
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  104 ( 1598),  selected  104 , name 2e6n_A
# Molecule2: number of CA atoms  135 ( 1110),  selected  135 , name T0429.pdb
# PARAMETERS: 2e6n_A.T0429.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E      22           -
LGA    -       -      T      23           -
LGA    -       -      E      24           -
LGA    -       -      L      25           -
LGA    -       -      L      27           -
LGA    -       -      Y      28           -
LGA    -       -      K      29           -
LGA    -       -      V      30           -
LGA    G     1_A      N      31           #
LGA    S     2_A      E      32           -
LGA    S     3_A      Y      33           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    G     8_A      -       -           -
LGA    T     9_A      -       -           -
LGA    Q    10_A      -       -           -
LGA    L    11_A      -       -           -
LGA    E    12_A      -       -           -
LGA    K    13_A      -       -           -
LGA    L    14_A      -       -           -
LGA    M    15_A      V      34           #
LGA    -       -      D      35           -
LGA    E    16_A      A      36          0.890
LGA    -       -      R      37           -
LGA    -       -      D      38           -
LGA    -       -      T      39           -
LGA    -       -      N      40           -
LGA    -       -      M      41           -
LGA    -       -      G      42           -
LGA    -       -      A      43           -
LGA    -       -      W      44           -
LGA    -       -      F      45           -
LGA    -       -      E      46           -
LGA    -       -      A      47           -
LGA    -       -      Q      48           -
LGA    -       -      V      49           -
LGA    -       -      V      50           -
LGA    -       -      R      51           -
LGA    -       -      V      52           -
LGA    -       -      T      53           -
LGA    -       -      R      54           -
LGA    -       -      E      73           -
LGA    -       -      D      74           -
LGA    -       -      V      75           -
LGA    -       -      I      76           -
LGA    -       -      Y      77           -
LGA    -       -      H      78           -
LGA    -       -      V      79           -
LGA    -       -      K      80           -
LGA    -       -      Y      81           -
LGA    -       -      D      82           -
LGA    -       -      D      83           -
LGA    -       -      Y      84           -
LGA    -       -      P      85           -
LGA    -       -      E      86           -
LGA    -       -      N      87           -
LGA    -       -      G      88           -
LGA    -       -      V      89           -
LGA    -       -      V      90           -
LGA    -       -      Q      91           -
LGA    -       -      M      92           -
LGA    -       -      N      93           -
LGA    -       -      S      94           -
LGA    -       -      R      95           -
LGA    -       -      D      96           -
LGA    N    17_A      V      97          2.808
LGA    M    18_A      R      98          4.349
LGA    R    19_A      -       -           -
LGA    N    20_A      A      99           #
LGA    D    21_A      R     100          1.700
LGA    I    22_A      A     101          3.326
LGA    A    23_A      -       -           -
LGA    S    24_A      -       -           -
LGA    H    25_A      -       -           -
LGA    P    26_A      R     102          4.702
LGA    P    27_A      T     103          3.871
LGA    V    28_A      I     104          3.451
LGA    E    29_A      -       -           -
LGA    G    30_A      -       -           -
LGA    S    31_A      I     105          3.534
LGA    Y    32_A      K     106          3.418
LGA    -       -      W     107           -
LGA    -       -      Q     108           -
LGA    A    33_A      D     109          2.341
LGA    P    34_A      L     110          1.839
LGA    R    35_A      E     111          0.877
LGA    R    36_A      V     112          1.358
LGA    G    37_A      G     113          1.681
LGA    E    38_A      Q     114          1.693
LGA    F    39_A      V     115          1.528
LGA    C    40_A      V     116          1.199
LGA    I    41_A      M     117          1.235
LGA    A    42_A      L     118          1.392
LGA    K    43_A      N     119          1.231
LGA    F    44_A      Y     120          2.174
LGA    V    45_A      N     121          3.664
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    -       -      E     127           -
LGA    D    46_A      R     128          4.943
LGA    G    47_A      G     129          4.490
LGA    E    48_A      F     130          2.279
LGA    W    49_A      W     131          1.632
LGA    Y    50_A      Y     132          1.444
LGA    R    51_A      D     133          1.179
LGA    A    52_A      A     134          0.841
LGA    R    53_A      E     135          0.659
LGA    V    54_A      I     136          0.850
LGA    E    55_A      S     137          0.794
LGA    K    56_A      R     138          0.671
LGA    V    57_A      K     139          0.714
LGA    E    58_A      R     140          1.037
LGA    S    59_A      E     141          2.882
LGA    P    60_A      T     142           -
LGA    -       -      R     143           -
LGA    -       -      T     144           -
LGA    -       -      A     145           -
LGA    A    61_A      R     146          2.885
LGA    K    62_A      E     147          1.503
LGA    I    63_A      L     148          0.740
LGA    H    64_A      Y     149          0.727
LGA    V    65_A      A     150          0.460
LGA    F    66_A      N     151          0.562
LGA    Y    67_A      V     152          1.119
LGA    I    68_A      V     153          2.854
LGA    D    69_A      L     154          3.594
LGA    Y    70_A      D     156           #
LGA    -       -      D     157           -
LGA    G    71_A      S     158          1.412
LGA    N    72_A      L     159          1.172
LGA    R    73_A      N     160          3.502
LGA    -       -      D     161           -
LGA    E    74_A      C     162          1.654
LGA    V    75_A      R     163          1.496
LGA    L    76_A      I     164          1.455
LGA    -       -      I     165           -
LGA    P    77_A      F     166          4.578
LGA    S    78_A      V     167          2.931
LGA    T    79_A      D     168          1.228
LGA    R    80_A      E     169          3.056
LGA    L    81_A      V     170          1.652
LGA    G    82_A      F     171          1.831
LGA    T    83_A      K     172          1.114
LGA    L    84_A      I     173          1.657
LGA    S    85_A      E     174          1.548
LGA    P    86_A      R     175          1.598
LGA    A    87_A      P     176          4.203
LGA    F    88_A      -       -           -
LGA    S    89_A      -       -           -
LGA    T    90_A      -       -           -
LGA    R    91_A      -       -           -
LGA    V    92_A      -       -           -
LGA    L    93_A      -       -           -
LGA    P    94_A      -       -           -
LGA    A    95_A      -       -           -
LGA    Q    96_A      -       -           -
LGA    A    97_A      -       -           -
LGA    T    98_A      -       -           -
LGA    E    99_A      -       -           -
LGA    Y   100_A      -       -           -
LGA    A   101_A      -       -           -
LGA    F   102_A      -       -           -
LGA    A   103_A      -       -           -
LGA    F   104_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  104  135    5.0     63    2.38     7.94     37.125     2.537

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.792323 * X  +   0.211042 * Y  +  -0.572438 * Z  +  29.046637
  Y_new =  -0.232869 * X  +  -0.971843 * Y  +  -0.035972 * Z  + -18.431664
  Z_new =  -0.563911 * X  +   0.104802 * Y  +   0.819159 * Z  +  -3.651700 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.127247   -3.014346  [ DEG:     7.2907   -172.7093 ]
  Theta =   0.599114    2.542479  [ DEG:    34.3267    145.6733 ]
  Phi   =  -2.855736    0.285857  [ DEG:  -163.6216     16.3784 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2e6n_A                                        
REMARK     2: T0429.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2e6n_A.T0429.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  104  135   5.0   63   2.38    7.94  37.125
REMARK  ---------------------------------------------------------- 
MOLECULE 2e6n_A
HEADER    TRANSCRIPTION                           27-DEC-06   2E6N              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF STAPHYLOCOCCAL              
TITLE    2 NUCLEASE DOMAIN-CONTAINING PROTEIN 1                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: STAPHYLOCOCCAL NUCLEASE DOMAIN-CONTAINING                  
COMPND   3 PROTEIN 1;                                                           
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   6 SYNONYM: P100 CO-ACTIVATOR, 100 KDA COACTIVATOR, EBNA2               
COMPND   7 COACTIVATOR P100;                                                    
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SND1;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060731-01;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, YUDOR DOMAIN, STAPHYLOCOCCAL NUCLEASE DOMAIN-                    
KEYWDS   2 CONTAINING PROTEIN 1, P100 CO-ACTIVATOR, 100 KDA                     
KEYWDS   3 COACTIVATOR, EBNA2 COACTIVATOR P100, STRUCTURAL GENOMICS,            
KEYWDS   4 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   5 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   6 INITIATIVE, RSGI                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,                   
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   03-JUL-07 2E6N    0                                                
JRNL        AUTH   W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,          
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF                    
JRNL        TITL 2 STAPHYLOCOCCAL NUCLEASE DOMAIN-CONTAINING PROTEIN 1          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2E6N A    8   104  UNP    Q7KZF4   SND1_HUMAN     704    800             
SEQRES   1 A  104  GLY SER SER GLY SER SER GLY GLY THR GLN LEU GLU LYS          
SEQRES   2 A  104  LEU MET GLU ASN MET ARG ASN ASP ILE ALA SER HIS PRO          
SEQRES   3 A  104  PRO VAL GLU GLY SER TYR ALA PRO ARG ARG GLY GLU PHE          
SEQRES   4 A  104  CYS ILE ALA LYS PHE VAL ASP GLY GLU TRP TYR ARG ALA          
SEQRES   5 A  104  ARG VAL GLU LYS VAL GLU SER PRO ALA LYS ILE HIS VAL          
SEQRES   6 A  104  PHE TYR ILE ASP TYR GLY ASN ARG GLU VAL LEU PRO SER          
SEQRES   7 A  104  THR ARG LEU GLY THR LEU SER PRO ALA PHE SER THR ARG          
SEQRES   8 A  104  VAL LEU PRO ALA GLN ALA THR GLU TYR ALA PHE ALA PHE          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      36.116   1.105  11.126  1.00  0.00           N  
ATOM      2  CA  GLY A   1      34.822   1.693  11.417  1.00  0.00           C  
ATOM      3  C   GLY A   1      34.620   3.025  10.722  1.00  0.00           C  
ATOM      4  O   GLY A   1      35.579   3.641  10.257  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      34.048   1.011  11.097  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      34.737   1.841  12.484  1.00  0.00           H  
ATOM      7  H1  GLY A   1      36.928   1.498  11.512  1.00  0.00           H  
ATOM      8  N   SER A   2      33.369   3.470  10.650  1.00  0.00           N  
ATOM      9  CA  SER A   2      33.045   4.735  10.001  1.00  0.00           C  
ATOM     10  C   SER A   2      32.119   5.573  10.878  1.00  0.00           C  
ATOM     11  O   SER A   2      31.114   5.080  11.388  1.00  0.00           O  
ATOM     12  CB  SER A   2      32.387   4.482   8.643  1.00  0.00           C  
ATOM     13  OG  SER A   2      31.213   3.701   8.782  1.00  0.00           O  
ATOM     14  H   SER A   2      32.648   2.933  11.039  1.00  0.00           H  
ATOM     15  HA  SER A   2      33.967   5.276   9.850  1.00  0.00           H  
ATOM     16  HB2 SER A   2      32.125   5.427   8.192  1.00  0.00           H  
ATOM     17  HB3 SER A   2      33.082   3.957   8.003  1.00  0.00           H  
ATOM     18  HG  SER A   2      31.449   2.816   9.069  1.00  0.00           H  
ATOM     19  N   SER A   3      32.468   6.845  11.050  1.00  0.00           N  
ATOM     20  CA  SER A   3      31.672   7.752  11.868  1.00  0.00           C  
ATOM     21  C   SER A   3      31.408   9.060  11.129  1.00  0.00           C  
ATOM     22  O   SER A   3      32.337   9.731  10.680  1.00  0.00           O  
ATOM     23  CB  SER A   3      32.384   8.035  13.193  1.00  0.00           C  
ATOM     24  OG  SER A   3      31.494   8.604  14.138  1.00  0.00           O  
ATOM     25  H   SER A   3      33.282   7.180  10.617  1.00  0.00           H  
ATOM     26  HA  SER A   3      30.727   7.271  12.073  1.00  0.00           H  
ATOM     27  HB2 SER A   3      32.774   7.112  13.593  1.00  0.00           H  
ATOM     28  HB3 SER A   3      33.197   8.725  13.020  1.00  0.00           H  
ATOM     29  HG  SER A   3      31.973   9.220  14.697  1.00  0.00           H  
ATOM     30  N   GLY A   4      30.134   9.417  11.007  1.00  0.00           N  
ATOM     31  CA  GLY A   4      29.769  10.644  10.322  1.00  0.00           C  
ATOM     32  C   GLY A   4      29.425  10.413   8.864  1.00  0.00           C  
ATOM     33  O   GLY A   4      30.261   9.951   8.088  1.00  0.00           O  
ATOM     34  H   GLY A   4      29.435   8.843  11.386  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      28.914  11.080  10.818  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      30.598  11.334  10.379  1.00  0.00           H  
ATOM     37  N   SER A   5      28.191  10.734   8.491  1.00  0.00           N  
ATOM     38  CA  SER A   5      27.737  10.554   7.116  1.00  0.00           C  
ATOM     39  C   SER A   5      28.075   9.154   6.611  1.00  0.00           C  
ATOM     40  O   SER A   5      28.505   8.981   5.471  1.00  0.00           O  
ATOM     41  CB  SER A   5      28.373  11.605   6.205  1.00  0.00           C  
ATOM     42  OG  SER A   5      27.644  12.819   6.242  1.00  0.00           O  
ATOM     43  H   SER A   5      27.569  11.097   9.156  1.00  0.00           H  
ATOM     44  HA  SER A   5      26.664  10.679   7.103  1.00  0.00           H  
ATOM     45  HB2 SER A   5      29.384  11.796   6.530  1.00  0.00           H  
ATOM     46  HB3 SER A   5      28.385  11.236   5.190  1.00  0.00           H  
ATOM     47  HG  SER A   5      28.187  13.507   6.633  1.00  0.00           H  
ATOM     48  N   SER A   6      27.877   8.159   7.470  1.00  0.00           N  
ATOM     49  CA  SER A   6      28.164   6.774   7.114  1.00  0.00           C  
ATOM     50  C   SER A   6      26.953   6.120   6.455  1.00  0.00           C  
ATOM     51  O   SER A   6      25.911   6.750   6.284  1.00  0.00           O  
ATOM     52  CB  SER A   6      28.574   5.980   8.355  1.00  0.00           C  
ATOM     53  OG  SER A   6      29.851   6.384   8.821  1.00  0.00           O  
ATOM     54  H   SER A   6      27.532   8.360   8.364  1.00  0.00           H  
ATOM     55  HA  SER A   6      28.984   6.776   6.411  1.00  0.00           H  
ATOM     56  HB2 SER A   6      27.851   6.143   9.139  1.00  0.00           H  
ATOM     57  HB3 SER A   6      28.609   4.927   8.111  1.00  0.00           H  
ATOM     58  HG  SER A   6      30.114   5.827   9.557  1.00  0.00           H  
ATOM     59  N   GLY A   7      27.101   4.851   6.086  1.00  0.00           N  
ATOM     60  CA  GLY A   7      26.013   4.131   5.451  1.00  0.00           C  
ATOM     61  C   GLY A   7      26.497   3.187   4.369  1.00  0.00           C  
ATOM     62  O   GLY A   7      27.302   3.565   3.519  1.00  0.00           O  
ATOM     63  H   GLY A   7      27.956   4.399   6.248  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      25.485   3.562   6.202  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      25.333   4.846   5.010  1.00  0.00           H  
ATOM     66  N   GLY A   8      26.005   1.951   4.400  1.00  0.00           N  
ATOM     67  CA  GLY A   8      26.406   0.969   3.409  1.00  0.00           C  
ATOM     68  C   GLY A   8      25.236   0.154   2.896  1.00  0.00           C  
ATOM     69  O   GLY A   8      24.078   0.540   3.063  1.00  0.00           O  
ATOM     70  H   GLY A   8      25.366   1.706   5.101  1.00  0.00           H  
ATOM     71  HA2 GLY A   8      26.868   1.479   2.578  1.00  0.00           H  
ATOM     72  HA3 GLY A   8      27.128   0.300   3.854  1.00  0.00           H  
ATOM     73  N   THR A   9      25.536  -0.980   2.269  1.00  0.00           N  
ATOM     74  CA  THR A   9      24.500  -1.851   1.727  1.00  0.00           C  
ATOM     75  C   THR A   9      24.230  -3.028   2.657  1.00  0.00           C  
ATOM     76  O   THR A   9      25.141  -3.534   3.313  1.00  0.00           O  
ATOM     77  CB  THR A   9      24.889  -2.387   0.337  1.00  0.00           C  
ATOM     78  OG1 THR A   9      25.467  -1.340  -0.449  1.00  0.00           O  
ATOM     79  CG2 THR A   9      23.674  -2.956  -0.382  1.00  0.00           C  
ATOM     80  H   THR A   9      26.476  -1.234   2.168  1.00  0.00           H  
ATOM     81  HA  THR A   9      23.595  -1.270   1.625  1.00  0.00           H  
ATOM     82  HB  THR A   9      25.617  -3.177   0.463  1.00  0.00           H  
ATOM     83  HG1 THR A   9      26.425  -1.408  -0.417  1.00  0.00           H  
ATOM     84 HG21 THR A   9      23.878  -3.973  -0.685  1.00  0.00           H  
ATOM     85 HG22 THR A   9      23.460  -2.358  -1.255  1.00  0.00           H  
ATOM     86 HG23 THR A   9      22.824  -2.942   0.282  1.00  0.00           H  
ATOM     87  N   GLN A  10      22.975  -3.460   2.708  1.00  0.00           N  
ATOM     88  CA  GLN A  10      22.586  -4.579   3.558  1.00  0.00           C  
ATOM     89  C   GLN A  10      23.695  -5.624   3.623  1.00  0.00           C  
ATOM     90  O   GLN A  10      24.248  -5.893   4.690  1.00  0.00           O  
ATOM     91  CB  GLN A  10      21.296  -5.218   3.040  1.00  0.00           C  
ATOM     92  CG  GLN A  10      20.035  -4.508   3.506  1.00  0.00           C  
ATOM     93  CD  GLN A  10      19.666  -3.333   2.622  1.00  0.00           C  
ATOM     94  OE1 GLN A  10      20.439  -2.385   2.474  1.00  0.00           O  
ATOM     95  NE2 GLN A  10      18.480  -3.389   2.028  1.00  0.00           N  
ATOM     96  H   GLN A  10      22.293  -3.017   2.161  1.00  0.00           H  
ATOM     97  HA  GLN A  10      22.412  -4.195   4.552  1.00  0.00           H  
ATOM     98  HB2 GLN A  10      21.312  -5.206   1.960  1.00  0.00           H  
ATOM     99  HB3 GLN A  10      21.254  -6.242   3.381  1.00  0.00           H  
ATOM    100  HG2 GLN A  10      19.218  -5.213   3.501  1.00  0.00           H  
ATOM    101  HG3 GLN A  10      20.193  -4.147   4.512  1.00  0.00           H  
ATOM    102 HE21 GLN A  10      17.917  -4.173   2.193  1.00  0.00           H  
ATOM    103 HE22 GLN A  10      18.215  -2.642   1.452  1.00  0.00           H  
ATOM    104  N   LEU A  11      24.014  -6.213   2.475  1.00  0.00           N  
ATOM    105  CA  LEU A  11      25.058  -7.229   2.400  1.00  0.00           C  
ATOM    106  C   LEU A  11      26.374  -6.701   2.961  1.00  0.00           C  
ATOM    107  O   LEU A  11      27.047  -7.381   3.735  1.00  0.00           O  
ATOM    108  CB  LEU A  11      25.252  -7.683   0.953  1.00  0.00           C  
ATOM    109  CG  LEU A  11      26.094  -8.944   0.752  1.00  0.00           C  
ATOM    110  CD1 LEU A  11      25.339 -10.172   1.237  1.00  0.00           C  
ATOM    111  CD2 LEU A  11      26.482  -9.099  -0.711  1.00  0.00           C  
ATOM    112  H   LEU A  11      23.538  -5.956   1.658  1.00  0.00           H  
ATOM    113  HA  LEU A  11      24.739  -8.074   2.994  1.00  0.00           H  
ATOM    114  HB2 LEU A  11      24.277  -7.867   0.530  1.00  0.00           H  
ATOM    115  HB3 LEU A  11      25.729  -6.876   0.415  1.00  0.00           H  
ATOM    116  HG  LEU A  11      27.002  -8.859   1.333  1.00  0.00           H  
ATOM    117 HD11 LEU A  11      25.320 -10.179   2.317  1.00  0.00           H  
ATOM    118 HD12 LEU A  11      25.835 -11.063   0.880  1.00  0.00           H  
ATOM    119 HD13 LEU A  11      24.328 -10.147   0.859  1.00  0.00           H  
ATOM    120 HD21 LEU A  11      26.729  -8.131  -1.121  1.00  0.00           H  
ATOM    121 HD22 LEU A  11      25.654  -9.522  -1.261  1.00  0.00           H  
ATOM    122 HD23 LEU A  11      27.338  -9.752  -0.789  1.00  0.00           H  
ATOM    123  N   GLU A  12      26.734  -5.484   2.566  1.00  0.00           N  
ATOM    124  CA  GLU A  12      27.969  -4.865   3.032  1.00  0.00           C  
ATOM    125  C   GLU A  12      28.028  -4.847   4.556  1.00  0.00           C  
ATOM    126  O   GLU A  12      29.102  -4.961   5.149  1.00  0.00           O  
ATOM    127  CB  GLU A  12      28.086  -3.439   2.491  1.00  0.00           C  
ATOM    128  CG  GLU A  12      28.808  -3.352   1.155  1.00  0.00           C  
ATOM    129  CD  GLU A  12      30.150  -4.055   1.171  1.00  0.00           C  
ATOM    130  OE1 GLU A  12      31.056  -3.587   1.891  1.00  0.00           O  
ATOM    131  OE2 GLU A  12      30.295  -5.074   0.464  1.00  0.00           O  
ATOM    132  H   GLU A  12      26.154  -4.991   1.948  1.00  0.00           H  
ATOM    133  HA  GLU A  12      28.794  -5.450   2.658  1.00  0.00           H  
ATOM    134  HB2 GLU A  12      27.093  -3.029   2.367  1.00  0.00           H  
ATOM    135  HB3 GLU A  12      28.626  -2.837   3.207  1.00  0.00           H  
ATOM    136  HG2 GLU A  12      28.189  -3.807   0.397  1.00  0.00           H  
ATOM    137  HG3 GLU A  12      28.965  -2.310   0.913  1.00  0.00           H  
ATOM    138  N   LYS A  13      26.868  -4.703   5.186  1.00  0.00           N  
ATOM    139  CA  LYS A  13      26.785  -4.671   6.642  1.00  0.00           C  
ATOM    140  C   LYS A  13      27.187  -6.016   7.239  1.00  0.00           C  
ATOM    141  O   LYS A  13      28.186  -6.116   7.953  1.00  0.00           O  
ATOM    142  CB  LYS A  13      25.366  -4.308   7.085  1.00  0.00           C  
ATOM    143  CG  LYS A  13      24.702  -3.266   6.203  1.00  0.00           C  
ATOM    144  CD  LYS A  13      23.582  -2.546   6.936  1.00  0.00           C  
ATOM    145  CE  LYS A  13      22.715  -3.519   7.721  1.00  0.00           C  
ATOM    146  NZ  LYS A  13      21.557  -2.836   8.362  1.00  0.00           N  
ATOM    147  H   LYS A  13      26.045  -4.616   4.659  1.00  0.00           H  
ATOM    148  HA  LYS A  13      27.468  -3.914   6.997  1.00  0.00           H  
ATOM    149  HB2 LYS A  13      24.758  -5.200   7.073  1.00  0.00           H  
ATOM    150  HB3 LYS A  13      25.404  -3.923   8.094  1.00  0.00           H  
ATOM    151  HG2 LYS A  13      25.441  -2.540   5.898  1.00  0.00           H  
ATOM    152  HG3 LYS A  13      24.292  -3.754   5.330  1.00  0.00           H  
ATOM    153  HD2 LYS A  13      24.013  -1.832   7.621  1.00  0.00           H  
ATOM    154  HD3 LYS A  13      22.965  -2.029   6.215  1.00  0.00           H  
ATOM    155  HE2 LYS A  13      22.347  -4.278   7.047  1.00  0.00           H  
ATOM    156  HE3 LYS A  13      23.319  -3.981   8.488  1.00  0.00           H  
ATOM    157  HZ1 LYS A  13      21.361  -3.262   9.291  1.00  0.00           H  
ATOM    158  HZ2 LYS A  13      20.710  -2.931   7.764  1.00  0.00           H  
ATOM    159  HZ3 LYS A  13      21.764  -1.826   8.493  1.00  0.00           H  
ATOM    160  N   LEU A  14      26.405  -7.047   6.942  1.00  0.00           N  
ATOM    161  CA  LEU A  14      26.680  -8.388   7.448  1.00  0.00           C  
ATOM    162  C   LEU A  14      28.091  -8.832   7.073  1.00  0.00           C  
ATOM    163  O   LEU A  14      28.880  -9.217   7.935  1.00  0.00           O  
ATOM    164  CB  LEU A  14      25.657  -9.383   6.898  1.00  0.00           C  
ATOM    165  CG  LEU A  14      25.739 -10.805   7.452  1.00  0.00           C  
ATOM    166  CD1 LEU A  14      24.862 -10.948   8.686  1.00  0.00           C  
ATOM    167  CD2 LEU A  14      25.334 -11.816   6.389  1.00  0.00           C  
ATOM    168  H   LEU A  14      25.623  -6.905   6.368  1.00  0.00           H  
ATOM    169  HA  LEU A  14      26.599  -8.358   8.525  1.00  0.00           H  
ATOM    170  HB2 LEU A  14      24.672  -8.999   7.117  1.00  0.00           H  
ATOM    171  HB3 LEU A  14      25.790  -9.435   5.827  1.00  0.00           H  
ATOM    172  HG  LEU A  14      26.760 -11.013   7.743  1.00  0.00           H  
ATOM    173 HD11 LEU A  14      24.823 -11.985   8.982  1.00  0.00           H  
ATOM    174 HD12 LEU A  14      23.865 -10.599   8.463  1.00  0.00           H  
ATOM    175 HD13 LEU A  14      25.277 -10.359   9.493  1.00  0.00           H  
ATOM    176 HD21 LEU A  14      25.294 -11.328   5.426  1.00  0.00           H  
ATOM    177 HD22 LEU A  14      24.362 -12.220   6.629  1.00  0.00           H  
ATOM    178 HD23 LEU A  14      26.059 -12.615   6.358  1.00  0.00           H  
ATOM    179  N   MET A  15      28.401  -8.773   5.782  1.00  0.00           N  
ATOM    180  CA  MET A  15      29.717  -9.167   5.294  1.00  0.00           C  
ATOM    181  C   MET A  15      30.817  -8.393   6.014  1.00  0.00           C  
ATOM    182  O   MET A  15      31.900  -8.923   6.261  1.00  0.00           O  
ATOM    183  CB  MET A  15      29.816  -8.932   3.786  1.00  0.00           C  
ATOM    184  CG  MET A  15      29.010  -9.924   2.962  1.00  0.00           C  
ATOM    185  SD  MET A  15      29.583 -11.621   3.163  1.00  0.00           S  
ATOM    186  CE  MET A  15      28.041 -12.458   3.526  1.00  0.00           C  
ATOM    187  H   MET A  15      27.728  -8.457   5.142  1.00  0.00           H  
ATOM    188  HA  MET A  15      29.843 -10.220   5.495  1.00  0.00           H  
ATOM    189  HB2 MET A  15      29.459  -7.938   3.564  1.00  0.00           H  
ATOM    190  HB3 MET A  15      30.852  -9.009   3.488  1.00  0.00           H  
ATOM    191  HG2 MET A  15      27.976  -9.869   3.269  1.00  0.00           H  
ATOM    192  HG3 MET A  15      29.089  -9.652   1.920  1.00  0.00           H  
ATOM    193  HE1 MET A  15      28.241 -13.339   4.118  1.00  0.00           H  
ATOM    194  HE2 MET A  15      27.393 -11.793   4.077  1.00  0.00           H  
ATOM    195  HE3 MET A  15      27.562 -12.747   2.602  1.00  0.00           H  
ATOM    196  N   GLU A  16      30.531  -7.138   6.348  1.00  0.00           N  
ATOM    197  CA  GLU A  16      31.498  -6.293   7.038  1.00  0.00           C  
ATOM    198  C   GLU A  16      31.803  -6.840   8.430  1.00  0.00           C  
ATOM    199  O   GLU A  16      32.936  -6.767   8.903  1.00  0.00           O  
ATOM    200  CB  GLU A  16      30.972  -4.861   7.145  1.00  0.00           C  
ATOM    201  CG  GLU A  16      31.792  -3.979   8.072  1.00  0.00           C  
ATOM    202  CD  GLU A  16      33.028  -3.415   7.398  1.00  0.00           C  
ATOM    203  OE1 GLU A  16      34.015  -4.163   7.245  1.00  0.00           O  
ATOM    204  OE2 GLU A  16      33.007  -2.224   7.022  1.00  0.00           O  
ATOM    205  H   GLU A  16      29.651  -6.772   6.123  1.00  0.00           H  
ATOM    206  HA  GLU A  16      32.409  -6.290   6.459  1.00  0.00           H  
ATOM    207  HB2 GLU A  16      30.974  -4.415   6.161  1.00  0.00           H  
ATOM    208  HB3 GLU A  16      29.958  -4.890   7.516  1.00  0.00           H  
ATOM    209  HG2 GLU A  16      31.176  -3.157   8.404  1.00  0.00           H  
ATOM    210  HG3 GLU A  16      32.101  -4.563   8.925  1.00  0.00           H  
ATOM    211  N   ASN A  17      30.782  -7.389   9.080  1.00  0.00           N  
ATOM    212  CA  ASN A  17      30.939  -7.948  10.418  1.00  0.00           C  
ATOM    213  C   ASN A  17      31.667  -9.287  10.366  1.00  0.00           C  
ATOM    214  O   ASN A  17      32.501  -9.586  11.220  1.00  0.00           O  
ATOM    215  CB  ASN A  17      29.573  -8.121  11.084  1.00  0.00           C  
ATOM    216  CG  ASN A  17      28.943  -6.795  11.467  1.00  0.00           C  
ATOM    217  OD1 ASN A  17      29.275  -6.212  12.498  1.00  0.00           O  
ATOM    218  ND2 ASN A  17      28.028  -6.313  10.633  1.00  0.00           N  
ATOM    219  H   ASN A  17      29.901  -7.419   8.650  1.00  0.00           H  
ATOM    220  HA  ASN A  17      31.528  -7.254  10.999  1.00  0.00           H  
ATOM    221  HB2 ASN A  17      28.908  -8.630  10.402  1.00  0.00           H  
ATOM    222  HB3 ASN A  17      29.688  -8.716  11.979  1.00  0.00           H  
ATOM    223 HD21 ASN A  17      27.814  -6.833   9.830  1.00  0.00           H  
ATOM    224 HD22 ASN A  17      27.605  -5.458  10.855  1.00  0.00           H  
ATOM    225  N   MET A  18      31.343 -10.091   9.358  1.00  0.00           N  
ATOM    226  CA  MET A  18      31.967 -11.399   9.193  1.00  0.00           C  
ATOM    227  C   MET A  18      33.421 -11.256   8.754  1.00  0.00           C  
ATOM    228  O   MET A  18      34.324 -11.816   9.375  1.00  0.00           O  
ATOM    229  CB  MET A  18      31.193 -12.232   8.171  1.00  0.00           C  
ATOM    230  CG  MET A  18      31.852 -13.564   7.846  1.00  0.00           C  
ATOM    231  SD  MET A  18      31.032 -14.435   6.498  1.00  0.00           S  
ATOM    232  CE  MET A  18      31.687 -13.557   5.080  1.00  0.00           C  
ATOM    233  H   MET A  18      30.670  -9.798   8.708  1.00  0.00           H  
ATOM    234  HA  MET A  18      31.939 -11.901  10.149  1.00  0.00           H  
ATOM    235  HB2 MET A  18      30.205 -12.429   8.558  1.00  0.00           H  
ATOM    236  HB3 MET A  18      31.106 -11.667   7.255  1.00  0.00           H  
ATOM    237  HG2 MET A  18      32.879 -13.383   7.568  1.00  0.00           H  
ATOM    238  HG3 MET A  18      31.824 -14.185   8.729  1.00  0.00           H  
ATOM    239  HE1 MET A  18      30.945 -13.536   4.296  1.00  0.00           H  
ATOM    240  HE2 MET A  18      31.936 -12.546   5.367  1.00  0.00           H  
ATOM    241  HE3 MET A  18      32.574 -14.060   4.724  1.00  0.00           H  
ATOM    242  N   ARG A  19      33.639 -10.504   7.681  1.00  0.00           N  
ATOM    243  CA  ARG A  19      34.983 -10.290   7.159  1.00  0.00           C  
ATOM    244  C   ARG A  19      35.964  -9.987   8.288  1.00  0.00           C  
ATOM    245  O   ARG A  19      37.147 -10.310   8.199  1.00  0.00           O  
ATOM    246  CB  ARG A  19      34.984  -9.141   6.147  1.00  0.00           C  
ATOM    247  CG  ARG A  19      34.399  -9.519   4.796  1.00  0.00           C  
ATOM    248  CD  ARG A  19      34.362  -8.327   3.852  1.00  0.00           C  
ATOM    249  NE  ARG A  19      33.243  -7.436   4.140  1.00  0.00           N  
ATOM    250  CZ  ARG A  19      32.835  -6.479   3.314  1.00  0.00           C  
ATOM    251  NH1 ARG A  19      33.451  -6.291   2.156  1.00  0.00           N  
ATOM    252  NH2 ARG A  19      31.807  -5.707   3.646  1.00  0.00           N  
ATOM    253  H   ARG A  19      32.878 -10.083   7.228  1.00  0.00           H  
ATOM    254  HA  ARG A  19      35.294 -11.196   6.660  1.00  0.00           H  
ATOM    255  HB2 ARG A  19      34.404  -8.322   6.549  1.00  0.00           H  
ATOM    256  HB3 ARG A  19      36.000  -8.811   5.996  1.00  0.00           H  
ATOM    257  HG2 ARG A  19      35.009 -10.294   4.355  1.00  0.00           H  
ATOM    258  HG3 ARG A  19      33.394  -9.885   4.939  1.00  0.00           H  
ATOM    259  HD2 ARG A  19      35.285  -7.775   3.954  1.00  0.00           H  
ATOM    260  HD3 ARG A  19      34.271  -8.691   2.839  1.00  0.00           H  
ATOM    261  HE  ARG A  19      32.773  -7.557   4.990  1.00  0.00           H  
ATOM    262 HH11 ARG A  19      34.225  -6.870   1.902  1.00  0.00           H  
ATOM    263 HH12 ARG A  19      33.141  -5.570   1.535  1.00  0.00           H  
ATOM    264 HH21 ARG A  19      31.340  -5.846   4.518  1.00  0.00           H  
ATOM    265 HH22 ARG A  19      31.501  -4.987   3.024  1.00  0.00           H  
ATOM    266  N   ASN A  20      35.462  -9.365   9.349  1.00  0.00           N  
ATOM    267  CA  ASN A  20      36.293  -9.018  10.496  1.00  0.00           C  
ATOM    268  C   ASN A  20      36.776 -10.272  11.217  1.00  0.00           C  
ATOM    269  O   ASN A  20      37.954 -10.624  11.152  1.00  0.00           O  
ATOM    270  CB  ASN A  20      35.517  -8.126  11.465  1.00  0.00           C  
ATOM    271  CG  ASN A  20      35.528  -6.668  11.045  1.00  0.00           C  
ATOM    272  OD1 ASN A  20      36.450  -6.213  10.369  1.00  0.00           O  
ATOM    273  ND2 ASN A  20      34.499  -5.930  11.445  1.00  0.00           N  
ATOM    274  H   ASN A  20      34.510  -9.133   9.362  1.00  0.00           H  
ATOM    275  HA  ASN A  20      37.153  -8.474  10.130  1.00  0.00           H  
ATOM    276  HB2 ASN A  20      34.489  -8.460  11.508  1.00  0.00           H  
ATOM    277  HB3 ASN A  20      35.957  -8.202  12.448  1.00  0.00           H  
ATOM    278 HD21 ASN A  20      33.800  -6.360  11.982  1.00  0.00           H  
ATOM    279 HD22 ASN A  20      34.480  -4.984  11.188  1.00  0.00           H  
ATOM    280  N   ASP A  21      35.858 -10.943  11.904  1.00  0.00           N  
ATOM    281  CA  ASP A  21      36.188 -12.160  12.637  1.00  0.00           C  
ATOM    282  C   ASP A  21      36.738 -13.229  11.696  1.00  0.00           C  
ATOM    283  O   ASP A  21      37.429 -14.151  12.126  1.00  0.00           O  
ATOM    284  CB  ASP A  21      34.954 -12.693  13.367  1.00  0.00           C  
ATOM    285  CG  ASP A  21      35.307 -13.400  14.661  1.00  0.00           C  
ATOM    286  OD1 ASP A  21      35.494 -12.707  15.684  1.00  0.00           O  
ATOM    287  OD2 ASP A  21      35.395 -14.645  14.651  1.00  0.00           O  
ATOM    288  H   ASP A  21      34.936 -10.613  11.917  1.00  0.00           H  
ATOM    289  HA  ASP A  21      36.947 -11.913  13.364  1.00  0.00           H  
ATOM    290  HB2 ASP A  21      34.297 -11.867  13.597  1.00  0.00           H  
ATOM    291  HB3 ASP A  21      34.437 -13.391  12.725  1.00  0.00           H  
ATOM    292  N   ILE A  22      36.425 -13.096  10.411  1.00  0.00           N  
ATOM    293  CA  ILE A  22      36.888 -14.051   9.411  1.00  0.00           C  
ATOM    294  C   ILE A  22      38.313 -13.735   8.969  1.00  0.00           C  
ATOM    295  O   ILE A  22      39.105 -14.639   8.702  1.00  0.00           O  
ATOM    296  CB  ILE A  22      35.969 -14.059   8.175  1.00  0.00           C  
ATOM    297  CG1 ILE A  22      34.823 -15.054   8.371  1.00  0.00           C  
ATOM    298  CG2 ILE A  22      36.766 -14.402   6.925  1.00  0.00           C  
ATOM    299  CD1 ILE A  22      35.274 -16.498   8.400  1.00  0.00           C  
ATOM    300  H   ILE A  22      35.871 -12.340  10.130  1.00  0.00           H  
ATOM    301  HA  ILE A  22      36.869 -15.035   9.856  1.00  0.00           H  
ATOM    302  HB  ILE A  22      35.559 -13.069   8.051  1.00  0.00           H  
ATOM    303 HG12 ILE A  22      34.328 -14.843   9.306  1.00  0.00           H  
ATOM    304 HG13 ILE A  22      34.117 -14.942   7.561  1.00  0.00           H  
ATOM    305 HG21 ILE A  22      37.266 -15.349   7.066  1.00  0.00           H  
ATOM    306 HG22 ILE A  22      36.098 -14.471   6.080  1.00  0.00           H  
ATOM    307 HG23 ILE A  22      37.500 -13.631   6.743  1.00  0.00           H  
ATOM    308 HD11 ILE A  22      35.138 -16.937   7.424  1.00  0.00           H  
ATOM    309 HD12 ILE A  22      36.317 -16.544   8.675  1.00  0.00           H  
ATOM    310 HD13 ILE A  22      34.686 -17.043   9.125  1.00  0.00           H  
ATOM    311  N   ALA A  23      38.633 -12.447   8.895  1.00  0.00           N  
ATOM    312  CA  ALA A  23      39.963 -12.014   8.490  1.00  0.00           C  
ATOM    313  C   ALA A  23      40.937 -12.058   9.663  1.00  0.00           C  
ATOM    314  O   ALA A  23      42.152 -12.112   9.472  1.00  0.00           O  
ATOM    315  CB  ALA A  23      39.906 -10.610   7.905  1.00  0.00           C  
ATOM    316  H   ALA A  23      37.958 -11.774   9.121  1.00  0.00           H  
ATOM    317  HA  ALA A  23      40.313 -12.684   7.719  1.00  0.00           H  
ATOM    318  HB1 ALA A  23      39.490  -9.933   8.636  1.00  0.00           H  
ATOM    319  HB2 ALA A  23      40.902 -10.289   7.641  1.00  0.00           H  
ATOM    320  HB3 ALA A  23      39.282 -10.614   7.023  1.00  0.00           H  
ATOM    321  N   SER A  24      40.396 -12.037  10.876  1.00  0.00           N  
ATOM    322  CA  SER A  24      41.217 -12.071  12.081  1.00  0.00           C  
ATOM    323  C   SER A  24      41.340 -13.496  12.614  1.00  0.00           C  
ATOM    324  O   SER A  24      42.367 -13.873  13.179  1.00  0.00           O  
ATOM    325  CB  SER A  24      40.621 -11.162  13.156  1.00  0.00           C  
ATOM    326  OG  SER A  24      41.624 -10.693  14.041  1.00  0.00           O  
ATOM    327  H   SER A  24      39.420 -11.994  10.964  1.00  0.00           H  
ATOM    328  HA  SER A  24      42.201 -11.711  11.821  1.00  0.00           H  
ATOM    329  HB2 SER A  24      40.149 -10.313  12.685  1.00  0.00           H  
ATOM    330  HB3 SER A  24      39.886 -11.714  13.724  1.00  0.00           H  
ATOM    331  HG  SER A  24      42.435 -10.536  13.552  1.00  0.00           H  
ATOM    332  N   HIS A  25      40.284 -14.283  12.432  1.00  0.00           N  
ATOM    333  CA  HIS A  25      40.273 -15.666  12.894  1.00  0.00           C  
ATOM    334  C   HIS A  25      39.804 -16.605  11.786  1.00  0.00           C  
ATOM    335  O   HIS A  25      38.869 -17.387  11.956  1.00  0.00           O  
ATOM    336  CB  HIS A  25      39.366 -15.810  14.117  1.00  0.00           C  
ATOM    337  CG  HIS A  25      40.063 -15.532  15.414  1.00  0.00           C  
ATOM    338  ND1 HIS A  25      40.525 -16.528  16.248  1.00  0.00           N  
ATOM    339  CD2 HIS A  25      40.376 -14.362  16.018  1.00  0.00           C  
ATOM    340  CE1 HIS A  25      41.091 -15.982  17.310  1.00  0.00           C  
ATOM    341  NE2 HIS A  25      41.014 -14.670  17.194  1.00  0.00           N  
ATOM    342  H   HIS A  25      39.495 -13.924  11.975  1.00  0.00           H  
ATOM    343  HA  HIS A  25      41.281 -15.931  13.171  1.00  0.00           H  
ATOM    344  HB2 HIS A  25      38.541 -15.118  14.029  1.00  0.00           H  
ATOM    345  HB3 HIS A  25      38.981 -16.818  14.156  1.00  0.00           H  
ATOM    346  HD1 HIS A  25      40.448 -17.491  16.086  1.00  0.00           H  
ATOM    347  HD2 HIS A  25      40.163 -13.370  15.645  1.00  0.00           H  
ATOM    348  HE1 HIS A  25      41.541 -16.518  18.132  1.00  0.00           H  
ATOM    349  N   PRO A  26      40.468 -16.527  10.623  1.00  0.00           N  
ATOM    350  CA  PRO A  26      40.137 -17.362   9.465  1.00  0.00           C  
ATOM    351  C   PRO A  26      39.985 -18.834   9.836  1.00  0.00           C  
ATOM    352  O   PRO A  26      40.646 -19.341  10.744  1.00  0.00           O  
ATOM    353  CB  PRO A  26      41.335 -17.167   8.533  1.00  0.00           C  
ATOM    354  CG  PRO A  26      41.883 -15.829   8.896  1.00  0.00           C  
ATOM    355  CD  PRO A  26      41.594 -15.618  10.350  1.00  0.00           C  
ATOM    356  HA  PRO A  26      39.238 -17.021   8.974  1.00  0.00           H  
ATOM    357  HB2 PRO A  26      42.059 -17.951   8.703  1.00  0.00           H  
ATOM    358  HB3 PRO A  26      41.004 -17.191   7.506  1.00  0.00           H  
ATOM    359  HG2 PRO A  26      42.950 -15.812   8.728  1.00  0.00           H  
ATOM    360  HG3 PRO A  26      41.397 -15.063   8.311  1.00  0.00           H  
ATOM    361  HD2 PRO A  26      42.456 -15.882  10.944  1.00  0.00           H  
ATOM    362  HD3 PRO A  26      41.312 -14.591  10.529  1.00  0.00           H  
ATOM    363  N   PRO A  27      39.097 -19.536   9.119  1.00  0.00           N  
ATOM    364  CA  PRO A  27      38.839 -20.960   9.354  1.00  0.00           C  
ATOM    365  C   PRO A  27      40.014 -21.839   8.940  1.00  0.00           C  
ATOM    366  O   PRO A  27      40.921 -21.390   8.238  1.00  0.00           O  
ATOM    367  CB  PRO A  27      37.620 -21.250   8.475  1.00  0.00           C  
ATOM    368  CG  PRO A  27      37.679 -20.226   7.394  1.00  0.00           C  
ATOM    369  CD  PRO A  27      38.275 -18.996   8.023  1.00  0.00           C  
ATOM    370  HA  PRO A  27      38.593 -21.154  10.388  1.00  0.00           H  
ATOM    371  HB2 PRO A  27      37.691 -22.252   8.075  1.00  0.00           H  
ATOM    372  HB3 PRO A  27      36.718 -21.154   9.061  1.00  0.00           H  
ATOM    373  HG2 PRO A  27      38.307 -20.577   6.590  1.00  0.00           H  
ATOM    374  HG3 PRO A  27      36.684 -20.017   7.032  1.00  0.00           H  
ATOM    375  HD2 PRO A  27      38.887 -18.466   7.308  1.00  0.00           H  
ATOM    376  HD3 PRO A  27      37.497 -18.353   8.406  1.00  0.00           H  
ATOM    377  N   VAL A  28      39.993 -23.093   9.379  1.00  0.00           N  
ATOM    378  CA  VAL A  28      41.058 -24.035   9.053  1.00  0.00           C  
ATOM    379  C   VAL A  28      40.837 -24.659   7.679  1.00  0.00           C  
ATOM    380  O   VAL A  28      39.837 -25.339   7.449  1.00  0.00           O  
ATOM    381  CB  VAL A  28      41.157 -25.157  10.104  1.00  0.00           C  
ATOM    382  CG1 VAL A  28      42.190 -26.192   9.686  1.00  0.00           C  
ATOM    383  CG2 VAL A  28      41.492 -24.577  11.470  1.00  0.00           C  
ATOM    384  H   VAL A  28      39.244 -23.392   9.935  1.00  0.00           H  
ATOM    385  HA  VAL A  28      41.992 -23.495   9.045  1.00  0.00           H  
ATOM    386  HB  VAL A  28      40.196 -25.646  10.170  1.00  0.00           H  
ATOM    387 HG11 VAL A  28      41.744 -27.175   9.710  1.00  0.00           H  
ATOM    388 HG12 VAL A  28      42.533 -25.974   8.685  1.00  0.00           H  
ATOM    389 HG13 VAL A  28      43.026 -26.160  10.368  1.00  0.00           H  
ATOM    390 HG21 VAL A  28      41.233 -23.530  11.489  1.00  0.00           H  
ATOM    391 HG22 VAL A  28      40.930 -25.101  12.231  1.00  0.00           H  
ATOM    392 HG23 VAL A  28      42.549 -24.692  11.660  1.00  0.00           H  
ATOM    393  N   GLU A  29      41.778 -24.423   6.770  1.00  0.00           N  
ATOM    394  CA  GLU A  29      41.685 -24.963   5.419  1.00  0.00           C  
ATOM    395  C   GLU A  29      41.682 -26.489   5.441  1.00  0.00           C  
ATOM    396  O   GLU A  29      42.681 -27.118   5.784  1.00  0.00           O  
ATOM    397  CB  GLU A  29      42.849 -24.458   4.563  1.00  0.00           C  
ATOM    398  CG  GLU A  29      44.165 -25.162   4.849  1.00  0.00           C  
ATOM    399  CD  GLU A  29      45.369 -24.321   4.471  1.00  0.00           C  
ATOM    400  OE1 GLU A  29      45.522 -23.217   5.034  1.00  0.00           O  
ATOM    401  OE2 GLU A  29      46.158 -24.767   3.612  1.00  0.00           O  
ATOM    402  H   GLU A  29      42.551 -23.874   7.014  1.00  0.00           H  
ATOM    403  HA  GLU A  29      40.757 -24.619   4.987  1.00  0.00           H  
ATOM    404  HB2 GLU A  29      42.604 -24.604   3.521  1.00  0.00           H  
ATOM    405  HB3 GLU A  29      42.982 -23.401   4.747  1.00  0.00           H  
ATOM    406  HG2 GLU A  29      44.218 -25.384   5.904  1.00  0.00           H  
ATOM    407  HG3 GLU A  29      44.196 -26.082   4.285  1.00  0.00           H  
ATOM    408  N   GLY A  30      40.548 -27.078   5.071  1.00  0.00           N  
ATOM    409  CA  GLY A  30      40.433 -28.524   5.056  1.00  0.00           C  
ATOM    410  C   GLY A  30      39.859 -29.074   6.347  1.00  0.00           C  
ATOM    411  O   GLY A  30      40.141 -30.210   6.725  1.00  0.00           O  
ATOM    412  H   GLY A  30      39.782 -26.524   4.808  1.00  0.00           H  
ATOM    413  HA2 GLY A  30      39.793 -28.815   4.237  1.00  0.00           H  
ATOM    414  HA3 GLY A  30      41.414 -28.949   4.903  1.00  0.00           H  
ATOM    415  N   SER A  31      39.053 -28.265   7.027  1.00  0.00           N  
ATOM    416  CA  SER A  31      38.441 -28.674   8.286  1.00  0.00           C  
ATOM    417  C   SER A  31      36.949 -28.933   8.106  1.00  0.00           C  
ATOM    418  O   SER A  31      36.427 -29.954   8.554  1.00  0.00           O  
ATOM    419  CB  SER A  31      38.660 -27.603   9.356  1.00  0.00           C  
ATOM    420  OG  SER A  31      38.039 -27.966  10.575  1.00  0.00           O  
ATOM    421  H   SER A  31      38.867 -27.369   6.673  1.00  0.00           H  
ATOM    422  HA  SER A  31      38.919 -29.590   8.603  1.00  0.00           H  
ATOM    423  HB2 SER A  31      39.718 -27.479   9.527  1.00  0.00           H  
ATOM    424  HB3 SER A  31      38.238 -26.667   9.015  1.00  0.00           H  
ATOM    425  HG  SER A  31      37.105 -27.748  10.538  1.00  0.00           H  
ATOM    426  N   TYR A  32      36.268 -28.002   7.448  1.00  0.00           N  
ATOM    427  CA  TYR A  32      34.835 -28.127   7.210  1.00  0.00           C  
ATOM    428  C   TYR A  32      34.560 -28.973   5.971  1.00  0.00           C  
ATOM    429  O   TYR A  32      35.110 -28.721   4.899  1.00  0.00           O  
ATOM    430  CB  TYR A  32      34.202 -26.744   7.049  1.00  0.00           C  
ATOM    431  CG  TYR A  32      32.852 -26.774   6.366  1.00  0.00           C  
ATOM    432  CD1 TYR A  32      32.752 -26.910   4.988  1.00  0.00           C  
ATOM    433  CD2 TYR A  32      31.678 -26.664   7.102  1.00  0.00           C  
ATOM    434  CE1 TYR A  32      31.522 -26.935   4.360  1.00  0.00           C  
ATOM    435  CE2 TYR A  32      30.443 -26.690   6.482  1.00  0.00           C  
ATOM    436  CZ  TYR A  32      30.370 -26.825   5.112  1.00  0.00           C  
ATOM    437  OH  TYR A  32      29.143 -26.852   4.491  1.00  0.00           O  
ATOM    438  H   TYR A  32      36.740 -27.210   7.116  1.00  0.00           H  
ATOM    439  HA  TYR A  32      34.398 -28.615   8.070  1.00  0.00           H  
ATOM    440  HB2 TYR A  32      34.069 -26.301   8.024  1.00  0.00           H  
ATOM    441  HB3 TYR A  32      34.858 -26.121   6.460  1.00  0.00           H  
ATOM    442  HD1 TYR A  32      33.656 -26.996   4.402  1.00  0.00           H  
ATOM    443  HD2 TYR A  32      31.738 -26.558   8.175  1.00  0.00           H  
ATOM    444  HE1 TYR A  32      31.464 -27.042   3.287  1.00  0.00           H  
ATOM    445  HE2 TYR A  32      29.541 -26.605   7.070  1.00  0.00           H  
ATOM    446  HH  TYR A  32      29.159 -27.497   3.779  1.00  0.00           H  
ATOM    447  N   ALA A  33      33.705 -29.978   6.127  1.00  0.00           N  
ATOM    448  CA  ALA A  33      33.354 -30.861   5.021  1.00  0.00           C  
ATOM    449  C   ALA A  33      32.060 -30.411   4.350  1.00  0.00           C  
ATOM    450  O   ALA A  33      30.975 -30.483   4.928  1.00  0.00           O  
ATOM    451  CB  ALA A  33      33.226 -32.296   5.511  1.00  0.00           C  
ATOM    452  H   ALA A  33      33.299 -30.129   7.006  1.00  0.00           H  
ATOM    453  HA  ALA A  33      34.155 -30.823   4.297  1.00  0.00           H  
ATOM    454  HB1 ALA A  33      34.210 -32.731   5.606  1.00  0.00           H  
ATOM    455  HB2 ALA A  33      32.734 -32.305   6.471  1.00  0.00           H  
ATOM    456  HB3 ALA A  33      32.645 -32.867   4.802  1.00  0.00           H  
ATOM    457  N   PRO A  34      32.173 -29.937   3.101  1.00  0.00           N  
ATOM    458  CA  PRO A  34      31.022 -29.466   2.325  1.00  0.00           C  
ATOM    459  C   PRO A  34      30.097 -30.606   1.912  1.00  0.00           C  
ATOM    460  O   PRO A  34      30.536 -31.589   1.315  1.00  0.00           O  
ATOM    461  CB  PRO A  34      31.665 -28.825   1.092  1.00  0.00           C  
ATOM    462  CG  PRO A  34      32.981 -29.508   0.952  1.00  0.00           C  
ATOM    463  CD  PRO A  34      33.435 -29.822   2.350  1.00  0.00           C  
ATOM    464  HA  PRO A  34      30.456 -28.723   2.867  1.00  0.00           H  
ATOM    465  HB2 PRO A  34      31.037 -28.993   0.228  1.00  0.00           H  
ATOM    466  HB3 PRO A  34      31.784 -27.764   1.255  1.00  0.00           H  
ATOM    467  HG2 PRO A  34      32.864 -30.417   0.382  1.00  0.00           H  
ATOM    468  HG3 PRO A  34      33.686 -28.848   0.469  1.00  0.00           H  
ATOM    469  HD2 PRO A  34      33.981 -30.754   2.369  1.00  0.00           H  
ATOM    470  HD3 PRO A  34      34.043 -29.019   2.739  1.00  0.00           H  
ATOM    471  N   ARG A  35      28.815 -30.467   2.233  1.00  0.00           N  
ATOM    472  CA  ARG A  35      27.828 -31.486   1.896  1.00  0.00           C  
ATOM    473  C   ARG A  35      26.760 -30.921   0.964  1.00  0.00           C  
ATOM    474  O   ARG A  35      26.338 -29.774   1.110  1.00  0.00           O  
ATOM    475  CB  ARG A  35      27.174 -32.033   3.165  1.00  0.00           C  
ATOM    476  CG  ARG A  35      28.167 -32.618   4.158  1.00  0.00           C  
ATOM    477  CD  ARG A  35      28.747 -33.932   3.657  1.00  0.00           C  
ATOM    478  NE  ARG A  35      30.000 -34.267   4.327  1.00  0.00           N  
ATOM    479  CZ  ARG A  35      30.755 -35.308   3.995  1.00  0.00           C  
ATOM    480  NH1 ARG A  35      30.387 -36.109   3.004  1.00  0.00           N  
ATOM    481  NH2 ARG A  35      31.882 -35.548   4.653  1.00  0.00           N  
ATOM    482  H   ARG A  35      28.526 -29.660   2.708  1.00  0.00           H  
ATOM    483  HA  ARG A  35      28.341 -32.290   1.390  1.00  0.00           H  
ATOM    484  HB2 ARG A  35      26.639 -31.232   3.655  1.00  0.00           H  
ATOM    485  HB3 ARG A  35      26.474 -32.808   2.890  1.00  0.00           H  
ATOM    486  HG2 ARG A  35      28.973 -31.914   4.304  1.00  0.00           H  
ATOM    487  HG3 ARG A  35      27.662 -32.791   5.096  1.00  0.00           H  
ATOM    488  HD2 ARG A  35      28.030 -34.719   3.839  1.00  0.00           H  
ATOM    489  HD3 ARG A  35      28.928 -33.848   2.596  1.00  0.00           H  
ATOM    490  HE  ARG A  35      30.291 -33.688   5.063  1.00  0.00           H  
ATOM    491 HH11 ARG A  35      29.539 -35.930   2.506  1.00  0.00           H  
ATOM    492 HH12 ARG A  35      30.958 -36.892   2.755  1.00  0.00           H  
ATOM    493 HH21 ARG A  35      32.164 -34.946   5.399  1.00  0.00           H  
ATOM    494 HH22 ARG A  35      32.451 -36.331   4.401  1.00  0.00           H  
ATOM    495  N   ARG A  36      26.329 -31.734   0.005  1.00  0.00           N  
ATOM    496  CA  ARG A  36      25.311 -31.315  -0.951  1.00  0.00           C  
ATOM    497  C   ARG A  36      24.072 -30.789  -0.233  1.00  0.00           C  
ATOM    498  O   ARG A  36      23.293 -31.559   0.327  1.00  0.00           O  
ATOM    499  CB  ARG A  36      24.927 -32.480  -1.864  1.00  0.00           C  
ATOM    500  CG  ARG A  36      23.905 -32.112  -2.927  1.00  0.00           C  
ATOM    501  CD  ARG A  36      24.064 -32.967  -4.173  1.00  0.00           C  
ATOM    502  NE  ARG A  36      22.868 -32.942  -5.011  1.00  0.00           N  
ATOM    503  CZ  ARG A  36      22.721 -33.681  -6.105  1.00  0.00           C  
ATOM    504  NH1 ARG A  36      23.689 -34.500  -6.491  1.00  0.00           N  
ATOM    505  NH2 ARG A  36      21.602 -33.602  -6.815  1.00  0.00           N  
ATOM    506  H   ARG A  36      26.703 -32.637  -0.061  1.00  0.00           H  
ATOM    507  HA  ARG A  36      25.728 -30.520  -1.553  1.00  0.00           H  
ATOM    508  HB2 ARG A  36      25.815 -32.841  -2.361  1.00  0.00           H  
ATOM    509  HB3 ARG A  36      24.515 -33.274  -1.260  1.00  0.00           H  
ATOM    510  HG2 ARG A  36      22.913 -32.259  -2.526  1.00  0.00           H  
ATOM    511  HG3 ARG A  36      24.037 -31.074  -3.193  1.00  0.00           H  
ATOM    512  HD2 ARG A  36      24.900 -32.595  -4.746  1.00  0.00           H  
ATOM    513  HD3 ARG A  36      24.259 -33.986  -3.873  1.00  0.00           H  
ATOM    514  HE  ARG A  36      22.140 -32.343  -4.744  1.00  0.00           H  
ATOM    515 HH11 ARG A  36      24.532 -34.562  -5.958  1.00  0.00           H  
ATOM    516 HH12 ARG A  36      23.575 -35.056  -7.314  1.00  0.00           H  
ATOM    517 HH21 ARG A  36      20.870 -32.986  -6.527  1.00  0.00           H  
ATOM    518 HH22 ARG A  36      21.492 -34.159  -7.638  1.00  0.00           H  
ATOM    519  N   GLY A  37      23.898 -29.471  -0.251  1.00  0.00           N  
ATOM    520  CA  GLY A  37      22.753 -28.865   0.402  1.00  0.00           C  
ATOM    521  C   GLY A  37      23.101 -28.282   1.759  1.00  0.00           C  
ATOM    522  O   GLY A  37      22.260 -28.239   2.656  1.00  0.00           O  
ATOM    523  H   GLY A  37      24.552 -28.905  -0.713  1.00  0.00           H  
ATOM    524  HA2 GLY A  37      22.367 -28.077  -0.228  1.00  0.00           H  
ATOM    525  HA3 GLY A  37      21.987 -29.616   0.533  1.00  0.00           H  
ATOM    526  N   GLU A  38      24.344 -27.833   1.907  1.00  0.00           N  
ATOM    527  CA  GLU A  38      24.800 -27.253   3.165  1.00  0.00           C  
ATOM    528  C   GLU A  38      25.395 -25.866   2.939  1.00  0.00           C  
ATOM    529  O   GLU A  38      26.137 -25.644   1.982  1.00  0.00           O  
ATOM    530  CB  GLU A  38      25.838 -28.163   3.824  1.00  0.00           C  
ATOM    531  CG  GLU A  38      25.233 -29.204   4.751  1.00  0.00           C  
ATOM    532  CD  GLU A  38      24.646 -28.596   6.010  1.00  0.00           C  
ATOM    533  OE1 GLU A  38      25.426 -28.259   6.925  1.00  0.00           O  
ATOM    534  OE2 GLU A  38      23.407 -28.455   6.079  1.00  0.00           O  
ATOM    535  H   GLU A  38      24.967 -27.895   1.154  1.00  0.00           H  
ATOM    536  HA  GLU A  38      23.946 -27.164   3.818  1.00  0.00           H  
ATOM    537  HB2 GLU A  38      26.392 -28.677   3.053  1.00  0.00           H  
ATOM    538  HB3 GLU A  38      26.519 -27.554   4.399  1.00  0.00           H  
ATOM    539  HG2 GLU A  38      24.448 -29.725   4.223  1.00  0.00           H  
ATOM    540  HG3 GLU A  38      26.002 -29.908   5.033  1.00  0.00           H  
ATOM    541  N   PHE A  39      25.062 -24.935   3.827  1.00  0.00           N  
ATOM    542  CA  PHE A  39      25.561 -23.569   3.725  1.00  0.00           C  
ATOM    543  C   PHE A  39      26.933 -23.441   4.380  1.00  0.00           C  
ATOM    544  O   PHE A  39      27.218 -24.095   5.383  1.00  0.00           O  
ATOM    545  CB  PHE A  39      24.579 -22.595   4.381  1.00  0.00           C  
ATOM    546  CG  PHE A  39      23.348 -22.341   3.557  1.00  0.00           C  
ATOM    547  CD1 PHE A  39      23.399 -21.514   2.448  1.00  0.00           C  
ATOM    548  CD2 PHE A  39      22.140 -22.929   3.895  1.00  0.00           C  
ATOM    549  CE1 PHE A  39      22.268 -21.278   1.689  1.00  0.00           C  
ATOM    550  CE2 PHE A  39      21.005 -22.698   3.140  1.00  0.00           C  
ATOM    551  CZ  PHE A  39      21.070 -21.872   2.035  1.00  0.00           C  
ATOM    552  H   PHE A  39      24.466 -25.173   4.568  1.00  0.00           H  
ATOM    553  HA  PHE A  39      25.650 -23.326   2.677  1.00  0.00           H  
ATOM    554  HB2 PHE A  39      24.264 -22.997   5.332  1.00  0.00           H  
ATOM    555  HB3 PHE A  39      25.074 -21.649   4.540  1.00  0.00           H  
ATOM    556  HD1 PHE A  39      24.336 -21.050   2.174  1.00  0.00           H  
ATOM    557  HD2 PHE A  39      22.089 -23.576   4.759  1.00  0.00           H  
ATOM    558  HE1 PHE A  39      22.321 -20.632   0.826  1.00  0.00           H  
ATOM    559  HE2 PHE A  39      20.070 -23.164   3.413  1.00  0.00           H  
ATOM    560  HZ  PHE A  39      20.185 -21.688   1.445  1.00  0.00           H  
ATOM    561  N   CYS A  40      27.780 -22.594   3.804  1.00  0.00           N  
ATOM    562  CA  CYS A  40      29.123 -22.380   4.328  1.00  0.00           C  
ATOM    563  C   CYS A  40      29.776 -21.167   3.674  1.00  0.00           C  
ATOM    564  O   CYS A  40      29.219 -20.574   2.750  1.00  0.00           O  
ATOM    565  CB  CYS A  40      29.986 -23.623   4.100  1.00  0.00           C  
ATOM    566  SG  CYS A  40      29.993 -24.213   2.391  1.00  0.00           S  
ATOM    567  H   CYS A  40      27.495 -22.101   3.006  1.00  0.00           H  
ATOM    568  HA  CYS A  40      29.040 -22.201   5.389  1.00  0.00           H  
ATOM    569  HB2 CYS A  40      31.007 -23.399   4.374  1.00  0.00           H  
ATOM    570  HB3 CYS A  40      29.621 -24.424   4.725  1.00  0.00           H  
ATOM    571  HG  CYS A  40      29.624 -23.209   1.611  1.00  0.00           H  
ATOM    572  N   ILE A  41      30.958 -20.803   4.161  1.00  0.00           N  
ATOM    573  CA  ILE A  41      31.685 -19.660   3.625  1.00  0.00           C  
ATOM    574  C   ILE A  41      32.768 -20.106   2.648  1.00  0.00           C  
ATOM    575  O   ILE A  41      33.541 -21.018   2.937  1.00  0.00           O  
ATOM    576  CB  ILE A  41      32.334 -18.828   4.746  1.00  0.00           C  
ATOM    577  CG1 ILE A  41      33.296 -19.694   5.562  1.00  0.00           C  
ATOM    578  CG2 ILE A  41      31.264 -18.226   5.645  1.00  0.00           C  
ATOM    579  CD1 ILE A  41      34.039 -18.926   6.633  1.00  0.00           C  
ATOM    580  H   ILE A  41      31.349 -21.316   4.898  1.00  0.00           H  
ATOM    581  HA  ILE A  41      30.979 -19.032   3.100  1.00  0.00           H  
ATOM    582  HB  ILE A  41      32.885 -18.018   4.292  1.00  0.00           H  
ATOM    583 HG12 ILE A  41      32.741 -20.483   6.044  1.00  0.00           H  
ATOM    584 HG13 ILE A  41      34.028 -20.128   4.896  1.00  0.00           H  
ATOM    585 HG21 ILE A  41      31.239 -18.761   6.583  1.00  0.00           H  
ATOM    586 HG22 ILE A  41      31.493 -17.187   5.830  1.00  0.00           H  
ATOM    587 HG23 ILE A  41      30.302 -18.302   5.162  1.00  0.00           H  
ATOM    588 HD11 ILE A  41      34.250 -19.582   7.466  1.00  0.00           H  
ATOM    589 HD12 ILE A  41      34.966 -18.548   6.229  1.00  0.00           H  
ATOM    590 HD13 ILE A  41      33.430 -18.100   6.972  1.00  0.00           H  
ATOM    591  N   ALA A  42      32.817 -19.456   1.489  1.00  0.00           N  
ATOM    592  CA  ALA A  42      33.807 -19.783   0.471  1.00  0.00           C  
ATOM    593  C   ALA A  42      34.785 -18.631   0.267  1.00  0.00           C  
ATOM    594  O   ALA A  42      34.404 -17.461   0.323  1.00  0.00           O  
ATOM    595  CB  ALA A  42      33.120 -20.134  -0.839  1.00  0.00           C  
ATOM    596  H   ALA A  42      32.174 -18.738   1.317  1.00  0.00           H  
ATOM    597  HA  ALA A  42      34.356 -20.652   0.806  1.00  0.00           H  
ATOM    598  HB1 ALA A  42      33.785 -20.733  -1.444  1.00  0.00           H  
ATOM    599  HB2 ALA A  42      32.218 -20.691  -0.635  1.00  0.00           H  
ATOM    600  HB3 ALA A  42      32.871 -19.227  -1.369  1.00  0.00           H  
ATOM    601  N   LYS A  43      36.048 -18.968   0.027  1.00  0.00           N  
ATOM    602  CA  LYS A  43      37.082 -17.962  -0.187  1.00  0.00           C  
ATOM    603  C   LYS A  43      37.186 -17.596  -1.664  1.00  0.00           C  
ATOM    604  O   LYS A  43      37.365 -18.464  -2.518  1.00  0.00           O  
ATOM    605  CB  LYS A  43      38.432 -18.473   0.319  1.00  0.00           C  
ATOM    606  CG  LYS A  43      39.365 -17.368   0.785  1.00  0.00           C  
ATOM    607  CD  LYS A  43      40.547 -17.925   1.560  1.00  0.00           C  
ATOM    608  CE  LYS A  43      41.045 -16.936   2.603  1.00  0.00           C  
ATOM    609  NZ  LYS A  43      42.477 -17.162   2.941  1.00  0.00           N  
ATOM    610  H   LYS A  43      36.291 -19.918  -0.006  1.00  0.00           H  
ATOM    611  HA  LYS A  43      36.807 -17.080   0.372  1.00  0.00           H  
ATOM    612  HB2 LYS A  43      38.262 -19.144   1.149  1.00  0.00           H  
ATOM    613  HB3 LYS A  43      38.920 -19.016  -0.477  1.00  0.00           H  
ATOM    614  HG2 LYS A  43      39.735 -16.835  -0.079  1.00  0.00           H  
ATOM    615  HG3 LYS A  43      38.816 -16.689   1.420  1.00  0.00           H  
ATOM    616  HD2 LYS A  43      40.243 -18.834   2.058  1.00  0.00           H  
ATOM    617  HD3 LYS A  43      41.349 -18.142   0.870  1.00  0.00           H  
ATOM    618  HE2 LYS A  43      40.928 -15.936   2.216  1.00  0.00           H  
ATOM    619  HE3 LYS A  43      40.450 -17.048   3.498  1.00  0.00           H  
ATOM    620  HZ1 LYS A  43      42.569 -17.980   3.578  1.00  0.00           H  
ATOM    621  HZ2 LYS A  43      42.869 -16.323   3.416  1.00  0.00           H  
ATOM    622  HZ3 LYS A  43      43.024 -17.345   2.077  1.00  0.00           H  
ATOM    623  N   PHE A  44      37.075 -16.305  -1.958  1.00  0.00           N  
ATOM    624  CA  PHE A  44      37.158 -15.824  -3.332  1.00  0.00           C  
ATOM    625  C   PHE A  44      38.609 -15.589  -3.739  1.00  0.00           C  
ATOM    626  O   PHE A  44      39.477 -15.376  -2.893  1.00  0.00           O  
ATOM    627  CB  PHE A  44      36.356 -14.530  -3.491  1.00  0.00           C  
ATOM    628  CG  PHE A  44      36.050 -14.186  -4.921  1.00  0.00           C  
ATOM    629  CD1 PHE A  44      35.352 -15.071  -5.727  1.00  0.00           C  
ATOM    630  CD2 PHE A  44      36.464 -12.978  -5.460  1.00  0.00           C  
ATOM    631  CE1 PHE A  44      35.070 -14.756  -7.043  1.00  0.00           C  
ATOM    632  CE2 PHE A  44      36.185 -12.659  -6.775  1.00  0.00           C  
ATOM    633  CZ  PHE A  44      35.487 -13.548  -7.567  1.00  0.00           C  
ATOM    634  H   PHE A  44      36.933 -15.660  -1.233  1.00  0.00           H  
ATOM    635  HA  PHE A  44      36.734 -16.581  -3.974  1.00  0.00           H  
ATOM    636  HB2 PHE A  44      35.417 -14.631  -2.968  1.00  0.00           H  
ATOM    637  HB3 PHE A  44      36.916 -13.714  -3.064  1.00  0.00           H  
ATOM    638  HD1 PHE A  44      35.024 -16.015  -5.318  1.00  0.00           H  
ATOM    639  HD2 PHE A  44      37.010 -12.281  -4.841  1.00  0.00           H  
ATOM    640  HE1 PHE A  44      34.524 -15.454  -7.660  1.00  0.00           H  
ATOM    641  HE2 PHE A  44      36.513 -11.713  -7.183  1.00  0.00           H  
ATOM    642  HZ  PHE A  44      35.269 -13.301  -8.596  1.00  0.00           H  
ATOM    643  N   VAL A  45      38.865 -15.630  -5.043  1.00  0.00           N  
ATOM    644  CA  VAL A  45      40.211 -15.420  -5.565  1.00  0.00           C  
ATOM    645  C   VAL A  45      40.886 -14.235  -4.884  1.00  0.00           C  
ATOM    646  O   VAL A  45      42.113 -14.156  -4.827  1.00  0.00           O  
ATOM    647  CB  VAL A  45      40.193 -15.184  -7.086  1.00  0.00           C  
ATOM    648  CG1 VAL A  45      39.521 -16.347  -7.800  1.00  0.00           C  
ATOM    649  CG2 VAL A  45      39.494 -13.873  -7.412  1.00  0.00           C  
ATOM    650  H   VAL A  45      38.132 -15.804  -5.669  1.00  0.00           H  
ATOM    651  HA  VAL A  45      40.788 -16.313  -5.367  1.00  0.00           H  
ATOM    652  HB  VAL A  45      41.213 -15.119  -7.433  1.00  0.00           H  
ATOM    653 HG11 VAL A  45      39.639 -16.230  -8.867  1.00  0.00           H  
ATOM    654 HG12 VAL A  45      39.976 -17.274  -7.485  1.00  0.00           H  
ATOM    655 HG13 VAL A  45      38.469 -16.360  -7.555  1.00  0.00           H  
ATOM    656 HG21 VAL A  45      39.808 -13.531  -8.388  1.00  0.00           H  
ATOM    657 HG22 VAL A  45      38.424 -14.024  -7.412  1.00  0.00           H  
ATOM    658 HG23 VAL A  45      39.753 -13.131  -6.670  1.00  0.00           H  
ATOM    659  N   ASP A  46      40.077 -13.315  -4.372  1.00  0.00           N  
ATOM    660  CA  ASP A  46      40.594 -12.133  -3.693  1.00  0.00           C  
ATOM    661  C   ASP A  46      40.678 -12.363  -2.187  1.00  0.00           C  
ATOM    662  O   ASP A  46      40.579 -11.424  -1.400  1.00  0.00           O  
ATOM    663  CB  ASP A  46      39.711 -10.920  -3.989  1.00  0.00           C  
ATOM    664  CG  ASP A  46      40.011 -10.301  -5.339  1.00  0.00           C  
ATOM    665  OD1 ASP A  46      41.139  -9.798  -5.524  1.00  0.00           O  
ATOM    666  OD2 ASP A  46      39.117 -10.317  -6.212  1.00  0.00           O  
ATOM    667  H   ASP A  46      39.106 -13.435  -4.450  1.00  0.00           H  
ATOM    668  HA  ASP A  46      41.589 -11.943  -4.071  1.00  0.00           H  
ATOM    669  HB2 ASP A  46      38.675 -11.227  -3.977  1.00  0.00           H  
ATOM    670  HB3 ASP A  46      39.870 -10.172  -3.226  1.00  0.00           H  
ATOM    671  N   GLY A  47      40.860 -13.620  -1.794  1.00  0.00           N  
ATOM    672  CA  GLY A  47      40.951 -13.951  -0.385  1.00  0.00           C  
ATOM    673  C   GLY A  47      39.802 -13.380   0.421  1.00  0.00           C  
ATOM    674  O   GLY A  47      39.961 -13.056   1.597  1.00  0.00           O  
ATOM    675  H   GLY A  47      40.932 -14.329  -2.468  1.00  0.00           H  
ATOM    676  HA2 GLY A  47      40.955 -15.025  -0.277  1.00  0.00           H  
ATOM    677  HA3 GLY A  47      41.879 -13.558   0.006  1.00  0.00           H  
ATOM    678  N   GLU A  48      38.641 -13.255  -0.215  1.00  0.00           N  
ATOM    679  CA  GLU A  48      37.460 -12.716   0.451  1.00  0.00           C  
ATOM    680  C   GLU A  48      36.418 -13.808   0.678  1.00  0.00           C  
ATOM    681  O   GLU A  48      35.980 -14.468  -0.264  1.00  0.00           O  
ATOM    682  CB  GLU A  48      36.855 -11.581  -0.376  1.00  0.00           C  
ATOM    683  CG  GLU A  48      37.666 -10.297  -0.334  1.00  0.00           C  
ATOM    684  CD  GLU A  48      37.269  -9.393   0.818  1.00  0.00           C  
ATOM    685  OE1 GLU A  48      36.062  -9.321   1.126  1.00  0.00           O  
ATOM    686  OE2 GLU A  48      38.167  -8.759   1.410  1.00  0.00           O  
ATOM    687  H   GLU A  48      38.577 -13.531  -1.153  1.00  0.00           H  
ATOM    688  HA  GLU A  48      37.769 -12.326   1.409  1.00  0.00           H  
ATOM    689  HB2 GLU A  48      36.778 -11.902  -1.404  1.00  0.00           H  
ATOM    690  HB3 GLU A  48      35.864 -11.368  -0.001  1.00  0.00           H  
ATOM    691  HG2 GLU A  48      38.710 -10.550  -0.229  1.00  0.00           H  
ATOM    692  HG3 GLU A  48      37.517  -9.761  -1.260  1.00  0.00           H  
ATOM    693  N   TRP A  49      36.027 -13.991   1.934  1.00  0.00           N  
ATOM    694  CA  TRP A  49      35.036 -15.003   2.285  1.00  0.00           C  
ATOM    695  C   TRP A  49      33.628 -14.527   1.944  1.00  0.00           C  
ATOM    696  O   TRP A  49      33.297 -13.357   2.131  1.00  0.00           O  
ATOM    697  CB  TRP A  49      35.128 -15.340   3.775  1.00  0.00           C  
ATOM    698  CG  TRP A  49      36.371 -16.094   4.137  1.00  0.00           C  
ATOM    699  CD1 TRP A  49      37.556 -15.565   4.564  1.00  0.00           C  
ATOM    700  CD2 TRP A  49      36.554 -17.514   4.103  1.00  0.00           C  
ATOM    701  NE1 TRP A  49      38.463 -16.570   4.798  1.00  0.00           N  
ATOM    702  CE2 TRP A  49      37.873 -17.775   4.523  1.00  0.00           C  
ATOM    703  CE3 TRP A  49      35.731 -18.590   3.760  1.00  0.00           C  
ATOM    704  CZ2 TRP A  49      38.385 -19.067   4.607  1.00  0.00           C  
ATOM    705  CZ3 TRP A  49      36.240 -19.871   3.845  1.00  0.00           C  
ATOM    706  CH2 TRP A  49      37.557 -20.102   4.266  1.00  0.00           C  
ATOM    707  H   TRP A  49      36.413 -13.434   2.642  1.00  0.00           H  
ATOM    708  HA  TRP A  49      35.253 -15.891   1.710  1.00  0.00           H  
ATOM    709  HB2 TRP A  49      35.115 -14.424   4.345  1.00  0.00           H  
ATOM    710  HB3 TRP A  49      34.277 -15.946   4.052  1.00  0.00           H  
ATOM    711  HD1 TRP A  49      37.738 -14.508   4.693  1.00  0.00           H  
ATOM    712  HE1 TRP A  49      39.384 -16.444   5.112  1.00  0.00           H  
ATOM    713  HE3 TRP A  49      34.713 -18.432   3.434  1.00  0.00           H  
ATOM    714  HZ2 TRP A  49      39.397 -19.260   4.931  1.00  0.00           H  
ATOM    715  HZ3 TRP A  49      35.618 -20.716   3.583  1.00  0.00           H  
ATOM    716  HH2 TRP A  49      37.913 -21.119   4.316  1.00  0.00           H  
ATOM    717  N   TYR A  50      32.804 -15.442   1.446  1.00  0.00           N  
ATOM    718  CA  TYR A  50      31.432 -15.115   1.077  1.00  0.00           C  
ATOM    719  C   TYR A  50      30.500 -16.293   1.346  1.00  0.00           C  
ATOM    720  O   TYR A  50      30.924 -17.449   1.334  1.00  0.00           O  
ATOM    721  CB  TYR A  50      31.359 -14.719  -0.398  1.00  0.00           C  
ATOM    722  CG  TYR A  50      32.166 -13.485  -0.735  1.00  0.00           C  
ATOM    723  CD1 TYR A  50      31.764 -12.228  -0.300  1.00  0.00           C  
ATOM    724  CD2 TYR A  50      33.331 -13.577  -1.486  1.00  0.00           C  
ATOM    725  CE1 TYR A  50      32.498 -11.099  -0.605  1.00  0.00           C  
ATOM    726  CE2 TYR A  50      34.071 -12.452  -1.796  1.00  0.00           C  
ATOM    727  CZ  TYR A  50      33.652 -11.216  -1.353  1.00  0.00           C  
ATOM    728  OH  TYR A  50      34.386 -10.093  -1.659  1.00  0.00           O  
ATOM    729  H   TYR A  50      33.127 -16.359   1.321  1.00  0.00           H  
ATOM    730  HA  TYR A  50      31.118 -14.277   1.682  1.00  0.00           H  
ATOM    731  HB2 TYR A  50      31.731 -15.533  -1.001  1.00  0.00           H  
ATOM    732  HB3 TYR A  50      30.330 -14.524  -0.661  1.00  0.00           H  
ATOM    733  HD1 TYR A  50      30.861 -12.140   0.287  1.00  0.00           H  
ATOM    734  HD2 TYR A  50      33.657 -14.548  -1.832  1.00  0.00           H  
ATOM    735  HE1 TYR A  50      32.170 -10.130  -0.259  1.00  0.00           H  
ATOM    736  HE2 TYR A  50      34.975 -12.544  -2.382  1.00  0.00           H  
ATOM    737  HH  TYR A  50      34.413  -9.978  -2.612  1.00  0.00           H  
ATOM    738  N   ARG A  51      29.230 -15.990   1.587  1.00  0.00           N  
ATOM    739  CA  ARG A  51      28.236 -17.022   1.860  1.00  0.00           C  
ATOM    740  C   ARG A  51      27.889 -17.792   0.589  1.00  0.00           C  
ATOM    741  O   ARG A  51      27.653 -17.198  -0.463  1.00  0.00           O  
ATOM    742  CB  ARG A  51      26.971 -16.400   2.452  1.00  0.00           C  
ATOM    743  CG  ARG A  51      27.034 -16.211   3.960  1.00  0.00           C  
ATOM    744  CD  ARG A  51      25.648 -16.251   4.585  1.00  0.00           C  
ATOM    745  NE  ARG A  51      25.040 -14.925   4.651  1.00  0.00           N  
ATOM    746  CZ  ARG A  51      24.355 -14.379   3.652  1.00  0.00           C  
ATOM    747  NH1 ARG A  51      24.192 -15.042   2.516  1.00  0.00           N  
ATOM    748  NH2 ARG A  51      23.831 -13.168   3.789  1.00  0.00           N  
ATOM    749  H   ARG A  51      28.952 -15.050   1.584  1.00  0.00           H  
ATOM    750  HA  ARG A  51      28.660 -17.709   2.577  1.00  0.00           H  
ATOM    751  HB2 ARG A  51      26.812 -15.433   1.998  1.00  0.00           H  
ATOM    752  HB3 ARG A  51      26.131 -17.038   2.226  1.00  0.00           H  
ATOM    753  HG2 ARG A  51      27.632 -17.002   4.388  1.00  0.00           H  
ATOM    754  HG3 ARG A  51      27.490 -15.257   4.175  1.00  0.00           H  
ATOM    755  HD2 ARG A  51      25.018 -16.896   3.990  1.00  0.00           H  
ATOM    756  HD3 ARG A  51      25.730 -16.651   5.584  1.00  0.00           H  
ATOM    757  HE  ARG A  51      25.148 -14.417   5.482  1.00  0.00           H  
ATOM    758 HH11 ARG A  51      24.585 -15.956   2.411  1.00  0.00           H  
ATOM    759 HH12 ARG A  51      23.675 -14.630   1.765  1.00  0.00           H  
ATOM    760 HH21 ARG A  51      23.952 -12.665   4.643  1.00  0.00           H  
ATOM    761 HH22 ARG A  51      23.317 -12.758   3.037  1.00  0.00           H  
ATOM    762  N   ALA A  52      27.862 -19.117   0.693  1.00  0.00           N  
ATOM    763  CA  ALA A  52      27.542 -19.966  -0.447  1.00  0.00           C  
ATOM    764  C   ALA A  52      26.915 -21.280   0.007  1.00  0.00           C  
ATOM    765  O   ALA A  52      27.148 -21.737   1.126  1.00  0.00           O  
ATOM    766  CB  ALA A  52      28.793 -20.235  -1.272  1.00  0.00           C  
ATOM    767  H   ALA A  52      28.059 -19.532   1.559  1.00  0.00           H  
ATOM    768  HA  ALA A  52      26.836 -19.438  -1.070  1.00  0.00           H  
ATOM    769  HB1 ALA A  52      28.845 -19.525  -2.085  1.00  0.00           H  
ATOM    770  HB2 ALA A  52      29.666 -20.130  -0.645  1.00  0.00           H  
ATOM    771  HB3 ALA A  52      28.753 -21.237  -1.671  1.00  0.00           H  
ATOM    772  N   ARG A  53      26.116 -21.883  -0.869  1.00  0.00           N  
ATOM    773  CA  ARG A  53      25.453 -23.143  -0.557  1.00  0.00           C  
ATOM    774  C   ARG A  53      25.969 -24.265  -1.453  1.00  0.00           C  
ATOM    775  O   ARG A  53      25.875 -24.189  -2.678  1.00  0.00           O  
ATOM    776  CB  ARG A  53      23.939 -23.001  -0.719  1.00  0.00           C  
ATOM    777  CG  ARG A  53      23.173 -24.285  -0.443  1.00  0.00           C  
ATOM    778  CD  ARG A  53      21.671 -24.068  -0.536  1.00  0.00           C  
ATOM    779  NE  ARG A  53      20.930 -24.999   0.312  1.00  0.00           N  
ATOM    780  CZ  ARG A  53      19.607 -25.106   0.304  1.00  0.00           C  
ATOM    781  NH1 ARG A  53      18.882 -24.343  -0.503  1.00  0.00           N  
ATOM    782  NH2 ARG A  53      19.006 -25.977   1.105  1.00  0.00           N  
ATOM    783  H   ARG A  53      25.970 -21.470  -1.745  1.00  0.00           H  
ATOM    784  HA  ARG A  53      25.675 -23.389   0.471  1.00  0.00           H  
ATOM    785  HB2 ARG A  53      23.584 -22.243  -0.037  1.00  0.00           H  
ATOM    786  HB3 ARG A  53      23.726 -22.691  -1.732  1.00  0.00           H  
ATOM    787  HG2 ARG A  53      23.465 -25.029  -1.169  1.00  0.00           H  
ATOM    788  HG3 ARG A  53      23.419 -24.632   0.549  1.00  0.00           H  
ATOM    789  HD2 ARG A  53      21.447 -23.059  -0.227  1.00  0.00           H  
ATOM    790  HD3 ARG A  53      21.364 -24.208  -1.562  1.00  0.00           H  
ATOM    791  HE  ARG A  53      21.448 -25.572   0.915  1.00  0.00           H  
ATOM    792 HH11 ARG A  53      19.332 -23.687  -1.108  1.00  0.00           H  
ATOM    793 HH12 ARG A  53      17.885 -24.426  -0.507  1.00  0.00           H  
ATOM    794 HH21 ARG A  53      19.549 -26.552   1.715  1.00  0.00           H  
ATOM    795 HH22 ARG A  53      18.010 -26.056   1.099  1.00  0.00           H  
ATOM    796  N   VAL A  54      26.516 -25.307  -0.833  1.00  0.00           N  
ATOM    797  CA  VAL A  54      27.046 -26.445  -1.575  1.00  0.00           C  
ATOM    798  C   VAL A  54      26.009 -27.002  -2.543  1.00  0.00           C  
ATOM    799  O   VAL A  54      24.961 -27.495  -2.129  1.00  0.00           O  
ATOM    800  CB  VAL A  54      27.501 -27.570  -0.625  1.00  0.00           C  
ATOM    801  CG1 VAL A  54      28.126 -28.712  -1.411  1.00  0.00           C  
ATOM    802  CG2 VAL A  54      28.475 -27.030   0.411  1.00  0.00           C  
ATOM    803  H   VAL A  54      26.562 -25.310   0.145  1.00  0.00           H  
ATOM    804  HA  VAL A  54      27.905 -26.107  -2.136  1.00  0.00           H  
ATOM    805  HB  VAL A  54      26.633 -27.951  -0.108  1.00  0.00           H  
ATOM    806 HG11 VAL A  54      29.090 -28.954  -0.990  1.00  0.00           H  
ATOM    807 HG12 VAL A  54      27.482 -29.579  -1.361  1.00  0.00           H  
ATOM    808 HG13 VAL A  54      28.249 -28.414  -2.443  1.00  0.00           H  
ATOM    809 HG21 VAL A  54      27.934 -26.764   1.308  1.00  0.00           H  
ATOM    810 HG22 VAL A  54      29.209 -27.788   0.645  1.00  0.00           H  
ATOM    811 HG23 VAL A  54      28.973 -26.156   0.018  1.00  0.00           H  
ATOM    812  N   GLU A  55      26.310 -26.918  -3.836  1.00  0.00           N  
ATOM    813  CA  GLU A  55      25.403 -27.415  -4.864  1.00  0.00           C  
ATOM    814  C   GLU A  55      25.715 -28.867  -5.211  1.00  0.00           C  
ATOM    815  O   GLU A  55      24.814 -29.699  -5.322  1.00  0.00           O  
ATOM    816  CB  GLU A  55      25.497 -26.546  -6.121  1.00  0.00           C  
ATOM    817  CG  GLU A  55      25.148 -25.087  -5.880  1.00  0.00           C  
ATOM    818  CD  GLU A  55      25.062 -24.289  -7.166  1.00  0.00           C  
ATOM    819  OE1 GLU A  55      26.035 -24.314  -7.948  1.00  0.00           O  
ATOM    820  OE2 GLU A  55      24.019 -23.638  -7.391  1.00  0.00           O  
ATOM    821  H   GLU A  55      27.162 -26.514  -4.103  1.00  0.00           H  
ATOM    822  HA  GLU A  55      24.397 -27.358  -4.474  1.00  0.00           H  
ATOM    823  HB2 GLU A  55      26.506 -26.595  -6.502  1.00  0.00           H  
ATOM    824  HB3 GLU A  55      24.822 -26.939  -6.866  1.00  0.00           H  
ATOM    825  HG2 GLU A  55      24.194 -25.037  -5.379  1.00  0.00           H  
ATOM    826  HG3 GLU A  55      25.908 -24.648  -5.251  1.00  0.00           H  
ATOM    827  N   LYS A  56      26.999 -29.165  -5.382  1.00  0.00           N  
ATOM    828  CA  LYS A  56      27.433 -30.517  -5.716  1.00  0.00           C  
ATOM    829  C   LYS A  56      28.863 -30.761  -5.245  1.00  0.00           C  
ATOM    830  O   LYS A  56      29.786 -30.046  -5.637  1.00  0.00           O  
ATOM    831  CB  LYS A  56      27.335 -30.747  -7.226  1.00  0.00           C  
ATOM    832  CG  LYS A  56      28.367 -31.725  -7.760  1.00  0.00           C  
ATOM    833  CD  LYS A  56      28.043 -32.156  -9.181  1.00  0.00           C  
ATOM    834  CE  LYS A  56      28.755 -33.451  -9.546  1.00  0.00           C  
ATOM    835  NZ  LYS A  56      28.244 -34.607  -8.758  1.00  0.00           N  
ATOM    836  H   LYS A  56      27.671 -28.459  -5.280  1.00  0.00           H  
ATOM    837  HA  LYS A  56      26.778 -31.210  -5.211  1.00  0.00           H  
ATOM    838  HB2 LYS A  56      26.352 -31.133  -7.456  1.00  0.00           H  
ATOM    839  HB3 LYS A  56      27.468 -29.801  -7.732  1.00  0.00           H  
ATOM    840  HG2 LYS A  56      29.337 -31.250  -7.752  1.00  0.00           H  
ATOM    841  HG3 LYS A  56      28.386 -32.598  -7.123  1.00  0.00           H  
ATOM    842  HD2 LYS A  56      26.978 -32.309  -9.268  1.00  0.00           H  
ATOM    843  HD3 LYS A  56      28.355 -31.379  -9.864  1.00  0.00           H  
ATOM    844  HE2 LYS A  56      28.603 -33.646 -10.596  1.00  0.00           H  
ATOM    845  HE3 LYS A  56      29.811 -33.332  -9.351  1.00  0.00           H  
ATOM    846  HZ1 LYS A  56      28.286 -34.391  -7.741  1.00  0.00           H  
ATOM    847  HZ2 LYS A  56      28.822 -35.450  -8.946  1.00  0.00           H  
ATOM    848  HZ3 LYS A  56      27.258 -34.809  -9.018  1.00  0.00           H  
ATOM    849  N   VAL A  57      29.041 -31.775  -4.405  1.00  0.00           N  
ATOM    850  CA  VAL A  57      30.358 -32.114  -3.884  1.00  0.00           C  
ATOM    851  C   VAL A  57      31.000 -33.234  -4.697  1.00  0.00           C  
ATOM    852  O   VAL A  57      30.571 -34.385  -4.631  1.00  0.00           O  
ATOM    853  CB  VAL A  57      30.285 -32.545  -2.408  1.00  0.00           C  
ATOM    854  CG1 VAL A  57      31.668 -32.902  -1.884  1.00  0.00           C  
ATOM    855  CG2 VAL A  57      29.654 -31.448  -1.564  1.00  0.00           C  
ATOM    856  H   VAL A  57      28.265 -32.308  -4.130  1.00  0.00           H  
ATOM    857  HA  VAL A  57      30.981 -31.233  -3.950  1.00  0.00           H  
ATOM    858  HB  VAL A  57      29.662 -33.425  -2.341  1.00  0.00           H  
ATOM    859 HG11 VAL A  57      31.721 -33.964  -1.702  1.00  0.00           H  
ATOM    860 HG12 VAL A  57      32.412 -32.622  -2.616  1.00  0.00           H  
ATOM    861 HG13 VAL A  57      31.852 -32.369  -0.963  1.00  0.00           H  
ATOM    862 HG21 VAL A  57      28.951 -31.887  -0.871  1.00  0.00           H  
ATOM    863 HG22 VAL A  57      30.423 -30.927  -1.014  1.00  0.00           H  
ATOM    864 HG23 VAL A  57      29.137 -30.751  -2.207  1.00  0.00           H  
ATOM    865  N   GLU A  58      32.029 -32.887  -5.463  1.00  0.00           N  
ATOM    866  CA  GLU A  58      32.729 -33.863  -6.289  1.00  0.00           C  
ATOM    867  C   GLU A  58      33.856 -34.530  -5.506  1.00  0.00           C  
ATOM    868  O   GLU A  58      33.829 -35.738  -5.266  1.00  0.00           O  
ATOM    869  CB  GLU A  58      33.292 -33.192  -7.545  1.00  0.00           C  
ATOM    870  CG  GLU A  58      32.298 -33.112  -8.690  1.00  0.00           C  
ATOM    871  CD  GLU A  58      31.887 -34.478  -9.204  1.00  0.00           C  
ATOM    872  OE1 GLU A  58      31.085 -35.152  -8.524  1.00  0.00           O  
ATOM    873  OE2 GLU A  58      32.369 -34.873 -10.286  1.00  0.00           O  
ATOM    874  H   GLU A  58      32.324 -31.953  -5.473  1.00  0.00           H  
ATOM    875  HA  GLU A  58      32.016 -34.619  -6.586  1.00  0.00           H  
ATOM    876  HB2 GLU A  58      33.603 -32.190  -7.293  1.00  0.00           H  
ATOM    877  HB3 GLU A  58      34.152 -33.753  -7.881  1.00  0.00           H  
ATOM    878  HG2 GLU A  58      31.414 -32.594  -8.347  1.00  0.00           H  
ATOM    879  HG3 GLU A  58      32.746 -32.558  -9.501  1.00  0.00           H  
ATOM    880  N   SER A  59      34.846 -33.736  -5.113  1.00  0.00           N  
ATOM    881  CA  SER A  59      35.985 -34.249  -4.361  1.00  0.00           C  
ATOM    882  C   SER A  59      36.557 -33.175  -3.440  1.00  0.00           C  
ATOM    883  O   SER A  59      36.317 -31.980  -3.614  1.00  0.00           O  
ATOM    884  CB  SER A  59      37.070 -34.748  -5.317  1.00  0.00           C  
ATOM    885  OG  SER A  59      36.506 -35.216  -6.530  1.00  0.00           O  
ATOM    886  H   SER A  59      34.810 -32.782  -5.335  1.00  0.00           H  
ATOM    887  HA  SER A  59      35.640 -35.076  -3.758  1.00  0.00           H  
ATOM    888  HB2 SER A  59      37.751 -33.940  -5.538  1.00  0.00           H  
ATOM    889  HB3 SER A  59      37.613 -35.558  -4.850  1.00  0.00           H  
ATOM    890  HG  SER A  59      35.874 -34.573  -6.857  1.00  0.00           H  
ATOM    891  N   PRO A  60      37.332 -33.609  -2.436  1.00  0.00           N  
ATOM    892  CA  PRO A  60      37.955 -32.703  -1.467  1.00  0.00           C  
ATOM    893  C   PRO A  60      38.654 -31.526  -2.141  1.00  0.00           C  
ATOM    894  O   PRO A  60      38.953 -30.520  -1.499  1.00  0.00           O  
ATOM    895  CB  PRO A  60      38.974 -33.592  -0.752  1.00  0.00           C  
ATOM    896  CG  PRO A  60      38.430 -34.973  -0.884  1.00  0.00           C  
ATOM    897  CD  PRO A  60      37.660 -35.019  -2.167  1.00  0.00           C  
ATOM    898  HA  PRO A  60      37.235 -32.330  -0.752  1.00  0.00           H  
ATOM    899  HB2 PRO A  60      39.937 -33.499  -1.233  1.00  0.00           H  
ATOM    900  HB3 PRO A  60      39.052 -33.296   0.283  1.00  0.00           H  
ATOM    901  HG2 PRO A  60      39.240 -35.686  -0.917  1.00  0.00           H  
ATOM    902  HG3 PRO A  60      37.772 -35.188  -0.054  1.00  0.00           H  
ATOM    903  HD2 PRO A  60      38.274 -35.429  -2.956  1.00  0.00           H  
ATOM    904  HD3 PRO A  60      36.762 -35.606  -2.043  1.00  0.00           H  
ATOM    905  N   ALA A  61      38.912 -31.662  -3.437  1.00  0.00           N  
ATOM    906  CA  ALA A  61      39.574 -30.609  -4.198  1.00  0.00           C  
ATOM    907  C   ALA A  61      38.584 -29.875  -5.096  1.00  0.00           C  
ATOM    908  O   ALA A  61      38.836 -28.750  -5.527  1.00  0.00           O  
ATOM    909  CB  ALA A  61      40.710 -31.191  -5.026  1.00  0.00           C  
ATOM    910  H   ALA A  61      38.649 -32.488  -3.893  1.00  0.00           H  
ATOM    911  HA  ALA A  61      39.997 -29.905  -3.496  1.00  0.00           H  
ATOM    912  HB1 ALA A  61      40.366 -31.362  -6.036  1.00  0.00           H  
ATOM    913  HB2 ALA A  61      41.537 -30.498  -5.040  1.00  0.00           H  
ATOM    914  HB3 ALA A  61      41.029 -32.126  -4.591  1.00  0.00           H  
ATOM    915  N   LYS A  62      37.456 -30.519  -5.375  1.00  0.00           N  
ATOM    916  CA  LYS A  62      36.426 -29.928  -6.223  1.00  0.00           C  
ATOM    917  C   LYS A  62      35.070 -29.946  -5.523  1.00  0.00           C  
ATOM    918  O   LYS A  62      34.514 -31.011  -5.256  1.00  0.00           O  
ATOM    919  CB  LYS A  62      36.336 -30.681  -7.552  1.00  0.00           C  
ATOM    920  CG  LYS A  62      37.601 -30.592  -8.388  1.00  0.00           C  
ATOM    921  CD  LYS A  62      37.297 -30.715  -9.872  1.00  0.00           C  
ATOM    922  CE  LYS A  62      38.331 -29.986 -10.715  1.00  0.00           C  
ATOM    923  NZ  LYS A  62      39.510 -30.846 -11.015  1.00  0.00           N  
ATOM    924  H   LYS A  62      37.312 -31.414  -5.002  1.00  0.00           H  
ATOM    925  HA  LYS A  62      36.704 -28.903  -6.417  1.00  0.00           H  
ATOM    926  HB2 LYS A  62      36.136 -31.723  -7.349  1.00  0.00           H  
ATOM    927  HB3 LYS A  62      35.518 -30.272  -8.128  1.00  0.00           H  
ATOM    928  HG2 LYS A  62      38.075 -29.639  -8.206  1.00  0.00           H  
ATOM    929  HG3 LYS A  62      38.270 -31.390  -8.099  1.00  0.00           H  
ATOM    930  HD2 LYS A  62      37.299 -31.760 -10.145  1.00  0.00           H  
ATOM    931  HD3 LYS A  62      36.322 -30.292 -10.068  1.00  0.00           H  
ATOM    932  HE2 LYS A  62      37.872 -29.682 -11.643  1.00  0.00           H  
ATOM    933  HE3 LYS A  62      38.663 -29.111 -10.176  1.00  0.00           H  
ATOM    934  HZ1 LYS A  62      40.357 -30.257 -11.147  1.00  0.00           H  
ATOM    935  HZ2 LYS A  62      39.341 -31.391 -11.885  1.00  0.00           H  
ATOM    936  HZ3 LYS A  62      39.679 -31.508 -10.231  1.00  0.00           H  
ATOM    937  N   ILE A  63      34.545 -28.761  -5.232  1.00  0.00           N  
ATOM    938  CA  ILE A  63      33.253 -28.641  -4.566  1.00  0.00           C  
ATOM    939  C   ILE A  63      32.385 -27.582  -5.238  1.00  0.00           C  
ATOM    940  O   ILE A  63      32.652 -26.384  -5.129  1.00  0.00           O  
ATOM    941  CB  ILE A  63      33.419 -28.284  -3.077  1.00  0.00           C  
ATOM    942  CG1 ILE A  63      34.611 -29.034  -2.480  1.00  0.00           C  
ATOM    943  CG2 ILE A  63      32.145 -28.608  -2.311  1.00  0.00           C  
ATOM    944  CD1 ILE A  63      34.316 -30.483  -2.159  1.00  0.00           C  
ATOM    945  H   ILE A  63      35.038 -27.948  -5.471  1.00  0.00           H  
ATOM    946  HA  ILE A  63      32.755 -29.596  -4.634  1.00  0.00           H  
ATOM    947  HB  ILE A  63      33.596 -27.222  -3.001  1.00  0.00           H  
ATOM    948 HG12 ILE A  63      35.431 -29.011  -3.180  1.00  0.00           H  
ATOM    949 HG13 ILE A  63      34.912 -28.546  -1.565  1.00  0.00           H  
ATOM    950 HG21 ILE A  63      31.902 -29.652  -2.442  1.00  0.00           H  
ATOM    951 HG22 ILE A  63      32.295 -28.404  -1.262  1.00  0.00           H  
ATOM    952 HG23 ILE A  63      31.335 -28.001  -2.685  1.00  0.00           H  
ATOM    953 HD11 ILE A  63      33.442 -30.540  -1.527  1.00  0.00           H  
ATOM    954 HD12 ILE A  63      34.136 -31.025  -3.075  1.00  0.00           H  
ATOM    955 HD13 ILE A  63      35.161 -30.916  -1.645  1.00  0.00           H  
ATOM    956  N   HIS A  64      31.344 -28.031  -5.931  1.00  0.00           N  
ATOM    957  CA  HIS A  64      30.434 -27.123  -6.619  1.00  0.00           C  
ATOM    958  C   HIS A  64      29.580 -26.349  -5.618  1.00  0.00           C  
ATOM    959  O   HIS A  64      28.820 -26.937  -4.849  1.00  0.00           O  
ATOM    960  CB  HIS A  64      29.535 -27.898  -7.581  1.00  0.00           C  
ATOM    961  CG  HIS A  64      30.293 -28.711  -8.585  1.00  0.00           C  
ATOM    962  ND1 HIS A  64      30.163 -28.538  -9.947  1.00  0.00           N  
ATOM    963  CD2 HIS A  64      31.197 -29.706  -8.419  1.00  0.00           C  
ATOM    964  CE1 HIS A  64      30.952 -29.393 -10.574  1.00  0.00           C  
ATOM    965  NE2 HIS A  64      31.589 -30.113  -9.670  1.00  0.00           N  
ATOM    966  H   HIS A  64      31.184 -28.996  -5.980  1.00  0.00           H  
ATOM    967  HA  HIS A  64      31.030 -26.420  -7.182  1.00  0.00           H  
ATOM    968  HB2 HIS A  64      28.909 -28.572  -7.015  1.00  0.00           H  
ATOM    969  HB3 HIS A  64      28.910 -27.202  -8.122  1.00  0.00           H  
ATOM    970  HD1 HIS A  64      29.577 -27.888 -10.387  1.00  0.00           H  
ATOM    971  HD2 HIS A  64      31.543 -30.106  -7.476  1.00  0.00           H  
ATOM    972  HE1 HIS A  64      31.056 -29.486 -11.644  1.00  0.00           H  
ATOM    973  N   VAL A  65      29.710 -25.026  -5.634  1.00  0.00           N  
ATOM    974  CA  VAL A  65      28.951 -24.172  -4.729  1.00  0.00           C  
ATOM    975  C   VAL A  65      28.363 -22.974  -5.467  1.00  0.00           C  
ATOM    976  O   VAL A  65      28.690 -22.725  -6.627  1.00  0.00           O  
ATOM    977  CB  VAL A  65      29.826 -23.666  -3.568  1.00  0.00           C  
ATOM    978  CG1 VAL A  65      30.028 -24.763  -2.533  1.00  0.00           C  
ATOM    979  CG2 VAL A  65      31.164 -23.162  -4.089  1.00  0.00           C  
ATOM    980  H   VAL A  65      30.331 -24.615  -6.270  1.00  0.00           H  
ATOM    981  HA  VAL A  65      28.143 -24.759  -4.314  1.00  0.00           H  
ATOM    982  HB  VAL A  65      29.316 -22.842  -3.091  1.00  0.00           H  
ATOM    983 HG11 VAL A  65      29.757 -25.717  -2.963  1.00  0.00           H  
ATOM    984 HG12 VAL A  65      31.063 -24.785  -2.228  1.00  0.00           H  
ATOM    985 HG13 VAL A  65      29.403 -24.566  -1.674  1.00  0.00           H  
ATOM    986 HG21 VAL A  65      31.644 -23.943  -4.658  1.00  0.00           H  
ATOM    987 HG22 VAL A  65      31.002 -22.302  -4.722  1.00  0.00           H  
ATOM    988 HG23 VAL A  65      31.793 -22.883  -3.257  1.00  0.00           H  
ATOM    989  N   PHE A  66      27.493 -22.235  -4.786  1.00  0.00           N  
ATOM    990  CA  PHE A  66      26.859 -21.063  -5.377  1.00  0.00           C  
ATOM    991  C   PHE A  66      26.778 -19.921  -4.367  1.00  0.00           C  
ATOM    992  O   PHE A  66      26.171 -20.059  -3.306  1.00  0.00           O  
ATOM    993  CB  PHE A  66      25.457 -21.415  -5.879  1.00  0.00           C  
ATOM    994  CG  PHE A  66      24.589 -20.213  -6.124  1.00  0.00           C  
ATOM    995  CD1 PHE A  66      24.573 -19.595  -7.364  1.00  0.00           C  
ATOM    996  CD2 PHE A  66      23.789 -19.702  -5.114  1.00  0.00           C  
ATOM    997  CE1 PHE A  66      23.775 -18.489  -7.591  1.00  0.00           C  
ATOM    998  CE2 PHE A  66      22.990 -18.597  -5.336  1.00  0.00           C  
ATOM    999  CZ  PHE A  66      22.982 -17.990  -6.576  1.00  0.00           C  
ATOM   1000  H   PHE A  66      27.273 -22.485  -3.863  1.00  0.00           H  
ATOM   1001  HA  PHE A  66      27.462 -20.747  -6.213  1.00  0.00           H  
ATOM   1002  HB2 PHE A  66      25.540 -21.957  -6.808  1.00  0.00           H  
ATOM   1003  HB3 PHE A  66      24.966 -22.037  -5.147  1.00  0.00           H  
ATOM   1004  HD1 PHE A  66      25.191 -19.984  -8.159  1.00  0.00           H  
ATOM   1005  HD2 PHE A  66      23.795 -20.177  -4.142  1.00  0.00           H  
ATOM   1006  HE1 PHE A  66      23.770 -18.017  -8.562  1.00  0.00           H  
ATOM   1007  HE2 PHE A  66      22.371 -18.209  -4.540  1.00  0.00           H  
ATOM   1008  HZ  PHE A  66      22.359 -17.126  -6.752  1.00  0.00           H  
ATOM   1009  N   TYR A  67      27.395 -18.795  -4.707  1.00  0.00           N  
ATOM   1010  CA  TYR A  67      27.396 -17.630  -3.830  1.00  0.00           C  
ATOM   1011  C   TYR A  67      25.991 -17.050  -3.694  1.00  0.00           C  
ATOM   1012  O   TYR A  67      25.438 -16.502  -4.648  1.00  0.00           O  
ATOM   1013  CB  TYR A  67      28.350 -16.563  -4.367  1.00  0.00           C  
ATOM   1014  CG  TYR A  67      29.805 -16.970  -4.316  1.00  0.00           C  
ATOM   1015  CD1 TYR A  67      30.322 -17.892  -5.217  1.00  0.00           C  
ATOM   1016  CD2 TYR A  67      30.665 -16.432  -3.366  1.00  0.00           C  
ATOM   1017  CE1 TYR A  67      31.651 -18.269  -5.173  1.00  0.00           C  
ATOM   1018  CE2 TYR A  67      31.995 -16.801  -3.314  1.00  0.00           C  
ATOM   1019  CZ  TYR A  67      32.483 -17.720  -4.220  1.00  0.00           C  
ATOM   1020  OH  TYR A  67      33.807 -18.091  -4.174  1.00  0.00           O  
ATOM   1021  H   TYR A  67      27.861 -18.746  -5.568  1.00  0.00           H  
ATOM   1022  HA  TYR A  67      27.738 -17.948  -2.857  1.00  0.00           H  
ATOM   1023  HB2 TYR A  67      28.103 -16.352  -5.397  1.00  0.00           H  
ATOM   1024  HB3 TYR A  67      28.237 -15.661  -3.783  1.00  0.00           H  
ATOM   1025  HD1 TYR A  67      29.667 -18.320  -5.964  1.00  0.00           H  
ATOM   1026  HD2 TYR A  67      30.280 -15.713  -2.657  1.00  0.00           H  
ATOM   1027  HE1 TYR A  67      32.033 -18.988  -5.883  1.00  0.00           H  
ATOM   1028  HE2 TYR A  67      32.647 -16.372  -2.569  1.00  0.00           H  
ATOM   1029  HH  TYR A  67      34.204 -17.972  -5.040  1.00  0.00           H  
ATOM   1030  N   ILE A  68      25.422 -17.172  -2.500  1.00  0.00           N  
ATOM   1031  CA  ILE A  68      24.083 -16.659  -2.236  1.00  0.00           C  
ATOM   1032  C   ILE A  68      24.121 -15.173  -1.897  1.00  0.00           C  
ATOM   1033  O   ILE A  68      23.167 -14.627  -1.342  1.00  0.00           O  
ATOM   1034  CB  ILE A  68      23.405 -17.421  -1.082  1.00  0.00           C  
ATOM   1035  CG1 ILE A  68      23.960 -16.951   0.264  1.00  0.00           C  
ATOM   1036  CG2 ILE A  68      23.604 -18.920  -1.248  1.00  0.00           C  
ATOM   1037  CD1 ILE A  68      23.277 -17.587   1.455  1.00  0.00           C  
ATOM   1038  H   ILE A  68      25.914 -17.618  -1.779  1.00  0.00           H  
ATOM   1039  HA  ILE A  68      23.491 -16.798  -3.130  1.00  0.00           H  
ATOM   1040  HB  ILE A  68      22.346 -17.216  -1.118  1.00  0.00           H  
ATOM   1041 HG12 ILE A  68      25.010 -17.191   0.317  1.00  0.00           H  
ATOM   1042 HG13 ILE A  68      23.835 -15.880   0.342  1.00  0.00           H  
ATOM   1043 HG21 ILE A  68      22.652 -19.387  -1.460  1.00  0.00           H  
ATOM   1044 HG22 ILE A  68      24.284 -19.104  -2.066  1.00  0.00           H  
ATOM   1045 HG23 ILE A  68      24.013 -19.332  -0.339  1.00  0.00           H  
ATOM   1046 HD11 ILE A  68      24.015 -17.824   2.208  1.00  0.00           H  
ATOM   1047 HD12 ILE A  68      22.552 -16.901   1.863  1.00  0.00           H  
ATOM   1048 HD13 ILE A  68      22.781 -18.494   1.142  1.00  0.00           H  
ATOM   1049  N   ASP A  69      25.229 -14.523  -2.234  1.00  0.00           N  
ATOM   1050  CA  ASP A  69      25.392 -13.098  -1.967  1.00  0.00           C  
ATOM   1051  C   ASP A  69      25.380 -12.298  -3.266  1.00  0.00           C  
ATOM   1052  O   ASP A  69      24.909 -11.162  -3.301  1.00  0.00           O  
ATOM   1053  CB  ASP A  69      26.696 -12.844  -1.209  1.00  0.00           C  
ATOM   1054  CG  ASP A  69      26.792 -13.660   0.066  1.00  0.00           C  
ATOM   1055  OD1 ASP A  69      25.950 -13.455   0.964  1.00  0.00           O  
ATOM   1056  OD2 ASP A  69      27.710 -14.501   0.165  1.00  0.00           O  
ATOM   1057  H   ASP A  69      25.956 -15.013  -2.674  1.00  0.00           H  
ATOM   1058  HA  ASP A  69      24.562 -12.779  -1.355  1.00  0.00           H  
ATOM   1059  HB2 ASP A  69      27.530 -13.105  -1.844  1.00  0.00           H  
ATOM   1060  HB3 ASP A  69      26.757 -11.798  -0.952  1.00  0.00           H  
ATOM   1061  N   TYR A  70      25.904 -12.898  -4.329  1.00  0.00           N  
ATOM   1062  CA  TYR A  70      25.956 -12.240  -5.630  1.00  0.00           C  
ATOM   1063  C   TYR A  70      25.094 -12.977  -6.649  1.00  0.00           C  
ATOM   1064  O   TYR A  70      24.351 -12.362  -7.413  1.00  0.00           O  
ATOM   1065  CB  TYR A  70      27.401 -12.163  -6.127  1.00  0.00           C  
ATOM   1066  CG  TYR A  70      28.342 -11.494  -5.151  1.00  0.00           C  
ATOM   1067  CD1 TYR A  70      28.674 -12.104  -3.947  1.00  0.00           C  
ATOM   1068  CD2 TYR A  70      28.901 -10.254  -5.432  1.00  0.00           C  
ATOM   1069  CE1 TYR A  70      29.534 -11.497  -3.052  1.00  0.00           C  
ATOM   1070  CE2 TYR A  70      29.762  -9.640  -4.544  1.00  0.00           C  
ATOM   1071  CZ  TYR A  70      30.075 -10.265  -3.355  1.00  0.00           C  
ATOM   1072  OH  TYR A  70      30.932  -9.657  -2.466  1.00  0.00           O  
ATOM   1073  H   TYR A  70      26.263 -13.804  -4.239  1.00  0.00           H  
ATOM   1074  HA  TYR A  70      25.573 -11.237  -5.509  1.00  0.00           H  
ATOM   1075  HB2 TYR A  70      27.765 -13.162  -6.308  1.00  0.00           H  
ATOM   1076  HB3 TYR A  70      27.427 -11.602  -7.050  1.00  0.00           H  
ATOM   1077  HD1 TYR A  70      28.249 -13.069  -3.713  1.00  0.00           H  
ATOM   1078  HD2 TYR A  70      28.654  -9.766  -6.364  1.00  0.00           H  
ATOM   1079  HE1 TYR A  70      29.779 -11.986  -2.122  1.00  0.00           H  
ATOM   1080  HE2 TYR A  70      30.186  -8.675  -4.781  1.00  0.00           H  
ATOM   1081  HH  TYR A  70      30.680  -9.887  -1.569  1.00  0.00           H  
ATOM   1082  N   GLY A  71      25.199 -14.303  -6.655  1.00  0.00           N  
ATOM   1083  CA  GLY A  71      24.424 -15.105  -7.584  1.00  0.00           C  
ATOM   1084  C   GLY A  71      25.287 -15.764  -8.641  1.00  0.00           C  
ATOM   1085  O   GLY A  71      24.920 -15.804  -9.815  1.00  0.00           O  
ATOM   1086  H   GLY A  71      25.808 -14.740  -6.024  1.00  0.00           H  
ATOM   1087  HA2 GLY A  71      23.901 -15.871  -7.032  1.00  0.00           H  
ATOM   1088  HA3 GLY A  71      23.699 -14.469  -8.073  1.00  0.00           H  
ATOM   1089  N   ASN A  72      26.440 -16.280  -8.226  1.00  0.00           N  
ATOM   1090  CA  ASN A  72      27.359 -16.938  -9.147  1.00  0.00           C  
ATOM   1091  C   ASN A  72      27.737 -18.326  -8.638  1.00  0.00           C  
ATOM   1092  O   ASN A  72      27.442 -18.681  -7.498  1.00  0.00           O  
ATOM   1093  CB  ASN A  72      28.619 -16.090  -9.335  1.00  0.00           C  
ATOM   1094  CG  ASN A  72      29.237 -16.270 -10.708  1.00  0.00           C  
ATOM   1095  OD1 ASN A  72      28.664 -15.859 -11.717  1.00  0.00           O  
ATOM   1096  ND2 ASN A  72      30.412 -16.888 -10.751  1.00  0.00           N  
ATOM   1097  H   ASN A  72      26.678 -16.215  -7.277  1.00  0.00           H  
ATOM   1098  HA  ASN A  72      26.859 -17.039 -10.098  1.00  0.00           H  
ATOM   1099  HB2 ASN A  72      28.366 -15.047  -9.209  1.00  0.00           H  
ATOM   1100  HB3 ASN A  72      29.349 -16.371  -8.592  1.00  0.00           H  
ATOM   1101 HD21 ASN A  72      30.808 -17.188  -9.907  1.00  0.00           H  
ATOM   1102 HD22 ASN A  72      30.834 -17.017 -11.626  1.00  0.00           H  
ATOM   1103  N   ARG A  73      28.392 -19.105  -9.493  1.00  0.00           N  
ATOM   1104  CA  ARG A  73      28.810 -20.454  -9.131  1.00  0.00           C  
ATOM   1105  C   ARG A  73      30.297 -20.654  -9.407  1.00  0.00           C  
ATOM   1106  O   ARG A  73      30.822 -20.175 -10.411  1.00  0.00           O  
ATOM   1107  CB  ARG A  73      27.992 -21.489  -9.905  1.00  0.00           C  
ATOM   1108  CG  ARG A  73      26.512 -21.155  -9.992  1.00  0.00           C  
ATOM   1109  CD  ARG A  73      25.897 -21.682 -11.279  1.00  0.00           C  
ATOM   1110  NE  ARG A  73      26.282 -20.881 -12.439  1.00  0.00           N  
ATOM   1111  CZ  ARG A  73      25.725 -21.009 -13.638  1.00  0.00           C  
ATOM   1112  NH1 ARG A  73      24.765 -21.901 -13.835  1.00  0.00           N  
ATOM   1113  NH2 ARG A  73      26.130 -20.243 -14.643  1.00  0.00           N  
ATOM   1114  H   ARG A  73      28.598 -18.765 -10.389  1.00  0.00           H  
ATOM   1115  HA  ARG A  73      28.631 -20.584  -8.074  1.00  0.00           H  
ATOM   1116  HB2 ARG A  73      28.382 -21.560 -10.910  1.00  0.00           H  
ATOM   1117  HB3 ARG A  73      28.095 -22.447  -9.420  1.00  0.00           H  
ATOM   1118  HG2 ARG A  73      26.002 -21.603  -9.153  1.00  0.00           H  
ATOM   1119  HG3 ARG A  73      26.392 -20.082  -9.958  1.00  0.00           H  
ATOM   1120  HD2 ARG A  73      26.228 -22.699 -11.431  1.00  0.00           H  
ATOM   1121  HD3 ARG A  73      24.821 -21.665 -11.182  1.00  0.00           H  
ATOM   1122  HE  ARG A  73      26.990 -20.215 -12.315  1.00  0.00           H  
ATOM   1123 HH11 ARG A  73      24.458 -22.479 -13.079  1.00  0.00           H  
ATOM   1124 HH12 ARG A  73      24.347 -21.995 -14.738  1.00  0.00           H  
ATOM   1125 HH21 ARG A  73      26.854 -19.569 -14.498  1.00  0.00           H  
ATOM   1126 HH22 ARG A  73      25.711 -20.340 -15.545  1.00  0.00           H  
ATOM   1127  N   GLU A  74      30.970 -21.365  -8.507  1.00  0.00           N  
ATOM   1128  CA  GLU A  74      32.397 -21.628  -8.655  1.00  0.00           C  
ATOM   1129  C   GLU A  74      32.785 -22.930  -7.960  1.00  0.00           C  
ATOM   1130  O   GLU A  74      32.391 -23.181  -6.820  1.00  0.00           O  
ATOM   1131  CB  GLU A  74      33.213 -20.468  -8.080  1.00  0.00           C  
ATOM   1132  CG  GLU A  74      34.701 -20.566  -8.372  1.00  0.00           C  
ATOM   1133  CD  GLU A  74      35.058 -20.060  -9.756  1.00  0.00           C  
ATOM   1134  OE1 GLU A  74      35.221 -18.831  -9.913  1.00  0.00           O  
ATOM   1135  OE2 GLU A  74      35.174 -20.891 -10.681  1.00  0.00           O  
ATOM   1136  H   GLU A  74      30.496 -21.722  -7.727  1.00  0.00           H  
ATOM   1137  HA  GLU A  74      32.611 -21.719  -9.708  1.00  0.00           H  
ATOM   1138  HB2 GLU A  74      32.845 -19.542  -8.498  1.00  0.00           H  
ATOM   1139  HB3 GLU A  74      33.079 -20.446  -7.008  1.00  0.00           H  
ATOM   1140  HG2 GLU A  74      35.238 -19.981  -7.642  1.00  0.00           H  
ATOM   1141  HG3 GLU A  74      35.001 -21.601  -8.295  1.00  0.00           H  
ATOM   1142  N   VAL A  75      33.561 -23.756  -8.655  1.00  0.00           N  
ATOM   1143  CA  VAL A  75      34.003 -25.032  -8.106  1.00  0.00           C  
ATOM   1144  C   VAL A  75      35.281 -24.868  -7.292  1.00  0.00           C  
ATOM   1145  O   VAL A  75      36.381 -24.830  -7.843  1.00  0.00           O  
ATOM   1146  CB  VAL A  75      34.247 -26.068  -9.220  1.00  0.00           C  
ATOM   1147  CG1 VAL A  75      34.722 -27.387  -8.629  1.00  0.00           C  
ATOM   1148  CG2 VAL A  75      32.985 -26.268 -10.046  1.00  0.00           C  
ATOM   1149  H   VAL A  75      33.842 -23.501  -9.558  1.00  0.00           H  
ATOM   1150  HA  VAL A  75      33.222 -25.407  -7.460  1.00  0.00           H  
ATOM   1151  HB  VAL A  75      35.022 -25.690  -9.871  1.00  0.00           H  
ATOM   1152 HG11 VAL A  75      35.212 -27.968  -9.396  1.00  0.00           H  
ATOM   1153 HG12 VAL A  75      35.417 -27.191  -7.826  1.00  0.00           H  
ATOM   1154 HG13 VAL A  75      33.875 -27.936  -8.248  1.00  0.00           H  
ATOM   1155 HG21 VAL A  75      32.287 -25.472  -9.835  1.00  0.00           H  
ATOM   1156 HG22 VAL A  75      33.238 -26.257 -11.097  1.00  0.00           H  
ATOM   1157 HG23 VAL A  75      32.538 -27.218  -9.794  1.00  0.00           H  
ATOM   1158  N   LEU A  76      35.128 -24.768  -5.976  1.00  0.00           N  
ATOM   1159  CA  LEU A  76      36.271 -24.608  -5.083  1.00  0.00           C  
ATOM   1160  C   LEU A  76      36.445 -25.835  -4.194  1.00  0.00           C  
ATOM   1161  O   LEU A  76      35.490 -26.549  -3.887  1.00  0.00           O  
ATOM   1162  CB  LEU A  76      36.095 -23.358  -4.218  1.00  0.00           C  
ATOM   1163  CG  LEU A  76      35.677 -22.085  -4.955  1.00  0.00           C  
ATOM   1164  CD1 LEU A  76      34.865 -21.181  -4.041  1.00  0.00           C  
ATOM   1165  CD2 LEU A  76      36.899 -21.350  -5.486  1.00  0.00           C  
ATOM   1166  H   LEU A  76      34.227 -24.804  -5.594  1.00  0.00           H  
ATOM   1167  HA  LEU A  76      37.154 -24.492  -5.694  1.00  0.00           H  
ATOM   1168  HB2 LEU A  76      35.342 -23.572  -3.476  1.00  0.00           H  
ATOM   1169  HB3 LEU A  76      37.038 -23.162  -3.727  1.00  0.00           H  
ATOM   1170  HG  LEU A  76      35.055 -22.353  -5.798  1.00  0.00           H  
ATOM   1171 HD11 LEU A  76      33.842 -21.524  -4.014  1.00  0.00           H  
ATOM   1172 HD12 LEU A  76      34.896 -20.169  -4.416  1.00  0.00           H  
ATOM   1173 HD13 LEU A  76      35.281 -21.209  -3.045  1.00  0.00           H  
ATOM   1174 HD21 LEU A  76      37.337 -20.761  -4.693  1.00  0.00           H  
ATOM   1175 HD22 LEU A  76      36.604 -20.699  -6.296  1.00  0.00           H  
ATOM   1176 HD23 LEU A  76      37.624 -22.067  -5.844  1.00  0.00           H  
ATOM   1177  N   PRO A  77      37.691 -26.085  -3.767  1.00  0.00           N  
ATOM   1178  CA  PRO A  77      38.019 -27.225  -2.906  1.00  0.00           C  
ATOM   1179  C   PRO A  77      37.464 -27.062  -1.495  1.00  0.00           C  
ATOM   1180  O   PRO A  77      36.908 -26.018  -1.153  1.00  0.00           O  
ATOM   1181  CB  PRO A  77      39.550 -27.223  -2.881  1.00  0.00           C  
ATOM   1182  CG  PRO A  77      39.931 -25.811  -3.165  1.00  0.00           C  
ATOM   1183  CD  PRO A  77      38.877 -25.276  -4.095  1.00  0.00           C  
ATOM   1184  HA  PRO A  77      37.664 -28.155  -3.325  1.00  0.00           H  
ATOM   1185  HB2 PRO A  77      39.897 -27.540  -1.909  1.00  0.00           H  
ATOM   1186  HB3 PRO A  77      39.926 -27.893  -3.640  1.00  0.00           H  
ATOM   1187  HG2 PRO A  77      39.946 -25.243  -2.248  1.00  0.00           H  
ATOM   1188  HG3 PRO A  77      40.900 -25.782  -3.642  1.00  0.00           H  
ATOM   1189  HD2 PRO A  77      38.696 -24.229  -3.897  1.00  0.00           H  
ATOM   1190  HD3 PRO A  77      39.171 -25.422  -5.124  1.00  0.00           H  
ATOM   1191  N   SER A  78      37.621 -28.100  -0.678  1.00  0.00           N  
ATOM   1192  CA  SER A  78      37.132 -28.072   0.695  1.00  0.00           C  
ATOM   1193  C   SER A  78      38.050 -27.236   1.582  1.00  0.00           C  
ATOM   1194  O   SER A  78      37.830 -27.118   2.787  1.00  0.00           O  
ATOM   1195  CB  SER A  78      37.026 -29.495   1.249  1.00  0.00           C  
ATOM   1196  OG  SER A  78      38.278 -29.948   1.733  1.00  0.00           O  
ATOM   1197  H   SER A  78      38.073 -28.904  -1.010  1.00  0.00           H  
ATOM   1198  HA  SER A  78      36.150 -27.624   0.689  1.00  0.00           H  
ATOM   1199  HB2 SER A  78      36.313 -29.511   2.059  1.00  0.00           H  
ATOM   1200  HB3 SER A  78      36.694 -30.160   0.464  1.00  0.00           H  
ATOM   1201  HG  SER A  78      38.483 -30.800   1.342  1.00  0.00           H  
ATOM   1202  N   THR A  79      39.082 -26.657   0.975  1.00  0.00           N  
ATOM   1203  CA  THR A  79      40.035 -25.833   1.707  1.00  0.00           C  
ATOM   1204  C   THR A  79      39.542 -24.396   1.824  1.00  0.00           C  
ATOM   1205  O   THR A  79      39.721 -23.750   2.858  1.00  0.00           O  
ATOM   1206  CB  THR A  79      41.419 -25.837   1.030  1.00  0.00           C  
ATOM   1207  OG1 THR A  79      41.296 -25.418  -0.334  1.00  0.00           O  
ATOM   1208  CG2 THR A  79      42.045 -27.221   1.086  1.00  0.00           C  
ATOM   1209  H   THR A  79      39.204 -26.789   0.012  1.00  0.00           H  
ATOM   1210  HA  THR A  79      40.142 -26.249   2.699  1.00  0.00           H  
ATOM   1211  HB  THR A  79      42.061 -25.145   1.554  1.00  0.00           H  
ATOM   1212  HG1 THR A  79      42.097 -25.646  -0.812  1.00  0.00           H  
ATOM   1213 HG21 THR A  79      42.462 -27.468   0.121  1.00  0.00           H  
ATOM   1214 HG22 THR A  79      41.290 -27.948   1.349  1.00  0.00           H  
ATOM   1215 HG23 THR A  79      42.828 -27.232   1.829  1.00  0.00           H  
ATOM   1216  N   ARG A  80      38.921 -23.899   0.759  1.00  0.00           N  
ATOM   1217  CA  ARG A  80      38.403 -22.536   0.743  1.00  0.00           C  
ATOM   1218  C   ARG A  80      37.041 -22.465   1.427  1.00  0.00           C  
ATOM   1219  O   ARG A  80      36.466 -21.385   1.577  1.00  0.00           O  
ATOM   1220  CB  ARG A  80      38.292 -22.028  -0.695  1.00  0.00           C  
ATOM   1221  CG  ARG A  80      39.276 -22.683  -1.651  1.00  0.00           C  
ATOM   1222  CD  ARG A  80      39.582 -21.784  -2.839  1.00  0.00           C  
ATOM   1223  NE  ARG A  80      40.760 -22.233  -3.576  1.00  0.00           N  
ATOM   1224  CZ  ARG A  80      41.243 -21.604  -4.641  1.00  0.00           C  
ATOM   1225  NH1 ARG A  80      40.654 -20.504  -5.091  1.00  0.00           N  
ATOM   1226  NH2 ARG A  80      42.319 -22.075  -5.258  1.00  0.00           N  
ATOM   1227  H   ARG A  80      38.810 -24.462  -0.035  1.00  0.00           H  
ATOM   1228  HA  ARG A  80      39.098 -21.911   1.284  1.00  0.00           H  
ATOM   1229  HB2 ARG A  80      37.292 -22.219  -1.056  1.00  0.00           H  
ATOM   1230  HB3 ARG A  80      38.471 -20.963  -0.702  1.00  0.00           H  
ATOM   1231  HG2 ARG A  80      40.195 -22.887  -1.123  1.00  0.00           H  
ATOM   1232  HG3 ARG A  80      38.851 -23.608  -2.011  1.00  0.00           H  
ATOM   1233  HD2 ARG A  80      38.731 -21.785  -3.503  1.00  0.00           H  
ATOM   1234  HD3 ARG A  80      39.755 -20.781  -2.478  1.00  0.00           H  
ATOM   1235  HE  ARG A  80      41.210 -23.044  -3.261  1.00  0.00           H  
ATOM   1236 HH11 ARG A  80      39.844 -20.147  -4.627  1.00  0.00           H  
ATOM   1237 HH12 ARG A  80      41.022 -20.032  -5.892  1.00  0.00           H  
ATOM   1238 HH21 ARG A  80      42.767 -22.902  -4.922  1.00  0.00           H  
ATOM   1239 HH22 ARG A  80      42.683 -21.601  -6.060  1.00  0.00           H  
ATOM   1240  N   LEU A  81      36.530 -23.619   1.838  1.00  0.00           N  
ATOM   1241  CA  LEU A  81      35.235 -23.688   2.506  1.00  0.00           C  
ATOM   1242  C   LEU A  81      35.406 -23.822   4.015  1.00  0.00           C  
ATOM   1243  O   LEU A  81      36.299 -24.524   4.489  1.00  0.00           O  
ATOM   1244  CB  LEU A  81      34.423 -24.868   1.966  1.00  0.00           C  
ATOM   1245  CG  LEU A  81      34.121 -24.846   0.467  1.00  0.00           C  
ATOM   1246  CD1 LEU A  81      33.549 -26.181   0.018  1.00  0.00           C  
ATOM   1247  CD2 LEU A  81      33.162 -23.713   0.133  1.00  0.00           C  
ATOM   1248  H   LEU A  81      37.035 -24.446   1.691  1.00  0.00           H  
ATOM   1249  HA  LEU A  81      34.705 -22.772   2.296  1.00  0.00           H  
ATOM   1250  HB2 LEU A  81      34.972 -25.772   2.180  1.00  0.00           H  
ATOM   1251  HB3 LEU A  81      33.481 -24.888   2.495  1.00  0.00           H  
ATOM   1252  HG  LEU A  81      35.040 -24.678  -0.076  1.00  0.00           H  
ATOM   1253 HD11 LEU A  81      34.168 -26.594  -0.763  1.00  0.00           H  
ATOM   1254 HD12 LEU A  81      32.546 -26.036  -0.355  1.00  0.00           H  
ATOM   1255 HD13 LEU A  81      33.524 -26.863   0.857  1.00  0.00           H  
ATOM   1256 HD21 LEU A  81      33.436 -23.279  -0.817  1.00  0.00           H  
ATOM   1257 HD22 LEU A  81      33.215 -22.957   0.904  1.00  0.00           H  
ATOM   1258 HD23 LEU A  81      32.155 -24.099   0.076  1.00  0.00           H  
ATOM   1259  N   GLY A  82      34.543 -23.145   4.766  1.00  0.00           N  
ATOM   1260  CA  GLY A  82      34.614 -23.203   6.215  1.00  0.00           C  
ATOM   1261  C   GLY A  82      33.246 -23.148   6.866  1.00  0.00           C  
ATOM   1262  O   GLY A  82      32.239 -22.923   6.193  1.00  0.00           O  
ATOM   1263  H   GLY A  82      33.851 -22.601   4.333  1.00  0.00           H  
ATOM   1264  HA2 GLY A  82      35.102 -24.122   6.503  1.00  0.00           H  
ATOM   1265  HA3 GLY A  82      35.202 -22.369   6.568  1.00  0.00           H  
ATOM   1266  N   THR A  83      33.209 -23.355   8.178  1.00  0.00           N  
ATOM   1267  CA  THR A  83      31.954 -23.331   8.920  1.00  0.00           C  
ATOM   1268  C   THR A  83      31.374 -21.922   8.973  1.00  0.00           C  
ATOM   1269  O   THR A  83      31.979 -21.011   9.539  1.00  0.00           O  
ATOM   1270  CB  THR A  83      32.141 -23.851  10.357  1.00  0.00           C  
ATOM   1271  OG1 THR A  83      32.991 -25.002  10.355  1.00  0.00           O  
ATOM   1272  CG2 THR A  83      30.801 -24.205  10.983  1.00  0.00           C  
ATOM   1273  H   THR A  83      34.044 -23.529   8.658  1.00  0.00           H  
ATOM   1274  HA  THR A  83      31.254 -23.980   8.413  1.00  0.00           H  
ATOM   1275  HB  THR A  83      32.603 -23.073  10.948  1.00  0.00           H  
ATOM   1276  HG1 THR A  83      32.954 -25.430  11.214  1.00  0.00           H  
ATOM   1277 HG21 THR A  83      30.318 -24.969  10.393  1.00  0.00           H  
ATOM   1278 HG22 THR A  83      30.175 -23.326  11.015  1.00  0.00           H  
ATOM   1279 HG23 THR A  83      30.958 -24.573  11.987  1.00  0.00           H  
ATOM   1280  N   LEU A  84      30.197 -21.750   8.381  1.00  0.00           N  
ATOM   1281  CA  LEU A  84      29.533 -20.451   8.360  1.00  0.00           C  
ATOM   1282  C   LEU A  84      28.893 -20.146   9.711  1.00  0.00           C  
ATOM   1283  O   LEU A  84      27.925 -20.794  10.110  1.00  0.00           O  
ATOM   1284  CB  LEU A  84      28.472 -20.415   7.259  1.00  0.00           C  
ATOM   1285  CG  LEU A  84      27.465 -19.268   7.336  1.00  0.00           C  
ATOM   1286  CD1 LEU A  84      28.180 -17.926   7.290  1.00  0.00           C  
ATOM   1287  CD2 LEU A  84      26.451 -19.372   6.206  1.00  0.00           C  
ATOM   1288  H   LEU A  84      29.763 -22.514   7.946  1.00  0.00           H  
ATOM   1289  HA  LEU A  84      30.281 -19.700   8.153  1.00  0.00           H  
ATOM   1290  HB2 LEU A  84      28.982 -20.345   6.311  1.00  0.00           H  
ATOM   1291  HB3 LEU A  84      27.921 -21.344   7.302  1.00  0.00           H  
ATOM   1292  HG  LEU A  84      26.929 -19.328   8.273  1.00  0.00           H  
ATOM   1293 HD11 LEU A  84      27.565 -17.208   6.768  1.00  0.00           H  
ATOM   1294 HD12 LEU A  84      29.121 -18.037   6.773  1.00  0.00           H  
ATOM   1295 HD13 LEU A  84      28.361 -17.580   8.297  1.00  0.00           H  
ATOM   1296 HD21 LEU A  84      26.783 -18.778   5.367  1.00  0.00           H  
ATOM   1297 HD22 LEU A  84      25.492 -19.007   6.547  1.00  0.00           H  
ATOM   1298 HD23 LEU A  84      26.356 -20.404   5.902  1.00  0.00           H  
ATOM   1299  N   SER A  85      29.437 -19.155  10.409  1.00  0.00           N  
ATOM   1300  CA  SER A  85      28.920 -18.764  11.714  1.00  0.00           C  
ATOM   1301  C   SER A  85      27.447 -18.378  11.622  1.00  0.00           C  
ATOM   1302  O   SER A  85      26.990 -17.806  10.633  1.00  0.00           O  
ATOM   1303  CB  SER A  85      29.731 -17.597  12.280  1.00  0.00           C  
ATOM   1304  OG  SER A  85      29.172 -17.130  13.496  1.00  0.00           O  
ATOM   1305  H   SER A  85      30.208 -18.676  10.037  1.00  0.00           H  
ATOM   1306  HA  SER A  85      29.016 -19.613  12.376  1.00  0.00           H  
ATOM   1307  HB2 SER A  85      30.744 -17.922  12.466  1.00  0.00           H  
ATOM   1308  HB3 SER A  85      29.737 -16.787  11.565  1.00  0.00           H  
ATOM   1309  HG  SER A  85      28.739 -16.287  13.346  1.00  0.00           H  
ATOM   1310  N   PRO A  86      26.685 -18.697  12.679  1.00  0.00           N  
ATOM   1311  CA  PRO A  86      25.253 -18.392  12.743  1.00  0.00           C  
ATOM   1312  C   PRO A  86      24.983 -16.897  12.875  1.00  0.00           C  
ATOM   1313  O   PRO A  86      23.901 -16.419  12.536  1.00  0.00           O  
ATOM   1314  CB  PRO A  86      24.787 -19.133  13.999  1.00  0.00           C  
ATOM   1315  CG  PRO A  86      26.007 -19.244  14.847  1.00  0.00           C  
ATOM   1316  CD  PRO A  86      27.163 -19.379  13.893  1.00  0.00           C  
ATOM   1317  HA  PRO A  86      24.726 -18.776  11.880  1.00  0.00           H  
ATOM   1318  HB2 PRO A  86      24.013 -18.561  14.491  1.00  0.00           H  
ATOM   1319  HB3 PRO A  86      24.406 -20.106  13.726  1.00  0.00           H  
ATOM   1320  HG2 PRO A  86      26.120 -18.355  15.447  1.00  0.00           H  
ATOM   1321  HG3 PRO A  86      25.938 -20.119  15.476  1.00  0.00           H  
ATOM   1322  HD2 PRO A  86      28.039 -18.889  14.291  1.00  0.00           H  
ATOM   1323  HD3 PRO A  86      27.368 -20.420  13.694  1.00  0.00           H  
ATOM   1324  N   ALA A  87      25.975 -16.163  13.370  1.00  0.00           N  
ATOM   1325  CA  ALA A  87      25.845 -14.723  13.545  1.00  0.00           C  
ATOM   1326  C   ALA A  87      25.895 -13.999  12.203  1.00  0.00           C  
ATOM   1327  O   ALA A  87      25.234 -12.979  12.010  1.00  0.00           O  
ATOM   1328  CB  ALA A  87      26.937 -14.203  14.468  1.00  0.00           C  
ATOM   1329  H   ALA A  87      26.814 -16.602  13.622  1.00  0.00           H  
ATOM   1330  HA  ALA A  87      24.890 -14.527  14.011  1.00  0.00           H  
ATOM   1331  HB1 ALA A  87      27.874 -14.680  14.221  1.00  0.00           H  
ATOM   1332  HB2 ALA A  87      27.033 -13.134  14.345  1.00  0.00           H  
ATOM   1333  HB3 ALA A  87      26.678 -14.425  15.493  1.00  0.00           H  
ATOM   1334  N   PHE A  88      26.685 -14.535  11.277  1.00  0.00           N  
ATOM   1335  CA  PHE A  88      26.824 -13.939   9.954  1.00  0.00           C  
ATOM   1336  C   PHE A  88      26.012 -14.716   8.921  1.00  0.00           C  
ATOM   1337  O   PHE A  88      25.855 -14.277   7.781  1.00  0.00           O  
ATOM   1338  CB  PHE A  88      28.296 -13.902   9.539  1.00  0.00           C  
ATOM   1339  CG  PHE A  88      29.205 -13.353  10.602  1.00  0.00           C  
ATOM   1340  CD1 PHE A  88      28.969 -12.106  11.158  1.00  0.00           C  
ATOM   1341  CD2 PHE A  88      30.295 -14.086  11.046  1.00  0.00           C  
ATOM   1342  CE1 PHE A  88      29.803 -11.599  12.136  1.00  0.00           C  
ATOM   1343  CE2 PHE A  88      31.131 -13.583  12.025  1.00  0.00           C  
ATOM   1344  CZ  PHE A  88      30.887 -12.338  12.569  1.00  0.00           C  
ATOM   1345  H   PHE A  88      27.188 -15.349  11.491  1.00  0.00           H  
ATOM   1346  HA  PHE A  88      26.448 -12.929  10.004  1.00  0.00           H  
ATOM   1347  HB2 PHE A  88      28.623 -14.905   9.308  1.00  0.00           H  
ATOM   1348  HB3 PHE A  88      28.399 -13.283   8.660  1.00  0.00           H  
ATOM   1349  HD1 PHE A  88      28.122 -11.527  10.818  1.00  0.00           H  
ATOM   1350  HD2 PHE A  88      30.488 -15.060  10.620  1.00  0.00           H  
ATOM   1351  HE1 PHE A  88      29.609 -10.624  12.559  1.00  0.00           H  
ATOM   1352  HE2 PHE A  88      31.977 -14.164  12.361  1.00  0.00           H  
ATOM   1353  HZ  PHE A  88      31.538 -11.944  13.335  1.00  0.00           H  
ATOM   1354  N   SER A  89      25.500 -15.872   9.327  1.00  0.00           N  
ATOM   1355  CA  SER A  89      24.709 -16.713   8.437  1.00  0.00           C  
ATOM   1356  C   SER A  89      23.553 -15.923   7.828  1.00  0.00           C  
ATOM   1357  O   SER A  89      23.022 -15.000   8.446  1.00  0.00           O  
ATOM   1358  CB  SER A  89      24.167 -17.927   9.194  1.00  0.00           C  
ATOM   1359  OG  SER A  89      22.937 -18.366   8.644  1.00  0.00           O  
ATOM   1360  H   SER A  89      25.660 -16.169  10.248  1.00  0.00           H  
ATOM   1361  HA  SER A  89      25.354 -17.055   7.643  1.00  0.00           H  
ATOM   1362  HB2 SER A  89      24.882 -18.733   9.134  1.00  0.00           H  
ATOM   1363  HB3 SER A  89      24.009 -17.661  10.230  1.00  0.00           H  
ATOM   1364  HG  SER A  89      23.106 -19.033   7.974  1.00  0.00           H  
ATOM   1365  N   THR A  90      23.168 -16.294   6.611  1.00  0.00           N  
ATOM   1366  CA  THR A  90      22.078 -15.620   5.917  1.00  0.00           C  
ATOM   1367  C   THR A  90      20.828 -15.557   6.787  1.00  0.00           C  
ATOM   1368  O   THR A  90      19.915 -14.775   6.521  1.00  0.00           O  
ATOM   1369  CB  THR A  90      21.733 -16.329   4.592  1.00  0.00           C  
ATOM   1370  OG1 THR A  90      20.783 -15.552   3.855  1.00  0.00           O  
ATOM   1371  CG2 THR A  90      21.168 -17.717   4.853  1.00  0.00           C  
ATOM   1372  H   THR A  90      23.630 -17.037   6.170  1.00  0.00           H  
ATOM   1373  HA  THR A  90      22.399 -14.614   5.689  1.00  0.00           H  
ATOM   1374  HB  THR A  90      22.637 -16.427   4.009  1.00  0.00           H  
ATOM   1375  HG1 THR A  90      21.244 -14.883   3.344  1.00  0.00           H  
ATOM   1376 HG21 THR A  90      20.160 -17.631   5.232  1.00  0.00           H  
ATOM   1377 HG22 THR A  90      21.784 -18.225   5.579  1.00  0.00           H  
ATOM   1378 HG23 THR A  90      21.159 -18.280   3.932  1.00  0.00           H  
ATOM   1379  N   ARG A  91      20.793 -16.384   7.826  1.00  0.00           N  
ATOM   1380  CA  ARG A  91      19.655 -16.421   8.735  1.00  0.00           C  
ATOM   1381  C   ARG A  91      19.270 -15.014   9.184  1.00  0.00           C  
ATOM   1382  O   ARG A  91      18.114 -14.752   9.517  1.00  0.00           O  
ATOM   1383  CB  ARG A  91      19.977 -17.288   9.955  1.00  0.00           C  
ATOM   1384  CG  ARG A  91      19.643 -18.758   9.763  1.00  0.00           C  
ATOM   1385  CD  ARG A  91      19.765 -19.531  11.067  1.00  0.00           C  
ATOM   1386  NE  ARG A  91      21.117 -20.041  11.276  1.00  0.00           N  
ATOM   1387  CZ  ARG A  91      21.610 -21.097  10.639  1.00  0.00           C  
ATOM   1388  NH1 ARG A  91      20.867 -21.750   9.756  1.00  0.00           N  
ATOM   1389  NH2 ARG A  91      22.851 -21.501  10.882  1.00  0.00           N  
ATOM   1390  H   ARG A  91      21.552 -16.984   7.986  1.00  0.00           H  
ATOM   1391  HA  ARG A  91      18.821 -16.858   8.206  1.00  0.00           H  
ATOM   1392  HB2 ARG A  91      21.032 -17.206  10.171  1.00  0.00           H  
ATOM   1393  HB3 ARG A  91      19.414 -16.919  10.800  1.00  0.00           H  
ATOM   1394  HG2 ARG A  91      18.628 -18.843   9.401  1.00  0.00           H  
ATOM   1395  HG3 ARG A  91      20.322 -19.180   9.039  1.00  0.00           H  
ATOM   1396  HD2 ARG A  91      19.507 -18.874  11.885  1.00  0.00           H  
ATOM   1397  HD3 ARG A  91      19.075 -20.362  11.042  1.00  0.00           H  
ATOM   1398  HE  ARG A  91      21.683 -19.573  11.924  1.00  0.00           H  
ATOM   1399 HH11 ARG A  91      19.933 -21.447   9.570  1.00  0.00           H  
ATOM   1400 HH12 ARG A  91      21.242 -22.545   9.278  1.00  0.00           H  
ATOM   1401 HH21 ARG A  91      23.415 -21.010  11.547  1.00  0.00           H  
ATOM   1402 HH22 ARG A  91      23.221 -22.295  10.403  1.00  0.00           H  
ATOM   1403  N   VAL A  92      20.247 -14.113   9.191  1.00  0.00           N  
ATOM   1404  CA  VAL A  92      20.012 -12.733   9.598  1.00  0.00           C  
ATOM   1405  C   VAL A  92      19.731 -11.845   8.391  1.00  0.00           C  
ATOM   1406  O   VAL A  92      18.872 -10.963   8.442  1.00  0.00           O  
ATOM   1407  CB  VAL A  92      21.215 -12.163  10.372  1.00  0.00           C  
ATOM   1408  CG1 VAL A  92      20.818 -10.903  11.124  1.00  0.00           C  
ATOM   1409  CG2 VAL A  92      21.779 -13.207  11.324  1.00  0.00           C  
ATOM   1410  H   VAL A  92      21.149 -14.384   8.914  1.00  0.00           H  
ATOM   1411  HA  VAL A  92      19.152 -12.720  10.251  1.00  0.00           H  
ATOM   1412  HB  VAL A  92      21.985 -11.904   9.660  1.00  0.00           H  
ATOM   1413 HG11 VAL A  92      20.261 -10.252  10.466  1.00  0.00           H  
ATOM   1414 HG12 VAL A  92      20.206 -11.167  11.973  1.00  0.00           H  
ATOM   1415 HG13 VAL A  92      21.706 -10.392  11.465  1.00  0.00           H  
ATOM   1416 HG21 VAL A  92      22.756 -12.897  11.661  1.00  0.00           H  
ATOM   1417 HG22 VAL A  92      21.121 -13.310  12.176  1.00  0.00           H  
ATOM   1418 HG23 VAL A  92      21.858 -14.155  10.814  1.00  0.00           H  
ATOM   1419  N   LEU A  93      20.460 -12.083   7.306  1.00  0.00           N  
ATOM   1420  CA  LEU A  93      20.289 -11.304   6.084  1.00  0.00           C  
ATOM   1421  C   LEU A  93      19.901 -12.204   4.915  1.00  0.00           C  
ATOM   1422  O   LEU A  93      20.454 -13.286   4.723  1.00  0.00           O  
ATOM   1423  CB  LEU A  93      21.576 -10.546   5.754  1.00  0.00           C  
ATOM   1424  CG  LEU A  93      21.427  -9.344   4.821  1.00  0.00           C  
ATOM   1425  CD1 LEU A  93      20.653  -8.228   5.506  1.00  0.00           C  
ATOM   1426  CD2 LEU A  93      22.792  -8.848   4.367  1.00  0.00           C  
ATOM   1427  H   LEU A  93      21.129 -12.798   7.326  1.00  0.00           H  
ATOM   1428  HA  LEU A  93      19.494 -10.592   6.254  1.00  0.00           H  
ATOM   1429  HB2 LEU A  93      21.999 -10.193   6.683  1.00  0.00           H  
ATOM   1430  HB3 LEU A  93      22.260 -11.243   5.292  1.00  0.00           H  
ATOM   1431  HG  LEU A  93      20.870  -9.645   3.944  1.00  0.00           H  
ATOM   1432 HD11 LEU A  93      19.833  -7.919   4.876  1.00  0.00           H  
ATOM   1433 HD12 LEU A  93      21.311  -7.388   5.679  1.00  0.00           H  
ATOM   1434 HD13 LEU A  93      20.269  -8.584   6.451  1.00  0.00           H  
ATOM   1435 HD21 LEU A  93      23.425  -8.698   5.230  1.00  0.00           H  
ATOM   1436 HD22 LEU A  93      22.678  -7.915   3.837  1.00  0.00           H  
ATOM   1437 HD23 LEU A  93      23.243  -9.581   3.714  1.00  0.00           H  
ATOM   1438  N   PRO A  94      18.929 -11.746   4.112  1.00  0.00           N  
ATOM   1439  CA  PRO A  94      18.448 -12.492   2.946  1.00  0.00           C  
ATOM   1440  C   PRO A  94      19.482 -12.547   1.826  1.00  0.00           C  
ATOM   1441  O   PRO A  94      20.197 -11.577   1.582  1.00  0.00           O  
ATOM   1442  CB  PRO A  94      17.217 -11.699   2.500  1.00  0.00           C  
ATOM   1443  CG  PRO A  94      17.459 -10.315   2.996  1.00  0.00           C  
ATOM   1444  CD  PRO A  94      18.225 -10.463   4.281  1.00  0.00           C  
ATOM   1445  HA  PRO A  94      18.153 -13.496   3.212  1.00  0.00           H  
ATOM   1446  HB2 PRO A  94      17.140 -11.725   1.422  1.00  0.00           H  
ATOM   1447  HB3 PRO A  94      16.330 -12.126   2.941  1.00  0.00           H  
ATOM   1448  HG2 PRO A  94      18.040  -9.762   2.274  1.00  0.00           H  
ATOM   1449  HG3 PRO A  94      16.516  -9.820   3.177  1.00  0.00           H  
ATOM   1450  HD2 PRO A  94      18.927  -9.650   4.398  1.00  0.00           H  
ATOM   1451  HD3 PRO A  94      17.548 -10.504   5.122  1.00  0.00           H  
ATOM   1452  N   ALA A  95      19.553 -13.688   1.150  1.00  0.00           N  
ATOM   1453  CA  ALA A  95      20.497 -13.868   0.053  1.00  0.00           C  
ATOM   1454  C   ALA A  95      20.270 -12.833  -1.043  1.00  0.00           C  
ATOM   1455  O   ALA A  95      19.200 -12.782  -1.648  1.00  0.00           O  
ATOM   1456  CB  ALA A  95      20.384 -15.275  -0.515  1.00  0.00           C  
ATOM   1457  H   ALA A  95      18.955 -14.426   1.392  1.00  0.00           H  
ATOM   1458  HA  ALA A  95      21.496 -13.745   0.449  1.00  0.00           H  
ATOM   1459  HB1 ALA A  95      19.342 -15.523  -0.655  1.00  0.00           H  
ATOM   1460  HB2 ALA A  95      20.896 -15.322  -1.464  1.00  0.00           H  
ATOM   1461  HB3 ALA A  95      20.833 -15.977   0.171  1.00  0.00           H  
ATOM   1462  N   GLN A  96      21.283 -12.010  -1.292  1.00  0.00           N  
ATOM   1463  CA  GLN A  96      21.192 -10.975  -2.315  1.00  0.00           C  
ATOM   1464  C   GLN A  96      21.539 -11.536  -3.691  1.00  0.00           C  
ATOM   1465  O   GLN A  96      21.515 -10.817  -4.689  1.00  0.00           O  
ATOM   1466  CB  GLN A  96      22.125  -9.810  -1.977  1.00  0.00           C  
ATOM   1467  CG  GLN A  96      21.891  -9.226  -0.593  1.00  0.00           C  
ATOM   1468  CD  GLN A  96      20.500  -8.644  -0.433  1.00  0.00           C  
ATOM   1469  OE1 GLN A  96      20.020  -7.906  -1.294  1.00  0.00           O  
ATOM   1470  NE2 GLN A  96      19.844  -8.975   0.672  1.00  0.00           N  
ATOM   1471  H   GLN A  96      22.111 -12.101  -0.776  1.00  0.00           H  
ATOM   1472  HA  GLN A  96      20.174 -10.616  -2.333  1.00  0.00           H  
ATOM   1473  HB2 GLN A  96      23.147 -10.156  -2.030  1.00  0.00           H  
ATOM   1474  HB3 GLN A  96      21.980  -9.026  -2.705  1.00  0.00           H  
ATOM   1475  HG2 GLN A  96      22.024 -10.006   0.141  1.00  0.00           H  
ATOM   1476  HG3 GLN A  96      22.615  -8.443  -0.421  1.00  0.00           H  
ATOM   1477 HE21 GLN A  96      20.289  -9.568   1.315  1.00  0.00           H  
ATOM   1478 HE22 GLN A  96      18.943  -8.614   0.802  1.00  0.00           H  
ATOM   1479  N   ALA A  97      21.861 -12.825  -3.733  1.00  0.00           N  
ATOM   1480  CA  ALA A  97      22.210 -13.483  -4.987  1.00  0.00           C  
ATOM   1481  C   ALA A  97      21.072 -13.381  -5.996  1.00  0.00           C  
ATOM   1482  O   ALA A  97      19.897 -13.421  -5.630  1.00  0.00           O  
ATOM   1483  CB  ALA A  97      22.566 -14.941  -4.736  1.00  0.00           C  
ATOM   1484  H   ALA A  97      21.861 -13.345  -2.904  1.00  0.00           H  
ATOM   1485  HA  ALA A  97      23.082 -12.989  -5.391  1.00  0.00           H  
ATOM   1486  HB1 ALA A  97      23.640 -15.058  -4.762  1.00  0.00           H  
ATOM   1487  HB2 ALA A  97      22.195 -15.240  -3.767  1.00  0.00           H  
ATOM   1488  HB3 ALA A  97      22.118 -15.558  -5.500  1.00  0.00           H  
ATOM   1489  N   THR A  98      21.428 -13.248  -7.270  1.00  0.00           N  
ATOM   1490  CA  THR A  98      20.437 -13.138  -8.333  1.00  0.00           C  
ATOM   1491  C   THR A  98      19.931 -14.512  -8.758  1.00  0.00           C  
ATOM   1492  O   THR A  98      18.726 -14.756  -8.792  1.00  0.00           O  
ATOM   1493  CB  THR A  98      21.011 -12.413  -9.564  1.00  0.00           C  
ATOM   1494  OG1 THR A  98      21.088 -11.005  -9.312  1.00  0.00           O  
ATOM   1495  CG2 THR A  98      20.150 -12.665 -10.792  1.00  0.00           C  
ATOM   1496  H   THR A  98      22.380 -13.222  -7.500  1.00  0.00           H  
ATOM   1497  HA  THR A  98      19.606 -12.561  -7.955  1.00  0.00           H  
ATOM   1498  HB  THR A  98      22.005 -12.792  -9.756  1.00  0.00           H  
ATOM   1499  HG1 THR A  98      20.360 -10.741  -8.743  1.00  0.00           H  
ATOM   1500 HG21 THR A  98      20.572 -12.149 -11.642  1.00  0.00           H  
ATOM   1501 HG22 THR A  98      19.149 -12.302 -10.611  1.00  0.00           H  
ATOM   1502 HG23 THR A  98      20.117 -13.724 -10.996  1.00  0.00           H  
ATOM   1503  N   GLU A  99      20.861 -15.407  -9.079  1.00  0.00           N  
ATOM   1504  CA  GLU A  99      20.508 -16.757  -9.503  1.00  0.00           C  
ATOM   1505  C   GLU A  99      20.294 -17.666  -8.295  1.00  0.00           C  
ATOM   1506  O   GLU A  99      20.480 -18.881  -8.379  1.00  0.00           O  
ATOM   1507  CB  GLU A  99      21.600 -17.335 -10.404  1.00  0.00           C  
ATOM   1508  CG  GLU A  99      21.661 -16.690 -11.777  1.00  0.00           C  
ATOM   1509  CD  GLU A  99      22.813 -17.210 -12.616  1.00  0.00           C  
ATOM   1510  OE1 GLU A  99      23.774 -17.755 -12.034  1.00  0.00           O  
ATOM   1511  OE2 GLU A  99      22.752 -17.072 -13.856  1.00  0.00           O  
ATOM   1512  H   GLU A  99      21.807 -15.152  -9.032  1.00  0.00           H  
ATOM   1513  HA  GLU A  99      19.586 -16.698 -10.062  1.00  0.00           H  
ATOM   1514  HB2 GLU A  99      22.558 -17.199  -9.922  1.00  0.00           H  
ATOM   1515  HB3 GLU A  99      21.420 -18.392 -10.533  1.00  0.00           H  
ATOM   1516  HG2 GLU A  99      20.737 -16.892 -12.298  1.00  0.00           H  
ATOM   1517  HG3 GLU A  99      21.777 -15.623 -11.655  1.00  0.00           H  
ATOM   1518  N   TYR A 100      19.903 -17.069  -7.175  1.00  0.00           N  
ATOM   1519  CA  TYR A 100      19.667 -17.824  -5.950  1.00  0.00           C  
ATOM   1520  C   TYR A 100      18.364 -18.612  -6.038  1.00  0.00           C  
ATOM   1521  O   TYR A 100      18.335 -19.815  -5.780  1.00  0.00           O  
ATOM   1522  CB  TYR A 100      19.626 -16.882  -4.745  1.00  0.00           C  
ATOM   1523  CG  TYR A 100      19.047 -17.515  -3.500  1.00  0.00           C  
ATOM   1524  CD1 TYR A 100      19.704 -18.559  -2.859  1.00  0.00           C  
ATOM   1525  CD2 TYR A 100      17.845 -17.069  -2.965  1.00  0.00           C  
ATOM   1526  CE1 TYR A 100      19.178 -19.141  -1.721  1.00  0.00           C  
ATOM   1527  CE2 TYR A 100      17.314 -17.645  -1.827  1.00  0.00           C  
ATOM   1528  CZ  TYR A 100      17.983 -18.681  -1.209  1.00  0.00           C  
ATOM   1529  OH  TYR A 100      17.458 -19.257  -0.076  1.00  0.00           O  
ATOM   1530  H   TYR A 100      19.772 -16.098  -7.170  1.00  0.00           H  
ATOM   1531  HA  TYR A 100      20.487 -18.517  -5.824  1.00  0.00           H  
ATOM   1532  HB2 TYR A 100      20.629 -16.557  -4.516  1.00  0.00           H  
ATOM   1533  HB3 TYR A 100      19.021 -16.021  -4.992  1.00  0.00           H  
ATOM   1534  HD1 TYR A 100      20.640 -18.917  -3.262  1.00  0.00           H  
ATOM   1535  HD2 TYR A 100      17.322 -16.259  -3.451  1.00  0.00           H  
ATOM   1536  HE1 TYR A 100      19.703 -19.951  -1.238  1.00  0.00           H  
ATOM   1537  HE2 TYR A 100      16.377 -17.285  -1.425  1.00  0.00           H  
ATOM   1538  HH  TYR A 100      17.338 -20.198  -0.221  1.00  0.00           H  
ATOM   1539  N   ALA A 101      17.288 -17.924  -6.404  1.00  0.00           N  
ATOM   1540  CA  ALA A 101      15.982 -18.559  -6.531  1.00  0.00           C  
ATOM   1541  C   ALA A 101      16.066 -19.826  -7.376  1.00  0.00           C  
ATOM   1542  O   ALA A 101      15.298 -20.768  -7.179  1.00  0.00           O  
ATOM   1543  CB  ALA A 101      14.978 -17.587  -7.132  1.00  0.00           C  
ATOM   1544  H   ALA A 101      17.375 -16.967  -6.597  1.00  0.00           H  
ATOM   1545  HA  ALA A 101      15.642 -18.822  -5.538  1.00  0.00           H  
ATOM   1546  HB1 ALA A 101      15.070 -17.594  -8.208  1.00  0.00           H  
ATOM   1547  HB2 ALA A 101      13.978 -17.884  -6.853  1.00  0.00           H  
ATOM   1548  HB3 ALA A 101      15.174 -16.591  -6.761  1.00  0.00           H  
ATOM   1549  N   PHE A 102      17.002 -19.840  -8.319  1.00  0.00           N  
ATOM   1550  CA  PHE A 102      17.184 -20.991  -9.196  1.00  0.00           C  
ATOM   1551  C   PHE A 102      18.269 -21.919  -8.658  1.00  0.00           C  
ATOM   1552  O   PHE A 102      18.320 -23.100  -9.002  1.00  0.00           O  
ATOM   1553  CB  PHE A 102      17.548 -20.529 -10.608  1.00  0.00           C  
ATOM   1554  CG  PHE A 102      16.488 -19.683 -11.255  1.00  0.00           C  
ATOM   1555  CD1 PHE A 102      15.210 -20.180 -11.452  1.00  0.00           C  
ATOM   1556  CD2 PHE A 102      16.770 -18.390 -11.663  1.00  0.00           C  
ATOM   1557  CE1 PHE A 102      14.232 -19.404 -12.045  1.00  0.00           C  
ATOM   1558  CE2 PHE A 102      15.797 -17.609 -12.257  1.00  0.00           C  
ATOM   1559  CZ  PHE A 102      14.527 -18.116 -12.449  1.00  0.00           C  
ATOM   1560  H   PHE A 102      17.583 -19.059  -8.428  1.00  0.00           H  
ATOM   1561  HA  PHE A 102      16.251 -21.531  -9.232  1.00  0.00           H  
ATOM   1562  HB2 PHE A 102      18.456 -19.948 -10.567  1.00  0.00           H  
ATOM   1563  HB3 PHE A 102      17.708 -21.396 -11.233  1.00  0.00           H  
ATOM   1564  HD1 PHE A 102      14.980 -21.188 -11.136  1.00  0.00           H  
ATOM   1565  HD2 PHE A 102      17.763 -17.991 -11.515  1.00  0.00           H  
ATOM   1566  HE1 PHE A 102      13.241 -19.804 -12.194  1.00  0.00           H  
ATOM   1567  HE2 PHE A 102      16.029 -16.602 -12.572  1.00  0.00           H  
ATOM   1568  HZ  PHE A 102      13.764 -17.507 -12.911  1.00  0.00           H  
ATOM   1569  N   ALA A 103      19.137 -21.376  -7.810  1.00  0.00           N  
ATOM   1570  CA  ALA A 103      20.220 -22.153  -7.222  1.00  0.00           C  
ATOM   1571  C   ALA A 103      19.702 -23.464  -6.640  1.00  0.00           C  
ATOM   1572  O   ALA A 103      20.350 -24.505  -6.756  1.00  0.00           O  
ATOM   1573  CB  ALA A 103      20.931 -21.342  -6.149  1.00  0.00           C  
ATOM   1574  H   ALA A 103      19.045 -20.429  -7.574  1.00  0.00           H  
ATOM   1575  HA  ALA A 103      20.934 -22.375  -8.002  1.00  0.00           H  
ATOM   1576  HB1 ALA A 103      21.380 -20.468  -6.598  1.00  0.00           H  
ATOM   1577  HB2 ALA A 103      20.217 -21.035  -5.398  1.00  0.00           H  
ATOM   1578  HB3 ALA A 103      21.699 -21.946  -5.691  1.00  0.00           H  
ATOM   1579  N   PHE A 104      18.532 -23.406  -6.014  1.00  0.00           N  
ATOM   1580  CA  PHE A 104      17.928 -24.589  -5.411  1.00  0.00           C  
ATOM   1581  C   PHE A 104      16.407 -24.548  -5.542  1.00  0.00           C  
ATOM   1582  O   PHE A 104      15.765 -23.583  -5.133  1.00  0.00           O  
ATOM   1583  CB  PHE A 104      18.322 -24.694  -3.937  1.00  0.00           C  
ATOM   1584  CG  PHE A 104      19.755 -25.092  -3.726  1.00  0.00           C  
ATOM   1585  CD1 PHE A 104      20.783 -24.220  -4.045  1.00  0.00           C  
ATOM   1586  CD2 PHE A 104      20.073 -26.338  -3.209  1.00  0.00           C  
ATOM   1587  CE1 PHE A 104      22.103 -24.583  -3.853  1.00  0.00           C  
ATOM   1588  CE2 PHE A 104      21.391 -26.706  -3.014  1.00  0.00           C  
ATOM   1589  CZ  PHE A 104      22.407 -25.828  -3.335  1.00  0.00           C  
ATOM   1590  H   PHE A 104      18.064 -22.547  -5.954  1.00  0.00           H  
ATOM   1591  HA  PHE A 104      18.299 -25.454  -5.938  1.00  0.00           H  
ATOM   1592  HB2 PHE A 104      18.170 -23.738  -3.461  1.00  0.00           H  
ATOM   1593  HB3 PHE A 104      17.697 -25.433  -3.457  1.00  0.00           H  
ATOM   1594  HD1 PHE A 104      20.547 -23.247  -4.448  1.00  0.00           H  
ATOM   1595  HD2 PHE A 104      19.278 -27.025  -2.957  1.00  0.00           H  
ATOM   1596  HE1 PHE A 104      22.895 -23.895  -4.105  1.00  0.00           H  
ATOM   1597  HE2 PHE A 104      21.625 -27.680  -2.611  1.00  0.00           H  
ATOM   1598  HZ  PHE A 104      23.436 -26.114  -3.185  1.00  0.00           H  
TER    1599      PHE A 104                                                      
END
MOLECULE T0429.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
