
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  435 ( 3480),  selected  435 , name 2ve3_A
# Molecule2: number of CA atoms  472 ( 3732),  selected  472 , name T0431.pdb
# PARAMETERS: 2ve3_A.T0431.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     9_A      S       7           -
LGA    -       -      R       8           -
LGA    -       -      R       9           -
LGA    -       -      R      10           -
LGA    -       -      Q      11           -
LGA    S    10_A      T      12          3.982
LGA    L    11_A      G      13          1.410
LGA    P    12_A      E      14          3.581
LGA    I    13_A      P      15          1.621
LGA    P    14_A      P      16          2.544
LGA    P    15_A      L      17          4.671
LGA    G    16_A      E      18          2.463
LGA    D    17_A      -       -           -
LGA    F    18_A      N      19          2.394
LGA    G    19_A      G      20          1.318
LGA    L    20_A      -       -           -
LGA    P    21_A      -       -           -
LGA    W    22_A      -       -           -
LGA    L    23_A      -       -           -
LGA    G    24_A      L      21          0.631
LGA    E    25_A      I      22          1.877
LGA    T    26_A      P      23          1.969
LGA    L    27_A      Y      24           #
LGA    N    28_A      L      25           #
LGA    F    29_A      G      26          3.382
LGA    L    30_A      C      27          2.288
LGA    N    31_A      A      28          3.624
LGA    D    32_A      L      29          3.316
LGA    -       -      Q      30           -
LGA    -       -      F      31           -
LGA    -       -      G      32           -
LGA    G    33_A      A      33           #
LGA    D    34_A      N      34          1.605
LGA    F    35_A      P      35          1.382
LGA    G    36_A      L      36          2.914
LGA    K    37_A      E      37          2.107
LGA    K    38_A      F      38          2.475
LGA    R    39_A      L      39          3.308
LGA    Q    40_A      R      40          1.769
LGA    Q    41_A      A      41          2.578
LGA    Q    42_A      N      42          4.295
LGA    F    43_A      Q      43          4.042
LGA    G    44_A      R      44          3.137
LGA    -       -      K      45           -
LGA    -       -      H      46           -
LGA    -       -      G      47           -
LGA    P    45_A      H      48          3.047
LGA    I    46_A      V      49          2.659
LGA    F    47_A      F      50          2.718
LGA    K    48_A      T      51          2.132
LGA    T    49_A      C      52          1.568
LGA    R    50_A      K      53          1.456
LGA    L    51_A      L      54          1.993
LGA    F    52_A      M      55          2.410
LGA    G    53_A      G      56          1.576
LGA    K    54_A      K      57          1.309
LGA    N    55_A      Y      58          1.637
LGA    V    56_A      V      59          1.392
LGA    I    57_A      H      60          1.902
LGA    F    58_A      F      61          2.184
LGA    I    59_A      I      62          2.492
LGA    S    60_A      T      63          3.285
LGA    G    61_A      N      64          4.844
LGA    A    62_A      P      65          3.425
LGA    L    63_A      L      66          2.933
LGA    A    64_A      S      67          3.483
LGA    N    65_A      Y      68          2.561
LGA    R    66_A      H      69          1.192
LGA    F    67_A      K      70          1.833
LGA    L    68_A      V      71          1.749
LGA    F    69_A      L      72          1.264
LGA    T    70_A      C      73          1.374
LGA    K    71_A      H      74          3.073
LGA    E    72_A      G      75          3.152
LGA    Q    73_A      -       -           -
LGA    E    74_A      K      76          2.392
LGA    T    75_A      Y      77          2.061
LGA    F    76_A      F      78          2.168
LGA    Q    77_A      D      79          2.207
LGA    A    78_A      W      80          3.438
LGA    -       -      K      81           -
LGA    -       -      K      82           -
LGA    T    79_A      F      83          1.845
LGA    W    80_A      H      84          4.741
LGA    P    81_A      F      85           -
LGA    L    82_A      -       -           -
LGA    S    83_A      -       -           -
LGA    T    84_A      A      86           #
LGA    R    85_A      T      87          1.808
LGA    -       -      S      88           -
LGA    -       -      A      89           -
LGA    I    86_A      K      90          0.482
LGA    L    87_A      A      91          1.408
LGA    L    88_A      F      92          3.076
LGA    G    89_A      G      93          4.142
LGA    -       -      H      94           -
LGA    -       -      R      95           -
LGA    P    90_A      S      96          2.994
LGA    N    91_A      I      97          3.329
LGA    A    92_A      -       -           -
LGA    L    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    T    95_A      -       -           -
LGA    Q    96_A      D      98          3.951
LGA    M    97_A      -       -           -
LGA    G    98_A      -       -           -
LGA    E    99_A      -       -           -
LGA    I   100_A      P      99          3.949
LGA    H   101_A      M     100           -
LGA    R   102_A      D     101           -
LGA    -       -      G     102           -
LGA    -       -      N     103           -
LGA    -       -      T     104           -
LGA    -       -      T     105           -
LGA    S   103_A      E     106          4.901
LGA    R   104_A      N     107          2.996
LGA    -       -      I     108           -
LGA    R   105_A      N     109          1.409
LGA    K   106_A      D     110          1.532
LGA    I   107_A      T     111          1.564
LGA    L   108_A      F     112          2.080
LGA    Y   109_A      I     113          2.219
LGA    Q   110_A      K     114          2.772
LGA    A   111_A      T     115          2.327
LGA    F   112_A      L     116          1.640
LGA    L   113_A      Q     117          2.773
LGA    P   114_A      G     118          3.981
LGA    R   115_A      H     119          3.488
LGA    T   116_A      A     120          3.033
LGA    L   117_A      L     121          3.258
LGA    D   118_A      N     122          3.068
LGA    S   119_A      S     123          2.750
LGA    Y   120_A      L     124          3.373
LGA    -       -      T     125           -
LGA    -       -      E     126           -
LGA    -       -      S     127           -
LGA    -       -      M     128           -
LGA    L   121_A      M     129          2.559
LGA    P   122_A      E     130          1.507
LGA    K   123_A      N     131          2.048
LGA    M   124_A      L     132          3.290
LGA    D   125_A      Q     133          3.173
LGA    G   126_A      R     134          2.332
LGA    I   127_A      I     135          2.621
LGA    V   128_A      -       -           -
LGA    Q   129_A      M     136          1.983
LGA    G   130_A      R     137          3.541
LGA    Y   131_A      -       -           -
LGA    L   132_A      -       -           -
LGA    E   133_A      -       -           -
LGA    Q   134_A      -       -           -
LGA    W   135_A      -       -           -
LGA    G   136_A      A     148           #
LGA    K   137_A      W     149          4.163
LGA    A   138_A      V     150          1.169
LGA    N   139_A      T     151          3.185
LGA    E   140_A      -       -           -
LGA    V   141_A      E     152          1.206
LGA    I   142_A      G     153          1.144
LGA    W   143_A      M     154          1.616
LGA    Y   144_A      Y     155          1.121
LGA    P   145_A      S     156          1.941
LGA    Q   146_A      F     157          2.417
LGA    L   147_A      C     158          1.671
LGA    R   148_A      Y     159          1.650
LGA    R   149_A      R     160          2.043
LGA    M   150_A      V     161          1.975
LGA    T   151_A      M     162          2.060
LGA    F   152_A      F     163          1.773
LGA    D   153_A      E     164          0.873
LGA    V   154_A      A     165          1.754
LGA    A   155_A      G     166          2.226
LGA    A   156_A      Y     167          1.605
LGA    T   157_A      L     168          0.456
LGA    L   158_A      T     169          0.991
LGA    F   159_A      I     170          1.203
LGA    M   160_A      F     171          1.024
LGA    G   161_A      G     172          1.452
LGA    E   162_A      R     173          1.668
LGA    K   163_A      D     174          2.088
LGA    V   164_A      L     175           -
LGA    S   165_A      T     176           -
LGA    -       -      R     177           -
LGA    -       -      R     178           -
LGA    -       -      D     179           -
LGA    -       -      T     180           -
LGA    Q   166_A      Q     181          2.681
LGA    -       -      K     182           -
LGA    -       -      A     183           -
LGA    N   167_A      H     184          1.235
LGA    -       -      I     185           -
LGA    P   168_A      L     186          4.457
LGA    Q   169_A      N     187          2.651
LGA    L   170_A      N     188          2.034
LGA    F   171_A      L     189          2.042
LGA    P   172_A      D     190          2.043
LGA    W   173_A      N     191          1.899
LGA    F   174_A      F     192          1.542
LGA    E   175_A      K     193          1.499
LGA    T   176_A      Q     194          1.743
LGA    Y   177_A      F     195          1.447
LGA    I   178_A      D     196          0.966
LGA    Q   179_A      K     197          1.698
LGA    G   180_A      V     198          1.992
LGA    L   181_A      F     199          1.480
LGA    F   182_A      P     200          0.985
LGA    S   183_A      A     201          0.986
LGA    -       -      L     202           -
LGA    -       -      V     203           -
LGA    L   184_A      A     204           #
LGA    -       -      G     205           -
LGA    P   185_A      L     206          0.563
LGA    I   186_A      P     207          3.413
LGA    P   187_A      I     208          5.129
LGA    L   188_A      H     209          3.905
LGA    P   189_A      M     210          4.154
LGA    N   190_A      -       -           -
LGA    T   191_A      -       -           -
LGA    L   192_A      F     211          3.428
LGA    F   193_A      -       -           -
LGA    G   194_A      R     212          5.091
LGA    K   195_A      T     213          4.122
LGA    S   196_A      A     214          3.345
LGA    Q   197_A      H     215          3.576
LGA    R   198_A      N     216          3.506
LGA    A   199_A      A     217          2.857
LGA    R   200_A      R     218          2.575
LGA    A   201_A      E     219          2.571
LGA    L   202_A      K     220          2.609
LGA    L   203_A      L     221          2.247
LGA    L   204_A      A     222          1.967
LGA    A   205_A      E     223          2.403
LGA    E   206_A      S     224          2.404
LGA    L   207_A      L     225          1.330
LGA    E   208_A      R     226          1.313
LGA    K   209_A      H     227           #
LGA    I   210_A      E     228          4.497
LGA    I   211_A      N     229          4.693
LGA    K   212_A      L     230           #
LGA    A   213_A      Q     231          3.008
LGA    R   214_A      K     232          4.689
LGA    Q   215_A      R     233           -
LGA    Q   216_A      -       -           -
LGA    Q   217_A      -       -           -
LGA    P   218_A      -       -           -
LGA    P   219_A      -       -           -
LGA    S   220_A      -       -           -
LGA    E   221_A      -       -           -
LGA    E   222_A      E     234           #
LGA    -       -      S     235           -
LGA    D   223_A      I     236          3.215
LGA    A   224_A      S     237          3.161
LGA    -       -      E     238           -
LGA    -       -      L     239           -
LGA    L   225_A      I     240          1.867
LGA    G   226_A      S     241          1.470
LGA    I   227_A      L     242          2.571
LGA    L   228_A      R     243          1.796
LGA    L   229_A      M     244          2.649
LGA    A   230_A      F     245          3.652
LGA    A   231_A      -       -           -
LGA    R   232_A      L     246          4.786
LGA    D   233_A      N     247           -
LGA    D   234_A      D     248           -
LGA    N   235_A      -       -           -
LGA    N   236_A      -       -           -
LGA    Q   237_A      T     249          3.853
LGA    P   238_A      L     250          3.548
LGA    L   239_A      S     251          4.563
LGA    S   240_A      T     252           #
LGA    -       -      F     253           -
LGA    -       -      D     254           -
LGA    -       -      D     255           -
LGA    L   241_A      L     256           #
LGA    P   242_A      E     257          2.674
LGA    E   243_A      K     258          4.196
LGA    L   244_A      -       -           -
LGA    K   245_A      A     259          2.332
LGA    D   246_A      K     260          3.071
LGA    Q   247_A      T     261          2.854
LGA    I   248_A      H     262          1.644
LGA    L   249_A      L     263          0.864
LGA    L   250_A      V     264          1.610
LGA    L   251_A      V     265          1.625
LGA    L   252_A      L     266          0.913
LGA    F   253_A      W     267          0.756
LGA    A   254_A      A     268          1.484
LGA    G   255_A      S     269          1.396
LGA    H   256_A      Q     270          1.307
LGA    E   257_A      A     271          1.253
LGA    T   258_A      N     272          0.566
LGA    L   259_A      T     273          0.856
LGA    T   260_A      I     274          0.979
LGA    S   261_A      P     275          0.981
LGA    A   262_A      A     276          0.345
LGA    L   263_A      T     277          0.899
LGA    S   264_A      F     278          1.111
LGA    S   265_A      W     279          0.752
LGA    F   266_A      S     280          0.965
LGA    C   267_A      L     281          2.129
LGA    L   268_A      F     282          2.174
LGA    L   269_A      Q     283          1.081
LGA    L   270_A      M     284          1.140
LGA    G   271_A      I     285          2.533
LGA    Q   272_A      R     286          2.120
LGA    H   273_A      N     287          0.960
LGA    S   274_A      P     288          1.166
LGA    D   275_A      E     289          0.781
LGA    I   276_A      A     290          1.240
LGA    R   277_A      M     291          0.974
LGA    E   278_A      K     292          0.465
LGA    R   279_A      A     293          0.728
LGA    V   280_A      A     294          1.124
LGA    R   281_A      T     295          0.976
LGA    Q   282_A      E     296          1.122
LGA    E   283_A      E     297          1.263
LGA    Q   284_A      V     298          1.870
LGA    N   285_A      K     299          2.058
LGA    K   286_A      R     300          2.071
LGA    L   287_A      T     301          3.130
LGA    Q   288_A      L     302          3.088
LGA    L   289_A      E     303          5.062
LGA    -       -      N     304           -
LGA    -       -      A     305           -
LGA    -       -      G     306           -
LGA    -       -      Q     307           -
LGA    -       -      K     308           -
LGA    S   290_A      V     309          1.844
LGA    Q   291_A      S     310          4.599
LGA    E   292_A      L     311           -
LGA    -       -      E     312           -
LGA    -       -      G     313           -
LGA    -       -      N     314           -
LGA    -       -      P     315           -
LGA    L   293_A      I     316          2.408
LGA    T   294_A      C     317          1.888
LGA    A   295_A      L     318          2.962
LGA    E   296_A      S     319          1.365
LGA    -       -      Q     320           -
LGA    -       -      A     321           -
LGA    T   297_A      E     322          3.619
LGA    L   298_A      L     323          2.090
LGA    K   299_A      N     324          3.357
LGA    K   300_A      D     325          3.995
LGA    M   301_A      L     326          1.850
LGA    P   302_A      P     327          2.544
LGA    Y   303_A      V     328          2.265
LGA    L   304_A      L     329          1.629
LGA    D   305_A      D     330          1.970
LGA    Q   306_A      S     331          2.213
LGA    V   307_A      I     332          1.970
LGA    L   308_A      I     333          1.772
LGA    Q   309_A      K     334          2.002
LGA    E   310_A      E     335          1.839
LGA    V   311_A      S     336          1.704
LGA    L   312_A      L     337          1.747
LGA    R   313_A      R     338          1.651
LGA    L   314_A      L     339          2.075
LGA    I   315_A      S     340          1.870
LGA    P   316_A      S     341          1.722
LGA    P   317_A      -       -           -
LGA    V   318_A      A     342          4.699
LGA    G   319_A      S     343          2.314
LGA    G   320_A      L     344          2.276
LGA    G   321_A      N     345          2.707
LGA    F   322_A      I     346          2.405
LGA    R   323_A      R     347          2.066
LGA    E   324_A      T     348          1.765
LGA    L   325_A      A     349          1.659
LGA    I   326_A      K     350          1.803
LGA    Q   327_A      E     351          2.975
LGA    D   328_A      D     352          3.056
LGA    -       -      F     353           -
LGA    C   329_A      T     354          2.873
LGA    Q   330_A      L     355          2.541
LGA    F   331_A      H     356          4.344
LGA    -       -      L     357           -
LGA    -       -      E     358           -
LGA    Q   332_A      D     359          2.271
LGA    G   333_A      G     360          2.604
LGA    F   334_A      S     361          5.103
LGA    H   335_A      Y     362          2.489
LGA    F   336_A      N     363          4.586
LGA    P   337_A      I     364          2.013
LGA    K   338_A      R     365          1.938
LGA    G   339_A      K     366          3.546
LGA    -       -      D     367           -
LGA    W   340_A      D     368          1.640
LGA    L   341_A      I     369          1.468
LGA    V   342_A      I     370          2.252
LGA    S   343_A      A     371          2.253
LGA    Y   344_A      L     372          1.461
LGA    Q   345_A      Y     373          0.926
LGA    I   346_A      P     374          2.231
LGA    S   347_A      Q     375          1.345
LGA    Q   348_A      L     376          1.278
LGA    T   349_A      M     377          1.778
LGA    H   350_A      H     378          0.681
LGA    A   351_A      L     379          0.930
LGA    D   352_A      D     380          1.558
LGA    P   353_A      P     381          1.863
LGA    D   354_A      E     382          2.197
LGA    L   355_A      I     383          1.932
LGA    Y   356_A      Y     384          1.313
LGA    P   357_A      P     385          1.936
LGA    D   358_A      D     386          1.866
LGA    P   359_A      P     387          1.272
LGA    E   360_A      L     388          1.349
LGA    K   361_A      T     389          1.984
LGA    F   362_A      F     390          1.778
LGA    D   363_A      K     391          2.106
LGA    P   364_A      Y     392          3.708
LGA    E   365_A      D     393          3.166
LGA    R   366_A      R     394          3.217
LGA    F   367_A      Y     395          2.081
LGA    T   368_A      L     396          2.186
LGA    P   369_A      D     397          3.896
LGA    D   370_A      E     398           #
LGA    G   371_A      N     399           -
LGA    S   372_A      G     400           -
LGA    A   373_A      K     401           -
LGA    -       -      T     402           -
LGA    -       -      K     403           -
LGA    T   374_A      T     404          1.621
LGA    H   375_A      T     405          2.216
LGA    N   376_A      F     406          2.837
LGA    -       -      Y     407           -
LGA    -       -      C     408           -
LGA    -       -      N     409           -
LGA    -       -      G     410           -
LGA    -       -      L     411           -
LGA    -       -      K     412           -
LGA    P   377_A      L     413          0.979
LGA    P   378_A      K     414          0.841
LGA    F   379_A      Y     415          1.360
LGA    A   380_A      Y     416          1.265
LGA    H   381_A      Y     417          0.833
LGA    V   382_A      M     418          0.703
LGA    P   383_A      P     419          0.977
LGA    F   384_A      F     420          0.613
LGA    G   385_A      G     421          0.410
LGA    G   386_A      S     422          0.843
LGA    G   387_A      G     423          1.204
LGA    L   388_A      A     424          1.143
LGA    R   389_A      T     425          1.713
LGA    E   390_A      I     426          0.528
LGA    C   391_A      C     427          0.350
LGA    L   392_A      P     428          0.721
LGA    G   393_A      G     429          0.671
LGA    K   394_A      R     430          0.525
LGA    E   395_A      L     431          1.405
LGA    F   396_A      F     432          1.609
LGA    A   397_A      A     433          0.499
LGA    R   398_A      I     434          0.646
LGA    L   399_A      H     435          0.999
LGA    E   400_A      E     436          0.870
LGA    M   401_A      I     437          0.651
LGA    K   402_A      K     438          0.448
LGA    L   403_A      Q     439          0.406
LGA    F   404_A      F     440          0.787
LGA    A   405_A      L     441          1.097
LGA    T   406_A      I     442          0.934
LGA    R   407_A      L     443          1.157
LGA    L   408_A      M     444          1.297
LGA    I   409_A      L     445          1.891
LGA    Q   410_A      S     446          2.407
LGA    Q   411_A      Y     447          3.181
LGA    F   412_A      F     448          3.436
LGA    D   413_A      E     449          4.478
LGA    W   414_A      L     450          3.043
LGA    T   415_A      E     451          3.104
LGA    L   416_A      L     452          2.875
LGA    L   417_A      I     453          3.005
LGA    P   418_A      E     454          2.992
LGA    -       -      G     455           -
LGA    -       -      Q     456           -
LGA    G   419_A      A     457          4.978
LGA    Q   420_A      K     458           #
LGA    N   421_A      C     459           #
LGA    L   422_A      P     460          1.471
LGA    E   423_A      P     461          1.679
LGA    L   424_A      L     462          1.635
LGA    V   425_A      D     463          0.695
LGA    V   426_A      Q     464          3.344
LGA    T   427_A      S     465          3.995
LGA    P   428_A      R     466          2.403
LGA    -       -      A     467           -
LGA    -       -      G     468           -
LGA    -       -      L     469           -
LGA    -       -      G     470           -
LGA    S   429_A      I     471          4.219
LGA    P   430_A      L     472          1.643
LGA    R   431_A      P     473          1.885
LGA    P   432_A      P     474          2.038
LGA    K   433_A      L     475          2.337
LGA    D   434_A      N     476          2.356
LGA    N   435_A      D     477          0.765
LGA    L   436_A      I     478          1.823
LGA    R   437_A      E     479          1.188
LGA    V   438_A      F     480          1.253
LGA    K   439_A      K     481          1.871
LGA    L   440_A      Y     482          2.710
LGA    H   441_A      K     483           #
LGA    S   442_A      F     484           #
LGA    L   443_A      K     485          4.404
LGA    -       -      H     486           -
LGA    -       -      H     487           -
LGA    -       -      H     488           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  435  472    5.0    370    2.46    18.11     49.512    14.473

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.535884 * X  +  -0.155039 * Y  +  -0.829934 * Z  +  -0.673184
  Y_new =  -0.812685 * X  +   0.171722 * Y  +  -0.556826 * Z  +  56.750019
  Z_new =   0.228847 * X  +   0.972869 * Y  +  -0.033975 * Z  + -46.915417 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.605705   -1.535888  [ DEG:    92.0001    -87.9999 ]
  Theta =  -0.230893   -2.910699  [ DEG:   -13.2292   -166.7708 ]
  Phi   =  -0.987842    2.153751  [ DEG:   -56.5992    123.4008 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ve3_A                                        
REMARK     2: T0431.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ve3_A.T0431.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  435  472   5.0  370   2.46   18.11  49.512
REMARK  ---------------------------------------------------------- 
MOLECULE 2ve3_A
HEADER    OXIDOREDUCTASE                          15-OCT-07   2VE3              
TITLE     RETINOIC ACID BOUND CYANOBACTERIAL CYP120A1                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE CYTOCHROME P450 120;                              
COMPND   3 SYNONYM: CYTOCHROME P450 ENZYME;                                     
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 EC: 1.14.-.-;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   4 ORGANISM_SCIENTIFIC: SYNECHOCYSTIS SP.;                              
SOURCE   5 STRAIN: PCC 6803                                                     
KEYWDS    OXIDOREDUCTASE, MONOOXYGENASE, METAL-BINDING,                         
KEYWDS   2 HEME, IRON                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.KUHNEL,N.KE,S.G.SLIGAR,M.A.SCHULER,I.SCHLICHTING                    
REVDAT   1   29-APR-08 2VE3    0                                                
JRNL        AUTH   K.KUHNEL,N.KE,S.G.SLIGAR,M.A.SCHULER,I.SCHLICHTING           
JRNL        TITL   CRYSTAL STRUCTURES OF SUBSTRATE-FREE AND RETINOIC            
JRNL        TITL 2 ACID-BOUND CYANOBACTERIAL CYTOCHROME P450 CYP120A1           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.1  ANGSTROMS.                                          
DBREF  2VE3 A    1   444  UNP    Q59990   CP120_SYNY3      1    444             
DBREF  2VE3 B    1   444  UNP    Q59990   CP120_SYNY3      1    444             
SEQRES   1 A  444  MET ILE THR SER PRO THR ASN LEU ASN SER LEU PRO ILE          
SEQRES   2 A  444  PRO PRO GLY ASP PHE GLY LEU PRO TRP LEU GLY GLU THR          
SEQRES   3 A  444  LEU ASN PHE LEU ASN ASP GLY ASP PHE GLY LYS LYS ARG          
SEQRES   4 A  444  GLN GLN GLN PHE GLY PRO ILE PHE LYS THR ARG LEU PHE          
SEQRES   5 A  444  GLY LYS ASN VAL ILE PHE ILE SER GLY ALA LEU ALA ASN          
SEQRES   6 A  444  ARG PHE LEU PHE THR LYS GLU GLN GLU THR PHE GLN ALA          
SEQRES   7 A  444  THR TRP PRO LEU SER THR ARG ILE LEU LEU GLY PRO ASN          
SEQRES   8 A  444  ALA LEU ALA THR GLN MET GLY GLU ILE HIS ARG SER ARG          
SEQRES   9 A  444  ARG LYS ILE LEU TYR GLN ALA PHE LEU PRO ARG THR LEU          
SEQRES  10 A  444  ASP SER TYR LEU PRO LYS MET ASP GLY ILE VAL GLN GLY          
SEQRES  11 A  444  TYR LEU GLU GLN TRP GLY LYS ALA ASN GLU VAL ILE TRP          
SEQRES  12 A  444  TYR PRO GLN LEU ARG ARG MET THR PHE ASP VAL ALA ALA          
SEQRES  13 A  444  THR LEU PHE MET GLY GLU LYS VAL SER GLN ASN PRO GLN          
SEQRES  14 A  444  LEU PHE PRO TRP PHE GLU THR TYR ILE GLN GLY LEU PHE          
SEQRES  15 A  444  SER LEU PRO ILE PRO LEU PRO ASN THR LEU PHE GLY LYS          
SEQRES  16 A  444  SER GLN ARG ALA ARG ALA LEU LEU LEU ALA GLU LEU GLU          
SEQRES  17 A  444  LYS ILE ILE LYS ALA ARG GLN GLN GLN PRO PRO SER GLU          
SEQRES  18 A  444  GLU ASP ALA LEU GLY ILE LEU LEU ALA ALA ARG ASP ASP          
SEQRES  19 A  444  ASN ASN GLN PRO LEU SER LEU PRO GLU LEU LYS ASP GLN          
SEQRES  20 A  444  ILE LEU LEU LEU LEU PHE ALA GLY HIS GLU THR LEU THR          
SEQRES  21 A  444  SER ALA LEU SER SER PHE CYS LEU LEU LEU GLY GLN HIS          
SEQRES  22 A  444  SER ASP ILE ARG GLU ARG VAL ARG GLN GLU GLN ASN LYS          
SEQRES  23 A  444  LEU GLN LEU SER GLN GLU LEU THR ALA GLU THR LEU LYS          
SEQRES  24 A  444  LYS MET PRO TYR LEU ASP GLN VAL LEU GLN GLU VAL LEU          
SEQRES  25 A  444  ARG LEU ILE PRO PRO VAL GLY GLY GLY PHE ARG GLU LEU          
SEQRES  26 A  444  ILE GLN ASP CYS GLN PHE GLN GLY PHE HIS PHE PRO LYS          
SEQRES  27 A  444  GLY TRP LEU VAL SER TYR GLN ILE SER GLN THR HIS ALA          
SEQRES  28 A  444  ASP PRO ASP LEU TYR PRO ASP PRO GLU LYS PHE ASP PRO          
SEQRES  29 A  444  GLU ARG PHE THR PRO ASP GLY SER ALA THR HIS ASN PRO          
SEQRES  30 A  444  PRO PHE ALA HIS VAL PRO PHE GLY GLY GLY LEU ARG GLU          
SEQRES  31 A  444  CYS LEU GLY LYS GLU PHE ALA ARG LEU GLU MET LYS LEU          
SEQRES  32 A  444  PHE ALA THR ARG LEU ILE GLN GLN PHE ASP TRP THR LEU          
SEQRES  33 A  444  LEU PRO GLY GLN ASN LEU GLU LEU VAL VAL THR PRO SER          
SEQRES  34 A  444  PRO ARG PRO LYS ASP ASN LEU ARG VAL LYS LEU HIS SER          
SEQRES  35 A  444  LEU MET                                                      
SEQRES   1 B  444  MET ILE THR SER PRO THR ASN LEU ASN SER LEU PRO ILE          
SEQRES   2 B  444  PRO PRO GLY ASP PHE GLY LEU PRO TRP LEU GLY GLU THR          
SEQRES   3 B  444  LEU ASN PHE LEU ASN ASP GLY ASP PHE GLY LYS LYS ARG          
SEQRES   4 B  444  GLN GLN GLN PHE GLY PRO ILE PHE LYS THR ARG LEU PHE          
SEQRES   5 B  444  GLY LYS ASN VAL ILE PHE ILE SER GLY ALA LEU ALA ASN          
SEQRES   6 B  444  ARG PHE LEU PHE THR LYS GLU GLN GLU THR PHE GLN ALA          
SEQRES   7 B  444  THR TRP PRO LEU SER THR ARG ILE LEU LEU GLY PRO ASN          
SEQRES   8 B  444  ALA LEU ALA THR GLN MET GLY GLU ILE HIS ARG SER ARG          
SEQRES   9 B  444  ARG LYS ILE LEU TYR GLN ALA PHE LEU PRO ARG THR LEU          
SEQRES  10 B  444  ASP SER TYR LEU PRO LYS MET ASP GLY ILE VAL GLN GLY          
SEQRES  11 B  444  TYR LEU GLU GLN TRP GLY LYS ALA ASN GLU VAL ILE TRP          
SEQRES  12 B  444  TYR PRO GLN LEU ARG ARG MET THR PHE ASP VAL ALA ALA          
SEQRES  13 B  444  THR LEU PHE MET GLY GLU LYS VAL SER GLN ASN PRO GLN          
SEQRES  14 B  444  LEU PHE PRO TRP PHE GLU THR TYR ILE GLN GLY LEU PHE          
SEQRES  15 B  444  SER LEU PRO ILE PRO LEU PRO ASN THR LEU PHE GLY LYS          
SEQRES  16 B  444  SER GLN ARG ALA ARG ALA LEU LEU LEU ALA GLU LEU GLU          
SEQRES  17 B  444  LYS ILE ILE LYS ALA ARG GLN GLN GLN PRO PRO SER GLU          
SEQRES  18 B  444  GLU ASP ALA LEU GLY ILE LEU LEU ALA ALA ARG ASP ASP          
SEQRES  19 B  444  ASN ASN GLN PRO LEU SER LEU PRO GLU LEU LYS ASP GLN          
SEQRES  20 B  444  ILE LEU LEU LEU LEU PHE ALA GLY HIS GLU THR LEU THR          
SEQRES  21 B  444  SER ALA LEU SER SER PHE CYS LEU LEU LEU GLY GLN HIS          
SEQRES  22 B  444  SER ASP ILE ARG GLU ARG VAL ARG GLN GLU GLN ASN LYS          
SEQRES  23 B  444  LEU GLN LEU SER GLN GLU LEU THR ALA GLU THR LEU LYS          
SEQRES  24 B  444  LYS MET PRO TYR LEU ASP GLN VAL LEU GLN GLU VAL LEU          
SEQRES  25 B  444  ARG LEU ILE PRO PRO VAL GLY GLY GLY PHE ARG GLU LEU          
SEQRES  26 B  444  ILE GLN ASP CYS GLN PHE GLN GLY PHE HIS PHE PRO LYS          
SEQRES  27 B  444  GLY TRP LEU VAL SER TYR GLN ILE SER GLN THR HIS ALA          
SEQRES  28 B  444  ASP PRO ASP LEU TYR PRO ASP PRO GLU LYS PHE ASP PRO          
SEQRES  29 B  444  GLU ARG PHE THR PRO ASP GLY SER ALA THR HIS ASN PRO          
SEQRES  30 B  444  PRO PHE ALA HIS VAL PRO PHE GLY GLY GLY LEU ARG GLU          
SEQRES  31 B  444  CYS LEU GLY LYS GLU PHE ALA ARG LEU GLU MET LYS LEU          
SEQRES  32 B  444  PHE ALA THR ARG LEU ILE GLN GLN PHE ASP TRP THR LEU          
SEQRES  33 B  444  LEU PRO GLY GLN ASN LEU GLU LEU VAL VAL THR PRO SER          
SEQRES  34 B  444  PRO ARG PRO LYS ASP ASN LEU ARG VAL LYS LEU HIS SER          
SEQRES  35 B  444  LEU MET                                                      
HET    HEM  A1444      43                                                       
HET    REA  A1445      22                                                       
HET    HEM  B1444      43                                                       
HET    REA  B1445      22                                                       
HETNAM     HEM PROTOPORPHYRIN IX CONTAINING FE                                  
HETNAM     REA RETINOIC ACID                                                    
FORMUL   3  HEM    2(C34 H32 FE N4 O4)                                          
FORMUL   4  REA    2(C20 H28 O2)                                                
FORMUL   5  HOH   *303(H2 O1)                                                   
CRYST1  141.460  132.970   67.420  90.00 114.50  90.00 C 1 2 1       8          
ATOM      1  N   ASN A   9      31.362 -15.149 -38.993  1.00 44.67           N  
ATOM      2  CA  ASN A   9      32.392 -14.787 -37.973  1.00 44.47           C  
ATOM      3  C   ASN A   9      31.823 -14.696 -36.555  1.00 43.85           C  
ATOM      4  O   ASN A   9      30.700 -14.210 -36.350  1.00 44.41           O  
ATOM      5  CB  ASN A   9      33.120 -13.497 -38.373  1.00 44.78           C  
ATOM      6  CG  ASN A   9      34.087 -13.707 -39.543  1.00 45.48           C  
ATOM      7  OD1 ASN A   9      34.762 -14.741 -39.636  1.00 44.95           O  
ATOM      8  ND2 ASN A   9      34.157 -12.721 -40.439  1.00 45.86           N  
ATOM      9  N   SER A  10      32.622 -15.156 -35.590  1.00 42.84           N  
ATOM     10  CA  SER A  10      32.175 -15.431 -34.216  1.00 41.53           C  
ATOM     11  C   SER A  10      32.538 -14.318 -33.213  1.00 40.43           C  
ATOM     12  O   SER A  10      33.337 -14.527 -32.291  1.00 40.29           O  
ATOM     13  CB  SER A  10      32.776 -16.763 -33.756  1.00 41.82           C  
ATOM     14  OG  SER A  10      33.247 -17.529 -34.861  1.00 42.37           O  
ATOM     15  N   LEU A  11      31.931 -13.146 -33.396  1.00 38.71           N  
ATOM     16  CA  LEU A  11      32.217 -11.960 -32.586  1.00 37.10           C  
ATOM     17  C   LEU A  11      31.119 -11.691 -31.538  1.00 36.08           C  
ATOM     18  O   LEU A  11      29.958 -12.038 -31.758  1.00 36.01           O  
ATOM     19  CB  LEU A  11      32.395 -10.742 -33.504  1.00 36.86           C  
ATOM     20  CG  LEU A  11      33.565 -10.745 -34.499  1.00 36.47           C  
ATOM     21  CD1 LEU A  11      33.357  -9.689 -35.545  1.00 36.64           C  
ATOM     22  CD2 LEU A  11      34.910 -10.543 -33.817  1.00 36.09           C  
ATOM     23  N   PRO A  12      31.473 -11.062 -30.397  1.00 34.82           N  
ATOM     24  CA  PRO A  12      30.440 -10.805 -29.388  1.00 33.96           C  
ATOM     25  C   PRO A  12      29.532  -9.623 -29.758  1.00 32.74           C  
ATOM     26  O   PRO A  12      29.912  -8.793 -30.585  1.00 32.78           O  
ATOM     27  CB  PRO A  12      31.260 -10.439 -28.158  1.00 33.87           C  
ATOM     28  CG  PRO A  12      32.470  -9.754 -28.739  1.00 33.89           C  
ATOM     29  CD  PRO A  12      32.786 -10.534 -29.980  1.00 34.83           C  
ATOM     30  N   ILE A  13      28.350  -9.554 -29.147  1.00 31.76           N  
ATOM     31  CA  ILE A  13      27.489  -8.362 -29.227  1.00 31.05           C  
ATOM     32  C   ILE A  13      27.855  -7.374 -28.100  1.00 30.27           C  
ATOM     33  O   ILE A  13      28.354  -7.798 -27.053  1.00 29.94           O  
ATOM     34  CB  ILE A  13      25.950  -8.704 -29.198  1.00 30.84           C  
ATOM     35  CG1 ILE A  13      25.547  -9.378 -27.884  1.00 30.51           C  
ATOM     36  CG2 ILE A  13      25.546  -9.541 -30.422  1.00 30.80           C  
ATOM     37  CD1 ILE A  13      24.043  -9.611 -27.727  1.00 32.06           C  
ATOM     38  N   PRO A  14      27.617  -6.052 -28.314  1.00 29.62           N  
ATOM     39  CA  PRO A  14      27.999  -5.030 -27.341  1.00 29.08           C  
ATOM     40  C   PRO A  14      27.468  -5.266 -25.933  1.00 29.16           C  
ATOM     41  O   PRO A  14      26.467  -5.969 -25.766  1.00 29.02           O  
ATOM     42  CB  PRO A  14      27.393  -3.758 -27.931  1.00 29.12           C  
ATOM     43  CG  PRO A  14      27.400  -4.006 -29.386  1.00 29.03           C  
ATOM     44  CD  PRO A  14      26.993  -5.438 -29.502  1.00 29.08           C  
ATOM     45  N   PRO A  15      28.143  -4.693 -24.915  1.00 28.93           N  
ATOM     46  CA  PRO A  15      27.611  -4.773 -23.553  1.00 29.07           C  
ATOM     47  C   PRO A  15      26.409  -3.847 -23.383  1.00 29.27           C  
ATOM     48  O   PRO A  15      26.302  -2.858 -24.098  1.00 29.37           O  
ATOM     49  CB  PRO A  15      28.779  -4.290 -22.687  1.00 28.88           C  
ATOM     50  CG  PRO A  15      29.588  -3.392 -23.602  1.00 28.77           C  
ATOM     51  CD  PRO A  15      29.428  -3.968 -24.982  1.00 28.64           C  
ATOM     52  N   GLY A  16      25.525  -4.160 -22.445  1.00 29.23           N  
ATOM     53  CA  GLY A  16      24.328  -3.355 -22.235  1.00 30.10           C  
ATOM     54  C   GLY A  16      23.132  -4.166 -21.764  1.00 30.46           C  
ATOM     55  O   GLY A  16      23.024  -5.352 -22.081  1.00 30.41           O  
ATOM     56  N   ASP A  17      22.243  -3.517 -21.010  1.00 30.90           N  
ATOM     57  CA  ASP A  17      21.015  -4.138 -20.479  1.00 31.86           C  
ATOM     58  C   ASP A  17      19.798  -3.971 -21.402  1.00 31.76           C  
ATOM     59  O   ASP A  17      19.484  -2.860 -21.837  1.00 31.60           O  
ATOM     60  CB  ASP A  17      20.681  -3.555 -19.107  1.00 32.17           C  
ATOM     61  CG  ASP A  17      21.774  -3.790 -18.088  1.00 33.92           C  
ATOM     62  OD1 ASP A  17      22.482  -4.819 -18.195  1.00 36.62           O  
ATOM     63  OD2 ASP A  17      21.916  -2.947 -17.174  1.00 34.92           O  
ATOM     64  N   PHE A  18      19.127  -5.083 -21.688  1.00 32.08           N  
ATOM     65  CA  PHE A  18      17.925  -5.088 -22.518  1.00 32.04           C  
ATOM     66  C   PHE A  18      16.675  -4.763 -21.723  1.00 32.32           C  
ATOM     67  O   PHE A  18      15.692  -4.285 -22.290  1.00 32.39           O  
ATOM     68  CB  PHE A  18      17.746  -6.436 -23.224  1.00 31.83           C  
ATOM     69  CG  PHE A  18      18.504  -6.560 -24.523  1.00 31.30           C  
ATOM     70  CD1 PHE A  18      18.895  -5.436 -25.238  1.00 30.65           C  
ATOM     71  CD2 PHE A  18      18.790  -7.806 -25.052  1.00 31.89           C  
ATOM     72  CE1 PHE A  18      19.578  -5.562 -26.439  1.00 30.10           C  
ATOM     73  CE2 PHE A  18      19.468  -7.933 -26.257  1.00 31.10           C  
ATOM     74  CZ  PHE A  18      19.855  -6.808 -26.947  1.00 31.20           C  
ATOM     75  N   GLY A  19      16.720  -5.023 -20.412  1.00 32.36           N  
ATOM     76  CA  GLY A  19      15.582  -4.774 -19.512  1.00 32.07           C  
ATOM     77  C   GLY A  19      14.406  -5.712 -19.744  1.00 31.75           C  
ATOM     78  O   GLY A  19      14.587  -6.835 -20.216  1.00 31.67           O  
ATOM     79  N   LEU A  20      13.203  -5.246 -19.413  1.00 31.53           N  
ATOM     80  CA  LEU A  20      11.967  -6.018 -19.605  1.00 31.36           C  
ATOM     81  C   LEU A  20      11.721  -6.323 -21.075  1.00 31.49           C  
ATOM     82  O   LEU A  20      12.179  -5.576 -21.936  1.00 31.14           O  
ATOM     83  CB  LEU A  20      10.760  -5.251 -19.050  1.00 31.30           C  
ATOM     84  CG  LEU A  20      10.742  -5.001 -17.544  1.00 31.79           C  
ATOM     85  CD1 LEU A  20       9.924  -3.763 -17.154  1.00 31.09           C  
ATOM     86  CD2 LEU A  20      10.263  -6.250 -16.820  1.00 31.49           C  
ATOM     87  N   PRO A  21      10.975  -7.417 -21.369  1.00 31.44           N  
ATOM     88  CA  PRO A  21      10.563  -7.654 -22.754  1.00 31.22           C  
ATOM     89  C   PRO A  21       9.727  -6.481 -23.273  1.00 30.85           C  
ATOM     90  O   PRO A  21       8.951  -5.889 -22.520  1.00 31.09           O  
ATOM     91  CB  PRO A  21       9.714  -8.931 -22.662  1.00 31.31           C  
ATOM     92  CG  PRO A  21      10.157  -9.588 -21.414  1.00 31.26           C  
ATOM     93  CD  PRO A  21      10.468  -8.470 -20.469  1.00 31.16           C  
ATOM     94  N   TRP A  22       9.929  -6.153 -24.547  1.00 30.66           N  
ATOM     95  CA  TRP A  22       9.349  -4.982 -25.218  1.00 30.27           C  
ATOM     96  C   TRP A  22       9.689  -3.624 -24.573  1.00 29.60           C  
ATOM     97  O   TRP A  22      10.402  -2.827 -25.179  1.00 29.48           O  
ATOM     98  CB  TRP A  22       7.837  -5.150 -25.480  1.00 30.53           C  
ATOM     99  CG  TRP A  22       7.430  -4.546 -26.778  1.00 31.14           C  
ATOM    100  CD1 TRP A  22       7.369  -5.175 -27.991  1.00 31.53           C  
ATOM    101  CD2 TRP A  22       7.062  -3.180 -27.014  1.00 31.42           C  
ATOM    102  NE1 TRP A  22       6.973  -4.288 -28.963  1.00 32.02           N  
ATOM    103  CE2 TRP A  22       6.772  -3.059 -28.392  1.00 30.99           C  
ATOM    104  CE3 TRP A  22       6.930  -2.051 -26.192  1.00 32.52           C  
ATOM    105  CZ2 TRP A  22       6.370  -1.852 -28.970  1.00 31.19           C  
ATOM    106  CZ3 TRP A  22       6.530  -0.845 -26.772  1.00 32.09           C  
ATOM    107  CH2 TRP A  22       6.258  -0.759 -28.148  1.00 30.72           C  
ATOM    108  N   LEU A  23       9.191  -3.361 -23.364  1.00 29.25           N  
ATOM    109  CA  LEU A  23       9.440  -2.071 -22.701  1.00 29.06           C  
ATOM    110  C   LEU A  23      10.935  -1.716 -22.638  1.00 28.43           C  
ATOM    111  O   LEU A  23      11.312  -0.571 -22.901  1.00 29.16           O  
ATOM    112  CB  LEU A  23       8.791  -1.993 -21.313  1.00 28.99           C  
ATOM    113  CG  LEU A  23       8.937  -0.660 -20.561  1.00 29.29           C  
ATOM    114  CD1 LEU A  23       8.058   0.449 -21.149  1.00 29.45           C  
ATOM    115  CD2 LEU A  23       8.663  -0.837 -19.078  1.00 29.32           C  
ATOM    116  N   GLY A  24      11.772  -2.693 -22.303  1.00 27.76           N  
ATOM    117  CA  GLY A  24      13.222  -2.509 -22.270  1.00 26.40           C  
ATOM    118  C   GLY A  24      13.614  -1.303 -21.448  1.00 25.86           C  
ATOM    119  O   GLY A  24      13.137  -1.132 -20.336  1.00 25.66           O  
ATOM    120  N   GLU A  25      14.477  -0.461 -22.004  1.00 25.41           N  
ATOM    121  CA  GLU A  25      14.870   0.780 -21.319  1.00 25.29           C  
ATOM    122  C   GLU A  25      14.182   2.010 -21.920  1.00 24.44           C  
ATOM    123  O   GLU A  25      14.685   3.130 -21.804  1.00 24.26           O  
ATOM    124  CB  GLU A  25      16.393   0.958 -21.334  1.00 25.32           C  
ATOM    125  CG  GLU A  25      17.185  -0.223 -20.794  1.00 25.08           C  
ATOM    126  CD  GLU A  25      18.635   0.149 -20.500  1.00 26.20           C  
ATOM    127  OE1 GLU A  25      19.446   0.274 -21.448  1.00 25.78           O  
ATOM    128  OE2 GLU A  25      18.961   0.328 -19.312  1.00 28.31           O  
ATOM    129  N   THR A  26      13.022   1.800 -22.545  1.00 23.60           N  
ATOM    130  CA  THR A  26      12.293   2.885 -23.206  1.00 22.59           C  
ATOM    131  C   THR A  26      11.967   4.028 -22.245  1.00 22.24           C  
ATOM    132  O   THR A  26      12.020   5.190 -22.634  1.00 22.08           O  
ATOM    133  CB  THR A  26      10.975   2.388 -23.892  1.00 22.57           C  
ATOM    134  OG1 THR A  26      11.243   1.244 -24.719  1.00 21.37           O  
ATOM    135  CG2 THR A  26      10.374   3.489 -24.757  1.00 22.95           C  
ATOM    136  N   LEU A  27      11.632   3.708 -20.996  1.00 22.03           N  
ATOM    137  CA  LEU A  27      11.272   4.757 -20.034  1.00 22.43           C  
ATOM    138  C   LEU A  27      12.468   5.636 -19.668  1.00 22.62           C  
ATOM    139  O   LEU A  27      12.314   6.834 -19.458  1.00 23.08           O  
ATOM    140  CB  LEU A  27      10.613   4.182 -18.773  1.00 22.58           C  
ATOM    141  CG  LEU A  27       9.291   3.406 -18.849  1.00 22.90           C  
ATOM    142  CD1 LEU A  27       8.925   2.818 -17.460  1.00 24.46           C  
ATOM    143  CD2 LEU A  27       8.152   4.261 -19.365  1.00 24.08           C  
ATOM    144  N   ASN A  28      13.652   5.033 -19.595  1.00 22.96           N  
ATOM    145  CA  ASN A  28      14.886   5.779 -19.311  1.00 23.28           C  
ATOM    146  C   ASN A  28      15.227   6.715 -20.473  1.00 23.10           C  
ATOM    147  O   ASN A  28      15.510   7.891 -20.269  1.00 22.86           O  
ATOM    148  CB  ASN A  28      16.032   4.811 -19.014  1.00 23.15           C  
ATOM    149  CG  ASN A  28      15.663   3.777 -17.943  1.00 23.97           C  
ATOM    150  OD1 ASN A  28      15.591   4.093 -16.759  1.00 24.65           O  
ATOM    151  ND2 ASN A  28      15.429   2.549 -18.362  1.00 25.21           N  
ATOM    152  N   PHE A  29      15.163   6.181 -21.689  1.00 23.37           N  
ATOM    153  CA  PHE A  29      15.299   6.966 -22.919  1.00 23.49           C  
ATOM    154  C   PHE A  29      14.362   8.183 -22.960  1.00 23.72           C  
ATOM    155  O   PHE A  29      14.798   9.299 -23.256  1.00 23.34           O  
ATOM    156  CB  PHE A  29      15.038   6.051 -24.121  1.00 23.58           C  
ATOM    157  CG  PHE A  29      15.229   6.716 -25.451  1.00 23.65           C  
ATOM    158  CD1 PHE A  29      16.510   6.988 -25.930  1.00 22.76           C  
ATOM    159  CD2 PHE A  29      14.131   7.056 -26.228  1.00 24.24           C  
ATOM    160  CE1 PHE A  29      16.696   7.600 -27.167  1.00 24.01           C  
ATOM    161  CE2 PHE A  29      14.305   7.664 -27.473  1.00 26.00           C  
ATOM    162  CZ  PHE A  29      15.592   7.938 -27.943  1.00 24.50           C  
ATOM    163  N   LEU A  30      13.084   7.973 -22.645  1.00 23.73           N  
ATOM    164  CA  LEU A  30      12.101   9.049 -22.745  1.00 24.45           C  
ATOM    165  C   LEU A  30      12.166  10.079 -21.609  1.00 25.17           C  
ATOM    166  O   LEU A  30      11.735  11.218 -21.783  1.00 24.71           O  
ATOM    167  CB  LEU A  30      10.685   8.485 -22.894  1.00 24.58           C  
ATOM    168  CG  LEU A  30      10.355   7.726 -24.181  1.00 24.43           C  
ATOM    169  CD1 LEU A  30       8.957   7.123 -24.074  1.00 24.86           C  
ATOM    170  CD2 LEU A  30      10.475   8.638 -25.405  1.00 23.76           C  
ATOM    171  N   ASN A  31      12.740   9.692 -20.471  1.00 26.14           N  
ATOM    172  CA  ASN A  31      12.686  10.517 -19.280  1.00 27.14           C  
ATOM    173  C   ASN A  31      14.015  10.991 -18.681  1.00 28.77           C  
ATOM    174  O   ASN A  31      14.064  12.052 -18.040  1.00 28.72           O  
ATOM    175  CB  ASN A  31      11.838   9.806 -18.230  1.00 26.94           C  
ATOM    176  CG  ASN A  31      10.369   9.770 -18.615  1.00 25.77           C  
ATOM    177  OD1 ASN A  31       9.660  10.749 -18.440  1.00 23.57           O  
ATOM    178  ND2 ASN A  31       9.922   8.654 -19.169  1.00 23.40           N  
ATOM    179  N   ASP A  32      15.078  10.219 -18.882  1.00 30.49           N  
ATOM    180  CA  ASP A  32      16.390  10.547 -18.322  1.00 32.36           C  
ATOM    181  C   ASP A  32      17.253  11.376 -19.285  1.00 33.20           C  
ATOM    182  O   ASP A  32      17.508  10.971 -20.432  1.00 33.52           O  
ATOM    183  CB  ASP A  32      17.147   9.270 -17.916  1.00 32.72           C  
ATOM    184  CG  ASP A  32      16.396   8.419 -16.881  1.00 34.71           C  
ATOM    185  OD1 ASP A  32      15.204   8.684 -16.590  1.00 37.29           O  
ATOM    186  OD2 ASP A  32      17.013   7.461 -16.356  1.00 36.91           O  
ATOM    187  N   GLY A  33      17.720  12.532 -18.810  1.00 34.08           N  
ATOM    188  CA  GLY A  33      18.663  13.353 -19.586  1.00 34.73           C  
ATOM    189  C   GLY A  33      20.040  12.711 -19.590  1.00 34.97           C  
ATOM    190  O   GLY A  33      20.983  13.226 -20.187  1.00 35.49           O  
ATOM    191  N   ASP A  34      20.109  11.545 -18.954  1.00 34.72           N  
ATOM    192  CA  ASP A  34      21.331  10.884 -18.534  1.00 34.48           C  
ATOM    193  C   ASP A  34      21.655   9.668 -19.406  1.00 33.58           C  
ATOM    194  O   ASP A  34      22.732   9.070 -19.290  1.00 33.61           O  
ATOM    195  CB  ASP A  34      21.100  10.412 -17.091  1.00 34.84           C  
ATOM    196  CG  ASP A  34      22.382  10.144 -16.349  1.00 36.93           C  
ATOM    197  OD1 ASP A  34      23.341  10.939 -16.513  1.00 38.64           O  
ATOM    198  OD2 ASP A  34      22.426   9.139 -15.596  1.00 38.82           O  
ATOM    199  N   PHE A  35      20.719   9.319 -20.287  1.00 32.33           N  
ATOM    200  CA  PHE A  35      20.678   8.000 -20.917  1.00 31.07           C  
ATOM    201  C   PHE A  35      21.985   7.541 -21.564  1.00 31.08           C  
ATOM    202  O   PHE A  35      22.524   6.503 -21.195  1.00 30.79           O  
ATOM    203  CB  PHE A  35      19.502   7.899 -21.903  1.00 29.82           C  
ATOM    204  CG  PHE A  35      19.261   6.506 -22.418  1.00 28.36           C  
ATOM    205  CD1 PHE A  35      18.455   5.622 -21.713  1.00 24.32           C  
ATOM    206  CD2 PHE A  35      19.851   6.073 -23.603  1.00 25.13           C  
ATOM    207  CE1 PHE A  35      18.234   4.340 -22.183  1.00 24.65           C  
ATOM    208  CE2 PHE A  35      19.634   4.788 -24.063  1.00 23.95           C  
ATOM    209  CZ  PHE A  35      18.821   3.920 -23.344  1.00 24.65           C  
ATOM    210  N   GLY A  36      22.485   8.313 -22.520  1.00 31.85           N  
ATOM    211  CA  GLY A  36      23.641   7.901 -23.324  1.00 32.41           C  
ATOM    212  C   GLY A  36      24.937   7.947 -22.538  1.00 32.93           C  
ATOM    213  O   GLY A  36      25.776   7.046 -22.655  1.00 32.97           O  
ATOM    214  N   LYS A  37      25.084   9.006 -21.742  1.00 33.29           N  
ATOM    215  CA  LYS A  37      26.255   9.229 -20.893  1.00 34.00           C  
ATOM    216  C   LYS A  37      26.365   8.155 -19.808  1.00 33.53           C  
ATOM    217  O   LYS A  37      27.449   7.619 -19.578  1.00 33.59           O  
ATOM    218  CB  LYS A  37      26.200  10.640 -20.267  1.00 34.24           C  
ATOM    219  CG  LYS A  37      27.424  11.018 -19.430  1.00 35.25           C  
ATOM    220  CD  LYS A  37      27.506  12.523 -19.155  1.00 35.21           C  
ATOM    221  CE  LYS A  37      28.681  12.862 -18.230  1.00 36.47           C  
ATOM    222  NZ  LYS A  37      30.004  12.362 -18.745  1.00 38.59           N  
ATOM    223  N   LYS A  38      25.240   7.839 -19.161  1.00 33.17           N  
ATOM    224  CA  LYS A  38      25.191   6.788 -18.136  1.00 33.27           C  
ATOM    225  C   LYS A  38      25.685   5.439 -18.655  1.00 32.84           C  
ATOM    226  O   LYS A  38      26.487   4.766 -18.012  1.00 32.93           O  
ATOM    227  CB  LYS A  38      23.776   6.642 -17.565  1.00 33.25           C  
ATOM    228  CG  LYS A  38      23.678   5.682 -16.391  1.00 35.01           C  
ATOM    229  CD  LYS A  38      22.342   5.823 -15.658  1.00 36.24           C  
ATOM    230  CE  LYS A  38      22.018   4.566 -14.856  1.00 36.48           C  
ATOM    231  NZ  LYS A  38      21.665   3.425 -15.762  1.00 36.98           N  
ATOM    232  N   ARG A  39      25.212   5.062 -19.830  1.00 32.63           N  
ATOM    233  CA  ARG A  39      25.548   3.776 -20.415  1.00 32.34           C  
ATOM    234  C   ARG A  39      26.921   3.772 -21.077  1.00 32.79           C  
ATOM    235  O   ARG A  39      27.496   2.714 -21.305  1.00 32.59           O  
ATOM    236  CB  ARG A  39      24.456   3.355 -21.393  1.00 31.78           C  
ATOM    237  CG  ARG A  39      23.244   2.819 -20.677  1.00 31.46           C  
ATOM    238  CD  ARG A  39      21.951   3.111 -21.393  1.00 29.44           C  
ATOM    239  NE  ARG A  39      20.831   2.733 -20.548  1.00 26.27           N  
ATOM    240  CZ  ARG A  39      20.305   3.509 -19.605  1.00 26.32           C  
ATOM    241  NH1 ARG A  39      19.284   3.056 -18.885  1.00 25.30           N  
ATOM    242  NH2 ARG A  39      20.783   4.734 -19.382  1.00 23.21           N  
ATOM    243  N   GLN A  40      27.450   4.950 -21.377  1.00 33.51           N  
ATOM    244  CA  GLN A  40      28.815   5.041 -21.888  1.00 34.53           C  
ATOM    245  C   GLN A  40      29.844   4.779 -20.790  1.00 34.51           C  
ATOM    246  O   GLN A  40      30.801   4.042 -20.996  1.00 34.76           O  
ATOM    247  CB  GLN A  40      29.053   6.392 -22.540  1.00 34.52           C  
ATOM    248  CG  GLN A  40      29.973   6.302 -23.712  1.00 37.00           C  
ATOM    249  CD  GLN A  40      29.408   7.001 -24.908  1.00 39.79           C  
ATOM    250  OE1 GLN A  40      28.734   6.381 -25.735  1.00 41.69           O  
ATOM    251  NE2 GLN A  40      29.658   8.302 -25.007  1.00 39.16           N  
ATOM    252  N   GLN A  41      29.630   5.384 -19.626  1.00 34.73           N  
ATOM    253  CA  GLN A  41      30.450   5.148 -18.444  1.00 34.88           C  
ATOM    254  C   GLN A  41      30.368   3.690 -17.991  1.00 34.42           C  
ATOM    255  O   GLN A  41      31.399   3.025 -17.842  1.00 34.59           O  
ATOM    256  CB  GLN A  41      30.002   6.069 -17.309  1.00 35.37           C  
ATOM    257  CG  GLN A  41      30.466   7.520 -17.435  1.00 37.44           C  
ATOM    258  CD  GLN A  41      31.505   7.910 -16.369  1.00 41.21           C  
ATOM    259  OE1 GLN A  41      32.278   7.069 -15.887  1.00 42.03           O  
ATOM    260  NE2 GLN A  41      31.517   9.195 -15.998  1.00 40.85           N  
ATOM    261  N   GLN A  42      29.143   3.200 -17.791  1.00 33.51           N  
ATOM    262  CA  GLN A  42      28.900   1.835 -17.308  1.00 32.39           C  
ATOM    263  C   GLN A  42      29.290   0.740 -18.307  1.00 31.35           C  
ATOM    264  O   GLN A  42      29.800  -0.316 -17.912  1.00 31.34           O  
ATOM    265  CB  GLN A  42      27.434   1.669 -16.909  1.00 32.43           C  
ATOM    266  CG  GLN A  42      27.071   0.279 -16.375  1.00 33.21           C  
ATOM    267  CD  GLN A  42      25.666   0.211 -15.776  1.00 33.15           C  
ATOM    268  OE1 GLN A  42      25.161  -0.872 -15.479  1.00 35.72           O  
ATOM    269  NE2 GLN A  42      25.036   1.362 -15.594  1.00 32.95           N  
ATOM    270  N   PHE A  43      29.050   0.974 -19.594  1.00 29.94           N  
ATOM    271  CA  PHE A  43      29.264  -0.091 -20.589  1.00 28.59           C  
ATOM    272  C   PHE A  43      30.408   0.144 -21.570  1.00 28.00           C  
ATOM    273  O   PHE A  43      31.006  -0.814 -22.041  1.00 28.14           O  
ATOM    274  CB  PHE A  43      27.958  -0.453 -21.330  1.00 27.94           C  
ATOM    275  CG  PHE A  43      26.883  -0.998 -20.430  1.00 27.16           C  
ATOM    276  CD1 PHE A  43      26.990  -2.282 -19.888  1.00 26.16           C  
ATOM    277  CD2 PHE A  43      25.776  -0.223 -20.102  1.00 26.08           C  
ATOM    278  CE1 PHE A  43      26.001  -2.789 -19.031  1.00 26.19           C  
ATOM    279  CE2 PHE A  43      24.779  -0.719 -19.252  1.00 26.12           C  
ATOM    280  CZ  PHE A  43      24.895  -2.008 -18.712  1.00 26.42           C  
ATOM    281  N   GLY A  44      30.703   1.398 -21.896  1.00 27.35           N  
ATOM    282  CA  GLY A  44      31.757   1.688 -22.876  1.00 27.09           C  
ATOM    283  C   GLY A  44      31.221   2.444 -24.080  1.00 27.00           C  
ATOM    284  O   GLY A  44      30.013   2.709 -24.151  1.00 27.05           O  
ATOM    285  N   PRO A  45      32.111   2.801 -25.029  1.00 26.54           N  
ATOM    286  CA  PRO A  45      31.752   3.621 -26.198  1.00 26.38           C  
ATOM    287  C   PRO A  45      30.679   3.025 -27.125  1.00 26.02           C  
ATOM    288  O   PRO A  45      29.980   3.775 -27.794  1.00 26.16           O  
ATOM    289  CB  PRO A  45      33.092   3.796 -26.938  1.00 26.13           C  
ATOM    290  CG  PRO A  45      33.941   2.694 -26.462  1.00 25.75           C  
ATOM    291  CD  PRO A  45      33.545   2.454 -25.038  1.00 26.66           C  
ATOM    292  N   ILE A  46      30.566   1.698 -27.162  1.00 25.99           N  
ATOM    293  CA  ILE A  46      29.536   1.008 -27.944  1.00 25.18           C  
ATOM    294  C   ILE A  46      28.656   0.182 -26.995  1.00 25.32           C  
ATOM    295  O   ILE A  46      29.139  -0.739 -26.306  1.00 25.51           O  
ATOM    296  CB  ILE A  46      30.152   0.133 -29.050  1.00 25.40           C  
ATOM    297  CG1 ILE A  46      31.056   0.986 -29.959  1.00 24.27           C  
ATOM    298  CG2 ILE A  46      29.063  -0.545 -29.893  1.00 24.36           C  
ATOM    299  CD1 ILE A  46      31.968   0.189 -30.848  1.00 25.58           C  
ATOM    300  N   PHE A  47      27.375   0.533 -26.927  1.00 24.21           N  
ATOM    301  CA  PHE A  47      26.475  -0.168 -26.018  1.00 23.93           C  
ATOM    302  C   PHE A  47      25.153  -0.593 -26.662  1.00 23.87           C  
ATOM    303  O   PHE A  47      24.752  -0.032 -27.685  1.00 23.91           O  
ATOM    304  CB  PHE A  47      26.284   0.600 -24.686  1.00 23.48           C  
ATOM    305  CG  PHE A  47      25.395   1.833 -24.776  1.00 23.59           C  
ATOM    306  CD1 PHE A  47      23.997   1.716 -24.742  1.00 21.17           C  
ATOM    307  CD2 PHE A  47      25.957   3.115 -24.852  1.00 23.79           C  
ATOM    308  CE1 PHE A  47      23.177   2.843 -24.811  1.00 21.66           C  
ATOM    309  CE2 PHE A  47      25.144   4.259 -24.920  1.00 21.97           C  
ATOM    310  CZ  PHE A  47      23.753   4.124 -24.895  1.00 23.07           C  
ATOM    311  N   LYS A  48      24.506  -1.601 -26.074  1.00 23.68           N  
ATOM    312  CA  LYS A  48      23.187  -2.041 -26.513  1.00 23.69           C  
ATOM    313  C   LYS A  48      22.086  -1.784 -25.468  1.00 23.47           C  
ATOM    314  O   LYS A  48      22.323  -1.734 -24.248  1.00 23.22           O  
ATOM    315  CB  LYS A  48      23.200  -3.514 -26.947  1.00 23.51           C  
ATOM    316  CG  LYS A  48      23.226  -4.505 -25.790  1.00 24.24           C  
ATOM    317  CD  LYS A  48      23.312  -5.935 -26.284  1.00 24.77           C  
ATOM    318  CE  LYS A  48      23.654  -6.870 -25.140  1.00 26.39           C  
ATOM    319  NZ  LYS A  48      22.492  -6.979 -24.235  1.00 29.13           N  
ATOM    320  N   THR A  49      20.873  -1.610 -25.971  1.00 23.09           N  
ATOM    321  CA  THR A  49      19.713  -1.429 -25.130  1.00 22.77           C  
ATOM    322  C   THR A  49      18.513  -1.978 -25.889  1.00 22.63           C  
ATOM    323  O   THR A  49      18.665  -2.571 -26.958  1.00 22.26           O  
ATOM    324  CB  THR A  49      19.532   0.067 -24.749  1.00 22.65           C  
ATOM    325  OG1 THR A  49      18.378   0.229 -23.917  1.00 23.79           O  
ATOM    326  CG2 THR A  49      19.399   0.938 -25.979  1.00 22.70           C  
ATOM    327  N   ARG A  50      17.325  -1.792 -25.329  1.00 22.88           N  
ATOM    328  CA  ARG A  50      16.102  -2.141 -26.032  1.00 22.92           C  
ATOM    329  C   ARG A  50      15.143  -0.975 -25.912  1.00 22.65           C  
ATOM    330  O   ARG A  50      14.907  -0.456 -24.827  1.00 22.57           O  
ATOM    331  CB  ARG A  50      15.513  -3.435 -25.481  1.00 23.11           C  
ATOM    332  CG  ARG A  50      14.082  -3.758 -25.936  1.00 24.07           C  
ATOM    333  CD  ARG A  50      13.632  -5.048 -25.299  1.00 25.34           C  
ATOM    334  NE  ARG A  50      14.343  -6.193 -25.861  1.00 27.55           N  
ATOM    335  CZ  ARG A  50      14.695  -7.281 -25.177  1.00 26.58           C  
ATOM    336  NH1 ARG A  50      14.424  -7.379 -23.883  1.00 27.13           N  
ATOM    337  NH2 ARG A  50      15.340  -8.265 -25.788  1.00 26.29           N  
ATOM    338  N   LEU A  51      14.629  -0.532 -27.049  1.00 22.86           N  
ATOM    339  CA  LEU A  51      13.741   0.616 -27.073  1.00 23.36           C  
ATOM    340  C   LEU A  51      12.575   0.326 -28.004  1.00 23.60           C  
ATOM    341  O   LEU A  51      12.776  -0.139 -29.114  1.00 23.60           O  
ATOM    342  CB  LEU A  51      14.491   1.884 -27.509  1.00 22.81           C  
ATOM    343  CG  LEU A  51      15.776   2.295 -26.764  1.00 22.36           C  
ATOM    344  CD1 LEU A  51      16.488   3.414 -27.537  1.00 20.94           C  
ATOM    345  CD2 LEU A  51      15.514   2.713 -25.336  1.00 20.03           C  
ATOM    346  N   PHE A  52      11.361   0.575 -27.514  1.00 24.96           N  
ATOM    347  CA  PHE A  52      10.111   0.406 -28.282  1.00 25.37           C  
ATOM    348  C   PHE A  52      10.064  -0.956 -28.977  1.00 25.64           C  
ATOM    349  O   PHE A  52       9.718  -1.044 -30.156  1.00 26.38           O  
ATOM    350  CB  PHE A  52       9.955   1.515 -29.331  1.00 25.23           C  
ATOM    351  CG  PHE A  52      10.121   2.911 -28.791  1.00 25.41           C  
ATOM    352  CD1 PHE A  52       9.018   3.631 -28.343  1.00 25.50           C  
ATOM    353  CD2 PHE A  52      11.376   3.513 -28.759  1.00 25.42           C  
ATOM    354  CE1 PHE A  52       9.164   4.917 -27.855  1.00 25.89           C  
ATOM    355  CE2 PHE A  52      11.537   4.804 -28.283  1.00 25.64           C  
ATOM    356  CZ  PHE A  52      10.429   5.508 -27.823  1.00 26.58           C  
ATOM    357  N   GLY A  53      10.474  -1.991 -28.250  1.00 25.66           N  
ATOM    358  CA  GLY A  53      10.471  -3.363 -28.742  1.00 25.33           C  
ATOM    359  C   GLY A  53      11.614  -3.776 -29.648  1.00 25.27           C  
ATOM    360  O   GLY A  53      11.623  -4.914 -30.122  1.00 24.98           O  
ATOM    361  N   LYS A  54      12.565  -2.867 -29.904  1.00 24.70           N  
ATOM    362  CA  LYS A  54      13.746  -3.168 -30.732  1.00 24.34           C  
ATOM    363  C   LYS A  54      15.063  -3.139 -29.946  1.00 23.77           C  
ATOM    364  O   LYS A  54      15.297  -2.261 -29.113  1.00 23.44           O  
ATOM    365  CB  LYS A  54      13.890  -2.190 -31.915  1.00 24.42           C  
ATOM    366  CG  LYS A  54      12.676  -2.045 -32.807  1.00 26.15           C  
ATOM    367  CD  LYS A  54      12.623  -3.120 -33.877  1.00 27.44           C  
ATOM    368  CE  LYS A  54      11.210  -3.304 -34.356  1.00 30.68           C  
ATOM    369  NZ  LYS A  54      10.513  -1.986 -34.455  1.00 31.01           N  
ATOM    370  N   ASN A  55      15.926  -4.098 -30.259  1.00 23.53           N  
ATOM    371  CA  ASN A  55      17.307  -4.119 -29.787  1.00 22.96           C  
ATOM    372  C   ASN A  55      18.099  -3.051 -30.522  1.00 22.24           C  
ATOM    373  O   ASN A  55      18.100  -3.020 -31.759  1.00 21.90           O  
ATOM    374  CB  ASN A  55      17.903  -5.509 -30.024  1.00 23.04           C  
ATOM    375  CG  ASN A  55      17.160  -6.601 -29.240  1.00 23.17           C  
ATOM    376  OD1 ASN A  55      16.575  -6.344 -28.178  1.00 21.30           O  
ATOM    377  ND2 ASN A  55      17.181  -7.815 -29.766  1.00 23.61           N  
ATOM    378  N   VAL A  56      18.750  -2.167 -29.761  1.00 21.44           N  
ATOM    379  CA  VAL A  56      19.408  -0.986 -30.343  1.00 20.53           C  
ATOM    380  C   VAL A  56      20.863  -0.872 -29.866  1.00 21.05           C  
ATOM    381  O   VAL A  56      21.133  -1.001 -28.677  1.00 20.62           O  
ATOM    382  CB  VAL A  56      18.635   0.338 -30.016  1.00 20.66           C  
ATOM    383  CG1 VAL A  56      19.154   1.526 -30.855  1.00 18.06           C  
ATOM    384  CG2 VAL A  56      17.097   0.182 -30.242  1.00 19.88           C  
ATOM    385  N   ILE A  57      21.782  -0.631 -30.804  1.00 21.20           N  
ATOM    386  CA  ILE A  57      23.183  -0.344 -30.477  1.00 21.06           C  
ATOM    387  C   ILE A  57      23.425   1.153 -30.648  1.00 21.11           C  
ATOM    388  O   ILE A  57      23.176   1.700 -31.711  1.00 21.02           O  
ATOM    389  CB  ILE A  57      24.171  -1.172 -31.357  1.00 20.92           C  
ATOM    390  CG1 ILE A  57      23.872  -2.672 -31.225  1.00 20.87           C  
ATOM    391  CG2 ILE A  57      25.631  -0.867 -30.985  1.00 21.57           C  
ATOM    392  CD1 ILE A  57      24.813  -3.591 -32.003  1.00 20.79           C  
ATOM    393  N   PHE A  58      23.870   1.809 -29.579  1.00 21.43           N  
ATOM    394  CA  PHE A  58      24.242   3.222 -29.629  1.00 21.83           C  
ATOM    395  C   PHE A  58      25.747   3.381 -29.919  1.00 22.19           C  
ATOM    396  O   PHE A  58      26.592   2.811 -29.224  1.00 21.95           O  
ATOM    397  CB  PHE A  58      23.904   3.908 -28.305  1.00 21.96           C  
ATOM    398  CG  PHE A  58      22.446   4.327 -28.159  1.00 22.80           C  
ATOM    399  CD1 PHE A  58      22.127   5.638 -27.821  1.00 22.03           C  
ATOM    400  CD2 PHE A  58      21.406   3.411 -28.314  1.00 22.21           C  
ATOM    401  CE1 PHE A  58      20.795   6.041 -27.663  1.00 21.69           C  
ATOM    402  CE2 PHE A  58      20.078   3.804 -28.153  1.00 22.90           C  
ATOM    403  CZ  PHE A  58      19.777   5.117 -27.824  1.00 22.18           C  
ATOM    404  N   ILE A  59      26.055   4.173 -30.941  1.00 22.38           N  
ATOM    405  CA  ILE A  59      27.423   4.505 -31.331  1.00 22.50           C  
ATOM    406  C   ILE A  59      27.574   6.023 -31.440  1.00 22.34           C  
ATOM    407  O   ILE A  59      26.565   6.746 -31.547  1.00 22.16           O  
ATOM    408  CB  ILE A  59      27.798   3.868 -32.695  1.00 22.76           C  
ATOM    409  CG1 ILE A  59      26.887   4.400 -33.827  1.00 23.29           C  
ATOM    410  CG2 ILE A  59      27.789   2.349 -32.589  1.00 23.69           C  
ATOM    411  CD1 ILE A  59      27.274   3.966 -35.241  1.00 22.16           C  
ATOM    412  N   SER A  60      28.823   6.497 -31.404  1.00 21.67           N  
ATOM    413  CA  SER A  60      29.150   7.926 -31.635  1.00 21.33           C  
ATOM    414  C   SER A  60      30.620   8.174 -32.041  1.00 21.05           C  
ATOM    415  O   SER A  60      31.448   7.267 -32.028  1.00 20.24           O  
ATOM    416  CB  SER A  60      28.781   8.776 -30.411  1.00 21.06           C  
ATOM    417  OG  SER A  60      29.591   8.435 -29.306  1.00 21.92           O  
ATOM    418  N   GLY A  61      30.939   9.415 -32.397  1.00 21.33           N  
ATOM    419  CA  GLY A  61      32.286   9.748 -32.833  1.00 21.15           C  
ATOM    420  C   GLY A  61      32.452   9.631 -34.331  1.00 21.35           C  
ATOM    421  O   GLY A  61      31.636   9.001 -35.011  1.00 21.09           O  
ATOM    422  N   ALA A  62      33.529  10.237 -34.839  1.00 21.46           N  
ATOM    423  CA  ALA A  62      33.788  10.327 -36.277  1.00 21.83           C  
ATOM    424  C   ALA A  62      33.760   8.962 -36.989  1.00 22.03           C  
ATOM    425  O   ALA A  62      33.128   8.802 -38.034  1.00 22.34           O  
ATOM    426  CB  ALA A  62      35.116  11.041 -36.527  1.00 21.73           C  
ATOM    427  N   LEU A  63      34.435   7.981 -36.414  1.00 22.27           N  
ATOM    428  CA  LEU A  63      34.584   6.684 -37.066  1.00 22.23           C  
ATOM    429  C   LEU A  63      33.293   5.888 -37.126  1.00 22.05           C  
ATOM    430  O   LEU A  63      33.016   5.242 -38.131  1.00 22.11           O  
ATOM    431  CB  LEU A  63      35.692   5.857 -36.411  1.00 22.55           C  
ATOM    432  CG  LEU A  63      37.157   6.285 -36.579  1.00 22.77           C  
ATOM    433  CD1 LEU A  63      38.011   5.056 -36.515  1.00 24.03           C  
ATOM    434  CD2 LEU A  63      37.427   7.018 -37.886  1.00 23.64           C  
ATOM    435  N   ALA A  64      32.515   5.933 -36.046  1.00 22.32           N  
ATOM    436  CA  ALA A  64      31.207   5.287 -36.008  1.00 22.40           C  
ATOM    437  C   ALA A  64      30.239   5.972 -36.985  1.00 22.63           C  
ATOM    438  O   ALA A  64      29.425   5.300 -37.633  1.00 22.52           O  
ATOM    439  CB  ALA A  64      30.652   5.288 -34.600  1.00 22.08           C  
ATOM    440  N   ASN A  65      30.363   7.296 -37.104  1.00 23.07           N  
ATOM    441  CA  ASN A  65      29.575   8.080 -38.061  1.00 23.84           C  
ATOM    442  C   ASN A  65      29.975   7.779 -39.498  1.00 24.59           C  
ATOM    443  O   ASN A  65      29.135   7.757 -40.392  1.00 24.18           O  
ATOM    444  CB  ASN A  65      29.689   9.589 -37.794  1.00 23.96           C  
ATOM    445  CG  ASN A  65      29.032  10.006 -36.498  1.00 23.42           C  
ATOM    446  OD1 ASN A  65      28.241   9.263 -35.925  1.00 24.64           O  
ATOM    447  ND2 ASN A  65      29.385  11.184 -36.012  1.00 24.51           N  
ATOM    448  N   ARG A  66      31.270   7.565 -39.706  1.00 25.33           N  
ATOM    449  CA  ARG A  66      31.804   7.149 -40.999  1.00 26.40           C  
ATOM    450  C   ARG A  66      31.202   5.800 -41.412  1.00 25.59           C  
ATOM    451  O   ARG A  66      30.627   5.669 -42.476  1.00 25.66           O  
ATOM    452  CB  ARG A  66      33.346   7.093 -40.921  1.00 26.21           C  
ATOM    453  CG  ARG A  66      34.055   6.820 -42.239  1.00 28.48           C  
ATOM    454  CD  ARG A  66      35.563   6.647 -42.049  1.00 29.32           C  
ATOM    455  NE  ARG A  66      36.262   7.914 -41.770  1.00 35.06           N  
ATOM    456  CZ  ARG A  66      37.556   8.009 -41.446  1.00 37.07           C  
ATOM    457  NH1 ARG A  66      38.318   6.915 -41.356  1.00 38.28           N  
ATOM    458  NH2 ARG A  66      38.095   9.201 -41.218  1.00 37.57           N  
ATOM    459  N   PHE A  67      31.335   4.810 -40.537  1.00 26.12           N  
ATOM    460  CA  PHE A  67      30.728   3.484 -40.677  1.00 25.98           C  
ATOM    461  C   PHE A  67      29.236   3.527 -41.089  1.00 26.12           C  
ATOM    462  O   PHE A  67      28.807   2.863 -42.058  1.00 24.77           O  
ATOM    463  CB  PHE A  67      30.960   2.732 -39.345  1.00 26.48           C  
ATOM    464  CG  PHE A  67      30.095   1.514 -39.138  1.00 27.32           C  
ATOM    465  CD1 PHE A  67      30.255   0.371 -39.924  1.00 29.44           C  
ATOM    466  CD2 PHE A  67      29.144   1.497 -38.128  1.00 28.94           C  
ATOM    467  CE1 PHE A  67      29.453  -0.759 -39.723  1.00 29.47           C  
ATOM    468  CE2 PHE A  67      28.340   0.369 -37.917  1.00 29.97           C  
ATOM    469  CZ  PHE A  67      28.498  -0.762 -38.720  1.00 28.58           C  
ATOM    470  N   LEU A  68      28.461   4.328 -40.358  1.00 26.35           N  
ATOM    471  CA  LEU A  68      27.017   4.434 -40.580  1.00 26.99           C  
ATOM    472  C   LEU A  68      26.668   5.160 -41.881  1.00 26.85           C  
ATOM    473  O   LEU A  68      25.619   4.917 -42.447  1.00 26.94           O  
ATOM    474  CB  LEU A  68      26.350   5.101 -39.367  1.00 26.89           C  
ATOM    475  CG  LEU A  68      24.838   4.948 -39.190  1.00 27.68           C  
ATOM    476  CD1 LEU A  68      24.421   3.551 -38.735  1.00 27.68           C  
ATOM    477  CD2 LEU A  68      24.395   5.962 -38.193  1.00 27.99           C  
ATOM    478  N   PHE A  69      27.556   6.031 -42.358  1.00 27.15           N  
ATOM    479  CA  PHE A  69      27.314   6.770 -43.597  1.00 27.50           C  
ATOM    480  C   PHE A  69      28.180   6.267 -44.768  1.00 28.58           C  
ATOM    481  O   PHE A  69      28.493   7.024 -45.691  1.00 27.86           O  
ATOM    482  CB  PHE A  69      27.488   8.285 -43.387  1.00 26.72           C  
ATOM    483  CG  PHE A  69      26.687   8.852 -42.231  1.00 25.29           C  
ATOM    484  CD1 PHE A  69      25.351   8.493 -42.033  1.00 23.84           C  
ATOM    485  CD2 PHE A  69      27.266   9.780 -41.357  1.00 24.79           C  
ATOM    486  CE1 PHE A  69      24.618   9.025 -40.967  1.00 22.77           C  
ATOM    487  CE2 PHE A  69      26.535  10.313 -40.286  1.00 23.20           C  
ATOM    488  CZ  PHE A  69      25.210   9.934 -40.102  1.00 23.15           C  
ATOM    489  N   THR A  70      28.522   4.975 -44.730  1.00 29.68           N  
ATOM    490  CA  THR A  70      29.345   4.334 -45.761  1.00 31.08           C  
ATOM    491  C   THR A  70      28.694   3.035 -46.233  1.00 31.66           C  
ATOM    492  O   THR A  70      28.141   2.288 -45.421  1.00 31.06           O  
ATOM    493  CB  THR A  70      30.780   4.043 -45.228  1.00 31.36           C  
ATOM    494  OG1 THR A  70      31.452   5.285 -44.973  1.00 32.06           O  
ATOM    495  CG2 THR A  70      31.604   3.236 -46.239  1.00 32.67           C  
ATOM    496  N   LYS A  71      28.753   2.776 -47.546  1.00 32.17           N  
ATOM    497  CA  LYS A  71      28.110   1.599 -48.140  1.00 32.86           C  
ATOM    498  C   LYS A  71      26.752   1.421 -47.486  1.00 32.95           C  
ATOM    499  O   LYS A  71      26.400   0.331 -47.013  1.00 33.62           O  
ATOM    500  CB  LYS A  71      28.981   0.344 -47.960  1.00 32.86           C  
ATOM    501  CG  LYS A  71      30.411   0.500 -48.462  1.00 33.46           C  
ATOM    502  CD  LYS A  71      31.285  -0.682 -48.056  1.00 33.73           C  
ATOM    503  CE  LYS A  71      32.720  -0.506 -48.542  1.00 35.49           C  
ATOM    504  NZ  LYS A  71      33.310   0.835 -48.181  1.00 35.52           N  
ATOM    505  N   GLU A  72      26.007   2.522 -47.453  1.00 33.13           N  
ATOM    506  CA  GLU A  72      24.804   2.680 -46.640  1.00 33.23           C  
ATOM    507  C   GLU A  72      23.572   1.959 -47.208  1.00 33.84           C  
ATOM    508  O   GLU A  72      22.845   1.267 -46.484  1.00 34.13           O  
ATOM    509  CB  GLU A  72      24.529   4.174 -46.517  1.00 33.05           C  
ATOM    510  CG  GLU A  72      23.470   4.555 -45.532  1.00 31.77           C  
ATOM    511  CD  GLU A  72      23.292   6.044 -45.443  1.00 29.62           C  
ATOM    512  OE1 GLU A  72      24.118   6.764 -46.040  1.00 25.99           O  
ATOM    513  OE2 GLU A  72      22.322   6.485 -44.780  1.00 28.69           O  
ATOM    514  N   GLN A  73      23.352   2.145 -48.506  1.00 34.18           N  
ATOM    515  CA  GLN A  73      22.257   1.539 -49.271  1.00 34.49           C  
ATOM    516  C   GLN A  73      22.102   0.018 -49.065  1.00 33.97           C  
ATOM    517  O   GLN A  73      20.989  -0.497 -48.964  1.00 34.58           O  
ATOM    518  CB  GLN A  73      22.469   1.832 -50.767  1.00 34.61           C  
ATOM    519  CG  GLN A  73      23.133   3.192 -51.094  1.00 36.80           C  
ATOM    520  CD  GLN A  73      24.613   3.264 -50.694  1.00 38.30           C  
ATOM    521  OE1 GLN A  73      25.287   2.240 -50.585  1.00 40.95           O  
ATOM    522  NE2 GLN A  73      25.116   4.476 -50.476  1.00 37.89           N  
ATOM    523  N   GLU A  74      23.223  -0.693 -49.016  1.00 33.40           N  
ATOM    524  CA  GLU A  74      23.228  -2.145 -48.841  1.00 32.27           C  
ATOM    525  C   GLU A  74      23.206  -2.582 -47.373  1.00 31.72           C  
ATOM    526  O   GLU A  74      23.039  -3.769 -47.086  1.00 31.89           O  
ATOM    527  CB  GLU A  74      24.444  -2.745 -49.544  1.00 32.63           C  
ATOM    528  N   THR A  75      23.370  -1.633 -46.451  1.00 30.39           N  
ATOM    529  CA  THR A  75      23.557  -1.963 -45.036  1.00 29.70           C  
ATOM    530  C   THR A  75      22.547  -1.325 -44.081  1.00 28.66           C  
ATOM    531  O   THR A  75      22.065  -1.986 -43.162  1.00 28.53           O  
ATOM    532  CB  THR A  75      24.971  -1.562 -44.578  1.00 30.03           C  
ATOM    533  OG1 THR A  75      25.922  -1.994 -45.557  1.00 30.46           O  
ATOM    534  CG2 THR A  75      25.315  -2.164 -43.215  1.00 30.13           C  
ATOM    535  N   PHE A  76      22.253  -0.043 -44.288  1.00 27.69           N  
ATOM    536  CA  PHE A  76      21.455   0.731 -43.331  1.00 27.12           C  
ATOM    537  C   PHE A  76      20.156   1.279 -43.928  1.00 26.52           C  
ATOM    538  O   PHE A  76      20.131   1.852 -45.020  1.00 26.11           O  
ATOM    539  CB  PHE A  76      22.301   1.851 -42.705  1.00 26.98           C  
ATOM    540  CG  PHE A  76      23.508   1.347 -41.958  1.00 26.46           C  
ATOM    541  CD1 PHE A  76      23.357   0.604 -40.788  1.00 26.93           C  
ATOM    542  CD2 PHE A  76      24.790   1.603 -42.424  1.00 26.46           C  
ATOM    543  CE1 PHE A  76      24.457   0.129 -40.096  1.00 26.69           C  
ATOM    544  CE2 PHE A  76      25.904   1.128 -41.732  1.00 26.76           C  
ATOM    545  CZ  PHE A  76      25.728   0.384 -40.567  1.00 26.80           C  
ATOM    546  N   GLN A  77      19.072   1.068 -43.196  1.00 26.15           N  
ATOM    547  CA  GLN A  77      17.755   1.533 -43.611  1.00 25.41           C  
ATOM    548  C   GLN A  77      17.249   2.462 -42.525  1.00 23.92           C  
ATOM    549  O   GLN A  77      17.077   2.029 -41.391  1.00 23.65           O  
ATOM    550  CB  GLN A  77      16.829   0.319 -43.783  1.00 25.80           C  
ATOM    551  CG  GLN A  77      15.380   0.629 -44.086  1.00 28.36           C  
ATOM    552  CD  GLN A  77      14.690  -0.540 -44.757  1.00 32.65           C  
ATOM    553  OE1 GLN A  77      13.947  -1.293 -44.111  1.00 33.79           O  
ATOM    554  NE2 GLN A  77      14.956  -0.723 -46.058  1.00 32.32           N  
ATOM    555  N   ALA A  78      17.009   3.730 -42.863  1.00 22.86           N  
ATOM    556  CA  ALA A  78      16.553   4.705 -41.858  1.00 22.10           C  
ATOM    557  C   ALA A  78      15.254   4.297 -41.169  1.00 21.18           C  
ATOM    558  O   ALA A  78      14.360   3.709 -41.769  1.00 21.22           O  
ATOM    559  CB  ALA A  78      16.433   6.104 -42.444  1.00 21.58           C  
ATOM    560  N   THR A  79      15.159   4.610 -39.891  1.00 20.76           N  
ATOM    561  CA  THR A  79      13.935   4.350 -39.158  1.00 20.01           C  
ATOM    562  C   THR A  79      13.770   5.363 -38.028  1.00 19.59           C  
ATOM    563  O   THR A  79      14.640   6.195 -37.788  1.00 18.74           O  
ATOM    564  CB  THR A  79      13.891   2.876 -38.669  1.00 20.47           C  
ATOM    565  OG1 THR A  79      12.551   2.520 -38.330  1.00 19.77           O  
ATOM    566  CG2 THR A  79      14.837   2.657 -37.488  1.00 19.36           C  
ATOM    567  N   TRP A  80      12.628   5.292 -37.352  1.00 19.49           N  
ATOM    568  CA  TRP A  80      12.327   6.161 -36.227  1.00 19.02           C  
ATOM    569  C   TRP A  80      11.549   5.319 -35.223  1.00 19.18           C  
ATOM    570  O   TRP A  80      10.946   4.326 -35.612  1.00 19.23           O  
ATOM    571  CB  TRP A  80      11.534   7.394 -36.684  1.00 18.04           C  
ATOM    572  CG  TRP A  80      12.390   8.445 -37.426  1.00 17.95           C  
ATOM    573  CD1 TRP A  80      12.365   8.736 -38.763  1.00 17.11           C  
ATOM    574  CD2 TRP A  80      13.404   9.289 -36.855  1.00 17.05           C  
ATOM    575  NE1 TRP A  80      13.291   9.713 -39.054  1.00 18.03           N  
ATOM    576  CE2 TRP A  80      13.938  10.073 -37.904  1.00 16.12           C  
ATOM    577  CE3 TRP A  80      13.915   9.455 -35.554  1.00 15.32           C  
ATOM    578  CZ2 TRP A  80      14.949  11.010 -37.699  1.00 16.52           C  
ATOM    579  CZ3 TRP A  80      14.918  10.399 -35.351  1.00 17.32           C  
ATOM    580  CH2 TRP A  80      15.420  11.165 -36.417  1.00 16.37           C  
ATOM    581  N   PRO A  81      11.594   5.685 -33.929  1.00 19.21           N  
ATOM    582  CA  PRO A  81      10.754   5.043 -32.907  1.00 19.94           C  
ATOM    583  C   PRO A  81       9.263   4.891 -33.310  1.00 19.91           C  
ATOM    584  O   PRO A  81       8.735   5.697 -34.072  1.00 20.35           O  
ATOM    585  CB  PRO A  81      10.920   5.970 -31.702  1.00 19.83           C  
ATOM    586  CG  PRO A  81      12.314   6.547 -31.879  1.00 18.86           C  
ATOM    587  CD  PRO A  81      12.471   6.725 -33.352  1.00 19.57           C  
ATOM    588  N   LEU A  82       8.607   3.853 -32.802  1.00 20.49           N  
ATOM    589  CA  LEU A  82       7.245   3.497 -33.225  1.00 21.11           C  
ATOM    590  C   LEU A  82       6.246   4.662 -33.184  1.00 21.03           C  
ATOM    591  O   LEU A  82       5.435   4.828 -34.110  1.00 21.22           O  
ATOM    592  CB  LEU A  82       6.700   2.296 -32.401  1.00 21.04           C  
ATOM    593  CG  LEU A  82       5.275   1.854 -32.794  1.00 21.60           C  
ATOM    594  CD1 LEU A  82       5.214   1.492 -34.278  1.00 22.33           C  
ATOM    595  CD2 LEU A  82       4.720   0.714 -31.934  1.00 21.56           C  
ATOM    596  N   SER A  83       6.293   5.442 -32.104  1.00 20.64           N  
ATOM    597  CA  SER A  83       5.450   6.620 -31.947  1.00 20.76           C  
ATOM    598  C   SER A  83       5.698   7.657 -33.047  1.00 20.22           C  
ATOM    599  O   SER A  83       4.752   8.223 -33.590  1.00 19.81           O  
ATOM    600  CB  SER A  83       5.693   7.258 -30.578  1.00 21.07           C  
ATOM    601  OG  SER A  83       7.062   7.618 -30.431  1.00 22.18           O  
ATOM    602  N   THR A  84       6.975   7.904 -33.352  1.00 19.75           N  
ATOM    603  CA  THR A  84       7.379   8.882 -34.373  1.00 18.87           C  
ATOM    604  C   THR A  84       6.881   8.486 -35.760  1.00 18.78           C  
ATOM    605  O   THR A  84       6.368   9.320 -36.498  1.00 19.54           O  
ATOM    606  CB  THR A  84       8.923   9.042 -34.448  1.00 18.98           C  
ATOM    607  OG1 THR A  84       9.492   8.906 -33.145  1.00 17.27           O  
ATOM    608  CG2 THR A  84       9.307  10.397 -35.054  1.00 17.54           C  
ATOM    609  N   ARG A  85       7.041   7.215 -36.103  1.00 19.01           N  
ATOM    610  CA  ARG A  85       6.633   6.725 -37.410  1.00 19.33           C  
ATOM    611  C   ARG A  85       5.143   6.888 -37.643  1.00 18.46           C  
ATOM    612  O   ARG A  85       4.751   7.452 -38.649  1.00 18.42           O  
ATOM    613  CB  ARG A  85       7.087   5.276 -37.621  1.00 20.25           C  
ATOM    614  CG  ARG A  85       8.528   5.195 -38.124  1.00 22.25           C  
ATOM    615  CD  ARG A  85       8.958   3.773 -38.446  1.00 24.82           C  
ATOM    616  NE  ARG A  85       9.138   3.000 -37.225  1.00 29.05           N  
ATOM    617  CZ  ARG A  85       8.333   2.014 -36.836  1.00 29.90           C  
ATOM    618  NH1 ARG A  85       7.286   1.663 -37.585  1.00 29.09           N  
ATOM    619  NH2 ARG A  85       8.582   1.379 -35.700  1.00 30.15           N  
ATOM    620  N   ILE A  86       4.332   6.451 -36.673  1.00 18.06           N  
ATOM    621  CA  ILE A  86       2.871   6.579 -36.722  1.00 17.44           C  
ATOM    622  C   ILE A  86       2.408   8.029 -36.882  1.00 17.98           C  
ATOM    623  O   ILE A  86       1.517   8.321 -37.683  1.00 18.49           O  
ATOM    624  CB  ILE A  86       2.190   5.941 -35.453  1.00 17.23           C  
ATOM    625  CG1 ILE A  86       2.458   4.432 -35.407  1.00 16.52           C  
ATOM    626  CG2 ILE A  86       0.703   6.244 -35.432  1.00 16.93           C  
ATOM    627  CD1 ILE A  86       1.963   3.709 -34.147  1.00 16.83           C  
ATOM    628  N   LEU A  87       3.032   8.938 -36.137  1.00 18.34           N  
ATOM    629  CA  LEU A  87       2.636  10.349 -36.127  1.00 18.19           C  
ATOM    630  C   LEU A  87       3.118  11.160 -37.332  1.00 18.55           C  
ATOM    631  O   LEU A  87       2.468  12.135 -37.722  1.00 18.02           O  
ATOM    632  CB  LEU A  87       3.062  11.016 -34.807  1.00 18.38           C  
ATOM    633  CG  LEU A  87       2.260  10.531 -33.585  1.00 18.40           C  
ATOM    634  CD1 LEU A  87       2.957  10.881 -32.279  1.00 18.07           C  
ATOM    635  CD2 LEU A  87       0.866  11.111 -33.617  1.00 17.32           C  
ATOM    636  N   LEU A  88       4.260  10.774 -37.897  1.00 18.76           N  
ATOM    637  CA  LEU A  88       4.743  11.337 -39.154  1.00 19.74           C  
ATOM    638  C   LEU A  88       3.893  10.905 -40.348  1.00 20.33           C  
ATOM    639  O   LEU A  88       3.640  11.703 -41.250  1.00 20.98           O  
ATOM    640  CB  LEU A  88       6.192  10.910 -39.408  1.00 19.41           C  
ATOM    641  CG  LEU A  88       7.346  11.628 -38.710  1.00 20.31           C  
ATOM    642  CD1 LEU A  88       8.619  10.842 -38.990  1.00 20.74           C  
ATOM    643  CD2 LEU A  88       7.456  13.030 -39.254  1.00 20.98           C  
ATOM    644  N   GLY A  89       3.476   9.637 -40.351  1.00 20.80           N  
ATOM    645  CA  GLY A  89       2.703   9.066 -41.440  1.00 21.04           C  
ATOM    646  C   GLY A  89       3.553   8.257 -42.402  1.00 21.78           C  
ATOM    647  O   GLY A  89       4.777   8.473 -42.492  1.00 21.55           O  
ATOM    648  N   PRO A  90       2.919   7.329 -43.149  1.00 21.61           N  
ATOM    649  CA  PRO A  90       3.660   6.493 -44.098  1.00 21.20           C  
ATOM    650  C   PRO A  90       4.133   7.251 -45.350  1.00 20.96           C  
ATOM    651  O   PRO A  90       4.992   6.768 -46.078  1.00 21.38           O  
ATOM    652  CB  PRO A  90       2.641   5.402 -44.477  1.00 21.38           C  
ATOM    653  CG  PRO A  90       1.314   6.051 -44.333  1.00 21.29           C  
ATOM    654  CD  PRO A  90       1.475   7.017 -43.145  1.00 21.96           C  
ATOM    655  N   ASN A  91       3.592   8.436 -45.576  1.00 20.63           N  
ATOM    656  CA  ASN A  91       3.864   9.204 -46.789  1.00 20.09           C  
ATOM    657  C   ASN A  91       4.744  10.442 -46.595  1.00 19.47           C  
ATOM    658  O   ASN A  91       4.643  11.413 -47.346  1.00 18.76           O  
ATOM    659  CB  ASN A  91       2.537   9.557 -47.451  1.00 20.40           C  
ATOM    660  CG  ASN A  91       1.776   8.321 -47.892  1.00 21.30           C  
ATOM    661  OD1 ASN A  91       2.311   7.486 -48.620  1.00 23.24           O  
ATOM    662  ND2 ASN A  91       0.531   8.193 -47.449  1.00 21.90           N  
ATOM    663  N   ALA A  92       5.610  10.387 -45.580  1.00 18.98           N  
ATOM    664  CA  ALA A  92       6.545  11.466 -45.278  1.00 18.67           C  
ATOM    665  C   ALA A  92       7.970  11.046 -45.678  1.00 18.10           C  
ATOM    666  O   ALA A  92       8.294   9.860 -45.666  1.00 17.68           O  
ATOM    667  CB  ALA A  92       6.488  11.815 -43.806  1.00 19.14           C  
ATOM    668  N   LEU A  93       8.808  12.004 -46.042  1.00 16.80           N  
ATOM    669  CA  LEU A  93      10.192  11.691 -46.425  1.00 17.07           C  
ATOM    670  C   LEU A  93      10.926  10.920 -45.334  1.00 17.00           C  
ATOM    671  O   LEU A  93      11.597   9.917 -45.601  1.00 17.53           O  
ATOM    672  CB  LEU A  93      10.961  12.960 -46.778  1.00 16.68           C  
ATOM    673  CG  LEU A  93      12.362  12.774 -47.387  1.00 17.74           C  
ATOM    674  CD1 LEU A  93      12.297  12.268 -48.813  1.00 14.90           C  
ATOM    675  CD2 LEU A  93      13.146  14.092 -47.303  1.00 16.30           C  
ATOM    676  N   ALA A  94      10.758  11.366 -44.101  1.00 16.98           N  
ATOM    677  CA  ALA A  94      11.337  10.679 -42.959  1.00 17.82           C  
ATOM    678  C   ALA A  94      10.949   9.187 -42.876  1.00 18.00           C  
ATOM    679  O   ALA A  94      11.654   8.414 -42.264  1.00 18.04           O  
ATOM    680  CB  ALA A  94      10.965  11.407 -41.681  1.00 17.70           C  
ATOM    681  N   THR A  95       9.836   8.794 -43.500  1.00 18.57           N  
ATOM    682  CA  THR A  95       9.343   7.399 -43.425  1.00 19.02           C  
ATOM    683  C   THR A  95       9.373   6.687 -44.796  1.00 19.71           C  
ATOM    684  O   THR A  95       8.919   5.543 -44.952  1.00 19.46           O  
ATOM    685  CB  THR A  95       7.915   7.340 -42.797  1.00 18.83           C  
ATOM    686  OG1 THR A  95       7.014   8.120 -43.586  1.00 18.25           O  
ATOM    687  CG2 THR A  95       7.919   7.905 -41.363  1.00 19.38           C  
ATOM    688  N   GLN A  96       9.914   7.377 -45.788  1.00 21.31           N  
ATOM    689  CA  GLN A  96      10.084   6.824 -47.138  1.00 22.63           C  
ATOM    690  C   GLN A  96      11.424   6.126 -47.310  1.00 23.95           C  
ATOM    691  O   GLN A  96      12.417   6.493 -46.664  1.00 22.88           O  
ATOM    692  CB  GLN A  96       9.886   7.922 -48.189  1.00 22.20           C  
ATOM    693  CG  GLN A  96       8.402   8.258 -48.318  1.00 22.04           C  
ATOM    694  CD  GLN A  96       8.119   9.519 -49.075  1.00 21.99           C  
ATOM    695  OE1 GLN A  96       8.878  10.501 -49.012  1.00 21.44           O  
ATOM    696  NE2 GLN A  96       7.000   9.516 -49.803  1.00 22.72           N  
ATOM    697  N   MET A  97      11.423   5.105 -48.172  1.00 25.85           N  
ATOM    698  CA  MET A  97      12.606   4.295 -48.456  1.00 27.38           C  
ATOM    699  C   MET A  97      12.908   4.259 -49.931  1.00 27.53           C  
ATOM    700  O   MET A  97      12.025   4.471 -50.770  1.00 27.27           O  
ATOM    701  CB  MET A  97      12.418   2.843 -47.995  1.00 28.25           C  
ATOM    702  CG  MET A  97      12.157   2.631 -46.514  1.00 32.25           C  
ATOM    703  SD  MET A  97      13.320   3.464 -45.417  1.00 39.06           S  
ATOM    704  CE  MET A  97      14.920   2.957 -46.059  1.00 38.30           C  
ATOM    705  N   GLY A  98      14.177   3.994 -50.232  1.00 28.22           N  
ATOM    706  CA  GLY A  98      14.626   3.651 -51.580  1.00 28.07           C  
ATOM    707  C   GLY A  98      14.233   4.611 -52.671  1.00 27.80           C  
ATOM    708  O   GLY A  98      14.500   5.810 -52.578  1.00 28.08           O  
ATOM    709  N   GLU A  99      13.595   4.064 -53.706  1.00 27.65           N  
ATOM    710  CA  GLU A  99      13.252   4.811 -54.920  1.00 27.50           C  
ATOM    711  C   GLU A  99      12.305   5.977 -54.663  1.00 26.48           C  
ATOM    712  O   GLU A  99      12.493   7.071 -55.202  1.00 26.46           O  
ATOM    713  CB  GLU A  99      12.674   3.859 -55.986  1.00 27.95           C  
ATOM    714  CG  GLU A  99      12.255   4.540 -57.282  1.00 30.08           C  
ATOM    715  CD  GLU A  99      12.288   3.610 -58.499  1.00 33.57           C  
ATOM    716  OE1 GLU A  99      12.680   2.421 -58.376  1.00 33.85           O  
ATOM    717  OE2 GLU A  99      11.912   4.084 -59.587  1.00 34.75           O  
ATOM    718  N   ILE A 100      11.285   5.735 -53.846  1.00 25.77           N  
ATOM    719  CA  ILE A 100      10.382   6.798 -53.405  1.00 25.44           C  
ATOM    720  C   ILE A 100      11.147   7.872 -52.610  1.00 24.93           C  
ATOM    721  O   ILE A 100      10.988   9.066 -52.858  1.00 24.13           O  
ATOM    722  CB  ILE A 100       9.202   6.232 -52.574  1.00 25.55           C  
ATOM    723  CG1 ILE A 100       8.332   5.301 -53.437  1.00 25.97           C  
ATOM    724  CG2 ILE A 100       8.349   7.361 -52.023  1.00 25.25           C  
ATOM    725  CD1 ILE A 100       7.330   4.480 -52.653  1.00 25.69           C  
ATOM    726  N   HIS A 101      11.977   7.437 -51.660  1.00 24.97           N  
ATOM    727  CA  HIS A 101      12.813   8.366 -50.892  1.00 25.28           C  
ATOM    728  C   HIS A 101      13.733   9.205 -51.788  1.00 25.44           C  
ATOM    729  O   HIS A 101      13.765  10.423 -51.659  1.00 25.16           O  
ATOM    730  CB  HIS A 101      13.618   7.628 -49.805  1.00 25.05           C  
ATOM    731  CG  HIS A 101      14.532   8.520 -49.017  1.00 24.66           C  
ATOM    732  ND1 HIS A 101      15.901   8.524 -49.189  1.00 22.99           N  
ATOM    733  CD2 HIS A 101      14.271   9.444 -48.062  1.00 23.97           C  
ATOM    734  CE1 HIS A 101      16.445   9.410 -48.373  1.00 22.14           C  
ATOM    735  NE2 HIS A 101      15.477   9.990 -47.685  1.00 22.71           N  
ATOM    736  N   ARG A 102      14.460   8.556 -52.700  1.00 26.65           N  
ATOM    737  CA  ARG A 102      15.369   9.262 -53.636  1.00 28.11           C  
ATOM    738  C   ARG A 102      14.608  10.336 -54.401  1.00 27.91           C  
ATOM    739  O   ARG A 102      15.074  11.467 -54.550  1.00 27.96           O  
ATOM    740  CB  ARG A 102      15.991   8.289 -54.647  1.00 27.73           C  
ATOM    741  CG  ARG A 102      17.447   7.873 -54.402  1.00 30.51           C  
ATOM    742  CD  ARG A 102      17.742   6.478 -54.994  1.00 30.19           C  
ATOM    743  NE  ARG A 102      16.860   6.201 -56.132  1.00 34.35           N  
ATOM    744  CZ  ARG A 102      16.394   5.001 -56.478  1.00 35.64           C  
ATOM    745  NH1 ARG A 102      16.724   3.913 -55.792  1.00 34.97           N  
ATOM    746  NH2 ARG A 102      15.582   4.900 -57.527  1.00 36.56           N  
ATOM    747  N   SER A 103      13.419   9.962 -54.861  1.00 28.03           N  
ATOM    748  CA  SER A 103      12.556  10.848 -55.630  1.00 28.38           C  
ATOM    749  C   SER A 103      12.074  12.077 -54.845  1.00 28.20           C  
ATOM    750  O   SER A 103      12.233  13.204 -55.307  1.00 28.46           O  
ATOM    751  CB  SER A 103      11.376  10.052 -56.198  1.00 28.17           C  
ATOM    752  OG  SER A 103      10.429  10.910 -56.785  1.00 29.29           O  
ATOM    753  N   ARG A 104      11.491  11.863 -53.668  1.00 27.97           N  
ATOM    754  CA  ARG A 104      10.953  12.979 -52.877  1.00 27.75           C  
ATOM    755  C   ARG A 104      12.077  13.878 -52.345  1.00 27.66           C  
ATOM    756  O   ARG A 104      11.905  15.072 -52.144  1.00 27.28           O  
ATOM    757  CB  ARG A 104      10.046  12.496 -51.732  1.00 27.32           C  
ATOM    758  CG  ARG A 104       8.930  11.514 -52.096  1.00 27.65           C  
ATOM    759  CD  ARG A 104       8.289  11.729 -53.473  1.00 27.04           C  
ATOM    760  NE  ARG A 104       7.048  10.968 -53.605  1.00 25.66           N  
ATOM    761  CZ  ARG A 104       6.738  10.150 -54.611  1.00 25.49           C  
ATOM    762  NH1 ARG A 104       7.569   9.953 -55.633  1.00 24.73           N  
ATOM    763  NH2 ARG A 104       5.575   9.526 -54.592  1.00 24.57           N  
ATOM    764  N   ARG A 105      13.242  13.288 -52.140  1.00 28.33           N  
ATOM    765  CA  ARG A 105      14.417  14.049 -51.769  1.00 28.77           C  
ATOM    766  C   ARG A 105      14.752  15.112 -52.826  1.00 29.23           C  
ATOM    767  O   ARG A 105      15.014  16.268 -52.501  1.00 29.23           O  
ATOM    768  CB  ARG A 105      15.573  13.087 -51.531  1.00 28.58           C  
ATOM    769  CG  ARG A 105      16.790  13.748 -51.038  1.00 29.36           C  
ATOM    770  CD  ARG A 105      17.313  13.094 -49.795  1.00 28.09           C  
ATOM    771  NE  ARG A 105      18.459  13.879 -49.374  1.00 28.61           N  
ATOM    772  CZ  ARG A 105      18.655  14.378 -48.165  1.00 26.40           C  
ATOM    773  NH1 ARG A 105      17.803  14.149 -47.166  1.00 26.38           N  
ATOM    774  NH2 ARG A 105      19.746  15.085 -47.964  1.00 27.12           N  
ATOM    775  N   LYS A 106      14.710  14.731 -54.092  1.00 29.79           N  
ATOM    776  CA  LYS A 106      14.996  15.674 -55.183  1.00 31.10           C  
ATOM    777  C   LYS A 106      13.884  16.718 -55.368  1.00 30.74           C  
ATOM    778  O   LYS A 106      14.155  17.878 -55.699  1.00 30.45           O  
ATOM    779  CB  LYS A 106      15.282  14.910 -56.482  1.00 31.01           C  
ATOM    780  CG  LYS A 106      16.442  13.927 -56.343  1.00 32.36           C  
ATOM    781  CD  LYS A 106      16.779  13.204 -57.636  1.00 33.04           C  
ATOM    782  CE  LYS A 106      18.193  12.614 -57.587  1.00 35.52           C  
ATOM    783  NZ  LYS A 106      19.255  13.658 -57.751  1.00 36.38           N  
ATOM    784  N   ILE A 107      12.641  16.286 -55.151  1.00 30.74           N  
ATOM    785  CA  ILE A 107      11.453  17.148 -55.196  1.00 30.73           C  
ATOM    786  C   ILE A 107      11.472  18.232 -54.099  1.00 31.22           C  
ATOM    787  O   ILE A 107      11.287  19.430 -54.374  1.00 30.57           O  
ATOM    788  CB  ILE A 107      10.164  16.288 -55.066  1.00 30.77           C  
ATOM    789  CG1 ILE A 107       9.918  15.504 -56.362  1.00 30.28           C  
ATOM    790  CG2 ILE A 107       8.953  17.147 -54.686  1.00 30.39           C  
ATOM    791  CD1 ILE A 107       8.981  14.355 -56.220  1.00 30.83           C  
ATOM    792  N   LEU A 108      11.709  17.795 -52.863  1.00 31.91           N  
ATOM    793  CA  LEU A 108      11.695  18.688 -51.704  1.00 32.78           C  
ATOM    794  C   LEU A 108      12.858  19.683 -51.713  1.00 33.34           C  
ATOM    795  O   LEU A 108      12.676  20.838 -51.342  1.00 33.31           O  
ATOM    796  CB  LEU A 108      11.595  17.881 -50.387  1.00 32.58           C  
ATOM    797  CG  LEU A 108      10.198  17.298 -50.084  1.00 32.31           C  
ATOM    798  CD1 LEU A 108      10.230  15.997 -49.284  1.00 32.15           C  
ATOM    799  CD2 LEU A 108       9.315  18.309 -49.384  1.00 32.57           C  
ATOM    800  N   TYR A 109      14.028  19.254 -52.179  1.00 34.63           N  
ATOM    801  CA  TYR A 109      15.202  20.133 -52.257  1.00 35.99           C  
ATOM    802  C   TYR A 109      14.919  21.424 -53.038  1.00 36.05           C  
ATOM    803  O   TYR A 109      15.424  22.488 -52.702  1.00 35.53           O  
ATOM    804  CB  TYR A 109      16.413  19.385 -52.837  1.00 37.29           C  
ATOM    805  CG  TYR A 109      17.633  20.265 -53.038  1.00 39.48           C  
ATOM    806  CD1 TYR A 109      18.177  20.999 -51.971  1.00 41.33           C  
ATOM    807  CD2 TYR A 109      18.248  20.370 -54.296  1.00 41.20           C  
ATOM    808  CE1 TYR A 109      19.300  21.821 -52.151  1.00 41.49           C  
ATOM    809  CE2 TYR A 109      19.378  21.193 -54.485  1.00 41.42           C  
ATOM    810  CZ  TYR A 109      19.895  21.910 -53.404  1.00 40.67           C  
ATOM    811  OH  TYR A 109      21.003  22.729 -53.566  1.00 40.90           O  
ATOM    812  N   GLN A 110      14.083  21.320 -54.060  1.00 36.33           N  
ATOM    813  CA  GLN A 110      13.689  22.474 -54.857  1.00 37.01           C  
ATOM    814  C   GLN A 110      13.059  23.609 -54.030  1.00 36.93           C  
ATOM    815  O   GLN A 110      13.110  24.769 -54.430  1.00 36.87           O  
ATOM    816  CB  GLN A 110      12.769  22.033 -55.994  1.00 37.32           C  
ATOM    817  CG  GLN A 110      13.487  21.215 -57.074  1.00 38.97           C  
ATOM    818  CD  GLN A 110      14.325  22.087 -57.996  1.00 42.09           C  
ATOM    819  OE1 GLN A 110      13.850  23.113 -58.501  1.00 43.74           O  
ATOM    820  NE2 GLN A 110      15.577  21.686 -58.221  1.00 42.29           N  
ATOM    821  N   ALA A 111      12.491  23.270 -52.872  1.00 36.78           N  
ATOM    822  CA  ALA A 111      11.981  24.283 -51.945  1.00 36.69           C  
ATOM    823  C   ALA A 111      13.092  25.052 -51.240  1.00 36.64           C  
ATOM    824  O   ALA A 111      12.851  26.133 -50.703  1.00 36.95           O  
ATOM    825  CB  ALA A 111      11.015  23.670 -50.929  1.00 36.66           C  
ATOM    826  N   PHE A 112      14.309  24.514 -51.265  1.00 36.66           N  
ATOM    827  CA  PHE A 112      15.427  25.119 -50.530  1.00 36.50           C  
ATOM    828  C   PHE A 112      16.611  25.527 -51.418  1.00 36.64           C  
ATOM    829  O   PHE A 112      17.755  25.555 -50.971  1.00 36.34           O  
ATOM    830  CB  PHE A 112      15.864  24.195 -49.376  1.00 36.37           C  
ATOM    831  CG  PHE A 112      14.730  23.785 -48.471  1.00 35.75           C  
ATOM    832  CD1 PHE A 112      14.258  24.645 -47.492  1.00 35.69           C  
ATOM    833  CD2 PHE A 112      14.112  22.555 -48.622  1.00 36.57           C  
ATOM    834  CE1 PHE A 112      13.203  24.281 -46.671  1.00 35.96           C  
ATOM    835  CE2 PHE A 112      13.050  22.185 -47.796  1.00 37.02           C  
ATOM    836  CZ  PHE A 112      12.601  23.049 -46.818  1.00 35.66           C  
ATOM    837  N   LEU A 113      16.328  25.860 -52.675  1.00 37.22           N  
ATOM    838  CA  LEU A 113      17.370  26.332 -53.597  1.00 37.89           C  
ATOM    839  C   LEU A 113      17.891  27.707 -53.179  1.00 38.45           C  
ATOM    840  O   LEU A 113      17.126  28.513 -52.649  1.00 38.09           O  
ATOM    841  CB  LEU A 113      16.850  26.372 -55.037  1.00 37.77           C  
ATOM    842  CG  LEU A 113      16.466  25.020 -55.656  1.00 38.18           C  
ATOM    843  CD1 LEU A 113      15.647  25.233 -56.915  1.00 38.14           C  
ATOM    844  CD2 LEU A 113      17.693  24.155 -55.931  1.00 37.04           C  
ATOM    845  N   PRO A 114      19.198  27.968 -53.405  1.00 39.36           N  
ATOM    846  CA  PRO A 114      19.834  29.238 -53.055  1.00 40.19           C  
ATOM    847  C   PRO A 114      18.993  30.484 -53.361  1.00 40.86           C  
ATOM    848  O   PRO A 114      18.940  31.396 -52.534  1.00 41.32           O  
ATOM    849  CB  PRO A 114      21.117  29.223 -53.893  1.00 40.25           C  
ATOM    850  CG  PRO A 114      21.483  27.784 -53.936  1.00 40.01           C  
ATOM    851  CD  PRO A 114      20.172  27.031 -54.004  1.00 39.42           C  
ATOM    852  N   ARG A 115      18.342  30.522 -54.523  1.00 41.29           N  
ATOM    853  CA  ARG A 115      17.532  31.684 -54.897  1.00 41.80           C  
ATOM    854  C   ARG A 115      16.156  31.706 -54.236  1.00 40.93           C  
ATOM    855  O   ARG A 115      15.634  32.773 -53.950  1.00 40.80           O  
ATOM    856  CB  ARG A 115      17.411  31.818 -56.423  1.00 41.82           C  
ATOM    857  CG  ARG A 115      18.636  32.458 -57.076  1.00 43.10           C  
ATOM    858  CD  ARG A 115      18.464  32.616 -58.581  1.00 43.73           C  
ATOM    859  NE  ARG A 115      18.389  31.325 -59.274  1.00 47.81           N  
ATOM    860  CZ  ARG A 115      17.782  31.133 -60.445  1.00 48.81           C  
ATOM    861  NH1 ARG A 115      17.179  32.147 -61.067  1.00 49.14           N  
ATOM    862  NH2 ARG A 115      17.766  29.922 -60.994  1.00 49.45           N  
ATOM    863  N   THR A 116      15.575  30.535 -54.001  1.00 40.98           N  
ATOM    864  CA  THR A 116      14.257  30.430 -53.347  1.00 41.02           C  
ATOM    865  C   THR A 116      14.360  30.850 -51.878  1.00 40.87           C  
ATOM    866  O   THR A 116      13.421  31.409 -51.308  1.00 41.06           O  
ATOM    867  CB  THR A 116      13.685  28.993 -53.427  1.00 41.05           C  
ATOM    868  OG1 THR A 116      13.618  28.572 -54.794  1.00 41.97           O  
ATOM    869  CG2 THR A 116      12.277  28.906 -52.799  1.00 40.78           C  
ATOM    870  N   LEU A 117      15.506  30.558 -51.277  1.00 40.55           N  
ATOM    871  CA  LEU A 117      15.792  30.982 -49.916  1.00 40.34           C  
ATOM    872  C   LEU A 117      15.945  32.502 -49.851  1.00 40.19           C  
ATOM    873  O   LEU A 117      15.444  33.144 -48.927  1.00 39.64           O  
ATOM    874  CB  LEU A 117      17.057  30.292 -49.409  1.00 40.24           C  
ATOM    875  CG  LEU A 117      17.030  28.773 -49.271  1.00 40.15           C  
ATOM    876  CD1 LEU A 117      18.387  28.316 -48.797  1.00 40.74           C  
ATOM    877  CD2 LEU A 117      15.928  28.293 -48.323  1.00 40.53           C  
ATOM    878  N   ASP A 118      16.634  33.063 -50.847  1.00 40.28           N  
ATOM    879  CA  ASP A 118      16.796  34.507 -50.975  1.00 40.05           C  
ATOM    880  C   ASP A 118      15.434  35.205 -51.008  1.00 39.81           C  
ATOM    881  O   ASP A 118      15.257  36.262 -50.398  1.00 39.98           O  
ATOM    882  CB  ASP A 118      17.609  34.843 -52.228  1.00 40.51           C  
ATOM    883  CG  ASP A 118      19.097  34.487 -52.097  1.00 41.36           C  
ATOM    884  OD1 ASP A 118      19.491  33.769 -51.150  1.00 43.10           O  
ATOM    885  OD2 ASP A 118      19.883  34.932 -52.963  1.00 42.58           O  
ATOM    886  N   SER A 119      14.466  34.592 -51.689  1.00 39.40           N  
ATOM    887  CA  SER A 119      13.106  35.134 -51.764  1.00 38.82           C  
ATOM    888  C   SER A 119      12.296  34.983 -50.480  1.00 38.78           C  
ATOM    889  O   SER A 119      11.272  35.649 -50.321  1.00 39.05           O  
ATOM    890  CB  SER A 119      12.333  34.543 -52.959  1.00 38.94           C  
ATOM    891  OG  SER A 119      12.072  33.161 -52.802  1.00 38.18           O  
ATOM    892  N   TYR A 120      12.743  34.119 -49.565  1.00 38.69           N  
ATOM    893  CA  TYR A 120      12.073  33.951 -48.264  1.00 38.19           C  
ATOM    894  C   TYR A 120      12.321  35.132 -47.316  1.00 37.41           C  
ATOM    895  O   TYR A 120      11.516  35.401 -46.421  1.00 37.21           O  
ATOM    896  CB  TYR A 120      12.518  32.654 -47.579  1.00 38.66           C  
ATOM    897  CG  TYR A 120      11.904  31.367 -48.108  1.00 39.65           C  
ATOM    898  CD1 TYR A 120      10.656  31.357 -48.734  1.00 40.76           C  
ATOM    899  CD2 TYR A 120      12.558  30.142 -47.930  1.00 40.53           C  
ATOM    900  CE1 TYR A 120      10.084  30.162 -49.200  1.00 41.69           C  
ATOM    901  CE2 TYR A 120      11.997  28.944 -48.386  1.00 40.31           C  
ATOM    902  CZ  TYR A 120      10.762  28.961 -49.022  1.00 40.87           C  
ATOM    903  OH  TYR A 120      10.199  27.785 -49.471  1.00 40.24           O  
ATOM    904  N   LEU A 121      13.428  35.834 -47.525  1.00 36.68           N  
ATOM    905  CA  LEU A 121      13.916  36.848 -46.575  1.00 36.36           C  
ATOM    906  C   LEU A 121      12.956  37.950 -46.099  1.00 35.67           C  
ATOM    907  O   LEU A 121      12.802  38.121 -44.882  1.00 35.54           O  
ATOM    908  CB  LEU A 121      15.213  37.483 -47.072  1.00 36.69           C  
ATOM    909  CG  LEU A 121      16.468  36.685 -46.773  1.00 37.30           C  
ATOM    910  CD1 LEU A 121      17.646  37.618 -46.860  1.00 37.79           C  
ATOM    911  CD2 LEU A 121      16.353  36.099 -45.378  1.00 38.48           C  
ATOM    912  N   PRO A 122      12.338  38.710 -47.041  1.00 34.96           N  
ATOM    913  CA  PRO A 122      11.459  39.822 -46.659  1.00 34.29           C  
ATOM    914  C   PRO A 122      10.372  39.442 -45.634  1.00 33.68           C  
ATOM    915  O   PRO A 122      10.212  40.145 -44.633  1.00 33.66           O  
ATOM    916  CB  PRO A 122      10.825  40.240 -47.993  1.00 34.26           C  
ATOM    917  CG  PRO A 122      11.826  39.848 -49.014  1.00 34.54           C  
ATOM    918  CD  PRO A 122      12.434  38.581 -48.511  1.00 34.74           C  
ATOM    919  N   LYS A 123       9.648  38.347 -45.877  1.00 32.71           N  
ATOM    920  CA  LYS A 123       8.604  37.894 -44.950  1.00 32.02           C  
ATOM    921  C   LYS A 123       9.211  37.394 -43.656  1.00 31.30           C  
ATOM    922  O   LYS A 123       8.641  37.606 -42.582  1.00 30.71           O  
ATOM    923  CB  LYS A 123       7.724  36.779 -45.543  1.00 32.16           C  
ATOM    924  CG  LYS A 123       6.695  37.198 -46.600  1.00 32.24           C  
ATOM    925  CD  LYS A 123       7.371  37.349 -47.952  1.00 32.84           C  
ATOM    926  CE  LYS A 123       8.318  36.181 -48.219  1.00 32.17           C  
ATOM    927  NZ  LYS A 123       9.585  36.633 -48.827  1.00 31.41           N  
ATOM    928  N   MET A 124      10.354  36.716 -43.767  1.00 30.95           N  
ATOM    929  CA  MET A 124      11.046  36.187 -42.592  1.00 31.30           C  
ATOM    930  C   MET A 124      11.533  37.306 -41.686  1.00 30.10           C  
ATOM    931  O   MET A 124      11.337  37.249 -40.489  1.00 29.81           O  
ATOM    932  CB  MET A 124      12.223  35.281 -42.966  1.00 31.23           C  
ATOM    933  CG  MET A 124      12.857  34.623 -41.733  1.00 31.84           C  
ATOM    934  SD  MET A 124      14.387  33.739 -42.049  1.00 33.57           S  
ATOM    935  CE  MET A 124      13.811  32.389 -43.077  1.00 32.35           C  
ATOM    936  N   ASP A 125      12.163  38.314 -42.278  1.00 29.79           N  
ATOM    937  CA  ASP A 125      12.663  39.469 -41.540  1.00 29.77           C  
ATOM    938  C   ASP A 125      11.526  40.302 -40.939  1.00 29.09           C  
ATOM    939  O   ASP A 125      11.669  40.865 -39.857  1.00 28.35           O  
ATOM    940  CB  ASP A 125      13.549  40.326 -42.449  1.00 30.24           C  
ATOM    941  CG  ASP A 125      14.258  41.448 -41.698  1.00 31.63           C  
ATOM    942  OD1 ASP A 125      14.687  41.234 -40.542  1.00 34.59           O  
ATOM    943  OD2 ASP A 125      14.400  42.544 -42.275  1.00 32.36           O  
ATOM    944  N   GLY A 126      10.403  40.373 -41.656  1.00 28.65           N  
ATOM    945  CA  GLY A 126       9.210  41.061 -41.178  1.00 27.87           C  
ATOM    946  C   GLY A 126       8.594  40.372 -39.970  1.00 27.80           C  
ATOM    947  O   GLY A 126       8.159  41.038 -39.029  1.00 27.04           O  
ATOM    948  N   ILE A 127       8.552  39.037 -39.992  1.00 27.81           N  
ATOM    949  CA  ILE A 127       8.059  38.274 -38.835  1.00 27.94           C  
ATOM    950  C   ILE A 127       9.037  38.439 -37.667  1.00 27.87           C  
ATOM    951  O   ILE A 127       8.623  38.668 -36.526  1.00 27.30           O  
ATOM    952  CB  ILE A 127       7.836  36.762 -39.154  1.00 27.78           C  
ATOM    953  CG1 ILE A 127       6.681  36.579 -40.144  1.00 29.16           C  
ATOM    954  CG2 ILE A 127       7.539  35.965 -37.877  1.00 27.50           C  
ATOM    955  CD1 ILE A 127       6.779  35.313 -41.008  1.00 28.42           C  
ATOM    956  N   VAL A 128      10.335  38.349 -37.973  1.00 28.21           N  
ATOM    957  CA  VAL A 128      11.394  38.425 -36.943  1.00 28.17           C  
ATOM    958  C   VAL A 128      11.413  39.768 -36.168  1.00 28.47           C  
ATOM    959  O   VAL A 128      11.318  39.780 -34.935  1.00 28.31           O  
ATOM    960  CB  VAL A 128      12.773  37.982 -37.497  1.00 27.77           C  
ATOM    961  CG1 VAL A 128      13.893  38.346 -36.556  1.00 27.13           C  
ATOM    962  CG2 VAL A 128      12.773  36.473 -37.693  1.00 27.30           C  
ATOM    963  N   GLN A 129      11.488  40.876 -36.906  1.00 28.77           N  
ATOM    964  CA  GLN A 129      11.450  42.228 -36.337  1.00 29.32           C  
ATOM    965  C   GLN A 129      10.177  42.527 -35.558  1.00 29.43           C  
ATOM    966  O   GLN A 129      10.219  43.212 -34.533  1.00 29.50           O  
ATOM    967  CB  GLN A 129      11.595  43.281 -37.434  1.00 29.21           C  
ATOM    968  CG  GLN A 129      12.893  43.234 -38.201  1.00 31.02           C  
ATOM    969  CD  GLN A 129      14.062  43.769 -37.409  1.00 32.54           C  
ATOM    970  OE1 GLN A 129      14.466  43.183 -36.407  1.00 32.14           O  
ATOM    971  NE2 GLN A 129      14.627  44.882 -37.867  1.00 33.27           N  
ATOM    972  N   GLY A 130       9.043  42.033 -36.053  1.00 29.37           N  
ATOM    973  CA  GLY A 130       7.776  42.182 -35.348  1.00 29.42           C  
ATOM    974  C   GLY A 130       7.858  41.661 -33.924  1.00 29.72           C  
ATOM    975  O   GLY A 130       7.413  42.325 -32.994  1.00 29.96           O  
ATOM    976  N   TYR A 131       8.431  40.473 -33.753  1.00 29.59           N  
ATOM    977  CA  TYR A 131       8.553  39.860 -32.428  1.00 29.76           C  
ATOM    978  C   TYR A 131       9.550  40.575 -31.532  1.00 30.08           C  
ATOM    979  O   TYR A 131       9.289  40.737 -30.350  1.00 30.19           O  
ATOM    980  CB  TYR A 131       8.923  38.377 -32.529  1.00 29.33           C  
ATOM    981  CG  TYR A 131       7.736  37.477 -32.749  1.00 29.50           C  
ATOM    982  CD1 TYR A 131       7.331  37.136 -34.040  1.00 28.85           C  
ATOM    983  CD2 TYR A 131       7.000  36.980 -31.670  1.00 28.34           C  
ATOM    984  CE1 TYR A 131       6.245  36.324 -34.251  1.00 27.13           C  
ATOM    985  CE2 TYR A 131       5.903  36.162 -31.882  1.00 28.45           C  
ATOM    986  CZ  TYR A 131       5.538  35.845 -33.179  1.00 28.19           C  
ATOM    987  OH  TYR A 131       4.460  35.033 -33.415  1.00 29.72           O  
ATOM    988  N   LEU A 132      10.685  40.992 -32.096  1.00 30.59           N  
ATOM    989  CA  LEU A 132      11.718  41.712 -31.343  1.00 31.11           C  
ATOM    990  C   LEU A 132      11.173  43.000 -30.735  1.00 31.82           C  
ATOM    991  O   LEU A 132      11.448  43.316 -29.573  1.00 31.61           O  
ATOM    992  CB  LEU A 132      12.937  42.007 -32.230  1.00 30.67           C  
ATOM    993  CG  LEU A 132      13.801  40.801 -32.612  1.00 30.58           C  
ATOM    994  CD1 LEU A 132      14.770  41.135 -33.724  1.00 28.75           C  
ATOM    995  CD2 LEU A 132      14.538  40.254 -31.396  1.00 29.55           C  
ATOM    996  N   GLU A 133      10.391  43.723 -31.534  1.00 33.10           N  
ATOM    997  CA  GLU A 133       9.715  44.940 -31.100  1.00 34.56           C  
ATOM    998  C   GLU A 133       8.817  44.693 -29.882  1.00 34.75           C  
ATOM    999  O   GLU A 133       8.900  45.424 -28.891  1.00 34.91           O  
ATOM   1000  CB  GLU A 133       8.928  45.556 -32.266  1.00 34.91           C  
ATOM   1001  CG  GLU A 133       7.902  46.616 -31.838  1.00 37.78           C  
ATOM   1002  CD  GLU A 133       7.636  47.655 -32.907  1.00 40.80           C  
ATOM   1003  OE1 GLU A 133       8.609  48.287 -33.382  1.00 43.00           O  
ATOM   1004  OE2 GLU A 133       6.456  47.854 -33.259  1.00 42.16           O  
ATOM   1005  N   GLN A 134       7.972  43.665 -29.958  1.00 35.14           N  
ATOM   1006  CA  GLN A 134       7.149  43.253 -28.824  1.00 35.91           C  
ATOM   1007  C   GLN A 134       8.002  42.926 -27.589  1.00 35.59           C  
ATOM   1008  O   GLN A 134       7.736  43.444 -26.501  1.00 35.72           O  
ATOM   1009  CB  GLN A 134       6.248  42.064 -29.192  1.00 36.25           C  
ATOM   1010  CG  GLN A 134       5.238  41.694 -28.088  1.00 38.53           C  
ATOM   1011  CD  GLN A 134       4.950  40.187 -27.993  1.00 41.49           C  
ATOM   1012  OE1 GLN A 134       5.483  39.385 -28.769  1.00 43.15           O  
ATOM   1013  NE2 GLN A 134       4.103  39.802 -27.033  1.00 41.51           N  
ATOM   1014  N   TRP A 135       9.031  42.091 -27.762  1.00 35.20           N  
ATOM   1015  CA  TRP A 135       9.892  41.678 -26.638  1.00 34.62           C  
ATOM   1016  C   TRP A 135      10.700  42.831 -26.037  1.00 34.63           C  
ATOM   1017  O   TRP A 135      10.916  42.879 -24.824  1.00 34.61           O  
ATOM   1018  CB  TRP A 135      10.831  40.531 -27.028  1.00 33.90           C  
ATOM   1019  CG  TRP A 135      10.136  39.312 -27.566  1.00 33.25           C  
ATOM   1020  CD1 TRP A 135       8.910  38.824 -27.196  1.00 31.99           C  
ATOM   1021  CD2 TRP A 135      10.639  38.421 -28.566  1.00 32.00           C  
ATOM   1022  NE1 TRP A 135       8.620  37.686 -27.913  1.00 32.96           N  
ATOM   1023  CE2 TRP A 135       9.662  37.419 -28.765  1.00 32.07           C  
ATOM   1024  CE3 TRP A 135      11.823  38.372 -29.318  1.00 31.44           C  
ATOM   1025  CZ2 TRP A 135       9.836  36.373 -29.682  1.00 32.22           C  
ATOM   1026  CZ3 TRP A 135      11.990  37.337 -30.233  1.00 32.01           C  
ATOM   1027  CH2 TRP A 135      10.998  36.354 -30.407  1.00 31.83           C  
ATOM   1028  N   GLY A 136      11.143  43.741 -26.893  1.00 34.99           N  
ATOM   1029  CA  GLY A 136      11.843  44.947 -26.458  1.00 36.19           C  
ATOM   1030  C   GLY A 136      11.016  45.916 -25.618  1.00 36.68           C  
ATOM   1031  O   GLY A 136      11.582  46.677 -24.828  1.00 36.82           O  
ATOM   1032  N   LYS A 137       9.690  45.890 -25.802  1.00 37.03           N  
ATOM   1033  CA  LYS A 137       8.740  46.679 -25.003  1.00 37.49           C  
ATOM   1034  C   LYS A 137       8.529  46.105 -23.614  1.00 37.64           C  
ATOM   1035  O   LYS A 137       8.335  46.856 -22.658  1.00 37.76           O  
ATOM   1036  CB  LYS A 137       7.377  46.766 -25.688  1.00 37.71           C  
ATOM   1037  CG  LYS A 137       7.305  47.711 -26.869  1.00 38.82           C  
ATOM   1038  CD  LYS A 137       5.871  47.833 -27.352  1.00 41.20           C  
ATOM   1039  CE  LYS A 137       5.806  47.981 -28.867  1.00 42.52           C  
ATOM   1040  NZ  LYS A 137       4.401  48.071 -29.358  1.00 43.28           N  
ATOM   1041  N   ALA A 138       8.557  44.777 -23.503  1.00 37.66           N  
ATOM   1042  CA  ALA A 138       8.293  44.089 -22.230  1.00 37.54           C  
ATOM   1043  C   ALA A 138       9.396  44.316 -21.204  1.00 37.49           C  
ATOM   1044  O   ALA A 138      10.484  44.794 -21.545  1.00 37.92           O  
ATOM   1045  CB  ALA A 138       8.089  42.581 -22.463  1.00 37.65           C  
ATOM   1046  N   ASN A 139       9.116  43.982 -19.946  1.00 36.99           N  
ATOM   1047  CA  ASN A 139      10.162  43.965 -18.929  1.00 36.86           C  
ATOM   1048  C   ASN A 139      10.917  42.639 -19.048  1.00 36.21           C  
ATOM   1049  O   ASN A 139      11.723  42.469 -19.966  1.00 37.09           O  
ATOM   1050  CB  ASN A 139       9.583  44.186 -17.518  1.00 37.22           C  
ATOM   1051  CG  ASN A 139      10.650  44.592 -16.496  1.00 38.24           C  
ATOM   1052  OD1 ASN A 139      11.608  45.305 -16.821  1.00 39.15           O  
ATOM   1053  ND2 ASN A 139      10.475  44.147 -15.250  1.00 38.43           N  
ATOM   1054  N   GLU A 140      10.647  41.700 -18.147  1.00 34.78           N  
ATOM   1055  CA  GLU A 140      11.121  40.331 -18.298  1.00 33.78           C  
ATOM   1056  C   GLU A 140      10.389  39.607 -19.441  1.00 32.62           C  
ATOM   1057  O   GLU A 140       9.158  39.688 -19.559  1.00 32.16           O  
ATOM   1058  CB  GLU A 140      10.950  39.575 -16.984  1.00 33.79           C  
ATOM   1059  CG  GLU A 140      11.193  38.067 -17.070  1.00 34.43           C  
ATOM   1060  CD  GLU A 140      11.223  37.397 -15.708  1.00 34.57           C  
ATOM   1061  OE1 GLU A 140      10.996  38.085 -14.689  1.00 36.94           O  
ATOM   1062  OE2 GLU A 140      11.492  36.187 -15.648  1.00 36.14           O  
ATOM   1063  N   VAL A 141      11.157  38.930 -20.295  1.00 31.17           N  
ATOM   1064  CA  VAL A 141      10.584  38.010 -21.281  1.00 29.79           C  
ATOM   1065  C   VAL A 141      10.897  36.564 -20.894  1.00 28.50           C  
ATOM   1066  O   VAL A 141      12.056  36.204 -20.714  1.00 28.09           O  
ATOM   1067  CB  VAL A 141      11.071  38.309 -22.717  1.00 29.96           C  
ATOM   1068  CG1 VAL A 141      10.391  37.374 -23.737  1.00 30.79           C  
ATOM   1069  CG2 VAL A 141      10.799  39.762 -23.077  1.00 30.35           C  
ATOM   1070  N   ILE A 142       9.853  35.751 -20.723  1.00 27.12           N  
ATOM   1071  CA  ILE A 142      10.013  34.291 -20.623  1.00 25.35           C  
ATOM   1072  C   ILE A 142      10.197  33.772 -22.057  1.00 24.07           C  
ATOM   1073  O   ILE A 142       9.209  33.512 -22.756  1.00 22.92           O  
ATOM   1074  CB  ILE A 142       8.799  33.623 -19.917  1.00 25.62           C  
ATOM   1075  CG1 ILE A 142       8.587  34.251 -18.533  1.00 26.06           C  
ATOM   1076  CG2 ILE A 142       8.973  32.098 -19.837  1.00 23.88           C  
ATOM   1077  CD1 ILE A 142       7.368  33.697 -17.755  1.00 26.50           C  
ATOM   1078  N   TRP A 143      11.458  33.645 -22.493  1.00 22.13           N  
ATOM   1079  CA  TRP A 143      11.759  33.593 -23.933  1.00 21.27           C  
ATOM   1080  C   TRP A 143      11.395  32.310 -24.656  1.00 21.18           C  
ATOM   1081  O   TRP A 143      10.914  32.362 -25.784  1.00 21.17           O  
ATOM   1082  CB  TRP A 143      13.233  33.886 -24.233  1.00 20.96           C  
ATOM   1083  CG  TRP A 143      13.446  34.772 -25.414  1.00 19.78           C  
ATOM   1084  CD1 TRP A 143      12.544  35.071 -26.391  1.00 19.98           C  
ATOM   1085  CD2 TRP A 143      14.652  35.477 -25.747  1.00 19.94           C  
ATOM   1086  NE1 TRP A 143      13.104  35.937 -27.309  1.00 19.41           N  
ATOM   1087  CE2 TRP A 143      14.397  36.203 -26.933  1.00 19.45           C  
ATOM   1088  CE3 TRP A 143      15.924  35.575 -25.149  1.00 20.77           C  
ATOM   1089  CZ2 TRP A 143      15.366  37.017 -27.537  1.00 19.80           C  
ATOM   1090  CZ3 TRP A 143      16.882  36.399 -25.744  1.00 19.50           C  
ATOM   1091  CH2 TRP A 143      16.596  37.103 -26.925  1.00 20.33           C  
ATOM   1092  N   TYR A 144      11.642  31.162 -24.040  1.00 20.96           N  
ATOM   1093  CA  TYR A 144      11.486  29.922 -24.778  1.00 21.20           C  
ATOM   1094  C   TYR A 144      10.102  29.791 -25.493  1.00 21.37           C  
ATOM   1095  O   TYR A 144      10.074  29.569 -26.697  1.00 21.81           O  
ATOM   1096  CB  TYR A 144      11.894  28.693 -23.945  1.00 20.90           C  
ATOM   1097  CG  TYR A 144      11.736  27.403 -24.720  1.00 21.79           C  
ATOM   1098  CD1 TYR A 144      12.663  27.038 -25.711  1.00 21.84           C  
ATOM   1099  CD2 TYR A 144      10.643  26.562 -24.488  1.00 22.83           C  
ATOM   1100  CE1 TYR A 144      12.506  25.875 -26.452  1.00 21.12           C  
ATOM   1101  CE2 TYR A 144      10.483  25.382 -25.211  1.00 22.42           C  
ATOM   1102  CZ  TYR A 144      11.414  25.050 -26.197  1.00 21.54           C  
ATOM   1103  OH  TYR A 144      11.244  23.892 -26.905  1.00 19.85           O  
ATOM   1104  N   PRO A 145       8.968  29.976 -24.766  1.00 21.64           N  
ATOM   1105  CA  PRO A 145       7.620  29.890 -25.364  1.00 21.71           C  
ATOM   1106  C   PRO A 145       7.364  30.924 -26.452  1.00 21.80           C  
ATOM   1107  O   PRO A 145       6.605  30.664 -27.391  1.00 21.35           O  
ATOM   1108  CB  PRO A 145       6.686  30.177 -24.176  1.00 21.93           C  
ATOM   1109  CG  PRO A 145       7.492  29.901 -22.973  1.00 22.04           C  
ATOM   1110  CD  PRO A 145       8.890  30.269 -23.322  1.00 21.52           C  
ATOM   1111  N   GLN A 146       7.990  32.089 -26.310  1.00 21.82           N  
ATOM   1112  CA  GLN A 146       7.967  33.138 -27.327  1.00 22.33           C  
ATOM   1113  C   GLN A 146       8.675  32.740 -28.616  1.00 22.28           C  
ATOM   1114  O   GLN A 146       8.170  33.002 -29.700  1.00 21.91           O  
ATOM   1115  CB  GLN A 146       8.592  34.426 -26.789  1.00 22.65           C  
ATOM   1116  CG  GLN A 146       7.745  35.152 -25.753  1.00 24.38           C  
ATOM   1117  CD  GLN A 146       6.363  35.531 -26.258  1.00 25.57           C  
ATOM   1118  OE1 GLN A 146       6.210  36.244 -27.265  1.00 26.16           O  
ATOM   1119  NE2 GLN A 146       5.344  35.072 -25.543  1.00 27.16           N  
ATOM   1120  N   LEU A 147       9.856  32.136 -28.481  1.00 22.92           N  
ATOM   1121  CA  LEU A 147      10.615  31.646 -29.626  1.00 23.65           C  
ATOM   1122  C   LEU A 147       9.815  30.587 -30.381  1.00 23.54           C  
ATOM   1123  O   LEU A 147       9.872  30.548 -31.599  1.00 23.11           O  
ATOM   1124  CB  LEU A 147      11.968  31.088 -29.185  1.00 23.70           C  
ATOM   1125  CG  LEU A 147      12.985  32.130 -28.674  1.00 25.36           C  
ATOM   1126  CD1 LEU A 147      14.087  31.428 -27.899  1.00 26.16           C  
ATOM   1127  CD2 LEU A 147      13.580  32.983 -29.804  1.00 24.52           C  
ATOM   1128  N   ARG A 148       9.055  29.771 -29.641  1.00 23.79           N  
ATOM   1129  CA  ARG A 148       8.171  28.759 -30.219  1.00 24.62           C  
ATOM   1130  C   ARG A 148       7.048  29.387 -31.033  1.00 25.16           C  
ATOM   1131  O   ARG A 148       6.669  28.850 -32.072  1.00 25.22           O  
ATOM   1132  CB  ARG A 148       7.580  27.843 -29.145  1.00 24.64           C  
ATOM   1133  CG  ARG A 148       8.580  26.881 -28.541  1.00 24.88           C  
ATOM   1134  CD  ARG A 148       7.919  25.768 -27.750  1.00 25.14           C  
ATOM   1135  NE  ARG A 148       7.243  24.811 -28.619  1.00 24.91           N  
ATOM   1136  CZ  ARG A 148       7.830  23.788 -29.232  1.00 25.71           C  
ATOM   1137  NH1 ARG A 148       9.135  23.571 -29.075  1.00 24.19           N  
ATOM   1138  NH2 ARG A 148       7.105  22.983 -30.015  1.00 24.90           N  
ATOM   1139  N   ARG A 149       6.530  30.528 -30.575  1.00 25.51           N  
ATOM   1140  CA  ARG A 149       5.485  31.237 -31.332  1.00 25.69           C  
ATOM   1141  C   ARG A 149       6.049  31.783 -32.633  1.00 24.69           C  
ATOM   1142  O   ARG A 149       5.463  31.578 -33.690  1.00 24.96           O  
ATOM   1143  CB  ARG A 149       4.826  32.347 -30.508  1.00 25.87           C  
ATOM   1144  CG  ARG A 149       4.032  31.826 -29.304  1.00 29.53           C  
ATOM   1145  CD  ARG A 149       2.877  32.758 -28.898  1.00 33.62           C  
ATOM   1146  NE  ARG A 149       1.585  32.238 -29.366  1.00 38.03           N  
ATOM   1147  CZ  ARG A 149       0.811  31.391 -28.681  1.00 38.43           C  
ATOM   1148  NH1 ARG A 149       1.179  30.961 -27.472  1.00 38.86           N  
ATOM   1149  NH2 ARG A 149      -0.334  30.971 -29.203  1.00 37.45           N  
ATOM   1150  N   MET A 150       7.205  32.440 -32.546  1.00 24.07           N  
ATOM   1151  CA  MET A 150       7.877  33.016 -33.701  1.00 23.29           C  
ATOM   1152  C   MET A 150       8.240  31.979 -34.762  1.00 23.10           C  
ATOM   1153  O   MET A 150       7.862  32.143 -35.920  1.00 23.01           O  
ATOM   1154  CB  MET A 150       9.122  33.785 -33.276  1.00 23.57           C  
ATOM   1155  CG  MET A 150       9.833  34.520 -34.431  1.00 23.70           C  
ATOM   1156  SD  MET A 150      11.524  35.027 -34.036  1.00 23.19           S  
ATOM   1157  CE  MET A 150      12.299  33.441 -33.794  1.00 24.88           C  
ATOM   1158  N   THR A 151       8.965  30.924 -34.376  1.00 22.21           N  
ATOM   1159  CA  THR A 151       9.472  29.973 -35.371  1.00 22.08           C  
ATOM   1160  C   THR A 151       8.332  29.257 -36.078  1.00 22.27           C  
ATOM   1161  O   THR A 151       8.439  28.985 -37.272  1.00 22.53           O  
ATOM   1162  CB  THR A 151      10.452  28.906 -34.813  1.00 21.70           C  
ATOM   1163  OG1 THR A 151       9.786  28.068 -33.860  1.00 20.67           O  
ATOM   1164  CG2 THR A 151      11.677  29.539 -34.203  1.00 19.65           C  
ATOM   1165  N   PHE A 152       7.256  28.944 -35.350  1.00 22.69           N  
ATOM   1166  CA  PHE A 152       6.052  28.396 -35.996  1.00 23.41           C  
ATOM   1167  C   PHE A 152       5.499  29.380 -37.020  1.00 23.78           C  
ATOM   1168  O   PHE A 152       5.189  28.990 -38.142  1.00 25.12           O  
ATOM   1169  CB  PHE A 152       4.951  27.967 -35.009  1.00 23.15           C  
ATOM   1170  CG  PHE A 152       3.776  27.292 -35.691  1.00 22.95           C  
ATOM   1171  CD1 PHE A 152       3.908  26.011 -36.218  1.00 22.62           C  
ATOM   1172  CD2 PHE A 152       2.579  27.962 -35.871  1.00 22.78           C  
ATOM   1173  CE1 PHE A 152       2.842  25.397 -36.895  1.00 23.23           C  
ATOM   1174  CE2 PHE A 152       1.512  27.356 -36.537  1.00 22.56           C  
ATOM   1175  CZ  PHE A 152       1.646  26.079 -37.044  1.00 22.43           C  
ATOM   1176  N   ASP A 153       5.384  30.648 -36.628  1.00 24.23           N  
ATOM   1177  CA  ASP A 153       4.916  31.715 -37.511  1.00 24.22           C  
ATOM   1178  C   ASP A 153       5.713  31.842 -38.803  1.00 23.65           C  
ATOM   1179  O   ASP A 153       5.131  32.081 -39.849  1.00 22.98           O  
ATOM   1180  CB  ASP A 153       4.923  33.065 -36.788  1.00 24.77           C  
ATOM   1181  CG  ASP A 153       3.664  33.304 -35.977  1.00 26.65           C  
ATOM   1182  OD1 ASP A 153       3.012  32.312 -35.573  1.00 28.06           O  
ATOM   1183  OD2 ASP A 153       3.338  34.487 -35.737  1.00 27.49           O  
ATOM   1184  N   VAL A 154       7.040  31.716 -38.715  1.00 23.10           N  
ATOM   1185  CA  VAL A 154       7.909  31.794 -39.893  1.00 22.79           C  
ATOM   1186  C   VAL A 154       7.651  30.587 -40.807  1.00 23.49           C  
ATOM   1187  O   VAL A 154       7.518  30.738 -42.027  1.00 23.80           O  
ATOM   1188  CB  VAL A 154       9.406  31.884 -39.496  1.00 22.72           C  
ATOM   1189  CG1 VAL A 154      10.314  31.805 -40.699  1.00 21.76           C  
ATOM   1190  CG2 VAL A 154       9.690  33.183 -38.753  1.00 22.00           C  
ATOM   1191  N   ALA A 155       7.567  29.404 -40.198  1.00 22.98           N  
ATOM   1192  CA  ALA A 155       7.432  28.168 -40.925  1.00 23.43           C  
ATOM   1193  C   ALA A 155       6.067  28.104 -41.603  1.00 23.88           C  
ATOM   1194  O   ALA A 155       5.993  27.806 -42.797  1.00 24.14           O  
ATOM   1195  CB  ALA A 155       7.653  26.974 -40.013  1.00 22.43           C  
ATOM   1196  N   ALA A 156       5.002  28.409 -40.857  1.00 24.29           N  
ATOM   1197  CA  ALA A 156       3.647  28.403 -41.433  1.00 25.18           C  
ATOM   1198  C   ALA A 156       3.567  29.406 -42.577  1.00 25.78           C  
ATOM   1199  O   ALA A 156       3.067  29.092 -43.656  1.00 26.34           O  
ATOM   1200  CB  ALA A 156       2.600  28.693 -40.371  1.00 24.47           C  
ATOM   1201  N   THR A 157       4.115  30.596 -42.343  1.00 26.36           N  
ATOM   1202  CA  THR A 157       4.127  31.673 -43.336  1.00 27.43           C  
ATOM   1203  C   THR A 157       4.867  31.326 -44.624  1.00 27.82           C  
ATOM   1204  O   THR A 157       4.298  31.446 -45.709  1.00 28.32           O  
ATOM   1205  CB  THR A 157       4.692  32.984 -42.737  1.00 27.02           C  
ATOM   1206  OG1 THR A 157       3.834  33.407 -41.676  1.00 26.52           O  
ATOM   1207  CG2 THR A 157       4.790  34.109 -43.787  1.00 27.81           C  
ATOM   1208  N   LEU A 158       6.120  30.899 -44.505  1.00 28.30           N  
ATOM   1209  CA  LEU A 158       6.966  30.685 -45.681  1.00 28.83           C  
ATOM   1210  C   LEU A 158       6.671  29.393 -46.448  1.00 29.52           C  
ATOM   1211  O   LEU A 158       6.942  29.316 -47.653  1.00 29.19           O  
ATOM   1212  CB  LEU A 158       8.453  30.754 -45.308  1.00 28.65           C  
ATOM   1213  CG  LEU A 158       9.012  32.121 -44.896  1.00 28.65           C  
ATOM   1214  CD1 LEU A 158      10.409  31.931 -44.369  1.00 29.17           C  
ATOM   1215  CD2 LEU A 158       9.019  33.123 -46.063  1.00 28.20           C  
ATOM   1216  N   PHE A 159       6.120  28.390 -45.762  1.00 30.21           N  
ATOM   1217  CA  PHE A 159       5.828  27.100 -46.398  1.00 31.20           C  
ATOM   1218  C   PHE A 159       4.397  26.991 -46.933  1.00 32.40           C  
ATOM   1219  O   PHE A 159       4.139  26.233 -47.863  1.00 32.32           O  
ATOM   1220  CB  PHE A 159       6.131  25.916 -45.464  1.00 30.21           C  
ATOM   1221  CG  PHE A 159       7.565  25.843 -44.999  1.00 29.03           C  
ATOM   1222  CD1 PHE A 159       8.599  26.401 -45.749  1.00 27.51           C  
ATOM   1223  CD2 PHE A 159       7.884  25.197 -43.807  1.00 27.88           C  
ATOM   1224  CE1 PHE A 159       9.913  26.324 -45.317  1.00 27.60           C  
ATOM   1225  CE2 PHE A 159       9.200  25.118 -43.368  1.00 27.52           C  
ATOM   1226  CZ  PHE A 159      10.218  25.683 -44.122  1.00 27.21           C  
ATOM   1227  N   MET A 160       3.479  27.744 -46.338  1.00 34.31           N  
ATOM   1228  CA  MET A 160       2.077  27.684 -46.724  1.00 35.91           C  
ATOM   1229  C   MET A 160       1.509  29.001 -47.268  1.00 37.60           C  
ATOM   1230  O   MET A 160       0.857  29.002 -48.312  1.00 38.24           O  
ATOM   1231  CB  MET A 160       1.231  27.165 -45.555  1.00 36.21           C  
ATOM   1232  CG  MET A 160       1.435  25.672 -45.269  1.00 35.82           C  
ATOM   1233  SD  MET A 160       0.221  25.041 -44.113  1.00 34.72           S  
ATOM   1234  CE  MET A 160       0.662  25.971 -42.639  1.00 34.67           C  
ATOM   1235  N   GLY A 161       1.764  30.110 -46.575  1.00 39.44           N  
ATOM   1236  CA  GLY A 161       1.200  31.422 -46.943  1.00 41.29           C  
ATOM   1237  C   GLY A 161       0.766  32.245 -45.736  1.00 42.96           C  
ATOM   1238  O   GLY A 161       0.534  31.694 -44.650  1.00 42.98           O  
ATOM   1239  N   GLU A 162       0.643  33.564 -45.935  1.00 44.39           N  
ATOM   1240  CA  GLU A 162       0.417  34.531 -44.844  1.00 45.68           C  
ATOM   1241  C   GLU A 162      -0.950  34.431 -44.138  1.00 46.61           C  
ATOM   1242  O   GLU A 162      -1.007  34.448 -42.905  1.00 46.88           O  
ATOM   1243  CB  GLU A 162       0.682  35.970 -45.328  1.00 45.50           C  
ATOM   1244  N   LYS A 163      -2.033  34.318 -44.914  1.00 47.60           N  
ATOM   1245  CA  LYS A 163      -3.398  34.205 -44.358  1.00 48.48           C  
ATOM   1246  C   LYS A 163      -3.612  32.889 -43.605  1.00 48.88           C  
ATOM   1247  O   LYS A 163      -4.428  32.810 -42.680  1.00 48.94           O  
ATOM   1248  CB  LYS A 163      -4.456  34.373 -45.466  1.00 48.65           C  
ATOM   1249  N   VAL A 164      -2.876  31.865 -44.029  1.00 49.55           N  
ATOM   1250  CA  VAL A 164      -2.806  30.572 -43.343  1.00 49.99           C  
ATOM   1251  C   VAL A 164      -2.292  30.721 -41.898  1.00 50.41           C  
ATOM   1252  O   VAL A 164      -2.823  30.092 -40.968  1.00 50.50           O  
ATOM   1253  CB  VAL A 164      -1.878  29.607 -44.114  1.00 50.07           C  
ATOM   1254  CG1 VAL A 164      -1.832  28.247 -43.443  1.00 49.83           C  
ATOM   1255  CG2 VAL A 164      -2.322  29.492 -45.594  1.00 50.11           C  
ATOM   1256  N   SER A 165      -1.275  31.570 -41.727  1.00 50.62           N  
ATOM   1257  CA  SER A 165      -0.566  31.742 -40.443  1.00 50.66           C  
ATOM   1258  C   SER A 165      -1.406  32.369 -39.321  1.00 50.44           C  
ATOM   1259  O   SER A 165      -1.236  32.026 -38.149  1.00 50.51           O  
ATOM   1260  CB  SER A 165       0.724  32.551 -40.645  1.00 50.53           C  
ATOM   1261  OG  SER A 165       1.469  32.644 -39.441  1.00 50.20           O  
ATOM   1262  N   GLN A 166      -2.308  33.280 -39.678  1.00 50.29           N  
ATOM   1263  CA  GLN A 166      -3.120  33.982 -38.685  1.00 49.89           C  
ATOM   1264  C   GLN A 166      -4.391  33.199 -38.343  1.00 49.50           C  
ATOM   1265  O   GLN A 166      -5.487  33.775 -38.308  1.00 49.73           O  
ATOM   1266  CB  GLN A 166      -3.458  35.390 -39.177  1.00 50.15           C  
ATOM   1267  N   ASN A 167      -4.238  31.900 -38.062  1.00 48.61           N  
ATOM   1268  CA  ASN A 167      -5.386  30.990 -38.068  1.00 47.40           C  
ATOM   1269  C   ASN A 167      -5.437  29.741 -37.178  1.00 46.27           C  
ATOM   1270  O   ASN A 167      -4.964  28.680 -37.563  1.00 46.83           O  
ATOM   1271  CB  ASN A 167      -5.733  30.605 -39.534  1.00 47.69           C  
ATOM   1272  CG  ASN A 167      -5.936  29.082 -39.749  1.00 48.32           C  
ATOM   1273  OD1 ASN A 167      -6.735  28.423 -39.056  1.00 48.20           O  
ATOM   1274  ND2 ASN A 167      -5.212  28.527 -40.727  1.00 48.16           N  
ATOM   1275  N   PRO A 168      -5.888  29.869 -35.928  1.00 44.89           N  
ATOM   1276  CA  PRO A 168      -5.381  30.429 -34.701  1.00 43.32           C  
ATOM   1277  C   PRO A 168      -5.218  29.181 -33.796  1.00 41.62           C  
ATOM   1278  O   PRO A 168      -4.691  29.251 -32.686  1.00 41.87           O  
ATOM   1279  CB  PRO A 168      -6.542  31.303 -34.216  1.00 43.28           C  
ATOM   1280  CG  PRO A 168      -7.797  30.769 -34.952  1.00 44.06           C  
ATOM   1281  CD  PRO A 168      -7.336  29.608 -35.804  1.00 45.09           C  
ATOM   1282  N   GLN A 169      -5.684  28.049 -34.326  1.00 39.57           N  
ATOM   1283  CA  GLN A 169      -5.725  26.746 -33.669  1.00 37.73           C  
ATOM   1284  C   GLN A 169      -4.543  25.872 -34.084  1.00 36.09           C  
ATOM   1285  O   GLN A 169      -4.301  24.812 -33.492  1.00 35.58           O  
ATOM   1286  CB  GLN A 169      -7.016  26.019 -34.070  1.00 37.76           C  
ATOM   1287  CG  GLN A 169      -8.271  26.449 -33.345  1.00 38.03           C  
ATOM   1288  CD  GLN A 169      -9.489  25.628 -33.762  1.00 38.68           C  
ATOM   1289  OE1 GLN A 169      -9.956  25.726 -34.903  1.00 40.04           O  
ATOM   1290  NE2 GLN A 169     -10.016  24.822 -32.836  1.00 38.85           N  
ATOM   1291  N   LEU A 170      -3.829  26.327 -35.112  1.00 34.25           N  
ATOM   1292  CA  LEU A 170      -2.774  25.572 -35.782  1.00 32.65           C  
ATOM   1293  C   LEU A 170      -1.564  25.332 -34.876  1.00 31.43           C  
ATOM   1294  O   LEU A 170      -1.027  24.222 -34.832  1.00 30.65           O  
ATOM   1295  CB  LEU A 170      -2.347  26.317 -37.052  1.00 32.39           C  
ATOM   1296  CG  LEU A 170      -2.081  25.548 -38.351  1.00 33.06           C  
ATOM   1297  CD1 LEU A 170      -3.256  24.661 -38.780  1.00 32.43           C  
ATOM   1298  CD2 LEU A 170      -1.756  26.519 -39.464  1.00 33.13           C  
ATOM   1299  N   PHE A 171      -1.152  26.389 -34.173  1.00 30.19           N  
ATOM   1300  CA  PHE A 171      -0.034  26.368 -33.218  1.00 29.19           C  
ATOM   1301  C   PHE A 171      -0.337  25.481 -32.007  1.00 28.37           C  
ATOM   1302  O   PHE A 171       0.437  24.577 -31.716  1.00 28.66           O  
ATOM   1303  CB  PHE A 171       0.347  27.805 -32.809  1.00 29.09           C  
ATOM   1304  CG  PHE A 171       1.496  27.895 -31.843  1.00 28.73           C  
ATOM   1305  CD1 PHE A 171       2.795  27.617 -32.253  1.00 28.82           C  
ATOM   1306  CD2 PHE A 171       1.281  28.280 -30.522  1.00 28.59           C  
ATOM   1307  CE1 PHE A 171       3.859  27.706 -31.362  1.00 27.11           C  
ATOM   1308  CE2 PHE A 171       2.346  28.382 -29.618  1.00 27.69           C  
ATOM   1309  CZ  PHE A 171       3.638  28.093 -30.045  1.00 28.75           C  
ATOM   1310  N   PRO A 172      -1.473  25.708 -31.319  1.00 27.78           N  
ATOM   1311  CA  PRO A 172      -1.876  24.838 -30.209  1.00 27.27           C  
ATOM   1312  C   PRO A 172      -1.878  23.345 -30.557  1.00 26.95           C  
ATOM   1313  O   PRO A 172      -1.408  22.523 -29.755  1.00 26.91           O  
ATOM   1314  CB  PRO A 172      -3.305  25.298 -29.916  1.00 28.06           C  
ATOM   1315  CG  PRO A 172      -3.344  26.723 -30.368  1.00 27.30           C  
ATOM   1316  CD  PRO A 172      -2.434  26.812 -31.528  1.00 27.69           C  
ATOM   1317  N   TRP A 173      -2.397  23.003 -31.735  1.00 25.78           N  
ATOM   1318  CA  TRP A 173      -2.418  21.629 -32.223  1.00 25.23           C  
ATOM   1319  C   TRP A 173      -1.009  21.064 -32.466  1.00 24.58           C  
ATOM   1320  O   TRP A 173      -0.708  19.946 -32.062  1.00 24.74           O  
ATOM   1321  CB  TRP A 173      -3.259  21.523 -33.506  1.00 25.13           C  
ATOM   1322  CG  TRP A 173      -4.750  21.644 -33.282  1.00 26.00           C  
ATOM   1323  CD1 TRP A 173      -5.439  21.398 -32.116  1.00 26.65           C  
ATOM   1324  CD2 TRP A 173      -5.738  21.991 -34.256  1.00 25.94           C  
ATOM   1325  NE1 TRP A 173      -6.790  21.597 -32.305  1.00 25.67           N  
ATOM   1326  CE2 TRP A 173      -7.001  21.963 -33.606  1.00 25.92           C  
ATOM   1327  CE3 TRP A 173      -5.682  22.336 -35.613  1.00 27.00           C  
ATOM   1328  CZ2 TRP A 173      -8.194  22.262 -34.266  1.00 25.53           C  
ATOM   1329  CZ3 TRP A 173      -6.873  22.632 -36.270  1.00 27.05           C  
ATOM   1330  CH2 TRP A 173      -8.116  22.592 -35.590  1.00 25.93           C  
ATOM   1331  N   PHE A 174      -0.156  21.834 -33.132  1.00 24.05           N  
ATOM   1332  CA  PHE A 174       1.216  21.415 -33.386  1.00 23.58           C  
ATOM   1333  C   PHE A 174       2.010  21.153 -32.115  1.00 22.38           C  
ATOM   1334  O   PHE A 174       2.786  20.207 -32.046  1.00 22.83           O  
ATOM   1335  CB  PHE A 174       1.939  22.426 -34.268  1.00 24.58           C  
ATOM   1336  CG  PHE A 174       2.374  21.859 -35.583  1.00 26.02           C  
ATOM   1337  CD1 PHE A 174       3.588  21.185 -35.688  1.00 28.00           C  
ATOM   1338  CD2 PHE A 174       1.575  21.975 -36.709  1.00 28.27           C  
ATOM   1339  CE1 PHE A 174       4.001  20.650 -36.897  1.00 29.24           C  
ATOM   1340  CE2 PHE A 174       1.983  21.442 -37.934  1.00 28.84           C  
ATOM   1341  CZ  PHE A 174       3.195  20.774 -38.022  1.00 28.25           C  
ATOM   1342  N   GLU A 175       1.786  21.978 -31.107  1.00 21.30           N  
ATOM   1343  CA  GLU A 175       2.447  21.837 -29.813  1.00 20.92           C  
ATOM   1344  C   GLU A 175       2.104  20.517 -29.145  1.00 20.22           C  
ATOM   1345  O   GLU A 175       2.983  19.835 -28.611  1.00 19.34           O  
ATOM   1346  CB  GLU A 175       2.112  23.034 -28.916  1.00 20.79           C  
ATOM   1347  CG  GLU A 175       2.559  24.350 -29.530  1.00 21.62           C  
ATOM   1348  CD  GLU A 175       4.079  24.473 -29.586  1.00 25.57           C  
ATOM   1349  OE1 GLU A 175       4.696  24.231 -30.663  1.00 27.56           O  
ATOM   1350  OE2 GLU A 175       4.654  24.804 -28.535  1.00 26.41           O  
ATOM   1351  N   THR A 176       0.820  20.160 -29.210  1.00 19.26           N  
ATOM   1352  CA  THR A 176       0.322  18.860 -28.760  1.00 18.73           C  
ATOM   1353  C   THR A 176       0.835  17.686 -29.628  1.00 18.29           C  
ATOM   1354  O   THR A 176       1.243  16.648 -29.110  1.00 18.00           O  
ATOM   1355  CB  THR A 176      -1.225  18.873 -28.752  1.00 18.16           C  
ATOM   1356  OG1 THR A 176      -1.668  20.017 -28.010  1.00 18.87           O  
ATOM   1357  CG2 THR A 176      -1.781  17.621 -28.124  1.00 18.23           C  
ATOM   1358  N   TYR A 177       0.793  17.854 -30.946  1.00 18.16           N  
ATOM   1359  CA  TYR A 177       1.355  16.879 -31.886  1.00 17.69           C  
ATOM   1360  C   TYR A 177       2.829  16.557 -31.533  1.00 17.48           C  
ATOM   1361  O   TYR A 177       3.188  15.404 -31.324  1.00 16.60           O  
ATOM   1362  CB  TYR A 177       1.213  17.428 -33.309  1.00 17.53           C  
ATOM   1363  CG  TYR A 177       1.910  16.627 -34.385  1.00 17.99           C  
ATOM   1364  CD1 TYR A 177       1.357  15.444 -34.868  1.00 16.70           C  
ATOM   1365  CD2 TYR A 177       3.123  17.061 -34.927  1.00 17.89           C  
ATOM   1366  CE1 TYR A 177       1.997  14.709 -35.838  1.00 16.67           C  
ATOM   1367  CE2 TYR A 177       3.765  16.329 -35.907  1.00 17.50           C  
ATOM   1368  CZ  TYR A 177       3.203  15.151 -36.350  1.00 17.17           C  
ATOM   1369  OH  TYR A 177       3.834  14.421 -37.336  1.00 17.83           O  
ATOM   1370  N   ILE A 178       3.651  17.595 -31.425  1.00 17.71           N  
ATOM   1371  CA  ILE A 178       5.071  17.469 -31.065  1.00 18.48           C  
ATOM   1372  C   ILE A 178       5.342  16.700 -29.753  1.00 18.87           C  
ATOM   1373  O   ILE A 178       6.233  15.842 -29.709  1.00 19.77           O  
ATOM   1374  CB  ILE A 178       5.767  18.854 -31.052  1.00 18.64           C  
ATOM   1375  CG1 ILE A 178       5.878  19.401 -32.481  1.00 19.20           C  
ATOM   1376  CG2 ILE A 178       7.150  18.774 -30.381  1.00 19.16           C  
ATOM   1377  CD1 ILE A 178       6.454  20.820 -32.565  1.00 18.04           C  
ATOM   1378  N   GLN A 179       4.553  16.971 -28.711  1.00 19.01           N  
ATOM   1379  CA  GLN A 179       4.751  16.347 -27.390  1.00 19.82           C  
ATOM   1380  C   GLN A 179       4.648  14.816 -27.389  1.00 19.43           C  
ATOM   1381  O   GLN A 179       5.221  14.157 -26.517  1.00 18.69           O  
ATOM   1382  CB  GLN A 179       3.822  16.971 -26.334  1.00 19.42           C  
ATOM   1383  CG  GLN A 179       4.346  18.293 -25.742  1.00 21.05           C  
ATOM   1384  CD  GLN A 179       3.491  18.863 -24.576  1.00 22.15           C  
ATOM   1385  OE1 GLN A 179       3.753  19.969 -24.094  1.00 26.91           O  
ATOM   1386  NE2 GLN A 179       2.499  18.111 -24.121  1.00 23.76           N  
ATOM   1387  N   GLY A 180       3.952  14.255 -28.388  1.00 19.59           N  
ATOM   1388  CA  GLY A 180       3.786  12.807 -28.488  1.00 19.12           C  
ATOM   1389  C   GLY A 180       4.728  12.102 -29.433  1.00 19.49           C  
ATOM   1390  O   GLY A 180       4.744  10.882 -29.469  1.00 19.94           O  
ATOM   1391  N   LEU A 181       5.506  12.860 -30.214  1.00 20.00           N  
ATOM   1392  CA  LEU A 181       6.405  12.291 -31.225  1.00 19.90           C  
ATOM   1393  C   LEU A 181       7.388  11.266 -30.644  1.00 20.11           C  
ATOM   1394  O   LEU A 181       7.578  10.174 -31.213  1.00 19.94           O  
ATOM   1395  CB  LEU A 181       7.164  13.402 -31.973  1.00 20.41           C  
ATOM   1396  CG  LEU A 181       6.460  14.012 -33.191  1.00 21.11           C  
ATOM   1397  CD1 LEU A 181       7.096  15.338 -33.539  1.00 20.94           C  
ATOM   1398  CD2 LEU A 181       6.454  13.061 -34.400  1.00 19.53           C  
ATOM   1399  N   PHE A 182       7.995  11.612 -29.511  1.00 19.61           N  
ATOM   1400  CA  PHE A 182       8.813  10.651 -28.771  1.00 20.20           C  
ATOM   1401  C   PHE A 182       8.156  10.367 -27.420  1.00 20.21           C  
ATOM   1402  O   PHE A 182       8.337  11.105 -26.454  1.00 19.50           O  
ATOM   1403  CB  PHE A 182      10.264  11.128 -28.652  1.00 20.37           C  
ATOM   1404  CG  PHE A 182      10.973  11.246 -29.987  1.00 21.14           C  
ATOM   1405  CD1 PHE A 182      11.832  10.239 -30.427  1.00 22.78           C  
ATOM   1406  CD2 PHE A 182      10.778  12.352 -30.806  1.00 21.90           C  
ATOM   1407  CE1 PHE A 182      12.492  10.345 -31.663  1.00 21.95           C  
ATOM   1408  CE2 PHE A 182      11.437  12.461 -32.049  1.00 22.04           C  
ATOM   1409  CZ  PHE A 182      12.284  11.448 -32.470  1.00 20.79           C  
ATOM   1410  N   SER A 183       7.356   9.303 -27.407  1.00 20.31           N  
ATOM   1411  CA  SER A 183       6.521   8.917 -26.263  1.00 21.31           C  
ATOM   1412  C   SER A 183       6.150   7.437 -26.357  1.00 21.72           C  
ATOM   1413  O   SER A 183       6.432   6.776 -27.370  1.00 22.26           O  
ATOM   1414  CB  SER A 183       5.242   9.770 -26.216  1.00 21.01           C  
ATOM   1415  OG  SER A 183       4.448   9.533 -27.364  1.00 20.60           O  
ATOM   1416  N   LEU A 184       5.510   6.925 -25.301  1.00 22.51           N  
ATOM   1417  CA  LEU A 184       4.969   5.564 -25.308  1.00 22.89           C  
ATOM   1418  C   LEU A 184       3.786   5.509 -26.274  1.00 22.35           C  
ATOM   1419  O   LEU A 184       2.811   6.228 -26.063  1.00 22.09           O  
ATOM   1420  CB  LEU A 184       4.476   5.142 -23.912  1.00 23.12           C  
ATOM   1421  CG  LEU A 184       5.409   4.923 -22.720  1.00 24.33           C  
ATOM   1422  CD1 LEU A 184       4.617   4.231 -21.580  1.00 25.66           C  
ATOM   1423  CD2 LEU A 184       6.665   4.127 -23.079  1.00 23.99           C  
ATOM   1424  N   PRO A 185       3.862   4.644 -27.310  1.00 22.46           N  
ATOM   1425  CA  PRO A 185       2.823   4.609 -28.345  1.00 22.71           C  
ATOM   1426  C   PRO A 185       1.526   3.924 -27.859  1.00 22.91           C  
ATOM   1427  O   PRO A 185       1.047   2.969 -28.474  1.00 23.03           O  
ATOM   1428  CB  PRO A 185       3.487   3.832 -29.488  1.00 22.18           C  
ATOM   1429  CG  PRO A 185       4.491   2.938 -28.808  1.00 22.52           C  
ATOM   1430  CD  PRO A 185       4.911   3.622 -27.535  1.00 21.75           C  
ATOM   1431  N   ILE A 186       0.964   4.441 -26.768  1.00 23.55           N  
ATOM   1432  CA  ILE A 186      -0.296   3.936 -26.219  1.00 23.97           C  
ATOM   1433  C   ILE A 186      -1.478   4.791 -26.683  1.00 24.17           C  
ATOM   1434  O   ILE A 186      -1.595   5.962 -26.320  1.00 23.94           O  
ATOM   1435  CB  ILE A 186      -0.238   3.775 -24.699  1.00 24.09           C  
ATOM   1436  CG1 ILE A 186       0.658   2.580 -24.359  1.00 25.63           C  
ATOM   1437  CG2 ILE A 186      -1.635   3.520 -24.117  1.00 25.18           C  
ATOM   1438  CD1 ILE A 186       0.925   2.401 -22.873  1.00 26.08           C  
ATOM   1439  N   PRO A 187      -2.348   4.192 -27.511  1.00 24.59           N  
ATOM   1440  CA  PRO A 187      -3.449   4.847 -28.211  1.00 24.76           C  
ATOM   1441  C   PRO A 187      -4.691   5.040 -27.342  1.00 25.15           C  
ATOM   1442  O   PRO A 187      -5.758   4.489 -27.639  1.00 25.17           O  
ATOM   1443  CB  PRO A 187      -3.751   3.889 -29.384  1.00 25.00           C  
ATOM   1444  CG  PRO A 187      -2.894   2.680 -29.178  1.00 24.15           C  
ATOM   1445  CD  PRO A 187      -2.270   2.756 -27.833  1.00 24.34           C  
ATOM   1446  N   LEU A 188      -4.543   5.830 -26.281  1.00 24.79           N  
ATOM   1447  CA  LEU A 188      -5.657   6.208 -25.422  1.00 24.76           C  
ATOM   1448  C   LEU A 188      -5.681   7.728 -25.391  1.00 24.81           C  
ATOM   1449  O   LEU A 188      -4.625   8.346 -25.534  1.00 24.44           O  
ATOM   1450  CB  LEU A 188      -5.421   5.660 -24.010  1.00 24.77           C  
ATOM   1451  CG  LEU A 188      -5.646   4.162 -23.797  1.00 24.99           C  
ATOM   1452  CD1 LEU A 188      -4.977   3.659 -22.514  1.00 23.71           C  
ATOM   1453  CD2 LEU A 188      -7.143   3.876 -23.785  1.00 25.04           C  
ATOM   1454  N   PRO A 189      -6.872   8.341 -25.198  1.00 25.09           N  
ATOM   1455  CA  PRO A 189      -6.946   9.816 -25.114  1.00 25.24           C  
ATOM   1456  C   PRO A 189      -6.246  10.463 -23.901  1.00 25.64           C  
ATOM   1457  O   PRO A 189      -6.022  11.680 -23.893  1.00 26.29           O  
ATOM   1458  CB  PRO A 189      -8.457  10.118 -25.099  1.00 25.52           C  
ATOM   1459  CG  PRO A 189      -9.160   8.826 -24.915  1.00 24.68           C  
ATOM   1460  CD  PRO A 189      -8.190   7.688 -25.060  1.00 25.08           C  
ATOM   1461  N   ASN A 190      -5.895   9.679 -22.890  1.00 25.85           N  
ATOM   1462  CA  ASN A 190      -5.211  10.233 -21.716  1.00 26.33           C  
ATOM   1463  C   ASN A 190      -3.677  10.015 -21.684  1.00 25.86           C  
ATOM   1464  O   ASN A 190      -3.068   9.922 -20.607  1.00 26.37           O  
ATOM   1465  CB  ASN A 190      -5.886   9.741 -20.419  1.00 26.93           C  
ATOM   1466  CG  ASN A 190      -6.216   8.262 -20.458  1.00 29.22           C  
ATOM   1467  OD1 ASN A 190      -6.905   7.782 -21.370  1.00 30.79           O  
ATOM   1468  ND2 ASN A 190      -5.723   7.526 -19.470  1.00 32.46           N  
ATOM   1469  N   THR A 191      -3.067   9.927 -22.867  1.00 24.95           N  
ATOM   1470  CA  THR A 191      -1.616   9.807 -23.002  1.00 23.57           C  
ATOM   1471  C   THR A 191      -1.125  10.934 -23.905  1.00 22.27           C  
ATOM   1472  O   THR A 191      -1.901  11.506 -24.660  1.00 21.89           O  
ATOM   1473  CB  THR A 191      -1.183   8.435 -23.616  1.00 24.28           C  
ATOM   1474  OG1 THR A 191      -1.788   8.258 -24.905  1.00 24.57           O  
ATOM   1475  CG2 THR A 191      -1.579   7.263 -22.713  1.00 24.28           C  
ATOM   1476  N   LEU A 192       0.159  11.260 -23.820  1.00 20.70           N  
ATOM   1477  CA  LEU A 192       0.735  12.263 -24.704  1.00 19.56           C  
ATOM   1478  C   LEU A 192       0.571  11.802 -26.160  1.00 18.82           C  
ATOM   1479  O   LEU A 192       0.229  12.601 -27.033  1.00 18.71           O  
ATOM   1480  CB  LEU A 192       2.206  12.507 -24.351  1.00 19.26           C  
ATOM   1481  CG  LEU A 192       2.461  13.078 -22.946  1.00 18.64           C  
ATOM   1482  CD1 LEU A 192       3.938  13.119 -22.663  1.00 19.15           C  
ATOM   1483  CD2 LEU A 192       1.834  14.454 -22.737  1.00 17.57           C  
ATOM   1484  N   PHE A 193       0.773  10.506 -26.385  1.00 17.82           N  
ATOM   1485  CA  PHE A 193       0.637   9.888 -27.704  1.00 18.01           C  
ATOM   1486  C   PHE A 193      -0.752   9.991 -28.327  1.00 17.62           C  
ATOM   1487  O   PHE A 193      -0.867  10.389 -29.481  1.00 18.15           O  
ATOM   1488  CB  PHE A 193       1.071   8.426 -27.680  1.00 17.92           C  
ATOM   1489  CG  PHE A 193       0.981   7.753 -29.027  1.00 18.65           C  
ATOM   1490  CD1 PHE A 193       1.835   8.129 -30.064  1.00 17.46           C  
ATOM   1491  CD2 PHE A 193       0.046   6.756 -29.258  1.00 16.18           C  
ATOM   1492  CE1 PHE A 193       1.753   7.515 -31.323  1.00 19.10           C  
ATOM   1493  CE2 PHE A 193      -0.034   6.125 -30.503  1.00 19.58           C  
ATOM   1494  CZ  PHE A 193       0.821   6.505 -31.544  1.00 19.11           C  
ATOM   1495  N   GLY A 194      -1.796   9.617 -27.582  1.00 18.07           N  
ATOM   1496  CA  GLY A 194      -3.185   9.718 -28.092  1.00 17.24           C  
ATOM   1497  C   GLY A 194      -3.623  11.150 -28.358  1.00 17.28           C  
ATOM   1498  O   GLY A 194      -4.392  11.419 -29.279  1.00 16.59           O  
ATOM   1499  N   LYS A 195      -3.156  12.079 -27.526  1.00 17.34           N  
ATOM   1500  CA  LYS A 195      -3.434  13.486 -27.752  1.00 18.03           C  
ATOM   1501  C   LYS A 195      -2.744  13.989 -29.019  1.00 17.71           C  
ATOM   1502  O   LYS A 195      -3.254  14.891 -29.692  1.00 18.06           O  
ATOM   1503  CB  LYS A 195      -3.001  14.334 -26.545  1.00 18.58           C  
ATOM   1504  CG  LYS A 195      -3.726  14.013 -25.245  1.00 21.81           C  
ATOM   1505  CD  LYS A 195      -3.642  15.192 -24.275  1.00 25.02           C  
ATOM   1506  CE  LYS A 195      -4.711  16.221 -24.607  1.00 28.02           C  
ATOM   1507  NZ  LYS A 195      -4.210  17.626 -24.580  1.00 28.60           N  
ATOM   1508  N   SER A 196      -1.571  13.426 -29.327  1.00 18.23           N  
ATOM   1509  CA  SER A 196      -0.826  13.803 -30.521  1.00 18.44           C  
ATOM   1510  C   SER A 196      -1.462  13.184 -31.746  1.00 17.88           C  
ATOM   1511  O   SER A 196      -1.421  13.759 -32.826  1.00 17.83           O  
ATOM   1512  CB  SER A 196       0.642  13.363 -30.427  1.00 18.62           C  
ATOM   1513  OG  SER A 196       1.375  14.284 -29.624  1.00 20.87           O  
ATOM   1514  N   GLN A 197      -2.033  12.001 -31.560  1.00 17.70           N  
ATOM   1515  CA  GLN A 197      -2.792  11.325 -32.603  1.00 18.25           C  
ATOM   1516  C   GLN A 197      -3.985  12.154 -33.044  1.00 18.70           C  
ATOM   1517  O   GLN A 197      -4.265  12.248 -34.234  1.00 18.90           O  
ATOM   1518  CB  GLN A 197      -3.266   9.957 -32.126  1.00 18.07           C  
ATOM   1519  CG  GLN A 197      -2.181   8.925 -32.067  1.00 17.67           C  
ATOM   1520  CD  GLN A 197      -2.708   7.556 -31.719  1.00 20.50           C  
ATOM   1521  OE1 GLN A 197      -2.587   6.628 -32.505  1.00 24.63           O  
ATOM   1522  NE2 GLN A 197      -3.298   7.418 -30.545  1.00 21.27           N  
ATOM   1523  N   ARG A 198      -4.669  12.748 -32.069  1.00 19.01           N  
ATOM   1524  CA  ARG A 198      -5.846  13.577 -32.282  1.00 19.77           C  
ATOM   1525  C   ARG A 198      -5.430  14.921 -32.875  1.00 19.38           C  
ATOM   1526  O   ARG A 198      -6.095  15.453 -33.772  1.00 19.21           O  
ATOM   1527  CB  ARG A 198      -6.621  13.729 -30.945  1.00 20.20           C  
ATOM   1528  CG  ARG A 198      -7.682  14.845 -30.900  1.00 22.93           C  
ATOM   1529  CD  ARG A 198      -9.035  14.411 -31.481  1.00 26.97           C  
ATOM   1530  NE  ARG A 198      -9.972  15.532 -31.553  1.00 29.61           N  
ATOM   1531  CZ  ARG A 198     -11.012  15.595 -32.380  1.00 30.66           C  
ATOM   1532  NH1 ARG A 198     -11.271  14.595 -33.208  1.00 30.18           N  
ATOM   1533  NH2 ARG A 198     -11.798  16.667 -32.375  1.00 30.60           N  
ATOM   1534  N   ALA A 199      -4.306  15.444 -32.390  1.00 19.21           N  
ATOM   1535  CA  ALA A 199      -3.695  16.659 -32.942  1.00 19.15           C  
ATOM   1536  C   ALA A 199      -3.399  16.460 -34.429  1.00 19.30           C  
ATOM   1537  O   ALA A 199      -3.751  17.306 -35.246  1.00 19.10           O  
ATOM   1538  CB  ALA A 199      -2.422  17.009 -32.179  1.00 18.03           C  
ATOM   1539  N   ARG A 200      -2.789  15.323 -34.773  1.00 19.88           N  
ATOM   1540  CA  ARG A 200      -2.434  15.011 -36.172  1.00 20.58           C  
ATOM   1541  C   ARG A 200      -3.682  14.960 -37.059  1.00 20.78           C  
ATOM   1542  O   ARG A 200      -3.663  15.467 -38.173  1.00 20.70           O  
ATOM   1543  CB  ARG A 200      -1.629  13.705 -36.264  1.00 20.08           C  
ATOM   1544  CG  ARG A 200      -1.893  12.836 -37.505  1.00 20.85           C  
ATOM   1545  CD  ARG A 200      -0.823  11.781 -37.731  1.00 20.95           C  
ATOM   1546  NE  ARG A 200      -1.002  11.111 -39.025  1.00 22.15           N  
ATOM   1547  CZ  ARG A 200      -0.321  11.400 -40.134  1.00 22.55           C  
ATOM   1548  NH1 ARG A 200       0.637  12.336 -40.145  1.00 19.86           N  
ATOM   1549  NH2 ARG A 200      -0.596  10.736 -41.243  1.00 21.94           N  
ATOM   1550  N   ALA A 201      -4.753  14.347 -36.554  1.00 21.38           N  
ATOM   1551  CA  ALA A 201      -6.014  14.238 -37.302  1.00 22.27           C  
ATOM   1552  C   ALA A 201      -6.581  15.618 -37.600  1.00 22.56           C  
ATOM   1553  O   ALA A 201      -6.992  15.909 -38.731  1.00 23.41           O  
ATOM   1554  CB  ALA A 201      -7.034  13.400 -36.529  1.00 22.05           C  
ATOM   1555  N   LEU A 202      -6.595  16.468 -36.581  1.00 22.59           N  
ATOM   1556  CA  LEU A 202      -7.091  17.832 -36.716  1.00 22.60           C  
ATOM   1557  C   LEU A 202      -6.232  18.663 -37.661  1.00 22.35           C  
ATOM   1558  O   LEU A 202      -6.762  19.448 -38.444  1.00 22.02           O  
ATOM   1559  CB  LEU A 202      -7.195  18.504 -35.342  1.00 22.72           C  
ATOM   1560  CG  LEU A 202      -8.268  17.963 -34.387  1.00 24.36           C  
ATOM   1561  CD1 LEU A 202      -8.006  18.443 -32.954  1.00 25.70           C  
ATOM   1562  CD2 LEU A 202      -9.672  18.351 -34.828  1.00 23.75           C  
ATOM   1563  N   LEU A 203      -4.912  18.485 -37.593  1.00 21.82           N  
ATOM   1564  CA  LEU A 203      -3.999  19.214 -38.472  1.00 21.49           C  
ATOM   1565  C   LEU A 203      -4.118  18.782 -39.927  1.00 22.78           C  
ATOM   1566  O   LEU A 203      -4.087  19.629 -40.814  1.00 23.05           O  
ATOM   1567  CB  LEU A 203      -2.536  19.081 -38.013  1.00 21.52           C  
ATOM   1568  CG  LEU A 203      -2.146  19.766 -36.698  1.00 18.32           C  
ATOM   1569  CD1 LEU A 203      -0.909  19.132 -36.101  1.00 16.68           C  
ATOM   1570  CD2 LEU A 203      -1.959  21.262 -36.909  1.00 18.07           C  
ATOM   1571  N   LEU A 204      -4.233  17.476 -40.181  1.00 23.36           N  
ATOM   1572  CA  LEU A 204      -4.358  16.984 -41.561  1.00 24.01           C  
ATOM   1573  C   LEU A 204      -5.662  17.489 -42.193  1.00 24.48           C  
ATOM   1574  O   LEU A 204      -5.672  17.902 -43.355  1.00 24.71           O  
ATOM   1575  CB  LEU A 204      -4.303  15.450 -41.609  1.00 23.90           C  
ATOM   1576  CG  LEU A 204      -3.000  14.714 -41.284  1.00 23.71           C  
ATOM   1577  CD1 LEU A 204      -3.288  13.217 -41.211  1.00 22.76           C  
ATOM   1578  CD2 LEU A 204      -1.925  14.992 -42.322  1.00 23.68           C  
ATOM   1579  N   ALA A 205      -6.744  17.486 -41.411  1.00 24.92           N  
ATOM   1580  CA  ALA A 205      -8.046  17.947 -41.884  1.00 25.59           C  
ATOM   1581  C   ALA A 205      -7.985  19.408 -42.312  1.00 26.41           C  
ATOM   1582  O   ALA A 205      -8.596  19.783 -43.302  1.00 26.98           O  
ATOM   1583  CB  ALA A 205      -9.125  17.723 -40.817  1.00 25.32           C  
ATOM   1584  N   GLU A 206      -7.229  20.219 -41.574  1.00 27.62           N  
ATOM   1585  CA  GLU A 206      -6.975  21.620 -41.930  1.00 28.81           C  
ATOM   1586  C   GLU A 206      -6.078  21.787 -43.142  1.00 29.25           C  
ATOM   1587  O   GLU A 206      -6.336  22.637 -43.991  1.00 29.39           O  
ATOM   1588  CB  GLU A 206      -6.347  22.380 -40.753  1.00 29.09           C  
ATOM   1589  CG  GLU A 206      -7.318  22.665 -39.643  1.00 31.05           C  
ATOM   1590  CD  GLU A 206      -8.534  23.420 -40.146  1.00 33.61           C  
ATOM   1591  OE1 GLU A 206      -8.379  24.618 -40.488  1.00 32.79           O  
ATOM   1592  OE2 GLU A 206      -9.632  22.806 -40.211  1.00 33.68           O  
ATOM   1593  N   LEU A 207      -5.000  21.007 -43.193  1.00 30.02           N  
ATOM   1594  CA  LEU A 207      -4.046  21.107 -44.293  1.00 30.66           C  
ATOM   1595  C   LEU A 207      -4.710  20.663 -45.603  1.00 30.88           C  
ATOM   1596  O   LEU A 207      -4.424  21.231 -46.652  1.00 30.58           O  
ATOM   1597  CB  LEU A 207      -2.757  20.312 -44.020  1.00 30.43           C  
ATOM   1598  CG  LEU A 207      -1.998  20.383 -42.685  1.00 30.62           C  
ATOM   1599  CD1 LEU A 207      -0.746  19.516 -42.765  1.00 30.55           C  
ATOM   1600  CD2 LEU A 207      -1.650  21.806 -42.217  1.00 29.84           C  
ATOM   1601  N   GLU A 208      -5.590  19.659 -45.523  1.00 31.54           N  
ATOM   1602  CA  GLU A 208      -6.440  19.271 -46.651  1.00 32.61           C  
ATOM   1603  C   GLU A 208      -7.247  20.469 -47.156  1.00 32.97           C  
ATOM   1604  O   GLU A 208      -7.277  20.722 -48.357  1.00 32.88           O  
ATOM   1605  CB  GLU A 208      -7.355  18.089 -46.302  1.00 32.31           C  
ATOM   1606  CG  GLU A 208      -8.351  17.710 -47.422  1.00 32.71           C  
ATOM   1607  CD  GLU A 208      -8.855  16.268 -47.364  1.00 34.10           C  
ATOM   1608  OE1 GLU A 208      -8.194  15.399 -46.734  1.00 36.33           O  
ATOM   1609  OE2 GLU A 208      -9.911  15.987 -47.985  1.00 35.63           O  
ATOM   1610  N   LYS A 209      -7.866  21.214 -46.234  1.00 34.09           N  
ATOM   1611  CA  LYS A 209      -8.614  22.435 -46.575  1.00 34.74           C  
ATOM   1612  C   LYS A 209      -7.702  23.471 -47.224  1.00 34.73           C  
ATOM   1613  O   LYS A 209      -8.040  24.023 -48.271  1.00 34.43           O  
ATOM   1614  CB  LYS A 209      -9.295  23.041 -45.343  1.00 34.99           C  
ATOM   1615  CG  LYS A 209     -10.530  22.285 -44.847  1.00 37.42           C  
ATOM   1616  CD  LYS A 209     -11.811  22.841 -45.460  1.00 40.71           C  
ATOM   1617  CE  LYS A 209     -13.031  21.979 -45.112  1.00 42.07           C  
ATOM   1618  NZ  LYS A 209     -14.163  22.142 -46.090  1.00 42.49           N  
ATOM   1619  N   ILE A 210      -6.554  23.723 -46.592  1.00 34.59           N  
ATOM   1620  CA  ILE A 210      -5.565  24.676 -47.094  1.00 34.61           C  
ATOM   1621  C   ILE A 210      -5.102  24.302 -48.501  1.00 35.25           C  
ATOM   1622  O   ILE A 210      -4.947  25.183 -49.346  1.00 35.54           O  
ATOM   1623  CB  ILE A 210      -4.343  24.788 -46.150  1.00 34.37           C  
ATOM   1624  CG1 ILE A 210      -4.709  25.531 -44.864  1.00 33.53           C  
ATOM   1625  CG2 ILE A 210      -3.188  25.509 -46.828  1.00 34.41           C  
ATOM   1626  CD1 ILE A 210      -3.772  25.255 -43.729  1.00 29.95           C  
ATOM   1627  N   ILE A 211      -4.880  23.009 -48.745  1.00 35.83           N  
ATOM   1628  CA  ILE A 211      -4.441  22.512 -50.071  1.00 36.59           C  
ATOM   1629  C   ILE A 211      -5.517  22.681 -51.164  1.00 37.30           C  
ATOM   1630  O   ILE A 211      -5.209  23.132 -52.270  1.00 37.57           O  
ATOM   1631  CB  ILE A 211      -3.932  21.034 -50.000  1.00 36.39           C  
ATOM   1632  CG1 ILE A 211      -2.564  20.970 -49.315  1.00 36.23           C  
ATOM   1633  CG2 ILE A 211      -3.834  20.396 -51.386  1.00 35.85           C  
ATOM   1634  CD1 ILE A 211      -2.192  19.585 -48.792  1.00 36.27           C  
ATOM   1635  N   LYS A 212      -6.764  22.318 -50.855  1.00 38.23           N  
ATOM   1636  CA  LYS A 212      -7.896  22.497 -51.785  1.00 39.47           C  
ATOM   1637  C   LYS A 212      -8.157  23.962 -52.159  1.00 40.09           C  
ATOM   1638  O   LYS A 212      -8.644  24.259 -53.250  1.00 40.75           O  
ATOM   1639  CB  LYS A 212      -9.172  21.869 -51.215  1.00 39.40           C  
ATOM   1640  CG  LYS A 212      -9.096  20.352 -50.994  1.00 39.98           C  
ATOM   1641  CD  LYS A 212      -9.290  19.567 -52.292  1.00 41.28           C  
ATOM   1642  CE  LYS A 212      -9.486  18.085 -52.031  1.00 40.86           C  
ATOM   1643  NZ  LYS A 212     -10.526  17.858 -50.985  1.00 41.85           N  
ATOM   1644  N   ALA A 213      -7.839  24.871 -51.248  1.00 40.74           N  
ATOM   1645  CA  ALA A 213      -7.915  26.294 -51.531  1.00 41.39           C  
ATOM   1646  C   ALA A 213      -6.858  26.711 -52.558  1.00 41.98           C  
ATOM   1647  O   ALA A 213      -7.170  27.408 -53.531  1.00 41.79           O  
ATOM   1648  CB  ALA A 213      -7.773  27.094 -50.247  1.00 41.51           C  
ATOM   1649  N   ARG A 214      -5.618  26.261 -52.348  1.00 42.48           N  
ATOM   1650  CA  ARG A 214      -4.479  26.630 -53.199  1.00 43.11           C  
ATOM   1651  C   ARG A 214      -4.589  26.073 -54.626  1.00 43.42           C  
ATOM   1652  O   ARG A 214      -4.053  26.664 -55.572  1.00 43.40           O  
ATOM   1653  CB  ARG A 214      -3.158  26.204 -52.530  1.00 43.15           C  
ATOM   1654  CG  ARG A 214      -1.900  26.292 -53.406  1.00 43.76           C  
ATOM   1655  CD  ARG A 214      -1.421  27.719 -53.599  1.00 44.92           C  
ATOM   1656  NE  ARG A 214      -0.864  28.237 -52.357  1.00 47.05           N  
ATOM   1657  CZ  ARG A 214       0.422  28.515 -52.151  1.00 47.17           C  
ATOM   1658  NH1 ARG A 214       1.320  28.358 -53.117  1.00 46.46           N  
ATOM   1659  NH2 ARG A 214       0.802  28.975 -50.968  1.00 47.74           N  
ATOM   1660  N   GLN A 215      -5.285  24.944 -54.769  1.00 44.05           N  
ATOM   1661  CA  GLN A 215      -5.475  24.283 -56.068  1.00 44.71           C  
ATOM   1662  C   GLN A 215      -6.482  24.992 -56.970  1.00 45.33           C  
ATOM   1663  O   GLN A 215      -6.435  24.846 -58.187  1.00 45.55           O  
ATOM   1664  CB  GLN A 215      -5.903  22.824 -55.880  1.00 44.62           C  
ATOM   1665  CG  GLN A 215      -4.773  21.900 -55.449  1.00 44.02           C  
ATOM   1666  CD  GLN A 215      -5.260  20.566 -54.927  1.00 43.13           C  
ATOM   1667  OE1 GLN A 215      -4.602  19.544 -55.114  1.00 43.73           O  
ATOM   1668  NE2 GLN A 215      -6.408  20.563 -54.265  1.00 42.30           N  
ATOM   1669  N   GLN A 216      -7.404  25.740 -56.373  1.00 46.07           N  
ATOM   1670  CA  GLN A 216      -8.381  26.515 -57.136  1.00 46.74           C  
ATOM   1671  C   GLN A 216      -7.834  27.916 -57.433  1.00 46.87           C  
ATOM   1672  O   GLN A 216      -8.576  28.903 -57.427  1.00 46.80           O  
ATOM   1673  CB  GLN A 216      -9.714  26.583 -56.385  1.00 46.94           C  
ATOM   1674  CG  GLN A 216     -10.405  25.229 -56.224  1.00 47.09           C  
ATOM   1675  CD  GLN A 216     -11.832  25.349 -55.723  1.00 47.66           C  
ATOM   1676  OE1 GLN A 216     -12.584  26.234 -56.146  1.00 48.93           O  
ATOM   1677  NE2 GLN A 216     -12.219  24.448 -54.817  1.00 49.11           N  
ATOM   1678  N   GLN A 217      -6.528  27.979 -57.700  1.00 46.93           N  
ATOM   1679  CA  GLN A 217      -5.806  29.234 -57.914  1.00 46.82           C  
ATOM   1680  C   GLN A 217      -4.649  29.057 -58.904  1.00 46.40           C  
ATOM   1681  O   GLN A 217      -4.147  27.942 -59.070  1.00 45.92           O  
ATOM   1682  CB  GLN A 217      -5.302  29.792 -56.575  1.00 46.88           C  
ATOM   1683  CG  GLN A 217      -6.332  30.675 -55.880  1.00 48.57           C  
ATOM   1684  CD  GLN A 217      -6.075  30.838 -54.401  1.00 50.58           C  
ATOM   1685  OE1 GLN A 217      -5.068  31.421 -53.993  1.00 51.98           O  
ATOM   1686  NE2 GLN A 217      -6.997  30.336 -53.582  1.00 51.17           N  
ATOM   1687  N   PRO A 218      -4.233  30.153 -59.580  1.00 46.14           N  
ATOM   1688  CA  PRO A 218      -3.084  30.105 -60.481  1.00 46.02           C  
ATOM   1689  C   PRO A 218      -1.854  29.501 -59.806  1.00 45.96           C  
ATOM   1690  O   PRO A 218      -1.595  29.800 -58.640  1.00 46.20           O  
ATOM   1691  CB  PRO A 218      -2.836  31.581 -60.805  1.00 45.86           C  
ATOM   1692  CG  PRO A 218      -4.158  32.205 -60.694  1.00 45.83           C  
ATOM   1693  CD  PRO A 218      -4.840  31.498 -59.557  1.00 46.15           C  
ATOM   1694  N   PRO A 219      -1.103  28.652 -60.533  1.00 45.79           N  
ATOM   1695  CA  PRO A 219       0.043  27.968 -59.938  1.00 45.58           C  
ATOM   1696  C   PRO A 219       1.137  28.946 -59.508  1.00 45.32           C  
ATOM   1697  O   PRO A 219       1.591  29.774 -60.316  1.00 45.08           O  
ATOM   1698  CB  PRO A 219       0.548  27.066 -61.075  1.00 45.65           C  
ATOM   1699  CG  PRO A 219      -0.596  26.970 -62.038  1.00 45.97           C  
ATOM   1700  CD  PRO A 219      -1.274  28.295 -61.951  1.00 45.82           C  
ATOM   1701  N   SER A 220       1.534  28.849 -58.238  1.00 44.79           N  
ATOM   1702  CA  SER A 220       2.632  29.653 -57.682  1.00 44.39           C  
ATOM   1703  C   SER A 220       3.651  28.770 -56.959  1.00 43.81           C  
ATOM   1704  O   SER A 220       3.280  27.973 -56.099  1.00 43.96           O  
ATOM   1705  CB  SER A 220       2.094  30.750 -56.747  1.00 44.44           C  
ATOM   1706  OG  SER A 220       0.817  30.409 -56.224  1.00 44.29           O  
ATOM   1707  N   GLU A 221       4.924  28.910 -57.331  1.00 43.05           N  
ATOM   1708  CA  GLU A 221       6.022  28.174 -56.702  1.00 42.37           C  
ATOM   1709  C   GLU A 221       6.836  29.090 -55.779  1.00 41.69           C  
ATOM   1710  O   GLU A 221       8.059  28.968 -55.672  1.00 41.42           O  
ATOM   1711  CB  GLU A 221       6.929  27.521 -57.757  1.00 42.54           C  
ATOM   1712  CG  GLU A 221       6.309  26.334 -58.494  1.00 43.38           C  
ATOM   1713  CD  GLU A 221       5.451  26.759 -59.678  1.00 44.85           C  
ATOM   1714  OE1 GLU A 221       6.002  27.391 -60.607  1.00 46.05           O  
ATOM   1715  OE2 GLU A 221       4.233  26.451 -59.690  1.00 45.12           O  
ATOM   1716  N   GLU A 222       6.140  30.019 -55.128  1.00 40.96           N  
ATOM   1717  CA  GLU A 222       6.771  30.965 -54.205  1.00 40.25           C  
ATOM   1718  C   GLU A 222       7.222  30.271 -52.920  1.00 39.50           C  
ATOM   1719  O   GLU A 222       8.289  30.596 -52.368  1.00 39.82           O  
ATOM   1720  CB  GLU A 222       5.816  32.129 -53.889  1.00 40.22           C  
ATOM   1721  N   ASP A 223       6.412  29.302 -52.486  1.00 38.31           N  
ATOM   1722  CA  ASP A 223       6.597  28.577 -51.225  1.00 36.93           C  
ATOM   1723  C   ASP A 223       6.688  27.051 -51.400  1.00 36.29           C  
ATOM   1724  O   ASP A 223       6.599  26.532 -52.521  1.00 35.77           O  
ATOM   1725  CB  ASP A 223       5.459  28.930 -50.252  1.00 36.97           C  
ATOM   1726  CG  ASP A 223       4.075  28.549 -50.779  1.00 36.39           C  
ATOM   1727  OD1 ASP A 223       3.952  28.031 -51.907  1.00 35.02           O  
ATOM   1728  OD2 ASP A 223       3.093  28.769 -50.041  1.00 37.20           O  
ATOM   1729  N   ALA A 224       6.841  26.349 -50.273  1.00 35.13           N  
ATOM   1730  CA  ALA A 224       6.981  24.894 -50.250  1.00 33.89           C  
ATOM   1731  C   ALA A 224       5.733  24.152 -50.734  1.00 33.24           C  
ATOM   1732  O   ALA A 224       5.849  23.204 -51.510  1.00 32.93           O  
ATOM   1733  CB  ALA A 224       7.394  24.417 -48.855  1.00 33.76           C  
ATOM   1734  N   LEU A 225       4.554  24.583 -50.285  1.00 32.60           N  
ATOM   1735  CA  LEU A 225       3.282  23.954 -50.681  1.00 32.48           C  
ATOM   1736  C   LEU A 225       3.027  24.036 -52.194  1.00 31.86           C  
ATOM   1737  O   LEU A 225       2.620  23.053 -52.818  1.00 31.32           O  
ATOM   1738  CB  LEU A 225       2.107  24.561 -49.894  1.00 32.74           C  
ATOM   1739  CG  LEU A 225       0.708  23.976 -50.140  1.00 33.17           C  
ATOM   1740  CD1 LEU A 225       0.644  22.464 -49.857  1.00 33.97           C  
ATOM   1741  CD2 LEU A 225      -0.367  24.718 -49.349  1.00 32.85           C  
ATOM   1742  N   GLY A 226       3.275  25.213 -52.765  1.00 31.37           N  
ATOM   1743  CA  GLY A 226       3.222  25.420 -54.216  1.00 31.09           C  
ATOM   1744  C   GLY A 226       4.187  24.533 -54.973  1.00 30.62           C  
ATOM   1745  O   GLY A 226       3.812  23.916 -55.967  1.00 30.70           O  
ATOM   1746  N   ILE A 227       5.422  24.443 -54.481  1.00 30.20           N  
ATOM   1747  CA  ILE A 227       6.409  23.503 -55.020  1.00 29.68           C  
ATOM   1748  C   ILE A 227       5.921  22.043 -55.034  1.00 29.33           C  
ATOM   1749  O   ILE A 227       6.069  21.354 -56.047  1.00 29.55           O  
ATOM   1750  CB  ILE A 227       7.820  23.670 -54.360  1.00 29.67           C  
ATOM   1751  CG1 ILE A 227       8.449  24.987 -54.824  1.00 29.31           C  
ATOM   1752  CG2 ILE A 227       8.763  22.534 -54.762  1.00 29.60           C  
ATOM   1753  CD1 ILE A 227       9.781  25.323 -54.208  1.00 29.74           C  
ATOM   1754  N   LEU A 228       5.315  21.584 -53.942  1.00 28.74           N  
ATOM   1755  CA  LEU A 228       4.812  20.209 -53.867  1.00 27.97           C  
ATOM   1756  C   LEU A 228       3.615  19.964 -54.779  1.00 27.55           C  
ATOM   1757  O   LEU A 228       3.462  18.883 -55.344  1.00 27.51           O  
ATOM   1758  CB  LEU A 228       4.448  19.831 -52.426  1.00 28.03           C  
ATOM   1759  CG  LEU A 228       5.571  19.815 -51.381  1.00 27.43           C  
ATOM   1760  CD1 LEU A 228       5.016  19.466 -49.981  1.00 26.00           C  
ATOM   1761  CD2 LEU A 228       6.662  18.850 -51.820  1.00 26.61           C  
ATOM   1762  N   LEU A 229       2.759  20.964 -54.912  1.00 27.44           N  
ATOM   1763  CA  LEU A 229       1.609  20.864 -55.808  1.00 27.26           C  
ATOM   1764  C   LEU A 229       2.061  20.748 -57.254  1.00 27.24           C  
ATOM   1765  O   LEU A 229       1.450  20.029 -58.036  1.00 27.50           O  
ATOM   1766  CB  LEU A 229       0.682  22.060 -55.627  1.00 27.10           C  
ATOM   1767  CG  LEU A 229      -0.533  22.012 -54.687  1.00 27.14           C  
ATOM   1768  CD1 LEU A 229      -0.641  20.775 -53.826  1.00 28.59           C  
ATOM   1769  CD2 LEU A 229      -0.518  23.233 -53.812  1.00 28.40           C  
ATOM   1770  N   ALA A 230       3.153  21.427 -57.592  1.00 27.55           N  
ATOM   1771  CA  ALA A 230       3.694  21.417 -58.950  1.00 27.34           C  
ATOM   1772  C   ALA A 230       4.498  20.155 -59.264  1.00 27.33           C  
ATOM   1773  O   ALA A 230       4.600  19.754 -60.427  1.00 27.81           O  
ATOM   1774  CB  ALA A 230       4.540  22.661 -59.188  1.00 27.47           C  
ATOM   1775  N   ALA A 231       5.051  19.531 -58.224  1.00 26.83           N  
ATOM   1776  CA  ALA A 231       5.946  18.364 -58.350  1.00 26.30           C  
ATOM   1777  C   ALA A 231       5.379  17.175 -59.134  1.00 25.82           C  
ATOM   1778  O   ALA A 231       4.201  16.852 -58.994  1.00 25.79           O  
ATOM   1779  CB  ALA A 231       6.363  17.899 -56.972  1.00 25.92           C  
ATOM   1780  N   ARG A 232       6.243  16.527 -59.929  1.00 25.34           N  
ATOM   1781  CA  ARG A 232       5.912  15.294 -60.676  1.00 25.14           C  
ATOM   1782  C   ARG A 232       6.960  14.194 -60.448  1.00 25.07           C  
ATOM   1783  O   ARG A 232       8.158  14.472 -60.497  1.00 24.86           O  
ATOM   1784  CB  ARG A 232       5.798  15.572 -62.194  1.00 24.68           C  
ATOM   1785  CG  ARG A 232       4.679  16.520 -62.628  1.00 23.59           C  
ATOM   1786  CD  ARG A 232       3.320  15.968 -62.233  1.00 23.02           C  
ATOM   1787  NE  ARG A 232       2.216  16.864 -62.559  1.00 23.05           N  
ATOM   1788  CZ  ARG A 232       1.839  17.914 -61.830  1.00 24.77           C  
ATOM   1789  NH1 ARG A 232       2.488  18.234 -60.715  1.00 24.29           N  
ATOM   1790  NH2 ARG A 232       0.805  18.649 -62.220  1.00 23.02           N  
ATOM   1791  N   ASP A 233       6.518  12.947 -60.234  1.00 25.28           N  
ATOM   1792  CA  ASP A 233       7.458  11.816 -60.101  1.00 25.05           C  
ATOM   1793  C   ASP A 233       8.104  11.446 -61.446  1.00 25.42           C  
ATOM   1794  O   ASP A 233       7.850  12.104 -62.468  1.00 25.30           O  
ATOM   1795  CB  ASP A 233       6.855  10.595 -59.357  1.00 24.98           C  
ATOM   1796  CG  ASP A 233       5.755   9.868 -60.143  1.00 26.11           C  
ATOM   1797  OD1 ASP A 233       5.590  10.109 -61.357  1.00 25.45           O  
ATOM   1798  OD2 ASP A 233       5.044   9.027 -59.525  1.00 25.07           O  
ATOM   1799  N   ASP A 234       8.951  10.422 -61.448  1.00 25.23           N  
ATOM   1800  CA  ASP A 234       9.649  10.033 -62.674  1.00 26.02           C  
ATOM   1801  C   ASP A 234       8.686   9.523 -63.755  1.00 25.43           C  
ATOM   1802  O   ASP A 234       9.042   9.500 -64.926  1.00 25.54           O  
ATOM   1803  CB  ASP A 234      10.733   8.992 -62.391  1.00 26.24           C  
ATOM   1804  CG  ASP A 234      11.882   9.552 -61.596  1.00 29.09           C  
ATOM   1805  OD1 ASP A 234      12.202  10.766 -61.744  1.00 31.31           O  
ATOM   1806  OD2 ASP A 234      12.482   8.762 -60.833  1.00 32.06           O  
ATOM   1807  N   ASN A 235       7.482   9.127 -63.344  1.00 24.93           N  
ATOM   1808  CA  ASN A 235       6.427   8.681 -64.269  1.00 24.74           C  
ATOM   1809  C   ASN A 235       5.392   9.783 -64.514  1.00 24.09           C  
ATOM   1810  O   ASN A 235       4.250   9.512 -64.906  1.00 23.97           O  
ATOM   1811  CB  ASN A 235       5.745   7.410 -63.750  1.00 24.77           C  
ATOM   1812  CG  ASN A 235       6.551   6.134 -64.022  1.00 26.98           C  
ATOM   1813  OD1 ASN A 235       7.474   6.104 -64.836  1.00 29.62           O  
ATOM   1814  ND2 ASN A 235       6.185   5.070 -63.338  1.00 28.69           N  
ATOM   1815  N   ASN A 236       5.819  11.028 -64.283  1.00 23.63           N  
ATOM   1816  CA  ASN A 236       5.045  12.234 -64.546  1.00 23.59           C  
ATOM   1817  C   ASN A 236       3.730  12.318 -63.771  1.00 23.86           C  
ATOM   1818  O   ASN A 236       2.814  13.037 -64.181  1.00 23.25           O  
ATOM   1819  CB  ASN A 236       4.822  12.452 -66.060  1.00 23.71           C  
ATOM   1820  CG  ASN A 236       4.129  13.775 -66.373  1.00 23.72           C  
ATOM   1821  OD1 ASN A 236       4.517  14.828 -65.876  1.00 26.17           O  
ATOM   1822  ND2 ASN A 236       3.090  13.720 -67.192  1.00 23.53           N  
ATOM   1823  N   GLN A 237       3.662  11.604 -62.643  1.00 23.73           N  
ATOM   1824  CA  GLN A 237       2.483  11.615 -61.780  1.00 23.74           C  
ATOM   1825  C   GLN A 237       2.609  12.620 -60.622  1.00 24.19           C  
ATOM   1826  O   GLN A 237       3.689  12.752 -60.025  1.00 24.07           O  
ATOM   1827  CB  GLN A 237       2.235  10.217 -61.210  1.00 23.99           C  
ATOM   1828  CG  GLN A 237       1.932   9.139 -62.239  1.00 23.50           C  
ATOM   1829  CD  GLN A 237       0.815   9.530 -63.191  1.00 23.58           C  
ATOM   1830  OE1 GLN A 237      -0.268   9.913 -62.772  1.00 22.69           O  
ATOM   1831  NE2 GLN A 237       1.095   9.456 -64.484  1.00 25.41           N  
ATOM   1832  N   PRO A 238       1.503  13.327 -60.292  1.00 24.28           N  
ATOM   1833  CA  PRO A 238       1.512  14.232 -59.134  1.00 23.98           C  
ATOM   1834  C   PRO A 238       1.601  13.475 -57.805  1.00 24.02           C  
ATOM   1835  O   PRO A 238       1.364  12.263 -57.764  1.00 24.00           O  
ATOM   1836  CB  PRO A 238       0.166  14.950 -59.238  1.00 23.65           C  
ATOM   1837  CG  PRO A 238      -0.696  14.030 -60.022  1.00 24.61           C  
ATOM   1838  CD  PRO A 238       0.202  13.338 -60.992  1.00 24.09           C  
ATOM   1839  N   LEU A 239       1.961  14.184 -56.735  1.00 23.74           N  
ATOM   1840  CA  LEU A 239       1.898  13.617 -55.396  1.00 23.24           C  
ATOM   1841  C   LEU A 239       0.438  13.538 -54.993  1.00 23.11           C  
ATOM   1842  O   LEU A 239      -0.324  14.487 -55.214  1.00 22.47           O  
ATOM   1843  CB  LEU A 239       2.628  14.485 -54.382  1.00 22.94           C  
ATOM   1844  CG  LEU A 239       4.102  14.843 -54.554  1.00 23.55           C  
ATOM   1845  CD1 LEU A 239       4.590  15.478 -53.242  1.00 21.69           C  
ATOM   1846  CD2 LEU A 239       4.955  13.634 -54.933  1.00 23.16           C  
ATOM   1847  N   SER A 240       0.059  12.413 -54.394  1.00 23.05           N  
ATOM   1848  CA  SER A 240      -1.295  12.242 -53.886  1.00 23.51           C  
ATOM   1849  C   SER A 240      -1.565  13.246 -52.780  1.00 23.52           C  
ATOM   1850  O   SER A 240      -0.629  13.825 -52.212  1.00 24.31           O  
ATOM   1851  CB  SER A 240      -1.503  10.819 -53.362  1.00 23.78           C  
ATOM   1852  OG  SER A 240      -0.689  10.565 -52.218  1.00 22.85           O  
ATOM   1853  N   LEU A 241      -2.845  13.452 -52.481  1.00 23.68           N  
ATOM   1854  CA  LEU A 241      -3.258  14.281 -51.350  1.00 23.60           C  
ATOM   1855  C   LEU A 241      -2.727  13.775 -50.002  1.00 23.18           C  
ATOM   1856  O   LEU A 241      -2.185  14.572 -49.242  1.00 23.56           O  
ATOM   1857  CB  LEU A 241      -4.790  14.461 -51.309  1.00 24.01           C  
ATOM   1858  CG  LEU A 241      -5.353  15.212 -50.093  1.00 23.90           C  
ATOM   1859  CD1 LEU A 241      -4.991  16.696 -50.136  1.00 22.60           C  
ATOM   1860  CD2 LEU A 241      -6.861  15.016 -49.977  1.00 24.37           C  
ATOM   1861  N   PRO A 242      -2.892  12.472 -49.688  1.00 22.55           N  
ATOM   1862  CA  PRO A 242      -2.310  11.983 -48.437  1.00 22.58           C  
ATOM   1863  C   PRO A 242      -0.791  12.230 -48.320  1.00 22.00           C  
ATOM   1864  O   PRO A 242      -0.306  12.558 -47.235  1.00 22.30           O  
ATOM   1865  CB  PRO A 242      -2.643  10.476 -48.457  1.00 22.79           C  
ATOM   1866  CG  PRO A 242      -3.926  10.403 -49.299  1.00 23.15           C  
ATOM   1867  CD  PRO A 242      -3.633  11.405 -50.390  1.00 23.05           C  
ATOM   1868  N   GLU A 243      -0.062  12.092 -49.425  1.00 21.43           N  
ATOM   1869  CA  GLU A 243       1.366  12.403 -49.444  1.00 20.74           C  
ATOM   1870  C   GLU A 243       1.664  13.900 -49.286  1.00 20.75           C  
ATOM   1871  O   GLU A 243       2.600  14.286 -48.552  1.00 21.09           O  
ATOM   1872  CB  GLU A 243       2.059  11.834 -50.687  1.00 21.04           C  
ATOM   1873  CG  GLU A 243       3.472  12.376 -50.852  1.00 19.73           C  
ATOM   1874  CD  GLU A 243       4.431  11.434 -51.525  1.00 22.77           C  
ATOM   1875  OE1 GLU A 243       3.981  10.456 -52.197  1.00 21.82           O  
ATOM   1876  OE2 GLU A 243       5.656  11.684 -51.366  1.00 20.50           O  
ATOM   1877  N   LEU A 244       0.874  14.730 -49.970  1.00 20.31           N  
ATOM   1878  CA  LEU A 244       0.961  16.194 -49.862  1.00 20.01           C  
ATOM   1879  C   LEU A 244       0.819  16.677 -48.420  1.00 20.21           C  
ATOM   1880  O   LEU A 244       1.571  17.543 -47.968  1.00 19.92           O  
ATOM   1881  CB  LEU A 244      -0.126  16.855 -50.706  1.00 20.73           C  
ATOM   1882  CG  LEU A 244      -0.005  16.889 -52.236  1.00 21.12           C  
ATOM   1883  CD1 LEU A 244      -1.306  17.396 -52.894  1.00 19.90           C  
ATOM   1884  CD2 LEU A 244       1.169  17.744 -52.641  1.00 19.36           C  
ATOM   1885  N   LYS A 245      -0.159  16.120 -47.709  1.00 19.75           N  
ATOM   1886  CA  LYS A 245      -0.411  16.494 -46.328  1.00 19.88           C  
ATOM   1887  C   LYS A 245       0.685  16.017 -45.363  1.00 19.55           C  
ATOM   1888  O   LYS A 245       1.077  16.758 -44.474  1.00 19.45           O  
ATOM   1889  CB  LYS A 245      -1.782  16.001 -45.904  1.00 20.17           C  
ATOM   1890  CG  LYS A 245      -2.894  16.445 -46.855  1.00 19.98           C  
ATOM   1891  CD  LYS A 245      -4.272  16.259 -46.269  1.00 22.31           C  
ATOM   1892  CE  LYS A 245      -4.580  14.839 -45.902  1.00 22.91           C  
ATOM   1893  NZ  LYS A 245      -5.966  14.792 -45.359  1.00 24.62           N  
ATOM   1894  N   ASP A 246       1.159  14.782 -45.541  1.00 19.83           N  
ATOM   1895  CA  ASP A 246       2.267  14.234 -44.746  1.00 19.84           C  
ATOM   1896  C   ASP A 246       3.567  15.009 -44.973  1.00 20.06           C  
ATOM   1897  O   ASP A 246       4.340  15.218 -44.035  1.00 19.66           O  
ATOM   1898  CB  ASP A 246       2.486  12.752 -45.058  1.00 19.39           C  
ATOM   1899  CG  ASP A 246       1.645  11.822 -44.177  1.00 20.19           C  
ATOM   1900  OD1 ASP A 246       0.791  12.320 -43.412  1.00 20.37           O  
ATOM   1901  OD2 ASP A 246       1.847  10.586 -44.242  1.00 18.36           O  
ATOM   1902  N   GLN A 247       3.798  15.436 -46.216  1.00 19.97           N  
ATOM   1903  CA  GLN A 247       5.017  16.177 -46.564  1.00 19.44           C  
ATOM   1904  C   GLN A 247       5.064  17.599 -45.971  1.00 19.71           C  
ATOM   1905  O   GLN A 247       6.111  18.011 -45.477  1.00 18.48           O  
ATOM   1906  CB  GLN A 247       5.275  16.182 -48.089  1.00 19.67           C  
ATOM   1907  CG  GLN A 247       5.514  14.787 -48.741  1.00 18.60           C  
ATOM   1908  CD  GLN A 247       6.818  14.091 -48.322  1.00 20.03           C  
ATOM   1909  OE1 GLN A 247       7.498  14.499 -47.369  1.00 22.18           O  
ATOM   1910  NE2 GLN A 247       7.170  13.038 -49.040  1.00 18.45           N  
ATOM   1911  N   ILE A 248       3.952  18.347 -46.016  1.00 19.64           N  
ATOM   1912  CA  ILE A 248       3.938  19.673 -45.390  1.00 20.46           C  
ATOM   1913  C   ILE A 248       3.938  19.581 -43.888  1.00 19.64           C  
ATOM   1914  O   ILE A 248       4.539  20.407 -43.236  1.00 19.77           O  
ATOM   1915  CB  ILE A 248       2.765  20.626 -45.812  1.00 20.50           C  
ATOM   1916  CG1 ILE A 248       1.503  19.842 -46.174  1.00 21.14           C  
ATOM   1917  CG2 ILE A 248       3.242  21.590 -46.890  1.00 22.06           C  
ATOM   1918  CD1 ILE A 248       0.265  20.719 -46.496  1.00 21.08           C  
ATOM   1919  N   LEU A 249       3.249  18.589 -43.333  1.00 19.52           N  
ATOM   1920  CA  LEU A 249       3.265  18.419 -41.884  1.00 19.45           C  
ATOM   1921  C   LEU A 249       4.715  18.242 -41.392  1.00 19.29           C  
ATOM   1922  O   LEU A 249       5.070  18.772 -40.346  1.00 19.68           O  
ATOM   1923  CB  LEU A 249       2.393  17.235 -41.460  1.00 19.39           C  
ATOM   1924  CG  LEU A 249       2.177  16.910 -39.981  1.00 19.57           C  
ATOM   1925  CD1 LEU A 249       1.380  17.998 -39.287  1.00 21.97           C  
ATOM   1926  CD2 LEU A 249       1.452  15.558 -39.840  1.00 20.30           C  
ATOM   1927  N   LEU A 250       5.532  17.506 -42.153  1.00 18.84           N  
ATOM   1928  CA  LEU A 250       6.932  17.243 -41.791  1.00 18.70           C  
ATOM   1929  C   LEU A 250       7.768  18.501 -41.871  1.00 18.77           C  
ATOM   1930  O   LEU A 250       8.473  18.838 -40.915  1.00 19.54           O  
ATOM   1931  CB  LEU A 250       7.530  16.118 -42.652  1.00 18.34           C  
ATOM   1932  CG  LEU A 250       9.035  15.802 -42.537  1.00 18.71           C  
ATOM   1933  CD1 LEU A 250       9.445  15.365 -41.135  1.00 13.76           C  
ATOM   1934  CD2 LEU A 250       9.452  14.750 -43.566  1.00 18.37           C  
ATOM   1935  N   LEU A 251       7.665  19.211 -42.992  1.00 18.92           N  
ATOM   1936  CA  LEU A 251       8.376  20.475 -43.199  1.00 18.90           C  
ATOM   1937  C   LEU A 251       8.019  21.514 -42.146  1.00 19.32           C  
ATOM   1938  O   LEU A 251       8.898  22.226 -41.664  1.00 18.86           O  
ATOM   1939  CB  LEU A 251       8.067  21.060 -44.578  1.00 19.05           C  
ATOM   1940  CG  LEU A 251       8.610  20.385 -45.834  1.00 19.22           C  
ATOM   1941  CD1 LEU A 251       8.191  21.215 -47.058  1.00 20.69           C  
ATOM   1942  CD2 LEU A 251      10.102  20.260 -45.757  1.00 16.39           C  
ATOM   1943  N   LEU A 252       6.731  21.618 -41.809  1.00 18.95           N  
ATOM   1944  CA  LEU A 252       6.302  22.508 -40.723  1.00 19.52           C  
ATOM   1945  C   LEU A 252       6.804  22.056 -39.348  1.00 18.96           C  
ATOM   1946  O   LEU A 252       7.151  22.884 -38.532  1.00 19.49           O  
ATOM   1947  CB  LEU A 252       4.770  22.636 -40.677  1.00 19.46           C  
ATOM   1948  CG  LEU A 252       4.029  23.269 -41.848  1.00 20.56           C  
ATOM   1949  CD1 LEU A 252       2.570  22.852 -41.767  1.00 22.27           C  
ATOM   1950  CD2 LEU A 252       4.185  24.804 -41.839  1.00 21.54           C  
ATOM   1951  N   PHE A 253       6.794  20.753 -39.064  1.00 19.40           N  
ATOM   1952  CA  PHE A 253       7.385  20.269 -37.814  1.00 19.43           C  
ATOM   1953  C   PHE A 253       8.917  20.530 -37.754  1.00 19.23           C  
ATOM   1954  O   PHE A 253       9.422  21.115 -36.778  1.00 19.24           O  
ATOM   1955  CB  PHE A 253       7.031  18.794 -37.553  1.00 20.37           C  
ATOM   1956  CG  PHE A 253       8.035  18.069 -36.692  1.00 21.13           C  
ATOM   1957  CD1 PHE A 253       8.298  18.489 -35.387  1.00 21.93           C  
ATOM   1958  CD2 PHE A 253       8.725  16.974 -37.190  1.00 20.82           C  
ATOM   1959  CE1 PHE A 253       9.250  17.835 -34.607  1.00 21.12           C  
ATOM   1960  CE2 PHE A 253       9.661  16.319 -36.413  1.00 20.14           C  
ATOM   1961  CZ  PHE A 253       9.928  16.756 -35.122  1.00 20.49           C  
ATOM   1962  N   ALA A 254       9.645  20.118 -38.791  1.00 18.13           N  
ATOM   1963  CA  ALA A 254      11.089  20.292 -38.800  1.00 17.99           C  
ATOM   1964  C   ALA A 254      11.500  21.773 -38.783  1.00 17.85           C  
ATOM   1965  O   ALA A 254      12.461  22.158 -38.102  1.00 17.67           O  
ATOM   1966  CB  ALA A 254      11.706  19.567 -39.978  1.00 18.31           C  
ATOM   1967  N   GLY A 255      10.755  22.608 -39.510  1.00 17.17           N  
ATOM   1968  CA  GLY A 255      11.094  24.026 -39.641  1.00 16.60           C  
ATOM   1969  C   GLY A 255      10.838  24.787 -38.357  1.00 16.90           C  
ATOM   1970  O   GLY A 255      11.404  25.860 -38.119  1.00 17.43           O  
ATOM   1971  N   HIS A 256       9.952  24.215 -37.549  1.00 17.07           N  
ATOM   1972  CA  HIS A 256       9.472  24.790 -36.309  1.00 16.40           C  
ATOM   1973  C   HIS A 256      10.276  24.253 -35.109  1.00 16.04           C  
ATOM   1974  O   HIS A 256      10.902  25.023 -34.397  1.00 14.86           O  
ATOM   1975  CB  HIS A 256       7.964  24.497 -36.171  1.00 16.12           C  
ATOM   1976  CG  HIS A 256       7.397  24.811 -34.827  1.00 16.82           C  
ATOM   1977  ND1 HIS A 256       7.726  25.951 -34.125  1.00 18.00           N  
ATOM   1978  CD2 HIS A 256       6.510  24.138 -34.060  1.00 16.11           C  
ATOM   1979  CE1 HIS A 256       7.064  25.965 -32.983  1.00 18.52           C  
ATOM   1980  NE2 HIS A 256       6.318  24.875 -32.922  1.00 19.31           N  
ATOM   1981  N   GLU A 257      10.257  22.939 -34.886  1.00 15.63           N  
ATOM   1982  CA  GLU A 257      10.893  22.380 -33.676  1.00 15.55           C  
ATOM   1983  C   GLU A 257      12.426  22.583 -33.629  1.00 15.15           C  
ATOM   1984  O   GLU A 257      12.971  23.066 -32.640  1.00 15.10           O  
ATOM   1985  CB  GLU A 257      10.542  20.904 -33.508  1.00 15.28           C  
ATOM   1986  CG  GLU A 257      11.135  20.238 -32.249  1.00 17.33           C  
ATOM   1987  CD  GLU A 257      10.525  20.726 -30.917  1.00 18.96           C  
ATOM   1988  OE1 GLU A 257       9.464  21.406 -30.919  1.00 16.42           O  
ATOM   1989  OE2 GLU A 257      11.128  20.413 -29.865  1.00 18.93           O  
ATOM   1990  N   THR A 258      13.115  22.243 -34.708  1.00 14.15           N  
ATOM   1991  CA  THR A 258      14.579  22.307 -34.678  1.00 13.74           C  
ATOM   1992  C   THR A 258      15.021  23.756 -34.445  1.00 13.73           C  
ATOM   1993  O   THR A 258      15.925  24.018 -33.651  1.00 12.56           O  
ATOM   1994  CB  THR A 258      15.210  21.715 -35.990  1.00 13.82           C  
ATOM   1995  OG1 THR A 258      14.830  22.510 -37.119  1.00 12.88           O  
ATOM   1996  CG2 THR A 258      14.736  20.261 -36.222  1.00 11.64           C  
ATOM   1997  N   LEU A 259      14.351  24.694 -35.116  1.00 13.32           N  
ATOM   1998  CA  LEU A 259      14.730  26.098 -35.007  1.00 14.53           C  
ATOM   1999  C   LEU A 259      14.422  26.701 -33.657  1.00 15.26           C  
ATOM   2000  O   LEU A 259      15.137  27.577 -33.205  1.00 16.36           O  
ATOM   2001  CB  LEU A 259      14.150  26.931 -36.156  1.00 13.94           C  
ATOM   2002  CG  LEU A 259      15.209  26.839 -37.250  1.00 15.06           C  
ATOM   2003  CD1 LEU A 259      14.627  26.459 -38.588  1.00 16.76           C  
ATOM   2004  CD2 LEU A 259      16.094  28.111 -37.285  1.00 16.01           C  
ATOM   2005  N   THR A 260      13.350  26.243 -33.013  1.00 16.92           N  
ATOM   2006  CA  THR A 260      13.095  26.603 -31.616  1.00 17.68           C  
ATOM   2007  C   THR A 260      14.296  26.286 -30.706  1.00 17.26           C  
ATOM   2008  O   THR A 260      14.738  27.127 -29.945  1.00 17.50           O  
ATOM   2009  CB  THR A 260      11.857  25.890 -31.096  1.00 18.15           C  
ATOM   2010  OG1 THR A 260      10.689  26.475 -31.702  1.00 19.84           O  
ATOM   2011  CG2 THR A 260      11.777  26.037 -29.603  1.00 18.53           C  
ATOM   2012  N   SER A 261      14.804  25.065 -30.796  1.00 17.44           N  
ATOM   2013  CA  SER A 261      16.006  24.656 -30.072  1.00 17.42           C  
ATOM   2014  C   SER A 261      17.266  25.486 -30.454  1.00 17.25           C  
ATOM   2015  O   SER A 261      17.925  26.052 -29.572  1.00 17.13           O  
ATOM   2016  CB  SER A 261      16.234  23.153 -30.234  1.00 17.29           C  
ATOM   2017  OG  SER A 261      17.339  22.724 -29.468  1.00 19.18           O  
ATOM   2018  N   ALA A 262      17.576  25.585 -31.751  1.00 16.27           N  
ATOM   2019  CA  ALA A 262      18.782  26.297 -32.187  1.00 15.51           C  
ATOM   2020  C   ALA A 262      18.799  27.745 -31.677  1.00 15.24           C  
ATOM   2021  O   ALA A 262      19.833  28.224 -31.212  1.00 14.38           O  
ATOM   2022  CB  ALA A 262      18.948  26.243 -33.708  1.00 14.93           C  
ATOM   2023  N   LEU A 263      17.650  28.421 -31.744  1.00 15.16           N  
ATOM   2024  CA  LEU A 263      17.577  29.846 -31.362  1.00 15.07           C  
ATOM   2025  C   LEU A 263      17.529  30.082 -29.865  1.00 14.96           C  
ATOM   2026  O   LEU A 263      18.044  31.101 -29.423  1.00 15.23           O  
ATOM   2027  CB  LEU A 263      16.402  30.572 -32.027  1.00 15.52           C  
ATOM   2028  CG  LEU A 263      16.199  30.487 -33.542  1.00 16.13           C  
ATOM   2029  CD1 LEU A 263      15.014  31.373 -33.901  1.00 15.65           C  
ATOM   2030  CD2 LEU A 263      17.444  30.859 -34.360  1.00 17.06           C  
ATOM   2031  N   SER A 264      16.882  29.194 -29.091  1.00 14.23           N  
ATOM   2032  CA  SER A 264      17.006  29.259 -27.628  1.00 14.91           C  
ATOM   2033  C   SER A 264      18.453  29.007 -27.221  1.00 14.59           C  
ATOM   2034  O   SER A 264      18.957  29.680 -26.317  1.00 14.81           O  
ATOM   2035  CB  SER A 264      16.076  28.297 -26.874  1.00 15.05           C  
ATOM   2036  OG  SER A 264      16.157  26.975 -27.373  1.00 18.43           O  
ATOM   2037  N   SER A 265      19.105  28.049 -27.885  1.00 13.86           N  
ATOM   2038  CA  SER A 265      20.535  27.780 -27.652  1.00 13.71           C  
ATOM   2039  C   SER A 265      21.391  29.007 -27.922  1.00 13.53           C  
ATOM   2040  O   SER A 265      22.246  29.327 -27.115  1.00 13.38           O  
ATOM   2041  CB  SER A 265      21.040  26.603 -28.477  1.00 13.47           C  
ATOM   2042  OG  SER A 265      20.327  25.425 -28.134  1.00 13.14           O  
ATOM   2043  N   PHE A 266      21.154  29.679 -29.053  1.00 13.96           N  
ATOM   2044  CA  PHE A 266      21.877  30.913 -29.414  1.00 14.86           C  
ATOM   2045  C   PHE A 266      21.626  32.022 -28.393  1.00 15.03           C  
ATOM   2046  O   PHE A 266      22.530  32.799 -28.047  1.00 14.53           O  
ATOM   2047  CB  PHE A 266      21.464  31.400 -30.815  1.00 15.08           C  
ATOM   2048  CG  PHE A 266      22.083  32.717 -31.210  1.00 14.94           C  
ATOM   2049  CD1 PHE A 266      23.319  32.754 -31.860  1.00 14.14           C  
ATOM   2050  CD2 PHE A 266      21.444  33.921 -30.908  1.00 15.67           C  
ATOM   2051  CE1 PHE A 266      23.904  33.963 -32.204  1.00 12.40           C  
ATOM   2052  CE2 PHE A 266      22.039  35.155 -31.242  1.00 16.18           C  
ATOM   2053  CZ  PHE A 266      23.269  35.161 -31.897  1.00 14.57           C  
ATOM   2054  N   CYS A 267      20.381  32.117 -27.940  1.00 15.30           N  
ATOM   2055  CA  CYS A 267      20.011  33.117 -26.944  1.00 16.28           C  
ATOM   2056  C   CYS A 267      20.621  32.759 -25.600  1.00 16.43           C  
ATOM   2057  O   CYS A 267      21.062  33.637 -24.863  1.00 17.00           O  
ATOM   2058  CB  CYS A 267      18.490  33.228 -26.809  1.00 16.71           C  
ATOM   2059  SG  CYS A 267      17.665  33.888 -28.231  1.00 16.06           S  
ATOM   2060  N   LEU A 268      20.621  31.474 -25.276  1.00 16.17           N  
ATOM   2061  CA  LEU A 268      21.304  30.995 -24.090  1.00 16.74           C  
ATOM   2062  C   LEU A 268      22.805  31.317 -24.158  1.00 16.38           C  
ATOM   2063  O   LEU A 268      23.330  32.034 -23.291  1.00 16.62           O  
ATOM   2064  CB  LEU A 268      21.049  29.492 -23.892  1.00 16.74           C  
ATOM   2065  CG  LEU A 268      21.683  28.731 -22.719  1.00 19.02           C  
ATOM   2066  CD1 LEU A 268      21.448  29.415 -21.382  1.00 20.70           C  
ATOM   2067  CD2 LEU A 268      21.182  27.282 -22.682  1.00 18.03           C  
ATOM   2068  N   LEU A 269      23.482  30.828 -25.194  1.00 15.31           N  
ATOM   2069  CA  LEU A 269      24.956  30.953 -25.279  1.00 15.28           C  
ATOM   2070  C   LEU A 269      25.523  32.358 -25.491  1.00 16.02           C  
ATOM   2071  O   LEU A 269      26.558  32.719 -24.922  1.00 16.33           O  
ATOM   2072  CB  LEU A 269      25.522  29.983 -26.312  1.00 14.63           C  
ATOM   2073  CG  LEU A 269      25.325  28.519 -25.931  1.00 12.64           C  
ATOM   2074  CD1 LEU A 269      25.492  27.578 -27.162  1.00  8.36           C  
ATOM   2075  CD2 LEU A 269      26.293  28.176 -24.819  1.00 10.33           C  
ATOM   2076  N   LEU A 270      24.860  33.150 -26.312  1.00 16.70           N  
ATOM   2077  CA  LEU A 270      25.343  34.512 -26.549  1.00 17.82           C  
ATOM   2078  C   LEU A 270      24.842  35.399 -25.432  1.00 18.01           C  
ATOM   2079  O   LEU A 270      25.303  36.515 -25.276  1.00 18.73           O  
ATOM   2080  CB  LEU A 270      24.920  35.018 -27.924  1.00 17.17           C  
ATOM   2081  CG  LEU A 270      25.811  34.673 -29.136  1.00 18.73           C  
ATOM   2082  CD1 LEU A 270      27.104  35.442 -29.131  1.00 19.69           C  
ATOM   2083  CD2 LEU A 270      26.082  33.164 -29.300  1.00 18.41           C  
ATOM   2084  N   GLY A 271      23.907  34.866 -24.644  1.00 19.14           N  
ATOM   2085  CA  GLY A 271      23.506  35.459 -23.366  1.00 19.11           C  
ATOM   2086  C   GLY A 271      24.624  35.403 -22.336  1.00 19.13           C  
ATOM   2087  O   GLY A 271      24.842  36.367 -21.597  1.00 18.75           O  
ATOM   2088  N   GLN A 272      25.329  34.269 -22.308  1.00 19.07           N  
ATOM   2089  CA  GLN A 272      26.415  33.996 -21.355  1.00 19.43           C  
ATOM   2090  C   GLN A 272      27.833  34.375 -21.832  1.00 19.16           C  
ATOM   2091  O   GLN A 272      28.789  34.252 -21.064  1.00 20.23           O  
ATOM   2092  CB  GLN A 272      26.437  32.503 -20.989  1.00 19.31           C  
ATOM   2093  CG  GLN A 272      25.189  31.954 -20.355  1.00 19.72           C  
ATOM   2094  CD  GLN A 272      25.237  30.448 -20.235  1.00 19.76           C  
ATOM   2095  OE1 GLN A 272      25.288  29.744 -21.236  1.00 24.79           O  
ATOM   2096  NE2 GLN A 272      25.229  29.945 -19.013  1.00 20.29           N  
ATOM   2097  N   HIS A 273      27.980  34.790 -23.085  1.00 18.50           N  
ATOM   2098  CA  HIS A 273      29.302  35.139 -23.630  1.00 17.99           C  
ATOM   2099  C   HIS A 273      29.203  36.451 -24.378  1.00 17.88           C  
ATOM   2100  O   HIS A 273      29.158  36.475 -25.615  1.00 17.35           O  
ATOM   2101  CB  HIS A 273      29.819  34.054 -24.583  1.00 17.85           C  
ATOM   2102  CG  HIS A 273      29.970  32.705 -23.950  1.00 18.28           C  
ATOM   2103  ND1 HIS A 273      31.191  32.201 -23.552  1.00 18.04           N  
ATOM   2104  CD2 HIS A 273      29.052  31.753 -23.659  1.00 17.23           C  
ATOM   2105  CE1 HIS A 273      31.016  30.994 -23.041  1.00 20.08           C  
ATOM   2106  NE2 HIS A 273      29.724  30.703 -23.083  1.00 17.48           N  
ATOM   2107  N   SER A 274      29.136  37.536 -23.608  1.00 17.80           N  
ATOM   2108  CA  SER A 274      28.953  38.883 -24.127  1.00 17.90           C  
ATOM   2109  C   SER A 274      30.134  39.422 -24.959  1.00 18.33           C  
ATOM   2110  O   SER A 274      30.020  40.458 -25.620  1.00 19.10           O  
ATOM   2111  CB  SER A 274      28.671  39.820 -22.952  1.00 18.18           C  
ATOM   2112  OG  SER A 274      29.782  39.845 -22.058  1.00 18.18           O  
ATOM   2113  N   ASP A 275      31.274  38.760 -24.863  1.00 18.67           N  
ATOM   2114  CA  ASP A 275      32.454  39.116 -25.624  1.00 19.09           C  
ATOM   2115  C   ASP A 275      32.291  38.603 -27.035  1.00 18.76           C  
ATOM   2116  O   ASP A 275      32.654  39.280 -27.983  1.00 18.78           O  
ATOM   2117  CB  ASP A 275      33.718  38.524 -24.972  1.00 18.78           C  
ATOM   2118  CG  ASP A 275      33.640  36.998 -24.779  1.00 20.25           C  
ATOM   2119  OD1 ASP A 275      32.547  36.456 -24.464  1.00 20.55           O  
ATOM   2120  OD2 ASP A 275      34.691  36.336 -24.926  1.00 20.24           O  
ATOM   2121  N   ILE A 276      31.754  37.392 -27.161  1.00 18.87           N  
ATOM   2122  CA  ILE A 276      31.443  36.803 -28.460  1.00 18.92           C  
ATOM   2123  C   ILE A 276      30.323  37.599 -29.132  1.00 19.23           C  
ATOM   2124  O   ILE A 276      30.383  37.884 -30.330  1.00 19.25           O  
ATOM   2125  CB  ILE A 276      31.101  35.275 -28.338  1.00 18.78           C  
ATOM   2126  CG1 ILE A 276      32.270  34.544 -27.676  1.00 18.32           C  
ATOM   2127  CG2 ILE A 276      30.798  34.686 -29.717  1.00 17.82           C  
ATOM   2128  CD1 ILE A 276      32.110  33.056 -27.518  1.00 19.75           C  
ATOM   2129  N   ARG A 277      29.334  37.992 -28.334  1.00 19.22           N  
ATOM   2130  CA  ARG A 277      28.230  38.836 -28.778  1.00 19.65           C  
ATOM   2131  C   ARG A 277      28.723  40.149 -29.410  1.00 20.12           C  
ATOM   2132  O   ARG A 277      28.216  40.571 -30.459  1.00 19.84           O  
ATOM   2133  CB  ARG A 277      27.312  39.115 -27.580  1.00 19.44           C  
ATOM   2134  CG  ARG A 277      26.007  39.851 -27.883  1.00 19.69           C  
ATOM   2135  CD  ARG A 277      25.042  39.588 -26.749  1.00 21.60           C  
ATOM   2136  NE  ARG A 277      24.997  40.637 -25.735  1.00 26.47           N  
ATOM   2137  CZ  ARG A 277      24.792  40.429 -24.435  1.00 25.17           C  
ATOM   2138  NH1 ARG A 277      24.667  39.203 -23.958  1.00 25.07           N  
ATOM   2139  NH2 ARG A 277      24.758  41.452 -23.598  1.00 28.39           N  
ATOM   2140  N   GLU A 278      29.707  40.783 -28.771  1.00 20.47           N  
ATOM   2141  CA  GLU A 278      30.283  42.032 -29.271  1.00 21.38           C  
ATOM   2142  C   GLU A 278      31.066  41.869 -30.577  1.00 21.22           C  
ATOM   2143  O   GLU A 278      31.031  42.747 -31.424  1.00 20.74           O  
ATOM   2144  CB  GLU A 278      31.205  42.656 -28.224  1.00 21.68           C  
ATOM   2145  CG  GLU A 278      30.496  43.318 -27.070  1.00 25.94           C  
ATOM   2146  CD  GLU A 278      29.867  44.653 -27.439  1.00 31.52           C  
ATOM   2147  OE1 GLU A 278      30.167  45.196 -28.535  1.00 34.25           O  
ATOM   2148  OE2 GLU A 278      29.064  45.155 -26.621  1.00 33.11           O  
ATOM   2149  N   ARG A 279      31.799  40.767 -30.715  1.00 22.07           N  
ATOM   2150  CA  ARG A 279      32.545  40.492 -31.937  1.00 23.28           C  
ATOM   2151  C   ARG A 279      31.621  40.301 -33.135  1.00 23.70           C  
ATOM   2152  O   ARG A 279      31.972  40.682 -34.253  1.00 24.11           O  
ATOM   2153  CB  ARG A 279      33.446  39.271 -31.779  1.00 23.44           C  
ATOM   2154  CG  ARG A 279      34.550  39.403 -30.721  1.00 23.61           C  
ATOM   2155  CD  ARG A 279      35.585  38.289 -30.866  1.00 23.15           C  
ATOM   2156  NE  ARG A 279      36.123  38.230 -32.229  1.00 24.18           N  
ATOM   2157  CZ  ARG A 279      36.761  37.187 -32.759  1.00 24.63           C  
ATOM   2158  NH1 ARG A 279      36.944  36.074 -32.049  1.00 21.42           N  
ATOM   2159  NH2 ARG A 279      37.216  37.258 -34.015  1.00 24.89           N  
ATOM   2160  N   VAL A 280      30.456  39.699 -32.899  1.00 24.17           N  
ATOM   2161  CA  VAL A 280      29.401  39.583 -33.917  1.00 25.05           C  
ATOM   2162  C   VAL A 280      28.920  40.982 -34.318  1.00 25.64           C  
ATOM   2163  O   VAL A 280      28.742  41.278 -35.506  1.00 25.65           O  
ATOM   2164  CB  VAL A 280      28.195  38.713 -33.427  1.00 24.68           C  
ATOM   2165  CG1 VAL A 280      27.022  38.780 -34.410  1.00 24.65           C  
ATOM   2166  CG2 VAL A 280      28.609  37.278 -33.221  1.00 24.32           C  
ATOM   2167  N   ARG A 281      28.722  41.828 -33.309  1.00 26.37           N  
ATOM   2168  CA  ARG A 281      28.243  43.183 -33.495  1.00 27.43           C  
ATOM   2169  C   ARG A 281      29.269  44.029 -34.248  1.00 28.32           C  
ATOM   2170  O   ARG A 281      28.906  44.821 -35.101  1.00 27.82           O  
ATOM   2171  CB  ARG A 281      27.894  43.821 -32.146  1.00 27.18           C  
ATOM   2172  CG  ARG A 281      27.108  45.136 -32.259  1.00 27.27           C  
ATOM   2173  CD  ARG A 281      26.537  45.597 -30.907  1.00 27.42           C  
ATOM   2174  NE  ARG A 281      25.387  44.790 -30.480  1.00 25.73           N  
ATOM   2175  CZ  ARG A 281      25.259  44.205 -29.287  1.00 25.44           C  
ATOM   2176  NH1 ARG A 281      26.198  44.323 -28.350  1.00 23.49           N  
ATOM   2177  NH2 ARG A 281      24.165  43.509 -29.020  1.00 25.05           N  
ATOM   2178  N   GLN A 282      30.543  43.848 -33.907  1.00 30.08           N  
ATOM   2179  CA  GLN A 282      31.654  44.534 -34.555  1.00 32.03           C  
ATOM   2180  C   GLN A 282      31.699  44.159 -36.036  1.00 32.70           C  
ATOM   2181  O   GLN A 282      32.035  44.986 -36.890  1.00 33.11           O  
ATOM   2182  CB  GLN A 282      32.975  44.178 -33.856  1.00 31.73           C  
ATOM   2183  CG  GLN A 282      34.227  44.792 -34.503  1.00 33.41           C  
ATOM   2184  CD  GLN A 282      35.559  44.318 -33.897  1.00 33.73           C  
ATOM   2185  OE1 GLN A 282      36.466  45.128 -33.653  1.00 35.27           O  
ATOM   2186  NE2 GLN A 282      35.687  43.005 -33.670  1.00 36.58           N  
ATOM   2187  N   GLU A 283      31.347  42.906 -36.331  1.00 33.71           N  
ATOM   2188  CA  GLU A 283      31.311  42.407 -37.695  1.00 34.04           C  
ATOM   2189  C   GLU A 283      30.209  43.076 -38.502  1.00 35.27           C  
ATOM   2190  O   GLU A 283      30.443  43.502 -39.634  1.00 35.07           O  
ATOM   2191  CB  GLU A 283      31.153  40.884 -37.718  1.00 34.04           C  
ATOM   2192  CG  GLU A 283      31.063  40.293 -39.109  1.00 32.77           C  
ATOM   2193  CD  GLU A 283      30.950  38.784 -39.097  1.00 32.86           C  
ATOM   2194  OE1 GLU A 283      29.938  38.246 -38.573  1.00 30.63           O  
ATOM   2195  OE2 GLU A 283      31.883  38.147 -39.620  1.00 27.76           O  
ATOM   2196  N   GLN A 284      29.014  43.175 -37.920  1.00 36.88           N  
ATOM   2197  CA  GLN A 284      27.868  43.771 -38.622  1.00 38.50           C  
ATOM   2198  C   GLN A 284      27.951  45.298 -38.675  1.00 40.09           C  
ATOM   2199  O   GLN A 284      27.100  45.945 -39.303  1.00 40.82           O  
ATOM   2200  CB  GLN A 284      26.527  43.305 -38.031  1.00 38.25           C  
ATOM   2201  CG  GLN A 284      26.442  43.410 -36.531  1.00 37.85           C  
ATOM   2202  CD  GLN A 284      25.083  43.059 -35.961  1.00 37.57           C  
ATOM   2203  OE1 GLN A 284      24.529  41.984 -36.200  1.00 36.03           O  
ATOM   2204  NE2 GLN A 284      24.547  43.969 -35.184  1.00 37.40           N  
ATOM   2205  N   ASN A 285      28.970  45.860 -38.021  1.00 41.49           N  
ATOM   2206  CA  ASN A 285      29.205  47.306 -38.005  1.00 43.05           C  
ATOM   2207  C   ASN A 285      30.180  47.735 -39.092  1.00 44.15           C  
ATOM   2208  O   ASN A 285      30.081  48.846 -39.618  1.00 44.47           O  
ATOM   2209  CB  ASN A 285      29.714  47.777 -36.635  1.00 42.65           C  
ATOM   2210  CG  ASN A 285      28.610  47.864 -35.584  1.00 42.87           C  
ATOM   2211  OD1 ASN A 285      28.881  48.168 -34.425  1.00 43.59           O  
ATOM   2212  ND2 ASN A 285      27.372  47.595 -35.977  1.00 42.40           N  
ATOM   2213  N   LYS A 286      31.125  46.852 -39.409  1.00 45.50           N  
ATOM   2214  CA  LYS A 286      32.037  47.050 -40.534  1.00 47.08           C  
ATOM   2215  C   LYS A 286      31.307  46.879 -41.875  1.00 47.90           C  
ATOM   2216  O   LYS A 286      31.908  47.013 -42.948  1.00 48.28           O  
ATOM   2217  CB  LYS A 286      33.229  46.091 -40.441  1.00 46.94           C  
ATOM   2218  CG  LYS A 286      34.157  46.354 -39.257  1.00 47.59           C  
ATOM   2219  CD  LYS A 286      35.444  45.530 -39.358  1.00 47.71           C  
ATOM   2220  CE  LYS A 286      35.998  45.167 -37.979  1.00 49.24           C  
ATOM   2221  NZ  LYS A 286      36.163  46.345 -37.062  1.00 50.28           N  
ATOM   2222  N   LEU A 287      30.015  46.563 -41.805  1.00 48.66           N  
ATOM   2223  CA  LEU A 287      29.151  46.534 -42.977  1.00 49.45           C  
ATOM   2224  C   LEU A 287      28.346  47.817 -42.970  1.00 50.15           C  
ATOM   2225  O   LEU A 287      28.895  48.900 -42.747  1.00 50.51           O  
ATOM   2226  CB  LEU A 287      28.200  45.326 -42.936  1.00 49.47           C  
ATOM   2227  CG  LEU A 287      28.755  43.898 -42.921  1.00 49.11           C  
ATOM   2228  CD1 LEU A 287      27.616  42.903 -42.755  1.00 49.00           C  
ATOM   2229  CD2 LEU A 287      29.553  43.596 -44.181  1.00 48.78           C  
ATOM   2230  N   GLN A 288      27.044  47.682 -43.208  1.00 50.90           N  
ATOM   2231  CA  GLN A 288      26.086  48.779 -43.095  1.00 51.55           C  
ATOM   2232  C   GLN A 288      24.671  48.220 -43.170  1.00 51.88           C  
ATOM   2233  O   GLN A 288      24.116  48.039 -44.262  1.00 52.14           O  
ATOM   2234  CB  GLN A 288      26.316  49.840 -44.194  1.00 51.61           C  
ATOM   2235  N   LEU A 289      24.107  47.908 -42.006  1.00 52.20           N  
ATOM   2236  CA  LEU A 289      22.688  47.569 -41.905  1.00 52.31           C  
ATOM   2237  C   LEU A 289      21.883  48.852 -41.710  1.00 52.59           C  
ATOM   2238  O   LEU A 289      22.450  49.937 -41.510  1.00 52.67           O  
ATOM   2239  CB  LEU A 289      22.430  46.609 -40.733  1.00 52.36           C  
ATOM   2240  CG  LEU A 289      23.077  45.217 -40.745  1.00 52.09           C  
ATOM   2241  CD1 LEU A 289      23.126  44.625 -39.353  1.00 51.78           C  
ATOM   2242  CD2 LEU A 289      22.349  44.284 -41.693  1.00 52.06           C  
ATOM   2243  N   SER A 290      20.561  48.724 -41.791  1.00 52.51           N  
ATOM   2244  CA  SER A 290      19.628  49.780 -41.407  1.00 52.46           C  
ATOM   2245  C   SER A 290      18.372  49.008 -41.061  1.00 52.43           C  
ATOM   2246  O   SER A 290      18.342  48.254 -40.079  1.00 52.40           O  
ATOM   2247  CB  SER A 290      19.371  50.744 -42.570  1.00 52.54           C  
ATOM   2248  OG  SER A 290      20.578  51.287 -43.078  1.00 52.41           O  
ATOM   2249  N   GLN A 291      17.338  49.187 -41.875  1.00 52.13           N  
ATOM   2250  CA  GLN A 291      16.399  48.101 -42.104  1.00 51.80           C  
ATOM   2251  C   GLN A 291      16.844  47.365 -43.366  1.00 51.29           C  
ATOM   2252  O   GLN A 291      16.535  46.184 -43.549  1.00 51.42           O  
ATOM   2253  CB  GLN A 291      14.950  48.591 -42.179  1.00 51.87           C  
ATOM   2254  CG  GLN A 291      14.114  48.178 -40.961  1.00 52.32           C  
ATOM   2255  CD  GLN A 291      14.763  48.547 -39.628  1.00 52.92           C  
ATOM   2256  OE1 GLN A 291      14.679  49.690 -39.177  1.00 53.48           O  
ATOM   2257  NE2 GLN A 291      15.402  47.572 -38.989  1.00 52.44           N  
ATOM   2258  N   GLU A 292      17.595  48.076 -44.209  1.00 50.36           N  
ATOM   2259  CA  GLU A 292      18.215  47.508 -45.406  1.00 49.51           C  
ATOM   2260  C   GLU A 292      19.101  46.309 -45.058  1.00 48.86           C  
ATOM   2261  O   GLU A 292      20.226  46.466 -44.565  1.00 48.68           O  
ATOM   2262  CB  GLU A 292      19.019  48.576 -46.145  1.00 49.60           C  
ATOM   2263  N   LEU A 293      18.561  45.114 -45.310  1.00 47.98           N  
ATOM   2264  CA  LEU A 293      19.264  43.852 -45.089  1.00 47.00           C  
ATOM   2265  C   LEU A 293      18.873  42.852 -46.186  1.00 46.29           C  
ATOM   2266  O   LEU A 293      17.720  42.410 -46.247  1.00 46.34           O  
ATOM   2267  CB  LEU A 293      18.934  43.291 -43.695  1.00 47.04           C  
ATOM   2268  CG  LEU A 293      19.714  42.085 -43.146  1.00 47.06           C  
ATOM   2269  CD1 LEU A 293      19.399  41.855 -41.673  1.00 45.89           C  
ATOM   2270  CD2 LEU A 293      19.462  40.812 -43.944  1.00 47.12           C  
ATOM   2271  N   THR A 294      19.834  42.504 -47.040  1.00 45.18           N  
ATOM   2272  CA  THR A 294      19.608  41.569 -48.148  1.00 44.19           C  
ATOM   2273  C   THR A 294      20.252  40.209 -47.915  1.00 43.39           C  
ATOM   2274  O   THR A 294      21.030  40.032 -46.986  1.00 43.33           O  
ATOM   2275  CB  THR A 294      20.153  42.120 -49.486  1.00 44.13           C  
ATOM   2276  OG1 THR A 294      21.272  42.974 -49.230  1.00 44.04           O  
ATOM   2277  CG2 THR A 294      19.077  42.897 -50.230  1.00 44.42           C  
ATOM   2278  N   ALA A 295      19.922  39.259 -48.784  1.00 42.55           N  
ATOM   2279  CA  ALA A 295      20.517  37.928 -48.770  1.00 41.60           C  
ATOM   2280  C   ALA A 295      22.032  37.965 -48.970  1.00 40.80           C  
ATOM   2281  O   ALA A 295      22.751  37.113 -48.446  1.00 40.69           O  
ATOM   2282  CB  ALA A 295      19.859  37.053 -49.828  1.00 41.71           C  
ATOM   2283  N   GLU A 296      22.512  38.946 -49.729  1.00 39.69           N  
ATOM   2284  CA  GLU A 296      23.945  39.072 -49.980  1.00 38.87           C  
ATOM   2285  C   GLU A 296      24.664  39.701 -48.775  1.00 37.59           C  
ATOM   2286  O   GLU A 296      25.862  39.495 -48.589  1.00 37.42           O  
ATOM   2287  CB  GLU A 296      24.225  39.846 -51.285  1.00 39.34           C  
ATOM   2288  CG  GLU A 296      23.334  39.451 -52.506  1.00 41.04           C  
ATOM   2289  CD  GLU A 296      23.237  37.932 -52.757  1.00 43.36           C  
ATOM   2290  OE1 GLU A 296      22.216  37.323 -52.343  1.00 43.41           O  
ATOM   2291  OE2 GLU A 296      24.175  37.349 -53.355  1.00 43.22           O  
ATOM   2292  N   THR A 297      23.924  40.451 -47.957  1.00 36.15           N  
ATOM   2293  CA  THR A 297      24.454  41.024 -46.716  1.00 35.02           C  
ATOM   2294  C   THR A 297      24.780  39.951 -45.660  1.00 34.04           C  
ATOM   2295  O   THR A 297      25.855  39.974 -45.043  1.00 33.77           O  
ATOM   2296  CB  THR A 297      23.490  42.085 -46.145  1.00 35.40           C  
ATOM   2297  OG1 THR A 297      23.474  43.222 -47.025  1.00 35.36           O  
ATOM   2298  CG2 THR A 297      23.914  42.533 -44.741  1.00 35.16           C  
ATOM   2299  N   LEU A 298      23.853  39.018 -45.465  1.00 32.40           N  
ATOM   2300  CA  LEU A 298      24.049  37.881 -44.558  1.00 31.39           C  
ATOM   2301  C   LEU A 298      25.174  36.936 -44.996  1.00 30.69           C  
ATOM   2302  O   LEU A 298      25.694  36.163 -44.188  1.00 30.09           O  
ATOM   2303  CB  LEU A 298      22.746  37.089 -44.423  1.00 31.09           C  
ATOM   2304  CG  LEU A 298      21.501  37.790 -43.873  1.00 31.13           C  
ATOM   2305  CD1 LEU A 298      20.258  36.957 -44.157  1.00 30.09           C  
ATOM   2306  CD2 LEU A 298      21.623  38.102 -42.380  1.00 30.75           C  
ATOM   2307  N   LYS A 299      25.534  36.990 -46.282  1.00 30.30           N  
ATOM   2308  CA  LYS A 299      26.670  36.213 -46.808  1.00 29.59           C  
ATOM   2309  C   LYS A 299      28.017  36.882 -46.541  1.00 29.09           C  
ATOM   2310  O   LYS A 299      29.063  36.354 -46.919  1.00 29.05           O  
ATOM   2311  CB  LYS A 299      26.505  35.950 -48.306  1.00 29.50           C  
ATOM   2312  CG  LYS A 299      25.580  34.802 -48.636  1.00 29.24           C  
ATOM   2313  CD  LYS A 299      25.052  34.944 -50.046  1.00 29.63           C  
ATOM   2314  CE  LYS A 299      24.112  33.804 -50.427  1.00 31.55           C  
ATOM   2315  NZ  LYS A 299      22.868  33.814 -49.622  1.00 32.65           N  
ATOM   2316  N   LYS A 300      27.982  38.045 -45.897  1.00 28.72           N  
ATOM   2317  CA  LYS A 300      29.188  38.763 -45.480  1.00 28.33           C  
ATOM   2318  C   LYS A 300      29.430  38.637 -43.966  1.00 27.38           C  
ATOM   2319  O   LYS A 300      29.930  39.565 -43.315  1.00 27.39           O  
ATOM   2320  CB  LYS A 300      29.084  40.244 -45.867  1.00 28.69           C  
ATOM   2321  CG  LYS A 300      29.053  40.538 -47.368  1.00 30.29           C  
ATOM   2322  CD  LYS A 300      29.570  41.955 -47.625  1.00 33.55           C  
ATOM   2323  CE  LYS A 300      29.427  42.384 -49.088  1.00 34.62           C  
ATOM   2324  NZ  LYS A 300      28.091  43.011 -49.357  1.00 34.95           N  
ATOM   2325  N   MET A 301      29.085  37.488 -43.400  1.00 25.94           N  
ATOM   2326  CA  MET A 301      29.205  37.309 -41.953  1.00 24.38           C  
ATOM   2327  C   MET A 301      29.977  36.043 -41.594  1.00 23.51           C  
ATOM   2328  O   MET A 301      29.397  35.122 -41.013  1.00 24.24           O  
ATOM   2329  CB  MET A 301      27.809  37.298 -41.300  1.00 24.48           C  
ATOM   2330  CG  MET A 301      27.076  38.628 -41.347  1.00 22.64           C  
ATOM   2331  SD  MET A 301      25.287  38.488 -41.071  1.00 23.80           S  
ATOM   2332  CE  MET A 301      24.825  40.198 -41.327  1.00 22.58           C  
ATOM   2333  N   PRO A 302      31.281  35.984 -41.944  1.00 22.52           N  
ATOM   2334  CA  PRO A 302      32.127  34.823 -41.645  1.00 22.05           C  
ATOM   2335  C   PRO A 302      32.293  34.500 -40.149  1.00 21.79           C  
ATOM   2336  O   PRO A 302      32.363  33.321 -39.788  1.00 21.22           O  
ATOM   2337  CB  PRO A 302      33.493  35.217 -42.243  1.00 22.17           C  
ATOM   2338  CG  PRO A 302      33.475  36.708 -42.292  1.00 21.73           C  
ATOM   2339  CD  PRO A 302      32.046  37.014 -42.676  1.00 22.66           C  
ATOM   2340  N   TYR A 303      32.402  35.516 -39.295  1.00 20.54           N  
ATOM   2341  CA  TYR A 303      32.533  35.246 -37.871  1.00 20.78           C  
ATOM   2342  C   TYR A 303      31.220  34.719 -37.268  1.00 20.88           C  
ATOM   2343  O   TYR A 303      31.248  33.806 -36.458  1.00 20.97           O  
ATOM   2344  CB  TYR A 303      33.018  36.475 -37.095  1.00 20.73           C  
ATOM   2345  CG  TYR A 303      33.165  36.172 -35.627  1.00 20.64           C  
ATOM   2346  CD1 TYR A 303      34.202  35.367 -35.172  1.00 17.62           C  
ATOM   2347  CD2 TYR A 303      32.231  36.654 -34.696  1.00 19.55           C  
ATOM   2348  CE1 TYR A 303      34.335  35.071 -33.835  1.00 18.80           C  
ATOM   2349  CE2 TYR A 303      32.346  36.344 -33.349  1.00 19.83           C  
ATOM   2350  CZ  TYR A 303      33.400  35.563 -32.931  1.00 19.72           C  
ATOM   2351  OH  TYR A 303      33.531  35.267 -31.612  1.00 21.36           O  
ATOM   2352  N   LEU A 304      30.081  35.297 -37.663  1.00 20.83           N  
ATOM   2353  CA  LEU A 304      28.777  34.801 -37.213  1.00 20.25           C  
ATOM   2354  C   LEU A 304      28.597  33.352 -37.672  1.00 19.99           C  
ATOM   2355  O   LEU A 304      28.133  32.504 -36.899  1.00 18.93           O  
ATOM   2356  CB  LEU A 304      27.626  35.689 -37.709  1.00 20.21           C  
ATOM   2357  CG  LEU A 304      26.194  35.245 -37.389  1.00 19.94           C  
ATOM   2358  CD1 LEU A 304      25.956  35.117 -35.874  1.00 18.74           C  
ATOM   2359  CD2 LEU A 304      25.159  36.172 -37.991  1.00 20.58           C  
ATOM   2360  N   ASP A 305      28.993  33.073 -38.916  1.00 19.75           N  
ATOM   2361  CA  ASP A 305      29.067  31.702 -39.414  1.00 19.72           C  
ATOM   2362  C   ASP A 305      29.719  30.741 -38.413  1.00 19.82           C  
ATOM   2363  O   ASP A 305      29.177  29.660 -38.159  1.00 19.59           O  
ATOM   2364  CB  ASP A 305      29.829  31.635 -40.738  1.00 20.14           C  
ATOM   2365  CG  ASP A 305      28.986  32.027 -41.937  1.00 21.00           C  
ATOM   2366  OD1 ASP A 305      27.773  32.313 -41.803  1.00 22.59           O  
ATOM   2367  OD2 ASP A 305      29.563  32.059 -43.039  1.00 24.28           O  
ATOM   2368  N   GLN A 306      30.888  31.127 -37.878  1.00 19.29           N  
ATOM   2369  CA  GLN A 306      31.607  30.324 -36.868  1.00 19.25           C  
ATOM   2370  C   GLN A 306      30.829  30.100 -35.563  1.00 18.19           C  
ATOM   2371  O   GLN A 306      30.825  29.004 -35.011  1.00 17.44           O  
ATOM   2372  CB  GLN A 306      32.923  30.991 -36.507  1.00 19.63           C  
ATOM   2373  CG  GLN A 306      34.013  30.874 -37.568  1.00 21.53           C  
ATOM   2374  CD  GLN A 306      35.319  31.475 -37.080  1.00 24.12           C  
ATOM   2375  OE1 GLN A 306      35.749  31.245 -35.936  1.00 23.33           O  
ATOM   2376  NE2 GLN A 306      35.954  32.261 -37.942  1.00 25.74           N  
ATOM   2377  N   VAL A 307      30.228  31.169 -35.055  1.00 18.21           N  
ATOM   2378  CA  VAL A 307      29.433  31.120 -33.814  1.00 17.89           C  
ATOM   2379  C   VAL A 307      28.278  30.119 -33.982  1.00 18.16           C  
ATOM   2380  O   VAL A 307      27.973  29.319 -33.077  1.00 18.61           O  
ATOM   2381  CB  VAL A 307      28.919  32.534 -33.473  1.00 17.48           C  
ATOM   2382  CG1 VAL A 307      27.917  32.509 -32.325  1.00 17.30           C  
ATOM   2383  CG2 VAL A 307      30.085  33.450 -33.162  1.00 16.47           C  
ATOM   2384  N   LEU A 308      27.653  30.149 -35.153  1.00 17.90           N  
ATOM   2385  CA  LEU A 308      26.478  29.324 -35.391  1.00 17.98           C  
ATOM   2386  C   LEU A 308      26.845  27.845 -35.568  1.00 17.63           C  
ATOM   2387  O   LEU A 308      26.149  26.983 -35.036  1.00 17.84           O  
ATOM   2388  CB  LEU A 308      25.619  29.902 -36.525  1.00 17.80           C  
ATOM   2389  CG  LEU A 308      25.013  31.286 -36.276  1.00 17.92           C  
ATOM   2390  CD1 LEU A 308      24.309  31.814 -37.533  1.00 19.69           C  
ATOM   2391  CD2 LEU A 308      24.047  31.302 -35.080  1.00 18.13           C  
ATOM   2392  N   GLN A 309      27.976  27.562 -36.224  1.00 16.84           N  
ATOM   2393  CA  GLN A 309      28.561  26.212 -36.209  1.00 16.56           C  
ATOM   2394  C   GLN A 309      28.788  25.691 -34.778  1.00 15.86           C  
ATOM   2395  O   GLN A 309      28.547  24.513 -34.487  1.00 14.20           O  
ATOM   2396  CB  GLN A 309      29.911  26.167 -36.965  1.00 17.41           C  
ATOM   2397  CG  GLN A 309      29.857  26.358 -38.521  1.00 18.31           C  
ATOM   2398  CD  GLN A 309      29.307  25.150 -39.255  1.00 20.04           C  
ATOM   2399  OE1 GLN A 309      28.104  24.861 -39.203  1.00 24.33           O  
ATOM   2400  NE2 GLN A 309      30.177  24.443 -39.958  1.00 19.85           N  
ATOM   2401  N   GLU A 310      29.263  26.576 -33.899  1.00 15.00           N  
ATOM   2402  CA  GLU A 310      29.608  26.202 -32.533  1.00 15.88           C  
ATOM   2403  C   GLU A 310      28.398  26.085 -31.578  1.00 15.11           C  
ATOM   2404  O   GLU A 310      28.405  25.241 -30.671  1.00 15.43           O  
ATOM   2405  CB  GLU A 310      30.708  27.132 -31.977  1.00 15.64           C  
ATOM   2406  CG  GLU A 310      31.078  26.941 -30.500  1.00 16.90           C  
ATOM   2407  CD  GLU A 310      31.684  25.588 -30.165  1.00 18.46           C  
ATOM   2408  OE1 GLU A 310      31.649  24.657 -31.000  1.00 22.28           O  
ATOM   2409  OE2 GLU A 310      32.209  25.452 -29.040  1.00 15.36           O  
ATOM   2410  N   VAL A 311      27.375  26.911 -31.788  1.00 15.17           N  
ATOM   2411  CA  VAL A 311      26.076  26.734 -31.093  1.00 14.90           C  
ATOM   2412  C   VAL A 311      25.536  25.322 -31.370  1.00 15.27           C  
ATOM   2413  O   VAL A 311      25.261  24.569 -30.435  1.00 16.14           O  
ATOM   2414  CB  VAL A 311      25.024  27.832 -31.484  1.00 14.63           C  
ATOM   2415  CG1 VAL A 311      23.644  27.462 -30.998  1.00 15.92           C  
ATOM   2416  CG2 VAL A 311      25.392  29.185 -30.899  1.00 13.47           C  
ATOM   2417  N   LEU A 312      25.411  24.964 -32.652  1.00 15.39           N  
ATOM   2418  CA  LEU A 312      24.919  23.638 -33.085  1.00 15.40           C  
ATOM   2419  C   LEU A 312      25.808  22.491 -32.607  1.00 15.48           C  
ATOM   2420  O   LEU A 312      25.342  21.355 -32.437  1.00 15.57           O  
ATOM   2421  CB  LEU A 312      24.797  23.571 -34.624  1.00 15.36           C  
ATOM   2422  CG  LEU A 312      23.809  24.512 -35.342  1.00 15.17           C  
ATOM   2423  CD1 LEU A 312      23.881  24.341 -36.847  1.00 16.52           C  
ATOM   2424  CD2 LEU A 312      22.372  24.364 -34.851  1.00 13.81           C  
ATOM   2425  N   ARG A 313      27.100  22.788 -32.424  1.00 15.06           N  
ATOM   2426  CA  ARG A 313      28.050  21.800 -31.951  1.00 14.57           C  
ATOM   2427  C   ARG A 313      27.765  21.528 -30.479  1.00 14.09           C  
ATOM   2428  O   ARG A 313      27.546  20.389 -30.087  1.00 13.37           O  
ATOM   2429  CB  ARG A 313      29.503  22.281 -32.173  1.00 14.36           C  
ATOM   2430  CG  ARG A 313      30.575  21.192 -32.120  1.00 15.40           C  
ATOM   2431  CD  ARG A 313      30.996  20.825 -30.680  1.00 17.39           C  
ATOM   2432  NE  ARG A 313      31.385  21.987 -29.865  1.00 20.17           N  
ATOM   2433  CZ  ARG A 313      31.672  21.945 -28.558  1.00 18.10           C  
ATOM   2434  NH1 ARG A 313      31.632  20.805 -27.889  1.00 15.57           N  
ATOM   2435  NH2 ARG A 313      31.993  23.055 -27.916  1.00 15.25           N  
ATOM   2436  N   LEU A 314      27.789  22.589 -29.678  1.00 14.04           N  
ATOM   2437  CA  LEU A 314      27.629  22.480 -28.232  1.00 13.86           C  
ATOM   2438  C   LEU A 314      26.242  21.986 -27.830  1.00 14.09           C  
ATOM   2439  O   LEU A 314      26.121  21.122 -26.968  1.00 15.02           O  
ATOM   2440  CB  LEU A 314      27.964  23.812 -27.530  1.00 13.29           C  
ATOM   2441  CG  LEU A 314      27.966  23.831 -25.990  1.00 12.86           C  
ATOM   2442  CD1 LEU A 314      28.860  22.748 -25.365  1.00  9.01           C  
ATOM   2443  CD2 LEU A 314      28.330  25.206 -25.440  1.00 13.09           C  
ATOM   2444  N   ILE A 315      25.199  22.533 -28.440  1.00 14.24           N  
ATOM   2445  CA  ILE A 315      23.831  22.102 -28.123  1.00 14.54           C  
ATOM   2446  C   ILE A 315      23.097  21.669 -29.402  1.00 14.78           C  
ATOM   2447  O   ILE A 315      22.385  22.467 -29.996  1.00 15.91           O  
ATOM   2448  CB  ILE A 315      23.023  23.226 -27.415  1.00 14.66           C  
ATOM   2449  CG1 ILE A 315      23.781  23.793 -26.201  1.00 13.36           C  
ATOM   2450  CG2 ILE A 315      21.652  22.702 -26.974  1.00 14.64           C  
ATOM   2451  CD1 ILE A 315      23.138  25.044 -25.633  1.00 13.56           C  
ATOM   2452  N   PRO A 316      23.266  20.411 -29.831  1.00 14.84           N  
ATOM   2453  CA  PRO A 316      22.676  20.026 -31.117  1.00 15.22           C  
ATOM   2454  C   PRO A 316      21.142  19.891 -30.984  1.00 15.00           C  
ATOM   2455  O   PRO A 316      20.650  19.230 -30.052  1.00 14.81           O  
ATOM   2456  CB  PRO A 316      23.335  18.665 -31.421  1.00 14.87           C  
ATOM   2457  CG  PRO A 316      24.374  18.450 -30.338  1.00 14.09           C  
ATOM   2458  CD  PRO A 316      23.949  19.278 -29.189  1.00 15.25           C  
ATOM   2459  N   PRO A 317      20.387  20.531 -31.891  1.00 15.30           N  
ATOM   2460  CA  PRO A 317      18.903  20.514 -31.788  1.00 15.31           C  
ATOM   2461  C   PRO A 317      18.315  19.109 -31.893  1.00 15.61           C  
ATOM   2462  O   PRO A 317      17.294  18.809 -31.255  1.00 16.82           O  
ATOM   2463  CB  PRO A 317      18.459  21.355 -33.002  1.00 15.22           C  
ATOM   2464  CG  PRO A 317      19.643  22.219 -33.299  1.00 15.79           C  
ATOM   2465  CD  PRO A 317      20.839  21.329 -33.047  1.00 14.78           C  
ATOM   2466  N   VAL A 318      18.946  18.269 -32.710  1.00 15.27           N  
ATOM   2467  CA  VAL A 318      18.492  16.894 -32.979  1.00 14.91           C  
ATOM   2468  C   VAL A 318      19.548  15.976 -32.378  1.00 15.81           C  
ATOM   2469  O   VAL A 318      20.733  16.090 -32.722  1.00 15.51           O  
ATOM   2470  CB  VAL A 318      18.345  16.620 -34.496  1.00 14.44           C  
ATOM   2471  CG1 VAL A 318      17.961  15.148 -34.764  1.00 13.95           C  
ATOM   2472  CG2 VAL A 318      17.305  17.560 -35.105  1.00 12.19           C  
ATOM   2473  N   GLY A 319      19.117  15.102 -31.465  1.00 15.64           N  
ATOM   2474  CA  GLY A 319      20.033  14.261 -30.698  1.00 16.08           C  
ATOM   2475  C   GLY A 319      20.684  13.126 -31.469  1.00 16.53           C  
ATOM   2476  O   GLY A 319      21.822  12.728 -31.184  1.00 15.23           O  
ATOM   2477  N   GLY A 320      19.960  12.592 -32.449  1.00 17.37           N  
ATOM   2478  CA  GLY A 320      20.475  11.501 -33.243  1.00 18.37           C  
ATOM   2479  C   GLY A 320      19.406  10.912 -34.136  1.00 19.21           C  
ATOM   2480  O   GLY A 320      18.253  11.363 -34.105  1.00 18.86           O  
ATOM   2481  N   GLY A 321      19.802   9.891 -34.904  1.00 19.65           N  
ATOM   2482  CA  GLY A 321      18.934   9.180 -35.845  1.00 19.81           C  
ATOM   2483  C   GLY A 321      19.032   7.685 -35.597  1.00 20.55           C  
ATOM   2484  O   GLY A 321      19.818   7.241 -34.761  1.00 20.49           O  
ATOM   2485  N   PHE A 322      18.232   6.914 -36.326  1.00 20.61           N  
ATOM   2486  CA  PHE A 322      18.140   5.460 -36.164  1.00 21.22           C  
ATOM   2487  C   PHE A 322      18.142   4.738 -37.508  1.00 21.62           C  
ATOM   2488  O   PHE A 322      17.628   5.254 -38.501  1.00 21.14           O  
ATOM   2489  CB  PHE A 322      16.894   5.083 -35.367  1.00 21.24           C  
ATOM   2490  CG  PHE A 322      16.812   5.762 -34.038  1.00 21.68           C  
ATOM   2491  CD1 PHE A 322      17.217   5.106 -32.885  1.00 22.62           C  
ATOM   2492  CD2 PHE A 322      16.345   7.077 -33.943  1.00 21.05           C  
ATOM   2493  CE1 PHE A 322      17.149   5.750 -31.644  1.00 24.35           C  
ATOM   2494  CE2 PHE A 322      16.277   7.726 -32.712  1.00 21.82           C  
ATOM   2495  CZ  PHE A 322      16.683   7.073 -31.568  1.00 22.44           C  
ATOM   2496  N   ARG A 323      18.770   3.560 -37.527  1.00 22.66           N  
ATOM   2497  CA  ARG A 323      18.933   2.748 -38.740  1.00 23.44           C  
ATOM   2498  C   ARG A 323      18.688   1.295 -38.384  1.00 24.37           C  
ATOM   2499  O   ARG A 323      19.129   0.839 -37.336  1.00 24.67           O  
ATOM   2500  CB  ARG A 323      20.359   2.892 -39.311  1.00 23.21           C  
ATOM   2501  CG  ARG A 323      20.799   4.318 -39.644  1.00 22.44           C  
ATOM   2502  CD  ARG A 323      20.091   4.894 -40.864  1.00 20.55           C  
ATOM   2503  NE  ARG A 323      20.603   6.211 -41.255  1.00 19.81           N  
ATOM   2504  CZ  ARG A 323      20.124   7.381 -40.821  1.00 19.45           C  
ATOM   2505  NH1 ARG A 323      19.098   7.431 -39.979  1.00 18.60           N  
ATOM   2506  NH2 ARG A 323      20.655   8.517 -41.254  1.00 20.23           N  
ATOM   2507  N   GLU A 324      17.967   0.576 -39.235  1.00 25.81           N  
ATOM   2508  CA  GLU A 324      17.892  -0.872 -39.111  1.00 27.58           C  
ATOM   2509  C   GLU A 324      19.058  -1.486 -39.884  1.00 28.19           C  
ATOM   2510  O   GLU A 324      19.369  -1.049 -40.992  1.00 28.13           O  
ATOM   2511  CB  GLU A 324      16.562  -1.427 -39.648  1.00 27.55           C  
ATOM   2512  CG  GLU A 324      16.407  -2.928 -39.371  1.00 28.07           C  
ATOM   2513  CD  GLU A 324      15.189  -3.565 -40.005  1.00 28.91           C  
ATOM   2514  OE1 GLU A 324      14.205  -2.853 -40.304  1.00 30.07           O  
ATOM   2515  OE2 GLU A 324      15.218  -4.806 -40.191  1.00 30.21           O  
ATOM   2516  N   LEU A 325      19.705  -2.486 -39.299  1.00 29.14           N  
ATOM   2517  CA  LEU A 325      20.697  -3.256 -40.041  1.00 30.45           C  
ATOM   2518  C   LEU A 325      19.970  -4.240 -40.950  1.00 31.38           C  
ATOM   2519  O   LEU A 325      19.179  -5.051 -40.470  1.00 31.46           O  
ATOM   2520  CB  LEU A 325      21.625  -3.996 -39.088  1.00 30.34           C  
ATOM   2521  CG  LEU A 325      22.660  -3.160 -38.342  1.00 30.05           C  
ATOM   2522  CD1 LEU A 325      22.819  -3.681 -36.906  1.00 29.51           C  
ATOM   2523  CD2 LEU A 325      23.993  -3.144 -39.095  1.00 30.03           C  
ATOM   2524  N   ILE A 326      20.194  -4.133 -42.257  1.00 32.65           N  
ATOM   2525  CA  ILE A 326      19.586  -5.069 -43.217  1.00 34.30           C  
ATOM   2526  C   ILE A 326      20.588  -6.128 -43.691  1.00 35.24           C  
ATOM   2527  O   ILE A 326      20.207  -7.161 -44.249  1.00 35.31           O  
ATOM   2528  CB  ILE A 326      18.858  -4.352 -44.391  1.00 34.45           C  
ATOM   2529  CG1 ILE A 326      19.797  -3.405 -45.145  1.00 34.58           C  
ATOM   2530  CG2 ILE A 326      17.623  -3.593 -43.872  1.00 34.24           C  
ATOM   2531  CD1 ILE A 326      19.326  -3.063 -46.553  1.00 34.58           C  
ATOM   2532  N   GLN A 327      21.866  -5.849 -43.435  1.00 36.28           N  
ATOM   2533  CA  GLN A 327      22.952  -6.825 -43.482  1.00 37.19           C  
ATOM   2534  C   GLN A 327      23.507  -7.057 -42.085  1.00 37.51           C  
ATOM   2535  O   GLN A 327      23.372  -6.205 -41.207  1.00 37.90           O  
ATOM   2536  CB  GLN A 327      24.096  -6.301 -44.336  1.00 37.26           C  
ATOM   2537  CG  GLN A 327      24.116  -6.797 -45.754  1.00 38.71           C  
ATOM   2538  CD  GLN A 327      25.507  -6.709 -46.339  1.00 40.79           C  
ATOM   2539  OE1 GLN A 327      26.016  -5.610 -46.603  1.00 41.67           O  
ATOM   2540  NE2 GLN A 327      26.146  -7.869 -46.534  1.00 40.99           N  
ATOM   2541  N   ASP A 328      24.137  -8.213 -41.895  1.00 38.02           N  
ATOM   2542  CA  ASP A 328      24.900  -8.538 -40.692  1.00 38.19           C  
ATOM   2543  C   ASP A 328      26.236  -7.796 -40.793  1.00 38.25           C  
ATOM   2544  O   ASP A 328      26.875  -7.793 -41.856  1.00 38.68           O  
ATOM   2545  CB  ASP A 328      25.141 -10.051 -40.652  1.00 38.27           C  
ATOM   2546  CG  ASP A 328      24.971 -10.649 -39.271  1.00 39.09           C  
ATOM   2547  OD1 ASP A 328      25.968 -11.229 -38.775  1.00 40.86           O  
ATOM   2548  OD2 ASP A 328      23.858 -10.568 -38.688  1.00 38.00           O  
ATOM   2549  N   CYS A 329      26.657  -7.152 -39.707  1.00 38.04           N  
ATOM   2550  CA  CYS A 329      27.861  -6.312 -39.744  1.00 37.81           C  
ATOM   2551  C   CYS A 329      28.749  -6.488 -38.519  1.00 36.78           C  
ATOM   2552  O   CYS A 329      28.330  -7.065 -37.524  1.00 36.67           O  
ATOM   2553  CB  CYS A 329      27.477  -4.830 -39.902  1.00 38.04           C  
ATOM   2554  SG  CYS A 329      27.315  -4.264 -41.617  1.00 41.75           S  
ATOM   2555  N   GLN A 330      29.979  -5.989 -38.607  1.00 35.89           N  
ATOM   2556  CA  GLN A 330      30.846  -5.871 -37.438  1.00 35.41           C  
ATOM   2557  C   GLN A 330      31.476  -4.481 -37.373  1.00 34.12           C  
ATOM   2558  O   GLN A 330      31.751  -3.868 -38.400  1.00 34.09           O  
ATOM   2559  CB  GLN A 330      31.935  -6.954 -37.422  1.00 35.35           C  
ATOM   2560  CG  GLN A 330      32.928  -6.914 -38.601  1.00 36.26           C  
ATOM   2561  CD  GLN A 330      34.233  -7.645 -38.301  1.00 36.61           C  
ATOM   2562  OE1 GLN A 330      35.054  -7.184 -37.498  1.00 37.78           O  
ATOM   2563  NE2 GLN A 330      34.424  -8.796 -38.937  1.00 37.37           N  
ATOM   2564  N   PHE A 331      31.704  -3.989 -36.164  1.00 33.01           N  
ATOM   2565  CA  PHE A 331      32.345  -2.688 -35.993  1.00 31.62           C  
ATOM   2566  C   PHE A 331      33.135  -2.687 -34.710  1.00 30.96           C  
ATOM   2567  O   PHE A 331      32.620  -3.062 -33.661  1.00 31.14           O  
ATOM   2568  CB  PHE A 331      31.330  -1.527 -36.029  1.00 30.98           C  
ATOM   2569  CG  PHE A 331      31.943  -0.168 -35.765  1.00 30.25           C  
ATOM   2570  CD1 PHE A 331      32.897   0.368 -36.642  1.00 29.53           C  
ATOM   2571  CD2 PHE A 331      31.572   0.573 -34.644  1.00 28.23           C  
ATOM   2572  CE1 PHE A 331      33.486   1.617 -36.392  1.00 28.54           C  
ATOM   2573  CE2 PHE A 331      32.149   1.834 -34.392  1.00 27.98           C  
ATOM   2574  CZ  PHE A 331      33.111   2.350 -35.268  1.00 27.64           C  
ATOM   2575  N   GLN A 332      34.393  -2.267 -34.811  1.00 30.49           N  
ATOM   2576  CA  GLN A 332      35.330  -2.277 -33.688  1.00 30.11           C  
ATOM   2577  C   GLN A 332      35.177  -3.506 -32.792  1.00 29.43           C  
ATOM   2578  O   GLN A 332      35.045  -3.389 -31.570  1.00 29.78           O  
ATOM   2579  CB  GLN A 332      35.264  -0.957 -32.905  1.00 30.18           C  
ATOM   2580  CG  GLN A 332      36.205   0.100 -33.483  1.00 31.27           C  
ATOM   2581  CD  GLN A 332      35.870   1.528 -33.089  1.00 33.01           C  
ATOM   2582  OE1 GLN A 332      36.368   2.481 -33.704  1.00 33.29           O  
ATOM   2583  NE2 GLN A 332      35.033   1.692 -32.068  1.00 33.65           N  
ATOM   2584  N   GLY A 333      35.180  -4.680 -33.419  1.00 28.63           N  
ATOM   2585  CA  GLY A 333      35.167  -5.946 -32.704  1.00 28.43           C  
ATOM   2586  C   GLY A 333      33.828  -6.498 -32.247  1.00 28.54           C  
ATOM   2587  O   GLY A 333      33.787  -7.548 -31.599  1.00 28.54           O  
ATOM   2588  N   PHE A 334      32.734  -5.808 -32.563  1.00 28.46           N  
ATOM   2589  CA  PHE A 334      31.395  -6.295 -32.183  1.00 28.34           C  
ATOM   2590  C   PHE A 334      30.551  -6.768 -33.367  1.00 28.24           C  
ATOM   2591  O   PHE A 334      30.628  -6.212 -34.454  1.00 28.18           O  
ATOM   2592  CB  PHE A 334      30.621  -5.223 -31.412  1.00 28.28           C  
ATOM   2593  CG  PHE A 334      31.190  -4.916 -30.060  1.00 27.90           C  
ATOM   2594  CD1 PHE A 334      31.106  -5.844 -29.026  1.00 27.86           C  
ATOM   2595  CD2 PHE A 334      31.800  -3.690 -29.816  1.00 27.67           C  
ATOM   2596  CE1 PHE A 334      31.621  -5.552 -27.768  1.00 28.65           C  
ATOM   2597  CE2 PHE A 334      32.321  -3.389 -28.571  1.00 28.29           C  
ATOM   2598  CZ  PHE A 334      32.231  -4.318 -27.540  1.00 28.41           C  
ATOM   2599  N   HIS A 335      29.756  -7.808 -33.136  1.00 28.58           N  
ATOM   2600  CA  HIS A 335      28.738  -8.237 -34.087  1.00 28.27           C  
ATOM   2601  C   HIS A 335      27.563  -7.255 -34.007  1.00 28.10           C  
ATOM   2602  O   HIS A 335      27.011  -7.038 -32.932  1.00 28.16           O  
ATOM   2603  CB  HIS A 335      28.299  -9.668 -33.746  1.00 28.35           C  
ATOM   2604  CG  HIS A 335      27.244 -10.223 -34.650  1.00 28.14           C  
ATOM   2605  ND1 HIS A 335      26.261 -11.076 -34.198  1.00 28.70           N  
ATOM   2606  CD2 HIS A 335      27.018 -10.057 -35.975  1.00 28.25           C  
ATOM   2607  CE1 HIS A 335      25.471 -11.410 -35.205  1.00 28.16           C  
ATOM   2608  NE2 HIS A 335      25.904 -10.800 -36.292  1.00 26.73           N  
ATOM   2609  N   PHE A 336      27.250  -6.609 -35.132  1.00 27.81           N  
ATOM   2610  CA  PHE A 336      26.052  -5.775 -35.279  1.00 27.41           C  
ATOM   2611  C   PHE A 336      25.031  -6.631 -36.041  1.00 26.83           C  
ATOM   2612  O   PHE A 336      25.079  -6.709 -37.273  1.00 26.81           O  
ATOM   2613  CB  PHE A 336      26.365  -4.475 -36.053  1.00 27.24           C  
ATOM   2614  CG  PHE A 336      27.007  -3.381 -35.217  1.00 27.48           C  
ATOM   2615  CD1 PHE A 336      26.439  -2.113 -35.157  1.00 27.22           C  
ATOM   2616  CD2 PHE A 336      28.192  -3.611 -34.508  1.00 28.64           C  
ATOM   2617  CE1 PHE A 336      27.035  -1.089 -34.403  1.00 28.02           C  
ATOM   2618  CE2 PHE A 336      28.785  -2.603 -33.748  1.00 28.75           C  
ATOM   2619  CZ  PHE A 336      28.212  -1.337 -33.705  1.00 28.45           C  
ATOM   2620  N   PRO A 337      24.131  -7.312 -35.310  1.00 26.69           N  
ATOM   2621  CA  PRO A 337      23.242  -8.318 -35.917  1.00 26.78           C  
ATOM   2622  C   PRO A 337      22.152  -7.766 -36.837  1.00 27.32           C  
ATOM   2623  O   PRO A 337      21.521  -6.749 -36.540  1.00 27.20           O  
ATOM   2624  CB  PRO A 337      22.622  -9.014 -34.702  1.00 26.93           C  
ATOM   2625  CG  PRO A 337      23.484  -8.576 -33.500  1.00 26.23           C  
ATOM   2626  CD  PRO A 337      23.927  -7.209 -33.856  1.00 26.13           C  
ATOM   2627  N   LYS A 338      21.945  -8.448 -37.961  1.00 27.88           N  
ATOM   2628  CA  LYS A 338      20.868  -8.120 -38.899  1.00 28.05           C  
ATOM   2629  C   LYS A 338      19.514  -7.918 -38.193  1.00 27.79           C  
ATOM   2630  O   LYS A 338      19.108  -8.733 -37.358  1.00 28.29           O  
ATOM   2631  CB  LYS A 338      20.780  -9.211 -39.976  1.00 28.14           C  
ATOM   2632  CG  LYS A 338      19.544  -9.136 -40.849  1.00 29.27           C  
ATOM   2633  CD  LYS A 338      19.714  -9.926 -42.123  1.00 31.92           C  
ATOM   2634  CE  LYS A 338      18.462  -9.849 -42.965  1.00 33.33           C  
ATOM   2635  NZ  LYS A 338      17.313 -10.516 -42.278  1.00 36.92           N  
ATOM   2636  N   GLY A 339      18.829  -6.820 -38.515  1.00 27.29           N  
ATOM   2637  CA  GLY A 339      17.492  -6.566 -37.968  1.00 26.86           C  
ATOM   2638  C   GLY A 339      17.470  -5.811 -36.647  1.00 26.54           C  
ATOM   2639  O   GLY A 339      16.417  -5.328 -36.204  1.00 26.43           O  
ATOM   2640  N   TRP A 340      18.625  -5.727 -35.998  1.00 25.95           N  
ATOM   2641  CA  TRP A 340      18.773  -4.871 -34.834  1.00 25.50           C  
ATOM   2642  C   TRP A 340      18.893  -3.454 -35.371  1.00 24.74           C  
ATOM   2643  O   TRP A 340      19.218  -3.261 -36.551  1.00 24.59           O  
ATOM   2644  CB  TRP A 340      20.053  -5.214 -34.083  1.00 26.13           C  
ATOM   2645  CG  TRP A 340      20.022  -6.443 -33.227  1.00 26.26           C  
ATOM   2646  CD1 TRP A 340      19.395  -7.639 -33.490  1.00 26.45           C  
ATOM   2647  CD2 TRP A 340      20.724  -6.618 -31.991  1.00 26.16           C  
ATOM   2648  NE1 TRP A 340      19.634  -8.531 -32.462  1.00 26.62           N  
ATOM   2649  CE2 TRP A 340      20.455  -7.930 -31.538  1.00 27.96           C  
ATOM   2650  CE3 TRP A 340      21.537  -5.784 -31.214  1.00 27.60           C  
ATOM   2651  CZ2 TRP A 340      20.983  -8.427 -30.339  1.00 27.20           C  
ATOM   2652  CZ3 TRP A 340      22.052  -6.268 -30.026  1.00 27.11           C  
ATOM   2653  CH2 TRP A 340      21.775  -7.578 -29.599  1.00 27.56           C  
ATOM   2654  N   LEU A 341      18.646  -2.476 -34.504  1.00 23.65           N  
ATOM   2655  CA  LEU A 341      18.840  -1.070 -34.842  1.00 23.00           C  
ATOM   2656  C   LEU A 341      20.162  -0.508 -34.320  1.00 22.78           C  
ATOM   2657  O   LEU A 341      20.671  -0.943 -33.291  1.00 22.74           O  
ATOM   2658  CB  LEU A 341      17.708  -0.224 -34.262  1.00 22.90           C  
ATOM   2659  CG  LEU A 341      16.478   0.127 -35.081  1.00 23.12           C  
ATOM   2660  CD1 LEU A 341      15.911  -1.067 -35.831  1.00 22.73           C  
ATOM   2661  CD2 LEU A 341      15.443   0.751 -34.150  1.00 22.32           C  
ATOM   2662  N   VAL A 342      20.689   0.468 -35.051  1.00 22.12           N  
ATOM   2663  CA  VAL A 342      21.818   1.269 -34.629  1.00 22.41           C  
ATOM   2664  C   VAL A 342      21.326   2.699 -34.495  1.00 22.13           C  
ATOM   2665  O   VAL A 342      20.545   3.180 -35.328  1.00 22.23           O  
ATOM   2666  CB  VAL A 342      22.976   1.233 -35.685  1.00 22.64           C  
ATOM   2667  CG1 VAL A 342      24.195   2.014 -35.203  1.00 23.48           C  
ATOM   2668  CG2 VAL A 342      23.359  -0.184 -35.999  1.00 23.30           C  
ATOM   2669  N   SER A 343      21.770   3.376 -33.437  1.00 21.92           N  
ATOM   2670  CA  SER A 343      21.503   4.803 -33.248  1.00 20.98           C  
ATOM   2671  C   SER A 343      22.801   5.586 -33.195  1.00 21.19           C  
ATOM   2672  O   SER A 343      23.684   5.275 -32.381  1.00 21.02           O  
ATOM   2673  CB  SER A 343      20.736   5.048 -31.951  1.00 21.08           C  
ATOM   2674  OG  SER A 343      20.473   6.435 -31.780  1.00 20.45           O  
ATOM   2675  N   TYR A 344      22.906   6.616 -34.036  1.00 20.56           N  
ATOM   2676  CA  TYR A 344      24.086   7.459 -34.043  1.00 20.35           C  
ATOM   2677  C   TYR A 344      23.758   8.695 -33.223  1.00 20.30           C  
ATOM   2678  O   TYR A 344      22.742   9.352 -33.452  1.00 20.11           O  
ATOM   2679  CB  TYR A 344      24.574   7.780 -35.475  1.00 19.95           C  
ATOM   2680  CG  TYR A 344      23.763   8.820 -36.229  1.00 19.54           C  
ATOM   2681  CD1 TYR A 344      24.124  10.175 -36.203  1.00 19.67           C  
ATOM   2682  CD2 TYR A 344      22.650   8.447 -36.987  1.00 16.79           C  
ATOM   2683  CE1 TYR A 344      23.368  11.141 -36.904  1.00 18.03           C  
ATOM   2684  CE2 TYR A 344      21.907   9.389 -37.682  1.00 18.08           C  
ATOM   2685  CZ  TYR A 344      22.263  10.733 -37.627  1.00 17.92           C  
ATOM   2686  OH  TYR A 344      21.533  11.643 -38.319  1.00 16.42           O  
ATOM   2687  N   GLN A 345      24.604   8.973 -32.238  1.00 19.91           N  
ATOM   2688  CA  GLN A 345      24.316  10.007 -31.253  1.00 19.93           C  
ATOM   2689  C   GLN A 345      25.171  11.237 -31.512  1.00 19.60           C  
ATOM   2690  O   GLN A 345      26.381  11.247 -31.236  1.00 19.67           O  
ATOM   2691  CB  GLN A 345      24.519   9.474 -29.837  1.00 19.78           C  
ATOM   2692  CG  GLN A 345      23.509   8.383 -29.449  1.00 21.42           C  
ATOM   2693  CD  GLN A 345      22.108   8.960 -29.256  1.00 24.84           C  
ATOM   2694  OE1 GLN A 345      21.904   9.841 -28.417  1.00 25.36           O  
ATOM   2695  NE2 GLN A 345      21.151   8.498 -30.063  1.00 23.03           N  
ATOM   2696  N   ILE A 346      24.526  12.252 -32.077  1.00 18.77           N  
ATOM   2697  CA  ILE A 346      25.164  13.530 -32.404  1.00 18.54           C  
ATOM   2698  C   ILE A 346      25.618  14.242 -31.115  1.00 19.44           C  
ATOM   2699  O   ILE A 346      26.708  14.803 -31.052  1.00 20.34           O  
ATOM   2700  CB  ILE A 346      24.207  14.446 -33.222  1.00 17.54           C  
ATOM   2701  CG1 ILE A 346      23.744  13.747 -34.499  1.00 14.73           C  
ATOM   2702  CG2 ILE A 346      24.864  15.811 -33.536  1.00 15.56           C  
ATOM   2703  CD1 ILE A 346      22.563  14.411 -35.162  1.00 11.57           C  
ATOM   2704  N   SER A 347      24.781  14.200 -30.092  1.00 20.02           N  
ATOM   2705  CA  SER A 347      25.130  14.768 -28.794  1.00 20.96           C  
ATOM   2706  C   SER A 347      26.427  14.165 -28.228  1.00 20.69           C  
ATOM   2707  O   SER A 347      27.254  14.889 -27.695  1.00 21.15           O  
ATOM   2708  CB  SER A 347      23.963  14.591 -27.816  1.00 21.15           C  
ATOM   2709  OG  SER A 347      23.482  13.249 -27.847  1.00 24.40           O  
ATOM   2710  N   GLN A 348      26.596  12.849 -28.333  1.00 20.40           N  
ATOM   2711  CA  GLN A 348      27.828  12.202 -27.857  1.00 20.95           C  
ATOM   2712  C   GLN A 348      29.055  12.579 -28.712  1.00 20.47           C  
ATOM   2713  O   GLN A 348      30.124  12.895 -28.167  1.00 21.30           O  
ATOM   2714  CB  GLN A 348      27.672  10.673 -27.743  1.00 20.84           C  
ATOM   2715  CG  GLN A 348      26.562  10.214 -26.807  1.00 21.94           C  
ATOM   2716  CD  GLN A 348      26.241   8.708 -26.885  1.00 22.46           C  
ATOM   2717  OE1 GLN A 348      25.127   8.296 -26.570  1.00 24.55           O  
ATOM   2718  NE2 GLN A 348      27.213   7.892 -27.298  1.00 25.14           N  
ATOM   2719  N   THR A 349      28.901  12.561 -30.036  1.00 19.85           N  
ATOM   2720  CA  THR A 349      29.995  12.912 -30.949  1.00 19.08           C  
ATOM   2721  C   THR A 349      30.513  14.313 -30.660  1.00 19.40           C  
ATOM   2722  O   THR A 349      31.724  14.540 -30.644  1.00 19.47           O  
ATOM   2723  CB  THR A 349      29.581  12.801 -32.435  1.00 18.59           C  
ATOM   2724  OG1 THR A 349      29.040  11.504 -32.693  1.00 18.18           O  
ATOM   2725  CG2 THR A 349      30.778  13.020 -33.363  1.00 18.91           C  
ATOM   2726  N   HIS A 350      29.588  15.238 -30.409  1.00 19.58           N  
ATOM   2727  CA  HIS A 350      29.926  16.645 -30.184  1.00 20.19           C  
ATOM   2728  C   HIS A 350      30.479  16.931 -28.794  1.00 20.71           C  
ATOM   2729  O   HIS A 350      30.943  18.035 -28.530  1.00 20.30           O  
ATOM   2730  CB  HIS A 350      28.710  17.526 -30.464  1.00 19.44           C  
ATOM   2731  CG  HIS A 350      28.359  17.624 -31.919  1.00 18.61           C  
ATOM   2732  ND1 HIS A 350      27.410  18.498 -32.395  1.00 17.47           N  
ATOM   2733  CD2 HIS A 350      28.821  16.949 -32.996  1.00 16.44           C  
ATOM   2734  CE1 HIS A 350      27.302  18.358 -33.704  1.00 17.00           C  
ATOM   2735  NE2 HIS A 350      28.144  17.422 -34.092  1.00 16.16           N  
ATOM   2736  N   ALA A 351      30.431  15.930 -27.923  1.00 22.17           N  
ATOM   2737  CA  ALA A 351      31.020  16.025 -26.587  1.00 23.27           C  
ATOM   2738  C   ALA A 351      32.329  15.245 -26.483  1.00 24.06           C  
ATOM   2739  O   ALA A 351      32.923  15.176 -25.407  1.00 25.07           O  
ATOM   2740  CB  ALA A 351      30.014  15.543 -25.517  1.00 23.53           C  
ATOM   2741  N   ASP A 352      32.790  14.668 -27.592  1.00 24.89           N  
ATOM   2742  CA  ASP A 352      34.061  13.933 -27.603  1.00 25.97           C  
ATOM   2743  C   ASP A 352      35.235  14.880 -27.364  1.00 26.13           C  
ATOM   2744  O   ASP A 352      35.414  15.824 -28.109  1.00 25.66           O  
ATOM   2745  CB  ASP A 352      34.245  13.170 -28.915  1.00 26.25           C  
ATOM   2746  CG  ASP A 352      35.534  12.359 -28.945  1.00 28.02           C  
ATOM   2747  OD1 ASP A 352      35.696  11.418 -28.134  1.00 29.44           O  
ATOM   2748  OD2 ASP A 352      36.390  12.664 -29.793  1.00 30.24           O  
ATOM   2749  N   PRO A 353      36.025  14.643 -26.294  1.00 27.13           N  
ATOM   2750  CA  PRO A 353      37.142  15.557 -25.985  1.00 27.18           C  
ATOM   2751  C   PRO A 353      38.326  15.493 -26.949  1.00 27.33           C  
ATOM   2752  O   PRO A 353      39.103  16.442 -27.009  1.00 27.55           O  
ATOM   2753  CB  PRO A 353      37.550  15.163 -24.562  1.00 26.89           C  
ATOM   2754  CG  PRO A 353      37.092  13.746 -24.398  1.00 27.50           C  
ATOM   2755  CD  PRO A 353      35.890  13.564 -25.291  1.00 27.18           C  
ATOM   2756  N   ASP A 354      38.449  14.400 -27.700  1.00 27.72           N  
ATOM   2757  CA  ASP A 354      39.457  14.285 -28.762  1.00 28.06           C  
ATOM   2758  C   ASP A 354      39.085  15.143 -29.959  1.00 27.92           C  
ATOM   2759  O   ASP A 354      39.936  15.813 -30.558  1.00 28.62           O  
ATOM   2760  CB  ASP A 354      39.597  12.829 -29.226  1.00 28.46           C  
ATOM   2761  CG  ASP A 354      40.055  11.894 -28.124  1.00 29.76           C  
ATOM   2762  OD1 ASP A 354      40.712  12.355 -27.172  1.00 31.63           O  
ATOM   2763  OD2 ASP A 354      39.769  10.681 -28.223  1.00 32.28           O  
ATOM   2764  N   LEU A 355      37.806  15.092 -30.322  1.00 27.13           N  
ATOM   2765  CA  LEU A 355      37.231  15.965 -31.337  1.00 26.12           C  
ATOM   2766  C   LEU A 355      37.121  17.421 -30.882  1.00 25.58           C  
ATOM   2767  O   LEU A 355      37.406  18.347 -31.641  1.00 25.55           O  
ATOM   2768  CB  LEU A 355      35.842  15.427 -31.709  1.00 26.22           C  
ATOM   2769  CG  LEU A 355      35.575  14.773 -33.069  1.00 25.97           C  
ATOM   2770  CD1 LEU A 355      36.832  14.172 -33.718  1.00 21.17           C  
ATOM   2771  CD2 LEU A 355      34.424  13.750 -32.979  1.00 25.62           C  
ATOM   2772  N   TYR A 356      36.696  17.617 -29.640  1.00 25.19           N  
ATOM   2773  CA  TYR A 356      36.438  18.950 -29.098  1.00 25.41           C  
ATOM   2774  C   TYR A 356      37.125  19.148 -27.749  1.00 25.74           C  
ATOM   2775  O   TYR A 356      36.520  18.911 -26.706  1.00 25.81           O  
ATOM   2776  CB  TYR A 356      34.918  19.208 -29.008  1.00 24.61           C  
ATOM   2777  CG  TYR A 356      34.244  19.063 -30.348  1.00 24.30           C  
ATOM   2778  CD1 TYR A 356      34.437  20.022 -31.353  1.00 23.56           C  
ATOM   2779  CD2 TYR A 356      33.479  17.937 -30.645  1.00 23.38           C  
ATOM   2780  CE1 TYR A 356      33.847  19.880 -32.594  1.00 23.42           C  
ATOM   2781  CE2 TYR A 356      32.886  17.778 -31.891  1.00 22.28           C  
ATOM   2782  CZ  TYR A 356      33.068  18.755 -32.852  1.00 23.42           C  
ATOM   2783  OH  TYR A 356      32.484  18.622 -34.069  1.00 22.66           O  
ATOM   2784  N   PRO A 357      38.403  19.563 -27.770  1.00 26.34           N  
ATOM   2785  CA  PRO A 357      39.152  19.814 -26.530  1.00 26.86           C  
ATOM   2786  C   PRO A 357      38.412  20.781 -25.600  1.00 27.31           C  
ATOM   2787  O   PRO A 357      38.029  21.869 -26.035  1.00 27.95           O  
ATOM   2788  CB  PRO A 357      40.460  20.429 -27.039  1.00 26.94           C  
ATOM   2789  CG  PRO A 357      40.629  19.858 -28.404  1.00 26.68           C  
ATOM   2790  CD  PRO A 357      39.230  19.812 -28.968  1.00 26.24           C  
ATOM   2791  N   ASP A 358      38.217  20.372 -24.341  1.00 27.62           N  
ATOM   2792  CA  ASP A 358      37.311  21.038 -23.387  1.00 27.59           C  
ATOM   2793  C   ASP A 358      35.917  21.120 -23.992  1.00 26.88           C  
ATOM   2794  O   ASP A 358      35.450  22.218 -24.320  1.00 26.59           O  
ATOM   2795  CB  ASP A 358      37.788  22.447 -23.013  1.00 28.01           C  
ATOM   2796  CG  ASP A 358      39.038  22.441 -22.169  1.00 29.97           C  
ATOM   2797  OD1 ASP A 358      39.238  21.472 -21.396  1.00 30.88           O  
ATOM   2798  OD2 ASP A 358      39.816  23.427 -22.277  1.00 33.45           O  
ATOM   2799  N   PRO A 359      35.247  19.961 -24.136  1.00 26.40           N  
ATOM   2800  CA  PRO A 359      34.005  19.844 -24.915  1.00 25.88           C  
ATOM   2801  C   PRO A 359      32.876  20.712 -24.381  1.00 25.06           C  
ATOM   2802  O   PRO A 359      31.965  21.069 -25.122  1.00 25.32           O  
ATOM   2803  CB  PRO A 359      33.644  18.362 -24.762  1.00 26.07           C  
ATOM   2804  CG  PRO A 359      34.338  17.935 -23.479  1.00 26.24           C  
ATOM   2805  CD  PRO A 359      35.627  18.668 -23.531  1.00 26.42           C  
ATOM   2806  N   GLU A 360      32.949  21.053 -23.101  1.00 24.66           N  
ATOM   2807  CA  GLU A 360      31.863  21.738 -22.427  1.00 24.22           C  
ATOM   2808  C   GLU A 360      31.911  23.235 -22.711  1.00 23.18           C  
ATOM   2809  O   GLU A 360      30.974  23.965 -22.382  1.00 22.57           O  
ATOM   2810  CB  GLU A 360      31.907  21.454 -20.919  1.00 24.65           C  
ATOM   2811  CG  GLU A 360      32.999  22.231 -20.146  1.00 27.62           C  
ATOM   2812  CD  GLU A 360      34.393  21.619 -20.255  1.00 30.13           C  
ATOM   2813  OE1 GLU A 360      34.529  20.454 -20.699  1.00 29.74           O  
ATOM   2814  OE2 GLU A 360      35.364  22.314 -19.872  1.00 33.98           O  
ATOM   2815  N   LYS A 361      32.997  23.680 -23.340  1.00 22.30           N  
ATOM   2816  CA  LYS A 361      33.234  25.115 -23.541  1.00 22.31           C  
ATOM   2817  C   LYS A 361      32.791  25.607 -24.904  1.00 20.77           C  
ATOM   2818  O   LYS A 361      33.062  24.978 -25.924  1.00 21.75           O  
ATOM   2819  CB  LYS A 361      34.703  25.487 -23.290  1.00 22.64           C  
ATOM   2820  CG  LYS A 361      35.163  25.275 -21.858  1.00 25.87           C  
ATOM   2821  CD  LYS A 361      36.254  26.277 -21.508  1.00 29.21           C  
ATOM   2822  CE  LYS A 361      36.394  26.476 -20.005  1.00 32.03           C  
ATOM   2823  NZ  LYS A 361      37.384  25.550 -19.392  1.00 32.83           N  
ATOM   2824  N   PHE A 362      32.093  26.733 -24.889  1.00 19.59           N  
ATOM   2825  CA  PHE A 362      31.599  27.407 -26.075  1.00 18.68           C  
ATOM   2826  C   PHE A 362      32.726  28.231 -26.694  1.00 19.47           C  
ATOM   2827  O   PHE A 362      33.085  29.295 -26.177  1.00 19.88           O  
ATOM   2828  CB  PHE A 362      30.392  28.282 -25.702  1.00 17.43           C  
ATOM   2829  CG  PHE A 362      29.793  29.031 -26.853  1.00 15.51           C  
ATOM   2830  CD1 PHE A 362      29.108  28.361 -27.862  1.00 12.68           C  
ATOM   2831  CD2 PHE A 362      29.894  30.414 -26.921  1.00 13.97           C  
ATOM   2832  CE1 PHE A 362      28.558  29.045 -28.933  1.00 11.38           C  
ATOM   2833  CE2 PHE A 362      29.345  31.113 -28.005  1.00 11.97           C  
ATOM   2834  CZ  PHE A 362      28.663  30.423 -29.007  1.00 12.40           C  
ATOM   2835  N   ASP A 363      33.280  27.739 -27.802  1.00 19.37           N  
ATOM   2836  CA  ASP A 363      34.411  28.398 -28.470  1.00 20.28           C  
ATOM   2837  C   ASP A 363      34.312  28.397 -30.008  1.00 19.82           C  
ATOM   2838  O   ASP A 363      34.675  27.428 -30.648  1.00 19.93           O  
ATOM   2839  CB  ASP A 363      35.726  27.747 -28.013  1.00 20.16           C  
ATOM   2840  CG  ASP A 363      36.947  28.304 -28.729  1.00 22.49           C  
ATOM   2841  OD1 ASP A 363      36.952  29.506 -29.137  1.00 22.47           O  
ATOM   2842  OD2 ASP A 363      37.911  27.515 -28.879  1.00 25.07           O  
ATOM   2843  N   PRO A 364      33.770  29.473 -30.591  1.00 19.73           N  
ATOM   2844  CA  PRO A 364      33.713  29.718 -32.028  1.00 20.35           C  
ATOM   2845  C   PRO A 364      35.048  29.555 -32.807  1.00 20.77           C  
ATOM   2846  O   PRO A 364      35.022  29.192 -33.987  1.00 20.39           O  
ATOM   2847  CB  PRO A 364      33.214  31.152 -32.095  1.00 20.12           C  
ATOM   2848  CG  PRO A 364      32.317  31.255 -30.909  1.00 19.96           C  
ATOM   2849  CD  PRO A 364      33.079  30.533 -29.845  1.00 20.12           C  
ATOM   2850  N   GLU A 365      36.178  29.814 -32.143  1.00 21.51           N  
ATOM   2851  CA  GLU A 365      37.515  29.709 -32.741  1.00 22.19           C  
ATOM   2852  C   GLU A 365      37.885  28.299 -33.197  1.00 22.53           C  
ATOM   2853  O   GLU A 365      38.921  28.119 -33.802  1.00 23.45           O  
ATOM   2854  CB  GLU A 365      38.607  30.218 -31.779  1.00 22.02           C  
ATOM   2855  CG  GLU A 365      38.407  31.631 -31.262  1.00 22.55           C  
ATOM   2856  CD  GLU A 365      38.465  32.674 -32.359  1.00 23.95           C  
ATOM   2857  OE1 GLU A 365      39.434  32.669 -33.143  1.00 26.29           O  
ATOM   2858  OE2 GLU A 365      37.542  33.503 -32.440  1.00 23.30           O  
ATOM   2859  N   ARG A 366      37.058  27.299 -32.886  1.00 23.13           N  
ATOM   2860  CA  ARG A 366      37.275  25.946 -33.389  1.00 23.11           C  
ATOM   2861  C   ARG A 366      37.014  25.908 -34.894  1.00 23.87           C  
ATOM   2862  O   ARG A 366      37.577  25.077 -35.606  1.00 24.14           O  
ATOM   2863  CB  ARG A 366      36.367  24.921 -32.686  1.00 23.18           C  
ATOM   2864  CG  ARG A 366      36.406  24.881 -31.163  1.00 21.81           C  
ATOM   2865  CD  ARG A 366      35.299  23.929 -30.646  1.00 22.70           C  
ATOM   2866  NE  ARG A 366      35.047  24.006 -29.203  1.00 20.17           N  
ATOM   2867  CZ  ARG A 366      35.731  23.348 -28.270  1.00 21.00           C  
ATOM   2868  NH1 ARG A 366      36.753  22.576 -28.606  1.00 20.74           N  
ATOM   2869  NH2 ARG A 366      35.412  23.480 -26.986  1.00 20.53           N  
ATOM   2870  N   PHE A 367      36.158  26.808 -35.371  1.00 24.44           N  
ATOM   2871  CA  PHE A 367      35.743  26.816 -36.778  1.00 25.84           C  
ATOM   2872  C   PHE A 367      36.449  27.898 -37.623  1.00 26.95           C  
ATOM   2873  O   PHE A 367      36.179  28.041 -38.826  1.00 27.31           O  
ATOM   2874  CB  PHE A 367      34.203  26.861 -36.882  1.00 24.98           C  
ATOM   2875  CG  PHE A 367      33.542  25.670 -36.239  1.00 24.93           C  
ATOM   2876  CD1 PHE A 367      33.364  24.488 -36.960  1.00 24.26           C  
ATOM   2877  CD2 PHE A 367      33.181  25.700 -34.895  1.00 24.08           C  
ATOM   2878  CE1 PHE A 367      32.809  23.375 -36.371  1.00 23.50           C  
ATOM   2879  CE2 PHE A 367      32.625  24.590 -34.296  1.00 23.97           C  
ATOM   2880  CZ  PHE A 367      32.441  23.416 -35.045  1.00 23.06           C  
ATOM   2881  N   THR A 368      37.343  28.641 -36.968  1.00 28.49           N  
ATOM   2882  CA  THR A 368      38.270  29.586 -37.608  1.00 30.32           C  
ATOM   2883  C   THR A 368      39.180  28.768 -38.501  1.00 31.64           C  
ATOM   2884  O   THR A 368      39.656  27.726 -38.059  1.00 32.19           O  
ATOM   2885  CB  THR A 368      39.143  30.318 -36.536  1.00 29.97           C  
ATOM   2886  OG1 THR A 368      38.331  31.222 -35.789  1.00 30.61           O  
ATOM   2887  CG2 THR A 368      40.305  31.112 -37.159  1.00 30.00           C  
ATOM   2888  N   PRO A 369      39.419  29.229 -39.754  1.00 33.16           N  
ATOM   2889  CA  PRO A 369      40.289  28.647 -40.776  1.00 34.12           C  
ATOM   2890  C   PRO A 369      41.289  27.529 -40.379  1.00 35.04           C  
ATOM   2891  O   PRO A 369      41.273  26.460 -41.008  1.00 35.34           O  
ATOM   2892  CB  PRO A 369      41.001  29.885 -41.317  1.00 34.39           C  
ATOM   2893  CG  PRO A 369      39.911  30.987 -41.215  1.00 33.48           C  
ATOM   2894  CD  PRO A 369      38.825  30.468 -40.289  1.00 33.30           C  
ATOM   2895  N   ASP A 370      42.139  27.752 -39.377  1.00 35.89           N  
ATOM   2896  CA  ASP A 370      43.104  26.708 -38.980  1.00 37.00           C  
ATOM   2897  C   ASP A 370      42.799  26.030 -37.649  1.00 37.22           C  
ATOM   2898  O   ASP A 370      43.637  25.281 -37.120  1.00 37.33           O  
ATOM   2899  CB  ASP A 370      44.526  27.266 -38.933  1.00 37.59           C  
ATOM   2900  CG  ASP A 370      45.094  27.512 -40.300  1.00 38.97           C  
ATOM   2901  OD1 ASP A 370      45.751  26.584 -40.836  1.00 39.76           O  
ATOM   2902  OD2 ASP A 370      44.880  28.629 -40.834  1.00 40.79           O  
ATOM   2903  N   GLY A 371      41.607  26.298 -37.115  1.00 37.06           N  
ATOM   2904  CA  GLY A 371      41.215  25.835 -35.790  1.00 36.90           C  
ATOM   2905  C   GLY A 371      41.042  24.335 -35.693  1.00 36.59           C  
ATOM   2906  O   GLY A 371      41.000  23.636 -36.706  1.00 36.02           O  
ATOM   2907  N   SER A 372      40.927  23.861 -34.455  1.00 36.60           N  
ATOM   2908  CA  SER A 372      40.889  22.433 -34.140  1.00 36.83           C  
ATOM   2909  C   SER A 372      39.855  21.617 -34.935  1.00 37.18           C  
ATOM   2910  O   SER A 372      40.112  20.459 -35.289  1.00 37.50           O  
ATOM   2911  CB  SER A 372      40.695  22.232 -32.632  1.00 36.49           C  
ATOM   2912  OG  SER A 372      39.670  23.071 -32.128  1.00 35.64           O  
ATOM   2913  N   ALA A 373      38.709  22.230 -35.218  1.00 37.49           N  
ATOM   2914  CA  ALA A 373      37.593  21.543 -35.863  1.00 38.33           C  
ATOM   2915  C   ALA A 373      37.714  21.433 -37.387  1.00 38.88           C  
ATOM   2916  O   ALA A 373      36.995  20.646 -38.012  1.00 38.93           O  
ATOM   2917  CB  ALA A 373      36.271  22.208 -35.476  1.00 38.37           C  
ATOM   2918  N   THR A 374      38.628  22.210 -37.971  1.00 39.36           N  
ATOM   2919  CA  THR A 374      38.816  22.270 -39.427  1.00 39.57           C  
ATOM   2920  C   THR A 374      39.619  21.095 -39.990  1.00 39.47           C  
ATOM   2921  O   THR A 374      39.340  20.615 -41.093  1.00 40.23           O  
ATOM   2922  CB  THR A 374      39.527  23.556 -39.845  1.00 39.67           C  
ATOM   2923  OG1 THR A 374      40.812  23.591 -39.218  1.00 39.98           O  
ATOM   2924  CG2 THR A 374      38.712  24.790 -39.433  1.00 40.01           C  
ATOM   2925  N   HIS A 375      40.637  20.648 -39.265  1.00 38.98           N  
ATOM   2926  CA  HIS A 375      41.336  19.442 -39.688  1.00 38.52           C  
ATOM   2927  C   HIS A 375      41.046  18.227 -38.803  1.00 37.49           C  
ATOM   2928  O   HIS A 375      41.893  17.353 -38.649  1.00 37.91           O  
ATOM   2929  CB  HIS A 375      42.850  19.664 -39.944  1.00 39.30           C  
ATOM   2930  CG  HIS A 375      43.481  20.738 -39.106  1.00 39.96           C  
ATOM   2931  ND1 HIS A 375      43.926  21.932 -39.640  1.00 40.47           N  
ATOM   2932  CD2 HIS A 375      43.766  20.787 -37.781  1.00 40.54           C  
ATOM   2933  CE1 HIS A 375      44.442  22.677 -38.677  1.00 41.06           C  
ATOM   2934  NE2 HIS A 375      44.355  22.007 -37.539  1.00 41.25           N  
ATOM   2935  N   ASN A 376      39.836  18.180 -38.237  1.00 36.08           N  
ATOM   2936  CA  ASN A 376      39.307  16.981 -37.577  1.00 34.47           C  
ATOM   2937  C   ASN A 376      39.014  15.921 -38.654  1.00 33.69           C  
ATOM   2938  O   ASN A 376      38.931  16.256 -39.844  1.00 33.76           O  
ATOM   2939  CB  ASN A 376      38.017  17.309 -36.782  1.00 34.41           C  
ATOM   2940  CG  ASN A 376      38.252  17.443 -35.267  1.00 33.23           C  
ATOM   2941  OD1 ASN A 376      39.219  16.919 -34.718  1.00 31.52           O  
ATOM   2942  ND2 ASN A 376      37.338  18.137 -34.588  1.00 32.91           N  
ATOM   2943  N   PRO A 377      38.875  14.640 -38.257  1.00 32.73           N  
ATOM   2944  CA  PRO A 377      38.399  13.640 -39.222  1.00 31.98           C  
ATOM   2945  C   PRO A 377      37.023  13.993 -39.804  1.00 31.07           C  
ATOM   2946  O   PRO A 377      36.312  14.823 -39.233  1.00 31.39           O  
ATOM   2947  CB  PRO A 377      38.321  12.349 -38.392  1.00 31.99           C  
ATOM   2948  CG  PRO A 377      38.344  12.787 -36.967  1.00 32.89           C  
ATOM   2949  CD  PRO A 377      39.177  14.032 -36.948  1.00 32.79           C  
ATOM   2950  N   PRO A 378      36.671  13.425 -40.971  1.00 30.10           N  
ATOM   2951  CA  PRO A 378      35.304  13.580 -41.476  1.00 29.22           C  
ATOM   2952  C   PRO A 378      34.260  13.088 -40.478  1.00 28.12           C  
ATOM   2953  O   PRO A 378      34.532  12.167 -39.708  1.00 27.70           O  
ATOM   2954  CB  PRO A 378      35.288  12.692 -42.726  1.00 29.53           C  
ATOM   2955  CG  PRO A 378      36.723  12.661 -43.177  1.00 30.36           C  
ATOM   2956  CD  PRO A 378      37.529  12.671 -41.909  1.00 29.97           C  
ATOM   2957  N   PHE A 379      33.086  13.716 -40.489  1.00 27.14           N  
ATOM   2958  CA  PHE A 379      31.924  13.272 -39.674  1.00 26.27           C  
ATOM   2959  C   PHE A 379      32.081  13.538 -38.179  1.00 25.10           C  
ATOM   2960  O   PHE A 379      31.514  12.829 -37.338  1.00 24.71           O  
ATOM   2961  CB  PHE A 379      31.563  11.800 -39.949  1.00 26.71           C  
ATOM   2962  CG  PHE A 379      31.225  11.513 -41.391  1.00 27.24           C  
ATOM   2963  CD1 PHE A 379      30.073  12.043 -41.971  1.00 28.66           C  
ATOM   2964  CD2 PHE A 379      32.061  10.715 -42.169  1.00 28.88           C  
ATOM   2965  CE1 PHE A 379      29.753  11.782 -43.310  1.00 28.08           C  
ATOM   2966  CE2 PHE A 379      31.748  10.437 -43.519  1.00 29.15           C  
ATOM   2967  CZ  PHE A 379      30.593  10.977 -44.081  1.00 28.46           C  
ATOM   2968  N   ALA A 380      32.827  14.597 -37.877  1.00 23.69           N  
ATOM   2969  CA  ALA A 380      33.126  15.017 -36.516  1.00 22.63           C  
ATOM   2970  C   ALA A 380      32.116  16.074 -36.009  1.00 21.70           C  
ATOM   2971  O   ALA A 380      31.800  16.154 -34.812  1.00 21.64           O  
ATOM   2972  CB  ALA A 380      34.557  15.560 -36.469  1.00 22.07           C  
ATOM   2973  N   HIS A 381      31.629  16.885 -36.942  1.00 20.94           N  
ATOM   2974  CA  HIS A 381      30.608  17.886 -36.700  1.00 19.79           C  
ATOM   2975  C   HIS A 381      29.431  17.439 -37.569  1.00 19.48           C  
ATOM   2976  O   HIS A 381      29.456  17.565 -38.792  1.00 19.74           O  
ATOM   2977  CB  HIS A 381      31.153  19.253 -37.113  1.00 19.78           C  
ATOM   2978  CG  HIS A 381      30.225  20.402 -36.863  1.00 18.71           C  
ATOM   2979  ND1 HIS A 381      29.926  20.863 -35.599  1.00 17.28           N  
ATOM   2980  CD2 HIS A 381      29.579  21.223 -37.720  1.00 16.99           C  
ATOM   2981  CE1 HIS A 381      29.107  21.893 -35.688  1.00 15.14           C  
ATOM   2982  NE2 HIS A 381      28.887  22.136 -36.965  1.00 17.93           N  
ATOM   2983  N   VAL A 382      28.424  16.852 -36.927  1.00 18.67           N  
ATOM   2984  CA  VAL A 382      27.272  16.297 -37.626  1.00 17.14           C  
ATOM   2985  C   VAL A 382      25.898  16.749 -37.079  1.00 16.35           C  
ATOM   2986  O   VAL A 382      25.033  15.903 -36.821  1.00 16.16           O  
ATOM   2987  CB  VAL A 382      27.344  14.750 -37.696  1.00 16.86           C  
ATOM   2988  CG1 VAL A 382      28.468  14.303 -38.654  1.00 17.62           C  
ATOM   2989  CG2 VAL A 382      27.486  14.114 -36.291  1.00 17.78           C  
ATOM   2990  N   PRO A 383      25.682  18.073 -36.949  1.00 15.56           N  
ATOM   2991  CA  PRO A 383      24.405  18.619 -36.448  1.00 15.68           C  
ATOM   2992  C   PRO A 383      23.239  18.339 -37.430  1.00 15.15           C  
ATOM   2993  O   PRO A 383      22.088  18.270 -37.015  1.00 14.25           O  
ATOM   2994  CB  PRO A 383      24.682  20.127 -36.343  1.00 14.99           C  
ATOM   2995  CG  PRO A 383      25.772  20.375 -37.387  1.00 16.81           C  
ATOM   2996  CD  PRO A 383      26.631  19.146 -37.332  1.00 15.83           C  
ATOM   2997  N   PHE A 384      23.560  18.157 -38.715  1.00 15.33           N  
ATOM   2998  CA  PHE A 384      22.572  17.843 -39.759  1.00 15.09           C  
ATOM   2999  C   PHE A 384      22.668  16.401 -40.260  1.00 15.63           C  
ATOM   3000  O   PHE A 384      22.078  16.056 -41.294  1.00 16.58           O  
ATOM   3001  CB  PHE A 384      22.703  18.815 -40.938  1.00 15.10           C  
ATOM   3002  CG  PHE A 384      22.540  20.269 -40.545  1.00 15.35           C  
ATOM   3003  CD1 PHE A 384      21.271  20.800 -40.266  1.00 15.23           C  
ATOM   3004  CD2 PHE A 384      23.654  21.099 -40.420  1.00 14.95           C  
ATOM   3005  CE1 PHE A 384      21.114  22.140 -39.904  1.00 13.67           C  
ATOM   3006  CE2 PHE A 384      23.503  22.444 -40.056  1.00 12.24           C  
ATOM   3007  CZ  PHE A 384      22.236  22.959 -39.800  1.00 13.17           C  
ATOM   3008  N   GLY A 385      23.396  15.563 -39.537  1.00 15.23           N  
ATOM   3009  CA  GLY A 385      23.605  14.180 -39.941  1.00 16.32           C  
ATOM   3010  C   GLY A 385      24.605  14.064 -41.083  1.00 16.78           C  
ATOM   3011  O   GLY A 385      25.540  14.875 -41.208  1.00 17.37           O  
ATOM   3012  N   GLY A 386      24.412  13.054 -41.917  1.00 16.79           N  
ATOM   3013  CA  GLY A 386      25.263  12.852 -43.086  1.00 17.34           C  
ATOM   3014  C   GLY A 386      24.704  11.722 -43.917  1.00 17.76           C  
ATOM   3015  O   GLY A 386      23.633  11.174 -43.602  1.00 16.85           O  
ATOM   3016  N   GLY A 387      25.436  11.378 -44.978  1.00 18.39           N  
ATOM   3017  CA  GLY A 387      25.033  10.349 -45.948  1.00 19.24           C  
ATOM   3018  C   GLY A 387      23.696  10.579 -46.640  1.00 19.92           C  
ATOM   3019  O   GLY A 387      23.361  11.699 -47.009  1.00 19.89           O  
ATOM   3020  N   LEU A 388      22.929   9.501 -46.790  1.00 20.27           N  
ATOM   3021  CA  LEU A 388      21.673   9.515 -47.537  1.00 20.78           C  
ATOM   3022  C   LEU A 388      20.500  10.289 -46.933  1.00 21.05           C  
ATOM   3023  O   LEU A 388      19.570  10.662 -47.655  1.00 21.88           O  
ATOM   3024  CB  LEU A 388      21.232   8.072 -47.897  1.00 21.25           C  
ATOM   3025  CG  LEU A 388      22.045   7.296 -48.965  1.00 20.77           C  
ATOM   3026  CD1 LEU A 388      21.536   5.870 -49.113  1.00 20.73           C  
ATOM   3027  CD2 LEU A 388      22.076   7.993 -50.334  1.00 22.35           C  
ATOM   3028  N   ARG A 389      20.545  10.547 -45.632  1.00 20.94           N  
ATOM   3029  CA  ARG A 389      19.433  11.152 -44.912  1.00 20.06           C  
ATOM   3030  C   ARG A 389      19.789  12.531 -44.356  1.00 20.25           C  
ATOM   3031  O   ARG A 389      19.000  13.128 -43.609  1.00 19.26           O  
ATOM   3032  CB  ARG A 389      19.000  10.234 -43.761  1.00 20.40           C  
ATOM   3033  CG  ARG A 389      18.431   8.891 -44.213  1.00 20.39           C  
ATOM   3034  CD  ARG A 389      16.996   9.090 -44.615  1.00 19.21           C  
ATOM   3035  NE  ARG A 389      16.397   7.885 -45.140  1.00 22.26           N  
ATOM   3036  CZ  ARG A 389      15.092   7.669 -45.249  1.00 20.93           C  
ATOM   3037  NH1 ARG A 389      14.205   8.584 -44.855  1.00 20.84           N  
ATOM   3038  NH2 ARG A 389      14.684   6.520 -45.751  1.00 23.16           N  
ATOM   3039  N   GLU A 390      20.962  13.038 -44.741  1.00 19.24           N  
ATOM   3040  CA  GLU A 390      21.418  14.350 -44.304  1.00 19.56           C  
ATOM   3041  C   GLU A 390      20.307  15.390 -44.443  1.00 19.04           C  
ATOM   3042  O   GLU A 390      19.656  15.479 -45.492  1.00 19.45           O  
ATOM   3043  CB  GLU A 390      22.642  14.787 -45.106  1.00 18.95           C  
ATOM   3044  CG  GLU A 390      23.347  15.989 -44.514  1.00 20.41           C  
ATOM   3045  CD  GLU A 390      24.682  16.310 -45.186  1.00 21.52           C  
ATOM   3046  OE1 GLU A 390      25.317  15.414 -45.783  1.00 23.01           O  
ATOM   3047  OE2 GLU A 390      25.102  17.478 -45.102  1.00 23.96           O  
ATOM   3048  N   CYS A 391      20.096  16.172 -43.391  1.00 18.30           N  
ATOM   3049  CA  CYS A 391      19.064  17.208 -43.378  1.00 17.86           C  
ATOM   3050  C   CYS A 391      18.922  17.887 -44.730  1.00 18.76           C  
ATOM   3051  O   CYS A 391      19.910  18.334 -45.344  1.00 18.18           O  
ATOM   3052  CB  CYS A 391      19.344  18.246 -42.292  1.00 17.05           C  
ATOM   3053  SG  CYS A 391      18.306  19.726 -42.379  1.00 15.62           S  
ATOM   3054  N   LEU A 392      17.669  17.957 -45.169  1.00 19.43           N  
ATOM   3055  CA  LEU A 392      17.298  18.522 -46.444  1.00 20.61           C  
ATOM   3056  C   LEU A 392      17.054  20.023 -46.301  1.00 20.71           C  
ATOM   3057  O   LEU A 392      17.121  20.780 -47.275  1.00 21.48           O  
ATOM   3058  CB  LEU A 392      16.019  17.810 -46.867  1.00 21.58           C  
ATOM   3059  CG  LEU A 392      15.367  17.841 -48.230  1.00 22.34           C  
ATOM   3060  CD1 LEU A 392      14.645  16.521 -48.401  1.00 22.58           C  
ATOM   3061  CD2 LEU A 392      14.397  18.962 -48.295  1.00 24.86           C  
ATOM   3062  N   GLY A 393      16.784  20.457 -45.078  1.00 20.31           N  
ATOM   3063  CA  GLY A 393      16.410  21.841 -44.825  1.00 20.53           C  
ATOM   3064  C   GLY A 393      17.489  22.672 -44.171  1.00 20.35           C  
ATOM   3065  O   GLY A 393      17.229  23.778 -43.719  1.00 20.47           O  
ATOM   3066  N   LYS A 394      18.715  22.162 -44.170  1.00 20.96           N  
ATOM   3067  CA  LYS A 394      19.822  22.805 -43.439  1.00 21.45           C  
ATOM   3068  C   LYS A 394      20.057  24.291 -43.756  1.00 21.20           C  
ATOM   3069  O   LYS A 394      20.401  25.062 -42.872  1.00 21.80           O  
ATOM   3070  CB  LYS A 394      21.107  21.983 -43.538  1.00 21.28           C  
ATOM   3071  CG  LYS A 394      21.806  22.012 -44.857  1.00 22.48           C  
ATOM   3072  CD  LYS A 394      22.977  21.029 -44.830  1.00 26.36           C  
ATOM   3073  CE  LYS A 394      23.730  20.980 -46.167  1.00 27.16           C  
ATOM   3074  NZ  LYS A 394      24.592  19.766 -46.224  1.00 28.21           N  
ATOM   3075  N   GLU A 395      19.853  24.688 -45.010  1.00 21.40           N  
ATOM   3076  CA  GLU A 395      20.073  26.086 -45.416  1.00 21.53           C  
ATOM   3077  C   GLU A 395      18.896  27.011 -45.082  1.00 20.36           C  
ATOM   3078  O   GLU A 395      19.098  28.202 -44.852  1.00 21.14           O  
ATOM   3079  CB  GLU A 395      20.479  26.192 -46.898  1.00 21.95           C  
ATOM   3080  CG  GLU A 395      21.724  25.383 -47.277  1.00 24.73           C  
ATOM   3081  CD  GLU A 395      23.000  25.857 -46.586  1.00 29.06           C  
ATOM   3082  OE1 GLU A 395      23.215  27.084 -46.471  1.00 32.66           O  
ATOM   3083  OE2 GLU A 395      23.802  24.998 -46.163  1.00 30.89           O  
ATOM   3084  N   PHE A 396      17.679  26.475 -45.063  1.00 19.30           N  
ATOM   3085  CA  PHE A 396      16.569  27.167 -44.423  1.00 19.07           C  
ATOM   3086  C   PHE A 396      16.870  27.460 -42.948  1.00 18.69           C  
ATOM   3087  O   PHE A 396      16.622  28.569 -42.482  1.00 18.49           O  
ATOM   3088  CB  PHE A 396      15.264  26.378 -44.521  1.00 18.93           C  
ATOM   3089  CG  PHE A 396      14.084  27.116 -43.956  1.00 19.41           C  
ATOM   3090  CD1 PHE A 396      13.350  27.991 -44.755  1.00 19.26           C  
ATOM   3091  CD2 PHE A 396      13.753  27.000 -42.611  1.00 17.85           C  
ATOM   3092  CE1 PHE A 396      12.262  28.698 -44.233  1.00 20.97           C  
ATOM   3093  CE2 PHE A 396      12.670  27.702 -42.072  1.00 20.09           C  
ATOM   3094  CZ  PHE A 396      11.921  28.561 -42.883  1.00 19.95           C  
ATOM   3095  N   ALA A 397      17.359  26.446 -42.225  1.00 18.60           N  
ATOM   3096  CA  ALA A 397      17.761  26.584 -40.827  1.00 18.84           C  
ATOM   3097  C   ALA A 397      18.827  27.662 -40.652  1.00 18.96           C  
ATOM   3098  O   ALA A 397      18.701  28.505 -39.757  1.00 18.07           O  
ATOM   3099  CB  ALA A 397      18.273  25.275 -40.293  1.00 18.69           C  
ATOM   3100  N   ARG A 398      19.880  27.612 -41.492  1.00 19.10           N  
ATOM   3101  CA  ARG A 398      21.027  28.531 -41.370  1.00 19.32           C  
ATOM   3102  C   ARG A 398      20.630  29.950 -41.692  1.00 19.86           C  
ATOM   3103  O   ARG A 398      21.093  30.882 -41.024  1.00 20.07           O  
ATOM   3104  CB  ARG A 398      22.214  28.114 -42.250  1.00 19.31           C  
ATOM   3105  CG  ARG A 398      23.068  27.035 -41.634  1.00 18.10           C  
ATOM   3106  CD  ARG A 398      24.057  26.453 -42.636  1.00 18.71           C  
ATOM   3107  NE  ARG A 398      25.012  25.591 -41.954  1.00 20.47           N  
ATOM   3108  CZ  ARG A 398      25.560  24.497 -42.466  1.00 22.35           C  
ATOM   3109  NH1 ARG A 398      25.249  24.093 -43.695  1.00 23.79           N  
ATOM   3110  NH2 ARG A 398      26.421  23.795 -41.736  1.00 23.37           N  
ATOM   3111  N   LEU A 399      19.781  30.099 -42.720  1.00 20.17           N  
ATOM   3112  CA  LEU A 399      19.158  31.376 -43.047  1.00 20.09           C  
ATOM   3113  C   LEU A 399      18.447  32.006 -41.844  1.00 19.90           C  
ATOM   3114  O   LEU A 399      18.734  33.152 -41.493  1.00 19.74           O  
ATOM   3115  CB  LEU A 399      18.145  31.222 -44.192  1.00 20.51           C  
ATOM   3116  CG  LEU A 399      17.439  32.511 -44.618  1.00 21.32           C  
ATOM   3117  CD1 LEU A 399      18.402  33.409 -45.370  1.00 24.12           C  
ATOM   3118  CD2 LEU A 399      16.231  32.200 -45.485  1.00 23.60           C  
ATOM   3119  N   GLU A 400      17.537  31.254 -41.220  1.00 19.26           N  
ATOM   3120  CA  GLU A 400      16.743  31.788 -40.113  1.00 19.73           C  
ATOM   3121  C   GLU A 400      17.600  32.086 -38.879  1.00 19.31           C  
ATOM   3122  O   GLU A 400      17.364  33.064 -38.188  1.00 19.75           O  
ATOM   3123  CB  GLU A 400      15.578  30.853 -39.748  1.00 19.58           C  
ATOM   3124  CG  GLU A 400      14.565  31.498 -38.799  1.00 20.54           C  
ATOM   3125  CD  GLU A 400      13.328  30.665 -38.512  1.00 20.91           C  
ATOM   3126  OE1 GLU A 400      12.913  29.834 -39.361  1.00 24.90           O  
ATOM   3127  OE2 GLU A 400      12.743  30.876 -37.425  1.00 22.95           O  
ATOM   3128  N   MET A 401      18.588  31.240 -38.613  1.00 19.82           N  
ATOM   3129  CA  MET A 401      19.523  31.459 -37.514  1.00 19.91           C  
ATOM   3130  C   MET A 401      20.334  32.738 -37.745  1.00 20.67           C  
ATOM   3131  O   MET A 401      20.515  33.550 -36.834  1.00 20.91           O  
ATOM   3132  CB  MET A 401      20.449  30.252 -37.370  1.00 19.72           C  
ATOM   3133  CG  MET A 401      19.797  29.015 -36.765  1.00 18.85           C  
ATOM   3134  SD  MET A 401      20.960  27.669 -36.475  1.00 20.64           S  
ATOM   3135  CE  MET A 401      21.036  26.913 -38.102  1.00 22.04           C  
ATOM   3136  N   LYS A 402      20.810  32.926 -38.975  1.00 21.26           N  
ATOM   3137  CA  LYS A 402      21.662  34.075 -39.294  1.00 21.35           C  
ATOM   3138  C   LYS A 402      20.882  35.377 -39.245  1.00 21.24           C  
ATOM   3139  O   LYS A 402      21.303  36.313 -38.598  1.00 21.43           O  
ATOM   3140  CB  LYS A 402      22.338  33.900 -40.649  1.00 21.34           C  
ATOM   3141  CG  LYS A 402      23.794  34.294 -40.642  1.00 22.86           C  
ATOM   3142  CD  LYS A 402      24.348  34.516 -42.036  1.00 23.33           C  
ATOM   3143  CE  LYS A 402      24.845  33.239 -42.667  1.00 24.59           C  
ATOM   3144  NZ  LYS A 402      26.018  33.506 -43.567  1.00 23.06           N  
ATOM   3145  N   LEU A 403      19.732  35.430 -39.908  1.00 21.78           N  
ATOM   3146  CA  LEU A 403      18.856  36.612 -39.825  1.00 21.79           C  
ATOM   3147  C   LEU A 403      18.489  36.976 -38.389  1.00 21.45           C  
ATOM   3148  O   LEU A 403      18.618  38.132 -38.007  1.00 21.58           O  
ATOM   3149  CB  LEU A 403      17.593  36.427 -40.678  1.00 21.82           C  
ATOM   3150  CG  LEU A 403      16.578  37.551 -40.956  1.00 22.20           C  
ATOM   3151  CD1 LEU A 403      17.187  38.930 -41.180  1.00 22.70           C  
ATOM   3152  CD2 LEU A 403      15.761  37.175 -42.164  1.00 21.78           C  
ATOM   3153  N   PHE A 404      18.042  35.993 -37.604  1.00 21.32           N  
ATOM   3154  CA  PHE A 404      17.636  36.238 -36.212  1.00 21.66           C  
ATOM   3155  C   PHE A 404      18.804  36.741 -35.362  1.00 21.60           C  
ATOM   3156  O   PHE A 404      18.666  37.691 -34.602  1.00 21.91           O  
ATOM   3157  CB  PHE A 404      17.066  34.968 -35.569  1.00 21.33           C  
ATOM   3158  CG  PHE A 404      16.708  35.135 -34.125  1.00 20.66           C  
ATOM   3159  CD1 PHE A 404      15.452  35.600 -33.761  1.00 22.91           C  
ATOM   3160  CD2 PHE A 404      17.624  34.837 -33.128  1.00 20.38           C  
ATOM   3161  CE1 PHE A 404      15.108  35.759 -32.413  1.00 22.06           C  
ATOM   3162  CE2 PHE A 404      17.296  34.989 -31.779  1.00 21.09           C  
ATOM   3163  CZ  PHE A 404      16.032  35.448 -31.421  1.00 21.27           C  
ATOM   3164  N   ALA A 405      19.938  36.063 -35.488  1.00 21.49           N  
ATOM   3165  CA  ALA A 405      21.147  36.422 -34.783  1.00 21.83           C  
ATOM   3166  C   ALA A 405      21.495  37.876 -35.096  1.00 22.08           C  
ATOM   3167  O   ALA A 405      21.834  38.647 -34.186  1.00 22.21           O  
ATOM   3168  CB  ALA A 405      22.278  35.500 -35.199  1.00 20.89           C  
ATOM   3169  N   THR A 406      21.365  38.233 -36.373  1.00 21.74           N  
ATOM   3170  CA  THR A 406      21.726  39.551 -36.874  1.00 22.44           C  
ATOM   3171  C   THR A 406      20.809  40.636 -36.326  1.00 22.78           C  
ATOM   3172  O   THR A 406      21.273  41.602 -35.743  1.00 23.33           O  
ATOM   3173  CB  THR A 406      21.777  39.572 -38.436  1.00 22.48           C  
ATOM   3174  OG1 THR A 406      22.869  38.765 -38.893  1.00 20.45           O  
ATOM   3175  CG2 THR A 406      21.953  40.993 -38.970  1.00 22.92           C  
ATOM   3176  N   ARG A 407      19.506  40.470 -36.505  1.00 23.61           N  
ATOM   3177  CA  ARG A 407      18.542  41.458 -36.005  1.00 24.04           C  
ATOM   3178  C   ARG A 407      18.519  41.611 -34.491  1.00 24.58           C  
ATOM   3179  O   ARG A 407      18.277  42.711 -33.984  1.00 25.20           O  
ATOM   3180  CB  ARG A 407      17.141  41.161 -36.517  1.00 23.84           C  
ATOM   3181  CG  ARG A 407      16.974  41.375 -37.998  1.00 22.85           C  
ATOM   3182  CD  ARG A 407      17.326  42.789 -38.406  1.00 24.69           C  
ATOM   3183  NE  ARG A 407      16.721  43.109 -39.690  1.00 25.98           N  
ATOM   3184  CZ  ARG A 407      17.018  44.167 -40.438  1.00 26.89           C  
ATOM   3185  NH1 ARG A 407      17.952  45.027 -40.045  1.00 26.71           N  
ATOM   3186  NH2 ARG A 407      16.384  44.344 -41.599  1.00 25.70           N  
ATOM   3187  N   LEU A 408      18.758  40.516 -33.771  1.00 24.85           N  
ATOM   3188  CA  LEU A 408      18.758  40.552 -32.317  1.00 24.97           C  
ATOM   3189  C   LEU A 408      19.978  41.299 -31.782  1.00 25.45           C  
ATOM   3190  O   LEU A 408      19.850  42.150 -30.903  1.00 24.98           O  
ATOM   3191  CB  LEU A 408      18.687  39.141 -31.725  1.00 24.72           C  
ATOM   3192  CG  LEU A 408      18.823  39.042 -30.194  1.00 24.72           C  
ATOM   3193  CD1 LEU A 408      17.693  39.749 -29.460  1.00 22.86           C  
ATOM   3194  CD2 LEU A 408      18.951  37.587 -29.735  1.00 23.63           C  
ATOM   3195  N   ILE A 409      21.153  40.986 -32.317  1.00 26.13           N  
ATOM   3196  CA  ILE A 409      22.381  41.625 -31.849  1.00 26.97           C  
ATOM   3197  C   ILE A 409      22.486  43.104 -32.267  1.00 27.87           C  
ATOM   3198  O   ILE A 409      22.968  43.936 -31.499  1.00 28.03           O  
ATOM   3199  CB  ILE A 409      23.642  40.780 -32.196  1.00 27.12           C  
ATOM   3200  CG1 ILE A 409      23.697  39.567 -31.263  1.00 26.35           C  
ATOM   3201  CG2 ILE A 409      24.931  41.615 -32.057  1.00 27.77           C  
ATOM   3202  CD1 ILE A 409      24.811  38.577 -31.540  1.00 26.48           C  
ATOM   3203  N   GLN A 410      22.020  43.439 -33.472  1.00 28.84           N  
ATOM   3204  CA  GLN A 410      22.059  44.843 -33.918  1.00 29.47           C  
ATOM   3205  C   GLN A 410      21.181  45.774 -33.069  1.00 29.33           C  
ATOM   3206  O   GLN A 410      21.519  46.945 -32.867  1.00 29.84           O  
ATOM   3207  CB  GLN A 410      21.772  44.984 -35.423  1.00 29.52           C  
ATOM   3208  CG  GLN A 410      20.310  44.948 -35.823  1.00 30.43           C  
ATOM   3209  CD  GLN A 410      20.059  45.446 -37.239  1.00 30.40           C  
ATOM   3210  OE1 GLN A 410      19.728  44.665 -38.130  1.00 32.03           O  
ATOM   3211  NE2 GLN A 410      20.208  46.751 -37.453  1.00 32.19           N  
ATOM   3212  N   GLN A 411      20.078  45.245 -32.551  1.00 29.32           N  
ATOM   3213  CA  GLN A 411      19.126  46.048 -31.777  1.00 29.20           C  
ATOM   3214  C   GLN A 411      19.235  45.918 -30.254  1.00 28.47           C  
ATOM   3215  O   GLN A 411      18.920  46.869 -29.532  1.00 28.80           O  
ATOM   3216  CB  GLN A 411      17.697  45.706 -32.197  1.00 29.64           C  
ATOM   3217  CG  GLN A 411      17.393  46.004 -33.640  1.00 31.52           C  
ATOM   3218  CD  GLN A 411      16.099  45.380 -34.070  1.00 35.00           C  
ATOM   3219  OE1 GLN A 411      15.037  45.657 -33.497  1.00 36.79           O  
ATOM   3220  NE2 GLN A 411      16.169  44.524 -35.084  1.00 34.09           N  
ATOM   3221  N   PHE A 412      19.642  44.750 -29.756  1.00 27.27           N  
ATOM   3222  CA  PHE A 412      19.611  44.519 -28.306  1.00 26.08           C  
ATOM   3223  C   PHE A 412      20.850  43.860 -27.714  1.00 25.10           C  
ATOM   3224  O   PHE A 412      21.504  43.031 -28.353  1.00 24.56           O  
ATOM   3225  CB  PHE A 412      18.417  43.642 -27.913  1.00 26.52           C  
ATOM   3226  CG  PHE A 412      17.070  44.230 -28.245  1.00 27.59           C  
ATOM   3227  CD1 PHE A 412      16.422  45.068 -27.347  1.00 27.61           C  
ATOM   3228  CD2 PHE A 412      16.426  43.899 -29.449  1.00 27.94           C  
ATOM   3229  CE1 PHE A 412      15.148  45.595 -27.650  1.00 28.70           C  
ATOM   3230  CE2 PHE A 412      15.165  44.417 -29.759  1.00 28.29           C  
ATOM   3231  CZ  PHE A 412      14.524  45.267 -28.861  1.00 27.38           C  
ATOM   3232  N   ASP A 413      21.149  44.242 -26.474  1.00 23.55           N  
ATOM   3233  CA  ASP A 413      21.847  43.373 -25.549  1.00 22.55           C  
ATOM   3234  C   ASP A 413      20.783  42.683 -24.717  1.00 21.94           C  
ATOM   3235  O   ASP A 413      19.631  43.134 -24.672  1.00 21.60           O  
ATOM   3236  CB  ASP A 413      22.767  44.163 -24.623  1.00 22.62           C  
ATOM   3237  CG  ASP A 413      24.067  44.547 -25.290  1.00 23.10           C  
ATOM   3238  OD1 ASP A 413      24.519  43.807 -26.193  1.00 23.14           O  
ATOM   3239  OD2 ASP A 413      24.637  45.587 -24.904  1.00 23.71           O  
ATOM   3240  N   TRP A 414      21.163  41.595 -24.061  1.00 21.04           N  
ATOM   3241  CA  TRP A 414      20.251  40.928 -23.144  1.00 20.57           C  
ATOM   3242  C   TRP A 414      20.942  40.267 -21.963  1.00 20.77           C  
ATOM   3243  O   TRP A 414      22.140  39.916 -22.009  1.00 20.61           O  
ATOM   3244  CB  TRP A 414      19.315  39.960 -23.888  1.00 19.33           C  
ATOM   3245  CG  TRP A 414      19.977  38.764 -24.529  1.00 18.29           C  
ATOM   3246  CD1 TRP A 414      19.991  37.484 -24.045  1.00 14.59           C  
ATOM   3247  CD2 TRP A 414      20.693  38.728 -25.774  1.00 16.23           C  
ATOM   3248  NE1 TRP A 414      20.661  36.661 -24.902  1.00 13.35           N  
ATOM   3249  CE2 TRP A 414      21.119  37.398 -25.967  1.00 16.12           C  
ATOM   3250  CE3 TRP A 414      21.017  39.691 -26.744  1.00 18.11           C  
ATOM   3251  CZ2 TRP A 414      21.851  36.998 -27.096  1.00 16.79           C  
ATOM   3252  CZ3 TRP A 414      21.744  39.297 -27.865  1.00 16.42           C  
ATOM   3253  CH2 TRP A 414      22.153  37.961 -28.029  1.00 17.48           C  
ATOM   3254  N   THR A 415      20.166  40.118 -20.900  1.00 21.08           N  
ATOM   3255  CA  THR A 415      20.631  39.543 -19.662  1.00 21.57           C  
ATOM   3256  C   THR A 415      19.771  38.354 -19.305  1.00 21.77           C  
ATOM   3257  O   THR A 415      18.540  38.448 -19.280  1.00 21.17           O  
ATOM   3258  CB  THR A 415      20.554  40.578 -18.508  1.00 21.79           C  
ATOM   3259  OG1 THR A 415      21.100  41.823 -18.948  1.00 23.88           O  
ATOM   3260  CG2 THR A 415      21.317  40.112 -17.287  1.00 21.31           C  
ATOM   3261  N   LEU A 416      20.441  37.245 -19.015  1.00 22.60           N  
ATOM   3262  CA  LEU A 416      19.809  36.055 -18.469  1.00 23.83           C  
ATOM   3263  C   LEU A 416      19.610  36.230 -16.967  1.00 24.64           C  
ATOM   3264  O   LEU A 416      20.571  36.211 -16.205  1.00 24.96           O  
ATOM   3265  CB  LEU A 416      20.673  34.814 -18.740  1.00 23.86           C  
ATOM   3266  CG  LEU A 416      21.142  34.491 -20.175  1.00 24.12           C  
ATOM   3267  CD1 LEU A 416      21.948  33.217 -20.173  1.00 24.31           C  
ATOM   3268  CD2 LEU A 416      19.989  34.338 -21.141  1.00 23.92           C  
ATOM   3269  N   LEU A 417      18.359  36.376 -16.545  1.00 25.35           N  
ATOM   3270  CA  LEU A 417      18.038  36.673 -15.146  1.00 25.62           C  
ATOM   3271  C   LEU A 417      18.662  35.702 -14.149  1.00 25.84           C  
ATOM   3272  O   LEU A 417      18.742  34.492 -14.411  1.00 25.26           O  
ATOM   3273  CB  LEU A 417      16.521  36.797 -14.935  1.00 26.04           C  
ATOM   3274  CG  LEU A 417      15.852  37.900 -15.765  1.00 26.16           C  
ATOM   3275  CD1 LEU A 417      14.422  38.115 -15.319  1.00 25.34           C  
ATOM   3276  CD2 LEU A 417      16.643  39.211 -15.693  1.00 25.31           C  
ATOM   3277  N   PRO A 418      19.170  36.243 -13.026  1.00 26.24           N  
ATOM   3278  CA  PRO A 418      19.781  35.421 -11.987  1.00 26.64           C  
ATOM   3279  C   PRO A 418      18.764  34.508 -11.324  1.00 26.85           C  
ATOM   3280  O   PRO A 418      17.554  34.795 -11.341  1.00 26.88           O  
ATOM   3281  CB  PRO A 418      20.340  36.452 -10.998  1.00 26.74           C  
ATOM   3282  CG  PRO A 418      20.492  37.711 -11.808  1.00 26.73           C  
ATOM   3283  CD  PRO A 418      19.278  37.676 -12.709  1.00 26.61           C  
ATOM   3284  N   GLY A 419      19.259  33.396 -10.787  1.00 26.83           N  
ATOM   3285  CA  GLY A 419      18.407  32.392 -10.175  1.00 27.26           C  
ATOM   3286  C   GLY A 419      17.325  31.891 -11.116  1.00 27.14           C  
ATOM   3287  O   GLY A 419      16.145  32.141 -10.885  1.00 28.56           O  
ATOM   3288  N   GLN A 420      17.732  31.239 -12.201  1.00 26.22           N  
ATOM   3289  CA  GLN A 420      16.844  30.357 -12.972  1.00 25.10           C  
ATOM   3290  C   GLN A 420      17.589  29.067 -13.252  1.00 24.58           C  
ATOM   3291  O   GLN A 420      18.806  29.005 -13.103  1.00 24.15           O  
ATOM   3292  CB  GLN A 420      16.374  31.008 -14.268  1.00 24.62           C  
ATOM   3293  CG  GLN A 420      17.494  31.427 -15.224  1.00 23.95           C  
ATOM   3294  CD  GLN A 420      16.944  32.059 -16.472  1.00 23.03           C  
ATOM   3295  OE1 GLN A 420      16.264  31.398 -17.273  1.00 22.67           O  
ATOM   3296  NE2 GLN A 420      17.219  33.345 -16.653  1.00 22.04           N  
ATOM   3297  N   ASN A 421      16.856  28.024 -13.610  1.00 24.16           N  
ATOM   3298  CA  ASN A 421      17.460  26.783 -14.078  1.00 24.32           C  
ATOM   3299  C   ASN A 421      17.711  26.841 -15.594  1.00 24.33           C  
ATOM   3300  O   ASN A 421      16.764  26.886 -16.379  1.00 24.66           O  
ATOM   3301  CB  ASN A 421      16.552  25.594 -13.728  1.00 24.42           C  
ATOM   3302  CG  ASN A 421      17.288  24.301 -13.719  1.00 23.44           C  
ATOM   3303  OD1 ASN A 421      18.436  24.237 -14.127  1.00 23.46           O  
ATOM   3304  ND2 ASN A 421      16.645  23.257 -13.244  1.00 24.42           N  
ATOM   3305  N   LEU A 422      18.985  26.875 -15.987  1.00 24.87           N  
ATOM   3306  CA  LEU A 422      19.396  26.920 -17.398  1.00 24.73           C  
ATOM   3307  C   LEU A 422      19.704  25.509 -17.885  1.00 24.88           C  
ATOM   3308  O   LEU A 422      20.140  25.303 -19.018  1.00 24.40           O  
ATOM   3309  CB  LEU A 422      20.625  27.813 -17.579  1.00 24.91           C  
ATOM   3310  CG  LEU A 422      20.500  29.308 -17.278  1.00 25.56           C  
ATOM   3311  CD1 LEU A 422      21.874  30.015 -17.263  1.00 26.60           C  
ATOM   3312  CD2 LEU A 422      19.550  29.987 -18.269  1.00 26.51           C  
ATOM   3313  N   GLU A 423      19.465  24.539 -17.014  1.00 25.13           N  
ATOM   3314  CA  GLU A 423      19.686  23.129 -17.323  1.00 25.88           C  
ATOM   3315  C   GLU A 423      18.802  22.676 -18.483  1.00 25.30           C  
ATOM   3316  O   GLU A 423      17.643  23.088 -18.595  1.00 25.29           O  
ATOM   3317  CB  GLU A 423      19.394  22.284 -16.088  1.00 26.26           C  
ATOM   3318  CG  GLU A 423      20.200  21.006 -15.995  1.00 29.91           C  
ATOM   3319  CD  GLU A 423      21.623  21.250 -15.525  1.00 33.25           C  
ATOM   3320  OE1 GLU A 423      21.995  22.441 -15.371  1.00 34.36           O  
ATOM   3321  OE2 GLU A 423      22.363  20.256 -15.313  1.00 32.98           O  
ATOM   3322  N   LEU A 424      19.348  21.811 -19.331  1.00 24.96           N  
ATOM   3323  CA  LEU A 424      18.717  21.483 -20.603  1.00 24.06           C  
ATOM   3324  C   LEU A 424      17.923  20.183 -20.548  1.00 23.53           C  
ATOM   3325  O   LEU A 424      18.448  19.129 -20.167  1.00 23.65           O  
ATOM   3326  CB  LEU A 424      19.765  21.433 -21.730  1.00 24.23           C  
ATOM   3327  CG  LEU A 424      20.539  22.707 -22.107  1.00 24.41           C  
ATOM   3328  CD1 LEU A 424      21.687  22.369 -23.071  1.00 25.32           C  
ATOM   3329  CD2 LEU A 424      19.634  23.785 -22.690  1.00 21.66           C  
ATOM   3330  N   VAL A 425      16.647  20.265 -20.910  1.00 22.62           N  
ATOM   3331  CA  VAL A 425      15.807  19.074 -21.062  1.00 22.62           C  
ATOM   3332  C   VAL A 425      15.529  18.858 -22.539  1.00 22.53           C  
ATOM   3333  O   VAL A 425      15.577  19.806 -23.312  1.00 22.02           O  
ATOM   3334  CB  VAL A 425      14.474  19.157 -20.248  1.00 22.45           C  
ATOM   3335  CG1 VAL A 425      14.762  19.015 -18.744  1.00 22.85           C  
ATOM   3336  CG2 VAL A 425      13.759  20.443 -20.505  1.00 21.81           C  
ATOM   3337  N   VAL A 426      15.264  17.610 -22.917  1.00 22.95           N  
ATOM   3338  CA  VAL A 426      15.113  17.216 -24.317  1.00 23.57           C  
ATOM   3339  C   VAL A 426      13.792  16.454 -24.567  1.00 24.07           C  
ATOM   3340  O   VAL A 426      13.767  15.222 -24.549  1.00 24.92           O  
ATOM   3341  CB  VAL A 426      16.345  16.383 -24.811  1.00 23.21           C  
ATOM   3342  CG1 VAL A 426      16.307  16.203 -26.296  1.00 22.31           C  
ATOM   3343  CG2 VAL A 426      17.688  17.041 -24.414  1.00 23.26           C  
ATOM   3344  N   THR A 427      12.704  17.188 -24.805  1.00 24.25           N  
ATOM   3345  CA  THR A 427      11.398  16.561 -25.107  1.00 24.67           C  
ATOM   3346  C   THR A 427      10.676  17.137 -26.352  1.00 23.95           C  
ATOM   3347  O   THR A 427       9.625  17.785 -26.229  1.00 24.60           O  
ATOM   3348  CB  THR A 427      10.413  16.659 -23.913  1.00 24.54           C  
ATOM   3349  OG1 THR A 427      10.202  18.046 -23.598  1.00 23.85           O  
ATOM   3350  CG2 THR A 427      10.936  15.907 -22.677  1.00 25.16           C  
ATOM   3351  N   PRO A 428      11.186  16.854 -27.554  1.00 22.94           N  
ATOM   3352  CA  PRO A 428      12.314  16.023 -27.910  1.00 22.05           C  
ATOM   3353  C   PRO A 428      13.585  16.777 -28.358  1.00 21.29           C  
ATOM   3354  O   PRO A 428      14.477  16.147 -28.932  1.00 20.52           O  
ATOM   3355  CB  PRO A 428      11.742  15.237 -29.085  1.00 22.51           C  
ATOM   3356  CG  PRO A 428      10.830  16.235 -29.785  1.00 22.32           C  
ATOM   3357  CD  PRO A 428      10.493  17.329 -28.763  1.00 22.98           C  
ATOM   3358  N   SER A 429      13.659  18.086 -28.086  1.00 20.19           N  
ATOM   3359  CA  SER A 429      14.810  18.951 -28.419  1.00 19.71           C  
ATOM   3360  C   SER A 429      15.325  19.703 -27.198  1.00 18.64           C  
ATOM   3361  O   SER A 429      14.531  20.066 -26.338  1.00 18.46           O  
ATOM   3362  CB  SER A 429      14.390  20.001 -29.454  1.00 19.51           C  
ATOM   3363  OG  SER A 429      14.726  19.587 -30.752  1.00 22.69           O  
ATOM   3364  N   PRO A 430      16.649  19.975 -27.126  1.00 18.40           N  
ATOM   3365  CA  PRO A 430      17.159  20.764 -25.986  1.00 17.83           C  
ATOM   3366  C   PRO A 430      16.426  22.085 -25.735  1.00 17.86           C  
ATOM   3367  O   PRO A 430      16.235  22.870 -26.649  1.00 17.70           O  
ATOM   3368  CB  PRO A 430      18.631  21.010 -26.351  1.00 17.66           C  
ATOM   3369  CG  PRO A 430      18.992  19.896 -27.247  1.00 18.21           C  
ATOM   3370  CD  PRO A 430      17.742  19.568 -28.035  1.00 18.15           C  
ATOM   3371  N   ARG A 431      16.010  22.305 -24.483  1.00 18.60           N  
ATOM   3372  CA  ARG A 431      15.433  23.582 -24.025  1.00 18.90           C  
ATOM   3373  C   ARG A 431      15.884  23.815 -22.585  1.00 18.60           C  
ATOM   3374  O   ARG A 431      16.064  22.854 -21.846  1.00 18.36           O  
ATOM   3375  CB  ARG A 431      13.894  23.580 -24.124  1.00 18.35           C  
ATOM   3376  CG  ARG A 431      13.191  22.464 -23.342  1.00 18.63           C  
ATOM   3377  CD  ARG A 431      11.695  22.288 -23.677  1.00 20.73           C  
ATOM   3378  NE  ARG A 431      11.208  21.033 -23.067  1.00 23.34           N  
ATOM   3379  CZ  ARG A 431      10.545  20.969 -21.907  1.00 25.53           C  
ATOM   3380  NH1 ARG A 431      10.241  22.095 -21.256  1.00 25.93           N  
ATOM   3381  NH2 ARG A 431      10.168  19.788 -21.404  1.00 23.71           N  
ATOM   3382  N   PRO A 432      16.091  25.089 -22.181  1.00 18.90           N  
ATOM   3383  CA  PRO A 432      16.392  25.366 -20.771  1.00 18.97           C  
ATOM   3384  C   PRO A 432      15.162  25.109 -19.874  1.00 19.57           C  
ATOM   3385  O   PRO A 432      14.050  25.512 -20.229  1.00 18.85           O  
ATOM   3386  CB  PRO A 432      16.768  26.852 -20.778  1.00 18.82           C  
ATOM   3387  CG  PRO A 432      16.047  27.408 -21.951  1.00 19.45           C  
ATOM   3388  CD  PRO A 432      16.052  26.320 -22.990  1.00 19.01           C  
ATOM   3389  N   LYS A 433      15.361  24.432 -18.747  1.00 20.57           N  
ATOM   3390  CA  LYS A 433      14.242  24.043 -17.866  1.00 22.98           C  
ATOM   3391  C   LYS A 433      13.307  25.201 -17.472  1.00 22.93           C  
ATOM   3392  O   LYS A 433      12.080  25.062 -17.565  1.00 22.96           O  
ATOM   3393  CB  LYS A 433      14.725  23.270 -16.634  1.00 23.02           C  
ATOM   3394  CG  LYS A 433      13.652  22.337 -16.027  1.00 25.00           C  
ATOM   3395  CD  LYS A 433      14.175  21.522 -14.861  1.00 25.71           C  
ATOM   3396  CE  LYS A 433      15.407  20.679 -15.257  1.00 30.57           C  
ATOM   3397  NZ  LYS A 433      15.996  19.925 -14.104  1.00 32.99           N  
ATOM   3398  N   ASP A 434      13.882  26.341 -17.082  1.00 22.77           N  
ATOM   3399  CA  ASP A 434      13.097  27.523 -16.706  1.00 22.95           C  
ATOM   3400  C   ASP A 434      12.743  28.477 -17.836  1.00 22.60           C  
ATOM   3401  O   ASP A 434      12.483  29.655 -17.589  1.00 22.59           O  
ATOM   3402  CB  ASP A 434      13.752  28.298 -15.547  1.00 23.73           C  
ATOM   3403  CG  ASP A 434      13.544  27.615 -14.201  1.00 25.19           C  
ATOM   3404  OD1 ASP A 434      12.802  26.611 -14.144  1.00 27.00           O  
ATOM   3405  OD2 ASP A 434      14.139  28.066 -13.201  1.00 25.98           O  
ATOM   3406  N   ASN A 435      12.717  27.958 -19.067  1.00 22.22           N  
ATOM   3407  CA  ASN A 435      12.207  28.669 -20.257  1.00 21.98           C  
ATOM   3408  C   ASN A 435      12.876  29.996 -20.639  1.00 21.80           C  
ATOM   3409  O   ASN A 435      12.275  30.815 -21.331  1.00 21.38           O  
ATOM   3410  CB  ASN A 435      10.693  28.864 -20.194  1.00 21.98           C  
ATOM   3411  CG  ASN A 435       9.938  27.559 -20.025  1.00 22.90           C  
ATOM   3412  OD1 ASN A 435       9.908  26.721 -20.924  1.00 22.87           O  
ATOM   3413  ND2 ASN A 435       9.316  27.388 -18.864  1.00 24.25           N  
ATOM   3414  N   LEU A 436      14.107  30.191 -20.175  1.00 22.20           N  
ATOM   3415  CA  LEU A 436      14.975  31.293 -20.605  1.00 22.49           C  
ATOM   3416  C   LEU A 436      14.423  32.667 -20.270  1.00 23.17           C  
ATOM   3417  O   LEU A 436      13.905  33.381 -21.140  1.00 23.13           O  
ATOM   3418  CB  LEU A 436      15.279  31.200 -22.102  1.00 22.30           C  
ATOM   3419  CG  LEU A 436      16.712  31.093 -22.633  1.00 21.81           C  
ATOM   3420  CD1 LEU A 436      16.793  31.799 -23.976  1.00 22.44           C  
ATOM   3421  CD2 LEU A 436      17.811  31.556 -21.669  1.00 22.14           C  
ATOM   3422  N   ARG A 437      14.553  33.050 -19.003  1.00 24.08           N  
ATOM   3423  CA  ARG A 437      14.061  34.339 -18.543  1.00 25.12           C  
ATOM   3424  C   ARG A 437      15.122  35.388 -18.812  1.00 24.79           C  
ATOM   3425  O   ARG A 437      16.262  35.250 -18.369  1.00 24.56           O  
ATOM   3426  CB  ARG A 437      13.722  34.285 -17.054  1.00 25.41           C  
ATOM   3427  CG  ARG A 437      12.698  33.219 -16.710  1.00 26.52           C  
ATOM   3428  CD  ARG A 437      12.358  33.195 -15.218  1.00 27.42           C  
ATOM   3429  NE  ARG A 437      11.171  32.367 -14.998  1.00 33.52           N  
ATOM   3430  CZ  ARG A 437       9.920  32.786 -15.192  1.00 35.77           C  
ATOM   3431  NH1 ARG A 437       9.688  34.031 -15.592  1.00 37.38           N  
ATOM   3432  NH2 ARG A 437       8.898  31.960 -14.984  1.00 38.42           N  
ATOM   3433  N   VAL A 438      14.738  36.426 -19.546  1.00 25.36           N  
ATOM   3434  CA  VAL A 438      15.660  37.481 -19.996  1.00 26.00           C  
ATOM   3435  C   VAL A 438      15.064  38.878 -19.826  1.00 26.77           C  
ATOM   3436  O   VAL A 438      13.863  39.022 -19.631  1.00 26.85           O  
ATOM   3437  CB  VAL A 438      16.045  37.301 -21.491  1.00 25.69           C  
ATOM   3438  CG1 VAL A 438      16.752  35.968 -21.710  1.00 24.45           C  
ATOM   3439  CG2 VAL A 438      14.803  37.435 -22.404  1.00 25.60           C  
ATOM   3440  N   LYS A 439      15.921  39.894 -19.860  1.00 27.83           N  
ATOM   3441  CA  LYS A 439      15.507  41.263 -20.131  1.00 29.15           C  
ATOM   3442  C   LYS A 439      16.322  41.687 -21.330  1.00 29.49           C  
ATOM   3443  O   LYS A 439      17.534  41.455 -21.356  1.00 29.22           O  
ATOM   3444  CB  LYS A 439      15.818  42.188 -18.947  1.00 29.35           C  
ATOM   3445  CG  LYS A 439      14.656  42.355 -17.974  1.00 32.30           C  
ATOM   3446  CD  LYS A 439      15.133  42.797 -16.600  1.00 35.44           C  
ATOM   3447  CE  LYS A 439      14.070  42.522 -15.538  1.00 36.96           C  
ATOM   3448  NZ  LYS A 439      14.654  42.661 -14.181  1.00 38.60           N  
ATOM   3449  N   LEU A 440      15.667  42.274 -22.328  1.00 30.10           N  
ATOM   3450  CA  LEU A 440      16.383  42.868 -23.452  1.00 31.17           C  
ATOM   3451  C   LEU A 440      16.640  44.350 -23.171  1.00 32.06           C  
ATOM   3452  O   LEU A 440      15.770  45.056 -22.656  1.00 32.17           O  
ATOM   3453  CB  LEU A 440      15.615  42.694 -24.773  1.00 30.90           C  
ATOM   3454  CG  LEU A 440      15.130  41.319 -25.276  1.00 30.60           C  
ATOM   3455  CD1 LEU A 440      14.760  41.406 -26.760  1.00 29.48           C  
ATOM   3456  CD2 LEU A 440      16.116  40.187 -25.059  1.00 29.03           C  
ATOM   3457  N   HIS A 441      17.837  44.819 -23.495  1.00 33.25           N  
ATOM   3458  CA  HIS A 441      18.136  46.241 -23.391  1.00 33.96           C  
ATOM   3459  C   HIS A 441      18.367  46.776 -24.791  1.00 34.62           C  
ATOM   3460  O   HIS A 441      19.263  46.306 -25.498  1.00 34.57           O  
ATOM   3461  CB  HIS A 441      19.375  46.500 -22.527  1.00 34.06           C  
ATOM   3462  CG  HIS A 441      19.704  45.395 -21.574  1.00 34.81           C  
ATOM   3463  ND1 HIS A 441      20.864  44.655 -21.674  1.00 36.14           N  
ATOM   3464  CD2 HIS A 441      19.038  44.909 -20.498  1.00 35.44           C  
ATOM   3465  CE1 HIS A 441      20.891  43.752 -20.710  1.00 35.91           C  
ATOM   3466  NE2 HIS A 441      19.794  43.882 -19.985  1.00 35.48           N  
ATOM   3467  N   SER A 442      17.559  47.762 -25.182  1.00 35.59           N  
ATOM   3468  CA  SER A 442      17.635  48.389 -26.509  1.00 36.16           C  
ATOM   3469  C   SER A 442      18.905  49.213 -26.721  1.00 36.39           C  
ATOM   3470  O   SER A 442      19.382  49.898 -25.805  1.00 36.25           O  
ATOM   3471  CB  SER A 442      16.399  49.265 -26.760  1.00 36.17           C  
ATOM   3472  OG  SER A 442      16.447  49.862 -28.049  1.00 37.19           O  
ATOM   3473  N   LEU A 443      19.429  49.152 -27.945  1.00 36.69           N  
ATOM   3474  CA  LEU A 443      20.626  49.900 -28.335  1.00 36.80           C  
ATOM   3475  C   LEU A 443      20.276  51.068 -29.253  1.00 37.29           C  
ATOM   3476  O   LEU A 443      21.167  51.713 -29.817  1.00 37.96           O  
ATOM   3477  CB  LEU A 443      21.629  48.979 -29.034  1.00 36.39           C  
ATOM   3478  CG  LEU A 443      22.408  47.954 -28.213  1.00 35.58           C  
ATOM   3479  CD1 LEU A 443      22.894  46.852 -29.118  1.00 33.49           C  
ATOM   3480  CD2 LEU A 443      23.567  48.615 -27.493  1.00 35.16           C  
TER    3481      LEU A 443                                                      
END
MOLECULE T0431.pdb
ATOM      1  N   SER     7      13.105 -14.959 -26.399  1.00 67.88           N
ATOM      2  CA  SER     7      14.074 -13.905 -25.987  1.00 67.36           C
ATOM      4  CB  SER     7      14.330 -13.962 -24.478  1.00 66.92           C
ATOM      8  C   SER     7      15.378 -14.088 -26.758  1.00 66.07           C
ATOM      9  O   SER     7      15.742 -15.210 -27.119  1.00 66.86           O
ATOM     13  N   ARG     8      16.071 -12.978 -27.008  1.00 63.72           N
ATOM     14  CA  ARG     8      17.282 -12.968 -27.850  1.00 59.66           C
ATOM     16  CB  ARG     8      17.334 -11.689 -28.697  1.00 57.81           C
ATOM     19  CG  ARG     8      18.696 -11.385 -29.304  1.00 56.21           C
ATOM     22  CD  ARG     8      18.576 -10.483 -30.479  1.00 53.14           C
ATOM     25  NE  ARG     8      19.868  -9.993 -30.915  1.00 50.83           N
ATOM     27  CZ  ARG     8      20.057  -9.287 -32.023  1.00 50.53           C
ATOM     28  NH1 ARG     8      21.283  -8.877 -32.343  1.00 52.15           N
ATOM     31  NH2 ARG     8      19.032  -8.984 -32.816  1.00 48.76           N
ATOM     34  C   ARG     8      18.539 -13.090 -27.014  1.00 57.01           C
ATOM     35  O   ARG     8      18.644 -12.512 -25.948  1.00 54.68           O
ATOM     37  N   ARG     9      19.502 -13.838 -27.527  1.00 57.45           N
ATOM     38  CA  ARG     9      20.713 -14.121 -26.803  1.00 57.60           C
ATOM     40  CB  ARG     9      20.785 -15.614 -26.463  1.00 59.18           C
ATOM     49  C   ARG     9      21.883 -13.718 -27.664  1.00 58.29           C
ATOM     50  O   ARG     9      21.855 -13.882 -28.889  1.00 58.21           O
ATOM     52  N   ARG    10      22.912 -13.177 -27.026  1.00 56.49           N
ATOM     53  CA  ARG    10      24.111 -12.773 -27.724  1.00 54.65           C
ATOM     55  CB  ARG    10      25.051 -12.037 -26.758  1.00 54.16           C
ATOM     58  CG  ARG    10      26.375 -11.633 -27.366  1.00 52.82           C
ATOM     61  CD  ARG    10      27.361 -11.242 -26.319  1.00 52.34           C
ATOM     64  NE  ARG    10      28.538 -10.635 -26.926  1.00 51.42           N
ATOM     66  CZ  ARG    10      29.620 -10.237 -26.257  1.00 50.68           C
ATOM     67  NH1 ARG    10      29.706 -10.383 -24.939  1.00 50.74           N
ATOM     70  NH2 ARG    10      30.633  -9.689 -26.919  1.00 51.24           N
ATOM     73  C   ARG    10      24.811 -14.007 -28.314  1.00 55.72           C
ATOM     74  O   ARG    10      25.243 -14.884 -27.586  1.00 52.72           O
ATOM     76  N   GLN    11      24.929 -14.046 -29.634  1.00 58.30           N
ATOM     77  CA  GLN    11      25.647 -15.115 -30.328  1.00 59.84           C
ATOM     79  CB  GLN    11      24.947 -15.422 -31.644  1.00 60.40           C
ATOM     82  CG  GLN    11      23.607 -16.095 -31.437  1.00 62.50           C
ATOM     85  CD  GLN    11      22.834 -16.257 -32.729  1.00 65.71           C
ATOM     86  OE1 GLN    11      23.354 -15.981 -33.824  1.00 66.87           O
ATOM     87  NE2 GLN    11      21.571 -16.701 -32.617  1.00 66.41           N
ATOM     90  C   GLN    11      27.139 -14.763 -30.551  1.00 61.43           C
ATOM     91  O   GLN    11      27.605 -13.678 -30.147  1.00 59.98           O
ATOM     93  N   THR    12      27.883 -15.685 -31.178  1.00 61.36           N
ATOM     94  CA  THR    12      29.317 -15.483 -31.444  1.00 60.32           C
ATOM     96  CB  THR    12      30.010 -16.807 -31.930  1.00 61.48           C
ATOM     98  OG1 THR    12      31.429 -16.706 -31.729  1.00 61.42           O
ATOM    100  CG2 THR    12      29.714 -17.096 -33.422  1.00 60.45           C
ATOM    104  C   THR    12      29.599 -14.335 -32.448  1.00 58.39           C
ATOM    105  O   THR    12      29.002 -14.270 -33.536  1.00 58.95           O
ATOM    107  N   GLY    13      30.510 -13.436 -32.065  1.00 56.82           N
ATOM    108  CA  GLY    13      30.871 -12.256 -32.886  1.00 54.75           C
ATOM    111  C   GLY    13      29.946 -11.047 -32.731  1.00 51.72           C
ATOM    112  O   GLY    13      30.237  -9.958 -33.243  1.00 49.54           O
ATOM    114  N   GLU    14      28.835 -11.229 -32.023  1.00 48.74           N
ATOM    115  CA  GLU    14      27.888 -10.141 -31.811  1.00 46.39           C
ATOM    117  CB  GLU    14      26.492 -10.687 -31.513  1.00 44.69           C
ATOM    120  CG  GLU    14      25.952 -11.535 -32.634  1.00 45.55           C
ATOM    123  CD  GLU    14      24.482 -11.732 -32.541  1.00 46.13           C
ATOM    124  OE1 GLU    14      24.000 -12.090 -31.443  1.00 46.55           O
ATOM    125  OE2 GLU    14      23.803 -11.527 -33.561  1.00 47.16           O
ATOM    126  C   GLU    14      28.380  -9.244 -30.678  1.00 45.33           C
ATOM    127  O   GLU    14      29.139  -9.693 -29.817  1.00 44.27           O
ATOM    129  N   PRO    15      27.987  -7.954 -30.698  1.00 42.61           N
ATOM    130  CA  PRO    15      28.373  -7.058 -29.609  1.00 40.34           C
ATOM    132  CB  PRO    15      27.769  -5.704 -30.041  1.00 37.44           C
ATOM    135  CG  PRO    15      27.580  -5.804 -31.485  1.00 36.68           C
ATOM    138  CD  PRO    15      27.234  -7.235 -31.747  1.00 40.34           C
ATOM    141  C   PRO    15      27.834  -7.471 -28.230  1.00 38.91           C
ATOM    142  O   PRO    15      26.912  -8.274 -28.137  1.00 41.72           O
ATOM    143  N   PRO    16      28.407  -6.914 -27.163  1.00 36.99           N
ATOM    144  CA  PRO    16      27.783  -7.093 -25.869  1.00 38.36           C
ATOM    146  CB  PRO    16      28.594  -6.186 -24.952  1.00 37.94           C
ATOM    149  CG  PRO    16      29.875  -5.977 -25.642  1.00 38.48           C
ATOM    152  CD  PRO    16      29.629  -6.108 -27.095  1.00 38.33           C
ATOM    155  C   PRO    16      26.302  -6.647 -25.887  1.00 38.74           C
ATOM    156  O   PRO    16      25.973  -5.599 -26.455  1.00 36.85           O
ATOM    157  N   LEU    17      25.443  -7.436 -25.264  1.00 39.59           N
ATOM    158  CA  LEU    17      24.014  -7.200 -25.282  1.00 42.06           C
ATOM    160  CB  LEU    17      23.280  -8.473 -25.721  1.00 43.46           C
ATOM    163  CG  LEU    17      21.740  -8.489 -25.771  1.00 43.39           C
ATOM    165  CD1 LEU    17      21.181  -7.396 -26.712  1.00 41.86           C
ATOM    169  CD2 LEU    17      21.244  -9.904 -26.189  1.00 42.26           C
ATOM    173  C   LEU    17      23.565  -6.770 -23.905  1.00 43.91           C
ATOM    174  O   LEU    17      23.640  -7.536 -22.955  1.00 45.10           O
ATOM    176  N   GLU    18      23.129  -5.521 -23.795  1.00 48.67           N
ATOM    177  CA  GLU    18      22.542  -5.020 -22.560  1.00 52.29           C
ATOM    179  CB  GLU    18      22.716  -3.491 -22.478  1.00 55.39           C
ATOM    182  CG  GLU    18      22.750  -2.870 -21.059  1.00 59.78           C
ATOM    185  CD  GLU    18      23.791  -3.522 -20.102  1.00 62.16           C
ATOM    186  OE1 GLU    18      23.484  -4.604 -19.538  1.00 63.18           O
ATOM    187  OE2 GLU    18      24.883  -2.933 -19.884  1.00 62.39           O
ATOM    188  C   GLU    18      21.057  -5.459 -22.554  1.00 52.44           C
ATOM    189  O   GLU    18      20.259  -5.050 -23.416  1.00 51.84           O
ATOM    191  N   ASN    19      20.709  -6.351 -21.630  1.00 54.19           N
ATOM    192  CA  ASN    19      19.300  -6.706 -21.413  1.00 55.75           C
ATOM    194  CB  ASN    19      19.139  -8.049 -20.660  1.00 57.62           C
ATOM    200  C   ASN    19      18.639  -5.553 -20.643  1.00 53.43           C
ATOM    201  O   ASN    19      19.326  -4.757 -19.945  1.00 53.85           O
ATOM    203  N   GLY    20      17.324  -5.458 -20.788  1.00 48.36           N
ATOM    204  CA  GLY    20      16.570  -4.343 -20.271  1.00 44.73           C
ATOM    207  C   GLY    20      15.881  -3.643 -21.407  1.00 39.93           C
ATOM    208  O   GLY    20      16.479  -3.399 -22.453  1.00 38.65           O
ATOM    210  N   LEU    21      14.618  -3.300 -21.197  1.00 37.42           N
ATOM    211  CA  LEU    21      13.829  -2.675 -22.223  1.00 36.88           C
ATOM    213  CB  LEU    21      12.365  -3.146 -22.142  1.00 42.76           C
ATOM    216  CG  LEU    21      12.149  -4.684 -22.095  1.00 46.29           C
ATOM    218  CD1 LEU    21      10.758  -5.077 -21.483  1.00 50.48           C
ATOM    222  CD2 LEU    21      12.315  -5.300 -23.459  1.00 48.86           C
ATOM    226  C   LEU    21      13.955  -1.169 -22.040  1.00 33.54           C
ATOM    227  O   LEU    21      13.782  -0.676 -20.947  1.00 32.12           O
ATOM    229  N   ILE    22      14.308  -0.458 -23.115  1.00 28.08           N
ATOM    230  CA  ILE    22      14.336   0.981 -23.107  1.00 29.92           C
ATOM    232  CB  ILE    22      15.766   1.554 -23.471  1.00 30.79           C
ATOM    234  CG1 ILE    22      16.842   0.988 -22.515  1.00 33.50           C
ATOM    237  CD1 ILE    22      18.227   1.036 -23.078  1.00 34.21           C
ATOM    241  CG2 ILE    22      15.763   3.103 -23.434  1.00 25.43           C
ATOM    245  C   ILE    22      13.300   1.419 -24.121  1.00 26.48           C
ATOM    246  O   ILE    22      13.524   1.339 -25.313  1.00 29.67           O
ATOM    248  N   PRO    23      12.118   1.806 -23.657  1.00 29.43           N
ATOM    249  CA  PRO    23      11.057   2.221 -24.588  1.00 25.73           C
ATOM    251  CB  PRO    23       9.955   2.711 -23.646  1.00 26.67           C
ATOM    254  CG  PRO    23      10.157   1.974 -22.436  1.00 27.15           C
ATOM    257  CD  PRO    23      11.648   1.828 -22.269  1.00 26.45           C
ATOM    260  C   PRO    23      11.485   3.304 -25.558  1.00 27.23           C
ATOM    261  O   PRO    23      11.246   3.208 -26.762  1.00 25.10           O
ATOM    262  N   TYR    24      12.129   4.329 -25.021  1.00 30.91           N
ATOM    263  CA  TYR    24      12.756   5.371 -25.807  1.00 28.99           C
ATOM    265  CB  TYR    24      11.716   6.326 -26.431  1.00 30.20           C
ATOM    268  CG  TYR    24      10.796   7.004 -25.417  1.00 31.76           C
ATOM    269  CD1 TYR    24      11.043   8.293 -24.972  1.00 27.87           C
ATOM    271  CE1 TYR    24      10.204   8.905 -24.042  1.00 30.76           C
ATOM    273  CZ  TYR    24       9.089   8.226 -23.576  1.00 31.76           C
ATOM    274  OH  TYR    24       8.229   8.807 -22.652  1.00 37.14           O
ATOM    276  CE2 TYR    24       8.815   6.956 -24.019  1.00 30.90           C
ATOM    278  CD2 TYR    24       9.664   6.355 -24.938  1.00 32.19           C
ATOM    280  C   TYR    24      13.751   6.120 -24.903  1.00 29.20           C
ATOM    281  O   TYR    24      13.667   6.058 -23.641  1.00 25.01           O
ATOM    283  N   LEU    25      14.693   6.816 -25.535  1.00 27.94           N
ATOM    284  CA  LEU    25      15.868   7.368 -24.823  1.00 26.91           C
ATOM    286  CB  LEU    25      16.840   8.049 -25.784  1.00 28.13           C
ATOM    289  CG  LEU    25      17.772   7.163 -26.591  1.00 30.27           C
ATOM    291  CD1 LEU    25      18.684   8.016 -27.513  1.00 31.05           C
ATOM    295  CD2 LEU    25      18.603   6.260 -25.669  1.00 28.05           C
ATOM    299  C   LEU    25      15.497   8.309 -23.729  1.00 27.20           C
ATOM    300  O   LEU    25      16.072   8.240 -22.671  1.00 32.58           O
ATOM    302  N   GLY    26      14.506   9.167 -23.957  1.00 27.40           N
ATOM    303  CA  GLY    26      14.056  10.111 -22.902  1.00 30.29           C
ATOM    306  C   GLY    26      13.054   9.582 -21.875  1.00 30.50           C
ATOM    307  O   GLY    26      12.527  10.354 -21.038  1.00 33.60           O
ATOM    309  N   CYS    27      12.799   8.284 -21.920  1.00 31.38           N
ATOM    310  CA  CYS    27      11.912   7.623 -20.966  1.00 33.34           C
ATOM    312  CB  CYS    27      11.680   6.167 -21.411  1.00 36.80           C
ATOM    315  SG  CYS    27      10.391   5.281 -20.517  1.00 45.15           S
ATOM    317  C   CYS    27      12.450   7.620 -19.517  1.00 33.87           C
ATOM    318  O   CYS    27      13.670   7.444 -19.248  1.00 32.94           O
ATOM    320  N   ALA    28      11.538   7.814 -18.583  1.00 29.48           N
ATOM    321  CA  ALA    28      11.846   7.676 -17.193  1.00 29.55           C
ATOM    323  CB  ALA    28      12.500   6.290 -16.933  1.00 26.98           C
ATOM    327  C   ALA    28      12.731   8.822 -16.690  1.00 29.77           C
ATOM    328  O   ALA    28      13.359   8.718 -15.662  1.00 28.86           O
ATOM    330  N   LEU    29      12.739   9.927 -17.422  1.00 30.18           N
ATOM    331  CA  LEU    29      13.412  11.130 -16.986  1.00 33.24           C
ATOM    333  CB  LEU    29      13.151  12.275 -17.983  1.00 34.55           C
ATOM    336  CG  LEU    29      14.347  13.189 -18.194  1.00 35.77           C
ATOM    338  CD1 LEU    29      15.388  12.469 -19.045  1.00 34.39           C
ATOM    342  CD2 LEU    29      13.899  14.530 -18.803  1.00 34.61           C
ATOM    346  C   LEU    29      12.929  11.527 -15.616  1.00 32.77           C
ATOM    347  O   LEU    29      13.727  11.886 -14.747  1.00 32.70           O
ATOM    349  N   GLN    30      11.616  11.435 -15.420  1.00 36.47           N
ATOM    350  CA  GLN    30      10.990  11.722 -14.106  1.00 39.12           C
ATOM    352  CB  GLN    30       9.434  11.672 -14.179  1.00 43.04           C
ATOM    355  CG  GLN    30       8.772  10.316 -14.664  1.00 45.22           C
ATOM    358  CD  GLN    30       7.191  10.360 -14.644  1.00 47.16           C
ATOM    359  OE1 GLN    30       6.583  11.381 -14.227  1.00 48.13           O
ATOM    360  NE2 GLN    30       6.535   9.246 -15.108  1.00 46.63           N
ATOM    363  C   GLN    30      11.513  10.849 -12.957  1.00 34.82           C
ATOM    364  O   GLN    30      11.416  11.236 -11.823  1.00 34.08           O
ATOM    366  N   PHE    31      12.098   9.694 -13.261  1.00 32.96           N
ATOM    367  CA  PHE    31      12.691   8.837 -12.227  1.00 34.92           C
ATOM    369  CB  PHE    31      12.404   7.367 -12.552  1.00 34.64           C
ATOM    372  CG  PHE    31      10.943   7.035 -12.628  1.00 34.29           C
ATOM    373  CD1 PHE    31      10.489   6.118 -13.532  1.00 35.45           C
ATOM    375  CE1 PHE    31       9.142   5.805 -13.598  1.00 36.22           C
ATOM    377  CZ  PHE    31       8.246   6.403 -12.745  1.00 33.97           C
ATOM    379  CE2 PHE    31       8.677   7.309 -11.842  1.00 35.20           C
ATOM    381  CD2 PHE    31      10.019   7.636 -11.779  1.00 35.17           C
ATOM    383  C   PHE    31      14.198   9.028 -12.049  1.00 33.77           C
ATOM    384  O   PHE    31      14.829   8.296 -11.282  1.00 41.43           O
ATOM    386  N   GLY    32      14.767   9.990 -12.759  1.00 33.28           N
ATOM    387  CA  GLY    32      16.205  10.265 -12.718  1.00 33.66           C
ATOM    390  C   GLY    32      17.005   9.644 -13.860  1.00 34.17           C
ATOM    391  O   GLY    32      18.231   9.602 -13.795  1.00 33.77           O
ATOM    393  N   ALA    33      16.329   9.152 -14.910  1.00 32.98           N
ATOM    394  CA  ALA    33      17.065   8.670 -16.104  1.00 32.58           C
ATOM    396  CB  ALA    33      16.124   8.055 -17.139  1.00 31.94           C
ATOM    400  C   ALA    33      17.893   9.808 -16.729  1.00 31.77           C
ATOM    401  O   ALA    33      17.559  10.982 -16.598  1.00 30.39           O
ATOM    403  N   ASN    34      19.017   9.436 -17.344  1.00 34.35           N
ATOM    404  CA  ASN    34      19.891  10.381 -18.033  1.00 34.12           C
ATOM    406  CB  ASN    34      20.996  10.874 -17.113  1.00 33.87           C
ATOM    409  CG  ASN    34      21.838  11.976 -17.750  1.00 34.89           C
ATOM    410  OD1 ASN    34      22.194  11.927 -18.943  1.00 28.27           O
ATOM    411  ND2 ASN    34      22.163  12.972 -16.957  1.00 37.74           N
ATOM    414  C   ASN    34      20.494   9.664 -19.247  1.00 33.48           C
ATOM    415  O   ASN    34      21.473   8.935 -19.104  1.00 28.82           O
ATOM    417  N   PRO    35      19.879   9.840 -20.430  1.00 29.75           N
ATOM    418  CA  PRO    35      20.270   9.115 -21.625  1.00 30.08           C
ATOM    420  CB  PRO    35      19.354   9.711 -22.723  1.00 29.81           C
ATOM    423  CG  PRO    35      18.311  10.370 -22.052  1.00 29.30           C
ATOM    426  CD  PRO    35      18.723  10.721 -20.682  1.00 31.37           C
ATOM    429  C   PRO    35      21.765   9.221 -22.033  1.00 27.64           C
ATOM    430  O   PRO    35      22.345   8.219 -22.383  1.00 24.67           O
ATOM    431  N   LEU    36      22.343  10.428 -22.003  1.00 27.04           N
ATOM    432  CA  LEU    36      23.755  10.630 -22.309  1.00 26.49           C
ATOM    434  CB  LEU    36      24.162  12.109 -22.140  1.00 28.11           C
ATOM    437  CG  LEU    36      25.613  12.464 -22.578  1.00 27.05           C
ATOM    439  CD1 LEU    36      25.774  12.100 -24.022  1.00 28.08           C
ATOM    443  CD2 LEU    36      25.936  13.954 -22.372  1.00 28.08           C
ATOM    447  C   LEU    36      24.623   9.798 -21.379  1.00 28.26           C
ATOM    448  O   LEU    36      25.480   9.026 -21.833  1.00 26.43           O
ATOM    450  N   GLU    37      24.404   9.972 -20.080  1.00 27.85           N
ATOM    451  CA  GLU    37      25.190   9.280 -19.076  1.00 29.58           C
ATOM    453  CB  GLU    37      24.940   9.843 -17.676  1.00 31.72           C
ATOM    456  CG  GLU    37      25.419  11.320 -17.538  1.00 35.62           C
ATOM    459  CD  GLU    37      26.944  11.488 -17.786  1.00 38.79           C
ATOM    460  OE1 GLU    37      27.735  10.645 -17.292  1.00 42.74           O
ATOM    461  OE2 GLU    37      27.328  12.449 -18.483  1.00 40.05           O
ATOM    462  C   GLU    37      24.958   7.814 -19.108  1.00 29.72           C
ATOM    463  O   GLU    37      25.846   7.057 -18.761  1.00 31.40           O
ATOM    465  N   PHE    38      23.768   7.404 -19.548  1.00 26.99           N
ATOM    466  CA  PHE    38      23.453   6.008 -19.716  1.00 25.71           C
ATOM    468  CB  PHE    38      21.917   5.815 -19.984  1.00 29.74           C
ATOM    471  CG  PHE    38      21.537   4.393 -20.325  1.00 27.24           C
ATOM    472  CD1 PHE    38      21.514   3.432 -19.355  1.00 29.45           C
ATOM    474  CE1 PHE    38      21.187   2.085 -19.664  1.00 31.30           C
ATOM    476  CZ  PHE    38      20.896   1.736 -20.944  1.00 31.28           C
ATOM    478  CE2 PHE    38      20.923   2.717 -21.952  1.00 32.25           C
ATOM    480  CD2 PHE    38      21.243   4.031 -21.628  1.00 30.72           C
ATOM    482  C   PHE    38      24.289   5.402 -20.825  1.00 25.30           C
ATOM    483  O   PHE    38      24.806   4.295 -20.691  1.00 24.36           O
ATOM    485  N   LEU    39      24.382   6.124 -21.942  1.00 26.48           N
ATOM    486  CA  LEU    39      25.180   5.697 -23.083  1.00 26.74           C
ATOM    488  CB  LEU    39      24.863   6.578 -24.305  1.00 27.03           C
ATOM    491  CG  LEU    39      23.474   6.297 -24.994  1.00 24.85           C
ATOM    493  CD1 LEU    39      23.265   7.182 -26.195  1.00 23.30           C
ATOM    497  CD2 LEU    39      23.310   4.825 -25.420  1.00 24.66           C
ATOM    501  C   LEU    39      26.709   5.683 -22.736  1.00 27.64           C
ATOM    502  O   LEU    39      27.414   4.762 -23.080  1.00 23.59           O
ATOM    504  N   ARG    40      27.170   6.706 -22.032  1.00 28.32           N
ATOM    505  CA  ARG    40      28.523   6.740 -21.493  1.00 31.62           C
ATOM    507  CB  ARG    40      28.762   8.045 -20.738  1.00 30.41           C
ATOM    510  CG  ARG    40      29.055   9.145 -21.678  1.00 30.12           C
ATOM    513  CD  ARG    40      28.951  10.525 -21.058  1.00 33.52           C
ATOM    516  NE  ARG    40      29.609  11.490 -21.933  1.00 34.37           N
ATOM    518  CZ  ARG    40      29.684  12.799 -21.722  1.00 37.32           C
ATOM    519  NH1 ARG    40      29.106  13.357 -20.668  1.00 36.73           N
ATOM    522  NH2 ARG    40      30.338  13.561 -22.590  1.00 38.24           N
ATOM    525  C   ARG    40      28.803   5.522 -20.601  1.00 34.44           C
ATOM    526  O   ARG    40      29.791   4.816 -20.826  1.00 34.52           O
ATOM    528  N   ALA    41      27.911   5.251 -19.637  1.00 30.15           N
ATOM    529  CA  ALA    41      28.095   4.137 -18.725  1.00 30.44           C
ATOM    531  CB  ALA    41      26.991   4.087 -17.710  1.00 29.24           C
ATOM    535  C   ALA    41      28.214   2.799 -19.463  1.00 32.73           C
ATOM    536  O   ALA    41      29.001   1.936 -19.058  1.00 32.93           O
ATOM    538  N   ASN    42      27.476   2.634 -20.559  1.00 29.83           N
ATOM    539  CA  ASN    42      27.635   1.426 -21.392  1.00 31.19           C
ATOM    541  CB  ASN    42      26.484   1.302 -22.375  1.00 30.82           C
ATOM    544  CG  ASN    42      25.200   0.810 -21.702  1.00 34.13           C
ATOM    545  OD1 ASN    42      25.037  -0.383 -21.475  1.00 34.53           O
ATOM    546  ND2 ASN    42      24.300   1.749 -21.362  1.00 31.74           N
ATOM    549  C   ASN    42      28.969   1.388 -22.153  1.00 30.34           C
ATOM    550  O   ASN    42      29.473   0.337 -22.457  1.00 29.41           O
ATOM    552  N   GLN    43      29.492   2.552 -22.475  1.00 31.33           N
ATOM    553  CA  GLN    43      30.778   2.665 -23.129  1.00 38.01           C
ATOM    555  CB  GLN    43      31.058   4.127 -23.484  1.00 40.47           C
ATOM    558  CG  GLN    43      31.258   4.371 -24.916  1.00 44.51           C
ATOM    561  CD  GLN    43      31.362   5.865 -25.253  1.00 45.97           C
ATOM    562  OE1 GLN    43      30.973   6.755 -24.451  1.00 46.44           O
ATOM    563  NE2 GLN    43      31.900   6.150 -26.446  1.00 48.11           N
ATOM    566  C   GLN    43      31.855   2.157 -22.191  1.00 35.96           C
ATOM    567  O   GLN    43      32.779   1.464 -22.617  1.00 36.25           O
ATOM    569  N   ARG    44      31.731   2.520 -20.917  1.00 35.55           N
ATOM    570  CA  ARG    44      32.709   2.154 -19.923  1.00 37.89           C
ATOM    572  CB  ARG    44      32.533   2.998 -18.670  1.00 38.27           C
ATOM    575  CG  ARG    44      32.947   4.421 -18.895  1.00 38.96           C
ATOM    578  CD  ARG    44      33.122   5.142 -17.633  1.00 41.41           C
ATOM    581  NE  ARG    44      31.869   5.267 -16.895  1.00 44.48           N
ATOM    583  CZ  ARG    44      31.001   6.286 -17.000  1.00 45.07           C
ATOM    584  NH1 ARG    44      29.908   6.279 -16.270  1.00 44.64           N
ATOM    587  NH2 ARG    44      31.214   7.303 -17.816  1.00 45.55           N
ATOM    590  C   ARG    44      32.609   0.676 -19.624  1.00 39.77           C
ATOM    591  O   ARG    44      33.631  -0.019 -19.582  1.00 42.78           O
ATOM    593  N   LYS    45      31.382   0.190 -19.462  1.00 37.92           N
ATOM    594  CA  LYS    45      31.121  -1.239 -19.229  1.00 38.47           C
ATOM    596  CB  LYS    45      29.629  -1.509 -18.933  1.00 39.45           C
ATOM    599  CG  LYS    45      29.147  -1.144 -17.538  1.00 44.94           C
ATOM    602  CD  LYS    45      28.024  -2.129 -17.057  1.00 44.96           C
ATOM    607  C   LYS    45      31.498  -2.131 -20.378  1.00 32.99           C
ATOM    608  O   LYS    45      32.033  -3.199 -20.161  1.00 34.83           O
ATOM    610  N   HIS    46      31.153  -1.736 -21.597  1.00 33.68           N
ATOM    611  CA  HIS    46      31.209  -2.652 -22.746  1.00 33.96           C
ATOM    613  CB  HIS    46      29.828  -2.771 -23.381  1.00 38.22           C
ATOM    616  CG  HIS    46      28.786  -3.324 -22.468  1.00 42.75           C
ATOM    617  ND1 HIS    46      28.809  -4.629 -22.016  1.00 44.79           N
ATOM    619  CE1 HIS    46      27.763  -4.837 -21.232  1.00 44.38           C
ATOM    621  NE2 HIS    46      27.058  -3.724 -21.174  1.00 43.62           N
ATOM    623  CD2 HIS    46      27.679  -2.759 -21.931  1.00 44.51           C
ATOM    625  C   HIS    46      32.185  -2.229 -23.838  1.00 32.98           C
ATOM    626  O   HIS    46      32.386  -2.965 -24.800  1.00 33.48           O
ATOM    628  N   GLY    47      32.748  -1.037 -23.733  1.00 29.78           N
ATOM    629  CA  GLY    47      33.495  -0.478 -24.846  1.00 33.77           C
ATOM    632  C   GLY    47      32.606   0.190 -25.906  1.00 35.87           C
ATOM    633  O   GLY    47      31.423   0.502 -25.672  1.00 37.63           O
ATOM    635  N   HIS    48      33.176   0.385 -27.078  1.00 35.71           N
ATOM    636  CA  HIS    48      32.653   1.353 -28.022  1.00 38.40           C
ATOM    638  CB  HIS    48      33.777   1.873 -28.920  1.00 39.41           C
ATOM    641  CG  HIS    48      34.630   2.922 -28.276  1.00 40.21           C
ATOM    642  ND1 HIS    48      34.108   4.085 -27.745  1.00 40.45           N
ATOM    644  CE1 HIS    48      35.088   4.820 -27.252  1.00 39.99           C
ATOM    646  NE2 HIS    48      36.226   4.183 -27.458  1.00 41.15           N
ATOM    648  CD2 HIS    48      35.969   2.999 -28.106  1.00 38.75           C
ATOM    650  C   HIS    48      31.491   0.856 -28.877  1.00 36.94           C
ATOM    651  O   HIS    48      30.899   1.642 -29.583  1.00 35.81           O
ATOM    653  N   VAL    49      31.211  -0.444 -28.823  1.00 35.30           N
ATOM    654  CA  VAL    49      30.095  -1.047 -29.537  1.00 37.14           C
ATOM    656  CB  VAL    49      30.577  -1.877 -30.751  1.00 35.91           C
ATOM    658  CG1 VAL    49      29.402  -2.262 -31.625  1.00 35.26           C
ATOM    662  CG2 VAL    49      31.574  -1.091 -31.543  1.00 36.59           C
ATOM    666  C   VAL    49      29.270  -1.935 -28.570  1.00 35.55           C
ATOM    667  O   VAL    49      29.780  -2.892 -27.995  1.00 35.06           O
ATOM    669  N   PHE    50      28.005  -1.574 -28.373  1.00 36.37           N
ATOM    670  CA  PHE    50      27.095  -2.347 -27.520  1.00 34.05           C
ATOM    672  CB  PHE    50      27.146  -1.832 -26.079  1.00 34.01           C
ATOM    675  CG  PHE    50      26.920  -0.339 -25.952  1.00 34.30           C
ATOM    676  CD1 PHE    50      27.999   0.547 -25.965  1.00 33.93           C
ATOM    678  CE1 PHE    50      27.798   1.929 -25.872  1.00 32.98           C
ATOM    680  CZ  PHE    50      26.520   2.435 -25.739  1.00 32.88           C
ATOM    682  CE2 PHE    50      25.413   1.561 -25.718  1.00 33.36           C
ATOM    684  CD2 PHE    50      25.609   0.186 -25.830  1.00 33.35           C
ATOM    686  C   PHE    50      25.667  -2.284 -28.071  1.00 34.45           C
ATOM    687  O   PHE    50      25.328  -1.423 -28.884  1.00 32.43           O
ATOM    689  N   THR    51      24.837  -3.203 -27.625  1.00 35.61           N
ATOM    690  CA  THR    51      23.495  -3.345 -28.171  1.00 35.86           C
ATOM    692  CB  THR    51      23.334  -4.703 -28.853  1.00 36.43           C
ATOM    694  OG1 THR    51      24.383  -4.860 -29.812  1.00 37.09           O
ATOM    696  CG2 THR    51      21.993  -4.815 -29.552  1.00 35.48           C
ATOM    700  C   THR    51      22.487  -3.170 -27.049  1.00 34.00           C
ATOM    701  O   THR    51      22.646  -3.761 -25.985  1.00 28.87           O
ATOM    703  N   CYS    52      21.498  -2.296 -27.295  1.00 34.43           N
ATOM    704  CA  CYS    52      20.353  -2.071 -26.409  1.00 33.82           C
ATOM    706  CB  CYS    52      20.229  -0.577 -26.076  1.00 35.04           C
ATOM    709  SG  CYS    52      21.647   0.124 -25.233  1.00 41.79           S
ATOM    711  C   CYS    52      19.037  -2.518 -27.075  1.00 32.72           C
ATOM    712  O   CYS    52      18.864  -2.413 -28.309  1.00 31.51           O
ATOM    714  N   LYS    53      18.091  -2.975 -26.256  1.00 32.69           N
ATOM    715  CA  LYS    53      16.725  -3.253 -26.737  1.00 29.36           C
ATOM    717  CB  LYS    53      16.049  -4.362 -25.931  1.00 26.05           C
ATOM    724  C   LYS    53      15.998  -1.908 -26.631  1.00 25.21           C
ATOM    725  O   LYS    53      15.475  -1.558 -25.593  1.00 27.90           O
ATOM    727  N   LEU    54      16.027  -1.152 -27.720  1.00 25.78           N
ATOM    728  CA  LEU    54      15.585   0.241 -27.727  1.00 27.35           C
ATOM    730  CB  LEU    54      16.763   1.173 -28.056  1.00 24.55           C
ATOM    733  CG  LEU    54      16.435   2.684 -28.175  1.00 24.67           C
ATOM    735  CD1 LEU    54      15.863   3.171 -26.877  1.00 14.30           C
ATOM    739  CD2 LEU    54      17.677   3.494 -28.570  1.00 25.01           C
ATOM    743  C   LEU    54      14.478   0.432 -28.756  1.00 28.19           C
ATOM    744  O   LEU    54      14.653   0.085 -29.890  1.00 27.40           O
ATOM    746  N   MET    55      13.341   1.001 -28.329  1.00 32.83           N
ATOM    747  CA  MET    55      12.175   1.241 -29.207  1.00 35.85           C
ATOM    749  CB  MET    55      12.487   2.326 -30.223  1.00 37.84           C
ATOM    752  CG  MET    55      12.475   3.687 -29.643  1.00 41.29           C
ATOM    755  SD  MET    55      13.126   4.847 -30.794  1.00 46.06           S
ATOM    756  CE  MET    55      11.875   4.778 -32.063  1.00 52.83           C
ATOM    760  C   MET    55      11.676  -0.027 -29.920  1.00 35.43           C
ATOM    761  O   MET    55      11.364  -0.016 -31.114  1.00 36.58           O
ATOM    763  N   GLY    56      11.620  -1.112 -29.169  1.00 36.47           N
ATOM    764  CA  GLY    56      11.262  -2.406 -29.712  1.00 37.44           C
ATOM    767  C   GLY    56      12.234  -2.959 -30.755  1.00 39.34           C
ATOM    768  O   GLY    56      11.899  -3.908 -31.443  1.00 39.56           O
ATOM    770  N   LYS    57      13.432  -2.370 -30.867  1.00 36.51           N
ATOM    771  CA  LYS    57      14.423  -2.830 -31.800  1.00 35.93           C
ATOM    773  CB  LYS    57      14.793  -1.705 -32.767  1.00 37.63           C
ATOM    776  CG  LYS    57      13.666  -1.187 -33.619  1.00 42.20           C
ATOM    779  CD  LYS    57      13.273  -2.199 -34.699  1.00 45.03           C
ATOM    782  CE  LYS    57      12.277  -1.627 -35.692  1.00 46.87           C
ATOM    785  NZ  LYS    57      11.810  -2.727 -36.623  1.00 49.66           N
ATOM    789  C   LYS    57      15.686  -3.323 -31.066  1.00 36.36           C
ATOM    790  O   LYS    57      15.846  -3.122 -29.880  1.00 34.37           O
ATOM    792  N   TYR    58      16.572  -3.991 -31.791  1.00 36.91           N
ATOM    793  CA  TYR    58      17.930  -4.202 -31.298  1.00 35.39           C
ATOM    795  CB  TYR    58      18.396  -5.636 -31.535  1.00 38.50           C
ATOM    798  CG  TYR    58      17.666  -6.556 -30.613  1.00 41.10           C
ATOM    799  CD1 TYR    58      18.102  -6.747 -29.302  1.00 41.78           C
ATOM    801  CE1 TYR    58      17.386  -7.560 -28.408  1.00 43.04           C
ATOM    803  CZ  TYR    58      16.217  -8.174 -28.834  1.00 42.80           C
ATOM    804  OH  TYR    58      15.510  -8.985 -27.970  1.00 44.15           O
ATOM    806  CE2 TYR    58      15.753  -7.983 -30.122  1.00 43.85           C
ATOM    808  CD2 TYR    58      16.475  -7.161 -31.006  1.00 42.78           C
ATOM    810  C   TYR    58      18.807  -3.168 -31.947  1.00 31.14           C
ATOM    811  O   TYR    58      18.988  -3.170 -33.167  1.00 30.89           O
ATOM    813  N   VAL    59      19.314  -2.262 -31.117  1.00 27.23           N
ATOM    814  CA  VAL    59      20.045  -1.087 -31.576  1.00 25.74           C
ATOM    816  CB  VAL    59      19.435   0.213 -31.029  1.00 26.39           C
ATOM    818  CG1 VAL    59      20.327   1.423 -31.468  1.00 22.26           C
ATOM    822  CG2 VAL    59      17.958   0.369 -31.515  1.00 25.96           C
ATOM    826  C   VAL    59      21.522  -1.137 -31.141  1.00 25.75           C
ATOM    827  O   VAL    59      21.820  -1.076 -29.957  1.00 29.22           O
ATOM    829  N   HIS    60      22.408  -1.272 -32.128  1.00 27.26           N
ATOM    830  CA  HIS    60      23.865  -1.363 -31.930  1.00 26.19           C
ATOM    832  CB  HIS    60      24.519  -2.162 -33.070  1.00 26.16           C
ATOM    835  CG  HIS    60      23.995  -3.549 -33.215  1.00 25.75           C
ATOM    836  ND1 HIS    60      24.184  -4.521 -32.252  1.00 27.73           N
ATOM    838  CE1 HIS    60      23.592  -5.638 -32.642  1.00 27.89           C
ATOM    840  NE2 HIS    60      23.077  -5.440 -33.843  1.00 26.84           N
ATOM    842  CD2 HIS    60      23.313  -4.141 -34.221  1.00 29.60           C
ATOM    844  C   HIS    60      24.393   0.023 -31.981  1.00 22.09           C
ATOM    845  O   HIS    60      24.349   0.661 -33.031  1.00 24.60           O
ATOM    847  N   PHE    61      24.857   0.516 -30.844  1.00 25.62           N
ATOM    848  CA  PHE    61      25.485   1.828 -30.761  1.00 26.88           C
ATOM    850  CB  PHE    61      25.319   2.418 -29.352  1.00 26.82           C
ATOM    853  CG  PHE    61      23.935   2.940 -29.079  1.00 27.11           C
ATOM    854  CD1 PHE    61      22.958   2.120 -28.516  1.00 25.83           C
ATOM    856  CE1 PHE    61      21.640   2.626 -28.288  1.00 28.07           C
ATOM    858  CZ  PHE    61      21.334   3.925 -28.613  1.00 23.57           C
ATOM    860  CE2 PHE    61      22.309   4.743 -29.149  1.00 28.21           C
ATOM    862  CD2 PHE    61      23.604   4.247 -29.392  1.00 26.07           C
ATOM    864  C   PHE    61      26.968   1.731 -31.109  1.00 28.93           C
ATOM    865  O   PHE    61      27.696   0.951 -30.506  1.00 28.83           O
ATOM    867  N   ILE    62      27.392   2.554 -32.076  1.00 32.85           N
ATOM    868  CA  ILE    62      28.796   2.748 -32.444  1.00 32.27           C
ATOM    870  CB  ILE    62      28.962   2.701 -33.984  1.00 34.93           C
ATOM    872  CG1 ILE    62      28.802   1.277 -34.508  1.00 33.06           C
ATOM    875  CD1 ILE    62      27.491   0.728 -34.352  1.00 34.84           C
ATOM    879  CG2 ILE    62      30.335   3.201 -34.416  1.00 35.34           C
ATOM    883  C   ILE    62      29.246   4.123 -31.884  1.00 31.36           C
ATOM    884  O   ILE    62      28.790   5.164 -32.334  1.00 33.85           O
ATOM    886  N   THR    63      30.120   4.109 -30.889  1.00 30.66           N
ATOM    887  CA  THR    63      30.430   5.312 -30.113  1.00 30.89           C
ATOM    889  CB  THR    63      30.109   5.100 -28.614  1.00 31.69           C
ATOM    891  OG1 THR    63      31.034   4.171 -28.027  1.00 29.17           O
ATOM    893  CG2 THR    63      28.614   4.590 -28.417  1.00 28.05           C
ATOM    897  C   THR    63      31.877   5.813 -30.238  1.00 33.52           C
ATOM    898  O   THR    63      32.210   6.868 -29.667  1.00 31.20           O
ATOM    900  N   ASN    64      32.717   5.085 -30.983  1.00 30.51           N
ATOM    901  CA  ASN    64      34.110   5.540 -31.275  1.00 33.41           C
ATOM    903  CB  ASN    64      35.015   4.333 -31.626  1.00 32.89           C
ATOM    906  CG  ASN    64      36.532   4.715 -31.809  1.00 34.17           C
ATOM    907  OD1 ASN    64      36.917   5.900 -31.846  1.00 30.57           O
ATOM    908  ND2 ASN    64      37.374   3.682 -31.943  1.00 31.14           N
ATOM    911  C   ASN    64      34.069   6.513 -32.427  1.00 29.08           C
ATOM    912  O   ASN    64      33.725   6.118 -33.556  1.00 28.89           O
ATOM    914  N   PRO    65      34.395   7.801 -32.168  1.00 28.13           N
ATOM    915  CA  PRO    65      34.394   8.795 -33.275  1.00 30.49           C
ATOM    917  CB  PRO    65      35.070  10.001 -32.668  1.00 29.71           C
ATOM    920  CG  PRO    65      34.825   9.862 -31.187  1.00 31.19           C
ATOM    923  CD  PRO    65      34.744   8.408 -30.878  1.00 27.44           C
ATOM    926  C   PRO    65      35.131   8.353 -34.539  1.00 30.52           C
ATOM    927  O   PRO    65      34.726   8.726 -35.646  1.00 35.11           O
ATOM    928  N   LEU    66      36.186   7.565 -34.370  1.00 31.09           N
ATOM    929  CA  LEU    66      37.021   7.091 -35.485  1.00 34.13           C
ATOM    931  CB  LEU    66      38.375   6.588 -34.951  1.00 36.48           C
ATOM    934  CG  LEU    66      39.235   7.578 -34.171  1.00 38.06           C
ATOM    936  CD1 LEU    66      40.384   6.852 -33.468  1.00 38.14           C
ATOM    940  CD2 LEU    66      39.747   8.652 -35.110  1.00 38.32           C
ATOM    944  C   LEU    66      36.377   5.967 -36.265  1.00 35.55           C
ATOM    945  O   LEU    66      36.866   5.594 -37.323  1.00 35.63           O
ATOM    947  N   SER    67      35.277   5.411 -35.752  1.00 36.94           N
ATOM    948  CA  SER    67      34.535   4.380 -36.487  1.00 35.46           C
ATOM    950  CB  SER    67      34.165   3.239 -35.543  1.00 36.36           C
ATOM    953  OG  SER    67      35.294   2.478 -35.183  1.00 35.50           O
ATOM    955  C   SER    67      33.277   4.945 -37.173  1.00 37.26           C
ATOM    956  O   SER    67      32.591   4.221 -37.903  1.00 35.90           O
ATOM    958  N   TYR    68      32.973   6.226 -36.938  1.00 36.85           N
ATOM    959  CA  TYR    68      31.764   6.866 -37.522  1.00 37.61           C
ATOM    961  CB  TYR    68      31.661   8.375 -37.140  1.00 32.31           C
ATOM    964  CG  TYR    68      31.079   8.702 -35.746  1.00 31.22           C
ATOM    965  CD1 TYR    68      31.169   7.814 -34.707  1.00 29.19           C
ATOM    967  CE1 TYR    68      30.674   8.118 -33.443  1.00 32.19           C
ATOM    969  CZ  TYR    68      30.070   9.344 -33.196  1.00 31.27           C
ATOM    970  OH  TYR    68      29.605   9.580 -31.934  1.00 30.20           O
ATOM    972  CE2 TYR    68      29.953  10.266 -34.197  1.00 28.83           C
ATOM    974  CD2 TYR    68      30.476   9.951 -35.482  1.00 32.00           C
ATOM    976  C   TYR    68      31.740   6.717 -39.041  1.00 39.42           C
ATOM    977  O   TYR    68      30.706   6.377 -39.616  1.00 38.11           O
ATOM    979  N   HIS    69      32.884   6.964 -39.691  1.00 42.81           N
ATOM    980  CA  HIS    69      32.962   6.920 -41.167  1.00 44.87           C
ATOM    982  CB  HIS    69      34.368   7.343 -41.666  1.00 48.68           C
ATOM    985  CG  HIS    69      35.431   6.321 -41.408  1.00 51.54           C
ATOM    986  ND1 HIS    69      35.875   5.447 -42.376  1.00 53.16           N
ATOM    988  CE1 HIS    69      36.794   4.647 -41.861  1.00 54.46           C
ATOM    990  NE2 HIS    69      36.959   4.967 -40.590  1.00 55.40           N
ATOM    992  CD2 HIS    69      36.117   6.012 -40.281  1.00 54.53           C
ATOM    994  C   HIS    69      32.542   5.545 -41.751  1.00 42.55           C
ATOM    995  O   HIS    69      31.999   5.489 -42.834  1.00 43.07           O
ATOM    997  N   LYS    70      32.768   4.455 -41.015  1.00 43.76           N
ATOM    998  CA  LYS    70      32.339   3.103 -41.462  1.00 45.70           C
ATOM   1000  CB  LYS    70      32.975   2.013 -40.577  1.00 46.06           C
ATOM   1003  CG  LYS    70      34.515   1.877 -40.719  1.00 47.28           C
ATOM   1009  C   LYS    70      30.804   2.903 -41.490  1.00 47.69           C
ATOM   1010  O   LYS    70      30.309   1.946 -42.097  1.00 49.05           O
ATOM   1012  N   VAL    71      30.069   3.787 -40.808  1.00 47.60           N
ATOM   1013  CA  VAL    71      28.600   3.702 -40.716  1.00 49.35           C
ATOM   1015  CB  VAL    71      28.113   3.928 -39.231  1.00 49.27           C
ATOM   1017  CG1 VAL    71      26.615   3.993 -39.155  1.00 49.61           C
ATOM   1021  CG2 VAL    71      28.642   2.824 -38.319  1.00 49.40           C
ATOM   1025  C   VAL    71      27.933   4.725 -41.632  1.00 49.20           C
ATOM   1026  O   VAL    71      26.828   4.489 -42.134  1.00 47.76           O
ATOM   1028  N   LEU    72      28.612   5.854 -41.846  1.00 47.94           N
ATOM   1029  CA  LEU    72      28.048   6.985 -42.590  1.00 47.61           C
ATOM   1031  CB  LEU    72      28.621   8.311 -42.067  1.00 42.28           C
ATOM   1034  CG  LEU    72      28.291   8.609 -40.606  1.00 39.02           C
ATOM   1036  CD1 LEU    72      29.009   9.875 -40.112  1.00 31.33           C
ATOM   1040  CD2 LEU    72      26.745   8.722 -40.445  1.00 36.30           C
ATOM   1044  C   LEU    72      28.264   6.884 -44.097  1.00 52.73           C
ATOM   1045  O   LEU    72      27.644   7.631 -44.860  1.00 53.59           O
ATOM   1047  N   CYS    73      29.130   5.969 -44.527  1.00 57.06           N
ATOM   1048  CA  CYS    73      29.296   5.694 -45.949  1.00 62.09           C
ATOM   1050  CB  CYS    73      30.574   4.896 -46.196  1.00 63.52           C
ATOM   1053  SG  CYS    73      30.601   3.345 -45.324  1.00 67.31           S
ATOM   1055  C   CYS    73      28.077   4.926 -46.478  1.00 64.94           C
ATOM   1056  O   CYS    73      27.327   4.308 -45.699  1.00 64.07           O
ATOM   1058  N   HIS    74      27.873   4.985 -47.795  1.00 67.70           N
ATOM   1059  CA  HIS    74      26.727   4.328 -48.419  1.00 71.18           C
ATOM   1061  CB  HIS    74      26.387   4.978 -49.773  1.00 71.83           C
ATOM   1069  C   HIS    74      27.017   2.832 -48.568  1.00 72.24           C
ATOM   1070  O   HIS    74      27.400   2.368 -49.642  1.00 76.38           O
ATOM   1072  N   GLY    75      26.833   2.094 -47.472  1.00 71.67           N
ATOM   1073  CA  GLY    75      27.085   0.653 -47.429  1.00 71.33           C
ATOM   1076  C   GLY    75      26.040  -0.184 -48.154  1.00 70.88           C
ATOM   1077  O   GLY    75      24.910   0.246 -48.354  1.00 69.91           O
ATOM   1079  N   LYS    76      26.428  -1.402 -48.515  1.00 71.63           N
ATOM   1080  CA  LYS    76      25.572  -2.302 -49.295  1.00 72.15           C
ATOM   1082  CB  LYS    76      26.420  -3.398 -49.985  1.00 75.09           C
ATOM   1085  CG  LYS    76      27.676  -2.877 -50.731  1.00 78.04           C
ATOM   1088  CD  LYS    76      27.320  -1.881 -51.871  1.00 80.01           C
ATOM   1091  CE  LYS    76      28.191  -0.618 -51.833  1.00 80.42           C
ATOM   1094  NZ  LYS    76      27.694   0.412 -52.782  1.00 80.79           N
ATOM   1098  C   LYS    76      24.498  -2.963 -48.426  1.00 69.06           C
ATOM   1099  O   LYS    76      23.467  -3.414 -48.947  1.00 67.88           O
ATOM   1101  N   TYR    77      24.748  -3.025 -47.113  1.00 64.85           N
ATOM   1102  CA  TYR    77      23.828  -3.666 -46.165  1.00 62.82           C
ATOM   1104  CB  TYR    77      24.604  -4.611 -45.259  1.00 68.46           C
ATOM   1107  CG  TYR    77      25.222  -5.767 -45.997  1.00 70.89           C
ATOM   1108  CD1 TYR    77      26.595  -5.798 -46.265  1.00 70.99           C
ATOM   1110  CE1 TYR    77      27.163  -6.870 -46.942  1.00 71.55           C
ATOM   1112  CZ  TYR    77      26.353  -7.926 -47.367  1.00 71.61           C
ATOM   1113  OH  TYR    77      26.908  -8.990 -48.042  1.00 72.46           O
ATOM   1115  CE2 TYR    77      24.989  -7.917 -47.117  1.00 72.09           C
ATOM   1117  CD2 TYR    77      24.429  -6.840 -46.438  1.00 71.72           C
ATOM   1119  C   TYR    77      23.050  -2.672 -45.303  1.00 56.15           C
ATOM   1120  O   TYR    77      22.397  -3.064 -44.341  1.00 51.13           O
ATOM   1122  N   PHE    78      23.116  -1.394 -45.664  1.00 51.44           N
ATOM   1123  CA  PHE    78      22.456  -0.337 -44.930  1.00 48.10           C
ATOM   1125  CB  PHE    78      23.371   0.881 -44.801  1.00 45.45           C
ATOM   1128  CG  PHE    78      24.588   0.669 -43.921  1.00 45.35           C
ATOM   1129  CD1 PHE    78      25.706   1.487 -44.077  1.00 45.76           C
ATOM   1131  CE1 PHE    78      26.834   1.329 -43.263  1.00 45.56           C
ATOM   1133  CZ  PHE    78      26.849   0.343 -42.283  1.00 44.95           C
ATOM   1135  CE2 PHE    78      25.739  -0.469 -42.107  1.00 45.99           C
ATOM   1137  CD2 PHE    78      24.615  -0.310 -42.916  1.00 44.92           C
ATOM   1139  C   PHE    78      21.191   0.091 -45.640  1.00 47.91           C
ATOM   1140  O   PHE    78      21.221   0.407 -46.829  1.00 48.19           O
ATOM   1142  N   ASP    79      20.077   0.089 -44.908  1.00 46.33           N
ATOM   1143  CA  ASP    79      18.836   0.724 -45.356  1.00 44.66           C
ATOM   1145  CB  ASP    79      17.658  -0.229 -45.124  1.00 45.95           C
ATOM   1148  CG  ASP    79      16.363   0.237 -45.794  1.00 46.44           C
ATOM   1149  OD1 ASP    79      16.090   1.463 -45.834  1.00 45.55           O
ATOM   1150  OD2 ASP    79      15.623  -0.640 -46.280  1.00 46.96           O
ATOM   1151  C   ASP    79      18.675   2.025 -44.539  1.00 45.89           C
ATOM   1152  O   ASP    79      18.435   1.980 -43.345  1.00 40.04           O
ATOM   1154  N   TRP    80      18.828   3.181 -45.184  1.00 50.10           N
ATOM   1155  CA  TRP    80      18.801   4.470 -44.449  1.00 55.60           C
ATOM   1157  CB  TRP    80      19.904   5.439 -44.946  1.00 63.07           C
ATOM   1160  CG  TRP    80      20.030   5.617 -46.456  1.00 65.87           C
ATOM   1161  CD1 TRP    80      20.691   4.776 -47.339  1.00 67.73           C
ATOM   1163  NE1 TRP    80      20.616   5.286 -48.629  1.00 67.72           N
ATOM   1165  CE2 TRP    80      19.924   6.474 -48.606  1.00 67.86           C
ATOM   1166  CD2 TRP    80      19.540   6.723 -47.253  1.00 67.40           C
ATOM   1167  CE3 TRP    80      18.818   7.901 -46.958  1.00 68.41           C
ATOM   1169  CZ3 TRP    80      18.495   8.795 -48.023  1.00 67.39           C
ATOM   1171  CH2 TRP    80      18.885   8.511 -49.356  1.00 67.23           C
ATOM   1173  CZ2 TRP    80      19.597   7.362 -49.669  1.00 67.67           C
ATOM   1175  C   TRP    80      17.420   5.146 -44.450  1.00 52.91           C
ATOM   1176  O   TRP    80      17.288   6.276 -43.997  1.00 52.76           O
ATOM   1178  N   LYS    81      16.405   4.434 -44.927  1.00 51.79           N
ATOM   1179  CA  LYS    81      15.072   4.994 -45.096  1.00 53.30           C
ATOM   1181  CB  LYS    81      14.761   5.138 -46.595  1.00 55.49           C
ATOM   1184  CG  LYS    81      15.288   6.449 -47.222  1.00 57.75           C
ATOM   1187  CD  LYS    81      15.368   6.355 -48.768  1.00 58.75           C
ATOM   1190  CE  LYS    81      15.321   7.749 -49.440  1.00 59.71           C
ATOM   1193  NZ  LYS    81      15.457   7.726 -50.962  1.00 59.62           N
ATOM   1197  C   LYS    81      13.955   4.205 -44.403  1.00 49.64           C
ATOM   1198  O   LYS    81      12.956   4.797 -44.014  1.00 50.27           O
ATOM   1200  N   LYS    82      14.115   2.889 -44.251  1.00 46.38           N
ATOM   1201  CA  LYS    82      13.050   2.019 -43.722  1.00 46.70           C
ATOM   1203  CB  LYS    82      13.562   0.566 -43.558  1.00 50.15           C
ATOM   1206  CG  LYS    82      12.578  -0.377 -42.851  1.00 51.31           C
ATOM   1209  CD  LYS    82      13.048  -1.830 -42.762  1.00 51.64           C
ATOM   1212  CE  LYS    82      12.130  -2.626 -41.803  1.00 54.45           C
ATOM   1215  NZ  LYS    82      12.127  -4.123 -42.031  1.00 57.72           N
ATOM   1219  C   LYS    82      12.493   2.528 -42.389  1.00 43.47           C
ATOM   1220  O   LYS    82      11.288   2.760 -42.244  1.00 41.94           O
ATOM   1222  N   PHE    83      13.381   2.705 -41.426  1.00 42.42           N
ATOM   1223  CA  PHE    83      12.988   3.068 -40.086  1.00 40.77           C
ATOM   1225  CB  PHE    83      14.193   3.031 -39.152  1.00 42.80           C
ATOM   1228  CG  PHE    83      13.856   3.360 -37.744  1.00 42.77           C
ATOM   1229  CD1 PHE    83      13.488   2.366 -36.865  1.00 43.70           C
ATOM   1231  CE1 PHE    83      13.167   2.672 -35.557  1.00 45.25           C
ATOM   1233  CZ  PHE    83      13.186   3.995 -35.129  1.00 44.39           C
ATOM   1235  CE2 PHE    83      13.522   5.001 -36.008  1.00 43.85           C
ATOM   1237  CD2 PHE    83      13.863   4.685 -37.302  1.00 44.37           C
ATOM   1239  C   PHE    83      12.309   4.453 -40.053  1.00 39.83           C
ATOM   1240  O   PHE    83      11.285   4.641 -39.350  1.00 35.89           O
ATOM   1242  N   HIS    84      12.855   5.402 -40.824  1.00 38.90           N
ATOM   1243  CA  HIS    84      12.337   6.775 -40.928  0.50 39.58           C
ATOM   1247  CB  HIS    84      13.230   7.622 -41.865  0.50 38.85           C
ATOM   1253  CG  HIS    84      14.598   7.905 -41.328  0.50 39.27           C
ATOM   1255  ND1 HIS    84      15.557   6.925 -41.166  0.50 41.74           N
ATOM   1259  CE1 HIS    84      16.665   7.470 -40.692  0.50 40.71           C
ATOM   1263  NE2 HIS    84      16.461   8.767 -40.548  0.50 40.18           N
ATOM   1267  CD2 HIS    84      15.178   9.064 -40.936  0.50 40.38           C
ATOM   1271  C   HIS    84      10.917   6.796 -41.492  1.00 39.00           C
ATOM   1272  O   HIS    84      10.042   7.442 -40.968  1.00 35.42           O
ATOM   1274  N   PHE    85      10.738   6.110 -42.625  1.00 39.64           N
ATOM   1275  CA  PHE    85       9.432   6.022 -43.267  1.00 41.39           C
ATOM   1277  CB  PHE    85       9.464   5.113 -44.503  1.00 46.45           C
ATOM   1280  CG  PHE    85      10.062   5.749 -45.742  1.00 47.72           C
ATOM   1281  CD1 PHE    85      10.888   5.012 -46.571  1.00 49.17           C
ATOM   1283  CE1 PHE    85      11.423   5.573 -47.722  1.00 50.88           C
ATOM   1285  CZ  PHE    85      11.138   6.889 -48.045  1.00 50.21           C
ATOM   1287  CE2 PHE    85      10.325   7.624 -47.239  1.00 49.58           C
ATOM   1289  CD2 PHE    85       9.781   7.058 -46.093  1.00 50.08           C
ATOM   1291  C   PHE    85       8.383   5.470 -42.287  1.00 38.65           C
ATOM   1292  O   PHE    85       7.299   6.034 -42.140  1.00 37.68           O
ATOM   1294  N   ALA    86       8.730   4.374 -41.620  1.00 36.77           N
ATOM   1295  CA  ALA    86       7.836   3.712 -40.683  1.00 38.36           C
ATOM   1297  CB  ALA    86       8.435   2.338 -40.233  1.00 34.80           C
ATOM   1301  C   ALA    86       7.511   4.577 -39.469  1.00 38.21           C
ATOM   1302  O   ALA    86       6.418   4.549 -38.983  1.00 44.51           O
ATOM   1304  N   THR    87       8.483   5.320 -38.985  1.00 40.31           N
ATOM   1305  CA  THR    87       8.315   6.233 -37.856  1.00 37.17           C
ATOM   1307  CB  THR    87       9.701   6.736 -37.370  1.00 38.01           C
ATOM   1309  OG1 THR    87      10.339   5.702 -36.643  1.00 37.45           O
ATOM   1311  CG2 THR    87       9.586   8.000 -36.476  1.00 39.61           C
ATOM   1315  C   THR    87       7.423   7.424 -38.215  1.00 37.95           C
ATOM   1316  O   THR    87       6.622   7.851 -37.405  1.00 39.24           O
ATOM   1318  N   SER    88       7.585   7.949 -39.426  1.00 38.17           N
ATOM   1319  CA  SER    88       6.774   9.075 -39.951  1.00 40.09           C
ATOM   1321  CB  SER    88       7.342   9.535 -41.341  1.00 40.30           C
ATOM   1324  OG  SER    88       6.494  10.422 -42.117  1.00 37.83           O
ATOM   1326  C   SER    88       5.281   8.672 -40.032  1.00 41.70           C
ATOM   1327  O   SER    88       4.399   9.412 -39.592  1.00 41.19           O
ATOM   1329  N   ALA    89       5.025   7.490 -40.595  1.00 45.25           N
ATOM   1330  CA  ALA    89       3.687   6.893 -40.647  1.00 44.19           C
ATOM   1332  CB  ALA    89       3.777   5.475 -41.188  1.00 46.29           C
ATOM   1336  C   ALA    89       3.008   6.885 -39.283  1.00 45.07           C
ATOM   1337  O   ALA    89       1.881   7.325 -39.153  1.00 48.19           O
ATOM   1339  N   LYS    90       3.714   6.388 -38.276  1.00 44.80           N
ATOM   1340  CA  LYS    90       3.198   6.280 -36.911  1.00 44.76           C
ATOM   1342  CB  LYS    90       4.230   5.624 -35.997  1.00 49.04           C
ATOM   1345  CG  LYS    90       4.427   4.167 -36.138  1.00 52.28           C
ATOM   1348  CD  LYS    90       5.252   3.684 -34.937  1.00 55.52           C
ATOM   1351  CE  LYS    90       5.861   2.316 -35.161  1.00 57.76           C
ATOM   1354  NZ  LYS    90       6.743   1.939 -34.007  1.00 61.01           N
ATOM   1358  C   LYS    90       2.895   7.608 -36.267  1.00 43.41           C
ATOM   1359  O   LYS    90       1.853   7.768 -35.629  1.00 41.29           O
ATOM   1361  N   ALA    91       3.848   8.541 -36.371  1.00 38.72           N
ATOM   1362  CA  ALA    91       3.811   9.776 -35.602  1.00 34.22           C
ATOM   1364  CB  ALA    91       5.192  10.399 -35.550  1.00 33.19           C
ATOM   1368  C   ALA    91       2.801  10.765 -36.196  1.00 33.10           C
ATOM   1369  O   ALA    91       2.111  11.494 -35.462  1.00 32.53           O
ATOM   1371  N   PHE    92       2.728  10.796 -37.522  1.00 28.52           N
ATOM   1372  CA  PHE    92       1.840  11.740 -38.221  1.00 29.87           C
ATOM   1374  CB  PHE    92       2.560  12.361 -39.421  1.00 28.38           C
ATOM   1377  CG  PHE    92       3.759  13.216 -39.043  1.00 28.68           C
ATOM   1378  CD1 PHE    92       5.042  12.697 -39.093  1.00 28.73           C
ATOM   1380  CE1 PHE    92       6.138  13.482 -38.750  1.00 28.96           C
ATOM   1382  CZ  PHE    92       5.947  14.770 -38.336  1.00 28.94           C
ATOM   1384  CE2 PHE    92       4.663  15.299 -38.266  1.00 27.76           C
ATOM   1386  CD2 PHE    92       3.588  14.532 -38.628  1.00 26.96           C
ATOM   1388  C   PHE    92       0.509  11.103 -38.668  1.00 28.49           C
ATOM   1389  O   PHE    92      -0.437  11.813 -38.861  1.00 30.98           O
ATOM   1391  N   GLY    93       0.465   9.779 -38.837  1.00 33.73           N
ATOM   1392  CA  GLY    93      -0.773   9.047 -39.187  1.00 37.82           C
ATOM   1395  C   GLY    93      -1.149   9.052 -40.667  1.00 42.79           C
ATOM   1396  O   GLY    93      -2.198   9.578 -41.044  1.00 48.69           O
ATOM   1398  N   HIS    94      -0.288   8.480 -41.509  1.00 46.25           N
ATOM   1399  CA  HIS    94      -0.554   8.314 -42.954  1.00 45.32           C
ATOM   1401  CB  HIS    94       0.084   9.445 -43.781  1.00 46.24           C
ATOM   1404  CG  HIS    94       1.574   9.584 -43.602  1.00 46.20           C
ATOM   1405  ND1 HIS    94       2.489   8.802 -44.284  1.00 47.40           N
ATOM   1407  CE1 HIS    94       3.713   9.150 -43.927  1.00 45.51           C
ATOM   1409  NE2 HIS    94       3.627  10.140 -43.057  1.00 44.79           N
ATOM   1411  CD2 HIS    94       2.304  10.431 -42.837  1.00 44.48           C
ATOM   1413  C   HIS    94      -0.016   6.984 -43.415  1.00 47.74           C
ATOM   1414  O   HIS    94       0.793   6.369 -42.717  1.00 49.46           O
ATOM   1416  N   ARG    95      -0.457   6.533 -44.591  1.00 50.57           N
ATOM   1417  CA  ARG    95       0.032   5.267 -45.169  1.00 51.59           C
ATOM   1419  CB  ARG    95      -0.875   4.791 -46.320  1.00 52.49           C
ATOM   1422  CG  ARG    95      -2.180   4.132 -45.819  1.00 53.97           C
ATOM   1425  CD  ARG    95      -3.100   3.623 -46.934  1.00 54.03           C
ATOM   1428  NE  ARG    95      -3.836   4.705 -47.596  1.00 54.06           N
ATOM   1430  CZ  ARG    95      -3.861   4.929 -48.918  1.00 54.85           C
ATOM   1431  NH1 ARG    95      -3.215   4.138 -49.778  1.00 55.26           N
ATOM   1434  NH2 ARG    95      -4.557   5.951 -49.393  1.00 53.58           N
ATOM   1437  C   ARG    95       1.442   5.468 -45.648  1.00 52.40           C
ATOM   1438  O   ARG    95       1.902   6.590 -45.756  1.00 52.12           O
ATOM   1440  N   SER    96       2.131   4.379 -45.954  1.00 55.99           N
ATOM   1441  CA  SER    96       3.549   4.465 -46.298  1.00 56.43           C
ATOM   1443  CB  SER    96       4.180   3.093 -46.433  1.00 57.03           C
ATOM   1446  OG  SER    96       5.550   3.236 -46.769  1.00 56.72           O
ATOM   1448  C   SER    96       3.818   5.240 -47.578  1.00 56.33           C
ATOM   1449  O   SER    96       3.080   5.143 -48.569  1.00 56.21           O
ATOM   1451  N   ILE    97       4.923   5.976 -47.537  1.00 55.09           N
ATOM   1452  CA  ILE    97       5.357   6.859 -48.620  1.00 54.03           C
ATOM   1454  CB  ILE    97       5.577   8.290 -48.096  1.00 54.11           C
ATOM   1456  CG1 ILE    97       6.598   8.312 -46.937  1.00 54.57           C
ATOM   1459  CD1 ILE    97       6.891   9.727 -46.416  1.00 56.06           C
ATOM   1463  CG2 ILE    97       4.279   8.842 -47.595  1.00 53.67           C
ATOM   1467  C   ILE    97       6.633   6.324 -49.244  1.00 51.84           C
ATOM   1468  O   ILE    97       7.251   6.979 -50.078  1.00 51.47           O
ATOM   1470  N   ASP    98       7.028   5.138 -48.803  1.00 53.71           N
ATOM   1471  CA  ASP    98       8.038   4.368 -49.460  1.00 56.67           C
ATOM   1473  CB  ASP    98       8.330   3.120 -48.628  1.00 56.84           C
ATOM   1476  CG  ASP    98       9.645   2.475 -48.975  1.00 58.14           C
ATOM   1477  OD1 ASP    98      10.122   2.627 -50.125  1.00 58.33           O
ATOM   1478  OD2 ASP    98      10.201   1.800 -48.080  1.00 59.35           O
ATOM   1479  C   ASP    98       7.452   3.977 -50.817  1.00 59.93           C
ATOM   1480  O   ASP    98       6.417   3.302 -50.866  1.00 59.70           O
ATOM   1482  N   PRO    99       8.090   4.411 -51.928  1.00 62.82           N
ATOM   1483  CA  PRO    99       7.562   4.038 -53.253  1.00 64.28           C
ATOM   1485  CB  PRO    99       8.643   4.541 -54.216  1.00 63.59           C
ATOM   1488  CG  PRO    99       9.337   5.630 -53.477  1.00 62.70           C
ATOM   1491  CD  PRO    99       9.302   5.248 -52.036  1.00 62.95           C
ATOM   1494  C   PRO    99       7.350   2.529 -53.423  1.00 66.35           C
ATOM   1495  O   PRO    99       6.520   2.108 -54.221  1.00 64.68           O
ATOM   1496  N   MET   100       8.103   1.743 -52.652  1.00 69.99           N
ATOM   1497  CA  MET   100       8.046   0.288 -52.682  1.00 72.67           C
ATOM   1499  CB  MET   100       9.186  -0.278 -51.828  1.00 73.98           C
ATOM   1502  CG  MET   100       9.405  -1.774 -51.985  1.00 77.08           C
ATOM   1505  SD  MET   100      11.147  -2.244 -51.859  1.00 79.78           S
ATOM   1506  CE  MET   100      11.851  -1.305 -53.240  1.00 79.03           C
ATOM   1510  C   MET   100       6.705  -0.272 -52.197  1.00 70.11           C
ATOM   1511  O   MET   100       6.394  -1.430 -52.460  1.00 70.91           O
ATOM   1513  N   ASP   101       5.929   0.548 -51.485  1.00 67.72           N
ATOM   1514  CA  ASP   101       4.594   0.158 -51.000  1.00 65.85           C
ATOM   1516  CB  ASP   101       4.397   0.617 -49.548  1.00 66.45           C
ATOM   1519  CG  ASP   101       5.476   0.097 -48.621  1.00 67.20           C
ATOM   1520  OD1 ASP   101       6.156  -0.896 -48.976  1.00 68.40           O
ATOM   1521  OD2 ASP   101       5.647   0.680 -47.535  1.00 67.26           O
ATOM   1522  C   ASP   101       3.471   0.708 -51.885  1.00 62.30           C
ATOM   1523  O   ASP   101       2.306   0.587 -51.547  1.00 61.55           O
ATOM   1525  N   GLY   102       3.842   1.325 -53.004  1.00 59.94           N
ATOM   1526  CA  GLY   102       2.907   1.611 -54.097  1.00 58.90           C
ATOM   1529  C   GLY   102       1.909   2.736 -53.908  1.00 57.91           C
ATOM   1530  O   GLY   102       0.954   2.845 -54.677  1.00 60.41           O
ATOM   1532  N   ASN   103       2.116   3.584 -52.905  1.00 55.32           N
ATOM   1533  CA  ASN   103       1.208   4.711 -52.668  1.00 50.84           C
ATOM   1535  CB  ASN   103       1.107   4.999 -51.185  1.00 50.43           C
ATOM   1538  CG  ASN   103       0.403   3.897 -50.431  1.00 49.71           C
ATOM   1539  OD1 ASN   103      -0.530   3.300 -50.935  1.00 48.27           O
ATOM   1540  ND2 ASN   103       0.830   3.645 -49.211  1.00 51.06           N
ATOM   1543  C   ASN   103       1.647   5.938 -53.427  1.00 49.49           C
ATOM   1544  O   ASN   103       0.826   6.795 -53.766  1.00 50.71           O
ATOM   1546  N   THR   104       2.944   6.015 -53.712  1.00 47.81           N
ATOM   1547  CA  THR   104       3.497   7.097 -54.523  1.00 47.44           C
ATOM   1549  CB  THR   104       3.908   8.349 -53.629  1.00 47.45           C
ATOM   1551  OG1 THR   104       4.063   9.528 -54.441  1.00 48.14           O
ATOM   1553  CG2 THR   104       5.173   8.081 -52.863  1.00 44.82           C
ATOM   1557  C   THR   104       4.679   6.551 -55.291  1.00 46.98           C
ATOM   1558  O   THR   104       5.227   5.505 -54.932  1.00 46.34           O
ATOM   1560  N   THR   105       5.025   7.227 -56.380  1.00 48.19           N
ATOM   1561  CA  THR   105       6.266   6.976 -57.118  1.00 49.25           C
ATOM   1563  CB  THR   105       5.989   6.872 -58.621  1.00 49.79           C
ATOM   1565  OG1 THR   105       5.459   8.122 -59.085  1.00 50.19           O
ATOM   1567  CG2 THR   105       4.990   5.730 -58.914  1.00 48.72           C
ATOM   1571  C   THR   105       7.271   8.124 -56.902  1.00 50.01           C
ATOM   1572  O   THR   105       8.360   8.120 -57.479  1.00 49.46           O
ATOM   1574  N   GLU   106       6.875   9.108 -56.084  1.00 48.84           N
ATOM   1575  CA  GLU   106       7.693  10.259 -55.772  1.00 47.82           C
ATOM   1577  CB  GLU   106       6.856  11.315 -55.046  1.00 47.63           C
ATOM   1580  CG  GLU   106       7.638  12.568 -54.683  1.00 49.06           C
ATOM   1583  CD  GLU   106       6.881  13.520 -53.791  1.00 48.17           C
ATOM   1584  OE1 GLU   106       5.729  13.231 -53.441  1.00 48.13           O
ATOM   1585  OE2 GLU   106       7.444  14.572 -53.444  1.00 46.64           O
ATOM   1586  C   GLU   106       8.843   9.858 -54.881  1.00 46.78           C
ATOM   1587  O   GLU   106       8.657   9.101 -53.930  1.00 46.19           O
ATOM   1589  N   ASN   107      10.035  10.365 -55.187  1.00 47.33           N
ATOM   1590  CA  ASN   107      11.147  10.313 -54.231  1.00 49.20           C
ATOM   1592  CB  ASN   107      12.489  10.133 -54.955  1.00 52.76           C
ATOM   1595  CG  ASN   107      13.675   9.978 -53.985  1.00 54.18           C
ATOM   1596  OD1 ASN   107      13.564  10.223 -52.779  1.00 55.90           O
ATOM   1597  ND2 ASN   107      14.805   9.574 -54.519  1.00 56.12           N
ATOM   1600  C   ASN   107      11.124  11.613 -53.408  1.00 46.24           C
ATOM   1601  O   ASN   107      11.539  12.656 -53.889  1.00 42.07           O
ATOM   1603  N   ILE   108      10.596  11.547 -52.182  1.00 47.09           N
ATOM   1604  CA  ILE   108      10.452  12.759 -51.341  1.00 50.83           C
ATOM   1606  CB  ILE   108       9.685  12.496 -50.013  1.00 53.08           C
ATOM   1608  CG1 ILE   108      10.360  11.392 -49.192  1.00 53.45           C
ATOM   1611  CD1 ILE   108       9.877  11.334 -47.799  1.00 56.16           C
ATOM   1615  CG2 ILE   108       8.243  12.166 -50.294  1.00 53.20           C
ATOM   1619  C   ILE   108      11.787  13.441 -51.017  1.00 48.36           C
ATOM   1620  O   ILE   108      11.839  14.646 -50.899  1.00 47.30           O
ATOM   1622  N   ASN   109      12.857  12.662 -50.894  1.00 49.70           N
ATOM   1623  CA  ASN   109      14.182  13.226 -50.649  1.00 50.06           C
ATOM   1625  CB  ASN   109      15.217  12.121 -50.389  1.00 52.92           C
ATOM   1631  C   ASN   109      14.630  14.138 -51.793  1.00 47.80           C
ATOM   1632  O   ASN   109      15.183  15.208 -51.543  1.00 51.25           O
ATOM   1634  N   ASP   110      14.389  13.707 -53.033  1.00 43.09           N
ATOM   1635  CA  ASP   110      14.692  14.537 -54.202  0.50 42.34           C
ATOM   1639  CB  ASP   110      14.475  13.771 -55.515  0.50 42.44           C
ATOM   1645  CG  ASP   110      15.514  12.667 -55.744  0.50 44.76           C
ATOM   1647  OD1 ASP   110      16.603  12.685 -55.098  0.50 44.19           O
ATOM   1649  OD2 ASP   110      15.231  11.780 -56.584  0.50 45.37           O
ATOM   1651  C   ASP   110      13.857  15.819 -54.211  1.00 40.89           C
ATOM   1652  O   ASP   110      14.361  16.882 -54.600  1.00 37.55           O
ATOM   1654  N   THR   111      12.590  15.720 -53.787  1.00 37.50           N
ATOM   1655  CA  THR   111      11.705  16.889 -53.674  1.00 34.04           C
ATOM   1657  CB  THR   111      10.276  16.460 -53.255  1.00 32.32           C
ATOM   1659  OG1 THR   111       9.801  15.491 -54.173  1.00 31.87           O
ATOM   1661  CG2 THR   111       9.266  17.674 -53.207  1.00 30.19           C
ATOM   1665  C   THR   111      12.269  17.895 -52.666  1.00 34.24           C
ATOM   1666  O   THR   111      12.227  19.107 -52.889  1.00 32.10           O
ATOM   1668  N   PHE   112      12.807  17.382 -51.561  1.00 36.07           N
ATOM   1669  CA  PHE   112      13.337  18.243 -50.507  1.00 37.35           C
ATOM   1671  CB  PHE   112      13.602  17.469 -49.212  1.00 35.12           C
ATOM   1674  CG  PHE   112      12.374  16.967 -48.538  1.00 34.64           C
ATOM   1675  CD1 PHE   112      12.381  15.727 -47.915  1.00 35.42           C
ATOM   1677  CE1 PHE   112      11.262  15.248 -47.283  1.00 35.59           C
ATOM   1679  CZ  PHE   112      10.117  15.999 -47.258  1.00 35.35           C
ATOM   1681  CE2 PHE   112      10.096  17.240 -47.860  1.00 36.13           C
ATOM   1683  CD2 PHE   112      11.224  17.720 -48.497  1.00 35.08           C
ATOM   1685  C   PHE   112      14.604  18.893 -50.964  1.00 37.79           C
ATOM   1686  O   PHE   112      14.743  20.113 -50.875  1.00 35.25           O
ATOM   1688  N   ILE   113      15.526  18.079 -51.467  1.00 39.53           N
ATOM   1689  CA  ILE   113      16.782  18.595 -52.012  1.00 42.79           C
ATOM   1691  CB  ILE   113      17.667  17.460 -52.604  1.00 43.24           C
ATOM   1693  CG1 ILE   113      18.194  16.556 -51.479  1.00 43.72           C
ATOM   1696  CD1 ILE   113      18.861  15.259 -51.989  1.00 43.74           C
ATOM   1700  CG2 ILE   113      18.792  18.050 -53.432  1.00 42.42           C
ATOM   1704  C   ILE   113      16.500  19.641 -53.081  1.00 41.31           C
ATOM   1705  O   ILE   113      17.069  20.725 -53.060  1.00 45.45           O
ATOM   1707  N   LYS   114      15.596  19.323 -53.995  1.00 43.21           N
ATOM   1708  CA  LYS   114      15.271  20.217 -55.146  1.00 40.11           C
ATOM   1710  CB  LYS   114      14.255  19.512 -56.079  1.00 42.74           C
ATOM   1713  CG  LYS   114      13.756  20.347 -57.276  1.00 44.09           C
ATOM   1719  C   LYS   114      14.732  21.579 -54.745  1.00 37.61           C
ATOM   1720  O   LYS   114      15.026  22.581 -55.391  1.00 40.71           O
ATOM   1722  N   THR   115      13.908  21.619 -53.693  1.00 35.93           N
ATOM   1723  CA  THR   115      13.146  22.826 -53.336  1.00 29.27           C
ATOM   1725  CB  THR   115      11.671  22.461 -53.097  1.00 32.50           C
ATOM   1727  OG1 THR   115      11.599  21.430 -52.106  1.00 29.13           O
ATOM   1729  CG2 THR   115      11.000  21.934 -54.402  1.00 30.85           C
ATOM   1733  C   THR   115      13.717  23.535 -52.081  1.00 29.60           C
ATOM   1734  O   THR   115      13.242  24.619 -51.693  1.00 23.98           O
ATOM   1736  N   LEU   116      14.747  22.934 -51.472  1.00 29.71           N
ATOM   1737  CA  LEU   116      15.381  23.497 -50.287  1.00 30.43           C
ATOM   1739  CB  LEU   116      15.385  22.465 -49.161  1.00 26.87           C
ATOM   1742  CG  LEU   116      14.034  22.340 -48.470  1.00 26.30           C
ATOM   1744  CD1 LEU   116      14.019  21.233 -47.459  1.00 23.09           C
ATOM   1748  CD2 LEU   116      13.654  23.751 -47.842  1.00 21.91           C
ATOM   1752  C   LEU   116      16.794  24.016 -50.562  1.00 32.58           C
ATOM   1753  O   LEU   116      17.445  24.565 -49.656  1.00 30.89           O
ATOM   1755  N   GLN   117      17.254  23.848 -51.804  1.00 38.09           N
ATOM   1756  CA  GLN   117      18.597  24.256 -52.229  1.00 39.94           C
ATOM   1758  CB  GLN   117      19.533  23.043 -52.221  1.00 42.92           C
ATOM   1761  CG  GLN   117      19.781  22.461 -50.770  1.00 44.86           C
ATOM   1764  CD  GLN   117      20.154  20.966 -50.746  1.00 44.36           C
ATOM   1765  OE1 GLN   117      21.010  20.507 -51.509  1.00 46.64           O
ATOM   1766  NE2 GLN   117      19.518  20.215 -49.852  1.00 39.53           N
ATOM   1769  C   GLN   117      18.519  24.909 -53.616  1.00 40.86           C
ATOM   1770  O   GLN   117      17.458  24.966 -54.216  1.00 41.67           O
ATOM   1772  N   GLY   118      19.636  25.431 -54.105  1.00 40.35           N
ATOM   1773  CA  GLY   118      19.684  26.036 -55.415  1.00 40.26           C
ATOM   1776  C   GLY   118      18.881  27.317 -55.481  1.00 41.13           C
ATOM   1777  O   GLY   118      18.876  28.101 -54.534  1.00 41.68           O
ATOM   1779  N   HIS   119      18.202  27.536 -56.603  1.00 41.40           N
ATOM   1780  CA  HIS   119      17.396  28.757 -56.790  1.00 43.06           C
ATOM   1782  CB  HIS   119      16.772  28.807 -58.207  1.00 48.11           C
ATOM   1785  CG  HIS   119      15.757  29.910 -58.384  1.00 49.93           C
ATOM   1786  ND1 HIS   119      14.402  29.711 -58.213  1.00 51.01           N
ATOM   1788  CE1 HIS   119      13.759  30.850 -58.409  1.00 52.94           C
ATOM   1790  NE2 HIS   119      14.649  31.788 -58.693  1.00 54.54           N
ATOM   1792  CD2 HIS   119      15.908  31.227 -58.680  1.00 52.95           C
ATOM   1794  C   HIS   119      16.296  28.856 -55.749  1.00 40.39           C
ATOM   1795  O   HIS   119      15.977  29.952 -55.266  1.00 36.66           O
ATOM   1797  N   ALA   120      15.697  27.705 -55.428  1.00 38.45           N
ATOM   1798  CA  ALA   120      14.641  27.625 -54.435  1.00 36.35           C
ATOM   1800  CB  ALA   120      14.166  26.169 -54.284  1.00 35.78           C
ATOM   1804  C   ALA   120      15.100  28.193 -53.091  1.00 34.84           C
ATOM   1805  O   ALA   120      14.373  28.965 -52.449  1.00 35.37           O
ATOM   1807  N   LEU   121      16.303  27.817 -52.672  1.00 32.04           N
ATOM   1808  CA  LEU   121      16.847  28.287 -51.413  1.00 32.86           C
ATOM   1810  CB  LEU   121      18.243  27.703 -51.180  1.00 35.10           C
ATOM   1813  CG  LEU   121      19.071  28.287 -50.010  1.00 37.67           C
ATOM   1815  CD1 LEU   121      18.282  28.244 -48.692  1.00 36.56           C
ATOM   1819  CD2 LEU   121      20.355  27.534 -49.900  1.00 32.26           C
ATOM   1823  C   LEU   121      16.892  29.829 -51.336  1.00 34.69           C
ATOM   1824  O   LEU   121      16.592  30.409 -50.268  1.00 33.71           O
ATOM   1826  N   ASN   122      17.232  30.479 -52.466  1.00 34.96           N
ATOM   1827  CA  ASN   122      17.380  31.920 -52.516  1.00 37.15           C
ATOM   1829  CB  ASN   122      17.877  32.397 -53.887  1.00 43.21           C
ATOM   1832  CG  ASN   122      19.261  31.859 -54.247  1.00 49.38           C
ATOM   1833  OD1 ASN   122      19.769  30.907 -53.623  1.00 52.85           O
ATOM   1834  ND2 ASN   122      19.876  32.459 -55.293  1.00 50.01           N
ATOM   1837  C   ASN   122      16.074  32.580 -52.233  1.00 34.92           C
ATOM   1838  O   ASN   122      16.016  33.519 -51.449  1.00 33.68           O
ATOM   1840  N   SER   123      15.018  32.085 -52.884  1.00 35.04           N
ATOM   1841  CA  SER   123      13.659  32.609 -52.703  1.00 35.74           C
ATOM   1843  CB  SER   123      12.691  32.094 -53.814  1.00 39.85           C
ATOM   1846  OG  SER   123      12.495  30.673 -53.752  1.00 44.18           O
ATOM   1848  C   SER   123      13.112  32.335 -51.292  1.00 28.43           C
ATOM   1849  O   SER   123      12.535  33.206 -50.702  1.00 29.45           O
ATOM   1851  N   LEU   124      13.344  31.151 -50.745  1.00 29.15           N
ATOM   1852  CA  LEU   124      13.056  30.900 -49.311  1.00 28.75           C
ATOM   1854  CB  LEU   124      13.499  29.507 -48.895  1.00 29.83           C
ATOM   1857  CG  LEU   124      12.540  28.380 -49.150  1.00 32.77           C
ATOM   1859  CD1 LEU   124      13.209  27.099 -48.723  1.00 32.58           C
ATOM   1863  CD2 LEU   124      11.181  28.608 -48.414  1.00 34.67           C
ATOM   1867  C   LEU   124      13.747  31.858 -48.360  1.00 27.31           C
ATOM   1868  O   LEU   124      13.138  32.342 -47.403  1.00 29.98           O
ATOM   1870  N   THR   125      15.041  32.056 -48.583  1.00 25.21           N
ATOM   1871  CA  THR   125      15.860  32.902 -47.728  1.00 26.77           C
ATOM   1873  CB  THR   125      17.316  32.921 -48.216  1.00 30.12           C
ATOM   1875  OG1 THR   125      17.835  31.591 -48.194  1.00 23.52           O
ATOM   1877  CG2 THR   125      18.152  33.819 -47.365  1.00 27.49           C
ATOM   1881  C   THR   125      15.346  34.307 -47.727  1.00 26.30           C
ATOM   1882  O   THR   125      15.216  34.940 -46.680  1.00 29.09           O
ATOM   1884  N   GLU   126      15.026  34.792 -48.919  1.00 30.51           N
ATOM   1885  CA  GLU   126      14.552  36.160 -49.120  1.00 33.34           C
ATOM   1887  CB  GLU   126      14.507  36.459 -50.627  1.00 36.23           C
ATOM   1890  CG  GLU   126      14.365  37.915 -50.953  1.00 42.33           C
ATOM   1896  C   GLU   126      13.184  36.360 -48.491  1.00 29.77           C
ATOM   1897  O   GLU   126      12.925  37.352 -47.806  1.00 28.72           O
ATOM   1899  N   SER   127      12.308  35.398 -48.706  1.00 29.62           N
ATOM   1900  CA  SER   127      10.975  35.408 -48.079  1.00 28.96           C
ATOM   1902  CB  SER   127      10.148  34.217 -48.626  1.00 30.13           C
ATOM   1905  OG  SER   127       8.903  34.084 -47.976  1.00 35.29           O
ATOM   1907  C   SER   127      11.082  35.377 -46.534  1.00 27.66           C
ATOM   1908  O   SER   127      10.348  36.078 -45.836  1.00 26.38           O
ATOM   1910  N   MET   128      12.007  34.581 -45.994  1.00 27.13           N
ATOM   1911  CA  MET   128      12.154  34.504 -44.517  1.00 26.14           C
ATOM   1913  CB  MET   128      13.131  33.371 -44.123  1.00 28.27           C
ATOM   1916  CG  MET   128      13.289  33.123 -42.617  1.00 28.63           C
ATOM   1919  SD  MET   128      11.798  32.494 -41.873  1.00 30.49           S
ATOM   1920  CE  MET   128      12.316  32.139 -40.211  1.00 29.26           C
ATOM   1924  C   MET   128      12.604  35.865 -43.967  1.00 26.41           C
ATOM   1925  O   MET   128      12.035  36.372 -42.978  1.00 26.88           O
ATOM   1927  N   MET   129      13.590  36.481 -44.624  1.00 27.51           N
ATOM   1928  CA  MET   129      14.056  37.775 -44.193  1.00 29.45           C
ATOM   1930  CB  MET   129      15.221  38.266 -45.073  1.00 31.45           C
ATOM   1933  CG  MET   129      15.766  39.657 -44.651  1.00 34.52           C
ATOM   1936  SD  MET   129      16.501  39.675 -42.993  1.00 35.80           S
ATOM   1937  CE  MET   129      18.211  39.407 -43.458  1.00 38.52           C
ATOM   1941  C   MET   129      12.901  38.797 -44.167  1.00 29.64           C
ATOM   1942  O   MET   129      12.781  39.574 -43.229  1.00 32.33           O
ATOM   1944  N   GLU   130      12.058  38.781 -45.197  1.00 34.99           N
ATOM   1945  CA  GLU   130      10.886  39.692 -45.271  1.00 35.98           C
ATOM   1947  CB  GLU   130      10.178  39.598 -46.636  1.00 40.68           C
ATOM   1950  CG  GLU   130      10.982  40.175 -47.832  1.00 43.75           C
ATOM   1956  C   GLU   130       9.894  39.405 -44.161  1.00 34.15           C
ATOM   1957  O   GLU   130       9.443  40.327 -43.474  1.00 34.36           O
ATOM   1959  N   ASN   131       9.571  38.119 -43.964  1.00 31.00           N
ATOM   1960  CA  ASN   131       8.647  37.723 -42.909  1.00 29.75           C
ATOM   1962  CB  ASN   131       8.252  36.240 -43.054  1.00 30.60           C
ATOM   1965  CG  ASN   131       7.303  36.014 -44.211  1.00 30.10           C
ATOM   1966  OD1 ASN   131       6.324  36.716 -44.332  1.00 34.99           O
ATOM   1967  ND2 ASN   131       7.580  35.035 -45.047  1.00 28.47           N
ATOM   1970  C   ASN   131       9.156  38.030 -41.509  1.00 30.44           C
ATOM   1971  O   ASN   131       8.377  38.428 -40.646  1.00 27.66           O
ATOM   1973  N   LEU   132      10.461  37.865 -41.279  1.00 32.65           N
ATOM   1974  CA  LEU   132      11.039  38.174 -39.970  1.00 31.49           C
ATOM   1976  CB  LEU   132      12.507  37.724 -39.876  1.00 29.91           C
ATOM   1979  CG  LEU   132      12.734  36.239 -39.578  1.00 28.91           C
ATOM   1981  CD1 LEU   132      14.228  35.879 -39.715  1.00 26.54           C
ATOM   1985  CD2 LEU   132      12.171  35.913 -38.184  1.00 27.73           C
ATOM   1989  C   LEU   132      10.926  39.658 -39.635  1.00 34.07           C
ATOM   1990  O   LEU   132      10.647  40.031 -38.471  1.00 30.72           O
ATOM   1992  N   GLN   133      11.123  40.508 -40.641  1.00 34.70           N
ATOM   1993  CA  GLN   133      11.059  41.959 -40.402  1.00 37.73           C
ATOM   1995  CB  GLN   133      11.731  42.753 -41.533  1.00 36.33           C
ATOM   1998  CG  GLN   133      13.198  42.457 -41.635  1.00 35.63           C
ATOM   2001  CD  GLN   133      13.874  43.266 -42.680  1.00 37.35           C
ATOM   2002  OE1 GLN   133      14.186  44.448 -42.461  1.00 40.25           O
ATOM   2003  NE2 GLN   133      14.125  42.658 -43.823  1.00 35.24           N
ATOM   2006  C   GLN   133       9.650  42.440 -40.164  1.00 36.18           C
ATOM   2007  O   GLN   133       9.439  43.273 -39.301  1.00 35.93           O
ATOM   2009  N   ARG   134       8.682  41.895 -40.896  1.00 38.33           N
ATOM   2010  CA  ARG   134       7.269  42.240 -40.645  1.00 39.04           C
ATOM   2012  CB  ARG   134       6.338  41.582 -41.635  1.00 42.31           C
ATOM   2015  CG  ARG   134       6.470  42.102 -43.045  1.00 47.65           C
ATOM   2018  CD  ARG   134       5.330  41.611 -43.924  1.00 52.42           C
ATOM   2021  NE  ARG   134       5.781  41.347 -45.295  1.00 55.38           N
ATOM   2023  CZ  ARG   134       5.843  40.134 -45.873  1.00 58.20           C
ATOM   2024  NH1 ARG   134       5.478  39.034 -45.213  1.00 58.46           N
ATOM   2027  NH2 ARG   134       6.270  40.018 -47.140  1.00 57.26           N
ATOM   2030  C   ARG   134       6.838  41.864 -39.257  1.00 37.72           C
ATOM   2031  O   ARG   134       6.086  42.589 -38.639  1.00 36.77           O
ATOM   2033  N   ILE   135       7.325  40.725 -38.769  1.00 38.60           N
ATOM   2034  CA  ILE   135       6.919  40.194 -37.463  1.00 38.17           C
ATOM   2036  CB  ILE   135       7.251  38.678 -37.321  1.00 37.30           C
ATOM   2038  CG1 ILE   135       6.451  37.856 -38.312  1.00 37.41           C
ATOM   2041  CD1 ILE   135       7.134  36.527 -38.637  1.00 36.96           C
ATOM   2045  CG2 ILE   135       6.958  38.169 -35.905  1.00 36.81           C
ATOM   2049  C   ILE   135       7.607  40.933 -36.350  1.00 39.68           C
ATOM   2050  O   ILE   135       6.984  41.252 -35.341  1.00 39.24           O
ATOM   2052  N   MET   136       8.909  41.179 -36.527  1.00 42.25           N
ATOM   2053  CA  MET   136       9.747  41.719 -35.459  1.00 42.86           C
ATOM   2055  CB  MET   136      11.234  41.331 -35.667  1.00 42.90           C
ATOM   2058  CG  MET   136      11.522  39.842 -35.324  1.00 43.22           C
ATOM   2061  SD  MET   136      13.104  39.133 -35.869  1.00 40.94           S
ATOM   2062  CE  MET   136      14.197  39.671 -34.579  1.00 37.35           C
ATOM   2066  C   MET   136       9.604  43.228 -35.247  1.00 44.61           C
ATOM   2067  O   MET   136       9.914  43.703 -34.175  1.00 42.21           O
ATOM   2069  N   ARG   137       9.145  43.974 -36.248  1.00 48.88           N
ATOM   2070  CA  ARG   137       8.956  45.437 -36.090  1.00 54.96           C
ATOM   2072  CB  ARG   137       8.899  46.125 -37.449  1.00 56.42           C
ATOM   2075  CG  ARG   137      10.235  46.193 -38.165  1.00 58.34           C
ATOM   2078  CD  ARG   137      10.036  46.579 -39.641  1.00 60.95           C
ATOM   2081  NE  ARG   137      11.249  47.125 -40.265  1.00 62.98           N
ATOM   2083  CZ  ARG   137      11.317  47.595 -41.517  1.00 63.87           C
ATOM   2084  NH1 ARG   137      10.244  47.603 -42.310  1.00 64.52           N
ATOM   2087  NH2 ARG   137      12.471  48.057 -41.983  1.00 64.08           N
ATOM   2090  C   ARG   137       7.693  45.755 -35.306  1.00 56.16           C
ATOM   2091  O   ARG   137       6.828  44.887 -35.129  1.00 58.29           O
ATOM   2093  N   ALA   148       9.868  51.090 -24.590  1.00 49.76           N
ATOM   2094  CA  ALA   148       9.825  50.401 -23.285  1.00 52.57           C
ATOM   2096  CB  ALA   148       8.369  50.284 -22.797  1.00 51.26           C
ATOM   2100  C   ALA   148      10.490  48.993 -23.305  1.00 50.89           C
ATOM   2101  O   ALA   148      10.551  48.336 -24.345  1.00 53.01           O
ATOM   2103  N   TRP   149      10.986  48.562 -22.142  1.00 49.40           N
ATOM   2104  CA  TRP   149      11.529  47.212 -21.958  1.00 45.99           C
ATOM   2106  CB  TRP   149      12.386  47.112 -20.703  1.00 43.99           C
ATOM   2109  CG  TRP   149      13.761  47.679 -20.773  1.00 44.62           C
ATOM   2110  CD1 TRP   149      14.189  48.830 -20.190  1.00 44.37           C
ATOM   2112  NE1 TRP   149      15.524  49.024 -20.429  1.00 43.58           N
ATOM   2114  CE2 TRP   149      16.003  47.984 -21.175  1.00 44.22           C
ATOM   2115  CD2 TRP   149      14.922  47.099 -21.404  1.00 44.73           C
ATOM   2116  CE3 TRP   149      15.147  45.942 -22.154  1.00 43.13           C
ATOM   2118  CZ3 TRP   149      16.441  45.697 -22.642  1.00 43.14           C
ATOM   2120  CH2 TRP   149      17.490  46.580 -22.391  1.00 43.91           C
ATOM   2122  CZ2 TRP   149      17.296  47.736 -21.658  1.00 44.44           C
ATOM   2124  C   TRP   149      10.387  46.235 -21.765  1.00 44.86           C
ATOM   2125  O   TRP   149       9.516  46.471 -20.936  1.00 42.03           O
ATOM   2127  N   VAL   150      10.417  45.128 -22.515  1.00 46.48           N
ATOM   2128  CA  VAL   150       9.451  44.010 -22.366  1.00 42.98           C
ATOM   2130  CB  VAL   150       8.768  43.678 -23.706  1.00 42.95           C
ATOM   2132  CG1 VAL   150       7.715  42.593 -23.526  1.00 42.74           C
ATOM   2136  CG2 VAL   150       8.143  44.928 -24.305  1.00 44.02           C
ATOM   2140  C   VAL   150      10.192  42.778 -21.835  1.00 40.17           C
ATOM   2141  O   VAL   150      11.193  42.358 -22.422  1.00 37.82           O
ATOM   2143  N   THR   151       9.715  42.230 -20.709  1.00 39.77           N
ATOM   2144  CA  THR   151      10.265  41.019 -20.136  1.00 39.54           C
ATOM   2146  CB  THR   151      10.313  41.076 -18.603  1.00 42.14           C
ATOM   2148  OG1 THR   151      11.151  42.160 -18.199  1.00 44.19           O
ATOM   2150  CG2 THR   151      10.884  39.783 -18.010  1.00 41.55           C
ATOM   2154  C   THR   151       9.426  39.815 -20.598  1.00 39.59           C
ATOM   2155  O   THR   151       8.184  39.861 -20.640  1.00 35.44           O
ATOM   2157  N   GLU   152      10.125  38.746 -20.959  1.00 37.91           N
ATOM   2158  CA  GLU   152       9.495  37.558 -21.533  1.00 36.35           C
ATOM   2160  CB  GLU   152       9.209  37.788 -23.016  1.00 38.50           C
ATOM   2163  CG  GLU   152       8.198  36.811 -23.582  1.00 39.94           C
ATOM   2166  CD  GLU   152       7.801  37.133 -24.997  1.00 42.67           C
ATOM   2167  OE1 GLU   152       8.036  38.288 -25.431  1.00 43.89           O
ATOM   2168  OE2 GLU   152       7.237  36.225 -25.680  1.00 45.78           O
ATOM   2169  C   GLU   152      10.418  36.366 -21.397  1.00 32.67           C
ATOM   2170  O   GLU   152      11.629  36.512 -21.352  1.00 31.53           O
ATOM   2172  N   GLY   153       9.846  35.178 -21.327  1.00 33.75           N
ATOM   2173  CA  GLY   153      10.630  33.951 -21.524  1.00 29.59           C
ATOM   2176  C   GLY   153      11.300  33.990 -22.889  1.00 25.89           C
ATOM   2177  O   GLY   153      10.658  34.317 -23.884  1.00 28.64           O
ATOM   2179  N   MET   154      12.599  33.708 -22.936  1.00 27.12           N
ATOM   2180  CA  MET   154      13.341  33.788 -24.196  1.00 29.68           C
ATOM   2182  CB  MET   154      14.848  33.785 -23.944  1.00 30.61           C
ATOM   2185  CG  MET   154      15.694  33.954 -25.208  1.00 31.18           C
ATOM   2188  SD  MET   154      17.463  33.887 -24.888  1.00 34.99           S
ATOM   2189  CE  MET   154      17.725  35.446 -24.028  1.00 37.43           C
ATOM   2193  C   MET   154      12.943  32.673 -25.163  1.00 25.80           C
ATOM   2194  O   MET   154      12.853  32.913 -26.357  1.00 29.56           O
ATOM   2196  N   TYR   155      12.690  31.472 -24.647  1.00 26.85           N
ATOM   2197  CA  TYR   155      12.253  30.321 -25.491  1.00 24.61           C
ATOM   2199  CB  TYR   155      12.172  29.009 -24.704  1.00 23.78           C
ATOM   2202  CG  TYR   155      12.157  27.804 -25.607  1.00 24.14           C
ATOM   2203  CD1 TYR   155      13.325  27.253 -26.030  1.00 26.51           C
ATOM   2205  CE1 TYR   155      13.354  26.136 -26.883  1.00 23.65           C
ATOM   2207  CZ  TYR   155      12.195  25.573 -27.331  1.00 23.58           C
ATOM   2208  OH  TYR   155      12.312  24.477 -28.152  1.00 23.02           O
ATOM   2210  CE2 TYR   155      10.982  26.086 -26.943  1.00 23.61           C
ATOM   2212  CD2 TYR   155      10.958  27.232 -26.069  1.00 24.80           C
ATOM   2214  C   TYR   155      10.929  30.598 -26.114  1.00 23.79           C
ATOM   2215  O   TYR   155      10.768  30.464 -27.314  1.00 22.24           O
ATOM   2217  N   SER   156       9.995  31.019 -25.277  1.00 27.91           N
ATOM   2218  CA  SER   156       8.677  31.482 -25.706  1.00 29.31           C
ATOM   2220  CB  SER   156       7.864  31.829 -24.454  1.00 29.17           C
ATOM   2223  OG  SER   156       6.747  32.577 -24.787  1.00 36.57           O
ATOM   2225  C   SER   156       8.711  32.659 -26.739  1.00 26.38           C
ATOM   2226  O   SER   156       7.905  32.727 -27.639  1.00 26.83           O
ATOM   2228  N   PHE   157       9.681  33.541 -26.631  1.00 31.24           N
ATOM   2229  CA  PHE   157       9.858  34.615 -27.613  1.00 28.14           C
ATOM   2231  CB  PHE   157      10.862  35.633 -27.077  1.00 30.58           C
ATOM   2234  CG  PHE   157      11.197  36.715 -28.042  1.00 28.76           C
ATOM   2235  CD1 PHE   157      10.440  37.855 -28.100  1.00 30.32           C
ATOM   2237  CE1 PHE   157      10.738  38.853 -28.981  1.00 32.16           C
ATOM   2239  CZ  PHE   157      11.805  38.731 -29.806  1.00 31.38           C
ATOM   2241  CE2 PHE   157      12.588  37.602 -29.751  1.00 32.96           C
ATOM   2243  CD2 PHE   157      12.279  36.603 -28.864  1.00 33.15           C
ATOM   2245  C   PHE   157      10.337  34.068 -28.942  1.00 25.62           C
ATOM   2246  O   PHE   157       9.787  34.363 -29.973  1.00 26.74           O
ATOM   2248  N   CYS   158      11.369  33.243 -28.908  1.00 26.31           N
ATOM   2249  CA  CYS   158      11.885  32.612 -30.123  1.00 24.79           C
ATOM   2251  CB  CYS   158      13.147  31.787 -29.807  1.00 22.72           C
ATOM   2254  SG  CYS   158      14.551  32.730 -29.264  1.00 23.76           S
ATOM   2256  C   CYS   158      10.835  31.719 -30.815  1.00 24.17           C
ATOM   2257  O   CYS   158      10.775  31.678 -32.025  1.00 25.68           O
ATOM   2259  N   TYR   159      10.033  31.018 -30.020  1.00 24.06           N
ATOM   2260  CA  TYR   159       8.952  30.186 -30.493  1.00 27.60           C
ATOM   2262  CB  TYR   159       8.260  29.459 -29.306  1.00 29.54           C
ATOM   2265  CG  TYR   159       7.790  28.047 -29.630  1.00 30.89           C
ATOM   2266  CD1 TYR   159       8.225  26.960 -28.887  1.00 34.62           C
ATOM   2268  CE1 TYR   159       7.810  25.640 -29.200  1.00 31.61           C
ATOM   2270  CZ  TYR   159       6.950  25.442 -30.270  1.00 32.11           C
ATOM   2271  OH  TYR   159       6.526  24.191 -30.591  1.00 32.03           O
ATOM   2273  CE2 TYR   159       6.505  26.511 -31.008  1.00 31.09           C
ATOM   2275  CD2 TYR   159       6.922  27.801 -30.687  1.00 32.28           C
ATOM   2277  C   TYR   159       7.914  31.020 -31.315  1.00 27.46           C
ATOM   2278  O   TYR   159       7.610  30.666 -32.438  1.00 24.86           O
ATOM   2280  N   ARG   160       7.390  32.105 -30.723  1.00 28.16           N
ATOM   2281  CA  ARG   160       6.438  33.043 -31.387  1.00 30.65           C
ATOM   2283  CB  ARG   160       6.256  34.353 -30.568  1.00 32.67           C
ATOM   2286  CG  ARG   160       5.579  34.245 -29.298  1.00 38.34           C
ATOM   2289  CD  ARG   160       5.035  35.623 -28.801  1.00 39.37           C
ATOM   2292  NE  ARG   160       6.062  36.589 -28.371  1.00 37.47           N
ATOM   2294  CZ  ARG   160       6.251  37.794 -28.928  1.00 41.02           C
ATOM   2295  NH1 ARG   160       7.182  38.603 -28.459  1.00 42.28           N
ATOM   2298  NH2 ARG   160       5.526  38.205 -29.963  1.00 44.91           N
ATOM   2301  C   ARG   160       6.978  33.499 -32.720  1.00 28.63           C
ATOM   2302  O   ARG   160       6.361  33.316 -33.785  1.00 28.79           O
ATOM   2304  N   VAL   161       8.160  34.111 -32.645  1.00 28.07           N
ATOM   2305  CA  VAL   161       8.739  34.792 -33.770  1.00 26.17           C
ATOM   2307  CB  VAL   161       9.975  35.609 -33.338  1.00 28.65           C
ATOM   2309  CG1 VAL   161      10.792  36.086 -34.588  1.00 25.14           C
ATOM   2313  CG2 VAL   161       9.546  36.776 -32.400  1.00 24.99           C
ATOM   2317  C   VAL   161       9.111  33.805 -34.851  1.00 25.91           C
ATOM   2318  O   VAL   161       8.717  33.969 -36.024  1.00 24.14           O
ATOM   2320  N   MET   162       9.870  32.779 -34.481  1.00 25.35           N
ATOM   2321  CA  MET   162      10.354  31.831 -35.492  1.00 23.81           C
ATOM   2323  CB  MET   162      11.477  30.941 -34.937  1.00 24.82           C
ATOM   2326  CG  MET   162      12.784  31.683 -34.664  1.00 26.65           C
ATOM   2329  SD  MET   162      13.523  32.548 -36.094  1.00 27.13           S
ATOM   2330  CE  MET   162      14.415  31.306 -36.974  1.00 24.57           C
ATOM   2334  C   MET   162       9.226  30.970 -36.055  1.00 21.92           C
ATOM   2335  O   MET   162       9.215  30.666 -37.242  1.00 26.41           O
ATOM   2337  N   PHE   163       8.294  30.549 -35.215  1.00 22.24           N
ATOM   2338  CA  PHE   163       7.187  29.728 -35.714  1.00 24.71           C
ATOM   2340  CB  PHE   163       6.224  29.231 -34.591  1.00 21.47           C
ATOM   2343  CG  PHE   163       5.129  28.350 -35.112  1.00 21.69           C
ATOM   2344  CD1 PHE   163       5.341  26.981 -35.292  1.00 19.78           C
ATOM   2346  CE1 PHE   163       4.349  26.168 -35.825  1.00 20.14           C
ATOM   2348  CZ  PHE   163       3.149  26.723 -36.187  1.00 22.66           C
ATOM   2350  CE2 PHE   163       2.936  28.103 -36.036  1.00 21.53           C
ATOM   2352  CD2 PHE   163       3.922  28.898 -35.523  1.00 23.70           C
ATOM   2354  C   PHE   163       6.400  30.488 -36.782  1.00 21.52           C
ATOM   2355  O   PHE   163       6.123  29.954 -37.869  1.00 23.53           O
ATOM   2357  N   GLU   164       6.046  31.724 -36.478  1.00 25.26           N
ATOM   2358  CA  GLU   164       5.256  32.512 -37.404  1.00 28.90           C
ATOM   2360  CB  GLU   164       4.823  33.822 -36.780  1.00 30.63           C
ATOM   2363  CG  GLU   164       4.038  34.702 -37.795  1.00 34.96           C
ATOM   2366  CD  GLU   164       3.277  35.848 -37.160  1.00 34.73           C
ATOM   2367  OE1 GLU   164       2.529  36.510 -37.893  1.00 38.40           O
ATOM   2368  OE2 GLU   164       3.432  36.083 -35.944  1.00 37.01           O
ATOM   2369  C   GLU   164       6.015  32.776 -38.696  1.00 27.69           C
ATOM   2370  O   GLU   164       5.462  32.607 -39.806  1.00 25.65           O
ATOM   2372  N   ALA   165       7.288  33.161 -38.553  1.00 27.49           N
ATOM   2373  CA  ALA   165       8.114  33.524 -39.694  1.00 24.41           C
ATOM   2375  CB  ALA   165       9.481  34.074 -39.211  1.00 21.48           C
ATOM   2379  C   ALA   165       8.283  32.320 -40.594  1.00 22.04           C
ATOM   2380  O   ALA   165       8.171  32.427 -41.818  1.00 28.60           O
ATOM   2382  N   GLY   166       8.569  31.184 -39.991  1.00 21.50           N
ATOM   2383  CA  GLY   166       8.787  29.923 -40.735  1.00 23.81           C
ATOM   2386  C   GLY   166       7.502  29.393 -41.351  1.00 23.14           C
ATOM   2387  O   GLY   166       7.517  28.854 -42.447  1.00 23.90           O
ATOM   2389  N   TYR   167       6.393  29.529 -40.630  1.00 27.66           N
ATOM   2390  CA  TYR   167       5.080  29.054 -41.123  1.00 28.94           C
ATOM   2392  CB  TYR   167       3.993  29.202 -40.041  1.00 32.54           C
ATOM   2395  CG  TYR   167       2.669  28.556 -40.416  1.00 33.89           C
ATOM   2396  CD1 TYR   167       2.431  27.233 -40.125  1.00 31.48           C
ATOM   2398  CE1 TYR   167       1.256  26.614 -40.479  1.00 34.41           C
ATOM   2400  CZ  TYR   167       0.272  27.319 -41.143  1.00 35.20           C
ATOM   2401  OH  TYR   167      -0.900  26.675 -41.471  1.00 37.19           O
ATOM   2403  CE2 TYR   167       0.475  28.648 -41.459  1.00 37.08           C
ATOM   2405  CD2 TYR   167       1.686  29.262 -41.095  1.00 34.26           C
ATOM   2407  C   TYR   167       4.700  29.836 -42.382  1.00 27.47           C
ATOM   2408  O   TYR   167       4.330  29.258 -43.404  1.00 26.09           O
ATOM   2410  N   LEU   168       4.823  31.145 -42.313  1.00 26.21           N
ATOM   2411  CA  LEU   168       4.410  32.018 -43.429  1.00 26.95           C
ATOM   2413  CB  LEU   168       4.347  33.482 -42.982  1.00 26.32           C
ATOM   2416  CG  LEU   168       3.277  33.873 -41.936  1.00 29.01           C
ATOM   2418  CD1 LEU   168       3.316  35.395 -41.668  1.00 27.68           C
ATOM   2422  CD2 LEU   168       1.837  33.434 -42.303  1.00 29.79           C
ATOM   2426  C   LEU   168       5.327  31.869 -44.607  1.00 25.01           C
ATOM   2427  O   LEU   168       4.885  31.928 -45.734  1.00 23.99           O
ATOM   2429  N   THR   169       6.610  31.624 -44.340  1.00 25.94           N
ATOM   2430  CA  THR   169       7.589  31.393 -45.378  1.00 23.19           C
ATOM   2432  CB  THR   169       9.028  31.396 -44.799  1.00 23.28           C
ATOM   2434  OG1 THR   169       9.305  32.665 -44.209  1.00 22.74           O
ATOM   2436  CG2 THR   169      10.040  31.127 -45.845  1.00 19.42           C
ATOM   2440  C   THR   169       7.325  30.077 -46.145  1.00 25.56           C
ATOM   2441  O   THR   169       7.438  30.028 -47.374  1.00 23.80           O
ATOM   2443  N   ILE   170       6.969  29.025 -45.435  1.00 26.30           N
ATOM   2444  CA  ILE   170       6.812  27.704 -46.062  0.50 27.19           C
ATOM   2448  CB  ILE   170       7.112  26.586 -45.080  0.50 26.70           C
ATOM   2452  CG1 ILE   170       8.585  26.627 -44.690  0.50 28.31           C
ATOM   2458  CD1 ILE   170       8.944  25.656 -43.640  0.50 25.49           C
ATOM   2466  CG2 ILE   170       6.764  25.207 -45.690  0.50 28.55           C
ATOM   2474  C   ILE   170       5.391  27.529 -46.635  1.00 26.99           C
ATOM   2475  O   ILE   170       5.223  27.013 -47.718  1.00 28.15           O
ATOM   2477  N   PHE   171       4.394  27.996 -45.889  1.00 27.39           N
ATOM   2478  CA  PHE   171       2.958  27.821 -46.220  1.00 27.97           C
ATOM   2480  CB  PHE   171       2.223  27.270 -44.983  1.00 26.36           C
ATOM   2483  CG  PHE   171       2.692  25.903 -44.615  1.00 24.34           C
ATOM   2484  CD1 PHE   171       3.609  25.716 -43.588  1.00 27.67           C
ATOM   2486  CE1 PHE   171       4.113  24.436 -43.303  1.00 29.27           C
ATOM   2488  CZ  PHE   171       3.700  23.340 -44.078  1.00 26.36           C
ATOM   2490  CE2 PHE   171       2.797  23.541 -45.132  1.00 27.34           C
ATOM   2492  CD2 PHE   171       2.320  24.813 -45.404  1.00 22.86           C
ATOM   2494  C   PHE   171       2.289  29.066 -46.761  1.00 28.16           C
ATOM   2495  O   PHE   171       1.106  29.076 -46.988  1.00 25.66           O
ATOM   2497  N   GLY   172       3.063  30.109 -47.009  1.00 32.72           N
ATOM   2498  CA  GLY   172       2.511  31.342 -47.564  1.00 35.22           C
ATOM   2501  C   GLY   172       1.547  31.982 -46.580  1.00 35.16           C
ATOM   2502  O   GLY   172       1.477  31.560 -45.435  1.00 33.85           O
ATOM   2504  N   ARG   173       0.805  32.990 -47.041  1.00 37.01           N
ATOM   2505  CA  ARG   173      -0.133  33.728 -46.198  1.00 45.04           C
ATOM   2507  CB  ARG   173       0.442  35.124 -45.766  1.00 47.06           C
ATOM   2510  CG  ARG   173       1.547  35.739 -46.664  1.00 51.73           C
ATOM   2513  CD  ARG   173       2.559  36.651 -45.877  1.00 50.87           C
ATOM   2520  C   ARG   173      -1.535  33.840 -46.830  1.00 45.54           C
ATOM   2521  O   ARG   173      -1.697  33.751 -48.056  1.00 44.16           O
ATOM   2523  N   ASP   174      -2.539  33.985 -45.965  1.00 47.59           N
ATOM   2524  CA  ASP   174      -3.913  34.212 -46.381  1.00 52.62           C
ATOM   2526  CB  ASP   174      -4.905  33.412 -45.496  1.00 56.46           C
ATOM   2529  CG  ASP   174      -6.255  33.097 -46.215  1.00 60.15           C
ATOM   2530  OD1 ASP   174      -6.546  33.690 -47.294  1.00 61.68           O
ATOM   2531  OD2 ASP   174      -7.022  32.252 -45.684  1.00 60.09           O
ATOM   2532  C   ASP   174      -4.175  35.717 -46.301  1.00 52.97           C
ATOM   2533  O   ASP   174      -4.315  36.306 -45.191  1.00 53.09           O
ATOM   2535  N   LEU   175      -4.209  36.342 -47.474  1.00 51.45           N
ATOM   2536  CA  LEU   175      -4.335  37.793 -47.575  1.00 51.70           C
ATOM   2538  CB  LEU   175      -3.532  38.295 -48.777  1.00 52.10           C
ATOM   2541  CG  LEU   175      -2.017  38.221 -48.587  1.00 51.91           C
ATOM   2543  CD1 LEU   175      -1.288  38.677 -49.844  1.00 52.51           C
ATOM   2547  CD2 LEU   175      -1.599  39.059 -47.368  1.00 50.94           C
ATOM   2551  C   LEU   175      -5.796  38.262 -47.649  1.00 51.00           C
ATOM   2552  O   LEU   175      -6.083  39.449 -47.501  1.00 53.97           O
ATOM   2554  N   THR   176      -6.710  37.326 -47.851  1.00 53.17           N
ATOM   2555  CA  THR   176      -8.140  37.614 -47.728  1.00 56.27           C
ATOM   2557  CB  THR   176      -9.022  36.435 -48.233  1.00 57.95           C
ATOM   2559  OG1 THR   176      -9.304  35.550 -47.148  1.00 59.35           O
ATOM   2561  CG2 THR   176      -8.333  35.644 -49.377  1.00 58.25           C
ATOM   2565  C   THR   176      -8.476  37.863 -46.258  1.00 56.08           C
ATOM   2566  O   THR   176      -9.317  38.694 -45.931  1.00 54.77           O
ATOM   2568  N   ARG   177      -7.774  37.135 -45.394  1.00 57.11           N
ATOM   2569  CA  ARG   177      -8.089  37.010 -43.981  1.00 59.92           C
ATOM   2571  CB  ARG   177      -7.904  35.511 -43.546  1.00 62.15           C
ATOM   2574  CG  ARG   177      -9.160  34.583 -43.654  1.00 62.57           C
ATOM   2577  CD  ARG   177      -9.352  33.933 -45.016  1.00 62.88           C
ATOM   2584  C   ARG   177      -7.189  37.887 -43.105  1.00 59.43           C
ATOM   2585  O   ARG   177      -6.906  37.511 -41.980  1.00 58.24           O
ATOM   2587  N   ARG   178      -6.739  39.041 -43.602  1.00 59.42           N
ATOM   2588  CA  ARG   178      -5.671  39.828 -42.898  1.00 59.39           C
ATOM   2590  CB  ARG   178      -5.477  41.200 -43.540  1.00 61.07           C
ATOM   2593  CG  ARG   178      -4.568  41.233 -44.729  1.00 61.16           C
ATOM   2596  CD  ARG   178      -4.544  42.644 -45.278  1.00 63.49           C
ATOM   2599  NE  ARG   178      -4.367  42.659 -46.720  1.00 64.28           N
ATOM   2601  CZ  ARG   178      -3.196  42.542 -47.329  1.00 65.34           C
ATOM   2602  NH1 ARG   178      -2.067  42.396 -46.629  1.00 67.11           N
ATOM   2605  NH2 ARG   178      -3.147  42.571 -48.645  1.00 65.58           N
ATOM   2608  C   ARG   178      -5.898  40.053 -41.400  1.00 56.59           C
ATOM   2609  O   ARG   178      -4.990  39.847 -40.590  1.00 53.51           O
ATOM   2611  N   ASP   179      -7.098  40.506 -41.050  1.00 55.05           N
ATOM   2612  CA  ASP   179      -7.409  40.899 -39.660  1.00 55.25           C
ATOM   2614  CB  ASP   179      -8.683  41.767 -39.628  1.00 59.40           C
ATOM   2617  CG  ASP   179      -9.888  41.075 -40.265  1.00 61.34           C
ATOM   2618  OD1 ASP   179      -9.701  40.368 -41.295  1.00 63.68           O
ATOM   2619  OD2 ASP   179     -11.015  41.241 -39.736  1.00 62.87           O
ATOM   2620  C   ASP   179      -7.542  39.702 -38.652  1.00 53.57           C
ATOM   2621  O   ASP   179      -7.463  39.906 -37.442  1.00 53.84           O
ATOM   2623  N   THR   180      -7.754  38.486 -39.169  1.00 48.61           N
ATOM   2624  CA  THR   180      -7.785  37.252 -38.358  1.00 47.85           C
ATOM   2626  CB  THR   180      -8.987  36.388 -38.735  1.00 45.22           C
ATOM   2628  OG1 THR   180      -8.829  35.930 -40.083  1.00 44.32           O
ATOM   2630  CG2 THR   180     -10.321  37.175 -38.603  1.00 44.28           C
ATOM   2634  C   THR   180      -6.507  36.395 -38.569  1.00 47.66           C
ATOM   2635  O   THR   180      -6.501  35.189 -38.289  1.00 47.68           O
ATOM   2637  N   GLN   181      -5.451  37.023 -39.096  1.00 46.27           N
ATOM   2638  CA  GLN   181      -4.169  36.357 -39.350  1.00 45.20           C
ATOM   2640  CB  GLN   181      -3.260  37.234 -40.221  1.00 45.96           C
ATOM   2647  C   GLN   181      -3.461  36.011 -38.044  1.00 42.60           C
ATOM   2648  O   GLN   181      -2.930  34.934 -37.922  1.00 36.75           O
ATOM   2650  N   LYS   182      -3.463  36.935 -37.080  1.00 42.89           N
ATOM   2651  CA  LYS   182      -2.882  36.678 -35.733  1.00 46.75           C
ATOM   2653  CB  LYS   182      -2.804  37.970 -34.884  1.00 47.24           C
ATOM   2656  CG  LYS   182      -1.364  38.475 -34.671  1.00 50.17           C
ATOM   2662  C   LYS   182      -3.619  35.572 -34.945  1.00 46.86           C
ATOM   2663  O   LYS   182      -2.988  34.820 -34.209  1.00 50.05           O
ATOM   2665  N   ALA   183      -4.939  35.487 -35.098  1.00 43.63           N
ATOM   2666  CA  ALA   183      -5.707  34.373 -34.537  1.00 44.93           C
ATOM   2668  CB  ALA   183      -7.201  34.607 -34.718  1.00 46.37           C
ATOM   2672  C   ALA   183      -5.307  33.010 -35.140  1.00 43.27           C
ATOM   2673  O   ALA   183      -5.044  32.057 -34.400  1.00 45.66           O
ATOM   2675  N   HIS   184      -5.270  32.919 -36.471  1.00 41.28           N
ATOM   2676  CA  HIS   184      -4.895  31.667 -37.159  1.00 40.19           C
ATOM   2678  CB  HIS   184      -4.985  31.848 -38.685  1.00 43.64           C
ATOM   2681  CG  HIS   184      -4.467  30.678 -39.505  1.00 48.01           C
ATOM   2682  ND1 HIS   184      -5.226  29.552 -39.779  1.00 51.11           N
ATOM   2684  CE1 HIS   184      -4.527  28.722 -40.546  1.00 50.78           C
ATOM   2686  NE2 HIS   184      -3.345  29.271 -40.790  1.00 49.17           N
ATOM   2688  CD2 HIS   184      -3.285  30.498 -40.164  1.00 48.94           C
ATOM   2690  C   HIS   184      -3.484  31.214 -36.700  1.00 37.76           C
ATOM   2691  O   HIS   184      -3.293  30.069 -36.321  1.00 31.71           O
ATOM   2693  N   ILE   185      -2.529  32.131 -36.689  1.00 35.36           N
ATOM   2694  CA  ILE   185      -1.133  31.791 -36.332  1.00 36.36           C
ATOM   2696  CB  ILE   185      -0.151  32.948 -36.671  1.00 38.83           C
ATOM   2698  CG1 ILE   185       0.122  32.950 -38.180  1.00 41.96           C
ATOM   2701  CD1 ILE   185       0.420  34.305 -38.734  1.00 47.57           C
ATOM   2705  CG2 ILE   185       1.225  32.801 -35.905  1.00 37.78           C
ATOM   2709  C   ILE   185      -1.016  31.346 -34.876  1.00 35.07           C
ATOM   2710  O   ILE   185      -0.403  30.362 -34.610  1.00 33.09           O
ATOM   2712  N   LEU   186      -1.640  32.071 -33.954  1.00 37.58           N
ATOM   2713  CA  LEU   186      -1.684  31.676 -32.545  1.00 39.03           C
ATOM   2715  CB  LEU   186      -2.419  32.745 -31.692  1.00 41.86           C
ATOM   2718  CG  LEU   186      -2.720  32.302 -30.248  1.00 45.01           C
ATOM   2720  CD1 LEU   186      -1.399  31.851 -29.479  1.00 47.03           C
ATOM   2724  CD2 LEU   186      -3.493  33.386 -29.484  1.00 44.56           C
ATOM   2728  C   LEU   186      -2.331  30.306 -32.317  1.00 35.32           C
ATOM   2729  O   LEU   186      -1.876  29.543 -31.444  1.00 32.47           O
ATOM   2731  N   ASN   187      -3.419  30.012 -33.040  1.00 33.15           N
ATOM   2732  CA  ASN   187      -4.023  28.661 -32.988  1.00 33.31           C
ATOM   2734  CB  ASN   187      -5.291  28.533 -33.854  1.00 34.07           C
ATOM   2737  CG  ASN   187      -6.494  29.225 -33.254  1.00 37.19           C
ATOM   2738  OD1 ASN   187      -6.492  29.595 -32.095  1.00 38.32           O
ATOM   2739  ND2 ASN   187      -7.527  29.429 -34.071  1.00 35.70           N
ATOM   2742  C   ASN   187      -3.037  27.595 -33.450  1.00 29.61           C
ATOM   2743  O   ASN   187      -2.930  26.571 -32.832  1.00 30.41           O
ATOM   2745  N   ASN   188      -2.359  27.862 -34.561  1.00 27.42           N
ATOM   2746  CA  ASN   188      -1.389  26.926 -35.162  1.00 32.79           C
ATOM   2748  CB  ASN   188      -0.862  27.453 -36.494  1.00 33.48           C
ATOM   2751  CG  ASN   188      -1.805  27.235 -37.614  1.00 39.29           C
ATOM   2752  OD1 ASN   188      -1.863  28.045 -38.535  1.00 47.90           O
ATOM   2753  ND2 ASN   188      -2.531  26.139 -37.589  1.00 40.39           N
ATOM   2756  C   ASN   188      -0.203  26.689 -34.264  1.00 28.39           C
ATOM   2757  O   ASN   188       0.215  25.568 -34.073  1.00 28.27           O
ATOM   2759  N   LEU   189       0.338  27.768 -33.735  1.00 29.27           N
ATOM   2760  CA  LEU   189       1.441  27.715 -32.795  1.00 30.95           C
ATOM   2762  CB  LEU   189       1.775  29.130 -32.344  1.00 33.78           C
ATOM   2765  CG  LEU   189       2.974  29.329 -31.427  1.00 35.24           C
ATOM   2767  CD1 LEU   189       3.604  30.641 -31.734  1.00 36.68           C
ATOM   2771  CD2 LEU   189       2.554  29.291 -30.016  1.00 39.61           C
ATOM   2775  C   LEU   189       1.095  26.829 -31.586  1.00 32.57           C
ATOM   2776  O   LEU   189       1.882  25.920 -31.208  1.00 30.89           O
ATOM   2778  N   ASP   190      -0.074  27.084 -30.998  1.00 30.09           N
ATOM   2779  CA  ASP   190      -0.531  26.331 -29.837  1.00 32.67           C
ATOM   2781  CB  ASP   190      -1.820  26.921 -29.229  1.00 39.29           C
ATOM   2784  CG  ASP   190      -2.359  26.076 -28.039  1.00 48.33           C
ATOM   2785  OD1 ASP   190      -1.525  25.598 -27.194  1.00 53.89           O
ATOM   2786  OD2 ASP   190      -3.612  25.882 -27.953  1.00 53.96           O
ATOM   2787  C   ASP   190      -0.755  24.888 -30.201  1.00 29.00           C
ATOM   2788  O   ASP   190      -0.402  24.001 -29.444  1.00 24.69           O
ATOM   2790  N   ASN   191      -1.366  24.640 -31.354  1.00 29.28           N
ATOM   2791  CA  ASN   191      -1.598  23.280 -31.766  1.00 28.97           C
ATOM   2793  CB  ASN   191      -2.502  23.222 -32.970  1.00 27.74           C
ATOM   2796  CG  ASN   191      -3.973  23.463 -32.600  1.00 30.05           C
ATOM   2797  OD1 ASN   191      -4.366  23.259 -31.467  1.00 26.12           O
ATOM   2798  ND2 ASN   191      -4.768  23.872 -33.565  1.00 27.42           N
ATOM   2801  C   ASN   191      -0.272  22.544 -32.022  1.00 28.19           C
ATOM   2802  O   ASN   191      -0.112  21.383 -31.630  1.00 26.01           O
ATOM   2804  N   PHE   192       0.664  23.239 -32.665  1.00 26.94           N
ATOM   2805  CA  PHE   192       1.978  22.671 -32.919  1.00 24.11           C
ATOM   2807  CB  PHE   192       2.839  23.596 -33.786  1.00 23.87           C
ATOM   2810  CG  PHE   192       4.154  22.996 -34.110  1.00 23.45           C
ATOM   2811  CD1 PHE   192       4.261  22.093 -35.142  1.00 21.47           C
ATOM   2813  CE1 PHE   192       5.456  21.500 -35.414  1.00 26.43           C
ATOM   2815  CZ  PHE   192       6.599  21.772 -34.611  1.00 23.38           C
ATOM   2817  CE2 PHE   192       6.501  22.633 -33.573  1.00 23.94           C
ATOM   2819  CD2 PHE   192       5.271  23.241 -33.294  1.00 19.90           C
ATOM   2821  C   PHE   192       2.705  22.311 -31.614  1.00 23.85           C
ATOM   2822  O   PHE   192       3.282  21.233 -31.523  1.00 21.22           O
ATOM   2824  N   LYS   193       2.675  23.215 -30.622  1.00 23.62           N
ATOM   2825  CA  LYS   193       3.299  22.973 -29.335  1.00 28.26           C
ATOM   2827  CB  LYS   193       3.066  24.128 -28.346  1.00 30.57           C
ATOM   2830  CG  LYS   193       3.923  25.362 -28.570  1.00 36.86           C
ATOM   2833  CD  LYS   193       4.165  26.153 -27.281  1.00 38.32           C
ATOM   2836  CE  LYS   193       4.225  27.691 -27.560  1.00 42.77           C
ATOM   2839  NZ  LYS   193       4.946  28.496 -26.509  1.00 41.07           N
ATOM   2843  C   LYS   193       2.790  21.707 -28.668  1.00 27.74           C
ATOM   2844  O   LYS   193       3.572  20.964 -28.071  1.00 26.99           O
ATOM   2846  N   GLN   194       1.477  21.516 -28.711  1.00 26.43           N
ATOM   2847  CA  GLN   194       0.814  20.382 -28.068  1.00 26.16           C
ATOM   2849  CB  GLN   194      -0.718  20.605 -27.977  1.00 29.30           C
ATOM   2852  CG  GLN   194      -1.152  21.676 -26.976  1.00 33.09           C
ATOM   2855  CD  GLN   194      -0.669  21.382 -25.575  1.00 37.82           C
ATOM   2856  OE1 GLN   194      -0.663  20.236 -25.129  1.00 44.90           O
ATOM   2857  NE2 GLN   194      -0.239  22.409 -24.877  1.00 42.67           N
ATOM   2860  C   GLN   194       1.104  19.067 -28.792  1.00 24.90           C
ATOM   2861  O   GLN   194       1.222  18.048 -28.156  1.00 23.89           O
ATOM   2863  N   PHE   195       1.232  19.107 -30.112  1.00 22.58           N
ATOM   2864  CA  PHE   195       1.568  17.903 -30.886  1.00 24.47           C
ATOM   2866  CB  PHE   195       1.205  18.108 -32.359  1.00 23.10           C
ATOM   2869  CG  PHE   195       1.794  17.074 -33.298  1.00 24.47           C
ATOM   2870  CD1 PHE   195       1.587  15.713 -33.095  1.00 24.50           C
ATOM   2872  CE1 PHE   195       2.118  14.758 -33.976  1.00 21.54           C
ATOM   2874  CZ  PHE   195       2.883  15.165 -35.036  1.00 22.88           C
ATOM   2876  CE2 PHE   195       3.098  16.537 -35.256  1.00 25.38           C
ATOM   2878  CD2 PHE   195       2.554  17.471 -34.402  1.00 26.44           C
ATOM   2880  C   PHE   195       3.065  17.544 -30.739  1.00 25.65           C
ATOM   2881  O   PHE   195       3.425  16.365 -30.499  1.00 21.88           O
ATOM   2883  N   ASP   196       3.933  18.549 -30.904  1.00 22.40           N
ATOM   2884  CA  ASP   196       5.383  18.337 -30.781  1.00 22.34           C
ATOM   2886  CB  ASP   196       6.163  19.633 -31.091  1.00 20.54           C
ATOM   2889  CG  ASP   196       7.658  19.416 -31.127  1.00 22.54           C
ATOM   2890  OD1 ASP   196       8.102  18.336 -31.595  1.00 21.21           O
ATOM   2891  OD2 ASP   196       8.393  20.300 -30.674  1.00 21.79           O
ATOM   2892  C   ASP   196       5.760  17.824 -29.383  1.00 22.69           C
ATOM   2893  O   ASP   196       6.668  17.014 -29.245  1.00 21.09           O
ATOM   2895  N   LYS   197       5.052  18.315 -28.357  1.00 23.35           N
ATOM   2896  CA  LYS   197       5.279  17.904 -26.963  1.00 23.28           C
ATOM   2898  CB  LYS   197       4.164  18.442 -26.068  1.00 25.46           C
ATOM   2901  CG  LYS   197       4.390  18.219 -24.585  1.00 30.56           C
ATOM   2904  CD  LYS   197       3.063  18.212 -23.800  1.00 36.67           C
ATOM   2907  CE  LYS   197       2.952  19.393 -22.792  1.00 39.77           C
ATOM   2910  NZ  LYS   197       2.320  18.948 -21.516  1.00 38.62           N
ATOM   2914  C   LYS   197       5.386  16.386 -26.770  1.00 22.39           C
ATOM   2915  O   LYS   197       6.257  15.904 -26.036  1.00 24.07           O
ATOM   2917  N   VAL   198       4.493  15.644 -27.415  1.00 21.99           N
ATOM   2918  CA  VAL   198       4.367  14.205 -27.193  1.00 19.98           C
ATOM   2920  CB  VAL   198       2.859  13.732 -27.224  1.00 19.20           C
ATOM   2922  CG1 VAL   198       1.937  14.674 -26.372  1.00 20.69           C
ATOM   2926  CG2 VAL   198       2.343  13.540 -28.665  1.00 23.48           C
ATOM   2930  C   VAL   198       5.130  13.406 -28.207  1.00 21.48           C
ATOM   2931  O   VAL   198       5.174  12.170 -28.124  1.00 22.00           O
ATOM   2933  N   PHE   199       5.752  14.087 -29.171  1.00 22.92           N
ATOM   2934  CA  PHE   199       6.504  13.411 -30.262  1.00 24.79           C
ATOM   2936  CB  PHE   199       7.218  14.468 -31.147  1.00 24.09           C
ATOM   2939  CG  PHE   199       7.359  14.050 -32.583  1.00 23.66           C
ATOM   2940  CD1 PHE   199       6.347  14.313 -33.503  1.00 24.98           C
ATOM   2942  CE1 PHE   199       6.487  13.938 -34.835  1.00 26.56           C
ATOM   2944  CZ  PHE   199       7.643  13.278 -35.253  1.00 22.71           C
ATOM   2946  CE2 PHE   199       8.651  13.013 -34.333  1.00 21.08           C
ATOM   2948  CD2 PHE   199       8.503  13.395 -33.024  1.00 24.39           C
ATOM   2950  C   PHE   199       7.535  12.300 -29.854  1.00 23.71           C
ATOM   2951  O   PHE   199       7.666  11.256 -30.561  1.00 21.69           O
ATOM   2953  N   PRO   200       8.293  12.516 -28.762  1.00 24.50           N
ATOM   2954  CA  PRO   200       9.223  11.447 -28.361  1.00 27.17           C
ATOM   2956  CB  PRO   200       9.837  11.987 -27.066  1.00 26.63           C
ATOM   2959  CG  PRO   200       9.628  13.475 -27.118  1.00 27.08           C
ATOM   2962  CD  PRO   200       8.342  13.662 -27.838  1.00 25.70           C
ATOM   2965  C   PRO   200       8.485  10.100 -28.073  1.00 27.89           C
ATOM   2966  O   PRO   200       9.004   9.028 -28.338  1.00 26.08           O
ATOM   2967  N   ALA   201       7.283  10.207 -27.521  1.00 26.49           N
ATOM   2968  CA  ALA   201       6.442   9.061 -27.235  1.00 26.25           C
ATOM   2970  CB  ALA   201       5.297   9.449 -26.299  1.00 22.87           C
ATOM   2974  C   ALA   201       5.920   8.443 -28.524  1.00 25.04           C
ATOM   2975  O   ALA   201       5.959   7.219 -28.680  1.00 28.18           O
ATOM   2977  N   LEU   202       5.487   9.275 -29.472  1.00 28.15           N
ATOM   2978  CA  LEU   202       4.911   8.775 -30.737  1.00 28.96           C
ATOM   2980  CB  LEU   202       4.391   9.921 -31.572  1.00 29.57           C
ATOM   2983  CG  LEU   202       3.306  10.816 -30.993  1.00 30.02           C
ATOM   2985  CD1 LEU   202       2.733  11.617 -32.097  1.00 30.28           C
ATOM   2989  CD2 LEU   202       2.205  10.044 -30.312  1.00 31.99           C
ATOM   2993  C   LEU   202       5.877   7.941 -31.582  1.00 30.42           C
ATOM   2994  O   LEU   202       5.515   6.892 -32.131  1.00 31.02           O
ATOM   2996  N   VAL   203       7.100   8.431 -31.692  1.00 31.24           N
ATOM   2997  CA  VAL   203       8.193   7.749 -32.385  1.00 30.25           C
ATOM   2999  CB  VAL   203       9.472   8.626 -32.303  1.00 34.18           C
ATOM   3001  CG1 VAL   203      10.719   7.793 -32.515  1.00 40.81           C
ATOM   3005  CG2 VAL   203       9.366   9.791 -33.307  1.00 31.28           C
ATOM   3009  C   VAL   203       8.487   6.370 -31.828  1.00 30.47           C
ATOM   3010  O   VAL   203       8.899   5.449 -32.552  1.00 31.67           O
ATOM   3012  N   ALA   204       8.255   6.241 -30.534  1.00 31.84           N
ATOM   3013  CA  ALA   204       8.499   5.038 -29.774  1.00 31.93           C
ATOM   3015  CB  ALA   204       8.708   5.431 -28.313  1.00 27.30           C
ATOM   3019  C   ALA   204       7.374   3.981 -29.868  1.00 29.77           C
ATOM   3020  O   ALA   204       7.535   2.884 -29.360  1.00 28.90           O
ATOM   3022  N   GLY   205       6.235   4.328 -30.474  1.00 31.04           N
ATOM   3023  CA  GLY   205       5.141   3.374 -30.695  1.00 29.45           C
ATOM   3026  C   GLY   205       4.034   3.539 -29.697  1.00 30.84           C
ATOM   3027  O   GLY   205       3.086   2.718 -29.663  1.00 28.92           O
ATOM   3029  N   LEU   206       4.133   4.584 -28.866  1.00 26.97           N
ATOM   3030  CA  LEU   206       3.059   4.885 -27.915  1.00 27.11           C
ATOM   3032  CB  LEU   206       3.521   5.777 -26.763  1.00 26.54           C
ATOM   3035  CG  LEU   206       4.316   5.097 -25.641  1.00 26.63           C
ATOM   3037  CD1 LEU   206       5.749   4.714 -26.083  1.00 26.35           C
ATOM   3041  CD2 LEU   206       4.320   5.925 -24.391  1.00 24.77           C
ATOM   3045  C   LEU   206       1.911   5.557 -28.683  1.00 28.38           C
ATOM   3046  O   LEU   206       2.155   6.365 -29.571  1.00 28.72           O
ATOM   3048  N   PRO   207       0.662   5.207 -28.341  1.00 27.14           N
ATOM   3049  CA  PRO   207      -0.480   5.649 -29.166  1.00 29.10           C
ATOM   3051  CB  PRO   207      -1.620   4.722 -28.724  1.00 26.72           C
ATOM   3054  CG  PRO   207      -1.344   4.432 -27.259  1.00 26.24           C
ATOM   3057  CD  PRO   207       0.229   4.406 -27.168  1.00 27.19           C
ATOM   3060  C   PRO   207      -0.836   7.109 -28.923  1.00 26.80           C
ATOM   3061  O   PRO   207      -0.850   7.563 -27.785  1.00 28.54           O
ATOM   3062  N   ILE   208      -1.101   7.837 -29.995  1.00 29.29           N
ATOM   3063  CA  ILE   208      -1.433   9.256 -29.887  1.00 30.80           C
ATOM   3065  CB  ILE   208      -1.424   9.955 -31.288  1.00 30.65           C
ATOM   3067  CG1 ILE   208      -1.259  11.479 -31.089  1.00 29.64           C
ATOM   3070  CD1 ILE   208      -1.317  12.255 -32.323  1.00 30.67           C
ATOM   3074  CG2 ILE   208      -2.663   9.523 -32.146  1.00 30.35           C
ATOM   3078  C   ILE   208      -2.727   9.535 -29.072  1.00 29.80           C
ATOM   3079  O   ILE   208      -2.846  10.570 -28.409  1.00 31.21           O
ATOM   3081  N   HIS   209      -3.657   8.588 -29.057  1.00 33.97           N
ATOM   3082  CA  HIS   209      -4.905   8.758 -28.282  1.00 34.09           C
ATOM   3084  CB  HIS   209      -6.011   7.827 -28.798  1.00 38.05           C
ATOM   3087  CG  HIS   209      -5.802   6.384 -28.462  1.00 38.83           C
ATOM   3088  ND1 HIS   209      -5.145   5.517 -29.304  1.00 39.89           N
ATOM   3090  CE1 HIS   209      -5.112   4.315 -28.753  1.00 41.22           C
ATOM   3092  NE2 HIS   209      -5.720   4.375 -27.579  1.00 42.44           N
ATOM   3094  CD2 HIS   209      -6.164   5.659 -27.375  1.00 40.46           C
ATOM   3096  C   HIS   209      -4.713   8.599 -26.778  1.00 33.35           C
ATOM   3097  O   HIS   209      -5.638   8.822 -26.019  1.00 34.23           O
ATOM   3099  N   MET   210      -3.498   8.219 -26.354  1.00 31.80           N
ATOM   3100  CA  MET   210      -3.075   8.320 -24.941  1.00 30.00           C
ATOM   3102  CB  MET   210      -1.791   7.505 -24.761  1.00 35.10           C
ATOM   3105  CG  MET   210      -1.026   7.617 -23.465  1.00 41.10           C
ATOM   3108  SD  MET   210       0.466   6.500 -23.549  1.00 42.98           S
ATOM   3109  CE  MET   210      -0.265   5.026 -22.813  1.00 45.13           C
ATOM   3113  C   MET   210      -2.879   9.791 -24.585  1.00 25.41           C
ATOM   3114  O   MET   210      -2.771  10.153 -23.412  1.00 26.15           O
ATOM   3116  N   PHE   211      -2.878  10.638 -25.606  1.00 23.01           N
ATOM   3117  CA  PHE   211      -2.598  12.062 -25.479  1.00 27.49           C
ATOM   3119  CB  PHE   211      -1.239  12.359 -26.155  1.00 24.01           C
ATOM   3122  CG  PHE   211      -0.106  11.557 -25.606  1.00 23.21           C
ATOM   3123  CD1 PHE   211       0.516  10.582 -26.381  1.00 24.25           C
ATOM   3125  CE1 PHE   211       1.574   9.852 -25.885  1.00 21.87           C
ATOM   3127  CZ  PHE   211       2.021  10.078 -24.576  1.00 22.65           C
ATOM   3129  CE2 PHE   211       1.430  11.050 -23.812  1.00 24.49           C
ATOM   3131  CD2 PHE   211       0.358  11.784 -24.319  1.00 22.92           C
ATOM   3133  C   PHE   211      -3.690  12.868 -26.163  1.00 28.93           C
ATOM   3134  O   PHE   211      -3.469  13.419 -27.248  1.00 29.76           O
ATOM   3136  N   ARG   212      -4.864  12.943 -25.530  1.00 31.43           N
ATOM   3137  CA  ARG   212      -6.080  13.450 -26.191  1.00 33.04           C
ATOM   3139  CB  ARG   212      -7.289  13.478 -25.199  1.00 35.37           C
ATOM   3142  CG  ARG   212      -8.617  14.038 -25.797  1.00 36.46           C
ATOM   3145  CD  ARG   212      -9.712  14.287 -24.698  1.00 36.50           C
ATOM   3152  C   ARG   212      -5.875  14.830 -26.798  1.00 28.30           C
ATOM   3153  O   ARG   212      -6.247  15.069 -27.929  1.00 26.70           O
ATOM   3155  N   THR   213      -5.285  15.721 -26.015  1.00 29.40           N
ATOM   3156  CA  THR   213      -4.977  17.076 -26.441  1.00 31.20           C
ATOM   3158  CB  THR   213      -4.345  17.830 -25.317  1.00 30.57           C
ATOM   3160  OG1 THR   213      -5.294  17.938 -24.274  1.00 35.39           O
ATOM   3162  CG2 THR   213      -3.899  19.227 -25.772  1.00 31.82           C
ATOM   3166  C   THR   213      -4.004  17.138 -27.617  1.00 28.10           C
ATOM   3167  O   THR   213      -4.201  17.877 -28.546  1.00 31.60           O
ATOM   3169  N   ALA   214      -2.964  16.349 -27.548  1.00 25.19           N
ATOM   3170  CA  ALA   214      -1.964  16.316 -28.630  1.00 26.65           C
ATOM   3172  CB  ALA   214      -0.757  15.505 -28.204  1.00 22.34           C
ATOM   3176  C   ALA   214      -2.595  15.746 -29.895  1.00 24.58           C
ATOM   3177  O   ALA   214      -2.287  16.188 -31.009  1.00 20.88           O
ATOM   3179  N   HIS   215      -3.487  14.769 -29.708  1.00 22.45           N
ATOM   3180  CA  HIS   215      -4.176  14.107 -30.833  1.00 22.18           C
ATOM   3182  CB  HIS   215      -4.957  12.917 -30.304  1.00 24.23           C
ATOM   3185  CG  HIS   215      -5.467  12.004 -31.361  1.00 24.69           C
ATOM   3186  ND1 HIS   215      -5.138  12.137 -32.695  1.00 27.26           N
ATOM   3188  CE1 HIS   215      -5.705  11.155 -33.382  1.00 27.25           C
ATOM   3190  NE2 HIS   215      -6.387  10.399 -32.540  1.00 26.35           N
ATOM   3192  CD2 HIS   215      -6.252  10.909 -31.273  1.00 25.55           C
ATOM   3194  C   HIS   215      -5.102  15.067 -31.573  1.00 24.10           C
ATOM   3195  O   HIS   215      -5.111  15.104 -32.790  1.00 26.99           O
ATOM   3197  N   ASN   216      -5.882  15.835 -30.822  1.00 24.82           N
ATOM   3198  CA  ASN   216      -6.727  16.852 -31.394  1.00 28.46           C
ATOM   3200  CB  ASN   216      -7.606  17.488 -30.299  1.00 32.22           C
ATOM   3203  CG  ASN   216      -8.651  16.508 -29.740  1.00 38.76           C
ATOM   3204  OD1 ASN   216      -8.964  15.477 -30.372  1.00 43.62           O
ATOM   3205  ND2 ASN   216      -9.189  16.823 -28.563  1.00 37.88           N
ATOM   3208  C   ASN   216      -5.913  17.921 -32.078  1.00 27.84           C
ATOM   3209  O   ASN   216      -6.247  18.328 -33.174  1.00 26.09           O
ATOM   3211  N   ALA   217      -4.847  18.384 -31.406  1.00 27.53           N
ATOM   3212  CA  ALA   217      -3.873  19.343 -31.980  1.00 23.72           C
ATOM   3214  CB  ALA   217      -2.699  19.588 -30.991  1.00 22.24           C
ATOM   3218  C   ALA   217      -3.358  18.863 -33.306  1.00 22.60           C
ATOM   3219  O   ALA   217      -3.438  19.583 -34.293  1.00 22.62           O
ATOM   3221  N   ARG   218      -2.875  17.620 -33.363  1.00 21.81           N
ATOM   3222  CA  ARG   218      -2.390  17.071 -34.628  1.00 24.11           C
ATOM   3224  CB  ARG   218      -1.955  15.607 -34.503  1.00 23.89           C
ATOM   3227  CG  ARG   218      -1.271  15.102 -35.742  1.00 24.83           C
ATOM   3230  CD  ARG   218      -0.873  13.688 -35.619  1.00 29.54           C
ATOM   3233  NE  ARG   218      -1.981  12.769 -35.855  1.00 30.04           N
ATOM   3235  CZ  ARG   218      -1.889  11.438 -35.751  1.00 30.87           C
ATOM   3236  NH1 ARG   218      -0.752  10.859 -35.374  1.00 30.34           N
ATOM   3239  NH2 ARG   218      -2.954  10.680 -35.987  1.00 32.01           N
ATOM   3242  C   ARG   218      -3.409  17.146 -35.755  1.00 27.02           C
ATOM   3243  O   ARG   218      -3.060  17.465 -36.913  1.00 25.60           O
ATOM   3245  N   GLU   219      -4.642  16.765 -35.454  1.00 29.10           N
ATOM   3246  CA  GLU   219      -5.672  16.656 -36.501  1.00 29.50           C
ATOM   3248  CB  GLU   219      -6.802  15.746 -36.021  1.00 32.67           C
ATOM   3251  CG  GLU   219      -6.324  14.313 -35.766  1.00 31.06           C
ATOM   3254  CD  GLU   219      -5.608  13.707 -36.951  1.00 34.62           C
ATOM   3255  OE1 GLU   219      -6.053  13.909 -38.093  1.00 33.39           O
ATOM   3256  OE2 GLU   219      -4.567  13.024 -36.743  1.00 36.02           O
ATOM   3257  C   GLU   219      -6.162  18.035 -36.936  1.00 26.31           C
ATOM   3258  O   GLU   219      -6.425  18.279 -38.125  1.00 23.89           O
ATOM   3260  N   LYS   220      -6.213  18.952 -35.992  1.00 26.70           N
ATOM   3261  CA  LYS   220      -6.475  20.336 -36.318  1.00 30.27           C
ATOM   3263  CB  LYS   220      -6.638  21.135 -35.037  1.00 32.11           C
ATOM   3266  CG  LYS   220      -7.908  20.804 -34.260  1.00 33.63           C
ATOM   3269  CD  LYS   220      -7.990  21.692 -33.005  1.00 35.65           C
ATOM   3272  CE  LYS   220      -9.293  21.507 -32.225  1.00 40.69           C
ATOM   3275  NZ  LYS   220      -9.166  21.928 -30.739  1.00 41.41           N
ATOM   3279  C   LYS   220      -5.372  20.943 -37.239  1.00 30.82           C
ATOM   3280  O   LYS   220      -5.685  21.635 -38.216  1.00 29.96           O
ATOM   3282  N   LEU   221      -4.090  20.688 -36.946  1.00 27.00           N
ATOM   3283  CA  LEU   221      -3.009  21.135 -37.860  1.00 24.95           C
ATOM   3285  CB  LEU   221      -1.608  20.746 -37.340  1.00 25.21           C
ATOM   3288  CG  LEU   221      -1.158  21.454 -36.071  1.00 21.55           C
ATOM   3290  CD1 LEU   221      -0.034  20.675 -35.366  1.00 18.92           C
ATOM   3294  CD2 LEU   221      -0.746  22.895 -36.432  1.00 22.15           C
ATOM   3298  C   LEU   221      -3.206  20.519 -39.224  1.00 21.24           C
ATOM   3299  O   LEU   221      -3.169  21.206 -40.208  1.00 30.28           O
ATOM   3301  N   ALA   222      -3.432  19.212 -39.277  1.00 28.00           N
ATOM   3302  CA  ALA   222      -3.636  18.509 -40.549  1.00 27.32           C
ATOM   3304  CB  ALA   222      -3.910  17.090 -40.295  1.00 27.83           C
ATOM   3308  C   ALA   222      -4.794  19.132 -41.341  1.00 30.57           C
ATOM   3309  O   ALA   222      -4.685  19.347 -42.552  1.00 27.72           O
ATOM   3311  N   GLU   223      -5.891  19.444 -40.644  1.00 32.46           N
ATOM   3312  CA  GLU   223      -7.063  20.057 -41.285  1.00 32.39           C
ATOM   3314  CB  GLU   223      -8.173  20.367 -40.256  1.00 34.13           C
ATOM   3317  CG  GLU   223      -9.413  21.142 -40.821  1.00 36.50           C
ATOM   3320  CD  GLU   223     -10.233  20.357 -41.856  1.00 40.55           C
ATOM   3321  OE1 GLU   223     -11.017  21.018 -42.595  1.00 44.82           O
ATOM   3322  OE2 GLU   223     -10.112  19.104 -41.934  1.00 43.41           O
ATOM   3323  C   GLU   223      -6.655  21.327 -42.016  1.00 30.96           C
ATOM   3324  O   GLU   223      -6.987  21.492 -43.185  1.00 27.87           O
ATOM   3326  N   SER   224      -5.909  22.192 -41.321  1.00 30.52           N
ATOM   3327  CA  SER   224      -5.456  23.482 -41.855  1.00 32.18           C
ATOM   3329  CB  SER   224      -4.828  24.335 -40.730  1.00 35.07           C
ATOM   3332  OG  SER   224      -3.650  23.705 -40.194  1.00 39.88           O
ATOM   3334  C   SER   224      -4.471  23.342 -43.022  1.00 32.65           C
ATOM   3335  O   SER   224      -4.211  24.316 -43.734  1.00 31.03           O
ATOM   3337  N   LEU   225      -3.941  22.128 -43.217  1.00 32.35           N
ATOM   3338  CA  LEU   225      -2.953  21.863 -44.243  1.00 30.36           C
ATOM   3340  CB  LEU   225      -1.721  21.171 -43.618  1.00 31.51           C
ATOM   3343  CG  LEU   225      -0.895  22.006 -42.613  1.00 28.05           C
ATOM   3345  CD1 LEU   225       0.312  21.257 -42.141  1.00 24.64           C
ATOM   3349  CD2 LEU   225      -0.475  23.312 -43.224  1.00 27.42           C
ATOM   3353  C   LEU   225      -3.527  21.042 -45.424  1.00 31.87           C
ATOM   3354  O   LEU   225      -2.764  20.569 -46.287  1.00 30.97           O
ATOM   3356  N   ARG   226      -4.867  20.905 -45.475  1.00 32.01           N
ATOM   3357  CA  ARG   226      -5.544  20.228 -46.579  1.00 33.01           C
ATOM   3359  CB  ARG   226      -7.052  20.076 -46.306  1.00 35.18           C
ATOM   3362  CG  ARG   226      -7.401  18.969 -45.346  1.00 38.05           C
ATOM   3365  CD  ARG   226      -8.902  18.900 -45.104  1.00 42.57           C
ATOM   3368  NE  ARG   226      -9.233  17.752 -44.252  1.00 47.85           N
ATOM   3370  CZ  ARG   226      -9.515  16.523 -44.692  1.00 48.88           C
ATOM   3371  NH1 ARG   226      -9.530  16.236 -46.004  1.00 52.26           N
ATOM   3374  NH2 ARG   226      -9.784  15.565 -43.807  1.00 46.59           N
ATOM   3377  C   ARG   226      -5.342  21.078 -47.792  1.00 30.58           C
ATOM   3378  O   ARG   226      -5.254  22.290 -47.668  1.00 31.05           O
ATOM   3380  N   HIS   227      -5.248  20.465 -48.969  1.00 32.22           N
ATOM   3381  CA  HIS   227      -5.021  21.254 -50.206  1.00 33.62           C
ATOM   3383  CB  HIS   227      -4.956  20.355 -51.432  1.00 36.13           C
ATOM   3386  CG  HIS   227      -3.699  19.529 -51.516  1.00 37.63           C
ATOM   3387  ND1 HIS   227      -3.159  19.123 -52.714  1.00 35.69           N
ATOM   3389  CE1 HIS   227      -2.075  18.404 -52.485  1.00 36.35           C
ATOM   3391  NE2 HIS   227      -1.874  18.351 -51.178  1.00 36.71           N
ATOM   3393  CD2 HIS   227      -2.867  19.058 -50.549  1.00 37.16           C
ATOM   3395  C   HIS   227      -6.073  22.368 -50.389  1.00 35.39           C
ATOM   3396  O   HIS   227      -5.727  23.508 -50.757  1.00 31.52           O
ATOM   3398  N   GLU   228      -7.334  22.043 -50.094  1.00 35.54           N
ATOM   3399  CA  GLU   228      -8.438  23.012 -50.127  1.00 36.74           C
ATOM   3401  CB  GLU   228      -9.698  22.401 -49.475  1.00 36.28           C
ATOM   3408  C   GLU   228      -8.077  24.311 -49.417  1.00 34.29           C
ATOM   3409  O   GLU   228      -8.345  25.397 -49.921  1.00 36.86           O
ATOM   3411  N   ASN   229      -7.445  24.200 -48.247  1.00 35.17           N
ATOM   3412  CA  ASN   229      -7.067  25.382 -47.445  1.00 33.26           C
ATOM   3414  CB  ASN   229      -7.027  25.017 -45.976  1.00 34.34           C
ATOM   3417  CG  ASN   229      -8.400  24.776 -45.401  1.00 37.60           C
ATOM   3418  OD1 ASN   229      -9.399  25.320 -45.895  1.00 39.29           O
ATOM   3419  ND2 ASN   229      -8.464  23.987 -44.336  1.00 33.58           N
ATOM   3422  C   ASN   229      -5.723  26.029 -47.864  1.00 31.80           C
ATOM   3423  O   ASN   229      -5.531  27.239 -47.726  1.00 30.84           O
ATOM   3425  N   LEU   230      -4.809  25.212 -48.347  1.00 31.24           N
ATOM   3426  CA  LEU   230      -3.549  25.709 -48.877  1.00 34.44           C
ATOM   3428  CB  LEU   230      -2.554  24.565 -49.046  1.00 30.90           C
ATOM   3431  CG  LEU   230      -1.968  23.969 -47.746  1.00 28.77           C
ATOM   3433  CD1 LEU   230      -0.875  23.005 -48.111  1.00 27.29           C
ATOM   3437  CD2 LEU   230      -1.440  25.088 -46.772  1.00 24.58           C
ATOM   3441  C   LEU   230      -3.734  26.481 -50.202  1.00 36.44           C
ATOM   3442  O   LEU   230      -3.009  27.421 -50.452  1.00 33.42           O
ATOM   3444  N   GLN   231      -4.734  26.105 -51.019  1.00 39.32           N
ATOM   3445  CA  GLN   231      -5.055  26.856 -52.272  1.00 41.26           C
ATOM   3447  CB  GLN   231      -6.072  26.086 -53.105  1.00 44.34           C
ATOM   3450  CG  GLN   231      -5.453  24.907 -53.836  1.00 48.22           C
ATOM   3453  CD  GLN   231      -6.453  23.816 -54.136  1.00 53.43           C
ATOM   3454  OE1 GLN   231      -7.688  24.028 -54.057  1.00 56.66           O
ATOM   3455  NE2 GLN   231      -5.942  22.630 -54.479  1.00 54.20           N
ATOM   3458  C   GLN   231      -5.553  28.298 -52.060  1.00 41.15           C
ATOM   3459  O   GLN   231      -5.504  29.113 -52.967  1.00 45.45           O
ATOM   3461  N   LYS   232      -6.028  28.607 -50.873  1.00 39.50           N
ATOM   3462  CA  LYS   232      -6.414  29.972 -50.540  1.00 42.73           C
ATOM   3464  CB  LYS   232      -7.332  29.988 -49.301  1.00 44.70           C
ATOM   3467  CG  LYS   232      -8.547  29.062 -49.352  1.00 43.81           C
ATOM   3470  CD  LYS   232      -9.146  28.897 -47.943  1.00 46.12           C
ATOM   3475  C   LYS   232      -5.205  30.871 -50.242  1.00 40.00           C
ATOM   3476  O   LYS   232      -5.367  32.070 -50.057  1.00 40.54           O
ATOM   3478  N   ARG   233      -4.006  30.283 -50.167  1.00 40.29           N
ATOM   3479  CA  ARG   233      -2.831  30.981 -49.663  1.00 38.04           C
ATOM   3481  CB  ARG   233      -2.019  30.088 -48.709  1.00 37.01           C
ATOM   3484  CG  ARG   233      -2.795  29.636 -47.482  1.00 37.58           C
ATOM   3487  CD  ARG   233      -1.929  28.881 -46.447  1.00 36.63           C
ATOM   3490  NE  ARG   233      -1.246  29.800 -45.522  1.00 33.76           N
ATOM   3492  CZ  ARG   233      -1.824  30.422 -44.498  1.00 32.98           C
ATOM   3493  NH1 ARG   233      -3.109  30.237 -44.220  1.00 34.68           N
ATOM   3496  NH2 ARG   233      -1.116  31.238 -43.737  1.00 35.55           N
ATOM   3499  C   ARG   233      -1.958  31.400 -50.801  1.00 38.98           C
ATOM   3500  O   ARG   233      -1.894  30.710 -51.819  1.00 37.54           O
ATOM   3502  N   GLU   234      -1.247  32.510 -50.600  1.00 41.60           N
ATOM   3503  CA  GLU   234      -0.350  33.069 -51.597  1.00 45.56           C
ATOM   3505  CB  GLU   234      -0.793  34.489 -51.934  1.00 47.76           C
ATOM   3508  CG  GLU   234      -1.960  34.540 -52.892  1.00 51.36           C
ATOM   3511  CD  GLU   234      -2.603  35.921 -52.985  1.00 53.41           C
ATOM   3512  OE1 GLU   234      -1.876  36.954 -52.852  1.00 51.88           O
ATOM   3513  OE2 GLU   234      -3.852  35.961 -53.200  1.00 60.43           O
ATOM   3514  C   GLU   234       1.091  33.096 -51.121  1.00 44.56           C
ATOM   3515  O   GLU   234       1.360  33.083 -49.948  1.00 44.21           O
ATOM   3517  N   SER   235       2.010  33.200 -52.071  1.00 47.88           N
ATOM   3518  CA  SER   235       3.452  33.085 -51.820  1.00 47.65           C
ATOM   3520  CB  SER   235       4.047  34.397 -51.259  1.00 51.54           C
ATOM   3523  OG  SER   235       3.252  34.961 -50.249  1.00 54.06           O
ATOM   3525  C   SER   235       3.794  31.853 -50.965  1.00 44.87           C
ATOM   3526  O   SER   235       4.568  31.928 -50.000  1.00 46.20           O
ATOM   3528  N   ILE   236       3.173  30.729 -51.344  1.00 40.30           N
ATOM   3529  CA  ILE   236       3.518  29.423 -50.848  1.00 39.59           C
ATOM   3531  CB  ILE   236       2.562  28.328 -51.398  1.00 38.93           C
ATOM   3533  CG1 ILE   236       1.149  28.503 -50.859  1.00 42.41           C
ATOM   3536  CD1 ILE   236       0.124  27.557 -51.557  1.00 43.52           C
ATOM   3540  CG2 ILE   236       3.014  26.934 -51.009  1.00 40.87           C
ATOM   3544  C   ILE   236       4.931  29.112 -51.319  1.00 37.87           C
ATOM   3545  O   ILE   236       5.312  29.453 -52.449  1.00 35.31           O
ATOM   3547  N   SER   237       5.705  28.454 -50.463  1.00 36.73           N
ATOM   3548  CA  SER   237       7.056  27.999 -50.837  1.00 34.62           C
ATOM   3550  CB  SER   237       7.732  27.200 -49.696  1.00 32.71           C
ATOM   3553  OG  SER   237       7.054  25.994 -49.390  1.00 28.24           O
ATOM   3555  C   SER   237       6.972  27.150 -52.056  1.00 33.97           C
ATOM   3556  O   SER   237       5.955  26.544 -52.315  1.00 37.41           O
ATOM   3558  N   GLU   238       8.047  27.111 -52.818  1.00 35.84           N
ATOM   3559  CA  GLU   238       8.164  26.162 -53.906  1.00 36.68           C
ATOM   3561  CB  GLU   238       9.458  26.431 -54.704  1.00 38.41           C
ATOM   3564  CG  GLU   238       9.774  25.388 -55.780  1.00 41.75           C
ATOM   3570  C   GLU   238       8.108  24.713 -53.385  1.00 34.60           C
ATOM   3571  O   GLU   238       7.580  23.837 -54.069  1.00 36.71           O
ATOM   3573  N   LEU   239       8.668  24.447 -52.189  1.00 31.77           N
ATOM   3574  CA  LEU   239       8.605  23.106 -51.590  1.00 31.33           C
ATOM   3576  CB  LEU   239       9.271  23.089 -50.193  1.00 33.37           C
ATOM   3579  CG  LEU   239       9.041  21.872 -49.273  1.00 32.06           C
ATOM   3581  CD1 LEU   239       9.481  20.555 -49.917  1.00 35.06           C
ATOM   3585  CD2 LEU   239       9.732  22.061 -47.959  1.00 31.80           C
ATOM   3589  C   LEU   239       7.157  22.590 -51.469  1.00 30.60           C
ATOM   3590  O   LEU   239       6.871  21.457 -51.828  1.00 26.46           O
ATOM   3592  N   ILE   240       6.269  23.423 -50.924  1.00 29.12           N
ATOM   3593  CA  ILE   240       4.896  23.016 -50.679  1.00 30.37           C
ATOM   3595  CB  ILE   240       4.237  23.835 -49.535  1.00 28.38           C
ATOM   3597  CG1 ILE   240       4.936  23.520 -48.195  1.00 27.93           C
ATOM   3600  CD1 ILE   240       4.991  22.079 -47.833  1.00 21.89           C
ATOM   3604  CG2 ILE   240       2.726  23.522 -49.406  1.00 28.75           C
ATOM   3608  C   ILE   240       4.063  23.039 -51.984  1.00 30.78           C
ATOM   3609  O   ILE   240       3.250  22.148 -52.202  1.00 32.68           O
ATOM   3611  N   SER   241       4.300  23.994 -52.860  1.00 31.06           N
ATOM   3612  CA  SER   241       3.589  23.998 -54.147  1.00 36.41           C
ATOM   3614  CB  SER   241       3.866  25.271 -54.914  1.00 40.30           C
ATOM   3617  OG  SER   241       5.175  25.233 -55.401  1.00 49.01           O
ATOM   3619  C   SER   241       3.941  22.762 -54.988  1.00 34.73           C
ATOM   3620  O   SER   241       3.067  22.155 -55.613  1.00 32.70           O
ATOM   3622  N   LEU   242       5.212  22.361 -54.969  1.00 34.18           N
ATOM   3623  CA  LEU   242       5.618  21.138 -55.648  1.00 35.21           C
ATOM   3625  CB  LEU   242       7.150  21.067 -55.809  1.00 34.93           C
ATOM   3628  CG  LEU   242       7.716  19.792 -56.445  1.00 36.90           C
ATOM   3630  CD1 LEU   242       7.045  19.468 -57.777  1.00 39.57           C
ATOM   3634  CD2 LEU   242       9.232  19.902 -56.637  1.00 36.07           C
ATOM   3638  C   LEU   242       5.093  19.901 -54.950  1.00 35.15           C
ATOM   3639  O   LEU   242       4.684  18.943 -55.604  1.00 36.33           O
ATOM   3641  N   ARG   243       5.122  19.892 -53.620  1.00 34.56           N
ATOM   3642  CA  ARG   243       4.642  18.718 -52.879  1.00 34.18           C
ATOM   3644  CB  ARG   243       4.975  18.855 -51.386  1.00 33.83           C
ATOM   3647  CG  ARG   243       6.443  18.589 -51.075  1.00 32.95           C
ATOM   3650  CD  ARG   243       6.699  17.216 -50.511  1.00 33.47           C
ATOM   3653  NE  ARG   243       6.011  16.146 -51.225  1.00 34.87           N
ATOM   3655  CZ  ARG   243       4.864  15.572 -50.844  1.00 35.01           C
ATOM   3656  NH1 ARG   243       4.362  14.592 -51.567  1.00 36.18           N
ATOM   3659  NH2 ARG   243       4.205  15.976 -49.779  1.00 35.02           N
ATOM   3662  C   ARG   243       3.127  18.520 -53.084  1.00 32.63           C
ATOM   3663  O   ARG   243       2.650  17.392 -53.100  1.00 33.83           O
ATOM   3665  N   MET   244       2.391  19.621 -53.211  1.00 35.12           N
ATOM   3666  CA  MET   244       0.967  19.573 -53.586  1.00 37.80           C
ATOM   3668  CB  MET   244       0.342  20.965 -53.582  1.00 35.39           C
ATOM   3671  CG  MET   244       0.049  21.508 -52.215  1.00 35.06           C
ATOM   3674  SD  MET   244      -0.407  23.251 -52.180  1.00 40.53           S
ATOM   3675  CE  MET   244      -2.191  23.151 -52.375  1.00 39.72           C
ATOM   3679  C   MET   244       0.836  18.951 -54.976  1.00 41.22           C
ATOM   3680  O   MET   244       0.062  17.988 -55.178  1.00 41.58           O
ATOM   3682  N   PHE   245       1.617  19.466 -55.926  1.00 41.08           N
ATOM   3683  CA  PHE   245       1.573  18.956 -57.282  1.00 40.95           C
ATOM   3685  CB  PHE   245       2.526  19.723 -58.196  1.00 44.62           C
ATOM   3688  CG  PHE   245       2.500  19.240 -59.632  1.00 45.77           C
ATOM   3689  CD1 PHE   245       1.480  19.624 -60.482  1.00 47.82           C
ATOM   3691  CE1 PHE   245       1.446  19.164 -61.801  1.00 49.08           C
ATOM   3693  CZ  PHE   245       2.441  18.311 -62.261  1.00 46.94           C
ATOM   3695  CE2 PHE   245       3.461  17.925 -61.412  1.00 46.80           C
ATOM   3697  CD2 PHE   245       3.485  18.383 -60.112  1.00 45.53           C
ATOM   3699  C   PHE   245       1.868  17.455 -57.362  1.00 39.34           C
ATOM   3700  O   PHE   245       1.196  16.747 -58.089  1.00 41.31           O
ATOM   3702  N   LEU   246       2.856  16.963 -56.617  1.00 39.09           N
ATOM   3703  CA  LEU   246       3.235  15.531 -56.716  1.00 38.61           C
ATOM   3705  CB  LEU   246       4.715  15.314 -56.344  1.00 37.57           C
ATOM   3708  CG  LEU   246       5.770  16.034 -57.186  1.00 37.53           C
ATOM   3710  CD1 LEU   246       7.150  15.817 -56.573  1.00 37.38           C
ATOM   3714  CD2 LEU   246       5.756  15.576 -58.649  1.00 37.64           C
ATOM   3718  C   LEU   246       2.335  14.598 -55.877  1.00 37.20           C
ATOM   3719  O   LEU   246       2.218  13.404 -56.184  1.00 37.10           O
ATOM   3721  N   ASN   247       1.766  15.122 -54.794  1.00 36.83           N
ATOM   3722  CA  ASN   247       0.666  14.449 -54.078  1.00 37.80           C
ATOM   3724  CB  ASN   247       0.036  15.390 -53.004  1.00 34.61           C
ATOM   3727  CG  ASN   247       0.731  15.318 -51.621  1.00 34.61           C
ATOM   3728  OD1 ASN   247       1.508  14.420 -51.352  1.00 30.57           O
ATOM   3729  ND2 ASN   247       0.407  16.286 -50.734  1.00 32.49           N
ATOM   3732  C   ASN   247      -0.453  14.093 -55.079  1.00 40.56           C
ATOM   3733  O   ASN   247      -0.977  12.963 -55.099  1.00 41.20           O
ATOM   3735  N   ASP   248      -0.815  15.104 -55.879  1.00 41.48           N
ATOM   3736  CA  ASP   248      -1.949  15.049 -56.784  1.00 42.25           C
ATOM   3738  CB  ASP   248      -2.306  16.447 -57.258  1.00 40.23           C
ATOM   3741  CG  ASP   248      -3.026  17.237 -56.214  1.00 41.41           C
ATOM   3742  OD1 ASP   248      -3.308  16.682 -55.143  1.00 44.03           O
ATOM   3743  OD2 ASP   248      -3.330  18.419 -56.453  1.00 42.12           O
ATOM   3744  C   ASP   248      -1.657  14.176 -57.980  1.00 45.17           C
ATOM   3745  O   ASP   248      -2.489  13.386 -58.390  1.00 46.85           O
ATOM   3747  N   THR   249      -0.453  14.315 -58.520  1.00 48.83           N
ATOM   3748  CA  THR   249      -0.081  13.670 -59.768  1.00 47.24           C
ATOM   3750  CB  THR   249       0.832  14.593 -60.581  1.00 48.91           C
ATOM   3752  OG1 THR   249       0.067  15.723 -61.031  1.00 47.73           O
ATOM   3754  CG2 THR   249       1.386  13.883 -61.771  1.00 50.70           C
ATOM   3758  C   THR   249       0.571  12.305 -59.605  1.00 47.12           C
ATOM   3759  O   THR   249       0.424  11.470 -60.491  1.00 48.13           O
ATOM   3761  N   LEU   250       1.291  12.065 -58.500  1.00 44.73           N
ATOM   3762  CA  LEU   250       2.076  10.814 -58.364  1.00 43.80           C
ATOM   3764  CB  LEU   250       3.574  11.113 -58.201  1.00 43.84           C
ATOM   3767  CG  LEU   250       4.299  11.916 -59.264  1.00 45.31           C
ATOM   3769  CD1 LEU   250       5.807  11.758 -59.050  1.00 46.16           C
ATOM   3773  CD2 LEU   250       3.913  11.479 -60.662  1.00 44.90           C
ATOM   3777  C   LEU   250       1.665   9.884 -57.231  1.00 42.60           C
ATOM   3778  O   LEU   250       2.318   8.868 -57.028  1.00 45.91           O
ATOM   3780  N   SER   251       0.613  10.215 -56.485  1.00 42.39           N
ATOM   3781  CA  SER   251       0.200   9.381 -55.351  1.00 41.32           C
ATOM   3783  CB  SER   251       0.502  10.080 -54.016  1.00 39.89           C
ATOM   3786  OG  SER   251      -0.544  10.991 -53.675  1.00 35.56           O
ATOM   3788  C   SER   251      -1.289   9.064 -55.373  1.00 43.12           C
ATOM   3789  O   SER   251      -2.098   9.818 -55.923  1.00 40.78           O
ATOM   3791  N   THR   252      -1.634   7.979 -54.688  1.00 44.40           N
ATOM   3792  CA  THR   252      -3.020   7.589 -54.447  1.00 48.16           C
ATOM   3794  CB  THR   252      -3.193   6.088 -54.781  1.00 48.82           C
ATOM   3796  OG1 THR   252      -2.372   5.314 -53.906  1.00 48.82           O
ATOM   3798  CG2 THR   252      -2.773   5.816 -56.220  1.00 48.75           C
ATOM   3802  C   THR   252      -3.452   7.860 -52.975  1.00 48.46           C
ATOM   3803  O   THR   252      -4.338   7.180 -52.445  1.00 46.19           O
ATOM   3805  N   PHE   253      -2.816   8.856 -52.333  1.00 49.32           N
ATOM   3806  CA  PHE   253      -3.154   9.273 -50.972  1.00 47.68           C
ATOM   3808  CB  PHE   253      -2.145  10.310 -50.409  1.00 48.28           C
ATOM   3811  CG  PHE   253      -0.756   9.775 -50.186  1.00 48.57           C
ATOM   3812  CD1 PHE   253       0.353  10.502 -50.618  1.00 48.01           C
ATOM   3814  CE1 PHE   253       1.645  10.022 -50.419  1.00 48.71           C
ATOM   3816  CZ  PHE   253       1.845   8.802 -49.767  1.00 48.98           C
ATOM   3818  CE2 PHE   253       0.744   8.067 -49.323  1.00 49.87           C
ATOM   3820  CD2 PHE   253      -0.550   8.561 -49.533  1.00 49.63           C
ATOM   3822  C   PHE   253      -4.496   9.935 -50.972  1.00 46.23           C
ATOM   3823  O   PHE   253      -4.841  10.615 -51.927  1.00 45.16           O
ATOM   3825  N   ASP   254      -5.241   9.791 -49.880  1.00 44.56           N
ATOM   3826  CA  ASP   254      -6.481  10.549 -49.743  1.00 48.12           C
ATOM   3828  CB  ASP   254      -7.492   9.816 -48.820  1.00 49.59           C
ATOM   3831  CG  ASP   254      -7.064   9.769 -47.358  1.00 51.72           C
ATOM   3832  OD1 ASP   254      -6.328  10.675 -46.910  1.00 52.97           O
ATOM   3833  OD2 ASP   254      -7.506   8.833 -46.636  1.00 52.29           O
ATOM   3834  C   ASP   254      -6.172  12.021 -49.326  1.00 48.90           C
ATOM   3835  O   ASP   254      -4.992  12.423 -49.238  1.00 46.44           O
ATOM   3837  N   ASP   255      -7.218  12.811 -49.086  1.00 46.25           N
ATOM   3838  CA  ASP   255      -7.061  14.242 -48.841  1.00 46.71           C
ATOM   3840  CB  ASP   255      -8.405  14.960 -49.018  1.00 50.11           C
ATOM   3843  CG  ASP   255      -9.020  14.719 -50.408  1.00 54.26           C
ATOM   3844  OD1 ASP   255      -8.319  14.934 -51.434  1.00 54.14           O
ATOM   3845  OD2 ASP   255     -10.201  14.294 -50.470  1.00 58.49           O
ATOM   3846  C   ASP   255      -6.446  14.562 -47.458  1.00 42.72           C
ATOM   3847  O   ASP   255      -5.688  15.521 -47.330  1.00 38.33           O
ATOM   3849  N   LEU   256      -6.795  13.767 -46.446  1.00 37.54           N
ATOM   3850  CA  LEU   256      -6.221  13.909 -45.136  1.00 36.71           C
ATOM   3852  CB  LEU   256      -6.983  13.080 -44.096  1.00 36.85           C
ATOM   3855  CG  LEU   256      -6.396  13.120 -42.674  1.00 37.38           C
ATOM   3857  CD1 LEU   256      -6.345  14.569 -42.167  1.00 39.69           C
ATOM   3861  CD2 LEU   256      -7.167  12.224 -41.681  1.00 39.30           C
ATOM   3865  C   LEU   256      -4.736  13.496 -45.142  1.00 33.95           C
ATOM   3866  O   LEU   256      -3.906  14.187 -44.578  1.00 33.69           O
ATOM   3868  N   GLU   257      -4.429  12.370 -45.756  1.00 33.05           N
ATOM   3869  CA  GLU   257      -3.043  11.909 -45.867  1.00 38.52           C
ATOM   3871  CB  GLU   257      -2.961  10.607 -46.632  1.00 38.03           C
ATOM   3874  CG  GLU   257      -3.492   9.446 -45.833  1.00 42.37           C
ATOM   3877  CD  GLU   257      -3.605   8.185 -46.645  1.00 42.87           C
ATOM   3878  OE1 GLU   257      -3.952   8.267 -47.852  1.00 41.38           O
ATOM   3879  OE2 GLU   257      -3.345   7.114 -46.073  1.00 44.88           O
ATOM   3880  C   GLU   257      -2.186  12.946 -46.559  1.00 36.53           C
ATOM   3881  O   GLU   257      -1.085  13.209 -46.138  1.00 40.27           O
ATOM   3883  N   LYS   258      -2.710  13.521 -47.628  1.00 33.97           N
ATOM   3884  CA  LYS   258      -2.045  14.572 -48.316  1.00 33.01           C
ATOM   3886  CB  LYS   258      -2.882  15.077 -49.481  1.00 35.80           C
ATOM   3889  CG  LYS   258      -2.790  14.213 -50.757  1.00 35.87           C
ATOM   3892  CD  LYS   258      -3.575  14.855 -51.895  1.00 35.26           C
ATOM   3895  CE  LYS   258      -3.902  13.858 -53.011  1.00 36.88           C
ATOM   3898  NZ  LYS   258      -4.620  14.602 -54.121  1.00 36.53           N
ATOM   3902  C   LYS   258      -1.722  15.712 -47.340  1.00 32.48           C
ATOM   3903  O   LYS   258      -0.594  16.165 -47.302  1.00 30.24           O
ATOM   3905  N   ALA   259      -2.700  16.121 -46.530  1.00 26.94           N
ATOM   3906  CA  ALA   259      -2.505  17.165 -45.554  1.00 29.08           C
ATOM   3908  CB  ALA   259      -3.794  17.412 -44.780  1.00 25.31           C
ATOM   3912  C   ALA   259      -1.351  16.782 -44.577  1.00 32.46           C
ATOM   3913  O   ALA   259      -0.522  17.643 -44.163  1.00 25.94           O
ATOM   3915  N   LYS   260      -1.293  15.501 -44.236  1.00 29.07           N
ATOM   3916  CA  LYS   260      -0.307  15.039 -43.277  1.00 31.62           C
ATOM   3918  CB  LYS   260      -0.755  13.739 -42.648  1.00 30.28           C
ATOM   3921  CG  LYS   260      -1.759  14.044 -41.572  1.00 32.42           C
ATOM   3924  CD  LYS   260      -2.383  12.866 -41.079  1.00 34.51           C
ATOM   3927  CE  LYS   260      -3.073  13.131 -39.755  1.00 34.45           C
ATOM   3930  NZ  LYS   260      -3.287  11.838 -39.152  1.00 32.56           N
ATOM   3934  C   LYS   260       1.121  14.965 -43.806  1.00 28.62           C
ATOM   3935  O   LYS   260       2.088  15.021 -43.014  1.00 32.17           O
ATOM   3937  N   THR   261       1.262  14.906 -45.122  1.00 28.26           N
ATOM   3938  CA  THR   261       2.571  14.969 -45.724  1.00 29.38           C
ATOM   3940  CB  THR   261       2.614  14.466 -47.183  1.00 29.99           C
ATOM   3942  OG1 THR   261       1.860  15.329 -48.035  1.00 31.94           O
ATOM   3944  CG2 THR   261       2.081  13.079 -47.285  1.00 32.94           C
ATOM   3948  C   THR   261       3.086  16.390 -45.611  1.00 28.28           C
ATOM   3949  O   THR   261       4.287  16.605 -45.548  1.00 33.31           O
ATOM   3951  N   HIS   262       2.188  17.361 -45.586  1.00 27.10           N
ATOM   3952  CA  HIS   262       2.589  18.733 -45.381  1.00 28.98           C
ATOM   3954  CB  HIS   262       1.559  19.705 -45.936  1.00 30.80           C
ATOM   3957  CG  HIS   262       1.228  19.471 -47.381  1.00 33.36           C
ATOM   3958  ND1 HIS   262       2.197  19.274 -48.345  1.00 31.75           N
ATOM   3960  CE1 HIS   262       1.608  19.090 -49.520  1.00 33.91           C
ATOM   3962  NE2 HIS   262       0.295  19.175 -49.353  1.00 30.01           N
ATOM   3964  CD2 HIS   262       0.031  19.394 -48.023  1.00 31.50           C
ATOM   3966  C   HIS   262       2.869  19.014 -43.906  1.00 28.65           C
ATOM   3967  O   HIS   262       3.680  19.886 -43.584  1.00 26.90           O
ATOM   3969  N   LEU   263       2.183  18.290 -43.021  1.00 27.02           N
ATOM   3970  CA  LEU   263       2.458  18.356 -41.580  1.00 25.03           C
ATOM   3972  CB  LEU   263       1.374  17.631 -40.777  1.00 24.14           C
ATOM   3975  CG  LEU   263       1.440  17.594 -39.228  1.00 23.60           C
ATOM   3977  CD1 LEU   263       1.384  18.979 -38.641  1.00 23.33           C
ATOM   3981  CD2 LEU   263       0.329  16.720 -38.631  1.00 19.84           C
ATOM   3985  C   LEU   263       3.866  17.802 -41.238  1.00 23.02           C
ATOM   3986  O   LEU   263       4.478  18.255 -40.325  1.00 25.08           O
ATOM   3988  N   VAL   264       4.311  16.800 -41.966  1.00 25.19           N
ATOM   3989  CA  VAL   264       5.646  16.275 -41.836  1.00 26.96           C
ATOM   3991  CB  VAL   264       5.895  15.100 -42.798  1.00 28.43           C
ATOM   3993  CG1 VAL   264       7.364  14.729 -42.813  1.00 26.77           C
ATOM   3997  CG2 VAL   264       4.997  13.900 -42.407  1.00 28.61           C
ATOM   4001  C   VAL   264       6.664  17.380 -42.102  1.00 26.78           C
ATOM   4002  O   VAL   264       7.648  17.508 -41.363  1.00 29.78           O
ATOM   4004  N   VAL   265       6.393  18.194 -43.121  1.00 25.68           N
ATOM   4005  CA  VAL   265       7.231  19.349 -43.448  1.00 26.40           C
ATOM   4007  CB  VAL   265       6.921  19.906 -44.857  1.00 26.07           C
ATOM   4009  CG1 VAL   265       7.592  21.233 -45.064  1.00 27.55           C
ATOM   4013  CG2 VAL   265       7.354  18.917 -45.925  1.00 23.36           C
ATOM   4017  C   VAL   265       7.137  20.470 -42.428  1.00 26.16           C
ATOM   4018  O   VAL   265       8.135  21.130 -42.141  1.00 25.72           O
ATOM   4020  N   LEU   266       5.951  20.723 -41.889  1.00 24.66           N
ATOM   4021  CA  LEU   266       5.833  21.735 -40.846  1.00 24.65           C
ATOM   4023  CB  LEU   266       4.395  21.909 -40.401  1.00 21.34           C
ATOM   4026  CG  LEU   266       4.108  22.823 -39.231  1.00 22.34           C
ATOM   4028  CD1 LEU   266       4.582  24.305 -39.501  1.00 18.50           C
ATOM   4032  CD2 LEU   266       2.612  22.711 -38.899  1.00 23.68           C
ATOM   4036  C   LEU   266       6.716  21.323 -39.650  1.00 25.62           C
ATOM   4037  O   LEU   266       7.517  22.124 -39.145  1.00 26.42           O
ATOM   4039  N   TRP   267       6.566  20.074 -39.228  1.00 22.25           N
ATOM   4040  CA  TRP   267       7.263  19.569 -38.074  1.00 20.26           C
ATOM   4042  CB  TRP   267       6.882  18.109 -37.793  1.00 19.63           C
ATOM   4045  CG  TRP   267       7.518  17.625 -36.532  1.00 20.37           C
ATOM   4046  CD1 TRP   267       7.041  17.791 -35.247  1.00 22.14           C
ATOM   4048  NE1 TRP   267       7.956  17.279 -34.336  1.00 22.80           N
ATOM   4050  CE2 TRP   267       9.033  16.785 -35.025  1.00 21.50           C
ATOM   4051  CD2 TRP   267       8.791  16.977 -36.401  1.00 22.08           C
ATOM   4052  CE3 TRP   267       9.757  16.546 -37.316  1.00 25.00           C
ATOM   4054  CZ3 TRP   267      10.913  15.935 -36.826  1.00 22.06           C
ATOM   4056  CH2 TRP   267      11.102  15.734 -35.453  1.00 22.49           C
ATOM   4058  CZ2 TRP   267      10.189  16.146 -34.544  1.00 23.36           C
ATOM   4060  C   TRP   267       8.794  19.691 -38.274  1.00 22.09           C
ATOM   4061  O   TRP   267       9.501  20.245 -37.431  1.00 17.50           O
ATOM   4063  N   ALA   268       9.263  19.207 -39.409  1.00 22.14           N
ATOM   4064  CA  ALA   268      10.723  19.220 -39.758  1.00 22.82           C
ATOM   4066  CB  ALA   268      10.972  18.453 -41.084  1.00 16.93           C
ATOM   4070  C   ALA   268      11.283  20.590 -39.853  1.00 22.00           C
ATOM   4071  O   ALA   268      12.433  20.805 -39.508  1.00 24.68           O
ATOM   4073  N   SER   269      10.469  21.547 -40.314  1.00 25.59           N
ATOM   4074  CA  SER   269      10.928  22.924 -40.482  1.00 23.93           C
ATOM   4076  CB  SER   269      10.015  23.674 -41.467  1.00 25.19           C
ATOM   4079  OG  SER   269       8.730  23.993 -40.918  1.00 21.14           O
ATOM   4081  C   SER   269      11.035  23.666 -39.143  1.00 25.09           C
ATOM   4082  O   SER   269      11.683  24.706 -39.047  1.00 27.93           O
ATOM   4084  N   GLN   270      10.417  23.110 -38.104  1.00 26.54           N
ATOM   4085  CA  GLN   270      10.165  23.839 -36.876  1.00 23.53           C
ATOM   4087  CB  GLN   270       8.649  23.894 -36.601  1.00 27.11           C
ATOM   4090  CG  GLN   270       7.816  24.781 -37.512  1.00 28.22           C
ATOM   4093  CD  GLN   270       8.183  26.267 -37.469  1.00 28.77           C
ATOM   4094  OE1 GLN   270       8.699  26.769 -36.499  1.00 27.91           O
ATOM   4095  NE2 GLN   270       7.891  26.962 -38.547  1.00 28.62           N
ATOM   4098  C   GLN   270      10.820  23.232 -35.665  1.00 21.28           C
ATOM   4099  O   GLN   270      11.317  23.945 -34.805  1.00 22.62           O
ATOM   4101  N   ALA   271      10.797  21.916 -35.558  1.00 24.29           N
ATOM   4102  CA  ALA   271      11.096  21.296 -34.270  1.00 24.42           C
ATOM   4104  CB  ALA   271      10.687  19.843 -34.241  1.00 21.44           C
ATOM   4108  C   ALA   271      12.536  21.460 -33.827  1.00 21.01           C
ATOM   4109  O   ALA   271      12.793  21.444 -32.616  1.00 19.91           O
ATOM   4111  N   ASN   272      13.467  21.603 -34.778  1.00 19.98           N
ATOM   4112  CA  ASN   272      14.875  21.892 -34.433  1.00 20.83           C
ATOM   4114  CB  ASN   272      15.814  21.142 -35.300  1.00 17.79           C
ATOM   4117  CG  ASN   272      15.724  19.621 -35.099  1.00 20.68           C
ATOM   4118  OD1 ASN   272      15.770  19.122 -33.984  1.00 20.10           O
ATOM   4119  ND2 ASN   272      15.618  18.899 -36.195  1.00 18.80           N
ATOM   4122  C   ASN   272      15.226  23.374 -34.498  1.00 22.01           C
ATOM   4123  O   ASN   272      16.036  23.818 -33.746  1.00 16.35           O
ATOM   4125  N   THR   273      14.581  24.114 -35.399  1.00 24.21           N
ATOM   4126  CA  THR   273      14.873  25.512 -35.614  1.00 24.70           C
ATOM   4128  CB  THR   273      14.094  26.029 -36.839  1.00 26.67           C
ATOM   4130  OG1 THR   273      14.469  25.281 -37.997  1.00 25.32           O
ATOM   4132  CG2 THR   273      14.351  27.489 -37.076  1.00 27.49           C
ATOM   4136  C   THR   273      14.553  26.373 -34.398  1.00 22.91           C
ATOM   4137  O   THR   273      15.296  27.307 -34.075  1.00 22.90           O
ATOM   4139  N   ILE   274      13.479  26.059 -33.707  1.00 24.03           N
ATOM   4140  CA  ILE   274      13.064  26.868 -32.558  1.00 22.94           C
ATOM   4142  CB  ILE   274      11.615  26.542 -32.112  1.00 24.30           C
ATOM   4144  CG1 ILE   274      10.647  27.124 -33.128  1.00 25.78           C
ATOM   4147  CD1 ILE   274       9.354  26.524 -33.098  1.00 29.74           C
ATOM   4151  CG2 ILE   274      11.330  27.127 -30.693  1.00 17.57           C
ATOM   4155  C   ILE   274      14.076  26.764 -31.413  1.00 25.70           C
ATOM   4156  O   ILE   274      14.616  27.800 -30.975  1.00 22.19           O
ATOM   4158  N   PRO   275      14.365  25.530 -30.931  1.00 23.46           N
ATOM   4159  CA  PRO   275      15.418  25.419 -29.886  1.00 23.84           C
ATOM   4161  CB  PRO   275      15.380  23.935 -29.500  1.00 23.16           C
ATOM   4164  CG  PRO   275      14.809  23.245 -30.674  1.00 24.73           C
ATOM   4167  CD  PRO   275      13.774  24.215 -31.226  1.00 24.97           C
ATOM   4170  C   PRO   275      16.850  25.834 -30.300  1.00 24.81           C
ATOM   4171  O   PRO   275      17.623  26.284 -29.425  1.00 23.22           O
ATOM   4172  N   ALA   276      17.186  25.710 -31.597  1.00 21.43           N
ATOM   4173  CA  ALA   276      18.485  26.140 -32.111  1.00 20.96           C
ATOM   4175  CB  ALA   276      18.688  25.666 -33.517  1.00 20.87           C
ATOM   4179  C   ALA   276      18.607  27.644 -32.037  1.00 21.94           C
ATOM   4180  O   ALA   276      19.678  28.182 -31.734  1.00 21.37           O
ATOM   4182  N   THR   277      17.499  28.317 -32.301  1.00 20.73           N
ATOM   4183  CA  THR   277      17.430  29.765 -32.245  1.00 23.07           C
ATOM   4185  CB  THR   277      16.123  30.256 -32.910  1.00 22.79           C
ATOM   4187  OG1 THR   277      16.151  29.851 -34.289  1.00 21.36           O
ATOM   4189  CG2 THR   277      15.983  31.760 -32.834  1.00 21.63           C
ATOM   4193  C   THR   277      17.579  30.253 -30.821  1.00 21.16           C
ATOM   4194  O   THR   277      18.341  31.153 -30.566  1.00 22.10           O
ATOM   4196  N   PHE   278      16.849  29.634 -29.897  1.00 22.83           N
ATOM   4197  CA  PHE   278      16.945  29.946 -28.500  1.00 22.85           C
ATOM   4199  CB  PHE   278      16.076  29.005 -27.641  1.00 25.45           C
ATOM   4202  CG  PHE   278      16.413  29.069 -26.175  1.00 26.41           C
ATOM   4203  CD1 PHE   278      15.929  30.111 -25.384  1.00 26.40           C
ATOM   4205  CE1 PHE   278      16.277  30.192 -24.037  1.00 28.91           C
ATOM   4207  CZ  PHE   278      17.123  29.245 -23.478  1.00 27.90           C
ATOM   4209  CE2 PHE   278      17.631  28.214 -24.273  1.00 27.06           C
ATOM   4211  CD2 PHE   278      17.273  28.129 -25.600  1.00 26.01           C
ATOM   4213  C   PHE   278      18.369  29.860 -27.998  1.00 22.80           C
ATOM   4214  O   PHE   278      18.867  30.780 -27.331  1.00 24.27           O
ATOM   4216  N   TRP   279      19.016  28.745 -28.279  1.00 20.92           N
ATOM   4217  CA  TRP   279      20.351  28.502 -27.755  1.00 22.87           C
ATOM   4219  CB  TRP   279      20.802  27.052 -27.977  1.00 22.21           C
ATOM   4222  CG  TRP   279      20.175  26.043 -27.001  1.00 23.63           C
ATOM   4223  CD1 TRP   279      19.388  24.983 -27.312  1.00 22.95           C
ATOM   4225  NE1 TRP   279      19.027  24.306 -26.167  1.00 22.47           N
ATOM   4227  CE2 TRP   279      19.576  24.926 -25.086  1.00 23.93           C
ATOM   4228  CD2 TRP   279      20.310  26.027 -25.562  1.00 22.66           C
ATOM   4229  CE3 TRP   279      20.990  26.838 -24.639  1.00 22.07           C
ATOM   4231  CZ3 TRP   279      20.914  26.525 -23.301  1.00 22.71           C
ATOM   4233  CH2 TRP   279      20.152  25.439 -22.852  1.00 23.37           C
ATOM   4235  CZ2 TRP   279      19.489  24.614 -23.727  1.00 24.18           C
ATOM   4237  C   TRP   279      21.345  29.485 -28.343  1.00 24.73           C
ATOM   4238  O   TRP   279      22.188  30.024 -27.608  1.00 25.82           O
ATOM   4240  N   SER   280      21.243  29.730 -29.655  1.00 22.16           N
ATOM   4241  CA  SER   280      22.110  30.684 -30.322  1.00 20.43           C
ATOM   4243  CB  SER   280      21.878  30.665 -31.821  1.00 18.07           C
ATOM   4246  OG  SER   280      22.069  29.389 -32.384  1.00 19.06           O
ATOM   4248  C   SER   280      21.932  32.129 -29.752  1.00 25.38           C
ATOM   4249  O   SER   280      22.907  32.834 -29.512  1.00 25.16           O
ATOM   4251  N   LEU   281      20.683  32.548 -29.524  1.00 25.50           N
ATOM   4252  CA  LEU   281      20.421  33.847 -28.902  1.00 24.56           C
ATOM   4254  CB  LEU   281      18.938  34.176 -29.001  1.00 25.66           C
ATOM   4257  CG  LEU   281      18.504  35.539 -28.447  1.00 24.73           C
ATOM   4259  CD1 LEU   281      19.127  36.673 -29.286  1.00 24.52           C
ATOM   4263  CD2 LEU   281      17.002  35.619 -28.395  1.00 20.63           C
ATOM   4267  C   LEU   281      20.900  33.895 -27.440  1.00 26.54           C
ATOM   4268  O   LEU   281      21.589  34.833 -27.035  1.00 28.06           O
ATOM   4270  N   PHE   282      20.528  32.878 -26.662  1.00 26.32           N
ATOM   4271  CA  PHE   282      20.890  32.789 -25.247  1.00 27.20           C
ATOM   4273  CB  PHE   282      20.313  31.521 -24.595  1.00 29.64           C
ATOM   4276  CG  PHE   282      20.728  31.345 -23.173  1.00 32.03           C
ATOM   4277  CD1 PHE   282      20.331  32.268 -22.197  1.00 34.51           C
ATOM   4279  CE1 PHE   282      20.732  32.135 -20.891  1.00 34.06           C
ATOM   4281  CZ  PHE   282      21.535  31.086 -20.526  1.00 33.33           C
ATOM   4283  CE2 PHE   282      21.953  30.161 -21.476  1.00 34.41           C
ATOM   4285  CD2 PHE   282      21.547  30.293 -22.796  1.00 34.44           C
ATOM   4287  C   PHE   282      22.406  32.827 -25.029  1.00 29.96           C
ATOM   4288  O   PHE   282      22.907  33.587 -24.198  1.00 30.49           O
ATOM   4290  N   GLN   283      23.112  32.001 -25.777  1.00 24.95           N
ATOM   4291  CA  GLN   283      24.546  31.878 -25.657  1.00 28.65           C
ATOM   4293  CB  GLN   283      25.042  30.678 -26.452  1.00 26.02           C
ATOM   4296  CG  GLN   283      24.558  29.341 -25.928  1.00 27.12           C
ATOM   4299  CD  GLN   283      25.278  28.865 -24.671  1.00 26.50           C
ATOM   4300  OE1 GLN   283      25.780  29.673 -23.871  1.00 25.97           O
ATOM   4301  NE2 GLN   283      25.326  27.540 -24.489  1.00 19.17           N
ATOM   4304  C   GLN   283      25.312  33.137 -26.102  1.00 28.73           C
ATOM   4305  O   GLN   283      26.319  33.485 -25.508  1.00 30.03           O
ATOM   4307  N   MET   284      24.819  33.805 -27.128  1.00 26.66           N
ATOM   4308  CA  MET   284      25.353  35.086 -27.534  1.00 28.77           C
ATOM   4310  CB  MET   284      24.670  35.540 -28.815  1.00 27.15           C
ATOM   4313  CG  MET   284      25.337  36.667 -29.509  1.00 29.33           C
ATOM   4316  SD  MET   284      24.539  37.075 -31.062  1.00 30.34           S
ATOM   4317  CE  MET   284      22.933  37.651 -30.470  1.00 31.63           C
ATOM   4321  C   MET   284      25.168  36.158 -26.454  1.00 32.14           C
ATOM   4322  O   MET   284      26.104  36.837 -26.103  1.00 33.99           O
ATOM   4324  N   ILE   285      23.956  36.316 -25.953  1.00 34.14           N
ATOM   4325  CA  ILE   285      23.655  37.384 -25.004  1.00 34.27           C
ATOM   4327  CB  ILE   285      22.154  37.485 -24.697  1.00 36.89           C
ATOM   4329  CG1 ILE   285      21.361  37.965 -25.897  1.00 36.13           C
ATOM   4332  CD1 ILE   285      19.833  37.945 -25.610  1.00 34.33           C
ATOM   4336  CG2 ILE   285      21.895  38.460 -23.540  1.00 39.27           C
ATOM   4340  C   ILE   285      24.365  37.136 -23.688  1.00 36.98           C
ATOM   4341  O   ILE   285      24.884  38.071 -23.086  1.00 37.04           O
ATOM   4343  N   ARG   286      24.363  35.875 -23.255  1.00 33.96           N
ATOM   4344  CA  ARG   286      24.989  35.429 -21.996  1.00 39.22           C
ATOM   4346  CB  ARG   286      24.695  33.940 -21.830  1.00 43.74           C
ATOM   4349  CG  ARG   286      25.388  33.251 -20.724  1.00 47.17           C
ATOM   4352  CD  ARG   286      25.135  31.750 -20.803  1.00 53.57           C
ATOM   4355  NE  ARG   286      25.878  31.033 -19.766  1.00 57.67           N
ATOM   4357  CZ  ARG   286      25.622  31.129 -18.455  1.00 60.15           C
ATOM   4358  NH1 ARG   286      24.631  31.907 -18.002  1.00 61.72           N
ATOM   4361  NH2 ARG   286      26.355  30.434 -17.584  1.00 61.14           N
ATOM   4364  C   ARG   286      26.526  35.643 -21.891  1.00 38.00           C
ATOM   4365  O   ARG   286      27.039  35.827 -20.787  1.00 38.05           O
ATOM   4367  N   ASN   287      27.233  35.569 -23.025  1.00 35.87           N
ATOM   4368  CA  ASN   287      28.691  35.639 -23.085  1.00 35.40           C
ATOM   4370  CB  ASN   287      29.256  34.462 -23.865  1.00 36.26           C
ATOM   4373  CG  ASN   287      28.984  33.101 -23.176  1.00 39.22           C
ATOM   4374  OD1 ASN   287      29.784  32.652 -22.348  1.00 37.71           O
ATOM   4375  ND2 ASN   287      27.846  32.435 -23.537  1.00 36.73           N
ATOM   4378  C   ASN   287      29.112  36.951 -23.748  1.00 40.08           C
ATOM   4379  O   ASN   287      29.102  37.054 -24.984  1.00 41.00           O
ATOM   4381  N   PRO   288      29.469  37.975 -22.931  1.00 40.58           N
ATOM   4382  CA  PRO   288      29.783  39.325 -23.437  1.00 40.29           C
ATOM   4384  CB  PRO   288      30.416  40.012 -22.222  1.00 41.31           C
ATOM   4387  CG  PRO   288      29.796  39.346 -21.052  1.00 40.61           C
ATOM   4390  CD  PRO   288      29.604  37.907 -21.462  1.00 41.47           C
ATOM   4393  C   PRO   288      30.747  39.356 -24.635  1.00 36.40           C
ATOM   4394  O   PRO   288      30.582  40.195 -25.515  1.00 40.82           O
ATOM   4395  N   GLU   289      31.721  38.449 -24.681  1.00 35.43           N
ATOM   4396  CA  GLU   289      32.682  38.395 -25.820  1.00 38.36           C
ATOM   4398  CB  GLU   289      33.879  37.448 -25.532  1.00 36.51           C
ATOM   4405  C   GLU   289      31.970  37.977 -27.123  1.00 36.27           C
ATOM   4406  O   GLU   289      32.203  38.565 -28.169  1.00 34.84           O
ATOM   4408  N   ALA   290      31.099  36.965 -27.027  1.00 35.10           N
ATOM   4409  CA  ALA   290      30.273  36.529 -28.154  1.00 33.27           C
ATOM   4411  CB  ALA   290      29.390  35.337 -27.736  1.00 29.42           C
ATOM   4415  C   ALA   290      29.424  37.663 -28.680  1.00 29.93           C
ATOM   4416  O   ALA   290      29.407  37.924 -29.869  1.00 29.94           O
ATOM   4418  N   MET   291      28.748  38.364 -27.776  1.00 32.60           N
ATOM   4419  CA  MET   291      27.874  39.468 -28.128  1.00 31.81           C
ATOM   4421  CB  MET   291      27.223  40.020 -26.876  1.00 38.20           C
ATOM   4424  CG  MET   291      26.190  41.141 -27.105  1.00 42.65           C
ATOM   4427  SD  MET   291      24.575  40.565 -27.652  1.00 47.16           S
ATOM   4428  CE  MET   291      23.632  42.066 -27.565  1.00 45.38           C
ATOM   4432  C   MET   291      28.593  40.606 -28.841  1.00 34.75           C
ATOM   4433  O   MET   291      28.040  41.218 -29.769  1.00 35.03           O
ATOM   4435  N   LYS   292      29.796  40.927 -28.375  1.00 35.86           N
ATOM   4436  CA  LYS   292      30.598  42.032 -28.929  1.00 35.34           C
ATOM   4438  CB  LYS   292      31.777  42.356 -27.973  1.00 37.46           C
ATOM   4441  CG  LYS   292      32.669  43.588 -28.374  1.00 40.45           C
ATOM   4444  CD  LYS   292      33.942  43.741 -27.426  1.00 41.07           C
ATOM   4449  C   LYS   292      31.111  41.647 -30.321  1.00 32.72           C
ATOM   4450  O   LYS   292      31.001  42.415 -31.257  1.00 34.46           O
ATOM   4452  N   ALA   293      31.626  40.434 -30.447  1.00 32.23           N
ATOM   4453  CA  ALA   293      32.122  39.947 -31.706  1.00 32.68           C
ATOM   4455  CB  ALA   293      32.832  38.599 -31.512  1.00 29.90           C
ATOM   4459  C   ALA   293      30.989  39.827 -32.730  1.00 33.67           C
ATOM   4460  O   ALA   293      31.173  40.153 -33.889  1.00 37.35           O
ATOM   4462  N   ALA   294      29.811  39.377 -32.285  1.00 35.43           N
ATOM   4463  CA  ALA   294      28.622  39.282 -33.165  1.00 34.87           C
ATOM   4465  CB  ALA   294      27.470  38.484 -32.459  1.00 32.55           C
ATOM   4469  C   ALA   294      28.104  40.655 -33.594  1.00 32.86           C
ATOM   4470  O   ALA   294      27.765  40.872 -34.765  1.00 30.32           O
ATOM   4472  N   THR   295      28.003  41.556 -32.630  1.00 33.46           N
ATOM   4473  CA  THR   295      27.531  42.926 -32.879  1.00 36.11           C
ATOM   4475  CB  THR   295      27.496  43.706 -31.577  1.00 37.50           C
ATOM   4477  OG1 THR   295      26.633  43.022 -30.660  1.00 37.16           O
ATOM   4479  CG2 THR   295      26.988  45.137 -31.798  1.00 37.71           C
ATOM   4483  C   THR   295      28.370  43.682 -33.944  1.00 36.93           C
ATOM   4484  O   THR   295      27.806  44.332 -34.839  1.00 39.95           O
ATOM   4486  N   GLU   296      29.691  43.554 -33.854  1.00 35.55           N
ATOM   4487  CA  GLU   296      30.632  44.153 -34.820  1.00 39.38           C
ATOM   4489  CB  GLU   296      32.088  43.997 -34.333  1.00 40.15           C
ATOM   4492  CG  GLU   296      32.389  44.847 -33.101  1.00 47.25           C
ATOM   4495  CD  GLU   296      33.814  44.674 -32.564  1.00 49.45           C
ATOM   4496  OE1 GLU   296      34.542  43.739 -33.043  1.00 52.33           O
ATOM   4497  OE2 GLU   296      34.187  45.472 -31.648  1.00 50.79           O
ATOM   4498  C   GLU   296      30.534  43.551 -36.196  1.00 35.77           C
ATOM   4499  O   GLU   296      30.500  44.274 -37.176  1.00 34.83           O
ATOM   4501  N   GLU   297      30.547  42.221 -36.274  1.00 34.76           N
ATOM   4502  CA  GLU   297      30.410  41.533 -37.565  1.00 36.88           C
ATOM   4504  CB  GLU   297      30.457  40.028 -37.384  1.00 40.29           C
ATOM   4507  CG  GLU   297      30.146  39.249 -38.656  1.00 42.56           C
ATOM   4510  CD  GLU   297      30.910  37.958 -38.752  1.00 46.70           C
ATOM   4511  OE1 GLU   297      30.267  36.896 -38.718  1.00 49.20           O
ATOM   4512  OE2 GLU   297      32.168  38.006 -38.859  1.00 53.80           O
ATOM   4513  C   GLU   297      29.121  41.927 -38.286  1.00 35.95           C
ATOM   4514  O   GLU   297      29.117  42.179 -39.478  1.00 37.14           O
ATOM   4516  N   VAL   298      28.029  41.990 -37.555  1.00 37.28           N
ATOM   4517  CA  VAL   298      26.755  42.342 -38.157  1.00 37.49           C
ATOM   4519  CB  VAL   298      25.566  42.036 -37.171  1.00 35.68           C
ATOM   4521  CG1 VAL   298      24.280  42.760 -37.580  1.00 34.98           C
ATOM   4525  CG2 VAL   298      25.326  40.506 -37.096  1.00 35.18           C
ATOM   4529  C   VAL   298      26.785  43.816 -38.655  1.00 37.57           C
ATOM   4530  O   VAL   298      26.270  44.114 -39.725  1.00 34.06           O
ATOM   4532  N   LYS   299      27.407  44.706 -37.871  1.00 39.82           N
ATOM   4533  CA  LYS   299      27.522  46.141 -38.219  1.00 42.55           C
ATOM   4535  CB  LYS   299      28.159  46.931 -37.083  1.00 47.62           C
ATOM   4538  CG  LYS   299      27.195  47.756 -36.288  1.00 52.39           C
ATOM   4541  CD  LYS   299      27.937  48.643 -35.279  1.00 57.29           C
ATOM   4544  CE  LYS   299      28.844  49.724 -35.954  1.00 57.95           C
ATOM   4547  NZ  LYS   299      28.057  50.839 -36.571  1.00 59.78           N
ATOM   4551  C   LYS   299      28.356  46.361 -39.456  1.00 41.43           C
ATOM   4552  O   LYS   299      27.974  47.096 -40.357  1.00 41.48           O
ATOM   4554  N   ARG   300      29.521  45.741 -39.465  1.00 40.54           N
ATOM   4555  CA  ARG   300      30.419  45.759 -40.603  1.00 42.82           C
ATOM   4557  CB  ARG   300      31.625  44.901 -40.262  1.00 43.28           C
ATOM   4560  CG  ARG   300      32.737  44.842 -41.262  1.00 45.90           C
ATOM   4563  CD  ARG   300      33.819  43.822 -40.770  1.00 47.14           C
ATOM   4570  C   ARG   300      29.706  45.236 -41.871  1.00 43.26           C
ATOM   4571  O   ARG   300      29.843  45.819 -42.941  1.00 46.39           O
ATOM   4573  N   THR   301      28.940  44.148 -41.745  1.00 39.67           N
ATOM   4574  CA  THR   301      28.266  43.532 -42.909  1.00 37.51           C
ATOM   4576  CB  THR   301      27.745  42.108 -42.575  1.00 38.57           C
ATOM   4578  OG1 THR   301      28.861  41.246 -42.291  1.00 40.42           O
ATOM   4580  CG2 THR   301      26.926  41.526 -43.740  1.00 38.07           C
ATOM   4584  C   THR   301      27.111  44.374 -43.433  1.00 35.22           C
ATOM   4585  O   THR   301      26.880  44.416 -44.625  1.00 37.27           O
ATOM   4587  N   LEU   302      26.373  45.022 -42.543  1.00 36.11           N
ATOM   4588  CA  LEU   302      25.238  45.813 -42.962  1.00 40.78           C
ATOM   4590  CB  LEU   302      24.290  46.098 -41.795  1.00 41.76           C
ATOM   4593  CG  LEU   302      23.480  44.925 -41.194  1.00 41.49           C
ATOM   4595  CD1 LEU   302      22.516  45.472 -40.176  1.00 41.53           C
ATOM   4599  CD2 LEU   302      22.744  44.122 -42.279  1.00 41.56           C
ATOM   4603  C   LEU   302      25.737  47.117 -43.557  1.00 46.90           C
ATOM   4604  O   LEU   302      25.211  47.579 -44.586  1.00 43.83           O
ATOM   4606  N   GLU   303      26.760  47.695 -42.907  1.00 50.47           N
ATOM   4607  CA  GLU   303      27.340  48.979 -43.315  1.00 55.46           C
ATOM   4609  CB  GLU   303      28.520  49.371 -42.405  1.00 58.14           C
ATOM   4612  CG  GLU   303      28.833  50.871 -42.396  1.00 62.22           C
ATOM   4615  CD  GLU   303      29.732  51.303 -41.211  1.00 63.66           C
ATOM   4616  OE1 GLU   303      30.599  52.190 -41.426  1.00 65.90           O
ATOM   4617  OE2 GLU   303      29.568  50.762 -40.075  1.00 66.24           O
ATOM   4618  C   GLU   303      27.797  48.942 -44.754  1.00 53.87           C
ATOM   4619  O   GLU   303      27.399  49.795 -45.557  1.00 54.53           O
ATOM   4621  N   ASN   304      28.618  47.957 -45.103  1.00 51.03           N
ATOM   4622  CA  ASN   304      29.139  47.941 -46.442  1.00 52.57           C
ATOM   4624  CB  ASN   304      30.648  47.659 -46.470  1.00 56.30           C
ATOM   4627  CG  ASN   304      31.010  46.428 -45.778  1.00 55.96           C
ATOM   4628  OD1 ASN   304      30.372  45.414 -45.963  1.00 58.70           O
ATOM   4629  ND2 ASN   304      32.046  46.491 -44.958  1.00 50.74           N
ATOM   4632  C   ASN   304      28.349  47.103 -47.432  1.00 51.50           C
ATOM   4633  O   ASN   304      28.787  46.903 -48.546  1.00 52.48           O
ATOM   4635  N   ALA   305      27.167  46.635 -47.031  1.00 48.88           N
ATOM   4636  CA  ALA   305      26.133  46.225 -47.992  1.00 45.84           C
ATOM   4638  CB  ALA   305      25.415  45.000 -47.506  1.00 45.34           C
ATOM   4642  C   ALA   305      25.150  47.389 -48.181  1.00 43.74           C
ATOM   4643  O   ALA   305      24.141  47.250 -48.856  1.00 43.11           O
ATOM   4645  N   GLY   306      25.447  48.524 -47.546  1.00 43.09           N
ATOM   4646  CA  GLY   306      24.623  49.740 -47.622  1.00 45.68           C
ATOM   4649  C   GLY   306      23.232  49.627 -47.015  1.00 47.12           C
ATOM   4650  O   GLY   306      22.314  50.376 -47.380  1.00 45.98           O
ATOM   4652  N   GLN   307      23.070  48.690 -46.085  1.00 47.80           N
ATOM   4653  CA  GLN   307      21.753  48.381 -45.526  1.00 47.29           C
ATOM   4655  CB  GLN   307      21.616  46.874 -45.260  1.00 44.45           C
ATOM   4658  CG  GLN   307      21.716  46.008 -46.513  1.00 44.50           C
ATOM   4661  CD  GLN   307      20.816  46.509 -47.664  1.00 44.13           C
ATOM   4662  OE1 GLN   307      19.606  46.574 -47.538  1.00 43.95           O
ATOM   4663  NE2 GLN   307      21.431  46.872 -48.772  1.00 45.45           N
ATOM   4666  C   GLN   307      21.542  49.169 -44.259  1.00 49.36           C
ATOM   4667  O   GLN   307      22.254  48.988 -43.274  1.00 50.68           O
ATOM   4669  N   LYS   308      20.572  50.070 -44.296  1.00 54.67           N
ATOM   4670  CA  LYS   308      20.215  50.849 -43.120  1.00 56.65           C
ATOM   4672  CB  LYS   308      19.646  52.227 -43.516  1.00 57.79           C
ATOM   4679  C   LYS   308      19.205  50.041 -42.314  1.00 58.25           C
ATOM   4680  O   LYS   308      18.386  49.297 -42.874  1.00 56.09           O
ATOM   4682  N   VAL   309      19.301  50.172 -40.996  1.00 61.51           N
ATOM   4683  CA  VAL   309      18.380  49.550 -40.069  1.00 63.56           C
ATOM   4685  CB  VAL   309      19.139  48.879 -38.908  1.00 63.91           C
ATOM   4687  CG1 VAL   309      18.198  48.563 -37.772  1.00 63.87           C
ATOM   4691  CG2 VAL   309      19.841  47.617 -39.393  1.00 64.76           C
ATOM   4695  C   VAL   309      17.443  50.616 -39.506  1.00 66.32           C
ATOM   4696  O   VAL   309      17.890  51.658 -39.000  1.00 64.17           O
ATOM   4698  N   SER   310      16.142  50.355 -39.599  1.00 69.57           N
ATOM   4699  CA  SER   310      15.145  51.206 -38.952  1.00 71.36           C
ATOM   4701  CB  SER   310      14.912  52.484 -39.753  1.00 72.37           C
ATOM   4704  OG  SER   310      14.463  52.175 -41.056  1.00 73.89           O
ATOM   4706  C   SER   310      13.845  50.455 -38.787  1.00 71.57           C
ATOM   4707  O   SER   310      13.571  49.502 -39.503  1.00 71.50           O
ATOM   4709  N   LEU   311      13.040  50.895 -37.840  1.00 73.87           N
ATOM   4710  CA  LEU   311      11.805  50.203 -37.526  1.00 77.26           C
ATOM   4712  CB  LEU   311      11.323  50.594 -36.128  1.00 77.45           C
ATOM   4715  CG  LEU   311      12.338  50.299 -35.026  1.00 77.88           C
ATOM   4717  CD1 LEU   311      11.804  50.760 -33.681  1.00 77.17           C
ATOM   4721  CD2 LEU   311      12.712  48.798 -35.017  1.00 77.48           C
ATOM   4725  C   LEU   311      10.738  50.511 -38.561  1.00 79.33           C
ATOM   4726  O   LEU   311       9.951  49.639 -38.934  1.00 78.08           O
ATOM   4728  N   GLU   312      10.723  51.755 -39.034  1.00 82.60           N
ATOM   4729  CA  GLU   312       9.673  52.209 -39.936  1.00 84.66           C
ATOM   4731  CB  GLU   312       9.109  53.561 -39.455  1.00 86.58           C
ATOM   4734  CG  GLU   312       8.892  53.617 -37.910  1.00 88.41           C
ATOM   4737  CD  GLU   312       7.541  54.207 -37.493  1.00 90.56           C
ATOM   4738  OE1 GLU   312       7.112  55.221 -38.093  1.00 91.31           O
ATOM   4739  OE2 GLU   312       6.910  53.652 -36.550  1.00 91.55           O
ATOM   4740  C   GLU   312      10.138  52.273 -41.397  1.00 84.10           C
ATOM   4741  O   GLU   312       9.309  52.233 -42.296  1.00 85.51           O
ATOM   4743  N   GLY   313      11.453  52.336 -41.631  1.00 82.42           N
ATOM   4744  CA  GLY   313      11.998  52.474 -42.994  1.00 81.44           C
ATOM   4747  C   GLY   313      11.857  51.255 -43.912  1.00 78.95           C
ATOM   4748  O   GLY   313      11.042  50.363 -43.666  1.00 78.46           O
ATOM   4750  N   ASN   314      12.657  51.239 -44.983  1.00 75.80           N
ATOM   4751  CA  ASN   314      12.648  50.141 -45.968  1.00 72.52           C
ATOM   4753  CB  ASN   314      13.359  50.545 -47.278  1.00 72.96           C
ATOM   4756  CG  ASN   314      12.929  51.918 -47.803  1.00 73.43           C
ATOM   4757  OD1 ASN   314      12.087  52.604 -47.212  1.00 74.62           O
ATOM   4758  ND2 ASN   314      13.517  52.318 -48.917  1.00 73.02           N
ATOM   4761  C   ASN   314      13.361  48.919 -45.403  1.00 67.82           C
ATOM   4762  O   ASN   314      14.231  49.064 -44.543  1.00 64.21           O
ATOM   4764  N   PRO   315      13.021  47.713 -45.904  1.00 65.07           N
ATOM   4765  CA  PRO   315      13.626  46.480 -45.368  1.00 63.39           C
ATOM   4767  CB  PRO   315      12.818  45.355 -46.061  1.00 63.04           C
ATOM   4770  CG  PRO   315      11.668  46.018 -46.722  1.00 63.27           C
ATOM   4773  CD  PRO   315      12.067  47.419 -46.989  1.00 64.44           C
ATOM   4776  C   PRO   315      15.129  46.315 -45.668  1.00 59.77           C
ATOM   4777  O   PRO   315      15.649  46.948 -46.577  1.00 63.69           O
ATOM   4778  N   ILE   316      15.797  45.466 -44.889  1.00 54.05           N
ATOM   4779  CA  ILE   316      17.165  45.030 -45.162  1.00 50.80           C
ATOM   4781  CB  ILE   316      17.822  44.464 -43.879  1.00 50.46           C
ATOM   4783  CG1 ILE   316      18.021  45.567 -42.845  1.00 51.69           C
ATOM   4786  CD1 ILE   316      18.507  45.036 -41.457  1.00 51.86           C
ATOM   4790  CG2 ILE   316      19.164  43.780 -44.176  1.00 49.57           C
ATOM   4794  C   ILE   316      17.146  43.929 -46.211  1.00 49.07           C
ATOM   4795  O   ILE   316      16.273  43.090 -46.203  1.00 51.24           O
ATOM   4797  N   CYS   317      18.112  43.945 -47.114  1.00 50.48           N
ATOM   4798  CA  CYS   317      18.259  42.888 -48.104  0.50 50.01           C
ATOM   4802  CB  CYS   317      17.787  43.355 -49.480  0.50 51.71           C
ATOM   4808  SG  CYS   317      17.864  42.064 -50.752  0.50 52.65           S
ATOM   4812  C   CYS   317      19.715  42.481 -48.175  1.00 49.41           C
ATOM   4813  O   CYS   317      20.588  43.313 -48.406  1.00 46.99           O
ATOM   4815  N   LEU   318      19.973  41.182 -47.975  1.00 47.97           N
ATOM   4816  CA  LEU   318      21.333  40.663 -47.978  1.00 47.72           C
ATOM   4818  CB  LEU   318      21.747  40.153 -46.577  1.00 43.80           C
ATOM   4821  CG  LEU   318      21.921  41.232 -45.486  1.00 42.47           C
ATOM   4823  CD1 LEU   318      21.984  40.570 -44.121  1.00 43.58           C
ATOM   4827  CD2 LEU   318      23.177  42.128 -45.710  1.00 40.42           C
ATOM   4831  C   LEU   318      21.470  39.560 -48.999  1.00 48.85           C
ATOM   4832  O   LEU   318      20.597  38.705 -49.116  1.00 49.69           O
ATOM   4834  N   SER   319      22.591  39.584 -49.726  1.00 47.14           N
ATOM   4835  CA  SER   319      22.907  38.569 -50.710  1.00 45.62           C
ATOM   4837  CB  SER   319      24.123  39.005 -51.527  1.00 45.41           C
ATOM   4840  OG  SER   319      25.278  39.156 -50.704  1.00 43.76           O
ATOM   4842  C   SER   319      23.192  37.235 -50.027  1.00 44.27           C
ATOM   4843  O   SER   319      23.487  37.207 -48.853  1.00 42.53           O
ATOM   4845  N   GLN   320      23.081  36.136 -50.765  1.00 43.99           N
ATOM   4846  CA  GLN   320      23.448  34.834 -50.238  1.00 46.50           C
ATOM   4848  CB  GLN   320      23.433  33.745 -51.327  1.00 49.38           C
ATOM   4851  CG  GLN   320      22.038  33.397 -51.871  1.00 52.68           C
ATOM   4854  CD  GLN   320      21.130  32.720 -50.839  1.00 52.79           C
ATOM   4855  OE1 GLN   320      21.108  31.494 -50.713  1.00 50.14           O
ATOM   4856  NE2 GLN   320      20.361  33.526 -50.120  1.00 53.65           N
ATOM   4859  C   GLN   320      24.839  34.920 -49.648  1.00 41.81           C
ATOM   4860  O   GLN   320      25.075  34.431 -48.554  1.00 44.61           O
ATOM   4862  N   ALA   321      25.744  35.555 -50.385  1.00 38.99           N
ATOM   4863  CA  ALA   321      27.159  35.641 -50.019  1.00 36.99           C
ATOM   4865  CB  ALA   321      27.992  36.241 -51.198  1.00 36.45           C
ATOM   4869  C   ALA   321      27.377  36.445 -48.757  1.00 34.13           C
ATOM   4870  O   ALA   321      28.171  36.078 -47.932  1.00 36.30           O
ATOM   4872  N   GLU   322      26.674  37.543 -48.607  1.00 34.10           N
ATOM   4873  CA  GLU   322      26.805  38.359 -47.399  1.00 37.52           C
ATOM   4875  CB  GLU   322      26.035  39.667 -47.574  1.00 37.50           C
ATOM   4878  CG  GLU   322      26.690  40.618 -48.607  1.00 40.25           C
ATOM   4881  CD  GLU   322      25.758  41.726 -49.084  1.00 41.39           C
ATOM   4882  OE1 GLU   322      24.539  41.465 -49.209  1.00 41.39           O
ATOM   4883  OE2 GLU   322      26.244  42.859 -49.337  1.00 43.53           O
ATOM   4884  C   GLU   322      26.317  37.607 -46.138  1.00 38.41           C
ATOM   4885  O   GLU   322      26.867  37.763 -45.045  1.00 37.92           O
ATOM   4887  N   LEU   323      25.284  36.796 -46.320  1.00 36.68           N
ATOM   4888  CA  LEU   323      24.678  36.009 -45.243  1.00 34.75           C
ATOM   4890  CB  LEU   323      23.330  35.461 -45.711  1.00 33.16           C
ATOM   4893  CG  LEU   323      22.348  35.043 -44.677  1.00 33.03           C
ATOM   4895  CD1 LEU   323      21.958  36.254 -43.783  1.00 29.34           C
ATOM   4899  CD2 LEU   323      21.140  34.446 -45.413  1.00 33.72           C
ATOM   4903  C   LEU   323      25.546  34.859 -44.880  1.00 30.84           C
ATOM   4904  O   LEU   323      25.718  34.574 -43.704  1.00 29.39           O
ATOM   4906  N   ASN   324      26.065  34.188 -45.917  1.00 32.13           N
ATOM   4907  CA  ASN   324      26.935  33.027 -45.786  1.00 32.69           C
ATOM   4909  CB  ASN   324      27.159  32.363 -47.137  1.00 34.56           C
ATOM   4912  CG  ASN   324      26.025  31.429 -47.550  1.00 38.98           C
ATOM   4913  OD1 ASN   324      25.112  31.129 -46.780  1.00 39.23           O
ATOM   4914  ND2 ASN   324      26.113  30.928 -48.783  1.00 39.06           N
ATOM   4917  C   ASN   324      28.302  33.348 -45.209  1.00 34.10           C
ATOM   4918  O   ASN   324      28.840  32.553 -44.442  1.00 35.78           O
ATOM   4920  N   ASP   325      28.868  34.496 -45.584  1.00 35.29           N
ATOM   4921  CA  ASP   325      30.193  34.915 -45.100  1.00 37.83           C
ATOM   4923  CB  ASP   325      30.927  35.741 -46.187  1.00 42.60           C
ATOM   4926  CG  ASP   325      32.402  36.070 -45.811  1.00 47.22           C
ATOM   4927  OD1 ASP   325      33.027  35.314 -45.030  1.00 49.08           O
ATOM   4928  OD2 ASP   325      32.924  37.094 -46.311  1.00 51.35           O
ATOM   4929  C   ASP   325      30.068  35.700 -43.771  1.00 35.76           C
ATOM   4930  O   ASP   325      30.429  36.896 -43.673  1.00 31.95           O
ATOM   4932  N   LEU   326      29.557  35.003 -42.752  1.00 35.59           N
ATOM   4933  CA  LEU   326      29.392  35.555 -41.397  1.00 33.49           C
ATOM   4935  CB  LEU   326      27.911  35.816 -41.081  1.00 32.58           C
ATOM   4938  CG  LEU   326      27.232  37.022 -41.711  1.00 32.35           C
ATOM   4940  CD1 LEU   326      25.733  36.936 -41.508  1.00 27.72           C
ATOM   4944  CD2 LEU   326      27.797  38.343 -41.126  1.00 32.91           C
ATOM   4948  C   LEU   326      29.962  34.542 -40.402  1.00 32.42           C
ATOM   4949  O   LEU   326      29.205  33.860 -39.723  1.00 28.72           O
ATOM   4951  N   PRO   327      31.308  34.456 -40.310  1.00 33.23           N
ATOM   4952  CA  PRO   327      31.973  33.389 -39.549  1.00 31.71           C
ATOM   4954  CB  PRO   327      33.469  33.616 -39.848  1.00 32.22           C
ATOM   4957  CG  PRO   327      33.498  34.506 -41.018  1.00 34.49           C
ATOM   4960  CD  PRO   327      32.298  35.364 -40.921  1.00 34.27           C
ATOM   4963  C   PRO   327      31.728  33.392 -38.036  1.00 29.56           C
ATOM   4964  O   PRO   327      31.692  32.319 -37.434  1.00 28.80           O
ATOM   4965  N   VAL   328      31.610  34.582 -37.446  1.00 27.07           N
ATOM   4966  CA  VAL   328      31.295  34.735 -36.044  1.00 29.58           C
ATOM   4968  CB  VAL   328      31.342  36.219 -35.560  1.00 28.80           C
ATOM   4970  CG1 VAL   328      30.996  36.284 -34.126  1.00 26.76           C
ATOM   4974  CG2 VAL   328      32.741  36.844 -35.783  1.00 29.01           C
ATOM   4978  C   VAL   328      29.898  34.191 -35.753  1.00 31.46           C
ATOM   4979  O   VAL   328      29.715  33.455 -34.806  1.00 30.76           O
ATOM   4981  N   LEU   329      28.913  34.589 -36.562  1.00 30.01           N
ATOM   4982  CA  LEU   329      27.563  34.072 -36.406  1.00 27.80           C
ATOM   4984  CB  LEU   329      26.611  34.764 -37.361  1.00 28.10           C
ATOM   4987  CG  LEU   329      26.213  36.203 -37.084  1.00 24.39           C
ATOM   4989  CD1 LEU   329      24.824  36.477 -37.711  1.00 23.91           C
ATOM   4993  CD2 LEU   329      26.217  36.519 -35.608  1.00 27.14           C
ATOM   4997  C   LEU   329      27.511  32.557 -36.622  1.00 28.01           C
ATOM   4998  O   LEU   329      26.853  31.840 -35.862  1.00 24.73           O
ATOM   5000  N   ASP   330      28.228  32.080 -37.636  1.00 26.69           N
ATOM   5001  CA  ASP   330      28.302  30.664 -37.925  1.00 26.65           C
ATOM   5003  CB  ASP   330      29.170  30.404 -39.170  1.00 30.11           C
ATOM   5006  CG  ASP   330      28.360  30.341 -40.446  1.00 36.79           C
ATOM   5007  OD1 ASP   330      27.375  29.536 -40.474  1.00 37.47           O
ATOM   5008  OD2 ASP   330      28.698  31.079 -41.427  1.00 36.59           O
ATOM   5009  C   ASP   330      28.871  29.901 -36.734  1.00 28.83           C
ATOM   5010  O   ASP   330      28.410  28.811 -36.411  1.00 30.62           O
ATOM   5012  N   SER   331      29.894  30.460 -36.096  1.00 28.77           N
ATOM   5013  CA  SER   331      30.579  29.797 -34.981  1.00 24.39           C
ATOM   5015  CB  SER   331      31.940  30.480 -34.689  1.00 25.31           C
ATOM   5018  OG  SER   331      32.652  29.802 -33.650  1.00 27.80           O
ATOM   5020  C   SER   331      29.715  29.779 -33.748  1.00 22.72           C
ATOM   5021  O   SER   331      29.651  28.783 -33.073  1.00 23.08           O
ATOM   5023  N   ILE   332      29.078  30.925 -33.438  1.00 25.82           N
ATOM   5024  CA  ILE   332      28.053  31.018 -32.412  1.00 23.72           C
ATOM   5026  CB  ILE   332      27.451  32.474 -32.343  1.00 24.70           C
ATOM   5028  CG1 ILE   332      28.451  33.446 -31.673  1.00 23.56           C
ATOM   5031  CD1 ILE   332      28.037  34.967 -31.846  1.00 25.11           C
ATOM   5035  CG2 ILE   332      26.175  32.537 -31.550  1.00 21.80           C
ATOM   5039  C   ILE   332      26.949  29.957 -32.601  1.00 27.57           C
ATOM   5040  O   ILE   332      26.585  29.226 -31.648  1.00 27.99           O
ATOM   5042  N   ILE   333      26.428  29.841 -33.815  1.00 26.98           N
ATOM   5043  CA  ILE   333      25.390  28.837 -34.080  1.00 23.96           C
ATOM   5045  CB  ILE   333      24.757  29.026 -35.450  1.00 22.15           C
ATOM   5047  CG1 ILE   333      24.051  30.385 -35.516  1.00 20.28           C
ATOM   5050  CD1 ILE   333      23.734  30.842 -36.984  1.00 19.39           C
ATOM   5054  CG2 ILE   333      23.753  27.890 -35.753  1.00 16.71           C
ATOM   5058  C   ILE   333      25.938  27.422 -33.958  1.00 24.64           C
ATOM   5059  O   ILE   333      25.351  26.591 -33.285  1.00 24.33           O
ATOM   5061  N   LYS   334      27.070  27.131 -34.598  1.00 25.35           N
ATOM   5062  CA  LYS   334      27.663  25.797 -34.469  1.00 25.61           C
ATOM   5064  CB  LYS   334      28.951  25.653 -35.262  1.00 29.96           C
ATOM   5067  CG  LYS   334      28.736  25.548 -36.727  1.00 29.66           C
ATOM   5070  CD  LYS   334      30.042  25.493 -37.490  1.00 34.78           C
ATOM   5073  CE  LYS   334      29.787  25.493 -38.986  1.00 36.75           C
ATOM   5076  NZ  LYS   334      30.638  26.552 -39.569  1.00 42.35           N
ATOM   5080  C   LYS   334      27.965  25.412 -33.055  1.00 24.63           C
ATOM   5081  O   LYS   334      27.748  24.271 -32.680  1.00 26.79           O
ATOM   5083  N   GLU   335      28.518  26.333 -32.278  1.00 22.40           N
ATOM   5084  CA  GLU   335      28.834  26.059 -30.871  1.00 23.22           C
ATOM   5086  CB  GLU   335      29.636  27.229 -30.256  1.00 27.82           C
ATOM   5089  CG  GLU   335      30.088  27.022 -28.759  1.00 28.74           C
ATOM   5092  CD  GLU   335      31.145  25.995 -28.584  1.00 31.43           C
ATOM   5093  OE1 GLU   335      31.356  25.251 -29.531  1.00 35.24           O
ATOM   5094  OE2 GLU   335      31.772  25.910 -27.485  1.00 31.50           O
ATOM   5095  C   GLU   335      27.581  25.813 -30.046  1.00 24.57           C
ATOM   5096  O   GLU   335      27.596  24.998 -29.154  1.00 29.56           O
ATOM   5098  N   SER   336      26.489  26.530 -30.353  1.00 25.64           N
ATOM   5099  CA  SER   336      25.214  26.355 -29.673  1.00 23.28           C
ATOM   5101  CB  SER   336      24.286  27.460 -30.069  1.00 24.87           C
ATOM   5104  OG  SER   336      24.809  28.723 -29.598  1.00 23.69           O
ATOM   5106  C   SER   336      24.613  24.954 -29.926  1.00 24.87           C
ATOM   5107  O   SER   336      24.116  24.289 -29.006  1.00 26.60           O
ATOM   5109  N   LEU   337      24.754  24.479 -31.141  1.00 25.75           N
ATOM   5110  CA  LEU   337      24.262  23.173 -31.535  1.00 23.85           C
ATOM   5112  CB  LEU   337      24.116  23.115 -33.030  1.00 23.48           C
ATOM   5115  CG  LEU   337      23.147  24.144 -33.660  1.00 25.88           C
ATOM   5117  CD1 LEU   337      22.879  23.707 -35.113  1.00 24.42           C
ATOM   5121  CD2 LEU   337      21.851  24.315 -32.869  1.00 25.26           C
ATOM   5125  C   LEU   337      25.167  22.041 -31.114  1.00 26.58           C
ATOM   5126  O   LEU   337      24.677  20.952 -30.854  1.00 23.61           O
ATOM   5128  N   ARG   338      26.496  22.269 -31.090  1.00 25.65           N
ATOM   5129  CA  ARG   338      27.421  21.297 -30.510  1.00 23.22           C
ATOM   5131  CB  ARG   338      28.880  21.835 -30.497  1.00 24.03           C
ATOM   5134  CG  ARG   338      29.932  20.759 -30.069  1.00 24.29           C
ATOM   5137  CD  ARG   338      31.357  21.309 -29.844  1.00 23.97           C
ATOM   5140  NE  ARG   338      31.356  22.283 -28.788  1.00 21.03           N
ATOM   5142  CZ  ARG   338      31.424  21.987 -27.503  1.00 19.02           C
ATOM   5143  NH1 ARG   338      31.556  20.740 -27.121  1.00 18.09           N
ATOM   5146  NH2 ARG   338      31.372  22.967 -26.596  1.00 19.55           N
ATOM   5149  C   ARG   338      26.971  20.948 -29.066  1.00 24.93           C
ATOM   5150  O   ARG   338      26.978  19.789 -28.660  1.00 29.67           O
ATOM   5152  N   LEU   339      26.559  21.967 -28.318  1.00 23.46           N
ATOM   5153  CA  LEU   339      26.140  21.799 -26.956  1.00 25.18           C
ATOM   5155  CB  LEU   339      26.263  23.126 -26.180  1.00 26.69           C
ATOM   5158  CG  LEU   339      27.704  23.568 -25.829  1.00 25.35           C
ATOM   5160  CD1 LEU   339      27.740  25.057 -25.379  1.00 25.47           C
ATOM   5164  CD2 LEU   339      28.231  22.653 -24.739  1.00 26.19           C
ATOM   5168  C   LEU   339      24.725  21.205 -26.802  1.00 25.34           C
ATOM   5169  O   LEU   339      24.488  20.513 -25.829  1.00 30.93           O
ATOM   5171  N   SER   340      23.823  21.419 -27.772  1.00 24.94           N
ATOM   5172  CA  SER   340      22.383  21.025 -27.633  1.00 22.47           C
ATOM   5174  CB  SER   340      21.504  22.243 -27.869  1.00 19.43           C
ATOM   5177  OG  SER   340      21.735  22.781 -29.173  1.00 20.46           O
ATOM   5179  C   SER   340      21.903  19.860 -28.543  1.00 23.41           C
ATOM   5180  O   SER   340      20.837  19.301 -28.323  1.00 26.42           O
ATOM   5182  N   SER   341      22.676  19.496 -29.552  1.00 24.51           N
ATOM   5183  CA  SER   341      22.261  18.476 -30.492  1.00 25.53           C
ATOM   5185  CB  SER   341      23.176  18.465 -31.716  1.00 23.01           C
ATOM   5188  OG  SER   341      22.962  17.296 -32.530  1.00 22.02           O
ATOM   5190  C   SER   341      22.234  17.096 -29.826  1.00 28.85           C
ATOM   5191  O   SER   341      23.202  16.719 -29.165  1.00 30.92           O
ATOM   5193  N   ALA   342      21.123  16.361 -29.999  1.00 23.69           N
ATOM   5194  CA  ALA   342      20.997  14.995 -29.486  1.00 26.17           C
ATOM   5196  CB  ALA   342      20.308  14.965 -28.134  1.00 24.65           C
ATOM   5200  C   ALA   342      20.240  14.115 -30.460  1.00 24.14           C
ATOM   5201  O   ALA   342      19.246  13.570 -30.110  1.00 28.16           O
ATOM   5203  N   SER   343      20.703  14.013 -31.698  1.00 26.35           N
ATOM   5204  CA  SER   343      20.124  13.042 -32.663  1.00 27.30           C
ATOM   5206  CB  SER   343      20.445  13.448 -34.085  1.00 26.16           C
ATOM   5209  OG  SER   343      19.890  14.674 -34.401  1.00 25.52           O
ATOM   5211  C   SER   343      20.599  11.589 -32.471  1.00 25.71           C
ATOM   5212  O   SER   343      21.755  11.316 -32.067  1.00 25.95           O
ATOM   5214  N   LEU   344      19.683  10.665 -32.719  1.00 26.61           N
ATOM   5215  CA  LEU   344      20.026   9.281 -33.017  1.00 29.03           C
ATOM   5217  CB  LEU   344      18.951   8.308 -32.558  1.00 30.91           C
ATOM   5220  CG  LEU   344      19.095   7.539 -31.277  1.00 32.90           C
ATOM   5222  CD1 LEU   344      17.747   6.785 -31.066  1.00 36.66           C
ATOM   5226  CD2 LEU   344      20.281   6.571 -31.303  1.00 26.81           C
ATOM   5230  C   LEU   344      20.111   9.187 -34.500  1.00 31.42           C
ATOM   5231  O   LEU   344      19.108   9.406 -35.212  1.00 34.15           O
ATOM   5233  N   ASN   345      21.291   8.872 -34.988  1.00 34.34           N
ATOM   5234  CA  ASN   345      21.538   8.690 -36.400  1.00 31.90           C
ATOM   5236  CB  ASN   345      22.928   9.237 -36.728  1.00 33.36           C
ATOM   5239  CG  ASN   345      23.282   9.120 -38.208  1.00 35.35           C
ATOM   5240  OD1 ASN   345      23.520   8.043 -38.687  1.00 35.56           O
ATOM   5241  ND2 ASN   345      23.337  10.237 -38.909  1.00 33.89           N
ATOM   5244  C   ASN   345      21.409   7.173 -36.690  1.00 33.70           C
ATOM   5245  O   ASN   345      22.158   6.385 -36.160  1.00 33.60           O
ATOM   5247  N   ILE   346      20.457   6.792 -37.547  1.00 32.30           N
ATOM   5248  CA  ILE   346      20.020   5.417 -37.663  1.00 31.19           C
ATOM   5250  CB  ILE   346      18.574   5.296 -37.131  1.00 33.27           C
ATOM   5252  CG1 ILE   346      18.586   5.164 -35.613  1.00 34.53           C
ATOM   5255  CD1 ILE   346      17.197   5.204 -35.008  1.00 33.42           C
ATOM   5259  CG2 ILE   346      17.866   4.095 -37.708  1.00 37.12           C
ATOM   5263  C   ILE   346      20.094   4.874 -39.102  1.00 32.55           C
ATOM   5264  O   ILE   346      19.937   5.615 -40.079  1.00 30.97           O
ATOM   5266  N   ARG   347      20.395   3.574 -39.209  1.00 32.01           N
ATOM   5267  CA  ARG   347      20.130   2.800 -40.423  1.00 33.49           C
ATOM   5269  CB  ARG   347      21.268   2.906 -41.478  1.00 34.58           C
ATOM   5272  CG  ARG   347      22.536   2.056 -41.224  1.00 36.47           C
ATOM   5275  CD  ARG   347      23.520   2.732 -40.284  1.00 37.10           C
ATOM   5278  NE  ARG   347      23.751   4.106 -40.716  1.00 38.45           N
ATOM   5280  CZ  ARG   347      23.820   5.176 -39.906  1.00 37.47           C
ATOM   5281  NH1 ARG   347      23.998   6.377 -40.457  1.00 39.13           N
ATOM   5284  NH2 ARG   347      23.695   5.065 -38.570  1.00 33.02           N
ATOM   5287  C   ARG   347      19.830   1.367 -40.011  1.00 34.14           C
ATOM   5288  O   ARG   347      20.121   0.964 -38.884  1.00 30.76           O
ATOM   5290  N   THR   348      19.226   0.608 -40.922  1.00 34.41           N
ATOM   5291  CA  THR   348      18.781  -0.748 -40.631  1.00 34.66           C
ATOM   5293  CB  THR   348      17.264  -0.879 -40.929  1.00 35.18           C
ATOM   5295  OG1 THR   348      16.543   0.133 -40.202  1.00 33.90           O
ATOM   5297  CG2 THR   348      16.753  -2.259 -40.538  1.00 32.83           C
ATOM   5301  C   THR   348      19.578  -1.765 -41.456  1.00 36.72           C
ATOM   5302  O   THR   348      19.839  -1.539 -42.642  1.00 34.57           O
ATOM   5304  N   ALA   349      19.985  -2.868 -40.820  1.00 40.25           N
ATOM   5305  CA  ALA   349      20.645  -3.985 -41.530  1.00 39.80           C
ATOM   5307  CB  ALA   349      21.134  -5.058 -40.533  1.00 38.11           C
ATOM   5311  C   ALA   349      19.723  -4.623 -42.580  1.00 40.72           C
ATOM   5312  O   ALA   349      18.719  -5.245 -42.240  1.00 41.45           O
ATOM   5314  N   LYS   350      20.097  -4.457 -43.850  1.00 44.20           N
ATOM   5315  CA  LYS   350      19.393  -5.046 -45.009  1.00 47.16           C
ATOM   5317  CB  LYS   350      20.030  -4.531 -46.314  1.00 47.21           C
ATOM   5320  CG  LYS   350      19.125  -3.784 -47.216  1.00 49.78           C
ATOM   5323  CD  LYS   350      19.910  -2.977 -48.247  1.00 53.01           C
ATOM   5326  CE  LYS   350      18.992  -2.100 -49.113  1.00 56.70           C
ATOM   5329  NZ  LYS   350      19.698  -0.901 -49.736  1.00 58.21           N
ATOM   5333  C   LYS   350      19.437  -6.599 -44.967  1.00 47.53           C
ATOM   5334  O   LYS   350      18.520  -7.263 -45.424  1.00 47.58           O
ATOM   5336  N   GLU   351      20.509  -7.146 -44.394  1.00 49.33           N
ATOM   5337  CA  GLU   351      20.682  -8.601 -44.219  1.00 48.84           C
ATOM   5339  CB  GLU   351      21.248  -9.227 -45.514  1.00 48.24           C
ATOM   5346  C   GLU   351      21.636  -8.882 -43.031  1.00 49.14           C
ATOM   5347  O   GLU   351      22.164  -7.942 -42.403  1.00 45.22           O
ATOM   5349  N   ASP   352      21.849 -10.166 -42.722  1.00 48.51           N
ATOM   5350  CA  ASP   352      22.878 -10.559 -41.771  1.00 49.59           C
ATOM   5352  CB  ASP   352      22.820 -12.065 -41.472  1.00 53.26           C
ATOM   5355  CG  ASP   352      21.667 -12.451 -40.565  1.00 54.96           C
ATOM   5356  OD1 ASP   352      20.721 -11.667 -40.403  1.00 57.53           O
ATOM   5357  OD2 ASP   352      21.705 -13.563 -40.010  1.00 58.42           O
ATOM   5358  C   ASP   352      24.241 -10.193 -42.371  1.00 49.14           C
ATOM   5359  O   ASP   352      24.472 -10.388 -43.565  1.00 50.31           O
ATOM   5361  N   PHE   353      25.129  -9.625 -41.569  1.00 48.05           N
ATOM   5362  CA  PHE   353      26.448  -9.257 -42.077  1.00 46.57           C
ATOM   5364  CB  PHE   353      26.366  -8.071 -43.066  1.00 45.06           C
ATOM   5367  CG  PHE   353      26.243  -6.729 -42.413  1.00 44.30           C
ATOM   5368  CD1 PHE   353      27.302  -5.830 -42.444  1.00 44.08           C
ATOM   5370  CE1 PHE   353      27.194  -4.564 -41.848  1.00 43.51           C
ATOM   5372  CZ  PHE   353      26.011  -4.194 -41.223  1.00 43.44           C
ATOM   5374  CE2 PHE   353      24.932  -5.081 -41.189  1.00 43.40           C
ATOM   5376  CD2 PHE   353      25.048  -6.342 -41.784  1.00 44.48           C
ATOM   5378  C   PHE   353      27.422  -8.973 -40.957  1.00 44.74           C
ATOM   5379  O   PHE   353      27.069  -9.029 -39.795  1.00 44.59           O
ATOM   5381  N   THR   354      28.666  -8.724 -41.336  1.00 45.59           N
ATOM   5382  CA  THR   354      29.717  -8.404 -40.402  1.00 44.48           C
ATOM   5384  CB  THR   354      30.910  -9.389 -40.558  1.00 45.43           C
ATOM   5386  OG1 THR   354      30.447 -10.720 -40.279  1.00 46.62           O
ATOM   5388  CG2 THR   354      32.064  -9.054 -39.603  1.00 42.87           C
ATOM   5392  C   THR   354      30.141  -6.977 -40.671  1.00 43.81           C
ATOM   5393  O   THR   354      30.475  -6.615 -41.808  1.00 42.21           O
ATOM   5395  N   LEU   355      30.098  -6.164 -39.621  1.00 42.39           N
ATOM   5396  CA  LEU   355      30.477  -4.771 -39.699  1.00 42.17           C
ATOM   5398  CB  LEU   355      29.551  -3.938 -38.799  1.00 42.19           C
ATOM   5401  CG  LEU   355      29.696  -2.419 -38.697  1.00 40.60           C
ATOM   5403  CD1 LEU   355      29.794  -1.749 -40.059  1.00 40.49           C
ATOM   5407  CD2 LEU   355      28.528  -1.884 -37.937  1.00 42.25           C
ATOM   5411  C   LEU   355      31.892  -4.663 -39.217  1.00 41.81           C
ATOM   5412  O   LEU   355      32.180  -5.114 -38.120  1.00 43.57           O
ATOM   5414  N   HIS   356      32.775  -4.071 -40.028  1.00 42.70           N
ATOM   5415  CA  HIS   356      34.212  -3.983 -39.696  1.00 45.75           C
ATOM   5417  CB  HIS   356      35.076  -4.404 -40.903  1.00 48.75           C
ATOM   5420  CG  HIS   356      34.801  -5.798 -41.386  1.00 49.93           C
ATOM   5421  ND1 HIS   356      35.152  -6.918 -40.662  1.00 50.41           N
ATOM   5423  CE1 HIS   356      34.778  -8.003 -41.320  1.00 51.60           C
ATOM   5425  NE2 HIS   356      34.196  -7.628 -42.447  1.00 50.94           N
ATOM   5427  CD2 HIS   356      34.201  -6.253 -42.515  1.00 51.03           C
ATOM   5429  C   HIS   356      34.563  -2.580 -39.274  1.00 46.25           C
ATOM   5430  O   HIS   356      34.519  -1.659 -40.088  1.00 48.20           O
ATOM   5432  N   LEU   357      34.902  -2.402 -37.996  1.00 47.69           N
ATOM   5433  CA  LEU   357      35.273  -1.079 -37.461  1.00 47.36           C
ATOM   5435  CB  LEU   357      34.321  -0.672 -36.326  1.00 46.81           C
ATOM   5438  CG  LEU   357      32.828  -0.792 -36.612  1.00 44.64           C
ATOM   5440  CD1 LEU   357      32.039  -0.712 -35.327  1.00 45.63           C
ATOM   5444  CD2 LEU   357      32.393   0.270 -37.601  1.00 44.26           C
ATOM   5448  C   LEU   357      36.708  -1.095 -36.938  1.00 49.80           C
ATOM   5449  O   LEU   357      37.325  -2.151 -36.850  1.00 49.53           O
ATOM   5451  N   GLU   358      37.212   0.086 -36.574  1.00 52.39           N
ATOM   5452  CA  GLU   358      38.506   0.231 -35.883  1.00 55.39           C
ATOM   5454  CB  GLU   358      38.783   1.708 -35.530  1.00 55.72           C
ATOM   5457  CG  GLU   358      38.868   2.668 -36.728  1.00 58.13           C
ATOM   5463  C   GLU   358      38.523  -0.587 -34.589  1.00 58.40           C
ATOM   5464  O   GLU   358      39.567  -1.072 -34.173  1.00 63.44           O
ATOM   5466  N   ASP   359      37.348  -0.738 -33.970  1.00 59.55           N
ATOM   5467  CA  ASP   359      37.182  -1.435 -32.680  1.00 57.94           C
ATOM   5469  CB  ASP   359      35.865  -0.990 -32.021  1.00 58.29           C
ATOM   5472  CG  ASP   359      35.742   0.522 -31.919  1.00 59.64           C
ATOM   5473  OD1 ASP   359      34.992   1.127 -32.741  1.00 58.43           O
ATOM   5474  OD2 ASP   359      36.416   1.100 -31.032  1.00 60.56           O
ATOM   5475  C   ASP   359      37.160  -2.962 -32.803  1.00 57.56           C
ATOM   5476  O   ASP   359      37.170  -3.659 -31.796  1.00 57.53           O
ATOM   5478  N   GLY   360      37.108  -3.478 -34.032  1.00 57.28           N
ATOM   5479  CA  GLY   360      36.986  -4.920 -34.260  1.00 54.83           C
ATOM   5482  C   GLY   360      35.864  -5.198 -35.232  1.00 52.91           C
ATOM   5483  O   GLY   360      35.394  -4.303 -35.924  1.00 52.61           O
ATOM   5485  N   SER   361      35.437  -6.448 -35.279  1.00 52.42           N
ATOM   5486  CA  SER   361      34.441  -6.883 -36.234  1.00 52.77           C
ATOM   5488  CB  SER   361      35.038  -7.901 -37.204  1.00 54.37           C
ATOM   5491  OG  SER   361      35.921  -7.271 -38.111  1.00 54.59           O
ATOM   5493  C   SER   361      33.270  -7.491 -35.483  1.00 52.31           C
ATOM   5494  O   SER   361      33.463  -8.302 -34.562  1.00 53.93           O
ATOM   5496  N   TYR   362      32.058  -7.093 -35.874  1.00 48.67           N
ATOM   5497  CA  TYR   362      30.852  -7.430 -35.125  1.00 44.86           C
ATOM   5499  CB  TYR   362      30.367  -6.205 -34.362  1.00 42.40           C
ATOM   5502  CG  TYR   362      31.392  -5.606 -33.423  1.00 41.42           C
ATOM   5503  CD1 TYR   362      32.243  -4.606 -33.841  1.00 40.88           C
ATOM   5505  CE1 TYR   362      33.173  -4.061 -32.987  1.00 40.87           C
ATOM   5507  CZ  TYR   362      33.250  -4.510 -31.687  1.00 41.89           C
ATOM   5508  OH  TYR   362      34.181  -3.960 -30.820  1.00 44.14           O
ATOM   5510  CE2 TYR   362      32.418  -5.484 -31.244  1.00 39.80           C
ATOM   5512  CD2 TYR   362      31.493  -6.032 -32.109  1.00 41.65           C
ATOM   5514  C   TYR   362      29.753  -7.952 -36.059  1.00 42.76           C
ATOM   5515  O   TYR   362      29.432  -7.330 -37.064  1.00 43.92           O
ATOM   5517  N   ASN   363      29.188  -9.102 -35.728  1.00 44.14           N
ATOM   5518  CA  ASN   363      28.124  -9.671 -36.528  1.00 44.23           C
ATOM   5520  CB  ASN   363      27.992 -11.176 -36.263  1.00 45.67           C
ATOM   5523  CG  ASN   363      29.097 -11.986 -36.904  1.00 47.40           C
ATOM   5524  OD1 ASN   363      29.477 -11.751 -38.051  1.00 50.00           O
ATOM   5525  ND2 ASN   363      29.600 -12.964 -36.176  1.00 48.56           N
ATOM   5528  C   ASN   363      26.799  -8.979 -36.213  1.00 42.86           C
ATOM   5529  O   ASN   363      26.440  -8.806 -35.036  1.00 41.15           O
ATOM   5531  N   ILE   364      26.070  -8.607 -37.265  1.00 41.90           N
ATOM   5532  CA  ILE   364      24.804  -7.915 -37.120  1.00 40.45           C
ATOM   5534  CB  ILE   364      24.923  -6.439 -37.622  1.00 39.55           C
ATOM   5536  CG1 ILE   364      25.833  -5.642 -36.678  1.00 38.73           C
ATOM   5539  CD1 ILE   364      27.002  -5.217 -37.286  1.00 40.32           C
ATOM   5543  CG2 ILE   364      23.568  -5.756 -37.681  1.00 35.89           C
ATOM   5547  C   ILE   364      23.703  -8.652 -37.856  1.00 42.89           C
ATOM   5548  O   ILE   364      23.850  -8.975 -39.017  1.00 46.40           O
ATOM   5550  N   ARG   365      22.582  -8.897 -37.180  1.00 44.55           N
ATOM   5551  CA  ARG   365      21.458  -9.602 -37.799  1.00 44.22           C
ATOM   5553  CB  ARG   365      20.567 -10.235 -36.733  1.00 42.68           C
ATOM   5556  CG  ARG   365      21.312 -11.121 -35.794  1.00 42.10           C
ATOM   5559  CD  ARG   365      20.388 -11.835 -34.860  1.00 41.07           C
ATOM   5562  NE  ARG   365      21.090 -12.227 -33.655  1.00 38.82           N
ATOM   5564  CZ  ARG   365      20.525 -12.872 -32.637  1.00 40.18           C
ATOM   5565  NH1 ARG   365      19.248 -13.242 -32.686  1.00 40.42           N
ATOM   5568  NH2 ARG   365      21.245 -13.169 -31.566  1.00 38.50           N
ATOM   5571  C   ARG   365      20.622  -8.692 -38.685  1.00 46.75           C
ATOM   5572  O   ARG   365      20.650  -7.451 -38.559  1.00 47.73           O
ATOM   5574  N   LYS   366      19.875  -9.314 -39.589  1.00 46.69           N
ATOM   5575  CA  LYS   366      18.966  -8.596 -40.473  1.00 47.35           C
ATOM   5577  CB  LYS   366      18.276  -9.590 -41.406  1.00 47.95           C
ATOM   5580  CG  LYS   366      17.393  -8.979 -42.475  1.00 49.23           C
ATOM   5583  CD  LYS   366      16.541 -10.061 -43.133  1.00 50.52           C
ATOM   5586  CE  LYS   366      15.608  -9.477 -44.174  1.00 53.24           C
ATOM   5589  NZ  LYS   366      14.306 -10.211 -44.199  1.00 55.06           N
ATOM   5593  C   LYS   366      17.921  -7.857 -39.634  1.00 44.19           C
ATOM   5594  O   LYS   366      17.396  -8.414 -38.680  1.00 40.85           O
ATOM   5596  N   ASP   367      17.638  -6.606 -40.006  1.00 44.97           N
ATOM   5597  CA  ASP   367      16.664  -5.731 -39.293  1.00 47.00           C
ATOM   5599  CB  ASP   367      15.282  -6.420 -39.121  1.00 49.82           C
ATOM   5602  CG  ASP   367      14.582  -6.670 -40.446  1.00 51.66           C
ATOM   5603  OD1 ASP   367      14.719  -5.842 -41.379  1.00 52.52           O
ATOM   5604  OD2 ASP   367      13.876  -7.698 -40.536  1.00 55.70           O
ATOM   5605  C   ASP   367      17.137  -5.163 -37.937  1.00 42.50           C
ATOM   5606  O   ASP   367      16.363  -4.503 -37.237  1.00 43.44           O
ATOM   5608  N   ASP   368      18.390  -5.420 -37.570  1.00 41.60           N
ATOM   5609  CA  ASP   368      19.015  -4.720 -36.449  1.00 37.35           C
ATOM   5611  CB  ASP   368      20.375  -5.337 -36.094  1.00 39.36           C
ATOM   5614  CG  ASP   368      20.251  -6.619 -35.316  1.00 37.01           C
ATOM   5615  OD1 ASP   368      19.119  -7.027 -35.030  1.00 38.45           O
ATOM   5616  OD2 ASP   368      21.295  -7.209 -34.973  1.00 36.39           O
ATOM   5617  C   ASP   368      19.206  -3.253 -36.829  1.00 34.64           C
ATOM   5618  O   ASP   368      19.313  -2.922 -38.001  1.00 36.26           O
ATOM   5620  N   ILE   369      19.224  -2.372 -35.842  1.00 36.04           N
ATOM   5621  CA  ILE   369      19.580  -0.971 -36.106  1.00 37.03           C
ATOM   5623  CB  ILE   369      18.620   0.034 -35.413  1.00 37.15           C
ATOM   5625  CG1 ILE   369      17.281   0.051 -36.166  1.00 37.83           C
ATOM   5628  CD1 ILE   369      16.367  -0.871 -35.628  1.00 39.93           C
ATOM   5632  CG2 ILE   369      19.199   1.468 -35.373  1.00 34.15           C
ATOM   5636  C   ILE   369      21.040  -0.739 -35.738  1.00 35.00           C
ATOM   5637  O   ILE   369      21.539  -1.301 -34.769  1.00 34.64           O
ATOM   5639  N   ILE   370      21.712   0.051 -36.578  1.00 34.00           N
ATOM   5640  CA  ILE   370      23.067   0.516 -36.345  1.00 34.99           C
ATOM   5642  CB  ILE   370      23.983   0.203 -37.583  1.00 36.08           C
ATOM   5644  CG1 ILE   370      24.089  -1.323 -37.804  1.00 37.55           C
ATOM   5647  CD1 ILE   370      23.982  -1.726 -39.297  1.00 40.48           C
ATOM   5651  CG2 ILE   370      25.349   0.781 -37.404  1.00 32.80           C
ATOM   5655  C   ILE   370      22.939   2.019 -36.103  1.00 32.81           C
ATOM   5656  O   ILE   370      22.433   2.746 -36.948  1.00 32.24           O
ATOM   5658  N   ALA   371      23.350   2.471 -34.926  1.00 31.87           N
ATOM   5659  CA  ALA   371      23.094   3.838 -34.518  1.00 30.53           C
ATOM   5661  CB  ALA   371      22.098   3.872 -33.414  1.00 28.80           C
ATOM   5665  C   ALA   371      24.352   4.530 -34.080  1.00 30.05           C
ATOM   5666  O   ALA   371      25.266   3.899 -33.549  1.00 28.47           O
ATOM   5668  N   LEU   372      24.376   5.837 -34.327  1.00 29.87           N
ATOM   5669  CA  LEU   372      25.325   6.755 -33.722  1.00 28.32           C
ATOM   5671  CB  LEU   372      26.027   7.606 -34.784  1.00 27.05           C
ATOM   5674  CG  LEU   372      26.772   6.902 -35.921  1.00 27.94           C
ATOM   5676  CD1 LEU   372      27.376   7.984 -36.825  1.00 28.30           C
ATOM   5680  CD2 LEU   372      27.799   6.002 -35.413  1.00 20.86           C
ATOM   5684  C   LEU   372      24.549   7.664 -32.828  1.00 27.95           C
ATOM   5685  O   LEU   372      23.384   7.949 -33.094  1.00 26.85           O
ATOM   5687  N   TYR   373      25.192   8.131 -31.773  1.00 25.84           N
ATOM   5688  CA  TYR   373      24.654   9.202 -30.946  1.00 24.93           C
ATOM   5690  CB  TYR   373      24.256   8.648 -29.543  1.00 22.30           C
ATOM   5693  CG  TYR   373      23.239   9.480 -28.794  1.00 21.37           C
ATOM   5694  CD1 TYR   373      21.867   9.468 -29.159  1.00 23.03           C
ATOM   5696  CE1 TYR   373      20.958  10.235 -28.493  1.00 21.29           C
ATOM   5698  CZ  TYR   373      21.377  11.045 -27.446  1.00 22.94           C
ATOM   5699  OH  TYR   373      20.480  11.831 -26.745  1.00 22.34           O
ATOM   5701  CE2 TYR   373      22.715  11.073 -27.075  1.00 24.03           C
ATOM   5703  CD2 TYR   373      23.622  10.288 -27.735  1.00 22.16           C
ATOM   5705  C   TYR   373      25.721  10.312 -30.876  1.00 22.89           C
ATOM   5706  O   TYR   373      26.467  10.405 -29.902  1.00 22.20           O
ATOM   5708  N   PRO   374      25.801  11.147 -31.930  1.00 26.35           N
ATOM   5709  CA  PRO   374      26.880  12.148 -32.054  1.00 24.80           C
ATOM   5711  CB  PRO   374      26.560  12.851 -33.403  1.00 25.24           C
ATOM   5714  CG  PRO   374      25.834  11.810 -34.181  1.00 24.33           C
ATOM   5717  CD  PRO   374      24.940  11.162 -33.133  1.00 26.27           C
ATOM   5720  C   PRO   374      27.068  13.146 -30.910  1.00 25.32           C
ATOM   5721  O   PRO   374      28.147  13.724 -30.804  1.00 24.29           O
ATOM   5722  N   GLN   375      26.081  13.329 -30.041  1.00 23.18           N
ATOM   5723  CA  GLN   375      26.304  14.113 -28.855  1.00 24.30           C
ATOM   5725  CB  GLN   375      25.096  14.108 -27.944  1.00 24.26           C
ATOM   5728  CG  GLN   375      25.214  15.107 -26.747  1.00 26.50           C
ATOM   5731  CD  GLN   375      23.936  15.190 -25.938  1.00 28.63           C
ATOM   5732  OE1 GLN   375      23.380  14.168 -25.562  1.00 35.10           O
ATOM   5733  NE2 GLN   375      23.472  16.402 -25.661  1.00 30.24           N
ATOM   5736  C   GLN   375      27.537  13.589 -28.053  1.00 23.42           C
ATOM   5737  O   GLN   375      28.216  14.350 -27.396  1.00 24.50           O
ATOM   5739  N   LEU   376      27.768  12.292 -28.095  1.00 24.54           N
ATOM   5740  CA  LEU   376      28.915  11.680 -27.435  1.00 26.20           C
ATOM   5742  CB  LEU   376      28.831  10.169 -27.606  1.00 25.80           C
ATOM   5745  CG  LEU   376      27.784   9.390 -26.810  1.00 23.31           C
ATOM   5747  CD1 LEU   376      27.702   7.966 -27.373  1.00 17.35           C
ATOM   5751  CD2 LEU   376      28.185   9.362 -25.341  1.00 23.82           C
ATOM   5755  C   LEU   376      30.268  12.209 -28.006  1.00 29.41           C
ATOM   5756  O   LEU   376      31.237  12.352 -27.287  1.00 30.53           O
ATOM   5758  N   MET   377      30.294  12.502 -29.303  1.00 31.81           N
ATOM   5759  CA  MET   377      31.458  13.082 -29.953  1.00 33.16           C
ATOM   5761  CB  MET   377      31.415  12.784 -31.447  1.00 36.51           C
ATOM   5764  CG  MET   377      32.503  13.544 -32.227  1.00 39.90           C
ATOM   5767  SD  MET   377      32.121  13.721 -33.904  1.00 49.21           S
ATOM   5768  CE  MET   377      30.659  14.766 -33.841  1.00 38.61           C
ATOM   5772  C   MET   377      31.552  14.592 -29.725  1.00 29.13           C
ATOM   5773  O   MET   377      32.636  15.116 -29.458  1.00 26.66           O
ATOM   5775  N   HIS   378      30.417  15.292 -29.841  1.00 27.29           N
ATOM   5776  CA  HIS   378      30.338  16.750 -29.652  1.00 22.35           C
ATOM   5778  CB  HIS   378      28.883  17.242 -29.832  1.00 25.30           C
ATOM   5781  CG  HIS   378      28.382  17.196 -31.244  1.00 26.00           C
ATOM   5782  ND1 HIS   378      27.045  17.091 -31.549  1.00 24.06           N
ATOM   5784  CE1 HIS   378      26.895  17.093 -32.859  1.00 24.98           C
ATOM   5786  NE2 HIS   378      28.087  17.165 -33.414  1.00 25.29           N
ATOM   5788  CD2 HIS   378      29.036  17.222 -32.428  1.00 26.47           C
ATOM   5790  C   HIS   378      30.816  17.216 -28.286  1.00 23.84           C
ATOM   5791  O   HIS   378      31.372  18.331 -28.125  1.00 20.62           O
ATOM   5793  N   LEU   379      30.551  16.394 -27.286  1.00 23.94           N
ATOM   5794  CA  LEU   379      30.942  16.683 -25.934  1.00 26.38           C
ATOM   5796  CB  LEU   379      29.775  16.350 -24.988  1.00 24.21           C
ATOM   5799  CG  LEU   379      28.426  17.034 -25.304  1.00 25.88           C
ATOM   5801  CD1 LEU   379      27.423  16.628 -24.271  1.00 27.44           C
ATOM   5805  CD2 LEU   379      28.540  18.565 -25.309  1.00 26.75           C
ATOM   5809  C   LEU   379      32.234  15.924 -25.528  1.00 25.98           C
ATOM   5810  O   LEU   379      32.580  15.908 -24.374  1.00 26.50           O
ATOM   5812  N   ASP   380      32.941  15.322 -26.489  1.00 28.69           N
ATOM   5813  CA  ASP   380      34.181  14.591 -26.195  1.00 28.19           C
ATOM   5815  CB  ASP   380      34.545  13.677 -27.344  1.00 32.02           C
ATOM   5818  CG  ASP   380      35.709  12.754 -27.013  1.00 33.61           C
ATOM   5819  OD1 ASP   380      36.616  13.166 -26.277  1.00 37.02           O
ATOM   5820  OD2 ASP   380      35.721  11.634 -27.490  1.00 27.68           O
ATOM   5821  C   ASP   380      35.330  15.568 -25.950  1.00 30.49           C
ATOM   5822  O   ASP   380      35.692  16.290 -26.850  1.00 29.96           O
ATOM   5824  N   PRO   381      35.914  15.574 -24.725  1.00 32.95           N
ATOM   5825  CA  PRO   381      37.005  16.521 -24.397  1.00 35.81           C
ATOM   5827  CB  PRO   381      37.230  16.303 -22.886  1.00 35.62           C
ATOM   5830  CG  PRO   381      36.716  14.939 -22.605  1.00 33.49           C
ATOM   5833  CD  PRO   381      35.586  14.697 -23.581  1.00 33.25           C
ATOM   5836  C   PRO   381      38.332  16.328 -25.191  1.00 34.09           C
ATOM   5837  O   PRO   381      39.127  17.225 -25.249  1.00 35.95           O
ATOM   5838  N   GLU   382      38.517  15.170 -25.782  1.00 33.78           N
ATOM   5839  CA  GLU   382      39.648  14.878 -26.655  1.00 36.98           C
ATOM   5841  CB  GLU   382      39.685  13.368 -26.923  1.00 39.39           C
ATOM   5844  CG  GLU   382      40.379  12.945 -28.205  1.00 43.57           C
ATOM   5847  CD  GLU   382      40.432  11.436 -28.350  1.00 42.94           C
ATOM   5850  C   GLU   382      39.587  15.631 -27.977  1.00 34.08           C
ATOM   5851  O   GLU   382      40.627  15.988 -28.551  1.00 31.41           O
ATOM   5853  N   ILE   383      38.364  15.843 -28.472  1.00 30.30           N
ATOM   5854  CA  ILE   383      38.118  16.527 -29.716  1.00 25.53           C
ATOM   5856  CB  ILE   383      36.951  15.874 -30.462  1.00 25.10           C
ATOM   5858  CG1 ILE   383      37.205  14.369 -30.660  1.00 27.76           C
ATOM   5861  CD1 ILE   383      36.011  13.652 -31.278  1.00 26.78           C
ATOM   5865  CG2 ILE   383      36.703  16.547 -31.810  1.00 23.51           C
ATOM   5869  C   ILE   383      37.810  17.991 -29.453  1.00 24.96           C
ATOM   5870  O   ILE   383      38.190  18.862 -30.226  1.00 25.84           O
ATOM   5872  N   TYR   384      37.139  18.254 -28.345  1.00 27.40           N
ATOM   5873  CA  TYR   384      36.696  19.585 -27.978  1.00 28.04           C
ATOM   5875  CB  TYR   384      35.166  19.657 -28.145  1.00 28.00           C
ATOM   5878  CG  TYR   384      34.675  19.602 -29.587  1.00 24.69           C
ATOM   5879  CD1 TYR   384      34.942  20.649 -30.476  1.00 27.06           C
ATOM   5881  CE1 TYR   384      34.481  20.622 -31.788  1.00 27.21           C
ATOM   5883  CZ  TYR   384      33.746  19.538 -32.236  1.00 26.85           C
ATOM   5884  OH  TYR   384      33.268  19.502 -33.556  1.00 24.59           O
ATOM   5886  CE2 TYR   384      33.474  18.477 -31.361  1.00 25.81           C
ATOM   5888  CD2 TYR   384      33.926  18.528 -30.048  1.00 25.44           C
ATOM   5890  C   TYR   384      37.074  19.917 -26.512  1.00 31.02           C
ATOM   5891  O   TYR   384      36.265  19.714 -25.612  1.00 29.81           O
ATOM   5893  N   PRO   385      38.319  20.418 -26.267  1.00 34.18           N
ATOM   5894  CA  PRO   385      38.738  20.759 -24.892  1.00 37.04           C
ATOM   5896  CB  PRO   385      40.085  21.453 -25.103  1.00 37.40           C
ATOM   5899  CG  PRO   385      40.620  20.807 -26.344  1.00 34.04           C
ATOM   5902  CD  PRO   385      39.413  20.643 -27.229  1.00 34.19           C
ATOM   5905  C   PRO   385      37.757  21.685 -24.152  1.00 39.56           C
ATOM   5906  O   PRO   385      37.292  22.660 -24.725  1.00 42.68           O
ATOM   5907  N   ASP   386      37.484  21.369 -22.879  1.00 38.00           N
ATOM   5908  CA  ASP   386      36.474  22.089 -22.091  0.50 35.60           C
ATOM   5912  CB  ASP   386      36.866  23.580 -21.884  0.50 35.60           C
ATOM   5918  CG  ASP   386      38.328  23.769 -21.437  0.50 35.16           C
ATOM   5920  OD1 ASP   386      38.664  23.387 -20.298  0.50 36.33           O
ATOM   5922  OD2 ASP   386      39.134  24.326 -22.217  0.50 35.32           O
ATOM   5924  C   ASP   386      35.098  21.958 -22.808  1.00 34.65           C
ATOM   5925  O   ASP   386      34.453  22.966 -23.126  1.00 31.91           O
ATOM   5927  N   PRO   387      34.648  20.705 -23.072  1.00 33.61           N
ATOM   5928  CA  PRO   387      33.473  20.450 -23.930  1.00 33.01           C
ATOM   5930  CB  PRO   387      33.344  18.929 -23.903  1.00 31.84           C
ATOM   5933  CG  PRO   387      34.083  18.529 -22.655  1.00 33.10           C
ATOM   5936  CD  PRO   387      35.211  19.443 -22.559  1.00 32.21           C
ATOM   5939  C   PRO   387      32.168  21.085 -23.458  1.00 32.84           C
ATOM   5940  O   PRO   387      31.307  21.305 -24.272  1.00 29.71           O
ATOM   5941  N   LEU   388      32.042  21.379 -22.159  1.00 31.54           N
ATOM   5942  CA  LEU   388      30.816  21.945 -21.601  1.00 32.95           C
ATOM   5944  CB  LEU   388      30.535  21.379 -20.190  1.00 34.51           C
ATOM   5947  CG  LEU   388      30.501  19.845 -20.070  1.00 35.82           C
ATOM   5949  CD1 LEU   388      30.040  19.447 -18.641  1.00 38.44           C
ATOM   5953  CD2 LEU   388      29.608  19.243 -21.118  1.00 33.51           C
ATOM   5957  C   LEU   388      30.838  23.434 -21.530  1.00 32.53           C
ATOM   5958  O   LEU   388      29.909  24.036 -21.001  1.00 34.56           O
ATOM   5960  N   THR   389      31.897  24.049 -22.039  1.00 32.80           N
ATOM   5961  CA  THR   389      31.997  25.496 -22.038  1.00 30.09           C
ATOM   5963  CB  THR   389      33.420  25.983 -21.647  1.00 30.10           C
ATOM   5965  OG1 THR   389      33.722  25.479 -20.357  1.00 32.71           O
ATOM   5967  CG2 THR   389      33.493  27.542 -21.622  1.00 25.18           C
ATOM   5971  C   THR   389      31.662  25.977 -23.410  1.00 28.07           C
ATOM   5972  O   THR   389      32.186  25.433 -24.416  1.00 30.42           O
ATOM   5974  N   PHE   390      30.785  26.993 -23.468  1.00 29.45           N
ATOM   5975  CA  PHE   390      30.464  27.654 -24.728  1.00 29.16           C
ATOM   5977  CB  PHE   390      29.150  28.434 -24.644  1.00 31.66           C
ATOM   5980  CG  PHE   390      28.815  29.211 -25.918  1.00 30.25           C
ATOM   5981  CD1 PHE   390      28.201  28.597 -26.968  1.00 31.01           C
ATOM   5983  CE1 PHE   390      27.895  29.308 -28.149  1.00 30.48           C
ATOM   5985  CZ  PHE   390      28.191  30.638 -28.252  1.00 32.56           C
ATOM   5987  CE2 PHE   390      28.807  31.294 -27.191  1.00 31.36           C
ATOM   5989  CD2 PHE   390      29.116  30.580 -26.029  1.00 31.96           C
ATOM   5991  C   PHE   390      31.588  28.573 -25.100  1.00 31.07           C
ATOM   5992  O   PHE   390      31.787  29.642 -24.471  1.00 25.46           O
ATOM   5994  N   LYS   391      32.339  28.154 -26.116  1.00 31.72           N
ATOM   5995  CA  LYS   391      33.407  28.982 -26.713  1.00 31.14           C
ATOM   5997  CB  LYS   391      34.700  28.158 -26.839  1.00 28.58           C
ATOM   6000  CG  LYS   391      35.265  27.717 -25.509  1.00 31.55           C
ATOM   6003  CD  LYS   391      36.623  27.055 -25.674  1.00 31.28           C
ATOM   6006  CE  LYS   391      37.050  26.309 -24.435  1.00 31.92           C
ATOM   6009  NZ  LYS   391      38.361  25.490 -24.676  1.00 31.64           N
ATOM   6013  C   LYS   391      32.953  29.539 -28.073  1.00 28.67           C
ATOM   6014  O   LYS   391      32.946  28.827 -29.059  1.00 29.63           O
ATOM   6016  N   TYR   392      32.576  30.826 -28.100  1.00 29.36           N
ATOM   6017  CA  TYR   392      31.928  31.437 -29.270  1.00 32.13           C
ATOM   6019  CB  TYR   392      31.513  32.907 -28.974  1.00 36.92           C
ATOM   6022  CG  TYR   392      32.585  33.899 -29.327  1.00 37.03           C
ATOM   6023  CD1 TYR   392      33.513  34.342 -28.367  1.00 36.29           C
ATOM   6025  CE1 TYR   392      34.519  35.231 -28.707  1.00 36.94           C
ATOM   6027  CZ  TYR   392      34.606  35.678 -30.011  1.00 38.75           C
ATOM   6028  OH  TYR   392      35.581  36.552 -30.397  1.00 39.56           O
ATOM   6030  CE2 TYR   392      33.696  35.247 -30.971  1.00 40.54           C
ATOM   6032  CD2 TYR   392      32.703  34.367 -30.623  1.00 37.05           C
ATOM   6034  C   TYR   392      32.803  31.365 -30.519  1.00 34.59           C
ATOM   6035  O   TYR   392      32.301  31.341 -31.655  1.00 33.79           O
ATOM   6037  N   ASP   393      34.118  31.319 -30.306  1.00 34.35           N
ATOM   6038  CA  ASP   393      35.080  31.227 -31.403  1.00 31.36           C
ATOM   6040  CB  ASP   393      36.271  32.198 -31.184  1.00 31.25           C
ATOM   6043  CG  ASP   393      37.000  31.991 -29.825  1.00 34.12           C
ATOM   6044  OD1 ASP   393      36.637  31.107 -29.049  1.00 31.59           O
ATOM   6045  OD2 ASP   393      37.956  32.752 -29.542  1.00 42.19           O
ATOM   6046  C   ASP   393      35.590  29.812 -31.629  1.00 31.00           C
ATOM   6047  O   ASP   393      36.634  29.629 -32.244  1.00 29.59           O
ATOM   6049  N   ARG   394      34.860  28.802 -31.172  1.00 31.13           N
ATOM   6050  CA  ARG   394      35.369  27.443 -31.274  1.00 28.92           C
ATOM   6052  CB  ARG   394      34.506  26.466 -30.490  1.00 31.16           C
ATOM   6055  CG  ARG   394      35.225  25.149 -30.273  1.00 31.45           C
ATOM   6058  CD  ARG   394      34.422  24.152 -29.581  1.00 30.26           C
ATOM   6061  NE  ARG   394      34.176  24.462 -28.171  1.00 31.36           N
ATOM   6063  CZ  ARG   394      34.869  23.972 -27.141  1.00 29.18           C
ATOM   6064  NH1 ARG   394      35.908  23.176 -27.318  1.00 29.75           N
ATOM   6067  NH2 ARG   394      34.501  24.282 -25.928  1.00 29.44           N
ATOM   6070  C   ARG   394      35.503  27.001 -32.730  1.00 27.55           C
ATOM   6071  O   ARG   394      36.388  26.219 -33.081  1.00 28.73           O
ATOM   6073  N   TYR   395      34.649  27.524 -33.598  1.00 28.32           N
ATOM   6074  CA  TYR   395      34.718  27.118 -34.992  1.00 27.61           C
ATOM   6076  CB  TYR   395      33.358  26.640 -35.473  1.00 25.97           C
ATOM   6079  CG  TYR   395      32.933  25.359 -34.844  1.00 23.69           C
ATOM   6080  CD1 TYR   395      32.152  25.340 -33.680  1.00 24.18           C
ATOM   6082  CE1 TYR   395      31.734  24.145 -33.125  1.00 21.91           C
ATOM   6084  CZ  TYR   395      32.143  22.946 -33.744  1.00 25.07           C
ATOM   6085  OH  TYR   395      31.789  21.722 -33.274  1.00 22.79           O
ATOM   6087  CE2 TYR   395      32.897  22.962 -34.869  1.00 22.04           C
ATOM   6089  CD2 TYR   395      33.293  24.147 -35.413  1.00 25.89           C
ATOM   6091  C   TYR   395      35.278  28.230 -35.853  1.00 29.51           C
ATOM   6092  O   TYR   395      34.949  28.324 -37.027  1.00 26.67           O
ATOM   6094  N   LEU   396      36.149  29.059 -35.243  1.00 31.08           N
ATOM   6095  CA  LEU   396      36.924  30.072 -35.956  1.00 34.42           C
ATOM   6097  CB  LEU   396      36.723  31.460 -35.346  1.00 35.50           C
ATOM   6100  CG  LEU   396      35.367  32.134 -35.494  1.00 32.70           C
ATOM   6102  CD1 LEU   396      35.401  33.498 -34.849  1.00 31.61           C
ATOM   6106  CD2 LEU   396      35.038  32.244 -36.947  1.00 32.91           C
ATOM   6110  C   LEU   396      38.408  29.715 -35.892  1.00 33.61           C
ATOM   6111  O   LEU   396      38.907  29.240 -34.866  1.00 33.95           O
ATOM   6113  N   ASP   397      39.106  29.907 -36.993  1.00 36.59           N
ATOM   6114  CA  ASP   397      40.567  29.682 -37.031  1.00 38.81           C
ATOM   6116  CB  ASP   397      40.989  29.041 -38.358  1.00 37.92           C
ATOM   6119  CG  ASP   397      40.822  29.975 -39.572  1.00 37.87           C
ATOM   6120  OD1 ASP   397      40.558  31.204 -39.415  1.00 30.77           O
ATOM   6121  OD2 ASP   397      40.955  29.442 -40.704  1.00 37.72           O
ATOM   6122  C   ASP   397      41.326  30.985 -36.751  1.00 39.51           C
ATOM   6123  O   ASP   397      40.709  32.005 -36.453  1.00 39.20           O
ATOM   6125  N   GLU   398      42.664  30.940 -36.821  1.00 46.16           N
ATOM   6126  CA  GLU   398      43.516  32.136 -36.549  1.00 48.68           C
ATOM   6128  CB  GLU   398      45.005  31.793 -36.755  1.00 50.31           C
ATOM   6135  C   GLU   398      43.113  33.349 -37.426  1.00 49.60           C
ATOM   6136  O   GLU   398      43.145  34.527 -36.970  1.00 48.95           O
ATOM   6138  N   ASN   399      42.694  33.051 -38.663  1.00 46.34           N
ATOM   6139  CA  ASN   399      42.267  34.082 -39.625  1.00 44.40           C
ATOM   6141  CB  ASN   399      42.415  33.539 -41.037  1.00 45.52           C
ATOM   6144  CG  ASN   399      43.842  33.199 -41.352  1.00 47.45           C
ATOM   6145  OD1 ASN   399      44.736  33.978 -41.035  1.00 47.23           O
ATOM   6146  ND2 ASN   399      44.078  32.016 -41.929  1.00 48.46           N
ATOM   6149  C   ASN   399      40.865  34.633 -39.423  1.00 43.64           C
ATOM   6150  O   ASN   399      40.448  35.549 -40.146  1.00 40.47           O
ATOM   6152  N   GLY   400      40.137  34.099 -38.437  1.00 40.45           N
ATOM   6153  CA  GLY   400      38.759  34.517 -38.209  1.00 40.13           C
ATOM   6156  C   GLY   400      37.829  33.923 -39.256  1.00 39.73           C
ATOM   6157  O   GLY   400      36.713  34.413 -39.439  1.00 44.62           O
ATOM   6159  N   LYS   401      38.297  32.871 -39.932  1.00 36.27           N
ATOM   6160  CA  LYS   401      37.519  32.122 -40.906  1.00 37.66           C
ATOM   6162  CB  LYS   401      38.397  31.660 -42.064  1.00 36.10           C
ATOM   6169  C   LYS   401      36.984  30.905 -40.211  1.00 41.42           C
ATOM   6170  O   LYS   401      37.384  30.607 -39.090  1.00 44.83           O
ATOM   6172  N   THR   402      36.104  30.180 -40.884  1.00 40.77           N
ATOM   6173  CA  THR   402      35.498  28.985 -40.322  1.00 40.38           C
ATOM   6175  CB  THR   402      34.241  28.515 -41.166  1.00 40.60           C
ATOM   6177  OG1 THR   402      33.164  29.454 -40.982  1.00 41.26           O
ATOM   6179  CG2 THR   402      33.780  27.123 -40.761  1.00 38.53           C
ATOM   6183  C   THR   402      36.555  27.886 -40.202  1.00 39.86           C
ATOM   6184  O   THR   402      37.219  27.543 -41.161  1.00 38.80           O
ATOM   6186  N   LYS   403      36.688  27.350 -38.987  1.00 40.38           N
ATOM   6187  CA  LYS   403      37.655  26.304 -38.672  1.00 33.21           C
ATOM   6189  CB  LYS   403      38.027  26.412 -37.201  1.00 33.27           C
ATOM   6192  CG  LYS   403      38.902  25.292 -36.691  1.00 33.50           C
ATOM   6195  CD  LYS   403      39.271  25.510 -35.246  1.00 31.09           C
ATOM   6198  CE  LYS   403      40.049  24.305 -34.767  1.00 32.67           C
ATOM   6201  NZ  LYS   403      40.750  24.648 -33.545  1.00 36.84           N
ATOM   6205  C   LYS   403      37.060  24.931 -38.976  1.00 33.91           C
ATOM   6206  O   LYS   403      35.907  24.658 -38.613  1.00 35.75           O
ATOM   6208  N   THR   404      37.862  24.081 -39.629  1.00 29.29           N
ATOM   6209  CA  THR   404      37.453  22.791 -40.132  1.00 31.02           C
ATOM   6211  CB  THR   404      37.364  22.805 -41.687  1.00 32.75           C
ATOM   6213  OG1 THR   404      38.629  23.189 -42.219  1.00 33.86           O
ATOM   6215  CG2 THR   404      36.300  23.794 -42.206  1.00 29.20           C
ATOM   6219  C   THR   404      38.427  21.644 -39.711  1.00 33.44           C
ATOM   6220  O   THR   404      38.311  20.485 -40.198  1.00 31.33           O
ATOM   6222  N   THR   405      39.368  21.946 -38.814  1.00 31.87           N
ATOM   6223  CA  THR   405      40.362  20.960 -38.400  1.00 32.21           C
ATOM   6225  CB  THR   405      41.799  21.451 -38.653  1.00 32.83           C
ATOM   6227  OG1 THR   405      41.971  22.718 -38.033  1.00 32.81           O
ATOM   6229  CG2 THR   405      42.055  21.597 -40.140  1.00 33.45           C
ATOM   6233  C   THR   405      40.181  20.612 -36.936  1.00 30.79           C
ATOM   6234  O   THR   405      40.392  21.460 -36.037  1.00 29.30           O
ATOM   6236  N   PHE   406      39.799  19.348 -36.715  1.00 27.19           N
ATOM   6237  CA  PHE   406      39.526  18.809 -35.419  1.00 23.00           C
ATOM   6239  CB  PHE   406      38.013  18.867 -35.121  1.00 25.34           C
ATOM   6242  CG  PHE   406      37.489  20.271 -34.984  1.00 23.32           C
ATOM   6243  CD1 PHE   406      37.582  20.941 -33.782  1.00 25.26           C
ATOM   6245  CE1 PHE   406      37.127  22.248 -33.640  1.00 23.48           C
ATOM   6247  CZ  PHE   406      36.571  22.904 -34.715  1.00 23.75           C
ATOM   6249  CE2 PHE   406      36.475  22.261 -35.930  1.00 24.33           C
ATOM   6251  CD2 PHE   406      36.944  20.935 -36.071  1.00 25.75           C
ATOM   6253  C   PHE   406      40.023  17.386 -35.456  1.00 28.24           C
ATOM   6254  O   PHE   406      39.942  16.732 -36.508  1.00 26.82           O
ATOM   6256  N   TYR   407      40.541  16.908 -34.310  1.00 31.66           N
ATOM   6257  CA  TYR   407      41.294  15.643 -34.247  1.00 32.21           C
ATOM   6259  CB  TYR   407      42.807  15.889 -34.035  1.00 31.75           C
ATOM   6262  CG  TYR   407      43.422  16.866 -35.003  1.00 30.51           C
ATOM   6263  CD1 TYR   407      44.078  16.426 -36.139  1.00 30.14           C
ATOM   6265  CE1 TYR   407      44.660  17.346 -37.044  1.00 32.18           C
ATOM   6267  CZ  TYR   407      44.589  18.702 -36.765  1.00 30.35           C
ATOM   6268  OH  TYR   407      45.129  19.619 -37.632  1.00 34.13           O
ATOM   6270  CE2 TYR   407      43.968  19.141 -35.628  1.00 31.79           C
ATOM   6272  CD2 TYR   407      43.389  18.224 -34.749  1.00 29.72           C
ATOM   6274  C   TYR   407      40.824  14.756 -33.138  1.00 30.86           C
ATOM   6275  O   TYR   407      40.352  15.222 -32.118  1.00 29.95           O
ATOM   6277  N   CYS   408      40.969  13.460 -33.370  1.00 32.32           N
ATOM   6278  CA  CYS   408      40.752  12.449 -32.375  1.00 36.34           C
ATOM   6280  CB  CYS   408      39.450  11.706 -32.668  1.00 37.17           C
ATOM   6283  SG  CYS   408      38.993  10.610 -31.362  1.00 39.68           S
ATOM   6285  C   CYS   408      41.928  11.450 -32.381  1.00 35.07           C
ATOM   6286  O   CYS   408      42.190  10.787 -33.396  1.00 32.21           O
ATOM   6288  N   ASN   409      42.622  11.349 -31.255  1.00 39.69           N
ATOM   6289  CA  ASN   409      43.844  10.504 -31.141  1.00 41.92           C
ATOM   6291  CB  ASN   409      43.487   9.005 -31.155  1.00 41.81           C
ATOM   6294  CG  ASN   409      42.484   8.627 -30.043  1.00 47.05           C
ATOM   6295  OD1 ASN   409      42.432   9.272 -28.974  1.00 45.75           O
ATOM   6296  ND2 ASN   409      41.672   7.601 -30.302  1.00 47.04           N
ATOM   6299  C   ASN   409      44.848  10.878 -32.251  1.00 39.86           C
ATOM   6300  O   ASN   409      45.370  10.017 -32.966  1.00 41.45           O
ATOM   6302  N   GLY   410      45.044  12.180 -32.410  1.00 38.11           N
ATOM   6303  CA  GLY   410      45.903  12.735 -33.451  1.00 42.53           C
ATOM   6306  C   GLY   410      45.380  12.691 -34.886  1.00 43.93           C
ATOM   6307  O   GLY   410      45.940  13.368 -35.745  1.00 46.13           O
ATOM   6309  N   LEU   411      44.310  11.928 -35.151  1.00 41.82           N
ATOM   6310  CA  LEU   411      43.795  11.759 -36.510  1.00 42.21           C
ATOM   6312  CB  LEU   411      43.116  10.388 -36.673  1.00 46.85           C
ATOM   6315  CG  LEU   411      44.054   9.177 -36.849  1.00 48.53           C
ATOM   6317  CD1 LEU   411      43.512   7.854 -36.239  1.00 48.49           C
ATOM   6321  CD2 LEU   411      44.331   9.007 -38.348  1.00 51.98           C
ATOM   6325  C   LEU   411      42.824  12.868 -36.837  1.00 40.97           C
ATOM   6326  O   LEU   411      41.994  13.243 -36.016  1.00 39.86           O
ATOM   6328  N   LYS   412      42.929  13.405 -38.043  1.00 39.29           N
ATOM   6329  CA  LYS   412      42.062  14.487 -38.459  1.00 37.96           C
ATOM   6331  CB  LYS   412      42.611  15.175 -39.691  1.00 38.57           C
ATOM   6334  CG  LYS   412      41.937  16.456 -40.037  1.00 40.85           C
ATOM   6337  CD  LYS   412      42.358  16.903 -41.447  1.00 43.30           C
ATOM   6340  CE  LYS   412      41.964  18.340 -41.732  1.00 44.31           C
ATOM   6343  NZ  LYS   412      41.925  18.624 -43.178  1.00 44.08           N
ATOM   6347  C   LYS   412      40.701  13.880 -38.760  1.00 39.37           C
ATOM   6348  O   LYS   412      40.600  12.876 -39.514  1.00 36.94           O
ATOM   6350  N   LEU   413      39.664  14.474 -38.169  1.00 35.90           N
ATOM   6351  CA  LEU   413      38.283  13.957 -38.303  1.00 34.32           C
ATOM   6353  CB  LEU   413      37.467  14.349 -37.091  1.00 32.51           C
ATOM   6356  CG  LEU   413      37.789  13.713 -35.740  1.00 30.87           C
ATOM   6358  CD1 LEU   413      37.019  14.442 -34.689  1.00 28.59           C
ATOM   6362  CD2 LEU   413      37.430  12.268 -35.730  1.00 32.22           C
ATOM   6366  C   LEU   413      37.587  14.491 -39.555  1.00 35.38           C
ATOM   6367  O   LEU   413      37.623  15.713 -39.828  1.00 36.23           O
ATOM   6369  N   LYS   414      36.966  13.585 -40.311  1.00 37.14           N
ATOM   6370  CA  LYS   414      36.054  13.958 -41.416  1.00 40.82           C
ATOM   6372  CB  LYS   414      35.959  12.787 -42.445  1.00 43.72           C
ATOM   6375  CG  LYS   414      34.651  12.653 -43.294  1.00 45.31           C
ATOM   6378  CD  LYS   414      34.657  13.431 -44.624  1.00 48.83           C
ATOM   6381  CE  LYS   414      33.415  13.038 -45.531  1.00 49.58           C
ATOM   6384  NZ  LYS   414      33.009  14.118 -46.553  1.00 49.28           N
ATOM   6388  C   LYS   414      34.682  14.363 -40.814  1.00 38.16           C
ATOM   6389  O   LYS   414      34.068  15.355 -41.219  1.00 37.92           O
ATOM   6391  N   TYR   415      34.245  13.603 -39.813  1.00 37.60           N
ATOM   6392  CA  TYR   415      32.998  13.870 -39.092  1.00 36.28           C
ATOM   6394  CB  TYR   415      32.182  12.592 -39.042  1.00 39.84           C
ATOM   6397  CG  TYR   415      31.954  12.037 -40.403  1.00 40.59           C
ATOM   6398  CD1 TYR   415      32.598  10.878 -40.819  1.00 42.23           C
ATOM   6400  CE1 TYR   415      32.403  10.369 -42.096  1.00 42.20           C
ATOM   6402  CZ  TYR   415      31.569  11.026 -42.973  1.00 41.78           C
ATOM   6403  OH  TYR   415      31.378  10.513 -44.237  1.00 41.90           O
ATOM   6405  CE2 TYR   415      30.925  12.200 -42.585  1.00 41.74           C
ATOM   6407  CD2 TYR   415      31.124  12.700 -41.312  1.00 39.76           C
ATOM   6409  C   TYR   415      33.243  14.362 -37.672  1.00 32.67           C
ATOM   6410  O   TYR   415      33.642  13.603 -36.819  1.00 33.13           O
ATOM   6412  N   TYR   416      32.987  15.631 -37.427  1.00 27.26           N
ATOM   6413  CA  TYR   416      33.225  16.209 -36.105  1.00 28.40           C
ATOM   6415  CB  TYR   416      34.577  16.951 -36.125  1.00 28.31           C
ATOM   6418  CG  TYR   416      34.631  17.982 -37.192  1.00 29.08           C
ATOM   6419  CD1 TYR   416      35.138  17.686 -38.442  1.00 28.86           C
ATOM   6421  CE1 TYR   416      35.171  18.672 -39.449  1.00 30.23           C
ATOM   6423  CZ  TYR   416      34.693  19.927 -39.183  1.00 28.17           C
ATOM   6424  OH  TYR   416      34.713  20.890 -40.145  1.00 32.35           O
ATOM   6426  CE2 TYR   416      34.184  20.244 -37.954  1.00 29.29           C
ATOM   6428  CD2 TYR   416      34.153  19.287 -36.960  1.00 30.23           C
ATOM   6430  C   TYR   416      32.107  17.154 -35.645  1.00 23.85           C
ATOM   6431  O   TYR   416      32.037  17.519 -34.464  1.00 26.65           O
ATOM   6433  N   TYR   417      31.256  17.554 -36.577  1.00 27.38           N
ATOM   6434  CA  TYR   417      30.110  18.429 -36.311  1.00 28.58           C
ATOM   6436  CB  TYR   417      30.450  19.868 -36.716  1.00 26.41           C
ATOM   6439  CG  TYR   417      29.312  20.841 -36.634  1.00 26.59           C
ATOM   6440  CD1 TYR   417      28.982  21.450 -35.429  1.00 25.89           C
ATOM   6442  CE1 TYR   417      27.920  22.360 -35.339  1.00 27.33           C
ATOM   6444  CZ  TYR   417      27.165  22.656 -36.475  1.00 28.09           C
ATOM   6445  OH  TYR   417      26.125  23.572 -36.395  1.00 26.97           O
ATOM   6447  CE2 TYR   417      27.486  22.071 -37.688  1.00 26.49           C
ATOM   6449  CD2 TYR   417      28.574  21.170 -37.762  1.00 25.28           C
ATOM   6451  C   TYR   417      28.927  17.889 -37.117  1.00 27.68           C
ATOM   6452  O   TYR   417      28.872  18.047 -38.345  1.00 27.35           O
ATOM   6454  N   MET   418      27.980  17.268 -36.425  1.00 26.25           N
ATOM   6455  CA  MET   418      26.912  16.518 -37.064  1.00 27.73           C
ATOM   6457  CB  MET   418      27.093  15.044 -36.719  1.00 32.11           C
ATOM   6460  CG  MET   418      28.318  14.478 -37.144  1.00 32.32           C
ATOM   6463  SD  MET   418      28.265  12.730 -37.107  1.00 39.24           S
ATOM   6464  CE  MET   418      26.733  12.403 -38.003  1.00 30.55           C
ATOM   6468  C   MET   418      25.463  16.849 -36.646  1.00 25.47           C
ATOM   6469  O   MET   418      24.624  15.983 -36.712  1.00 26.47           O
ATOM   6471  N   PRO   419      25.159  18.091 -36.223  1.00 22.85           N
ATOM   6472  CA  PRO   419      23.771  18.324 -35.767  1.00 22.71           C
ATOM   6474  CB  PRO   419      23.810  19.752 -35.257  1.00 22.33           C
ATOM   6477  CG  PRO   419      24.980  20.360 -35.933  1.00 24.73           C
ATOM   6480  CD  PRO   419      25.980  19.291 -36.108  1.00 23.14           C
ATOM   6483  C   PRO   419      22.680  18.192 -36.826  1.00 23.06           C
ATOM   6484  O   PRO   419      21.513  18.108 -36.459  1.00 21.03           O
ATOM   6485  N   PHE   420      23.081  18.187 -38.112  1.00 24.60           N
ATOM   6486  CA  PHE   420      22.207  18.000 -39.293  1.00 25.21           C
ATOM   6488  CB  PHE   420      22.583  18.982 -40.368  1.00 24.20           C
ATOM   6491  CG  PHE   420      22.369  20.380 -39.968  1.00 24.65           C
ATOM   6492  CD1 PHE   420      23.415  21.157 -39.535  1.00 23.82           C
ATOM   6494  CE1 PHE   420      23.200  22.459 -39.155  1.00 26.04           C
ATOM   6496  CZ  PHE   420      21.931  22.976 -39.191  1.00 22.85           C
ATOM   6498  CE2 PHE   420      20.880  22.196 -39.597  1.00 22.56           C
ATOM   6500  CD2 PHE   420      21.088  20.915 -39.972  1.00 22.99           C
ATOM   6502  C   PHE   420      22.323  16.618 -39.884  1.00 26.51           C
ATOM   6503  O   PHE   420      21.739  16.339 -40.902  1.00 28.39           O
ATOM   6505  N   GLY   421      23.029  15.738 -39.203  1.00 30.28           N
ATOM   6506  CA  GLY   421      23.356  14.450 -39.758  1.00 33.71           C
ATOM   6509  C   GLY   421      24.491  14.579 -40.769  1.00 36.52           C
ATOM   6510  O   GLY   421      25.279  15.556 -40.753  1.00 33.85           O
ATOM   6512  N   SER   422      24.567  13.584 -41.640  1.00 42.89           N
ATOM   6513  CA  SER   422      25.608  13.491 -42.658  1.00 51.27           C
ATOM   6515  CB  SER   422      26.991  13.258 -42.027  1.00 53.60           C
ATOM   6518  OG  SER   422      27.586  14.495 -41.616  1.00 57.10           O
ATOM   6520  C   SER   422      25.267  12.350 -43.613  1.00 54.78           C
ATOM   6521  O   SER   422      24.451  11.473 -43.283  1.00 54.16           O
ATOM   6523  N   GLY   423      25.873  12.388 -44.802  1.00 57.72           N
ATOM   6524  CA  GLY   423      25.673  11.356 -45.792  1.00 58.83           C
ATOM   6527  C   GLY   423      24.376  11.520 -46.545  1.00 60.49           C
ATOM   6528  O   GLY   423      24.083  12.597 -47.066  1.00 62.36           O
ATOM   6530  N   ALA   424      23.620  10.429 -46.638  1.00 62.44           N
ATOM   6531  CA  ALA   424      22.304  10.431 -47.277  1.00 62.79           C
ATOM   6533  CB  ALA   424      22.034   9.072 -47.936  1.00 63.38           C
ATOM   6537  C   ALA   424      21.238  10.742 -46.237  1.00 62.69           C
ATOM   6538  O   ALA   424      20.162  11.249 -46.565  1.00 61.17           O
ATOM   6540  N   THR   425      21.545  10.406 -44.980  1.00 62.07           N
ATOM   6541  CA  THR   425      20.729  10.801 -43.847  1.00 60.50           C
ATOM   6543  CB  THR   425      20.857   9.789 -42.663  1.00 61.43           C
ATOM   6547  C   THR   425      21.197  12.200 -43.407  1.00 56.92           C
ATOM   6548  O   THR   425      21.898  12.341 -42.355  1.00 57.95           O
ATOM   6550  N   ILE   426      20.842  13.227 -44.204  1.00 45.77           N
ATOM   6551  CA  ILE   426      21.242  14.601 -43.874  1.00 41.19           C
ATOM   6553  CB  ILE   426      22.526  15.056 -44.600  1.00 39.48           C
ATOM   6555  CG1 ILE   426      23.097  16.295 -43.886  1.00 38.18           C
ATOM   6558  CD1 ILE   426      24.384  16.824 -44.452  1.00 40.03           C
ATOM   6562  CG2 ILE   426      22.259  15.319 -46.122  1.00 37.64           C
ATOM   6566  C   ILE   426      20.112  15.596 -44.129  1.00 37.35           C
ATOM   6567  O   ILE   426      19.410  15.516 -45.151  1.00 36.58           O
ATOM   6569  N   CYS   427      19.953  16.535 -43.198  1.00 25.89           N
ATOM   6570  CA  CYS   427      18.900  17.505 -43.292  1.00 24.11           C
ATOM   6572  CB  CYS   427      19.075  18.536 -42.215  1.00 25.50           C
ATOM   6575  SG  CYS   427      17.846  19.757 -42.278  1.00 23.59           S
ATOM   6577  C   CYS   427      18.949  18.170 -44.638  1.00 22.44           C
ATOM   6578  O   CYS   427      19.918  18.763 -44.954  1.00 24.73           O
ATOM   6580  N   PRO   428      17.884  18.058 -45.457  1.00 24.77           N
ATOM   6581  CA  PRO   428      17.893  18.844 -46.694  1.00 22.85           C
ATOM   6583  CB  PRO   428      16.710  18.268 -47.465  1.00 24.14           C
ATOM   6586  CG  PRO   428      15.787  17.764 -46.423  1.00 23.24           C
ATOM   6589  CD  PRO   428      16.652  17.243 -45.331  1.00 22.36           C
ATOM   6592  C   PRO   428      17.711  20.353 -46.476  1.00 21.18           C
ATOM   6593  O   PRO   428      18.044  21.140 -47.361  1.00 21.11           O
ATOM   6594  N   GLY   429      17.179  20.754 -45.314  1.00 20.54           N
ATOM   6595  CA  GLY   429      16.955  22.181 -45.018  1.00 19.06           C
ATOM   6598  C   GLY   429      18.109  22.922 -44.341  1.00 21.22           C
ATOM   6599  O   GLY   429      17.944  24.067 -43.893  1.00 21.70           O
ATOM   6601  N   ARG   430      19.274  22.296 -44.270  1.00 25.48           N
ATOM   6602  CA  ARG   430      20.344  22.798 -43.390  1.00 29.17           C
ATOM   6604  CB  ARG   430      21.501  21.816 -43.278  1.00 32.60           C
ATOM   6607  CG  ARG   430      22.174  21.501 -44.524  1.00 36.19           C
ATOM   6610  CD  ARG   430      22.990  20.196 -44.376  1.00 40.36           C
ATOM   6613  NE  ARG   430      23.774  19.934 -45.586  1.00 39.88           N
ATOM   6615  CZ  ARG   430      23.254  19.510 -46.726  1.00 41.79           C
ATOM   6616  NH1 ARG   430      24.053  19.318 -47.771  1.00 40.29           N
ATOM   6619  NH2 ARG   430      21.926  19.282 -46.835  1.00 38.64           N
ATOM   6622  C   ARG   430      20.857  24.173 -43.715  1.00 26.35           C
ATOM   6623  O   ARG   430      21.044  24.959 -42.817  1.00 25.59           O
ATOM   6625  N   LEU   431      21.014  24.483 -44.993  1.00 25.50           N
ATOM   6626  CA  LEU   431      21.450  25.807 -45.422  1.00 27.41           C
ATOM   6628  CB  LEU   431      21.766  25.812 -46.939  1.00 33.21           C
ATOM   6631  CG  LEU   431      22.736  24.741 -47.444  1.00 39.44           C
ATOM   6633  CD1 LEU   431      22.972  24.821 -48.995  1.00 40.84           C
ATOM   6637  CD2 LEU   431      24.055  24.866 -46.686  1.00 41.26           C
ATOM   6641  C   LEU   431      20.397  26.815 -45.123  1.00 24.52           C
ATOM   6642  O   LEU   431      20.677  27.915 -44.667  1.00 22.13           O
ATOM   6644  N   PHE   432      19.144  26.446 -45.366  1.00 25.12           N
ATOM   6645  CA  PHE   432      18.043  27.344 -45.045  1.00 25.62           C
ATOM   6647  CB  PHE   432      16.710  26.809 -45.605  1.00 26.14           C
ATOM   6650  CG  PHE   432      15.536  27.590 -45.155  1.00 24.04           C
ATOM   6651  CD1 PHE   432      15.431  28.915 -45.479  1.00 25.14           C
ATOM   6653  CE1 PHE   432      14.393  29.653 -45.074  1.00 25.82           C
ATOM   6655  CZ  PHE   432      13.390  29.086 -44.312  1.00 26.57           C
ATOM   6657  CE2 PHE   432      13.477  27.778 -43.959  1.00 24.41           C
ATOM   6659  CD2 PHE   432      14.559  27.023 -44.383  1.00 26.51           C
ATOM   6661  C   PHE   432      17.947  27.597 -43.520  1.00 21.31           C
ATOM   6662  O   PHE   432      17.760  28.725 -43.095  1.00 23.11           O
ATOM   6664  N   ALA   433      18.077  26.538 -42.725  1.00 22.24           N
ATOM   6665  CA  ALA   433      18.044  26.631 -41.236  1.00 26.25           C
ATOM   6667  CB  ALA   433      18.278  25.220 -40.599  1.00 21.52           C
ATOM   6671  C   ALA   433      19.095  27.656 -40.706  1.00 24.91           C
ATOM   6672  O   ALA   433      18.780  28.536 -39.904  1.00 23.77           O
ATOM   6674  N   ILE   434      20.327  27.529 -41.193  1.00 25.76           N
ATOM   6675  CA  ILE   434      21.416  28.485 -40.856  1.00 28.96           C
ATOM   6677  CB  ILE   434      22.769  28.060 -41.470  1.00 30.52           C
ATOM   6679  CG1 ILE   434      23.171  26.663 -40.971  1.00 28.24           C
ATOM   6682  CD1 ILE   434      23.262  26.585 -39.444  1.00 33.19           C
ATOM   6686  CG2 ILE   434      23.854  29.067 -41.114  1.00 26.94           C
ATOM   6690  C   ILE   434      21.103  29.896 -41.289  1.00 27.19           C
ATOM   6691  O   ILE   434      21.302  30.852 -40.523  1.00 25.84           O
ATOM   6693  N   HIS   435      20.564  30.035 -42.495  1.00 27.59           N
ATOM   6694  CA  HIS   435      20.154  31.355 -42.973  1.00 27.10           C
ATOM   6696  CB  HIS   435      19.591  31.310 -44.404  1.00 28.30           C
ATOM   6699  CG  HIS   435      20.639  31.141 -45.447  1.00 30.96           C
ATOM   6700  ND1 HIS   435      20.347  30.781 -46.745  1.00 31.91           N
ATOM   6702  CE1 HIS   435      21.475  30.694 -47.430  1.00 31.52           C
ATOM   6704  NE2 HIS   435      22.485  30.964 -46.618  1.00 30.45           N
ATOM   6706  CD2 HIS   435      21.991  31.244 -45.374  1.00 28.65           C
ATOM   6708  C   HIS   435      19.151  31.947 -42.084  1.00 26.73           C
ATOM   6709  O   HIS   435      19.276  33.112 -41.703  1.00 24.49           O
ATOM   6711  N   GLU   436      18.130  31.169 -41.716  1.00 27.50           N
ATOM   6712  CA  GLU   436      17.042  31.754 -40.929  1.00 27.76           C
ATOM   6714  CB  GLU   436      15.760  30.882 -40.960  1.00 31.62           C
ATOM   6717  CG  GLU   436      15.774  29.659 -40.121  1.00 34.03           C
ATOM   6720  CD  GLU   436      14.570  28.725 -40.367  1.00 31.16           C
ATOM   6721  OE1 GLU   436      13.436  29.197 -40.540  1.00 31.65           O
ATOM   6722  OE2 GLU   436      14.782  27.511 -40.348  1.00 30.48           O
ATOM   6723  C   GLU   436      17.485  32.121 -39.517  1.00 25.70           C
ATOM   6724  O   GLU   436      17.003  33.120 -38.948  1.00 27.81           O
ATOM   6726  N   ILE   437      18.409  31.350 -38.942  1.00 24.07           N
ATOM   6727  CA  ILE   437      18.914  31.676 -37.591  1.00 24.12           C
ATOM   6729  CB  ILE   437      19.682  30.510 -36.923  1.00 24.12           C
ATOM   6731  CG1 ILE   437      18.765  29.278 -36.799  1.00 24.01           C
ATOM   6734  CD1 ILE   437      19.374  28.118 -36.150  1.00 24.78           C
ATOM   6738  CG2 ILE   437      20.219  30.972 -35.545  1.00 21.96           C
ATOM   6742  C   ILE   437      19.819  32.934 -37.633  1.00 22.93           C
ATOM   6743  O   ILE   437      19.736  33.787 -36.768  1.00 21.72           O
ATOM   6745  N   LYS   438      20.666  33.016 -38.655  1.00 23.17           N
ATOM   6746  CA  LYS   438      21.481  34.197 -38.903  1.00 22.37           C
ATOM   6748  CB  LYS   438      22.346  34.006 -40.135  1.00 22.18           C
ATOM   6751  CG  LYS   438      23.537  33.084 -39.910  1.00 21.81           C
ATOM   6754  CD  LYS   438      24.337  32.973 -41.177  1.00 23.49           C
ATOM   6757  CE  LYS   438      25.609  32.191 -40.986  1.00 25.22           C
ATOM   6760  NZ  LYS   438      26.281  32.063 -42.313  1.00 28.75           N
ATOM   6764  C   LYS   438      20.614  35.413 -39.073  1.00 26.34           C
ATOM   6765  O   LYS   438      20.852  36.425 -38.441  1.00 26.48           O
ATOM   6767  N   GLN   439      19.575  35.300 -39.900  1.00 28.39           N
ATOM   6768  CA  GLN   439      18.644  36.415 -40.110  1.00 29.51           C
ATOM   6770  CB  GLN   439      17.544  36.033 -41.117  1.00 29.18           C
ATOM   6773  CG  GLN   439      18.082  35.872 -42.548  1.00 30.21           C
ATOM   6776  CD  GLN   439      17.067  35.243 -43.501  1.00 31.55           C
ATOM   6777  OE1 GLN   439      16.118  34.570 -43.064  1.00 36.01           O
ATOM   6778  NE2 GLN   439      17.250  35.464 -44.783  1.00 22.53           N
ATOM   6781  C   GLN   439      18.032  36.869 -38.812  1.00 29.19           C
ATOM   6782  O   GLN   439      17.991  38.082 -38.530  1.00 32.99           O
ATOM   6784  N   PHE   440      17.560  35.910 -38.000  1.00 27.43           N
ATOM   6785  CA  PHE   440      16.996  36.242 -36.670  1.00 25.81           C
ATOM   6787  CB  PHE   440      16.427  34.998 -35.978  1.00 24.89           C
ATOM   6790  CG  PHE   440      15.944  35.234 -34.588  1.00 23.77           C
ATOM   6791  CD1 PHE   440      14.659  35.706 -34.349  1.00 24.13           C
ATOM   6793  CE1 PHE   440      14.197  35.879 -33.028  1.00 21.97           C
ATOM   6795  CZ  PHE   440      15.037  35.582 -31.953  1.00 21.87           C
ATOM   6797  CE2 PHE   440      16.291  35.092 -32.183  1.00 24.39           C
ATOM   6799  CD2 PHE   440      16.752  34.914 -33.493  1.00 23.95           C
ATOM   6801  C   PHE   440      17.995  36.968 -35.757  1.00 26.96           C
ATOM   6802  O   PHE   440      17.635  37.997 -35.158  1.00 24.40           O
ATOM   6804  N   LEU   441      19.228  36.459 -35.673  1.00 24.96           N
ATOM   6805  CA  LEU   441      20.255  37.059 -34.821  1.00 27.03           C
ATOM   6807  CB  LEU   441      21.518  36.179 -34.777  1.00 27.80           C
ATOM   6810  CG  LEU   441      21.391  34.787 -34.144  1.00 26.16           C
ATOM   6812  CD1 LEU   441      22.672  34.034 -34.233  1.00 25.33           C
ATOM   6816  CD2 LEU   441      20.918  34.899 -32.682  1.00 22.93           C
ATOM   6820  C   LEU   441      20.622  38.470 -35.320  1.00 30.51           C
ATOM   6821  O   LEU   441      20.753  39.414 -34.511  1.00 27.25           O
ATOM   6823  N   ILE   442      20.758  38.612 -36.652  1.00 31.80           N
ATOM   6824  CA  ILE   442      20.973  39.926 -37.280  1.00 30.80           C
ATOM   6826  CB  ILE   442      21.000  39.853 -38.818  1.00 30.45           C
ATOM   6828  CG1 ILE   442      22.280  39.185 -39.300  1.00 28.64           C
ATOM   6831  CD1 ILE   442      22.227  38.673 -40.777  1.00 27.96           C
ATOM   6835  CG2 ILE   442      20.916  41.293 -39.419  1.00 30.86           C
ATOM   6839  C   ILE   442      19.910  40.941 -36.863  1.00 32.00           C
ATOM   6840  O   ILE   442      20.230  42.057 -36.460  1.00 31.02           O
ATOM   6842  N   LEU   443      18.644  40.539 -36.929  1.00 30.09           N
ATOM   6843  CA  LEU   443      17.570  41.444 -36.634  1.00 29.07           C
ATOM   6845  CB  LEU   443      16.266  40.923 -37.215  1.00 31.64           C
ATOM   6848  CG  LEU   443      16.255  40.845 -38.760  1.00 32.88           C
ATOM   6850  CD1 LEU   443      15.039  40.070 -39.246  1.00 30.85           C
ATOM   6854  CD2 LEU   443      16.293  42.248 -39.426  1.00 30.42           C
ATOM   6858  C   LEU   443      17.440  41.755 -35.153  1.00 32.11           C
ATOM   6859  O   LEU   443      17.077  42.863 -34.803  1.00 29.14           O
ATOM   6861  N   MET   444      17.727  40.775 -34.288  1.00 29.43           N
ATOM   6862  CA  MET   444      17.663  40.971 -32.872  1.00 28.33           C
ATOM   6864  CB  MET   444      17.895  39.637 -32.107  1.00 30.11           C
ATOM   6867  CG  MET   444      16.692  38.651 -32.074  1.00 26.55           C
ATOM   6870  SD  MET   444      15.116  39.346 -31.517  1.00 31.50           S
ATOM   6871  CE  MET   444      15.309  39.424 -29.742  1.00 30.92           C
ATOM   6875  C   MET   444      18.710  41.998 -32.446  1.00 32.02           C
ATOM   6876  O   MET   444      18.408  42.943 -31.707  1.00 30.41           O
ATOM   6878  N   LEU   445      19.937  41.797 -32.909  1.00 31.85           N
ATOM   6879  CA  LEU   445      21.038  42.714 -32.615  1.00 36.25           C
ATOM   6881  CB  LEU   445      22.338  42.141 -33.157  1.00 34.46           C
ATOM   6884  CG  LEU   445      22.930  40.918 -32.466  1.00 33.58           C
ATOM   6886  CD1 LEU   445      23.942  40.298 -33.379  1.00 26.76           C
ATOM   6890  CD2 LEU   445      23.572  41.262 -31.091  1.00 31.14           C
ATOM   6894  C   LEU   445      20.834  44.145 -33.203  1.00 38.00           C
ATOM   6895  O   LEU   445      21.240  45.124 -32.613  1.00 40.00           O
ATOM   6897  N   SER   446      20.206  44.234 -34.365  1.00 37.49           N
ATOM   6898  CA  SER   446      20.030  45.494 -35.036  1.00 35.55           C
ATOM   6900  CB  SER   446      19.851  45.274 -36.560  1.00 34.67           C
ATOM   6903  OG  SER   446      20.967  44.578 -37.120  1.00 32.04           O
ATOM   6905  C   SER   446      18.854  46.268 -34.468  1.00 38.10           C
ATOM   6906  O   SER   446      18.905  47.497 -34.393  1.00 38.48           O
ATOM   6908  N   TYR   447      17.805  45.558 -34.055  1.00 37.15           N
ATOM   6909  CA  TYR   447      16.541  46.180 -33.627  1.00 40.12           C
ATOM   6911  CB  TYR   447      15.350  45.250 -33.966  1.00 44.39           C
ATOM   6914  CG  TYR   447      14.882  45.247 -35.399  1.00 46.01           C
ATOM   6915  CD1 TYR   447      15.577  45.929 -36.411  1.00 47.04           C
ATOM   6917  CE1 TYR   447      15.124  45.911 -37.737  1.00 49.21           C
ATOM   6919  CZ  TYR   447      13.963  45.210 -38.059  1.00 47.80           C
ATOM   6920  OH  TYR   447      13.493  45.178 -39.354  1.00 48.58           O
ATOM   6922  CE2 TYR   447      13.273  44.523 -37.075  1.00 48.97           C
ATOM   6924  CD2 TYR   447      13.738  44.540 -35.752  1.00 47.62           C
ATOM   6926  C   TYR   447      16.430  46.500 -32.150  1.00 36.89           C
ATOM   6927  O   TYR   447      15.658  47.378 -31.778  1.00 38.69           O
ATOM   6929  N   PHE   448      17.138  45.762 -31.302  1.00 36.97           N
ATOM   6930  CA  PHE   448      16.828  45.777 -29.881  1.00 37.66           C
ATOM   6932  CB  PHE   448      16.184  44.435 -29.435  1.00 40.48           C
ATOM   6935  CG  PHE   448      14.860  44.133 -30.074  1.00 39.96           C
ATOM   6936  CD1 PHE   448      14.750  43.139 -31.037  1.00 39.79           C
ATOM   6938  CE1 PHE   448      13.508  42.845 -31.628  1.00 42.01           C
ATOM   6940  CZ  PHE   448      12.375  43.546 -31.249  1.00 40.64           C
ATOM   6942  CE2 PHE   448      12.483  44.542 -30.279  1.00 42.93           C
ATOM   6944  CD2 PHE   448      13.720  44.816 -29.691  1.00 39.24           C
ATOM   6946  C   PHE   448      18.046  45.966 -29.018  1.00 37.26           C
ATOM   6947  O   PHE   448      19.153  45.605 -29.401  1.00 35.03           O
ATOM   6949  N   GLU   449      17.804  46.510 -27.824  1.00 40.11           N
ATOM   6950  CA  GLU   449      18.702  46.349 -26.690  1.00 42.78           C
ATOM   6952  CB  GLU   449      18.610  47.533 -25.694  1.00 46.27           C
ATOM   6955  CG  GLU   449      18.787  48.946 -26.317  1.00 49.97           C
ATOM   6958  CD  GLU   449      20.215  49.231 -26.808  1.00 52.80           C
ATOM   6959  OE1 GLU   449      21.089  48.338 -26.681  1.00 55.15           O
ATOM   6960  OE2 GLU   449      20.463  50.362 -27.322  1.00 55.59           O
ATOM   6961  C   GLU   449      18.263  45.067 -26.008  1.00 39.74           C
ATOM   6962  O   GLU   449      17.081  44.771 -25.954  1.00 37.44           O
ATOM   6964  N   LEU   450      19.225  44.320 -25.489  1.00 41.36           N
ATOM   6965  CA  LEU   450      18.990  42.982 -25.002  1.00 41.82           C
ATOM   6967  CB  LEU   450      19.495  41.973 -26.039  1.00 40.96           C
ATOM   6970  CG  LEU   450      18.781  42.002 -27.383  1.00 38.83           C
ATOM   6972  CD1 LEU   450      19.467  41.079 -28.388  1.00 38.34           C
ATOM   6976  CD2 LEU   450      17.312  41.653 -27.183  1.00 39.06           C
ATOM   6980  C   LEU   450      19.714  42.764 -23.689  1.00 43.13           C
ATOM   6981  O   LEU   450      20.902  43.061 -23.587  1.00 44.23           O
ATOM   6983  N   GLU   451      18.990  42.238 -22.695  1.00 43.77           N
ATOM   6984  CA  GLU   451      19.560  41.886 -21.395  1.00 46.91           C
ATOM   6986  CB  GLU   451      19.492  43.101 -20.412  1.00 49.77           C
ATOM   6989  CG  GLU   451      20.708  44.097 -20.548  1.00 53.19           C
ATOM   6992  CD  GLU   451      20.518  45.429 -19.787  1.00 55.23           C
ATOM   6993  OE1 GLU   451      19.694  45.468 -18.830  1.00 58.02           O
ATOM   6994  OE2 GLU   451      21.199  46.429 -20.157  1.00 55.15           O
ATOM   6995  C   GLU   451      18.886  40.645 -20.781  1.00 42.65           C
ATOM   6996  O   GLU   451      17.687  40.446 -20.891  1.00 38.88           O
ATOM   6998  N   LEU   452      19.695  39.806 -20.163  1.00 43.73           N
ATOM   6999  CA  LEU   452      19.201  38.725 -19.346  1.00 44.98           C
ATOM   7001  CB  LEU   452      20.296  37.671 -19.139  1.00 42.92           C
ATOM   7004  CG  LEU   452      20.766  36.917 -20.395  1.00 40.82           C
ATOM   7006  CD1 LEU   452      21.692  35.835 -20.000  1.00 39.65           C
ATOM   7010  CD2 LEU   452      19.576  36.352 -21.197  1.00 38.93           C
ATOM   7014  C   LEU   452      18.780  39.281 -18.009  1.00 48.80           C
ATOM   7015  O   LEU   452      19.540  39.993 -17.381  1.00 50.07           O
ATOM   7017  N   ILE   453      17.567  38.938 -17.574  1.00 53.76           N
ATOM   7018  CA  ILE   453      17.068  39.299 -16.237  1.00 57.83           C
ATOM   7020  CB  ILE   453      15.618  38.797 -16.031  1.00 55.58           C
ATOM   7022  CG1 ILE   453      14.662  39.455 -17.045  1.00 54.10           C
ATOM   7025  CD1 ILE   453      14.669  40.973 -17.044  1.00 51.89           C
ATOM   7029  CG2 ILE   453      15.143  39.067 -14.601  1.00 55.61           C
ATOM   7033  C   ILE   453      17.973  38.724 -15.124  1.00 64.97           C
ATOM   7034  O   ILE   453      18.144  39.328 -14.062  1.00 65.82           O
ATOM   7036  N   GLU   454      18.539  37.556 -15.390  1.00 72.13           N
ATOM   7037  CA  GLU   454      19.542  36.957 -14.544  1.00 78.34           C
ATOM   7039  CB  GLU   454      19.025  35.629 -13.985  1.00 80.52           C
ATOM   7042  CG  GLU   454      17.900  35.759 -12.988  1.00 82.09           C
ATOM   7045  CD  GLU   454      18.405  36.056 -11.601  1.00 83.44           C
ATOM   7046  OE1 GLU   454      19.162  37.045 -11.440  1.00 84.12           O
ATOM   7047  OE2 GLU   454      18.045  35.295 -10.673  1.00 83.72           O
ATOM   7048  C   GLU   454      20.802  36.717 -15.375  1.00 82.08           C
ATOM   7049  O   GLU   454      21.045  35.592 -15.833  1.00 84.12           O
ATOM   7051  N   GLY   455      21.602  37.772 -15.569  1.00 85.70           N
ATOM   7052  CA  GLY   455      22.855  37.685 -16.354  1.00 87.77           C
ATOM   7055  C   GLY   455      23.837  36.638 -15.836  1.00 89.96           C
ATOM   7056  O   GLY   455      24.714  36.164 -16.575  1.00 89.37           O
ATOM   7058  N   GLN   456      23.667  36.280 -14.560  1.00 92.47           N
ATOM   7059  CA  GLN   456      24.539  35.348 -13.850  1.00 93.39           C
ATOM   7061  CB  GLN   456      24.932  35.974 -12.500  1.00 95.23           C
ATOM   7064  CG  GLN   456      25.428  37.458 -12.595  1.00 96.63           C
ATOM   7067  CD  GLN   456      24.695  38.414 -11.636  1.00 97.69           C
ATOM   7068  OE1 GLN   456      23.481  38.301 -11.422  1.00 97.99           O
ATOM   7069  NE2 GLN   456      25.436  39.365 -11.074  1.00 98.22           N
ATOM   7072  C   GLN   456      23.865  33.979 -13.616  1.00 91.98           C
ATOM   7073  O   GLN   456      24.513  33.048 -13.132  1.00 91.50           O
ATOM   7075  N   ALA   457      22.570  33.867 -13.953  1.00 90.39           N
ATOM   7076  CA  ALA   457      21.811  32.606 -13.800  1.00 87.92           C
ATOM   7078  CB  ALA   457      20.345  32.796 -14.209  1.00 87.50           C
ATOM   7082  C   ALA   457      22.428  31.459 -14.607  1.00 85.05           C
ATOM   7083  O   ALA   457      22.716  31.599 -15.798  1.00 85.07           O
ATOM   7085  N   LYS   458      22.611  30.325 -13.943  1.00 81.37           N
ATOM   7086  CA  LYS   458      23.161  29.135 -14.571  1.00 78.71           C
ATOM   7088  CB  LYS   458      23.058  27.931 -13.607  1.00 82.27           C
ATOM   7091  CG  LYS   458      24.073  26.784 -13.864  1.00 85.41           C
ATOM   7094  CD  LYS   458      25.476  27.115 -13.296  1.00 87.61           C
ATOM   7097  CE  LYS   458      26.182  25.865 -12.737  1.00 88.68           C
ATOM   7100  NZ  LYS   458      27.395  26.217 -11.945  1.00 89.23           N
ATOM   7104  C   LYS   458      22.432  28.804 -15.887  1.00 70.86           C
ATOM   7105  O   LYS   458      21.240  29.108 -16.065  1.00 68.81           O
ATOM   7107  N   CYS   459      23.176  28.196 -16.801  1.00 63.61           N
ATOM   7108  CA  CYS   459      22.608  27.690 -18.054  0.50 60.23           C
ATOM   7112  CB  CYS   459      23.693  27.101 -18.952  0.50 59.15           C
ATOM   7118  SG  CYS   459      24.988  28.254 -19.369  0.50 58.05           S
ATOM   7122  C   CYS   459      21.596  26.607 -17.741  1.00 56.80           C
ATOM   7123  O   CYS   459      21.875  25.711 -16.942  1.00 55.38           O
ATOM   7125  N   PRO   460      20.400  26.678 -18.371  1.00 50.54           N
ATOM   7126  CA  PRO   460      19.479  25.601 -18.044  1.00 46.06           C
ATOM   7128  CB  PRO   460      18.178  25.997 -18.761  1.00 47.74           C
ATOM   7131  CG  PRO   460      18.358  27.422 -19.145  1.00 49.32           C
ATOM   7134  CD  PRO   460      19.817  27.617 -19.340  1.00 49.34           C
ATOM   7137  C   PRO   460      20.005  24.275 -18.561  1.00 41.22           C
ATOM   7138  O   PRO   460      20.685  24.231 -19.581  1.00 36.29           O
ATOM   7139  N   PRO   461      19.729  23.201 -17.845  1.00 38.95           N
ATOM   7140  CA  PRO   461      20.107  21.924 -18.413  1.00 36.87           C
ATOM   7142  CB  PRO   461      19.828  20.924 -17.281  1.00 39.09           C
ATOM   7145  CG  PRO   461      19.004  21.643 -16.269  1.00 40.31           C
ATOM   7148  CD  PRO   461      19.082  23.094 -16.520  1.00 40.23           C
ATOM   7151  C   PRO   461      19.272  21.598 -19.665  1.00 32.32           C
ATOM   7152  O   PRO   461      18.188  22.123 -19.858  1.00 32.16           O
ATOM   7153  N   LEU   462      19.793  20.731 -20.499  1.00 29.17           N
ATOM   7154  CA  LEU   462      19.058  20.252 -21.624  1.00 27.95           C
ATOM   7156  CB  LEU   462      19.947  19.440 -22.545  1.00 26.57           C
ATOM   7159  CG  LEU   462      21.140  20.142 -23.202  1.00 27.43           C
ATOM   7161  CD1 LEU   462      21.873  19.104 -24.147  1.00 21.18           C
ATOM   7165  CD2 LEU   462      20.687  21.371 -23.951  1.00 24.63           C
ATOM   7169  C   LEU   462      17.940  19.402 -21.113  1.00 26.03           C
ATOM   7170  O   LEU   462      18.066  18.748 -20.087  1.00 31.01           O
ATOM   7172  N   ASP   463      16.837  19.414 -21.826  1.00 26.90           N
ATOM   7173  CA  ASP   463      15.732  18.557 -21.520  1.00 26.42           C
ATOM   7175  CB  ASP   463      14.435  19.262 -21.860  1.00 28.19           C
ATOM   7178  CG  ASP   463      13.214  18.382 -21.686  1.00 30.68           C
ATOM   7179  OD1 ASP   463      13.307  17.209 -21.200  1.00 30.56           O
ATOM   7180  OD2 ASP   463      12.143  18.881 -22.062  1.00 33.92           O
ATOM   7181  C   ASP   463      15.876  17.299 -22.342  1.00 24.83           C
ATOM   7182  O   ASP   463      15.543  17.282 -23.532  1.00 25.54           O
ATOM   7184  N   GLN   464      16.322  16.226 -21.688  1.00 20.83           N
ATOM   7185  CA  GLN   464      16.636  14.971 -22.362  1.00 22.31           C
ATOM   7187  CB  GLN   464      17.762  14.232 -21.587  1.00 21.99           C
ATOM   7190  CG  GLN   464      19.145  14.846 -21.725  1.00 22.70           C
ATOM   7193  CD  GLN   464      20.235  13.879 -21.342  1.00 25.92           C
ATOM   7194  OE1 GLN   464      20.601  12.983 -22.111  1.00 29.19           O
ATOM   7195  NE2 GLN   464      20.733  14.015 -20.129  1.00 31.10           N
ATOM   7198  C   GLN   464      15.414  14.035 -22.624  1.00 22.36           C
ATOM   7199  O   GLN   464      15.573  12.903 -23.066  1.00 23.04           O
ATOM   7201  N   SER   465      14.200  14.526 -22.400  1.00 26.88           N
ATOM   7202  CA  SER   465      12.989  13.770 -22.732  1.00 25.14           C
ATOM   7204  CB  SER   465      11.741  14.452 -22.119  1.00 29.74           C
ATOM   7207  OG  SER   465      11.435  15.655 -22.781  1.00 30.79           O
ATOM   7209  C   SER   465      12.844  13.605 -24.240  1.00 24.84           C
ATOM   7210  O   SER   465      12.223  12.635 -24.715  1.00 20.33           O
ATOM   7212  N   ARG   466      13.473  14.526 -24.999  1.00 22.92           N
ATOM   7213  CA  ARG   466      13.444  14.483 -26.452  0.50 24.81           C
ATOM   7217  CB  ARG   466      13.189  15.875 -27.009  0.50 27.86           C
ATOM   7223  CG  ARG   466      11.992  16.550 -26.357  0.50 32.11           C
ATOM   7229  CD  ARG   466      11.627  17.831 -27.042  0.50 36.19           C
ATOM   7235  NE  ARG   466      11.067  17.589 -28.372  0.50 39.00           N
ATOM   7239  CZ  ARG   466      11.703  17.772 -29.532  0.50 41.35           C
ATOM   7241  NH1 ARG   466      12.979  18.216 -29.577  0.50 43.44           N
ATOM   7247  NH2 ARG   466      11.053  17.514 -30.670  0.50 40.73           N
ATOM   7253  C   ARG   466      14.719  13.896 -27.047  1.00 22.44           C
ATOM   7254  O   ARG   466      14.916  13.971 -28.256  1.00 22.57           O
ATOM   7256  N   ALA   467      15.553  13.275 -26.192  1.00 22.57           N
ATOM   7257  CA  ALA   467      16.815  12.667 -26.609  1.00 20.12           C
ATOM   7259  CB  ALA   467      17.472  11.936 -25.439  1.00 20.26           C
ATOM   7263  C   ALA   467      16.588  11.723 -27.775  1.00 23.34           C
ATOM   7264  O   ALA   467      15.722  10.839 -27.736  1.00 27.67           O
ATOM   7266  N   GLY   468      17.341  11.940 -28.835  1.00 23.15           N
ATOM   7267  CA  GLY   468      17.141  11.215 -30.072  1.00 24.68           C
ATOM   7270  C   GLY   468      16.568  12.061 -31.184  1.00 24.22           C
ATOM   7271  O   GLY   468      16.815  11.784 -32.354  1.00 24.79           O
ATOM   7273  N   LEU   469      15.841  13.116 -30.828  1.00 23.34           N
ATOM   7274  CA  LEU   469      14.950  13.788 -31.792  1.00 24.41           C
ATOM   7276  CB  LEU   469      13.635  14.257 -31.117  1.00 24.45           C
ATOM   7279  CG  LEU   469      12.580  13.182 -30.910  1.00 30.06           C
ATOM   7281  CD1 LEU   469      11.327  13.829 -30.362  1.00 30.40           C
ATOM   7285  CD2 LEU   469      12.279  12.378 -32.258  1.00 34.22           C
ATOM   7289  C   LEU   469      15.549  14.946 -32.509  1.00 25.26           C
ATOM   7290  O   LEU   469      14.942  15.419 -33.491  1.00 25.87           O
ATOM   7292  N   GLY   470      16.691  15.459 -32.019  1.00 20.92           N
ATOM   7293  CA  GLY   470      17.337  16.609 -32.647  1.00 18.51           C
ATOM   7296  C   GLY   470      17.896  17.555 -31.620  1.00 17.36           C
ATOM   7297  O   GLY   470      18.520  17.113 -30.673  1.00 21.48           O
ATOM   7299  N   ILE   471      17.677  18.856 -31.804  1.00 17.41           N
ATOM   7300  CA  ILE   471      18.143  19.860 -30.841  1.00 18.24           C
ATOM   7302  CB  ILE   471      18.167  21.295 -31.453  1.00 20.54           C
ATOM   7304  CG1 ILE   471      18.895  21.312 -32.818  1.00 19.73           C
ATOM   7307  CD1 ILE   471      20.371  20.764 -32.797  1.00 17.55           C
ATOM   7311  CG2 ILE   471      18.835  22.291 -30.484  1.00 17.18           C
ATOM   7315  C   ILE   471      17.290  19.888 -29.599  1.00 18.92           C
ATOM   7316  O   ILE   471      16.097  20.088 -29.680  1.00 22.84           O
ATOM   7318  N   LEU   472      17.904  19.703 -28.432  1.00 20.57           N
ATOM   7319  CA  LEU   472      17.166  19.642 -27.187  1.00 19.32           C
ATOM   7321  CB  LEU   472      17.901  18.812 -26.141  1.00 21.15           C
ATOM   7324  CG  LEU   472      18.227  17.353 -26.436  1.00 21.16           C
ATOM   7326  CD1 LEU   472      18.859  16.695 -25.176  1.00 19.46           C
ATOM   7330  CD2 LEU   472      16.952  16.572 -26.978  1.00 21.75           C
ATOM   7334  C   LEU   472      16.916  21.046 -26.631  1.00 24.32           C
ATOM   7335  O   LEU   472      17.833  21.848 -26.548  1.00 21.60           O
ATOM   7337  N   PRO   473      15.659  21.340 -26.244  1.00 25.60           N
ATOM   7338  CA  PRO   473      15.329  22.585 -25.621  1.00 24.38           C
ATOM   7340  CB  PRO   473      13.779  22.610 -25.658  1.00 27.38           C
ATOM   7343  CG  PRO   473      13.368  21.268 -25.673  1.00 29.14           C
ATOM   7346  CD  PRO   473      14.490  20.469 -26.379  1.00 28.31           C
ATOM   7349  C   PRO   473      15.828  22.648 -24.198  1.00 26.44           C
ATOM   7350  O   PRO   473      16.292  21.635 -23.641  1.00 23.23           O
ATOM   7351  N   PRO   474      15.748  23.834 -23.590  1.00 25.14           N
ATOM   7352  CA  PRO   474      16.120  23.941 -22.202  1.00 26.34           C
ATOM   7354  CB  PRO   474      16.135  25.460 -21.969  1.00 25.93           C
ATOM   7357  CG  PRO   474      15.181  25.988 -22.906  1.00 25.75           C
ATOM   7360  CD  PRO   474      15.341  25.131 -24.147  1.00 26.72           C
ATOM   7363  C   PRO   474      15.083  23.283 -21.292  1.00 27.83           C
ATOM   7364  O   PRO   474      13.910  23.308 -21.591  1.00 25.99           O
ATOM   7365  N   LEU   475      15.520  22.749 -20.165  1.00 31.02           N
ATOM   7366  CA  LEU   475      14.600  22.156 -19.198  1.00 33.11           C
ATOM   7368  CB  LEU   475      15.389  21.476 -18.086  1.00 33.78           C
ATOM   7371  CG  LEU   475      14.569  20.597 -17.128  1.00 36.36           C
ATOM   7373  CD1 LEU   475      13.895  19.434 -17.856  1.00 35.37           C
ATOM   7377  CD2 LEU   475      15.475  20.091 -16.010  1.00 36.01           C
ATOM   7381  C   LEU   475      13.618  23.204 -18.644  1.00 34.34           C
ATOM   7382  O   LEU   475      12.416  22.930 -18.497  1.00 30.92           O
ATOM   7384  N   ASN   476      14.147  24.408 -18.379  1.00 35.14           N
ATOM   7385  CA  ASN   476      13.331  25.548 -17.969  0.50 33.58           C
ATOM   7389  CB  ASN   476      13.551  25.841 -16.481  0.50 33.28           C
ATOM   7395  CG  ASN   476      15.000  26.027 -16.136  0.50 31.53           C
ATOM   7397  OD1 ASN   476      15.554  27.101 -16.328  0.50 31.38           O
ATOM   7399  ND2 ASN   476      15.634  24.973 -15.630  0.50 32.52           N
ATOM   7405  C   ASN   476      13.639  26.790 -18.829  1.00 34.31           C
ATOM   7406  O   ASN   476      14.754  26.974 -19.296  1.00 33.71           O
ATOM   7408  N   ASP   477      12.627  27.625 -19.063  1.00 30.35           N
ATOM   7409  CA  ASP   477      12.809  28.856 -19.824  1.00 33.59           C
ATOM   7411  CB  ASP   477      11.453  29.435 -20.274  1.00 30.78           C
ATOM   7414  CG  ASP   477      11.570  30.345 -21.504  1.00 30.00           C
ATOM   7415  OD1 ASP   477      12.703  30.620 -21.939  1.00 29.10           O
ATOM   7416  OD2 ASP   477      10.518  30.769 -22.043  1.00 29.95           O
ATOM   7417  C   ASP   477      13.574  29.889 -18.952  1.00 37.78           C
ATOM   7418  O   ASP   477      13.628  29.771 -17.729  1.00 38.14           O
ATOM   7420  N   ILE   478      14.197  30.859 -19.598  1.00 39.56           N
ATOM   7421  CA  ILE   478      14.901  31.911 -18.892  1.00 41.88           C
ATOM   7423  CB  ILE   478      16.473  31.840 -19.066  1.00 44.93           C
ATOM   7425  CG1 ILE   478      16.898  32.268 -20.451  1.00 46.43           C
ATOM   7428  CD1 ILE   478      17.237  33.780 -20.533  1.00 49.25           C
ATOM   7432  CG2 ILE   478      17.008  30.446 -18.749  1.00 45.96           C
ATOM   7436  C   ILE   478      14.354  33.244 -19.350  1.00 41.42           C
ATOM   7437  O   ILE   478      13.965  33.433 -20.541  1.00 37.06           O
ATOM   7439  N   GLU   479      14.310  34.178 -18.415  1.00 41.03           N
ATOM   7440  CA  GLU   479      13.731  35.469 -18.701  1.00 41.90           C
ATOM   7442  CB  GLU   479      13.038  36.027 -17.478  1.00 47.80           C
ATOM   7445  CG  GLU   479      11.729  35.292 -17.198  1.00 52.53           C
ATOM   7448  CD  GLU   479      10.687  36.182 -16.579  1.00 57.39           C
ATOM   7449  OE1 GLU   479      11.008  36.803 -15.536  1.00 59.74           O
ATOM   7450  OE2 GLU   479       9.549  36.253 -17.133  1.00 59.67           O
ATOM   7451  C   GLU   479      14.743  36.420 -19.249  1.00 39.12           C
ATOM   7452  O   GLU   479      15.926  36.422 -18.833  1.00 34.65           O
ATOM   7454  N   PHE   480      14.291  37.194 -20.241  1.00 36.16           N
ATOM   7455  CA  PHE   480      15.085  38.254 -20.796  1.00 34.30           C
ATOM   7457  CB  PHE   480      15.921  37.784 -22.020  1.00 34.48           C
ATOM   7460  CG  PHE   480      15.226  37.917 -23.369  1.00 33.96           C
ATOM   7461  CD1 PHE   480      15.884  38.511 -24.437  1.00 33.06           C
ATOM   7463  CE1 PHE   480      15.279  38.625 -25.683  1.00 32.81           C
ATOM   7465  CZ  PHE   480      14.020  38.128 -25.884  1.00 32.92           C
ATOM   7467  CE2 PHE   480      13.336  37.536 -24.833  1.00 32.84           C
ATOM   7469  CD2 PHE   480      13.943  37.420 -23.579  1.00 34.06           C
ATOM   7471  C   PHE   480      14.234  39.458 -21.079  1.00 36.87           C
ATOM   7472  O   PHE   480      12.990  39.408 -20.996  1.00 34.07           O
ATOM   7474  N   LYS   481      14.935  40.543 -21.380  1.00 39.41           N
ATOM   7475  CA  LYS   481      14.374  41.864 -21.494  1.00 42.68           C
ATOM   7477  CB  LYS   481      14.963  42.724 -20.372  1.00 45.35           C
ATOM   7480  CG  LYS   481      14.026  43.763 -19.814  1.00 47.95           C
ATOM   7483  CD  LYS   481      14.602  44.458 -18.559  1.00 49.33           C
ATOM   7486  CE  LYS   481      16.076  44.866 -18.696  1.00 51.36           C
ATOM   7489  NZ  LYS   481      16.377  46.022 -17.745  1.00 52.75           N
ATOM   7493  C   LYS   481      14.800  42.413 -22.853  1.00 40.39           C
ATOM   7494  O   LYS   481      15.956  42.242 -23.254  1.00 40.56           O
ATOM   7496  N   TYR   482      13.877  43.028 -23.577  1.00 38.71           N
ATOM   7497  CA  TYR   482      14.200  43.640 -24.860  1.00 40.11           C
ATOM   7499  CB  TYR   482      13.922  42.688 -26.044  1.00 42.05           C
ATOM   7502  CG  TYR   482      12.499  42.191 -26.163  1.00 41.79           C
ATOM   7503  CD1 TYR   482      12.046  41.117 -25.398  1.00 41.80           C
ATOM   7505  CE1 TYR   482      10.746  40.652 -25.509  1.00 40.83           C
ATOM   7507  CZ  TYR   482       9.886  41.253 -26.397  1.00 42.93           C
ATOM   7508  OH  TYR   482       8.606  40.803 -26.527  1.00 44.42           O
ATOM   7510  CE2 TYR   482      10.302  42.317 -27.171  1.00 44.16           C
ATOM   7512  CD2 TYR   482      11.616  42.775 -27.055  1.00 43.47           C
ATOM   7514  C   TYR   482      13.470  44.948 -25.067  1.00 39.49           C
ATOM   7515  O   TYR   482      12.355  45.122 -24.606  1.00 42.80           O
ATOM   7517  N   LYS   483      14.117  45.835 -25.812  1.00 42.69           N
ATOM   7518  CA  LYS   483      13.700  47.234 -25.997  1.00 44.71           C
ATOM   7520  CB  LYS   483      14.442  48.093 -24.963  1.00 46.56           C
ATOM   7523  CG  LYS   483      14.184  49.595 -24.955  1.00 47.52           C
ATOM   7526  CD  LYS   483      14.825  50.174 -23.704  1.00 48.30           C
ATOM   7529  CE  LYS   483      14.698  51.678 -23.584  1.00 51.12           C
ATOM   7532  NZ  LYS   483      15.206  52.164 -22.231  1.00 49.91           N
ATOM   7536  C   LYS   483      14.102  47.675 -27.380  1.00 41.40           C
ATOM   7537  O   LYS   483      15.256  47.501 -27.769  1.00 40.58           O
ATOM   7539  N   PHE   484      13.175  48.250 -28.131  1.00 42.93           N
ATOM   7540  CA  PHE   484      13.529  48.797 -29.435  1.00 46.68           C
ATOM   7542  CB  PHE   484      12.302  49.361 -30.154  1.00 48.15           C
ATOM   7545  CG  PHE   484      11.452  48.308 -30.801  1.00 48.55           C
ATOM   7546  CD1 PHE   484      10.186  48.010 -30.306  1.00 49.75           C
ATOM   7548  CE1 PHE   484       9.397  47.021 -30.912  1.00 50.65           C
ATOM   7550  CZ  PHE   484       9.889  46.323 -32.019  1.00 49.78           C
ATOM   7552  CE2 PHE   484      11.151  46.608 -32.510  1.00 49.56           C
ATOM   7554  CD2 PHE   484      11.929  47.594 -31.897  1.00 49.55           C
ATOM   7556  C   PHE   484      14.621  49.866 -29.316  1.00 48.36           C
ATOM   7557  O   PHE   484      14.521  50.764 -28.493  1.00 50.46           O
ATOM   7559  N   LYS   485      15.670  49.729 -30.121  1.00 50.45           N
ATOM   7560  CA  LYS   485      16.728  50.736 -30.207  1.00 53.46           C
ATOM   7562  CB  LYS   485      17.895  50.222 -31.051  1.00 52.71           C
ATOM   7565  CG  LYS   485      18.905  49.423 -30.312  1.00 52.40           C
ATOM   7568  CD  LYS   485      19.889  48.806 -31.294  1.00 53.44           C
ATOM   7571  CE  LYS   485      21.123  48.264 -30.585  1.00 55.41           C
ATOM   7574  NZ  LYS   485      21.779  47.194 -31.369  1.00 55.64           N
ATOM   7578  C   LYS   485      16.205  52.007 -30.866  1.00 56.69           C
ATOM   7579  O   LYS   485      15.282  51.953 -31.676  1.00 56.26           O
ATOM   7581  N   HIS   486      16.794  53.148 -30.502  1.00 60.74           N
ATOM   7582  CA  HIS   486      16.654  54.387 -31.290  1.00 62.88           C
ATOM   7584  CB  HIS   486      16.449  55.617 -30.398  1.00 64.55           C
ATOM   7587  CG  HIS   486      15.149  55.622 -29.669  1.00 66.06           C
ATOM   7588  ND1 HIS   486      15.068  55.661 -28.294  1.00 68.16           N
ATOM   7590  CE1 HIS   486      13.798  55.641 -27.928  1.00 69.46           C
ATOM   7592  NE2 HIS   486      13.053  55.585 -29.020  1.00 70.23           N
ATOM   7594  CD2 HIS   486      13.874  55.571 -30.122  1.00 68.38           C
ATOM   7596  C   HIS   486      17.924  54.545 -32.077  1.00 62.08           C
ATOM   7597  O   HIS   486      19.011  54.500 -31.513  1.00 61.18           O
ATOM   7599  N   HIS   487      17.797  54.719 -33.381  1.00 64.33           N
ATOM   7600  CA  HIS   487      18.967  54.863 -34.244  1.00 67.16           C
ATOM   7602  CB  HIS   487      18.763  54.071 -35.545  1.00 68.89           C
ATOM   7605  CG  HIS   487      18.504  52.607 -35.315  1.00 69.48           C
ATOM   7606  ND1 HIS   487      17.236  52.057 -35.344  1.00 68.19           N
ATOM   7608  CE1 HIS   487      17.315  50.763 -35.086  1.00 67.97           C
ATOM   7610  NE2 HIS   487      18.584  50.455 -34.878  1.00 69.21           N
ATOM   7612  CD2 HIS   487      19.349  51.590 -35.010  1.00 69.75           C
ATOM   7614  C   HIS   487      19.245  56.355 -34.492  1.00 66.20           C
ATOM   7615  O   HIS   487      18.369  57.093 -34.956  1.00 66.35           O
ATOM   7617  N   HIS   488      20.461  56.783 -34.142  1.00 64.52           N
ATOM   7618  CA  HIS   488      20.869  58.179 -34.228  1.00 62.73           C
ATOM   7620  CB  HIS   488      21.539  58.612 -32.914  1.00 60.00           C
ATOM   7623  CG  HIS   488      20.703  58.370 -31.691  1.00 56.82           C
ATOM   7624  ND1 HIS   488      19.476  58.972 -31.494  1.00 53.30           N
ATOM   7626  CE1 HIS   488      18.976  58.583 -30.334  1.00 53.41           C
ATOM   7628  NE2 HIS   488      19.838  57.756 -29.765  1.00 55.05           N
ATOM   7630  CD2 HIS   488      20.928  57.608 -30.592  1.00 55.75           C
ATOM   7632  C   HIS   488      21.838  58.384 -35.397  1.00 65.11           C
ATOM   7633  O   HIS   488      21.499  59.009 -36.406  1.00 67.28           O
END
