
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  103 ( 1724),  selected  103 , name 1f68_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 1f68_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G   730_A      S       1           -
LGA    -       -      M       2           -
LGA    -       -      Q       3           -
LGA    -       -      E       4           -
LGA    -       -      E       5           -
LGA    D   731_A      D       6          4.735
LGA    -       -      T       7           -
LGA    -       -      F       8           -
LGA    -       -      R       9           -
LGA    Q   732_A      E      10          0.389
LGA    L   733_A      L      11          0.587
LGA    Y   734_A      R      12          0.462
LGA    T   735_A      I      13          0.300
LGA    T   736_A      F      14          0.619
LGA    L   737_A      L      15          0.475
LGA    K   738_A      R      16          0.547
LGA    N   739_A      N      17          0.860
LGA    L   740_A      V      18          1.028
LGA    L   741_A      T      19          0.491
LGA    A   742_A      H      20          1.125
LGA    Q   743_A      R      21          1.415
LGA    I   744_A      L      22          1.212
LGA    K   745_A      A      23          1.155
LGA    S   746_A      I      24          2.574
LGA    H   747_A      D      25          2.564
LGA    P   748_A      K      26          2.478
LGA    S   749_A      R      27          2.128
LGA    A   750_A      F      28          1.393
LGA    W   751_A      R      29          1.023
LGA    P   752_A      V      30          0.872
LGA    F   753_A      F      31          0.751
LGA    M   754_A      T      32          0.814
LGA    E   755_A      K      33          0.705
LGA    P   756_A      P      34          0.434
LGA    V   757_A      V      35          0.340
LGA    K   758_A      D      36          0.231
LGA    K   759_A      P      37          1.170
LGA    S   760_A      D      38          1.551
LGA    E   761_A      E      39          1.832
LGA    A   762_A      V      40          1.216
LGA    P   763_A      P      41          2.572
LGA    D   764_A      D      42          1.421
LGA    Y   765_A      Y      43          1.134
LGA    Y   766_A      V      44          1.212
LGA    E   767_A      T      45          0.786
LGA    V   768_A      V      46          1.056
LGA    I   769_A      I      47          0.668
LGA    R   770_A      K      48          0.525
LGA    F   771_A      Q      49          0.866
LGA    P   772_A      P      50          1.180
LGA    I   773_A      M      51          0.678
LGA    D   774_A      D      52          0.767
LGA    L   775_A      L      53          0.967
LGA    K   776_A      S      54          1.010
LGA    T   777_A      S      55          0.890
LGA    M   778_A      V      56          0.888
LGA    T   779_A      I      57          1.259
LGA    E   780_A      S      58          1.262
LGA    R   781_A      K      59          1.128
LGA    L   782_A      I      60          1.296
LGA    R   783_A      D      61          1.424
LGA    S   784_A      L      62          1.059
LGA    R   785_A      H      63          1.159
LGA    Y   786_A      K      64          1.111
LGA    Y   787_A      Y      65          0.883
LGA    V   788_A      L      66          1.641
LGA    T   789_A      T      67          1.407
LGA    R   790_A      V      68          1.307
LGA    K   791_A      K      69          0.728
LGA    L   792_A      D      70          0.991
LGA    F   793_A      Y      71          0.674
LGA    V   794_A      L      72          0.255
LGA    A   795_A      R      73          0.231
LGA    D   796_A      D      74          0.308
LGA    L   797_A      I      75          0.318
LGA    Q   798_A      D      76          0.141
LGA    R   799_A      L      77          0.181
LGA    V   800_A      I      78          0.150
LGA    I   801_A      C      79          0.123
LGA    A   802_A      S      80          0.235
LGA    N   803_A      N      81          0.320
LGA    C   804_A      A      82          0.405
LGA    R   805_A      L      83          0.402
LGA    E   806_A      E      84          0.385
LGA    Y   807_A      Y      85          0.428
LGA    N   808_A      N      86          1.162
LGA    P   809_A      P      87          2.853
LGA    P   810_A      D      88          3.981
LGA    D   811_A      R      89          5.620
LGA    -       -      D      90           -
LGA    -       -      P      91           -
LGA    -       -      G      92           -
LGA    -       -      D      93           -
LGA    S   812_A      R      94          1.282
LGA    E   813_A      L      95          0.970
LGA    Y   814_A      I      96          0.445
LGA    C   815_A      R      97          0.367
LGA    R   816_A      H      98          0.910
LGA    C   817_A      R      99          0.632
LGA    A   818_A      A     100          0.624
LGA    S   819_A      C     101          1.489
LGA    A   820_A      A     102          1.451
LGA    L   821_A      L     103          1.053
LGA    E   822_A      R     104          1.688
LGA    K   823_A      D     105          1.804
LGA    F   824_A      T     106          1.178
LGA    F   825_A      A     107          1.308
LGA    Y   826_A      Y     108          1.626
LGA    F   827_A      A     109          1.348
LGA    K   828_A      I     110          0.617
LGA    L   829_A      I     111          1.590
LGA    K   830_A      K     112          1.564
LGA    E   831_A      E     113          0.995
LGA    G   832_A      E     114          1.729
LGA    -       -      L     115           -
LGA    -       -      D     116           -
LGA    -       -      E     117           -
LGA    -       -      D     118           -
LGA    -       -      F     119           -
LGA    -       -      E     120           -
LGA    -       -      Q     121           -
LGA    -       -      L     122           -
LGA    -       -      C     123           -
LGA    -       -      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  103  130    5.0    102    1.41    30.39     74.160     6.749

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.854120 * X  +  -0.040867 * Y  +  -0.518468 * Z  +  11.316586
  Y_new =  -0.008456 * X  +  -0.995685 * Y  +   0.092413 * Z  +  43.265987
  Z_new =  -0.520008 * X  +   0.083315 * Y  +   0.850088 * Z  +  -8.505037 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.097696   -3.043897  [ DEG:     5.5976   -174.4024 ]
  Theta =   0.546860    2.594733  [ DEG:    31.3328    148.6672 ]
  Phi   =  -3.131693    0.009900  [ DEG:  -179.4328      0.5672 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1f68_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1f68_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  103  130   5.0  102   1.41   30.39  74.160
REMARK  ---------------------------------------------------------- 
MOLECULE 1f68_A
HEADER    TRANSFERASE                             20-JUN-00   1F68              
TITLE     NMR SOLUTION STRUCTURE OF THE BROMODOMAIN FROM HUMAN GCN5             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HISTONE ACETYLTRANSFERASE;                                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: BROMODOMAIN;                                               
COMPND   5 SYNONYM: GCN5;                                                       
COMPND   6 EC: 2.3.1.48;                                                        
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 ORGAN: LIVER;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET24A                                    
KEYWDS    LEFT-HANDED FOUR-HELIX BUNDLE                                         
EXPDTA    NMR, 30 STRUCTURES                                                    
AUTHOR    P.E.WRIGHT,B.P.HUDSON,H.J.DYSON                                       
REVDAT   1   13-DEC-00 1F68    0                                                
JRNL        AUTH   B.P.HUDSON,M.A.MARTINEZ-YAMOUT,H.J.DYSON,P.E.WRIGHT          
JRNL        TITL   SOLUTION STRUCTURE AND ACETYL-LYSINE BINDING                 
JRNL        TITL 2 ACTIVITY OF THE GCN5 BROMODOMAIN.                            
JRNL        REF    J.MOL.BIOL.                   V. 304   355 2000              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1F68 A  730   832  UNP    Q92830   GCNL2_HUMAN    730    832             
SEQRES   1 A  103  GLY ASP GLN LEU TYR THR THR LEU LYS ASN LEU LEU ALA          
SEQRES   2 A  103  GLN ILE LYS SER HIS PRO SER ALA TRP PRO PHE MET GLU          
SEQRES   3 A  103  PRO VAL LYS LYS SER GLU ALA PRO ASP TYR TYR GLU VAL          
SEQRES   4 A  103  ILE ARG PHE PRO ILE ASP LEU LYS THR MET THR GLU ARG          
SEQRES   5 A  103  LEU ARG SER ARG TYR TYR VAL THR ARG LYS LEU PHE VAL          
SEQRES   6 A  103  ALA ASP LEU GLN ARG VAL ILE ALA ASN CYS ARG GLU TYR          
SEQRES   7 A  103  ASN PRO PRO ASP SER GLU TYR CYS ARG CYS ALA SER ALA          
SEQRES   8 A  103  LEU GLU LYS PHE PHE TYR PHE LYS LEU LYS GLU GLY              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A 730      -0.795  48.639 -12.059  1.00 10.00           N  
ATOM      2  CA  GLY A 730      -0.907  48.733 -10.612  1.00 10.00           C  
ATOM      3  C   GLY A 730      -0.155  47.578  -9.948  1.00 10.00           C  
ATOM      4  O   GLY A 730       0.074  46.541 -10.571  1.00 10.00           O  
ATOM      5  H   GLY A 730      -1.583  48.289 -12.579  1.00 10.00           H  
ATOM      6  HA2 GLY A 730      -0.501  49.686 -10.274  1.00 10.00           H  
ATOM      7  HA3 GLY A 730      -1.959  48.678 -10.331  1.00 10.00           H  
ATOM      8  N   ASP A 731       0.213  47.746  -8.672  1.00 10.00           N  
ATOM      9  CA  ASP A 731       0.835  46.684  -7.889  1.00 10.00           C  
ATOM     10  C   ASP A 731      -0.040  45.430  -7.935  1.00 10.00           C  
ATOM     11  O   ASP A 731      -1.256  45.519  -7.768  1.00 10.00           O  
ATOM     12  CB  ASP A 731       1.058  47.153  -6.445  1.00 10.00           C  
ATOM     13  CG  ASP A 731       1.397  45.980  -5.530  1.00 10.00           C  
ATOM     14  OD1 ASP A 731       2.584  45.592  -5.512  1.00 10.00           O  
ATOM     15  OD2 ASP A 731       0.450  45.465  -4.895  1.00 10.00           O  
ATOM     16  H   ASP A 731       0.003  48.620  -8.216  1.00 10.00           H  
ATOM     17  HA  ASP A 731       1.807  46.457  -8.331  1.00 10.00           H  
ATOM     18  HB2 ASP A 731       1.872  47.878  -6.419  1.00 10.00           H  
ATOM     19  HB3 ASP A 731       0.156  47.633  -6.068  1.00 10.00           H  
ATOM     20  N   GLN A 732       0.576  44.271  -8.173  1.00 10.00           N  
ATOM     21  CA  GLN A 732      -0.126  43.021  -8.423  1.00 10.00           C  
ATOM     22  C   GLN A 732      -1.061  42.686  -7.260  1.00 10.00           C  
ATOM     23  O   GLN A 732      -2.252  42.451  -7.473  1.00 10.00           O  
ATOM     24  CB  GLN A 732       0.874  41.880  -8.672  1.00 10.00           C  
ATOM     25  CG  GLN A 732       1.612  41.982 -10.019  1.00 10.00           C  
ATOM     26  CD  GLN A 732       2.724  43.029 -10.061  1.00 10.00           C  
ATOM     27  OE1 GLN A 732       3.098  43.609  -9.046  1.00 10.00           O  
ATOM     28  NE2 GLN A 732       3.272  43.285 -11.244  1.00 10.00           N  
ATOM     29  H   GLN A 732       1.583  44.276  -8.277  1.00 10.00           H  
ATOM     30  HA  GLN A 732      -0.740  43.145  -9.317  1.00 10.00           H  
ATOM     31  HB2 GLN A 732       1.590  41.812  -7.852  1.00 10.00           H  
ATOM     32  HB3 GLN A 732       0.304  40.949  -8.695  1.00 10.00           H  
ATOM     33  HG2 GLN A 732       2.073  41.015 -10.223  1.00 10.00           H  
ATOM     34  HG3 GLN A 732       0.890  42.191 -10.809  1.00 10.00           H  
ATOM     35 HE21 GLN A 732       2.966  42.801 -12.074  1.00 10.00           H  
ATOM     36 HE22 GLN A 732       4.007  43.975 -11.289  1.00 10.00           H  
ATOM     37  N   LEU A 733      -0.529  42.666  -6.035  1.00 10.00           N  
ATOM     38  CA  LEU A 733      -1.314  42.333  -4.854  1.00 10.00           C  
ATOM     39  C   LEU A 733      -2.494  43.294  -4.730  1.00 10.00           C  
ATOM     40  O   LEU A 733      -3.640  42.855  -4.697  1.00 10.00           O  
ATOM     41  CB  LEU A 733      -0.427  42.338  -3.598  1.00 10.00           C  
ATOM     42  CG  LEU A 733      -1.200  42.031  -2.303  1.00 10.00           C  
ATOM     43  CD1 LEU A 733      -1.843  40.638  -2.324  1.00 10.00           C  
ATOM     44  CD2 LEU A 733      -0.241  42.115  -1.113  1.00 10.00           C  
ATOM     45  H   LEU A 733       0.445  42.910  -5.920  1.00 10.00           H  
ATOM     46  HA  LEU A 733      -1.702  41.325  -5.002  1.00 10.00           H  
ATOM     47  HB2 LEU A 733       0.363  41.597  -3.725  1.00 10.00           H  
ATOM     48  HB3 LEU A 733       0.038  43.318  -3.493  1.00 10.00           H  
ATOM     49  HG  LEU A 733      -1.980  42.778  -2.150  1.00 10.00           H  
ATOM     50 HD11 LEU A 733      -2.298  40.433  -1.354  1.00 10.00           H  
ATOM     51 HD12 LEU A 733      -2.623  40.585  -3.082  1.00 10.00           H  
ATOM     52 HD13 LEU A 733      -1.089  39.879  -2.529  1.00 10.00           H  
ATOM     53 HD21 LEU A 733       0.203  43.111  -1.061  1.00 10.00           H  
ATOM     54 HD22 LEU A 733      -0.789  41.927  -0.190  1.00 10.00           H  
ATOM     55 HD23 LEU A 733       0.555  41.376  -1.213  1.00 10.00           H  
ATOM     56  N   TYR A 734      -2.220  44.602  -4.693  1.00 10.00           N  
ATOM     57  CA  TYR A 734      -3.249  45.632  -4.629  1.00 10.00           C  
ATOM     58  C   TYR A 734      -4.332  45.385  -5.681  1.00 10.00           C  
ATOM     59  O   TYR A 734      -5.514  45.344  -5.357  1.00 10.00           O  
ATOM     60  CB  TYR A 734      -2.611  47.015  -4.814  1.00 10.00           C  
ATOM     61  CG  TYR A 734      -3.614  48.147  -4.918  1.00 10.00           C  
ATOM     62  CD1 TYR A 734      -4.150  48.727  -3.752  1.00 10.00           C  
ATOM     63  CD2 TYR A 734      -4.077  48.565  -6.182  1.00 10.00           C  
ATOM     64  CE1 TYR A 734      -5.145  49.714  -3.850  1.00 10.00           C  
ATOM     65  CE2 TYR A 734      -5.086  49.538  -6.275  1.00 10.00           C  
ATOM     66  CZ  TYR A 734      -5.628  50.104  -5.110  1.00 10.00           C  
ATOM     67  OH  TYR A 734      -6.628  51.023  -5.213  1.00 10.00           O  
ATOM     68  H   TYR A 734      -1.248  44.893  -4.737  1.00 10.00           H  
ATOM     69  HA  TYR A 734      -3.711  45.597  -3.642  1.00 10.00           H  
ATOM     70  HB2 TYR A 734      -1.935  47.210  -3.980  1.00 10.00           H  
ATOM     71  HB3 TYR A 734      -2.019  47.003  -5.728  1.00 10.00           H  
ATOM     72  HD1 TYR A 734      -3.803  48.413  -2.779  1.00 10.00           H  
ATOM     73  HD2 TYR A 734      -3.674  48.127  -7.083  1.00 10.00           H  
ATOM     74  HE1 TYR A 734      -5.532  50.169  -2.951  1.00 10.00           H  
ATOM     75  HE2 TYR A 734      -5.443  49.851  -7.245  1.00 10.00           H  
ATOM     76  HH  TYR A 734      -6.902  51.375  -4.364  1.00 10.00           H  
ATOM     77  N   THR A 735      -3.931  45.215  -6.941  1.00 10.00           N  
ATOM     78  CA  THR A 735      -4.859  45.000  -8.043  1.00 10.00           C  
ATOM     79  C   THR A 735      -5.702  43.743  -7.801  1.00 10.00           C  
ATOM     80  O   THR A 735      -6.923  43.767  -7.975  1.00 10.00           O  
ATOM     81  CB  THR A 735      -4.083  44.947  -9.367  1.00 10.00           C  
ATOM     82  OG1 THR A 735      -3.305  46.120  -9.499  1.00 10.00           O  
ATOM     83  CG2 THR A 735      -5.022  44.873 -10.573  1.00 10.00           C  
ATOM     84  H   THR A 735      -2.938  45.246  -7.139  1.00 10.00           H  
ATOM     85  HA  THR A 735      -5.531  45.858  -8.082  1.00 10.00           H  
ATOM     86  HB  THR A 735      -3.424  44.077  -9.378  1.00 10.00           H  
ATOM     87  HG1 THR A 735      -2.531  46.038  -8.927  1.00 10.00           H  
ATOM     88 HG21 THR A 735      -5.712  45.718 -10.562  1.00 10.00           H  
ATOM     89 HG22 THR A 735      -4.432  44.910 -11.489  1.00 10.00           H  
ATOM     90 HG23 THR A 735      -5.587  43.940 -10.561  1.00 10.00           H  
ATOM     91  N   THR A 736      -5.064  42.646  -7.391  1.00 10.00           N  
ATOM     92  CA  THR A 736      -5.760  41.402  -7.091  1.00 10.00           C  
ATOM     93  C   THR A 736      -6.807  41.643  -6.000  1.00 10.00           C  
ATOM     94  O   THR A 736      -7.977  41.310  -6.175  1.00 10.00           O  
ATOM     95  CB  THR A 736      -4.754  40.310  -6.692  1.00 10.00           C  
ATOM     96  OG1 THR A 736      -3.787  40.165  -7.711  1.00 10.00           O  
ATOM     97  CG2 THR A 736      -5.439  38.954  -6.497  1.00 10.00           C  
ATOM     98  H   THR A 736      -4.063  42.693  -7.230  1.00 10.00           H  
ATOM     99  HA  THR A 736      -6.275  41.075  -7.996  1.00 10.00           H  
ATOM    100  HB  THR A 736      -4.250  40.582  -5.762  1.00 10.00           H  
ATOM    101  HG1 THR A 736      -3.236  40.957  -7.737  1.00 10.00           H  
ATOM    102 HG21 THR A 736      -4.686  38.201  -6.266  1.00 10.00           H  
ATOM    103 HG22 THR A 736      -6.154  38.998  -5.674  1.00 10.00           H  
ATOM    104 HG23 THR A 736      -5.960  38.666  -7.411  1.00 10.00           H  
ATOM    105  N   LEU A 737      -6.398  42.248  -4.884  1.00 10.00           N  
ATOM    106  CA  LEU A 737      -7.294  42.534  -3.773  1.00 10.00           C  
ATOM    107  C   LEU A 737      -8.414  43.486  -4.193  1.00 10.00           C  
ATOM    108  O   LEU A 737      -9.553  43.303  -3.780  1.00 10.00           O  
ATOM    109  CB  LEU A 737      -6.512  43.084  -2.577  1.00 10.00           C  
ATOM    110  CG  LEU A 737      -5.482  42.093  -2.009  1.00 10.00           C  
ATOM    111  CD1 LEU A 737      -4.783  42.752  -0.820  1.00 10.00           C  
ATOM    112  CD2 LEU A 737      -6.111  40.769  -1.563  1.00 10.00           C  
ATOM    113  H   LEU A 737      -5.430  42.546  -4.809  1.00 10.00           H  
ATOM    114  HA  LEU A 737      -7.775  41.605  -3.471  1.00 10.00           H  
ATOM    115  HB2 LEU A 737      -5.997  43.994  -2.887  1.00 10.00           H  
ATOM    116  HB3 LEU A 737      -7.223  43.339  -1.791  1.00 10.00           H  
ATOM    117  HG  LEU A 737      -4.728  41.864  -2.757  1.00 10.00           H  
ATOM    118 HD11 LEU A 737      -4.306  43.675  -1.147  1.00 10.00           H  
ATOM    119 HD12 LEU A 737      -5.520  42.978  -0.051  1.00 10.00           H  
ATOM    120 HD13 LEU A 737      -4.023  42.087  -0.410  1.00 10.00           H  
ATOM    121 HD21 LEU A 737      -5.357  40.183  -1.042  1.00 10.00           H  
ATOM    122 HD22 LEU A 737      -6.951  40.952  -0.895  1.00 10.00           H  
ATOM    123 HD23 LEU A 737      -6.447  40.194  -2.424  1.00 10.00           H  
ATOM    124  N   LYS A 738      -8.120  44.484  -5.026  1.00 10.00           N  
ATOM    125  CA  LYS A 738      -9.130  45.381  -5.569  1.00 10.00           C  
ATOM    126  C   LYS A 738     -10.155  44.592  -6.386  1.00 10.00           C  
ATOM    127  O   LYS A 738     -11.357  44.768  -6.210  1.00 10.00           O  
ATOM    128  CB  LYS A 738      -8.448  46.480  -6.396  1.00 10.00           C  
ATOM    129  CG  LYS A 738      -9.453  47.529  -6.891  1.00 10.00           C  
ATOM    130  CD  LYS A 738      -8.757  48.736  -7.540  1.00 10.00           C  
ATOM    131  CE  LYS A 738      -7.819  48.365  -8.697  1.00 10.00           C  
ATOM    132  NZ  LYS A 738      -8.495  47.553  -9.724  1.00 10.00           N  
ATOM    133  H   LYS A 738      -7.157  44.614  -5.311  1.00 10.00           H  
ATOM    134  HA  LYS A 738      -9.653  45.853  -4.736  1.00 10.00           H  
ATOM    135  HB2 LYS A 738      -7.700  46.978  -5.776  1.00 10.00           H  
ATOM    136  HB3 LYS A 738      -7.947  46.022  -7.247  1.00 10.00           H  
ATOM    137  HG2 LYS A 738     -10.148  47.077  -7.601  1.00 10.00           H  
ATOM    138  HG3 LYS A 738     -10.031  47.892  -6.040  1.00 10.00           H  
ATOM    139  HD2 LYS A 738      -9.524  49.420  -7.910  1.00 10.00           H  
ATOM    140  HD3 LYS A 738      -8.179  49.264  -6.779  1.00 10.00           H  
ATOM    141  HE2 LYS A 738      -7.457  49.284  -9.161  1.00 10.00           H  
ATOM    142  HE3 LYS A 738      -6.956  47.820  -8.315  1.00 10.00           H  
ATOM    143  HZ1 LYS A 738      -9.293  48.055 -10.084  1.00 10.00           H  
ATOM    144  HZ2 LYS A 738      -7.852  47.361 -10.480  1.00 10.00           H  
ATOM    145  HZ3 LYS A 738      -8.802  46.679  -9.321  1.00 10.00           H  
ATOM    146  N   ASN A 739      -9.696  43.714  -7.280  1.00 10.00           N  
ATOM    147  CA  ASN A 739     -10.598  42.887  -8.078  1.00 10.00           C  
ATOM    148  C   ASN A 739     -11.430  41.978  -7.172  1.00 10.00           C  
ATOM    149  O   ASN A 739     -12.645  41.876  -7.333  1.00 10.00           O  
ATOM    150  CB  ASN A 739      -9.823  42.070  -9.120  1.00 10.00           C  
ATOM    151  CG  ASN A 739      -9.514  42.894 -10.365  1.00 10.00           C  
ATOM    152  OD1 ASN A 739     -10.199  42.779 -11.374  1.00 10.00           O  
ATOM    153  ND2 ASN A 739      -8.491  43.741 -10.311  1.00 10.00           N  
ATOM    154  H   ASN A 739      -8.691  43.594  -7.370  1.00 10.00           H  
ATOM    155  HA  ASN A 739     -11.295  43.538  -8.609  1.00 10.00           H  
ATOM    156  HB2 ASN A 739      -8.906  41.666  -8.688  1.00 10.00           H  
ATOM    157  HB3 ASN A 739     -10.446  41.230  -9.433  1.00 10.00           H  
ATOM    158 HD21 ASN A 739      -7.936  43.811  -9.463  1.00 10.00           H  
ATOM    159 HD22 ASN A 739      -8.270  44.284 -11.129  1.00 10.00           H  
ATOM    160  N   LEU A 740     -10.785  41.328  -6.203  1.00 10.00           N  
ATOM    161  CA  LEU A 740     -11.447  40.476  -5.225  1.00 10.00           C  
ATOM    162  C   LEU A 740     -12.521  41.272  -4.472  1.00 10.00           C  
ATOM    163  O   LEU A 740     -13.654  40.818  -4.326  1.00 10.00           O  
ATOM    164  CB  LEU A 740     -10.370  39.889  -4.300  1.00 10.00           C  
ATOM    165  CG  LEU A 740     -10.840  38.844  -3.277  1.00 10.00           C  
ATOM    166  CD1 LEU A 740     -11.547  37.656  -3.938  1.00 10.00           C  
ATOM    167  CD2 LEU A 740      -9.597  38.340  -2.529  1.00 10.00           C  
ATOM    168  H   LEU A 740      -9.780  41.446  -6.132  1.00 10.00           H  
ATOM    169  HA  LEU A 740     -11.927  39.664  -5.772  1.00 10.00           H  
ATOM    170  HB2 LEU A 740      -9.609  39.424  -4.931  1.00 10.00           H  
ATOM    171  HB3 LEU A 740      -9.903  40.705  -3.752  1.00 10.00           H  
ATOM    172  HG  LEU A 740     -11.522  39.306  -2.561  1.00 10.00           H  
ATOM    173 HD11 LEU A 740     -12.495  37.972  -4.373  1.00 10.00           H  
ATOM    174 HD12 LEU A 740     -10.914  37.228  -4.716  1.00 10.00           H  
ATOM    175 HD13 LEU A 740     -11.755  36.890  -3.190  1.00 10.00           H  
ATOM    176 HD21 LEU A 740      -9.859  37.526  -1.857  1.00 10.00           H  
ATOM    177 HD22 LEU A 740      -8.857  37.970  -3.239  1.00 10.00           H  
ATOM    178 HD23 LEU A 740      -9.160  39.154  -1.950  1.00 10.00           H  
ATOM    179  N   LEU A 741     -12.178  42.479  -4.024  1.00 10.00           N  
ATOM    180  CA  LEU A 741     -13.089  43.385  -3.343  1.00 10.00           C  
ATOM    181  C   LEU A 741     -14.250  43.771  -4.262  1.00 10.00           C  
ATOM    182  O   LEU A 741     -15.400  43.772  -3.833  1.00 10.00           O  
ATOM    183  CB  LEU A 741     -12.314  44.611  -2.838  1.00 10.00           C  
ATOM    184  CG  LEU A 741     -13.169  45.603  -2.033  1.00 10.00           C  
ATOM    185  CD1 LEU A 741     -13.813  44.965  -0.794  1.00 10.00           C  
ATOM    186  CD2 LEU A 741     -12.276  46.765  -1.589  1.00 10.00           C  
ATOM    187  H   LEU A 741     -11.226  42.793  -4.168  1.00 10.00           H  
ATOM    188  HA  LEU A 741     -13.480  42.848  -2.481  1.00 10.00           H  
ATOM    189  HB2 LEU A 741     -11.493  44.270  -2.208  1.00 10.00           H  
ATOM    190  HB3 LEU A 741     -11.892  45.137  -3.692  1.00 10.00           H  
ATOM    191  HG  LEU A 741     -13.954  46.002  -2.675  1.00 10.00           H  
ATOM    192 HD11 LEU A 741     -14.562  44.230  -1.085  1.00 10.00           H  
ATOM    193 HD12 LEU A 741     -13.050  44.484  -0.181  1.00 10.00           H  
ATOM    194 HD13 LEU A 741     -14.306  45.734  -0.198  1.00 10.00           H  
ATOM    195 HD21 LEU A 741     -12.872  47.484  -1.030  1.00 10.00           H  
ATOM    196 HD22 LEU A 741     -11.470  46.403  -0.950  1.00 10.00           H  
ATOM    197 HD23 LEU A 741     -11.851  47.263  -2.461  1.00 10.00           H  
ATOM    198  N   ALA A 742     -13.970  44.082  -5.530  1.00 10.00           N  
ATOM    199  CA  ALA A 742     -15.000  44.398  -6.510  1.00 10.00           C  
ATOM    200  C   ALA A 742     -15.964  43.219  -6.672  1.00 10.00           C  
ATOM    201  O   ALA A 742     -17.179  43.399  -6.618  1.00 10.00           O  
ATOM    202  CB  ALA A 742     -14.363  44.793  -7.846  1.00 10.00           C  
ATOM    203  H   ALA A 742     -13.000  44.093  -5.826  1.00 10.00           H  
ATOM    204  HA  ALA A 742     -15.565  45.256  -6.144  1.00 10.00           H  
ATOM    205  HB1 ALA A 742     -13.809  43.959  -8.273  1.00 10.00           H  
ATOM    206  HB2 ALA A 742     -15.146  45.090  -8.546  1.00 10.00           H  
ATOM    207  HB3 ALA A 742     -13.685  45.634  -7.697  1.00 10.00           H  
ATOM    208  N   GLN A 743     -15.432  42.007  -6.847  1.00 10.00           N  
ATOM    209  CA  GLN A 743     -16.228  40.786  -6.899  1.00 10.00           C  
ATOM    210  C   GLN A 743     -17.092  40.659  -5.642  1.00 10.00           C  
ATOM    211  O   GLN A 743     -18.298  40.440  -5.738  1.00 10.00           O  
ATOM    212  CB  GLN A 743     -15.304  39.572  -7.077  1.00 10.00           C  
ATOM    213  CG  GLN A 743     -14.761  39.473  -8.506  1.00 10.00           C  
ATOM    214  CD  GLN A 743     -15.807  38.893  -9.452  1.00 10.00           C  
ATOM    215  OE1 GLN A 743     -15.968  37.678  -9.531  1.00 10.00           O  
ATOM    216  NE2 GLN A 743     -16.537  39.740 -10.169  1.00 10.00           N  
ATOM    217  H   GLN A 743     -14.420  41.929  -6.891  1.00 10.00           H  
ATOM    218  HA  GLN A 743     -16.908  40.848  -7.748  1.00 10.00           H  
ATOM    219  HB2 GLN A 743     -14.467  39.645  -6.386  1.00 10.00           H  
ATOM    220  HB3 GLN A 743     -15.849  38.655  -6.848  1.00 10.00           H  
ATOM    221  HG2 GLN A 743     -14.425  40.448  -8.860  1.00 10.00           H  
ATOM    222  HG3 GLN A 743     -13.901  38.805  -8.506  1.00 10.00           H  
ATOM    223 HE21 GLN A 743     -16.403  40.737 -10.091  1.00 10.00           H  
ATOM    224 HE22 GLN A 743     -17.231  39.357 -10.792  1.00 10.00           H  
ATOM    225  N   ILE A 744     -16.483  40.818  -4.465  1.00 10.00           N  
ATOM    226  CA  ILE A 744     -17.197  40.822  -3.196  1.00 10.00           C  
ATOM    227  C   ILE A 744     -18.357  41.821  -3.227  1.00 10.00           C  
ATOM    228  O   ILE A 744     -19.487  41.439  -2.956  1.00 10.00           O  
ATOM    229  CB  ILE A 744     -16.205  41.055  -2.037  1.00 10.00           C  
ATOM    230  CG1 ILE A 744     -15.450  39.759  -1.696  1.00 10.00           C  
ATOM    231  CG2 ILE A 744     -16.853  41.667  -0.790  1.00 10.00           C  
ATOM    232  CD1 ILE A 744     -16.284  38.751  -0.897  1.00 10.00           C  
ATOM    233  H   ILE A 744     -15.478  40.971  -4.454  1.00 10.00           H  
ATOM    234  HA  ILE A 744     -17.654  39.841  -3.080  1.00 10.00           H  
ATOM    235  HB  ILE A 744     -15.459  41.771  -2.366  1.00 10.00           H  
ATOM    236 HG12 ILE A 744     -15.116  39.284  -2.620  1.00 10.00           H  
ATOM    237 HG13 ILE A 744     -14.566  40.009  -1.108  1.00 10.00           H  
ATOM    238 HG21 ILE A 744     -17.759  41.124  -0.534  1.00 10.00           H  
ATOM    239 HG22 ILE A 744     -16.154  41.631   0.045  1.00 10.00           H  
ATOM    240 HG23 ILE A 744     -17.109  42.711  -0.975  1.00 10.00           H  
ATOM    241 HD11 ILE A 744     -16.447  39.111   0.117  1.00 10.00           H  
ATOM    242 HD12 ILE A 744     -17.245  38.562  -1.369  1.00 10.00           H  
ATOM    243 HD13 ILE A 744     -15.736  37.815  -0.851  1.00 10.00           H  
ATOM    244  N   LYS A 745     -18.102  43.084  -3.572  1.00 10.00           N  
ATOM    245  CA  LYS A 745     -19.149  44.096  -3.657  1.00 10.00           C  
ATOM    246  C   LYS A 745     -20.231  43.689  -4.664  1.00 10.00           C  
ATOM    247  O   LYS A 745     -21.415  43.898  -4.414  1.00 10.00           O  
ATOM    248  CB  LYS A 745     -18.537  45.455  -4.021  1.00 10.00           C  
ATOM    249  CG  LYS A 745     -17.724  46.033  -2.856  1.00 10.00           C  
ATOM    250  CD  LYS A 745     -17.028  47.323  -3.306  1.00 10.00           C  
ATOM    251  CE  LYS A 745     -16.318  47.995  -2.126  1.00 10.00           C  
ATOM    252  NZ  LYS A 745     -15.513  49.144  -2.576  1.00 10.00           N  
ATOM    253  H   LYS A 745     -17.151  43.345  -3.807  1.00 10.00           H  
ATOM    254  HA  LYS A 745     -19.626  44.186  -2.681  1.00 10.00           H  
ATOM    255  HB2 LYS A 745     -17.904  45.346  -4.902  1.00 10.00           H  
ATOM    256  HB3 LYS A 745     -19.343  46.151  -4.256  1.00 10.00           H  
ATOM    257  HG2 LYS A 745     -18.393  46.241  -2.022  1.00 10.00           H  
ATOM    258  HG3 LYS A 745     -16.972  45.314  -2.529  1.00 10.00           H  
ATOM    259  HD2 LYS A 745     -16.299  47.076  -4.079  1.00 10.00           H  
ATOM    260  HD3 LYS A 745     -17.763  48.013  -3.723  1.00 10.00           H  
ATOM    261  HE2 LYS A 745     -17.052  48.339  -1.397  1.00 10.00           H  
ATOM    262  HE3 LYS A 745     -15.654  47.283  -1.638  1.00 10.00           H  
ATOM    263  HZ1 LYS A 745     -15.012  49.525  -1.780  1.00 10.00           H  
ATOM    264  HZ2 LYS A 745     -14.842  48.843  -3.268  1.00 10.00           H  
ATOM    265  HZ3 LYS A 745     -16.113  49.854  -2.970  1.00 10.00           H  
ATOM    266  N   SER A 746     -19.828  43.115  -5.801  1.00 10.00           N  
ATOM    267  CA  SER A 746     -20.758  42.647  -6.819  1.00 10.00           C  
ATOM    268  C   SER A 746     -21.672  41.549  -6.267  1.00 10.00           C  
ATOM    269  O   SER A 746     -22.862  41.527  -6.570  1.00 10.00           O  
ATOM    270  CB  SER A 746     -19.998  42.148  -8.054  1.00 10.00           C  
ATOM    271  OG  SER A 746     -19.126  43.146  -8.549  1.00 10.00           O  
ATOM    272  H   SER A 746     -18.833  42.984  -5.944  1.00 10.00           H  
ATOM    273  HA  SER A 746     -21.381  43.489  -7.125  1.00 10.00           H  
ATOM    274  HB2 SER A 746     -19.430  41.250  -7.811  1.00 10.00           H  
ATOM    275  HB3 SER A 746     -20.723  41.892  -8.828  1.00 10.00           H  
ATOM    276  HG  SER A 746     -18.489  43.377  -7.862  1.00 10.00           H  
ATOM    277  N   HIS A 747     -21.114  40.621  -5.483  1.00 10.00           N  
ATOM    278  CA  HIS A 747     -21.869  39.535  -4.872  1.00 10.00           C  
ATOM    279  C   HIS A 747     -22.981  40.101  -3.969  1.00 10.00           C  
ATOM    280  O   HIS A 747     -22.664  40.692  -2.935  1.00 10.00           O  
ATOM    281  CB  HIS A 747     -20.907  38.632  -4.095  1.00 10.00           C  
ATOM    282  CG  HIS A 747     -21.574  37.432  -3.482  1.00 10.00           C  
ATOM    283  ND1 HIS A 747     -22.171  36.395  -4.160  1.00 10.00           N  
ATOM    284  CD2 HIS A 747     -21.691  37.179  -2.144  1.00 10.00           C  
ATOM    285  CE1 HIS A 747     -22.651  35.539  -3.241  1.00 10.00           C  
ATOM    286  NE2 HIS A 747     -22.385  35.975  -1.997  1.00 10.00           N  
ATOM    287  H   HIS A 747     -20.121  40.690  -5.276  1.00 10.00           H  
ATOM    288  HA  HIS A 747     -22.272  38.927  -5.679  1.00 10.00           H  
ATOM    289  HB2 HIS A 747     -20.133  38.283  -4.774  1.00 10.00           H  
ATOM    290  HB3 HIS A 747     -20.430  39.200  -3.298  1.00 10.00           H  
ATOM    291  HD1 HIS A 747     -22.209  36.278  -5.162  1.00 10.00           H  
ATOM    292  HD2 HIS A 747     -21.325  37.809  -1.348  1.00 10.00           H  
ATOM    293  HE1 HIS A 747     -23.166  34.619  -3.468  1.00 10.00           H  
ATOM    294  N   PRO A 748     -24.271  39.920  -4.318  1.00 10.00           N  
ATOM    295  CA  PRO A 748     -25.402  40.542  -3.637  1.00 10.00           C  
ATOM    296  C   PRO A 748     -25.304  40.545  -2.112  1.00 10.00           C  
ATOM    297  O   PRO A 748     -25.528  41.575  -1.479  1.00 10.00           O  
ATOM    298  CB  PRO A 748     -26.639  39.788  -4.127  1.00 10.00           C  
ATOM    299  CG  PRO A 748     -26.253  39.436  -5.562  1.00 10.00           C  
ATOM    300  CD  PRO A 748     -24.757  39.143  -5.453  1.00 10.00           C  
ATOM    301  HA  PRO A 748     -25.462  41.575  -3.986  1.00 10.00           H  
ATOM    302  HB2 PRO A 748     -26.775  38.868  -3.556  1.00 10.00           H  
ATOM    303  HB3 PRO A 748     -27.541  40.400  -4.077  1.00 10.00           H  
ATOM    304  HG2 PRO A 748     -26.818  38.588  -5.951  1.00 10.00           H  
ATOM    305  HG3 PRO A 748     -26.404  40.311  -6.197  1.00 10.00           H  
ATOM    306  HD2 PRO A 748     -24.605  38.081  -5.253  1.00 10.00           H  
ATOM    307  HD3 PRO A 748     -24.281  39.419  -6.394  1.00 10.00           H  
ATOM    308  N   SER A 749     -24.952  39.402  -1.519  1.00 10.00           N  
ATOM    309  CA  SER A 749     -24.838  39.190  -0.083  1.00 10.00           C  
ATOM    310  C   SER A 749     -23.967  40.220   0.645  1.00 10.00           C  
ATOM    311  O   SER A 749     -24.049  40.331   1.864  1.00 10.00           O  
ATOM    312  CB  SER A 749     -24.283  37.782   0.135  1.00 10.00           C  
ATOM    313  OG  SER A 749     -24.734  36.929  -0.905  1.00 10.00           O  
ATOM    314  H   SER A 749     -24.821  38.563  -2.070  1.00 10.00           H  
ATOM    315  HA  SER A 749     -25.844  39.233   0.337  1.00 10.00           H  
ATOM    316  HB2 SER A 749     -23.193  37.814   0.138  1.00 10.00           H  
ATOM    317  HB3 SER A 749     -24.613  37.417   1.104  1.00 10.00           H  
ATOM    318  HG  SER A 749     -23.990  36.378  -1.190  1.00 10.00           H  
ATOM    319  N   ALA A 750     -23.130  40.968  -0.082  1.00 10.00           N  
ATOM    320  CA  ALA A 750     -22.403  42.109   0.452  1.00 10.00           C  
ATOM    321  C   ALA A 750     -23.326  43.157   1.088  1.00 10.00           C  
ATOM    322  O   ALA A 750     -22.902  43.841   2.019  1.00 10.00           O  
ATOM    323  CB  ALA A 750     -21.599  42.747  -0.680  1.00 10.00           C  
ATOM    324  H   ALA A 750     -23.076  40.816  -1.087  1.00 10.00           H  
ATOM    325  HA  ALA A 750     -21.703  41.758   1.210  1.00 10.00           H  
ATOM    326  HB1 ALA A 750     -21.099  43.646  -0.324  1.00 10.00           H  
ATOM    327  HB2 ALA A 750     -20.849  42.038  -1.019  1.00 10.00           H  
ATOM    328  HB3 ALA A 750     -22.251  43.015  -1.512  1.00 10.00           H  
ATOM    329  N   TRP A 751     -24.561  43.294   0.585  1.00 10.00           N  
ATOM    330  CA  TRP A 751     -25.482  44.377   0.922  1.00 10.00           C  
ATOM    331  C   TRP A 751     -25.474  44.857   2.385  1.00 10.00           C  
ATOM    332  O   TRP A 751     -25.373  46.066   2.594  1.00 10.00           O  
ATOM    333  CB  TRP A 751     -26.894  44.154   0.347  1.00 10.00           C  
ATOM    334  CG  TRP A 751     -27.808  43.178   1.029  1.00 10.00           C  
ATOM    335  CD1 TRP A 751     -28.057  41.913   0.621  1.00 10.00           C  
ATOM    336  CD2 TRP A 751     -28.624  43.374   2.226  1.00 10.00           C  
ATOM    337  NE1 TRP A 751     -28.937  41.306   1.490  1.00 10.00           N  
ATOM    338  CE2 TRP A 751     -29.319  42.158   2.505  1.00 10.00           C  
ATOM    339  CE3 TRP A 751     -28.839  44.448   3.117  1.00 10.00           C  
ATOM    340  CZ2 TRP A 751     -30.165  42.010   3.614  1.00 10.00           C  
ATOM    341  CZ3 TRP A 751     -29.676  44.309   4.240  1.00 10.00           C  
ATOM    342  CH2 TRP A 751     -30.335  43.092   4.493  1.00 10.00           C  
ATOM    343  H   TRP A 751     -24.834  42.677  -0.176  1.00 10.00           H  
ATOM    344  HA  TRP A 751     -25.098  45.221   0.347  1.00 10.00           H  
ATOM    345  HB2 TRP A 751     -27.404  45.119   0.367  1.00 10.00           H  
ATOM    346  HB3 TRP A 751     -26.800  43.867  -0.702  1.00 10.00           H  
ATOM    347  HD1 TRP A 751     -27.633  41.437  -0.248  1.00 10.00           H  
ATOM    348  HE1 TRP A 751     -29.236  40.348   1.380  1.00 10.00           H  
ATOM    349  HE3 TRP A 751     -28.345  45.392   2.939  1.00 10.00           H  
ATOM    350  HZ2 TRP A 751     -30.670  41.074   3.796  1.00 10.00           H  
ATOM    351  HZ3 TRP A 751     -29.814  45.143   4.912  1.00 10.00           H  
ATOM    352  HH2 TRP A 751     -30.974  42.992   5.358  1.00 10.00           H  
ATOM    353  N   PRO A 752     -25.575  43.994   3.413  1.00 10.00           N  
ATOM    354  CA  PRO A 752     -25.671  44.467   4.785  1.00 10.00           C  
ATOM    355  C   PRO A 752     -24.357  45.080   5.279  1.00 10.00           C  
ATOM    356  O   PRO A 752     -24.368  45.887   6.204  1.00 10.00           O  
ATOM    357  CB  PRO A 752     -26.042  43.247   5.640  1.00 10.00           C  
ATOM    358  CG  PRO A 752     -26.330  42.121   4.649  1.00 10.00           C  
ATOM    359  CD  PRO A 752     -25.566  42.541   3.398  1.00 10.00           C  
ATOM    360  HA  PRO A 752     -26.469  45.208   4.860  1.00 10.00           H  
ATOM    361  HB2 PRO A 752     -25.201  42.960   6.272  1.00 10.00           H  
ATOM    362  HB3 PRO A 752     -26.912  43.456   6.263  1.00 10.00           H  
ATOM    363  HG2 PRO A 752     -25.999  41.152   5.026  1.00 10.00           H  
ATOM    364  HG3 PRO A 752     -27.397  42.087   4.443  1.00 10.00           H  
ATOM    365  HD2 PRO A 752     -24.536  42.206   3.503  1.00 10.00           H  
ATOM    366  HD3 PRO A 752     -26.000  42.090   2.510  1.00 10.00           H  
ATOM    367  N   PHE A 753     -23.224  44.679   4.693  1.00 10.00           N  
ATOM    368  CA  PHE A 753     -21.896  45.001   5.198  1.00 10.00           C  
ATOM    369  C   PHE A 753     -21.221  46.123   4.412  1.00 10.00           C  
ATOM    370  O   PHE A 753     -20.023  46.336   4.584  1.00 10.00           O  
ATOM    371  CB  PHE A 753     -21.034  43.730   5.144  1.00 10.00           C  
ATOM    372  CG  PHE A 753     -21.755  42.462   5.567  1.00 10.00           C  
ATOM    373  CD1 PHE A 753     -22.342  42.377   6.843  1.00 10.00           C  
ATOM    374  CD2 PHE A 753     -21.995  41.444   4.625  1.00 10.00           C  
ATOM    375  CE1 PHE A 753     -23.182  41.297   7.163  1.00 10.00           C  
ATOM    376  CE2 PHE A 753     -22.792  40.337   4.963  1.00 10.00           C  
ATOM    377  CZ  PHE A 753     -23.398  40.269   6.228  1.00 10.00           C  
ATOM    378  H   PHE A 753     -23.268  44.073   3.879  1.00 10.00           H  
ATOM    379  HA  PHE A 753     -21.961  45.318   6.240  1.00 10.00           H  
ATOM    380  HB2 PHE A 753     -20.678  43.610   4.121  1.00 10.00           H  
ATOM    381  HB3 PHE A 753     -20.160  43.876   5.781  1.00 10.00           H  
ATOM    382  HD1 PHE A 753     -22.195  43.171   7.563  1.00 10.00           H  
ATOM    383  HD2 PHE A 753     -21.597  41.519   3.624  1.00 10.00           H  
ATOM    384  HE1 PHE A 753     -23.690  41.285   8.117  1.00 10.00           H  
ATOM    385  HE2 PHE A 753     -22.969  39.565   4.228  1.00 10.00           H  
ATOM    386  HZ  PHE A 753     -24.053  39.444   6.464  1.00 10.00           H  
ATOM    387  N   MET A 754     -21.948  46.811   3.525  1.00 10.00           N  
ATOM    388  CA  MET A 754     -21.361  47.811   2.644  1.00 10.00           C  
ATOM    389  C   MET A 754     -20.734  48.954   3.449  1.00 10.00           C  
ATOM    390  O   MET A 754     -19.512  49.111   3.482  1.00 10.00           O  
ATOM    391  CB  MET A 754     -22.415  48.325   1.653  1.00 10.00           C  
ATOM    392  CG  MET A 754     -22.828  47.249   0.639  1.00 10.00           C  
ATOM    393  SD  MET A 754     -21.566  46.659  -0.522  1.00 10.00           S  
ATOM    394  CE  MET A 754     -21.190  48.166  -1.445  1.00 10.00           C  
ATOM    395  H   MET A 754     -22.929  46.586   3.424  1.00 10.00           H  
ATOM    396  HA  MET A 754     -20.567  47.339   2.073  1.00 10.00           H  
ATOM    397  HB2 MET A 754     -23.306  48.642   2.199  1.00 10.00           H  
ATOM    398  HB3 MET A 754     -22.021  49.186   1.116  1.00 10.00           H  
ATOM    399  HG2 MET A 754     -23.178  46.376   1.184  1.00 10.00           H  
ATOM    400  HG3 MET A 754     -23.659  47.633   0.048  1.00 10.00           H  
ATOM    401  HE1 MET A 754     -20.482  47.923  -2.236  1.00 10.00           H  
ATOM    402  HE2 MET A 754     -22.107  48.555  -1.886  1.00 10.00           H  
ATOM    403  HE3 MET A 754     -20.747  48.907  -0.783  1.00 10.00           H  
ATOM    404  N   GLU A 755     -21.587  49.769   4.069  1.00 10.00           N  
ATOM    405  CA  GLU A 755     -21.187  50.959   4.806  1.00 10.00           C  
ATOM    406  C   GLU A 755     -20.851  50.595   6.259  1.00 10.00           C  
ATOM    407  O   GLU A 755     -21.262  49.534   6.728  1.00 10.00           O  
ATOM    408  CB  GLU A 755     -22.335  51.978   4.759  1.00 10.00           C  
ATOM    409  CG  GLU A 755     -22.672  52.401   3.323  1.00 10.00           C  
ATOM    410  CD  GLU A 755     -23.741  53.487   3.310  1.00 10.00           C  
ATOM    411  OE1 GLU A 755     -23.357  54.661   3.504  1.00 10.00           O  
ATOM    412  OE2 GLU A 755     -24.922  53.125   3.121  1.00 10.00           O  
ATOM    413  H   GLU A 755     -22.566  49.526   4.054  1.00 10.00           H  
ATOM    414  HA  GLU A 755     -20.317  51.389   4.312  1.00 10.00           H  
ATOM    415  HB2 GLU A 755     -23.223  51.551   5.230  1.00 10.00           H  
ATOM    416  HB3 GLU A 755     -22.055  52.867   5.325  1.00 10.00           H  
ATOM    417  HG2 GLU A 755     -21.775  52.788   2.837  1.00 10.00           H  
ATOM    418  HG3 GLU A 755     -23.035  51.545   2.752  1.00 10.00           H  
ATOM    419  N   PRO A 756     -20.127  51.454   6.995  1.00 10.00           N  
ATOM    420  CA  PRO A 756     -19.953  51.289   8.428  1.00 10.00           C  
ATOM    421  C   PRO A 756     -21.312  51.308   9.123  1.00 10.00           C  
ATOM    422  O   PRO A 756     -22.253  51.945   8.650  1.00 10.00           O  
ATOM    423  CB  PRO A 756     -19.076  52.461   8.888  1.00 10.00           C  
ATOM    424  CG  PRO A 756     -18.384  52.926   7.608  1.00 10.00           C  
ATOM    425  CD  PRO A 756     -19.439  52.647   6.540  1.00 10.00           C  
ATOM    426  HA  PRO A 756     -19.456  50.343   8.628  1.00 10.00           H  
ATOM    427  HB2 PRO A 756     -19.706  53.271   9.261  1.00 10.00           H  
ATOM    428  HB3 PRO A 756     -18.362  52.160   9.655  1.00 10.00           H  
ATOM    429  HG2 PRO A 756     -18.101  53.978   7.647  1.00 10.00           H  
ATOM    430  HG3 PRO A 756     -17.503  52.309   7.423  1.00 10.00           H  
ATOM    431  HD2 PRO A 756     -20.141  53.479   6.495  1.00 10.00           H  
ATOM    432  HD3 PRO A 756     -18.954  52.510   5.578  1.00 10.00           H  
ATOM    433  N   VAL A 757     -21.413  50.623  10.262  1.00 10.00           N  
ATOM    434  CA  VAL A 757     -22.634  50.634  11.047  1.00 10.00           C  
ATOM    435  C   VAL A 757     -22.893  52.070  11.514  1.00 10.00           C  
ATOM    436  O   VAL A 757     -21.963  52.780  11.901  1.00 10.00           O  
ATOM    437  CB  VAL A 757     -22.515  49.635  12.208  1.00 10.00           C  
ATOM    438  CG1 VAL A 757     -23.749  49.694  13.112  1.00 10.00           C  
ATOM    439  CG2 VAL A 757     -22.361  48.209  11.660  1.00 10.00           C  
ATOM    440  H   VAL A 757     -20.600  50.158  10.635  1.00 10.00           H  
ATOM    441  HA  VAL A 757     -23.456  50.319  10.402  1.00 10.00           H  
ATOM    442  HB  VAL A 757     -21.638  49.881  12.808  1.00 10.00           H  
ATOM    443 HG11 VAL A 757     -23.703  48.900  13.856  1.00 10.00           H  
ATOM    444 HG12 VAL A 757     -23.785  50.650  13.634  1.00 10.00           H  
ATOM    445 HG13 VAL A 757     -24.656  49.565  12.519  1.00 10.00           H  
ATOM    446 HG21 VAL A 757     -21.431  48.111  11.101  1.00 10.00           H  
ATOM    447 HG22 VAL A 757     -22.346  47.492  12.481  1.00 10.00           H  
ATOM    448 HG23 VAL A 757     -23.198  47.968  11.004  1.00 10.00           H  
ATOM    449  N   LYS A 758     -24.151  52.509  11.471  1.00 10.00           N  
ATOM    450  CA  LYS A 758     -24.487  53.895  11.735  1.00 10.00           C  
ATOM    451  C   LYS A 758     -24.445  54.128  13.243  1.00 10.00           C  
ATOM    452  O   LYS A 758     -25.372  53.755  13.958  1.00 10.00           O  
ATOM    453  CB  LYS A 758     -25.862  54.228  11.141  1.00 10.00           C  
ATOM    454  CG  LYS A 758     -25.841  54.115   9.608  1.00 10.00           C  
ATOM    455  CD  LYS A 758     -27.219  54.372   8.980  1.00 10.00           C  
ATOM    456  CE  LYS A 758     -27.757  55.792   9.200  1.00 10.00           C  
ATOM    457  NZ  LYS A 758     -26.859  56.817   8.638  1.00 10.00           N  
ATOM    458  H   LYS A 758     -24.885  51.884  11.174  1.00 10.00           H  
ATOM    459  HA  LYS A 758     -23.757  54.547  11.249  1.00 10.00           H  
ATOM    460  HB2 LYS A 758     -26.615  53.551  11.548  1.00 10.00           H  
ATOM    461  HB3 LYS A 758     -26.110  55.248  11.433  1.00 10.00           H  
ATOM    462  HG2 LYS A 758     -25.105  54.809   9.198  1.00 10.00           H  
ATOM    463  HG3 LYS A 758     -25.534  53.108   9.322  1.00 10.00           H  
ATOM    464  HD2 LYS A 758     -27.146  54.191   7.906  1.00 10.00           H  
ATOM    465  HD3 LYS A 758     -27.934  53.655   9.387  1.00 10.00           H  
ATOM    466  HE2 LYS A 758     -28.727  55.875   8.708  1.00 10.00           H  
ATOM    467  HE3 LYS A 758     -27.903  55.984  10.263  1.00 10.00           H  
ATOM    468  HZ1 LYS A 758     -26.728  56.646   7.650  1.00 10.00           H  
ATOM    469  HZ2 LYS A 758     -27.268  57.731   8.765  1.00 10.00           H  
ATOM    470  HZ3 LYS A 758     -25.966  56.781   9.105  1.00 10.00           H  
ATOM    471  N   LYS A 759     -23.361  54.752  13.714  1.00 10.00           N  
ATOM    472  CA  LYS A 759     -23.121  55.087  15.114  1.00 10.00           C  
ATOM    473  C   LYS A 759     -24.327  55.768  15.770  1.00 10.00           C  
ATOM    474  O   LYS A 759     -24.572  55.581  16.956  1.00 10.00           O  
ATOM    475  CB  LYS A 759     -21.889  55.996  15.218  1.00 10.00           C  
ATOM    476  CG  LYS A 759     -20.592  55.255  14.876  1.00 10.00           C  
ATOM    477  CD  LYS A 759     -19.402  56.221  14.923  1.00 10.00           C  
ATOM    478  CE  LYS A 759     -18.086  55.524  14.557  1.00 10.00           C  
ATOM    479  NZ  LYS A 759     -17.713  54.496  15.544  1.00 10.00           N  
ATOM    480  H   LYS A 759     -22.625  54.953  13.052  1.00 10.00           H  
ATOM    481  HA  LYS A 759     -22.924  54.163  15.660  1.00 10.00           H  
ATOM    482  HB2 LYS A 759     -22.015  56.853  14.554  1.00 10.00           H  
ATOM    483  HB3 LYS A 759     -21.810  56.363  16.244  1.00 10.00           H  
ATOM    484  HG2 LYS A 759     -20.451  54.465  15.612  1.00 10.00           H  
ATOM    485  HG3 LYS A 759     -20.656  54.811  13.881  1.00 10.00           H  
ATOM    486  HD2 LYS A 759     -19.575  57.029  14.209  1.00 10.00           H  
ATOM    487  HD3 LYS A 759     -19.321  56.657  15.921  1.00 10.00           H  
ATOM    488  HE2 LYS A 759     -18.174  55.061  13.573  1.00 10.00           H  
ATOM    489  HE3 LYS A 759     -17.289  56.269  14.520  1.00 10.00           H  
ATOM    490  HZ1 LYS A 759     -18.426  53.782  15.579  1.00 10.00           H  
ATOM    491  HZ2 LYS A 759     -16.836  54.072  15.278  1.00 10.00           H  
ATOM    492  HZ3 LYS A 759     -17.616  54.916  16.459  1.00 10.00           H  
ATOM    493  N   SER A 760     -25.075  56.569  15.009  1.00 10.00           N  
ATOM    494  CA  SER A 760     -26.279  57.231  15.475  1.00 10.00           C  
ATOM    495  C   SER A 760     -27.353  56.221  15.898  1.00 10.00           C  
ATOM    496  O   SER A 760     -28.097  56.475  16.843  1.00 10.00           O  
ATOM    497  CB  SER A 760     -26.778  58.123  14.335  1.00 10.00           C  
ATOM    498  OG  SER A 760     -26.521  57.490  13.089  1.00 10.00           O  
ATOM    499  H   SER A 760     -24.889  56.663  14.019  1.00 10.00           H  
ATOM    500  HA  SER A 760     -26.044  57.858  16.337  1.00 10.00           H  
ATOM    501  HB2 SER A 760     -27.844  58.326  14.459  1.00 10.00           H  
ATOM    502  HB3 SER A 760     -26.235  59.068  14.366  1.00 10.00           H  
ATOM    503  HG  SER A 760     -26.862  58.048  12.383  1.00 10.00           H  
ATOM    504  N   GLU A 761     -27.456  55.105  15.173  1.00 10.00           N  
ATOM    505  CA  GLU A 761     -28.496  54.104  15.351  1.00 10.00           C  
ATOM    506  C   GLU A 761     -28.009  52.993  16.280  1.00 10.00           C  
ATOM    507  O   GLU A 761     -28.684  52.650  17.246  1.00 10.00           O  
ATOM    508  CB  GLU A 761     -28.892  53.531  13.984  1.00 10.00           C  
ATOM    509  CG  GLU A 761     -29.374  54.628  13.021  1.00 10.00           C  
ATOM    510  CD  GLU A 761     -29.818  54.076  11.668  1.00 10.00           C  
ATOM    511  OE1 GLU A 761     -29.558  52.880  11.415  1.00 10.00           O  
ATOM    512  OE2 GLU A 761     -30.397  54.873  10.899  1.00 10.00           O  
ATOM    513  H   GLU A 761     -26.757  54.934  14.460  1.00 10.00           H  
ATOM    514  HA  GLU A 761     -29.383  54.562  15.796  1.00 10.00           H  
ATOM    515  HB2 GLU A 761     -28.040  53.013  13.541  1.00 10.00           H  
ATOM    516  HB3 GLU A 761     -29.696  52.807  14.132  1.00 10.00           H  
ATOM    517  HG2 GLU A 761     -30.216  55.155  13.473  1.00 10.00           H  
ATOM    518  HG3 GLU A 761     -28.572  55.343  12.838  1.00 10.00           H  
ATOM    519  N   ALA A 762     -26.847  52.412  15.961  1.00 10.00           N  
ATOM    520  CA  ALA A 762     -26.298  51.244  16.638  1.00 10.00           C  
ATOM    521  C   ALA A 762     -24.871  51.520  17.132  1.00 10.00           C  
ATOM    522  O   ALA A 762     -23.931  50.852  16.697  1.00 10.00           O  
ATOM    523  CB  ALA A 762     -26.345  50.051  15.676  1.00 10.00           C  
ATOM    524  H   ALA A 762     -26.327  52.795  15.178  1.00 10.00           H  
ATOM    525  HA  ALA A 762     -26.910  50.970  17.495  1.00 10.00           H  
ATOM    526  HB1 ALA A 762     -25.880  49.180  16.136  1.00 10.00           H  
ATOM    527  HB2 ALA A 762     -27.382  49.812  15.436  1.00 10.00           H  
ATOM    528  HB3 ALA A 762     -25.816  50.295  14.757  1.00 10.00           H  
ATOM    529  N   PRO A 763     -24.681  52.468  18.066  1.00 10.00           N  
ATOM    530  CA  PRO A 763     -23.364  52.771  18.618  1.00 10.00           C  
ATOM    531  C   PRO A 763     -22.767  51.520  19.261  1.00 10.00           C  
ATOM    532  O   PRO A 763     -21.592  51.204  19.082  1.00 10.00           O  
ATOM    533  CB  PRO A 763     -23.591  53.881  19.648  1.00 10.00           C  
ATOM    534  CG  PRO A 763     -25.066  53.755  20.034  1.00 10.00           C  
ATOM    535  CD  PRO A 763     -25.726  53.196  18.773  1.00 10.00           C  
ATOM    536  HA  PRO A 763     -22.693  53.127  17.835  1.00 10.00           H  
ATOM    537  HB2 PRO A 763     -22.937  53.778  20.516  1.00 10.00           H  
ATOM    538  HB3 PRO A 763     -23.430  54.849  19.174  1.00 10.00           H  
ATOM    539  HG2 PRO A 763     -25.171  53.042  20.853  1.00 10.00           H  
ATOM    540  HG3 PRO A 763     -25.496  54.715  20.326  1.00 10.00           H  
ATOM    541  HD2 PRO A 763     -26.565  52.561  19.058  1.00 10.00           H  
ATOM    542  HD3 PRO A 763     -26.088  54.018  18.157  1.00 10.00           H  
ATOM    543  N   ASP A 764     -23.619  50.793  19.986  1.00 10.00           N  
ATOM    544  CA  ASP A 764     -23.325  49.536  20.653  1.00 10.00           C  
ATOM    545  C   ASP A 764     -22.546  48.549  19.781  1.00 10.00           C  
ATOM    546  O   ASP A 764     -21.754  47.787  20.331  1.00 10.00           O  
ATOM    547  CB  ASP A 764     -24.619  48.907  21.180  1.00 10.00           C  
ATOM    548  CG  ASP A 764     -25.599  48.593  20.056  1.00 10.00           C  
ATOM    549  OD1 ASP A 764     -26.133  49.567  19.483  1.00 10.00           O  
ATOM    550  OD2 ASP A 764     -25.780  47.391  19.769  1.00 10.00           O  
ATOM    551  H   ASP A 764     -24.569  51.129  20.037  1.00 10.00           H  
ATOM    552  HA  ASP A 764     -22.707  49.770  21.520  1.00 10.00           H  
ATOM    553  HB2 ASP A 764     -24.369  47.987  21.711  1.00 10.00           H  
ATOM    554  HB3 ASP A 764     -25.096  49.588  21.885  1.00 10.00           H  
ATOM    555  N   TYR A 765     -22.718  48.561  18.450  1.00 10.00           N  
ATOM    556  CA  TYR A 765     -21.876  47.746  17.574  1.00 10.00           C  
ATOM    557  C   TYR A 765     -20.403  47.957  17.911  1.00 10.00           C  
ATOM    558  O   TYR A 765     -19.678  46.996  18.126  1.00 10.00           O  
ATOM    559  CB  TYR A 765     -22.133  48.057  16.095  1.00 10.00           C  
ATOM    560  CG  TYR A 765     -21.170  47.374  15.127  1.00 10.00           C  
ATOM    561  CD1 TYR A 765     -21.260  45.992  14.885  1.00 10.00           C  
ATOM    562  CD2 TYR A 765     -20.177  48.121  14.463  1.00 10.00           C  
ATOM    563  CE1 TYR A 765     -20.401  45.375  13.953  1.00 10.00           C  
ATOM    564  CE2 TYR A 765     -19.350  47.516  13.498  1.00 10.00           C  
ATOM    565  CZ  TYR A 765     -19.465  46.140  13.231  1.00 10.00           C  
ATOM    566  OH  TYR A 765     -18.670  45.546  12.286  1.00 10.00           O  
ATOM    567  H   TYR A 765     -23.324  49.257  18.028  1.00 10.00           H  
ATOM    568  HA  TYR A 765     -22.108  46.695  17.748  1.00 10.00           H  
ATOM    569  HB2 TYR A 765     -23.151  47.748  15.853  1.00 10.00           H  
ATOM    570  HB3 TYR A 765     -22.066  49.136  15.949  1.00 10.00           H  
ATOM    571  HD1 TYR A 765     -21.996  45.403  15.408  1.00 10.00           H  
ATOM    572  HD2 TYR A 765     -20.059  49.169  14.677  1.00 10.00           H  
ATOM    573  HE1 TYR A 765     -20.504  44.319  13.762  1.00 10.00           H  
ATOM    574  HE2 TYR A 765     -18.627  48.119  12.972  1.00 10.00           H  
ATOM    575  HH  TYR A 765     -18.411  46.127  11.558  1.00 10.00           H  
ATOM    576  N   TYR A 766     -19.969  49.213  18.003  1.00 10.00           N  
ATOM    577  CA  TYR A 766     -18.566  49.541  18.198  1.00 10.00           C  
ATOM    578  C   TYR A 766     -18.145  49.273  19.645  1.00 10.00           C  
ATOM    579  O   TYR A 766     -16.975  49.000  19.901  1.00 10.00           O  
ATOM    580  CB  TYR A 766     -18.334  51.007  17.814  1.00 10.00           C  
ATOM    581  CG  TYR A 766     -18.614  51.301  16.353  1.00 10.00           C  
ATOM    582  CD1 TYR A 766     -19.903  51.684  15.935  1.00 10.00           C  
ATOM    583  CD2 TYR A 766     -17.595  51.130  15.399  1.00 10.00           C  
ATOM    584  CE1 TYR A 766     -20.169  51.897  14.572  1.00 10.00           C  
ATOM    585  CE2 TYR A 766     -17.863  51.339  14.035  1.00 10.00           C  
ATOM    586  CZ  TYR A 766     -19.149  51.718  13.621  1.00 10.00           C  
ATOM    587  OH  TYR A 766     -19.396  51.896  12.293  1.00 10.00           O  
ATOM    588  H   TYR A 766     -20.643  49.971  17.978  1.00 10.00           H  
ATOM    589  HA  TYR A 766     -17.952  48.916  17.546  1.00 10.00           H  
ATOM    590  HB2 TYR A 766     -18.959  51.646  18.440  1.00 10.00           H  
ATOM    591  HB3 TYR A 766     -17.294  51.259  18.027  1.00 10.00           H  
ATOM    592  HD1 TYR A 766     -20.697  51.808  16.657  1.00 10.00           H  
ATOM    593  HD2 TYR A 766     -16.603  50.841  15.715  1.00 10.00           H  
ATOM    594  HE1 TYR A 766     -21.168  52.162  14.264  1.00 10.00           H  
ATOM    595  HE2 TYR A 766     -17.079  51.214  13.302  1.00 10.00           H  
ATOM    596  HH  TYR A 766     -20.274  52.260  12.124  1.00 10.00           H  
ATOM    597  N   GLU A 767     -19.092  49.332  20.587  1.00 10.00           N  
ATOM    598  CA  GLU A 767     -18.808  49.121  22.000  1.00 10.00           C  
ATOM    599  C   GLU A 767     -18.692  47.628  22.320  1.00 10.00           C  
ATOM    600  O   GLU A 767     -17.916  47.247  23.192  1.00 10.00           O  
ATOM    601  CB  GLU A 767     -19.897  49.777  22.861  1.00 10.00           C  
ATOM    602  CG  GLU A 767     -20.208  51.225  22.449  1.00 10.00           C  
ATOM    603  CD  GLU A 767     -18.954  52.090  22.362  1.00 10.00           C  
ATOM    604  OE1 GLU A 767     -18.385  52.370  23.438  1.00 10.00           O  
ATOM    605  OE2 GLU A 767     -18.589  52.451  21.222  1.00 10.00           O  
ATOM    606  H   GLU A 767     -20.037  49.551  20.304  1.00 10.00           H  
ATOM    607  HA  GLU A 767     -17.852  49.587  22.245  1.00 10.00           H  
ATOM    608  HB2 GLU A 767     -20.810  49.184  22.803  1.00 10.00           H  
ATOM    609  HB3 GLU A 767     -19.555  49.770  23.898  1.00 10.00           H  
ATOM    610  HG2 GLU A 767     -20.712  51.238  21.485  1.00 10.00           H  
ATOM    611  HG3 GLU A 767     -20.883  51.662  23.184  1.00 10.00           H  
ATOM    612  N   VAL A 768     -19.484  46.792  21.645  1.00 10.00           N  
ATOM    613  CA  VAL A 768     -19.442  45.343  21.794  1.00 10.00           C  
ATOM    614  C   VAL A 768     -18.375  44.792  20.848  1.00 10.00           C  
ATOM    615  O   VAL A 768     -17.371  44.223  21.276  1.00 10.00           O  
ATOM    616  CB  VAL A 768     -20.839  44.758  21.509  1.00 10.00           C  
ATOM    617  CG1 VAL A 768     -20.832  43.224  21.528  1.00 10.00           C  
ATOM    618  CG2 VAL A 768     -21.849  45.254  22.554  1.00 10.00           C  
ATOM    619  H   VAL A 768     -20.141  47.183  20.978  1.00 10.00           H  
ATOM    620  HA  VAL A 768     -19.163  45.079  22.815  1.00 10.00           H  
ATOM    621  HB  VAL A 768     -21.178  45.083  20.522  1.00 10.00           H  
ATOM    622 HG11 VAL A 768     -21.846  42.850  21.375  1.00 10.00           H  
ATOM    623 HG12 VAL A 768     -20.206  42.831  20.728  1.00 10.00           H  
ATOM    624 HG13 VAL A 768     -20.459  42.862  22.486  1.00 10.00           H  
ATOM    625 HG21 VAL A 768     -22.836  44.850  22.330  1.00 10.00           H  
ATOM    626 HG22 VAL A 768     -21.546  44.924  23.549  1.00 10.00           H  
ATOM    627 HG23 VAL A 768     -21.911  46.341  22.546  1.00 10.00           H  
ATOM    628  N   ILE A 769     -18.587  44.961  19.544  1.00 10.00           N  
ATOM    629  CA  ILE A 769     -17.666  44.506  18.521  1.00 10.00           C  
ATOM    630  C   ILE A 769     -16.559  45.554  18.408  1.00 10.00           C  
ATOM    631  O   ILE A 769     -16.515  46.329  17.453  1.00 10.00           O  
ATOM    632  CB  ILE A 769     -18.412  44.275  17.191  1.00 10.00           C  
ATOM    633  CG1 ILE A 769     -19.707  43.457  17.345  1.00 10.00           C  
ATOM    634  CG2 ILE A 769     -17.507  43.618  16.147  1.00 10.00           C  
ATOM    635  CD1 ILE A 769     -19.500  42.025  17.849  1.00 10.00           C  
ATOM    636  H   ILE A 769     -19.342  45.563  19.235  1.00 10.00           H  
ATOM    637  HA  ILE A 769     -17.217  43.559  18.824  1.00 10.00           H  
ATOM    638  HB  ILE A 769     -18.707  45.235  16.771  1.00 10.00           H  
ATOM    639 HG12 ILE A 769     -20.394  43.973  18.015  1.00 10.00           H  
ATOM    640 HG13 ILE A 769     -20.182  43.408  16.366  1.00 10.00           H  
ATOM    641 HG21 ILE A 769     -18.108  43.441  15.258  1.00 10.00           H  
ATOM    642 HG22 ILE A 769     -16.678  44.275  15.882  1.00 10.00           H  
ATOM    643 HG23 ILE A 769     -17.109  42.670  16.507  1.00 10.00           H  
ATOM    644 HD11 ILE A 769     -18.981  42.024  18.807  1.00 10.00           H  
ATOM    645 HD12 ILE A 769     -20.473  41.553  17.977  1.00 10.00           H  
ATOM    646 HD13 ILE A 769     -18.927  41.444  17.127  1.00 10.00           H  
ATOM    647  N   ARG A 770     -15.623  45.549  19.361  1.00 10.00           N  
ATOM    648  CA  ARG A 770     -14.470  46.453  19.379  1.00 10.00           C  
ATOM    649  C   ARG A 770     -13.414  46.052  18.334  1.00 10.00           C  
ATOM    650  O   ARG A 770     -12.214  46.129  18.588  1.00 10.00           O  
ATOM    651  CB  ARG A 770     -13.864  46.491  20.790  1.00 10.00           C  
ATOM    652  CG  ARG A 770     -14.901  46.925  21.831  1.00 10.00           C  
ATOM    653  CD  ARG A 770     -14.270  47.137  23.208  1.00 10.00           C  
ATOM    654  NE  ARG A 770     -15.318  47.483  24.172  1.00 10.00           N  
ATOM    655  CZ  ARG A 770     -15.134  47.937  25.416  1.00 10.00           C  
ATOM    656  NH1 ARG A 770     -13.900  48.083  25.909  1.00 10.00           N  
ATOM    657  NH2 ARG A 770     -16.206  48.241  26.153  1.00 10.00           N  
ATOM    658  H   ARG A 770     -15.752  44.907  20.135  1.00 10.00           H  
ATOM    659  HA  ARG A 770     -14.811  47.460  19.134  1.00 10.00           H  
ATOM    660  HB2 ARG A 770     -13.473  45.505  21.050  1.00 10.00           H  
ATOM    661  HB3 ARG A 770     -13.041  47.207  20.798  1.00 10.00           H  
ATOM    662  HG2 ARG A 770     -15.362  47.860  21.511  1.00 10.00           H  
ATOM    663  HG3 ARG A 770     -15.678  46.164  21.919  1.00 10.00           H  
ATOM    664  HD2 ARG A 770     -13.772  46.220  23.527  1.00 10.00           H  
ATOM    665  HD3 ARG A 770     -13.541  47.948  23.139  1.00 10.00           H  
ATOM    666  HE  ARG A 770     -16.273  47.372  23.840  1.00 10.00           H  
ATOM    667 HH11 ARG A 770     -13.110  47.836  25.333  1.00 10.00           H  
ATOM    668 HH12 ARG A 770     -13.750  48.430  26.843  1.00 10.00           H  
ATOM    669 HH21 ARG A 770     -17.124  48.115  25.748  1.00 10.00           H  
ATOM    670 HH22 ARG A 770     -16.117  48.591  27.095  1.00 10.00           H  
ATOM    671  N   PHE A 771     -13.869  45.636  17.149  1.00 10.00           N  
ATOM    672  CA  PHE A 771     -13.082  45.086  16.060  1.00 10.00           C  
ATOM    673  C   PHE A 771     -13.755  45.535  14.753  1.00 10.00           C  
ATOM    674  O   PHE A 771     -14.104  44.698  13.922  1.00 10.00           O  
ATOM    675  CB  PHE A 771     -13.061  43.546  16.198  1.00 10.00           C  
ATOM    676  CG  PHE A 771     -12.962  43.024  17.623  1.00 10.00           C  
ATOM    677  CD1 PHE A 771     -11.751  43.130  18.333  1.00 10.00           C  
ATOM    678  CD2 PHE A 771     -14.125  42.594  18.293  1.00 10.00           C  
ATOM    679  CE1 PHE A 771     -11.710  42.833  19.706  1.00 10.00           C  
ATOM    680  CE2 PHE A 771     -14.086  42.309  19.668  1.00 10.00           C  
ATOM    681  CZ  PHE A 771     -12.878  42.429  20.376  1.00 10.00           C  
ATOM    682  H   PHE A 771     -14.859  45.732  16.977  1.00 10.00           H  
ATOM    683  HA  PHE A 771     -12.061  45.467  16.100  1.00 10.00           H  
ATOM    684  HB2 PHE A 771     -13.972  43.130  15.765  1.00 10.00           H  
ATOM    685  HB3 PHE A 771     -12.222  43.153  15.626  1.00 10.00           H  
ATOM    686  HD1 PHE A 771     -10.863  43.497  17.839  1.00 10.00           H  
ATOM    687  HD2 PHE A 771     -15.057  42.497  17.757  1.00 10.00           H  
ATOM    688  HE1 PHE A 771     -10.781  42.935  20.250  1.00 10.00           H  
ATOM    689  HE2 PHE A 771     -14.986  42.001  20.182  1.00 10.00           H  
ATOM    690  HZ  PHE A 771     -12.848  42.214  21.435  1.00 10.00           H  
ATOM    691  N   PRO A 772     -13.999  46.843  14.569  1.00 10.00           N  
ATOM    692  CA  PRO A 772     -14.822  47.334  13.479  1.00 10.00           C  
ATOM    693  C   PRO A 772     -14.223  47.023  12.108  1.00 10.00           C  
ATOM    694  O   PRO A 772     -13.005  47.065  11.924  1.00 10.00           O  
ATOM    695  CB  PRO A 772     -14.967  48.840  13.714  1.00 10.00           C  
ATOM    696  CG  PRO A 772     -13.711  49.195  14.510  1.00 10.00           C  
ATOM    697  CD  PRO A 772     -13.525  47.955  15.382  1.00 10.00           C  
ATOM    698  HA  PRO A 772     -15.808  46.873  13.552  1.00 10.00           H  
ATOM    699  HB2 PRO A 772     -15.048  49.411  12.788  1.00 10.00           H  
ATOM    700  HB3 PRO A 772     -15.845  49.008  14.337  1.00 10.00           H  
ATOM    701  HG2 PRO A 772     -12.864  49.297  13.830  1.00 10.00           H  
ATOM    702  HG3 PRO A 772     -13.834  50.105  15.100  1.00 10.00           H  
ATOM    703  HD2 PRO A 772     -12.479  47.845  15.675  1.00 10.00           H  
ATOM    704  HD3 PRO A 772     -14.155  48.059  16.266  1.00 10.00           H  
ATOM    705  N   ILE A 773     -15.112  46.737  11.154  1.00 10.00           N  
ATOM    706  CA  ILE A 773     -14.848  46.547   9.738  1.00 10.00           C  
ATOM    707  C   ILE A 773     -16.213  46.540   9.036  1.00 10.00           C  
ATOM    708  O   ILE A 773     -17.245  46.430   9.707  1.00 10.00           O  
ATOM    709  CB  ILE A 773     -14.022  45.262   9.510  1.00 10.00           C  
ATOM    710  CG1 ILE A 773     -13.525  45.050   8.068  1.00 10.00           C  
ATOM    711  CG2 ILE A 773     -14.786  44.022   9.987  1.00 10.00           C  
ATOM    712  CD1 ILE A 773     -12.720  46.238   7.535  1.00 10.00           C  
ATOM    713  H   ILE A 773     -16.097  46.712  11.384  1.00 10.00           H  
ATOM    714  HA  ILE A 773     -14.288  47.415   9.393  1.00 10.00           H  
ATOM    715  HB  ILE A 773     -13.118  45.328  10.115  1.00 10.00           H  
ATOM    716 HG12 ILE A 773     -12.865  44.182   8.077  1.00 10.00           H  
ATOM    717 HG13 ILE A 773     -14.347  44.839   7.388  1.00 10.00           H  
ATOM    718 HG21 ILE A 773     -14.894  44.054  11.068  1.00 10.00           H  
ATOM    719 HG22 ILE A 773     -15.774  43.968   9.537  1.00 10.00           H  
ATOM    720 HG23 ILE A 773     -14.231  43.126   9.720  1.00 10.00           H  
ATOM    721 HD11 ILE A 773     -11.935  45.886   6.868  1.00 10.00           H  
ATOM    722 HD12 ILE A 773     -13.360  46.919   6.982  1.00 10.00           H  
ATOM    723 HD13 ILE A 773     -12.267  46.784   8.356  1.00 10.00           H  
ATOM    724  N   ASP A 774     -16.187  46.694   7.709  1.00 10.00           N  
ATOM    725  CA  ASP A 774     -17.280  46.794   6.747  1.00 10.00           C  
ATOM    726  C   ASP A 774     -16.588  47.027   5.397  1.00 10.00           C  
ATOM    727  O   ASP A 774     -15.389  47.306   5.380  1.00 10.00           O  
ATOM    728  CB  ASP A 774     -18.226  47.952   7.083  1.00 10.00           C  
ATOM    729  CG  ASP A 774     -17.475  49.274   7.108  1.00 10.00           C  
ATOM    730  OD1 ASP A 774     -17.321  49.867   6.018  1.00 10.00           O  
ATOM    731  OD2 ASP A 774     -17.021  49.649   8.212  1.00 10.00           O  
ATOM    732  H   ASP A 774     -15.281  46.785   7.269  1.00 10.00           H  
ATOM    733  HA  ASP A 774     -17.837  45.856   6.720  1.00 10.00           H  
ATOM    734  HB2 ASP A 774     -19.010  48.012   6.328  1.00 10.00           H  
ATOM    735  HB3 ASP A 774     -18.704  47.781   8.047  1.00 10.00           H  
ATOM    736  N   LEU A 775     -17.289  46.911   4.271  1.00 10.00           N  
ATOM    737  CA  LEU A 775     -16.637  46.909   2.964  1.00 10.00           C  
ATOM    738  C   LEU A 775     -16.088  48.286   2.578  1.00 10.00           C  
ATOM    739  O   LEU A 775     -15.018  48.372   1.973  1.00 10.00           O  
ATOM    740  CB  LEU A 775     -17.561  46.323   1.892  1.00 10.00           C  
ATOM    741  CG  LEU A 775     -17.991  44.876   2.201  1.00 10.00           C  
ATOM    742  CD1 LEU A 775     -19.058  44.437   1.198  1.00 10.00           C  
ATOM    743  CD2 LEU A 775     -16.815  43.892   2.143  1.00 10.00           C  
ATOM    744  H   LEU A 775     -18.291  46.755   4.320  1.00 10.00           H  
ATOM    745  HA  LEU A 775     -15.774  46.251   3.030  1.00 10.00           H  
ATOM    746  HB2 LEU A 775     -18.436  46.961   1.812  1.00 10.00           H  
ATOM    747  HB3 LEU A 775     -17.042  46.340   0.932  1.00 10.00           H  
ATOM    748  HG  LEU A 775     -18.435  44.815   3.193  1.00 10.00           H  
ATOM    749 HD11 LEU A 775     -19.938  45.066   1.314  1.00 10.00           H  
ATOM    750 HD12 LEU A 775     -18.679  44.523   0.179  1.00 10.00           H  
ATOM    751 HD13 LEU A 775     -19.344  43.403   1.392  1.00 10.00           H  
ATOM    752 HD21 LEU A 775     -16.264  44.016   1.210  1.00 10.00           H  
ATOM    753 HD22 LEU A 775     -16.147  44.057   2.986  1.00 10.00           H  
ATOM    754 HD23 LEU A 775     -17.186  42.869   2.207  1.00 10.00           H  
ATOM    755  N   LYS A 776     -16.762  49.380   2.941  1.00 10.00           N  
ATOM    756  CA  LYS A 776     -16.173  50.705   2.763  1.00 10.00           C  
ATOM    757  C   LYS A 776     -14.826  50.761   3.496  1.00 10.00           C  
ATOM    758  O   LYS A 776     -13.810  51.133   2.912  1.00 10.00           O  
ATOM    759  CB  LYS A 776     -17.141  51.798   3.233  1.00 10.00           C  
ATOM    760  CG  LYS A 776     -16.609  53.201   2.912  1.00 10.00           C  
ATOM    761  CD  LYS A 776     -17.657  54.268   3.259  1.00 10.00           C  
ATOM    762  CE  LYS A 776     -17.135  55.684   2.988  1.00 10.00           C  
ATOM    763  NZ  LYS A 776     -16.118  56.092   3.974  1.00 10.00           N  
ATOM    764  H   LYS A 776     -17.668  49.287   3.392  1.00 10.00           H  
ATOM    765  HA  LYS A 776     -15.994  50.853   1.697  1.00 10.00           H  
ATOM    766  HB2 LYS A 776     -18.100  51.656   2.732  1.00 10.00           H  
ATOM    767  HB3 LYS A 776     -17.287  51.713   4.307  1.00 10.00           H  
ATOM    768  HG2 LYS A 776     -15.699  53.380   3.486  1.00 10.00           H  
ATOM    769  HG3 LYS A 776     -16.374  53.264   1.848  1.00 10.00           H  
ATOM    770  HD2 LYS A 776     -18.547  54.099   2.648  1.00 10.00           H  
ATOM    771  HD3 LYS A 776     -17.937  54.188   4.310  1.00 10.00           H  
ATOM    772  HE2 LYS A 776     -16.714  55.738   1.984  1.00 10.00           H  
ATOM    773  HE3 LYS A 776     -17.969  56.385   3.052  1.00 10.00           H  
ATOM    774  HZ1 LYS A 776     -15.781  57.018   3.750  1.00 10.00           H  
ATOM    775  HZ2 LYS A 776     -16.528  56.106   4.897  1.00 10.00           H  
ATOM    776  HZ3 LYS A 776     -15.340  55.445   3.976  1.00 10.00           H  
ATOM    777  N   THR A 777     -14.806  50.337   4.759  1.00 10.00           N  
ATOM    778  CA  THR A 777     -13.577  50.260   5.535  1.00 10.00           C  
ATOM    779  C   THR A 777     -12.550  49.317   4.889  1.00 10.00           C  
ATOM    780  O   THR A 777     -11.375  49.672   4.840  1.00 10.00           O  
ATOM    781  CB  THR A 777     -13.901  49.936   6.997  1.00 10.00           C  
ATOM    782  OG1 THR A 777     -14.780  50.934   7.469  1.00 10.00           O  
ATOM    783  CG2 THR A 777     -12.658  49.944   7.890  1.00 10.00           C  
ATOM    784  H   THR A 777     -15.679  50.087   5.210  1.00 10.00           H  
ATOM    785  HA  THR A 777     -13.140  51.260   5.533  1.00 10.00           H  
ATOM    786  HB  THR A 777     -14.388  48.965   7.061  1.00 10.00           H  
ATOM    787  HG1 THR A 777     -15.476  50.524   7.997  1.00 10.00           H  
ATOM    788 HG21 THR A 777     -11.952  49.175   7.574  1.00 10.00           H  
ATOM    789 HG22 THR A 777     -12.171  50.919   7.837  1.00 10.00           H  
ATOM    790 HG23 THR A 777     -12.949  49.750   8.922  1.00 10.00           H  
ATOM    791  N   MET A 778     -12.949  48.159   4.340  1.00 10.00           N  
ATOM    792  CA  MET A 778     -12.035  47.337   3.538  1.00 10.00           C  
ATOM    793  C   MET A 778     -11.409  48.193   2.431  1.00 10.00           C  
ATOM    794  O   MET A 778     -10.198  48.166   2.233  1.00 10.00           O  
ATOM    795  CB  MET A 778     -12.729  46.118   2.907  1.00 10.00           C  
ATOM    796  CG  MET A 778     -13.195  45.054   3.908  1.00 10.00           C  
ATOM    797  SD  MET A 778     -11.924  44.024   4.680  1.00 10.00           S  
ATOM    798  CE  MET A 778     -11.307  43.067   3.278  1.00 10.00           C  
ATOM    799  H   MET A 778     -13.921  47.881   4.432  1.00 10.00           H  
ATOM    800  HA  MET A 778     -11.232  46.976   4.183  1.00 10.00           H  
ATOM    801  HB2 MET A 778     -13.584  46.448   2.326  1.00 10.00           H  
ATOM    802  HB3 MET A 778     -12.035  45.648   2.211  1.00 10.00           H  
ATOM    803  HG2 MET A 778     -13.746  45.537   4.710  1.00 10.00           H  
ATOM    804  HG3 MET A 778     -13.871  44.372   3.394  1.00 10.00           H  
ATOM    805  HE1 MET A 778     -12.131  42.530   2.814  1.00 10.00           H  
ATOM    806  HE2 MET A 778     -10.838  43.731   2.554  1.00 10.00           H  
ATOM    807  HE3 MET A 778     -10.570  42.350   3.635  1.00 10.00           H  
ATOM    808  N   THR A 779     -12.227  48.969   1.716  1.00 10.00           N  
ATOM    809  CA  THR A 779     -11.749  49.847   0.651  1.00 10.00           C  
ATOM    810  C   THR A 779     -10.735  50.863   1.196  1.00 10.00           C  
ATOM    811  O   THR A 779      -9.671  51.060   0.610  1.00 10.00           O  
ATOM    812  CB  THR A 779     -12.926  50.539  -0.061  1.00 10.00           C  
ATOM    813  OG1 THR A 779     -13.999  49.640  -0.260  1.00 10.00           O  
ATOM    814  CG2 THR A 779     -12.502  51.043  -1.443  1.00 10.00           C  
ATOM    815  H   THR A 779     -13.216  48.952   1.942  1.00 10.00           H  
ATOM    816  HA  THR A 779     -11.239  49.217  -0.079  1.00 10.00           H  
ATOM    817  HB  THR A 779     -13.281  51.386   0.523  1.00 10.00           H  
ATOM    818  HG1 THR A 779     -14.328  49.326   0.591  1.00 10.00           H  
ATOM    819 HG21 THR A 779     -11.654  51.719  -1.361  1.00 10.00           H  
ATOM    820 HG22 THR A 779     -12.223  50.202  -2.078  1.00 10.00           H  
ATOM    821 HG23 THR A 779     -13.333  51.577  -1.906  1.00 10.00           H  
ATOM    822  N   GLU A 780     -11.053  51.518   2.319  1.00 10.00           N  
ATOM    823  CA  GLU A 780     -10.143  52.456   2.974  1.00 10.00           C  
ATOM    824  C   GLU A 780      -8.812  51.772   3.299  1.00 10.00           C  
ATOM    825  O   GLU A 780      -7.744  52.264   2.935  1.00 10.00           O  
ATOM    826  CB  GLU A 780     -10.781  53.028   4.249  1.00 10.00           C  
ATOM    827  CG  GLU A 780     -12.017  53.889   3.951  1.00 10.00           C  
ATOM    828  CD  GLU A 780     -12.758  54.307   5.219  1.00 10.00           C  
ATOM    829  OE1 GLU A 780     -12.088  54.424   6.267  1.00 10.00           O  
ATOM    830  OE2 GLU A 780     -13.987  54.506   5.109  1.00 10.00           O  
ATOM    831  H   GLU A 780     -11.942  51.300   2.764  1.00 10.00           H  
ATOM    832  HA  GLU A 780      -9.935  53.287   2.298  1.00 10.00           H  
ATOM    833  HB2 GLU A 780     -11.053  52.216   4.923  1.00 10.00           H  
ATOM    834  HB3 GLU A 780     -10.044  53.653   4.758  1.00 10.00           H  
ATOM    835  HG2 GLU A 780     -11.709  54.790   3.420  1.00 10.00           H  
ATOM    836  HG3 GLU A 780     -12.717  53.337   3.331  1.00 10.00           H  
ATOM    837  N   ARG A 781      -8.873  50.632   3.985  1.00 10.00           N  
ATOM    838  CA  ARG A 781      -7.708  49.867   4.396  1.00 10.00           C  
ATOM    839  C   ARG A 781      -6.884  49.429   3.182  1.00 10.00           C  
ATOM    840  O   ARG A 781      -5.659  49.540   3.195  1.00 10.00           O  
ATOM    841  CB  ARG A 781      -8.164  48.682   5.256  1.00 10.00           C  
ATOM    842  CG  ARG A 781      -8.598  49.163   6.646  1.00 10.00           C  
ATOM    843  CD  ARG A 781      -9.029  47.980   7.515  1.00 10.00           C  
ATOM    844  NE  ARG A 781      -9.504  48.440   8.826  1.00 10.00           N  
ATOM    845  CZ  ARG A 781     -10.127  47.652   9.711  1.00 10.00           C  
ATOM    846  NH1 ARG A 781     -10.073  46.322   9.584  1.00 10.00           N  
ATOM    847  NH2 ARG A 781     -10.837  48.206  10.699  1.00 10.00           N  
ATOM    848  H   ARG A 781      -9.788  50.272   4.229  1.00 10.00           H  
ATOM    849  HA  ARG A 781      -7.072  50.506   5.009  1.00 10.00           H  
ATOM    850  HB2 ARG A 781      -8.988  48.164   4.763  1.00 10.00           H  
ATOM    851  HB3 ARG A 781      -7.344  47.980   5.379  1.00 10.00           H  
ATOM    852  HG2 ARG A 781      -7.765  49.674   7.131  1.00 10.00           H  
ATOM    853  HG3 ARG A 781      -9.431  49.861   6.552  1.00 10.00           H  
ATOM    854  HD2 ARG A 781      -9.841  47.456   7.008  1.00 10.00           H  
ATOM    855  HD3 ARG A 781      -8.191  47.296   7.640  1.00 10.00           H  
ATOM    856  HE  ARG A 781      -9.505  49.439   8.978  1.00 10.00           H  
ATOM    857 HH11 ARG A 781      -9.520  45.893   8.850  1.00 10.00           H  
ATOM    858 HH12 ARG A 781     -10.602  45.725  10.201  1.00 10.00           H  
ATOM    859 HH21 ARG A 781     -10.863  49.210  10.789  1.00 10.00           H  
ATOM    860 HH22 ARG A 781     -11.485  47.652  11.261  1.00 10.00           H  
ATOM    861  N   LEU A 782      -7.544  48.960   2.121  1.00 10.00           N  
ATOM    862  CA  LEU A 782      -6.894  48.584   0.875  1.00 10.00           C  
ATOM    863  C   LEU A 782      -6.160  49.784   0.281  1.00 10.00           C  
ATOM    864  O   LEU A 782      -4.968  49.695  -0.010  1.00 10.00           O  
ATOM    865  CB  LEU A 782      -7.928  47.987  -0.093  1.00 10.00           C  
ATOM    866  CG  LEU A 782      -7.355  47.651  -1.480  1.00 10.00           C  
ATOM    867  CD1 LEU A 782      -6.178  46.672  -1.414  1.00 10.00           C  
ATOM    868  CD2 LEU A 782      -8.456  47.051  -2.357  1.00 10.00           C  
ATOM    869  H   LEU A 782      -8.552  48.881   2.179  1.00 10.00           H  
ATOM    870  HA  LEU A 782      -6.151  47.823   1.114  1.00 10.00           H  
ATOM    871  HB2 LEU A 782      -8.344  47.080   0.349  1.00 10.00           H  
ATOM    872  HB3 LEU A 782      -8.740  48.702  -0.227  1.00 10.00           H  
ATOM    873  HG  LEU A 782      -7.020  48.568  -1.961  1.00 10.00           H  
ATOM    874 HD11 LEU A 782      -5.343  47.124  -0.883  1.00 10.00           H  
ATOM    875 HD12 LEU A 782      -6.479  45.755  -0.910  1.00 10.00           H  
ATOM    876 HD13 LEU A 782      -5.850  46.433  -2.426  1.00 10.00           H  
ATOM    877 HD21 LEU A 782      -8.051  46.864  -3.350  1.00 10.00           H  
ATOM    878 HD22 LEU A 782      -8.813  46.112  -1.932  1.00 10.00           H  
ATOM    879 HD23 LEU A 782      -9.287  47.750  -2.441  1.00 10.00           H  
ATOM    880  N   ARG A 783      -6.849  50.918   0.123  1.00 10.00           N  
ATOM    881  CA  ARG A 783      -6.224  52.156  -0.334  1.00 10.00           C  
ATOM    882  C   ARG A 783      -5.042  52.540   0.564  1.00 10.00           C  
ATOM    883  O   ARG A 783      -4.013  52.991   0.068  1.00 10.00           O  
ATOM    884  CB  ARG A 783      -7.264  53.279  -0.406  1.00 10.00           C  
ATOM    885  CG  ARG A 783      -8.198  53.067  -1.605  1.00 10.00           C  
ATOM    886  CD  ARG A 783      -9.338  54.088  -1.605  1.00 10.00           C  
ATOM    887  NE  ARG A 783     -10.274  53.826  -0.504  1.00 10.00           N  
ATOM    888  CZ  ARG A 783     -11.403  54.517  -0.294  1.00 10.00           C  
ATOM    889  NH1 ARG A 783     -11.706  55.564  -1.069  1.00 10.00           N  
ATOM    890  NH2 ARG A 783     -12.230  54.153   0.689  1.00 10.00           N  
ATOM    891  H   ARG A 783      -7.831  50.940   0.388  1.00 10.00           H  
ATOM    892  HA  ARG A 783      -5.824  51.997  -1.336  1.00 10.00           H  
ATOM    893  HB2 ARG A 783      -7.831  53.314   0.525  1.00 10.00           H  
ATOM    894  HB3 ARG A 783      -6.750  54.234  -0.533  1.00 10.00           H  
ATOM    895  HG2 ARG A 783      -7.620  53.185  -2.523  1.00 10.00           H  
ATOM    896  HG3 ARG A 783      -8.620  52.062  -1.588  1.00 10.00           H  
ATOM    897  HD2 ARG A 783      -8.924  55.093  -1.514  1.00 10.00           H  
ATOM    898  HD3 ARG A 783      -9.874  54.003  -2.552  1.00 10.00           H  
ATOM    899  HE  ARG A 783     -10.061  53.025   0.080  1.00 10.00           H  
ATOM    900 HH11 ARG A 783     -11.071  55.833  -1.805  1.00 10.00           H  
ATOM    901 HH12 ARG A 783     -12.551  56.095  -0.927  1.00 10.00           H  
ATOM    902 HH21 ARG A 783     -11.982  53.390   1.302  1.00 10.00           H  
ATOM    903 HH22 ARG A 783     -13.088  54.659   0.853  1.00 10.00           H  
ATOM    904  N   SER A 784      -5.168  52.319   1.874  1.00 10.00           N  
ATOM    905  CA  SER A 784      -4.105  52.585   2.837  1.00 10.00           C  
ATOM    906  C   SER A 784      -3.039  51.479   2.868  1.00 10.00           C  
ATOM    907  O   SER A 784      -2.164  51.514   3.727  1.00 10.00           O  
ATOM    908  CB  SER A 784      -4.712  52.773   4.231  1.00 10.00           C  
ATOM    909  OG  SER A 784      -5.761  53.723   4.195  1.00 10.00           O  
ATOM    910  H   SER A 784      -6.058  51.977   2.220  1.00 10.00           H  
ATOM    911  HA  SER A 784      -3.611  53.520   2.566  1.00 10.00           H  
ATOM    912  HB2 SER A 784      -5.091  51.819   4.599  1.00 10.00           H  
ATOM    913  HB3 SER A 784      -3.935  53.121   4.915  1.00 10.00           H  
ATOM    914  HG  SER A 784      -6.486  53.369   3.665  1.00 10.00           H  
ATOM    915  N   ARG A 785      -3.103  50.496   1.963  1.00 10.00           N  
ATOM    916  CA  ARG A 785      -2.139  49.408   1.850  1.00 10.00           C  
ATOM    917  C   ARG A 785      -2.006  48.621   3.163  1.00 10.00           C  
ATOM    918  O   ARG A 785      -0.933  48.125   3.502  1.00 10.00           O  
ATOM    919  CB  ARG A 785      -0.806  49.963   1.313  1.00 10.00           C  
ATOM    920  CG  ARG A 785       0.140  48.934   0.667  1.00 10.00           C  
ATOM    921  CD  ARG A 785      -0.245  48.537  -0.770  1.00 10.00           C  
ATOM    922  NE  ARG A 785      -1.451  47.700  -0.833  1.00 10.00           N  
ATOM    923  CZ  ARG A 785      -1.526  46.429  -0.415  1.00 10.00           C  
ATOM    924  NH1 ARG A 785      -0.447  45.783   0.034  1.00 10.00           N  
ATOM    925  NH2 ARG A 785      -2.690  45.782  -0.419  1.00 10.00           N  
ATOM    926  H   ARG A 785      -3.861  50.489   1.291  1.00 10.00           H  
ATOM    927  HA  ARG A 785      -2.568  48.727   1.121  1.00 10.00           H  
ATOM    928  HB2 ARG A 785      -1.011  50.737   0.573  1.00 10.00           H  
ATOM    929  HB3 ARG A 785      -0.279  50.432   2.145  1.00 10.00           H  
ATOM    930  HG2 ARG A 785       1.123  49.404   0.611  1.00 10.00           H  
ATOM    931  HG3 ARG A 785       0.236  48.056   1.302  1.00 10.00           H  
ATOM    932  HD2 ARG A 785      -0.415  49.441  -1.357  1.00 10.00           H  
ATOM    933  HD3 ARG A 785       0.584  47.998  -1.232  1.00 10.00           H  
ATOM    934  HE  ARG A 785      -2.295  48.153  -1.158  1.00 10.00           H  
ATOM    935 HH11 ARG A 785       0.450  46.242   0.067  1.00 10.00           H  
ATOM    936 HH12 ARG A 785      -0.570  44.850   0.418  1.00 10.00           H  
ATOM    937 HH21 ARG A 785      -3.526  46.213  -0.779  1.00 10.00           H  
ATOM    938 HH22 ARG A 785      -2.715  44.850  -0.013  1.00 10.00           H  
ATOM    939  N   TYR A 786      -3.118  48.467   3.889  1.00 10.00           N  
ATOM    940  CA  TYR A 786      -3.201  47.657   5.101  1.00 10.00           C  
ATOM    941  C   TYR A 786      -2.834  46.212   4.756  1.00 10.00           C  
ATOM    942  O   TYR A 786      -2.074  45.550   5.462  1.00 10.00           O  
ATOM    943  CB  TYR A 786      -4.639  47.753   5.633  1.00 10.00           C  
ATOM    944  CG  TYR A 786      -4.927  47.203   7.023  1.00 10.00           C  
ATOM    945  CD1 TYR A 786      -5.178  45.828   7.204  1.00 10.00           C  
ATOM    946  CD2 TYR A 786      -5.232  48.098   8.068  1.00 10.00           C  
ATOM    947  CE1 TYR A 786      -5.796  45.366   8.382  1.00 10.00           C  
ATOM    948  CE2 TYR A 786      -5.834  47.634   9.252  1.00 10.00           C  
ATOM    949  CZ  TYR A 786      -6.160  46.274   9.391  1.00 10.00           C  
ATOM    950  OH  TYR A 786      -6.862  45.846  10.482  1.00 10.00           O  
ATOM    951  H   TYR A 786      -3.966  48.919   3.559  1.00 10.00           H  
ATOM    952  HA  TYR A 786      -2.507  48.048   5.846  1.00 10.00           H  
ATOM    953  HB2 TYR A 786      -4.915  48.808   5.636  1.00 10.00           H  
ATOM    954  HB3 TYR A 786      -5.292  47.245   4.924  1.00 10.00           H  
ATOM    955  HD1 TYR A 786      -4.927  45.127   6.426  1.00 10.00           H  
ATOM    956  HD2 TYR A 786      -5.054  49.157   7.945  1.00 10.00           H  
ATOM    957  HE1 TYR A 786      -6.016  44.315   8.502  1.00 10.00           H  
ATOM    958  HE2 TYR A 786      -6.110  48.345  10.017  1.00 10.00           H  
ATOM    959  HH  TYR A 786      -6.988  46.563  11.107  1.00 10.00           H  
ATOM    960  N   TYR A 787      -3.398  45.720   3.651  1.00 10.00           N  
ATOM    961  CA  TYR A 787      -3.280  44.336   3.230  1.00 10.00           C  
ATOM    962  C   TYR A 787      -1.936  44.087   2.553  1.00 10.00           C  
ATOM    963  O   TYR A 787      -1.871  43.808   1.355  1.00 10.00           O  
ATOM    964  CB  TYR A 787      -4.484  43.977   2.348  1.00 10.00           C  
ATOM    965  CG  TYR A 787      -5.816  44.239   3.024  1.00 10.00           C  
ATOM    966  CD1 TYR A 787      -6.058  43.674   4.284  1.00 10.00           C  
ATOM    967  CD2 TYR A 787      -6.725  45.174   2.498  1.00 10.00           C  
ATOM    968  CE1 TYR A 787      -7.162  44.076   5.043  1.00 10.00           C  
ATOM    969  CE2 TYR A 787      -7.839  45.576   3.258  1.00 10.00           C  
ATOM    970  CZ  TYR A 787      -8.038  45.051   4.545  1.00 10.00           C  
ATOM    971  OH  TYR A 787      -9.027  45.543   5.338  1.00 10.00           O  
ATOM    972  H   TYR A 787      -3.988  46.332   3.111  1.00 10.00           H  
ATOM    973  HA  TYR A 787      -3.305  43.700   4.114  1.00 10.00           H  
ATOM    974  HB2 TYR A 787      -4.431  44.556   1.427  1.00 10.00           H  
ATOM    975  HB3 TYR A 787      -4.425  42.916   2.101  1.00 10.00           H  
ATOM    976  HD1 TYR A 787      -5.369  42.965   4.701  1.00 10.00           H  
ATOM    977  HD2 TYR A 787      -6.568  45.593   1.517  1.00 10.00           H  
ATOM    978  HE1 TYR A 787      -7.280  43.669   6.032  1.00 10.00           H  
ATOM    979  HE2 TYR A 787      -8.536  46.300   2.863  1.00 10.00           H  
ATOM    980  HH  TYR A 787      -9.047  45.137   6.212  1.00 10.00           H  
ATOM    981  N   VAL A 788      -0.859  44.157   3.339  1.00 10.00           N  
ATOM    982  CA  VAL A 788       0.489  43.823   2.892  1.00 10.00           C  
ATOM    983  C   VAL A 788       0.586  42.368   2.413  1.00 10.00           C  
ATOM    984  O   VAL A 788       1.441  42.054   1.590  1.00 10.00           O  
ATOM    985  CB  VAL A 788       1.539  44.172   3.962  1.00 10.00           C  
ATOM    986  CG1 VAL A 788       1.602  45.691   4.177  1.00 10.00           C  
ATOM    987  CG2 VAL A 788       1.293  43.484   5.309  1.00 10.00           C  
ATOM    988  H   VAL A 788      -0.995  44.489   4.290  1.00 10.00           H  
ATOM    989  HA  VAL A 788       0.719  44.442   2.027  1.00 10.00           H  
ATOM    990  HB  VAL A 788       2.513  43.848   3.590  1.00 10.00           H  
ATOM    991 HG11 VAL A 788       2.400  45.928   4.880  1.00 10.00           H  
ATOM    992 HG12 VAL A 788       1.810  46.193   3.231  1.00 10.00           H  
ATOM    993 HG13 VAL A 788       0.658  46.063   4.575  1.00 10.00           H  
ATOM    994 HG21 VAL A 788       0.409  43.902   5.787  1.00 10.00           H  
ATOM    995 HG22 VAL A 788       1.169  42.411   5.176  1.00 10.00           H  
ATOM    996 HG23 VAL A 788       2.150  43.657   5.963  1.00 10.00           H  
ATOM    997  N   THR A 789      -0.294  41.483   2.899  1.00 10.00           N  
ATOM    998  CA  THR A 789      -0.454  40.132   2.380  1.00 10.00           C  
ATOM    999  C   THR A 789      -1.952  39.833   2.295  1.00 10.00           C  
ATOM   1000  O   THR A 789      -2.727  40.328   3.118  1.00 10.00           O  
ATOM   1001  CB  THR A 789       0.266  39.119   3.283  1.00 10.00           C  
ATOM   1002  OG1 THR A 789      -0.205  39.223   4.609  1.00 10.00           O  
ATOM   1003  CG2 THR A 789       1.784  39.316   3.279  1.00 10.00           C  
ATOM   1004  H   THR A 789      -1.006  41.793   3.543  1.00 10.00           H  
ATOM   1005  HA  THR A 789      -0.039  40.063   1.373  1.00 10.00           H  
ATOM   1006  HB  THR A 789       0.055  38.112   2.916  1.00 10.00           H  
ATOM   1007  HG1 THR A 789       0.052  40.080   4.958  1.00 10.00           H  
ATOM   1008 HG21 THR A 789       2.162  39.269   2.258  1.00 10.00           H  
ATOM   1009 HG22 THR A 789       2.051  40.281   3.712  1.00 10.00           H  
ATOM   1010 HG23 THR A 789       2.253  38.527   3.866  1.00 10.00           H  
ATOM   1011  N   ARG A 790      -2.367  39.016   1.317  1.00 10.00           N  
ATOM   1012  CA  ARG A 790      -3.770  38.642   1.164  1.00 10.00           C  
ATOM   1013  C   ARG A 790      -4.315  38.010   2.446  1.00 10.00           C  
ATOM   1014  O   ARG A 790      -5.484  38.202   2.769  1.00 10.00           O  
ATOM   1015  CB  ARG A 790      -3.980  37.740  -0.065  1.00 10.00           C  
ATOM   1016  CG  ARG A 790      -5.465  37.366  -0.202  1.00 10.00           C  
ATOM   1017  CD  ARG A 790      -5.870  36.970  -1.623  1.00 10.00           C  
ATOM   1018  NE  ARG A 790      -5.237  35.716  -2.050  1.00 10.00           N  
ATOM   1019  CZ  ARG A 790      -5.654  34.992  -3.101  1.00 10.00           C  
ATOM   1020  NH1 ARG A 790      -6.664  35.432  -3.860  1.00 10.00           N  
ATOM   1021  NH2 ARG A 790      -5.062  33.829  -3.386  1.00 10.00           N  
ATOM   1022  H   ARG A 790      -1.698  38.656   0.652  1.00 10.00           H  
ATOM   1023  HA  ARG A 790      -4.327  39.565   0.999  1.00 10.00           H  
ATOM   1024  HB2 ARG A 790      -3.662  38.284  -0.954  1.00 10.00           H  
ATOM   1025  HB3 ARG A 790      -3.384  36.831   0.023  1.00 10.00           H  
ATOM   1026  HG2 ARG A 790      -5.700  36.544   0.475  1.00 10.00           H  
ATOM   1027  HG3 ARG A 790      -6.083  38.220   0.077  1.00 10.00           H  
ATOM   1028  HD2 ARG A 790      -6.954  36.837  -1.616  1.00 10.00           H  
ATOM   1029  HD3 ARG A 790      -5.616  37.766  -2.324  1.00 10.00           H  
ATOM   1030  HE  ARG A 790      -4.462  35.379  -1.498  1.00 10.00           H  
ATOM   1031 HH11 ARG A 790      -7.085  36.324  -3.657  1.00 10.00           H  
ATOM   1032 HH12 ARG A 790      -7.035  34.872  -4.622  1.00 10.00           H  
ATOM   1033 HH21 ARG A 790      -4.298  33.494  -2.819  1.00 10.00           H  
ATOM   1034 HH22 ARG A 790      -5.363  33.283  -4.190  1.00 10.00           H  
ATOM   1035  N   LYS A 791      -3.472  37.301   3.203  1.00 10.00           N  
ATOM   1036  CA  LYS A 791      -3.829  36.750   4.504  1.00 10.00           C  
ATOM   1037  C   LYS A 791      -4.538  37.781   5.391  1.00 10.00           C  
ATOM   1038  O   LYS A 791      -5.502  37.446   6.076  1.00 10.00           O  
ATOM   1039  CB  LYS A 791      -2.577  36.209   5.206  1.00 10.00           C  
ATOM   1040  CG  LYS A 791      -1.856  35.088   4.437  1.00 10.00           C  
ATOM   1041  CD  LYS A 791      -2.745  33.891   4.063  1.00 10.00           C  
ATOM   1042  CE  LYS A 791      -3.423  33.258   5.285  1.00 10.00           C  
ATOM   1043  NZ  LYS A 791      -4.180  32.051   4.911  1.00 10.00           N  
ATOM   1044  H   LYS A 791      -2.521  37.195   2.890  1.00 10.00           H  
ATOM   1045  HA  LYS A 791      -4.532  35.933   4.345  1.00 10.00           H  
ATOM   1046  HB2 LYS A 791      -1.873  37.030   5.355  1.00 10.00           H  
ATOM   1047  HB3 LYS A 791      -2.860  35.839   6.193  1.00 10.00           H  
ATOM   1048  HG2 LYS A 791      -1.417  35.493   3.525  1.00 10.00           H  
ATOM   1049  HG3 LYS A 791      -1.035  34.732   5.062  1.00 10.00           H  
ATOM   1050  HD2 LYS A 791      -3.497  34.196   3.334  1.00 10.00           H  
ATOM   1051  HD3 LYS A 791      -2.110  33.140   3.587  1.00 10.00           H  
ATOM   1052  HE2 LYS A 791      -2.667  32.983   6.022  1.00 10.00           H  
ATOM   1053  HE3 LYS A 791      -4.119  33.962   5.743  1.00 10.00           H  
ATOM   1054  HZ1 LYS A 791      -3.556  31.370   4.501  1.00 10.00           H  
ATOM   1055  HZ2 LYS A 791      -4.611  31.654   5.735  1.00 10.00           H  
ATOM   1056  HZ3 LYS A 791      -4.898  32.292   4.243  1.00 10.00           H  
ATOM   1057  N   LEU A 792      -4.095  39.040   5.371  1.00 10.00           N  
ATOM   1058  CA  LEU A 792      -4.735  40.081   6.165  1.00 10.00           C  
ATOM   1059  C   LEU A 792      -6.115  40.434   5.599  1.00 10.00           C  
ATOM   1060  O   LEU A 792      -7.043  40.727   6.353  1.00 10.00           O  
ATOM   1061  CB  LEU A 792      -3.824  41.312   6.238  1.00 10.00           C  
ATOM   1062  CG  LEU A 792      -2.485  41.044   6.942  1.00 10.00           C  
ATOM   1063  CD1 LEU A 792      -1.599  42.278   6.772  1.00 10.00           C  
ATOM   1064  CD2 LEU A 792      -2.661  40.751   8.438  1.00 10.00           C  
ATOM   1065  H   LEU A 792      -3.341  39.302   4.744  1.00 10.00           H  
ATOM   1066  HA  LEU A 792      -4.892  39.713   7.178  1.00 10.00           H  
ATOM   1067  HB2 LEU A 792      -3.616  41.636   5.220  1.00 10.00           H  
ATOM   1068  HB3 LEU A 792      -4.346  42.113   6.763  1.00 10.00           H  
ATOM   1069  HG  LEU A 792      -1.980  40.198   6.475  1.00 10.00           H  
ATOM   1070 HD11 LEU A 792      -0.628  42.104   7.237  1.00 10.00           H  
ATOM   1071 HD12 LEU A 792      -1.455  42.476   5.712  1.00 10.00           H  
ATOM   1072 HD13 LEU A 792      -2.067  43.148   7.237  1.00 10.00           H  
ATOM   1073 HD21 LEU A 792      -3.230  41.550   8.914  1.00 10.00           H  
ATOM   1074 HD22 LEU A 792      -3.176  39.803   8.586  1.00 10.00           H  
ATOM   1075 HD23 LEU A 792      -1.682  40.682   8.914  1.00 10.00           H  
ATOM   1076  N   PHE A 793      -6.270  40.402   4.272  1.00 10.00           N  
ATOM   1077  CA  PHE A 793      -7.569  40.607   3.642  1.00 10.00           C  
ATOM   1078  C   PHE A 793      -8.502  39.480   4.074  1.00 10.00           C  
ATOM   1079  O   PHE A 793      -9.623  39.737   4.500  1.00 10.00           O  
ATOM   1080  CB  PHE A 793      -7.437  40.690   2.115  1.00 10.00           C  
ATOM   1081  CG  PHE A 793      -8.682  41.183   1.392  1.00 10.00           C  
ATOM   1082  CD1 PHE A 793      -9.803  40.341   1.252  1.00 10.00           C  
ATOM   1083  CD2 PHE A 793      -8.694  42.458   0.794  1.00 10.00           C  
ATOM   1084  CE1 PHE A 793     -10.931  40.776   0.535  1.00 10.00           C  
ATOM   1085  CE2 PHE A 793      -9.800  42.870   0.031  1.00 10.00           C  
ATOM   1086  CZ  PHE A 793     -10.920  42.030  -0.097  1.00 10.00           C  
ATOM   1087  H   PHE A 793      -5.515  40.035   3.707  1.00 10.00           H  
ATOM   1088  HA  PHE A 793      -7.983  41.554   3.994  1.00 10.00           H  
ATOM   1089  HB2 PHE A 793      -6.611  41.362   1.880  1.00 10.00           H  
ATOM   1090  HB3 PHE A 793      -7.187  39.707   1.717  1.00 10.00           H  
ATOM   1091  HD1 PHE A 793      -9.815  39.361   1.698  1.00 10.00           H  
ATOM   1092  HD2 PHE A 793      -7.850  43.122   0.899  1.00 10.00           H  
ATOM   1093  HE1 PHE A 793     -11.809  40.149   0.477  1.00 10.00           H  
ATOM   1094  HE2 PHE A 793      -9.792  43.837  -0.452  1.00 10.00           H  
ATOM   1095  HZ  PHE A 793     -11.775  42.349  -0.673  1.00 10.00           H  
ATOM   1096  N   VAL A 794      -8.029  38.232   3.988  1.00 10.00           N  
ATOM   1097  CA  VAL A 794      -8.753  37.062   4.469  1.00 10.00           C  
ATOM   1098  C   VAL A 794      -9.172  37.272   5.921  1.00 10.00           C  
ATOM   1099  O   VAL A 794     -10.355  37.160   6.233  1.00 10.00           O  
ATOM   1100  CB  VAL A 794      -7.923  35.782   4.253  1.00 10.00           C  
ATOM   1101  CG1 VAL A 794      -8.594  34.553   4.881  1.00 10.00           C  
ATOM   1102  CG2 VAL A 794      -7.722  35.514   2.756  1.00 10.00           C  
ATOM   1103  H   VAL A 794      -7.086  38.102   3.637  1.00 10.00           H  
ATOM   1104  HA  VAL A 794      -9.674  36.972   3.899  1.00 10.00           H  
ATOM   1105  HB  VAL A 794      -6.946  35.901   4.715  1.00 10.00           H  
ATOM   1106 HG11 VAL A 794      -9.613  34.445   4.510  1.00 10.00           H  
ATOM   1107 HG12 VAL A 794      -8.027  33.656   4.631  1.00 10.00           H  
ATOM   1108 HG13 VAL A 794      -8.613  34.651   5.966  1.00 10.00           H  
ATOM   1109 HG21 VAL A 794      -8.682  35.307   2.286  1.00 10.00           H  
ATOM   1110 HG22 VAL A 794      -7.270  36.373   2.269  1.00 10.00           H  
ATOM   1111 HG23 VAL A 794      -7.069  34.651   2.621  1.00 10.00           H  
ATOM   1112  N   ALA A 795      -8.222  37.616   6.795  1.00 10.00           N  
ATOM   1113  CA  ALA A 795      -8.499  37.891   8.195  1.00 10.00           C  
ATOM   1114  C   ALA A 795      -9.607  38.937   8.345  1.00 10.00           C  
ATOM   1115  O   ALA A 795     -10.574  38.704   9.061  1.00 10.00           O  
ATOM   1116  CB  ALA A 795      -7.221  38.328   8.914  1.00 10.00           C  
ATOM   1117  H   ALA A 795      -7.260  37.663   6.476  1.00 10.00           H  
ATOM   1118  HA  ALA A 795      -8.840  36.961   8.657  1.00 10.00           H  
ATOM   1119  HB1 ALA A 795      -6.863  39.275   8.515  1.00 10.00           H  
ATOM   1120  HB2 ALA A 795      -7.430  38.453   9.978  1.00 10.00           H  
ATOM   1121  HB3 ALA A 795      -6.448  37.568   8.793  1.00 10.00           H  
ATOM   1122  N   ASP A 796      -9.492  40.084   7.671  1.00 10.00           N  
ATOM   1123  CA  ASP A 796     -10.481  41.152   7.796  1.00 10.00           C  
ATOM   1124  C   ASP A 796     -11.844  40.745   7.225  1.00 10.00           C  
ATOM   1125  O   ASP A 796     -12.877  41.061   7.806  1.00 10.00           O  
ATOM   1126  CB  ASP A 796      -9.979  42.444   7.145  1.00 10.00           C  
ATOM   1127  CG  ASP A 796      -8.969  43.201   8.001  1.00 10.00           C  
ATOM   1128  OD1 ASP A 796      -8.238  42.544   8.774  1.00 10.00           O  
ATOM   1129  OD2 ASP A 796      -8.945  44.445   7.854  1.00 10.00           O  
ATOM   1130  H   ASP A 796      -8.665  40.239   7.101  1.00 10.00           H  
ATOM   1131  HA  ASP A 796     -10.628  41.362   8.856  1.00 10.00           H  
ATOM   1132  HB2 ASP A 796      -9.563  42.237   6.159  1.00 10.00           H  
ATOM   1133  HB3 ASP A 796     -10.839  43.103   7.036  1.00 10.00           H  
ATOM   1134  N   LEU A 797     -11.883  40.039   6.097  1.00 10.00           N  
ATOM   1135  CA  LEU A 797     -13.139  39.572   5.520  1.00 10.00           C  
ATOM   1136  C   LEU A 797     -13.798  38.583   6.495  1.00 10.00           C  
ATOM   1137  O   LEU A 797     -14.973  38.707   6.843  1.00 10.00           O  
ATOM   1138  CB  LEU A 797     -12.852  38.989   4.124  1.00 10.00           C  
ATOM   1139  CG  LEU A 797     -14.036  38.920   3.143  1.00 10.00           C  
ATOM   1140  CD1 LEU A 797     -15.146  37.979   3.608  1.00 10.00           C  
ATOM   1141  CD2 LEU A 797     -14.623  40.296   2.808  1.00 10.00           C  
ATOM   1142  H   LEU A 797     -11.011  39.792   5.643  1.00 10.00           H  
ATOM   1143  HA  LEU A 797     -13.788  40.441   5.416  1.00 10.00           H  
ATOM   1144  HB2 LEU A 797     -12.106  39.622   3.642  1.00 10.00           H  
ATOM   1145  HB3 LEU A 797     -12.416  37.997   4.237  1.00 10.00           H  
ATOM   1146  HG  LEU A 797     -13.640  38.510   2.213  1.00 10.00           H  
ATOM   1147 HD11 LEU A 797     -14.709  37.035   3.931  1.00 10.00           H  
ATOM   1148 HD12 LEU A 797     -15.707  38.431   4.424  1.00 10.00           H  
ATOM   1149 HD13 LEU A 797     -15.825  37.791   2.777  1.00 10.00           H  
ATOM   1150 HD21 LEU A 797     -13.834  40.961   2.461  1.00 10.00           H  
ATOM   1151 HD22 LEU A 797     -15.361  40.188   2.014  1.00 10.00           H  
ATOM   1152 HD23 LEU A 797     -15.117  40.737   3.675  1.00 10.00           H  
ATOM   1153  N   GLN A 798     -13.012  37.636   7.015  1.00 10.00           N  
ATOM   1154  CA  GLN A 798     -13.441  36.769   8.103  1.00 10.00           C  
ATOM   1155  C   GLN A 798     -13.881  37.592   9.321  1.00 10.00           C  
ATOM   1156  O   GLN A 798     -14.843  37.221   9.983  1.00 10.00           O  
ATOM   1157  CB  GLN A 798     -12.347  35.747   8.435  1.00 10.00           C  
ATOM   1158  CG  GLN A 798     -12.228  34.723   7.295  1.00 10.00           C  
ATOM   1159  CD  GLN A 798     -11.091  33.728   7.512  1.00 10.00           C  
ATOM   1160  OE1 GLN A 798     -10.055  34.065   8.075  1.00 10.00           O  
ATOM   1161  NE2 GLN A 798     -11.268  32.489   7.058  1.00 10.00           N  
ATOM   1162  H   GLN A 798     -12.042  37.593   6.723  1.00 10.00           H  
ATOM   1163  HA  GLN A 798     -14.313  36.208   7.774  1.00 10.00           H  
ATOM   1164  HB2 GLN A 798     -11.397  36.259   8.590  1.00 10.00           H  
ATOM   1165  HB3 GLN A 798     -12.612  35.217   9.350  1.00 10.00           H  
ATOM   1166  HG2 GLN A 798     -13.170  34.180   7.219  1.00 10.00           H  
ATOM   1167  HG3 GLN A 798     -12.050  35.231   6.348  1.00 10.00           H  
ATOM   1168 HE21 GLN A 798     -12.147  32.220   6.624  1.00 10.00           H  
ATOM   1169 HE22 GLN A 798     -10.522  31.821   7.179  1.00 10.00           H  
ATOM   1170  N   ARG A 799     -13.228  38.722   9.602  1.00 10.00           N  
ATOM   1171  CA  ARG A 799     -13.648  39.643  10.648  1.00 10.00           C  
ATOM   1172  C   ARG A 799     -15.042  40.207  10.337  1.00 10.00           C  
ATOM   1173  O   ARG A 799     -15.876  40.245  11.232  1.00 10.00           O  
ATOM   1174  CB  ARG A 799     -12.600  40.744  10.877  1.00 10.00           C  
ATOM   1175  CG  ARG A 799     -12.716  41.383  12.265  1.00 10.00           C  
ATOM   1176  CD  ARG A 799     -12.070  42.775  12.311  1.00 10.00           C  
ATOM   1177  NE  ARG A 799     -10.704  42.799  11.768  1.00 10.00           N  
ATOM   1178  CZ  ARG A 799      -9.921  43.888  11.760  1.00 10.00           C  
ATOM   1179  NH1 ARG A 799     -10.346  45.022  12.331  1.00 10.00           N  
ATOM   1180  NH2 ARG A 799      -8.727  43.846  11.157  1.00 10.00           N  
ATOM   1181  H   ARG A 799     -12.387  38.936   9.080  1.00 10.00           H  
ATOM   1182  HA  ARG A 799     -13.710  39.064  11.570  1.00 10.00           H  
ATOM   1183  HB2 ARG A 799     -11.602  40.314  10.795  1.00 10.00           H  
ATOM   1184  HB3 ARG A 799     -12.712  41.525  10.132  1.00 10.00           H  
ATOM   1185  HG2 ARG A 799     -13.767  41.498  12.533  1.00 10.00           H  
ATOM   1186  HG3 ARG A 799     -12.243  40.729  12.999  1.00 10.00           H  
ATOM   1187  HD2 ARG A 799     -12.690  43.469  11.745  1.00 10.00           H  
ATOM   1188  HD3 ARG A 799     -12.052  43.100  13.348  1.00 10.00           H  
ATOM   1189  HE  ARG A 799     -10.356  41.945  11.356  1.00 10.00           H  
ATOM   1190 HH11 ARG A 799     -11.278  45.068  12.718  1.00 10.00           H  
ATOM   1191 HH12 ARG A 799      -9.758  45.842  12.355  1.00 10.00           H  
ATOM   1192 HH21 ARG A 799      -8.457  43.024  10.627  1.00 10.00           H  
ATOM   1193 HH22 ARG A 799      -8.121  44.661  11.082  1.00 10.00           H  
ATOM   1194  N   VAL A 800     -15.339  40.611   9.095  1.00 10.00           N  
ATOM   1195  CA  VAL A 800     -16.699  41.020   8.718  1.00 10.00           C  
ATOM   1196  C   VAL A 800     -17.687  39.898   9.061  1.00 10.00           C  
ATOM   1197  O   VAL A 800     -18.694  40.125   9.732  1.00 10.00           O  
ATOM   1198  CB  VAL A 800     -16.800  41.405   7.225  1.00 10.00           C  
ATOM   1199  CG1 VAL A 800     -18.246  41.741   6.827  1.00 10.00           C  
ATOM   1200  CG2 VAL A 800     -15.930  42.615   6.875  1.00 10.00           C  
ATOM   1201  H   VAL A 800     -14.606  40.587   8.392  1.00 10.00           H  
ATOM   1202  HA  VAL A 800     -16.969  41.894   9.312  1.00 10.00           H  
ATOM   1203  HB  VAL A 800     -16.483  40.570   6.604  1.00 10.00           H  
ATOM   1204 HG11 VAL A 800     -18.270  42.081   5.791  1.00 10.00           H  
ATOM   1205 HG12 VAL A 800     -18.887  40.863   6.907  1.00 10.00           H  
ATOM   1206 HG13 VAL A 800     -18.637  42.530   7.470  1.00 10.00           H  
ATOM   1207 HG21 VAL A 800     -14.901  42.450   7.185  1.00 10.00           H  
ATOM   1208 HG22 VAL A 800     -15.944  42.777   5.796  1.00 10.00           H  
ATOM   1209 HG23 VAL A 800     -16.323  43.504   7.367  1.00 10.00           H  
ATOM   1210  N   ILE A 801     -17.398  38.684   8.590  1.00 10.00           N  
ATOM   1211  CA  ILE A 801     -18.258  37.522   8.803  1.00 10.00           C  
ATOM   1212  C   ILE A 801     -18.477  37.288  10.308  1.00 10.00           C  
ATOM   1213  O   ILE A 801     -19.610  37.138  10.771  1.00 10.00           O  
ATOM   1214  CB  ILE A 801     -17.641  36.312   8.071  1.00 10.00           C  
ATOM   1215  CG1 ILE A 801     -17.737  36.522   6.546  1.00 10.00           C  
ATOM   1216  CG2 ILE A 801     -18.320  34.993   8.462  1.00 10.00           C  
ATOM   1217  CD1 ILE A 801     -16.678  35.735   5.768  1.00 10.00           C  
ATOM   1218  H   ILE A 801     -16.546  38.577   8.043  1.00 10.00           H  
ATOM   1219  HA  ILE A 801     -19.234  37.727   8.361  1.00 10.00           H  
ATOM   1220  HB  ILE A 801     -16.592  36.239   8.349  1.00 10.00           H  
ATOM   1221 HG12 ILE A 801     -18.731  36.230   6.204  1.00 10.00           H  
ATOM   1222 HG13 ILE A 801     -17.592  37.573   6.296  1.00 10.00           H  
ATOM   1223 HG21 ILE A 801     -19.395  35.055   8.296  1.00 10.00           H  
ATOM   1224 HG22 ILE A 801     -17.919  34.171   7.872  1.00 10.00           H  
ATOM   1225 HG23 ILE A 801     -18.133  34.771   9.513  1.00 10.00           H  
ATOM   1226 HD11 ILE A 801     -16.704  34.678   6.025  1.00 10.00           H  
ATOM   1227 HD12 ILE A 801     -16.863  35.850   4.702  1.00 10.00           H  
ATOM   1228 HD13 ILE A 801     -15.686  36.126   5.987  1.00 10.00           H  
ATOM   1229  N   ALA A 802     -17.386  37.270  11.075  1.00 10.00           N  
ATOM   1230  CA  ALA A 802     -17.405  37.094  12.518  1.00 10.00           C  
ATOM   1231  C   ALA A 802     -18.255  38.183  13.165  1.00 10.00           C  
ATOM   1232  O   ALA A 802     -19.235  37.870  13.831  1.00 10.00           O  
ATOM   1233  CB  ALA A 802     -15.975  37.083  13.067  1.00 10.00           C  
ATOM   1234  H   ALA A 802     -16.490  37.411  10.626  1.00 10.00           H  
ATOM   1235  HA  ALA A 802     -17.857  36.125  12.737  1.00 10.00           H  
ATOM   1236  HB1 ALA A 802     -15.397  36.299  12.578  1.00 10.00           H  
ATOM   1237  HB2 ALA A 802     -15.490  38.044  12.897  1.00 10.00           H  
ATOM   1238  HB3 ALA A 802     -15.998  36.882  14.139  1.00 10.00           H  
ATOM   1239  N   ASN A 803     -17.908  39.452  12.939  1.00 10.00           N  
ATOM   1240  CA  ASN A 803     -18.646  40.615  13.424  1.00 10.00           C  
ATOM   1241  C   ASN A 803     -20.139  40.429  13.178  1.00 10.00           C  
ATOM   1242  O   ASN A 803     -20.936  40.556  14.106  1.00 10.00           O  
ATOM   1243  CB  ASN A 803     -18.179  41.900  12.724  1.00 10.00           C  
ATOM   1244  CG  ASN A 803     -16.833  42.424  13.212  1.00 10.00           C  
ATOM   1245  OD1 ASN A 803     -16.033  41.707  13.804  1.00 10.00           O  
ATOM   1246  ND2 ASN A 803     -16.589  43.713  13.000  1.00 10.00           N  
ATOM   1247  H   ASN A 803     -17.081  39.622  12.383  1.00 10.00           H  
ATOM   1248  HA  ASN A 803     -18.484  40.716  14.498  1.00 10.00           H  
ATOM   1249  HB2 ASN A 803     -18.131  41.751  11.646  1.00 10.00           H  
ATOM   1250  HB3 ASN A 803     -18.920  42.675  12.921  1.00 10.00           H  
ATOM   1251 HD21 ASN A 803     -17.295  44.309  12.577  1.00 10.00           H  
ATOM   1252 HD22 ASN A 803     -15.690  44.084  13.296  1.00 10.00           H  
ATOM   1253  N   CYS A 804     -20.513  40.116  11.932  1.00 10.00           N  
ATOM   1254  CA  CYS A 804     -21.902  39.880  11.572  1.00 10.00           C  
ATOM   1255  C   CYS A 804     -22.528  38.823  12.480  1.00 10.00           C  
ATOM   1256  O   CYS A 804     -23.522  39.105  13.150  1.00 10.00           O  
ATOM   1257  CB  CYS A 804     -22.040  39.465  10.105  1.00 10.00           C  
ATOM   1258  SG  CYS A 804     -23.777  39.024   9.849  1.00 10.00           S  
ATOM   1259  H   CYS A 804     -19.801  40.021  11.212  1.00 10.00           H  
ATOM   1260  HA  CYS A 804     -22.441  40.818  11.704  1.00 10.00           H  
ATOM   1261  HB2 CYS A 804     -21.753  40.286   9.449  1.00 10.00           H  
ATOM   1262  HB3 CYS A 804     -21.428  38.596   9.881  1.00 10.00           H  
ATOM   1263  HG  CYS A 804     -23.695  38.656   8.568  1.00 10.00           H  
ATOM   1264  N   ARG A 805     -21.950  37.619  12.498  1.00 10.00           N  
ATOM   1265  CA  ARG A 805     -22.503  36.482  13.225  1.00 10.00           C  
ATOM   1266  C   ARG A 805     -22.543  36.725  14.738  1.00 10.00           C  
ATOM   1267  O   ARG A 805     -23.459  36.260  15.408  1.00 10.00           O  
ATOM   1268  CB  ARG A 805     -21.701  35.223  12.885  1.00 10.00           C  
ATOM   1269  CG  ARG A 805     -21.993  34.773  11.448  1.00 10.00           C  
ATOM   1270  CD  ARG A 805     -21.042  33.645  11.044  1.00 10.00           C  
ATOM   1271  NE  ARG A 805     -21.427  33.069   9.749  1.00 10.00           N  
ATOM   1272  CZ  ARG A 805     -20.634  32.306   8.980  1.00 10.00           C  
ATOM   1273  NH1 ARG A 805     -19.372  32.047   9.338  1.00 10.00           N  
ATOM   1274  NH2 ARG A 805     -21.099  31.793   7.840  1.00 10.00           N  
ATOM   1275  H   ARG A 805     -21.099  37.481  11.957  1.00 10.00           H  
ATOM   1276  HA  ARG A 805     -23.533  36.329  12.898  1.00 10.00           H  
ATOM   1277  HB2 ARG A 805     -20.636  35.424  13.007  1.00 10.00           H  
ATOM   1278  HB3 ARG A 805     -21.986  34.420  13.567  1.00 10.00           H  
ATOM   1279  HG2 ARG A 805     -23.026  34.428  11.391  1.00 10.00           H  
ATOM   1280  HG3 ARG A 805     -21.861  35.608  10.758  1.00 10.00           H  
ATOM   1281  HD2 ARG A 805     -20.035  34.061  10.995  1.00 10.00           H  
ATOM   1282  HD3 ARG A 805     -21.070  32.856  11.796  1.00 10.00           H  
ATOM   1283  HE  ARG A 805     -22.367  33.262   9.432  1.00 10.00           H  
ATOM   1284 HH11 ARG A 805     -19.010  32.390  10.214  1.00 10.00           H  
ATOM   1285 HH12 ARG A 805     -18.778  31.514   8.715  1.00 10.00           H  
ATOM   1286 HH21 ARG A 805     -22.077  31.893   7.570  1.00 10.00           H  
ATOM   1287 HH22 ARG A 805     -20.463  31.284   7.235  1.00 10.00           H  
ATOM   1288  N   GLU A 806     -21.548  37.428  15.282  1.00 10.00           N  
ATOM   1289  CA  GLU A 806     -21.500  37.800  16.688  1.00 10.00           C  
ATOM   1290  C   GLU A 806     -22.624  38.784  17.010  1.00 10.00           C  
ATOM   1291  O   GLU A 806     -23.346  38.616  17.989  1.00 10.00           O  
ATOM   1292  CB  GLU A 806     -20.147  38.452  17.004  1.00 10.00           C  
ATOM   1293  CG  GLU A 806     -18.985  37.454  17.016  1.00 10.00           C  
ATOM   1294  CD  GLU A 806     -17.655  38.192  17.138  1.00 10.00           C  
ATOM   1295  OE1 GLU A 806     -17.322  38.570  18.282  1.00 10.00           O  
ATOM   1296  OE2 GLU A 806     -17.009  38.386  16.085  1.00 10.00           O  
ATOM   1297  H   GLU A 806     -20.804  37.747  14.676  1.00 10.00           H  
ATOM   1298  HA  GLU A 806     -21.625  36.912  17.310  1.00 10.00           H  
ATOM   1299  HB2 GLU A 806     -19.944  39.232  16.269  1.00 10.00           H  
ATOM   1300  HB3 GLU A 806     -20.201  38.918  17.990  1.00 10.00           H  
ATOM   1301  HG2 GLU A 806     -19.097  36.778  17.864  1.00 10.00           H  
ATOM   1302  HG3 GLU A 806     -18.980  36.860  16.103  1.00 10.00           H  
ATOM   1303  N   TYR A 807     -22.713  39.859  16.225  1.00 10.00           N  
ATOM   1304  CA  TYR A 807     -23.584  40.981  16.532  1.00 10.00           C  
ATOM   1305  C   TYR A 807     -25.050  40.650  16.267  1.00 10.00           C  
ATOM   1306  O   TYR A 807     -25.921  40.959  17.079  1.00 10.00           O  
ATOM   1307  CB  TYR A 807     -23.141  42.195  15.710  1.00 10.00           C  
ATOM   1308  CG  TYR A 807     -23.890  43.463  16.054  1.00 10.00           C  
ATOM   1309  CD1 TYR A 807     -23.710  44.052  17.320  1.00 10.00           C  
ATOM   1310  CD2 TYR A 807     -24.814  44.015  15.148  1.00 10.00           C  
ATOM   1311  CE1 TYR A 807     -24.466  45.175  17.687  1.00 10.00           C  
ATOM   1312  CE2 TYR A 807     -25.553  45.154  15.509  1.00 10.00           C  
ATOM   1313  CZ  TYR A 807     -25.400  45.716  16.787  1.00 10.00           C  
ATOM   1314  OH  TYR A 807     -26.181  46.768  17.155  1.00 10.00           O  
ATOM   1315  H   TYR A 807     -22.082  39.945  15.434  1.00 10.00           H  
ATOM   1316  HA  TYR A 807     -23.470  41.222  17.590  1.00 10.00           H  
ATOM   1317  HB2 TYR A 807     -22.083  42.368  15.899  1.00 10.00           H  
ATOM   1318  HB3 TYR A 807     -23.258  41.973  14.648  1.00 10.00           H  
ATOM   1319  HD1 TYR A 807     -23.002  43.633  18.020  1.00 10.00           H  
ATOM   1320  HD2 TYR A 807     -24.971  43.562  14.180  1.00 10.00           H  
ATOM   1321  HE1 TYR A 807     -24.337  45.600  18.670  1.00 10.00           H  
ATOM   1322  HE2 TYR A 807     -26.277  45.567  14.823  1.00 10.00           H  
ATOM   1323  HH  TYR A 807     -26.092  46.978  18.092  1.00 10.00           H  
ATOM   1324  N   ASN A 808     -25.331  40.073  15.100  1.00 10.00           N  
ATOM   1325  CA  ASN A 808     -26.693  39.804  14.660  1.00 10.00           C  
ATOM   1326  C   ASN A 808     -27.166  38.490  15.276  1.00 10.00           C  
ATOM   1327  O   ASN A 808     -26.348  37.609  15.527  1.00 10.00           O  
ATOM   1328  CB  ASN A 808     -26.752  39.739  13.129  1.00 10.00           C  
ATOM   1329  CG  ASN A 808     -26.382  41.076  12.501  1.00 10.00           C  
ATOM   1330  OD1 ASN A 808     -27.237  41.919  12.258  1.00 10.00           O  
ATOM   1331  ND2 ASN A 808     -25.097  41.284  12.240  1.00 10.00           N  
ATOM   1332  H   ASN A 808     -24.563  39.746  14.524  1.00 10.00           H  
ATOM   1333  HA  ASN A 808     -27.329  40.626  14.993  1.00 10.00           H  
ATOM   1334  HB2 ASN A 808     -26.088  38.956  12.763  1.00 10.00           H  
ATOM   1335  HB3 ASN A 808     -27.764  39.490  12.814  1.00 10.00           H  
ATOM   1336 HD21 ASN A 808     -24.430  40.565  12.501  1.00 10.00           H  
ATOM   1337 HD22 ASN A 808     -24.807  42.151  11.819  1.00 10.00           H  
ATOM   1338  N   PRO A 809     -28.476  38.319  15.511  1.00 10.00           N  
ATOM   1339  CA  PRO A 809     -28.997  37.066  16.030  1.00 10.00           C  
ATOM   1340  C   PRO A 809     -28.660  35.913  15.072  1.00 10.00           C  
ATOM   1341  O   PRO A 809     -28.527  36.136  13.866  1.00 10.00           O  
ATOM   1342  CB  PRO A 809     -30.506  37.280  16.199  1.00 10.00           C  
ATOM   1343  CG  PRO A 809     -30.826  38.435  15.249  1.00 10.00           C  
ATOM   1344  CD  PRO A 809     -29.547  39.271  15.265  1.00 10.00           C  
ATOM   1345  HA  PRO A 809     -28.541  36.890  17.004  1.00 10.00           H  
ATOM   1346  HB2 PRO A 809     -31.088  36.386  15.967  1.00 10.00           H  
ATOM   1347  HB3 PRO A 809     -30.705  37.598  17.223  1.00 10.00           H  
ATOM   1348  HG2 PRO A 809     -30.983  38.043  14.245  1.00 10.00           H  
ATOM   1349  HG3 PRO A 809     -31.697  39.008  15.568  1.00 10.00           H  
ATOM   1350  HD2 PRO A 809     -29.443  39.803  14.320  1.00 10.00           H  
ATOM   1351  HD3 PRO A 809     -29.578  39.984  16.091  1.00 10.00           H  
ATOM   1352  N   PRO A 810     -28.500  34.687  15.592  1.00 10.00           N  
ATOM   1353  CA  PRO A 810     -28.072  33.540  14.809  1.00 10.00           C  
ATOM   1354  C   PRO A 810     -29.134  33.145  13.781  1.00 10.00           C  
ATOM   1355  O   PRO A 810     -30.330  33.305  14.018  1.00 10.00           O  
ATOM   1356  CB  PRO A 810     -27.823  32.421  15.825  1.00 10.00           C  
ATOM   1357  CG  PRO A 810     -28.758  32.783  16.979  1.00 10.00           C  
ATOM   1358  CD  PRO A 810     -28.709  34.310  16.979  1.00 10.00           C  
ATOM   1359  HA  PRO A 810     -27.135  33.775  14.305  1.00 10.00           H  
ATOM   1360  HB2 PRO A 810     -28.031  31.429  15.420  1.00 10.00           H  
ATOM   1361  HB3 PRO A 810     -26.790  32.474  16.171  1.00 10.00           H  
ATOM   1362  HG2 PRO A 810     -29.770  32.453  16.741  1.00 10.00           H  
ATOM   1363  HG3 PRO A 810     -28.433  32.355  17.928  1.00 10.00           H  
ATOM   1364  HD2 PRO A 810     -29.638  34.715  17.384  1.00 10.00           H  
ATOM   1365  HD3 PRO A 810     -27.857  34.648  17.573  1.00 10.00           H  
ATOM   1366  N   ASP A 811     -28.681  32.613  12.641  1.00 10.00           N  
ATOM   1367  CA  ASP A 811     -29.521  32.138  11.545  1.00 10.00           C  
ATOM   1368  C   ASP A 811     -30.525  33.207  11.096  1.00 10.00           C  
ATOM   1369  O   ASP A 811     -31.683  32.913  10.795  1.00 10.00           O  
ATOM   1370  CB  ASP A 811     -30.183  30.803  11.919  1.00 10.00           C  
ATOM   1371  CG  ASP A 811     -30.867  30.135  10.728  1.00 10.00           C  
ATOM   1372  OD1 ASP A 811     -30.257  30.145   9.635  1.00 10.00           O  
ATOM   1373  OD2 ASP A 811     -31.987  29.615  10.928  1.00 10.00           O  
ATOM   1374  H   ASP A 811     -27.680  32.576  12.511  1.00 10.00           H  
ATOM   1375  HA  ASP A 811     -28.849  31.960  10.704  1.00 10.00           H  
ATOM   1376  HB2 ASP A 811     -29.424  30.116  12.296  1.00 10.00           H  
ATOM   1377  HB3 ASP A 811     -30.920  30.974  12.705  1.00 10.00           H  
ATOM   1378  N   SER A 812     -30.057  34.452  11.022  1.00 10.00           N  
ATOM   1379  CA  SER A 812     -30.786  35.585  10.486  1.00 10.00           C  
ATOM   1380  C   SER A 812     -30.441  35.790   9.012  1.00 10.00           C  
ATOM   1381  O   SER A 812     -29.509  35.175   8.490  1.00 10.00           O  
ATOM   1382  CB  SER A 812     -30.353  36.808  11.292  1.00 10.00           C  
ATOM   1383  OG  SER A 812     -28.935  36.902  11.282  1.00 10.00           O  
ATOM   1384  H   SER A 812     -29.114  34.636  11.331  1.00 10.00           H  
ATOM   1385  HA  SER A 812     -31.863  35.441  10.592  1.00 10.00           H  
ATOM   1386  HB2 SER A 812     -30.805  37.714  10.885  1.00 10.00           H  
ATOM   1387  HB3 SER A 812     -30.698  36.682  12.319  1.00 10.00           H  
ATOM   1388  HG  SER A 812     -28.647  36.796  12.201  1.00 10.00           H  
ATOM   1389  N   GLU A 813     -31.135  36.729   8.363  1.00 10.00           N  
ATOM   1390  CA  GLU A 813     -30.789  37.199   7.027  1.00 10.00           C  
ATOM   1391  C   GLU A 813     -29.320  37.621   7.005  1.00 10.00           C  
ATOM   1392  O   GLU A 813     -28.600  37.315   6.060  1.00 10.00           O  
ATOM   1393  CB  GLU A 813     -31.681  38.385   6.625  1.00 10.00           C  
ATOM   1394  CG  GLU A 813     -33.126  37.980   6.287  1.00 10.00           C  
ATOM   1395  CD  GLU A 813     -33.865  37.324   7.448  1.00 10.00           C  
ATOM   1396  OE1 GLU A 813     -33.692  37.812   8.587  1.00 10.00           O  
ATOM   1397  OE2 GLU A 813     -34.545  36.309   7.184  1.00 10.00           O  
ATOM   1398  H   GLU A 813     -31.913  37.177   8.831  1.00 10.00           H  
ATOM   1399  HA  GLU A 813     -30.928  36.386   6.311  1.00 10.00           H  
ATOM   1400  HB2 GLU A 813     -31.682  39.139   7.415  1.00 10.00           H  
ATOM   1401  HB3 GLU A 813     -31.257  38.841   5.729  1.00 10.00           H  
ATOM   1402  HG2 GLU A 813     -33.681  38.872   5.997  1.00 10.00           H  
ATOM   1403  HG3 GLU A 813     -33.113  37.295   5.439  1.00 10.00           H  
ATOM   1404  N   TYR A 814     -28.877  38.316   8.055  1.00 10.00           N  
ATOM   1405  CA  TYR A 814     -27.500  38.753   8.208  1.00 10.00           C  
ATOM   1406  C   TYR A 814     -26.551  37.551   8.231  1.00 10.00           C  
ATOM   1407  O   TYR A 814     -25.545  37.545   7.521  1.00 10.00           O  
ATOM   1408  CB  TYR A 814     -27.372  39.593   9.483  1.00 10.00           C  
ATOM   1409  CG  TYR A 814     -28.327  40.767   9.545  1.00 10.00           C  
ATOM   1410  CD1 TYR A 814     -28.064  41.921   8.786  1.00 10.00           C  
ATOM   1411  CD2 TYR A 814     -29.473  40.712  10.361  1.00 10.00           C  
ATOM   1412  CE1 TYR A 814     -28.947  43.014   8.834  1.00 10.00           C  
ATOM   1413  CE2 TYR A 814     -30.357  41.802  10.406  1.00 10.00           C  
ATOM   1414  CZ  TYR A 814     -30.084  42.960   9.658  1.00 10.00           C  
ATOM   1415  OH  TYR A 814     -30.944  44.014   9.715  1.00 10.00           O  
ATOM   1416  H   TYR A 814     -29.526  38.529   8.796  1.00 10.00           H  
ATOM   1417  HA  TYR A 814     -27.242  39.383   7.356  1.00 10.00           H  
ATOM   1418  HB2 TYR A 814     -27.524  38.954  10.353  1.00 10.00           H  
ATOM   1419  HB3 TYR A 814     -26.362  39.992   9.536  1.00 10.00           H  
ATOM   1420  HD1 TYR A 814     -27.178  41.970   8.170  1.00 10.00           H  
ATOM   1421  HD2 TYR A 814     -29.668  39.843  10.971  1.00 10.00           H  
ATOM   1422  HE1 TYR A 814     -28.731  43.899   8.254  1.00 10.00           H  
ATOM   1423  HE2 TYR A 814     -31.231  41.766  11.039  1.00 10.00           H  
ATOM   1424  HH  TYR A 814     -30.648  44.770   9.203  1.00 10.00           H  
ATOM   1425  N   CYS A 815     -26.871  36.527   9.031  1.00 10.00           N  
ATOM   1426  CA  CYS A 815     -26.058  35.310   9.074  1.00 10.00           C  
ATOM   1427  C   CYS A 815     -26.012  34.655   7.696  1.00 10.00           C  
ATOM   1428  O   CYS A 815     -24.937  34.307   7.207  1.00 10.00           O  
ATOM   1429  CB  CYS A 815     -26.588  34.298  10.094  1.00 10.00           C  
ATOM   1430  SG  CYS A 815     -26.250  34.854  11.777  1.00 10.00           S  
ATOM   1431  H   CYS A 815     -27.718  36.582   9.589  1.00 10.00           H  
ATOM   1432  HA  CYS A 815     -25.040  35.576   9.362  1.00 10.00           H  
ATOM   1433  HB2 CYS A 815     -27.650  34.128   9.949  1.00 10.00           H  
ATOM   1434  HB3 CYS A 815     -26.063  33.350   9.961  1.00 10.00           H  
ATOM   1435  HG  CYS A 815     -26.966  35.981  11.721  1.00 10.00           H  
ATOM   1436  N   ARG A 816     -27.172  34.478   7.058  1.00 10.00           N  
ATOM   1437  CA  ARG A 816     -27.251  33.903   5.723  1.00 10.00           C  
ATOM   1438  C   ARG A 816     -26.396  34.703   4.744  1.00 10.00           C  
ATOM   1439  O   ARG A 816     -25.601  34.126   4.005  1.00 10.00           O  
ATOM   1440  CB  ARG A 816     -28.711  33.807   5.259  1.00 10.00           C  
ATOM   1441  CG  ARG A 816     -29.411  32.624   5.935  1.00 10.00           C  
ATOM   1442  CD  ARG A 816     -30.874  32.494   5.487  1.00 10.00           C  
ATOM   1443  NE  ARG A 816     -31.761  33.427   6.197  1.00 10.00           N  
ATOM   1444  CZ  ARG A 816     -32.168  33.256   7.465  1.00 10.00           C  
ATOM   1445  NH1 ARG A 816     -31.701  32.243   8.195  1.00 10.00           N  
ATOM   1446  NH2 ARG A 816     -33.048  34.094   8.019  1.00 10.00           N  
ATOM   1447  H   ARG A 816     -28.030  34.770   7.516  1.00 10.00           H  
ATOM   1448  HA  ARG A 816     -26.824  32.901   5.757  1.00 10.00           H  
ATOM   1449  HB2 ARG A 816     -29.240  34.734   5.476  1.00 10.00           H  
ATOM   1450  HB3 ARG A 816     -28.725  33.641   4.180  1.00 10.00           H  
ATOM   1451  HG2 ARG A 816     -28.887  31.709   5.652  1.00 10.00           H  
ATOM   1452  HG3 ARG A 816     -29.349  32.734   7.019  1.00 10.00           H  
ATOM   1453  HD2 ARG A 816     -30.948  32.674   4.413  1.00 10.00           H  
ATOM   1454  HD3 ARG A 816     -31.218  31.474   5.666  1.00 10.00           H  
ATOM   1455  HE  ARG A 816     -32.124  34.208   5.669  1.00 10.00           H  
ATOM   1456 HH11 ARG A 816     -31.047  31.578   7.809  1.00 10.00           H  
ATOM   1457 HH12 ARG A 816     -31.923  32.195   9.188  1.00 10.00           H  
ATOM   1458 HH21 ARG A 816     -33.501  34.822   7.475  1.00 10.00           H  
ATOM   1459 HH22 ARG A 816     -33.342  33.941   8.974  1.00 10.00           H  
ATOM   1460  N   CYS A 817     -26.521  36.030   4.763  1.00 10.00           N  
ATOM   1461  CA  CYS A 817     -25.730  36.907   3.913  1.00 10.00           C  
ATOM   1462  C   CYS A 817     -24.243  36.683   4.169  1.00 10.00           C  
ATOM   1463  O   CYS A 817     -23.477  36.496   3.226  1.00 10.00           O  
ATOM   1464  CB  CYS A 817     -26.098  38.379   4.134  1.00 10.00           C  
ATOM   1465  SG  CYS A 817     -27.681  38.762   3.353  1.00 10.00           S  
ATOM   1466  H   CYS A 817     -27.174  36.444   5.417  1.00 10.00           H  
ATOM   1467  HA  CYS A 817     -25.941  36.647   2.874  1.00 10.00           H  
ATOM   1468  HB2 CYS A 817     -26.149  38.608   5.197  1.00 10.00           H  
ATOM   1469  HB3 CYS A 817     -25.346  39.014   3.671  1.00 10.00           H  
ATOM   1470  HG  CYS A 817     -28.402  37.890   4.064  1.00 10.00           H  
ATOM   1471  N   ALA A 818     -23.827  36.670   5.438  1.00 10.00           N  
ATOM   1472  CA  ALA A 818     -22.436  36.418   5.798  1.00 10.00           C  
ATOM   1473  C   ALA A 818     -21.977  35.043   5.312  1.00 10.00           C  
ATOM   1474  O   ALA A 818     -20.848  34.890   4.855  1.00 10.00           O  
ATOM   1475  CB  ALA A 818     -22.247  36.556   7.309  1.00 10.00           C  
ATOM   1476  H   ALA A 818     -24.511  36.786   6.180  1.00 10.00           H  
ATOM   1477  HA  ALA A 818     -21.812  37.174   5.319  1.00 10.00           H  
ATOM   1478  HB1 ALA A 818     -21.221  36.306   7.571  1.00 10.00           H  
ATOM   1479  HB2 ALA A 818     -22.432  37.588   7.595  1.00 10.00           H  
ATOM   1480  HB3 ALA A 818     -22.924  35.894   7.847  1.00 10.00           H  
ATOM   1481  N   SER A 819     -22.843  34.036   5.390  1.00 10.00           N  
ATOM   1482  CA  SER A 819     -22.520  32.693   4.936  1.00 10.00           C  
ATOM   1483  C   SER A 819     -22.365  32.641   3.415  1.00 10.00           C  
ATOM   1484  O   SER A 819     -21.413  32.047   2.908  1.00 10.00           O  
ATOM   1485  CB  SER A 819     -23.570  31.707   5.452  1.00 10.00           C  
ATOM   1486  OG  SER A 819     -23.686  31.849   6.857  1.00 10.00           O  
ATOM   1487  H   SER A 819     -23.754  34.213   5.797  1.00 10.00           H  
ATOM   1488  HA  SER A 819     -21.558  32.412   5.361  1.00 10.00           H  
ATOM   1489  HB2 SER A 819     -24.536  31.890   4.978  1.00 10.00           H  
ATOM   1490  HB3 SER A 819     -23.251  30.690   5.216  1.00 10.00           H  
ATOM   1491  HG  SER A 819     -24.139  32.682   7.050  1.00 10.00           H  
ATOM   1492  N   ALA A 820     -23.288  33.258   2.676  1.00 10.00           N  
ATOM   1493  CA  ALA A 820     -23.181  33.375   1.229  1.00 10.00           C  
ATOM   1494  C   ALA A 820     -21.887  34.105   0.863  1.00 10.00           C  
ATOM   1495  O   ALA A 820     -21.114  33.626   0.035  1.00 10.00           O  
ATOM   1496  CB  ALA A 820     -24.419  34.085   0.677  1.00 10.00           C  
ATOM   1497  H   ALA A 820     -24.053  33.734   3.144  1.00 10.00           H  
ATOM   1498  HA  ALA A 820     -23.147  32.378   0.791  1.00 10.00           H  
ATOM   1499  HB1 ALA A 820     -24.518  35.070   1.128  1.00 10.00           H  
ATOM   1500  HB2 ALA A 820     -24.332  34.188  -0.404  1.00 10.00           H  
ATOM   1501  HB3 ALA A 820     -25.310  33.501   0.909  1.00 10.00           H  
ATOM   1502  N   LEU A 821     -21.632  35.236   1.528  1.00 10.00           N  
ATOM   1503  CA  LEU A 821     -20.407  36.007   1.381  1.00 10.00           C  
ATOM   1504  C   LEU A 821     -19.189  35.110   1.605  1.00 10.00           C  
ATOM   1505  O   LEU A 821     -18.283  35.091   0.780  1.00 10.00           O  
ATOM   1506  CB  LEU A 821     -20.426  37.190   2.361  1.00 10.00           C  
ATOM   1507  CG  LEU A 821     -19.255  38.168   2.179  1.00 10.00           C  
ATOM   1508  CD1 LEU A 821     -19.475  39.046   0.945  1.00 10.00           C  
ATOM   1509  CD2 LEU A 821     -19.138  39.058   3.421  1.00 10.00           C  
ATOM   1510  H   LEU A 821     -22.313  35.552   2.210  1.00 10.00           H  
ATOM   1511  HA  LEU A 821     -20.371  36.387   0.361  1.00 10.00           H  
ATOM   1512  HB2 LEU A 821     -21.360  37.742   2.250  1.00 10.00           H  
ATOM   1513  HB3 LEU A 821     -20.383  36.800   3.374  1.00 10.00           H  
ATOM   1514  HG  LEU A 821     -18.316  37.624   2.070  1.00 10.00           H  
ATOM   1515 HD11 LEU A 821     -20.453  39.526   0.989  1.00 10.00           H  
ATOM   1516 HD12 LEU A 821     -18.710  39.818   0.929  1.00 10.00           H  
ATOM   1517 HD13 LEU A 821     -19.400  38.457   0.033  1.00 10.00           H  
ATOM   1518 HD21 LEU A 821     -20.062  39.613   3.568  1.00 10.00           H  
ATOM   1519 HD22 LEU A 821     -18.948  38.445   4.302  1.00 10.00           H  
ATOM   1520 HD23 LEU A 821     -18.312  39.759   3.300  1.00 10.00           H  
ATOM   1521  N   GLU A 822     -19.171  34.361   2.711  1.00 10.00           N  
ATOM   1522  CA  GLU A 822     -18.093  33.456   3.074  1.00 10.00           C  
ATOM   1523  C   GLU A 822     -17.844  32.431   1.965  1.00 10.00           C  
ATOM   1524  O   GLU A 822     -16.724  32.306   1.471  1.00 10.00           O  
ATOM   1525  CB  GLU A 822     -18.418  32.786   4.419  1.00 10.00           C  
ATOM   1526  CG  GLU A 822     -17.255  31.906   4.890  1.00 10.00           C  
ATOM   1527  CD  GLU A 822     -17.418  31.410   6.324  1.00 10.00           C  
ATOM   1528  OE1 GLU A 822     -18.573  31.129   6.712  1.00 10.00           O  
ATOM   1529  OE2 GLU A 822     -16.373  31.307   7.004  1.00 10.00           O  
ATOM   1530  H   GLU A 822     -19.946  34.453   3.358  1.00 10.00           H  
ATOM   1531  HA  GLU A 822     -17.185  34.049   3.194  1.00 10.00           H  
ATOM   1532  HB2 GLU A 822     -18.603  33.557   5.168  1.00 10.00           H  
ATOM   1533  HB3 GLU A 822     -19.313  32.171   4.331  1.00 10.00           H  
ATOM   1534  HG2 GLU A 822     -17.179  31.035   4.240  1.00 10.00           H  
ATOM   1535  HG3 GLU A 822     -16.334  32.484   4.826  1.00 10.00           H  
ATOM   1536  N   LYS A 823     -18.885  31.694   1.571  1.00 10.00           N  
ATOM   1537  CA  LYS A 823     -18.759  30.679   0.535  1.00 10.00           C  
ATOM   1538  C   LYS A 823     -18.276  31.296  -0.778  1.00 10.00           C  
ATOM   1539  O   LYS A 823     -17.339  30.790  -1.392  1.00 10.00           O  
ATOM   1540  CB  LYS A 823     -20.080  29.929   0.364  1.00 10.00           C  
ATOM   1541  CG  LYS A 823     -20.358  29.057   1.597  1.00 10.00           C  
ATOM   1542  CD  LYS A 823     -21.535  28.101   1.363  1.00 10.00           C  
ATOM   1543  CE  LYS A 823     -22.817  28.831   0.951  1.00 10.00           C  
ATOM   1544  NZ  LYS A 823     -23.233  29.816   1.965  1.00 10.00           N  
ATOM   1545  H   LYS A 823     -19.793  31.858   1.998  1.00 10.00           H  
ATOM   1546  HA  LYS A 823     -18.015  29.948   0.846  1.00 10.00           H  
ATOM   1547  HB2 LYS A 823     -20.877  30.657   0.210  1.00 10.00           H  
ATOM   1548  HB3 LYS A 823     -20.005  29.286  -0.514  1.00 10.00           H  
ATOM   1549  HG2 LYS A 823     -19.479  28.446   1.811  1.00 10.00           H  
ATOM   1550  HG3 LYS A 823     -20.546  29.685   2.467  1.00 10.00           H  
ATOM   1551  HD2 LYS A 823     -21.268  27.393   0.576  1.00 10.00           H  
ATOM   1552  HD3 LYS A 823     -21.719  27.537   2.280  1.00 10.00           H  
ATOM   1553  HE2 LYS A 823     -22.656  29.336  -0.000  1.00 10.00           H  
ATOM   1554  HE3 LYS A 823     -23.615  28.100   0.820  1.00 10.00           H  
ATOM   1555  HZ1 LYS A 823     -24.078  30.279   1.660  1.00 10.00           H  
ATOM   1556  HZ2 LYS A 823     -23.403  29.348   2.842  1.00 10.00           H  
ATOM   1557  HZ3 LYS A 823     -22.501  30.505   2.087  1.00 10.00           H  
ATOM   1558  N   PHE A 824     -18.896  32.400  -1.203  1.00 10.00           N  
ATOM   1559  CA  PHE A 824     -18.494  33.118  -2.406  1.00 10.00           C  
ATOM   1560  C   PHE A 824     -17.019  33.516  -2.322  1.00 10.00           C  
ATOM   1561  O   PHE A 824     -16.245  33.276  -3.244  1.00 10.00           O  
ATOM   1562  CB  PHE A 824     -19.391  34.344  -2.601  1.00 10.00           C  
ATOM   1563  CG  PHE A 824     -19.002  35.185  -3.800  1.00 10.00           C  
ATOM   1564  CD1 PHE A 824     -19.391  34.792  -5.094  1.00 10.00           C  
ATOM   1565  CD2 PHE A 824     -18.151  36.295  -3.635  1.00 10.00           C  
ATOM   1566  CE1 PHE A 824     -18.971  35.531  -6.212  1.00 10.00           C  
ATOM   1567  CE2 PHE A 824     -17.718  37.025  -4.754  1.00 10.00           C  
ATOM   1568  CZ  PHE A 824     -18.144  36.656  -6.042  1.00 10.00           C  
ATOM   1569  H   PHE A 824     -19.654  32.776  -0.643  1.00 10.00           H  
ATOM   1570  HA  PHE A 824     -18.629  32.458  -3.263  1.00 10.00           H  
ATOM   1571  HB2 PHE A 824     -20.417  34.001  -2.722  1.00 10.00           H  
ATOM   1572  HB3 PHE A 824     -19.361  34.966  -1.705  1.00 10.00           H  
ATOM   1573  HD1 PHE A 824     -20.005  33.914  -5.235  1.00 10.00           H  
ATOM   1574  HD2 PHE A 824     -17.820  36.585  -2.648  1.00 10.00           H  
ATOM   1575  HE1 PHE A 824     -19.274  35.231  -7.205  1.00 10.00           H  
ATOM   1576  HE2 PHE A 824     -17.069  37.877  -4.622  1.00 10.00           H  
ATOM   1577  HZ  PHE A 824     -17.842  37.235  -6.903  1.00 10.00           H  
ATOM   1578  N   PHE A 825     -16.628  34.121  -1.204  1.00 10.00           N  
ATOM   1579  CA  PHE A 825     -15.269  34.566  -0.962  1.00 10.00           C  
ATOM   1580  C   PHE A 825     -14.295  33.397  -1.111  1.00 10.00           C  
ATOM   1581  O   PHE A 825     -13.358  33.456  -1.904  1.00 10.00           O  
ATOM   1582  CB  PHE A 825     -15.192  35.196   0.434  1.00 10.00           C  
ATOM   1583  CG  PHE A 825     -13.825  35.711   0.822  1.00 10.00           C  
ATOM   1584  CD1 PHE A 825     -13.142  36.610  -0.019  1.00 10.00           C  
ATOM   1585  CD2 PHE A 825     -13.250  35.319   2.044  1.00 10.00           C  
ATOM   1586  CE1 PHE A 825     -11.889  37.109   0.362  1.00 10.00           C  
ATOM   1587  CE2 PHE A 825     -11.984  35.798   2.411  1.00 10.00           C  
ATOM   1588  CZ  PHE A 825     -11.302  36.689   1.565  1.00 10.00           C  
ATOM   1589  H   PHE A 825     -17.316  34.270  -0.476  1.00 10.00           H  
ATOM   1590  HA  PHE A 825     -15.030  35.319  -1.714  1.00 10.00           H  
ATOM   1591  HB2 PHE A 825     -15.893  36.028   0.495  1.00 10.00           H  
ATOM   1592  HB3 PHE A 825     -15.510  34.459   1.168  1.00 10.00           H  
ATOM   1593  HD1 PHE A 825     -13.570  36.932  -0.956  1.00 10.00           H  
ATOM   1594  HD2 PHE A 825     -13.781  34.652   2.708  1.00 10.00           H  
ATOM   1595  HE1 PHE A 825     -11.384  37.824  -0.267  1.00 10.00           H  
ATOM   1596  HE2 PHE A 825     -11.542  35.489   3.347  1.00 10.00           H  
ATOM   1597  HZ  PHE A 825     -10.330  37.058   1.834  1.00 10.00           H  
ATOM   1598  N   TYR A 826     -14.531  32.314  -0.368  1.00 10.00           N  
ATOM   1599  CA  TYR A 826     -13.679  31.137  -0.443  1.00 10.00           C  
ATOM   1600  C   TYR A 826     -13.673  30.550  -1.859  1.00 10.00           C  
ATOM   1601  O   TYR A 826     -12.633  30.096  -2.333  1.00 10.00           O  
ATOM   1602  CB  TYR A 826     -14.104  30.114   0.619  1.00 10.00           C  
ATOM   1603  CG  TYR A 826     -14.021  30.558   2.076  1.00 10.00           C  
ATOM   1604  CD1 TYR A 826     -13.246  31.669   2.476  1.00 10.00           C  
ATOM   1605  CD2 TYR A 826     -14.676  29.789   3.056  1.00 10.00           C  
ATOM   1606  CE1 TYR A 826     -13.144  32.010   3.836  1.00 10.00           C  
ATOM   1607  CE2 TYR A 826     -14.577  30.135   4.416  1.00 10.00           C  
ATOM   1608  CZ  TYR A 826     -13.835  31.264   4.800  1.00 10.00           C  
ATOM   1609  OH  TYR A 826     -13.821  31.675   6.101  1.00 10.00           O  
ATOM   1610  H   TYR A 826     -15.331  32.303   0.259  1.00 10.00           H  
ATOM   1611  HA  TYR A 826     -12.650  31.434  -0.244  1.00 10.00           H  
ATOM   1612  HB2 TYR A 826     -15.133  29.815   0.408  1.00 10.00           H  
ATOM   1613  HB3 TYR A 826     -13.469  29.234   0.509  1.00 10.00           H  
ATOM   1614  HD1 TYR A 826     -12.725  32.283   1.761  1.00 10.00           H  
ATOM   1615  HD2 TYR A 826     -15.259  28.927   2.766  1.00 10.00           H  
ATOM   1616  HE1 TYR A 826     -12.548  32.860   4.136  1.00 10.00           H  
ATOM   1617  HE2 TYR A 826     -15.088  29.538   5.157  1.00 10.00           H  
ATOM   1618  HH  TYR A 826     -14.595  31.359   6.588  1.00 10.00           H  
ATOM   1619  N   PHE A 827     -14.816  30.556  -2.550  1.00 10.00           N  
ATOM   1620  CA  PHE A 827     -14.877  30.176  -3.955  1.00 10.00           C  
ATOM   1621  C   PHE A 827     -13.917  31.039  -4.782  1.00 10.00           C  
ATOM   1622  O   PHE A 827     -13.079  30.496  -5.500  1.00 10.00           O  
ATOM   1623  CB  PHE A 827     -16.322  30.226  -4.466  1.00 10.00           C  
ATOM   1624  CG  PHE A 827     -16.455  30.058  -5.965  1.00 10.00           C  
ATOM   1625  CD1 PHE A 827     -16.255  28.796  -6.554  1.00 10.00           C  
ATOM   1626  CD2 PHE A 827     -16.728  31.175  -6.777  1.00 10.00           C  
ATOM   1627  CE1 PHE A 827     -16.361  28.645  -7.947  1.00 10.00           C  
ATOM   1628  CE2 PHE A 827     -16.843  31.021  -8.169  1.00 10.00           C  
ATOM   1629  CZ  PHE A 827     -16.666  29.755  -8.754  1.00 10.00           C  
ATOM   1630  H   PHE A 827     -15.657  30.907  -2.102  1.00 10.00           H  
ATOM   1631  HA  PHE A 827     -14.541  29.143  -4.046  1.00 10.00           H  
ATOM   1632  HB2 PHE A 827     -16.898  29.442  -3.970  1.00 10.00           H  
ATOM   1633  HB3 PHE A 827     -16.778  31.170  -4.193  1.00 10.00           H  
ATOM   1634  HD1 PHE A 827     -16.023  27.939  -5.940  1.00 10.00           H  
ATOM   1635  HD2 PHE A 827     -16.854  32.156  -6.338  1.00 10.00           H  
ATOM   1636  HE1 PHE A 827     -16.208  27.675  -8.398  1.00 10.00           H  
ATOM   1637  HE2 PHE A 827     -17.054  31.879  -8.792  1.00 10.00           H  
ATOM   1638  HZ  PHE A 827     -16.750  29.639  -9.825  1.00 10.00           H  
ATOM   1639  N   LYS A 828     -13.988  32.368  -4.658  1.00 10.00           N  
ATOM   1640  CA  LYS A 828     -13.058  33.255  -5.347  1.00 10.00           C  
ATOM   1641  C   LYS A 828     -11.606  32.900  -5.011  1.00 10.00           C  
ATOM   1642  O   LYS A 828     -10.783  32.781  -5.917  1.00 10.00           O  
ATOM   1643  CB  LYS A 828     -13.345  34.734  -5.040  1.00 10.00           C  
ATOM   1644  CG  LYS A 828     -14.690  35.252  -5.571  1.00 10.00           C  
ATOM   1645  CD  LYS A 828     -14.908  35.047  -7.076  1.00 10.00           C  
ATOM   1646  CE  LYS A 828     -13.751  35.590  -7.922  1.00 10.00           C  
ATOM   1647  NZ  LYS A 828     -14.074  35.522  -9.356  1.00 10.00           N  
ATOM   1648  H   LYS A 828     -14.679  32.770  -4.032  1.00 10.00           H  
ATOM   1649  HA  LYS A 828     -13.176  33.087  -6.417  1.00 10.00           H  
ATOM   1650  HB2 LYS A 828     -13.316  34.895  -3.964  1.00 10.00           H  
ATOM   1651  HB3 LYS A 828     -12.548  35.335  -5.480  1.00 10.00           H  
ATOM   1652  HG2 LYS A 828     -15.506  34.762  -5.042  1.00 10.00           H  
ATOM   1653  HG3 LYS A 828     -14.750  36.319  -5.350  1.00 10.00           H  
ATOM   1654  HD2 LYS A 828     -15.055  33.987  -7.284  1.00 10.00           H  
ATOM   1655  HD3 LYS A 828     -15.824  35.567  -7.360  1.00 10.00           H  
ATOM   1656  HE2 LYS A 828     -13.553  36.626  -7.650  1.00 10.00           H  
ATOM   1657  HE3 LYS A 828     -12.849  34.999  -7.754  1.00 10.00           H  
ATOM   1658  HZ1 LYS A 828     -14.883  36.103  -9.548  1.00 10.00           H  
ATOM   1659  HZ2 LYS A 828     -13.289  35.853  -9.899  1.00 10.00           H  
ATOM   1660  HZ3 LYS A 828     -14.272  34.561  -9.604  1.00 10.00           H  
ATOM   1661  N   LEU A 829     -11.284  32.708  -3.727  1.00 10.00           N  
ATOM   1662  CA  LEU A 829      -9.940  32.288  -3.334  1.00 10.00           C  
ATOM   1663  C   LEU A 829      -9.535  31.003  -4.065  1.00 10.00           C  
ATOM   1664  O   LEU A 829      -8.436  30.932  -4.608  1.00 10.00           O  
ATOM   1665  CB  LEU A 829      -9.815  32.108  -1.814  1.00 10.00           C  
ATOM   1666  CG  LEU A 829     -10.039  33.386  -0.986  1.00 10.00           C  
ATOM   1667  CD1 LEU A 829      -9.899  33.038   0.499  1.00 10.00           C  
ATOM   1668  CD2 LEU A 829      -9.045  34.500  -1.335  1.00 10.00           C  
ATOM   1669  H   LEU A 829     -12.001  32.841  -3.017  1.00 10.00           H  
ATOM   1670  HA  LEU A 829      -9.238  33.059  -3.650  1.00 10.00           H  
ATOM   1671  HB2 LEU A 829     -10.524  31.347  -1.492  1.00 10.00           H  
ATOM   1672  HB3 LEU A 829      -8.810  31.739  -1.601  1.00 10.00           H  
ATOM   1673  HG  LEU A 829     -11.045  33.762  -1.151  1.00 10.00           H  
ATOM   1674 HD11 LEU A 829      -8.868  32.768   0.727  1.00 10.00           H  
ATOM   1675 HD12 LEU A 829     -10.188  33.897   1.104  1.00 10.00           H  
ATOM   1676 HD13 LEU A 829     -10.548  32.201   0.752  1.00 10.00           H  
ATOM   1677 HD21 LEU A 829      -9.164  35.326  -0.632  1.00 10.00           H  
ATOM   1678 HD22 LEU A 829      -8.024  34.125  -1.276  1.00 10.00           H  
ATOM   1679 HD23 LEU A 829      -9.237  34.877  -2.340  1.00 10.00           H  
ATOM   1680  N   LYS A 830     -10.412  29.994  -4.100  1.00 10.00           N  
ATOM   1681  CA  LYS A 830     -10.136  28.757  -4.823  1.00 10.00           C  
ATOM   1682  C   LYS A 830      -9.939  29.005  -6.323  1.00 10.00           C  
ATOM   1683  O   LYS A 830      -9.042  28.410  -6.918  1.00 10.00           O  
ATOM   1684  CB  LYS A 830     -11.225  27.708  -4.556  1.00 10.00           C  
ATOM   1685  CG  LYS A 830     -11.105  27.145  -3.132  1.00 10.00           C  
ATOM   1686  CD  LYS A 830     -12.042  25.951  -2.892  1.00 10.00           C  
ATOM   1687  CE  LYS A 830     -13.530  26.308  -2.979  1.00 10.00           C  
ATOM   1688  NZ  LYS A 830     -13.899  27.342  -1.998  1.00 10.00           N  
ATOM   1689  H   LYS A 830     -11.310  30.102  -3.639  1.00 10.00           H  
ATOM   1690  HA  LYS A 830      -9.190  28.355  -4.454  1.00 10.00           H  
ATOM   1691  HB2 LYS A 830     -12.206  28.152  -4.717  1.00 10.00           H  
ATOM   1692  HB3 LYS A 830     -11.093  26.886  -5.262  1.00 10.00           H  
ATOM   1693  HG2 LYS A 830     -10.083  26.793  -2.986  1.00 10.00           H  
ATOM   1694  HG3 LYS A 830     -11.288  27.934  -2.401  1.00 10.00           H  
ATOM   1695  HD2 LYS A 830     -11.823  25.173  -3.627  1.00 10.00           H  
ATOM   1696  HD3 LYS A 830     -11.837  25.542  -1.900  1.00 10.00           H  
ATOM   1697  HE2 LYS A 830     -13.775  26.656  -3.982  1.00 10.00           H  
ATOM   1698  HE3 LYS A 830     -14.121  25.412  -2.778  1.00 10.00           H  
ATOM   1699  HZ1 LYS A 830     -14.884  27.550  -2.074  1.00 10.00           H  
ATOM   1700  HZ2 LYS A 830     -13.692  27.018  -1.064  1.00 10.00           H  
ATOM   1701  HZ3 LYS A 830     -13.365  28.182  -2.188  1.00 10.00           H  
ATOM   1702  N   GLU A 831     -10.753  29.865  -6.947  1.00 10.00           N  
ATOM   1703  CA  GLU A 831     -10.536  30.244  -8.341  1.00 10.00           C  
ATOM   1704  C   GLU A 831      -9.147  30.864  -8.524  1.00 10.00           C  
ATOM   1705  O   GLU A 831      -8.460  30.558  -9.496  1.00 10.00           O  
ATOM   1706  CB  GLU A 831     -11.618  31.208  -8.846  1.00 10.00           C  
ATOM   1707  CG  GLU A 831     -12.994  30.545  -8.974  1.00 10.00           C  
ATOM   1708  CD  GLU A 831     -13.964  31.445  -9.733  1.00 10.00           C  
ATOM   1709  OE1 GLU A 831     -14.143  32.598  -9.284  1.00 10.00           O  
ATOM   1710  OE2 GLU A 831     -14.498  30.974 -10.760  1.00 10.00           O  
ATOM   1711  H   GLU A 831     -11.502  30.303  -6.420  1.00 10.00           H  
ATOM   1712  HA  GLU A 831     -10.573  29.341  -8.953  1.00 10.00           H  
ATOM   1713  HB2 GLU A 831     -11.683  32.079  -8.195  1.00 10.00           H  
ATOM   1714  HB3 GLU A 831     -11.318  31.549  -9.838  1.00 10.00           H  
ATOM   1715  HG2 GLU A 831     -12.896  29.602  -9.515  1.00 10.00           H  
ATOM   1716  HG3 GLU A 831     -13.409  30.337  -7.989  1.00 10.00           H  
ATOM   1717  N   GLY A 832      -8.742  31.751  -7.611  1.00 10.00           N  
ATOM   1718  CA  GLY A 832      -7.420  32.354  -7.641  1.00 10.00           C  
ATOM   1719  C   GLY A 832      -7.085  33.022  -6.311  1.00 10.00           C  
ATOM   1720  O   GLY A 832      -7.854  33.923  -5.909  1.00 10.00           O  
ATOM   1721  OXT GLY A 832      -6.042  32.658  -5.724  1.00 10.00           O  
ATOM   1722  H   GLY A 832      -9.368  31.997  -6.846  1.00 10.00           H  
ATOM   1723  HA2 GLY A 832      -6.671  31.587  -7.852  1.00 10.00           H  
ATOM   1724  HA3 GLY A 832      -7.386  33.104  -8.432  1.00 10.00           H  
TER    1725      GLY A 832                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
