
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  121 ( 1921),  selected  121 , name 2d9e_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 2d9e_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      S       1          5.513
LGA    S     2_A      M       2          4.705
LGA    S     3_A      Q       3          3.391
LGA    -       -      E       4           -
LGA    G     4_A      E       5          1.344
LGA    S     5_A      D       6          2.848
LGA    -       -      T       7           -
LGA    -       -      F       8           -
LGA    S     6_A      R       9          1.644
LGA    G     7_A      E      10          1.422
LGA    F     8_A      L      11          1.590
LGA    L     9_A      R      12          1.557
LGA    I    10_A      I      13          1.099
LGA    L    11_A      F      14          1.149
LGA    L    12_A      L      15          1.100
LGA    R    13_A      R      16          1.174
LGA    K    14_A      N      17          1.361
LGA    T    15_A      V      18          1.434
LGA    L    16_A      T      19          1.212
LGA    E    17_A      H      20          1.987
LGA    Q    18_A      R      21          2.512
LGA    L    19_A      L      22          2.249
LGA    Q    20_A      A      23          2.634
LGA    E    21_A      I      24          4.366
LGA    K    22_A      D      25          3.779
LGA    D    23_A      K      26          3.989
LGA    T    24_A      R      27          3.536
LGA    G    25_A      F      28          5.309
LGA    N    26_A      R      29          0.880
LGA    I    27_A      V      30          0.996
LGA    F    28_A      F      31          0.732
LGA    S    29_A      T      32          1.095
LGA    E    30_A      K      33          1.195
LGA    P    31_A      P      34          1.152
LGA    V    32_A      V      35          0.904
LGA    P    33_A      D      36          0.802
LGA    L    34_A      P      37          1.159
LGA    S    35_A      D      38          1.353
LGA    E    36_A      E      39          2.029
LGA    V    37_A      V      40          1.924
LGA    P    38_A      P      41          1.968
LGA    D    39_A      D      42          1.851
LGA    Y    40_A      Y      43          1.123
LGA    L    41_A      V      44          2.650
LGA    D    42_A      T      45          2.025
LGA    H    43_A      V      46          1.942
LGA    I    44_A      I      47          1.388
LGA    K    45_A      K      48          1.890
LGA    K    46_A      Q      49          1.266
LGA    P    47_A      P      50          0.851
LGA    M    48_A      M      51          0.588
LGA    D    49_A      D      52          0.257
LGA    F    50_A      L      53          0.581
LGA    F    51_A      S      54          0.615
LGA    T    52_A      S      55          0.666
LGA    M    53_A      V      56          0.656
LGA    K    54_A      I      57          0.636
LGA    Q    55_A      S      58          0.524
LGA    N    56_A      K      59          0.730
LGA    L    57_A      I      60          0.650
LGA    E    58_A      D      61          1.335
LGA    A    59_A      L      62          1.489
LGA    Y    60_A      H      63          1.501
LGA    R    61_A      K      64          1.374
LGA    Y    62_A      Y      65          0.974
LGA    L    63_A      L      66          1.191
LGA    N    64_A      T      67          0.722
LGA    F    65_A      V      68          0.708
LGA    D    66_A      K      69          0.486
LGA    D    67_A      D      70          0.602
LGA    F    68_A      Y      71          1.029
LGA    E    69_A      L      72          0.996
LGA    E    70_A      R      73          0.879
LGA    D    71_A      D      74          0.826
LGA    F    72_A      I      75          0.789
LGA    N    73_A      D      76          0.759
LGA    L    74_A      L      77          0.649
LGA    I    75_A      I      78          0.644
LGA    V    76_A      C      79          0.862
LGA    S    77_A      S      80          0.680
LGA    N    78_A      N      81          0.297
LGA    C    79_A      A      82          0.523
LGA    L    80_A      L      83          0.561
LGA    K    81_A      E      84          0.826
LGA    Y    82_A      Y      85          0.724
LGA    N    83_A      N      86          0.571
LGA    A    84_A      P      87          2.428
LGA    -       -      D      88           -
LGA    K    85_A      R      89          5.025
LGA    D    86_A      D      90          2.553
LGA    -       -      P      91           -
LGA    T    87_A      G      92          2.242
LGA    -       -      D      93           -
LGA    -       -      R      94           -
LGA    I    88_A      L      95          3.321
LGA    F    89_A      I      96          2.240
LGA    Y    90_A      R      97          2.225
LGA    R    91_A      H      98          2.362
LGA    A    92_A      R      99          1.694
LGA    A    93_A      A     100          0.981
LGA    V    94_A      C     101          2.101
LGA    R    95_A      A     102          1.917
LGA    L    96_A      L     103          1.515
LGA    R    97_A      R     104          2.034
LGA    E    98_A      D     105          2.744
LGA    Q    99_A      T     106          2.984
LGA    G   100_A      A     107          3.042
LGA    G   101_A      Y     108          2.417
LGA    A   102_A      A     109          0.927
LGA    V   103_A      I     110          1.450
LGA    L   104_A      I     111          2.640
LGA    R   105_A      K     112          1.827
LGA    Q   106_A      E     113          2.145
LGA    A   107_A      E     114          3.484
LGA    R   108_A      L     115          3.453
LGA    R   109_A      D     116          2.665
LGA    Q   110_A      -       -           -
LGA    A   111_A      E     117          6.199
LGA    E   112_A      D     118          3.176
LGA    K   113_A      F     119          3.474
LGA    M   114_A      E     120           #
LGA    -       -      Q     121           -
LGA    G   115_A      L     122           #
LGA    S   116_A      C     123           -
LGA    G   117_A      E     124           -
LGA    P   118_A      E     125           #
LGA    S   119_A      I     126           -
LGA    S   120_A      Q     127           -
LGA    G   121_A      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  121  130    5.0    112    2.13    29.46     75.456     5.015

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.071481 * X  +   0.881608 * Y  +  -0.466537 * Z  + -13.666148
  Y_new =   0.849917 * X  +   0.190969 * Y  +   0.491093 * Z  +  41.145271
  Z_new =   0.522046 * X  +  -0.431622 * Y  +  -0.735643 * Z  +   3.218175 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.610990    0.530603  [ DEG:  -149.5987     30.4013 ]
  Theta =  -0.549248   -2.592345  [ DEG:   -31.4696   -148.5304 ]
  Phi   =   1.486890   -1.654703  [ DEG:    85.1925    -94.8075 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2d9e_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2d9e_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  121  130   5.0  112   2.13   29.46  75.456
REMARK  ---------------------------------------------------------- 
MOLECULE 2d9e_A
HEADER    TRANSCRIPTION                           09-DEC-05   2D9E              
TITLE     SOLUTION STRUCTURE OF THE BROMODOMAIN OF PEREGRIN                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PEREGRIN;                                                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: BROMODOMAIN;                                               
COMPND   5 SYNONYM: BROMODOMAIN AND PHD FINGER-CONTAINING PROTEIN 1,            
COMPND   6 BR140 PROTEIN;                                                       
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: BRPF1;                                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050314-10;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    FOUR-HELIX BUNDLE, TRANSCRIPTION ACTIVATOR, STRUCTURAL                
KEYWDS   2 GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL             
KEYWDS   3 AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                            
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    R.HATTA,F.HAYASHI,K.IZUMI,M.YOSHIDA,S.YOKOYAMA,RIKEN                  
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   09-JUN-06 2D9E    0                                                
JRNL        AUTH   R.HATTA,F.HAYASHI,K.IZUMI,M.YOSHIDA,S.YOKOYAMA               
JRNL        TITL   SOLUTION STRUCTURE OF THE BROMODOMAIN OF PEREGRIN            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2D9E A    8   115  GB     19584408 CAD28495       633    740             
SEQRES   1 A  121  GLY SER SER GLY SER SER GLY PHE LEU ILE LEU LEU ARG          
SEQRES   2 A  121  LYS THR LEU GLU GLN LEU GLN GLU LYS ASP THR GLY ASN          
SEQRES   3 A  121  ILE PHE SER GLU PRO VAL PRO LEU SER GLU VAL PRO ASP          
SEQRES   4 A  121  TYR LEU ASP HIS ILE LYS LYS PRO MET ASP PHE PHE THR          
SEQRES   5 A  121  MET LYS GLN ASN LEU GLU ALA TYR ARG TYR LEU ASN PHE          
SEQRES   6 A  121  ASP ASP PHE GLU GLU ASP PHE ASN LEU ILE VAL SER ASN          
SEQRES   7 A  121  CYS LEU LYS TYR ASN ALA LYS ASP THR ILE PHE TYR ARG          
SEQRES   8 A  121  ALA ALA VAL ARG LEU ARG GLU GLN GLY GLY ALA VAL LEU          
SEQRES   9 A  121  ARG GLN ALA ARG ARG GLN ALA GLU LYS MET GLY SER GLY          
SEQRES  10 A  121  PRO SER SER GLY                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      14.157  50.665  -0.215  1.00  0.00           N  
ATOM      2  CA  GLY A   1      13.014  50.331  -1.044  1.00  0.00           C  
ATOM      3  C   GLY A   1      13.149  48.971  -1.697  1.00  0.00           C  
ATOM      4  O   GLY A   1      14.114  48.247  -1.448  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      12.125  50.337  -0.430  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      12.911  51.080  -1.815  1.00  0.00           H  
ATOM      7  H1  GLY A   1      14.191  50.363   0.716  1.00  0.00           H  
ATOM      8  N   SER A   2      12.181  48.619  -2.536  1.00  0.00           N  
ATOM      9  CA  SER A   2      12.194  47.335  -3.226  1.00  0.00           C  
ATOM     10  C   SER A   2      11.674  47.477  -4.653  1.00  0.00           C  
ATOM     11  O   SER A   2      11.006  48.455  -4.986  1.00  0.00           O  
ATOM     12  CB  SER A   2      11.346  46.315  -2.462  1.00  0.00           C  
ATOM     13  OG  SER A   2      11.926  46.009  -1.205  1.00  0.00           O  
ATOM     14  H   SER A   2      11.438  49.240  -2.696  1.00  0.00           H  
ATOM     15  HA  SER A   2      13.216  46.986  -3.260  1.00  0.00           H  
ATOM     16  HB2 SER A   2      10.359  46.720  -2.301  1.00  0.00           H  
ATOM     17  HB3 SER A   2      11.273  45.406  -3.041  1.00  0.00           H  
ATOM     18  HG  SER A   2      11.623  45.146  -0.913  1.00  0.00           H  
ATOM     19  N   SER A   3      11.988  46.494  -5.491  1.00  0.00           N  
ATOM     20  CA  SER A   3      11.556  46.510  -6.884  1.00  0.00           C  
ATOM     21  C   SER A   3      10.142  47.069  -7.009  1.00  0.00           C  
ATOM     22  O   SER A   3       9.846  47.844  -7.917  1.00  0.00           O  
ATOM     23  CB  SER A   3      11.614  45.101  -7.474  1.00  0.00           C  
ATOM     24  OG  SER A   3      11.698  45.142  -8.889  1.00  0.00           O  
ATOM     25  H   SER A   3      12.523  45.742  -5.165  1.00  0.00           H  
ATOM     26  HA  SER A   3      12.231  47.149  -7.432  1.00  0.00           H  
ATOM     27  HB2 SER A   3      12.481  44.587  -7.089  1.00  0.00           H  
ATOM     28  HB3 SER A   3      10.721  44.559  -7.194  1.00  0.00           H  
ATOM     29  HG  SER A   3      11.126  45.838  -9.223  1.00  0.00           H  
ATOM     30  N   GLY A   4       9.271  46.669  -6.087  1.00  0.00           N  
ATOM     31  CA  GLY A   4       7.899  47.139  -6.109  1.00  0.00           C  
ATOM     32  C   GLY A   4       6.906  46.017  -6.344  1.00  0.00           C  
ATOM     33  O   GLY A   4       7.138  45.136  -7.172  1.00  0.00           O  
ATOM     34  H   GLY A   4       9.565  46.050  -5.384  1.00  0.00           H  
ATOM     35  HA2 GLY A   4       7.675  47.612  -5.165  1.00  0.00           H  
ATOM     36  HA3 GLY A   4       7.793  47.867  -6.900  1.00  0.00           H  
ATOM     37  N   SER A   5       5.797  46.047  -5.611  1.00  0.00           N  
ATOM     38  CA  SER A   5       4.768  45.022  -5.739  1.00  0.00           C  
ATOM     39  C   SER A   5       3.425  45.642  -6.110  1.00  0.00           C  
ATOM     40  O   SER A   5       2.683  46.108  -5.245  1.00  0.00           O  
ATOM     41  CB  SER A   5       4.636  44.236  -4.433  1.00  0.00           C  
ATOM     42  OG  SER A   5       4.321  45.096  -3.351  1.00  0.00           O  
ATOM     43  H   SER A   5       5.670  46.776  -4.968  1.00  0.00           H  
ATOM     44  HA  SER A   5       5.069  44.347  -6.526  1.00  0.00           H  
ATOM     45  HB2 SER A   5       3.850  43.504  -4.535  1.00  0.00           H  
ATOM     46  HB3 SER A   5       5.570  43.736  -4.220  1.00  0.00           H  
ATOM     47  HG  SER A   5       5.121  45.530  -3.044  1.00  0.00           H  
ATOM     48  N   SER A   6       3.120  45.647  -7.404  1.00  0.00           N  
ATOM     49  CA  SER A   6       1.868  46.215  -7.893  1.00  0.00           C  
ATOM     50  C   SER A   6       0.885  45.113  -8.277  1.00  0.00           C  
ATOM     51  O   SER A   6      -0.269  45.119  -7.854  1.00  0.00           O  
ATOM     52  CB  SER A   6       2.131  47.123  -9.095  1.00  0.00           C  
ATOM     53  OG  SER A   6       2.983  46.492 -10.034  1.00  0.00           O  
ATOM     54  H   SER A   6       3.753  45.262  -8.047  1.00  0.00           H  
ATOM     55  HA  SER A   6       1.437  46.803  -7.095  1.00  0.00           H  
ATOM     56  HB2 SER A   6       1.194  47.357  -9.578  1.00  0.00           H  
ATOM     57  HB3 SER A   6       2.600  48.036  -8.757  1.00  0.00           H  
ATOM     58  HG  SER A   6       2.478  46.254 -10.816  1.00  0.00           H  
ATOM     59  N   GLY A   7       1.355  44.167  -9.085  1.00  0.00           N  
ATOM     60  CA  GLY A   7       0.506  43.071  -9.515  1.00  0.00           C  
ATOM     61  C   GLY A   7      -0.379  42.550  -8.399  1.00  0.00           C  
ATOM     62  O   GLY A   7      -1.576  42.338  -8.594  1.00  0.00           O  
ATOM     63  H   GLY A   7       2.284  44.213  -9.393  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      -0.120  43.412 -10.328  1.00  0.00           H  
ATOM     65  HA3 GLY A   7       1.131  42.265  -9.869  1.00  0.00           H  
ATOM     66  N   PHE A   8       0.211  42.343  -7.227  1.00  0.00           N  
ATOM     67  CA  PHE A   8      -0.531  41.842  -6.076  1.00  0.00           C  
ATOM     68  C   PHE A   8      -1.679  42.781  -5.717  1.00  0.00           C  
ATOM     69  O   PHE A   8      -2.762  42.339  -5.332  1.00  0.00           O  
ATOM     70  CB  PHE A   8       0.401  41.675  -4.875  1.00  0.00           C  
ATOM     71  CG  PHE A   8      -0.310  41.272  -3.615  1.00  0.00           C  
ATOM     72  CD1 PHE A   8      -0.797  39.985  -3.460  1.00  0.00           C  
ATOM     73  CD2 PHE A   8      -0.491  42.181  -2.585  1.00  0.00           C  
ATOM     74  CE1 PHE A   8      -1.453  39.612  -2.303  1.00  0.00           C  
ATOM     75  CE2 PHE A   8      -1.146  41.814  -1.424  1.00  0.00           C  
ATOM     76  CZ  PHE A   8      -1.628  40.527  -1.283  1.00  0.00           C  
ATOM     77  H   PHE A   8       1.168  42.532  -7.133  1.00  0.00           H  
ATOM     78  HA  PHE A   8      -0.939  40.879  -6.340  1.00  0.00           H  
ATOM     79  HB2 PHE A   8       1.134  40.915  -5.099  1.00  0.00           H  
ATOM     80  HB3 PHE A   8       0.906  42.610  -4.687  1.00  0.00           H  
ATOM     81  HD1 PHE A   8      -0.662  39.267  -4.256  1.00  0.00           H  
ATOM     82  HD2 PHE A   8      -0.115  43.189  -2.694  1.00  0.00           H  
ATOM     83  HE1 PHE A   8      -1.828  38.605  -2.194  1.00  0.00           H  
ATOM     84  HE2 PHE A   8      -1.280  42.532  -0.630  1.00  0.00           H  
ATOM     85  HZ  PHE A   8      -2.140  40.238  -0.377  1.00  0.00           H  
ATOM     86  N   LEU A   9      -1.433  44.081  -5.845  1.00  0.00           N  
ATOM     87  CA  LEU A   9      -2.445  45.085  -5.534  1.00  0.00           C  
ATOM     88  C   LEU A   9      -3.652  44.945  -6.456  1.00  0.00           C  
ATOM     89  O   LEU A   9      -4.797  44.999  -6.008  1.00  0.00           O  
ATOM     90  CB  LEU A   9      -1.852  46.490  -5.658  1.00  0.00           C  
ATOM     91  CG  LEU A   9      -0.570  46.750  -4.867  1.00  0.00           C  
ATOM     92  CD1 LEU A   9      -0.120  48.192  -5.041  1.00  0.00           C  
ATOM     93  CD2 LEU A   9      -0.777  46.428  -3.395  1.00  0.00           C  
ATOM     94  H   LEU A   9      -0.551  44.373  -6.156  1.00  0.00           H  
ATOM     95  HA  LEU A   9      -2.765  44.928  -4.515  1.00  0.00           H  
ATOM     96  HB2 LEU A   9      -1.639  46.667  -6.702  1.00  0.00           H  
ATOM     97  HB3 LEU A   9      -2.600  47.194  -5.321  1.00  0.00           H  
ATOM     98  HG  LEU A   9       0.214  46.109  -5.244  1.00  0.00           H  
ATOM     99 HD11 LEU A   9      -0.204  48.474  -6.079  1.00  0.00           H  
ATOM    100 HD12 LEU A   9       0.908  48.289  -4.724  1.00  0.00           H  
ATOM    101 HD13 LEU A   9      -0.743  48.839  -4.441  1.00  0.00           H  
ATOM    102 HD21 LEU A   9      -1.493  47.119  -2.973  1.00  0.00           H  
ATOM    103 HD22 LEU A   9       0.163  46.520  -2.871  1.00  0.00           H  
ATOM    104 HD23 LEU A   9      -1.149  45.419  -3.296  1.00  0.00           H  
ATOM    105  N   ILE A  10      -3.387  44.764  -7.746  1.00  0.00           N  
ATOM    106  CA  ILE A  10      -4.452  44.615  -8.729  1.00  0.00           C  
ATOM    107  C   ILE A  10      -5.312  43.393  -8.427  1.00  0.00           C  
ATOM    108  O   ILE A  10      -6.540  43.478  -8.392  1.00  0.00           O  
ATOM    109  CB  ILE A  10      -3.884  44.488 -10.157  1.00  0.00           C  
ATOM    110  CG1 ILE A  10      -3.150  45.771 -10.553  1.00  0.00           C  
ATOM    111  CG2 ILE A  10      -5.001  44.183 -11.145  1.00  0.00           C  
ATOM    112  CD1 ILE A  10      -1.705  45.800 -10.109  1.00  0.00           C  
ATOM    113  H   ILE A  10      -2.454  44.732  -8.042  1.00  0.00           H  
ATOM    114  HA  ILE A  10      -5.071  45.498  -8.687  1.00  0.00           H  
ATOM    115  HB  ILE A  10      -3.188  43.664 -10.171  1.00  0.00           H  
ATOM    116 HG12 ILE A  10      -3.170  45.872 -11.627  1.00  0.00           H  
ATOM    117 HG13 ILE A  10      -3.654  46.616 -10.107  1.00  0.00           H  
ATOM    118 HG21 ILE A  10      -5.693  45.011 -11.172  1.00  0.00           H  
ATOM    119 HG22 ILE A  10      -4.580  44.034 -12.128  1.00  0.00           H  
ATOM    120 HG23 ILE A  10      -5.521  43.289 -10.835  1.00  0.00           H  
ATOM    121 HD11 ILE A  10      -1.579  46.552  -9.345  1.00  0.00           H  
ATOM    122 HD12 ILE A  10      -1.428  44.835  -9.715  1.00  0.00           H  
ATOM    123 HD13 ILE A  10      -1.075  46.040 -10.953  1.00  0.00           H  
ATOM    124  N   LEU A  11      -4.659  42.257  -8.206  1.00  0.00           N  
ATOM    125  CA  LEU A  11      -5.366  41.016  -7.903  1.00  0.00           C  
ATOM    126  C   LEU A  11      -6.377  41.226  -6.780  1.00  0.00           C  
ATOM    127  O   LEU A  11      -7.509  40.744  -6.853  1.00  0.00           O  
ATOM    128  CB  LEU A  11      -4.369  39.923  -7.510  1.00  0.00           C  
ATOM    129  CG  LEU A  11      -4.958  38.701  -6.804  1.00  0.00           C  
ATOM    130  CD1 LEU A  11      -5.877  37.934  -7.742  1.00  0.00           C  
ATOM    131  CD2 LEU A  11      -3.848  37.798  -6.285  1.00  0.00           C  
ATOM    132  H   LEU A  11      -3.682  42.251  -8.247  1.00  0.00           H  
ATOM    133  HA  LEU A  11      -5.892  40.709  -8.794  1.00  0.00           H  
ATOM    134  HB2 LEU A  11      -3.881  39.582  -8.409  1.00  0.00           H  
ATOM    135  HB3 LEU A  11      -3.637  40.367  -6.849  1.00  0.00           H  
ATOM    136  HG  LEU A  11      -5.545  39.030  -5.958  1.00  0.00           H  
ATOM    137 HD11 LEU A  11      -6.659  37.459  -7.170  1.00  0.00           H  
ATOM    138 HD12 LEU A  11      -5.308  37.183  -8.269  1.00  0.00           H  
ATOM    139 HD13 LEU A  11      -6.314  38.618  -8.455  1.00  0.00           H  
ATOM    140 HD21 LEU A  11      -3.107  38.397  -5.775  1.00  0.00           H  
ATOM    141 HD22 LEU A  11      -3.387  37.283  -7.115  1.00  0.00           H  
ATOM    142 HD23 LEU A  11      -4.263  37.075  -5.599  1.00  0.00           H  
ATOM    143  N   LEU A  12      -5.964  41.948  -5.746  1.00  0.00           N  
ATOM    144  CA  LEU A  12      -6.835  42.223  -4.608  1.00  0.00           C  
ATOM    145  C   LEU A  12      -8.029  43.074  -5.031  1.00  0.00           C  
ATOM    146  O   LEU A  12      -9.181  42.698  -4.812  1.00  0.00           O  
ATOM    147  CB  LEU A  12      -6.053  42.935  -3.502  1.00  0.00           C  
ATOM    148  CG  LEU A  12      -4.846  42.181  -2.943  1.00  0.00           C  
ATOM    149  CD1 LEU A  12      -4.006  43.095  -2.065  1.00  0.00           C  
ATOM    150  CD2 LEU A  12      -5.297  40.956  -2.161  1.00  0.00           C  
ATOM    151  H   LEU A  12      -5.052  42.305  -5.744  1.00  0.00           H  
ATOM    152  HA  LEU A  12      -7.197  41.279  -4.231  1.00  0.00           H  
ATOM    153  HB2 LEU A  12      -5.701  43.875  -3.899  1.00  0.00           H  
ATOM    154  HB3 LEU A  12      -6.735  43.124  -2.685  1.00  0.00           H  
ATOM    155  HG  LEU A  12      -4.227  41.846  -3.763  1.00  0.00           H  
ATOM    156 HD11 LEU A  12      -4.453  44.078  -2.037  1.00  0.00           H  
ATOM    157 HD12 LEU A  12      -3.007  43.165  -2.470  1.00  0.00           H  
ATOM    158 HD13 LEU A  12      -3.961  42.692  -1.064  1.00  0.00           H  
ATOM    159 HD21 LEU A  12      -4.635  40.130  -2.374  1.00  0.00           H  
ATOM    160 HD22 LEU A  12      -6.305  40.695  -2.454  1.00  0.00           H  
ATOM    161 HD23 LEU A  12      -5.275  41.174  -1.104  1.00  0.00           H  
ATOM    162  N   ARG A  13      -7.746  44.222  -5.638  1.00  0.00           N  
ATOM    163  CA  ARG A  13      -8.796  45.126  -6.091  1.00  0.00           C  
ATOM    164  C   ARG A  13      -9.828  44.381  -6.931  1.00  0.00           C  
ATOM    165  O   ARG A  13     -11.031  44.615  -6.810  1.00  0.00           O  
ATOM    166  CB  ARG A  13      -8.195  46.274  -6.904  1.00  0.00           C  
ATOM    167  CG  ARG A  13      -7.281  47.180  -6.095  1.00  0.00           C  
ATOM    168  CD  ARG A  13      -6.227  47.837  -6.972  1.00  0.00           C  
ATOM    169  NE  ARG A  13      -6.698  49.093  -7.546  1.00  0.00           N  
ATOM    170  CZ  ARG A  13      -5.924  49.922  -8.239  1.00  0.00           C  
ATOM    171  NH1 ARG A  13      -4.647  49.626  -8.441  1.00  0.00           N  
ATOM    172  NH2 ARG A  13      -6.426  51.047  -8.729  1.00  0.00           N  
ATOM    173  H   ARG A  13      -6.808  44.468  -5.783  1.00  0.00           H  
ATOM    174  HA  ARG A  13      -9.284  45.532  -5.218  1.00  0.00           H  
ATOM    175  HB2 ARG A  13      -7.622  45.861  -7.721  1.00  0.00           H  
ATOM    176  HB3 ARG A  13      -8.997  46.874  -7.306  1.00  0.00           H  
ATOM    177  HG2 ARG A  13      -7.877  47.951  -5.628  1.00  0.00           H  
ATOM    178  HG3 ARG A  13      -6.790  46.592  -5.332  1.00  0.00           H  
ATOM    179  HD2 ARG A  13      -5.350  48.032  -6.373  1.00  0.00           H  
ATOM    180  HD3 ARG A  13      -5.971  47.159  -7.772  1.00  0.00           H  
ATOM    181  HE  ARG A  13      -7.638  49.331  -7.408  1.00  0.00           H  
ATOM    182 HH11 ARG A  13      -4.266  48.777  -8.073  1.00  0.00           H  
ATOM    183 HH12 ARG A  13      -4.066  50.250  -8.964  1.00  0.00           H  
ATOM    184 HH21 ARG A  13      -7.388  51.273  -8.579  1.00  0.00           H  
ATOM    185 HH22 ARG A  13      -5.843  51.670  -9.251  1.00  0.00           H  
ATOM    186  N   LYS A  14      -9.352  43.481  -7.786  1.00  0.00           N  
ATOM    187  CA  LYS A  14     -10.232  42.700  -8.646  1.00  0.00           C  
ATOM    188  C   LYS A  14     -11.030  41.687  -7.832  1.00  0.00           C  
ATOM    189  O   LYS A  14     -12.206  41.445  -8.103  1.00  0.00           O  
ATOM    190  CB  LYS A  14      -9.417  41.977  -9.722  1.00  0.00           C  
ATOM    191  CG  LYS A  14     -10.188  40.878 -10.434  1.00  0.00           C  
ATOM    192  CD  LYS A  14     -10.061  39.549  -9.709  1.00  0.00           C  
ATOM    193  CE  LYS A  14      -8.811  38.796 -10.141  1.00  0.00           C  
ATOM    194  NZ  LYS A  14      -8.564  37.598  -9.292  1.00  0.00           N  
ATOM    195  H   LYS A  14      -8.383  43.338  -7.836  1.00  0.00           H  
ATOM    196  HA  LYS A  14     -10.919  43.381  -9.124  1.00  0.00           H  
ATOM    197  HB2 LYS A  14      -9.097  42.698 -10.458  1.00  0.00           H  
ATOM    198  HB3 LYS A  14      -8.545  41.535  -9.260  1.00  0.00           H  
ATOM    199  HG2 LYS A  14     -11.232  41.153 -10.476  1.00  0.00           H  
ATOM    200  HG3 LYS A  14      -9.801  40.771 -11.436  1.00  0.00           H  
ATOM    201  HD2 LYS A  14     -10.008  39.731  -8.646  1.00  0.00           H  
ATOM    202  HD3 LYS A  14     -10.929  38.944  -9.928  1.00  0.00           H  
ATOM    203  HE2 LYS A  14      -8.934  38.482 -11.166  1.00  0.00           H  
ATOM    204  HE3 LYS A  14      -7.963  39.461 -10.066  1.00  0.00           H  
ATOM    205  HZ1 LYS A  14      -7.759  37.056  -9.666  1.00  0.00           H  
ATOM    206  HZ2 LYS A  14      -9.405  36.986  -9.285  1.00  0.00           H  
ATOM    207  HZ3 LYS A  14      -8.352  37.888  -8.317  1.00  0.00           H  
ATOM    208  N   THR A  15     -10.384  41.096  -6.831  1.00  0.00           N  
ATOM    209  CA  THR A  15     -11.034  40.110  -5.977  1.00  0.00           C  
ATOM    210  C   THR A  15     -12.158  40.742  -5.166  1.00  0.00           C  
ATOM    211  O   THR A  15     -13.308  40.307  -5.237  1.00  0.00           O  
ATOM    212  CB  THR A  15     -10.027  39.451  -5.015  1.00  0.00           C  
ATOM    213  OG1 THR A  15      -9.114  38.628  -5.748  1.00  0.00           O  
ATOM    214  CG2 THR A  15     -10.748  38.612  -3.969  1.00  0.00           C  
ATOM    215  H   THR A  15      -9.447  41.331  -6.665  1.00  0.00           H  
ATOM    216  HA  THR A  15     -11.447  39.341  -6.612  1.00  0.00           H  
ATOM    217  HB  THR A  15      -9.472  40.230  -4.510  1.00  0.00           H  
ATOM    218  HG1 THR A  15      -8.637  39.167  -6.383  1.00  0.00           H  
ATOM    219 HG21 THR A  15     -10.188  37.707  -3.786  1.00  0.00           H  
ATOM    220 HG22 THR A  15     -11.734  38.359  -4.330  1.00  0.00           H  
ATOM    221 HG23 THR A  15     -10.833  39.175  -3.052  1.00  0.00           H  
ATOM    222  N   LEU A  16     -11.820  41.770  -4.395  1.00  0.00           N  
ATOM    223  CA  LEU A  16     -12.804  42.462  -3.568  1.00  0.00           C  
ATOM    224  C   LEU A  16     -14.124  42.624  -4.315  1.00  0.00           C  
ATOM    225  O   LEU A  16     -15.194  42.368  -3.763  1.00  0.00           O  
ATOM    226  CB  LEU A  16     -12.271  43.833  -3.149  1.00  0.00           C  
ATOM    227  CG  LEU A  16     -13.296  44.799  -2.557  1.00  0.00           C  
ATOM    228  CD1 LEU A  16     -13.811  44.280  -1.224  1.00  0.00           C  
ATOM    229  CD2 LEU A  16     -12.690  46.186  -2.393  1.00  0.00           C  
ATOM    230  H   LEU A  16     -10.888  42.071  -4.380  1.00  0.00           H  
ATOM    231  HA  LEU A  16     -12.974  41.865  -2.686  1.00  0.00           H  
ATOM    232  HB2 LEU A  16     -11.500  43.676  -2.409  1.00  0.00           H  
ATOM    233  HB3 LEU A  16     -11.838  44.301  -4.022  1.00  0.00           H  
ATOM    234  HG  LEU A  16     -14.138  44.879  -3.231  1.00  0.00           H  
ATOM    235 HD11 LEU A  16     -13.222  43.430  -0.915  1.00  0.00           H  
ATOM    236 HD12 LEU A  16     -14.844  43.983  -1.329  1.00  0.00           H  
ATOM    237 HD13 LEU A  16     -13.736  45.060  -0.480  1.00  0.00           H  
ATOM    238 HD21 LEU A  16     -12.862  46.761  -3.292  1.00  0.00           H  
ATOM    239 HD22 LEU A  16     -11.628  46.096  -2.220  1.00  0.00           H  
ATOM    240 HD23 LEU A  16     -13.153  46.683  -1.554  1.00  0.00           H  
ATOM    241  N   GLU A  17     -14.039  43.048  -5.572  1.00  0.00           N  
ATOM    242  CA  GLU A  17     -15.228  43.244  -6.393  1.00  0.00           C  
ATOM    243  C   GLU A  17     -16.059  41.965  -6.461  1.00  0.00           C  
ATOM    244  O   GLU A  17     -17.264  41.981  -6.214  1.00  0.00           O  
ATOM    245  CB  GLU A  17     -14.834  43.683  -7.805  1.00  0.00           C  
ATOM    246  CG  GLU A  17     -14.064  44.993  -7.842  1.00  0.00           C  
ATOM    247  CD  GLU A  17     -13.661  45.394  -9.247  1.00  0.00           C  
ATOM    248  OE1 GLU A  17     -12.995  44.586  -9.927  1.00  0.00           O  
ATOM    249  OE2 GLU A  17     -14.014  46.516  -9.668  1.00  0.00           O  
ATOM    250  H   GLU A  17     -13.158  43.237  -5.955  1.00  0.00           H  
ATOM    251  HA  GLU A  17     -15.823  44.020  -5.937  1.00  0.00           H  
ATOM    252  HB2 GLU A  17     -14.219  42.915  -8.251  1.00  0.00           H  
ATOM    253  HB3 GLU A  17     -15.730  43.801  -8.395  1.00  0.00           H  
ATOM    254  HG2 GLU A  17     -14.684  45.772  -7.425  1.00  0.00           H  
ATOM    255  HG3 GLU A  17     -13.171  44.887  -7.242  1.00  0.00           H  
ATOM    256  N   GLN A  18     -15.403  40.858  -6.797  1.00  0.00           N  
ATOM    257  CA  GLN A  18     -16.080  39.571  -6.898  1.00  0.00           C  
ATOM    258  C   GLN A  18     -16.950  39.316  -5.673  1.00  0.00           C  
ATOM    259  O   GLN A  18     -18.101  38.893  -5.792  1.00  0.00           O  
ATOM    260  CB  GLN A  18     -15.058  38.444  -7.056  1.00  0.00           C  
ATOM    261  CG  GLN A  18     -14.355  38.444  -8.405  1.00  0.00           C  
ATOM    262  CD  GLN A  18     -13.752  37.097  -8.748  1.00  0.00           C  
ATOM    263  OE1 GLN A  18     -14.469  36.132  -9.015  1.00  0.00           O  
ATOM    264  NE2 GLN A  18     -12.425  37.022  -8.743  1.00  0.00           N  
ATOM    265  H   GLN A  18     -14.442  40.909  -6.981  1.00  0.00           H  
ATOM    266  HA  GLN A  18     -16.711  39.597  -7.773  1.00  0.00           H  
ATOM    267  HB2 GLN A  18     -14.308  38.542  -6.284  1.00  0.00           H  
ATOM    268  HB3 GLN A  18     -15.562  37.496  -6.938  1.00  0.00           H  
ATOM    269  HG2 GLN A  18     -15.072  38.704  -9.169  1.00  0.00           H  
ATOM    270  HG3 GLN A  18     -13.567  39.182  -8.384  1.00  0.00           H  
ATOM    271 HE21 GLN A  18     -11.918  37.832  -8.518  1.00  0.00           H  
ATOM    272 HE22 GLN A  18     -12.009  36.164  -8.959  1.00  0.00           H  
ATOM    273  N   LEU A  19     -16.394  39.574  -4.494  1.00  0.00           N  
ATOM    274  CA  LEU A  19     -17.120  39.373  -3.244  1.00  0.00           C  
ATOM    275  C   LEU A  19     -18.404  40.195  -3.221  1.00  0.00           C  
ATOM    276  O   LEU A  19     -19.468  39.691  -2.862  1.00  0.00           O  
ATOM    277  CB  LEU A  19     -16.237  39.750  -2.053  1.00  0.00           C  
ATOM    278  CG  LEU A  19     -14.979  38.904  -1.855  1.00  0.00           C  
ATOM    279  CD1 LEU A  19     -14.080  39.526  -0.797  1.00  0.00           C  
ATOM    280  CD2 LEU A  19     -15.350  37.480  -1.471  1.00  0.00           C  
ATOM    281  H   LEU A  19     -15.475  39.910  -4.462  1.00  0.00           H  
ATOM    282  HA  LEU A  19     -17.375  38.325  -3.174  1.00  0.00           H  
ATOM    283  HB2 LEU A  19     -15.929  40.776  -2.182  1.00  0.00           H  
ATOM    284  HB3 LEU A  19     -16.839  39.667  -1.159  1.00  0.00           H  
ATOM    285  HG  LEU A  19     -14.426  38.869  -2.784  1.00  0.00           H  
ATOM    286 HD11 LEU A  19     -13.406  38.776  -0.411  1.00  0.00           H  
ATOM    287 HD12 LEU A  19     -14.686  39.914   0.008  1.00  0.00           H  
ATOM    288 HD13 LEU A  19     -13.509  40.330  -1.239  1.00  0.00           H  
ATOM    289 HD21 LEU A  19     -15.367  36.862  -2.358  1.00  0.00           H  
ATOM    290 HD22 LEU A  19     -16.326  37.473  -1.009  1.00  0.00           H  
ATOM    291 HD23 LEU A  19     -14.619  37.093  -0.776  1.00  0.00           H  
ATOM    292  N   GLN A  20     -18.297  41.462  -3.610  1.00  0.00           N  
ATOM    293  CA  GLN A  20     -19.450  42.353  -3.635  1.00  0.00           C  
ATOM    294  C   GLN A  20     -20.589  41.747  -4.451  1.00  0.00           C  
ATOM    295  O   GLN A  20     -21.751  41.819  -4.058  1.00  0.00           O  
ATOM    296  CB  GLN A  20     -19.059  43.713  -4.215  1.00  0.00           C  
ATOM    297  CG  GLN A  20     -18.072  44.480  -3.351  1.00  0.00           C  
ATOM    298  CD  GLN A  20     -18.211  45.983  -3.501  1.00  0.00           C  
ATOM    299  OE1 GLN A  20     -17.438  46.622  -4.216  1.00  0.00           O  
ATOM    300  NE2 GLN A  20     -19.201  46.556  -2.825  1.00  0.00           N  
ATOM    301  H   GLN A  20     -17.422  41.805  -3.884  1.00  0.00           H  
ATOM    302  HA  GLN A  20     -19.788  42.488  -2.618  1.00  0.00           H  
ATOM    303  HB2 GLN A  20     -18.614  43.561  -5.187  1.00  0.00           H  
ATOM    304  HB3 GLN A  20     -19.951  44.313  -4.327  1.00  0.00           H  
ATOM    305  HG2 GLN A  20     -18.240  44.220  -2.317  1.00  0.00           H  
ATOM    306  HG3 GLN A  20     -17.069  44.196  -3.636  1.00  0.00           H  
ATOM    307 HE21 GLN A  20     -19.777  45.984  -2.275  1.00  0.00           H  
ATOM    308 HE22 GLN A  20     -19.314  47.525  -2.903  1.00  0.00           H  
ATOM    309  N   GLU A  21     -20.243  41.152  -5.588  1.00  0.00           N  
ATOM    310  CA  GLU A  21     -21.237  40.534  -6.459  1.00  0.00           C  
ATOM    311  C   GLU A  21     -22.208  39.677  -5.654  1.00  0.00           C  
ATOM    312  O   GLU A  21     -23.417  39.704  -5.886  1.00  0.00           O  
ATOM    313  CB  GLU A  21     -20.551  39.681  -7.527  1.00  0.00           C  
ATOM    314  CG  GLU A  21     -19.643  40.476  -8.452  1.00  0.00           C  
ATOM    315  CD  GLU A  21     -20.417  41.288  -9.472  1.00  0.00           C  
ATOM    316  OE1 GLU A  21     -21.335  40.725 -10.106  1.00  0.00           O  
ATOM    317  OE2 GLU A  21     -20.105  42.486  -9.637  1.00  0.00           O  
ATOM    318  H   GLU A  21     -19.299  41.127  -5.848  1.00  0.00           H  
ATOM    319  HA  GLU A  21     -21.788  41.325  -6.944  1.00  0.00           H  
ATOM    320  HB2 GLU A  21     -19.958  38.922  -7.039  1.00  0.00           H  
ATOM    321  HB3 GLU A  21     -21.310  39.201  -8.127  1.00  0.00           H  
ATOM    322  HG2 GLU A  21     -19.045  41.149  -7.857  1.00  0.00           H  
ATOM    323  HG3 GLU A  21     -18.995  39.789  -8.976  1.00  0.00           H  
ATOM    324  N   LYS A  22     -21.672  38.918  -4.705  1.00  0.00           N  
ATOM    325  CA  LYS A  22     -22.490  38.051  -3.865  1.00  0.00           C  
ATOM    326  C   LYS A  22     -23.481  38.870  -3.043  1.00  0.00           C  
ATOM    327  O   LYS A  22     -24.643  38.491  -2.898  1.00  0.00           O  
ATOM    328  CB  LYS A  22     -21.602  37.223  -2.934  1.00  0.00           C  
ATOM    329  CG  LYS A  22     -20.603  36.346  -3.669  1.00  0.00           C  
ATOM    330  CD  LYS A  22     -21.277  35.518  -4.750  1.00  0.00           C  
ATOM    331  CE  LYS A  22     -20.285  34.605  -5.454  1.00  0.00           C  
ATOM    332  NZ  LYS A  22     -20.970  33.566  -6.272  1.00  0.00           N  
ATOM    333  H   LYS A  22     -20.702  38.939  -4.568  1.00  0.00           H  
ATOM    334  HA  LYS A  22     -23.041  37.385  -4.511  1.00  0.00           H  
ATOM    335  HB2 LYS A  22     -21.054  37.892  -2.287  1.00  0.00           H  
ATOM    336  HB3 LYS A  22     -22.231  36.586  -2.329  1.00  0.00           H  
ATOM    337  HG2 LYS A  22     -19.855  36.974  -4.127  1.00  0.00           H  
ATOM    338  HG3 LYS A  22     -20.131  35.680  -2.960  1.00  0.00           H  
ATOM    339  HD2 LYS A  22     -22.048  34.912  -4.298  1.00  0.00           H  
ATOM    340  HD3 LYS A  22     -21.720  36.183  -5.477  1.00  0.00           H  
ATOM    341  HE2 LYS A  22     -19.659  35.204  -6.097  1.00  0.00           H  
ATOM    342  HE3 LYS A  22     -19.672  34.119  -4.708  1.00  0.00           H  
ATOM    343  HZ1 LYS A  22     -21.191  32.737  -5.684  1.00  0.00           H  
ATOM    344  HZ2 LYS A  22     -20.356  33.267  -7.055  1.00  0.00           H  
ATOM    345  HZ3 LYS A  22     -21.855  33.946  -6.663  1.00  0.00           H  
ATOM    346  N   ASP A  23     -23.014  39.993  -2.509  1.00  0.00           N  
ATOM    347  CA  ASP A  23     -23.860  40.867  -1.703  1.00  0.00           C  
ATOM    348  C   ASP A  23     -24.768  41.713  -2.592  1.00  0.00           C  
ATOM    349  O   ASP A  23     -24.398  42.811  -3.010  1.00  0.00           O  
ATOM    350  CB  ASP A  23     -23.000  41.773  -0.822  1.00  0.00           C  
ATOM    351  CG  ASP A  23     -23.821  42.536   0.199  1.00  0.00           C  
ATOM    352  OD1 ASP A  23     -24.935  42.078   0.526  1.00  0.00           O  
ATOM    353  OD2 ASP A  23     -23.350  43.593   0.670  1.00  0.00           O  
ATOM    354  H   ASP A  23     -22.078  40.242  -2.660  1.00  0.00           H  
ATOM    355  HA  ASP A  23     -24.474  40.243  -1.072  1.00  0.00           H  
ATOM    356  HB2 ASP A  23     -22.277  41.169  -0.293  1.00  0.00           H  
ATOM    357  HB3 ASP A  23     -22.481  42.486  -1.445  1.00  0.00           H  
ATOM    358  N   THR A  24     -25.958  41.195  -2.876  1.00  0.00           N  
ATOM    359  CA  THR A  24     -26.919  41.900  -3.715  1.00  0.00           C  
ATOM    360  C   THR A  24     -27.707  42.923  -2.906  1.00  0.00           C  
ATOM    361  O   THR A  24     -28.263  43.871  -3.460  1.00  0.00           O  
ATOM    362  CB  THR A  24     -27.902  40.923  -4.386  1.00  0.00           C  
ATOM    363  OG1 THR A  24     -28.718  40.292  -3.394  1.00  0.00           O  
ATOM    364  CG2 THR A  24     -27.155  39.865  -5.183  1.00  0.00           C  
ATOM    365  H   THR A  24     -26.196  40.315  -2.513  1.00  0.00           H  
ATOM    366  HA  THR A  24     -26.369  42.414  -4.490  1.00  0.00           H  
ATOM    367  HB  THR A  24     -28.535  41.482  -5.061  1.00  0.00           H  
ATOM    368  HG1 THR A  24     -29.587  40.704  -3.385  1.00  0.00           H  
ATOM    369 HG21 THR A  24     -27.656  38.915  -5.080  1.00  0.00           H  
ATOM    370 HG22 THR A  24     -26.144  39.783  -4.814  1.00  0.00           H  
ATOM    371 HG23 THR A  24     -27.134  40.148  -6.226  1.00  0.00           H  
ATOM    372  N   GLY A  25     -27.754  42.724  -1.593  1.00  0.00           N  
ATOM    373  CA  GLY A  25     -28.478  43.638  -0.728  1.00  0.00           C  
ATOM    374  C   GLY A  25     -27.623  44.804  -0.271  1.00  0.00           C  
ATOM    375  O   GLY A  25     -28.141  45.814   0.203  1.00  0.00           O  
ATOM    376  H   GLY A  25     -27.292  41.950  -1.207  1.00  0.00           H  
ATOM    377  HA2 GLY A  25     -29.332  44.022  -1.265  1.00  0.00           H  
ATOM    378  HA3 GLY A  25     -28.823  43.098   0.140  1.00  0.00           H  
ATOM    379  N   ASN A  26     -26.309  44.662  -0.411  1.00  0.00           N  
ATOM    380  CA  ASN A  26     -25.380  45.711  -0.006  1.00  0.00           C  
ATOM    381  C   ASN A  26     -25.491  45.988   1.490  1.00  0.00           C  
ATOM    382  O   ASN A  26     -25.403  47.136   1.928  1.00  0.00           O  
ATOM    383  CB  ASN A  26     -25.650  46.994  -0.795  1.00  0.00           C  
ATOM    384  CG  ASN A  26     -26.094  46.713  -2.218  1.00  0.00           C  
ATOM    385  OD1 ASN A  26     -25.572  45.815  -2.878  1.00  0.00           O  
ATOM    386  ND2 ASN A  26     -27.062  47.485  -2.698  1.00  0.00           N  
ATOM    387  H   ASN A  26     -25.954  43.833  -0.795  1.00  0.00           H  
ATOM    388  HA  ASN A  26     -24.379  45.369  -0.222  1.00  0.00           H  
ATOM    389  HB2 ASN A  26     -26.428  47.555  -0.300  1.00  0.00           H  
ATOM    390  HB3 ASN A  26     -24.747  47.585  -0.828  1.00  0.00           H  
ATOM    391 HD21 ASN A  26     -27.431  48.182  -2.116  1.00  0.00           H  
ATOM    392 HD22 ASN A  26     -27.368  47.325  -3.615  1.00  0.00           H  
ATOM    393  N   ILE A  27     -25.685  44.929   2.270  1.00  0.00           N  
ATOM    394  CA  ILE A  27     -25.807  45.058   3.717  1.00  0.00           C  
ATOM    395  C   ILE A  27     -24.456  45.355   4.358  1.00  0.00           C  
ATOM    396  O   ILE A  27     -24.377  46.052   5.370  1.00  0.00           O  
ATOM    397  CB  ILE A  27     -26.393  43.782   4.348  1.00  0.00           C  
ATOM    398  CG1 ILE A  27     -27.705  43.404   3.661  1.00  0.00           C  
ATOM    399  CG2 ILE A  27     -26.608  43.982   5.841  1.00  0.00           C  
ATOM    400  CD1 ILE A  27     -28.349  42.159   4.232  1.00  0.00           C  
ATOM    401  H   ILE A  27     -25.746  44.041   1.863  1.00  0.00           H  
ATOM    402  HA  ILE A  27     -26.479  45.879   3.921  1.00  0.00           H  
ATOM    403  HB  ILE A  27     -25.680  42.983   4.217  1.00  0.00           H  
ATOM    404 HG12 ILE A  27     -28.407  44.216   3.766  1.00  0.00           H  
ATOM    405 HG13 ILE A  27     -27.516  43.229   2.612  1.00  0.00           H  
ATOM    406 HG21 ILE A  27     -27.554  44.478   6.006  1.00  0.00           H  
ATOM    407 HG22 ILE A  27     -26.617  43.021   6.334  1.00  0.00           H  
ATOM    408 HG23 ILE A  27     -25.809  44.585   6.243  1.00  0.00           H  
ATOM    409 HD11 ILE A  27     -28.333  41.372   3.491  1.00  0.00           H  
ATOM    410 HD12 ILE A  27     -27.805  41.840   5.107  1.00  0.00           H  
ATOM    411 HD13 ILE A  27     -29.372  42.375   4.502  1.00  0.00           H  
ATOM    412  N   PHE A  28     -23.394  44.824   3.761  1.00  0.00           N  
ATOM    413  CA  PHE A  28     -22.044  45.033   4.273  1.00  0.00           C  
ATOM    414  C   PHE A  28     -21.291  46.052   3.422  1.00  0.00           C  
ATOM    415  O   PHE A  28     -20.234  46.546   3.815  1.00  0.00           O  
ATOM    416  CB  PHE A  28     -21.276  43.710   4.301  1.00  0.00           C  
ATOM    417  CG  PHE A  28     -22.106  42.545   4.763  1.00  0.00           C  
ATOM    418  CD1 PHE A  28     -22.963  41.899   3.887  1.00  0.00           C  
ATOM    419  CD2 PHE A  28     -22.028  42.098   6.071  1.00  0.00           C  
ATOM    420  CE1 PHE A  28     -23.728  40.828   4.310  1.00  0.00           C  
ATOM    421  CE2 PHE A  28     -22.789  41.026   6.499  1.00  0.00           C  
ATOM    422  CZ  PHE A  28     -23.640  40.390   5.616  1.00  0.00           C  
ATOM    423  H   PHE A  28     -23.521  44.278   2.956  1.00  0.00           H  
ATOM    424  HA  PHE A  28     -22.127  45.413   5.279  1.00  0.00           H  
ATOM    425  HB2 PHE A  28     -20.919  43.489   3.307  1.00  0.00           H  
ATOM    426  HB3 PHE A  28     -20.434  43.805   4.970  1.00  0.00           H  
ATOM    427  HD1 PHE A  28     -23.033  42.239   2.865  1.00  0.00           H  
ATOM    428  HD2 PHE A  28     -21.361  42.594   6.762  1.00  0.00           H  
ATOM    429  HE1 PHE A  28     -24.392  40.332   3.618  1.00  0.00           H  
ATOM    430  HE2 PHE A  28     -22.717  40.686   7.522  1.00  0.00           H  
ATOM    431  HZ  PHE A  28     -24.237  39.554   5.948  1.00  0.00           H  
ATOM    432  N   SER A  29     -21.845  46.362   2.254  1.00  0.00           N  
ATOM    433  CA  SER A  29     -21.224  47.320   1.346  1.00  0.00           C  
ATOM    434  C   SER A  29     -20.872  48.613   2.075  1.00  0.00           C  
ATOM    435  O   SER A  29     -19.925  49.307   1.708  1.00  0.00           O  
ATOM    436  CB  SER A  29     -22.158  47.621   0.172  1.00  0.00           C  
ATOM    437  OG  SER A  29     -21.425  47.972  -0.987  1.00  0.00           O  
ATOM    438  H   SER A  29     -22.688  45.936   1.996  1.00  0.00           H  
ATOM    439  HA  SER A  29     -20.316  46.876   0.965  1.00  0.00           H  
ATOM    440  HB2 SER A  29     -22.755  46.748  -0.043  1.00  0.00           H  
ATOM    441  HB3 SER A  29     -22.808  48.444   0.436  1.00  0.00           H  
ATOM    442  HG  SER A  29     -21.792  47.516  -1.748  1.00  0.00           H  
ATOM    443  N   GLU A  30     -21.642  48.928   3.111  1.00  0.00           N  
ATOM    444  CA  GLU A  30     -21.412  50.138   3.892  1.00  0.00           C  
ATOM    445  C   GLU A  30     -21.243  49.806   5.373  1.00  0.00           C  
ATOM    446  O   GLU A  30     -21.770  48.815   5.877  1.00  0.00           O  
ATOM    447  CB  GLU A  30     -22.572  51.119   3.709  1.00  0.00           C  
ATOM    448  CG  GLU A  30     -23.060  51.222   2.274  1.00  0.00           C  
ATOM    449  CD  GLU A  30     -23.957  52.424   2.047  1.00  0.00           C  
ATOM    450  OE1 GLU A  30     -23.717  53.472   2.683  1.00  0.00           O  
ATOM    451  OE2 GLU A  30     -24.900  52.315   1.234  1.00  0.00           O  
ATOM    452  H   GLU A  30     -22.383  48.335   3.356  1.00  0.00           H  
ATOM    453  HA  GLU A  30     -20.505  50.597   3.534  1.00  0.00           H  
ATOM    454  HB2 GLU A  30     -23.399  50.800   4.328  1.00  0.00           H  
ATOM    455  HB3 GLU A  30     -22.253  52.099   4.030  1.00  0.00           H  
ATOM    456  HG2 GLU A  30     -22.203  51.305   1.621  1.00  0.00           H  
ATOM    457  HG3 GLU A  30     -23.612  50.328   2.030  1.00  0.00           H  
ATOM    458  N   PRO A  31     -20.488  50.654   6.087  1.00  0.00           N  
ATOM    459  CA  PRO A  31     -20.229  50.472   7.518  1.00  0.00           C  
ATOM    460  C   PRO A  31     -21.475  50.712   8.366  1.00  0.00           C  
ATOM    461  O   PRO A  31     -22.222  51.663   8.134  1.00  0.00           O  
ATOM    462  CB  PRO A  31     -19.163  51.528   7.823  1.00  0.00           C  
ATOM    463  CG  PRO A  31     -19.362  52.578   6.785  1.00  0.00           C  
ATOM    464  CD  PRO A  31     -19.828  51.857   5.551  1.00  0.00           C  
ATOM    465  HA  PRO A  31     -19.836  49.490   7.729  1.00  0.00           H  
ATOM    466  HB2 PRO A  31     -19.318  51.921   8.818  1.00  0.00           H  
ATOM    467  HB3 PRO A  31     -18.183  51.084   7.753  1.00  0.00           H  
ATOM    468  HG2 PRO A  31     -20.112  53.282   7.113  1.00  0.00           H  
ATOM    469  HG3 PRO A  31     -18.429  53.085   6.593  1.00  0.00           H  
ATOM    470  HD2 PRO A  31     -20.528  52.468   4.999  1.00  0.00           H  
ATOM    471  HD3 PRO A  31     -18.986  51.590   4.929  1.00  0.00           H  
ATOM    472  N   VAL A  32     -21.691  49.845   9.349  1.00  0.00           N  
ATOM    473  CA  VAL A  32     -22.845  49.963  10.233  1.00  0.00           C  
ATOM    474  C   VAL A  32     -22.800  51.266  11.022  1.00  0.00           C  
ATOM    475  O   VAL A  32     -21.791  51.619  11.631  1.00  0.00           O  
ATOM    476  CB  VAL A  32     -22.921  48.780  11.218  1.00  0.00           C  
ATOM    477  CG1 VAL A  32     -24.043  48.994  12.222  1.00  0.00           C  
ATOM    478  CG2 VAL A  32     -23.106  47.472  10.466  1.00  0.00           C  
ATOM    479  H   VAL A  32     -21.059  49.108   9.484  1.00  0.00           H  
ATOM    480  HA  VAL A  32     -23.736  49.953   9.622  1.00  0.00           H  
ATOM    481  HB  VAL A  32     -21.988  48.731  11.761  1.00  0.00           H  
ATOM    482 HG11 VAL A  32     -23.666  48.841  13.223  1.00  0.00           H  
ATOM    483 HG12 VAL A  32     -24.426  49.999  12.127  1.00  0.00           H  
ATOM    484 HG13 VAL A  32     -24.838  48.287  12.027  1.00  0.00           H  
ATOM    485 HG21 VAL A  32     -22.444  47.450   9.613  1.00  0.00           H  
ATOM    486 HG22 VAL A  32     -22.875  46.643  11.121  1.00  0.00           H  
ATOM    487 HG23 VAL A  32     -24.129  47.391  10.130  1.00  0.00           H  
ATOM    488  N   PRO A  33     -23.922  52.001  11.014  1.00  0.00           N  
ATOM    489  CA  PRO A  33     -24.038  53.278  11.725  1.00  0.00           C  
ATOM    490  C   PRO A  33     -24.051  53.098  13.240  1.00  0.00           C  
ATOM    491  O   PRO A  33     -24.636  52.146  13.757  1.00  0.00           O  
ATOM    492  CB  PRO A  33     -25.380  53.833  11.242  1.00  0.00           C  
ATOM    493  CG  PRO A  33     -26.164  52.631  10.841  1.00  0.00           C  
ATOM    494  CD  PRO A  33     -25.164  51.643  10.309  1.00  0.00           C  
ATOM    495  HA  PRO A  33     -23.246  53.958  11.451  1.00  0.00           H  
ATOM    496  HB2 PRO A  33     -25.861  54.370  12.047  1.00  0.00           H  
ATOM    497  HB3 PRO A  33     -25.218  54.497  10.406  1.00  0.00           H  
ATOM    498  HG2 PRO A  33     -26.677  52.225  11.699  1.00  0.00           H  
ATOM    499  HG3 PRO A  33     -26.874  52.898  10.071  1.00  0.00           H  
ATOM    500  HD2 PRO A  33     -25.467  50.634  10.549  1.00  0.00           H  
ATOM    501  HD3 PRO A  33     -25.049  51.759   9.242  1.00  0.00           H  
ATOM    502  N   LEU A  34     -23.404  54.018  13.946  1.00  0.00           N  
ATOM    503  CA  LEU A  34     -23.341  53.963  15.401  1.00  0.00           C  
ATOM    504  C   LEU A  34     -24.576  54.603  16.025  1.00  0.00           C  
ATOM    505  O   LEU A  34     -24.981  54.248  17.132  1.00  0.00           O  
ATOM    506  CB  LEU A  34     -22.078  54.665  15.905  1.00  0.00           C  
ATOM    507  CG  LEU A  34     -20.752  53.978  15.578  1.00  0.00           C  
ATOM    508  CD1 LEU A  34     -19.591  54.729  16.211  1.00  0.00           C  
ATOM    509  CD2 LEU A  34     -20.772  52.530  16.046  1.00  0.00           C  
ATOM    510  H   LEU A  34     -22.957  54.753  13.477  1.00  0.00           H  
ATOM    511  HA  LEU A  34     -23.305  52.923  15.691  1.00  0.00           H  
ATOM    512  HB2 LEU A  34     -22.055  55.652  15.471  1.00  0.00           H  
ATOM    513  HB3 LEU A  34     -22.153  54.747  16.979  1.00  0.00           H  
ATOM    514  HG  LEU A  34     -20.607  53.981  14.506  1.00  0.00           H  
ATOM    515 HD11 LEU A  34     -18.683  54.159  16.087  1.00  0.00           H  
ATOM    516 HD12 LEU A  34     -19.786  54.872  17.263  1.00  0.00           H  
ATOM    517 HD13 LEU A  34     -19.481  55.691  15.731  1.00  0.00           H  
ATOM    518 HD21 LEU A  34     -19.806  52.272  16.455  1.00  0.00           H  
ATOM    519 HD22 LEU A  34     -20.991  51.884  15.208  1.00  0.00           H  
ATOM    520 HD23 LEU A  34     -21.531  52.407  16.804  1.00  0.00           H  
ATOM    521  N   SER A  35     -25.173  55.549  15.306  1.00  0.00           N  
ATOM    522  CA  SER A  35     -26.361  56.241  15.789  1.00  0.00           C  
ATOM    523  C   SER A  35     -27.437  55.243  16.210  1.00  0.00           C  
ATOM    524  O   SER A  35     -28.146  55.460  17.192  1.00  0.00           O  
ATOM    525  CB  SER A  35     -26.910  57.174  14.708  1.00  0.00           C  
ATOM    526  OG  SER A  35     -27.766  58.155  15.265  1.00  0.00           O  
ATOM    527  H   SER A  35     -24.802  55.788  14.431  1.00  0.00           H  
ATOM    528  HA  SER A  35     -26.077  56.829  16.649  1.00  0.00           H  
ATOM    529  HB2 SER A  35     -26.089  57.671  14.214  1.00  0.00           H  
ATOM    530  HB3 SER A  35     -27.466  56.596  13.985  1.00  0.00           H  
ATOM    531  HG  SER A  35     -27.257  58.938  15.487  1.00  0.00           H  
ATOM    532  N   GLU A  36     -27.552  54.155  15.457  1.00  0.00           N  
ATOM    533  CA  GLU A  36     -28.542  53.125  15.750  1.00  0.00           C  
ATOM    534  C   GLU A  36     -27.952  52.045  16.654  1.00  0.00           C  
ATOM    535  O   GLU A  36     -28.674  51.376  17.392  1.00  0.00           O  
ATOM    536  CB  GLU A  36     -29.056  52.496  14.453  1.00  0.00           C  
ATOM    537  CG  GLU A  36     -30.284  51.622  14.647  1.00  0.00           C  
ATOM    538  CD  GLU A  36     -31.154  51.555  13.408  1.00  0.00           C  
ATOM    539  OE1 GLU A  36     -31.381  52.615  12.786  1.00  0.00           O  
ATOM    540  OE2 GLU A  36     -31.609  50.447  13.058  1.00  0.00           O  
ATOM    541  H   GLU A  36     -26.958  54.041  14.686  1.00  0.00           H  
ATOM    542  HA  GLU A  36     -29.368  53.595  16.264  1.00  0.00           H  
ATOM    543  HB2 GLU A  36     -29.306  53.285  13.760  1.00  0.00           H  
ATOM    544  HB3 GLU A  36     -28.271  51.889  14.028  1.00  0.00           H  
ATOM    545  HG2 GLU A  36     -29.962  50.621  14.895  1.00  0.00           H  
ATOM    546  HG3 GLU A  36     -30.871  52.022  15.461  1.00  0.00           H  
ATOM    547  N   VAL A  37     -26.634  51.882  16.588  1.00  0.00           N  
ATOM    548  CA  VAL A  37     -25.946  50.884  17.399  1.00  0.00           C  
ATOM    549  C   VAL A  37     -24.872  51.529  18.266  1.00  0.00           C  
ATOM    550  O   VAL A  37     -23.694  51.574  17.907  1.00  0.00           O  
ATOM    551  CB  VAL A  37     -25.300  49.797  16.521  1.00  0.00           C  
ATOM    552  CG1 VAL A  37     -25.129  48.506  17.310  1.00  0.00           C  
ATOM    553  CG2 VAL A  37     -26.129  49.559  15.268  1.00  0.00           C  
ATOM    554  H   VAL A  37     -26.112  52.445  15.980  1.00  0.00           H  
ATOM    555  HA  VAL A  37     -26.677  50.414  18.039  1.00  0.00           H  
ATOM    556  HB  VAL A  37     -24.321  50.141  16.219  1.00  0.00           H  
ATOM    557 HG11 VAL A  37     -25.104  48.731  18.366  1.00  0.00           H  
ATOM    558 HG12 VAL A  37     -25.956  47.844  17.100  1.00  0.00           H  
ATOM    559 HG13 VAL A  37     -24.203  48.029  17.020  1.00  0.00           H  
ATOM    560 HG21 VAL A  37     -25.666  48.789  14.671  1.00  0.00           H  
ATOM    561 HG22 VAL A  37     -27.126  49.247  15.549  1.00  0.00           H  
ATOM    562 HG23 VAL A  37     -26.188  50.473  14.696  1.00  0.00           H  
ATOM    563  N   PRO A  38     -25.282  52.039  19.436  1.00  0.00           N  
ATOM    564  CA  PRO A  38     -24.368  52.689  20.381  1.00  0.00           C  
ATOM    565  C   PRO A  38     -23.410  51.700  21.037  1.00  0.00           C  
ATOM    566  O   PRO A  38     -22.348  52.081  21.527  1.00  0.00           O  
ATOM    567  CB  PRO A  38     -25.309  53.294  21.425  1.00  0.00           C  
ATOM    568  CG  PRO A  38     -26.536  52.452  21.362  1.00  0.00           C  
ATOM    569  CD  PRO A  38     -26.670  52.019  19.928  1.00  0.00           C  
ATOM    570  HA  PRO A  38     -23.801  53.475  19.906  1.00  0.00           H  
ATOM    571  HB2 PRO A  38     -24.845  53.249  22.401  1.00  0.00           H  
ATOM    572  HB3 PRO A  38     -25.522  54.322  21.170  1.00  0.00           H  
ATOM    573  HG2 PRO A  38     -26.424  51.593  22.004  1.00  0.00           H  
ATOM    574  HG3 PRO A  38     -27.397  53.035  21.659  1.00  0.00           H  
ATOM    575  HD2 PRO A  38     -27.085  51.025  19.872  1.00  0.00           H  
ATOM    576  HD3 PRO A  38     -27.282  52.719  19.379  1.00  0.00           H  
ATOM    577  N   ASP A  39     -23.794  50.427  21.040  1.00  0.00           N  
ATOM    578  CA  ASP A  39     -22.968  49.382  21.635  1.00  0.00           C  
ATOM    579  C   ASP A  39     -22.371  48.483  20.557  1.00  0.00           C  
ATOM    580  O   ASP A  39     -22.073  47.315  20.804  1.00  0.00           O  
ATOM    581  CB  ASP A  39     -23.794  48.546  22.614  1.00  0.00           C  
ATOM    582  CG  ASP A  39     -23.987  49.241  23.948  1.00  0.00           C  
ATOM    583  OD1 ASP A  39     -23.071  49.166  24.793  1.00  0.00           O  
ATOM    584  OD2 ASP A  39     -25.055  49.859  24.146  1.00  0.00           O  
ATOM    585  H   ASP A  39     -24.652  50.185  20.632  1.00  0.00           H  
ATOM    586  HA  ASP A  39     -22.164  49.861  22.172  1.00  0.00           H  
ATOM    587  HB2 ASP A  39     -24.766  48.356  22.184  1.00  0.00           H  
ATOM    588  HB3 ASP A  39     -23.291  47.607  22.788  1.00  0.00           H  
ATOM    589  N   TYR A  40     -22.200  49.035  19.361  1.00  0.00           N  
ATOM    590  CA  TYR A  40     -21.642  48.283  18.244  1.00  0.00           C  
ATOM    591  C   TYR A  40     -20.284  47.690  18.610  1.00  0.00           C  
ATOM    592  O   TYR A  40     -20.106  46.472  18.619  1.00  0.00           O  
ATOM    593  CB  TYR A  40     -21.505  49.181  17.013  1.00  0.00           C  
ATOM    594  CG  TYR A  40     -20.894  48.482  15.819  1.00  0.00           C  
ATOM    595  CD1 TYR A  40     -21.372  47.250  15.392  1.00  0.00           C  
ATOM    596  CD2 TYR A  40     -19.842  49.056  15.117  1.00  0.00           C  
ATOM    597  CE1 TYR A  40     -20.818  46.609  14.301  1.00  0.00           C  
ATOM    598  CE2 TYR A  40     -19.282  48.423  14.024  1.00  0.00           C  
ATOM    599  CZ  TYR A  40     -19.773  47.199  13.621  1.00  0.00           C  
ATOM    600  OH  TYR A  40     -19.220  46.563  12.533  1.00  0.00           O  
ATOM    601  H   TYR A  40     -22.456  49.971  19.225  1.00  0.00           H  
ATOM    602  HA  TYR A  40     -22.323  47.476  18.014  1.00  0.00           H  
ATOM    603  HB2 TYR A  40     -22.481  49.537  16.726  1.00  0.00           H  
ATOM    604  HB3 TYR A  40     -20.876  50.024  17.261  1.00  0.00           H  
ATOM    605  HD1 TYR A  40     -22.191  46.790  15.927  1.00  0.00           H  
ATOM    606  HD2 TYR A  40     -19.460  50.016  15.435  1.00  0.00           H  
ATOM    607  HE1 TYR A  40     -21.202  45.650  13.984  1.00  0.00           H  
ATOM    608  HE2 TYR A  40     -18.464  48.884  13.491  1.00  0.00           H  
ATOM    609  HH  TYR A  40     -18.294  46.377  12.708  1.00  0.00           H  
ATOM    610  N   LEU A  41     -19.329  48.563  18.913  1.00  0.00           N  
ATOM    611  CA  LEU A  41     -17.986  48.129  19.282  1.00  0.00           C  
ATOM    612  C   LEU A  41     -18.011  47.316  20.572  1.00  0.00           C  
ATOM    613  O   LEU A  41     -17.264  46.350  20.724  1.00  0.00           O  
ATOM    614  CB  LEU A  41     -17.064  49.339  19.445  1.00  0.00           C  
ATOM    615  CG  LEU A  41     -17.014  50.308  18.264  1.00  0.00           C  
ATOM    616  CD1 LEU A  41     -16.228  51.558  18.632  1.00  0.00           C  
ATOM    617  CD2 LEU A  41     -16.406  49.632  17.044  1.00  0.00           C  
ATOM    618  H   LEU A  41     -19.531  49.521  18.889  1.00  0.00           H  
ATOM    619  HA  LEU A  41     -17.609  47.505  18.485  1.00  0.00           H  
ATOM    620  HB2 LEU A  41     -17.394  49.891  20.311  1.00  0.00           H  
ATOM    621  HB3 LEU A  41     -16.063  48.971  19.615  1.00  0.00           H  
ATOM    622  HG  LEU A  41     -18.021  50.611  18.012  1.00  0.00           H  
ATOM    623 HD11 LEU A  41     -15.737  51.946  17.752  1.00  0.00           H  
ATOM    624 HD12 LEU A  41     -15.488  51.311  19.378  1.00  0.00           H  
ATOM    625 HD13 LEU A  41     -16.901  52.304  19.025  1.00  0.00           H  
ATOM    626 HD21 LEU A  41     -15.382  49.362  17.257  1.00  0.00           H  
ATOM    627 HD22 LEU A  41     -16.431  50.313  16.205  1.00  0.00           H  
ATOM    628 HD23 LEU A  41     -16.970  48.744  16.805  1.00  0.00           H  
ATOM    629  N   ASP A  42     -18.876  47.714  21.499  1.00  0.00           N  
ATOM    630  CA  ASP A  42     -19.000  47.022  22.776  1.00  0.00           C  
ATOM    631  C   ASP A  42     -18.972  45.508  22.578  1.00  0.00           C  
ATOM    632  O   ASP A  42     -18.635  44.758  23.495  1.00  0.00           O  
ATOM    633  CB  ASP A  42     -20.295  47.433  23.479  1.00  0.00           C  
ATOM    634  CG  ASP A  42     -20.132  48.696  24.300  1.00  0.00           C  
ATOM    635  OD1 ASP A  42     -19.479  48.633  25.363  1.00  0.00           O  
ATOM    636  OD2 ASP A  42     -20.658  49.749  23.882  1.00  0.00           O  
ATOM    637  H   ASP A  42     -19.445  48.492  21.319  1.00  0.00           H  
ATOM    638  HA  ASP A  42     -18.162  47.307  23.392  1.00  0.00           H  
ATOM    639  HB2 ASP A  42     -21.062  47.605  22.737  1.00  0.00           H  
ATOM    640  HB3 ASP A  42     -20.610  46.634  24.136  1.00  0.00           H  
ATOM    641  N   HIS A  43     -19.330  45.068  21.376  1.00  0.00           N  
ATOM    642  CA  HIS A  43     -19.347  43.644  21.059  1.00  0.00           C  
ATOM    643  C   HIS A  43     -18.323  43.317  19.975  1.00  0.00           C  
ATOM    644  O   HIS A  43     -17.843  42.187  19.883  1.00  0.00           O  
ATOM    645  CB  HIS A  43     -20.743  43.217  20.603  1.00  0.00           C  
ATOM    646  CG  HIS A  43     -21.698  42.987  21.735  1.00  0.00           C  
ATOM    647  ND1 HIS A  43     -21.889  41.753  22.317  1.00  0.00           N  
ATOM    648  CD2 HIS A  43     -22.516  43.843  22.388  1.00  0.00           C  
ATOM    649  CE1 HIS A  43     -22.786  41.858  23.282  1.00  0.00           C  
ATOM    650  NE2 HIS A  43     -23.181  43.117  23.347  1.00  0.00           N  
ATOM    651  H   HIS A  43     -19.589  45.715  20.687  1.00  0.00           H  
ATOM    652  HA  HIS A  43     -19.089  43.101  21.955  1.00  0.00           H  
ATOM    653  HB2 HIS A  43     -21.158  43.987  19.970  1.00  0.00           H  
ATOM    654  HB3 HIS A  43     -20.665  42.299  20.040  1.00  0.00           H  
ATOM    655  HD1 HIS A  43     -21.436  40.922  22.061  1.00  0.00           H  
ATOM    656  HD2 HIS A  43     -22.627  44.901  22.196  1.00  0.00           H  
ATOM    657  HE1 HIS A  43     -23.135  41.055  23.912  1.00  0.00           H  
ATOM    658  HE2 HIS A  43     -23.903  43.453  23.919  1.00  0.00           H  
ATOM    659  N   ILE A  44     -17.995  44.313  19.160  1.00  0.00           N  
ATOM    660  CA  ILE A  44     -17.029  44.130  18.084  1.00  0.00           C  
ATOM    661  C   ILE A  44     -15.714  44.834  18.401  1.00  0.00           C  
ATOM    662  O   ILE A  44     -15.676  46.049  18.590  1.00  0.00           O  
ATOM    663  CB  ILE A  44     -17.571  44.661  16.743  1.00  0.00           C  
ATOM    664  CG1 ILE A  44     -18.827  43.889  16.334  1.00  0.00           C  
ATOM    665  CG2 ILE A  44     -16.505  44.560  15.662  1.00  0.00           C  
ATOM    666  CD1 ILE A  44     -18.739  42.404  16.612  1.00  0.00           C  
ATOM    667  H   ILE A  44     -18.412  45.191  19.284  1.00  0.00           H  
ATOM    668  HA  ILE A  44     -16.843  43.071  17.979  1.00  0.00           H  
ATOM    669  HB  ILE A  44     -17.823  45.704  16.870  1.00  0.00           H  
ATOM    670 HG12 ILE A  44     -19.674  44.277  16.877  1.00  0.00           H  
ATOM    671 HG13 ILE A  44     -18.992  44.020  15.275  1.00  0.00           H  
ATOM    672 HG21 ILE A  44     -16.056  43.579  15.692  1.00  0.00           H  
ATOM    673 HG22 ILE A  44     -16.957  44.721  14.696  1.00  0.00           H  
ATOM    674 HG23 ILE A  44     -15.746  45.309  15.836  1.00  0.00           H  
ATOM    675 HD11 ILE A  44     -18.894  42.224  17.665  1.00  0.00           H  
ATOM    676 HD12 ILE A  44     -19.497  41.887  16.043  1.00  0.00           H  
ATOM    677 HD13 ILE A  44     -17.762  42.041  16.325  1.00  0.00           H  
ATOM    678  N   LYS A  45     -14.635  44.060  18.458  1.00  0.00           N  
ATOM    679  CA  LYS A  45     -13.315  44.608  18.750  1.00  0.00           C  
ATOM    680  C   LYS A  45     -12.699  45.238  17.503  1.00  0.00           C  
ATOM    681  O   LYS A  45     -12.053  46.283  17.578  1.00  0.00           O  
ATOM    682  CB  LYS A  45     -12.392  43.512  19.288  1.00  0.00           C  
ATOM    683  CG  LYS A  45     -12.631  43.183  20.752  1.00  0.00           C  
ATOM    684  CD  LYS A  45     -12.074  44.264  21.664  1.00  0.00           C  
ATOM    685  CE  LYS A  45     -11.760  43.718  23.049  1.00  0.00           C  
ATOM    686  NZ  LYS A  45     -10.989  44.694  23.868  1.00  0.00           N  
ATOM    687  H   LYS A  45     -14.727  43.098  18.298  1.00  0.00           H  
ATOM    688  HA  LYS A  45     -13.431  45.372  19.504  1.00  0.00           H  
ATOM    689  HB2 LYS A  45     -12.545  42.613  18.710  1.00  0.00           H  
ATOM    690  HB3 LYS A  45     -11.367  43.833  19.176  1.00  0.00           H  
ATOM    691  HG2 LYS A  45     -13.693  43.094  20.925  1.00  0.00           H  
ATOM    692  HG3 LYS A  45     -12.147  42.245  20.984  1.00  0.00           H  
ATOM    693  HD2 LYS A  45     -11.166  44.657  21.230  1.00  0.00           H  
ATOM    694  HD3 LYS A  45     -12.804  45.056  21.756  1.00  0.00           H  
ATOM    695  HE2 LYS A  45     -12.688  43.492  23.552  1.00  0.00           H  
ATOM    696  HE3 LYS A  45     -11.180  42.813  22.940  1.00  0.00           H  
ATOM    697  HZ1 LYS A  45     -10.513  45.382  23.249  1.00  0.00           H  
ATOM    698  HZ2 LYS A  45     -10.269  44.196  24.431  1.00  0.00           H  
ATOM    699  HZ3 LYS A  45     -11.626  45.204  24.511  1.00  0.00           H  
ATOM    700  N   LYS A  46     -12.904  44.594  16.359  1.00  0.00           N  
ATOM    701  CA  LYS A  46     -12.372  45.090  15.096  1.00  0.00           C  
ATOM    702  C   LYS A  46     -13.448  45.091  14.014  1.00  0.00           C  
ATOM    703  O   LYS A  46     -13.594  44.137  13.250  1.00  0.00           O  
ATOM    704  CB  LYS A  46     -11.184  44.237  14.646  1.00  0.00           C  
ATOM    705  CG  LYS A  46     -10.587  44.672  13.319  1.00  0.00           C  
ATOM    706  CD  LYS A  46      -9.248  44.002  13.064  1.00  0.00           C  
ATOM    707  CE  LYS A  46      -8.869  44.059  11.592  1.00  0.00           C  
ATOM    708  NZ  LYS A  46      -8.479  45.433  11.173  1.00  0.00           N  
ATOM    709  H   LYS A  46     -13.427  43.765  16.364  1.00  0.00           H  
ATOM    710  HA  LYS A  46     -12.036  46.105  15.253  1.00  0.00           H  
ATOM    711  HB2 LYS A  46     -10.412  44.292  15.401  1.00  0.00           H  
ATOM    712  HB3 LYS A  46     -11.509  43.211  14.553  1.00  0.00           H  
ATOM    713  HG2 LYS A  46     -11.268  44.407  12.525  1.00  0.00           H  
ATOM    714  HG3 LYS A  46     -10.447  45.744  13.334  1.00  0.00           H  
ATOM    715  HD2 LYS A  46      -8.487  44.507  13.640  1.00  0.00           H  
ATOM    716  HD3 LYS A  46      -9.308  42.968  13.371  1.00  0.00           H  
ATOM    717  HE2 LYS A  46      -8.039  43.391  11.421  1.00  0.00           H  
ATOM    718  HE3 LYS A  46      -9.716  43.739  11.003  1.00  0.00           H  
ATOM    719  HZ1 LYS A  46      -9.305  45.941  10.798  1.00  0.00           H  
ATOM    720  HZ2 LYS A  46      -7.749  45.387  10.432  1.00  0.00           H  
ATOM    721  HZ3 LYS A  46      -8.099  45.962  11.985  1.00  0.00           H  
ATOM    722  N   PRO A  47     -14.219  46.186  13.947  1.00  0.00           N  
ATOM    723  CA  PRO A  47     -15.294  46.337  12.961  1.00  0.00           C  
ATOM    724  C   PRO A  47     -14.762  46.506  11.543  1.00  0.00           C  
ATOM    725  O   PRO A  47     -14.071  47.479  11.242  1.00  0.00           O  
ATOM    726  CB  PRO A  47     -16.017  47.609  13.416  1.00  0.00           C  
ATOM    727  CG  PRO A  47     -14.987  48.381  14.164  1.00  0.00           C  
ATOM    728  CD  PRO A  47     -14.103  47.361  14.826  1.00  0.00           C  
ATOM    729  HA  PRO A  47     -15.979  45.502  12.990  1.00  0.00           H  
ATOM    730  HB2 PRO A  47     -16.370  48.153  12.551  1.00  0.00           H  
ATOM    731  HB3 PRO A  47     -16.850  47.345  14.049  1.00  0.00           H  
ATOM    732  HG2 PRO A  47     -14.413  48.987  13.480  1.00  0.00           H  
ATOM    733  HG3 PRO A  47     -15.464  49.002  14.909  1.00  0.00           H  
ATOM    734  HD2 PRO A  47     -13.082  47.714  14.866  1.00  0.00           H  
ATOM    735  HD3 PRO A  47     -14.463  47.136  15.819  1.00  0.00           H  
ATOM    736  N   MET A  48     -15.086  45.552  10.676  1.00  0.00           N  
ATOM    737  CA  MET A  48     -14.640  45.598   9.289  1.00  0.00           C  
ATOM    738  C   MET A  48     -15.828  45.537   8.334  1.00  0.00           C  
ATOM    739  O   MET A  48     -16.856  44.935   8.643  1.00  0.00           O  
ATOM    740  CB  MET A  48     -13.682  44.440   9.000  1.00  0.00           C  
ATOM    741  CG  MET A  48     -13.030  44.518   7.630  1.00  0.00           C  
ATOM    742  SD  MET A  48     -11.844  45.870   7.499  1.00  0.00           S  
ATOM    743  CE  MET A  48     -10.815  45.557   8.930  1.00  0.00           C  
ATOM    744  H   MET A  48     -15.638  44.801  10.976  1.00  0.00           H  
ATOM    745  HA  MET A  48     -14.118  46.530   9.138  1.00  0.00           H  
ATOM    746  HB2 MET A  48     -12.900  44.441   9.746  1.00  0.00           H  
ATOM    747  HB3 MET A  48     -14.227  43.511   9.064  1.00  0.00           H  
ATOM    748  HG2 MET A  48     -12.515  43.588   7.436  1.00  0.00           H  
ATOM    749  HG3 MET A  48     -13.801  44.660   6.887  1.00  0.00           H  
ATOM    750  HE1 MET A  48      -9.777  45.715   8.670  1.00  0.00           H  
ATOM    751  HE2 MET A  48     -11.092  46.230   9.728  1.00  0.00           H  
ATOM    752  HE3 MET A  48     -10.952  44.535   9.256  1.00  0.00           H  
ATOM    753  N   ASP A  49     -15.680  46.166   7.173  1.00  0.00           N  
ATOM    754  CA  ASP A  49     -16.741  46.184   6.172  1.00  0.00           C  
ATOM    755  C   ASP A  49     -16.159  46.267   4.765  1.00  0.00           C  
ATOM    756  O   ASP A  49     -14.958  46.475   4.590  1.00  0.00           O  
ATOM    757  CB  ASP A  49     -17.683  47.363   6.418  1.00  0.00           C  
ATOM    758  CG  ASP A  49     -16.963  48.573   6.982  1.00  0.00           C  
ATOM    759  OD1 ASP A  49     -16.324  48.439   8.045  1.00  0.00           O  
ATOM    760  OD2 ASP A  49     -17.039  49.652   6.357  1.00  0.00           O  
ATOM    761  H   ASP A  49     -14.837  46.628   6.983  1.00  0.00           H  
ATOM    762  HA  ASP A  49     -17.298  45.264   6.264  1.00  0.00           H  
ATOM    763  HB2 ASP A  49     -18.147  47.646   5.484  1.00  0.00           H  
ATOM    764  HB3 ASP A  49     -18.449  47.063   7.119  1.00  0.00           H  
ATOM    765  N   PHE A  50     -17.017  46.103   3.764  1.00  0.00           N  
ATOM    766  CA  PHE A  50     -16.588  46.158   2.370  1.00  0.00           C  
ATOM    767  C   PHE A  50     -16.000  47.526   2.036  1.00  0.00           C  
ATOM    768  O   PHE A  50     -15.032  47.631   1.284  1.00  0.00           O  
ATOM    769  CB  PHE A  50     -17.765  45.855   1.441  1.00  0.00           C  
ATOM    770  CG  PHE A  50     -17.931  44.391   1.144  1.00  0.00           C  
ATOM    771  CD1 PHE A  50     -16.848  43.621   0.757  1.00  0.00           C  
ATOM    772  CD2 PHE A  50     -19.174  43.787   1.252  1.00  0.00           C  
ATOM    773  CE1 PHE A  50     -16.998  42.275   0.483  1.00  0.00           C  
ATOM    774  CE2 PHE A  50     -19.330  42.441   0.980  1.00  0.00           C  
ATOM    775  CZ  PHE A  50     -18.241  41.684   0.594  1.00  0.00           C  
ATOM    776  H   PHE A  50     -17.963  45.941   3.966  1.00  0.00           H  
ATOM    777  HA  PHE A  50     -15.826  45.408   2.231  1.00  0.00           H  
ATOM    778  HB2 PHE A  50     -18.677  46.206   1.898  1.00  0.00           H  
ATOM    779  HB3 PHE A  50     -17.615  46.368   0.504  1.00  0.00           H  
ATOM    780  HD1 PHE A  50     -15.874  44.082   0.668  1.00  0.00           H  
ATOM    781  HD2 PHE A  50     -20.027  44.378   1.554  1.00  0.00           H  
ATOM    782  HE1 PHE A  50     -16.143  41.686   0.182  1.00  0.00           H  
ATOM    783  HE2 PHE A  50     -20.304  41.982   1.068  1.00  0.00           H  
ATOM    784  HZ  PHE A  50     -18.361  40.631   0.382  1.00  0.00           H  
ATOM    785  N   PHE A  51     -16.593  48.571   2.601  1.00  0.00           N  
ATOM    786  CA  PHE A  51     -16.132  49.934   2.363  1.00  0.00           C  
ATOM    787  C   PHE A  51     -14.828  50.205   3.107  1.00  0.00           C  
ATOM    788  O   PHE A  51     -13.894  50.790   2.559  1.00  0.00           O  
ATOM    789  CB  PHE A  51     -17.197  50.941   2.796  1.00  0.00           C  
ATOM    790  CG  PHE A  51     -16.638  52.285   3.167  1.00  0.00           C  
ATOM    791  CD1 PHE A  51     -16.353  53.225   2.190  1.00  0.00           C  
ATOM    792  CD2 PHE A  51     -16.396  52.607   4.493  1.00  0.00           C  
ATOM    793  CE1 PHE A  51     -15.838  54.462   2.528  1.00  0.00           C  
ATOM    794  CE2 PHE A  51     -15.883  53.843   4.837  1.00  0.00           C  
ATOM    795  CZ  PHE A  51     -15.602  54.771   3.854  1.00  0.00           C  
ATOM    796  H   PHE A  51     -17.362  48.425   3.192  1.00  0.00           H  
ATOM    797  HA  PHE A  51     -15.955  50.043   1.303  1.00  0.00           H  
ATOM    798  HB2 PHE A  51     -17.896  51.086   1.986  1.00  0.00           H  
ATOM    799  HB3 PHE A  51     -17.723  50.551   3.655  1.00  0.00           H  
ATOM    800  HD1 PHE A  51     -16.538  52.985   1.152  1.00  0.00           H  
ATOM    801  HD2 PHE A  51     -16.614  51.882   5.263  1.00  0.00           H  
ATOM    802  HE1 PHE A  51     -15.620  55.186   1.757  1.00  0.00           H  
ATOM    803  HE2 PHE A  51     -15.698  54.082   5.873  1.00  0.00           H  
ATOM    804  HZ  PHE A  51     -15.200  55.737   4.120  1.00  0.00           H  
ATOM    805  N   THR A  52     -14.770  49.774   4.364  1.00  0.00           N  
ATOM    806  CA  THR A  52     -13.584  49.969   5.187  1.00  0.00           C  
ATOM    807  C   THR A  52     -12.378  49.254   4.591  1.00  0.00           C  
ATOM    808  O   THR A  52     -11.342  49.869   4.337  1.00  0.00           O  
ATOM    809  CB  THR A  52     -13.808  49.465   6.624  1.00  0.00           C  
ATOM    810  OG1 THR A  52     -14.639  50.384   7.342  1.00  0.00           O  
ATOM    811  CG2 THR A  52     -12.482  49.298   7.352  1.00  0.00           C  
ATOM    812  H   THR A  52     -15.548  49.314   4.746  1.00  0.00           H  
ATOM    813  HA  THR A  52     -13.378  51.030   5.227  1.00  0.00           H  
ATOM    814  HB  THR A  52     -14.301  48.504   6.580  1.00  0.00           H  
ATOM    815  HG1 THR A  52     -14.501  50.270   8.286  1.00  0.00           H  
ATOM    816 HG21 THR A  52     -11.913  50.213   7.279  1.00  0.00           H  
ATOM    817 HG22 THR A  52     -11.923  48.490   6.902  1.00  0.00           H  
ATOM    818 HG23 THR A  52     -12.667  49.071   8.391  1.00  0.00           H  
ATOM    819  N   MET A  53     -12.518  47.950   4.368  1.00  0.00           N  
ATOM    820  CA  MET A  53     -11.439  47.152   3.800  1.00  0.00           C  
ATOM    821  C   MET A  53     -10.888  47.803   2.536  1.00  0.00           C  
ATOM    822  O   MET A  53      -9.683  47.777   2.287  1.00  0.00           O  
ATOM    823  CB  MET A  53     -11.934  45.739   3.485  1.00  0.00           C  
ATOM    824  CG  MET A  53     -12.956  45.690   2.361  1.00  0.00           C  
ATOM    825  SD  MET A  53     -13.510  44.013   1.998  1.00  0.00           S  
ATOM    826  CE  MET A  53     -11.993  43.094   2.250  1.00  0.00           C  
ATOM    827  H   MET A  53     -13.368  47.516   4.592  1.00  0.00           H  
ATOM    828  HA  MET A  53     -10.651  47.091   4.534  1.00  0.00           H  
ATOM    829  HB2 MET A  53     -11.090  45.130   3.200  1.00  0.00           H  
ATOM    830  HB3 MET A  53     -12.387  45.322   4.371  1.00  0.00           H  
ATOM    831  HG2 MET A  53     -13.814  46.282   2.645  1.00  0.00           H  
ATOM    832  HG3 MET A  53     -12.512  46.108   1.470  1.00  0.00           H  
ATOM    833  HE1 MET A  53     -12.119  42.086   1.883  1.00  0.00           H  
ATOM    834  HE2 MET A  53     -11.189  43.574   1.714  1.00  0.00           H  
ATOM    835  HE3 MET A  53     -11.760  43.067   3.303  1.00  0.00           H  
ATOM    836  N   LYS A  54     -11.777  48.389   1.742  1.00  0.00           N  
ATOM    837  CA  LYS A  54     -11.380  49.050   0.504  1.00  0.00           C  
ATOM    838  C   LYS A  54     -10.361  50.152   0.777  1.00  0.00           C  
ATOM    839  O   LYS A  54      -9.281  50.172   0.189  1.00  0.00           O  
ATOM    840  CB  LYS A  54     -12.604  49.637  -0.201  1.00  0.00           C  
ATOM    841  CG  LYS A  54     -12.443  49.748  -1.708  1.00  0.00           C  
ATOM    842  CD  LYS A  54     -11.298  50.674  -2.080  1.00  0.00           C  
ATOM    843  CE  LYS A  54     -11.501  51.284  -3.459  1.00  0.00           C  
ATOM    844  NZ  LYS A  54     -12.406  52.466  -3.415  1.00  0.00           N  
ATOM    845  H   LYS A  54     -12.724  48.378   1.994  1.00  0.00           H  
ATOM    846  HA  LYS A  54     -10.926  48.309  -0.136  1.00  0.00           H  
ATOM    847  HB2 LYS A  54     -13.458  49.008   0.004  1.00  0.00           H  
ATOM    848  HB3 LYS A  54     -12.793  50.625   0.193  1.00  0.00           H  
ATOM    849  HG2 LYS A  54     -12.246  48.767  -2.113  1.00  0.00           H  
ATOM    850  HG3 LYS A  54     -13.360  50.134  -2.130  1.00  0.00           H  
ATOM    851  HD2 LYS A  54     -11.239  51.469  -1.352  1.00  0.00           H  
ATOM    852  HD3 LYS A  54     -10.376  50.110  -2.077  1.00  0.00           H  
ATOM    853  HE2 LYS A  54     -10.541  51.590  -3.847  1.00  0.00           H  
ATOM    854  HE3 LYS A  54     -11.930  50.537  -4.108  1.00  0.00           H  
ATOM    855  HZ1 LYS A  54     -13.206  52.327  -4.064  1.00  0.00           H  
ATOM    856  HZ2 LYS A  54     -11.888  53.322  -3.698  1.00  0.00           H  
ATOM    857  HZ3 LYS A  54     -12.774  52.599  -2.451  1.00  0.00           H  
ATOM    858  N   GLN A  55     -10.712  51.067   1.677  1.00  0.00           N  
ATOM    859  CA  GLN A  55      -9.828  52.171   2.028  1.00  0.00           C  
ATOM    860  C   GLN A  55      -8.428  51.662   2.360  1.00  0.00           C  
ATOM    861  O   GLN A  55      -7.440  52.117   1.786  1.00  0.00           O  
ATOM    862  CB  GLN A  55     -10.395  52.948   3.217  1.00  0.00           C  
ATOM    863  CG  GLN A  55     -11.812  53.452   2.992  1.00  0.00           C  
ATOM    864  CD  GLN A  55     -11.850  54.796   2.293  1.00  0.00           C  
ATOM    865  OE1 GLN A  55     -11.267  55.772   2.767  1.00  0.00           O  
ATOM    866  NE2 GLN A  55     -12.540  54.855   1.159  1.00  0.00           N  
ATOM    867  H   GLN A  55     -11.586  50.996   2.112  1.00  0.00           H  
ATOM    868  HA  GLN A  55      -9.764  52.829   1.176  1.00  0.00           H  
ATOM    869  HB2 GLN A  55     -10.398  52.306   4.085  1.00  0.00           H  
ATOM    870  HB3 GLN A  55      -9.762  53.800   3.410  1.00  0.00           H  
ATOM    871  HG2 GLN A  55     -12.345  52.734   2.387  1.00  0.00           H  
ATOM    872  HG3 GLN A  55     -12.303  53.546   3.951  1.00  0.00           H  
ATOM    873 HE21 GLN A  55     -12.980  54.038   0.843  1.00  0.00           H  
ATOM    874 HE22 GLN A  55     -12.582  55.711   0.687  1.00  0.00           H  
ATOM    875  N   ASN A  56      -8.353  50.717   3.291  1.00  0.00           N  
ATOM    876  CA  ASN A  56      -7.074  50.148   3.700  1.00  0.00           C  
ATOM    877  C   ASN A  56      -6.324  49.577   2.501  1.00  0.00           C  
ATOM    878  O   ASN A  56      -5.111  49.757   2.370  1.00  0.00           O  
ATOM    879  CB  ASN A  56      -7.291  49.054   4.747  1.00  0.00           C  
ATOM    880  CG  ASN A  56      -8.099  49.541   5.935  1.00  0.00           C  
ATOM    881  OD1 ASN A  56      -8.219  50.744   6.166  1.00  0.00           O  
ATOM    882  ND2 ASN A  56      -8.656  48.606   6.695  1.00  0.00           N  
ATOM    883  H   ASN A  56      -9.177  50.395   3.714  1.00  0.00           H  
ATOM    884  HA  ASN A  56      -6.484  50.938   4.136  1.00  0.00           H  
ATOM    885  HB2 ASN A  56      -7.819  48.228   4.292  1.00  0.00           H  
ATOM    886  HB3 ASN A  56      -6.332  48.710   5.104  1.00  0.00           H  
ATOM    887 HD21 ASN A  56      -8.518  47.667   6.450  1.00  0.00           H  
ATOM    888 HD22 ASN A  56      -9.185  48.894   7.468  1.00  0.00           H  
ATOM    889  N   LEU A  57      -7.051  48.891   1.627  1.00  0.00           N  
ATOM    890  CA  LEU A  57      -6.455  48.294   0.436  1.00  0.00           C  
ATOM    891  C   LEU A  57      -5.873  49.368  -0.478  1.00  0.00           C  
ATOM    892  O   LEU A  57      -4.771  49.217  -1.005  1.00  0.00           O  
ATOM    893  CB  LEU A  57      -7.498  47.472  -0.324  1.00  0.00           C  
ATOM    894  CG  LEU A  57      -7.110  47.038  -1.737  1.00  0.00           C  
ATOM    895  CD1 LEU A  57      -7.798  45.731  -2.101  1.00  0.00           C  
ATOM    896  CD2 LEU A  57      -7.460  48.124  -2.744  1.00  0.00           C  
ATOM    897  H   LEU A  57      -8.011  48.781   1.785  1.00  0.00           H  
ATOM    898  HA  LEU A  57      -5.658  47.641   0.758  1.00  0.00           H  
ATOM    899  HB2 LEU A  57      -7.700  46.582   0.252  1.00  0.00           H  
ATOM    900  HB3 LEU A  57      -8.398  48.066  -0.394  1.00  0.00           H  
ATOM    901  HG  LEU A  57      -6.042  46.875  -1.777  1.00  0.00           H  
ATOM    902 HD11 LEU A  57      -8.676  45.939  -2.693  1.00  0.00           H  
ATOM    903 HD12 LEU A  57      -8.086  45.212  -1.198  1.00  0.00           H  
ATOM    904 HD13 LEU A  57      -7.117  45.113  -2.669  1.00  0.00           H  
ATOM    905 HD21 LEU A  57      -6.563  48.656  -3.025  1.00  0.00           H  
ATOM    906 HD22 LEU A  57      -8.162  48.815  -2.298  1.00  0.00           H  
ATOM    907 HD23 LEU A  57      -7.903  47.675  -3.619  1.00  0.00           H  
ATOM    908  N   GLU A  58      -6.620  50.452  -0.658  1.00  0.00           N  
ATOM    909  CA  GLU A  58      -6.177  51.552  -1.508  1.00  0.00           C  
ATOM    910  C   GLU A  58      -4.999  52.286  -0.876  1.00  0.00           C  
ATOM    911  O   GLU A  58      -4.288  53.036  -1.545  1.00  0.00           O  
ATOM    912  CB  GLU A  58      -7.327  52.530  -1.757  1.00  0.00           C  
ATOM    913  CG  GLU A  58      -8.417  51.971  -2.655  1.00  0.00           C  
ATOM    914  CD  GLU A  58      -8.088  52.113  -4.128  1.00  0.00           C  
ATOM    915  OE1 GLU A  58      -7.780  53.243  -4.562  1.00  0.00           O  
ATOM    916  OE2 GLU A  58      -8.138  51.094  -4.848  1.00  0.00           O  
ATOM    917  H   GLU A  58      -7.490  50.514  -0.211  1.00  0.00           H  
ATOM    918  HA  GLU A  58      -5.861  51.134  -2.452  1.00  0.00           H  
ATOM    919  HB2 GLU A  58      -7.771  52.794  -0.808  1.00  0.00           H  
ATOM    920  HB3 GLU A  58      -6.932  53.422  -2.218  1.00  0.00           H  
ATOM    921  HG2 GLU A  58      -8.549  50.923  -2.432  1.00  0.00           H  
ATOM    922  HG3 GLU A  58      -9.339  52.499  -2.455  1.00  0.00           H  
ATOM    923  N   ALA A  59      -4.797  52.065   0.419  1.00  0.00           N  
ATOM    924  CA  ALA A  59      -3.704  52.704   1.142  1.00  0.00           C  
ATOM    925  C   ALA A  59      -2.476  51.801   1.193  1.00  0.00           C  
ATOM    926  O   ALA A  59      -1.518  52.080   1.912  1.00  0.00           O  
ATOM    927  CB  ALA A  59      -4.148  53.074   2.550  1.00  0.00           C  
ATOM    928  H   ALA A  59      -5.396  51.457   0.899  1.00  0.00           H  
ATOM    929  HA  ALA A  59      -3.448  53.615   0.621  1.00  0.00           H  
ATOM    930  HB1 ALA A  59      -5.146  52.701   2.722  1.00  0.00           H  
ATOM    931  HB2 ALA A  59      -3.470  52.636   3.268  1.00  0.00           H  
ATOM    932  HB3 ALA A  59      -4.142  54.148   2.659  1.00  0.00           H  
ATOM    933  N   TYR A  60      -2.514  50.717   0.424  1.00  0.00           N  
ATOM    934  CA  TYR A  60      -1.406  49.770   0.385  1.00  0.00           C  
ATOM    935  C   TYR A  60      -1.155  49.166   1.763  1.00  0.00           C  
ATOM    936  O   TYR A  60      -0.009  48.998   2.181  1.00  0.00           O  
ATOM    937  CB  TYR A  60      -0.137  50.460  -0.120  1.00  0.00           C  
ATOM    938  CG  TYR A  60      -0.146  50.730  -1.608  1.00  0.00           C  
ATOM    939  CD1 TYR A  60      -1.175  51.456  -2.195  1.00  0.00           C  
ATOM    940  CD2 TYR A  60       0.873  50.261  -2.426  1.00  0.00           C  
ATOM    941  CE1 TYR A  60      -1.189  51.706  -3.554  1.00  0.00           C  
ATOM    942  CE2 TYR A  60       0.868  50.505  -3.785  1.00  0.00           C  
ATOM    943  CZ  TYR A  60      -0.164  51.228  -4.344  1.00  0.00           C  
ATOM    944  OH  TYR A  60      -0.174  51.475  -5.698  1.00  0.00           O  
ATOM    945  H   TYR A  60      -3.306  50.548  -0.126  1.00  0.00           H  
ATOM    946  HA  TYR A  60      -1.670  48.978  -0.300  1.00  0.00           H  
ATOM    947  HB2 TYR A  60      -0.023  51.404   0.388  1.00  0.00           H  
ATOM    948  HB3 TYR A  60       0.716  49.833   0.098  1.00  0.00           H  
ATOM    949  HD1 TYR A  60      -1.977  51.828  -1.572  1.00  0.00           H  
ATOM    950  HD2 TYR A  60       1.680  49.694  -1.985  1.00  0.00           H  
ATOM    951  HE1 TYR A  60      -1.998  52.272  -3.991  1.00  0.00           H  
ATOM    952  HE2 TYR A  60       1.670  50.132  -4.405  1.00  0.00           H  
ATOM    953  HH  TYR A  60       0.465  50.903  -6.131  1.00  0.00           H  
ATOM    954  N   ARG A  61      -2.236  48.842   2.465  1.00  0.00           N  
ATOM    955  CA  ARG A  61      -2.134  48.257   3.797  1.00  0.00           C  
ATOM    956  C   ARG A  61      -2.074  46.734   3.719  1.00  0.00           C  
ATOM    957  O   ARG A  61      -1.576  46.074   4.631  1.00  0.00           O  
ATOM    958  CB  ARG A  61      -3.324  48.686   4.658  1.00  0.00           C  
ATOM    959  CG  ARG A  61      -3.240  50.126   5.138  1.00  0.00           C  
ATOM    960  CD  ARG A  61      -3.965  50.315   6.461  1.00  0.00           C  
ATOM    961  NE  ARG A  61      -3.782  51.661   6.997  1.00  0.00           N  
ATOM    962  CZ  ARG A  61      -4.364  52.094   8.110  1.00  0.00           C  
ATOM    963  NH1 ARG A  61      -5.162  51.289   8.801  1.00  0.00           N  
ATOM    964  NH2 ARG A  61      -4.149  53.332   8.535  1.00  0.00           N  
ATOM    965  H   ARG A  61      -3.123  49.000   2.079  1.00  0.00           H  
ATOM    966  HA  ARG A  61      -1.224  48.619   4.250  1.00  0.00           H  
ATOM    967  HB2 ARG A  61      -4.231  48.575   4.081  1.00  0.00           H  
ATOM    968  HB3 ARG A  61      -3.378  48.044   5.524  1.00  0.00           H  
ATOM    969  HG2 ARG A  61      -2.202  50.392   5.269  1.00  0.00           H  
ATOM    970  HG3 ARG A  61      -3.688  50.770   4.396  1.00  0.00           H  
ATOM    971  HD2 ARG A  61      -5.020  50.140   6.307  1.00  0.00           H  
ATOM    972  HD3 ARG A  61      -3.582  49.598   7.172  1.00  0.00           H  
ATOM    973  HE  ARG A  61      -3.197  52.270   6.504  1.00  0.00           H  
ATOM    974 HH11 ARG A  61      -5.325  50.357   8.483  1.00  0.00           H  
ATOM    975 HH12 ARG A  61      -5.598  51.618   9.640  1.00  0.00           H  
ATOM    976 HH21 ARG A  61      -3.549  53.941   8.018  1.00  0.00           H  
ATOM    977 HH22 ARG A  61      -4.588  53.657   9.372  1.00  0.00           H  
ATOM    978  N   TYR A  62      -2.584  46.182   2.622  1.00  0.00           N  
ATOM    979  CA  TYR A  62      -2.590  44.737   2.427  1.00  0.00           C  
ATOM    980  C   TYR A  62      -1.535  44.322   1.406  1.00  0.00           C  
ATOM    981  O   TYR A  62      -1.671  44.586   0.212  1.00  0.00           O  
ATOM    982  CB  TYR A  62      -3.972  44.271   1.965  1.00  0.00           C  
ATOM    983  CG  TYR A  62      -5.098  44.733   2.862  1.00  0.00           C  
ATOM    984  CD1 TYR A  62      -5.032  44.562   4.239  1.00  0.00           C  
ATOM    985  CD2 TYR A  62      -6.229  45.343   2.332  1.00  0.00           C  
ATOM    986  CE1 TYR A  62      -6.058  44.983   5.062  1.00  0.00           C  
ATOM    987  CE2 TYR A  62      -7.260  45.768   3.147  1.00  0.00           C  
ATOM    988  CZ  TYR A  62      -7.170  45.586   4.511  1.00  0.00           C  
ATOM    989  OH  TYR A  62      -8.195  46.008   5.327  1.00  0.00           O  
ATOM    990  H   TYR A  62      -2.967  46.761   1.930  1.00  0.00           H  
ATOM    991  HA  TYR A  62      -2.363  44.272   3.374  1.00  0.00           H  
ATOM    992  HB2 TYR A  62      -4.161  44.651   0.974  1.00  0.00           H  
ATOM    993  HB3 TYR A  62      -3.991  43.191   1.940  1.00  0.00           H  
ATOM    994  HD1 TYR A  62      -4.159  44.089   4.668  1.00  0.00           H  
ATOM    995  HD2 TYR A  62      -6.296  45.485   1.262  1.00  0.00           H  
ATOM    996  HE1 TYR A  62      -5.989  44.840   6.130  1.00  0.00           H  
ATOM    997  HE2 TYR A  62      -8.131  46.240   2.717  1.00  0.00           H  
ATOM    998  HH  TYR A  62      -8.962  45.446   5.194  1.00  0.00           H  
ATOM    999  N   LEU A  63      -0.482  43.669   1.888  1.00  0.00           N  
ATOM   1000  CA  LEU A  63       0.598  43.214   1.021  1.00  0.00           C  
ATOM   1001  C   LEU A  63       0.550  41.701   0.837  1.00  0.00           C  
ATOM   1002  O   LEU A  63       1.037  41.171  -0.160  1.00  0.00           O  
ATOM   1003  CB  LEU A  63       1.953  43.627   1.600  1.00  0.00           C  
ATOM   1004  CG  LEU A  63       2.098  45.100   1.985  1.00  0.00           C  
ATOM   1005  CD1 LEU A  63       3.124  45.263   3.094  1.00  0.00           C  
ATOM   1006  CD2 LEU A  63       2.484  45.932   0.773  1.00  0.00           C  
ATOM   1007  H   LEU A  63      -0.431  43.487   2.849  1.00  0.00           H  
ATOM   1008  HA  LEU A  63       0.470  43.685   0.057  1.00  0.00           H  
ATOM   1009  HB2 LEU A  63       2.127  43.036   2.485  1.00  0.00           H  
ATOM   1010  HB3 LEU A  63       2.711  43.399   0.863  1.00  0.00           H  
ATOM   1011  HG  LEU A  63       1.148  45.464   2.353  1.00  0.00           H  
ATOM   1012 HD11 LEU A  63       3.489  44.292   3.393  1.00  0.00           H  
ATOM   1013 HD12 LEU A  63       2.664  45.750   3.942  1.00  0.00           H  
ATOM   1014 HD13 LEU A  63       3.948  45.864   2.738  1.00  0.00           H  
ATOM   1015 HD21 LEU A  63       2.745  46.931   1.089  1.00  0.00           H  
ATOM   1016 HD22 LEU A  63       1.650  45.978   0.086  1.00  0.00           H  
ATOM   1017 HD23 LEU A  63       3.332  45.478   0.279  1.00  0.00           H  
ATOM   1018  N   ASN A  64      -0.040  41.012   1.808  1.00  0.00           N  
ATOM   1019  CA  ASN A  64      -0.155  39.558   1.753  1.00  0.00           C  
ATOM   1020  C   ASN A  64      -1.617  39.125   1.786  1.00  0.00           C  
ATOM   1021  O   ASN A  64      -2.370  39.510   2.682  1.00  0.00           O  
ATOM   1022  CB  ASN A  64       0.604  38.922   2.920  1.00  0.00           C  
ATOM   1023  CG  ASN A  64       1.895  39.652   3.237  1.00  0.00           C  
ATOM   1024  OD1 ASN A  64       2.934  39.389   2.629  1.00  0.00           O  
ATOM   1025  ND2 ASN A  64       1.836  40.575   4.189  1.00  0.00           N  
ATOM   1026  H   ASN A  64      -0.409  41.490   2.579  1.00  0.00           H  
ATOM   1027  HA  ASN A  64       0.286  39.226   0.825  1.00  0.00           H  
ATOM   1028  HB2 ASN A  64      -0.022  38.941   3.800  1.00  0.00           H  
ATOM   1029  HB3 ASN A  64       0.841  37.898   2.672  1.00  0.00           H  
ATOM   1030 HD21 ASN A  64       0.974  40.731   4.630  1.00  0.00           H  
ATOM   1031 HD22 ASN A  64       2.656  41.061   4.413  1.00  0.00           H  
ATOM   1032  N   PHE A  65      -2.013  38.322   0.804  1.00  0.00           N  
ATOM   1033  CA  PHE A  65      -3.386  37.836   0.721  1.00  0.00           C  
ATOM   1034  C   PHE A  65      -3.967  37.604   2.113  1.00  0.00           C  
ATOM   1035  O   PHE A  65      -5.007  38.159   2.463  1.00  0.00           O  
ATOM   1036  CB  PHE A  65      -3.442  36.541  -0.091  1.00  0.00           C  
ATOM   1037  CG  PHE A  65      -4.795  36.258  -0.677  1.00  0.00           C  
ATOM   1038  CD1 PHE A  65      -5.749  35.567   0.050  1.00  0.00           C  
ATOM   1039  CD2 PHE A  65      -5.113  36.686  -1.958  1.00  0.00           C  
ATOM   1040  CE1 PHE A  65      -6.997  35.307  -0.487  1.00  0.00           C  
ATOM   1041  CE2 PHE A  65      -6.358  36.428  -2.500  1.00  0.00           C  
ATOM   1042  CZ  PHE A  65      -7.300  35.736  -1.763  1.00  0.00           C  
ATOM   1043  H   PHE A  65      -1.366  38.050   0.120  1.00  0.00           H  
ATOM   1044  HA  PHE A  65      -3.973  38.590   0.220  1.00  0.00           H  
ATOM   1045  HB2 PHE A  65      -2.734  36.603  -0.904  1.00  0.00           H  
ATOM   1046  HB3 PHE A  65      -3.176  35.713   0.549  1.00  0.00           H  
ATOM   1047  HD1 PHE A  65      -5.513  35.229   1.050  1.00  0.00           H  
ATOM   1048  HD2 PHE A  65      -4.376  37.225  -2.534  1.00  0.00           H  
ATOM   1049  HE1 PHE A  65      -7.732  34.765   0.091  1.00  0.00           H  
ATOM   1050  HE2 PHE A  65      -6.592  36.766  -3.498  1.00  0.00           H  
ATOM   1051  HZ  PHE A  65      -8.274  35.535  -2.185  1.00  0.00           H  
ATOM   1052  N   ASP A  66      -3.285  36.779   2.901  1.00  0.00           N  
ATOM   1053  CA  ASP A  66      -3.732  36.473   4.255  1.00  0.00           C  
ATOM   1054  C   ASP A  66      -4.381  37.693   4.902  1.00  0.00           C  
ATOM   1055  O   ASP A  66      -5.486  37.610   5.436  1.00  0.00           O  
ATOM   1056  CB  ASP A  66      -2.555  35.994   5.106  1.00  0.00           C  
ATOM   1057  CG  ASP A  66      -2.878  35.988   6.588  1.00  0.00           C  
ATOM   1058  OD1 ASP A  66      -3.393  34.962   7.080  1.00  0.00           O  
ATOM   1059  OD2 ASP A  66      -2.613  37.009   7.255  1.00  0.00           O  
ATOM   1060  H   ASP A  66      -2.462  36.368   2.564  1.00  0.00           H  
ATOM   1061  HA  ASP A  66      -4.465  35.684   4.192  1.00  0.00           H  
ATOM   1062  HB2 ASP A  66      -2.293  34.987   4.811  1.00  0.00           H  
ATOM   1063  HB3 ASP A  66      -1.712  36.645   4.941  1.00  0.00           H  
ATOM   1064  N   ASP A  67      -3.684  38.823   4.850  1.00  0.00           N  
ATOM   1065  CA  ASP A  67      -4.192  40.061   5.432  1.00  0.00           C  
ATOM   1066  C   ASP A  67      -5.492  40.486   4.756  1.00  0.00           C  
ATOM   1067  O   ASP A  67      -6.504  40.709   5.419  1.00  0.00           O  
ATOM   1068  CB  ASP A  67      -3.150  41.172   5.306  1.00  0.00           C  
ATOM   1069  CG  ASP A  67      -2.147  41.158   6.443  1.00  0.00           C  
ATOM   1070  OD1 ASP A  67      -2.520  40.737   7.558  1.00  0.00           O  
ATOM   1071  OD2 ASP A  67      -0.989  41.568   6.219  1.00  0.00           O  
ATOM   1072  H   ASP A  67      -2.808  38.827   4.410  1.00  0.00           H  
ATOM   1073  HA  ASP A  67      -4.387  39.880   6.479  1.00  0.00           H  
ATOM   1074  HB2 ASP A  67      -2.613  41.052   4.377  1.00  0.00           H  
ATOM   1075  HB3 ASP A  67      -3.653  42.129   5.306  1.00  0.00           H  
ATOM   1076  N   PHE A  68      -5.456  40.596   3.433  1.00  0.00           N  
ATOM   1077  CA  PHE A  68      -6.630  40.997   2.667  1.00  0.00           C  
ATOM   1078  C   PHE A  68      -7.809  40.075   2.958  1.00  0.00           C  
ATOM   1079  O   PHE A  68      -8.967  40.480   2.855  1.00  0.00           O  
ATOM   1080  CB  PHE A  68      -6.316  40.986   1.169  1.00  0.00           C  
ATOM   1081  CG  PHE A  68      -7.529  41.177   0.301  1.00  0.00           C  
ATOM   1082  CD1 PHE A  68      -7.939  42.447  -0.068  1.00  0.00           C  
ATOM   1083  CD2 PHE A  68      -8.255  40.084  -0.144  1.00  0.00           C  
ATOM   1084  CE1 PHE A  68      -9.053  42.625  -0.866  1.00  0.00           C  
ATOM   1085  CE2 PHE A  68      -9.371  40.257  -0.943  1.00  0.00           C  
ATOM   1086  CZ  PHE A  68      -9.770  41.528  -1.304  1.00  0.00           C  
ATOM   1087  H   PHE A  68      -4.618  40.406   2.959  1.00  0.00           H  
ATOM   1088  HA  PHE A  68      -6.891  42.002   2.963  1.00  0.00           H  
ATOM   1089  HB2 PHE A  68      -5.621  41.782   0.948  1.00  0.00           H  
ATOM   1090  HB3 PHE A  68      -5.868  40.039   0.910  1.00  0.00           H  
ATOM   1091  HD1 PHE A  68      -7.378  43.306   0.273  1.00  0.00           H  
ATOM   1092  HD2 PHE A  68      -7.944  39.088   0.138  1.00  0.00           H  
ATOM   1093  HE1 PHE A  68      -9.362  43.620  -1.147  1.00  0.00           H  
ATOM   1094  HE2 PHE A  68      -9.929  39.397  -1.284  1.00  0.00           H  
ATOM   1095  HZ  PHE A  68     -10.641  41.666  -1.927  1.00  0.00           H  
ATOM   1096  N   GLU A  69      -7.506  38.833   3.322  1.00  0.00           N  
ATOM   1097  CA  GLU A  69      -8.542  37.852   3.626  1.00  0.00           C  
ATOM   1098  C   GLU A  69      -9.079  38.050   5.042  1.00  0.00           C  
ATOM   1099  O   GLU A  69     -10.277  37.912   5.287  1.00  0.00           O  
ATOM   1100  CB  GLU A  69      -7.993  36.433   3.471  1.00  0.00           C  
ATOM   1101  CG  GLU A  69      -8.898  35.363   4.057  1.00  0.00           C  
ATOM   1102  CD  GLU A  69      -8.449  33.959   3.701  1.00  0.00           C  
ATOM   1103  OE1 GLU A  69      -8.257  33.684   2.498  1.00  0.00           O  
ATOM   1104  OE2 GLU A  69      -8.288  33.134   4.625  1.00  0.00           O  
ATOM   1105  H   GLU A  69      -6.565  38.568   3.386  1.00  0.00           H  
ATOM   1106  HA  GLU A  69      -9.350  37.995   2.926  1.00  0.00           H  
ATOM   1107  HB2 GLU A  69      -7.857  36.224   2.419  1.00  0.00           H  
ATOM   1108  HB3 GLU A  69      -7.035  36.375   3.967  1.00  0.00           H  
ATOM   1109  HG2 GLU A  69      -8.901  35.460   5.132  1.00  0.00           H  
ATOM   1110  HG3 GLU A  69      -9.900  35.510   3.681  1.00  0.00           H  
ATOM   1111  N   GLU A  70      -8.182  38.372   5.969  1.00  0.00           N  
ATOM   1112  CA  GLU A  70      -8.564  38.587   7.359  1.00  0.00           C  
ATOM   1113  C   GLU A  70      -9.724  39.576   7.458  1.00  0.00           C  
ATOM   1114  O   GLU A  70     -10.780  39.256   8.002  1.00  0.00           O  
ATOM   1115  CB  GLU A  70      -7.371  39.101   8.166  1.00  0.00           C  
ATOM   1116  CG  GLU A  70      -7.414  38.707   9.634  1.00  0.00           C  
ATOM   1117  CD  GLU A  70      -6.724  39.718  10.529  1.00  0.00           C  
ATOM   1118  OE1 GLU A  70      -7.363  40.732  10.879  1.00  0.00           O  
ATOM   1119  OE2 GLU A  70      -5.547  39.496  10.880  1.00  0.00           O  
ATOM   1120  H   GLU A  70      -7.241  38.467   5.711  1.00  0.00           H  
ATOM   1121  HA  GLU A  70      -8.881  37.637   7.766  1.00  0.00           H  
ATOM   1122  HB2 GLU A  70      -6.463  38.707   7.736  1.00  0.00           H  
ATOM   1123  HB3 GLU A  70      -7.349  40.179   8.106  1.00  0.00           H  
ATOM   1124  HG2 GLU A  70      -8.446  38.622   9.941  1.00  0.00           H  
ATOM   1125  HG3 GLU A  70      -6.924  37.751   9.751  1.00  0.00           H  
ATOM   1126  N   ASP A  71      -9.515  40.775   6.929  1.00  0.00           N  
ATOM   1127  CA  ASP A  71     -10.541  41.811   6.956  1.00  0.00           C  
ATOM   1128  C   ASP A  71     -11.911  41.228   6.623  1.00  0.00           C  
ATOM   1129  O   ASP A  71     -12.854  41.342   7.407  1.00  0.00           O  
ATOM   1130  CB  ASP A  71     -10.195  42.928   5.971  1.00  0.00           C  
ATOM   1131  CG  ASP A  71      -8.706  43.199   5.902  1.00  0.00           C  
ATOM   1132  OD1 ASP A  71      -8.173  43.825   6.841  1.00  0.00           O  
ATOM   1133  OD2 ASP A  71      -8.072  42.783   4.910  1.00  0.00           O  
ATOM   1134  H   ASP A  71      -8.650  40.970   6.509  1.00  0.00           H  
ATOM   1135  HA  ASP A  71     -10.572  42.222   7.955  1.00  0.00           H  
ATOM   1136  HB2 ASP A  71     -10.538  42.649   4.985  1.00  0.00           H  
ATOM   1137  HB3 ASP A  71     -10.694  43.837   6.277  1.00  0.00           H  
ATOM   1138  N   PHE A  72     -12.014  40.605   5.454  1.00  0.00           N  
ATOM   1139  CA  PHE A  72     -13.269  40.006   5.015  1.00  0.00           C  
ATOM   1140  C   PHE A  72     -13.856  39.114   6.106  1.00  0.00           C  
ATOM   1141  O   PHE A  72     -14.985  39.317   6.547  1.00  0.00           O  
ATOM   1142  CB  PHE A  72     -13.051  39.192   3.737  1.00  0.00           C  
ATOM   1143  CG  PHE A  72     -14.217  38.316   3.378  1.00  0.00           C  
ATOM   1144  CD1 PHE A  72     -14.340  37.048   3.923  1.00  0.00           C  
ATOM   1145  CD2 PHE A  72     -15.189  38.762   2.498  1.00  0.00           C  
ATOM   1146  CE1 PHE A  72     -15.412  36.238   3.592  1.00  0.00           C  
ATOM   1147  CE2 PHE A  72     -16.263  37.957   2.165  1.00  0.00           C  
ATOM   1148  CZ  PHE A  72     -16.376  36.694   2.714  1.00  0.00           C  
ATOM   1149  H   PHE A  72     -11.227  40.546   4.872  1.00  0.00           H  
ATOM   1150  HA  PHE A  72     -13.963  40.806   4.809  1.00  0.00           H  
ATOM   1151  HB2 PHE A  72     -12.880  39.868   2.914  1.00  0.00           H  
ATOM   1152  HB3 PHE A  72     -12.186  38.560   3.865  1.00  0.00           H  
ATOM   1153  HD1 PHE A  72     -13.589  36.690   4.611  1.00  0.00           H  
ATOM   1154  HD2 PHE A  72     -15.104  39.749   2.068  1.00  0.00           H  
ATOM   1155  HE1 PHE A  72     -15.497  35.253   4.024  1.00  0.00           H  
ATOM   1156  HE2 PHE A  72     -17.015  38.317   1.477  1.00  0.00           H  
ATOM   1157  HZ  PHE A  72     -17.213  36.065   2.454  1.00  0.00           H  
ATOM   1158  N   ASN A  73     -13.079  38.124   6.534  1.00  0.00           N  
ATOM   1159  CA  ASN A  73     -13.521  37.199   7.572  1.00  0.00           C  
ATOM   1160  C   ASN A  73     -14.302  37.933   8.657  1.00  0.00           C  
ATOM   1161  O   ASN A  73     -15.427  37.557   8.992  1.00  0.00           O  
ATOM   1162  CB  ASN A  73     -12.321  36.480   8.190  1.00  0.00           C  
ATOM   1163  CG  ASN A  73     -11.888  35.276   7.375  1.00  0.00           C  
ATOM   1164  OD1 ASN A  73     -12.716  34.569   6.800  1.00  0.00           O  
ATOM   1165  ND2 ASN A  73     -10.583  35.036   7.323  1.00  0.00           N  
ATOM   1166  H   ASN A  73     -12.187  38.012   6.142  1.00  0.00           H  
ATOM   1167  HA  ASN A  73     -14.170  36.469   7.110  1.00  0.00           H  
ATOM   1168  HB2 ASN A  73     -11.490  37.167   8.249  1.00  0.00           H  
ATOM   1169  HB3 ASN A  73     -12.580  36.146   9.182  1.00  0.00           H  
ATOM   1170 HD21 ASN A  73      -9.980  35.642   7.804  1.00  0.00           H  
ATOM   1171 HD22 ASN A  73     -10.274  34.265   6.802  1.00  0.00           H  
ATOM   1172  N   LEU A  74     -13.700  38.982   9.205  1.00  0.00           N  
ATOM   1173  CA  LEU A  74     -14.338  39.770  10.253  1.00  0.00           C  
ATOM   1174  C   LEU A  74     -15.720  40.244   9.813  1.00  0.00           C  
ATOM   1175  O   LEU A  74     -16.718  39.982  10.484  1.00  0.00           O  
ATOM   1176  CB  LEU A  74     -13.465  40.974  10.617  1.00  0.00           C  
ATOM   1177  CG  LEU A  74     -12.214  40.670  11.441  1.00  0.00           C  
ATOM   1178  CD1 LEU A  74     -11.323  41.899  11.530  1.00  0.00           C  
ATOM   1179  CD2 LEU A  74     -12.597  40.186  12.833  1.00  0.00           C  
ATOM   1180  H   LEU A  74     -12.804  39.233   8.897  1.00  0.00           H  
ATOM   1181  HA  LEU A  74     -14.446  39.140  11.122  1.00  0.00           H  
ATOM   1182  HB2 LEU A  74     -13.149  41.442   9.698  1.00  0.00           H  
ATOM   1183  HB3 LEU A  74     -14.075  41.665  11.180  1.00  0.00           H  
ATOM   1184  HG  LEU A  74     -11.652  39.885  10.956  1.00  0.00           H  
ATOM   1185 HD11 LEU A  74     -11.513  42.416  12.458  1.00  0.00           H  
ATOM   1186 HD12 LEU A  74     -11.534  42.557  10.701  1.00  0.00           H  
ATOM   1187 HD13 LEU A  74     -10.286  41.595  11.493  1.00  0.00           H  
ATOM   1188 HD21 LEU A  74     -13.625  40.450  13.034  1.00  0.00           H  
ATOM   1189 HD22 LEU A  74     -11.955  40.652  13.566  1.00  0.00           H  
ATOM   1190 HD23 LEU A  74     -12.484  39.113  12.884  1.00  0.00           H  
ATOM   1191  N   ILE A  75     -15.767  40.942   8.683  1.00  0.00           N  
ATOM   1192  CA  ILE A  75     -17.027  41.449   8.153  1.00  0.00           C  
ATOM   1193  C   ILE A  75     -18.165  40.467   8.405  1.00  0.00           C  
ATOM   1194  O   ILE A  75     -19.290  40.868   8.712  1.00  0.00           O  
ATOM   1195  CB  ILE A  75     -16.929  41.727   6.641  1.00  0.00           C  
ATOM   1196  CG1 ILE A  75     -15.860  42.785   6.362  1.00  0.00           C  
ATOM   1197  CG2 ILE A  75     -18.278  42.174   6.097  1.00  0.00           C  
ATOM   1198  CD1 ILE A  75     -15.699  43.108   4.893  1.00  0.00           C  
ATOM   1199  H   ILE A  75     -14.937  41.119   8.195  1.00  0.00           H  
ATOM   1200  HA  ILE A  75     -17.250  42.380   8.656  1.00  0.00           H  
ATOM   1201  HB  ILE A  75     -16.656  40.809   6.146  1.00  0.00           H  
ATOM   1202 HG12 ILE A  75     -16.122  43.696   6.875  1.00  0.00           H  
ATOM   1203 HG13 ILE A  75     -14.909  42.428   6.732  1.00  0.00           H  
ATOM   1204 HG21 ILE A  75     -18.836  42.668   6.879  1.00  0.00           H  
ATOM   1205 HG22 ILE A  75     -18.126  42.860   5.277  1.00  0.00           H  
ATOM   1206 HG23 ILE A  75     -18.830  41.314   5.750  1.00  0.00           H  
ATOM   1207 HD11 ILE A  75     -15.886  42.222   4.306  1.00  0.00           H  
ATOM   1208 HD12 ILE A  75     -16.399  43.881   4.615  1.00  0.00           H  
ATOM   1209 HD13 ILE A  75     -14.692  43.454   4.709  1.00  0.00           H  
ATOM   1210  N   VAL A  76     -17.867  39.178   8.279  1.00  0.00           N  
ATOM   1211  CA  VAL A  76     -18.864  38.138   8.497  1.00  0.00           C  
ATOM   1212  C   VAL A  76     -18.943  37.750   9.969  1.00  0.00           C  
ATOM   1213  O   VAL A  76     -20.030  37.594  10.523  1.00  0.00           O  
ATOM   1214  CB  VAL A  76     -18.555  36.880   7.663  1.00  0.00           C  
ATOM   1215  CG1 VAL A  76     -19.620  35.817   7.883  1.00  0.00           C  
ATOM   1216  CG2 VAL A  76     -18.440  37.235   6.188  1.00  0.00           C  
ATOM   1217  H   VAL A  76     -16.954  38.921   8.034  1.00  0.00           H  
ATOM   1218  HA  VAL A  76     -19.824  38.523   8.184  1.00  0.00           H  
ATOM   1219  HB  VAL A  76     -17.607  36.480   7.991  1.00  0.00           H  
ATOM   1220 HG11 VAL A  76     -20.448  36.246   8.429  1.00  0.00           H  
ATOM   1221 HG12 VAL A  76     -19.970  35.453   6.927  1.00  0.00           H  
ATOM   1222 HG13 VAL A  76     -19.202  35.000   8.450  1.00  0.00           H  
ATOM   1223 HG21 VAL A  76     -18.368  38.306   6.080  1.00  0.00           H  
ATOM   1224 HG22 VAL A  76     -17.555  36.771   5.774  1.00  0.00           H  
ATOM   1225 HG23 VAL A  76     -19.313  36.876   5.662  1.00  0.00           H  
ATOM   1226  N   SER A  77     -17.782  37.599  10.599  1.00  0.00           N  
ATOM   1227  CA  SER A  77     -17.717  37.227  12.006  1.00  0.00           C  
ATOM   1228  C   SER A  77     -18.447  38.250  12.872  1.00  0.00           C  
ATOM   1229  O   SER A  77     -19.485  37.952  13.462  1.00  0.00           O  
ATOM   1230  CB  SER A  77     -16.260  37.106  12.459  1.00  0.00           C  
ATOM   1231  OG  SER A  77     -15.536  36.229  11.614  1.00  0.00           O  
ATOM   1232  H   SER A  77     -16.947  37.738  10.101  1.00  0.00           H  
ATOM   1233  HA  SER A  77     -18.201  36.268  12.119  1.00  0.00           H  
ATOM   1234  HB2 SER A  77     -15.797  38.079  12.431  1.00  0.00           H  
ATOM   1235  HB3 SER A  77     -16.231  36.723  13.469  1.00  0.00           H  
ATOM   1236  HG  SER A  77     -15.171  36.723  10.877  1.00  0.00           H  
ATOM   1237  N   ASN A  78     -17.896  39.457  12.942  1.00  0.00           N  
ATOM   1238  CA  ASN A  78     -18.493  40.525  13.736  1.00  0.00           C  
ATOM   1239  C   ASN A  78     -20.004  40.582  13.524  1.00  0.00           C  
ATOM   1240  O   ASN A  78     -20.746  41.039  14.392  1.00  0.00           O  
ATOM   1241  CB  ASN A  78     -17.866  41.872  13.371  1.00  0.00           C  
ATOM   1242  CG  ASN A  78     -17.536  41.976  11.894  1.00  0.00           C  
ATOM   1243  OD1 ASN A  78     -18.373  41.687  11.039  1.00  0.00           O  
ATOM   1244  ND2 ASN A  78     -16.311  42.388  11.589  1.00  0.00           N  
ATOM   1245  H   ASN A  78     -17.068  39.634  12.449  1.00  0.00           H  
ATOM   1246  HA  ASN A  78     -18.295  40.316  14.776  1.00  0.00           H  
ATOM   1247  HB2 ASN A  78     -18.555  42.664  13.623  1.00  0.00           H  
ATOM   1248  HB3 ASN A  78     -16.954  42.002  13.935  1.00  0.00           H  
ATOM   1249 HD21 ASN A  78     -15.697  42.599  12.324  1.00  0.00           H  
ATOM   1250 HD22 ASN A  78     -16.071  42.464  10.643  1.00  0.00           H  
ATOM   1251  N   CYS A  79     -20.450  40.113  12.364  1.00  0.00           N  
ATOM   1252  CA  CYS A  79     -21.871  40.110  12.036  1.00  0.00           C  
ATOM   1253  C   CYS A  79     -22.557  38.869  12.602  1.00  0.00           C  
ATOM   1254  O   CYS A  79     -23.690  38.937  13.079  1.00  0.00           O  
ATOM   1255  CB  CYS A  79     -22.067  40.168  10.520  1.00  0.00           C  
ATOM   1256  SG  CYS A  79     -23.691  40.777  10.010  1.00  0.00           S  
ATOM   1257  H   CYS A  79     -19.810  39.761  11.711  1.00  0.00           H  
ATOM   1258  HA  CYS A  79     -22.315  40.986  12.483  1.00  0.00           H  
ATOM   1259  HB2 CYS A  79     -21.322  40.824  10.095  1.00  0.00           H  
ATOM   1260  HB3 CYS A  79     -21.943  39.178  10.110  1.00  0.00           H  
ATOM   1261  HG  CYS A  79     -24.451  39.730   9.729  1.00  0.00           H  
ATOM   1262  N   LEU A  80     -21.863  37.738  12.542  1.00  0.00           N  
ATOM   1263  CA  LEU A  80     -22.404  36.481  13.048  1.00  0.00           C  
ATOM   1264  C   LEU A  80     -22.206  36.369  14.556  1.00  0.00           C  
ATOM   1265  O   LEU A  80     -22.767  35.484  15.203  1.00  0.00           O  
ATOM   1266  CB  LEU A  80     -21.739  35.298  12.346  1.00  0.00           C  
ATOM   1267  CG  LEU A  80     -21.937  35.217  10.831  1.00  0.00           C  
ATOM   1268  CD1 LEU A  80     -20.993  34.191  10.223  1.00  0.00           C  
ATOM   1269  CD2 LEU A  80     -23.384  34.875  10.501  1.00  0.00           C  
ATOM   1270  H   LEU A  80     -20.965  37.746  12.152  1.00  0.00           H  
ATOM   1271  HA  LEU A  80     -23.463  36.468  12.835  1.00  0.00           H  
ATOM   1272  HB2 LEU A  80     -20.678  35.354  12.537  1.00  0.00           H  
ATOM   1273  HB3 LEU A  80     -22.134  34.390  12.781  1.00  0.00           H  
ATOM   1274  HG  LEU A  80     -21.711  36.179  10.394  1.00  0.00           H  
ATOM   1275 HD11 LEU A  80     -21.286  33.995   9.202  1.00  0.00           H  
ATOM   1276 HD12 LEU A  80     -21.040  33.275  10.794  1.00  0.00           H  
ATOM   1277 HD13 LEU A  80     -19.984  34.575  10.242  1.00  0.00           H  
ATOM   1278 HD21 LEU A  80     -24.025  35.226  11.295  1.00  0.00           H  
ATOM   1279 HD22 LEU A  80     -23.487  33.805  10.401  1.00  0.00           H  
ATOM   1280 HD23 LEU A  80     -23.662  35.354   9.574  1.00  0.00           H  
ATOM   1281  N   LYS A  81     -21.406  37.274  15.111  1.00  0.00           N  
ATOM   1282  CA  LYS A  81     -21.136  37.281  16.544  1.00  0.00           C  
ATOM   1283  C   LYS A  81     -21.990  38.326  17.254  1.00  0.00           C  
ATOM   1284  O   LYS A  81     -22.188  38.261  18.468  1.00  0.00           O  
ATOM   1285  CB  LYS A  81     -19.654  37.556  16.802  1.00  0.00           C  
ATOM   1286  CG  LYS A  81     -19.385  38.242  18.132  1.00  0.00           C  
ATOM   1287  CD  LYS A  81     -17.900  38.257  18.462  1.00  0.00           C  
ATOM   1288  CE  LYS A  81     -17.653  38.692  19.898  1.00  0.00           C  
ATOM   1289  NZ  LYS A  81     -16.281  38.340  20.354  1.00  0.00           N  
ATOM   1290  H   LYS A  81     -20.988  37.955  14.542  1.00  0.00           H  
ATOM   1291  HA  LYS A  81     -21.386  36.305  16.932  1.00  0.00           H  
ATOM   1292  HB2 LYS A  81     -19.117  36.618  16.790  1.00  0.00           H  
ATOM   1293  HB3 LYS A  81     -19.275  38.189  16.012  1.00  0.00           H  
ATOM   1294  HG2 LYS A  81     -19.741  39.260  18.080  1.00  0.00           H  
ATOM   1295  HG3 LYS A  81     -19.912  37.713  18.912  1.00  0.00           H  
ATOM   1296  HD2 LYS A  81     -17.500  37.263  18.323  1.00  0.00           H  
ATOM   1297  HD3 LYS A  81     -17.400  38.944  17.795  1.00  0.00           H  
ATOM   1298  HE2 LYS A  81     -17.783  39.761  19.964  1.00  0.00           H  
ATOM   1299  HE3 LYS A  81     -18.374  38.202  20.536  1.00  0.00           H  
ATOM   1300  HZ1 LYS A  81     -15.803  39.184  20.729  1.00  0.00           H  
ATOM   1301  HZ2 LYS A  81     -15.725  37.964  19.560  1.00  0.00           H  
ATOM   1302  HZ3 LYS A  81     -16.326  37.620  21.103  1.00  0.00           H  
ATOM   1303  N   TYR A  82     -22.493  39.290  16.491  1.00  0.00           N  
ATOM   1304  CA  TYR A  82     -23.325  40.351  17.048  1.00  0.00           C  
ATOM   1305  C   TYR A  82     -24.804  40.066  16.805  1.00  0.00           C  
ATOM   1306  O   TYR A  82     -25.641  40.281  17.682  1.00  0.00           O  
ATOM   1307  CB  TYR A  82     -22.946  41.699  16.435  1.00  0.00           C  
ATOM   1308  CG  TYR A  82     -23.499  42.885  17.192  1.00  0.00           C  
ATOM   1309  CD1 TYR A  82     -23.126  43.132  18.507  1.00  0.00           C  
ATOM   1310  CD2 TYR A  82     -24.396  43.761  16.591  1.00  0.00           C  
ATOM   1311  CE1 TYR A  82     -23.629  44.213  19.203  1.00  0.00           C  
ATOM   1312  CE2 TYR A  82     -24.904  44.847  17.279  1.00  0.00           C  
ATOM   1313  CZ  TYR A  82     -24.518  45.068  18.584  1.00  0.00           C  
ATOM   1314  OH  TYR A  82     -25.021  46.147  19.273  1.00  0.00           O  
ATOM   1315  H   TYR A  82     -22.300  39.289  15.530  1.00  0.00           H  
ATOM   1316  HA  TYR A  82     -23.146  40.386  18.113  1.00  0.00           H  
ATOM   1317  HB2 TYR A  82     -21.871  41.790  16.417  1.00  0.00           H  
ATOM   1318  HB3 TYR A  82     -23.323  41.746  15.423  1.00  0.00           H  
ATOM   1319  HD1 TYR A  82     -22.429  42.459  18.988  1.00  0.00           H  
ATOM   1320  HD2 TYR A  82     -24.696  43.585  15.568  1.00  0.00           H  
ATOM   1321  HE1 TYR A  82     -23.326  44.387  20.225  1.00  0.00           H  
ATOM   1322  HE2 TYR A  82     -25.600  45.516  16.795  1.00  0.00           H  
ATOM   1323  HH  TYR A  82     -24.705  46.124  20.179  1.00  0.00           H  
ATOM   1324  N   ASN A  83     -25.119  39.579  15.609  1.00  0.00           N  
ATOM   1325  CA  ASN A  83     -26.497  39.266  15.251  1.00  0.00           C  
ATOM   1326  C   ASN A  83     -26.722  37.757  15.224  1.00  0.00           C  
ATOM   1327  O   ASN A  83     -25.770  36.978  15.239  1.00  0.00           O  
ATOM   1328  CB  ASN A  83     -26.840  39.866  13.885  1.00  0.00           C  
ATOM   1329  CG  ASN A  83     -26.467  41.334  13.789  1.00  0.00           C  
ATOM   1330  OD1 ASN A  83     -26.917  42.154  14.590  1.00  0.00           O  
ATOM   1331  ND2 ASN A  83     -25.641  41.672  12.806  1.00  0.00           N  
ATOM   1332  H   ASN A  83     -24.408  39.430  14.952  1.00  0.00           H  
ATOM   1333  HA  ASN A  83     -27.141  39.703  15.998  1.00  0.00           H  
ATOM   1334  HB2 ASN A  83     -26.304  39.328  13.117  1.00  0.00           H  
ATOM   1335  HB3 ASN A  83     -27.901  39.772  13.713  1.00  0.00           H  
ATOM   1336 HD21 ASN A  83     -25.323  40.965  12.205  1.00  0.00           H  
ATOM   1337 HD22 ASN A  83     -25.383  42.613  12.720  1.00  0.00           H  
ATOM   1338  N   ALA A  84     -27.987  37.353  15.186  1.00  0.00           N  
ATOM   1339  CA  ALA A  84     -28.338  35.939  15.155  1.00  0.00           C  
ATOM   1340  C   ALA A  84     -29.021  35.571  13.844  1.00  0.00           C  
ATOM   1341  O   ALA A  84     -29.473  36.443  13.101  1.00  0.00           O  
ATOM   1342  CB  ALA A  84     -29.233  35.591  16.336  1.00  0.00           C  
ATOM   1343  H   ALA A  84     -28.702  38.023  15.176  1.00  0.00           H  
ATOM   1344  HA  ALA A  84     -27.425  35.367  15.247  1.00  0.00           H  
ATOM   1345  HB1 ALA A  84     -28.629  35.500  17.228  1.00  0.00           H  
ATOM   1346  HB2 ALA A  84     -29.965  36.373  16.475  1.00  0.00           H  
ATOM   1347  HB3 ALA A  84     -29.735  34.656  16.143  1.00  0.00           H  
ATOM   1348  N   LYS A  85     -29.096  34.274  13.563  1.00  0.00           N  
ATOM   1349  CA  LYS A  85     -29.726  33.789  12.342  1.00  0.00           C  
ATOM   1350  C   LYS A  85     -31.034  34.525  12.075  1.00  0.00           C  
ATOM   1351  O   LYS A  85     -31.265  35.021  10.972  1.00  0.00           O  
ATOM   1352  CB  LYS A  85     -29.985  32.285  12.440  1.00  0.00           C  
ATOM   1353  CG  LYS A  85     -28.720  31.457  12.595  1.00  0.00           C  
ATOM   1354  CD  LYS A  85     -28.996  30.145  13.308  1.00  0.00           C  
ATOM   1355  CE  LYS A  85     -27.766  29.252  13.329  1.00  0.00           C  
ATOM   1356  NZ  LYS A  85     -27.350  28.847  11.958  1.00  0.00           N  
ATOM   1357  H   LYS A  85     -28.717  33.627  14.196  1.00  0.00           H  
ATOM   1358  HA  LYS A  85     -29.048  33.977  11.522  1.00  0.00           H  
ATOM   1359  HB2 LYS A  85     -30.621  32.096  13.292  1.00  0.00           H  
ATOM   1360  HB3 LYS A  85     -30.494  31.960  11.543  1.00  0.00           H  
ATOM   1361  HG2 LYS A  85     -28.317  31.245  11.617  1.00  0.00           H  
ATOM   1362  HG3 LYS A  85     -28.000  32.023  13.167  1.00  0.00           H  
ATOM   1363  HD2 LYS A  85     -29.294  30.352  14.325  1.00  0.00           H  
ATOM   1364  HD3 LYS A  85     -29.797  29.627  12.797  1.00  0.00           H  
ATOM   1365  HE2 LYS A  85     -26.955  29.790  13.798  1.00  0.00           H  
ATOM   1366  HE3 LYS A  85     -27.990  28.365  13.905  1.00  0.00           H  
ATOM   1367  HZ1 LYS A  85     -26.345  29.071  11.808  1.00  0.00           H  
ATOM   1368  HZ2 LYS A  85     -27.916  29.356  11.249  1.00  0.00           H  
ATOM   1369  HZ3 LYS A  85     -27.489  27.824  11.828  1.00  0.00           H  
ATOM   1370  N   ASP A  86     -31.886  34.594  13.092  1.00  0.00           N  
ATOM   1371  CA  ASP A  86     -33.171  35.271  12.968  1.00  0.00           C  
ATOM   1372  C   ASP A  86     -33.040  36.538  12.127  1.00  0.00           C  
ATOM   1373  O   ASP A  86     -33.763  36.726  11.148  1.00  0.00           O  
ATOM   1374  CB  ASP A  86     -33.725  35.618  14.351  1.00  0.00           C  
ATOM   1375  CG  ASP A  86     -34.467  34.459  14.985  1.00  0.00           C  
ATOM   1376  OD1 ASP A  86     -35.277  33.816  14.283  1.00  0.00           O  
ATOM   1377  OD2 ASP A  86     -34.238  34.192  16.183  1.00  0.00           O  
ATOM   1378  H   ASP A  86     -31.646  34.178  13.947  1.00  0.00           H  
ATOM   1379  HA  ASP A  86     -33.857  34.597  12.475  1.00  0.00           H  
ATOM   1380  HB2 ASP A  86     -32.907  35.897  14.999  1.00  0.00           H  
ATOM   1381  HB3 ASP A  86     -34.406  36.452  14.260  1.00  0.00           H  
ATOM   1382  N   THR A  87     -32.110  37.406  12.517  1.00  0.00           N  
ATOM   1383  CA  THR A  87     -31.884  38.655  11.801  1.00  0.00           C  
ATOM   1384  C   THR A  87     -31.543  38.397  10.338  1.00  0.00           C  
ATOM   1385  O   THR A  87     -31.391  37.249   9.920  1.00  0.00           O  
ATOM   1386  CB  THR A  87     -30.749  39.474  12.445  1.00  0.00           C  
ATOM   1387  OG1 THR A  87     -29.506  38.775  12.312  1.00  0.00           O  
ATOM   1388  CG2 THR A  87     -31.036  39.734  13.916  1.00  0.00           C  
ATOM   1389  H   THR A  87     -31.565  37.201  13.305  1.00  0.00           H  
ATOM   1390  HA  THR A  87     -32.793  39.238  11.852  1.00  0.00           H  
ATOM   1391  HB  THR A  87     -30.676  40.423  11.934  1.00  0.00           H  
ATOM   1392  HG1 THR A  87     -29.358  38.234  13.093  1.00  0.00           H  
ATOM   1393 HG21 THR A  87     -32.055  40.073  14.030  1.00  0.00           H  
ATOM   1394 HG22 THR A  87     -30.362  40.492  14.286  1.00  0.00           H  
ATOM   1395 HG23 THR A  87     -30.895  38.822  14.475  1.00  0.00           H  
ATOM   1396  N   ILE A  88     -31.424  39.471   9.564  1.00  0.00           N  
ATOM   1397  CA  ILE A  88     -31.099  39.359   8.149  1.00  0.00           C  
ATOM   1398  C   ILE A  88     -29.590  39.384   7.927  1.00  0.00           C  
ATOM   1399  O   ILE A  88     -29.011  38.421   7.423  1.00  0.00           O  
ATOM   1400  CB  ILE A  88     -31.745  40.495   7.331  1.00  0.00           C  
ATOM   1401  CG1 ILE A  88     -33.175  40.120   6.939  1.00  0.00           C  
ATOM   1402  CG2 ILE A  88     -30.912  40.796   6.094  1.00  0.00           C  
ATOM   1403  CD1 ILE A  88     -33.729  40.954   5.805  1.00  0.00           C  
ATOM   1404  H   ILE A  88     -31.558  40.359   9.957  1.00  0.00           H  
ATOM   1405  HA  ILE A  88     -31.489  38.417   7.790  1.00  0.00           H  
ATOM   1406  HB  ILE A  88     -31.768  41.382   7.945  1.00  0.00           H  
ATOM   1407 HG12 ILE A  88     -33.199  39.085   6.632  1.00  0.00           H  
ATOM   1408 HG13 ILE A  88     -33.821  40.251   7.795  1.00  0.00           H  
ATOM   1409 HG21 ILE A  88     -31.403  41.558   5.507  1.00  0.00           H  
ATOM   1410 HG22 ILE A  88     -29.935  41.147   6.395  1.00  0.00           H  
ATOM   1411 HG23 ILE A  88     -30.807  39.899   5.503  1.00  0.00           H  
ATOM   1412 HD11 ILE A  88     -33.328  41.954   5.865  1.00  0.00           H  
ATOM   1413 HD12 ILE A  88     -33.452  40.509   4.862  1.00  0.00           H  
ATOM   1414 HD13 ILE A  88     -34.807  40.994   5.882  1.00  0.00           H  
ATOM   1415  N   PHE A  89     -28.959  40.490   8.309  1.00  0.00           N  
ATOM   1416  CA  PHE A  89     -27.517  40.640   8.154  1.00  0.00           C  
ATOM   1417  C   PHE A  89     -26.798  39.330   8.463  1.00  0.00           C  
ATOM   1418  O   PHE A  89     -25.696  39.083   7.973  1.00  0.00           O  
ATOM   1419  CB  PHE A  89     -26.998  41.750   9.068  1.00  0.00           C  
ATOM   1420  CG  PHE A  89     -27.977  42.870   9.269  1.00  0.00           C  
ATOM   1421  CD1 PHE A  89     -28.626  43.442   8.187  1.00  0.00           C  
ATOM   1422  CD2 PHE A  89     -28.250  43.351  10.540  1.00  0.00           C  
ATOM   1423  CE1 PHE A  89     -29.529  44.474   8.369  1.00  0.00           C  
ATOM   1424  CE2 PHE A  89     -29.152  44.380  10.728  1.00  0.00           C  
ATOM   1425  CZ  PHE A  89     -29.792  44.942   9.641  1.00  0.00           C  
ATOM   1426  H   PHE A  89     -29.477  41.222   8.704  1.00  0.00           H  
ATOM   1427  HA  PHE A  89     -27.323  40.909   7.127  1.00  0.00           H  
ATOM   1428  HB2 PHE A  89     -26.770  41.331  10.037  1.00  0.00           H  
ATOM   1429  HB3 PHE A  89     -26.097  42.166   8.641  1.00  0.00           H  
ATOM   1430  HD1 PHE A  89     -28.422  43.076   7.191  1.00  0.00           H  
ATOM   1431  HD2 PHE A  89     -27.749  42.912  11.390  1.00  0.00           H  
ATOM   1432  HE1 PHE A  89     -30.029  44.911   7.518  1.00  0.00           H  
ATOM   1433  HE2 PHE A  89     -29.355  44.745  11.724  1.00  0.00           H  
ATOM   1434  HZ  PHE A  89     -30.497  45.748   9.786  1.00  0.00           H  
ATOM   1435  N   TYR A  90     -27.428  38.495   9.282  1.00  0.00           N  
ATOM   1436  CA  TYR A  90     -26.848  37.213   9.661  1.00  0.00           C  
ATOM   1437  C   TYR A  90     -26.816  36.257   8.472  1.00  0.00           C  
ATOM   1438  O   TYR A  90     -25.747  35.818   8.044  1.00  0.00           O  
ATOM   1439  CB  TYR A  90     -27.643  36.589  10.809  1.00  0.00           C  
ATOM   1440  CG  TYR A  90     -26.992  35.357  11.397  1.00  0.00           C  
ATOM   1441  CD1 TYR A  90     -26.874  34.189  10.655  1.00  0.00           C  
ATOM   1442  CD2 TYR A  90     -26.495  35.362  12.695  1.00  0.00           C  
ATOM   1443  CE1 TYR A  90     -26.282  33.060  11.188  1.00  0.00           C  
ATOM   1444  CE2 TYR A  90     -25.899  34.239  13.236  1.00  0.00           C  
ATOM   1445  CZ  TYR A  90     -25.795  33.091  12.479  1.00  0.00           C  
ATOM   1446  OH  TYR A  90     -25.203  31.969  13.014  1.00  0.00           O  
ATOM   1447  H   TYR A  90     -28.304  38.748   9.641  1.00  0.00           H  
ATOM   1448  HA  TYR A  90     -25.836  37.391   9.993  1.00  0.00           H  
ATOM   1449  HB2 TYR A  90     -27.752  37.316  11.600  1.00  0.00           H  
ATOM   1450  HB3 TYR A  90     -28.622  36.308  10.448  1.00  0.00           H  
ATOM   1451  HD1 TYR A  90     -27.256  34.168   9.644  1.00  0.00           H  
ATOM   1452  HD2 TYR A  90     -26.578  36.264  13.284  1.00  0.00           H  
ATOM   1453  HE1 TYR A  90     -26.199  32.161  10.596  1.00  0.00           H  
ATOM   1454  HE2 TYR A  90     -25.520  34.263  14.245  1.00  0.00           H  
ATOM   1455  HH  TYR A  90     -25.575  31.186  12.604  1.00  0.00           H  
ATOM   1456  N   ARG A  91     -27.992  35.941   7.943  1.00  0.00           N  
ATOM   1457  CA  ARG A  91     -28.100  35.037   6.804  1.00  0.00           C  
ATOM   1458  C   ARG A  91     -27.333  35.583   5.603  1.00  0.00           C  
ATOM   1459  O   ARG A  91     -26.839  34.822   4.771  1.00  0.00           O  
ATOM   1460  CB  ARG A  91     -29.568  34.825   6.431  1.00  0.00           C  
ATOM   1461  CG  ARG A  91     -30.328  33.958   7.421  1.00  0.00           C  
ATOM   1462  CD  ARG A  91     -31.821  34.256   7.389  1.00  0.00           C  
ATOM   1463  NE  ARG A  91     -32.497  33.534   6.313  1.00  0.00           N  
ATOM   1464  CZ  ARG A  91     -32.643  32.214   6.291  1.00  0.00           C  
ATOM   1465  NH1 ARG A  91     -32.161  31.474   7.279  1.00  0.00           N  
ATOM   1466  NH2 ARG A  91     -33.272  31.633   5.277  1.00  0.00           N  
ATOM   1467  H   ARG A  91     -28.807  36.323   8.328  1.00  0.00           H  
ATOM   1468  HA  ARG A  91     -27.670  34.090   7.091  1.00  0.00           H  
ATOM   1469  HB2 ARG A  91     -30.057  35.787   6.378  1.00  0.00           H  
ATOM   1470  HB3 ARG A  91     -29.616  34.352   5.461  1.00  0.00           H  
ATOM   1471  HG2 ARG A  91     -30.174  32.920   7.170  1.00  0.00           H  
ATOM   1472  HG3 ARG A  91     -29.954  34.151   8.415  1.00  0.00           H  
ATOM   1473  HD2 ARG A  91     -32.252  33.960   8.334  1.00  0.00           H  
ATOM   1474  HD3 ARG A  91     -31.960  35.316   7.243  1.00  0.00           H  
ATOM   1475  HE  ARG A  91     -32.861  34.062   5.573  1.00  0.00           H  
ATOM   1476 HH11 ARG A  91     -31.688  31.910   8.044  1.00  0.00           H  
ATOM   1477 HH12 ARG A  91     -32.273  30.480   7.260  1.00  0.00           H  
ATOM   1478 HH21 ARG A  91     -33.637  32.188   4.531  1.00  0.00           H  
ATOM   1479 HH22 ARG A  91     -33.381  30.640   5.260  1.00  0.00           H  
ATOM   1480  N   ALA A  92     -27.236  36.906   5.519  1.00  0.00           N  
ATOM   1481  CA  ALA A  92     -26.528  37.553   4.422  1.00  0.00           C  
ATOM   1482  C   ALA A  92     -25.023  37.343   4.541  1.00  0.00           C  
ATOM   1483  O   ALA A  92     -24.324  37.210   3.537  1.00  0.00           O  
ATOM   1484  CB  ALA A  92     -26.856  39.038   4.385  1.00  0.00           C  
ATOM   1485  H   ALA A  92     -27.650  37.459   6.213  1.00  0.00           H  
ATOM   1486  HA  ALA A  92     -26.872  37.111   3.498  1.00  0.00           H  
ATOM   1487  HB1 ALA A  92     -27.920  39.175   4.509  1.00  0.00           H  
ATOM   1488  HB2 ALA A  92     -26.333  39.541   5.186  1.00  0.00           H  
ATOM   1489  HB3 ALA A  92     -26.546  39.452   3.438  1.00  0.00           H  
ATOM   1490  N   ALA A  93     -24.529  37.317   5.774  1.00  0.00           N  
ATOM   1491  CA  ALA A  93     -23.106  37.122   6.023  1.00  0.00           C  
ATOM   1492  C   ALA A  93     -22.702  35.669   5.796  1.00  0.00           C  
ATOM   1493  O   ALA A  93     -21.599  35.387   5.330  1.00  0.00           O  
ATOM   1494  CB  ALA A  93     -22.755  37.554   7.440  1.00  0.00           C  
ATOM   1495  H   ALA A  93     -25.137  37.428   6.534  1.00  0.00           H  
ATOM   1496  HA  ALA A  93     -22.558  37.750   5.336  1.00  0.00           H  
ATOM   1497  HB1 ALA A  93     -23.541  38.185   7.828  1.00  0.00           H  
ATOM   1498  HB2 ALA A  93     -22.650  36.680   8.067  1.00  0.00           H  
ATOM   1499  HB3 ALA A  93     -21.825  38.103   7.428  1.00  0.00           H  
ATOM   1500  N   VAL A  94     -23.603  34.750   6.129  1.00  0.00           N  
ATOM   1501  CA  VAL A  94     -23.341  33.326   5.960  1.00  0.00           C  
ATOM   1502  C   VAL A  94     -23.104  32.981   4.494  1.00  0.00           C  
ATOM   1503  O   VAL A  94     -22.221  32.188   4.167  1.00  0.00           O  
ATOM   1504  CB  VAL A  94     -24.507  32.473   6.495  1.00  0.00           C  
ATOM   1505  CG1 VAL A  94     -24.353  31.024   6.058  1.00  0.00           C  
ATOM   1506  CG2 VAL A  94     -24.590  32.576   8.010  1.00  0.00           C  
ATOM   1507  H   VAL A  94     -24.465  35.036   6.496  1.00  0.00           H  
ATOM   1508  HA  VAL A  94     -22.454  33.081   6.525  1.00  0.00           H  
ATOM   1509  HB  VAL A  94     -25.427  32.855   6.079  1.00  0.00           H  
ATOM   1510 HG11 VAL A  94     -25.098  30.418   6.553  1.00  0.00           H  
ATOM   1511 HG12 VAL A  94     -24.484  30.955   4.988  1.00  0.00           H  
ATOM   1512 HG13 VAL A  94     -23.367  30.671   6.323  1.00  0.00           H  
ATOM   1513 HG21 VAL A  94     -25.544  32.996   8.291  1.00  0.00           H  
ATOM   1514 HG22 VAL A  94     -24.488  31.592   8.444  1.00  0.00           H  
ATOM   1515 HG23 VAL A  94     -23.794  33.210   8.373  1.00  0.00           H  
ATOM   1516  N   ARG A  95     -23.899  33.582   3.615  1.00  0.00           N  
ATOM   1517  CA  ARG A  95     -23.777  33.337   2.182  1.00  0.00           C  
ATOM   1518  C   ARG A  95     -22.430  33.830   1.660  1.00  0.00           C  
ATOM   1519  O   ARG A  95     -21.777  33.156   0.864  1.00  0.00           O  
ATOM   1520  CB  ARG A  95     -24.914  34.028   1.427  1.00  0.00           C  
ATOM   1521  CG  ARG A  95     -24.786  33.933  -0.085  1.00  0.00           C  
ATOM   1522  CD  ARG A  95     -26.142  34.041  -0.766  1.00  0.00           C  
ATOM   1523  NE  ARG A  95     -26.021  34.439  -2.165  1.00  0.00           N  
ATOM   1524  CZ  ARG A  95     -26.966  34.227  -3.075  1.00  0.00           C  
ATOM   1525  NH1 ARG A  95     -28.094  33.622  -2.733  1.00  0.00           N  
ATOM   1526  NH2 ARG A  95     -26.781  34.620  -4.329  1.00  0.00           N  
ATOM   1527  H   ARG A  95     -24.585  34.203   3.936  1.00  0.00           H  
ATOM   1528  HA  ARG A  95     -23.845  32.272   2.021  1.00  0.00           H  
ATOM   1529  HB2 ARG A  95     -25.850  33.574   1.716  1.00  0.00           H  
ATOM   1530  HB3 ARG A  95     -24.929  35.073   1.699  1.00  0.00           H  
ATOM   1531  HG2 ARG A  95     -24.155  34.735  -0.435  1.00  0.00           H  
ATOM   1532  HG3 ARG A  95     -24.340  32.984  -0.340  1.00  0.00           H  
ATOM   1533  HD2 ARG A  95     -26.631  33.080  -0.717  1.00  0.00           H  
ATOM   1534  HD3 ARG A  95     -26.735  34.773  -0.242  1.00  0.00           H  
ATOM   1535  HE  ARG A  95     -25.195  34.889  -2.439  1.00  0.00           H  
ATOM   1536 HH11 ARG A  95     -28.236  33.325  -1.789  1.00  0.00           H  
ATOM   1537 HH12 ARG A  95     -28.805  33.464  -3.420  1.00  0.00           H  
ATOM   1538 HH21 ARG A  95     -25.932  35.076  -4.590  1.00  0.00           H  
ATOM   1539 HH22 ARG A  95     -27.493  34.460  -5.013  1.00  0.00           H  
ATOM   1540  N   LEU A  96     -22.024  35.012   2.111  1.00  0.00           N  
ATOM   1541  CA  LEU A  96     -20.756  35.597   1.689  1.00  0.00           C  
ATOM   1542  C   LEU A  96     -19.583  34.709   2.098  1.00  0.00           C  
ATOM   1543  O   LEU A  96     -18.693  34.433   1.295  1.00  0.00           O  
ATOM   1544  CB  LEU A  96     -20.589  36.992   2.294  1.00  0.00           C  
ATOM   1545  CG  LEU A  96     -21.433  38.101   1.665  1.00  0.00           C  
ATOM   1546  CD1 LEU A  96     -21.359  39.367   2.504  1.00  0.00           C  
ATOM   1547  CD2 LEU A  96     -20.976  38.376   0.239  1.00  0.00           C  
ATOM   1548  H   LEU A  96     -22.589  35.503   2.743  1.00  0.00           H  
ATOM   1549  HA  LEU A  96     -20.771  35.680   0.613  1.00  0.00           H  
ATOM   1550  HB2 LEU A  96     -20.847  36.932   3.341  1.00  0.00           H  
ATOM   1551  HB3 LEU A  96     -19.548  37.271   2.197  1.00  0.00           H  
ATOM   1552  HG  LEU A  96     -22.465  37.783   1.631  1.00  0.00           H  
ATOM   1553 HD11 LEU A  96     -20.794  39.173   3.402  1.00  0.00           H  
ATOM   1554 HD12 LEU A  96     -22.358  39.682   2.768  1.00  0.00           H  
ATOM   1555 HD13 LEU A  96     -20.876  40.149   1.935  1.00  0.00           H  
ATOM   1556 HD21 LEU A  96     -21.836  38.581  -0.379  1.00  0.00           H  
ATOM   1557 HD22 LEU A  96     -20.454  37.512  -0.144  1.00  0.00           H  
ATOM   1558 HD23 LEU A  96     -20.314  39.229   0.232  1.00  0.00           H  
ATOM   1559  N   ARG A  97     -19.594  34.265   3.350  1.00  0.00           N  
ATOM   1560  CA  ARG A  97     -18.533  33.408   3.864  1.00  0.00           C  
ATOM   1561  C   ARG A  97     -18.481  32.087   3.100  1.00  0.00           C  
ATOM   1562  O   ARG A  97     -17.404  31.553   2.838  1.00  0.00           O  
ATOM   1563  CB  ARG A  97     -18.744  33.138   5.355  1.00  0.00           C  
ATOM   1564  CG  ARG A  97     -17.646  32.295   5.983  1.00  0.00           C  
ATOM   1565  CD  ARG A  97     -17.924  32.023   7.453  1.00  0.00           C  
ATOM   1566  NE  ARG A  97     -16.967  31.080   8.026  1.00  0.00           N  
ATOM   1567  CZ  ARG A  97     -15.756  31.429   8.451  1.00  0.00           C  
ATOM   1568  NH1 ARG A  97     -15.359  32.691   8.367  1.00  0.00           N  
ATOM   1569  NH2 ARG A  97     -14.942  30.514   8.961  1.00  0.00           N  
ATOM   1570  H   ARG A  97     -20.332  34.519   3.943  1.00  0.00           H  
ATOM   1571  HA  ARG A  97     -17.594  33.924   3.730  1.00  0.00           H  
ATOM   1572  HB2 ARG A  97     -18.785  34.082   5.877  1.00  0.00           H  
ATOM   1573  HB3 ARG A  97     -19.683  32.621   5.486  1.00  0.00           H  
ATOM   1574  HG2 ARG A  97     -17.585  31.352   5.459  1.00  0.00           H  
ATOM   1575  HG3 ARG A  97     -16.707  32.820   5.894  1.00  0.00           H  
ATOM   1576  HD2 ARG A  97     -17.866  32.955   7.995  1.00  0.00           H  
ATOM   1577  HD3 ARG A  97     -18.918  31.613   7.548  1.00  0.00           H  
ATOM   1578  HE  ARG A  97     -17.240  30.142   8.096  1.00  0.00           H  
ATOM   1579 HH11 ARG A  97     -15.971  33.381   7.985  1.00  0.00           H  
ATOM   1580 HH12 ARG A  97     -14.449  32.950   8.689  1.00  0.00           H  
ATOM   1581 HH21 ARG A  97     -15.239  29.561   9.024  1.00  0.00           H  
ATOM   1582 HH22 ARG A  97     -14.032  30.776   9.279  1.00  0.00           H  
ATOM   1583  N   GLU A  98     -19.653  31.568   2.746  1.00  0.00           N  
ATOM   1584  CA  GLU A  98     -19.740  30.311   2.015  1.00  0.00           C  
ATOM   1585  C   GLU A  98     -19.295  30.492   0.565  1.00  0.00           C  
ATOM   1586  O   GLU A  98     -18.292  29.922   0.137  1.00  0.00           O  
ATOM   1587  CB  GLU A  98     -21.171  29.769   2.055  1.00  0.00           C  
ATOM   1588  CG  GLU A  98     -21.555  29.167   3.396  1.00  0.00           C  
ATOM   1589  CD  GLU A  98     -20.760  27.916   3.722  1.00  0.00           C  
ATOM   1590  OE1 GLU A  98     -20.710  27.005   2.870  1.00  0.00           O  
ATOM   1591  OE2 GLU A  98     -20.189  27.851   4.830  1.00  0.00           O  
ATOM   1592  H   GLU A  98     -20.478  32.041   2.984  1.00  0.00           H  
ATOM   1593  HA  GLU A  98     -19.083  29.602   2.493  1.00  0.00           H  
ATOM   1594  HB2 GLU A  98     -21.855  30.576   1.836  1.00  0.00           H  
ATOM   1595  HB3 GLU A  98     -21.275  29.005   1.299  1.00  0.00           H  
ATOM   1596  HG2 GLU A  98     -21.378  29.898   4.169  1.00  0.00           H  
ATOM   1597  HG3 GLU A  98     -22.604  28.912   3.374  1.00  0.00           H  
ATOM   1598  N   GLN A  99     -20.049  31.291  -0.183  1.00  0.00           N  
ATOM   1599  CA  GLN A  99     -19.733  31.547  -1.583  1.00  0.00           C  
ATOM   1600  C   GLN A  99     -18.405  32.285  -1.716  1.00  0.00           C  
ATOM   1601  O   GLN A  99     -17.491  31.821  -2.397  1.00  0.00           O  
ATOM   1602  CB  GLN A  99     -20.850  32.361  -2.239  1.00  0.00           C  
ATOM   1603  CG  GLN A  99     -22.236  31.782  -2.017  1.00  0.00           C  
ATOM   1604  CD  GLN A  99     -23.248  32.282  -3.030  1.00  0.00           C  
ATOM   1605  OE1 GLN A  99     -22.881  32.806  -4.082  1.00  0.00           O  
ATOM   1606  NE2 GLN A  99     -24.528  32.122  -2.718  1.00  0.00           N  
ATOM   1607  H   GLN A  99     -20.835  31.718   0.215  1.00  0.00           H  
ATOM   1608  HA  GLN A  99     -19.653  30.595  -2.085  1.00  0.00           H  
ATOM   1609  HB2 GLN A  99     -20.832  33.364  -1.836  1.00  0.00           H  
ATOM   1610  HB3 GLN A  99     -20.668  32.408  -3.303  1.00  0.00           H  
ATOM   1611  HG2 GLN A  99     -22.179  30.707  -2.089  1.00  0.00           H  
ATOM   1612  HG3 GLN A  99     -22.573  32.058  -1.028  1.00  0.00           H  
ATOM   1613 HE21 GLN A  99     -24.746  31.696  -1.861  1.00  0.00           H  
ATOM   1614 HE22 GLN A  99     -25.202  32.436  -3.353  1.00  0.00           H  
ATOM   1615  N   GLY A 100     -18.304  33.437  -1.059  1.00  0.00           N  
ATOM   1616  CA  GLY A 100     -17.084  34.220  -1.117  1.00  0.00           C  
ATOM   1617  C   GLY A 100     -15.839  33.358  -1.063  1.00  0.00           C  
ATOM   1618  O   GLY A 100     -14.845  33.647  -1.727  1.00  0.00           O  
ATOM   1619  H   GLY A 100     -19.065  33.758  -0.531  1.00  0.00           H  
ATOM   1620  HA2 GLY A 100     -17.075  34.787  -2.036  1.00  0.00           H  
ATOM   1621  HA3 GLY A 100     -17.070  34.905  -0.282  1.00  0.00           H  
ATOM   1622  N   GLY A 101     -15.891  32.295  -0.265  1.00  0.00           N  
ATOM   1623  CA  GLY A 101     -14.751  31.405  -0.140  1.00  0.00           C  
ATOM   1624  C   GLY A 101     -14.143  31.048  -1.481  1.00  0.00           C  
ATOM   1625  O   GLY A 101     -12.921  31.010  -1.626  1.00  0.00           O  
ATOM   1626  H   GLY A 101     -16.710  32.114   0.242  1.00  0.00           H  
ATOM   1627  HA2 GLY A 101     -14.000  31.885   0.470  1.00  0.00           H  
ATOM   1628  HA3 GLY A 101     -15.070  30.496   0.351  1.00  0.00           H  
ATOM   1629  N   ALA A 102     -14.997  30.787  -2.465  1.00  0.00           N  
ATOM   1630  CA  ALA A 102     -14.536  30.431  -3.802  1.00  0.00           C  
ATOM   1631  C   ALA A 102     -13.724  31.565  -4.421  1.00  0.00           C  
ATOM   1632  O   ALA A 102     -12.740  31.326  -5.122  1.00  0.00           O  
ATOM   1633  CB  ALA A 102     -15.719  30.081  -4.692  1.00  0.00           C  
ATOM   1634  H   ALA A 102     -15.959  30.834  -2.288  1.00  0.00           H  
ATOM   1635  HA  ALA A 102     -13.908  29.557  -3.717  1.00  0.00           H  
ATOM   1636  HB1 ALA A 102     -16.601  29.949  -4.081  1.00  0.00           H  
ATOM   1637  HB2 ALA A 102     -15.886  30.878  -5.400  1.00  0.00           H  
ATOM   1638  HB3 ALA A 102     -15.510  29.165  -5.223  1.00  0.00           H  
ATOM   1639  N   VAL A 103     -14.143  32.798  -4.160  1.00  0.00           N  
ATOM   1640  CA  VAL A 103     -13.454  33.968  -4.690  1.00  0.00           C  
ATOM   1641  C   VAL A 103     -12.057  34.102  -4.093  1.00  0.00           C  
ATOM   1642  O   VAL A 103     -11.084  34.343  -4.809  1.00  0.00           O  
ATOM   1643  CB  VAL A 103     -14.246  35.260  -4.413  1.00  0.00           C  
ATOM   1644  CG1 VAL A 103     -13.472  36.476  -4.901  1.00  0.00           C  
ATOM   1645  CG2 VAL A 103     -15.618  35.194  -5.065  1.00  0.00           C  
ATOM   1646  H   VAL A 103     -14.933  32.925  -3.593  1.00  0.00           H  
ATOM   1647  HA  VAL A 103     -13.368  33.848  -5.760  1.00  0.00           H  
ATOM   1648  HB  VAL A 103     -14.381  35.353  -3.346  1.00  0.00           H  
ATOM   1649 HG11 VAL A 103     -13.563  36.553  -5.975  1.00  0.00           H  
ATOM   1650 HG12 VAL A 103     -13.873  37.367  -4.440  1.00  0.00           H  
ATOM   1651 HG13 VAL A 103     -12.430  36.371  -4.634  1.00  0.00           H  
ATOM   1652 HG21 VAL A 103     -15.547  35.539  -6.086  1.00  0.00           H  
ATOM   1653 HG22 VAL A 103     -15.975  34.174  -5.054  1.00  0.00           H  
ATOM   1654 HG23 VAL A 103     -16.306  35.822  -4.520  1.00  0.00           H  
ATOM   1655  N   LEU A 104     -11.965  33.946  -2.777  1.00  0.00           N  
ATOM   1656  CA  LEU A 104     -10.688  34.048  -2.082  1.00  0.00           C  
ATOM   1657  C   LEU A 104      -9.807  32.839  -2.380  1.00  0.00           C  
ATOM   1658  O   LEU A 104      -8.581  32.917  -2.301  1.00  0.00           O  
ATOM   1659  CB  LEU A 104     -10.913  34.170  -0.574  1.00  0.00           C  
ATOM   1660  CG  LEU A 104     -11.615  35.443  -0.100  1.00  0.00           C  
ATOM   1661  CD1 LEU A 104     -11.987  35.334   1.369  1.00  0.00           C  
ATOM   1662  CD2 LEU A 104     -10.731  36.660  -0.340  1.00  0.00           C  
ATOM   1663  H   LEU A 104     -12.776  33.755  -2.260  1.00  0.00           H  
ATOM   1664  HA  LEU A 104     -10.189  34.938  -2.436  1.00  0.00           H  
ATOM   1665  HB2 LEU A 104     -11.510  33.328  -0.260  1.00  0.00           H  
ATOM   1666  HB3 LEU A 104      -9.947  34.124  -0.091  1.00  0.00           H  
ATOM   1667  HG  LEU A 104     -12.526  35.576  -0.667  1.00  0.00           H  
ATOM   1668 HD11 LEU A 104     -12.182  34.300   1.614  1.00  0.00           H  
ATOM   1669 HD12 LEU A 104     -12.873  35.922   1.562  1.00  0.00           H  
ATOM   1670 HD13 LEU A 104     -11.172  35.701   1.975  1.00  0.00           H  
ATOM   1671 HD21 LEU A 104     -10.479  37.113   0.608  1.00  0.00           H  
ATOM   1672 HD22 LEU A 104     -11.261  37.376  -0.950  1.00  0.00           H  
ATOM   1673 HD23 LEU A 104      -9.827  36.353  -0.844  1.00  0.00           H  
ATOM   1674  N   ARG A 105     -10.440  31.723  -2.724  1.00  0.00           N  
ATOM   1675  CA  ARG A 105      -9.714  30.497  -3.035  1.00  0.00           C  
ATOM   1676  C   ARG A 105      -9.156  30.542  -4.454  1.00  0.00           C  
ATOM   1677  O   ARG A 105      -8.094  29.984  -4.730  1.00  0.00           O  
ATOM   1678  CB  ARG A 105     -10.629  29.282  -2.873  1.00  0.00           C  
ATOM   1679  CG  ARG A 105     -10.652  28.720  -1.461  1.00  0.00           C  
ATOM   1680  CD  ARG A 105     -11.083  27.262  -1.448  1.00  0.00           C  
ATOM   1681  NE  ARG A 105     -11.023  26.685  -0.109  1.00  0.00           N  
ATOM   1682  CZ  ARG A 105     -11.559  25.513   0.212  1.00  0.00           C  
ATOM   1683  NH1 ARG A 105     -12.191  24.796  -0.706  1.00  0.00           N  
ATOM   1684  NH2 ARG A 105     -11.463  25.054   1.454  1.00  0.00           N  
ATOM   1685  H   ARG A 105     -11.419  31.723  -2.769  1.00  0.00           H  
ATOM   1686  HA  ARG A 105      -8.892  30.413  -2.340  1.00  0.00           H  
ATOM   1687  HB2 ARG A 105     -11.637  29.566  -3.140  1.00  0.00           H  
ATOM   1688  HB3 ARG A 105     -10.295  28.504  -3.542  1.00  0.00           H  
ATOM   1689  HG2 ARG A 105      -9.661  28.794  -1.038  1.00  0.00           H  
ATOM   1690  HG3 ARG A 105     -11.344  29.297  -0.865  1.00  0.00           H  
ATOM   1691  HD2 ARG A 105     -12.097  27.197  -1.813  1.00  0.00           H  
ATOM   1692  HD3 ARG A 105     -10.430  26.702  -2.101  1.00  0.00           H  
ATOM   1693  HE  ARG A 105     -10.560  27.198   0.587  1.00  0.00           H  
ATOM   1694 HH11 ARG A 105     -12.265  25.138  -1.644  1.00  0.00           H  
ATOM   1695 HH12 ARG A 105     -12.593  23.912  -0.464  1.00  0.00           H  
ATOM   1696 HH21 ARG A 105     -10.987  25.591   2.149  1.00  0.00           H  
ATOM   1697 HH22 ARG A 105     -11.867  24.172   1.693  1.00  0.00           H  
ATOM   1698  N   GLN A 106      -9.880  31.207  -5.349  1.00  0.00           N  
ATOM   1699  CA  GLN A 106      -9.456  31.322  -6.739  1.00  0.00           C  
ATOM   1700  C   GLN A 106      -8.417  32.427  -6.902  1.00  0.00           C  
ATOM   1701  O   GLN A 106      -7.525  32.333  -7.745  1.00  0.00           O  
ATOM   1702  CB  GLN A 106     -10.660  31.601  -7.640  1.00  0.00           C  
ATOM   1703  CG  GLN A 106     -11.132  33.046  -7.594  1.00  0.00           C  
ATOM   1704  CD  GLN A 106     -12.043  33.401  -8.751  1.00  0.00           C  
ATOM   1705  OE1 GLN A 106     -13.105  32.801  -8.926  1.00  0.00           O  
ATOM   1706  NE2 GLN A 106     -11.634  34.379  -9.550  1.00  0.00           N  
ATOM   1707  H   GLN A 106     -10.717  31.629  -5.068  1.00  0.00           H  
ATOM   1708  HA  GLN A 106      -9.012  30.381  -7.030  1.00  0.00           H  
ATOM   1709  HB2 GLN A 106     -10.396  31.365  -8.659  1.00  0.00           H  
ATOM   1710  HB3 GLN A 106     -11.479  30.968  -7.332  1.00  0.00           H  
ATOM   1711  HG2 GLN A 106     -11.670  33.206  -6.670  1.00  0.00           H  
ATOM   1712  HG3 GLN A 106     -10.269  33.693  -7.622  1.00  0.00           H  
ATOM   1713 HE21 GLN A 106     -10.777  34.810  -9.350  1.00  0.00           H  
ATOM   1714 HE22 GLN A 106     -12.203  34.627 -10.307  1.00  0.00           H  
ATOM   1715  N   ALA A 107      -8.539  33.471  -6.089  1.00  0.00           N  
ATOM   1716  CA  ALA A 107      -7.609  34.593  -6.143  1.00  0.00           C  
ATOM   1717  C   ALA A 107      -6.343  34.294  -5.347  1.00  0.00           C  
ATOM   1718  O   ALA A 107      -5.281  34.856  -5.617  1.00  0.00           O  
ATOM   1719  CB  ALA A 107      -8.277  35.856  -5.623  1.00  0.00           C  
ATOM   1720  H   ALA A 107      -9.270  33.487  -5.439  1.00  0.00           H  
ATOM   1721  HA  ALA A 107      -7.342  34.756  -7.177  1.00  0.00           H  
ATOM   1722  HB1 ALA A 107      -9.039  36.173  -6.319  1.00  0.00           H  
ATOM   1723  HB2 ALA A 107      -8.727  35.656  -4.661  1.00  0.00           H  
ATOM   1724  HB3 ALA A 107      -7.538  36.637  -5.519  1.00  0.00           H  
ATOM   1725  N   ARG A 108      -6.461  33.407  -4.365  1.00  0.00           N  
ATOM   1726  CA  ARG A 108      -5.327  33.035  -3.529  1.00  0.00           C  
ATOM   1727  C   ARG A 108      -4.212  32.416  -4.367  1.00  0.00           C  
ATOM   1728  O   ARG A 108      -3.044  32.780  -4.232  1.00  0.00           O  
ATOM   1729  CB  ARG A 108      -5.767  32.053  -2.441  1.00  0.00           C  
ATOM   1730  CG  ARG A 108      -4.611  31.462  -1.651  1.00  0.00           C  
ATOM   1731  CD  ARG A 108      -4.173  32.386  -0.527  1.00  0.00           C  
ATOM   1732  NE  ARG A 108      -4.898  32.122   0.713  1.00  0.00           N  
ATOM   1733  CZ  ARG A 108      -4.712  31.035   1.455  1.00  0.00           C  
ATOM   1734  NH1 ARG A 108      -3.830  30.118   1.084  1.00  0.00           N  
ATOM   1735  NH2 ARG A 108      -5.410  30.866   2.571  1.00  0.00           N  
ATOM   1736  H   ARG A 108      -7.335  32.992  -4.198  1.00  0.00           H  
ATOM   1737  HA  ARG A 108      -4.952  33.933  -3.061  1.00  0.00           H  
ATOM   1738  HB2 ARG A 108      -6.419  32.567  -1.751  1.00  0.00           H  
ATOM   1739  HB3 ARG A 108      -6.311  31.243  -2.904  1.00  0.00           H  
ATOM   1740  HG2 ARG A 108      -4.923  30.518  -1.227  1.00  0.00           H  
ATOM   1741  HG3 ARG A 108      -3.778  31.299  -2.318  1.00  0.00           H  
ATOM   1742  HD2 ARG A 108      -3.117  32.244  -0.353  1.00  0.00           H  
ATOM   1743  HD3 ARG A 108      -4.354  33.407  -0.827  1.00  0.00           H  
ATOM   1744  HE  ARG A 108      -5.555  32.787   1.007  1.00  0.00           H  
ATOM   1745 HH11 ARG A 108      -3.302  30.243   0.245  1.00  0.00           H  
ATOM   1746 HH12 ARG A 108      -3.690  29.302   1.645  1.00  0.00           H  
ATOM   1747 HH21 ARG A 108      -6.076  31.555   2.854  1.00  0.00           H  
ATOM   1748 HH22 ARG A 108      -5.269  30.048   3.129  1.00  0.00           H  
ATOM   1749  N   ARG A 109      -4.583  31.480  -5.234  1.00  0.00           N  
ATOM   1750  CA  ARG A 109      -3.615  30.807  -6.093  1.00  0.00           C  
ATOM   1751  C   ARG A 109      -2.866  31.816  -6.959  1.00  0.00           C  
ATOM   1752  O   ARG A 109      -1.689  31.630  -7.267  1.00  0.00           O  
ATOM   1753  CB  ARG A 109      -4.316  29.778  -6.980  1.00  0.00           C  
ATOM   1754  CG  ARG A 109      -5.059  30.392  -8.156  1.00  0.00           C  
ATOM   1755  CD  ARG A 109      -6.146  29.465  -8.676  1.00  0.00           C  
ATOM   1756  NE  ARG A 109      -6.677  29.908  -9.961  1.00  0.00           N  
ATOM   1757  CZ  ARG A 109      -7.605  29.245 -10.641  1.00  0.00           C  
ATOM   1758  NH1 ARG A 109      -8.104  28.115 -10.160  1.00  0.00           N  
ATOM   1759  NH2 ARG A 109      -8.039  29.714 -11.806  1.00  0.00           N  
ATOM   1760  H   ARG A 109      -5.529  31.231  -5.295  1.00  0.00           H  
ATOM   1761  HA  ARG A 109      -2.905  30.298  -5.459  1.00  0.00           H  
ATOM   1762  HB2 ARG A 109      -3.578  29.092  -7.368  1.00  0.00           H  
ATOM   1763  HB3 ARG A 109      -5.027  29.229  -6.382  1.00  0.00           H  
ATOM   1764  HG2 ARG A 109      -5.514  31.319  -7.839  1.00  0.00           H  
ATOM   1765  HG3 ARG A 109      -4.355  30.588  -8.951  1.00  0.00           H  
ATOM   1766  HD2 ARG A 109      -5.730  28.475  -8.791  1.00  0.00           H  
ATOM   1767  HD3 ARG A 109      -6.950  29.434  -7.955  1.00  0.00           H  
ATOM   1768  HE  ARG A 109      -6.323  30.743 -10.335  1.00  0.00           H  
ATOM   1769 HH11 ARG A 109      -7.780  27.761  -9.283  1.00  0.00           H  
ATOM   1770 HH12 ARG A 109      -8.803  27.618 -10.674  1.00  0.00           H  
ATOM   1771 HH21 ARG A 109      -7.666  30.566 -12.171  1.00  0.00           H  
ATOM   1772 HH22 ARG A 109      -8.737  29.215 -12.316  1.00  0.00           H  
ATOM   1773  N   GLN A 110      -3.558  32.883  -7.349  1.00  0.00           N  
ATOM   1774  CA  GLN A 110      -2.957  33.920  -8.180  1.00  0.00           C  
ATOM   1775  C   GLN A 110      -1.877  34.675  -7.412  1.00  0.00           C  
ATOM   1776  O   GLN A 110      -0.745  34.803  -7.879  1.00  0.00           O  
ATOM   1777  CB  GLN A 110      -4.030  34.895  -8.668  1.00  0.00           C  
ATOM   1778  CG  GLN A 110      -5.154  34.225  -9.443  1.00  0.00           C  
ATOM   1779  CD  GLN A 110      -5.837  35.167 -10.414  1.00  0.00           C  
ATOM   1780  OE1 GLN A 110      -7.053  35.352 -10.368  1.00  0.00           O  
ATOM   1781  NE2 GLN A 110      -5.055  35.771 -11.303  1.00  0.00           N  
ATOM   1782  H   GLN A 110      -4.492  32.974  -7.070  1.00  0.00           H  
ATOM   1783  HA  GLN A 110      -2.505  33.438  -9.034  1.00  0.00           H  
ATOM   1784  HB2 GLN A 110      -4.459  35.396  -7.815  1.00  0.00           H  
ATOM   1785  HB3 GLN A 110      -3.567  35.627  -9.313  1.00  0.00           H  
ATOM   1786  HG2 GLN A 110      -4.746  33.393 -10.000  1.00  0.00           H  
ATOM   1787  HG3 GLN A 110      -5.889  33.860  -8.740  1.00  0.00           H  
ATOM   1788 HE21 GLN A 110      -4.094  35.574 -11.282  1.00  0.00           H  
ATOM   1789 HE22 GLN A 110      -5.469  36.383 -11.943  1.00  0.00           H  
ATOM   1790  N   ALA A 111      -2.236  35.176  -6.236  1.00  0.00           N  
ATOM   1791  CA  ALA A 111      -1.296  35.918  -5.403  1.00  0.00           C  
ATOM   1792  C   ALA A 111      -0.056  35.085  -5.100  1.00  0.00           C  
ATOM   1793  O   ALA A 111       0.962  35.614  -4.651  1.00  0.00           O  
ATOM   1794  CB  ALA A 111      -1.970  36.357  -4.112  1.00  0.00           C  
ATOM   1795  H   ALA A 111      -3.153  35.042  -5.917  1.00  0.00           H  
ATOM   1796  HA  ALA A 111      -1.000  36.805  -5.945  1.00  0.00           H  
ATOM   1797  HB1 ALA A 111      -2.970  35.952  -4.073  1.00  0.00           H  
ATOM   1798  HB2 ALA A 111      -1.401  35.995  -3.268  1.00  0.00           H  
ATOM   1799  HB3 ALA A 111      -2.015  37.434  -4.078  1.00  0.00           H  
ATOM   1800  N   GLU A 112      -0.148  33.782  -5.345  1.00  0.00           N  
ATOM   1801  CA  GLU A 112       0.968  32.878  -5.096  1.00  0.00           C  
ATOM   1802  C   GLU A 112       1.699  32.544  -6.395  1.00  0.00           C  
ATOM   1803  O   GLU A 112       2.927  32.475  -6.429  1.00  0.00           O  
ATOM   1804  CB  GLU A 112       0.473  31.592  -4.432  1.00  0.00           C  
ATOM   1805  CG  GLU A 112      -0.165  31.816  -3.072  1.00  0.00           C  
ATOM   1806  CD  GLU A 112      -0.016  30.618  -2.153  1.00  0.00           C  
ATOM   1807  OE1 GLU A 112       1.042  30.503  -1.499  1.00  0.00           O  
ATOM   1808  OE2 GLU A 112      -0.955  29.800  -2.088  1.00  0.00           O  
ATOM   1809  H   GLU A 112      -0.986  33.422  -5.703  1.00  0.00           H  
ATOM   1810  HA  GLU A 112       1.655  33.376  -4.428  1.00  0.00           H  
ATOM   1811  HB2 GLU A 112      -0.257  31.126  -5.078  1.00  0.00           H  
ATOM   1812  HB3 GLU A 112       1.310  30.921  -4.309  1.00  0.00           H  
ATOM   1813  HG2 GLU A 112       0.303  32.669  -2.605  1.00  0.00           H  
ATOM   1814  HG3 GLU A 112      -1.219  32.015  -3.210  1.00  0.00           H  
ATOM   1815  N   LYS A 113       0.934  32.340  -7.460  1.00  0.00           N  
ATOM   1816  CA  LYS A 113       1.506  32.015  -8.762  1.00  0.00           C  
ATOM   1817  C   LYS A 113       2.361  33.164  -9.284  1.00  0.00           C  
ATOM   1818  O   LYS A 113       3.241  32.967 -10.120  1.00  0.00           O  
ATOM   1819  CB  LYS A 113       0.394  31.696  -9.765  1.00  0.00           C  
ATOM   1820  CG  LYS A 113      -0.159  32.923 -10.470  1.00  0.00           C  
ATOM   1821  CD  LYS A 113      -1.366  32.578 -11.325  1.00  0.00           C  
ATOM   1822  CE  LYS A 113      -0.950  32.031 -12.682  1.00  0.00           C  
ATOM   1823  NZ  LYS A 113      -0.168  33.029 -13.465  1.00  0.00           N  
ATOM   1824  H   LYS A 113      -0.040  32.409  -7.371  1.00  0.00           H  
ATOM   1825  HA  LYS A 113       2.131  31.143  -8.641  1.00  0.00           H  
ATOM   1826  HB2 LYS A 113       0.783  31.021 -10.513  1.00  0.00           H  
ATOM   1827  HB3 LYS A 113      -0.417  31.211  -9.243  1.00  0.00           H  
ATOM   1828  HG2 LYS A 113      -0.452  33.651  -9.729  1.00  0.00           H  
ATOM   1829  HG3 LYS A 113       0.612  33.340 -11.103  1.00  0.00           H  
ATOM   1830  HD2 LYS A 113      -1.956  31.830 -10.815  1.00  0.00           H  
ATOM   1831  HD3 LYS A 113      -1.960  33.469 -11.471  1.00  0.00           H  
ATOM   1832  HE2 LYS A 113      -0.346  31.151 -12.532  1.00  0.00           H  
ATOM   1833  HE3 LYS A 113      -1.839  31.770 -13.238  1.00  0.00           H  
ATOM   1834  HZ1 LYS A 113       0.766  32.639 -13.706  1.00  0.00           H  
ATOM   1835  HZ2 LYS A 113      -0.035  33.896 -12.907  1.00  0.00           H  
ATOM   1836  HZ3 LYS A 113      -0.670  33.268 -14.344  1.00  0.00           H  
ATOM   1837  N   MET A 114       2.097  34.366  -8.783  1.00  0.00           N  
ATOM   1838  CA  MET A 114       2.846  35.548  -9.196  1.00  0.00           C  
ATOM   1839  C   MET A 114       4.344  35.262  -9.216  1.00  0.00           C  
ATOM   1840  O   MET A 114       5.053  35.686 -10.128  1.00  0.00           O  
ATOM   1841  CB  MET A 114       2.551  36.720  -8.258  1.00  0.00           C  
ATOM   1842  CG  MET A 114       1.067  36.982  -8.059  1.00  0.00           C  
ATOM   1843  SD  MET A 114       0.712  38.701  -7.647  1.00  0.00           S  
ATOM   1844  CE  MET A 114      -1.035  38.789  -8.032  1.00  0.00           C  
ATOM   1845  H   MET A 114       1.383  34.463  -8.118  1.00  0.00           H  
ATOM   1846  HA  MET A 114       2.527  35.809 -10.194  1.00  0.00           H  
ATOM   1847  HB2 MET A 114       2.990  36.512  -7.294  1.00  0.00           H  
ATOM   1848  HB3 MET A 114       3.001  37.613  -8.664  1.00  0.00           H  
ATOM   1849  HG2 MET A 114       0.546  36.731  -8.972  1.00  0.00           H  
ATOM   1850  HG3 MET A 114       0.709  36.351  -7.258  1.00  0.00           H  
ATOM   1851  HE1 MET A 114      -1.273  39.778  -8.392  1.00  0.00           H  
ATOM   1852  HE2 MET A 114      -1.271  38.061  -8.794  1.00  0.00           H  
ATOM   1853  HE3 MET A 114      -1.610  38.580  -7.142  1.00  0.00           H  
ATOM   1854  N   GLY A 115       4.819  34.541  -8.205  1.00  0.00           N  
ATOM   1855  CA  GLY A 115       6.231  34.213  -8.127  1.00  0.00           C  
ATOM   1856  C   GLY A 115       6.512  32.774  -8.509  1.00  0.00           C  
ATOM   1857  O   GLY A 115       6.199  31.852  -7.755  1.00  0.00           O  
ATOM   1858  H   GLY A 115       4.205  34.231  -7.506  1.00  0.00           H  
ATOM   1859  HA2 GLY A 115       6.778  34.865  -8.791  1.00  0.00           H  
ATOM   1860  HA3 GLY A 115       6.571  34.378  -7.115  1.00  0.00           H  
ATOM   1861  N   SER A 116       7.104  32.579  -9.683  1.00  0.00           N  
ATOM   1862  CA  SER A 116       7.422  31.241 -10.167  1.00  0.00           C  
ATOM   1863  C   SER A 116       8.410  30.547  -9.232  1.00  0.00           C  
ATOM   1864  O   SER A 116       9.622  30.624  -9.423  1.00  0.00           O  
ATOM   1865  CB  SER A 116       8.005  31.310 -11.580  1.00  0.00           C  
ATOM   1866  OG  SER A 116       8.093  30.021 -12.159  1.00  0.00           O  
ATOM   1867  H   SER A 116       7.329  33.354 -10.238  1.00  0.00           H  
ATOM   1868  HA  SER A 116       6.506  30.670 -10.190  1.00  0.00           H  
ATOM   1869  HB2 SER A 116       7.368  31.926 -12.198  1.00  0.00           H  
ATOM   1870  HB3 SER A 116       8.993  31.743 -11.538  1.00  0.00           H  
ATOM   1871  HG  SER A 116       8.992  29.866 -12.458  1.00  0.00           H  
ATOM   1872  N   GLY A 117       7.879  29.867  -8.219  1.00  0.00           N  
ATOM   1873  CA  GLY A 117       8.726  29.171  -7.270  1.00  0.00           C  
ATOM   1874  C   GLY A 117       7.936  28.266  -6.344  1.00  0.00           C  
ATOM   1875  O   GLY A 117       7.797  27.065  -6.583  1.00  0.00           O  
ATOM   1876  H   GLY A 117       6.904  29.841  -8.116  1.00  0.00           H  
ATOM   1877  HA2 GLY A 117       9.442  28.574  -7.812  1.00  0.00           H  
ATOM   1878  HA3 GLY A 117       9.257  29.898  -6.675  1.00  0.00           H  
ATOM   1879  N   PRO A 118       7.403  28.844  -5.258  1.00  0.00           N  
ATOM   1880  CA  PRO A 118       6.614  28.100  -4.270  1.00  0.00           C  
ATOM   1881  C   PRO A 118       5.262  27.660  -4.821  1.00  0.00           C  
ATOM   1882  O   PRO A 118       4.520  26.932  -4.161  1.00  0.00           O  
ATOM   1883  CB  PRO A 118       6.426  29.108  -3.134  1.00  0.00           C  
ATOM   1884  CG  PRO A 118       6.540  30.442  -3.787  1.00  0.00           C  
ATOM   1885  CD  PRO A 118       7.526  30.270  -4.911  1.00  0.00           C  
ATOM   1886  HA  PRO A 118       7.150  27.237  -3.904  1.00  0.00           H  
ATOM   1887  HB2 PRO A 118       5.453  28.970  -2.684  1.00  0.00           H  
ATOM   1888  HB3 PRO A 118       7.195  28.966  -2.392  1.00  0.00           H  
ATOM   1889  HG2 PRO A 118       5.580  30.745  -4.176  1.00  0.00           H  
ATOM   1890  HG3 PRO A 118       6.905  31.168  -3.077  1.00  0.00           H  
ATOM   1891  HD2 PRO A 118       7.257  30.896  -5.748  1.00  0.00           H  
ATOM   1892  HD3 PRO A 118       8.526  30.498  -4.572  1.00  0.00           H  
ATOM   1893  N   SER A 119       4.948  28.106  -6.035  1.00  0.00           N  
ATOM   1894  CA  SER A 119       3.684  27.760  -6.671  1.00  0.00           C  
ATOM   1895  C   SER A 119       3.850  27.653  -8.184  1.00  0.00           C  
ATOM   1896  O   SER A 119       4.296  28.594  -8.839  1.00  0.00           O  
ATOM   1897  CB  SER A 119       2.618  28.804  -6.336  1.00  0.00           C  
ATOM   1898  OG  SER A 119       1.380  28.486  -6.952  1.00  0.00           O  
ATOM   1899  H   SER A 119       5.582  28.683  -6.509  1.00  0.00           H  
ATOM   1900  HA  SER A 119       3.370  26.801  -6.287  1.00  0.00           H  
ATOM   1901  HB2 SER A 119       2.475  28.839  -5.267  1.00  0.00           H  
ATOM   1902  HB3 SER A 119       2.942  29.772  -6.689  1.00  0.00           H  
ATOM   1903  HG  SER A 119       1.542  28.040  -7.786  1.00  0.00           H  
ATOM   1904  N   SER A 120       3.484  26.498  -8.733  1.00  0.00           N  
ATOM   1905  CA  SER A 120       3.596  26.266 -10.168  1.00  0.00           C  
ATOM   1906  C   SER A 120       2.506  27.016 -10.927  1.00  0.00           C  
ATOM   1907  O   SER A 120       1.612  27.609 -10.326  1.00  0.00           O  
ATOM   1908  CB  SER A 120       3.506  24.769 -10.471  1.00  0.00           C  
ATOM   1909  OG  SER A 120       2.230  24.255 -10.127  1.00  0.00           O  
ATOM   1910  H   SER A 120       3.136  25.786  -8.159  1.00  0.00           H  
ATOM   1911  HA  SER A 120       4.560  26.631 -10.489  1.00  0.00           H  
ATOM   1912  HB2 SER A 120       3.672  24.607 -11.526  1.00  0.00           H  
ATOM   1913  HB3 SER A 120       4.259  24.242  -9.903  1.00  0.00           H  
ATOM   1914  HG  SER A 120       1.981  24.574  -9.256  1.00  0.00           H  
ATOM   1915  N   GLY A 121       2.591  26.987 -12.254  1.00  0.00           N  
ATOM   1916  CA  GLY A 121       1.606  27.669 -13.074  1.00  0.00           C  
ATOM   1917  C   GLY A 121       2.027  27.761 -14.528  1.00  0.00           C  
ATOM   1918  O   GLY A 121       1.748  26.861 -15.320  1.00  0.00           O  
ATOM   1919  H   GLY A 121       3.326  26.500 -12.679  1.00  0.00           H  
ATOM   1920  HA2 GLY A 121       0.671  27.134 -13.015  1.00  0.00           H  
ATOM   1921  HA3 GLY A 121       1.463  28.668 -12.689  1.00  0.00           H  
TER    1922      GLY A 121                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
