
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  112 (  913),  selected  112 , name 2dvv_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 2dvv_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      S       1           -
LGA    S     2_A      M       2           -
LGA    -       -      Q       3           -
LGA    -       -      E       4           -
LGA    H     3_A      E       5           #
LGA    -       -      D       6           -
LGA    M     4_A      T       7          2.602
LGA    -       -      F       8           -
LGA    -       -      R       9           -
LGA    E   348_A      E      10          3.773
LGA    Q   349_A      L      11          3.785
LGA    L   350_A      R      12          3.755
LGA    K   351_A      I      13          3.233
LGA    H   352_A      F      14          2.744
LGA    C   353_A      L      15          2.230
LGA    N   354_A      R      16          2.272
LGA    G   355_A      N      17          2.106
LGA    I   356_A      V      18          1.108
LGA    L   357_A      T      19          0.632
LGA    K   358_A      H      20          1.617
LGA    E   359_A      R      21          0.668
LGA    L   360_A      L      22          0.542
LGA    L   361_A      A      23          1.591
LGA    S   362_A      I      24          2.264
LGA    K   363_A      -       -           -
LGA    K   364_A      -       -           -
LGA    H   365_A      D      25          1.455
LGA    A   366_A      K      26          1.708
LGA    A   367_A      -       -           -
LGA    Y   368_A      R      27          0.845
LGA    A   369_A      F      28          0.841
LGA    W   370_A      R      29          0.425
LGA    P   371_A      V      30          0.137
LGA    F   372_A      F      31          0.566
LGA    Y   373_A      T      32          0.712
LGA    K   374_A      K      33          0.596
LGA    P   375_A      P      34          0.549
LGA    V   376_A      V      35          0.876
LGA    D   377_A      D      36          1.089
LGA    A   378_A      P      37          3.191
LGA    S   379_A      D      38          2.389
LGA    A   380_A      -       -           -
LGA    L   381_A      E      39          1.917
LGA    G   382_A      V      40          3.625
LGA    L   383_A      -       -           -
LGA    H   384_A      P      41          3.027
LGA    D   385_A      D      42          2.416
LGA    Y   386_A      Y      43          1.680
LGA    H   387_A      V      44          1.993
LGA    D   388_A      T      45          2.143
LGA    I   389_A      V      46          1.703
LGA    I   390_A      I      47          0.707
LGA    K   391_A      K      48          0.504
LGA    H   392_A      Q      49          0.421
LGA    P   393_A      P      50          0.472
LGA    M   394_A      M      51          0.513
LGA    D   395_A      D      52          0.442
LGA    L   396_A      L      53          0.459
LGA    S   397_A      S      54          0.444
LGA    T   398_A      S      55          0.549
LGA    V   399_A      V      56          0.510
LGA    K   400_A      I      57          0.585
LGA    R   401_A      S      58          1.005
LGA    K   402_A      K      59          1.221
LGA    M   403_A      I      60          1.095
LGA    E   404_A      D      61          1.986
LGA    N   405_A      L      62          2.575
LGA    R   406_A      H      63          2.196
LGA    D   407_A      K      64          2.538
LGA    Y   408_A      Y      65          1.843
LGA    R   409_A      L      66          2.027
LGA    D   410_A      T      67          2.027
LGA    A   411_A      V      68          1.651
LGA    Q   412_A      K      69          1.538
LGA    E   413_A      D      70          1.336
LGA    F   414_A      Y      71          1.225
LGA    A   415_A      L      72          1.207
LGA    A   416_A      R      73          0.920
LGA    D   417_A      D      74          1.023
LGA    V   418_A      I      75          1.290
LGA    R   419_A      D      76          1.017
LGA    L   420_A      L      77          0.674
LGA    M   421_A      I      78          0.987
LGA    F   422_A      C      79          0.920
LGA    S   423_A      S      80          0.753
LGA    N   424_A      N      81          0.419
LGA    C   425_A      A      82          0.419
LGA    Y   426_A      L      83          0.648
LGA    K   427_A      E      84          0.880
LGA    Y   428_A      Y      85          0.801
LGA    N   429_A      N      86          0.526
LGA    P   430_A      P      87          1.825
LGA    P   431_A      D      88          4.871
LGA    D   432_A      R      89          3.736
LGA    -       -      D      90           -
LGA    -       -      P      91           -
LGA    -       -      G      92           -
LGA    -       -      D      93           -
LGA    H   433_A      R      94          2.908
LGA    D   434_A      L      95          1.863
LGA    V   435_A      I      96          1.324
LGA    V   436_A      R      97          1.299
LGA    A   437_A      H      98          1.756
LGA    M   438_A      R      99          1.521
LGA    A   439_A      A     100          1.244
LGA    R   440_A      C     101          1.726
LGA    K   441_A      A     102          1.925
LGA    L   442_A      L     103          1.884
LGA    Q   443_A      R     104          1.813
LGA    D   444_A      D     105          1.888
LGA    V   445_A      T     106          1.156
LGA    F   446_A      A     107          0.980
LGA    E   447_A      Y     108          1.475
LGA    F   448_A      A     109          0.793
LGA    R   449_A      I     110          0.939
LGA    Y   450_A      I     111          1.940
LGA    A   451_A      K     112          1.817
LGA    K   452_A      E     113          2.522
LGA    -       -      E     114           -
LGA    M   453_A      L     115          2.008
LGA    P   454_A      D     116          1.006
LGA    D   455_A      E     117          1.772
LGA    -       -      D     118           -
LGA    -       -      F     119           -
LGA    -       -      E     120           -
LGA    -       -      Q     121           -
LGA    -       -      L     122           -
LGA    -       -      C     123           -
LGA    -       -      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  112  130    5.0    104    1.79    27.88     72.294     5.493

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.247433 * X  +  -0.401184 * Y  +  -0.881946 * Z  +  -2.627800
  Y_new =  -0.089619 * X  +   0.915824 * Y  +  -0.391452 * Z  +  36.074245
  Z_new =   0.964752 * X  +  -0.017819 * Y  +  -0.262558 * Z  + -27.260523 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.073830    0.067763  [ DEG:  -176.1175      3.8825 ]
  Theta =  -1.304498   -1.837095  [ DEG:   -74.7422   -105.2578 ]
  Phi   =  -2.794095    0.347498  [ DEG:  -160.0898     19.9102 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dvv_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dvv_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  112  130   5.0  104   1.79   27.88  72.294
REMARK  ---------------------------------------------------------- 
MOLECULE 2dvv_A
HEADER    TRANSCRIPTION                           01-AUG-06   2DVV              
TITLE     CRYSTAL STRUCTURE OF THE SECOND BROMODOMAIN OF THE HUMAN              
TITLE    2 BRD2 PROTEIN                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BROMODOMAIN-CONTAINING PROTEIN 2;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 348-455;                                          
COMPND   5 SYNONYM: BRD2, RING3 PROTEIN, O27.1.1;                               
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: BRD2, KIAA9001, RING3;                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    BROMODOMAIN, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT            
KEYWDS   2 ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                 
KEYWDS   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI,                     
KEYWDS   4 TRANSCRIPTION                                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.PADMANABHAN,S.YOKOYAMA,RIKEN STRUCTURAL                             
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   07-AUG-07 2DVV    0                                                
JRNL        AUTH   B.PADMANABHAN,S.YOKOYAMA                                     
JRNL        TITL   CRYSTAL STRUCTURE OF THE SECOND BROMODOMAIN OF THE           
JRNL        TITL 2 HUMAN BRD2 PROTEIN                                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2DVV A  348   455  UNP    P25440   BRD2_HUMAN     348    455             
SEQRES   1 A  112  GLY SER HIS MET GLU GLN LEU LYS HIS CYS ASN GLY ILE          
SEQRES   2 A  112  LEU LYS GLU LEU LEU SER LYS LYS HIS ALA ALA TYR ALA          
SEQRES   3 A  112  TRP PRO PHE TYR LYS PRO VAL ASP ALA SER ALA LEU GLY          
SEQRES   4 A  112  LEU HIS ASP TYR HIS ASP ILE ILE LYS HIS PRO MET ASP          
SEQRES   5 A  112  LEU SER THR VAL LYS ARG LYS MET GLU ASN ARG ASP TYR          
SEQRES   6 A  112  ARG ASP ALA GLN GLU PHE ALA ALA ASP VAL ARG LEU MET          
SEQRES   7 A  112  PHE SER ASN CYS TYR LYS TYR ASN PRO PRO ASP HIS ASP          
SEQRES   8 A  112  VAL VAL ALA MET ALA ARG LYS LEU GLN ASP VAL PHE GLU          
SEQRES   9 A  112  PHE ARG TYR ALA LYS MET PRO ASP                              
HET    EPE  A 300      15                                                       
HETNAM     EPE 4-(2-HYDROXYETHYL)-1-PIPERAZINE ETHANESULFONIC ACID              
HETSYN     EPE HEPES                                                            
FORMUL   2  EPE    C8 H18 N2 O4 S                                               
FORMUL   3  HOH   *270(H2 O)                                                    
CRYST1   71.782   52.604   32.059  90.00  90.00  90.00 P 21 21 2     4          
ATOM      1  N   GLY A   1       3.037  36.113   1.859  1.00 51.14           N  
ATOM      2  CA  GLY A   1       2.558  36.358   0.469  1.00 50.87           C  
ATOM      3  C   GLY A   1       2.418  37.835   0.163  1.00 49.94           C  
ATOM      4  O   GLY A   1       1.328  38.312  -0.162  1.00 50.73           O  
ATOM      5  N   SER A   2       3.526  38.562   0.266  1.00 48.79           N  
ATOM      6  CA  SER A   2       3.535  39.995   0.006  1.00 47.42           C  
ATOM      7  C   SER A   2       3.781  40.290  -1.469  1.00 45.98           C  
ATOM      8  O   SER A   2       4.411  41.288  -1.815  1.00 47.09           O  
ATOM      9  CB  SER A   2       4.603  40.671   0.859  1.00 47.66           C  
ATOM     10  N   HIS A   3       3.281  39.414  -2.335  1.00 43.64           N  
ATOM     11  CA  HIS A   3       3.444  39.585  -3.771  1.00 40.75           C  
ATOM     12  C   HIS A   3       2.407  40.569  -4.301  1.00 39.16           C  
ATOM     13  O   HIS A   3       1.270  40.604  -3.824  1.00 38.97           O  
ATOM     14  CB  HIS A   3       3.297  38.245  -4.478  1.00 41.29           C  
ATOM     15  N   MET A   4       2.804  41.374  -5.280  1.00 36.11           N  
ATOM     16  CA  MET A   4       1.894  42.345  -5.870  1.00 32.41           C  
ATOM     17  C   MET A   4       0.788  41.590  -6.595  1.00 29.87           C  
ATOM     18  O   MET A   4      -0.371  42.009  -6.594  1.00 28.76           O  
ATOM     19  CB  MET A   4       2.643  43.243  -6.843  1.00 33.75           C  
ATOM     20  N   GLU A 348       1.158  40.469  -7.205  1.00 25.97           N  
ATOM     21  CA  GLU A 348       0.216  39.639  -7.937  1.00 23.72           C  
ATOM     22  C   GLU A 348      -0.923  39.151  -7.051  1.00 20.87           C  
ATOM     23  O   GLU A 348      -2.082  39.149  -7.463  1.00 19.27           O  
ATOM     24  CB  GLU A 348       0.939  38.436  -8.552  1.00 26.44           C  
ATOM     25  CG  GLU A 348       0.001  37.354  -9.058  1.00 29.06           C  
ATOM     26  CD  GLU A 348       0.714  36.252  -9.814  1.00 30.51           C  
ATOM     27  OE1 GLU A 348       1.665  35.659  -9.260  1.00 34.61           O  
ATOM     28  OE2 GLU A 348       0.314  35.972 -10.963  1.00 29.88           O  
ATOM     29  N   GLN A 349      -0.593  38.724  -5.836  1.00 16.92           N  
ATOM     30  CA  GLN A 349      -1.617  38.241  -4.924  1.00 15.83           C  
ATOM     31  C   GLN A 349      -2.537  39.382  -4.495  1.00 13.98           C  
ATOM     32  O   GLN A 349      -3.738  39.182  -4.319  1.00 12.25           O  
ATOM     33  CB  GLN A 349      -0.979  37.578  -3.701  1.00 18.47           C  
ATOM     34  CG  GLN A 349      -0.130  36.359  -4.045  1.00 20.91           C  
ATOM     35  CD  GLN A 349      -0.005  35.389  -2.885  1.00 24.14           C  
ATOM     36  OE1 GLN A 349       0.229  35.791  -1.749  1.00 25.35           O  
ATOM     37  NE2 GLN A 349      -0.156  34.101  -3.172  1.00 25.99           N  
ATOM     38  N   LEU A 350      -1.982  40.579  -4.332  1.00 13.21           N  
ATOM     39  CA  LEU A 350      -2.809  41.713  -3.942  1.00 13.65           C  
ATOM     40  C   LEU A 350      -3.770  42.095  -5.067  1.00 11.88           C  
ATOM     41  O   LEU A 350      -4.869  42.584  -4.812  1.00 10.02           O  
ATOM     42  CB  LEU A 350      -1.939  42.902  -3.532  1.00 16.44           C  
ATOM     43  CG  LEU A 350      -1.357  42.735  -2.121  1.00 17.85           C  
ATOM     44  CD1 LEU A 350      -0.483  43.920  -1.764  1.00 20.04           C  
ATOM     45  CD2 LEU A 350      -2.495  42.589  -1.123  1.00 18.50           C  
ATOM     46  N   LYS A 351      -3.358  41.874  -6.312  1.00 10.81           N  
ATOM     47  CA  LYS A 351      -4.230  42.165  -7.445  1.00  9.03           C  
ATOM     48  C   LYS A 351      -5.408  41.198  -7.368  1.00  9.03           C  
ATOM     49  O   LYS A 351      -6.546  41.571  -7.628  1.00  8.11           O  
ATOM     50  CB  LYS A 351      -3.488  41.961  -8.767  1.00 13.58           C  
ATOM     51  CG  LYS A 351      -2.414  42.994  -9.051  1.00 16.59           C  
ATOM     52  CD  LYS A 351      -3.023  44.334  -9.417  1.00 17.78           C  
ATOM     53  CE  LYS A 351      -1.960  45.296  -9.922  1.00 18.86           C  
ATOM     54  NZ  LYS A 351      -2.554  46.571 -10.403  1.00 21.59           N  
ATOM     55  N   HIS A 352      -5.127  39.947  -7.006  1.00  7.64           N  
ATOM     56  CA  HIS A 352      -6.190  38.955  -6.887  1.00  8.87           C  
ATOM     57  C   HIS A 352      -7.161  39.405  -5.798  1.00  9.82           C  
ATOM     58  O   HIS A 352      -8.375  39.302  -5.948  1.00  9.45           O  
ATOM     59  CB  HIS A 352      -5.619  37.584  -6.516  1.00 11.28           C  
ATOM     60  CG  HIS A 352      -6.653  36.504  -6.444  1.00 12.66           C  
ATOM     61  ND1 HIS A 352      -7.349  36.069  -7.551  1.00 14.21           N  
ATOM     62  CD2 HIS A 352      -7.132  35.793  -5.396  1.00 14.62           C  
ATOM     63  CE1 HIS A 352      -8.214  35.138  -7.188  1.00 14.95           C  
ATOM     64  NE2 HIS A 352      -8.104  34.953  -5.885  1.00 13.93           N  
ATOM     65  N   CYS A 353      -6.614  39.909  -4.698  1.00  9.72           N  
ATOM     66  CA  CYS A 353      -7.442  40.380  -3.598  1.00  8.89           C  
ATOM     67  C   CYS A 353      -8.300  41.556  -4.045  1.00  8.15           C  
ATOM     68  O   CYS A 353      -9.474  41.648  -3.693  1.00  8.42           O  
ATOM     69  CB  CYS A 353      -6.569  40.805  -2.415  1.00 10.29           C  
ATOM     70  SG  CYS A 353      -5.769  39.427  -1.564  1.00 13.17           S  
ATOM     71  N   ASN A 354      -7.716  42.460  -4.823  1.00  8.12           N  
ATOM     72  CA  ASN A 354      -8.480  43.613  -5.286  1.00  7.96           C  
ATOM     73  C   ASN A 354      -9.613  43.168  -6.215  1.00  8.42           C  
ATOM     74  O   ASN A 354     -10.685  43.783  -6.241  1.00  9.12           O  
ATOM     75  CB  ASN A 354      -7.568  44.602  -6.004  1.00  9.64           C  
ATOM     76  CG  ASN A 354      -8.235  45.939  -6.225  1.00  9.33           C  
ATOM     77  OD1 ASN A 354      -8.797  46.515  -5.296  1.00 10.01           O  
ATOM     78  ND2 ASN A 354      -8.178  46.441  -7.453  1.00  9.38           N  
ATOM     79  N   GLY A 355      -9.370  42.103  -6.976  1.00  8.80           N  
ATOM     80  CA  GLY A 355     -10.386  41.584  -7.878  1.00  9.36           C  
ATOM     81  C   GLY A 355     -11.568  41.076  -7.073  1.00  8.77           C  
ATOM     82  O   GLY A 355     -12.724  41.340  -7.407  1.00  8.84           O  
ATOM     83  N   ILE A 356     -11.270  40.343  -6.004  1.00  7.69           N  
ATOM     84  CA  ILE A 356     -12.307  39.811  -5.124  1.00  8.06           C  
ATOM     85  C   ILE A 356     -13.100  40.974  -4.535  1.00  8.27           C  
ATOM     86  O   ILE A 356     -14.328  40.960  -4.520  1.00  7.10           O  
ATOM     87  CB  ILE A 356     -11.690  38.993  -3.964  1.00  8.26           C  
ATOM     88  CG1 ILE A 356     -11.047  37.717  -4.508  1.00  8.61           C  
ATOM     89  CG2 ILE A 356     -12.760  38.661  -2.926  1.00 10.32           C  
ATOM     90  CD1 ILE A 356     -10.247  36.944  -3.473  1.00 10.17           C  
ATOM     91  N   LEU A 357     -12.382  41.985  -4.055  1.00 10.37           N  
ATOM     92  CA  LEU A 357     -13.004  43.163  -3.456  1.00 10.26           C  
ATOM     93  C   LEU A 357     -13.981  43.781  -4.454  1.00 10.50           C  
ATOM     94  O   LEU A 357     -15.117  44.114  -4.109  1.00 10.48           O  
ATOM     95  CB  LEU A 357     -11.931  44.194  -3.087  1.00 11.86           C  
ATOM     96  CG  LEU A 357     -12.111  45.067  -1.837  1.00 18.96           C  
ATOM     97  CD1 LEU A 357     -11.346  46.368  -2.034  1.00 16.03           C  
ATOM     98  CD2 LEU A 357     -13.574  45.355  -1.569  1.00 16.17           C  
ATOM     99  N   LYS A 358     -13.529  43.938  -5.694  1.00 11.12           N  
ATOM    100  CA  LYS A 358     -14.370  44.504  -6.742  1.00 11.44           C  
ATOM    101  C   LYS A 358     -15.629  43.661  -6.947  1.00 10.96           C  
ATOM    102  O   LYS A 358     -16.727  44.202  -7.103  1.00 10.97           O  
ATOM    103  CB  LYS A 358     -13.591  44.595  -8.060  1.00 13.38           C  
ATOM    104  CG  LYS A 358     -12.548  45.708  -8.095  1.00 19.22           C  
ATOM    105  CD  LYS A 358     -13.201  47.093  -8.088  1.00 22.12           C  
ATOM    106  CE  LYS A 358     -14.095  47.295  -9.307  1.00 26.30           C  
ATOM    107  NZ  LYS A 358     -14.776  48.625  -9.310  1.00 29.35           N  
ATOM    108  N   GLU A 359     -15.476  42.340  -6.944  1.00 10.35           N  
ATOM    109  CA  GLU A 359     -16.632  41.465  -7.130  1.00 10.21           C  
ATOM    110  C   GLU A 359     -17.614  41.572  -5.973  1.00  9.53           C  
ATOM    111  O   GLU A 359     -18.824  41.648  -6.185  1.00  9.66           O  
ATOM    112  CB  GLU A 359     -16.210  39.995  -7.294  1.00 11.01           C  
ATOM    113  CG  GLU A 359     -17.407  39.093  -7.629  1.00 10.41           C  
ATOM    114  CD  GLU A 359     -17.051  37.632  -7.846  1.00 10.95           C  
ATOM    115  OE1 GLU A 359     -15.854  37.305  -7.998  1.00 11.26           O  
ATOM    116  OE2 GLU A 359     -17.986  36.806  -7.881  1.00  9.99           O  
ATOM    117  N   LEU A 360     -17.102  41.586  -4.745  1.00  9.49           N  
ATOM    118  CA  LEU A 360     -17.974  41.676  -3.577  1.00  9.22           C  
ATOM    119  C   LEU A 360     -18.808  42.955  -3.601  1.00 10.11           C  
ATOM    120  O   LEU A 360     -19.927  42.980  -3.086  1.00 11.54           O  
ATOM    121  CB  LEU A 360     -17.148  41.622  -2.286  1.00  7.82           C  
ATOM    122  CG  LEU A 360     -16.309  40.362  -2.035  1.00  7.83           C  
ATOM    123  CD1 LEU A 360     -15.625  40.486  -0.674  1.00  8.88           C  
ATOM    124  CD2 LEU A 360     -17.189  39.119  -2.076  1.00  9.84           C  
ATOM    125  N   LEU A 361     -18.263  44.007  -4.207  1.00 10.09           N  
ATOM    126  CA  LEU A 361     -18.948  45.296  -4.298  1.00 10.50           C  
ATOM    127  C   LEU A 361     -19.761  45.473  -5.584  1.00 11.79           C  
ATOM    128  O   LEU A 361     -20.390  46.517  -5.785  1.00 12.75           O  
ATOM    129  CB  LEU A 361     -17.924  46.433  -4.197  1.00 10.82           C  
ATOM    130  CG  LEU A 361     -17.230  46.600  -2.843  1.00 10.06           C  
ATOM    131  CD1 LEU A 361     -16.035  47.537  -2.981  1.00 14.21           C  
ATOM    132  CD2 LEU A 361     -18.231  47.135  -1.827  1.00 13.06           C  
ATOM    133  N   SER A 362     -19.751  44.455  -6.442  1.00 12.91           N  
ATOM    134  CA  SER A 362     -20.456  44.508  -7.721  1.00 13.65           C  
ATOM    135  C   SER A 362     -21.956  44.214  -7.642  1.00 14.78           C  
ATOM    136  O   SER A 362     -22.442  43.622  -6.680  1.00 12.53           O  
ATOM    137  CB  SER A 362     -19.803  43.542  -8.715  1.00 12.65           C  
ATOM    138  OG  SER A 362     -20.025  42.191  -8.354  1.00 14.89           O  
ATOM    139  N   LYS A 363     -22.680  44.627  -8.678  1.00 15.77           N  
ATOM    140  CA  LYS A 363     -24.124  44.430  -8.733  1.00 16.77           C  
ATOM    141  C   LYS A 363     -24.521  42.961  -8.621  1.00 15.69           C  
ATOM    142  O   LYS A 363     -25.584  42.637  -8.091  1.00 15.36           O  
ATOM    143  CB  LYS A 363     -24.679  45.014 -10.037  1.00 21.18           C  
ATOM    144  CG  LYS A 363     -26.191  45.169 -10.050  1.00 26.30           C  
ATOM    145  CD  LYS A 363     -26.656  46.119  -8.950  1.00 30.82           C  
ATOM    146  CE  LYS A 363     -28.162  46.345  -9.002  1.00 32.48           C  
ATOM    147  NZ  LYS A 363     -28.930  45.083  -8.817  1.00 36.47           N  
ATOM    148  N   LYS A 364     -23.663  42.071  -9.110  1.00 16.57           N  
ATOM    149  CA  LYS A 364     -23.951  40.642  -9.070  1.00 16.37           C  
ATOM    150  C   LYS A 364     -24.305  40.126  -7.678  1.00 15.33           C  
ATOM    151  O   LYS A 364     -25.140  39.232  -7.535  1.00 14.71           O  
ATOM    152  CB  LYS A 364     -22.762  39.843  -9.614  1.00 19.58           C  
ATOM    153  CG  LYS A 364     -23.007  38.338  -9.647  1.00 23.45           C  
ATOM    154  CD  LYS A 364     -21.894  37.591 -10.372  1.00 28.38           C  
ATOM    155  CE  LYS A 364     -20.562  37.715  -9.650  1.00 30.46           C  
ATOM    156  NZ  LYS A 364     -19.508  36.872 -10.292  1.00 35.16           N  
ATOM    157  N   HIS A 365     -23.682  40.696  -6.653  1.00 11.59           N  
ATOM    158  CA  HIS A 365     -23.916  40.253  -5.282  1.00 11.36           C  
ATOM    159  C   HIS A 365     -24.620  41.286  -4.404  1.00 11.17           C  
ATOM    160  O   HIS A 365     -24.750  41.089  -3.201  1.00 12.11           O  
ATOM    161  CB  HIS A 365     -22.578  39.885  -4.639  1.00 11.60           C  
ATOM    162  CG  HIS A 365     -21.797  38.863  -5.406  1.00 11.91           C  
ATOM    163  ND1 HIS A 365     -22.268  37.588  -5.638  1.00 11.54           N  
ATOM    164  CD2 HIS A 365     -20.583  38.930  -6.003  1.00 10.53           C  
ATOM    165  CE1 HIS A 365     -21.377  36.913  -6.344  1.00 12.41           C  
ATOM    166  NE2 HIS A 365     -20.345  37.705  -6.578  1.00 11.85           N  
ATOM    167  N   ALA A 366     -25.082  42.376  -5.008  1.00 11.92           N  
ATOM    168  CA  ALA A 366     -25.736  43.450  -4.262  1.00 11.31           C  
ATOM    169  C   ALA A 366     -26.913  43.041  -3.379  1.00 13.32           C  
ATOM    170  O   ALA A 366     -27.146  43.654  -2.336  1.00 11.41           O  
ATOM    171  CB  ALA A 366     -26.176  44.548  -5.229  1.00 13.23           C  
ATOM    172  N   ALA A 367     -27.659  42.018  -3.787  1.00 12.12           N  
ATOM    173  CA  ALA A 367     -28.818  41.582  -3.010  1.00 12.35           C  
ATOM    174  C   ALA A 367     -28.486  41.172  -1.578  1.00 13.11           C  
ATOM    175  O   ALA A 367     -29.316  41.328  -0.681  1.00 12.55           O  
ATOM    176  CB  ALA A 367     -29.532  40.435  -3.725  1.00 12.19           C  
ATOM    177  N   TYR A 368     -27.279  40.654  -1.361  1.00 11.55           N  
ATOM    178  CA  TYR A 368     -26.874  40.223  -0.030  1.00 10.98           C  
ATOM    179  C   TYR A 368     -25.598  40.882   0.493  1.00 10.36           C  
ATOM    180  O   TYR A 368     -25.236  40.706   1.655  1.00 10.92           O  
ATOM    181  CB  TYR A 368     -26.732  38.695   0.001  1.00 12.32           C  
ATOM    182  CG  TYR A 368     -26.120  38.097  -1.249  1.00 11.46           C  
ATOM    183  CD1 TYR A 368     -24.741  37.934  -1.372  1.00 12.10           C  
ATOM    184  CD2 TYR A 368     -26.928  37.694  -2.311  1.00 11.53           C  
ATOM    185  CE1 TYR A 368     -24.182  37.378  -2.526  1.00 13.24           C  
ATOM    186  CE2 TYR A 368     -26.384  37.142  -3.464  1.00 14.08           C  
ATOM    187  CZ  TYR A 368     -25.012  36.986  -3.567  1.00 15.07           C  
ATOM    188  OH  TYR A 368     -24.478  36.446  -4.717  1.00 15.13           O  
ATOM    189  N   ALA A 369     -24.926  41.656  -0.351  1.00  9.64           N  
ATOM    190  CA  ALA A 369     -23.690  42.312   0.071  1.00  8.61           C  
ATOM    191  C   ALA A 369     -23.908  43.699   0.663  1.00  8.69           C  
ATOM    192  O   ALA A 369     -23.066  44.199   1.411  1.00  9.41           O  
ATOM    193  CB  ALA A 369     -22.727  42.413  -1.112  1.00  8.30           C  
ATOM    194  N   TRP A 370     -25.040  44.319   0.343  1.00 10.49           N  
ATOM    195  CA  TRP A 370     -25.296  45.680   0.808  1.00 10.59           C  
ATOM    196  C   TRP A 370     -25.142  45.982   2.299  1.00  9.70           C  
ATOM    197  O   TRP A 370     -24.746  47.089   2.661  1.00 10.72           O  
ATOM    198  CB  TRP A 370     -26.666  46.178   0.312  1.00 11.29           C  
ATOM    199  CG  TRP A 370     -27.856  45.514   0.924  1.00 12.51           C  
ATOM    200  CD1 TRP A 370     -28.554  44.453   0.423  1.00 12.39           C  
ATOM    201  CD2 TRP A 370     -28.494  45.868   2.157  1.00 15.19           C  
ATOM    202  NE1 TRP A 370     -29.586  44.124   1.269  1.00 13.73           N  
ATOM    203  CE2 TRP A 370     -29.572  44.977   2.342  1.00 14.34           C  
ATOM    204  CE3 TRP A 370     -28.256  46.852   3.126  1.00 14.25           C  
ATOM    205  CZ2 TRP A 370     -30.415  45.040   3.457  1.00 16.53           C  
ATOM    206  CZ3 TRP A 370     -29.094  46.915   4.238  1.00 17.15           C  
ATOM    207  CH2 TRP A 370     -30.160  46.011   4.391  1.00 14.90           C  
ATOM    208  N   PRO A 371     -25.446  45.018   3.188  1.00 10.19           N  
ATOM    209  CA  PRO A 371     -25.286  45.339   4.612  1.00  9.35           C  
ATOM    210  C   PRO A 371     -23.824  45.579   5.000  1.00 11.70           C  
ATOM    211  O   PRO A 371     -23.533  46.156   6.045  1.00 12.55           O  
ATOM    212  CB  PRO A 371     -25.852  44.102   5.313  1.00 10.89           C  
ATOM    213  CG  PRO A 371     -26.841  43.563   4.327  1.00 11.04           C  
ATOM    214  CD  PRO A 371     -26.084  43.700   3.026  1.00  8.39           C  
ATOM    215  N   PHE A 372     -22.909  45.136   4.144  1.00 10.45           N  
ATOM    216  CA  PHE A 372     -21.485  45.255   4.420  1.00 10.57           C  
ATOM    217  C   PHE A 372     -20.766  46.340   3.632  1.00  9.24           C  
ATOM    218  O   PHE A 372     -19.541  46.438   3.684  1.00  8.86           O  
ATOM    219  CB  PHE A 372     -20.828  43.894   4.172  1.00 11.45           C  
ATOM    220  CG  PHE A 372     -21.598  42.751   4.771  1.00 11.32           C  
ATOM    221  CD1 PHE A 372     -22.501  42.020   4.003  1.00 11.20           C  
ATOM    222  CD2 PHE A 372     -21.494  42.471   6.132  1.00 11.92           C  
ATOM    223  CE1 PHE A 372     -23.293  41.029   4.582  1.00 10.03           C  
ATOM    224  CE2 PHE A 372     -22.279  41.487   6.719  1.00 11.30           C  
ATOM    225  CZ  PHE A 372     -23.184  40.763   5.943  1.00 10.89           C  
ATOM    226  N   TYR A 373     -21.527  47.164   2.919  1.00  9.19           N  
ATOM    227  CA  TYR A 373     -20.950  48.236   2.111  1.00  9.46           C  
ATOM    228  C   TYR A 373     -20.310  49.358   2.914  1.00  9.69           C  
ATOM    229  O   TYR A 373     -19.276  49.897   2.516  1.00 10.62           O  
ATOM    230  CB  TYR A 373     -22.015  48.862   1.208  1.00  8.04           C  
ATOM    231  CG  TYR A 373     -22.445  48.035   0.012  1.00  8.93           C  
ATOM    232  CD1 TYR A 373     -21.718  46.916  -0.399  1.00  9.46           C  
ATOM    233  CD2 TYR A 373     -23.554  48.415  -0.742  1.00 10.42           C  
ATOM    234  CE1 TYR A 373     -22.090  46.197  -1.541  1.00  9.53           C  
ATOM    235  CE2 TYR A 373     -23.930  47.712  -1.876  1.00 13.81           C  
ATOM    236  CZ  TYR A 373     -23.198  46.608  -2.274  1.00 12.25           C  
ATOM    237  OH  TYR A 373     -23.572  45.935  -3.413  1.00 12.37           O  
ATOM    238  N   LYS A 374     -20.930  49.718   4.033  1.00  9.93           N  
ATOM    239  CA  LYS A 374     -20.434  50.807   4.864  1.00 11.02           C  
ATOM    240  C   LYS A 374     -20.336  50.428   6.340  1.00 10.19           C  
ATOM    241  O   LYS A 374     -20.902  49.424   6.774  1.00  9.26           O  
ATOM    242  CB  LYS A 374     -21.357  52.023   4.718  1.00 14.38           C  
ATOM    243  CG  LYS A 374     -21.336  52.682   3.340  1.00 17.88           C  
ATOM    244  CD  LYS A 374     -19.957  53.246   3.030  1.00 19.46           C  
ATOM    245  CE  LYS A 374     -19.986  54.208   1.852  1.00 24.60           C  
ATOM    246  NZ  LYS A 374     -20.572  53.602   0.627  1.00 25.81           N  
ATOM    247  N   PRO A 375     -19.604  51.228   7.130  1.00 11.14           N  
ATOM    248  CA  PRO A 375     -19.476  50.922   8.556  1.00 10.07           C  
ATOM    249  C   PRO A 375     -20.854  50.859   9.203  1.00 11.43           C  
ATOM    250  O   PRO A 375     -21.755  51.614   8.835  1.00 10.10           O  
ATOM    251  CB  PRO A 375     -18.655  52.096   9.089  1.00 11.55           C  
ATOM    252  CG  PRO A 375     -17.808  52.470   7.921  1.00 12.23           C  
ATOM    253  CD  PRO A 375     -18.778  52.393   6.766  1.00 10.67           C  
ATOM    254  N   VAL A 376     -21.020  49.948  10.154  1.00 11.72           N  
ATOM    255  CA  VAL A 376     -22.290  49.829  10.851  1.00 11.90           C  
ATOM    256  C   VAL A 376     -22.524  51.122  11.621  1.00 13.07           C  
ATOM    257  O   VAL A 376     -21.672  51.546  12.402  1.00 13.23           O  
ATOM    258  CB  VAL A 376     -22.274  48.649  11.851  1.00 12.04           C  
ATOM    259  CG1 VAL A 376     -23.570  48.631  12.667  1.00 12.53           C  
ATOM    260  CG2 VAL A 376     -22.120  47.336  11.098  1.00 11.54           C  
ATOM    261  N   ASP A 377     -23.661  51.764  11.376  1.00 13.66           N  
ATOM    262  CA  ASP A 377     -23.995  52.995  12.086  1.00 13.96           C  
ATOM    263  C   ASP A 377     -24.868  52.540  13.246  1.00 12.51           C  
ATOM    264  O   ASP A 377     -26.095  52.543  13.150  1.00 11.93           O  
ATOM    265  CB  ASP A 377     -24.784  53.954  11.190  1.00 16.76           C  
ATOM    266  CG  ASP A 377     -24.930  55.333  11.806  1.00 18.66           C  
ATOM    267  OD1 ASP A 377     -24.993  55.424  13.050  1.00 16.02           O  
ATOM    268  OD2 ASP A 377     -24.993  56.324  11.048  1.00 18.74           O  
ATOM    269  N   ALA A 378     -24.221  52.141  14.334  1.00 13.66           N  
ATOM    270  CA  ALA A 378     -24.913  51.636  15.513  1.00 13.93           C  
ATOM    271  C   ALA A 378     -26.021  52.545  16.027  1.00 15.35           C  
ATOM    272  O   ALA A 378     -27.148  52.100  16.232  1.00 15.69           O  
ATOM    273  CB  ALA A 378     -23.904  51.360  16.623  1.00 13.88           C  
ATOM    274  N   SER A 379     -25.698  53.817  16.235  1.00 16.61           N  
ATOM    275  CA  SER A 379     -26.677  54.775  16.740  1.00 18.80           C  
ATOM    276  C   SER A 379     -27.909  54.881  15.846  1.00 18.33           C  
ATOM    277  O   SER A 379     -29.044  54.815  16.324  1.00 18.60           O  
ATOM    278  CB  SER A 379     -26.030  56.154  16.886  1.00 21.30           C  
ATOM    279  OG  SER A 379     -24.927  56.098  17.772  1.00 24.28           O  
ATOM    280  N   ALA A 380     -27.684  55.046  14.548  1.00 18.23           N  
ATOM    281  CA  ALA A 380     -28.781  55.165  13.595  1.00 17.41           C  
ATOM    282  C   ALA A 380     -29.686  53.938  13.618  1.00 17.42           C  
ATOM    283  O   ALA A 380     -30.899  54.047  13.430  1.00 17.67           O  
ATOM    284  CB  ALA A 380     -28.224  55.381  12.190  1.00 19.17           C  
ATOM    285  N   LEU A 381     -29.095  52.771  13.861  1.00 15.50           N  
ATOM    286  CA  LEU A 381     -29.848  51.520  13.894  1.00 15.55           C  
ATOM    287  C   LEU A 381     -30.385  51.156  15.275  1.00 14.43           C  
ATOM    288  O   LEU A 381     -31.096  50.165  15.427  1.00 14.90           O  
ATOM    289  CB  LEU A 381     -28.970  50.387  13.366  1.00 16.32           C  
ATOM    290  CG  LEU A 381     -28.560  50.589  11.905  1.00 18.61           C  
ATOM    291  CD1 LEU A 381     -27.403  49.679  11.565  1.00 19.84           C  
ATOM    292  CD2 LEU A 381     -29.753  50.329  11.002  1.00 19.30           C  
ATOM    293  N   GLY A 382     -30.042  51.955  16.279  1.00 13.99           N  
ATOM    294  CA  GLY A 382     -30.512  51.682  17.627  1.00 13.56           C  
ATOM    295  C   GLY A 382     -29.773  50.542  18.306  1.00 13.69           C  
ATOM    296  O   GLY A 382     -30.249  49.997  19.303  1.00 15.03           O  
ATOM    297  N   LEU A 383     -28.608  50.185  17.772  1.00 12.44           N  
ATOM    298  CA  LEU A 383     -27.796  49.101  18.327  1.00 12.01           C  
ATOM    299  C   LEU A 383     -26.785  49.710  19.293  1.00 11.55           C  
ATOM    300  O   LEU A 383     -25.584  49.714  19.044  1.00 11.09           O  
ATOM    301  CB  LEU A 383     -27.071  48.362  17.197  1.00 12.25           C  
ATOM    302  CG  LEU A 383     -27.924  47.998  15.975  1.00 12.59           C  
ATOM    303  CD1 LEU A 383     -27.049  47.318  14.927  1.00 13.61           C  
ATOM    304  CD2 LEU A 383     -29.073  47.091  16.385  1.00 13.79           C  
ATOM    305  N   HIS A 384     -27.291  50.199  20.417  1.00 12.78           N  
ATOM    306  CA  HIS A 384     -26.462  50.866  21.413  1.00 12.03           C  
ATOM    307  C   HIS A 384     -25.438  50.022  22.159  1.00 12.03           C  
ATOM    308  O   HIS A 384     -24.641  50.555  22.933  1.00 12.20           O  
ATOM    309  CB  HIS A 384     -27.386  51.603  22.381  1.00 11.84           C  
ATOM    310  CG  HIS A 384     -28.354  52.505  21.683  1.00 13.80           C  
ATOM    311  ND1 HIS A 384     -27.944  53.530  20.857  1.00 14.22           N  
ATOM    312  CD2 HIS A 384     -29.706  52.494  21.625  1.00 14.15           C  
ATOM    313  CE1 HIS A 384     -29.001  54.109  20.318  1.00 14.74           C  
ATOM    314  NE2 HIS A 384     -30.084  53.500  20.768  1.00 13.82           N  
ATOM    315  N   ASP A 385     -25.442  48.715  21.914  1.00 10.29           N  
ATOM    316  CA  ASP A 385     -24.490  47.809  22.549  1.00  9.27           C  
ATOM    317  C   ASP A 385     -23.480  47.293  21.520  1.00  8.06           C  
ATOM    318  O   ASP A 385     -22.579  46.521  21.849  1.00 10.30           O  
ATOM    319  CB  ASP A 385     -25.233  46.624  23.184  1.00  9.66           C  
ATOM    320  CG  ASP A 385     -26.060  45.834  22.176  1.00 11.87           C  
ATOM    321  OD1 ASP A 385     -26.330  46.351  21.068  1.00 12.86           O  
ATOM    322  OD2 ASP A 385     -26.458  44.696  22.498  1.00 13.05           O  
ATOM    323  N   TYR A 386     -23.612  47.748  20.277  1.00  8.37           N  
ATOM    324  CA  TYR A 386     -22.731  47.287  19.209  1.00  9.32           C  
ATOM    325  C   TYR A 386     -21.241  47.457  19.480  1.00  9.58           C  
ATOM    326  O   TYR A 386     -20.464  46.516  19.336  1.00  8.70           O  
ATOM    327  CB  TYR A 386     -23.069  47.981  17.886  1.00  8.81           C  
ATOM    328  CG  TYR A 386     -22.391  47.329  16.702  1.00  8.90           C  
ATOM    329  CD1 TYR A 386     -22.859  46.120  16.187  1.00  9.70           C  
ATOM    330  CD2 TYR A 386     -21.248  47.889  16.132  1.00 10.09           C  
ATOM    331  CE1 TYR A 386     -22.199  45.481  15.133  1.00  9.88           C  
ATOM    332  CE2 TYR A 386     -20.582  47.256  15.081  1.00  9.64           C  
ATOM    333  CZ  TYR A 386     -21.062  46.054  14.591  1.00  9.60           C  
ATOM    334  OH  TYR A 386     -20.386  45.417  13.573  1.00  9.50           O  
ATOM    335  N   HIS A 387     -20.836  48.657  19.871  1.00  9.87           N  
ATOM    336  CA  HIS A 387     -19.425  48.904  20.116  1.00 10.95           C  
ATOM    337  C   HIS A 387     -18.897  48.357  21.438  1.00 11.89           C  
ATOM    338  O   HIS A 387     -17.704  48.446  21.727  1.00 12.21           O  
ATOM    339  CB  HIS A 387     -19.153  50.395  19.952  1.00 11.60           C  
ATOM    340  CG  HIS A 387     -19.385  50.877  18.553  1.00 12.71           C  
ATOM    341  ND1 HIS A 387     -18.583  50.496  17.498  1.00 11.35           N  
ATOM    342  CD2 HIS A 387     -20.366  51.645  18.021  1.00 11.96           C  
ATOM    343  CE1 HIS A 387     -19.062  51.005  16.376  1.00 12.18           C  
ATOM    344  NE2 HIS A 387     -20.143  51.706  16.666  1.00 12.24           N  
ATOM    345  N   ASP A 388     -19.784  47.775  22.236  1.00 11.09           N  
ATOM    346  CA  ASP A 388     -19.370  47.166  23.496  1.00 11.87           C  
ATOM    347  C   ASP A 388     -19.053  45.710  23.186  1.00 12.62           C  
ATOM    348  O   ASP A 388     -18.225  45.081  23.845  1.00 14.24           O  
ATOM    349  CB  ASP A 388     -20.500  47.220  24.523  1.00 11.43           C  
ATOM    350  CG  ASP A 388     -20.778  48.621  24.996  1.00 11.42           C  
ATOM    351  OD1 ASP A 388     -19.943  49.161  25.754  1.00 10.39           O  
ATOM    352  OD2 ASP A 388     -21.822  49.182  24.602  1.00 11.48           O  
ATOM    353  N   ILE A 389     -19.721  45.193  22.161  1.00 10.72           N  
ATOM    354  CA  ILE A 389     -19.564  43.806  21.736  1.00 11.38           C  
ATOM    355  C   ILE A 389     -18.541  43.628  20.612  1.00 10.44           C  
ATOM    356  O   ILE A 389     -17.772  42.665  20.616  1.00 11.33           O  
ATOM    357  CB  ILE A 389     -20.937  43.246  21.295  1.00 11.24           C  
ATOM    358  CG1 ILE A 389     -21.875  43.198  22.507  1.00 12.27           C  
ATOM    359  CG2 ILE A 389     -20.776  41.878  20.648  1.00 11.02           C  
ATOM    360  CD1 ILE A 389     -23.296  42.814  22.174  1.00 14.52           C  
ATOM    361  N   ILE A 390     -18.541  44.550  19.654  1.00 10.54           N  
ATOM    362  CA  ILE A 390     -17.612  44.506  18.525  1.00 10.34           C  
ATOM    363  C   ILE A 390     -16.476  45.497  18.775  1.00 11.72           C  
ATOM    364  O   ILE A 390     -16.658  46.711  18.661  1.00 12.69           O  
ATOM    365  CB  ILE A 390     -18.328  44.866  17.197  1.00 10.29           C  
ATOM    366  CG1 ILE A 390     -19.463  43.869  16.929  1.00  9.22           C  
ATOM    367  CG2 ILE A 390     -17.334  44.871  16.042  1.00 11.25           C  
ATOM    368  CD1 ILE A 390     -19.041  42.399  16.991  1.00  6.72           C  
ATOM    369  N   LYS A 391     -15.306  44.964  19.113  1.00 11.71           N  
ATOM    370  CA  LYS A 391     -14.128  45.774  19.410  1.00 14.87           C  
ATOM    371  C   LYS A 391     -13.433  46.328  18.173  1.00 14.55           C  
ATOM    372  O   LYS A 391     -12.829  47.403  18.221  1.00 13.64           O  
ATOM    373  CB  LYS A 391     -13.126  44.945  20.216  1.00 19.45           C  
ATOM    374  CG  LYS A 391     -11.824  45.668  20.542  1.00 24.64           C  
ATOM    375  CD  LYS A 391     -10.853  44.762  21.292  1.00 30.33           C  
ATOM    376  CE  LYS A 391     -11.445  44.261  22.604  1.00 31.99           C  
ATOM    377  NZ  LYS A 391     -11.855  45.374  23.509  1.00 35.13           N  
ATOM    378  N   HIS A 392     -13.516  45.591  17.071  1.00 12.20           N  
ATOM    379  CA  HIS A 392     -12.867  46.004  15.834  1.00 13.77           C  
ATOM    380  C   HIS A 392     -13.810  45.974  14.639  1.00 11.60           C  
ATOM    381  O   HIS A 392     -13.880  44.982  13.915  1.00 11.92           O  
ATOM    382  CB  HIS A 392     -11.660  45.102  15.565  1.00 17.04           C  
ATOM    383  CG  HIS A 392     -10.634  45.138  16.654  1.00 21.02           C  
ATOM    384  ND1 HIS A 392      -9.821  46.230  16.874  1.00 22.43           N  
ATOM    385  CD2 HIS A 392     -10.315  44.233  17.609  1.00 22.54           C  
ATOM    386  CE1 HIS A 392      -9.046  45.995  17.918  1.00 23.93           C  
ATOM    387  NE2 HIS A 392      -9.327  44.791  18.383  1.00 23.23           N  
ATOM    388  N   PRO A 393     -14.552  47.069  14.421  1.00 11.48           N  
ATOM    389  CA  PRO A 393     -15.488  47.144  13.297  1.00 10.04           C  
ATOM    390  C   PRO A 393     -14.754  47.071  11.961  1.00  9.66           C  
ATOM    391  O   PRO A 393     -13.607  47.515  11.842  1.00  9.34           O  
ATOM    392  CB  PRO A 393     -16.162  48.502  13.495  1.00 10.71           C  
ATOM    393  CG  PRO A 393     -16.084  48.713  14.978  1.00 11.96           C  
ATOM    394  CD  PRO A 393     -14.686  48.250  15.292  1.00 11.66           C  
ATOM    395  N   MET A 394     -15.418  46.503  10.964  1.00  8.70           N  
ATOM    396  CA  MET A 394     -14.847  46.394   9.628  1.00  8.14           C  
ATOM    397  C   MET A 394     -15.971  46.268   8.607  1.00  8.74           C  
ATOM    398  O   MET A 394     -17.020  45.686   8.886  1.00  8.92           O  
ATOM    399  CB  MET A 394     -13.914  45.181   9.538  1.00  8.82           C  
ATOM    400  CG  MET A 394     -13.150  45.072   8.217  1.00  8.45           C  
ATOM    401  SD  MET A 394     -12.254  46.584   7.755  1.00 10.22           S  
ATOM    402  CE  MET A 394     -11.214  46.833   9.204  1.00  9.70           C  
ATOM    403  N   ASP A 395     -15.749  46.834   7.425  1.00  8.30           N  
ATOM    404  CA  ASP A 395     -16.737  46.791   6.358  1.00  9.78           C  
ATOM    405  C   ASP A 395     -15.992  46.922   5.037  1.00  8.06           C  
ATOM    406  O   ASP A 395     -14.816  47.268   5.020  1.00  7.55           O  
ATOM    407  CB  ASP A 395     -17.727  47.943   6.502  1.00  9.13           C  
ATOM    408  CG  ASP A 395     -17.082  49.288   6.251  1.00 11.37           C  
ATOM    409  OD1 ASP A 395     -16.299  49.749   7.109  1.00 10.20           O  
ATOM    410  OD2 ASP A 395     -17.352  49.874   5.188  1.00  9.95           O  
ATOM    411  N   LEU A 396     -16.684  46.673   3.933  1.00  8.41           N  
ATOM    412  CA  LEU A 396     -16.050  46.740   2.626  1.00  8.66           C  
ATOM    413  C   LEU A 396     -15.508  48.106   2.202  1.00  8.90           C  
ATOM    414  O   LEU A 396     -14.508  48.168   1.488  1.00  9.37           O  
ATOM    415  CB  LEU A 396     -17.007  46.198   1.558  1.00  8.57           C  
ATOM    416  CG  LEU A 396     -17.369  44.716   1.728  1.00  9.46           C  
ATOM    417  CD1 LEU A 396     -18.415  44.326   0.693  1.00 10.74           C  
ATOM    418  CD2 LEU A 396     -16.122  43.844   1.594  1.00 10.37           C  
ATOM    419  N   SER A 397     -16.144  49.198   2.627  1.00  8.70           N  
ATOM    420  CA  SER A 397     -15.640  50.520   2.242  1.00 10.22           C  
ATOM    421  C   SER A 397     -14.302  50.784   2.923  1.00  9.73           C  
ATOM    422  O   SER A 397     -13.440  51.474   2.375  1.00  9.51           O  
ATOM    423  CB  SER A 397     -16.640  51.626   2.608  1.00 10.65           C  
ATOM    424  OG  SER A 397     -16.630  51.915   3.995  1.00 10.50           O  
ATOM    425  N   THR A 398     -14.125  50.226   4.117  1.00  9.69           N  
ATOM    426  CA  THR A 398     -12.877  50.400   4.852  1.00  9.86           C  
ATOM    427  C   THR A 398     -11.788  49.540   4.214  1.00  9.79           C  
ATOM    428  O   THR A 398     -10.631  49.955   4.109  1.00 11.00           O  
ATOM    429  CB  THR A 398     -13.054  50.023   6.336  1.00 10.02           C  
ATOM    430  OG1 THR A 398     -14.022  50.901   6.925  1.00 10.25           O  
ATOM    431  CG2 THR A 398     -11.735  50.159   7.092  1.00 12.95           C  
ATOM    432  N   VAL A 399     -12.167  48.341   3.784  1.00  8.47           N  
ATOM    433  CA  VAL A 399     -11.231  47.442   3.122  1.00  8.83           C  
ATOM    434  C   VAL A 399     -10.790  48.104   1.814  1.00  9.89           C  
ATOM    435  O   VAL A 399      -9.616  48.072   1.453  1.00 10.00           O  
ATOM    436  CB  VAL A 399     -11.897  46.075   2.804  1.00  8.43           C  
ATOM    437  CG1 VAL A 399     -10.946  45.194   2.000  1.00  7.74           C  
ATOM    438  CG2 VAL A 399     -12.278  45.373   4.098  1.00  9.00           C  
ATOM    439  N   LYS A 400     -11.739  48.715   1.109  1.00  8.96           N  
ATOM    440  CA  LYS A 400     -11.431  49.377  -0.153  1.00 11.13           C  
ATOM    441  C   LYS A 400     -10.458  50.532   0.075  1.00 11.82           C  
ATOM    442  O   LYS A 400      -9.491  50.699  -0.669  1.00 11.05           O  
ATOM    443  CB  LYS A 400     -12.715  49.894  -0.811  1.00 11.67           C  
ATOM    444  CG  LYS A 400     -12.498  50.570  -2.160  1.00 16.57           C  
ATOM    445  CD  LYS A 400     -13.828  50.876  -2.834  1.00 20.56           C  
ATOM    446  CE  LYS A 400     -13.642  51.650  -4.131  1.00 22.26           C  
ATOM    447  NZ  LYS A 400     -13.182  53.047  -3.885  1.00 23.93           N  
ATOM    448  N   ARG A 401     -10.712  51.328   1.109  1.00 11.48           N  
ATOM    449  CA  ARG A 401      -9.837  52.455   1.422  1.00 13.85           C  
ATOM    450  C   ARG A 401      -8.427  51.969   1.749  1.00 13.49           C  
ATOM    451  O   ARG A 401      -7.437  52.542   1.289  1.00 14.69           O  
ATOM    452  CB  ARG A 401     -10.392  53.249   2.608  1.00 16.18           C  
ATOM    453  CG  ARG A 401      -9.518  54.430   3.017  1.00 23.20           C  
ATOM    454  CD  ARG A 401     -10.089  55.156   4.224  1.00 27.94           C  
ATOM    455  NE  ARG A 401     -10.174  54.288   5.398  1.00 33.40           N  
ATOM    456  CZ  ARG A 401      -9.128  53.711   5.982  1.00 35.13           C  
ATOM    457  NH1 ARG A 401      -7.905  53.908   5.507  1.00 36.55           N  
ATOM    458  NH2 ARG A 401      -9.305  52.936   7.043  1.00 36.87           N  
ATOM    459  N   LYS A 402      -8.337  50.907   2.546  1.00 12.61           N  
ATOM    460  CA  LYS A 402      -7.041  50.361   2.927  1.00 11.93           C  
ATOM    461  C   LYS A 402      -6.296  49.799   1.714  1.00 13.45           C  
ATOM    462  O   LYS A 402      -5.071  49.898   1.625  1.00 13.06           O  
ATOM    463  CB  LYS A 402      -7.226  49.296   4.019  1.00 10.89           C  
ATOM    464  CG  LYS A 402      -7.707  49.904   5.345  1.00 12.00           C  
ATOM    465  CD  LYS A 402      -7.955  48.876   6.448  1.00 13.23           C  
ATOM    466  CE  LYS A 402      -6.676  48.200   6.911  1.00 15.82           C  
ATOM    467  NZ  LYS A 402      -6.931  47.343   8.108  1.00 15.17           N  
ATOM    468  N   MET A 403      -7.035  49.227   0.771  1.00 11.56           N  
ATOM    469  CA  MET A 403      -6.421  48.678  -0.434  1.00 12.76           C  
ATOM    470  C   MET A 403      -5.887  49.816  -1.303  1.00 13.22           C  
ATOM    471  O   MET A 403      -4.758  49.761  -1.791  1.00 13.51           O  
ATOM    472  CB  MET A 403      -7.448  47.857  -1.226  1.00 13.08           C  
ATOM    473  CG  MET A 403      -6.913  47.228  -2.505  1.00 16.07           C  
ATOM    474  SD  MET A 403      -5.663  45.955  -2.219  1.00 18.06           S  
ATOM    475  CE  MET A 403      -6.666  44.623  -1.606  1.00 19.78           C  
ATOM    476  N   GLU A 404      -6.697  50.856  -1.482  1.00 13.73           N  
ATOM    477  CA  GLU A 404      -6.299  51.998  -2.301  1.00 16.58           C  
ATOM    478  C   GLU A 404      -5.094  52.728  -1.708  1.00 17.84           C  
ATOM    479  O   GLU A 404      -4.239  53.228  -2.442  1.00 17.97           O  
ATOM    480  CB  GLU A 404      -7.470  52.971  -2.454  1.00 17.92           C  
ATOM    481  CG  GLU A 404      -8.739  52.316  -2.969  1.00 21.77           C  
ATOM    482  CD  GLU A 404      -9.897  53.286  -3.085  1.00 25.10           C  
ATOM    483  OE1 GLU A 404     -10.064  54.131  -2.178  1.00 26.03           O  
ATOM    484  OE2 GLU A 404     -10.648  53.189  -4.078  1.00 26.37           O  
ATOM    485  N   ASN A 405      -5.028  52.783  -0.381  1.00 16.24           N  
ATOM    486  CA  ASN A 405      -3.927  53.453   0.309  1.00 17.62           C  
ATOM    487  C   ASN A 405      -2.716  52.536   0.485  1.00 16.57           C  
ATOM    488  O   ASN A 405      -1.734  52.910   1.132  1.00 17.16           O  
ATOM    489  CB  ASN A 405      -4.393  53.952   1.683  1.00 19.39           C  
ATOM    490  CG  ASN A 405      -5.436  55.058   1.589  1.00 23.98           C  
ATOM    491  OD1 ASN A 405      -5.992  55.489   2.601  1.00 28.03           O  
ATOM    492  ND2 ASN A 405      -5.699  55.525   0.376  1.00 26.58           N  
ATOM    493  N   ARG A 406      -2.791  51.341  -0.094  1.00 15.62           N  
ATOM    494  CA  ARG A 406      -1.719  50.351  -0.006  1.00 16.48           C  
ATOM    495  C   ARG A 406      -1.388  50.013   1.446  1.00 18.25           C  
ATOM    496  O   ARG A 406      -0.227  49.834   1.812  1.00 17.34           O  
ATOM    497  CB  ARG A 406      -0.465  50.847  -0.737  1.00 19.80           C  
ATOM    498  CG  ARG A 406      -0.606  50.828  -2.255  1.00 23.65           C  
ATOM    499  CD  ARG A 406       0.701  51.167  -2.959  1.00 27.26           C  
ATOM    500  NE  ARG A 406       1.026  52.588  -2.878  1.00 31.72           N  
ATOM    501  CZ  ARG A 406       2.116  53.136  -3.409  1.00 32.46           C  
ATOM    502  NH1 ARG A 406       2.992  52.380  -4.061  1.00 32.53           N  
ATOM    503  NH2 ARG A 406       2.327  54.439  -3.297  1.00 32.73           N  
ATOM    504  N   ASP A 407      -2.427  49.915   2.267  1.00 15.97           N  
ATOM    505  CA  ASP A 407      -2.260  49.593   3.676  1.00 15.81           C  
ATOM    506  C   ASP A 407      -1.936  48.105   3.823  1.00 16.22           C  
ATOM    507  O   ASP A 407      -1.085  47.725   4.623  1.00 16.89           O  
ATOM    508  CB  ASP A 407      -3.537  49.959   4.438  1.00 16.14           C  
ATOM    509  CG  ASP A 407      -3.353  49.939   5.943  1.00 19.86           C  
ATOM    510  OD1 ASP A 407      -3.957  50.797   6.624  1.00 18.67           O  
ATOM    511  OD2 ASP A 407      -2.620  49.063   6.445  1.00 23.88           O  
ATOM    512  N   TYR A 408      -2.599  47.266   3.032  1.00 15.00           N  
ATOM    513  CA  TYR A 408      -2.352  45.827   3.091  1.00 13.71           C  
ATOM    514  C   TYR A 408      -1.016  45.506   2.435  1.00 15.44           C  
ATOM    515  O   TYR A 408      -0.763  45.904   1.299  1.00 16.26           O  
ATOM    516  CB  TYR A 408      -3.461  45.056   2.369  1.00 13.02           C  
ATOM    517  CG  TYR A 408      -4.831  45.266   2.968  1.00 11.74           C  
ATOM    518  CD1 TYR A 408      -5.073  44.977   4.308  1.00  9.60           C  
ATOM    519  CD2 TYR A 408      -5.883  45.759   2.196  1.00 11.11           C  
ATOM    520  CE1 TYR A 408      -6.329  45.175   4.871  1.00 11.02           C  
ATOM    521  CE2 TYR A 408      -7.147  45.961   2.753  1.00 11.44           C  
ATOM    522  CZ  TYR A 408      -7.361  45.668   4.088  1.00 10.23           C  
ATOM    523  OH  TYR A 408      -8.606  45.857   4.648  1.00  9.79           O  
ATOM    524  N   ARG A 409      -0.161  44.784   3.146  1.00 15.95           N  
ATOM    525  CA  ARG A 409       1.136  44.427   2.591  1.00 17.87           C  
ATOM    526  C   ARG A 409       1.114  43.056   1.927  1.00 17.59           C  
ATOM    527  O   ARG A 409       1.987  42.735   1.124  1.00 17.37           O  
ATOM    528  CB  ARG A 409       2.209  44.465   3.678  1.00 18.70           C  
ATOM    529  CG  ARG A 409       2.461  45.854   4.243  1.00 21.41           C  
ATOM    530  CD  ARG A 409       3.767  45.865   5.008  1.00 23.21           C  
ATOM    531  NE  ARG A 409       4.876  45.481   4.140  1.00 25.46           N  
ATOM    532  CZ  ARG A 409       5.957  44.830   4.555  1.00 27.50           C  
ATOM    533  NH1 ARG A 409       6.076  44.487   5.830  1.00 29.58           N  
ATOM    534  NH2 ARG A 409       6.917  44.521   3.694  1.00 28.77           N  
ATOM    535  N   ASP A 410       0.117  42.245   2.261  1.00 18.02           N  
ATOM    536  CA  ASP A 410       0.008  40.921   1.664  1.00 18.03           C  
ATOM    537  C   ASP A 410      -1.441  40.449   1.671  1.00 16.61           C  
ATOM    538  O   ASP A 410      -2.304  41.074   2.288  1.00 15.23           O  
ATOM    539  CB  ASP A 410       0.885  39.919   2.419  1.00 21.11           C  
ATOM    540  CG  ASP A 410       0.165  39.274   3.580  1.00 24.24           C  
ATOM    541  OD1 ASP A 410      -0.311  40.004   4.471  1.00 22.20           O  
ATOM    542  OD2 ASP A 410       0.070  38.028   3.593  1.00 30.54           O  
ATOM    543  N   ALA A 411      -1.699  39.340   0.988  1.00 15.42           N  
ATOM    544  CA  ALA A 411      -3.045  38.785   0.899  1.00 14.02           C  
ATOM    545  C   ALA A 411      -3.642  38.402   2.256  1.00 14.57           C  
ATOM    546  O   ALA A 411      -4.834  38.600   2.493  1.00 10.91           O  
ATOM    547  CB  ALA A 411      -3.038  37.574  -0.026  1.00 16.02           C  
ATOM    548  N   GLN A 412      -2.815  37.848   3.140  1.00 13.66           N  
ATOM    549  CA  GLN A 412      -3.274  37.433   4.466  1.00 16.39           C  
ATOM    550  C   GLN A 412      -3.903  38.578   5.253  1.00 15.22           C  
ATOM    551  O   GLN A 412      -4.921  38.391   5.919  1.00 15.60           O  
ATOM    552  CB  GLN A 412      -2.111  36.847   5.269  1.00 19.94           C  
ATOM    553  CG  GLN A 412      -1.502  35.601   4.664  1.00 26.70           C  
ATOM    554  CD  GLN A 412      -0.271  35.141   5.420  1.00 31.00           C  
ATOM    555  OE1 GLN A 412       0.717  35.871   5.524  1.00 35.39           O  
ATOM    556  NE2 GLN A 412      -0.322  33.926   5.953  1.00 34.85           N  
ATOM    557  N   GLU A 413      -3.287  39.753   5.186  1.00 13.59           N  
ATOM    558  CA  GLU A 413      -3.794  40.936   5.878  1.00 13.99           C  
ATOM    559  C   GLU A 413      -5.190  41.277   5.383  1.00 12.95           C  
ATOM    560  O   GLU A 413      -6.095  41.549   6.168  1.00 12.48           O  
ATOM    561  CB  GLU A 413      -2.911  42.146   5.602  1.00 16.48           C  
ATOM    562  CG  GLU A 413      -1.888  42.480   6.651  1.00 23.39           C  
ATOM    563  CD  GLU A 413      -1.408  43.912   6.505  1.00 22.67           C  
ATOM    564  OE1 GLU A 413      -2.094  44.827   7.016  1.00 25.93           O  
ATOM    565  OE2 GLU A 413      -0.364  44.123   5.861  1.00 26.04           O  
ATOM    566  N   PHE A 414      -5.329  41.306   4.063  1.00 12.67           N  
ATOM    567  CA  PHE A 414      -6.596  41.609   3.410  1.00 10.45           C  
ATOM    568  C   PHE A 414      -7.657  40.605   3.836  1.00 11.06           C  
ATOM    569  O   PHE A 414      -8.750  40.984   4.251  1.00  9.67           O  
ATOM    570  CB  PHE A 414      -6.402  41.555   1.890  1.00 10.57           C  
ATOM    571  CG  PHE A 414      -7.685  41.496   1.103  1.00  9.73           C  
ATOM    572  CD1 PHE A 414      -8.411  42.650   0.829  1.00  8.09           C  
ATOM    573  CD2 PHE A 414      -8.140  40.285   0.593  1.00 11.73           C  
ATOM    574  CE1 PHE A 414      -9.573  42.601   0.049  1.00 10.71           C  
ATOM    575  CE2 PHE A 414      -9.301  40.224  -0.186  1.00 11.85           C  
ATOM    576  CZ  PHE A 414     -10.015  41.383  -0.459  1.00  9.44           C  
ATOM    577  N   ALA A 415      -7.324  39.322   3.731  1.00 10.16           N  
ATOM    578  CA  ALA A 415      -8.256  38.256   4.091  1.00 10.34           C  
ATOM    579  C   ALA A 415      -8.716  38.374   5.540  1.00 11.08           C  
ATOM    580  O   ALA A 415      -9.878  38.127   5.852  1.00  8.77           O  
ATOM    581  CB  ALA A 415      -7.602  36.894   3.857  1.00 12.42           C  
ATOM    582  N   ALA A 416      -7.796  38.749   6.425  1.00 10.31           N  
ATOM    583  CA  ALA A 416      -8.124  38.896   7.840  1.00 10.19           C  
ATOM    584  C   ALA A 416      -9.204  39.957   8.068  1.00  9.84           C  
ATOM    585  O   ALA A 416     -10.086  39.777   8.913  1.00 11.34           O  
ATOM    586  CB  ALA A 416      -6.868  39.246   8.631  1.00 11.40           C  
ATOM    587  N   ASP A 417      -9.138  41.063   7.328  1.00  9.49           N  
ATOM    588  CA  ASP A 417     -10.139  42.120   7.474  1.00  9.13           C  
ATOM    589  C   ASP A 417     -11.490  41.671   6.921  1.00  8.33           C  
ATOM    590  O   ASP A 417     -12.531  41.943   7.514  1.00  7.74           O  
ATOM    591  CB  ASP A 417      -9.705  43.404   6.755  1.00 10.70           C  
ATOM    592  CG  ASP A 417      -8.897  44.332   7.645  1.00 14.33           C  
ATOM    593  OD1 ASP A 417      -8.800  44.067   8.864  1.00 14.40           O  
ATOM    594  OD2 ASP A 417      -8.370  45.338   7.126  1.00 16.04           O  
ATOM    595  N   VAL A 418     -11.479  40.988   5.782  1.00  8.59           N  
ATOM    596  CA  VAL A 418     -12.732  40.525   5.205  1.00  7.65           C  
ATOM    597  C   VAL A 418     -13.401  39.541   6.162  1.00  8.71           C  
ATOM    598  O   VAL A 418     -14.603  39.615   6.397  1.00  9.20           O  
ATOM    599  CB  VAL A 418     -12.510  39.851   3.831  1.00  8.27           C  
ATOM    600  CG1 VAL A 418     -13.826  39.266   3.310  1.00  7.10           C  
ATOM    601  CG2 VAL A 418     -11.980  40.881   2.836  1.00  7.12           C  
ATOM    602  N   ARG A 419     -12.618  38.626   6.725  1.00  9.60           N  
ATOM    603  CA  ARG A 419     -13.165  37.648   7.654  1.00  9.10           C  
ATOM    604  C   ARG A 419     -13.588  38.285   8.971  1.00  9.05           C  
ATOM    605  O   ARG A 419     -14.528  37.823   9.607  1.00  9.64           O  
ATOM    606  CB  ARG A 419     -12.150  36.532   7.892  1.00 10.13           C  
ATOM    607  CG  ARG A 419     -12.065  35.591   6.713  1.00 11.88           C  
ATOM    608  CD  ARG A 419     -10.776  34.817   6.699  1.00 14.30           C  
ATOM    609  NE  ARG A 419     -10.733  33.872   5.587  1.00 12.59           N  
ATOM    610  CZ  ARG A 419      -9.618  33.303   5.147  1.00 13.87           C  
ATOM    611  NH1 ARG A 419      -8.458  33.592   5.724  1.00 16.38           N  
ATOM    612  NH2 ARG A 419      -9.664  32.438   4.141  1.00 11.96           N  
ATOM    613  N   LEU A 420     -12.898  39.345   9.377  1.00  9.91           N  
ATOM    614  CA  LEU A 420     -13.240  40.044  10.614  1.00  8.88           C  
ATOM    615  C   LEU A 420     -14.643  40.626  10.449  1.00  8.88           C  
ATOM    616  O   LEU A 420     -15.465  40.586  11.363  1.00  8.58           O  
ATOM    617  CB  LEU A 420     -12.238  41.174  10.874  1.00  9.46           C  
ATOM    618  CG  LEU A 420     -12.582  42.200  11.959  1.00 11.36           C  
ATOM    619  CD1 LEU A 420     -12.726  41.512  13.311  1.00 10.88           C  
ATOM    620  CD2 LEU A 420     -11.492  43.261  12.008  1.00  9.27           C  
ATOM    621  N   MET A 421     -14.894  41.180   9.268  1.00  7.15           N  
ATOM    622  CA  MET A 421     -16.185  41.768   8.940  1.00  7.49           C  
ATOM    623  C   MET A 421     -17.299  40.734   9.113  1.00  7.82           C  
ATOM    624  O   MET A 421     -18.338  41.022   9.716  1.00  7.75           O  
ATOM    625  CB  MET A 421     -16.155  42.280   7.496  1.00  8.65           C  
ATOM    626  CG  MET A 421     -17.440  42.916   7.007  1.00  9.12           C  
ATOM    627  SD  MET A 421     -17.309  43.332   5.258  1.00  9.78           S  
ATOM    628  CE  MET A 421     -17.355  41.665   4.525  1.00 10.55           C  
ATOM    629  N   PHE A 422     -17.087  39.529   8.589  1.00  7.03           N  
ATOM    630  CA  PHE A 422     -18.092  38.476   8.707  1.00  6.96           C  
ATOM    631  C   PHE A 422     -18.202  38.000  10.150  1.00  7.40           C  
ATOM    632  O   PHE A 422     -19.302  37.794  10.660  1.00  8.64           O  
ATOM    633  CB  PHE A 422     -17.759  37.288   7.795  1.00  7.46           C  
ATOM    634  CG  PHE A 422     -17.851  37.602   6.330  1.00  8.60           C  
ATOM    635  CD1 PHE A 422     -18.973  38.244   5.813  1.00 10.59           C  
ATOM    636  CD2 PHE A 422     -16.819  37.255   5.461  1.00  9.74           C  
ATOM    637  CE1 PHE A 422     -19.069  38.538   4.451  1.00 10.04           C  
ATOM    638  CE2 PHE A 422     -16.904  37.544   4.098  1.00  9.46           C  
ATOM    639  CZ  PHE A 422     -18.032  38.188   3.595  1.00  9.80           C  
ATOM    640  N   SER A 423     -17.062  37.837  10.813  1.00  8.07           N  
ATOM    641  CA  SER A 423     -17.063  37.391  12.202  1.00  7.86           C  
ATOM    642  C   SER A 423     -17.842  38.355  13.090  1.00  8.20           C  
ATOM    643  O   SER A 423     -18.574  37.929  13.986  1.00  7.84           O  
ATOM    644  CB  SER A 423     -15.630  37.253  12.723  1.00  7.82           C  
ATOM    645  OG  SER A 423     -14.940  36.227  12.029  1.00  9.62           O  
ATOM    646  N   ASN A 424     -17.687  39.654  12.847  1.00  7.61           N  
ATOM    647  CA  ASN A 424     -18.403  40.645  13.649  1.00  8.88           C  
ATOM    648  C   ASN A 424     -19.907  40.433  13.508  1.00  8.01           C  
ATOM    649  O   ASN A 424     -20.659  40.563  14.472  1.00  7.06           O  
ATOM    650  CB  ASN A 424     -18.046  42.068  13.210  1.00  9.86           C  
ATOM    651  CG  ASN A 424     -16.650  42.476  13.634  1.00 10.17           C  
ATOM    652  OD1 ASN A 424     -16.074  41.897  14.560  1.00  8.74           O  
ATOM    653  ND2 ASN A 424     -16.106  43.491  12.972  1.00 10.34           N  
ATOM    654  N   CYS A 425     -20.336  40.096  12.297  1.00  6.80           N  
ATOM    655  CA  CYS A 425     -21.747  39.853  12.030  1.00  8.31           C  
ATOM    656  C   CYS A 425     -22.239  38.618  12.794  1.00  9.06           C  
ATOM    657  O   CYS A 425     -23.316  38.642  13.390  1.00  9.83           O  
ATOM    658  CB  CYS A 425     -21.965  39.670  10.524  1.00  8.19           C  
ATOM    659  SG  CYS A 425     -23.695  39.469  10.016  1.00 10.57           S  
ATOM    660  N   TYR A 426     -21.449  37.546  12.776  1.00  7.90           N  
ATOM    661  CA  TYR A 426     -21.819  36.311  13.465  1.00  8.62           C  
ATOM    662  C   TYR A 426     -21.778  36.464  14.983  1.00 10.98           C  
ATOM    663  O   TYR A 426     -22.500  35.775  15.704  1.00 10.59           O  
ATOM    664  CB  TYR A 426     -20.883  35.160  13.072  1.00 10.68           C  
ATOM    665  CG  TYR A 426     -20.747  34.917  11.584  1.00  8.98           C  
ATOM    666  CD1 TYR A 426     -21.849  35.014  10.734  1.00 10.45           C  
ATOM    667  CD2 TYR A 426     -19.514  34.561  11.030  1.00 10.09           C  
ATOM    668  CE1 TYR A 426     -21.724  34.763   9.362  1.00 11.65           C  
ATOM    669  CE2 TYR A 426     -19.381  34.305   9.663  1.00 10.17           C  
ATOM    670  CZ  TYR A 426     -20.489  34.410   8.837  1.00 11.34           C  
ATOM    671  OH  TYR A 426     -20.362  34.169   7.488  1.00 12.86           O  
ATOM    672  N   LYS A 427     -20.922  37.359  15.463  1.00 10.59           N  
ATOM    673  CA  LYS A 427     -20.783  37.587  16.894  1.00 10.08           C  
ATOM    674  C   LYS A 427     -21.926  38.415  17.462  1.00  9.91           C  
ATOM    675  O   LYS A 427     -22.481  38.082  18.507  1.00  9.63           O  
ATOM    676  CB  LYS A 427     -19.452  38.292  17.179  1.00 12.05           C  
ATOM    677  CG  LYS A 427     -19.208  38.615  18.643  1.00 16.02           C  
ATOM    678  CD  LYS A 427     -17.890  39.356  18.826  1.00 18.94           C  
ATOM    679  CE  LYS A 427     -17.561  39.534  20.297  1.00 23.10           C  
ATOM    680  NZ  LYS A 427     -17.456  38.215  20.985  1.00 28.15           N  
ATOM    681  N   TYR A 428     -22.288  39.488  16.765  1.00 10.04           N  
ATOM    682  CA  TYR A 428     -23.344  40.373  17.244  1.00 10.51           C  
ATOM    683  C   TYR A 428     -24.779  39.890  17.045  1.00 11.97           C  
ATOM    684  O   TYR A 428     -25.617  40.021  17.944  1.00 12.45           O  
ATOM    685  CB  TYR A 428     -23.214  41.753  16.587  1.00 10.51           C  
ATOM    686  CG  TYR A 428     -24.201  42.757  17.138  1.00  9.34           C  
ATOM    687  CD1 TYR A 428     -24.007  43.332  18.392  1.00  9.56           C  
ATOM    688  CD2 TYR A 428     -25.361  43.087  16.432  1.00  9.40           C  
ATOM    689  CE1 TYR A 428     -24.945  44.207  18.938  1.00  9.02           C  
ATOM    690  CE2 TYR A 428     -26.309  43.960  16.971  1.00 10.17           C  
ATOM    691  CZ  TYR A 428     -26.092  44.512  18.223  1.00  9.34           C  
ATOM    692  OH  TYR A 428     -27.034  45.348  18.772  1.00 10.08           O  
ATOM    693  N   ASN A 429     -25.056  39.333  15.871  1.00 12.41           N  
ATOM    694  CA  ASN A 429     -26.402  38.891  15.514  1.00 14.17           C  
ATOM    695  C   ASN A 429     -26.776  37.446  15.818  1.00 16.89           C  
ATOM    696  O   ASN A 429     -25.931  36.555  15.797  1.00 16.63           O  
ATOM    697  CB  ASN A 429     -26.619  39.131  14.020  1.00 15.07           C  
ATOM    698  CG  ASN A 429     -26.400  40.572  13.629  1.00 15.35           C  
ATOM    699  OD1 ASN A 429     -27.244  41.429  13.881  1.00 15.38           O  
ATOM    700  ND2 ASN A 429     -25.253  40.851  13.020  1.00 13.12           N  
ATOM    701  N   PRO A 430     -28.065  37.205  16.119  1.00 19.16           N  
ATOM    702  CA  PRO A 430     -28.535  35.848  16.410  1.00 19.71           C  
ATOM    703  C   PRO A 430     -28.370  35.053  15.116  1.00 20.22           C  
ATOM    704  O   PRO A 430     -28.499  35.608  14.024  1.00 18.62           O  
ATOM    705  CB  PRO A 430     -30.001  36.061  16.771  1.00 20.33           C  
ATOM    706  CG  PRO A 430     -29.990  37.418  17.402  1.00 21.47           C  
ATOM    707  CD  PRO A 430     -29.097  38.198  16.465  1.00 19.71           C  
ATOM    708  N   PRO A 431     -28.091  33.746  15.222  1.00 21.61           N  
ATOM    709  CA  PRO A 431     -27.900  32.861  14.066  1.00 22.50           C  
ATOM    710  C   PRO A 431     -29.034  32.848  13.044  1.00 22.81           C  
ATOM    711  O   PRO A 431     -28.818  32.502  11.885  1.00 23.63           O  
ATOM    712  CB  PRO A 431     -27.709  31.489  14.710  1.00 23.91           C  
ATOM    713  CG  PRO A 431     -27.105  31.816  16.034  1.00 24.06           C  
ATOM    714  CD  PRO A 431     -27.923  32.998  16.480  1.00 22.80           C  
ATOM    715  N   ASP A 432     -30.235  33.226  13.473  1.00 24.03           N  
ATOM    716  CA  ASP A 432     -31.398  33.220  12.590  1.00 25.24           C  
ATOM    717  C   ASP A 432     -31.713  34.563  11.937  1.00 24.27           C  
ATOM    718  O   ASP A 432     -32.678  34.674  11.181  1.00 22.95           O  
ATOM    719  CB  ASP A 432     -32.631  32.746  13.366  1.00 30.61           C  
ATOM    720  CG  ASP A 432     -32.360  31.501  14.185  1.00 35.32           C  
ATOM    721  OD1 ASP A 432     -31.943  30.479  13.599  1.00 39.73           O  
ATOM    722  OD2 ASP A 432     -32.563  31.543  15.418  1.00 38.82           O  
ATOM    723  N   HIS A 433     -30.907  35.581  12.223  1.00 21.51           N  
ATOM    724  CA  HIS A 433     -31.140  36.906  11.655  1.00 19.91           C  
ATOM    725  C   HIS A 433     -30.856  36.898  10.153  1.00 19.28           C  
ATOM    726  O   HIS A 433     -29.936  36.226   9.693  1.00 16.83           O  
ATOM    727  CB  HIS A 433     -30.249  37.939  12.352  1.00 20.78           C  
ATOM    728  CG  HIS A 433     -30.669  39.357  12.121  1.00 23.91           C  
ATOM    729  ND1 HIS A 433     -30.743  39.919  10.864  1.00 23.67           N  
ATOM    730  CD2 HIS A 433     -31.039  40.328  12.990  1.00 24.55           C  
ATOM    731  CE1 HIS A 433     -31.141  41.174  10.969  1.00 25.27           C  
ATOM    732  NE2 HIS A 433     -31.327  41.448  12.248  1.00 25.34           N  
ATOM    733  N   ASP A 434     -31.653  37.641   9.393  1.00 18.65           N  
ATOM    734  CA  ASP A 434     -31.478  37.706   7.946  1.00 17.74           C  
ATOM    735  C   ASP A 434     -30.090  38.191   7.543  1.00 17.65           C  
ATOM    736  O   ASP A 434     -29.546  37.752   6.532  1.00 16.40           O  
ATOM    737  CB  ASP A 434     -32.536  38.623   7.326  1.00 22.08           C  
ATOM    738  CG  ASP A 434     -33.948  38.107   7.535  1.00 26.83           C  
ATOM    739  OD1 ASP A 434     -34.234  36.969   7.109  1.00 29.17           O  
ATOM    740  OD2 ASP A 434     -34.771  38.839   8.125  1.00 31.85           O  
ATOM    741  N   VAL A 435     -29.517  39.096   8.330  1.00 15.83           N  
ATOM    742  CA  VAL A 435     -28.193  39.625   8.009  1.00 14.88           C  
ATOM    743  C   VAL A 435     -27.125  38.537   8.067  1.00 12.47           C  
ATOM    744  O   VAL A 435     -26.139  38.587   7.330  1.00 11.07           O  
ATOM    745  CB  VAL A 435     -27.798  40.776   8.961  1.00 15.74           C  
ATOM    746  CG1 VAL A 435     -28.816  41.897   8.858  1.00 19.60           C  
ATOM    747  CG2 VAL A 435     -27.696  40.269  10.389  1.00 16.30           C  
ATOM    748  N   VAL A 436     -27.324  37.558   8.944  1.00 11.50           N  
ATOM    749  CA  VAL A 436     -26.375  36.453   9.072  1.00 12.51           C  
ATOM    750  C   VAL A 436     -26.450  35.571   7.828  1.00 12.21           C  
ATOM    751  O   VAL A 436     -25.435  35.053   7.356  1.00 11.96           O  
ATOM    752  CB  VAL A 436     -26.673  35.596  10.330  1.00 12.14           C  
ATOM    753  CG1 VAL A 436     -25.841  34.318  10.308  1.00 14.34           C  
ATOM    754  CG2 VAL A 436     -26.366  36.395  11.586  1.00 12.55           C  
ATOM    755  N   ALA A 437     -27.658  35.401   7.299  1.00 13.05           N  
ATOM    756  CA  ALA A 437     -27.858  34.594   6.100  1.00 12.14           C  
ATOM    757  C   ALA A 437     -27.126  35.244   4.928  1.00 12.28           C  
ATOM    758  O   ALA A 437     -26.513  34.560   4.109  1.00 12.82           O  
ATOM    759  CB  ALA A 437     -29.347  34.478   5.790  1.00 13.30           C  
ATOM    760  N   MET A 438     -27.196  36.569   4.860  1.00 11.91           N  
ATOM    761  CA  MET A 438     -26.535  37.325   3.803  1.00 11.15           C  
ATOM    762  C   MET A 438     -25.019  37.256   3.964  1.00 10.72           C  
ATOM    763  O   MET A 438     -24.287  37.172   2.976  1.00 10.87           O  
ATOM    764  CB  MET A 438     -27.001  38.781   3.831  1.00 12.36           C  
ATOM    765  CG  MET A 438     -28.475  38.955   3.508  1.00 15.29           C  
ATOM    766  SD  MET A 438     -29.048  40.638   3.798  1.00 22.18           S  
ATOM    767  CE  MET A 438     -28.787  41.354   2.258  1.00 22.65           C  
ATOM    768  N   ALA A 439     -24.550  37.287   5.208  1.00 11.07           N  
ATOM    769  CA  ALA A 439     -23.117  37.209   5.482  1.00 10.17           C  
ATOM    770  C   ALA A 439     -22.563  35.863   5.016  1.00 10.84           C  
ATOM    771  O   ALA A 439     -21.499  35.799   4.390  1.00  8.48           O  
ATOM    772  CB  ALA A 439     -22.852  37.394   6.976  1.00 11.11           C  
ATOM    773  N   ARG A 440     -23.283  34.784   5.315  1.00 11.95           N  
ATOM    774  CA  ARG A 440     -22.830  33.453   4.918  1.00 13.15           C  
ATOM    775  C   ARG A 440     -22.714  33.327   3.404  1.00 13.28           C  
ATOM    776  O   ARG A 440     -21.760  32.734   2.895  1.00 13.01           O  
ATOM    777  CB  ARG A 440     -23.767  32.373   5.476  1.00 15.80           C  
ATOM    778  CG  ARG A 440     -23.698  32.244   6.993  1.00 19.67           C  
ATOM    779  CD  ARG A 440     -24.435  31.019   7.520  1.00 25.36           C  
ATOM    780  NE  ARG A 440     -25.865  31.044   7.227  1.00 32.88           N  
ATOM    781  CZ  ARG A 440     -26.422  30.496   6.151  1.00 35.52           C  
ATOM    782  NH1 ARG A 440     -25.670  29.872   5.253  1.00 38.13           N  
ATOM    783  NH2 ARG A 440     -27.733  30.572   5.972  1.00 38.00           N  
ATOM    784  N   LYS A 441     -23.680  33.893   2.686  1.00 13.06           N  
ATOM    785  CA  LYS A 441     -23.672  33.846   1.228  1.00 12.56           C  
ATOM    786  C   LYS A 441     -22.508  34.648   0.653  1.00 11.05           C  
ATOM    787  O   LYS A 441     -21.808  34.186  -0.251  1.00  9.88           O  
ATOM    788  CB  LYS A 441     -24.996  34.381   0.675  1.00 14.61           C  
ATOM    789  CG  LYS A 441     -26.165  33.440   0.899  1.00 16.89           C  
ATOM    790  CD  LYS A 441     -27.507  34.096   0.593  1.00 18.56           C  
ATOM    791  CE  LYS A 441     -27.651  34.448  -0.875  1.00 19.39           C  
ATOM    792  NZ  LYS A 441     -29.028  34.933  -1.159  1.00 18.85           N  
ATOM    793  N   LEU A 442     -22.295  35.849   1.176  1.00 10.29           N  
ATOM    794  CA  LEU A 442     -21.199  36.671   0.678  1.00  8.86           C  
ATOM    795  C   LEU A 442     -19.858  36.055   1.067  1.00  9.45           C  
ATOM    796  O   LEU A 442     -18.888  36.145   0.316  1.00  8.54           O  
ATOM    797  CB  LEU A 442     -21.294  38.101   1.220  1.00  9.32           C  
ATOM    798  CG  LEU A 442     -20.346  39.093   0.530  1.00 10.88           C  
ATOM    799  CD1 LEU A 442     -20.754  39.259  -0.937  1.00 11.37           C  
ATOM    800  CD2 LEU A 442     -20.386  40.436   1.243  1.00 10.32           C  
ATOM    801  N   GLN A 443     -19.795  35.422   2.236  1.00  9.70           N  
ATOM    802  CA  GLN A 443     -18.544  34.805   2.661  1.00 10.36           C  
ATOM    803  C   GLN A 443     -18.213  33.606   1.782  1.00 10.98           C  
ATOM    804  O   GLN A 443     -17.047  33.322   1.532  1.00 10.80           O  
ATOM    805  CB  GLN A 443     -18.602  34.373   4.131  1.00 10.95           C  
ATOM    806  CG  GLN A 443     -17.360  33.599   4.574  1.00 11.71           C  
ATOM    807  CD  GLN A 443     -16.978  33.839   6.026  1.00 12.84           C  
ATOM    808  OE1 GLN A 443     -17.832  33.882   6.907  1.00 12.35           O  
ATOM    809  NE2 GLN A 443     -15.681  33.982   6.279  1.00 14.32           N  
ATOM    810  N   ASP A 444     -19.242  32.905   1.314  1.00 10.84           N  
ATOM    811  CA  ASP A 444     -19.022  31.758   0.446  1.00 13.84           C  
ATOM    812  C   ASP A 444     -18.389  32.276  -0.842  1.00 11.80           C  
ATOM    813  O   ASP A 444     -17.444  31.683  -1.361  1.00 10.71           O  
ATOM    814  CB  ASP A 444     -20.348  31.041   0.156  1.00 16.94           C  
ATOM    815  CG  ASP A 444     -20.167  29.804  -0.709  1.00 23.41           C  
ATOM    816  OD1 ASP A 444     -20.092  29.952  -1.947  1.00 27.03           O  
ATOM    817  OD2 ASP A 444     -20.088  28.687  -0.152  1.00 26.23           O  
ATOM    818  N   VAL A 445     -18.905  33.397  -1.341  1.00 10.20           N  
ATOM    819  CA  VAL A 445     -18.367  34.007  -2.552  1.00  9.77           C  
ATOM    820  C   VAL A 445     -16.890  34.325  -2.325  1.00 10.29           C  
ATOM    821  O   VAL A 445     -16.037  34.019  -3.158  1.00  9.76           O  
ATOM    822  CB  VAL A 445     -19.110  35.320  -2.901  1.00 10.18           C  
ATOM    823  CG1 VAL A 445     -18.403  36.040  -4.045  1.00 10.12           C  
ATOM    824  CG2 VAL A 445     -20.553  35.015  -3.288  1.00 11.47           C  
ATOM    825  N   PHE A 446     -16.593  34.932  -1.182  1.00  8.06           N  
ATOM    826  CA  PHE A 446     -15.224  35.295  -0.846  1.00  7.41           C  
ATOM    827  C   PHE A 446     -14.271  34.108  -0.684  1.00  8.35           C  
ATOM    828  O   PHE A 446     -13.198  34.082  -1.284  1.00  7.84           O  
ATOM    829  CB  PHE A 446     -15.192  36.114   0.447  1.00  8.64           C  
ATOM    830  CG  PHE A 446     -13.807  36.323   0.988  1.00  9.99           C  
ATOM    831  CD1 PHE A 446     -12.924  37.198   0.363  1.00 12.84           C  
ATOM    832  CD2 PHE A 446     -13.364  35.597   2.090  1.00 10.60           C  
ATOM    833  CE1 PHE A 446     -11.613  37.346   0.827  1.00 10.75           C  
ATOM    834  CE2 PHE A 446     -12.059  35.738   2.559  1.00 11.29           C  
ATOM    835  CZ  PHE A 446     -11.183  36.614   1.925  1.00 10.85           C  
ATOM    836  N   GLU A 447     -14.650  33.145   0.150  1.00  7.26           N  
ATOM    837  CA  GLU A 447     -13.796  31.989   0.400  1.00  7.15           C  
ATOM    838  C   GLU A 447     -13.461  31.196  -0.861  1.00  7.05           C  
ATOM    839  O   GLU A 447     -12.310  30.815  -1.077  1.00  7.92           O  
ATOM    840  CB  GLU A 447     -14.436  31.051   1.430  1.00  6.83           C  
ATOM    841  CG  GLU A 447     -14.627  31.632   2.834  1.00  8.26           C  
ATOM    842  CD  GLU A 447     -13.329  32.083   3.489  1.00 11.91           C  
ATOM    843  OE1 GLU A 447     -12.254  31.576   3.105  1.00 11.66           O  
ATOM    844  OE2 GLU A 447     -13.388  32.934   4.404  1.00 12.24           O  
ATOM    845  N   PHE A 448     -14.454  30.942  -1.703  1.00  9.05           N  
ATOM    846  CA  PHE A 448     -14.173  30.172  -2.905  1.00  9.70           C  
ATOM    847  C   PHE A 448     -13.258  30.884  -3.894  1.00  9.43           C  
ATOM    848  O   PHE A 448     -12.414  30.246  -4.523  1.00  7.13           O  
ATOM    849  CB  PHE A 448     -15.478  29.722  -3.560  1.00 10.25           C  
ATOM    850  CG  PHE A 448     -16.051  28.478  -2.936  1.00 14.64           C  
ATOM    851  CD1 PHE A 448     -15.686  27.220  -3.405  1.00 14.29           C  
ATOM    852  CD2 PHE A 448     -16.891  28.562  -1.832  1.00 16.43           C  
ATOM    853  CE1 PHE A 448     -16.147  26.060  -2.781  1.00 17.43           C  
ATOM    854  CE2 PHE A 448     -17.357  27.410  -1.199  1.00 19.34           C  
ATOM    855  CZ  PHE A 448     -16.982  26.156  -1.676  1.00 17.02           C  
ATOM    856  N   ARG A 449     -13.391  32.200  -4.029  1.00  9.11           N  
ATOM    857  CA  ARG A 449     -12.507  32.897  -4.951  1.00  8.63           C  
ATOM    858  C   ARG A 449     -11.140  33.149  -4.317  1.00  8.88           C  
ATOM    859  O   ARG A 449     -10.122  33.170  -5.013  1.00  9.25           O  
ATOM    860  CB  ARG A 449     -13.115  34.221  -5.429  1.00  7.87           C  
ATOM    861  CG  ARG A 449     -12.250  34.867  -6.503  1.00  8.80           C  
ATOM    862  CD  ARG A 449     -12.930  36.005  -7.233  1.00  9.50           C  
ATOM    863  NE  ARG A 449     -11.996  36.619  -8.173  1.00 12.58           N  
ATOM    864  CZ  ARG A 449     -12.244  37.723  -8.871  1.00  9.81           C  
ATOM    865  NH1 ARG A 449     -13.410  38.346  -8.744  1.00  7.68           N  
ATOM    866  NH2 ARG A 449     -11.312  38.210  -9.684  1.00 10.24           N  
ATOM    867  N   TYR A 450     -11.107  33.333  -2.998  1.00  8.06           N  
ATOM    868  CA  TYR A 450      -9.837  33.557  -2.315  1.00  7.34           C  
ATOM    869  C   TYR A 450      -8.994  32.283  -2.416  1.00  8.90           C  
ATOM    870  O   TYR A 450      -7.760  32.334  -2.424  1.00  9.03           O  
ATOM    871  CB  TYR A 450     -10.065  33.903  -0.840  1.00  9.43           C  
ATOM    872  CG  TYR A 450      -8.792  34.265  -0.104  1.00 10.03           C  
ATOM    873  CD1 TYR A 450      -8.121  35.454  -0.378  1.00 11.57           C  
ATOM    874  CD2 TYR A 450      -8.242  33.405   0.846  1.00 12.49           C  
ATOM    875  CE1 TYR A 450      -6.934  35.780   0.272  1.00 13.13           C  
ATOM    876  CE2 TYR A 450      -7.050  33.720   1.501  1.00 13.64           C  
ATOM    877  CZ  TYR A 450      -6.403  34.911   1.208  1.00 14.01           C  
ATOM    878  OH  TYR A 450      -5.225  35.234   1.842  1.00 15.53           O  
ATOM    879  N   ALA A 451      -9.676  31.143  -2.497  1.00  8.55           N  
ATOM    880  CA  ALA A 451      -9.017  29.845  -2.605  1.00 10.42           C  
ATOM    881  C   ALA A 451      -8.327  29.681  -3.956  1.00 14.17           C  
ATOM    882  O   ALA A 451      -7.437  28.843  -4.108  1.00 15.12           O  
ATOM    883  CB  ALA A 451     -10.032  28.728  -2.402  1.00 10.88           C  
ATOM    884  N   LYS A 452      -8.745  30.480  -4.935  1.00 16.16           N  
ATOM    885  CA  LYS A 452      -8.167  30.429  -6.276  1.00 18.50           C  
ATOM    886  C   LYS A 452      -6.980  31.378  -6.394  1.00 19.84           C  
ATOM    887  O   LYS A 452      -6.545  31.726  -7.493  1.00 19.53           O  
ATOM    888  CB  LYS A 452      -9.225  30.792  -7.321  1.00 19.92           C  
ATOM    889  CG  LYS A 452     -10.377  29.801  -7.408  1.00 21.10           C  
ATOM    890  CD  LYS A 452     -11.403  30.241  -8.442  1.00 23.83           C  
ATOM    891  CE  LYS A 452     -12.525  29.223  -8.582  1.00 24.93           C  
ATOM    892  NZ  LYS A 452     -13.254  29.009  -7.298  1.00 26.55           N  
ATOM    893  N   MET A 453      -6.464  31.789  -5.242  1.00 21.52           N  
ATOM    894  CA  MET A 453      -5.325  32.694  -5.156  1.00 24.34           C  
ATOM    895  C   MET A 453      -4.107  32.142  -5.894  1.00 25.50           C  
ATOM    896  O   MET A 453      -3.619  31.061  -5.573  1.00 24.72           O  
ATOM    897  CB  MET A 453      -4.961  32.906  -3.685  1.00 25.71           C  
ATOM    898  CG  MET A 453      -3.689  33.706  -3.444  1.00 28.18           C  
ATOM    899  SD  MET A 453      -3.915  35.466  -3.708  1.00 27.71           S  
ATOM    900  CE  MET A 453      -4.792  35.896  -2.251  1.00 26.20           C  
ATOM    901  N   PRO A 454      -3.605  32.876  -6.898  1.00 27.62           N  
ATOM    902  CA  PRO A 454      -2.432  32.387  -7.628  1.00 29.73           C  
ATOM    903  C   PRO A 454      -1.256  32.228  -6.668  1.00 31.62           C  
ATOM    904  O   PRO A 454      -1.030  33.078  -5.807  1.00 31.19           O  
ATOM    905  CB  PRO A 454      -2.194  33.480  -8.665  1.00 29.63           C  
ATOM    906  CG  PRO A 454      -3.582  33.964  -8.952  1.00 29.97           C  
ATOM    907  CD  PRO A 454      -4.177  34.061  -7.561  1.00 28.52           C  
ATOM    908  N   ASP A 455      -0.516  31.132  -6.809  1.00 34.02           N  
ATOM    909  CA  ASP A 455       0.631  30.869  -5.949  1.00 36.23           C  
ATOM    910  C   ASP A 455       1.370  29.618  -6.407  1.00 38.02           C  
ATOM    911  O   ASP A 455       1.400  28.636  -5.634  1.00 39.97           O  
ATOM    912  CB  ASP A 455       0.176  30.708  -4.501  1.00 36.18           C  
ATOM    913  OXT ASP A 455       1.906  29.635  -7.535  1.00 40.92           O  
TER     914      ASP A 455                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
