
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 (  898),  selected  110 , name 2oo1_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 2oo1_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S       1           -
LGA    -       -      M       2           -
LGA    -       -      Q       3           -
LGA    -       -      E       4           -
LGA    -       -      E       5           -
LGA    -       -      D       6           -
LGA    -       -      T       7           -
LGA    K   307_A      F       8          6.022
LGA    L   308_A      R       9          1.512
LGA    S   309_A      E      10          3.463
LGA    E   310_A      -       -           -
LGA    H   311_A      L      11          3.580
LGA    L   312_A      R      12          3.612
LGA    R   313_A      I      13          2.863
LGA    Y   314_A      F      14          2.365
LGA    C   315_A      L      15          2.131
LGA    D   316_A      R      16          2.072
LGA    S   317_A      N      17          1.868
LGA    I   318_A      V      18          1.107
LGA    L   319_A      T      19          0.419
LGA    R   320_A      H      20          1.464
LGA    E   321_A      R      21          0.613
LGA    M   322_A      L      22          0.369
LGA    L   323_A      A      23          1.470
LGA    S   324_A      I      24          2.026
LGA    K   325_A      -       -           -
LGA    K   326_A      -       -           -
LGA    H   327_A      D      25          1.630
LGA    A   328_A      K      26          1.369
LGA    A   329_A      -       -           -
LGA    Y   330_A      R      27          1.066
LGA    A   331_A      F      28          0.742
LGA    W   332_A      R      29          0.511
LGA    P   333_A      V      30          0.307
LGA    F   334_A      F      31          0.520
LGA    Y   335_A      T      32          0.696
LGA    K   336_A      K      33          0.557
LGA    P   337_A      P      34          0.556
LGA    V   338_A      V      35          1.038
LGA    D   339_A      D      36          1.519
LGA    A   340_A      P      37          2.939
LGA    E   341_A      D      38          2.179
LGA    A   342_A      E      39          1.929
LGA    L   343_A      V      40          3.169
LGA    E   344_A      -       -           -
LGA    L   345_A      -       -           -
LGA    H   346_A      P      41          2.554
LGA    D   347_A      D      42          2.100
LGA    Y   348_A      Y      43          1.625
LGA    H   349_A      V      44          2.104
LGA    D   350_A      T      45          2.203
LGA    I   351_A      V      46          1.764
LGA    I   352_A      I      47          0.932
LGA    K   353_A      K      48          0.553
LGA    H   354_A      Q      49          0.498
LGA    P   355_A      P      50          0.502
LGA    M   356_A      M      51          0.383
LGA    D   357_A      D      52          0.359
LGA    L   358_A      L      53          0.388
LGA    S   359_A      S      54          0.392
LGA    T   360_A      S      55          0.345
LGA    V   361_A      V      56          0.366
LGA    K   362_A      I      57          0.599
LGA    R   363_A      S      58          0.771
LGA    K   364_A      K      59          1.001
LGA    M   365_A      I      60          0.998
LGA    D   366_A      D      61          1.797
LGA    G   367_A      L      62          2.056
LGA    R   368_A      H      63          1.843
LGA    E   369_A      K      64          2.084
LGA    Y   370_A      Y      65          1.448
LGA    P   371_A      L      66          1.831
LGA    D   372_A      T      67          1.725
LGA    A   373_A      V      68          1.496
LGA    Q   374_A      K      69          1.240
LGA    G   375_A      D      70          1.032
LGA    F   376_A      Y      71          0.958
LGA    A   377_A      L      72          0.895
LGA    A   378_A      R      73          0.819
LGA    D   379_A      D      74          0.901
LGA    V   380_A      I      75          1.136
LGA    R   381_A      D      76          0.813
LGA    L   382_A      L      77          0.561
LGA    M   383_A      I      78          0.853
LGA    F   384_A      C      79          0.828
LGA    S   385_A      S      80          0.578
LGA    N   386_A      N      81          0.390
LGA    C   387_A      A      82          0.460
LGA    Y   388_A      L      83          0.538
LGA    K   389_A      E      84          0.928
LGA    Y   390_A      Y      85          0.986
LGA    N   391_A      N      86          0.651
LGA    P   392_A      P      87          1.984
LGA    P   393_A      D      88          4.441
LGA    D   394_A      R      89          3.548
LGA    -       -      D      90           -
LGA    -       -      P      91           -
LGA    -       -      G      92           -
LGA    H   395_A      D      93          0.924
LGA    -       -      R      94           -
LGA    E   396_A      L      95          1.960
LGA    V   397_A      I      96          1.275
LGA    V   398_A      R      97          1.237
LGA    A   399_A      H      98          1.657
LGA    M   400_A      R      99          1.725
LGA    A   401_A      A     100          1.353
LGA    R   402_A      C     101          1.937
LGA    K   403_A      A     102          2.186
LGA    L   404_A      L     103          1.934
LGA    Q   405_A      R     104          1.976
LGA    D   406_A      D     105          2.234
LGA    V   407_A      T     106          1.106
LGA    F   408_A      A     107          1.115
LGA    E   409_A      Y     108          1.634
LGA    M   410_A      A     109          0.753
LGA    R   411_A      I     110          0.966
LGA    F   412_A      I     111          2.025
LGA    A   413_A      K     112          1.976
LGA    K   414_A      E     113          2.047
LGA    M   415_A      E     114          3.524
LGA    P   416_A      L     115          2.995
LGA    -       -      D     116           -
LGA    -       -      E     117           -
LGA    -       -      D     118           -
LGA    -       -      F     119           -
LGA    -       -      E     120           -
LGA    -       -      Q     121           -
LGA    -       -      L     122           -
LGA    -       -      C     123           -
LGA    -       -      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110  130    5.0    104    1.79    26.92     72.271     5.494

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.989673 * X  +  -0.111867 * Y  +   0.089626 * Z  +  49.516644
  Y_new =  -0.139266 * X  +   0.602337 * Y  +  -0.785999 * Z  +  83.929123
  Z_new =   0.033942 * X  +  -0.790364 * Y  +  -0.611696 * Z  +  38.783974 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.229445    0.912147  [ DEG:  -127.7378     52.2622 ]
  Theta =  -0.033949   -3.107644  [ DEG:    -1.9451   -178.0549 ]
  Phi   =  -3.001792    0.139801  [ DEG:  -171.9900      8.0100 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2oo1_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2oo1_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110  130   5.0  104   1.79   26.92  72.271
REMARK  ---------------------------------------------------------- 
MOLECULE 2oo1_A
HEADER    SIGNALING PROTEIN                       25-JAN-07   2OO1              
TITLE     CRYSTAL STRUCTURE OF THE BROMO DOMAIN 2 OF HUMAN                      
TITLE    2 BROMODOMAIN CONTAINING PROTEIN 3 (BRD3)                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BROMODOMAIN-CONTAINING PROTEIN 3;                          
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: BROMO 2 DOMAIN;                                            
COMPND   5 SYNONYM: RING3-LIKE PROTEIN;                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: BRD3, KIAA0043, RING3L;                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: ROSETTA-R3;                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    BRD3, BROMODOMAIN CONTAINING PROTEIN 3, ORFX, RING3 LIKE              
KEYWDS   2 GENE, RING3L, STRUCTURAL GENOMICS, STRUCTURAL GENOMICS               
KEYWDS   3 CONSORTIUM, SGC                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.FILIPPAKOPOULOS,A.BULLOCK,E.PAPAGRIGORIOU,T.KEATES,                 
AUTHOR   2 C.COOPER,C.SMEE,E.UGOCHUKWU,J.DEBRECZENI,F.VON DELFT,                
AUTHOR   3 C.ARROWSMITH,A.EDWARDS,J.WEIGELT,M.SUNDSTROM,S.KNAPP,                
AUTHOR   4 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   13-FEB-07 2OO1    0                                                
JRNL        AUTH   P.FILIPPAKOPOULOS,A.BULLOCK,E.PAPAGRIGORIOU,                 
JRNL        AUTH 2 T.KEATES,C.COOPER,C.SMEE,E.UGOCHUKWU,J.DEBRECZENI,           
JRNL        AUTH 3 F.VON DELFT,C.ARROWSMITH,A.EDWARDS,J.WEIGELT,                
JRNL        AUTH 4 M.SUNDSTROM,S.KNAPP                                          
JRNL        TITL   CRYSTAL STRUCTURE OF THE BROMO DOMAIN 2 IN HUMAN             
JRNL        TITL 2 BROMODOMAIN CONTAINING PROTEIN 3 (BRD3)                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  2OO1 A  307   416  UNP    Q15059   BRD3_HUMAN     307    416             
DBREF  2OO1 B  307   416  UNP    Q15059   BRD3_HUMAN     307    416             
DBREF  2OO1 C  307   416  UNP    Q15059   BRD3_HUMAN     307    416             
DBREF  2OO1 D  307   416  UNP    Q15059   BRD3_HUMAN     307    416             
SEQRES   1 A  113  SER MET GLY LYS LEU SER GLU HIS LEU ARG TYR CYS ASP          
SEQRES   2 A  113  SER ILE LEU ARG GLU MET LEU SER LYS LYS HIS ALA ALA          
SEQRES   3 A  113  TYR ALA TRP PRO PHE TYR LYS PRO VAL ASP ALA GLU ALA          
SEQRES   4 A  113  LEU GLU LEU HIS ASP TYR HIS ASP ILE ILE LYS HIS PRO          
SEQRES   5 A  113  MET ASP LEU SER THR VAL LYS ARG LYS MET ASP GLY ARG          
SEQRES   6 A  113  GLU TYR PRO ASP ALA GLN GLY PHE ALA ALA ASP VAL ARG          
SEQRES   7 A  113  LEU MET PHE SER ASN CYS TYR LYS TYR ASN PRO PRO ASP          
SEQRES   8 A  113  HIS GLU VAL VAL ALA MET ALA ARG LYS LEU GLN ASP VAL          
SEQRES   9 A  113  PHE GLU MET ARG PHE ALA LYS MET PRO                          
SEQRES   1 B  113  SER MET GLY LYS LEU SER GLU HIS LEU ARG TYR CYS ASP          
SEQRES   2 B  113  SER ILE LEU ARG GLU MET LEU SER LYS LYS HIS ALA ALA          
SEQRES   3 B  113  TYR ALA TRP PRO PHE TYR LYS PRO VAL ASP ALA GLU ALA          
SEQRES   4 B  113  LEU GLU LEU HIS ASP TYR HIS ASP ILE ILE LYS HIS PRO          
SEQRES   5 B  113  MET ASP LEU SER THR VAL LYS ARG LYS MET ASP GLY ARG          
SEQRES   6 B  113  GLU TYR PRO ASP ALA GLN GLY PHE ALA ALA ASP VAL ARG          
SEQRES   7 B  113  LEU MET PHE SER ASN CYS TYR LYS TYR ASN PRO PRO ASP          
SEQRES   8 B  113  HIS GLU VAL VAL ALA MET ALA ARG LYS LEU GLN ASP VAL          
SEQRES   9 B  113  PHE GLU MET ARG PHE ALA LYS MET PRO                          
SEQRES   1 C  113  SER MET GLY LYS LEU SER GLU HIS LEU ARG TYR CYS ASP          
SEQRES   2 C  113  SER ILE LEU ARG GLU MET LEU SER LYS LYS HIS ALA ALA          
SEQRES   3 C  113  TYR ALA TRP PRO PHE TYR LYS PRO VAL ASP ALA GLU ALA          
SEQRES   4 C  113  LEU GLU LEU HIS ASP TYR HIS ASP ILE ILE LYS HIS PRO          
SEQRES   5 C  113  MET ASP LEU SER THR VAL LYS ARG LYS MET ASP GLY ARG          
SEQRES   6 C  113  GLU TYR PRO ASP ALA GLN GLY PHE ALA ALA ASP VAL ARG          
SEQRES   7 C  113  LEU MET PHE SER ASN CYS TYR LYS TYR ASN PRO PRO ASP          
SEQRES   8 C  113  HIS GLU VAL VAL ALA MET ALA ARG LYS LEU GLN ASP VAL          
SEQRES   9 C  113  PHE GLU MET ARG PHE ALA LYS MET PRO                          
SEQRES   1 D  113  SER MET GLY LYS LEU SER GLU HIS LEU ARG TYR CYS ASP          
SEQRES   2 D  113  SER ILE LEU ARG GLU MET LEU SER LYS LYS HIS ALA ALA          
SEQRES   3 D  113  TYR ALA TRP PRO PHE TYR LYS PRO VAL ASP ALA GLU ALA          
SEQRES   4 D  113  LEU GLU LEU HIS ASP TYR HIS ASP ILE ILE LYS HIS PRO          
SEQRES   5 D  113  MET ASP LEU SER THR VAL LYS ARG LYS MET ASP GLY ARG          
SEQRES   6 D  113  GLU TYR PRO ASP ALA GLN GLY PHE ALA ALA ASP VAL ARG          
SEQRES   7 D  113  LEU MET PHE SER ASN CYS TYR LYS TYR ASN PRO PRO ASP          
SEQRES   8 D  113  HIS GLU VAL VAL ALA MET ALA ARG LYS LEU GLN ASP VAL          
SEQRES   9 D  113  PHE GLU MET ARG PHE ALA LYS MET PRO                          
HET     NA    601       1                                                       
HET     NA    602       1                                                       
HET    EDO   2960       4                                                       
HET    EDO   2961       4                                                       
HET    EDO   2962       4                                                       
HET    EDO   2963       4                                                       
HET    EDO   2964       4                                                       
HET    EDO   2965       4                                                       
HET    EDO   2966       4                                                       
HET    EDO   2967       4                                                       
HET    7PE   5096      10                                                       
HET    EDO   2968       4                                                       
HETNAM      NA SODIUM ION                                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     7PE 2-(2-(2-(2-(2-(2-ETHOXYETHOXY)ETHOXY)ETHOXY)ETHOXY)              
HETNAM   2 7PE  ETHOXY)ETHANOL                                                  
HETSYN     EDO ETHYLENE GLYCOL                                                  
HETSYN     7PE POLYETHYLENE GLYCOL FRAGMENT                                     
FORMUL   5   NA    2(NA 1+)                                                     
FORMUL   7  EDO    9(C2 H6 O2)                                                  
FORMUL  15  7PE    C14 H30 O7                                                   
FORMUL  17  HOH   *475(H2 O)                                                    
CRYST1  103.837   64.678   91.827  90.00  90.00  90.00 P 21 21 2    16          
ATOM      1  N   LYS A 307       2.072  50.217  -6.918  1.00 38.26           N  
ATOM      2  CA  LYS A 307       1.456  48.943  -7.462  1.00 38.27           C  
ATOM      3  C   LYS A 307       1.117  47.967  -6.344  1.00 36.70           C  
ATOM      4  O   LYS A 307       1.734  47.970  -5.263  1.00 38.80           O  
ATOM      5  CB  LYS A 307       2.362  48.232  -8.498  1.00 37.55           C  
ATOM      6  N   LEU A 308       0.100  47.141  -6.590  1.00 34.43           N  
ATOM      7  CA  LEU A 308      -0.240  46.038  -5.701  1.00 32.35           C  
ATOM      8  C   LEU A 308       0.558  44.830  -6.145  1.00 30.47           C  
ATOM      9  O   LEU A 308       0.815  44.678  -7.325  1.00 32.02           O  
ATOM     10  CB  LEU A 308      -1.752  45.750  -5.805  1.00 31.77           C  
ATOM     11  CG  LEU A 308      -2.790  46.756  -5.298  1.00 30.76           C  
ATOM     12  CD1 LEU A 308      -4.219  46.460  -5.852  1.00 30.46           C  
ATOM     13  CD2 LEU A 308      -2.798  46.813  -3.790  1.00 31.32           C  
ATOM     14  N   SER A 309       0.966  43.962  -5.229  1.00 28.95           N  
ATOM     15  CA  SER A 309       1.558  42.710  -5.593  1.00 28.05           C  
ATOM     16  C   SER A 309       0.537  41.966  -6.458  1.00 26.13           C  
ATOM     17  O   SER A 309      -0.644  42.305  -6.426  1.00 24.80           O  
ATOM     18  CB  SER A 309       1.908  41.888  -4.358  1.00 29.40           C  
ATOM     19  OG  SER A 309       0.729  41.421  -3.656  1.00 30.89           O  
ATOM     20  N   GLU A 310       1.008  40.935  -7.128  1.00 25.17           N  
ATOM     21  CA  GLU A 310       0.190  39.993  -7.877  1.00 25.04           C  
ATOM     22  C   GLU A 310      -0.963  39.453  -7.038  1.00 24.29           C  
ATOM     23  O   GLU A 310      -2.151  39.538  -7.456  1.00 21.71           O  
ATOM     24  CB  GLU A 310       1.042  38.867  -8.386  1.00 26.44           C  
ATOM     25  CG  GLU A 310       0.371  37.944  -9.314  1.00 30.15           C  
ATOM     26  CD  GLU A 310       1.187  36.742  -9.642  1.00 38.16           C  
ATOM     27  OE1 GLU A 310       2.400  36.908  -9.949  1.00 38.35           O  
ATOM     28  OE2 GLU A 310       0.605  35.628  -9.572  1.00 43.02           O  
ATOM     29  N   HIS A 311      -0.637  38.950  -5.855  1.00 23.02           N  
ATOM     30  CA  HIS A 311      -1.724  38.441  -4.982  1.00 23.43           C  
ATOM     31  C   HIS A 311      -2.726  39.528  -4.643  1.00 23.06           C  
ATOM     32  O   HIS A 311      -3.940  39.266  -4.615  1.00 20.43           O  
ATOM     33  CB  HIS A 311      -1.204  37.818  -3.681  1.00 25.03           C  
ATOM     34  CG  HIS A 311      -0.467  36.534  -3.874  1.00 29.72           C  
ATOM     35  ND1 HIS A 311       0.100  35.849  -2.814  1.00 33.33           N  
ATOM     36  CD2 HIS A 311      -0.171  35.828  -4.986  1.00 34.90           C  
ATOM     37  CE1 HIS A 311       0.685  34.754  -3.268  1.00 36.29           C  
ATOM     38  NE2 HIS A 311       0.562  34.731  -4.584  1.00 38.90           N  
ATOM     39  N   LEU A 312      -2.268  40.749  -4.357  1.00 21.27           N  
ATOM     40  CA  LEU A 312      -3.178  41.792  -3.982  1.00 21.42           C  
ATOM     41  C   LEU A 312      -3.973  42.317  -5.153  1.00 21.39           C  
ATOM     42  O   LEU A 312      -5.084  42.805  -4.973  1.00 20.14           O  
ATOM     43  CB  LEU A 312      -2.497  42.930  -3.209  1.00 23.06           C  
ATOM     44  CG  LEU A 312      -2.175  42.524  -1.773  1.00 24.50           C  
ATOM     45  CD1 LEU A 312      -1.142  43.478  -1.170  1.00 29.26           C  
ATOM     46  CD2 LEU A 312      -3.444  42.443  -0.892  1.00 25.87           C  
ATOM     47  N   ARG A 313      -3.438  42.206  -6.368  1.00 19.85           N  
ATOM     48  CA  ARG A 313      -4.257  42.527  -7.555  1.00 19.11           C  
ATOM     49  C   ARG A 313      -5.456  41.537  -7.635  1.00 18.73           C  
ATOM     50  O   ARG A 313      -6.566  41.951  -7.967  1.00 20.62           O  
ATOM     51  CB  ARG A 313      -3.436  42.478  -8.827  1.00 18.70           C  
ATOM     52  CG  ARG A 313      -2.406  43.645  -8.837  1.00 22.34           C  
ATOM     53  CD  ARG A 313      -1.765  43.798 -10.183  1.00 20.47           C  
ATOM     54  NE  ARG A 313      -1.000  42.697 -10.667  1.00 20.96           N  
ATOM     55  CZ  ARG A 313       0.316  42.583 -10.510  1.00 25.63           C  
ATOM     56  NH1 ARG A 313       0.989  43.473  -9.751  1.00 26.63           N  
ATOM     57  NH2 ARG A 313       0.945  41.580 -11.055  1.00 23.99           N  
ATOM     58  N   TYR A 314      -5.194  40.277  -7.312  1.00 19.40           N  
ATOM     59  CA  TYR A 314      -6.257  39.282  -7.304  1.00 19.32           C  
ATOM     60  C   TYR A 314      -7.272  39.639  -6.195  1.00 19.03           C  
ATOM     61  O   TYR A 314      -8.478  39.641  -6.437  1.00 20.33           O  
ATOM     62  CB  TYR A 314      -5.690  37.882  -7.215  1.00 20.16           C  
ATOM     63  CG  TYR A 314      -6.753  36.817  -7.270  1.00 22.70           C  
ATOM     64  CD1 TYR A 314      -7.201  36.284  -8.481  1.00 26.93           C  
ATOM     65  CD2 TYR A 314      -7.401  36.420  -6.129  1.00 24.13           C  
ATOM     66  CE1 TYR A 314      -8.236  35.293  -8.511  1.00 26.24           C  
ATOM     67  CE2 TYR A 314      -8.390  35.399  -6.143  1.00 24.78           C  
ATOM     68  CZ  TYR A 314      -8.820  34.858  -7.370  1.00 26.33           C  
ATOM     69  OH  TYR A 314      -9.853  33.879  -7.439  1.00 23.09           O  
ATOM     70  N   CYS A 315      -6.777  40.023  -5.031  1.00 19.68           N  
ATOM     71  CA  CYS A 315      -7.642  40.427  -3.922  1.00 20.14           C  
ATOM     72  C   CYS A 315      -8.524  41.610  -4.306  1.00 19.32           C  
ATOM     73  O   CYS A 315      -9.714  41.716  -3.971  1.00 18.41           O  
ATOM     74  CB  CYS A 315      -6.798  40.738  -2.688  1.00 20.22           C  
ATOM     75  SG  CYS A 315      -6.115  39.291  -1.939  1.00 22.63           S  
ATOM     76  N   ASP A 316      -7.934  42.563  -5.005  1.00 20.72           N  
ATOM     77  CA  ASP A 316      -8.699  43.726  -5.481  1.00 21.32           C  
ATOM     78  C   ASP A 316      -9.873  43.300  -6.342  1.00 20.45           C  
ATOM     79  O   ASP A 316     -10.927  43.881  -6.300  1.00 20.99           O  
ATOM     80  CB  ASP A 316      -7.780  44.671  -6.273  1.00 22.59           C  
ATOM     81  CG  ASP A 316      -8.527  45.859  -6.793  1.00 29.97           C  
ATOM     82  OD1 ASP A 316      -8.713  46.803  -5.962  1.00 34.20           O  
ATOM     83  OD2 ASP A 316      -8.959  45.800  -7.995  1.00 35.54           O  
ATOM     84  N   SER A 317      -9.671  42.290  -7.176  1.00 19.76           N  
ATOM     85  CA  SER A 317     -10.755  41.708  -7.962  1.00 20.99           C  
ATOM     86  C   SER A 317     -11.809  41.069  -7.099  1.00 19.86           C  
ATOM     87  O   SER A 317     -12.997  41.110  -7.456  1.00 19.03           O  
ATOM     88  CB  SER A 317     -10.216  40.705  -8.992  1.00 22.10           C  
ATOM     89  OG  SER A 317      -9.642  41.453 -10.037  1.00 28.18           O  
ATOM     90  N   ILE A 318     -11.428  40.437  -6.001  1.00 18.83           N  
ATOM     91  CA  ILE A 318     -12.451  39.817  -5.134  1.00 17.64           C  
ATOM     92  C   ILE A 318     -13.275  40.932  -4.541  1.00 18.18           C  
ATOM     93  O   ILE A 318     -14.488  40.823  -4.416  1.00 19.57           O  
ATOM     94  CB  ILE A 318     -11.811  38.986  -4.023  1.00 16.13           C  
ATOM     95  CG1 ILE A 318     -10.899  37.881  -4.581  1.00 16.16           C  
ATOM     96  CG2 ILE A 318     -12.872  38.394  -3.096  1.00 20.02           C  
ATOM     97  CD1 ILE A 318     -10.096  37.134  -3.521  1.00 17.64           C  
ATOM     98  N   LEU A 319     -12.620  42.006  -4.117  1.00 19.28           N  
ATOM     99  CA  LEU A 319     -13.355  43.144  -3.527  1.00 20.14           C  
ATOM    100  C   LEU A 319     -14.291  43.722  -4.542  1.00 21.23           C  
ATOM    101  O   LEU A 319     -15.414  44.042  -4.234  1.00 20.63           O  
ATOM    102  CB  LEU A 319     -12.397  44.228  -3.087  1.00 20.68           C  
ATOM    103  CG  LEU A 319     -12.916  45.445  -2.334  1.00 21.32           C  
ATOM    104  CD1 LEU A 319     -13.751  45.024  -1.078  1.00 22.91           C  
ATOM    105  CD2 LEU A 319     -11.672  46.265  -1.975  1.00 25.60           C  
ATOM    106  N   ARG A 320     -13.830  43.882  -5.782  1.00 20.69           N  
ATOM    107  CA  ARG A 320     -14.714  44.409  -6.820  1.00 22.52           C  
ATOM    108  C   ARG A 320     -15.955  43.562  -6.958  1.00 22.31           C  
ATOM    109  O   ARG A 320     -17.083  44.078  -6.948  1.00 22.49           O  
ATOM    110  CB  ARG A 320     -13.998  44.475  -8.170  1.00 23.85           C  
ATOM    111  CG  ARG A 320     -14.850  45.219  -9.245  1.00 28.07           C  
ATOM    112  CD  ARG A 320     -14.299  45.071 -10.655  1.00 34.09           C  
ATOM    113  NE  ARG A 320     -13.944  43.706 -10.983  1.00 40.45           N  
ATOM    114  CZ  ARG A 320     -12.693  43.242 -11.097  1.00 44.01           C  
ATOM    115  NH1 ARG A 320     -11.638  44.050 -10.919  1.00 42.31           N  
ATOM    116  NH2 ARG A 320     -12.505  41.952 -11.422  1.00 47.77           N  
ATOM    117  N   GLU A 321     -15.761  42.250  -7.007  1.00 20.14           N  
ATOM    118  CA  GLU A 321     -16.854  41.317  -7.110  1.00 21.33           C  
ATOM    119  C   GLU A 321     -17.777  41.460  -5.915  1.00 20.45           C  
ATOM    120  O   GLU A 321     -18.994  41.524  -6.106  1.00 20.94           O  
ATOM    121  CB  GLU A 321     -16.406  39.871  -7.253  1.00 21.24           C  
ATOM    122  CG  GLU A 321     -17.614  38.920  -7.200  1.00 25.20           C  
ATOM    123  CD  GLU A 321     -17.435  37.608  -7.831  1.00 29.21           C  
ATOM    124  OE1 GLU A 321     -16.250  37.288  -8.151  1.00 29.12           O  
ATOM    125  OE2 GLU A 321     -18.487  36.893  -7.966  1.00 28.20           O  
ATOM    126  N   MET A 322     -17.255  41.472  -4.699  1.00 19.20           N  
ATOM    127  CA  MET A 322     -18.135  41.595  -3.501  1.00 18.94           C  
ATOM    128  C   MET A 322     -19.007  42.872  -3.522  1.00 19.74           C  
ATOM    129  O   MET A 322     -20.097  42.888  -2.952  1.00 19.20           O  
ATOM    130  CB  MET A 322     -17.297  41.543  -2.209  1.00 19.36           C  
ATOM    131  CG  MET A 322     -16.723  40.150  -2.047  1.00 20.40           C  
ATOM    132  SD  MET A 322     -15.978  39.910  -0.397  1.00 23.22           S  
ATOM    133  CE  MET A 322     -14.640  40.986  -0.513  1.00 24.78           C  
ATOM    134  N   LEU A 323     -18.494  43.925  -4.164  1.00 19.64           N  
ATOM    135  CA  LEU A 323     -19.161  45.215  -4.247  1.00 20.07           C  
ATOM    136  C   LEU A 323     -20.079  45.344  -5.471  1.00 21.35           C  
ATOM    137  O   LEU A 323     -20.792  46.354  -5.604  1.00 20.78           O  
ATOM    138  CB  LEU A 323     -18.094  46.282  -4.247  1.00 20.63           C  
ATOM    139  CG  LEU A 323     -17.442  46.577  -2.881  1.00 19.84           C  
ATOM    140  CD1 LEU A 323     -16.186  47.445  -3.252  1.00 23.40           C  
ATOM    141  CD2 LEU A 323     -18.360  47.292  -1.854  1.00 22.51           C  
ATOM    142  N   SER A 324     -20.120  44.306  -6.298  1.00 21.65           N  
ATOM    143  CA  SER A 324     -20.774  44.387  -7.612  1.00 23.43           C  
ATOM    144  C   SER A 324     -22.277  44.115  -7.531  1.00 22.66           C  
ATOM    145  O   SER A 324     -22.790  43.556  -6.554  1.00 21.75           O  
ATOM    146  CB  SER A 324     -20.097  43.428  -8.608  1.00 23.91           C  
ATOM    147  OG  SER A 324     -20.412  42.084  -8.357  1.00 24.34           O  
ATOM    148  N   LYS A 325     -23.010  44.531  -8.581  1.00 23.09           N  
ATOM    149  CA  LYS A 325     -24.452  44.286  -8.613  1.00 24.43           C  
ATOM    150  C   LYS A 325     -24.833  42.838  -8.440  1.00 23.98           C  
ATOM    151  O   LYS A 325     -25.817  42.585  -7.823  1.00 24.83           O  
ATOM    152  CB  LYS A 325     -25.056  44.823  -9.928  1.00 25.81           C  
ATOM    153  CG  LYS A 325     -24.941  46.349 -10.053  1.00 31.20           C  
ATOM    154  N   LYS A 326     -24.032  41.890  -8.921  1.00 24.22           N  
ATOM    155  CA  LYS A 326     -24.406  40.477  -8.921  1.00 26.14           C  
ATOM    156  C   LYS A 326     -24.748  40.052  -7.495  1.00 24.82           C  
ATOM    157  O   LYS A 326     -25.601  39.228  -7.289  1.00 25.87           O  
ATOM    158  CB  LYS A 326     -23.220  39.604  -9.408  1.00 26.64           C  
ATOM    159  CG  LYS A 326     -23.578  38.165  -9.663  1.00 33.46           C  
ATOM    160  CD  LYS A 326     -22.328  37.347 -10.033  1.00 39.69           C  
ATOM    161  CE  LYS A 326     -22.629  35.800 -10.090  1.00 43.22           C  
ATOM    162  NZ  LYS A 326     -23.773  35.364 -10.970  1.00 46.10           N  
ATOM    163  N   HIS A 327     -24.054  40.618  -6.504  1.00 23.01           N  
ATOM    164  CA  HIS A 327     -24.186  40.140  -5.117  1.00 19.30           C  
ATOM    165  C   HIS A 327     -24.886  41.140  -4.215  1.00 19.15           C  
ATOM    166  O   HIS A 327     -24.984  40.932  -3.004  1.00 19.35           O  
ATOM    167  CB  HIS A 327     -22.814  39.855  -4.552  1.00 21.77           C  
ATOM    168  CG  HIS A 327     -22.083  38.785  -5.302  1.00 17.58           C  
ATOM    169  ND1 HIS A 327     -22.520  37.486  -5.380  1.00 22.14           N  
ATOM    170  CD2 HIS A 327     -20.947  38.857  -6.024  1.00 20.43           C  
ATOM    171  CE1 HIS A 327     -21.646  36.780  -6.086  1.00 21.12           C  
ATOM    172  NE2 HIS A 327     -20.727  37.607  -6.554  1.00 20.15           N  
ATOM    173  N   ALA A 328     -25.407  42.220  -4.780  1.00 20.22           N  
ATOM    174  CA  ALA A 328     -25.951  43.315  -3.938  1.00 20.26           C  
ATOM    175  C   ALA A 328     -27.123  42.942  -3.032  1.00 20.05           C  
ATOM    176  O   ALA A 328     -27.237  43.549  -1.949  1.00 20.46           O  
ATOM    177  CB  ALA A 328     -26.292  44.551  -4.791  1.00 20.52           C  
ATOM    178  N   ALA A 329     -27.947  41.980  -3.441  1.00 20.55           N  
ATOM    179  CA  ALA A 329     -29.123  41.556  -2.660  1.00 20.98           C  
ATOM    180  C   ALA A 329     -28.715  41.115  -1.280  1.00 21.32           C  
ATOM    181  O   ALA A 329     -29.511  41.269  -0.341  1.00 22.15           O  
ATOM    182  CB  ALA A 329     -29.903  40.446  -3.375  1.00 22.71           C  
ATOM    183  N   TYR A 330     -27.507  40.542  -1.122  1.00 18.69           N  
ATOM    184  CA  TYR A 330     -27.023  40.132   0.196  1.00 20.07           C  
ATOM    185  C   TYR A 330     -25.798  40.896   0.671  1.00 19.36           C  
ATOM    186  O   TYR A 330     -25.512  40.907   1.853  1.00 20.14           O  
ATOM    187  CB  TYR A 330     -26.772  38.617   0.256  1.00 19.60           C  
ATOM    188  CG  TYR A 330     -26.174  38.028  -0.981  1.00 18.67           C  
ATOM    189  CD1 TYR A 330     -24.822  37.861  -1.112  1.00 19.52           C  
ATOM    190  CD2 TYR A 330     -27.005  37.590  -1.996  1.00 20.74           C  
ATOM    191  CE1 TYR A 330     -24.282  37.292  -2.273  1.00 19.32           C  
ATOM    192  CE2 TYR A 330     -26.480  37.029  -3.134  1.00 23.53           C  
ATOM    193  CZ  TYR A 330     -25.113  36.898  -3.274  1.00 23.10           C  
ATOM    194  OH  TYR A 330     -24.636  36.312  -4.464  1.00 25.39           O  
ATOM    195  N   ALA A 331     -25.092  41.604  -0.203  1.00 18.00           N  
ATOM    196  CA  ALA A 331     -23.918  42.281   0.216  1.00 17.96           C  
ATOM    197  C   ALA A 331     -24.150  43.647   0.830  1.00 17.67           C  
ATOM    198  O   ALA A 331     -23.288  44.165   1.564  1.00 17.18           O  
ATOM    199  CB  ALA A 331     -22.874  42.381  -0.957  1.00 17.52           C  
ATOM    200  N   TRP A 332     -25.312  44.253   0.530  1.00 17.44           N  
ATOM    201  CA  TRP A 332     -25.464  45.650   0.852  1.00 18.23           C  
ATOM    202  C   TRP A 332     -25.255  45.993   2.326  1.00 17.18           C  
ATOM    203  O   TRP A 332     -24.789  47.107   2.589  1.00 20.74           O  
ATOM    204  CB  TRP A 332     -26.770  46.225   0.291  1.00 18.34           C  
ATOM    205  CG  TRP A 332     -28.049  45.731   0.917  1.00 17.53           C  
ATOM    206  CD1 TRP A 332     -28.861  44.816   0.415  1.00 18.83           C  
ATOM    207  CD2 TRP A 332     -28.631  46.174   2.142  1.00 17.60           C  
ATOM    208  NE1 TRP A 332     -29.922  44.577   1.267  1.00 17.23           N  
ATOM    209  CE2 TRP A 332     -29.800  45.450   2.328  1.00 16.89           C  
ATOM    210  CE3 TRP A 332     -28.249  47.110   3.116  1.00 19.15           C  
ATOM    211  CZ2 TRP A 332     -30.613  45.621   3.437  1.00 18.80           C  
ATOM    212  CZ3 TRP A 332     -29.093  47.312   4.216  1.00 18.91           C  
ATOM    213  CH2 TRP A 332     -30.239  46.547   4.361  1.00 18.82           C  
ATOM    214  N   PRO A 333     -25.617  45.118   3.283  1.00 18.07           N  
ATOM    215  CA  PRO A 333     -25.354  45.490   4.671  1.00 19.55           C  
ATOM    216  C   PRO A 333     -23.869  45.671   5.034  1.00 19.86           C  
ATOM    217  O   PRO A 333     -23.566  46.279   6.080  1.00 20.95           O  
ATOM    218  CB  PRO A 333     -26.027  44.369   5.477  1.00 19.29           C  
ATOM    219  CG  PRO A 333     -27.064  43.792   4.571  1.00 19.14           C  
ATOM    220  CD  PRO A 333     -26.356  43.858   3.208  1.00 17.17           C  
ATOM    221  N   PHE A 334     -22.965  45.234   4.151  1.00 18.49           N  
ATOM    222  CA  PHE A 334     -21.530  45.203   4.419  1.00 19.03           C  
ATOM    223  C   PHE A 334     -20.789  46.315   3.707  1.00 20.50           C  
ATOM    224  O   PHE A 334     -19.566  46.423   3.804  1.00 20.20           O  
ATOM    225  CB  PHE A 334     -21.017  43.803   4.070  1.00 19.04           C  
ATOM    226  CG  PHE A 334     -21.755  42.756   4.798  1.00 18.34           C  
ATOM    227  CD1 PHE A 334     -21.536  42.558   6.159  1.00 19.63           C  
ATOM    228  CD2 PHE A 334     -22.730  41.978   4.164  1.00 17.28           C  
ATOM    229  CE1 PHE A 334     -22.298  41.670   6.846  1.00 21.68           C  
ATOM    230  CE2 PHE A 334     -23.467  41.109   4.852  1.00 20.38           C  
ATOM    231  CZ  PHE A 334     -23.261  40.964   6.200  1.00 20.20           C  
ATOM    232  N   TYR A 335     -21.547  47.190   3.014  1.00 21.09           N  
ATOM    233  CA  TYR A 335     -20.934  48.238   2.189  1.00 20.28           C  
ATOM    234  C   TYR A 335     -20.317  49.372   2.990  1.00 23.00           C  
ATOM    235  O   TYR A 335     -19.363  49.979   2.522  1.00 25.17           O  
ATOM    236  CB  TYR A 335     -21.998  48.827   1.262  1.00 20.22           C  
ATOM    237  CG  TYR A 335     -22.404  47.991   0.051  1.00 18.03           C  
ATOM    238  CD1 TYR A 335     -21.771  46.806  -0.329  1.00 17.23           C  
ATOM    239  CD2 TYR A 335     -23.438  48.431  -0.762  1.00 21.87           C  
ATOM    240  CE1 TYR A 335     -22.192  46.073  -1.446  1.00 18.91           C  
ATOM    241  CE2 TYR A 335     -23.853  47.728  -1.829  1.00 19.57           C  
ATOM    242  CZ  TYR A 335     -23.226  46.570  -2.223  1.00 20.06           C  
ATOM    243  OH  TYR A 335     -23.674  45.897  -3.330  1.00 21.60           O  
ATOM    244  N   LYS A 336     -20.877  49.659   4.155  1.00 22.59           N  
ATOM    245  CA  LYS A 336     -20.472  50.786   4.972  1.00 24.28           C  
ATOM    246  C   LYS A 336     -20.362  50.375   6.416  1.00 23.14           C  
ATOM    247  O   LYS A 336     -20.918  49.356   6.840  1.00 22.22           O  
ATOM    248  CB  LYS A 336     -21.509  51.907   4.855  1.00 26.19           C  
ATOM    249  CG  LYS A 336     -21.641  52.489   3.467  1.00 31.64           C  
ATOM    250  CD  LYS A 336     -20.480  53.369   3.125  1.00 37.57           C  
ATOM    251  CE  LYS A 336     -20.470  53.656   1.613  1.00 42.06           C  
ATOM    252  NZ  LYS A 336     -19.080  53.723   1.112  1.00 45.01           N  
ATOM    253  N   PRO A 337     -19.626  51.163   7.214  1.00 24.00           N  
ATOM    254  CA  PRO A 337     -19.475  50.806   8.608  1.00 23.20           C  
ATOM    255  C   PRO A 337     -20.786  50.774   9.337  1.00 23.84           C  
ATOM    256  O   PRO A 337     -21.656  51.593   9.040  1.00 23.42           O  
ATOM    257  CB  PRO A 337     -18.561  51.932   9.160  1.00 23.83           C  
ATOM    258  CG  PRO A 337     -17.866  52.469   8.020  1.00 25.47           C  
ATOM    259  CD  PRO A 337     -18.866  52.386   6.880  1.00 24.09           C  
ATOM    260  N   VAL A 338     -20.949  49.820  10.261  1.00 22.81           N  
ATOM    261  CA  VAL A 338     -22.110  49.782  11.137  1.00 23.57           C  
ATOM    262  C   VAL A 338     -22.208  51.099  11.891  1.00 23.70           C  
ATOM    263  O   VAL A 338     -21.249  51.494  12.531  1.00 23.49           O  
ATOM    264  CB  VAL A 338     -22.017  48.645  12.126  1.00 23.69           C  
ATOM    265  CG1 VAL A 338     -23.091  48.760  13.192  1.00 24.51           C  
ATOM    266  CG2 VAL A 338     -22.159  47.330  11.336  1.00 22.24           C  
ATOM    267  N   ASP A 339     -23.379  51.748  11.800  1.00 24.92           N  
ATOM    268  CA  ASP A 339     -23.634  52.978  12.502  1.00 25.02           C  
ATOM    269  C   ASP A 339     -24.550  52.649  13.645  1.00 24.39           C  
ATOM    270  O   ASP A 339     -25.753  52.483  13.467  1.00 23.09           O  
ATOM    271  CB  ASP A 339     -24.303  53.957  11.558  1.00 27.38           C  
ATOM    272  CG  ASP A 339     -24.491  55.322  12.168  1.00 28.01           C  
ATOM    273  OD1 ASP A 339     -24.672  55.427  13.392  1.00 29.84           O  
ATOM    274  OD2 ASP A 339     -24.427  56.291  11.373  1.00 38.42           O  
ATOM    275  N   ALA A 340     -23.961  52.447  14.812  1.00 23.51           N  
ATOM    276  CA  ALA A 340     -24.661  51.888  15.936  1.00 24.51           C  
ATOM    277  C   ALA A 340     -25.846  52.773  16.350  1.00 22.59           C  
ATOM    278  O   ALA A 340     -26.934  52.281  16.739  1.00 24.82           O  
ATOM    279  CB  ALA A 340     -23.657  51.763  17.101  1.00 25.44           C  
ATOM    280  N   GLU A 341     -25.624  54.071  16.294  1.00 23.56           N  
ATOM    281  CA  GLU A 341     -26.678  55.007  16.656  1.00 22.09           C  
ATOM    282  C   GLU A 341     -27.844  54.935  15.661  1.00 22.70           C  
ATOM    283  O   GLU A 341     -29.005  54.808  16.044  1.00 21.81           O  
ATOM    284  CB  GLU A 341     -26.147  56.418  16.786  1.00 24.32           C  
ATOM    285  N   ALA A 342     -27.527  55.012  14.367  1.00 22.99           N  
ATOM    286  CA  ALA A 342     -28.589  55.025  13.350  1.00 21.80           C  
ATOM    287  C   ALA A 342     -29.387  53.739  13.315  1.00 21.95           C  
ATOM    288  O   ALA A 342     -30.600  53.746  13.031  1.00 22.50           O  
ATOM    289  CB  ALA A 342     -27.980  55.377  11.910  1.00 22.31           C  
ATOM    290  N   LEU A 343     -28.727  52.610  13.572  1.00 21.51           N  
ATOM    291  CA  LEU A 343     -29.339  51.311  13.638  1.00 21.95           C  
ATOM    292  C   LEU A 343     -29.935  50.981  15.004  1.00 22.38           C  
ATOM    293  O   LEU A 343     -30.623  49.970  15.142  1.00 22.83           O  
ATOM    294  CB  LEU A 343     -28.287  50.245  13.267  1.00 24.09           C  
ATOM    295  CG  LEU A 343     -27.654  50.365  11.878  1.00 26.60           C  
ATOM    296  CD1 LEU A 343     -26.709  49.177  11.620  1.00 28.30           C  
ATOM    297  CD2 LEU A 343     -28.712  50.510  10.826  1.00 31.96           C  
ATOM    298  N   GLU A 344     -29.749  51.884  15.985  1.00 21.25           N  
ATOM    299  CA  GLU A 344     -30.290  51.662  17.367  1.00 21.90           C  
ATOM    300  C   GLU A 344     -29.764  50.372  17.934  1.00 22.31           C  
ATOM    301  O   GLU A 344     -30.494  49.604  18.597  1.00 24.87           O  
ATOM    302  CB  GLU A 344     -31.789  51.732  17.429  1.00 22.74           C  
ATOM    303  CG  GLU A 344     -32.245  53.136  16.988  1.00 25.40           C  
ATOM    304  CD  GLU A 344     -33.718  53.261  16.967  1.00 29.28           C  
ATOM    305  OE1 GLU A 344     -34.333  53.356  18.060  1.00 37.44           O  
ATOM    306  OE2 GLU A 344     -34.287  53.202  15.875  1.00 31.33           O  
ATOM    307  N   LEU A 345     -28.498  50.118  17.631  1.00 21.62           N  
ATOM    308  CA  LEU A 345     -27.771  48.966  18.197  1.00 22.68           C  
ATOM    309  C   LEU A 345     -26.744  49.564  19.076  1.00 22.41           C  
ATOM    310  O   LEU A 345     -25.565  49.554  18.786  1.00 22.61           O  
ATOM    311  CB  LEU A 345     -27.091  48.123  17.087  1.00 23.38           C  
ATOM    312  CG  LEU A 345     -28.014  47.690  15.961  1.00 26.21           C  
ATOM    313  CD1 LEU A 345     -27.078  47.023  14.880  1.00 27.65           C  
ATOM    314  CD2 LEU A 345     -29.070  46.779  16.526  1.00 29.22           C  
ATOM    315  N   HIS A 346     -27.191  50.131  20.188  1.00 21.80           N  
ATOM    316  CA  HIS A 346     -26.355  51.045  20.957  1.00 21.95           C  
ATOM    317  C   HIS A 346     -25.239  50.345  21.735  1.00 22.67           C  
ATOM    318  O   HIS A 346     -24.306  51.008  22.138  1.00 25.17           O  
ATOM    319  CB  HIS A 346     -27.208  51.864  21.936  1.00 22.62           C  
ATOM    320  CG  HIS A 346     -28.274  52.711  21.279  1.00 21.55           C  
ATOM    321  ND1 HIS A 346     -27.975  53.883  20.612  1.00 26.35           N  
ATOM    322  CD2 HIS A 346     -29.617  52.586  21.228  1.00 25.88           C  
ATOM    323  CE1 HIS A 346     -29.092  54.424  20.156  1.00 27.11           C  
ATOM    324  NE2 HIS A 346     -30.109  53.668  20.534  1.00 23.84           N  
ATOM    325  N   ASP A 347     -25.326  49.037  21.869  1.00 23.54           N  
ATOM    326  CA  ASP A 347     -24.271  48.242  22.504  1.00 25.61           C  
ATOM    327  C   ASP A 347     -23.239  47.694  21.519  1.00 26.31           C  
ATOM    328  O   ASP A 347     -22.353  46.942  21.906  1.00 25.58           O  
ATOM    329  CB  ASP A 347     -24.870  47.077  23.289  1.00 26.27           C  
ATOM    330  CG  ASP A 347     -25.607  46.128  22.443  1.00 27.14           C  
ATOM    331  OD1 ASP A 347     -25.858  46.426  21.270  1.00 30.20           O  
ATOM    332  OD2 ASP A 347     -26.065  45.098  22.931  1.00 33.90           O  
ATOM    333  N   TYR A 348     -23.336  48.084  20.238  1.00 24.65           N  
ATOM    334  CA  TYR A 348     -22.560  47.386  19.210  1.00 24.29           C  
ATOM    335  C   TYR A 348     -21.092  47.439  19.498  1.00 23.91           C  
ATOM    336  O   TYR A 348     -20.389  46.422  19.428  1.00 25.75           O  
ATOM    337  CB  TYR A 348     -22.845  48.027  17.861  1.00 22.94           C  
ATOM    338  CG  TYR A 348     -22.136  47.268  16.740  1.00 23.06           C  
ATOM    339  CD1 TYR A 348     -22.633  46.055  16.278  1.00 21.39           C  
ATOM    340  CD2 TYR A 348     -20.972  47.750  16.203  1.00 21.26           C  
ATOM    341  CE1 TYR A 348     -21.956  45.371  15.241  1.00 18.73           C  
ATOM    342  CE2 TYR A 348     -20.294  47.046  15.155  1.00 20.46           C  
ATOM    343  CZ  TYR A 348     -20.830  45.836  14.738  1.00 20.21           C  
ATOM    344  OH  TYR A 348     -20.177  45.087  13.699  1.00 20.81           O  
ATOM    345  N   HIS A 349     -20.629  48.601  19.928  1.00 24.48           N  
ATOM    346  CA  HIS A 349     -19.196  48.799  20.149  1.00 26.13           C  
ATOM    347  C   HIS A 349     -18.753  48.289  21.528  1.00 27.74           C  
ATOM    348  O   HIS A 349     -17.552  48.183  21.781  1.00 27.67           O  
ATOM    349  CB  HIS A 349     -18.778  50.240  19.940  1.00 27.41           C  
ATOM    350  CG  HIS A 349     -18.940  50.715  18.539  1.00 27.52           C  
ATOM    351  ND1 HIS A 349     -18.126  50.273  17.516  1.00 24.61           N  
ATOM    352  CD2 HIS A 349     -19.837  51.556  17.978  1.00 26.18           C  
ATOM    353  CE1 HIS A 349     -18.512  50.843  16.385  1.00 30.66           C  
ATOM    354  NE2 HIS A 349     -19.542  51.636  16.640  1.00 26.46           N  
ATOM    355  N   ASP A 350     -19.699  47.912  22.368  1.00 28.71           N  
ATOM    356  CA  ASP A 350     -19.356  47.153  23.579  1.00 30.33           C  
ATOM    357  C   ASP A 350     -19.010  45.698  23.255  1.00 30.18           C  
ATOM    358  O   ASP A 350     -18.217  45.058  23.970  1.00 31.15           O  
ATOM    359  CB  ASP A 350     -20.505  47.183  24.571  1.00 30.98           C  
ATOM    360  CG  ASP A 350     -20.843  48.591  25.005  1.00 34.32           C  
ATOM    361  OD1 ASP A 350     -19.911  49.435  25.017  1.00 36.97           O  
ATOM    362  OD2 ASP A 350     -22.043  48.842  25.299  1.00 40.19           O  
ATOM    363  N   ILE A 351     -19.646  45.168  22.211  1.00 28.35           N  
ATOM    364  CA  ILE A 351     -19.547  43.776  21.848  1.00 26.92           C  
ATOM    365  C   ILE A 351     -18.473  43.562  20.763  1.00 26.57           C  
ATOM    366  O   ILE A 351     -17.668  42.594  20.818  1.00 27.03           O  
ATOM    367  CB  ILE A 351     -20.930  43.253  21.426  1.00 26.89           C  
ATOM    368  CG1 ILE A 351     -21.892  43.368  22.616  1.00 28.78           C  
ATOM    369  CG2 ILE A 351     -20.863  41.806  20.926  1.00 25.30           C  
ATOM    370  CD1 ILE A 351     -23.269  42.955  22.314  1.00 33.01           C  
ATOM    371  N   ILE A 352     -18.436  44.452  19.789  1.00 24.89           N  
ATOM    372  CA  ILE A 352     -17.494  44.367  18.689  1.00 24.41           C  
ATOM    373  C   ILE A 352     -16.380  45.367  18.852  1.00 25.39           C  
ATOM    374  O   ILE A 352     -16.594  46.543  18.703  1.00 26.12           O  
ATOM    375  CB  ILE A 352     -18.249  44.641  17.355  1.00 24.20           C  
ATOM    376  CG1 ILE A 352     -19.312  43.560  17.148  1.00 23.28           C  
ATOM    377  CG2 ILE A 352     -17.292  44.745  16.185  1.00 25.70           C  
ATOM    378  CD1 ILE A 352     -18.864  42.102  17.238  1.00 23.00           C  
ATOM    379  N   LYS A 353     -15.154  44.898  19.088  1.00 26.46           N  
ATOM    380  CA  LYS A 353     -14.050  45.809  19.386  1.00 27.93           C  
ATOM    381  C   LYS A 353     -13.275  46.284  18.167  1.00 26.94           C  
ATOM    382  O   LYS A 353     -12.533  47.287  18.204  1.00 25.80           O  
ATOM    383  CB  LYS A 353     -13.143  45.101  20.363  1.00 30.18           C  
ATOM    384  CG  LYS A 353     -13.863  44.733  21.667  1.00 35.58           C  
ATOM    385  CD  LYS A 353     -14.595  45.923  22.236  1.00 40.30           C  
ATOM    386  CE  LYS A 353     -14.982  45.724  23.667  1.00 44.13           C  
ATOM    387  NZ  LYS A 353     -15.394  47.076  24.165  1.00 48.16           N  
ATOM    388  N   HIS A 354     -13.428  45.541  17.056  1.00 25.96           N  
ATOM    389  CA  HIS A 354     -12.749  45.834  15.833  1.00 25.79           C  
ATOM    390  C   HIS A 354     -13.719  45.785  14.651  1.00 24.57           C  
ATOM    391  O   HIS A 354     -13.784  44.778  13.939  1.00 23.09           O  
ATOM    392  CB  HIS A 354     -11.605  44.843  15.656  1.00 27.19           C  
ATOM    393  CG  HIS A 354     -10.542  44.996  16.708  1.00 29.91           C  
ATOM    394  ND1 HIS A 354      -9.768  46.133  16.808  1.00 36.58           N  
ATOM    395  CD2 HIS A 354     -10.162  44.185  17.721  1.00 34.23           C  
ATOM    396  CE1 HIS A 354      -8.910  45.988  17.808  1.00 39.22           C  
ATOM    397  NE2 HIS A 354      -9.138  44.819  18.389  1.00 36.13           N  
ATOM    398  N   PRO A 355     -14.479  46.868  14.466  1.00 24.29           N  
ATOM    399  CA  PRO A 355     -15.438  46.896  13.369  1.00 23.56           C  
ATOM    400  C   PRO A 355     -14.749  46.794  12.003  1.00 23.20           C  
ATOM    401  O   PRO A 355     -13.573  47.204  11.827  1.00 21.55           O  
ATOM    402  CB  PRO A 355     -16.122  48.254  13.552  1.00 24.61           C  
ATOM    403  CG  PRO A 355     -15.951  48.549  15.034  1.00 24.58           C  
ATOM    404  CD  PRO A 355     -14.552  48.118  15.257  1.00 25.27           C  
ATOM    405  N   MET A 356     -15.463  46.263  11.025  1.00 21.82           N  
ATOM    406  CA  MET A 356     -14.907  46.259   9.673  1.00 20.30           C  
ATOM    407  C   MET A 356     -16.064  46.143   8.677  1.00 19.98           C  
ATOM    408  O   MET A 356     -17.147  45.609   9.000  1.00 20.77           O  
ATOM    409  CB  MET A 356     -13.906  45.078   9.511  1.00 21.65           C  
ATOM    410  CG  MET A 356     -13.209  44.902   8.191  1.00 23.61           C  
ATOM    411  SD  MET A 356     -12.282  46.379   7.725  1.00 23.05           S  
ATOM    412  CE  MET A 356     -11.257  46.614   9.213  1.00 23.77           C  
ATOM    413  N   ASP A 357     -15.818  46.687   7.491  1.00 19.56           N  
ATOM    414  CA  ASP A 357     -16.803  46.678   6.435  1.00 20.30           C  
ATOM    415  C   ASP A 357     -16.052  46.843   5.125  1.00 20.49           C  
ATOM    416  O   ASP A 357     -14.860  47.159   5.099  1.00 20.38           O  
ATOM    417  CB  ASP A 357     -17.794  47.827   6.580  1.00 21.17           C  
ATOM    418  CG  ASP A 357     -17.156  49.147   6.304  1.00 22.80           C  
ATOM    419  OD1 ASP A 357     -16.342  49.564   7.166  1.00 25.31           O  
ATOM    420  OD2 ASP A 357     -17.366  49.732   5.213  1.00 28.17           O  
ATOM    421  N   LEU A 358     -16.771  46.655   4.029  1.00 19.41           N  
ATOM    422  CA  LEU A 358     -16.089  46.615   2.727  1.00 19.36           C  
ATOM    423  C   LEU A 358     -15.541  47.972   2.273  1.00 20.72           C  
ATOM    424  O   LEU A 358     -14.515  48.026   1.545  1.00 21.62           O  
ATOM    425  CB  LEU A 358     -17.035  46.079   1.672  1.00 19.76           C  
ATOM    426  CG  LEU A 358     -17.401  44.589   1.710  1.00 18.93           C  
ATOM    427  CD1 LEU A 358     -18.476  44.195   0.699  1.00 20.35           C  
ATOM    428  CD2 LEU A 358     -16.137  43.727   1.580  1.00 20.23           C  
ATOM    429  N   SER A 359     -16.162  49.071   2.737  1.00 21.89           N  
ATOM    430  CA  SER A 359     -15.651  50.436   2.414  1.00 22.35           C  
ATOM    431  C   SER A 359     -14.297  50.663   3.072  1.00 22.83           C  
ATOM    432  O   SER A 359     -13.417  51.320   2.500  1.00 24.09           O  
ATOM    433  CB  SER A 359     -16.635  51.540   2.790  1.00 23.79           C  
ATOM    434  OG  SER A 359     -16.662  51.772   4.155  1.00 25.45           O  
ATOM    435  N   THR A 360     -14.105  50.072   4.248  1.00 22.64           N  
ATOM    436  CA  THR A 360     -12.871  50.217   4.965  1.00 23.76           C  
ATOM    437  C   THR A 360     -11.806  49.337   4.301  1.00 23.74           C  
ATOM    438  O   THR A 360     -10.638  49.705   4.170  1.00 24.45           O  
ATOM    439  CB  THR A 360     -13.039  49.878   6.420  1.00 23.47           C  
ATOM    440  OG1 THR A 360     -14.001  50.794   6.990  1.00 25.50           O  
ATOM    441  CG2 THR A 360     -11.756  49.957   7.151  1.00 25.32           C  
ATOM    442  N   VAL A 361     -12.208  48.149   3.874  1.00 22.67           N  
ATOM    443  CA  VAL A 361     -11.271  47.305   3.140  1.00 20.51           C  
ATOM    444  C   VAL A 361     -10.822  48.014   1.839  1.00 22.26           C  
ATOM    445  O   VAL A 361      -9.616  47.933   1.418  1.00 23.68           O  
ATOM    446  CB  VAL A 361     -11.912  45.946   2.811  1.00 20.95           C  
ATOM    447  CG1 VAL A 361     -10.954  45.088   1.929  1.00 20.53           C  
ATOM    448  CG2 VAL A 361     -12.339  45.200   4.112  1.00 19.36           C  
ATOM    449  N   LYS A 362     -11.754  48.683   1.189  1.00 24.30           N  
ATOM    450  CA  LYS A 362     -11.457  49.403  -0.067  1.00 26.38           C  
ATOM    451  C   LYS A 362     -10.486  50.533   0.257  1.00 27.70           C  
ATOM    452  O   LYS A 362      -9.442  50.664  -0.407  1.00 29.04           O  
ATOM    453  CB  LYS A 362     -12.706  49.934  -0.746  1.00 27.65           C  
ATOM    454  CG  LYS A 362     -12.303  50.763  -1.957  1.00 33.25           C  
ATOM    455  CD  LYS A 362     -13.233  50.827  -3.153  1.00 40.54           C  
ATOM    456  CE  LYS A 362     -12.509  51.598  -4.309  1.00 40.92           C  
ATOM    457  NZ  LYS A 362     -11.359  50.869  -5.030  1.00 42.51           N  
ATOM    458  N   ARG A 363     -10.741  51.289   1.317  1.00 27.80           N  
ATOM    459  CA  ARG A 363      -9.815  52.373   1.694  1.00 28.41           C  
ATOM    460  C   ARG A 363      -8.405  51.867   1.992  1.00 28.85           C  
ATOM    461  O   ARG A 363      -7.391  52.462   1.537  1.00 28.76           O  
ATOM    462  CB  ARG A 363     -10.342  53.137   2.907  1.00 29.41           C  
ATOM    463  CG  ARG A 363      -9.376  54.226   3.445  1.00 32.19           C  
ATOM    464  CD  ARG A 363      -9.874  54.868   4.784  1.00 34.60           C  
ATOM    465  NE  ARG A 363      -9.838  53.977   5.954  1.00 37.48           N  
ATOM    466  CZ  ARG A 363      -8.761  53.479   6.568  1.00 41.59           C  
ATOM    467  NH1 ARG A 363      -7.524  53.737   6.164  1.00 45.48           N  
ATOM    468  NH2 ARG A 363      -8.920  52.685   7.623  1.00 41.51           N  
ATOM    469  N   LYS A 364      -8.318  50.781   2.735  1.00 27.54           N  
ATOM    470  CA  LYS A 364      -7.046  50.175   3.051  1.00 28.78           C  
ATOM    471  C   LYS A 364      -6.340  49.636   1.841  1.00 29.13           C  
ATOM    472  O   LYS A 364      -5.123  49.797   1.736  1.00 30.87           O  
ATOM    473  CB  LYS A 364      -7.203  49.112   4.111  1.00 27.62           C  
ATOM    474  CG  LYS A 364      -7.647  49.688   5.433  1.00 25.94           C  
ATOM    475  CD  LYS A 364      -7.870  48.743   6.575  1.00 25.30           C  
ATOM    476  CE  LYS A 364      -6.653  47.889   6.937  1.00 27.67           C  
ATOM    477  NZ  LYS A 364      -6.847  47.162   8.176  1.00 30.23           N  
ATOM    478  N   MET A 365      -7.084  49.000   0.931  1.00 30.19           N  
ATOM    479  CA  MET A 365      -6.514  48.536  -0.313  1.00 31.23           C  
ATOM    480  C   MET A 365      -5.918  49.705  -1.108  1.00 32.63           C  
ATOM    481  O   MET A 365      -4.745  49.643  -1.501  1.00 32.80           O  
ATOM    482  CB  MET A 365      -7.547  47.792  -1.186  1.00 31.94           C  
ATOM    483  CG  MET A 365      -6.908  47.055  -2.404  1.00 36.39           C  
ATOM    484  SD  MET A 365      -5.784  45.700  -1.946  1.00 43.79           S  
ATOM    485  CE  MET A 365      -6.896  44.702  -1.026  1.00 37.85           C  
ATOM    486  N   ASP A 366      -6.727  50.732  -1.347  1.00 33.45           N  
ATOM    487  CA  ASP A 366      -6.291  51.952  -2.054  1.00 35.16           C  
ATOM    488  C   ASP A 366      -5.092  52.597  -1.373  1.00 35.84           C  
ATOM    489  O   ASP A 366      -4.178  53.104  -2.055  1.00 37.09           O  
ATOM    490  CB  ASP A 366      -7.424  52.957  -2.093  1.00 35.44           C  
ATOM    491  CG  ASP A 366      -8.553  52.569  -3.043  1.00 37.41           C  
ATOM    492  OD1 ASP A 366      -8.386  51.655  -3.859  1.00 36.20           O  
ATOM    493  OD2 ASP A 366      -9.636  53.197  -2.975  1.00 41.30           O  
ATOM    494  N   GLY A 367      -5.075  52.569  -0.044  1.00 35.61           N  
ATOM    495  CA  GLY A 367      -3.967  53.099   0.761  1.00 36.64           C  
ATOM    496  C   GLY A 367      -2.735  52.218   0.866  1.00 37.21           C  
ATOM    497  O   GLY A 367      -1.757  52.593   1.529  1.00 38.23           O  
ATOM    498  N   ARG A 368      -2.757  51.061   0.197  1.00 36.07           N  
ATOM    499  CA  ARG A 368      -1.683  50.102   0.263  1.00 35.55           C  
ATOM    500  C   ARG A 368      -1.337  49.747   1.664  1.00 35.30           C  
ATOM    501  O   ARG A 368      -0.150  49.569   2.010  1.00 36.07           O  
ATOM    502  CB  ARG A 368      -0.442  50.604  -0.481  1.00 35.96           C  
ATOM    503  CG  ARG A 368      -0.734  51.117  -1.859  1.00 35.62           C  
ATOM    504  CD  ARG A 368      -1.248  50.019  -2.731  1.00 36.76           C  
ATOM    505  NE  ARG A 368      -1.469  50.418  -4.111  1.00 39.20           N  
ATOM    506  CZ  ARG A 368      -2.632  50.468  -4.756  1.00 43.61           C  
ATOM    507  NH1 ARG A 368      -3.791  50.134  -4.175  1.00 45.33           N  
ATOM    508  NH2 ARG A 368      -2.641  50.837  -6.026  1.00 43.18           N  
ATOM    509  N   GLU A 369      -2.349  49.610   2.511  1.00 33.62           N  
ATOM    510  CA  GLU A 369      -2.111  49.176   3.858  1.00 33.59           C  
ATOM    511  C   GLU A 369      -1.942  47.678   4.067  1.00 33.89           C  
ATOM    512  O   GLU A 369      -1.432  47.254   5.129  1.00 33.93           O  
ATOM    513  CB  GLU A 369      -3.196  49.721   4.777  1.00 33.23           C  
ATOM    514  CG  GLU A 369      -3.284  51.206   4.775  1.00 34.70           C  
ATOM    515  CD  GLU A 369      -4.289  51.729   5.761  1.00 35.36           C  
ATOM    516  OE1 GLU A 369      -4.402  51.141   6.837  1.00 37.41           O  
ATOM    517  OE2 GLU A 369      -4.967  52.725   5.442  1.00 39.30           O  
ATOM    518  N   TYR A 370      -2.339  46.835   3.092  1.00 32.94           N  
ATOM    519  CA  TYR A 370      -2.199  45.386   3.295  1.00 30.84           C  
ATOM    520  C   TYR A 370      -0.821  44.924   2.816  1.00 31.43           C  
ATOM    521  O   TYR A 370      -0.461  45.191   1.710  1.00 32.38           O  
ATOM    522  CB  TYR A 370      -3.293  44.620   2.525  1.00 30.08           C  
ATOM    523  CG  TYR A 370      -4.685  44.906   3.071  1.00 26.56           C  
ATOM    524  CD1 TYR A 370      -5.020  44.509   4.356  1.00 25.71           C  
ATOM    525  CD2 TYR A 370      -5.667  45.518   2.306  1.00 26.16           C  
ATOM    526  CE1 TYR A 370      -6.280  44.759   4.870  1.00 24.60           C  
ATOM    527  CE2 TYR A 370      -6.969  45.778   2.841  1.00 25.23           C  
ATOM    528  CZ  TYR A 370      -7.244  45.400   4.116  1.00 23.64           C  
ATOM    529  OH  TYR A 370      -8.517  45.621   4.649  1.00 26.53           O  
ATOM    530  N   PRO A 371      -0.062  44.249   3.647  1.00 32.47           N  
ATOM    531  CA  PRO A 371       1.266  43.844   3.155  1.00 33.32           C  
ATOM    532  C   PRO A 371       1.218  42.571   2.366  1.00 32.16           C  
ATOM    533  O   PRO A 371       2.147  42.254   1.615  1.00 32.92           O  
ATOM    534  CB  PRO A 371       2.052  43.587   4.420  1.00 33.95           C  
ATOM    535  CG  PRO A 371       1.033  43.397   5.510  1.00 35.00           C  
ATOM    536  CD  PRO A 371      -0.316  43.863   5.039  1.00 34.30           C  
ATOM    537  N   ASP A 372       0.139  41.821   2.544  1.00 29.50           N  
ATOM    538  CA  ASP A 372      -0.014  40.599   1.808  1.00 28.83           C  
ATOM    539  C   ASP A 372      -1.509  40.218   1.720  1.00 26.70           C  
ATOM    540  O   ASP A 372      -2.348  40.884   2.320  1.00 24.59           O  
ATOM    541  CB  ASP A 372       0.787  39.492   2.445  1.00 29.56           C  
ATOM    542  CG  ASP A 372       0.513  39.329   3.925  1.00 34.00           C  
ATOM    543  OD1 ASP A 372      -0.592  39.666   4.439  1.00 33.67           O  
ATOM    544  OD2 ASP A 372       1.444  38.831   4.583  1.00 36.69           O  
ATOM    545  N   ALA A 373      -1.793  39.164   0.979  1.00 26.01           N  
ATOM    546  CA  ALA A 373      -3.173  38.685   0.792  1.00 25.78           C  
ATOM    547  C   ALA A 373      -3.750  38.236   2.120  1.00 26.25           C  
ATOM    548  O   ALA A 373      -4.947  38.418   2.358  1.00 25.87           O  
ATOM    549  CB  ALA A 373      -3.241  37.533  -0.245  1.00 26.13           C  
ATOM    550  N   GLN A 374      -2.928  37.656   2.987  1.00 25.84           N  
ATOM    551  CA  GLN A 374      -3.426  37.173   4.278  1.00 26.82           C  
ATOM    552  C   GLN A 374      -4.015  38.303   5.097  1.00 25.42           C  
ATOM    553  O   GLN A 374      -4.999  38.096   5.853  1.00 25.63           O  
ATOM    554  CB  GLN A 374      -2.306  36.466   5.051  1.00 27.77           C  
ATOM    555  CG  GLN A 374      -2.093  35.066   4.564  1.00 30.86           C  
ATOM    556  N   GLY A 375      -3.437  39.498   5.006  1.00 25.78           N  
ATOM    557  CA  GLY A 375      -3.967  40.647   5.791  1.00 25.36           C  
ATOM    558  C   GLY A 375      -5.358  41.109   5.274  1.00 24.76           C  
ATOM    559  O   GLY A 375      -6.267  41.441   6.044  1.00 24.92           O  
ATOM    560  N   PHE A 376      -5.496  41.110   3.960  1.00 22.25           N  
ATOM    561  CA  PHE A 376      -6.804  41.368   3.301  1.00 20.53           C  
ATOM    562  C   PHE A 376      -7.830  40.356   3.777  1.00 20.74           C  
ATOM    563  O   PHE A 376      -8.938  40.736   4.194  1.00 21.47           O  
ATOM    564  CB  PHE A 376      -6.609  41.329   1.784  1.00 19.95           C  
ATOM    565  CG  PHE A 376      -7.881  41.283   0.998  1.00 21.13           C  
ATOM    566  CD1 PHE A 376      -8.555  42.423   0.669  1.00 22.23           C  
ATOM    567  CD2 PHE A 376      -8.385  40.062   0.492  1.00 21.71           C  
ATOM    568  CE1 PHE A 376      -9.750  42.341  -0.092  1.00 21.57           C  
ATOM    569  CE2 PHE A 376      -9.565  40.036  -0.242  1.00 20.89           C  
ATOM    570  CZ  PHE A 376     -10.217  41.160  -0.522  1.00 19.55           C  
ATOM    571  N   ALA A 377      -7.499  39.069   3.685  1.00 19.99           N  
ATOM    572  CA  ALA A 377      -8.431  37.996   4.121  1.00 19.14           C  
ATOM    573  C   ALA A 377      -8.798  38.174   5.578  1.00 20.37           C  
ATOM    574  O   ALA A 377      -9.947  37.895   5.967  1.00 20.49           O  
ATOM    575  CB  ALA A 377      -7.856  36.625   3.882  1.00 18.34           C  
ATOM    576  N   ALA A 378      -7.834  38.582   6.403  1.00 19.67           N  
ATOM    577  CA  ALA A 378      -8.108  38.778   7.844  1.00 20.92           C  
ATOM    578  C   ALA A 378      -9.212  39.820   8.096  1.00 20.81           C  
ATOM    579  O   ALA A 378     -10.073  39.596   8.930  1.00 21.22           O  
ATOM    580  CB  ALA A 378      -6.800  39.196   8.579  1.00 21.98           C  
ATOM    581  N   ASP A 379      -9.187  40.920   7.364  1.00 20.39           N  
ATOM    582  CA  ASP A 379     -10.166  41.997   7.532  1.00 20.01           C  
ATOM    583  C   ASP A 379     -11.518  41.511   7.016  1.00 18.45           C  
ATOM    584  O   ASP A 379     -12.558  41.710   7.618  1.00 18.90           O  
ATOM    585  CB  ASP A 379      -9.702  43.250   6.795  1.00 20.68           C  
ATOM    586  CG  ASP A 379      -8.912  44.227   7.695  1.00 20.46           C  
ATOM    587  OD1 ASP A 379      -8.772  43.972   8.898  1.00 26.87           O  
ATOM    588  OD2 ASP A 379      -8.527  45.272   7.156  1.00 28.48           O  
ATOM    589  N   VAL A 380     -11.514  40.833   5.878  1.00 17.86           N  
ATOM    590  CA  VAL A 380     -12.822  40.400   5.335  1.00 17.14           C  
ATOM    591  C   VAL A 380     -13.489  39.360   6.260  1.00 17.69           C  
ATOM    592  O   VAL A 380     -14.729  39.444   6.549  1.00 17.94           O  
ATOM    593  CB  VAL A 380     -12.654  39.820   3.872  1.00 17.49           C  
ATOM    594  CG1 VAL A 380     -13.974  39.300   3.407  1.00 16.83           C  
ATOM    595  CG2 VAL A 380     -12.115  40.855   2.932  1.00 17.61           C  
ATOM    596  N   ARG A 381     -12.678  38.446   6.804  1.00 17.46           N  
ATOM    597  CA  ARG A 381     -13.190  37.475   7.759  1.00 18.31           C  
ATOM    598  C   ARG A 381     -13.638  38.119   9.074  1.00 18.49           C  
ATOM    599  O   ARG A 381     -14.622  37.676   9.704  1.00 20.99           O  
ATOM    600  CB  ARG A 381     -12.195  36.384   7.985  1.00 19.28           C  
ATOM    601  CG  ARG A 381     -11.949  35.547   6.768  1.00 19.28           C  
ATOM    602  CD  ARG A 381     -11.248  34.317   7.141  1.00 24.17           C  
ATOM    603  NE  ARG A 381     -11.111  33.406   5.999  1.00 23.27           N  
ATOM    604  CZ  ARG A 381      -9.955  33.061   5.473  1.00 22.72           C  
ATOM    605  NH1 ARG A 381      -8.816  33.489   5.988  1.00 21.40           N  
ATOM    606  NH2 ARG A 381      -9.931  32.264   4.408  1.00 23.71           N  
ATOM    607  N   LEU A 382     -12.953  39.174   9.458  1.00 20.51           N  
ATOM    608  CA  LEU A 382     -13.321  39.958  10.666  1.00 19.57           C  
ATOM    609  C   LEU A 382     -14.719  40.550  10.465  1.00 19.41           C  
ATOM    610  O   LEU A 382     -15.570  40.512  11.363  1.00 19.99           O  
ATOM    611  CB  LEU A 382     -12.283  41.076  10.894  1.00 19.90           C  
ATOM    612  CG  LEU A 382     -12.557  42.162  11.959  1.00 21.57           C  
ATOM    613  CD1 LEU A 382     -12.778  41.493  13.322  1.00 22.25           C  
ATOM    614  CD2 LEU A 382     -11.456  43.216  11.994  1.00 25.37           C  
ATOM    615  N   MET A 383     -14.949  41.135   9.308  1.00 18.30           N  
ATOM    616  CA  MET A 383     -16.270  41.647   8.950  1.00 17.43           C  
ATOM    617  C   MET A 383     -17.367  40.594   9.107  1.00 17.36           C  
ATOM    618  O   MET A 383     -18.415  40.827   9.708  1.00 17.85           O  
ATOM    619  CB  MET A 383     -16.238  42.127   7.499  1.00 18.96           C  
ATOM    620  CG  MET A 383     -17.534  42.652   6.999  1.00 22.33           C  
ATOM    621  SD  MET A 383     -17.400  43.188   5.285  1.00 20.52           S  
ATOM    622  CE  MET A 383     -17.565  41.609   4.465  1.00 22.22           C  
ATOM    623  N   PHE A 384     -17.167  39.402   8.573  1.00 17.30           N  
ATOM    624  CA  PHE A 384     -18.219  38.406   8.714  1.00 17.05           C  
ATOM    625  C   PHE A 384     -18.354  37.929  10.175  1.00 16.64           C  
ATOM    626  O   PHE A 384     -19.430  37.745  10.696  1.00 17.65           O  
ATOM    627  CB  PHE A 384     -17.899  37.216   7.828  1.00 17.67           C  
ATOM    628  CG  PHE A 384     -17.908  37.543   6.345  1.00 18.16           C  
ATOM    629  CD1 PHE A 384     -19.015  38.096   5.749  1.00 22.80           C  
ATOM    630  CD2 PHE A 384     -16.842  37.166   5.583  1.00 20.78           C  
ATOM    631  CE1 PHE A 384     -18.966  38.344   4.381  1.00 22.83           C  
ATOM    632  CE2 PHE A 384     -16.791  37.414   4.258  1.00 23.88           C  
ATOM    633  CZ  PHE A 384     -17.829  37.987   3.689  1.00 18.18           C  
ATOM    634  N   SER A 385     -17.224  37.686  10.811  1.00 17.89           N  
ATOM    635  CA  SER A 385     -17.197  37.222  12.188  1.00 17.65           C  
ATOM    636  C   SER A 385     -17.890  38.191  13.144  1.00 17.17           C  
ATOM    637  O   SER A 385     -18.585  37.749  14.087  1.00 18.85           O  
ATOM    638  CB  SER A 385     -15.744  36.964  12.615  1.00 20.01           C  
ATOM    639  OG  SER A 385     -15.224  35.771  11.971  1.00 23.31           O  
ATOM    640  N   ASN A 386     -17.693  39.504  12.918  1.00 18.23           N  
ATOM    641  CA  ASN A 386     -18.392  40.559  13.709  1.00 18.44           C  
ATOM    642  C   ASN A 386     -19.902  40.342  13.551  1.00 20.19           C  
ATOM    643  O   ASN A 386     -20.695  40.444  14.488  1.00 21.32           O  
ATOM    644  CB  ASN A 386     -18.007  41.947  13.211  1.00 19.55           C  
ATOM    645  CG  ASN A 386     -16.643  42.365  13.660  1.00 18.71           C  
ATOM    646  OD1 ASN A 386     -16.009  41.693  14.562  1.00 21.58           O  
ATOM    647  ND2 ASN A 386     -16.131  43.470  13.067  1.00 18.97           N  
ATOM    648  N   CYS A 387     -20.316  40.010  12.367  1.00 18.89           N  
ATOM    649  CA  CYS A 387     -21.718  39.831  12.090  1.00 18.99           C  
ATOM    650  C   CYS A 387     -22.264  38.603  12.812  1.00 19.56           C  
ATOM    651  O   CYS A 387     -23.321  38.648  13.457  1.00 20.62           O  
ATOM    652  CB  CYS A 387     -21.977  39.727  10.594  1.00 18.67           C  
ATOM    653  SG  CYS A 387     -23.694  39.560  10.115  1.00 22.26           S  
ATOM    654  N   TYR A 388     -21.527  37.497  12.724  1.00 17.03           N  
ATOM    655  CA  TYR A 388     -21.944  36.297  13.409  1.00 18.96           C  
ATOM    656  C   TYR A 388     -21.924  36.510  14.939  1.00 17.61           C  
ATOM    657  O   TYR A 388     -22.748  35.898  15.616  1.00 20.17           O  
ATOM    658  CB  TYR A 388     -21.018  35.136  13.071  1.00 18.04           C  
ATOM    659  CG  TYR A 388     -20.934  34.859  11.566  1.00 18.71           C  
ATOM    660  CD1 TYR A 388     -22.034  34.970  10.746  1.00 19.64           C  
ATOM    661  CD2 TYR A 388     -19.735  34.490  10.979  1.00 16.90           C  
ATOM    662  CE1 TYR A 388     -21.941  34.742   9.322  1.00 18.13           C  
ATOM    663  CE2 TYR A 388     -19.617  34.261   9.606  1.00 18.94           C  
ATOM    664  CZ  TYR A 388     -20.713  34.385   8.778  1.00 18.56           C  
ATOM    665  OH  TYR A 388     -20.625  34.167   7.456  1.00 19.70           O  
ATOM    666  N   LYS A 389     -20.938  37.230  15.442  1.00 18.60           N  
ATOM    667  CA  LYS A 389     -20.773  37.415  16.903  1.00 19.04           C  
ATOM    668  C   LYS A 389     -21.927  38.228  17.474  1.00 21.21           C  
ATOM    669  O   LYS A 389     -22.569  37.854  18.506  1.00 20.87           O  
ATOM    670  CB  LYS A 389     -19.488  38.098  17.199  1.00 20.19           C  
ATOM    671  CG  LYS A 389     -19.289  38.397  18.711  1.00 21.53           C  
ATOM    672  CD  LYS A 389     -17.897  38.863  18.998  1.00 24.08           C  
ATOM    673  CE  LYS A 389     -17.735  39.224  20.473  1.00 29.08           C  
ATOM    674  NZ  LYS A 389     -16.338  39.651  20.679  1.00 31.87           N  
ATOM    675  N   TYR A 390     -22.244  39.329  16.797  1.00 21.00           N  
ATOM    676  CA  TYR A 390     -23.222  40.283  17.350  1.00 21.15           C  
ATOM    677  C   TYR A 390     -24.693  39.810  17.240  1.00 22.95           C  
ATOM    678  O   TYR A 390     -25.463  40.031  18.164  1.00 24.15           O  
ATOM    679  CB  TYR A 390     -23.066  41.658  16.659  1.00 21.66           C  
ATOM    680  CG  TYR A 390     -24.016  42.660  17.263  1.00 19.08           C  
ATOM    681  CD1 TYR A 390     -23.728  43.242  18.464  1.00 22.39           C  
ATOM    682  CD2 TYR A 390     -25.242  42.918  16.682  1.00 23.45           C  
ATOM    683  CE1 TYR A 390     -24.668  44.127  19.062  1.00 22.66           C  
ATOM    684  CE2 TYR A 390     -26.181  43.789  17.283  1.00 24.73           C  
ATOM    685  CZ  TYR A 390     -25.850  44.376  18.460  1.00 24.27           C  
ATOM    686  OH  TYR A 390     -26.790  45.186  19.113  1.00 26.15           O  
ATOM    687  N   ASN A 391     -25.107  39.236  16.107  1.00 22.49           N  
ATOM    688  CA  ASN A 391     -26.505  38.977  15.787  1.00 23.96           C  
ATOM    689  C   ASN A 391     -26.908  37.571  16.220  1.00 26.34           C  
ATOM    690  O   ASN A 391     -26.041  36.638  16.249  1.00 24.98           O  
ATOM    691  CB  ASN A 391     -26.724  39.155  14.284  1.00 24.57           C  
ATOM    692  CG  ASN A 391     -26.471  40.537  13.876  1.00 23.03           C  
ATOM    693  OD1 ASN A 391     -27.272  41.436  14.230  1.00 27.07           O  
ATOM    694  ND2 ASN A 391     -25.343  40.782  13.171  1.00 21.44           N  
ATOM    695  N   PRO A 392     -28.201  37.390  16.520  1.00 29.34           N  
ATOM    696  CA  PRO A 392     -28.718  36.082  16.719  1.00 30.48           C  
ATOM    697  C   PRO A 392     -28.575  35.257  15.439  1.00 30.49           C  
ATOM    698  O   PRO A 392     -28.768  35.782  14.341  1.00 29.41           O  
ATOM    699  CB  PRO A 392     -30.200  36.306  17.061  1.00 30.98           C  
ATOM    700  CG  PRO A 392     -30.478  37.687  16.928  1.00 32.50           C  
ATOM    701  CD  PRO A 392     -29.221  38.440  16.701  1.00 30.99           C  
ATOM    702  N   PRO A 393     -28.298  33.957  15.584  1.00 30.80           N  
ATOM    703  CA  PRO A 393     -27.982  33.152  14.439  1.00 30.69           C  
ATOM    704  C   PRO A 393     -29.083  33.006  13.427  1.00 31.42           C  
ATOM    705  O   PRO A 393     -28.801  32.636  12.279  1.00 32.09           O  
ATOM    706  CB  PRO A 393     -27.655  31.796  15.050  1.00 31.65           C  
ATOM    707  CG  PRO A 393     -28.379  31.782  16.338  1.00 31.34           C  
ATOM    708  CD  PRO A 393     -28.271  33.167  16.834  1.00 31.96           C  
ATOM    709  N   ASP A 394     -30.322  33.303  13.801  1.00 31.55           N  
ATOM    710  CA  ASP A 394     -31.403  33.285  12.819  1.00 33.07           C  
ATOM    711  C   ASP A 394     -31.719  34.645  12.208  1.00 32.38           C  
ATOM    712  O   ASP A 394     -32.664  34.762  11.479  1.00 34.98           O  
ATOM    713  CB  ASP A 394     -32.670  32.718  13.439  1.00 34.96           C  
ATOM    714  CG  ASP A 394     -33.132  33.514  14.623  1.00 38.79           C  
ATOM    715  OD1 ASP A 394     -32.293  34.198  15.265  1.00 46.16           O  
ATOM    716  OD2 ASP A 394     -34.345  33.422  14.944  1.00 48.07           O  
ATOM    717  N   HIS A 395     -30.931  35.665  12.482  1.00 30.40           N  
ATOM    718  CA  HIS A 395     -31.177  36.969  11.871  1.00 29.15           C  
ATOM    719  C   HIS A 395     -30.984  36.855  10.367  1.00 28.29           C  
ATOM    720  O   HIS A 395     -30.033  36.181   9.886  1.00 26.58           O  
ATOM    721  CB  HIS A 395     -30.199  37.957  12.458  1.00 29.34           C  
ATOM    722  CG  HIS A 395     -30.596  39.378  12.309  1.00 30.20           C  
ATOM    723  ND1 HIS A 395     -30.645  40.001  11.082  1.00 26.57           N  
ATOM    724  CD2 HIS A 395     -30.905  40.321  13.234  1.00 31.96           C  
ATOM    725  CE1 HIS A 395     -30.994  41.265  11.250  1.00 33.18           C  
ATOM    726  NE2 HIS A 395     -31.157  41.486  12.550  1.00 32.98           N  
ATOM    727  N   GLU A 396     -31.829  37.558   9.615  1.00 27.16           N  
ATOM    728  CA  GLU A 396     -31.665  37.573   8.167  1.00 27.23           C  
ATOM    729  C   GLU A 396     -30.254  38.061   7.763  1.00 25.22           C  
ATOM    730  O   GLU A 396     -29.722  37.582   6.754  1.00 25.37           O  
ATOM    731  CB  GLU A 396     -32.779  38.380   7.479  1.00 28.99           C  
ATOM    732  CG  GLU A 396     -32.690  38.421   5.916  1.00 35.31           C  
ATOM    733  CD  GLU A 396     -32.472  37.049   5.206  1.00 40.36           C  
ATOM    734  OE1 GLU A 396     -33.005  35.988   5.648  1.00 46.12           O  
ATOM    735  OE2 GLU A 396     -31.775  37.039   4.176  1.00 40.95           O  
ATOM    736  N   VAL A 397     -29.620  38.922   8.541  1.00 23.44           N  
ATOM    737  CA  VAL A 397     -28.329  39.487   8.140  1.00 22.75           C  
ATOM    738  C   VAL A 397     -27.217  38.431   8.235  1.00 22.36           C  
ATOM    739  O   VAL A 397     -26.223  38.478   7.507  1.00 20.90           O  
ATOM    740  CB  VAL A 397     -27.942  40.748   8.885  1.00 22.77           C  
ATOM    741  CG1 VAL A 397     -27.571  40.487  10.362  1.00 23.83           C  
ATOM    742  CG2 VAL A 397     -26.837  41.497   8.151  1.00 22.30           C  
ATOM    743  N   VAL A 398     -27.432  37.439   9.085  1.00 21.97           N  
ATOM    744  CA  VAL A 398     -26.449  36.344   9.215  1.00 21.39           C  
ATOM    745  C   VAL A 398     -26.473  35.471   7.961  1.00 21.02           C  
ATOM    746  O   VAL A 398     -25.419  35.030   7.418  1.00 20.51           O  
ATOM    747  CB  VAL A 398     -26.687  35.543  10.542  1.00 21.19           C  
ATOM    748  CG1 VAL A 398     -25.975  34.208  10.454  1.00 20.87           C  
ATOM    749  CG2 VAL A 398     -26.232  36.410  11.750  1.00 21.19           C  
ATOM    750  N   ALA A 399     -27.670  35.248   7.395  1.00 21.42           N  
ATOM    751  CA  ALA A 399     -27.818  34.481   6.177  1.00 20.63           C  
ATOM    752  C   ALA A 399     -27.184  35.241   5.018  1.00 20.56           C  
ATOM    753  O   ALA A 399     -26.628  34.631   4.132  1.00 21.20           O  
ATOM    754  CB  ALA A 399     -29.316  34.208   5.851  1.00 21.96           C  
ATOM    755  N   MET A 400     -27.293  36.575   5.043  1.00 19.30           N  
ATOM    756  CA  MET A 400     -26.744  37.409   3.977  1.00 17.35           C  
ATOM    757  C   MET A 400     -25.221  37.328   4.077  1.00 18.08           C  
ATOM    758  O   MET A 400     -24.536  37.223   3.067  1.00 17.94           O  
ATOM    759  CB  MET A 400     -27.267  38.846   4.152  1.00 18.33           C  
ATOM    760  CG  MET A 400     -28.773  38.943   3.849  1.00 19.29           C  
ATOM    761  SD  MET A 400     -29.435  40.523   4.432  1.00 23.97           S  
ATOM    762  CE  MET A 400     -29.229  41.581   3.041  1.00 26.40           C  
ATOM    763  N   ALA A 401     -24.706  37.444   5.296  1.00 17.76           N  
ATOM    764  CA  ALA A 401     -23.243  37.339   5.542  1.00 18.39           C  
ATOM    765  C   ALA A 401     -22.718  36.018   5.014  1.00 18.87           C  
ATOM    766  O   ALA A 401     -21.673  35.944   4.331  1.00 17.93           O  
ATOM    767  CB  ALA A 401     -22.938  37.480   7.046  1.00 18.24           C  
ATOM    768  N   ARG A 402     -23.438  34.945   5.316  1.00 18.55           N  
ATOM    769  CA  ARG A 402     -23.003  33.620   4.865  1.00 19.68           C  
ATOM    770  C   ARG A 402     -22.931  33.483   3.393  1.00 19.85           C  
ATOM    771  O   ARG A 402     -21.962  32.913   2.854  1.00 20.09           O  
ATOM    772  CB  ARG A 402     -23.969  32.582   5.354  1.00 22.22           C  
ATOM    773  CG  ARG A 402     -23.659  32.115   6.651  1.00 30.94           C  
ATOM    774  CD  ARG A 402     -24.245  30.720   6.774  1.00 35.04           C  
ATOM    775  NE  ARG A 402     -24.279  30.471   8.169  1.00 37.49           N  
ATOM    776  CZ  ARG A 402     -25.361  30.481   8.926  1.00 39.20           C  
ATOM    777  NH1 ARG A 402     -26.582  30.729   8.424  1.00 42.45           N  
ATOM    778  NH2 ARG A 402     -25.186  30.187  10.183  1.00 43.17           N  
ATOM    779  N   LYS A 403     -23.951  34.011   2.698  1.00 18.93           N  
ATOM    780  CA  LYS A 403     -23.921  33.982   1.219  1.00 19.08           C  
ATOM    781  C   LYS A 403     -22.727  34.743   0.676  1.00 17.40           C  
ATOM    782  O   LYS A 403     -22.072  34.315  -0.274  1.00 18.53           O  
ATOM    783  CB  LYS A 403     -25.195  34.558   0.652  1.00 19.78           C  
ATOM    784  CG  LYS A 403     -26.393  33.686   0.793  1.00 26.45           C  
ATOM    785  CD  LYS A 403     -27.605  34.261   0.006  1.00 32.76           C  
ATOM    786  CE  LYS A 403     -28.984  33.748   0.558  1.00 35.53           C  
ATOM    787  N   LEU A 404     -22.447  35.889   1.254  1.00 16.77           N  
ATOM    788  CA  LEU A 404     -21.326  36.708   0.781  1.00 16.52           C  
ATOM    789  C   LEU A 404     -19.984  36.051   1.138  1.00 17.57           C  
ATOM    790  O   LEU A 404     -19.013  36.068   0.328  1.00 18.00           O  
ATOM    791  CB  LEU A 404     -21.391  38.121   1.296  1.00 17.66           C  
ATOM    792  CG  LEU A 404     -20.362  39.067   0.633  1.00 18.96           C  
ATOM    793  CD1 LEU A 404     -20.582  39.170  -0.877  1.00 20.29           C  
ATOM    794  CD2 LEU A 404     -20.425  40.421   1.364  1.00 19.10           C  
ATOM    795  N   GLN A 405     -19.937  35.404   2.291  1.00 17.03           N  
ATOM    796  CA  GLN A 405     -18.738  34.686   2.669  1.00 16.96           C  
ATOM    797  C   GLN A 405     -18.499  33.494   1.779  1.00 17.03           C  
ATOM    798  O   GLN A 405     -17.357  33.158   1.502  1.00 17.69           O  
ATOM    799  CB  GLN A 405     -18.769  34.237   4.116  1.00 18.57           C  
ATOM    800  CG  GLN A 405     -17.379  33.726   4.529  1.00 18.63           C  
ATOM    801  CD  GLN A 405     -17.142  33.639   6.039  1.00 22.87           C  
ATOM    802  OE1 GLN A 405     -18.081  33.681   6.859  1.00 20.89           O  
ATOM    803  NE2 GLN A 405     -15.870  33.442   6.408  1.00 20.99           N  
ATOM    804  N   ASP A 406     -19.544  32.809   1.340  1.00 17.43           N  
ATOM    805  CA  ASP A 406     -19.363  31.755   0.346  1.00 19.19           C  
ATOM    806  C   ASP A 406     -18.626  32.286  -0.873  1.00 19.54           C  
ATOM    807  O   ASP A 406     -17.703  31.643  -1.390  1.00 20.03           O  
ATOM    808  CB  ASP A 406     -20.724  31.218  -0.105  1.00 20.69           C  
ATOM    809  CG  ASP A 406     -21.428  30.402   0.934  1.00 24.38           C  
ATOM    810  OD1 ASP A 406     -20.840  30.018   1.990  1.00 26.54           O  
ATOM    811  OD2 ASP A 406     -22.636  30.128   0.651  1.00 33.17           O  
ATOM    812  N   VAL A 407     -19.029  33.441  -1.376  1.00 19.62           N  
ATOM    813  CA  VAL A 407     -18.296  34.089  -2.491  1.00 19.05           C  
ATOM    814  C   VAL A 407     -16.836  34.331  -2.116  1.00 18.54           C  
ATOM    815  O   VAL A 407     -15.923  34.003  -2.880  1.00 18.33           O  
ATOM    816  CB  VAL A 407     -18.941  35.398  -2.888  1.00 19.27           C  
ATOM    817  CG1 VAL A 407     -18.185  36.060  -4.065  1.00 20.76           C  
ATOM    818  CG2 VAL A 407     -20.372  35.146  -3.267  1.00 21.68           C  
ATOM    819  N   PHE A 408     -16.626  34.989  -0.991  1.00 17.22           N  
ATOM    820  CA  PHE A 408     -15.284  35.382  -0.610  1.00 16.09           C  
ATOM    821  C   PHE A 408     -14.409  34.147  -0.508  1.00 15.49           C  
ATOM    822  O   PHE A 408     -13.272  34.091  -1.039  1.00 16.25           O  
ATOM    823  CB  PHE A 408     -15.267  36.100   0.728  1.00 17.29           C  
ATOM    824  CG  PHE A 408     -13.909  36.197   1.268  1.00 17.00           C  
ATOM    825  CD1 PHE A 408     -13.011  37.086   0.659  1.00 19.10           C  
ATOM    826  CD2 PHE A 408     -13.468  35.427   2.305  1.00 18.76           C  
ATOM    827  CE1 PHE A 408     -11.705  37.133   1.068  1.00 21.05           C  
ATOM    828  CE2 PHE A 408     -12.095  35.495   2.722  1.00 19.73           C  
ATOM    829  CZ  PHE A 408     -11.252  36.354   2.069  1.00 19.83           C  
ATOM    830  N   GLU A 409     -14.841  33.128   0.241  1.00 16.12           N  
ATOM    831  CA  GLU A 409     -13.939  32.009   0.477  1.00 16.28           C  
ATOM    832  C   GLU A 409     -13.598  31.281  -0.802  1.00 17.33           C  
ATOM    833  O   GLU A 409     -12.434  30.868  -1.008  1.00 18.57           O  
ATOM    834  CB  GLU A 409     -14.528  31.030   1.460  1.00 16.97           C  
ATOM    835  CG  GLU A 409     -14.693  31.588   2.856  1.00 16.48           C  
ATOM    836  CD  GLU A 409     -13.451  31.881   3.668  1.00 24.60           C  
ATOM    837  OE1 GLU A 409     -12.362  31.345   3.355  1.00 21.63           O  
ATOM    838  OE2 GLU A 409     -13.569  32.638   4.675  1.00 23.27           O  
ATOM    839  N   MET A 410     -14.570  31.165  -1.699  1.00 17.56           N  
ATOM    840  CA  MET A 410     -14.295  30.446  -2.958  1.00 16.89           C  
ATOM    841  C   MET A 410     -13.330  31.245  -3.785  1.00 17.03           C  
ATOM    842  O   MET A 410     -12.342  30.687  -4.305  1.00 19.21           O  
ATOM    843  CB  MET A 410     -15.550  30.226  -3.748  1.00 18.06           C  
ATOM    844  CG  MET A 410     -15.391  29.568  -5.110  1.00 18.83           C  
ATOM    845  SD  MET A 410     -14.678  27.942  -4.979  1.00 21.87           S  
ATOM    846  CE  MET A 410     -16.008  27.062  -4.097  1.00 21.92           C  
ATOM    847  N   ARG A 411     -13.603  32.542  -3.948  1.00 17.06           N  
ATOM    848  CA  ARG A 411     -12.717  33.346  -4.770  1.00 16.42           C  
ATOM    849  C   ARG A 411     -11.291  33.401  -4.180  1.00 16.45           C  
ATOM    850  O   ARG A 411     -10.321  33.329  -4.931  1.00 17.75           O  
ATOM    851  CB  ARG A 411     -13.215  34.763  -4.984  1.00 17.11           C  
ATOM    852  CG  ARG A 411     -14.583  34.903  -5.631  1.00 19.20           C  
ATOM    853  CD  ARG A 411     -14.662  34.198  -7.018  1.00 23.81           C  
ATOM    854  NE  ARG A 411     -16.020  34.465  -7.466  1.00 25.85           N  
ATOM    855  CZ  ARG A 411     -17.053  33.638  -7.322  1.00 29.08           C  
ATOM    856  NH1 ARG A 411     -16.866  32.364  -6.982  1.00 28.09           N  
ATOM    857  NH2 ARG A 411     -18.304  34.064  -7.641  1.00 29.66           N  
ATOM    858  N   PHE A 412     -11.158  33.577  -2.873  1.00 15.93           N  
ATOM    859  CA  PHE A 412      -9.850  33.655  -2.239  1.00 17.02           C  
ATOM    860  C   PHE A 412      -9.045  32.365  -2.449  1.00 18.46           C  
ATOM    861  O   PHE A 412      -7.851  32.365  -2.747  1.00 18.94           O  
ATOM    862  CB  PHE A 412     -10.012  34.022  -0.756  1.00 17.02           C  
ATOM    863  CG  PHE A 412      -8.722  34.371  -0.089  1.00 19.89           C  
ATOM    864  CD1 PHE A 412      -8.103  35.572  -0.352  1.00 19.28           C  
ATOM    865  CD2 PHE A 412      -8.096  33.470   0.753  1.00 25.10           C  
ATOM    866  CE1 PHE A 412      -6.857  35.875   0.232  1.00 21.30           C  
ATOM    867  CE2 PHE A 412      -6.875  33.794   1.331  1.00 25.63           C  
ATOM    868  CZ  PHE A 412      -6.291  34.998   1.063  1.00 21.09           C  
ATOM    869  N   ALA A 413      -9.708  31.214  -2.320  1.00 18.20           N  
ATOM    870  CA  ALA A 413      -9.072  29.904  -2.456  1.00 18.69           C  
ATOM    871  C   ALA A 413      -8.584  29.662  -3.878  1.00 20.32           C  
ATOM    872  O   ALA A 413      -7.673  28.881  -4.096  1.00 20.49           O  
ATOM    873  CB  ALA A 413     -10.064  28.837  -2.059  1.00 18.34           C  
ATOM    874  N   LYS A 414      -9.263  30.264  -4.846  1.00 19.09           N  
ATOM    875  CA  LYS A 414      -8.940  30.082  -6.262  1.00 21.50           C  
ATOM    876  C   LYS A 414      -7.857  31.077  -6.712  1.00 24.12           C  
ATOM    877  O   LYS A 414      -7.439  31.049  -7.887  1.00 26.02           O  
ATOM    878  CB  LYS A 414     -10.204  30.197  -7.108  1.00 21.02           C  
ATOM    879  CG  LYS A 414     -11.249  29.131  -7.015  1.00 19.64           C  
ATOM    880  CD  LYS A 414     -10.748  27.753  -7.385  1.00 18.84           C  
ATOM    881  CE  LYS A 414     -11.760  26.708  -7.265  1.00 17.63           C  
ATOM    882  NZ  LYS A 414     -11.208  25.348  -7.585  1.00 19.43           N  
ATOM    883  N   MET A 415      -7.311  31.891  -5.816  1.00 23.34           N  
ATOM    884  CA  MET A 415      -6.176  32.788  -6.153  1.00 25.57           C  
ATOM    885  C   MET A 415      -5.028  31.927  -6.705  1.00 25.04           C  
ATOM    886  O   MET A 415      -4.616  30.958  -6.089  1.00 25.11           O  
ATOM    887  CB  MET A 415      -5.689  33.557  -4.914  1.00 25.42           C  
ATOM    888  CG  MET A 415      -4.521  34.534  -5.142  1.00 30.86           C  
ATOM    889  SD  MET A 415      -4.277  35.520  -3.666  1.00 35.30           S  
ATOM    890  CE  MET A 415      -3.190  34.521  -2.705  1.00 38.02           C  
ATOM    891  N   PRO A 416      -4.538  32.255  -7.892  1.00 25.70           N  
ATOM    892  CA  PRO A 416      -3.435  31.496  -8.416  1.00 26.76           C  
ATOM    893  C   PRO A 416      -2.242  31.444  -7.520  1.00 30.01           C  
ATOM    894  O   PRO A 416      -1.955  32.438  -6.829  1.00 31.04           O  
ATOM    895  CB  PRO A 416      -3.070  32.285  -9.656  1.00 26.78           C  
ATOM    896  CG  PRO A 416      -4.225  32.909 -10.083  1.00 25.65           C  
ATOM    897  CD  PRO A 416      -4.982  33.264  -8.848  1.00 23.79           C  
ATOM    898  OXT PRO A 416      -1.535  30.403  -7.528  1.00 31.87           O  
TER     899      PRO A 416                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
