
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  103 ( 1662),  selected  103 , name 1y9o_A
# Molecule2: number of CA atoms   76 ( 1151),  selected   76 , name T0437.pdb
# PARAMETERS: 1y9o_A.T0437.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    -1_A      D      24           -
LGA    S     0_A      N      25           -
LGA    M     1_A      -       -           -
LGA    K     2_A      -       -           -
LGA    K     3_A      -       -           -
LGA    W     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    D     6_A      -       -           -
LGA    T     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    V     9_A      -       -           -
LGA    F    10_A      -       -           -
LGA    E    11_A      -       -           -
LGA    M    12_A      -       -           -
LGA    L    13_A      -       -           -
LGA    K    14_A      C      26          1.317
LGA    R    15_A      T      27          1.591
LGA    M    16_A      S      28          1.432
LGA    Y    17_A      K      29          2.197
LGA    A    18_A      F      30          2.291
LGA    R    19_A      S      31          2.338
LGA    V    20_A      R      32          1.807
LGA    Y    21_A      F      33          1.938
LGA    G    22_A      F      34          3.021
LGA    L    23_A      A      35          2.653
LGA    V    24_A      T      36          6.335
LGA    Q    25_A      R      37          3.048
LGA    G    26_A      E      38          1.082
LGA    V    27_A      E      39          3.027
LGA    -       -      A      40           -
LGA    -       -      E      41           -
LGA    G    28_A      S      42          1.560
LGA    F    29_A      F      43          0.491
LGA    R    30_A      M      44          0.919
LGA    K    31_A      T      45          1.035
LGA    F    32_A      K      46          0.717
LGA    V    33_A      L      47          0.691
LGA    Q    34_A      K      48          1.011
LGA    I    35_A      E      49          1.121
LGA    H    36_A      L      50          1.162
LGA    A    37_A      A      51          0.966
LGA    I    38_A      A      52          2.618
LGA    R    39_A      A      53          2.942
LGA    L    40_A      A      54          2.418
LGA    G    41_A      S      55          2.237
LGA    -       -      S      56           -
LGA    -       -      A      57           -
LGA    -       -      D      58           -
LGA    -       -      E      59           -
LGA    -       -      G      60           -
LGA    I    42_A      A      61          1.994
LGA    K    43_A      S      62          1.374
LGA    G    44_A      V      63          1.831
LGA    Y    45_A      A      64          1.697
LGA    A    46_A      Y      65          2.043
LGA    K    47_A      K      66          2.501
LGA    N    48_A      I      67          2.427
LGA    L    49_A      K      68          3.073
LGA    P    50_A      D      69          3.296
LGA    D    51_A      L      70          2.928
LGA    -       -      E      71           -
LGA    -       -      G      72           -
LGA    -       -      Q      73           -
LGA    G    52_A      V      74          1.205
LGA    S    53_A      E      75          1.181
LGA    V    54_A      L      76          1.658
LGA    E    55_A      D      77          1.772
LGA    V    56_A      A      78          1.203
LGA    V    57_A      A      79          1.087
LGA    A    58_A      F      80          1.078
LGA    E    59_A      T      81          1.774
LGA    G    60_A      F      82          2.534
LGA    -       -      S      83           -
LGA    Y    61_A      C      84          1.982
LGA    E    62_A      Q      85          2.432
LGA    E    63_A      A      86          2.433
LGA    A    64_A      E      87          1.140
LGA    L    65_A      M      88          1.223
LGA    S    66_A      I      89          2.253
LGA    K    67_A      I      90          2.278
LGA    L    68_A      F      91          1.306
LGA    L    69_A      E      92          0.673
LGA    E    70_A      L      93          1.246
LGA    R    71_A      S      94          1.868
LGA    I    72_A      L      95          1.686
LGA    K    73_A      R      96          2.323
LGA    Q    74_A      S      97          2.165
LGA    G    75_A      L      98          1.832
LGA    P    76_A      A      99          2.063
LGA    P    77_A      -       -           -
LGA    A    78_A      -       -           -
LGA    A    79_A      -       -           -
LGA    E    80_A      -       -           -
LGA    V    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    K    83_A      -       -           -
LGA    V    84_A      -       -           -
LGA    D    85_A      -       -           -
LGA    Y    86_A      -       -           -
LGA    S    87_A      -       -           -
LGA    F    88_A      -       -           -
LGA    S    89_A      -       -           -
LGA    E    90_A      -       -           -
LGA    Y    91_A      -       -           -
LGA    K    92_A      -       -           -
LGA    G    93_A      -       -           -
LGA    E    94_A      -       -           -
LGA    F    95_A      -       -           -
LGA    E    96_A      -       -           -
LGA    D    97_A      -       -           -
LGA    F    98_A      -       -           -
LGA    E    99_A      -       -           -
LGA    T   100_A      -       -           -
LGA    Y   101_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  103   76    5.0     63    2.10     4.76     68.521     2.867

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.673636 * X  +  -0.266825 * Y  +   0.689216 * Z  +  -8.861781
  Y_new =  -0.605880 * X  +   0.733412 * Y  +  -0.308248 * Z  +  -3.406948
  Z_new =  -0.423231 * X  +  -0.625229 * Y  +  -0.655716 * Z  +  -6.136343 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.379990    0.761602  [ DEG:  -136.3634     43.6366 ]
  Theta =   0.437008    2.704584  [ DEG:    25.0387    154.9613 ]
  Phi   =  -2.409100    0.732493  [ DEG:  -138.0312     41.9688 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1y9o_A                                        
REMARK     2: T0437.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1y9o_A.T0437.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  103   76   5.0   63   2.10    4.76  68.521
REMARK  ---------------------------------------------------------- 
MOLECULE 1y9o_A
HEADER    HYDROLASE                               16-DEC-04   1Y9O              
TITLE     1H NMR STRUCTURE OF ACYLPHOSPHATASE FROM THE                          
TITLE    2 HYPERTHERMOPHILE SULFOLOBUS SOLFATARICUS                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACYLPHOSPHATASE;                                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 3.6.1.7;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SULFOLOBUS SOLFATARICUS;                        
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PGEX-2T                                   
KEYWDS    SSO, ACYLPHOSPHATASE, HYPERTHERMOPHILE, NMR                           
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.CORAZZA,C.ROSANO,K.PAGANO,V.ALVERDI,G.ESPOSITO,C.CAPANNI,           
AUTHOR   2 F.BEMPORAD,G.PLAKOUTSI,M.STEFANI,F.CHITI,S.ZUCCOTTI,                 
AUTHOR   3 M.BOLOGNESI,P.VIGLINO                                                
REVDAT   3   20-MAR-07 1Y9O    1       JRNL                                     
REVDAT   2   13-MAR-07 1Y9O    1       DBREF  SEQADV                            
REVDAT   1   29-NOV-05 1Y9O    0                                                
JRNL        AUTH   A.CORAZZA,C.ROSANO,K.PAGANO,V.ALVERDI,G.ESPOSITO,            
JRNL        AUTH 2 C.CAPANNI,F.BEMPORAD,G.PLAKOUTSI,M.STEFANI,F.CHITI,          
JRNL        AUTH 3 S.ZUCCOTTI,M.BOLOGNESI,P.VIGLINO                             
JRNL        TITL   STRUCTURE, CONFORMATIONAL STABILITY, AND ENZYMATIC           
JRNL        TITL 2 PROPERTIES OF ACYLPHOSPHATASE FROM THE                       
JRNL        TITL 3 HYPERTHERMOPHILE SULFOLOBUS SOLFATARICUS                     
JRNL        REF    PROTEINS                      V.  62    64 2006              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1Y9O A    1   101  UNP    Q97ZL0   Q97ZL0_SULSO     1    101             
SEQRES   1 A  103  GLY SER MET LYS LYS TRP SER ASP THR GLU VAL PHE GLU          
SEQRES   2 A  103  MET LEU LYS ARG MET TYR ALA ARG VAL TYR GLY LEU VAL          
SEQRES   3 A  103  GLN GLY VAL GLY PHE ARG LYS PHE VAL GLN ILE HIS ALA          
SEQRES   4 A  103  ILE ARG LEU GLY ILE LYS GLY TYR ALA LYS ASN LEU PRO          
SEQRES   5 A  103  ASP GLY SER VAL GLU VAL VAL ALA GLU GLY TYR GLU GLU          
SEQRES   6 A  103  ALA LEU SER LYS LEU LEU GLU ARG ILE LYS GLN GLY PRO          
SEQRES   7 A  103  PRO ALA ALA GLU VAL GLU LYS VAL ASP TYR SER PHE SER          
SEQRES   8 A  103  GLU TYR LYS GLY GLU PHE GLU ASP PHE GLU THR TYR              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A  -1      35.208  -3.680  15.218  1.00  0.00           N  
ATOM      2  CA  GLY A  -1      34.054  -4.249  14.500  1.00  0.00           C  
ATOM      3  C   GLY A  -1      33.123  -5.021  15.431  1.00  0.00           C  
ATOM      4  O   GLY A  -1      33.394  -5.126  16.625  1.00  0.00           O  
ATOM      5  H2  GLY A  -1      34.873  -3.059  15.941  1.00  0.00           H  
ATOM      6  HA2 GLY A  -1      33.497  -3.435  14.033  1.00  0.00           H  
ATOM      7  HA3 GLY A  -1      34.420  -4.920  13.723  1.00  0.00           H  
ATOM      8  H1  GLY A  -1      35.801  -3.173  14.577  1.00  0.00           H  
ATOM      9  H3  GLY A  -1      35.730  -4.431  15.648  1.00  0.00           H  
ATOM     10  N   SER A   0      32.027  -5.555  14.878  1.00  0.00           N  
ATOM     11  CA  SER A   0      31.056  -6.347  15.622  1.00  0.00           C  
ATOM     12  C   SER A   0      31.563  -7.775  15.836  1.00  0.00           C  
ATOM     13  O   SER A   0      32.513  -8.209  15.186  1.00  0.00           O  
ATOM     14  CB  SER A   0      29.712  -6.343  14.880  1.00  0.00           C  
ATOM     15  OG  SER A   0      29.829  -6.959  13.613  1.00  0.00           O  
ATOM     16  H   SER A   0      31.873  -5.439  13.887  1.00  0.00           H  
ATOM     17  HA  SER A   0      30.895  -5.885  16.597  1.00  0.00           H  
ATOM     18  HB2 SER A   0      28.968  -6.887  15.464  1.00  0.00           H  
ATOM     19  HB3 SER A   0      29.367  -5.316  14.750  1.00  0.00           H  
ATOM     20  HG  SER A   0      30.445  -6.459  13.074  1.00  0.00           H  
ATOM     21  N   MET A   1      30.908  -8.499  16.753  1.00  0.00           N  
ATOM     22  CA  MET A   1      31.143  -9.911  17.023  1.00  0.00           C  
ATOM     23  C   MET A   1      29.796 -10.629  17.000  1.00  0.00           C  
ATOM     24  O   MET A   1      29.595 -11.547  16.206  1.00  0.00           O  
ATOM     25  CB  MET A   1      31.861 -10.109  18.369  1.00  0.00           C  
ATOM     26  CG  MET A   1      33.221  -9.402  18.436  1.00  0.00           C  
ATOM     27  SD  MET A   1      33.155  -7.642  18.878  1.00  0.00           S  
ATOM     28  CE  MET A   1      34.890  -7.200  18.627  1.00  0.00           C  
ATOM     29  H   MET A   1      30.151  -8.057  17.252  1.00  0.00           H  
ATOM     30  HA  MET A   1      31.765 -10.347  16.239  1.00  0.00           H  
ATOM     31  HB2 MET A   1      31.238  -9.760  19.193  1.00  0.00           H  
ATOM     32  HB3 MET A   1      32.031 -11.180  18.496  1.00  0.00           H  
ATOM     33  HG2 MET A   1      33.818  -9.896  19.202  1.00  0.00           H  
ATOM     34  HG3 MET A   1      33.734  -9.516  17.482  1.00  0.00           H  
ATOM     35  HE1 MET A   1      35.523  -7.835  19.248  1.00  0.00           H  
ATOM     36  HE2 MET A   1      35.038  -6.157  18.906  1.00  0.00           H  
ATOM     37  HE3 MET A   1      35.153  -7.335  17.577  1.00  0.00           H  
ATOM     38  N   LYS A   2      28.862 -10.184  17.851  1.00  0.00           N  
ATOM     39  CA  LYS A   2      27.485 -10.656  17.845  1.00  0.00           C  
ATOM     40  C   LYS A   2      26.769 -10.211  16.565  1.00  0.00           C  
ATOM     41  O   LYS A   2      27.162  -9.227  15.936  1.00  0.00           O  
ATOM     42  CB  LYS A   2      26.748 -10.176  19.105  1.00  0.00           C  
ATOM     43  CG  LYS A   2      26.611  -8.648  19.187  1.00  0.00           C  
ATOM     44  CD  LYS A   2      25.823  -8.259  20.445  1.00  0.00           C  
ATOM     45  CE  LYS A   2      25.607  -6.743  20.546  1.00  0.00           C  
ATOM     46  NZ  LYS A   2      26.867  -6.052  20.758  1.00  0.00           N  
ATOM     47  H   LYS A   2      29.102  -9.435  18.483  1.00  0.00           H  
ATOM     48  HA  LYS A   2      27.503 -11.747  17.870  1.00  0.00           H  
ATOM     49  HB2 LYS A   2      25.751 -10.618  19.112  1.00  0.00           H  
ATOM     50  HB3 LYS A   2      27.287 -10.532  19.983  1.00  0.00           H  
ATOM     51  HG2 LYS A   2      27.601  -8.192  19.220  1.00  0.00           H  
ATOM     52  HG3 LYS A   2      26.076  -8.274  18.315  1.00  0.00           H  
ATOM     53  HD2 LYS A   2      24.843  -8.738  20.405  1.00  0.00           H  
ATOM     54  HD3 LYS A   2      26.347  -8.611  21.334  1.00  0.00           H  
ATOM     55  HE2 LYS A   2      25.141  -6.372  19.632  1.00  0.00           H  
ATOM     56  HE3 LYS A   2      24.945  -6.537  21.386  1.00  0.00           H  
ATOM     57  HZ1 LYS A   2      26.759  -5.066  20.947  1.00  0.00           H  
ATOM     58  HZ2 LYS A   2      27.564  -6.253  20.056  1.00  0.00           H  
ATOM     59  N   LYS A   3      25.716 -10.945  16.187  1.00  0.00           N  
ATOM     60  CA  LYS A   3      24.932 -10.707  14.985  1.00  0.00           C  
ATOM     61  C   LYS A   3      23.559 -11.357  15.172  1.00  0.00           C  
ATOM     62  O   LYS A   3      23.418 -12.253  16.002  1.00  0.00           O  
ATOM     63  CB  LYS A   3      25.696 -11.268  13.773  1.00  0.00           C  
ATOM     64  CG  LYS A   3      25.056 -10.890  12.429  1.00  0.00           C  
ATOM     65  CD  LYS A   3      25.952 -11.237  11.233  1.00  0.00           C  
ATOM     66  CE  LYS A   3      27.185 -10.328  11.128  1.00  0.00           C  
ATOM     67  NZ  LYS A   3      27.888 -10.592   9.887  1.00  0.00           N  
ATOM     68  H   LYS A   3      25.432 -11.727  16.760  1.00  0.00           H  
ATOM     69  HA  LYS A   3      24.795  -9.631  14.860  1.00  0.00           H  
ATOM     70  HB2 LYS A   3      26.706 -10.861  13.803  1.00  0.00           H  
ATOM     71  HB3 LYS A   3      25.762 -12.354  13.850  1.00  0.00           H  
ATOM     72  HG2 LYS A   3      24.127 -11.445  12.312  1.00  0.00           H  
ATOM     73  HG3 LYS A   3      24.835  -9.822  12.410  1.00  0.00           H  
ATOM     74  HD2 LYS A   3      26.267 -12.280  11.301  1.00  0.00           H  
ATOM     75  HD3 LYS A   3      25.357 -11.113  10.326  1.00  0.00           H  
ATOM     76  HE2 LYS A   3      26.873  -9.283  11.143  1.00  0.00           H  
ATOM     77  HE3 LYS A   3      27.866 -10.508  11.959  1.00  0.00           H  
ATOM     78  HZ1 LYS A   3      28.760 -10.089   9.801  1.00  0.00           H  
ATOM     79  HZ2 LYS A   3      27.302 -10.522   9.068  1.00  0.00           H  
ATOM     80  N   TRP A   4      22.562 -10.907  14.398  1.00  0.00           N  
ATOM     81  CA  TRP A   4      21.225 -11.479  14.350  1.00  0.00           C  
ATOM     82  C   TRP A   4      20.559 -11.039  13.045  1.00  0.00           C  
ATOM     83  O   TRP A   4      20.946 -10.033  12.452  1.00  0.00           O  
ATOM     84  CB  TRP A   4      20.363 -11.024  15.540  1.00  0.00           C  
ATOM     85  CG  TRP A   4      20.754 -11.525  16.895  1.00  0.00           C  
ATOM     86  CD1 TRP A   4      21.177 -10.764  17.930  1.00  0.00           C  
ATOM     87  CD2 TRP A   4      20.791 -12.900  17.373  1.00  0.00           C  
ATOM     88  NE1 TRP A   4      21.471 -11.568  19.013  1.00  0.00           N  
ATOM     89  CE2 TRP A   4      21.257 -12.898  18.721  1.00  0.00           C  
ATOM     90  CE3 TRP A   4      20.493 -14.154  16.797  1.00  0.00           C  
ATOM     91  CZ2 TRP A   4      21.413 -14.080  19.460  1.00  0.00           C  
ATOM     92  CZ3 TRP A   4      20.662 -15.346  17.525  1.00  0.00           C  
ATOM     93  CH2 TRP A   4      21.114 -15.312  18.855  1.00  0.00           C  
ATOM     94  H   TRP A   4      22.840 -10.384  13.581  1.00  0.00           H  
ATOM     95  HA  TRP A   4      21.305 -12.563  14.261  1.00  0.00           H  
ATOM     96  HB2 TRP A   4      20.351  -9.933  15.558  1.00  0.00           H  
ATOM     97  HB3 TRP A   4      19.340 -11.362  15.372  1.00  0.00           H  
ATOM     98  HD1 TRP A   4      21.279  -9.689  17.912  1.00  0.00           H  
ATOM     99  HE1 TRP A   4      21.809 -11.244  19.909  1.00  0.00           H  
ATOM    100  HE3 TRP A   4      20.138 -14.200  15.778  1.00  0.00           H  
ATOM    101  HZ2 TRP A   4      21.765 -14.044  20.481  1.00  0.00           H  
ATOM    102  HZ3 TRP A   4      20.447 -16.290  17.050  1.00  0.00           H  
ATOM    103  HH2 TRP A   4      21.234 -16.231  19.410  1.00  0.00           H  
ATOM    104  N   SER A   5      19.555 -11.812  12.612  1.00  0.00           N  
ATOM    105  CA  SER A   5      18.719 -11.552  11.446  1.00  0.00           C  
ATOM    106  C   SER A   5      17.251 -11.520  11.877  1.00  0.00           C  
ATOM    107  O   SER A   5      16.907 -12.034  12.941  1.00  0.00           O  
ATOM    108  CB  SER A   5      18.971 -12.631  10.386  1.00  0.00           C  
ATOM    109  OG  SER A   5      18.705 -13.918  10.902  1.00  0.00           O  
ATOM    110  H   SER A   5      19.324 -12.632  13.154  1.00  0.00           H  
ATOM    111  HA  SER A   5      18.976 -10.588  11.004  1.00  0.00           H  
ATOM    112  HB2 SER A   5      18.328 -12.454   9.523  1.00  0.00           H  
ATOM    113  HB3 SER A   5      20.011 -12.586  10.062  1.00  0.00           H  
ATOM    114  HG  SER A   5      19.328 -14.103  11.608  1.00  0.00           H  
ATOM    115  N   ASP A   6      16.389 -10.902  11.059  1.00  0.00           N  
ATOM    116  CA  ASP A   6      14.977 -10.720  11.353  1.00  0.00           C  
ATOM    117  C   ASP A   6      14.224 -10.361  10.068  1.00  0.00           C  
ATOM    118  O   ASP A   6      14.835  -9.912   9.100  1.00  0.00           O  
ATOM    119  CB  ASP A   6      14.817  -9.619  12.417  1.00  0.00           C  
ATOM    120  CG  ASP A   6      13.370  -9.407  12.859  1.00  0.00           C  
ATOM    121  OD1 ASP A   6      12.615 -10.372  12.954  1.00  0.00           O  
ATOM    122  OD2 ASP A   6      13.012  -8.118  13.121  1.00  0.00           O  
ATOM    123  H   ASP A   6      16.713 -10.528  10.182  1.00  0.00           H  
ATOM    124  HA  ASP A   6      14.592 -11.664  11.731  1.00  0.00           H  
ATOM    125  HB2 ASP A   6      15.395  -9.877  13.305  1.00  0.00           H  
ATOM    126  HB3 ASP A   6      15.206  -8.683  12.015  1.00  0.00           H  
ATOM    127  HD2 ASP A   6      12.086  -8.037  13.361  1.00  0.00           H  
ATOM    128  N   THR A   7      12.898 -10.553  10.086  1.00  0.00           N  
ATOM    129  CA  THR A   7      11.954 -10.144   9.051  1.00  0.00           C  
ATOM    130  C   THR A   7      12.127 -10.975   7.777  1.00  0.00           C  
ATOM    131  O   THR A   7      12.977 -10.675   6.941  1.00  0.00           O  
ATOM    132  CB  THR A   7      12.028  -8.627   8.793  1.00  0.00           C  
ATOM    133  OG1 THR A   7      11.947  -7.936  10.024  1.00  0.00           O  
ATOM    134  CG2 THR A   7      10.870  -8.166   7.901  1.00  0.00           C  
ATOM    135  H   THR A   7      12.500 -10.925  10.937  1.00  0.00           H  
ATOM    136  HA  THR A   7      10.958 -10.343   9.449  1.00  0.00           H  
ATOM    137  HB  THR A   7      12.968  -8.365   8.307  1.00  0.00           H  
ATOM    138  HG1 THR A   7      12.038  -6.996   9.855  1.00  0.00           H  
ATOM    139 HG21 THR A   7      10.930  -7.087   7.756  1.00  0.00           H  
ATOM    140 HG22 THR A   7      10.925  -8.652   6.925  1.00  0.00           H  
ATOM    141 HG23 THR A   7       9.918  -8.409   8.370  1.00  0.00           H  
ATOM    142  N   GLU A   8      11.289 -12.007   7.623  1.00  0.00           N  
ATOM    143  CA  GLU A   8      11.245 -12.869   6.452  1.00  0.00           C  
ATOM    144  C   GLU A   8       9.804 -13.340   6.257  1.00  0.00           C  
ATOM    145  O   GLU A   8       9.091 -13.559   7.235  1.00  0.00           O  
ATOM    146  CB  GLU A   8      12.213 -14.043   6.654  1.00  0.00           C  
ATOM    147  CG  GLU A   8      12.291 -14.951   5.422  1.00  0.00           C  
ATOM    148  CD  GLU A   8      13.353 -16.030   5.601  1.00  0.00           C  
ATOM    149  OE1 GLU A   8      14.409 -15.949   4.977  1.00  0.00           O  
ATOM    150  OE2 GLU A   8      13.041 -17.037   6.464  1.00  0.00           O  
ATOM    151  H   GLU A   8      10.604 -12.193   8.343  1.00  0.00           H  
ATOM    152  HA  GLU A   8      11.554 -12.300   5.574  1.00  0.00           H  
ATOM    153  HB2 GLU A   8      13.210 -13.645   6.849  1.00  0.00           H  
ATOM    154  HB3 GLU A   8      11.898 -14.632   7.519  1.00  0.00           H  
ATOM    155  HG2 GLU A   8      11.330 -15.440   5.255  1.00  0.00           H  
ATOM    156  HG3 GLU A   8      12.535 -14.350   4.545  1.00  0.00           H  
ATOM    157  HE2 GLU A   8      13.741 -17.688   6.536  1.00  0.00           H  
ATOM    158  N   VAL A   9       9.374 -13.479   4.997  1.00  0.00           N  
ATOM    159  CA  VAL A   9       8.033 -13.933   4.660  1.00  0.00           C  
ATOM    160  C   VAL A   9       7.866 -15.398   5.076  1.00  0.00           C  
ATOM    161  O   VAL A   9       8.716 -16.234   4.775  1.00  0.00           O  
ATOM    162  CB  VAL A   9       7.742 -13.679   3.169  1.00  0.00           C  
ATOM    163  CG1 VAL A   9       8.594 -14.532   2.221  1.00  0.00           C  
ATOM    164  CG2 VAL A   9       6.255 -13.888   2.859  1.00  0.00           C  
ATOM    165  H   VAL A   9      10.012 -13.297   4.238  1.00  0.00           H  
ATOM    166  HA  VAL A   9       7.333 -13.319   5.233  1.00  0.00           H  
ATOM    167  HB  VAL A   9       7.967 -12.632   2.962  1.00  0.00           H  
ATOM    168 HG11 VAL A   9       8.309 -15.583   2.289  1.00  0.00           H  
ATOM    169 HG12 VAL A   9       8.436 -14.198   1.195  1.00  0.00           H  
ATOM    170 HG13 VAL A   9       9.651 -14.431   2.460  1.00  0.00           H  
ATOM    171 HG21 VAL A   9       5.961 -14.919   3.062  1.00  0.00           H  
ATOM    172 HG22 VAL A   9       5.658 -13.216   3.473  1.00  0.00           H  
ATOM    173 HG23 VAL A   9       6.062 -13.665   1.810  1.00  0.00           H  
ATOM    174  N   PHE A  10       6.789 -15.683   5.817  1.00  0.00           N  
ATOM    175  CA  PHE A  10       6.534 -16.966   6.454  1.00  0.00           C  
ATOM    176  C   PHE A  10       5.064 -17.358   6.280  1.00  0.00           C  
ATOM    177  O   PHE A  10       4.696 -17.867   5.223  1.00  0.00           O  
ATOM    178  CB  PHE A  10       7.034 -16.952   7.916  1.00  0.00           C  
ATOM    179  CG  PHE A  10       6.945 -15.667   8.741  1.00  0.00           C  
ATOM    180  CD1 PHE A  10       5.938 -14.696   8.544  1.00  0.00           C  
ATOM    181  CD2 PHE A  10       7.896 -15.462   9.761  1.00  0.00           C  
ATOM    182  CE1 PHE A  10       5.901 -13.536   9.335  1.00  0.00           C  
ATOM    183  CE2 PHE A  10       7.860 -14.301  10.551  1.00  0.00           C  
ATOM    184  CZ  PHE A  10       6.864 -13.335  10.337  1.00  0.00           C  
ATOM    185  H   PHE A  10       6.177 -14.925   6.070  1.00  0.00           H  
ATOM    186  HA  PHE A  10       7.114 -17.743   5.952  1.00  0.00           H  
ATOM    187  HB2 PHE A  10       6.565 -17.766   8.472  1.00  0.00           H  
ATOM    188  HB3 PHE A  10       8.098 -17.192   7.853  1.00  0.00           H  
ATOM    189  HD1 PHE A  10       5.188 -14.800   7.781  1.00  0.00           H  
ATOM    190  HD2 PHE A  10       8.667 -16.199   9.939  1.00  0.00           H  
ATOM    191  HE1 PHE A  10       5.128 -12.801   9.173  1.00  0.00           H  
ATOM    192  HE2 PHE A  10       8.597 -14.153  11.326  1.00  0.00           H  
ATOM    193  HZ  PHE A  10       6.834 -12.441  10.943  1.00  0.00           H  
ATOM    194  N   GLU A  11       4.236 -17.129   7.304  1.00  0.00           N  
ATOM    195  CA  GLU A  11       2.808 -17.404   7.323  1.00  0.00           C  
ATOM    196  C   GLU A  11       2.032 -16.122   7.636  1.00  0.00           C  
ATOM    197  O   GLU A  11       2.614 -15.128   8.066  1.00  0.00           O  
ATOM    198  CB  GLU A  11       2.511 -18.493   8.369  1.00  0.00           C  
ATOM    199  CG  GLU A  11       2.920 -18.102   9.790  1.00  0.00           C  
ATOM    200  CD  GLU A  11       2.493 -19.161  10.803  1.00  0.00           C  
ATOM    201  OE1 GLU A  11       1.610 -18.899  11.616  1.00  0.00           O  
ATOM    202  OE2 GLU A  11       3.141 -20.358  10.726  1.00  0.00           O  
ATOM    203  H   GLU A  11       4.613 -16.724   8.144  1.00  0.00           H  
ATOM    204  HA  GLU A  11       2.482 -17.794   6.358  1.00  0.00           H  
ATOM    205  HB2 GLU A  11       1.441 -18.677   8.396  1.00  0.00           H  
ATOM    206  HB3 GLU A  11       3.020 -19.415   8.083  1.00  0.00           H  
ATOM    207  HG2 GLU A  11       4.001 -17.986   9.837  1.00  0.00           H  
ATOM    208  HG3 GLU A  11       2.436 -17.162  10.055  1.00  0.00           H  
ATOM    209  HE2 GLU A  11       2.828 -20.987  11.380  1.00  0.00           H  
ATOM    210  N   MET A  12       0.707 -16.189   7.451  1.00  0.00           N  
ATOM    211  CA  MET A  12      -0.271 -15.178   7.843  1.00  0.00           C  
ATOM    212  C   MET A  12      -0.136 -13.864   7.073  1.00  0.00           C  
ATOM    213  O   MET A  12       0.844 -13.638   6.374  1.00  0.00           O  
ATOM    214  CB  MET A  12      -0.224 -14.928   9.358  1.00  0.00           C  
ATOM    215  CG  MET A  12      -0.764 -16.139  10.127  1.00  0.00           C  
ATOM    216  SD  MET A  12      -0.845 -15.908  11.922  1.00  0.00           S  
ATOM    217  CE  MET A  12      -1.720 -17.429  12.369  1.00  0.00           C  
ATOM    218  H   MET A  12       0.349 -17.054   7.080  1.00  0.00           H  
ATOM    219  HA  MET A  12      -1.255 -15.578   7.598  1.00  0.00           H  
ATOM    220  HB2 MET A  12       0.788 -14.709   9.695  1.00  0.00           H  
ATOM    221  HB3 MET A  12      -0.835 -14.055   9.575  1.00  0.00           H  
ATOM    222  HG2 MET A  12      -1.769 -16.357   9.770  1.00  0.00           H  
ATOM    223  HG3 MET A  12      -0.132 -17.005   9.928  1.00  0.00           H  
ATOM    224  HE1 MET A  12      -2.697 -17.445  11.885  1.00  0.00           H  
ATOM    225  HE2 MET A  12      -1.851 -17.462  13.451  1.00  0.00           H  
ATOM    226  HE3 MET A  12      -1.141 -18.294  12.047  1.00  0.00           H  
ATOM    227  N   LEU A  13      -1.143 -12.993   7.212  1.00  0.00           N  
ATOM    228  CA  LEU A  13      -1.167 -11.661   6.631  1.00  0.00           C  
ATOM    229  C   LEU A  13      -2.364 -10.874   7.167  1.00  0.00           C  
ATOM    230  O   LEU A  13      -3.354 -11.463   7.595  1.00  0.00           O  
ATOM    231  CB  LEU A  13      -1.121 -11.710   5.098  1.00  0.00           C  
ATOM    232  CG  LEU A  13      -2.116 -12.664   4.418  1.00  0.00           C  
ATOM    233  CD1 LEU A  13      -3.423 -11.938   4.116  1.00  0.00           C  
ATOM    234  CD2 LEU A  13      -1.507 -13.139   3.098  1.00  0.00           C  
ATOM    235  H   LEU A  13      -1.934 -13.246   7.789  1.00  0.00           H  
ATOM    236  HA  LEU A  13      -0.272 -11.139   6.963  1.00  0.00           H  
ATOM    237  HB2 LEU A  13      -1.274 -10.706   4.712  1.00  0.00           H  
ATOM    238  HB3 LEU A  13      -0.115 -12.005   4.816  1.00  0.00           H  
ATOM    239  HG  LEU A  13      -2.322 -13.541   5.032  1.00  0.00           H  
ATOM    240 HD11 LEU A  13      -4.119 -12.614   3.622  1.00  0.00           H  
ATOM    241 HD12 LEU A  13      -3.878 -11.563   5.030  1.00  0.00           H  
ATOM    242 HD13 LEU A  13      -3.202 -11.105   3.453  1.00  0.00           H  
ATOM    243 HD21 LEU A  13      -2.239 -13.717   2.538  1.00  0.00           H  
ATOM    244 HD22 LEU A  13      -1.186 -12.282   2.503  1.00  0.00           H  
ATOM    245 HD23 LEU A  13      -0.648 -13.774   3.310  1.00  0.00           H  
ATOM    246  N   LYS A  14      -2.238  -9.543   7.170  1.00  0.00           N  
ATOM    247  CA  LYS A  14      -3.168  -8.604   7.780  1.00  0.00           C  
ATOM    248  C   LYS A  14      -4.075  -7.999   6.712  1.00  0.00           C  
ATOM    249  O   LYS A  14      -3.610  -7.689   5.618  1.00  0.00           O  
ATOM    250  CB  LYS A  14      -2.338  -7.527   8.496  1.00  0.00           C  
ATOM    251  CG  LYS A  14      -3.181  -6.378   9.064  1.00  0.00           C  
ATOM    252  CD  LYS A  14      -3.322  -5.178   8.116  1.00  0.00           C  
ATOM    253  CE  LYS A  14      -2.029  -4.361   8.018  1.00  0.00           C  
ATOM    254  NZ  LYS A  14      -2.309  -3.080   7.397  1.00  0.00           N  
ATOM    255  H   LYS A  14      -1.409  -9.145   6.750  1.00  0.00           H  
ATOM    256  HA  LYS A  14      -3.779  -9.117   8.524  1.00  0.00           H  
ATOM    257  HB2 LYS A  14      -1.826  -8.014   9.327  1.00  0.00           H  
ATOM    258  HB3 LYS A  14      -1.582  -7.130   7.817  1.00  0.00           H  
ATOM    259  HG2 LYS A  14      -4.168  -6.762   9.309  1.00  0.00           H  
ATOM    260  HG3 LYS A  14      -2.722  -6.030   9.990  1.00  0.00           H  
ATOM    261  HD2 LYS A  14      -3.596  -5.492   7.113  1.00  0.00           H  
ATOM    262  HD3 LYS A  14      -4.122  -4.544   8.497  1.00  0.00           H  
ATOM    263  HE2 LYS A  14      -1.605  -4.193   9.007  1.00  0.00           H  
ATOM    264  HE3 LYS A  14      -1.309  -4.906   7.412  1.00  0.00           H  
ATOM    265  HZ1 LYS A  14      -1.484  -2.529   7.213  1.00  0.00           H  
ATOM    266  HZ2 LYS A  14      -3.044  -2.560   7.853  1.00  0.00           H  
ATOM    267  N   ARG A  15      -5.356  -7.791   7.041  1.00  0.00           N  
ATOM    268  CA  ARG A  15      -6.326  -7.148   6.177  1.00  0.00           C  
ATOM    269  C   ARG A  15      -6.208  -5.631   6.309  1.00  0.00           C  
ATOM    270  O   ARG A  15      -6.552  -5.063   7.346  1.00  0.00           O  
ATOM    271  CB  ARG A  15      -7.725  -7.649   6.531  1.00  0.00           C  
ATOM    272  CG  ARG A  15      -8.810  -6.885   5.777  1.00  0.00           C  
ATOM    273  CD  ARG A  15     -10.188  -7.504   6.037  1.00  0.00           C  
ATOM    274  NE  ARG A  15     -11.225  -6.468   6.114  1.00  0.00           N  
ATOM    275  CZ  ARG A  15     -11.443  -5.681   7.185  1.00  0.00           C  
ATOM    276  NH1 ARG A  15     -10.751  -5.849   8.322  1.00  0.00           N  
ATOM    277  NH2 ARG A  15     -12.366  -4.713   7.114  1.00  0.00           N  
ATOM    278  H   ARG A  15      -5.680  -8.020   7.967  1.00  0.00           H  
ATOM    279  HA  ARG A  15      -6.140  -7.437   5.149  1.00  0.00           H  
ATOM    280  HB2 ARG A  15      -7.790  -8.708   6.283  1.00  0.00           H  
ATOM    281  HB3 ARG A  15      -7.891  -7.505   7.594  1.00  0.00           H  
ATOM    282  HG2 ARG A  15      -8.800  -5.854   6.131  1.00  0.00           H  
ATOM    283  HG3 ARG A  15      -8.587  -6.896   4.710  1.00  0.00           H  
ATOM    284  HD2 ARG A  15     -10.425  -8.191   5.221  1.00  0.00           H  
ATOM    285  HD3 ARG A  15     -10.184  -8.080   6.962  1.00  0.00           H  
ATOM    286  HE  ARG A  15     -11.780  -6.320   5.282  1.00  0.00           H  
ATOM    287 HH11 ARG A  15     -10.057  -6.582   8.405  1.00  0.00           H  
ATOM    288 HH12 ARG A  15     -10.931  -5.255   9.120  1.00  0.00           H  
ATOM    289 HH21 ARG A  15     -12.895  -4.575   6.265  1.00  0.00           H  
ATOM    290 HH22 ARG A  15     -12.534  -4.110   7.905  1.00  0.00           H  
ATOM    291  N   MET A  16      -5.739  -4.991   5.236  1.00  0.00           N  
ATOM    292  CA  MET A  16      -5.668  -3.549   5.103  1.00  0.00           C  
ATOM    293  C   MET A  16      -6.953  -3.064   4.429  1.00  0.00           C  
ATOM    294  O   MET A  16      -7.115  -3.174   3.214  1.00  0.00           O  
ATOM    295  CB  MET A  16      -4.414  -3.155   4.320  1.00  0.00           C  
ATOM    296  CG  MET A  16      -4.113  -4.029   3.103  1.00  0.00           C  
ATOM    297  SD  MET A  16      -2.895  -3.375   1.958  1.00  0.00           S  
ATOM    298  CE  MET A  16      -3.737  -1.873   1.390  1.00  0.00           C  
ATOM    299  H   MET A  16      -5.462  -5.532   4.426  1.00  0.00           H  
ATOM    300  HA  MET A  16      -5.531  -3.056   6.068  1.00  0.00           H  
ATOM    301  HB2 MET A  16      -4.581  -2.137   3.996  1.00  0.00           H  
ATOM    302  HB3 MET A  16      -3.547  -3.179   4.977  1.00  0.00           H  
ATOM    303  HG2 MET A  16      -3.767  -5.010   3.424  1.00  0.00           H  
ATOM    304  HG3 MET A  16      -5.016  -4.137   2.524  1.00  0.00           H  
ATOM    305  HE1 MET A  16      -4.797  -2.064   1.238  1.00  0.00           H  
ATOM    306  HE2 MET A  16      -3.299  -1.548   0.449  1.00  0.00           H  
ATOM    307  HE3 MET A  16      -3.618  -1.085   2.130  1.00  0.00           H  
ATOM    308  N   TYR A  17      -7.871  -2.508   5.222  1.00  0.00           N  
ATOM    309  CA  TYR A  17      -9.046  -1.843   4.685  1.00  0.00           C  
ATOM    310  C   TYR A  17      -8.579  -0.515   4.099  1.00  0.00           C  
ATOM    311  O   TYR A  17      -7.883   0.234   4.777  1.00  0.00           O  
ATOM    312  CB  TYR A  17     -10.092  -1.651   5.789  1.00  0.00           C  
ATOM    313  CG  TYR A  17     -11.366  -0.958   5.340  1.00  0.00           C  
ATOM    314  CD1 TYR A  17     -12.424  -1.712   4.802  1.00  0.00           C  
ATOM    315  CD2 TYR A  17     -11.528   0.427   5.534  1.00  0.00           C  
ATOM    316  CE1 TYR A  17     -13.644  -1.094   4.481  1.00  0.00           C  
ATOM    317  CE2 TYR A  17     -12.766   1.036   5.260  1.00  0.00           C  
ATOM    318  CZ  TYR A  17     -13.824   0.277   4.729  1.00  0.00           C  
ATOM    319  OH  TYR A  17     -15.026   0.865   4.463  1.00  0.00           O  
ATOM    320  H   TYR A  17      -7.647  -2.379   6.198  1.00  0.00           H  
ATOM    321  HA  TYR A  17      -9.485  -2.461   3.903  1.00  0.00           H  
ATOM    322  HB2 TYR A  17     -10.352  -2.632   6.187  1.00  0.00           H  
ATOM    323  HB3 TYR A  17      -9.653  -1.077   6.605  1.00  0.00           H  
ATOM    324  HD1 TYR A  17     -12.313  -2.774   4.660  1.00  0.00           H  
ATOM    325  HD2 TYR A  17     -10.714   1.025   5.915  1.00  0.00           H  
ATOM    326  HE1 TYR A  17     -14.455  -1.680   4.075  1.00  0.00           H  
ATOM    327  HE2 TYR A  17     -12.904   2.086   5.475  1.00  0.00           H  
ATOM    328  HH  TYR A  17     -15.067   1.779   4.752  1.00  0.00           H  
ATOM    329  N   ALA A  18      -8.922  -0.238   2.839  1.00  0.00           N  
ATOM    330  CA  ALA A  18      -8.538   0.991   2.165  1.00  0.00           C  
ATOM    331  C   ALA A  18      -9.746   1.593   1.468  1.00  0.00           C  
ATOM    332  O   ALA A  18     -10.209   1.105   0.439  1.00  0.00           O  
ATOM    333  CB  ALA A  18      -7.366   0.758   1.222  1.00  0.00           C  
ATOM    334  H   ALA A  18      -9.482  -0.903   2.323  1.00  0.00           H  
ATOM    335  HA  ALA A  18      -8.188   1.715   2.894  1.00  0.00           H  
ATOM    336  HB1 ALA A  18      -7.116   1.704   0.740  1.00  0.00           H  
ATOM    337  HB2 ALA A  18      -6.512   0.413   1.804  1.00  0.00           H  
ATOM    338  HB3 ALA A  18      -7.632   0.016   0.474  1.00  0.00           H  
ATOM    339  N   ARG A  19     -10.249   2.665   2.076  1.00  0.00           N  
ATOM    340  CA  ARG A  19     -11.434   3.387   1.677  1.00  0.00           C  
ATOM    341  C   ARG A  19     -10.989   4.528   0.766  1.00  0.00           C  
ATOM    342  O   ARG A  19     -10.447   5.522   1.248  1.00  0.00           O  
ATOM    343  CB  ARG A  19     -12.140   3.899   2.946  1.00  0.00           C  
ATOM    344  CG  ARG A  19     -13.655   3.719   2.888  1.00  0.00           C  
ATOM    345  CD  ARG A  19     -14.252   4.318   1.613  1.00  0.00           C  
ATOM    346  NE  ARG A  19     -15.622   4.788   1.838  1.00  0.00           N  
ATOM    347  CZ  ARG A  19     -16.691   4.023   2.117  1.00  0.00           C  
ATOM    348  NH1 ARG A  19     -16.587   2.688   2.188  1.00  0.00           N  
ATOM    349  NH2 ARG A  19     -17.880   4.604   2.333  1.00  0.00           N  
ATOM    350  H   ARG A  19      -9.777   2.985   2.903  1.00  0.00           H  
ATOM    351  HA  ARG A  19     -12.095   2.695   1.152  1.00  0.00           H  
ATOM    352  HB2 ARG A  19     -11.791   3.343   3.815  1.00  0.00           H  
ATOM    353  HB3 ARG A  19     -11.918   4.949   3.124  1.00  0.00           H  
ATOM    354  HG2 ARG A  19     -13.885   2.657   2.927  1.00  0.00           H  
ATOM    355  HG3 ARG A  19     -14.080   4.209   3.764  1.00  0.00           H  
ATOM    356  HD2 ARG A  19     -13.657   5.179   1.313  1.00  0.00           H  
ATOM    357  HD3 ARG A  19     -14.214   3.584   0.806  1.00  0.00           H  
ATOM    358  HE  ARG A  19     -15.738   5.790   1.832  1.00  0.00           H  
ATOM    359 HH11 ARG A  19     -15.695   2.246   2.034  1.00  0.00           H  
ATOM    360 HH12 ARG A  19     -17.392   2.121   2.406  1.00  0.00           H  
ATOM    361 HH21 ARG A  19     -17.972   5.608   2.279  1.00  0.00           H  
ATOM    362 HH22 ARG A  19     -18.692   4.042   2.546  1.00  0.00           H  
ATOM    363  N   VAL A  20     -11.183   4.370  -0.549  1.00  0.00           N  
ATOM    364  CA  VAL A  20     -10.725   5.336  -1.537  1.00  0.00           C  
ATOM    365  C   VAL A  20     -11.921   6.161  -2.021  1.00  0.00           C  
ATOM    366  O   VAL A  20     -12.844   5.631  -2.638  1.00  0.00           O  
ATOM    367  CB  VAL A  20      -9.959   4.635  -2.672  1.00  0.00           C  
ATOM    368  CG1 VAL A  20      -9.264   5.676  -3.561  1.00  0.00           C  
ATOM    369  CG2 VAL A  20      -8.904   3.677  -2.097  1.00  0.00           C  
ATOM    370  H   VAL A  20     -11.659   3.539  -0.882  1.00  0.00           H  
ATOM    371  HA  VAL A  20     -10.006   6.015  -1.077  1.00  0.00           H  
ATOM    372  HB  VAL A  20     -10.645   4.056  -3.283  1.00  0.00           H  
ATOM    373 HG11 VAL A  20      -8.480   6.183  -3.001  1.00  0.00           H  
ATOM    374 HG12 VAL A  20      -8.817   5.184  -4.424  1.00  0.00           H  
ATOM    375 HG13 VAL A  20      -9.983   6.414  -3.915  1.00  0.00           H  
ATOM    376 HG21 VAL A  20      -8.359   4.157  -1.288  1.00  0.00           H  
ATOM    377 HG22 VAL A  20      -9.386   2.777  -1.713  1.00  0.00           H  
ATOM    378 HG23 VAL A  20      -8.188   3.394  -2.864  1.00  0.00           H  
ATOM    379  N   TYR A  21     -11.899   7.458  -1.704  1.00  0.00           N  
ATOM    380  CA  TYR A  21     -12.947   8.418  -2.020  1.00  0.00           C  
ATOM    381  C   TYR A  21     -12.550   9.240  -3.245  1.00  0.00           C  
ATOM    382  O   TYR A  21     -11.363   9.460  -3.481  1.00  0.00           O  
ATOM    383  CB  TYR A  21     -13.139   9.355  -0.821  1.00  0.00           C  
ATOM    384  CG  TYR A  21     -13.699   8.697   0.425  1.00  0.00           C  
ATOM    385  CD1 TYR A  21     -12.842   8.016   1.309  1.00  0.00           C  
ATOM    386  CD2 TYR A  21     -15.053   8.874   0.768  1.00  0.00           C  
ATOM    387  CE1 TYR A  21     -13.312   7.588   2.560  1.00  0.00           C  
ATOM    388  CE2 TYR A  21     -15.534   8.403   2.001  1.00  0.00           C  
ATOM    389  CZ  TYR A  21     -14.661   7.771   2.904  1.00  0.00           C  
ATOM    390  OH  TYR A  21     -15.123   7.320   4.106  1.00  0.00           O  
ATOM    391  H   TYR A  21     -11.105   7.810  -1.189  1.00  0.00           H  
ATOM    392  HA  TYR A  21     -13.889   7.905  -2.213  1.00  0.00           H  
ATOM    393  HB2 TYR A  21     -12.174   9.799  -0.575  1.00  0.00           H  
ATOM    394  HB3 TYR A  21     -13.802  10.170  -1.114  1.00  0.00           H  
ATOM    395  HD1 TYR A  21     -11.815   7.834   1.037  1.00  0.00           H  
ATOM    396  HD2 TYR A  21     -15.723   9.388   0.094  1.00  0.00           H  
ATOM    397  HE1 TYR A  21     -12.633   7.115   3.252  1.00  0.00           H  
ATOM    398  HE2 TYR A  21     -16.574   8.545   2.258  1.00  0.00           H  
ATOM    399  HH  TYR A  21     -16.034   7.567   4.283  1.00  0.00           H  
ATOM    400  N   GLY A  22     -13.551   9.741  -3.979  1.00  0.00           N  
ATOM    401  CA  GLY A  22     -13.383  10.712  -5.049  1.00  0.00           C  
ATOM    402  C   GLY A  22     -13.860  10.164  -6.387  1.00  0.00           C  
ATOM    403  O   GLY A  22     -14.607   9.191  -6.430  1.00  0.00           O  
ATOM    404  H   GLY A  22     -14.496   9.467  -3.756  1.00  0.00           H  
ATOM    405  HA2 GLY A  22     -13.988  11.589  -4.814  1.00  0.00           H  
ATOM    406  HA3 GLY A  22     -12.343  11.017  -5.144  1.00  0.00           H  
ATOM    407  N   LEU A  23     -13.413  10.784  -7.484  1.00  0.00           N  
ATOM    408  CA  LEU A  23     -13.856  10.438  -8.832  1.00  0.00           C  
ATOM    409  C   LEU A  23     -13.077   9.236  -9.391  1.00  0.00           C  
ATOM    410  O   LEU A  23     -12.947   9.088 -10.603  1.00  0.00           O  
ATOM    411  CB  LEU A  23     -13.757  11.684  -9.725  1.00  0.00           C  
ATOM    412  CG  LEU A  23     -14.686  11.664 -10.955  1.00  0.00           C  
ATOM    413  CD1 LEU A  23     -16.149  11.924 -10.570  1.00  0.00           C  
ATOM    414  CD2 LEU A  23     -14.242  12.746 -11.945  1.00  0.00           C  
ATOM    415  H   LEU A  23     -12.754  11.547  -7.384  1.00  0.00           H  
ATOM    416  HA  LEU A  23     -14.903  10.163  -8.771  1.00  0.00           H  
ATOM    417  HB2 LEU A  23     -14.037  12.548  -9.124  1.00  0.00           H  
ATOM    418  HB3 LEU A  23     -12.720  11.806 -10.040  1.00  0.00           H  
ATOM    419  HG  LEU A  23     -14.626  10.702 -11.463  1.00  0.00           H  
ATOM    420 HD11 LEU A  23     -16.763  11.948 -11.469  1.00  0.00           H  
ATOM    421 HD12 LEU A  23     -16.527  11.137  -9.920  1.00  0.00           H  
ATOM    422 HD13 LEU A  23     -16.237  12.883 -10.058  1.00  0.00           H  
ATOM    423 HD21 LEU A  23     -14.910  12.759 -12.807  1.00  0.00           H  
ATOM    424 HD22 LEU A  23     -14.259  13.725 -11.464  1.00  0.00           H  
ATOM    425 HD23 LEU A  23     -13.232  12.533 -12.296  1.00  0.00           H  
ATOM    426  N   VAL A  24     -12.561   8.369  -8.509  1.00  0.00           N  
ATOM    427  CA  VAL A  24     -11.781   7.189  -8.873  1.00  0.00           C  
ATOM    428  C   VAL A  24     -12.622   6.094  -9.544  1.00  0.00           C  
ATOM    429  O   VAL A  24     -12.066   5.154 -10.111  1.00  0.00           O  
ATOM    430  CB  VAL A  24     -10.988   6.674  -7.662  1.00  0.00           C  
ATOM    431  CG1 VAL A  24     -10.015   7.745  -7.149  1.00  0.00           C  
ATOM    432  CG2 VAL A  24     -11.914   6.218  -6.532  1.00  0.00           C  
ATOM    433  H   VAL A  24     -12.710   8.546  -7.524  1.00  0.00           H  
ATOM    434  HA  VAL A  24     -11.052   7.484  -9.622  1.00  0.00           H  
ATOM    435  HB  VAL A  24     -10.399   5.818  -7.986  1.00  0.00           H  
ATOM    436 HG11 VAL A  24     -10.558   8.612  -6.774  1.00  0.00           H  
ATOM    437 HG12 VAL A  24      -9.412   7.333  -6.340  1.00  0.00           H  
ATOM    438 HG13 VAL A  24      -9.354   8.065  -7.953  1.00  0.00           H  
ATOM    439 HG21 VAL A  24     -12.446   7.065  -6.102  1.00  0.00           H  
ATOM    440 HG22 VAL A  24     -12.635   5.503  -6.922  1.00  0.00           H  
ATOM    441 HG23 VAL A  24     -11.323   5.736  -5.756  1.00  0.00           H  
ATOM    442  N   GLN A  25     -13.951   6.237  -9.516  1.00  0.00           N  
ATOM    443  CA  GLN A  25     -14.882   5.463 -10.322  1.00  0.00           C  
ATOM    444  C   GLN A  25     -14.556   5.634 -11.809  1.00  0.00           C  
ATOM    445  O   GLN A  25     -14.018   6.660 -12.223  1.00  0.00           O  
ATOM    446  CB  GLN A  25     -16.316   5.919 -10.021  1.00  0.00           C  
ATOM    447  CG  GLN A  25     -16.976   5.071  -8.928  1.00  0.00           C  
ATOM    448  CD  GLN A  25     -16.327   5.145  -7.546  1.00  0.00           C  
ATOM    449  OE1 GLN A  25     -15.500   6.007  -7.273  1.00  0.00           O  
ATOM    450  NE2 GLN A  25     -16.723   4.235  -6.655  1.00  0.00           N  
ATOM    451  H   GLN A  25     -14.345   6.985  -8.965  1.00  0.00           H  
ATOM    452  HA  GLN A  25     -14.815   4.410 -10.056  1.00  0.00           H  
ATOM    453  HB2 GLN A  25     -16.341   6.976  -9.753  1.00  0.00           H  
ATOM    454  HB3 GLN A  25     -16.923   5.789 -10.920  1.00  0.00           H  
ATOM    455  HG2 GLN A  25     -17.997   5.421  -8.838  1.00  0.00           H  
ATOM    456  HG3 GLN A  25     -17.001   4.033  -9.258  1.00  0.00           H  
ATOM    457 HE21 GLN A  25     -17.422   3.545  -6.909  1.00  0.00           H  
ATOM    458 HE22 GLN A  25     -16.342   4.239  -5.720  1.00  0.00           H  
ATOM    459  N   GLY A  26     -14.885   4.618 -12.612  1.00  0.00           N  
ATOM    460  CA  GLY A  26     -14.688   4.637 -14.052  1.00  0.00           C  
ATOM    461  C   GLY A  26     -13.255   4.263 -14.425  1.00  0.00           C  
ATOM    462  O   GLY A  26     -13.045   3.262 -15.109  1.00  0.00           O  
ATOM    463  H   GLY A  26     -15.328   3.804 -12.215  1.00  0.00           H  
ATOM    464  HA2 GLY A  26     -15.374   3.916 -14.499  1.00  0.00           H  
ATOM    465  HA3 GLY A  26     -14.928   5.623 -14.448  1.00  0.00           H  
ATOM    466  N   VAL A  27     -12.273   5.067 -13.992  1.00  0.00           N  
ATOM    467  CA  VAL A  27     -10.871   4.862 -14.348  1.00  0.00           C  
ATOM    468  C   VAL A  27     -10.323   3.571 -13.728  1.00  0.00           C  
ATOM    469  O   VAL A  27     -10.922   3.003 -12.813  1.00  0.00           O  
ATOM    470  CB  VAL A  27     -10.007   6.087 -13.986  1.00  0.00           C  
ATOM    471  CG1 VAL A  27     -10.547   7.369 -14.636  1.00  0.00           C  
ATOM    472  CG2 VAL A  27      -9.863   6.316 -12.477  1.00  0.00           C  
ATOM    473  H   VAL A  27     -12.513   5.860 -13.412  1.00  0.00           H  
ATOM    474  HA  VAL A  27     -10.824   4.749 -15.433  1.00  0.00           H  
ATOM    475  HB  VAL A  27      -9.009   5.913 -14.386  1.00  0.00           H  
ATOM    476 HG11 VAL A  27     -11.518   7.637 -14.221  1.00  0.00           H  
ATOM    477 HG12 VAL A  27      -9.856   8.191 -14.450  1.00  0.00           H  
ATOM    478 HG13 VAL A  27     -10.639   7.230 -15.713  1.00  0.00           H  
ATOM    479 HG21 VAL A  27     -10.804   6.669 -12.056  1.00  0.00           H  
ATOM    480 HG22 VAL A  27      -9.554   5.408 -11.964  1.00  0.00           H  
ATOM    481 HG23 VAL A  27      -9.088   7.067 -12.315  1.00  0.00           H  
ATOM    482  N   GLY A  28      -9.164   3.116 -14.222  1.00  0.00           N  
ATOM    483  CA  GLY A  28      -8.526   1.878 -13.792  1.00  0.00           C  
ATOM    484  C   GLY A  28      -7.751   2.044 -12.482  1.00  0.00           C  
ATOM    485  O   GLY A  28      -6.615   1.589 -12.376  1.00  0.00           O  
ATOM    486  H   GLY A  28      -8.718   3.637 -14.962  1.00  0.00           H  
ATOM    487  HA2 GLY A  28      -9.278   1.098 -13.663  1.00  0.00           H  
ATOM    488  HA3 GLY A  28      -7.836   1.560 -14.575  1.00  0.00           H  
ATOM    489  N   PHE A  29      -8.381   2.660 -11.477  1.00  0.00           N  
ATOM    490  CA  PHE A  29      -7.858   2.781 -10.125  1.00  0.00           C  
ATOM    491  C   PHE A  29      -7.737   1.385  -9.514  1.00  0.00           C  
ATOM    492  O   PHE A  29      -6.643   0.946  -9.161  1.00  0.00           O  
ATOM    493  CB  PHE A  29      -8.789   3.690  -9.300  1.00  0.00           C  
ATOM    494  CG  PHE A  29      -8.859   3.367  -7.817  1.00  0.00           C  
ATOM    495  CD1 PHE A  29      -7.688   3.398  -7.033  1.00  0.00           C  
ATOM    496  CD2 PHE A  29     -10.034   2.797  -7.290  1.00  0.00           C  
ATOM    497  CE1 PHE A  29      -7.690   2.842  -5.744  1.00  0.00           C  
ATOM    498  CE2 PHE A  29     -10.018   2.200  -6.019  1.00  0.00           C  
ATOM    499  CZ  PHE A  29      -8.841   2.207  -5.254  1.00  0.00           C  
ATOM    500  H   PHE A  29      -9.324   2.988 -11.640  1.00  0.00           H  
ATOM    501  HA  PHE A  29      -6.859   3.223 -10.162  1.00  0.00           H  
ATOM    502  HB2 PHE A  29      -8.484   4.728  -9.428  1.00  0.00           H  
ATOM    503  HB3 PHE A  29      -9.801   3.609  -9.702  1.00  0.00           H  
ATOM    504  HD1 PHE A  29      -6.769   3.791  -7.431  1.00  0.00           H  
ATOM    505  HD2 PHE A  29     -10.941   2.763  -7.877  1.00  0.00           H  
ATOM    506  HE1 PHE A  29      -6.793   2.879  -5.142  1.00  0.00           H  
ATOM    507  HE2 PHE A  29     -10.902   1.715  -5.636  1.00  0.00           H  
ATOM    508  HZ  PHE A  29      -8.826   1.721  -4.290  1.00  0.00           H  
ATOM    509  N   ARG A  30      -8.871   0.690  -9.400  1.00  0.00           N  
ATOM    510  CA  ARG A  30      -8.945  -0.643  -8.822  1.00  0.00           C  
ATOM    511  C   ARG A  30      -8.115  -1.658  -9.611  1.00  0.00           C  
ATOM    512  O   ARG A  30      -7.667  -2.649  -9.038  1.00  0.00           O  
ATOM    513  CB  ARG A  30     -10.411  -1.063  -8.704  1.00  0.00           C  
ATOM    514  CG  ARG A  30     -11.121  -1.254 -10.051  1.00  0.00           C  
ATOM    515  CD  ARG A  30     -12.626  -1.319  -9.780  1.00  0.00           C  
ATOM    516  NE  ARG A  30     -13.385  -1.925 -10.878  1.00  0.00           N  
ATOM    517  CZ  ARG A  30     -13.717  -1.341 -12.040  1.00  0.00           C  
ATOM    518  NH1 ARG A  30     -13.256  -0.126 -12.369  1.00  0.00           N  
ATOM    519  NH2 ARG A  30     -14.533  -1.999 -12.872  1.00  0.00           N  
ATOM    520  H   ARG A  30      -9.732   1.121  -9.701  1.00  0.00           H  
ATOM    521  HA  ARG A  30      -8.540  -0.588  -7.810  1.00  0.00           H  
ATOM    522  HB2 ARG A  30     -10.455  -2.007  -8.163  1.00  0.00           H  
ATOM    523  HB3 ARG A  30     -10.936  -0.303  -8.122  1.00  0.00           H  
ATOM    524  HG2 ARG A  30     -10.912  -0.422 -10.724  1.00  0.00           H  
ATOM    525  HG3 ARG A  30     -10.780  -2.179 -10.514  1.00  0.00           H  
ATOM    526  HD2 ARG A  30     -12.805  -1.937  -8.898  1.00  0.00           H  
ATOM    527  HD3 ARG A  30     -12.996  -0.312  -9.585  1.00  0.00           H  
ATOM    528  HE  ARG A  30     -13.782  -2.843 -10.700  1.00  0.00           H  
ATOM    529 HH11 ARG A  30     -12.649   0.374 -11.735  1.00  0.00           H  
ATOM    530 HH12 ARG A  30     -13.513   0.299 -13.249  1.00  0.00           H  
ATOM    531 HH21 ARG A  30     -14.916  -2.890 -12.565  1.00  0.00           H  
ATOM    532 HH22 ARG A  30     -14.808  -1.608 -13.762  1.00  0.00           H  
ATOM    533  N   LYS A  31      -7.897  -1.393 -10.907  1.00  0.00           N  
ATOM    534  CA  LYS A  31      -7.037  -2.180 -11.769  1.00  0.00           C  
ATOM    535  C   LYS A  31      -5.568  -1.950 -11.375  1.00  0.00           C  
ATOM    536  O   LYS A  31      -4.829  -2.911 -11.190  1.00  0.00           O  
ATOM    537  CB  LYS A  31      -7.308  -1.825 -13.240  1.00  0.00           C  
ATOM    538  CG  LYS A  31      -7.186  -3.020 -14.194  1.00  0.00           C  
ATOM    539  CD  LYS A  31      -5.812  -3.703 -14.156  1.00  0.00           C  
ATOM    540  CE  LYS A  31      -5.690  -4.780 -15.239  1.00  0.00           C  
ATOM    541  NZ  LYS A  31      -5.596  -4.177 -16.555  1.00  0.00           N  
ATOM    542  H   LYS A  31      -8.239  -0.524 -11.283  1.00  0.00           H  
ATOM    543  HA  LYS A  31      -7.305  -3.223 -11.601  1.00  0.00           H  
ATOM    544  HB2 LYS A  31      -8.329  -1.454 -13.336  1.00  0.00           H  
ATOM    545  HB3 LYS A  31      -6.631  -1.033 -13.559  1.00  0.00           H  
ATOM    546  HG2 LYS A  31      -7.951  -3.755 -13.942  1.00  0.00           H  
ATOM    547  HG3 LYS A  31      -7.383  -2.657 -15.202  1.00  0.00           H  
ATOM    548  HD2 LYS A  31      -5.020  -2.963 -14.281  1.00  0.00           H  
ATOM    549  HD3 LYS A  31      -5.688  -4.196 -13.194  1.00  0.00           H  
ATOM    550  HE2 LYS A  31      -4.794  -5.373 -15.058  1.00  0.00           H  
ATOM    551  HE3 LYS A  31      -6.557  -5.441 -15.203  1.00  0.00           H  
ATOM    552  HZ1 LYS A  31      -5.607  -4.848 -17.310  1.00  0.00           H  
ATOM    553  HZ2 LYS A  31      -4.854  -3.496 -16.636  1.00  0.00           H  
ATOM    554  N   PHE A  32      -5.140  -0.688 -11.227  1.00  0.00           N  
ATOM    555  CA  PHE A  32      -3.777  -0.341 -10.828  1.00  0.00           C  
ATOM    556  C   PHE A  32      -3.413  -0.984  -9.483  1.00  0.00           C  
ATOM    557  O   PHE A  32      -2.353  -1.594  -9.343  1.00  0.00           O  
ATOM    558  CB  PHE A  32      -3.652   1.188 -10.755  1.00  0.00           C  
ATOM    559  CG  PHE A  32      -2.271   1.782 -10.514  1.00  0.00           C  
ATOM    560  CD1 PHE A  32      -1.090   1.012 -10.586  1.00  0.00           C  
ATOM    561  CD2 PHE A  32      -2.175   3.165 -10.268  1.00  0.00           C  
ATOM    562  CE1 PHE A  32       0.162   1.615 -10.386  1.00  0.00           C  
ATOM    563  CE2 PHE A  32      -0.919   3.773 -10.110  1.00  0.00           C  
ATOM    564  CZ  PHE A  32       0.252   2.999 -10.166  1.00  0.00           C  
ATOM    565  H   PHE A  32      -5.743   0.067 -11.530  1.00  0.00           H  
ATOM    566  HA  PHE A  32      -3.111  -0.676 -11.626  1.00  0.00           H  
ATOM    567  HB2 PHE A  32      -4.015   1.599 -11.696  1.00  0.00           H  
ATOM    568  HB3 PHE A  32      -4.306   1.550  -9.962  1.00  0.00           H  
ATOM    569  HD1 PHE A  32      -1.109  -0.043 -10.798  1.00  0.00           H  
ATOM    570  HD2 PHE A  32      -3.070   3.763 -10.180  1.00  0.00           H  
ATOM    571  HE1 PHE A  32       1.052   1.005 -10.406  1.00  0.00           H  
ATOM    572  HE2 PHE A  32      -0.859   4.833  -9.922  1.00  0.00           H  
ATOM    573  HZ  PHE A  32       1.217   3.466 -10.029  1.00  0.00           H  
ATOM    574  N   VAL A  33      -4.320  -0.872  -8.505  1.00  0.00           N  
ATOM    575  CA  VAL A  33      -4.200  -1.572  -7.229  1.00  0.00           C  
ATOM    576  C   VAL A  33      -4.059  -3.078  -7.453  1.00  0.00           C  
ATOM    577  O   VAL A  33      -3.289  -3.728  -6.748  1.00  0.00           O  
ATOM    578  CB  VAL A  33      -5.388  -1.233  -6.310  1.00  0.00           C  
ATOM    579  CG1 VAL A  33      -5.340  -2.037  -5.003  1.00  0.00           C  
ATOM    580  CG2 VAL A  33      -5.383   0.258  -5.954  1.00  0.00           C  
ATOM    581  H   VAL A  33      -5.207  -0.441  -8.732  1.00  0.00           H  
ATOM    582  HA  VAL A  33      -3.270  -1.269  -6.756  1.00  0.00           H  
ATOM    583  HB  VAL A  33      -6.320  -1.469  -6.825  1.00  0.00           H  
ATOM    584 HG11 VAL A  33      -4.384  -1.881  -4.501  1.00  0.00           H  
ATOM    585 HG12 VAL A  33      -6.145  -1.713  -4.342  1.00  0.00           H  
ATOM    586 HG13 VAL A  33      -5.475  -3.101  -5.200  1.00  0.00           H  
ATOM    587 HG21 VAL A  33      -4.457   0.513  -5.443  1.00  0.00           H  
ATOM    588 HG22 VAL A  33      -5.477   0.872  -6.847  1.00  0.00           H  
ATOM    589 HG23 VAL A  33      -6.221   0.470  -5.292  1.00  0.00           H  
ATOM    590  N   GLN A  34      -4.762  -3.613  -8.456  1.00  0.00           N  
ATOM    591  CA  GLN A  34      -4.685  -5.016  -8.824  1.00  0.00           C  
ATOM    592  C   GLN A  34      -3.278  -5.383  -9.277  1.00  0.00           C  
ATOM    593  O   GLN A  34      -2.699  -6.273  -8.674  1.00  0.00           O  
ATOM    594  CB  GLN A  34      -5.759  -5.377  -9.867  1.00  0.00           C  
ATOM    595  CG  GLN A  34      -6.551  -6.634  -9.499  1.00  0.00           C  
ATOM    596  CD  GLN A  34      -7.115  -6.585  -8.080  1.00  0.00           C  
ATOM    597  OE1 GLN A  34      -7.097  -7.592  -7.384  1.00  0.00           O  
ATOM    598  NE2 GLN A  34      -7.575  -5.419  -7.620  1.00  0.00           N  
ATOM    599  H   GLN A  34      -5.238  -2.986  -9.086  1.00  0.00           H  
ATOM    600  HA  GLN A  34      -4.834  -5.576  -7.903  1.00  0.00           H  
ATOM    601  HB2 GLN A  34      -6.476  -4.569  -9.962  1.00  0.00           H  
ATOM    602  HB3 GLN A  34      -5.305  -5.527 -10.847  1.00  0.00           H  
ATOM    603  HG2 GLN A  34      -7.375  -6.750 -10.203  1.00  0.00           H  
ATOM    604  HG3 GLN A  34      -5.899  -7.501  -9.598  1.00  0.00           H  
ATOM    605 HE21 GLN A  34      -7.545  -4.590  -8.198  1.00  0.00           H  
ATOM    606 HE22 GLN A  34      -7.908  -5.370  -6.668  1.00  0.00           H  
ATOM    607  N   ILE A  35      -2.717  -4.721 -10.298  1.00  0.00           N  
ATOM    608  CA  ILE A  35      -1.392  -5.052 -10.827  1.00  0.00           C  
ATOM    609  C   ILE A  35      -0.383  -5.293  -9.708  1.00  0.00           C  
ATOM    610  O   ILE A  35       0.228  -6.358  -9.662  1.00  0.00           O  
ATOM    611  CB  ILE A  35      -0.873  -3.938 -11.760  1.00  0.00           C  
ATOM    612  CG1 ILE A  35      -1.772  -3.677 -12.982  1.00  0.00           C  
ATOM    613  CG2 ILE A  35       0.572  -4.230 -12.207  1.00  0.00           C  
ATOM    614  CD1 ILE A  35      -1.949  -4.885 -13.902  1.00  0.00           C  
ATOM    615  H   ILE A  35      -3.292  -4.061 -10.804  1.00  0.00           H  
ATOM    616  HA  ILE A  35      -1.463  -5.990 -11.382  1.00  0.00           H  
ATOM    617  HB  ILE A  35      -0.848  -3.004 -11.195  1.00  0.00           H  
ATOM    618 HG12 ILE A  35      -2.756  -3.347 -12.653  1.00  0.00           H  
ATOM    619 HG13 ILE A  35      -1.336  -2.867 -13.565  1.00  0.00           H  
ATOM    620 HG21 ILE A  35       0.882  -3.516 -12.970  1.00  0.00           H  
ATOM    621 HG22 ILE A  35       1.263  -4.137 -11.367  1.00  0.00           H  
ATOM    622 HG23 ILE A  35       0.651  -5.242 -12.607  1.00  0.00           H  
ATOM    623 HD11 ILE A  35      -2.529  -4.577 -14.773  1.00  0.00           H  
ATOM    624 HD12 ILE A  35      -0.982  -5.252 -14.243  1.00  0.00           H  
ATOM    625 HD13 ILE A  35      -2.486  -5.682 -13.387  1.00  0.00           H  
ATOM    626  N   HIS A  36      -0.214  -4.318  -8.813  1.00  0.00           N  
ATOM    627  CA  HIS A  36       0.780  -4.405  -7.758  1.00  0.00           C  
ATOM    628  C   HIS A  36       0.393  -5.487  -6.751  1.00  0.00           C  
ATOM    629  O   HIS A  36       1.226  -6.322  -6.411  1.00  0.00           O  
ATOM    630  CB  HIS A  36       0.997  -3.034  -7.115  1.00  0.00           C  
ATOM    631  CG  HIS A  36       1.911  -2.153  -7.932  1.00  0.00           C  
ATOM    632  ND1 HIS A  36       3.126  -1.705  -7.415  1.00  0.00           N  
ATOM    633  CD2 HIS A  36       1.785  -1.690  -9.221  1.00  0.00           C  
ATOM    634  CE1 HIS A  36       3.681  -0.990  -8.397  1.00  0.00           C  
ATOM    635  NE2 HIS A  36       2.917  -0.955  -9.502  1.00  0.00           N  
ATOM    636  H   HIS A  36      -0.819  -3.508  -8.849  1.00  0.00           H  
ATOM    637  HA  HIS A  36       1.732  -4.705  -8.202  1.00  0.00           H  
ATOM    638  HB2 HIS A  36       0.039  -2.536  -6.962  1.00  0.00           H  
ATOM    639  HB3 HIS A  36       1.469  -3.181  -6.142  1.00  0.00           H  
ATOM    640  HD2 HIS A  36       0.971  -1.871  -9.905  1.00  0.00           H  
ATOM    641  HE1 HIS A  36       4.638  -0.499  -8.314  1.00  0.00           H  
ATOM    642  HE2 HIS A  36       3.127  -0.487 -10.372  1.00  0.00           H  
ATOM    643  N   ALA A  37      -0.865  -5.499  -6.299  1.00  0.00           N  
ATOM    644  CA  ALA A  37      -1.367  -6.514  -5.383  1.00  0.00           C  
ATOM    645  C   ALA A  37      -1.068  -7.939  -5.856  1.00  0.00           C  
ATOM    646  O   ALA A  37      -0.527  -8.754  -5.112  1.00  0.00           O  
ATOM    647  CB  ALA A  37      -2.878  -6.323  -5.218  1.00  0.00           C  
ATOM    648  H   ALA A  37      -1.462  -4.706  -6.494  1.00  0.00           H  
ATOM    649  HA  ALA A  37      -0.905  -6.344  -4.417  1.00  0.00           H  
ATOM    650  HB1 ALA A  37      -3.284  -7.116  -4.600  1.00  0.00           H  
ATOM    651  HB2 ALA A  37      -3.081  -5.365  -4.744  1.00  0.00           H  
ATOM    652  HB3 ALA A  37      -3.377  -6.365  -6.185  1.00  0.00           H  
ATOM    653  N   ILE A  38      -1.417  -8.219  -7.109  1.00  0.00           N  
ATOM    654  CA  ILE A  38      -1.199  -9.485  -7.782  1.00  0.00           C  
ATOM    655  C   ILE A  38       0.305  -9.756  -7.858  1.00  0.00           C  
ATOM    656  O   ILE A  38       0.740 -10.848  -7.498  1.00  0.00           O  
ATOM    657  CB  ILE A  38      -1.935  -9.455  -9.140  1.00  0.00           C  
ATOM    658  CG1 ILE A  38      -3.382  -9.958  -8.984  1.00  0.00           C  
ATOM    659  CG2 ILE A  38      -1.235 -10.252 -10.247  1.00  0.00           C  
ATOM    660  CD1 ILE A  38      -4.208  -9.205  -7.932  1.00  0.00           C  
ATOM    661  H   ILE A  38      -1.708  -7.444  -7.681  1.00  0.00           H  
ATOM    662  HA  ILE A  38      -1.598 -10.283  -7.155  1.00  0.00           H  
ATOM    663  HB  ILE A  38      -1.961  -8.433  -9.520  1.00  0.00           H  
ATOM    664 HG12 ILE A  38      -3.892  -9.857  -9.942  1.00  0.00           H  
ATOM    665 HG13 ILE A  38      -3.367 -11.015  -8.715  1.00  0.00           H  
ATOM    666 HG21 ILE A  38      -1.844 -10.219 -11.152  1.00  0.00           H  
ATOM    667 HG22 ILE A  38      -0.271  -9.797 -10.482  1.00  0.00           H  
ATOM    668 HG23 ILE A  38      -1.095 -11.286  -9.938  1.00  0.00           H  
ATOM    669 HD11 ILE A  38      -5.239  -9.550  -7.979  1.00  0.00           H  
ATOM    670 HD12 ILE A  38      -3.830  -9.384  -6.926  1.00  0.00           H  
ATOM    671 HD13 ILE A  38      -4.199  -8.136  -8.128  1.00  0.00           H  
ATOM    672  N   ARG A  39       1.096  -8.760  -8.278  1.00  0.00           N  
ATOM    673  CA  ARG A  39       2.539  -8.889  -8.412  1.00  0.00           C  
ATOM    674  C   ARG A  39       3.178  -9.343  -7.098  1.00  0.00           C  
ATOM    675  O   ARG A  39       4.099 -10.157  -7.094  1.00  0.00           O  
ATOM    676  CB  ARG A  39       3.100  -7.548  -8.906  1.00  0.00           C  
ATOM    677  CG  ARG A  39       4.526  -7.651  -9.449  1.00  0.00           C  
ATOM    678  CD  ARG A  39       5.579  -7.299  -8.397  1.00  0.00           C  
ATOM    679  NE  ARG A  39       6.929  -7.575  -8.907  1.00  0.00           N  
ATOM    680  CZ  ARG A  39       8.048  -7.605  -8.164  1.00  0.00           C  
ATOM    681  NH1 ARG A  39       8.011  -7.321  -6.855  1.00  0.00           N  
ATOM    682  NH2 ARG A  39       9.215  -7.923  -8.741  1.00  0.00           N  
ATOM    683  H   ARG A  39       0.670  -7.932  -8.675  1.00  0.00           H  
ATOM    684  HA  ARG A  39       2.740  -9.588  -9.220  1.00  0.00           H  
ATOM    685  HB2 ARG A  39       2.496  -7.233  -9.755  1.00  0.00           H  
ATOM    686  HB3 ARG A  39       3.043  -6.782  -8.134  1.00  0.00           H  
ATOM    687  HG2 ARG A  39       4.688  -8.656  -9.836  1.00  0.00           H  
ATOM    688  HG3 ARG A  39       4.614  -6.940 -10.271  1.00  0.00           H  
ATOM    689  HD2 ARG A  39       5.488  -6.238  -8.155  1.00  0.00           H  
ATOM    690  HD3 ARG A  39       5.401  -7.886  -7.500  1.00  0.00           H  
ATOM    691  HE  ARG A  39       7.002  -7.784  -9.892  1.00  0.00           H  
ATOM    692 HH11 ARG A  39       7.136  -7.072  -6.417  1.00  0.00           H  
ATOM    693 HH12 ARG A  39       8.855  -7.354  -6.299  1.00  0.00           H  
ATOM    694 HH21 ARG A  39       9.250  -8.144  -9.727  1.00  0.00           H  
ATOM    695 HH22 ARG A  39      10.063  -7.955  -8.195  1.00  0.00           H  
ATOM    696  N   LEU A  40       2.667  -8.798  -5.989  1.00  0.00           N  
ATOM    697  CA  LEU A  40       3.187  -8.977  -4.641  1.00  0.00           C  
ATOM    698  C   LEU A  40       2.496 -10.112  -3.872  1.00  0.00           C  
ATOM    699  O   LEU A  40       2.865 -10.369  -2.726  1.00  0.00           O  
ATOM    700  CB  LEU A  40       3.048  -7.647  -3.900  1.00  0.00           C  
ATOM    701  CG  LEU A  40       3.849  -6.524  -4.583  1.00  0.00           C  
ATOM    702  CD1 LEU A  40       3.363  -5.192  -4.023  1.00  0.00           C  
ATOM    703  CD2 LEU A  40       5.358  -6.677  -4.365  1.00  0.00           C  
ATOM    704  H   LEU A  40       1.917  -8.128  -6.110  1.00  0.00           H  
ATOM    705  HA  LEU A  40       4.246  -9.210  -4.686  1.00  0.00           H  
ATOM    706  HB2 LEU A  40       1.991  -7.379  -3.881  1.00  0.00           H  
ATOM    707  HB3 LEU A  40       3.394  -7.753  -2.870  1.00  0.00           H  
ATOM    708  HG  LEU A  40       3.668  -6.505  -5.655  1.00  0.00           H  
ATOM    709 HD11 LEU A  40       3.917  -4.377  -4.488  1.00  0.00           H  
ATOM    710 HD12 LEU A  40       2.303  -5.072  -4.246  1.00  0.00           H  
ATOM    711 HD13 LEU A  40       3.508  -5.185  -2.943  1.00  0.00           H  
ATOM    712 HD21 LEU A  40       5.878  -5.824  -4.805  1.00  0.00           H  
ATOM    713 HD22 LEU A  40       5.582  -6.722  -3.300  1.00  0.00           H  
ATOM    714 HD23 LEU A  40       5.722  -7.583  -4.847  1.00  0.00           H  
ATOM    715  N   GLY A  41       1.513 -10.798  -4.471  1.00  0.00           N  
ATOM    716  CA  GLY A  41       0.812 -11.909  -3.838  1.00  0.00           C  
ATOM    717  C   GLY A  41      -0.057 -11.438  -2.671  1.00  0.00           C  
ATOM    718  O   GLY A  41       0.159 -11.840  -1.530  1.00  0.00           O  
ATOM    719  H   GLY A  41       1.237 -10.553  -5.413  1.00  0.00           H  
ATOM    720  HA2 GLY A  41       0.174 -12.387  -4.582  1.00  0.00           H  
ATOM    721  HA3 GLY A  41       1.538 -12.643  -3.485  1.00  0.00           H  
ATOM    722  N   ILE A  42      -1.046 -10.591  -2.978  1.00  0.00           N  
ATOM    723  CA  ILE A  42      -2.001 -10.007  -2.046  1.00  0.00           C  
ATOM    724  C   ILE A  42      -3.389 -10.529  -2.412  1.00  0.00           C  
ATOM    725  O   ILE A  42      -3.713 -10.672  -3.591  1.00  0.00           O  
ATOM    726  CB  ILE A  42      -1.926  -8.473  -2.157  1.00  0.00           C  
ATOM    727  CG1 ILE A  42      -0.532  -7.932  -1.816  1.00  0.00           C  
ATOM    728  CG2 ILE A  42      -2.995  -7.683  -1.392  1.00  0.00           C  
ATOM    729  CD1 ILE A  42      -0.067  -8.173  -0.380  1.00  0.00           C  
ATOM    730  H   ILE A  42      -1.142 -10.304  -3.941  1.00  0.00           H  
ATOM    731  HA  ILE A  42      -1.772 -10.308  -1.027  1.00  0.00           H  
ATOM    732  HB  ILE A  42      -2.099  -8.250  -3.204  1.00  0.00           H  
ATOM    733 HG12 ILE A  42       0.194  -8.379  -2.487  1.00  0.00           H  
ATOM    734 HG13 ILE A  42      -0.551  -6.859  -1.977  1.00  0.00           H  
ATOM    735 HG21 ILE A  42      -2.907  -6.626  -1.642  1.00  0.00           H  
ATOM    736 HG22 ILE A  42      -3.991  -8.012  -1.668  1.00  0.00           H  
ATOM    737 HG23 ILE A  42      -2.875  -7.791  -0.322  1.00  0.00           H  
ATOM    738 HD11 ILE A  42       0.936  -7.765  -0.260  1.00  0.00           H  
ATOM    739 HD12 ILE A  42      -0.733  -7.657   0.308  1.00  0.00           H  
ATOM    740 HD13 ILE A  42      -0.040  -9.236  -0.148  1.00  0.00           H  
ATOM    741  N   LYS A  43      -4.198 -10.803  -1.387  1.00  0.00           N  
ATOM    742  CA  LYS A  43      -5.576 -11.266  -1.515  1.00  0.00           C  
ATOM    743  C   LYS A  43      -6.512 -10.098  -1.204  1.00  0.00           C  
ATOM    744  O   LYS A  43      -6.063  -9.086  -0.670  1.00  0.00           O  
ATOM    745  CB  LYS A  43      -5.837 -12.427  -0.552  1.00  0.00           C  
ATOM    746  CG  LYS A  43      -4.805 -13.552  -0.717  1.00  0.00           C  
ATOM    747  CD  LYS A  43      -5.068 -14.686   0.279  1.00  0.00           C  
ATOM    748  CE  LYS A  43      -4.125 -15.875   0.058  1.00  0.00           C  
ATOM    749  NZ  LYS A  43      -2.750 -15.508   0.344  1.00  0.00           N  
ATOM    750  H   LYS A  43      -3.854 -10.593  -0.459  1.00  0.00           H  
ATOM    751  HA  LYS A  43      -5.768 -11.642  -2.521  1.00  0.00           H  
ATOM    752  HB2 LYS A  43      -5.821 -12.046   0.464  1.00  0.00           H  
ATOM    753  HB3 LYS A  43      -6.832 -12.825  -0.745  1.00  0.00           H  
ATOM    754  HG2 LYS A  43      -4.861 -13.938  -1.735  1.00  0.00           H  
ATOM    755  HG3 LYS A  43      -3.801 -13.164  -0.542  1.00  0.00           H  
ATOM    756  HD2 LYS A  43      -4.950 -14.310   1.297  1.00  0.00           H  
ATOM    757  HD3 LYS A  43      -6.090 -15.041   0.154  1.00  0.00           H  
ATOM    758  HE2 LYS A  43      -4.417 -16.687   0.722  1.00  0.00           H  
ATOM    759  HE3 LYS A  43      -4.200 -16.218  -0.974  1.00  0.00           H  
ATOM    760  HZ1 LYS A  43      -2.426 -14.704  -0.175  1.00  0.00           H  
ATOM    761  HZ2 LYS A  43      -2.108 -16.286   0.316  1.00  0.00           H  
ATOM    762  N   GLY A  44      -7.807 -10.229  -1.505  1.00  0.00           N  
ATOM    763  CA  GLY A  44      -8.788  -9.217  -1.133  1.00  0.00           C  
ATOM    764  C   GLY A  44      -9.960  -9.135  -2.101  1.00  0.00           C  
ATOM    765  O   GLY A  44     -10.367 -10.140  -2.678  1.00  0.00           O  
ATOM    766  H   GLY A  44      -8.126 -11.084  -1.940  1.00  0.00           H  
ATOM    767  HA2 GLY A  44      -9.167  -9.444  -0.137  1.00  0.00           H  
ATOM    768  HA3 GLY A  44      -8.309  -8.238  -1.125  1.00  0.00           H  
ATOM    769  N   TYR A  45     -10.491  -7.917  -2.274  1.00  0.00           N  
ATOM    770  CA  TYR A  45     -11.498  -7.581  -3.271  1.00  0.00           C  
ATOM    771  C   TYR A  45     -11.682  -6.062  -3.314  1.00  0.00           C  
ATOM    772  O   TYR A  45     -11.658  -5.406  -2.275  1.00  0.00           O  
ATOM    773  CB  TYR A  45     -12.828  -8.263  -2.956  1.00  0.00           C  
ATOM    774  CG  TYR A  45     -13.843  -8.294  -4.082  1.00  0.00           C  
ATOM    775  CD1 TYR A  45     -13.626  -9.139  -5.186  1.00  0.00           C  
ATOM    776  CD2 TYR A  45     -15.099  -7.692  -3.906  1.00  0.00           C  
ATOM    777  CE1 TYR A  45     -14.645  -9.347  -6.130  1.00  0.00           C  
ATOM    778  CE2 TYR A  45     -16.127  -7.923  -4.833  1.00  0.00           C  
ATOM    779  CZ  TYR A  45     -15.903  -8.757  -5.943  1.00  0.00           C  
ATOM    780  OH  TYR A  45     -16.907  -9.013  -6.831  1.00  0.00           O  
ATOM    781  H   TYR A  45     -10.113  -7.151  -1.736  1.00  0.00           H  
ATOM    782  HA  TYR A  45     -11.137  -7.945  -4.226  1.00  0.00           H  
ATOM    783  HB2 TYR A  45     -12.660  -9.298  -2.680  1.00  0.00           H  
ATOM    784  HB3 TYR A  45     -13.249  -7.741  -2.107  1.00  0.00           H  
ATOM    785  HD1 TYR A  45     -12.682  -9.647  -5.291  1.00  0.00           H  
ATOM    786  HD2 TYR A  45     -15.298  -7.092  -3.030  1.00  0.00           H  
ATOM    787  HE1 TYR A  45     -14.484  -9.993  -6.981  1.00  0.00           H  
ATOM    788  HE2 TYR A  45     -17.096  -7.486  -4.674  1.00  0.00           H  
ATOM    789  HH  TYR A  45     -17.737  -8.591  -6.600  1.00  0.00           H  
ATOM    790  N   ALA A  46     -11.838  -5.515  -4.524  1.00  0.00           N  
ATOM    791  CA  ALA A  46     -11.915  -4.078  -4.778  1.00  0.00           C  
ATOM    792  C   ALA A  46     -13.326  -3.739  -5.222  1.00  0.00           C  
ATOM    793  O   ALA A  46     -13.631  -3.777  -6.414  1.00  0.00           O  
ATOM    794  CB  ALA A  46     -10.887  -3.662  -5.837  1.00  0.00           C  
ATOM    795  H   ALA A  46     -11.726  -6.142  -5.308  1.00  0.00           H  
ATOM    796  HA  ALA A  46     -11.653  -3.511  -3.885  1.00  0.00           H  
ATOM    797  HB1 ALA A  46     -11.018  -2.603  -6.054  1.00  0.00           H  
ATOM    798  HB2 ALA A  46      -9.875  -3.816  -5.470  1.00  0.00           H  
ATOM    799  HB3 ALA A  46     -11.012  -4.230  -6.757  1.00  0.00           H  
ATOM    800  N   LYS A  47     -14.195  -3.445  -4.256  1.00  0.00           N  
ATOM    801  CA  LYS A  47     -15.626  -3.425  -4.475  1.00  0.00           C  
ATOM    802  C   LYS A  47     -16.051  -2.000  -4.835  1.00  0.00           C  
ATOM    803  O   LYS A  47     -16.568  -1.261  -3.998  1.00  0.00           O  
ATOM    804  CB  LYS A  47     -16.287  -3.969  -3.211  1.00  0.00           C  
ATOM    805  CG  LYS A  47     -17.788  -4.227  -3.378  1.00  0.00           C  
ATOM    806  CD  LYS A  47     -18.471  -4.589  -2.054  1.00  0.00           C  
ATOM    807  CE  LYS A  47     -17.924  -5.887  -1.445  1.00  0.00           C  
ATOM    808  NZ  LYS A  47     -18.700  -6.253  -0.276  1.00  0.00           N  
ATOM    809  H   LYS A  47     -13.868  -3.297  -3.309  1.00  0.00           H  
ATOM    810  HA  LYS A  47     -15.871  -4.109  -5.288  1.00  0.00           H  
ATOM    811  HB2 LYS A  47     -15.800  -4.906  -2.950  1.00  0.00           H  
ATOM    812  HB3 LYS A  47     -16.094  -3.259  -2.419  1.00  0.00           H  
ATOM    813  HG2 LYS A  47     -18.274  -3.340  -3.783  1.00  0.00           H  
ATOM    814  HG3 LYS A  47     -17.921  -5.047  -4.080  1.00  0.00           H  
ATOM    815  HD2 LYS A  47     -18.342  -3.770  -1.344  1.00  0.00           H  
ATOM    816  HD3 LYS A  47     -19.537  -4.714  -2.250  1.00  0.00           H  
ATOM    817  HE2 LYS A  47     -17.987  -6.690  -2.180  1.00  0.00           H  
ATOM    818  HE3 LYS A  47     -16.885  -5.755  -1.145  1.00  0.00           H  
ATOM    819  HZ1 LYS A  47     -18.331  -7.051   0.220  1.00  0.00           H  
ATOM    820  HZ2 LYS A  47     -19.694  -6.316  -0.454  1.00  0.00           H  
ATOM    821  N   ASN A  48     -15.803  -1.619  -6.092  1.00  0.00           N  
ATOM    822  CA  ASN A  48     -16.128  -0.322  -6.666  1.00  0.00           C  
ATOM    823  C   ASN A  48     -17.632  -0.180  -6.900  1.00  0.00           C  
ATOM    824  O   ASN A  48     -18.094  -0.190  -8.038  1.00  0.00           O  
ATOM    825  CB  ASN A  48     -15.298  -0.134  -7.943  1.00  0.00           C  
ATOM    826  CG  ASN A  48     -15.395   1.277  -8.529  1.00  0.00           C  
ATOM    827  OD1 ASN A  48     -16.222   1.541  -9.397  1.00  0.00           O  
ATOM    828  ND2 ASN A  48     -14.524   2.182  -8.081  1.00  0.00           N  
ATOM    829  H   ASN A  48     -15.298  -2.262  -6.683  1.00  0.00           H  
ATOM    830  HA  ASN A  48     -15.849   0.455  -5.962  1.00  0.00           H  
ATOM    831  HB2 ASN A  48     -14.256  -0.333  -7.690  1.00  0.00           H  
ATOM    832  HB3 ASN A  48     -15.609  -0.861  -8.694  1.00  0.00           H  
ATOM    833 HD21 ASN A  48     -13.845   1.928  -7.378  1.00  0.00           H  
ATOM    834 HD22 ASN A  48     -14.555   3.127  -8.433  1.00  0.00           H  
ATOM    835  N   LEU A  49     -18.385   0.008  -5.810  1.00  0.00           N  
ATOM    836  CA  LEU A  49     -19.758   0.463  -5.851  1.00  0.00           C  
ATOM    837  C   LEU A  49     -19.723   1.839  -6.521  1.00  0.00           C  
ATOM    838  O   LEU A  49     -18.964   2.692  -6.064  1.00  0.00           O  
ATOM    839  CB  LEU A  49     -20.369   0.579  -4.440  1.00  0.00           C  
ATOM    840  CG  LEU A  49     -19.748  -0.298  -3.339  1.00  0.00           C  
ATOM    841  CD1 LEU A  49     -18.671   0.497  -2.583  1.00  0.00           C  
ATOM    842  CD2 LEU A  49     -20.819  -0.734  -2.333  1.00  0.00           C  
ATOM    843  H   LEU A  49     -17.959  -0.044  -4.901  1.00  0.00           H  
ATOM    844  HA  LEU A  49     -20.326  -0.279  -6.409  1.00  0.00           H  
ATOM    845  HB2 LEU A  49     -20.309   1.612  -4.100  1.00  0.00           H  
ATOM    846  HB3 LEU A  49     -21.420   0.323  -4.544  1.00  0.00           H  
ATOM    847  HG  LEU A  49     -19.327  -1.203  -3.774  1.00  0.00           H  
ATOM    848 HD11 LEU A  49     -18.115  -0.162  -1.918  1.00  0.00           H  
ATOM    849 HD12 LEU A  49     -17.974   0.963  -3.276  1.00  0.00           H  
ATOM    850 HD13 LEU A  49     -19.136   1.285  -1.991  1.00  0.00           H  
ATOM    851 HD21 LEU A  49     -20.360  -1.328  -1.543  1.00  0.00           H  
ATOM    852 HD22 LEU A  49     -21.301   0.139  -1.892  1.00  0.00           H  
ATOM    853 HD23 LEU A  49     -21.572  -1.343  -2.835  1.00  0.00           H  
ATOM    854  N   PRO A  50     -20.465   2.068  -7.612  1.00  0.00           N  
ATOM    855  CA  PRO A  50     -20.349   3.282  -8.403  1.00  0.00           C  
ATOM    856  C   PRO A  50     -21.041   4.455  -7.701  1.00  0.00           C  
ATOM    857  O   PRO A  50     -22.145   4.852  -8.071  1.00  0.00           O  
ATOM    858  CB  PRO A  50     -20.960   2.924  -9.759  1.00  0.00           C  
ATOM    859  CG  PRO A  50     -22.010   1.871  -9.401  1.00  0.00           C  
ATOM    860  CD  PRO A  50     -21.343   1.110  -8.254  1.00  0.00           C  
ATOM    861  HA  PRO A  50     -19.301   3.529  -8.559  1.00  0.00           H  
ATOM    862  HB2 PRO A  50     -21.376   3.784 -10.284  1.00  0.00           H  
ATOM    863  HB3 PRO A  50     -20.185   2.457 -10.371  1.00  0.00           H  
ATOM    864  HG2 PRO A  50     -22.910   2.367  -9.034  1.00  0.00           H  
ATOM    865  HG3 PRO A  50     -22.254   1.223 -10.243  1.00  0.00           H  
ATOM    866  HD2 PRO A  50     -22.090   0.727  -7.556  1.00  0.00           H  
ATOM    867  HD3 PRO A  50     -20.744   0.289  -8.652  1.00  0.00           H  
ATOM    868  N   ASP A  51     -20.378   5.004  -6.675  1.00  0.00           N  
ATOM    869  CA  ASP A  51     -20.899   6.072  -5.828  1.00  0.00           C  
ATOM    870  C   ASP A  51     -19.778   6.950  -5.259  1.00  0.00           C  
ATOM    871  O   ASP A  51     -19.941   7.533  -4.186  1.00  0.00           O  
ATOM    872  CB  ASP A  51     -21.760   5.453  -4.713  1.00  0.00           C  
ATOM    873  CG  ASP A  51     -20.992   4.525  -3.763  1.00  0.00           C  
ATOM    874  OD1 ASP A  51     -19.765   4.455  -3.808  1.00  0.00           O  
ATOM    875  OD2 ASP A  51     -21.764   3.807  -2.899  1.00  0.00           O  
ATOM    876  H   ASP A  51     -19.509   4.573  -6.390  1.00  0.00           H  
ATOM    877  HA  ASP A  51     -21.536   6.725  -6.427  1.00  0.00           H  
ATOM    878  HB2 ASP A  51     -22.212   6.250  -4.122  1.00  0.00           H  
ATOM    879  HB3 ASP A  51     -22.565   4.878  -5.172  1.00  0.00           H  
ATOM    880  HD2 ASP A  51     -21.241   3.243  -2.322  1.00  0.00           H  
ATOM    881  N   GLY A  52     -18.633   7.039  -5.947  1.00  0.00           N  
ATOM    882  CA  GLY A  52     -17.482   7.817  -5.503  1.00  0.00           C  
ATOM    883  C   GLY A  52     -16.644   7.072  -4.457  1.00  0.00           C  
ATOM    884  O   GLY A  52     -15.420   7.015  -4.561  1.00  0.00           O  
ATOM    885  H   GLY A  52     -18.550   6.555  -6.829  1.00  0.00           H  
ATOM    886  HA2 GLY A  52     -16.872   8.033  -6.377  1.00  0.00           H  
ATOM    887  HA3 GLY A  52     -17.813   8.768  -5.083  1.00  0.00           H  
ATOM    888  N   SER A  53     -17.303   6.527  -3.430  1.00  0.00           N  
ATOM    889  CA  SER A  53     -16.675   5.880  -2.291  1.00  0.00           C  
ATOM    890  C   SER A  53     -16.508   4.378  -2.541  1.00  0.00           C  
ATOM    891  O   SER A  53     -17.393   3.593  -2.208  1.00  0.00           O  
ATOM    892  CB  SER A  53     -17.527   6.167  -1.054  1.00  0.00           C  
ATOM    893  OG  SER A  53     -18.877   5.806  -1.275  1.00  0.00           O  
ATOM    894  H   SER A  53     -18.310   6.620  -3.395  1.00  0.00           H  
ATOM    895  HA  SER A  53     -15.691   6.314  -2.108  1.00  0.00           H  
ATOM    896  HB2 SER A  53     -17.131   5.605  -0.214  1.00  0.00           H  
ATOM    897  HB3 SER A  53     -17.483   7.231  -0.824  1.00  0.00           H  
ATOM    898  HG  SER A  53     -18.894   4.942  -1.697  1.00  0.00           H  
ATOM    899  N   VAL A  54     -15.355   3.983  -3.096  1.00  0.00           N  
ATOM    900  CA  VAL A  54     -14.995   2.586  -3.330  1.00  0.00           C  
ATOM    901  C   VAL A  54     -14.166   2.059  -2.160  1.00  0.00           C  
ATOM    902  O   VAL A  54     -13.137   2.639  -1.815  1.00  0.00           O  
ATOM    903  CB  VAL A  54     -14.277   2.399  -4.680  1.00  0.00           C  
ATOM    904  CG1 VAL A  54     -13.286   3.510  -5.027  1.00  0.00           C  
ATOM    905  CG2 VAL A  54     -13.547   1.044  -4.737  1.00  0.00           C  
ATOM    906  H   VAL A  54     -14.650   4.687  -3.271  1.00  0.00           H  
ATOM    907  HA  VAL A  54     -15.902   1.988  -3.395  1.00  0.00           H  
ATOM    908  HB  VAL A  54     -15.044   2.421  -5.450  1.00  0.00           H  
ATOM    909 HG11 VAL A  54     -12.531   3.582  -4.253  1.00  0.00           H  
ATOM    910 HG12 VAL A  54     -12.800   3.280  -5.974  1.00  0.00           H  
ATOM    911 HG13 VAL A  54     -13.802   4.464  -5.129  1.00  0.00           H  
ATOM    912 HG21 VAL A  54     -12.662   1.057  -4.101  1.00  0.00           H  
ATOM    913 HG22 VAL A  54     -14.203   0.242  -4.401  1.00  0.00           H  
ATOM    914 HG23 VAL A  54     -13.230   0.833  -5.757  1.00  0.00           H  
ATOM    915  N   GLU A  55     -14.605   0.939  -1.574  1.00  0.00           N  
ATOM    916  CA  GLU A  55     -13.882   0.258  -0.515  1.00  0.00           C  
ATOM    917  C   GLU A  55     -13.041  -0.866  -1.113  1.00  0.00           C  
ATOM    918  O   GLU A  55     -13.481  -1.546  -2.042  1.00  0.00           O  
ATOM    919  CB  GLU A  55     -14.867  -0.246   0.553  1.00  0.00           C  
ATOM    920  CG  GLU A  55     -15.712  -1.465   0.148  1.00  0.00           C  
ATOM    921  CD  GLU A  55     -15.087  -2.785   0.607  1.00  0.00           C  
ATOM    922  OE1 GLU A  55     -15.125  -3.077   1.801  1.00  0.00           O  
ATOM    923  OE2 GLU A  55     -14.526  -3.573  -0.352  1.00  0.00           O  
ATOM    924  H   GLU A  55     -15.488   0.539  -1.861  1.00  0.00           H  
ATOM    925  HA  GLU A  55     -13.246   0.981   0.001  1.00  0.00           H  
ATOM    926  HB2 GLU A  55     -14.316  -0.476   1.465  1.00  0.00           H  
ATOM    927  HB3 GLU A  55     -15.551   0.572   0.776  1.00  0.00           H  
ATOM    928  HG2 GLU A  55     -16.678  -1.384   0.648  1.00  0.00           H  
ATOM    929  HG3 GLU A  55     -15.896  -1.469  -0.926  1.00  0.00           H  
ATOM    930  HE2 GLU A  55     -14.149  -4.378   0.009  1.00  0.00           H  
ATOM    931  N   VAL A  56     -11.834  -1.053  -0.577  1.00  0.00           N  
ATOM    932  CA  VAL A  56     -10.945  -2.151  -0.930  1.00  0.00           C  
ATOM    933  C   VAL A  56     -10.603  -2.907   0.353  1.00  0.00           C  
ATOM    934  O   VAL A  56     -10.340  -2.279   1.376  1.00  0.00           O  
ATOM    935  CB  VAL A  56      -9.689  -1.604  -1.628  1.00  0.00           C  
ATOM    936  CG1 VAL A  56      -8.789  -2.749  -2.105  1.00  0.00           C  
ATOM    937  CG2 VAL A  56     -10.058  -0.737  -2.841  1.00  0.00           C  
ATOM    938  H   VAL A  56     -11.459  -0.330   0.024  1.00  0.00           H  
ATOM    939  HA  VAL A  56     -11.430  -2.813  -1.647  1.00  0.00           H  
ATOM    940  HB  VAL A  56      -9.127  -0.991  -0.927  1.00  0.00           H  
ATOM    941 HG11 VAL A  56      -9.333  -3.391  -2.799  1.00  0.00           H  
ATOM    942 HG12 VAL A  56      -7.913  -2.339  -2.609  1.00  0.00           H  
ATOM    943 HG13 VAL A  56      -8.447  -3.343  -1.259  1.00  0.00           H  
ATOM    944 HG21 VAL A  56     -10.710  -1.290  -3.517  1.00  0.00           H  
ATOM    945 HG22 VAL A  56     -10.563   0.175  -2.522  1.00  0.00           H  
ATOM    946 HG23 VAL A  56      -9.150  -0.459  -3.377  1.00  0.00           H  
ATOM    947  N   VAL A  57     -10.608  -4.244   0.301  1.00  0.00           N  
ATOM    948  CA  VAL A  57     -10.224  -5.102   1.418  1.00  0.00           C  
ATOM    949  C   VAL A  57      -9.017  -5.946   1.018  1.00  0.00           C  
ATOM    950  O   VAL A  57      -9.069  -7.173   1.030  1.00  0.00           O  
ATOM    951  CB  VAL A  57     -11.425  -5.932   1.914  1.00  0.00           C  
ATOM    952  CG1 VAL A  57     -12.374  -5.032   2.711  1.00  0.00           C  
ATOM    953  CG2 VAL A  57     -12.205  -6.618   0.784  1.00  0.00           C  
ATOM    954  H   VAL A  57     -10.860  -4.693  -0.572  1.00  0.00           H  
ATOM    955  HA  VAL A  57      -9.867  -4.502   2.254  1.00  0.00           H  
ATOM    956  HB  VAL A  57     -11.068  -6.701   2.601  1.00  0.00           H  
ATOM    957 HG11 VAL A  57     -12.695  -4.185   2.106  1.00  0.00           H  
ATOM    958 HG12 VAL A  57     -13.248  -5.597   3.032  1.00  0.00           H  
ATOM    959 HG13 VAL A  57     -11.849  -4.669   3.592  1.00  0.00           H  
ATOM    960 HG21 VAL A  57     -12.636  -5.883   0.106  1.00  0.00           H  
ATOM    961 HG22 VAL A  57     -11.557  -7.293   0.226  1.00  0.00           H  
ATOM    962 HG23 VAL A  57     -13.021  -7.196   1.214  1.00  0.00           H  
ATOM    963  N   ALA A  58      -7.915  -5.260   0.697  1.00  0.00           N  
ATOM    964  CA  ALA A  58      -6.630  -5.863   0.370  1.00  0.00           C  
ATOM    965  C   ALA A  58      -6.008  -6.487   1.620  1.00  0.00           C  
ATOM    966  O   ALA A  58      -6.367  -6.102   2.731  1.00  0.00           O  
ATOM    967  CB  ALA A  58      -5.707  -4.782  -0.193  1.00  0.00           C  
ATOM    968  H   ALA A  58      -7.953  -4.256   0.791  1.00  0.00           H  
ATOM    969  HA  ALA A  58      -6.772  -6.624  -0.394  1.00  0.00           H  
ATOM    970  HB1 ALA A  58      -4.690  -5.164  -0.286  1.00  0.00           H  
ATOM    971  HB2 ALA A  58      -6.065  -4.451  -1.163  1.00  0.00           H  
ATOM    972  HB3 ALA A  58      -5.708  -3.926   0.477  1.00  0.00           H  
ATOM    973  N   GLU A  59      -5.115  -7.473   1.442  1.00  0.00           N  
ATOM    974  CA  GLU A  59      -4.608  -8.252   2.563  1.00  0.00           C  
ATOM    975  C   GLU A  59      -3.127  -8.595   2.367  1.00  0.00           C  
ATOM    976  O   GLU A  59      -2.814  -9.381   1.473  1.00  0.00           O  
ATOM    977  CB  GLU A  59      -5.437  -9.540   2.711  1.00  0.00           C  
ATOM    978  CG  GLU A  59      -6.949  -9.302   2.732  1.00  0.00           C  
ATOM    979  CD  GLU A  59      -7.711 -10.580   3.055  1.00  0.00           C  
ATOM    980  OE1 GLU A  59      -7.781 -11.469   2.208  1.00  0.00           O  
ATOM    981  OE2 GLU A  59      -8.281 -10.642   4.294  1.00  0.00           O  
ATOM    982  H   GLU A  59      -5.207  -7.965   0.564  1.00  0.00           H  
ATOM    983  HA  GLU A  59      -4.827  -7.713   3.477  1.00  0.00           H  
ATOM    984  HB2 GLU A  59      -5.209 -10.230   1.898  1.00  0.00           H  
ATOM    985  HB3 GLU A  59      -5.172 -10.004   3.659  1.00  0.00           H  
ATOM    986  HG2 GLU A  59      -7.202  -8.547   3.475  1.00  0.00           H  
ATOM    987  HG3 GLU A  59      -7.268  -8.945   1.757  1.00  0.00           H  
ATOM    988  HE2 GLU A  59      -8.765 -11.459   4.455  1.00  0.00           H  
ATOM    989  N   GLY A  60      -2.225  -8.035   3.186  1.00  0.00           N  
ATOM    990  CA  GLY A  60      -0.783  -8.166   2.993  1.00  0.00           C  
ATOM    991  C   GLY A  60      -0.008  -8.462   4.276  1.00  0.00           C  
ATOM    992  O   GLY A  60      -0.469  -8.176   5.377  1.00  0.00           O  
ATOM    993  H   GLY A  60      -2.549  -7.467   3.958  1.00  0.00           H  
ATOM    994  HA2 GLY A  60      -0.566  -8.975   2.296  1.00  0.00           H  
ATOM    995  HA3 GLY A  60      -0.405  -7.238   2.577  1.00  0.00           H  
ATOM    996  N   TYR A  61       1.180  -9.054   4.096  1.00  0.00           N  
ATOM    997  CA  TYR A  61       2.086  -9.490   5.147  1.00  0.00           C  
ATOM    998  C   TYR A  61       2.740  -8.276   5.823  1.00  0.00           C  
ATOM    999  O   TYR A  61       2.208  -7.749   6.797  1.00  0.00           O  
ATOM   1000  CB  TYR A  61       3.140 -10.435   4.537  1.00  0.00           C  
ATOM   1001  CG  TYR A  61       2.804 -11.909   4.472  1.00  0.00           C  
ATOM   1002  CD1 TYR A  61       2.084 -12.409   3.372  1.00  0.00           C  
ATOM   1003  CD2 TYR A  61       3.458 -12.806   5.340  1.00  0.00           C  
ATOM   1004  CE1 TYR A  61       2.071 -13.788   3.101  1.00  0.00           C  
ATOM   1005  CE2 TYR A  61       3.460 -14.182   5.059  1.00  0.00           C  
ATOM   1006  CZ  TYR A  61       2.756 -14.677   3.948  1.00  0.00           C  
ATOM   1007  OH  TYR A  61       2.739 -16.016   3.693  1.00  0.00           O  
ATOM   1008  H   TYR A  61       1.495  -9.211   3.151  1.00  0.00           H  
ATOM   1009  HA  TYR A  61       1.528 -10.027   5.909  1.00  0.00           H  
ATOM   1010  HB2 TYR A  61       3.356 -10.102   3.524  1.00  0.00           H  
ATOM   1011  HB3 TYR A  61       4.062 -10.360   5.103  1.00  0.00           H  
ATOM   1012  HD1 TYR A  61       1.523 -11.735   2.744  1.00  0.00           H  
ATOM   1013  HD2 TYR A  61       3.945 -12.450   6.237  1.00  0.00           H  
ATOM   1014  HE1 TYR A  61       1.533 -14.161   2.241  1.00  0.00           H  
ATOM   1015  HE2 TYR A  61       3.984 -14.862   5.706  1.00  0.00           H  
ATOM   1016  HH  TYR A  61       2.240 -16.250   2.908  1.00  0.00           H  
ATOM   1017  N   GLU A  62       3.918  -7.873   5.330  1.00  0.00           N  
ATOM   1018  CA  GLU A  62       4.840  -6.959   5.989  1.00  0.00           C  
ATOM   1019  C   GLU A  62       5.676  -6.290   4.899  1.00  0.00           C  
ATOM   1020  O   GLU A  62       5.379  -5.174   4.487  1.00  0.00           O  
ATOM   1021  CB  GLU A  62       5.749  -7.747   6.939  1.00  0.00           C  
ATOM   1022  CG  GLU A  62       5.065  -8.212   8.231  1.00  0.00           C  
ATOM   1023  CD  GLU A  62       6.058  -8.939   9.135  1.00  0.00           C  
ATOM   1024  OE1 GLU A  62       5.987 -10.160   9.252  1.00  0.00           O  
ATOM   1025  OE2 GLU A  62       6.983  -8.156   9.757  1.00  0.00           O  
ATOM   1026  H   GLU A  62       4.265  -8.336   4.503  1.00  0.00           H  
ATOM   1027  HA  GLU A  62       4.299  -6.191   6.546  1.00  0.00           H  
ATOM   1028  HB2 GLU A  62       6.123  -8.626   6.412  1.00  0.00           H  
ATOM   1029  HB3 GLU A  62       6.585  -7.098   7.202  1.00  0.00           H  
ATOM   1030  HG2 GLU A  62       4.657  -7.353   8.765  1.00  0.00           H  
ATOM   1031  HG3 GLU A  62       4.254  -8.902   7.997  1.00  0.00           H  
ATOM   1032  HE2 GLU A  62       7.589  -8.665  10.301  1.00  0.00           H  
ATOM   1033  N   GLU A  63       6.708  -6.983   4.404  1.00  0.00           N  
ATOM   1034  CA  GLU A  63       7.443  -6.579   3.222  1.00  0.00           C  
ATOM   1035  C   GLU A  63       6.470  -6.339   2.063  1.00  0.00           C  
ATOM   1036  O   GLU A  63       6.447  -5.257   1.484  1.00  0.00           O  
ATOM   1037  CB  GLU A  63       8.519  -7.637   2.922  1.00  0.00           C  
ATOM   1038  CG  GLU A  63       8.017  -9.082   2.762  1.00  0.00           C  
ATOM   1039  CD  GLU A  63       9.187 -10.062   2.717  1.00  0.00           C  
ATOM   1040  OE1 GLU A  63       9.519 -10.559   1.643  1.00  0.00           O  
ATOM   1041  OE2 GLU A  63       9.791 -10.327   3.911  1.00  0.00           O  
ATOM   1042  H   GLU A  63       7.110  -7.730   4.949  1.00  0.00           H  
ATOM   1043  HA  GLU A  63       8.013  -5.678   3.456  1.00  0.00           H  
ATOM   1044  HB2 GLU A  63       9.057  -7.346   2.022  1.00  0.00           H  
ATOM   1045  HB3 GLU A  63       9.220  -7.620   3.759  1.00  0.00           H  
ATOM   1046  HG2 GLU A  63       7.376  -9.367   3.595  1.00  0.00           H  
ATOM   1047  HG3 GLU A  63       7.454  -9.175   1.834  1.00  0.00           H  
ATOM   1048  HE2 GLU A  63      10.537 -10.926   3.818  1.00  0.00           H  
ATOM   1049  N   ALA A  64       5.606  -7.323   1.782  1.00  0.00           N  
ATOM   1050  CA  ALA A  64       4.597  -7.217   0.739  1.00  0.00           C  
ATOM   1051  C   ALA A  64       3.535  -6.170   1.080  1.00  0.00           C  
ATOM   1052  O   ALA A  64       2.972  -5.560   0.171  1.00  0.00           O  
ATOM   1053  CB  ALA A  64       3.960  -8.586   0.495  1.00  0.00           C  
ATOM   1054  H   ALA A  64       5.630  -8.170   2.334  1.00  0.00           H  
ATOM   1055  HA  ALA A  64       5.087  -6.890  -0.178  1.00  0.00           H  
ATOM   1056  HB1 ALA A  64       3.270  -8.527  -0.346  1.00  0.00           H  
ATOM   1057  HB2 ALA A  64       4.734  -9.320   0.264  1.00  0.00           H  
ATOM   1058  HB3 ALA A  64       3.414  -8.907   1.382  1.00  0.00           H  
ATOM   1059  N   LEU A  65       3.283  -5.946   2.378  1.00  0.00           N  
ATOM   1060  CA  LEU A  65       2.366  -4.904   2.815  1.00  0.00           C  
ATOM   1061  C   LEU A  65       2.938  -3.539   2.427  1.00  0.00           C  
ATOM   1062  O   LEU A  65       2.374  -2.869   1.569  1.00  0.00           O  
ATOM   1063  CB  LEU A  65       2.081  -5.042   4.310  1.00  0.00           C  
ATOM   1064  CG  LEU A  65       1.054  -4.034   4.822  1.00  0.00           C  
ATOM   1065  CD1 LEU A  65      -0.376  -4.377   4.388  1.00  0.00           C  
ATOM   1066  CD2 LEU A  65       1.150  -4.033   6.341  1.00  0.00           C  
ATOM   1067  H   LEU A  65       3.857  -6.408   3.075  1.00  0.00           H  
ATOM   1068  HA  LEU A  65       1.415  -5.025   2.306  1.00  0.00           H  
ATOM   1069  HB2 LEU A  65       1.705  -6.040   4.513  1.00  0.00           H  
ATOM   1070  HB3 LEU A  65       3.000  -4.887   4.866  1.00  0.00           H  
ATOM   1071  HG  LEU A  65       1.320  -3.040   4.474  1.00  0.00           H  
ATOM   1072 HD11 LEU A  65      -1.062  -3.633   4.789  1.00  0.00           H  
ATOM   1073 HD12 LEU A  65      -0.456  -4.372   3.304  1.00  0.00           H  
ATOM   1074 HD13 LEU A  65      -0.657  -5.361   4.763  1.00  0.00           H  
ATOM   1075 HD21 LEU A  65       0.438  -3.317   6.741  1.00  0.00           H  
ATOM   1076 HD22 LEU A  65       0.938  -5.037   6.712  1.00  0.00           H  
ATOM   1077 HD23 LEU A  65       2.157  -3.740   6.637  1.00  0.00           H  
ATOM   1078  N   SER A  66       4.065  -3.151   3.036  1.00  0.00           N  
ATOM   1079  CA  SER A  66       4.786  -1.914   2.768  1.00  0.00           C  
ATOM   1080  C   SER A  66       4.968  -1.642   1.279  1.00  0.00           C  
ATOM   1081  O   SER A  66       4.755  -0.511   0.866  1.00  0.00           O  
ATOM   1082  CB  SER A  66       6.126  -1.932   3.513  1.00  0.00           C  
ATOM   1083  OG  SER A  66       6.936  -3.006   3.090  1.00  0.00           O  
ATOM   1084  H   SER A  66       4.400  -3.717   3.801  1.00  0.00           H  
ATOM   1085  HA  SER A  66       4.224  -1.069   3.172  1.00  0.00           H  
ATOM   1086  HB2 SER A  66       6.656  -0.994   3.333  1.00  0.00           H  
ATOM   1087  HB3 SER A  66       5.944  -2.030   4.584  1.00  0.00           H  
ATOM   1088  HG  SER A  66       6.453  -3.831   3.210  1.00  0.00           H  
ATOM   1089  N   LYS A  67       5.313  -2.650   0.466  1.00  0.00           N  
ATOM   1090  CA  LYS A  67       5.385  -2.467  -0.980  1.00  0.00           C  
ATOM   1091  C   LYS A  67       4.033  -1.976  -1.520  1.00  0.00           C  
ATOM   1092  O   LYS A  67       3.957  -0.866  -2.043  1.00  0.00           O  
ATOM   1093  CB  LYS A  67       5.878  -3.742  -1.686  1.00  0.00           C  
ATOM   1094  CG  LYS A  67       7.387  -3.717  -1.973  1.00  0.00           C  
ATOM   1095  CD  LYS A  67       8.249  -3.859  -0.714  1.00  0.00           C  
ATOM   1096  CE  LYS A  67       9.732  -3.691  -1.055  1.00  0.00           C  
ATOM   1097  NZ  LYS A  67      10.533  -3.865   0.142  1.00  0.00           N  
ATOM   1098  H   LYS A  67       5.430  -3.579   0.853  1.00  0.00           H  
ATOM   1099  HA  LYS A  67       6.092  -1.661  -1.182  1.00  0.00           H  
ATOM   1100  HB2 LYS A  67       5.607  -4.634  -1.118  1.00  0.00           H  
ATOM   1101  HB3 LYS A  67       5.394  -3.798  -2.659  1.00  0.00           H  
ATOM   1102  HG2 LYS A  67       7.622  -4.550  -2.639  1.00  0.00           H  
ATOM   1103  HG3 LYS A  67       7.639  -2.790  -2.488  1.00  0.00           H  
ATOM   1104  HD2 LYS A  67       7.965  -3.108   0.023  1.00  0.00           H  
ATOM   1105  HD3 LYS A  67       8.100  -4.854  -0.301  1.00  0.00           H  
ATOM   1106  HE2 LYS A  67      10.027  -4.438  -1.793  1.00  0.00           H  
ATOM   1107  HE3 LYS A  67       9.908  -2.696  -1.462  1.00  0.00           H  
ATOM   1108  HZ1 LYS A  67      11.516  -3.678   0.002  1.00  0.00           H  
ATOM   1109  HZ2 LYS A  67      10.353  -4.732   0.626  1.00  0.00           H  
ATOM   1110  N   LEU A  68       2.970  -2.781  -1.379  1.00  0.00           N  
ATOM   1111  CA  LEU A  68       1.642  -2.449  -1.891  1.00  0.00           C  
ATOM   1112  C   LEU A  68       1.117  -1.115  -1.326  1.00  0.00           C  
ATOM   1113  O   LEU A  68       0.474  -0.352  -2.043  1.00  0.00           O  
ATOM   1114  CB  LEU A  68       0.719  -3.644  -1.603  1.00  0.00           C  
ATOM   1115  CG  LEU A  68      -0.694  -3.630  -2.221  1.00  0.00           C  
ATOM   1116  CD1 LEU A  68      -1.714  -3.047  -1.252  1.00  0.00           C  
ATOM   1117  CD2 LEU A  68      -0.842  -2.950  -3.583  1.00  0.00           C  
ATOM   1118  H   LEU A  68       3.121  -3.735  -1.074  1.00  0.00           H  
ATOM   1119  HA  LEU A  68       1.717  -2.409  -2.979  1.00  0.00           H  
ATOM   1120  HB2 LEU A  68       1.217  -4.528  -2.007  1.00  0.00           H  
ATOM   1121  HB3 LEU A  68       0.641  -3.785  -0.524  1.00  0.00           H  
ATOM   1122  HG  LEU A  68      -0.975  -4.672  -2.365  1.00  0.00           H  
ATOM   1123 HD11 LEU A  68      -2.711  -3.071  -1.693  1.00  0.00           H  
ATOM   1124 HD12 LEU A  68      -1.701  -3.680  -0.371  1.00  0.00           H  
ATOM   1125 HD13 LEU A  68      -1.454  -2.026  -0.985  1.00  0.00           H  
ATOM   1126 HD21 LEU A  68      -1.844  -3.152  -3.965  1.00  0.00           H  
ATOM   1127 HD22 LEU A  68      -0.729  -1.874  -3.494  1.00  0.00           H  
ATOM   1128 HD23 LEU A  68      -0.106  -3.350  -4.272  1.00  0.00           H  
ATOM   1129  N   LEU A  69       1.419  -0.799  -0.061  1.00  0.00           N  
ATOM   1130  CA  LEU A  69       1.065   0.465   0.569  1.00  0.00           C  
ATOM   1131  C   LEU A  69       1.786   1.624  -0.114  1.00  0.00           C  
ATOM   1132  O   LEU A  69       1.138   2.499  -0.683  1.00  0.00           O  
ATOM   1133  CB  LEU A  69       1.383   0.422   2.074  1.00  0.00           C  
ATOM   1134  CG  LEU A  69       0.173   0.122   2.969  1.00  0.00           C  
ATOM   1135  CD1 LEU A  69      -0.795   1.308   3.041  1.00  0.00           C  
ATOM   1136  CD2 LEU A  69      -0.567  -1.138   2.527  1.00  0.00           C  
ATOM   1137  H   LEU A  69       2.090  -1.374   0.424  1.00  0.00           H  
ATOM   1138  HA  LEU A  69       0.012   0.649   0.380  1.00  0.00           H  
ATOM   1139  HB2 LEU A  69       2.142  -0.337   2.257  1.00  0.00           H  
ATOM   1140  HB3 LEU A  69       1.806   1.371   2.400  1.00  0.00           H  
ATOM   1141  HG  LEU A  69       0.557  -0.058   3.974  1.00  0.00           H  
ATOM   1142 HD11 LEU A  69      -1.635   1.060   3.687  1.00  0.00           H  
ATOM   1143 HD12 LEU A  69      -0.274   2.167   3.461  1.00  0.00           H  
ATOM   1144 HD13 LEU A  69      -1.176   1.568   2.054  1.00  0.00           H  
ATOM   1145 HD21 LEU A  69      -1.330  -1.364   3.271  1.00  0.00           H  
ATOM   1146 HD22 LEU A  69      -1.039  -0.987   1.559  1.00  0.00           H  
ATOM   1147 HD23 LEU A  69       0.125  -1.977   2.462  1.00  0.00           H  
ATOM   1148  N   GLU A  70       3.121   1.626  -0.043  1.00  0.00           N  
ATOM   1149  CA  GLU A  70       3.987   2.661  -0.590  1.00  0.00           C  
ATOM   1150  C   GLU A  70       3.676   2.936  -2.065  1.00  0.00           C  
ATOM   1151  O   GLU A  70       3.688   4.094  -2.473  1.00  0.00           O  
ATOM   1152  CB  GLU A  70       5.451   2.253  -0.380  1.00  0.00           C  
ATOM   1153  CG  GLU A  70       5.867   2.393   1.091  1.00  0.00           C  
ATOM   1154  CD  GLU A  70       7.297   1.911   1.312  1.00  0.00           C  
ATOM   1155  OE1 GLU A  70       8.165   2.722   1.630  1.00  0.00           O  
ATOM   1156  OE2 GLU A  70       7.519   0.578   1.137  1.00  0.00           O  
ATOM   1157  H   GLU A  70       3.572   0.853   0.424  1.00  0.00           H  
ATOM   1158  HA  GLU A  70       3.806   3.584  -0.040  1.00  0.00           H  
ATOM   1159  HB2 GLU A  70       5.593   1.224  -0.715  1.00  0.00           H  
ATOM   1160  HB3 GLU A  70       6.094   2.903  -0.970  1.00  0.00           H  
ATOM   1161  HG2 GLU A  70       5.799   3.444   1.378  1.00  0.00           H  
ATOM   1162  HG3 GLU A  70       5.200   1.823   1.737  1.00  0.00           H  
ATOM   1163  HE2 GLU A  70       8.436   0.333   1.281  1.00  0.00           H  
ATOM   1164  N   ARG A  71       3.345   1.892  -2.839  1.00  0.00           N  
ATOM   1165  CA  ARG A  71       2.813   2.005  -4.194  1.00  0.00           C  
ATOM   1166  C   ARG A  71       1.664   3.017  -4.254  1.00  0.00           C  
ATOM   1167  O   ARG A  71       1.748   3.973  -5.022  1.00  0.00           O  
ATOM   1168  CB  ARG A  71       2.429   0.609  -4.723  1.00  0.00           C  
ATOM   1169  CG  ARG A  71       1.198   0.550  -5.639  1.00  0.00           C  
ATOM   1170  CD  ARG A  71       1.303   1.412  -6.904  1.00  0.00           C  
ATOM   1171  NE  ARG A  71       0.196   2.378  -7.045  1.00  0.00           N  
ATOM   1172  CZ  ARG A  71      -1.123   2.109  -7.065  1.00  0.00           C  
ATOM   1173  NH1 ARG A  71      -1.587   0.861  -6.926  1.00  0.00           N  
ATOM   1174  NH2 ARG A  71      -2.005   3.108  -7.189  1.00  0.00           N  
ATOM   1175  H   ARG A  71       3.279   0.986  -2.393  1.00  0.00           H  
ATOM   1176  HA  ARG A  71       3.584   2.411  -4.852  1.00  0.00           H  
ATOM   1177  HB2 ARG A  71       3.289   0.189  -5.245  1.00  0.00           H  
ATOM   1178  HB3 ARG A  71       2.209  -0.043  -3.880  1.00  0.00           H  
ATOM   1179  HG2 ARG A  71       1.048  -0.488  -5.923  1.00  0.00           H  
ATOM   1180  HG3 ARG A  71       0.322   0.828  -5.066  1.00  0.00           H  
ATOM   1181  HD2 ARG A  71       2.240   1.970  -6.894  1.00  0.00           H  
ATOM   1182  HD3 ARG A  71       1.332   0.764  -7.773  1.00  0.00           H  
ATOM   1183  HE  ARG A  71       0.472   3.349  -7.112  1.00  0.00           H  
ATOM   1184 HH11 ARG A  71      -0.946   0.096  -6.784  1.00  0.00           H  
ATOM   1185 HH12 ARG A  71      -2.584   0.702  -6.876  1.00  0.00           H  
ATOM   1186 HH21 ARG A  71      -1.674   4.058  -7.284  1.00  0.00           H  
ATOM   1187 HH22 ARG A  71      -2.996   2.919  -7.212  1.00  0.00           H  
ATOM   1188  N   ILE A  72       0.584   2.791  -3.497  1.00  0.00           N  
ATOM   1189  CA  ILE A  72      -0.675   3.480  -3.751  1.00  0.00           C  
ATOM   1190  C   ILE A  72      -0.525   4.991  -3.575  1.00  0.00           C  
ATOM   1191  O   ILE A  72      -0.709   5.741  -4.529  1.00  0.00           O  
ATOM   1192  CB  ILE A  72      -1.833   2.878  -2.939  1.00  0.00           C  
ATOM   1193  CG1 ILE A  72      -2.036   1.392  -3.279  1.00  0.00           C  
ATOM   1194  CG2 ILE A  72      -3.139   3.597  -3.309  1.00  0.00           C  
ATOM   1195  CD1 ILE A  72      -2.632   0.644  -2.089  1.00  0.00           C  
ATOM   1196  H   ILE A  72       0.566   1.938  -2.953  1.00  0.00           H  
ATOM   1197  HA  ILE A  72      -0.949   3.271  -4.773  1.00  0.00           H  
ATOM   1198  HB  ILE A  72      -1.625   2.997  -1.874  1.00  0.00           H  
ATOM   1199 HG12 ILE A  72      -2.670   1.288  -4.161  1.00  0.00           H  
ATOM   1200 HG13 ILE A  72      -1.097   0.908  -3.511  1.00  0.00           H  
ATOM   1201 HG21 ILE A  72      -3.982   3.118  -2.813  1.00  0.00           H  
ATOM   1202 HG22 ILE A  72      -3.101   4.642  -3.008  1.00  0.00           H  
ATOM   1203 HG23 ILE A  72      -3.295   3.542  -4.388  1.00  0.00           H  
ATOM   1204 HD11 ILE A  72      -2.761  -0.404  -2.357  1.00  0.00           H  
ATOM   1205 HD12 ILE A  72      -1.949   0.714  -1.241  1.00  0.00           H  
ATOM   1206 HD13 ILE A  72      -3.593   1.072  -1.812  1.00  0.00           H  
ATOM   1207  N   LYS A  73      -0.178   5.422  -2.360  1.00  0.00           N  
ATOM   1208  CA  LYS A  73       0.049   6.820  -2.028  1.00  0.00           C  
ATOM   1209  C   LYS A  73       1.037   7.510  -2.974  1.00  0.00           C  
ATOM   1210  O   LYS A  73       0.745   8.597  -3.466  1.00  0.00           O  
ATOM   1211  CB  LYS A  73       0.486   6.927  -0.562  1.00  0.00           C  
ATOM   1212  CG  LYS A  73       1.613   5.970  -0.134  1.00  0.00           C  
ATOM   1213  CD  LYS A  73       1.425   5.587   1.339  1.00  0.00           C  
ATOM   1214  CE  LYS A  73       0.268   4.592   1.553  1.00  0.00           C  
ATOM   1215  NZ  LYS A  73      -0.375   4.849   2.828  1.00  0.00           N  
ATOM   1216  H   LYS A  73      -0.211   4.763  -1.594  1.00  0.00           H  
ATOM   1217  HA  LYS A  73      -0.914   7.335  -2.066  1.00  0.00           H  
ATOM   1218  HB2 LYS A  73       0.783   7.953  -0.343  1.00  0.00           H  
ATOM   1219  HB3 LYS A  73      -0.403   6.720   0.030  1.00  0.00           H  
ATOM   1220  HG2 LYS A  73       1.644   5.055  -0.721  1.00  0.00           H  
ATOM   1221  HG3 LYS A  73       2.569   6.481  -0.258  1.00  0.00           H  
ATOM   1222  HD2 LYS A  73       2.342   5.129   1.705  1.00  0.00           H  
ATOM   1223  HD3 LYS A  73       1.247   6.506   1.898  1.00  0.00           H  
ATOM   1224  HE2 LYS A  73      -0.479   4.656   0.762  1.00  0.00           H  
ATOM   1225  HE3 LYS A  73       0.659   3.576   1.555  1.00  0.00           H  
ATOM   1226  HZ1 LYS A  73      -1.072   4.161   3.072  1.00  0.00           H  
ATOM   1227  HZ2 LYS A  73      -0.698   5.800   2.933  1.00  0.00           H  
ATOM   1228  N   GLN A  74       2.191   6.880  -3.228  1.00  0.00           N  
ATOM   1229  CA  GLN A  74       3.220   7.419  -4.113  1.00  0.00           C  
ATOM   1230  C   GLN A  74       2.664   7.659  -5.518  1.00  0.00           C  
ATOM   1231  O   GLN A  74       2.827   8.749  -6.063  1.00  0.00           O  
ATOM   1232  CB  GLN A  74       4.434   6.479  -4.131  1.00  0.00           C  
ATOM   1233  CG  GLN A  74       5.612   6.989  -4.973  1.00  0.00           C  
ATOM   1234  CD  GLN A  74       5.445   6.700  -6.464  1.00  0.00           C  
ATOM   1235  OE1 GLN A  74       5.407   5.543  -6.874  1.00  0.00           O  
ATOM   1236  NE2 GLN A  74       5.347   7.746  -7.287  1.00  0.00           N  
ATOM   1237  H   GLN A  74       2.364   5.987  -2.783  1.00  0.00           H  
ATOM   1238  HA  GLN A  74       3.547   8.379  -3.704  1.00  0.00           H  
ATOM   1239  HB2 GLN A  74       4.786   6.379  -3.103  1.00  0.00           H  
ATOM   1240  HB3 GLN A  74       4.137   5.496  -4.497  1.00  0.00           H  
ATOM   1241  HG2 GLN A  74       5.760   8.054  -4.794  1.00  0.00           H  
ATOM   1242  HG3 GLN A  74       6.510   6.464  -4.645  1.00  0.00           H  
ATOM   1243 HE21 GLN A  74       5.345   8.686  -6.914  1.00  0.00           H  
ATOM   1244 HE22 GLN A  74       5.232   7.594  -8.278  1.00  0.00           H  
ATOM   1245  N   GLY A  75       2.033   6.633  -6.099  1.00  0.00           N  
ATOM   1246  CA  GLY A  75       1.484   6.645  -7.443  1.00  0.00           C  
ATOM   1247  C   GLY A  75      -0.043   6.690  -7.380  1.00  0.00           C  
ATOM   1248  O   GLY A  75      -0.663   5.628  -7.421  1.00  0.00           O  
ATOM   1249  H   GLY A  75       1.927   5.777  -5.570  1.00  0.00           H  
ATOM   1250  HA2 GLY A  75       1.895   7.455  -8.044  1.00  0.00           H  
ATOM   1251  HA3 GLY A  75       1.774   5.710  -7.922  1.00  0.00           H  
ATOM   1252  N   PRO A  76      -0.667   7.879  -7.279  1.00  0.00           N  
ATOM   1253  CA  PRO A  76      -2.116   8.017  -7.178  1.00  0.00           C  
ATOM   1254  C   PRO A  76      -2.808   7.565  -8.471  1.00  0.00           C  
ATOM   1255  O   PRO A  76      -2.156   7.438  -9.507  1.00  0.00           O  
ATOM   1256  CB  PRO A  76      -2.360   9.506  -6.896  1.00  0.00           C  
ATOM   1257  CG  PRO A  76      -1.152  10.189  -7.529  1.00  0.00           C  
ATOM   1258  CD  PRO A  76      -0.034   9.188  -7.258  1.00  0.00           C  
ATOM   1259  HA  PRO A  76      -2.476   7.422  -6.337  1.00  0.00           H  
ATOM   1260  HB2 PRO A  76      -3.292   9.885  -7.319  1.00  0.00           H  
ATOM   1261  HB3 PRO A  76      -2.341   9.677  -5.819  1.00  0.00           H  
ATOM   1262  HG2 PRO A  76      -1.310  10.278  -8.606  1.00  0.00           H  
ATOM   1263  HG3 PRO A  76      -0.949  11.166  -7.092  1.00  0.00           H  
ATOM   1264  HD2 PRO A  76       0.742   9.300  -8.015  1.00  0.00           H  
ATOM   1265  HD3 PRO A  76       0.369   9.371  -6.262  1.00  0.00           H  
ATOM   1266  N   PRO A  77      -4.128   7.314  -8.428  1.00  0.00           N  
ATOM   1267  CA  PRO A  77      -4.893   6.906  -9.596  1.00  0.00           C  
ATOM   1268  C   PRO A  77      -5.026   8.053 -10.597  1.00  0.00           C  
ATOM   1269  O   PRO A  77      -4.803   9.214 -10.260  1.00  0.00           O  
ATOM   1270  CB  PRO A  77      -6.264   6.497  -9.059  1.00  0.00           C  
ATOM   1271  CG  PRO A  77      -6.416   7.348  -7.799  1.00  0.00           C  
ATOM   1272  CD  PRO A  77      -4.989   7.421  -7.259  1.00  0.00           C  
ATOM   1273  HA  PRO A  77      -4.418   6.051 -10.082  1.00  0.00           H  
ATOM   1274  HB2 PRO A  77      -7.072   6.671  -9.771  1.00  0.00           H  
ATOM   1275  HB3 PRO A  77      -6.224   5.446  -8.785  1.00  0.00           H  
ATOM   1276  HG2 PRO A  77      -6.749   8.348  -8.081  1.00  0.00           H  
ATOM   1277  HG3 PRO A  77      -7.105   6.904  -7.081  1.00  0.00           H  
ATOM   1278  HD2 PRO A  77      -4.853   8.355  -6.715  1.00  0.00           H  
ATOM   1279  HD3 PRO A  77      -4.805   6.575  -6.595  1.00  0.00           H  
ATOM   1280  N   ALA A  78      -5.438   7.717 -11.826  1.00  0.00           N  
ATOM   1281  CA  ALA A  78      -5.663   8.676 -12.896  1.00  0.00           C  
ATOM   1282  C   ALA A  78      -7.036   9.346 -12.760  1.00  0.00           C  
ATOM   1283  O   ALA A  78      -7.746   9.512 -13.749  1.00  0.00           O  
ATOM   1284  CB  ALA A  78      -5.508   7.956 -14.241  1.00  0.00           C  
ATOM   1285  H   ALA A  78      -5.618   6.746 -12.031  1.00  0.00           H  
ATOM   1286  HA  ALA A  78      -4.896   9.449 -12.846  1.00  0.00           H  
ATOM   1287  HB1 ALA A  78      -5.600   8.671 -15.060  1.00  0.00           H  
ATOM   1288  HB2 ALA A  78      -4.524   7.489 -14.296  1.00  0.00           H  
ATOM   1289  HB3 ALA A  78      -6.274   7.188 -14.345  1.00  0.00           H  
ATOM   1290  N   ALA A  79      -7.410   9.734 -11.534  1.00  0.00           N  
ATOM   1291  CA  ALA A  79      -8.659  10.403 -11.218  1.00  0.00           C  
ATOM   1292  C   ALA A  79      -8.455  11.304 -10.002  1.00  0.00           C  
ATOM   1293  O   ALA A  79      -7.448  11.203  -9.300  1.00  0.00           O  
ATOM   1294  CB  ALA A  79      -9.730   9.365 -10.915  1.00  0.00           C  
ATOM   1295  H   ALA A  79      -6.795   9.574 -10.748  1.00  0.00           H  
ATOM   1296  HA  ALA A  79      -9.007  10.986 -12.069  1.00  0.00           H  
ATOM   1297  HB1 ALA A  79     -10.542   9.830 -10.361  1.00  0.00           H  
ATOM   1298  HB2 ALA A  79     -10.128   8.976 -11.850  1.00  0.00           H  
ATOM   1299  HB3 ALA A  79      -9.290   8.566 -10.322  1.00  0.00           H  
ATOM   1300  N   GLU A  80      -9.440  12.168  -9.747  1.00  0.00           N  
ATOM   1301  CA  GLU A  80      -9.459  13.088  -8.624  1.00  0.00           C  
ATOM   1302  C   GLU A  80      -9.814  12.328  -7.345  1.00  0.00           C  
ATOM   1303  O   GLU A  80     -10.955  12.370  -6.885  1.00  0.00           O  
ATOM   1304  CB  GLU A  80     -10.444  14.238  -8.893  1.00  0.00           C  
ATOM   1305  CG  GLU A  80     -10.012  15.161 -10.046  1.00  0.00           C  
ATOM   1306  CD  GLU A  80     -10.131  14.534 -11.436  1.00  0.00           C  
ATOM   1307  OE1 GLU A  80     -10.947  13.636 -11.635  1.00  0.00           O  
ATOM   1308  OE2 GLU A  80      -9.289  15.031 -12.384  1.00  0.00           O  
ATOM   1309  H   GLU A  80     -10.225  12.200 -10.387  1.00  0.00           H  
ATOM   1310  HA  GLU A  80      -8.463  13.517  -8.492  1.00  0.00           H  
ATOM   1311  HB2 GLU A  80     -11.444  13.846  -9.085  1.00  0.00           H  
ATOM   1312  HB3 GLU A  80     -10.490  14.851  -7.991  1.00  0.00           H  
ATOM   1313  HG2 GLU A  80     -10.647  16.047 -10.031  1.00  0.00           H  
ATOM   1314  HG3 GLU A  80      -8.980  15.475  -9.880  1.00  0.00           H  
ATOM   1315  HE2 GLU A  80      -9.403  14.603 -13.237  1.00  0.00           H  
ATOM   1316  N   VAL A  81      -8.814  11.655  -6.764  1.00  0.00           N  
ATOM   1317  CA  VAL A  81      -8.890  11.070  -5.435  1.00  0.00           C  
ATOM   1318  C   VAL A  81      -9.100  12.192  -4.417  1.00  0.00           C  
ATOM   1319  O   VAL A  81      -8.313  13.135  -4.343  1.00  0.00           O  
ATOM   1320  CB  VAL A  81      -7.655  10.188  -5.174  1.00  0.00           C  
ATOM   1321  CG1 VAL A  81      -6.325  10.951  -5.142  1.00  0.00           C  
ATOM   1322  CG2 VAL A  81      -7.821   9.384  -3.880  1.00  0.00           C  
ATOM   1323  H   VAL A  81      -7.924  11.622  -7.243  1.00  0.00           H  
ATOM   1324  HA  VAL A  81      -9.767  10.422  -5.389  1.00  0.00           H  
ATOM   1325  HB  VAL A  81      -7.598   9.480  -6.002  1.00  0.00           H  
ATOM   1326 HG11 VAL A  81      -6.260  11.571  -4.249  1.00  0.00           H  
ATOM   1327 HG12 VAL A  81      -5.501  10.238  -5.121  1.00  0.00           H  
ATOM   1328 HG13 VAL A  81      -6.217  11.580  -6.026  1.00  0.00           H  
ATOM   1329 HG21 VAL A  81      -7.877  10.053  -3.021  1.00  0.00           H  
ATOM   1330 HG22 VAL A  81      -8.730   8.785  -3.927  1.00  0.00           H  
ATOM   1331 HG23 VAL A  81      -6.968   8.716  -3.755  1.00  0.00           H  
ATOM   1332  N   GLU A  82     -10.217  12.113  -3.692  1.00  0.00           N  
ATOM   1333  CA  GLU A  82     -10.731  13.182  -2.857  1.00  0.00           C  
ATOM   1334  C   GLU A  82     -10.119  13.107  -1.460  1.00  0.00           C  
ATOM   1335  O   GLU A  82      -9.634  14.117  -0.954  1.00  0.00           O  
ATOM   1336  CB  GLU A  82     -12.263  13.081  -2.842  1.00  0.00           C  
ATOM   1337  CG  GLU A  82     -12.941  14.175  -2.005  1.00  0.00           C  
ATOM   1338  CD  GLU A  82     -12.681  15.571  -2.562  1.00  0.00           C  
ATOM   1339  OE1 GLU A  82     -11.942  16.338  -1.950  1.00  0.00           O  
ATOM   1340  OE2 GLU A  82     -13.311  15.871  -3.733  1.00  0.00           O  
ATOM   1341  H   GLU A  82     -10.785  11.281  -3.778  1.00  0.00           H  
ATOM   1342  HA  GLU A  82     -10.451  14.141  -3.300  1.00  0.00           H  
ATOM   1343  HB2 GLU A  82     -12.616  13.161  -3.871  1.00  0.00           H  
ATOM   1344  HB3 GLU A  82     -12.556  12.103  -2.458  1.00  0.00           H  
ATOM   1345  HG2 GLU A  82     -14.016  13.998  -2.006  1.00  0.00           H  
ATOM   1346  HG3 GLU A  82     -12.593  14.132  -0.972  1.00  0.00           H  
ATOM   1347  HE2 GLU A  82     -13.122  16.764  -4.031  1.00  0.00           H  
ATOM   1348  N   LYS A  83     -10.153  11.921  -0.837  1.00  0.00           N  
ATOM   1349  CA  LYS A  83      -9.704  11.744   0.541  1.00  0.00           C  
ATOM   1350  C   LYS A  83      -9.529  10.266   0.890  1.00  0.00           C  
ATOM   1351  O   LYS A  83     -10.288   9.699   1.669  1.00  0.00           O  
ATOM   1352  CB  LYS A  83     -10.632  12.469   1.529  1.00  0.00           C  
ATOM   1353  CG  LYS A  83     -12.115  12.090   1.401  1.00  0.00           C  
ATOM   1354  CD  LYS A  83     -12.964  12.932   2.357  1.00  0.00           C  
ATOM   1355  CE  LYS A  83     -14.428  12.487   2.291  1.00  0.00           C  
ATOM   1356  NZ  LYS A  83     -15.226  13.265   3.218  1.00  0.00           N  
ATOM   1357  H   LYS A  83     -10.502  11.120  -1.346  1.00  0.00           H  
ATOM   1358  HA  LYS A  83      -8.720  12.201   0.631  1.00  0.00           H  
ATOM   1359  HB2 LYS A  83     -10.285  12.247   2.539  1.00  0.00           H  
ATOM   1360  HB3 LYS A  83     -10.530  13.541   1.368  1.00  0.00           H  
ATOM   1361  HG2 LYS A  83     -12.457  12.253   0.380  1.00  0.00           H  
ATOM   1362  HG3 LYS A  83     -12.262  11.043   1.654  1.00  0.00           H  
ATOM   1363  HD2 LYS A  83     -12.593  12.801   3.375  1.00  0.00           H  
ATOM   1364  HD3 LYS A  83     -12.887  13.985   2.081  1.00  0.00           H  
ATOM   1365  HE2 LYS A  83     -14.810  12.632   1.279  1.00  0.00           H  
ATOM   1366  HE3 LYS A  83     -14.503  11.431   2.554  1.00  0.00           H  
ATOM   1367  HZ1 LYS A  83     -16.184  12.955   3.287  1.00  0.00           H  
ATOM   1368  HZ2 LYS A  83     -15.132  14.263   3.096  1.00  0.00           H  
ATOM   1369  N   VAL A  84      -8.488   9.655   0.326  1.00  0.00           N  
ATOM   1370  CA  VAL A  84      -8.160   8.251   0.554  1.00  0.00           C  
ATOM   1371  C   VAL A  84      -7.752   8.009   2.013  1.00  0.00           C  
ATOM   1372  O   VAL A  84      -6.596   8.185   2.391  1.00  0.00           O  
ATOM   1373  CB  VAL A  84      -7.141   7.741  -0.481  1.00  0.00           C  
ATOM   1374  CG1 VAL A  84      -5.873   8.595  -0.638  1.00  0.00           C  
ATOM   1375  CG2 VAL A  84      -6.759   6.291  -0.164  1.00  0.00           C  
ATOM   1376  H   VAL A  84      -7.901  10.216  -0.266  1.00  0.00           H  
ATOM   1377  HA  VAL A  84      -9.072   7.683   0.372  1.00  0.00           H  
ATOM   1378  HB  VAL A  84      -7.647   7.745  -1.446  1.00  0.00           H  
ATOM   1379 HG11 VAL A  84      -5.312   8.644   0.293  1.00  0.00           H  
ATOM   1380 HG12 VAL A  84      -5.236   8.148  -1.402  1.00  0.00           H  
ATOM   1381 HG13 VAL A  84      -6.125   9.606  -0.956  1.00  0.00           H  
ATOM   1382 HG21 VAL A  84      -6.055   6.250   0.668  1.00  0.00           H  
ATOM   1383 HG22 VAL A  84      -7.652   5.730   0.109  1.00  0.00           H  
ATOM   1384 HG23 VAL A  84      -6.299   5.832  -1.039  1.00  0.00           H  
ATOM   1385  N   ASP A  85      -8.731   7.606   2.833  1.00  0.00           N  
ATOM   1386  CA  ASP A  85      -8.601   7.443   4.269  1.00  0.00           C  
ATOM   1387  C   ASP A  85      -8.575   5.949   4.573  1.00  0.00           C  
ATOM   1388  O   ASP A  85      -9.613   5.364   4.883  1.00  0.00           O  
ATOM   1389  CB  ASP A  85      -9.791   8.136   4.950  1.00  0.00           C  
ATOM   1390  CG  ASP A  85      -9.781   7.958   6.468  1.00  0.00           C  
ATOM   1391  OD1 ASP A  85      -8.711   7.926   7.072  1.00  0.00           O  
ATOM   1392  OD2 ASP A  85     -11.004   7.840   7.059  1.00  0.00           O  
ATOM   1393  H   ASP A  85      -9.666   7.541   2.458  1.00  0.00           H  
ATOM   1394  HA  ASP A  85      -7.706   7.943   4.639  1.00  0.00           H  
ATOM   1395  HB2 ASP A  85      -9.760   9.203   4.725  1.00  0.00           H  
ATOM   1396  HB3 ASP A  85     -10.723   7.731   4.554  1.00  0.00           H  
ATOM   1397  HD2 ASP A  85     -10.940   7.712   8.009  1.00  0.00           H  
ATOM   1398  N   TYR A  86      -7.397   5.326   4.461  1.00  0.00           N  
ATOM   1399  CA  TYR A  86      -7.275   3.901   4.724  1.00  0.00           C  
ATOM   1400  C   TYR A  86      -7.257   3.628   6.231  1.00  0.00           C  
ATOM   1401  O   TYR A  86      -7.033   4.534   7.033  1.00  0.00           O  
ATOM   1402  CB  TYR A  86      -6.057   3.298   4.004  1.00  0.00           C  
ATOM   1403  CG  TYR A  86      -4.728   3.474   4.715  1.00  0.00           C  
ATOM   1404  CD1 TYR A  86      -4.000   4.670   4.579  1.00  0.00           C  
ATOM   1405  CD2 TYR A  86      -4.217   2.429   5.511  1.00  0.00           C  
ATOM   1406  CE1 TYR A  86      -2.763   4.818   5.230  1.00  0.00           C  
ATOM   1407  CE2 TYR A  86      -2.979   2.577   6.156  1.00  0.00           C  
ATOM   1408  CZ  TYR A  86      -2.245   3.766   6.008  1.00  0.00           C  
ATOM   1409  OH  TYR A  86      -1.031   3.897   6.620  1.00  0.00           O  
ATOM   1410  H   TYR A  86      -6.574   5.849   4.203  1.00  0.00           H  
ATOM   1411  HA  TYR A  86      -8.165   3.438   4.300  1.00  0.00           H  
ATOM   1412  HB2 TYR A  86      -6.224   2.226   3.904  1.00  0.00           H  
ATOM   1413  HB3 TYR A  86      -5.994   3.705   2.994  1.00  0.00           H  
ATOM   1414  HD1 TYR A  86      -4.385   5.477   3.973  1.00  0.00           H  
ATOM   1415  HD2 TYR A  86      -4.771   1.508   5.630  1.00  0.00           H  
ATOM   1416  HE1 TYR A  86      -2.210   5.739   5.124  1.00  0.00           H  
ATOM   1417  HE2 TYR A  86      -2.588   1.771   6.762  1.00  0.00           H  
ATOM   1418  HH  TYR A  86      -0.608   4.740   6.443  1.00  0.00           H  
ATOM   1419  N   SER A  87      -7.493   2.367   6.600  1.00  0.00           N  
ATOM   1420  CA  SER A  87      -7.515   1.888   7.971  1.00  0.00           C  
ATOM   1421  C   SER A  87      -6.823   0.526   8.051  1.00  0.00           C  
ATOM   1422  O   SER A  87      -7.353  -0.479   7.586  1.00  0.00           O  
ATOM   1423  CB  SER A  87      -8.959   1.805   8.479  1.00  0.00           C  
ATOM   1424  OG  SER A  87      -9.608   3.051   8.331  1.00  0.00           O  
ATOM   1425  H   SER A  87      -7.663   1.684   5.880  1.00  0.00           H  
ATOM   1426  HA  SER A  87      -6.979   2.592   8.606  1.00  0.00           H  
ATOM   1427  HB2 SER A  87      -9.513   1.049   7.922  1.00  0.00           H  
ATOM   1428  HB3 SER A  87      -8.952   1.526   9.533  1.00  0.00           H  
ATOM   1429  HG  SER A  87      -9.046   3.737   8.699  1.00  0.00           H  
ATOM   1430  N   PHE A  88      -5.646   0.501   8.684  1.00  0.00           N  
ATOM   1431  CA  PHE A  88      -4.989  -0.722   9.123  1.00  0.00           C  
ATOM   1432  C   PHE A  88      -5.922  -1.433  10.112  1.00  0.00           C  
ATOM   1433  O   PHE A  88      -6.297  -0.854  11.131  1.00  0.00           O  
ATOM   1434  CB  PHE A  88      -3.621  -0.350   9.739  1.00  0.00           C  
ATOM   1435  CG  PHE A  88      -3.157  -1.149  10.947  1.00  0.00           C  
ATOM   1436  CD1 PHE A  88      -3.109  -2.553  10.900  1.00  0.00           C  
ATOM   1437  CD2 PHE A  88      -2.754  -0.483  12.121  1.00  0.00           C  
ATOM   1438  CE1 PHE A  88      -2.670  -3.288  12.014  1.00  0.00           C  
ATOM   1439  CE2 PHE A  88      -2.316  -1.216  13.236  1.00  0.00           C  
ATOM   1440  CZ  PHE A  88      -2.272  -2.619  13.183  1.00  0.00           C  
ATOM   1441  H   PHE A  88      -5.270   1.376   9.018  1.00  0.00           H  
ATOM   1442  HA  PHE A  88      -4.827  -1.369   8.255  1.00  0.00           H  
ATOM   1443  HB2 PHE A  88      -2.863  -0.434   8.960  1.00  0.00           H  
ATOM   1444  HB3 PHE A  88      -3.652   0.698  10.040  1.00  0.00           H  
ATOM   1445  HD1 PHE A  88      -3.435  -3.069  10.016  1.00  0.00           H  
ATOM   1446  HD2 PHE A  88      -2.775   0.597  12.172  1.00  0.00           H  
ATOM   1447  HE1 PHE A  88      -2.647  -4.367  11.974  1.00  0.00           H  
ATOM   1448  HE2 PHE A  88      -2.012  -0.699  14.135  1.00  0.00           H  
ATOM   1449  HZ  PHE A  88      -1.933  -3.182  14.040  1.00  0.00           H  
ATOM   1450  N   SER A  89      -6.311  -2.674   9.788  1.00  0.00           N  
ATOM   1451  CA  SER A  89      -7.206  -3.499  10.586  1.00  0.00           C  
ATOM   1452  C   SER A  89      -6.548  -4.864  10.826  1.00  0.00           C  
ATOM   1453  O   SER A  89      -5.323  -4.961  10.825  1.00  0.00           O  
ATOM   1454  CB  SER A  89      -8.562  -3.612   9.873  1.00  0.00           C  
ATOM   1455  OG  SER A  89      -9.033  -2.338   9.483  1.00  0.00           O  
ATOM   1456  H   SER A  89      -5.983  -3.077   8.923  1.00  0.00           H  
ATOM   1457  HA  SER A  89      -7.381  -3.035  11.552  1.00  0.00           H  
ATOM   1458  HB2 SER A  89      -8.466  -4.234   8.986  1.00  0.00           H  
ATOM   1459  HB3 SER A  89      -9.296  -4.055  10.545  1.00  0.00           H  
ATOM   1460  HG  SER A  89      -8.936  -1.734  10.224  1.00  0.00           H  
ATOM   1461  N   GLU A  90      -7.351  -5.917  11.015  1.00  0.00           N  
ATOM   1462  CA  GLU A  90      -6.900  -7.300  11.050  1.00  0.00           C  
ATOM   1463  C   GLU A  90      -7.834  -8.154  10.197  1.00  0.00           C  
ATOM   1464  O   GLU A  90      -8.984  -7.783   9.957  1.00  0.00           O  
ATOM   1465  CB  GLU A  90      -6.801  -7.821  12.492  1.00  0.00           C  
ATOM   1466  CG  GLU A  90      -8.154  -8.027  13.186  1.00  0.00           C  
ATOM   1467  CD  GLU A  90      -8.895  -6.715  13.432  1.00  0.00           C  
ATOM   1468  OE1 GLU A  90      -9.753  -6.345  12.632  1.00  0.00           O  
ATOM   1469  OE2 GLU A  90      -8.526  -6.024  14.546  1.00  0.00           O  
ATOM   1470  H   GLU A  90      -8.350  -5.784  11.073  1.00  0.00           H  
ATOM   1471  HA  GLU A  90      -5.905  -7.369  10.612  1.00  0.00           H  
ATOM   1472  HB2 GLU A  90      -6.292  -8.785  12.467  1.00  0.00           H  
ATOM   1473  HB3 GLU A  90      -6.191  -7.134  13.082  1.00  0.00           H  
ATOM   1474  HG2 GLU A  90      -8.779  -8.707  12.603  1.00  0.00           H  
ATOM   1475  HG3 GLU A  90      -7.967  -8.502  14.148  1.00  0.00           H  
ATOM   1476  HE2 GLU A  90      -9.021  -5.209  14.657  1.00  0.00           H  
ATOM   1477  N   TYR A  91      -7.319  -9.290   9.720  1.00  0.00           N  
ATOM   1478  CA  TYR A  91      -8.046 -10.220   8.886  1.00  0.00           C  
ATOM   1479  C   TYR A  91      -8.937 -11.124   9.738  1.00  0.00           C  
ATOM   1480  O   TYR A  91      -8.460 -11.803  10.645  1.00  0.00           O  
ATOM   1481  CB  TYR A  91      -7.045 -10.995   8.018  1.00  0.00           C  
ATOM   1482  CG  TYR A  91      -6.354 -12.182   8.662  1.00  0.00           C  
ATOM   1483  CD1 TYR A  91      -5.370 -11.991   9.651  1.00  0.00           C  
ATOM   1484  CD2 TYR A  91      -6.666 -13.486   8.236  1.00  0.00           C  
ATOM   1485  CE1 TYR A  91      -4.691 -13.093  10.196  1.00  0.00           C  
ATOM   1486  CE2 TYR A  91      -5.985 -14.588   8.778  1.00  0.00           C  
ATOM   1487  CZ  TYR A  91      -4.991 -14.392   9.754  1.00  0.00           C  
ATOM   1488  OH  TYR A  91      -4.318 -15.459  10.271  1.00  0.00           O  
ATOM   1489  H   TYR A  91      -6.354  -9.516   9.895  1.00  0.00           H  
ATOM   1490  HA  TYR A  91      -8.682  -9.652   8.209  1.00  0.00           H  
ATOM   1491  HB2 TYR A  91      -7.585 -11.341   7.140  1.00  0.00           H  
ATOM   1492  HB3 TYR A  91      -6.273 -10.301   7.682  1.00  0.00           H  
ATOM   1493  HD1 TYR A  91      -5.096 -10.999   9.976  1.00  0.00           H  
ATOM   1494  HD2 TYR A  91      -7.424 -13.648   7.485  1.00  0.00           H  
ATOM   1495  HE1 TYR A  91      -3.927 -12.933  10.943  1.00  0.00           H  
ATOM   1496  HE2 TYR A  91      -6.228 -15.583   8.435  1.00  0.00           H  
ATOM   1497  HH  TYR A  91      -4.596 -16.299   9.898  1.00  0.00           H  
ATOM   1498  N   LYS A  92     -10.238 -11.133   9.430  1.00  0.00           N  
ATOM   1499  CA  LYS A  92     -11.165 -12.128   9.946  1.00  0.00           C  
ATOM   1500  C   LYS A  92     -10.898 -13.449   9.224  1.00  0.00           C  
ATOM   1501  O   LYS A  92     -10.798 -14.499   9.855  1.00  0.00           O  
ATOM   1502  CB  LYS A  92     -12.603 -11.645   9.723  1.00  0.00           C  
ATOM   1503  CG  LYS A  92     -13.668 -12.646  10.190  1.00  0.00           C  
ATOM   1504  CD  LYS A  92     -13.649 -12.843  11.713  1.00  0.00           C  
ATOM   1505  CE  LYS A  92     -14.803 -13.729  12.199  1.00  0.00           C  
ATOM   1506  NZ  LYS A  92     -16.079 -13.053  12.055  1.00  0.00           N  
ATOM   1507  H   LYS A  92     -10.571 -10.519   8.701  1.00  0.00           H  
ATOM   1508  HA  LYS A  92     -10.994 -12.253  11.015  1.00  0.00           H  
ATOM   1509  HB2 LYS A  92     -12.745 -10.705  10.257  1.00  0.00           H  
ATOM   1510  HB3 LYS A  92     -12.752 -11.461   8.658  1.00  0.00           H  
ATOM   1511  HG2 LYS A  92     -14.637 -12.250   9.886  1.00  0.00           H  
ATOM   1512  HG3 LYS A  92     -13.527 -13.606   9.692  1.00  0.00           H  
ATOM   1513  HD2 LYS A  92     -12.717 -13.331  11.998  1.00  0.00           H  
ATOM   1514  HD3 LYS A  92     -13.704 -11.875  12.213  1.00  0.00           H  
ATOM   1515  HE2 LYS A  92     -14.819 -14.661  11.634  1.00  0.00           H  
ATOM   1516  HE3 LYS A  92     -14.649 -13.960  13.254  1.00  0.00           H  
ATOM   1517  HZ1 LYS A  92     -16.853 -13.554  12.466  1.00  0.00           H  
ATOM   1518  HZ2 LYS A  92     -16.265 -12.731  11.115  1.00  0.00           H  
ATOM   1519  N   GLY A  93     -10.777 -13.377   7.893  1.00  0.00           N  
ATOM   1520  CA  GLY A  93     -10.483 -14.494   7.022  1.00  0.00           C  
ATOM   1521  C   GLY A  93      -9.858 -13.968   5.731  1.00  0.00           C  
ATOM   1522  O   GLY A  93      -9.917 -12.771   5.440  1.00  0.00           O  
ATOM   1523  H   GLY A  93     -10.847 -12.478   7.439  1.00  0.00           H  
ATOM   1524  HA2 GLY A  93      -9.790 -15.176   7.516  1.00  0.00           H  
ATOM   1525  HA3 GLY A  93     -11.410 -15.018   6.796  1.00  0.00           H  
ATOM   1526  N   GLU A  94      -9.241 -14.873   4.967  1.00  0.00           N  
ATOM   1527  CA  GLU A  94      -8.588 -14.577   3.709  1.00  0.00           C  
ATOM   1528  C   GLU A  94      -9.597 -14.723   2.572  1.00  0.00           C  
ATOM   1529  O   GLU A  94     -10.352 -15.693   2.505  1.00  0.00           O  
ATOM   1530  CB  GLU A  94      -7.346 -15.457   3.519  1.00  0.00           C  
ATOM   1531  CG  GLU A  94      -7.640 -16.961   3.441  1.00  0.00           C  
ATOM   1532  CD  GLU A  94      -6.355 -17.762   3.268  1.00  0.00           C  
ATOM   1533  OE1 GLU A  94      -6.093 -18.257   2.174  1.00  0.00           O  
ATOM   1534  OE2 GLU A  94      -5.571 -17.880   4.378  1.00  0.00           O  
ATOM   1535  H   GLU A  94      -9.239 -15.831   5.252  1.00  0.00           H  
ATOM   1536  HA  GLU A  94      -8.211 -13.558   3.745  1.00  0.00           H  
ATOM   1537  HB2 GLU A  94      -6.853 -15.151   2.596  1.00  0.00           H  
ATOM   1538  HB3 GLU A  94      -6.661 -15.271   4.349  1.00  0.00           H  
ATOM   1539  HG2 GLU A  94      -8.139 -17.292   4.350  1.00  0.00           H  
ATOM   1540  HG3 GLU A  94      -8.286 -17.163   2.587  1.00  0.00           H  
ATOM   1541  HE2 GLU A  94      -4.786 -18.408   4.216  1.00  0.00           H  
ATOM   1542  N   PHE A  95      -9.595 -13.735   1.681  1.00  0.00           N  
ATOM   1543  CA  PHE A  95     -10.372 -13.725   0.454  1.00  0.00           C  
ATOM   1544  C   PHE A  95      -9.742 -14.680  -0.559  1.00  0.00           C  
ATOM   1545  O   PHE A  95      -8.522 -14.821  -0.609  1.00  0.00           O  
ATOM   1546  CB  PHE A  95     -10.408 -12.300  -0.107  1.00  0.00           C  
ATOM   1547  CG  PHE A  95     -11.441 -11.392   0.535  1.00  0.00           C  
ATOM   1548  CD1 PHE A  95     -11.281 -10.954   1.863  1.00  0.00           C  
ATOM   1549  CD2 PHE A  95     -12.598 -11.028  -0.182  1.00  0.00           C  
ATOM   1550  CE1 PHE A  95     -12.275 -10.173   2.476  1.00  0.00           C  
ATOM   1551  CE2 PHE A  95     -13.591 -10.245   0.429  1.00  0.00           C  
ATOM   1552  CZ  PHE A  95     -13.438  -9.831   1.764  1.00  0.00           C  
ATOM   1553  H   PHE A  95      -8.956 -12.976   1.852  1.00  0.00           H  
ATOM   1554  HA  PHE A  95     -11.394 -14.048   0.665  1.00  0.00           H  
ATOM   1555  HB2 PHE A  95      -9.420 -11.854  -0.005  1.00  0.00           H  
ATOM   1556  HB3 PHE A  95     -10.620 -12.367  -1.171  1.00  0.00           H  
ATOM   1557  HD1 PHE A  95     -10.408 -11.233   2.428  1.00  0.00           H  
ATOM   1558  HD2 PHE A  95     -12.737 -11.359  -1.201  1.00  0.00           H  
ATOM   1559  HE1 PHE A  95     -12.152  -9.848   3.499  1.00  0.00           H  
ATOM   1560  HE2 PHE A  95     -14.478  -9.970  -0.122  1.00  0.00           H  
ATOM   1561  HZ  PHE A  95     -14.212  -9.246   2.242  1.00  0.00           H  
ATOM   1562  N   GLU A  96     -10.580 -15.326  -1.374  1.00  0.00           N  
ATOM   1563  CA  GLU A  96     -10.152 -16.200  -2.450  1.00  0.00           C  
ATOM   1564  C   GLU A  96      -9.548 -15.374  -3.591  1.00  0.00           C  
ATOM   1565  O   GLU A  96     -10.250 -14.985  -4.521  1.00  0.00           O  
ATOM   1566  CB  GLU A  96     -11.299 -17.122  -2.902  1.00  0.00           C  
ATOM   1567  CG  GLU A  96     -12.649 -16.429  -3.157  1.00  0.00           C  
ATOM   1568  CD  GLU A  96     -13.654 -17.402  -3.767  1.00  0.00           C  
ATOM   1569  OE1 GLU A  96     -13.999 -17.261  -4.938  1.00  0.00           O  
ATOM   1570  OE2 GLU A  96     -14.108 -18.386  -2.941  1.00  0.00           O  
ATOM   1571  H   GLU A  96     -11.569 -15.194  -1.257  1.00  0.00           H  
ATOM   1572  HA  GLU A  96      -9.383 -16.847  -2.045  1.00  0.00           H  
ATOM   1573  HB2 GLU A  96     -10.985 -17.637  -3.811  1.00  0.00           H  
ATOM   1574  HB3 GLU A  96     -11.453 -17.875  -2.126  1.00  0.00           H  
ATOM   1575  HG2 GLU A  96     -13.069 -16.062  -2.221  1.00  0.00           H  
ATOM   1576  HG3 GLU A  96     -12.529 -15.588  -3.836  1.00  0.00           H  
ATOM   1577  HE2 GLU A  96     -14.730 -18.973  -3.376  1.00  0.00           H  
ATOM   1578  N   ASP A  97      -8.239 -15.096  -3.502  1.00  0.00           N  
ATOM   1579  CA  ASP A  97      -7.514 -14.226  -4.424  1.00  0.00           C  
ATOM   1580  C   ASP A  97      -8.018 -12.788  -4.277  1.00  0.00           C  
ATOM   1581  O   ASP A  97      -8.591 -12.439  -3.246  1.00  0.00           O  
ATOM   1582  CB  ASP A  97      -7.556 -14.764  -5.868  1.00  0.00           C  
ATOM   1583  CG  ASP A  97      -7.124 -16.226  -5.944  1.00  0.00           C  
ATOM   1584  OD1 ASP A  97      -5.928 -16.498  -6.020  1.00  0.00           O  
ATOM   1585  OD2 ASP A  97      -8.126 -17.152  -5.923  1.00  0.00           O  
ATOM   1586  H   ASP A  97      -7.752 -15.382  -2.664  1.00  0.00           H  
ATOM   1587  HA  ASP A  97      -6.466 -14.210  -4.132  1.00  0.00           H  
ATOM   1588  HB2 ASP A  97      -8.551 -14.656  -6.299  1.00  0.00           H  
ATOM   1589  HB3 ASP A  97      -6.861 -14.195  -6.485  1.00  0.00           H  
ATOM   1590  HD2 ASP A  97      -7.793 -18.051  -5.960  1.00  0.00           H  
ATOM   1591  N   PHE A  98      -7.769 -11.953  -5.291  1.00  0.00           N  
ATOM   1592  CA  PHE A  98      -8.109 -10.537  -5.288  1.00  0.00           C  
ATOM   1593  C   PHE A  98      -8.684 -10.153  -6.652  1.00  0.00           C  
ATOM   1594  O   PHE A  98      -7.967 -10.206  -7.650  1.00  0.00           O  
ATOM   1595  CB  PHE A  98      -6.843  -9.738  -4.946  1.00  0.00           C  
ATOM   1596  CG  PHE A  98      -6.996  -8.321  -4.422  1.00  0.00           C  
ATOM   1597  CD1 PHE A  98      -8.167  -7.561  -4.614  1.00  0.00           C  
ATOM   1598  CD2 PHE A  98      -5.879  -7.721  -3.819  1.00  0.00           C  
ATOM   1599  CE1 PHE A  98      -8.204  -6.212  -4.219  1.00  0.00           C  
ATOM   1600  CE2 PHE A  98      -5.912  -6.371  -3.436  1.00  0.00           C  
ATOM   1601  CZ  PHE A  98      -7.072  -5.610  -3.650  1.00  0.00           C  
ATOM   1602  H   PHE A  98      -7.248 -12.307  -6.077  1.00  0.00           H  
ATOM   1603  HA  PHE A  98      -8.845 -10.345  -4.513  1.00  0.00           H  
ATOM   1604  HB2 PHE A  98      -6.319 -10.287  -4.169  1.00  0.00           H  
ATOM   1605  HB3 PHE A  98      -6.185  -9.716  -5.814  1.00  0.00           H  
ATOM   1606  HD1 PHE A  98      -9.030  -7.976  -5.099  1.00  0.00           H  
ATOM   1607  HD2 PHE A  98      -4.982  -8.302  -3.681  1.00  0.00           H  
ATOM   1608  HE1 PHE A  98      -9.096  -5.631  -4.380  1.00  0.00           H  
ATOM   1609  HE2 PHE A  98      -5.038  -5.912  -2.999  1.00  0.00           H  
ATOM   1610  HZ  PHE A  98      -7.087  -4.563  -3.391  1.00  0.00           H  
ATOM   1611  N   GLU A  99      -9.977  -9.794  -6.698  1.00  0.00           N  
ATOM   1612  CA  GLU A  99     -10.658  -9.372  -7.919  1.00  0.00           C  
ATOM   1613  C   GLU A  99     -11.325  -8.010  -7.728  1.00  0.00           C  
ATOM   1614  O   GLU A  99     -11.498  -7.549  -6.604  1.00  0.00           O  
ATOM   1615  CB  GLU A  99     -11.688 -10.444  -8.299  1.00  0.00           C  
ATOM   1616  CG  GLU A  99     -12.321 -10.185  -9.672  1.00  0.00           C  
ATOM   1617  CD  GLU A  99     -13.092 -11.403 -10.167  1.00  0.00           C  
ATOM   1618  OE1 GLU A  99     -12.643 -12.065 -11.100  1.00  0.00           O  
ATOM   1619  OE2 GLU A  99     -14.259 -11.673  -9.516  1.00  0.00           O  
ATOM   1620  H   GLU A  99     -10.558 -10.055  -5.911  1.00  0.00           H  
ATOM   1621  HA  GLU A  99      -9.966  -9.363  -8.762  1.00  0.00           H  
ATOM   1622  HB2 GLU A  99     -11.186 -11.407  -8.332  1.00  0.00           H  
ATOM   1623  HB3 GLU A  99     -12.457 -10.510  -7.537  1.00  0.00           H  
ATOM   1624  HG2 GLU A  99     -13.017  -9.349  -9.613  1.00  0.00           H  
ATOM   1625  HG3 GLU A  99     -11.538  -9.930 -10.394  1.00  0.00           H  
ATOM   1626  HE2 GLU A  99     -14.712 -12.438  -9.877  1.00  0.00           H  
ATOM   1627  N   THR A 100     -11.703  -7.368  -8.838  1.00  0.00           N  
ATOM   1628  CA  THR A 100     -12.331  -6.056  -8.854  1.00  0.00           C  
ATOM   1629  C   THR A 100     -13.808  -6.175  -9.248  1.00  0.00           C  
ATOM   1630  O   THR A 100     -14.153  -6.992 -10.100  1.00  0.00           O  
ATOM   1631  CB  THR A 100     -11.537  -5.093  -9.766  1.00  0.00           C  
ATOM   1632  OG1 THR A 100     -12.207  -4.828 -10.982  1.00  0.00           O  
ATOM   1633  CG2 THR A 100     -10.130  -5.605 -10.108  1.00  0.00           C  
ATOM   1634  H   THR A 100     -11.377  -7.736  -9.719  1.00  0.00           H  
ATOM   1635  HA  THR A 100     -12.249  -5.616  -7.863  1.00  0.00           H  
ATOM   1636  HB  THR A 100     -11.430  -4.151  -9.222  1.00  0.00           H  
ATOM   1637  HG1 THR A 100     -11.681  -4.212 -11.498  1.00  0.00           H  
ATOM   1638 HG21 THR A 100      -9.557  -4.823 -10.606  1.00  0.00           H  
ATOM   1639 HG22 THR A 100      -9.612  -5.892  -9.196  1.00  0.00           H  
ATOM   1640 HG23 THR A 100     -10.184  -6.469 -10.773  1.00  0.00           H  
ATOM   1641  N   TYR A 101     -14.670  -5.348  -8.641  1.00  0.00           N  
ATOM   1642  CA  TYR A 101     -16.057  -5.173  -9.078  1.00  0.00           C  
ATOM   1643  C   TYR A 101     -16.124  -4.765 -10.556  1.00  0.00           C  
ATOM   1644  O   TYR A 101     -17.049  -5.254 -11.239  1.00  0.00           O  
ATOM   1645  CB  TYR A 101     -16.747  -4.109  -8.203  1.00  0.00           C  
ATOM   1646  CG  TYR A 101     -18.029  -4.510  -7.493  1.00  0.00           C  
ATOM   1647  CD1 TYR A 101     -18.122  -5.760  -6.855  1.00  0.00           C  
ATOM   1648  CD2 TYR A 101     -19.054  -3.565  -7.303  1.00  0.00           C  
ATOM   1649  CE1 TYR A 101     -19.290  -6.117  -6.158  1.00  0.00           C  
ATOM   1650  CE2 TYR A 101     -20.200  -3.898  -6.560  1.00  0.00           C  
ATOM   1651  CZ  TYR A 101     -20.324  -5.179  -5.996  1.00  0.00           C  
ATOM   1652  OH  TYR A 101     -21.439  -5.502  -5.280  1.00  0.00           O  
ATOM   1653  OXT TYR A 101     -15.265  -3.959 -10.975  1.00  0.00           O  
ATOM   1654  H   TYR A 101     -14.339  -4.794  -7.859  1.00  0.00           H  
ATOM   1655  HA  TYR A 101     -16.561  -6.134  -8.983  1.00  0.00           H  
ATOM   1656  HB2 TYR A 101     -16.055  -3.824  -7.426  1.00  0.00           H  
ATOM   1657  HB3 TYR A 101     -16.936  -3.215  -8.801  1.00  0.00           H  
ATOM   1658  HD1 TYR A 101     -17.283  -6.432  -6.872  1.00  0.00           H  
ATOM   1659  HD2 TYR A 101     -18.959  -2.568  -7.703  1.00  0.00           H  
ATOM   1660  HE1 TYR A 101     -19.375  -7.097  -5.711  1.00  0.00           H  
ATOM   1661  HE2 TYR A 101     -20.982  -3.166  -6.421  1.00  0.00           H  
ATOM   1662  HH  TYR A 101     -21.419  -6.392  -4.926  1.00  0.00           H  
TER    1663      TYR A 101                                                      
END
MOLECULE T0437.pdb
ATOM    365  N   ASP    24      -1.217  -3.430  12.771  1.00 32.15           N  
ATOM    366  CA  ASP    24      -2.558  -3.784  13.227  1.00 11.24           C  
ATOM    367  C   ASP    24      -3.077  -4.985  12.447  1.00  3.52           C  
ATOM    368  O   ASP    24      -3.558  -5.955  13.031  1.00 72.30           O  
ATOM    369  CB  ASP    24      -3.550  -2.622  13.081  1.00 55.51           C  
ATOM    370  CG  ASP    24      -4.808  -2.840  13.907  1.00 50.34           C  
ATOM    371  OD1 ASP    24      -4.721  -2.781  15.153  1.00 45.42           O  
ATOM    372  OD2 ASP    24      -5.894  -3.051  13.323  1.00 64.32           O  
ATOM    373  H   ASP    24      -0.799  -3.973  12.068  1.00 54.01           H  
ATOM    374  HA  ASP    24      -2.484  -4.056  14.271  1.00 33.12           H  
ATOM    375  HB2 ASP    24      -3.078  -1.707  13.409  1.00 36.92           H  
ATOM    376  HB3 ASP    24      -3.834  -2.526  12.043  1.00 36.92           H  
ATOM    377  N   ASN    25      -2.962  -4.924  11.121  1.00 30.54           N  
ATOM    378  CA  ASN    25      -3.508  -5.964  10.256  1.00 13.41           C  
ATOM    379  C   ASN    25      -2.460  -6.507   9.295  1.00 63.53           C  
ATOM    380  O   ASN    25      -1.296  -6.099   9.311  1.00 14.31           O  
ATOM    381  CB  ASN    25      -4.679  -5.420   9.426  1.00 24.42           C  
ATOM    382  CG  ASN    25      -5.829  -4.927  10.269  1.00 32.35           C  
ATOM    383  OD1 ASN    25      -6.706  -5.697  10.646  1.00 43.01           O  
ATOM    384  ND2 ASN    25      -5.853  -3.633  10.534  1.00 44.23           N  
ATOM    385  H   ASN    25      -2.501  -4.158  10.709  1.00 41.11           H  
ATOM    386  HA  ASN    25      -3.864  -6.769  10.879  1.00 52.21           H  
ATOM    387  HB2 ASN    25      -4.327  -4.598   8.822  1.00 36.92           H  
ATOM    388  HB3 ASN    25      -5.043  -6.204   8.776  1.00 36.92           H  
ATOM    389 HD21 ASN    25      -5.133  -3.072  10.171  1.00 36.92           H  
ATOM    390 HD22 ASN    25      -6.577  -3.287  11.100  1.00 36.92           H  
ATOM    391  N   CYS    26      -2.899  -7.447   8.473  1.00 31.24           N  
ATOM    392  CA  CYS    26      -2.129  -7.926   7.338  1.00 12.34           C  
ATOM    393  C   CYS    26      -2.935  -7.685   6.063  1.00 73.22           C  
ATOM    394  O   CYS    26      -2.415  -7.757   4.950  1.00 24.23           O  
ATOM    395  CB  CYS    26      -1.796  -9.411   7.499  1.00 72.14           C  
ATOM    396  SG  CYS    26      -3.233 -10.466   7.786  1.00  1.02           S  
ATOM    397  H   CYS    26      -3.780  -7.844   8.643  1.00 23.14           H  
ATOM    398  HA  CYS    26      -1.212  -7.355   7.290  1.00 54.15           H  
ATOM    399  HB2 CYS    26      -1.310  -9.763   6.603  1.00 36.92           H  
ATOM    400  HB3 CYS    26      -1.127  -9.535   8.338  1.00 36.92           H  
ATOM    401  HG  CYS    26      -2.885 -11.712   7.486  1.00 33.31           H  
ATOM    402  N   THR    27      -4.221  -7.404   6.252  1.00  2.42           N  
ATOM    403  CA  THR    27      -5.103  -7.020   5.167  1.00 14.14           C  
ATOM    404  C   THR    27      -5.241  -5.501   5.133  1.00 42.33           C  
ATOM    405  O   THR    27      -5.709  -4.893   6.102  1.00 22.32           O  
ATOM    406  CB  THR    27      -6.496  -7.663   5.341  1.00 43.41           C  
ATOM    407  OG1 THR    27      -6.380  -9.092   5.329  1.00  1.24           O  
ATOM    408  CG2 THR    27      -7.455  -7.221   4.244  1.00  1.25           C  
ATOM    409  H   THR    27      -4.589  -7.460   7.160  1.00 62.31           H  
ATOM    410  HA  THR    27      -4.674  -7.363   4.237  1.00 23.45           H  
ATOM    411  HB  THR    27      -6.899  -7.353   6.294  1.00 23.25           H  
ATOM    412  HG1 THR    27      -6.285  -9.415   6.235  1.00 70.53           H  
ATOM    413 HG21 THR    27      -8.407  -7.714   4.375  1.00 36.92           H  
ATOM    414 HG22 THR    27      -7.044  -7.482   3.280  1.00 36.92           H  
ATOM    415 HG23 THR    27      -7.593  -6.151   4.298  1.00 36.92           H  
ATOM    416  N   SER    28      -4.839  -4.888   4.027  1.00 33.44           N  
ATOM    417  CA  SER    28      -4.883  -3.439   3.911  1.00 41.41           C  
ATOM    418  C   SER    28      -6.138  -3.018   3.169  1.00  3.25           C  
ATOM    419  O   SER    28      -6.628  -3.746   2.308  1.00  4.43           O  
ATOM    420  CB  SER    28      -3.645  -2.908   3.181  1.00 70.44           C  
ATOM    421  OG  SER    28      -3.551  -1.502   3.323  1.00  3.01           O  
ATOM    422  H   SER    28      -4.524  -5.424   3.263  1.00 11.31           H  
ATOM    423  HA  SER    28      -4.911  -3.026   4.909  1.00 33.32           H  
ATOM    424  HB2 SER    28      -2.757  -3.363   3.593  1.00 36.92           H  
ATOM    425  HB3 SER    28      -3.718  -3.149   2.130  1.00 36.92           H  
ATOM    426  HG  SER    28      -2.992  -1.130   2.615  1.00  3.41           H  
ATOM    427  N   LYS    29      -6.662  -1.853   3.509  1.00 34.41           N  
ATOM    428  CA  LYS    29      -7.877  -1.356   2.890  1.00 11.21           C  
ATOM    429  C   LYS    29      -7.593  -0.009   2.265  1.00 12.41           C  
ATOM    430  O   LYS    29      -7.319   0.971   2.962  1.00 14.44           O  
ATOM    431  CB  LYS    29      -9.024  -1.202   3.893  1.00 31.01           C  
ATOM    432  CG  LYS    29      -9.044  -2.231   5.007  1.00 24.44           C  
ATOM    433  CD  LYS    29      -8.016  -1.879   6.067  1.00 42.42           C  
ATOM    434  CE  LYS    29      -8.275  -2.586   7.387  1.00 72.54           C  
ATOM    435  NZ  LYS    29      -8.114  -4.060   7.277  1.00 24.34           N  
ATOM    436  H   LYS    29      -6.209  -1.302   4.180  1.00  5.13           H  
ATOM    437  HA  LYS    29      -8.168  -2.052   2.115  1.00 14.03           H  
ATOM    438  HB2 LYS    29      -8.955  -0.226   4.347  1.00 36.92           H  
ATOM    439  HB3 LYS    29      -9.961  -1.269   3.359  1.00 36.92           H  
ATOM    440  HG2 LYS    29     -10.025  -2.248   5.451  1.00 36.92           H  
ATOM    441  HG3 LYS    29      -8.811  -3.204   4.597  1.00 36.92           H  
ATOM    442  HD2 LYS    29      -7.038  -2.166   5.706  1.00 36.92           H  
ATOM    443  HD3 LYS    29      -8.040  -0.811   6.215  1.00 36.92           H  
ATOM    444  HE2 LYS    29      -7.580  -2.212   8.123  1.00 36.92           H  
ATOM    445  HE3 LYS    29      -9.284  -2.365   7.704  1.00 36.92           H  
ATOM    446  HZ1 LYS    29      -7.150  -4.297   6.962  1.00 36.92           H  
ATOM    447  HZ2 LYS    29      -8.798  -4.448   6.588  1.00 36.92           H  
ATOM    448  HZ3 LYS    29      -8.288  -4.508   8.205  1.00 36.92           H  
ATOM    449  N   PHE    30      -7.655   0.034   0.964  1.00 52.14           N  
ATOM    450  CA  PHE    30      -7.342   1.246   0.228  1.00 74.42           C  
ATOM    451  C   PHE    30      -8.617   1.916  -0.259  1.00 75.21           C  
ATOM    452  O   PHE    30      -9.343   1.360  -1.081  1.00  2.21           O  
ATOM    453  CB  PHE    30      -6.425   0.925  -0.957  1.00 63.54           C  
ATOM    454  CG  PHE    30      -6.093   2.118  -1.810  1.00 64.50           C  
ATOM    455  CD1 PHE    30      -5.122   3.024  -1.413  1.00 43.31           C  
ATOM    456  CD2 PHE    30      -6.755   2.335  -3.009  1.00 42.02           C  
ATOM    457  CE1 PHE    30      -4.818   4.122  -2.194  1.00 25.13           C  
ATOM    458  CE2 PHE    30      -6.455   3.432  -3.794  1.00 72.40           C  
ATOM    459  CZ  PHE    30      -5.485   4.326  -3.386  1.00 61.32           C  
ATOM    460  H   PHE    30      -7.942  -0.770   0.485  1.00 44.02           H  
ATOM    461  HA  PHE    30      -6.829   1.918   0.898  1.00 62.01           H  
ATOM    462  HB2 PHE    30      -5.497   0.518  -0.584  1.00 36.92           H  
ATOM    463  HB3 PHE    30      -6.907   0.189  -1.585  1.00 36.92           H  
ATOM    464  HD1 PHE    30      -4.599   2.867  -0.481  1.00 63.41           H  
ATOM    465  HD2 PHE    30      -7.516   1.637  -3.329  1.00  2.43           H  
ATOM    466  HE1 PHE    30      -4.059   4.820  -1.873  1.00 51.40           H  
ATOM    467  HE2 PHE    30      -6.977   3.588  -4.726  1.00  0.03           H  
ATOM    468  HZ  PHE    30      -5.250   5.185  -3.999  1.00 35.04           H  
ATOM    469  N   SER    31      -8.867   3.118   0.237  1.00 74.32           N  
ATOM    470  CA  SER    31     -10.047   3.876  -0.141  1.00 73.15           C  
ATOM    471  C   SER    31      -9.680   5.137  -0.908  1.00 74.03           C  
ATOM    472  O   SER    31      -8.747   5.860  -0.543  1.00  5.31           O  
ATOM    473  CB  SER    31     -10.858   4.239   1.103  1.00  0.34           C  
ATOM    474  OG  SER    31     -10.003   4.439   2.220  1.00 44.25           O  
ATOM    475  H   SER    31      -8.253   3.498   0.892  1.00 63.34           H  
ATOM    476  HA  SER    31     -10.652   3.249  -0.778  1.00 42.22           H  
ATOM    477  HB2 SER    31     -11.401   5.154   0.916  1.00 36.92           H  
ATOM    478  HB3 SER    31     -11.556   3.446   1.328  1.00 36.92           H  
ATOM    479  HG  SER    31     -10.076   3.677   2.815  1.00 62.22           H  
ATOM    480  N   ARG    32     -10.409   5.372  -1.982  1.00 34.33           N  
ATOM    481  CA  ARG    32     -10.290   6.587  -2.767  1.00 13.22           C  
ATOM    482  C   ARG    32     -11.656   6.967  -3.312  1.00 30.12           C  
ATOM    483  O   ARG    32     -12.485   6.098  -3.590  1.00  1.53           O  
ATOM    484  CB  ARG    32      -9.293   6.400  -3.914  1.00 72.21           C  
ATOM    485  CG  ARG    32      -7.900   6.946  -3.627  1.00 15.03           C  
ATOM    486  CD  ARG    32      -7.783   8.424  -3.980  1.00 21.11           C  
ATOM    487  NE  ARG    32      -8.659   9.273  -3.169  1.00 34.31           N  
ATOM    488  CZ  ARG    32      -9.089  10.477  -3.550  1.00 74.52           C  
ATOM    489  NH1 ARG    32      -8.702  10.996  -4.708  1.00 22.20           N  
ATOM    490  NH2 ARG    32      -9.890  11.175  -2.752  1.00 10.25           N  
ATOM    491  H   ARG    32     -11.061   4.688  -2.268  1.00 61.53           H  
ATOM    492  HA  ARG    32      -9.940   7.373  -2.115  1.00 13.20           H  
ATOM    493  HB2 ARG    32      -9.204   5.346  -4.123  1.00 36.92           H  
ATOM    494  HB3 ARG    32      -9.677   6.898  -4.791  1.00 36.92           H  
ATOM    495  HG2 ARG    32      -7.683   6.821  -2.577  1.00 36.92           H  
ATOM    496  HG3 ARG    32      -7.182   6.390  -4.211  1.00 36.92           H  
ATOM    497  HD2 ARG    32      -6.759   8.734  -3.827  1.00 36.92           H  
ATOM    498  HD3 ARG    32      -8.040   8.550  -5.021  1.00 36.92           H  
ATOM    499  HE  ARG    32      -8.933   8.926  -2.287  1.00 22.31           H  
ATOM    500 HH11 ARG    32      -8.075  10.485  -5.314  1.00 36.92           H  
ATOM    501 HH12 ARG    32      -9.017  11.913  -4.987  1.00 36.92           H  
ATOM    502 HH21 ARG    32     -10.166  10.801  -1.861  1.00 36.92           H  
ATOM    503 HH22 ARG    32     -10.226  12.085  -3.037  1.00 36.92           H  
ATOM    504  N   PHE    33     -11.893   8.257  -3.446  1.00 12.54           N  
ATOM    505  CA  PHE    33     -13.175   8.746  -3.916  1.00 11.05           C  
ATOM    506  C   PHE    33     -13.030   9.297  -5.322  1.00 55.33           C  
ATOM    507  O   PHE    33     -12.193  10.165  -5.578  1.00 62.12           O  
ATOM    508  CB  PHE    33     -13.716   9.827  -2.977  1.00  2.45           C  
ATOM    509  CG  PHE    33     -13.665   9.442  -1.522  1.00  1.40           C  
ATOM    510  CD1 PHE    33     -14.492   8.449  -1.023  1.00  3.52           C  
ATOM    511  CD2 PHE    33     -12.783  10.069  -0.656  1.00 73.01           C  
ATOM    512  CE1 PHE    33     -14.440   8.090   0.312  1.00 11.30           C  
ATOM    513  CE2 PHE    33     -12.728   9.714   0.678  1.00 34.42           C  
ATOM    514  CZ  PHE    33     -13.558   8.724   1.163  1.00 42.15           C  
ATOM    515  H   PHE    33     -11.185   8.898  -3.238  1.00 14.11           H  
ATOM    516  HA  PHE    33     -13.864   7.914  -3.934  1.00 32.42           H  
ATOM    517  HB2 PHE    33     -13.137  10.726  -3.104  1.00 36.92           H  
ATOM    518  HB3 PHE    33     -14.747  10.029  -3.231  1.00 36.92           H  
ATOM    519  HD1 PHE    33     -15.183   7.953  -1.687  1.00 41.41           H  
ATOM    520  HD2 PHE    33     -12.132  10.845  -1.031  1.00 72.44           H  
ATOM    521  HE1 PHE    33     -15.091   7.314   0.688  1.00 12.34           H  
ATOM    522  HE2 PHE    33     -12.035  10.211   1.343  1.00 62.42           H  
ATOM    523  HZ  PHE    33     -13.517   8.446   2.206  1.00  5.22           H  
ATOM    524  N   PHE    34     -13.832   8.783  -6.232  1.00 32.11           N  
ATOM    525  CA  PHE    34     -13.750   9.181  -7.627  1.00  1.22           C  
ATOM    526  C   PHE    34     -15.068   9.782  -8.075  1.00 23.44           C  
ATOM    527  O   PHE    34     -16.074   9.649  -7.383  1.00 51.45           O  
ATOM    528  CB  PHE    34     -13.392   7.981  -8.498  1.00 31.22           C  
ATOM    529  CG  PHE    34     -12.063   7.371  -8.150  1.00 51.33           C  
ATOM    530  CD1 PHE    34     -10.884   7.944  -8.604  1.00 14.42           C  
ATOM    531  CD2 PHE    34     -11.993   6.229  -7.369  1.00 64.14           C  
ATOM    532  CE1 PHE    34      -9.662   7.387  -8.285  1.00  2.41           C  
ATOM    533  CE2 PHE    34     -10.772   5.669  -7.048  1.00 51.32           C  
ATOM    534  CZ  PHE    34      -9.606   6.249  -7.506  1.00 32.24           C  
ATOM    535  H   PHE    34     -14.509   8.124  -5.958  1.00  3.15           H  
ATOM    536  HA  PHE    34     -12.975   9.926  -7.719  1.00 13.43           H  
ATOM    537  HB2 PHE    34     -14.152   7.221  -8.382  1.00 36.92           H  
ATOM    538  HB3 PHE    34     -13.356   8.293  -9.532  1.00 36.92           H  
ATOM    539  HD1 PHE    34     -10.927   8.836  -9.212  1.00 23.34           H  
ATOM    540  HD2 PHE    34     -12.904   5.776  -7.008  1.00 55.40           H  
ATOM    541  HE1 PHE    34      -8.750   7.841  -8.645  1.00  4.21           H  
ATOM    542  HE2 PHE    34     -10.728   4.778  -6.438  1.00 43.52           H  
ATOM    543  HZ  PHE    34      -8.651   5.811  -7.258  1.00 60.55           H  
ATOM    544  N   ALA    35     -15.059  10.445  -9.223  1.00 41.43           N  
ATOM    545  CA  ALA    35     -16.262  11.091  -9.739  1.00 35.44           C  
ATOM    546  C   ALA    35     -17.209  10.081 -10.376  1.00 12.23           C  
ATOM    547  O   ALA    35     -18.426  10.269 -10.368  1.00  3.53           O  
ATOM    548  CB  ALA    35     -15.895  12.179 -10.734  1.00 10.24           C  
ATOM    549  H   ALA    35     -14.222  10.509  -9.734  1.00 32.10           H  
ATOM    550  HA  ALA    35     -16.766  11.557  -8.907  1.00 65.13           H  
ATOM    551  HB1 ALA    35     -16.787  12.711 -11.032  1.00 36.92           H  
ATOM    552  HB2 ALA    35     -15.435  11.733 -11.604  1.00 36.92           H  
ATOM    553  HB3 ALA    35     -15.203  12.867 -10.274  1.00 36.92           H  
ATOM    554  N   THR    36     -16.655   9.015 -10.931  1.00 23.34           N  
ATOM    555  CA  THR    36     -17.470   7.980 -11.544  1.00 51.01           C  
ATOM    556  C   THR    36     -17.045   6.607 -11.049  1.00 43.30           C  
ATOM    557  O   THR    36     -15.901   6.418 -10.624  1.00  5.14           O  
ATOM    558  CB  THR    36     -17.358   7.997 -13.082  1.00 13.34           C  
ATOM    559  OG1 THR    36     -15.991   7.818 -13.472  1.00 31.33           O  
ATOM    560  CG2 THR    36     -17.895   9.295 -13.669  1.00 12.13           C  
ATOM    561  H   THR    36     -15.680   8.919 -10.930  1.00 11.05           H  
ATOM    562  HA  THR    36     -18.500   8.153 -11.272  1.00 24.33           H  
ATOM    563  HB  THR    36     -17.942   7.177 -13.475  1.00 62.24           H  
ATOM    564  HG1 THR    36     -15.774   8.439 -14.184  1.00 51.32           H  
ATOM    565 HG21 THR    36     -17.783   9.276 -14.743  1.00 36.92           H  
ATOM    566 HG22 THR    36     -17.341  10.129 -13.264  1.00 36.92           H  
ATOM    567 HG23 THR    36     -18.940   9.401 -13.417  1.00 36.92           H  
ATOM    568  N   ARG    37     -17.964   5.653 -11.105  1.00  3.51           N  
ATOM    569  CA  ARG    37     -17.648   4.269 -10.789  1.00 24.40           C  
ATOM    570  C   ARG    37     -16.613   3.737 -11.780  1.00 72.31           C  
ATOM    571  O   ARG    37     -15.833   2.837 -11.462  1.00 55.35           O  
ATOM    572  CB  ARG    37     -18.924   3.422 -10.804  1.00  2.52           C  
ATOM    573  CG  ARG    37     -18.675   1.925 -10.730  1.00 45.12           C  
ATOM    574  CD  ARG    37     -19.979   1.152 -10.685  1.00 43.11           C  
ATOM    575  NE  ARG    37     -19.758  -0.288 -10.589  1.00 74.04           N  
ATOM    576  CZ  ARG    37     -20.451  -1.088  -9.782  1.00 42.35           C  
ATOM    577  NH1 ARG    37     -21.353  -0.577  -8.950  1.00 25.52           N  
ATOM    578  NH2 ARG    37     -20.229  -2.397  -9.786  1.00 54.14           N  
ATOM    579  H   ARG    37     -18.888   5.891 -11.359  1.00 10.41           H  
ATOM    580  HA  ARG    37     -17.221   4.246  -9.796  1.00 21.43           H  
ATOM    581  HB2 ARG    37     -19.530   3.702  -9.955  1.00 36.92           H  
ATOM    582  HB3 ARG    37     -19.475   3.632 -11.707  1.00 36.92           H  
ATOM    583  HG2 ARG    37     -18.115   1.618 -11.601  1.00 36.92           H  
ATOM    584  HG3 ARG    37     -18.105   1.708  -9.837  1.00 36.92           H  
ATOM    585  HD2 ARG    37     -20.547   1.477  -9.825  1.00 36.92           H  
ATOM    586  HD3 ARG    37     -20.539   1.362 -11.585  1.00 36.92           H  
ATOM    587  HE  ARG    37     -19.061  -0.678 -11.172  1.00 14.05           H  
ATOM    588 HH11 ARG    37     -21.521   0.418  -8.927  1.00 36.92           H  
ATOM    589 HH12 ARG    37     -21.866  -1.180  -8.329  1.00 36.92           H  
ATOM    590 HH21 ARG    37     -19.533  -2.794 -10.399  1.00 36.92           H  
ATOM    591 HH22 ARG    37     -20.769  -3.002  -9.183  1.00 36.92           H  
ATOM    592  N   GLU    38     -16.602   4.325 -12.973  1.00 14.40           N  
ATOM    593  CA  GLU    38     -15.581   4.032 -13.969  1.00 15.45           C  
ATOM    594  C   GLU    38     -14.200   4.347 -13.421  1.00  3.11           C  
ATOM    595  O   GLU    38     -13.309   3.502 -13.439  1.00 72.21           O  
ATOM    596  CB  GLU    38     -15.814   4.858 -15.223  1.00 64.21           C  
ATOM    597  CG  GLU    38     -17.079   4.500 -15.969  1.00 62.14           C  
ATOM    598  CD  GLU    38     -17.275   5.367 -17.191  1.00  2.33           C  
ATOM    599  OE1 GLU    38     -16.436   5.296 -18.114  1.00 74.31           O  
ATOM    600  OE2 GLU    38     -18.261   6.124 -17.232  1.00  2.14           O  
ATOM    601  H   GLU    38     -17.302   4.974 -13.190  1.00 42.23           H  
ATOM    602  HA  GLU    38     -15.637   2.983 -14.216  1.00 33.10           H  
ATOM    603  HB2 GLU    38     -15.869   5.901 -14.947  1.00 36.92           H  
ATOM    604  HB3 GLU    38     -14.977   4.716 -15.886  1.00 36.92           H  
ATOM    605  HG2 GLU    38     -17.018   3.468 -16.277  1.00 36.92           H  
ATOM    606  HG3 GLU    38     -17.923   4.632 -15.308  1.00 36.92           H  
ATOM    607  N   GLU    39     -14.041   5.573 -12.934  1.00 32.12           N  
ATOM    608  CA  GLU    39     -12.795   6.019 -12.318  1.00 42.12           C  
ATOM    609  C   GLU    39     -12.352   5.058 -11.220  1.00 31.43           C  
ATOM    610  O   GLU    39     -11.159   4.832 -11.022  1.00  2.11           O  
ATOM    611  CB  GLU    39     -12.987   7.417 -11.730  1.00 35.53           C  
ATOM    612  CG  GLU    39     -13.006   8.527 -12.761  1.00  1.50           C  
ATOM    613  CD  GLU    39     -11.630   8.822 -13.316  1.00 55.23           C  
ATOM    614  OE1 GLU    39     -10.892   9.612 -12.684  1.00 51.31           O  
ATOM    615  OE2 GLU    39     -11.276   8.263 -14.372  1.00 14.10           O  
ATOM    616  H   GLU    39     -14.791   6.208 -13.000  1.00 33.31           H  
ATOM    617  HA  GLU    39     -12.034   6.056 -13.082  1.00 32.33           H  
ATOM    618  HB2 GLU    39     -13.926   7.438 -11.199  1.00 36.92           H  
ATOM    619  HB3 GLU    39     -12.187   7.615 -11.033  1.00 36.92           H  
ATOM    620  HG2 GLU    39     -13.654   8.234 -13.574  1.00 36.92           H  
ATOM    621  HG3 GLU    39     -13.394   9.422 -12.299  1.00 36.92           H  
ATOM    622  N   ALA    40     -13.324   4.482 -10.528  1.00 15.32           N  
ATOM    623  CA  ALA    40     -13.043   3.557  -9.439  1.00 54.43           C  
ATOM    624  C   ALA    40     -12.469   2.248  -9.972  1.00 33.33           C  
ATOM    625  O   ALA    40     -11.409   1.798  -9.538  1.00 20.01           O  
ATOM    626  CB  ALA    40     -14.303   3.297  -8.623  1.00 33.21           C  
ATOM    627  H   ALA    40     -14.257   4.677 -10.764  1.00 53.43           H  
ATOM    628  HA  ALA    40     -12.314   4.019  -8.790  1.00 31.22           H  
ATOM    629  HB1 ALA    40     -14.059   2.683  -7.769  1.00 36.92           H  
ATOM    630  HB2 ALA    40     -15.028   2.785  -9.238  1.00 36.92           H  
ATOM    631  HB3 ALA    40     -14.717   4.237  -8.286  1.00 36.92           H  
ATOM    632  N   GLU    41     -13.162   1.653 -10.936  1.00  4.00           N  
ATOM    633  CA  GLU    41     -12.741   0.377 -11.503  1.00 73.11           C  
ATOM    634  C   GLU    41     -11.495   0.533 -12.376  1.00 44.42           C  
ATOM    635  O   GLU    41     -10.745  -0.423 -12.575  1.00 62.40           O  
ATOM    636  CB  GLU    41     -13.883  -0.252 -12.302  1.00 43.42           C  
ATOM    637  CG  GLU    41     -15.061  -0.668 -11.435  1.00 63.32           C  
ATOM    638  CD  GLU    41     -16.138  -1.406 -12.204  1.00 13.55           C  
ATOM    639  OE1 GLU    41     -15.808  -2.379 -12.914  1.00 13.40           O  
ATOM    640  OE2 GLU    41     -17.327  -1.038 -12.081  1.00 14.30           O  
ATOM    641  H   GLU    41     -13.981   2.081 -11.273  1.00 13.32           H  
ATOM    642  HA  GLU    41     -12.497  -0.277 -10.678  1.00 33.21           H  
ATOM    643  HB2 GLU    41     -14.232   0.465 -13.032  1.00 36.92           H  
ATOM    644  HB3 GLU    41     -13.512  -1.126 -12.816  1.00 36.92           H  
ATOM    645  HG2 GLU    41     -14.699  -1.315 -10.649  1.00 36.92           H  
ATOM    646  HG3 GLU    41     -15.497   0.217 -10.995  1.00 36.92           H  
ATOM    647  N   SER    42     -11.275   1.736 -12.892  1.00 34.34           N  
ATOM    648  CA  SER    42     -10.074   2.024 -13.663  1.00 34.54           C  
ATOM    649  C   SER    42      -8.859   2.061 -12.751  1.00 64.54           C  
ATOM    650  O   SER    42      -7.767   1.645 -13.137  1.00 33.55           O  
ATOM    651  CB  SER    42     -10.219   3.357 -14.404  1.00 12.41           C  
ATOM    652  OG  SER    42     -11.356   3.351 -15.251  1.00 45.13           O  
ATOM    653  H   SER    42     -11.942   2.446 -12.757  1.00 63.32           H  
ATOM    654  HA  SER    42      -9.937   1.231 -14.382  1.00 60.43           H  
ATOM    655  HB2 SER    42     -10.328   4.156 -13.684  1.00 36.92           H  
ATOM    656  HB3 SER    42      -9.337   3.532 -15.003  1.00 36.92           H  
ATOM    657  HG  SER    42     -12.155   3.246 -14.716  1.00 51.21           H  
ATOM    658  N   PHE    43      -9.057   2.529 -11.527  1.00 72.54           N  
ATOM    659  CA  PHE    43      -7.965   2.627 -10.579  1.00  3.13           C  
ATOM    660  C   PHE    43      -7.646   1.244 -10.019  1.00 34.22           C  
ATOM    661  O   PHE    43      -6.511   0.960  -9.641  1.00 30.41           O  
ATOM    662  CB  PHE    43      -8.327   3.597  -9.455  1.00 41.13           C  
ATOM    663  CG  PHE    43      -7.139   4.284  -8.845  1.00 43.32           C  
ATOM    664  CD1 PHE    43      -6.541   5.354  -9.492  1.00 15.11           C  
ATOM    665  CD2 PHE    43      -6.620   3.867  -7.632  1.00 40.35           C  
ATOM    666  CE1 PHE    43      -5.449   5.993  -8.941  1.00 43.32           C  
ATOM    667  CE2 PHE    43      -5.527   4.502  -7.075  1.00 52.15           C  
ATOM    668  CZ  PHE    43      -4.941   5.567  -7.731  1.00 35.31           C  
ATOM    669  H   PHE    43      -9.959   2.816 -11.256  1.00 63.33           H  
ATOM    670  HA  PHE    43      -7.100   3.000 -11.108  1.00 64.25           H  
ATOM    671  HB2 PHE    43      -8.987   4.357  -9.845  1.00 36.92           H  
ATOM    672  HB3 PHE    43      -8.834   3.052  -8.673  1.00 36.92           H  
ATOM    673  HD1 PHE    43      -6.940   5.687 -10.439  1.00 53.12           H  
ATOM    674  HD2 PHE    43      -7.077   3.034  -7.119  1.00 22.22           H  
ATOM    675  HE1 PHE    43      -4.993   6.827  -9.456  1.00  1.35           H  
ATOM    676  HE2 PHE    43      -5.132   4.169  -6.128  1.00 43.32           H  
ATOM    677  HZ  PHE    43      -4.086   6.065  -7.297  1.00 63.25           H  
ATOM    678  N   MET    44      -8.658   0.381 -10.000  1.00 62.50           N  
ATOM    679  CA  MET    44      -8.496  -0.995  -9.543  1.00 13.32           C  
ATOM    680  C   MET    44      -7.478  -1.733 -10.408  1.00 73.33           C  
ATOM    681  O   MET    44      -6.744  -2.594  -9.923  1.00 61.20           O  
ATOM    682  CB  MET    44      -9.843  -1.727  -9.572  1.00  3.31           C  
ATOM    683  CG  MET    44      -9.766  -3.179  -9.123  1.00 73.12           C  
ATOM    684  SD  MET    44      -9.170  -3.356  -7.431  1.00 23.22           S  
ATOM    685  CE  MET    44     -10.369  -2.359  -6.551  1.00 71.13           C  
ATOM    686  H   MET    44      -9.542   0.682 -10.297  1.00 71.24           H  
ATOM    687  HA  MET    44      -8.133  -0.967  -8.526  1.00 13.31           H  
ATOM    688  HB2 MET    44     -10.533  -1.209  -8.923  1.00 36.92           H  
ATOM    689  HB3 MET    44     -10.228  -1.706 -10.581  1.00 36.92           H  
ATOM    690  HG2 MET    44     -10.752  -3.616  -9.187  1.00 36.92           H  
ATOM    691  HG3 MET    44      -9.096  -3.709  -9.783  1.00 36.92           H  
ATOM    692  HE1 MET    44     -11.361  -2.737  -6.749  1.00 36.92           H  
ATOM    693  HE2 MET    44     -10.300  -1.334  -6.884  1.00 36.92           H  
ATOM    694  HE3 MET    44     -10.170  -2.407  -5.490  1.00 36.92           H  
ATOM    695  N   THR    45      -7.432  -1.375 -11.688  1.00 65.23           N  
ATOM    696  CA  THR    45      -6.485  -1.970 -12.619  1.00 31.31           C  
ATOM    697  C   THR    45      -5.052  -1.838 -12.108  1.00 32.21           C  
ATOM    698  O   THR    45      -4.336  -2.832 -11.983  1.00 30.05           O  
ATOM    699  CB  THR    45      -6.586  -1.312 -14.008  1.00 73.30           C  
ATOM    700  OG1 THR    45      -7.941  -1.362 -14.475  1.00 22.51           O  
ATOM    701  CG2 THR    45      -5.673  -2.011 -15.006  1.00 62.31           C  
ATOM    702  H   THR    45      -8.058  -0.697 -12.017  1.00 71.11           H  
ATOM    703  HA  THR    45      -6.728  -3.019 -12.720  1.00 45.11           H  
ATOM    704  HB  THR    45      -6.279  -0.279 -13.922  1.00 71.42           H  
ATOM    705  HG1 THR    45      -8.215  -0.480 -14.749  1.00 14.35           H  
ATOM    706 HG21 THR    45      -4.653  -1.955 -14.659  1.00 36.92           H  
ATOM    707 HG22 THR    45      -5.752  -1.528 -15.970  1.00 36.92           H  
ATOM    708 HG23 THR    45      -5.966  -3.046 -15.098  1.00 36.92           H  
ATOM    709  N   LYS    46      -4.647  -0.613 -11.785  1.00 43.41           N  
ATOM    710  CA  LYS    46      -3.278  -0.371 -11.342  1.00 13.22           C  
ATOM    711  C   LYS    46      -3.031  -0.946  -9.949  1.00 74.13           C  
ATOM    712  O   LYS    46      -1.901  -1.290  -9.606  1.00 74.50           O  
ATOM    713  CB  LYS    46      -2.906   1.110 -11.431  1.00 20.52           C  
ATOM    714  CG  LYS    46      -3.828   2.057 -10.694  1.00 45.41           C  
ATOM    715  CD  LYS    46      -3.570   3.491 -11.125  1.00 65.20           C  
ATOM    716  CE  LYS    46      -2.105   3.875 -10.961  1.00 50.24           C  
ATOM    717  NZ  LYS    46      -1.766   5.128 -11.692  1.00 65.40           N  
ATOM    718  H   LYS    46      -5.281   0.136 -11.841  1.00 25.43           H  
ATOM    719  HA  LYS    46      -2.641  -0.905 -12.026  1.00 53.31           H  
ATOM    720  HB2 LYS    46      -1.913   1.236 -11.029  1.00 36.92           H  
ATOM    721  HB3 LYS    46      -2.896   1.396 -12.473  1.00 36.92           H  
ATOM    722  HG2 LYS    46      -4.854   1.800 -10.918  1.00 36.92           H  
ATOM    723  HG3 LYS    46      -3.653   1.970  -9.633  1.00 36.92           H  
ATOM    724  HD2 LYS    46      -3.848   3.603 -12.162  1.00 36.92           H  
ATOM    725  HD3 LYS    46      -4.172   4.140 -10.519  1.00 36.92           H  
ATOM    726  HE2 LYS    46      -1.899   4.017  -9.911  1.00 36.92           H  
ATOM    727  HE3 LYS    46      -1.494   3.072 -11.341  1.00 36.92           H  
ATOM    728  HZ1 LYS    46      -2.261   5.946 -11.272  1.00 36.92           H  
ATOM    729  HZ2 LYS    46      -2.047   5.046 -12.693  1.00 36.92           H  
ATOM    730  HZ3 LYS    46      -0.738   5.300 -11.654  1.00 36.92           H  
ATOM    731  N   LEU    47      -4.086  -1.053  -9.150  1.00 74.23           N  
ATOM    732  CA  LEU    47      -3.993  -1.742  -7.866  1.00 35.22           C  
ATOM    733  C   LEU    47      -3.630  -3.211  -8.078  1.00 13.01           C  
ATOM    734  O   LEU    47      -2.806  -3.759  -7.352  1.00 61.51           O  
ATOM    735  CB  LEU    47      -5.308  -1.629  -7.083  1.00 13.51           C  
ATOM    736  CG  LEU    47      -5.396  -0.462  -6.092  1.00 71.30           C  
ATOM    737  CD1 LEU    47      -4.392  -0.640  -4.966  1.00 55.22           C  
ATOM    738  CD2 LEU    47      -5.172   0.867  -6.790  1.00 60.32           C  
ATOM    739  H   LEU    47      -4.943  -0.663  -9.429  1.00 33.42           H  
ATOM    740  HA  LEU    47      -3.200  -1.273  -7.296  1.00 34.23           H  
ATOM    741  HB2 LEU    47      -6.114  -1.528  -7.795  1.00 36.92           H  
ATOM    742  HB3 LEU    47      -5.453  -2.547  -6.533  1.00 36.92           H  
ATOM    743  HG  LEU    47      -6.383  -0.447  -5.655  1.00  4.10           H  
ATOM    744 HD11 LEU    47      -3.390  -0.614  -5.369  1.00 36.92           H  
ATOM    745 HD12 LEU    47      -4.560  -1.592  -4.483  1.00 36.92           H  
ATOM    746 HD13 LEU    47      -4.515   0.156  -4.247  1.00 36.92           H  
ATOM    747 HD21 LEU    47      -5.256   1.670  -6.072  1.00 36.92           H  
ATOM    748 HD22 LEU    47      -5.917   0.995  -7.562  1.00 36.92           H  
ATOM    749 HD23 LEU    47      -4.188   0.881  -7.232  1.00 36.92           H  
ATOM    750  N   LYS    48      -4.243  -3.840  -9.078  1.00 73.20           N  
ATOM    751  CA  LYS    48      -3.909  -5.213  -9.441  1.00 75.42           C  
ATOM    752  C   LYS    48      -2.463  -5.317  -9.916  1.00 51.41           C  
ATOM    753  O   LYS    48      -1.756  -6.266  -9.571  1.00 33.44           O  
ATOM    754  CB  LYS    48      -4.852  -5.730 -10.530  1.00 33.13           C  
ATOM    755  CG  LYS    48      -6.310  -5.777 -10.105  1.00 42.44           C  
ATOM    756  CD  LYS    48      -6.452  -6.375  -8.717  1.00 64.23           C  
ATOM    757  CE  LYS    48      -7.872  -6.839  -8.440  1.00 25.11           C  
ATOM    758  NZ  LYS    48      -8.293  -7.930  -9.360  1.00 44.22           N  
ATOM    759  H   LYS    48      -4.956  -3.380  -9.571  1.00 54.34           H  
ATOM    760  HA  LYS    48      -4.027  -5.823  -8.558  1.00 12.33           H  
ATOM    761  HB2 LYS    48      -4.773  -5.085 -11.392  1.00 36.92           H  
ATOM    762  HB3 LYS    48      -4.549  -6.728 -10.810  1.00 36.92           H  
ATOM    763  HG2 LYS    48      -6.709  -4.773 -10.099  1.00 36.92           H  
ATOM    764  HG3 LYS    48      -6.861  -6.384 -10.806  1.00 36.92           H  
ATOM    765  HD2 LYS    48      -5.782  -7.212  -8.632  1.00 36.92           H  
ATOM    766  HD3 LYS    48      -6.181  -5.624  -7.988  1.00 36.92           H  
ATOM    767  HE2 LYS    48      -7.929  -7.197  -7.423  1.00 36.92           H  
ATOM    768  HE3 LYS    48      -8.540  -6.000  -8.563  1.00 36.92           H  
ATOM    769  HZ1 LYS    48      -7.595  -8.708  -9.341  1.00 36.92           H  
ATOM    770  HZ2 LYS    48      -8.371  -7.570 -10.336  1.00 36.92           H  
ATOM    771  HZ3 LYS    48      -9.220  -8.306  -9.067  1.00 36.92           H  
ATOM    772  N   GLU    49      -2.027  -4.338 -10.704  1.00 11.24           N  
ATOM    773  CA  GLU    49      -0.648  -4.291 -11.179  1.00 21.22           C  
ATOM    774  C   GLU    49       0.310  -4.242  -9.994  1.00 71.10           C  
ATOM    775  O   GLU    49       1.316  -4.953  -9.958  1.00 65.13           O  
ATOM    776  CB  GLU    49      -0.431  -3.066 -12.074  1.00 24.45           C  
ATOM    777  CG  GLU    49      -1.391  -2.986 -13.250  1.00 22.30           C  
ATOM    778  CD  GLU    49      -1.150  -1.768 -14.124  1.00 71.11           C  
ATOM    779  OE1 GLU    49      -1.441  -0.639 -13.680  1.00  3.41           O  
ATOM    780  OE2 GLU    49      -0.676  -1.931 -15.267  1.00 13.53           O  
ATOM    781  H   GLU    49      -2.651  -3.632 -10.981  1.00 54.14           H  
ATOM    782  HA  GLU    49      -0.457  -5.188 -11.750  1.00 30.44           H  
ATOM    783  HB2 GLU    49      -0.553  -2.175 -11.477  1.00 36.92           H  
ATOM    784  HB3 GLU    49       0.576  -3.092 -12.463  1.00 36.92           H  
ATOM    785  HG2 GLU    49      -1.273  -3.873 -13.852  1.00 36.92           H  
ATOM    786  HG3 GLU    49      -2.401  -2.943 -12.869  1.00 36.92           H  
ATOM    787  N   LEU    50      -0.027  -3.407  -9.023  1.00 32.24           N  
ATOM    788  CA  LEU    50       0.779  -3.245  -7.819  1.00 54.34           C  
ATOM    789  C   LEU    50       0.700  -4.475  -6.919  1.00 62.31           C  
ATOM    790  O   LEU    50       1.695  -4.870  -6.308  1.00 33.53           O  
ATOM    791  CB  LEU    50       0.328  -1.999  -7.058  1.00 74.11           C  
ATOM    792  CG  LEU    50       0.742  -0.676  -7.701  1.00 64.13           C  
ATOM    793  CD1 LEU    50       0.149   0.499  -6.940  1.00  1.12           C  
ATOM    794  CD2 LEU    50       2.259  -0.572  -7.746  1.00 55.13           C  
ATOM    795  H   LEU    50      -0.846  -2.872  -9.121  1.00  0.32           H  
ATOM    796  HA  LEU    50       1.804  -3.110  -8.128  1.00 33.13           H  
ATOM    797  HB2 LEU    50      -0.750  -2.019  -6.985  1.00 36.92           H  
ATOM    798  HB3 LEU    50       0.738  -2.036  -6.063  1.00 36.92           H  
ATOM    799  HG  LEU    50       0.371  -0.642  -8.715  1.00 33.34           H  
ATOM    800 HD11 LEU    50       0.499   0.481  -5.919  1.00 36.92           H  
ATOM    801 HD12 LEU    50      -0.929   0.428  -6.952  1.00 36.92           H  
ATOM    802 HD13 LEU    50       0.454   1.422  -7.409  1.00 36.92           H  
ATOM    803 HD21 LEU    50       2.650  -0.596  -6.740  1.00 36.92           H  
ATOM    804 HD22 LEU    50       2.542   0.355  -8.222  1.00 36.92           H  
ATOM    805 HD23 LEU    50       2.660  -1.403  -8.308  1.00 36.92           H  
ATOM    806  N   ALA    51      -0.481  -5.079  -6.846  1.00 41.11           N  
ATOM    807  CA  ALA    51      -0.690  -6.268  -6.026  1.00 11.41           C  
ATOM    808  C   ALA    51       0.201  -7.417  -6.487  1.00 11.52           C  
ATOM    809  O   ALA    51       0.742  -8.157  -5.667  1.00 40.12           O  
ATOM    810  CB  ALA    51      -2.151  -6.690  -6.057  1.00 40.43           C  
ATOM    811  H   ALA    51      -1.241  -4.704  -7.346  1.00 73.44           H  
ATOM    812  HA  ALA    51      -0.434  -6.017  -5.007  1.00 62.11           H  
ATOM    813  HB1 ALA    51      -2.770  -5.869  -5.728  1.00 36.92           H  
ATOM    814  HB2 ALA    51      -2.297  -7.536  -5.400  1.00 36.92           H  
ATOM    815  HB3 ALA    51      -2.425  -6.967  -7.064  1.00 36.92           H  
ATOM    816  N   ALA    52       0.359  -7.550  -7.802  1.00 30.53           N  
ATOM    817  CA  ALA    52       1.192  -8.601  -8.378  1.00 50.04           C  
ATOM    818  C   ALA    52       2.662  -8.413  -8.011  1.00 23.14           C  
ATOM    819  O   ALA    52       3.413  -9.382  -7.903  1.00 21.42           O  
ATOM    820  CB  ALA    52       1.031  -8.637  -9.891  1.00 23.14           C  
ATOM    821  H   ALA    52      -0.110  -6.929  -8.402  1.00 65.21           H  
ATOM    822  HA  ALA    52       0.853  -9.547  -7.982  1.00 63.03           H  
ATOM    823  HB1 ALA    52       1.603  -9.461 -10.293  1.00 36.92           H  
ATOM    824  HB2 ALA    52       1.390  -7.711 -10.313  1.00 36.92           H  
ATOM    825  HB3 ALA    52      -0.012  -8.768 -10.141  1.00 36.92           H  
ATOM    826  N   ALA    53       3.069  -7.163  -7.831  1.00 15.05           N  
ATOM    827  CA  ALA    53       4.444  -6.860  -7.461  1.00 25.53           C  
ATOM    828  C   ALA    53       4.680  -7.140  -5.981  1.00 14.01           C  
ATOM    829  O   ALA    53       5.673  -7.767  -5.613  1.00 21.34           O  
ATOM    830  CB  ALA    53       4.775  -5.411  -7.788  1.00 44.34           C  
ATOM    831  H   ALA    53       2.430  -6.430  -7.947  1.00 13.42           H  
ATOM    832  HA  ALA    53       5.094  -7.494  -8.046  1.00 13.21           H  
ATOM    833  HB1 ALA    53       4.145  -4.759  -7.203  1.00 36.92           H  
ATOM    834  HB2 ALA    53       4.604  -5.231  -8.839  1.00 36.92           H  
ATOM    835  HB3 ALA    53       5.812  -5.217  -7.554  1.00 36.92           H  
ATOM    836  N   ALA    54       3.753  -6.681  -5.144  1.00 63.51           N  
ATOM    837  CA  ALA    54       3.859  -6.855  -3.698  1.00 50.11           C  
ATOM    838  C   ALA    54       3.695  -8.321  -3.301  1.00 31.12           C  
ATOM    839  O   ALA    54       4.514  -8.878  -2.567  1.00 55.23           O  
ATOM    840  CB  ALA    54       2.816  -5.999  -2.993  1.00 43.23           C  
ATOM    841  H   ALA    54       2.975  -6.206  -5.510  1.00 62.02           H  
ATOM    842  HA  ALA    54       4.836  -6.516  -3.391  1.00  3.24           H  
ATOM    843  HB1 ALA    54       2.917  -4.971  -3.311  1.00 36.92           H  
ATOM    844  HB2 ALA    54       2.961  -6.061  -1.925  1.00 36.92           H  
ATOM    845  HB3 ALA    54       1.828  -6.357  -3.243  1.00 36.92           H  
ATOM    846  N   SER    55       2.634  -8.937  -3.792  1.00 63.11           N  
ATOM    847  CA  SER    55       2.357 -10.328  -3.496  1.00 53.42           C  
ATOM    848  C   SER    55       2.462 -11.162  -4.763  1.00 52.22           C  
ATOM    849  O   SER    55       1.758 -10.909  -5.740  1.00  1.23           O  
ATOM    850  CB  SER    55       0.966 -10.466  -2.874  1.00 41.12           C  
ATOM    851  OG  SER    55      -0.024  -9.848  -3.684  1.00 43.44           O  
ATOM    852  H   SER    55       2.023  -8.444  -4.381  1.00 22.04           H  
ATOM    853  HA  SER    55       3.097 -10.674  -2.789  1.00 21.41           H  
ATOM    854  HB2 SER    55       0.725 -11.515  -2.767  1.00 36.92           H  
ATOM    855  HB3 SER    55       0.962  -9.994  -1.904  1.00 36.92           H  
ATOM    856  HG  SER    55       0.393  -9.486  -4.478  1.00  0.33           H  
ATOM    857  N   SER    56       3.356 -12.139  -4.752  1.00 71.22           N  
ATOM    858  CA  SER    56       3.554 -12.997  -5.907  1.00  2.45           C  
ATOM    859  C   SER    56       2.365 -13.942  -6.077  1.00 50.23           C  
ATOM    860  O   SER    56       1.435 -13.646  -6.832  1.00 52.53           O  
ATOM    861  CB  SER    56       4.852 -13.788  -5.752  1.00 10.03           C  
ATOM    862  OG  SER    56       5.923 -12.940  -5.373  1.00 72.14           O  
ATOM    863  H   SER    56       3.899 -12.284  -3.947  1.00  1.32           H  
ATOM    864  HA  SER    56       3.625 -12.366  -6.780  1.00  4.24           H  
ATOM    865  HB2 SER    56       4.722 -14.545  -4.993  1.00 36.92           H  
ATOM    866  HB3 SER    56       5.099 -14.260  -6.693  1.00 36.92           H  
ATOM    867  HG  SER    56       5.861 -12.107  -5.866  1.00  4.34           H  
ATOM    868  N   ALA    57       2.396 -15.065  -5.353  1.00 12.51           N  
ATOM    869  CA  ALA    57       1.335 -16.047  -5.377  1.00 33.14           C  
ATOM    870  C   ALA    57       1.033 -16.502  -6.796  1.00 23.43           C  
ATOM    871  O   ALA    57       1.818 -16.299  -7.729  1.00 10.43           O  
ATOM    872  CB  ALA    57       0.083 -15.483  -4.713  1.00 62.00           C  
ATOM    873  H   ALA    57       3.159 -15.242  -4.789  1.00 31.43           H  
ATOM    874  HA  ALA    57       1.662 -16.901  -4.801  1.00 43.33           H  
ATOM    875  HB1 ALA    57      -0.252 -14.613  -5.258  1.00 36.92           H  
ATOM    876  HB2 ALA    57       0.309 -15.204  -3.694  1.00 36.92           H  
ATOM    877  HB3 ALA    57      -0.695 -16.232  -4.716  1.00 36.92           H  
ATOM    878  N   ASP    58      -0.098 -17.142  -6.935  1.00 51.44           N  
ATOM    879  CA  ASP    58      -0.593 -17.557  -8.241  1.00 60.15           C  
ATOM    880  C   ASP    58      -1.215 -16.372  -8.962  1.00 21.53           C  
ATOM    881  O   ASP    58      -0.896 -16.094 -10.118  1.00 41.32           O  
ATOM    882  CB  ASP    58      -1.630 -18.676  -8.110  1.00 52.14           C  
ATOM    883  CG  ASP    58      -1.017 -20.002  -7.713  1.00 11.33           C  
ATOM    884  OD1 ASP    58      -0.813 -20.238  -6.500  1.00 22.34           O  
ATOM    885  OD2 ASP    58      -0.735 -20.819  -8.612  1.00 61.34           O  
ATOM    886  H   ASP    58      -0.616 -17.340  -6.127  1.00 45.34           H  
ATOM    887  HA  ASP    58       0.247 -17.917  -8.816  1.00 63.12           H  
ATOM    888  HB2 ASP    58      -2.356 -18.399  -7.361  1.00 36.92           H  
ATOM    889  HB3 ASP    58      -2.131 -18.802  -9.060  1.00 36.92           H  
ATOM    890  N   GLU    59      -2.106 -15.675  -8.268  1.00  5.43           N  
ATOM    891  CA  GLU    59      -2.817 -14.540  -8.838  1.00 65.12           C  
ATOM    892  C   GLU    59      -2.734 -13.331  -7.912  1.00 42.44           C  
ATOM    893  O   GLU    59      -3.513 -12.381  -8.038  1.00 62.23           O  
ATOM    894  CB  GLU    59      -4.278 -14.922  -9.073  1.00 24.01           C  
ATOM    895  CG  GLU    59      -4.443 -16.070 -10.051  1.00 21.50           C  
ATOM    896  CD  GLU    59      -5.859 -16.586 -10.113  1.00 22.43           C  
ATOM    897  OE1 GLU    59      -6.689 -15.976 -10.815  1.00 73.42           O  
ATOM    898  OE2 GLU    59      -6.144 -17.611  -9.459  1.00 70.12           O  
ATOM    899  H   GLU    59      -2.307 -15.947  -7.341  1.00 73.32           H  
ATOM    900  HA  GLU    59      -2.358 -14.294  -9.783  1.00 21.01           H  
ATOM    901  HB2 GLU    59      -4.718 -15.214  -8.130  1.00 36.92           H  
ATOM    902  HB3 GLU    59      -4.808 -14.064  -9.460  1.00 36.92           H  
ATOM    903  HG2 GLU    59      -4.156 -15.734 -11.036  1.00 36.92           H  
ATOM    904  HG3 GLU    59      -3.796 -16.879  -9.746  1.00 36.92           H  
ATOM    905  N   GLY    60      -1.785 -13.372  -6.989  1.00 65.33           N  
ATOM    906  CA  GLY    60      -1.613 -12.283  -6.052  1.00 60.33           C  
ATOM    907  C   GLY    60      -2.392 -12.506  -4.771  1.00  3.34           C  
ATOM    908  O   GLY    60      -3.015 -13.554  -4.590  1.00 14.40           O  
ATOM    909  H   GLY    60      -1.195 -14.152  -6.939  1.00 72.33           H  
ATOM    910  HA2 GLY    60      -0.562 -12.188  -5.815  1.00 36.92           H  
ATOM    911  HA3 GLY    60      -1.954 -11.369  -6.514  1.00 36.92           H  
ATOM    912  N   ALA    61      -2.346 -11.526  -3.880  1.00 72.42           N  
ATOM    913  CA  ALA    61      -3.069 -11.591  -2.616  1.00 51.33           C  
ATOM    914  C   ALA    61      -4.578 -11.542  -2.840  1.00 33.41           C  
ATOM    915  O   ALA    61      -5.045 -11.232  -3.938  1.00 22.40           O  
ATOM    916  CB  ALA    61      -2.636 -10.451  -1.708  1.00 75.35           C  
ATOM    917  H   ALA    61      -1.799 -10.733  -4.074  1.00 11.03           H  
ATOM    918  HA  ALA    61      -2.817 -12.522  -2.131  1.00 14.23           H  
ATOM    919  HB1 ALA    61      -3.144 -10.536  -0.758  1.00 36.92           H  
ATOM    920  HB2 ALA    61      -2.892  -9.508  -2.169  1.00 36.92           H  
ATOM    921  HB3 ALA    61      -1.569 -10.498  -1.553  1.00 36.92           H  
ATOM    922  N   SER    62      -5.334 -11.843  -1.793  1.00 73.03           N  
ATOM    923  CA  SER    62      -6.787 -11.813  -1.866  1.00 13.25           C  
ATOM    924  C   SER    62      -7.280 -10.372  -1.920  1.00 31.33           C  
ATOM    925  O   SER    62      -6.742  -9.502  -1.239  1.00 73.22           O  
ATOM    926  CB  SER    62      -7.375 -12.533  -0.656  1.00 54.03           C  
ATOM    927  OG  SER    62      -6.856 -13.851  -0.560  1.00 72.43           O  
ATOM    928  H   SER    62      -4.903 -12.076  -0.942  1.00 71.44           H  
ATOM    929  HA  SER    62      -7.090 -12.325  -2.766  1.00 52.21           H  
ATOM    930  HB2 SER    62      -7.120 -11.994   0.245  1.00 36.92           H  
ATOM    931  HB3 SER    62      -8.448 -12.581  -0.755  1.00 36.92           H  
ATOM    932  HG  SER    62      -6.398 -14.071  -1.381  1.00 64.34           H  
ATOM    933  N   VAL    63      -8.296 -10.121  -2.728  1.00 44.14           N  
ATOM    934  CA  VAL    63      -8.796  -8.773  -2.909  1.00  5.32           C  
ATOM    935  C   VAL    63     -10.323  -8.737  -2.879  1.00 64.30           C  
ATOM    936  O   VAL    63     -10.999  -9.339  -3.715  1.00 54.23           O  
ATOM    937  CB  VAL    63      -8.267  -8.150  -4.225  1.00 12.20           C  
ATOM    938  CG1 VAL    63      -8.564  -9.045  -5.422  1.00 44.21           C  
ATOM    939  CG2 VAL    63      -8.845  -6.758  -4.438  1.00  3.44           C  
ATOM    940  H   VAL    63      -8.730 -10.863  -3.205  1.00 41.21           H  
ATOM    941  HA  VAL    63      -8.424  -8.176  -2.088  1.00 34.10           H  
ATOM    942  HB  VAL    63      -7.194  -8.057  -4.141  1.00 44.33           H  
ATOM    943 HG11 VAL    63      -9.633  -9.167  -5.524  1.00 36.92           H  
ATOM    944 HG12 VAL    63      -8.104 -10.010  -5.273  1.00 36.92           H  
ATOM    945 HG13 VAL    63      -8.166  -8.591  -6.318  1.00 36.92           H  
ATOM    946 HG21 VAL    63      -8.434  -6.330  -5.341  1.00 36.92           H  
ATOM    947 HG22 VAL    63      -8.594  -6.131  -3.595  1.00 36.92           H  
ATOM    948 HG23 VAL    63      -9.919  -6.825  -4.530  1.00 36.92           H  
ATOM    949  N   ALA    64     -10.856  -8.047  -1.887  1.00  0.14           N  
ATOM    950  CA  ALA    64     -12.288  -7.819  -1.788  1.00 21.41           C  
ATOM    951  C   ALA    64     -12.562  -6.327  -1.880  1.00 35.15           C  
ATOM    952  O   ALA    64     -12.278  -5.578  -0.946  1.00 43.34           O  
ATOM    953  CB  ALA    64     -12.834  -8.391  -0.489  1.00 63.04           C  
ATOM    954  H   ALA    64     -10.264  -7.673  -1.193  1.00 52.24           H  
ATOM    955  HA  ALA    64     -12.769  -8.322  -2.616  1.00 14.12           H  
ATOM    956  HB1 ALA    64     -12.364  -7.896   0.348  1.00 36.92           H  
ATOM    957  HB2 ALA    64     -12.625  -9.449  -0.445  1.00 36.92           H  
ATOM    958  HB3 ALA    64     -13.902  -8.233  -0.447  1.00 36.92           H  
ATOM    959  N   TYR    65     -13.097  -5.890  -3.004  1.00 54.34           N  
ATOM    960  CA  TYR    65     -13.224  -4.466  -3.259  1.00 14.20           C  
ATOM    961  C   TYR    65     -14.639  -3.974  -3.005  1.00 50.43           C  
ATOM    962  O   TYR    65     -15.609  -4.709  -3.185  1.00 43.51           O  
ATOM    963  CB  TYR    65     -12.788  -4.132  -4.693  1.00  1.20           C  
ATOM    964  CG  TYR    65     -13.635  -4.762  -5.787  1.00  2.44           C  
ATOM    965  CD1 TYR    65     -14.810  -4.154  -6.216  1.00  0.31           C  
ATOM    966  CD2 TYR    65     -13.252  -5.950  -6.401  1.00 62.40           C  
ATOM    967  CE1 TYR    65     -15.579  -4.712  -7.217  1.00 73.44           C  
ATOM    968  CE2 TYR    65     -14.017  -6.511  -7.408  1.00 12.11           C  
ATOM    969  CZ  TYR    65     -15.179  -5.887  -7.809  1.00  0.44           C  
ATOM    970  OH  TYR    65     -15.944  -6.433  -8.815  1.00 35.31           O  
ATOM    971  H   TYR    65     -13.431  -6.535  -3.668  1.00 31.52           H  
ATOM    972  HA  TYR    65     -12.560  -3.956  -2.575  1.00 43.25           H  
ATOM    973  HB2 TYR    65     -12.825  -3.062  -4.826  1.00 36.92           H  
ATOM    974  HB3 TYR    65     -11.770  -4.467  -4.830  1.00 36.92           H  
ATOM    975  HD1 TYR    65     -15.122  -3.233  -5.751  1.00 71.15           H  
ATOM    976  HD2 TYR    65     -12.342  -6.438  -6.083  1.00 51.12           H  
ATOM    977  HE1 TYR    65     -16.490  -4.225  -7.533  1.00 12.11           H  
ATOM    978  HE2 TYR    65     -13.706  -7.435  -7.874  1.00 43.35           H  
ATOM    979  HH  TYR    65     -16.005  -7.390  -8.696  1.00 23.11           H  
ATOM    980  N   LYS    66     -14.740  -2.736  -2.558  1.00 23.34           N  
ATOM    981  CA  LYS    66     -16.020  -2.076  -2.406  1.00 52.14           C  
ATOM    982  C   LYS    66     -16.198  -1.043  -3.489  1.00 45.51           C  
ATOM    983  O   LYS    66     -15.264  -0.320  -3.838  1.00 42.11           O  
ATOM    984  CB  LYS    66     -16.127  -1.366  -1.064  1.00 20.13           C  
ATOM    985  CG  LYS    66     -16.056  -2.280   0.131  1.00 13.54           C  
ATOM    986  CD  LYS    66     -15.737  -1.473   1.373  1.00 52.40           C  
ATOM    987  CE  LYS    66     -15.406  -2.345   2.568  1.00 75.44           C  
ATOM    988  NZ  LYS    66     -14.811  -1.538   3.664  1.00  1.23           N  
ATOM    989  H   LYS    66     -13.923  -2.248  -2.307  1.00 52.21           H  
ATOM    990  HA  LYS    66     -16.799  -2.817  -2.485  1.00 74.25           H  
ATOM    991  HB2 LYS    66     -15.321  -0.652  -0.985  1.00 36.92           H  
ATOM    992  HB3 LYS    66     -17.067  -0.836  -1.025  1.00 36.92           H  
ATOM    993  HG2 LYS    66     -17.011  -2.769   0.259  1.00 36.92           H  
ATOM    994  HG3 LYS    66     -15.287  -3.011  -0.035  1.00 36.92           H  
ATOM    995  HD2 LYS    66     -14.890  -0.837   1.165  1.00 36.92           H  
ATOM    996  HD3 LYS    66     -16.593  -0.859   1.616  1.00 36.92           H  
ATOM    997  HE2 LYS    66     -16.313  -2.811   2.923  1.00 36.92           H  
ATOM    998  HE3 LYS    66     -14.701  -3.103   2.264  1.00 36.92           H  
ATOM    999  HZ1 LYS    66     -15.471  -0.782   3.954  1.00 36.92           H  
ATOM   1000  HZ2 LYS    66     -13.921  -1.095   3.334  1.00 36.92           H  
ATOM   1001  HZ3 LYS    66     -14.602  -2.135   4.488  1.00 36.92           H  
ATOM   1002  N   ILE    67     -17.398  -0.991  -4.009  1.00 45.32           N  
ATOM   1003  CA  ILE    67     -17.793   0.051  -4.939  1.00 72.14           C  
ATOM   1004  C   ILE    67     -19.163   0.573  -4.544  1.00 63.23           C  
ATOM   1005  O   ILE    67     -20.180  -0.090  -4.764  1.00 32.20           O  
ATOM   1006  CB  ILE    67     -17.842  -0.437  -6.404  1.00 21.51           C  
ATOM   1007  CG1 ILE    67     -16.476  -0.963  -6.847  1.00 22.50           C  
ATOM   1008  CG2 ILE    67     -18.293   0.700  -7.315  1.00 22.44           C  
ATOM   1009  CD1 ILE    67     -16.452  -1.466  -8.275  1.00  1.44           C  
ATOM   1010  H   ILE    67     -18.049  -1.670  -3.740  1.00  2.22           H  
ATOM   1011  HA  ILE    67     -17.073   0.855  -4.866  1.00 75.03           H  
ATOM   1012  HB  ILE    67     -18.568  -1.233  -6.474  1.00 11.44           H  
ATOM   1013 HG12 ILE    67     -15.750  -0.169  -6.763  1.00 36.92           H  
ATOM   1014 HG13 ILE    67     -16.185  -1.779  -6.201  1.00 36.92           H  
ATOM   1015 HG21 ILE    67     -19.276   1.032  -7.018  1.00 36.92           H  
ATOM   1016 HG22 ILE    67     -18.323   0.353  -8.338  1.00 36.92           H  
ATOM   1017 HG23 ILE    67     -17.596   1.520  -7.235  1.00 36.92           H  
ATOM   1018 HD11 ILE    67     -17.154  -2.280  -8.381  1.00 36.92           H  
ATOM   1019 HD12 ILE    67     -15.459  -1.812  -8.518  1.00 36.92           H  
ATOM   1020 HD13 ILE    67     -16.726  -0.663  -8.943  1.00 36.92           H  
ATOM   1021  N   LYS    68     -19.186   1.740  -3.934  1.00 34.32           N  
ATOM   1022  CA  LYS    68     -20.437   2.340  -3.514  1.00 25.45           C  
ATOM   1023  C   LYS    68     -20.806   3.478  -4.442  1.00 45.23           C  
ATOM   1024  O   LYS    68     -20.070   4.459  -4.571  1.00 71.53           O  
ATOM   1025  CB  LYS    68     -20.345   2.827  -2.072  1.00 71.40           C  
ATOM   1026  CG  LYS    68     -21.651   3.377  -1.517  1.00 52.33           C  
ATOM   1027  CD  LYS    68     -21.542   3.652  -0.026  1.00 33.42           C  
ATOM   1028  CE  LYS    68     -22.825   4.245   0.538  1.00 50.52           C  
ATOM   1029  NZ  LYS    68     -23.997   3.355   0.327  1.00 72.10           N  
ATOM   1030  H   LYS    68     -18.341   2.211  -3.764  1.00 40.12           H  
ATOM   1031  HA  LYS    68     -21.205   1.582  -3.579  1.00 54.24           H  
ATOM   1032  HB2 LYS    68     -20.038   2.003  -1.451  1.00 36.92           H  
ATOM   1033  HB3 LYS    68     -19.602   3.607  -2.018  1.00 36.92           H  
ATOM   1034  HG2 LYS    68     -21.887   4.300  -2.025  1.00 36.92           H  
ATOM   1035  HG3 LYS    68     -22.438   2.657  -1.685  1.00 36.92           H  
ATOM   1036  HD2 LYS    68     -21.333   2.724   0.486  1.00 36.92           H  
ATOM   1037  HD3 LYS    68     -20.731   4.346   0.141  1.00 36.92           H  
ATOM   1038  HE2 LYS    68     -22.696   4.409   1.598  1.00 36.92           H  
ATOM   1039  HE3 LYS    68     -23.010   5.193   0.051  1.00 36.92           H  
ATOM   1040  HZ1 LYS    68     -23.818   2.416   0.742  1.00 36.92           H  
ATOM   1041  HZ2 LYS    68     -24.187   3.246  -0.691  1.00 36.92           H  
ATOM   1042  HZ3 LYS    68     -24.843   3.766   0.780  1.00 36.92           H  
ATOM   1043  N   ASP    69     -21.948   3.326  -5.082  1.00 60.11           N  
ATOM   1044  CA  ASP    69     -22.432   4.284  -6.053  1.00 21.41           C  
ATOM   1045  C   ASP    69     -23.101   5.447  -5.324  1.00 34.11           C  
ATOM   1046  O   ASP    69     -24.267   5.355  -4.939  1.00 44.23           O  
ATOM   1047  CB  ASP    69     -23.443   3.619  -6.996  1.00 24.45           C  
ATOM   1048  CG  ASP    69     -23.033   2.222  -7.437  1.00 63.23           C  
ATOM   1049  OD1 ASP    69     -22.338   2.087  -8.468  1.00 23.43           O  
ATOM   1050  OD2 ASP    69     -23.432   1.246  -6.762  1.00 74.32           O  
ATOM   1051  H   ASP    69     -22.499   2.539  -4.881  1.00 51.42           H  
ATOM   1052  HA  ASP    69     -21.589   4.649  -6.628  1.00 41.14           H  
ATOM   1053  HB2 ASP    69     -24.397   3.548  -6.495  1.00 36.92           H  
ATOM   1054  HB3 ASP    69     -23.553   4.231  -7.872  1.00 36.92           H  
ATOM   1055  N   LEU    70     -22.358   6.520  -5.106  1.00 53.24           N  
ATOM   1056  CA  LEU    70     -22.879   7.671  -4.381  1.00 44.32           C  
ATOM   1057  C   LEU    70     -23.393   8.734  -5.341  1.00 73.41           C  
ATOM   1058  O   LEU    70     -23.405   8.542  -6.559  1.00 72.32           O  
ATOM   1059  CB  LEU    70     -21.796   8.270  -3.478  1.00 24.22           C  
ATOM   1060  CG  LEU    70     -21.334   7.376  -2.330  1.00 55.12           C  
ATOM   1061  CD1 LEU    70     -20.155   8.007  -1.604  1.00 61.32           C  
ATOM   1062  CD2 LEU    70     -22.483   7.129  -1.367  1.00 75.23           C  
ATOM   1063  H   LEU    70     -21.438   6.548  -5.446  1.00 74.20           H  
ATOM   1064  HA  LEU    70     -23.700   7.332  -3.766  1.00 60.34           H  
ATOM   1065  HB2 LEU    70     -20.938   8.504  -4.092  1.00 36.92           H  
ATOM   1066  HB3 LEU    70     -22.177   9.189  -3.058  1.00 36.92           H  
ATOM   1067  HG  LEU    70     -21.015   6.424  -2.727  1.00 20.33           H  
ATOM   1068 HD11 LEU    70     -19.847   7.366  -0.790  1.00 36.92           H  
ATOM   1069 HD12 LEU    70     -20.445   8.971  -1.213  1.00 36.92           H  
ATOM   1070 HD13 LEU    70     -19.334   8.131  -2.294  1.00 36.92           H  
ATOM   1071 HD21 LEU    70     -22.155   6.473  -0.576  1.00 36.92           H  
ATOM   1072 HD22 LEU    70     -23.305   6.671  -1.898  1.00 36.92           H  
ATOM   1073 HD23 LEU    70     -22.807   8.069  -0.945  1.00 36.92           H  
ATOM   1074  N   GLU    71     -23.814   9.857  -4.785  1.00 23.43           N  
ATOM   1075  CA  GLU    71     -24.349  10.951  -5.573  1.00  1.01           C  
ATOM   1076  C   GLU    71     -23.249  11.955  -5.905  1.00 60.04           C  
ATOM   1077  O   GLU    71     -22.900  12.807  -5.086  1.00  1.51           O  
ATOM   1078  CB  GLU    71     -25.472  11.637  -4.801  1.00 70.31           C  
ATOM   1079  CG  GLU    71     -26.265  12.635  -5.619  1.00 62.41           C  
ATOM   1080  CD  GLU    71     -27.254  13.402  -4.774  1.00 30.54           C  
ATOM   1081  OE1 GLU    71     -28.047  12.768  -4.047  1.00 32.54           O  
ATOM   1082  OE2 GLU    71     -27.228  14.651  -4.815  1.00 74.10           O  
ATOM   1083  H   GLU    71     -23.765   9.954  -3.807  1.00 15.23           H  
ATOM   1084  HA  GLU    71     -24.744  10.545  -6.491  1.00 14.31           H  
ATOM   1085  HB2 GLU    71     -26.154  10.884  -4.436  1.00 36.92           H  
ATOM   1086  HB3 GLU    71     -25.043  12.158  -3.957  1.00 36.92           H  
ATOM   1087  HG2 GLU    71     -25.580  13.336  -6.072  1.00 36.92           H  
ATOM   1088  HG3 GLU    71     -26.805  12.107  -6.393  1.00 36.92           H  
ATOM   1089  N   GLY    72     -22.685  11.829  -7.094  1.00 12.40           N  
ATOM   1090  CA  GLY    72     -21.642  12.744  -7.518  1.00 54.51           C  
ATOM   1091  C   GLY    72     -20.257  12.149  -7.384  1.00 60.22           C  
ATOM   1092  O   GLY    72     -19.296  12.660  -7.960  1.00 71.13           O  
ATOM   1093  H   GLY    72     -22.982  11.111  -7.693  1.00 72.14           H  
ATOM   1094  HA2 GLY    72     -21.811  13.008  -8.553  1.00 36.92           H  
ATOM   1095  HA3 GLY    72     -21.696  13.638  -6.916  1.00 36.92           H  
ATOM   1096  N   GLN    73     -20.152  11.070  -6.626  1.00 12.51           N  
ATOM   1097  CA  GLN    73     -18.878  10.398  -6.423  1.00 65.04           C  
ATOM   1098  C   GLN    73     -19.103   8.924  -6.129  1.00 53.02           C  
ATOM   1099  O   GLN    73     -20.239   8.469  -6.037  1.00  4.34           O  
ATOM   1100  CB  GLN    73     -18.098  11.043  -5.271  1.00 73.13           C  
ATOM   1101  CG  GLN    73     -18.834  11.021  -3.939  1.00 20.53           C  
ATOM   1102  CD  GLN    73     -17.944  11.413  -2.774  1.00 32.52           C  
ATOM   1103  OE1 GLN    73     -17.817  12.589  -2.437  1.00 12.33           O  
ATOM   1104  NE2 GLN    73     -17.331  10.424  -2.142  1.00 64.02           N  
ATOM   1105  H   GLN    73     -20.955  10.705  -6.197  1.00  2.45           H  
ATOM   1106  HA  GLN    73     -18.304  10.489  -7.334  1.00 14.12           H  
ATOM   1107  HB2 GLN    73     -17.164  10.517  -5.148  1.00 36.92           H  
ATOM   1108  HB3 GLN    73     -17.890  12.072  -5.526  1.00 36.92           H  
ATOM   1109  HG2 GLN    73     -19.662  11.712  -3.987  1.00 36.92           H  
ATOM   1110  HG3 GLN    73     -19.208  10.023  -3.766  1.00 36.92           H  
ATOM   1111 HE21 GLN    73     -17.484   9.510  -2.455  1.00 36.92           H  
ATOM   1112 HE22 GLN    73     -16.755  10.646  -1.380  1.00 36.92           H  
ATOM   1113  N   VAL    74     -18.016   8.182  -6.000  1.00 44.24           N  
ATOM   1114  CA  VAL    74     -18.083   6.779  -5.618  1.00 51.30           C  
ATOM   1115  C   VAL    74     -16.989   6.451  -4.614  1.00 24.33           C  
ATOM   1116  O   VAL    74     -15.954   7.121  -4.569  1.00  0.32           O  
ATOM   1117  CB  VAL    74     -17.938   5.837  -6.832  1.00 13.50           C  
ATOM   1118  CG1 VAL    74     -19.130   5.966  -7.767  1.00 50.33           C  
ATOM   1119  CG2 VAL    74     -16.641   6.115  -7.573  1.00 32.50           C  
ATOM   1120  H   VAL    74     -17.138   8.591  -6.170  1.00 31.51           H  
ATOM   1121  HA  VAL    74     -19.046   6.601  -5.161  1.00 15.53           H  
ATOM   1122  HB  VAL    74     -17.903   4.822  -6.468  1.00  4.20           H  
ATOM   1123 HG11 VAL    74     -19.014   5.283  -8.595  1.00 36.92           H  
ATOM   1124 HG12 VAL    74     -19.188   6.978  -8.139  1.00 36.92           H  
ATOM   1125 HG13 VAL    74     -20.035   5.728  -7.228  1.00 36.92           H  
ATOM   1126 HG21 VAL    74     -16.557   5.445  -8.416  1.00 36.92           H  
ATOM   1127 HG22 VAL    74     -15.806   5.962  -6.906  1.00 36.92           H  
ATOM   1128 HG23 VAL    74     -16.639   7.137  -7.924  1.00 36.92           H  
ATOM   1129  N   GLU    75     -17.224   5.429  -3.807  1.00 25.23           N  
ATOM   1130  CA  GLU    75     -16.222   4.954  -2.868  1.00 61.11           C  
ATOM   1131  C   GLU    75     -15.567   3.690  -3.386  1.00 54.30           C  
ATOM   1132  O   GLU    75     -16.224   2.657  -3.540  1.00 60.22           O  
ATOM   1133  CB  GLU    75     -16.831   4.678  -1.495  1.00 44.30           C  
ATOM   1134  CG  GLU    75     -17.083   5.925  -0.679  1.00  2.41           C  
ATOM   1135  CD  GLU    75     -17.741   5.628   0.651  1.00 51.44           C  
ATOM   1136  OE1 GLU    75     -18.290   4.516   0.815  1.00 33.35           O  
ATOM   1137  OE2 GLU    75     -17.693   6.496   1.546  1.00 15.14           O  
ATOM   1138  H   GLU    75     -18.095   4.978  -3.847  1.00 52.23           H  
ATOM   1139  HA  GLU    75     -15.467   5.724  -2.770  1.00 22.00           H  
ATOM   1140  HB2 GLU    75     -17.774   4.168  -1.627  1.00 36.92           H  
ATOM   1141  HB3 GLU    75     -16.162   4.040  -0.938  1.00 36.92           H  
ATOM   1142  HG2 GLU    75     -16.137   6.411  -0.491  1.00 36.92           H  
ATOM   1143  HG3 GLU    75     -17.715   6.584  -1.244  1.00 36.92           H  
ATOM   1144  N   LEU    76     -14.285   3.786  -3.670  1.00 12.03           N  
ATOM   1145  CA  LEU    76     -13.500   2.625  -4.045  1.00 73.45           C  
ATOM   1146  C   LEU    76     -12.639   2.229  -2.859  1.00 13.34           C  
ATOM   1147  O   LEU    76     -11.725   2.958  -2.479  1.00 71.02           O  
ATOM   1148  CB  LEU    76     -12.638   2.929  -5.283  1.00 30.32           C  
ATOM   1149  CG  LEU    76     -11.966   1.718  -5.963  1.00 24.24           C  
ATOM   1150  CD1 LEU    76     -10.748   1.240  -5.183  1.00 52.21           C  
ATOM   1151  CD2 LEU    76     -12.963   0.581  -6.137  1.00 40.14           C  
ATOM   1152  H   LEU    76     -13.849   4.665  -3.617  1.00  2.51           H  
ATOM   1153  HA  LEU    76     -14.180   1.817  -4.271  1.00 12.21           H  
ATOM   1154  HB2 LEU    76     -13.265   3.416  -6.015  1.00 36.92           H  
ATOM   1155  HB3 LEU    76     -11.862   3.620  -4.989  1.00 36.92           H  
ATOM   1156  HG  LEU    76     -11.631   2.013  -6.943  1.00  3.32           H  
ATOM   1157 HD11 LEU    76     -10.305   0.395  -5.689  1.00 36.92           H  
ATOM   1158 HD12 LEU    76     -11.049   0.949  -4.189  1.00 36.92           H  
ATOM   1159 HD13 LEU    76     -10.024   2.040  -5.120  1.00 36.92           H  
ATOM   1160 HD21 LEU    76     -13.782   0.909  -6.759  1.00 36.92           H  
ATOM   1161 HD22 LEU    76     -13.343   0.282  -5.170  1.00 36.92           H  
ATOM   1162 HD23 LEU    76     -12.471  -0.259  -6.604  1.00 36.92           H  
ATOM   1163  N   ASP    77     -12.956   1.092  -2.270  1.00 44.04           N  
ATOM   1164  CA  ASP    77     -12.244   0.619  -1.085  1.00 71.33           C  
ATOM   1165  C   ASP    77     -11.896  -0.850  -1.246  1.00 21.25           C  
ATOM   1166  O   ASP    77     -12.757  -1.719  -1.129  1.00  5.21           O  
ATOM   1167  CB  ASP    77     -13.078   0.839   0.186  1.00 30.32           C  
ATOM   1168  CG  ASP    77     -12.360   0.396   1.454  1.00 43.10           C  
ATOM   1169  OD1 ASP    77     -11.302   0.975   1.778  1.00 52.23           O  
ATOM   1170  OD2 ASP    77     -12.863  -0.523   2.140  1.00 61.53           O  
ATOM   1171  H   ASP    77     -13.676   0.543  -2.655  1.00 11.34           H  
ATOM   1172  HA  ASP    77     -11.327   1.184  -1.006  1.00 53.23           H  
ATOM   1173  HB2 ASP    77     -13.308   1.891   0.279  1.00 36.92           H  
ATOM   1174  HB3 ASP    77     -14.001   0.283   0.105  1.00 36.92           H  
ATOM   1175  N   ALA    78     -10.642  -1.121  -1.553  1.00 23.23           N  
ATOM   1176  CA  ALA    78     -10.206  -2.479  -1.820  1.00 62.42           C  
ATOM   1177  C   ALA    78      -9.454  -3.060  -0.634  1.00 62.32           C  
ATOM   1178  O   ALA    78      -8.474  -2.483  -0.161  1.00  3.13           O  
ATOM   1179  CB  ALA    78      -9.338  -2.511  -3.067  1.00 32.42           C  
ATOM   1180  H   ALA    78      -9.988  -0.385  -1.591  1.00 35.04           H  
ATOM   1181  HA  ALA    78     -11.084  -3.079  -2.006  1.00 25.14           H  
ATOM   1182  HB1 ALA    78      -9.042  -3.529  -3.273  1.00 36.92           H  
ATOM   1183  HB2 ALA    78      -8.459  -1.906  -2.907  1.00 36.92           H  
ATOM   1184  HB3 ALA    78      -9.897  -2.122  -3.905  1.00 36.92           H  
ATOM   1185  N   ALA    79      -9.925  -4.201  -0.156  1.00 14.34           N  
ATOM   1186  CA  ALA    79      -9.272  -4.897   0.935  1.00 74.43           C  
ATOM   1187  C   ALA    79      -8.351  -5.982   0.396  1.00 62.11           C  
ATOM   1188  O   ALA    79      -8.807  -6.953  -0.212  1.00 60.22           O  
ATOM   1189  CB  ALA    79     -10.306  -5.489   1.880  1.00 15.01           C  
ATOM   1190  H   ALA    79     -10.743  -4.584  -0.546  1.00 24.21           H  
ATOM   1191  HA  ALA    79      -8.683  -4.177   1.484  1.00 62.25           H  
ATOM   1192  HB1 ALA    79     -10.983  -4.712   2.204  1.00 36.92           H  
ATOM   1193  HB2 ALA    79      -9.808  -5.914   2.739  1.00 36.92           H  
ATOM   1194  HB3 ALA    79     -10.861  -6.260   1.366  1.00 36.92           H  
ATOM   1195  N   PHE    80      -7.057  -5.796   0.603  1.00 44.11           N  
ATOM   1196  CA  PHE    80      -6.057  -6.747   0.142  1.00 65.22           C  
ATOM   1197  C   PHE    80      -5.550  -7.596   1.296  1.00 14.33           C  
ATOM   1198  O   PHE    80      -4.884  -7.094   2.201  1.00 43.53           O  
ATOM   1199  CB  PHE    80      -4.882  -6.015  -0.511  1.00 62.23           C  
ATOM   1200  CG  PHE    80      -5.197  -5.424  -1.857  1.00 12.12           C  
ATOM   1201  CD1 PHE    80      -5.026  -6.170  -3.012  1.00 64.12           C  
ATOM   1202  CD2 PHE    80      -5.660  -4.122  -1.965  1.00  1.25           C  
ATOM   1203  CE1 PHE    80      -5.311  -5.628  -4.251  1.00 23.20           C  
ATOM   1204  CE2 PHE    80      -5.946  -3.576  -3.201  1.00  1.44           C  
ATOM   1205  CZ  PHE    80      -5.771  -4.330  -4.345  1.00  4.21           C  
ATOM   1206  H   PHE    80      -6.763  -4.991   1.089  1.00 31.51           H  
ATOM   1207  HA  PHE    80      -6.522  -7.392  -0.587  1.00 30.54           H  
ATOM   1208  HB2 PHE    80      -4.570  -5.208   0.137  1.00 36.92           H  
ATOM   1209  HB3 PHE    80      -4.060  -6.704  -0.630  1.00 36.92           H  
ATOM   1210  HD1 PHE    80      -4.665  -7.186  -2.938  1.00 24.45           H  
ATOM   1211  HD2 PHE    80      -5.796  -3.530  -1.071  1.00 14.34           H  
ATOM   1212  HE1 PHE    80      -5.173  -6.219  -5.144  1.00 34.43           H  
ATOM   1213  HE2 PHE    80      -6.304  -2.561  -3.272  1.00 24.03           H  
ATOM   1214  HZ  PHE    80      -5.994  -3.904  -5.312  1.00 75.03           H  
ATOM   1215  N   THR    81      -5.864  -8.881   1.257  1.00 11.34           N  
ATOM   1216  CA  THR    81      -5.431  -9.800   2.291  1.00 63.13           C  
ATOM   1217  C   THR    81      -4.085 -10.406   1.929  1.00 62.21           C  
ATOM   1218  O   THR    81      -3.996 -11.274   1.055  1.00  1.30           O  
ATOM   1219  CB  THR    81      -6.464 -10.927   2.510  1.00 55.42           C  
ATOM   1220  OG1 THR    81      -7.730 -10.360   2.875  1.00 23.22           O  
ATOM   1221  CG2 THR    81      -6.002 -11.887   3.599  1.00 51.14           C  
ATOM   1222  H   THR    81      -6.388  -9.224   0.497  1.00 23.55           H  
ATOM   1223  HA  THR    81      -5.332  -9.244   3.212  1.00 12.00           H  
ATOM   1224  HB  THR    81      -6.579 -11.477   1.588  1.00 64.32           H  
ATOM   1225  HG1 THR    81      -7.582  -9.605   3.458  1.00 42.21           H  
ATOM   1226 HG21 THR    81      -5.911 -11.354   4.534  1.00 36.92           H  
ATOM   1227 HG22 THR    81      -5.043 -12.302   3.327  1.00 36.92           H  
ATOM   1228 HG23 THR    81      -6.722 -12.686   3.706  1.00 36.92           H  
ATOM   1229  N   PHE    82      -3.041  -9.929   2.585  1.00 30.33           N  
ATOM   1230  CA  PHE    82      -1.705 -10.441   2.361  1.00 25.52           C  
ATOM   1231  C   PHE    82      -1.409 -11.577   3.328  1.00 12.33           C  
ATOM   1232  O   PHE    82      -2.144 -11.791   4.296  1.00 63.14           O  
ATOM   1233  CB  PHE    82      -0.672  -9.324   2.523  1.00 61.22           C  
ATOM   1234  CG  PHE    82      -0.754  -8.263   1.458  1.00 34.50           C  
ATOM   1235  CD1 PHE    82      -0.074  -8.414   0.261  1.00  4.42           C  
ATOM   1236  CD2 PHE    82      -1.509  -7.119   1.654  1.00  5.35           C  
ATOM   1237  CE1 PHE    82      -0.145  -7.445  -0.720  1.00  1.34           C  
ATOM   1238  CE2 PHE    82      -1.584  -6.144   0.676  1.00 14.24           C  
ATOM   1239  CZ  PHE    82      -0.901  -6.309  -0.512  1.00 62.53           C  
ATOM   1240  H   PHE    82      -3.173  -9.213   3.242  1.00 62.12           H  
ATOM   1241  HA  PHE    82      -1.660 -10.821   1.350  1.00 14.25           H  
ATOM   1242  HB2 PHE    82      -0.819  -8.846   3.479  1.00 36.92           H  
ATOM   1243  HB3 PHE    82       0.320  -9.754   2.491  1.00 36.92           H  
ATOM   1244  HD1 PHE    82       0.517  -9.302   0.095  1.00  5.41           H  
ATOM   1245  HD2 PHE    82      -2.044  -6.991   2.584  1.00 23.51           H  
ATOM   1246  HE1 PHE    82       0.391  -7.574  -1.648  1.00 60.10           H  
ATOM   1247  HE2 PHE    82      -2.177  -5.255   0.840  1.00 64.21           H  
ATOM   1248  HZ  PHE    82      -0.959  -5.549  -1.279  1.00  4.14           H  
ATOM   1249  N   SER    83      -0.337 -12.299   3.069  1.00 75.03           N  
ATOM   1250  CA  SER    83       0.052 -13.409   3.916  1.00 22.32           C  
ATOM   1251  C   SER    83       1.024 -12.920   4.983  1.00 34.44           C  
ATOM   1252  O   SER    83       1.085 -13.455   6.088  1.00 72.02           O  
ATOM   1253  CB  SER    83       0.691 -14.510   3.071  1.00 42.15           C  
ATOM   1254  OG  SER    83      -0.133 -14.842   1.963  1.00 71.23           O  
ATOM   1255  H   SER    83       0.229 -12.062   2.292  1.00 64.54           H  
ATOM   1256  HA  SER    83      -0.834 -13.794   4.396  1.00 51.32           H  
ATOM   1257  HB2 SER    83       1.648 -14.171   2.703  1.00 36.92           H  
ATOM   1258  HB3 SER    83       0.830 -15.392   3.677  1.00 36.92           H  
ATOM   1259  HG  SER    83      -0.148 -14.102   1.347  1.00 63.13           H  
ATOM   1260  N   CYS    84       1.768 -11.880   4.646  1.00 14.33           N  
ATOM   1261  CA  CYS    84       2.748 -11.314   5.552  1.00  3.35           C  
ATOM   1262  C   CYS    84       2.442  -9.840   5.777  1.00 24.12           C  
ATOM   1263  O   CYS    84       1.700  -9.231   5.006  1.00 12.23           O  
ATOM   1264  CB  CYS    84       4.150 -11.465   4.959  1.00 32.54           C  
ATOM   1265  SG  CYS    84       4.440 -13.051   4.143  1.00 64.32           S  
ATOM   1266  H   CYS    84       1.647 -11.474   3.759  1.00 21.02           H  
ATOM   1267  HA  CYS    84       2.692 -11.842   6.493  1.00 43.40           H  
ATOM   1268  HB2 CYS    84       4.306 -10.687   4.228  1.00 36.92           H  
ATOM   1269  HB3 CYS    84       4.878 -11.362   5.750  1.00 36.92           H  
ATOM   1270  HG  CYS    84       4.291 -12.861   2.833  1.00  5.21           H  
ATOM   1271  N   GLN    85       3.009  -9.260   6.820  1.00 12.02           N  
ATOM   1272  CA  GLN    85       2.841  -7.837   7.060  1.00 45.42           C  
ATOM   1273  C   GLN    85       3.818  -7.049   6.206  1.00 45.23           C  
ATOM   1274  O   GLN    85       3.514  -5.945   5.759  1.00 72.34           O  
ATOM   1275  CB  GLN    85       3.032  -7.499   8.537  1.00 24.10           C  
ATOM   1276  CG  GLN    85       2.939  -6.011   8.832  1.00  4.41           C  
ATOM   1277  CD  GLN    85       2.667  -5.733  10.293  1.00 20.40           C  
ATOM   1278  OE1 GLN    85       3.589  -5.561  11.091  1.00  4.15           O  
ATOM   1279  NE2 GLN    85       1.395  -5.704  10.653  1.00  4.11           N  
ATOM   1280  H   GLN    85       3.551  -9.800   7.444  1.00 33.03           H  
ATOM   1281  HA  GLN    85       1.835  -7.572   6.768  1.00 11.14           H  
ATOM   1282  HB2 GLN    85       2.272  -8.005   9.112  1.00 36.92           H  
ATOM   1283  HB3 GLN    85       4.005  -7.848   8.852  1.00 36.92           H  
ATOM   1284  HG2 GLN    85       3.874  -5.544   8.559  1.00 36.92           H  
ATOM   1285  HG3 GLN    85       2.143  -5.586   8.240  1.00 36.92           H  
ATOM   1286 HE21 GLN    85       0.712  -5.861   9.963  1.00 36.92           H  
ATOM   1287 HE22 GLN    85       1.182  -5.534  11.599  1.00 36.92           H  
ATOM   1288  N   ALA    86       4.986  -7.639   5.971  1.00 43.40           N  
ATOM   1289  CA  ALA    86       6.013  -7.022   5.140  1.00  1.11           C  
ATOM   1290  C   ALA    86       5.460  -6.660   3.767  1.00 11.02           C  
ATOM   1291  O   ALA    86       5.602  -5.530   3.312  1.00 13.21           O  
ATOM   1292  CB  ALA    86       7.207  -7.954   5.003  1.00 60.14           C  
ATOM   1293  H   ALA    86       5.170  -8.508   6.384  1.00 20.34           H  
ATOM   1294  HA  ALA    86       6.343  -6.120   5.635  1.00 44.00           H  
ATOM   1295  HB1 ALA    86       6.904  -8.855   4.491  1.00 36.92           H  
ATOM   1296  HB2 ALA    86       7.582  -8.205   5.984  1.00 36.92           H  
ATOM   1297  HB3 ALA    86       7.982  -7.461   4.437  1.00 36.92           H  
ATOM   1298  N   GLU    87       4.804  -7.620   3.128  1.00 34.24           N  
ATOM   1299  CA  GLU    87       4.230  -7.407   1.802  1.00 53.14           C  
ATOM   1300  C   GLU    87       3.065  -6.412   1.851  1.00  2.12           C  
ATOM   1301  O   GLU    87       2.774  -5.740   0.863  1.00  2.04           O  
ATOM   1302  CB  GLU    87       3.792  -8.742   1.188  1.00 73.41           C  
ATOM   1303  CG  GLU    87       3.017  -9.630   2.144  1.00 12.24           C  
ATOM   1304  CD  GLU    87       2.751 -11.017   1.585  1.00 31.21           C  
ATOM   1305  OE1 GLU    87       3.725 -11.734   1.274  1.00 33.21           O  
ATOM   1306  OE2 GLU    87       1.570 -11.395   1.471  1.00 44.22           O  
ATOM   1307  H   GLU    87       4.705  -8.495   3.554  1.00 34.13           H  
ATOM   1308  HA  GLU    87       5.008  -6.984   1.182  1.00 52.24           H  
ATOM   1309  HB2 GLU    87       3.165  -8.540   0.332  1.00 36.92           H  
ATOM   1310  HB3 GLU    87       4.670  -9.279   0.861  1.00 36.92           H  
ATOM   1311  HG2 GLU    87       3.582  -9.732   3.058  1.00 36.92           H  
ATOM   1312  HG3 GLU    87       2.069  -9.159   2.359  1.00 36.92           H  
ATOM   1313  N   MET    88       2.413  -6.310   3.006  1.00 52.33           N  
ATOM   1314  CA  MET    88       1.300  -5.382   3.176  1.00 24.23           C  
ATOM   1315  C   MET    88       1.807  -3.942   3.255  1.00 14.41           C  
ATOM   1316  O   MET    88       1.372  -3.077   2.493  1.00  0.21           O  
ATOM   1317  CB  MET    88       0.490  -5.743   4.433  1.00 34.40           C  
ATOM   1318  CG  MET    88      -0.783  -4.924   4.616  1.00 60.15           C  
ATOM   1319  SD  MET    88      -0.493  -3.301   5.350  1.00  0.12           S  
ATOM   1320  CE  MET    88       0.031  -3.759   7.002  1.00 21.04           C  
ATOM   1321  H   MET    88       2.688  -6.870   3.759  1.00 35.21           H  
ATOM   1322  HA  MET    88       0.660  -5.473   2.309  1.00 72.13           H  
ATOM   1323  HB2 MET    88       0.211  -6.785   4.378  1.00 36.92           H  
ATOM   1324  HB3 MET    88       1.114  -5.594   5.303  1.00 36.92           H  
ATOM   1325  HG2 MET    88      -1.245  -4.783   3.649  1.00 36.92           H  
ATOM   1326  HG3 MET    88      -1.457  -5.476   5.254  1.00 36.92           H  
ATOM   1327  HE1 MET    88       0.905  -4.392   6.940  1.00 36.92           H  
ATOM   1328  HE2 MET    88      -0.767  -4.293   7.497  1.00 36.92           H  
ATOM   1329  HE3 MET    88       0.270  -2.868   7.564  1.00 36.92           H  
ATOM   1330  N   ILE    89       2.745  -3.695   4.163  1.00 35.42           N  
ATOM   1331  CA  ILE    89       3.269  -2.353   4.375  1.00 43.20           C  
ATOM   1332  C   ILE    89       3.995  -1.816   3.142  1.00 61.45           C  
ATOM   1333  O   ILE    89       3.833  -0.649   2.794  1.00 55.34           O  
ATOM   1334  CB  ILE    89       4.210  -2.290   5.596  1.00 34.31           C  
ATOM   1335  CG1 ILE    89       5.259  -3.401   5.532  1.00 51.41           C  
ATOM   1336  CG2 ILE    89       3.407  -2.386   6.884  1.00 41.33           C  
ATOM   1337  CD1 ILE    89       6.361  -3.268   6.558  1.00  5.14           C  
ATOM   1338  H   ILE    89       3.084  -4.429   4.713  1.00 34.24           H  
ATOM   1339  HA  ILE    89       2.425  -1.709   4.579  1.00  1.23           H  
ATOM   1340  HB  ILE    89       4.707  -1.335   5.584  1.00 43.22           H  
ATOM   1341 HG12 ILE    89       4.773  -4.350   5.696  1.00 36.92           H  
ATOM   1342 HG13 ILE    89       5.712  -3.401   4.555  1.00 36.92           H  
ATOM   1343 HG21 ILE    89       4.077  -2.342   7.730  1.00 36.92           H  
ATOM   1344 HG22 ILE    89       2.866  -3.320   6.900  1.00 36.92           H  
ATOM   1345 HG23 ILE    89       2.709  -1.564   6.934  1.00 36.92           H  
ATOM   1346 HD11 ILE    89       6.888  -2.337   6.402  1.00 36.92           H  
ATOM   1347 HD12 ILE    89       7.050  -4.093   6.455  1.00 36.92           H  
ATOM   1348 HD13 ILE    89       5.933  -3.276   7.549  1.00 36.92           H  
ATOM   1349  N   ILE    90       4.778  -2.659   2.470  1.00 32.24           N  
ATOM   1350  CA  ILE    90       5.503  -2.224   1.282  1.00 31.31           C  
ATOM   1351  C   ILE    90       4.533  -1.885   0.152  1.00 73.11           C  
ATOM   1352  O   ILE    90       4.821  -1.042  -0.700  1.00  4.12           O  
ATOM   1353  CB  ILE    90       6.558  -3.259   0.815  1.00 23.53           C  
ATOM   1354  CG1 ILE    90       5.924  -4.601   0.429  1.00 33.53           C  
ATOM   1355  CG2 ILE    90       7.607  -3.464   1.899  1.00 34.14           C  
ATOM   1356  CD1 ILE    90       5.578  -4.718  -1.040  1.00 53.43           C  
ATOM   1357  H   ILE    90       4.876  -3.585   2.779  1.00 55.43           H  
ATOM   1358  HA  ILE    90       6.030  -1.316   1.548  1.00 52.21           H  
ATOM   1359  HB  ILE    90       7.054  -2.849  -0.047  1.00 40.41           H  
ATOM   1360 HG12 ILE    90       6.612  -5.397   0.668  1.00 36.92           H  
ATOM   1361 HG13 ILE    90       5.014  -4.737   0.996  1.00 36.92           H  
ATOM   1362 HG21 ILE    90       8.068  -2.517   2.141  1.00 36.92           H  
ATOM   1363 HG22 ILE    90       8.361  -4.150   1.545  1.00 36.92           H  
ATOM   1364 HG23 ILE    90       7.137  -3.871   2.782  1.00 36.92           H  
ATOM   1365 HD11 ILE    90       5.115  -5.676  -1.223  1.00 36.92           H  
ATOM   1366 HD12 ILE    90       6.479  -4.634  -1.631  1.00 36.92           H  
ATOM   1367 HD13 ILE    90       4.893  -3.929  -1.311  1.00 36.92           H  
ATOM   1368  N   PHE    91       3.384  -2.548   0.152  1.00 12.44           N  
ATOM   1369  CA  PHE    91       2.319  -2.246  -0.793  1.00  4.12           C  
ATOM   1370  C   PHE    91       1.830  -0.816  -0.570  1.00 34.42           C  
ATOM   1371  O   PHE    91       1.723  -0.035  -1.515  1.00 51.31           O  
ATOM   1372  CB  PHE    91       1.172  -3.249  -0.628  1.00  3.51           C  
ATOM   1373  CG  PHE    91       0.042  -3.069  -1.600  1.00 12.43           C  
ATOM   1374  CD1 PHE    91       0.213  -3.358  -2.942  1.00 64.41           C  
ATOM   1375  CD2 PHE    91      -1.193  -2.620  -1.168  1.00  2.12           C  
ATOM   1376  CE1 PHE    91      -0.827  -3.202  -3.837  1.00  1.12           C  
ATOM   1377  CE2 PHE    91      -2.238  -2.463  -2.057  1.00 51.23           C  
ATOM   1378  CZ  PHE    91      -2.054  -2.754  -3.393  1.00 33.21           C  
ATOM   1379  H   PHE    91       3.248  -3.261   0.810  1.00 34.24           H  
ATOM   1380  HA  PHE    91       2.723  -2.328  -1.791  1.00 22.42           H  
ATOM   1381  HB2 PHE    91       1.560  -4.248  -0.757  1.00 36.92           H  
ATOM   1382  HB3 PHE    91       0.769  -3.155   0.370  1.00 36.92           H  
ATOM   1383  HD1 PHE    91       1.172  -3.709  -3.289  1.00 41.40           H  
ATOM   1384  HD2 PHE    91      -1.335  -2.391  -0.122  1.00 71.30           H  
ATOM   1385  HE1 PHE    91      -0.679  -3.430  -4.882  1.00 71.31           H  
ATOM   1386  HE2 PHE    91      -3.198  -2.112  -1.706  1.00 41.33           H  
ATOM   1387  HZ  PHE    91      -2.869  -2.633  -4.092  1.00 14.52           H  
ATOM   1388  N   GLU    92       1.566  -0.479   0.693  1.00 60.31           N  
ATOM   1389  CA  GLU    92       1.198   0.884   1.079  1.00 10.41           C  
ATOM   1390  C   GLU    92       2.265   1.883   0.648  1.00 35.53           C  
ATOM   1391  O   GLU    92       1.952   2.971   0.162  1.00 73.23           O  
ATOM   1392  CB  GLU    92       0.999   0.976   2.593  1.00 11.32           C  
ATOM   1393  CG  GLU    92      -0.192   0.187   3.105  1.00 64.52           C  
ATOM   1394  CD  GLU    92      -1.510   0.842   2.735  1.00 54.45           C  
ATOM   1395  OE1 GLU    92      -1.816   1.931   3.280  1.00 62.31           O  
ATOM   1396  OE2 GLU    92      -2.236   0.284   1.889  1.00 51.03           O  
ATOM   1397  H   GLU    92       1.610  -1.172   1.387  1.00 65.03           H  
ATOM   1398  HA  GLU    92       0.270   1.131   0.588  1.00 64.10           H  
ATOM   1399  HB2 GLU    92       1.887   0.604   3.083  1.00 36.92           H  
ATOM   1400  HB3 GLU    92       0.860   2.015   2.862  1.00 36.92           H  
ATOM   1401  HG2 GLU    92      -0.164  -0.803   2.672  1.00 36.92           H  
ATOM   1402  HG3 GLU    92      -0.125   0.109   4.181  1.00 36.92           H  
ATOM   1403  N   LEU    93       3.524   1.505   0.827  1.00 14.44           N  
ATOM   1404  CA  LEU    93       4.640   2.349   0.424  1.00 24.34           C  
ATOM   1405  C   LEU    93       4.606   2.583  -1.085  1.00 52.55           C  
ATOM   1406  O   LEU    93       4.647   3.724  -1.550  1.00 74.11           O  
ATOM   1407  CB  LEU    93       5.964   1.700   0.832  1.00  3.13           C  
ATOM   1408  CG  LEU    93       6.067   1.306   2.306  1.00 35.43           C  
ATOM   1409  CD1 LEU    93       7.460   0.789   2.622  1.00 62.01           C  
ATOM   1410  CD2 LEU    93       5.712   2.481   3.203  1.00 24.35           C  
ATOM   1411  H   LEU    93       3.706   0.635   1.248  1.00 15.41           H  
ATOM   1412  HA  LEU    93       4.539   3.298   0.929  1.00 74.31           H  
ATOM   1413  HB2 LEU    93       6.102   0.811   0.235  1.00 36.92           H  
ATOM   1414  HB3 LEU    93       6.764   2.391   0.610  1.00 36.92           H  
ATOM   1415  HG  LEU    93       5.364   0.510   2.507  1.00 55.25           H  
ATOM   1416 HD11 LEU    93       8.183   1.571   2.441  1.00 36.92           H  
ATOM   1417 HD12 LEU    93       7.681  -0.058   1.991  1.00 36.92           H  
ATOM   1418 HD13 LEU    93       7.506   0.487   3.659  1.00 36.92           H  
ATOM   1419 HD21 LEU    93       5.766   2.175   4.236  1.00 36.92           H  
ATOM   1420 HD22 LEU    93       4.710   2.818   2.978  1.00 36.92           H  
ATOM   1421 HD23 LEU    93       6.409   3.289   3.031  1.00 36.92           H  
ATOM   1422  N   SER    94       4.526   1.491  -1.834  1.00  0.42           N  
ATOM   1423  CA  SER    94       4.378   1.541  -3.285  1.00 43.13           C  
ATOM   1424  C   SER    94       3.182   2.409  -3.695  1.00 14.02           C  
ATOM   1425  O   SER    94       3.272   3.188  -4.643  1.00  4.35           O  
ATOM   1426  CB  SER    94       4.212   0.120  -3.833  1.00  2.31           C  
ATOM   1427  OG  SER    94       5.285  -0.711  -3.419  1.00 23.35           O  
ATOM   1428  H   SER    94       4.600   0.614  -1.398  1.00 60.22           H  
ATOM   1429  HA  SER    94       5.278   1.972  -3.695  1.00  1.32           H  
ATOM   1430  HB2 SER    94       3.288  -0.299  -3.467  1.00 36.92           H  
ATOM   1431  HB3 SER    94       4.192   0.151  -4.913  1.00 36.92           H  
ATOM   1432  HG  SER    94       5.171  -0.947  -2.492  1.00 41.11           H  
ATOM   1433  N   LEU    95       2.070   2.281  -2.972  1.00 65.10           N  
ATOM   1434  CA  LEU    95       0.882   3.091  -3.234  1.00 21.12           C  
ATOM   1435  C   LEU    95       1.207   4.574  -3.106  1.00 64.05           C  
ATOM   1436  O   LEU    95       0.848   5.375  -3.964  1.00  4.22           O  
ATOM   1437  CB  LEU    95      -0.252   2.736  -2.267  1.00 12.15           C  
ATOM   1438  CG  LEU    95      -0.826   1.327  -2.408  1.00 65.30           C  
ATOM   1439  CD1 LEU    95      -1.894   1.083  -1.355  1.00 40.24           C  
ATOM   1440  CD2 LEU    95      -1.397   1.125  -3.799  1.00 22.31           C  
ATOM   1441  H   LEU    95       2.047   1.617  -2.244  1.00 33.15           H  
ATOM   1442  HA  LEU    95       0.561   2.888  -4.246  1.00 51.10           H  
ATOM   1443  HB2 LEU    95       0.116   2.849  -1.258  1.00 36.92           H  
ATOM   1444  HB3 LEU    95      -1.056   3.442  -2.417  1.00 36.92           H  
ATOM   1445  HG  LEU    95      -0.036   0.604  -2.257  1.00 24.45           H  
ATOM   1446 HD11 LEU    95      -2.701   1.789  -1.489  1.00 36.92           H  
ATOM   1447 HD12 LEU    95      -1.466   1.210  -0.372  1.00 36.92           H  
ATOM   1448 HD13 LEU    95      -2.277   0.078  -1.454  1.00 36.92           H  
ATOM   1449 HD21 LEU    95      -2.186   1.842  -3.972  1.00 36.92           H  
ATOM   1450 HD22 LEU    95      -1.793   0.124  -3.886  1.00 36.92           H  
ATOM   1451 HD23 LEU    95      -0.616   1.267  -4.530  1.00 36.92           H  
ATOM   1452  N   ARG    96       1.900   4.920  -2.030  1.00 52.23           N  
ATOM   1453  CA  ARG    96       2.298   6.299  -1.768  1.00 74.33           C  
ATOM   1454  C   ARG    96       3.264   6.810  -2.829  1.00 44.22           C  
ATOM   1455  O   ARG    96       3.304   8.001  -3.123  1.00 53.24           O  
ATOM   1456  CB  ARG    96       2.932   6.407  -0.385  1.00 63.10           C  
ATOM   1457  CG  ARG    96       1.926   6.265   0.735  1.00 54.05           C  
ATOM   1458  CD  ARG    96       2.605   6.167   2.084  1.00 63.12           C  
ATOM   1459  NE  ARG    96       3.512   7.289   2.341  1.00 62.44           N  
ATOM   1460  CZ  ARG    96       4.058   7.550   3.530  1.00 22.01           C  
ATOM   1461  NH1 ARG    96       3.766   6.797   4.586  1.00  1.44           N  
ATOM   1462  NH2 ARG    96       4.889   8.573   3.660  1.00 42.11           N  
ATOM   1463  H   ARG    96       2.154   4.221  -1.385  1.00 51.31           H  
ATOM   1464  HA  ARG    96       1.407   6.904  -1.783  1.00 74.33           H  
ATOM   1465  HB2 ARG    96       3.676   5.630  -0.276  1.00 36.92           H  
ATOM   1466  HB3 ARG    96       3.411   7.371  -0.292  1.00 36.92           H  
ATOM   1467  HG2 ARG    96       1.272   7.125   0.731  1.00 36.92           H  
ATOM   1468  HG3 ARG    96       1.345   5.370   0.569  1.00 36.92           H  
ATOM   1469  HD2 ARG    96       1.843   6.152   2.842  1.00 36.92           H  
ATOM   1470  HD3 ARG    96       3.167   5.247   2.120  1.00 36.92           H  
ATOM   1471  HE  ARG    96       3.735   7.874   1.582  1.00 72.43           H  
ATOM   1472 HH11 ARG    96       3.136   6.026   4.496  1.00 36.92           H  
ATOM   1473 HH12 ARG    96       4.172   7.001   5.487  1.00 36.92           H  
ATOM   1474 HH21 ARG    96       5.105   9.149   2.864  1.00 36.92           H  
ATOM   1475 HH22 ARG    96       5.317   8.773   4.556  1.00 36.92           H  
ATOM   1476  N   SER    97       4.043   5.903  -3.390  1.00 72.43           N  
ATOM   1477  CA  SER    97       5.027   6.261  -4.398  1.00 45.52           C  
ATOM   1478  C   SER    97       4.378   6.420  -5.779  1.00 73.23           C  
ATOM   1479  O   SER    97       4.681   7.365  -6.510  1.00 53.10           O  
ATOM   1480  CB  SER    97       6.126   5.194  -4.444  1.00 74.24           C  
ATOM   1481  OG  SER    97       7.168   5.554  -5.335  1.00 11.23           O  
ATOM   1482  H   SER    97       3.963   4.965  -3.112  1.00  1.44           H  
ATOM   1483  HA  SER    97       5.467   7.203  -4.109  1.00 55.10           H  
ATOM   1484  HB2 SER    97       6.544   5.070  -3.457  1.00 36.92           H  
ATOM   1485  HB3 SER    97       5.697   4.259  -4.770  1.00 36.92           H  
ATOM   1486  HG  SER    97       7.251   6.522  -5.360  1.00 50.13           H  
ATOM   1487  N   LEU    98       3.481   5.505  -6.130  1.00 34.54           N  
ATOM   1488  CA  LEU    98       2.902   5.485  -7.469  1.00 34.41           C  
ATOM   1489  C   LEU    98       1.629   6.318  -7.543  1.00  1.11           C  
ATOM   1490  O   LEU    98       1.524   7.239  -8.354  1.00 72.25           O  
ATOM   1491  CB  LEU    98       2.597   4.050  -7.893  1.00 12.30           C  
ATOM   1492  CG  LEU    98       2.422   3.854  -9.401  1.00 10.13           C  
ATOM   1493  CD1 LEU    98       3.708   4.199 -10.134  1.00 33.50           C  
ATOM   1494  CD2 LEU    98       1.994   2.431  -9.713  1.00 62.21           C  
ATOM   1495  H   LEU    98       3.208   4.822  -5.477  1.00 62.32           H  
ATOM   1496  HA  LEU    98       3.630   5.901  -8.150  1.00 63.01           H  
ATOM   1497  HB2 LEU    98       3.398   3.419  -7.549  1.00 36.92           H  
ATOM   1498  HB3 LEU    98       1.685   3.740  -7.406  1.00 36.92           H  
ATOM   1499  HG  LEU    98       1.649   4.521  -9.756  1.00 15.40           H  
ATOM   1500 HD11 LEU    98       3.963   5.231  -9.946  1.00 36.92           H  
ATOM   1501 HD12 LEU    98       3.570   4.049 -11.194  1.00 36.92           H  
ATOM   1502 HD13 LEU    98       4.506   3.562  -9.781  1.00 36.92           H  
ATOM   1503 HD21 LEU    98       1.892   2.312 -10.782  1.00 36.92           H  
ATOM   1504 HD22 LEU    98       1.046   2.229  -9.237  1.00 36.92           H  
ATOM   1505 HD23 LEU    98       2.738   1.741  -9.344  1.00 36.92           H  
ATOM   1506  N   ALA    99       0.664   5.990  -6.698  1.00 63.54           N  
ATOM   1507  CA  ALA    99      -0.616   6.682  -6.705  1.00 23.02           C  
ATOM   1508  C   ALA    99      -0.475   8.024  -6.008  1.00  2.43           C  
ATOM   1509  O   ALA    99      -1.050   9.024  -6.441  1.00 53.01           O  
ATOM   1510  CB  ALA    99      -1.689   5.832  -6.036  1.00 72.13           C  
ATOM   1511  H   ALA    99       0.825   5.286  -6.033  1.00 42.21           H  
ATOM   1512  HA  ALA    99      -0.902   6.846  -7.734  1.00 51.33           H  
ATOM   1513  HB1 ALA    99      -1.413   5.645  -5.008  1.00 36.92           H  
ATOM   1514  HB2 ALA    99      -1.784   4.893  -6.560  1.00 36.92           H  
ATOM   1515  HB3 ALA    99      -2.634   6.356  -6.064  1.00 36.92           H  
END
