
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   85 ( 1328),  selected   85 , name 2ytc_A
# Molecule2: number of CA atoms   76 ( 1151),  selected   76 , name T0437.pdb
# PARAMETERS: 2ytc_A.T0437.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G   227_A      -       -           -
LGA    S   228_A      -       -           -
LGA    S   229_A      -       -           -
LGA    G   230_A      -       -           -
LGA    S   231_A      -       -           -
LGA    S   232_A      -       -           -
LGA    G   233_A      -       -           -
LGA    E   234_A      -       -           -
LGA    D   235_A      -       -           -
LGA    K   236_A      -       -           -
LGA    T   237_A      D      24          4.839
LGA    I   238_A      N      25          1.523
LGA    T   239_A      C      26          1.268
LGA    T   240_A      T      27          1.343
LGA    L   241_A      S      28          1.400
LGA    Y   242_A      K      29          1.552
LGA    V   243_A      F      30          1.280
LGA    G   244_A      S      31          1.880
LGA    G   245_A      R      32          2.020
LGA    L   246_A      F      33           #
LGA    -       -      F      34           -
LGA    -       -      A      35           -
LGA    -       -      T      36           -
LGA    -       -      R      37           -
LGA    -       -      E      38           -
LGA    -       -      E      39           -
LGA    G   247_A      A      40          1.798
LGA    D   248_A      E      41          3.788
LGA    T   249_A      S      42          2.868
LGA    I   250_A      F      43          1.873
LGA    T   251_A      M      44          2.694
LGA    E   252_A      -       -           -
LGA    T   253_A      T      45          4.199
LGA    D   254_A      K      46          2.978
LGA    L   255_A      L      47          1.495
LGA    R   256_A      K      48          2.205
LGA    N   257_A      E      49          2.327
LGA    H   258_A      L      50          1.105
LGA    F   259_A      A      51          1.798
LGA    Y   260_A      A      52          1.687
LGA    Q   261_A      A      53          0.424
LGA    F   262_A      A      54          1.426
LGA    G   263_A      S      55          1.918
LGA    E   264_A      S      56          3.666
LGA    -       -      A      57           -
LGA    -       -      D      58           -
LGA    -       -      E      59           -
LGA    I   265_A      G      60          3.657
LGA    R   266_A      A      61          3.298
LGA    T   267_A      S      62          0.738
LGA    I   268_A      V      63          0.530
LGA    T   269_A      A      64          1.104
LGA    V   270_A      Y      65          1.372
LGA    V   271_A      K      66          0.821
LGA    Q   272_A      I      67          1.296
LGA    R   273_A      K      68          0.897
LGA    -       -      D      69           -
LGA    -       -      L      70           -
LGA    -       -      E      71           -
LGA    -       -      G      72           -
LGA    -       -      Q      73           -
LGA    -       -      V      74           -
LGA    Q   274_A      E      75          2.269
LGA    Q   275_A      L      76          1.520
LGA    C   276_A      D      77          1.724
LGA    A   277_A      A      78          0.849
LGA    F   278_A      A      79          1.162
LGA    I   279_A      F      80          1.319
LGA    Q   280_A      T      81          1.498
LGA    F   281_A      F      82          0.842
LGA    A   282_A      S      83          1.159
LGA    T   283_A      C      84          1.534
LGA    R   284_A      Q      85          1.463
LGA    Q   285_A      A      86          1.789
LGA    A   286_A      E      87          0.893
LGA    A   287_A      M      88          0.890
LGA    E   288_A      I      89          1.690
LGA    V   289_A      I      90          1.169
LGA    A   290_A      F      91          1.189
LGA    A   291_A      E      92          1.878
LGA    E   292_A      L      93          2.244
LGA    K   293_A      S      94          2.449
LGA    S   294_A      L      95          2.114
LGA    F   295_A      -       -           -
LGA    N   296_A      R      96          3.869
LGA    K   297_A      S      97          3.446
LGA    L   298_A      L      98          3.660
LGA    I   299_A      A      99          1.346
LGA    V   300_A      -       -           -
LGA    N   301_A      -       -           -
LGA    G   302_A      -       -           -
LGA    R   303_A      -       -           -
LGA    R   304_A      -       -           -
LGA    L   305_A      -       -           -
LGA    N   306_A      -       -           -
LGA    V   307_A      -       -           -
LGA    K   308_A      -       -           -
LGA    W   309_A      -       -           -
LGA    G   310_A      -       -           -
LGA    R   311_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   85   76    5.0     60    2.12    10.00     66.597     2.697

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.435851 * X  +   0.568704 * Y  +  -0.697574 * Z  +  -4.807806
  Y_new =  -0.874366 * X  +  -0.083826 * Y  +   0.477972 * Z  +  -1.922630
  Z_new =   0.213350 * X  +   0.818260 * Y  +   0.533791 * Z  +  -0.102062 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.992771   -2.148821  [ DEG:    56.8816   -123.1184 ]
  Theta =  -0.215002   -2.926590  [ DEG:   -12.3187   -167.6813 ]
  Phi   =  -2.033225    1.108368  [ DEG:  -116.4952     63.5048 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ytc_A                                        
REMARK     2: T0437.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ytc_A.T0437.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   85   76   5.0   60   2.12   10.00  66.597
REMARK  ---------------------------------------------------------- 
MOLECULE 2ytc_A
HEADER    TRANSCRIPTION                           05-APR-07   2YTC              
TITLE     SOLUTION STRUCTURE OF RNA BINDING DOMAIN IN PRE-MRNA-                 
TITLE    2 SPLICING FACTOR RBM22                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PRE-MRNA-SPLICING FACTOR RBM22;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RNA BINDING MOTIF;                                         
COMPND   5 SYNONYM: RNA-BINDING MOTIF PROTEIN 22, ZINC FINGER CCCH              
COMPND   6 DOMAIN-CONTAINING PROTEIN 16;                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: RBM22;                                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060313-05;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    RRM DOMAIN, RBD, STRUCTURAL GENOMICS, NPPSFA, NATIONAL                
KEYWDS   2 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   3 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI,               
KEYWDS   4 TRANSCRIPTION                                                        
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    N.KASAHARA,K.TSUDA,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,                  
AUTHOR   2 M.SHIROUZU,S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS           
AUTHOR   3 INITIATIVE (RSGI)                                                    
REVDAT   1   09-OCT-07 2YTC    0                                                
JRNL        AUTH   N.KASAHARA,K.TSUDA,Y.MUTO,M.INOUE,T.KIGAWA,                  
JRNL        AUTH 2 T.TERADA,M.SHIROUZU,S.YOKOYAMA                               
JRNL        TITL   SOLUTION STRUCTURE OF RNA BINDING DOMAIN IN                  
JRNL        TITL 2 PRE-MRNA-SPLICING FACTOR RBM22                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2YTC A  234   311  UNP    Q9NW64   RBM22_HUMAN    227    304             
SEQRES   1 A   85  GLY SER SER GLY SER SER GLY GLU ASP LYS THR ILE THR          
SEQRES   2 A   85  THR LEU TYR VAL GLY GLY LEU GLY ASP THR ILE THR GLU          
SEQRES   3 A   85  THR ASP LEU ARG ASN HIS PHE TYR GLN PHE GLY GLU ILE          
SEQRES   4 A   85  ARG THR ILE THR VAL VAL GLN ARG GLN GLN CYS ALA PHE          
SEQRES   5 A   85  ILE GLN PHE ALA THR ARG GLN ALA ALA GLU VAL ALA ALA          
SEQRES   6 A   85  GLU LYS SER PHE ASN LYS LEU ILE VAL ASN GLY ARG ARG          
SEQRES   7 A   85  LEU ASN VAL LYS TRP GLY ARG                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A 227      14.407  15.720   6.919  1.00  0.00           N  
ATOM      2  CA  GLY A 227      14.113  14.320   7.163  1.00  0.00           C  
ATOM      3  C   GLY A 227      12.626  14.029   7.152  1.00  0.00           C  
ATOM      4  O   GLY A 227      11.860  14.700   6.459  1.00  0.00           O  
ATOM      5  H1  GLY A 227      14.101  16.401   7.555  1.00  0.00           H  
ATOM      6  HA2 GLY A 227      14.592  13.725   6.400  1.00  0.00           H  
ATOM      7  HA3 GLY A 227      14.515  14.042   8.127  1.00  0.00           H  
ATOM      8  N   SER A 228      12.215  13.025   7.920  1.00  0.00           N  
ATOM      9  CA  SER A 228      10.809  12.644   7.992  1.00  0.00           C  
ATOM     10  C   SER A 228      10.233  12.949   9.371  1.00  0.00           C  
ATOM     11  O   SER A 228      10.948  12.936  10.372  1.00  0.00           O  
ATOM     12  CB  SER A 228      10.646  11.154   7.678  1.00  0.00           C  
ATOM     13  OG  SER A 228       9.279  10.802   7.576  1.00  0.00           O  
ATOM     14  H   SER A 228      12.873  12.528   8.449  1.00  0.00           H  
ATOM     15  HA  SER A 228      10.271  13.219   7.254  1.00  0.00           H  
ATOM     16  HB2 SER A 228      11.135  10.932   6.742  1.00  0.00           H  
ATOM     17  HB3 SER A 228      11.099  10.572   8.467  1.00  0.00           H  
ATOM     18  HG  SER A 228       9.180  10.079   6.951  1.00  0.00           H  
ATOM     19  N   SER A 229       8.933  13.227   9.413  1.00  0.00           N  
ATOM     20  CA  SER A 229       8.259  13.542  10.667  1.00  0.00           C  
ATOM     21  C   SER A 229       8.260  12.334  11.602  1.00  0.00           C  
ATOM     22  O   SER A 229       8.553  12.455  12.790  1.00  0.00           O  
ATOM     23  CB  SER A 229       6.823  13.993  10.400  1.00  0.00           C  
ATOM     24  OG  SER A 229       6.077  12.972   9.761  1.00  0.00           O  
ATOM     25  H   SER A 229       8.416  13.223   8.580  1.00  0.00           H  
ATOM     26  HA  SER A 229       8.799  14.347  11.141  1.00  0.00           H  
ATOM     27  HB2 SER A 229       6.345  14.239  11.336  1.00  0.00           H  
ATOM     28  HB3 SER A 229       6.835  14.865   9.763  1.00  0.00           H  
ATOM     29  HG  SER A 229       6.080  12.183  10.308  1.00  0.00           H  
ATOM     30  N   GLY A 230       7.926  11.170  11.053  1.00  0.00           N  
ATOM     31  CA  GLY A 230       7.893   9.957  11.850  1.00  0.00           C  
ATOM     32  C   GLY A 230       6.563   9.761  12.551  1.00  0.00           C  
ATOM     33  O   GLY A 230       6.208  10.525  13.447  1.00  0.00           O  
ATOM     34  H   GLY A 230       7.700  11.134  10.100  1.00  0.00           H  
ATOM     35  HA2 GLY A 230       8.077   9.111  11.205  1.00  0.00           H  
ATOM     36  HA3 GLY A 230       8.675  10.007  12.594  1.00  0.00           H  
ATOM     37  N   SER A 231       5.827   8.732  12.141  1.00  0.00           N  
ATOM     38  CA  SER A 231       4.527   8.440  12.732  1.00  0.00           C  
ATOM     39  C   SER A 231       4.385   6.949  13.023  1.00  0.00           C  
ATOM     40  O   SER A 231       5.061   6.120  12.414  1.00  0.00           O  
ATOM     41  CB  SER A 231       3.404   8.898  11.800  1.00  0.00           C  
ATOM     42  OG  SER A 231       3.456   8.210  10.563  1.00  0.00           O  
ATOM     43  H   SER A 231       6.166   8.158  11.423  1.00  0.00           H  
ATOM     44  HA  SER A 231       4.455   8.984  13.663  1.00  0.00           H  
ATOM     45  HB2 SER A 231       2.451   8.704  12.267  1.00  0.00           H  
ATOM     46  HB3 SER A 231       3.504   9.958  11.614  1.00  0.00           H  
ATOM     47  HG  SER A 231       3.361   8.837   9.843  1.00  0.00           H  
ATOM     48  N   SER A 232       3.500   6.616  13.958  1.00  0.00           N  
ATOM     49  CA  SER A 232       3.272   5.226  14.334  1.00  0.00           C  
ATOM     50  C   SER A 232       1.780   4.907  14.351  1.00  0.00           C  
ATOM     51  O   SER A 232       1.104   5.099  15.361  1.00  0.00           O  
ATOM     52  CB  SER A 232       3.882   4.939  15.706  1.00  0.00           C  
ATOM     53  OG  SER A 232       5.276   5.196  15.709  1.00  0.00           O  
ATOM     54  H   SER A 232       2.992   7.323  14.408  1.00  0.00           H  
ATOM     55  HA  SER A 232       3.753   4.600  13.597  1.00  0.00           H  
ATOM     56  HB2 SER A 232       3.411   5.568  16.446  1.00  0.00           H  
ATOM     57  HB3 SER A 232       3.719   3.901  15.960  1.00  0.00           H  
ATOM     58  HG  SER A 232       5.712   4.589  16.311  1.00  0.00           H  
ATOM     59  N   GLY A 233       1.273   4.417  13.224  1.00  0.00           N  
ATOM     60  CA  GLY A 233      -0.136   4.078  13.130  1.00  0.00           C  
ATOM     61  C   GLY A 233      -0.524   2.947  14.061  1.00  0.00           C  
ATOM     62  O   GLY A 233       0.207   2.630  14.999  1.00  0.00           O  
ATOM     63  H   GLY A 233       1.859   4.283  12.450  1.00  0.00           H  
ATOM     64  HA2 GLY A 233      -0.722   4.951  13.376  1.00  0.00           H  
ATOM     65  HA3 GLY A 233      -0.356   3.784  12.114  1.00  0.00           H  
ATOM     66  N   GLU A 234      -1.677   2.339  13.803  1.00  0.00           N  
ATOM     67  CA  GLU A 234      -2.161   1.238  14.628  1.00  0.00           C  
ATOM     68  C   GLU A 234      -2.101  -0.081  13.864  1.00  0.00           C  
ATOM     69  O   GLU A 234      -3.025  -0.892  13.930  1.00  0.00           O  
ATOM     70  CB  GLU A 234      -3.595   1.509  15.087  1.00  0.00           C  
ATOM     71  CG  GLU A 234      -3.945   0.848  16.411  1.00  0.00           C  
ATOM     72  CD  GLU A 234      -5.442   0.744  16.633  1.00  0.00           C  
ATOM     73  OE1 GLU A 234      -6.194   0.768  15.636  1.00  0.00           O  
ATOM     74  OE2 GLU A 234      -5.860   0.637  17.804  1.00  0.00           O  
ATOM     75  H   GLU A 234      -2.215   2.637  13.040  1.00  0.00           H  
ATOM     76  HA  GLU A 234      -1.523   1.167  15.495  1.00  0.00           H  
ATOM     77  HB2 GLU A 234      -3.732   2.575  15.193  1.00  0.00           H  
ATOM     78  HB3 GLU A 234      -4.277   1.141  14.334  1.00  0.00           H  
ATOM     79  HG2 GLU A 234      -3.525  -0.146  16.425  1.00  0.00           H  
ATOM     80  HG3 GLU A 234      -3.517   1.430  17.213  1.00  0.00           H  
ATOM     81  N   ASP A 235      -1.007  -0.290  13.140  1.00  0.00           N  
ATOM     82  CA  ASP A 235      -0.824  -1.511  12.363  1.00  0.00           C  
ATOM     83  C   ASP A 235       0.342  -2.329  12.905  1.00  0.00           C  
ATOM     84  O   ASP A 235       1.505  -2.033  12.627  1.00  0.00           O  
ATOM     85  CB  ASP A 235      -0.587  -1.173  10.890  1.00  0.00           C  
ATOM     86  CG  ASP A 235       0.646  -0.316  10.684  1.00  0.00           C  
ATOM     87  OD1 ASP A 235       0.681   0.812  11.220  1.00  0.00           O  
ATOM     88  OD2 ASP A 235       1.577  -0.772   9.988  1.00  0.00           O  
ATOM     89  H   ASP A 235      -0.305   0.394  13.127  1.00  0.00           H  
ATOM     90  HA  ASP A 235      -1.728  -2.095  12.448  1.00  0.00           H  
ATOM     91  HB2 ASP A 235      -0.463  -2.090  10.333  1.00  0.00           H  
ATOM     92  HB3 ASP A 235      -1.444  -0.638  10.508  1.00  0.00           H  
ATOM     93  N   LYS A 236       0.026  -3.360  13.680  1.00  0.00           N  
ATOM     94  CA  LYS A 236       1.047  -4.223  14.262  1.00  0.00           C  
ATOM     95  C   LYS A 236       1.309  -5.433  13.372  1.00  0.00           C  
ATOM     96  O   LYS A 236       2.390  -5.573  12.798  1.00  0.00           O  
ATOM     97  CB  LYS A 236       0.619  -4.687  15.657  1.00  0.00           C  
ATOM     98  CG  LYS A 236       0.373  -3.545  16.628  1.00  0.00           C  
ATOM     99  CD  LYS A 236      -1.085  -3.116  16.627  1.00  0.00           C  
ATOM    100  CE  LYS A 236      -1.908  -3.935  17.609  1.00  0.00           C  
ATOM    101  NZ  LYS A 236      -3.120  -3.200  18.066  1.00  0.00           N  
ATOM    102  H   LYS A 236      -0.919  -3.547  13.866  1.00  0.00           H  
ATOM    103  HA  LYS A 236       1.957  -3.650  14.347  1.00  0.00           H  
ATOM    104  HB2 LYS A 236      -0.293  -5.260  15.568  1.00  0.00           H  
ATOM    105  HB3 LYS A 236       1.393  -5.320  16.066  1.00  0.00           H  
ATOM    106  HG2 LYS A 236       0.641  -3.867  17.623  1.00  0.00           H  
ATOM    107  HG3 LYS A 236       0.988  -2.703  16.343  1.00  0.00           H  
ATOM    108  HD2 LYS A 236      -1.144  -2.075  16.906  1.00  0.00           H  
ATOM    109  HD3 LYS A 236      -1.488  -3.248  15.633  1.00  0.00           H  
ATOM    110  HE2 LYS A 236      -2.214  -4.851  17.125  1.00  0.00           H  
ATOM    111  HE3 LYS A 236      -1.294  -4.169  18.466  1.00  0.00           H  
ATOM    112  HZ1 LYS A 236      -3.060  -3.012  19.087  1.00  0.00           H  
ATOM    113  HZ2 LYS A 236      -3.973  -3.763  17.876  1.00  0.00           H  
ATOM    114  HZ3 LYS A 236      -3.198  -2.293  17.563  1.00  0.00           H  
ATOM    115  N   THR A 237       0.313  -6.306  13.257  1.00  0.00           N  
ATOM    116  CA  THR A 237       0.435  -7.503  12.436  1.00  0.00           C  
ATOM    117  C   THR A 237      -0.628  -7.532  11.344  1.00  0.00           C  
ATOM    118  O   THR A 237      -1.054  -8.603  10.908  1.00  0.00           O  
ATOM    119  CB  THR A 237       0.317  -8.783  13.287  1.00  0.00           C  
ATOM    120  OG1 THR A 237      -0.972  -8.839  13.909  1.00  0.00           O  
ATOM    121  CG2 THR A 237       1.403  -8.828  14.351  1.00  0.00           C  
ATOM    122  H   THR A 237      -0.525  -6.139  13.739  1.00  0.00           H  
ATOM    123  HA  THR A 237       1.412  -7.493  11.974  1.00  0.00           H  
ATOM    124  HB  THR A 237       0.433  -9.639  12.638  1.00  0.00           H  
ATOM    125  HG1 THR A 237      -1.156  -8.001  14.339  1.00  0.00           H  
ATOM    126 HG21 THR A 237       1.522  -7.846  14.784  1.00  0.00           H  
ATOM    127 HG22 THR A 237       2.335  -9.138  13.902  1.00  0.00           H  
ATOM    128 HG23 THR A 237       1.122  -9.529  15.122  1.00  0.00           H  
ATOM    129  N   ILE A 238      -1.051  -6.352  10.906  1.00  0.00           N  
ATOM    130  CA  ILE A 238      -2.063  -6.243   9.863  1.00  0.00           C  
ATOM    131  C   ILE A 238      -1.441  -6.374   8.476  1.00  0.00           C  
ATOM    132  O   ILE A 238      -0.503  -5.654   8.134  1.00  0.00           O  
ATOM    133  CB  ILE A 238      -2.819  -4.904   9.949  1.00  0.00           C  
ATOM    134  CG1 ILE A 238      -3.412  -4.717  11.347  1.00  0.00           C  
ATOM    135  CG2 ILE A 238      -3.912  -4.843   8.892  1.00  0.00           C  
ATOM    136  CD1 ILE A 238      -4.107  -3.387  11.536  1.00  0.00           C  
ATOM    137  H   ILE A 238      -0.673  -5.535  11.292  1.00  0.00           H  
ATOM    138  HA  ILE A 238      -2.774  -7.044  10.004  1.00  0.00           H  
ATOM    139  HB  ILE A 238      -2.117  -4.107   9.754  1.00  0.00           H  
ATOM    140 HG12 ILE A 238      -4.134  -5.497  11.533  1.00  0.00           H  
ATOM    141 HG13 ILE A 238      -2.619  -4.784  12.078  1.00  0.00           H  
ATOM    142 HG21 ILE A 238      -4.241  -3.821   8.774  1.00  0.00           H  
ATOM    143 HG22 ILE A 238      -3.523  -5.206   7.952  1.00  0.00           H  
ATOM    144 HG23 ILE A 238      -4.744  -5.457   9.199  1.00  0.00           H  
ATOM    145 HD11 ILE A 238      -4.100  -2.842  10.603  1.00  0.00           H  
ATOM    146 HD12 ILE A 238      -5.128  -3.554  11.846  1.00  0.00           H  
ATOM    147 HD13 ILE A 238      -3.590  -2.814  12.291  1.00  0.00           H  
ATOM    148  N   THR A 239      -1.971  -7.299   7.681  1.00  0.00           N  
ATOM    149  CA  THR A 239      -1.468  -7.525   6.332  1.00  0.00           C  
ATOM    150  C   THR A 239      -2.384  -6.893   5.291  1.00  0.00           C  
ATOM    151  O   THR A 239      -2.028  -6.786   4.117  1.00  0.00           O  
ATOM    152  CB  THR A 239      -1.328  -9.029   6.030  1.00  0.00           C  
ATOM    153  OG1 THR A 239      -2.605  -9.670   6.128  1.00  0.00           O  
ATOM    154  CG2 THR A 239      -0.349  -9.686   6.992  1.00  0.00           C  
ATOM    155  H   THR A 239      -2.716  -7.842   8.012  1.00  0.00           H  
ATOM    156  HA  THR A 239      -0.490  -7.072   6.260  1.00  0.00           H  
ATOM    157  HB  THR A 239      -0.952  -9.144   5.022  1.00  0.00           H  
ATOM    158  HG1 THR A 239      -2.922  -9.614   7.033  1.00  0.00           H  
ATOM    159 HG21 THR A 239      -0.002  -8.954   7.706  1.00  0.00           H  
ATOM    160 HG22 THR A 239       0.493 -10.076   6.439  1.00  0.00           H  
ATOM    161 HG23 THR A 239      -0.843 -10.492   7.512  1.00  0.00           H  
ATOM    162  N   THR A 240      -3.568  -6.472   5.728  1.00  0.00           N  
ATOM    163  CA  THR A 240      -4.536  -5.850   4.834  1.00  0.00           C  
ATOM    164  C   THR A 240      -4.264  -4.357   4.681  1.00  0.00           C  
ATOM    165  O   THR A 240      -3.890  -3.682   5.642  1.00  0.00           O  
ATOM    166  CB  THR A 240      -5.978  -6.047   5.341  1.00  0.00           C  
ATOM    167  OG1 THR A 240      -6.193  -7.421   5.679  1.00  0.00           O  
ATOM    168  CG2 THR A 240      -6.986  -5.615   4.287  1.00  0.00           C  
ATOM    169  H   THR A 240      -3.794  -6.584   6.675  1.00  0.00           H  
ATOM    170  HA  THR A 240      -4.449  -6.322   3.866  1.00  0.00           H  
ATOM    171  HB  THR A 240      -6.119  -5.440   6.223  1.00  0.00           H  
ATOM    172  HG1 THR A 240      -5.995  -7.974   4.919  1.00  0.00           H  
ATOM    173 HG21 THR A 240      -7.182  -6.439   3.618  1.00  0.00           H  
ATOM    174 HG22 THR A 240      -6.586  -4.784   3.726  1.00  0.00           H  
ATOM    175 HG23 THR A 240      -7.903  -5.315   4.769  1.00  0.00           H  
ATOM    176  N   LEU A 241      -4.453  -3.848   3.468  1.00  0.00           N  
ATOM    177  CA  LEU A 241      -4.227  -2.434   3.190  1.00  0.00           C  
ATOM    178  C   LEU A 241      -5.415  -1.830   2.446  1.00  0.00           C  
ATOM    179  O   LEU A 241      -5.809  -2.317   1.387  1.00  0.00           O  
ATOM    180  CB  LEU A 241      -2.950  -2.253   2.369  1.00  0.00           C  
ATOM    181  CG  LEU A 241      -1.637  -2.297   3.150  1.00  0.00           C  
ATOM    182  CD1 LEU A 241      -0.472  -2.597   2.221  1.00  0.00           C  
ATOM    183  CD2 LEU A 241      -1.410  -0.985   3.887  1.00  0.00           C  
ATOM    184  H   LEU A 241      -4.750  -4.435   2.744  1.00  0.00           H  
ATOM    185  HA  LEU A 241      -4.113  -1.923   4.135  1.00  0.00           H  
ATOM    186  HB2 LEU A 241      -2.920  -3.035   1.627  1.00  0.00           H  
ATOM    187  HB3 LEU A 241      -3.009  -1.293   1.874  1.00  0.00           H  
ATOM    188  HG  LEU A 241      -1.689  -3.089   3.885  1.00  0.00           H  
ATOM    189 HD11 LEU A 241      -0.618  -3.561   1.759  1.00  0.00           H  
ATOM    190 HD12 LEU A 241       0.448  -2.604   2.787  1.00  0.00           H  
ATOM    191 HD13 LEU A 241      -0.416  -1.835   1.456  1.00  0.00           H  
ATOM    192 HD21 LEU A 241      -2.043  -0.220   3.463  1.00  0.00           H  
ATOM    193 HD22 LEU A 241      -0.375  -0.692   3.788  1.00  0.00           H  
ATOM    194 HD23 LEU A 241      -1.649  -1.113   4.933  1.00  0.00           H  
ATOM    195  N   TYR A 242      -5.977  -0.765   3.007  1.00  0.00           N  
ATOM    196  CA  TYR A 242      -7.119  -0.094   2.397  1.00  0.00           C  
ATOM    197  C   TYR A 242      -6.666   0.859   1.294  1.00  0.00           C  
ATOM    198  O   TYR A 242      -5.643   1.532   1.420  1.00  0.00           O  
ATOM    199  CB  TYR A 242      -7.912   0.673   3.455  1.00  0.00           C  
ATOM    200  CG  TYR A 242      -8.675   1.855   2.902  1.00  0.00           C  
ATOM    201  CD1 TYR A 242      -8.013   3.007   2.495  1.00  0.00           C  
ATOM    202  CD2 TYR A 242     -10.060   1.820   2.785  1.00  0.00           C  
ATOM    203  CE1 TYR A 242      -8.706   4.089   1.989  1.00  0.00           C  
ATOM    204  CE2 TYR A 242     -10.761   2.897   2.280  1.00  0.00           C  
ATOM    205  CZ  TYR A 242     -10.081   4.029   1.884  1.00  0.00           C  
ATOM    206  OH  TYR A 242     -10.776   5.105   1.378  1.00  0.00           O  
ATOM    207  H   TYR A 242      -5.617  -0.423   3.852  1.00  0.00           H  
ATOM    208  HA  TYR A 242      -7.756  -0.851   1.963  1.00  0.00           H  
ATOM    209  HB2 TYR A 242      -8.624   0.006   3.916  1.00  0.00           H  
ATOM    210  HB3 TYR A 242      -7.231   1.042   4.209  1.00  0.00           H  
ATOM    211  HD1 TYR A 242      -6.936   3.050   2.578  1.00  0.00           H  
ATOM    212  HD2 TYR A 242     -10.590   0.932   3.096  1.00  0.00           H  
ATOM    213  HE1 TYR A 242      -8.173   4.976   1.678  1.00  0.00           H  
ATOM    214  HE2 TYR A 242     -11.837   2.851   2.196  1.00  0.00           H  
ATOM    215  HH  TYR A 242     -10.168   5.695   0.928  1.00  0.00           H  
ATOM    216  N   VAL A 243      -7.436   0.910   0.212  1.00  0.00           N  
ATOM    217  CA  VAL A 243      -7.116   1.780  -0.913  1.00  0.00           C  
ATOM    218  C   VAL A 243      -8.361   2.499  -1.423  1.00  0.00           C  
ATOM    219  O   VAL A 243      -9.306   1.867  -1.895  1.00  0.00           O  
ATOM    220  CB  VAL A 243      -6.483   0.989  -2.073  1.00  0.00           C  
ATOM    221  CG1 VAL A 243      -6.192   1.907  -3.250  1.00  0.00           C  
ATOM    222  CG2 VAL A 243      -5.216   0.287  -1.608  1.00  0.00           C  
ATOM    223  H   VAL A 243      -8.238   0.349   0.169  1.00  0.00           H  
ATOM    224  HA  VAL A 243      -6.402   2.516  -0.575  1.00  0.00           H  
ATOM    225  HB  VAL A 243      -7.188   0.238  -2.397  1.00  0.00           H  
ATOM    226 HG11 VAL A 243      -7.122   2.283  -3.651  1.00  0.00           H  
ATOM    227 HG12 VAL A 243      -5.581   2.735  -2.919  1.00  0.00           H  
ATOM    228 HG13 VAL A 243      -5.667   1.356  -4.016  1.00  0.00           H  
ATOM    229 HG21 VAL A 243      -4.984   0.592  -0.600  1.00  0.00           H  
ATOM    230 HG22 VAL A 243      -5.368  -0.782  -1.637  1.00  0.00           H  
ATOM    231 HG23 VAL A 243      -4.397   0.551  -2.262  1.00  0.00           H  
ATOM    232  N   GLY A 244      -8.355   3.825  -1.324  1.00  0.00           N  
ATOM    233  CA  GLY A 244      -9.488   4.608  -1.780  1.00  0.00           C  
ATOM    234  C   GLY A 244      -9.175   5.410  -3.026  1.00  0.00           C  
ATOM    235  O   GLY A 244      -8.046   5.396  -3.515  1.00  0.00           O  
ATOM    236  H   GLY A 244      -7.574   4.274  -0.938  1.00  0.00           H  
ATOM    237  HA2 GLY A 244     -10.312   3.941  -1.991  1.00  0.00           H  
ATOM    238  HA3 GLY A 244      -9.782   5.287  -0.992  1.00  0.00           H  
ATOM    239  N   GLY A 245     -10.178   6.115  -3.543  1.00  0.00           N  
ATOM    240  CA  GLY A 245      -9.984   6.916  -4.736  1.00  0.00           C  
ATOM    241  C   GLY A 245      -9.758   6.069  -5.973  1.00  0.00           C  
ATOM    242  O   GLY A 245      -8.954   6.421  -6.838  1.00  0.00           O  
ATOM    243  H   GLY A 245     -11.058   6.088  -3.110  1.00  0.00           H  
ATOM    244  HA2 GLY A 245     -10.858   7.532  -4.890  1.00  0.00           H  
ATOM    245  HA3 GLY A 245      -9.127   7.556  -4.591  1.00  0.00           H  
ATOM    246  N   LEU A 246     -10.466   4.948  -6.059  1.00  0.00           N  
ATOM    247  CA  LEU A 246     -10.337   4.046  -7.198  1.00  0.00           C  
ATOM    248  C   LEU A 246     -11.058   4.607  -8.420  1.00  0.00           C  
ATOM    249  O   LEU A 246     -10.446   4.843  -9.460  1.00  0.00           O  
ATOM    250  CB  LEU A 246     -10.898   2.667  -6.849  1.00  0.00           C  
ATOM    251  CG  LEU A 246     -10.113   1.867  -5.809  1.00  0.00           C  
ATOM    252  CD1 LEU A 246     -10.651   0.448  -5.709  1.00  0.00           C  
ATOM    253  CD2 LEU A 246      -8.631   1.855  -6.153  1.00  0.00           C  
ATOM    254  H   LEU A 246     -11.090   4.721  -5.339  1.00  0.00           H  
ATOM    255  HA  LEU A 246      -9.286   3.951  -7.428  1.00  0.00           H  
ATOM    256  HB2 LEU A 246     -11.901   2.804  -6.472  1.00  0.00           H  
ATOM    257  HB3 LEU A 246     -10.933   2.085  -7.758  1.00  0.00           H  
ATOM    258  HG  LEU A 246     -10.229   2.335  -4.841  1.00  0.00           H  
ATOM    259 HD11 LEU A 246     -10.964   0.112  -6.687  1.00  0.00           H  
ATOM    260 HD12 LEU A 246     -11.494   0.429  -5.035  1.00  0.00           H  
ATOM    261 HD13 LEU A 246      -9.877  -0.205  -5.336  1.00  0.00           H  
ATOM    262 HD21 LEU A 246      -8.112   2.573  -5.536  1.00  0.00           H  
ATOM    263 HD22 LEU A 246      -8.502   2.114  -7.194  1.00  0.00           H  
ATOM    264 HD23 LEU A 246      -8.228   0.868  -5.974  1.00  0.00           H  
ATOM    265  N   GLY A 247     -12.364   4.819  -8.285  1.00  0.00           N  
ATOM    266  CA  GLY A 247     -13.147   5.351  -9.385  1.00  0.00           C  
ATOM    267  C   GLY A 247     -13.194   4.411 -10.571  1.00  0.00           C  
ATOM    268  O   GLY A 247     -12.256   3.649 -10.806  1.00  0.00           O  
ATOM    269  H   GLY A 247     -12.799   4.611  -7.432  1.00  0.00           H  
ATOM    270  HA2 GLY A 247     -14.155   5.532  -9.040  1.00  0.00           H  
ATOM    271  HA3 GLY A 247     -12.712   6.288  -9.700  1.00  0.00           H  
ATOM    272  N   ASP A 248     -14.290   4.461 -11.321  1.00  0.00           N  
ATOM    273  CA  ASP A 248     -14.457   3.606 -12.490  1.00  0.00           C  
ATOM    274  C   ASP A 248     -13.156   3.505 -13.281  1.00  0.00           C  
ATOM    275  O   ASP A 248     -12.825   2.450 -13.822  1.00  0.00           O  
ATOM    276  CB  ASP A 248     -15.573   4.144 -13.388  1.00  0.00           C  
ATOM    277  CG  ASP A 248     -16.929   4.107 -12.711  1.00  0.00           C  
ATOM    278  OD1 ASP A 248     -17.224   5.029 -11.924  1.00  0.00           O  
ATOM    279  OD2 ASP A 248     -17.694   3.154 -12.968  1.00  0.00           O  
ATOM    280  H   ASP A 248     -15.004   5.090 -11.082  1.00  0.00           H  
ATOM    281  HA  ASP A 248     -14.730   2.621 -12.144  1.00  0.00           H  
ATOM    282  HB2 ASP A 248     -15.352   5.168 -13.651  1.00  0.00           H  
ATOM    283  HB3 ASP A 248     -15.622   3.548 -14.286  1.00  0.00           H  
ATOM    284  N   THR A 249     -12.420   4.611 -13.343  1.00  0.00           N  
ATOM    285  CA  THR A 249     -11.157   4.649 -14.068  1.00  0.00           C  
ATOM    286  C   THR A 249     -10.239   3.511 -13.634  1.00  0.00           C  
ATOM    287  O   THR A 249      -9.604   2.863 -14.465  1.00  0.00           O  
ATOM    288  CB  THR A 249     -10.428   5.989 -13.859  1.00  0.00           C  
ATOM    289  OG1 THR A 249     -10.360   6.296 -12.461  1.00  0.00           O  
ATOM    290  CG2 THR A 249     -11.140   7.113 -14.595  1.00  0.00           C  
ATOM    291  H   THR A 249     -12.737   5.421 -12.890  1.00  0.00           H  
ATOM    292  HA  THR A 249     -11.373   4.542 -15.121  1.00  0.00           H  
ATOM    293  HB  THR A 249      -9.425   5.902 -14.249  1.00  0.00           H  
ATOM    294  HG1 THR A 249     -11.105   5.895 -12.008  1.00  0.00           H  
ATOM    295 HG21 THR A 249     -11.142   6.905 -15.654  1.00  0.00           H  
ATOM    296 HG22 THR A 249     -10.627   8.046 -14.413  1.00  0.00           H  
ATOM    297 HG23 THR A 249     -12.158   7.188 -14.242  1.00  0.00           H  
ATOM    298  N   ILE A 250     -10.176   3.274 -12.327  1.00  0.00           N  
ATOM    299  CA  ILE A 250      -9.338   2.213 -11.784  1.00  0.00           C  
ATOM    300  C   ILE A 250     -10.149   0.948 -11.530  1.00  0.00           C  
ATOM    301  O   ILE A 250     -11.307   1.011 -11.116  1.00  0.00           O  
ATOM    302  CB  ILE A 250      -8.660   2.649 -10.470  1.00  0.00           C  
ATOM    303  CG1 ILE A 250      -7.827   3.911 -10.695  1.00  0.00           C  
ATOM    304  CG2 ILE A 250      -7.792   1.524  -9.925  1.00  0.00           C  
ATOM    305  CD1 ILE A 250      -7.290   4.516  -9.417  1.00  0.00           C  
ATOM    306  H   ILE A 250     -10.707   3.825 -11.716  1.00  0.00           H  
ATOM    307  HA  ILE A 250      -8.566   1.995 -12.508  1.00  0.00           H  
ATOM    308  HB  ILE A 250      -9.432   2.859  -9.746  1.00  0.00           H  
ATOM    309 HG12 ILE A 250      -6.987   3.673 -11.327  1.00  0.00           H  
ATOM    310 HG13 ILE A 250      -8.440   4.656 -11.183  1.00  0.00           H  
ATOM    311 HG21 ILE A 250      -6.837   1.924  -9.618  1.00  0.00           H  
ATOM    312 HG22 ILE A 250      -8.282   1.072  -9.075  1.00  0.00           H  
ATOM    313 HG23 ILE A 250      -7.642   0.781 -10.692  1.00  0.00           H  
ATOM    314 HD11 ILE A 250      -8.027   5.188  -8.999  1.00  0.00           H  
ATOM    315 HD12 ILE A 250      -7.078   3.730  -8.707  1.00  0.00           H  
ATOM    316 HD13 ILE A 250      -6.385   5.065  -9.630  1.00  0.00           H  
ATOM    317  N   THR A 251      -9.532  -0.204 -11.777  1.00  0.00           N  
ATOM    318  CA  THR A 251     -10.196  -1.485 -11.576  1.00  0.00           C  
ATOM    319  C   THR A 251      -9.427  -2.352 -10.584  1.00  0.00           C  
ATOM    320  O   THR A 251      -8.405  -1.933 -10.043  1.00  0.00           O  
ATOM    321  CB  THR A 251     -10.348  -2.255 -12.901  1.00  0.00           C  
ATOM    322  OG1 THR A 251      -9.066  -2.687 -13.367  1.00  0.00           O  
ATOM    323  CG2 THR A 251     -11.011  -1.385 -13.958  1.00  0.00           C  
ATOM    324  H   THR A 251      -8.609  -0.189 -12.105  1.00  0.00           H  
ATOM    325  HA  THR A 251     -11.182  -1.291 -11.180  1.00  0.00           H  
ATOM    326  HB  THR A 251     -10.970  -3.121 -12.727  1.00  0.00           H  
ATOM    327  HG1 THR A 251      -8.752  -3.411 -12.819  1.00  0.00           H  
ATOM    328 HG21 THR A 251     -10.311  -0.637 -14.299  1.00  0.00           H  
ATOM    329 HG22 THR A 251     -11.877  -0.899 -13.534  1.00  0.00           H  
ATOM    330 HG23 THR A 251     -11.315  -2.000 -14.792  1.00  0.00           H  
ATOM    331  N   GLU A 252      -9.926  -3.562 -10.351  1.00  0.00           N  
ATOM    332  CA  GLU A 252      -9.285  -4.487  -9.424  1.00  0.00           C  
ATOM    333  C   GLU A 252      -7.952  -4.978  -9.980  1.00  0.00           C  
ATOM    334  O   GLU A 252      -6.907  -4.829  -9.344  1.00  0.00           O  
ATOM    335  CB  GLU A 252     -10.202  -5.679  -9.142  1.00  0.00           C  
ATOM    336  CG  GLU A 252      -9.643  -6.646  -8.112  1.00  0.00           C  
ATOM    337  CD  GLU A 252     -10.656  -7.689  -7.682  1.00  0.00           C  
ATOM    338  OE1 GLU A 252     -11.701  -7.303  -7.115  1.00  0.00           O  
ATOM    339  OE2 GLU A 252     -10.405  -8.891  -7.912  1.00  0.00           O  
ATOM    340  H   GLU A 252     -10.745  -3.839 -10.813  1.00  0.00           H  
ATOM    341  HA  GLU A 252      -9.103  -3.958  -8.501  1.00  0.00           H  
ATOM    342  HB2 GLU A 252     -11.151  -5.310  -8.783  1.00  0.00           H  
ATOM    343  HB3 GLU A 252     -10.362  -6.220 -10.063  1.00  0.00           H  
ATOM    344  HG2 GLU A 252      -8.788  -7.150  -8.536  1.00  0.00           H  
ATOM    345  HG3 GLU A 252      -9.334  -6.086  -7.241  1.00  0.00           H  
ATOM    346  N   THR A 253      -7.994  -5.566 -11.172  1.00  0.00           N  
ATOM    347  CA  THR A 253      -6.792  -6.080 -11.814  1.00  0.00           C  
ATOM    348  C   THR A 253      -5.637  -5.091 -11.693  1.00  0.00           C  
ATOM    349  O   THR A 253      -4.538  -5.455 -11.275  1.00  0.00           O  
ATOM    350  CB  THR A 253      -7.036  -6.386 -13.304  1.00  0.00           C  
ATOM    351  OG1 THR A 253      -8.083  -7.353 -13.440  1.00  0.00           O  
ATOM    352  CG2 THR A 253      -5.769  -6.904 -13.966  1.00  0.00           C  
ATOM    353  H   THR A 253      -8.856  -5.654 -11.630  1.00  0.00           H  
ATOM    354  HA  THR A 253      -6.517  -7.001 -11.320  1.00  0.00           H  
ATOM    355  HB  THR A 253      -7.334  -5.471 -13.799  1.00  0.00           H  
ATOM    356  HG1 THR A 253      -7.891  -7.929 -14.184  1.00  0.00           H  
ATOM    357 HG21 THR A 253      -5.970  -7.127 -15.003  1.00  0.00           H  
ATOM    358 HG22 THR A 253      -5.441  -7.803 -13.462  1.00  0.00           H  
ATOM    359 HG23 THR A 253      -4.996  -6.153 -13.902  1.00  0.00           H  
ATOM    360  N   ASP A 254      -5.895  -3.841 -12.060  1.00  0.00           N  
ATOM    361  CA  ASP A 254      -4.877  -2.799 -11.990  1.00  0.00           C  
ATOM    362  C   ASP A 254      -4.169  -2.820 -10.639  1.00  0.00           C  
ATOM    363  O   ASP A 254      -2.960  -2.595 -10.556  1.00  0.00           O  
ATOM    364  CB  ASP A 254      -5.506  -1.425 -12.229  1.00  0.00           C  
ATOM    365  CG  ASP A 254      -5.514  -1.039 -13.694  1.00  0.00           C  
ATOM    366  OD1 ASP A 254      -4.541  -1.375 -14.402  1.00  0.00           O  
ATOM    367  OD2 ASP A 254      -6.492  -0.399 -14.135  1.00  0.00           O  
ATOM    368  H   ASP A 254      -6.791  -3.613 -12.385  1.00  0.00           H  
ATOM    369  HA  ASP A 254      -4.152  -2.992 -12.765  1.00  0.00           H  
ATOM    370  HB2 ASP A 254      -6.527  -1.437 -11.873  1.00  0.00           H  
ATOM    371  HB3 ASP A 254      -4.948  -0.681 -11.680  1.00  0.00           H  
ATOM    372  N   LEU A 255      -4.929  -3.091  -9.583  1.00  0.00           N  
ATOM    373  CA  LEU A 255      -4.374  -3.139  -8.235  1.00  0.00           C  
ATOM    374  C   LEU A 255      -3.688  -4.478  -7.977  1.00  0.00           C  
ATOM    375  O   LEU A 255      -2.532  -4.523  -7.559  1.00  0.00           O  
ATOM    376  CB  LEU A 255      -5.478  -2.911  -7.200  1.00  0.00           C  
ATOM    377  CG  LEU A 255      -6.400  -1.720  -7.455  1.00  0.00           C  
ATOM    378  CD1 LEU A 255      -7.608  -1.772  -6.532  1.00  0.00           C  
ATOM    379  CD2 LEU A 255      -5.645  -0.412  -7.271  1.00  0.00           C  
ATOM    380  H   LEU A 255      -5.884  -3.261  -9.713  1.00  0.00           H  
ATOM    381  HA  LEU A 255      -3.642  -2.351  -8.148  1.00  0.00           H  
ATOM    382  HB2 LEU A 255      -6.088  -3.801  -7.166  1.00  0.00           H  
ATOM    383  HB3 LEU A 255      -5.004  -2.765  -6.240  1.00  0.00           H  
ATOM    384  HG  LEU A 255      -6.758  -1.760  -8.474  1.00  0.00           H  
ATOM    385 HD11 LEU A 255      -7.495  -1.039  -5.749  1.00  0.00           H  
ATOM    386 HD12 LEU A 255      -7.684  -2.758  -6.096  1.00  0.00           H  
ATOM    387 HD13 LEU A 255      -8.503  -1.560  -7.099  1.00  0.00           H  
ATOM    388 HD21 LEU A 255      -5.274  -0.073  -8.228  1.00  0.00           H  
ATOM    389 HD22 LEU A 255      -4.815  -0.567  -6.598  1.00  0.00           H  
ATOM    390 HD23 LEU A 255      -6.309   0.334  -6.858  1.00  0.00           H  
ATOM    391  N   ARG A 256      -4.409  -5.565  -8.230  1.00  0.00           N  
ATOM    392  CA  ARG A 256      -3.870  -6.904  -8.026  1.00  0.00           C  
ATOM    393  C   ARG A 256      -2.444  -7.003  -8.562  1.00  0.00           C  
ATOM    394  O   ARG A 256      -1.570  -7.586  -7.922  1.00  0.00           O  
ATOM    395  CB  ARG A 256      -4.757  -7.944  -8.713  1.00  0.00           C  
ATOM    396  CG  ARG A 256      -4.297  -9.377  -8.493  1.00  0.00           C  
ATOM    397  CD  ARG A 256      -5.467 -10.348  -8.525  1.00  0.00           C  
ATOM    398  NE  ARG A 256      -5.045 -11.721  -8.269  1.00  0.00           N  
ATOM    399  CZ  ARG A 256      -4.567 -12.532  -9.207  1.00  0.00           C  
ATOM    400  NH1 ARG A 256      -4.452 -12.107 -10.458  1.00  0.00           N  
ATOM    401  NH2 ARG A 256      -4.204 -13.769  -8.895  1.00  0.00           N  
ATOM    402  H   ARG A 256      -5.326  -5.465  -8.562  1.00  0.00           H  
ATOM    403  HA  ARG A 256      -3.858  -7.099  -6.964  1.00  0.00           H  
ATOM    404  HB2 ARG A 256      -5.764  -7.850  -8.331  1.00  0.00           H  
ATOM    405  HB3 ARG A 256      -4.764  -7.750  -9.775  1.00  0.00           H  
ATOM    406  HG2 ARG A 256      -3.601  -9.645  -9.274  1.00  0.00           H  
ATOM    407  HG3 ARG A 256      -3.810  -9.445  -7.533  1.00  0.00           H  
ATOM    408  HD2 ARG A 256      -6.182 -10.054  -7.772  1.00  0.00           H  
ATOM    409  HD3 ARG A 256      -5.931 -10.299  -9.499  1.00  0.00           H  
ATOM    410  HE  ARG A 256      -5.122 -12.056  -7.351  1.00  0.00           H  
ATOM    411 HH11 ARG A 256      -4.724 -11.174 -10.695  1.00  0.00           H  
ATOM    412 HH12 ARG A 256      -4.091 -12.718 -11.163  1.00  0.00           H  
ATOM    413 HH21 ARG A 256      -4.289 -14.093  -7.954  1.00  0.00           H  
ATOM    414 HH22 ARG A 256      -3.845 -14.378  -9.602  1.00  0.00           H  
ATOM    415  N   ASN A 257      -2.219  -6.430  -9.740  1.00  0.00           N  
ATOM    416  CA  ASN A 257      -0.900  -6.455 -10.362  1.00  0.00           C  
ATOM    417  C   ASN A 257       0.034  -5.449  -9.697  1.00  0.00           C  
ATOM    418  O   ASN A 257       1.193  -5.754  -9.414  1.00  0.00           O  
ATOM    419  CB  ASN A 257      -1.013  -6.153 -11.857  1.00  0.00           C  
ATOM    420  CG  ASN A 257      -1.335  -7.390 -12.675  1.00  0.00           C  
ATOM    421  OD1 ASN A 257      -0.543  -8.331 -12.734  1.00  0.00           O  
ATOM    422  ND2 ASN A 257      -2.501  -7.393 -13.309  1.00  0.00           N  
ATOM    423  H   ASN A 257      -2.957  -5.981 -10.202  1.00  0.00           H  
ATOM    424  HA  ASN A 257      -0.492  -7.447 -10.234  1.00  0.00           H  
ATOM    425  HB2 ASN A 257      -1.799  -5.428 -12.014  1.00  0.00           H  
ATOM    426  HB3 ASN A 257      -0.077  -5.745 -12.208  1.00  0.00           H  
ATOM    427 HD21 ASN A 257      -3.080  -6.608 -13.217  1.00  0.00           H  
ATOM    428 HD22 ASN A 257      -2.734  -8.180 -13.845  1.00  0.00           H  
ATOM    429  N   HIS A 258      -0.479  -4.248  -9.451  1.00  0.00           N  
ATOM    430  CA  HIS A 258       0.309  -3.195  -8.818  1.00  0.00           C  
ATOM    431  C   HIS A 258       0.842  -3.655  -7.464  1.00  0.00           C  
ATOM    432  O   HIS A 258       1.933  -3.264  -7.050  1.00  0.00           O  
ATOM    433  CB  HIS A 258      -0.536  -1.932  -8.644  1.00  0.00           C  
ATOM    434  CG  HIS A 258       0.279  -0.685  -8.486  1.00  0.00           C  
ATOM    435  ND1 HIS A 258       0.979  -0.383  -7.336  1.00  0.00           N  
ATOM    436  CD2 HIS A 258       0.505   0.339  -9.342  1.00  0.00           C  
ATOM    437  CE1 HIS A 258       1.598   0.774  -7.492  1.00  0.00           C  
ATOM    438  NE2 HIS A 258       1.326   1.233  -8.701  1.00  0.00           N  
ATOM    439  H   HIS A 258      -1.408  -4.065  -9.699  1.00  0.00           H  
ATOM    440  HA  HIS A 258       1.144  -2.973  -9.463  1.00  0.00           H  
ATOM    441  HB2 HIS A 258      -1.168  -1.808  -9.510  1.00  0.00           H  
ATOM    442  HB3 HIS A 258      -1.154  -2.038  -7.764  1.00  0.00           H  
ATOM    443  HD1 HIS A 258       1.015  -0.934  -6.527  1.00  0.00           H  
ATOM    444  HD2 HIS A 258       0.111   0.437 -10.344  1.00  0.00           H  
ATOM    445  HE1 HIS A 258       2.219   1.262  -6.757  1.00  0.00           H  
ATOM    446  N   PHE A 259       0.066  -4.489  -6.780  1.00  0.00           N  
ATOM    447  CA  PHE A 259       0.459  -5.001  -5.472  1.00  0.00           C  
ATOM    448  C   PHE A 259       1.149  -6.356  -5.604  1.00  0.00           C  
ATOM    449  O   PHE A 259       2.143  -6.627  -4.931  1.00  0.00           O  
ATOM    450  CB  PHE A 259      -0.763  -5.124  -4.560  1.00  0.00           C  
ATOM    451  CG  PHE A 259      -1.318  -3.800  -4.120  1.00  0.00           C  
ATOM    452  CD1 PHE A 259      -0.705  -3.078  -3.108  1.00  0.00           C  
ATOM    453  CD2 PHE A 259      -2.452  -3.276  -4.718  1.00  0.00           C  
ATOM    454  CE1 PHE A 259      -1.215  -1.860  -2.700  1.00  0.00           C  
ATOM    455  CE2 PHE A 259      -2.966  -2.057  -4.315  1.00  0.00           C  
ATOM    456  CZ  PHE A 259      -2.345  -1.348  -3.305  1.00  0.00           C  
ATOM    457  H   PHE A 259      -0.793  -4.765  -7.163  1.00  0.00           H  
ATOM    458  HA  PHE A 259       1.153  -4.298  -5.037  1.00  0.00           H  
ATOM    459  HB2 PHE A 259      -1.544  -5.652  -5.086  1.00  0.00           H  
ATOM    460  HB3 PHE A 259      -0.489  -5.681  -3.677  1.00  0.00           H  
ATOM    461  HD1 PHE A 259       0.180  -3.477  -2.634  1.00  0.00           H  
ATOM    462  HD2 PHE A 259      -2.940  -3.830  -5.509  1.00  0.00           H  
ATOM    463  HE1 PHE A 259      -0.727  -1.308  -1.911  1.00  0.00           H  
ATOM    464  HE2 PHE A 259      -3.851  -1.660  -4.791  1.00  0.00           H  
ATOM    465  HZ  PHE A 259      -2.746  -0.397  -2.989  1.00  0.00           H  
ATOM    466  N   TYR A 260       0.611  -7.204  -6.475  1.00  0.00           N  
ATOM    467  CA  TYR A 260       1.172  -8.531  -6.693  1.00  0.00           C  
ATOM    468  C   TYR A 260       2.695  -8.476  -6.762  1.00  0.00           C  
ATOM    469  O   TYR A 260       3.381  -9.385  -6.297  1.00  0.00           O  
ATOM    470  CB  TYR A 260       0.614  -9.138  -7.981  1.00  0.00           C  
ATOM    471  CG  TYR A 260       1.584 -10.058  -8.687  1.00  0.00           C  
ATOM    472  CD1 TYR A 260       1.879 -11.314  -8.173  1.00  0.00           C  
ATOM    473  CD2 TYR A 260       2.206  -9.671  -9.868  1.00  0.00           C  
ATOM    474  CE1 TYR A 260       2.766 -12.158  -8.814  1.00  0.00           C  
ATOM    475  CE2 TYR A 260       3.091 -10.509 -10.517  1.00  0.00           C  
ATOM    476  CZ  TYR A 260       3.368 -11.752  -9.986  1.00  0.00           C  
ATOM    477  OH  TYR A 260       4.252 -12.588 -10.629  1.00  0.00           O  
ATOM    478  H   TYR A 260      -0.181  -6.930  -6.981  1.00  0.00           H  
ATOM    479  HA  TYR A 260       0.883  -9.155  -5.859  1.00  0.00           H  
ATOM    480  HB2 TYR A 260      -0.273  -9.708  -7.748  1.00  0.00           H  
ATOM    481  HB3 TYR A 260       0.356  -8.341  -8.664  1.00  0.00           H  
ATOM    482  HD1 TYR A 260       1.406 -11.631  -7.255  1.00  0.00           H  
ATOM    483  HD2 TYR A 260       1.986  -8.698 -10.282  1.00  0.00           H  
ATOM    484  HE1 TYR A 260       2.983 -13.132  -8.399  1.00  0.00           H  
ATOM    485  HE2 TYR A 260       3.565 -10.190 -11.434  1.00  0.00           H  
ATOM    486  HH  TYR A 260       3.780 -13.353 -10.965  1.00  0.00           H  
ATOM    487  N   GLN A 261       3.215  -7.401  -7.346  1.00  0.00           N  
ATOM    488  CA  GLN A 261       4.657  -7.226  -7.477  1.00  0.00           C  
ATOM    489  C   GLN A 261       5.345  -7.349  -6.122  1.00  0.00           C  
ATOM    490  O   GLN A 261       6.412  -7.955  -6.008  1.00  0.00           O  
ATOM    491  CB  GLN A 261       4.972  -5.865  -8.100  1.00  0.00           C  
ATOM    492  CG  GLN A 261       4.793  -4.700  -7.141  1.00  0.00           C  
ATOM    493  CD  GLN A 261       5.319  -3.394  -7.703  1.00  0.00           C  
ATOM    494  OE1 GLN A 261       6.517  -3.250  -7.949  1.00  0.00           O  
ATOM    495  NE2 GLN A 261       4.425  -2.435  -7.910  1.00  0.00           N  
ATOM    496  H   GLN A 261       2.616  -6.711  -7.698  1.00  0.00           H  
ATOM    497  HA  GLN A 261       5.028  -8.003  -8.127  1.00  0.00           H  
ATOM    498  HB2 GLN A 261       5.996  -5.867  -8.443  1.00  0.00           H  
ATOM    499  HB3 GLN A 261       4.318  -5.710  -8.946  1.00  0.00           H  
ATOM    500  HG2 GLN A 261       3.741  -4.583  -6.928  1.00  0.00           H  
ATOM    501  HG3 GLN A 261       5.322  -4.920  -6.225  1.00  0.00           H  
ATOM    502 HE21 GLN A 261       3.489  -2.621  -7.689  1.00  0.00           H  
ATOM    503 HE22 GLN A 261       4.738  -1.580  -8.272  1.00  0.00           H  
ATOM    504  N   PHE A 262       4.729  -6.771  -5.096  1.00  0.00           N  
ATOM    505  CA  PHE A 262       5.284  -6.815  -3.748  1.00  0.00           C  
ATOM    506  C   PHE A 262       5.343  -8.249  -3.231  1.00  0.00           C  
ATOM    507  O   PHE A 262       6.353  -8.678  -2.674  1.00  0.00           O  
ATOM    508  CB  PHE A 262       4.445  -5.954  -2.801  1.00  0.00           C  
ATOM    509  CG  PHE A 262       4.407  -4.502  -3.185  1.00  0.00           C  
ATOM    510  CD1 PHE A 262       5.577  -3.766  -3.278  1.00  0.00           C  
ATOM    511  CD2 PHE A 262       3.201  -3.874  -3.452  1.00  0.00           C  
ATOM    512  CE1 PHE A 262       5.545  -2.430  -3.632  1.00  0.00           C  
ATOM    513  CE2 PHE A 262       3.163  -2.539  -3.807  1.00  0.00           C  
ATOM    514  CZ  PHE A 262       4.338  -1.816  -3.896  1.00  0.00           C  
ATOM    515  H   PHE A 262       3.882  -6.303  -5.249  1.00  0.00           H  
ATOM    516  HA  PHE A 262       6.285  -6.417  -3.790  1.00  0.00           H  
ATOM    517  HB2 PHE A 262       3.430  -6.321  -2.795  1.00  0.00           H  
ATOM    518  HB3 PHE A 262       4.854  -6.024  -1.804  1.00  0.00           H  
ATOM    519  HD1 PHE A 262       6.524  -4.246  -3.072  1.00  0.00           H  
ATOM    520  HD2 PHE A 262       2.283  -4.438  -3.383  1.00  0.00           H  
ATOM    521  HE1 PHE A 262       6.466  -1.868  -3.701  1.00  0.00           H  
ATOM    522  HE2 PHE A 262       2.218  -2.061  -4.013  1.00  0.00           H  
ATOM    523  HZ  PHE A 262       4.311  -0.772  -4.174  1.00  0.00           H  
ATOM    524  N   GLY A 263       4.252  -8.986  -3.420  1.00  0.00           N  
ATOM    525  CA  GLY A 263       4.200 -10.363  -2.966  1.00  0.00           C  
ATOM    526  C   GLY A 263       2.828 -10.982  -3.144  1.00  0.00           C  
ATOM    527  O   GLY A 263       1.895 -10.317  -3.594  1.00  0.00           O  
ATOM    528  H   GLY A 263       3.477  -8.591  -3.870  1.00  0.00           H  
ATOM    529  HA2 GLY A 263       4.920 -10.943  -3.526  1.00  0.00           H  
ATOM    530  HA3 GLY A 263       4.464 -10.396  -1.920  1.00  0.00           H  
ATOM    531  N   GLU A 264       2.703 -12.256  -2.791  1.00  0.00           N  
ATOM    532  CA  GLU A 264       1.435 -12.964  -2.916  1.00  0.00           C  
ATOM    533  C   GLU A 264       0.291 -12.137  -2.336  1.00  0.00           C  
ATOM    534  O   GLU A 264       0.465 -11.428  -1.344  1.00  0.00           O  
ATOM    535  CB  GLU A 264       1.508 -14.318  -2.209  1.00  0.00           C  
ATOM    536  CG  GLU A 264       0.269 -15.176  -2.406  1.00  0.00           C  
ATOM    537  CD  GLU A 264       0.247 -15.867  -3.755  1.00  0.00           C  
ATOM    538  OE1 GLU A 264       0.216 -15.159  -4.783  1.00  0.00           O  
ATOM    539  OE2 GLU A 264       0.259 -17.115  -3.783  1.00  0.00           O  
ATOM    540  H   GLU A 264       3.484 -12.733  -2.437  1.00  0.00           H  
ATOM    541  HA  GLU A 264       1.248 -13.126  -3.966  1.00  0.00           H  
ATOM    542  HB2 GLU A 264       2.361 -14.863  -2.586  1.00  0.00           H  
ATOM    543  HB3 GLU A 264       1.639 -14.152  -1.150  1.00  0.00           H  
ATOM    544  HG2 GLU A 264       0.241 -15.928  -1.632  1.00  0.00           H  
ATOM    545  HG3 GLU A 264      -0.605 -14.547  -2.325  1.00  0.00           H  
ATOM    546  N   ILE A 265      -0.878 -12.232  -2.962  1.00  0.00           N  
ATOM    547  CA  ILE A 265      -2.050 -11.494  -2.508  1.00  0.00           C  
ATOM    548  C   ILE A 265      -3.146 -12.441  -2.034  1.00  0.00           C  
ATOM    549  O   ILE A 265      -3.769 -13.136  -2.835  1.00  0.00           O  
ATOM    550  CB  ILE A 265      -2.612 -10.592  -3.622  1.00  0.00           C  
ATOM    551  CG1 ILE A 265      -1.585  -9.527  -4.014  1.00  0.00           C  
ATOM    552  CG2 ILE A 265      -3.912  -9.941  -3.171  1.00  0.00           C  
ATOM    553  CD1 ILE A 265      -1.921  -8.809  -5.304  1.00  0.00           C  
ATOM    554  H   ILE A 265      -0.953 -12.814  -3.747  1.00  0.00           H  
ATOM    555  HA  ILE A 265      -1.748 -10.866  -1.682  1.00  0.00           H  
ATOM    556  HB  ILE A 265      -2.826 -11.209  -4.482  1.00  0.00           H  
ATOM    557 HG12 ILE A 265      -1.525  -8.788  -3.230  1.00  0.00           H  
ATOM    558 HG13 ILE A 265      -0.620  -9.996  -4.137  1.00  0.00           H  
ATOM    559 HG21 ILE A 265      -4.154  -9.124  -3.834  1.00  0.00           H  
ATOM    560 HG22 ILE A 265      -4.706 -10.672  -3.198  1.00  0.00           H  
ATOM    561 HG23 ILE A 265      -3.798  -9.568  -2.165  1.00  0.00           H  
ATOM    562 HD11 ILE A 265      -2.040  -7.753  -5.106  1.00  0.00           H  
ATOM    563 HD12 ILE A 265      -1.121  -8.953  -6.014  1.00  0.00           H  
ATOM    564 HD13 ILE A 265      -2.840  -9.205  -5.708  1.00  0.00           H  
ATOM    565  N   ARG A 266      -3.378 -12.461  -0.725  1.00  0.00           N  
ATOM    566  CA  ARG A 266      -4.400 -13.321  -0.143  1.00  0.00           C  
ATOM    567  C   ARG A 266      -5.741 -13.121  -0.841  1.00  0.00           C  
ATOM    568  O   ARG A 266      -6.387 -14.083  -1.259  1.00  0.00           O  
ATOM    569  CB  ARG A 266      -4.544 -13.039   1.354  1.00  0.00           C  
ATOM    570  CG  ARG A 266      -3.667 -13.920   2.228  1.00  0.00           C  
ATOM    571  CD  ARG A 266      -4.167 -13.954   3.663  1.00  0.00           C  
ATOM    572  NE  ARG A 266      -3.856 -15.220   4.321  1.00  0.00           N  
ATOM    573  CZ  ARG A 266      -4.454 -15.639   5.432  1.00  0.00           C  
ATOM    574  NH1 ARG A 266      -5.389 -14.894   6.005  1.00  0.00           N  
ATOM    575  NH2 ARG A 266      -4.116 -16.803   5.970  1.00  0.00           N  
ATOM    576  H   ARG A 266      -2.847 -11.883  -0.136  1.00  0.00           H  
ATOM    577  HA  ARG A 266      -4.087 -14.346  -0.278  1.00  0.00           H  
ATOM    578  HB2 ARG A 266      -4.280 -12.007   1.540  1.00  0.00           H  
ATOM    579  HB3 ARG A 266      -5.573 -13.196   1.640  1.00  0.00           H  
ATOM    580  HG2 ARG A 266      -3.674 -14.925   1.831  1.00  0.00           H  
ATOM    581  HG3 ARG A 266      -2.659 -13.532   2.216  1.00  0.00           H  
ATOM    582  HD2 ARG A 266      -3.699 -13.151   4.212  1.00  0.00           H  
ATOM    583  HD3 ARG A 266      -5.238 -13.813   3.661  1.00  0.00           H  
ATOM    584  HE  ARG A 266      -3.168 -15.786   3.913  1.00  0.00           H  
ATOM    585 HH11 ARG A 266      -5.645 -14.016   5.601  1.00  0.00           H  
ATOM    586 HH12 ARG A 266      -5.838 -15.211   6.841  1.00  0.00           H  
ATOM    587 HH21 ARG A 266      -3.412 -17.368   5.540  1.00  0.00           H  
ATOM    588 HH22 ARG A 266      -4.566 -17.116   6.805  1.00  0.00           H  
ATOM    589  N   THR A 267      -6.157 -11.864  -0.965  1.00  0.00           N  
ATOM    590  CA  THR A 267      -7.422 -11.536  -1.611  1.00  0.00           C  
ATOM    591  C   THR A 267      -7.522 -10.043  -1.897  1.00  0.00           C  
ATOM    592  O   THR A 267      -6.712  -9.252  -1.412  1.00  0.00           O  
ATOM    593  CB  THR A 267      -8.621 -11.963  -0.743  1.00  0.00           C  
ATOM    594  OG1 THR A 267      -9.820 -11.952  -1.527  1.00  0.00           O  
ATOM    595  CG2 THR A 267      -8.783 -11.037   0.452  1.00  0.00           C  
ATOM    596  H   THR A 267      -5.598 -11.140  -0.612  1.00  0.00           H  
ATOM    597  HA  THR A 267      -7.469 -12.077  -2.545  1.00  0.00           H  
ATOM    598  HB  THR A 267      -8.446 -12.966  -0.383  1.00  0.00           H  
ATOM    599  HG1 THR A 267     -10.579 -12.085  -0.954  1.00  0.00           H  
ATOM    600 HG21 THR A 267      -9.279 -10.130   0.141  1.00  0.00           H  
ATOM    601 HG22 THR A 267      -7.809 -10.794   0.854  1.00  0.00           H  
ATOM    602 HG23 THR A 267      -9.372 -11.528   1.211  1.00  0.00           H  
ATOM    603  N   ILE A 268      -8.520  -9.662  -2.686  1.00  0.00           N  
ATOM    604  CA  ILE A 268      -8.727  -8.263  -3.036  1.00  0.00           C  
ATOM    605  C   ILE A 268     -10.214  -7.935  -3.141  1.00  0.00           C  
ATOM    606  O   ILE A 268     -10.890  -8.360  -4.079  1.00  0.00           O  
ATOM    607  CB  ILE A 268      -8.040  -7.907  -4.367  1.00  0.00           C  
ATOM    608  CG1 ILE A 268      -6.523  -8.076  -4.244  1.00  0.00           C  
ATOM    609  CG2 ILE A 268      -8.387  -6.484  -4.779  1.00  0.00           C  
ATOM    610  CD1 ILE A 268      -5.785  -7.871  -5.548  1.00  0.00           C  
ATOM    611  H   ILE A 268      -9.133 -10.339  -3.042  1.00  0.00           H  
ATOM    612  HA  ILE A 268      -8.290  -7.656  -2.254  1.00  0.00           H  
ATOM    613  HB  ILE A 268      -8.409  -8.577  -5.127  1.00  0.00           H  
ATOM    614 HG12 ILE A 268      -6.145  -7.360  -3.532  1.00  0.00           H  
ATOM    615 HG13 ILE A 268      -6.308  -9.075  -3.892  1.00  0.00           H  
ATOM    616 HG21 ILE A 268      -7.814  -6.213  -5.654  1.00  0.00           H  
ATOM    617 HG22 ILE A 268      -9.440  -6.423  -5.007  1.00  0.00           H  
ATOM    618 HG23 ILE A 268      -8.154  -5.808  -3.971  1.00  0.00           H  
ATOM    619 HD11 ILE A 268      -5.439  -6.848  -5.609  1.00  0.00           H  
ATOM    620 HD12 ILE A 268      -4.937  -8.539  -5.591  1.00  0.00           H  
ATOM    621 HD13 ILE A 268      -6.448  -8.075  -6.374  1.00  0.00           H  
ATOM    622  N   THR A 269     -10.717  -7.177  -2.172  1.00  0.00           N  
ATOM    623  CA  THR A 269     -12.122  -6.791  -2.156  1.00  0.00           C  
ATOM    624  C   THR A 269     -12.302  -5.347  -2.606  1.00  0.00           C  
ATOM    625  O   THR A 269     -12.113  -4.413  -1.826  1.00  0.00           O  
ATOM    626  CB  THR A 269     -12.735  -6.959  -0.752  1.00  0.00           C  
ATOM    627  OG1 THR A 269     -12.545  -8.303  -0.293  1.00  0.00           O  
ATOM    628  CG2 THR A 269     -14.219  -6.627  -0.766  1.00  0.00           C  
ATOM    629  H   THR A 269     -10.127  -6.869  -1.452  1.00  0.00           H  
ATOM    630  HA  THR A 269     -12.654  -7.440  -2.838  1.00  0.00           H  
ATOM    631  HB  THR A 269     -12.235  -6.281  -0.075  1.00  0.00           H  
ATOM    632  HG1 THR A 269     -12.678  -8.912  -1.024  1.00  0.00           H  
ATOM    633 HG21 THR A 269     -14.671  -6.965   0.154  1.00  0.00           H  
ATOM    634 HG22 THR A 269     -14.691  -7.121  -1.602  1.00  0.00           H  
ATOM    635 HG23 THR A 269     -14.347  -5.558  -0.860  1.00  0.00           H  
ATOM    636  N   VAL A 270     -12.669  -5.167  -3.871  1.00  0.00           N  
ATOM    637  CA  VAL A 270     -12.877  -3.834  -4.426  1.00  0.00           C  
ATOM    638  C   VAL A 270     -14.332  -3.402  -4.288  1.00  0.00           C  
ATOM    639  O   VAL A 270     -15.217  -3.947  -4.946  1.00  0.00           O  
ATOM    640  CB  VAL A 270     -12.474  -3.776  -5.911  1.00  0.00           C  
ATOM    641  CG1 VAL A 270     -12.601  -2.356  -6.444  1.00  0.00           C  
ATOM    642  CG2 VAL A 270     -11.058  -4.300  -6.100  1.00  0.00           C  
ATOM    643  H   VAL A 270     -12.805  -5.949  -4.445  1.00  0.00           H  
ATOM    644  HA  VAL A 270     -12.252  -3.144  -3.878  1.00  0.00           H  
ATOM    645  HB  VAL A 270     -13.147  -4.408  -6.472  1.00  0.00           H  
ATOM    646 HG11 VAL A 270     -11.950  -1.702  -5.882  1.00  0.00           H  
ATOM    647 HG12 VAL A 270     -12.322  -2.336  -7.487  1.00  0.00           H  
ATOM    648 HG13 VAL A 270     -13.623  -2.023  -6.337  1.00  0.00           H  
ATOM    649 HG21 VAL A 270     -10.443  -3.527  -6.535  1.00  0.00           H  
ATOM    650 HG22 VAL A 270     -10.651  -4.588  -5.142  1.00  0.00           H  
ATOM    651 HG23 VAL A 270     -11.076  -5.158  -6.756  1.00  0.00           H  
ATOM    652  N   VAL A 271     -14.573  -2.417  -3.428  1.00  0.00           N  
ATOM    653  CA  VAL A 271     -15.920  -1.910  -3.204  1.00  0.00           C  
ATOM    654  C   VAL A 271     -16.203  -0.696  -4.081  1.00  0.00           C  
ATOM    655  O   VAL A 271     -15.792   0.420  -3.763  1.00  0.00           O  
ATOM    656  CB  VAL A 271     -16.137  -1.526  -1.728  1.00  0.00           C  
ATOM    657  CG1 VAL A 271     -17.566  -1.054  -1.504  1.00  0.00           C  
ATOM    658  CG2 VAL A 271     -15.806  -2.698  -0.818  1.00  0.00           C  
ATOM    659  H   VAL A 271     -13.824  -2.023  -2.932  1.00  0.00           H  
ATOM    660  HA  VAL A 271     -16.619  -2.695  -3.456  1.00  0.00           H  
ATOM    661  HB  VAL A 271     -15.471  -0.710  -1.488  1.00  0.00           H  
ATOM    662 HG11 VAL A 271     -17.592  -0.367  -0.670  1.00  0.00           H  
ATOM    663 HG12 VAL A 271     -17.925  -0.555  -2.393  1.00  0.00           H  
ATOM    664 HG13 VAL A 271     -18.197  -1.904  -1.289  1.00  0.00           H  
ATOM    665 HG21 VAL A 271     -16.673  -2.951  -0.226  1.00  0.00           H  
ATOM    666 HG22 VAL A 271     -15.517  -3.548  -1.418  1.00  0.00           H  
ATOM    667 HG23 VAL A 271     -14.990  -2.427  -0.164  1.00  0.00           H  
ATOM    668  N   GLN A 272     -16.908  -0.921  -5.185  1.00  0.00           N  
ATOM    669  CA  GLN A 272     -17.245   0.156  -6.109  1.00  0.00           C  
ATOM    670  C   GLN A 272     -18.075   1.229  -5.413  1.00  0.00           C  
ATOM    671  O   GLN A 272     -17.842   2.424  -5.598  1.00  0.00           O  
ATOM    672  CB  GLN A 272     -18.011  -0.398  -7.312  1.00  0.00           C  
ATOM    673  CG  GLN A 272     -17.835   0.427  -8.577  1.00  0.00           C  
ATOM    674  CD  GLN A 272     -18.931   0.178  -9.594  1.00  0.00           C  
ATOM    675  OE1 GLN A 272     -20.113   0.372  -9.310  1.00  0.00           O  
ATOM    676  NE2 GLN A 272     -18.543  -0.256 -10.788  1.00  0.00           N  
ATOM    677  H   GLN A 272     -17.207  -1.833  -5.384  1.00  0.00           H  
ATOM    678  HA  GLN A 272     -16.323   0.598  -6.453  1.00  0.00           H  
ATOM    679  HB2 GLN A 272     -17.666  -1.402  -7.513  1.00  0.00           H  
ATOM    680  HB3 GLN A 272     -19.063  -0.428  -7.072  1.00  0.00           H  
ATOM    681  HG2 GLN A 272     -17.843   1.475  -8.312  1.00  0.00           H  
ATOM    682  HG3 GLN A 272     -16.884   0.178  -9.025  1.00  0.00           H  
ATOM    683 HE21 GLN A 272     -17.584  -0.390 -10.942  1.00  0.00           H  
ATOM    684 HE22 GLN A 272     -19.230  -0.427 -11.463  1.00  0.00           H  
ATOM    685  N   ARG A 273     -19.044   0.795  -4.614  1.00  0.00           N  
ATOM    686  CA  ARG A 273     -19.910   1.721  -3.892  1.00  0.00           C  
ATOM    687  C   ARG A 273     -19.087   2.690  -3.050  1.00  0.00           C  
ATOM    688  O   ARG A 273     -19.525   3.804  -2.763  1.00  0.00           O  
ATOM    689  CB  ARG A 273     -20.882   0.949  -2.998  1.00  0.00           C  
ATOM    690  CG  ARG A 273     -20.219   0.299  -1.794  1.00  0.00           C  
ATOM    691  CD  ARG A 273     -21.173   0.206  -0.615  1.00  0.00           C  
ATOM    692  NE  ARG A 273     -21.242   1.458   0.133  1.00  0.00           N  
ATOM    693  CZ  ARG A 273     -22.045   1.649   1.175  1.00  0.00           C  
ATOM    694  NH1 ARG A 273     -22.842   0.674   1.589  1.00  0.00           N  
ATOM    695  NH2 ARG A 273     -22.052   2.817   1.804  1.00  0.00           N  
ATOM    696  H   ARG A 273     -19.181  -0.169  -4.508  1.00  0.00           H  
ATOM    697  HA  ARG A 273     -20.474   2.284  -4.620  1.00  0.00           H  
ATOM    698  HB2 ARG A 273     -21.640   1.630  -2.639  1.00  0.00           H  
ATOM    699  HB3 ARG A 273     -21.354   0.175  -3.583  1.00  0.00           H  
ATOM    700  HG2 ARG A 273     -19.900  -0.697  -2.065  1.00  0.00           H  
ATOM    701  HG3 ARG A 273     -19.361   0.889  -1.508  1.00  0.00           H  
ATOM    702  HD2 ARG A 273     -22.158  -0.037  -0.984  1.00  0.00           H  
ATOM    703  HD3 ARG A 273     -20.833  -0.578   0.045  1.00  0.00           H  
ATOM    704  HE  ARG A 273     -20.662   2.193  -0.156  1.00  0.00           H  
ATOM    705 HH11 ARG A 273     -22.838  -0.208   1.117  1.00  0.00           H  
ATOM    706 HH12 ARG A 273     -23.445   0.819   2.375  1.00  0.00           H  
ATOM    707 HH21 ARG A 273     -21.452   3.555   1.495  1.00  0.00           H  
ATOM    708 HH22 ARG A 273     -22.655   2.959   2.588  1.00  0.00           H  
ATOM    709  N   GLN A 274     -17.893   2.258  -2.656  1.00  0.00           N  
ATOM    710  CA  GLN A 274     -17.010   3.088  -1.846  1.00  0.00           C  
ATOM    711  C   GLN A 274     -15.715   3.395  -2.591  1.00  0.00           C  
ATOM    712  O   GLN A 274     -14.720   3.792  -1.987  1.00  0.00           O  
ATOM    713  CB  GLN A 274     -16.697   2.393  -0.520  1.00  0.00           C  
ATOM    714  CG  GLN A 274     -17.860   2.394   0.457  1.00  0.00           C  
ATOM    715  CD  GLN A 274     -17.681   1.391   1.580  1.00  0.00           C  
ATOM    716  OE1 GLN A 274     -16.635   0.752   1.696  1.00  0.00           O  
ATOM    717  NE2 GLN A 274     -18.703   1.248   2.417  1.00  0.00           N  
ATOM    718  H   GLN A 274     -17.599   1.361  -2.917  1.00  0.00           H  
ATOM    719  HA  GLN A 274     -17.522   4.017  -1.642  1.00  0.00           H  
ATOM    720  HB2 GLN A 274     -16.424   1.368  -0.720  1.00  0.00           H  
ATOM    721  HB3 GLN A 274     -15.862   2.894  -0.053  1.00  0.00           H  
ATOM    722  HG2 GLN A 274     -17.951   3.380   0.889  1.00  0.00           H  
ATOM    723  HG3 GLN A 274     -18.766   2.153  -0.079  1.00  0.00           H  
ATOM    724 HE21 GLN A 274     -19.505   1.790   2.262  1.00  0.00           H  
ATOM    725 HE22 GLN A 274     -18.615   0.607   3.150  1.00  0.00           H  
ATOM    726  N   GLN A 275     -15.737   3.208  -3.907  1.00  0.00           N  
ATOM    727  CA  GLN A 275     -14.564   3.464  -4.734  1.00  0.00           C  
ATOM    728  C   GLN A 275     -13.282   3.124  -3.981  1.00  0.00           C  
ATOM    729  O   GLN A 275     -12.310   3.880  -4.018  1.00  0.00           O  
ATOM    730  CB  GLN A 275     -14.536   4.928  -5.177  1.00  0.00           C  
ATOM    731  CG  GLN A 275     -15.749   5.339  -5.995  1.00  0.00           C  
ATOM    732  CD  GLN A 275     -15.919   6.844  -6.072  1.00  0.00           C  
ATOM    733  OE1 GLN A 275     -15.008   7.600  -5.733  1.00  0.00           O  
ATOM    734  NE2 GLN A 275     -17.087   7.286  -6.520  1.00  0.00           N  
ATOM    735  H   GLN A 275     -16.561   2.890  -4.330  1.00  0.00           H  
ATOM    736  HA  GLN A 275     -14.630   2.835  -5.608  1.00  0.00           H  
ATOM    737  HB2 GLN A 275     -14.490   5.556  -4.300  1.00  0.00           H  
ATOM    738  HB3 GLN A 275     -13.652   5.093  -5.775  1.00  0.00           H  
ATOM    739  HG2 GLN A 275     -15.639   4.953  -6.998  1.00  0.00           H  
ATOM    740  HG3 GLN A 275     -16.633   4.915  -5.543  1.00  0.00           H  
ATOM    741 HE21 GLN A 275     -17.766   6.624  -6.771  1.00  0.00           H  
ATOM    742 HE22 GLN A 275     -17.224   8.253  -6.580  1.00  0.00           H  
ATOM    743  N   CYS A 276     -13.288   1.984  -3.298  1.00  0.00           N  
ATOM    744  CA  CYS A 276     -12.125   1.546  -2.534  1.00  0.00           C  
ATOM    745  C   CYS A 276     -11.868   0.057  -2.744  1.00  0.00           C  
ATOM    746  O   CYS A 276     -12.664  -0.638  -3.377  1.00  0.00           O  
ATOM    747  CB  CYS A 276     -12.327   1.834  -1.046  1.00  0.00           C  
ATOM    748  SG  CYS A 276     -13.792   1.050  -0.333  1.00  0.00           S  
ATOM    749  H   CYS A 276     -14.093   1.425  -3.306  1.00  0.00           H  
ATOM    750  HA  CYS A 276     -11.270   2.099  -2.887  1.00  0.00           H  
ATOM    751  HB2 CYS A 276     -11.466   1.481  -0.498  1.00  0.00           H  
ATOM    752  HB3 CYS A 276     -12.422   2.901  -0.904  1.00  0.00           H  
ATOM    753  HG  CYS A 276     -13.449  -0.163   0.071  1.00  0.00           H  
ATOM    754  N   ALA A 277     -10.751  -0.426  -2.211  1.00  0.00           N  
ATOM    755  CA  ALA A 277     -10.389  -1.832  -2.339  1.00  0.00           C  
ATOM    756  C   ALA A 277      -9.438  -2.259  -1.226  1.00  0.00           C  
ATOM    757  O   ALA A 277      -8.523  -1.521  -0.862  1.00  0.00           O  
ATOM    758  CB  ALA A 277      -9.762  -2.093  -3.701  1.00  0.00           C  
ATOM    759  H   ALA A 277     -10.157   0.177  -1.718  1.00  0.00           H  
ATOM    760  HA  ALA A 277     -11.294  -2.418  -2.270  1.00  0.00           H  
ATOM    761  HB1 ALA A 277     -10.489  -1.904  -4.475  1.00  0.00           H  
ATOM    762  HB2 ALA A 277      -8.912  -1.439  -3.837  1.00  0.00           H  
ATOM    763  HB3 ALA A 277      -9.436  -3.122  -3.756  1.00  0.00           H  
ATOM    764  N   PHE A 278      -9.661  -3.454  -0.689  1.00  0.00           N  
ATOM    765  CA  PHE A 278      -8.824  -3.978   0.384  1.00  0.00           C  
ATOM    766  C   PHE A 278      -7.886  -5.062  -0.137  1.00  0.00           C  
ATOM    767  O   PHE A 278      -8.329  -6.126  -0.570  1.00  0.00           O  
ATOM    768  CB  PHE A 278      -9.695  -4.539   1.510  1.00  0.00           C  
ATOM    769  CG  PHE A 278     -10.267  -3.481   2.409  1.00  0.00           C  
ATOM    770  CD1 PHE A 278      -9.545  -3.010   3.493  1.00  0.00           C  
ATOM    771  CD2 PHE A 278     -11.529  -2.959   2.172  1.00  0.00           C  
ATOM    772  CE1 PHE A 278     -10.069  -2.036   4.324  1.00  0.00           C  
ATOM    773  CE2 PHE A 278     -12.057  -1.985   2.998  1.00  0.00           C  
ATOM    774  CZ  PHE A 278     -11.327  -1.524   4.075  1.00  0.00           C  
ATOM    775  H   PHE A 278     -10.406  -3.996  -1.022  1.00  0.00           H  
ATOM    776  HA  PHE A 278      -8.233  -3.162   0.771  1.00  0.00           H  
ATOM    777  HB2 PHE A 278     -10.519  -5.088   1.079  1.00  0.00           H  
ATOM    778  HB3 PHE A 278      -9.100  -5.206   2.116  1.00  0.00           H  
ATOM    779  HD1 PHE A 278      -8.560  -3.409   3.689  1.00  0.00           H  
ATOM    780  HD2 PHE A 278     -12.102  -3.319   1.330  1.00  0.00           H  
ATOM    781  HE1 PHE A 278      -9.494  -1.677   5.165  1.00  0.00           H  
ATOM    782  HE2 PHE A 278     -13.042  -1.587   2.801  1.00  0.00           H  
ATOM    783  HZ  PHE A 278     -11.737  -0.763   4.722  1.00  0.00           H  
ATOM    784  N   ILE A 279      -6.588  -4.783  -0.093  1.00  0.00           N  
ATOM    785  CA  ILE A 279      -5.586  -5.734  -0.560  1.00  0.00           C  
ATOM    786  C   ILE A 279      -4.988  -6.519   0.602  1.00  0.00           C  
ATOM    787  O   ILE A 279      -4.369  -5.945   1.498  1.00  0.00           O  
ATOM    788  CB  ILE A 279      -4.451  -5.027  -1.324  1.00  0.00           C  
ATOM    789  CG1 ILE A 279      -5.015  -3.893  -2.184  1.00  0.00           C  
ATOM    790  CG2 ILE A 279      -3.690  -6.024  -2.185  1.00  0.00           C  
ATOM    791  CD1 ILE A 279      -5.836  -4.377  -3.359  1.00  0.00           C  
ATOM    792  H   ILE A 279      -6.296  -3.918   0.262  1.00  0.00           H  
ATOM    793  HA  ILE A 279      -6.072  -6.424  -1.236  1.00  0.00           H  
ATOM    794  HB  ILE A 279      -3.764  -4.613  -0.602  1.00  0.00           H  
ATOM    795 HG12 ILE A 279      -5.647  -3.267  -1.574  1.00  0.00           H  
ATOM    796 HG13 ILE A 279      -4.195  -3.304  -2.571  1.00  0.00           H  
ATOM    797 HG21 ILE A 279      -2.635  -5.799  -2.149  1.00  0.00           H  
ATOM    798 HG22 ILE A 279      -3.858  -7.023  -1.811  1.00  0.00           H  
ATOM    799 HG23 ILE A 279      -4.038  -5.957  -3.205  1.00  0.00           H  
ATOM    800 HD11 ILE A 279      -5.184  -4.562  -4.201  1.00  0.00           H  
ATOM    801 HD12 ILE A 279      -6.344  -5.292  -3.091  1.00  0.00           H  
ATOM    802 HD13 ILE A 279      -6.562  -3.624  -3.625  1.00  0.00           H  
ATOM    803  N   GLN A 280      -5.178  -7.834   0.580  1.00  0.00           N  
ATOM    804  CA  GLN A 280      -4.656  -8.699   1.633  1.00  0.00           C  
ATOM    805  C   GLN A 280      -3.427  -9.461   1.152  1.00  0.00           C  
ATOM    806  O   GLN A 280      -3.374  -9.917   0.009  1.00  0.00           O  
ATOM    807  CB  GLN A 280      -5.734  -9.683   2.094  1.00  0.00           C  
ATOM    808  CG  GLN A 280      -5.405 -10.372   3.409  1.00  0.00           C  
ATOM    809  CD  GLN A 280      -6.560 -11.198   3.939  1.00  0.00           C  
ATOM    810  OE1 GLN A 280      -6.932 -12.214   3.351  1.00  0.00           O  
ATOM    811  NE2 GLN A 280      -7.133 -10.767   5.056  1.00  0.00           N  
ATOM    812  H   GLN A 280      -5.681  -8.232  -0.160  1.00  0.00           H  
ATOM    813  HA  GLN A 280      -4.374  -8.073   2.465  1.00  0.00           H  
ATOM    814  HB2 GLN A 280      -6.664  -9.148   2.215  1.00  0.00           H  
ATOM    815  HB3 GLN A 280      -5.859 -10.442   1.337  1.00  0.00           H  
ATOM    816  HG2 GLN A 280      -4.556 -11.022   3.258  1.00  0.00           H  
ATOM    817  HG3 GLN A 280      -5.153  -9.618   4.142  1.00  0.00           H  
ATOM    818 HE21 GLN A 280      -6.783  -9.949   5.470  1.00  0.00           H  
ATOM    819 HE22 GLN A 280      -7.882 -11.282   5.421  1.00  0.00           H  
ATOM    820  N   PHE A 281      -2.439  -9.596   2.030  1.00  0.00           N  
ATOM    821  CA  PHE A 281      -1.209 -10.303   1.694  1.00  0.00           C  
ATOM    822  C   PHE A 281      -1.003 -11.505   2.612  1.00  0.00           C  
ATOM    823  O   PHE A 281      -1.374 -11.473   3.786  1.00  0.00           O  
ATOM    824  CB  PHE A 281      -0.009  -9.358   1.797  1.00  0.00           C  
ATOM    825  CG  PHE A 281      -0.049  -8.230   0.806  1.00  0.00           C  
ATOM    826  CD1 PHE A 281      -0.722  -7.055   1.101  1.00  0.00           C  
ATOM    827  CD2 PHE A 281       0.587  -8.343  -0.420  1.00  0.00           C  
ATOM    828  CE1 PHE A 281      -0.761  -6.015   0.192  1.00  0.00           C  
ATOM    829  CE2 PHE A 281       0.552  -7.307  -1.332  1.00  0.00           C  
ATOM    830  CZ  PHE A 281      -0.123  -6.141  -1.027  1.00  0.00           C  
ATOM    831  H   PHE A 281      -2.540  -9.211   2.926  1.00  0.00           H  
ATOM    832  HA  PHE A 281      -1.295 -10.652   0.677  1.00  0.00           H  
ATOM    833  HB2 PHE A 281       0.019  -8.929   2.787  1.00  0.00           H  
ATOM    834  HB3 PHE A 281       0.897  -9.920   1.626  1.00  0.00           H  
ATOM    835  HD1 PHE A 281      -1.222  -6.956   2.055  1.00  0.00           H  
ATOM    836  HD2 PHE A 281       1.114  -9.255  -0.661  1.00  0.00           H  
ATOM    837  HE1 PHE A 281      -1.289  -5.105   0.435  1.00  0.00           H  
ATOM    838  HE2 PHE A 281       1.051  -7.408  -2.285  1.00  0.00           H  
ATOM    839  HZ  PHE A 281      -0.151  -5.329  -1.738  1.00  0.00           H  
ATOM    840  N   ALA A 282      -0.412 -12.563   2.068  1.00  0.00           N  
ATOM    841  CA  ALA A 282      -0.157 -13.775   2.836  1.00  0.00           C  
ATOM    842  C   ALA A 282       0.921 -13.539   3.890  1.00  0.00           C  
ATOM    843  O   ALA A 282       0.876 -14.114   4.979  1.00  0.00           O  
ATOM    844  CB  ALA A 282       0.247 -14.912   1.911  1.00  0.00           C  
ATOM    845  H   ALA A 282      -0.141 -12.528   1.127  1.00  0.00           H  
ATOM    846  HA  ALA A 282      -1.075 -14.055   3.332  1.00  0.00           H  
ATOM    847  HB1 ALA A 282      -0.009 -15.856   2.368  1.00  0.00           H  
ATOM    848  HB2 ALA A 282      -0.277 -14.813   0.971  1.00  0.00           H  
ATOM    849  HB3 ALA A 282       1.312 -14.873   1.735  1.00  0.00           H  
ATOM    850  N   THR A 283       1.890 -12.692   3.558  1.00  0.00           N  
ATOM    851  CA  THR A 283       2.980 -12.382   4.475  1.00  0.00           C  
ATOM    852  C   THR A 283       3.137 -10.876   4.655  1.00  0.00           C  
ATOM    853  O   THR A 283       3.417 -10.153   3.700  1.00  0.00           O  
ATOM    854  CB  THR A 283       4.315 -12.969   3.978  1.00  0.00           C  
ATOM    855  OG1 THR A 283       4.540 -12.591   2.617  1.00  0.00           O  
ATOM    856  CG2 THR A 283       4.316 -14.486   4.096  1.00  0.00           C  
ATOM    857  H   THR A 283       1.871 -12.266   2.676  1.00  0.00           H  
ATOM    858  HA  THR A 283       2.749 -12.828   5.432  1.00  0.00           H  
ATOM    859  HB  THR A 283       5.114 -12.575   4.591  1.00  0.00           H  
ATOM    860  HG1 THR A 283       4.266 -11.680   2.487  1.00  0.00           H  
ATOM    861 HG21 THR A 283       3.316 -14.859   3.939  1.00  0.00           H  
ATOM    862 HG22 THR A 283       4.656 -14.771   5.081  1.00  0.00           H  
ATOM    863 HG23 THR A 283       4.977 -14.904   3.352  1.00  0.00           H  
ATOM    864  N   ARG A 284       2.954 -10.410   5.886  1.00  0.00           N  
ATOM    865  CA  ARG A 284       3.074  -8.990   6.191  1.00  0.00           C  
ATOM    866  C   ARG A 284       4.190  -8.350   5.370  1.00  0.00           C  
ATOM    867  O   ARG A 284       4.074  -7.207   4.933  1.00  0.00           O  
ATOM    868  CB  ARG A 284       3.343  -8.788   7.683  1.00  0.00           C  
ATOM    869  CG  ARG A 284       3.590  -7.337   8.067  1.00  0.00           C  
ATOM    870  CD  ARG A 284       2.302  -6.530   8.046  1.00  0.00           C  
ATOM    871  NE  ARG A 284       2.551  -5.098   8.198  1.00  0.00           N  
ATOM    872  CZ  ARG A 284       2.947  -4.538   9.336  1.00  0.00           C  
ATOM    873  NH1 ARG A 284       3.139  -5.285  10.415  1.00  0.00           N  
ATOM    874  NH2 ARG A 284       3.154  -3.229   9.395  1.00  0.00           N  
ATOM    875  H   ARG A 284       2.733 -11.037   6.607  1.00  0.00           H  
ATOM    876  HA  ARG A 284       2.138  -8.515   5.935  1.00  0.00           H  
ATOM    877  HB2 ARG A 284       2.491  -9.145   8.242  1.00  0.00           H  
ATOM    878  HB3 ARG A 284       4.213  -9.364   7.962  1.00  0.00           H  
ATOM    879  HG2 ARG A 284       4.008  -7.304   9.062  1.00  0.00           H  
ATOM    880  HG3 ARG A 284       4.288  -6.903   7.366  1.00  0.00           H  
ATOM    881  HD2 ARG A 284       1.800  -6.699   7.106  1.00  0.00           H  
ATOM    882  HD3 ARG A 284       1.671  -6.864   8.856  1.00  0.00           H  
ATOM    883  HE  ARG A 284       2.416  -4.528   7.413  1.00  0.00           H  
ATOM    884 HH11 ARG A 284       2.985  -6.272  10.373  1.00  0.00           H  
ATOM    885 HH12 ARG A 284       3.438  -4.860  11.270  1.00  0.00           H  
ATOM    886 HH21 ARG A 284       3.011  -2.663   8.584  1.00  0.00           H  
ATOM    887 HH22 ARG A 284       3.451  -2.808  10.251  1.00  0.00           H  
ATOM    888  N   GLN A 285       5.271  -9.097   5.168  1.00  0.00           N  
ATOM    889  CA  GLN A 285       6.408  -8.603   4.401  1.00  0.00           C  
ATOM    890  C   GLN A 285       5.944  -7.737   3.235  1.00  0.00           C  
ATOM    891  O   GLN A 285       6.205  -6.535   3.197  1.00  0.00           O  
ATOM    892  CB  GLN A 285       7.248  -9.771   3.883  1.00  0.00           C  
ATOM    893  CG  GLN A 285       8.619  -9.356   3.373  1.00  0.00           C  
ATOM    894  CD  GLN A 285       9.678  -9.382   4.456  1.00  0.00           C  
ATOM    895  OE1 GLN A 285      10.324 -10.404   4.684  1.00  0.00           O  
ATOM    896  NE2 GLN A 285       9.862  -8.253   5.132  1.00  0.00           N  
ATOM    897  H   GLN A 285       5.304 -10.002   5.543  1.00  0.00           H  
ATOM    898  HA  GLN A 285       7.015  -8.000   5.060  1.00  0.00           H  
ATOM    899  HB2 GLN A 285       7.386 -10.483   4.682  1.00  0.00           H  
ATOM    900  HB3 GLN A 285       6.716 -10.249   3.073  1.00  0.00           H  
ATOM    901  HG2 GLN A 285       8.915 -10.033   2.585  1.00  0.00           H  
ATOM    902  HG3 GLN A 285       8.553  -8.353   2.977  1.00  0.00           H  
ATOM    903 HE21 GLN A 285       9.309  -7.478   4.896  1.00  0.00           H  
ATOM    904 HE22 GLN A 285      10.539  -8.242   5.838  1.00  0.00           H  
ATOM    905  N   ALA A 286       5.252  -8.357   2.283  1.00  0.00           N  
ATOM    906  CA  ALA A 286       4.751  -7.644   1.116  1.00  0.00           C  
ATOM    907  C   ALA A 286       3.815  -6.511   1.526  1.00  0.00           C  
ATOM    908  O   ALA A 286       3.789  -5.456   0.894  1.00  0.00           O  
ATOM    909  CB  ALA A 286       4.038  -8.606   0.175  1.00  0.00           C  
ATOM    910  H   ALA A 286       5.076  -9.317   2.369  1.00  0.00           H  
ATOM    911  HA  ALA A 286       5.596  -7.226   0.590  1.00  0.00           H  
ATOM    912  HB1 ALA A 286       3.744  -9.490   0.720  1.00  0.00           H  
ATOM    913  HB2 ALA A 286       3.160  -8.125  -0.232  1.00  0.00           H  
ATOM    914  HB3 ALA A 286       4.704  -8.882  -0.628  1.00  0.00           H  
ATOM    915  N   ALA A 287       3.047  -6.739   2.587  1.00  0.00           N  
ATOM    916  CA  ALA A 287       2.111  -5.736   3.081  1.00  0.00           C  
ATOM    917  C   ALA A 287       2.830  -4.439   3.431  1.00  0.00           C  
ATOM    918  O   ALA A 287       2.506  -3.376   2.901  1.00  0.00           O  
ATOM    919  CB  ALA A 287       1.359  -6.269   4.291  1.00  0.00           C  
ATOM    920  H   ALA A 287       3.113  -7.600   3.048  1.00  0.00           H  
ATOM    921  HA  ALA A 287       1.391  -5.539   2.299  1.00  0.00           H  
ATOM    922  HB1 ALA A 287       1.921  -6.053   5.187  1.00  0.00           H  
ATOM    923  HB2 ALA A 287       0.391  -5.794   4.350  1.00  0.00           H  
ATOM    924  HB3 ALA A 287       1.231  -7.337   4.195  1.00  0.00           H  
ATOM    925  N   GLU A 288       3.808  -4.533   4.327  1.00  0.00           N  
ATOM    926  CA  GLU A 288       4.571  -3.364   4.749  1.00  0.00           C  
ATOM    927  C   GLU A 288       5.127  -2.613   3.542  1.00  0.00           C  
ATOM    928  O   GLU A 288       4.830  -1.436   3.339  1.00  0.00           O  
ATOM    929  CB  GLU A 288       5.716  -3.782   5.674  1.00  0.00           C  
ATOM    930  CG  GLU A 288       5.316  -3.867   7.137  1.00  0.00           C  
ATOM    931  CD  GLU A 288       6.507  -3.808   8.072  1.00  0.00           C  
ATOM    932  OE1 GLU A 288       7.301  -2.849   7.962  1.00  0.00           O  
ATOM    933  OE2 GLU A 288       6.648  -4.719   8.914  1.00  0.00           O  
ATOM    934  H   GLU A 288       4.020  -5.408   4.714  1.00  0.00           H  
ATOM    935  HA  GLU A 288       3.905  -2.710   5.289  1.00  0.00           H  
ATOM    936  HB2 GLU A 288       6.079  -4.751   5.364  1.00  0.00           H  
ATOM    937  HB3 GLU A 288       6.517  -3.063   5.583  1.00  0.00           H  
ATOM    938  HG2 GLU A 288       4.658  -3.043   7.366  1.00  0.00           H  
ATOM    939  HG3 GLU A 288       4.794  -4.799   7.301  1.00  0.00           H  
ATOM    940  N   VAL A 289       5.936  -3.303   2.744  1.00  0.00           N  
ATOM    941  CA  VAL A 289       6.533  -2.702   1.558  1.00  0.00           C  
ATOM    942  C   VAL A 289       5.506  -1.892   0.776  1.00  0.00           C  
ATOM    943  O   VAL A 289       5.654  -0.681   0.606  1.00  0.00           O  
ATOM    944  CB  VAL A 289       7.139  -3.773   0.631  1.00  0.00           C  
ATOM    945  CG1 VAL A 289       7.846  -3.122  -0.548  1.00  0.00           C  
ATOM    946  CG2 VAL A 289       8.092  -4.670   1.405  1.00  0.00           C  
ATOM    947  H   VAL A 289       6.136  -4.237   2.958  1.00  0.00           H  
ATOM    948  HA  VAL A 289       7.327  -2.044   1.880  1.00  0.00           H  
ATOM    949  HB  VAL A 289       6.335  -4.384   0.247  1.00  0.00           H  
ATOM    950 HG11 VAL A 289       7.869  -3.810  -1.380  1.00  0.00           H  
ATOM    951 HG12 VAL A 289       7.316  -2.226  -0.836  1.00  0.00           H  
ATOM    952 HG13 VAL A 289       8.857  -2.868  -0.265  1.00  0.00           H  
ATOM    953 HG21 VAL A 289       8.079  -4.393   2.450  1.00  0.00           H  
ATOM    954 HG22 VAL A 289       7.782  -5.699   1.302  1.00  0.00           H  
ATOM    955 HG23 VAL A 289       9.093  -4.554   1.016  1.00  0.00           H  
ATOM    956  N   ALA A 290       4.465  -2.567   0.301  1.00  0.00           N  
ATOM    957  CA  ALA A 290       3.410  -1.908  -0.462  1.00  0.00           C  
ATOM    958  C   ALA A 290       2.777  -0.778   0.341  1.00  0.00           C  
ATOM    959  O   ALA A 290       2.444   0.274  -0.205  1.00  0.00           O  
ATOM    960  CB  ALA A 290       2.352  -2.919  -0.880  1.00  0.00           C  
ATOM    961  H   ALA A 290       4.403  -3.530   0.469  1.00  0.00           H  
ATOM    962  HA  ALA A 290       3.853  -1.497  -1.357  1.00  0.00           H  
ATOM    963  HB1 ALA A 290       2.824  -3.867  -1.093  1.00  0.00           H  
ATOM    964  HB2 ALA A 290       1.639  -3.045  -0.078  1.00  0.00           H  
ATOM    965  HB3 ALA A 290       1.843  -2.562  -1.763  1.00  0.00           H  
ATOM    966  N   ALA A 291       2.610  -1.002   1.641  1.00  0.00           N  
ATOM    967  CA  ALA A 291       2.017  -0.001   2.519  1.00  0.00           C  
ATOM    968  C   ALA A 291       2.680   1.358   2.328  1.00  0.00           C  
ATOM    969  O   ALA A 291       2.071   2.289   1.802  1.00  0.00           O  
ATOM    970  CB  ALA A 291       2.123  -0.444   3.970  1.00  0.00           C  
ATOM    971  H   ALA A 291       2.895  -1.861   2.018  1.00  0.00           H  
ATOM    972  HA  ALA A 291       0.970   0.083   2.269  1.00  0.00           H  
ATOM    973  HB1 ALA A 291       1.340   0.024   4.547  1.00  0.00           H  
ATOM    974  HB2 ALA A 291       2.020  -1.518   4.027  1.00  0.00           H  
ATOM    975  HB3 ALA A 291       3.084  -0.153   4.366  1.00  0.00           H  
ATOM    976  N   GLU A 292       3.934   1.467   2.760  1.00  0.00           N  
ATOM    977  CA  GLU A 292       4.678   2.714   2.638  1.00  0.00           C  
ATOM    978  C   GLU A 292       4.679   3.208   1.195  1.00  0.00           C  
ATOM    979  O   GLU A 292       4.490   4.396   0.932  1.00  0.00           O  
ATOM    980  CB  GLU A 292       6.116   2.525   3.125  1.00  0.00           C  
ATOM    981  CG  GLU A 292       6.289   2.756   4.617  1.00  0.00           C  
ATOM    982  CD  GLU A 292       7.650   2.317   5.121  1.00  0.00           C  
ATOM    983  OE1 GLU A 292       8.088   1.205   4.755  1.00  0.00           O  
ATOM    984  OE2 GLU A 292       8.278   3.083   5.881  1.00  0.00           O  
ATOM    985  H   GLU A 292       4.366   0.689   3.171  1.00  0.00           H  
ATOM    986  HA  GLU A 292       4.193   3.453   3.257  1.00  0.00           H  
ATOM    987  HB2 GLU A 292       6.431   1.517   2.898  1.00  0.00           H  
ATOM    988  HB3 GLU A 292       6.755   3.219   2.598  1.00  0.00           H  
ATOM    989  HG2 GLU A 292       6.170   3.809   4.821  1.00  0.00           H  
ATOM    990  HG3 GLU A 292       5.529   2.199   5.144  1.00  0.00           H  
ATOM    991  N   LYS A 293       4.893   2.288   0.260  1.00  0.00           N  
ATOM    992  CA  LYS A 293       4.918   2.627  -1.157  1.00  0.00           C  
ATOM    993  C   LYS A 293       3.519   2.971  -1.659  1.00  0.00           C  
ATOM    994  O   LYS A 293       3.341   3.352  -2.816  1.00  0.00           O  
ATOM    995  CB  LYS A 293       5.491   1.463  -1.971  1.00  0.00           C  
ATOM    996  CG  LYS A 293       7.009   1.420  -1.982  1.00  0.00           C  
ATOM    997  CD  LYS A 293       7.540   0.814  -3.271  1.00  0.00           C  
ATOM    998  CE  LYS A 293       8.866   0.103  -3.048  1.00  0.00           C  
ATOM    999  NZ  LYS A 293       9.100  -0.963  -4.062  1.00  0.00           N  
ATOM   1000  H   LYS A 293       5.036   1.356   0.531  1.00  0.00           H  
ATOM   1001  HA  LYS A 293       5.555   3.489  -1.281  1.00  0.00           H  
ATOM   1002  HB2 LYS A 293       5.127   0.536  -1.555  1.00  0.00           H  
ATOM   1003  HB3 LYS A 293       5.147   1.550  -2.992  1.00  0.00           H  
ATOM   1004  HG2 LYS A 293       7.390   2.425  -1.886  1.00  0.00           H  
ATOM   1005  HG3 LYS A 293       7.349   0.821  -1.148  1.00  0.00           H  
ATOM   1006  HD2 LYS A 293       6.821   0.102  -3.647  1.00  0.00           H  
ATOM   1007  HD3 LYS A 293       7.682   1.603  -3.996  1.00  0.00           H  
ATOM   1008  HE2 LYS A 293       9.663   0.827  -3.109  1.00  0.00           H  
ATOM   1009  HE3 LYS A 293       8.859  -0.343  -2.064  1.00  0.00           H  
ATOM   1010  HZ1 LYS A 293       9.257  -1.876  -3.591  1.00  0.00           H  
ATOM   1011  HZ2 LYS A 293       9.937  -0.732  -4.635  1.00  0.00           H  
ATOM   1012  HZ3 LYS A 293       8.276  -1.045  -4.690  1.00  0.00           H  
ATOM   1013  N   SER A 294       2.530   2.835  -0.782  1.00  0.00           N  
ATOM   1014  CA  SER A 294       1.147   3.130  -1.137  1.00  0.00           C  
ATOM   1015  C   SER A 294       0.643   4.358  -0.385  1.00  0.00           C  
ATOM   1016  O   SER A 294      -0.212   5.094  -0.878  1.00  0.00           O  
ATOM   1017  CB  SER A 294       0.252   1.927  -0.830  1.00  0.00           C  
ATOM   1018  OG  SER A 294       0.465   0.883  -1.764  1.00  0.00           O  
ATOM   1019  H   SER A 294       2.736   2.527   0.126  1.00  0.00           H  
ATOM   1020  HA  SER A 294       1.113   3.332  -2.197  1.00  0.00           H  
ATOM   1021  HB2 SER A 294       0.474   1.560   0.160  1.00  0.00           H  
ATOM   1022  HB3 SER A 294      -0.783   2.232  -0.878  1.00  0.00           H  
ATOM   1023  HG  SER A 294       1.366   0.922  -2.089  1.00  0.00           H  
ATOM   1024  N   PHE A 295       1.180   4.573   0.811  1.00  0.00           N  
ATOM   1025  CA  PHE A 295       0.785   5.711   1.634  1.00  0.00           C  
ATOM   1026  C   PHE A 295       0.782   6.998   0.814  1.00  0.00           C  
ATOM   1027  O   PHE A 295       1.822   7.629   0.625  1.00  0.00           O  
ATOM   1028  CB  PHE A 295       1.729   5.856   2.829  1.00  0.00           C  
ATOM   1029  CG  PHE A 295       1.299   5.064   4.031  1.00  0.00           C  
ATOM   1030  CD1 PHE A 295       0.690   3.829   3.883  1.00  0.00           C  
ATOM   1031  CD2 PHE A 295       1.504   5.557   5.310  1.00  0.00           C  
ATOM   1032  CE1 PHE A 295       0.293   3.099   4.987  1.00  0.00           C  
ATOM   1033  CE2 PHE A 295       1.110   4.831   6.418  1.00  0.00           C  
ATOM   1034  CZ  PHE A 295       0.503   3.600   6.256  1.00  0.00           C  
ATOM   1035  H   PHE A 295       1.858   3.951   1.150  1.00  0.00           H  
ATOM   1036  HA  PHE A 295      -0.214   5.527   1.995  1.00  0.00           H  
ATOM   1037  HB2 PHE A 295       2.714   5.517   2.544  1.00  0.00           H  
ATOM   1038  HB3 PHE A 295       1.779   6.896   3.115  1.00  0.00           H  
ATOM   1039  HD1 PHE A 295       0.525   3.435   2.889  1.00  0.00           H  
ATOM   1040  HD2 PHE A 295       1.978   6.519   5.439  1.00  0.00           H  
ATOM   1041  HE1 PHE A 295      -0.181   2.136   4.856  1.00  0.00           H  
ATOM   1042  HE2 PHE A 295       1.274   5.225   7.409  1.00  0.00           H  
ATOM   1043  HZ  PHE A 295       0.195   3.031   7.120  1.00  0.00           H  
ATOM   1044  N   ASN A 296      -0.395   7.382   0.331  1.00  0.00           N  
ATOM   1045  CA  ASN A 296      -0.534   8.594  -0.470  1.00  0.00           C  
ATOM   1046  C   ASN A 296       0.571   8.683  -1.518  1.00  0.00           C  
ATOM   1047  O   ASN A 296       0.931   9.772  -1.967  1.00  0.00           O  
ATOM   1048  CB  ASN A 296      -0.499   9.831   0.430  1.00  0.00           C  
ATOM   1049  CG  ASN A 296      -0.807  11.107  -0.330  1.00  0.00           C  
ATOM   1050  OD1 ASN A 296      -1.869  11.242  -0.936  1.00  0.00           O  
ATOM   1051  ND2 ASN A 296       0.126  12.053  -0.299  1.00  0.00           N  
ATOM   1052  H   ASN A 296      -1.188   6.838   0.515  1.00  0.00           H  
ATOM   1053  HA  ASN A 296      -1.488   8.552  -0.972  1.00  0.00           H  
ATOM   1054  HB2 ASN A 296      -1.232   9.718   1.216  1.00  0.00           H  
ATOM   1055  HB3 ASN A 296       0.482   9.922   0.870  1.00  0.00           H  
ATOM   1056 HD21 ASN A 296       0.949  11.876   0.203  1.00  0.00           H  
ATOM   1057 HD22 ASN A 296      -0.047  12.888  -0.782  1.00  0.00           H  
ATOM   1058  N   LYS A 297       1.107   7.530  -1.905  1.00  0.00           N  
ATOM   1059  CA  LYS A 297       2.170   7.476  -2.903  1.00  0.00           C  
ATOM   1060  C   LYS A 297       1.744   6.642  -4.106  1.00  0.00           C  
ATOM   1061  O   LYS A 297       2.244   6.834  -5.216  1.00  0.00           O  
ATOM   1062  CB  LYS A 297       3.444   6.892  -2.288  1.00  0.00           C  
ATOM   1063  CG  LYS A 297       4.551   6.651  -3.299  1.00  0.00           C  
ATOM   1064  CD  LYS A 297       5.876   6.360  -2.616  1.00  0.00           C  
ATOM   1065  CE  LYS A 297       6.899   5.804  -3.596  1.00  0.00           C  
ATOM   1066  NZ  LYS A 297       8.073   5.214  -2.896  1.00  0.00           N  
ATOM   1067  H   LYS A 297       0.779   6.695  -1.511  1.00  0.00           H  
ATOM   1068  HA  LYS A 297       2.368   8.485  -3.230  1.00  0.00           H  
ATOM   1069  HB2 LYS A 297       3.813   7.574  -1.536  1.00  0.00           H  
ATOM   1070  HB3 LYS A 297       3.203   5.949  -1.818  1.00  0.00           H  
ATOM   1071  HG2 LYS A 297       4.284   5.807  -3.919  1.00  0.00           H  
ATOM   1072  HG3 LYS A 297       4.661   7.532  -3.916  1.00  0.00           H  
ATOM   1073  HD2 LYS A 297       6.262   7.274  -2.190  1.00  0.00           H  
ATOM   1074  HD3 LYS A 297       5.714   5.636  -1.829  1.00  0.00           H  
ATOM   1075  HE2 LYS A 297       6.427   5.042  -4.195  1.00  0.00           H  
ATOM   1076  HE3 LYS A 297       7.237   6.606  -4.235  1.00  0.00           H  
ATOM   1077  HZ1 LYS A 297       8.791   4.919  -3.589  1.00  0.00           H  
ATOM   1078  HZ2 LYS A 297       7.780   4.383  -2.343  1.00  0.00           H  
ATOM   1079  HZ3 LYS A 297       8.495   5.913  -2.253  1.00  0.00           H  
ATOM   1080  N   LEU A 298       0.818   5.716  -3.881  1.00  0.00           N  
ATOM   1081  CA  LEU A 298       0.325   4.853  -4.949  1.00  0.00           C  
ATOM   1082  C   LEU A 298      -0.573   5.630  -5.906  1.00  0.00           C  
ATOM   1083  O   LEU A 298      -1.751   5.855  -5.623  1.00  0.00           O  
ATOM   1084  CB  LEU A 298      -0.444   3.669  -4.359  1.00  0.00           C  
ATOM   1085  CG  LEU A 298      -1.372   2.926  -5.320  1.00  0.00           C  
ATOM   1086  CD1 LEU A 298      -0.587   1.918  -6.147  1.00  0.00           C  
ATOM   1087  CD2 LEU A 298      -2.490   2.234  -4.554  1.00  0.00           C  
ATOM   1088  H   LEU A 298       0.459   5.609  -2.976  1.00  0.00           H  
ATOM   1089  HA  LEU A 298       1.178   4.481  -5.496  1.00  0.00           H  
ATOM   1090  HB2 LEU A 298       0.279   2.960  -3.983  1.00  0.00           H  
ATOM   1091  HB3 LEU A 298      -1.042   4.039  -3.539  1.00  0.00           H  
ATOM   1092  HG  LEU A 298      -1.820   3.636  -6.000  1.00  0.00           H  
ATOM   1093 HD11 LEU A 298      -0.013   1.283  -5.491  1.00  0.00           H  
ATOM   1094 HD12 LEU A 298       0.078   2.442  -6.816  1.00  0.00           H  
ATOM   1095 HD13 LEU A 298      -1.274   1.313  -6.722  1.00  0.00           H  
ATOM   1096 HD21 LEU A 298      -2.474   1.176  -4.769  1.00  0.00           H  
ATOM   1097 HD22 LEU A 298      -3.441   2.648  -4.854  1.00  0.00           H  
ATOM   1098 HD23 LEU A 298      -2.349   2.389  -3.493  1.00  0.00           H  
ATOM   1099  N   ILE A 299      -0.010   6.035  -7.039  1.00  0.00           N  
ATOM   1100  CA  ILE A 299      -0.761   6.784  -8.039  1.00  0.00           C  
ATOM   1101  C   ILE A 299      -0.936   5.971  -9.317  1.00  0.00           C  
ATOM   1102  O   ILE A 299      -0.051   5.942 -10.172  1.00  0.00           O  
ATOM   1103  CB  ILE A 299      -0.069   8.117  -8.381  1.00  0.00           C  
ATOM   1104  CG1 ILE A 299       0.321   8.857  -7.100  1.00  0.00           C  
ATOM   1105  CG2 ILE A 299      -0.979   8.980  -9.243  1.00  0.00           C  
ATOM   1106  CD1 ILE A 299       1.055  10.156  -7.353  1.00  0.00           C  
ATOM   1107  H   ILE A 299       0.932   5.825  -7.207  1.00  0.00           H  
ATOM   1108  HA  ILE A 299      -1.737   7.002  -7.628  1.00  0.00           H  
ATOM   1109  HB  ILE A 299       0.822   7.898  -8.948  1.00  0.00           H  
ATOM   1110 HG12 ILE A 299      -0.570   9.085  -6.538  1.00  0.00           H  
ATOM   1111 HG13 ILE A 299       0.963   8.222  -6.508  1.00  0.00           H  
ATOM   1112 HG21 ILE A 299      -1.358   9.802  -8.653  1.00  0.00           H  
ATOM   1113 HG22 ILE A 299      -0.420   9.366 -10.081  1.00  0.00           H  
ATOM   1114 HG23 ILE A 299      -1.805   8.385  -9.604  1.00  0.00           H  
ATOM   1115 HD11 ILE A 299       0.910  10.456  -8.382  1.00  0.00           H  
ATOM   1116 HD12 ILE A 299       0.669  10.922  -6.698  1.00  0.00           H  
ATOM   1117 HD13 ILE A 299       2.108  10.017  -7.165  1.00  0.00           H  
ATOM   1118  N   VAL A 300      -2.085   5.315  -9.443  1.00  0.00           N  
ATOM   1119  CA  VAL A 300      -2.378   4.504 -10.619  1.00  0.00           C  
ATOM   1120  C   VAL A 300      -3.291   5.248 -11.585  1.00  0.00           C  
ATOM   1121  O   VAL A 300      -4.244   5.907 -11.172  1.00  0.00           O  
ATOM   1122  CB  VAL A 300      -3.039   3.169 -10.229  1.00  0.00           C  
ATOM   1123  CG1 VAL A 300      -3.347   2.343 -11.469  1.00  0.00           C  
ATOM   1124  CG2 VAL A 300      -2.148   2.393  -9.270  1.00  0.00           C  
ATOM   1125  H   VAL A 300      -2.751   5.378  -8.727  1.00  0.00           H  
ATOM   1126  HA  VAL A 300      -1.443   4.287 -11.116  1.00  0.00           H  
ATOM   1127  HB  VAL A 300      -3.971   3.385  -9.727  1.00  0.00           H  
ATOM   1128 HG11 VAL A 300      -2.423   2.022 -11.926  1.00  0.00           H  
ATOM   1129 HG12 VAL A 300      -3.932   1.479 -11.190  1.00  0.00           H  
ATOM   1130 HG13 VAL A 300      -3.905   2.944 -12.172  1.00  0.00           H  
ATOM   1131 HG21 VAL A 300      -1.366   1.898  -9.825  1.00  0.00           H  
ATOM   1132 HG22 VAL A 300      -1.709   3.075  -8.557  1.00  0.00           H  
ATOM   1133 HG23 VAL A 300      -2.739   1.656  -8.745  1.00  0.00           H  
ATOM   1134  N   ASN A 301      -2.994   5.137 -12.877  1.00  0.00           N  
ATOM   1135  CA  ASN A 301      -3.789   5.801 -13.903  1.00  0.00           C  
ATOM   1136  C   ASN A 301      -3.824   7.309 -13.675  1.00  0.00           C  
ATOM   1137  O   ASN A 301      -4.891   7.922 -13.675  1.00  0.00           O  
ATOM   1138  CB  ASN A 301      -5.213   5.241 -13.916  1.00  0.00           C  
ATOM   1139  CG  ASN A 301      -5.297   3.888 -14.594  1.00  0.00           C  
ATOM   1140  OD1 ASN A 301      -4.665   3.658 -15.626  1.00  0.00           O  
ATOM   1141  ND2 ASN A 301      -6.081   2.985 -14.018  1.00  0.00           N  
ATOM   1142  H   ASN A 301      -2.220   4.598 -13.144  1.00  0.00           H  
ATOM   1143  HA  ASN A 301      -3.326   5.604 -14.859  1.00  0.00           H  
ATOM   1144  HB2 ASN A 301      -5.560   5.134 -12.897  1.00  0.00           H  
ATOM   1145  HB3 ASN A 301      -5.859   5.929 -14.441  1.00  0.00           H  
ATOM   1146 HD21 ASN A 301      -6.555   3.238 -13.198  1.00  0.00           H  
ATOM   1147 HD22 ASN A 301      -6.153   2.101 -14.435  1.00  0.00           H  
ATOM   1148  N   GLY A 302      -2.650   7.901 -13.480  1.00  0.00           N  
ATOM   1149  CA  GLY A 302      -2.569   9.332 -13.254  1.00  0.00           C  
ATOM   1150  C   GLY A 302      -3.596   9.819 -12.252  1.00  0.00           C  
ATOM   1151  O   GLY A 302      -4.111  10.931 -12.372  1.00  0.00           O  
ATOM   1152  H   GLY A 302      -1.831   7.361 -13.491  1.00  0.00           H  
ATOM   1153  HA2 GLY A 302      -1.581   9.571 -12.888  1.00  0.00           H  
ATOM   1154  HA3 GLY A 302      -2.728   9.843 -14.193  1.00  0.00           H  
ATOM   1155  N   ARG A 303      -3.896   8.986 -11.261  1.00  0.00           N  
ATOM   1156  CA  ARG A 303      -4.871   9.336 -10.236  1.00  0.00           C  
ATOM   1157  C   ARG A 303      -4.393   8.893  -8.856  1.00  0.00           C  
ATOM   1158  O   ARG A 303      -4.426   7.707  -8.529  1.00  0.00           O  
ATOM   1159  CB  ARG A 303      -6.225   8.697 -10.549  1.00  0.00           C  
ATOM   1160  CG  ARG A 303      -7.323   9.087  -9.573  1.00  0.00           C  
ATOM   1161  CD  ARG A 303      -8.368   7.991  -9.443  1.00  0.00           C  
ATOM   1162  NE  ARG A 303      -9.635   8.502  -8.925  1.00  0.00           N  
ATOM   1163  CZ  ARG A 303      -9.798   8.935  -7.680  1.00  0.00           C  
ATOM   1164  NH1 ARG A 303      -8.781   8.922  -6.831  1.00  0.00           N  
ATOM   1165  NH2 ARG A 303     -10.982   9.385  -7.283  1.00  0.00           N  
ATOM   1166  H   ARG A 303      -3.452   8.113 -11.219  1.00  0.00           H  
ATOM   1167  HA  ARG A 303      -4.981  10.411 -10.238  1.00  0.00           H  
ATOM   1168  HB2 ARG A 303      -6.531   8.997 -11.540  1.00  0.00           H  
ATOM   1169  HB3 ARG A 303      -6.117   7.624 -10.524  1.00  0.00           H  
ATOM   1170  HG2 ARG A 303      -6.883   9.267  -8.603  1.00  0.00           H  
ATOM   1171  HG3 ARG A 303      -7.802   9.990  -9.926  1.00  0.00           H  
ATOM   1172  HD2 ARG A 303      -8.538   7.556 -10.417  1.00  0.00           H  
ATOM   1173  HD3 ARG A 303      -7.994   7.234  -8.771  1.00  0.00           H  
ATOM   1174  HE  ARG A 303     -10.400   8.520  -9.536  1.00  0.00           H  
ATOM   1175 HH11 ARG A 303      -7.888   8.584  -7.128  1.00  0.00           H  
ATOM   1176 HH12 ARG A 303      -8.907   9.251  -5.894  1.00  0.00           H  
ATOM   1177 HH21 ARG A 303     -11.752   9.397  -7.921  1.00  0.00           H  
ATOM   1178 HH22 ARG A 303     -11.104   9.711  -6.346  1.00  0.00           H  
ATOM   1179  N   ARG A 304      -3.949   9.853  -8.052  1.00  0.00           N  
ATOM   1180  CA  ARG A 304      -3.463   9.561  -6.709  1.00  0.00           C  
ATOM   1181  C   ARG A 304      -4.481   8.732  -5.931  1.00  0.00           C  
ATOM   1182  O   ARG A 304      -5.687   8.847  -6.148  1.00  0.00           O  
ATOM   1183  CB  ARG A 304      -3.166  10.860  -5.957  1.00  0.00           C  
ATOM   1184  CG  ARG A 304      -2.048  10.730  -4.935  1.00  0.00           C  
ATOM   1185  CD  ARG A 304      -2.142  11.808  -3.867  1.00  0.00           C  
ATOM   1186  NE  ARG A 304      -0.830  12.170  -3.338  1.00  0.00           N  
ATOM   1187  CZ  ARG A 304       0.135  12.711  -4.073  1.00  0.00           C  
ATOM   1188  NH1 ARG A 304      -0.065  12.952  -5.361  1.00  0.00           N  
ATOM   1189  NH2 ARG A 304       1.302  13.013  -3.519  1.00  0.00           N  
ATOM   1190  H   ARG A 304      -3.948  10.781  -8.370  1.00  0.00           H  
ATOM   1191  HA  ARG A 304      -2.550   8.993  -6.803  1.00  0.00           H  
ATOM   1192  HB2 ARG A 304      -2.884  11.620  -6.672  1.00  0.00           H  
ATOM   1193  HB3 ARG A 304      -4.061  11.176  -5.442  1.00  0.00           H  
ATOM   1194  HG2 ARG A 304      -2.118   9.762  -4.460  1.00  0.00           H  
ATOM   1195  HG3 ARG A 304      -1.099  10.818  -5.442  1.00  0.00           H  
ATOM   1196  HD2 ARG A 304      -2.600  12.686  -4.300  1.00  0.00           H  
ATOM   1197  HD3 ARG A 304      -2.759  11.442  -3.060  1.00  0.00           H  
ATOM   1198  HE  ARG A 304      -0.662  12.001  -2.388  1.00  0.00           H  
ATOM   1199 HH11 ARG A 304      -0.943  12.727  -5.781  1.00  0.00           H  
ATOM   1200 HH12 ARG A 304       0.664  13.361  -5.912  1.00  0.00           H  
ATOM   1201 HH21 ARG A 304       1.456  12.833  -2.548  1.00  0.00           H  
ATOM   1202 HH22 ARG A 304       2.028  13.420  -4.072  1.00  0.00           H  
ATOM   1203  N   LEU A 305      -3.986   7.895  -5.025  1.00  0.00           N  
ATOM   1204  CA  LEU A 305      -4.852   7.046  -4.215  1.00  0.00           C  
ATOM   1205  C   LEU A 305      -4.443   7.098  -2.746  1.00  0.00           C  
ATOM   1206  O   LEU A 305      -3.261   7.015  -2.416  1.00  0.00           O  
ATOM   1207  CB  LEU A 305      -4.800   5.602  -4.719  1.00  0.00           C  
ATOM   1208  CG  LEU A 305      -5.011   5.410  -6.221  1.00  0.00           C  
ATOM   1209  CD1 LEU A 305      -4.906   3.937  -6.590  1.00  0.00           C  
ATOM   1210  CD2 LEU A 305      -6.359   5.973  -6.648  1.00  0.00           C  
ATOM   1211  H   LEU A 305      -3.016   7.848  -4.898  1.00  0.00           H  
ATOM   1212  HA  LEU A 305      -5.861   7.416  -4.309  1.00  0.00           H  
ATOM   1213  HB2 LEU A 305      -3.832   5.198  -4.466  1.00  0.00           H  
ATOM   1214  HB3 LEU A 305      -5.567   5.045  -4.201  1.00  0.00           H  
ATOM   1215  HG  LEU A 305      -4.240   5.943  -6.759  1.00  0.00           H  
ATOM   1216 HD11 LEU A 305      -5.479   3.350  -5.890  1.00  0.00           H  
ATOM   1217 HD12 LEU A 305      -3.871   3.631  -6.555  1.00  0.00           H  
ATOM   1218 HD13 LEU A 305      -5.292   3.788  -7.588  1.00  0.00           H  
ATOM   1219 HD21 LEU A 305      -6.928   5.204  -7.148  1.00  0.00           H  
ATOM   1220 HD22 LEU A 305      -6.205   6.803  -7.321  1.00  0.00           H  
ATOM   1221 HD23 LEU A 305      -6.899   6.312  -5.776  1.00  0.00           H  
ATOM   1222  N   ASN A 306      -5.432   7.233  -1.868  1.00  0.00           N  
ATOM   1223  CA  ASN A 306      -5.177   7.294  -0.433  1.00  0.00           C  
ATOM   1224  C   ASN A 306      -5.198   5.898   0.183  1.00  0.00           C  
ATOM   1225  O   ASN A 306      -6.262   5.326   0.415  1.00  0.00           O  
ATOM   1226  CB  ASN A 306      -6.215   8.182   0.254  1.00  0.00           C  
ATOM   1227  CG  ASN A 306      -5.671   8.851   1.501  1.00  0.00           C  
ATOM   1228  OD1 ASN A 306      -4.484   8.743   1.809  1.00  0.00           O  
ATOM   1229  ND2 ASN A 306      -6.539   9.547   2.227  1.00  0.00           N  
ATOM   1230  H   ASN A 306      -6.355   7.294  -2.191  1.00  0.00           H  
ATOM   1231  HA  ASN A 306      -4.197   7.723  -0.289  1.00  0.00           H  
ATOM   1232  HB2 ASN A 306      -6.532   8.953  -0.434  1.00  0.00           H  
ATOM   1233  HB3 ASN A 306      -7.068   7.581   0.533  1.00  0.00           H  
ATOM   1234 HD21 ASN A 306      -7.469   9.588   1.922  1.00  0.00           H  
ATOM   1235 HD22 ASN A 306      -6.213   9.989   3.038  1.00  0.00           H  
ATOM   1236  N   VAL A 307      -4.014   5.356   0.447  1.00  0.00           N  
ATOM   1237  CA  VAL A 307      -3.895   4.028   1.038  1.00  0.00           C  
ATOM   1238  C   VAL A 307      -3.630   4.115   2.537  1.00  0.00           C  
ATOM   1239  O   VAL A 307      -2.821   4.924   2.990  1.00  0.00           O  
ATOM   1240  CB  VAL A 307      -2.765   3.218   0.375  1.00  0.00           C  
ATOM   1241  CG1 VAL A 307      -2.549   1.903   1.110  1.00  0.00           C  
ATOM   1242  CG2 VAL A 307      -3.079   2.971  -1.093  1.00  0.00           C  
ATOM   1243  H   VAL A 307      -3.199   5.861   0.240  1.00  0.00           H  
ATOM   1244  HA  VAL A 307      -4.826   3.506   0.876  1.00  0.00           H  
ATOM   1245  HB  VAL A 307      -1.854   3.793   0.436  1.00  0.00           H  
ATOM   1246 HG11 VAL A 307      -1.779   1.334   0.610  1.00  0.00           H  
ATOM   1247 HG12 VAL A 307      -2.246   2.105   2.127  1.00  0.00           H  
ATOM   1248 HG13 VAL A 307      -3.469   1.338   1.114  1.00  0.00           H  
ATOM   1249 HG21 VAL A 307      -2.261   3.330  -1.701  1.00  0.00           H  
ATOM   1250 HG22 VAL A 307      -3.213   1.913  -1.259  1.00  0.00           H  
ATOM   1251 HG23 VAL A 307      -3.984   3.496  -1.361  1.00  0.00           H  
ATOM   1252  N   LYS A 308      -4.318   3.276   3.303  1.00  0.00           N  
ATOM   1253  CA  LYS A 308      -4.159   3.255   4.752  1.00  0.00           C  
ATOM   1254  C   LYS A 308      -4.331   1.841   5.299  1.00  0.00           C  
ATOM   1255  O   LYS A 308      -5.102   1.047   4.760  1.00  0.00           O  
ATOM   1256  CB  LYS A 308      -5.171   4.194   5.411  1.00  0.00           C  
ATOM   1257  CG  LYS A 308      -6.496   4.276   4.673  1.00  0.00           C  
ATOM   1258  CD  LYS A 308      -7.499   5.138   5.421  1.00  0.00           C  
ATOM   1259  CE  LYS A 308      -8.628   5.596   4.511  1.00  0.00           C  
ATOM   1260  NZ  LYS A 308      -9.294   6.824   5.028  1.00  0.00           N  
ATOM   1261  H   LYS A 308      -4.950   2.653   2.883  1.00  0.00           H  
ATOM   1262  HA  LYS A 308      -3.160   3.597   4.980  1.00  0.00           H  
ATOM   1263  HB2 LYS A 308      -5.363   3.848   6.416  1.00  0.00           H  
ATOM   1264  HB3 LYS A 308      -4.747   5.187   5.457  1.00  0.00           H  
ATOM   1265  HG2 LYS A 308      -6.328   4.704   3.696  1.00  0.00           H  
ATOM   1266  HG3 LYS A 308      -6.900   3.279   4.567  1.00  0.00           H  
ATOM   1267  HD2 LYS A 308      -7.918   4.564   6.234  1.00  0.00           H  
ATOM   1268  HD3 LYS A 308      -6.990   6.006   5.815  1.00  0.00           H  
ATOM   1269  HE2 LYS A 308      -8.222   5.802   3.532  1.00  0.00           H  
ATOM   1270  HE3 LYS A 308      -9.358   4.804   4.438  1.00  0.00           H  
ATOM   1271  HZ1 LYS A 308      -9.347   7.544   4.279  1.00  0.00           H  
ATOM   1272  HZ2 LYS A 308      -8.755   7.211   5.829  1.00  0.00           H  
ATOM   1273  HZ3 LYS A 308     -10.257   6.600   5.348  1.00  0.00           H  
ATOM   1274  N   TRP A 309      -3.609   1.535   6.370  1.00  0.00           N  
ATOM   1275  CA  TRP A 309      -3.682   0.217   6.990  1.00  0.00           C  
ATOM   1276  C   TRP A 309      -5.121  -0.133   7.356  1.00  0.00           C  
ATOM   1277  O   TRP A 309      -5.890   0.729   7.779  1.00  0.00           O  
ATOM   1278  CB  TRP A 309      -2.799   0.166   8.237  1.00  0.00           C  
ATOM   1279  CG  TRP A 309      -1.343  -0.007   7.928  1.00  0.00           C  
ATOM   1280  CD1 TRP A 309      -0.343   0.894   8.160  1.00  0.00           C  
ATOM   1281  CD2 TRP A 309      -0.724  -1.149   7.325  1.00  0.00           C  
ATOM   1282  NE1 TRP A 309       0.860   0.380   7.740  1.00  0.00           N  
ATOM   1283  CE2 TRP A 309       0.653  -0.872   7.224  1.00  0.00           C  
ATOM   1284  CE3 TRP A 309      -1.200  -2.379   6.863  1.00  0.00           C  
ATOM   1285  CZ2 TRP A 309       1.556  -1.781   6.679  1.00  0.00           C  
ATOM   1286  CZ3 TRP A 309      -0.302  -3.280   6.322  1.00  0.00           C  
ATOM   1287  CH2 TRP A 309       1.063  -2.977   6.234  1.00  0.00           C  
ATOM   1288  H   TRP A 309      -3.011   2.210   6.755  1.00  0.00           H  
ATOM   1289  HA  TRP A 309      -3.321  -0.507   6.274  1.00  0.00           H  
ATOM   1290  HB2 TRP A 309      -2.915   1.085   8.791  1.00  0.00           H  
ATOM   1291  HB3 TRP A 309      -3.110  -0.663   8.856  1.00  0.00           H  
ATOM   1292  HD1 TRP A 309      -0.491   1.864   8.610  1.00  0.00           H  
ATOM   1293  HE1 TRP A 309       1.726   0.835   7.801  1.00  0.00           H  
ATOM   1294  HE3 TRP A 309      -2.249  -2.630   6.922  1.00  0.00           H  
ATOM   1295  HZ2 TRP A 309       2.612  -1.564   6.605  1.00  0.00           H  
ATOM   1296  HZ3 TRP A 309      -0.651  -4.235   5.958  1.00  0.00           H  
ATOM   1297  HH2 TRP A 309       1.728  -3.711   5.805  1.00  0.00           H  
ATOM   1298  N   GLY A 310      -5.478  -1.403   7.192  1.00  0.00           N  
ATOM   1299  CA  GLY A 310      -6.824  -1.843   7.511  1.00  0.00           C  
ATOM   1300  C   GLY A 310      -6.941  -2.371   8.926  1.00  0.00           C  
ATOM   1301  O   GLY A 310      -6.425  -1.766   9.866  1.00  0.00           O  
ATOM   1302  H   GLY A 310      -4.822  -2.047   6.851  1.00  0.00           H  
ATOM   1303  HA2 GLY A 310      -7.500  -1.010   7.390  1.00  0.00           H  
ATOM   1304  HA3 GLY A 310      -7.106  -2.626   6.822  1.00  0.00           H  
ATOM   1305  N   ARG A 311      -7.623  -3.501   9.080  1.00  0.00           N  
ATOM   1306  CA  ARG A 311      -7.809  -4.108  10.392  1.00  0.00           C  
ATOM   1307  C   ARG A 311      -7.226  -5.518  10.427  1.00  0.00           C  
ATOM   1308  O   ARG A 311      -6.940  -6.056  11.497  1.00  0.00           O  
ATOM   1309  CB  ARG A 311      -9.296  -4.152  10.751  1.00  0.00           C  
ATOM   1310  CG  ARG A 311      -9.872  -2.794  11.121  1.00  0.00           C  
ATOM   1311  CD  ARG A 311      -9.499  -2.398  12.541  1.00  0.00           C  
ATOM   1312  NE  ARG A 311      -9.816  -1.000  12.820  1.00  0.00           N  
ATOM   1313  CZ  ARG A 311      -8.993   0.007  12.550  1.00  0.00           C  
ATOM   1314  NH1 ARG A 311      -7.811  -0.227  11.999  1.00  0.00           N  
ATOM   1315  NH2 ARG A 311      -9.352   1.253  12.834  1.00  0.00           N  
ATOM   1316  H   ARG A 311      -8.011  -3.936   8.293  1.00  0.00           H  
ATOM   1317  HA  ARG A 311      -7.291  -3.499  11.117  1.00  0.00           H  
ATOM   1318  HB2 ARG A 311      -9.848  -4.535   9.906  1.00  0.00           H  
ATOM   1319  HB3 ARG A 311      -9.432  -4.816  11.591  1.00  0.00           H  
ATOM   1320  HG2 ARG A 311      -9.487  -2.052  10.439  1.00  0.00           H  
ATOM   1321  HG3 ARG A 311     -10.949  -2.837  11.040  1.00  0.00           H  
ATOM   1322  HD2 ARG A 311     -10.045  -3.025  13.231  1.00  0.00           H  
ATOM   1323  HD3 ARG A 311      -8.439  -2.552  12.676  1.00  0.00           H  
ATOM   1324  HE  ARG A 311     -10.685  -0.804  13.228  1.00  0.00           H  
ATOM   1325 HH11 ARG A 311      -7.538  -1.165  11.783  1.00  0.00           H  
ATOM   1326 HH12 ARG A 311      -7.193   0.533  11.796  1.00  0.00           H  
ATOM   1327 HH21 ARG A 311     -10.243   1.434  13.250  1.00  0.00           H  
ATOM   1328 HH22 ARG A 311      -8.732   2.011  12.632  1.00  0.00           H  
TER    1329      ARG A 311                                                      
END
MOLECULE T0437.pdb
ATOM    365  N   ASP    24      -1.217  -3.430  12.771  1.00 32.15           N  
ATOM    366  CA  ASP    24      -2.558  -3.784  13.227  1.00 11.24           C  
ATOM    367  C   ASP    24      -3.077  -4.985  12.447  1.00  3.52           C  
ATOM    368  O   ASP    24      -3.558  -5.955  13.031  1.00 72.30           O  
ATOM    369  CB  ASP    24      -3.550  -2.622  13.081  1.00 55.51           C  
ATOM    370  CG  ASP    24      -4.808  -2.840  13.907  1.00 50.34           C  
ATOM    371  OD1 ASP    24      -4.721  -2.781  15.153  1.00 45.42           O  
ATOM    372  OD2 ASP    24      -5.894  -3.051  13.323  1.00 64.32           O  
ATOM    373  H   ASP    24      -0.799  -3.973  12.068  1.00 54.01           H  
ATOM    374  HA  ASP    24      -2.484  -4.056  14.271  1.00 33.12           H  
ATOM    375  HB2 ASP    24      -3.078  -1.707  13.409  1.00 36.92           H  
ATOM    376  HB3 ASP    24      -3.834  -2.526  12.043  1.00 36.92           H  
ATOM    377  N   ASN    25      -2.962  -4.924  11.121  1.00 30.54           N  
ATOM    378  CA  ASN    25      -3.508  -5.964  10.256  1.00 13.41           C  
ATOM    379  C   ASN    25      -2.460  -6.507   9.295  1.00 63.53           C  
ATOM    380  O   ASN    25      -1.296  -6.099   9.311  1.00 14.31           O  
ATOM    381  CB  ASN    25      -4.679  -5.420   9.426  1.00 24.42           C  
ATOM    382  CG  ASN    25      -5.829  -4.927  10.269  1.00 32.35           C  
ATOM    383  OD1 ASN    25      -6.706  -5.697  10.646  1.00 43.01           O  
ATOM    384  ND2 ASN    25      -5.853  -3.633  10.534  1.00 44.23           N  
ATOM    385  H   ASN    25      -2.501  -4.158  10.709  1.00 41.11           H  
ATOM    386  HA  ASN    25      -3.864  -6.769  10.879  1.00 52.21           H  
ATOM    387  HB2 ASN    25      -4.327  -4.598   8.822  1.00 36.92           H  
ATOM    388  HB3 ASN    25      -5.043  -6.204   8.776  1.00 36.92           H  
ATOM    389 HD21 ASN    25      -5.133  -3.072  10.171  1.00 36.92           H  
ATOM    390 HD22 ASN    25      -6.577  -3.287  11.100  1.00 36.92           H  
ATOM    391  N   CYS    26      -2.899  -7.447   8.473  1.00 31.24           N  
ATOM    392  CA  CYS    26      -2.129  -7.926   7.338  1.00 12.34           C  
ATOM    393  C   CYS    26      -2.935  -7.685   6.063  1.00 73.22           C  
ATOM    394  O   CYS    26      -2.415  -7.757   4.950  1.00 24.23           O  
ATOM    395  CB  CYS    26      -1.796  -9.411   7.499  1.00 72.14           C  
ATOM    396  SG  CYS    26      -3.233 -10.466   7.786  1.00  1.02           S  
ATOM    397  H   CYS    26      -3.780  -7.844   8.643  1.00 23.14           H  
ATOM    398  HA  CYS    26      -1.212  -7.355   7.290  1.00 54.15           H  
ATOM    399  HB2 CYS    26      -1.310  -9.763   6.603  1.00 36.92           H  
ATOM    400  HB3 CYS    26      -1.127  -9.535   8.338  1.00 36.92           H  
ATOM    401  HG  CYS    26      -2.885 -11.712   7.486  1.00 33.31           H  
ATOM    402  N   THR    27      -4.221  -7.404   6.252  1.00  2.42           N  
ATOM    403  CA  THR    27      -5.103  -7.020   5.167  1.00 14.14           C  
ATOM    404  C   THR    27      -5.241  -5.501   5.133  1.00 42.33           C  
ATOM    405  O   THR    27      -5.709  -4.893   6.102  1.00 22.32           O  
ATOM    406  CB  THR    27      -6.496  -7.663   5.341  1.00 43.41           C  
ATOM    407  OG1 THR    27      -6.380  -9.092   5.329  1.00  1.24           O  
ATOM    408  CG2 THR    27      -7.455  -7.221   4.244  1.00  1.25           C  
ATOM    409  H   THR    27      -4.589  -7.460   7.160  1.00 62.31           H  
ATOM    410  HA  THR    27      -4.674  -7.363   4.237  1.00 23.45           H  
ATOM    411  HB  THR    27      -6.899  -7.353   6.294  1.00 23.25           H  
ATOM    412  HG1 THR    27      -6.285  -9.415   6.235  1.00 70.53           H  
ATOM    413 HG21 THR    27      -8.407  -7.714   4.375  1.00 36.92           H  
ATOM    414 HG22 THR    27      -7.044  -7.482   3.280  1.00 36.92           H  
ATOM    415 HG23 THR    27      -7.593  -6.151   4.298  1.00 36.92           H  
ATOM    416  N   SER    28      -4.839  -4.888   4.027  1.00 33.44           N  
ATOM    417  CA  SER    28      -4.883  -3.439   3.911  1.00 41.41           C  
ATOM    418  C   SER    28      -6.138  -3.018   3.169  1.00  3.25           C  
ATOM    419  O   SER    28      -6.628  -3.746   2.308  1.00  4.43           O  
ATOM    420  CB  SER    28      -3.645  -2.908   3.181  1.00 70.44           C  
ATOM    421  OG  SER    28      -3.551  -1.502   3.323  1.00  3.01           O  
ATOM    422  H   SER    28      -4.524  -5.424   3.263  1.00 11.31           H  
ATOM    423  HA  SER    28      -4.911  -3.026   4.909  1.00 33.32           H  
ATOM    424  HB2 SER    28      -2.757  -3.363   3.593  1.00 36.92           H  
ATOM    425  HB3 SER    28      -3.718  -3.149   2.130  1.00 36.92           H  
ATOM    426  HG  SER    28      -2.992  -1.130   2.615  1.00  3.41           H  
ATOM    427  N   LYS    29      -6.662  -1.853   3.509  1.00 34.41           N  
ATOM    428  CA  LYS    29      -7.877  -1.356   2.890  1.00 11.21           C  
ATOM    429  C   LYS    29      -7.593  -0.009   2.265  1.00 12.41           C  
ATOM    430  O   LYS    29      -7.319   0.971   2.962  1.00 14.44           O  
ATOM    431  CB  LYS    29      -9.024  -1.202   3.893  1.00 31.01           C  
ATOM    432  CG  LYS    29      -9.044  -2.231   5.007  1.00 24.44           C  
ATOM    433  CD  LYS    29      -8.016  -1.879   6.067  1.00 42.42           C  
ATOM    434  CE  LYS    29      -8.275  -2.586   7.387  1.00 72.54           C  
ATOM    435  NZ  LYS    29      -8.114  -4.060   7.277  1.00 24.34           N  
ATOM    436  H   LYS    29      -6.209  -1.302   4.180  1.00  5.13           H  
ATOM    437  HA  LYS    29      -8.168  -2.052   2.115  1.00 14.03           H  
ATOM    438  HB2 LYS    29      -8.955  -0.226   4.347  1.00 36.92           H  
ATOM    439  HB3 LYS    29      -9.961  -1.269   3.359  1.00 36.92           H  
ATOM    440  HG2 LYS    29     -10.025  -2.248   5.451  1.00 36.92           H  
ATOM    441  HG3 LYS    29      -8.811  -3.204   4.597  1.00 36.92           H  
ATOM    442  HD2 LYS    29      -7.038  -2.166   5.706  1.00 36.92           H  
ATOM    443  HD3 LYS    29      -8.040  -0.811   6.215  1.00 36.92           H  
ATOM    444  HE2 LYS    29      -7.580  -2.212   8.123  1.00 36.92           H  
ATOM    445  HE3 LYS    29      -9.284  -2.365   7.704  1.00 36.92           H  
ATOM    446  HZ1 LYS    29      -7.150  -4.297   6.962  1.00 36.92           H  
ATOM    447  HZ2 LYS    29      -8.798  -4.448   6.588  1.00 36.92           H  
ATOM    448  HZ3 LYS    29      -8.288  -4.508   8.205  1.00 36.92           H  
ATOM    449  N   PHE    30      -7.655   0.034   0.964  1.00 52.14           N  
ATOM    450  CA  PHE    30      -7.342   1.246   0.228  1.00 74.42           C  
ATOM    451  C   PHE    30      -8.617   1.916  -0.259  1.00 75.21           C  
ATOM    452  O   PHE    30      -9.343   1.360  -1.081  1.00  2.21           O  
ATOM    453  CB  PHE    30      -6.425   0.925  -0.957  1.00 63.54           C  
ATOM    454  CG  PHE    30      -6.093   2.118  -1.810  1.00 64.50           C  
ATOM    455  CD1 PHE    30      -5.122   3.024  -1.413  1.00 43.31           C  
ATOM    456  CD2 PHE    30      -6.755   2.335  -3.009  1.00 42.02           C  
ATOM    457  CE1 PHE    30      -4.818   4.122  -2.194  1.00 25.13           C  
ATOM    458  CE2 PHE    30      -6.455   3.432  -3.794  1.00 72.40           C  
ATOM    459  CZ  PHE    30      -5.485   4.326  -3.386  1.00 61.32           C  
ATOM    460  H   PHE    30      -7.942  -0.770   0.485  1.00 44.02           H  
ATOM    461  HA  PHE    30      -6.829   1.918   0.898  1.00 62.01           H  
ATOM    462  HB2 PHE    30      -5.497   0.518  -0.584  1.00 36.92           H  
ATOM    463  HB3 PHE    30      -6.907   0.189  -1.585  1.00 36.92           H  
ATOM    464  HD1 PHE    30      -4.599   2.867  -0.481  1.00 63.41           H  
ATOM    465  HD2 PHE    30      -7.516   1.637  -3.329  1.00  2.43           H  
ATOM    466  HE1 PHE    30      -4.059   4.820  -1.873  1.00 51.40           H  
ATOM    467  HE2 PHE    30      -6.977   3.588  -4.726  1.00  0.03           H  
ATOM    468  HZ  PHE    30      -5.250   5.185  -3.999  1.00 35.04           H  
ATOM    469  N   SER    31      -8.867   3.118   0.237  1.00 74.32           N  
ATOM    470  CA  SER    31     -10.047   3.876  -0.141  1.00 73.15           C  
ATOM    471  C   SER    31      -9.680   5.137  -0.908  1.00 74.03           C  
ATOM    472  O   SER    31      -8.747   5.860  -0.543  1.00  5.31           O  
ATOM    473  CB  SER    31     -10.858   4.239   1.103  1.00  0.34           C  
ATOM    474  OG  SER    31     -10.003   4.439   2.220  1.00 44.25           O  
ATOM    475  H   SER    31      -8.253   3.498   0.892  1.00 63.34           H  
ATOM    476  HA  SER    31     -10.652   3.249  -0.778  1.00 42.22           H  
ATOM    477  HB2 SER    31     -11.401   5.154   0.916  1.00 36.92           H  
ATOM    478  HB3 SER    31     -11.556   3.446   1.328  1.00 36.92           H  
ATOM    479  HG  SER    31     -10.076   3.677   2.815  1.00 62.22           H  
ATOM    480  N   ARG    32     -10.409   5.372  -1.982  1.00 34.33           N  
ATOM    481  CA  ARG    32     -10.290   6.587  -2.767  1.00 13.22           C  
ATOM    482  C   ARG    32     -11.656   6.967  -3.312  1.00 30.12           C  
ATOM    483  O   ARG    32     -12.485   6.098  -3.590  1.00  1.53           O  
ATOM    484  CB  ARG    32      -9.293   6.400  -3.914  1.00 72.21           C  
ATOM    485  CG  ARG    32      -7.900   6.946  -3.627  1.00 15.03           C  
ATOM    486  CD  ARG    32      -7.783   8.424  -3.980  1.00 21.11           C  
ATOM    487  NE  ARG    32      -8.659   9.273  -3.169  1.00 34.31           N  
ATOM    488  CZ  ARG    32      -9.089  10.477  -3.550  1.00 74.52           C  
ATOM    489  NH1 ARG    32      -8.702  10.996  -4.708  1.00 22.20           N  
ATOM    490  NH2 ARG    32      -9.890  11.175  -2.752  1.00 10.25           N  
ATOM    491  H   ARG    32     -11.061   4.688  -2.268  1.00 61.53           H  
ATOM    492  HA  ARG    32      -9.940   7.373  -2.115  1.00 13.20           H  
ATOM    493  HB2 ARG    32      -9.204   5.346  -4.123  1.00 36.92           H  
ATOM    494  HB3 ARG    32      -9.677   6.898  -4.791  1.00 36.92           H  
ATOM    495  HG2 ARG    32      -7.683   6.821  -2.577  1.00 36.92           H  
ATOM    496  HG3 ARG    32      -7.182   6.390  -4.211  1.00 36.92           H  
ATOM    497  HD2 ARG    32      -6.759   8.734  -3.827  1.00 36.92           H  
ATOM    498  HD3 ARG    32      -8.040   8.550  -5.021  1.00 36.92           H  
ATOM    499  HE  ARG    32      -8.933   8.926  -2.287  1.00 22.31           H  
ATOM    500 HH11 ARG    32      -8.075  10.485  -5.314  1.00 36.92           H  
ATOM    501 HH12 ARG    32      -9.017  11.913  -4.987  1.00 36.92           H  
ATOM    502 HH21 ARG    32     -10.166  10.801  -1.861  1.00 36.92           H  
ATOM    503 HH22 ARG    32     -10.226  12.085  -3.037  1.00 36.92           H  
ATOM    504  N   PHE    33     -11.893   8.257  -3.446  1.00 12.54           N  
ATOM    505  CA  PHE    33     -13.175   8.746  -3.916  1.00 11.05           C  
ATOM    506  C   PHE    33     -13.030   9.297  -5.322  1.00 55.33           C  
ATOM    507  O   PHE    33     -12.193  10.165  -5.578  1.00 62.12           O  
ATOM    508  CB  PHE    33     -13.716   9.827  -2.977  1.00  2.45           C  
ATOM    509  CG  PHE    33     -13.665   9.442  -1.522  1.00  1.40           C  
ATOM    510  CD1 PHE    33     -14.492   8.449  -1.023  1.00  3.52           C  
ATOM    511  CD2 PHE    33     -12.783  10.069  -0.656  1.00 73.01           C  
ATOM    512  CE1 PHE    33     -14.440   8.090   0.312  1.00 11.30           C  
ATOM    513  CE2 PHE    33     -12.728   9.714   0.678  1.00 34.42           C  
ATOM    514  CZ  PHE    33     -13.558   8.724   1.163  1.00 42.15           C  
ATOM    515  H   PHE    33     -11.185   8.898  -3.238  1.00 14.11           H  
ATOM    516  HA  PHE    33     -13.864   7.914  -3.934  1.00 32.42           H  
ATOM    517  HB2 PHE    33     -13.137  10.726  -3.104  1.00 36.92           H  
ATOM    518  HB3 PHE    33     -14.747  10.029  -3.231  1.00 36.92           H  
ATOM    519  HD1 PHE    33     -15.183   7.953  -1.687  1.00 41.41           H  
ATOM    520  HD2 PHE    33     -12.132  10.845  -1.031  1.00 72.44           H  
ATOM    521  HE1 PHE    33     -15.091   7.314   0.688  1.00 12.34           H  
ATOM    522  HE2 PHE    33     -12.035  10.211   1.343  1.00 62.42           H  
ATOM    523  HZ  PHE    33     -13.517   8.446   2.206  1.00  5.22           H  
ATOM    524  N   PHE    34     -13.832   8.783  -6.232  1.00 32.11           N  
ATOM    525  CA  PHE    34     -13.750   9.181  -7.627  1.00  1.22           C  
ATOM    526  C   PHE    34     -15.068   9.782  -8.075  1.00 23.44           C  
ATOM    527  O   PHE    34     -16.074   9.649  -7.383  1.00 51.45           O  
ATOM    528  CB  PHE    34     -13.392   7.981  -8.498  1.00 31.22           C  
ATOM    529  CG  PHE    34     -12.063   7.371  -8.150  1.00 51.33           C  
ATOM    530  CD1 PHE    34     -10.884   7.944  -8.604  1.00 14.42           C  
ATOM    531  CD2 PHE    34     -11.993   6.229  -7.369  1.00 64.14           C  
ATOM    532  CE1 PHE    34      -9.662   7.387  -8.285  1.00  2.41           C  
ATOM    533  CE2 PHE    34     -10.772   5.669  -7.048  1.00 51.32           C  
ATOM    534  CZ  PHE    34      -9.606   6.249  -7.506  1.00 32.24           C  
ATOM    535  H   PHE    34     -14.509   8.124  -5.958  1.00  3.15           H  
ATOM    536  HA  PHE    34     -12.975   9.926  -7.719  1.00 13.43           H  
ATOM    537  HB2 PHE    34     -14.152   7.221  -8.382  1.00 36.92           H  
ATOM    538  HB3 PHE    34     -13.356   8.293  -9.532  1.00 36.92           H  
ATOM    539  HD1 PHE    34     -10.927   8.836  -9.212  1.00 23.34           H  
ATOM    540  HD2 PHE    34     -12.904   5.776  -7.008  1.00 55.40           H  
ATOM    541  HE1 PHE    34      -8.750   7.841  -8.645  1.00  4.21           H  
ATOM    542  HE2 PHE    34     -10.728   4.778  -6.438  1.00 43.52           H  
ATOM    543  HZ  PHE    34      -8.651   5.811  -7.258  1.00 60.55           H  
ATOM    544  N   ALA    35     -15.059  10.445  -9.223  1.00 41.43           N  
ATOM    545  CA  ALA    35     -16.262  11.091  -9.739  1.00 35.44           C  
ATOM    546  C   ALA    35     -17.209  10.081 -10.376  1.00 12.23           C  
ATOM    547  O   ALA    35     -18.426  10.269 -10.368  1.00  3.53           O  
ATOM    548  CB  ALA    35     -15.895  12.179 -10.734  1.00 10.24           C  
ATOM    549  H   ALA    35     -14.222  10.509  -9.734  1.00 32.10           H  
ATOM    550  HA  ALA    35     -16.766  11.557  -8.907  1.00 65.13           H  
ATOM    551  HB1 ALA    35     -16.787  12.711 -11.032  1.00 36.92           H  
ATOM    552  HB2 ALA    35     -15.435  11.733 -11.604  1.00 36.92           H  
ATOM    553  HB3 ALA    35     -15.203  12.867 -10.274  1.00 36.92           H  
ATOM    554  N   THR    36     -16.655   9.015 -10.931  1.00 23.34           N  
ATOM    555  CA  THR    36     -17.470   7.980 -11.544  1.00 51.01           C  
ATOM    556  C   THR    36     -17.045   6.607 -11.049  1.00 43.30           C  
ATOM    557  O   THR    36     -15.901   6.418 -10.624  1.00  5.14           O  
ATOM    558  CB  THR    36     -17.358   7.997 -13.082  1.00 13.34           C  
ATOM    559  OG1 THR    36     -15.991   7.818 -13.472  1.00 31.33           O  
ATOM    560  CG2 THR    36     -17.895   9.295 -13.669  1.00 12.13           C  
ATOM    561  H   THR    36     -15.680   8.919 -10.930  1.00 11.05           H  
ATOM    562  HA  THR    36     -18.500   8.153 -11.272  1.00 24.33           H  
ATOM    563  HB  THR    36     -17.942   7.177 -13.475  1.00 62.24           H  
ATOM    564  HG1 THR    36     -15.774   8.439 -14.184  1.00 51.32           H  
ATOM    565 HG21 THR    36     -17.783   9.276 -14.743  1.00 36.92           H  
ATOM    566 HG22 THR    36     -17.341  10.129 -13.264  1.00 36.92           H  
ATOM    567 HG23 THR    36     -18.940   9.401 -13.417  1.00 36.92           H  
ATOM    568  N   ARG    37     -17.964   5.653 -11.105  1.00  3.51           N  
ATOM    569  CA  ARG    37     -17.648   4.269 -10.789  1.00 24.40           C  
ATOM    570  C   ARG    37     -16.613   3.737 -11.780  1.00 72.31           C  
ATOM    571  O   ARG    37     -15.833   2.837 -11.462  1.00 55.35           O  
ATOM    572  CB  ARG    37     -18.924   3.422 -10.804  1.00  2.52           C  
ATOM    573  CG  ARG    37     -18.675   1.925 -10.730  1.00 45.12           C  
ATOM    574  CD  ARG    37     -19.979   1.152 -10.685  1.00 43.11           C  
ATOM    575  NE  ARG    37     -19.758  -0.288 -10.589  1.00 74.04           N  
ATOM    576  CZ  ARG    37     -20.451  -1.088  -9.782  1.00 42.35           C  
ATOM    577  NH1 ARG    37     -21.353  -0.577  -8.950  1.00 25.52           N  
ATOM    578  NH2 ARG    37     -20.229  -2.397  -9.786  1.00 54.14           N  
ATOM    579  H   ARG    37     -18.888   5.891 -11.359  1.00 10.41           H  
ATOM    580  HA  ARG    37     -17.221   4.246  -9.796  1.00 21.43           H  
ATOM    581  HB2 ARG    37     -19.530   3.702  -9.955  1.00 36.92           H  
ATOM    582  HB3 ARG    37     -19.475   3.632 -11.707  1.00 36.92           H  
ATOM    583  HG2 ARG    37     -18.115   1.618 -11.601  1.00 36.92           H  
ATOM    584  HG3 ARG    37     -18.105   1.708  -9.837  1.00 36.92           H  
ATOM    585  HD2 ARG    37     -20.547   1.477  -9.825  1.00 36.92           H  
ATOM    586  HD3 ARG    37     -20.539   1.362 -11.585  1.00 36.92           H  
ATOM    587  HE  ARG    37     -19.061  -0.678 -11.172  1.00 14.05           H  
ATOM    588 HH11 ARG    37     -21.521   0.418  -8.927  1.00 36.92           H  
ATOM    589 HH12 ARG    37     -21.866  -1.180  -8.329  1.00 36.92           H  
ATOM    590 HH21 ARG    37     -19.533  -2.794 -10.399  1.00 36.92           H  
ATOM    591 HH22 ARG    37     -20.769  -3.002  -9.183  1.00 36.92           H  
ATOM    592  N   GLU    38     -16.602   4.325 -12.973  1.00 14.40           N  
ATOM    593  CA  GLU    38     -15.581   4.032 -13.969  1.00 15.45           C  
ATOM    594  C   GLU    38     -14.200   4.347 -13.421  1.00  3.11           C  
ATOM    595  O   GLU    38     -13.309   3.502 -13.439  1.00 72.21           O  
ATOM    596  CB  GLU    38     -15.814   4.858 -15.223  1.00 64.21           C  
ATOM    597  CG  GLU    38     -17.079   4.500 -15.969  1.00 62.14           C  
ATOM    598  CD  GLU    38     -17.275   5.367 -17.191  1.00  2.33           C  
ATOM    599  OE1 GLU    38     -16.436   5.296 -18.114  1.00 74.31           O  
ATOM    600  OE2 GLU    38     -18.261   6.124 -17.232  1.00  2.14           O  
ATOM    601  H   GLU    38     -17.302   4.974 -13.190  1.00 42.23           H  
ATOM    602  HA  GLU    38     -15.637   2.983 -14.216  1.00 33.10           H  
ATOM    603  HB2 GLU    38     -15.869   5.901 -14.947  1.00 36.92           H  
ATOM    604  HB3 GLU    38     -14.977   4.716 -15.886  1.00 36.92           H  
ATOM    605  HG2 GLU    38     -17.018   3.468 -16.277  1.00 36.92           H  
ATOM    606  HG3 GLU    38     -17.923   4.632 -15.308  1.00 36.92           H  
ATOM    607  N   GLU    39     -14.041   5.573 -12.934  1.00 32.12           N  
ATOM    608  CA  GLU    39     -12.795   6.019 -12.318  1.00 42.12           C  
ATOM    609  C   GLU    39     -12.352   5.058 -11.220  1.00 31.43           C  
ATOM    610  O   GLU    39     -11.159   4.832 -11.022  1.00  2.11           O  
ATOM    611  CB  GLU    39     -12.987   7.417 -11.730  1.00 35.53           C  
ATOM    612  CG  GLU    39     -13.006   8.527 -12.761  1.00  1.50           C  
ATOM    613  CD  GLU    39     -11.630   8.822 -13.316  1.00 55.23           C  
ATOM    614  OE1 GLU    39     -10.892   9.612 -12.684  1.00 51.31           O  
ATOM    615  OE2 GLU    39     -11.276   8.263 -14.372  1.00 14.10           O  
ATOM    616  H   GLU    39     -14.791   6.208 -13.000  1.00 33.31           H  
ATOM    617  HA  GLU    39     -12.034   6.056 -13.082  1.00 32.33           H  
ATOM    618  HB2 GLU    39     -13.926   7.438 -11.199  1.00 36.92           H  
ATOM    619  HB3 GLU    39     -12.187   7.615 -11.033  1.00 36.92           H  
ATOM    620  HG2 GLU    39     -13.654   8.234 -13.574  1.00 36.92           H  
ATOM    621  HG3 GLU    39     -13.394   9.422 -12.299  1.00 36.92           H  
ATOM    622  N   ALA    40     -13.324   4.482 -10.528  1.00 15.32           N  
ATOM    623  CA  ALA    40     -13.043   3.557  -9.439  1.00 54.43           C  
ATOM    624  C   ALA    40     -12.469   2.248  -9.972  1.00 33.33           C  
ATOM    625  O   ALA    40     -11.409   1.798  -9.538  1.00 20.01           O  
ATOM    626  CB  ALA    40     -14.303   3.297  -8.623  1.00 33.21           C  
ATOM    627  H   ALA    40     -14.257   4.677 -10.764  1.00 53.43           H  
ATOM    628  HA  ALA    40     -12.314   4.019  -8.790  1.00 31.22           H  
ATOM    629  HB1 ALA    40     -14.059   2.683  -7.769  1.00 36.92           H  
ATOM    630  HB2 ALA    40     -15.028   2.785  -9.238  1.00 36.92           H  
ATOM    631  HB3 ALA    40     -14.717   4.237  -8.286  1.00 36.92           H  
ATOM    632  N   GLU    41     -13.162   1.653 -10.936  1.00  4.00           N  
ATOM    633  CA  GLU    41     -12.741   0.377 -11.503  1.00 73.11           C  
ATOM    634  C   GLU    41     -11.495   0.533 -12.376  1.00 44.42           C  
ATOM    635  O   GLU    41     -10.745  -0.423 -12.575  1.00 62.40           O  
ATOM    636  CB  GLU    41     -13.883  -0.252 -12.302  1.00 43.42           C  
ATOM    637  CG  GLU    41     -15.061  -0.668 -11.435  1.00 63.32           C  
ATOM    638  CD  GLU    41     -16.138  -1.406 -12.204  1.00 13.55           C  
ATOM    639  OE1 GLU    41     -15.808  -2.379 -12.914  1.00 13.40           O  
ATOM    640  OE2 GLU    41     -17.327  -1.038 -12.081  1.00 14.30           O  
ATOM    641  H   GLU    41     -13.981   2.081 -11.273  1.00 13.32           H  
ATOM    642  HA  GLU    41     -12.497  -0.277 -10.678  1.00 33.21           H  
ATOM    643  HB2 GLU    41     -14.232   0.465 -13.032  1.00 36.92           H  
ATOM    644  HB3 GLU    41     -13.512  -1.126 -12.816  1.00 36.92           H  
ATOM    645  HG2 GLU    41     -14.699  -1.315 -10.649  1.00 36.92           H  
ATOM    646  HG3 GLU    41     -15.497   0.217 -10.995  1.00 36.92           H  
ATOM    647  N   SER    42     -11.275   1.736 -12.892  1.00 34.34           N  
ATOM    648  CA  SER    42     -10.074   2.024 -13.663  1.00 34.54           C  
ATOM    649  C   SER    42      -8.859   2.061 -12.751  1.00 64.54           C  
ATOM    650  O   SER    42      -7.767   1.645 -13.137  1.00 33.55           O  
ATOM    651  CB  SER    42     -10.219   3.357 -14.404  1.00 12.41           C  
ATOM    652  OG  SER    42     -11.356   3.351 -15.251  1.00 45.13           O  
ATOM    653  H   SER    42     -11.942   2.446 -12.757  1.00 63.32           H  
ATOM    654  HA  SER    42      -9.937   1.231 -14.382  1.00 60.43           H  
ATOM    655  HB2 SER    42     -10.328   4.156 -13.684  1.00 36.92           H  
ATOM    656  HB3 SER    42      -9.337   3.532 -15.003  1.00 36.92           H  
ATOM    657  HG  SER    42     -12.155   3.246 -14.716  1.00 51.21           H  
ATOM    658  N   PHE    43      -9.057   2.529 -11.527  1.00 72.54           N  
ATOM    659  CA  PHE    43      -7.965   2.627 -10.579  1.00  3.13           C  
ATOM    660  C   PHE    43      -7.646   1.244 -10.019  1.00 34.22           C  
ATOM    661  O   PHE    43      -6.511   0.960  -9.641  1.00 30.41           O  
ATOM    662  CB  PHE    43      -8.327   3.597  -9.455  1.00 41.13           C  
ATOM    663  CG  PHE    43      -7.139   4.284  -8.845  1.00 43.32           C  
ATOM    664  CD1 PHE    43      -6.541   5.354  -9.492  1.00 15.11           C  
ATOM    665  CD2 PHE    43      -6.620   3.867  -7.632  1.00 40.35           C  
ATOM    666  CE1 PHE    43      -5.449   5.993  -8.941  1.00 43.32           C  
ATOM    667  CE2 PHE    43      -5.527   4.502  -7.075  1.00 52.15           C  
ATOM    668  CZ  PHE    43      -4.941   5.567  -7.731  1.00 35.31           C  
ATOM    669  H   PHE    43      -9.959   2.816 -11.256  1.00 63.33           H  
ATOM    670  HA  PHE    43      -7.100   3.000 -11.108  1.00 64.25           H  
ATOM    671  HB2 PHE    43      -8.987   4.357  -9.845  1.00 36.92           H  
ATOM    672  HB3 PHE    43      -8.834   3.052  -8.673  1.00 36.92           H  
ATOM    673  HD1 PHE    43      -6.940   5.687 -10.439  1.00 53.12           H  
ATOM    674  HD2 PHE    43      -7.077   3.034  -7.119  1.00 22.22           H  
ATOM    675  HE1 PHE    43      -4.993   6.827  -9.456  1.00  1.35           H  
ATOM    676  HE2 PHE    43      -5.132   4.169  -6.128  1.00 43.32           H  
ATOM    677  HZ  PHE    43      -4.086   6.065  -7.297  1.00 63.25           H  
ATOM    678  N   MET    44      -8.658   0.381 -10.000  1.00 62.50           N  
ATOM    679  CA  MET    44      -8.496  -0.995  -9.543  1.00 13.32           C  
ATOM    680  C   MET    44      -7.478  -1.733 -10.408  1.00 73.33           C  
ATOM    681  O   MET    44      -6.744  -2.594  -9.923  1.00 61.20           O  
ATOM    682  CB  MET    44      -9.843  -1.727  -9.572  1.00  3.31           C  
ATOM    683  CG  MET    44      -9.766  -3.179  -9.123  1.00 73.12           C  
ATOM    684  SD  MET    44      -9.170  -3.356  -7.431  1.00 23.22           S  
ATOM    685  CE  MET    44     -10.369  -2.359  -6.551  1.00 71.13           C  
ATOM    686  H   MET    44      -9.542   0.682 -10.297  1.00 71.24           H  
ATOM    687  HA  MET    44      -8.133  -0.967  -8.526  1.00 13.31           H  
ATOM    688  HB2 MET    44     -10.533  -1.209  -8.923  1.00 36.92           H  
ATOM    689  HB3 MET    44     -10.228  -1.706 -10.581  1.00 36.92           H  
ATOM    690  HG2 MET    44     -10.752  -3.616  -9.187  1.00 36.92           H  
ATOM    691  HG3 MET    44      -9.096  -3.709  -9.783  1.00 36.92           H  
ATOM    692  HE1 MET    44     -11.361  -2.737  -6.749  1.00 36.92           H  
ATOM    693  HE2 MET    44     -10.300  -1.334  -6.884  1.00 36.92           H  
ATOM    694  HE3 MET    44     -10.170  -2.407  -5.490  1.00 36.92           H  
ATOM    695  N   THR    45      -7.432  -1.375 -11.688  1.00 65.23           N  
ATOM    696  CA  THR    45      -6.485  -1.970 -12.619  1.00 31.31           C  
ATOM    697  C   THR    45      -5.052  -1.838 -12.108  1.00 32.21           C  
ATOM    698  O   THR    45      -4.336  -2.832 -11.983  1.00 30.05           O  
ATOM    699  CB  THR    45      -6.586  -1.312 -14.008  1.00 73.30           C  
ATOM    700  OG1 THR    45      -7.941  -1.362 -14.475  1.00 22.51           O  
ATOM    701  CG2 THR    45      -5.673  -2.011 -15.006  1.00 62.31           C  
ATOM    702  H   THR    45      -8.058  -0.697 -12.017  1.00 71.11           H  
ATOM    703  HA  THR    45      -6.728  -3.019 -12.720  1.00 45.11           H  
ATOM    704  HB  THR    45      -6.279  -0.279 -13.922  1.00 71.42           H  
ATOM    705  HG1 THR    45      -8.215  -0.480 -14.749  1.00 14.35           H  
ATOM    706 HG21 THR    45      -4.653  -1.955 -14.659  1.00 36.92           H  
ATOM    707 HG22 THR    45      -5.752  -1.528 -15.970  1.00 36.92           H  
ATOM    708 HG23 THR    45      -5.966  -3.046 -15.098  1.00 36.92           H  
ATOM    709  N   LYS    46      -4.647  -0.613 -11.785  1.00 43.41           N  
ATOM    710  CA  LYS    46      -3.278  -0.371 -11.342  1.00 13.22           C  
ATOM    711  C   LYS    46      -3.031  -0.946  -9.949  1.00 74.13           C  
ATOM    712  O   LYS    46      -1.901  -1.290  -9.606  1.00 74.50           O  
ATOM    713  CB  LYS    46      -2.906   1.110 -11.431  1.00 20.52           C  
ATOM    714  CG  LYS    46      -3.828   2.057 -10.694  1.00 45.41           C  
ATOM    715  CD  LYS    46      -3.570   3.491 -11.125  1.00 65.20           C  
ATOM    716  CE  LYS    46      -2.105   3.875 -10.961  1.00 50.24           C  
ATOM    717  NZ  LYS    46      -1.766   5.128 -11.692  1.00 65.40           N  
ATOM    718  H   LYS    46      -5.281   0.136 -11.841  1.00 25.43           H  
ATOM    719  HA  LYS    46      -2.641  -0.905 -12.026  1.00 53.31           H  
ATOM    720  HB2 LYS    46      -1.913   1.236 -11.029  1.00 36.92           H  
ATOM    721  HB3 LYS    46      -2.896   1.396 -12.473  1.00 36.92           H  
ATOM    722  HG2 LYS    46      -4.854   1.800 -10.918  1.00 36.92           H  
ATOM    723  HG3 LYS    46      -3.653   1.970  -9.633  1.00 36.92           H  
ATOM    724  HD2 LYS    46      -3.848   3.603 -12.162  1.00 36.92           H  
ATOM    725  HD3 LYS    46      -4.172   4.140 -10.519  1.00 36.92           H  
ATOM    726  HE2 LYS    46      -1.899   4.017  -9.911  1.00 36.92           H  
ATOM    727  HE3 LYS    46      -1.494   3.072 -11.341  1.00 36.92           H  
ATOM    728  HZ1 LYS    46      -2.261   5.946 -11.272  1.00 36.92           H  
ATOM    729  HZ2 LYS    46      -2.047   5.046 -12.693  1.00 36.92           H  
ATOM    730  HZ3 LYS    46      -0.738   5.300 -11.654  1.00 36.92           H  
ATOM    731  N   LEU    47      -4.086  -1.053  -9.150  1.00 74.23           N  
ATOM    732  CA  LEU    47      -3.993  -1.742  -7.866  1.00 35.22           C  
ATOM    733  C   LEU    47      -3.630  -3.211  -8.078  1.00 13.01           C  
ATOM    734  O   LEU    47      -2.806  -3.759  -7.352  1.00 61.51           O  
ATOM    735  CB  LEU    47      -5.308  -1.629  -7.083  1.00 13.51           C  
ATOM    736  CG  LEU    47      -5.396  -0.462  -6.092  1.00 71.30           C  
ATOM    737  CD1 LEU    47      -4.392  -0.640  -4.966  1.00 55.22           C  
ATOM    738  CD2 LEU    47      -5.172   0.867  -6.790  1.00 60.32           C  
ATOM    739  H   LEU    47      -4.943  -0.663  -9.429  1.00 33.42           H  
ATOM    740  HA  LEU    47      -3.200  -1.273  -7.296  1.00 34.23           H  
ATOM    741  HB2 LEU    47      -6.114  -1.528  -7.795  1.00 36.92           H  
ATOM    742  HB3 LEU    47      -5.453  -2.547  -6.533  1.00 36.92           H  
ATOM    743  HG  LEU    47      -6.383  -0.447  -5.655  1.00  4.10           H  
ATOM    744 HD11 LEU    47      -3.390  -0.614  -5.369  1.00 36.92           H  
ATOM    745 HD12 LEU    47      -4.560  -1.592  -4.483  1.00 36.92           H  
ATOM    746 HD13 LEU    47      -4.515   0.156  -4.247  1.00 36.92           H  
ATOM    747 HD21 LEU    47      -5.256   1.670  -6.072  1.00 36.92           H  
ATOM    748 HD22 LEU    47      -5.917   0.995  -7.562  1.00 36.92           H  
ATOM    749 HD23 LEU    47      -4.188   0.881  -7.232  1.00 36.92           H  
ATOM    750  N   LYS    48      -4.243  -3.840  -9.078  1.00 73.20           N  
ATOM    751  CA  LYS    48      -3.909  -5.213  -9.441  1.00 75.42           C  
ATOM    752  C   LYS    48      -2.463  -5.317  -9.916  1.00 51.41           C  
ATOM    753  O   LYS    48      -1.756  -6.266  -9.571  1.00 33.44           O  
ATOM    754  CB  LYS    48      -4.852  -5.730 -10.530  1.00 33.13           C  
ATOM    755  CG  LYS    48      -6.310  -5.777 -10.105  1.00 42.44           C  
ATOM    756  CD  LYS    48      -6.452  -6.375  -8.717  1.00 64.23           C  
ATOM    757  CE  LYS    48      -7.872  -6.839  -8.440  1.00 25.11           C  
ATOM    758  NZ  LYS    48      -8.293  -7.930  -9.360  1.00 44.22           N  
ATOM    759  H   LYS    48      -4.956  -3.380  -9.571  1.00 54.34           H  
ATOM    760  HA  LYS    48      -4.027  -5.823  -8.558  1.00 12.33           H  
ATOM    761  HB2 LYS    48      -4.773  -5.085 -11.392  1.00 36.92           H  
ATOM    762  HB3 LYS    48      -4.549  -6.728 -10.810  1.00 36.92           H  
ATOM    763  HG2 LYS    48      -6.709  -4.773 -10.099  1.00 36.92           H  
ATOM    764  HG3 LYS    48      -6.861  -6.384 -10.806  1.00 36.92           H  
ATOM    765  HD2 LYS    48      -5.782  -7.212  -8.632  1.00 36.92           H  
ATOM    766  HD3 LYS    48      -6.181  -5.624  -7.988  1.00 36.92           H  
ATOM    767  HE2 LYS    48      -7.929  -7.197  -7.423  1.00 36.92           H  
ATOM    768  HE3 LYS    48      -8.540  -6.000  -8.563  1.00 36.92           H  
ATOM    769  HZ1 LYS    48      -7.595  -8.708  -9.341  1.00 36.92           H  
ATOM    770  HZ2 LYS    48      -8.371  -7.570 -10.336  1.00 36.92           H  
ATOM    771  HZ3 LYS    48      -9.220  -8.306  -9.067  1.00 36.92           H  
ATOM    772  N   GLU    49      -2.027  -4.338 -10.704  1.00 11.24           N  
ATOM    773  CA  GLU    49      -0.648  -4.291 -11.179  1.00 21.22           C  
ATOM    774  C   GLU    49       0.310  -4.242  -9.994  1.00 71.10           C  
ATOM    775  O   GLU    49       1.316  -4.953  -9.958  1.00 65.13           O  
ATOM    776  CB  GLU    49      -0.431  -3.066 -12.074  1.00 24.45           C  
ATOM    777  CG  GLU    49      -1.391  -2.986 -13.250  1.00 22.30           C  
ATOM    778  CD  GLU    49      -1.150  -1.768 -14.124  1.00 71.11           C  
ATOM    779  OE1 GLU    49      -1.441  -0.639 -13.680  1.00  3.41           O  
ATOM    780  OE2 GLU    49      -0.676  -1.931 -15.267  1.00 13.53           O  
ATOM    781  H   GLU    49      -2.651  -3.632 -10.981  1.00 54.14           H  
ATOM    782  HA  GLU    49      -0.457  -5.188 -11.750  1.00 30.44           H  
ATOM    783  HB2 GLU    49      -0.553  -2.175 -11.477  1.00 36.92           H  
ATOM    784  HB3 GLU    49       0.576  -3.092 -12.463  1.00 36.92           H  
ATOM    785  HG2 GLU    49      -1.273  -3.873 -13.852  1.00 36.92           H  
ATOM    786  HG3 GLU    49      -2.401  -2.943 -12.869  1.00 36.92           H  
ATOM    787  N   LEU    50      -0.027  -3.407  -9.023  1.00 32.24           N  
ATOM    788  CA  LEU    50       0.779  -3.245  -7.819  1.00 54.34           C  
ATOM    789  C   LEU    50       0.700  -4.475  -6.919  1.00 62.31           C  
ATOM    790  O   LEU    50       1.695  -4.870  -6.308  1.00 33.53           O  
ATOM    791  CB  LEU    50       0.328  -1.999  -7.058  1.00 74.11           C  
ATOM    792  CG  LEU    50       0.742  -0.676  -7.701  1.00 64.13           C  
ATOM    793  CD1 LEU    50       0.149   0.499  -6.940  1.00  1.12           C  
ATOM    794  CD2 LEU    50       2.259  -0.572  -7.746  1.00 55.13           C  
ATOM    795  H   LEU    50      -0.846  -2.872  -9.121  1.00  0.32           H  
ATOM    796  HA  LEU    50       1.804  -3.110  -8.128  1.00 33.13           H  
ATOM    797  HB2 LEU    50      -0.750  -2.019  -6.985  1.00 36.92           H  
ATOM    798  HB3 LEU    50       0.738  -2.036  -6.063  1.00 36.92           H  
ATOM    799  HG  LEU    50       0.371  -0.642  -8.715  1.00 33.34           H  
ATOM    800 HD11 LEU    50       0.499   0.481  -5.919  1.00 36.92           H  
ATOM    801 HD12 LEU    50      -0.929   0.428  -6.952  1.00 36.92           H  
ATOM    802 HD13 LEU    50       0.454   1.422  -7.409  1.00 36.92           H  
ATOM    803 HD21 LEU    50       2.650  -0.596  -6.740  1.00 36.92           H  
ATOM    804 HD22 LEU    50       2.542   0.355  -8.222  1.00 36.92           H  
ATOM    805 HD23 LEU    50       2.660  -1.403  -8.308  1.00 36.92           H  
ATOM    806  N   ALA    51      -0.481  -5.079  -6.846  1.00 41.11           N  
ATOM    807  CA  ALA    51      -0.690  -6.268  -6.026  1.00 11.41           C  
ATOM    808  C   ALA    51       0.201  -7.417  -6.487  1.00 11.52           C  
ATOM    809  O   ALA    51       0.742  -8.157  -5.667  1.00 40.12           O  
ATOM    810  CB  ALA    51      -2.151  -6.690  -6.057  1.00 40.43           C  
ATOM    811  H   ALA    51      -1.241  -4.704  -7.346  1.00 73.44           H  
ATOM    812  HA  ALA    51      -0.434  -6.017  -5.007  1.00 62.11           H  
ATOM    813  HB1 ALA    51      -2.770  -5.869  -5.728  1.00 36.92           H  
ATOM    814  HB2 ALA    51      -2.297  -7.536  -5.400  1.00 36.92           H  
ATOM    815  HB3 ALA    51      -2.425  -6.967  -7.064  1.00 36.92           H  
ATOM    816  N   ALA    52       0.359  -7.550  -7.802  1.00 30.53           N  
ATOM    817  CA  ALA    52       1.192  -8.601  -8.378  1.00 50.04           C  
ATOM    818  C   ALA    52       2.662  -8.413  -8.011  1.00 23.14           C  
ATOM    819  O   ALA    52       3.413  -9.382  -7.903  1.00 21.42           O  
ATOM    820  CB  ALA    52       1.031  -8.637  -9.891  1.00 23.14           C  
ATOM    821  H   ALA    52      -0.110  -6.929  -8.402  1.00 65.21           H  
ATOM    822  HA  ALA    52       0.853  -9.547  -7.982  1.00 63.03           H  
ATOM    823  HB1 ALA    52       1.603  -9.461 -10.293  1.00 36.92           H  
ATOM    824  HB2 ALA    52       1.390  -7.711 -10.313  1.00 36.92           H  
ATOM    825  HB3 ALA    52      -0.012  -8.768 -10.141  1.00 36.92           H  
ATOM    826  N   ALA    53       3.069  -7.163  -7.831  1.00 15.05           N  
ATOM    827  CA  ALA    53       4.444  -6.860  -7.461  1.00 25.53           C  
ATOM    828  C   ALA    53       4.680  -7.140  -5.981  1.00 14.01           C  
ATOM    829  O   ALA    53       5.673  -7.767  -5.613  1.00 21.34           O  
ATOM    830  CB  ALA    53       4.775  -5.411  -7.788  1.00 44.34           C  
ATOM    831  H   ALA    53       2.430  -6.430  -7.947  1.00 13.42           H  
ATOM    832  HA  ALA    53       5.094  -7.494  -8.046  1.00 13.21           H  
ATOM    833  HB1 ALA    53       4.145  -4.759  -7.203  1.00 36.92           H  
ATOM    834  HB2 ALA    53       4.604  -5.231  -8.839  1.00 36.92           H  
ATOM    835  HB3 ALA    53       5.812  -5.217  -7.554  1.00 36.92           H  
ATOM    836  N   ALA    54       3.753  -6.681  -5.144  1.00 63.51           N  
ATOM    837  CA  ALA    54       3.859  -6.855  -3.698  1.00 50.11           C  
ATOM    838  C   ALA    54       3.695  -8.321  -3.301  1.00 31.12           C  
ATOM    839  O   ALA    54       4.514  -8.878  -2.567  1.00 55.23           O  
ATOM    840  CB  ALA    54       2.816  -5.999  -2.993  1.00 43.23           C  
ATOM    841  H   ALA    54       2.975  -6.206  -5.510  1.00 62.02           H  
ATOM    842  HA  ALA    54       4.836  -6.516  -3.391  1.00  3.24           H  
ATOM    843  HB1 ALA    54       2.917  -4.971  -3.311  1.00 36.92           H  
ATOM    844  HB2 ALA    54       2.961  -6.061  -1.925  1.00 36.92           H  
ATOM    845  HB3 ALA    54       1.828  -6.357  -3.243  1.00 36.92           H  
ATOM    846  N   SER    55       2.634  -8.937  -3.792  1.00 63.11           N  
ATOM    847  CA  SER    55       2.357 -10.328  -3.496  1.00 53.42           C  
ATOM    848  C   SER    55       2.462 -11.162  -4.763  1.00 52.22           C  
ATOM    849  O   SER    55       1.758 -10.909  -5.740  1.00  1.23           O  
ATOM    850  CB  SER    55       0.966 -10.466  -2.874  1.00 41.12           C  
ATOM    851  OG  SER    55      -0.024  -9.848  -3.684  1.00 43.44           O  
ATOM    852  H   SER    55       2.023  -8.444  -4.381  1.00 22.04           H  
ATOM    853  HA  SER    55       3.097 -10.674  -2.789  1.00 21.41           H  
ATOM    854  HB2 SER    55       0.725 -11.515  -2.767  1.00 36.92           H  
ATOM    855  HB3 SER    55       0.962  -9.994  -1.904  1.00 36.92           H  
ATOM    856  HG  SER    55       0.393  -9.486  -4.478  1.00  0.33           H  
ATOM    857  N   SER    56       3.356 -12.139  -4.752  1.00 71.22           N  
ATOM    858  CA  SER    56       3.554 -12.997  -5.907  1.00  2.45           C  
ATOM    859  C   SER    56       2.365 -13.942  -6.077  1.00 50.23           C  
ATOM    860  O   SER    56       1.435 -13.646  -6.832  1.00 52.53           O  
ATOM    861  CB  SER    56       4.852 -13.788  -5.752  1.00 10.03           C  
ATOM    862  OG  SER    56       5.923 -12.940  -5.373  1.00 72.14           O  
ATOM    863  H   SER    56       3.899 -12.284  -3.947  1.00  1.32           H  
ATOM    864  HA  SER    56       3.625 -12.366  -6.780  1.00  4.24           H  
ATOM    865  HB2 SER    56       4.722 -14.545  -4.993  1.00 36.92           H  
ATOM    866  HB3 SER    56       5.099 -14.260  -6.693  1.00 36.92           H  
ATOM    867  HG  SER    56       5.861 -12.107  -5.866  1.00  4.34           H  
ATOM    868  N   ALA    57       2.396 -15.065  -5.353  1.00 12.51           N  
ATOM    869  CA  ALA    57       1.335 -16.047  -5.377  1.00 33.14           C  
ATOM    870  C   ALA    57       1.033 -16.502  -6.796  1.00 23.43           C  
ATOM    871  O   ALA    57       1.818 -16.299  -7.729  1.00 10.43           O  
ATOM    872  CB  ALA    57       0.083 -15.483  -4.713  1.00 62.00           C  
ATOM    873  H   ALA    57       3.159 -15.242  -4.789  1.00 31.43           H  
ATOM    874  HA  ALA    57       1.662 -16.901  -4.801  1.00 43.33           H  
ATOM    875  HB1 ALA    57      -0.252 -14.613  -5.258  1.00 36.92           H  
ATOM    876  HB2 ALA    57       0.309 -15.204  -3.694  1.00 36.92           H  
ATOM    877  HB3 ALA    57      -0.695 -16.232  -4.716  1.00 36.92           H  
ATOM    878  N   ASP    58      -0.098 -17.142  -6.935  1.00 51.44           N  
ATOM    879  CA  ASP    58      -0.593 -17.557  -8.241  1.00 60.15           C  
ATOM    880  C   ASP    58      -1.215 -16.372  -8.962  1.00 21.53           C  
ATOM    881  O   ASP    58      -0.896 -16.094 -10.118  1.00 41.32           O  
ATOM    882  CB  ASP    58      -1.630 -18.676  -8.110  1.00 52.14           C  
ATOM    883  CG  ASP    58      -1.017 -20.002  -7.713  1.00 11.33           C  
ATOM    884  OD1 ASP    58      -0.813 -20.238  -6.500  1.00 22.34           O  
ATOM    885  OD2 ASP    58      -0.735 -20.819  -8.612  1.00 61.34           O  
ATOM    886  H   ASP    58      -0.616 -17.340  -6.127  1.00 45.34           H  
ATOM    887  HA  ASP    58       0.247 -17.917  -8.816  1.00 63.12           H  
ATOM    888  HB2 ASP    58      -2.356 -18.399  -7.361  1.00 36.92           H  
ATOM    889  HB3 ASP    58      -2.131 -18.802  -9.060  1.00 36.92           H  
ATOM    890  N   GLU    59      -2.106 -15.675  -8.268  1.00  5.43           N  
ATOM    891  CA  GLU    59      -2.817 -14.540  -8.838  1.00 65.12           C  
ATOM    892  C   GLU    59      -2.734 -13.331  -7.912  1.00 42.44           C  
ATOM    893  O   GLU    59      -3.513 -12.381  -8.038  1.00 62.23           O  
ATOM    894  CB  GLU    59      -4.278 -14.922  -9.073  1.00 24.01           C  
ATOM    895  CG  GLU    59      -4.443 -16.070 -10.051  1.00 21.50           C  
ATOM    896  CD  GLU    59      -5.859 -16.586 -10.113  1.00 22.43           C  
ATOM    897  OE1 GLU    59      -6.689 -15.976 -10.815  1.00 73.42           O  
ATOM    898  OE2 GLU    59      -6.144 -17.611  -9.459  1.00 70.12           O  
ATOM    899  H   GLU    59      -2.307 -15.947  -7.341  1.00 73.32           H  
ATOM    900  HA  GLU    59      -2.358 -14.294  -9.783  1.00 21.01           H  
ATOM    901  HB2 GLU    59      -4.718 -15.214  -8.130  1.00 36.92           H  
ATOM    902  HB3 GLU    59      -4.808 -14.064  -9.460  1.00 36.92           H  
ATOM    903  HG2 GLU    59      -4.156 -15.734 -11.036  1.00 36.92           H  
ATOM    904  HG3 GLU    59      -3.796 -16.879  -9.746  1.00 36.92           H  
ATOM    905  N   GLY    60      -1.785 -13.372  -6.989  1.00 65.33           N  
ATOM    906  CA  GLY    60      -1.613 -12.283  -6.052  1.00 60.33           C  
ATOM    907  C   GLY    60      -2.392 -12.506  -4.771  1.00  3.34           C  
ATOM    908  O   GLY    60      -3.015 -13.554  -4.590  1.00 14.40           O  
ATOM    909  H   GLY    60      -1.195 -14.152  -6.939  1.00 72.33           H  
ATOM    910  HA2 GLY    60      -0.562 -12.188  -5.815  1.00 36.92           H  
ATOM    911  HA3 GLY    60      -1.954 -11.369  -6.514  1.00 36.92           H  
ATOM    912  N   ALA    61      -2.346 -11.526  -3.880  1.00 72.42           N  
ATOM    913  CA  ALA    61      -3.069 -11.591  -2.616  1.00 51.33           C  
ATOM    914  C   ALA    61      -4.578 -11.542  -2.840  1.00 33.41           C  
ATOM    915  O   ALA    61      -5.045 -11.232  -3.938  1.00 22.40           O  
ATOM    916  CB  ALA    61      -2.636 -10.451  -1.708  1.00 75.35           C  
ATOM    917  H   ALA    61      -1.799 -10.733  -4.074  1.00 11.03           H  
ATOM    918  HA  ALA    61      -2.817 -12.522  -2.131  1.00 14.23           H  
ATOM    919  HB1 ALA    61      -3.144 -10.536  -0.758  1.00 36.92           H  
ATOM    920  HB2 ALA    61      -2.892  -9.508  -2.169  1.00 36.92           H  
ATOM    921  HB3 ALA    61      -1.569 -10.498  -1.553  1.00 36.92           H  
ATOM    922  N   SER    62      -5.334 -11.843  -1.793  1.00 73.03           N  
ATOM    923  CA  SER    62      -6.787 -11.813  -1.866  1.00 13.25           C  
ATOM    924  C   SER    62      -7.280 -10.372  -1.920  1.00 31.33           C  
ATOM    925  O   SER    62      -6.742  -9.502  -1.239  1.00 73.22           O  
ATOM    926  CB  SER    62      -7.375 -12.533  -0.656  1.00 54.03           C  
ATOM    927  OG  SER    62      -6.856 -13.851  -0.560  1.00 72.43           O  
ATOM    928  H   SER    62      -4.903 -12.076  -0.942  1.00 71.44           H  
ATOM    929  HA  SER    62      -7.090 -12.325  -2.766  1.00 52.21           H  
ATOM    930  HB2 SER    62      -7.120 -11.994   0.245  1.00 36.92           H  
ATOM    931  HB3 SER    62      -8.448 -12.581  -0.755  1.00 36.92           H  
ATOM    932  HG  SER    62      -6.398 -14.071  -1.381  1.00 64.34           H  
ATOM    933  N   VAL    63      -8.296 -10.121  -2.728  1.00 44.14           N  
ATOM    934  CA  VAL    63      -8.796  -8.773  -2.909  1.00  5.32           C  
ATOM    935  C   VAL    63     -10.323  -8.737  -2.879  1.00 64.30           C  
ATOM    936  O   VAL    63     -10.999  -9.339  -3.715  1.00 54.23           O  
ATOM    937  CB  VAL    63      -8.267  -8.150  -4.225  1.00 12.20           C  
ATOM    938  CG1 VAL    63      -8.564  -9.045  -5.422  1.00 44.21           C  
ATOM    939  CG2 VAL    63      -8.845  -6.758  -4.438  1.00  3.44           C  
ATOM    940  H   VAL    63      -8.730 -10.863  -3.205  1.00 41.21           H  
ATOM    941  HA  VAL    63      -8.424  -8.176  -2.088  1.00 34.10           H  
ATOM    942  HB  VAL    63      -7.194  -8.057  -4.141  1.00 44.33           H  
ATOM    943 HG11 VAL    63      -9.633  -9.167  -5.524  1.00 36.92           H  
ATOM    944 HG12 VAL    63      -8.104 -10.010  -5.273  1.00 36.92           H  
ATOM    945 HG13 VAL    63      -8.166  -8.591  -6.318  1.00 36.92           H  
ATOM    946 HG21 VAL    63      -8.434  -6.330  -5.341  1.00 36.92           H  
ATOM    947 HG22 VAL    63      -8.594  -6.131  -3.595  1.00 36.92           H  
ATOM    948 HG23 VAL    63      -9.919  -6.825  -4.530  1.00 36.92           H  
ATOM    949  N   ALA    64     -10.856  -8.047  -1.887  1.00  0.14           N  
ATOM    950  CA  ALA    64     -12.288  -7.819  -1.788  1.00 21.41           C  
ATOM    951  C   ALA    64     -12.562  -6.327  -1.880  1.00 35.15           C  
ATOM    952  O   ALA    64     -12.278  -5.578  -0.946  1.00 43.34           O  
ATOM    953  CB  ALA    64     -12.834  -8.391  -0.489  1.00 63.04           C  
ATOM    954  H   ALA    64     -10.264  -7.673  -1.193  1.00 52.24           H  
ATOM    955  HA  ALA    64     -12.769  -8.322  -2.616  1.00 14.12           H  
ATOM    956  HB1 ALA    64     -12.364  -7.896   0.348  1.00 36.92           H  
ATOM    957  HB2 ALA    64     -12.625  -9.449  -0.445  1.00 36.92           H  
ATOM    958  HB3 ALA    64     -13.902  -8.233  -0.447  1.00 36.92           H  
ATOM    959  N   TYR    65     -13.097  -5.890  -3.004  1.00 54.34           N  
ATOM    960  CA  TYR    65     -13.224  -4.466  -3.259  1.00 14.20           C  
ATOM    961  C   TYR    65     -14.639  -3.974  -3.005  1.00 50.43           C  
ATOM    962  O   TYR    65     -15.609  -4.709  -3.185  1.00 43.51           O  
ATOM    963  CB  TYR    65     -12.788  -4.132  -4.693  1.00  1.20           C  
ATOM    964  CG  TYR    65     -13.635  -4.762  -5.787  1.00  2.44           C  
ATOM    965  CD1 TYR    65     -14.810  -4.154  -6.216  1.00  0.31           C  
ATOM    966  CD2 TYR    65     -13.252  -5.950  -6.401  1.00 62.40           C  
ATOM    967  CE1 TYR    65     -15.579  -4.712  -7.217  1.00 73.44           C  
ATOM    968  CE2 TYR    65     -14.017  -6.511  -7.408  1.00 12.11           C  
ATOM    969  CZ  TYR    65     -15.179  -5.887  -7.809  1.00  0.44           C  
ATOM    970  OH  TYR    65     -15.944  -6.433  -8.815  1.00 35.31           O  
ATOM    971  H   TYR    65     -13.431  -6.535  -3.668  1.00 31.52           H  
ATOM    972  HA  TYR    65     -12.560  -3.956  -2.575  1.00 43.25           H  
ATOM    973  HB2 TYR    65     -12.825  -3.062  -4.826  1.00 36.92           H  
ATOM    974  HB3 TYR    65     -11.770  -4.467  -4.830  1.00 36.92           H  
ATOM    975  HD1 TYR    65     -15.122  -3.233  -5.751  1.00 71.15           H  
ATOM    976  HD2 TYR    65     -12.342  -6.438  -6.083  1.00 51.12           H  
ATOM    977  HE1 TYR    65     -16.490  -4.225  -7.533  1.00 12.11           H  
ATOM    978  HE2 TYR    65     -13.706  -7.435  -7.874  1.00 43.35           H  
ATOM    979  HH  TYR    65     -16.005  -7.390  -8.696  1.00 23.11           H  
ATOM    980  N   LYS    66     -14.740  -2.736  -2.558  1.00 23.34           N  
ATOM    981  CA  LYS    66     -16.020  -2.076  -2.406  1.00 52.14           C  
ATOM    982  C   LYS    66     -16.198  -1.043  -3.489  1.00 45.51           C  
ATOM    983  O   LYS    66     -15.264  -0.320  -3.838  1.00 42.11           O  
ATOM    984  CB  LYS    66     -16.127  -1.366  -1.064  1.00 20.13           C  
ATOM    985  CG  LYS    66     -16.056  -2.280   0.131  1.00 13.54           C  
ATOM    986  CD  LYS    66     -15.737  -1.473   1.373  1.00 52.40           C  
ATOM    987  CE  LYS    66     -15.406  -2.345   2.568  1.00 75.44           C  
ATOM    988  NZ  LYS    66     -14.811  -1.538   3.664  1.00  1.23           N  
ATOM    989  H   LYS    66     -13.923  -2.248  -2.307  1.00 52.21           H  
ATOM    990  HA  LYS    66     -16.799  -2.817  -2.485  1.00 74.25           H  
ATOM    991  HB2 LYS    66     -15.321  -0.652  -0.985  1.00 36.92           H  
ATOM    992  HB3 LYS    66     -17.067  -0.836  -1.025  1.00 36.92           H  
ATOM    993  HG2 LYS    66     -17.011  -2.769   0.259  1.00 36.92           H  
ATOM    994  HG3 LYS    66     -15.287  -3.011  -0.035  1.00 36.92           H  
ATOM    995  HD2 LYS    66     -14.890  -0.837   1.165  1.00 36.92           H  
ATOM    996  HD3 LYS    66     -16.593  -0.859   1.616  1.00 36.92           H  
ATOM    997  HE2 LYS    66     -16.313  -2.811   2.923  1.00 36.92           H  
ATOM    998  HE3 LYS    66     -14.701  -3.103   2.264  1.00 36.92           H  
ATOM    999  HZ1 LYS    66     -15.471  -0.782   3.954  1.00 36.92           H  
ATOM   1000  HZ2 LYS    66     -13.921  -1.095   3.334  1.00 36.92           H  
ATOM   1001  HZ3 LYS    66     -14.602  -2.135   4.488  1.00 36.92           H  
ATOM   1002  N   ILE    67     -17.398  -0.991  -4.009  1.00 45.32           N  
ATOM   1003  CA  ILE    67     -17.793   0.051  -4.939  1.00 72.14           C  
ATOM   1004  C   ILE    67     -19.163   0.573  -4.544  1.00 63.23           C  
ATOM   1005  O   ILE    67     -20.180  -0.090  -4.764  1.00 32.20           O  
ATOM   1006  CB  ILE    67     -17.842  -0.437  -6.404  1.00 21.51           C  
ATOM   1007  CG1 ILE    67     -16.476  -0.963  -6.847  1.00 22.50           C  
ATOM   1008  CG2 ILE    67     -18.293   0.700  -7.315  1.00 22.44           C  
ATOM   1009  CD1 ILE    67     -16.452  -1.466  -8.275  1.00  1.44           C  
ATOM   1010  H   ILE    67     -18.049  -1.670  -3.740  1.00  2.22           H  
ATOM   1011  HA  ILE    67     -17.073   0.855  -4.866  1.00 75.03           H  
ATOM   1012  HB  ILE    67     -18.568  -1.233  -6.474  1.00 11.44           H  
ATOM   1013 HG12 ILE    67     -15.750  -0.169  -6.763  1.00 36.92           H  
ATOM   1014 HG13 ILE    67     -16.185  -1.779  -6.201  1.00 36.92           H  
ATOM   1015 HG21 ILE    67     -19.276   1.032  -7.018  1.00 36.92           H  
ATOM   1016 HG22 ILE    67     -18.323   0.353  -8.338  1.00 36.92           H  
ATOM   1017 HG23 ILE    67     -17.596   1.520  -7.235  1.00 36.92           H  
ATOM   1018 HD11 ILE    67     -17.154  -2.280  -8.381  1.00 36.92           H  
ATOM   1019 HD12 ILE    67     -15.459  -1.812  -8.518  1.00 36.92           H  
ATOM   1020 HD13 ILE    67     -16.726  -0.663  -8.943  1.00 36.92           H  
ATOM   1021  N   LYS    68     -19.186   1.740  -3.934  1.00 34.32           N  
ATOM   1022  CA  LYS    68     -20.437   2.340  -3.514  1.00 25.45           C  
ATOM   1023  C   LYS    68     -20.806   3.478  -4.442  1.00 45.23           C  
ATOM   1024  O   LYS    68     -20.070   4.459  -4.571  1.00 71.53           O  
ATOM   1025  CB  LYS    68     -20.345   2.827  -2.072  1.00 71.40           C  
ATOM   1026  CG  LYS    68     -21.651   3.377  -1.517  1.00 52.33           C  
ATOM   1027  CD  LYS    68     -21.542   3.652  -0.026  1.00 33.42           C  
ATOM   1028  CE  LYS    68     -22.825   4.245   0.538  1.00 50.52           C  
ATOM   1029  NZ  LYS    68     -23.997   3.355   0.327  1.00 72.10           N  
ATOM   1030  H   LYS    68     -18.341   2.211  -3.764  1.00 40.12           H  
ATOM   1031  HA  LYS    68     -21.205   1.582  -3.579  1.00 54.24           H  
ATOM   1032  HB2 LYS    68     -20.038   2.003  -1.451  1.00 36.92           H  
ATOM   1033  HB3 LYS    68     -19.602   3.607  -2.018  1.00 36.92           H  
ATOM   1034  HG2 LYS    68     -21.887   4.300  -2.025  1.00 36.92           H  
ATOM   1035  HG3 LYS    68     -22.438   2.657  -1.685  1.00 36.92           H  
ATOM   1036  HD2 LYS    68     -21.333   2.724   0.486  1.00 36.92           H  
ATOM   1037  HD3 LYS    68     -20.731   4.346   0.141  1.00 36.92           H  
ATOM   1038  HE2 LYS    68     -22.696   4.409   1.598  1.00 36.92           H  
ATOM   1039  HE3 LYS    68     -23.010   5.193   0.051  1.00 36.92           H  
ATOM   1040  HZ1 LYS    68     -23.818   2.416   0.742  1.00 36.92           H  
ATOM   1041  HZ2 LYS    68     -24.187   3.246  -0.691  1.00 36.92           H  
ATOM   1042  HZ3 LYS    68     -24.843   3.766   0.780  1.00 36.92           H  
ATOM   1043  N   ASP    69     -21.948   3.326  -5.082  1.00 60.11           N  
ATOM   1044  CA  ASP    69     -22.432   4.284  -6.053  1.00 21.41           C  
ATOM   1045  C   ASP    69     -23.101   5.447  -5.324  1.00 34.11           C  
ATOM   1046  O   ASP    69     -24.267   5.355  -4.939  1.00 44.23           O  
ATOM   1047  CB  ASP    69     -23.443   3.619  -6.996  1.00 24.45           C  
ATOM   1048  CG  ASP    69     -23.033   2.222  -7.437  1.00 63.23           C  
ATOM   1049  OD1 ASP    69     -22.338   2.087  -8.468  1.00 23.43           O  
ATOM   1050  OD2 ASP    69     -23.432   1.246  -6.762  1.00 74.32           O  
ATOM   1051  H   ASP    69     -22.499   2.539  -4.881  1.00 51.42           H  
ATOM   1052  HA  ASP    69     -21.589   4.649  -6.628  1.00 41.14           H  
ATOM   1053  HB2 ASP    69     -24.397   3.548  -6.495  1.00 36.92           H  
ATOM   1054  HB3 ASP    69     -23.553   4.231  -7.872  1.00 36.92           H  
ATOM   1055  N   LEU    70     -22.358   6.520  -5.106  1.00 53.24           N  
ATOM   1056  CA  LEU    70     -22.879   7.671  -4.381  1.00 44.32           C  
ATOM   1057  C   LEU    70     -23.393   8.734  -5.341  1.00 73.41           C  
ATOM   1058  O   LEU    70     -23.405   8.542  -6.559  1.00 72.32           O  
ATOM   1059  CB  LEU    70     -21.796   8.270  -3.478  1.00 24.22           C  
ATOM   1060  CG  LEU    70     -21.334   7.376  -2.330  1.00 55.12           C  
ATOM   1061  CD1 LEU    70     -20.155   8.007  -1.604  1.00 61.32           C  
ATOM   1062  CD2 LEU    70     -22.483   7.129  -1.367  1.00 75.23           C  
ATOM   1063  H   LEU    70     -21.438   6.548  -5.446  1.00 74.20           H  
ATOM   1064  HA  LEU    70     -23.700   7.332  -3.766  1.00 60.34           H  
ATOM   1065  HB2 LEU    70     -20.938   8.504  -4.092  1.00 36.92           H  
ATOM   1066  HB3 LEU    70     -22.177   9.189  -3.058  1.00 36.92           H  
ATOM   1067  HG  LEU    70     -21.015   6.424  -2.727  1.00 20.33           H  
ATOM   1068 HD11 LEU    70     -19.847   7.366  -0.790  1.00 36.92           H  
ATOM   1069 HD12 LEU    70     -20.445   8.971  -1.213  1.00 36.92           H  
ATOM   1070 HD13 LEU    70     -19.334   8.131  -2.294  1.00 36.92           H  
ATOM   1071 HD21 LEU    70     -22.155   6.473  -0.576  1.00 36.92           H  
ATOM   1072 HD22 LEU    70     -23.305   6.671  -1.898  1.00 36.92           H  
ATOM   1073 HD23 LEU    70     -22.807   8.069  -0.945  1.00 36.92           H  
ATOM   1074  N   GLU    71     -23.814   9.857  -4.785  1.00 23.43           N  
ATOM   1075  CA  GLU    71     -24.349  10.951  -5.573  1.00  1.01           C  
ATOM   1076  C   GLU    71     -23.249  11.955  -5.905  1.00 60.04           C  
ATOM   1077  O   GLU    71     -22.900  12.807  -5.086  1.00  1.51           O  
ATOM   1078  CB  GLU    71     -25.472  11.637  -4.801  1.00 70.31           C  
ATOM   1079  CG  GLU    71     -26.265  12.635  -5.619  1.00 62.41           C  
ATOM   1080  CD  GLU    71     -27.254  13.402  -4.774  1.00 30.54           C  
ATOM   1081  OE1 GLU    71     -28.047  12.768  -4.047  1.00 32.54           O  
ATOM   1082  OE2 GLU    71     -27.228  14.651  -4.815  1.00 74.10           O  
ATOM   1083  H   GLU    71     -23.765   9.954  -3.807  1.00 15.23           H  
ATOM   1084  HA  GLU    71     -24.744  10.545  -6.491  1.00 14.31           H  
ATOM   1085  HB2 GLU    71     -26.154  10.884  -4.436  1.00 36.92           H  
ATOM   1086  HB3 GLU    71     -25.043  12.158  -3.957  1.00 36.92           H  
ATOM   1087  HG2 GLU    71     -25.580  13.336  -6.072  1.00 36.92           H  
ATOM   1088  HG3 GLU    71     -26.805  12.107  -6.393  1.00 36.92           H  
ATOM   1089  N   GLY    72     -22.685  11.829  -7.094  1.00 12.40           N  
ATOM   1090  CA  GLY    72     -21.642  12.744  -7.518  1.00 54.51           C  
ATOM   1091  C   GLY    72     -20.257  12.149  -7.384  1.00 60.22           C  
ATOM   1092  O   GLY    72     -19.296  12.660  -7.960  1.00 71.13           O  
ATOM   1093  H   GLY    72     -22.982  11.111  -7.693  1.00 72.14           H  
ATOM   1094  HA2 GLY    72     -21.811  13.008  -8.553  1.00 36.92           H  
ATOM   1095  HA3 GLY    72     -21.696  13.638  -6.916  1.00 36.92           H  
ATOM   1096  N   GLN    73     -20.152  11.070  -6.626  1.00 12.51           N  
ATOM   1097  CA  GLN    73     -18.878  10.398  -6.423  1.00 65.04           C  
ATOM   1098  C   GLN    73     -19.103   8.924  -6.129  1.00 53.02           C  
ATOM   1099  O   GLN    73     -20.239   8.469  -6.037  1.00  4.34           O  
ATOM   1100  CB  GLN    73     -18.098  11.043  -5.271  1.00 73.13           C  
ATOM   1101  CG  GLN    73     -18.834  11.021  -3.939  1.00 20.53           C  
ATOM   1102  CD  GLN    73     -17.944  11.413  -2.774  1.00 32.52           C  
ATOM   1103  OE1 GLN    73     -17.817  12.589  -2.437  1.00 12.33           O  
ATOM   1104  NE2 GLN    73     -17.331  10.424  -2.142  1.00 64.02           N  
ATOM   1105  H   GLN    73     -20.955  10.705  -6.197  1.00  2.45           H  
ATOM   1106  HA  GLN    73     -18.304  10.489  -7.334  1.00 14.12           H  
ATOM   1107  HB2 GLN    73     -17.164  10.517  -5.148  1.00 36.92           H  
ATOM   1108  HB3 GLN    73     -17.890  12.072  -5.526  1.00 36.92           H  
ATOM   1109  HG2 GLN    73     -19.662  11.712  -3.987  1.00 36.92           H  
ATOM   1110  HG3 GLN    73     -19.208  10.023  -3.766  1.00 36.92           H  
ATOM   1111 HE21 GLN    73     -17.484   9.510  -2.455  1.00 36.92           H  
ATOM   1112 HE22 GLN    73     -16.755  10.646  -1.380  1.00 36.92           H  
ATOM   1113  N   VAL    74     -18.016   8.182  -6.000  1.00 44.24           N  
ATOM   1114  CA  VAL    74     -18.083   6.779  -5.618  1.00 51.30           C  
ATOM   1115  C   VAL    74     -16.989   6.451  -4.614  1.00 24.33           C  
ATOM   1116  O   VAL    74     -15.954   7.121  -4.569  1.00  0.32           O  
ATOM   1117  CB  VAL    74     -17.938   5.837  -6.832  1.00 13.50           C  
ATOM   1118  CG1 VAL    74     -19.130   5.966  -7.767  1.00 50.33           C  
ATOM   1119  CG2 VAL    74     -16.641   6.115  -7.573  1.00 32.50           C  
ATOM   1120  H   VAL    74     -17.138   8.591  -6.170  1.00 31.51           H  
ATOM   1121  HA  VAL    74     -19.046   6.601  -5.161  1.00 15.53           H  
ATOM   1122  HB  VAL    74     -17.903   4.822  -6.468  1.00  4.20           H  
ATOM   1123 HG11 VAL    74     -19.014   5.283  -8.595  1.00 36.92           H  
ATOM   1124 HG12 VAL    74     -19.188   6.978  -8.139  1.00 36.92           H  
ATOM   1125 HG13 VAL    74     -20.035   5.728  -7.228  1.00 36.92           H  
ATOM   1126 HG21 VAL    74     -16.557   5.445  -8.416  1.00 36.92           H  
ATOM   1127 HG22 VAL    74     -15.806   5.962  -6.906  1.00 36.92           H  
ATOM   1128 HG23 VAL    74     -16.639   7.137  -7.924  1.00 36.92           H  
ATOM   1129  N   GLU    75     -17.224   5.429  -3.807  1.00 25.23           N  
ATOM   1130  CA  GLU    75     -16.222   4.954  -2.868  1.00 61.11           C  
ATOM   1131  C   GLU    75     -15.567   3.690  -3.386  1.00 54.30           C  
ATOM   1132  O   GLU    75     -16.224   2.657  -3.540  1.00 60.22           O  
ATOM   1133  CB  GLU    75     -16.831   4.678  -1.495  1.00 44.30           C  
ATOM   1134  CG  GLU    75     -17.083   5.925  -0.679  1.00  2.41           C  
ATOM   1135  CD  GLU    75     -17.741   5.628   0.651  1.00 51.44           C  
ATOM   1136  OE1 GLU    75     -18.290   4.516   0.815  1.00 33.35           O  
ATOM   1137  OE2 GLU    75     -17.693   6.496   1.546  1.00 15.14           O  
ATOM   1138  H   GLU    75     -18.095   4.978  -3.847  1.00 52.23           H  
ATOM   1139  HA  GLU    75     -15.467   5.724  -2.770  1.00 22.00           H  
ATOM   1140  HB2 GLU    75     -17.774   4.168  -1.627  1.00 36.92           H  
ATOM   1141  HB3 GLU    75     -16.162   4.040  -0.938  1.00 36.92           H  
ATOM   1142  HG2 GLU    75     -16.137   6.411  -0.491  1.00 36.92           H  
ATOM   1143  HG3 GLU    75     -17.715   6.584  -1.244  1.00 36.92           H  
ATOM   1144  N   LEU    76     -14.285   3.786  -3.670  1.00 12.03           N  
ATOM   1145  CA  LEU    76     -13.500   2.625  -4.045  1.00 73.45           C  
ATOM   1146  C   LEU    76     -12.639   2.229  -2.859  1.00 13.34           C  
ATOM   1147  O   LEU    76     -11.725   2.958  -2.479  1.00 71.02           O  
ATOM   1148  CB  LEU    76     -12.638   2.929  -5.283  1.00 30.32           C  
ATOM   1149  CG  LEU    76     -11.966   1.718  -5.963  1.00 24.24           C  
ATOM   1150  CD1 LEU    76     -10.748   1.240  -5.183  1.00 52.21           C  
ATOM   1151  CD2 LEU    76     -12.963   0.581  -6.137  1.00 40.14           C  
ATOM   1152  H   LEU    76     -13.849   4.665  -3.617  1.00  2.51           H  
ATOM   1153  HA  LEU    76     -14.180   1.817  -4.271  1.00 12.21           H  
ATOM   1154  HB2 LEU    76     -13.265   3.416  -6.015  1.00 36.92           H  
ATOM   1155  HB3 LEU    76     -11.862   3.620  -4.989  1.00 36.92           H  
ATOM   1156  HG  LEU    76     -11.631   2.013  -6.943  1.00  3.32           H  
ATOM   1157 HD11 LEU    76     -10.305   0.395  -5.689  1.00 36.92           H  
ATOM   1158 HD12 LEU    76     -11.049   0.949  -4.189  1.00 36.92           H  
ATOM   1159 HD13 LEU    76     -10.024   2.040  -5.120  1.00 36.92           H  
ATOM   1160 HD21 LEU    76     -13.782   0.909  -6.759  1.00 36.92           H  
ATOM   1161 HD22 LEU    76     -13.343   0.282  -5.170  1.00 36.92           H  
ATOM   1162 HD23 LEU    76     -12.471  -0.259  -6.604  1.00 36.92           H  
ATOM   1163  N   ASP    77     -12.956   1.092  -2.270  1.00 44.04           N  
ATOM   1164  CA  ASP    77     -12.244   0.619  -1.085  1.00 71.33           C  
ATOM   1165  C   ASP    77     -11.896  -0.850  -1.246  1.00 21.25           C  
ATOM   1166  O   ASP    77     -12.757  -1.719  -1.129  1.00  5.21           O  
ATOM   1167  CB  ASP    77     -13.078   0.839   0.186  1.00 30.32           C  
ATOM   1168  CG  ASP    77     -12.360   0.396   1.454  1.00 43.10           C  
ATOM   1169  OD1 ASP    77     -11.302   0.975   1.778  1.00 52.23           O  
ATOM   1170  OD2 ASP    77     -12.863  -0.523   2.140  1.00 61.53           O  
ATOM   1171  H   ASP    77     -13.676   0.543  -2.655  1.00 11.34           H  
ATOM   1172  HA  ASP    77     -11.327   1.184  -1.006  1.00 53.23           H  
ATOM   1173  HB2 ASP    77     -13.308   1.891   0.279  1.00 36.92           H  
ATOM   1174  HB3 ASP    77     -14.001   0.283   0.105  1.00 36.92           H  
ATOM   1175  N   ALA    78     -10.642  -1.121  -1.553  1.00 23.23           N  
ATOM   1176  CA  ALA    78     -10.206  -2.479  -1.820  1.00 62.42           C  
ATOM   1177  C   ALA    78      -9.454  -3.060  -0.634  1.00 62.32           C  
ATOM   1178  O   ALA    78      -8.474  -2.483  -0.161  1.00  3.13           O  
ATOM   1179  CB  ALA    78      -9.338  -2.511  -3.067  1.00 32.42           C  
ATOM   1180  H   ALA    78      -9.988  -0.385  -1.591  1.00 35.04           H  
ATOM   1181  HA  ALA    78     -11.084  -3.079  -2.006  1.00 25.14           H  
ATOM   1182  HB1 ALA    78      -9.042  -3.529  -3.273  1.00 36.92           H  
ATOM   1183  HB2 ALA    78      -8.459  -1.906  -2.907  1.00 36.92           H  
ATOM   1184  HB3 ALA    78      -9.897  -2.122  -3.905  1.00 36.92           H  
ATOM   1185  N   ALA    79      -9.925  -4.201  -0.156  1.00 14.34           N  
ATOM   1186  CA  ALA    79      -9.272  -4.897   0.935  1.00 74.43           C  
ATOM   1187  C   ALA    79      -8.351  -5.982   0.396  1.00 62.11           C  
ATOM   1188  O   ALA    79      -8.807  -6.953  -0.212  1.00 60.22           O  
ATOM   1189  CB  ALA    79     -10.306  -5.489   1.880  1.00 15.01           C  
ATOM   1190  H   ALA    79     -10.743  -4.584  -0.546  1.00 24.21           H  
ATOM   1191  HA  ALA    79      -8.683  -4.177   1.484  1.00 62.25           H  
ATOM   1192  HB1 ALA    79     -10.983  -4.712   2.204  1.00 36.92           H  
ATOM   1193  HB2 ALA    79      -9.808  -5.914   2.739  1.00 36.92           H  
ATOM   1194  HB3 ALA    79     -10.861  -6.260   1.366  1.00 36.92           H  
ATOM   1195  N   PHE    80      -7.057  -5.796   0.603  1.00 44.11           N  
ATOM   1196  CA  PHE    80      -6.057  -6.747   0.142  1.00 65.22           C  
ATOM   1197  C   PHE    80      -5.550  -7.596   1.296  1.00 14.33           C  
ATOM   1198  O   PHE    80      -4.884  -7.094   2.201  1.00 43.53           O  
ATOM   1199  CB  PHE    80      -4.882  -6.015  -0.511  1.00 62.23           C  
ATOM   1200  CG  PHE    80      -5.197  -5.424  -1.857  1.00 12.12           C  
ATOM   1201  CD1 PHE    80      -5.026  -6.170  -3.012  1.00 64.12           C  
ATOM   1202  CD2 PHE    80      -5.660  -4.122  -1.965  1.00  1.25           C  
ATOM   1203  CE1 PHE    80      -5.311  -5.628  -4.251  1.00 23.20           C  
ATOM   1204  CE2 PHE    80      -5.946  -3.576  -3.201  1.00  1.44           C  
ATOM   1205  CZ  PHE    80      -5.771  -4.330  -4.345  1.00  4.21           C  
ATOM   1206  H   PHE    80      -6.763  -4.991   1.089  1.00 31.51           H  
ATOM   1207  HA  PHE    80      -6.522  -7.392  -0.587  1.00 30.54           H  
ATOM   1208  HB2 PHE    80      -4.570  -5.208   0.137  1.00 36.92           H  
ATOM   1209  HB3 PHE    80      -4.060  -6.704  -0.630  1.00 36.92           H  
ATOM   1210  HD1 PHE    80      -4.665  -7.186  -2.938  1.00 24.45           H  
ATOM   1211  HD2 PHE    80      -5.796  -3.530  -1.071  1.00 14.34           H  
ATOM   1212  HE1 PHE    80      -5.173  -6.219  -5.144  1.00 34.43           H  
ATOM   1213  HE2 PHE    80      -6.304  -2.561  -3.272  1.00 24.03           H  
ATOM   1214  HZ  PHE    80      -5.994  -3.904  -5.312  1.00 75.03           H  
ATOM   1215  N   THR    81      -5.864  -8.881   1.257  1.00 11.34           N  
ATOM   1216  CA  THR    81      -5.431  -9.800   2.291  1.00 63.13           C  
ATOM   1217  C   THR    81      -4.085 -10.406   1.929  1.00 62.21           C  
ATOM   1218  O   THR    81      -3.996 -11.274   1.055  1.00  1.30           O  
ATOM   1219  CB  THR    81      -6.464 -10.927   2.510  1.00 55.42           C  
ATOM   1220  OG1 THR    81      -7.730 -10.360   2.875  1.00 23.22           O  
ATOM   1221  CG2 THR    81      -6.002 -11.887   3.599  1.00 51.14           C  
ATOM   1222  H   THR    81      -6.388  -9.224   0.497  1.00 23.55           H  
ATOM   1223  HA  THR    81      -5.332  -9.244   3.212  1.00 12.00           H  
ATOM   1224  HB  THR    81      -6.579 -11.477   1.588  1.00 64.32           H  
ATOM   1225  HG1 THR    81      -7.582  -9.605   3.458  1.00 42.21           H  
ATOM   1226 HG21 THR    81      -5.911 -11.354   4.534  1.00 36.92           H  
ATOM   1227 HG22 THR    81      -5.043 -12.302   3.327  1.00 36.92           H  
ATOM   1228 HG23 THR    81      -6.722 -12.686   3.706  1.00 36.92           H  
ATOM   1229  N   PHE    82      -3.041  -9.929   2.585  1.00 30.33           N  
ATOM   1230  CA  PHE    82      -1.705 -10.441   2.361  1.00 25.52           C  
ATOM   1231  C   PHE    82      -1.409 -11.577   3.328  1.00 12.33           C  
ATOM   1232  O   PHE    82      -2.144 -11.791   4.296  1.00 63.14           O  
ATOM   1233  CB  PHE    82      -0.672  -9.324   2.523  1.00 61.22           C  
ATOM   1234  CG  PHE    82      -0.754  -8.263   1.458  1.00 34.50           C  
ATOM   1235  CD1 PHE    82      -0.074  -8.414   0.261  1.00  4.42           C  
ATOM   1236  CD2 PHE    82      -1.509  -7.119   1.654  1.00  5.35           C  
ATOM   1237  CE1 PHE    82      -0.145  -7.445  -0.720  1.00  1.34           C  
ATOM   1238  CE2 PHE    82      -1.584  -6.144   0.676  1.00 14.24           C  
ATOM   1239  CZ  PHE    82      -0.901  -6.309  -0.512  1.00 62.53           C  
ATOM   1240  H   PHE    82      -3.173  -9.213   3.242  1.00 62.12           H  
ATOM   1241  HA  PHE    82      -1.660 -10.821   1.350  1.00 14.25           H  
ATOM   1242  HB2 PHE    82      -0.819  -8.846   3.479  1.00 36.92           H  
ATOM   1243  HB3 PHE    82       0.320  -9.754   2.491  1.00 36.92           H  
ATOM   1244  HD1 PHE    82       0.517  -9.302   0.095  1.00  5.41           H  
ATOM   1245  HD2 PHE    82      -2.044  -6.991   2.584  1.00 23.51           H  
ATOM   1246  HE1 PHE    82       0.391  -7.574  -1.648  1.00 60.10           H  
ATOM   1247  HE2 PHE    82      -2.177  -5.255   0.840  1.00 64.21           H  
ATOM   1248  HZ  PHE    82      -0.959  -5.549  -1.279  1.00  4.14           H  
ATOM   1249  N   SER    83      -0.337 -12.299   3.069  1.00 75.03           N  
ATOM   1250  CA  SER    83       0.052 -13.409   3.916  1.00 22.32           C  
ATOM   1251  C   SER    83       1.024 -12.920   4.983  1.00 34.44           C  
ATOM   1252  O   SER    83       1.085 -13.455   6.088  1.00 72.02           O  
ATOM   1253  CB  SER    83       0.691 -14.510   3.071  1.00 42.15           C  
ATOM   1254  OG  SER    83      -0.133 -14.842   1.963  1.00 71.23           O  
ATOM   1255  H   SER    83       0.229 -12.062   2.292  1.00 64.54           H  
ATOM   1256  HA  SER    83      -0.834 -13.794   4.396  1.00 51.32           H  
ATOM   1257  HB2 SER    83       1.648 -14.171   2.703  1.00 36.92           H  
ATOM   1258  HB3 SER    83       0.830 -15.392   3.677  1.00 36.92           H  
ATOM   1259  HG  SER    83      -0.148 -14.102   1.347  1.00 63.13           H  
ATOM   1260  N   CYS    84       1.768 -11.880   4.646  1.00 14.33           N  
ATOM   1261  CA  CYS    84       2.748 -11.314   5.552  1.00  3.35           C  
ATOM   1262  C   CYS    84       2.442  -9.840   5.777  1.00 24.12           C  
ATOM   1263  O   CYS    84       1.700  -9.231   5.006  1.00 12.23           O  
ATOM   1264  CB  CYS    84       4.150 -11.465   4.959  1.00 32.54           C  
ATOM   1265  SG  CYS    84       4.440 -13.051   4.143  1.00 64.32           S  
ATOM   1266  H   CYS    84       1.647 -11.474   3.759  1.00 21.02           H  
ATOM   1267  HA  CYS    84       2.692 -11.842   6.493  1.00 43.40           H  
ATOM   1268  HB2 CYS    84       4.306 -10.687   4.228  1.00 36.92           H  
ATOM   1269  HB3 CYS    84       4.878 -11.362   5.750  1.00 36.92           H  
ATOM   1270  HG  CYS    84       4.291 -12.861   2.833  1.00  5.21           H  
ATOM   1271  N   GLN    85       3.009  -9.260   6.820  1.00 12.02           N  
ATOM   1272  CA  GLN    85       2.841  -7.837   7.060  1.00 45.42           C  
ATOM   1273  C   GLN    85       3.818  -7.049   6.206  1.00 45.23           C  
ATOM   1274  O   GLN    85       3.514  -5.945   5.759  1.00 72.34           O  
ATOM   1275  CB  GLN    85       3.032  -7.499   8.537  1.00 24.10           C  
ATOM   1276  CG  GLN    85       2.939  -6.011   8.832  1.00  4.41           C  
ATOM   1277  CD  GLN    85       2.667  -5.733  10.293  1.00 20.40           C  
ATOM   1278  OE1 GLN    85       3.589  -5.561  11.091  1.00  4.15           O  
ATOM   1279  NE2 GLN    85       1.395  -5.704  10.653  1.00  4.11           N  
ATOM   1280  H   GLN    85       3.551  -9.800   7.444  1.00 33.03           H  
ATOM   1281  HA  GLN    85       1.835  -7.572   6.768  1.00 11.14           H  
ATOM   1282  HB2 GLN    85       2.272  -8.005   9.112  1.00 36.92           H  
ATOM   1283  HB3 GLN    85       4.005  -7.848   8.852  1.00 36.92           H  
ATOM   1284  HG2 GLN    85       3.874  -5.544   8.559  1.00 36.92           H  
ATOM   1285  HG3 GLN    85       2.143  -5.586   8.240  1.00 36.92           H  
ATOM   1286 HE21 GLN    85       0.712  -5.861   9.963  1.00 36.92           H  
ATOM   1287 HE22 GLN    85       1.182  -5.534  11.599  1.00 36.92           H  
ATOM   1288  N   ALA    86       4.986  -7.639   5.971  1.00 43.40           N  
ATOM   1289  CA  ALA    86       6.013  -7.022   5.140  1.00  1.11           C  
ATOM   1290  C   ALA    86       5.460  -6.660   3.767  1.00 11.02           C  
ATOM   1291  O   ALA    86       5.602  -5.530   3.312  1.00 13.21           O  
ATOM   1292  CB  ALA    86       7.207  -7.954   5.003  1.00 60.14           C  
ATOM   1293  H   ALA    86       5.170  -8.508   6.384  1.00 20.34           H  
ATOM   1294  HA  ALA    86       6.343  -6.120   5.635  1.00 44.00           H  
ATOM   1295  HB1 ALA    86       6.904  -8.855   4.491  1.00 36.92           H  
ATOM   1296  HB2 ALA    86       7.582  -8.205   5.984  1.00 36.92           H  
ATOM   1297  HB3 ALA    86       7.982  -7.461   4.437  1.00 36.92           H  
ATOM   1298  N   GLU    87       4.804  -7.620   3.128  1.00 34.24           N  
ATOM   1299  CA  GLU    87       4.230  -7.407   1.802  1.00 53.14           C  
ATOM   1300  C   GLU    87       3.065  -6.412   1.851  1.00  2.12           C  
ATOM   1301  O   GLU    87       2.774  -5.740   0.863  1.00  2.04           O  
ATOM   1302  CB  GLU    87       3.792  -8.742   1.188  1.00 73.41           C  
ATOM   1303  CG  GLU    87       3.017  -9.630   2.144  1.00 12.24           C  
ATOM   1304  CD  GLU    87       2.751 -11.017   1.585  1.00 31.21           C  
ATOM   1305  OE1 GLU    87       3.725 -11.734   1.274  1.00 33.21           O  
ATOM   1306  OE2 GLU    87       1.570 -11.395   1.471  1.00 44.22           O  
ATOM   1307  H   GLU    87       4.705  -8.495   3.554  1.00 34.13           H  
ATOM   1308  HA  GLU    87       5.008  -6.984   1.182  1.00 52.24           H  
ATOM   1309  HB2 GLU    87       3.165  -8.540   0.332  1.00 36.92           H  
ATOM   1310  HB3 GLU    87       4.670  -9.279   0.861  1.00 36.92           H  
ATOM   1311  HG2 GLU    87       3.582  -9.732   3.058  1.00 36.92           H  
ATOM   1312  HG3 GLU    87       2.069  -9.159   2.359  1.00 36.92           H  
ATOM   1313  N   MET    88       2.413  -6.310   3.006  1.00 52.33           N  
ATOM   1314  CA  MET    88       1.300  -5.382   3.176  1.00 24.23           C  
ATOM   1315  C   MET    88       1.807  -3.942   3.255  1.00 14.41           C  
ATOM   1316  O   MET    88       1.372  -3.077   2.493  1.00  0.21           O  
ATOM   1317  CB  MET    88       0.490  -5.743   4.433  1.00 34.40           C  
ATOM   1318  CG  MET    88      -0.783  -4.924   4.616  1.00 60.15           C  
ATOM   1319  SD  MET    88      -0.493  -3.301   5.350  1.00  0.12           S  
ATOM   1320  CE  MET    88       0.031  -3.759   7.002  1.00 21.04           C  
ATOM   1321  H   MET    88       2.688  -6.870   3.759  1.00 35.21           H  
ATOM   1322  HA  MET    88       0.660  -5.473   2.309  1.00 72.13           H  
ATOM   1323  HB2 MET    88       0.211  -6.785   4.378  1.00 36.92           H  
ATOM   1324  HB3 MET    88       1.114  -5.594   5.303  1.00 36.92           H  
ATOM   1325  HG2 MET    88      -1.245  -4.783   3.649  1.00 36.92           H  
ATOM   1326  HG3 MET    88      -1.457  -5.476   5.254  1.00 36.92           H  
ATOM   1327  HE1 MET    88       0.905  -4.392   6.940  1.00 36.92           H  
ATOM   1328  HE2 MET    88      -0.767  -4.293   7.497  1.00 36.92           H  
ATOM   1329  HE3 MET    88       0.270  -2.868   7.564  1.00 36.92           H  
ATOM   1330  N   ILE    89       2.745  -3.695   4.163  1.00 35.42           N  
ATOM   1331  CA  ILE    89       3.269  -2.353   4.375  1.00 43.20           C  
ATOM   1332  C   ILE    89       3.995  -1.816   3.142  1.00 61.45           C  
ATOM   1333  O   ILE    89       3.833  -0.649   2.794  1.00 55.34           O  
ATOM   1334  CB  ILE    89       4.210  -2.290   5.596  1.00 34.31           C  
ATOM   1335  CG1 ILE    89       5.259  -3.401   5.532  1.00 51.41           C  
ATOM   1336  CG2 ILE    89       3.407  -2.386   6.884  1.00 41.33           C  
ATOM   1337  CD1 ILE    89       6.361  -3.268   6.558  1.00  5.14           C  
ATOM   1338  H   ILE    89       3.084  -4.429   4.713  1.00 34.24           H  
ATOM   1339  HA  ILE    89       2.425  -1.709   4.579  1.00  1.23           H  
ATOM   1340  HB  ILE    89       4.707  -1.335   5.584  1.00 43.22           H  
ATOM   1341 HG12 ILE    89       4.773  -4.350   5.696  1.00 36.92           H  
ATOM   1342 HG13 ILE    89       5.712  -3.401   4.555  1.00 36.92           H  
ATOM   1343 HG21 ILE    89       4.077  -2.342   7.730  1.00 36.92           H  
ATOM   1344 HG22 ILE    89       2.866  -3.320   6.900  1.00 36.92           H  
ATOM   1345 HG23 ILE    89       2.709  -1.564   6.934  1.00 36.92           H  
ATOM   1346 HD11 ILE    89       6.888  -2.337   6.402  1.00 36.92           H  
ATOM   1347 HD12 ILE    89       7.050  -4.093   6.455  1.00 36.92           H  
ATOM   1348 HD13 ILE    89       5.933  -3.276   7.549  1.00 36.92           H  
ATOM   1349  N   ILE    90       4.778  -2.659   2.470  1.00 32.24           N  
ATOM   1350  CA  ILE    90       5.503  -2.224   1.282  1.00 31.31           C  
ATOM   1351  C   ILE    90       4.533  -1.885   0.152  1.00 73.11           C  
ATOM   1352  O   ILE    90       4.821  -1.042  -0.700  1.00  4.12           O  
ATOM   1353  CB  ILE    90       6.558  -3.259   0.815  1.00 23.53           C  
ATOM   1354  CG1 ILE    90       5.924  -4.601   0.429  1.00 33.53           C  
ATOM   1355  CG2 ILE    90       7.607  -3.464   1.899  1.00 34.14           C  
ATOM   1356  CD1 ILE    90       5.578  -4.718  -1.040  1.00 53.43           C  
ATOM   1357  H   ILE    90       4.876  -3.585   2.779  1.00 55.43           H  
ATOM   1358  HA  ILE    90       6.030  -1.316   1.548  1.00 52.21           H  
ATOM   1359  HB  ILE    90       7.054  -2.849  -0.047  1.00 40.41           H  
ATOM   1360 HG12 ILE    90       6.612  -5.397   0.668  1.00 36.92           H  
ATOM   1361 HG13 ILE    90       5.014  -4.737   0.996  1.00 36.92           H  
ATOM   1362 HG21 ILE    90       8.068  -2.517   2.141  1.00 36.92           H  
ATOM   1363 HG22 ILE    90       8.361  -4.150   1.545  1.00 36.92           H  
ATOM   1364 HG23 ILE    90       7.137  -3.871   2.782  1.00 36.92           H  
ATOM   1365 HD11 ILE    90       5.115  -5.676  -1.223  1.00 36.92           H  
ATOM   1366 HD12 ILE    90       6.479  -4.634  -1.631  1.00 36.92           H  
ATOM   1367 HD13 ILE    90       4.893  -3.929  -1.311  1.00 36.92           H  
ATOM   1368  N   PHE    91       3.384  -2.548   0.152  1.00 12.44           N  
ATOM   1369  CA  PHE    91       2.319  -2.246  -0.793  1.00  4.12           C  
ATOM   1370  C   PHE    91       1.830  -0.816  -0.570  1.00 34.42           C  
ATOM   1371  O   PHE    91       1.723  -0.035  -1.515  1.00 51.31           O  
ATOM   1372  CB  PHE    91       1.172  -3.249  -0.628  1.00  3.51           C  
ATOM   1373  CG  PHE    91       0.042  -3.069  -1.600  1.00 12.43           C  
ATOM   1374  CD1 PHE    91       0.213  -3.358  -2.942  1.00 64.41           C  
ATOM   1375  CD2 PHE    91      -1.193  -2.620  -1.168  1.00  2.12           C  
ATOM   1376  CE1 PHE    91      -0.827  -3.202  -3.837  1.00  1.12           C  
ATOM   1377  CE2 PHE    91      -2.238  -2.463  -2.057  1.00 51.23           C  
ATOM   1378  CZ  PHE    91      -2.054  -2.754  -3.393  1.00 33.21           C  
ATOM   1379  H   PHE    91       3.248  -3.261   0.810  1.00 34.24           H  
ATOM   1380  HA  PHE    91       2.723  -2.328  -1.791  1.00 22.42           H  
ATOM   1381  HB2 PHE    91       1.560  -4.248  -0.757  1.00 36.92           H  
ATOM   1382  HB3 PHE    91       0.769  -3.155   0.370  1.00 36.92           H  
ATOM   1383  HD1 PHE    91       1.172  -3.709  -3.289  1.00 41.40           H  
ATOM   1384  HD2 PHE    91      -1.335  -2.391  -0.122  1.00 71.30           H  
ATOM   1385  HE1 PHE    91      -0.679  -3.430  -4.882  1.00 71.31           H  
ATOM   1386  HE2 PHE    91      -3.198  -2.112  -1.706  1.00 41.33           H  
ATOM   1387  HZ  PHE    91      -2.869  -2.633  -4.092  1.00 14.52           H  
ATOM   1388  N   GLU    92       1.566  -0.479   0.693  1.00 60.31           N  
ATOM   1389  CA  GLU    92       1.198   0.884   1.079  1.00 10.41           C  
ATOM   1390  C   GLU    92       2.265   1.883   0.648  1.00 35.53           C  
ATOM   1391  O   GLU    92       1.952   2.971   0.162  1.00 73.23           O  
ATOM   1392  CB  GLU    92       0.999   0.976   2.593  1.00 11.32           C  
ATOM   1393  CG  GLU    92      -0.192   0.187   3.105  1.00 64.52           C  
ATOM   1394  CD  GLU    92      -1.510   0.842   2.735  1.00 54.45           C  
ATOM   1395  OE1 GLU    92      -1.816   1.931   3.280  1.00 62.31           O  
ATOM   1396  OE2 GLU    92      -2.236   0.284   1.889  1.00 51.03           O  
ATOM   1397  H   GLU    92       1.610  -1.172   1.387  1.00 65.03           H  
ATOM   1398  HA  GLU    92       0.270   1.131   0.588  1.00 64.10           H  
ATOM   1399  HB2 GLU    92       1.887   0.604   3.083  1.00 36.92           H  
ATOM   1400  HB3 GLU    92       0.860   2.015   2.862  1.00 36.92           H  
ATOM   1401  HG2 GLU    92      -0.164  -0.803   2.672  1.00 36.92           H  
ATOM   1402  HG3 GLU    92      -0.125   0.109   4.181  1.00 36.92           H  
ATOM   1403  N   LEU    93       3.524   1.505   0.827  1.00 14.44           N  
ATOM   1404  CA  LEU    93       4.640   2.349   0.424  1.00 24.34           C  
ATOM   1405  C   LEU    93       4.606   2.583  -1.085  1.00 52.55           C  
ATOM   1406  O   LEU    93       4.647   3.724  -1.550  1.00 74.11           O  
ATOM   1407  CB  LEU    93       5.964   1.700   0.832  1.00  3.13           C  
ATOM   1408  CG  LEU    93       6.067   1.306   2.306  1.00 35.43           C  
ATOM   1409  CD1 LEU    93       7.460   0.789   2.622  1.00 62.01           C  
ATOM   1410  CD2 LEU    93       5.712   2.481   3.203  1.00 24.35           C  
ATOM   1411  H   LEU    93       3.706   0.635   1.248  1.00 15.41           H  
ATOM   1412  HA  LEU    93       4.539   3.298   0.929  1.00 74.31           H  
ATOM   1413  HB2 LEU    93       6.102   0.811   0.235  1.00 36.92           H  
ATOM   1414  HB3 LEU    93       6.764   2.391   0.610  1.00 36.92           H  
ATOM   1415  HG  LEU    93       5.364   0.510   2.507  1.00 55.25           H  
ATOM   1416 HD11 LEU    93       8.183   1.571   2.441  1.00 36.92           H  
ATOM   1417 HD12 LEU    93       7.681  -0.058   1.991  1.00 36.92           H  
ATOM   1418 HD13 LEU    93       7.506   0.487   3.659  1.00 36.92           H  
ATOM   1419 HD21 LEU    93       5.766   2.175   4.236  1.00 36.92           H  
ATOM   1420 HD22 LEU    93       4.710   2.818   2.978  1.00 36.92           H  
ATOM   1421 HD23 LEU    93       6.409   3.289   3.031  1.00 36.92           H  
ATOM   1422  N   SER    94       4.526   1.491  -1.834  1.00  0.42           N  
ATOM   1423  CA  SER    94       4.378   1.541  -3.285  1.00 43.13           C  
ATOM   1424  C   SER    94       3.182   2.409  -3.695  1.00 14.02           C  
ATOM   1425  O   SER    94       3.272   3.188  -4.643  1.00  4.35           O  
ATOM   1426  CB  SER    94       4.212   0.120  -3.833  1.00  2.31           C  
ATOM   1427  OG  SER    94       5.285  -0.711  -3.419  1.00 23.35           O  
ATOM   1428  H   SER    94       4.600   0.614  -1.398  1.00 60.22           H  
ATOM   1429  HA  SER    94       5.278   1.972  -3.695  1.00  1.32           H  
ATOM   1430  HB2 SER    94       3.288  -0.299  -3.467  1.00 36.92           H  
ATOM   1431  HB3 SER    94       4.192   0.151  -4.913  1.00 36.92           H  
ATOM   1432  HG  SER    94       5.171  -0.947  -2.492  1.00 41.11           H  
ATOM   1433  N   LEU    95       2.070   2.281  -2.972  1.00 65.10           N  
ATOM   1434  CA  LEU    95       0.882   3.091  -3.234  1.00 21.12           C  
ATOM   1435  C   LEU    95       1.207   4.574  -3.106  1.00 64.05           C  
ATOM   1436  O   LEU    95       0.848   5.375  -3.964  1.00  4.22           O  
ATOM   1437  CB  LEU    95      -0.252   2.736  -2.267  1.00 12.15           C  
ATOM   1438  CG  LEU    95      -0.826   1.327  -2.408  1.00 65.30           C  
ATOM   1439  CD1 LEU    95      -1.894   1.083  -1.355  1.00 40.24           C  
ATOM   1440  CD2 LEU    95      -1.397   1.125  -3.799  1.00 22.31           C  
ATOM   1441  H   LEU    95       2.047   1.617  -2.244  1.00 33.15           H  
ATOM   1442  HA  LEU    95       0.561   2.888  -4.246  1.00 51.10           H  
ATOM   1443  HB2 LEU    95       0.116   2.849  -1.258  1.00 36.92           H  
ATOM   1444  HB3 LEU    95      -1.056   3.442  -2.417  1.00 36.92           H  
ATOM   1445  HG  LEU    95      -0.036   0.604  -2.257  1.00 24.45           H  
ATOM   1446 HD11 LEU    95      -2.701   1.789  -1.489  1.00 36.92           H  
ATOM   1447 HD12 LEU    95      -1.466   1.210  -0.372  1.00 36.92           H  
ATOM   1448 HD13 LEU    95      -2.277   0.078  -1.454  1.00 36.92           H  
ATOM   1449 HD21 LEU    95      -2.186   1.842  -3.972  1.00 36.92           H  
ATOM   1450 HD22 LEU    95      -1.793   0.124  -3.886  1.00 36.92           H  
ATOM   1451 HD23 LEU    95      -0.616   1.267  -4.530  1.00 36.92           H  
ATOM   1452  N   ARG    96       1.900   4.920  -2.030  1.00 52.23           N  
ATOM   1453  CA  ARG    96       2.298   6.299  -1.768  1.00 74.33           C  
ATOM   1454  C   ARG    96       3.264   6.810  -2.829  1.00 44.22           C  
ATOM   1455  O   ARG    96       3.304   8.001  -3.123  1.00 53.24           O  
ATOM   1456  CB  ARG    96       2.932   6.407  -0.385  1.00 63.10           C  
ATOM   1457  CG  ARG    96       1.926   6.265   0.735  1.00 54.05           C  
ATOM   1458  CD  ARG    96       2.605   6.167   2.084  1.00 63.12           C  
ATOM   1459  NE  ARG    96       3.512   7.289   2.341  1.00 62.44           N  
ATOM   1460  CZ  ARG    96       4.058   7.550   3.530  1.00 22.01           C  
ATOM   1461  NH1 ARG    96       3.766   6.797   4.586  1.00  1.44           N  
ATOM   1462  NH2 ARG    96       4.889   8.573   3.660  1.00 42.11           N  
ATOM   1463  H   ARG    96       2.154   4.221  -1.385  1.00 51.31           H  
ATOM   1464  HA  ARG    96       1.407   6.904  -1.783  1.00 74.33           H  
ATOM   1465  HB2 ARG    96       3.676   5.630  -0.276  1.00 36.92           H  
ATOM   1466  HB3 ARG    96       3.411   7.371  -0.292  1.00 36.92           H  
ATOM   1467  HG2 ARG    96       1.272   7.125   0.731  1.00 36.92           H  
ATOM   1468  HG3 ARG    96       1.345   5.370   0.569  1.00 36.92           H  
ATOM   1469  HD2 ARG    96       1.843   6.152   2.842  1.00 36.92           H  
ATOM   1470  HD3 ARG    96       3.167   5.247   2.120  1.00 36.92           H  
ATOM   1471  HE  ARG    96       3.735   7.874   1.582  1.00 72.43           H  
ATOM   1472 HH11 ARG    96       3.136   6.026   4.496  1.00 36.92           H  
ATOM   1473 HH12 ARG    96       4.172   7.001   5.487  1.00 36.92           H  
ATOM   1474 HH21 ARG    96       5.105   9.149   2.864  1.00 36.92           H  
ATOM   1475 HH22 ARG    96       5.317   8.773   4.556  1.00 36.92           H  
ATOM   1476  N   SER    97       4.043   5.903  -3.390  1.00 72.43           N  
ATOM   1477  CA  SER    97       5.027   6.261  -4.398  1.00 45.52           C  
ATOM   1478  C   SER    97       4.378   6.420  -5.779  1.00 73.23           C  
ATOM   1479  O   SER    97       4.681   7.365  -6.510  1.00 53.10           O  
ATOM   1480  CB  SER    97       6.126   5.194  -4.444  1.00 74.24           C  
ATOM   1481  OG  SER    97       7.168   5.554  -5.335  1.00 11.23           O  
ATOM   1482  H   SER    97       3.963   4.965  -3.112  1.00  1.44           H  
ATOM   1483  HA  SER    97       5.467   7.203  -4.109  1.00 55.10           H  
ATOM   1484  HB2 SER    97       6.544   5.070  -3.457  1.00 36.92           H  
ATOM   1485  HB3 SER    97       5.697   4.259  -4.770  1.00 36.92           H  
ATOM   1486  HG  SER    97       7.251   6.522  -5.360  1.00 50.13           H  
ATOM   1487  N   LEU    98       3.481   5.505  -6.130  1.00 34.54           N  
ATOM   1488  CA  LEU    98       2.902   5.485  -7.469  1.00 34.41           C  
ATOM   1489  C   LEU    98       1.629   6.318  -7.543  1.00  1.11           C  
ATOM   1490  O   LEU    98       1.524   7.239  -8.354  1.00 72.25           O  
ATOM   1491  CB  LEU    98       2.597   4.050  -7.893  1.00 12.30           C  
ATOM   1492  CG  LEU    98       2.422   3.854  -9.401  1.00 10.13           C  
ATOM   1493  CD1 LEU    98       3.708   4.199 -10.134  1.00 33.50           C  
ATOM   1494  CD2 LEU    98       1.994   2.431  -9.713  1.00 62.21           C  
ATOM   1495  H   LEU    98       3.208   4.822  -5.477  1.00 62.32           H  
ATOM   1496  HA  LEU    98       3.630   5.901  -8.150  1.00 63.01           H  
ATOM   1497  HB2 LEU    98       3.398   3.419  -7.549  1.00 36.92           H  
ATOM   1498  HB3 LEU    98       1.685   3.740  -7.406  1.00 36.92           H  
ATOM   1499  HG  LEU    98       1.649   4.521  -9.756  1.00 15.40           H  
ATOM   1500 HD11 LEU    98       3.963   5.231  -9.946  1.00 36.92           H  
ATOM   1501 HD12 LEU    98       3.570   4.049 -11.194  1.00 36.92           H  
ATOM   1502 HD13 LEU    98       4.506   3.562  -9.781  1.00 36.92           H  
ATOM   1503 HD21 LEU    98       1.892   2.312 -10.782  1.00 36.92           H  
ATOM   1504 HD22 LEU    98       1.046   2.229  -9.237  1.00 36.92           H  
ATOM   1505 HD23 LEU    98       2.738   1.741  -9.344  1.00 36.92           H  
ATOM   1506  N   ALA    99       0.664   5.990  -6.698  1.00 63.54           N  
ATOM   1507  CA  ALA    99      -0.616   6.682  -6.705  1.00 23.02           C  
ATOM   1508  C   ALA    99      -0.475   8.024  -6.008  1.00  2.43           C  
ATOM   1509  O   ALA    99      -1.050   9.024  -6.441  1.00 53.01           O  
ATOM   1510  CB  ALA    99      -1.689   5.832  -6.036  1.00 72.13           C  
ATOM   1511  H   ALA    99       0.825   5.286  -6.033  1.00 42.21           H  
ATOM   1512  HA  ALA    99      -0.902   6.846  -7.734  1.00 51.33           H  
ATOM   1513  HB1 ALA    99      -1.413   5.645  -5.008  1.00 36.92           H  
ATOM   1514  HB2 ALA    99      -1.784   4.893  -6.560  1.00 36.92           H  
ATOM   1515  HB3 ALA    99      -2.634   6.356  -6.064  1.00 36.92           H  
END
