
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  275 ( 2122),  selected  275 , name 2rgy_A
# Molecule2: number of CA atoms  270 ( 1966),  selected  270 , name T0441.pdb
# PARAMETERS: 2rgy_A.T0441.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    85_A      Y      71          3.398
LGA    G    86_A      S      72          2.424
LGA    I    87_A      -       -           -
LGA    I    88_A      I      73          1.941
LGA    G    89_A      A      74          1.985
LGA    L    90_A      L      75          2.016
LGA    F    91_A      I      76          2.128
LGA    V    92_A      I      77          2.165
LGA    P    93_A      P      78          2.489
LGA    T    94_A      S      79          2.300
LGA    F    95_A      L      80          2.025
LGA    F    96_A      F      81          2.701
LGA    G    97_A      E      82          4.347
LGA    S    98_A      K      83          3.457
LGA    Y    99_A      A      84          3.124
LGA    Y   100_A      C      85          2.210
LGA    G   101_A      A      86          1.461
LGA    T   102_A      H      87          1.198
LGA    I   103_A      F      88          1.353
LGA    L   104_A      L      89          0.934
LGA    K   105_A      P      90          1.756
LGA    Q   106_A      S      91          2.470
LGA    T   107_A      F      92          1.469
LGA    D   108_A      Q      93          0.774
LGA    L   109_A      Q      94          1.893
LGA    E   110_A      A      95          1.832
LGA    L   111_A      L      96          1.026
LGA    R   112_A      N      97          1.252
LGA    A   113_A      K      98          1.614
LGA    V   114_A      A      99          0.745
LGA    H   115_A      G     100          1.732
LGA    R   116_A      Y     101          1.690
LGA    H   117_A      Q     102          1.954
LGA    V   118_A      L     103          1.617
LGA    V   119_A      L     104          2.579
LGA    V   120_A      L     105          2.858
LGA    A   121_A      G     106          2.019
LGA    T   122_A      Y     107          1.903
LGA    G   123_A      S     108          3.072
LGA    C   124_A      D     109           #
LGA    G   125_A      -       -           -
LGA    E   126_A      -       -           -
LGA    S   127_A      -       -           -
LGA    T   128_A      -       -           -
LGA    P   129_A      -       -           -
LGA    R   130_A      Y     110          4.544
LGA    E   131_A      S     111          3.424
LGA    Q   132_A      -       -           -
LGA    A   133_A      I     112          4.479
LGA    L   134_A      E     113          2.823
LGA    E   135_A      Q     114          1.003
LGA    A   136_A      E     115          3.929
LGA    V   137_A      E     116          5.143
LGA    R   138_A      K     117          3.433
LGA    F   139_A      L     118          1.406
LGA    L   140_A      L     119          3.913
LGA    I   141_A      S     120          3.767
LGA    G   142_A      T     121          0.721
LGA    R   143_A      F     122          2.682
LGA    D   144_A      L     123          3.233
LGA    -       -      E     124           -
LGA    -       -      S     125           -
LGA    C   145_A      R     126          5.234
LGA    D   146_A      P     127          3.722
LGA    -       -      A     128           -
LGA    G   147_A      G     129          2.395
LGA    V   148_A      V     130          2.148
LGA    V   149_A      V     131          1.841
LGA    V   150_A      L     132          1.671
LGA    I   151_A      F     133          1.697
LGA    S   152_A      G     134          4.342
LGA    H   153_A      -       -           -
LGA    D   154_A      -       -           -
LGA    L   155_A      -       -           -
LGA    H   156_A      S     135           #
LGA    D   157_A      E     136          2.886
LGA    E   158_A      -       -           -
LGA    D   159_A      H     137          1.889
LGA    L   160_A      S     138          5.133
LGA    D   161_A      Q     139          5.489
LGA    E   162_A      R     140          3.944
LGA    L   163_A      T     141          1.703
LGA    H   164_A      H     142          3.106
LGA    R   165_A      Q     143          2.215
LGA    X   166_A      L     144          1.267
LGA    H   167_A      L     145          1.877
LGA    P   168_A      E     146          3.405
LGA    -       -      A     147           -
LGA    -       -      S     148           -
LGA    -       -      N     149           -
LGA    -       -      T     150           -
LGA    K   169_A      P     151          2.652
LGA    X   170_A      V     152          2.183
LGA    V   171_A      L     153          1.271
LGA    F   172_A      E     154          1.001
LGA    L   173_A      I     155          0.797
LGA    N   174_A      A     156          2.765
LGA    R   175_A      E     157          3.705
LGA    A   176_A      L     158          1.853
LGA    F   177_A      S     159          1.726
LGA    D   178_A      S     160          3.742
LGA    A   179_A      K     161          2.058
LGA    L   180_A      A     162          1.918
LGA    P   181_A      S     163           #
LGA    D   182_A      Y     164          4.809
LGA    A   183_A      L     165          2.229
LGA    S   184_A      N     166          2.591
LGA    F   185_A      I     167          1.349
LGA    C   186_A      G     168          1.949
LGA    P   187_A      V     169          1.562
LGA    D   188_A      D     170          1.989
LGA    H   189_A      H     171          1.669
LGA    R   190_A      F     172          1.780
LGA    R   191_A      E     173          1.238
LGA    G   192_A      V     174          0.913
LGA    G   193_A      G     175          1.040
LGA    E   194_A      K     176          1.052
LGA    L   195_A      A     177          0.724
LGA    A   196_A      C     178          1.017
LGA    A   197_A      T     179          0.820
LGA    A   198_A      R     180          0.904
LGA    T   199_A      H     181          1.021
LGA    L   200_A      L     182          0.588
LGA    I   201_A      I     183          0.581
LGA    E   202_A      E     184          1.339
LGA    H   203_A      Q     185          1.445
LGA    G   204_A      G     186          0.739
LGA    H   205_A      F     187          0.881
LGA    R   206_A      K     188          1.474
LGA    K   207_A      N     189          1.386
LGA    L   208_A      V     190          0.959
LGA    A   209_A      G     191          0.496
LGA    V   210_A      F     192          0.286
LGA    I   211_A      I     193          0.398
LGA    S   212_A      G     194          1.612
LGA    G   213_A      A     195          2.440
LGA    P   214_A      R     196          3.420
LGA    F   215_A      G     197          3.410
LGA    T   216_A      N     198          2.702
LGA    A   217_A      H     199          2.306
LGA    S   218_A      S     200          2.080
LGA    D   219_A      T     201          1.840
LGA    N   220_A      L     202          1.745
LGA    V   221_A      Q     203          1.562
LGA    E   222_A      R     204          1.789
LGA    R   223_A      Q     205          1.660
LGA    L   224_A      L     206          1.776
LGA    D   225_A      H     207          1.579
LGA    G   226_A      G     208          1.974
LGA    F   227_A      W     209          1.607
LGA    F   228_A      Q     210          1.437
LGA    D   229_A      S     211          1.313
LGA    E   230_A      A     212          1.524
LGA    L   231_A      M     213          1.159
LGA    A   232_A      I     214          1.287
LGA    R   233_A      E     215          1.698
LGA    H   234_A      N     216          1.095
LGA    G   235_A      Y     217          0.824
LGA    I   236_A      L     218          0.782
LGA    A   237_A      T     219          2.133
LGA    R   238_A      P     220          2.295
LGA    D   239_A      D     221          3.074
LGA    S   240_A      -       -           -
LGA    V   241_A      -       -           -
LGA    P   242_A      H     222          1.410
LGA    L   243_A      F     223          0.668
LGA    I   244_A      L     224          0.709
LGA    E   245_A      T     225          0.506
LGA    S   246_A      T     226          2.661
LGA    -       -      H     227           -
LGA    D   247_A      E     228          3.445
LGA    F   248_A      A     229          4.245
LGA    S   249_A      P     230          2.072
LGA    P   250_A      S     231          2.015
LGA    E   251_A      S     232          4.943
LGA    G   252_A      -       -           -
LGA    G   253_A      -       -           -
LGA    Y   254_A      Q     233          1.877
LGA    A   255_A      L     234          2.555
LGA    A   256_A      G     235          4.609
LGA    T   257_A      A     236          3.214
LGA    C   258_A      E     237          0.895
LGA    Q   259_A      G     238          4.126
LGA    L   260_A      L     239          3.626
LGA    L   261_A      A     240          1.127
LGA    E   262_A      K     241          3.677
LGA    S   263_A      L     242          4.812
LGA    K   264_A      L     243          3.007
LGA    A   265_A      L     244          4.012
LGA    -       -      R     245           -
LGA    -       -      D     246           -
LGA    P   266_A      S     247          2.299
LGA    -       -      S     248           -
LGA    F   267_A      L     249          1.137
LGA    T   268_A      N     250          0.959
LGA    G   269_A      A     251          0.458
LGA    L   270_A      L     252          0.126
LGA    F   271_A      V     253          0.066
LGA    C   272_A      C     254          0.546
LGA    A   273_A      S     255          1.022
LGA    N   274_A      H     256          1.940
LGA    D   275_A      E     257          1.924
LGA    T   276_A      E     258          2.736
LGA    X   277_A      I     259          1.858
LGA    A   278_A      A     260          1.546
LGA    V   279_A      I     261          2.072
LGA    S   280_A      G     262          2.437
LGA    A   281_A      A     263          1.954
LGA    L   282_A      L     264          2.045
LGA    A   283_A      F     265          2.983
LGA    R   284_A      E     266          2.683
LGA    F   285_A      C     267          2.617
LGA    Q   286_A      H     268          3.035
LGA    Q   287_A      R     269          3.529
LGA    L   288_A      R     270          3.460
LGA    G   289_A      V     271          3.143
LGA    I   290_A      L     272          3.005
LGA    S   291_A      K     273          2.997
LGA    V   292_A      V     274          2.302
LGA    P   293_A      P     275          2.366
LGA    G   294_A      T     276          3.924
LGA    D   295_A      D     277          2.372
LGA    V   296_A      I     278          1.518
LGA    S   297_A      A     279          1.125
LGA    V   298_A      I     280          0.856
LGA    I   299_A      I     281          0.537
LGA    G   300_A      C     282          0.626
LGA    Y   301_A      L     283          1.242
LGA    D   302_A      E     284          2.268
LGA    D   303_A      G     285          3.067
LGA    D   304_A      S     286          2.823
LGA    Y   305_A      S     287          3.495
LGA    S   306_A      M     288          2.386
LGA    A   307_A      G     289          2.614
LGA    A   308_A      E     290          1.865
LGA    Y   309_A      H     291          2.348
LGA    A   310_A      A     292          2.680
LGA    A   311_A      Y     293          2.990
LGA    P   312_A      P     294          2.859
LGA    A   313_A      S     295          2.101
LGA    L   314_A      L     296          2.212
LGA    T   315_A      T     297          1.193
LGA    S   316_A      S     298          0.940
LGA    V   317_A      A     299          1.768
LGA    H   318_A      E     300          2.700
LGA    I   319_A      F     301          3.273
LGA    P   320_A      D     302          4.412
LGA    T   321_A      Y     303          3.223
LGA    A   322_A      E     304          3.502
LGA    E   323_A      R     305          3.599
LGA    L   324_A      M     306          3.569
LGA    T   325_A      G     307          3.814
LGA    Q   326_A      T     308          2.890
LGA    N   327_A      K     309          2.583
LGA    A   328_A      A     310          2.662
LGA    V   329_A      A     311          2.684
LGA    R   330_A      E     312          2.129
LGA    W   331_A      K     313          2.098
LGA    L   332_A      L     314          2.160
LGA    I   333_A      L     315          2.425
LGA    N   334_A      H     316          2.847
LGA    Q   335_A      A     317          3.050
LGA    C   336_A      I     318          3.795
LGA    Y   337_A      -       -           -
LGA    G   338_A      K     319          1.921
LGA    T   339_A      E     321           #
LGA    K   340_A      -       -           -
LGA    W   341_A      P     322           #
LGA    E   342_A      E     323           #
LGA    I   343_A      E     324          4.251
LGA    F   344_A      P     326          5.493
LGA    R   345_A      T     327          0.600
LGA    E   346_A      S     328          1.031
LGA    F   347_A      M     329          2.330
LGA    P   348_A      G     330          3.424
LGA    V   349_A      F     331          3.123
LGA    T   350_A      K     332          3.181
LGA    V   351_A      L     333          1.005
LGA    S   352_A      K     334          1.255
LGA    X   353_A      R     335          1.111
LGA    R   354_A      R     336          1.877
LGA    A   355_A      A     337          2.012
LGA    S   356_A      S     338          1.857
LGA    V   357_A      T     339          1.414
LGA    A   358_A      A     340          2.328
LGA    R   359_A      I     341          3.335
LGA    -       -      N     342           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  275  270    5.0    252    2.50    17.46     63.664     9.704

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.756478 * X  +  -0.006369 * Y  +   0.653989 * Z  +  41.500084
  Y_new =   0.163435 * X  +  -0.970068 * Y  +   0.179601 * Z  +  89.201103
  Z_new =   0.633270 * X  +   0.242748 * Y  +   0.734876 * Z  +  -0.039633 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.319041   -2.822551  [ DEG:    18.2797   -161.7203 ]
  Theta =  -0.685771   -2.455822  [ DEG:   -39.2918   -140.7082 ]
  Phi   =   2.928816   -0.212777  [ DEG:   167.8088    -12.1912 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rgy_A                                        
REMARK     2: T0441.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rgy_A.T0441.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  275  270   5.0  252   2.50   17.46  63.664
REMARK  ---------------------------------------------------------- 
MOLECULE 2rgy_A
HEADER    TRANSCRIPTION REGULATOR                 05-OCT-07   2RGY              
TITLE     CRYSTAL STRUCTURE OF TRANSCRIPTIONAL REGULATOR OF LACI                
TITLE    2 FAMILY FROM BURKHODERIA PHYMATUM                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR, LACI FAMILY;                    
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 81-359;                                           
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BURKHOLDERIA PHYMATUM STM815;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: STM815;                                                      
SOURCE   5 GENE: BPHYDRAFT_4885;                                                
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)RIL;                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_VECTOR: PET;                                       
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PSGX3(BC)                                 
KEYWDS    CRYSTAL STRUCTURE, 11011J, NYSGXRC, TRANSCTIPTIONAL                   
KEYWDS   2 REGULATOR, LACI FAMILY, SUGAR BINDING PROTEIN, STRUCTURAL            
KEYWDS   3 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, NEW YORK              
KEYWDS   4 STRUCTURAL GENOMIX RESEARCH CONSORTIUM, DNA-BINDING,                 
KEYWDS   5 TRANSCRIPTION, TRANSCRIPTION REGULATION, TRANSCRIPTION               
KEYWDS   6 REGULATOR                                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.AGARWAL,S.K.BURLEY,S.SWAMINATHAN,NEW YORK STRUCTURAL                
AUTHOR   2 GENOMIX RESEARCH CONSORTIUM (NYSGXRC)                                
REVDAT   1   23-OCT-07 2RGY    0                                                
JRNL        AUTH   R.AGARWAL,S.K.BURLEY,S.SWAMINATHAN                           
JRNL        TITL   STRUCTURAL ANALYSIS OF TRANSCRIPTION REGULATOR OF            
JRNL        TITL 2 LACI FAMILY FROM BURKHOLDERIA PHYMATUM.                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.05 ANGSTROMS.                                          
DBREF  2RGY A   81   359  UNP    A0FW12   A0FW12_9BURK    81    359             
SEQRES   1 A  290  MSE SER LEU ALA THR GLN GLN LEU GLY ILE ILE GLY LEU          
SEQRES   2 A  290  PHE VAL PRO THR PHE PHE GLY SER TYR TYR GLY THR ILE          
SEQRES   3 A  290  LEU LYS GLN THR ASP LEU GLU LEU ARG ALA VAL HIS ARG          
SEQRES   4 A  290  HIS VAL VAL VAL ALA THR GLY CYS GLY GLU SER THR PRO          
SEQRES   5 A  290  ARG GLU GLN ALA LEU GLU ALA VAL ARG PHE LEU ILE GLY          
SEQRES   6 A  290  ARG ASP CYS ASP GLY VAL VAL VAL ILE SER HIS ASP LEU          
SEQRES   7 A  290  HIS ASP GLU ASP LEU ASP GLU LEU HIS ARG MSE HIS PRO          
SEQRES   8 A  290  LYS MSE VAL PHE LEU ASN ARG ALA PHE ASP ALA LEU PRO          
SEQRES   9 A  290  ASP ALA SER PHE CYS PRO ASP HIS ARG ARG GLY GLY GLU          
SEQRES  10 A  290  LEU ALA ALA ALA THR LEU ILE GLU HIS GLY HIS ARG LYS          
SEQRES  11 A  290  LEU ALA VAL ILE SER GLY PRO PHE THR ALA SER ASP ASN          
SEQRES  12 A  290  VAL GLU ARG LEU ASP GLY PHE PHE ASP GLU LEU ALA ARG          
SEQRES  13 A  290  HIS GLY ILE ALA ARG ASP SER VAL PRO LEU ILE GLU SER          
SEQRES  14 A  290  ASP PHE SER PRO GLU GLY GLY TYR ALA ALA THR CYS GLN          
SEQRES  15 A  290  LEU LEU GLU SER LYS ALA PRO PHE THR GLY LEU PHE CYS          
SEQRES  16 A  290  ALA ASN ASP THR MSE ALA VAL SER ALA LEU ALA ARG PHE          
SEQRES  17 A  290  GLN GLN LEU GLY ILE SER VAL PRO GLY ASP VAL SER VAL          
SEQRES  18 A  290  ILE GLY TYR ASP ASP ASP TYR SER ALA ALA TYR ALA ALA          
SEQRES  19 A  290  PRO ALA LEU THR SER VAL HIS ILE PRO THR ALA GLU LEU          
SEQRES  20 A  290  THR GLN ASN ALA VAL ARG TRP LEU ILE ASN GLN CYS TYR          
SEQRES  21 A  290  GLY THR LYS TRP GLU ILE PHE ARG GLU PHE PRO VAL THR          
SEQRES  22 A  290  VAL SER MSE ARG ALA SER VAL ALA ARG GLU GLY HIS HIS          
SEQRES  23 A  290  HIS HIS HIS HIS                                              
HET    MSE  A 166       8                                                       
HET    MSE  A 170       8                                                       
HET    MSE  A 277       8                                                       
HET    MSE  A 353       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *174(H2 O)                                                    
CRYST1   58.543  118.777   85.439  90.00  90.00  90.00 C 2 2 21      8          
ATOM      1  N   LEU A  85      49.844  89.344  13.021  1.00 23.48           N  
ATOM      2  CA  LEU A  85      51.125  88.864  13.626  1.00 22.50           C  
ATOM      3  C   LEU A  85      51.665  87.646  12.885  1.00 21.85           C  
ATOM      4  O   LEU A  85      52.863  87.377  12.912  1.00 24.00           O  
ATOM      5  CB  LEU A  85      50.908  88.515  15.104  1.00 24.75           C  
ATOM      6  CG  LEU A  85      52.058  87.930  15.929  1.00 25.60           C  
ATOM      7  CD1 LEU A  85      53.237  88.904  15.991  1.00 25.96           C  
ATOM      8  CD2 LEU A  85      51.538  87.650  17.340  1.00 25.89           C  
ATOM      9  N   GLY A  86      50.779  86.912  12.225  1.00 20.46           N  
ATOM     10  CA  GLY A  86      51.196  85.728  11.492  1.00 20.80           C  
ATOM     11  C   GLY A  86      51.451  84.525  12.389  1.00 21.32           C  
ATOM     12  O   GLY A  86      52.163  83.596  12.002  1.00 21.61           O  
ATOM     13  N   ILE A  87      50.873  84.548  13.588  1.00 20.37           N  
ATOM     14  CA  ILE A  87      51.034  83.457  14.548  1.00 19.73           C  
ATOM     15  C   ILE A  87      49.700  83.041  15.150  1.00 17.32           C  
ATOM     16  O   ILE A  87      48.864  83.881  15.490  1.00 16.87           O  
ATOM     17  CB  ILE A  87      51.927  83.847  15.756  1.00 22.14           C  
ATOM     18  CG1 ILE A  87      53.149  84.640  15.304  1.00 25.22           C  
ATOM     19  CG2 ILE A  87      52.367  82.600  16.492  1.00 24.65           C  
ATOM     20  CD1 ILE A  87      53.962  83.974  14.246  1.00 29.38           C  
ATOM     21  N   ILE A  88      49.508  81.738  15.283  1.00 16.17           N  
ATOM     22  CA  ILE A  88      48.309  81.219  15.904  1.00 16.99           C  
ATOM     23  C   ILE A  88      48.791  80.587  17.198  1.00 17.88           C  
ATOM     24  O   ILE A  88      49.842  79.955  17.227  1.00 18.27           O  
ATOM     25  CB  ILE A  88      47.605  80.181  14.995  1.00 18.54           C  
ATOM     26  CG1 ILE A  88      46.799  80.921  13.922  1.00 19.21           C  
ATOM     27  CG2 ILE A  88      46.693  79.276  15.820  1.00 18.70           C  
ATOM     28  CD1 ILE A  88      45.966  80.019  13.027  1.00 23.12           C  
ATOM     29  N   GLY A  89      48.058  80.796  18.282  1.00 18.55           N  
ATOM     30  CA  GLY A  89      48.470  80.221  19.549  1.00 18.82           C  
ATOM     31  C   GLY A  89      47.844  78.859  19.759  1.00 18.94           C  
ATOM     32  O   GLY A  89      46.756  78.606  19.255  1.00 20.11           O  
ATOM     33  N   LEU A  90      48.526  77.983  20.490  1.00 16.95           N  
ATOM     34  CA  LEU A  90      48.017  76.643  20.753  1.00 17.49           C  
ATOM     35  C   LEU A  90      48.232  76.206  22.197  1.00 15.70           C  
ATOM     36  O   LEU A  90      49.360  76.203  22.687  1.00 15.18           O  
ATOM     37  CB  LEU A  90      48.696  75.624  19.833  1.00 16.73           C  
ATOM     38  CG  LEU A  90      48.507  74.148  20.212  1.00 17.23           C  
ATOM     39  CD1 LEU A  90      47.034  73.767  20.158  1.00 17.13           C  
ATOM     40  CD2 LEU A  90      49.312  73.277  19.255  1.00 20.56           C  
ATOM     41  N   PHE A  91      47.155  75.842  22.879  1.00 15.75           N  
ATOM     42  CA  PHE A  91      47.291  75.364  24.244  1.00 16.65           C  
ATOM     43  C   PHE A  91      47.005  73.867  24.319  1.00 16.83           C  
ATOM     44  O   PHE A  91      46.002  73.387  23.791  1.00 16.88           O  
ATOM     45  CB  PHE A  91      46.330  76.060  25.200  1.00 14.85           C  
ATOM     46  CG  PHE A  91      46.336  75.460  26.579  1.00 17.37           C  
ATOM     47  CD1 PHE A  91      47.317  75.819  27.500  1.00 15.80           C  
ATOM     48  CD2 PHE A  91      45.397  74.484  26.936  1.00 17.34           C  
ATOM     49  CE1 PHE A  91      47.370  75.216  28.769  1.00 17.33           C  
ATOM     50  CE2 PHE A  91      45.436  73.872  28.199  1.00 17.88           C  
ATOM     51  CZ  PHE A  91      46.428  74.241  29.119  1.00 15.70           C  
ATOM     52  N   VAL A  92      47.901  73.143  24.974  1.00 17.27           N  
ATOM     53  CA  VAL A  92      47.746  71.715  25.191  1.00 18.52           C  
ATOM     54  C   VAL A  92      48.095  71.533  26.667  1.00 19.73           C  
ATOM     55  O   VAL A  92      49.016  72.179  27.182  1.00 19.88           O  
ATOM     56  CB  VAL A  92      48.702  70.877  24.315  1.00 17.73           C  
ATOM     57  CG1 VAL A  92      48.320  71.011  22.854  1.00 20.69           C  
ATOM     58  CG2 VAL A  92      50.138  71.322  24.535  1.00 18.99           C  
ATOM     59  N   PRO A  93      47.355  70.673  27.372  1.00 20.72           N  
ATOM     60  CA  PRO A  93      47.624  70.452  28.797  1.00 22.35           C  
ATOM     61  C   PRO A  93      48.983  69.834  29.115  1.00 23.62           C  
ATOM     62  O   PRO A  93      49.407  69.846  30.272  1.00 25.35           O  
ATOM     63  CB  PRO A  93      46.462  69.571  29.232  1.00 21.51           C  
ATOM     64  CG  PRO A  93      46.125  68.813  27.979  1.00 23.29           C  
ATOM     65  CD  PRO A  93      46.211  69.867  26.915  1.00 20.84           C  
ATOM     66  N   THR A  94      49.665  69.310  28.097  1.00 23.16           N  
ATOM     67  CA  THR A  94      50.979  68.687  28.284  1.00 23.94           C  
ATOM     68  C   THR A  94      51.582  68.312  26.928  1.00 23.13           C  
ATOM     69  O   THR A  94      50.851  68.102  25.965  1.00 23.66           O  
ATOM     70  CB  THR A  94      50.861  67.413  29.165  1.00 26.17           C  
ATOM     71  OG1 THR A  94      52.165  66.888  29.452  1.00 27.84           O  
ATOM     72  CG2 THR A  94      50.033  66.348  28.455  1.00 27.46           C  
ATOM     73  N   PHE A  95      52.909  68.259  26.849  1.00 22.28           N  
ATOM     74  CA  PHE A  95      53.593  67.902  25.605  1.00 23.73           C  
ATOM     75  C   PHE A  95      53.766  66.395  25.477  1.00 25.32           C  
ATOM     76  O   PHE A  95      54.212  65.909  24.440  1.00 25.76           O  
ATOM     77  CB  PHE A  95      54.982  68.541  25.547  1.00 24.70           C  
ATOM     78  CG  PHE A  95      54.966  70.030  25.396  1.00 25.17           C  
ATOM     79  CD1 PHE A  95      54.627  70.613  24.175  1.00 26.85           C  
ATOM     80  CD2 PHE A  95      55.316  70.854  26.468  1.00 26.22           C  
ATOM     81  CE1 PHE A  95      54.635  72.009  24.014  1.00 28.33           C  
ATOM     82  CE2 PHE A  95      55.331  72.253  26.333  1.00 27.88           C  
ATOM     83  CZ  PHE A  95      54.990  72.836  25.098  1.00 28.79           C  
ATOM     84  N   PHE A  96      53.427  65.660  26.532  1.00 25.49           N  
ATOM     85  CA  PHE A  96      53.584  64.209  26.522  1.00 25.56           C  
ATOM     86  C   PHE A  96      52.367  63.411  26.090  1.00 26.10           C  
ATOM     87  O   PHE A  96      51.232  63.791  26.358  1.00 25.24           O  
ATOM     88  CB  PHE A  96      54.031  63.735  27.898  1.00 26.02           C  
ATOM     89  CG  PHE A  96      55.284  64.404  28.378  1.00 26.80           C  
ATOM     90  CD1 PHE A  96      55.223  65.467  29.280  1.00 27.03           C  
ATOM     91  CD2 PHE A  96      56.525  63.986  27.903  1.00 25.97           C  
ATOM     92  CE1 PHE A  96      56.391  66.114  29.708  1.00 28.08           C  
ATOM     93  CE2 PHE A  96      57.705  64.619  28.317  1.00 27.06           C  
ATOM     94  CZ  PHE A  96      57.639  65.686  29.222  1.00 27.03           C  
ATOM     95  N   GLY A  97      52.632  62.273  25.449  1.00 26.90           N  
ATOM     96  CA  GLY A  97      51.576  61.413  24.949  1.00 26.40           C  
ATOM     97  C   GLY A  97      51.498  61.655  23.456  1.00 26.78           C  
ATOM     98  O   GLY A  97      51.498  62.810  23.033  1.00 26.60           O  
ATOM     99  N   SER A  98      51.454  60.600  22.646  1.00 26.01           N  
ATOM    100  CA  SER A  98      51.384  60.785  21.200  1.00 26.26           C  
ATOM    101  C   SER A  98      50.085  61.472  20.761  1.00 25.50           C  
ATOM    102  O   SER A  98      49.975  61.974  19.643  1.00 23.89           O  
ATOM    103  CB  SER A  98      51.546  59.441  20.485  1.00 29.14           C  
ATOM    104  OG  SER A  98      50.556  58.514  20.895  1.00 33.33           O  
ATOM    105  N   TYR A  99      49.102  61.490  21.655  1.00 25.80           N  
ATOM    106  CA  TYR A  99      47.819  62.132  21.378  1.00 24.80           C  
ATOM    107  C   TYR A  99      48.068  63.637  21.241  1.00 23.09           C  
ATOM    108  O   TYR A  99      47.656  64.263  20.269  1.00 21.59           O  
ATOM    109  CB  TYR A  99      46.838  61.864  22.524  1.00 25.54           C  
ATOM    110  CG  TYR A  99      45.516  62.571  22.374  1.00 28.04           C  
ATOM    111  CD1 TYR A  99      44.557  62.128  21.457  1.00 28.00           C  
ATOM    112  CD2 TYR A  99      45.226  63.694  23.143  1.00 27.87           C  
ATOM    113  CE1 TYR A  99      43.333  62.795  21.317  1.00 27.41           C  
ATOM    114  CE2 TYR A  99      44.017  64.364  23.013  1.00 28.65           C  
ATOM    115  CZ  TYR A  99      43.074  63.912  22.098  1.00 28.40           C  
ATOM    116  OH  TYR A  99      41.889  64.602  21.977  1.00 27.42           O  
ATOM    117  N   TYR A 100      48.757  64.218  22.219  1.00 22.31           N  
ATOM    118  CA  TYR A 100      49.040  65.641  22.154  1.00 20.82           C  
ATOM    119  C   TYR A 100      50.094  65.925  21.094  1.00 20.20           C  
ATOM    120  O   TYR A 100      50.087  66.991  20.490  1.00 19.58           O  
ATOM    121  CB  TYR A 100      49.467  66.162  23.523  1.00 20.78           C  
ATOM    122  CG  TYR A 100      48.323  66.105  24.507  1.00 24.04           C  
ATOM    123  CD1 TYR A 100      47.194  66.900  24.330  1.00 23.46           C  
ATOM    124  CD2 TYR A 100      48.333  65.202  25.564  1.00 25.47           C  
ATOM    125  CE1 TYR A 100      46.092  66.792  25.179  1.00 26.25           C  
ATOM    126  CE2 TYR A 100      47.240  65.082  26.423  1.00 27.37           C  
ATOM    127  CZ  TYR A 100      46.122  65.883  26.221  1.00 27.75           C  
ATOM    128  OH  TYR A 100      45.027  65.765  27.054  1.00 27.48           O  
ATOM    129  N   GLY A 101      50.990  64.970  20.861  1.00 19.68           N  
ATOM    130  CA  GLY A 101      51.999  65.158  19.836  1.00 18.99           C  
ATOM    131  C   GLY A 101      51.329  65.286  18.477  1.00 19.46           C  
ATOM    132  O   GLY A 101      51.761  66.063  17.625  1.00 18.57           O  
ATOM    133  N   THR A 102      50.265  64.516  18.274  1.00 18.28           N  
ATOM    134  CA  THR A 102      49.519  64.541  17.016  1.00 20.46           C  
ATOM    135  C   THR A 102      48.896  65.913  16.781  1.00 18.78           C  
ATOM    136  O   THR A 102      48.914  66.444  15.672  1.00 17.05           O  
ATOM    137  CB  THR A 102      48.389  63.491  17.033  1.00 21.52           C  
ATOM    138  OG1 THR A 102      48.963  62.195  17.249  1.00 24.61           O  
ATOM    139  CG2 THR A 102      47.624  63.499  15.711  1.00 21.81           C  
ATOM    140  N   ILE A 103      48.338  66.477  17.844  1.00 18.24           N  
ATOM    141  CA  ILE A 103      47.702  67.782  17.776  1.00 17.62           C  
ATOM    142  C   ILE A 103      48.744  68.844  17.461  1.00 18.11           C  
ATOM    143  O   ILE A 103      48.502  69.721  16.635  1.00 17.52           O  
ATOM    144  CB  ILE A 103      47.008  68.097  19.108  1.00 17.99           C  
ATOM    145  CG1 ILE A 103      45.900  67.074  19.350  1.00 17.85           C  
ATOM    146  CG2 ILE A 103      46.435  69.500  19.099  1.00 16.61           C  
ATOM    147  CD1 ILE A 103      45.289  67.161  20.720  1.00 20.26           C  
ATOM    148  N   LEU A 104      49.904  68.749  18.105  1.00 17.52           N  
ATOM    149  CA  LEU A 104      50.983  69.704  17.874  1.00 18.28           C  
ATOM    150  C   LEU A 104      51.478  69.590  16.437  1.00 18.76           C  
ATOM    151  O   LEU A 104      51.667  70.597  15.749  1.00 17.06           O  
ATOM    152  CB  LEU A 104      52.160  69.436  18.820  1.00 21.61           C  
ATOM    153  CG  LEU A 104      51.879  69.415  20.326  1.00 23.53           C  
ATOM    154  CD1 LEU A 104      53.138  69.015  21.058  1.00 25.15           C  
ATOM    155  CD2 LEU A 104      51.394  70.782  20.787  1.00 24.03           C  
ATOM    156  N   LYS A 105      51.694  68.360  15.984  1.00 17.26           N  
ATOM    157  CA  LYS A 105      52.191  68.142  14.633  1.00 18.63           C  
ATOM    158  C   LYS A 105      51.251  68.703  13.570  1.00 18.35           C  
ATOM    159  O   LYS A 105      51.688  69.454  12.704  1.00 18.28           O  
ATOM    160  CB  LYS A 105      52.430  66.649  14.388  1.00 20.52           C  
ATOM    161  CG  LYS A 105      52.935  66.301  12.985  1.00 23.65           C  
ATOM    162  CD  LYS A 105      53.113  64.779  12.842  1.00 28.86           C  
ATOM    163  CE  LYS A 105      53.404  64.356  11.396  1.00 33.16           C  
ATOM    164  NZ  LYS A 105      53.422  62.853  11.233  1.00 33.23           N  
ATOM    165  N   GLN A 106      49.972  68.341  13.636  1.00 18.37           N  
ATOM    166  CA  GLN A 106      48.992  68.823  12.662  1.00 19.27           C  
ATOM    167  C   GLN A 106      48.826  70.336  12.679  1.00 17.97           C  
ATOM    168  O   GLN A 106      48.635  70.944  11.635  1.00 17.73           O  
ATOM    169  CB  GLN A 106      47.620  68.191  12.894  1.00 19.49           C  
ATOM    170  CG  GLN A 106      47.502  66.760  12.431  1.00 25.62           C  
ATOM    171  CD  GLN A 106      47.964  66.575  10.999  1.00 23.80           C  
ATOM    172  OE1 GLN A 106      47.541  67.291  10.093  1.00 25.93           O  
ATOM    173  NE2 GLN A 106      48.840  65.612  10.794  1.00 28.32           N  
ATOM    174  N   THR A 107      48.877  70.943  13.862  1.00 17.32           N  
ATOM    175  CA  THR A 107      48.731  72.390  13.948  1.00 18.20           C  
ATOM    176  C   THR A 107      49.936  73.031  13.254  1.00 18.86           C  
ATOM    177  O   THR A 107      49.778  73.917  12.417  1.00 20.60           O  
ATOM    178  CB  THR A 107      48.660  72.868  15.420  1.00 20.16           C  
ATOM    179  OG1 THR A 107      47.600  72.186  16.100  1.00 17.87           O  
ATOM    180  CG2 THR A 107      48.396  74.369  15.479  1.00 20.29           C  
ATOM    181  N   ASP A 108      51.136  72.570  13.595  1.00 20.46           N  
ATOM    182  CA  ASP A 108      52.371  73.087  12.999  1.00 22.33           C  
ATOM    183  C   ASP A 108      52.322  72.942  11.478  1.00 21.82           C  
ATOM    184  O   ASP A 108      52.671  73.862  10.741  1.00 23.65           O  
ATOM    185  CB  ASP A 108      53.582  72.323  13.568  1.00 24.47           C  
ATOM    186  CG  ASP A 108      54.904  72.708  12.897  1.00 27.46           C  
ATOM    187  OD1 ASP A 108      55.152  73.917  12.693  1.00 27.73           O  
ATOM    188  OD2 ASP A 108      55.714  71.800  12.591  1.00 30.43           O  
ATOM    189  N   LEU A 109      51.856  71.781  11.035  1.00 21.90           N  
ATOM    190  CA  LEU A 109      51.742  71.432   9.624  1.00 22.85           C  
ATOM    191  C   LEU A 109      50.839  72.372   8.824  1.00 21.71           C  
ATOM    192  O   LEU A 109      51.249  72.918   7.796  1.00 20.37           O  
ATOM    193  CB  LEU A 109      51.222  69.996   9.520  1.00 25.97           C  
ATOM    194  CG  LEU A 109      51.796  69.041   8.477  1.00 29.40           C  
ATOM    195  CD1 LEU A 109      53.307  69.176   8.436  1.00 30.49           C  
ATOM    196  CD2 LEU A 109      51.398  67.597   8.827  1.00 30.29           C  
ATOM    197  N   GLU A 110      49.609  72.560   9.291  1.00 20.17           N  
ATOM    198  CA  GLU A 110      48.679  73.424   8.581  1.00 20.35           C  
ATOM    199  C   GLU A 110      49.148  74.873   8.553  1.00 20.54           C  
ATOM    200  O   GLU A 110      48.898  75.598   7.586  1.00 19.71           O  
ATOM    201  CB  GLU A 110      47.287  73.329   9.200  1.00 19.84           C  
ATOM    202  CG  GLU A 110      46.614  71.966   9.008  1.00 23.23           C  
ATOM    203  CD  GLU A 110      46.586  71.493   7.544  1.00 24.05           C  
ATOM    204  OE1 GLU A 110      46.260  72.297   6.644  1.00 25.36           O  
ATOM    205  OE2 GLU A 110      46.877  70.300   7.296  1.00 24.33           O  
ATOM    206  N   LEU A 111      49.828  75.298   9.612  1.00 19.05           N  
ATOM    207  CA  LEU A 111      50.330  76.662   9.675  1.00 19.10           C  
ATOM    208  C   LEU A 111      51.540  76.837   8.764  1.00 18.91           C  
ATOM    209  O   LEU A 111      51.684  77.871   8.119  1.00 16.96           O  
ATOM    210  CB  LEU A 111      50.698  77.028  11.110  1.00 18.97           C  
ATOM    211  CG  LEU A 111      49.544  77.473  12.001  1.00 20.84           C  
ATOM    212  CD1 LEU A 111      50.026  77.582  13.425  1.00 24.61           C  
ATOM    213  CD2 LEU A 111      49.023  78.815  11.521  1.00 23.69           C  
ATOM    214  N   ARG A 112      52.408  75.831   8.716  1.00 18.47           N  
ATOM    215  CA  ARG A 112      53.588  75.903   7.862  1.00 19.55           C  
ATOM    216  C   ARG A 112      53.131  76.027   6.409  1.00 20.60           C  
ATOM    217  O   ARG A 112      53.698  76.797   5.634  1.00 19.24           O  
ATOM    218  CB  ARG A 112      54.438  74.645   8.004  1.00 19.97           C  
ATOM    219  CG  ARG A 112      55.783  74.745   7.309  1.00 20.42           C  
ATOM    220  CD  ARG A 112      56.732  75.607   8.136  1.00 20.66           C  
ATOM    221  NE  ARG A 112      56.926  75.025   9.464  1.00 22.60           N  
ATOM    222  CZ  ARG A 112      57.757  74.023   9.733  1.00 21.54           C  
ATOM    223  NH1 ARG A 112      58.500  73.479   8.773  1.00 18.31           N  
ATOM    224  NH2 ARG A 112      57.824  73.540  10.968  1.00 20.11           N  
ATOM    225  N   ALA A 113      52.098  75.263   6.065  1.00 20.17           N  
ATOM    226  CA  ALA A 113      51.535  75.263   4.718  1.00 22.23           C  
ATOM    227  C   ALA A 113      51.156  76.673   4.260  1.00 22.54           C  
ATOM    228  O   ALA A 113      51.208  76.979   3.064  1.00 22.47           O  
ATOM    229  CB  ALA A 113      50.310  74.350   4.669  1.00 22.02           C  
ATOM    230  N   VAL A 114      50.753  77.528   5.200  1.00 20.89           N  
ATOM    231  CA  VAL A 114      50.408  78.897   4.836  1.00 20.67           C  
ATOM    232  C   VAL A 114      51.501  79.861   5.270  1.00 21.75           C  
ATOM    233  O   VAL A 114      51.257  81.049   5.481  1.00 22.07           O  
ATOM    234  CB  VAL A 114      49.045  79.335   5.419  1.00 20.97           C  
ATOM    235  CG1 VAL A 114      47.947  78.470   4.835  1.00 22.55           C  
ATOM    236  CG2 VAL A 114      49.051  79.253   6.937  1.00 19.24           C  
ATOM    237  N   HIS A 115      52.712  79.325   5.396  1.00 22.63           N  
ATOM    238  CA  HIS A 115      53.893  80.102   5.764  1.00 22.59           C  
ATOM    239  C   HIS A 115      53.766  80.908   7.051  1.00 21.60           C  
ATOM    240  O   HIS A 115      54.250  82.035   7.130  1.00 19.40           O  
ATOM    241  CB  HIS A 115      54.261  81.032   4.607  1.00 26.38           C  
ATOM    242  CG  HIS A 115      54.381  80.328   3.291  1.00 30.42           C  
ATOM    243  ND1 HIS A 115      55.293  79.317   3.070  1.00 32.95           N  
ATOM    244  CD2 HIS A 115      53.684  80.465   2.137  1.00 32.21           C  
ATOM    245  CE1 HIS A 115      55.152  78.861   1.837  1.00 34.54           C  
ATOM    246  NE2 HIS A 115      54.183  79.541   1.251  1.00 34.09           N  
ATOM    247  N   ARG A 116      53.126  80.325   8.058  1.00 20.36           N  
ATOM    248  CA  ARG A 116      52.962  81.000   9.335  1.00 19.73           C  
ATOM    249  C   ARG A 116      53.402  80.106  10.492  1.00 18.78           C  
ATOM    250  O   ARG A 116      53.630  78.914  10.303  1.00 18.98           O  
ATOM    251  CB  ARG A 116      51.516  81.473   9.491  1.00 20.35           C  
ATOM    252  CG  ARG A 116      51.183  82.606   8.512  1.00 23.64           C  
ATOM    253  CD  ARG A 116      49.734  83.046   8.594  1.00 22.48           C  
ATOM    254  NE  ARG A 116      49.445  84.228   7.776  1.00 23.68           N  
ATOM    255  CZ  ARG A 116      49.136  84.204   6.479  1.00 23.04           C  
ATOM    256  NH1 ARG A 116      49.077  83.058   5.813  1.00 21.29           N  
ATOM    257  NH2 ARG A 116      48.844  85.335   5.853  1.00 22.66           N  
ATOM    258  N   HIS A 117      53.510  80.682  11.685  1.00 16.61           N  
ATOM    259  CA  HIS A 117      53.998  79.951  12.847  1.00 16.88           C  
ATOM    260  C   HIS A 117      53.013  79.651  13.977  1.00 17.41           C  
ATOM    261  O   HIS A 117      51.913  80.196  14.045  1.00 18.52           O  
ATOM    262  CB  HIS A 117      55.189  80.696  13.442  1.00 16.14           C  
ATOM    263  CG  HIS A 117      56.267  81.020  12.454  1.00 17.68           C  
ATOM    264  ND1 HIS A 117      56.122  81.984  11.478  1.00 17.83           N  
ATOM    265  CD2 HIS A 117      57.523  80.538  12.323  1.00 18.46           C  
ATOM    266  CE1 HIS A 117      57.247  82.085  10.793  1.00 17.22           C  
ATOM    267  NE2 HIS A 117      58.113  81.221  11.285  1.00 18.82           N  
ATOM    268  N   VAL A 118      53.443  78.784  14.880  1.00 17.46           N  
ATOM    269  CA  VAL A 118      52.627  78.410  16.015  1.00 17.89           C  
ATOM    270  C   VAL A 118      53.399  78.625  17.313  1.00 17.55           C  
ATOM    271  O   VAL A 118      54.567  78.252  17.432  1.00 17.69           O  
ATOM    272  CB  VAL A 118      52.212  76.936  15.932  1.00 20.44           C  
ATOM    273  CG1 VAL A 118      53.449  76.066  15.890  1.00 23.18           C  
ATOM    274  CG2 VAL A 118      51.338  76.562  17.116  1.00 19.27           C  
ATOM    275  N   VAL A 119      52.742  79.262  18.268  1.00 16.97           N  
ATOM    276  CA  VAL A 119      53.318  79.484  19.576  1.00 17.23           C  
ATOM    277  C   VAL A 119      52.573  78.494  20.456  1.00 17.68           C  
ATOM    278  O   VAL A 119      51.341  78.469  20.453  1.00 18.11           O  
ATOM    279  CB  VAL A 119      53.054  80.909  20.087  1.00 18.29           C  
ATOM    280  CG1 VAL A 119      53.267  80.966  21.598  1.00 18.04           C  
ATOM    281  CG2 VAL A 119      53.995  81.881  19.394  1.00 19.51           C  
ATOM    282  N   VAL A 120      53.309  77.663  21.183  1.00 16.59           N  
ATOM    283  CA  VAL A 120      52.674  76.680  22.046  1.00 20.04           C  
ATOM    284  C   VAL A 120      52.789  77.070  23.507  1.00 20.71           C  
ATOM    285  O   VAL A 120      53.767  77.697  23.930  1.00 19.93           O  
ATOM    286  CB  VAL A 120      53.293  75.273  21.871  1.00 21.77           C  
ATOM    287  CG1 VAL A 120      52.526  74.254  22.721  1.00 24.92           C  
ATOM    288  CG2 VAL A 120      53.256  74.869  20.412  1.00 24.05           C  
ATOM    289  N   ALA A 121      51.773  76.692  24.272  1.00 21.32           N  
ATOM    290  CA  ALA A 121      51.745  76.971  25.692  1.00 21.94           C  
ATOM    291  C   ALA A 121      51.082  75.791  26.398  1.00 21.59           C  
ATOM    292  O   ALA A 121      50.140  75.199  25.873  1.00 21.39           O  
ATOM    293  CB  ALA A 121      50.969  78.243  25.951  1.00 22.12           C  
ATOM    294  N   THR A 122      51.596  75.435  27.568  1.00 21.93           N  
ATOM    295  CA  THR A 122      51.030  74.348  28.349  1.00 22.65           C  
ATOM    296  C   THR A 122      50.896  74.821  29.790  1.00 23.72           C  
ATOM    297  O   THR A 122      51.336  75.920  30.128  1.00 22.25           O  
ATOM    298  CB  THR A 122      51.912  73.090  28.301  1.00 25.16           C  
ATOM    299  OG1 THR A 122      51.225  72.018  28.962  1.00 30.13           O  
ATOM    300  CG2 THR A 122      53.257  73.336  28.992  1.00 24.02           C  
ATOM    301  N   GLY A 123      50.280  74.004  30.637  1.00 22.82           N  
ATOM    302  CA  GLY A 123      50.105  74.400  32.024  1.00 25.62           C  
ATOM    303  C   GLY A 123      51.393  74.476  32.827  1.00 26.60           C  
ATOM    304  O   GLY A 123      52.144  73.499  32.886  1.00 26.64           O  
ATOM    305  N   CYS A 124      51.627  75.632  33.457  1.00 27.45           N  
ATOM    306  CA  CYS A 124      52.814  75.894  34.283  1.00 29.95           C  
ATOM    307  C   CYS A 124      52.443  76.482  35.654  1.00 30.23           C  
ATOM    308  O   CYS A 124      51.378  77.088  35.819  1.00 29.18           O  
ATOM    309  CB  CYS A 124      53.747  76.913  33.600  1.00 31.56           C  
ATOM    310  SG  CYS A 124      54.412  76.454  31.991  1.00 36.76           S  
ATOM    311  N   GLY A 125      53.341  76.328  36.626  1.00 30.70           N  
ATOM    312  CA  GLY A 125      53.098  76.885  37.945  1.00 33.14           C  
ATOM    313  C   GLY A 125      52.451  75.977  38.974  1.00 34.41           C  
ATOM    314  O   GLY A 125      52.224  74.790  38.726  1.00 33.77           O  
ATOM    315  N   GLU A 126      52.135  76.543  40.139  1.00 35.28           N  
ATOM    316  CA  GLU A 126      51.536  75.743  41.195  1.00 37.68           C  
ATOM    317  C   GLU A 126      50.024  75.876  41.334  1.00 36.43           C  
ATOM    318  O   GLU A 126      49.455  75.397  42.315  1.00 37.46           O  
ATOM    319  CB  GLU A 126      52.223  76.026  42.552  1.00 40.64           C  
ATOM    320  CG  GLU A 126      51.889  77.371  43.203  1.00 44.35           C  
ATOM    321  CD  GLU A 126      52.076  77.343  44.732  1.00 46.95           C  
ATOM    322  OE1 GLU A 126      53.221  77.133  45.198  1.00 48.44           O  
ATOM    323  OE2 GLU A 126      51.073  77.528  45.468  1.00 47.73           O  
ATOM    324  N   SER A 127      49.365  76.512  40.365  1.00 35.42           N  
ATOM    325  CA  SER A 127      47.905  76.656  40.411  1.00 32.39           C  
ATOM    326  C   SER A 127      47.273  75.316  40.049  1.00 30.78           C  
ATOM    327  O   SER A 127      47.983  74.358  39.729  1.00 30.74           O  
ATOM    328  CB  SER A 127      47.427  77.725  39.420  1.00 32.50           C  
ATOM    329  OG  SER A 127      48.075  78.963  39.645  1.00 30.80           O  
ATOM    330  N   THR A 128      45.944  75.247  40.103  1.00 30.23           N  
ATOM    331  CA  THR A 128      45.232  74.012  39.780  1.00 29.89           C  
ATOM    332  C   THR A 128      45.254  73.800  38.272  1.00 29.45           C  
ATOM    333  O   THR A 128      45.466  74.744  37.512  1.00 28.39           O  
ATOM    334  CB  THR A 128      43.754  74.053  40.242  1.00 29.65           C  
ATOM    335  OG1 THR A 128      43.028  75.012  39.466  1.00 29.20           O  
ATOM    336  CG2 THR A 128      43.664  74.434  41.712  1.00 31.59           C  
ATOM    337  N   PRO A 129      45.048  72.555  37.817  1.00 29.51           N  
ATOM    338  CA  PRO A 129      45.054  72.278  36.380  1.00 28.31           C  
ATOM    339  C   PRO A 129      44.170  73.256  35.621  1.00 27.69           C  
ATOM    340  O   PRO A 129      44.569  73.789  34.584  1.00 26.77           O  
ATOM    341  CB  PRO A 129      44.550  70.849  36.313  1.00 28.30           C  
ATOM    342  CG  PRO A 129      45.180  70.247  37.538  1.00 29.24           C  
ATOM    343  CD  PRO A 129      44.920  71.307  38.591  1.00 28.82           C  
ATOM    344  N   ARG A 130      42.984  73.517  36.156  1.00 26.24           N  
ATOM    345  CA  ARG A 130      42.052  74.436  35.520  1.00 26.25           C  
ATOM    346  C   ARG A 130      42.634  75.838  35.387  1.00 26.29           C  
ATOM    347  O   ARG A 130      42.678  76.396  34.292  1.00 25.13           O  
ATOM    348  CB  ARG A 130      40.759  74.510  36.321  1.00 28.01           C  
ATOM    349  CG  ARG A 130      39.742  75.465  35.747  1.00 30.43           C  
ATOM    350  CD  ARG A 130      38.608  75.692  36.731  1.00 31.91           C  
ATOM    351  NE  ARG A 130      37.558  76.512  36.142  1.00 33.76           N  
ATOM    352  CZ  ARG A 130      36.488  76.952  36.802  1.00 36.86           C  
ATOM    353  NH1 ARG A 130      36.322  76.652  38.085  1.00 35.84           N  
ATOM    354  NH2 ARG A 130      35.576  77.689  36.174  1.00 37.09           N  
ATOM    355  N   GLU A 131      43.071  76.409  36.507  1.00 26.39           N  
ATOM    356  CA  GLU A 131      43.641  77.749  36.500  1.00 26.49           C  
ATOM    357  C   GLU A 131      44.928  77.831  35.689  1.00 24.94           C  
ATOM    358  O   GLU A 131      45.274  78.892  35.175  1.00 25.24           O  
ATOM    359  CB  GLU A 131      43.901  78.220  37.930  1.00 29.06           C  
ATOM    360  CG  GLU A 131      42.660  78.735  38.654  1.00 34.55           C  
ATOM    361  CD  GLU A 131      42.058  79.972  37.989  1.00 37.41           C  
ATOM    362  OE1 GLU A 131      42.821  80.759  37.382  1.00 39.91           O  
ATOM    363  OE2 GLU A 131      40.823  80.172  38.086  1.00 38.83           O  
ATOM    364  N   GLN A 132      45.641  76.717  35.584  1.00 23.74           N  
ATOM    365  CA  GLN A 132      46.871  76.700  34.810  1.00 23.62           C  
ATOM    366  C   GLN A 132      46.518  76.863  33.340  1.00 21.60           C  
ATOM    367  O   GLN A 132      47.284  77.430  32.584  1.00 22.30           O  
ATOM    368  CB  GLN A 132      47.618  75.384  35.001  1.00 24.23           C  
ATOM    369  CG  GLN A 132      48.301  75.220  36.337  1.00 28.63           C  
ATOM    370  CD  GLN A 132      49.072  73.923  36.399  1.00 31.06           C  
ATOM    371  OE1 GLN A 132      49.946  73.675  35.570  1.00 32.70           O  
ATOM    372  NE2 GLN A 132      48.750  73.081  37.374  1.00 34.92           N  
ATOM    373  N   ALA A 133      45.359  76.348  32.943  1.00 19.69           N  
ATOM    374  CA  ALA A 133      44.911  76.461  31.557  1.00 20.30           C  
ATOM    375  C   ALA A 133      44.378  77.876  31.301  1.00 20.45           C  
ATOM    376  O   ALA A 133      44.587  78.447  30.233  1.00 20.22           O  
ATOM    377  CB  ALA A 133      43.817  75.423  31.267  1.00 17.96           C  
ATOM    378  N   LEU A 134      43.679  78.432  32.285  1.00 20.83           N  
ATOM    379  CA  LEU A 134      43.140  79.779  32.148  1.00 22.72           C  
ATOM    380  C   LEU A 134      44.282  80.767  31.962  1.00 22.22           C  
ATOM    381  O   LEU A 134      44.238  81.616  31.074  1.00 22.91           O  
ATOM    382  CB  LEU A 134      42.322  80.174  33.387  1.00 23.78           C  
ATOM    383  CG  LEU A 134      40.829  79.832  33.487  1.00 26.28           C  
ATOM    384  CD1 LEU A 134      40.140  80.243  32.196  1.00 26.48           C  
ATOM    385  CD2 LEU A 134      40.622  78.353  33.759  1.00 28.92           C  
ATOM    386  N   GLU A 135      45.307  80.645  32.798  1.00 21.95           N  
ATOM    387  CA  GLU A 135      46.459  81.532  32.735  1.00 23.23           C  
ATOM    388  C   GLU A 135      47.222  81.375  31.414  1.00 22.51           C  
ATOM    389  O   GLU A 135      47.630  82.360  30.799  1.00 22.96           O  
ATOM    390  CB  GLU A 135      47.398  81.255  33.916  1.00 24.73           C  
ATOM    391  CG  GLU A 135      46.710  81.294  35.273  1.00 30.67           C  
ATOM    392  CD  GLU A 135      47.644  80.967  36.434  1.00 34.09           C  
ATOM    393  OE1 GLU A 135      48.497  80.055  36.298  1.00 34.90           O  
ATOM    394  OE2 GLU A 135      47.518  81.616  37.499  1.00 38.22           O  
ATOM    395  N   ALA A 136      47.413  80.135  30.981  1.00 21.43           N  
ATOM    396  CA  ALA A 136      48.137  79.877  29.743  1.00 20.22           C  
ATOM    397  C   ALA A 136      47.406  80.451  28.532  1.00 20.58           C  
ATOM    398  O   ALA A 136      48.018  81.100  27.684  1.00 22.16           O  
ATOM    399  CB  ALA A 136      48.350  78.393  29.570  1.00 19.57           C  
ATOM    400  N   VAL A 137      46.100  80.217  28.443  1.00 20.29           N  
ATOM    401  CA  VAL A 137      45.338  80.747  27.317  1.00 19.48           C  
ATOM    402  C   VAL A 137      45.327  82.278  27.348  1.00 21.09           C  
ATOM    403  O   VAL A 137      45.450  82.920  26.306  1.00 20.96           O  
ATOM    404  CB  VAL A 137      43.889  80.215  27.303  1.00 18.42           C  
ATOM    405  CG1 VAL A 137      43.132  80.809  26.126  1.00 15.87           C  
ATOM    406  CG2 VAL A 137      43.900  78.693  27.200  1.00 18.80           C  
ATOM    407  N   ARG A 138      45.190  82.869  28.533  1.00 20.90           N  
ATOM    408  CA  ARG A 138      45.210  84.329  28.629  1.00 21.83           C  
ATOM    409  C   ARG A 138      46.576  84.878  28.208  1.00 21.57           C  
ATOM    410  O   ARG A 138      46.675  85.982  27.683  1.00 21.63           O  
ATOM    411  CB  ARG A 138      44.857  84.779  30.055  1.00 24.08           C  
ATOM    412  CG  ARG A 138      43.366  84.636  30.377  1.00 27.06           C  
ATOM    413  CD  ARG A 138      42.987  85.181  31.763  1.00 31.18           C  
ATOM    414  NE  ARG A 138      43.579  84.407  32.853  1.00 34.51           N  
ATOM    415  CZ  ARG A 138      42.910  83.953  33.916  1.00 35.99           C  
ATOM    416  NH1 ARG A 138      41.606  84.184  34.056  1.00 35.63           N  
ATOM    417  NH2 ARG A 138      43.552  83.267  34.851  1.00 35.86           N  
ATOM    418  N   PHE A 139      47.621  84.088  28.430  1.00 20.76           N  
ATOM    419  CA  PHE A 139      48.991  84.450  28.070  1.00 21.68           C  
ATOM    420  C   PHE A 139      49.147  84.454  26.542  1.00 21.01           C  
ATOM    421  O   PHE A 139      49.903  85.247  25.988  1.00 21.35           O  
ATOM    422  CB  PHE A 139      49.959  83.436  28.688  1.00 21.77           C  
ATOM    423  CG  PHE A 139      51.412  83.747  28.457  1.00 23.59           C  
ATOM    424  CD1 PHE A 139      51.944  84.974  28.852  1.00 24.03           C  
ATOM    425  CD2 PHE A 139      52.265  82.791  27.884  1.00 23.92           C  
ATOM    426  CE1 PHE A 139      53.311  85.258  28.689  1.00 24.64           C  
ATOM    427  CE2 PHE A 139      53.637  83.056  27.714  1.00 23.89           C  
ATOM    428  CZ  PHE A 139      54.163  84.300  28.118  1.00 23.67           C  
ATOM    429  N   LEU A 140      48.436  83.553  25.870  1.00 20.07           N  
ATOM    430  CA  LEU A 140      48.480  83.474  24.414  1.00 19.29           C  
ATOM    431  C   LEU A 140      47.702  84.653  23.839  1.00 19.54           C  
ATOM    432  O   LEU A 140      48.141  85.310  22.892  1.00 18.12           O  
ATOM    433  CB  LEU A 140      47.850  82.163  23.926  1.00 18.39           C  
ATOM    434  CG  LEU A 140      48.603  80.854  24.200  1.00 17.21           C  
ATOM    435  CD1 LEU A 140      47.741  79.670  23.771  1.00 17.83           C  
ATOM    436  CD2 LEU A 140      49.933  80.849  23.453  1.00 16.74           C  
ATOM    437  N   ILE A 141      46.535  84.911  24.423  1.00 18.97           N  
ATOM    438  CA  ILE A 141      45.673  86.007  23.987  1.00 20.68           C  
ATOM    439  C   ILE A 141      46.386  87.338  24.183  1.00 20.40           C  
ATOM    440  O   ILE A 141      46.254  88.251  23.376  1.00 21.56           O  
ATOM    441  CB  ILE A 141      44.343  86.024  24.787  1.00 20.21           C  
ATOM    442  CG1 ILE A 141      43.506  84.797  24.440  1.00 21.38           C  
ATOM    443  CG2 ILE A 141      43.553  87.288  24.472  1.00 22.23           C  
ATOM    444  CD1 ILE A 141      42.188  84.737  25.168  1.00 18.90           C  
ATOM    445  N   GLY A 142      47.150  87.440  25.266  1.00 22.47           N  
ATOM    446  CA  GLY A 142      47.870  88.670  25.541  1.00 22.60           C  
ATOM    447  C   GLY A 142      48.940  88.976  24.507  1.00 23.28           C  
ATOM    448  O   GLY A 142      49.275  90.136  24.291  1.00 23.88           O  
ATOM    449  N   ARG A 143      49.479  87.942  23.866  1.00 22.90           N  
ATOM    450  CA  ARG A 143      50.515  88.128  22.850  1.00 23.69           C  
ATOM    451  C   ARG A 143      49.916  88.530  21.504  1.00 23.65           C  
ATOM    452  O   ARG A 143      50.637  88.785  20.541  1.00 23.93           O  
ATOM    453  CB  ARG A 143      51.329  86.843  22.667  1.00 23.04           C  
ATOM    454  CG  ARG A 143      52.568  87.021  21.779  1.00 24.76           C  
ATOM    455  CD  ARG A 143      53.487  88.098  22.342  1.00 26.64           C  
ATOM    456  NE  ARG A 143      54.554  88.513  21.430  1.00 29.53           N  
ATOM    457  CZ  ARG A 143      54.370  89.271  20.355  1.00 29.30           C  
ATOM    458  NH1 ARG A 143      53.162  89.696  20.039  1.00 30.35           N  
ATOM    459  NH2 ARG A 143      55.401  89.635  19.615  1.00 30.44           N  
ATOM    460  N   ASP A 144      48.590  88.589  21.451  1.00 24.68           N  
ATOM    461  CA  ASP A 144      47.863  88.937  20.235  1.00 25.92           C  
ATOM    462  C   ASP A 144      48.035  87.942  19.099  1.00 26.92           C  
ATOM    463  O   ASP A 144      48.293  88.325  17.949  1.00 25.52           O  
ATOM    464  CB  ASP A 144      48.241  90.332  19.748  1.00 29.28           C  
ATOM    465  CG  ASP A 144      47.559  91.420  20.543  1.00 32.42           C  
ATOM    466  OD1 ASP A 144      46.318  91.350  20.682  1.00 34.65           O  
ATOM    467  OD2 ASP A 144      48.261  92.339  21.022  1.00 33.64           O  
ATOM    468  N   CYS A 145      47.900  86.660  19.423  1.00 24.48           N  
ATOM    469  CA  CYS A 145      47.988  85.629  18.396  1.00 23.45           C  
ATOM    470  C   CYS A 145      46.786  85.916  17.498  1.00 22.91           C  
ATOM    471  O   CYS A 145      45.755  86.376  17.989  1.00 22.59           O  
ATOM    472  CB  CYS A 145      47.859  84.246  19.030  1.00 22.93           C  
ATOM    473  SG  CYS A 145      49.242  83.781  20.096  1.00 27.60           S  
ATOM    474  N   ASP A 146      46.905  85.673  16.196  1.00 21.99           N  
ATOM    475  CA  ASP A 146      45.785  85.938  15.296  1.00 21.85           C  
ATOM    476  C   ASP A 146      44.594  85.040  15.629  1.00 21.31           C  
ATOM    477  O   ASP A 146      43.439  85.430  15.470  1.00 21.16           O  
ATOM    478  CB  ASP A 146      46.203  85.730  13.841  1.00 22.38           C  
ATOM    479  CG  ASP A 146      47.320  86.664  13.423  1.00 24.27           C  
ATOM    480  OD1 ASP A 146      47.235  87.867  13.751  1.00 27.48           O  
ATOM    481  OD2 ASP A 146      48.271  86.199  12.764  1.00 24.03           O  
ATOM    482  N   GLY A 147      44.894  83.833  16.086  1.00 20.17           N  
ATOM    483  CA  GLY A 147      43.858  82.885  16.453  1.00 18.01           C  
ATOM    484  C   GLY A 147      44.406  81.986  17.542  1.00 18.16           C  
ATOM    485  O   GLY A 147      45.622  81.889  17.706  1.00 17.25           O  
ATOM    486  N   VAL A 148      43.530  81.331  18.291  1.00 15.83           N  
ATOM    487  CA  VAL A 148      43.993  80.451  19.349  1.00 16.75           C  
ATOM    488  C   VAL A 148      43.299  79.094  19.307  1.00 16.84           C  
ATOM    489  O   VAL A 148      42.066  79.016  19.245  1.00 16.99           O  
ATOM    490  CB  VAL A 148      43.762  81.083  20.735  1.00 17.38           C  
ATOM    491  CG1 VAL A 148      44.301  80.157  21.815  1.00 19.88           C  
ATOM    492  CG2 VAL A 148      44.434  82.439  20.806  1.00 16.74           C  
ATOM    493  N   VAL A 149      44.103  78.032  19.316  1.00 14.63           N  
ATOM    494  CA  VAL A 149      43.588  76.669  19.309  1.00 14.56           C  
ATOM    495  C   VAL A 149      43.664  76.176  20.748  1.00 15.31           C  
ATOM    496  O   VAL A 149      44.712  76.255  21.391  1.00 17.58           O  
ATOM    497  CB  VAL A 149      44.433  75.737  18.414  1.00 14.36           C  
ATOM    498  CG1 VAL A 149      43.862  74.334  18.456  1.00 12.73           C  
ATOM    499  CG2 VAL A 149      44.451  76.260  16.977  1.00 13.51           C  
ATOM    500  N   VAL A 150      42.562  75.651  21.256  1.00 15.29           N  
ATOM    501  CA  VAL A 150      42.549  75.211  22.636  1.00 17.52           C  
ATOM    502  C   VAL A 150      41.969  73.837  22.895  1.00 15.98           C  
ATOM    503  O   VAL A 150      40.900  73.506  22.397  1.00 16.60           O  
ATOM    504  CB  VAL A 150      41.774  76.231  23.513  1.00 16.50           C  
ATOM    505  CG1 VAL A 150      41.688  75.744  24.941  1.00 18.39           C  
ATOM    506  CG2 VAL A 150      42.449  77.583  23.444  1.00 17.20           C  
ATOM    507  N   ILE A 151      42.701  73.032  23.661  1.00 18.66           N  
ATOM    508  CA  ILE A 151      42.224  71.714  24.059  1.00 19.51           C  
ATOM    509  C   ILE A 151      42.554  71.537  25.531  1.00 20.92           C  
ATOM    510  O   ILE A 151      43.701  71.681  25.945  1.00 20.49           O  
ATOM    511  CB  ILE A 151      42.857  70.551  23.252  1.00 19.66           C  
ATOM    512  CG1 ILE A 151      42.324  69.213  23.780  1.00 21.48           C  
ATOM    513  CG2 ILE A 151      44.359  70.580  23.347  1.00 18.44           C  
ATOM    514  CD1 ILE A 151      42.740  68.008  22.947  1.00 22.28           C  
ATOM    515  N   SER A 152      41.529  71.247  26.322  1.00 22.12           N  
ATOM    516  CA  SER A 152      41.696  71.052  27.752  1.00 23.61           C  
ATOM    517  C   SER A 152      40.419  70.479  28.322  1.00 23.44           C  
ATOM    518  O   SER A 152      39.326  70.925  27.983  1.00 23.78           O  
ATOM    519  CB  SER A 152      42.006  72.385  28.439  1.00 24.94           C  
ATOM    520  OG  SER A 152      41.873  72.289  29.852  1.00 26.65           O  
ATOM    521  N   HIS A 153      40.556  69.476  29.179  1.00 25.98           N  
ATOM    522  CA  HIS A 153      39.392  68.879  29.805  1.00 26.56           C  
ATOM    523  C   HIS A 153      39.295  69.363  31.246  1.00 25.60           C  
ATOM    524  O   HIS A 153      38.447  68.896  32.006  1.00 25.63           O  
ATOM    525  CB  HIS A 153      39.487  67.353  29.756  1.00 29.28           C  
ATOM    526  CG  HIS A 153      40.652  66.798  30.516  1.00 31.77           C  
ATOM    527  ND1 HIS A 153      40.774  66.933  31.884  1.00 32.99           N  
ATOM    528  CD2 HIS A 153      41.737  66.108  30.104  1.00 32.57           C  
ATOM    529  CE1 HIS A 153      41.889  66.342  32.279  1.00 33.00           C  
ATOM    530  NE2 HIS A 153      42.492  65.834  31.221  1.00 33.56           N  
ATOM    531  N   ASP A 154      40.175  70.293  31.614  1.00 24.48           N  
ATOM    532  CA  ASP A 154      40.197  70.865  32.964  1.00 25.23           C  
ATOM    533  C   ASP A 154      39.378  72.154  33.002  1.00 25.59           C  
ATOM    534  O   ASP A 154      38.905  72.574  34.057  1.00 25.31           O  
ATOM    535  CB  ASP A 154      41.632  71.188  33.396  1.00 27.00           C  
ATOM    536  CG  ASP A 154      42.473  69.948  33.615  1.00 29.97           C  
ATOM    537  OD1 ASP A 154      42.204  69.213  34.583  1.00 31.50           O  
ATOM    538  OD2 ASP A 154      43.407  69.707  32.823  1.00 29.55           O  
ATOM    539  N   LEU A 155      39.234  72.797  31.847  1.00 24.65           N  
ATOM    540  CA  LEU A 155      38.461  74.028  31.776  1.00 24.45           C  
ATOM    541  C   LEU A 155      36.984  73.693  31.937  1.00 25.72           C  
ATOM    542  O   LEU A 155      36.542  72.608  31.569  1.00 26.36           O  
ATOM    543  CB  LEU A 155      38.669  74.724  30.429  1.00 23.71           C  
ATOM    544  CG  LEU A 155      40.053  75.269  30.065  1.00 23.32           C  
ATOM    545  CD1 LEU A 155      40.005  75.764  28.633  1.00 23.00           C  
ATOM    546  CD2 LEU A 155      40.447  76.418  31.005  1.00 22.19           C  
ATOM    547  N   HIS A 156      36.225  74.621  32.497  1.00 27.21           N  
ATOM    548  CA  HIS A 156      34.793  74.413  32.664  1.00 29.71           C  
ATOM    549  C   HIS A 156      34.115  75.133  31.521  1.00 28.45           C  
ATOM    550  O   HIS A 156      34.674  76.082  30.977  1.00 27.99           O  
ATOM    551  CB  HIS A 156      34.322  74.980  34.000  1.00 32.92           C  
ATOM    552  CG  HIS A 156      34.711  74.139  35.171  1.00 37.28           C  
ATOM    553  ND1 HIS A 156      35.797  73.291  35.143  1.00 38.84           N  
ATOM    554  CD2 HIS A 156      34.192  74.047  36.417  1.00 38.68           C  
ATOM    555  CE1 HIS A 156      35.933  72.714  36.324  1.00 40.21           C  
ATOM    556  NE2 HIS A 156      34.971  73.157  37.115  1.00 40.48           N  
ATOM    557  N   ASP A 157      32.914  74.700  31.160  1.00 27.85           N  
ATOM    558  CA  ASP A 157      32.217  75.334  30.049  1.00 28.38           C  
ATOM    559  C   ASP A 157      32.215  76.859  30.158  1.00 28.20           C  
ATOM    560  O   ASP A 157      32.428  77.550  29.166  1.00 26.21           O  
ATOM    561  CB  ASP A 157      30.780  74.798  29.943  1.00 30.23           C  
ATOM    562  CG  ASP A 157      30.722  73.340  29.483  1.00 31.70           C  
ATOM    563  OD1 ASP A 157      31.785  72.694  29.363  1.00 33.19           O  
ATOM    564  OD2 ASP A 157      29.607  72.825  29.241  1.00 33.04           O  
ATOM    565  N   GLU A 158      31.994  77.383  31.360  1.00 27.97           N  
ATOM    566  CA  GLU A 158      31.956  78.831  31.558  1.00 29.78           C  
ATOM    567  C   GLU A 158      33.285  79.495  31.176  1.00 30.19           C  
ATOM    568  O   GLU A 158      33.315  80.668  30.779  1.00 29.58           O  
ATOM    569  CB  GLU A 158      31.581  79.163  33.020  1.00 31.95           C  
ATOM    570  CG  GLU A 158      32.739  79.170  34.015  1.00 36.72           C  
ATOM    571  CD  GLU A 158      32.291  79.228  35.483  1.00 39.49           C  
ATOM    572  OE1 GLU A 158      31.192  79.770  35.777  1.00 40.72           O  
ATOM    573  OE2 GLU A 158      33.052  78.736  36.348  1.00 40.12           O  
ATOM    574  N   ASP A 159      34.381  78.744  31.289  1.00 29.13           N  
ATOM    575  CA  ASP A 159      35.692  79.269  30.936  1.00 29.19           C  
ATOM    576  C   ASP A 159      35.784  79.440  29.426  1.00 28.01           C  
ATOM    577  O   ASP A 159      36.331  80.428  28.942  1.00 27.13           O  
ATOM    578  CB  ASP A 159      36.806  78.336  31.429  1.00 29.37           C  
ATOM    579  CG  ASP A 159      36.788  78.165  32.931  1.00 30.34           C  
ATOM    580  OD1 ASP A 159      36.415  79.143  33.615  1.00 30.80           O  
ATOM    581  OD2 ASP A 159      37.147  77.073  33.425  1.00 27.23           O  
ATOM    582  N   LEU A 160      35.243  78.478  28.682  1.00 27.89           N  
ATOM    583  CA  LEU A 160      35.264  78.561  27.225  1.00 28.68           C  
ATOM    584  C   LEU A 160      34.584  79.854  26.745  1.00 29.11           C  
ATOM    585  O   LEU A 160      35.076  80.515  25.829  1.00 27.36           O  
ATOM    586  CB  LEU A 160      34.571  77.333  26.623  1.00 29.02           C  
ATOM    587  CG  LEU A 160      35.339  76.008  26.482  1.00 30.36           C  
ATOM    588  CD1 LEU A 160      36.245  75.742  27.659  1.00 30.08           C  
ATOM    589  CD2 LEU A 160      34.318  74.889  26.328  1.00 32.02           C  
ATOM    590  N   ASP A 161      33.466  80.216  27.378  1.00 29.60           N  
ATOM    591  CA  ASP A 161      32.719  81.430  27.022  1.00 30.81           C  
ATOM    592  C   ASP A 161      33.481  82.717  27.329  1.00 30.31           C  
ATOM    593  O   ASP A 161      33.424  83.688  26.568  1.00 29.85           O  
ATOM    594  CB  ASP A 161      31.376  81.455  27.759  1.00 32.77           C  
ATOM    595  CG  ASP A 161      30.459  80.336  27.323  1.00 34.96           C  
ATOM    596  OD1 ASP A 161      30.193  80.232  26.108  1.00 37.80           O  
ATOM    597  OD2 ASP A 161      30.004  79.561  28.189  1.00 37.37           O  
ATOM    598  N   GLU A 162      34.199  82.716  28.446  1.00 29.82           N  
ATOM    599  CA  GLU A 162      34.981  83.876  28.871  1.00 30.54           C  
ATOM    600  C   GLU A 162      36.169  84.097  27.936  1.00 29.48           C  
ATOM    601  O   GLU A 162      36.391  85.206  27.441  1.00 30.02           O  
ATOM    602  CB  GLU A 162      35.480  83.653  30.296  1.00 31.78           C  
ATOM    603  CG  GLU A 162      36.258  84.803  30.848  1.00 36.30           C  
ATOM    604  CD  GLU A 162      36.651  84.568  32.281  1.00 41.74           C  
ATOM    605  OE1 GLU A 162      37.680  83.886  32.522  1.00 42.72           O  
ATOM    606  OE2 GLU A 162      35.909  85.057  33.170  1.00 44.15           O  
ATOM    607  N   LEU A 163      36.927  83.030  27.701  1.00 27.51           N  
ATOM    608  CA  LEU A 163      38.089  83.078  26.825  1.00 26.09           C  
ATOM    609  C   LEU A 163      37.654  83.481  25.423  1.00 25.93           C  
ATOM    610  O   LEU A 163      38.370  84.192  24.728  1.00 25.48           O  
ATOM    611  CB  LEU A 163      38.772  81.702  26.786  1.00 25.26           C  
ATOM    612  CG  LEU A 163      39.390  81.208  28.100  1.00 24.49           C  
ATOM    613  CD1 LEU A 163      39.807  79.739  27.987  1.00 24.73           C  
ATOM    614  CD2 LEU A 163      40.584  82.084  28.439  1.00 26.02           C  
ATOM    615  N   HIS A 164      36.471  83.036  25.011  1.00 26.00           N  
ATOM    616  CA  HIS A 164      35.981  83.357  23.680  1.00 27.75           C  
ATOM    617  C   HIS A 164      35.620  84.831  23.517  1.00 28.53           C  
ATOM    618  O   HIS A 164      35.828  85.400  22.443  1.00 27.40           O  
ATOM    619  CB  HIS A 164      34.774  82.500  23.321  1.00 28.97           C  
ATOM    620  CG  HIS A 164      34.466  82.498  21.860  1.00 31.63           C  
ATOM    621  ND1 HIS A 164      35.295  81.914  20.927  1.00 33.56           N  
ATOM    622  CD2 HIS A 164      33.426  83.019  21.164  1.00 31.62           C  
ATOM    623  CE1 HIS A 164      34.780  82.070  19.721  1.00 32.95           C  
ATOM    624  NE2 HIS A 164      33.646  82.737  19.839  1.00 32.97           N  
ATOM    625  N   ARG A 165      35.079  85.461  24.559  1.00 29.18           N  
ATOM    626  CA  ARG A 165      34.750  86.881  24.427  1.00 29.98           C  
ATOM    627  C   ARG A 165      36.015  87.736  24.492  1.00 29.22           C  
ATOM    628  O   ARG A 165      36.026  88.886  24.038  1.00 30.00           O  
ATOM    629  CB  ARG A 165      33.754  87.322  25.497  1.00 32.64           C  
ATOM    630  CG  ARG A 165      34.159  87.009  26.911  1.00 36.43           C  
ATOM    631  CD  ARG A 165      33.427  87.942  27.868  1.00 41.97           C  
ATOM    632  NE  ARG A 165      34.146  89.206  28.016  1.00 43.26           N  
ATOM    633  CZ  ARG A 165      35.370  89.294  28.538  1.00 45.98           C  
ATOM    634  NH1 ARG A 165      35.999  88.191  28.955  1.00 45.84           N  
ATOM    635  NH2 ARG A 165      35.967  90.477  28.647  1.00 45.30           N  
HETATM  636  N   MSE A 166      37.082  87.173  25.055  1.00 27.55           N  
HETATM  637  CA  MSE A 166      38.363  87.875  25.133  1.00 27.42           C  
HETATM  638  C   MSE A 166      39.046  87.806  23.766  1.00 26.74           C  
HETATM  639  O   MSE A 166      39.830  88.678  23.400  1.00 27.15           O  
HETATM  640  CB  MSE A 166      39.286  87.219  26.164  1.00 27.52           C  
HETATM  641  CG  MSE A 166      39.070  87.658  27.597  1.00 29.04           C  
HETATM  642 SE   MSE A 166      40.096  86.738  28.778  1.00 30.28          SE  
HETATM  643  CE  MSE A 166      41.693  87.570  28.599  1.00 30.54           C  
ATOM    644  N   HIS A 167      38.748  86.752  23.018  1.00 27.03           N  
ATOM    645  CA  HIS A 167      39.353  86.557  21.706  1.00 27.69           C  
ATOM    646  C   HIS A 167      38.396  85.715  20.872  1.00 26.82           C  
ATOM    647  O   HIS A 167      38.398  84.486  20.963  1.00 27.38           O  
ATOM    648  CB  HIS A 167      40.698  85.839  21.887  1.00 27.48           C  
ATOM    649  CG  HIS A 167      41.570  85.872  20.672  1.00 28.25           C  
ATOM    650  ND1 HIS A 167      41.310  85.117  19.547  1.00 29.28           N  
ATOM    651  CD2 HIS A 167      42.685  86.583  20.398  1.00 28.56           C  
ATOM    652  CE1 HIS A 167      42.230  85.363  18.633  1.00 29.77           C  
ATOM    653  NE2 HIS A 167      43.077  86.250  19.124  1.00 29.29           N  
ATOM    654  N   PRO A 168      37.562  86.363  20.045  1.00 26.01           N  
ATOM    655  CA  PRO A 168      36.599  85.636  19.210  1.00 26.96           C  
ATOM    656  C   PRO A 168      37.164  84.628  18.198  1.00 26.22           C  
ATOM    657  O   PRO A 168      36.444  83.736  17.761  1.00 28.20           O  
ATOM    658  CB  PRO A 168      35.810  86.760  18.533  1.00 28.31           C  
ATOM    659  CG  PRO A 168      35.872  87.875  19.546  1.00 27.32           C  
ATOM    660  CD  PRO A 168      37.330  87.814  19.958  1.00 27.36           C  
ATOM    661  N   LYS A 169      38.432  84.753  17.819  1.00 24.73           N  
ATOM    662  CA  LYS A 169      39.011  83.814  16.860  1.00 23.29           C  
ATOM    663  C   LYS A 169      39.727  82.664  17.561  1.00 22.18           C  
ATOM    664  O   LYS A 169      40.952  82.632  17.653  1.00 20.09           O  
ATOM    665  CB  LYS A 169      39.952  84.549  15.905  1.00 24.96           C  
ATOM    666  CG  LYS A 169      39.192  85.398  14.904  1.00 26.42           C  
ATOM    667  CD  LYS A 169      40.099  86.080  13.892  1.00 28.89           C  
ATOM    668  CE  LYS A 169      39.260  86.928  12.929  1.00 30.05           C  
ATOM    669  NZ  LYS A 169      40.068  87.681  11.899  1.00 31.17           N  
HETATM  670  N   MSE A 170      38.919  81.726  18.051  1.00 21.99           N  
HETATM  671  CA  MSE A 170      39.371  80.548  18.784  1.00 21.48           C  
HETATM  672  C   MSE A 170      38.665  79.308  18.268  1.00 19.02           C  
HETATM  673  O   MSE A 170      37.561  79.389  17.742  1.00 18.82           O  
HETATM  674  CB  MSE A 170      39.003  80.653  20.265  1.00 21.06           C  
HETATM  675  CG  MSE A 170      39.858  81.562  21.123  1.00 28.71           C  
HETATM  676 SE   MSE A 170      39.278  81.460  22.850  1.00 26.95          SE  
HETATM  677  CE  MSE A 170      39.995  80.058  23.395  1.00 27.29           C  
ATOM    678  N   VAL A 171      39.300  78.158  18.449  1.00 17.09           N  
ATOM    679  CA  VAL A 171      38.696  76.893  18.073  1.00 16.49           C  
ATOM    680  C   VAL A 171      38.956  75.939  19.245  1.00 18.69           C  
ATOM    681  O   VAL A 171      40.030  75.969  19.859  1.00 17.83           O  
ATOM    682  CB  VAL A 171      39.280  76.331  16.745  1.00 16.11           C  
ATOM    683  CG1 VAL A 171      40.741  75.950  16.910  1.00 13.95           C  
ATOM    684  CG2 VAL A 171      38.459  75.130  16.292  1.00 15.70           C  
ATOM    685  N   PHE A 172      37.965  75.111  19.563  1.00 18.39           N  
ATOM    686  CA  PHE A 172      38.060  74.173  20.673  1.00 19.72           C  
ATOM    687  C   PHE A 172      38.057  72.725  20.196  1.00 20.42           C  
ATOM    688  O   PHE A 172      37.180  72.319  19.445  1.00 20.79           O  
ATOM    689  CB  PHE A 172      36.884  74.391  21.621  1.00 20.69           C  
ATOM    690  CG  PHE A 172      36.805  75.779  22.163  1.00 22.86           C  
ATOM    691  CD1 PHE A 172      37.782  76.253  23.040  1.00 24.50           C  
ATOM    692  CD2 PHE A 172      35.772  76.629  21.779  1.00 24.78           C  
ATOM    693  CE1 PHE A 172      37.735  77.560  23.533  1.00 25.59           C  
ATOM    694  CE2 PHE A 172      35.708  77.940  22.259  1.00 26.62           C  
ATOM    695  CZ  PHE A 172      36.696  78.408  23.141  1.00 25.97           C  
ATOM    696  N   LEU A 173      39.034  71.946  20.647  1.00 20.87           N  
ATOM    697  CA  LEU A 173      39.129  70.545  20.258  1.00 20.88           C  
ATOM    698  C   LEU A 173      38.654  69.627  21.390  1.00 22.06           C  
ATOM    699  O   LEU A 173      38.792  69.953  22.570  1.00 20.40           O  
ATOM    700  CB  LEU A 173      40.577  70.186  19.920  1.00 20.59           C  
ATOM    701  CG  LEU A 173      41.447  71.250  19.248  1.00 22.16           C  
ATOM    702  CD1 LEU A 173      42.889  70.752  19.170  1.00 22.63           C  
ATOM    703  CD2 LEU A 173      40.900  71.574  17.880  1.00 20.09           C  
ATOM    704  N   ASN A 174      38.093  68.484  21.011  1.00 22.80           N  
ATOM    705  CA  ASN A 174      37.624  67.463  21.950  1.00 25.22           C  
ATOM    706  C   ASN A 174      36.558  67.833  22.987  1.00 26.24           C  
ATOM    707  O   ASN A 174      36.391  67.119  23.980  1.00 26.65           O  
ATOM    708  CB  ASN A 174      38.826  66.842  22.667  1.00 25.90           C  
ATOM    709  CG  ASN A 174      38.614  65.373  22.995  1.00 27.75           C  
ATOM    710  OD1 ASN A 174      38.104  64.606  22.173  1.00 24.89           O  
ATOM    711  ND2 ASN A 174      39.030  64.968  24.195  1.00 28.66           N  
ATOM    712  N   ARG A 175      35.860  68.946  22.783  1.00 27.07           N  
ATOM    713  CA  ARG A 175      34.767  69.340  23.677  1.00 27.73           C  
ATOM    714  C   ARG A 175      33.841  70.298  22.951  1.00 27.75           C  
ATOM    715  O   ARG A 175      34.255  70.998  22.030  1.00 26.52           O  
ATOM    716  CB  ARG A 175      35.268  69.961  24.988  1.00 27.17           C  
ATOM    717  CG  ARG A 175      36.004  71.263  24.884  1.00 26.08           C  
ATOM    718  CD  ARG A 175      36.547  71.607  26.261  1.00 26.20           C  
ATOM    719  NE  ARG A 175      35.479  71.837  27.227  1.00 25.07           N  
ATOM    720  CZ  ARG A 175      35.645  71.829  28.545  1.00 26.50           C  
ATOM    721  NH1 ARG A 175      36.840  71.591  29.066  1.00 23.59           N  
ATOM    722  NH2 ARG A 175      34.613  72.087  29.345  1.00 26.35           N  
ATOM    723  N   ALA A 176      32.581  70.315  23.365  1.00 27.84           N  
ATOM    724  CA  ALA A 176      31.573  71.155  22.728  1.00 28.76           C  
ATOM    725  C   ALA A 176      31.633  72.630  23.112  1.00 27.41           C  
ATOM    726  O   ALA A 176      32.235  73.003  24.123  1.00 26.74           O  
ATOM    727  CB  ALA A 176      30.175  70.591  23.032  1.00 28.76           C  
ATOM    728  N   PHE A 177      31.006  73.463  22.286  1.00 26.93           N  
ATOM    729  CA  PHE A 177      30.945  74.898  22.522  1.00 27.25           C  
ATOM    730  C   PHE A 177      29.585  75.393  22.012  1.00 28.84           C  
ATOM    731  O   PHE A 177      29.467  75.972  20.921  1.00 27.70           O  
ATOM    732  CB  PHE A 177      32.091  75.607  21.802  1.00 24.36           C  
ATOM    733  CG  PHE A 177      32.227  77.047  22.177  1.00 24.61           C  
ATOM    734  CD1 PHE A 177      32.400  77.416  23.513  1.00 23.95           C  
ATOM    735  CD2 PHE A 177      32.138  78.045  21.208  1.00 24.49           C  
ATOM    736  CE1 PHE A 177      32.485  78.763  23.879  1.00 23.98           C  
ATOM    737  CE2 PHE A 177      32.222  79.400  21.558  1.00 24.53           C  
ATOM    738  CZ  PHE A 177      32.393  79.760  22.892  1.00 24.34           C  
ATOM    739  N   ASP A 178      28.559  75.147  22.821  1.00 30.47           N  
ATOM    740  CA  ASP A 178      27.186  75.504  22.482  1.00 32.38           C  
ATOM    741  C   ASP A 178      26.942  76.923  21.983  1.00 31.95           C  
ATOM    742  O   ASP A 178      26.163  77.121  21.055  1.00 32.93           O  
ATOM    743  CB  ASP A 178      26.264  75.223  23.669  1.00 34.56           C  
ATOM    744  CG  ASP A 178      26.306  73.775  24.104  1.00 37.53           C  
ATOM    745  OD1 ASP A 178      26.455  72.895  23.219  1.00 37.80           O  
ATOM    746  OD2 ASP A 178      26.179  73.516  25.324  1.00 38.38           O  
ATOM    747  N   ALA A 179      27.593  77.914  22.581  1.00 32.78           N  
ATOM    748  CA  ALA A 179      27.384  79.286  22.132  1.00 32.75           C  
ATOM    749  C   ALA A 179      27.757  79.483  20.657  1.00 33.14           C  
ATOM    750  O   ALA A 179      27.190  80.347  19.972  1.00 33.69           O  
ATOM    751  CB  ALA A 179      28.168  80.248  23.005  1.00 32.88           C  
ATOM    752  N   LEU A 180      28.703  78.679  20.169  1.00 33.15           N  
ATOM    753  CA  LEU A 180      29.151  78.770  18.777  1.00 31.53           C  
ATOM    754  C   LEU A 180      29.653  77.402  18.336  1.00 30.79           C  
ATOM    755  O   LEU A 180      30.857  77.173  18.239  1.00 30.12           O  
ATOM    756  CB  LEU A 180      30.284  79.789  18.654  1.00 32.79           C  
ATOM    757  CG  LEU A 180      30.450  80.382  17.258  1.00 32.68           C  
ATOM    758  CD1 LEU A 180      29.332  81.397  17.045  1.00 34.19           C  
ATOM    759  CD2 LEU A 180      31.796  81.057  17.113  1.00 33.52           C  
ATOM    760  N   PRO A 181      28.729  76.476  18.059  1.00 29.83           N  
ATOM    761  CA  PRO A 181      29.003  75.101  17.630  1.00 28.80           C  
ATOM    762  C   PRO A 181      30.127  74.835  16.633  1.00 28.49           C  
ATOM    763  O   PRO A 181      30.961  73.961  16.874  1.00 26.91           O  
ATOM    764  CB  PRO A 181      27.650  74.628  17.118  1.00 30.71           C  
ATOM    765  CG  PRO A 181      26.704  75.336  18.065  1.00 31.97           C  
ATOM    766  CD  PRO A 181      27.277  76.726  18.121  1.00 29.84           C  
ATOM    767  N   ASP A 182      30.193  75.545  15.513  1.00 27.24           N  
ATOM    768  CA  ASP A 182      31.272  75.186  14.609  1.00 27.85           C  
ATOM    769  C   ASP A 182      32.670  75.585  15.065  1.00 25.40           C  
ATOM    770  O   ASP A 182      33.633  75.380  14.341  1.00 23.28           O  
ATOM    771  CB  ASP A 182      31.007  75.652  13.173  1.00 32.03           C  
ATOM    772  CG  ASP A 182      30.594  77.072  13.091  1.00 36.29           C  
ATOM    773  OD1 ASP A 182      31.235  77.894  13.780  1.00 40.97           O  
ATOM    774  OD2 ASP A 182      29.644  77.370  12.327  1.00 38.75           O  
ATOM    775  N   ALA A 183      32.780  76.123  16.277  1.00 22.97           N  
ATOM    776  CA  ALA A 183      34.082  76.476  16.840  1.00 22.85           C  
ATOM    777  C   ALA A 183      34.543  75.245  17.631  1.00 22.26           C  
ATOM    778  O   ALA A 183      35.607  75.241  18.254  1.00 22.18           O  
ATOM    779  CB  ALA A 183      33.956  77.675  17.770  1.00 22.34           C  
ATOM    780  N   SER A 184      33.715  74.204  17.591  1.00 20.95           N  
ATOM    781  CA  SER A 184      33.982  72.952  18.289  1.00 22.28           C  
ATOM    782  C   SER A 184      34.162  71.777  17.325  1.00 21.68           C  
ATOM    783  O   SER A 184      33.325  71.535  16.451  1.00 19.01           O  
ATOM    784  CB  SER A 184      32.836  72.634  19.257  1.00 22.59           C  
ATOM    785  OG  SER A 184      32.971  71.320  19.776  1.00 25.55           O  
ATOM    786  N   PHE A 185      35.272  71.066  17.493  1.00 21.38           N  
ATOM    787  CA  PHE A 185      35.591  69.902  16.676  1.00 20.66           C  
ATOM    788  C   PHE A 185      35.796  68.746  17.641  1.00 21.96           C  
ATOM    789  O   PHE A 185      36.794  68.684  18.360  1.00 22.49           O  
ATOM    790  CB  PHE A 185      36.837  70.182  15.847  1.00 17.60           C  
ATOM    791  CG  PHE A 185      36.569  71.084  14.677  1.00 18.92           C  
ATOM    792  CD1 PHE A 185      36.366  70.546  13.399  1.00 16.86           C  
ATOM    793  CD2 PHE A 185      36.453  72.471  14.857  1.00 17.79           C  
ATOM    794  CE1 PHE A 185      36.044  71.372  12.315  1.00 18.04           C  
ATOM    795  CE2 PHE A 185      36.129  73.311  13.784  1.00 19.00           C  
ATOM    796  CZ  PHE A 185      35.926  72.763  12.506  1.00 17.19           C  
ATOM    797  N   CYS A 186      34.834  67.833  17.658  1.00 22.29           N  
ATOM    798  CA  CYS A 186      34.872  66.718  18.593  1.00 24.06           C  
ATOM    799  C   CYS A 186      34.429  65.406  17.966  1.00 23.85           C  
ATOM    800  O   CYS A 186      33.441  65.359  17.248  1.00 25.33           O  
ATOM    801  CB  CYS A 186      33.958  67.055  19.783  1.00 24.41           C  
ATOM    802  SG  CYS A 186      34.225  66.106  21.307  1.00 29.08           S  
ATOM    803  N   PRO A 187      35.156  64.316  18.236  1.00 22.73           N  
ATOM    804  CA  PRO A 187      34.739  63.041  17.653  1.00 21.86           C  
ATOM    805  C   PRO A 187      33.533  62.499  18.429  1.00 21.93           C  
ATOM    806  O   PRO A 187      33.079  63.111  19.399  1.00 19.61           O  
ATOM    807  CB  PRO A 187      35.978  62.172  17.824  1.00 21.19           C  
ATOM    808  CG  PRO A 187      36.512  62.637  19.141  1.00 21.67           C  
ATOM    809  CD  PRO A 187      36.381  64.153  19.040  1.00 22.54           C  
ATOM    810  N   ASP A 188      33.017  61.354  18.002  1.00 21.03           N  
ATOM    811  CA  ASP A 188      31.871  60.747  18.661  1.00 21.76           C  
ATOM    812  C   ASP A 188      32.342  59.810  19.779  1.00 20.41           C  
ATOM    813  O   ASP A 188      32.474  58.610  19.566  1.00 20.38           O  
ATOM    814  CB  ASP A 188      31.043  59.972  17.632  1.00 22.95           C  
ATOM    815  CG  ASP A 188      29.746  59.443  18.206  1.00 24.78           C  
ATOM    816  OD1 ASP A 188      28.902  58.955  17.422  1.00 28.50           O  
ATOM    817  OD2 ASP A 188      29.568  59.511  19.439  1.00 24.23           O  
ATOM    818  N   HIS A 189      32.590  60.363  20.964  1.00 19.72           N  
ATOM    819  CA  HIS A 189      33.065  59.573  22.103  1.00 20.02           C  
ATOM    820  C   HIS A 189      32.042  58.558  22.608  1.00 21.13           C  
ATOM    821  O   HIS A 189      32.411  57.506  23.130  1.00 20.31           O  
ATOM    822  CB  HIS A 189      33.483  60.493  23.254  1.00 17.17           C  
ATOM    823  CG  HIS A 189      34.740  61.261  22.988  1.00 18.27           C  
ATOM    824  ND1 HIS A 189      35.939  60.647  22.693  1.00 18.67           N  
ATOM    825  CD2 HIS A 189      34.985  62.594  22.961  1.00 17.57           C  
ATOM    826  CE1 HIS A 189      36.866  61.568  22.494  1.00 17.87           C  
ATOM    827  NE2 HIS A 189      36.313  62.757  22.651  1.00 17.50           N  
ATOM    828  N   ARG A 190      30.759  58.875  22.457  1.00 20.50           N  
ATOM    829  CA  ARG A 190      29.698  57.972  22.898  1.00 22.49           C  
ATOM    830  C   ARG A 190      29.880  56.680  22.113  1.00 20.57           C  
ATOM    831  O   ARG A 190      29.943  55.591  22.678  1.00 20.24           O  
ATOM    832  CB  ARG A 190      28.332  58.588  22.593  1.00 25.89           C  
ATOM    833  CG  ARG A 190      27.147  57.903  23.245  1.00 31.55           C  
ATOM    834  CD  ARG A 190      25.864  58.602  22.815  1.00 38.27           C  
ATOM    835  NE  ARG A 190      24.883  58.688  23.893  1.00 44.67           N  
ATOM    836  CZ  ARG A 190      23.648  59.175  23.747  1.00 48.31           C  
ATOM    837  NH1 ARG A 190      23.239  59.624  22.561  1.00 49.19           N  
ATOM    838  NH2 ARG A 190      22.808  59.196  24.782  1.00 50.25           N  
ATOM    839  N   ARG A 191      29.988  56.825  20.799  1.00 19.26           N  
ATOM    840  CA  ARG A 191      30.182  55.692  19.910  1.00 20.17           C  
ATOM    841  C   ARG A 191      31.500  54.991  20.241  1.00 19.18           C  
ATOM    842  O   ARG A 191      31.617  53.771  20.128  1.00 16.56           O  
ATOM    843  CB  ARG A 191      30.191  56.177  18.459  1.00 21.01           C  
ATOM    844  CG  ARG A 191      30.626  55.151  17.445  1.00 24.28           C  
ATOM    845  CD  ARG A 191      29.658  54.002  17.316  1.00 30.77           C  
ATOM    846  NE  ARG A 191      30.043  53.167  16.186  1.00 36.12           N  
ATOM    847  CZ  ARG A 191      29.393  52.074  15.799  1.00 39.60           C  
ATOM    848  NH1 ARG A 191      28.310  51.676  16.459  1.00 41.81           N  
ATOM    849  NH2 ARG A 191      29.830  51.379  14.749  1.00 40.88           N  
ATOM    850  N   GLY A 192      32.493  55.777  20.641  1.00 19.25           N  
ATOM    851  CA  GLY A 192      33.785  55.213  20.993  1.00 19.11           C  
ATOM    852  C   GLY A 192      33.666  54.273  22.180  1.00 18.18           C  
ATOM    853  O   GLY A 192      34.189  53.163  22.146  1.00 18.95           O  
ATOM    854  N   GLY A 193      32.976  54.714  23.229  1.00 18.07           N  
ATOM    855  CA  GLY A 193      32.806  53.873  24.401  1.00 18.12           C  
ATOM    856  C   GLY A 193      31.996  52.635  24.051  1.00 18.38           C  
ATOM    857  O   GLY A 193      32.283  51.533  24.515  1.00 17.73           O  
ATOM    858  N   GLU A 194      30.986  52.823  23.210  1.00 18.43           N  
ATOM    859  CA  GLU A 194      30.121  51.736  22.775  1.00 20.45           C  
ATOM    860  C   GLU A 194      30.946  50.623  22.129  1.00 20.65           C  
ATOM    861  O   GLU A 194      30.784  49.452  22.468  1.00 19.48           O  
ATOM    862  CB  GLU A 194      29.088  52.289  21.792  1.00 24.61           C  
ATOM    863  CG  GLU A 194      28.156  51.279  21.181  1.00 29.33           C  
ATOM    864  CD  GLU A 194      27.168  51.940  20.241  1.00 33.98           C  
ATOM    865  OE1 GLU A 194      27.236  51.678  19.012  1.00 36.05           O  
ATOM    866  OE2 GLU A 194      26.334  52.737  20.736  1.00 33.53           O  
ATOM    867  N   LEU A 195      31.844  50.999  21.220  1.00 19.39           N  
ATOM    868  CA  LEU A 195      32.700  50.038  20.521  1.00 20.07           C  
ATOM    869  C   LEU A 195      33.638  49.290  21.479  1.00 19.76           C  
ATOM    870  O   LEU A 195      33.925  48.115  21.280  1.00 21.93           O  
ATOM    871  CB  LEU A 195      33.528  50.749  19.442  1.00 20.18           C  
ATOM    872  CG  LEU A 195      32.778  51.289  18.220  1.00 21.59           C  
ATOM    873  CD1 LEU A 195      33.733  52.030  17.304  1.00 21.97           C  
ATOM    874  CD2 LEU A 195      32.135  50.147  17.467  1.00 24.51           C  
ATOM    875  N   ALA A 196      34.112  49.976  22.510  1.00 18.98           N  
ATOM    876  CA  ALA A 196      34.999  49.359  23.480  1.00 19.15           C  
ATOM    877  C   ALA A 196      34.245  48.252  24.203  1.00 18.62           C  
ATOM    878  O   ALA A 196      34.751  47.142  24.365  1.00 17.98           O  
ATOM    879  CB  ALA A 196      35.484  50.395  24.480  1.00 18.44           C  
ATOM    880  N   ALA A 197      33.030  48.560  24.637  1.00 18.46           N  
ATOM    881  CA  ALA A 197      32.219  47.580  25.333  1.00 19.26           C  
ATOM    882  C   ALA A 197      31.878  46.408  24.416  1.00 19.03           C  
ATOM    883  O   ALA A 197      31.998  45.255  24.816  1.00 19.15           O  
ATOM    884  CB  ALA A 197      30.941  48.227  25.857  1.00 16.62           C  
ATOM    885  N   ALA A 198      31.461  46.703  23.189  1.00 19.22           N  
ATOM    886  CA  ALA A 198      31.086  45.660  22.239  1.00 18.52           C  
ATOM    887  C   ALA A 198      32.239  44.729  21.917  1.00 19.29           C  
ATOM    888  O   ALA A 198      32.036  43.531  21.722  1.00 19.28           O  
ATOM    889  CB  ALA A 198      30.552  46.282  20.959  1.00 19.11           C  
ATOM    890  N   THR A 199      33.447  45.278  21.842  1.00 18.26           N  
ATOM    891  CA  THR A 199      34.612  44.457  21.555  1.00 19.80           C  
ATOM    892  C   THR A 199      34.738  43.422  22.671  1.00 18.57           C  
ATOM    893  O   THR A 199      34.820  42.222  22.413  1.00 20.72           O  
ATOM    894  CB  THR A 199      35.915  45.293  21.501  1.00 20.53           C  
ATOM    895  OG1 THR A 199      35.777  46.354  20.551  1.00 19.83           O  
ATOM    896  CG2 THR A 199      37.084  44.415  21.087  1.00 22.84           C  
ATOM    897  N   LEU A 200      34.729  43.889  23.913  1.00 17.22           N  
ATOM    898  CA  LEU A 200      34.847  42.999  25.060  1.00 17.09           C  
ATOM    899  C   LEU A 200      33.691  42.003  25.149  1.00 17.14           C  
ATOM    900  O   LEU A 200      33.900  40.802  25.299  1.00 17.90           O  
ATOM    901  CB  LEU A 200      34.920  43.813  26.353  1.00 14.75           C  
ATOM    902  CG  LEU A 200      36.180  44.676  26.494  1.00 17.49           C  
ATOM    903  CD1 LEU A 200      36.106  45.529  27.757  1.00 18.97           C  
ATOM    904  CD2 LEU A 200      37.408  43.775  26.519  1.00 15.40           C  
ATOM    905  N   ILE A 201      32.470  42.501  25.059  1.00 18.23           N  
ATOM    906  CA  ILE A 201      31.327  41.622  25.159  1.00 21.64           C  
ATOM    907  C   ILE A 201      31.286  40.586  24.045  1.00 21.12           C  
ATOM    908  O   ILE A 201      30.967  39.432  24.291  1.00 21.64           O  
ATOM    909  CB  ILE A 201      30.017  42.424  25.192  1.00 21.27           C  
ATOM    910  CG1 ILE A 201      29.903  43.131  26.551  1.00 21.09           C  
ATOM    911  CG2 ILE A 201      28.820  41.486  24.991  1.00 22.60           C  
ATOM    912  CD1 ILE A 201      28.932  44.279  26.569  1.00 24.35           C  
ATOM    913  N   GLU A 202      31.637  40.987  22.829  1.00 22.66           N  
ATOM    914  CA  GLU A 202      31.628  40.063  21.704  1.00 24.83           C  
ATOM    915  C   GLU A 202      32.659  38.955  21.881  1.00 25.38           C  
ATOM    916  O   GLU A 202      32.562  37.896  21.255  1.00 23.72           O  
ATOM    917  CB  GLU A 202      31.874  40.822  20.399  1.00 27.49           C  
ATOM    918  CG  GLU A 202      30.696  41.727  20.020  1.00 34.20           C  
ATOM    919  CD  GLU A 202      30.931  42.513  18.747  1.00 37.53           C  
ATOM    920  OE1 GLU A 202      32.065  42.479  18.219  1.00 39.04           O  
ATOM    921  OE2 GLU A 202      29.982  43.178  18.271  1.00 39.68           O  
ATOM    922  N   HIS A 203      33.644  39.198  22.741  1.00 23.37           N  
ATOM    923  CA  HIS A 203      34.670  38.204  22.994  1.00 23.49           C  
ATOM    924  C   HIS A 203      34.318  37.348  24.207  1.00 23.51           C  
ATOM    925  O   HIS A 203      35.182  36.703  24.798  1.00 22.87           O  
ATOM    926  CB  HIS A 203      36.033  38.886  23.158  1.00 22.62           C  
ATOM    927  CG  HIS A 203      36.663  39.259  21.853  1.00 22.57           C  
ATOM    928  ND1 HIS A 203      37.488  38.403  21.155  1.00 23.66           N  
ATOM    929  CD2 HIS A 203      36.520  40.359  21.078  1.00 20.99           C  
ATOM    930  CE1 HIS A 203      37.824  38.959  20.005  1.00 23.07           C  
ATOM    931  NE2 HIS A 203      37.250  40.146  19.933  1.00 24.46           N  
ATOM    932  N   GLY A 204      33.036  37.351  24.567  1.00 22.67           N  
ATOM    933  CA  GLY A 204      32.571  36.544  25.678  1.00 22.91           C  
ATOM    934  C   GLY A 204      32.753  37.060  27.094  1.00 23.18           C  
ATOM    935  O   GLY A 204      32.388  36.377  28.042  1.00 22.87           O  
ATOM    936  N   HIS A 205      33.307  38.252  27.263  1.00 22.64           N  
ATOM    937  CA  HIS A 205      33.500  38.783  28.607  1.00 22.12           C  
ATOM    938  C   HIS A 205      32.193  39.340  29.196  1.00 23.09           C  
ATOM    939  O   HIS A 205      31.508  40.135  28.554  1.00 22.34           O  
ATOM    940  CB  HIS A 205      34.585  39.863  28.568  1.00 22.08           C  
ATOM    941  CG  HIS A 205      35.900  39.365  28.050  1.00 20.70           C  
ATOM    942  ND1 HIS A 205      36.810  38.698  28.844  1.00 20.47           N  
ATOM    943  CD2 HIS A 205      36.431  39.378  26.805  1.00 20.44           C  
ATOM    944  CE1 HIS A 205      37.840  38.323  28.108  1.00 21.02           C  
ATOM    945  NE2 HIS A 205      37.636  38.721  26.866  1.00 20.77           N  
ATOM    946  N   ARG A 206      31.860  38.913  30.417  1.00 23.06           N  
ATOM    947  CA  ARG A 206      30.647  39.349  31.118  1.00 24.02           C  
ATOM    948  C   ARG A 206      30.982  40.145  32.378  1.00 22.93           C  
ATOM    949  O   ARG A 206      30.183  40.961  32.834  1.00 22.68           O  
ATOM    950  CB  ARG A 206      29.793  38.139  31.526  1.00 25.23           C  
ATOM    951  CG  ARG A 206      29.177  37.350  30.384  1.00 28.61           C  
ATOM    952  CD  ARG A 206      27.999  38.074  29.744  1.00 29.89           C  
ATOM    953  NE  ARG A 206      26.981  38.476  30.721  1.00 31.82           N  
ATOM    954  CZ  ARG A 206      25.862  39.128  30.403  1.00 32.62           C  
ATOM    955  NH1 ARG A 206      25.618  39.439  29.133  1.00 30.99           N  
ATOM    956  NH2 ARG A 206      25.001  39.496  31.349  1.00 32.16           N  
ATOM    957  N   LYS A 207      32.152  39.878  32.956  1.00 22.19           N  
ATOM    958  CA  LYS A 207      32.605  40.575  34.160  1.00 21.79           C  
ATOM    959  C   LYS A 207      33.694  41.529  33.694  1.00 21.91           C  
ATOM    960  O   LYS A 207      34.815  41.106  33.404  1.00 20.93           O  
ATOM    961  CB  LYS A 207      33.185  39.585  35.174  1.00 24.90           C  
ATOM    962  CG  LYS A 207      32.195  38.569  35.731  1.00 28.67           C  
ATOM    963  CD  LYS A 207      31.241  39.195  36.739  1.00 32.81           C  
ATOM    964  CE  LYS A 207      30.320  38.142  37.362  1.00 35.29           C  
ATOM    965  NZ  LYS A 207      29.528  37.389  36.326  1.00 37.02           N  
ATOM    966  N   LEU A 208      33.357  42.813  33.627  1.00 20.19           N  
ATOM    967  CA  LEU A 208      34.269  43.833  33.142  1.00 19.22           C  
ATOM    968  C   LEU A 208      34.660  44.827  34.224  1.00 18.66           C  
ATOM    969  O   LEU A 208      34.030  44.892  35.272  1.00 18.55           O  
ATOM    970  CB  LEU A 208      33.592  44.575  31.990  1.00 20.43           C  
ATOM    971  CG  LEU A 208      32.939  43.650  30.957  1.00 18.86           C  
ATOM    972  CD1 LEU A 208      31.957  44.422  30.113  1.00 19.62           C  
ATOM    973  CD2 LEU A 208      34.020  43.005  30.104  1.00 19.15           C  
ATOM    974  N   ALA A 209      35.707  45.598  33.947  1.00 17.17           N  
ATOM    975  CA  ALA A 209      36.206  46.617  34.860  1.00 17.12           C  
ATOM    976  C   ALA A 209      36.615  47.836  34.029  1.00 16.61           C  
ATOM    977  O   ALA A 209      36.927  47.711  32.847  1.00 18.70           O  
ATOM    978  CB  ALA A 209      37.408  46.079  35.652  1.00 16.07           C  
ATOM    979  N   VAL A 210      36.617  49.012  34.648  1.00 16.24           N  
ATOM    980  CA  VAL A 210      36.986  50.227  33.938  1.00 16.39           C  
ATOM    981  C   VAL A 210      37.898  51.167  34.725  1.00 17.02           C  
ATOM    982  O   VAL A 210      37.701  51.388  35.917  1.00 18.81           O  
ATOM    983  CB  VAL A 210      35.742  51.046  33.540  1.00 16.42           C  
ATOM    984  CG1 VAL A 210      36.175  52.292  32.790  1.00 16.96           C  
ATOM    985  CG2 VAL A 210      34.785  50.204  32.697  1.00 17.50           C  
ATOM    986  N   ILE A 211      38.902  51.705  34.044  1.00 18.60           N  
ATOM    987  CA  ILE A 211      39.817  52.674  34.636  1.00 19.23           C  
ATOM    988  C   ILE A 211      39.588  53.896  33.760  1.00 18.76           C  
ATOM    989  O   ILE A 211      39.953  53.897  32.588  1.00 18.93           O  
ATOM    990  CB  ILE A 211      41.291  52.225  34.525  1.00 19.78           C  
ATOM    991  CG1 ILE A 211      41.545  51.036  35.456  1.00 20.02           C  
ATOM    992  CG2 ILE A 211      42.211  53.390  34.883  1.00 20.51           C  
ATOM    993  CD1 ILE A 211      42.947  50.479  35.363  1.00 21.01           C  
ATOM    994  N   SER A 212      38.960  54.929  34.314  1.00 20.52           N  
ATOM    995  CA  SER A 212      38.667  56.114  33.520  1.00 21.87           C  
ATOM    996  C   SER A 212      39.500  57.344  33.830  1.00 21.39           C  
ATOM    997  O   SER A 212      40.420  57.309  34.654  1.00 20.07           O  
ATOM    998  CB  SER A 212      37.185  56.477  33.654  1.00 24.97           C  
ATOM    999  OG  SER A 212      36.940  57.284  34.801  1.00 26.67           O  
ATOM   1000  N   GLY A 213      39.170  58.430  33.132  1.00 20.50           N  
ATOM   1001  CA  GLY A 213      39.843  59.689  33.351  1.00 20.91           C  
ATOM   1002  C   GLY A 213      39.002  60.423  34.369  1.00 21.85           C  
ATOM   1003  O   GLY A 213      38.077  59.835  34.931  1.00 21.55           O  
ATOM   1004  N   PRO A 214      39.293  61.700  34.644  1.00 23.18           N  
ATOM   1005  CA  PRO A 214      38.491  62.428  35.624  1.00 23.22           C  
ATOM   1006  C   PRO A 214      37.016  62.457  35.248  1.00 23.79           C  
ATOM   1007  O   PRO A 214      36.657  62.611  34.078  1.00 22.45           O  
ATOM   1008  CB  PRO A 214      39.121  63.823  35.630  1.00 24.95           C  
ATOM   1009  CG  PRO A 214      39.795  63.923  34.287  1.00 25.44           C  
ATOM   1010  CD  PRO A 214      40.368  62.549  34.103  1.00 24.26           C  
ATOM   1011  N   PHE A 215      36.167  62.303  36.256  1.00 25.17           N  
ATOM   1012  CA  PHE A 215      34.729  62.312  36.050  1.00 27.80           C  
ATOM   1013  C   PHE A 215      34.246  63.660  35.533  1.00 29.03           C  
ATOM   1014  O   PHE A 215      33.164  63.748  34.948  1.00 28.92           O  
ATOM   1015  CB  PHE A 215      34.014  61.965  37.358  1.00 29.09           C  
ATOM   1016  CG  PHE A 215      34.103  60.499  37.731  1.00 31.75           C  
ATOM   1017  CD1 PHE A 215      33.727  60.071  39.004  1.00 32.16           C  
ATOM   1018  CD2 PHE A 215      34.561  59.544  36.803  1.00 32.09           C  
ATOM   1019  CE1 PHE A 215      33.808  58.718  39.365  1.00 31.53           C  
ATOM   1020  CE2 PHE A 215      34.648  58.190  37.142  1.00 30.35           C  
ATOM   1021  CZ  PHE A 215      34.269  57.774  38.432  1.00 32.69           C  
ATOM   1022  N   THR A 216      35.045  64.705  35.750  1.00 29.37           N  
ATOM   1023  CA  THR A 216      34.687  66.048  35.291  1.00 31.06           C  
ATOM   1024  C   THR A 216      35.072  66.328  33.834  1.00 30.79           C  
ATOM   1025  O   THR A 216      34.778  67.404  33.309  1.00 33.06           O  
ATOM   1026  CB  THR A 216      35.315  67.148  36.182  1.00 31.57           C  
ATOM   1027  OG1 THR A 216      36.725  66.911  36.328  1.00 31.24           O  
ATOM   1028  CG2 THR A 216      34.637  67.179  37.556  1.00 30.85           C  
ATOM   1029  N   ALA A 217      35.734  65.378  33.181  1.00 28.85           N  
ATOM   1030  CA  ALA A 217      36.117  65.563  31.779  1.00 27.27           C  
ATOM   1031  C   ALA A 217      34.943  65.090  30.923  1.00 26.87           C  
ATOM   1032  O   ALA A 217      34.575  63.918  30.969  1.00 24.84           O  
ATOM   1033  CB  ALA A 217      37.371  64.756  31.454  1.00 27.04           C  
ATOM   1034  N   SER A 218      34.355  66.001  30.149  1.00 26.27           N  
ATOM   1035  CA  SER A 218      33.205  65.662  29.314  1.00 27.64           C  
ATOM   1036  C   SER A 218      33.508  64.582  28.278  1.00 26.07           C  
ATOM   1037  O   SER A 218      32.652  63.763  27.969  1.00 25.18           O  
ATOM   1038  CB  SER A 218      32.647  66.913  28.611  1.00 27.58           C  
ATOM   1039  OG  SER A 218      33.533  67.393  27.616  1.00 30.31           O  
ATOM   1040  N   ASP A 219      34.719  64.575  27.739  1.00 26.56           N  
ATOM   1041  CA  ASP A 219      35.074  63.564  26.757  1.00 27.31           C  
ATOM   1042  C   ASP A 219      35.073  62.198  27.444  1.00 27.61           C  
ATOM   1043  O   ASP A 219      34.811  61.170  26.812  1.00 26.43           O  
ATOM   1044  CB  ASP A 219      36.450  63.859  26.165  1.00 30.00           C  
ATOM   1045  CG  ASP A 219      37.493  64.145  27.230  1.00 33.29           C  
ATOM   1046  OD1 ASP A 219      37.197  64.933  28.157  1.00 33.31           O  
ATOM   1047  OD2 ASP A 219      38.611  63.595  27.136  1.00 35.35           O  
ATOM   1048  N   ASN A 220      35.342  62.195  28.747  1.00 26.60           N  
ATOM   1049  CA  ASN A 220      35.377  60.951  29.498  1.00 26.04           C  
ATOM   1050  C   ASN A 220      33.970  60.496  29.844  1.00 26.04           C  
ATOM   1051  O   ASN A 220      33.643  59.319  29.713  1.00 27.32           O  
ATOM   1052  CB  ASN A 220      36.200  61.125  30.773  1.00 24.08           C  
ATOM   1053  CG  ASN A 220      36.343  59.831  31.558  1.00 22.06           C  
ATOM   1054  OD1 ASN A 220      35.604  59.580  32.512  1.00 22.57           O  
ATOM   1055  ND2 ASN A 220      37.287  59.001  31.149  1.00 18.01           N  
ATOM   1056  N   VAL A 221      33.135  61.432  30.272  1.00 25.62           N  
ATOM   1057  CA  VAL A 221      31.769  61.101  30.638  1.00 26.27           C  
ATOM   1058  C   VAL A 221      30.963  60.476  29.496  1.00 26.05           C  
ATOM   1059  O   VAL A 221      30.206  59.531  29.715  1.00 24.19           O  
ATOM   1060  CB  VAL A 221      31.026  62.345  31.157  1.00 27.72           C  
ATOM   1061  CG1 VAL A 221      29.584  61.987  31.504  1.00 27.69           C  
ATOM   1062  CG2 VAL A 221      31.741  62.883  32.388  1.00 30.16           C  
ATOM   1063  N   GLU A 222      31.127  60.998  28.284  1.00 25.13           N  
ATOM   1064  CA  GLU A 222      30.386  60.480  27.135  1.00 26.17           C  
ATOM   1065  C   GLU A 222      30.969  59.160  26.683  1.00 23.10           C  
ATOM   1066  O   GLU A 222      30.280  58.310  26.142  1.00 20.04           O  
ATOM   1067  CB  GLU A 222      30.402  61.499  26.001  1.00 29.03           C  
ATOM   1068  CG  GLU A 222      29.274  62.505  26.128  1.00 37.30           C  
ATOM   1069  CD  GLU A 222      29.617  63.851  25.540  1.00 42.84           C  
ATOM   1070  OE1 GLU A 222      30.123  63.877  24.390  1.00 47.25           O  
ATOM   1071  OE2 GLU A 222      29.371  64.882  26.221  1.00 44.66           O  
ATOM   1072  N   ARG A 223      32.260  59.006  26.927  1.00 22.15           N  
ATOM   1073  CA  ARG A 223      32.979  57.791  26.601  1.00 22.94           C  
ATOM   1074  C   ARG A 223      32.396  56.674  27.480  1.00 22.19           C  
ATOM   1075  O   ARG A 223      32.073  55.582  27.003  1.00 24.05           O  
ATOM   1076  CB  ARG A 223      34.453  58.022  26.926  1.00 25.76           C  
ATOM   1077  CG  ARG A 223      35.414  56.980  26.452  1.00 24.70           C  
ATOM   1078  CD  ARG A 223      36.830  57.528  26.637  1.00 24.73           C  
ATOM   1079  NE  ARG A 223      36.908  58.922  26.186  1.00 24.40           N  
ATOM   1080  CZ  ARG A 223      38.028  59.632  26.086  1.00 23.95           C  
ATOM   1081  NH1 ARG A 223      39.198  59.093  26.404  1.00 24.01           N  
ATOM   1082  NH2 ARG A 223      37.977  60.892  25.671  1.00 25.84           N  
ATOM   1083  N   LEU A 224      32.268  56.957  28.772  1.00 21.30           N  
ATOM   1084  CA  LEU A 224      31.716  55.992  29.718  1.00 21.30           C  
ATOM   1085  C   LEU A 224      30.228  55.774  29.454  1.00 21.95           C  
ATOM   1086  O   LEU A 224      29.735  54.655  29.548  1.00 22.18           O  
ATOM   1087  CB  LEU A 224      31.889  56.482  31.159  1.00 20.12           C  
ATOM   1088  CG  LEU A 224      33.299  56.635  31.729  1.00 19.93           C  
ATOM   1089  CD1 LEU A 224      33.192  57.102  33.176  1.00 17.95           C  
ATOM   1090  CD2 LEU A 224      34.057  55.310  31.647  1.00 19.93           C  
ATOM   1091  N   ASP A 225      29.508  56.847  29.150  1.00 22.97           N  
ATOM   1092  CA  ASP A 225      28.083  56.728  28.881  1.00 23.42           C  
ATOM   1093  C   ASP A 225      27.845  55.705  27.772  1.00 23.53           C  
ATOM   1094  O   ASP A 225      27.024  54.804  27.926  1.00 24.13           O  
ATOM   1095  CB  ASP A 225      27.510  58.085  28.484  1.00 26.30           C  
ATOM   1096  CG  ASP A 225      27.224  58.969  29.683  1.00 32.04           C  
ATOM   1097  OD1 ASP A 225      27.688  58.652  30.810  1.00 35.24           O  
ATOM   1098  OD2 ASP A 225      26.534  59.992  29.496  1.00 35.41           O  
ATOM   1099  N   GLY A 226      28.568  55.851  26.664  1.00 21.86           N  
ATOM   1100  CA  GLY A 226      28.431  54.923  25.553  1.00 20.95           C  
ATOM   1101  C   GLY A 226      28.821  53.516  25.958  1.00 21.22           C  
ATOM   1102  O   GLY A 226      28.196  52.536  25.544  1.00 20.23           O  
ATOM   1103  N   PHE A 227      29.866  53.409  26.766  1.00 18.95           N  
ATOM   1104  CA  PHE A 227      30.322  52.108  27.236  1.00 18.69           C  
ATOM   1105  C   PHE A 227      29.193  51.423  28.011  1.00 20.39           C  
ATOM   1106  O   PHE A 227      28.846  50.275  27.739  1.00 19.35           O  
ATOM   1107  CB  PHE A 227      31.526  52.289  28.159  1.00 17.03           C  
ATOM   1108  CG  PHE A 227      32.086  51.002  28.684  1.00 16.83           C  
ATOM   1109  CD1 PHE A 227      32.896  50.199  27.882  1.00 15.58           C  
ATOM   1110  CD2 PHE A 227      31.832  50.604  29.995  1.00 14.95           C  
ATOM   1111  CE1 PHE A 227      33.456  49.015  28.385  1.00 15.27           C  
ATOM   1112  CE2 PHE A 227      32.381  49.428  30.507  1.00 14.46           C  
ATOM   1113  CZ  PHE A 227      33.199  48.632  29.699  1.00 13.61           C  
ATOM   1114  N   PHE A 228      28.620  52.141  28.971  1.00 19.10           N  
ATOM   1115  CA  PHE A 228      27.561  51.581  29.788  1.00 20.37           C  
ATOM   1116  C   PHE A 228      26.216  51.406  29.106  1.00 20.99           C  
ATOM   1117  O   PHE A 228      25.405  50.609  29.570  1.00 21.97           O  
ATOM   1118  CB  PHE A 228      27.428  52.384  31.073  1.00 20.13           C  
ATOM   1119  CG  PHE A 228      28.581  52.178  32.013  1.00 20.14           C  
ATOM   1120  CD1 PHE A 228      28.791  50.929  32.597  1.00 20.68           C  
ATOM   1121  CD2 PHE A 228      29.477  53.211  32.288  1.00 19.37           C  
ATOM   1122  CE1 PHE A 228      29.885  50.699  33.449  1.00 21.34           C  
ATOM   1123  CE2 PHE A 228      30.579  53.008  33.137  1.00 20.30           C  
ATOM   1124  CZ  PHE A 228      30.785  51.746  33.719  1.00 21.37           C  
ATOM   1125  N   ASP A 229      25.971  52.139  28.018  1.00 22.84           N  
ATOM   1126  CA  ASP A 229      24.717  51.971  27.291  1.00 23.38           C  
ATOM   1127  C   ASP A 229      24.785  50.576  26.682  1.00 22.54           C  
ATOM   1128  O   ASP A 229      23.845  49.798  26.790  1.00 22.01           O  
ATOM   1129  CB  ASP A 229      24.565  52.985  26.150  1.00 25.88           C  
ATOM   1130  CG  ASP A 229      24.234  54.385  26.634  1.00 28.09           C  
ATOM   1131  OD1 ASP A 229      23.734  54.535  27.769  1.00 28.25           O  
ATOM   1132  OD2 ASP A 229      24.460  55.345  25.861  1.00 31.25           O  
ATOM   1133  N   GLU A 230      25.912  50.270  26.048  1.00 21.56           N  
ATOM   1134  CA  GLU A 230      26.120  48.970  25.413  1.00 20.96           C  
ATOM   1135  C   GLU A 230      26.023  47.839  26.442  1.00 21.15           C  
ATOM   1136  O   GLU A 230      25.456  46.779  26.158  1.00 20.22           O  
ATOM   1137  CB  GLU A 230      27.483  48.944  24.730  1.00 21.75           C  
ATOM   1138  CG  GLU A 230      27.805  47.667  23.968  1.00 25.01           C  
ATOM   1139  CD  GLU A 230      26.909  47.451  22.759  1.00 27.38           C  
ATOM   1140  OE1 GLU A 230      26.374  48.444  22.209  1.00 28.29           O  
ATOM   1141  OE2 GLU A 230      26.753  46.281  22.341  1.00 29.45           O  
ATOM   1142  N   LEU A 231      26.571  48.067  27.633  1.00 20.43           N  
ATOM   1143  CA  LEU A 231      26.516  47.062  28.690  1.00 20.92           C  
ATOM   1144  C   LEU A 231      25.064  46.823  29.102  1.00 21.04           C  
ATOM   1145  O   LEU A 231      24.661  45.684  29.329  1.00 19.79           O  
ATOM   1146  CB  LEU A 231      27.308  47.493  29.933  1.00 21.36           C  
ATOM   1147  CG  LEU A 231      28.829  47.741  29.874  1.00 25.70           C  
ATOM   1148  CD1 LEU A 231      29.432  47.422  31.239  1.00 22.27           C  
ATOM   1149  CD2 LEU A 231      29.480  46.886  28.802  1.00 22.15           C  
ATOM   1150  N   ALA A 232      24.292  47.904  29.201  1.00 19.76           N  
ATOM   1151  CA  ALA A 232      22.893  47.819  29.595  1.00 20.11           C  
ATOM   1152  C   ALA A 232      22.097  46.985  28.606  1.00 20.42           C  
ATOM   1153  O   ALA A 232      21.198  46.245  29.006  1.00 19.77           O  
ATOM   1154  CB  ALA A 232      22.292  49.209  29.710  1.00 21.66           C  
ATOM   1155  N   ARG A 233      22.421  47.107  27.320  1.00 19.51           N  
ATOM   1156  CA  ARG A 233      21.740  46.339  26.273  1.00 21.24           C  
ATOM   1157  C   ARG A 233      22.005  44.848  26.433  1.00 22.80           C  
ATOM   1158  O   ARG A 233      21.296  44.017  25.858  1.00 23.25           O  
ATOM   1159  CB  ARG A 233      22.212  46.761  24.877  1.00 20.22           C  
ATOM   1160  CG  ARG A 233      21.731  48.118  24.426  1.00 24.67           C  
ATOM   1161  CD  ARG A 233      22.330  48.506  23.074  1.00 26.73           C  
ATOM   1162  NE  ARG A 233      22.119  49.924  22.821  1.00 32.34           N  
ATOM   1163  CZ  ARG A 233      23.087  50.834  22.754  1.00 33.45           C  
ATOM   1164  NH1 ARG A 233      24.357  50.475  22.909  1.00 34.98           N  
ATOM   1165  NH2 ARG A 233      22.779  52.113  22.570  1.00 34.61           N  
ATOM   1166  N   HIS A 234      23.037  44.512  27.200  1.00 23.15           N  
ATOM   1167  CA  HIS A 234      23.390  43.124  27.431  1.00 23.48           C  
ATOM   1168  C   HIS A 234      23.059  42.645  28.826  1.00 23.83           C  
ATOM   1169  O   HIS A 234      23.532  41.592  29.256  1.00 25.35           O  
ATOM   1170  CB  HIS A 234      24.861  42.898  27.133  1.00 24.89           C  
ATOM   1171  CG  HIS A 234      25.164  42.910  25.674  1.00 26.58           C  
ATOM   1172  ND1 HIS A 234      25.391  44.074  24.972  1.00 28.29           N  
ATOM   1173  CD2 HIS A 234      25.165  41.912  24.761  1.00 27.73           C  
ATOM   1174  CE1 HIS A 234      25.515  43.792  23.689  1.00 30.47           C  
ATOM   1175  NE2 HIS A 234      25.382  42.487  23.533  1.00 29.02           N  
ATOM   1176  N   GLY A 235      22.240  43.420  29.527  1.00 22.04           N  
ATOM   1177  CA  GLY A 235      21.830  43.038  30.863  1.00 21.84           C  
ATOM   1178  C   GLY A 235      22.867  43.252  31.945  1.00 20.11           C  
ATOM   1179  O   GLY A 235      22.835  42.591  32.976  1.00 19.29           O  
ATOM   1180  N   ILE A 236      23.786  44.180  31.723  1.00 20.53           N  
ATOM   1181  CA  ILE A 236      24.815  44.460  32.713  1.00 18.95           C  
ATOM   1182  C   ILE A 236      24.632  45.859  33.291  1.00 18.57           C  
ATOM   1183  O   ILE A 236      24.752  46.859  32.584  1.00 18.37           O  
ATOM   1184  CB  ILE A 236      26.218  44.319  32.105  1.00 20.63           C  
ATOM   1185  CG1 ILE A 236      26.399  42.898  31.556  1.00 20.03           C  
ATOM   1186  CG2 ILE A 236      27.271  44.595  33.168  1.00 18.54           C  
ATOM   1187  CD1 ILE A 236      27.728  42.662  30.904  1.00 20.70           C  
ATOM   1188  N   ALA A 237      24.337  45.917  34.585  1.00 18.07           N  
ATOM   1189  CA  ALA A 237      24.100  47.182  35.266  1.00 20.89           C  
ATOM   1190  C   ALA A 237      25.368  47.983  35.522  1.00 22.04           C  
ATOM   1191  O   ALA A 237      26.368  47.456  36.012  1.00 22.80           O  
ATOM   1192  CB  ALA A 237      23.362  46.934  36.583  1.00 21.12           C  
ATOM   1193  N   ARG A 238      25.314  49.265  35.184  1.00 21.70           N  
ATOM   1194  CA  ARG A 238      26.449  50.158  35.380  1.00 23.86           C  
ATOM   1195  C   ARG A 238      26.981  50.045  36.814  1.00 26.04           C  
ATOM   1196  O   ARG A 238      28.196  49.995  37.040  1.00 24.96           O  
ATOM   1197  CB  ARG A 238      26.015  51.602  35.083  1.00 24.07           C  
ATOM   1198  CG  ARG A 238      27.066  52.678  35.345  1.00 25.02           C  
ATOM   1199  CD  ARG A 238      26.752  53.945  34.550  1.00 26.05           C  
ATOM   1200  NE  ARG A 238      27.755  54.984  34.753  1.00 27.39           N  
ATOM   1201  CZ  ARG A 238      28.012  55.959  33.885  1.00 29.48           C  
ATOM   1202  NH1 ARG A 238      27.340  56.041  32.739  1.00 28.64           N  
ATOM   1203  NH2 ARG A 238      28.953  56.850  34.160  1.00 29.50           N  
ATOM   1204  N   ASP A 239      26.061  49.972  37.775  1.00 28.59           N  
ATOM   1205  CA  ASP A 239      26.418  49.903  39.189  1.00 30.13           C  
ATOM   1206  C   ASP A 239      27.200  48.680  39.656  1.00 28.33           C  
ATOM   1207  O   ASP A 239      27.799  48.707  40.729  1.00 29.55           O  
ATOM   1208  CB  ASP A 239      25.165  50.064  40.070  1.00 34.98           C  
ATOM   1209  CG  ASP A 239      24.088  49.032  39.771  1.00 39.79           C  
ATOM   1210  OD1 ASP A 239      24.433  47.890  39.387  1.00 41.93           O  
ATOM   1211  OD2 ASP A 239      22.880  49.354  39.946  1.00 43.17           O  
ATOM   1212  N   SER A 240      27.207  47.616  38.865  1.00 25.96           N  
ATOM   1213  CA  SER A 240      27.921  46.398  39.246  1.00 25.86           C  
ATOM   1214  C   SER A 240      29.320  46.315  38.641  1.00 23.95           C  
ATOM   1215  O   SER A 240      30.018  45.321  38.820  1.00 23.33           O  
ATOM   1216  CB  SER A 240      27.135  45.171  38.795  1.00 25.32           C  
ATOM   1217  OG  SER A 240      27.075  45.144  37.378  1.00 27.79           O  
ATOM   1218  N   VAL A 241      29.728  47.352  37.924  1.00 22.49           N  
ATOM   1219  CA  VAL A 241      31.040  47.343  37.279  1.00 21.12           C  
ATOM   1220  C   VAL A 241      32.091  48.167  38.016  1.00 20.50           C  
ATOM   1221  O   VAL A 241      31.924  49.370  38.206  1.00 19.36           O  
ATOM   1222  CB  VAL A 241      30.929  47.870  35.824  1.00 20.21           C  
ATOM   1223  CG1 VAL A 241      32.308  47.958  35.180  1.00 18.68           C  
ATOM   1224  CG2 VAL A 241      30.021  46.961  35.016  1.00 18.23           C  
ATOM   1225  N   PRO A 242      33.180  47.522  38.458  1.00 21.24           N  
ATOM   1226  CA  PRO A 242      34.227  48.272  39.161  1.00 22.64           C  
ATOM   1227  C   PRO A 242      34.763  49.391  38.257  1.00 23.06           C  
ATOM   1228  O   PRO A 242      35.137  49.155  37.106  1.00 23.83           O  
ATOM   1229  CB  PRO A 242      35.275  47.203  39.482  1.00 22.51           C  
ATOM   1230  CG  PRO A 242      34.984  46.092  38.502  1.00 24.80           C  
ATOM   1231  CD  PRO A 242      33.481  46.082  38.453  1.00 22.36           C  
ATOM   1232  N   LEU A 243      34.780  50.604  38.791  1.00 22.14           N  
ATOM   1233  CA  LEU A 243      35.214  51.778  38.058  1.00 24.22           C  
ATOM   1234  C   LEU A 243      36.175  52.597  38.917  1.00 24.78           C  
ATOM   1235  O   LEU A 243      35.796  53.098  39.974  1.00 25.65           O  
ATOM   1236  CB  LEU A 243      33.980  52.617  37.700  1.00 26.44           C  
ATOM   1237  CG  LEU A 243      34.024  53.804  36.731  1.00 28.18           C  
ATOM   1238  CD1 LEU A 243      35.186  54.695  37.093  1.00 29.28           C  
ATOM   1239  CD2 LEU A 243      34.147  53.329  35.291  1.00 29.07           C  
ATOM   1240  N   ILE A 244      37.418  52.727  38.467  1.00 24.85           N  
ATOM   1241  CA  ILE A 244      38.417  53.506  39.199  1.00 24.44           C  
ATOM   1242  C   ILE A 244      38.623  54.834  38.473  1.00 24.09           C  
ATOM   1243  O   ILE A 244      38.974  54.843  37.298  1.00 23.65           O  
ATOM   1244  CB  ILE A 244      39.782  52.787  39.242  1.00 25.60           C  
ATOM   1245  CG1 ILE A 244      39.609  51.317  39.635  1.00 27.85           C  
ATOM   1246  CG2 ILE A 244      40.685  53.474  40.241  1.00 24.18           C  
ATOM   1247  CD1 ILE A 244      39.120  51.105  41.064  1.00 28.12           C  
ATOM   1248  N   GLU A 245      38.397  55.950  39.159  1.00 24.18           N  
ATOM   1249  CA  GLU A 245      38.594  57.258  38.541  1.00 24.45           C  
ATOM   1250  C   GLU A 245      40.090  57.557  38.559  1.00 24.12           C  
ATOM   1251  O   GLU A 245      40.749  57.385  39.586  1.00 22.69           O  
ATOM   1252  CB  GLU A 245      37.854  58.348  39.319  1.00 25.02           C  
ATOM   1253  CG  GLU A 245      37.678  59.651  38.538  1.00 28.28           C  
ATOM   1254  CD  GLU A 245      37.286  60.831  39.422  1.00 31.30           C  
ATOM   1255  OE1 GLU A 245      36.627  60.622  40.469  1.00 33.53           O  
ATOM   1256  OE2 GLU A 245      37.622  61.977  39.063  1.00 31.86           O  
ATOM   1257  N   SER A 246      40.628  57.991  37.421  1.00 23.61           N  
ATOM   1258  CA  SER A 246      42.047  58.317  37.342  1.00 22.92           C  
ATOM   1259  C   SER A 246      42.270  59.648  36.614  1.00 23.62           C  
ATOM   1260  O   SER A 246      41.328  60.417  36.436  1.00 22.34           O  
ATOM   1261  CB  SER A 246      42.819  57.191  36.657  1.00 23.10           C  
ATOM   1262  OG  SER A 246      44.207  57.366  36.861  1.00 24.19           O  
ATOM   1263  N   ASP A 247      43.500  59.914  36.173  1.00 24.77           N  
ATOM   1264  CA  ASP A 247      43.792  61.191  35.528  1.00 24.19           C  
ATOM   1265  C   ASP A 247      44.416  61.176  34.137  1.00 23.63           C  
ATOM   1266  O   ASP A 247      44.975  62.181  33.718  1.00 24.02           O  
ATOM   1267  CB  ASP A 247      44.688  62.018  36.453  1.00 25.87           C  
ATOM   1268  CG  ASP A 247      46.030  61.354  36.698  1.00 27.47           C  
ATOM   1269  OD1 ASP A 247      46.304  60.312  36.061  1.00 27.62           O  
ATOM   1270  OD2 ASP A 247      46.817  61.871  37.516  1.00 30.26           O  
ATOM   1271  N   PHE A 248      44.314  60.062  33.419  1.00 23.27           N  
ATOM   1272  CA  PHE A 248      44.891  59.949  32.072  1.00 23.17           C  
ATOM   1273  C   PHE A 248      46.420  59.851  32.009  1.00 22.55           C  
ATOM   1274  O   PHE A 248      46.975  59.706  30.916  1.00 20.83           O  
ATOM   1275  CB  PHE A 248      44.479  61.134  31.176  1.00 23.61           C  
ATOM   1276  CG  PHE A 248      43.041  61.114  30.738  1.00 24.41           C  
ATOM   1277  CD1 PHE A 248      42.442  59.933  30.292  1.00 25.40           C  
ATOM   1278  CD2 PHE A 248      42.298  62.294  30.718  1.00 24.34           C  
ATOM   1279  CE1 PHE A 248      41.116  59.923  29.827  1.00 24.94           C  
ATOM   1280  CE2 PHE A 248      40.974  62.304  30.256  1.00 24.70           C  
ATOM   1281  CZ  PHE A 248      40.382  61.113  29.807  1.00 24.99           C  
ATOM   1282  N   SER A 249      47.101  59.943  33.148  1.00 21.59           N  
ATOM   1283  CA  SER A 249      48.567  59.875  33.157  1.00 21.32           C  
ATOM   1284  C   SER A 249      49.122  58.469  33.371  1.00 21.78           C  
ATOM   1285  O   SER A 249      48.417  57.580  33.838  1.00 21.39           O  
ATOM   1286  CB  SER A 249      49.130  60.770  34.259  1.00 22.84           C  
ATOM   1287  OG  SER A 249      48.801  60.242  35.537  1.00 23.73           O  
ATOM   1288  N   PRO A 250      50.413  58.259  33.050  1.00 21.39           N  
ATOM   1289  CA  PRO A 250      51.033  56.942  33.230  1.00 21.55           C  
ATOM   1290  C   PRO A 250      50.947  56.464  34.677  1.00 21.26           C  
ATOM   1291  O   PRO A 250      50.526  55.338  34.938  1.00 21.09           O  
ATOM   1292  CB  PRO A 250      52.481  57.172  32.793  1.00 20.89           C  
ATOM   1293  CG  PRO A 250      52.357  58.251  31.770  1.00 21.32           C  
ATOM   1294  CD  PRO A 250      51.363  59.192  32.418  1.00 21.44           C  
ATOM   1295  N   GLU A 251      51.354  57.324  35.609  1.00 20.87           N  
ATOM   1296  CA  GLU A 251      51.330  56.986  37.034  1.00 20.97           C  
ATOM   1297  C   GLU A 251      49.902  56.783  37.545  1.00 20.81           C  
ATOM   1298  O   GLU A 251      49.663  55.946  38.418  1.00 19.82           O  
ATOM   1299  CB  GLU A 251      52.011  58.080  37.860  1.00 22.63           C  
ATOM   1300  CG  GLU A 251      51.325  59.437  37.758  1.00 26.51           C  
ATOM   1301  CD  GLU A 251      51.883  60.309  36.640  1.00 28.55           C  
ATOM   1302  OE1 GLU A 251      52.293  59.763  35.592  1.00 27.42           O  
ATOM   1303  OE2 GLU A 251      51.898  61.552  36.813  1.00 30.04           O  
ATOM   1304  N   GLY A 252      48.960  57.558  37.005  1.00 19.32           N  
ATOM   1305  CA  GLY A 252      47.572  57.426  37.416  1.00 19.16           C  
ATOM   1306  C   GLY A 252      47.037  56.061  37.031  1.00 18.77           C  
ATOM   1307  O   GLY A 252      46.385  55.394  37.820  1.00 18.99           O  
ATOM   1308  N   GLY A 253      47.319  55.646  35.802  1.00 18.26           N  
ATOM   1309  CA  GLY A 253      46.857  54.357  35.334  1.00 18.22           C  
ATOM   1310  C   GLY A 253      47.448  53.217  36.137  1.00 19.08           C  
ATOM   1311  O   GLY A 253      46.768  52.234  36.417  1.00 17.92           O  
ATOM   1312  N   TYR A 254      48.718  53.347  36.510  1.00 18.82           N  
ATOM   1313  CA  TYR A 254      49.387  52.311  37.285  1.00 18.94           C  
ATOM   1314  C   TYR A 254      48.735  52.162  38.651  1.00 18.87           C  
ATOM   1315  O   TYR A 254      48.432  51.052  39.095  1.00 20.14           O  
ATOM   1316  CB  TYR A 254      50.868  52.644  37.471  1.00 19.96           C  
ATOM   1317  CG  TYR A 254      51.645  51.553  38.169  1.00 23.01           C  
ATOM   1318  CD1 TYR A 254      51.999  50.385  37.495  1.00 23.23           C  
ATOM   1319  CD2 TYR A 254      52.029  51.687  39.508  1.00 22.45           C  
ATOM   1320  CE1 TYR A 254      52.722  49.377  38.136  1.00 23.88           C  
ATOM   1321  CE2 TYR A 254      52.745  50.685  40.159  1.00 23.25           C  
ATOM   1322  CZ  TYR A 254      53.089  49.531  39.467  1.00 24.72           C  
ATOM   1323  OH  TYR A 254      53.784  48.518  40.106  1.00 25.85           O  
ATOM   1324  N   ALA A 255      48.518  53.295  39.309  1.00 19.11           N  
ATOM   1325  CA  ALA A 255      47.904  53.315  40.627  1.00 20.38           C  
ATOM   1326  C   ALA A 255      46.467  52.800  40.569  1.00 20.17           C  
ATOM   1327  O   ALA A 255      45.996  52.122  41.488  1.00 19.98           O  
ATOM   1328  CB  ALA A 255      47.927  54.738  41.183  1.00 19.96           C  
ATOM   1329  N   ALA A 256      45.765  53.120  39.488  1.00 19.54           N  
ATOM   1330  CA  ALA A 256      44.382  52.690  39.352  1.00 19.44           C  
ATOM   1331  C   ALA A 256      44.310  51.180  39.145  1.00 19.81           C  
ATOM   1332  O   ALA A 256      43.393  50.526  39.645  1.00 18.28           O  
ATOM   1333  CB  ALA A 256      43.719  53.424  38.192  1.00 18.95           C  
ATOM   1334  N   THR A 257      45.280  50.624  38.419  1.00 20.09           N  
ATOM   1335  CA  THR A 257      45.284  49.185  38.191  1.00 20.64           C  
ATOM   1336  C   THR A 257      45.536  48.489  39.525  1.00 22.81           C  
ATOM   1337  O   THR A 257      44.886  47.492  39.848  1.00 20.98           O  
ATOM   1338  CB  THR A 257      46.362  48.749  37.165  1.00 20.55           C  
ATOM   1339  OG1 THR A 257      46.116  49.384  35.899  1.00 19.92           O  
ATOM   1340  CG2 THR A 257      46.306  47.244  36.958  1.00 19.45           C  
ATOM   1341  N   CYS A 258      46.469  49.026  40.306  1.00 22.80           N  
ATOM   1342  CA  CYS A 258      46.774  48.444  41.609  1.00 25.28           C  
ATOM   1343  C   CYS A 258      45.548  48.482  42.520  1.00 25.23           C  
ATOM   1344  O   CYS A 258      45.231  47.498  43.187  1.00 28.23           O  
ATOM   1345  CB  CYS A 258      47.933  49.196  42.268  1.00 23.24           C  
ATOM   1346  SG  CYS A 258      49.489  48.952  41.414  1.00 25.91           S  
ATOM   1347  N   GLN A 259      44.863  49.618  42.546  1.00 25.48           N  
ATOM   1348  CA  GLN A 259      43.679  49.763  43.375  1.00 25.71           C  
ATOM   1349  C   GLN A 259      42.638  48.716  42.970  1.00 25.63           C  
ATOM   1350  O   GLN A 259      41.965  48.132  43.825  1.00 25.85           O  
ATOM   1351  CB  GLN A 259      43.097  51.170  43.229  1.00 26.78           C  
ATOM   1352  CG  GLN A 259      41.937  51.466  44.185  1.00 30.43           C  
ATOM   1353  CD  GLN A 259      41.320  52.847  43.973  1.00 31.61           C  
ATOM   1354  OE1 GLN A 259      42.023  53.861  43.927  1.00 33.43           O  
ATOM   1355  NE2 GLN A 259      39.996  52.891  43.856  1.00 33.85           N  
ATOM   1356  N   LEU A 260      42.528  48.464  41.668  1.00 23.55           N  
ATOM   1357  CA  LEU A 260      41.572  47.492  41.155  1.00 22.53           C  
ATOM   1358  C   LEU A 260      41.896  46.077  41.619  1.00 22.77           C  
ATOM   1359  O   LEU A 260      41.032  45.379  42.135  1.00 24.17           O  
ATOM   1360  CB  LEU A 260      41.546  47.540  39.626  1.00 19.43           C  
ATOM   1361  CG  LEU A 260      40.686  46.500  38.916  1.00 19.82           C  
ATOM   1362  CD1 LEU A 260      39.215  46.664  39.316  1.00 19.93           C  
ATOM   1363  CD2 LEU A 260      40.863  46.650  37.413  1.00 19.52           C  
ATOM   1364  N   LEU A 261      43.140  45.656  41.429  1.00 24.25           N  
ATOM   1365  CA  LEU A 261      43.581  44.317  41.833  1.00 25.50           C  
ATOM   1366  C   LEU A 261      43.482  44.092  43.334  1.00 26.37           C  
ATOM   1367  O   LEU A 261      43.191  42.980  43.795  1.00 27.00           O  
ATOM   1368  CB  LEU A 261      45.030  44.095  41.400  1.00 24.84           C  
ATOM   1369  CG  LEU A 261      45.249  44.126  39.896  1.00 26.15           C  
ATOM   1370  CD1 LEU A 261      46.736  44.092  39.577  1.00 26.33           C  
ATOM   1371  CD2 LEU A 261      44.525  42.949  39.276  1.00 25.24           C  
ATOM   1372  N   GLU A 262      43.753  45.149  44.093  1.00 27.82           N  
ATOM   1373  CA  GLU A 262      43.706  45.101  45.548  1.00 29.51           C  
ATOM   1374  C   GLU A 262      42.270  44.958  46.040  1.00 29.24           C  
ATOM   1375  O   GLU A 262      42.020  44.358  47.094  1.00 28.19           O  
ATOM   1376  CB  GLU A 262      44.325  46.382  46.131  1.00 31.35           C  
ATOM   1377  CG  GLU A 262      45.859  46.436  46.081  1.00 35.53           C  
ATOM   1378  CD  GLU A 262      46.417  47.849  46.307  1.00 38.19           C  
ATOM   1379  OE1 GLU A 262      45.713  48.687  46.913  1.00 38.11           O  
ATOM   1380  OE2 GLU A 262      47.569  48.121  45.890  1.00 39.98           O  
ATOM   1381  N   SER A 263      41.326  45.506  45.278  1.00 26.75           N  
ATOM   1382  CA  SER A 263      39.923  45.431  45.672  1.00 26.34           C  
ATOM   1383  C   SER A 263      39.430  43.994  45.597  1.00 26.47           C  
ATOM   1384  O   SER A 263      38.467  43.647  46.267  1.00 27.96           O  
ATOM   1385  CB  SER A 263      39.050  46.312  44.774  1.00 24.72           C  
ATOM   1386  OG  SER A 263      38.739  45.653  43.560  1.00 23.40           O  
ATOM   1387  N   LYS A 264      40.087  43.177  44.774  1.00 26.54           N  
ATOM   1388  CA  LYS A 264      39.733  41.768  44.604  1.00 27.93           C  
ATOM   1389  C   LYS A 264      38.500  41.589  43.731  1.00 28.40           C  
ATOM   1390  O   LYS A 264      38.044  40.465  43.514  1.00 26.86           O  
ATOM   1391  CB  LYS A 264      39.504  41.099  45.972  1.00 29.70           C  
ATOM   1392  CG  LYS A 264      40.729  41.126  46.878  1.00 31.51           C  
ATOM   1393  CD  LYS A 264      41.880  40.333  46.272  1.00 34.71           C  
ATOM   1394  CE  LYS A 264      43.114  40.390  47.167  1.00 38.09           C  
ATOM   1395  NZ  LYS A 264      44.168  39.418  46.732  1.00 41.01           N  
ATOM   1396  N   ALA A 265      37.956  42.698  43.234  1.00 27.23           N  
ATOM   1397  CA  ALA A 265      36.782  42.630  42.373  1.00 28.11           C  
ATOM   1398  C   ALA A 265      37.097  41.750  41.167  1.00 28.38           C  
ATOM   1399  O   ALA A 265      38.099  41.953  40.476  1.00 29.21           O  
ATOM   1400  CB  ALA A 265      36.382  44.029  41.913  1.00 28.01           C  
ATOM   1401  N   PRO A 266      36.244  40.756  40.892  1.00 28.52           N  
ATOM   1402  CA  PRO A 266      36.503  39.882  39.746  1.00 28.65           C  
ATOM   1403  C   PRO A 266      36.282  40.598  38.417  1.00 26.79           C  
ATOM   1404  O   PRO A 266      35.445  41.494  38.324  1.00 28.07           O  
ATOM   1405  CB  PRO A 266      35.511  38.747  39.963  1.00 29.35           C  
ATOM   1406  CG  PRO A 266      34.333  39.467  40.523  1.00 30.80           C  
ATOM   1407  CD  PRO A 266      34.974  40.397  41.547  1.00 30.02           C  
ATOM   1408  N   PHE A 267      37.041  40.209  37.397  1.00 24.35           N  
ATOM   1409  CA  PHE A 267      36.897  40.796  36.068  1.00 23.52           C  
ATOM   1410  C   PHE A 267      37.815  40.088  35.083  1.00 23.51           C  
ATOM   1411  O   PHE A 267      38.933  39.712  35.423  1.00 22.56           O  
ATOM   1412  CB  PHE A 267      37.201  42.302  36.099  1.00 22.15           C  
ATOM   1413  CG  PHE A 267      38.656  42.632  36.222  1.00 22.79           C  
ATOM   1414  CD1 PHE A 267      39.456  42.740  35.084  1.00 20.12           C  
ATOM   1415  CD2 PHE A 267      39.230  42.831  37.478  1.00 20.50           C  
ATOM   1416  CE1 PHE A 267      40.819  43.046  35.188  1.00 23.81           C  
ATOM   1417  CE2 PHE A 267      40.587  43.137  37.606  1.00 22.74           C  
ATOM   1418  CZ  PHE A 267      41.393  43.246  36.451  1.00 23.08           C  
ATOM   1419  N   THR A 268      37.337  39.881  33.864  1.00 22.55           N  
ATOM   1420  CA  THR A 268      38.156  39.221  32.863  1.00 23.07           C  
ATOM   1421  C   THR A 268      38.456  40.174  31.721  1.00 22.54           C  
ATOM   1422  O   THR A 268      39.286  39.878  30.867  1.00 20.74           O  
ATOM   1423  CB  THR A 268      37.466  37.966  32.289  1.00 22.91           C  
ATOM   1424  OG1 THR A 268      36.251  38.346  31.633  1.00 24.11           O  
ATOM   1425  CG2 THR A 268      37.164  36.969  33.402  1.00 23.03           C  
ATOM   1426  N   GLY A 269      37.772  41.315  31.720  1.00 22.43           N  
ATOM   1427  CA  GLY A 269      37.962  42.308  30.673  1.00 21.65           C  
ATOM   1428  C   GLY A 269      38.066  43.696  31.263  1.00 21.44           C  
ATOM   1429  O   GLY A 269      37.257  44.075  32.112  1.00 24.21           O  
ATOM   1430  N   LEU A 270      39.053  44.460  30.805  1.00 21.47           N  
ATOM   1431  CA  LEU A 270      39.301  45.811  31.312  1.00 19.00           C  
ATOM   1432  C   LEU A 270      39.302  46.887  30.233  1.00 17.95           C  
ATOM   1433  O   LEU A 270      39.928  46.734  29.187  1.00 18.71           O  
ATOM   1434  CB  LEU A 270      40.655  45.849  32.038  1.00 16.57           C  
ATOM   1435  CG  LEU A 270      41.199  47.226  32.448  1.00 18.52           C  
ATOM   1436  CD1 LEU A 270      40.308  47.834  33.510  1.00 15.92           C  
ATOM   1437  CD2 LEU A 270      42.620  47.086  32.976  1.00 17.11           C  
ATOM   1438  N   PHE A 271      38.594  47.976  30.501  1.00 17.26           N  
ATOM   1439  CA  PHE A 271      38.546  49.099  29.580  1.00 16.22           C  
ATOM   1440  C   PHE A 271      39.249  50.297  30.210  1.00 16.34           C  
ATOM   1441  O   PHE A 271      38.887  50.735  31.305  1.00 16.88           O  
ATOM   1442  CB  PHE A 271      37.102  49.467  29.256  1.00 14.48           C  
ATOM   1443  CG  PHE A 271      36.960  50.749  28.492  1.00 14.96           C  
ATOM   1444  CD1 PHE A 271      37.815  51.047  27.427  1.00 14.96           C  
ATOM   1445  CD2 PHE A 271      35.923  51.633  28.790  1.00 15.63           C  
ATOM   1446  CE1 PHE A 271      37.635  52.207  26.662  1.00 16.07           C  
ATOM   1447  CE2 PHE A 271      35.725  52.804  28.034  1.00 17.30           C  
ATOM   1448  CZ  PHE A 271      36.580  53.093  26.967  1.00 16.24           C  
ATOM   1449  N   CYS A 272      40.258  50.808  29.516  1.00 17.87           N  
ATOM   1450  CA  CYS A 272      41.016  51.966  29.976  1.00 18.60           C  
ATOM   1451  C   CYS A 272      40.689  53.177  29.110  1.00 18.91           C  
ATOM   1452  O   CYS A 272      40.804  53.127  27.887  1.00 19.10           O  
ATOM   1453  CB  CYS A 272      42.511  51.668  29.917  1.00 20.01           C  
ATOM   1454  SG  CYS A 272      42.994  50.386  31.072  1.00 25.12           S  
ATOM   1455  N   ALA A 273      40.301  54.266  29.764  1.00 18.32           N  
ATOM   1456  CA  ALA A 273      39.909  55.506  29.100  1.00 19.29           C  
ATOM   1457  C   ALA A 273      40.886  56.051  28.057  1.00 19.57           C  
ATOM   1458  O   ALA A 273      40.493  56.848  27.202  1.00 18.47           O  
ATOM   1459  CB  ALA A 273      39.611  56.575  30.150  1.00 20.21           C  
ATOM   1460  N   ASN A 274      42.152  55.650  28.140  1.00 18.34           N  
ATOM   1461  CA  ASN A 274      43.145  56.074  27.154  1.00 18.08           C  
ATOM   1462  C   ASN A 274      44.283  55.063  27.119  1.00 19.07           C  
ATOM   1463  O   ASN A 274      44.493  54.326  28.085  1.00 17.59           O  
ATOM   1464  CB  ASN A 274      43.651  57.505  27.437  1.00 17.84           C  
ATOM   1465  CG  ASN A 274      44.705  57.576  28.534  1.00 18.86           C  
ATOM   1466  OD1 ASN A 274      44.848  56.668  29.355  1.00 19.70           O  
ATOM   1467  ND2 ASN A 274      45.439  58.686  28.559  1.00 18.72           N  
ATOM   1468  N   ASP A 275      44.985  55.011  25.992  1.00 19.14           N  
ATOM   1469  CA  ASP A 275      46.087  54.070  25.811  1.00 21.85           C  
ATOM   1470  C   ASP A 275      47.180  54.198  26.874  1.00 21.08           C  
ATOM   1471  O   ASP A 275      47.774  53.196  27.275  1.00 22.59           O  
ATOM   1472  CB  ASP A 275      46.707  54.231  24.414  1.00 21.95           C  
ATOM   1473  CG  ASP A 275      45.776  53.758  23.300  1.00 24.81           C  
ATOM   1474  OD1 ASP A 275      44.769  53.081  23.597  1.00 25.76           O  
ATOM   1475  OD2 ASP A 275      46.051  54.050  22.121  1.00 26.30           O  
ATOM   1476  N   THR A 276      47.442  55.423  27.319  1.00 20.21           N  
ATOM   1477  CA  THR A 276      48.469  55.664  28.326  1.00 19.44           C  
ATOM   1478  C   THR A 276      48.203  54.860  29.589  1.00 18.07           C  
ATOM   1479  O   THR A 276      49.066  54.118  30.050  1.00 18.42           O  
ATOM   1480  CB  THR A 276      48.553  57.160  28.693  1.00 20.54           C  
ATOM   1481  OG1 THR A 276      49.028  57.893  27.558  1.00 24.11           O  
ATOM   1482  CG2 THR A 276      49.519  57.389  29.860  1.00 20.06           C  
HETATM 1483  N   MSE A 277      47.006  54.995  30.146  1.00 17.03           N  
HETATM 1484  CA  MSE A 277      46.689  54.264  31.360  1.00 16.14           C  
HETATM 1485  C   MSE A 277      46.644  52.756  31.065  1.00 17.21           C  
HETATM 1486  O   MSE A 277      47.011  51.939  31.913  1.00 16.42           O  
HETATM 1487  CB  MSE A 277      45.355  54.741  31.951  1.00 16.56           C  
HETATM 1488  CG  MSE A 277      45.326  56.215  32.391  1.00 13.64           C  
HETATM 1489 SE   MSE A 277      43.853  56.640  33.379  1.00 10.06          SE  
HETATM 1490  CE  MSE A 277      42.560  56.469  32.146  1.00 13.09           C  
ATOM   1491  N   ALA A 278      46.208  52.393  29.861  1.00 16.98           N  
ATOM   1492  CA  ALA A 278      46.132  50.987  29.468  1.00 16.56           C  
ATOM   1493  C   ALA A 278      47.519  50.359  29.486  1.00 16.43           C  
ATOM   1494  O   ALA A 278      47.694  49.233  29.936  1.00 15.42           O  
ATOM   1495  CB  ALA A 278      45.514  50.852  28.072  1.00 15.15           C  
ATOM   1496  N   VAL A 279      48.505  51.088  28.982  1.00 16.20           N  
ATOM   1497  CA  VAL A 279      49.867  50.578  28.957  1.00 16.50           C  
ATOM   1498  C   VAL A 279      50.362  50.340  30.374  1.00 17.68           C  
ATOM   1499  O   VAL A 279      51.029  49.344  30.630  1.00 20.97           O  
ATOM   1500  CB  VAL A 279      50.811  51.542  28.233  1.00 15.90           C  
ATOM   1501  CG1 VAL A 279      52.262  51.105  28.436  1.00 19.39           C  
ATOM   1502  CG2 VAL A 279      50.468  51.564  26.759  1.00 15.81           C  
ATOM   1503  N   SER A 280      50.039  51.247  31.292  1.00 16.30           N  
ATOM   1504  CA  SER A 280      50.440  51.075  32.690  1.00 18.99           C  
ATOM   1505  C   SER A 280      49.758  49.832  33.277  1.00 18.48           C  
ATOM   1506  O   SER A 280      50.323  49.148  34.122  1.00 16.32           O  
ATOM   1507  CB  SER A 280      50.061  52.306  33.529  1.00 17.93           C  
ATOM   1508  OG  SER A 280      50.882  53.422  33.215  1.00 21.32           O  
ATOM   1509  N   ALA A 281      48.537  49.545  32.827  1.00 18.34           N  
ATOM   1510  CA  ALA A 281      47.818  48.371  33.318  1.00 17.60           C  
ATOM   1511  C   ALA A 281      48.561  47.114  32.877  1.00 18.12           C  
ATOM   1512  O   ALA A 281      48.702  46.154  33.643  1.00 18.51           O  
ATOM   1513  CB  ALA A 281      46.397  48.357  32.783  1.00 19.93           C  
ATOM   1514  N   LEU A 282      49.035  47.131  31.635  1.00 16.70           N  
ATOM   1515  CA  LEU A 282      49.785  46.020  31.080  1.00 16.80           C  
ATOM   1516  C   LEU A 282      51.083  45.871  31.857  1.00 18.73           C  
ATOM   1517  O   LEU A 282      51.619  44.768  31.976  1.00 18.96           O  
ATOM   1518  CB  LEU A 282      50.108  46.270  29.605  1.00 17.34           C  
ATOM   1519  CG  LEU A 282      48.915  46.307  28.641  1.00 19.14           C  
ATOM   1520  CD1 LEU A 282      49.419  46.497  27.212  1.00 21.49           C  
ATOM   1521  CD2 LEU A 282      48.129  45.022  28.757  1.00 19.13           C  
ATOM   1522  N   ALA A 283      51.584  46.991  32.379  1.00 17.84           N  
ATOM   1523  CA  ALA A 283      52.829  46.992  33.136  1.00 19.81           C  
ATOM   1524  C   ALA A 283      52.646  46.253  34.443  1.00 19.80           C  
ATOM   1525  O   ALA A 283      53.470  45.425  34.806  1.00 19.81           O  
ATOM   1526  CB  ALA A 283      53.291  48.414  33.406  1.00 18.95           C  
ATOM   1527  N   ARG A 284      51.559  46.559  35.145  1.00 19.98           N  
ATOM   1528  CA  ARG A 284      51.255  45.929  36.424  1.00 19.99           C  
ATOM   1529  C   ARG A 284      50.971  44.447  36.242  1.00 19.79           C  
ATOM   1530  O   ARG A 284      51.534  43.617  36.942  1.00 21.06           O  
ATOM   1531  CB  ARG A 284      50.048  46.615  37.080  1.00 21.20           C  
ATOM   1532  CG  ARG A 284      49.724  46.101  38.477  1.00 21.54           C  
ATOM   1533  CD  ARG A 284      50.989  46.017  39.322  1.00 23.32           C  
ATOM   1534  NE  ARG A 284      50.712  45.644  40.704  1.00 24.69           N  
ATOM   1535  CZ  ARG A 284      51.643  45.280  41.583  1.00 25.97           C  
ATOM   1536  NH1 ARG A 284      52.919  45.234  41.228  1.00 24.84           N  
ATOM   1537  NH2 ARG A 284      51.297  44.951  42.820  1.00 23.89           N  
ATOM   1538  N   PHE A 285      50.099  44.120  35.296  1.00 19.05           N  
ATOM   1539  CA  PHE A 285      49.763  42.727  35.031  1.00 19.40           C  
ATOM   1540  C   PHE A 285      51.010  41.889  34.766  1.00 20.15           C  
ATOM   1541  O   PHE A 285      51.094  40.749  35.202  1.00 18.97           O  
ATOM   1542  CB  PHE A 285      48.825  42.626  33.825  1.00 18.51           C  
ATOM   1543  CG  PHE A 285      47.448  43.176  34.078  1.00 19.67           C  
ATOM   1544  CD1 PHE A 285      46.564  43.372  33.017  1.00 21.46           C  
ATOM   1545  CD2 PHE A 285      47.031  43.497  35.375  1.00 20.79           C  
ATOM   1546  CE1 PHE A 285      45.281  43.876  33.229  1.00 19.50           C  
ATOM   1547  CE2 PHE A 285      45.738  44.007  35.608  1.00 22.75           C  
ATOM   1548  CZ  PHE A 285      44.863  44.197  34.521  1.00 19.79           C  
ATOM   1549  N   GLN A 286      51.971  42.455  34.041  1.00 20.02           N  
ATOM   1550  CA  GLN A 286      53.197  41.733  33.724  1.00 22.73           C  
ATOM   1551  C   GLN A 286      54.019  41.510  34.996  1.00 22.83           C  
ATOM   1552  O   GLN A 286      54.619  40.447  35.177  1.00 22.90           O  
ATOM   1553  CB  GLN A 286      54.011  42.508  32.679  1.00 23.63           C  
ATOM   1554  CG  GLN A 286      55.150  41.727  32.000  1.00 25.83           C  
ATOM   1555  CD  GLN A 286      56.398  41.598  32.864  1.00 26.00           C  
ATOM   1556  OE1 GLN A 286      56.663  42.444  33.717  1.00 25.19           O  
ATOM   1557  NE2 GLN A 286      57.180  40.546  32.627  1.00 26.56           N  
ATOM   1558  N   GLN A 287      54.025  42.501  35.882  1.00 22.70           N  
ATOM   1559  CA  GLN A 287      54.763  42.389  37.137  1.00 25.04           C  
ATOM   1560  C   GLN A 287      54.194  41.284  38.035  1.00 25.63           C  
ATOM   1561  O   GLN A 287      54.934  40.674  38.807  1.00 24.71           O  
ATOM   1562  CB  GLN A 287      54.732  43.720  37.907  1.00 26.04           C  
ATOM   1563  CG  GLN A 287      55.366  44.894  37.168  1.00 25.74           C  
ATOM   1564  CD  GLN A 287      55.266  46.208  37.931  1.00 26.69           C  
ATOM   1565  OE1 GLN A 287      54.563  46.314  38.939  1.00 24.54           O  
ATOM   1566  NE2 GLN A 287      55.958  47.228  37.435  1.00 29.80           N  
ATOM   1567  N   LEU A 288      52.891  41.018  37.930  1.00 24.46           N  
ATOM   1568  CA  LEU A 288      52.255  40.005  38.774  1.00 24.85           C  
ATOM   1569  C   LEU A 288      51.986  38.659  38.105  1.00 25.91           C  
ATOM   1570  O   LEU A 288      51.389  37.768  38.706  1.00 26.22           O  
ATOM   1571  CB  LEU A 288      50.948  40.562  39.345  1.00 25.19           C  
ATOM   1572  CG  LEU A 288      51.094  41.827  40.195  1.00 24.14           C  
ATOM   1573  CD1 LEU A 288      49.716  42.430  40.485  1.00 25.56           C  
ATOM   1574  CD2 LEU A 288      51.821  41.480  41.481  1.00 24.65           C  
ATOM   1575  N   GLY A 289      52.419  38.509  36.861  1.00 25.95           N  
ATOM   1576  CA  GLY A 289      52.206  37.249  36.176  1.00 27.30           C  
ATOM   1577  C   GLY A 289      50.797  37.067  35.644  1.00 27.77           C  
ATOM   1578  O   GLY A 289      50.394  35.942  35.338  1.00 27.68           O  
ATOM   1579  N   ILE A 290      50.044  38.160  35.544  1.00 26.19           N  
ATOM   1580  CA  ILE A 290      48.685  38.112  35.019  1.00 25.42           C  
ATOM   1581  C   ILE A 290      48.806  38.299  33.512  1.00 25.20           C  
ATOM   1582  O   ILE A 290      49.119  39.394  33.038  1.00 24.37           O  
ATOM   1583  CB  ILE A 290      47.822  39.244  35.601  1.00 25.34           C  
ATOM   1584  CG1 ILE A 290      47.673  39.041  37.112  1.00 23.97           C  
ATOM   1585  CG2 ILE A 290      46.469  39.276  34.899  1.00 24.46           C  
ATOM   1586  CD1 ILE A 290      47.168  40.256  37.850  1.00 26.04           C  
ATOM   1587  N   SER A 291      48.560  37.230  32.764  1.00 24.82           N  
ATOM   1588  CA  SER A 291      48.684  37.269  31.321  1.00 25.10           C  
ATOM   1589  C   SER A 291      47.596  38.033  30.579  1.00 25.29           C  
ATOM   1590  O   SER A 291      46.422  38.051  30.966  1.00 24.17           O  
ATOM   1591  CB  SER A 291      48.791  35.840  30.771  1.00 27.95           C  
ATOM   1592  OG  SER A 291      47.696  35.048  31.199  1.00 32.23           O  
ATOM   1593  N   VAL A 292      48.024  38.683  29.505  1.00 24.76           N  
ATOM   1594  CA  VAL A 292      47.142  39.454  28.653  1.00 23.72           C  
ATOM   1595  C   VAL A 292      47.466  39.007  27.237  1.00 24.79           C  
ATOM   1596  O   VAL A 292      48.615  39.083  26.813  1.00 25.89           O  
ATOM   1597  CB  VAL A 292      47.421  40.965  28.799  1.00 22.64           C  
ATOM   1598  CG1 VAL A 292      46.535  41.757  27.849  1.00 19.31           C  
ATOM   1599  CG2 VAL A 292      47.182  41.390  30.229  1.00 20.71           C  
ATOM   1600  N   PRO A 293      46.464  38.529  26.485  1.00 25.76           N  
ATOM   1601  CA  PRO A 293      45.046  38.375  26.820  1.00 26.95           C  
ATOM   1602  C   PRO A 293      44.717  37.106  27.598  1.00 29.03           C  
ATOM   1603  O   PRO A 293      43.545  36.825  27.863  1.00 28.83           O  
ATOM   1604  CB  PRO A 293      44.378  38.365  25.453  1.00 27.28           C  
ATOM   1605  CG  PRO A 293      45.375  37.563  24.644  1.00 26.00           C  
ATOM   1606  CD  PRO A 293      46.712  38.154  25.081  1.00 24.93           C  
ATOM   1607  N   GLY A 294      45.736  36.332  27.947  1.00 29.53           N  
ATOM   1608  CA  GLY A 294      45.503  35.099  28.683  1.00 32.27           C  
ATOM   1609  C   GLY A 294      44.425  35.169  29.754  1.00 32.07           C  
ATOM   1610  O   GLY A 294      43.330  34.645  29.571  1.00 33.90           O  
ATOM   1611  N   ASP A 295      44.736  35.818  30.869  1.00 31.23           N  
ATOM   1612  CA  ASP A 295      43.804  35.943  31.984  1.00 29.99           C  
ATOM   1613  C   ASP A 295      42.935  37.193  31.900  1.00 28.81           C  
ATOM   1614  O   ASP A 295      41.800  37.194  32.368  1.00 28.01           O  
ATOM   1615  CB  ASP A 295      44.574  35.975  33.302  1.00 31.03           C  
ATOM   1616  CG  ASP A 295      45.553  34.825  33.435  1.00 33.28           C  
ATOM   1617  OD1 ASP A 295      45.161  33.669  33.132  1.00 32.79           O  
ATOM   1618  OD2 ASP A 295      46.712  35.076  33.848  1.00 31.65           O  
ATOM   1619  N   VAL A 296      43.469  38.255  31.312  1.00 26.49           N  
ATOM   1620  CA  VAL A 296      42.727  39.504  31.199  1.00 23.57           C  
ATOM   1621  C   VAL A 296      42.862  40.137  29.829  1.00 22.50           C  
ATOM   1622  O   VAL A 296      43.963  40.247  29.297  1.00 22.79           O  
ATOM   1623  CB  VAL A 296      43.209  40.537  32.240  1.00 23.10           C  
ATOM   1624  CG1 VAL A 296      42.458  41.846  32.056  1.00 21.97           C  
ATOM   1625  CG2 VAL A 296      42.981  40.008  33.640  1.00 22.47           C  
ATOM   1626  N   SER A 297      41.732  40.546  29.261  1.00 20.30           N  
ATOM   1627  CA  SER A 297      41.716  41.200  27.961  1.00 19.83           C  
ATOM   1628  C   SER A 297      41.651  42.685  28.256  1.00 17.45           C  
ATOM   1629  O   SER A 297      40.844  43.123  29.061  1.00 17.93           O  
ATOM   1630  CB  SER A 297      40.496  40.762  27.153  1.00 22.52           C  
ATOM   1631  OG  SER A 297      40.676  39.453  26.645  1.00 26.71           O  
ATOM   1632  N   VAL A 298      42.514  43.452  27.605  1.00 18.03           N  
ATOM   1633  CA  VAL A 298      42.590  44.888  27.839  1.00 17.00           C  
ATOM   1634  C   VAL A 298      42.384  45.690  26.566  1.00 16.77           C  
ATOM   1635  O   VAL A 298      43.004  45.409  25.551  1.00 17.14           O  
ATOM   1636  CB  VAL A 298      43.977  45.270  28.426  1.00 15.35           C  
ATOM   1637  CG1 VAL A 298      44.042  46.769  28.699  1.00 16.85           C  
ATOM   1638  CG2 VAL A 298      44.246  44.476  29.696  1.00 13.70           C  
ATOM   1639  N   ILE A 299      41.509  46.686  26.615  1.00 17.12           N  
ATOM   1640  CA  ILE A 299      41.293  47.520  25.441  1.00 17.41           C  
ATOM   1641  C   ILE A 299      41.506  48.985  25.801  1.00 15.95           C  
ATOM   1642  O   ILE A 299      40.993  49.462  26.808  1.00 17.26           O  
ATOM   1643  CB  ILE A 299      39.887  47.346  24.855  1.00 15.81           C  
ATOM   1644  CG1 ILE A 299      39.741  48.240  23.626  1.00 18.49           C  
ATOM   1645  CG2 ILE A 299      38.834  47.685  25.891  1.00 15.90           C  
ATOM   1646  CD1 ILE A 299      38.519  47.913  22.767  1.00 19.68           C  
ATOM   1647  N   GLY A 300      42.274  49.693  24.979  1.00 14.53           N  
ATOM   1648  CA  GLY A 300      42.545  51.091  25.252  1.00 15.63           C  
ATOM   1649  C   GLY A 300      41.670  52.051  24.469  1.00 18.51           C  
ATOM   1650  O   GLY A 300      40.690  51.646  23.848  1.00 18.25           O  
ATOM   1651  N   TYR A 301      42.036  53.328  24.476  1.00 18.72           N  
ATOM   1652  CA  TYR A 301      41.250  54.339  23.782  1.00 20.29           C  
ATOM   1653  C   TYR A 301      42.191  55.416  23.247  1.00 21.43           C  
ATOM   1654  O   TYR A 301      43.078  55.872  23.966  1.00 21.26           O  
ATOM   1655  CB  TYR A 301      40.249  54.949  24.759  1.00 17.15           C  
ATOM   1656  CG  TYR A 301      39.079  55.647  24.121  1.00 19.52           C  
ATOM   1657  CD1 TYR A 301      37.860  54.993  23.952  1.00 19.69           C  
ATOM   1658  CD2 TYR A 301      39.173  56.979  23.730  1.00 19.55           C  
ATOM   1659  CE1 TYR A 301      36.751  55.657  23.413  1.00 22.34           C  
ATOM   1660  CE2 TYR A 301      38.079  57.656  23.187  1.00 21.27           C  
ATOM   1661  CZ  TYR A 301      36.867  56.992  23.033  1.00 23.33           C  
ATOM   1662  OH  TYR A 301      35.774  57.674  22.525  1.00 23.67           O  
ATOM   1663  N   ASP A 302      41.973  55.802  21.990  1.00 22.89           N  
ATOM   1664  CA  ASP A 302      42.751  56.811  21.259  1.00 23.38           C  
ATOM   1665  C   ASP A 302      43.423  56.162  20.054  1.00 24.28           C  
ATOM   1666  O   ASP A 302      43.306  56.646  18.930  1.00 23.92           O  
ATOM   1667  CB  ASP A 302      43.863  57.462  22.115  1.00 23.78           C  
ATOM   1668  CG  ASP A 302      43.332  58.420  23.178  1.00 26.03           C  
ATOM   1669  OD1 ASP A 302      42.220  58.957  23.020  1.00 25.00           O  
ATOM   1670  OD2 ASP A 302      44.049  58.663  24.179  1.00 28.21           O  
ATOM   1671  N   ASP A 303      44.109  55.053  20.314  1.00 25.07           N  
ATOM   1672  CA  ASP A 303      44.880  54.301  19.322  1.00 28.68           C  
ATOM   1673  C   ASP A 303      46.098  55.152  19.013  1.00 32.32           C  
ATOM   1674  O   ASP A 303      46.453  55.400  17.854  1.00 30.69           O  
ATOM   1675  CB  ASP A 303      44.088  54.011  18.041  1.00 27.62           C  
ATOM   1676  CG  ASP A 303      44.831  53.056  17.105  1.00 28.73           C  
ATOM   1677  OD1 ASP A 303      45.729  52.330  17.590  1.00 27.27           O  
ATOM   1678  OD2 ASP A 303      44.514  53.017  15.896  1.00 26.79           O  
ATOM   1679  N   ASP A 304      46.717  55.617  20.094  1.00 35.89           N  
ATOM   1680  CA  ASP A 304      47.907  56.437  20.012  1.00 40.00           C  
ATOM   1681  C   ASP A 304      48.975  55.510  19.443  1.00 41.03           C  
ATOM   1682  O   ASP A 304      48.885  54.286  19.594  1.00 40.73           O  
ATOM   1683  CB  ASP A 304      48.232  56.973  21.415  1.00 41.73           C  
ATOM   1684  CG  ASP A 304      47.436  58.246  21.745  1.00 44.51           C  
ATOM   1685  OD1 ASP A 304      47.190  58.524  22.943  1.00 46.14           O  
ATOM   1686  OD2 ASP A 304      47.067  58.986  20.797  1.00 45.30           O  
ATOM   1687  N   TYR A 305      49.978  56.051  18.771  1.00 41.49           N  
ATOM   1688  CA  TYR A 305      50.933  55.137  18.182  1.00 43.40           C  
ATOM   1689  C   TYR A 305      51.983  54.497  19.071  1.00 42.09           C  
ATOM   1690  O   TYR A 305      53.023  54.036  18.611  1.00 42.18           O  
ATOM   1691  CB  TYR A 305      51.504  55.757  16.906  1.00 46.46           C  
ATOM   1692  CG  TYR A 305      50.449  55.734  15.808  1.00 49.86           C  
ATOM   1693  CD1 TYR A 305      50.412  56.715  14.809  1.00 50.90           C  
ATOM   1694  CD2 TYR A 305      49.478  54.712  15.769  1.00 50.82           C  
ATOM   1695  CE1 TYR A 305      49.435  56.680  13.792  1.00 51.63           C  
ATOM   1696  CE2 TYR A 305      48.505  54.668  14.759  1.00 52.37           C  
ATOM   1697  CZ  TYR A 305      48.491  55.653  13.775  1.00 52.64           C  
ATOM   1698  OH  TYR A 305      47.545  55.587  12.761  1.00 53.46           O  
ATOM   1699  N   SER A 306      51.665  54.427  20.356  1.00 41.50           N  
ATOM   1700  CA  SER A 306      52.523  53.756  21.320  1.00 40.60           C  
ATOM   1701  C   SER A 306      51.861  52.388  21.544  1.00 39.05           C  
ATOM   1702  O   SER A 306      52.458  51.475  22.129  1.00 38.80           O  
ATOM   1703  CB  SER A 306      52.560  54.535  22.640  1.00 42.15           C  
ATOM   1704  OG  SER A 306      53.286  53.822  23.641  1.00 43.44           O  
ATOM   1705  N   ALA A 307      50.626  52.253  21.055  1.00 36.23           N  
ATOM   1706  CA  ALA A 307      49.845  51.023  21.214  1.00 32.54           C  
ATOM   1707  C   ALA A 307      50.341  49.827  20.416  1.00 31.03           C  
ATOM   1708  O   ALA A 307      50.421  48.713  20.944  1.00 29.92           O  
ATOM   1709  CB  ALA A 307      48.373  51.296  20.878  1.00 33.06           C  
ATOM   1710  N   ALA A 308      50.670  50.045  19.145  1.00 29.32           N  
ATOM   1711  CA  ALA A 308      51.145  48.956  18.299  1.00 27.52           C  
ATOM   1712  C   ALA A 308      52.392  48.307  18.870  1.00 26.99           C  
ATOM   1713  O   ALA A 308      52.668  47.140  18.608  1.00 25.40           O  
ATOM   1714  CB  ALA A 308      51.429  49.465  16.884  1.00 29.76           C  
ATOM   1715  N   TYR A 309      53.141  49.061  19.665  1.00 25.97           N  
ATOM   1716  CA  TYR A 309      54.370  48.539  20.240  1.00 24.59           C  
ATOM   1717  C   TYR A 309      54.292  48.221  21.723  1.00 23.80           C  
ATOM   1718  O   TYR A 309      55.317  48.107  22.397  1.00 21.56           O  
ATOM   1719  CB  TYR A 309      55.511  49.509  19.960  1.00 25.45           C  
ATOM   1720  CG  TYR A 309      55.647  49.753  18.486  1.00 26.38           C  
ATOM   1721  CD1 TYR A 309      55.121  50.904  17.894  1.00 26.42           C  
ATOM   1722  CD2 TYR A 309      56.246  48.800  17.664  1.00 26.81           C  
ATOM   1723  CE1 TYR A 309      55.194  51.096  16.516  1.00 26.94           C  
ATOM   1724  CE2 TYR A 309      56.320  48.981  16.295  1.00 27.62           C  
ATOM   1725  CZ  TYR A 309      55.798  50.129  15.727  1.00 27.17           C  
ATOM   1726  OH  TYR A 309      55.919  50.310  14.373  1.00 30.64           O  
ATOM   1727  N   ALA A 310      53.073  48.083  22.227  1.00 22.30           N  
ATOM   1728  CA  ALA A 310      52.878  47.727  23.617  1.00 20.43           C  
ATOM   1729  C   ALA A 310      53.125  46.225  23.676  1.00 20.87           C  
ATOM   1730  O   ALA A 310      53.156  45.550  22.642  1.00 20.86           O  
ATOM   1731  CB  ALA A 310      51.448  48.043  24.055  1.00 19.05           C  
ATOM   1732  N   ALA A 311      53.314  45.698  24.878  1.00 20.11           N  
ATOM   1733  CA  ALA A 311      53.543  44.268  25.030  1.00 21.03           C  
ATOM   1734  C   ALA A 311      52.482  43.703  25.957  1.00 20.40           C  
ATOM   1735  O   ALA A 311      52.562  43.868  27.174  1.00 21.07           O  
ATOM   1736  CB  ALA A 311      54.928  44.013  25.608  1.00 21.60           C  
ATOM   1737  N   PRO A 312      51.477  43.015  25.395  1.00 20.35           N  
ATOM   1738  CA  PRO A 312      51.261  42.726  23.969  1.00 19.09           C  
ATOM   1739  C   PRO A 312      50.703  43.921  23.198  1.00 18.34           C  
ATOM   1740  O   PRO A 312      50.290  44.912  23.803  1.00 18.08           O  
ATOM   1741  CB  PRO A 312      50.271  41.575  24.016  1.00 19.97           C  
ATOM   1742  CG  PRO A 312      49.404  41.969  25.185  1.00 21.23           C  
ATOM   1743  CD  PRO A 312      50.445  42.357  26.215  1.00 20.28           C  
ATOM   1744  N   ALA A 313      50.682  43.821  21.871  1.00 16.50           N  
ATOM   1745  CA  ALA A 313      50.163  44.901  21.033  1.00 17.97           C  
ATOM   1746  C   ALA A 313      48.766  45.262  21.537  1.00 17.77           C  
ATOM   1747  O   ALA A 313      47.891  44.405  21.619  1.00 15.81           O  
ATOM   1748  CB  ALA A 313      50.113  44.463  19.578  1.00 18.73           C  
ATOM   1749  N   LEU A 314      48.572  46.537  21.870  1.00 17.83           N  
ATOM   1750  CA  LEU A 314      47.310  47.007  22.439  1.00 18.55           C  
ATOM   1751  C   LEU A 314      46.149  47.259  21.487  1.00 20.23           C  
ATOM   1752  O   LEU A 314      46.252  48.079  20.565  1.00 19.05           O  
ATOM   1753  CB  LEU A 314      47.556  48.284  23.248  1.00 19.61           C  
ATOM   1754  CG  LEU A 314      46.354  48.869  23.991  1.00 19.32           C  
ATOM   1755  CD1 LEU A 314      45.943  47.930  25.126  1.00 19.60           C  
ATOM   1756  CD2 LEU A 314      46.713  50.245  24.532  1.00 18.45           C  
ATOM   1757  N   THR A 315      45.044  46.552  21.729  1.00 18.65           N  
ATOM   1758  CA  THR A 315      43.828  46.722  20.942  1.00 18.25           C  
ATOM   1759  C   THR A 315      43.240  48.019  21.479  1.00 18.38           C  
ATOM   1760  O   THR A 315      43.109  48.199  22.690  1.00 18.32           O  
ATOM   1761  CB  THR A 315      42.849  45.545  21.158  1.00 19.13           C  
ATOM   1762  OG1 THR A 315      43.392  44.363  20.544  1.00 16.47           O  
ATOM   1763  CG2 THR A 315      41.481  45.856  20.547  1.00 16.83           C  
ATOM   1764  N   SER A 316      42.899  48.931  20.580  1.00 17.86           N  
ATOM   1765  CA  SER A 316      42.402  50.227  21.005  1.00 18.09           C  
ATOM   1766  C   SER A 316      41.337  50.818  20.096  1.00 18.32           C  
ATOM   1767  O   SER A 316      41.296  50.529  18.906  1.00 20.14           O  
ATOM   1768  CB  SER A 316      43.589  51.197  21.095  1.00 18.16           C  
ATOM   1769  OG  SER A 316      43.207  52.494  21.522  1.00 20.63           O  
ATOM   1770  N   VAL A 317      40.473  51.642  20.679  1.00 18.14           N  
ATOM   1771  CA  VAL A 317      39.433  52.324  19.929  1.00 18.56           C  
ATOM   1772  C   VAL A 317      40.154  53.454  19.182  1.00 19.46           C  
ATOM   1773  O   VAL A 317      40.843  54.282  19.789  1.00 17.75           O  
ATOM   1774  CB  VAL A 317      38.365  52.918  20.874  1.00 17.60           C  
ATOM   1775  CG1 VAL A 317      37.403  53.790  20.095  1.00 17.49           C  
ATOM   1776  CG2 VAL A 317      37.607  51.791  21.575  1.00 17.26           C  
ATOM   1777  N   HIS A 318      40.010  53.467  17.861  1.00 19.30           N  
ATOM   1778  CA  HIS A 318      40.665  54.473  17.042  1.00 21.17           C  
ATOM   1779  C   HIS A 318      39.885  55.780  16.904  1.00 22.35           C  
ATOM   1780  O   HIS A 318      38.799  55.805  16.330  1.00 24.39           O  
ATOM   1781  CB  HIS A 318      40.932  53.928  15.646  1.00 23.12           C  
ATOM   1782  CG  HIS A 318      41.600  54.918  14.749  1.00 25.84           C  
ATOM   1783  ND1 HIS A 318      42.952  55.167  14.804  1.00 27.73           N  
ATOM   1784  CD2 HIS A 318      41.093  55.768  13.827  1.00 26.91           C  
ATOM   1785  CE1 HIS A 318      43.253  56.129  13.948  1.00 28.07           C  
ATOM   1786  NE2 HIS A 318      42.143  56.512  13.343  1.00 26.35           N  
ATOM   1787  N   ILE A 319      40.463  56.862  17.414  1.00 22.35           N  
ATOM   1788  CA  ILE A 319      39.858  58.195  17.363  1.00 23.10           C  
ATOM   1789  C   ILE A 319      40.565  59.008  16.273  1.00 23.16           C  
ATOM   1790  O   ILE A 319      41.793  59.099  16.267  1.00 23.35           O  
ATOM   1791  CB  ILE A 319      40.031  58.927  18.716  1.00 23.78           C  
ATOM   1792  CG1 ILE A 319      39.271  58.180  19.817  1.00 23.41           C  
ATOM   1793  CG2 ILE A 319      39.543  60.362  18.601  1.00 23.81           C  
ATOM   1794  CD1 ILE A 319      37.759  58.073  19.563  1.00 26.29           C  
ATOM   1795  N   PRO A 320      39.799  59.628  15.353  1.00 22.36           N  
ATOM   1796  CA  PRO A 320      40.375  60.423  14.259  1.00 23.40           C  
ATOM   1797  C   PRO A 320      40.889  61.778  14.726  1.00 22.48           C  
ATOM   1798  O   PRO A 320      40.379  62.817  14.327  1.00 21.56           O  
ATOM   1799  CB  PRO A 320      39.206  60.550  13.290  1.00 22.89           C  
ATOM   1800  CG  PRO A 320      38.068  60.765  14.229  1.00 23.62           C  
ATOM   1801  CD  PRO A 320      38.331  59.750  15.355  1.00 23.03           C  
ATOM   1802  N   THR A 321      41.921  61.748  15.555  1.00 23.21           N  
ATOM   1803  CA  THR A 321      42.506  62.959  16.109  1.00 23.09           C  
ATOM   1804  C   THR A 321      43.233  63.832  15.095  1.00 22.20           C  
ATOM   1805  O   THR A 321      43.103  65.054  15.127  1.00 24.06           O  
ATOM   1806  CB  THR A 321      43.464  62.598  17.257  1.00 23.44           C  
ATOM   1807  OG1 THR A 321      42.699  62.035  18.331  1.00 23.86           O  
ATOM   1808  CG2 THR A 321      44.217  63.829  17.752  1.00 22.45           C  
ATOM   1809  N   ALA A 322      43.998  63.216  14.204  1.00 21.71           N  
ATOM   1810  CA  ALA A 322      44.726  63.979  13.193  1.00 22.75           C  
ATOM   1811  C   ALA A 322      43.758  64.712  12.264  1.00 22.77           C  
ATOM   1812  O   ALA A 322      43.962  65.886  11.952  1.00 22.16           O  
ATOM   1813  CB  ALA A 322      45.629  63.061  12.388  1.00 22.53           C  
ATOM   1814  N   GLU A 323      42.702  64.022  11.836  1.00 23.02           N  
ATOM   1815  CA  GLU A 323      41.712  64.610  10.934  1.00 24.07           C  
ATOM   1816  C   GLU A 323      40.931  65.763  11.555  1.00 22.73           C  
ATOM   1817  O   GLU A 323      40.747  66.799  10.925  1.00 20.63           O  
ATOM   1818  CB  GLU A 323      40.719  63.547  10.443  1.00 26.54           C  
ATOM   1819  CG  GLU A 323      41.333  62.436   9.602  1.00 31.70           C  
ATOM   1820  CD  GLU A 323      41.630  61.190  10.424  1.00 35.98           C  
ATOM   1821  OE1 GLU A 323      42.448  61.272  11.366  1.00 38.03           O  
ATOM   1822  OE2 GLU A 323      41.032  60.129  10.135  1.00 38.16           O  
ATOM   1823  N   LEU A 324      40.462  65.581  12.784  1.00 22.31           N  
ATOM   1824  CA  LEU A 324      39.703  66.636  13.443  1.00 21.95           C  
ATOM   1825  C   LEU A 324      40.586  67.852  13.699  1.00 20.46           C  
ATOM   1826  O   LEU A 324      40.140  68.991  13.546  1.00 20.66           O  
ATOM   1827  CB  LEU A 324      39.090  66.121  14.751  1.00 24.21           C  
ATOM   1828  CG  LEU A 324      37.863  65.210  14.560  1.00 28.68           C  
ATOM   1829  CD1 LEU A 324      37.447  64.588  15.887  1.00 28.19           C  
ATOM   1830  CD2 LEU A 324      36.709  66.018  13.963  1.00 28.61           C  
ATOM   1831  N   THR A 325      41.841  67.615  14.059  1.00 18.35           N  
ATOM   1832  CA  THR A 325      42.766  68.712  14.313  1.00 18.80           C  
ATOM   1833  C   THR A 325      43.029  69.458  13.002  1.00 18.41           C  
ATOM   1834  O   THR A 325      42.985  70.683  12.946  1.00 18.42           O  
ATOM   1835  CB  THR A 325      44.119  68.212  14.879  1.00 18.57           C  
ATOM   1836  OG1 THR A 325      43.909  67.530  16.121  1.00 18.07           O  
ATOM   1837  CG2 THR A 325      45.049  69.381  15.112  1.00 18.51           C  
ATOM   1838  N   GLN A 326      43.310  68.713  11.945  1.00 18.12           N  
ATOM   1839  CA  GLN A 326      43.571  69.316  10.655  1.00 19.28           C  
ATOM   1840  C   GLN A 326      42.408  70.228  10.259  1.00 18.15           C  
ATOM   1841  O   GLN A 326      42.612  71.365   9.835  1.00 18.81           O  
ATOM   1842  CB  GLN A 326      43.776  68.215   9.609  1.00 19.96           C  
ATOM   1843  CG  GLN A 326      43.913  68.719   8.194  1.00 24.50           C  
ATOM   1844  CD  GLN A 326      44.164  67.597   7.217  1.00 26.43           C  
ATOM   1845  OE1 GLN A 326      43.366  66.661   7.100  1.00 29.14           O  
ATOM   1846  NE2 GLN A 326      45.277  67.679   6.509  1.00 30.18           N  
ATOM   1847  N   ASN A 327      41.189  69.732  10.419  1.00 16.34           N  
ATOM   1848  CA  ASN A 327      40.010  70.507  10.075  1.00 16.98           C  
ATOM   1849  C   ASN A 327      39.724  71.653  11.054  1.00 17.74           C  
ATOM   1850  O   ASN A 327      39.266  72.727  10.648  1.00 17.66           O  
ATOM   1851  CB  ASN A 327      38.808  69.566   9.944  1.00 16.84           C  
ATOM   1852  CG  ASN A 327      38.813  68.806   8.625  1.00 17.84           C  
ATOM   1853  OD1 ASN A 327      38.387  69.336   7.595  1.00 18.90           O  
ATOM   1854  ND2 ASN A 327      39.320  67.575   8.642  1.00 15.45           N  
ATOM   1855  N   ALA A 328      40.003  71.440  12.334  1.00 16.12           N  
ATOM   1856  CA  ALA A 328      39.788  72.481  13.327  1.00 16.50           C  
ATOM   1857  C   ALA A 328      40.739  73.638  13.027  1.00 17.27           C  
ATOM   1858  O   ALA A 328      40.348  74.798  13.057  1.00 17.10           O  
ATOM   1859  CB  ALA A 328      40.056  71.937  14.733  1.00 17.27           C  
ATOM   1860  N   VAL A 329      41.990  73.314  12.716  1.00 16.60           N  
ATOM   1861  CA  VAL A 329      42.979  74.337  12.418  1.00 15.96           C  
ATOM   1862  C   VAL A 329      42.714  75.016  11.073  1.00 17.52           C  
ATOM   1863  O   VAL A 329      42.939  76.212  10.934  1.00 16.65           O  
ATOM   1864  CB  VAL A 329      44.404  73.754  12.457  1.00 15.06           C  
ATOM   1865  CG1 VAL A 329      45.413  74.815  12.067  1.00 16.21           C  
ATOM   1866  CG2 VAL A 329      44.710  73.247  13.864  1.00 16.69           C  
ATOM   1867  N   ARG A 330      42.236  74.261  10.087  1.00 17.27           N  
ATOM   1868  CA  ARG A 330      41.924  74.848   8.783  1.00 17.01           C  
ATOM   1869  C   ARG A 330      40.764  75.835   8.920  1.00 17.40           C  
ATOM   1870  O   ARG A 330      40.786  76.916   8.330  1.00 17.57           O  
ATOM   1871  CB  ARG A 330      41.571  73.756   7.775  1.00 17.13           C  
ATOM   1872  CG  ARG A 330      42.793  73.011   7.271  1.00 16.60           C  
ATOM   1873  CD  ARG A 330      42.428  71.924   6.278  1.00 19.77           C  
ATOM   1874  NE  ARG A 330      43.626  71.334   5.688  1.00 20.83           N  
ATOM   1875  CZ  ARG A 330      43.622  70.308   4.846  1.00 23.49           C  
ATOM   1876  NH1 ARG A 330      42.477  69.741   4.492  1.00 21.05           N  
ATOM   1877  NH2 ARG A 330      44.764  69.858   4.352  1.00 25.04           N  
ATOM   1878  N   TRP A 331      39.761  75.461   9.708  1.00 14.71           N  
ATOM   1879  CA  TRP A 331      38.605  76.316   9.943  1.00 17.32           C  
ATOM   1880  C   TRP A 331      39.087  77.641  10.522  1.00 18.32           C  
ATOM   1881  O   TRP A 331      38.660  78.711  10.088  1.00 17.74           O  
ATOM   1882  CB  TRP A 331      37.644  75.655  10.930  1.00 15.69           C  
ATOM   1883  CG  TRP A 331      36.420  76.472  11.216  1.00 16.76           C  
ATOM   1884  CD1 TRP A 331      35.310  76.582  10.427  1.00 17.47           C  
ATOM   1885  CD2 TRP A 331      36.187  77.306  12.360  1.00 17.10           C  
ATOM   1886  NE1 TRP A 331      34.398  77.435  11.011  1.00 19.01           N  
ATOM   1887  CE2 TRP A 331      34.914  77.895  12.199  1.00 18.69           C  
ATOM   1888  CE3 TRP A 331      36.931  77.618  13.510  1.00 16.55           C  
ATOM   1889  CZ2 TRP A 331      34.364  78.781  13.145  1.00 17.44           C  
ATOM   1890  CZ3 TRP A 331      36.384  78.500  14.455  1.00 15.98           C  
ATOM   1891  CH2 TRP A 331      35.115  79.068  14.262  1.00 17.94           C  
ATOM   1892  N   LEU A 332      39.994  77.556  11.492  1.00 16.86           N  
ATOM   1893  CA  LEU A 332      40.543  78.740  12.141  1.00 17.71           C  
ATOM   1894  C   LEU A 332      41.359  79.576  11.157  1.00 17.78           C  
ATOM   1895  O   LEU A 332      41.267  80.800  11.140  1.00 18.32           O  
ATOM   1896  CB  LEU A 332      41.413  78.316  13.330  1.00 16.92           C  
ATOM   1897  CG  LEU A 332      41.990  79.425  14.209  1.00 18.18           C  
ATOM   1898  CD1 LEU A 332      40.846  80.239  14.804  1.00 18.87           C  
ATOM   1899  CD2 LEU A 332      42.861  78.820  15.306  1.00 14.41           C  
ATOM   1900  N   ILE A 333      42.149  78.911  10.328  1.00 16.75           N  
ATOM   1901  CA  ILE A 333      42.965  79.612   9.351  1.00 18.02           C  
ATOM   1902  C   ILE A 333      42.076  80.368   8.351  1.00 17.62           C  
ATOM   1903  O   ILE A 333      42.406  81.482   7.946  1.00 18.89           O  
ATOM   1904  CB  ILE A 333      43.942  78.619   8.646  1.00 18.38           C  
ATOM   1905  CG1 ILE A 333      45.002  78.157   9.664  1.00 18.00           C  
ATOM   1906  CG2 ILE A 333      44.610  79.278   7.449  1.00 17.38           C  
ATOM   1907  CD1 ILE A 333      46.022  77.164   9.126  1.00 18.12           C  
ATOM   1908  N   ASN A 334      40.936  79.783   7.986  1.00 18.03           N  
ATOM   1909  CA  ASN A 334      39.996  80.441   7.073  1.00 19.88           C  
ATOM   1910  C   ASN A 334      39.578  81.798   7.660  1.00 21.23           C  
ATOM   1911  O   ASN A 334      39.648  82.835   6.999  1.00 22.10           O  
ATOM   1912  CB  ASN A 334      38.732  79.588   6.884  1.00 19.60           C  
ATOM   1913  CG  ASN A 334      38.929  78.435   5.914  1.00 20.89           C  
ATOM   1914  OD1 ASN A 334      38.010  77.644   5.688  1.00 22.13           O  
ATOM   1915  ND2 ASN A 334      40.117  78.333   5.335  1.00 16.83           N  
ATOM   1916  N   GLN A 335      39.143  81.771   8.914  1.00 23.34           N  
ATOM   1917  CA  GLN A 335      38.688  82.969   9.607  1.00 25.22           C  
ATOM   1918  C   GLN A 335      39.799  84.003   9.790  1.00 24.71           C  
ATOM   1919  O   GLN A 335      39.554  85.207   9.689  1.00 25.68           O  
ATOM   1920  CB  GLN A 335      38.139  82.604  10.990  1.00 26.89           C  
ATOM   1921  CG  GLN A 335      37.473  81.241  11.099  1.00 31.01           C  
ATOM   1922  CD  GLN A 335      36.179  81.142  10.313  1.00 33.65           C  
ATOM   1923  OE1 GLN A 335      35.249  81.918  10.531  1.00 34.62           O  
ATOM   1924  NE2 GLN A 335      36.107  80.168   9.403  1.00 32.33           N  
ATOM   1925  N   CYS A 336      41.013  83.527  10.061  1.00 23.12           N  
ATOM   1926  CA  CYS A 336      42.162  84.395  10.310  1.00 23.41           C  
ATOM   1927  C   CYS A 336      42.916  84.930   9.107  1.00 25.24           C  
ATOM   1928  O   CYS A 336      43.227  86.124   9.048  1.00 25.23           O  
ATOM   1929  CB  CYS A 336      43.195  83.682  11.181  1.00 23.40           C  
ATOM   1930  SG  CYS A 336      42.763  83.441  12.895  1.00 24.52           S  
ATOM   1931  N   TYR A 337      43.220  84.048   8.158  1.00 24.18           N  
ATOM   1932  CA  TYR A 337      44.012  84.448   7.011  1.00 23.04           C  
ATOM   1933  C   TYR A 337      43.392  84.429   5.620  1.00 23.50           C  
ATOM   1934  O   TYR A 337      44.106  84.598   4.631  1.00 25.91           O  
ATOM   1935  CB  TYR A 337      45.302  83.635   7.007  1.00 20.67           C  
ATOM   1936  CG  TYR A 337      46.016  83.637   8.346  1.00 19.21           C  
ATOM   1937  CD1 TYR A 337      46.467  84.824   8.911  1.00 20.52           C  
ATOM   1938  CD2 TYR A 337      46.260  82.449   9.035  1.00 18.96           C  
ATOM   1939  CE1 TYR A 337      47.149  84.834  10.125  1.00 22.16           C  
ATOM   1940  CE2 TYR A 337      46.943  82.449  10.249  1.00 20.20           C  
ATOM   1941  CZ  TYR A 337      47.386  83.645  10.790  1.00 19.44           C  
ATOM   1942  OH  TYR A 337      48.086  83.661  11.978  1.00 19.85           O  
ATOM   1943  N   GLY A 338      42.086  84.217   5.527  1.00 23.26           N  
ATOM   1944  CA  GLY A 338      41.453  84.247   4.223  1.00 23.77           C  
ATOM   1945  C   GLY A 338      41.576  83.035   3.318  1.00 24.36           C  
ATOM   1946  O   GLY A 338      41.293  83.137   2.116  1.00 24.35           O  
ATOM   1947  N   THR A 339      42.000  81.895   3.862  1.00 22.15           N  
ATOM   1948  CA  THR A 339      42.101  80.686   3.059  1.00 20.25           C  
ATOM   1949  C   THR A 339      40.675  80.227   2.783  1.00 19.33           C  
ATOM   1950  O   THR A 339      39.736  80.731   3.393  1.00 18.86           O  
ATOM   1951  CB  THR A 339      42.834  79.570   3.815  1.00 20.59           C  
ATOM   1952  OG1 THR A 339      42.356  79.525   5.167  1.00 18.42           O  
ATOM   1953  CG2 THR A 339      44.323  79.820   3.812  1.00 15.86           C  
ATOM   1954  N   LYS A 340      40.506  79.285   1.861  1.00 20.40           N  
ATOM   1955  CA  LYS A 340      39.176  78.780   1.552  1.00 21.46           C  
ATOM   1956  C   LYS A 340      39.075  77.256   1.610  1.00 22.10           C  
ATOM   1957  O   LYS A 340      38.606  76.613   0.676  1.00 20.06           O  
ATOM   1958  CB  LYS A 340      38.708  79.286   0.181  1.00 24.73           C  
ATOM   1959  CG  LYS A 340      37.783  80.497   0.267  1.00 28.38           C  
ATOM   1960  CD  LYS A 340      38.555  81.796   0.339  1.00 32.74           C  
ATOM   1961  CE  LYS A 340      37.777  82.895   1.081  1.00 34.45           C  
ATOM   1962  NZ  LYS A 340      36.375  83.128   0.607  1.00 34.90           N  
ATOM   1963  N   TRP A 341      39.511  76.687   2.726  1.00 21.85           N  
ATOM   1964  CA  TRP A 341      39.452  75.248   2.931  1.00 22.04           C  
ATOM   1965  C   TRP A 341      38.020  74.779   3.100  1.00 23.49           C  
ATOM   1966  O   TRP A 341      37.218  75.469   3.724  1.00 23.17           O  
ATOM   1967  CB  TRP A 341      40.170  74.866   4.225  1.00 21.94           C  
ATOM   1968  CG  TRP A 341      41.653  75.025   4.223  1.00 23.34           C  
ATOM   1969  CD1 TRP A 341      42.385  75.965   4.894  1.00 22.42           C  
ATOM   1970  CD2 TRP A 341      42.594  74.153   3.592  1.00 22.54           C  
ATOM   1971  NE1 TRP A 341      43.731  75.721   4.724  1.00 22.88           N  
ATOM   1972  CE2 TRP A 341      43.883  74.617   3.932  1.00 22.85           C  
ATOM   1973  CE3 TRP A 341      42.470  73.023   2.777  1.00 24.13           C  
ATOM   1974  CZ2 TRP A 341      45.047  73.977   3.482  1.00 24.07           C  
ATOM   1975  CZ3 TRP A 341      43.630  72.388   2.328  1.00 26.50           C  
ATOM   1976  CH2 TRP A 341      44.899  72.866   2.683  1.00 26.83           C  
ATOM   1977  N   GLU A 342      37.688  73.611   2.558  1.00 23.83           N  
ATOM   1978  CA  GLU A 342      36.361  73.062   2.785  1.00 25.22           C  
ATOM   1979  C   GLU A 342      36.591  72.383   4.127  1.00 23.91           C  
ATOM   1980  O   GLU A 342      37.630  71.751   4.331  1.00 23.13           O  
ATOM   1981  CB  GLU A 342      35.980  72.022   1.722  1.00 28.80           C  
ATOM   1982  CG  GLU A 342      35.749  72.618   0.338  1.00 34.54           C  
ATOM   1983  CD  GLU A 342      35.269  71.587  -0.674  1.00 39.11           C  
ATOM   1984  OE1 GLU A 342      36.061  70.673  -1.029  1.00 40.55           O  
ATOM   1985  OE2 GLU A 342      34.099  71.695  -1.110  1.00 39.18           O  
ATOM   1986  N   ILE A 343      35.640  72.520   5.042  1.00 23.51           N  
ATOM   1987  CA  ILE A 343      35.779  71.939   6.376  1.00 22.25           C  
ATOM   1988  C   ILE A 343      34.873  70.733   6.623  1.00 22.45           C  
ATOM   1989  O   ILE A 343      33.673  70.793   6.366  1.00 22.07           O  
ATOM   1990  CB  ILE A 343      35.484  73.009   7.448  1.00 21.09           C  
ATOM   1991  CG1 ILE A 343      36.326  74.258   7.176  1.00 19.89           C  
ATOM   1992  CG2 ILE A 343      35.778  72.466   8.840  1.00 23.11           C  
ATOM   1993  CD1 ILE A 343      37.815  74.007   7.153  1.00 18.46           C  
ATOM   1994  N   PHE A 344      35.457  69.641   7.119  1.00 21.55           N  
ATOM   1995  CA  PHE A 344      34.704  68.421   7.430  1.00 21.69           C  
ATOM   1996  C   PHE A 344      34.774  68.137   8.930  1.00 22.14           C  
ATOM   1997  O   PHE A 344      35.841  68.251   9.542  1.00 21.14           O  
ATOM   1998  CB  PHE A 344      35.254  67.253   6.613  1.00 22.69           C  
ATOM   1999  CG  PHE A 344      35.281  67.534   5.136  1.00 26.02           C  
ATOM   2000  CD1 PHE A 344      36.297  68.320   4.584  1.00 25.80           C  
ATOM   2001  CD2 PHE A 344      34.246  67.094   4.312  1.00 27.14           C  
ATOM   2002  CE1 PHE A 344      36.281  68.675   3.226  1.00 27.69           C  
ATOM   2003  CE2 PHE A 344      34.213  67.440   2.946  1.00 28.50           C  
ATOM   2004  CZ  PHE A 344      35.234  68.233   2.405  1.00 27.81           C  
ATOM   2005  N   ARG A 345      33.633  67.781   9.516  1.00 22.70           N  
ATOM   2006  CA  ARG A 345      33.528  67.532  10.959  1.00 24.17           C  
ATOM   2007  C   ARG A 345      33.104  66.119  11.355  1.00 26.04           C  
ATOM   2008  O   ARG A 345      32.925  65.836  12.545  1.00 25.84           O  
ATOM   2009  CB  ARG A 345      32.523  68.515  11.571  1.00 23.50           C  
ATOM   2010  CG  ARG A 345      32.872  69.971  11.359  1.00 25.02           C  
ATOM   2011  CD  ARG A 345      31.634  70.853  11.395  1.00 23.65           C  
ATOM   2012  NE  ARG A 345      31.989  72.244  11.162  1.00 21.51           N  
ATOM   2013  CZ  ARG A 345      32.618  73.003  12.050  1.00 23.66           C  
ATOM   2014  NH1 ARG A 345      32.944  72.499  13.235  1.00 21.76           N  
ATOM   2015  NH2 ARG A 345      32.951  74.251  11.741  1.00 22.77           N  
ATOM   2016  N   GLU A 346      32.932  65.238  10.376  1.00 26.83           N  
ATOM   2017  CA  GLU A 346      32.491  63.873  10.665  1.00 28.17           C  
ATOM   2018  C   GLU A 346      33.484  62.812  10.230  1.00 27.45           C  
ATOM   2019  O   GLU A 346      33.782  62.681   9.043  1.00 26.24           O  
ATOM   2020  CB  GLU A 346      31.150  63.593   9.976  1.00 31.15           C  
ATOM   2021  CG  GLU A 346      30.014  64.532  10.395  1.00 38.37           C  
ATOM   2022  CD  GLU A 346      29.780  64.519  11.897  1.00 41.44           C  
ATOM   2023  OE1 GLU A 346      29.748  63.412  12.474  1.00 44.28           O  
ATOM   2024  OE2 GLU A 346      29.632  65.608  12.504  1.00 43.65           O  
ATOM   2025  N   PHE A 347      33.995  62.057  11.193  1.00 26.44           N  
ATOM   2026  CA  PHE A 347      34.926  60.987  10.884  1.00 27.11           C  
ATOM   2027  C   PHE A 347      34.519  59.771  11.679  1.00 27.17           C  
ATOM   2028  O   PHE A 347      34.019  59.887  12.800  1.00 27.86           O  
ATOM   2029  CB  PHE A 347      36.353  61.411  11.191  1.00 26.69           C  
ATOM   2030  CG  PHE A 347      36.777  62.616  10.417  1.00 28.53           C  
ATOM   2031  CD1 PHE A 347      36.744  63.880  11.006  1.00 28.33           C  
ATOM   2032  CD2 PHE A 347      37.123  62.502   9.068  1.00 27.61           C  
ATOM   2033  CE1 PHE A 347      37.051  65.023  10.262  1.00 30.34           C  
ATOM   2034  CE2 PHE A 347      37.432  63.642   8.301  1.00 29.34           C  
ATOM   2035  CZ  PHE A 347      37.394  64.907   8.900  1.00 29.39           C  
ATOM   2036  N   PRO A 348      34.700  58.582  11.099  1.00 26.78           N  
ATOM   2037  CA  PRO A 348      34.294  57.412  11.866  1.00 27.67           C  
ATOM   2038  C   PRO A 348      35.292  56.970  12.922  1.00 27.16           C  
ATOM   2039  O   PRO A 348      36.495  57.216  12.826  1.00 24.97           O  
ATOM   2040  CB  PRO A 348      34.068  56.358  10.779  1.00 27.06           C  
ATOM   2041  CG  PRO A 348      35.125  56.686   9.785  1.00 28.73           C  
ATOM   2042  CD  PRO A 348      35.071  58.213   9.719  1.00 28.50           C  
ATOM   2043  N   VAL A 349      34.751  56.347  13.955  1.00 28.02           N  
ATOM   2044  CA  VAL A 349      35.556  55.805  15.024  1.00 26.84           C  
ATOM   2045  C   VAL A 349      35.473  54.299  14.771  1.00 25.92           C  
ATOM   2046  O   VAL A 349      34.409  53.767  14.439  1.00 24.64           O  
ATOM   2047  CB  VAL A 349      34.959  56.163  16.391  1.00 28.07           C  
ATOM   2048  CG1 VAL A 349      33.574  55.581  16.499  1.00 29.68           C  
ATOM   2049  CG2 VAL A 349      35.841  55.641  17.508  1.00 28.80           C  
ATOM   2050  N   THR A 350      36.604  53.623  14.884  1.00 24.28           N  
ATOM   2051  CA  THR A 350      36.657  52.188  14.662  1.00 24.13           C  
ATOM   2052  C   THR A 350      37.524  51.567  15.748  1.00 24.53           C  
ATOM   2053  O   THR A 350      38.037  52.273  16.624  1.00 24.16           O  
ATOM   2054  CB  THR A 350      37.291  51.862  13.306  1.00 24.73           C  
ATOM   2055  OG1 THR A 350      38.581  52.481  13.231  1.00 25.30           O  
ATOM   2056  CG2 THR A 350      36.410  52.376  12.159  1.00 24.22           C  
ATOM   2057  N   VAL A 351      37.680  50.251  15.703  1.00 23.04           N  
ATOM   2058  CA  VAL A 351      38.510  49.575  16.686  1.00 22.51           C  
ATOM   2059  C   VAL A 351      39.719  48.960  16.013  1.00 21.73           C  
ATOM   2060  O   VAL A 351      39.594  48.228  15.032  1.00 22.19           O  
ATOM   2061  CB  VAL A 351      37.738  48.478  17.425  1.00 23.05           C  
ATOM   2062  CG1 VAL A 351      38.677  47.694  18.311  1.00 23.69           C  
ATOM   2063  CG2 VAL A 351      36.652  49.103  18.274  1.00 26.16           C  
ATOM   2064  N   SER A 352      40.896  49.277  16.534  1.00 20.65           N  
ATOM   2065  CA  SER A 352      42.122  48.731  15.987  1.00 21.62           C  
ATOM   2066  C   SER A 352      42.421  47.447  16.745  1.00 21.34           C  
ATOM   2067  O   SER A 352      42.956  47.475  17.849  1.00 21.77           O  
ATOM   2068  CB  SER A 352      43.259  49.738  16.145  1.00 22.89           C  
ATOM   2069  OG  SER A 352      42.940  50.930  15.448  1.00 24.08           O  
HETATM 2070  N   MSE A 353      42.042  46.323  16.152  1.00 22.32           N  
HETATM 2071  CA  MSE A 353      42.246  45.024  16.776  1.00 22.83           C  
HETATM 2072  C   MSE A 353      43.697  44.594  16.719  1.00 23.02           C  
HETATM 2073  O   MSE A 353      44.275  44.471  15.639  1.00 21.82           O  
HETATM 2074  CB  MSE A 353      41.383  43.954  16.093  1.00 23.49           C  
HETATM 2075  CG  MSE A 353      39.905  43.954  16.469  1.00 27.12           C  
HETATM 2076 SE   MSE A 353      39.543  43.537  18.208  1.00 27.32          SE  
HETATM 2077  CE  MSE A 353      40.553  42.110  18.458  1.00 26.53           C  
ATOM   2078  N   ARG A 354      44.287  44.368  17.885  1.00 22.12           N  
ATOM   2079  CA  ARG A 354      45.674  43.929  17.938  1.00 22.98           C  
ATOM   2080  C   ARG A 354      45.745  42.637  18.728  1.00 22.91           C  
ATOM   2081  O   ARG A 354      45.000  41.708  18.422  1.00 23.82           O  
ATOM   2082  CB  ARG A 354      46.559  45.036  18.525  1.00 22.25           C  
ATOM   2083  CG  ARG A 354      46.501  46.310  17.670  1.00 22.15           C  
ATOM   2084  CD  ARG A 354      47.794  47.105  17.711  1.00 21.85           C  
ATOM   2085  NE  ARG A 354      47.774  48.262  16.814  1.00 20.69           N  
ATOM   2086  CZ  ARG A 354      47.093  49.381  17.041  1.00 20.09           C  
ATOM   2087  NH1 ARG A 354      46.365  49.508  18.143  1.00 19.76           N  
ATOM   2088  NH2 ARG A 354      47.147  50.379  16.171  1.00 19.79           N  
ATOM   2089  N   ALA A 355      46.582  42.563  19.758  1.00 22.09           N  
ATOM   2090  CA  ALA A 355      46.694  41.308  20.491  1.00 19.88           C  
ATOM   2091  C   ALA A 355      46.346  41.304  21.973  1.00 19.54           C  
ATOM   2092  O   ALA A 355      46.566  40.298  22.650  1.00 19.66           O  
ATOM   2093  CB  ALA A 355      48.101  40.745  20.299  1.00 21.36           C  
ATOM   2094  N   SER A 356      45.796  42.396  22.490  1.00 18.18           N  
ATOM   2095  CA  SER A 356      45.479  42.447  23.913  1.00 16.77           C  
ATOM   2096  C   SER A 356      44.077  41.963  24.267  1.00 17.41           C  
ATOM   2097  O   SER A 356      43.737  41.865  25.439  1.00 17.07           O  
ATOM   2098  CB  SER A 356      45.671  43.863  24.450  1.00 15.11           C  
ATOM   2099  OG  SER A 356      44.799  44.744  23.789  1.00 16.30           O  
ATOM   2100  N   VAL A 357      43.260  41.675  23.262  1.00 17.93           N  
ATOM   2101  CA  VAL A 357      41.911  41.172  23.514  1.00 19.18           C  
ATOM   2102  C   VAL A 357      41.729  39.780  22.894  1.00 20.07           C  
ATOM   2103  O   VAL A 357      42.009  39.577  21.713  1.00 19.52           O  
ATOM   2104  CB  VAL A 357      40.825  42.127  22.948  1.00 19.23           C  
ATOM   2105  CG1 VAL A 357      39.428  41.547  23.208  1.00 18.78           C  
ATOM   2106  CG2 VAL A 357      40.947  43.494  23.598  1.00 20.12           C  
ATOM   2107  N   ALA A 358      41.270  38.830  23.704  1.00 21.07           N  
ATOM   2108  CA  ALA A 358      41.041  37.460  23.250  1.00 23.88           C  
ATOM   2109  C   ALA A 358      39.754  36.926  23.881  1.00 23.91           C  
ATOM   2110  O   ALA A 358      39.182  37.558  24.760  1.00 24.33           O  
ATOM   2111  CB  ALA A 358      42.227  36.573  23.635  1.00 23.16           C  
ATOM   2112  N   ARG A 359      39.296  35.762  23.434  1.00 26.07           N  
ATOM   2113  CA  ARG A 359      38.070  35.182  23.973  1.00 28.48           C  
ATOM   2114  C   ARG A 359      38.252  34.682  25.411  1.00 29.84           C  
ATOM   2115  O   ARG A 359      39.338  34.149  25.718  1.00 29.65           O  
ATOM   2116  CB  ARG A 359      37.612  34.038  23.066  1.00 30.36           C  
ATOM   2117  CG  ARG A 359      36.339  33.346  23.508  1.00 32.78           C  
ATOM   2118  CD  ARG A 359      35.385  33.190  22.337  1.00 33.37           C  
ATOM   2119  NE  ARG A 359      34.132  33.874  22.627  1.00 34.09           N  
ATOM   2120  CZ  ARG A 359      33.583  34.792  21.844  1.00 33.65           C  
ATOM   2121  NH1 ARG A 359      34.166  35.143  20.699  1.00 34.82           N  
ATOM   2122  NH2 ARG A 359      32.457  35.373  22.221  1.00 36.58           N  
TER    2123      ARG A 359                                                      
END
MOLECULE T0441.pdb
ATOM   1966  N   TYR    71      49.594  89.534  10.660  1.00 83.57           N  
ATOM   1967  CA  TYR    71      48.568  88.745  11.391  1.00 83.73           C  
ATOM   1968  C   TYR    71      49.071  87.324  11.626  1.00 83.84           C  
ATOM   1969  O   TYR    71      49.434  86.619  10.681  1.00 83.94           O  
ATOM   1970  CB  TYR    71      47.245  88.735  10.617  1.00 83.64           C  
ATOM   1971  N   SER    72      49.096  86.923  12.896  1.00 83.90           N  
ATOM   1972  CA  SER    72      49.603  85.615  13.315  1.00 83.83           C  
ATOM   1973  C   SER    72      48.574  84.867  14.158  1.00 83.82           C  
ATOM   1974  O   SER    72      47.678  85.478  14.757  1.00 83.79           O  
ATOM   1975  CB  SER    72      50.905  85.773  14.103  1.00 83.93           C  
ATOM   1976  OG  SER    72      50.713  86.579  15.256  1.00 83.98           O  
ATOM   1977  N   ILE    73      48.729  83.546  14.221  1.00 83.67           N  
ATOM   1978  CA  ILE    73      47.692  82.646  14.742  1.00 83.53           C  
ATOM   1979  C   ILE    73      48.098  81.919  16.050  1.00 83.45           C  
ATOM   1980  O   ILE    73      49.184  81.323  16.148  1.00 83.38           O  
ATOM   1981  CB  ILE    73      47.225  81.659  13.623  1.00 83.50           C  
ATOM   1982  CG1 ILE    73      46.156  80.671  14.113  1.00 83.40           C  
ATOM   1983  CG2 ILE    73      48.419  80.944  13.007  1.00 83.88           C  
ATOM   1984  CD1 ILE    73      46.690  79.468  14.879  1.00 82.70           C  
ATOM   1985  N   ALA    74      47.204  81.964  17.038  1.00 83.07           N  
ATOM   1986  CA  ALA    74      47.529  81.533  18.394  1.00 82.96           C  
ATOM   1987  C   ALA    74      46.796  80.279  18.842  1.00 82.74           C  
ATOM   1988  O   ALA    74      45.665  80.017  18.424  1.00 83.01           O  
ATOM   1989  CB  ALA    74      47.301  82.671  19.390  1.00 83.02           C  
ATOM   1990  N   LEU    75      47.457  79.513  19.704  1.00 82.10           N  
ATOM   1991  CA  LEU    75      46.938  78.237  20.154  1.00 81.49           C  
ATOM   1992  C   LEU    75      47.412  77.951  21.572  1.00 81.22           C  
ATOM   1993  O   LEU    75      48.610  77.992  21.869  1.00 81.01           O  
ATOM   1994  CB  LEU    75      47.382  77.129  19.198  1.00 81.47           C  
ATOM   1995  CG  LEU    75      47.316  75.695  19.705  1.00 80.81           C  
ATOM   1996  CD1 LEU    75      45.955  75.124  19.430  1.00 80.85           C  
ATOM   1997  CD2 LEU    75      48.374  74.879  19.016  1.00 80.38           C  
ATOM   1998  N   ILE    76      46.456  77.661  22.444  1.00 80.63           N  
ATOM   1999  CA  ILE    76      46.765  77.385  23.834  1.00 79.97           C  
ATOM   2000  C   ILE    76      46.554  75.911  24.133  1.00 79.25           C  
ATOM   2001  O   ILE    76      45.423  75.417  24.188  1.00 79.06           O  
ATOM   2002  CB  ILE    76      45.952  78.278  24.785  1.00 80.00           C  
ATOM   2003  CG1 ILE    76      46.060  79.741  24.346  1.00 80.18           C  
ATOM   2004  CG2 ILE    76      46.436  78.113  26.225  1.00 80.49           C  
ATOM   2005  CD1 ILE    76      45.212  80.711  25.164  1.00 80.47           C  
ATOM   2006  N   ILE    77      47.676  75.223  24.300  1.00 78.70           N  
ATOM   2007  CA  ILE    77      47.728  73.816  24.669  1.00 78.25           C  
ATOM   2008  C   ILE    77      47.348  73.636  26.137  1.00 77.99           C  
ATOM   2009  O   ILE    77      47.729  74.449  26.983  1.00 77.85           O  
ATOM   2010  CB  ILE    77      49.159  73.254  24.395  1.00 78.34           C  
ATOM   2011  CG1 ILE    77      49.362  72.938  22.905  1.00 78.12           C  
ATOM   2012  CG2 ILE    77      49.490  72.045  25.269  1.00 78.58           C  
ATOM   2013  CD1 ILE    77      48.130  72.369  22.181  1.00 78.12           C  
ATOM   2014  N   PRO    78      46.579  72.580  26.441  1.00 77.98           N  
ATOM   2015  CA  PRO    78      46.216  72.257  27.820  1.00 78.03           C  
ATOM   2016  C   PRO    78      47.234  71.368  28.534  1.00 77.93           C  
ATOM   2017  O   PRO    78      47.503  71.584  29.707  1.00 77.64           O  
ATOM   2018  CB  PRO    78      44.885  71.526  27.661  1.00 78.05           C  
ATOM   2019  CG  PRO    78      44.986  70.835  26.343  1.00 78.02           C  
ATOM   2020  CD  PRO    78      45.967  71.637  25.486  1.00 78.23           C  
ATOM   2021  N   SER    79      47.770  70.367  27.835  1.00 78.42           N  
ATOM   2022  CA  SER    79      48.829  69.499  28.378  1.00 78.87           C  
ATOM   2023  C   SER    79      49.870  69.176  27.323  1.00 79.25           C  
ATOM   2024  O   SER    79      49.586  69.185  26.129  1.00 79.38           O  
ATOM   2025  CB  SER    79      48.268  68.194  28.963  1.00 78.67           C  
ATOM   2026  OG  SER    79      47.852  68.370  30.302  1.00 78.28           O  
ATOM   2027  N   LEU    80      51.083  68.906  27.785  1.00 79.95           N  
ATOM   2028  CA  LEU    80      52.169  68.467  26.929  1.00 80.52           C  
ATOM   2029  C   LEU    80      52.079  66.957  26.805  1.00 80.91           C  
ATOM   2030  O   LEU    80      52.534  66.381  25.819  1.00 80.65           O  
ATOM   2031  CB  LEU    80      53.510  68.863  27.557  1.00 80.60           C  
ATOM   2032  N   PHE    81      51.459  66.344  27.817  1.00 81.78           N  
ATOM   2033  CA  PHE    81      51.446  64.895  28.023  1.00 82.60           C  
ATOM   2034  C   PHE    81      50.295  64.154  27.320  1.00 83.52           C  
ATOM   2035  O   PHE    81      50.105  62.945  27.531  1.00 83.41           O  
ATOM   2036  CB  PHE    81      51.424  64.590  29.522  1.00 82.23           C  
ATOM   2037  N   GLU    82      49.535  64.860  26.482  1.00 84.40           N  
ATOM   2038  CA  GLU    82      48.391  64.229  25.857  1.00 85.69           C  
ATOM   2039  C   GLU    82      48.537  63.989  24.344  1.00 86.38           C  
ATOM   2040  O   GLU    82      48.646  64.938  23.555  1.00 86.64           O  
ATOM   2041  CB  GLU    82      47.087  64.947  26.220  1.00 85.68           C  
ATOM   2042  CG  GLU    82      45.826  64.054  26.091  1.00 88.45           C  
ATOM   2043  CD  GLU    82      45.926  62.697  26.857  1.00 91.76           C  
ATOM   2044  OE1 GLU    82      46.359  61.679  26.239  1.00 91.96           O  
ATOM   2045  OE2 GLU    82      45.563  62.652  28.066  1.00 91.67           O  
ATOM   2046  N   LYS    83      48.543  62.706  23.967  1.00 87.01           N  
ATOM   2047  CA  LYS    83      48.568  62.251  22.569  1.00 87.39           C  
ATOM   2048  C   LYS    83      47.903  63.247  21.619  1.00 87.84           C  
ATOM   2049  O   LYS    83      48.505  63.676  20.634  1.00 87.78           O  
ATOM   2050  CB  LYS    83      47.866  60.886  22.444  1.00 87.25           C  
ATOM   2051  CG  LYS    83      48.729  59.642  22.702  1.00 87.00           C  
ATOM   2052  CD  LYS    83      49.144  59.465  24.169  1.00 86.17           C  
ATOM   2053  CE  LYS    83      49.422  57.996  24.482  1.00 85.98           C  
ATOM   2054  NZ  LYS    83      49.983  57.805  25.857  1.00 86.52           N  
ATOM   2055  N   ALA    84      46.660  63.610  21.939  1.00 88.65           N  
ATOM   2056  CA  ALA    84      45.878  64.570  21.164  1.00 89.16           C  
ATOM   2057  C   ALA    84      46.681  65.819  20.810  1.00 89.74           C  
ATOM   2058  O   ALA    84      46.688  66.230  19.661  1.00 90.35           O  
ATOM   2059  CB  ALA    84      44.584  64.931  21.889  1.00 89.06           C  
ATOM   2060  N   CYS    85      47.389  66.406  21.768  1.00 90.04           N  
ATOM   2061  CA  CYS    85      48.221  67.571  21.454  1.00 90.17           C  
ATOM   2062  C   CYS    85      49.563  67.138  20.901  1.00 89.89           C  
ATOM   2063  O   CYS    85      50.009  67.664  19.885  1.00 90.18           O  
ATOM   2064  CB  CYS    85      48.406  68.444  22.680  1.00 90.12           C  
ATOM   2065  SG  CYS    85      46.881  68.515  23.610  1.00 91.77           S  
ATOM   2066  N   ALA    86      50.201  66.177  21.565  1.00 89.42           N  
ATOM   2067  CA  ALA    86      51.482  65.646  21.112  1.00 88.98           C  
ATOM   2068  C   ALA    86      51.483  65.354  19.609  1.00 88.68           C  
ATOM   2069  O   ALA    86      52.378  65.793  18.885  1.00 88.59           O  
ATOM   2070  CB  ALA    86      51.845  64.392  21.899  1.00 89.30           C  
ATOM   2071  N   HIS    87      50.464  64.646  19.131  1.00 88.21           N  
ATOM   2072  CA  HIS    87      50.435  64.242  17.727  1.00 87.79           C  
ATOM   2073  C   HIS    87      49.810  65.308  16.818  1.00 87.04           C  
ATOM   2074  O   HIS    87      50.122  65.385  15.633  1.00 87.02           O  
ATOM   2075  CB  HIS    87      49.774  62.874  17.581  1.00 87.92           C  
ATOM   2076  CG  HIS    87      50.509  61.774  18.292  1.00 89.43           C  
ATOM   2077  ND1 HIS    87      50.432  61.583  19.659  1.00 90.36           N  
ATOM   2078  CD2 HIS    87      51.346  60.813  17.829  1.00 90.29           C  
ATOM   2079  CE1 HIS    87      51.179  60.549  20.005  1.00 89.29           C  
ATOM   2080  NE2 HIS    87      51.743  60.064  18.914  1.00 90.44           N  
ATOM   2081  N   PHE    88      48.961  66.144  17.401  1.00 86.05           N  
ATOM   2082  CA  PHE    88      48.298  67.229  16.695  1.00 85.20           C  
ATOM   2083  C   PHE    88      49.260  68.361  16.278  1.00 84.88           C  
ATOM   2084  O   PHE    88      49.353  68.703  15.094  1.00 85.42           O  
ATOM   2085  CB  PHE    88      47.192  67.736  17.603  1.00 85.13           C  
ATOM   2086  CG  PHE    88      46.521  68.975  17.141  1.00 84.81           C  
ATOM   2087  CD1 PHE    88      45.364  68.902  16.378  1.00 85.76           C  
ATOM   2088  CD2 PHE    88      46.995  70.216  17.520  1.00 84.06           C  
ATOM   2089  CE1 PHE    88      44.713  70.059  15.949  1.00 85.65           C  
ATOM   2090  CE2 PHE    88      46.353  71.372  17.105  1.00 85.29           C  
ATOM   2091  CZ  PHE    88      45.207  71.293  16.313  1.00 85.42           C  
ATOM   2092  N   LEU    89      49.983  68.921  17.242  1.00 84.05           N  
ATOM   2093  CA  LEU    89      50.886  70.068  17.019  1.00 83.60           C  
ATOM   2094  C   LEU    89      51.788  70.137  15.761  1.00 83.37           C  
ATOM   2095  O   LEU    89      51.823  71.174  15.101  1.00 82.95           O  
ATOM   2096  CB  LEU    89      51.751  70.304  18.263  1.00 83.53           C  
ATOM   2097  CG  LEU    89      51.536  71.596  19.044  1.00 83.15           C  
ATOM   2098  CD1 LEU    89      52.428  72.696  18.523  1.00 83.68           C  
ATOM   2099  CD2 LEU    89      50.089  72.024  18.990  1.00 82.82           C  
ATOM   2100  N   PRO    90      52.539  69.060  15.441  1.00 83.25           N  
ATOM   2101  CA  PRO    90      53.534  69.246  14.386  1.00 83.05           C  
ATOM   2102  C   PRO    90      52.955  69.281  12.965  1.00 82.81           C  
ATOM   2103  O   PRO    90      53.599  69.821  12.060  1.00 82.76           O  
ATOM   2104  CB  PRO    90      54.493  68.051  14.564  1.00 82.87           C  
ATOM   2105  CG  PRO    90      54.005  67.293  15.736  1.00 83.15           C  
ATOM   2106  CD  PRO    90      52.570  67.680  15.954  1.00 83.48           C  
ATOM   2107  N   SER    91      51.767  68.718  12.763  1.00 82.38           N  
ATOM   2108  CA  SER    91      51.143  68.802  11.448  1.00 81.93           C  
ATOM   2109  C   SER    91      50.214  70.003  11.407  1.00 81.59           C  
ATOM   2110  O   SER    91      49.813  70.450  10.336  1.00 81.40           O  
ATOM   2111  CB  SER    91      50.416  67.504  11.079  1.00 82.17           C  
ATOM   2112  OG  SER    91      49.149  67.398  11.700  1.00 82.10           O  
ATOM   2113  N   PHE    92      49.876  70.513  12.588  1.00 81.10           N  
ATOM   2114  CA  PHE    92      49.159  71.767  12.688  1.00 80.93           C  
ATOM   2115  C   PHE    92      50.138  72.901  12.470  1.00 81.32           C  
ATOM   2116  O   PHE    92      49.748  73.982  12.055  1.00 81.63           O  
ATOM   2117  CB  PHE    92      48.487  71.906  14.052  1.00 80.67           C  
ATOM   2118  CG  PHE    92      47.610  73.130  14.180  1.00 80.49           C  
ATOM   2119  CD1 PHE    92      46.341  73.164  13.612  1.00 80.67           C  
ATOM   2120  CD2 PHE    92      48.049  74.248  14.871  1.00 80.65           C  
ATOM   2121  CE1 PHE    92      45.530  74.288  13.731  1.00 79.47           C  
ATOM   2122  CE2 PHE    92      47.240  75.379  14.988  1.00 79.58           C  
ATOM   2123  CZ  PHE    92      45.983  75.394  14.416  1.00 78.92           C  
ATOM   2124  N   GLN    93      51.413  72.659  12.764  1.00 81.80           N  
ATOM   2125  CA  GLN    93      52.452  73.626  12.450  1.00 82.18           C  
ATOM   2126  C   GLN    93      52.701  73.603  10.948  1.00 82.40           C  
ATOM   2127  O   GLN    93      52.641  74.658  10.308  1.00 82.79           O  
ATOM   2128  CB  GLN    93      53.746  73.361  13.232  1.00 82.30           C  
ATOM   2129  CG  GLN    93      54.901  74.348  12.946  1.00 82.85           C  
ATOM   2130  CD  GLN    93      54.952  75.553  13.894  1.00 84.06           C  
ATOM   2131  OE1 GLN    93      55.199  75.412  15.100  1.00 84.93           O  
ATOM   2132  NE2 GLN    93      54.759  76.746  13.341  1.00 83.84           N  
ATOM   2133  N   GLN    94      52.952  72.412  10.388  1.00 82.32           N  
ATOM   2134  CA  GLN    94      53.298  72.272   8.950  1.00 82.26           C  
ATOM   2135  C   GLN    94      52.285  72.961   8.053  1.00 81.40           C  
ATOM   2136  O   GLN    94      52.627  73.864   7.285  1.00 81.12           O  
ATOM   2137  CB  GLN    94      53.399  70.801   8.521  1.00 82.33           C  
ATOM   2138  CG  GLN    94      54.645  70.039   8.991  1.00 82.94           C  
ATOM   2139  CD  GLN    94      54.467  68.511   8.907  1.00 83.39           C  
ATOM   2140  OE1 GLN    94      53.375  67.968   9.184  1.00 84.98           O  
ATOM   2141  NE2 GLN    94      55.540  67.815   8.532  1.00 83.49           N  
ATOM   2142  N   ALA    95      51.035  72.530   8.182  1.00 80.74           N  
ATOM   2143  CA  ALA    95      49.950  73.000   7.331  1.00 80.28           C  
ATOM   2144  C   ALA    95      49.831  74.514   7.392  1.00 79.73           C  
ATOM   2145  O   ALA    95      49.824  75.193   6.372  1.00 79.34           O  
ATOM   2146  CB  ALA    95      48.655  72.348   7.741  1.00 80.26           C  
ATOM   2147  N   LEU    96      49.761  75.025   8.612  1.00 79.10           N  
ATOM   2148  CA  LEU    96      49.730  76.452   8.869  1.00 78.60           C  
ATOM   2149  C   LEU    96      50.927  77.196   8.233  1.00 78.27           C  
ATOM   2150  O   LEU    96      50.807  78.337   7.773  1.00 77.92           O  
ATOM   2151  CB  LEU    96      49.723  76.631  10.386  1.00 78.42           C  
ATOM   2152  CG  LEU    96      49.111  77.866  11.030  1.00 78.09           C  
ATOM   2153  CD1 LEU    96      48.036  78.478  10.159  1.00 77.95           C  
ATOM   2154  CD2 LEU    96      48.558  77.469  12.379  1.00 77.13           C  
ATOM   2155  N   ASN    97      52.076  76.527   8.217  1.00 77.88           N  
ATOM   2156  CA  ASN    97      53.311  77.119   7.753  1.00 77.73           C  
ATOM   2157  C   ASN    97      53.400  77.172   6.246  1.00 77.39           C  
ATOM   2158  O   ASN    97      54.012  78.082   5.694  1.00 77.37           O  
ATOM   2159  CB  ASN    97      54.512  76.366   8.319  1.00 77.92           C  
ATOM   2160  CG  ASN    97      54.996  76.943   9.635  1.00 78.53           C  
ATOM   2161  OD1 ASN    97      55.805  76.323  10.329  1.00 79.28           O  
ATOM   2162  ND2 ASN    97      54.512  78.137   9.985  1.00 78.73           N  
ATOM   2163  N   LYS    98      52.801  76.187   5.583  1.00 76.93           N  
ATOM   2164  CA  LYS    98      52.710  76.196   4.124  1.00 76.24           C  
ATOM   2165  C   LYS    98      51.789  77.323   3.664  1.00 76.03           C  
ATOM   2166  O   LYS    98      51.972  77.874   2.579  1.00 76.19           O  
ATOM   2167  CB  LYS    98      52.234  74.840   3.588  1.00 76.26           C  
ATOM   2168  CG  LYS    98      53.328  73.774   3.541  1.00 75.92           C  
ATOM   2169  CD  LYS    98      52.787  72.358   3.344  1.00 75.87           C  
ATOM   2170  CE  LYS    98      52.095  71.855   4.606  1.00 76.31           C  
ATOM   2171  NZ  LYS    98      52.580  70.522   5.076  1.00 76.48           N  
ATOM   2172  N   ALA    99      50.811  77.662   4.502  1.00 75.67           N  
ATOM   2173  CA  ALA    99      49.934  78.804   4.269  1.00 75.44           C  
ATOM   2174  C   ALA    99      50.624  80.111   4.660  1.00 75.42           C  
ATOM   2175  O   ALA    99      50.207  81.192   4.233  1.00 75.32           O  
ATOM   2176  CB  ALA    99      48.633  78.641   5.030  1.00 75.42           C  
ATOM   2177  N   GLY   100      51.670  80.003   5.479  1.00 75.27           N  
ATOM   2178  CA  GLY   100      52.513  81.147   5.822  1.00 74.98           C  
ATOM   2179  C   GLY   100      52.128  81.881   7.093  1.00 74.87           C  
ATOM   2180  O   GLY   100      52.148  83.114   7.126  1.00 74.67           O  
ATOM   2181  N   TYR   101      51.781  81.129   8.138  1.00 74.73           N  
ATOM   2182  CA  TYR   101      51.436  81.722   9.425  1.00 74.59           C  
ATOM   2183  C   TYR   101      52.349  81.225  10.526  1.00 74.86           C  
ATOM   2184  O   TYR   101      52.516  80.017  10.707  1.00 74.76           O  
ATOM   2185  CB  TYR   101      50.001  81.396   9.796  1.00 74.36           C  
ATOM   2186  CG  TYR   101      48.964  82.095   8.967  1.00 73.95           C  
ATOM   2187  CD1 TYR   101      48.368  83.266   9.417  1.00 73.86           C  
ATOM   2188  CD2 TYR   101      48.559  81.575   7.737  1.00 73.74           C  
ATOM   2189  CE1 TYR   101      47.401  83.915   8.658  1.00 74.17           C  
ATOM   2190  CE2 TYR   101      47.593  82.214   6.969  1.00 73.77           C  
ATOM   2191  CZ  TYR   101      47.020  83.385   7.434  1.00 74.11           C  
ATOM   2192  OH  TYR   101      46.066  84.031   6.679  1.00 74.13           O  
ATOM   2193  N   GLN   102      52.940  82.166  11.258  1.00 75.23           N  
ATOM   2194  CA  GLN   102      53.738  81.844  12.441  1.00 75.47           C  
ATOM   2195  C   GLN   102      52.784  81.400  13.541  1.00 75.57           C  
ATOM   2196  O   GLN   102      51.637  81.854  13.593  1.00 75.49           O  
ATOM   2197  CB  GLN   102      54.579  83.049  12.885  1.00 75.36           C  
ATOM   2198  N   LEU   103      53.251  80.505  14.404  1.00 75.93           N  
ATOM   2199  CA  LEU   103      52.373  79.886  15.404  1.00 76.44           C  
ATOM   2200  C   LEU   103      52.726  80.233  16.848  1.00 76.58           C  
ATOM   2201  O   LEU   103      53.607  79.619  17.452  1.00 76.58           O  
ATOM   2202  CB  LEU   103      52.312  78.370  15.200  1.00 76.25           C  
ATOM   2203  CG  LEU   103      51.753  77.551  16.354  1.00 76.96           C  
ATOM   2204  CD1 LEU   103      50.597  76.658  15.909  1.00 77.99           C  
ATOM   2205  CD2 LEU   103      52.879  76.743  16.987  1.00 78.03           C  
ATOM   2206  N   LEU   104      52.028  81.232  17.382  1.00 76.98           N  
ATOM   2207  CA  LEU   104      52.191  81.659  18.772  1.00 77.25           C  
ATOM   2208  C   LEU   104      51.404  80.720  19.685  1.00 77.34           C  
ATOM   2209  O   LEU   104      50.200  80.545  19.496  1.00 77.33           O  
ATOM   2210  CB  LEU   104      51.702  83.104  18.937  1.00 77.19           C  
ATOM   2211  N   LEU   105      52.068  80.094  20.655  1.00 77.63           N  
ATOM   2212  CA  LEU   105      51.348  79.161  21.538  1.00 78.04           C  
ATOM   2213  C   LEU   105      51.460  79.438  23.026  1.00 78.18           C  
ATOM   2214  O   LEU   105      51.963  80.487  23.423  1.00 78.14           O  
ATOM   2215  CB  LEU   105      51.617  77.676  21.209  1.00 78.03           C  
ATOM   2216  CG  LEU   105      52.910  76.947  21.532  1.00 77.24           C  
ATOM   2217  CD1 LEU   105      52.633  75.462  21.463  1.00 75.82           C  
ATOM   2218  CD2 LEU   105      53.979  77.343  20.534  1.00 76.89           C  
ATOM   2219  N   GLY   106      50.943  78.515  23.835  1.00 78.44           N  
ATOM   2220  CA  GLY   106      50.848  78.730  25.270  1.00 78.68           C  
ATOM   2221  C   GLY   106      50.420  77.497  26.020  1.00 78.85           C  
ATOM   2222  O   GLY   106      49.593  76.726  25.549  1.00 78.75           O  
ATOM   2223  N   TYR   107      51.000  77.325  27.197  1.00 79.29           N  
ATOM   2224  CA  TYR   107      50.712  76.199  28.044  1.00 80.09           C  
ATOM   2225  C   TYR   107      49.837  76.638  29.199  1.00 80.64           C  
ATOM   2226  O   TYR   107      50.132  77.624  29.869  1.00 80.55           O  
ATOM   2227  CB  TYR   107      52.011  75.670  28.607  1.00 80.24           C  
ATOM   2228  CG  TYR   107      51.937  74.259  29.117  1.00 80.88           C  
ATOM   2229  CD1 TYR   107      52.073  73.185  28.233  1.00 81.29           C  
ATOM   2230  CD2 TYR   107      51.759  73.986  30.482  1.00 80.68           C  
ATOM   2231  CE1 TYR   107      52.038  71.876  28.678  1.00 81.13           C  
ATOM   2232  CE2 TYR   107      51.710  72.665  30.947  1.00 80.59           C  
ATOM   2233  CZ  TYR   107      51.853  71.618  30.027  1.00 81.06           C  
ATOM   2234  OH  TYR   107      51.807  70.303  30.423  1.00 81.11           O  
ATOM   2235  N   SER   108      48.760  75.897  29.434  1.00 81.48           N  
ATOM   2236  CA  SER   108      47.944  76.081  30.631  1.00 81.83           C  
ATOM   2237  C   SER   108      47.770  74.734  31.295  1.00 82.04           C  
ATOM   2238  O   SER   108      47.041  73.887  30.786  1.00 81.98           O  
ATOM   2239  CB  SER   108      46.568  76.648  30.276  1.00 82.01           C  
ATOM   2240  OG  SER   108      45.611  75.611  30.094  1.00 81.96           O  
ATOM   2241  N   ASP   109      48.453  74.528  32.414  1.00 82.52           N  
ATOM   2242  CA  ASP   109      48.228  73.356  33.248  1.00 83.03           C  
ATOM   2243  C   ASP   109      46.733  73.171  33.403  1.00 83.40           C  
ATOM   2244  O   ASP   109      46.158  73.614  34.397  1.00 83.57           O  
ATOM   2245  CB  ASP   109      48.850  73.565  34.632  1.00 83.08           C  
ATOM   2246  CG  ASP   109      50.091  72.736  34.852  1.00 83.07           C  
ATOM   2247  OD1 ASP   109      50.689  72.870  35.938  1.00 82.19           O  
ATOM   2248  OD2 ASP   109      50.461  71.946  33.956  1.00 84.02           O  
ATOM   2249  N   TYR   110      46.099  72.556  32.406  1.00 83.90           N  
ATOM   2250  CA  TYR   110      44.644  72.418  32.380  1.00 84.39           C  
ATOM   2251  C   TYR   110      43.954  73.571  33.141  1.00 84.01           C  
ATOM   2252  O   TYR   110      43.148  73.323  34.038  1.00 84.11           O  
ATOM   2253  CB  TYR   110      44.256  71.062  32.990  1.00 85.46           C  
ATOM   2254  CG  TYR   110      44.167  69.892  32.028  1.00 86.39           C  
ATOM   2255  CD1 TYR   110      43.451  68.731  32.377  1.00 88.11           C  
ATOM   2256  CD2 TYR   110      44.775  69.942  30.778  1.00 86.99           C  
ATOM   2257  CE1 TYR   110      43.356  67.644  31.494  1.00 89.23           C  
ATOM   2258  CE2 TYR   110      44.683  68.878  29.880  1.00 88.26           C  
ATOM   2259  CZ  TYR   110      43.980  67.730  30.234  1.00 88.95           C  
ATOM   2260  OH  TYR   110      43.910  66.682  29.326  1.00 88.28           O  
ATOM   2261  N   SER   111      44.287  74.821  32.809  1.00 83.45           N  
ATOM   2262  CA  SER   111      43.785  75.969  33.578  1.00 82.93           C  
ATOM   2263  C   SER   111      42.975  76.969  32.771  1.00 82.79           C  
ATOM   2264  O   SER   111      43.508  77.675  31.914  1.00 82.84           O  
ATOM   2265  CB  SER   111      44.920  76.701  34.294  1.00 82.92           C  
ATOM   2266  OG  SER   111      44.437  77.893  34.896  1.00 82.27           O  
ATOM   2267  N   ILE   112      41.687  77.043  33.073  1.00 82.55           N  
ATOM   2268  CA  ILE   112      40.819  78.039  32.466  1.00 82.51           C  
ATOM   2269  C   ILE   112      41.275  79.459  32.837  1.00 82.56           C  
ATOM   2270  O   ILE   112      41.142  80.388  32.036  1.00 82.61           O  
ATOM   2271  CB  ILE   112      39.344  77.823  32.868  1.00 82.53           C  
ATOM   2272  CG1 ILE   112      39.191  77.823  34.395  1.00 82.91           C  
ATOM   2273  CG2 ILE   112      38.812  76.516  32.271  1.00 82.32           C  
ATOM   2274  CD1 ILE   112      37.809  78.227  34.891  1.00 83.59           C  
ATOM   2275  N   GLU   113      41.827  79.607  34.045  1.00 82.47           N  
ATOM   2276  CA  GLU   113      42.247  80.907  34.577  1.00 82.23           C  
ATOM   2277  C   GLU   113      43.539  81.422  33.924  1.00 82.15           C  
ATOM   2278  O   GLU   113      43.615  82.599  33.536  1.00 82.07           O  
ATOM   2279  CB  GLU   113      42.389  80.847  36.106  1.00 82.12           C  
ATOM   2280  N   GLN   114      44.543  80.545  33.808  1.00 81.92           N  
ATOM   2281  CA  GLN   114      45.823  80.892  33.175  1.00 81.67           C  
ATOM   2282  C   GLN   114      45.618  81.159  31.692  1.00 81.48           C  
ATOM   2283  O   GLN   114      46.235  82.059  31.127  1.00 81.36           O  
ATOM   2284  CB  GLN   114      46.866  79.788  33.376  1.00 81.69           C  
ATOM   2285  N   GLU   115      44.738  80.365  31.084  1.00 81.35           N  
ATOM   2286  CA  GLU   115      44.268  80.560  29.713  1.00 81.20           C  
ATOM   2287  C   GLU   115      43.864  82.013  29.439  1.00 81.00           C  
ATOM   2288  O   GLU   115      44.206  82.570  28.396  1.00 80.85           O  
ATOM   2289  CB  GLU   115      43.085  79.635  29.455  1.00 81.14           C  
ATOM   2290  CG  GLU   115      42.639  79.574  28.018  1.00 81.89           C  
ATOM   2291  CD  GLU   115      41.362  78.782  27.854  1.00 83.45           C  
ATOM   2292  OE1 GLU   115      40.333  79.180  28.452  1.00 83.74           O  
ATOM   2293  OE2 GLU   115      41.390  77.763  27.123  1.00 84.55           O  
ATOM   2294  N   GLU   116      43.127  82.605  30.379  1.00 80.81           N  
ATOM   2295  CA  GLU   116      42.815  84.031  30.367  1.00 80.68           C  
ATOM   2296  C   GLU   116      44.074  84.899  30.385  1.00 80.55           C  
ATOM   2297  O   GLU   116      44.409  85.539  29.376  1.00 80.38           O  
ATOM   2298  CB  GLU   116      41.961  84.387  31.577  1.00 80.76           C  
ATOM   2299  CG  GLU   116      40.498  84.522  31.299  1.00 80.66           C  
ATOM   2300  CD  GLU   116      39.763  85.078  32.487  1.00 80.62           C  
ATOM   2301  OE1 GLU   116      40.232  86.086  33.063  1.00 80.57           O  
ATOM   2302  OE2 GLU   116      38.713  84.513  32.843  1.00 80.61           O  
ATOM   2303  N   LYS   117      44.760  84.921  31.535  1.00 80.26           N  
ATOM   2304  CA  LYS   117      46.010  85.668  31.687  1.00 80.03           C  
ATOM   2305  C   LYS   117      46.824  85.614  30.377  1.00 80.00           C  
ATOM   2306  O   LYS   117      47.229  86.658  29.843  1.00 80.11           O  
ATOM   2307  CB  LYS   117      46.819  85.142  32.880  1.00 79.64           C  
ATOM   2308  N   LEU   118      47.003  84.397  29.849  1.00 79.65           N  
ATOM   2309  CA  LEU   118      47.718  84.159  28.591  1.00 79.10           C  
ATOM   2310  C   LEU   118      46.980  84.693  27.355  1.00 78.74           C  
ATOM   2311  O   LEU   118      47.507  85.553  26.652  1.00 78.73           O  
ATOM   2312  CB  LEU   118      48.060  82.670  28.427  1.00 79.06           C  
ATOM   2313  N   LEU   119      45.771  84.197  27.095  1.00 78.31           N  
ATOM   2314  CA  LEU   119      45.033  84.592  25.892  1.00 78.10           C  
ATOM   2315  C   LEU   119      45.044  86.103  25.727  1.00 77.97           C  
ATOM   2316  O   LEU   119      45.298  86.614  24.631  1.00 77.79           O  
ATOM   2317  CB  LEU   119      43.591  84.065  25.911  1.00 78.00           C  
ATOM   2318  N   SER   120      44.795  86.803  26.835  1.00 77.94           N  
ATOM   2319  CA  SER   120      44.726  88.258  26.855  1.00 77.90           C  
ATOM   2320  C   SER   120      45.905  88.840  26.096  1.00 77.85           C  
ATOM   2321  O   SER   120      45.718  89.517  25.084  1.00 77.87           O  
ATOM   2322  CB  SER   120      44.698  88.782  28.294  1.00 77.89           C  
ATOM   2323  N   THR   121      47.111  88.533  26.575  1.00 77.76           N  
ATOM   2324  CA  THR   121      48.355  88.997  25.963  1.00 77.75           C  
ATOM   2325  C   THR   121      48.344  88.758  24.452  1.00 77.54           C  
ATOM   2326  O   THR   121      48.592  89.683  23.670  1.00 77.62           O  
ATOM   2327  CB  THR   121      49.606  88.298  26.579  1.00 77.90           C  
ATOM   2328  OG1 THR   121      49.306  87.811  27.895  1.00 78.26           O  
ATOM   2329  CG2 THR   121      50.802  89.258  26.637  1.00 77.53           C  
ATOM   2330  N   PHE   122      48.038  87.522  24.055  1.00 77.21           N  
ATOM   2331  CA  PHE   122      48.031  87.136  22.645  1.00 77.00           C  
ATOM   2332  C   PHE   122      47.154  88.080  21.826  1.00 76.92           C  
ATOM   2333  O   PHE   122      47.615  88.711  20.869  1.00 76.53           O  
ATOM   2334  CB  PHE   122      47.543  85.693  22.475  1.00 76.79           C  
ATOM   2335  CG  PHE   122      48.515  84.644  22.962  1.00 76.82           C  
ATOM   2336  CD1 PHE   122      49.739  84.446  22.324  1.00 77.17           C  
ATOM   2337  CD2 PHE   122      48.191  83.827  24.042  1.00 76.21           C  
ATOM   2338  CE1 PHE   122      50.633  83.461  22.776  1.00 76.99           C  
ATOM   2339  CE2 PHE   122      49.069  82.845  24.491  1.00 75.67           C  
ATOM   2340  CZ  PHE   122      50.288  82.663  23.857  1.00 76.05           C  
ATOM   2341  N   LEU   123      45.891  88.173  22.230  1.00 76.97           N  
ATOM   2342  CA  LEU   123      44.917  89.018  21.564  1.00 76.96           C  
ATOM   2343  C   LEU   123      45.412  90.465  21.457  1.00 77.02           C  
ATOM   2344  O   LEU   123      45.308  91.083  20.393  1.00 76.98           O  
ATOM   2345  CB  LEU   123      43.571  88.936  22.292  1.00 76.85           C  
ATOM   2346  N   GLU   124      45.981  90.982  22.547  1.00 77.12           N  
ATOM   2347  CA  GLU   124      46.488  92.362  22.601  1.00 77.27           C  
ATOM   2348  C   GLU   124      47.697  92.601  21.687  1.00 77.40           C  
ATOM   2349  O   GLU   124      48.242  93.707  21.643  1.00 77.22           O  
ATOM   2350  CB  GLU   124      46.839  92.748  24.045  1.00 77.16           C  
ATOM   2351  N   SER   125      48.091  91.563  20.949  1.00 77.69           N  
ATOM   2352  CA  SER   125      49.311  91.571  20.143  1.00 77.82           C  
ATOM   2353  C   SER   125      49.043  91.677  18.636  1.00 77.79           C  
ATOM   2354  O   SER   125      49.388  92.679  18.006  1.00 77.81           O  
ATOM   2355  CB  SER   125      50.151  90.325  20.463  1.00 77.81           C  
ATOM   2356  OG  SER   125      51.121  90.078  19.463  1.00 78.12           O  
ATOM   2357  N   ARG   126      48.446  90.631  18.069  1.00 77.84           N  
ATOM   2358  CA  ARG   126      48.179  90.554  16.633  1.00 77.85           C  
ATOM   2359  C   ARG   126      46.932  89.704  16.366  1.00 77.80           C  
ATOM   2360  O   ARG   126      46.707  88.699  17.052  1.00 77.48           O  
ATOM   2361  CB  ARG   126      49.398  89.996  15.879  1.00 77.88           C  
ATOM   2362  N   PRO   127      46.130  90.106  15.357  1.00 77.81           N  
ATOM   2363  CA  PRO   127      44.809  89.524  15.099  1.00 77.75           C  
ATOM   2364  C   PRO   127      44.822  88.030  14.732  1.00 77.71           C  
ATOM   2365  O   PRO   127      44.996  87.175  15.605  1.00 77.50           O  
ATOM   2366  CB  PRO   127      44.268  90.368  13.924  1.00 77.79           C  
ATOM   2367  CG  PRO   127      45.141  91.579  13.850  1.00 77.76           C  
ATOM   2368  CD  PRO   127      46.466  91.162  14.379  1.00 77.80           C  
ATOM   2369  N   ALA   128      44.651  87.750  13.438  1.00 77.80           N  
ATOM   2370  CA  ALA   128      44.354  86.417  12.894  1.00 77.74           C  
ATOM   2371  C   ALA   128      43.229  85.716  13.658  1.00 77.90           C  
ATOM   2372  O   ALA   128      42.241  86.353  14.034  1.00 77.82           O  
ATOM   2373  CB  ALA   128      45.611  85.556  12.807  1.00 77.56           C  
ATOM   2374  N   GLY   129      43.375  84.408  13.865  1.00 78.04           N  
ATOM   2375  CA  GLY   129      42.442  83.637  14.675  1.00 78.06           C  
ATOM   2376  C   GLY   129      43.176  82.886  15.765  1.00 78.22           C  
ATOM   2377  O   GLY   129      44.402  82.801  15.751  1.00 78.35           O  
ATOM   2378  N   VAL   130      42.424  82.335  16.709  1.00 78.36           N  
ATOM   2379  CA  VAL   130      42.996  81.570  17.810  1.00 78.47           C  
ATOM   2380  C   VAL   130      42.282  80.225  17.955  1.00 78.73           C  
ATOM   2381  O   VAL   130      41.078  80.127  17.714  1.00 78.85           O  
ATOM   2382  CB  VAL   130      42.961  82.384  19.136  1.00 78.50           C  
ATOM   2383  CG1 VAL   130      41.597  83.036  19.350  1.00 78.46           C  
ATOM   2384  CG2 VAL   130      43.367  81.531  20.339  1.00 78.02           C  
ATOM   2385  N   VAL   131      43.025  79.191  18.345  1.00 78.91           N  
ATOM   2386  CA  VAL   131      42.456  77.844  18.458  1.00 79.10           C  
ATOM   2387  C   VAL   131      42.680  77.258  19.848  1.00 79.16           C  
ATOM   2388  O   VAL   131      43.788  77.310  20.378  1.00 79.16           O  
ATOM   2389  CB  VAL   131      42.949  76.905  17.316  1.00 79.01           C  
ATOM   2390  CG1 VAL   131      44.387  77.189  16.976  1.00 79.69           C  
ATOM   2391  CG2 VAL   131      42.766  75.446  17.670  1.00 79.09           C  
ATOM   2392  N   LEU   132      41.605  76.717  20.424  1.00 79.37           N  
ATOM   2393  CA  LEU   132      41.578  76.304  21.827  1.00 79.76           C  
ATOM   2394  C   LEU   132      41.049  74.894  22.053  1.00 79.97           C  
ATOM   2395  O   LEU   132      40.119  74.447  21.378  1.00 80.05           O  
ATOM   2396  CB  LEU   132      40.717  77.266  22.644  1.00 79.69           C  
ATOM   2397  CG  LEU   132      41.098  78.741  22.703  1.00 79.74           C  
ATOM   2398  CD1 LEU   132      40.214  79.418  23.725  1.00 80.08           C  
ATOM   2399  CD2 LEU   132      42.565  78.928  23.055  1.00 79.42           C  
ATOM   2400  N   PHE   133      41.633  74.216  23.033  1.00 80.04           N  
ATOM   2401  CA  PHE   133      41.185  72.898  23.429  1.00 80.28           C  
ATOM   2402  C   PHE   133      40.108  73.003  24.494  1.00 80.56           C  
ATOM   2403  O   PHE   133      40.110  73.941  25.293  1.00 80.66           O  
ATOM   2404  CB  PHE   133      42.371  72.102  23.948  1.00 80.49           C  
ATOM   2405  CG  PHE   133      43.274  71.621  22.868  1.00 80.30           C  
ATOM   2406  CD1 PHE   133      43.353  70.268  22.567  1.00 80.61           C  
ATOM   2407  CD2 PHE   133      44.031  72.518  22.128  1.00 81.02           C  
ATOM   2408  CE1 PHE   133      44.188  69.799  21.548  1.00 81.06           C  
ATOM   2409  CE2 PHE   133      44.861  72.067  21.098  1.00 82.01           C  
ATOM   2410  CZ  PHE   133      44.940  70.699  20.811  1.00 81.89           C  
ATOM   2411  N   GLY   134      39.181  72.045  24.491  1.00 80.85           N  
ATOM   2412  CA  GLY   134      38.109  71.982  25.489  1.00 80.82           C  
ATOM   2413  C   GLY   134      37.007  73.003  25.278  1.00 80.96           C  
ATOM   2414  O   GLY   134      37.208  74.041  24.650  1.00 80.88           O  
ATOM   2415  N   SER   135      35.829  72.704  25.807  1.00 81.18           N  
ATOM   2416  CA  SER   135      34.695  73.602  25.680  1.00 81.05           C  
ATOM   2417  C   SER   135      34.586  74.526  26.882  1.00 80.93           C  
ATOM   2418  O   SER   135      34.092  75.645  26.753  1.00 81.16           O  
ATOM   2419  CB  SER   135      33.404  72.809  25.510  1.00 81.09           C  
ATOM   2420  OG  SER   135      32.276  73.635  25.761  1.00 81.64           O  
ATOM   2421  N   GLU   136      35.028  74.052  28.047  1.00 80.75           N  
ATOM   2422  CA  GLU   136      34.955  74.830  29.286  1.00 80.69           C  
ATOM   2423  C   GLU   136      35.961  75.971  29.239  1.00 80.73           C  
ATOM   2424  O   GLU   136      37.146  75.731  29.002  1.00 81.00           O  
ATOM   2425  CB  GLU   136      35.211  73.942  30.506  1.00 80.45           C  
ATOM   2426  N   HIS   137      35.481  77.205  29.433  1.00 80.79           N  
ATOM   2427  CA  HIS   137      36.324  78.419  29.372  1.00 80.69           C  
ATOM   2428  C   HIS   137      35.913  79.509  30.365  1.00 80.60           C  
ATOM   2429  O   HIS   137      35.260  79.225  31.369  1.00 80.58           O  
ATOM   2430  CB  HIS   137      36.395  78.980  27.944  1.00 80.70           C  
ATOM   2431  CG  HIS   137      36.929  78.002  26.947  1.00 80.78           C  
ATOM   2432  ND1 HIS   137      38.248  77.600  26.933  1.00 80.45           N  
ATOM   2433  CD2 HIS   137      36.317  77.320  25.951  1.00 81.04           C  
ATOM   2434  CE1 HIS   137      38.427  76.721  25.963  1.00 81.19           C  
ATOM   2435  NE2 HIS   137      37.269  76.532  25.355  1.00 81.73           N  
ATOM   2436  N   SER   138      36.293  80.752  30.078  1.00 80.51           N  
ATOM   2437  CA  SER   138      36.219  81.824  31.070  1.00 80.52           C  
ATOM   2438  C   SER   138      35.430  83.028  30.571  1.00 80.55           C  
ATOM   2439  O   SER   138      35.549  83.411  29.405  1.00 80.87           O  
ATOM   2440  CB  SER   138      37.632  82.282  31.421  1.00 80.48           C  
ATOM   2441  OG  SER   138      38.611  81.466  30.794  1.00 80.51           O  
ATOM   2442  N   GLN   139      34.647  83.641  31.459  1.00 80.23           N  
ATOM   2443  CA  GLN   139      33.923  84.869  31.127  1.00 79.89           C  
ATOM   2444  C   GLN   139      34.812  85.814  30.321  1.00 79.71           C  
ATOM   2445  O   GLN   139      34.462  86.202  29.210  1.00 79.58           O  
ATOM   2446  CB  GLN   139      33.409  85.563  32.392  1.00 79.92           C  
ATOM   2447  N   ARG   140      35.978  86.145  30.867  1.00 79.60           N  
ATOM   2448  CA  ARG   140      36.902  87.054  30.199  1.00 79.65           C  
ATOM   2449  C   ARG   140      37.416  86.529  28.859  1.00 79.76           C  
ATOM   2450  O   ARG   140      37.629  87.318  27.940  1.00 79.77           O  
ATOM   2451  CB  ARG   140      38.064  87.445  31.114  1.00 79.45           C  
ATOM   2452  N   THR   141      37.620  85.217  28.735  1.00 79.92           N  
ATOM   2453  CA  THR   141      37.982  84.667  27.428  1.00 80.22           C  
ATOM   2454  C   THR   141      36.786  84.818  26.507  1.00 80.34           C  
ATOM   2455  O   THR   141      36.883  85.431  25.446  1.00 80.34           O  
ATOM   2456  CB  THR   141      38.474  83.175  27.447  1.00 80.32           C  
ATOM   2457  OG1 THR   141      37.567  82.350  28.191  1.00 80.43           O  
ATOM   2458  CG2 THR   141      39.886  83.055  28.023  1.00 80.28           C  
ATOM   2459  N   HIS   142      35.648  84.288  26.943  1.00 80.60           N  
ATOM   2460  CA  HIS   142      34.422  84.361  26.172  1.00 81.02           C  
ATOM   2461  C   HIS   142      34.151  85.794  25.730  1.00 81.36           C  
ATOM   2462  O   HIS   142      33.628  86.014  24.637  1.00 81.61           O  
ATOM   2463  CB  HIS   142      33.239  83.820  26.976  1.00 81.02           C  
ATOM   2464  CG  HIS   142      33.238  82.331  27.131  1.00 80.89           C  
ATOM   2465  ND1 HIS   142      33.105  81.471  26.062  1.00 80.95           N  
ATOM   2466  CD2 HIS   142      33.328  81.550  28.234  1.00 80.66           C  
ATOM   2467  CE1 HIS   142      33.129  80.224  26.499  1.00 81.37           C  
ATOM   2468  NE2 HIS   142      33.261  80.244  27.814  1.00 80.89           N  
ATOM   2469  N   GLN   143      34.509  86.760  26.577  1.00 81.50           N  
ATOM   2470  CA  GLN   143      34.430  88.166  26.203  1.00 81.69           C  
ATOM   2471  C   GLN   143      35.481  88.435  25.136  1.00 81.85           C  
ATOM   2472  O   GLN   143      35.164  88.437  23.950  1.00 81.76           O  
ATOM   2473  CB  GLN   143      34.620  89.089  27.413  1.00 81.65           C  
ATOM   2474  N   LEU   144      36.732  88.606  25.562  1.00 82.17           N  
ATOM   2475  CA  LEU   144      37.842  88.930  24.664  1.00 82.38           C  
ATOM   2476  C   LEU   144      37.687  88.287  23.284  1.00 82.63           C  
ATOM   2477  O   LEU   144      37.574  88.994  22.285  1.00 82.58           O  
ATOM   2478  CB  LEU   144      39.185  88.552  25.297  1.00 82.22           C  
ATOM   2479  N   LEU   145      37.643  86.954  23.245  1.00 82.96           N  
ATOM   2480  CA  LEU   145      37.533  86.201  21.992  1.00 83.27           C  
ATOM   2481  C   LEU   145      36.392  86.719  21.103  1.00 83.56           C  
ATOM   2482  O   LEU   145      36.633  87.189  19.984  1.00 83.60           O  
ATOM   2483  CB  LEU   145      37.396  84.692  22.265  1.00 83.02           C  
ATOM   2484  N   GLU   146      35.162  86.654  21.613  1.00 83.94           N  
ATOM   2485  CA  GLU   146      33.975  87.060  20.847  1.00 84.23           C  
ATOM   2486  C   GLU   146      33.827  88.579  20.756  1.00 84.35           C  
ATOM   2487  O   GLU   146      33.075  89.086  19.917  1.00 84.46           O  
ATOM   2488  CB  GLU   146      32.703  86.432  21.430  1.00 84.36           C  
ATOM   2489  N   ALA   147      34.539  89.291  21.629  1.00 84.44           N  
ATOM   2490  CA  ALA   147      34.620  90.749  21.573  1.00 84.44           C  
ATOM   2491  C   ALA   147      35.611  91.162  20.491  1.00 84.47           C  
ATOM   2492  O   ALA   147      35.467  92.221  19.881  1.00 84.50           O  
ATOM   2493  CB  ALA   147      35.032  91.319  22.925  1.00 84.37           C  
ATOM   2494  N   SER   148      36.603  90.307  20.251  1.00 84.47           N  
ATOM   2495  CA  SER   148      37.626  90.534  19.231  1.00 84.47           C  
ATOM   2496  C   SER   148      37.141  90.243  17.803  1.00 84.55           C  
ATOM   2497  O   SER   148      37.855  90.523  16.832  1.00 84.50           O  
ATOM   2498  CB  SER   148      38.865  89.690  19.543  1.00 84.45           C  
ATOM   2499  OG  SER   148      39.876  89.866  18.567  1.00 84.27           O  
ATOM   2500  N   ASN   149      35.937  89.678  17.686  1.00 84.58           N  
ATOM   2501  CA  ASN   149      35.347  89.277  16.398  1.00 84.53           C  
ATOM   2502  C   ASN   149      36.227  88.342  15.548  1.00 84.51           C  
ATOM   2503  O   ASN   149      35.811  87.892  14.476  1.00 84.60           O  
ATOM   2504  CB  ASN   149      34.871  90.493  15.592  1.00 84.46           C  
ATOM   2505  N   THR   150      37.433  88.056  16.043  1.00 84.39           N  
ATOM   2506  CA  THR   150      38.348  87.104  15.413  1.00 84.21           C  
ATOM   2507  C   THR   150      37.834  85.677  15.594  1.00 84.06           C  
ATOM   2508  O   THR   150      37.134  85.396  16.571  1.00 83.91           O  
ATOM   2509  CB  THR   150      39.765  87.199  16.004  1.00 84.22           C  
ATOM   2510  OG1 THR   150      39.697  87.069  17.428  1.00 84.14           O  
ATOM   2511  CG2 THR   150      40.419  88.529  15.633  1.00 84.28           C  
ATOM   2512  N   PRO   151      38.185  84.773  14.657  1.00 84.05           N  
ATOM   2513  CA  PRO   151      37.658  83.399  14.618  1.00 84.01           C  
ATOM   2514  C   PRO   151      38.306  82.435  15.625  1.00 83.83           C  
ATOM   2515  O   PRO   151      39.492  82.568  15.936  1.00 83.74           O  
ATOM   2516  CB  PRO   151      37.958  82.944  13.178  1.00 84.13           C  
ATOM   2517  CG  PRO   151      38.579  84.156  12.469  1.00 84.11           C  
ATOM   2518  CD  PRO   151      39.126  85.015  13.548  1.00 83.98           C  
ATOM   2519  N   VAL   152      37.515  81.470  16.104  1.00 83.61           N  
ATOM   2520  CA  VAL   152      37.924  80.513  17.149  1.00 83.43           C  
ATOM   2521  C   VAL   152      37.639  79.054  16.777  1.00 83.25           C  
ATOM   2522  O   VAL   152      36.544  78.726  16.293  1.00 83.10           O  
ATOM   2523  CB  VAL   152      37.228  80.798  18.522  1.00 83.46           C  
ATOM   2524  CG1 VAL   152      38.055  81.736  19.387  1.00 83.44           C  
ATOM   2525  CG2 VAL   152      35.820  81.347  18.321  1.00 83.44           C  
ATOM   2526  N   LEU   153      38.620  78.184  17.027  1.00 83.03           N  
ATOM   2527  CA  LEU   153      38.447  76.734  16.837  1.00 82.86           C  
ATOM   2528  C   LEU   153      38.654  75.922  18.130  1.00 82.67           C  
ATOM   2529  O   LEU   153      39.779  75.746  18.609  1.00 82.81           O  
ATOM   2530  CB  LEU   153      39.372  76.205  15.728  1.00 82.99           C  
ATOM   2531  CG  LEU   153      39.002  74.945  14.921  1.00 82.76           C  
ATOM   2532  CD1 LEU   153      40.209  74.455  14.142  1.00 82.62           C  
ATOM   2533  CD2 LEU   153      38.473  73.818  15.769  1.00 83.07           C  
ATOM   2534  N   GLU   154      37.561  75.417  18.688  1.00 82.32           N  
ATOM   2535  CA  GLU   154      37.659  74.515  19.822  1.00 81.86           C  
ATOM   2536  C   GLU   154      38.007  73.118  19.332  1.00 81.16           C  
ATOM   2537  O   GLU   154      37.369  72.597  18.425  1.00 81.08           O  
ATOM   2538  CB  GLU   154      36.359  74.531  20.628  1.00 82.04           C  
ATOM   2539  CG  GLU   154      36.303  75.686  21.641  1.00 83.27           C  
ATOM   2540  CD  GLU   154      34.886  76.092  22.052  1.00 84.75           C  
ATOM   2541  OE1 GLU   154      33.964  76.045  21.200  1.00 85.08           O  
ATOM   2542  OE2 GLU   154      34.705  76.488  23.228  1.00 84.61           O  
ATOM   2543  N   ILE   155      39.056  72.530  19.889  1.00 80.58           N  
ATOM   2544  CA  ILE   155      39.269  71.103  19.707  1.00 80.18           C  
ATOM   2545  C   ILE   155      38.451  70.483  20.820  1.00 80.40           C  
ATOM   2546  O   ILE   155      38.919  70.335  21.953  1.00 80.38           O  
ATOM   2547  CB  ILE   155      40.744  70.663  19.801  1.00 80.03           C  
ATOM   2548  CG1 ILE   155      41.675  71.621  19.033  1.00 80.46           C  
ATOM   2549  CG2 ILE   155      40.899  69.223  19.333  1.00 78.46           C  
ATOM   2550  CD1 ILE   155      41.344  71.846  17.532  1.00 80.24           C  
ATOM   2551  N   ALA   156      37.206  70.172  20.480  1.00 80.44           N  
ATOM   2552  CA  ALA   156      36.202  69.778  21.437  1.00 81.04           C  
ATOM   2553  C   ALA   156      35.025  69.126  20.700  1.00 81.37           C  
ATOM   2554  O   ALA   156      34.869  69.328  19.489  1.00 81.22           O  
ATOM   2555  CB  ALA   156      35.742  70.993  22.249  1.00 81.17           C  
ATOM   2556  N   GLU   157      34.222  68.349  21.439  1.00 81.45           N  
ATOM   2557  CA  GLU   157      33.124  67.554  20.877  1.00 81.75           C  
ATOM   2558  C   GLU   157      31.935  68.439  20.608  1.00 81.75           C  
ATOM   2559  O   GLU   157      31.402  68.466  19.504  1.00 81.64           O  
ATOM   2560  CB  GLU   157      32.716  66.434  21.844  1.00 81.93           C  
ATOM   2561  CG  GLU   157      33.872  65.496  22.219  1.00 82.80           C  
ATOM   2562  CD  GLU   157      33.538  64.499  23.323  1.00 81.61           C  
ATOM   2563  OE1 GLU   157      33.578  64.889  24.514  1.00 80.54           O  
ATOM   2564  OE2 GLU   157      33.268  63.323  22.993  1.00 80.74           O  
ATOM   2565  N   LEU   158      31.522  69.148  21.649  1.00 82.07           N  
ATOM   2566  CA  LEU   158      30.516  70.185  21.555  1.00 82.27           C  
ATOM   2567  C   LEU   158      31.252  71.517  21.677  1.00 82.36           C  
ATOM   2568  O   LEU   158      32.365  71.563  22.220  1.00 82.34           O  
ATOM   2569  CB  LEU   158      29.460  70.003  22.657  1.00 82.22           C  
ATOM   2570  CG  LEU   158      29.671  70.449  24.118  1.00 82.26           C  
ATOM   2571  CD1 LEU   158      28.475  69.993  24.982  1.00 81.08           C  
ATOM   2572  CD2 LEU   158      31.000  69.984  24.741  1.00 81.66           C  
ATOM   2573  N   SER   159      30.650  72.588  21.166  1.00 82.50           N  
ATOM   2574  CA  SER   159      31.304  73.896  21.163  1.00 82.81           C  
ATOM   2575  C   SER   159      30.503  74.984  21.881  1.00 82.85           C  
ATOM   2576  O   SER   159      29.341  75.235  21.551  1.00 83.04           O  
ATOM   2577  CB  SER   159      31.614  74.328  19.733  1.00 82.74           C  
ATOM   2578  OG  SER   159      30.426  74.675  19.052  1.00 83.60           O  
ATOM   2579  N   SER   160      31.139  75.630  22.856  1.00 82.93           N  
ATOM   2580  CA  SER   160      30.540  76.749  23.580  1.00 83.14           C  
ATOM   2581  C   SER   160      30.296  77.913  22.625  1.00 83.33           C  
ATOM   2582  O   SER   160      30.729  77.863  21.473  1.00 83.49           O  
ATOM   2583  CB  SER   160      31.447  77.182  24.735  1.00 83.20           C  
ATOM   2584  OG  SER   160      32.739  77.553  24.278  1.00 83.09           O  
ATOM   2585  N   LYS   161      29.606  78.949  23.101  1.00 83.48           N  
ATOM   2586  CA  LYS   161      29.256  80.127  22.288  1.00 83.69           C  
ATOM   2587  C   LYS   161      29.030  79.795  20.800  1.00 83.73           C  
ATOM   2588  O   LYS   161      29.973  79.735  20.005  1.00 83.71           O  
ATOM   2589  CB  LYS   161      30.289  81.246  22.470  1.00 83.65           C  
ATOM   2590  N   ALA   162      27.757  79.599  20.455  1.00 83.80           N  
ATOM   2591  CA  ALA   162      27.294  79.051  19.164  1.00 83.79           C  
ATOM   2592  C   ALA   162      28.199  79.233  17.940  1.00 83.72           C  
ATOM   2593  O   ALA   162      28.488  78.267  17.225  1.00 83.78           O  
ATOM   2594  CB  ALA   162      25.865  79.541  18.857  1.00 83.86           C  
ATOM   2595  N   SER   163      28.641  80.469  17.713  1.00 83.56           N  
ATOM   2596  CA  SER   163      29.419  80.821  16.527  1.00 83.41           C  
ATOM   2597  C   SER   163      30.926  80.549  16.697  1.00 83.37           C  
ATOM   2598  O   SER   163      31.769  81.378  16.337  1.00 83.23           O  
ATOM   2599  CB  SER   163      29.153  82.280  16.145  1.00 83.39           C  
ATOM   2600  OG  SER   163      28.983  82.424  14.745  1.00 83.39           O  
ATOM   2601  N   TYR   164      31.245  79.380  17.250  1.00 83.33           N  
ATOM   2602  CA  TYR   164      32.618  78.893  17.361  1.00 83.28           C  
ATOM   2603  C   TYR   164      32.804  77.750  16.364  1.00 83.07           C  
ATOM   2604  O   TYR   164      31.977  76.830  16.316  1.00 82.87           O  
ATOM   2605  CB  TYR   164      32.881  78.380  18.781  1.00 83.59           C  
ATOM   2606  CG  TYR   164      33.219  79.427  19.834  1.00 83.74           C  
ATOM   2607  CD1 TYR   164      32.826  80.760  19.698  1.00 83.83           C  
ATOM   2608  CD2 TYR   164      33.905  79.063  20.994  1.00 83.60           C  
ATOM   2609  CE1 TYR   164      33.141  81.710  20.678  1.00 84.42           C  
ATOM   2610  CE2 TYR   164      34.217  79.998  21.981  1.00 83.95           C  
ATOM   2611  CZ  TYR   164      33.837  81.318  21.819  1.00 84.30           C  
ATOM   2612  OH  TYR   164      34.151  82.244  22.796  1.00 84.43           O  
ATOM   2613  N   LEU   165      33.870  77.819  15.561  1.00 82.85           N  
ATOM   2614  CA  LEU   165      34.238  76.733  14.631  1.00 82.53           C  
ATOM   2615  C   LEU   165      34.851  75.616  15.466  1.00 82.31           C  
ATOM   2616  O   LEU   165      35.478  75.901  16.485  1.00 82.47           O  
ATOM   2617  CB  LEU   165      35.227  77.225  13.564  1.00 82.25           C  
ATOM   2618  N   ASN   166      34.666  74.355  15.075  1.00 82.01           N  
ATOM   2619  CA  ASN   166      35.080  73.255  15.962  1.00 81.62           C  
ATOM   2620  C   ASN   166      35.370  71.877  15.338  1.00 81.69           C  
ATOM   2621  O   ASN   166      35.004  71.595  14.198  1.00 81.74           O  
ATOM   2622  CB  ASN   166      34.092  73.114  17.135  1.00 81.51           C  
ATOM   2623  CG  ASN   166      33.298  71.840  17.072  1.00 80.00           C  
ATOM   2624  OD1 ASN   166      32.559  71.603  16.127  1.00 79.28           O  
ATOM   2625  ND2 ASN   166      33.468  70.998  18.073  1.00 78.62           N  
ATOM   2626  N   ILE   167      35.996  71.020  16.142  1.00 81.64           N  
ATOM   2627  CA  ILE   167      36.523  69.735  15.714  1.00 81.65           C  
ATOM   2628  C   ILE   167      36.879  68.905  16.970  1.00 81.39           C  
ATOM   2629  O   ILE   167      37.498  69.410  17.908  1.00 81.71           O  
ATOM   2630  CB  ILE   167      37.773  69.954  14.790  1.00 81.82           C  
ATOM   2631  CG1 ILE   167      37.985  68.794  13.799  1.00 82.60           C  
ATOM   2632  CG2 ILE   167      39.029  70.295  15.602  1.00 82.00           C  
ATOM   2633  CD1 ILE   167      38.673  67.539  14.354  1.00 83.11           C  
ATOM   2634  N   GLY   168      36.476  67.640  16.998  1.00 80.83           N  
ATOM   2635  CA  GLY   168      36.765  66.771  18.131  1.00 79.92           C  
ATOM   2636  C   GLY   168      36.180  65.402  17.885  1.00 79.40           C  
ATOM   2637  O   GLY   168      35.303  65.255  17.047  1.00 79.16           O  
ATOM   2638  N   VAL   169      36.665  64.389  18.597  1.00 78.88           N  
ATOM   2639  CA  VAL   169      36.100  63.066  18.419  1.00 78.43           C  
ATOM   2640  C   VAL   169      34.942  62.925  19.388  1.00 78.66           C  
ATOM   2641  O   VAL   169      34.799  63.718  20.316  1.00 78.78           O  
ATOM   2642  CB  VAL   169      37.128  61.905  18.583  1.00 78.27           C  
ATOM   2643  CG1 VAL   169      38.461  62.270  17.975  1.00 78.12           C  
ATOM   2644  CG2 VAL   169      37.299  61.505  20.030  1.00 77.88           C  
ATOM   2645  N   ASP   170      34.101  61.931  19.138  1.00 78.48           N  
ATOM   2646  CA  ASP   170      33.042  61.579  20.037  1.00 78.11           C  
ATOM   2647  C   ASP   170      33.518  60.388  20.856  1.00 77.65           C  
ATOM   2648  O   ASP   170      33.521  59.244  20.406  1.00 77.39           O  
ATOM   2649  CB  ASP   170      31.768  61.276  19.243  1.00 78.30           C  
ATOM   2650  CG  ASP   170      30.722  60.532  20.052  1.00 79.56           C  
ATOM   2651  OD1 ASP   170      29.614  60.382  19.526  1.00 81.69           O  
ATOM   2652  OD2 ASP   170      30.989  60.075  21.191  1.00 82.57           O  
ATOM   2653  N   HIS   171      33.900  60.671  22.088  1.00 77.71           N  
ATOM   2654  CA  HIS   171      34.503  59.665  22.945  1.00 77.55           C  
ATOM   2655  C   HIS   171      33.497  58.628  23.414  1.00 77.58           C  
ATOM   2656  O   HIS   171      33.864  57.468  23.686  1.00 77.98           O  
ATOM   2657  CB  HIS   171      35.176  60.348  24.107  1.00 77.09           C  
ATOM   2658  CG  HIS   171      36.363  61.157  23.705  1.00 78.95           C  
ATOM   2659  ND1 HIS   171      37.615  60.603  23.516  1.00 80.05           N  
ATOM   2660  CD2 HIS   171      36.493  62.480  23.441  1.00 80.65           C  
ATOM   2661  CE1 HIS   171      38.469  61.551  23.177  1.00 80.66           C  
ATOM   2662  NE2 HIS   171      37.814  62.700  23.124  1.00 81.52           N  
ATOM   2663  N   PHE   172      32.233  59.040  23.473  1.00 77.03           N  
ATOM   2664  CA  PHE   172      31.160  58.159  23.895  1.00 76.98           C  
ATOM   2665  C   PHE   172      31.113  56.943  22.991  1.00 77.19           C  
ATOM   2666  O   PHE   172      31.136  55.817  23.492  1.00 77.09           O  
ATOM   2667  CB  PHE   172      29.836  58.921  23.864  1.00 77.18           C  
ATOM   2668  CG  PHE   172      28.661  58.154  24.354  1.00 76.49           C  
ATOM   2669  CD1 PHE   172      28.342  58.138  25.697  1.00 78.32           C  
ATOM   2670  CD2 PHE   172      27.829  57.495  23.466  1.00 76.70           C  
ATOM   2671  CE1 PHE   172      27.210  57.435  26.156  1.00 78.10           C  
ATOM   2672  CE2 PHE   172      26.694  56.800  23.910  1.00 76.12           C  
ATOM   2673  CZ  PHE   172      26.388  56.775  25.250  1.00 76.31           C  
ATOM   2674  N   GLU   173      31.079  57.163  21.668  1.00 76.95           N  
ATOM   2675  CA  GLU   173      31.035  56.046  20.734  1.00 77.23           C  
ATOM   2676  C   GLU   173      32.259  55.176  20.964  1.00 77.15           C  
ATOM   2677  O   GLU   173      32.178  53.953  20.993  1.00 76.58           O  
ATOM   2678  CB  GLU   173      30.930  56.511  19.272  1.00 77.36           C  
ATOM   2679  CG  GLU   173      30.816  55.359  18.226  1.00 80.90           C  
ATOM   2680  CD  GLU   173      29.582  54.416  18.451  1.00 88.97           C  
ATOM   2681  OE1 GLU   173      29.768  53.259  18.935  1.00 93.40           O  
ATOM   2682  OE2 GLU   173      28.422  54.817  18.160  1.00 88.23           O  
ATOM   2683  N   VAL   174      33.398  55.819  21.160  1.00 77.60           N  
ATOM   2684  CA  VAL   174      34.596  55.075  21.387  1.00 78.62           C  
ATOM   2685  C   VAL   174      34.424  54.137  22.569  1.00 79.30           C  
ATOM   2686  O   VAL   174      34.714  52.946  22.431  1.00 80.41           O  
ATOM   2687  CB  VAL   174      35.834  55.961  21.599  1.00 79.19           C  
ATOM   2688  CG1 VAL   174      37.048  55.081  21.906  1.00 77.82           C  
ATOM   2689  CG2 VAL   174      36.097  56.819  20.353  1.00 79.42           C  
ATOM   2690  N   GLY   175      33.961  54.649  23.712  1.00 78.91           N  
ATOM   2691  CA  GLY   175      33.727  53.794  24.878  1.00 78.37           C  
ATOM   2692  C   GLY   175      32.796  52.665  24.490  1.00 78.79           C  
ATOM   2693  O   GLY   175      33.177  51.503  24.459  1.00 78.33           O  
ATOM   2694  N   LYS   176      31.565  53.018  24.146  1.00 79.45           N  
ATOM   2695  CA  LYS   176      30.585  52.048  23.666  1.00 79.96           C  
ATOM   2696  C   LYS   176      31.176  51.022  22.687  1.00 79.37           C  
ATOM   2697  O   LYS   176      31.013  49.829  22.882  1.00 79.42           O  
ATOM   2698  CB  LYS   176      29.397  52.772  23.033  1.00 79.56           C  
ATOM   2699  CG  LYS   176      28.260  51.855  22.659  1.00 81.40           C  
ATOM   2700  CD  LYS   176      26.926  52.606  22.380  1.00 81.77           C  
ATOM   2701  CE  LYS   176      26.848  53.142  20.911  1.00 84.89           C  
ATOM   2702  NZ  LYS   176      25.676  54.054  20.647  1.00 83.93           N  
ATOM   2703  N   ALA   177      31.865  51.469  21.642  1.00 79.24           N  
ATOM   2704  CA  ALA   177      32.176  50.535  20.566  1.00 79.27           C  
ATOM   2705  C   ALA   177      33.219  49.554  21.081  1.00 79.93           C  
ATOM   2706  O   ALA   177      33.099  48.324  20.921  1.00 80.24           O  
ATOM   2707  CB  ALA   177      32.622  51.252  19.346  1.00 78.51           C  
ATOM   2708  N   CYS   178      34.207  50.110  21.768  1.00 79.78           N  
ATOM   2709  CA  CYS   178      35.165  49.311  22.478  1.00 80.08           C  
ATOM   2710  C   CYS   178      34.496  48.388  23.454  1.00 80.09           C  
ATOM   2711  O   CYS   178      34.971  47.279  23.695  1.00 80.25           O  
ATOM   2712  CB  CYS   178      36.129  50.201  23.244  1.00 79.97           C  
ATOM   2713  SG  CYS   178      37.208  51.015  22.135  1.00 83.90           S  
ATOM   2714  N   THR   179      33.414  48.826  24.075  1.00 80.07           N  
ATOM   2715  CA  THR   179      32.910  47.912  25.041  1.00 79.86           C  
ATOM   2716  C   THR   179      31.955  46.883  24.476  1.00 79.65           C  
ATOM   2717  O   THR   179      31.944  45.763  24.964  1.00 80.10           O  
ATOM   2718  CB  THR   179      32.618  48.501  26.423  1.00 79.75           C  
ATOM   2719  OG1 THR   179      31.564  47.759  27.025  1.00 81.48           O  
ATOM   2720  CG2 THR   179      32.283  49.953  26.388  1.00 78.95           C  
ATOM   2721  N   ARG   180      31.260  47.181  23.378  1.00 79.52           N  
ATOM   2722  CA  ARG   180      30.469  46.119  22.713  1.00 78.90           C  
ATOM   2723  C   ARG   180      31.441  45.028  22.254  1.00 78.05           C  
ATOM   2724  O   ARG   180      31.097  43.843  22.240  1.00 77.76           O  
ATOM   2725  CB  ARG   180      29.714  46.601  21.481  1.00 78.83           C  
ATOM   2726  CG  ARG   180      28.670  47.636  21.682  1.00 80.53           C  
ATOM   2727  CD  ARG   180      27.735  47.674  20.441  1.00 84.24           C  
ATOM   2728  NE  ARG   180      26.867  48.854  20.436  1.00 88.24           N  
ATOM   2729  CZ  ARG   180      25.893  49.112  19.556  1.00 92.40           C  
ATOM   2730  NH1 ARG   180      25.595  48.268  18.554  1.00 93.33           N  
ATOM   2731  NH2 ARG   180      25.205  50.247  19.677  1.00 94.32           N  
ATOM   2732  N   HIS   181      32.651  45.436  21.886  1.00 76.48           N  
ATOM   2733  CA  HIS   181      33.605  44.486  21.390  1.00 75.74           C  
ATOM   2734  C   HIS   181      33.821  43.362  22.410  1.00 75.96           C  
ATOM   2735  O   HIS   181      33.502  42.217  22.120  1.00 75.40           O  
ATOM   2736  CB  HIS   181      34.909  45.177  20.994  1.00 75.30           C  
ATOM   2737  CG  HIS   181      35.996  44.228  20.583  1.00 73.49           C  
ATOM   2738  ND1 HIS   181      35.785  43.182  19.708  1.00 74.20           N  
ATOM   2739  CD2 HIS   181      37.301  44.166  20.925  1.00 71.10           C  
ATOM   2740  CE1 HIS   181      36.908  42.510  19.537  1.00 70.48           C  
ATOM   2741  NE2 HIS   181      37.841  43.085  20.271  1.00 71.52           N  
ATOM   2742  N   LEU   182      34.321  43.699  23.600  1.00 76.46           N  
ATOM   2743  CA  LEU   182      34.436  42.751  24.721  1.00 77.19           C  
ATOM   2744  C   LEU   182      33.182  41.868  24.879  1.00 78.63           C  
ATOM   2745  O   LEU   182      33.265  40.636  24.969  1.00 79.20           O  
ATOM   2746  CB  LEU   182      34.654  43.512  26.026  1.00 76.44           C  
ATOM   2747  CG  LEU   182      35.972  44.295  26.188  1.00 75.55           C  
ATOM   2748  CD1 LEU   182      36.016  45.069  27.463  1.00 72.73           C  
ATOM   2749  CD2 LEU   182      37.183  43.414  26.136  1.00 72.50           C  
ATOM   2750  N   ILE   183      32.016  42.499  24.893  1.00 78.80           N  
ATOM   2751  CA  ILE   183      30.797  41.759  24.965  1.00 79.22           C  
ATOM   2752  C   ILE   183      30.567  40.870  23.730  1.00 79.91           C  
ATOM   2753  O   ILE   183      30.315  39.669  23.883  1.00 80.72           O  
ATOM   2754  CB  ILE   183      29.609  42.691  25.219  1.00 79.49           C  
ATOM   2755  CG1 ILE   183      29.902  43.591  26.417  1.00 79.82           C  
ATOM   2756  CG2 ILE   183      28.332  41.889  25.471  1.00 78.82           C  
ATOM   2757  CD1 ILE   183      28.888  44.708  26.629  1.00 82.25           C  
ATOM   2758  N   GLU   184      30.628  41.408  22.512  1.00 80.05           N  
ATOM   2759  CA  GLU   184      30.426  40.527  21.338  1.00 80.10           C  
ATOM   2760  C   GLU   184      31.446  39.401  21.394  1.00 80.16           C  
ATOM   2761  O   GLU   184      31.192  38.297  20.944  1.00 80.55           O  
ATOM   2762  CB  GLU   184      30.549  41.262  20.006  1.00 79.71           C  
ATOM   2763  CG  GLU   184      29.544  42.364  19.803  1.00 81.68           C  
ATOM   2764  CD  GLU   184      30.022  43.440  18.843  1.00 83.99           C  
ATOM   2765  OE1 GLU   184      29.181  43.990  18.091  1.00 84.65           O  
ATOM   2766  OE2 GLU   184      31.238  43.750  18.849  1.00 86.64           O  
ATOM   2767  N   GLN   185      32.593  39.696  21.982  1.00 80.10           N  
ATOM   2768  CA  GLN   185      33.676  38.749  22.099  1.00 80.36           C  
ATOM   2769  C   GLN   185      33.483  37.698  23.167  1.00 80.27           C  
ATOM   2770  O   GLN   185      34.251  36.752  23.237  1.00 80.62           O  
ATOM   2771  CB  GLN   185      34.967  39.504  22.425  1.00 81.07           C  
ATOM   2772  CG  GLN   185      35.668  40.050  21.188  1.00 80.87           C  
ATOM   2773  CD  GLN   185      36.068  38.953  20.272  1.00 78.91           C  
ATOM   2774  OE1 GLN   185      35.308  38.574  19.386  1.00 81.42           O  
ATOM   2775  NE2 GLN   185      37.238  38.383  20.511  1.00 77.13           N  
ATOM   2776  N   GLY   186      32.509  37.881  24.041  1.00 80.11           N  
ATOM   2777  CA  GLY   186      32.293  36.923  25.108  1.00 79.60           C  
ATOM   2778  C   GLY   186      32.768  37.339  26.483  1.00 79.55           C  
ATOM   2779  O   GLY   186      32.462  36.665  27.451  1.00 80.17           O  
ATOM   2780  N   PHE   187      33.502  38.441  26.591  1.00 79.33           N  
ATOM   2781  CA  PHE   187      33.986  38.923  27.886  1.00 78.91           C  
ATOM   2782  C   PHE   187      32.943  39.820  28.552  1.00 79.97           C  
ATOM   2783  O   PHE   187      32.911  41.047  28.385  1.00 80.79           O  
ATOM   2784  CB  PHE   187      35.304  39.652  27.708  1.00 78.21           C  
ATOM   2785  CG  PHE   187      36.365  38.824  27.034  1.00 77.68           C  
ATOM   2786  CD1 PHE   187      36.646  38.999  25.676  1.00 79.19           C  
ATOM   2787  CD2 PHE   187      37.064  37.856  27.742  1.00 75.88           C  
ATOM   2788  CE1 PHE   187      37.615  38.238  25.030  1.00 78.14           C  
ATOM   2789  CE2 PHE   187      38.013  37.078  27.119  1.00 77.33           C  
ATOM   2790  CZ  PHE   187      38.308  37.272  25.750  1.00 78.08           C  
ATOM   2791  N   LYS   188      32.071  39.208  29.322  1.00 80.38           N  
ATOM   2792  CA  LYS   188      30.915  39.937  29.794  1.00 80.84           C  
ATOM   2793  C   LYS   188      31.063  40.627  31.167  1.00 80.86           C  
ATOM   2794  O   LYS   188      30.079  41.211  31.669  1.00 80.99           O  
ATOM   2795  CB  LYS   188      29.664  39.026  29.744  1.00 80.76           C  
ATOM   2796  CG  LYS   188      29.261  38.639  28.296  1.00 81.71           C  
ATOM   2797  CD  LYS   188      28.091  37.692  28.232  1.00 81.52           C  
ATOM   2798  CE  LYS   188      27.244  38.001  27.006  1.00 85.18           C  
ATOM   2799  NZ  LYS   188      25.736  37.841  27.224  1.00 86.22           N  
ATOM   2800  N   ASN   189      32.221  40.561  31.824  1.00 80.14           N  
ATOM   2801  CA  ASN   189      32.241  41.338  33.062  1.00 80.65           C  
ATOM   2802  C   ASN   189      33.378  42.269  33.287  1.00 80.24           C  
ATOM   2803  O   ASN   189      34.320  41.987  34.008  1.00 80.39           O  
ATOM   2804  CB  ASN   189      31.732  40.616  34.331  1.00 81.09           C  
ATOM   2805  CG  ASN   189      32.468  39.378  34.631  1.00 81.57           C  
ATOM   2806  OD1 ASN   189      31.864  38.341  34.936  1.00 78.74           O  
ATOM   2807  ND2 ASN   189      33.792  39.455  34.563  1.00 83.76           N  
ATOM   2808  N   VAL   190      33.171  43.433  32.687  1.00 79.71           N  
ATOM   2809  CA  VAL   190      34.188  44.366  32.349  1.00 79.19           C  
ATOM   2810  C   VAL   190      34.303  45.369  33.445  1.00 78.89           C  
ATOM   2811  O   VAL   190      33.314  45.846  33.933  1.00 78.26           O  
ATOM   2812  CB  VAL   190      33.776  45.122  31.074  1.00 79.19           C  
ATOM   2813  CG1 VAL   190      34.944  45.917  30.532  1.00 78.94           C  
ATOM   2814  CG2 VAL   190      33.273  44.163  30.030  1.00 79.00           C  
ATOM   2815  N   GLY   191      35.528  45.688  33.822  1.00 79.46           N  
ATOM   2816  CA  GLY   191      35.778  46.807  34.694  1.00 80.54           C  
ATOM   2817  C   GLY   191      36.290  47.944  33.841  1.00 81.68           C  
ATOM   2818  O   GLY   191      36.678  47.753  32.672  1.00 81.85           O  
ATOM   2819  N   PHE   192      36.308  49.131  34.426  1.00 82.51           N  
ATOM   2820  CA  PHE   192      36.807  50.314  33.732  1.00 83.52           C  
ATOM   2821  C   PHE   192      37.820  51.041  34.596  1.00 83.55           C  
ATOM   2822  O   PHE   192      37.572  51.283  35.782  1.00 84.79           O  
ATOM   2823  CB  PHE   192      35.622  51.245  33.469  1.00 83.85           C  
ATOM   2824  CG  PHE   192      35.963  52.492  32.717  1.00 84.15           C  
ATOM   2825  CD1 PHE   192      35.894  52.519  31.322  1.00 83.73           C  
ATOM   2826  CD2 PHE   192      36.299  53.661  33.399  1.00 85.06           C  
ATOM   2827  CE1 PHE   192      36.167  53.697  30.607  1.00 83.70           C  
ATOM   2828  CE2 PHE   192      36.585  54.859  32.693  1.00 85.36           C  
ATOM   2829  CZ  PHE   192      36.520  54.873  31.300  1.00 84.60           C  
ATOM   2830  N   ILE   193      38.934  51.434  34.017  1.00 82.61           N  
ATOM   2831  CA  ILE   193      39.823  52.292  34.748  1.00 82.73           C  
ATOM   2832  C   ILE   193      40.120  53.495  33.879  1.00 82.43           C  
ATOM   2833  O   ILE   193      40.569  53.339  32.751  1.00 82.40           O  
ATOM   2834  CB  ILE   193      41.120  51.560  35.095  1.00 83.08           C  
ATOM   2835  CG1 ILE   193      40.841  50.351  35.984  1.00 83.58           C  
ATOM   2836  CG2 ILE   193      42.049  52.468  35.824  1.00 83.03           C  
ATOM   2837  CD1 ILE   193      41.969  49.322  35.948  1.00 83.18           C  
ATOM   2838  N   GLY   194      39.885  54.693  34.399  1.00 82.42           N  
ATOM   2839  CA  GLY   194      40.259  55.911  33.670  1.00 83.13           C  
ATOM   2840  C   GLY   194      40.774  57.070  34.505  1.00 84.00           C  
ATOM   2841  O   GLY   194      40.590  57.097  35.723  1.00 84.09           O  
ATOM   2842  N   ALA   195      41.420  58.043  33.868  1.00 85.27           N  
ATOM   2843  CA  ALA   195      41.868  59.211  34.625  1.00 86.69           C  
ATOM   2844  C   ALA   195      41.589  60.556  34.003  1.00 87.86           C  
ATOM   2845  O   ALA   195      40.987  60.666  32.943  1.00 88.25           O  
ATOM   2846  CB  ALA   195      43.313  59.095  34.951  1.00 87.22           C  
ATOM   2847  N   ARG   196      42.105  61.583  34.671  1.00 89.60           N  
ATOM   2848  CA  ARG   196      41.675  62.986  34.509  1.00 90.66           C  
ATOM   2849  C   ARG   196      40.163  63.034  34.302  1.00 90.86           C  
ATOM   2850  O   ARG   196      39.666  63.607  33.347  1.00 90.92           O  
ATOM   2851  CB  ARG   196      42.504  63.802  33.487  1.00 90.49           C  
ATOM   2852  CG  ARG   196      43.175  63.034  32.375  1.00 91.94           C  
ATOM   2853  CD  ARG   196      42.213  62.693  31.252  1.00 96.21           C  
ATOM   2854  NE  ARG   196      42.211  63.696  30.178  1.00100.30           N  
ATOM   2855  CZ  ARG   196      41.193  63.892  29.335  1.00102.27           C  
ATOM   2856  NH1 ARG   196      40.076  63.157  29.441  1.00101.77           N  
ATOM   2857  NH2 ARG   196      41.282  64.837  28.394  1.00102.48           N  
ATOM   2858  N   GLY   197      39.467  62.411  35.255  1.00 91.35           N  
ATOM   2859  CA  GLY   197      38.034  62.202  35.216  1.00 91.79           C  
ATOM   2860  C   GLY   197      37.219  63.293  35.868  1.00 92.28           C  
ATOM   2861  O   GLY   197      36.054  63.079  36.230  1.00 92.31           O  
ATOM   2862  N   ASN   198      37.844  64.452  36.035  1.00 92.64           N  
ATOM   2863  CA  ASN   198      37.138  65.677  36.366  1.00 93.28           C  
ATOM   2864  C   ASN   198      37.107  66.523  35.088  1.00 92.95           C  
ATOM   2865  O   ASN   198      36.318  67.469  34.981  1.00 93.11           O  
ATOM   2866  CB  ASN   198      37.806  66.429  37.539  1.00 93.99           C  
ATOM   2867  CG  ASN   198      37.985  65.549  38.834  1.00 96.42           C  
ATOM   2868  OD1 ASN   198      38.247  66.086  39.919  1.00 98.53           O  
ATOM   2869  ND2 ASN   198      37.868  64.219  38.710  1.00 97.94           N  
ATOM   2870  N   HIS   199      37.977  66.173  34.128  1.00 92.31           N  
ATOM   2871  CA  HIS   199      37.888  66.677  32.748  1.00 91.43           C  
ATOM   2872  C   HIS   199      36.818  65.892  31.993  1.00 89.90           C  
ATOM   2873  O   HIS   199      36.617  64.715  32.274  1.00 89.72           O  
ATOM   2874  CB  HIS   199      39.228  66.602  31.997  1.00 91.96           C  
ATOM   2875  CG  HIS   199      39.172  67.240  30.640  1.00 95.07           C  
ATOM   2876  ND1 HIS   199      38.842  66.537  29.495  1.00 97.43           N  
ATOM   2877  CD2 HIS   199      39.324  68.533  30.254  1.00 97.09           C  
ATOM   2878  CE1 HIS   199      38.828  67.363  28.461  1.00 97.18           C  
ATOM   2879  NE2 HIS   199      39.114  68.580  28.894  1.00 97.50           N  
ATOM   2880  N   SER   200      36.148  66.535  31.032  1.00 88.30           N  
ATOM   2881  CA  SER   200      34.909  65.990  30.461  1.00 86.92           C  
ATOM   2882  C   SER   200      35.070  64.754  29.576  1.00 85.74           C  
ATOM   2883  O   SER   200      34.207  63.901  29.582  1.00 85.73           O  
ATOM   2884  CB  SER   200      34.069  67.078  29.776  1.00 87.22           C  
ATOM   2885  OG  SER   200      34.280  67.122  28.371  1.00 88.08           O  
ATOM   2886  N   THR   201      36.168  64.643  28.838  1.00 84.64           N  
ATOM   2887  CA  THR   201      36.411  63.449  28.016  1.00 83.55           C  
ATOM   2888  C   THR   201      36.262  62.141  28.785  1.00 83.42           C  
ATOM   2889  O   THR   201      35.669  61.198  28.312  1.00 83.11           O  
ATOM   2890  CB  THR   201      37.801  63.485  27.375  1.00 83.05           C  
ATOM   2891  OG1 THR   201      37.890  64.655  26.567  1.00 84.53           O  
ATOM   2892  CG2 THR   201      38.055  62.255  26.503  1.00 80.40           C  
ATOM   2893  N   LEU   202      36.821  62.053  29.974  1.00 83.48           N  
ATOM   2894  CA  LEU   202      36.689  60.793  30.638  1.00 83.21           C  
ATOM   2895  C   LEU   202      35.206  60.453  30.854  1.00 82.67           C  
ATOM   2896  O   LEU   202      34.805  59.316  30.618  1.00 82.50           O  
ATOM   2897  CB  LEU   202      37.481  60.744  31.941  1.00 83.44           C  
ATOM   2898  CG  LEU   202      37.032  59.479  32.695  1.00 84.26           C  
ATOM   2899  CD1 LEU   202      37.781  58.229  32.239  1.00 82.06           C  
ATOM   2900  CD2 LEU   202      37.125  59.673  34.185  1.00 84.40           C  
ATOM   2901  N   GLN   203      34.403  61.435  31.275  1.00 81.91           N  
ATOM   2902  CA  GLN   203      32.993  61.188  31.605  1.00 81.41           C  
ATOM   2903  C   GLN   203      32.186  60.645  30.422  1.00 80.68           C  
ATOM   2904  O   GLN   203      31.303  59.796  30.588  1.00 80.17           O  
ATOM   2905  CB  GLN   203      32.323  62.413  32.221  1.00 81.28           C  
ATOM   2906  CG  GLN   203      31.132  62.047  33.157  1.00 84.16           C  
ATOM   2907  CD  GLN   203      31.493  61.959  34.684  1.00 88.19           C  
ATOM   2908  OE1 GLN   203      30.637  62.242  35.549  1.00 88.30           O  
ATOM   2909  NE2 GLN   203      32.757  61.593  35.007  1.00 88.03           N  
ATOM   2910  N   ARG   204      32.525  61.121  29.231  1.00 80.29           N  
ATOM   2911  CA  ARG   204      31.944  60.638  28.000  1.00 79.76           C  
ATOM   2912  C   ARG   204      32.359  59.220  27.672  1.00 80.40           C  
ATOM   2913  O   ARG   204      31.599  58.500  27.069  1.00 81.29           O  
ATOM   2914  CB  ARG   204      32.342  61.546  26.878  1.00 79.22           C  
ATOM   2915  CG  ARG   204      31.510  62.815  26.779  1.00 78.09           C  
ATOM   2916  CD  ARG   204      30.503  62.709  25.671  1.00 73.78           C  
ATOM   2917  NE  ARG   204      29.178  62.581  26.260  1.00 73.94           N  
ATOM   2918  CZ  ARG   204      28.079  62.153  25.643  1.00 71.92           C  
ATOM   2919  NH1 ARG   204      28.089  61.774  24.372  1.00 70.10           N  
ATOM   2920  NH2 ARG   204      26.953  62.101  26.329  1.00 72.91           N  
ATOM   2921  N   GLN   205      33.552  58.810  28.069  1.00 81.01           N  
ATOM   2922  CA  GLN   205      34.001  57.430  27.859  1.00 81.83           C  
ATOM   2923  C   GLN   205      33.366  56.483  28.874  1.00 81.54           C  
ATOM   2924  O   GLN   205      32.989  55.372  28.525  1.00 81.79           O  
ATOM   2925  CB  GLN   205      35.523  57.295  27.986  1.00 81.66           C  
ATOM   2926  CG  GLN   205      36.339  58.403  27.364  1.00 82.67           C  
ATOM   2927  CD  GLN   205      37.824  58.230  27.614  1.00 83.74           C  
ATOM   2928  OE1 GLN   205      38.590  57.948  26.687  1.00 87.39           O  
ATOM   2929  NE2 GLN   205      38.245  58.386  28.868  1.00 85.67           N  
ATOM   2930  N   LEU   206      33.280  56.923  30.129  1.00 81.26           N  
ATOM   2931  CA  LEU   206      32.664  56.154  31.211  1.00 80.62           C  
ATOM   2932  C   LEU   206      31.267  55.837  30.799  1.00 80.58           C  
ATOM   2933  O   LEU   206      30.844  54.691  30.807  1.00 80.68           O  
ATOM   2934  CB  LEU   206      32.554  56.999  32.473  1.00 80.35           C  
ATOM   2935  CG  LEU   206      32.950  56.478  33.855  1.00 80.48           C  
ATOM   2936  CD1 LEU   206      31.895  56.834  34.835  1.00 79.54           C  
ATOM   2937  CD2 LEU   206      33.171  54.998  33.885  1.00 82.11           C  
ATOM   2938  N   HIS   207      30.560  56.892  30.421  1.00 81.09           N  
ATOM   2939  CA  HIS   207      29.186  56.802  30.008  1.00 81.13           C  
ATOM   2940  C   HIS   207      29.084  55.873  28.824  1.00 81.17           C  
ATOM   2941  O   HIS   207      28.182  55.036  28.763  1.00 81.97           O  
ATOM   2942  CB  HIS   207      28.688  58.171  29.616  1.00 80.90           C  
ATOM   2943  CG  HIS   207      28.303  59.019  30.776  1.00 81.89           C  
ATOM   2944  ND1 HIS   207      28.257  60.393  30.710  1.00 83.73           N  
ATOM   2945  CD2 HIS   207      27.917  58.691  32.028  1.00 83.91           C  
ATOM   2946  CE1 HIS   207      27.853  60.877  31.869  1.00 84.17           C  
ATOM   2947  NE2 HIS   207      27.636  59.864  32.686  1.00 85.03           N  
ATOM   2948  N   GLY   208      30.017  56.007  27.888  1.00 80.25           N  
ATOM   2949  CA  GLY   208      30.003  55.150  26.725  1.00 79.50           C  
ATOM   2950  C   GLY   208      30.023  53.729  27.212  1.00 78.89           C  
ATOM   2951  O   GLY   208      29.307  52.886  26.719  1.00 78.71           O  
ATOM   2952  N   TRP   209      30.828  53.478  28.223  1.00 79.07           N  
ATOM   2953  CA  TRP   209      31.034  52.119  28.677  1.00 79.62           C  
ATOM   2954  C   TRP   209      29.805  51.629  29.414  1.00 79.46           C  
ATOM   2955  O   TRP   209      29.413  50.468  29.268  1.00 79.36           O  
ATOM   2956  CB  TRP   209      32.300  52.019  29.528  1.00 79.54           C  
ATOM   2957  CG  TRP   209      32.366  50.838  30.418  1.00 80.47           C  
ATOM   2958  CD1 TRP   209      32.629  49.542  30.055  1.00 80.70           C  
ATOM   2959  CD2 TRP   209      32.163  50.824  31.840  1.00 80.61           C  
ATOM   2960  NE1 TRP   209      32.607  48.720  31.177  1.00 80.20           N  
ATOM   2961  CE2 TRP   209      32.324  49.480  32.279  1.00 79.61           C  
ATOM   2962  CE3 TRP   209      31.846  51.806  32.783  1.00 79.52           C  
ATOM   2963  CZ2 TRP   209      32.174  49.101  33.615  1.00 78.81           C  
ATOM   2964  CZ3 TRP   209      31.724  51.421  34.131  1.00 79.47           C  
ATOM   2965  CH2 TRP   209      31.876  50.079  34.523  1.00 78.39           C  
ATOM   2966  N   GLN   210      29.179  52.521  30.173  1.00 79.68           N  
ATOM   2967  CA  GLN   210      28.035  52.146  31.021  1.00 79.73           C  
ATOM   2968  C   GLN   210      26.840  51.860  30.171  1.00 80.37           C  
ATOM   2969  O   GLN   210      26.070  50.968  30.458  1.00 80.30           O  
ATOM   2970  CB  GLN   210      27.714  53.238  32.011  1.00 79.17           C  
ATOM   2971  CG  GLN   210      28.840  53.487  32.944  1.00 78.82           C  
ATOM   2972  CD  GLN   210      28.479  54.365  34.067  1.00 77.16           C  
ATOM   2973  OE1 GLN   210      27.879  55.413  33.884  1.00 76.86           O  
ATOM   2974  NE2 GLN   210      28.858  53.954  35.264  1.00 79.17           N  
ATOM   2975  N   SER   211      26.716  52.604  29.084  1.00 81.82           N  
ATOM   2976  CA  SER   211      25.690  52.330  28.096  1.00 82.60           C  
ATOM   2977  C   SER   211      25.819  50.883  27.620  1.00 82.35           C  
ATOM   2978  O   SER   211      24.942  50.048  27.874  1.00 82.07           O  
ATOM   2979  CB  SER   211      25.813  53.297  26.922  1.00 82.72           C  
ATOM   2980  OG  SER   211      24.608  53.282  26.170  1.00 85.36           O  
ATOM   2981  N   ALA   212      26.933  50.589  26.962  1.00 82.35           N  
ATOM   2982  CA  ALA   212      27.198  49.247  26.454  1.00 82.75           C  
ATOM   2983  C   ALA   212      26.832  48.124  27.447  1.00 83.30           C  
ATOM   2984  O   ALA   212      26.241  47.099  27.028  1.00 83.70           O  
ATOM   2985  CB  ALA   212      28.635  49.131  26.039  1.00 82.33           C  
ATOM   2986  N   MET   213      27.158  48.315  28.741  1.00 82.82           N  
ATOM   2987  CA  MET   213      26.838  47.320  29.773  1.00 82.13           C  
ATOM   2988  C   MET   213      25.330  47.205  29.978  1.00 81.75           C  
ATOM   2989  O   MET   213      24.724  46.151  29.739  1.00 81.60           O  
ATOM   2990  CB  MET   213      27.488  47.680  31.087  1.00 81.95           C  
ATOM   2991  CG  MET   213      28.964  47.810  31.050  1.00 84.63           C  
ATOM   2992  SD  MET   213      29.883  46.136  30.639  0.90 92.81          SE  
ATOM   2993  CE  MET   213      29.680  45.178  32.333  1.00 90.40           C  
ATOM   2994  N   ILE   214      24.727  48.304  30.421  1.00 81.16           N  
ATOM   2995  CA  ILE   214      23.289  48.340  30.703  1.00 80.55           C  
ATOM   2996  C   ILE   214      22.459  47.774  29.546  1.00 80.64           C  
ATOM   2997  O   ILE   214      21.670  46.870  29.767  1.00 80.55           O  
ATOM   2998  CB  ILE   214      22.807  49.760  31.122  1.00 80.05           C  
ATOM   2999  CG1 ILE   214      23.707  50.302  32.235  1.00 78.65           C  
ATOM   3000  CG2 ILE   214      21.416  49.697  31.633  1.00 78.55           C  
ATOM   3001  CD1 ILE   214      23.628  51.791  32.454  1.00 76.82           C  
ATOM   3002  N   GLU   215      22.681  48.282  28.329  1.00 80.87           N  
ATOM   3003  CA  GLU   215      22.042  47.797  27.091  1.00 80.88           C  
ATOM   3004  C   GLU   215      22.051  46.275  27.002  1.00 80.66           C  
ATOM   3005  O   GLU   215      21.127  45.696  26.460  1.00 80.62           O  
ATOM   3006  CB  GLU   215      22.741  48.417  25.876  1.00 81.14           C  
ATOM   3007  CG  GLU   215      22.337  47.919  24.489  1.00 81.26           C  
ATOM   3008  CD  GLU   215      22.902  48.789  23.336  1.00 81.95           C  
ATOM   3009  OE1 GLU   215      22.057  49.343  22.600  1.00 82.54           O  
ATOM   3010  OE2 GLU   215      24.162  48.922  23.153  1.00 83.52           O  
ATOM   3011  N   ASN   216      23.067  45.628  27.567  1.00 80.46           N  
ATOM   3012  CA  ASN   216      23.105  44.163  27.627  1.00 80.35           C  
ATOM   3013  C   ASN   216      22.707  43.497  28.982  1.00 80.42           C  
ATOM   3014  O   ASN   216      23.016  42.325  29.199  1.00 80.86           O  
ATOM   3015  CB  ASN   216      24.477  43.638  27.155  1.00 80.81           C  
ATOM   3016  CG  ASN   216      24.736  43.879  25.653  1.00 81.75           C  
ATOM   3017  OD1 ASN   216      25.231  44.935  25.240  1.00 82.86           O  
ATOM   3018  ND2 ASN   216      24.440  42.871  24.844  1.00 83.41           N  
ATOM   3019  N   TYR   217      21.993  44.212  29.859  1.00 80.03           N  
ATOM   3020  CA  TYR   217      21.676  43.754  31.241  1.00 79.43           C  
ATOM   3021  C   TYR   217      22.903  43.442  32.069  1.00 79.05           C  
ATOM   3022  O   TYR   217      22.855  42.674  33.003  1.00 78.59           O  
ATOM   3023  CB  TYR   217      20.775  42.535  31.266  1.00 78.94           C  
ATOM   3024  CG  TYR   217      19.520  42.715  30.500  1.00 79.30           C  
ATOM   3025  CD1 TYR   217      19.528  42.600  29.113  1.00 80.49           C  
ATOM   3026  CD2 TYR   217      18.311  42.989  31.144  1.00 78.52           C  
ATOM   3027  CE1 TYR   217      18.373  42.762  28.366  1.00 80.34           C  
ATOM   3028  CE2 TYR   217      17.140  43.153  30.411  1.00 78.65           C  
ATOM   3029  CZ  TYR   217      17.181  43.044  29.005  1.00 79.65           C  
ATOM   3030  OH  TYR   217      16.058  43.210  28.205  1.00 79.47           O  
ATOM   3031  N   LEU   218      24.022  44.032  31.722  1.00 79.48           N  
ATOM   3032  CA  LEU   218      25.203  43.811  32.513  1.00 80.02           C  
ATOM   3033  C   LEU   218      25.235  44.948  33.505  1.00 81.06           C  
ATOM   3034  O   LEU   218      24.770  46.049  33.194  1.00 81.03           O  
ATOM   3035  CB  LEU   218      26.417  43.787  31.611  1.00 79.50           C  
ATOM   3036  CG  LEU   218      26.866  42.414  31.093  1.00 78.14           C  
ATOM   3037  CD1 LEU   218      25.746  41.443  30.890  1.00 75.30           C  
ATOM   3038  CD2 LEU   218      27.696  42.586  29.819  1.00 76.40           C  
ATOM   3039  N   THR   219      25.706  44.685  34.719  1.00 82.41           N  
ATOM   3040  CA  THR   219      25.541  45.691  35.769  1.00 83.88           C  
ATOM   3041  C   THR   219      26.892  46.345  35.941  1.00 84.11           C  
ATOM   3042  O   THR   219      27.820  45.689  36.393  1.00 84.65           O  
ATOM   3043  CB  THR   219      24.888  45.134  37.111  1.00 84.63           C  
ATOM   3044  OG1 THR   219      23.454  44.965  36.963  1.00 84.24           O  
ATOM   3045  CG2 THR   219      25.135  46.086  38.300  1.00 85.95           C  
ATOM   3046  N   PRO   220      26.963  47.657  35.612  1.00 84.07           N  
ATOM   3047  CA  PRO   220      28.052  48.528  35.185  1.00 83.80           C  
ATOM   3048  C   PRO   220      28.682  49.405  36.290  1.00 84.24           C  
ATOM   3049  O   PRO   220      28.902  50.622  36.095  1.00 83.18           O  
ATOM   3050  CB  PRO   220      27.308  49.474  34.248  1.00 83.87           C  
ATOM   3051  CG  PRO   220      25.976  49.681  34.961  1.00 83.16           C  
ATOM   3052  CD  PRO   220      25.711  48.437  35.749  1.00 83.40           C  
ATOM   3053  N   ASP   221      28.948  48.822  37.447  1.00 84.85           N  
ATOM   3054  CA  ASP   221      29.414  49.635  38.556  1.00 85.97           C  
ATOM   3055  C   ASP   221      30.748  49.146  39.059  1.00 85.17           C  
ATOM   3056  O   ASP   221      30.990  49.126  40.246  1.00 85.59           O  
ATOM   3057  CB  ASP   221      28.342  49.769  39.683  1.00 86.83           C  
ATOM   3058  CG  ASP   221      27.426  48.535  39.794  1.00 90.87           C  
ATOM   3059  OD1 ASP   221      27.667  47.577  38.987  1.00 94.30           O  
ATOM   3060  OD2 ASP   221      26.486  48.519  40.671  1.00 91.66           O  
ATOM   3061  N   HIS   222      31.613  48.729  38.146  1.00 84.85           N  
ATOM   3062  CA  HIS   222      32.964  48.320  38.535  1.00 84.13           C  
ATOM   3063  C   HIS   222      33.944  49.158  37.783  1.00 83.02           C  
ATOM   3064  O   HIS   222      34.596  48.720  36.811  1.00 82.52           O  
ATOM   3065  CB  HIS   222      33.197  46.793  38.449  1.00 83.98           C  
ATOM   3066  CG  HIS   222      32.434  46.044  39.496  1.00 86.64           C  
ATOM   3067  ND1 HIS   222      32.674  46.207  40.846  1.00 88.07           N  
ATOM   3068  CD2 HIS   222      31.353  45.229  39.407  1.00 89.19           C  
ATOM   3069  CE1 HIS   222      31.819  45.469  41.537  1.00 88.71           C  
ATOM   3070  NE2 HIS   222      31.000  44.872  40.689  1.00 87.42           N  
ATOM   3071  N   PHE   223      34.006  50.403  38.238  1.00 81.78           N  
ATOM   3072  CA  PHE   223      34.900  51.371  37.632  1.00 81.50           C  
ATOM   3073  C   PHE   223      35.734  52.130  38.659  1.00 82.19           C  
ATOM   3074  O   PHE   223      35.310  52.274  39.825  1.00 82.35           O  
ATOM   3075  CB  PHE   223      34.123  52.326  36.734  1.00 79.77           C  
ATOM   3076  CG  PHE   223      33.174  53.199  37.451  1.00 77.37           C  
ATOM   3077  CD1 PHE   223      31.837  52.880  37.519  1.00 77.18           C  
ATOM   3078  CD2 PHE   223      33.592  54.371  38.036  1.00 77.31           C  
ATOM   3079  CE1 PHE   223      30.918  53.713  38.164  1.00 72.44           C  
ATOM   3080  CE2 PHE   223      32.661  55.214  38.694  1.00 76.67           C  
ATOM   3081  CZ  PHE   223      31.335  54.874  38.735  1.00 73.97           C  
ATOM   3082  N   LEU   224      36.905  52.604  38.219  1.00 82.06           N  
ATOM   3083  CA  LEU   224      37.733  53.499  39.012  1.00 82.61           C  
ATOM   3084  C   LEU   224      38.128  54.698  38.205  1.00 82.97           C  
ATOM   3085  O   LEU   224      38.662  54.527  37.092  1.00 83.77           O  
ATOM   3086  CB  LEU   224      39.026  52.802  39.399  1.00 82.82           C  
ATOM   3087  CG  LEU   224      39.254  52.219  40.774  1.00 83.50           C  
ATOM   3088  CD1 LEU   224      37.959  52.088  41.554  1.00 85.03           C  
ATOM   3089  CD2 LEU   224      39.894  50.858  40.578  1.00 85.70           C  
ATOM   3090  N   THR   225      37.933  55.902  38.744  1.00 82.85           N  
ATOM   3091  CA  THR   225      38.495  57.087  38.075  1.00 83.61           C  
ATOM   3092  C   THR   225      39.307  57.980  39.011  1.00 84.39           C  
ATOM   3093  O   THR   225      39.051  58.007  40.209  1.00 84.97           O  
ATOM   3094  CB  THR   225      37.412  57.907  37.391  1.00 83.54           C  
ATOM   3095  OG1 THR   225      36.355  58.157  38.318  1.00 83.97           O  
ATOM   3096  CG2 THR   225      36.843  57.160  36.177  1.00 83.17           C  
ATOM   3097  N   THR   226      40.304  58.691  38.493  1.00 84.90           N  
ATOM   3098  CA  THR   226      40.943  59.733  39.305  1.00 85.90           C  
ATOM   3099  C   THR   226      40.960  61.051  38.587  1.00 86.24           C  
ATOM   3100  O   THR   226      40.904  61.124  37.361  1.00 86.36           O  
ATOM   3101  CB  THR   226      42.401  59.413  39.730  1.00 86.41           C  
ATOM   3102  OG1 THR   226      43.255  59.353  38.579  1.00 86.81           O  
ATOM   3103  CG2 THR   226      42.481  58.094  40.507  1.00 87.66           C  
ATOM   3104  N   HIS   227      41.040  62.109  39.368  1.00 87.18           N  
ATOM   3105  CA  HIS   227      41.241  63.440  38.816  1.00 88.05           C  
ATOM   3106  C   HIS   227      42.692  63.543  38.325  1.00 87.59           C  
ATOM   3107  O   HIS   227      43.010  64.354  37.461  1.00 87.62           O  
ATOM   3108  CB  HIS   227      40.868  64.527  39.852  1.00 88.59           C  
ATOM   3109  CG  HIS   227      41.334  64.250  41.262  1.00 91.75           C  
ATOM   3110  ND1 HIS   227      41.565  65.260  42.180  1.00 94.04           N  
ATOM   3111  CD2 HIS   227      41.605  63.087  41.915  1.00 94.12           C  
ATOM   3112  CE1 HIS   227      41.957  64.732  43.329  1.00 94.60           C  
ATOM   3113  NE2 HIS   227      42.001  63.417  43.193  1.00 94.22           N  
ATOM   3114  N   GLU   228      43.550  62.666  38.845  1.00 87.05           N  
ATOM   3115  CA  GLU   228      44.947  62.625  38.439  1.00 86.70           C  
ATOM   3116  C   GLU   228      45.210  62.211  36.991  1.00 85.50           C  
ATOM   3117  O   GLU   228      44.288  61.895  36.247  1.00 84.81           O  
ATOM   3118  CB  GLU   228      45.757  61.781  39.408  1.00 87.01           C  
ATOM   3119  CG  GLU   228      46.501  62.670  40.394  1.00 89.88           C  
ATOM   3120  CD  GLU   228      46.612  62.040  41.770  1.00 93.66           C  
ATOM   3121  OE1 GLU   228      46.266  62.723  42.759  1.00 94.15           O  
ATOM   3122  OE2 GLU   228      47.029  60.857  41.859  1.00 94.91           O  
ATOM   3123  N   ALA   229      46.486  62.239  36.608  1.00 84.35           N  
ATOM   3124  CA  ALA   229      46.906  61.929  35.241  1.00 82.60           C  
ATOM   3125  C   ALA   229      47.145  60.431  35.095  1.00 81.39           C  
ATOM   3126  O   ALA   229      47.444  59.757  36.095  1.00 80.76           O  
ATOM   3127  CB  ALA   229      48.147  62.717  34.875  1.00 82.24           C  
ATOM   3128  N   PRO   230      47.005  59.912  33.850  1.00 80.34           N  
ATOM   3129  CA  PRO   230      47.079  58.488  33.551  1.00 79.67           C  
ATOM   3130  C   PRO   230      48.490  57.998  33.807  1.00 79.33           C  
ATOM   3131  O   PRO   230      49.441  58.728  33.544  1.00 79.37           O  
ATOM   3132  CB  PRO   230      46.791  58.446  32.060  1.00 79.50           C  
ATOM   3133  CG  PRO   230      47.291  59.746  31.566  1.00 79.05           C  
ATOM   3134  CD  PRO   230      46.788  60.679  32.610  1.00 80.01           C  
ATOM   3135  N   SER   231      48.618  56.787  34.331  1.00 78.06           N  
ATOM   3136  CA  SER   231      49.889  56.293  34.756  1.00 77.44           C  
ATOM   3137  C   SER   231      49.764  54.794  34.771  1.00 77.76           C  
ATOM   3138  O   SER   231      48.660  54.257  34.891  1.00 77.53           O  
ATOM   3139  CB  SER   231      50.167  56.775  36.161  1.00 77.01           C  
ATOM   3140  OG  SER   231      49.558  55.912  37.102  1.00 76.78           O  
ATOM   3141  N   SER   232      50.882  54.093  34.662  1.00 77.58           N  
ATOM   3142  CA  SER   232      50.761  52.664  34.703  1.00 77.72           C  
ATOM   3143  C   SER   232      50.582  52.211  36.124  1.00 77.42           C  
ATOM   3144  O   SER   232      50.033  51.143  36.326  1.00 78.13           O  
ATOM   3145  CB  SER   232      51.926  51.958  34.038  1.00 77.32           C  
ATOM   3146  OG  SER   232      53.123  52.333  34.672  1.00 80.66           O  
ATOM   3147  N   GLN   233      51.023  53.005  37.106  1.00 77.03           N  
ATOM   3148  CA  GLN   233      50.759  52.656  38.518  1.00 76.52           C  
ATOM   3149  C   GLN   233      49.248  52.585  38.710  1.00 77.02           C  
ATOM   3150  O   GLN   233      48.710  51.699  39.382  1.00 76.52           O  
ATOM   3151  CB  GLN   233      51.331  53.665  39.512  1.00 75.54           C  
ATOM   3152  CG  GLN   233      50.857  53.389  40.915  1.00 72.24           C  
ATOM   3153  CD  GLN   233      51.261  54.449  41.915  1.00 73.31           C  
ATOM   3154  OE1 GLN   233      51.663  55.559  41.563  1.00 74.54           O  
ATOM   3155  NE2 GLN   233      51.161  54.109  43.190  1.00 74.95           N  
ATOM   3156  N   LEU   234      48.566  53.522  38.088  1.00 77.12           N  
ATOM   3157  CA  LEU   234      47.147  53.527  38.196  1.00 77.96           C  
ATOM   3158  C   LEU   234      46.530  52.232  37.636  1.00 78.74           C  
ATOM   3159  O   LEU   234      45.608  51.708  38.248  1.00 79.47           O  
ATOM   3160  CB  LEU   234      46.584  54.758  37.521  1.00 77.70           C  
ATOM   3161  CG  LEU   234      45.370  55.355  38.177  1.00 79.13           C  
ATOM   3162  CD1 LEU   234      44.947  56.555  37.375  1.00 82.80           C  
ATOM   3163  CD2 LEU   234      44.222  54.330  38.267  1.00 80.77           C  
ATOM   3164  N   GLY   235      47.029  51.718  36.500  1.00 79.10           N  
ATOM   3165  CA  GLY   235      46.478  50.499  35.880  1.00 78.47           C  
ATOM   3166  C   GLY   235      46.785  49.249  36.687  1.00 78.51           C  
ATOM   3167  O   GLY   235      45.963  48.374  36.811  1.00 78.65           O  
ATOM   3168  N   ALA   236      47.985  49.156  37.222  1.00 79.07           N  
ATOM   3169  CA  ALA   236      48.313  48.110  38.190  1.00 79.99           C  
ATOM   3170  C   ALA   236      47.314  48.145  39.331  1.00 80.11           C  
ATOM   3171  O   ALA   236      46.516  47.236  39.528  1.00 80.82           O  
ATOM   3172  CB  ALA   236      49.721  48.320  38.744  1.00 79.45           C  
ATOM   3173  N   GLU   237      47.336  49.226  40.078  1.00 80.17           N  
ATOM   3174  CA  GLU   237      46.568  49.254  41.290  1.00 79.92           C  
ATOM   3175  C   GLU   237      45.127  49.207  40.916  1.00 79.99           C  
ATOM   3176  O   GLU   237      44.324  48.569  41.598  1.00 81.06           O  
ATOM   3177  CB  GLU   237      46.919  50.465  42.102  1.00 79.24           C  
ATOM   3178  CG  GLU   237      48.337  50.394  42.513  1.00 79.76           C  
ATOM   3179  CD  GLU   237      48.812  51.687  43.053  1.00 84.93           C  
ATOM   3180  OE1 GLU   237      49.783  51.685  43.842  1.00 89.59           O  
ATOM   3181  OE2 GLU   237      48.216  52.724  42.706  1.00 87.95           O  
ATOM   3182  N   GLY   238      44.802  49.827  39.792  1.00 79.75           N  
ATOM   3183  CA  GLY   238      43.430  49.763  39.256  1.00 79.00           C  
ATOM   3184  C   GLY   238      42.989  48.320  39.201  1.00 77.94           C  
ATOM   3185  O   GLY   238      41.979  47.950  39.823  1.00 78.05           O  
ATOM   3186  N   LEU   239      43.773  47.499  38.500  1.00 76.52           N  
ATOM   3187  CA  LEU   239      43.450  46.101  38.382  1.00 75.69           C  
ATOM   3188  C   LEU   239      43.298  45.514  39.771  1.00 75.56           C  
ATOM   3189  O   LEU   239      42.265  44.888  40.092  1.00 75.42           O  
ATOM   3190  CB  LEU   239      44.538  45.355  37.665  1.00 75.82           C  
ATOM   3191  CG  LEU   239      44.167  44.117  36.844  1.00 75.08           C  
ATOM   3192  CD1 LEU   239      45.276  43.100  36.964  1.00 71.28           C  
ATOM   3193  CD2 LEU   239      42.840  43.508  37.195  1.00 73.29           C  
ATOM   3194  N   ALA   240      44.302  45.739  40.613  1.00 75.04           N  
ATOM   3195  CA  ALA   240      44.243  45.216  41.986  1.00 74.69           C  
ATOM   3196  C   ALA   240      42.893  45.477  42.653  1.00 74.79           C  
ATOM   3197  O   ALA   240      42.198  44.533  43.034  1.00 74.63           O  
ATOM   3198  CB  ALA   240      45.359  45.736  42.823  1.00 73.80           C  
ATOM   3199  N   LYS   241      42.507  46.743  42.764  1.00 75.18           N  
ATOM   3200  CA  LYS   241      41.346  47.095  43.555  1.00 76.31           C  
ATOM   3201  C   LYS   241      40.051  46.506  42.967  1.00 76.89           C  
ATOM   3202  O   LYS   241      39.150  46.100  43.704  1.00 76.65           O  
ATOM   3203  CB  LYS   241      41.230  48.606  43.696  1.00 77.02           C  
ATOM   3204  CG  LYS   241      42.432  49.312  44.336  1.00 79.16           C  
ATOM   3205  CD  LYS   241      41.960  50.650  44.905  1.00 83.08           C  
ATOM   3206  CE  LYS   241      43.102  51.600  45.260  1.00 86.88           C  
ATOM   3207  NZ  LYS   241      43.539  52.449  44.099  1.00 90.07           N  
ATOM   3208  N   LEU   242      39.967  46.448  41.640  1.00 77.59           N  
ATOM   3209  CA  LEU   242      38.846  45.799  40.996  1.00 78.27           C  
ATOM   3210  C   LEU   242      38.787  44.308  41.355  1.00 78.63           C  
ATOM   3211  O   LEU   242      37.764  43.814  41.804  1.00 78.46           O  
ATOM   3212  CB  LEU   242      38.903  46.022  39.480  1.00 78.55           C  
ATOM   3213  CG  LEU   242      38.591  47.426  38.937  1.00 78.41           C  
ATOM   3214  CD1 LEU   242      38.297  47.335  37.480  1.00 78.32           C  
ATOM   3215  CD2 LEU   242      37.400  48.064  39.613  1.00 76.96           C  
ATOM   3216  N   LEU   243      39.904  43.608  41.184  1.00 79.41           N  
ATOM   3217  CA  LEU   243      40.029  42.229  41.647  1.00 79.93           C  
ATOM   3218  C   LEU   243      39.565  42.060  43.060  1.00 80.28           C  
ATOM   3219  O   LEU   243      39.089  40.995  43.404  1.00 81.87           O  
ATOM   3220  CB  LEU   243      41.481  41.776  41.598  1.00 79.58           C  
ATOM   3221  CG  LEU   243      41.994  40.912  40.448  1.00 80.56           C  
ATOM   3222  CD1 LEU   243      41.020  40.762  39.265  1.00 81.41           C  
ATOM   3223  CD2 LEU   243      43.334  41.430  39.975  1.00 80.94           C  
ATOM   3224  N   LEU   244      39.748  43.076  43.897  1.00 79.94           N  
ATOM   3225  CA  LEU   244      39.491  42.915  45.318  1.00 79.65           C  
ATOM   3226  C   LEU   244      38.041  43.245  45.590  1.00 80.53           C  
ATOM   3227  O   LEU   244      37.427  42.723  46.520  1.00 80.53           O  
ATOM   3228  CB  LEU   244      40.424  43.809  46.140  1.00 79.63           C  
ATOM   3229  CG  LEU   244      40.195  44.023  47.644  1.00 78.57           C  
ATOM   3230  CD1 LEU   244      40.535  42.772  48.389  1.00 80.14           C  
ATOM   3231  CD2 LEU   244      41.050  45.133  48.169  1.00 78.59           C  
ATOM   3232  N   ARG   245      37.514  44.157  44.782  1.00 81.43           N  
ATOM   3233  CA  ARG   245      36.104  44.454  44.754  1.00 81.46           C  
ATOM   3234  C   ARG   245      35.417  43.118  44.408  1.00 81.77           C  
ATOM   3235  O   ARG   245      34.539  42.669  45.140  1.00 81.58           O  
ATOM   3236  CB  ARG   245      35.838  45.576  43.724  1.00 81.30           C  
ATOM   3237  CG  ARG   245      34.440  46.194  43.750  1.00 82.92           C  
ATOM   3238  CD  ARG   245      34.456  47.706  43.527  1.00 86.21           C  
ATOM   3239  NE  ARG   245      33.213  48.354  44.017  1.00 91.72           N  
ATOM   3240  CZ  ARG   245      32.935  48.729  45.297  1.00 91.05           C  
ATOM   3241  NH1 ARG   245      33.784  48.526  46.318  1.00 87.40           N  
ATOM   3242  NH2 ARG   245      31.772  49.324  45.563  1.00 89.97           N  
ATOM   3243  N   ASP   246      35.875  42.443  43.350  1.00 82.20           N  
ATOM   3244  CA  ASP   246      35.144  41.312  42.784  1.00 82.59           C  
ATOM   3245  C   ASP   246      35.994  40.486  41.807  1.00 82.66           C  
ATOM   3246  O   ASP   246      36.337  40.947  40.734  1.00 82.39           O  
ATOM   3247  CB  ASP   246      33.900  41.854  42.079  1.00 82.72           C  
ATOM   3248  CG  ASP   246      33.016  40.761  41.505  1.00 84.75           C  
ATOM   3249  OD1 ASP   246      31.801  40.773  41.815  1.00 86.71           O  
ATOM   3250  OD2 ASP   246      33.517  39.908  40.735  1.00 86.22           O  
ATOM   3251  N   SER   247      36.311  39.248  42.172  1.00 83.39           N  
ATOM   3252  CA  SER   247      37.240  38.423  41.364  1.00 83.24           C  
ATOM   3253  C   SER   247      36.642  37.914  40.067  1.00 83.14           C  
ATOM   3254  O   SER   247      37.365  37.639  39.119  1.00 84.49           O  
ATOM   3255  CB  SER   247      37.813  37.237  42.161  1.00 83.19           C  
ATOM   3256  OG  SER   247      36.788  36.346  42.615  1.00 83.91           O  
ATOM   3257  N   SER   248      35.338  37.779  39.977  1.00 82.77           N  
ATOM   3258  CA  SER   248      34.817  37.268  38.733  1.00 83.19           C  
ATOM   3259  C   SER   248      35.249  38.151  37.543  1.00 83.13           C  
ATOM   3260  O   SER   248      35.228  37.691  36.406  1.00 83.48           O  
ATOM   3261  CB  SER   248      33.309  37.140  38.792  1.00 83.03           C  
ATOM   3262  OG  SER   248      32.768  38.435  38.784  1.00 84.39           O  
ATOM   3263  N   LEU   249      35.657  39.397  37.813  1.00 83.13           N  
ATOM   3264  CA  LEU   249      36.135  40.353  36.787  1.00 82.64           C  
ATOM   3265  C   LEU   249      36.877  39.615  35.716  1.00 82.64           C  
ATOM   3266  O   LEU   249      37.651  38.739  36.047  1.00 83.40           O  
ATOM   3267  CB  LEU   249      37.087  41.356  37.404  1.00 82.11           C  
ATOM   3268  CG  LEU   249      37.791  42.260  36.391  1.00 83.16           C  
ATOM   3269  CD1 LEU   249      36.932  43.464  36.112  1.00 83.79           C  
ATOM   3270  CD2 LEU   249      39.157  42.713  36.873  1.00 81.01           C  
ATOM   3271  N   ASN   250      36.656  39.946  34.448  1.00 82.36           N  
ATOM   3272  CA  ASN   250      37.342  39.240  33.369  1.00 82.52           C  
ATOM   3273  C   ASN   250      37.651  40.026  32.087  1.00 83.30           C  
ATOM   3274  O   ASN   250      38.069  39.448  31.095  1.00 83.64           O  
ATOM   3275  CB  ASN   250      36.637  37.926  33.046  1.00 82.21           C  
ATOM   3276  CG  ASN   250      35.394  38.103  32.221  1.00 81.28           C  
ATOM   3277  OD1 ASN   250      35.194  39.113  31.571  1.00 83.19           O  
ATOM   3278  ND2 ASN   250      34.555  37.098  32.227  1.00 80.62           N  
ATOM   3279  N   ALA   251      37.426  41.333  32.108  1.00 84.24           N  
ATOM   3280  CA  ALA   251      38.035  42.235  31.119  1.00 85.17           C  
ATOM   3281  C   ALA   251      38.202  43.674  31.666  1.00 85.56           C  
ATOM   3282  O   ALA   251      37.555  44.055  32.666  1.00 85.84           O  
ATOM   3283  CB  ALA   251      37.249  42.233  29.821  1.00 84.51           C  
ATOM   3284  N   LEU   252      39.032  44.465  31.000  1.00 85.03           N  
ATOM   3285  CA  LEU   252      39.224  45.832  31.410  1.00 85.80           C  
ATOM   3286  C   LEU   252      39.114  46.825  30.272  1.00 86.02           C  
ATOM   3287  O   LEU   252      39.662  46.583  29.186  1.00 86.98           O  
ATOM   3288  CB  LEU   252      40.613  45.952  31.998  1.00 86.34           C  
ATOM   3289  CG  LEU   252      40.856  46.259  33.464  1.00 86.70           C  
ATOM   3290  CD1 LEU   252      39.724  45.801  34.310  1.00 86.48           C  
ATOM   3291  CD2 LEU   252      42.162  45.577  33.868  1.00 88.38           C  
ATOM   3292  N   VAL   253      38.434  47.947  30.501  1.00 85.70           N  
ATOM   3293  CA  VAL   253      38.505  49.059  29.547  1.00 85.61           C  
ATOM   3294  C   VAL   253      39.384  50.110  30.187  1.00 86.01           C  
ATOM   3295  O   VAL   253      39.072  50.601  31.254  1.00 87.31           O  
ATOM   3296  CB  VAL   253      37.138  49.732  29.270  1.00 85.41           C  
ATOM   3297  CG1 VAL   253      37.299  50.868  28.281  1.00 83.63           C  
ATOM   3298  CG2 VAL   253      36.116  48.753  28.759  1.00 84.62           C  
ATOM   3299  N   CYS   254      40.470  50.473  29.547  1.00 85.81           N  
ATOM   3300  CA  CYS   254      41.311  51.516  30.071  1.00 85.82           C  
ATOM   3301  C   CYS   254      41.166  52.796  29.277  1.00 85.90           C  
ATOM   3302  O   CYS   254      41.260  52.787  28.022  1.00 86.76           O  
ATOM   3303  CB  CYS   254      42.750  51.076  29.968  1.00 86.09           C  
ATOM   3304  SG  CYS   254      43.022  49.648  30.943  1.00 87.05           S  
ATOM   3305  N   SER   255      41.006  53.903  29.992  1.00 84.47           N  
ATOM   3306  CA  SER   255      40.847  55.172  29.330  1.00 83.85           C  
ATOM   3307  C   SER   255      42.078  55.569  28.498  1.00 83.36           C  
ATOM   3308  O   SER   255      41.943  56.300  27.498  1.00 83.50           O  
ATOM   3309  CB  SER   255      40.566  56.249  30.348  1.00 83.72           C  
ATOM   3310  OG  SER   255      41.766  56.625  30.974  1.00 84.32           O  
ATOM   3311  N   HIS   256      43.248  55.075  28.906  1.00 81.70           N  
ATOM   3312  CA  HIS   256      44.527  55.571  28.419  1.00 80.68           C  
ATOM   3313  C   HIS   256      45.512  54.444  28.269  1.00 81.83           C  
ATOM   3314  O   HIS   256      45.438  53.425  28.959  1.00 82.07           O  
ATOM   3315  CB  HIS   256      45.162  56.514  29.435  1.00 79.68           C  
ATOM   3316  CG  HIS   256      44.628  57.896  29.397  1.00 75.29           C  
ATOM   3317  ND1 HIS   256      43.323  58.193  29.705  1.00 73.05           N  
ATOM   3318  CD2 HIS   256      45.229  59.071  29.111  1.00 72.69           C  
ATOM   3319  CE1 HIS   256      43.138  59.496  29.601  1.00 73.77           C  
ATOM   3320  NE2 HIS   256      44.279  60.054  29.237  1.00 71.70           N  
ATOM   3321  N   GLU   257      46.496  54.661  27.412  1.00 82.44           N  
ATOM   3322  CA  GLU   257      47.441  53.611  27.098  1.00 82.31           C  
ATOM   3323  C   GLU   257      48.394  53.288  28.235  1.00 81.42           C  
ATOM   3324  O   GLU   257      48.726  52.121  28.432  1.00 80.55           O  
ATOM   3325  CB  GLU   257      48.198  53.968  25.835  1.00 82.78           C  
ATOM   3326  CG  GLU   257      48.803  52.806  25.111  1.00 83.56           C  
ATOM   3327  CD  GLU   257      49.789  53.282  24.108  1.00 86.39           C  
ATOM   3328  OE1 GLU   257      50.529  54.253  24.425  1.00 88.34           O  
ATOM   3329  OE2 GLU   257      49.816  52.709  22.996  1.00 87.47           O  
ATOM   3330  N   GLU   258      48.829  54.308  28.978  1.00 81.44           N  
ATOM   3331  CA  GLU   258      49.629  54.073  30.226  1.00 81.37           C  
ATOM   3332  C   GLU   258      48.894  53.151  31.197  1.00 80.61           C  
ATOM   3333  O   GLU   258      49.465  52.222  31.746  1.00 80.28           O  
ATOM   3334  CB  GLU   258      49.958  55.370  30.942  1.00 81.09           C  
ATOM   3335  CG  GLU   258      50.756  56.303  30.103  1.00 84.47           C  
ATOM   3336  CD  GLU   258      50.012  57.578  29.721  1.00 89.55           C  
ATOM   3337  OE1 GLU   258      48.869  57.541  29.169  1.00 87.61           O  
ATOM   3338  OE2 GLU   258      50.630  58.643  29.973  1.00 93.93           O  
ATOM   3339  N   ILE   259      47.600  53.401  31.350  1.00 80.21           N  
ATOM   3340  CA  ILE   259      46.764  52.619  32.222  1.00 80.11           C  
ATOM   3341  C   ILE   259      46.742  51.144  31.812  1.00 80.24           C  
ATOM   3342  O   ILE   259      46.965  50.250  32.626  1.00 80.65           O  
ATOM   3343  CB  ILE   259      45.379  53.229  32.232  1.00 79.76           C  
ATOM   3344  CG1 ILE   259      45.480  54.624  32.840  1.00 80.71           C  
ATOM   3345  CG2 ILE   259      44.394  52.329  32.950  1.00 79.34           C  
ATOM   3346  CD1 ILE   259      44.325  55.559  32.565  1.00 81.97           C  
ATOM   3347  N   ALA   260      46.507  50.902  30.535  1.00 80.27           N  
ATOM   3348  CA  ALA   260      46.356  49.566  30.034  1.00 79.77           C  
ATOM   3349  C   ALA   260      47.669  48.847  30.160  1.00 79.71           C  
ATOM   3350  O   ALA   260      47.700  47.641  30.270  1.00 79.58           O  
ATOM   3351  CB  ALA   260      45.945  49.623  28.594  1.00 80.65           C  
ATOM   3352  N   ILE   261      48.767  49.584  30.132  1.00 79.78           N  
ATOM   3353  CA  ILE   261      50.069  48.958  30.234  1.00 79.85           C  
ATOM   3354  C   ILE   261      50.293  48.515  31.678  1.00 80.61           C  
ATOM   3355  O   ILE   261      50.737  47.375  31.943  1.00 80.58           O  
ATOM   3356  CB  ILE   261      51.156  49.917  29.793  1.00 79.31           C  
ATOM   3357  CG1 ILE   261      51.105  50.043  28.276  1.00 81.41           C  
ATOM   3358  CG2 ILE   261      52.498  49.436  30.232  1.00 77.40           C  
ATOM   3359  CD1 ILE   261      51.792  48.907  27.512  1.00 84.06           C  
ATOM   3360  N   GLY   262      49.980  49.413  32.612  1.00 80.40           N  
ATOM   3361  CA  GLY   262      50.056  49.061  34.007  1.00 80.65           C  
ATOM   3362  C   GLY   262      49.307  47.762  34.166  1.00 80.88           C  
ATOM   3363  O   GLY   262      49.828  46.808  34.722  1.00 81.27           O  
ATOM   3364  N   ALA   263      48.093  47.717  33.631  1.00 81.05           N  
ATOM   3365  CA  ALA   263      47.205  46.595  33.852  1.00 81.34           C  
ATOM   3366  C   ALA   263      47.828  45.313  33.311  1.00 82.15           C  
ATOM   3367  O   ALA   263      47.917  44.328  34.041  1.00 82.89           O  
ATOM   3368  CB  ALA   263      45.868  46.867  33.226  1.00 80.54           C  
ATOM   3369  N   LEU   264      48.280  45.346  32.050  1.00 82.57           N  
ATOM   3370  CA  LEU   264      48.885  44.204  31.350  1.00 82.63           C  
ATOM   3371  C   LEU   264      50.021  43.614  32.157  1.00 83.42           C  
ATOM   3372  O   LEU   264      50.038  42.426  32.456  1.00 84.14           O  
ATOM   3373  CB  LEU   264      49.463  44.649  30.004  1.00 82.03           C  
ATOM   3374  CG  LEU   264      49.329  43.693  28.809  1.00 82.31           C  
ATOM   3375  CD1 LEU   264      50.477  43.882  27.850  1.00 83.64           C  
ATOM   3376  CD2 LEU   264      49.224  42.220  29.158  1.00 82.40           C  
ATOM   3377  N   PHE   265      50.985  44.467  32.483  1.00 83.88           N  
ATOM   3378  CA  PHE   265      52.086  44.109  33.320  1.00 83.77           C  
ATOM   3379  C   PHE   265      51.622  43.507  34.642  1.00 83.96           C  
ATOM   3380  O   PHE   265      52.248  42.571  35.128  1.00 84.61           O  
ATOM   3381  CB  PHE   265      52.920  45.342  33.578  1.00 83.96           C  
ATOM   3382  CG  PHE   265      53.969  45.592  32.545  1.00 85.31           C  
ATOM   3383  CD1 PHE   265      54.675  44.531  31.965  1.00 86.87           C  
ATOM   3384  CD2 PHE   265      54.316  46.895  32.189  1.00 86.60           C  
ATOM   3385  CE1 PHE   265      55.683  44.767  31.018  1.00 86.32           C  
ATOM   3386  CE2 PHE   265      55.343  47.144  31.238  1.00 85.63           C  
ATOM   3387  CZ  PHE   265      56.014  46.084  30.657  1.00 84.94           C  
ATOM   3388  N   GLU   266      50.534  44.017  35.222  1.00 83.47           N  
ATOM   3389  CA  GLU   266      50.076  43.521  36.529  1.00 83.66           C  
ATOM   3390  C   GLU   266      49.419  42.146  36.393  1.00 84.31           C  
ATOM   3391  O   GLU   266      49.481  41.324  37.316  1.00 84.28           O  
ATOM   3392  CB  GLU   266      49.131  44.529  37.227  1.00 83.95           C  
ATOM   3393  CG  GLU   266      48.665  44.190  38.634  1.00 82.61           C  
ATOM   3394  CD  GLU   266      49.831  44.163  39.608  1.00 84.94           C  
ATOM   3395  OE1 GLU   266      50.880  44.748  39.219  1.00 86.56           O  
ATOM   3396  OE2 GLU   266      49.726  43.561  40.726  1.00 81.04           O  
ATOM   3397  N   CYS   267      48.781  41.906  35.245  1.00 84.70           N  
ATOM   3398  CA  CYS   267      48.246  40.596  34.932  1.00 85.28           C  
ATOM   3399  C   CYS   267      49.410  39.630  34.959  1.00 84.98           C  
ATOM   3400  O   CYS   267      49.389  38.628  35.677  1.00 85.53           O  
ATOM   3401  CB  CYS   267      47.648  40.615  33.550  1.00 85.97           C  
ATOM   3402  SG  CYS   267      46.056  41.419  33.472  1.00 90.56           S  
ATOM   3403  N   HIS   268      50.463  39.960  34.221  1.00 84.08           N  
ATOM   3404  CA  HIS   268      51.678  39.175  34.324  1.00 83.30           C  
ATOM   3405  C   HIS   268      52.142  38.917  35.762  1.00 81.89           C  
ATOM   3406  O   HIS   268      52.492  37.786  36.086  1.00 81.78           O  
ATOM   3407  CB  HIS   268      52.777  39.735  33.443  1.00 83.22           C  
ATOM   3408  CG  HIS   268      52.461  39.622  31.989  1.00 85.46           C  
ATOM   3409  ND1 HIS   268      53.184  40.267  31.011  1.00 86.53           N  
ATOM   3410  CD2 HIS   268      51.474  38.956  31.345  1.00 87.96           C  
ATOM   3411  CE1 HIS   268      52.670  39.996  29.829  1.00 84.77           C  
ATOM   3412  NE2 HIS   268      51.629  39.206  30.002  1.00 87.65           N  
ATOM   3413  N   ARG   269      52.097  39.930  36.623  1.00 80.16           N  
ATOM   3414  CA  ARG   269      52.585  39.750  38.001  1.00 78.66           C  
ATOM   3415  C   ARG   269      51.748  38.698  38.753  1.00 78.29           C  
ATOM   3416  O   ARG   269      52.281  37.860  39.503  1.00 77.61           O  
ATOM   3417  CB  ARG   269      52.597  41.066  38.789  1.00 77.55           C  
ATOM   3418  CG  ARG   269      53.533  40.970  39.951  1.00 76.08           C  
ATOM   3419  CD  ARG   269      53.725  42.245  40.730  1.00 73.34           C  
ATOM   3420  NE  ARG   269      52.597  42.430  41.631  1.00 71.11           N  
ATOM   3421  CZ  ARG   269      52.631  42.304  42.952  1.00 68.49           C  
ATOM   3422  NH1 ARG   269      53.751  42.031  43.609  1.00 67.24           N  
ATOM   3423  NH2 ARG   269      51.498  42.475  43.615  1.00 70.15           N  
ATOM   3424  N   ARG   270      50.440  38.743  38.512  1.00 77.23           N  
ATOM   3425  CA  ARG   270      49.484  37.999  39.290  1.00 76.19           C  
ATOM   3426  C   ARG   270      49.201  36.708  38.580  1.00 75.95           C  
ATOM   3427  O   ARG   270      48.387  35.900  39.018  1.00 75.43           O  
ATOM   3428  CB  ARG   270      48.203  38.800  39.411  1.00 76.37           C  
ATOM   3429  CG  ARG   270      48.399  40.257  39.742  1.00 74.85           C  
ATOM   3430  CD  ARG   270      47.141  40.820  40.363  1.00 72.59           C  
ATOM   3431  NE  ARG   270      47.443  42.022  41.138  1.00 70.63           N  
ATOM   3432  CZ  ARG   270      47.415  42.119  42.460  1.00 70.78           C  
ATOM   3433  NH1 ARG   270      47.057  41.106  43.240  1.00 70.72           N  
ATOM   3434  NH2 ARG   270      47.737  43.267  43.006  1.00 74.54           N  
ATOM   3435  N   VAL   271      49.905  36.525  37.467  1.00 75.84           N  
ATOM   3436  CA  VAL   271      49.743  35.346  36.612  1.00 74.88           C  
ATOM   3437  C   VAL   271      48.313  35.199  36.145  1.00 75.23           C  
ATOM   3438  O   VAL   271      47.847  34.101  36.023  1.00 75.71           O  
ATOM   3439  CB  VAL   271      50.197  34.017  37.312  1.00 74.43           C  
ATOM   3440  CG1 VAL   271      50.468  32.912  36.298  1.00 70.81           C  
ATOM   3441  CG2 VAL   271      51.399  34.254  38.213  1.00 73.03           C  
ATOM   3442  N   LEU   272      47.603  36.293  35.906  1.00 76.44           N  
ATOM   3443  CA  LEU   272      46.354  36.217  35.101  1.00 77.40           C  
ATOM   3444  C   LEU   272      46.669  36.270  33.586  1.00 77.51           C  
ATOM   3445  O   LEU   272      46.988  37.324  33.042  1.00 77.60           O  
ATOM   3446  CB  LEU   272      45.349  37.324  35.461  1.00 77.07           C  
ATOM   3447  CG  LEU   272      44.613  37.514  36.809  1.00 78.26           C  
ATOM   3448  CD1 LEU   272      43.810  36.322  37.267  1.00 77.82           C  
ATOM   3449  CD2 LEU   272      45.555  37.905  37.888  1.00 81.04           C  
ATOM   3450  N   LYS   273      46.598  35.126  32.914  1.00 77.78           N  
ATOM   3451  CA  LYS   273      46.627  35.093  31.449  1.00 77.71           C  
ATOM   3452  C   LYS   273      45.803  36.201  30.738  1.00 76.95           C  
ATOM   3453  O   LYS   273      44.687  36.556  31.151  1.00 76.88           O  
ATOM   3454  CB  LYS   273      46.186  33.717  30.960  1.00 78.46           C  
ATOM   3455  CG  LYS   273      47.344  32.771  30.761  1.00 81.33           C  
ATOM   3456  CD  LYS   273      48.324  33.300  29.641  1.00 86.35           C  
ATOM   3457  CE  LYS   273      49.550  32.367  29.373  1.00 85.14           C  
ATOM   3458  NZ  LYS   273      49.243  31.298  28.380  1.00 88.29           N  
ATOM   3459  N   VAL   274      46.355  36.720  29.652  1.00 76.06           N  
ATOM   3460  CA  VAL   274      45.667  37.696  28.831  1.00 76.26           C  
ATOM   3461  C   VAL   274      45.513  37.167  27.387  1.00 77.43           C  
ATOM   3462  O   VAL   274      46.503  36.897  26.721  1.00 78.31           O  
ATOM   3463  CB  VAL   274      46.401  39.035  28.943  1.00 76.12           C  
ATOM   3464  CG1 VAL   274      45.889  40.072  27.980  1.00 74.36           C  
ATOM   3465  CG2 VAL   274      46.334  39.558  30.436  1.00 75.82           C  
ATOM   3466  N   PRO   275      44.269  37.015  26.880  1.00 78.20           N  
ATOM   3467  CA  PRO   275      42.963  37.409  27.389  1.00 78.84           C  
ATOM   3468  C   PRO   275      42.131  36.338  28.084  1.00 79.41           C  
ATOM   3469  O   PRO   275      40.998  36.623  28.471  1.00 79.46           O  
ATOM   3470  CB  PRO   275      42.230  37.809  26.105  1.00 78.68           C  
ATOM   3471  CG  PRO   275      42.751  36.848  25.092  1.00 78.47           C  
ATOM   3472  CD  PRO   275      44.138  36.407  25.546  1.00 78.30           C  
ATOM   3473  N   THR   276      42.630  35.120  28.236  1.00 80.07           N  
ATOM   3474  CA  THR   276      41.711  34.091  28.724  1.00 80.73           C  
ATOM   3475  C   THR   276      41.370  34.158  30.216  1.00 81.09           C  
ATOM   3476  O   THR   276      40.515  33.414  30.662  1.00 81.71           O  
ATOM   3477  CB  THR   276      42.116  32.659  28.335  1.00 80.48           C  
ATOM   3478  OG1 THR   276      43.346  32.336  28.966  1.00 81.49           O  
ATOM   3479  CG2 THR   276      42.268  32.525  26.830  1.00 81.18           C  
ATOM   3480  N   ASP   277      42.019  35.029  30.989  1.00 81.71           N  
ATOM   3481  CA  ASP   277      41.555  35.297  32.368  1.00 81.91           C  
ATOM   3482  C   ASP   277      41.077  36.709  32.434  1.00 81.75           C  
ATOM   3483  O   ASP   277      40.046  36.994  32.980  1.00 82.59           O  
ATOM   3484  CB  ASP   277      42.651  35.107  33.413  1.00 82.07           C  
ATOM   3485  CG  ASP   277      43.087  33.671  33.555  1.00 83.35           C  
ATOM   3486  OD1 ASP   277      42.200  32.805  33.764  1.00 84.57           O  
ATOM   3487  OD2 ASP   277      44.315  33.420  33.479  1.00 83.88           O  
ATOM   3488  N   ILE   278      41.855  37.608  31.875  1.00 81.75           N  
ATOM   3489  CA  ILE   278      41.415  38.958  31.732  1.00 81.55           C  
ATOM   3490  C   ILE   278      41.684  39.411  30.284  1.00 81.63           C  
ATOM   3491  O   ILE   278      42.785  39.182  29.730  1.00 81.02           O  
ATOM   3492  CB  ILE   278      42.078  39.807  32.819  1.00 81.80           C  
ATOM   3493  CG1 ILE   278      41.279  39.615  34.132  1.00 82.82           C  
ATOM   3494  CG2 ILE   278      42.174  41.269  32.401  1.00 81.69           C  
ATOM   3495  CD1 ILE   278      41.974  40.012  35.402  1.00 81.58           C  
ATOM   3496  N   ALA   279      40.655  39.969  29.651  1.00 80.88           N  
ATOM   3497  CA  ALA   279      40.844  40.618  28.369  1.00 81.25           C  
ATOM   3498  C   ALA   279      41.083  42.109  28.584  1.00 81.18           C  
ATOM   3499  O   ALA   279      40.575  42.674  29.537  1.00 82.19           O  
ATOM   3500  CB  ALA   279      39.641  40.405  27.513  1.00 81.61           C  
ATOM   3501  N   ILE   280      41.826  42.769  27.712  1.00 80.88           N  
ATOM   3502  CA  ILE   280      42.109  44.188  27.939  1.00 80.85           C  
ATOM   3503  C   ILE   280      41.836  45.024  26.693  1.00 81.76           C  
ATOM   3504  O   ILE   280      42.144  44.605  25.564  1.00 82.66           O  
ATOM   3505  CB  ILE   280      43.595  44.413  28.419  1.00 80.89           C  
ATOM   3506  CG1 ILE   280      43.809  43.922  29.865  1.00 79.90           C  
ATOM   3507  CG2 ILE   280      43.988  45.887  28.363  1.00 79.91           C  
ATOM   3508  CD1 ILE   280      45.294  43.804  30.291  1.00 79.26           C  
ATOM   3509  N   ILE   281      41.300  46.224  26.863  1.00 81.46           N  
ATOM   3510  CA  ILE   281      41.121  47.068  25.675  1.00 81.24           C  
ATOM   3511  C   ILE   281      41.394  48.532  25.992  1.00 81.42           C  
ATOM   3512  O   ILE   281      40.860  49.073  26.967  1.00 81.87           O  
ATOM   3513  CB  ILE   281      39.710  46.858  25.035  1.00 81.39           C  
ATOM   3514  CG1 ILE   281      39.680  47.507  23.648  1.00 81.23           C  
ATOM   3515  CG2 ILE   281      38.570  47.299  26.009  1.00 80.21           C  
ATOM   3516  CD1 ILE   281      38.335  47.725  23.069  1.00 77.98           C  
ATOM   3517  N   CYS   282      42.227  49.178  25.187  1.00 81.39           N  
ATOM   3518  CA  CYS   282      42.668  50.538  25.517  1.00 81.35           C  
ATOM   3519  C   CYS   282      41.896  51.518  24.697  1.00 81.30           C  
ATOM   3520  O   CYS   282      41.590  51.248  23.547  1.00 81.66           O  
ATOM   3521  CB  CYS   282      44.147  50.710  25.237  1.00 81.07           C  
ATOM   3522  SG  CYS   282      44.722  52.425  25.344  1.00 82.39           S  
ATOM   3523  N   LEU   283      41.570  52.661  25.273  1.00 81.28           N  
ATOM   3524  CA  LEU   283      40.664  53.593  24.583  1.00 81.05           C  
ATOM   3525  C   LEU   283      41.380  54.608  23.684  1.00 81.11           C  
ATOM   3526  O   LEU   283      40.730  55.408  23.004  1.00 80.38           O  
ATOM   3527  CB  LEU   283      39.812  54.326  25.619  1.00 81.16           C  
ATOM   3528  CG  LEU   283      38.326  53.980  25.772  1.00 80.91           C  
ATOM   3529  CD1 LEU   283      37.959  52.551  25.366  1.00 81.11           C  
ATOM   3530  CD2 LEU   283      37.855  54.275  27.195  1.00 80.76           C  
ATOM   3531  N   GLU   284      42.716  54.583  23.706  1.00 81.12           N  
ATOM   3532  CA  GLU   284      43.532  55.544  22.971  1.00 81.87           C  
ATOM   3533  C   GLU   284      44.925  54.982  22.838  1.00 81.92           C  
ATOM   3534  O   GLU   284      45.863  55.460  23.473  1.00 82.86           O  
ATOM   3535  CB  GLU   284      43.571  56.913  23.663  1.00 81.14           C  
ATOM   3536  CG  GLU   284      44.092  58.032  22.774  1.00 82.40           C  
ATOM   3537  CD  GLU   284      44.717  59.220  23.536  1.00 83.80           C  
ATOM   3538  OE1 GLU   284      45.325  59.021  24.637  1.00 86.52           O  
ATOM   3539  OE2 GLU   284      44.629  60.364  23.002  1.00 85.86           O  
ATOM   3540  N   GLY   285      45.056  53.937  22.034  1.00 82.25           N  
ATOM   3541  CA  GLY   285      46.353  53.284  21.813  1.00 82.49           C  
ATOM   3542  C   GLY   285      47.267  53.991  20.828  1.00 82.72           C  
ATOM   3543  O   GLY   285      46.853  54.829  20.037  1.00 83.15           O  
ATOM   3544  N   SER   286      48.533  53.653  20.905  1.00 82.98           N  
ATOM   3545  CA  SER   286      49.527  54.126  19.986  1.00 83.27           C  
ATOM   3546  C   SER   286      50.352  52.890  19.659  1.00 83.62           C  
ATOM   3547  O   SER   286      50.068  51.794  20.156  1.00 83.96           O  
ATOM   3548  CB  SER   286      50.415  55.144  20.698  1.00 83.98           C  
ATOM   3549  OG  SER   286      51.532  54.520  21.344  1.00 83.20           O  
ATOM   3550  N   SER   287      51.409  53.062  18.883  1.00 83.50           N  
ATOM   3551  CA  SER   287      52.313  51.954  18.609  1.00 83.23           C  
ATOM   3552  C   SER   287      52.865  51.370  19.895  1.00 82.51           C  
ATOM   3553  O   SER   287      53.332  50.230  19.918  1.00 82.19           O  
ATOM   3554  CB  SER   287      53.461  52.434  17.738  1.00 83.21           C  
ATOM   3555  OG  SER   287      54.187  53.392  18.470  1.00 84.46           O  
ATOM   3556  N   MET   288      52.798  52.151  20.967  1.00 82.36           N  
ATOM   3557  CA  MET   288      53.336  51.723  22.269  1.00 82.73           C  
ATOM   3558  C   MET   288      52.685  50.447  22.698  1.00 81.57           C  
ATOM   3559  O   MET   288      53.353  49.471  22.970  1.00 80.97           O  
ATOM   3560  CB  MET   288      53.148  52.813  23.319  1.00 83.18           C  
ATOM   3561  CG  MET   288      52.963  52.326  24.721  1.00 89.04           C  
ATOM   3562  SD  MET   288      54.574  51.903  25.725  0.80105.94          SE  
ATOM   3563  CE  MET   288      55.558  53.606  25.569  1.00 99.22           C  
ATOM   3564  N   GLY   289      51.356  50.474  22.697  1.00 81.59           N  
ATOM   3565  CA  GLY   289      50.536  49.378  23.123  1.00 80.65           C  
ATOM   3566  C   GLY   289      50.502  48.338  22.054  1.00 80.78           C  
ATOM   3567  O   GLY   289      50.423  47.174  22.361  1.00 81.79           O  
ATOM   3568  N   GLU   290      50.561  48.749  20.792  1.00 80.73           N  
ATOM   3569  CA  GLU   290      50.595  47.806  19.661  1.00 80.56           C  
ATOM   3570  C   GLU   290      51.689  46.760  19.799  1.00 80.60           C  
ATOM   3571  O   GLU   290      51.555  45.650  19.285  1.00 80.71           O  
ATOM   3572  CB  GLU   290      50.832  48.544  18.346  1.00 80.31           C  
ATOM   3573  CG  GLU   290      50.862  47.612  17.159  1.00 81.56           C  
ATOM   3574  CD  GLU   290      51.363  48.285  15.913  1.00 83.89           C  
ATOM   3575  OE1 GLU   290      51.760  49.463  16.044  1.00 86.52           O  
ATOM   3576  OE2 GLU   290      51.370  47.653  14.816  1.00 82.25           O  
ATOM   3577  N   HIS   291      52.781  47.126  20.466  1.00 80.18           N  
ATOM   3578  CA  HIS   291      53.913  46.253  20.524  1.00 80.05           C  
ATOM   3579  C   HIS   291      54.216  45.812  21.935  1.00 81.23           C  
ATOM   3580  O   HIS   291      55.373  45.528  22.261  1.00 81.74           O  
ATOM   3581  CB  HIS   291      55.128  46.923  19.904  1.00 79.38           C  
ATOM   3582  CG  HIS   291      55.208  46.775  18.421  1.00 76.46           C  
ATOM   3583  ND1 HIS   291      54.601  47.655  17.550  1.00 74.30           N  
ATOM   3584  CD2 HIS   291      55.824  45.848  17.653  1.00 73.89           C  
ATOM   3585  CE1 HIS   291      54.844  47.283  16.309  1.00 72.44           C  
ATOM   3586  NE2 HIS   291      55.579  46.185  16.344  1.00 73.21           N  
ATOM   3587  N   ALA   292      53.187  45.773  22.778  1.00 81.96           N  
ATOM   3588  CA  ALA   292      53.274  45.117  24.078  1.00 82.59           C  
ATOM   3589  C   ALA   292      53.062  43.600  23.888  1.00 83.24           C  
ATOM   3590  O   ALA   292      52.928  43.144  22.767  1.00 84.32           O  
ATOM   3591  CB  ALA   292      52.243  45.676  24.962  1.00 82.78           C  
ATOM   3592  N   TYR   293      53.059  42.814  24.956  1.00 83.78           N  
ATOM   3593  CA  TYR   293      52.790  41.380  24.851  1.00 84.14           C  
ATOM   3594  C   TYR   293      51.913  40.864  25.987  1.00 84.11           C  
ATOM   3595  O   TYR   293      52.261  41.049  27.147  1.00 84.38           O  
ATOM   3596  CB  TYR   293      54.072  40.586  24.911  1.00 84.66           C  
ATOM   3597  CG  TYR   293      53.806  39.097  24.974  1.00 86.11           C  
ATOM   3598  CD1 TYR   293      53.805  38.418  26.196  1.00 86.38           C  
ATOM   3599  CD2 TYR   293      53.535  38.368  23.806  1.00 86.68           C  
ATOM   3600  CE1 TYR   293      53.554  37.053  26.256  1.00 86.76           C  
ATOM   3601  CE2 TYR   293      53.289  37.001  23.851  1.00 86.49           C  
ATOM   3602  CZ  TYR   293      53.300  36.357  25.081  1.00 86.96           C  
ATOM   3603  OH  TYR   293      53.043  35.015  25.134  1.00 87.32           O  
ATOM   3604  N   PRO   294      50.782  40.212  25.664  1.00 83.61           N  
ATOM   3605  CA  PRO   294      50.186  40.103  24.344  1.00 83.14           C  
ATOM   3606  C   PRO   294      49.870  41.513  23.883  1.00 82.69           C  
ATOM   3607  O   PRO   294      49.586  42.348  24.729  1.00 83.29           O  
ATOM   3608  CB  PRO   294      48.879  39.374  24.637  1.00 82.88           C  
ATOM   3609  CG  PRO   294      49.141  38.596  25.828  1.00 82.74           C  
ATOM   3610  CD  PRO   294      49.976  39.497  26.665  1.00 83.43           C  
ATOM   3611  N   SER   295      49.947  41.790  22.584  1.00 81.63           N  
ATOM   3612  CA  SER   295      49.701  43.126  22.058  1.00 80.96           C  
ATOM   3613  C   SER   295      48.275  43.461  22.357  1.00 81.34           C  
ATOM   3614  O   SER   295      47.440  42.558  22.446  1.00 81.90           O  
ATOM   3615  CB  SER   295      49.830  43.093  20.559  1.00 81.04           C  
ATOM   3616  OG  SER   295      49.004  42.066  20.053  1.00 80.89           O  
ATOM   3617  N   LEU   296      47.936  44.737  22.478  1.00 81.03           N  
ATOM   3618  CA  LEU   296      46.570  44.976  22.908  1.00 80.63           C  
ATOM   3619  C   LEU   296      45.616  45.704  21.996  1.00 79.83           C  
ATOM   3620  O   LEU   296      45.924  46.746  21.427  1.00 79.65           O  
ATOM   3621  CB  LEU   296      46.506  45.529  24.347  1.00 81.66           C  
ATOM   3622  CG  LEU   296      47.613  46.402  24.916  1.00 81.55           C  
ATOM   3623  CD1 LEU   296      47.722  47.649  24.054  1.00 81.34           C  
ATOM   3624  CD2 LEU   296      47.280  46.701  26.377  1.00 79.93           C  
ATOM   3625  N   THR   297      44.437  45.114  21.903  1.00 79.07           N  
ATOM   3626  CA  THR   297      43.313  45.677  21.198  1.00 79.14           C  
ATOM   3627  C   THR   297      43.068  47.087  21.679  1.00 79.58           C  
ATOM   3628  O   THR   297      42.826  47.311  22.854  1.00 81.39           O  
ATOM   3629  CB  THR   297      42.061  44.843  21.479  1.00 78.86           C  
ATOM   3630  OG1 THR   297      42.166  43.595  20.794  1.00 78.44           O  
ATOM   3631  CG2 THR   297      40.802  45.559  21.036  1.00 78.03           C  
ATOM   3632  N   SER   298      43.105  48.046  20.777  1.00 79.51           N  
ATOM   3633  CA  SER   298      42.795  49.389  21.166  1.00 79.09           C  
ATOM   3634  C   SER   298      42.246  50.237  20.038  1.00 78.30           C  
ATOM   3635  O   SER   298      42.322  49.891  18.851  1.00 78.13           O  
ATOM   3636  CB  SER   298      44.065  50.048  21.618  1.00 79.90           C  
ATOM   3637  OG  SER   298      44.503  50.824  20.534  1.00 82.76           O  
ATOM   3638  N   ALA   299      41.750  51.391  20.443  1.00 77.50           N  
ATOM   3639  CA  ALA   299      41.158  52.355  19.545  1.00 77.20           C  
ATOM   3640  C   ALA   299      42.214  53.346  19.183  1.00 76.88           C  
ATOM   3641  O   ALA   299      42.933  53.800  20.055  1.00 77.33           O  
ATOM   3642  CB  ALA   299      40.041  53.064  20.236  1.00 77.48           C  
ATOM   3643  N   GLU   300      42.312  53.691  17.902  1.00 76.19           N  
ATOM   3644  CA  GLU   300      43.326  54.630  17.472  1.00 75.41           C  
ATOM   3645  C   GLU   300      42.703  55.808  16.792  1.00 74.48           C  
ATOM   3646  O   GLU   300      41.589  55.705  16.319  1.00 74.51           O  
ATOM   3647  CB  GLU   300      44.326  53.941  16.566  1.00 76.01           C  
ATOM   3648  CG  GLU   300      45.229  52.989  17.335  1.00 77.18           C  
ATOM   3649  CD  GLU   300      46.257  52.373  16.456  1.00 78.27           C  
ATOM   3650  OE1 GLU   300      46.411  52.838  15.317  1.00 81.55           O  
ATOM   3651  OE2 GLU   300      46.916  51.421  16.892  1.00 79.79           O  
ATOM   3652  N   PHE   301      43.414  56.929  16.772  1.00 73.35           N  
ATOM   3653  CA  PHE   301      42.907  58.151  16.172  1.00 72.73           C  
ATOM   3654  C   PHE   301      44.040  58.747  15.362  1.00 72.26           C  
ATOM   3655  O   PHE   301      45.188  58.401  15.568  1.00 72.70           O  
ATOM   3656  CB  PHE   301      42.466  59.165  17.240  1.00 73.07           C  
ATOM   3657  CG  PHE   301      41.539  58.604  18.297  1.00 72.90           C  
ATOM   3658  CD1 PHE   301      40.168  58.748  18.179  1.00 73.42           C  
ATOM   3659  CD2 PHE   301      42.047  57.968  19.424  1.00 73.00           C  
ATOM   3660  CE1 PHE   301      39.319  58.249  19.142  1.00 73.89           C  
ATOM   3661  CE2 PHE   301      41.210  57.450  20.388  1.00 72.82           C  
ATOM   3662  CZ  PHE   301      39.845  57.599  20.256  1.00 74.30           C  
ATOM   3663  N   ASP   302      43.725  59.648  14.447  1.00 71.31           N  
ATOM   3664  CA  ASP   302      44.730  60.199  13.594  1.00 70.69           C  
ATOM   3665  C   ASP   302      44.826  61.684  13.899  1.00 70.98           C  
ATOM   3666  O   ASP   302      44.295  62.526  13.206  1.00 71.04           O  
ATOM   3667  CB  ASP   302      44.393  59.872  12.144  1.00 69.96           C  
ATOM   3668  CG  ASP   302      45.422  60.382  11.147  1.00 70.55           C  
ATOM   3669  OD1 ASP   302      45.106  60.217   9.948  1.00 71.95           O  
ATOM   3670  OD2 ASP   302      46.505  60.945  11.510  1.00 67.91           O  
ATOM   3671  N   TYR   303      45.522  62.008  14.968  1.00 71.92           N  
ATOM   3672  CA  TYR   303      45.611  63.391  15.358  1.00 73.12           C  
ATOM   3673  C   TYR   303      46.477  64.171  14.394  1.00 73.92           C  
ATOM   3674  O   TYR   303      46.251  65.362  14.211  1.00 74.47           O  
ATOM   3675  CB  TYR   303      46.108  63.540  16.799  1.00 73.26           C  
ATOM   3676  CG  TYR   303      45.215  62.899  17.838  1.00 73.56           C  
ATOM   3677  CD1 TYR   303      43.843  63.221  17.923  1.00 73.22           C  
ATOM   3678  CD2 TYR   303      45.739  61.977  18.753  1.00 74.58           C  
ATOM   3679  CE1 TYR   303      43.009  62.619  18.892  1.00 73.27           C  
ATOM   3680  CE2 TYR   303      44.921  61.376  19.738  1.00 74.96           C  
ATOM   3681  CZ  TYR   303      43.558  61.701  19.798  1.00 74.41           C  
ATOM   3682  OH  TYR   303      42.774  61.103  20.765  1.00 74.15           O  
ATOM   3683  N   GLU   304      47.459  63.520  13.769  1.00 74.71           N  
ATOM   3684  CA  GLU   304      48.185  64.188  12.685  1.00 75.38           C  
ATOM   3685  C   GLU   304      47.207  64.759  11.638  1.00 75.84           C  
ATOM   3686  O   GLU   304      47.320  65.934  11.303  1.00 76.04           O  
ATOM   3687  CB  GLU   304      49.267  63.306  12.044  1.00 75.36           C  
ATOM   3688  N   ARG   305      46.237  63.966  11.161  1.00 76.26           N  
ATOM   3689  CA  ARG   305      45.231  64.479  10.190  1.00 77.38           C  
ATOM   3690  C   ARG   305      44.364  65.615  10.754  1.00 77.78           C  
ATOM   3691  O   ARG   305      44.148  66.635  10.103  1.00 77.58           O  
ATOM   3692  CB  ARG   305      44.340  63.367   9.608  1.00 77.16           C  
ATOM   3693  CG  ARG   305      43.794  63.717   8.222  1.00 78.11           C  
ATOM   3694  CD  ARG   305      43.069  62.572   7.509  1.00 78.41           C  
ATOM   3695  NE  ARG   305      41.604  62.717   7.526  1.00 81.34           N  
ATOM   3696  CZ  ARG   305      40.784  62.276   6.563  1.00 81.76           C  
ATOM   3697  NH1 ARG   305      41.289  61.674   5.490  1.00 81.84           N  
ATOM   3698  NH2 ARG   305      39.461  62.442   6.663  1.00 80.57           N  
ATOM   3699  N   MET   306      43.880  65.426  11.974  1.00 78.66           N  
ATOM   3700  CA  MET   306      43.192  66.472  12.711  1.00 79.70           C  
ATOM   3701  C   MET   306      44.028  67.736  12.738  1.00 78.26           C  
ATOM   3702  O   MET   306      43.512  68.826  12.546  1.00 78.02           O  
ATOM   3703  CB  MET   306      42.919  65.988  14.118  1.00 79.65           C  
ATOM   3704  CG  MET   306      42.229  66.966  15.018  1.00 80.59           C  
ATOM   3705  SD  MET   306      41.519  65.936  16.498  0.80 85.28          SE  
ATOM   3706  CE  MET   306      42.450  66.827  17.975  1.00 83.16           C  
ATOM   3707  N   GLY   307      45.325  67.578  12.967  1.00 77.83           N  
ATOM   3708  CA  GLY   307      46.274  68.672  12.818  1.00 77.37           C  
ATOM   3709  C   GLY   307      46.055  69.431  11.513  1.00 77.05           C  
ATOM   3710  O   GLY   307      45.695  70.610  11.539  1.00 77.12           O  
ATOM   3711  N   THR   308      46.241  68.768  10.371  1.00 76.40           N  
ATOM   3712  CA  THR   308      45.998  69.440   9.091  1.00 76.00           C  
ATOM   3713  C   THR   308      44.560  69.928   8.927  1.00 75.96           C  
ATOM   3714  O   THR   308      44.337  71.037   8.450  1.00 75.72           O  
ATOM   3715  CB  THR   308      46.468  68.650   7.844  1.00 75.64           C  
ATOM   3716  OG1 THR   308      46.651  67.273   8.162  1.00 75.36           O  
ATOM   3717  CG2 THR   308      47.782  69.176   7.384  1.00 75.66           C  
ATOM   3718  N   LYS   309      43.596  69.125   9.362  1.00 76.13           N  
ATOM   3719  CA  LYS   309      42.190  69.469   9.156  1.00 76.38           C  
ATOM   3720  C   LYS   309      41.766  70.672   9.977  1.00 76.06           C  
ATOM   3721  O   LYS   309      41.019  71.519   9.501  1.00 75.80           O  
ATOM   3722  CB  LYS   309      41.276  68.267   9.391  1.00 76.48           C  
ATOM   3723  CG  LYS   309      41.620  67.100   8.470  1.00 78.46           C  
ATOM   3724  CD  LYS   309      40.435  66.630   7.627  1.00 81.61           C  
ATOM   3725  CE  LYS   309      40.929  65.983   6.316  1.00 83.14           C  
ATOM   3726  NZ  LYS   309      39.821  65.434   5.466  1.00 84.93           N  
ATOM   3727  N   ALA   310      42.261  70.748  11.205  1.00 76.28           N  
ATOM   3728  CA  ALA   310      42.050  71.923  12.038  1.00 76.51           C  
ATOM   3729  C   ALA   310      42.585  73.143  11.298  1.00 76.75           C  
ATOM   3730  O   ALA   310      41.852  74.095  11.024  1.00 77.08           O  
ATOM   3731  CB  ALA   310      42.747  71.767  13.365  1.00 76.32           C  
ATOM   3732  N   ALA   311      43.864  73.097  10.951  1.00 76.62           N  
ATOM   3733  CA  ALA   311      44.478  74.175  10.198  1.00 76.64           C  
ATOM   3734  C   ALA   311      43.645  74.576   8.977  1.00 76.53           C  
ATOM   3735  O   ALA   311      43.379  75.761   8.765  1.00 76.69           O  
ATOM   3736  CB  ALA   311      45.889  73.786   9.783  1.00 76.78           C  
ATOM   3737  N   GLU   312      43.228  73.585   8.192  1.00 76.15           N  
ATOM   3738  CA  GLU   312      42.462  73.840   6.987  1.00 75.78           C  
ATOM   3739  C   GLU   312      41.185  74.606   7.320  1.00 75.33           C  
ATOM   3740  O   GLU   312      40.912  75.647   6.726  1.00 75.39           O  
ATOM   3741  CB  GLU   312      42.146  72.532   6.259  1.00 75.89           C  
ATOM   3742  CG  GLU   312      43.263  72.000   5.339  1.00 76.04           C  
ATOM   3743  CD  GLU   312      42.806  70.800   4.482  1.00 76.60           C  
ATOM   3744  OE1 GLU   312      43.546  69.789   4.431  1.00 76.90           O  
ATOM   3745  OE2 GLU   312      41.708  70.861   3.861  1.00 77.96           O  
ATOM   3746  N   LYS   313      40.426  74.102   8.289  1.00 75.10           N  
ATOM   3747  CA  LYS   313      39.162  74.719   8.701  1.00 74.88           C  
ATOM   3748  C   LYS   313      39.348  76.187   9.083  1.00 74.77           C  
ATOM   3749  O   LYS   313      38.543  77.037   8.702  1.00 74.69           O  
ATOM   3750  CB  LYS   313      38.502  73.926   9.845  1.00 74.88           C  
ATOM   3751  N   LEU   314      40.424  76.484   9.808  1.00 74.67           N  
ATOM   3752  CA  LEU   314      40.723  77.861  10.177  1.00 74.80           C  
ATOM   3753  C   LEU   314      41.236  78.704   9.001  1.00 75.05           C  
ATOM   3754  O   LEU   314      40.760  79.823   8.788  1.00 75.20           O  
ATOM   3755  CB  LEU   314      41.718  77.913  11.329  1.00 74.61           C  
ATOM   3756  CG  LEU   314      41.297  78.760  12.539  1.00 74.70           C  
ATOM   3757  CD1 LEU   314      42.530  79.183  13.348  1.00 74.54           C  
ATOM   3758  CD2 LEU   314      40.422  79.975  12.186  1.00 73.41           C  
ATOM   3759  N   LEU   315      42.211  78.189   8.251  1.00 75.16           N  
ATOM   3760  CA  LEU   315      42.679  78.880   7.057  1.00 75.32           C  
ATOM   3761  C   LEU   315      41.467  79.239   6.185  1.00 75.72           C  
ATOM   3762  O   LEU   315      41.296  80.404   5.814  1.00 75.85           O  
ATOM   3763  CB  LEU   315      43.708  78.045   6.289  1.00 75.00           C  
ATOM   3764  N   HIS   316      40.601  78.256   5.913  1.00 76.07           N  
ATOM   3765  CA  HIS   316      39.384  78.477   5.106  1.00 76.44           C  
ATOM   3766  C   HIS   316      38.391  79.447   5.755  1.00 76.66           C  
ATOM   3767  O   HIS   316      37.469  79.929   5.097  1.00 76.77           O  
ATOM   3768  CB  HIS   316      38.689  77.153   4.765  1.00 76.26           C  
ATOM   3769  N   ALA   317      38.591  79.727   7.040  1.00 77.07           N  
ATOM   3770  CA  ALA   317      37.791  80.715   7.759  1.00 77.38           C  
ATOM   3771  C   ALA   317      38.216  82.131   7.390  1.00 77.50           C  
ATOM   3772  O   ALA   317      37.396  82.907   6.896  1.00 77.65           O  
ATOM   3773  CB  ALA   317      37.880  80.496   9.269  1.00 77.42           C  
ATOM   3774  N   ILE   318      39.489  82.462   7.618  1.00 77.67           N  
ATOM   3775  CA  ILE   318      40.028  83.778   7.232  1.00 77.87           C  
ATOM   3776  C   ILE   318      39.970  84.001   5.720  1.00 77.98           C  
ATOM   3777  O   ILE   318      39.694  85.110   5.259  1.00 78.07           O  
ATOM   3778  CB  ILE   318      41.481  83.981   7.709  1.00 77.73           C  
ATOM   3779  N   LYS   319      40.223  82.937   4.959  1.00 78.18           N  
ATOM   3780  CA  LYS   319      40.194  82.991   3.497  1.00 78.23           C  
ATOM   3781  C   LYS   319      38.763  82.947   2.975  1.00 78.20           C  
ATOM   3782  O   LYS   319      37.871  83.590   3.532  1.00 78.21           O  
ATOM   3783  CB  LYS   319      41.004  81.836   2.903  1.00 78.26           C  
ATOM   3784  N   GLU   321      34.693  82.271   1.962  1.00 74.27           N  
ATOM   3785  CA  GLU   321      34.900  82.107   3.395  1.00 74.30           C  
ATOM   3786  C   GLU   321      33.844  81.217   4.043  1.00 74.51           C  
ATOM   3787  O   GLU   321      33.642  81.295   5.254  1.00 74.65           O  
ATOM   3788  CB  GLU   321      34.931  83.469   4.097  1.00 74.09           C  
ATOM   3789  N   PRO   322      33.168  80.365   3.244  1.00 74.74           N  
ATOM   3790  CA  PRO   322      32.223  79.354   3.752  1.00 74.90           C  
ATOM   3791  C   PRO   322      32.861  78.479   4.854  1.00 75.01           C  
ATOM   3792  O   PRO   322      34.088  78.308   4.876  1.00 74.69           O  
ATOM   3793  CB  PRO   322      31.880  78.536   2.502  1.00 74.76           C  
ATOM   3794  N   GLU   323      32.037  77.934   5.752  1.00 75.38           N  
ATOM   3795  CA  GLU   323      32.535  77.464   7.062  1.00 75.85           C  
ATOM   3796  C   GLU   323      32.427  75.967   7.418  1.00 76.08           C  
ATOM   3797  O   GLU   323      32.744  75.568   8.551  1.00 76.17           O  
ATOM   3798  CB  GLU   323      31.918  78.313   8.185  1.00 75.75           C  
ATOM   3799  N   GLU   324      32.004  75.136   6.469  1.00 76.23           N  
ATOM   3800  CA  GLU   324      31.926  73.700   6.730  1.00 76.37           C  
ATOM   3801  C   GLU   324      32.229  72.879   5.487  1.00 76.47           C  
ATOM   3802  O   GLU   324      32.432  71.666   5.577  1.00 76.61           O  
ATOM   3803  CB  GLU   324      30.553  73.323   7.301  1.00 76.41           C  
ATOM   3804  N   PRO   326      29.553  70.241   8.915  1.00 95.52           N  
ATOM   3805  CA  PRO   326      29.812  69.129   9.825  1.00 95.72           C  
ATOM   3806  C   PRO   326      31.238  68.570   9.670  1.00 95.90           C  
ATOM   3807  O   PRO   326      31.919  68.898   8.690  1.00 95.91           O  
ATOM   3808  CB  PRO   326      28.764  68.093   9.409  1.00 95.76           C  
ATOM   3809  N   THR   327      31.684  67.749  10.632  1.00 96.04           N  
ATOM   3810  CA  THR   327      33.073  67.259  10.678  1.00 96.02           C  
ATOM   3811  C   THR   327      33.203  65.933  11.444  1.00 96.07           C  
ATOM   3812  O   THR   327      33.840  65.883  12.518  1.00 96.24           O  
ATOM   3813  CB  THR   327      34.020  68.312  11.342  1.00 96.16           C  
ATOM   3814  OG1 THR   327      33.682  69.633  10.904  1.00 96.54           O  
ATOM   3815  CG2 THR   327      35.486  68.041  11.008  1.00 96.21           C  
ATOM   3816  N   SER   328      32.627  64.856  10.901  1.00 95.82           N  
ATOM   3817  CA  SER   328      32.566  63.563  11.646  1.00 95.51           C  
ATOM   3818  C   SER   328      33.847  62.708  11.593  1.00 94.47           C  
ATOM   3819  O   SER   328      33.890  61.683  10.899  1.00 94.49           O  
ATOM   3820  CB  SER   328      31.360  62.724  11.193  1.00 95.74           C  
ATOM   3821  OG  SER   328      31.361  61.465  11.854  1.00 96.57           O  
ATOM   3822  N   MET   329      34.871  63.115  12.333  1.00 93.48           N  
ATOM   3823  CA  MET   329      36.152  62.405  12.269  0.50 93.09           C  
ATOM   3825  C   MET   329      36.327  61.429  13.437  1.00 92.01           C  
ATOM   3826  O   MET   329      36.420  61.822  14.591  1.00 91.96           O  
ATOM   3827  CB  MET   329      37.348  63.367  12.125  0.50 93.68           C  
ATOM   3829  CG  MET   329      37.341  64.227  10.838  0.50 94.63           C  
ATOM   3831  SD  MET   329      37.278  63.239   9.130  0.40 98.13          SE  
ATOM   3833  CE  MET   329      37.122  64.739   7.873  0.50 95.11           C  
ATOM   3835  N   GLY   330      36.365  60.141  13.096  1.00 90.14           N  
ATOM   3836  CA  GLY   330      36.347  59.051  14.062  1.00 87.30           C  
ATOM   3837  C   GLY   330      37.647  58.336  14.396  1.00 85.42           C  
ATOM   3838  O   GLY   330      38.648  58.968  14.694  1.00 85.23           O  
ATOM   3839  N   PHE   331      37.612  57.008  14.359  1.00 83.74           N  
ATOM   3840  CA  PHE   331      38.656  56.173  14.940  1.00 82.47           C  
ATOM   3841  C   PHE   331      38.652  54.766  14.352  1.00 82.34           C  
ATOM   3842  O   PHE   331      37.671  54.349  13.772  1.00 82.98           O  
ATOM   3843  CB  PHE   331      38.464  56.092  16.455  1.00 81.49           C  
ATOM   3844  CG  PHE   331      37.339  55.220  16.866  1.00 80.32           C  
ATOM   3845  CD1 PHE   331      36.019  55.680  16.794  1.00 79.28           C  
ATOM   3846  CD2 PHE   331      37.575  53.931  17.321  1.00 79.03           C  
ATOM   3847  CE1 PHE   331      34.940  54.860  17.179  1.00 77.25           C  
ATOM   3848  CE2 PHE   331      36.478  53.097  17.701  1.00 79.12           C  
ATOM   3849  CZ  PHE   331      35.167  53.570  17.618  1.00 76.56           C  
ATOM   3850  N   LYS   332      39.746  54.029  14.490  1.00 82.06           N  
ATOM   3851  CA  LYS   332      39.744  52.645  14.048  1.00 81.68           C  
ATOM   3852  C   LYS   332      39.954  51.803  15.289  1.00 80.82           C  
ATOM   3853  O   LYS   332      40.748  52.182  16.147  1.00 81.05           O  
ATOM   3854  CB  LYS   332      40.860  52.348  13.034  1.00 82.28           C  
ATOM   3855  CG  LYS   332      41.420  53.529  12.228  1.00 83.84           C  
ATOM   3856  CD  LYS   332      40.515  53.890  11.081  1.00 88.56           C  
ATOM   3857  CE  LYS   332      40.984  55.162  10.384  1.00 91.04           C  
ATOM   3858  NZ  LYS   332      42.167  54.957   9.492  1.00 92.95           N  
ATOM   3859  N   LEU   333      39.231  50.684  15.378  1.00 79.21           N  
ATOM   3860  CA  LEU   333      39.462  49.651  16.374  1.00 77.70           C  
ATOM   3861  C   LEU   333      40.387  48.520  15.870  1.00 77.78           C  
ATOM   3862  O   LEU   333      39.915  47.509  15.335  1.00 77.74           O  
ATOM   3863  CB  LEU   333      38.138  49.031  16.780  1.00 77.15           C  
ATOM   3864  CG  LEU   333      37.916  48.395  18.155  1.00 76.10           C  
ATOM   3865  CD1 LEU   333      37.206  47.074  17.992  1.00 74.66           C  
ATOM   3866  CD2 LEU   333      39.204  48.190  18.921  1.00 76.71           C  
ATOM   3867  N   LYS   334      41.694  48.690  16.073  1.00 77.57           N  
ATOM   3868  CA  LYS   334      42.709  47.623  15.950  1.00 77.41           C  
ATOM   3869  C   LYS   334      42.488  46.428  16.907  1.00 77.39           C  
ATOM   3870  O   LYS   334      42.820  46.500  18.111  1.00 77.20           O  
ATOM   3871  CB  LYS   334      44.107  48.214  16.237  1.00 77.53           C  
ATOM   3872  CG  LYS   334      44.483  49.394  15.358  1.00 77.59           C  
ATOM   3873  CD  LYS   334      44.342  49.017  13.876  1.00 76.62           C  
ATOM   3874  CE  LYS   334      44.277  50.242  13.000  1.00 76.35           C  
ATOM   3875  NZ  LYS   334      44.662  49.855  11.593  1.00 79.37           N  
ATOM   3876  N   ARG   335      41.944  45.332  16.377  1.00 76.73           N  
ATOM   3877  CA  ARG   335      41.714  44.131  17.169  1.00 76.39           C  
ATOM   3878  C   ARG   335      43.018  43.372  17.254  1.00 76.19           C  
ATOM   3879  O   ARG   335      43.547  42.989  16.227  1.00 76.67           O  
ATOM   3880  CB  ARG   335      40.672  43.259  16.491  1.00 76.80           C  
ATOM   3881  CG  ARG   335      39.317  43.921  16.311  1.00 77.80           C  
ATOM   3882  CD  ARG   335      38.713  43.597  14.951  1.00 80.51           C  
ATOM   3883  NE  ARG   335      37.259  43.764  14.985  1.00 83.77           N  
ATOM   3884  CZ  ARG   335      36.618  44.925  14.824  1.00 83.52           C  
ATOM   3885  NH1 ARG   335      35.293  44.960  14.897  1.00 82.23           N  
ATOM   3886  NH2 ARG   335      37.295  46.052  14.597  1.00 83.15           N  
ATOM   3887  N   ARG   336      43.563  43.186  18.459  1.00 75.95           N  
ATOM   3888  CA  ARG   336      44.812  42.418  18.642  1.00 75.87           C  
ATOM   3889  C   ARG   336      44.651  41.331  19.695  1.00 76.49           C  
ATOM   3890  O   ARG   336      43.530  40.919  19.977  1.00 76.09           O  
ATOM   3891  CB  ARG   336      45.979  43.312  19.031  1.00 75.21           C  
ATOM   3892  CG  ARG   336      45.888  44.687  18.504  1.00 74.74           C  
ATOM   3893  CD  ARG   336      47.143  45.342  18.894  1.00 77.89           C  
ATOM   3894  NE  ARG   336      47.073  46.798  18.870  1.00 79.85           N  
ATOM   3895  CZ  ARG   336      47.284  47.537  17.789  1.00 78.38           C  
ATOM   3896  NH1 ARG   336      47.558  46.957  16.619  1.00 77.89           N  
ATOM   3897  NH2 ARG   336      47.222  48.855  17.895  1.00 77.33           N  
ATOM   3898  N   ALA   337      45.758  40.878  20.295  1.00 77.29           N  
ATOM   3899  CA  ALA   337      45.681  39.710  21.175  1.00 78.02           C  
ATOM   3900  C   ALA   337      44.743  39.905  22.347  1.00 79.10           C  
ATOM   3901  O   ALA   337      43.889  39.054  22.593  1.00 80.51           O  
ATOM   3902  CB  ALA   337      47.014  39.284  21.649  1.00 77.04           C  
ATOM   3903  N   SER   338      44.854  41.030  23.046  1.00 79.69           N  
ATOM   3904  CA  SER   338      44.249  41.133  24.372  1.00 80.21           C  
ATOM   3905  C   SER   338      42.716  41.048  24.376  1.00 80.61           C  
ATOM   3906  O   SER   338      42.090  41.114  25.460  1.00 80.70           O  
ATOM   3907  CB  SER   338      44.676  42.422  25.037  1.00 80.31           C  
ATOM   3908  OG  SER   338      44.043  43.510  24.389  1.00 82.53           O  
ATOM   3909  N   THR   339      42.104  40.931  23.192  1.00 80.30           N  
ATOM   3910  CA  THR   339      40.679  40.593  23.135  1.00 80.65           C  
ATOM   3911  C   THR   339      40.355  39.427  22.267  1.00 80.79           C  
ATOM   3912  O   THR   339      39.209  39.275  21.880  1.00 81.10           O  
ATOM   3913  CB  THR   339      39.741  41.755  22.707  1.00 80.18           C  
ATOM   3914  OG1 THR   339      39.994  42.121  21.349  1.00 80.98           O  
ATOM   3915  CG2 THR   339      39.907  42.939  23.611  1.00 81.05           C  
ATOM   3916  N   ALA   340      41.339  38.591  21.967  1.00 81.72           N  
ATOM   3917  CA  ALA   340      41.148  37.574  20.928  1.00 82.33           C  
ATOM   3918  C   ALA   340      40.507  36.324  21.509  1.00 83.30           C  
ATOM   3919  O   ALA   340      40.431  36.157  22.732  1.00 83.25           O  
ATOM   3920  CB  ALA   340      42.437  37.257  20.272  1.00 81.36           C  
ATOM   3921  N   ILE   341      40.020  35.455  20.632  1.00 84.69           N  
ATOM   3922  CA  ILE   341      39.407  34.212  21.076  1.00 86.00           C  
ATOM   3923  C   ILE   341      39.703  33.111  20.070  1.00 86.21           C  
ATOM   3924  O   ILE   341      39.423  33.264  18.880  1.00 86.39           O  
ATOM   3925  CB  ILE   341      37.893  34.393  21.307  1.00 86.04           C  
ATOM   3926  CG1 ILE   341      37.229  33.043  21.605  1.00 87.67           C  
ATOM   3927  CG2 ILE   341      37.247  35.115  20.124  1.00 86.43           C  
ATOM   3928  CD1 ILE   341      35.691  32.966  21.275  1.00 86.79           C  
ATOM   3929  N   ASN   342      40.301  32.020  20.548  1.00 86.81           N  
ATOM   3930  CA  ASN   342      40.675  30.879  19.681  1.00 87.10           C  
ATOM   3931  C   ASN   342      39.975  29.568  20.069  1.00 86.91           C  
ATOM   3932  O   ASN   342      38.977  29.176  19.458  1.00 86.63           O  
ATOM   3933  CB  ASN   342      42.206  30.682  19.636  1.00 87.08           C  
ATOM   3934  CG  ASN   342      42.650  29.605  18.607  1.00 87.89           C  
ATOM   3935  OD1 ASN   342      41.844  29.088  17.815  1.00 85.68           O  
ATOM   3936  ND2 ASN   342      43.951  29.271  18.629  1.00 89.00           N  
END
