
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  107 ( 1532),  selected  107 , name 1imu_A
# Molecule2: number of CA atoms   62 (  480),  selected   62 , name T0446_9_70.pdb
# PARAMETERS: 1imu_A.T0446_9_70.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      G       9           -
LGA    T     2_A      N      10           -
LGA    L     3_A      A      11           -
LGA    -       -      A      12           -
LGA    N     4_A      E      13          2.905
LGA    I     5_A      V      14          4.326
LGA    T     6_A      N      15           -
LGA    S     7_A      L      16           -
LGA    K     8_A      D      17           -
LGA    Q     9_A      -       -           -
LGA    M    10_A      -       -           -
LGA    D    11_A      -       -           -
LGA    I    12_A      -       -           -
LGA    T    13_A      -       -           -
LGA    P    14_A      -       -           -
LGA    A    15_A      -       -           -
LGA    I    16_A      -       -           -
LGA    R    17_A      -       -           -
LGA    E    18_A      -       -           -
LGA    H    19_A      -       -           -
LGA    L    20_A      -       -           -
LGA    E    21_A      E      18          3.650
LGA    E    22_A      -       -           -
LGA    R    23_A      L      19          5.243
LGA    L    24_A      A      20          3.905
LGA    A    25_A      Q      21          1.277
LGA    K    26_A      E      22          2.238
LGA    L    27_A      L      23          1.169
LGA    G    28_A      G      24          2.593
LGA    K    29_A      P      25          4.215
LGA    -       -      I      26           -
LGA    W    30_A      M      27          1.601
LGA    Q    31_A      G      28          0.782
LGA    -       -      D      29           -
LGA    -       -      N      30           -
LGA    T    32_A      E      31          2.192
LGA    Q    33_A      Q      32          1.024
LGA    L    34_A      L      33          1.266
LGA    I    35_A      A      34          1.056
LGA    S    36_A      L      35          1.122
LGA    P    37_A      A      36          1.777
LGA    H    38_A      Y      37          2.047
LGA    F    39_A      R      38          1.890
LGA    V    40_A      V      39          1.571
LGA    L    41_A      I      40          1.714
LGA    N    42_A      -       -           -
LGA    K    43_A      -       -           -
LGA    V    44_A      -       -           -
LGA    P    45_A      -       -           -
LGA    N    46_A      -       -           -
LGA    G    47_A      -       -           -
LGA    F    48_A      -       -           -
LGA    S    49_A      -       -           -
LGA    V    50_A      R      41          2.714
LGA    E    51_A      D      42          1.482
LGA    A    52_A      M      43          0.979
LGA    S    53_A      F      44          0.527
LGA    I    54_A      V      45          0.626
LGA    G    55_A      F      46          0.581
LGA    T    56_A      T      47          1.653
LGA    P    57_A      N      48          1.816
LGA    L    58_A      K      49          1.753
LGA    G    59_A      R      50          1.980
LGA    N    60_A      L      51          2.000
LGA    L    61_A      I      52          1.965
LGA    L    62_A      L      53          1.734
LGA    A    63_A      I      54          2.897
LGA    S    64_A      D      55          2.012
LGA    A    65_A      K      56          2.650
LGA    T    66_A      Q      57          1.900
LGA    S    67_A      G      58          0.845
LGA    D    68_A      V      59          1.256
LGA    D    69_A      T      60          0.973
LGA    M    70_A      G      61          3.715
LGA    Y    71_A      -       -           -
LGA    K    72_A      K      62          1.820
LGA    A    73_A      K      63          4.753
LGA    I    74_A      -       -           -
LGA    N    75_A      -       -           -
LGA    E    76_A      V      64          0.938
LGA    V    77_A      -       -           -
LGA    E    78_A      -       -           -
LGA    E    79_A      -       -           -
LGA    K    80_A      S      65          2.731
LGA    L    81_A      Y      66          2.759
LGA    E    82_A      H      67           #
LGA    R    83_A      -       -           -
LGA    Q    84_A      S      68          1.740
LGA    L    85_A      V      69           #
LGA    N    86_A      -       -           -
LGA    K    87_A      -       -           -
LGA    L    88_A      P      70          4.221
LGA    Q    89_A      -       -           -
LGA    H    90_A      -       -           -
LGA    K    91_A      -       -           -
LGA    S    92_A      -       -           -
LGA    E    93_A      -       -           -
LGA    S    94_A      -       -           -
LGA    R    95_A      -       -           -
LGA    R    96_A      -       -           -
LGA    A    97_A      -       -           -
LGA    D    98_A      -       -           -
LGA    E    99_A      -       -           -
LGA    R   100_A      -       -           -
LGA    L   101_A      -       -           -
LGA    K   102_A      -       -           -
LGA    D   103_A      -       -           -
LGA    S   104_A      -       -           -
LGA    F   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    N   107_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  107   62    5.0     50    2.38    18.00     64.662     2.016

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.760362 * X  +  -0.009805 * Y  +   0.649425 * Z  +  53.279598
  Y_new =   0.580716 * X  +   0.437558 * Y  +   0.686522 * Z  + -15.536125
  Z_new =  -0.290892 * X  +   0.899137 * Y  +  -0.327009 * Z  +  23.512657 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.919616   -1.221977  [ DEG:   109.9859    -70.0141 ]
  Theta =   0.295159    2.846434  [ DEG:    16.9114    163.0886 ]
  Phi   =   2.489359   -0.652234  [ DEG:   142.6297    -37.3703 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1imu_A                                        
REMARK     2: T0446_9_70.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1imu_A.T0446_9_70.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  107   62   5.0   50   2.38   18.00  64.662
REMARK  ---------------------------------------------------------- 
MOLECULE 1imu_A
HEADER    RNA BINDING PROTEIN                     11-MAY-01   1IMU              
TITLE     SOLUTION STRUCTURE OF HI0257, A RIBOSOME BINDING PROTEIN              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN HI0257;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HAEMOPHILUS INFLUENZAE;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-15B                                   
KEYWDS    DSRNA BINDING PROTEIN, NMR, PROTEOME, SOLUTION STRUCTURE,             
KEYWDS   2 RIBOSOME, STRUCTURE 2 FUNCTION PROJECT, S2F, STRUCTURAL              
KEYWDS   3 GENOMICS                                                             
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    L.PARSONS,E.EISENSTEIN,J.ORBAN,STRUCTURE 2 FUNCTION PROJECT           
AUTHOR   2 (S2F)                                                                
REVDAT   1   03-OCT-01 1IMU    0                                                
JRNL        AUTH   L.PARSONS,E.EISENSTEIN,J.ORBAN                               
JRNL        TITL   SOLUTION STRUCTURE OF HI0257, A BACTERIAL RIBOSOME           
JRNL        TITL 2 BINDING PROTEIN.                                             
JRNL        REF    BIOCHEMISTRY                  V.  40 10979 2001              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1IMU A    1   107  UNP    P71346   Y257_HAEIN       0    106             
SEQRES   1 A  107  MET THR LEU ASN ILE THR SER LYS GLN MET ASP ILE THR          
SEQRES   2 A  107  PRO ALA ILE ARG GLU HIS LEU GLU GLU ARG LEU ALA LYS          
SEQRES   3 A  107  LEU GLY LYS TRP GLN THR GLN LEU ILE SER PRO HIS PHE          
SEQRES   4 A  107  VAL LEU ASN LYS VAL PRO ASN GLY PHE SER VAL GLU ALA          
SEQRES   5 A  107  SER ILE GLY THR PRO LEU GLY ASN LEU LEU ALA SER ALA          
SEQRES   6 A  107  THR SER ASP ASP MET TYR LYS ALA ILE ASN GLU VAL GLU          
SEQRES   7 A  107  GLU LYS LEU GLU ARG GLN LEU ASN LYS LEU GLN HIS LYS          
SEQRES   8 A  107  SER GLU SER ARG ARG ALA ASP GLU ARG LEU LYS ASP SER          
SEQRES   9 A  107  PHE GLU ASN                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      41.900 -19.990  20.201  1.00  0.00           N  
ATOM      2  CA  MET A   1      43.357 -19.951  19.899  1.00  0.00           C  
ATOM      3  C   MET A   1      44.164 -20.669  20.978  1.00  0.00           C  
ATOM      4  O   MET A   1      44.143 -20.277  22.145  1.00  0.00           O  
ATOM      5  CB  MET A   1      43.800 -18.489  19.793  1.00  0.00           C  
ATOM      6  CG  MET A   1      43.331 -17.798  18.522  1.00  0.00           C  
ATOM      7  SD  MET A   1      41.565 -17.433  18.540  1.00  0.00           S  
ATOM      8  CE  MET A   1      41.010 -18.396  17.135  1.00  0.00           C  
ATOM      9  HA  MET A   1      43.523 -20.443  18.951  1.00 99.99           H  
ATOM     10  HB2 MET A   1      43.411 -17.944  20.640  1.00 99.99           H  
ATOM     11  HB3 MET A   1      44.880 -18.450  19.819  1.00 99.99           H  
ATOM     12  HG2 MET A   1      43.873 -16.871  18.413  1.00 99.99           H  
ATOM     13  HG3 MET A   1      43.544 -18.439  17.680  1.00 99.99           H  
ATOM     14  HE1 MET A   1      40.999 -19.444  17.397  1.00 99.99           H  
ATOM     15  HE2 MET A   1      41.681 -18.240  16.304  1.00 99.99           H  
ATOM     16  HE3 MET A   1      40.013 -18.085  16.858  1.00 99.99           H  
ATOM     17  H1  MET A   1      41.707 -20.870  20.720  1.00 99.99           H  
ATOM     18  H2  MET A   1      41.389 -19.972  19.296  1.00 99.99           H  
ATOM     19  H3  MET A   1      41.672 -19.158  20.780  1.00 99.99           H  
ATOM     20  N   THR A   2      44.872 -21.721  20.579  1.00  0.00           N  
ATOM     21  CA  THR A   2      45.684 -22.494  21.512  1.00  0.00           C  
ATOM     22  C   THR A   2      47.165 -22.391  21.163  1.00  0.00           C  
ATOM     23  O   THR A   2      47.556 -22.579  20.010  1.00  0.00           O  
ATOM     24  CB  THR A   2      45.250 -23.959  21.508  1.00  0.00           C  
ATOM     25  OG1 THR A   2      45.630 -24.592  20.298  1.00  0.00           O  
ATOM     26  CG2 THR A   2      43.758 -24.142  21.672  1.00  0.00           C  
ATOM     27  H   THR A   2      44.847 -21.985  19.636  1.00 99.99           H  
ATOM     28  HA  THR A   2      45.532 -22.086  22.500  1.00 99.99           H  
ATOM     29  HB  THR A   2      45.738 -24.471  22.324  1.00 99.99           H  
ATOM     30  HG1 THR A   2      45.147 -24.200  19.567  1.00 99.99           H  
ATOM     31  N   LEU A   3      47.985 -22.095  22.166  1.00  0.00           N  
ATOM     32  CA  LEU A   3      49.424 -21.971  21.968  1.00  0.00           C  
ATOM     33  C   LEU A   3      50.056 -23.335  21.724  1.00  0.00           C  
ATOM     34  O   LEU A   3      50.202 -24.138  22.646  1.00  0.00           O  
ATOM     35  CB  LEU A   3      50.069 -21.302  23.184  1.00  0.00           C  
ATOM     36  CG  LEU A   3      51.593 -21.192  23.133  1.00  0.00           C  
ATOM     37  CD1 LEU A   3      52.072 -20.041  24.001  1.00  0.00           C  
ATOM     38  CD2 LEU A   3      52.235 -22.498  23.576  1.00  0.00           C  
ATOM     39  H   LEU A   3      47.612 -21.960  23.062  1.00 99.99           H  
ATOM     40  HA  LEU A   3      49.589 -21.353  21.099  1.00 99.99           H  
ATOM     41  HB2 LEU A   3      49.660 -20.305  23.276  1.00 99.99           H  
ATOM     42  HB3 LEU A   3      49.799 -21.866  24.064  1.00 99.99           H  
ATOM     43  HG  LEU A   3      51.901 -20.996  22.116  1.00 99.99           H  
ATOM     44  N   ASN A   4      50.422 -23.597  20.473  1.00  0.00           N  
ATOM     45  CA  ASN A   4      51.032 -24.871  20.107  1.00  0.00           C  
ATOM     46  C   ASN A   4      52.532 -24.877  20.389  1.00  0.00           C  
ATOM     47  O   ASN A   4      53.163 -23.824  20.521  1.00  0.00           O  
ATOM     48  CB  ASN A   4      50.784 -25.171  18.633  1.00  0.00           C  
ATOM     49  CG  ASN A   4      49.330 -24.988  18.240  1.00  0.00           C  
ATOM     50  OD1 ASN A   4      48.996 -24.117  17.438  1.00  0.00           O  
ATOM     51  ND2 ASN A   4      48.456 -25.813  18.805  1.00  0.00           N  
ATOM     52  H   ASN A   4      50.272 -22.920  19.781  1.00 99.99           H  
ATOM     53  HA  ASN A   4      50.565 -25.641  20.702  1.00 99.99           H  
ATOM     54  HB2 ASN A   4      51.385 -24.509  18.032  1.00 99.99           H  
ATOM     55  HB3 ASN A   4      51.067 -26.192  18.430  1.00 99.99           H  
ATOM     56  N   ILE A   5      53.095 -26.078  20.479  1.00  0.00           N  
ATOM     57  CA  ILE A   5      54.519 -26.243  20.748  1.00  0.00           C  
ATOM     58  C   ILE A   5      55.186 -27.092  19.674  1.00  0.00           C  
ATOM     59  O   ILE A   5      54.526 -27.835  18.948  1.00  0.00           O  
ATOM     60  CB  ILE A   5      54.784 -26.900  22.128  1.00  0.00           C  
ATOM     61  CG1 ILE A   5      53.501 -27.519  22.704  1.00  0.00           C  
ATOM     62  CG2 ILE A   5      55.374 -25.881  23.089  1.00  0.00           C  
ATOM     63  CD1 ILE A   5      52.447 -26.503  23.094  1.00  0.00           C  
ATOM     64  H   ILE A   5      52.537 -26.875  20.363  1.00 99.99           H  
ATOM     65  HA  ILE A   5      54.972 -25.263  20.747  1.00 99.99           H  
ATOM     66  HB  ILE A   5      55.517 -27.682  21.991  1.00 99.99           H  
ATOM     67  N   THR A   6      56.506 -26.985  19.597  1.00  0.00           N  
ATOM     68  CA  THR A   6      57.286 -27.747  18.634  1.00  0.00           C  
ATOM     69  C   THR A   6      58.386 -28.512  19.354  1.00  0.00           C  
ATOM     70  O   THR A   6      58.504 -29.729  19.223  1.00  0.00           O  
ATOM     71  CB  THR A   6      57.892 -26.819  17.578  1.00  0.00           C  
ATOM     72  OG1 THR A   6      56.920 -25.908  17.093  1.00  0.00           O  
ATOM     73  CG2 THR A   6      58.462 -27.558  16.387  1.00  0.00           C  
ATOM     74  H   THR A   6      56.970 -26.383  20.216  1.00 99.99           H  
ATOM     75  HA  THR A   6      56.625 -28.452  18.152  1.00 99.99           H  
ATOM     76  HB  THR A   6      58.692 -26.253  18.030  1.00 99.99           H  
ATOM     77  HG1 THR A   6      57.282 -25.019  17.106  1.00 99.99           H  
ATOM     78  N   SER A   7      59.175 -27.779  20.135  1.00  0.00           N  
ATOM     79  CA  SER A   7      60.266 -28.361  20.909  1.00  0.00           C  
ATOM     80  C   SER A   7      61.059 -29.387  20.104  1.00  0.00           C  
ATOM     81  O   SER A   7      60.678 -30.554  20.013  1.00  0.00           O  
ATOM     82  CB  SER A   7      59.715 -29.004  22.181  1.00  0.00           C  
ATOM     83  OG  SER A   7      58.652 -28.237  22.721  1.00  0.00           O  
ATOM     84  H   SER A   7      59.012 -26.816  20.200  1.00 99.99           H  
ATOM     85  HA  SER A   7      60.928 -27.560  21.188  1.00 99.99           H  
ATOM     86  HB2 SER A   7      59.349 -29.992  21.955  1.00 99.99           H  
ATOM     87  HB3 SER A   7      60.501 -29.069  22.915  1.00 99.99           H  
ATOM     88  HG  SER A   7      58.984 -27.379  22.996  1.00 99.99           H  
ATOM     89  N   LYS A   8      62.164 -28.938  19.521  1.00  0.00           N  
ATOM     90  CA  LYS A   8      63.016 -29.808  18.719  1.00  0.00           C  
ATOM     91  C   LYS A   8      63.547 -30.988  19.536  1.00  0.00           C  
ATOM     92  O   LYS A   8      63.673 -32.099  19.024  1.00  0.00           O  
ATOM     93  CB  LYS A   8      64.184 -29.009  18.129  1.00  0.00           C  
ATOM     94  CG  LYS A   8      65.311 -28.741  19.115  1.00  0.00           C  
ATOM     95  CD  LYS A   8      66.095 -27.493  18.741  1.00  0.00           C  
ATOM     96  CE  LYS A   8      67.289 -27.830  17.861  1.00  0.00           C  
ATOM     97  NZ  LYS A   8      68.478 -27.001  18.201  1.00  0.00           N  
ATOM     98  H   LYS A   8      62.413 -27.994  19.628  1.00 99.99           H  
ATOM     99  HA  LYS A   8      62.417 -30.194  17.910  1.00 99.99           H  
ATOM    100  HB2 LYS A   8      64.592 -29.555  17.290  1.00 99.99           H  
ATOM    101  HB3 LYS A   8      63.810 -28.058  17.776  1.00 99.99           H  
ATOM    102  HG2 LYS A   8      64.889 -28.608  20.100  1.00 99.99           H  
ATOM    103  HG3 LYS A   8      65.980 -29.589  19.119  1.00 99.99           H  
ATOM    104  HD2 LYS A   8      65.445 -26.818  18.205  1.00 99.99           H  
ATOM    105  HD3 LYS A   8      66.447 -27.017  19.644  1.00 99.99           H  
ATOM    106  HE2 LYS A   8      67.536 -28.871  17.995  1.00 99.99           H  
ATOM    107  HE3 LYS A   8      67.019 -27.654  16.830  1.00 99.99           H  
ATOM    108  HZ1 LYS A   8      68.678 -27.061  19.219  1.00 99.99           H  
ATOM    109  HZ2 LYS A   8      68.307 -26.007  17.949  1.00 99.99           H  
ATOM    110  HZ3 LYS A   8      69.310 -27.340  17.675  1.00 99.99           H  
ATOM    111  N   GLN A   9      63.866 -30.739  20.806  1.00  0.00           N  
ATOM    112  CA  GLN A   9      64.394 -31.788  21.674  1.00  0.00           C  
ATOM    113  C   GLN A   9      63.471 -32.050  22.869  1.00  0.00           C  
ATOM    114  O   GLN A   9      62.540 -32.849  22.772  1.00  0.00           O  
ATOM    115  CB  GLN A   9      65.805 -31.424  22.157  1.00  0.00           C  
ATOM    116  CG  GLN A   9      66.034 -29.929  22.322  1.00  0.00           C  
ATOM    117  CD  GLN A   9      67.268 -29.618  23.145  1.00  0.00           C  
ATOM    118  OE1 GLN A   9      68.237 -29.049  22.642  1.00  0.00           O  
ATOM    119  NE2 GLN A   9      67.241 -29.995  24.420  1.00  0.00           N  
ATOM    120  H   GLN A   9      63.754 -29.835  21.161  1.00 99.99           H  
ATOM    121  HA  GLN A   9      64.455 -32.692  21.089  1.00 99.99           H  
ATOM    122  HB2 GLN A   9      65.979 -31.900  23.110  1.00 99.99           H  
ATOM    123  HB3 GLN A   9      66.523 -31.798  21.442  1.00 99.99           H  
ATOM    124  HG2 GLN A   9      66.152 -29.486  21.345  1.00 99.99           H  
ATOM    125  HG3 GLN A   9      65.173 -29.497  22.812  1.00 99.99           H  
ATOM    126  N   MET A  10      63.735 -31.385  23.997  1.00  0.00           N  
ATOM    127  CA  MET A  10      62.930 -31.563  25.202  1.00  0.00           C  
ATOM    128  C   MET A  10      61.439 -31.508  24.891  1.00  0.00           C  
ATOM    129  O   MET A  10      60.912 -30.462  24.518  1.00  0.00           O  
ATOM    130  CB  MET A  10      63.274 -30.489  26.232  1.00  0.00           C  
ATOM    131  CG  MET A  10      63.261 -29.082  25.668  1.00  0.00           C  
ATOM    132  SD  MET A  10      62.872 -27.840  26.911  1.00  0.00           S  
ATOM    133  CE  MET A  10      63.683 -26.414  26.201  1.00  0.00           C  
ATOM    134  H   MET A  10      64.493 -30.768  24.021  1.00 99.99           H  
ATOM    135  HA  MET A  10      63.170 -32.527  25.617  1.00 99.99           H  
ATOM    136  HB2 MET A  10      62.560 -30.539  27.039  1.00 99.99           H  
ATOM    137  HB3 MET A  10      64.258 -30.689  26.622  1.00 99.99           H  
ATOM    138  HG2 MET A  10      64.234 -28.863  25.255  1.00 99.99           H  
ATOM    139  HG3 MET A  10      62.520 -29.029  24.885  1.00 99.99           H  
ATOM    140  HE1 MET A  10      64.750 -26.546  26.264  1.00 99.99           H  
ATOM    141  HE2 MET A  10      63.393 -25.524  26.739  1.00 99.99           H  
ATOM    142  HE3 MET A  10      63.396 -26.314  25.163  1.00 99.99           H  
ATOM    143  N   ASP A  11      60.758 -32.636  25.050  1.00  0.00           N  
ATOM    144  CA  ASP A  11      59.327 -32.697  24.786  1.00  0.00           C  
ATOM    145  C   ASP A  11      58.573 -31.725  25.691  1.00  0.00           C  
ATOM    146  O   ASP A  11      59.167 -31.088  26.559  1.00  0.00           O  
ATOM    147  CB  ASP A  11      58.804 -34.120  24.989  1.00  0.00           C  
ATOM    148  CG  ASP A  11      59.631 -35.152  24.249  1.00  0.00           C  
ATOM    149  OD1 ASP A  11      60.766 -35.431  24.689  1.00  0.00           O  
ATOM    150  OD2 ASP A  11      59.143 -35.682  23.229  1.00  0.00           O  
ATOM    151  H   ASP A  11      61.226 -33.442  25.354  1.00 99.99           H  
ATOM    152  HA  ASP A  11      59.173 -32.406  23.759  1.00 99.99           H  
ATOM    153  HB2 ASP A  11      58.826 -34.358  26.043  1.00 99.99           H  
ATOM    154  HB3 ASP A  11      57.786 -34.176  24.633  1.00 99.99           H  
ATOM    155  N   ILE A  12      57.264 -31.619  25.488  1.00  0.00           N  
ATOM    156  CA  ILE A  12      56.445 -30.722  26.299  1.00  0.00           C  
ATOM    157  C   ILE A  12      55.816 -31.472  27.466  1.00  0.00           C  
ATOM    158  O   ILE A  12      55.496 -32.655  27.361  1.00  0.00           O  
ATOM    159  CB  ILE A  12      55.315 -30.020  25.497  1.00  0.00           C  
ATOM    160  CG1 ILE A  12      55.282 -30.485  24.036  1.00  0.00           C  
ATOM    161  CG2 ILE A  12      55.476 -28.505  25.560  1.00  0.00           C  
ATOM    162  CD1 ILE A  12      56.533 -30.134  23.259  1.00  0.00           C  
ATOM    163  H   ILE A  12      56.841 -32.156  24.785  1.00 99.99           H  
ATOM    164  HA  ILE A  12      57.099 -29.958  26.699  1.00 99.99           H  
ATOM    165  HB  ILE A  12      54.374 -30.269  25.966  1.00 99.99           H  
ATOM    166  N   THR A  13      55.645 -30.770  28.575  1.00  0.00           N  
ATOM    167  CA  THR A  13      55.058 -31.351  29.771  1.00  0.00           C  
ATOM    168  C   THR A  13      54.166 -30.329  30.475  1.00  0.00           C  
ATOM    169  O   THR A  13      54.143 -29.157  30.098  1.00  0.00           O  
ATOM    170  CB  THR A  13      56.164 -31.826  30.714  1.00  0.00           C  
ATOM    171  OG1 THR A  13      57.387 -31.175  30.421  1.00  0.00           O  
ATOM    172  CG2 THR A  13      56.412 -33.318  30.643  1.00  0.00           C  
ATOM    173  H   THR A  13      55.925 -29.833  28.591  1.00 99.99           H  
ATOM    174  HA  THR A  13      54.457 -32.197  29.472  1.00 99.99           H  
ATOM    175  HB  THR A  13      55.885 -31.583  31.725  1.00 99.99           H  
ATOM    176  HG1 THR A  13      57.808 -30.902  31.239  1.00 99.99           H  
ATOM    177  N   PRO A  14      53.417 -30.757  31.508  1.00  0.00           N  
ATOM    178  CA  PRO A  14      52.525 -29.868  32.258  1.00  0.00           C  
ATOM    179  C   PRO A  14      53.148 -28.503  32.535  1.00  0.00           C  
ATOM    180  O   PRO A  14      52.529 -27.468  32.287  1.00  0.00           O  
ATOM    181  CB  PRO A  14      52.310 -30.631  33.559  1.00  0.00           C  
ATOM    182  CG  PRO A  14      52.386 -32.065  33.164  1.00  0.00           C  
ATOM    183  CD  PRO A  14      53.377 -32.139  32.030  1.00  0.00           C  
ATOM    184  HA  PRO A  14      51.579 -29.737  31.754  1.00 99.99           H  
ATOM    185  HB2 PRO A  14      53.089 -30.369  34.261  1.00 99.99           H  
ATOM    186  HB3 PRO A  14      51.344 -30.385  33.973  1.00 99.99           H  
ATOM    187  HG2 PRO A  14      52.729 -32.658  34.000  1.00 99.99           H  
ATOM    188  HG3 PRO A  14      51.415 -32.406  32.835  1.00 99.99           H  
ATOM    189  HD2 PRO A  14      54.345 -32.440  32.398  1.00 99.99           H  
ATOM    190  HD3 PRO A  14      53.030 -32.825  31.271  1.00 99.99           H  
ATOM    191  N   ALA A  15      54.376 -28.505  33.046  1.00  0.00           N  
ATOM    192  CA  ALA A  15      55.078 -27.263  33.349  1.00  0.00           C  
ATOM    193  C   ALA A  15      55.103 -26.347  32.131  1.00  0.00           C  
ATOM    194  O   ALA A  15      54.379 -25.355  32.076  1.00  0.00           O  
ATOM    195  CB  ALA A  15      56.493 -27.554  33.828  1.00  0.00           C  
ATOM    196  H   ALA A  15      54.821 -29.361  33.220  1.00 99.99           H  
ATOM    197  HA  ALA A  15      54.545 -26.764  34.147  1.00 99.99           H  
ATOM    198  HB1 ALA A  15      57.025 -28.104  33.065  1.00 99.99           H  
ATOM    199  HB2 ALA A  15      56.453 -28.140  34.732  1.00 99.99           H  
ATOM    200  HB3 ALA A  15      57.005 -26.623  34.024  1.00 99.99           H  
ATOM    201  N   ILE A  16      55.927 -26.697  31.144  1.00  0.00           N  
ATOM    202  CA  ILE A  16      56.021 -25.912  29.917  1.00  0.00           C  
ATOM    203  C   ILE A  16      54.626 -25.633  29.366  1.00  0.00           C  
ATOM    204  O   ILE A  16      54.183 -24.486  29.321  1.00  0.00           O  
ATOM    205  CB  ILE A  16      56.854 -26.646  28.836  1.00  0.00           C  
ATOM    206  CG1 ILE A  16      58.344 -26.383  29.025  1.00  0.00           C  
ATOM    207  CG2 ILE A  16      56.441 -26.214  27.438  1.00  0.00           C  
ATOM    208  CD1 ILE A  16      59.020 -27.368  29.954  1.00  0.00           C  
ATOM    209  H   ILE A  16      56.470 -27.508  31.236  1.00 99.99           H  
ATOM    210  HA  ILE A  16      56.507 -24.970  30.150  1.00 99.99           H  
ATOM    211  HB  ILE A  16      56.670 -27.702  28.930  1.00 99.99           H  
ATOM    212  N   ARG A  17      53.943 -26.702  28.954  1.00  0.00           N  
ATOM    213  CA  ARG A  17      52.596 -26.596  28.399  1.00  0.00           C  
ATOM    214  C   ARG A  17      51.773 -25.554  29.158  1.00  0.00           C  
ATOM    215  O   ARG A  17      51.338 -24.553  28.588  1.00  0.00           O  
ATOM    216  CB  ARG A  17      51.892 -27.953  28.455  1.00  0.00           C  
ATOM    217  CG  ARG A  17      50.645 -28.026  27.588  1.00  0.00           C  
ATOM    218  CD  ARG A  17      49.928 -29.357  27.747  1.00  0.00           C  
ATOM    219  NE  ARG A  17      49.701 -30.014  26.462  1.00  0.00           N  
ATOM    220  CZ  ARG A  17      48.793 -30.966  26.266  1.00  0.00           C  
ATOM    221  NH1 ARG A  17      48.026 -31.381  27.267  1.00  0.00           N  
ATOM    222  NH2 ARG A  17      48.651 -31.509  25.064  1.00  0.00           N  
ATOM    223  H   ARG A  17      54.356 -27.586  29.027  1.00 99.99           H  
ATOM    224  HA  ARG A  17      52.690 -26.292  27.365  1.00 99.99           H  
ATOM    225  HB2 ARG A  17      52.580 -28.716  28.124  1.00 99.99           H  
ATOM    226  HB3 ARG A  17      51.607 -28.155  29.476  1.00 99.99           H  
ATOM    227  HG2 ARG A  17      49.973 -27.231  27.875  1.00 99.99           H  
ATOM    228  HG3 ARG A  17      50.931 -27.902  26.553  1.00 99.99           H  
ATOM    229  HD2 ARG A  17      50.530 -30.005  28.368  1.00 99.99           H  
ATOM    230  HD3 ARG A  17      48.976 -29.183  28.225  1.00 99.99           H  
ATOM    231  HE  ARG A  17      50.253 -29.728  25.704  1.00 99.99           H  
ATOM    232 HH11 ARG A  17      48.128 -30.975  28.176  1.00 99.99           H  
ATOM    233 HH12 ARG A  17      47.346 -32.097  27.113  1.00 99.99           H  
ATOM    234 HH21 ARG A  17      49.225 -31.202  24.305  1.00 99.99           H  
ATOM    235 HH22 ARG A  17      47.969 -32.225  24.916  1.00 99.99           H  
ATOM    236  N   GLU A  18      51.580 -25.795  30.452  1.00  0.00           N  
ATOM    237  CA  GLU A  18      50.824 -24.880  31.297  1.00  0.00           C  
ATOM    238  C   GLU A  18      51.454 -23.493  31.281  1.00  0.00           C  
ATOM    239  O   GLU A  18      50.755 -22.480  31.260  1.00  0.00           O  
ATOM    240  CB  GLU A  18      50.761 -25.412  32.731  1.00  0.00           C  
ATOM    241  CG  GLU A  18      49.998 -24.505  33.685  1.00  0.00           C  
ATOM    242  CD  GLU A  18      48.976 -25.257  34.514  1.00  0.00           C  
ATOM    243  OE1 GLU A  18      49.257 -26.411  34.899  1.00  0.00           O  
ATOM    244  OE2 GLU A  18      47.894 -24.691  34.779  1.00  0.00           O  
ATOM    245  H   GLU A  18      51.962 -26.606  30.848  1.00 99.99           H  
ATOM    246  HA  GLU A  18      49.822 -24.810  30.900  1.00 99.99           H  
ATOM    247  HB2 GLU A  18      50.277 -26.378  32.723  1.00 99.99           H  
ATOM    248  HB3 GLU A  18      51.768 -25.527  33.105  1.00 99.99           H  
ATOM    249  HG2 GLU A  18      50.703 -24.033  34.352  1.00 99.99           H  
ATOM    250  HG3 GLU A  18      49.486 -23.748  33.109  1.00 99.99           H  
ATOM    251  N   HIS A  19      52.784 -23.453  31.275  1.00  0.00           N  
ATOM    252  CA  HIS A  19      53.511 -22.195  31.241  1.00  0.00           C  
ATOM    253  C   HIS A  19      53.170 -21.444  29.960  1.00  0.00           C  
ATOM    254  O   HIS A  19      52.494 -20.416  29.992  1.00  0.00           O  
ATOM    255  CB  HIS A  19      55.008 -22.475  31.319  1.00  0.00           C  
ATOM    256  CG  HIS A  19      55.827 -21.319  31.769  1.00  0.00           C  
ATOM    257  ND1 HIS A  19      55.402 -20.381  32.683  1.00  0.00           N  
ATOM    258  CD2 HIS A  19      57.076 -20.975  31.425  1.00  0.00           C  
ATOM    259  CE1 HIS A  19      56.368 -19.502  32.883  1.00  0.00           C  
ATOM    260  NE2 HIS A  19      57.399 -19.839  32.128  1.00  0.00           N  
ATOM    261  H   HIS A  19      53.291 -24.292  31.277  1.00 99.99           H  
ATOM    262  HA  HIS A  19      53.209 -21.605  32.093  1.00 99.99           H  
ATOM    263  HB2 HIS A  19      55.183 -23.282  32.012  1.00 99.99           H  
ATOM    264  HB3 HIS A  19      55.364 -22.768  30.341  1.00 99.99           H  
ATOM    265  HD1 HIS A  19      54.525 -20.362  33.120  1.00 99.99           H  
ATOM    266  HD2 HIS A  19      57.706 -21.510  30.733  1.00 99.99           H  
ATOM    267  HE1 HIS A  19      56.328 -18.658  33.556  1.00 99.99           H  
ATOM    268  HE2 HIS A  19      58.292 -19.440  32.181  1.00 99.99           H  
ATOM    269  N   LEU A  20      53.619 -21.989  28.832  1.00  0.00           N  
ATOM    270  CA  LEU A  20      53.341 -21.396  27.524  1.00  0.00           C  
ATOM    271  C   LEU A  20      51.866 -21.019  27.411  1.00  0.00           C  
ATOM    272  O   LEU A  20      51.524 -19.885  27.068  1.00  0.00           O  
ATOM    273  CB  LEU A  20      53.713 -22.372  26.407  1.00  0.00           C  
ATOM    274  CG  LEU A  20      54.960 -23.222  26.679  1.00  0.00           C  
ATOM    275  CD1 LEU A  20      55.233 -24.187  25.540  1.00  0.00           C  
ATOM    276  CD2 LEU A  20      56.161 -22.329  26.921  1.00  0.00           C  
ATOM    277  H   LEU A  20      54.138 -22.816  28.881  1.00 99.99           H  
ATOM    278  HA  LEU A  20      53.938 -20.505  27.421  1.00 99.99           H  
ATOM    279  HB2 LEU A  20      52.874 -23.031  26.240  1.00 99.99           H  
ATOM    280  HB3 LEU A  20      53.886 -21.796  25.513  1.00 99.99           H  
ATOM    281  HG  LEU A  20      54.799 -23.808  27.566  1.00 99.99           H  
ATOM    282  N   GLU A  21      50.994 -21.979  27.719  1.00  0.00           N  
ATOM    283  CA  GLU A  21      49.554 -21.747  27.669  1.00  0.00           C  
ATOM    284  C   GLU A  21      49.184 -20.555  28.544  1.00  0.00           C  
ATOM    285  O   GLU A  21      48.561 -19.598  28.081  1.00  0.00           O  
ATOM    286  CB  GLU A  21      48.799 -22.994  28.130  1.00  0.00           C  
ATOM    287  CG  GLU A  21      48.797 -24.116  27.104  1.00  0.00           C  
ATOM    288  CD  GLU A  21      47.805 -25.213  27.440  1.00  0.00           C  
ATOM    289  OE1 GLU A  21      47.803 -25.677  28.600  1.00  0.00           O  
ATOM    290  OE2 GLU A  21      47.029 -25.606  26.545  1.00  0.00           O  
ATOM    291  H   GLU A  21      51.328 -22.857  27.997  1.00 99.99           H  
ATOM    292  HA  GLU A  21      49.288 -21.527  26.646  1.00 99.99           H  
ATOM    293  HB2 GLU A  21      49.255 -23.364  29.036  1.00 99.99           H  
ATOM    294  HB3 GLU A  21      47.774 -22.723  28.337  1.00 99.99           H  
ATOM    295  HG2 GLU A  21      48.541 -23.704  26.140  1.00 99.99           H  
ATOM    296  HG3 GLU A  21      49.785 -24.547  27.058  1.00 99.99           H  
ATOM    297  N   GLU A  22      49.590 -20.613  29.810  1.00  0.00           N  
ATOM    298  CA  GLU A  22      49.318 -19.529  30.748  1.00  0.00           C  
ATOM    299  C   GLU A  22      49.810 -18.206  30.174  1.00  0.00           C  
ATOM    300  O   GLU A  22      49.119 -17.188  30.246  1.00  0.00           O  
ATOM    301  CB  GLU A  22      49.994 -19.802  32.093  1.00  0.00           C  
ATOM    302  CG  GLU A  22      49.225 -20.774  32.975  1.00  0.00           C  
ATOM    303  CD  GLU A  22      48.877 -20.184  34.328  1.00  0.00           C  
ATOM    304  OE1 GLU A  22      48.249 -19.106  34.364  1.00  0.00           O  
ATOM    305  OE2 GLU A  22      49.233 -20.802  35.354  1.00  0.00           O  
ATOM    306  H   GLU A  22      50.094 -21.398  30.117  1.00 99.99           H  
ATOM    307  HA  GLU A  22      48.250 -19.474  30.893  1.00 99.99           H  
ATOM    308  HB2 GLU A  22      50.976 -20.213  31.913  1.00 99.99           H  
ATOM    309  HB3 GLU A  22      50.098 -18.868  32.627  1.00 99.99           H  
ATOM    310  HG2 GLU A  22      48.308 -21.046  32.472  1.00 99.99           H  
ATOM    311  HG3 GLU A  22      49.828 -21.656  33.126  1.00 99.99           H  
ATOM    312  N   ARG A  23      51.004 -18.232  29.584  1.00  0.00           N  
ATOM    313  CA  ARG A  23      51.581 -17.041  28.979  1.00  0.00           C  
ATOM    314  C   ARG A  23      50.671 -16.530  27.869  1.00  0.00           C  
ATOM    315  O   ARG A  23      50.379 -15.336  27.792  1.00  0.00           O  
ATOM    316  CB  ARG A  23      52.973 -17.339  28.425  1.00  0.00           C  
ATOM    317  CG  ARG A  23      54.053 -17.396  29.495  1.00  0.00           C  
ATOM    318  CD  ARG A  23      53.997 -16.190  30.422  1.00  0.00           C  
ATOM    319  NE  ARG A  23      55.309 -15.858  30.969  1.00  0.00           N  
ATOM    320  CZ  ARG A  23      55.533 -14.825  31.781  1.00  0.00           C  
ATOM    321  NH1 ARG A  23      54.537 -14.026  32.140  1.00  0.00           N  
ATOM    322  NH2 ARG A  23      56.757 -14.594  32.235  1.00  0.00           N  
ATOM    323  H   ARG A  23      51.502 -19.076  29.547  1.00 99.99           H  
ATOM    324  HA  ARG A  23      51.661 -16.284  29.743  1.00 99.99           H  
ATOM    325  HB2 ARG A  23      52.950 -18.291  27.915  1.00 99.99           H  
ATOM    326  HB3 ARG A  23      53.239 -16.569  27.717  1.00 99.99           H  
ATOM    327  HG2 ARG A  23      53.921 -18.292  30.080  1.00 99.99           H  
ATOM    328  HG3 ARG A  23      55.016 -17.418  29.012  1.00 99.99           H  
ATOM    329  HD2 ARG A  23      53.622 -15.342  29.867  1.00 99.99           H  
ATOM    330  HD3 ARG A  23      53.323 -16.411  31.237  1.00 99.99           H  
ATOM    331  HE  ARG A  23      56.063 -16.432  30.720  1.00 99.99           H  
ATOM    332 HH11 ARG A  23      53.612 -14.195  31.802  1.00 99.99           H  
ATOM    333 HH12 ARG A  23      54.712 -13.253  32.750  1.00 99.99           H  
ATOM    334 HH21 ARG A  23      57.512 -15.195  31.968  1.00 99.99           H  
ATOM    335 HH22 ARG A  23      56.926 -13.819  32.844  1.00 99.99           H  
ATOM    336  N   LEU A  24      50.208 -17.448  27.022  1.00  0.00           N  
ATOM    337  CA  LEU A  24      49.307 -17.088  25.935  1.00  0.00           C  
ATOM    338  C   LEU A  24      48.039 -16.470  26.506  1.00  0.00           C  
ATOM    339  O   LEU A  24      47.632 -15.370  26.114  1.00  0.00           O  
ATOM    340  CB  LEU A  24      48.962 -18.317  25.093  1.00  0.00           C  
ATOM    341  CG  LEU A  24      47.966 -18.067  23.959  1.00  0.00           C  
ATOM    342  CD1 LEU A  24      48.698 -17.742  22.667  1.00  0.00           C  
ATOM    343  CD2 LEU A  24      47.058 -19.273  23.771  1.00  0.00           C  
ATOM    344  H   LEU A  24      50.462 -18.386  27.144  1.00 99.99           H  
ATOM    345  HA  LEU A  24      49.806 -16.358  25.314  1.00 99.99           H  
ATOM    346  HB2 LEU A  24      49.876 -18.700  24.662  1.00 99.99           H  
ATOM    347  HB3 LEU A  24      48.548 -19.070  25.746  1.00 99.99           H  
ATOM    348  HG  LEU A  24      47.346 -17.218  24.214  1.00 99.99           H  
ATOM    349  N   ALA A  25      47.429 -17.174  27.458  1.00  0.00           N  
ATOM    350  CA  ALA A  25      46.223 -16.685  28.110  1.00  0.00           C  
ATOM    351  C   ALA A  25      46.485 -15.318  28.723  1.00  0.00           C  
ATOM    352  O   ALA A  25      45.600 -14.462  28.770  1.00  0.00           O  
ATOM    353  CB  ALA A  25      45.757 -17.669  29.174  1.00  0.00           C  
ATOM    354  H   ALA A  25      47.813 -18.031  27.740  1.00 99.99           H  
ATOM    355  HA  ALA A  25      45.447 -16.597  27.363  1.00 99.99           H  
ATOM    356  HB1 ALA A  25      45.071 -18.377  28.734  1.00 99.99           H  
ATOM    357  HB2 ALA A  25      45.261 -17.131  29.968  1.00 99.99           H  
ATOM    358  HB3 ALA A  25      46.611 -18.195  29.575  1.00 99.99           H  
ATOM    359  N   LYS A  26      47.721 -15.115  29.174  1.00  0.00           N  
ATOM    360  CA  LYS A  26      48.121 -13.847  29.764  1.00  0.00           C  
ATOM    361  C   LYS A  26      48.227 -12.783  28.679  1.00  0.00           C  
ATOM    362  O   LYS A  26      47.833 -11.635  28.880  1.00  0.00           O  
ATOM    363  CB  LYS A  26      49.458 -13.994  30.491  1.00  0.00           C  
ATOM    364  CG  LYS A  26      49.805 -12.804  31.374  1.00  0.00           C  
ATOM    365  CD  LYS A  26      50.184 -13.240  32.782  1.00  0.00           C  
ATOM    366  CE  LYS A  26      51.442 -12.537  33.264  1.00  0.00           C  
ATOM    367  NZ  LYS A  26      51.360 -12.178  34.708  1.00  0.00           N  
ATOM    368  H   LYS A  26      48.383 -15.834  29.093  1.00 99.99           H  
ATOM    369  HA  LYS A  26      47.360 -13.552  30.471  1.00 99.99           H  
ATOM    370  HB2 LYS A  26      49.422 -14.877  31.112  1.00 99.99           H  
ATOM    371  HB3 LYS A  26      50.242 -14.111  29.758  1.00 99.99           H  
ATOM    372  HG2 LYS A  26      50.637 -12.274  30.935  1.00 99.99           H  
ATOM    373  HG3 LYS A  26      48.948 -12.147  31.429  1.00 99.99           H  
ATOM    374  HD2 LYS A  26      49.372 -13.002  33.452  1.00 99.99           H  
ATOM    375  HD3 LYS A  26      50.354 -14.306  32.784  1.00 99.99           H  
ATOM    376  HE2 LYS A  26      52.286 -13.193  33.113  1.00 99.99           H  
ATOM    377  HE3 LYS A  26      51.580 -11.635  32.685  1.00 99.99           H  
ATOM    378  HZ1 LYS A  26      51.526 -13.019  35.295  1.00 99.99           H  
ATOM    379  HZ2 LYS A  26      50.419 -11.795  34.928  1.00 99.99           H  
ATOM    380  HZ3 LYS A  26      52.078 -11.461  34.938  1.00 99.99           H  
ATOM    381  N   LEU A  27      48.747 -13.182  27.519  1.00  0.00           N  
ATOM    382  CA  LEU A  27      48.885 -12.266  26.394  1.00  0.00           C  
ATOM    383  C   LEU A  27      47.530 -12.026  25.729  1.00  0.00           C  
ATOM    384  O   LEU A  27      47.393 -11.149  24.879  1.00  0.00           O  
ATOM    385  CB  LEU A  27      49.903 -12.796  25.373  1.00  0.00           C  
ATOM    386  CG  LEU A  27      51.328 -12.249  25.537  1.00  0.00           C  
ATOM    387  CD1 LEU A  27      52.219 -12.724  24.399  1.00  0.00           C  
ATOM    388  CD2 LEU A  27      51.319 -10.725  25.607  1.00  0.00           C  
ATOM    389  H   LEU A  27      49.032 -14.115  27.416  1.00 99.99           H  
ATOM    390  HA  LEU A  27      49.243 -11.327  26.786  1.00 99.99           H  
ATOM    391  HB2 LEU A  27      49.942 -13.874  25.458  1.00 99.99           H  
ATOM    392  HB3 LEU A  27      49.558 -12.544  24.381  1.00 99.99           H  
ATOM    393  HG  LEU A  27      51.743 -12.623  26.461  1.00 99.99           H  
ATOM    394  N   GLY A  28      46.521 -12.802  26.130  1.00  0.00           N  
ATOM    395  CA  GLY A  28      45.191 -12.634  25.569  1.00  0.00           C  
ATOM    396  C   GLY A  28      44.594 -11.282  25.911  1.00  0.00           C  
ATOM    397  O   GLY A  28      43.889 -10.680  25.101  1.00  0.00           O  
ATOM    398  H   GLY A  28      46.677 -13.482  26.819  1.00 99.99           H  
ATOM    399  HA2 GLY A  28      45.247 -12.727  24.497  1.00 99.99           H  
ATOM    400  HA3 GLY A  28      44.546 -13.408  25.955  1.00 99.99           H  
ATOM    401  N   LYS A  29      44.886 -10.807  27.114  1.00  0.00           N  
ATOM    402  CA  LYS A  29      44.391  -9.516  27.578  1.00  0.00           C  
ATOM    403  C   LYS A  29      44.955  -8.380  26.725  1.00  0.00           C  
ATOM    404  O   LYS A  29      44.373  -7.297  26.647  1.00  0.00           O  
ATOM    405  CB  LYS A  29      44.782  -9.318  29.051  1.00  0.00           C  
ATOM    406  CG  LYS A  29      44.614  -7.894  29.569  1.00  0.00           C  
ATOM    407  CD  LYS A  29      45.653  -7.564  30.631  1.00  0.00           C  
ATOM    408  CE  LYS A  29      46.702  -6.589  30.111  1.00  0.00           C  
ATOM    409  NZ  LYS A  29      46.926  -5.460  31.054  1.00  0.00           N  
ATOM    410  H   LYS A  29      45.459 -11.336  27.709  1.00 99.99           H  
ATOM    411  HA  LYS A  29      43.314  -9.519  27.496  1.00 99.99           H  
ATOM    412  HB2 LYS A  29      44.172  -9.967  29.659  1.00 99.99           H  
ATOM    413  HB3 LYS A  29      45.818  -9.600  29.172  1.00 99.99           H  
ATOM    414  HG2 LYS A  29      44.723  -7.203  28.750  1.00 99.99           H  
ATOM    415  HG3 LYS A  29      43.631  -7.795  29.997  1.00 99.99           H  
ATOM    416  HD2 LYS A  29      45.154  -7.120  31.479  1.00 99.99           H  
ATOM    417  HD3 LYS A  29      46.142  -8.476  30.937  1.00 99.99           H  
ATOM    418  HE2 LYS A  29      47.632  -7.120  29.970  1.00 99.99           H  
ATOM    419  HE3 LYS A  29      46.370  -6.194  29.162  1.00 99.99           H  
ATOM    420  HZ1 LYS A  29      47.749  -5.660  31.661  1.00 99.99           H  
ATOM    421  HZ2 LYS A  29      46.090  -5.326  31.658  1.00 99.99           H  
ATOM    422  HZ3 LYS A  29      47.103  -4.583  30.527  1.00 99.99           H  
ATOM    423  N   TRP A  30      46.097  -8.633  26.101  1.00  0.00           N  
ATOM    424  CA  TRP A  30      46.755  -7.662  25.281  1.00  0.00           C  
ATOM    425  C   TRP A  30      45.962  -7.360  24.026  1.00  0.00           C  
ATOM    426  O   TRP A  30      45.239  -8.206  23.503  1.00  0.00           O  
ATOM    427  CB  TRP A  30      48.152  -8.161  24.926  1.00  0.00           C  
ATOM    428  CG  TRP A  30      49.151  -7.915  26.011  1.00  0.00           C  
ATOM    429  CD1 TRP A  30      49.351  -8.663  27.135  1.00  0.00           C  
ATOM    430  CD2 TRP A  30      50.077  -6.834  26.075  1.00  0.00           C  
ATOM    431  NE1 TRP A  30      50.358  -8.111  27.892  1.00  0.00           N  
ATOM    432  CE2 TRP A  30      50.818  -6.984  27.260  1.00  0.00           C  
ATOM    433  CE3 TRP A  30      50.350  -5.757  25.240  1.00  0.00           C  
ATOM    434  CZ2 TRP A  30      51.818  -6.088  27.627  1.00  0.00           C  
ATOM    435  CZ3 TRP A  30      51.338  -4.867  25.606  1.00  0.00           C  
ATOM    436  CH2 TRP A  30      52.063  -5.037  26.789  1.00  0.00           C  
ATOM    437  H   TRP A  30      46.512  -9.491  26.201  1.00 99.99           H  
ATOM    438  HA  TRP A  30      46.852  -6.761  25.854  1.00 99.99           H  
ATOM    439  HB2 TRP A  30      48.114  -9.222  24.739  1.00 99.99           H  
ATOM    440  HB3 TRP A  30      48.490  -7.656  24.039  1.00 99.99           H  
ATOM    441  HD1 TRP A  30      48.797  -9.555  27.381  1.00 99.99           H  
ATOM    442  HE1 TRP A  30      50.690  -8.464  28.743  1.00 99.99           H  
ATOM    443  HE3 TRP A  30      49.805  -5.614  24.321  1.00 99.99           H  
ATOM    444  HZ2 TRP A  30      52.389  -6.205  28.535  1.00 99.99           H  
ATOM    445  HZ3 TRP A  30      51.559  -4.026  24.973  1.00 99.99           H  
ATOM    446  HH2 TRP A  30      52.824  -4.316  27.036  1.00 99.99           H  
ATOM    447  N   GLN A  31      46.126  -6.138  23.562  1.00  0.00           N  
ATOM    448  CA  GLN A  31      45.463  -5.651  22.357  1.00  0.00           C  
ATOM    449  C   GLN A  31      45.897  -6.479  21.156  1.00  0.00           C  
ATOM    450  O   GLN A  31      46.599  -5.987  20.272  1.00  0.00           O  
ATOM    451  CB  GLN A  31      45.825  -4.183  22.113  1.00  0.00           C  
ATOM    452  CG  GLN A  31      45.137  -3.199  23.044  1.00  0.00           C  
ATOM    453  CD  GLN A  31      45.212  -3.615  24.500  1.00  0.00           C  
ATOM    454  OE1 GLN A  31      44.302  -4.261  25.021  1.00  0.00           O  
ATOM    455  NE2 GLN A  31      46.300  -3.245  25.166  1.00  0.00           N  
ATOM    456  H   GLN A  31      46.724  -5.545  24.050  1.00 99.99           H  
ATOM    457  HA  GLN A  31      44.395  -5.742  22.491  1.00 99.99           H  
ATOM    458  HB2 GLN A  31      46.891  -4.068  22.236  1.00 99.99           H  
ATOM    459  HB3 GLN A  31      45.561  -3.926  21.096  1.00 99.99           H  
ATOM    460  HG2 GLN A  31      45.615  -2.234  22.936  1.00 99.99           H  
ATOM    461  HG3 GLN A  31      44.099  -3.118  22.758  1.00 99.99           H  
ATOM    462  N   THR A  32      45.507  -7.745  21.137  1.00  0.00           N  
ATOM    463  CA  THR A  32      45.896  -8.628  20.059  1.00  0.00           C  
ATOM    464  C   THR A  32      45.068  -9.912  20.058  1.00  0.00           C  
ATOM    465  O   THR A  32      44.459 -10.282  21.061  1.00  0.00           O  
ATOM    466  CB  THR A  32      47.382  -8.957  20.211  1.00  0.00           C  
ATOM    467  OG1 THR A  32      48.182  -7.840  19.867  1.00  0.00           O  
ATOM    468  CG2 THR A  32      47.840 -10.120  19.365  1.00  0.00           C  
ATOM    469  H   THR A  32      44.971  -8.098  21.872  1.00 99.99           H  
ATOM    470  HA  THR A  32      45.744  -8.109  19.127  1.00 99.99           H  
ATOM    471  HB  THR A  32      47.578  -9.207  21.247  1.00 99.99           H  
ATOM    472  HG1 THR A  32      47.913  -7.508  19.008  1.00 99.99           H  
ATOM    473  N   GLN A  33      45.091 -10.594  18.922  1.00  0.00           N  
ATOM    474  CA  GLN A  33      44.394 -11.856  18.745  1.00  0.00           C  
ATOM    475  C   GLN A  33      45.358 -12.838  18.113  1.00  0.00           C  
ATOM    476  O   GLN A  33      45.546 -12.854  16.896  1.00  0.00           O  
ATOM    477  CB  GLN A  33      43.155 -11.695  17.871  1.00  0.00           C  
ATOM    478  CG  GLN A  33      43.305 -10.652  16.776  1.00  0.00           C  
ATOM    479  CD  GLN A  33      42.920  -9.262  17.249  1.00  0.00           C  
ATOM    480  OE1 GLN A  33      43.116  -8.916  18.414  1.00  0.00           O  
ATOM    481  NE2 GLN A  33      42.368  -8.455  16.349  1.00  0.00           N  
ATOM    482  H   GLN A  33      45.622 -10.248  18.181  1.00 99.99           H  
ATOM    483  HA  GLN A  33      44.105 -12.222  19.720  1.00 99.99           H  
ATOM    484  HB2 GLN A  33      42.938 -12.644  17.408  1.00 99.99           H  
ATOM    485  HB3 GLN A  33      42.326 -11.410  18.497  1.00 99.99           H  
ATOM    486  HG2 GLN A  33      44.336 -10.637  16.456  1.00 99.99           H  
ATOM    487  HG3 GLN A  33      42.674 -10.927  15.944  1.00 99.99           H  
ATOM    488  N   LEU A  34      46.003 -13.616  18.955  1.00  0.00           N  
ATOM    489  CA  LEU A  34      47.003 -14.569  18.512  1.00  0.00           C  
ATOM    490  C   LEU A  34      46.528 -15.424  17.348  1.00  0.00           C  
ATOM    491  O   LEU A  34      45.873 -16.449  17.534  1.00  0.00           O  
ATOM    492  CB  LEU A  34      47.438 -15.456  19.675  1.00  0.00           C  
ATOM    493  CG  LEU A  34      47.820 -14.713  20.963  1.00  0.00           C  
ATOM    494  CD1 LEU A  34      48.238 -13.274  20.672  1.00  0.00           C  
ATOM    495  CD2 LEU A  34      46.660 -14.743  21.943  1.00  0.00           C  
ATOM    496  H   LEU A  34      45.827 -13.523  19.912  1.00 99.99           H  
ATOM    497  HA  LEU A  34      47.853 -13.994  18.183  1.00 99.99           H  
ATOM    498  HB2 LEU A  34      46.630 -16.135  19.903  1.00 99.99           H  
ATOM    499  HB3 LEU A  34      48.290 -16.033  19.357  1.00 99.99           H  
ATOM    500  HG  LEU A  34      48.658 -15.216  21.423  1.00 99.99           H  
ATOM    501  N   ILE A  35      46.903 -15.007  16.146  1.00  0.00           N  
ATOM    502  CA  ILE A  35      46.561 -15.739  14.941  1.00  0.00           C  
ATOM    503  C   ILE A  35      47.429 -16.986  14.844  1.00  0.00           C  
ATOM    504  O   ILE A  35      48.529 -16.946  14.292  1.00  0.00           O  
ATOM    505  CB  ILE A  35      46.769 -14.871  13.689  1.00  0.00           C  
ATOM    506  CG1 ILE A  35      45.778 -13.703  13.702  1.00  0.00           C  
ATOM    507  CG2 ILE A  35      46.614 -15.711  12.425  1.00  0.00           C  
ATOM    508  CD1 ILE A  35      45.667 -13.002  12.373  1.00  0.00           C  
ATOM    509  H   ILE A  35      47.446 -14.196  16.073  1.00 99.99           H  
ATOM    510  HA  ILE A  35      45.522 -16.024  14.993  1.00 99.99           H  
ATOM    511  HB  ILE A  35      47.779 -14.477  13.713  1.00 99.99           H  
ATOM    512  N   SER A  36      46.944 -18.085  15.405  1.00  0.00           N  
ATOM    513  CA  SER A  36      47.700 -19.333  15.396  1.00  0.00           C  
ATOM    514  C   SER A  36      49.036 -19.131  16.105  1.00  0.00           C  
ATOM    515  O   SER A  36      50.009 -18.673  15.506  1.00  0.00           O  
ATOM    516  CB  SER A  36      47.919 -19.801  13.958  1.00  0.00           C  
ATOM    517  OG  SER A  36      48.831 -20.886  13.905  1.00  0.00           O  
ATOM    518  H   SER A  36      46.067 -18.053  15.841  1.00 99.99           H  
ATOM    519  HA  SER A  36      47.130 -20.077  15.942  1.00 99.99           H  
ATOM    520  HB2 SER A  36      46.975 -20.117  13.538  1.00 99.99           H  
ATOM    521  HB3 SER A  36      48.315 -18.982  13.374  1.00 99.99           H  
ATOM    522  HG  SER A  36      49.130 -21.009  13.001  1.00 99.99           H  
ATOM    523  N   PRO A  37      49.080 -19.443  17.408  1.00  0.00           N  
ATOM    524  CA  PRO A  37      50.264 -19.276  18.237  1.00  0.00           C  
ATOM    525  C   PRO A  37      51.101 -20.542  18.398  1.00  0.00           C  
ATOM    526  O   PRO A  37      50.569 -21.643  18.553  1.00  0.00           O  
ATOM    527  CB  PRO A  37      49.649 -18.883  19.579  1.00  0.00           C  
ATOM    528  CG  PRO A  37      48.283 -19.513  19.598  1.00  0.00           C  
ATOM    529  CD  PRO A  37      47.959 -19.955  18.198  1.00  0.00           C  
ATOM    530  HA  PRO A  37      50.889 -18.473  17.882  1.00 99.99           H  
ATOM    531  HB2 PRO A  37      50.266 -19.258  20.381  1.00 99.99           H  
ATOM    532  HB3 PRO A  37      49.585 -17.807  19.643  1.00 99.99           H  
ATOM    533  HG2 PRO A  37      48.284 -20.367  20.244  1.00 99.99           H  
ATOM    534  HG3 PRO A  37      47.555 -18.792  19.938  1.00 99.99           H  
ATOM    535  HD2 PRO A  37      47.911 -21.032  18.144  1.00 99.99           H  
ATOM    536  HD3 PRO A  37      47.028 -19.520  17.876  1.00 99.99           H  
ATOM    537  N   HIS A  38      52.418 -20.362  18.380  1.00  0.00           N  
ATOM    538  CA  HIS A  38      53.356 -21.461  18.541  1.00  0.00           C  
ATOM    539  C   HIS A  38      54.448 -21.091  19.525  1.00  0.00           C  
ATOM    540  O   HIS A  38      54.574 -19.937  19.936  1.00  0.00           O  
ATOM    541  CB  HIS A  38      54.014 -21.815  17.214  1.00  0.00           C  
ATOM    542  CG  HIS A  38      53.621 -23.144  16.670  1.00  0.00           C  
ATOM    543  ND1 HIS A  38      53.070 -23.299  15.421  1.00  0.00           N  
ATOM    544  CD2 HIS A  38      53.732 -24.388  17.192  1.00  0.00           C  
ATOM    545  CE1 HIS A  38      52.862 -24.583  15.191  1.00  0.00           C  
ATOM    546  NE2 HIS A  38      53.253 -25.265  16.250  1.00  0.00           N  
ATOM    547  H   HIS A  38      52.771 -19.459  18.266  1.00 99.99           H  
ATOM    548  HA  HIS A  38      52.818 -22.315  18.914  1.00 99.99           H  
ATOM    549  HB2 HIS A  38      53.754 -21.073  16.491  1.00 99.99           H  
ATOM    550  HB3 HIS A  38      55.088 -21.817  17.343  1.00 99.99           H  
ATOM    551  HD1 HIS A  38      52.852 -22.572  14.801  1.00 99.99           H  
ATOM    552  HD2 HIS A  38      54.125 -24.641  18.166  1.00 99.99           H  
ATOM    553  HE1 HIS A  38      52.461 -25.002  14.284  1.00 99.99           H  
ATOM    554  HE2 HIS A  38      53.126 -26.227  16.383  1.00 99.99           H  
ATOM    555  N   PHE A  39      55.253 -22.077  19.866  1.00  0.00           N  
ATOM    556  CA  PHE A  39      56.370 -21.867  20.768  1.00  0.00           C  
ATOM    557  C   PHE A  39      57.487 -22.865  20.491  1.00  0.00           C  
ATOM    558  O   PHE A  39      57.377 -24.044  20.827  1.00  0.00           O  
ATOM    559  CB  PHE A  39      55.924 -21.954  22.220  1.00  0.00           C  
ATOM    560  CG  PHE A  39      55.928 -20.628  22.926  1.00  0.00           C  
ATOM    561  CD1 PHE A  39      54.889 -19.727  22.754  1.00  0.00           C  
ATOM    562  CD2 PHE A  39      56.978 -20.284  23.761  1.00  0.00           C  
ATOM    563  CE1 PHE A  39      54.899 -18.508  23.404  1.00  0.00           C  
ATOM    564  CE2 PHE A  39      56.994 -19.065  24.412  1.00  0.00           C  
ATOM    565  CZ  PHE A  39      55.953 -18.177  24.234  1.00  0.00           C  
ATOM    566  H   PHE A  39      55.110 -22.959  19.474  1.00 99.99           H  
ATOM    567  HA  PHE A  39      56.750 -20.882  20.588  1.00 99.99           H  
ATOM    568  HB2 PHE A  39      54.923 -22.356  22.264  1.00 99.99           H  
ATOM    569  HB3 PHE A  39      56.598 -22.604  22.744  1.00 99.99           H  
ATOM    570  HD1 PHE A  39      54.065 -19.986  22.107  1.00 99.99           H  
ATOM    571  HD2 PHE A  39      57.793 -20.978  23.901  1.00 99.99           H  
ATOM    572  HE1 PHE A  39      54.082 -17.813  23.263  1.00 99.99           H  
ATOM    573  HE2 PHE A  39      57.817 -18.811  25.061  1.00 99.99           H  
ATOM    574  HZ  PHE A  39      55.964 -17.225  24.743  1.00 99.99           H  
ATOM    575  N   VAL A  40      58.565 -22.381  19.886  1.00  0.00           N  
ATOM    576  CA  VAL A  40      59.702 -23.219  19.575  1.00  0.00           C  
ATOM    577  C   VAL A  40      60.668 -23.230  20.755  1.00  0.00           C  
ATOM    578  O   VAL A  40      61.568 -22.394  20.858  1.00  0.00           O  
ATOM    579  CB  VAL A  40      60.410 -22.721  18.304  1.00  0.00           C  
ATOM    580  CG1 VAL A  40      61.645 -23.551  18.022  1.00  0.00           C  
ATOM    581  CG2 VAL A  40      59.454 -22.749  17.116  1.00  0.00           C  
ATOM    582  H   VAL A  40      58.599 -21.435  19.647  1.00 99.99           H  
ATOM    583  HA  VAL A  40      59.343 -24.223  19.400  1.00 99.99           H  
ATOM    584  HB  VAL A  40      60.720 -21.699  18.465  1.00 99.99           H  
ATOM    585  N   LEU A  41      60.438 -24.176  21.659  1.00  0.00           N  
ATOM    586  CA  LEU A  41      61.238 -24.318  22.869  1.00  0.00           C  
ATOM    587  C   LEU A  41      62.426 -25.249  22.659  1.00  0.00           C  
ATOM    588  O   LEU A  41      62.305 -26.288  22.016  1.00  0.00           O  
ATOM    589  CB  LEU A  41      60.352 -24.869  23.986  1.00  0.00           C  
ATOM    590  CG  LEU A  41      60.954 -24.838  25.388  1.00  0.00           C  
ATOM    591  CD1 LEU A  41      60.672 -23.510  26.069  1.00  0.00           C  
ATOM    592  CD2 LEU A  41      60.405 -25.993  26.211  1.00  0.00           C  
ATOM    593  H   LEU A  41      59.685 -24.788  21.517  1.00 99.99           H  
ATOM    594  HA  LEU A  41      61.598 -23.342  23.155  1.00 99.99           H  
ATOM    595  HB2 LEU A  41      59.435 -24.302  24.001  1.00 99.99           H  
ATOM    596  HB3 LEU A  41      60.116 -25.894  23.749  1.00 99.99           H  
ATOM    597  HG  LEU A  41      62.023 -24.954  25.315  1.00 99.99           H  
ATOM    598  N   ASN A  42      63.569 -24.883  23.225  1.00  0.00           N  
ATOM    599  CA  ASN A  42      64.768 -25.708  23.110  1.00  0.00           C  
ATOM    600  C   ASN A  42      65.692 -25.536  24.309  1.00  0.00           C  
ATOM    601  O   ASN A  42      65.623 -24.550  25.043  1.00  0.00           O  
ATOM    602  CB  ASN A  42      65.535 -25.405  21.826  1.00  0.00           C  
ATOM    603  CG  ASN A  42      64.659 -25.493  20.597  1.00  0.00           C  
ATOM    604  OD1 ASN A  42      64.068 -26.536  20.314  1.00  0.00           O  
ATOM    605  ND2 ASN A  42      64.573 -24.400  19.856  1.00  0.00           N  
ATOM    606  H   ASN A  42      63.603 -24.052  23.744  1.00 99.99           H  
ATOM    607  HA  ASN A  42      64.443 -26.736  23.080  1.00 99.99           H  
ATOM    608  HB2 ASN A  42      65.951 -24.415  21.885  1.00 99.99           H  
ATOM    609  HB3 ASN A  42      66.339 -26.121  21.722  1.00 99.99           H  
ATOM    610  N   LYS A  43      66.560 -26.516  24.488  1.00  0.00           N  
ATOM    611  CA  LYS A  43      67.525 -26.515  25.578  1.00  0.00           C  
ATOM    612  C   LYS A  43      68.927 -26.692  25.021  1.00  0.00           C  
ATOM    613  O   LYS A  43      69.100 -27.075  23.864  1.00  0.00           O  
ATOM    614  CB  LYS A  43      67.231 -27.662  26.560  1.00  0.00           C  
ATOM    615  CG  LYS A  43      68.489 -28.335  27.112  1.00  0.00           C  
ATOM    616  CD  LYS A  43      68.148 -29.479  28.052  1.00  0.00           C  
ATOM    617  CE  LYS A  43      69.047 -29.479  29.278  1.00  0.00           C  
ATOM    618  NZ  LYS A  43      69.419 -30.860  29.694  1.00  0.00           N  
ATOM    619  H   LYS A  43      66.557 -27.266  23.857  1.00 99.99           H  
ATOM    620  HA  LYS A  43      67.457 -25.566  26.105  1.00 99.99           H  
ATOM    621  HB2 LYS A  43      66.662 -27.272  27.389  1.00 99.99           H  
ATOM    622  HB3 LYS A  43      66.639 -28.415  26.052  1.00 99.99           H  
ATOM    623  HG2 LYS A  43      69.075 -28.719  26.284  1.00 99.99           H  
ATOM    624  HG3 LYS A  43      69.078 -27.599  27.645  1.00 99.99           H  
ATOM    625  HD2 LYS A  43      67.122 -29.376  28.372  1.00 99.99           H  
ATOM    626  HD3 LYS A  43      68.272 -30.414  27.526  1.00 99.99           H  
ATOM    627  HE2 LYS A  43      69.947 -28.929  29.048  1.00 99.99           H  
ATOM    628  HE3 LYS A  43      68.527 -28.995  30.091  1.00 99.99           H  
ATOM    629  HZ1 LYS A  43      68.712 -31.540  29.346  1.00 99.99           H  
ATOM    630  HZ2 LYS A  43      69.462 -30.922  30.731  1.00 99.99           H  
ATOM    631  HZ3 LYS A  43      70.349 -31.113  29.304  1.00 99.99           H  
ATOM    632  N   VAL A  44      69.922 -26.456  25.859  1.00  0.00           N  
ATOM    633  CA  VAL A  44      71.298 -26.635  25.458  1.00  0.00           C  
ATOM    634  C   VAL A  44      72.222 -26.767  26.669  1.00  0.00           C  
ATOM    635  O   VAL A  44      71.887 -26.332  27.768  1.00  0.00           O  
ATOM    636  CB  VAL A  44      71.782 -25.487  24.571  1.00  0.00           C  
ATOM    637  CG1 VAL A  44      71.271 -25.651  23.146  1.00  0.00           C  
ATOM    638  CG2 VAL A  44      71.377 -24.135  25.141  1.00  0.00           C  
ATOM    639  H   VAL A  44      69.725 -26.178  26.778  1.00 99.99           H  
ATOM    640  HA  VAL A  44      71.354 -27.548  24.882  1.00 99.99           H  
ATOM    641  HB  VAL A  44      72.847 -25.540  24.555  1.00 99.99           H  
ATOM    642  N   PRO A  45      73.401 -27.379  26.485  1.00  0.00           N  
ATOM    643  CA  PRO A  45      74.365 -27.571  27.572  1.00  0.00           C  
ATOM    644  C   PRO A  45      74.642 -26.285  28.346  1.00  0.00           C  
ATOM    645  O   PRO A  45      74.717 -26.291  29.574  1.00  0.00           O  
ATOM    646  CB  PRO A  45      75.626 -28.040  26.845  1.00  0.00           C  
ATOM    647  CG  PRO A  45      75.126 -28.692  25.604  1.00  0.00           C  
ATOM    648  CD  PRO A  45      73.885 -27.937  25.208  1.00  0.00           C  
ATOM    649  HA  PRO A  45      74.036 -28.336  28.258  1.00 99.99           H  
ATOM    650  HB2 PRO A  45      76.254 -27.190  26.623  1.00 99.99           H  
ATOM    651  HB3 PRO A  45      76.164 -28.740  27.469  1.00 99.99           H  
ATOM    652  HG2 PRO A  45      75.872 -28.621  24.826  1.00 99.99           H  
ATOM    653  HG3 PRO A  45      74.886 -29.726  25.801  1.00 99.99           H  
ATOM    654  HD2 PRO A  45      74.130 -27.149  24.511  1.00 99.99           H  
ATOM    655  HD3 PRO A  45      73.155 -28.607  24.780  1.00 99.99           H  
ATOM    656  N   ASN A  46      74.805 -25.189  27.615  1.00  0.00           N  
ATOM    657  CA  ASN A  46      75.087 -23.892  28.224  1.00  0.00           C  
ATOM    658  C   ASN A  46      73.822 -23.208  28.750  1.00  0.00           C  
ATOM    659  O   ASN A  46      73.879 -22.059  29.191  1.00  0.00           O  
ATOM    660  CB  ASN A  46      75.783 -22.980  27.214  1.00  0.00           C  
ATOM    661  CG  ASN A  46      77.154 -23.494  26.818  1.00  0.00           C  
ATOM    662  OD1 ASN A  46      77.413 -23.764  25.646  1.00  0.00           O  
ATOM    663  ND2 ASN A  46      78.040 -23.631  27.798  1.00  0.00           N  
ATOM    664  H   ASN A  46      74.740 -25.254  26.641  1.00 99.99           H  
ATOM    665  HA  ASN A  46      75.757 -24.061  29.054  1.00 99.99           H  
ATOM    666  HB2 ASN A  46      75.176 -22.909  26.323  1.00 99.99           H  
ATOM    667  HB3 ASN A  46      75.897 -21.995  27.644  1.00 99.99           H  
ATOM    668  N   GLY A  47      72.684 -23.899  28.700  1.00  0.00           N  
ATOM    669  CA  GLY A  47      71.452 -23.306  29.174  1.00  0.00           C  
ATOM    670  C   GLY A  47      70.239 -23.791  28.419  1.00  0.00           C  
ATOM    671  O   GLY A  47      70.162 -24.940  27.990  1.00  0.00           O  
ATOM    672  H   GLY A  47      72.677 -24.804  28.339  1.00 99.99           H  
ATOM    673  HA2 GLY A  47      71.318 -23.530  30.216  1.00 99.99           H  
ATOM    674  HA3 GLY A  47      71.520 -22.234  29.059  1.00 99.99           H  
ATOM    675  N   PHE A  48      69.289 -22.900  28.270  1.00  0.00           N  
ATOM    676  CA  PHE A  48      68.054 -23.188  27.573  1.00  0.00           C  
ATOM    677  C   PHE A  48      67.793 -22.134  26.507  1.00  0.00           C  
ATOM    678  O   PHE A  48      67.805 -20.934  26.797  1.00  0.00           O  
ATOM    679  CB  PHE A  48      66.885 -23.190  28.552  1.00  0.00           C  
ATOM    680  CG  PHE A  48      66.769 -24.424  29.396  1.00  0.00           C  
ATOM    681  CD1 PHE A  48      67.434 -24.526  30.607  1.00  0.00           C  
ATOM    682  CD2 PHE A  48      65.973 -25.471  28.985  1.00  0.00           C  
ATOM    683  CE1 PHE A  48      67.303 -25.657  31.388  1.00  0.00           C  
ATOM    684  CE2 PHE A  48      65.838 -26.606  29.755  1.00  0.00           C  
ATOM    685  CZ  PHE A  48      66.501 -26.700  30.958  1.00  0.00           C  
ATOM    686  H   PHE A  48      69.425 -22.015  28.647  1.00 99.99           H  
ATOM    687  HA  PHE A  48      68.135 -24.156  27.111  1.00 99.99           H  
ATOM    688  HB2 PHE A  48      66.986 -22.357  29.207  1.00 99.99           H  
ATOM    689  HB3 PHE A  48      65.972 -23.082  28.003  1.00 99.99           H  
ATOM    690  HD1 PHE A  48      68.061 -23.711  30.940  1.00 99.99           H  
ATOM    691  HD2 PHE A  48      65.456 -25.395  28.048  1.00 99.99           H  
ATOM    692  HE1 PHE A  48      67.824 -25.728  32.331  1.00 99.99           H  
ATOM    693  HE2 PHE A  48      65.211 -27.418  29.416  1.00 99.99           H  
ATOM    694  HZ  PHE A  48      66.390 -27.584  31.563  1.00 99.99           H  
ATOM    695  N   SER A  49      67.531 -22.577  25.283  1.00  0.00           N  
ATOM    696  CA  SER A  49      67.234 -21.655  24.202  1.00  0.00           C  
ATOM    697  C   SER A  49      65.773 -21.771  23.831  1.00  0.00           C  
ATOM    698  O   SER A  49      65.287 -22.837  23.457  1.00  0.00           O  
ATOM    699  CB  SER A  49      68.107 -21.899  22.982  1.00  0.00           C  
ATOM    700  OG  SER A  49      68.930 -23.041  23.151  1.00  0.00           O  
ATOM    701  H   SER A  49      67.513 -23.537  25.111  1.00 99.99           H  
ATOM    702  HA  SER A  49      67.416 -20.654  24.569  1.00 99.99           H  
ATOM    703  HB2 SER A  49      67.479 -22.041  22.120  1.00 99.99           H  
ATOM    704  HB3 SER A  49      68.732 -21.034  22.827  1.00 99.99           H  
ATOM    705  HG  SER A  49      69.110 -23.436  22.296  1.00 99.99           H  
ATOM    706  N   VAL A  50      65.079 -20.668  23.959  1.00  0.00           N  
ATOM    707  CA  VAL A  50      63.657 -20.624  23.667  1.00  0.00           C  
ATOM    708  C   VAL A  50      63.355 -19.637  22.549  1.00  0.00           C  
ATOM    709  O   VAL A  50      64.063 -18.647  22.378  1.00  0.00           O  
ATOM    710  CB  VAL A  50      62.842 -20.220  24.915  1.00  0.00           C  
ATOM    711  CG1 VAL A  50      61.449 -20.821  24.859  1.00  0.00           C  
ATOM    712  CG2 VAL A  50      63.557 -20.641  26.194  1.00  0.00           C  
ATOM    713  H   VAL A  50      65.537 -19.861  24.269  1.00 99.99           H  
ATOM    714  HA  VAL A  50      63.344 -21.617  23.368  1.00 99.99           H  
ATOM    715  HB  VAL A  50      62.744 -19.145  24.923  1.00 99.99           H  
ATOM    716  N   GLU A  51      62.295 -19.910  21.797  1.00  0.00           N  
ATOM    717  CA  GLU A  51      61.889 -19.041  20.700  1.00  0.00           C  
ATOM    718  C   GLU A  51      60.384 -19.122  20.498  1.00  0.00           C  
ATOM    719  O   GLU A  51      59.830 -20.200  20.282  1.00  0.00           O  
ATOM    720  CB  GLU A  51      62.626 -19.418  19.415  1.00  0.00           C  
ATOM    721  CG  GLU A  51      62.183 -18.631  18.190  1.00  0.00           C  
ATOM    722  CD  GLU A  51      62.424 -19.386  16.897  1.00  0.00           C  
ATOM    723  OE1 GLU A  51      61.839 -20.476  16.730  1.00  0.00           O  
ATOM    724  OE2 GLU A  51      63.197 -18.888  16.053  1.00  0.00           O  
ATOM    725  H   GLU A  51      61.767 -20.713  21.990  1.00 99.99           H  
ATOM    726  HA  GLU A  51      62.143 -18.026  20.967  1.00 99.99           H  
ATOM    727  HB2 GLU A  51      63.682 -19.249  19.561  1.00 99.99           H  
ATOM    728  HB3 GLU A  51      62.463 -20.461  19.223  1.00 99.99           H  
ATOM    729  HG2 GLU A  51      61.128 -18.420  18.273  1.00 99.99           H  
ATOM    730  HG3 GLU A  51      62.735 -17.703  18.155  1.00 99.99           H  
ATOM    731  N   ALA A  52      59.726 -17.975  20.581  1.00  0.00           N  
ATOM    732  CA  ALA A  52      58.280 -17.911  20.420  1.00  0.00           C  
ATOM    733  C   ALA A  52      57.899 -17.361  19.052  1.00  0.00           C  
ATOM    734  O   ALA A  52      58.643 -16.581  18.456  1.00  0.00           O  
ATOM    735  CB  ALA A  52      57.665 -17.060  21.521  1.00  0.00           C  
ATOM    736  H   ALA A  52      60.227 -17.153  20.762  1.00 99.99           H  
ATOM    737  HA  ALA A  52      57.891 -18.915  20.514  1.00 99.99           H  
ATOM    738  HB1 ALA A  52      57.709 -17.597  22.457  1.00 99.99           H  
ATOM    739  HB2 ALA A  52      56.636 -16.844  21.276  1.00 99.99           H  
ATOM    740  HB3 ALA A  52      58.217 -16.136  21.610  1.00 99.99           H  
ATOM    741  N   SER A  53      56.733 -17.775  18.562  1.00  0.00           N  
ATOM    742  CA  SER A  53      56.246 -17.324  17.267  1.00  0.00           C  
ATOM    743  C   SER A  53      54.721 -17.341  17.222  1.00  0.00           C  
ATOM    744  O   SER A  53      54.102 -18.394  17.078  1.00  0.00           O  
ATOM    745  CB  SER A  53      56.808 -18.199  16.148  1.00  0.00           C  
ATOM    746  OG  SER A  53      58.193 -18.433  16.329  1.00  0.00           O  
ATOM    747  H   SER A  53      56.188 -18.394  19.087  1.00 99.99           H  
ATOM    748  HA  SER A  53      56.586 -16.310  17.123  1.00 99.99           H  
ATOM    749  HB2 SER A  53      56.292 -19.146  16.142  1.00 99.99           H  
ATOM    750  HB3 SER A  53      56.660 -17.702  15.201  1.00 99.99           H  
ATOM    751  HG  SER A  53      58.325 -18.999  17.094  1.00 99.99           H  
ATOM    752  N   ILE A  54      54.127 -16.159  17.339  1.00  0.00           N  
ATOM    753  CA  ILE A  54      52.674 -16.018  17.305  1.00  0.00           C  
ATOM    754  C   ILE A  54      52.260 -15.112  16.149  1.00  0.00           C  
ATOM    755  O   ILE A  54      53.111 -14.542  15.471  1.00  0.00           O  
ATOM    756  CB  ILE A  54      52.127 -15.442  18.633  1.00  0.00           C  
ATOM    757  CG1 ILE A  54      52.909 -16.003  19.827  1.00  0.00           C  
ATOM    758  CG2 ILE A  54      50.643 -15.752  18.774  1.00  0.00           C  
ATOM    759  CD1 ILE A  54      52.368 -15.567  21.176  1.00  0.00           C  
ATOM    760  H   ILE A  54      54.681 -15.359  17.444  1.00 99.99           H  
ATOM    761  HA  ILE A  54      52.243 -16.997  17.155  1.00 99.99           H  
ATOM    762  HB  ILE A  54      52.241 -14.370  18.607  1.00 99.99           H  
ATOM    763  N   GLY A  55      50.958 -14.977  15.928  1.00  0.00           N  
ATOM    764  CA  GLY A  55      50.473 -14.135  14.862  1.00  0.00           C  
ATOM    765  C   GLY A  55      49.531 -13.076  15.368  1.00  0.00           C  
ATOM    766  O   GLY A  55      48.808 -13.281  16.342  1.00  0.00           O  
ATOM    767  H   GLY A  55      50.320 -15.448  16.492  1.00 99.99           H  
ATOM    768  HA2 GLY A  55      51.307 -13.656  14.384  1.00 99.99           H  
ATOM    769  HA3 GLY A  55      49.963 -14.736  14.135  1.00 99.99           H  
ATOM    770  N   THR A  56      49.538 -11.946  14.698  1.00  0.00           N  
ATOM    771  CA  THR A  56      48.674 -10.834  15.070  1.00  0.00           C  
ATOM    772  C   THR A  56      48.214 -10.068  13.838  1.00  0.00           C  
ATOM    773  O   THR A  56      49.009  -9.815  12.932  1.00  0.00           O  
ATOM    774  CB  THR A  56      49.384  -9.860  16.018  1.00  0.00           C  
ATOM    775  OG1 THR A  56      49.837  -8.708  15.312  1.00  0.00           O  
ATOM    776  CG2 THR A  56      50.559 -10.472  16.748  1.00  0.00           C  
ATOM    777  H   THR A  56      50.135 -11.864  13.933  1.00 99.99           H  
ATOM    778  HA  THR A  56      47.822 -11.244  15.573  1.00 99.99           H  
ATOM    779  HB  THR A  56      48.675  -9.531  16.764  1.00 99.99           H  
ATOM    780  HG1 THR A  56      50.797  -8.697  15.290  1.00 99.99           H  
ATOM    781  N   PRO A  57      46.938  -9.653  13.789  1.00  0.00           N  
ATOM    782  CA  PRO A  57      46.432  -8.881  12.660  1.00  0.00           C  
ATOM    783  C   PRO A  57      47.307  -7.661  12.378  1.00  0.00           C  
ATOM    784  O   PRO A  57      47.232  -7.068  11.302  1.00  0.00           O  
ATOM    785  CB  PRO A  57      45.041  -8.429  13.109  1.00  0.00           C  
ATOM    786  CG  PRO A  57      44.644  -9.366  14.197  1.00  0.00           C  
ATOM    787  CD  PRO A  57      45.910  -9.875  14.826  1.00  0.00           C  
ATOM    788  HA  PRO A  57      46.351  -9.485  11.766  1.00 99.99           H  
ATOM    789  HB2 PRO A  57      45.092  -7.411  13.468  1.00 99.99           H  
ATOM    790  HB3 PRO A  57      44.357  -8.485  12.275  1.00 99.99           H  
ATOM    791  HG2 PRO A  57      44.058  -8.840  14.931  1.00 99.99           H  
ATOM    792  HG3 PRO A  57      44.077 -10.186  13.784  1.00 99.99           H  
ATOM    793  HD2 PRO A  57      46.134  -9.318  15.725  1.00 99.99           H  
ATOM    794  HD3 PRO A  57      45.806 -10.927  15.051  1.00 99.99           H  
ATOM    795  N   LEU A  58      48.128  -7.279  13.361  1.00  0.00           N  
ATOM    796  CA  LEU A  58      48.999  -6.118  13.214  1.00  0.00           C  
ATOM    797  C   LEU A  58      50.415  -6.534  12.820  1.00  0.00           C  
ATOM    798  O   LEU A  58      51.172  -5.738  12.263  1.00  0.00           O  
ATOM    799  CB  LEU A  58      49.030  -5.312  14.517  1.00  0.00           C  
ATOM    800  CG  LEU A  58      47.814  -5.494  15.433  1.00  0.00           C  
ATOM    801  CD1 LEU A  58      47.976  -4.673  16.703  1.00  0.00           C  
ATOM    802  CD2 LEU A  58      46.529  -5.109  14.708  1.00  0.00           C  
ATOM    803  H   LEU A  58      48.139  -7.778  14.203  1.00 99.99           H  
ATOM    804  HA  LEU A  58      48.591  -5.499  12.431  1.00 99.99           H  
ATOM    805  HB2 LEU A  58      49.914  -5.596  15.068  1.00 99.99           H  
ATOM    806  HB3 LEU A  58      49.107  -4.264  14.264  1.00 99.99           H  
ATOM    807  HG  LEU A  58      47.740  -6.534  15.716  1.00 99.99           H  
ATOM    808  N   GLY A  59      50.766  -7.782  13.109  1.00  0.00           N  
ATOM    809  CA  GLY A  59      52.088  -8.279  12.774  1.00  0.00           C  
ATOM    810  C   GLY A  59      52.457  -9.528  13.549  1.00  0.00           C  
ATOM    811  O   GLY A  59      52.286  -9.583  14.766  1.00  0.00           O  
ATOM    812  H   GLY A  59      50.123  -8.372  13.550  1.00 99.99           H  
ATOM    813  HA2 GLY A  59      52.116  -8.505  11.724  1.00 99.99           H  
ATOM    814  HA3 GLY A  59      52.817  -7.512  12.979  1.00 99.99           H  
ATOM    815  N   ASN A  60      52.962 -10.532  12.838  1.00  0.00           N  
ATOM    816  CA  ASN A  60      53.355 -11.791  13.456  1.00  0.00           C  
ATOM    817  C   ASN A  60      54.343 -11.566  14.596  1.00  0.00           C  
ATOM    818  O   ASN A  60      55.275 -10.772  14.476  1.00  0.00           O  
ATOM    819  CB  ASN A  60      53.986 -12.713  12.414  1.00  0.00           C  
ATOM    820  CG  ASN A  60      53.164 -12.809  11.144  1.00  0.00           C  
ATOM    821  OD1 ASN A  60      52.103 -12.196  11.029  1.00  0.00           O  
ATOM    822  ND2 ASN A  60      53.652 -13.580  10.179  1.00  0.00           N  
ATOM    823  H   ASN A  60      53.072 -10.422  11.872  1.00 99.99           H  
ATOM    824  HA  ASN A  60      52.466 -12.261  13.847  1.00 99.99           H  
ATOM    825  HB2 ASN A  60      54.965 -12.340  12.158  1.00 99.99           H  
ATOM    826  HB3 ASN A  60      54.082 -13.701  12.833  1.00 99.99           H  
ATOM    827  N   LEU A  61      54.140 -12.284  15.696  1.00  0.00           N  
ATOM    828  CA  LEU A  61      55.023 -12.178  16.849  1.00  0.00           C  
ATOM    829  C   LEU A  61      56.109 -13.241  16.789  1.00  0.00           C  
ATOM    830  O   LEU A  61      55.851 -14.382  16.412  1.00  0.00           O  
ATOM    831  CB  LEU A  61      54.247 -12.350  18.156  1.00  0.00           C  
ATOM    832  CG  LEU A  61      53.231 -11.255  18.481  1.00  0.00           C  
ATOM    833  CD1 LEU A  61      51.928 -11.874  18.966  1.00  0.00           C  
ATOM    834  CD2 LEU A  61      53.787 -10.307  19.534  1.00  0.00           C  
ATOM    835  H   LEU A  61      53.387 -12.909  15.727  1.00 99.99           H  
ATOM    836  HA  LEU A  61      55.483 -11.202  16.832  1.00 99.99           H  
ATOM    837  HB2 LEU A  61      53.725 -13.294  18.111  1.00 99.99           H  
ATOM    838  HB3 LEU A  61      54.962 -12.396  18.962  1.00 99.99           H  
ATOM    839  HG  LEU A  61      53.020 -10.684  17.588  1.00 99.99           H  
ATOM    840  N   LEU A  62      57.316 -12.865  17.185  1.00  0.00           N  
ATOM    841  CA  LEU A  62      58.438 -13.788  17.202  1.00  0.00           C  
ATOM    842  C   LEU A  62      59.442 -13.361  18.259  1.00  0.00           C  
ATOM    843  O   LEU A  62      59.559 -12.178  18.577  1.00  0.00           O  
ATOM    844  CB  LEU A  62      59.123 -13.857  15.837  1.00  0.00           C  
ATOM    845  CG  LEU A  62      58.184 -14.001  14.637  1.00  0.00           C  
ATOM    846  CD1 LEU A  62      58.923 -13.712  13.340  1.00  0.00           C  
ATOM    847  CD2 LEU A  62      57.576 -15.397  14.606  1.00  0.00           C  
ATOM    848  H   LEU A  62      57.454 -11.948  17.492  1.00 99.99           H  
ATOM    849  HA  LEU A  62      58.058 -14.764  17.455  1.00 99.99           H  
ATOM    850  HB2 LEU A  62      59.708 -12.960  15.709  1.00 99.99           H  
ATOM    851  HB3 LEU A  62      59.796 -14.701  15.840  1.00 99.99           H  
ATOM    852  HG  LEU A  62      57.379 -13.287  14.728  1.00 99.99           H  
ATOM    853  N   ALA A  63      60.158 -14.327  18.801  1.00  0.00           N  
ATOM    854  CA  ALA A  63      61.152 -14.053  19.827  1.00  0.00           C  
ATOM    855  C   ALA A  63      62.057 -15.253  20.042  1.00  0.00           C  
ATOM    856  O   ALA A  63      61.737 -16.367  19.628  1.00  0.00           O  
ATOM    857  CB  ALA A  63      60.475 -13.657  21.130  1.00  0.00           C  
ATOM    858  H   ALA A  63      60.015 -15.247  18.503  1.00 99.99           H  
ATOM    859  HA  ALA A  63      61.751 -13.218  19.493  1.00 99.99           H  
ATOM    860  HB1 ALA A  63      59.510 -14.136  21.193  1.00 99.99           H  
ATOM    861  HB2 ALA A  63      60.349 -12.585  21.158  1.00 99.99           H  
ATOM    862  HB3 ALA A  63      61.089 -13.970  21.964  1.00 99.99           H  
ATOM    863  N   SER A  64      63.190 -15.020  20.691  1.00  0.00           N  
ATOM    864  CA  SER A  64      64.148 -16.086  20.961  1.00  0.00           C  
ATOM    865  C   SER A  64      65.186 -15.634  21.984  1.00  0.00           C  
ATOM    866  O   SER A  64      65.724 -14.532  21.890  1.00  0.00           O  
ATOM    867  CB  SER A  64      64.839 -16.518  19.668  1.00  0.00           C  
ATOM    868  OG  SER A  64      64.775 -15.497  18.688  1.00  0.00           O  
ATOM    869  H   SER A  64      63.386 -14.107  20.998  1.00 99.99           H  
ATOM    870  HA  SER A  64      63.602 -16.923  21.363  1.00 99.99           H  
ATOM    871  HB2 SER A  64      65.877 -16.738  19.871  1.00 99.99           H  
ATOM    872  HB3 SER A  64      64.353 -17.403  19.281  1.00 99.99           H  
ATOM    873  HG  SER A  64      65.528 -14.909  18.787  1.00 99.99           H  
ATOM    874  N   ALA A  65      65.465 -16.492  22.963  1.00  0.00           N  
ATOM    875  CA  ALA A  65      66.438 -16.169  23.999  1.00  0.00           C  
ATOM    876  C   ALA A  65      67.156 -17.419  24.501  1.00  0.00           C  
ATOM    877  O   ALA A  65      66.663 -18.536  24.351  1.00  0.00           O  
ATOM    878  CB  ALA A  65      65.757 -15.452  25.155  1.00  0.00           C  
ATOM    879  H   ALA A  65      65.004 -17.355  22.990  1.00 99.99           H  
ATOM    880  HA  ALA A  65      67.167 -15.497  23.571  1.00 99.99           H  
ATOM    881  HB1 ALA A  65      66.261 -15.696  26.078  1.00 99.99           H  
ATOM    882  HB2 ALA A  65      64.726 -15.763  25.214  1.00 99.99           H  
ATOM    883  HB3 ALA A  65      65.802 -14.385  24.992  1.00 99.99           H  
ATOM    884  N   THR A  66      68.324 -17.214  25.102  1.00  0.00           N  
ATOM    885  CA  THR A  66      69.123 -18.312  25.636  1.00  0.00           C  
ATOM    886  C   THR A  66      69.589 -17.989  27.051  1.00  0.00           C  
ATOM    887  O   THR A  66      70.119 -16.907  27.301  1.00  0.00           O  
ATOM    888  CB  THR A  66      70.334 -18.573  24.738  1.00  0.00           C  
ATOM    889  OG1 THR A  66      69.925 -18.879  23.417  1.00  0.00           O  
ATOM    890  CG2 THR A  66      71.209 -19.708  25.225  1.00  0.00           C  
ATOM    891  H   THR A  66      68.659 -16.297  25.191  1.00 99.99           H  
ATOM    892  HA  THR A  66      68.504 -19.195  25.662  1.00 99.99           H  
ATOM    893  HB  THR A  66      70.942 -17.679  24.705  1.00 99.99           H  
ATOM    894  HG1 THR A  66      70.174 -18.159  22.830  1.00 99.99           H  
ATOM    895  N   SER A  67      69.394 -18.924  27.977  1.00  0.00           N  
ATOM    896  CA  SER A  67      69.803 -18.706  29.358  1.00  0.00           C  
ATOM    897  C   SER A  67      69.765 -20.001  30.155  1.00  0.00           C  
ATOM    898  O   SER A  67      69.076 -20.948  29.785  1.00  0.00           O  
ATOM    899  CB  SER A  67      68.891 -17.674  30.020  1.00  0.00           C  
ATOM    900  OG  SER A  67      69.612 -16.511  30.386  1.00  0.00           O  
ATOM    901  H   SER A  67      68.967 -19.770  27.734  1.00 99.99           H  
ATOM    902  HA  SER A  67      70.814 -18.327  29.351  1.00 99.99           H  
ATOM    903  HB2 SER A  67      68.108 -17.396  29.332  1.00 99.99           H  
ATOM    904  HB3 SER A  67      68.450 -18.104  30.902  1.00 99.99           H  
ATOM    905  HG  SER A  67      70.155 -16.225  29.648  1.00 99.99           H  
ATOM    906  N   ASP A  68      70.493 -20.025  31.263  1.00  0.00           N  
ATOM    907  CA  ASP A  68      70.527 -21.197  32.123  1.00  0.00           C  
ATOM    908  C   ASP A  68      69.278 -21.264  33.001  1.00  0.00           C  
ATOM    909  O   ASP A  68      69.150 -22.153  33.843  1.00  0.00           O  
ATOM    910  CB  ASP A  68      71.781 -21.176  33.001  1.00  0.00           C  
ATOM    911  CG  ASP A  68      72.396 -22.551  33.165  1.00  0.00           C  
ATOM    912  OD1 ASP A  68      71.648 -23.548  33.085  1.00  0.00           O  
ATOM    913  OD2 ASP A  68      73.624 -22.632  33.373  1.00  0.00           O  
ATOM    914  H   ASP A  68      71.007 -19.229  31.517  1.00 99.99           H  
ATOM    915  HA  ASP A  68      70.556 -22.072  31.492  1.00 99.99           H  
ATOM    916  HB2 ASP A  68      72.516 -20.525  32.551  1.00 99.99           H  
ATOM    917  HB3 ASP A  68      71.522 -20.797  33.979  1.00 99.99           H  
ATOM    918  N   ASP A  69      68.356 -20.319  32.801  1.00  0.00           N  
ATOM    919  CA  ASP A  69      67.126 -20.283  33.578  1.00  0.00           C  
ATOM    920  C   ASP A  69      65.906 -20.480  32.681  1.00  0.00           C  
ATOM    921  O   ASP A  69      65.416 -19.540  32.061  1.00  0.00           O  
ATOM    922  CB  ASP A  69      67.019 -18.959  34.334  1.00  0.00           C  
ATOM    923  CG  ASP A  69      67.790 -18.975  35.640  1.00  0.00           C  
ATOM    924  OD1 ASP A  69      68.819 -19.680  35.713  1.00  0.00           O  
ATOM    925  OD2 ASP A  69      67.366 -18.282  36.588  1.00  0.00           O  
ATOM    926  H   ASP A  69      68.506 -19.633  32.118  1.00 99.99           H  
ATOM    927  HA  ASP A  69      67.164 -21.093  34.293  1.00 99.99           H  
ATOM    928  HB2 ASP A  69      67.412 -18.167  33.714  1.00 99.99           H  
ATOM    929  HB3 ASP A  69      65.981 -18.760  34.552  1.00 99.99           H  
ATOM    930  N   MET A  70      65.440 -21.720  32.621  1.00  0.00           N  
ATOM    931  CA  MET A  70      64.287 -22.104  31.810  1.00  0.00           C  
ATOM    932  C   MET A  70      63.171 -21.055  31.812  1.00  0.00           C  
ATOM    933  O   MET A  70      62.905 -20.408  30.792  1.00  0.00           O  
ATOM    934  CB  MET A  70      63.742 -23.434  32.334  1.00  0.00           C  
ATOM    935  CG  MET A  70      63.986 -24.605  31.397  1.00  0.00           C  
ATOM    936  SD  MET A  70      62.470 -25.465  30.943  1.00  0.00           S  
ATOM    937  CE  MET A  70      61.885 -24.415  29.617  1.00  0.00           C  
ATOM    938  H   MET A  70      65.895 -22.416  33.134  1.00 99.99           H  
ATOM    939  HA  MET A  70      64.623 -22.245  30.800  1.00 99.99           H  
ATOM    940  HB2 MET A  70      64.219 -23.655  33.278  1.00 99.99           H  
ATOM    941  HB3 MET A  70      62.678 -23.340  32.495  1.00 99.99           H  
ATOM    942  HG2 MET A  70      64.456 -24.235  30.497  1.00 99.99           H  
ATOM    943  HG3 MET A  70      64.649 -25.306  31.884  1.00 99.99           H  
ATOM    944  HE1 MET A  70      61.662 -25.022  28.753  1.00 99.99           H  
ATOM    945  HE2 MET A  70      62.654 -23.697  29.364  1.00 99.99           H  
ATOM    946  HE3 MET A  70      60.990 -23.896  29.937  1.00 99.99           H  
ATOM    947  N   TYR A  71      62.500 -20.911  32.950  1.00  0.00           N  
ATOM    948  CA  TYR A  71      61.392 -19.973  33.058  1.00  0.00           C  
ATOM    949  C   TYR A  71      61.840 -18.537  32.875  1.00  0.00           C  
ATOM    950  O   TYR A  71      61.043 -17.695  32.475  1.00  0.00           O  
ATOM    951  CB  TYR A  71      60.642 -20.174  34.373  1.00  0.00           C  
ATOM    952  CG  TYR A  71      59.501 -21.157  34.222  1.00  0.00           C  
ATOM    953  CD1 TYR A  71      59.508 -22.089  33.187  1.00  0.00           C  
ATOM    954  CD2 TYR A  71      58.417 -21.150  35.087  1.00  0.00           C  
ATOM    955  CE1 TYR A  71      58.478 -22.983  33.020  1.00  0.00           C  
ATOM    956  CE2 TYR A  71      57.375 -22.047  34.928  1.00  0.00           C  
ATOM    957  CZ  TYR A  71      57.410 -22.962  33.893  1.00  0.00           C  
ATOM    958  OH  TYR A  71      56.378 -23.857  33.735  1.00  0.00           O  
ATOM    959  H   TYR A  71      62.742 -21.461  33.721  1.00 99.99           H  
ATOM    960  HA  TYR A  71      60.709 -20.201  32.253  1.00 99.99           H  
ATOM    961  HB2 TYR A  71      61.324 -20.558  35.120  1.00 99.99           H  
ATOM    962  HB3 TYR A  71      60.234 -19.231  34.703  1.00 99.99           H  
ATOM    963  HD1 TYR A  71      60.345 -22.108  32.506  1.00 99.99           H  
ATOM    964  HD2 TYR A  71      58.389 -20.432  35.894  1.00 99.99           H  
ATOM    965  HE1 TYR A  71      58.509 -23.688  32.199  1.00 99.99           H  
ATOM    966  HE2 TYR A  71      56.540 -22.030  35.610  1.00 99.99           H  
ATOM    967  HH  TYR A  71      56.730 -24.712  33.483  1.00 99.99           H  
ATOM    968  N   LYS A  72      63.118 -18.265  33.112  1.00  0.00           N  
ATOM    969  CA  LYS A  72      63.642 -16.924  32.906  1.00  0.00           C  
ATOM    970  C   LYS A  72      63.810 -16.694  31.411  1.00  0.00           C  
ATOM    971  O   LYS A  72      63.508 -15.623  30.894  1.00  0.00           O  
ATOM    972  CB  LYS A  72      64.966 -16.739  33.600  1.00  0.00           C  
ATOM    973  CG  LYS A  72      65.452 -15.300  33.622  1.00  0.00           C  
ATOM    974  CD  LYS A  72      65.101 -14.612  34.933  1.00  0.00           C  
ATOM    975  CE  LYS A  72      64.559 -13.212  34.700  1.00  0.00           C  
ATOM    976  NZ  LYS A  72      65.642 -12.235  34.396  1.00  0.00           N  
ATOM    977  H   LYS A  72      63.723 -18.983  33.394  1.00 99.99           H  
ATOM    978  HA  LYS A  72      62.937 -16.220  33.305  1.00 99.99           H  
ATOM    979  HB2 LYS A  72      64.876 -17.085  34.615  1.00 99.99           H  
ATOM    980  HB3 LYS A  72      65.681 -17.330  33.082  1.00 99.99           H  
ATOM    981  HG2 LYS A  72      66.525 -15.291  33.499  1.00 99.99           H  
ATOM    982  HG3 LYS A  72      64.990 -14.762  32.807  1.00 99.99           H  
ATOM    983  HD2 LYS A  72      64.352 -15.197  35.445  1.00 99.99           H  
ATOM    984  HD3 LYS A  72      65.989 -14.549  35.543  1.00 99.99           H  
ATOM    985  HE2 LYS A  72      63.869 -13.240  33.869  1.00 99.99           H  
ATOM    986  HE3 LYS A  72      64.035 -12.891  35.590  1.00 99.99           H  
ATOM    987  HZ1 LYS A  72      65.569 -11.413  35.029  1.00 99.99           H  
ATOM    988  HZ2 LYS A  72      65.564 -11.909  33.412  1.00 99.99           H  
ATOM    989  HZ3 LYS A  72      66.573 -12.681  34.529  1.00 99.99           H  
ATOM    990  N   ALA A  73      64.259 -17.740  30.709  1.00  0.00           N  
ATOM    991  CA  ALA A  73      64.415 -17.673  29.265  1.00  0.00           C  
ATOM    992  C   ALA A  73      63.042 -17.422  28.679  1.00  0.00           C  
ATOM    993  O   ALA A  73      62.849 -16.537  27.844  1.00  0.00           O  
ATOM    994  CB  ALA A  73      65.014 -18.963  28.722  1.00  0.00           C  
ATOM    995  H   ALA A  73      64.452 -18.577  31.171  1.00 99.99           H  
ATOM    996  HA  ALA A  73      65.069 -16.848  29.024  1.00 99.99           H  
ATOM    997  HB1 ALA A  73      65.769 -19.324  29.405  1.00 99.99           H  
ATOM    998  HB2 ALA A  73      65.461 -18.774  27.758  1.00 99.99           H  
ATOM    999  HB3 ALA A  73      64.238 -19.706  28.620  1.00 99.99           H  
ATOM   1000  N   ILE A  74      62.073 -18.169  29.204  1.00  0.00           N  
ATOM   1001  CA  ILE A  74      60.686 -17.994  28.821  1.00  0.00           C  
ATOM   1002  C   ILE A  74      60.274 -16.599  29.269  1.00  0.00           C  
ATOM   1003  O   ILE A  74      59.585 -15.861  28.559  1.00  0.00           O  
ATOM   1004  CB  ILE A  74      59.801 -19.076  29.488  1.00  0.00           C  
ATOM   1005  CG1 ILE A  74      59.814 -20.342  28.640  1.00  0.00           C  
ATOM   1006  CG2 ILE A  74      58.371 -18.597  29.702  1.00  0.00           C  
ATOM   1007  CD1 ILE A  74      60.373 -21.548  29.355  1.00  0.00           C  
ATOM   1008  H   ILE A  74      62.296 -18.812  29.910  1.00 99.99           H  
ATOM   1009  HA  ILE A  74      60.604 -18.074  27.746  1.00 99.99           H  
ATOM   1010  HB  ILE A  74      60.222 -19.302  30.456  1.00 99.99           H  
ATOM   1011  N   ASN A  75      60.774 -16.244  30.451  1.00  0.00           N  
ATOM   1012  CA  ASN A  75      60.563 -14.944  31.045  1.00  0.00           C  
ATOM   1013  C   ASN A  75      61.036 -13.867  30.079  1.00  0.00           C  
ATOM   1014  O   ASN A  75      60.396 -12.829  29.909  1.00  0.00           O  
ATOM   1015  CB  ASN A  75      61.342 -14.899  32.360  1.00  0.00           C  
ATOM   1016  CG  ASN A  75      60.654 -14.083  33.419  1.00  0.00           C  
ATOM   1017  OD1 ASN A  75      60.661 -12.852  33.387  1.00  0.00           O  
ATOM   1018  ND2 ASN A  75      60.053 -14.778  34.369  1.00  0.00           N  
ATOM   1019  H   ASN A  75      61.341 -16.881  30.932  1.00 99.99           H  
ATOM   1020  HA  ASN A  75      59.508 -14.820  31.241  1.00 99.99           H  
ATOM   1021  HB2 ASN A  75      61.431 -15.908  32.731  1.00 99.99           H  
ATOM   1022  HB3 ASN A  75      62.337 -14.502  32.197  1.00 99.99           H  
ATOM   1023  N   GLU A  76      62.161 -14.151  29.427  1.00  0.00           N  
ATOM   1024  CA  GLU A  76      62.739 -13.245  28.445  1.00  0.00           C  
ATOM   1025  C   GLU A  76      61.883 -13.228  27.176  1.00  0.00           C  
ATOM   1026  O   GLU A  76      61.443 -12.165  26.725  1.00  0.00           O  
ATOM   1027  CB  GLU A  76      64.170 -13.679  28.113  1.00  0.00           C  
ATOM   1028  CG  GLU A  76      65.215 -12.620  28.422  1.00  0.00           C  
ATOM   1029  CD  GLU A  76      66.173 -13.047  29.517  1.00  0.00           C  
ATOM   1030  OE1 GLU A  76      65.736 -13.760  30.445  1.00  0.00           O  
ATOM   1031  OE2 GLU A  76      67.362 -12.668  29.445  1.00  0.00           O  
ATOM   1032  H   GLU A  76      62.606 -15.006  29.607  1.00 99.99           H  
ATOM   1033  HA  GLU A  76      62.757 -12.254  28.871  1.00 99.99           H  
ATOM   1034  HB2 GLU A  76      64.406 -14.567  28.687  1.00 99.99           H  
ATOM   1035  HB3 GLU A  76      64.229 -13.918  27.061  1.00 99.99           H  
ATOM   1036  HG2 GLU A  76      65.782 -12.421  27.526  1.00 99.99           H  
ATOM   1037  HG3 GLU A  76      64.711 -11.718  28.736  1.00 99.99           H  
ATOM   1038  N   VAL A  77      61.636 -14.416  26.612  1.00  0.00           N  
ATOM   1039  CA  VAL A  77      60.820 -14.535  25.409  1.00  0.00           C  
ATOM   1040  C   VAL A  77      59.545 -13.729  25.548  1.00  0.00           C  
ATOM   1041  O   VAL A  77      59.226 -12.894  24.701  1.00  0.00           O  
ATOM   1042  CB  VAL A  77      60.432 -15.992  25.121  1.00  0.00           C  
ATOM   1043  CG1 VAL A  77      59.780 -16.113  23.751  1.00  0.00           C  
ATOM   1044  CG2 VAL A  77      61.644 -16.892  25.223  1.00  0.00           C  
ATOM   1045  H   VAL A  77      62.004 -15.225  27.018  1.00 99.99           H  
ATOM   1046  HA  VAL A  77      61.393 -14.164  24.575  1.00 99.99           H  
ATOM   1047  HB  VAL A  77      59.714 -16.307  25.864  1.00 99.99           H  
ATOM   1048  N   GLU A  78      58.819 -13.982  26.632  1.00  0.00           N  
ATOM   1049  CA  GLU A  78      57.580 -13.269  26.883  1.00  0.00           C  
ATOM   1050  C   GLU A  78      57.832 -11.770  26.858  1.00  0.00           C  
ATOM   1051  O   GLU A  78      56.990 -10.993  26.407  1.00  0.00           O  
ATOM   1052  CB  GLU A  78      56.978 -13.688  28.226  1.00  0.00           C  
ATOM   1053  CG  GLU A  78      55.466 -13.846  28.192  1.00  0.00           C  
ATOM   1054  CD  GLU A  78      54.738 -12.591  28.632  1.00  0.00           C  
ATOM   1055  OE1 GLU A  78      55.352 -11.765  29.340  1.00  0.00           O  
ATOM   1056  OE2 GLU A  78      53.554 -12.434  28.267  1.00  0.00           O  
ATOM   1057  H   GLU A  78      59.128 -14.655  27.274  1.00 99.99           H  
ATOM   1058  HA  GLU A  78      56.896 -13.521  26.089  1.00 99.99           H  
ATOM   1059  HB2 GLU A  78      57.410 -14.632  28.523  1.00 99.99           H  
ATOM   1060  HB3 GLU A  78      57.223 -12.941  28.967  1.00 99.99           H  
ATOM   1061  HG2 GLU A  78      55.166 -14.083  27.183  1.00 99.99           H  
ATOM   1062  HG3 GLU A  78      55.188 -14.657  28.849  1.00 99.99           H  
ATOM   1063  N   GLU A  79      59.013 -11.375  27.321  1.00  0.00           N  
ATOM   1064  CA  GLU A  79      59.391  -9.973  27.325  1.00  0.00           C  
ATOM   1065  C   GLU A  79      59.509  -9.483  25.892  1.00  0.00           C  
ATOM   1066  O   GLU A  79      59.011  -8.410  25.548  1.00  0.00           O  
ATOM   1067  CB  GLU A  79      60.710  -9.770  28.075  1.00  0.00           C  
ATOM   1068  CG  GLU A  79      60.606  -8.790  29.232  1.00  0.00           C  
ATOM   1069  CD  GLU A  79      61.106  -7.405  28.870  1.00  0.00           C  
ATOM   1070  OE1 GLU A  79      60.348  -6.651  28.227  1.00  0.00           O  
ATOM   1071  OE2 GLU A  79      62.256  -7.077  29.229  1.00  0.00           O  
ATOM   1072  H   GLU A  79      59.649 -12.045  27.648  1.00 99.99           H  
ATOM   1073  HA  GLU A  79      58.605  -9.420  27.818  1.00 99.99           H  
ATOM   1074  HB2 GLU A  79      61.037 -10.722  28.466  1.00 99.99           H  
ATOM   1075  HB3 GLU A  79      61.453  -9.400  27.382  1.00 99.99           H  
ATOM   1076  HG2 GLU A  79      59.573  -8.715  29.533  1.00 99.99           H  
ATOM   1077  HG3 GLU A  79      61.194  -9.165  30.057  1.00 99.99           H  
ATOM   1078  N   LYS A  80      60.143 -10.293  25.045  1.00  0.00           N  
ATOM   1079  CA  LYS A  80      60.284  -9.940  23.640  1.00  0.00           C  
ATOM   1080  C   LYS A  80      58.905  -9.875  23.002  1.00  0.00           C  
ATOM   1081  O   LYS A  80      58.500  -8.842  22.469  1.00  0.00           O  
ATOM   1082  CB  LYS A  80      61.155 -10.962  22.903  1.00  0.00           C  
ATOM   1083  CG  LYS A  80      62.631 -10.873  23.256  1.00  0.00           C  
ATOM   1084  CD  LYS A  80      63.417 -10.131  22.186  1.00  0.00           C  
ATOM   1085  CE  LYS A  80      64.482  -9.235  22.797  1.00  0.00           C  
ATOM   1086  NZ  LYS A  80      65.502  -8.822  21.794  1.00  0.00           N  
ATOM   1087  H   LYS A  80      60.498 -11.149  25.369  1.00 99.99           H  
ATOM   1088  HA  LYS A  80      60.746  -8.966  23.581  1.00 99.99           H  
ATOM   1089  HB2 LYS A  80      60.808 -11.954  23.141  1.00 99.99           H  
ATOM   1090  HB3 LYS A  80      61.051 -10.804  21.841  1.00 99.99           H  
ATOM   1091  HG2 LYS A  80      62.735 -10.348  24.194  1.00 99.99           H  
ATOM   1092  HG3 LYS A  80      63.028 -11.873  23.355  1.00 99.99           H  
ATOM   1093  HD2 LYS A  80      63.895 -10.852  21.540  1.00 99.99           H  
ATOM   1094  HD3 LYS A  80      62.735  -9.525  21.609  1.00 99.99           H  
ATOM   1095  HE2 LYS A  80      64.005  -8.352  23.196  1.00 99.99           H  
ATOM   1096  HE3 LYS A  80      64.971  -9.772  23.597  1.00 99.99           H  
ATOM   1097  HZ1 LYS A  80      66.329  -9.451  21.846  1.00 99.99           H  
ATOM   1098  HZ2 LYS A  80      65.812  -7.847  21.980  1.00 99.99           H  
ATOM   1099  HZ3 LYS A  80      65.102  -8.869  20.836  1.00 99.99           H  
ATOM   1100  N   LEU A  81      58.177 -10.987  23.086  1.00  0.00           N  
ATOM   1101  CA  LEU A  81      56.826 -11.071  22.539  1.00  0.00           C  
ATOM   1102  C   LEU A  81      55.988  -9.876  23.000  1.00  0.00           C  
ATOM   1103  O   LEU A  81      55.322  -9.227  22.191  1.00  0.00           O  
ATOM   1104  CB  LEU A  81      56.163 -12.396  22.956  1.00  0.00           C  
ATOM   1105  CG  LEU A  81      55.977 -13.433  21.840  1.00  0.00           C  
ATOM   1106  CD1 LEU A  81      54.613 -13.270  21.188  1.00  0.00           C  
ATOM   1107  CD2 LEU A  81      57.084 -13.333  20.799  1.00  0.00           C  
ATOM   1108  H   LEU A  81      58.557 -11.769  23.540  1.00 99.99           H  
ATOM   1109  HA  LEU A  81      56.906 -11.038  21.463  1.00 99.99           H  
ATOM   1110  HB2 LEU A  81      56.766 -12.846  23.730  1.00 99.99           H  
ATOM   1111  HB3 LEU A  81      55.189 -12.174  23.367  1.00 99.99           H  
ATOM   1112  HG  LEU A  81      56.017 -14.422  22.274  1.00 99.99           H  
ATOM   1113  N   GLU A  82      56.038  -9.573  24.300  1.00  0.00           N  
ATOM   1114  CA  GLU A  82      55.293  -8.439  24.835  1.00  0.00           C  
ATOM   1115  C   GLU A  82      55.804  -7.144  24.218  1.00  0.00           C  
ATOM   1116  O   GLU A  82      55.022  -6.313  23.746  1.00  0.00           O  
ATOM   1117  CB  GLU A  82      55.428  -8.385  26.357  1.00  0.00           C  
ATOM   1118  CG  GLU A  82      54.298  -7.637  27.042  1.00  0.00           C  
ATOM   1119  CD  GLU A  82      54.774  -6.372  27.733  1.00  0.00           C  
ATOM   1120  OE1 GLU A  82      55.258  -5.459  27.031  1.00  0.00           O  
ATOM   1121  OE2 GLU A  82      54.662  -6.294  28.974  1.00  0.00           O  
ATOM   1122  H   GLU A  82      56.600 -10.110  24.906  1.00 99.99           H  
ATOM   1123  HA  GLU A  82      54.252  -8.564  24.573  1.00 99.99           H  
ATOM   1124  HB2 GLU A  82      55.446  -9.394  26.737  1.00 99.99           H  
ATOM   1125  HB3 GLU A  82      56.359  -7.899  26.606  1.00 99.99           H  
ATOM   1126  HG2 GLU A  82      53.559  -7.368  26.303  1.00 99.99           H  
ATOM   1127  HG3 GLU A  82      53.850  -8.285  27.780  1.00 99.99           H  
ATOM   1128  N   ARG A  83      57.124  -6.985  24.211  1.00  0.00           N  
ATOM   1129  CA  ARG A  83      57.748  -5.799  23.634  1.00  0.00           C  
ATOM   1130  C   ARG A  83      57.246  -5.581  22.211  1.00  0.00           C  
ATOM   1131  O   ARG A  83      56.822  -4.480  21.848  1.00  0.00           O  
ATOM   1132  CB  ARG A  83      59.272  -5.941  23.639  1.00  0.00           C  
ATOM   1133  CG  ARG A  83      60.002  -4.674  23.224  1.00  0.00           C  
ATOM   1134  CD  ARG A  83      60.355  -4.693  21.746  1.00  0.00           C  
ATOM   1135  NE  ARG A  83      61.102  -3.503  21.346  1.00  0.00           N  
ATOM   1136  CZ  ARG A  83      62.403  -3.333  21.572  1.00  0.00           C  
ATOM   1137  NH1 ARG A  83      63.104  -4.275  22.191  1.00  0.00           N  
ATOM   1138  NH2 ARG A  83      63.006  -2.220  21.176  1.00  0.00           N  
ATOM   1139  H   ARG A  83      57.691  -7.687  24.591  1.00 99.99           H  
ATOM   1140  HA  ARG A  83      57.470  -4.948  24.238  1.00 99.99           H  
ATOM   1141  HB2 ARG A  83      59.594  -6.208  24.634  1.00 99.99           H  
ATOM   1142  HB3 ARG A  83      59.550  -6.730  22.955  1.00 99.99           H  
ATOM   1143  HG2 ARG A  83      59.369  -3.823  23.422  1.00 99.99           H  
ATOM   1144  HG3 ARG A  83      60.912  -4.591  23.801  1.00 99.99           H  
ATOM   1145  HD2 ARG A  83      60.955  -5.567  21.542  1.00 99.99           H  
ATOM   1146  HD3 ARG A  83      59.441  -4.742  21.172  1.00 99.99           H  
ATOM   1147  HE  ARG A  83      60.609  -2.791  20.887  1.00 99.99           H  
ATOM   1148 HH11 ARG A  83      62.657  -5.116  22.492  1.00 99.99           H  
ATOM   1149 HH12 ARG A  83      64.081  -4.142  22.357  1.00 99.99           H  
ATOM   1150 HH21 ARG A  83      62.482  -1.508  20.709  1.00 99.99           H  
ATOM   1151 HH22 ARG A  83      63.982  -2.094  21.344  1.00 99.99           H  
ATOM   1152  N   GLN A  84      57.271  -6.646  21.413  1.00  0.00           N  
ATOM   1153  CA  GLN A  84      56.793  -6.569  20.037  1.00  0.00           C  
ATOM   1154  C   GLN A  84      55.315  -6.209  20.044  1.00  0.00           C  
ATOM   1155  O   GLN A  84      54.884  -5.306  19.329  1.00  0.00           O  
ATOM   1156  CB  GLN A  84      57.015  -7.885  19.280  1.00  0.00           C  
ATOM   1157  CG  GLN A  84      58.154  -8.735  19.821  1.00  0.00           C  
ATOM   1158  CD  GLN A  84      58.968  -9.400  18.729  1.00  0.00           C  
ATOM   1159  OE1 GLN A  84      58.493  -9.584  17.608  1.00  0.00           O  
ATOM   1160  NE2 GLN A  84      60.203  -9.761  19.054  1.00  0.00           N  
ATOM   1161  H   GLN A  84      57.599  -7.500  21.764  1.00 99.99           H  
ATOM   1162  HA  GLN A  84      57.339  -5.778  19.542  1.00 99.99           H  
ATOM   1163  HB2 GLN A  84      56.111  -8.466  19.328  1.00 99.99           H  
ATOM   1164  HB3 GLN A  84      57.229  -7.657  18.246  1.00 99.99           H  
ATOM   1165  HG2 GLN A  84      58.810  -8.105  20.398  1.00 99.99           H  
ATOM   1166  HG3 GLN A  84      57.741  -9.502  20.459  1.00 99.99           H  
ATOM   1167  N   LEU A  85      54.545  -6.905  20.886  1.00  0.00           N  
ATOM   1168  CA  LEU A  85      53.113  -6.639  21.016  1.00  0.00           C  
ATOM   1169  C   LEU A  85      52.887  -5.139  21.182  1.00  0.00           C  
ATOM   1170  O   LEU A  85      52.174  -4.500  20.393  1.00  0.00           O  
ATOM   1171  CB  LEU A  85      52.547  -7.396  22.227  1.00  0.00           C  
ATOM   1172  CG  LEU A  85      51.907  -8.752  21.912  1.00  0.00           C  
ATOM   1173  CD1 LEU A  85      52.449  -9.825  22.845  1.00  0.00           C  
ATOM   1174  CD2 LEU A  85      50.389  -8.673  22.023  1.00  0.00           C  
ATOM   1175  H   LEU A  85      54.955  -7.597  21.447  1.00 99.99           H  
ATOM   1176  HA  LEU A  85      52.620  -6.978  20.117  1.00 99.99           H  
ATOM   1177  HB2 LEU A  85      53.354  -7.556  22.927  1.00 99.99           H  
ATOM   1178  HB3 LEU A  85      51.805  -6.773  22.701  1.00 99.99           H  
ATOM   1179  HG  LEU A  85      52.154  -9.033  20.900  1.00 99.99           H  
ATOM   1180  N   ASN A  86      53.536  -4.576  22.201  1.00  0.00           N  
ATOM   1181  CA  ASN A  86      53.449  -3.148  22.464  1.00  0.00           C  
ATOM   1182  C   ASN A  86      53.911  -2.384  21.233  1.00  0.00           C  
ATOM   1183  O   ASN A  86      53.372  -1.327  20.904  1.00  0.00           O  
ATOM   1184  CB  ASN A  86      54.301  -2.771  23.679  1.00  0.00           C  
ATOM   1185  CG  ASN A  86      53.835  -1.487  24.336  1.00  0.00           C  
ATOM   1186  OD1 ASN A  86      52.637  -1.218  24.422  1.00  0.00           O  
ATOM   1187  ND2 ASN A  86      54.783  -0.684  24.804  1.00  0.00           N  
ATOM   1188  H   ASN A  86      54.106  -5.133  22.772  1.00 99.99           H  
ATOM   1189  HA  ASN A  86      52.417  -2.903  22.657  1.00 99.99           H  
ATOM   1190  HB2 ASN A  86      54.248  -3.567  24.412  1.00 99.99           H  
ATOM   1191  HB3 ASN A  86      55.327  -2.644  23.368  1.00 99.99           H  
ATOM   1192  N   LYS A  87      54.893  -2.951  20.535  1.00  0.00           N  
ATOM   1193  CA  LYS A  87      55.404  -2.345  19.315  1.00  0.00           C  
ATOM   1194  C   LYS A  87      54.304  -2.305  18.270  1.00  0.00           C  
ATOM   1195  O   LYS A  87      54.111  -1.299  17.590  1.00  0.00           O  
ATOM   1196  CB  LYS A  87      56.586  -3.143  18.770  1.00  0.00           C  
ATOM   1197  CG  LYS A  87      57.791  -2.286  18.418  1.00  0.00           C  
ATOM   1198  CD  LYS A  87      57.867  -2.017  16.924  1.00  0.00           C  
ATOM   1199  CE  LYS A  87      58.989  -2.810  16.272  1.00  0.00           C  
ATOM   1200  NZ  LYS A  87      59.083  -2.541  14.811  1.00  0.00           N  
ATOM   1201  H   LYS A  87      55.262  -3.807  20.836  1.00 99.99           H  
ATOM   1202  HA  LYS A  87      55.719  -1.337  19.541  1.00 99.99           H  
ATOM   1203  HB2 LYS A  87      56.889  -3.867  19.512  1.00 99.99           H  
ATOM   1204  HB3 LYS A  87      56.267  -3.666  17.878  1.00 99.99           H  
ATOM   1205  HG2 LYS A  87      57.714  -1.344  18.939  1.00 99.99           H  
ATOM   1206  HG3 LYS A  87      58.689  -2.800  18.729  1.00 99.99           H  
ATOM   1207  HD2 LYS A  87      56.930  -2.299  16.467  1.00 99.99           H  
ATOM   1208  HD3 LYS A  87      58.046  -0.964  16.766  1.00 99.99           H  
ATOM   1209  HE2 LYS A  87      59.923  -2.538  16.740  1.00 99.99           H  
ATOM   1210  HE3 LYS A  87      58.804  -3.862  16.425  1.00 99.99           H  
ATOM   1211  HZ1 LYS A  87      58.141  -2.326  14.426  1.00 99.99           H  
ATOM   1212  HZ2 LYS A  87      59.465  -3.375  14.317  1.00 99.99           H  
ATOM   1213  HZ3 LYS A  87      59.712  -1.732  14.636  1.00 99.99           H  
ATOM   1214  N   LEU A  88      53.582  -3.416  18.148  1.00  0.00           N  
ATOM   1215  CA  LEU A  88      52.499  -3.511  17.186  1.00  0.00           C  
ATOM   1216  C   LEU A  88      51.460  -2.436  17.457  1.00  0.00           C  
ATOM   1217  O   LEU A  88      51.173  -1.602  16.599  1.00  0.00           O  
ATOM   1218  CB  LEU A  88      51.828  -4.890  17.242  1.00  0.00           C  
ATOM   1219  CG  LEU A  88      52.774  -6.091  17.289  1.00  0.00           C  
ATOM   1220  CD1 LEU A  88      52.001  -7.387  17.096  1.00  0.00           C  
ATOM   1221  CD2 LEU A  88      53.862  -5.957  16.236  1.00  0.00           C  
ATOM   1222  H   LEU A  88      53.785  -4.185  18.721  1.00 99.99           H  
ATOM   1223  HA  LEU A  88      52.919  -3.356  16.206  1.00 99.99           H  
ATOM   1224  HB2 LEU A  88      51.200  -4.923  18.120  1.00 99.99           H  
ATOM   1225  HB3 LEU A  88      51.200  -4.992  16.371  1.00 99.99           H  
ATOM   1226  HG  LEU A  88      53.247  -6.130  18.257  1.00 99.99           H  
ATOM   1227  N   GLN A  89      50.900  -2.458  18.662  1.00  0.00           N  
ATOM   1228  CA  GLN A  89      49.888  -1.473  19.041  1.00  0.00           C  
ATOM   1229  C   GLN A  89      50.473  -0.064  19.037  1.00  0.00           C  
ATOM   1230  O   GLN A  89      49.745   0.920  18.904  1.00  0.00           O  
ATOM   1231  CB  GLN A  89      49.302  -1.801  20.415  1.00  0.00           C  
ATOM   1232  CG  GLN A  89      48.719  -3.199  20.497  1.00  0.00           C  
ATOM   1233  CD  GLN A  89      49.435  -4.072  21.496  1.00  0.00           C  
ATOM   1234  OE1 GLN A  89      50.328  -3.621  22.214  1.00  0.00           O  
ATOM   1235  NE2 GLN A  89      49.042  -5.332  21.549  1.00  0.00           N  
ATOM   1236  H   GLN A  89      51.172  -3.150  19.304  1.00 99.99           H  
ATOM   1237  HA  GLN A  89      49.098  -1.519  18.306  1.00 99.99           H  
ATOM   1238  HB2 GLN A  89      50.078  -1.709  21.160  1.00 99.99           H  
ATOM   1239  HB3 GLN A  89      48.513  -1.095  20.640  1.00 99.99           H  
ATOM   1240  HG2 GLN A  89      47.684  -3.130  20.785  1.00 99.99           H  
ATOM   1241  HG3 GLN A  89      48.791  -3.663  19.525  1.00 99.99           H  
ATOM   1242  N   HIS A  90      51.794   0.028  19.170  1.00  0.00           N  
ATOM   1243  CA  HIS A  90      52.476   1.316  19.169  1.00  0.00           C  
ATOM   1244  C   HIS A  90      52.657   1.824  17.746  1.00  0.00           C  
ATOM   1245  O   HIS A  90      52.061   2.824  17.345  1.00  0.00           O  
ATOM   1246  CB  HIS A  90      53.846   1.193  19.833  1.00  0.00           C  
ATOM   1247  CG  HIS A  90      53.808   1.331  21.324  1.00  0.00           C  
ATOM   1248  ND1 HIS A  90      52.676   1.085  22.073  1.00  0.00           N  
ATOM   1249  CD2 HIS A  90      54.769   1.692  22.206  1.00  0.00           C  
ATOM   1250  CE1 HIS A  90      52.943   1.290  23.352  1.00  0.00           C  
ATOM   1251  NE2 HIS A  90      54.206   1.659  23.458  1.00  0.00           N  
ATOM   1252  H   HIS A  90      52.324  -0.791  19.264  1.00 99.99           H  
ATOM   1253  HA  HIS A  90      51.873   2.020  19.723  1.00 99.99           H  
ATOM   1254  HB2 HIS A  90      54.267   0.227  19.597  1.00 99.99           H  
ATOM   1255  HB3 HIS A  90      54.496   1.963  19.444  1.00 99.99           H  
ATOM   1256  HD1 HIS A  90      51.806   0.803  21.720  1.00 99.99           H  
ATOM   1257  HD2 HIS A  90      55.790   1.957  21.968  1.00 99.99           H  
ATOM   1258  HE1 HIS A  90      52.247   1.175  24.169  1.00 99.99           H  
ATOM   1259  HE2 HIS A  90      54.638   1.961  24.285  1.00 99.99           H  
ATOM   1260  N   LYS A  91      53.496   1.117  16.996  1.00  0.00           N  
ATOM   1261  CA  LYS A  91      53.792   1.460  15.613  1.00  0.00           C  
ATOM   1262  C   LYS A  91      54.102   2.946  15.453  1.00  0.00           C  
ATOM   1263  O   LYS A  91      54.173   3.688  16.433  1.00  0.00           O  
ATOM   1264  CB  LYS A  91      52.635   1.055  14.695  1.00  0.00           C  
ATOM   1265  CG  LYS A  91      51.360   1.850  14.927  1.00  0.00           C  
ATOM   1266  CD  LYS A  91      50.331   1.586  13.840  1.00  0.00           C  
ATOM   1267  CE  LYS A  91      50.224   2.758  12.877  1.00  0.00           C  
ATOM   1268  NZ  LYS A  91      49.612   3.954  13.521  1.00  0.00           N  
ATOM   1269  H   LYS A  91      53.933   0.335  17.388  1.00 99.99           H  
ATOM   1270  HA  LYS A  91      54.668   0.897  15.335  1.00 99.99           H  
ATOM   1271  HB2 LYS A  91      52.939   1.198  13.668  1.00 99.99           H  
ATOM   1272  HB3 LYS A  91      52.415   0.010  14.853  1.00 99.99           H  
ATOM   1273  HG2 LYS A  91      50.940   1.567  15.881  1.00 99.99           H  
ATOM   1274  HG3 LYS A  91      51.601   2.904  14.938  1.00 99.99           H  
ATOM   1275  HD2 LYS A  91      50.622   0.707  13.287  1.00 99.99           H  
ATOM   1276  HD3 LYS A  91      49.368   1.423  14.302  1.00 99.99           H  
ATOM   1277  HE2 LYS A  91      51.214   3.016  12.531  1.00 99.99           H  
ATOM   1278  HE3 LYS A  91      49.615   2.462  12.035  1.00 99.99           H  
ATOM   1279  HZ1 LYS A  91      48.704   3.697  13.957  1.00 99.99           H  
ATOM   1280  HZ2 LYS A  91      49.446   4.696  12.813  1.00 99.99           H  
ATOM   1281  HZ3 LYS A  91      50.246   4.327  14.257  1.00 99.99           H  
ATOM   1282  N   SER A  92      54.291   3.372  14.208  1.00  0.00           N  
ATOM   1283  CA  SER A  92      54.598   4.765  13.913  1.00  0.00           C  
ATOM   1284  C   SER A  92      53.434   5.674  14.294  1.00  0.00           C  
ATOM   1285  O   SER A  92      52.273   5.357  14.033  1.00  0.00           O  
ATOM   1286  CB  SER A  92      54.926   4.933  12.429  1.00  0.00           C  
ATOM   1287  OG  SER A  92      53.755   4.846  11.634  1.00  0.00           O  
ATOM   1288  H   SER A  92      54.226   2.730  13.470  1.00 99.99           H  
ATOM   1289  HA  SER A  92      55.463   5.044  14.497  1.00 99.99           H  
ATOM   1290  HB2 SER A  92      55.382   5.898  12.270  1.00 99.99           H  
ATOM   1291  HB3 SER A  92      55.611   4.155  12.124  1.00 99.99           H  
ATOM   1292  HG  SER A  92      53.992   4.575  10.744  1.00 99.99           H  
ATOM   1293  N   GLU A  93      53.755   6.807  14.910  1.00  0.00           N  
ATOM   1294  CA  GLU A  93      52.738   7.765  15.325  1.00  0.00           C  
ATOM   1295  C   GLU A  93      52.619   8.902  14.313  1.00  0.00           C  
ATOM   1296  O   GLU A  93      52.281  10.030  14.669  1.00  0.00           O  
ATOM   1297  CB  GLU A  93      53.073   8.329  16.707  1.00  0.00           C  
ATOM   1298  CG  GLU A  93      53.230   7.262  17.776  1.00  0.00           C  
ATOM   1299  CD  GLU A  93      52.696   7.702  19.124  1.00  0.00           C  
ATOM   1300  OE1 GLU A  93      51.471   7.587  19.344  1.00  0.00           O  
ATOM   1301  OE2 GLU A  93      53.500   8.164  19.961  1.00  0.00           O  
ATOM   1302  H   GLU A  93      54.698   7.003  15.089  1.00 99.99           H  
ATOM   1303  HA  GLU A  93      51.793   7.245  15.378  1.00 99.99           H  
ATOM   1304  HB2 GLU A  93      53.998   8.882  16.643  1.00 99.99           H  
ATOM   1305  HB3 GLU A  93      52.282   8.999  17.011  1.00 99.99           H  
ATOM   1306  HG2 GLU A  93      52.695   6.375  17.467  1.00 99.99           H  
ATOM   1307  HG3 GLU A  93      54.280   7.026  17.881  1.00 99.99           H  
ATOM   1308  N   SER A  94      52.900   8.593  13.051  1.00  0.00           N  
ATOM   1309  CA  SER A  94      52.825   9.586  11.986  1.00  0.00           C  
ATOM   1310  C   SER A  94      52.957   8.924  10.617  1.00  0.00           C  
ATOM   1311  O   SER A  94      53.889   9.209   9.864  1.00  0.00           O  
ATOM   1312  CB  SER A  94      53.920  10.641  12.167  1.00  0.00           C  
ATOM   1313  OG  SER A  94      53.440  11.754  12.900  1.00  0.00           O  
ATOM   1314  H   SER A  94      53.163   7.676  12.830  1.00 99.99           H  
ATOM   1315  HA  SER A  94      51.861  10.067  12.048  1.00 99.99           H  
ATOM   1316  HB2 SER A  94      54.751  10.206  12.701  1.00 99.99           H  
ATOM   1317  HB3 SER A  94      54.253  10.980  11.197  1.00 99.99           H  
ATOM   1318  HG  SER A  94      53.985  12.522  12.710  1.00 99.99           H  
ATOM   1319  N   ARG A  95      52.017   8.039  10.302  1.00  0.00           N  
ATOM   1320  CA  ARG A  95      52.029   7.335   9.025  1.00  0.00           C  
ATOM   1321  C   ARG A  95      51.742   8.297   7.875  1.00  0.00           C  
ATOM   1322  O   ARG A  95      50.654   8.287   7.299  1.00  0.00           O  
ATOM   1323  CB  ARG A  95      50.998   6.203   9.030  1.00  0.00           C  
ATOM   1324  CG  ARG A  95      51.332   5.071   8.074  1.00  0.00           C  
ATOM   1325  CD  ARG A  95      50.941   3.722   8.654  1.00  0.00           C  
ATOM   1326  NE  ARG A  95      51.341   2.614   7.785  1.00  0.00           N  
ATOM   1327  CZ  ARG A  95      51.447   1.353   8.196  1.00  0.00           C  
ATOM   1328  NH1 ARG A  95      51.180   1.032   9.456  1.00  0.00           N  
ATOM   1329  NH2 ARG A  95      51.816   0.407   7.342  1.00  0.00           N  
ATOM   1330  H   ARG A  95      51.301   7.855  10.945  1.00 99.99           H  
ATOM   1331  HA  ARG A  95      53.013   6.913   8.888  1.00 99.99           H  
ATOM   1332  HB2 ARG A  95      50.934   5.796  10.029  1.00 99.99           H  
ATOM   1333  HB3 ARG A  95      50.035   6.608   8.754  1.00 99.99           H  
ATOM   1334  HG2 ARG A  95      50.794   5.223   7.149  1.00 99.99           H  
ATOM   1335  HG3 ARG A  95      52.394   5.077   7.881  1.00 99.99           H  
ATOM   1336  HD2 ARG A  95      51.421   3.603   9.613  1.00 99.99           H  
ATOM   1337  HD3 ARG A  95      49.868   3.695   8.782  1.00 99.99           H  
ATOM   1338  HE  ARG A  95      51.543   2.823   6.851  1.00 99.99           H  
ATOM   1339 HH11 ARG A  95      50.901   1.740  10.105  1.00 99.99           H  
ATOM   1340 HH12 ARG A  95      51.260   0.082   9.756  1.00 99.99           H  
ATOM   1341 HH21 ARG A  95      52.017   0.644   6.391  1.00 99.99           H  
ATOM   1342 HH22 ARG A  95      51.896  -0.540   7.649  1.00 99.99           H  
ATOM   1343  N   ARG A  96      52.727   9.128   7.548  1.00  0.00           N  
ATOM   1344  CA  ARG A  96      52.585  10.101   6.468  1.00  0.00           C  
ATOM   1345  C   ARG A  96      51.540  11.156   6.822  1.00  0.00           C  
ATOM   1346  O   ARG A  96      51.879  12.288   7.163  1.00  0.00           O  
ATOM   1347  CB  ARG A  96      52.202   9.396   5.162  1.00  0.00           C  
ATOM   1348  CG  ARG A  96      53.315   9.397   4.125  1.00  0.00           C  
ATOM   1349  CD  ARG A  96      53.146  10.533   3.129  1.00  0.00           C  
ATOM   1350  NE  ARG A  96      53.524  10.133   1.775  1.00  0.00           N  
ATOM   1351  CZ  ARG A  96      53.150  10.788   0.677  1.00  0.00           C  
ATOM   1352  NH1 ARG A  96      52.391  11.872   0.768  1.00  0.00           N  
ATOM   1353  NH2 ARG A  96      53.538  10.356  -0.516  1.00  0.00           N  
ATOM   1354  H   ARG A  96      53.570   9.089   8.046  1.00 99.99           H  
ATOM   1355  HA  ARG A  96      53.539  10.588   6.337  1.00 99.99           H  
ATOM   1356  HB2 ARG A  96      51.944   8.372   5.381  1.00 99.99           H  
ATOM   1357  HB3 ARG A  96      51.343   9.893   4.736  1.00 99.99           H  
ATOM   1358  HG2 ARG A  96      54.263   9.510   4.628  1.00 99.99           H  
ATOM   1359  HG3 ARG A  96      53.297   8.457   3.593  1.00 99.99           H  
ATOM   1360  HD2 ARG A  96      52.112  10.843   3.127  1.00 99.99           H  
ATOM   1361  HD3 ARG A  96      53.768  11.360   3.437  1.00 99.99           H  
ATOM   1362  HE  ARG A  96      54.085   9.336   1.678  1.00 99.99           H  
ATOM   1363 HH11 ARG A  96      52.095  12.204   1.665  1.00 99.99           H  
ATOM   1364 HH12 ARG A  96      52.114  12.360  -0.060  1.00 99.99           H  
ATOM   1365 HH21 ARG A  96      54.111   9.540  -0.589  1.00 99.99           H  
ATOM   1366 HH22 ARG A  96      53.257  10.848  -1.341  1.00 99.99           H  
ATOM   1367  N   ALA A  97      50.269  10.774   6.739  1.00  0.00           N  
ATOM   1368  CA  ALA A  97      49.177  11.688   7.052  1.00  0.00           C  
ATOM   1369  C   ALA A  97      48.323  11.154   8.198  1.00  0.00           C  
ATOM   1370  O   ALA A  97      47.153  11.513   8.332  1.00  0.00           O  
ATOM   1371  CB  ALA A  97      48.318  11.923   5.818  1.00  0.00           C  
ATOM   1372  H   ALA A  97      50.062   9.857   6.462  1.00 99.99           H  
ATOM   1373  HA  ALA A  97      49.607  12.633   7.348  1.00 99.99           H  
ATOM   1374  HB1 ALA A  97      48.933  11.855   4.934  1.00 99.99           H  
ATOM   1375  HB2 ALA A  97      47.871  12.905   5.873  1.00 99.99           H  
ATOM   1376  HB3 ALA A  97      47.540  11.175   5.774  1.00 99.99           H  
ATOM   1377  N   ASP A  98      48.914  10.295   9.025  1.00  0.00           N  
ATOM   1378  CA  ASP A  98      48.207   9.714  10.162  1.00  0.00           C  
ATOM   1379  C   ASP A  98      46.925   9.017   9.713  1.00  0.00           C  
ATOM   1380  O   ASP A  98      46.558   9.068   8.539  1.00  0.00           O  
ATOM   1381  CB  ASP A  98      47.877  10.796  11.192  1.00  0.00           C  
ATOM   1382  CG  ASP A  98      47.997  10.294  12.617  1.00  0.00           C  
ATOM   1383  OD1 ASP A  98      47.219   9.392  12.996  1.00  0.00           O  
ATOM   1384  OD2 ASP A  98      48.868  10.800  13.354  1.00  0.00           O  
ATOM   1385  H   ASP A  98      49.849  10.047   8.869  1.00 99.99           H  
ATOM   1386  HA  ASP A  98      48.856   8.983  10.617  1.00 99.99           H  
ATOM   1387  HB2 ASP A  98      48.558  11.625  11.064  1.00 99.99           H  
ATOM   1388  HB3 ASP A  98      46.865  11.139  11.033  1.00 99.99           H  
ATOM   1389  N   GLU A  99      46.249   8.369  10.655  1.00  0.00           N  
ATOM   1390  CA  GLU A  99      45.008   7.663  10.359  1.00  0.00           C  
ATOM   1391  C   GLU A  99      43.807   8.375  10.979  1.00  0.00           C  
ATOM   1392  O   GLU A  99      42.671   8.187  10.544  1.00  0.00           O  
ATOM   1393  CB  GLU A  99      45.081   6.223  10.870  1.00  0.00           C  
ATOM   1394  CG  GLU A  99      44.073   5.292  10.216  1.00  0.00           C  
ATOM   1395  CD  GLU A  99      44.731   4.143   9.476  1.00  0.00           C  
ATOM   1396  OE1 GLU A  99      45.078   4.322   8.290  1.00  0.00           O  
ATOM   1397  OE2 GLU A  99      44.899   3.065  10.083  1.00  0.00           O  
ATOM   1398  H   GLU A  99      46.593   8.366  11.572  1.00 99.99           H  
ATOM   1399  HA  GLU A  99      44.884   7.646   9.286  1.00 99.99           H  
ATOM   1400  HB2 GLU A  99      46.072   5.837  10.682  1.00 99.99           H  
ATOM   1401  HB3 GLU A  99      44.901   6.223  11.935  1.00 99.99           H  
ATOM   1402  HG2 GLU A  99      43.428   4.885  10.980  1.00 99.99           H  
ATOM   1403  HG3 GLU A  99      43.480   5.861   9.514  1.00 99.99           H  
ATOM   1404  N   ARG A 100      44.065   9.188  12.001  1.00  0.00           N  
ATOM   1405  CA  ARG A 100      43.004   9.927  12.680  1.00  0.00           C  
ATOM   1406  C   ARG A 100      42.080   8.977  13.436  1.00  0.00           C  
ATOM   1407  O   ARG A 100      42.135   7.762  13.248  1.00  0.00           O  
ATOM   1408  CB  ARG A 100      42.197  10.752  11.675  1.00  0.00           C  
ATOM   1409  CG  ARG A 100      41.751  12.102  12.218  1.00  0.00           C  
ATOM   1410  CD  ARG A 100      42.458  13.249  11.512  1.00  0.00           C  
ATOM   1411  NE  ARG A 100      41.669  13.777  10.401  1.00  0.00           N  
ATOM   1412  CZ  ARG A 100      42.073  14.768   9.610  1.00  0.00           C  
ATOM   1413  NH1 ARG A 100      43.257  15.339   9.801  1.00  0.00           N  
ATOM   1414  NH2 ARG A 100      41.294  15.188   8.623  1.00  0.00           N  
ATOM   1415  H   ARG A 100      44.990   9.297  12.305  1.00 99.99           H  
ATOM   1416  HA  ARG A 100      43.469  10.594  13.389  1.00 99.99           H  
ATOM   1417  HB2 ARG A 100      42.802  10.922  10.797  1.00 99.99           H  
ATOM   1418  HB3 ARG A 100      41.316  10.194  11.394  1.00 99.99           H  
ATOM   1419  HG2 ARG A 100      40.688  12.204  12.070  1.00 99.99           H  
ATOM   1420  HG3 ARG A 100      41.977  12.147  13.273  1.00 99.99           H  
ATOM   1421  HD2 ARG A 100      42.633  14.041  12.225  1.00 99.99           H  
ATOM   1422  HD3 ARG A 100      43.405  12.893  11.132  1.00 99.99           H  
ATOM   1423  HE  ARG A 100      40.791  13.374  10.237  1.00 99.99           H  
ATOM   1424 HH11 ARG A 100      43.849  15.027  10.543  1.00 99.99           H  
ATOM   1425 HH12 ARG A 100      43.555  16.083   9.202  1.00 99.99           H  
ATOM   1426 HH21 ARG A 100      40.402  14.760   8.474  1.00 99.99           H  
ATOM   1427 HH22 ARG A 100      41.597  15.931   8.027  1.00 99.99           H  
ATOM   1428  N   LEU A 101      41.234   9.540  14.291  1.00  0.00           N  
ATOM   1429  CA  LEU A 101      40.298   8.744  15.076  1.00  0.00           C  
ATOM   1430  C   LEU A 101      38.857   9.031  14.664  1.00  0.00           C  
ATOM   1431  O   LEU A 101      37.961   9.106  15.507  1.00  0.00           O  
ATOM   1432  CB  LEU A 101      40.482   9.030  16.569  1.00  0.00           C  
ATOM   1433  CG  LEU A 101      40.395   7.804  17.478  1.00  0.00           C  
ATOM   1434  CD1 LEU A 101      41.391   7.914  18.622  1.00  0.00           C  
ATOM   1435  CD2 LEU A 101      38.981   7.638  18.016  1.00  0.00           C  
ATOM   1436  H   LEU A 101      41.238  10.514  14.398  1.00 99.99           H  
ATOM   1437  HA  LEU A 101      40.511   7.703  14.891  1.00 99.99           H  
ATOM   1438  HB2 LEU A 101      41.450   9.489  16.707  1.00 99.99           H  
ATOM   1439  HB3 LEU A 101      39.722   9.733  16.878  1.00 99.99           H  
ATOM   1440  HG  LEU A 101      40.642   6.921  16.906  1.00 99.99           H  
ATOM   1441  N   LYS A 102      38.639   9.190  13.363  1.00  0.00           N  
ATOM   1442  CA  LYS A 102      37.306   9.467  12.841  1.00  0.00           C  
ATOM   1443  C   LYS A 102      36.709   8.226  12.185  1.00  0.00           C  
ATOM   1444  O   LYS A 102      37.390   7.511  11.450  1.00  0.00           O  
ATOM   1445  CB  LYS A 102      37.358  10.616  11.831  1.00  0.00           C  
ATOM   1446  CG  LYS A 102      38.283  10.352  10.653  1.00  0.00           C  
ATOM   1447  CD  LYS A 102      37.709  10.904   9.356  1.00  0.00           C  
ATOM   1448  CE  LYS A 102      38.698  11.818   8.649  1.00  0.00           C  
ATOM   1449  NZ  LYS A 102      39.324  11.155   7.472  1.00  0.00           N  
ATOM   1450  H   LYS A 102      39.392   9.119  12.740  1.00 99.99           H  
ATOM   1451  HA  LYS A 102      36.679   9.758  13.670  1.00 99.99           H  
ATOM   1452  HB2 LYS A 102      36.364  10.790  11.449  1.00 99.99           H  
ATOM   1453  HB3 LYS A 102      37.701  11.508  12.336  1.00 99.99           H  
ATOM   1454  HG2 LYS A 102      39.236  10.823  10.843  1.00 99.99           H  
ATOM   1455  HG3 LYS A 102      38.422   9.286  10.549  1.00 99.99           H  
ATOM   1456  HD2 LYS A 102      37.466  10.079   8.703  1.00 99.99           H  
ATOM   1457  HD3 LYS A 102      36.811  11.462   9.580  1.00 99.99           H  
ATOM   1458  HE2 LYS A 102      38.175  12.702   8.316  1.00 99.99           H  
ATOM   1459  HE3 LYS A 102      39.471  12.100   9.347  1.00 99.99           H  
ATOM   1460  HZ1 LYS A 102      39.426  10.135   7.649  1.00 99.99           H  
ATOM   1461  HZ2 LYS A 102      40.265  11.560   7.293  1.00 99.99           H  
ATOM   1462  HZ3 LYS A 102      38.732  11.293   6.628  1.00 99.99           H  
ATOM   1463  N   ASP A 103      35.432   7.975  12.459  1.00  0.00           N  
ATOM   1464  CA  ASP A 103      34.744   6.818  11.896  1.00  0.00           C  
ATOM   1465  C   ASP A 103      33.232   6.964  12.037  1.00  0.00           C  
ATOM   1466  O   ASP A 103      32.735   7.407  13.072  1.00  0.00           O  
ATOM   1467  CB  ASP A 103      35.211   5.536  12.586  1.00  0.00           C  
ATOM   1468  CG  ASP A 103      35.196   5.655  14.098  1.00  0.00           C  
ATOM   1469  OD1 ASP A 103      36.207   6.116  14.667  1.00  0.00           O  
ATOM   1470  OD2 ASP A 103      34.173   5.286  14.713  1.00  0.00           O  
ATOM   1471  H   ASP A 103      34.942   8.581  13.053  1.00 99.99           H  
ATOM   1472  HA  ASP A 103      34.992   6.763  10.847  1.00 99.99           H  
ATOM   1473  HB2 ASP A 103      34.558   4.723  12.303  1.00 99.99           H  
ATOM   1474  HB3 ASP A 103      36.218   5.310  12.270  1.00 99.99           H  
ATOM   1475  N   SER A 104      32.507   6.588  10.988  1.00  0.00           N  
ATOM   1476  CA  SER A 104      31.050   6.676  10.995  1.00  0.00           C  
ATOM   1477  C   SER A 104      30.467   6.143   9.690  1.00  0.00           C  
ATOM   1478  O   SER A 104      29.439   5.466   9.689  1.00  0.00           O  
ATOM   1479  CB  SER A 104      30.607   8.125  11.208  1.00  0.00           C  
ATOM   1480  OG  SER A 104      31.345   9.012  10.387  1.00  0.00           O  
ATOM   1481  H   SER A 104      32.961   6.243  10.192  1.00 99.99           H  
ATOM   1482  HA  SER A 104      30.685   6.073  11.813  1.00 99.99           H  
ATOM   1483  HB2 SER A 104      29.559   8.218  10.965  1.00 99.99           H  
ATOM   1484  HB3 SER A 104      30.762   8.398  12.242  1.00 99.99           H  
ATOM   1485  HG  SER A 104      31.201   8.788   9.464  1.00 99.99           H  
ATOM   1486  N   PHE A 105      31.131   6.452   8.582  1.00  0.00           N  
ATOM   1487  CA  PHE A 105      30.678   6.003   7.269  1.00  0.00           C  
ATOM   1488  C   PHE A 105      31.834   5.972   6.274  1.00  0.00           C  
ATOM   1489  O   PHE A 105      31.983   5.017   5.511  1.00  0.00           O  
ATOM   1490  CB  PHE A 105      29.568   6.918   6.750  1.00  0.00           C  
ATOM   1491  CG  PHE A 105      28.188   6.459   7.124  1.00  0.00           C  
ATOM   1492  CD1 PHE A 105      27.792   5.152   6.889  1.00  0.00           C  
ATOM   1493  CD2 PHE A 105      27.287   7.333   7.708  1.00  0.00           C  
ATOM   1494  CE1 PHE A 105      26.523   4.725   7.232  1.00  0.00           C  
ATOM   1495  CE2 PHE A 105      26.016   6.913   8.053  1.00  0.00           C  
ATOM   1496  CZ  PHE A 105      25.634   5.607   7.814  1.00  0.00           C  
ATOM   1497  H   PHE A 105      31.944   6.994   8.647  1.00 99.99           H  
ATOM   1498  HA  PHE A 105      30.285   5.004   7.379  1.00 99.99           H  
ATOM   1499  HB2 PHE A 105      29.709   7.909   7.155  1.00 99.99           H  
ATOM   1500  HB3 PHE A 105      29.623   6.965   5.672  1.00 99.99           H  
ATOM   1501  HD1 PHE A 105      28.487   4.462   6.434  1.00 99.99           H  
ATOM   1502  HD2 PHE A 105      27.584   8.354   7.895  1.00 99.99           H  
ATOM   1503  HE1 PHE A 105      26.227   3.705   7.043  1.00 99.99           H  
ATOM   1504  HE2 PHE A 105      25.322   7.604   8.509  1.00 99.99           H  
ATOM   1505  HZ  PHE A 105      24.641   5.277   8.082  1.00 99.99           H  
ATOM   1506  N   GLU A 106      32.649   7.022   6.285  1.00  0.00           N  
ATOM   1507  CA  GLU A 106      33.791   7.117   5.383  1.00  0.00           C  
ATOM   1508  C   GLU A 106      33.332   7.165   3.929  1.00  0.00           C  
ATOM   1509  O   GLU A 106      33.520   6.210   3.175  1.00  0.00           O  
ATOM   1510  CB  GLU A 106      34.738   5.933   5.597  1.00  0.00           C  
ATOM   1511  CG  GLU A 106      35.863   6.222   6.577  1.00  0.00           C  
ATOM   1512  CD  GLU A 106      36.700   4.996   6.882  1.00  0.00           C  
ATOM   1513  OE1 GLU A 106      37.329   4.458   5.946  1.00  0.00           O  
ATOM   1514  OE2 GLU A 106      36.728   4.572   8.056  1.00  0.00           O  
ATOM   1515  H   GLU A 106      32.477   7.754   6.915  1.00 99.99           H  
ATOM   1516  HA  GLU A 106      34.318   8.032   5.611  1.00 99.99           H  
ATOM   1517  HB2 GLU A 106      34.169   5.095   5.973  1.00 99.99           H  
ATOM   1518  HB3 GLU A 106      35.177   5.661   4.647  1.00 99.99           H  
ATOM   1519  HG2 GLU A 106      36.504   6.981   6.154  1.00 99.99           H  
ATOM   1520  HG3 GLU A 106      35.435   6.587   7.498  1.00 99.99           H  
ATOM   1521  N   ASN A 107      32.730   8.285   3.542  1.00  0.00           N  
ATOM   1522  CA  ASN A 107      32.243   8.460   2.179  1.00  0.00           C  
ATOM   1523  C   ASN A 107      31.652   9.853   1.987  1.00  0.00           C  
ATOM   1524  O   ASN A 107      31.998  10.551   1.037  1.00 99.99           O  
ATOM   1525  CB  ASN A 107      31.193   7.398   1.848  1.00  0.00           C  
ATOM   1526  CG  ASN A 107      30.146   7.262   2.935  1.00  0.00           C  
ATOM   1527  OD1 ASN A 107      29.968   8.160   3.757  1.00  0.00           O  
ATOM   1528  ND2 ASN A 107      29.447   6.133   2.945  1.00  0.00           N  
ATOM   1529  H   ASN A 107      32.610   9.011   4.188  1.00 99.99           H  
ATOM   1530  HA  ASN A 107      33.083   8.345   1.509  1.00 99.99           H  
ATOM   1531  HB2 ASN A 107      30.696   7.667   0.927  1.00 99.99           H  
ATOM   1532  HB3 ASN A 107      31.683   6.444   1.722  1.00 99.99           H  
TER    1533      ASN A 107                                                      
END
MOLECULE T0446_9_70.pdb
ATOM      5  N   GLY     9      65.185 -29.612  12.805  1.00 60.87           N  
ATOM      6  CA  GLY     9      64.461 -29.375  14.061  1.00 59.52           C  
ATOM      7  C   GLY     9      62.984 -29.191  13.759  1.00 57.77           C  
ATOM      8  O   GLY     9      62.643 -28.728  12.672  1.00 57.61           O  
ATOM      9  N   ASN    10      62.114 -29.563  14.705  1.00 55.20           N  
ATOM     10  CA  ASN    10      60.651 -29.470  14.527  1.00 53.29           C  
ATOM     11  C   ASN    10      60.014 -28.305  15.312  1.00 52.05           C  
ATOM     12  O   ASN    10      60.425 -27.996  16.430  1.00 52.82           O  
ATOM     13  CB  ASN    10      59.961 -30.783  14.932  1.00 52.26           C  
ATOM     14  CG  ASN    10      60.368 -31.975  14.048  1.00 53.17           C  
ATOM     15  OD1 ASN    10      60.525 -31.847  12.834  1.00 52.31           O  
ATOM     16  ND2 ASN    10      60.516 -33.139  14.663  1.00 52.23           N  
ATOM     17  N   ALA    11      59.012 -27.666  14.710  1.00 49.77           N  
ATOM     18  CA  ALA    11      58.198 -26.655  15.395  1.00 48.15           C  
ATOM     19  C   ALA    11      56.922 -27.335  15.898  1.00 45.50           C  
ATOM     20  O   ALA    11      56.339 -28.180  15.200  1.00 46.35           O  
ATOM     21  CB  ALA    11      57.864 -25.490  14.458  1.00 45.83           C  
ATOM     22  N   ALA    12      56.518 -26.982  17.115  1.00 42.12           N  
ATOM     23  CA  ALA    12      55.301 -27.490  17.736  1.00 40.00           C  
ATOM     24  C   ALA    12      54.252 -26.375  17.772  1.00 39.55           C  
ATOM     25  O   ALA    12      54.566 -25.236  18.129  1.00 35.98           O  
ATOM     26  CB  ALA    12      55.605 -27.961  19.142  1.00 38.33           C  
ATOM     27  N   GLU    13      53.023 -26.699  17.394  1.00 40.63           N  
ATOM     28  CA  GLU    13      51.913 -25.749  17.482  1.00 42.72           C  
ATOM     29  C   GLU    13      51.523 -25.518  18.950  1.00 42.02           C  
ATOM     30  O   GLU    13      51.506 -26.452  19.742  1.00 42.03           O  
ATOM     31  CB  GLU    13      50.717 -26.254  16.671  1.00 42.21           C  
ATOM     32  CG  GLU    13      49.860 -25.143  16.068  1.00 47.11           C  
ATOM     33  CD  GLU    13      48.729 -25.671  15.169  1.00 49.32           C  
ATOM     34  OE1 GLU    13      48.950 -26.674  14.442  1.00 52.36           O  
ATOM     35  OE2 GLU    13      47.614 -25.083  15.200  1.00 59.57           O  
ATOM     36  N   VAL    14      51.230 -24.268  19.301  1.00 40.63           N  
ATOM     37  CA  VAL    14      50.890 -23.890  20.675  1.00 37.77           C  
ATOM     38  C   VAL    14      49.390 -23.660  20.813  1.00 36.42           C  
ATOM     39  O   VAL    14      48.761 -23.060  19.946  1.00 36.60           O  
ATOM     40  CB  VAL    14      51.644 -22.622  21.110  1.00 38.62           C  
ATOM     41  CG1 VAL    14      51.241 -22.212  22.518  1.00 33.88           C  
ATOM     42  CG2 VAL    14      53.152 -22.846  21.033  1.00 35.50           C  
ATOM     43  N   ASN    15      48.812 -24.153  21.900  1.00 34.06           N  
ATOM     44  CA  ASN    15      47.407 -23.957  22.158  1.00 33.88           C  
ATOM     45  C   ASN    15      47.083 -22.479  22.334  1.00 33.04           C  
ATOM     46  O   ASN    15      47.602 -21.847  23.255  1.00 32.42           O  
ATOM     47  CB  ASN    15      46.994 -24.708  23.418  1.00 35.53           C  
ATOM     48  CG  ASN    15      45.527 -24.540  23.733  1.00 37.44           C  
ATOM     49  OD1 ASN    15      45.120 -23.520  24.243  1.00 37.41           O  
ATOM     50  ND2 ASN    15      44.729 -25.556  23.423  1.00 43.93           N  
ATOM     51  N   LEU    16      46.207 -21.958  21.483  1.00 31.24           N  
ATOM     52  CA  LEU    16      45.931 -20.529  21.429  1.00 33.01           C  
ATOM     53  C   LEU    16      45.005 -20.054  22.541  1.00 32.25           C  
ATOM     54  O   LEU    16      44.996 -18.881  22.845  1.00 32.26           O  
ATOM     55  CB  LEU    16      45.328 -20.148  20.075  1.00 34.27           C  
ATOM     56  CG  LEU    16      46.190 -20.305  18.818  1.00 34.50           C  
ATOM     57  CD1 LEU    16      45.443 -19.732  17.607  1.00 34.58           C  
ATOM     58  CD2 LEU    16      47.568 -19.650  18.992  1.00 33.93           C  
ATOM     59  N   ASP    17      44.236 -20.949  23.151  1.00 32.19           N  
ATOM     60  CA  ASP    17      43.394 -20.576  24.279  1.00 32.48           C  
ATOM     61  C   ASP    17      44.231 -20.282  25.513  1.00 32.65           C  
ATOM     62  O   ASP    17      44.037 -19.269  26.162  1.00 30.88           O  
ATOM     63  CB  ASP    17      42.382 -21.674  24.594  1.00 35.60           C  
ATOM     64  CG  ASP    17      41.437 -21.931  23.455  1.00 35.99           C  
ATOM     65  OD1 ASP    17      40.779 -20.971  23.006  1.00 38.81           O  
ATOM     66  OD2 ASP    17      41.367 -23.092  23.003  1.00 50.00           O  
ATOM     67  N   GLU    18      45.170 -21.165  25.820  1.00 32.04           N  
ATOM     68  CA  GLU    18      46.071 -20.942  26.935  1.00 34.74           C  
ATOM     69  C   GLU    18      46.977 -19.765  26.654  1.00 31.75           C  
ATOM     70  O   GLU    18      47.183 -18.936  27.543  1.00 30.78           O  
ATOM     71  CB  GLU    18      46.900 -22.196  27.222  1.00 34.77           C  
ATOM     72  CG  GLU    18      46.059 -23.376  27.751  1.00 42.03           C  
ATOM     73  CD  GLU    18      46.796 -24.726  27.729  1.00 43.33           C  
ATOM     74  OE1 GLU    18      47.977 -24.782  27.337  1.00 54.77           O  
ATOM     75  OE2 GLU    18      46.183 -25.752  28.110  1.00 57.13           O  
ATOM     76  N   LEU    19      47.485 -19.658  25.420  1.00 30.67           N  
ATOM     77  CA  LEU    19      48.438 -18.570  25.070  1.00 30.07           C  
ATOM     78  C   LEU    19      47.779 -17.220  25.227  1.00 30.04           C  
ATOM     79  O   LEU    19      48.381 -16.277  25.748  1.00 30.43           O  
ATOM     80  CB  LEU    19      48.997 -18.734  23.646  1.00 29.84           C  
ATOM     81  CG  LEU    19      50.144 -17.827  23.208  1.00 29.31           C  
ATOM     82  CD1 LEU    19      51.284 -17.839  24.240  1.00 31.63           C  
ATOM     83  CD2 LEU    19      50.653 -18.189  21.806  1.00 25.27           C  
ATOM     84  N   ALA    20      46.525 -17.150  24.806  1.00 29.97           N  
ATOM     85  CA  ALA    20      45.729 -15.924  24.888  1.00 31.22           C  
ATOM     86  C   ALA    20      45.521 -15.475  26.334  1.00 30.56           C  
ATOM     87  O   ALA    20      45.505 -14.283  26.629  1.00 32.27           O  
ATOM     88  CB  ALA    20      44.375 -16.146  24.203  1.00 30.51           C  
ATOM     89  N   GLN    21      45.343 -16.432  27.233  1.00 31.77           N  
ATOM     90  CA  GLN    21      45.207 -16.143  28.663  1.00 30.90           C  
ATOM     91  C   GLN    21      46.536 -15.649  29.217  1.00 30.39           C  
ATOM     92  O   GLN    21      46.576 -14.712  30.011  1.00 32.04           O  
ATOM     93  CB  GLN    21      44.717 -17.404  29.411  1.00 32.37           C  
ATOM     94  CG  GLN    21      44.695 -17.283  30.920  1.00 42.11           C  
ATOM     95  N   GLU    22      47.636 -16.241  28.772  1.00 29.04           N  
ATOM     96  CA  GLU    22      48.951 -15.875  29.310  1.00 27.71           C  
ATOM     97  C   GLU    22      49.502 -14.569  28.735  1.00 30.62           C  
ATOM     98  O   GLU    22      50.216 -13.818  29.441  1.00 30.38           O  
ATOM     99  CB  GLU    22      49.911 -17.020  29.090  1.00 27.03           C  
ATOM    100  CG  GLU    22      49.492 -18.259  29.869  1.00 33.36           C  
ATOM    101  CD  GLU    22      50.401 -19.423  29.682  1.00 36.56           C  
ATOM    102  OE1 GLU    22      51.620 -19.193  29.452  1.00 42.93           O  
ATOM    103  OE2 GLU    22      49.905 -20.578  29.799  1.00 37.90           O  
ATOM    104  N   LEU    23      49.169 -14.279  27.470  1.00 29.30           N  
ATOM    105  CA  LEU    23      49.631 -13.056  26.825  1.00 29.17           C  
ATOM    106  C   LEU    23      48.642 -11.915  26.932  1.00 30.25           C  
ATOM    107  O   LEU    23      48.992 -10.772  26.663  1.00 32.08           O  
ATOM    108  CB  LEU    23      49.935 -13.315  25.356  1.00 29.09           C  
ATOM    109  CG  LEU    23      51.089 -14.251  25.075  1.00 30.17           C  
ATOM    110  CD1 LEU    23      51.295 -14.407  23.565  1.00 31.18           C  
ATOM    111  CD2 LEU    23      52.365 -13.776  25.805  1.00 27.85           C  
ATOM    112  N   GLY    24      47.408 -12.223  27.309  1.00 30.92           N  
ATOM    113  CA  GLY    24      46.347 -11.247  27.430  1.00 30.54           C  
ATOM    114  C   GLY    24      46.758  -9.901  27.994  1.00 31.61           C  
ATOM    115  O   GLY    24      46.393  -8.876  27.436  1.00 30.61           O  
ATOM    116  N   PRO    25      47.494  -9.889  29.125  1.00 30.78           N  
ATOM    117  CA  PRO    25      47.913  -8.620  29.713  1.00 29.71           C  
ATOM    118  C   PRO    25      48.754  -7.681  28.835  1.00 30.41           C  
ATOM    119  O   PRO    25      48.751  -6.495  29.105  1.00 30.79           O  
ATOM    120  CB  PRO    25      48.729  -9.065  30.930  1.00 29.78           C  
ATOM    121  CG  PRO    25      48.166 -10.377  31.282  1.00 32.86           C  
ATOM    122  CD  PRO    25      47.910 -11.019  29.970  1.00 31.91           C  
ATOM    123  N   ILE    26      49.481  -8.189  27.836  1.00 29.88           N  
ATOM    124  CA  ILE    26      50.311  -7.331  26.939  1.00 27.57           C  
ATOM    125  C   ILE    26      49.696  -7.214  25.528  1.00 29.15           C  
ATOM    126  O   ILE    26      50.237  -6.558  24.634  1.00 29.64           O  
ATOM    127  CB  ILE    26      51.795  -7.772  26.920  1.00 27.40           C  
ATOM    128  CG1 ILE    26      52.030  -9.205  26.461  1.00 28.86           C  
ATOM    129  CG2 ILE    26      52.382  -7.701  28.367  1.00 27.44           C  
ATOM    130  CD1 ILE    26      51.852  -9.499  24.971  1.00 34.86           C  
ATOM    131  N   MET    27      48.551  -7.848  25.344  1.00 31.06           N  
ATOM    132  CA  MET    27      47.818  -7.785  24.090  1.00 31.64           C  
ATOM    133  C   MET    27      46.949  -6.543  24.019  1.00 29.78           C  
ATOM    134  O   MET    27      46.490  -6.026  25.053  1.00 29.97           O  
ATOM    135  CB  MET    27      46.958  -9.038  23.926  1.00 30.84           C  
ATOM    136  CG  MET    27      47.764 -10.254  23.491  1.00 32.59           C  
ATOM    137  SD  MET    27      46.672 -11.860  23.482  0.75 35.14          SE  
ATOM    138  CE  MET    27      45.480 -11.416  21.918  1.00 32.37           C  
ATOM    139  N   GLY    28      46.702  -6.069  22.799  1.00 28.32           N  
ATOM    140  CA  GLY    28      45.767  -4.966  22.580  1.00 29.27           C  
ATOM    141  C   GLY    28      44.343  -5.406  22.889  1.00 31.94           C  
ATOM    142  O   GLY    28      44.034  -6.593  22.801  1.00 32.50           O  
ATOM    143  N   ASP    29      43.478  -4.449  23.232  1.00 32.77           N  
ATOM    144  CA  ASP    29      42.073  -4.713  23.559  1.00 34.58           C  
ATOM    145  C   ASP    29      41.351  -5.497  22.450  1.00 35.87           C  
ATOM    146  O   ASP    29      40.587  -6.400  22.741  1.00 39.58           O  
ATOM    147  CB  ASP    29      41.286  -3.411  23.802  1.00 34.46           C  
ATOM    148  CG  ASP    29      41.745  -2.633  25.038  1.00 37.07           C  
ATOM    149  OD1 ASP    29      42.465  -3.173  25.898  1.00 37.61           O  
ATOM    150  OD2 ASP    29      41.381  -1.434  25.124  1.00 44.68           O  
ATOM    151  N   ASN    30      41.580  -5.136  21.193  1.00 35.57           N  
ATOM    152  CA  ASN    30      40.959  -5.818  20.047  1.00 37.83           C  
ATOM    153  C   ASN    30      41.907  -6.777  19.279  1.00 36.99           C  
ATOM    154  O   ASN    30      41.725  -7.048  18.082  1.00 37.90           O  
ATOM    155  CB  ASN    30      40.408  -4.760  19.085  1.00 40.16           C  
ATOM    156  CG  ASN    30      39.472  -3.749  19.782  1.00 50.83           C  
ATOM    157  OD1 ASN    30      38.693  -4.105  20.683  1.00 53.38           O  
ATOM    158  ND2 ASN    30      39.556  -2.484  19.364  1.00 57.62           N  
ATOM    159  N   GLU    31      42.917  -7.298  19.973  1.00 33.17           N  
ATOM    160  CA  GLU    31      43.866  -8.192  19.356  1.00 30.29           C  
ATOM    161  C   GLU    31      43.462  -9.640  19.573  1.00 29.50           C  
ATOM    162  O   GLU    31      43.000 -10.022  20.652  1.00 27.97           O  
ATOM    163  CB  GLU    31      45.260  -7.965  19.936  1.00 28.92           C  
ATOM    164  CG  GLU    31      46.361  -8.680  19.151  1.00 28.18           C  
ATOM    165  CD  GLU    31      47.734  -8.228  19.562  1.00 28.59           C  
ATOM    166  OE1 GLU    31      47.887  -7.721  20.712  1.00 28.28           O  
ATOM    167  OE2 GLU    31      48.671  -8.396  18.748  1.00 30.08           O  
ATOM    168  N   GLN    32      43.663 -10.442  18.536  1.00 29.95           N  
ATOM    169  CA  GLN    32      43.384 -11.871  18.580  1.00 30.19           C  
ATOM    170  C   GLN    32      44.564 -12.658  18.060  1.00 29.38           C  
ATOM    171  O   GLN    32      45.280 -12.223  17.161  1.00 27.54           O  
ATOM    172  CB  GLN    32      42.156 -12.191  17.749  1.00 29.37           C  
ATOM    173  CG  GLN    32      40.886 -11.656  18.349  1.00 38.86           C  
ATOM    174  CD  GLN    32      39.686 -12.111  17.575  1.00 48.30           C  
ATOM    175  OE1 GLN    32      39.096 -11.329  16.829  1.00 53.49           O  
ATOM    176  NE2 GLN    32      39.339 -13.400  17.703  1.00 44.10           N  
ATOM    177  N   LEU    33      44.745 -13.847  18.626  1.00 30.24           N  
ATOM    178  CA  LEU    33      45.794 -14.753  18.184  1.00 30.31           C  
ATOM    179  C   LEU    33      45.333 -15.563  16.985  1.00 29.00           C  
ATOM    180  O   LEU    33      44.192 -16.012  16.938  1.00 28.70           O  
ATOM    181  CB  LEU    33      46.199 -15.677  19.328  1.00 29.81           C  
ATOM    182  CG  LEU    33      46.748 -14.978  20.574  1.00 32.58           C  
ATOM    183  CD1 LEU    33      47.196 -16.058  21.500  1.00 28.01           C  
ATOM    184  CD2 LEU    33      47.890 -14.036  20.289  1.00 31.90           C  
ATOM    185  N   ALA    34      46.197 -15.717  15.991  1.00 27.96           N  
ATOM    186  CA  ALA    34      45.836 -16.491  14.792  1.00 30.62           C  
ATOM    187  C   ALA    34      46.559 -17.833  14.765  1.00 30.42           C  
ATOM    188  O   ALA    34      46.006 -18.860  14.353  1.00 28.34           O  
ATOM    189  CB  ALA    34      46.123 -15.678  13.473  1.00 28.64           C  
ATOM    190  N   LEU    35      47.805 -17.819  15.205  1.00 29.05           N  
ATOM    191  CA  LEU    35      48.680 -18.949  15.009  1.00 29.50           C  
ATOM    192  C   LEU    35      49.915 -18.789  15.876  1.00 28.92           C  
ATOM    193  O   LEU    35      50.457 -17.688  15.998  1.00 27.72           O  
ATOM    194  CB  LEU    35      49.077 -18.981  13.542  1.00 31.93           C  
ATOM    195  CG  LEU    35      49.742 -20.189  12.917  1.00 35.04           C  
ATOM    196  CD1 LEU    35      48.962 -21.506  13.182  1.00 38.57           C  
ATOM    197  CD2 LEU    35      49.850 -19.879  11.433  1.00 36.70           C  
ATOM    198  N   ALA    36      50.387 -19.888  16.457  1.00 26.00           N  
ATOM    199  CA  ALA    36      51.602 -19.829  17.208  1.00 26.36           C  
ATOM    200  C   ALA    36      52.398 -21.115  17.200  1.00 26.82           C  
ATOM    201  O   ALA    36      51.850 -22.198  17.333  1.00 25.24           O  
ATOM    202  CB  ALA    36      51.327 -19.382  18.648  1.00 25.51           C  
ATOM    203  N   TYR    37      53.718 -20.956  17.077  1.00 26.47           N  
ATOM    204  CA  TYR    37      54.626 -22.089  17.064  1.00 27.81           C  
ATOM    205  C   TYR    37      55.699 -21.936  18.146  1.00 28.83           C  
ATOM    206  O   TYR    37      56.197 -20.845  18.417  1.00 28.58           O  
ATOM    207  CB  TYR    37      55.281 -22.242  15.691  1.00 28.27           C  
ATOM    208  CG  TYR    37      54.308 -22.558  14.585  1.00 28.64           C  
ATOM    209  CD1 TYR    37      53.787 -23.844  14.442  1.00 30.62           C  
ATOM    210  CD2 TYR    37      53.887 -21.578  13.688  1.00 31.83           C  
ATOM    211  CE1 TYR    37      52.866 -24.148  13.426  1.00 30.92           C  
ATOM    212  CE2 TYR    37      52.970 -21.886  12.650  1.00 32.26           C  
ATOM    213  CZ  TYR    37      52.467 -23.160  12.540  1.00 31.17           C  
ATOM    214  OH  TYR    37      51.557 -23.480  11.544  1.00 37.96           O  
ATOM    215  N   ARG    38      56.061 -23.057  18.748  1.00 29.59           N  
ATOM    216  CA  ARG    38      57.211 -23.114  19.624  1.00 31.93           C  
ATOM    217  C   ARG    38      58.388 -23.872  18.988  1.00 32.07           C  
ATOM    218  O   ARG    38      58.234 -24.897  18.322  1.00 32.21           O  
ATOM    219  CB  ARG    38      56.822 -23.759  20.946  1.00 33.38           C  
ATOM    220  CG  ARG    38      57.843 -23.520  22.054  1.00 39.14           C  
ATOM    221  CD  ARG    38      57.762 -24.582  23.122  1.00 48.81           C  
ATOM    222  NE  ARG    38      56.793 -24.280  24.161  1.00 51.66           N  
ATOM    223  CZ  ARG    38      55.529 -24.684  24.163  1.00 55.61           C  
ATOM    224  NH1 ARG    38      55.039 -25.411  23.159  1.00 59.48           N  
ATOM    225  NH2 ARG    38      54.751 -24.347  25.181  1.00 52.27           N  
ATOM    226  N   VAL    39      59.579 -23.348  19.184  1.00 32.67           N  
ATOM    227  CA  VAL    39      60.788 -24.084  18.841  1.00 33.79           C  
ATOM    228  C   VAL    39      61.618 -24.110  20.121  1.00 34.37           C  
ATOM    229  O   VAL    39      62.196 -23.097  20.514  1.00 35.08           O  
ATOM    230  CB  VAL    39      61.557 -23.468  17.631  1.00 32.80           C  
ATOM    231  CG1 VAL    39      62.871 -24.228  17.388  1.00 33.25           C  
ATOM    232  CG2 VAL    39      60.697 -23.525  16.386  1.00 35.00           C  
ATOM    233  N   ILE    40      61.613 -25.265  20.788  1.00 34.65           N  
ATOM    234  CA  ILE    40      62.264 -25.452  22.095  1.00 36.62           C  
ATOM    235  C   ILE    40      61.657 -24.485  23.132  1.00 34.68           C  
ATOM    236  O   ILE    40      60.539 -24.701  23.582  1.00 34.13           O  
ATOM    237  CB  ILE    40      63.824 -25.387  22.019  1.00 38.36           C  
ATOM    238  CG1 ILE    40      64.365 -26.358  20.954  1.00 43.53           C  
ATOM    239  CG2 ILE    40      64.429 -25.782  23.363  1.00 40.40           C  
ATOM    240  CD1 ILE    40      65.763 -25.997  20.421  1.00 40.40           C  
ATOM    241  N   ARG    41      62.357 -23.419  23.507  1.00 33.68           N  
ATOM    242  CA  ARG    41      61.806 -22.442  24.463  1.00 34.26           C  
ATOM    243  C   ARG    41      61.242 -21.171  23.802  1.00 32.54           C  
ATOM    244  O   ARG    41      60.541 -20.393  24.445  1.00 34.61           O  
ATOM    245  CB  ARG    41      62.879 -21.980  25.436  1.00 34.70           C  
ATOM    246  CG  ARG    41      63.597 -23.055  26.161  1.00 37.86           C  
ATOM    247  CD  ARG    41      64.516 -22.440  27.219  1.00 40.35           C  
ATOM    248  NE  ARG    41      65.529 -21.523  26.666  1.00 39.77           N  
ATOM    249  CZ  ARG    41      66.724 -21.315  27.228  1.00 39.80           C  
ATOM    250  NH1 ARG    41      67.050 -21.929  28.361  1.00 35.97           N  
ATOM    251  NH2 ARG    41      67.594 -20.488  26.670  1.00 31.93           N  
ATOM    252  N   ASP    42      61.585 -20.951  22.545  1.00 29.33           N  
ATOM    253  CA  ASP    42      61.232 -19.738  21.831  1.00 30.54           C  
ATOM    254  C   ASP    42      59.881 -19.918  21.142  1.00 30.37           C  
ATOM    255  O   ASP    42      59.463 -21.036  20.858  1.00 30.57           O  
ATOM    256  CB  ASP    42      62.319 -19.405  20.805  1.00 29.08           C  
ATOM    257  CG  ASP    42      63.675 -19.131  21.445  1.00 35.53           C  
ATOM    258  OD1 ASP    42      63.723 -18.839  22.665  1.00 33.19           O  
ATOM    259  OD2 ASP    42      64.705 -19.209  20.729  1.00 40.83           O  
ATOM    260  N   MET    43      59.199 -18.806  20.902  1.00 29.53           N  
ATOM    261  CA  MET    43      57.899 -18.801  20.272  1.00 33.10           C  
ATOM    262  C   MET    43      57.786 -17.741  19.205  1.00 29.59           C  
ATOM    263  O   MET    43      58.364 -16.654  19.304  1.00 31.23           O  
ATOM    264  CB  MET    43      56.815 -18.561  21.301  1.00 31.88           C  
ATOM    265  CG  MET    43      56.082 -19.773  21.698  1.00 41.39           C  
ATOM    266  SD  MET    43      54.583 -19.260  22.789  0.75 44.15          SE  
ATOM    267  CE  MET    43      54.929 -20.493  24.116  1.00 39.34           C  
ATOM    268  N   PHE    44      57.042 -18.095  18.167  1.00 29.00           N  
ATOM    269  CA  PHE    44      56.722 -17.213  17.071  1.00 28.77           C  
ATOM    270  C   PHE    44      55.190 -17.112  17.021  1.00 29.74           C  
ATOM    271  O   PHE    44      54.499 -18.098  16.729  1.00 30.01           O  
ATOM    272  CB  PHE    44      57.282 -17.836  15.807  1.00 30.56           C  
ATOM    273  CG  PHE    44      57.484 -16.877  14.696  1.00 32.68           C  
ATOM    274  CD1 PHE    44      56.436 -16.470  13.921  1.00 40.05           C  
ATOM    275  CD2 PHE    44      58.737 -16.371  14.427  1.00 39.89           C  
ATOM    276  CE1 PHE    44      56.629 -15.576  12.869  1.00 38.52           C  
ATOM    277  CE2 PHE    44      58.931 -15.475  13.376  1.00 38.67           C  
ATOM    278  CZ  PHE    44      57.865 -15.098  12.592  1.00 35.49           C  
ATOM    279  N   VAL    45      54.657 -15.937  17.355  1.00 27.56           N  
ATOM    280  CA  VAL    45      53.215 -15.790  17.522  1.00 28.26           C  
ATOM    281  C   VAL    45      52.675 -14.862  16.445  1.00 27.06           C  
ATOM    282  O   VAL    45      53.233 -13.789  16.221  1.00 27.80           O  
ATOM    283  CB  VAL    45      52.890 -15.282  18.925  1.00 27.14           C  
ATOM    284  CG1 VAL    45      51.361 -15.110  19.124  1.00 23.97           C  
ATOM    285  CG2 VAL    45      53.477 -16.246  19.943  1.00 24.77           C  
ATOM    286  N   PHE    46      51.654 -15.322  15.738  1.00 25.28           N  
ATOM    287  CA  PHE    46      50.933 -14.480  14.779  1.00 26.22           C  
ATOM    288  C   PHE    46      49.657 -14.017  15.411  1.00 25.97           C  
ATOM    289  O   PHE    46      48.792 -14.832  15.732  1.00 24.46           O  
ATOM    290  CB  PHE    46      50.565 -15.239  13.507  1.00 25.83           C  
ATOM    291  CG  PHE    46      51.729 -15.729  12.736  1.00 26.44           C  
ATOM    292  CD1 PHE    46      52.428 -16.870  13.152  1.00 33.54           C  
ATOM    293  CD2 PHE    46      52.122 -15.083  11.572  1.00 31.14           C  
ATOM    294  CE1 PHE    46      53.521 -17.335  12.424  1.00 31.61           C  
ATOM    295  CE2 PHE    46      53.214 -15.538  10.832  1.00 30.46           C  
ATOM    296  CZ  PHE    46      53.908 -16.657  11.251  1.00 32.65           C  
ATOM    297  N   THR    47      49.525 -12.711  15.596  1.00 26.48           N  
ATOM    298  CA  THR    47      48.247 -12.146  15.980  1.00 25.78           C  
ATOM    299  C   THR    47      47.572 -11.540  14.737  1.00 26.06           C  
ATOM    300  O   THR    47      48.073 -11.664  13.619  1.00 25.84           O  
ATOM    301  CB  THR    47      48.401 -11.146  17.110  1.00 24.21           C  
ATOM    302  OG1 THR    47      48.626  -9.819  16.579  1.00 24.94           O  
ATOM    303  CG2 THR    47      49.514 -11.595  18.070  1.00 22.98           C  
ATOM    304  N   ASN    48      46.414 -10.923  14.908  1.00 27.66           N  
ATOM    305  CA  ASN    48      45.837 -10.172  13.790  1.00 28.00           C  
ATOM    306  C   ASN    48      46.465  -8.771  13.558  1.00 28.75           C  
ATOM    307  O   ASN    48      46.083  -8.081  12.625  1.00 27.02           O  
ATOM    308  CB  ASN    48      44.310 -10.085  13.891  1.00 27.80           C  
ATOM    309  CG  ASN    48      43.834  -9.365  15.101  1.00 30.65           C  
ATOM    310  OD1 ASN    48      44.560  -9.170  16.079  1.00 27.46           O  
ATOM    311  ND2 ASN    48      42.582  -8.966  15.058  1.00 32.05           N  
ATOM    312  N   LYS    49      47.414  -8.373  14.401  1.00 29.97           N  
ATOM    313  CA  LYS    49      48.050  -7.044  14.362  1.00 29.05           C  
ATOM    314  C   LYS    49      49.577  -7.072  14.225  1.00 27.69           C  
ATOM    315  O   LYS    49      50.189  -6.095  13.795  1.00 25.55           O  
ATOM    316  CB  LYS    49      47.745  -6.312  15.651  1.00 29.91           C  
ATOM    317  CG  LYS    49      46.293  -6.201  16.012  1.00 32.58           C  
ATOM    318  CD  LYS    49      45.605  -5.135  15.243  1.00 40.52           C  
ATOM    319  CE  LYS    49      44.240  -4.850  15.839  1.00 46.49           C  
ATOM    320  NZ  LYS    49      43.305  -4.508  14.762  1.00 47.89           N  
ATOM    321  N   ARG    50      50.196  -8.159  14.650  1.00 25.39           N  
ATOM    322  CA  ARG    50      51.658  -8.219  14.705  1.00 25.08           C  
ATOM    323  C   ARG    50      52.156  -9.637  14.821  1.00 24.78           C  
ATOM    324  O   ARG    50      51.416 -10.546  15.162  1.00 24.93           O  
ATOM    325  CB  ARG    50      52.176  -7.433  15.933  1.00 24.93           C  
ATOM    326  CG  ARG    50      51.571  -7.928  17.244  1.00 23.01           C  
ATOM    327  CD  ARG    50      52.229  -7.387  18.526  1.00 25.97           C  
ATOM    328  NE  ARG    50      51.227  -7.423  19.606  1.00 25.66           N  
ATOM    329  CZ  ARG    50      51.399  -6.963  20.839  1.00 26.42           C  
ATOM    330  NH1 ARG    50      52.565  -6.453  21.241  1.00 27.11           N  
ATOM    331  NH2 ARG    50      50.387  -7.018  21.699  1.00 26.62           N  
ATOM    332  N   LEU    51      53.451  -9.807  14.600  1.00 26.95           N  
ATOM    333  CA  LEU    51      54.146 -10.970  15.100  1.00 27.04           C  
ATOM    334  C   LEU    51      54.712 -10.597  16.461  1.00 29.78           C  
ATOM    335  O   LEU    51      55.170  -9.460  16.658  1.00 30.41           O  
ATOM    336  CB  LEU    51      55.282 -11.370  14.186  1.00 27.54           C  
ATOM    337  CG  LEU    51      54.998 -11.394  12.686  1.00 29.34           C  
ATOM    338  CD1 LEU    51      56.323 -11.607  11.956  1.00 30.99           C  
ATOM    339  CD2 LEU    51      53.980 -12.453  12.310  1.00 26.66           C  
ATOM    340  N   ILE    52      54.661 -11.547  17.392  1.00 27.68           N  
ATOM    341  CA  ILE    52      55.383 -11.477  18.649  1.00 27.58           C  
ATOM    342  C   ILE    52      56.458 -12.570  18.624  1.00 30.30           C  
ATOM    343  O   ILE    52      56.167 -13.772  18.457  1.00 28.72           O  
ATOM    344  CB  ILE    52      54.457 -11.600  19.874  1.00 27.65           C  
ATOM    345  CG1 ILE    52      53.316 -10.591  19.780  1.00 27.80           C  
ATOM    346  CG2 ILE    52      55.258 -11.341  21.209  1.00 28.50           C  
ATOM    347  CD1 ILE    52      52.186 -10.811  20.826  1.00 30.99           C  
ATOM    348  N   LEU    53      57.715 -12.153  18.732  1.00 29.54           N  
ATOM    349  CA  LEU    53      58.807 -13.091  18.746  1.00 31.22           C  
ATOM    350  C   LEU    53      59.322 -13.140  20.175  1.00 29.24           C  
ATOM    351  O   LEU    53      59.818 -12.145  20.702  1.00 27.89           O  
ATOM    352  CB  LEU    53      59.911 -12.694  17.757  1.00 33.84           C  
ATOM    353  CG  LEU    53      59.534 -12.203  16.352  1.00 38.88           C  
ATOM    354  CD1 LEU    53      60.751 -12.304  15.464  1.00 47.75           C  
ATOM    355  CD2 LEU    53      58.375 -12.968  15.755  1.00 44.16           C  
ATOM    356  N   ILE    54      59.141 -14.292  20.806  1.00 29.19           N  
ATOM    357  CA  ILE    54      59.549 -14.519  22.195  1.00 28.78           C  
ATOM    358  C   ILE    54      60.821 -15.358  22.243  1.00 29.78           C  
ATOM    359  O   ILE    54      60.788 -16.562  21.961  1.00 29.99           O  
ATOM    360  CB  ILE    54      58.442 -15.232  22.980  1.00 29.40           C  
ATOM    361  CG1 ILE    54      57.138 -14.418  22.910  1.00 27.48           C  
ATOM    362  CG2 ILE    54      58.904 -15.475  24.437  1.00 29.29           C  
ATOM    363  CD1 ILE    54      55.941 -15.044  23.609  1.00 28.12           C  
ATOM    364  N   ASP    55      61.939 -14.719  22.571  1.00 27.43           N  
ATOM    365  CA  ASP    55      63.209 -15.395  22.601  0.50 28.25           C  
ATOM    367  C   ASP    55      63.689 -15.445  24.058  1.00 30.38           C  
ATOM    368  O   ASP    55      63.672 -14.436  24.769  1.00 29.76           O  
ATOM    369  CB  ASP    55      64.211 -14.688  21.668  0.50 28.09           C  
ATOM    371  CG  ASP    55      63.711 -14.584  20.193  0.50 31.75           C  
ATOM    373  OD1 ASP    55      62.981 -15.477  19.699  0.50 24.59           O  
ATOM    375  OD2 ASP    55      64.057 -13.580  19.521  0.50 41.59           O  
ATOM    377  N   LYS    56      64.099 -16.626  24.493  1.00 32.08           N  
ATOM    378  CA  LYS    56      64.643 -16.810  25.839  1.00 34.65           C  
ATOM    379  C   LYS    56      66.126 -17.191  25.736  1.00 34.68           C  
ATOM    380  O   LYS    56      66.532 -17.954  24.850  1.00 37.13           O  
ATOM    381  CB  LYS    56      63.849 -17.857  26.614  1.00 33.26           C  
ATOM    382  CG  LYS    56      62.331 -17.594  26.648  1.00 33.10           C  
ATOM    383  CD  LYS    56      61.635 -18.592  27.549  1.00 36.85           C  
ATOM    384  CE  LYS    56      60.313 -18.080  28.068  1.00 40.09           C  
ATOM    385  NZ  LYS    56      59.874 -18.933  29.177  1.00 38.34           N  
ATOM    386  N   GLN    57      66.925 -16.637  26.632  1.00 31.52           N  
ATOM    387  CA  GLN    57      68.346 -16.923  26.674  1.00 35.10           C  
ATOM    388  C   GLN    57      68.785 -17.298  28.081  1.00 30.44           C  
ATOM    389  O   GLN    57      68.106 -16.981  29.053  1.00 29.95           O  
ATOM    390  CB  GLN    57      69.126 -15.699  26.191  1.00 37.37           C  
ATOM    391  CG  GLN    57      69.024 -15.465  24.686  1.00 43.68           C  
ATOM    392  CD  GLN    57      69.663 -14.166  24.279  1.00 45.08           C  
ATOM    393  OE1 GLN    57      69.247 -13.084  24.727  1.00 59.61           O  
ATOM    394  NE2 GLN    57      70.687 -14.252  23.422  1.00 57.02           N  
ATOM    395  N   GLY    58      69.932 -17.956  28.156  1.00 27.79           N  
ATOM    396  CA  GLY    58      70.562 -18.339  29.414  1.00 26.89           C  
ATOM    397  C   GLY    58      70.197 -19.773  29.693  1.00 24.22           C  
ATOM    398  O   GLY    58      69.295 -20.297  29.067  1.00 23.88           O  
ATOM    399  N   VAL    59      70.886 -20.411  30.626  1.00 23.58           N  
ATOM    400  CA  VAL    59      70.582 -21.783  31.014  1.00 23.37           C  
ATOM    401  C   VAL    59      69.143 -21.909  31.530  1.00 25.93           C  
ATOM    402  O   VAL    59      68.434 -22.844  31.153  1.00 26.68           O  
ATOM    403  CB  VAL    59      71.593 -22.308  32.067  1.00 24.01           C  
ATOM    404  CG1 VAL    59      71.238 -23.739  32.550  1.00 25.92           C  
ATOM    405  CG2 VAL    59      72.972 -22.274  31.485  1.00 24.03           C  
ATOM    406  N   THR    60      68.709 -20.948  32.352  1.00 23.65           N  
ATOM    407  CA  THR    60      67.411 -21.024  33.014  1.00 23.37           C  
ATOM    408  C   THR    60      66.334 -20.330  32.196  1.00 26.68           C  
ATOM    409  O   THR    60      65.167 -20.386  32.543  1.00 29.28           O  
ATOM    410  CB  THR    60      67.460 -20.432  34.466  1.00 23.51           C  
ATOM    411  OG1 THR    60      67.723 -19.014  34.411  1.00 24.54           O  
ATOM    412  CG2 THR    60      68.520 -21.178  35.329  1.00 18.42           C  
ATOM    413  N   GLY    61      66.724 -19.685  31.104  1.00 30.73           N  
ATOM    414  CA  GLY    61      65.778 -19.099  30.213  1.00 32.98           C  
ATOM    415  C   GLY    61      65.064 -17.897  30.798  1.00 33.69           C  
ATOM    416  O   GLY    61      63.924 -17.633  30.444  1.00 30.37           O  
ATOM    417  N   LYS    62      65.742 -17.153  31.672  1.00 34.20           N  
ATOM    418  CA  LYS    62      65.126 -16.018  32.367  1.00 34.99           C  
ATOM    419  C   LYS    62      65.403 -14.678  31.674  1.00 33.78           C  
ATOM    420  O   LYS    62      64.777 -13.689  31.991  1.00 32.47           O  
ATOM    421  CB  LYS    62      65.569 -15.970  33.846  1.00 36.51           C  
ATOM    422  CG  LYS    62      64.835 -17.001  34.756  1.00 40.22           C  
ATOM    423  CD  LYS    62      63.469 -16.485  35.349  1.00 35.99           C  
ATOM    424  CE  LYS    62      63.674 -15.574  36.580  1.00 39.51           C  
ATOM    425  NZ  LYS    62      62.419 -15.380  37.434  1.00 49.24           N  
ATOM    426  N   LYS    63      66.347 -14.657  30.743  1.00 34.21           N  
ATOM    427  CA  LYS    63      66.583 -13.491  29.897  0.50 32.42           C  
ATOM    429  C   LYS    63      65.592 -13.606  28.728  1.00 33.46           C  
ATOM    430  O   LYS    63      65.785 -14.402  27.821  1.00 34.76           O  
ATOM    431  CB  LYS    63      68.057 -13.471  29.440  0.50 32.19           C  
ATOM    433  CG  LYS    63      68.509 -12.280  28.569  0.50 31.21           C  
ATOM    435  CD  LYS    63      68.054 -10.927  29.115  0.50 31.56           C  
ATOM    437  CE  LYS    63      69.005  -9.800  28.734  0.50 31.03           C  
ATOM    439  NZ  LYS    63      69.908  -9.444  29.870  0.50 31.91           N  
ATOM    441  N   VAL    64      64.505 -12.844  28.784  1.00 31.40           N  
ATOM    442  CA  VAL    64      63.399 -13.004  27.823  1.00 30.46           C  
ATOM    443  C   VAL    64      63.151 -11.707  27.081  1.00 30.91           C  
ATOM    444  O   VAL    64      63.119 -10.664  27.694  1.00 29.73           O  
ATOM    445  CB  VAL    64      62.088 -13.428  28.519  1.00 29.36           C  
ATOM    446  CG1 VAL    64      60.970 -13.644  27.493  1.00 27.60           C  
ATOM    447  CG2 VAL    64      62.291 -14.703  29.339  1.00 27.76           C  
ATOM    448  N   SER    65      63.017 -11.776  25.760  1.00 29.51           N  
ATOM    449  CA  SER    65      62.544 -10.643  25.002  1.00 26.52           C  
ATOM    450  C   SER    65      61.240 -10.925  24.275  1.00 26.64           C  
ATOM    451  O   SER    65      61.002 -12.012  23.772  1.00 28.62           O  
ATOM    452  CB  SER    65      63.592 -10.138  24.022  1.00 27.05           C  
ATOM    453  OG  SER    65      64.070 -11.185  23.235  1.00 33.03           O  
ATOM    454  N   TYR    66      60.389  -9.920  24.236  1.00 25.59           N  
ATOM    455  CA  TYR    66      59.191  -9.948  23.409  1.00 27.15           C  
ATOM    456  C   TYR    66      59.361  -8.849  22.363  1.00 25.16           C  
ATOM    457  O   TYR    66      59.309  -7.661  22.693  1.00 25.87           O  
ATOM    458  CB  TYR    66      57.933  -9.662  24.243  1.00 28.11           C  
ATOM    459  CG  TYR    66      57.432 -10.753  25.177  1.00 28.34           C  
ATOM    460  CD1 TYR    66      58.267 -11.715  25.738  1.00 37.37           C  
ATOM    461  CD2 TYR    66      56.097 -10.793  25.520  1.00 31.42           C  
ATOM    462  CE1 TYR    66      57.757 -12.693  26.606  1.00 34.85           C  
ATOM    463  CE2 TYR    66      55.586 -11.741  26.356  1.00 33.25           C  
ATOM    464  CZ  TYR    66      56.403 -12.676  26.918  1.00 35.59           C  
ATOM    465  OH  TYR    66      55.813 -13.599  27.764  1.00 35.83           O  
ATOM    466  N   HIS    67      59.605  -9.263  21.126  1.00 24.79           N  
ATOM    467  CA  HIS    67      59.756  -8.360  20.009  1.00 26.12           C  
ATOM    468  C   HIS    67      58.450  -8.365  19.214  1.00 25.09           C  
ATOM    469  O   HIS    67      58.064  -9.386  18.628  1.00 25.46           O  
ATOM    470  CB  HIS    67      60.943  -8.805  19.158  1.00 27.50           C  
ATOM    471  CG  HIS    67      61.301  -7.845  18.073  1.00 28.86           C  
ATOM    472  ND1 HIS    67      62.124  -8.190  17.027  1.00 41.80           N  
ATOM    473  CD2 HIS    67      60.888  -6.582  17.826  1.00 33.68           C  
ATOM    474  CE1 HIS    67      62.236  -7.160  16.203  1.00 47.44           C  
ATOM    475  NE2 HIS    67      61.492  -6.172  16.665  1.00 32.45           N  
ATOM    476  N   SER    68      57.770  -7.224  19.200  1.00 23.64           N  
ATOM    477  CA  SER    68      56.558  -7.036  18.377  1.00 24.79           C  
ATOM    478  C   SER    68      56.883  -6.462  17.006  1.00 25.82           C  
ATOM    479  O   SER    68      57.509  -5.383  16.889  1.00 23.38           O  
ATOM    480  CB  SER    68      55.560  -6.122  19.079  1.00 24.81           C  
ATOM    481  OG  SER    68      55.153  -6.674  20.322  1.00 24.83           O  
ATOM    482  N   VAL    69      56.462  -7.187  15.969  1.00 25.47           N  
ATOM    483  CA  VAL    69      56.582  -6.720  14.602  1.00 26.01           C  
ATOM    484  C   VAL    69      55.193  -6.542  14.009  1.00 24.83           C  
ATOM    485  O   VAL    69      54.589  -7.532  13.574  1.00 24.53           O  
ATOM    486  CB  VAL    69      57.414  -7.649  13.728  1.00 25.83           C  
ATOM    487  CG1 VAL    69      57.718  -6.924  12.392  1.00 24.55           C  
ATOM    488  CG2 VAL    69      58.691  -8.027  14.450  1.00 23.41           C  
ATOM    489  N   PRO    70      54.672  -5.302  14.022  1.00 23.95           N  
ATOM    490  CA  PRO    70      53.391  -5.074  13.368  1.00 25.46           C  
ATOM    491  C   PRO    70      53.522  -5.421  11.899  1.00 25.75           C  
ATOM    492  O   PRO    70      54.592  -5.246  11.303  1.00 23.32           O  
ATOM    493  CB  PRO    70      53.128  -3.576  13.583  1.00 26.99           C  
ATOM    494  CG  PRO    70      54.007  -3.194  14.738  1.00 26.95           C  
ATOM    495  CD  PRO    70      55.206  -4.066  14.618  1.00 25.90           C  
END
