
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  789),  selected   98 , name 1stf_I
# Molecule2: number of CA atoms   62 (  480),  selected   62 , name T0446_9_70.pdb
# PARAMETERS: 1stf_I.T0446_9_70.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     6_I      -       -           -
LGA    M     7_I      -       -           -
LGA    S     8_I      G       9          3.535
LGA    G     9_I      -       -           -
LGA    A    10_I      -       -           -
LGA    P    11_I      N      10          5.122
LGA    S    12_I      A      11          1.054
LGA    A    13_I      A      12          4.402
LGA    T    14_I      E      13          3.851
LGA    Q    15_I      V      14          4.312
LGA    P    16_I      N      15          4.699
LGA    A    17_I      L      16          1.009
LGA    T    18_I      D      17          2.710
LGA    A    19_I      E      18          1.364
LGA    E    20_I      L      19          3.237
LGA    T    21_I      -       -           -
LGA    Q    22_I      A      20          1.258
LGA    H    23_I      Q      21          3.399
LGA    I    24_I      E      22          3.847
LGA    A    25_I      L      23          2.646
LGA    D    26_I      G      24          2.734
LGA    Q    27_I      P      25          4.667
LGA    V    28_I      I      26          3.939
LGA    R    29_I      M      27          3.515
LGA    S    30_I      -       -           -
LGA    Q    31_I      -       -           -
LGA    L    32_I      -       -           -
LGA    E    33_I      -       -           -
LGA    E    34_I      -       -           -
LGA    K    35_I      -       -           -
LGA    Y    36_I      -       -           -
LGA    N    37_I      -       -           -
LGA    K    38_I      -       -           -
LGA    K    39_I      -       -           -
LGA    F    40_I      G      28          3.531
LGA    P    43_I      D      29          3.073
LGA    V    44_I      N      30          0.955
LGA    F    45_I      E      31          2.053
LGA    K    46_I      Q      32          1.910
LGA    A    47_I      L      33          1.969
LGA    V    48_I      A      34          2.516
LGA    S    49_I      L      35          1.600
LGA    F    50_I      A      36          0.817
LGA    K    51_I      Y      37          0.372
LGA    S    52_I      R      38          0.385
LGA    Q    53_I      V      39          0.875
LGA    V    54_I      I      40          1.351
LGA    V    55_I      -       -           -
LGA    A    56_I      -       -           -
LGA    G    57_I      -       -           -
LGA    T    58_I      R      41          1.378
LGA    N    59_I      D      42          1.007
LGA    Y    60_I      M      43          0.999
LGA    F    61_I      F      44          0.790
LGA    I    62_I      V      45          0.836
LGA    K    63_I      F      46          1.285
LGA    V    64_I      T      47          1.445
LGA    H    65_I      N      48          2.643
LGA    V    66_I      K      49          4.115
LGA    G    67_I      -       -           -
LGA    D    68_I      -       -           -
LGA    E    92_I      -       -           -
LGA    D    93_I      -       -           -
LGA    F    94_I      -       -           -
LGA    V    95_I      R      50          1.491
LGA    H    96_I      L      51          1.357
LGA    L    97_I      I      52          0.878
LGA    R    98_I      L      53          0.430
LGA    V    99_I      I      54          1.265
LGA    F   100_I      D      55          2.766
LGA    Q   101_I      K      56          4.413
LGA    -       -      Q      57           -
LGA    -       -      G      58           -
LGA    -       -      V      59           -
LGA    S   102_I      T      60           #
LGA    L  102A_I      G      61          3.019
LGA    P   103_I      -       -           -
LGA    H   104_I      -       -           -
LGA    E   105_I      -       -           -
LGA    N  105A_I      -       -           -
LGA    K   106_I      K      62          3.526
LGA    P   107_I      K      63           #
LGA    L   108_I      V      64          4.834
LGA    T   109_I      S      65          2.649
LGA    L   110_I      Y      66          0.642
LGA    S   111_I      H      67          3.279
LGA    N   112_I      -       -           -
LGA    Y   113_I      S      68          2.877
LGA    Q   114_I      V      69          2.688
LGA    T   115_I      P      70          2.073
LGA    N  115A_I      -       -           -
LGA    K   116_I      -       -           -
LGA    A   117_I      -       -           -
LGA    K   118_I      -       -           -
LGA    H   119_I      -       -           -
LGA    D   120_I      -       -           -
LGA    E   121_I      -       -           -
LGA    L   122_I      -       -           -
LGA    T   123_I      -       -           -
LGA    Y   124_I      -       -           -
LGA    F   125_I      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   62    5.0     57    2.73     5.26     66.090     2.016

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.551831 * X  +  -0.076640 * Y  +  -0.830427 * Z  + 106.833542
  Y_new =   0.493299 * X  +  -0.832879 * Y  +  -0.250938 * Z  +  20.009188
  Z_new =  -0.672413 * X  +  -0.548124 * Y  +   0.497414 * Z  +  25.463923 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.833861    2.307732  [ DEG:   -47.7767    132.2233 ]
  Theta =   0.737464    2.404129  [ DEG:    42.2536    137.7464 ]
  Phi   =   2.412141   -0.729452  [ DEG:   138.2055    -41.7945 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1stf_I                                        
REMARK     2: T0446_9_70.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1stf_I.T0446_9_70.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   62   5.0   57   2.73    5.26  66.090
REMARK  ---------------------------------------------------------- 
MOLECULE 1stf_I
HEADER    HYDROLASE(SULFHYDRYL PROTEINASE)        21-APR-93   1STF              
TITLE     THE REFINED 2.4 ANGSTROMS X-RAY CRYSTAL STRUCTURE OF                  
TITLE    2 RECOMBINANT HUMAN STEFIN B IN COMPLEX WITH THE CYSTEINE              
TITLE    3 PROTEINASE PAPAIN: A NOVEL TYPE OF PROTEINASE INHIBITOR              
TITLE    4 INTERACTION                                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PAPAIN;                                                    
COMPND   3 CHAIN: E;                                                            
COMPND   4 EC: 3.4.22.2;                                                        
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: STEFIN B (CYSTATIN B);                                     
COMPND   8 CHAIN: I;                                                            
COMPND   9 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CARICA PAPAYA;                                  
SOURCE   3 ORGAN: FRUIT;                                                        
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 MOL_ID: 2;                                                           
SOURCE   6 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   7 ORGAN: FRUIT;                                                        
SOURCE   8 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    HYDROLASE(SULFHYDRYL PROTEINASE)                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.T.STUBBS,B.LABER,W.BODE                                             
REVDAT   2   01-APR-03 1STF    1       JRNL                                     
REVDAT   1   31-JAN-94 1STF    0                                                
JRNL        AUTH   M.T.STUBBS,B.LABER,W.BODE,R.HUBER,R.JERALA,                  
JRNL        AUTH 2 B.LENARCIC,V.TURK                                            
JRNL        TITL   THE REFINED 2.4 A X-RAY CRYSTAL STRUCTURE OF                 
JRNL        TITL 2 RECOMBINANT HUMAN STEFIN B IN COMPLEX WITH THE               
JRNL        TITL 3 CYSTEINE PROTEINASE PAPAIN: A NOVEL TYPE OF                  
JRNL        TITL 4 PROTEINASE INHIBITOR INTERACTION.                            
JRNL        REF    EMBO J.                       V.   9  1939 1990              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 2.37 ANGSTROMS.                                          
DBREF  1STF E    1   212  UNP    P00784   PAPA1_CARPA    134    345             
DBREF  1STF I    6   125  UNP    P04080   CYTB_HUMAN       1     98             
SEQRES   1 E  212  ILE PRO GLU TYR VAL ASP TRP ARG GLN LYS GLY ALA VAL          
SEQRES   2 E  212  THR PRO VAL LYS ASN GLN GLY SER CYS GLY SER CCS TRP          
SEQRES   3 E  212  ALA PHE SER ALA VAL VAL THR ILE GLU GLY ILE ILE LYS          
SEQRES   4 E  212  ILE ARG THR GLY ASN LEU ASN GLN TYR SER GLU GLN GLU          
SEQRES   5 E  212  LEU LEU ASP CYS ASP ARG ARG SER TYR GLY CYS ASN GLY          
SEQRES   6 E  212  GLY TYR PRO TRP SER ALA LEU GLN LEU VAL ALA GLN TYR          
SEQRES   7 E  212  GLY ILE HIS TYR ARG ASN THR TYR PRO TYR GLU GLY VAL          
SEQRES   8 E  212  GLN ARG TYR CYS ARG SER ARG GLU LYS GLY PRO TYR ALA          
SEQRES   9 E  212  ALA LYS THR ASP GLY VAL ARG GLN VAL GLN PRO TYR ASN          
SEQRES  10 E  212  GLN GLY ALA LEU LEU TYR SER ILE ALA ASN GLN PRO VAL          
SEQRES  11 E  212  SER VAL VAL LEU GLN ALA ALA GLY LYS ASP PHE GLN LEU          
SEQRES  12 E  212  TYR ARG GLY GLY ILE PHE VAL GLY PRO CYS GLY ASN LYS          
SEQRES  13 E  212  VAL ASP HIS ALA VAL ALA ALA VAL GLY TYR GLY PRO ASN          
SEQRES  14 E  212  TYR ILE LEU ILE LYS ASN SER TRP GLY THR GLY TRP GLY          
SEQRES  15 E  212  GLU ASN GLY TYR ILE ARG ILE LYS ARG GLY THR GLY ASN          
SEQRES  16 E  212  SER TYR GLY VAL CYS GLY LEU TYR THR SER SER PHE TYR          
SEQRES  17 E  212  PRO VAL LYS ASN                                              
SEQRES   1 I   98  MET MET SER GLY ALA PRO SER ALA THR GLN PRO ALA THR          
SEQRES   2 I   98  ALA GLU THR GLN HIS ILE ALA ASP GLN VAL ARG SER GLN          
SEQRES   3 I   98  LEU GLU GLU LYS TYR ASN LYS LYS PHE PRO VAL PHE LYS          
SEQRES   4 I   98  ALA VAL SER PHE LYS SER GLN VAL VAL ALA GLY THR ASN          
SEQRES   5 I   98  TYR PHE ILE LYS VAL HIS VAL GLY ASP GLU ASP PHE VAL          
SEQRES   6 I   98  HIS LEU ARG VAL PHE GLN SER LEU PRO HIS GLU ASN LYS          
SEQRES   7 I   98  PRO LEU THR LEU SER ASN TYR GLN THR ASN LYS ALA LYS          
SEQRES   8 I   98  HIS ASP GLU LEU THR TYR PHE                                  
HET    CCS  E  25      10                                                       
HETNAM     CCS CARBOXYMETHYLATED CYSTEINE                                       
FORMUL   1  CCS    C5 H9 N O4 S                                                 
FORMUL   3  HOH   *142(H2 O)                                                    
CRYST1   67.000   67.000  169.300  90.00  90.00 120.00 P 31 2 1      6          
ATOM   1661  N   MET I   6      67.210 -35.777  13.750  1.00 25.30           N  
ATOM   1662  CA  MET I   6      68.055 -35.252  12.614  1.00 33.43           C  
ATOM   1663  C   MET I   6      68.287 -33.716  12.620  1.00 37.66           C  
ATOM   1664  O   MET I   6      69.153 -33.255  13.391  1.00 29.78           O  
ATOM   1665  CB  MET I   6      67.555 -35.731  11.240  0.00  0.00           C  
ATOM   1666  CG  MET I   6      68.663 -35.649  10.170  0.00  0.00           C  
ATOM   1667  SD  MET I   6      68.188 -36.183   8.515  0.00  0.00           S  
ATOM   1668  CE  MET I   6      69.800 -36.055   7.716  0.00  0.00           C  
ATOM   1669  N   MET I   7      67.359 -32.981  11.930  1.00 11.54           N  
ATOM   1670  CA  MET I   7      67.181 -31.507  11.974  1.00  8.89           C  
ATOM   1671  C   MET I   7      66.804 -30.926  13.345  1.00  9.83           C  
ATOM   1672  O   MET I   7      65.678 -31.096  13.785  1.00  9.57           O  
ATOM   1673  CB  MET I   7      66.000 -31.230  11.070  1.00  6.00           C  
ATOM   1674  CG  MET I   7      66.289 -30.061  10.134  1.00 22.68           C  
ATOM   1675  SD  MET I   7      66.167 -28.444  10.864  1.00 24.77           S  
ATOM   1676  CE  MET I   7      64.769 -27.826   9.905  0.00  0.00           C  
ATOM   1677  N   SER I   8      67.783 -30.404  14.080  1.00  9.78           N  
ATOM   1678  CA  SER I   8      67.650 -29.974  15.463  1.00  6.00           C  
ATOM   1679  C   SER I   8      67.421 -28.476  15.506  1.00  7.99           C  
ATOM   1680  O   SER I   8      68.204 -27.770  14.890  1.00 10.62           O  
ATOM   1681  CB  SER I   8      68.967 -30.269  16.175  1.00  6.00           C  
ATOM   1682  OG  SER I   8      69.177 -31.688  16.194  1.00  6.00           O  
ATOM   1683  N   GLY I   9      66.488 -28.012  16.315  1.00  6.00           N  
ATOM   1684  CA  GLY I   9      66.407 -26.572  16.583  1.00  6.00           C  
ATOM   1685  C   GLY I   9      65.387 -25.833  15.720  1.00  6.00           C  
ATOM   1686  O   GLY I   9      65.379 -24.606  15.713  1.00  6.00           O  
ATOM   1687  N   ALA I  10      64.566 -26.564  15.010  1.00 16.39           N  
ATOM   1688  CA  ALA I  10      63.511 -25.900  14.227  1.00 17.54           C  
ATOM   1689  C   ALA I  10      62.229 -25.702  15.053  1.00 17.79           C  
ATOM   1690  O   ALA I  10      61.893 -26.557  15.887  1.00 15.81           O  
ATOM   1691  CB  ALA I  10      63.221 -26.750  12.983  1.00 16.63           C  
ATOM   1692  N   PRO I  11      61.504 -24.602  14.818  1.00 19.43           N  
ATOM   1693  CA  PRO I  11      60.202 -24.456  15.473  1.00 21.87           C  
ATOM   1694  C   PRO I  11      59.263 -25.636  15.170  1.00 18.85           C  
ATOM   1695  O   PRO I  11      59.348 -26.318  14.136  1.00 19.04           O  
ATOM   1696  CB  PRO I  11      59.661 -23.077  15.039  1.00 13.81           C  
ATOM   1697  CG  PRO I  11      60.814 -22.393  14.335  1.00  6.00           C  
ATOM   1698  CD  PRO I  11      61.757 -23.486  13.894  1.00  6.00           C  
ATOM   1699  N   SER I  12      58.345 -25.802  16.057  1.00 14.51           N  
ATOM   1700  CA  SER I  12      57.259 -26.748  15.863  1.00 18.15           C  
ATOM   1701  C   SER I  12      56.333 -26.322  14.720  1.00 19.50           C  
ATOM   1702  O   SER I  12      56.264 -25.142  14.372  1.00 18.46           O  
ATOM   1703  CB  SER I  12      56.394 -26.767  17.134  1.00 17.61           C  
ATOM   1704  OG  SER I  12      55.583 -25.578  17.284  1.00  9.98           O  
ATOM   1705  N   ALA I  13      55.460 -27.231  14.341  1.00 19.44           N  
ATOM   1706  CA  ALA I  13      54.334 -26.866  13.487  1.00 16.69           C  
ATOM   1707  C   ALA I  13      53.304 -26.020  14.242  1.00 17.36           C  
ATOM   1708  O   ALA I  13      53.319 -25.901  15.472  1.00 16.56           O  
ATOM   1709  CB  ALA I  13      53.674 -28.116  12.915  1.00 16.10           C  
ATOM   1710  N   THR I  14      52.573 -25.297  13.431  1.00 25.15           N  
ATOM   1711  CA  THR I  14      51.653 -24.297  13.925  1.00 22.82           C  
ATOM   1712  C   THR I  14      50.512 -24.991  14.633  1.00 21.00           C  
ATOM   1713  O   THR I  14      49.885 -25.904  14.106  1.00 22.79           O  
ATOM   1714  CB  THR I  14      51.115 -23.380  12.801  1.00 24.13           C  
ATOM   1715  OG1 THR I  14      52.180 -22.833  12.010  1.00 28.12           O  
ATOM   1716  CG2 THR I  14      50.297 -22.211  13.372  1.00 27.10           C  
ATOM   1717  N   GLN I  15      50.431 -24.623  15.855  1.00 17.56           N  
ATOM   1718  CA  GLN I  15      49.434 -25.063  16.790  1.00 15.97           C  
ATOM   1719  C   GLN I  15      48.530 -23.884  17.128  1.00 17.18           C  
ATOM   1720  O   GLN I  15      48.880 -22.728  16.928  1.00 16.41           O  
ATOM   1721  CB  GLN I  15      50.201 -25.499  18.030  1.00 11.01           C  
ATOM   1722  CG  GLN I  15      50.991 -26.740  17.671  1.00 37.34           C  
ATOM   1723  CD  GLN I  15      51.742 -27.128  18.926  1.00 45.11           C  
ATOM   1724  OE1 GLN I  15      51.278 -28.014  19.644  1.00 44.54           O  
ATOM   1725  NE2 GLN I  15      52.863 -26.447  19.160  1.00 45.24           N  
ATOM   1726  N   PRO I  16      47.308 -24.189  17.464  1.00 23.41           N  
ATOM   1727  CA  PRO I  16      46.316 -23.131  17.663  1.00 22.06           C  
ATOM   1728  C   PRO I  16      46.318 -22.768  19.126  1.00 18.34           C  
ATOM   1729  O   PRO I  16      46.834 -23.566  19.922  1.00 18.82           O  
ATOM   1730  CB  PRO I  16      44.994 -23.777  17.211  1.00 22.62           C  
ATOM   1731  CG  PRO I  16      45.371 -25.164  16.690  1.00 38.96           C  
ATOM   1732  CD  PRO I  16      46.668 -25.517  17.409  1.00 38.92           C  
ATOM   1733  N   ALA I  17      46.109 -21.476  19.323  1.00 21.55           N  
ATOM   1734  CA  ALA I  17      46.425 -20.876  20.621  1.00 21.86           C  
ATOM   1735  C   ALA I  17      45.671 -21.559  21.764  1.00 26.40           C  
ATOM   1736  O   ALA I  17      44.472 -21.825  21.672  1.00 23.81           O  
ATOM   1737  CB  ALA I  17      46.113 -19.378  20.603  1.00 19.95           C  
ATOM   1738  N   THR I  18      46.339 -21.687  22.883  1.00 18.72           N  
ATOM   1739  CA  THR I  18      45.644 -22.076  24.107  1.00 17.02           C  
ATOM   1740  C   THR I  18      45.500 -20.889  25.056  1.00 19.40           C  
ATOM   1741  O   THR I  18      45.629 -19.734  24.656  1.00 18.94           O  
ATOM   1742  CB  THR I  18      46.397 -23.220  24.792  1.00 11.48           C  
ATOM   1743  OG1 THR I  18      47.624 -22.748  25.313  1.00 11.36           O  
ATOM   1744  CG2 THR I  18      46.696 -24.305  23.759  1.00 16.04           C  
ATOM   1745  N   ALA I  19      45.198 -21.194  26.285  1.00 29.20           N  
ATOM   1746  CA  ALA I  19      45.022 -20.132  27.257  1.00 29.44           C  
ATOM   1747  C   ALA I  19      46.404 -19.632  27.631  1.00 29.74           C  
ATOM   1748  O   ALA I  19      46.562 -18.462  27.994  1.00 29.68           O  
ATOM   1749  CB  ALA I  19      44.359 -20.717  28.520  1.00 31.54           C  
ATOM   1750  N   GLU I  20      47.342 -20.565  27.502  1.00 19.15           N  
ATOM   1751  CA  GLU I  20      48.764 -20.291  27.792  1.00 19.22           C  
ATOM   1752  C   GLU I  20      49.277 -19.313  26.741  1.00 11.43           C  
ATOM   1753  O   GLU I  20      49.917 -18.333  27.083  1.00 14.93           O  
ATOM   1754  CB  GLU I  20      49.572 -21.609  27.730  1.00 19.39           C  
ATOM   1755  CG  GLU I  20      50.991 -21.487  28.353  1.00 31.15           C  
ATOM   1756  CD  GLU I  20      51.850 -22.564  27.699  0.00  0.00           C  
ATOM   1757  OE1 GLU I  20      51.483 -23.078  26.608  0.00  0.00           O  
ATOM   1758  OE2 GLU I  20      52.929 -22.940  28.231  0.00  0.00           O  
ATOM   1759  N   THR I  21      48.842 -19.580  25.528  1.00 14.40           N  
ATOM   1760  CA  THR I  21      49.232 -18.777  24.389  1.00 17.54           C  
ATOM   1761  C   THR I  21      48.741 -17.349  24.617  1.00 21.37           C  
ATOM   1762  O   THR I  21      49.524 -16.395  24.528  1.00 19.28           O  
ATOM   1763  CB  THR I  21      48.687 -19.332  23.054  1.00 15.68           C  
ATOM   1764  OG1 THR I  21      48.918 -20.744  22.920  1.00  6.00           O  
ATOM   1765  CG2 THR I  21      49.267 -18.591  21.829  1.00  6.00           C  
ATOM   1766  N   GLN I  22      47.502 -17.263  25.056  1.00  9.34           N  
ATOM   1767  CA  GLN I  22      46.934 -15.934  25.248  1.00  6.00           C  
ATOM   1768  C   GLN I  22      47.558 -15.272  26.453  1.00 10.56           C  
ATOM   1769  O   GLN I  22      47.817 -14.068  26.381  1.00 11.21           O  
ATOM   1770  CB  GLN I  22      45.423 -16.013  25.445  1.00  8.82           C  
ATOM   1771  CG  GLN I  22      44.784 -14.632  25.693  1.00  7.26           C  
ATOM   1772  CD  GLN I  22      44.773 -13.774  24.437  1.00  7.41           C  
ATOM   1773  OE1 GLN I  22      44.468 -14.316  23.372  1.00  6.35           O  
ATOM   1774  NE2 GLN I  22      45.094 -12.473  24.623  1.00  6.32           N  
ATOM   1775  N   HIS I  23      47.954 -16.047  27.420  1.00  6.00           N  
ATOM   1776  CA  HIS I  23      48.506 -15.332  28.558  1.00  6.00           C  
ATOM   1777  C   HIS I  23      49.889 -14.766  28.281  1.00  6.00           C  
ATOM   1778  O   HIS I  23      50.203 -13.673  28.734  1.00  6.00           O  
ATOM   1779  CB  HIS I  23      48.595 -16.310  29.717  1.00  6.00           C  
ATOM   1780  CG  HIS I  23      49.439 -15.730  30.861  1.00 55.24           C  
ATOM   1781  ND1 HIS I  23      48.966 -14.632  31.603  1.00 56.93           N  
ATOM   1782  CD2 HIS I  23      50.657 -16.105  31.329  1.00 55.90           C  
ATOM   1783  CE1 HIS I  23      49.938 -14.345  32.605  1.00 58.35           C  
ATOM   1784  NE2 HIS I  23      51.011 -15.272  32.430  1.00 55.82           N  
ATOM   1785  N   ILE I  24      50.635 -15.513  27.500  1.00  6.00           N  
ATOM   1786  CA  ILE I  24      51.995 -15.171  27.065  1.00  6.00           C  
ATOM   1787  C   ILE I  24      51.924 -13.919  26.199  1.00  6.00           C  
ATOM   1788  O   ILE I  24      52.623 -12.967  26.505  1.00  8.03           O  
ATOM   1789  CB  ILE I  24      52.662 -16.367  26.315  1.00  7.20           C  
ATOM   1790  CG1 ILE I  24      52.985 -17.520  27.284  1.00  6.00           C  
ATOM   1791  CG2 ILE I  24      53.919 -16.029  25.462  1.00  6.00           C  
ATOM   1792  CD1 ILE I  24      53.218 -18.820  26.489  1.00  7.27           C  
ATOM   1793  N   ALA I  25      50.993 -13.872  25.254  1.00  7.96           N  
ATOM   1794  CA  ALA I  25      50.754 -12.658  24.462  1.00  6.44           C  
ATOM   1795  C   ALA I  25      50.450 -11.444  25.360  1.00 15.09           C  
ATOM   1796  O   ALA I  25      50.978 -10.340  25.177  1.00 11.39           O  
ATOM   1797  CB  ALA I  25      49.542 -12.905  23.542  1.00  6.69           C  
ATOM   1798  N   ASP I  26      49.524 -11.667  26.286  1.00 13.92           N  
ATOM   1799  CA  ASP I  26      48.973 -10.576  27.068  1.00  7.96           C  
ATOM   1800  C   ASP I  26      50.037 -10.022  27.964  1.00  8.73           C  
ATOM   1801  O   ASP I  26      50.003  -8.825  28.204  1.00 12.67           O  
ATOM   1802  CB  ASP I  26      47.818 -11.053  27.955  1.00 13.85           C  
ATOM   1803  CG  ASP I  26      46.495 -11.123  27.182  1.00 24.14           C  
ATOM   1804  OD1 ASP I  26      46.183 -10.316  26.256  1.00 21.47           O  
ATOM   1805  OD2 ASP I  26      45.674 -12.011  27.521  1.00 24.26           O  
ATOM   1806  N   GLN I  27      50.996 -10.842  28.324  1.00  9.01           N  
ATOM   1807  CA  GLN I  27      52.195 -10.366  29.083  1.00 10.04           C  
ATOM   1808  C   GLN I  27      53.054  -9.309  28.367  1.00 11.83           C  
ATOM   1809  O   GLN I  27      54.058  -8.824  28.887  1.00 12.10           O  
ATOM   1810  CB  GLN I  27      53.096 -11.590  29.349  1.00  8.98           C  
ATOM   1811  CG  GLN I  27      52.415 -12.654  30.211  1.00 35.95           C  
ATOM   1812  CD  GLN I  27      52.660 -12.301  31.666  1.00 41.46           C  
ATOM   1813  OE1 GLN I  27      53.362 -13.060  32.330  1.00 42.88           O  
ATOM   1814  NE2 GLN I  27      52.115 -11.190  32.141  1.00 42.24           N  
ATOM   1815  N   VAL I  28      52.948  -9.312  27.073  1.00 11.03           N  
ATOM   1816  CA  VAL I  28      53.950  -8.662  26.231  1.00  7.36           C  
ATOM   1817  C   VAL I  28      53.237  -7.557  25.459  1.00  6.78           C  
ATOM   1818  O   VAL I  28      53.900  -6.696  24.904  1.00  6.00           O  
ATOM   1819  CB  VAL I  28      54.466  -9.831  25.382  1.00  6.00           C  
ATOM   1820  CG1 VAL I  28      54.511  -9.591  23.898  1.00  6.00           C  
ATOM   1821  CG2 VAL I  28      55.785 -10.298  25.970  1.00  6.00           C  
ATOM   1822  N   ARG I  29      51.901  -7.553  25.589  1.00  6.74           N  
ATOM   1823  CA  ARG I  29      51.012  -6.585  24.935  1.00  6.24           C  
ATOM   1824  C   ARG I  29      51.551  -5.150  24.998  1.00  6.00           C  
ATOM   1825  O   ARG I  29      51.557  -4.381  24.038  1.00  6.00           O  
ATOM   1826  CB  ARG I  29      49.552  -6.656  25.440  1.00  6.00           C  
ATOM   1827  CG  ARG I  29      48.729  -6.029  24.318  1.00 15.14           C  
ATOM   1828  CD  ARG I  29      47.464  -5.293  24.713  1.00 12.93           C  
ATOM   1829  NE  ARG I  29      46.542  -6.205  25.353  1.00 20.90           N  
ATOM   1830  CZ  ARG I  29      45.213  -6.072  25.174  1.00 24.25           C  
ATOM   1831  NH1 ARG I  29      44.704  -5.168  24.331  1.00 13.58           N  
ATOM   1832  NH2 ARG I  29      44.396  -6.895  25.851  1.00 21.56           N  
ATOM   1833  N   SER I  30      51.957  -4.796  26.147  1.00  7.43           N  
ATOM   1834  CA  SER I  30      52.257  -3.387  26.361  1.00  8.73           C  
ATOM   1835  C   SER I  30      53.567  -2.988  25.720  1.00  6.78           C  
ATOM   1836  O   SER I  30      53.678  -1.843  25.298  1.00  7.07           O  
ATOM   1837  CB  SER I  30      52.395  -3.127  27.876  1.00 13.27           C  
ATOM   1838  OG  SER I  30      51.110  -3.324  28.502  1.00 39.70           O  
ATOM   1839  N   GLN I  31      54.505  -3.903  25.807  1.00 10.56           N  
ATOM   1840  CA  GLN I  31      55.821  -3.713  25.200  1.00 12.38           C  
ATOM   1841  C   GLN I  31      55.637  -3.458  23.701  1.00 12.02           C  
ATOM   1842  O   GLN I  31      56.282  -2.566  23.165  1.00 11.46           O  
ATOM   1843  CB  GLN I  31      56.703  -4.969  25.382  1.00 10.91           C  
ATOM   1844  CG  GLN I  31      56.947  -5.378  26.844  1.00 35.65           C  
ATOM   1845  CD  GLN I  31      57.882  -6.595  26.868  1.00 38.37           C  
ATOM   1846  OE1 GLN I  31      58.808  -6.674  26.048  1.00 37.47           O  
ATOM   1847  NE2 GLN I  31      57.625  -7.515  27.808  1.00 36.22           N  
ATOM   1848  N   LEU I  32      54.740  -4.190  23.082  1.00  7.19           N  
ATOM   1849  CA  LEU I  32      54.425  -4.001  21.651  1.00  6.52           C  
ATOM   1850  C   LEU I  32      53.941  -2.565  21.451  1.00 10.16           C  
ATOM   1851  O   LEU I  32      54.279  -1.915  20.451  1.00  7.99           O  
ATOM   1852  CB  LEU I  32      53.219  -4.911  21.307  1.00  6.00           C  
ATOM   1853  CG  LEU I  32      53.183  -5.449  19.872  1.00  7.61           C  
ATOM   1854  CD1 LEU I  32      51.780  -5.816  19.389  1.00  6.00           C  
ATOM   1855  CD2 LEU I  32      53.877  -4.539  18.867  1.00 13.67           C  
ATOM   1856  N   GLU I  33      52.959  -2.258  22.298  1.00 25.11           N  
ATOM   1857  CA  GLU I  33      52.146  -1.077  22.082  1.00 22.95           C  
ATOM   1858  C   GLU I  33      53.003   0.163  22.213  1.00 22.99           C  
ATOM   1859  O   GLU I  33      52.784   1.143  21.500  1.00 23.11           O  
ATOM   1860  CB  GLU I  33      50.981  -1.032  23.076  1.00 22.65           C  
ATOM   1861  CG  GLU I  33      49.863  -1.992  22.639  1.00 15.66           C  
ATOM   1862  CD  GLU I  33      48.679  -1.849  23.597  1.00 11.96           C  
ATOM   1863  OE1 GLU I  33      48.881  -1.338  24.720  1.00 11.18           O  
ATOM   1864  OE2 GLU I  33      47.522  -2.240  23.284  1.00 10.55           O  
ATOM   1865  N   GLU I  34      53.969   0.009  23.096  1.00 20.03           N  
ATOM   1866  CA  GLU I  34      54.955   1.063  23.397  1.00 19.11           C  
ATOM   1867  C   GLU I  34      56.034   1.165  22.315  1.00 24.10           C  
ATOM   1868  O   GLU I  34      56.340   2.263  21.861  1.00 22.28           O  
ATOM   1869  CB  GLU I  34      55.570   0.830  24.776  1.00 21.27           C  
ATOM   1870  CG  GLU I  34      56.155   2.100  25.422  1.00 19.72           C  
ATOM   1871  CD  GLU I  34      56.607   1.800  26.847  0.00  0.00           C  
ATOM   1872  OE1 GLU I  34      56.799   0.612  27.220  0.00  0.00           O  
ATOM   1873  OE2 GLU I  34      56.799   2.744  27.660  0.00  0.00           O  
ATOM   1874  N   LYS I  35      56.392   0.035  21.709  1.00 14.72           N  
ATOM   1875  CA  LYS I  35      57.335   0.079  20.587  1.00  6.00           C  
ATOM   1876  C   LYS I  35      56.647   0.494  19.318  1.00  6.00           C  
ATOM   1877  O   LYS I  35      57.328   1.089  18.495  1.00  9.10           O  
ATOM   1878  CB  LYS I  35      57.918  -1.299  20.328  1.00  6.00           C  
ATOM   1879  CG  LYS I  35      58.899  -1.605  21.437  1.00 25.96           C  
ATOM   1880  CD  LYS I  35      59.530  -2.979  21.247  1.00 31.01           C  
ATOM   1881  CE  LYS I  35      60.758  -3.106  22.184  1.00 37.97           C  
ATOM   1882  NZ  LYS I  35      61.466  -4.404  22.023  1.00 39.18           N  
ATOM   1883  N   TYR I  36      55.421   0.063  19.134  1.00  6.00           N  
ATOM   1884  CA  TYR I  36      54.759   0.399  17.864  1.00  6.00           C  
ATOM   1885  C   TYR I  36      54.119   1.801  17.844  1.00  6.00           C  
ATOM   1886  O   TYR I  36      53.722   2.297  16.782  1.00  6.00           O  
ATOM   1887  CB  TYR I  36      53.792  -0.709  17.375  1.00  6.00           C  
ATOM   1888  CG  TYR I  36      53.689  -0.630  15.839  1.00 23.53           C  
ATOM   1889  CD1 TYR I  36      54.866  -0.562  15.095  1.00 26.52           C  
ATOM   1890  CD2 TYR I  36      52.459  -0.678  15.194  1.00 23.18           C  
ATOM   1891  CE1 TYR I  36      54.846  -0.588  13.679  1.00 26.47           C  
ATOM   1892  CE2 TYR I  36      52.396  -0.679  13.777  1.00 26.35           C  
ATOM   1893  CZ  TYR I  36      53.599  -0.659  13.004  1.00 30.22           C  
ATOM   1894  OH  TYR I  36      53.562  -0.723  11.602  1.00 22.44           O  
ATOM   1895  N   ASN I  37      54.014   2.403  19.016  1.00  7.10           N  
ATOM   1896  CA  ASN I  37      53.280   3.680  19.173  1.00  9.01           C  
ATOM   1897  C   ASN I  37      51.811   3.556  18.712  1.00 10.60           C  
ATOM   1898  O   ASN I  37      51.299   4.347  17.908  1.00  9.51           O  
ATOM   1899  CB  ASN I  37      54.028   4.882  18.513  1.00 11.21           C  
ATOM   1900  CG  ASN I  37      53.389   6.196  18.995  1.00 20.69           C  
ATOM   1901  OD1 ASN I  37      53.306   6.434  20.203  1.00 20.09           O  
ATOM   1902  ND2 ASN I  37      52.935   7.009  18.055  1.00 18.48           N  
ATOM   1903  N   LYS I  38      51.239   2.403  19.046  1.00 21.51           N  
ATOM   1904  CA  LYS I  38      49.857   2.010  18.678  1.00 20.71           C  
ATOM   1905  C   LYS I  38      49.203   1.228  19.807  1.00 22.34           C  
ATOM   1906  O   LYS I  38      49.771   0.266  20.330  1.00 18.61           O  
ATOM   1907  CB  LYS I  38      49.811   1.101  17.450  1.00 19.99           C  
ATOM   1908  CG  LYS I  38      48.367   0.906  16.947  1.00 25.63           C  
ATOM   1909  CD  LYS I  38      48.397   0.291  15.555  1.00 31.67           C  
ATOM   1910  CE  LYS I  38      47.030   0.312  14.841  1.00 34.37           C  
ATOM   1911  NZ  LYS I  38      47.076  -0.601  13.654  1.00 35.39           N  
ATOM   1912  N   LYS I  39      47.974   1.593  20.074  1.00 27.33           N  
ATOM   1913  CA  LYS I  39      47.234   0.807  21.047  1.00 27.00           C  
ATOM   1914  C   LYS I  39      46.333  -0.183  20.338  1.00 24.60           C  
ATOM   1915  O   LYS I  39      45.599   0.196  19.432  1.00 26.63           O  
ATOM   1916  CB  LYS I  39      46.420   1.688  21.989  1.00 24.60           C  
ATOM   1917  CG  LYS I  39      47.345   2.442  22.940  1.00 51.05           C  
ATOM   1918  CD  LYS I  39      46.493   3.166  23.984  1.00 55.84           C  
ATOM   1919  CE  LYS I  39      47.322   4.075  24.909  1.00 56.98           C  
ATOM   1920  NZ  LYS I  39      46.399   4.896  25.717  1.00 56.17           N  
ATOM   1921  N   PHE I  40      46.476  -1.424  20.711  1.00 23.43           N  
ATOM   1922  CA  PHE I  40      45.653  -2.451  20.104  1.00 24.30           C  
ATOM   1923  C   PHE I  40      44.499  -2.719  21.061  1.00 30.97           C  
ATOM   1924  O   PHE I  40      44.761  -3.292  22.125  1.00 28.10           O  
ATOM   1925  CB  PHE I  40      46.473  -3.737  19.887  1.00 21.07           C  
ATOM   1926  CG  PHE I  40      47.687  -3.456  18.984  1.00 21.59           C  
ATOM   1927  CD1 PHE I  40      47.531  -3.375  17.619  1.00 21.48           C  
ATOM   1928  CD2 PHE I  40      48.927  -3.255  19.553  1.00 19.70           C  
ATOM   1929  CE1 PHE I  40      48.632  -3.093  16.812  1.00 22.31           C  
ATOM   1930  CE2 PHE I  40      50.017  -2.980  18.760  1.00 19.61           C  
ATOM   1931  CZ  PHE I  40      49.875  -2.894  17.386  1.00 22.03           C  
ATOM   1932  N   PRO I  43      43.294  -2.268  20.653  1.00 32.16           N  
ATOM   1933  CA  PRO I  43      41.984  -2.549  21.378  1.00 31.13           C  
ATOM   1934  C   PRO I  43      41.651  -4.038  21.599  1.00 30.49           C  
ATOM   1935  O   PRO I  43      41.321  -4.442  22.713  1.00 29.71           O  
ATOM   1936  CB  PRO I  43      40.931  -2.011  20.404  1.00 30.20           C  
ATOM   1937  CG  PRO I  43      41.678  -1.192  19.348  1.00 39.00           C  
ATOM   1938  CD  PRO I  43      43.079  -1.759  19.275  1.00 36.49           C  
ATOM   1939  N   VAL I  44      41.813  -4.819  20.523  1.00 18.81           N  
ATOM   1940  CA  VAL I  44      41.707  -6.278  20.422  1.00 14.78           C  
ATOM   1941  C   VAL I  44      43.104  -6.924  20.354  1.00 19.97           C  
ATOM   1942  O   VAL I  44      44.012  -6.341  19.757  1.00 18.23           O  
ATOM   1943  CB  VAL I  44      40.931  -6.607  19.137  1.00 13.74           C  
ATOM   1944  CG1 VAL I  44      40.527  -8.084  19.119  1.00 10.94           C  
ATOM   1945  CG2 VAL I  44      39.757  -5.633  18.891  1.00  7.48           C  
ATOM   1946  N   PHE I  45      43.309  -8.033  21.083  1.00 19.17           N  
ATOM   1947  CA  PHE I  45      44.620  -8.697  21.198  1.00 12.03           C  
ATOM   1948  C   PHE I  45      44.446 -10.205  21.359  1.00 13.22           C  
ATOM   1949  O   PHE I  45      44.659 -10.792  22.426  1.00 15.38           O  
ATOM   1950  CB  PHE I  45      45.406  -8.138  22.385  1.00 11.03           C  
ATOM   1951  CG  PHE I  45      46.902  -8.274  22.127  1.00 11.86           C  
ATOM   1952  CD1 PHE I  45      47.439  -7.614  21.037  1.00 18.33           C  
ATOM   1953  CD2 PHE I  45      47.701  -9.025  22.963  1.00 11.14           C  
ATOM   1954  CE1 PHE I  45      48.799  -7.694  20.765  1.00 15.07           C  
ATOM   1955  CE2 PHE I  45      49.064  -9.104  22.715  1.00 13.98           C  
ATOM   1956  CZ  PHE I  45      49.613  -8.436  21.607  1.00 14.86           C  
ATOM   1957  N   LYS I  46      43.995 -10.797  20.307  1.00 13.44           N  
ATOM   1958  CA  LYS I  46      43.699 -12.213  20.432  1.00 18.10           C  
ATOM   1959  C   LYS I  46      44.667 -13.181  19.741  1.00 15.21           C  
ATOM   1960  O   LYS I  46      44.627 -13.347  18.520  1.00 13.43           O  
ATOM   1961  CB  LYS I  46      42.220 -12.507  20.060  1.00 17.97           C  
ATOM   1962  CG  LYS I  46      41.625 -13.423  21.153  1.00 31.45           C  
ATOM   1963  CD  LYS I  46      40.595 -14.451  20.637  1.00 32.14           C  
ATOM   1964  CE  LYS I  46      40.184 -15.432  21.751  0.00  0.00           C  
ATOM   1965  NZ  LYS I  46      39.706 -14.691  22.925  0.00  0.00           N  
ATOM   1966  N   ALA I  47      45.341 -13.948  20.579  1.00  7.66           N  
ATOM   1967  CA  ALA I  47      46.165 -15.072  20.091  1.00  6.46           C  
ATOM   1968  C   ALA I  47      45.329 -15.993  19.218  1.00 11.43           C  
ATOM   1969  O   ALA I  47      44.242 -16.419  19.583  1.00 11.29           O  
ATOM   1970  CB  ALA I  47      46.784 -15.894  21.246  1.00  6.00           C  
ATOM   1971  N   VAL I  48      45.827 -16.254  18.056  1.00 11.24           N  
ATOM   1972  CA  VAL I  48      45.198 -17.182  17.125  1.00  6.00           C  
ATOM   1973  C   VAL I  48      46.080 -18.443  16.957  1.00 12.30           C  
ATOM   1974  O   VAL I  48      45.692 -19.590  17.178  1.00 10.38           O  
ATOM   1975  CB  VAL I  48      45.090 -16.338  15.839  1.00  7.14           C  
ATOM   1976  CG1 VAL I  48      44.634 -17.129  14.632  1.00 19.92           C  
ATOM   1977  CG2 VAL I  48      44.178 -15.120  16.017  1.00 14.18           C  
ATOM   1978  N   SER I  49      47.336 -18.265  16.683  1.00 14.67           N  
ATOM   1979  CA  SER I  49      48.195 -19.432  16.455  1.00 11.28           C  
ATOM   1980  C   SER I  49      49.541 -19.314  17.165  1.00 15.03           C  
ATOM   1981  O   SER I  49      49.906 -18.212  17.598  1.00 11.65           O  
ATOM   1982  CB  SER I  49      48.482 -19.425  14.977  1.00  6.00           C  
ATOM   1983  OG  SER I  49      47.578 -20.377  14.594  1.00 28.05           O  
ATOM   1984  N   PHE I  50      50.251 -20.446  17.159  1.00 11.37           N  
ATOM   1985  CA  PHE I  50      51.636 -20.521  17.640  1.00 13.19           C  
ATOM   1986  C   PHE I  50      52.514 -21.622  17.060  1.00 14.19           C  
ATOM   1987  O   PHE I  50      52.025 -22.705  16.777  1.00  9.02           O  
ATOM   1988  CB  PHE I  50      51.881 -20.353  19.160  1.00  9.91           C  
ATOM   1989  CG  PHE I  50      51.681 -21.667  19.918  1.00 20.00           C  
ATOM   1990  CD1 PHE I  50      50.403 -22.150  20.121  1.00 21.19           C  
ATOM   1991  CD2 PHE I  50      52.773 -22.346  20.404  1.00 16.24           C  
ATOM   1992  CE1 PHE I  50      50.215 -23.302  20.835  1.00 18.32           C  
ATOM   1993  CE2 PHE I  50      52.595 -23.507  21.101  1.00 18.52           C  
ATOM   1994  CZ  PHE I  50      51.314 -23.976  21.324  1.00 21.78           C  
ATOM   1995  N   LYS I  51      53.818 -21.337  17.204  1.00 17.75           N  
ATOM   1996  CA  LYS I  51      54.959 -22.251  17.099  1.00  9.32           C  
ATOM   1997  C   LYS I  51      55.895 -22.032  18.265  1.00  6.00           C  
ATOM   1998  O   LYS I  51      56.053 -20.947  18.826  1.00  7.17           O  
ATOM   1999  CB  LYS I  51      55.790 -22.051  15.837  1.00  6.00           C  
ATOM   2000  CG  LYS I  51      55.001 -22.254  14.560  1.00  6.00           C  
ATOM   2001  CD  LYS I  51      55.962 -22.132  13.398  1.00  6.96           C  
ATOM   2002  CE  LYS I  51      55.393 -22.870  12.166  1.00 13.81           C  
ATOM   2003  NZ  LYS I  51      56.430 -23.032  11.154  1.00 17.19           N  
ATOM   2004  N   SER I  52      56.537 -23.089  18.544  1.00  7.26           N  
ATOM   2005  CA  SER I  52      57.578 -23.033  19.543  1.00  8.80           C  
ATOM   2006  C   SER I  52      58.915 -23.416  18.924  1.00 11.20           C  
ATOM   2007  O   SER I  52      58.949 -24.364  18.151  1.00  8.71           O  
ATOM   2008  CB  SER I  52      57.255 -24.091  20.593  1.00  7.27           C  
ATOM   2009  OG  SER I  52      56.717 -23.324  21.620  1.00 25.01           O  
ATOM   2010  N   GLN I  53      59.979 -22.926  19.547  1.00 12.88           N  
ATOM   2011  CA  GLN I  53      61.274 -23.575  19.362  1.00 12.76           C  
ATOM   2012  C   GLN I  53      62.030 -23.546  20.674  1.00  9.88           C  
ATOM   2013  O   GLN I  53      61.925 -22.562  21.412  1.00 10.13           O  
ATOM   2014  CB  GLN I  53      62.134 -23.149  18.131  1.00 10.96           C  
ATOM   2015  CG  GLN I  53      62.964 -21.928  18.446  1.00 11.85           C  
ATOM   2016  CD  GLN I  53      64.028 -21.537  17.430  1.00  6.85           C  
ATOM   2017  OE1 GLN I  53      64.308 -20.349  17.399  1.00 12.01           O  
ATOM   2018  NE2 GLN I  53      64.642 -22.410  16.696  1.00  6.00           N  
ATOM   2019  N   VAL I  54      62.693 -24.658  20.894  1.00 20.73           N  
ATOM   2020  CA  VAL I  54      63.511 -24.931  22.067  1.00 21.56           C  
ATOM   2021  C   VAL I  54      64.946 -24.423  21.860  1.00 21.10           C  
ATOM   2022  O   VAL I  54      65.658 -24.903  20.981  1.00 21.37           O  
ATOM   2023  CB  VAL I  54      63.477 -26.472  22.257  1.00 21.83           C  
ATOM   2024  CG1 VAL I  54      64.340 -27.015  23.393  1.00 19.99           C  
ATOM   2025  CG2 VAL I  54      62.051 -27.029  22.362  1.00 18.62           C  
ATOM   2026  N   VAL I  55      65.316 -23.404  22.611  1.00  6.00           N  
ATOM   2027  CA  VAL I  55      66.646 -22.777  22.655  1.00  6.00           C  
ATOM   2028  C   VAL I  55      67.144 -22.960  24.079  1.00  7.44           C  
ATOM   2029  O   VAL I  55      66.678 -23.920  24.695  1.00  9.15           O  
ATOM   2030  CB  VAL I  55      66.608 -21.312  22.190  1.00  6.00           C  
ATOM   2031  CG1 VAL I  55      66.220 -21.341  20.717  1.00  6.00           C  
ATOM   2032  CG2 VAL I  55      65.583 -20.471  22.959  1.00  6.00           C  
ATOM   2033  N   ALA I  56      67.949 -22.033  24.620  1.00  8.02           N  
ATOM   2034  CA  ALA I  56      68.249 -22.067  26.051  1.00  6.00           C  
ATOM   2035  C   ALA I  56      67.100 -21.433  26.841  1.00 12.47           C  
ATOM   2036  O   ALA I  56      67.322 -20.516  27.608  1.00 12.08           O  
ATOM   2037  CB  ALA I  56      69.599 -21.439  26.425  1.00  6.00           C  
ATOM   2038  N   GLY I  57      65.886 -21.885  26.577  1.00 10.74           N  
ATOM   2039  CA  GLY I  57      64.623 -21.225  26.935  1.00  6.00           C  
ATOM   2040  C   GLY I  57      63.608 -21.610  25.875  1.00  6.00           C  
ATOM   2041  O   GLY I  57      63.739 -22.686  25.306  1.00  7.30           O  
ATOM   2042  N   THR I  58      62.632 -20.784  25.627  1.00  6.00           N  
ATOM   2043  CA  THR I  58      61.668 -21.074  24.551  1.00  6.00           C  
ATOM   2044  C   THR I  58      61.294 -19.801  23.813  1.00 10.37           C  
ATOM   2045  O   THR I  58      60.796 -18.858  24.439  1.00  9.49           O  
ATOM   2046  CB  THR I  58      60.352 -21.712  25.062  1.00  6.00           C  
ATOM   2047  OG1 THR I  58      60.625 -22.891  25.826  1.00  9.32           O  
ATOM   2048  CG2 THR I  58      59.374 -22.142  23.954  1.00  6.00           C  
ATOM   2049  N   ASN I  59      61.445 -19.865  22.492  1.00  7.78           N  
ATOM   2050  CA  ASN I  59      60.906 -18.808  21.627  1.00  6.13           C  
ATOM   2051  C   ASN I  59      59.473 -19.179  21.272  1.00  6.00           C  
ATOM   2052  O   ASN I  59      59.264 -20.279  20.764  1.00  6.62           O  
ATOM   2053  CB  ASN I  59      61.744 -18.623  20.328  1.00  6.00           C  
ATOM   2054  CG  ASN I  59      63.105 -18.023  20.686  1.00  6.54           C  
ATOM   2055  OD1 ASN I  59      63.185 -17.037  21.410  1.00  6.50           O  
ATOM   2056  ND2 ASN I  59      64.166 -18.614  20.200  1.00  6.00           N  
ATOM   2057  N   TYR I  60      58.558 -18.251  21.447  1.00  6.00           N  
ATOM   2058  CA  TYR I  60      57.218 -18.469  20.923  1.00  6.00           C  
ATOM   2059  C   TYR I  60      56.966 -17.556  19.744  1.00  6.00           C  
ATOM   2060  O   TYR I  60      57.109 -16.345  19.885  1.00  7.44           O  
ATOM   2061  CB  TYR I  60      56.182 -18.077  21.962  1.00  6.00           C  
ATOM   2062  CG  TYR I  60      56.187 -19.100  23.079  1.00  6.68           C  
ATOM   2063  CD1 TYR I  60      55.563 -20.323  22.901  1.00  6.17           C  
ATOM   2064  CD2 TYR I  60      56.875 -18.800  24.234  1.00  9.01           C  
ATOM   2065  CE1 TYR I  60      55.595 -21.251  23.930  1.00  8.12           C  
ATOM   2066  CE2 TYR I  60      56.907 -19.711  25.269  1.00  9.88           C  
ATOM   2067  CZ  TYR I  60      56.250 -20.923  25.117  1.00 11.47           C  
ATOM   2068  OH  TYR I  60      56.279 -21.785  26.150  1.00 12.38           O  
ATOM   2069  N   PHE I  61      56.419 -18.106  18.701  1.00  6.00           N  
ATOM   2070  CA  PHE I  61      56.071 -17.297  17.511  1.00  8.95           C  
ATOM   2071  C   PHE I  61      54.557 -17.242  17.418  1.00  7.04           C  
ATOM   2072  O   PHE I  61      53.950 -18.301  17.358  1.00  6.00           O  
ATOM   2073  CB  PHE I  61      56.635 -17.954  16.219  1.00  6.00           C  
ATOM   2074  CG  PHE I  61      58.182 -17.931  16.207  1.00  6.75           C  
ATOM   2075  CD1 PHE I  61      58.841 -16.782  15.816  1.00  8.52           C  
ATOM   2076  CD2 PHE I  61      58.926 -19.037  16.591  1.00  7.94           C  
ATOM   2077  CE1 PHE I  61      60.237 -16.744  15.824  1.00  6.82           C  
ATOM   2078  CE2 PHE I  61      60.331 -18.989  16.608  1.00  6.00           C  
ATOM   2079  CZ  PHE I  61      60.980 -17.841  16.230  1.00  6.00           C  
ATOM   2080  N   ILE I  62      53.982 -16.091  17.683  1.00  7.06           N  
ATOM   2081  CA  ILE I  62      52.535 -16.027  17.948  1.00  6.00           C  
ATOM   2082  C   ILE I  62      51.786 -15.157  16.964  1.00  6.00           C  
ATOM   2083  O   ILE I  62      52.172 -14.020  16.786  1.00  7.19           O  
ATOM   2084  CB  ILE I  62      52.272 -15.563  19.386  1.00  6.00           C  
ATOM   2085  CG1 ILE I  62      53.105 -16.404  20.382  1.00  6.00           C  
ATOM   2086  CG2 ILE I  62      50.776 -15.657  19.686  1.00  6.00           C  
ATOM   2087  CD1 ILE I  62      52.917 -15.942  21.818  1.00  6.00           C  
ATOM   2088  N   LYS I  63      50.753 -15.670  16.333  1.00  6.87           N  
ATOM   2089  CA  LYS I  63      49.911 -14.820  15.480  1.00  6.20           C  
ATOM   2090  C   LYS I  63      48.737 -14.302  16.322  1.00 10.62           C  
ATOM   2091  O   LYS I  63      48.046 -15.048  17.024  1.00  7.98           O  
ATOM   2092  CB  LYS I  63      49.393 -15.626  14.267  1.00 10.48           C  
ATOM   2093  CG  LYS I  63      48.356 -14.863  13.378  1.00  7.78           C  
ATOM   2094  CD  LYS I  63      47.551 -15.851  12.495  1.00  7.66           C  
ATOM   2095  CE  LYS I  63      48.350 -16.353  11.288  1.00 11.34           C  
ATOM   2096  NZ  LYS I  63      48.435 -15.281  10.260  1.00  7.04           N  
ATOM   2097  N   VAL I  64      48.697 -13.012  16.450  1.00  7.21           N  
ATOM   2098  CA  VAL I  64      47.696 -12.394  17.293  1.00  6.00           C  
ATOM   2099  C   VAL I  64      46.723 -11.577  16.433  1.00 10.66           C  
ATOM   2100  O   VAL I  64      47.156 -10.756  15.611  1.00  9.43           O  
ATOM   2101  CB  VAL I  64      48.448 -11.508  18.279  1.00  6.00           C  
ATOM   2102  CG1 VAL I  64      47.469 -10.628  19.054  1.00  6.75           C  
ATOM   2103  CG2 VAL I  64      49.231 -12.366  19.266  1.00  6.00           C  
ATOM   2104  N   HIS I  65      45.416 -11.849  16.556  1.00 15.00           N  
ATOM   2105  CA  HIS I  65      44.384 -11.069  15.808  1.00 16.28           C  
ATOM   2106  C   HIS I  65      44.098  -9.732  16.479  1.00 10.97           C  
ATOM   2107  O   HIS I  65      44.037  -9.692  17.704  1.00 14.66           O  
ATOM   2108  CB  HIS I  65      43.046 -11.822  15.657  1.00 17.41           C  
ATOM   2109  CG  HIS I  65      42.020 -10.894  14.965  1.00 34.12           C  
ATOM   2110  ND1 HIS I  65      40.918 -10.407  15.665  1.00 32.76           N  
ATOM   2111  CD2 HIS I  65      42.033 -10.349  13.725  1.00 32.71           C  
ATOM   2112  CE1 HIS I  65      40.233  -9.535  14.793  1.00 33.80           C  
ATOM   2113  NE2 HIS I  65      40.941  -9.492  13.578  1.00 30.82           N  
ATOM   2114  N   VAL I  66      44.416  -8.672  15.791  1.00  8.83           N  
ATOM   2115  CA  VAL I  66      44.610  -7.448  16.584  1.00 13.14           C  
ATOM   2116  C   VAL I  66      43.544  -6.389  16.239  1.00 15.83           C  
ATOM   2117  O   VAL I  66      43.634  -5.195  16.533  1.00 13.34           O  
ATOM   2118  CB  VAL I  66      46.053  -6.987  16.345  1.00  8.84           C  
ATOM   2119  CG1 VAL I  66      46.242  -6.022  15.160  1.00  6.00           C  
ATOM   2120  CG2 VAL I  66      46.838  -6.687  17.634  1.00  6.12           C  
ATOM   2121  N   GLY I  67      42.808  -6.749  15.263  1.00 16.04           N  
ATOM   2122  CA  GLY I  67      42.429  -5.640  14.451  1.00 18.30           C  
ATOM   2123  C   GLY I  67      41.122  -5.989  13.841  1.00 16.19           C  
ATOM   2124  O   GLY I  67      40.158  -5.737  14.544  1.00 22.62           O  
ATOM   2125  N   ASP I  68      41.117  -6.034  12.571  1.00 28.55           N  
ATOM   2126  CA  ASP I  68      39.846  -6.058  11.871  1.00 32.05           C  
ATOM   2127  C   ASP I  68      39.945  -7.298  11.027  1.00 32.12           C  
ATOM   2128  O   ASP I  68      39.578  -8.386  11.470  1.00 33.40           O  
ATOM   2129  CB  ASP I  68      39.692  -4.855  10.906  1.00 33.89           C  
ATOM   2130  CG  ASP I  68      39.258  -3.608  11.669  0.00  0.00           C  
ATOM   2131  OD1 ASP I  68      40.101  -2.936  12.319  0.00  0.00           O  
ATOM   2132  OD2 ASP I  68      38.051  -3.249  11.658  0.00  0.00           O  
ATOM   2133  N   GLU I  92      40.752  -7.141  10.016  1.00 32.61           N  
ATOM   2134  CA  GLU I  92      41.226  -8.356   9.365  1.00 35.27           C  
ATOM   2135  C   GLU I  92      42.761  -8.350   9.477  1.00 38.58           C  
ATOM   2136  O   GLU I  92      43.477  -8.839   8.604  1.00 35.73           O  
ATOM   2137  CB  GLU I  92      40.712  -8.345   7.907  1.00 34.40           C  
ATOM   2138  CG  GLU I  92      40.648  -9.743   7.262  0.00  0.00           C  
ATOM   2139  CD  GLU I  92      39.482 -10.517   7.868  0.00  0.00           C  
ATOM   2140  OE1 GLU I  92      38.464  -9.904   8.290  0.00  0.00           O  
ATOM   2141  OE2 GLU I  92      39.524 -11.773   7.945  0.00  0.00           O  
ATOM   2142  N   ASP I  93      43.205  -7.598  10.478  1.00 16.87           N  
ATOM   2143  CA  ASP I  93      44.567  -7.157  10.724  1.00 13.34           C  
ATOM   2144  C   ASP I  93      45.190  -7.884  11.932  1.00 16.21           C  
ATOM   2145  O   ASP I  93      44.593  -8.013  13.011  1.00 11.63           O  
ATOM   2146  CB  ASP I  93      44.595  -5.609  10.858  1.00  9.48           C  
ATOM   2147  CG  ASP I  93      46.022  -5.162  11.124  1.00 43.86           C  
ATOM   2148  OD1 ASP I  93      46.974  -5.723  10.505  1.00 43.26           O  
ATOM   2149  OD2 ASP I  93      46.260  -4.234  11.953  1.00 43.24           O  
ATOM   2150  N   PHE I  94      46.382  -8.448  11.625  1.00 10.28           N  
ATOM   2151  CA  PHE I  94      47.176  -9.322  12.510  1.00  6.88           C  
ATOM   2152  C   PHE I  94      48.602  -8.823  12.719  1.00  7.28           C  
ATOM   2153  O   PHE I  94      49.162  -8.118  11.879  1.00 11.04           O  
ATOM   2154  CB  PHE I  94      47.264 -10.686  11.840  1.00  6.36           C  
ATOM   2155  CG  PHE I  94      45.904 -11.413  11.821  1.00 21.70           C  
ATOM   2156  CD1 PHE I  94      44.941 -11.080  10.883  1.00 19.45           C  
ATOM   2157  CD2 PHE I  94      45.690 -12.473  12.679  1.00 20.53           C  
ATOM   2158  CE1 PHE I  94      43.759 -11.805  10.788  1.00 18.37           C  
ATOM   2159  CE2 PHE I  94      44.521 -13.221  12.584  1.00 21.02           C  
ATOM   2160  CZ  PHE I  94      43.560 -12.890  11.633  1.00 21.90           C  
ATOM   2161  N   VAL I  95      49.195  -9.288  13.767  1.00  6.00           N  
ATOM   2162  CA  VAL I  95      50.597  -9.028  14.041  1.00  6.00           C  
ATOM   2163  C   VAL I  95      51.252 -10.338  14.512  1.00  9.53           C  
ATOM   2164  O   VAL I  95      50.616 -11.077  15.256  1.00  8.89           O  
ATOM   2165  CB  VAL I  95      50.527  -7.987  15.180  1.00  6.00           C  
ATOM   2166  CG1 VAL I  95      51.371  -8.268  16.411  1.00 16.91           C  
ATOM   2167  CG2 VAL I  95      50.698  -6.538  14.687  1.00 19.19           C  
ATOM   2168  N   HIS I  96      52.501 -10.648  14.115  1.00 13.83           N  
ATOM   2169  CA  HIS I  96      53.238 -11.861  14.626  1.00  9.24           C  
ATOM   2170  C   HIS I  96      54.295 -11.465  15.665  1.00 13.56           C  
ATOM   2171  O   HIS I  96      54.934 -10.423  15.513  1.00 15.89           O  
ATOM   2172  CB  HIS I  96      53.948 -12.716  13.542  1.00  8.10           C  
ATOM   2173  CG  HIS I  96      53.018 -13.337  12.487  1.00  7.18           C  
ATOM   2174  ND1 HIS I  96      51.640 -13.086  12.473  1.00  8.76           N  
ATOM   2175  CD2 HIS I  96      53.335 -14.065  11.421  1.00  6.00           C  
ATOM   2176  CE1 HIS I  96      51.105 -13.709  11.358  1.00  6.50           C  
ATOM   2177  NE2 HIS I  96      52.188 -14.315  10.709  1.00  8.86           N  
ATOM   2178  N   LEU I  97      54.395 -12.240  16.733  1.00  6.00           N  
ATOM   2179  CA  LEU I  97      55.193 -11.896  17.901  1.00  6.00           C  
ATOM   2180  C   LEU I  97      56.326 -12.895  18.042  1.00  6.00           C  
ATOM   2181  O   LEU I  97      56.087 -14.095  17.947  1.00  6.00           O  
ATOM   2182  CB  LEU I  97      54.280 -12.096  19.111  1.00  6.00           C  
ATOM   2183  CG  LEU I  97      53.520 -10.874  19.632  1.00  6.00           C  
ATOM   2184  CD1 LEU I  97      52.871 -10.054  18.554  1.00  6.00           C  
ATOM   2185  CD2 LEU I  97      52.448 -11.337  20.623  1.00  6.00           C  
ATOM   2186  N   ARG I  98      57.481 -12.424  18.451  1.00  6.00           N  
ATOM   2187  CA  ARG I  98      58.517 -13.404  18.797  1.00  6.50           C  
ATOM   2188  C   ARG I  98      58.846 -13.209  20.255  1.00 10.89           C  
ATOM   2189  O   ARG I  98      59.364 -12.147  20.586  1.00 12.20           O  
ATOM   2190  CB  ARG I  98      59.849 -13.289  17.978  1.00 12.81           C  
ATOM   2191  CG  ARG I  98      60.875 -14.420  18.285  1.00  6.00           C  
ATOM   2192  CD  ARG I  98      62.325 -13.985  18.497  1.00  6.00           C  
ATOM   2193  NE  ARG I  98      63.109 -14.265  17.329  1.00  6.00           N  
ATOM   2194  CZ  ARG I  98      64.308 -14.870  17.389  1.00  6.00           C  
ATOM   2195  NH1 ARG I  98      64.869 -15.257  18.510  1.00  6.00           N  
ATOM   2196  NH2 ARG I  98      64.919 -15.142  16.240  1.00  6.00           N  
ATOM   2197  N   VAL I  99      58.431 -14.142  21.089  1.00  6.00           N  
ATOM   2198  CA  VAL I  99      58.499 -13.900  22.532  1.00  6.00           C  
ATOM   2199  C   VAL I  99      59.498 -14.840  23.181  1.00  6.00           C  
ATOM   2200  O   VAL I  99      59.409 -16.035  22.955  1.00  6.76           O  
ATOM   2201  CB  VAL I  99      57.085 -14.118  23.137  1.00  6.00           C  
ATOM   2202  CG1 VAL I  99      57.033 -13.851  24.634  1.00  6.00           C  
ATOM   2203  CG2 VAL I  99      55.972 -13.320  22.456  1.00  6.00           C  
ATOM   2204  N   PHE I 100      60.419 -14.318  23.965  1.00  6.00           N  
ATOM   2205  CA  PHE I 100      61.390 -15.172  24.673  1.00  6.00           C  
ATOM   2206  C   PHE I 100      60.917 -15.501  26.084  1.00  7.27           C  
ATOM   2207  O   PHE I 100      60.786 -14.581  26.889  1.00  8.33           O  
ATOM   2208  CB  PHE I 100      62.776 -14.494  24.839  1.00  6.00           C  
ATOM   2209  CG  PHE I 100      63.816 -15.543  25.293  1.00  9.20           C  
ATOM   2210  CD1 PHE I 100      63.785 -16.817  24.770  1.00 10.16           C  
ATOM   2211  CD2 PHE I 100      64.760 -15.239  26.234  1.00 11.28           C  
ATOM   2212  CE1 PHE I 100      64.690 -17.785  25.196  1.00  9.97           C  
ATOM   2213  CE2 PHE I 100      65.683 -16.199  26.657  1.00 11.76           C  
ATOM   2214  CZ  PHE I 100      65.648 -17.474  26.140  1.00 10.13           C  
ATOM   2215  N   GLN I 101      60.849 -16.792  26.359  1.00  6.00           N  
ATOM   2216  CA  GLN I 101      60.672 -17.329  27.693  1.00  6.00           C  
ATOM   2217  C   GLN I 101      61.950 -18.063  28.165  1.00 11.03           C  
ATOM   2218  O   GLN I 101      62.465 -19.001  27.539  1.00  8.12           O  
ATOM   2219  CB  GLN I 101      59.480 -18.276  27.625  1.00  6.00           C  
ATOM   2220  CG  GLN I 101      59.373 -19.110  28.911  1.00 16.63           C  
ATOM   2221  CD  GLN I 101      58.126 -19.995  28.875  1.00 23.27           C  
ATOM   2222  OE1 GLN I 101      57.050 -19.563  29.288  1.00 22.97           O  
ATOM   2223  NE2 GLN I 101      58.258 -21.215  28.398  1.00 22.77           N  
ATOM   2224  N   SER I 102      62.502 -17.602  29.280  1.00 12.90           N  
ATOM   2225  CA  SER I 102      63.678 -18.184  29.962  1.00  8.83           C  
ATOM   2226  C   SER I 102      63.451 -19.595  30.527  1.00 15.20           C  
ATOM   2227  O   SER I 102      62.322 -19.992  30.825  1.00 13.76           O  
ATOM   2228  CB  SER I 102      64.031 -17.289  31.150  1.00 11.66           C  
ATOM   2229  OG  SER I 102      64.319 -15.993  30.629  1.00 25.30           O  
ATOM   2230  N   LEU I 102A     64.567 -20.218  30.874  1.00 10.03           N  
ATOM   2231  CA  LEU I 102A     64.565 -21.458  31.655  1.00  6.09           C  
ATOM   2232  C   LEU I 102A     64.051 -21.072  33.027  1.00  8.39           C  
ATOM   2233  O   LEU I 102A     64.251 -19.929  33.470  1.00  9.31           O  
ATOM   2234  CB  LEU I 102A     65.981 -22.082  31.806  1.00  6.44           C  
ATOM   2235  CG  LEU I 102A     66.474 -22.658  30.459  1.00 11.00           C  
ATOM   2236  CD1 LEU I 102A     67.983 -22.937  30.472  1.00  8.54           C  
ATOM   2237  CD2 LEU I 102A     65.660 -23.889  30.017  1.00  8.27           C  
ATOM   2238  N   PRO I 103      63.240 -21.996  33.502  1.00 24.08           N  
ATOM   2239  CA  PRO I 103      62.486 -21.824  34.763  1.00 24.43           C  
ATOM   2240  C   PRO I 103      63.353 -21.280  35.901  1.00 20.75           C  
ATOM   2241  O   PRO I 103      62.988 -20.342  36.613  1.00 19.43           O  
ATOM   2242  CB  PRO I 103      62.038 -23.257  35.054  1.00 24.59           C  
ATOM   2243  CG  PRO I 103      61.944 -23.955  33.711  1.00 25.57           C  
ATOM   2244  CD  PRO I 103      63.024 -23.320  32.865  1.00 27.17           C  
ATOM   2245  N   HIS I 104      64.514 -21.860  35.987  1.00 10.06           N  
ATOM   2246  CA  HIS I 104      65.402 -21.506  37.089  1.00 10.30           C  
ATOM   2247  C   HIS I 104      65.914 -20.083  37.008  1.00  7.46           C  
ATOM   2248  O   HIS I 104      66.549 -19.624  37.951  1.00  9.93           O  
ATOM   2249  CB  HIS I 104      66.586 -22.467  37.128  1.00 13.18           C  
ATOM   2250  CG  HIS I 104      67.632 -22.207  36.030  1.00 21.74           C  
ATOM   2251  ND1 HIS I 104      68.667 -21.324  36.305  1.00 20.08           N  
ATOM   2252  CD2 HIS I 104      67.766 -22.705  34.773  1.00 17.91           C  
ATOM   2253  CE1 HIS I 104      69.484 -21.269  35.157  1.00 24.16           C  
ATOM   2254  NE2 HIS I 104      68.925 -22.138  34.192  1.00 21.10           N  
ATOM   2255  N   GLU I 105      65.528 -19.415  35.948  1.00 13.38           N  
ATOM   2256  CA  GLU I 105      66.038 -18.071  35.747  1.00 14.50           C  
ATOM   2257  C   GLU I 105      65.112 -16.949  36.103  1.00 16.60           C  
ATOM   2258  O   GLU I 105      65.639 -15.899  36.484  1.00 17.61           O  
ATOM   2259  CB  GLU I 105      66.514 -17.814  34.336  1.00 15.64           C  
ATOM   2260  CG  GLU I 105      68.021 -18.009  34.397  1.00 41.21           C  
ATOM   2261  CD  GLU I 105      68.414 -18.122  32.962  1.00 41.57           C  
ATOM   2262  OE1 GLU I 105      67.812 -18.970  32.261  1.00 40.94           O  
ATOM   2263  OE2 GLU I 105      69.304 -17.367  32.485  1.00 42.82           O  
ATOM   2264  N   ASN I 105A     63.845 -17.295  36.090  1.00 26.58           N  
ATOM   2265  CA  ASN I 105A     62.839 -16.407  36.659  1.00 30.38           C  
ATOM   2266  C   ASN I 105A     62.969 -15.003  36.078  1.00 27.94           C  
ATOM   2267  O   ASN I 105A     63.040 -14.010  36.802  1.00 27.33           O  
ATOM   2268  CB  ASN I 105A     62.955 -16.394  38.224  1.00 34.42           C  
ATOM   2269  CG  ASN I 105A     61.687 -15.812  38.873  1.00 42.36           C  
ATOM   2270  OD1 ASN I 105A     61.800 -15.016  39.812  1.00 39.21           O  
ATOM   2271  ND2 ASN I 105A     60.522 -16.230  38.332  1.00 39.94           N  
ATOM   2272  N   LYS I 106      63.103 -14.962  34.771  1.00 26.78           N  
ATOM   2273  CA  LYS I 106      63.129 -13.656  34.059  1.00 24.72           C  
ATOM   2274  C   LYS I 106      61.782 -13.522  33.384  1.00 24.82           C  
ATOM   2275  O   LYS I 106      61.094 -14.519  33.173  1.00 25.34           O  
ATOM   2276  CB  LYS I 106      64.236 -13.565  32.988  1.00 21.43           C  
ATOM   2277  CG  LYS I 106      65.610 -13.416  33.644  1.00 31.16           C  
ATOM   2278  CD  LYS I 106      66.747 -13.792  32.686  1.00 32.60           C  
ATOM   2279  CE  LYS I 106      68.116 -13.782  33.412  1.00 35.17           C  
ATOM   2280  NZ  LYS I 106      69.147 -14.364  32.542  0.00  0.00           N  
ATOM   2281  N   PRO I 107      61.341 -12.317  33.306  1.00 17.87           N  
ATOM   2282  CA  PRO I 107      60.039 -12.066  32.685  1.00 17.52           C  
ATOM   2283  C   PRO I 107      60.063 -12.291  31.168  1.00 21.56           C  
ATOM   2284  O   PRO I 107      61.119 -12.342  30.549  1.00 19.68           O  
ATOM   2285  CB  PRO I 107      59.729 -10.624  33.063  1.00 17.54           C  
ATOM   2286  CG  PRO I 107      61.044 -10.024  33.548  1.00 14.13           C  
ATOM   2287  CD  PRO I 107      61.963 -11.161  33.945  1.00  9.23           C  
ATOM   2288  N   LEU I 108      58.901 -12.478  30.597  1.00 27.89           N  
ATOM   2289  CA  LEU I 108      58.762 -12.732  29.159  1.00 25.17           C  
ATOM   2290  C   LEU I 108      59.227 -11.503  28.384  1.00 27.58           C  
ATOM   2291  O   LEU I 108      58.907 -10.376  28.778  1.00 26.93           O  
ATOM   2292  CB  LEU I 108      57.259 -12.956  28.887  1.00 23.30           C  
ATOM   2293  CG  LEU I 108      57.021 -14.401  28.472  1.00 15.43           C  
ATOM   2294  CD1 LEU I 108      57.873 -15.395  29.261  1.00 14.44           C  
ATOM   2295  CD2 LEU I 108      55.529 -14.729  28.494  1.00 20.89           C  
ATOM   2296  N   THR I 109      59.936 -11.726  27.292  1.00  8.87           N  
ATOM   2297  CA  THR I 109      60.367 -10.551  26.507  1.00  6.68           C  
ATOM   2298  C   THR I 109      59.887 -10.605  25.066  1.00  6.00           C  
ATOM   2299  O   THR I 109      60.052 -11.650  24.453  1.00  7.51           O  
ATOM   2300  CB  THR I 109      61.887 -10.633  26.468  1.00  7.85           C  
ATOM   2301  OG1 THR I 109      62.381 -11.053  27.751  1.00 32.52           O  
ATOM   2302  CG2 THR I 109      62.481  -9.285  26.049  1.00 34.72           C  
ATOM   2303  N   LEU I 110      59.422  -9.502  24.545  1.00  7.11           N  
ATOM   2304  CA  LEU I 110      59.098  -9.386  23.114  1.00 11.90           C  
ATOM   2305  C   LEU I 110      60.404  -9.126  22.339  1.00 13.68           C  
ATOM   2306  O   LEU I 110      60.900  -8.010  22.400  1.00 14.05           O  
ATOM   2307  CB  LEU I 110      58.167  -8.183  22.922  1.00  6.00           C  
ATOM   2308  CG  LEU I 110      57.665  -8.005  21.492  1.00  6.00           C  
ATOM   2309  CD1 LEU I 110      56.800  -9.176  21.020  1.00  6.00           C  
ATOM   2310  CD2 LEU I 110      56.807  -6.735  21.394  1.00  6.00           C  
ATOM   2311  N   SER I 111      61.066 -10.158  21.830  1.00  6.83           N  
ATOM   2312  CA  SER I 111      62.352  -9.995  21.164  1.00  6.00           C  
ATOM   2313  C   SER I 111      62.129  -9.259  19.859  1.00  9.22           C  
ATOM   2314  O   SER I 111      62.926  -8.402  19.533  1.00 12.29           O  
ATOM   2315  CB  SER I 111      62.929 -11.342  20.772  1.00  6.00           C  
ATOM   2316  OG  SER I 111      62.947 -12.189  21.918  1.00 10.39           O  
ATOM   2317  N   ASN I 112      61.085  -9.567  19.131  1.00  9.46           N  
ATOM   2318  CA  ASN I 112      60.755  -8.950  17.836  1.00  6.00           C  
ATOM   2319  C   ASN I 112      59.243  -9.069  17.522  1.00  8.04           C  
ATOM   2320  O   ASN I 112      58.526  -9.885  18.105  1.00  7.42           O  
ATOM   2321  CB  ASN I 112      61.610  -9.642  16.744  1.00  6.00           C  
ATOM   2322  CG  ASN I 112      61.842  -8.727  15.532  1.00  9.61           C  
ATOM   2323  OD1 ASN I 112      61.372  -7.587  15.447  1.00  9.58           O  
ATOM   2324  ND2 ASN I 112      62.594  -9.252  14.596  1.00  9.09           N  
ATOM   2325  N   TYR I 113      58.774  -8.294  16.548  1.00  9.76           N  
ATOM   2326  CA  TYR I 113      57.412  -8.385  15.984  1.00  7.84           C  
ATOM   2327  C   TYR I 113      57.398  -8.035  14.494  1.00  6.00           C  
ATOM   2328  O   TYR I 113      58.237  -7.274  14.007  1.00  6.00           O  
ATOM   2329  CB  TYR I 113      56.367  -7.515  16.736  1.00  6.00           C  
ATOM   2330  CG  TYR I 113      56.770  -6.019  16.866  1.00  6.47           C  
ATOM   2331  CD1 TYR I 113      57.732  -5.653  17.806  1.00  6.47           C  
ATOM   2332  CD2 TYR I 113      56.156  -5.054  16.090  1.00  6.00           C  
ATOM   2333  CE1 TYR I 113      58.131  -4.341  17.941  1.00  6.00           C  
ATOM   2334  CE2 TYR I 113      56.549  -3.743  16.219  1.00  6.00           C  
ATOM   2335  CZ  TYR I 113      57.544  -3.402  17.120  1.00  7.12           C  
ATOM   2336  OH  TYR I 113      57.932  -2.103  17.242  1.00 11.77           O  
ATOM   2337  N   GLN I 114      56.342  -8.531  13.881  1.00  7.08           N  
ATOM   2338  CA  GLN I 114      55.940  -8.260  12.495  1.00  6.07           C  
ATOM   2339  C   GLN I 114      54.503  -7.727  12.429  1.00  9.68           C  
ATOM   2340  O   GLN I 114      53.602  -8.144  13.169  1.00  6.30           O  
ATOM   2341  CB  GLN I 114      56.040  -9.507  11.602  1.00  6.00           C  
ATOM   2342  CG  GLN I 114      57.429 -10.178  11.579  1.00  9.74           C  
ATOM   2343  CD  GLN I 114      57.360 -11.395  10.649  1.00 13.64           C  
ATOM   2344  OE1 GLN I 114      56.403 -12.176  10.670  1.00 12.49           O  
ATOM   2345  NE2 GLN I 114      58.385 -11.550   9.849  1.00 12.44           N  
ATOM   2346  N   THR I 115      54.373  -6.700  11.611  1.00 11.96           N  
ATOM   2347  CA  THR I 115      53.145  -5.918  11.491  1.00 11.54           C  
ATOM   2348  C   THR I 115      52.562  -6.089  10.096  1.00 12.00           C  
ATOM   2349  O   THR I 115      53.302  -6.520   9.211  1.00 10.49           O  
ATOM   2350  CB  THR I 115      53.525  -4.452  11.724  1.00  6.21           C  
ATOM   2351  OG1 THR I 115      53.991  -4.382  13.071  1.00 33.21           O  
ATOM   2352  CG2 THR I 115      52.301  -3.559  11.735  1.00 37.76           C  
ATOM   2353  N   ASN I 115A     51.289  -5.725   9.973  1.00 10.65           N  
ATOM   2354  CA  ASN I 115A     50.559  -5.640   8.728  1.00  9.82           C  
ATOM   2355  C   ASN I 115A     50.493  -7.020   8.119  1.00 10.60           C  
ATOM   2356  O   ASN I 115A     50.945  -7.253   6.996  1.00 14.65           O  
ATOM   2357  CB  ASN I 115A     51.221  -4.630   7.762  1.00 15.90           C  
ATOM   2358  CG  ASN I 115A     51.306  -3.243   8.405  1.00 24.95           C  
ATOM   2359  OD1 ASN I 115A     50.466  -2.920   9.251  1.00 22.44           O  
ATOM   2360  ND2 ASN I 115A     52.319  -2.488   7.985  1.00 21.36           N  
ATOM   2361  N   LYS I 116      50.186  -7.921   8.984  1.00  6.31           N  
ATOM   2362  CA  LYS I 116      50.242  -9.342   8.630  1.00  7.31           C  
ATOM   2363  C   LYS I 116      48.810  -9.858   8.386  1.00 10.80           C  
ATOM   2364  O   LYS I 116      47.831  -9.251   8.822  1.00 11.01           O  
ATOM   2365  CB  LYS I 116      50.902  -9.996   9.864  1.00  6.94           C  
ATOM   2366  CG  LYS I 116      51.866 -11.078   9.452  1.00 16.62           C  
ATOM   2367  CD  LYS I 116      53.065 -10.565   8.655  1.00 15.54           C  
ATOM   2368  CE  LYS I 116      53.847 -11.797   8.146  1.00 20.69           C  
ATOM   2369  NZ  LYS I 116      55.132 -11.412   7.581  1.00 18.85           N  
ATOM   2370  N   ALA I 117      48.643 -10.930   7.665  1.00 12.39           N  
ATOM   2371  CA  ALA I 117      47.295 -11.399   7.300  1.00  9.30           C  
ATOM   2372  C   ALA I 117      46.924 -12.687   8.012  1.00 13.36           C  
ATOM   2373  O   ALA I 117      47.797 -13.331   8.579  1.00 13.70           O  
ATOM   2374  CB  ALA I 117      47.234 -11.673   5.800  1.00 11.94           C  
ATOM   2375  N   LYS I 118      45.626 -12.940   8.049  1.00 20.80           N  
ATOM   2376  CA  LYS I 118      45.040 -14.127   8.695  1.00 20.08           C  
ATOM   2377  C   LYS I 118      45.782 -15.355   8.198  1.00 18.48           C  
ATOM   2378  O   LYS I 118      45.999 -16.277   8.990  1.00 17.78           O  
ATOM   2379  CB  LYS I 118      43.565 -14.224   8.201  1.00 21.05           C  
ATOM   2380  CG  LYS I 118      42.605 -15.114   9.049  1.00 37.26           C  
ATOM   2381  CD  LYS I 118      42.814 -16.633   8.903  0.00  0.00           C  
ATOM   2382  CE  LYS I 118      41.832 -17.442   9.769  0.00  0.00           C  
ATOM   2383  NZ  LYS I 118      42.056 -18.879   9.567  0.00  0.00           N  
ATOM   2384  N   HIS I 119      46.041 -15.304   6.880  1.00 35.91           N  
ATOM   2385  CA  HIS I 119      46.579 -16.435   6.099  1.00 38.90           C  
ATOM   2386  C   HIS I 119      48.071 -16.366   5.841  1.00 38.83           C  
ATOM   2387  O   HIS I 119      48.565 -17.232   5.121  1.00 37.12           O  
ATOM   2388  CB  HIS I 119      45.921 -16.509   4.709  1.00 39.96           C  
ATOM   2389  CG  HIS I 119      44.474 -17.043   4.862  1.00 62.15           C  
ATOM   2390  ND1 HIS I 119      43.410 -16.591   4.021  1.00 58.64           N  
ATOM   2391  CD2 HIS I 119      43.984 -17.923   5.787  1.00 57.52           C  
ATOM   2392  CE1 HIS I 119      42.237 -17.225   4.491  1.00 60.13           C  
ATOM   2393  NE2 HIS I 119      42.599 -18.051   5.593  1.00 56.59           N  
ATOM   2394  N   ASP I 120      48.727 -15.367   6.404  1.00 22.29           N  
ATOM   2395  CA  ASP I 120      50.181 -15.360   6.348  1.00 18.16           C  
ATOM   2396  C   ASP I 120      50.640 -16.410   7.342  1.00 24.31           C  
ATOM   2397  O   ASP I 120      50.057 -16.465   8.426  1.00 23.04           O  
ATOM   2398  CB  ASP I 120      50.753 -13.998   6.763  1.00 17.95           C  
ATOM   2399  CG  ASP I 120      50.459 -12.999   5.656  1.00 34.71           C  
ATOM   2400  OD1 ASP I 120      49.985 -13.388   4.558  1.00 36.52           O  
ATOM   2401  OD2 ASP I 120      50.693 -11.773   5.827  1.00 36.31           O  
ATOM   2402  N   GLU I 121      51.638 -17.199   6.912  1.00 30.75           N  
ATOM   2403  CA  GLU I 121      52.253 -18.280   7.692  1.00 29.08           C  
ATOM   2404  C   GLU I 121      53.137 -17.684   8.782  1.00 28.66           C  
ATOM   2405  O   GLU I 121      53.852 -16.697   8.532  1.00 28.51           O  
ATOM   2406  CB  GLU I 121      53.093 -19.247   6.804  1.00 28.34           C  
ATOM   2407  CG  GLU I 121      52.260 -20.015   5.760  0.00  0.00           C  
ATOM   2408  CD  GLU I 121      51.849 -19.079   4.629  0.00  0.00           C  
ATOM   2409  OE1 GLU I 121      52.584 -18.109   4.305  0.00  0.00           O  
ATOM   2410  OE2 GLU I 121      50.770 -19.273   4.007  0.00  0.00           O  
ATOM   2411  N   LEU I 122      53.047 -18.344   9.930  1.00 18.33           N  
ATOM   2412  CA  LEU I 122      53.922 -17.981  11.035  1.00 18.98           C  
ATOM   2413  C   LEU I 122      55.313 -18.482  10.682  1.00 23.52           C  
ATOM   2414  O   LEU I 122      55.556 -19.677  10.726  1.00 27.07           O  
ATOM   2415  CB  LEU I 122      53.514 -18.761  12.292  1.00 19.25           C  
ATOM   2416  CG  LEU I 122      52.714 -17.965  13.299  1.00  6.00           C  
ATOM   2417  CD1 LEU I 122      52.279 -18.887  14.443  1.00  6.00           C  
ATOM   2418  CD2 LEU I 122      53.492 -16.727  13.767  1.00  6.00           C  
ATOM   2419  N   THR I 123      56.213 -17.668  10.280  1.00 13.48           N  
ATOM   2420  CA  THR I 123      57.510 -18.267   9.957  1.00 12.76           C  
ATOM   2421  C   THR I 123      58.534 -17.760  10.956  1.00 14.53           C  
ATOM   2422  O   THR I 123      58.206 -16.916  11.775  1.00 14.28           O  
ATOM   2423  CB  THR I 123      57.930 -17.828   8.545  1.00 16.80           C  
ATOM   2424  OG1 THR I 123      57.871 -16.379   8.462  1.00 21.47           O  
ATOM   2425  CG2 THR I 123      57.043 -18.442   7.468  1.00 15.96           C  
ATOM   2426  N   TYR I 124      59.725 -18.280  10.877  1.00 19.37           N  
ATOM   2427  CA  TYR I 124      60.836 -17.861  11.748  1.00 15.50           C  
ATOM   2428  C   TYR I 124      61.351 -16.482  11.293  1.00 16.45           C  
ATOM   2429  O   TYR I 124      61.391 -16.184  10.099  1.00 14.31           O  
ATOM   2430  CB  TYR I 124      61.947 -18.938  11.711  1.00 12.02           C  
ATOM   2431  CG  TYR I 124      63.150 -18.572  12.601  1.00  6.55           C  
ATOM   2432  CD1 TYR I 124      64.129 -17.730  12.135  1.00  6.00           C  
ATOM   2433  CD2 TYR I 124      63.241 -19.074  13.878  1.00  8.16           C  
ATOM   2434  CE1 TYR I 124      65.162 -17.319  12.970  1.00  6.00           C  
ATOM   2435  CE2 TYR I 124      64.283 -18.685  14.718  1.00  6.00           C  
ATOM   2436  CZ  TYR I 124      65.223 -17.775  14.267  1.00  6.07           C  
ATOM   2437  OH  TYR I 124      66.234 -17.357  15.075  1.00  7.27           O  
ATOM   2438  N   PHE I 125      61.661 -15.635  12.274  1.00  9.03           N  
ATOM   2439  CA  PHE I 125      62.257 -14.290  12.108  1.00  7.09           C  
ATOM   2440  C   PHE I 125      62.989 -13.898  13.379  1.00  6.87           C  
ATOM   2441  O   PHE I 125      62.854 -14.512  14.440  1.00  7.09           O  
ATOM   2442  CB  PHE I 125      61.283 -13.136  11.713  1.00  6.77           C  
ATOM   2443  CG  PHE I 125      60.216 -12.815  12.796  1.00 10.42           C  
ATOM   2444  CD1 PHE I 125      59.124 -13.660  12.945  1.00  7.01           C  
ATOM   2445  CD2 PHE I 125      60.354 -11.730  13.633  1.00  6.00           C  
ATOM   2446  CE1 PHE I 125      58.186 -13.428  13.926  1.00  6.00           C  
ATOM   2447  CE2 PHE I 125      59.400 -11.491  14.611  1.00  6.05           C  
ATOM   2448  CZ  PHE I 125      58.315 -12.336  14.760  1.00  6.00           C  
ATOM   2449  OXT PHE I 125      63.763 -12.915  13.323  1.00  6.73           O  
TER    2450      PHE I 125                                                      
END
MOLECULE T0446_9_70.pdb
ATOM      5  N   GLY     9      65.185 -29.612  12.805  1.00 60.87           N  
ATOM      6  CA  GLY     9      64.461 -29.375  14.061  1.00 59.52           C  
ATOM      7  C   GLY     9      62.984 -29.191  13.759  1.00 57.77           C  
ATOM      8  O   GLY     9      62.643 -28.728  12.672  1.00 57.61           O  
ATOM      9  N   ASN    10      62.114 -29.563  14.705  1.00 55.20           N  
ATOM     10  CA  ASN    10      60.651 -29.470  14.527  1.00 53.29           C  
ATOM     11  C   ASN    10      60.014 -28.305  15.312  1.00 52.05           C  
ATOM     12  O   ASN    10      60.425 -27.996  16.430  1.00 52.82           O  
ATOM     13  CB  ASN    10      59.961 -30.783  14.932  1.00 52.26           C  
ATOM     14  CG  ASN    10      60.368 -31.975  14.048  1.00 53.17           C  
ATOM     15  OD1 ASN    10      60.525 -31.847  12.834  1.00 52.31           O  
ATOM     16  ND2 ASN    10      60.516 -33.139  14.663  1.00 52.23           N  
ATOM     17  N   ALA    11      59.012 -27.666  14.710  1.00 49.77           N  
ATOM     18  CA  ALA    11      58.198 -26.655  15.395  1.00 48.15           C  
ATOM     19  C   ALA    11      56.922 -27.335  15.898  1.00 45.50           C  
ATOM     20  O   ALA    11      56.339 -28.180  15.200  1.00 46.35           O  
ATOM     21  CB  ALA    11      57.864 -25.490  14.458  1.00 45.83           C  
ATOM     22  N   ALA    12      56.518 -26.982  17.115  1.00 42.12           N  
ATOM     23  CA  ALA    12      55.301 -27.490  17.736  1.00 40.00           C  
ATOM     24  C   ALA    12      54.252 -26.375  17.772  1.00 39.55           C  
ATOM     25  O   ALA    12      54.566 -25.236  18.129  1.00 35.98           O  
ATOM     26  CB  ALA    12      55.605 -27.961  19.142  1.00 38.33           C  
ATOM     27  N   GLU    13      53.023 -26.699  17.394  1.00 40.63           N  
ATOM     28  CA  GLU    13      51.913 -25.749  17.482  1.00 42.72           C  
ATOM     29  C   GLU    13      51.523 -25.518  18.950  1.00 42.02           C  
ATOM     30  O   GLU    13      51.506 -26.452  19.742  1.00 42.03           O  
ATOM     31  CB  GLU    13      50.717 -26.254  16.671  1.00 42.21           C  
ATOM     32  CG  GLU    13      49.860 -25.143  16.068  1.00 47.11           C  
ATOM     33  CD  GLU    13      48.729 -25.671  15.169  1.00 49.32           C  
ATOM     34  OE1 GLU    13      48.950 -26.674  14.442  1.00 52.36           O  
ATOM     35  OE2 GLU    13      47.614 -25.083  15.200  1.00 59.57           O  
ATOM     36  N   VAL    14      51.230 -24.268  19.301  1.00 40.63           N  
ATOM     37  CA  VAL    14      50.890 -23.890  20.675  1.00 37.77           C  
ATOM     38  C   VAL    14      49.390 -23.660  20.813  1.00 36.42           C  
ATOM     39  O   VAL    14      48.761 -23.060  19.946  1.00 36.60           O  
ATOM     40  CB  VAL    14      51.644 -22.622  21.110  1.00 38.62           C  
ATOM     41  CG1 VAL    14      51.241 -22.212  22.518  1.00 33.88           C  
ATOM     42  CG2 VAL    14      53.152 -22.846  21.033  1.00 35.50           C  
ATOM     43  N   ASN    15      48.812 -24.153  21.900  1.00 34.06           N  
ATOM     44  CA  ASN    15      47.407 -23.957  22.158  1.00 33.88           C  
ATOM     45  C   ASN    15      47.083 -22.479  22.334  1.00 33.04           C  
ATOM     46  O   ASN    15      47.602 -21.847  23.255  1.00 32.42           O  
ATOM     47  CB  ASN    15      46.994 -24.708  23.418  1.00 35.53           C  
ATOM     48  CG  ASN    15      45.527 -24.540  23.733  1.00 37.44           C  
ATOM     49  OD1 ASN    15      45.120 -23.520  24.243  1.00 37.41           O  
ATOM     50  ND2 ASN    15      44.729 -25.556  23.423  1.00 43.93           N  
ATOM     51  N   LEU    16      46.207 -21.958  21.483  1.00 31.24           N  
ATOM     52  CA  LEU    16      45.931 -20.529  21.429  1.00 33.01           C  
ATOM     53  C   LEU    16      45.005 -20.054  22.541  1.00 32.25           C  
ATOM     54  O   LEU    16      44.996 -18.881  22.845  1.00 32.26           O  
ATOM     55  CB  LEU    16      45.328 -20.148  20.075  1.00 34.27           C  
ATOM     56  CG  LEU    16      46.190 -20.305  18.818  1.00 34.50           C  
ATOM     57  CD1 LEU    16      45.443 -19.732  17.607  1.00 34.58           C  
ATOM     58  CD2 LEU    16      47.568 -19.650  18.992  1.00 33.93           C  
ATOM     59  N   ASP    17      44.236 -20.949  23.151  1.00 32.19           N  
ATOM     60  CA  ASP    17      43.394 -20.576  24.279  1.00 32.48           C  
ATOM     61  C   ASP    17      44.231 -20.282  25.513  1.00 32.65           C  
ATOM     62  O   ASP    17      44.037 -19.269  26.162  1.00 30.88           O  
ATOM     63  CB  ASP    17      42.382 -21.674  24.594  1.00 35.60           C  
ATOM     64  CG  ASP    17      41.437 -21.931  23.455  1.00 35.99           C  
ATOM     65  OD1 ASP    17      40.779 -20.971  23.006  1.00 38.81           O  
ATOM     66  OD2 ASP    17      41.367 -23.092  23.003  1.00 50.00           O  
ATOM     67  N   GLU    18      45.170 -21.165  25.820  1.00 32.04           N  
ATOM     68  CA  GLU    18      46.071 -20.942  26.935  1.00 34.74           C  
ATOM     69  C   GLU    18      46.977 -19.765  26.654  1.00 31.75           C  
ATOM     70  O   GLU    18      47.183 -18.936  27.543  1.00 30.78           O  
ATOM     71  CB  GLU    18      46.900 -22.196  27.222  1.00 34.77           C  
ATOM     72  CG  GLU    18      46.059 -23.376  27.751  1.00 42.03           C  
ATOM     73  CD  GLU    18      46.796 -24.726  27.729  1.00 43.33           C  
ATOM     74  OE1 GLU    18      47.977 -24.782  27.337  1.00 54.77           O  
ATOM     75  OE2 GLU    18      46.183 -25.752  28.110  1.00 57.13           O  
ATOM     76  N   LEU    19      47.485 -19.658  25.420  1.00 30.67           N  
ATOM     77  CA  LEU    19      48.438 -18.570  25.070  1.00 30.07           C  
ATOM     78  C   LEU    19      47.779 -17.220  25.227  1.00 30.04           C  
ATOM     79  O   LEU    19      48.381 -16.277  25.748  1.00 30.43           O  
ATOM     80  CB  LEU    19      48.997 -18.734  23.646  1.00 29.84           C  
ATOM     81  CG  LEU    19      50.144 -17.827  23.208  1.00 29.31           C  
ATOM     82  CD1 LEU    19      51.284 -17.839  24.240  1.00 31.63           C  
ATOM     83  CD2 LEU    19      50.653 -18.189  21.806  1.00 25.27           C  
ATOM     84  N   ALA    20      46.525 -17.150  24.806  1.00 29.97           N  
ATOM     85  CA  ALA    20      45.729 -15.924  24.888  1.00 31.22           C  
ATOM     86  C   ALA    20      45.521 -15.475  26.334  1.00 30.56           C  
ATOM     87  O   ALA    20      45.505 -14.283  26.629  1.00 32.27           O  
ATOM     88  CB  ALA    20      44.375 -16.146  24.203  1.00 30.51           C  
ATOM     89  N   GLN    21      45.343 -16.432  27.233  1.00 31.77           N  
ATOM     90  CA  GLN    21      45.207 -16.143  28.663  1.00 30.90           C  
ATOM     91  C   GLN    21      46.536 -15.649  29.217  1.00 30.39           C  
ATOM     92  O   GLN    21      46.576 -14.712  30.011  1.00 32.04           O  
ATOM     93  CB  GLN    21      44.717 -17.404  29.411  1.00 32.37           C  
ATOM     94  CG  GLN    21      44.695 -17.283  30.920  1.00 42.11           C  
ATOM     95  N   GLU    22      47.636 -16.241  28.772  1.00 29.04           N  
ATOM     96  CA  GLU    22      48.951 -15.875  29.310  1.00 27.71           C  
ATOM     97  C   GLU    22      49.502 -14.569  28.735  1.00 30.62           C  
ATOM     98  O   GLU    22      50.216 -13.818  29.441  1.00 30.38           O  
ATOM     99  CB  GLU    22      49.911 -17.020  29.090  1.00 27.03           C  
ATOM    100  CG  GLU    22      49.492 -18.259  29.869  1.00 33.36           C  
ATOM    101  CD  GLU    22      50.401 -19.423  29.682  1.00 36.56           C  
ATOM    102  OE1 GLU    22      51.620 -19.193  29.452  1.00 42.93           O  
ATOM    103  OE2 GLU    22      49.905 -20.578  29.799  1.00 37.90           O  
ATOM    104  N   LEU    23      49.169 -14.279  27.470  1.00 29.30           N  
ATOM    105  CA  LEU    23      49.631 -13.056  26.825  1.00 29.17           C  
ATOM    106  C   LEU    23      48.642 -11.915  26.932  1.00 30.25           C  
ATOM    107  O   LEU    23      48.992 -10.772  26.663  1.00 32.08           O  
ATOM    108  CB  LEU    23      49.935 -13.315  25.356  1.00 29.09           C  
ATOM    109  CG  LEU    23      51.089 -14.251  25.075  1.00 30.17           C  
ATOM    110  CD1 LEU    23      51.295 -14.407  23.565  1.00 31.18           C  
ATOM    111  CD2 LEU    23      52.365 -13.776  25.805  1.00 27.85           C  
ATOM    112  N   GLY    24      47.408 -12.223  27.309  1.00 30.92           N  
ATOM    113  CA  GLY    24      46.347 -11.247  27.430  1.00 30.54           C  
ATOM    114  C   GLY    24      46.758  -9.901  27.994  1.00 31.61           C  
ATOM    115  O   GLY    24      46.393  -8.876  27.436  1.00 30.61           O  
ATOM    116  N   PRO    25      47.494  -9.889  29.125  1.00 30.78           N  
ATOM    117  CA  PRO    25      47.913  -8.620  29.713  1.00 29.71           C  
ATOM    118  C   PRO    25      48.754  -7.681  28.835  1.00 30.41           C  
ATOM    119  O   PRO    25      48.751  -6.495  29.105  1.00 30.79           O  
ATOM    120  CB  PRO    25      48.729  -9.065  30.930  1.00 29.78           C  
ATOM    121  CG  PRO    25      48.166 -10.377  31.282  1.00 32.86           C  
ATOM    122  CD  PRO    25      47.910 -11.019  29.970  1.00 31.91           C  
ATOM    123  N   ILE    26      49.481  -8.189  27.836  1.00 29.88           N  
ATOM    124  CA  ILE    26      50.311  -7.331  26.939  1.00 27.57           C  
ATOM    125  C   ILE    26      49.696  -7.214  25.528  1.00 29.15           C  
ATOM    126  O   ILE    26      50.237  -6.558  24.634  1.00 29.64           O  
ATOM    127  CB  ILE    26      51.795  -7.772  26.920  1.00 27.40           C  
ATOM    128  CG1 ILE    26      52.030  -9.205  26.461  1.00 28.86           C  
ATOM    129  CG2 ILE    26      52.382  -7.701  28.367  1.00 27.44           C  
ATOM    130  CD1 ILE    26      51.852  -9.499  24.971  1.00 34.86           C  
ATOM    131  N   MET    27      48.551  -7.848  25.344  1.00 31.06           N  
ATOM    132  CA  MET    27      47.818  -7.785  24.090  1.00 31.64           C  
ATOM    133  C   MET    27      46.949  -6.543  24.019  1.00 29.78           C  
ATOM    134  O   MET    27      46.490  -6.026  25.053  1.00 29.97           O  
ATOM    135  CB  MET    27      46.958  -9.038  23.926  1.00 30.84           C  
ATOM    136  CG  MET    27      47.764 -10.254  23.491  1.00 32.59           C  
ATOM    137  SD  MET    27      46.672 -11.860  23.482  0.75 35.14          SE  
ATOM    138  CE  MET    27      45.480 -11.416  21.918  1.00 32.37           C  
ATOM    139  N   GLY    28      46.702  -6.069  22.799  1.00 28.32           N  
ATOM    140  CA  GLY    28      45.767  -4.966  22.580  1.00 29.27           C  
ATOM    141  C   GLY    28      44.343  -5.406  22.889  1.00 31.94           C  
ATOM    142  O   GLY    28      44.034  -6.593  22.801  1.00 32.50           O  
ATOM    143  N   ASP    29      43.478  -4.449  23.232  1.00 32.77           N  
ATOM    144  CA  ASP    29      42.073  -4.713  23.559  1.00 34.58           C  
ATOM    145  C   ASP    29      41.351  -5.497  22.450  1.00 35.87           C  
ATOM    146  O   ASP    29      40.587  -6.400  22.741  1.00 39.58           O  
ATOM    147  CB  ASP    29      41.286  -3.411  23.802  1.00 34.46           C  
ATOM    148  CG  ASP    29      41.745  -2.633  25.038  1.00 37.07           C  
ATOM    149  OD1 ASP    29      42.465  -3.173  25.898  1.00 37.61           O  
ATOM    150  OD2 ASP    29      41.381  -1.434  25.124  1.00 44.68           O  
ATOM    151  N   ASN    30      41.580  -5.136  21.193  1.00 35.57           N  
ATOM    152  CA  ASN    30      40.959  -5.818  20.047  1.00 37.83           C  
ATOM    153  C   ASN    30      41.907  -6.777  19.279  1.00 36.99           C  
ATOM    154  O   ASN    30      41.725  -7.048  18.082  1.00 37.90           O  
ATOM    155  CB  ASN    30      40.408  -4.760  19.085  1.00 40.16           C  
ATOM    156  CG  ASN    30      39.472  -3.749  19.782  1.00 50.83           C  
ATOM    157  OD1 ASN    30      38.693  -4.105  20.683  1.00 53.38           O  
ATOM    158  ND2 ASN    30      39.556  -2.484  19.364  1.00 57.62           N  
ATOM    159  N   GLU    31      42.917  -7.298  19.973  1.00 33.17           N  
ATOM    160  CA  GLU    31      43.866  -8.192  19.356  1.00 30.29           C  
ATOM    161  C   GLU    31      43.462  -9.640  19.573  1.00 29.50           C  
ATOM    162  O   GLU    31      43.000 -10.022  20.652  1.00 27.97           O  
ATOM    163  CB  GLU    31      45.260  -7.965  19.936  1.00 28.92           C  
ATOM    164  CG  GLU    31      46.361  -8.680  19.151  1.00 28.18           C  
ATOM    165  CD  GLU    31      47.734  -8.228  19.562  1.00 28.59           C  
ATOM    166  OE1 GLU    31      47.887  -7.721  20.712  1.00 28.28           O  
ATOM    167  OE2 GLU    31      48.671  -8.396  18.748  1.00 30.08           O  
ATOM    168  N   GLN    32      43.663 -10.442  18.536  1.00 29.95           N  
ATOM    169  CA  GLN    32      43.384 -11.871  18.580  1.00 30.19           C  
ATOM    170  C   GLN    32      44.564 -12.658  18.060  1.00 29.38           C  
ATOM    171  O   GLN    32      45.280 -12.223  17.161  1.00 27.54           O  
ATOM    172  CB  GLN    32      42.156 -12.191  17.749  1.00 29.37           C  
ATOM    173  CG  GLN    32      40.886 -11.656  18.349  1.00 38.86           C  
ATOM    174  CD  GLN    32      39.686 -12.111  17.575  1.00 48.30           C  
ATOM    175  OE1 GLN    32      39.096 -11.329  16.829  1.00 53.49           O  
ATOM    176  NE2 GLN    32      39.339 -13.400  17.703  1.00 44.10           N  
ATOM    177  N   LEU    33      44.745 -13.847  18.626  1.00 30.24           N  
ATOM    178  CA  LEU    33      45.794 -14.753  18.184  1.00 30.31           C  
ATOM    179  C   LEU    33      45.333 -15.563  16.985  1.00 29.00           C  
ATOM    180  O   LEU    33      44.192 -16.012  16.938  1.00 28.70           O  
ATOM    181  CB  LEU    33      46.199 -15.677  19.328  1.00 29.81           C  
ATOM    182  CG  LEU    33      46.748 -14.978  20.574  1.00 32.58           C  
ATOM    183  CD1 LEU    33      47.196 -16.058  21.500  1.00 28.01           C  
ATOM    184  CD2 LEU    33      47.890 -14.036  20.289  1.00 31.90           C  
ATOM    185  N   ALA    34      46.197 -15.717  15.991  1.00 27.96           N  
ATOM    186  CA  ALA    34      45.836 -16.491  14.792  1.00 30.62           C  
ATOM    187  C   ALA    34      46.559 -17.833  14.765  1.00 30.42           C  
ATOM    188  O   ALA    34      46.006 -18.860  14.353  1.00 28.34           O  
ATOM    189  CB  ALA    34      46.123 -15.678  13.473  1.00 28.64           C  
ATOM    190  N   LEU    35      47.805 -17.819  15.205  1.00 29.05           N  
ATOM    191  CA  LEU    35      48.680 -18.949  15.009  1.00 29.50           C  
ATOM    192  C   LEU    35      49.915 -18.789  15.876  1.00 28.92           C  
ATOM    193  O   LEU    35      50.457 -17.688  15.998  1.00 27.72           O  
ATOM    194  CB  LEU    35      49.077 -18.981  13.542  1.00 31.93           C  
ATOM    195  CG  LEU    35      49.742 -20.189  12.917  1.00 35.04           C  
ATOM    196  CD1 LEU    35      48.962 -21.506  13.182  1.00 38.57           C  
ATOM    197  CD2 LEU    35      49.850 -19.879  11.433  1.00 36.70           C  
ATOM    198  N   ALA    36      50.387 -19.888  16.457  1.00 26.00           N  
ATOM    199  CA  ALA    36      51.602 -19.829  17.208  1.00 26.36           C  
ATOM    200  C   ALA    36      52.398 -21.115  17.200  1.00 26.82           C  
ATOM    201  O   ALA    36      51.850 -22.198  17.333  1.00 25.24           O  
ATOM    202  CB  ALA    36      51.327 -19.382  18.648  1.00 25.51           C  
ATOM    203  N   TYR    37      53.718 -20.956  17.077  1.00 26.47           N  
ATOM    204  CA  TYR    37      54.626 -22.089  17.064  1.00 27.81           C  
ATOM    205  C   TYR    37      55.699 -21.936  18.146  1.00 28.83           C  
ATOM    206  O   TYR    37      56.197 -20.845  18.417  1.00 28.58           O  
ATOM    207  CB  TYR    37      55.281 -22.242  15.691  1.00 28.27           C  
ATOM    208  CG  TYR    37      54.308 -22.558  14.585  1.00 28.64           C  
ATOM    209  CD1 TYR    37      53.787 -23.844  14.442  1.00 30.62           C  
ATOM    210  CD2 TYR    37      53.887 -21.578  13.688  1.00 31.83           C  
ATOM    211  CE1 TYR    37      52.866 -24.148  13.426  1.00 30.92           C  
ATOM    212  CE2 TYR    37      52.970 -21.886  12.650  1.00 32.26           C  
ATOM    213  CZ  TYR    37      52.467 -23.160  12.540  1.00 31.17           C  
ATOM    214  OH  TYR    37      51.557 -23.480  11.544  1.00 37.96           O  
ATOM    215  N   ARG    38      56.061 -23.057  18.748  1.00 29.59           N  
ATOM    216  CA  ARG    38      57.211 -23.114  19.624  1.00 31.93           C  
ATOM    217  C   ARG    38      58.388 -23.872  18.988  1.00 32.07           C  
ATOM    218  O   ARG    38      58.234 -24.897  18.322  1.00 32.21           O  
ATOM    219  CB  ARG    38      56.822 -23.759  20.946  1.00 33.38           C  
ATOM    220  CG  ARG    38      57.843 -23.520  22.054  1.00 39.14           C  
ATOM    221  CD  ARG    38      57.762 -24.582  23.122  1.00 48.81           C  
ATOM    222  NE  ARG    38      56.793 -24.280  24.161  1.00 51.66           N  
ATOM    223  CZ  ARG    38      55.529 -24.684  24.163  1.00 55.61           C  
ATOM    224  NH1 ARG    38      55.039 -25.411  23.159  1.00 59.48           N  
ATOM    225  NH2 ARG    38      54.751 -24.347  25.181  1.00 52.27           N  
ATOM    226  N   VAL    39      59.579 -23.348  19.184  1.00 32.67           N  
ATOM    227  CA  VAL    39      60.788 -24.084  18.841  1.00 33.79           C  
ATOM    228  C   VAL    39      61.618 -24.110  20.121  1.00 34.37           C  
ATOM    229  O   VAL    39      62.196 -23.097  20.514  1.00 35.08           O  
ATOM    230  CB  VAL    39      61.557 -23.468  17.631  1.00 32.80           C  
ATOM    231  CG1 VAL    39      62.871 -24.228  17.388  1.00 33.25           C  
ATOM    232  CG2 VAL    39      60.697 -23.525  16.386  1.00 35.00           C  
ATOM    233  N   ILE    40      61.613 -25.265  20.788  1.00 34.65           N  
ATOM    234  CA  ILE    40      62.264 -25.452  22.095  1.00 36.62           C  
ATOM    235  C   ILE    40      61.657 -24.485  23.132  1.00 34.68           C  
ATOM    236  O   ILE    40      60.539 -24.701  23.582  1.00 34.13           O  
ATOM    237  CB  ILE    40      63.824 -25.387  22.019  1.00 38.36           C  
ATOM    238  CG1 ILE    40      64.365 -26.358  20.954  1.00 43.53           C  
ATOM    239  CG2 ILE    40      64.429 -25.782  23.363  1.00 40.40           C  
ATOM    240  CD1 ILE    40      65.763 -25.997  20.421  1.00 40.40           C  
ATOM    241  N   ARG    41      62.357 -23.419  23.507  1.00 33.68           N  
ATOM    242  CA  ARG    41      61.806 -22.442  24.463  1.00 34.26           C  
ATOM    243  C   ARG    41      61.242 -21.171  23.802  1.00 32.54           C  
ATOM    244  O   ARG    41      60.541 -20.393  24.445  1.00 34.61           O  
ATOM    245  CB  ARG    41      62.879 -21.980  25.436  1.00 34.70           C  
ATOM    246  CG  ARG    41      63.597 -23.055  26.161  1.00 37.86           C  
ATOM    247  CD  ARG    41      64.516 -22.440  27.219  1.00 40.35           C  
ATOM    248  NE  ARG    41      65.529 -21.523  26.666  1.00 39.77           N  
ATOM    249  CZ  ARG    41      66.724 -21.315  27.228  1.00 39.80           C  
ATOM    250  NH1 ARG    41      67.050 -21.929  28.361  1.00 35.97           N  
ATOM    251  NH2 ARG    41      67.594 -20.488  26.670  1.00 31.93           N  
ATOM    252  N   ASP    42      61.585 -20.951  22.545  1.00 29.33           N  
ATOM    253  CA  ASP    42      61.232 -19.738  21.831  1.00 30.54           C  
ATOM    254  C   ASP    42      59.881 -19.918  21.142  1.00 30.37           C  
ATOM    255  O   ASP    42      59.463 -21.036  20.858  1.00 30.57           O  
ATOM    256  CB  ASP    42      62.319 -19.405  20.805  1.00 29.08           C  
ATOM    257  CG  ASP    42      63.675 -19.131  21.445  1.00 35.53           C  
ATOM    258  OD1 ASP    42      63.723 -18.839  22.665  1.00 33.19           O  
ATOM    259  OD2 ASP    42      64.705 -19.209  20.729  1.00 40.83           O  
ATOM    260  N   MET    43      59.199 -18.806  20.902  1.00 29.53           N  
ATOM    261  CA  MET    43      57.899 -18.801  20.272  1.00 33.10           C  
ATOM    262  C   MET    43      57.786 -17.741  19.205  1.00 29.59           C  
ATOM    263  O   MET    43      58.364 -16.654  19.304  1.00 31.23           O  
ATOM    264  CB  MET    43      56.815 -18.561  21.301  1.00 31.88           C  
ATOM    265  CG  MET    43      56.082 -19.773  21.698  1.00 41.39           C  
ATOM    266  SD  MET    43      54.583 -19.260  22.789  0.75 44.15          SE  
ATOM    267  CE  MET    43      54.929 -20.493  24.116  1.00 39.34           C  
ATOM    268  N   PHE    44      57.042 -18.095  18.167  1.00 29.00           N  
ATOM    269  CA  PHE    44      56.722 -17.213  17.071  1.00 28.77           C  
ATOM    270  C   PHE    44      55.190 -17.112  17.021  1.00 29.74           C  
ATOM    271  O   PHE    44      54.499 -18.098  16.729  1.00 30.01           O  
ATOM    272  CB  PHE    44      57.282 -17.836  15.807  1.00 30.56           C  
ATOM    273  CG  PHE    44      57.484 -16.877  14.696  1.00 32.68           C  
ATOM    274  CD1 PHE    44      56.436 -16.470  13.921  1.00 40.05           C  
ATOM    275  CD2 PHE    44      58.737 -16.371  14.427  1.00 39.89           C  
ATOM    276  CE1 PHE    44      56.629 -15.576  12.869  1.00 38.52           C  
ATOM    277  CE2 PHE    44      58.931 -15.475  13.376  1.00 38.67           C  
ATOM    278  CZ  PHE    44      57.865 -15.098  12.592  1.00 35.49           C  
ATOM    279  N   VAL    45      54.657 -15.937  17.355  1.00 27.56           N  
ATOM    280  CA  VAL    45      53.215 -15.790  17.522  1.00 28.26           C  
ATOM    281  C   VAL    45      52.675 -14.862  16.445  1.00 27.06           C  
ATOM    282  O   VAL    45      53.233 -13.789  16.221  1.00 27.80           O  
ATOM    283  CB  VAL    45      52.890 -15.282  18.925  1.00 27.14           C  
ATOM    284  CG1 VAL    45      51.361 -15.110  19.124  1.00 23.97           C  
ATOM    285  CG2 VAL    45      53.477 -16.246  19.943  1.00 24.77           C  
ATOM    286  N   PHE    46      51.654 -15.322  15.738  1.00 25.28           N  
ATOM    287  CA  PHE    46      50.933 -14.480  14.779  1.00 26.22           C  
ATOM    288  C   PHE    46      49.657 -14.017  15.411  1.00 25.97           C  
ATOM    289  O   PHE    46      48.792 -14.832  15.732  1.00 24.46           O  
ATOM    290  CB  PHE    46      50.565 -15.239  13.507  1.00 25.83           C  
ATOM    291  CG  PHE    46      51.729 -15.729  12.736  1.00 26.44           C  
ATOM    292  CD1 PHE    46      52.428 -16.870  13.152  1.00 33.54           C  
ATOM    293  CD2 PHE    46      52.122 -15.083  11.572  1.00 31.14           C  
ATOM    294  CE1 PHE    46      53.521 -17.335  12.424  1.00 31.61           C  
ATOM    295  CE2 PHE    46      53.214 -15.538  10.832  1.00 30.46           C  
ATOM    296  CZ  PHE    46      53.908 -16.657  11.251  1.00 32.65           C  
ATOM    297  N   THR    47      49.525 -12.711  15.596  1.00 26.48           N  
ATOM    298  CA  THR    47      48.247 -12.146  15.980  1.00 25.78           C  
ATOM    299  C   THR    47      47.572 -11.540  14.737  1.00 26.06           C  
ATOM    300  O   THR    47      48.073 -11.664  13.619  1.00 25.84           O  
ATOM    301  CB  THR    47      48.401 -11.146  17.110  1.00 24.21           C  
ATOM    302  OG1 THR    47      48.626  -9.819  16.579  1.00 24.94           O  
ATOM    303  CG2 THR    47      49.514 -11.595  18.070  1.00 22.98           C  
ATOM    304  N   ASN    48      46.414 -10.923  14.908  1.00 27.66           N  
ATOM    305  CA  ASN    48      45.837 -10.172  13.790  1.00 28.00           C  
ATOM    306  C   ASN    48      46.465  -8.771  13.558  1.00 28.75           C  
ATOM    307  O   ASN    48      46.083  -8.081  12.625  1.00 27.02           O  
ATOM    308  CB  ASN    48      44.310 -10.085  13.891  1.00 27.80           C  
ATOM    309  CG  ASN    48      43.834  -9.365  15.101  1.00 30.65           C  
ATOM    310  OD1 ASN    48      44.560  -9.170  16.079  1.00 27.46           O  
ATOM    311  ND2 ASN    48      42.582  -8.966  15.058  1.00 32.05           N  
ATOM    312  N   LYS    49      47.414  -8.373  14.401  1.00 29.97           N  
ATOM    313  CA  LYS    49      48.050  -7.044  14.362  1.00 29.05           C  
ATOM    314  C   LYS    49      49.577  -7.072  14.225  1.00 27.69           C  
ATOM    315  O   LYS    49      50.189  -6.095  13.795  1.00 25.55           O  
ATOM    316  CB  LYS    49      47.745  -6.312  15.651  1.00 29.91           C  
ATOM    317  CG  LYS    49      46.293  -6.201  16.012  1.00 32.58           C  
ATOM    318  CD  LYS    49      45.605  -5.135  15.243  1.00 40.52           C  
ATOM    319  CE  LYS    49      44.240  -4.850  15.839  1.00 46.49           C  
ATOM    320  NZ  LYS    49      43.305  -4.508  14.762  1.00 47.89           N  
ATOM    321  N   ARG    50      50.196  -8.159  14.650  1.00 25.39           N  
ATOM    322  CA  ARG    50      51.658  -8.219  14.705  1.00 25.08           C  
ATOM    323  C   ARG    50      52.156  -9.637  14.821  1.00 24.78           C  
ATOM    324  O   ARG    50      51.416 -10.546  15.162  1.00 24.93           O  
ATOM    325  CB  ARG    50      52.176  -7.433  15.933  1.00 24.93           C  
ATOM    326  CG  ARG    50      51.571  -7.928  17.244  1.00 23.01           C  
ATOM    327  CD  ARG    50      52.229  -7.387  18.526  1.00 25.97           C  
ATOM    328  NE  ARG    50      51.227  -7.423  19.606  1.00 25.66           N  
ATOM    329  CZ  ARG    50      51.399  -6.963  20.839  1.00 26.42           C  
ATOM    330  NH1 ARG    50      52.565  -6.453  21.241  1.00 27.11           N  
ATOM    331  NH2 ARG    50      50.387  -7.018  21.699  1.00 26.62           N  
ATOM    332  N   LEU    51      53.451  -9.807  14.600  1.00 26.95           N  
ATOM    333  CA  LEU    51      54.146 -10.970  15.100  1.00 27.04           C  
ATOM    334  C   LEU    51      54.712 -10.597  16.461  1.00 29.78           C  
ATOM    335  O   LEU    51      55.170  -9.460  16.658  1.00 30.41           O  
ATOM    336  CB  LEU    51      55.282 -11.370  14.186  1.00 27.54           C  
ATOM    337  CG  LEU    51      54.998 -11.394  12.686  1.00 29.34           C  
ATOM    338  CD1 LEU    51      56.323 -11.607  11.956  1.00 30.99           C  
ATOM    339  CD2 LEU    51      53.980 -12.453  12.310  1.00 26.66           C  
ATOM    340  N   ILE    52      54.661 -11.547  17.392  1.00 27.68           N  
ATOM    341  CA  ILE    52      55.383 -11.477  18.649  1.00 27.58           C  
ATOM    342  C   ILE    52      56.458 -12.570  18.624  1.00 30.30           C  
ATOM    343  O   ILE    52      56.167 -13.772  18.457  1.00 28.72           O  
ATOM    344  CB  ILE    52      54.457 -11.600  19.874  1.00 27.65           C  
ATOM    345  CG1 ILE    52      53.316 -10.591  19.780  1.00 27.80           C  
ATOM    346  CG2 ILE    52      55.258 -11.341  21.209  1.00 28.50           C  
ATOM    347  CD1 ILE    52      52.186 -10.811  20.826  1.00 30.99           C  
ATOM    348  N   LEU    53      57.715 -12.153  18.732  1.00 29.54           N  
ATOM    349  CA  LEU    53      58.807 -13.091  18.746  1.00 31.22           C  
ATOM    350  C   LEU    53      59.322 -13.140  20.175  1.00 29.24           C  
ATOM    351  O   LEU    53      59.818 -12.145  20.702  1.00 27.89           O  
ATOM    352  CB  LEU    53      59.911 -12.694  17.757  1.00 33.84           C  
ATOM    353  CG  LEU    53      59.534 -12.203  16.352  1.00 38.88           C  
ATOM    354  CD1 LEU    53      60.751 -12.304  15.464  1.00 47.75           C  
ATOM    355  CD2 LEU    53      58.375 -12.968  15.755  1.00 44.16           C  
ATOM    356  N   ILE    54      59.141 -14.292  20.806  1.00 29.19           N  
ATOM    357  CA  ILE    54      59.549 -14.519  22.195  1.00 28.78           C  
ATOM    358  C   ILE    54      60.821 -15.358  22.243  1.00 29.78           C  
ATOM    359  O   ILE    54      60.788 -16.562  21.961  1.00 29.99           O  
ATOM    360  CB  ILE    54      58.442 -15.232  22.980  1.00 29.40           C  
ATOM    361  CG1 ILE    54      57.138 -14.418  22.910  1.00 27.48           C  
ATOM    362  CG2 ILE    54      58.904 -15.475  24.437  1.00 29.29           C  
ATOM    363  CD1 ILE    54      55.941 -15.044  23.609  1.00 28.12           C  
ATOM    364  N   ASP    55      61.939 -14.719  22.571  1.00 27.43           N  
ATOM    365  CA  ASP    55      63.209 -15.395  22.601  0.50 28.25           C  
ATOM    367  C   ASP    55      63.689 -15.445  24.058  1.00 30.38           C  
ATOM    368  O   ASP    55      63.672 -14.436  24.769  1.00 29.76           O  
ATOM    369  CB  ASP    55      64.211 -14.688  21.668  0.50 28.09           C  
ATOM    371  CG  ASP    55      63.711 -14.584  20.193  0.50 31.75           C  
ATOM    373  OD1 ASP    55      62.981 -15.477  19.699  0.50 24.59           O  
ATOM    375  OD2 ASP    55      64.057 -13.580  19.521  0.50 41.59           O  
ATOM    377  N   LYS    56      64.099 -16.626  24.493  1.00 32.08           N  
ATOM    378  CA  LYS    56      64.643 -16.810  25.839  1.00 34.65           C  
ATOM    379  C   LYS    56      66.126 -17.191  25.736  1.00 34.68           C  
ATOM    380  O   LYS    56      66.532 -17.954  24.850  1.00 37.13           O  
ATOM    381  CB  LYS    56      63.849 -17.857  26.614  1.00 33.26           C  
ATOM    382  CG  LYS    56      62.331 -17.594  26.648  1.00 33.10           C  
ATOM    383  CD  LYS    56      61.635 -18.592  27.549  1.00 36.85           C  
ATOM    384  CE  LYS    56      60.313 -18.080  28.068  1.00 40.09           C  
ATOM    385  NZ  LYS    56      59.874 -18.933  29.177  1.00 38.34           N  
ATOM    386  N   GLN    57      66.925 -16.637  26.632  1.00 31.52           N  
ATOM    387  CA  GLN    57      68.346 -16.923  26.674  1.00 35.10           C  
ATOM    388  C   GLN    57      68.785 -17.298  28.081  1.00 30.44           C  
ATOM    389  O   GLN    57      68.106 -16.981  29.053  1.00 29.95           O  
ATOM    390  CB  GLN    57      69.126 -15.699  26.191  1.00 37.37           C  
ATOM    391  CG  GLN    57      69.024 -15.465  24.686  1.00 43.68           C  
ATOM    392  CD  GLN    57      69.663 -14.166  24.279  1.00 45.08           C  
ATOM    393  OE1 GLN    57      69.247 -13.084  24.727  1.00 59.61           O  
ATOM    394  NE2 GLN    57      70.687 -14.252  23.422  1.00 57.02           N  
ATOM    395  N   GLY    58      69.932 -17.956  28.156  1.00 27.79           N  
ATOM    396  CA  GLY    58      70.562 -18.339  29.414  1.00 26.89           C  
ATOM    397  C   GLY    58      70.197 -19.773  29.693  1.00 24.22           C  
ATOM    398  O   GLY    58      69.295 -20.297  29.067  1.00 23.88           O  
ATOM    399  N   VAL    59      70.886 -20.411  30.626  1.00 23.58           N  
ATOM    400  CA  VAL    59      70.582 -21.783  31.014  1.00 23.37           C  
ATOM    401  C   VAL    59      69.143 -21.909  31.530  1.00 25.93           C  
ATOM    402  O   VAL    59      68.434 -22.844  31.153  1.00 26.68           O  
ATOM    403  CB  VAL    59      71.593 -22.308  32.067  1.00 24.01           C  
ATOM    404  CG1 VAL    59      71.238 -23.739  32.550  1.00 25.92           C  
ATOM    405  CG2 VAL    59      72.972 -22.274  31.485  1.00 24.03           C  
ATOM    406  N   THR    60      68.709 -20.948  32.352  1.00 23.65           N  
ATOM    407  CA  THR    60      67.411 -21.024  33.014  1.00 23.37           C  
ATOM    408  C   THR    60      66.334 -20.330  32.196  1.00 26.68           C  
ATOM    409  O   THR    60      65.167 -20.386  32.543  1.00 29.28           O  
ATOM    410  CB  THR    60      67.460 -20.432  34.466  1.00 23.51           C  
ATOM    411  OG1 THR    60      67.723 -19.014  34.411  1.00 24.54           O  
ATOM    412  CG2 THR    60      68.520 -21.178  35.329  1.00 18.42           C  
ATOM    413  N   GLY    61      66.724 -19.685  31.104  1.00 30.73           N  
ATOM    414  CA  GLY    61      65.778 -19.099  30.213  1.00 32.98           C  
ATOM    415  C   GLY    61      65.064 -17.897  30.798  1.00 33.69           C  
ATOM    416  O   GLY    61      63.924 -17.633  30.444  1.00 30.37           O  
ATOM    417  N   LYS    62      65.742 -17.153  31.672  1.00 34.20           N  
ATOM    418  CA  LYS    62      65.126 -16.018  32.367  1.00 34.99           C  
ATOM    419  C   LYS    62      65.403 -14.678  31.674  1.00 33.78           C  
ATOM    420  O   LYS    62      64.777 -13.689  31.991  1.00 32.47           O  
ATOM    421  CB  LYS    62      65.569 -15.970  33.846  1.00 36.51           C  
ATOM    422  CG  LYS    62      64.835 -17.001  34.756  1.00 40.22           C  
ATOM    423  CD  LYS    62      63.469 -16.485  35.349  1.00 35.99           C  
ATOM    424  CE  LYS    62      63.674 -15.574  36.580  1.00 39.51           C  
ATOM    425  NZ  LYS    62      62.419 -15.380  37.434  1.00 49.24           N  
ATOM    426  N   LYS    63      66.347 -14.657  30.743  1.00 34.21           N  
ATOM    427  CA  LYS    63      66.583 -13.491  29.897  0.50 32.42           C  
ATOM    429  C   LYS    63      65.592 -13.606  28.728  1.00 33.46           C  
ATOM    430  O   LYS    63      65.785 -14.402  27.821  1.00 34.76           O  
ATOM    431  CB  LYS    63      68.057 -13.471  29.440  0.50 32.19           C  
ATOM    433  CG  LYS    63      68.509 -12.280  28.569  0.50 31.21           C  
ATOM    435  CD  LYS    63      68.054 -10.927  29.115  0.50 31.56           C  
ATOM    437  CE  LYS    63      69.005  -9.800  28.734  0.50 31.03           C  
ATOM    439  NZ  LYS    63      69.908  -9.444  29.870  0.50 31.91           N  
ATOM    441  N   VAL    64      64.505 -12.844  28.784  1.00 31.40           N  
ATOM    442  CA  VAL    64      63.399 -13.004  27.823  1.00 30.46           C  
ATOM    443  C   VAL    64      63.151 -11.707  27.081  1.00 30.91           C  
ATOM    444  O   VAL    64      63.119 -10.664  27.694  1.00 29.73           O  
ATOM    445  CB  VAL    64      62.088 -13.428  28.519  1.00 29.36           C  
ATOM    446  CG1 VAL    64      60.970 -13.644  27.493  1.00 27.60           C  
ATOM    447  CG2 VAL    64      62.291 -14.703  29.339  1.00 27.76           C  
ATOM    448  N   SER    65      63.017 -11.776  25.760  1.00 29.51           N  
ATOM    449  CA  SER    65      62.544 -10.643  25.002  1.00 26.52           C  
ATOM    450  C   SER    65      61.240 -10.925  24.275  1.00 26.64           C  
ATOM    451  O   SER    65      61.002 -12.012  23.772  1.00 28.62           O  
ATOM    452  CB  SER    65      63.592 -10.138  24.022  1.00 27.05           C  
ATOM    453  OG  SER    65      64.070 -11.185  23.235  1.00 33.03           O  
ATOM    454  N   TYR    66      60.389  -9.920  24.236  1.00 25.59           N  
ATOM    455  CA  TYR    66      59.191  -9.948  23.409  1.00 27.15           C  
ATOM    456  C   TYR    66      59.361  -8.849  22.363  1.00 25.16           C  
ATOM    457  O   TYR    66      59.309  -7.661  22.693  1.00 25.87           O  
ATOM    458  CB  TYR    66      57.933  -9.662  24.243  1.00 28.11           C  
ATOM    459  CG  TYR    66      57.432 -10.753  25.177  1.00 28.34           C  
ATOM    460  CD1 TYR    66      58.267 -11.715  25.738  1.00 37.37           C  
ATOM    461  CD2 TYR    66      56.097 -10.793  25.520  1.00 31.42           C  
ATOM    462  CE1 TYR    66      57.757 -12.693  26.606  1.00 34.85           C  
ATOM    463  CE2 TYR    66      55.586 -11.741  26.356  1.00 33.25           C  
ATOM    464  CZ  TYR    66      56.403 -12.676  26.918  1.00 35.59           C  
ATOM    465  OH  TYR    66      55.813 -13.599  27.764  1.00 35.83           O  
ATOM    466  N   HIS    67      59.605  -9.263  21.126  1.00 24.79           N  
ATOM    467  CA  HIS    67      59.756  -8.360  20.009  1.00 26.12           C  
ATOM    468  C   HIS    67      58.450  -8.365  19.214  1.00 25.09           C  
ATOM    469  O   HIS    67      58.064  -9.386  18.628  1.00 25.46           O  
ATOM    470  CB  HIS    67      60.943  -8.805  19.158  1.00 27.50           C  
ATOM    471  CG  HIS    67      61.301  -7.845  18.073  1.00 28.86           C  
ATOM    472  ND1 HIS    67      62.124  -8.190  17.027  1.00 41.80           N  
ATOM    473  CD2 HIS    67      60.888  -6.582  17.826  1.00 33.68           C  
ATOM    474  CE1 HIS    67      62.236  -7.160  16.203  1.00 47.44           C  
ATOM    475  NE2 HIS    67      61.492  -6.172  16.665  1.00 32.45           N  
ATOM    476  N   SER    68      57.770  -7.224  19.200  1.00 23.64           N  
ATOM    477  CA  SER    68      56.558  -7.036  18.377  1.00 24.79           C  
ATOM    478  C   SER    68      56.883  -6.462  17.006  1.00 25.82           C  
ATOM    479  O   SER    68      57.509  -5.383  16.889  1.00 23.38           O  
ATOM    480  CB  SER    68      55.560  -6.122  19.079  1.00 24.81           C  
ATOM    481  OG  SER    68      55.153  -6.674  20.322  1.00 24.83           O  
ATOM    482  N   VAL    69      56.462  -7.187  15.969  1.00 25.47           N  
ATOM    483  CA  VAL    69      56.582  -6.720  14.602  1.00 26.01           C  
ATOM    484  C   VAL    69      55.193  -6.542  14.009  1.00 24.83           C  
ATOM    485  O   VAL    69      54.589  -7.532  13.574  1.00 24.53           O  
ATOM    486  CB  VAL    69      57.414  -7.649  13.728  1.00 25.83           C  
ATOM    487  CG1 VAL    69      57.718  -6.924  12.392  1.00 24.55           C  
ATOM    488  CG2 VAL    69      58.691  -8.027  14.450  1.00 23.41           C  
ATOM    489  N   PRO    70      54.672  -5.302  14.022  1.00 23.95           N  
ATOM    490  CA  PRO    70      53.391  -5.074  13.368  1.00 25.46           C  
ATOM    491  C   PRO    70      53.522  -5.421  11.899  1.00 25.75           C  
ATOM    492  O   PRO    70      54.592  -5.246  11.303  1.00 23.32           O  
ATOM    493  CB  PRO    70      53.128  -3.576  13.583  1.00 26.99           C  
ATOM    494  CG  PRO    70      54.007  -3.194  14.738  1.00 26.95           C  
ATOM    495  CD  PRO    70      55.206  -4.066  14.618  1.00 25.90           C  
END
