
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  214 ( 1723),  selected  214 , name 2hsj_D
# Molecule2: number of CA atoms  213 ( 1647),  selected  213 , name T0448.pdb
# PARAMETERS: 2hsj_D.T0448.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    -2_D      H      18           -
LGA    N    -1_D      V      19           -
LGA    A     0_D      S      20           -
LGA    X     1_D      F      21           -
LGA    A     2_D      -       -           -
LGA    V     3_D      -       -           -
LGA    Q     4_D      -       -           -
LGA    L     5_D      -       -           -
LGA    L     6_D      -       -           -
LGA    E     7_D      -       -           -
LGA    N     8_D      -       -           -
LGA    W     9_D      -       -           -
LGA    L    10_D      -       -           -
LGA    L    11_D      -       -           -
LGA    K    12_D      -       -           -
LGA    E    13_D      -       -           -
LGA    Q    14_D      -       -           -
LGA    E    15_D      -       -           -
LGA    K    16_D      -       -           -
LGA    I    17_D      -       -           -
LGA    Q    18_D      -       -           -
LGA    T    19_D      -       -           -
LGA    K    20_D      -       -           -
LGA    Y    21_D      -       -           -
LGA    R    22_D      -       -           -
LGA    H    23_D      -       -           -
LGA    L    24_D      -       -           -
LGA    N    25_D      -       -           -
LGA    H    26_D      -       -           -
LGA    I    27_D      -       -           -
LGA    S    28_D      -       -           -
LGA    V    29_D      -       -           -
LGA    V    30_D      -       -           -
LGA    E    31_D      K      22          5.427
LGA    P    32_D      R      23          1.151
LGA    N    33_D      -       -           -
LGA    I    34_D      P      24          2.246
LGA    L    35_D      A      25          1.423
LGA    F    36_D      W      26          1.376
LGA    I    37_D      L      27          0.717
LGA    G    38_D      G      28          0.604
LGA    D    39_D      D      29          0.417
LGA    S    40_D      S      30          0.440
LGA    I    41_D      I      31          0.637
LGA    V    42_D      T      32          0.802
LGA    E    43_D      A      33          0.852
LGA    -       -      N      34           -
LGA    -       -      N      35           -
LGA    Y    44_D      G      36          3.538
LGA    -       -      L      37           -
LGA    -       -      A      38           -
LGA    -       -      T      39           -
LGA    -       -      V      40           -
LGA    Y    45_D      H      41          2.268
LGA    P    46_D      Y      42          5.008
LGA    L    47_D      H      43          2.378
LGA    Q    48_D      D      44          2.561
LGA    E    49_D      I      45          3.462
LGA    L    50_D      L      46           #
LGA    F    51_D      A      47           #
LGA    G    52_D      A      48          2.379
LGA    T    53_D      D      49          3.874
LGA    S    54_D      W      50          2.280
LGA    K    55_D      D      51          4.777
LGA    T    56_D      V      52          2.552
LGA    -       -      E      53           -
LGA    -       -      R      54           -
LGA    I    57_D      S      55          4.147
LGA    V    58_D      D      56          3.083
LGA    N    59_D      N      57          1.960
LGA    R    60_D      L      58          1.575
LGA    G    61_D      G      59          0.927
LGA    I    62_D      I      60          1.029
LGA    R    63_D      S      61          0.819
LGA    G    64_D      G      62          1.084
LGA    Y    65_D      S      63          0.717
LGA    Q    66_D      T      64          0.996
LGA    T    67_D      I      65          1.096
LGA    G    68_D      G      66          2.900
LGA    -       -      S      67           -
LGA    -       -      R      68           -
LGA    -       -      Y      69           -
LGA    -       -      D      70           -
LGA    L    69_D      A      71          1.580
LGA    L    70_D      M      72          1.652
LGA    L    71_D      A      73          1.925
LGA    E    72_D      V      74          2.630
LGA    N    73_D      R      75          2.734
LGA    L    74_D      Y      76          2.461
LGA    D    75_D      Q      77          2.077
LGA    A    76_D      A      78          2.221
LGA    H    77_D      -       -           -
LGA    L    78_D      I      79          0.584
LGA    Y    79_D      P      80          0.597
LGA    G    80_D      E      81          4.076
LGA    G    81_D      D      82          2.187
LGA    A    82_D      A      83          4.938
LGA    V    83_D      D      84          1.372
LGA    D    84_D      -       -           -
LGA    K    85_D      F      85          2.666
LGA    I    86_D      I      86          1.392
LGA    F    87_D      A      87          1.297
LGA    L    88_D      V      88          0.816
LGA    L    89_D      F      89          0.986
LGA    I    90_D      G      90          0.958
LGA    G    91_D      G      91          1.540
LGA    T    92_D      V      92          1.380
LGA    N    93_D      N      93          1.327
LGA    D    94_D      D      94          1.562
LGA    I    95_D      Y      95          1.645
LGA    G    96_D      G      96          2.034
LGA    K    97_D      R      97          2.115
LGA    D    98_D      D      98          1.249
LGA    V    99_D      Q      99          1.180
LGA    P   100_D      P     100          0.839
LGA    V   101_D      L     101          1.008
LGA    N   102_D      G     102          2.026
LGA    -       -      Q     103           -
LGA    -       -      Y     104           -
LGA    -       -      G     105           -
LGA    -       -      D     106           -
LGA    -       -      C     107           -
LGA    -       -      D     108           -
LGA    -       -      M     109           -
LGA    -       -      T     110           -
LGA    E   103_D      T     111          0.583
LGA    A   104_D      F     112          1.176
LGA    L   105_D      Y     113          1.729
LGA    N   106_D      G     114          1.015
LGA    N   107_D      A     115          0.620
LGA    L   108_D      L     116          1.348
LGA    E   109_D      M     117          1.271
LGA    A   110_D      M     118          0.426
LGA    I   111_D      L     119          0.858
LGA    I   112_D      L     120          0.920
LGA    Q   113_D      T     121          0.470
LGA    S   114_D      G     122          0.733
LGA    V   115_D      L     123          1.167
LGA    A   116_D      Q     124          1.143
LGA    R   117_D      T     125          1.280
LGA    D   118_D      N     126          1.030
LGA    Y   119_D      W     127          0.441
LGA    P   120_D      P     128          0.466
LGA    L   121_D      T     129          0.757
LGA    T   122_D      V     130          1.641
LGA    E   123_D      P     131          2.715
LGA    I   124_D      K     132          2.422
LGA    K   125_D      L     133          1.041
LGA    L   126_D      F     134          1.117
LGA    L   127_D      I     135          1.272
LGA    S   128_D      S     136          1.939
LGA    I   129_D      A     137          2.635
LGA    L   130_D      I     138          2.210
LGA    P   131_D      H     139          1.540
LGA    V   132_D      I     140          1.064
LGA    N   133_D      G     141          2.036
LGA    E   134_D      S     142          2.952
LGA    R   135_D      -       -           -
LGA    E   136_D      -       -           -
LGA    E   137_D      -       -           -
LGA    Y   138_D      -       -           -
LGA    Q   139_D      D     143          2.594
LGA    Q   140_D      F     144          3.837
LGA    A   141_D      -       -           -
LGA    V   142_D      G     145          4.236
LGA    Y   143_D      G     146          2.887
LGA    I   144_D      S     147          1.468
LGA    R   145_D      F     148          2.637
LGA    S   146_D      S     149          3.221
LGA    N   147_D      A     150          4.025
LGA    -       -      V     151           -
LGA    -       -      T     152           -
LGA    -       -      N     153           -
LGA    -       -      G     154           -
LGA    -       -      L     155           -
LGA    -       -      G     156           -
LGA    E   148_D      Y     157           #
LGA    K   149_D      R     158          1.387
LGA    I   150_D      Q     159          1.330
LGA    Q   151_D      S     160          1.510
LGA    N   152_D      D     161          1.789
LGA    W   153_D      Y     162          1.183
LGA    N   154_D      E     163          0.862
LGA    Q   155_D      A     164          1.374
LGA    A   156_D      A     165          1.597
LGA    Y   157_D      I     166          0.979
LGA    Q   158_D      A     167          0.763
LGA    E   159_D      Q     168          0.998
LGA    L   160_D      M     169          1.025
LGA    A   161_D      T     170          1.582
LGA    S   162_D      A     171          1.449
LGA    A   163_D      D     172          0.850
LGA    Y   164_D      Y     173          1.480
LGA    X   165_D      G     174          1.995
LGA    Q   166_D      -       -           -
LGA    V   167_D      V     175          0.328
LGA    E   168_D      P     176          0.814
LGA    F   169_D      H     177          1.137
LGA    V   170_D      L     178          0.612
LGA    P   171_D      S     179          1.610
LGA    V   172_D      L     180          1.242
LGA    F   173_D      Y     181          1.400
LGA    D   174_D      R     182          3.374
LGA    -       -      D     183           -
LGA    C   175_D      A     184          1.419
LGA    L   176_D      G     185          4.593
LGA    T   177_D      M     186          2.057
LGA    D   178_D      T     187          4.564
LGA    Q   179_D      -       -           -
LGA    A   180_D      -       -           -
LGA    G   181_D      -       -           -
LGA    Q   182_D      F     188          3.537
LGA    L   183_D      A     189          4.749
LGA    -       -      I     190           -
LGA    -       -      P     191           -
LGA    -       -      A     192           -
LGA    K   184_D      Q     193          2.068
LGA    K   185_D      A     194          1.829
LGA    -       -      A     195           -
LGA    E   186_D      I     196          0.729
LGA    Y   187_D      Y     197          0.788
LGA    T   188_D      S     198          0.510
LGA    T   189_D      V     199          0.521
LGA    D   190_D      D     200          1.135
LGA    G   191_D      T     201          1.314
LGA    L   192_D      L     202          0.843
LGA    H   193_D      H     203          0.839
LGA    L   194_D      P     204          0.936
LGA    S   195_D      N     205          0.655
LGA    I   196_D      N     206          0.573
LGA    A   197_D      A     207          0.774
LGA    G   198_D      G     208          0.707
LGA    Y   199_D      H     209          0.585
LGA    Q   200_D      R     210          0.904
LGA    A   201_D      V     211          1.064
LGA    L   202_D      I     212          1.095
LGA    S   203_D      A     213          1.175
LGA    K   204_D      R     214          1.230
LGA    S   205_D      K     215          1.001
LGA    L   206_D      L     216          0.862
LGA    K   207_D      Q     217          0.790
LGA    D   208_D      S     218          2.322
LGA    Y   209_D      F     219          2.958
LGA    L   210_D      L     220          3.375
LGA    Y   211_D      D     221          4.402
LGA    -       -      S     222           -
LGA    -       -      H     223           -
LGA    -       -      F     224           -
LGA    -       -      L     225           -
LGA    -       -      E     226           -
LGA    -       -      H     227           -
LGA    -       -      H     228           -
LGA    -       -      H     229           -
LGA    -       -      H     230           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  214  213    5.0    166    2.05    19.88     64.498     7.711

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.245170 * X  +  -0.776594 * Y  +   0.580340 * Z  +  82.481796
  Y_new =  -0.947716 * X  +  -0.318110 * Y  +  -0.025315 * Z  +  99.249977
  Z_new =   0.204271 * X  +  -0.543790 * Y  +  -0.813981 * Z  + 157.456589 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.552624    0.588969  [ DEG:  -146.2546     33.7454 ]
  Theta =  -0.205719   -2.935873  [ DEG:   -11.7869   -168.2132 ]
  Phi   =  -1.317651    1.823942  [ DEG:   -75.4958    104.5042 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hsj_D                                        
REMARK     2: T0448.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hsj_D.T0448.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  214  213   5.0  166   2.05   19.88  64.498
REMARK  ---------------------------------------------------------- 
MOLECULE 2hsj_D
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   21-JUL-06   2HSJ              
TITLE     THE STRUCTURE OF A PUTATIVE PLATELET ACTIVATING FACTOR FROM           
TITLE    2 STREPTOCOCCUS PNEUMONIA.                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE PLATELET ACTIVATING FACTOR;                       
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PNEUMONIAE;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: TIGR4;                                                       
SOURCE   5 GENE: SP1450;                                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    PLATELET ACTIVATING FACTOR, STREPTOCOCCUS PNEUMONIA,                  
KEYWDS   2 STRUCTRAL GENOMICS, STRUCTURAL GENOMICS, PSI-2, PROTEIN              
KEYWDS   3 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   4 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.CUFF,R.MULLIGAN,J.ABDULLAH,A.JOACHIMIAK,MIDWEST CENTER            
AUTHOR   2 FOR STRUCTURAL GENOMICS (MCSG)                                       
REVDAT   1   19-SEP-06 2HSJ    0                                                
JRNL        AUTH   M.E.CUFF,R.MULLIGAN,J.ABDULLAH,A.JOACHIMIAK                  
JRNL        TITL   THE STRUCTURE OF A PUTATIVE PLATELET ACTIVATING              
JRNL        TITL 2 FACTOR FROM STREPTOCOCCUS PNEUMONIA.                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2HSJ A    1   211  UNP    Q97PY9   Q97PY9_STRPN     1    211             
DBREF  2HSJ B    1   211  UNP    Q97PY9   Q97PY9_STRPN     1    211             
DBREF  2HSJ C    1   211  UNP    Q97PY9   Q97PY9_STRPN     1    211             
DBREF  2HSJ D    1   211  UNP    Q97PY9   Q97PY9_STRPN     1    211             
SEQRES   1 A  214  SER ASN ALA MSE ALA VAL GLN LEU LEU GLU ASN TRP LEU          
SEQRES   2 A  214  LEU LYS GLU GLN GLU LYS ILE GLN THR LYS TYR ARG HIS          
SEQRES   3 A  214  LEU ASN HIS ILE SER VAL VAL GLU PRO ASN ILE LEU PHE          
SEQRES   4 A  214  ILE GLY ASP SER ILE VAL GLU TYR TYR PRO LEU GLN GLU          
SEQRES   5 A  214  LEU PHE GLY THR SER LYS THR ILE VAL ASN ARG GLY ILE          
SEQRES   6 A  214  ARG GLY TYR GLN THR GLY LEU LEU LEU GLU ASN LEU ASP          
SEQRES   7 A  214  ALA HIS LEU TYR GLY GLY ALA VAL ASP LYS ILE PHE LEU          
SEQRES   8 A  214  LEU ILE GLY THR ASN ASP ILE GLY LYS ASP VAL PRO VAL          
SEQRES   9 A  214  ASN GLU ALA LEU ASN ASN LEU GLU ALA ILE ILE GLN SER          
SEQRES  10 A  214  VAL ALA ARG ASP TYR PRO LEU THR GLU ILE LYS LEU LEU          
SEQRES  11 A  214  SER ILE LEU PRO VAL ASN GLU ARG GLU GLU TYR GLN GLN          
SEQRES  12 A  214  ALA VAL TYR ILE ARG SER ASN GLU LYS ILE GLN ASN TRP          
SEQRES  13 A  214  ASN GLN ALA TYR GLN GLU LEU ALA SER ALA TYR MSE GLN          
SEQRES  14 A  214  VAL GLU PHE VAL PRO VAL PHE ASP CYS LEU THR ASP GLN          
SEQRES  15 A  214  ALA GLY GLN LEU LYS LYS GLU TYR THR THR ASP GLY LEU          
SEQRES  16 A  214  HIS LEU SER ILE ALA GLY TYR GLN ALA LEU SER LYS SER          
SEQRES  17 A  214  LEU LYS ASP TYR LEU TYR                                      
SEQRES   1 B  214  SER ASN ALA MSE ALA VAL GLN LEU LEU GLU ASN TRP LEU          
SEQRES   2 B  214  LEU LYS GLU GLN GLU LYS ILE GLN THR LYS TYR ARG HIS          
SEQRES   3 B  214  LEU ASN HIS ILE SER VAL VAL GLU PRO ASN ILE LEU PHE          
SEQRES   4 B  214  ILE GLY ASP SER ILE VAL GLU TYR TYR PRO LEU GLN GLU          
SEQRES   5 B  214  LEU PHE GLY THR SER LYS THR ILE VAL ASN ARG GLY ILE          
SEQRES   6 B  214  ARG GLY TYR GLN THR GLY LEU LEU LEU GLU ASN LEU ASP          
SEQRES   7 B  214  ALA HIS LEU TYR GLY GLY ALA VAL ASP LYS ILE PHE LEU          
SEQRES   8 B  214  LEU ILE GLY THR ASN ASP ILE GLY LYS ASP VAL PRO VAL          
SEQRES   9 B  214  ASN GLU ALA LEU ASN ASN LEU GLU ALA ILE ILE GLN SER          
SEQRES  10 B  214  VAL ALA ARG ASP TYR PRO LEU THR GLU ILE LYS LEU LEU          
SEQRES  11 B  214  SER ILE LEU PRO VAL ASN GLU ARG GLU GLU TYR GLN GLN          
SEQRES  12 B  214  ALA VAL TYR ILE ARG SER ASN GLU LYS ILE GLN ASN TRP          
SEQRES  13 B  214  ASN GLN ALA TYR GLN GLU LEU ALA SER ALA TYR MSE GLN          
SEQRES  14 B  214  VAL GLU PHE VAL PRO VAL PHE ASP CYS LEU THR ASP GLN          
SEQRES  15 B  214  ALA GLY GLN LEU LYS LYS GLU TYR THR THR ASP GLY LEU          
SEQRES  16 B  214  HIS LEU SER ILE ALA GLY TYR GLN ALA LEU SER LYS SER          
SEQRES  17 B  214  LEU LYS ASP TYR LEU TYR                                      
SEQRES   1 C  214  SER ASN ALA MSE ALA VAL GLN LEU LEU GLU ASN TRP LEU          
SEQRES   2 C  214  LEU LYS GLU GLN GLU LYS ILE GLN THR LYS TYR ARG HIS          
SEQRES   3 C  214  LEU ASN HIS ILE SER VAL VAL GLU PRO ASN ILE LEU PHE          
SEQRES   4 C  214  ILE GLY ASP SER ILE VAL GLU TYR TYR PRO LEU GLN GLU          
SEQRES   5 C  214  LEU PHE GLY THR SER LYS THR ILE VAL ASN ARG GLY ILE          
SEQRES   6 C  214  ARG GLY TYR GLN THR GLY LEU LEU LEU GLU ASN LEU ASP          
SEQRES   7 C  214  ALA HIS LEU TYR GLY GLY ALA VAL ASP LYS ILE PHE LEU          
SEQRES   8 C  214  LEU ILE GLY THR ASN ASP ILE GLY LYS ASP VAL PRO VAL          
SEQRES   9 C  214  ASN GLU ALA LEU ASN ASN LEU GLU ALA ILE ILE GLN SER          
SEQRES  10 C  214  VAL ALA ARG ASP TYR PRO LEU THR GLU ILE LYS LEU LEU          
SEQRES  11 C  214  SER ILE LEU PRO VAL ASN GLU ARG GLU GLU TYR GLN GLN          
SEQRES  12 C  214  ALA VAL TYR ILE ARG SER ASN GLU LYS ILE GLN ASN TRP          
SEQRES  13 C  214  ASN GLN ALA TYR GLN GLU LEU ALA SER ALA TYR MSE GLN          
SEQRES  14 C  214  VAL GLU PHE VAL PRO VAL PHE ASP CYS LEU THR ASP GLN          
SEQRES  15 C  214  ALA GLY GLN LEU LYS LYS GLU TYR THR THR ASP GLY LEU          
SEQRES  16 C  214  HIS LEU SER ILE ALA GLY TYR GLN ALA LEU SER LYS SER          
SEQRES  17 C  214  LEU LYS ASP TYR LEU TYR                                      
SEQRES   1 D  214  SER ASN ALA MSE ALA VAL GLN LEU LEU GLU ASN TRP LEU          
SEQRES   2 D  214  LEU LYS GLU GLN GLU LYS ILE GLN THR LYS TYR ARG HIS          
SEQRES   3 D  214  LEU ASN HIS ILE SER VAL VAL GLU PRO ASN ILE LEU PHE          
SEQRES   4 D  214  ILE GLY ASP SER ILE VAL GLU TYR TYR PRO LEU GLN GLU          
SEQRES   5 D  214  LEU PHE GLY THR SER LYS THR ILE VAL ASN ARG GLY ILE          
SEQRES   6 D  214  ARG GLY TYR GLN THR GLY LEU LEU LEU GLU ASN LEU ASP          
SEQRES   7 D  214  ALA HIS LEU TYR GLY GLY ALA VAL ASP LYS ILE PHE LEU          
SEQRES   8 D  214  LEU ILE GLY THR ASN ASP ILE GLY LYS ASP VAL PRO VAL          
SEQRES   9 D  214  ASN GLU ALA LEU ASN ASN LEU GLU ALA ILE ILE GLN SER          
SEQRES  10 D  214  VAL ALA ARG ASP TYR PRO LEU THR GLU ILE LYS LEU LEU          
SEQRES  11 D  214  SER ILE LEU PRO VAL ASN GLU ARG GLU GLU TYR GLN GLN          
SEQRES  12 D  214  ALA VAL TYR ILE ARG SER ASN GLU LYS ILE GLN ASN TRP          
SEQRES  13 D  214  ASN GLN ALA TYR GLN GLU LEU ALA SER ALA TYR MSE GLN          
SEQRES  14 D  214  VAL GLU PHE VAL PRO VAL PHE ASP CYS LEU THR ASP GLN          
SEQRES  15 D  214  ALA GLY GLN LEU LYS LYS GLU TYR THR THR ASP GLY LEU          
SEQRES  16 D  214  HIS LEU SER ILE ALA GLY TYR GLN ALA LEU SER LYS SER          
SEQRES  17 D  214  LEU LYS ASP TYR LEU TYR                                      
HET    MSE  A   1      16                                                       
HET    MSE  A 165       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B 165       8                                                       
HET    MSE  C   1      16                                                       
HET    MSE  C 165       8                                                       
HET    MSE  D   1      16                                                       
HET    MSE  D 165       8                                                       
HET     MG   1301       1                                                       
HET     MG   1302       1                                                       
HET     MG   1303       1                                                       
HET     MG   1304       1                                                       
HET     MG   1305       1                                                       
HET     MG   1306       1                                                       
HET     MG   1307       1                                                       
HET    GOL   1401       6                                                       
HET    GOL   1402       6                                                       
HET    GOL   1403       6                                                       
HET    GOL   1404       6                                                       
HET    GOL   1405       6                                                       
HET    GOL   1406       6                                                       
HET    GOL   1407       6                                                       
HET    GOL   1408       6                                                       
HET    GOL   1409       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   5   MG    7(MG 2+)                                                     
FORMUL  12  GOL    9(C3 H8 O3)                                                  
FORMUL  21  HOH   *1266(H2 O)                                                   
CRYST1   41.032  120.063   84.743  90.00  99.48  90.00 P 1 21 1      8          
ATOM   5299  N   SER D  -2       1.820  54.309 121.395  1.00 43.41           N  
ATOM   5300  CA  SER D  -2       1.867  55.708 120.889  1.00 43.44           C  
ATOM   5301  C   SER D  -2       0.962  56.699 121.645  1.00 42.91           C  
ATOM   5302  O   SER D  -2       0.157  56.326 122.511  1.00 43.19           O  
ATOM   5303  CB  SER D  -2       1.586  55.764 119.379  1.00 43.44           C  
ATOM   5304  OG  SER D  -2       2.745  55.426 118.628  1.00 45.17           O  
ATOM   5305  N   ASN D  -1       1.123  57.968 121.279  1.00 42.01           N  
ATOM   5306  CA  ASN D  -1       0.573  59.112 121.985  1.00 40.82           C  
ATOM   5307  C   ASN D  -1       0.307  60.200 120.938  1.00 39.99           C  
ATOM   5308  O   ASN D  -1       1.215  60.579 120.191  1.00 39.90           O  
ATOM   5309  CB  ASN D  -1       1.595  59.553 123.047  1.00 40.86           C  
ATOM   5310  CG  ASN D  -1       1.293  60.905 123.647  1.00 40.66           C  
ATOM   5311  OD1 ASN D  -1       1.389  61.931 122.977  1.00 39.86           O  
ATOM   5312  ND2 ASN D  -1       0.975  60.919 124.936  1.00 41.17           N  
ATOM   5313  N   ALA D   0      -0.939  60.673 120.876  1.00 38.78           N  
ATOM   5314  CA  ALA D   0      -1.412  61.573 119.804  1.00 37.73           C  
ATOM   5315  C   ALA D   0      -0.647  62.894 119.681  1.00 37.12           C  
ATOM   5316  O   ALA D   0      -0.502  63.439 118.575  1.00 36.61           O  
ATOM   5317  CB  ALA D   0      -2.883  61.846 119.963  1.00 37.61           C  
HETATM 5318  N   MSE D   1      -0.183  63.401 120.821  0.60 36.68           N  
HETATM 5320  CA  MSE D   1       0.669  64.584 120.885  0.60 36.62           C  
HETATM 5322  C   MSE D   1       1.997  64.275 120.195  0.60 35.65           C  
HETATM 5324  O   MSE D   1       2.504  65.078 119.406  0.60 35.05           O  
HETATM 5326  CB  MSE D   1       0.903  65.001 122.347  0.60 37.64           C  
HETATM 5328  CG  MSE D   1      -0.375  65.282 123.160  0.60 39.93           C  
HETATM 5330 SE   MSE D   1      -1.599  63.742 123.339  0.60 49.07          SE  
HETATM 5332  CE  MSE D   1      -1.350  63.258 125.214  0.60 42.35           C  
ATOM   5334  N   ALA D   2       2.539  63.094 120.488  1.00 34.81           N  
ATOM   5335  CA  ALA D   2       3.772  62.619 119.865  1.00 34.01           C  
ATOM   5336  C   ALA D   2       3.557  62.284 118.377  1.00 33.00           C  
ATOM   5337  O   ALA D   2       4.447  62.535 117.565  1.00 32.99           O  
ATOM   5338  CB  ALA D   2       4.344  61.438 120.626  1.00 33.97           C  
ATOM   5339  N   VAL D   3       2.373  61.758 118.031  1.00 31.99           N  
ATOM   5340  CA  VAL D   3       1.968  61.552 116.623  1.00 30.72           C  
ATOM   5341  C   VAL D   3       2.123  62.854 115.832  1.00 29.77           C  
ATOM   5342  O   VAL D   3       2.846  62.895 114.840  1.00 29.14           O  
ATOM   5343  CB  VAL D   3       0.503  61.014 116.490  1.00 31.08           C  
ATOM   5344  CG1 VAL D   3      -0.030  61.146 115.041  1.00 30.21           C  
ATOM   5345  CG2 VAL D   3       0.410  59.565 116.958  1.00 31.41           C  
ATOM   5346  N   GLN D   4       1.455  63.913 116.290  1.00 28.68           N  
ATOM   5347  CA  GLN D   4       1.541  65.230 115.656  1.00 28.32           C  
ATOM   5348  C   GLN D   4       2.984  65.694 115.505  1.00 27.32           C  
ATOM   5349  O   GLN D   4       3.375  66.164 114.444  1.00 27.05           O  
ATOM   5350  CB  GLN D   4       0.792  66.284 116.481  1.00 28.84           C  
ATOM   5351  CG  GLN D   4      -0.178  67.228 115.726  1.00 31.67           C  
ATOM   5352  CD  GLN D   4       0.246  67.705 114.310  1.00 35.73           C  
ATOM   5353  OE1 GLN D   4       0.876  66.982 113.528  1.00 37.66           O  
ATOM   5354  NE2 GLN D   4      -0.175  68.922 113.968  1.00 37.37           N  
ATOM   5355  N   LEU D   5       3.779  65.581 116.566  1.00 26.58           N  
ATOM   5356  CA  LEU D   5       5.142  66.115 116.512  1.00 25.65           C  
ATOM   5357  C   LEU D   5       6.060  65.324 115.568  1.00 25.50           C  
ATOM   5358  O   LEU D   5       6.940  65.914 114.941  1.00 24.67           O  
ATOM   5359  CB  LEU D   5       5.753  66.284 117.911  1.00 25.59           C  
ATOM   5360  CG  LEU D   5       5.055  67.324 118.799  1.00 25.35           C  
ATOM   5361  CD1 LEU D   5       5.355  67.024 120.233  1.00 25.27           C  
ATOM   5362  CD2 LEU D   5       5.409  68.782 118.462  1.00 24.86           C  
ATOM   5363  N   LEU D   6       5.838  64.013 115.458  1.00 24.91           N  
ATOM   5364  CA  LEU D   6       6.539  63.191 114.462  1.00 25.05           C  
ATOM   5365  C   LEU D   6       6.129  63.542 113.047  1.00 24.60           C  
ATOM   5366  O   LEU D   6       6.965  63.603 112.148  1.00 24.38           O  
ATOM   5367  CB  LEU D   6       6.304  61.697 114.685  1.00 25.38           C  
ATOM   5368  CG  LEU D   6       7.049  61.045 115.851  1.00 26.42           C  
ATOM   5369  CD1 LEU D   6       6.917  59.533 115.735  1.00 29.07           C  
ATOM   5370  CD2 LEU D   6       8.512  61.452 115.875  1.00 27.90           C  
ATOM   5371  N   GLU D   7       4.833  63.736 112.834  1.00 23.40           N  
ATOM   5372  CA  GLU D   7       4.355  64.239 111.548  1.00 23.30           C  
ATOM   5373  C   GLU D   7       5.042  65.584 111.303  1.00 21.28           C  
ATOM   5374  O   GLU D   7       5.513  65.877 110.192  1.00 19.91           O  
ATOM   5375  CB  GLU D   7       2.839  64.392 111.605  1.00 22.89           C  
ATOM   5376  CG  GLU D   7       2.177  64.843 110.328  1.00 26.07           C  
ATOM   5377  CD  GLU D   7       0.684  65.084 110.508  1.00 26.59           C  
ATOM   5378  OE1 GLU D   7       0.032  64.321 111.279  1.00 29.11           O  
ATOM   5379  OE2 GLU D   7       0.168  66.050 109.887  1.00 31.46           O  
ATOM   5380  N   ASN D   8       5.149  66.379 112.375  1.00 20.09           N  
ATOM   5381  CA  ASN D   8       5.848  67.653 112.316  1.00 19.79           C  
ATOM   5382  C   ASN D   8       7.339  67.464 112.032  1.00 19.29           C  
ATOM   5383  O   ASN D   8       7.905  68.245 111.298  1.00 20.29           O  
ATOM   5384  CB  ASN D   8       5.622  68.494 113.587  1.00 19.36           C  
ATOM   5385  CG  ASN D   8       4.177  69.004 113.716  1.00 20.28           C  
ATOM   5386  OD1 ASN D   8       3.358  68.850 112.805  1.00 19.57           O  
ATOM   5387  ND2 ASN D   8       3.862  69.607 114.871  1.00 21.42           N  
ATOM   5388  N   TRP D   9       7.951  66.422 112.598  0.50 19.39           N  
ATOM   5390  CA  TRP D   9       9.363  66.129 112.342  0.50 19.23           C  
ATOM   5392  C   TRP D   9       9.605  65.807 110.867  0.50 18.44           C  
ATOM   5394  O   TRP D   9      10.580  66.276 110.270  0.50 18.20           O  
ATOM   5396  CB  TRP D   9       9.870  64.972 113.209  0.50 20.20           C  
ATOM   5398  CG  TRP D   9      11.345  64.696 113.015  0.50 21.74           C  
ATOM   5400  CD1 TRP D   9      12.390  65.436 113.496  0.50 22.93           C  
ATOM   5402  CD2 TRP D   9      11.929  63.615 112.278  0.50 22.78           C  
ATOM   5404  NE1 TRP D   9      13.586  64.881 113.108  0.50 23.79           N  
ATOM   5406  CE2 TRP D   9      13.332  63.760 112.361  0.50 23.09           C  
ATOM   5408  CE3 TRP D   9      11.402  62.527 111.562  0.50 23.67           C  
ATOM   5410  CZ2 TRP D   9      14.215  62.864 111.752  0.50 23.16           C  
ATOM   5412  CZ3 TRP D   9      12.278  61.639 110.963  0.50 22.76           C  
ATOM   5414  CH2 TRP D   9      13.669  61.814 111.061  0.50 22.45           C  
ATOM   5416  N   LEU D  10       8.717  65.009 110.285  1.00 17.06           N  
ATOM   5417  CA  LEU D  10       8.846  64.637 108.866  1.00 16.56           C  
ATOM   5418  C   LEU D  10       8.660  65.862 107.966  1.00 16.98           C  
ATOM   5419  O   LEU D  10       9.443  66.080 107.030  1.00 16.04           O  
ATOM   5420  CB  LEU D  10       7.852  63.534 108.511  1.00 16.20           C  
ATOM   5421  CG  LEU D  10       7.890  63.208 107.016  1.00 14.12           C  
ATOM   5422  CD1 LEU D  10       9.252  62.645 106.547  1.00 16.19           C  
ATOM   5423  CD2 LEU D  10       6.736  62.268 106.665  1.00 17.41           C  
ATOM   5424  N   LEU D  11       7.637  66.667 108.236  1.00 16.90           N  
ATOM   5425  CA  LEU D  11       7.435  67.902 107.475  1.00 18.03           C  
ATOM   5426  C   LEU D  11       8.633  68.850 107.542  1.00 17.68           C  
ATOM   5427  O   LEU D  11       9.069  69.355 106.496  1.00 18.05           O  
ATOM   5428  CB  LEU D  11       6.162  68.637 107.884  1.00 18.64           C  
ATOM   5429  CG  LEU D  11       4.840  67.878 107.728  1.00 20.57           C  
ATOM   5430  CD1 LEU D  11       3.709  68.508 108.551  1.00 22.19           C  
ATOM   5431  CD2 LEU D  11       4.435  67.774 106.267  1.00 22.95           C  
ATOM   5432  N   LYS D  12       9.197  69.076 108.725  0.50 17.68           N  
ATOM   5434  CA  LYS D  12      10.350  69.988 108.799  0.50 17.86           C  
ATOM   5436  C   LYS D  12      11.604  69.432 108.116  0.50 17.55           C  
ATOM   5438  O   LYS D  12      12.370  70.195 107.525  0.50 17.52           O  
ATOM   5440  CB  LYS D  12      10.667  70.449 110.220  0.50 18.42           C  
ATOM   5442  CG  LYS D  12      11.281  71.854 110.239  0.50 19.68           C  
ATOM   5444  CD  LYS D  12      11.816  72.239 111.595  0.50 21.61           C  
ATOM   5446  CE  LYS D  12      11.782  73.744 111.782  0.50 21.99           C  
ATOM   5448  NZ  LYS D  12      10.449  74.196 112.288  0.50 22.61           N  
ATOM   5450  N   GLU D  13      11.817  68.120 108.187  1.00 16.47           N  
ATOM   5451  CA  GLU D  13      12.928  67.527 107.426  1.00 16.48           C  
ATOM   5452  C   GLU D  13      12.719  67.706 105.911  1.00 15.32           C  
ATOM   5453  O   GLU D  13      13.653  68.063 105.187  1.00 15.13           O  
ATOM   5454  CB  GLU D  13      13.118  66.051 107.769  1.00 17.70           C  
ATOM   5455  CG  GLU D  13      13.633  65.791 109.181  1.00 21.18           C  
ATOM   5456  CD  GLU D  13      14.952  66.487 109.450  1.00 28.14           C  
ATOM   5457  OE1 GLU D  13      15.987  66.055 108.907  1.00 32.48           O  
ATOM   5458  OE2 GLU D  13      14.953  67.471 110.213  1.00 33.03           O  
ATOM   5459  N   GLN D  14      11.498  67.495 105.429  1.00 14.46           N  
ATOM   5460  CA  GLN D  14      11.233  67.664 103.996  1.00 13.83           C  
ATOM   5461  C   GLN D  14      11.466  69.108 103.552  1.00 14.43           C  
ATOM   5462  O   GLN D  14      12.087  69.355 102.517  1.00 14.76           O  
ATOM   5463  CB  GLN D  14       9.807  67.229 103.647  1.00 13.41           C  
ATOM   5464  CG  GLN D  14       9.555  65.738 103.841  1.00 11.46           C  
ATOM   5465  CD  GLN D  14       8.091  65.382 103.611  1.00 13.55           C  
ATOM   5466  OE1 GLN D  14       7.210  66.175 103.931  1.00 14.38           O  
ATOM   5467  NE2 GLN D  14       7.831  64.194 103.090  1.00 12.31           N  
ATOM   5468  N   GLU D  15      10.983  70.066 104.351  1.00 15.25           N  
ATOM   5469  CA  GLU D  15      11.170  71.477 104.069  1.00 16.77           C  
ATOM   5470  C   GLU D  15      12.664  71.857 104.073  1.00 14.19           C  
ATOM   5471  O   GLU D  15      13.115  72.600 103.189  1.00 14.73           O  
ATOM   5472  CB  GLU D  15      10.415  72.313 105.109  1.00 17.11           C  
ATOM   5473  CG  GLU D  15      10.576  73.811 104.946  1.00 22.62           C  
ATOM   5474  CD  GLU D  15       9.907  74.600 106.061  1.00 22.82           C  
ATOM   5475  OE1 GLU D  15       8.828  74.153 106.550  1.00 29.74           O  
ATOM   5476  OE2 GLU D  15      10.459  75.661 106.454  1.00 28.27           O  
ATOM   5477  N   LYS D  16      13.428  71.309 105.017  1.00 14.18           N  
ATOM   5478  CA  LYS D  16      14.881  71.552 105.044  1.00 13.49           C  
ATOM   5479  C   LYS D  16      15.560  71.021 103.778  1.00 12.49           C  
ATOM   5480  O   LYS D  16      16.471  71.651 103.245  1.00 11.97           O  
ATOM   5481  CB  LYS D  16      15.517  70.915 106.276  1.00 14.23           C  
ATOM   5482  CG  LYS D  16      15.223  71.684 107.551  1.00 17.80           C  
ATOM   5483  CD  LYS D  16      15.444  70.838 108.825  1.00 21.17           C  
ATOM   5484  CE  LYS D  16      16.850  70.245 108.917  1.00 25.58           C  
ATOM   5485  NZ  LYS D  16      17.034  69.418 110.168  1.00 26.62           N  
ATOM   5486  N   ILE D  17      15.138  69.842 103.328  1.00 11.85           N  
ATOM   5487  CA  ILE D  17      15.761  69.281 102.129  1.00 11.18           C  
ATOM   5488  C   ILE D  17      15.351  70.062 100.886  1.00 11.16           C  
ATOM   5489  O   ILE D  17      16.184  70.315 100.019  1.00 10.70           O  
ATOM   5490  CB  ILE D  17      15.485  67.779 101.975  1.00 12.32           C  
ATOM   5491  CG1 ILE D  17      16.109  67.039 103.160  1.00 14.36           C  
ATOM   5492  CG2 ILE D  17      16.033  67.279 100.640  1.00 12.55           C  
ATOM   5493  CD1 ILE D  17      15.559  65.618 103.384  1.00 14.71           C  
ATOM   5494  N   GLN D  18      14.090  70.497 100.828  1.00  9.94           N  
ATOM   5495  CA  GLN D  18      13.684  71.342  99.708  1.00 10.50           C  
ATOM   5496  C   GLN D  18      14.514  72.643  99.614  1.00 10.59           C  
ATOM   5497  O   GLN D  18      14.921  73.071  98.524  1.00 11.87           O  
ATOM   5498  CB  GLN D  18      12.192  71.645  99.841  1.00 10.17           C  
ATOM   5499  CG  GLN D  18      11.341  70.436  99.584  1.00 12.41           C  
ATOM   5500  CD  GLN D  18       9.912  70.571 100.060  1.00 13.85           C  
ATOM   5501  OE1 GLN D  18       9.609  71.396 100.930  1.00 14.05           O  
ATOM   5502  NE2 GLN D  18       9.026  69.723  99.516  1.00 13.95           N  
ATOM   5503  N   THR D  19      14.789  73.246 100.769  1.00 10.70           N  
ATOM   5504  CA  THR D  19      15.584  74.459 100.807  1.00 11.34           C  
ATOM   5505  C   THR D  19      17.018  74.185 100.315  1.00 10.77           C  
ATOM   5506  O   THR D  19      17.591  74.942  99.518  1.00 11.78           O  
ATOM   5507  CB  THR D  19      15.583  75.031 102.229  1.00 11.35           C  
ATOM   5508  OG1 THR D  19      14.240  75.461 102.543  1.00 12.83           O  
ATOM   5509  CG2 THR D  19      16.574  76.209 102.347  1.00 12.03           C  
ATOM   5510  N   LYS D  20      17.563  73.078 100.785  1.00  9.95           N  
ATOM   5511  CA  LYS D  20      18.898  72.631 100.391  1.00 10.93           C  
ATOM   5512  C   LYS D  20      18.954  72.463  98.870  1.00  9.59           C  
ATOM   5513  O   LYS D  20      19.855  72.998  98.203  1.00 10.88           O  
ATOM   5514  CB  LYS D  20      19.191  71.302 101.082  1.00 11.14           C  
ATOM   5515  CG  LYS D  20      20.611  70.751 100.847  1.00 13.00           C  
ATOM   5516  CD  LYS D  20      20.813  69.366 101.396  1.00 13.20           C  
ATOM   5517  CE  LYS D  20      22.303  68.987 101.429  1.00 15.55           C  
ATOM   5518  NZ  LYS D  20      22.499  67.537 101.845  1.00 14.58           N  
ATOM   5519  N   TYR D  21      17.987  71.740  98.308  1.00 10.21           N  
ATOM   5520  CA  TYR D  21      17.984  71.524  96.874  1.00  8.84           C  
ATOM   5521  C   TYR D  21      17.813  72.822  96.088  1.00  8.90           C  
ATOM   5522  O   TYR D  21      18.467  73.016  95.068  1.00 10.48           O  
ATOM   5523  CB  TYR D  21      16.840  70.598  96.536  1.00  9.25           C  
ATOM   5524  CG  TYR D  21      17.063  69.136  96.895  1.00  9.57           C  
ATOM   5525  CD1 TYR D  21      18.331  68.648  97.286  1.00  9.94           C  
ATOM   5526  CD2 TYR D  21      16.009  68.228  96.824  1.00  9.21           C  
ATOM   5527  CE1 TYR D  21      18.523  67.270  97.585  1.00 11.31           C  
ATOM   5528  CE2 TYR D  21      16.187  66.882  97.124  1.00  8.84           C  
ATOM   5529  CZ  TYR D  21      17.434  66.398  97.485  1.00  9.54           C  
ATOM   5530  OH  TYR D  21      17.603  65.048  97.772  1.00 10.63           O  
ATOM   5531  N   ARG D  22      16.960  73.719  96.560  1.00  9.78           N  
ATOM   5532  CA  ARG D  22      16.757  74.958  95.818  1.00 10.44           C  
ATOM   5533  C   ARG D  22      18.053  75.748  95.703  1.00 10.88           C  
ATOM   5534  O   ARG D  22      18.346  76.334  94.651  1.00 11.70           O  
ATOM   5535  CB  ARG D  22      15.616  75.793  96.414  1.00 10.74           C  
ATOM   5536  CG  ARG D  22      14.275  75.214  96.064  1.00 12.11           C  
ATOM   5537  CD  ARG D  22      13.149  76.061  96.652  1.00 13.56           C  
ATOM   5538  NE  ARG D  22      11.873  75.478  96.223  1.00 14.52           N  
ATOM   5539  CZ  ARG D  22      10.965  74.936  97.026  1.00 13.43           C  
ATOM   5540  NH1 ARG D  22      11.133  74.946  98.348  1.00 12.64           N  
ATOM   5541  NH2 ARG D  22       9.860  74.419  96.497  1.00 14.31           N  
ATOM   5542  N   HIS D  23      18.850  75.747  96.766  1.00 10.64           N  
ATOM   5543  CA  HIS D  23      20.108  76.478  96.709  1.00 11.32           C  
ATOM   5544  C   HIS D  23      21.146  75.718  95.866  1.00 11.36           C  
ATOM   5545  O   HIS D  23      21.856  76.315  95.056  1.00 11.54           O  
ATOM   5546  CB  HIS D  23      20.654  76.739  98.109  1.00 12.23           C  
ATOM   5547  CG  HIS D  23      21.743  77.779  98.153  1.00 14.00           C  
ATOM   5548  ND1 HIS D  23      22.079  78.420  99.324  1.00 12.90           N  
ATOM   5549  CD2 HIS D  23      22.530  78.335  97.190  1.00 14.19           C  
ATOM   5550  CE1 HIS D  23      23.074  79.267  99.108  1.00 14.69           C  
ATOM   5551  NE2 HIS D  23      23.366  79.239  97.818  1.00 17.72           N  
ATOM   5552  N   LEU D  24      21.215  74.385  96.018  1.00 10.04           N  
ATOM   5553  CA  LEU D  24      22.147  73.639  95.187  1.00 10.51           C  
ATOM   5554  C   LEU D  24      21.832  73.759  93.709  1.00  9.97           C  
ATOM   5555  O   LEU D  24      22.747  73.737  92.856  1.00 10.70           O  
ATOM   5556  CB  LEU D  24      22.139  72.157  95.566  1.00 11.15           C  
ATOM   5557  CG  LEU D  24      22.920  71.793  96.809  1.00 10.53           C  
ATOM   5558  CD1 LEU D  24      22.656  70.294  97.087  1.00 10.47           C  
ATOM   5559  CD2 LEU D  24      24.411  72.071  96.646  1.00 12.40           C  
ATOM   5560  N   ASN D  25      20.547  73.855  93.358  1.00  9.36           N  
ATOM   5561  CA  ASN D  25      20.169  73.994  91.953  1.00  9.99           C  
ATOM   5562  C   ASN D  25      20.856  75.202  91.304  1.00 10.83           C  
ATOM   5563  O   ASN D  25      21.087  75.206  90.079  1.00 12.83           O  
ATOM   5564  CB  ASN D  25      18.662  74.175  91.838  1.00 10.37           C  
ATOM   5565  CG  ASN D  25      17.892  72.920  92.152  1.00 11.02           C  
ATOM   5566  OD1 ASN D  25      18.458  71.839  92.288  1.00 11.05           O  
ATOM   5567  ND2 ASN D  25      16.577  73.052  92.238  1.00 11.82           N  
ATOM   5568  N   HIS D  26      21.183  76.206  92.114  1.00 10.77           N  
ATOM   5569  CA  HIS D  26      21.806  77.428  91.588  1.00 11.67           C  
ATOM   5570  C   HIS D  26      23.321  77.394  91.587  1.00 12.18           C  
ATOM   5571  O   HIS D  26      23.961  77.991  90.710  1.00 14.16           O  
ATOM   5572  CB  HIS D  26      21.386  78.643  92.403  1.00 12.29           C  
ATOM   5573  CG  HIS D  26      19.966  79.052  92.185  1.00 14.40           C  
ATOM   5574  ND1 HIS D  26      19.516  79.570  90.988  1.00 17.81           N  
ATOM   5575  CD2 HIS D  26      18.903  79.051  93.023  1.00 20.75           C  
ATOM   5576  CE1 HIS D  26      18.229  79.848  91.091  1.00 20.47           C  
ATOM   5577  NE2 HIS D  26      17.832  79.544  92.316  1.00 21.95           N  
ATOM   5578  N   ILE D  27      23.898  76.731  92.586  1.00 10.31           N  
ATOM   5579  CA  ILE D  27      25.349  76.791  92.736  1.00 10.22           C  
ATOM   5580  C   ILE D  27      26.070  75.472  92.418  1.00 10.12           C  
ATOM   5581  O   ILE D  27      27.294  75.417  92.453  1.00  9.66           O  
ATOM   5582  CB  ILE D  27      25.797  77.311  94.133  1.00 10.15           C  
ATOM   5583  CG1 ILE D  27      25.518  76.298  95.268  1.00 10.72           C  
ATOM   5584  CG2 ILE D  27      25.169  78.711  94.418  1.00 11.75           C  
ATOM   5585  CD1 ILE D  27      26.297  76.626  96.557  1.00 10.03           C  
ATOM   5586  N   SER D  28      25.315  74.436  92.086  1.00  9.93           N  
ATOM   5587  CA  SER D  28      25.980  73.170  91.739  1.00  9.67           C  
ATOM   5588  C   SER D  28      27.063  73.343  90.659  1.00  9.87           C  
ATOM   5589  O   SER D  28      26.861  74.100  89.677  1.00 10.49           O  
ATOM   5590  CB  SER D  28      24.960  72.169  91.241  1.00  9.96           C  
ATOM   5591  OG  SER D  28      25.623  71.022  90.733  1.00 10.40           O  
ATOM   5592  N   VAL D  29      28.169  72.608  90.802  1.00  8.51           N  
ATOM   5593  CA  VAL D  29      29.248  72.675  89.822  1.00  9.60           C  
ATOM   5594  C   VAL D  29      29.151  71.547  88.786  1.00  9.85           C  
ATOM   5595  O   VAL D  29      30.019  71.456  87.908  1.00 11.27           O  
ATOM   5596  CB  VAL D  29      30.659  72.703  90.470  1.00  8.78           C  
ATOM   5597  CG1 VAL D  29      30.756  73.829  91.454  1.00 10.85           C  
ATOM   5598  CG2 VAL D  29      31.007  71.355  91.125  1.00 10.41           C  
ATOM   5599  N   VAL D  30      28.122  70.700  88.872  1.00  9.24           N  
ATOM   5600  CA  VAL D  30      27.974  69.627  87.889  1.00 10.69           C  
ATOM   5601  C   VAL D  30      26.738  69.876  87.033  1.00 10.89           C  
ATOM   5602  O   VAL D  30      25.806  70.574  87.440  1.00 11.85           O  
ATOM   5603  CB  VAL D  30      27.906  68.218  88.540  1.00 11.28           C  
ATOM   5604  CG1 VAL D  30      29.171  67.972  89.344  1.00 10.46           C  
ATOM   5605  CG2 VAL D  30      26.668  68.078  89.438  1.00 11.39           C  
ATOM   5606  N   GLU D  31      26.731  69.265  85.849  1.00 10.58           N  
ATOM   5607  CA  GLU D  31      25.562  69.268  84.981  1.00 11.33           C  
ATOM   5608  C   GLU D  31      24.898  67.904  85.088  1.00 11.20           C  
ATOM   5609  O   GLU D  31      25.504  66.887  84.721  1.00 12.99           O  
ATOM   5610  CB  GLU D  31      26.011  69.505  83.537  1.00 11.60           C  
ATOM   5611  CG  GLU D  31      26.339  70.974  83.263  1.00 12.00           C  
ATOM   5612  CD  GLU D  31      25.107  71.861  83.126  1.00 13.24           C  
ATOM   5613  OE1 GLU D  31      23.969  71.377  83.305  1.00 13.44           O  
ATOM   5614  OE2 GLU D  31      25.280  73.068  82.837  1.00 15.49           O  
ATOM   5615  N   PRO D  32      23.673  67.844  85.639  1.00 10.63           N  
ATOM   5616  CA  PRO D  32      23.046  66.531  85.707  1.00 10.89           C  
ATOM   5617  C   PRO D  32      22.731  65.987  84.325  1.00 11.96           C  
ATOM   5618  O   PRO D  32      22.094  66.665  83.538  1.00 13.15           O  
ATOM   5619  CB  PRO D  32      21.749  66.760  86.486  1.00 11.99           C  
ATOM   5620  CG  PRO D  32      21.632  68.224  86.689  1.00 11.88           C  
ATOM   5621  CD  PRO D  32      22.858  68.921  86.251  1.00 10.68           C  
ATOM   5622  N   ASN D  33      23.189  64.779  84.048  1.00 11.07           N  
ATOM   5623  CA  ASN D  33      22.751  64.073  82.856  1.00 11.24           C  
ATOM   5624  C   ASN D  33      21.431  63.365  83.143  1.00 10.74           C  
ATOM   5625  O   ASN D  33      20.536  63.304  82.287  1.00 10.59           O  
ATOM   5626  CB  ASN D  33      23.838  63.104  82.391  1.00 10.57           C  
ATOM   5627  CG  ASN D  33      23.423  62.315  81.162  1.00 12.22           C  
ATOM   5628  OD1 ASN D  33      23.000  61.155  81.278  1.00 13.20           O  
ATOM   5629  ND2 ASN D  33      23.502  62.952  79.967  1.00 11.84           N  
ATOM   5630  N   ILE D  34      21.320  62.830  84.365  1.00 10.30           N  
ATOM   5631  CA  ILE D  34      20.114  62.166  84.830  1.00 10.43           C  
ATOM   5632  C   ILE D  34      19.774  62.813  86.177  1.00  9.84           C  
ATOM   5633  O   ILE D  34      20.671  63.000  87.029  1.00 10.38           O  
ATOM   5634  CB  ILE D  34      20.366  60.637  85.051  1.00 11.19           C  
ATOM   5635  CG1 ILE D  34      21.059  60.008  83.829  1.00 13.38           C  
ATOM   5636  CG2 ILE D  34      19.103  59.917  85.526  1.00 11.67           C  
ATOM   5637  CD1 ILE D  34      20.245  59.814  82.631  1.00 17.81           C  
ATOM   5638  N   LEU D  35      18.505  63.189  86.353  1.00  9.16           N  
ATOM   5639  CA  LEU D  35      18.003  63.555  87.674  1.00  9.95           C  
ATOM   5640  C   LEU D  35      17.169  62.402  88.204  1.00 10.48           C  
ATOM   5641  O   LEU D  35      16.239  61.954  87.506  1.00 11.80           O  
ATOM   5642  CB  LEU D  35      17.123  64.805  87.581  1.00 10.26           C  
ATOM   5643  CG  LEU D  35      17.872  66.118  87.337  1.00 11.38           C  
ATOM   5644  CD1 LEU D  35      16.942  67.189  86.812  1.00 11.42           C  
ATOM   5645  CD2 LEU D  35      18.531  66.671  88.614  1.00 12.75           C  
ATOM   5646  N   PHE D  36      17.473  61.906  89.407  0.50 10.41           N  
ATOM   5648  CA  PHE D  36      16.618  60.904  90.060  0.50 10.43           C  
ATOM   5650  C   PHE D  36      15.739  61.660  91.037  0.50 10.64           C  
ATOM   5652  O   PHE D  36      16.246  62.338  91.931  0.50 10.37           O  
ATOM   5654  CB  PHE D  36      17.455  59.860  90.818  0.50 11.34           C  
ATOM   5656  CG  PHE D  36      17.664  58.570  90.060  0.50 11.69           C  
ATOM   5658  CD1 PHE D  36      18.455  58.547  88.923  0.50 14.29           C  
ATOM   5660  CD2 PHE D  36      17.080  57.386  90.497  0.50 14.07           C  
ATOM   5662  CE1 PHE D  36      18.670  57.361  88.220  0.50 15.31           C  
ATOM   5664  CE2 PHE D  36      17.276  56.199  89.782  0.50 13.57           C  
ATOM   5666  CZ  PHE D  36      18.068  56.193  88.655  0.50 13.74           C  
ATOM   5668  N   ILE D  37      14.428  61.570  90.827  1.00 10.89           N  
ATOM   5669  CA  ILE D  37      13.452  62.289  91.651  1.00 11.22           C  
ATOM   5670  C   ILE D  37      12.497  61.280  92.278  1.00 11.58           C  
ATOM   5671  O   ILE D  37      12.083  60.299  91.654  1.00 11.85           O  
ATOM   5672  CB  ILE D  37      12.644  63.320  90.775  1.00 11.23           C  
ATOM   5673  CG1 ILE D  37      13.617  64.338  90.168  1.00 11.29           C  
ATOM   5674  CG2 ILE D  37      11.531  63.992  91.573  1.00 12.35           C  
ATOM   5675  CD1 ILE D  37      12.918  65.267  89.193  1.00 12.54           C  
ATOM   5676  N   GLY D  38      12.134  61.529  93.523  1.00 11.38           N  
ATOM   5677  CA  GLY D  38      11.138  60.666  94.167  1.00 11.57           C  
ATOM   5678  C   GLY D  38      11.205  60.670  95.662  1.00 11.99           C  
ATOM   5679  O   GLY D  38      11.562  61.688  96.259  1.00 11.84           O  
ATOM   5680  N   ASP D  39      10.876  59.527  96.256  1.00 11.61           N  
ATOM   5681  CA  ASP D  39      10.650  59.462  97.708  1.00 12.14           C  
ATOM   5682  C   ASP D  39      11.859  58.905  98.460  1.00 12.29           C  
ATOM   5683  O   ASP D  39      13.001  59.099  98.023  1.00 10.94           O  
ATOM   5684  CB  ASP D  39       9.361  58.645  97.976  1.00 13.32           C  
ATOM   5685  CG  ASP D  39       9.407  57.229  97.381  1.00 17.59           C  
ATOM   5686  OD1 ASP D  39      10.531  56.712  97.122  1.00 20.53           O  
ATOM   5687  OD2 ASP D  39       8.317  56.607  97.182  1.00 15.83           O  
ATOM   5688  N   SER D  40      11.653  58.237  99.591  1.00 12.08           N  
ATOM   5689  CA  SER D  40      12.789  57.767 100.406  1.00 12.34           C  
ATOM   5690  C   SER D  40      13.713  56.836  99.624  1.00 12.11           C  
ATOM   5691  O   SER D  40      14.906  56.836  99.832  1.00 12.18           O  
ATOM   5692  CB  SER D  40      12.285  56.987 101.632  1.00 14.05           C  
ATOM   5693  OG  SER D  40      11.301  57.717 102.315  1.00 18.41           O  
ATOM   5694  N   ILE D  41      13.141  55.955  98.815  1.00 11.46           N  
ATOM   5695  CA  ILE D  41      13.954  54.993  98.082  1.00 12.92           C  
ATOM   5696  C   ILE D  41      14.966  55.725  97.196  1.00 12.11           C  
ATOM   5697  O   ILE D  41      16.090  55.272  97.022  1.00 11.95           O  
ATOM   5698  CB  ILE D  41      13.078  54.030  97.247  1.00 13.88           C  
ATOM   5699  CG1 ILE D  41      11.993  53.399  98.112  1.00 19.01           C  
ATOM   5700  CG2 ILE D  41      13.936  52.985  96.505  1.00 15.00           C  
ATOM   5701  CD1 ILE D  41      12.505  52.556  99.159  1.00 22.15           C  
ATOM   5702  N   VAL D  42      14.555  56.849  96.616  1.00 11.03           N  
ATOM   5703  CA  VAL D  42      15.497  57.699  95.869  1.00 10.25           C  
ATOM   5704  C   VAL D  42      16.476  58.409  96.804  1.00 10.06           C  
ATOM   5705  O   VAL D  42      17.683  58.370  96.565  1.00 10.51           O  
ATOM   5706  CB  VAL D  42      14.738  58.733  95.007  1.00 10.36           C  
ATOM   5707  CG1 VAL D  42      15.740  59.590  94.223  1.00 10.23           C  
ATOM   5708  CG2 VAL D  42      13.754  57.997  94.062  1.00 11.86           C  
ATOM   5709  N   GLU D  43      15.971  59.085  97.842  1.00  9.89           N  
ATOM   5710  CA  GLU D  43      16.884  59.832  98.715  1.00  9.38           C  
ATOM   5711  C   GLU D  43      18.042  58.981  99.232  1.00 10.43           C  
ATOM   5712  O   GLU D  43      19.212  59.440  99.314  1.00 10.83           O  
ATOM   5713  CB  GLU D  43      16.159  60.462  99.926  1.00 10.54           C  
ATOM   5714  CG  GLU D  43      17.109  61.397 100.647  1.00 11.89           C  
ATOM   5715  CD  GLU D  43      16.613  61.954 101.951  1.00 15.26           C  
ATOM   5716  OE1 GLU D  43      15.377  62.057 102.185  1.00 14.21           O  
ATOM   5717  OE2 GLU D  43      17.504  62.305 102.781  1.00 15.41           O  
ATOM   5718  N   TYR D  44      17.718  57.733  99.572  1.00 10.50           N  
ATOM   5719  CA  TYR D  44      18.699  56.842 100.207  1.00 11.19           C  
ATOM   5720  C   TYR D  44      19.481  55.981  99.216  1.00 11.59           C  
ATOM   5721  O   TYR D  44      20.348  55.156  99.621  1.00 12.21           O  
ATOM   5722  CB  TYR D  44      18.029  55.909 101.235  1.00 13.23           C  
ATOM   5723  CG  TYR D  44      17.120  56.572 102.244  1.00 14.64           C  
ATOM   5724  CD1 TYR D  44      17.362  57.869 102.701  1.00 13.94           C  
ATOM   5725  CD2 TYR D  44      16.041  55.859 102.785  1.00 16.98           C  
ATOM   5726  CE1 TYR D  44      16.498  58.474 103.680  1.00 14.98           C  
ATOM   5727  CE2 TYR D  44      15.203  56.438 103.727  1.00 18.27           C  
ATOM   5728  CZ  TYR D  44      15.436  57.736 104.159  1.00 16.52           C  
ATOM   5729  OH  TYR D  44      14.566  58.272 105.098  1.00 19.59           O  
ATOM   5730  N   TYR D  45      19.241  56.180  97.931  1.00 10.79           N  
ATOM   5731  CA  TYR D  45      19.861  55.370  96.888  1.00 10.43           C  
ATOM   5732  C   TYR D  45      21.331  55.729  96.748  1.00 10.90           C  
ATOM   5733  O   TYR D  45      21.661  56.907  96.474  1.00 10.33           O  
ATOM   5734  CB  TYR D  45      19.148  55.702  95.585  1.00 10.66           C  
ATOM   5735  CG  TYR D  45      19.245  54.661  94.457  1.00 10.04           C  
ATOM   5736  CD1 TYR D  45      18.126  54.390  93.679  1.00 10.71           C  
ATOM   5737  CD2 TYR D  45      20.422  53.951  94.186  1.00 11.66           C  
ATOM   5738  CE1 TYR D  45      18.163  53.490  92.644  1.00 10.50           C  
ATOM   5739  CE2 TYR D  45      20.494  53.014  93.104  1.00  9.95           C  
ATOM   5740  CZ  TYR D  45      19.319  52.767  92.372  1.00  9.91           C  
ATOM   5741  OH  TYR D  45      19.339  51.862  91.315  1.00 10.95           O  
ATOM   5742  N   PRO D  46      22.235  54.739  96.911  1.00 10.34           N  
ATOM   5743  CA  PRO D  46      23.675  55.013  96.696  1.00 10.27           C  
ATOM   5744  C   PRO D  46      23.998  55.017  95.238  1.00 11.13           C  
ATOM   5745  O   PRO D  46      24.609  54.109  94.685  1.00 10.31           O  
ATOM   5746  CB  PRO D  46      24.390  53.858  97.420  1.00 10.65           C  
ATOM   5747  CG  PRO D  46      23.386  52.724  97.379  1.00 13.36           C  
ATOM   5748  CD  PRO D  46      21.982  53.348  97.355  1.00 10.42           C  
ATOM   5749  N   LEU D  47      23.603  56.098  94.580  1.00 10.42           N  
ATOM   5750  CA  LEU D  47      23.755  56.169  93.126  1.00 10.70           C  
ATOM   5751  C   LEU D  47      25.194  56.084  92.625  1.00 10.59           C  
ATOM   5752  O   LEU D  47      25.485  55.365  91.673  1.00 11.98           O  
ATOM   5753  CB  LEU D  47      23.112  57.452  92.619  1.00 11.70           C  
ATOM   5754  CG  LEU D  47      21.617  57.535  92.838  1.00 11.61           C  
ATOM   5755  CD1 LEU D  47      21.122  58.998  92.679  1.00 13.43           C  
ATOM   5756  CD2 LEU D  47      20.892  56.640  91.880  1.00 14.42           C  
ATOM   5757  N   GLN D  48      26.063  56.874  93.251  1.00  9.82           N  
ATOM   5758  CA  GLN D  48      27.466  56.906  92.821  1.00 10.81           C  
ATOM   5759  C   GLN D  48      28.088  55.529  92.905  1.00 10.11           C  
ATOM   5760  O   GLN D  48      28.760  55.085  91.980  1.00 10.93           O  
ATOM   5761  CB  GLN D  48      28.257  57.850  93.722  1.00 11.43           C  
ATOM   5762  CG  GLN D  48      29.725  57.887  93.432  1.00 13.75           C  
ATOM   5763  CD  GLN D  48      30.493  58.472  94.588  1.00 13.81           C  
ATOM   5764  OE1 GLN D  48      30.289  58.100  95.743  1.00 13.65           O  
ATOM   5765  NE2 GLN D  48      31.416  59.377  94.278  1.00 14.50           N  
ATOM   5766  N   GLU D  49      27.919  54.881  94.066  1.00  9.33           N  
ATOM   5767  CA  GLU D  49      28.648  53.640  94.296  1.00  8.73           C  
ATOM   5768  C   GLU D  49      28.064  52.442  93.552  1.00  9.63           C  
ATOM   5769  O   GLU D  49      28.758  51.422  93.417  1.00  9.99           O  
ATOM   5770  CB  GLU D  49      28.800  53.388  95.796  1.00  9.45           C  
ATOM   5771  CG  GLU D  49      29.617  54.459  96.455  1.00 10.59           C  
ATOM   5772  CD  GLU D  49      29.856  54.134  97.910  1.00 12.35           C  
ATOM   5773  OE1 GLU D  49      30.763  53.342  98.221  1.00 11.36           O  
ATOM   5774  OE2 GLU D  49      29.093  54.648  98.761  1.00 14.50           O  
ATOM   5775  N   LEU D  50      26.823  52.567  93.085  1.00  9.45           N  
ATOM   5776  CA  LEU D  50      26.232  51.436  92.333  1.00 10.85           C  
ATOM   5777  C   LEU D  50      26.177  51.665  90.827  1.00 11.17           C  
ATOM   5778  O   LEU D  50      26.171  50.682  90.062  1.00 10.98           O  
ATOM   5779  CB  LEU D  50      24.853  51.063  92.897  1.00 11.21           C  
ATOM   5780  CG  LEU D  50      24.898  50.589  94.360  1.00 12.68           C  
ATOM   5781  CD1 LEU D  50      23.470  50.265  94.797  1.00 12.75           C  
ATOM   5782  CD2 LEU D  50      25.784  49.362  94.579  1.00 11.96           C  
ATOM   5783  N   PHE D  51      26.073  52.925  90.387  1.00 10.91           N  
ATOM   5784  CA  PHE D  51      26.122  53.206  88.933  1.00 11.87           C  
ATOM   5785  C   PHE D  51      27.485  53.708  88.439  1.00 12.89           C  
ATOM   5786  O   PHE D  51      27.789  53.643  87.249  1.00 15.69           O  
ATOM   5787  CB  PHE D  51      25.061  54.241  88.557  1.00 11.62           C  
ATOM   5788  CG  PHE D  51      23.641  53.728  88.603  1.00 12.86           C  
ATOM   5789  CD1 PHE D  51      23.224  52.701  87.740  1.00 11.18           C  
ATOM   5790  CD2 PHE D  51      22.726  54.294  89.479  1.00 14.75           C  
ATOM   5791  CE1 PHE D  51      21.908  52.253  87.778  1.00 13.57           C  
ATOM   5792  CE2 PHE D  51      21.406  53.873  89.540  1.00 14.55           C  
ATOM   5793  CZ  PHE D  51      20.981  52.843  88.672  1.00 13.47           C  
ATOM   5794  N   GLY D  52      28.298  54.232  89.360  1.00 12.67           N  
ATOM   5795  CA  GLY D  52      29.563  54.855  88.992  1.00 13.43           C  
ATOM   5796  C   GLY D  52      29.421  56.334  88.691  1.00 13.40           C  
ATOM   5797  O   GLY D  52      28.350  56.913  88.850  1.00 13.44           O  
ATOM   5798  N   THR D  53      30.510  56.925  88.208  1.00 14.12           N  
ATOM   5799  CA  THR D  53      30.571  58.378  88.097  1.00 14.48           C  
ATOM   5800  C   THR D  53      30.710  58.861  86.657  1.00 13.60           C  
ATOM   5801  O   THR D  53      30.728  60.094  86.388  1.00 14.56           O  
ATOM   5802  CB  THR D  53      31.761  58.966  88.879  1.00 15.19           C  
ATOM   5803  OG1 THR D  53      32.972  58.487  88.323  1.00 17.97           O  
ATOM   5804  CG2 THR D  53      31.692  58.585  90.365  1.00 17.85           C  
ATOM   5805  N   SER D  54      30.784  57.932  85.706  1.00 12.49           N  
ATOM   5806  CA  SER D  54      31.043  58.369  84.323  1.00 12.64           C  
ATOM   5807  C   SER D  54      29.842  59.133  83.767  1.00 12.52           C  
ATOM   5808  O   SER D  54      30.015  60.076  82.989  1.00 13.57           O  
ATOM   5809  CB  SER D  54      31.473  57.211  83.417  1.00 12.52           C  
ATOM   5810  OG  SER D  54      32.723  56.679  83.863  1.00 14.13           O  
ATOM   5811  N   LYS D  55      28.646  58.733  84.187  1.00 12.85           N  
ATOM   5812  CA  LYS D  55      27.407  59.414  83.842  1.00 12.78           C  
ATOM   5813  C   LYS D  55      26.990  60.129  85.121  1.00 12.66           C  
ATOM   5814  O   LYS D  55      26.853  59.487  86.183  1.00 14.25           O  
ATOM   5815  CB  LYS D  55      26.348  58.375  83.445  1.00 13.18           C  
ATOM   5816  CG  LYS D  55      25.001  58.945  83.089  1.00 15.10           C  
ATOM   5817  CD  LYS D  55      24.095  57.860  82.504  1.00 16.97           C  
ATOM   5818  CE  LYS D  55      24.357  57.590  81.038  1.00 16.48           C  
ATOM   5819  NZ  LYS D  55      23.548  58.486  80.168  1.00 18.71           N  
ATOM   5820  N   THR D  56      26.751  61.438  85.031  1.00 12.37           N  
ATOM   5821  CA  THR D  56      26.412  62.229  86.208  1.00 11.13           C  
ATOM   5822  C   THR D  56      24.933  62.140  86.530  1.00 11.25           C  
ATOM   5823  O   THR D  56      24.080  62.696  85.813  1.00 11.78           O  
ATOM   5824  CB  THR D  56      26.808  63.706  86.065  1.00 11.86           C  
ATOM   5825  OG1 THR D  56      28.203  63.765  85.744  1.00 12.99           O  
ATOM   5826  CG2 THR D  56      26.580  64.465  87.359  1.00 12.45           C  
ATOM   5827  N   ILE D  57      24.650  61.454  87.638  1.00 10.65           N  
ATOM   5828  CA  ILE D  57      23.291  61.233  88.112  1.00  9.94           C  
ATOM   5829  C   ILE D  57      23.200  61.982  89.429  1.00  9.81           C  
ATOM   5830  O   ILE D  57      24.007  61.797  90.326  1.00 10.64           O  
ATOM   5831  CB  ILE D  57      23.036  59.728  88.398  1.00  9.60           C  
ATOM   5832  CG1 ILE D  57      23.416  58.925  87.140  1.00 11.20           C  
ATOM   5833  CG2 ILE D  57      21.555  59.524  88.849  1.00 11.12           C  
ATOM   5834  CD1 ILE D  57      23.243  57.369  87.237  1.00 12.92           C  
ATOM   5835  N   VAL D  58      22.207  62.859  89.502  1.00  9.02           N  
ATOM   5836  CA  VAL D  58      22.039  63.704  90.684  1.00  9.46           C  
ATOM   5837  C   VAL D  58      20.782  63.325  91.455  1.00  9.75           C  
ATOM   5838  O   VAL D  58      19.710  63.124  90.871  1.00 10.85           O  
ATOM   5839  CB  VAL D  58      22.035  65.236  90.292  1.00  9.25           C  
ATOM   5840  CG1 VAL D  58      21.689  66.150  91.454  1.00 12.41           C  
ATOM   5841  CG2 VAL D  58      23.389  65.652  89.737  1.00 10.69           C  
ATOM   5842  N   ASN D  59      20.918  63.269  92.782  1.00  9.59           N  
ATOM   5843  CA  ASN D  59      19.833  62.843  93.651  1.00  9.19           C  
ATOM   5844  C   ASN D  59      18.959  64.035  93.994  1.00 10.23           C  
ATOM   5845  O   ASN D  59      19.418  65.019  94.599  1.00  9.88           O  
ATOM   5846  CB  ASN D  59      20.423  62.278  94.937  1.00 10.65           C  
ATOM   5847  CG  ASN D  59      19.448  61.381  95.654  1.00 11.62           C  
ATOM   5848  OD1 ASN D  59      18.293  61.738  95.836  1.00 11.52           O  
ATOM   5849  ND2 ASN D  59      19.899  60.177  96.039  1.00 10.52           N  
ATOM   5850  N   ARG D  60      17.681  63.923  93.645  1.00  9.54           N  
ATOM   5851  CA  ARG D  60      16.703  64.891  94.122  1.00 11.03           C  
ATOM   5852  C   ARG D  60      15.526  64.135  94.767  1.00 10.45           C  
ATOM   5853  O   ARG D  60      14.368  64.501  94.595  1.00 11.68           O  
ATOM   5854  CB  ARG D  60      16.237  65.819  92.969  1.00 11.46           C  
ATOM   5855  CG  ARG D  60      17.278  66.911  92.586  1.00 11.21           C  
ATOM   5856  CD  ARG D  60      17.404  67.918  93.715  1.00  9.87           C  
ATOM   5857  NE  ARG D  60      18.313  69.044  93.461  1.00 10.02           N  
ATOM   5858  CZ  ARG D  60      19.628  68.987  93.708  1.00  9.85           C  
ATOM   5859  NH1 ARG D  60      20.194  67.861  94.167  1.00 10.85           N  
ATOM   5860  NH2 ARG D  60      20.400  70.070  93.478  1.00 10.86           N  
ATOM   5861  N   GLY D  61      15.852  63.131  95.576  1.00 10.86           N  
ATOM   5862  CA  GLY D  61      14.805  62.417  96.329  1.00 10.02           C  
ATOM   5863  C   GLY D  61      14.599  63.011  97.715  1.00 10.39           C  
ATOM   5864  O   GLY D  61      15.500  63.653  98.283  1.00 10.46           O  
ATOM   5865  N   ILE D  62      13.409  62.790  98.269  1.00 10.01           N  
ATOM   5866  CA  ILE D  62      13.084  63.257  99.617  1.00 10.54           C  
ATOM   5867  C   ILE D  62      12.249  62.215 100.347  1.00 10.81           C  
ATOM   5868  O   ILE D  62      11.197  61.769  99.847  1.00 11.19           O  
ATOM   5869  CB  ILE D  62      12.313  64.602  99.610  1.00  9.83           C  
ATOM   5870  CG1 ILE D  62      13.121  65.667  98.875  1.00 11.19           C  
ATOM   5871  CG2 ILE D  62      11.956  65.031 101.050  1.00 10.06           C  
ATOM   5872  CD1 ILE D  62      12.612  67.096  98.989  1.00 11.83           C  
ATOM   5873  N   ARG D  63      12.705  61.841 101.540  1.00 10.84           N  
ATOM   5874  CA  ARG D  63      11.985  60.863 102.352  1.00 12.26           C  
ATOM   5875  C   ARG D  63      10.534  61.266 102.554  1.00 12.04           C  
ATOM   5876  O   ARG D  63      10.200  62.447 102.669  1.00 10.72           O  
ATOM   5877  CB  ARG D  63      12.657  60.721 103.713  1.00 13.23           C  
ATOM   5878  CG  ARG D  63      12.500  62.017 104.575  1.00 15.47           C  
ATOM   5879  CD  ARG D  63      13.484  62.136 105.671  1.00 22.16           C  
ATOM   5880  NE  ARG D  63      14.820  62.397 105.163  1.00 20.81           N  
ATOM   5881  CZ  ARG D  63      15.835  62.681 105.957  1.00 21.64           C  
ATOM   5882  NH1 ARG D  63      15.627  62.776 107.271  1.00 21.17           N  
ATOM   5883  NH2 ARG D  63      17.037  62.881 105.452  1.00 19.58           N  
ATOM   5884  N   GLY D  64       9.671  60.258 102.549  1.00 12.30           N  
ATOM   5885  CA  GLY D  64       8.267  60.447 102.827  1.00 13.07           C  
ATOM   5886  C   GLY D  64       7.474  61.134 101.721  1.00 13.21           C  
ATOM   5887  O   GLY D  64       6.292  61.463 101.924  1.00 14.48           O  
ATOM   5888  N   TYR D  65       8.079  61.339 100.543  1.00 13.01           N  
ATOM   5889  CA  TYR D  65       7.407  62.170  99.526  1.00 11.67           C  
ATOM   5890  C   TYR D  65       6.235  61.417  98.915  1.00 12.06           C  
ATOM   5891  O   TYR D  65       6.238  60.193  98.845  1.00 12.36           O  
ATOM   5892  CB  TYR D  65       8.366  62.510  98.402  1.00 12.29           C  
ATOM   5893  CG  TYR D  65       8.566  63.990  98.124  1.00 11.12           C  
ATOM   5894  CD1 TYR D  65       8.478  64.956  99.143  1.00 12.38           C  
ATOM   5895  CD2 TYR D  65       8.929  64.418  96.832  1.00 12.04           C  
ATOM   5896  CE1 TYR D  65       8.738  66.321  98.857  1.00 11.75           C  
ATOM   5897  CE2 TYR D  65       9.196  65.746  96.559  1.00 11.79           C  
ATOM   5898  CZ  TYR D  65       9.111  66.671  97.557  1.00  9.84           C  
ATOM   5899  OH  TYR D  65       9.369  67.978  97.276  1.00 11.56           O  
ATOM   5900  N   GLN D  66       5.256  62.190  98.498  1.00 13.03           N  
ATOM   5901  CA  GLN D  66       4.065  61.705  97.817  1.00 13.19           C  
ATOM   5902  C   GLN D  66       3.927  62.537  96.568  1.00 12.51           C  
ATOM   5903  O   GLN D  66       4.494  63.617  96.473  1.00 12.23           O  
ATOM   5904  CB  GLN D  66       2.821  61.920  98.662  1.00 14.19           C  
ATOM   5905  CG  GLN D  66       2.812  61.150  99.957  1.00 16.13           C  
ATOM   5906  CD  GLN D  66       1.665  61.586 100.851  1.00 19.18           C  
ATOM   5907  OE1 GLN D  66       1.874  61.988 101.986  1.00 22.63           O  
ATOM   5908  NE2 GLN D  66       0.453  61.519 100.335  1.00 19.15           N  
ATOM   5909  N   THR D  67       3.107  62.068  95.631  1.00 12.19           N  
ATOM   5910  CA  THR D  67       2.958  62.756  94.338  1.00 12.33           C  
ATOM   5911  C   THR D  67       2.509  64.209  94.493  1.00 12.07           C  
ATOM   5912  O   THR D  67       2.971  65.090  93.791  1.00 12.79           O  
ATOM   5913  CB  THR D  67       1.985  62.008  93.362  1.00 11.65           C  
ATOM   5914  OG1 THR D  67       0.653  62.008  93.906  1.00 12.69           O  
ATOM   5915  CG2 THR D  67       2.479  60.544  93.073  1.00 12.02           C  
ATOM   5916  N   GLY D  68       1.593  64.471  95.419  1.00 12.08           N  
ATOM   5917  CA  GLY D  68       1.130  65.850  95.617  1.00 12.52           C  
ATOM   5918  C   GLY D  68       2.206  66.805  96.116  1.00 12.91           C  
ATOM   5919  O   GLY D  68       2.254  67.967  95.693  1.00 13.57           O  
ATOM   5920  N   LEU D  69       3.073  66.311  97.009  1.00 13.06           N  
ATOM   5921  CA  LEU D  69       4.139  67.141  97.564  1.00 13.76           C  
ATOM   5922  C   LEU D  69       5.159  67.456  96.474  1.00 13.49           C  
ATOM   5923  O   LEU D  69       5.675  68.585  96.377  1.00 13.89           O  
ATOM   5924  CB  LEU D  69       4.841  66.413  98.717  1.00 15.08           C  
ATOM   5925  CG  LEU D  69       3.983  66.008  99.914  1.00 17.48           C  
ATOM   5926  CD1 LEU D  69       4.807  65.109 100.865  1.00 20.94           C  
ATOM   5927  CD2 LEU D  69       3.461  67.240 100.647  1.00 19.97           C  
ATOM   5928  N   LEU D  70       5.423  66.459  95.637  1.00 13.32           N  
ATOM   5929  CA  LEU D  70       6.378  66.641  94.541  1.00 12.39           C  
ATOM   5930  C   LEU D  70       5.868  67.657  93.538  1.00 12.58           C  
ATOM   5931  O   LEU D  70       6.606  68.545  93.113  1.00 12.85           O  
ATOM   5932  CB  LEU D  70       6.704  65.306  93.847  1.00 12.19           C  
ATOM   5933  CG  LEU D  70       7.497  65.353  92.543  1.00 13.86           C  
ATOM   5934  CD1 LEU D  70       8.846  66.009  92.841  1.00 13.15           C  
ATOM   5935  CD2 LEU D  70       7.685  63.939  91.987  1.00 13.63           C  
ATOM   5936  N   LEU D  71       4.600  67.536  93.171  1.00 11.67           N  
ATOM   5937  CA  LEU D  71       4.027  68.500  92.248  1.00 13.14           C  
ATOM   5938  C   LEU D  71       4.107  69.938  92.781  1.00 13.41           C  
ATOM   5939  O   LEU D  71       4.524  70.854  92.072  1.00 14.23           O  
ATOM   5940  CB  LEU D  71       2.571  68.128  91.926  1.00 13.24           C  
ATOM   5941  CG  LEU D  71       1.842  69.155  91.049  1.00 14.75           C  
ATOM   5942  CD1 LEU D  71       2.514  69.321  89.668  1.00 16.08           C  
ATOM   5943  CD2 LEU D  71       0.370  68.773  90.919  1.00 14.72           C  
ATOM   5944  N   GLU D  72       3.729  70.119  94.044  1.00 13.47           N  
ATOM   5945  CA  GLU D  72       3.731  71.439  94.660  1.00 14.48           C  
ATOM   5946  C   GLU D  72       5.133  72.065  94.689  1.00 14.01           C  
ATOM   5947  O   GLU D  72       5.287  73.280  94.503  1.00 14.80           O  
ATOM   5948  CB  GLU D  72       3.185  71.309  96.083  1.00 15.43           C  
ATOM   5949  CG  GLU D  72       2.904  72.610  96.773  1.00 21.22           C  
ATOM   5950  CD  GLU D  72       2.683  72.436  98.269  1.00 27.98           C  
ATOM   5951  OE1 GLU D  72       2.184  71.358  98.686  1.00 31.15           O  
ATOM   5952  OE2 GLU D  72       3.018  73.379  99.023  1.00 31.74           O  
ATOM   5953  N   ASN D  73       6.150  71.215  94.889  1.00 12.84           N  
ATOM   5954  CA  ASN D  73       7.526  71.669  95.060  1.00 12.20           C  
ATOM   5955  C   ASN D  73       8.435  71.249  93.928  1.00 11.86           C  
ATOM   5956  O   ASN D  73       9.638  71.115  94.126  1.00 11.57           O  
ATOM   5957  CB  ASN D  73       8.074  71.134  96.370  1.00 12.77           C  
ATOM   5958  CG  ASN D  73       7.379  71.761  97.548  1.00 12.91           C  
ATOM   5959  OD1 ASN D  73       7.689  72.892  97.931  1.00 15.91           O  
ATOM   5960  ND2 ASN D  73       6.377  71.068  98.080  1.00 15.14           N  
ATOM   5961  N   LEU D  74       7.862  71.042  92.740  1.00 10.84           N  
ATOM   5962  CA  LEU D  74       8.614  70.452  91.643  1.00 11.32           C  
ATOM   5963  C   LEU D  74       9.898  71.208  91.294  1.00 10.95           C  
ATOM   5964  O   LEU D  74      10.910  70.606  90.887  1.00 11.26           O  
ATOM   5965  CB  LEU D  74       7.712  70.345  90.417  1.00 12.30           C  
ATOM   5966  CG  LEU D  74       8.301  69.631  89.203  1.00 12.24           C  
ATOM   5967  CD1 LEU D  74       8.713  68.194  89.533  1.00 12.45           C  
ATOM   5968  CD2 LEU D  74       7.249  69.637  88.056  1.00 12.57           C  
ATOM   5969  N   ASP D  75       9.862  72.529  91.480  1.00 11.07           N  
ATOM   5970  CA  ASP D  75      11.017  73.369  91.169  1.00 12.28           C  
ATOM   5971  C   ASP D  75      12.264  72.994  91.951  1.00 12.64           C  
ATOM   5972  O   ASP D  75      13.387  73.256  91.501  1.00 13.32           O  
ATOM   5973  CB  ASP D  75      10.693  74.845  91.483  1.00 12.62           C  
ATOM   5974  CG  ASP D  75      10.477  75.108  92.969  1.00 14.89           C  
ATOM   5975  OD1 ASP D  75       9.530  74.571  93.563  1.00 15.53           O  
ATOM   5976  OD2 ASP D  75      11.244  75.914  93.538  1.00 19.95           O  
ATOM   5977  N   ALA D  76      12.080  72.441  93.143  1.00 11.38           N  
ATOM   5978  CA  ALA D  76      13.248  72.065  93.947  1.00  9.91           C  
ATOM   5979  C   ALA D  76      14.026  70.894  93.310  1.00 11.19           C  
ATOM   5980  O   ALA D  76      15.172  70.617  93.698  1.00  9.98           O  
ATOM   5981  CB  ALA D  76      12.821  71.717  95.385  1.00  9.75           C  
ATOM   5982  N   HIS D  77      13.383  70.210  92.362  1.00 10.56           N  
ATOM   5983  CA  HIS D  77      13.907  68.913  91.906  1.00 10.04           C  
ATOM   5984  C   HIS D  77      14.490  68.977  90.532  1.00 10.75           C  
ATOM   5985  O   HIS D  77      14.967  67.959  90.033  1.00 11.46           O  
ATOM   5986  CB  HIS D  77      12.804  67.860  91.972  1.00 11.00           C  
ATOM   5987  CG  HIS D  77      12.260  67.705  93.353  1.00 10.10           C  
ATOM   5988  ND1 HIS D  77      12.739  66.765  94.244  1.00 10.54           N  
ATOM   5989  CD2 HIS D  77      11.315  68.409  94.018  1.00 10.28           C  
ATOM   5990  CE1 HIS D  77      12.092  66.881  95.391  1.00 12.75           C  
ATOM   5991  NE2 HIS D  77      11.248  67.894  95.295  1.00 11.88           N  
ATOM   5992  N   LEU D  78      14.485  70.174  89.922  1.00 10.41           N  
ATOM   5993  CA  LEU D  78      14.895  70.314  88.512  1.00 11.60           C  
ATOM   5994  C   LEU D  78      15.933  71.414  88.331  1.00 10.77           C  
ATOM   5995  O   LEU D  78      15.696  72.573  88.727  1.00 11.49           O  
ATOM   5996  CB  LEU D  78      13.681  70.634  87.644  1.00 11.85           C  
ATOM   5997  CG  LEU D  78      12.545  69.593  87.600  1.00 13.85           C  
ATOM   5998  CD1 LEU D  78      11.303  70.164  86.900  1.00 15.20           C  
ATOM   5999  CD2 LEU D  78      13.006  68.340  86.892  1.00 16.19           C  
ATOM   6000  N   TYR D  79      17.075  71.053  87.730  1.00 10.35           N  
ATOM   6001  CA  TYR D  79      18.033  72.044  87.246  1.00 10.31           C  
ATOM   6002  C   TYR D  79      18.902  71.408  86.183  1.00 10.75           C  
ATOM   6003  O   TYR D  79      18.874  70.171  86.006  1.00 11.65           O  
ATOM   6004  CB  TYR D  79      18.892  72.616  88.362  1.00 10.67           C  
ATOM   6005  CG  TYR D  79      20.053  71.759  88.823  1.00  9.59           C  
ATOM   6006  CD1 TYR D  79      21.361  72.029  88.405  1.00 10.35           C  
ATOM   6007  CD2 TYR D  79      19.852  70.695  89.716  1.00 10.68           C  
ATOM   6008  CE1 TYR D  79      22.447  71.295  88.856  1.00  9.77           C  
ATOM   6009  CE2 TYR D  79      20.939  69.924  90.156  1.00  9.34           C  
ATOM   6010  CZ  TYR D  79      22.241  70.215  89.711  1.00  9.59           C  
ATOM   6011  OH  TYR D  79      23.341  69.498  90.162  1.00 10.90           O  
ATOM   6012  N   GLY D  80      19.644  72.258  85.482  1.00 11.32           N  
ATOM   6013  CA  GLY D  80      20.628  71.817  84.518  1.00 11.47           C  
ATOM   6014  C   GLY D  80      20.347  72.290  83.119  1.00 10.77           C  
ATOM   6015  O   GLY D  80      19.193  72.519  82.739  1.00 11.57           O  
ATOM   6016  N   GLY D  81      21.412  72.399  82.350  1.00 10.33           N  
ATOM   6017  CA  GLY D  81      21.309  72.804  80.959  1.00 10.74           C  
ATOM   6018  C   GLY D  81      21.295  71.675  79.946  1.00 11.05           C  
ATOM   6019  O   GLY D  81      21.179  71.948  78.733  1.00 12.81           O  
ATOM   6020  N   ALA D  82      21.458  70.430  80.418  1.00 11.21           N  
ATOM   6021  CA  ALA D  82      21.565  69.284  79.497  1.00 11.68           C  
ATOM   6022  C   ALA D  82      21.033  68.000  80.135  1.00 11.89           C  
ATOM   6023  O   ALA D  82      21.709  66.963  80.205  1.00 13.01           O  
ATOM   6024  CB  ALA D  82      23.009  69.105  79.077  1.00 13.76           C  
ATOM   6025  N   VAL D  83      19.827  68.099  80.674  1.00 10.76           N  
ATOM   6026  CA  VAL D  83      19.234  66.938  81.338  1.00 10.61           C  
ATOM   6027  C   VAL D  83      18.685  65.983  80.278  1.00 10.97           C  
ATOM   6028  O   VAL D  83      17.743  66.311  79.559  1.00 11.66           O  
ATOM   6029  CB  VAL D  83      18.095  67.346  82.290  1.00 10.78           C  
ATOM   6030  CG1 VAL D  83      17.585  66.090  83.023  1.00 11.27           C  
ATOM   6031  CG2 VAL D  83      18.598  68.415  83.278  1.00 11.44           C  
ATOM   6032  N   ASP D  84      19.297  64.817  80.166  1.00 10.72           N  
ATOM   6033  CA  ASP D  84      18.822  63.820  79.207  1.00 11.26           C  
ATOM   6034  C   ASP D  84      17.569  63.106  79.710  1.00 11.31           C  
ATOM   6035  O   ASP D  84      16.629  62.867  78.935  1.00 12.09           O  
ATOM   6036  CB  ASP D  84      19.933  62.790  78.930  1.00 10.97           C  
ATOM   6037  CG  ASP D  84      20.929  63.267  77.886  1.00 17.04           C  
ATOM   6038  OD1 ASP D  84      20.814  64.438  77.411  1.00 20.36           O  
ATOM   6039  OD2 ASP D  84      21.817  62.457  77.510  1.00 20.85           O  
ATOM   6040  N   LYS D  85      17.566  62.734  80.992  1.00 11.53           N  
ATOM   6041  CA  LYS D  85      16.508  61.903  81.526  1.00 11.89           C  
ATOM   6042  C   LYS D  85      16.248  62.270  82.960  1.00 11.71           C  
ATOM   6043  O   LYS D  85      17.161  62.661  83.707  1.00 11.55           O  
ATOM   6044  CB  LYS D  85      16.886  60.405  81.485  1.00 12.58           C  
ATOM   6045  CG  LYS D  85      17.186  59.873  80.093  1.00 12.95           C  
ATOM   6046  CD  LYS D  85      17.589  58.425  80.174  1.00 15.57           C  
ATOM   6047  CE  LYS D  85      17.825  57.847  78.797  1.00 19.81           C  
ATOM   6048  NZ  LYS D  85      19.028  58.432  78.194  1.00 20.20           N  
ATOM   6049  N   ILE D  86      14.986  62.122  83.334  1.00 10.79           N  
ATOM   6050  CA  ILE D  86      14.540  62.177  84.722  1.00 12.04           C  
ATOM   6051  C   ILE D  86      13.985  60.812  85.064  1.00 11.88           C  
ATOM   6052  O   ILE D  86      13.117  60.312  84.362  1.00 12.25           O  
ATOM   6053  CB  ILE D  86      13.417  63.226  84.893  1.00 12.79           C  
ATOM   6054  CG1 ILE D  86      13.984  64.633  84.700  1.00 14.61           C  
ATOM   6055  CG2 ILE D  86      12.719  63.090  86.269  1.00 13.72           C  
ATOM   6056  CD1 ILE D  86      12.905  65.692  84.335  1.00 16.88           C  
ATOM   6057  N   PHE D  87      14.518  60.197  86.116  1.00 11.49           N  
ATOM   6058  CA  PHE D  87      13.953  58.946  86.639  1.00 11.93           C  
ATOM   6059  C   PHE D  87      13.053  59.326  87.786  1.00 12.92           C  
ATOM   6060  O   PHE D  87      13.478  60.042  88.695  1.00 13.35           O  
ATOM   6061  CB  PHE D  87      15.052  58.017  87.135  1.00 12.65           C  
ATOM   6062  CG  PHE D  87      15.708  57.226  86.049  1.00 12.81           C  
ATOM   6063  CD1 PHE D  87      16.254  57.834  84.927  1.00 13.02           C  
ATOM   6064  CD2 PHE D  87      15.741  55.839  86.142  1.00 16.26           C  
ATOM   6065  CE1 PHE D  87      16.847  57.071  83.937  1.00 12.45           C  
ATOM   6066  CE2 PHE D  87      16.322  55.072  85.154  1.00 16.50           C  
ATOM   6067  CZ  PHE D  87      16.877  55.683  84.047  1.00 14.47           C  
ATOM   6068  N   LEU D  88      11.818  58.842  87.755  1.00 12.31           N  
ATOM   6069  CA  LEU D  88      10.837  59.186  88.753  1.00 11.92           C  
ATOM   6070  C   LEU D  88      10.336  57.912  89.446  1.00 11.53           C  
ATOM   6071  O   LEU D  88       9.754  57.026  88.812  1.00 12.06           O  
ATOM   6072  CB  LEU D  88       9.685  59.919  88.073  1.00 12.38           C  
ATOM   6073  CG  LEU D  88       8.573  60.366  88.982  1.00 13.30           C  
ATOM   6074  CD1 LEU D  88       9.110  61.211  90.130  1.00 16.12           C  
ATOM   6075  CD2 LEU D  88       7.548  61.138  88.122  1.00 18.37           C  
ATOM   6076  N   LEU D  89      10.534  57.859  90.767  1.00 10.73           N  
ATOM   6077  CA  LEU D  89      10.076  56.738  91.579  1.00 11.67           C  
ATOM   6078  C   LEU D  89       9.273  57.338  92.717  1.00 11.19           C  
ATOM   6079  O   LEU D  89       9.820  57.911  93.676  1.00 12.40           O  
ATOM   6080  CB  LEU D  89      11.233  55.879  92.152  1.00 13.14           C  
ATOM   6081  CG  LEU D  89      10.771  54.724  93.053  1.00 14.35           C  
ATOM   6082  CD1 LEU D  89       9.750  53.784  92.337  1.00 15.68           C  
ATOM   6083  CD2 LEU D  89      11.995  53.958  93.485  1.00 18.11           C  
ATOM   6084  N   ILE D  90       7.958  57.196  92.629  1.00 10.94           N  
ATOM   6085  CA  ILE D  90       7.089  57.800  93.620  1.00 12.22           C  
ATOM   6086  C   ILE D  90       5.744  57.124  93.577  1.00 11.65           C  
ATOM   6087  O   ILE D  90       5.352  56.580  92.535  1.00 12.15           O  
ATOM   6088  CB  ILE D  90       6.977  59.349  93.392  1.00 12.25           C  
ATOM   6089  CG1 ILE D  90       6.428  60.049  94.656  1.00 14.16           C  
ATOM   6090  CG2 ILE D  90       6.207  59.664  92.091  1.00 13.69           C  
ATOM   6091  CD1 ILE D  90       6.737  61.506  94.699  1.00 15.88           C  
ATOM   6092  N   GLY D  91       5.062  57.144  94.730  1.00 11.33           N  
ATOM   6093  CA  GLY D  91       3.712  56.629  94.823  1.00 11.82           C  
ATOM   6094  C   GLY D  91       3.519  55.691  95.987  1.00 11.84           C  
ATOM   6095  O   GLY D  91       2.388  55.569  96.455  1.00 12.16           O  
ATOM   6096  N   THR D  92       4.578  55.033  96.476  1.00 12.19           N  
ATOM   6097  CA  THR D  92       4.378  54.069  97.576  1.00 11.37           C  
ATOM   6098  C   THR D  92       3.796  54.753  98.804  1.00 11.63           C  
ATOM   6099  O   THR D  92       3.058  54.129  99.558  1.00 12.82           O  
ATOM   6100  CB  THR D  92       5.630  53.218  97.907  1.00 12.54           C  
ATOM   6101  OG1 THR D  92       5.231  52.046  98.654  1.00 12.75           O  
ATOM   6102  CG2 THR D  92       6.682  54.009  98.694  1.00 12.52           C  
ATOM   6103  N   ASN D  93       4.122  56.032  98.983  1.00 11.51           N  
ATOM   6104  CA  ASN D  93       3.625  56.762 100.141  1.00 11.77           C  
ATOM   6105  C   ASN D  93       2.223  57.283  99.915  1.00 12.12           C  
ATOM   6106  O   ASN D  93       1.451  57.410 100.880  1.00 13.89           O  
ATOM   6107  CB  ASN D  93       4.606  57.843 100.581  1.00 11.23           C  
ATOM   6108  CG  ASN D  93       5.932  57.249 101.011  1.00 13.98           C  
ATOM   6109  OD1 ASN D  93       5.979  56.154 101.571  1.00 14.58           O  
ATOM   6110  ND2 ASN D  93       7.023  57.927 100.684  1.00 14.63           N  
ATOM   6111  N   ASP D  94       1.856  57.506  98.656  1.00 11.90           N  
ATOM   6112  CA  ASP D  94       0.453  57.785  98.332  1.00 12.55           C  
ATOM   6113  C   ASP D  94      -0.392  56.560  98.701  1.00 12.31           C  
ATOM   6114  O   ASP D  94      -1.427  56.687  99.337  1.00 12.36           O  
ATOM   6115  CB  ASP D  94       0.301  58.086  96.838  1.00 12.72           C  
ATOM   6116  CG  ASP D  94       0.974  59.375  96.421  1.00 13.57           C  
ATOM   6117  OD1 ASP D  94       0.237  60.351  96.102  1.00 14.33           O  
ATOM   6118  OD2 ASP D  94       2.232  59.403  96.395  1.00 13.33           O  
ATOM   6119  N   ILE D  95       0.066  55.367  98.320  1.00 11.82           N  
ATOM   6120  CA  ILE D  95      -0.627  54.136  98.712  1.00 12.18           C  
ATOM   6121  C   ILE D  95      -0.691  54.004 100.246  1.00 12.21           C  
ATOM   6122  O   ILE D  95      -1.739  53.690 100.807  1.00 12.13           O  
ATOM   6123  CB  ILE D  95       0.023  52.885  98.074  1.00 12.35           C  
ATOM   6124  CG1 ILE D  95      -0.174  52.914  96.553  1.00 12.72           C  
ATOM   6125  CG2 ILE D  95      -0.578  51.589  98.735  1.00 12.82           C  
ATOM   6126  CD1 ILE D  95       0.551  51.792  95.833  1.00 12.83           C  
ATOM   6127  N   GLY D  96       0.424  54.258 100.920  1.00 12.07           N  
ATOM   6128  CA  GLY D  96       0.470  54.119 102.390  1.00 12.48           C  
ATOM   6129  C   GLY D  96      -0.403  55.119 103.148  1.00 13.09           C  
ATOM   6130  O   GLY D  96      -0.726  54.893 104.340  1.00 14.64           O  
ATOM   6131  N   LYS D  97      -0.788  56.214 102.476  1.00 13.24           N  
ATOM   6132  CA  LYS D  97      -1.682  57.247 103.027  1.00 15.15           C  
ATOM   6133  C   LYS D  97      -3.093  57.184 102.450  1.00 15.31           C  
ATOM   6134  O   LYS D  97      -3.924  58.074 102.719  1.00 15.82           O  
ATOM   6135  CB  LYS D  97      -1.104  58.638 102.759  1.00 15.56           C  
ATOM   6136  CG  LYS D  97       0.093  58.993 103.611  1.00 17.02           C  
ATOM   6137  CD  LYS D  97      -0.308  59.308 105.028  1.00 21.09           C  
ATOM   6138  CE  LYS D  97       0.911  59.533 105.909  1.00 24.39           C  
ATOM   6139  NZ  LYS D  97       0.458  59.726 107.329  1.00 27.81           N  
ATOM   6140  N   ASP D  98      -3.370  56.146 101.665  1.00 15.58           N  
ATOM   6141  CA  ASP D  98      -4.702  55.934 101.070  1.00 16.28           C  
ATOM   6142  C   ASP D  98      -5.176  57.092 100.159  1.00 16.23           C  
ATOM   6143  O   ASP D  98      -6.375  57.379 100.057  1.00 16.20           O  
ATOM   6144  CB  ASP D  98      -5.739  55.609 102.163  1.00 17.35           C  
ATOM   6145  CG  ASP D  98      -6.781  54.612 101.704  1.00 19.17           C  
ATOM   6146  OD1 ASP D  98      -6.566  53.898 100.694  1.00 23.26           O  
ATOM   6147  OD2 ASP D  98      -7.841  54.547 102.360  1.00 23.07           O  
ATOM   6148  N   VAL D  99      -4.229  57.740  99.484  1.00 15.25           N  
ATOM   6149  CA  VAL D  99      -4.522  58.749  98.450  1.00 14.97           C  
ATOM   6150  C   VAL D  99      -5.266  58.076  97.289  1.00 15.24           C  
ATOM   6151  O   VAL D  99      -4.856  56.995  96.879  1.00 14.75           O  
ATOM   6152  CB  VAL D  99      -3.208  59.369  97.922  1.00 14.18           C  
ATOM   6153  CG1 VAL D  99      -3.476  60.260  96.710  1.00 13.98           C  
ATOM   6154  CG2 VAL D  99      -2.548  60.158  99.024  1.00 14.02           C  
ATOM   6155  N   PRO D 100      -6.382  58.673  96.798  1.00 15.46           N  
ATOM   6156  CA  PRO D 100      -7.073  58.005  95.680  1.00 15.48           C  
ATOM   6157  C   PRO D 100      -6.164  57.863  94.468  1.00 15.17           C  
ATOM   6158  O   PRO D 100      -5.428  58.796  94.136  1.00 15.53           O  
ATOM   6159  CB  PRO D 100      -8.257  58.939  95.372  1.00 15.98           C  
ATOM   6160  CG  PRO D 100      -8.497  59.679  96.685  1.00 16.07           C  
ATOM   6161  CD  PRO D 100      -7.095  59.891  97.231  1.00 15.78           C  
ATOM   6162  N   VAL D 101      -6.195  56.696  93.828  1.00 15.21           N  
ATOM   6163  CA  VAL D 101      -5.319  56.469  92.677  1.00 15.10           C  
ATOM   6164  C   VAL D 101      -5.481  57.541  91.592  1.00 15.08           C  
ATOM   6165  O   VAL D 101      -4.503  58.000  91.015  1.00 14.54           O  
ATOM   6166  CB  VAL D 101      -5.431  55.017  92.119  1.00 15.33           C  
ATOM   6167  CG1 VAL D 101      -6.849  54.696  91.603  1.00 16.38           C  
ATOM   6168  CG2 VAL D 101      -4.394  54.757  91.028  1.00 14.88           C  
ATOM   6169  N   ASN D 102      -6.717  57.952  91.315  1.00 15.03           N  
ATOM   6170  CA  ASN D 102      -6.961  59.009  90.338  1.00 15.95           C  
ATOM   6171  C   ASN D 102      -6.339  60.354  90.715  1.00 15.66           C  
ATOM   6172  O   ASN D 102      -5.930  61.111  89.836  1.00 16.51           O  
ATOM   6173  CB  ASN D 102      -8.461  59.215  90.128  1.00 15.63           C  
ATOM   6174  CG  ASN D 102      -9.108  58.109  89.306  1.00 18.06           C  
ATOM   6175  OD1 ASN D 102      -8.436  57.358  88.593  1.00 21.98           O  
ATOM   6176  ND2 ASN D 102     -10.431  58.014  89.394  1.00 19.43           N  
ATOM   6177  N   GLU D 103      -6.277  60.659  92.014  1.00 15.25           N  
ATOM   6178  CA  GLU D 103      -5.589  61.863  92.449  1.00 15.20           C  
ATOM   6179  C   GLU D 103      -4.070  61.743  92.225  1.00 14.50           C  
ATOM   6180  O   GLU D 103      -3.452  62.656  91.689  1.00 14.53           O  
ATOM   6181  CB  GLU D 103      -5.912  62.169  93.914  1.00 14.41           C  
ATOM   6182  CG  GLU D 103      -5.225  63.412  94.491  1.00 17.46           C  
ATOM   6183  CD  GLU D 103      -5.676  63.688  95.929  1.00 17.47           C  
ATOM   6184  OE1 GLU D 103      -6.891  63.596  96.213  1.00 22.95           O  
ATOM   6185  OE2 GLU D 103      -4.819  63.991  96.774  1.00 21.63           O  
ATOM   6186  N   ALA D 104      -3.478  60.616  92.619  1.00 14.49           N  
ATOM   6187  CA  ALA D 104      -2.049  60.396  92.345  1.00 13.90           C  
ATOM   6188  C   ALA D 104      -1.726  60.481  90.842  1.00 13.66           C  
ATOM   6189  O   ALA D 104      -0.720  61.082  90.444  1.00 14.05           O  
ATOM   6190  CB  ALA D 104      -1.582  59.063  92.907  1.00 14.94           C  
ATOM   6191  N   LEU D 105      -2.558  59.847  90.017  0.50 13.79           N  
ATOM   6193  CA  LEU D 105      -2.367  59.879  88.572  0.50 13.89           C  
ATOM   6195  C   LEU D 105      -2.428  61.297  88.029  0.50 13.52           C  
ATOM   6197  O   LEU D 105      -1.533  61.712  87.284  0.50 14.14           O  
ATOM   6199  CB  LEU D 105      -3.406  59.004  87.859  0.50 14.17           C  
ATOM   6201  CG  LEU D 105      -3.284  57.495  88.068  0.50 14.69           C  
ATOM   6203  CD1 LEU D 105      -4.479  56.795  87.411  0.50 14.13           C  
ATOM   6205  CD2 LEU D 105      -1.943  56.943  87.571  0.50 14.66           C  
ATOM   6207  N   ASN D 106      -3.460  62.045  88.422  1.00 13.31           N  
ATOM   6208  CA  ASN D 106      -3.581  63.442  87.998  1.00 13.31           C  
ATOM   6209  C   ASN D 106      -2.352  64.235  88.401  1.00 13.62           C  
ATOM   6210  O   ASN D 106      -1.856  65.054  87.622  1.00 14.13           O  
ATOM   6211  CB  ASN D 106      -4.822  64.118  88.577  1.00 13.75           C  
ATOM   6212  CG  ASN D 106      -6.090  63.694  87.874  1.00 16.71           C  
ATOM   6213  OD1 ASN D 106      -6.047  63.100  86.796  1.00 18.37           O  
ATOM   6214  ND2 ASN D 106      -7.229  63.987  88.490  1.00 18.94           N  
ATOM   6215  N   ASN D 107      -1.834  63.967  89.605  1.00 13.22           N  
ATOM   6216  CA  ASN D 107      -0.600  64.621  90.046  1.00 13.29           C  
ATOM   6217  C   ASN D 107       0.569  64.276  89.125  1.00 12.50           C  
ATOM   6218  O   ASN D 107       1.307  65.162  88.690  1.00 12.50           O  
ATOM   6219  CB  ASN D 107      -0.251  64.238  91.486  1.00 12.85           C  
ATOM   6220  CG  ASN D 107      -1.179  64.869  92.513  1.00 13.11           C  
ATOM   6221  OD1 ASN D 107      -1.875  65.839  92.226  1.00 14.23           O  
ATOM   6222  ND2 ASN D 107      -1.172  64.327  93.715  1.00 13.51           N  
ATOM   6223  N   LEU D 108       0.713  62.988  88.797  1.00 13.65           N  
ATOM   6224  CA  LEU D 108       1.811  62.553  87.935  1.00 13.52           C  
ATOM   6225  C   LEU D 108       1.663  63.134  86.556  1.00 13.06           C  
ATOM   6226  O   LEU D 108       2.648  63.547  85.940  1.00 12.75           O  
ATOM   6227  CB  LEU D 108       1.876  61.032  87.844  1.00 14.72           C  
ATOM   6228  CG  LEU D 108       2.437  60.364  89.078  1.00 16.47           C  
ATOM   6229  CD1 LEU D 108       2.090  58.907  89.098  1.00 17.91           C  
ATOM   6230  CD2 LEU D 108       3.982  60.583  89.145  1.00 16.29           C  
ATOM   6231  N   GLU D 109       0.420  63.178  86.054  1.00 13.54           N  
ATOM   6232  CA  GLU D 109       0.200  63.745  84.733  1.00 13.85           C  
ATOM   6233  C   GLU D 109       0.594  65.215  84.701  1.00 13.86           C  
ATOM   6234  O   GLU D 109       1.268  65.673  83.770  1.00 14.04           O  
ATOM   6235  CB  GLU D 109      -1.224  63.506  84.252  1.00 14.15           C  
ATOM   6236  CG  GLU D 109      -1.360  63.914  82.804  1.00 13.81           C  
ATOM   6237  CD  GLU D 109      -2.569  63.327  82.114  1.00 18.26           C  
ATOM   6238  OE1 GLU D 109      -3.503  62.876  82.819  1.00 17.57           O  
ATOM   6239  OE2 GLU D 109      -2.565  63.330  80.854  1.00 18.18           O  
ATOM   6240  N   ALA D 110       0.251  65.955  85.756  1.00 12.84           N  
ATOM   6241  CA  ALA D 110       0.665  67.358  85.825  1.00 12.51           C  
ATOM   6242  C   ALA D 110       2.201  67.547  85.889  1.00 12.43           C  
ATOM   6243  O   ALA D 110       2.749  68.496  85.321  1.00 13.08           O  
ATOM   6244  CB  ALA D 110       0.024  68.014  87.034  1.00 12.77           C  
ATOM   6245  N   ILE D 111       2.873  66.663  86.612  1.00 12.35           N  
ATOM   6246  CA  ILE D 111       4.358  66.692  86.670  1.00 12.50           C  
ATOM   6247  C   ILE D 111       4.937  66.507  85.243  1.00 13.00           C  
ATOM   6248  O   ILE D 111       5.774  67.281  84.780  1.00 13.59           O  
ATOM   6249  CB  ILE D 111       4.901  65.633  87.638  1.00 12.95           C  
ATOM   6250  CG1 ILE D 111       4.543  65.990  89.084  1.00 12.34           C  
ATOM   6251  CG2 ILE D 111       6.421  65.491  87.467  1.00 13.09           C  
ATOM   6252  CD1 ILE D 111       4.521  64.831  90.057  1.00 15.64           C  
ATOM   6253  N   ILE D 112       4.458  65.480  84.545  1.00 13.24           N  
ATOM   6254  CA  ILE D 112       4.914  65.206  83.188  1.00 12.46           C  
ATOM   6255  C   ILE D 112       4.717  66.431  82.307  1.00 12.33           C  
ATOM   6256  O   ILE D 112       5.621  66.859  81.571  1.00 13.08           O  
ATOM   6257  CB  ILE D 112       4.163  63.985  82.587  1.00 12.75           C  
ATOM   6258  CG1 ILE D 112       4.608  62.712  83.293  1.00 13.86           C  
ATOM   6259  CG2 ILE D 112       4.425  63.878  81.094  1.00 14.18           C  
ATOM   6260  CD1 ILE D 112       3.652  61.550  83.074  1.00 14.23           C  
ATOM   6261  N   GLN D 113       3.518  67.012  82.372  1.00 12.72           N  
ATOM   6262  CA  GLN D 113       3.246  68.190  81.559  1.00 12.54           C  
ATOM   6263  C   GLN D 113       4.104  69.410  81.942  1.00 13.46           C  
ATOM   6264  O   GLN D 113       4.515  70.183  81.081  1.00 14.11           O  
ATOM   6265  CB  GLN D 113       1.776  68.550  81.632  1.00 13.65           C  
ATOM   6266  CG  GLN D 113       0.894  67.480  81.056  1.00 14.57           C  
ATOM   6267  CD  GLN D 113      -0.574  67.755  81.316  1.00 19.50           C  
ATOM   6268  OE1 GLN D 113      -0.929  68.593  82.146  1.00 24.00           O  
ATOM   6269  NE2 GLN D 113      -1.429  67.047  80.619  1.00 19.46           N  
ATOM   6270  N   SER D 114       4.387  69.578  83.235  1.00 13.69           N  
ATOM   6271  CA  SER D 114       5.207  70.704  83.647  1.00 15.16           C  
ATOM   6272  C   SER D 114       6.661  70.534  83.158  1.00 15.21           C  
ATOM   6273  O   SER D 114       7.286  71.477  82.653  1.00 15.92           O  
ATOM   6274  CB  SER D 114       5.126  70.836  85.155  1.00 15.57           C  
ATOM   6275  OG  SER D 114       5.792  72.008  85.593  1.00 18.68           O  
ATOM   6276  N   VAL D 115       7.175  69.319  83.271  1.00 15.08           N  
ATOM   6277  CA  VAL D 115       8.513  69.026  82.762  1.00 16.18           C  
ATOM   6278  C   VAL D 115       8.604  69.259  81.252  1.00 16.35           C  
ATOM   6279  O   VAL D 115       9.612  69.805  80.773  1.00 17.17           O  
ATOM   6280  CB  VAL D 115       8.934  67.588  83.120  1.00 16.86           C  
ATOM   6281  CG1 VAL D 115      10.259  67.200  82.414  1.00 16.53           C  
ATOM   6282  CG2 VAL D 115       9.050  67.427  84.639  1.00 15.43           C  
ATOM   6283  N   ALA D 116       7.554  68.884  80.509  1.00 15.93           N  
ATOM   6284  CA  ALA D 116       7.519  69.052  79.033  1.00 16.01           C  
ATOM   6285  C   ALA D 116       7.681  70.509  78.599  1.00 16.59           C  
ATOM   6286  O   ALA D 116       8.287  70.809  77.564  1.00 17.10           O  
ATOM   6287  CB  ALA D 116       6.195  68.504  78.449  1.00 15.48           C  
ATOM   6288  N   ARG D 117       7.100  71.402  79.392  1.00 16.87           N  
ATOM   6289  CA  ARG D 117       7.166  72.814  79.109  1.00 17.75           C  
ATOM   6290  C   ARG D 117       8.580  73.319  79.330  1.00 17.27           C  
ATOM   6291  O   ARG D 117       9.111  74.032  78.493  1.00 18.02           O  
ATOM   6292  CB  ARG D 117       6.186  73.587  80.001  1.00 18.15           C  
ATOM   6293  CG  ARG D 117       4.740  73.479  79.580  1.00 20.61           C  
ATOM   6294  CD  ARG D 117       3.824  73.867  80.745  1.00 25.12           C  
ATOM   6295  NE  ARG D 117       3.930  75.289  81.073  1.00 28.02           N  
ATOM   6296  CZ  ARG D 117       3.158  75.911  81.961  1.00 30.35           C  
ATOM   6297  NH1 ARG D 117       2.210  75.243  82.620  1.00 30.65           N  
ATOM   6298  NH2 ARG D 117       3.338  77.208  82.195  1.00 30.27           N  
ATOM   6299  N   ASP D 118       9.198  72.942  80.449  1.00 17.05           N  
ATOM   6300  CA  ASP D 118      10.496  73.507  80.811  1.00 17.47           C  
ATOM   6301  C   ASP D 118      11.714  72.709  80.319  1.00 17.15           C  
ATOM   6302  O   ASP D 118      12.816  73.269  80.189  1.00 17.37           O  
ATOM   6303  CB  ASP D 118      10.591  73.695  82.334  1.00 18.81           C  
ATOM   6304  CG  ASP D 118       9.599  74.727  82.875  1.00 19.49           C  
ATOM   6305  OD1 ASP D 118       9.112  75.595  82.098  1.00 22.71           O  
ATOM   6306  OD2 ASP D 118       9.306  74.655  84.088  1.00 22.40           O  
ATOM   6307  N   TYR D 119      11.526  71.415  80.057  1.00 14.96           N  
ATOM   6308  CA  TYR D 119      12.617  70.536  79.634  1.00 14.54           C  
ATOM   6309  C   TYR D 119      12.119  69.740  78.441  1.00 14.68           C  
ATOM   6310  O   TYR D 119      11.952  68.528  78.534  1.00 14.44           O  
ATOM   6311  CB  TYR D 119      13.064  69.596  80.790  1.00 14.51           C  
ATOM   6312  CG  TYR D 119      13.679  70.375  81.943  1.00 15.91           C  
ATOM   6313  CD1 TYR D 119      15.059  70.560  82.030  1.00 16.93           C  
ATOM   6314  CD2 TYR D 119      12.873  70.960  82.921  1.00 15.59           C  
ATOM   6315  CE1 TYR D 119      15.619  71.296  83.076  1.00 17.05           C  
ATOM   6316  CE2 TYR D 119      13.409  71.720  83.948  1.00 17.21           C  
ATOM   6317  CZ  TYR D 119      14.784  71.884  84.029  1.00 16.89           C  
ATOM   6318  OH  TYR D 119      15.324  72.629  85.054  1.00 16.38           O  
ATOM   6319  N   PRO D 120      11.885  70.417  77.297  1.00 15.26           N  
ATOM   6320  CA  PRO D 120      11.181  69.714  76.220  1.00 15.56           C  
ATOM   6321  C   PRO D 120      11.893  68.514  75.576  1.00 15.76           C  
ATOM   6322  O   PRO D 120      11.209  67.652  75.013  1.00 16.79           O  
ATOM   6323  CB  PRO D 120      10.912  70.808  75.176  1.00 15.98           C  
ATOM   6324  CG  PRO D 120      11.851  71.893  75.482  1.00 16.61           C  
ATOM   6325  CD  PRO D 120      12.222  71.808  76.933  1.00 15.68           C  
ATOM   6326  N   LEU D 121      13.226  68.451  75.670  1.00 15.34           N  
ATOM   6327  CA  LEU D 121      13.966  67.346  75.040  1.00 15.11           C  
ATOM   6328  C   LEU D 121      14.316  66.254  76.048  1.00 14.57           C  
ATOM   6329  O   LEU D 121      14.979  65.280  75.692  1.00 14.64           O  
ATOM   6330  CB  LEU D 121      15.238  67.842  74.328  1.00 16.28           C  
ATOM   6331  CG  LEU D 121      15.018  68.822  73.169  1.00 18.05           C  
ATOM   6332  CD1 LEU D 121      16.337  69.365  72.617  1.00 19.98           C  
ATOM   6333  CD2 LEU D 121      14.247  68.137  72.079  1.00 20.74           C  
ATOM   6334  N   THR D 122      13.863  66.418  77.285  1.00 12.22           N  
ATOM   6335  CA  THR D 122      14.190  65.464  78.341  1.00 12.51           C  
ATOM   6336  C   THR D 122      13.179  64.329  78.382  1.00 13.20           C  
ATOM   6337  O   THR D 122      11.969  64.561  78.277  1.00 14.88           O  
ATOM   6338  CB  THR D 122      14.248  66.189  79.692  1.00 12.94           C  
ATOM   6339  OG1 THR D 122      15.227  67.235  79.604  1.00 12.87           O  
ATOM   6340  CG2 THR D 122      14.600  65.240  80.851  1.00 13.27           C  
ATOM   6341  N   GLU D 123      13.682  63.105  78.519  1.00 12.56           N  
ATOM   6342  CA  GLU D 123      12.845  61.915  78.676  1.00 13.32           C  
ATOM   6343  C   GLU D 123      12.510  61.688  80.136  1.00 12.87           C  
ATOM   6344  O   GLU D 123      13.323  62.013  81.008  1.00 13.55           O  
ATOM   6345  CB  GLU D 123      13.569  60.691  78.120  1.00 13.12           C  
ATOM   6346  CG  GLU D 123      13.665  60.761  76.590  1.00 15.52           C  
ATOM   6347  CD  GLU D 123      14.486  59.644  76.008  1.00 20.23           C  
ATOM   6348  OE1 GLU D 123      15.142  58.924  76.765  1.00 19.91           O  
ATOM   6349  OE2 GLU D 123      14.479  59.474  74.764  1.00 24.60           O  
ATOM   6350  N   ILE D 124      11.313  61.156  80.428  1.00 12.08           N  
ATOM   6351  CA  ILE D 124      10.971  60.762  81.786  1.00 12.61           C  
ATOM   6352  C   ILE D 124      10.887  59.258  81.813  1.00 10.92           C  
ATOM   6353  O   ILE D 124      10.212  58.657  80.973  1.00 12.55           O  
ATOM   6354  CB  ILE D 124       9.633  61.405  82.263  1.00 12.55           C  
ATOM   6355  CG1 ILE D 124       9.821  62.918  82.446  1.00 16.07           C  
ATOM   6356  CG2 ILE D 124       9.125  60.767  83.567  1.00 13.51           C  
ATOM   6357  CD1 ILE D 124       8.487  63.686  82.651  1.00 14.23           C  
ATOM   6358  N   LYS D 125      11.601  58.643  82.744  1.00 11.07           N  
ATOM   6359  CA  LYS D 125      11.486  57.202  82.974  1.00 10.99           C  
ATOM   6360  C   LYS D 125      10.655  57.040  84.235  1.00 11.29           C  
ATOM   6361  O   LYS D 125      11.105  57.372  85.338  1.00 12.16           O  
ATOM   6362  CB  LYS D 125      12.886  56.589  83.119  1.00 11.76           C  
ATOM   6363  CG  LYS D 125      13.819  56.924  81.952  1.00 11.88           C  
ATOM   6364  CD  LYS D 125      13.238  56.355  80.642  1.00 13.86           C  
ATOM   6365  CE  LYS D 125      14.089  56.698  79.431  1.00 13.87           C  
ATOM   6366  NZ  LYS D 125      13.438  56.223  78.151  1.00 15.99           N  
ATOM   6367  N   LEU D 126       9.421  56.573  84.057  1.00 10.93           N  
ATOM   6368  CA  LEU D 126       8.495  56.462  85.188  1.00 10.61           C  
ATOM   6369  C   LEU D 126       8.567  55.025  85.719  1.00 10.77           C  
ATOM   6370  O   LEU D 126       8.091  54.073  85.070  1.00 11.46           O  
ATOM   6371  CB  LEU D 126       7.065  56.800  84.738  1.00 11.09           C  
ATOM   6372  CG  LEU D 126       5.918  56.677  85.754  1.00 11.01           C  
ATOM   6373  CD1 LEU D 126       6.127  57.625  86.976  1.00 13.70           C  
ATOM   6374  CD2 LEU D 126       4.581  56.954  85.039  1.00 11.56           C  
ATOM   6375  N   LEU D 127       9.180  54.881  86.890  1.00 10.54           N  
ATOM   6376  CA  LEU D 127       9.420  53.548  87.411  1.00 10.76           C  
ATOM   6377  C   LEU D 127       8.142  52.960  87.970  1.00 11.10           C  
ATOM   6378  O   LEU D 127       7.339  53.654  88.595  1.00 12.24           O  
ATOM   6379  CB  LEU D 127      10.494  53.570  88.515  1.00 11.25           C  
ATOM   6380  CG  LEU D 127      11.921  53.439  87.983  1.00 14.17           C  
ATOM   6381  CD1 LEU D 127      12.343  54.567  87.015  1.00 16.73           C  
ATOM   6382  CD2 LEU D 127      12.838  53.370  89.209  1.00 17.22           C  
ATOM   6383  N   SER D 128       7.992  51.650  87.822  1.00 11.13           N  
ATOM   6384  CA  SER D 128       6.982  50.958  88.601  1.00 11.98           C  
ATOM   6385  C   SER D 128       7.237  51.200  90.092  1.00 10.97           C  
ATOM   6386  O   SER D 128       8.383  51.141  90.541  1.00 12.25           O  
ATOM   6387  CB  SER D 128       7.081  49.463  88.300  1.00 12.68           C  
ATOM   6388  OG  SER D 128       8.354  48.985  88.663  1.00 14.46           O  
ATOM   6389  N   ILE D 129       6.177  51.424  90.868  1.00 11.22           N  
ATOM   6390  CA  ILE D 129       6.291  51.358  92.324  1.00 11.60           C  
ATOM   6391  C   ILE D 129       6.819  49.972  92.715  1.00 11.22           C  
ATOM   6392  O   ILE D 129       6.397  48.948  92.183  1.00 11.41           O  
ATOM   6393  CB  ILE D 129       4.917  51.626  92.976  1.00 10.65           C  
ATOM   6394  CG1 ILE D 129       4.400  53.015  92.569  1.00 12.41           C  
ATOM   6395  CG2 ILE D 129       4.969  51.408  94.491  1.00 12.27           C  
ATOM   6396  CD1 ILE D 129       2.917  53.266  92.904  1.00 12.36           C  
ATOM   6397  N   LEU D 130       7.754  49.940  93.665  1.00 11.61           N  
ATOM   6398  CA  LEU D 130       8.405  48.681  93.997  1.00 11.13           C  
ATOM   6399  C   LEU D 130       7.513  47.799  94.880  1.00 11.27           C  
ATOM   6400  O   LEU D 130       6.630  48.311  95.575  1.00 10.43           O  
ATOM   6401  CB  LEU D 130       9.738  48.941  94.699  1.00 11.45           C  
ATOM   6402  CG  LEU D 130      10.674  49.962  94.058  1.00 13.63           C  
ATOM   6403  CD1 LEU D 130      12.016  49.973  94.790  1.00 14.33           C  
ATOM   6404  CD2 LEU D 130      10.877  49.633  92.618  1.00 14.11           C  
ATOM   6405  N   PRO D 131       7.753  46.471  94.891  1.00 11.18           N  
ATOM   6406  CA  PRO D 131       6.988  45.568  95.778  1.00 11.67           C  
ATOM   6407  C   PRO D 131       7.377  45.777  97.243  1.00 11.06           C  
ATOM   6408  O   PRO D 131       8.444  46.343  97.546  1.00 11.93           O  
ATOM   6409  CB  PRO D 131       7.404  44.160  95.331  1.00 12.05           C  
ATOM   6410  CG  PRO D 131       8.776  44.376  94.701  1.00 11.99           C  
ATOM   6411  CD  PRO D 131       8.797  45.765  94.120  1.00 12.05           C  
ATOM   6412  N   VAL D 132       6.502  45.314  98.124  1.00 11.14           N  
ATOM   6413  CA  VAL D 132       6.771  45.232  99.537  1.00 10.76           C  
ATOM   6414  C   VAL D 132       6.851  43.767  99.935  1.00 11.10           C  
ATOM   6415  O   VAL D 132       6.448  42.870  99.177  1.00 11.32           O  
ATOM   6416  CB  VAL D 132       5.681  45.954 100.355  1.00 11.15           C  
ATOM   6417  CG1 VAL D 132       5.728  47.434 100.054  1.00 10.86           C  
ATOM   6418  CG2 VAL D 132       4.278  45.355 100.085  1.00 11.46           C  
ATOM   6419  N   ASN D 133       7.358  43.527 101.140  1.00 10.99           N  
ATOM   6420  CA  ASN D 133       7.359  42.185 101.705  1.00 12.96           C  
ATOM   6421  C   ASN D 133       6.247  42.116 102.726  1.00 13.82           C  
ATOM   6422  O   ASN D 133       6.197  42.919 103.661  1.00 13.84           O  
ATOM   6423  CB  ASN D 133       8.728  41.832 102.288  1.00 12.62           C  
ATOM   6424  CG  ASN D 133       8.826  40.363 102.675  1.00 13.78           C  
ATOM   6425  OD1 ASN D 133       8.127  39.914 103.568  1.00 15.85           O  
ATOM   6426  ND2 ASN D 133       9.681  39.604 101.981  1.00 13.57           N  
ATOM   6427  N   GLU D 134       5.349  41.145 102.526  1.00 15.42           N  
ATOM   6428  CA  GLU D 134       4.121  41.062 103.313  1.00 17.67           C  
ATOM   6429  C   GLU D 134       4.259  40.170 104.560  1.00 17.74           C  
ATOM   6430  O   GLU D 134       3.270  39.928 105.255  1.00 18.22           O  
ATOM   6431  CB  GLU D 134       2.930  40.641 102.420  1.00 17.86           C  
ATOM   6432  CG  GLU D 134       2.496  41.740 101.424  1.00 19.79           C  
ATOM   6433  CD  GLU D 134       1.370  41.307 100.473  1.00 20.05           C  
ATOM   6434  OE1 GLU D 134       0.926  40.143 100.566  1.00 25.64           O  
ATOM   6435  OE2 GLU D 134       0.910  42.139  99.649  1.00 20.91           O  
ATOM   6436  N   ARG D 135       5.475  39.705 104.864  1.00 17.68           N  
ATOM   6437  CA  ARG D 135       5.701  38.876 106.069  1.00 18.66           C  
ATOM   6438  C   ARG D 135       5.294  39.666 107.305  1.00 18.05           C  
ATOM   6439  O   ARG D 135       5.465  40.884 107.353  1.00 18.07           O  
ATOM   6440  CB  ARG D 135       7.163  38.427 106.193  1.00 18.63           C  
ATOM   6441  CG  ARG D 135       7.569  37.279 105.252  1.00 20.70           C  
ATOM   6442  CD  ARG D 135       9.089  37.014 105.286  1.00 21.90           C  
ATOM   6443  NE  ARG D 135       9.587  36.630 106.612  1.00 26.49           N  
ATOM   6444  CZ  ARG D 135       9.571  35.393 107.109  1.00 27.48           C  
ATOM   6445  NH1 ARG D 135       9.074  34.382 106.402  1.00 27.32           N  
ATOM   6446  NH2 ARG D 135      10.049  35.171 108.329  1.00 29.02           N  
ATOM   6447  N   GLU D 136       4.750  38.969 108.303  1.00 17.88           N  
ATOM   6448  CA  GLU D 136       4.276  39.623 109.521  1.00 18.56           C  
ATOM   6449  C   GLU D 136       5.321  40.538 110.200  1.00 17.82           C  
ATOM   6450  O   GLU D 136       4.986  41.612 110.712  1.00 16.34           O  
ATOM   6451  CB  GLU D 136       3.754  38.576 110.520  1.00 18.43           C  
ATOM   6452  CG  GLU D 136       2.956  39.182 111.669  1.00 21.29           C  
ATOM   6453  CD  GLU D 136       2.739  38.229 112.851  1.00 21.39           C  
ATOM   6454  OE1 GLU D 136       2.856  36.982 112.694  1.00 25.75           O  
ATOM   6455  OE2 GLU D 136       2.432  38.740 113.954  1.00 24.85           O  
ATOM   6456  N   GLU D 137       6.588  40.119 110.177  1.00 18.13           N  
ATOM   6457  CA  GLU D 137       7.666  40.866 110.838  1.00 19.07           C  
ATOM   6458  C   GLU D 137       7.896  42.275 110.284  1.00 18.47           C  
ATOM   6459  O   GLU D 137       8.544  43.091 110.933  1.00 19.30           O  
ATOM   6460  CB  GLU D 137       8.976  40.080 110.780  1.00 19.09           C  
ATOM   6461  CG  GLU D 137       9.507  39.836 109.370  1.00 21.40           C  
ATOM   6462  CD  GLU D 137      10.865  39.154 109.366  1.00 21.65           C  
ATOM   6463  OE1 GLU D 137      11.743  39.571 110.153  1.00 25.56           O  
ATOM   6464  OE2 GLU D 137      11.044  38.207 108.573  1.00 26.28           O  
ATOM   6465  N   TYR D 138       7.381  42.553 109.085  1.00 17.57           N  
ATOM   6466  CA  TYR D 138       7.602  43.841 108.427  1.00 17.78           C  
ATOM   6467  C   TYR D 138       6.381  44.753 108.417  1.00 18.26           C  
ATOM   6468  O   TYR D 138       6.399  45.802 107.769  1.00 17.61           O  
ATOM   6469  CB  TYR D 138       8.019  43.619 106.972  1.00 17.09           C  
ATOM   6470  CG  TYR D 138       9.298  42.854 106.769  1.00 16.89           C  
ATOM   6471  CD1 TYR D 138      10.469  43.233 107.408  1.00 15.52           C  
ATOM   6472  CD2 TYR D 138       9.342  41.782 105.887  1.00 16.74           C  
ATOM   6473  CE1 TYR D 138      11.659  42.531 107.188  1.00 16.75           C  
ATOM   6474  CE2 TYR D 138      10.512  41.081 105.665  1.00 18.86           C  
ATOM   6475  CZ  TYR D 138      11.664  41.460 106.317  1.00 18.16           C  
ATOM   6476  OH  TYR D 138      12.830  40.761 106.084  1.00 20.92           O  
ATOM   6477  N   GLN D 139       5.327  44.351 109.124  1.00 19.06           N  
ATOM   6478  CA  GLN D 139       4.060  45.093 109.094  1.00 20.66           C  
ATOM   6479  C   GLN D 139       4.148  46.580 109.509  1.00 20.87           C  
ATOM   6480  O   GLN D 139       3.380  47.394 108.997  1.00 21.76           O  
ATOM   6481  CB  GLN D 139       2.967  44.345 109.870  1.00 20.48           C  
ATOM   6482  CG  GLN D 139       2.515  43.058 109.185  1.00 21.71           C  
ATOM   6483  CD  GLN D 139       1.528  42.224 110.007  1.00 22.72           C  
ATOM   6484  OE1 GLN D 139       1.487  42.301 111.242  1.00 28.33           O  
ATOM   6485  NE2 GLN D 139       0.728  41.411 109.314  1.00 24.96           N  
ATOM   6486  N   GLN D 140       5.108  46.917 110.375  0.50 20.82           N  
ATOM   6488  CA  GLN D 140       5.319  48.290 110.885  0.50 20.87           C  
ATOM   6490  C   GLN D 140       5.728  49.337 109.840  0.50 20.57           C  
ATOM   6492  O   GLN D 140       5.357  50.514 109.948  0.50 20.37           O  
ATOM   6494  CB  GLN D 140       6.371  48.291 112.000  0.50 21.12           C  
ATOM   6496  CG  GLN D 140       5.981  47.506 113.234  0.50 21.55           C  
ATOM   6498  CD  GLN D 140       7.025  47.593 114.324  0.50 21.60           C  
ATOM   6500  OE1 GLN D 140       8.170  47.172 114.149  0.50 22.12           O  
ATOM   6502  NE2 GLN D 140       6.629  48.137 115.466  0.50 22.74           N  
ATOM   6504  N   ALA D 141       6.531  48.920 108.863  1.00 19.70           N  
ATOM   6505  CA  ALA D 141       6.919  49.797 107.763  1.00 18.76           C  
ATOM   6506  C   ALA D 141       5.958  49.639 106.594  1.00 17.05           C  
ATOM   6507  O   ALA D 141       5.590  50.622 105.961  1.00 17.76           O  
ATOM   6508  CB  ALA D 141       8.347  49.525 107.330  1.00 18.74           C  
ATOM   6509  N   VAL D 142       5.543  48.402 106.318  1.00 15.30           N  
ATOM   6510  CA  VAL D 142       4.709  48.124 105.148  1.00 14.02           C  
ATOM   6511  C   VAL D 142       3.296  48.714 105.300  1.00 13.15           C  
ATOM   6512  O   VAL D 142       2.745  49.284 104.346  1.00 12.32           O  
ATOM   6513  CB  VAL D 142       4.700  46.618 104.826  1.00 13.24           C  
ATOM   6514  CG1 VAL D 142       3.678  46.271 103.763  1.00 13.85           C  
ATOM   6515  CG2 VAL D 142       6.087  46.193 104.382  1.00 13.01           C  
ATOM   6516  N   TYR D 143       2.728  48.599 106.506  1.00 13.88           N  
ATOM   6517  CA  TYR D 143       1.456  49.241 106.820  1.00 13.67           C  
ATOM   6518  C   TYR D 143       0.380  48.781 105.829  1.00 13.65           C  
ATOM   6519  O   TYR D 143       0.282  47.586 105.513  1.00 14.10           O  
ATOM   6520  CB  TYR D 143       1.648  50.767 106.847  1.00 14.16           C  
ATOM   6521  CG  TYR D 143       0.522  51.532 107.493  1.00 13.56           C  
ATOM   6522  CD1 TYR D 143      -0.009  51.122 108.707  1.00 13.08           C  
ATOM   6523  CD2 TYR D 143       0.020  52.684 106.896  1.00 13.91           C  
ATOM   6524  CE1 TYR D 143      -1.067  51.829 109.307  1.00 12.45           C  
ATOM   6525  CE2 TYR D 143      -1.021  53.396 107.475  1.00 11.09           C  
ATOM   6526  CZ  TYR D 143      -1.557  52.967 108.681  1.00 13.25           C  
ATOM   6527  OH  TYR D 143      -2.585  53.679 109.252  1.00 15.21           O  
ATOM   6528  N   ILE D 144      -0.437  49.688 105.329  1.00 12.95           N  
ATOM   6529  CA  ILE D 144      -1.559  49.268 104.482  1.00 13.56           C  
ATOM   6530  C   ILE D 144      -1.186  48.974 103.006  1.00 13.99           C  
ATOM   6531  O   ILE D 144      -2.051  48.665 102.190  1.00 13.36           O  
ATOM   6532  CB  ILE D 144      -2.734  50.282 104.548  1.00 13.16           C  
ATOM   6533  CG1 ILE D 144      -2.319  51.631 103.935  1.00 13.42           C  
ATOM   6534  CG2 ILE D 144      -3.261  50.415 106.003  1.00 13.98           C  
ATOM   6535  CD1 ILE D 144      -3.491  52.650 103.840  1.00 14.06           C  
ATOM   6536  N   ARG D 145       0.092  49.077 102.661  1.00 13.57           N  
ATOM   6537  CA  ARG D 145       0.508  48.730 101.305  1.00 13.45           C  
ATOM   6538  C   ARG D 145       0.333  47.231 101.089  1.00 13.80           C  
ATOM   6539  O   ARG D 145       0.494  46.426 102.026  1.00 13.84           O  
ATOM   6540  CB  ARG D 145       1.972  49.094 101.103  1.00 13.16           C  
ATOM   6541  CG  ARG D 145       2.295  50.553 101.294  1.00 12.93           C  
ATOM   6542  CD  ARG D 145       3.819  50.755 101.295  1.00 13.12           C  
ATOM   6543  NE  ARG D 145       4.168  52.148 101.565  1.00 14.58           N  
ATOM   6544  CZ  ARG D 145       4.095  52.715 102.762  1.00 15.55           C  
ATOM   6545  NH1 ARG D 145       3.666  52.028 103.830  1.00 12.20           N  
ATOM   6546  NH2 ARG D 145       4.434  53.982 102.911  1.00 13.53           N  
ATOM   6547  N   SER D 146       0.005  46.855  99.852  1.00 13.31           N  
ATOM   6548  CA  SER D 146      -0.049  45.440  99.458  1.00 12.92           C  
ATOM   6549  C   SER D 146       0.433  45.367  98.036  1.00 12.21           C  
ATOM   6550  O   SER D 146       0.365  46.359  97.308  1.00 13.41           O  
ATOM   6551  CB  SER D 146      -1.465  44.880  99.542  1.00 12.30           C  
ATOM   6552  OG  SER D 146      -2.280  45.362  98.487  1.00 12.94           O  
ATOM   6553  N   ASN D 147       0.938  44.199  97.642  1.00 11.93           N  
ATOM   6554  CA  ASN D 147       1.428  44.036  96.288  1.00 11.65           C  
ATOM   6555  C   ASN D 147       0.312  44.035  95.248  1.00 12.63           C  
ATOM   6556  O   ASN D 147       0.556  44.391  94.093  1.00 13.07           O  
ATOM   6557  CB  ASN D 147       2.350  42.813  96.187  1.00 12.24           C  
ATOM   6558  CG  ASN D 147       3.667  43.022  96.926  1.00 11.38           C  
ATOM   6559  OD1 ASN D 147       4.362  44.013  96.678  1.00 11.95           O  
ATOM   6560  ND2 ASN D 147       3.998  42.113  97.860  1.00 12.73           N  
ATOM   6561  N   GLU D 148      -0.909  43.680  95.654  1.00 12.83           N  
ATOM   6562  CA  GLU D 148      -2.056  43.791  94.729  1.00 14.21           C  
ATOM   6563  C   GLU D 148      -2.370  45.260  94.418  1.00 13.87           C  
ATOM   6564  O   GLU D 148      -2.597  45.606  93.255  1.00 13.16           O  
ATOM   6565  CB  GLU D 148      -3.292  43.055  95.251  1.00 15.38           C  
ATOM   6566  CG  GLU D 148      -3.019  41.608  95.690  1.00 19.58           C  
ATOM   6567  CD  GLU D 148      -2.711  41.502  97.188  1.00 23.47           C  
ATOM   6568  OE1 GLU D 148      -3.658  41.149  97.920  1.00 27.20           O  
ATOM   6569  OE2 GLU D 148      -1.560  41.786  97.647  1.00 23.87           O  
ATOM   6570  N   LYS D 149      -2.352  46.124  95.437  1.00 13.14           N  
ATOM   6571  CA  LYS D 149      -2.558  47.567  95.236  1.00 14.01           C  
ATOM   6572  C   LYS D 149      -1.434  48.128  94.372  1.00 12.81           C  
ATOM   6573  O   LYS D 149      -1.682  48.861  93.403  1.00 13.20           O  
ATOM   6574  CB  LYS D 149      -2.547  48.351  96.555  1.00 14.24           C  
ATOM   6575  CG  LYS D 149      -3.697  48.092  97.510  1.00 16.98           C  
ATOM   6576  CD  LYS D 149      -3.364  48.675  98.892  1.00 16.97           C  
ATOM   6577  CE  LYS D 149      -4.563  48.585  99.860  1.00 18.84           C  
ATOM   6578  NZ  LYS D 149      -4.335  49.386 101.120  1.00 20.52           N  
ATOM   6579  N   ILE D 150      -0.199  47.785  94.733  1.00 12.54           N  
ATOM   6580  CA  ILE D 150       0.975  48.287  93.992  1.00 12.31           C  
ATOM   6581  C   ILE D 150       0.891  47.883  92.511  1.00 12.60           C  
ATOM   6582  O   ILE D 150       1.101  48.721  91.639  1.00 12.46           O  
ATOM   6583  CB  ILE D 150       2.298  47.837  94.639  1.00 12.59           C  
ATOM   6584  CG1 ILE D 150       2.489  48.603  95.961  1.00 13.83           C  
ATOM   6585  CG2 ILE D 150       3.469  48.097  93.721  1.00 12.78           C  
ATOM   6586  CD1 ILE D 150       3.433  47.943  96.925  1.00 12.27           C  
ATOM   6587  N   GLN D 151       0.573  46.618  92.241  1.00 12.68           N  
ATOM   6588  CA  GLN D 151       0.397  46.153  90.856  1.00 13.51           C  
ATOM   6589  C   GLN D 151      -0.738  46.893  90.115  1.00 13.02           C  
ATOM   6590  O   GLN D 151      -0.591  47.208  88.944  1.00 12.93           O  
ATOM   6591  CB  GLN D 151       0.192  44.640  90.824  1.00 14.38           C  
ATOM   6592  CG  GLN D 151       1.487  43.896  91.063  1.00 18.68           C  
ATOM   6593  CD  GLN D 151       1.321  42.384  91.081  1.00 24.01           C  
ATOM   6594  OE1 GLN D 151       0.675  41.823  91.975  1.00 26.98           O  
ATOM   6595  NE2 GLN D 151       1.928  41.713  90.108  1.00 26.21           N  
ATOM   6596  N   ASN D 152      -1.842  47.189  90.802  1.00 12.93           N  
ATOM   6597  CA  ASN D 152      -2.921  47.983  90.193  1.00 13.70           C  
ATOM   6598  C   ASN D 152      -2.476  49.412  89.862  1.00 13.46           C  
ATOM   6599  O   ASN D 152      -2.801  49.951  88.794  1.00 13.79           O  
ATOM   6600  CB  ASN D 152      -4.171  47.986  91.079  1.00 14.30           C  
ATOM   6601  CG  ASN D 152      -4.853  46.634  91.103  1.00 16.63           C  
ATOM   6602  OD1 ASN D 152      -4.698  45.837  90.176  1.00 20.85           O  
ATOM   6603  ND2 ASN D 152      -5.619  46.367  92.157  1.00 18.92           N  
ATOM   6604  N   TRP D 153      -1.715  50.028  90.763  1.00 12.12           N  
ATOM   6605  CA  TRP D 153      -1.186  51.349  90.470  1.00 12.05           C  
ATOM   6606  C   TRP D 153      -0.226  51.293  89.302  1.00 11.63           C  
ATOM   6607  O   TRP D 153      -0.249  52.179  88.451  1.00 11.21           O  
ATOM   6608  CB  TRP D 153      -0.524  51.962  91.697  1.00 12.47           C  
ATOM   6609  CG  TRP D 153      -1.562  52.488  92.655  1.00 11.61           C  
ATOM   6610  CD1 TRP D 153      -2.724  51.848  93.067  1.00 13.89           C  
ATOM   6611  CD2 TRP D 153      -1.548  53.759  93.321  1.00 12.10           C  
ATOM   6612  NE1 TRP D 153      -3.417  52.657  93.948  1.00 14.30           N  
ATOM   6613  CE2 TRP D 153      -2.715  53.820  94.136  1.00 14.47           C  
ATOM   6614  CE3 TRP D 153      -0.651  54.841  93.337  1.00 13.51           C  
ATOM   6615  CZ2 TRP D 153      -3.016  54.938  94.927  1.00 14.09           C  
ATOM   6616  CZ3 TRP D 153      -0.940  55.946  94.132  1.00 13.31           C  
ATOM   6617  CH2 TRP D 153      -2.115  55.981  94.928  1.00 12.64           C  
ATOM   6618  N   ASN D 154       0.587  50.241  89.243  1.00 10.90           N  
ATOM   6619  CA  ASN D 154       1.575  50.116  88.177  1.00 10.76           C  
ATOM   6620  C   ASN D 154       0.928  49.975  86.817  1.00 11.45           C  
ATOM   6621  O   ASN D 154       1.467  50.468  85.817  1.00 11.83           O  
ATOM   6622  CB  ASN D 154       2.566  48.993  88.475  1.00 11.04           C  
ATOM   6623  CG  ASN D 154       3.535  49.381  89.584  1.00 10.34           C  
ATOM   6624  OD1 ASN D 154       3.723  50.573  89.845  1.00 12.91           O  
ATOM   6625  ND2 ASN D 154       4.179  48.384  90.207  1.00 12.34           N  
ATOM   6626  N   GLN D 155      -0.247  49.347  86.779  1.00 11.60           N  
ATOM   6627  CA  GLN D 155      -0.996  49.235  85.520  1.00 13.44           C  
ATOM   6628  C   GLN D 155      -1.428  50.623  85.067  1.00 11.86           C  
ATOM   6629  O   GLN D 155      -1.325  50.958  83.877  1.00 12.71           O  
ATOM   6630  CB  GLN D 155      -2.200  48.280  85.657  1.00 13.30           C  
ATOM   6631  CG  GLN D 155      -2.775  47.794  84.336  1.00 17.38           C  
ATOM   6632  CD  GLN D 155      -3.695  46.587  84.515  1.00 18.62           C  
ATOM   6633  OE1 GLN D 155      -3.613  45.869  85.529  1.00 28.16           O  
ATOM   6634  NE2 GLN D 155      -4.578  46.361  83.545  1.00 26.24           N  
ATOM   6635  N   ALA D 156      -1.894  51.436  86.022  1.00 10.62           N  
ATOM   6636  CA  ALA D 156      -2.251  52.830  85.746  1.00 10.44           C  
ATOM   6637  C   ALA D 156      -1.053  53.702  85.297  1.00 10.45           C  
ATOM   6638  O   ALA D 156      -1.176  54.502  84.377  1.00 11.24           O  
ATOM   6639  CB  ALA D 156      -2.962  53.440  86.934  1.00 11.22           C  
ATOM   6640  N   TYR D 157       0.089  53.549  85.960  1.00 10.01           N  
ATOM   6641  CA  TYR D 157       1.294  54.267  85.546  1.00 10.40           C  
ATOM   6642  C   TYR D 157       1.662  53.903  84.109  1.00 11.06           C  
ATOM   6643  O   TYR D 157       2.059  54.770  83.325  1.00 11.11           O  
ATOM   6644  CB  TYR D 157       2.474  53.877  86.450  1.00 10.97           C  
ATOM   6645  CG  TYR D 157       2.553  54.593  87.807  1.00 11.44           C  
ATOM   6646  CD1 TYR D 157       1.401  55.045  88.473  1.00 13.11           C  
ATOM   6647  CD2 TYR D 157       3.788  54.791  88.425  1.00 10.98           C  
ATOM   6648  CE1 TYR D 157       1.486  55.681  89.731  1.00 12.55           C  
ATOM   6649  CE2 TYR D 157       3.885  55.430  89.662  1.00 11.00           C  
ATOM   6650  CZ  TYR D 157       2.730  55.870  90.310  1.00 11.79           C  
ATOM   6651  OH  TYR D 157       2.831  56.502  91.523  1.00 12.95           O  
ATOM   6652  N   GLN D 158       1.565  52.613  83.783  1.00 11.77           N  
ATOM   6653  CA  GLN D 158       1.893  52.136  82.437  1.00 13.09           C  
ATOM   6654  C   GLN D 158       0.975  52.794  81.404  1.00 12.86           C  
ATOM   6655  O   GLN D 158       1.424  53.173  80.301  1.00 12.72           O  
ATOM   6656  CB  GLN D 158       1.793  50.618  82.361  1.00 13.64           C  
ATOM   6657  CG  GLN D 158       2.273  50.015  81.047  1.00 17.26           C  
ATOM   6658  CD  GLN D 158       2.160  48.496  81.053  1.00 18.38           C  
ATOM   6659  OE1 GLN D 158       1.111  47.941  81.396  1.00 27.55           O  
ATOM   6660  NE2 GLN D 158       3.234  47.819  80.658  1.00 27.11           N  
ATOM   6661  N   GLU D 159      -0.303  52.947  81.750  1.00 12.37           N  
ATOM   6662  CA  GLU D 159      -1.277  53.553  80.834  1.00 14.67           C  
ATOM   6663  C   GLU D 159      -1.003  55.049  80.669  1.00 13.39           C  
ATOM   6664  O   GLU D 159      -1.070  55.595  79.551  1.00 13.32           O  
ATOM   6665  CB  GLU D 159      -2.690  53.264  81.335  1.00 13.88           C  
ATOM   6666  CG  GLU D 159      -2.999  51.760  81.251  1.00 18.94           C  
ATOM   6667  CD  GLU D 159      -4.356  51.366  81.819  1.00 20.76           C  
ATOM   6668  OE1 GLU D 159      -4.899  52.109  82.672  1.00 27.65           O  
ATOM   6669  OE2 GLU D 159      -4.865  50.287  81.410  1.00 26.32           O  
ATOM   6670  N   LEU D 160      -0.625  55.702  81.767  1.00 12.05           N  
ATOM   6671  CA  LEU D 160      -0.274  57.113  81.718  1.00 11.44           C  
ATOM   6672  C   LEU D 160       0.960  57.297  80.798  1.00 11.55           C  
ATOM   6673  O   LEU D 160       0.982  58.183  79.950  1.00 10.98           O  
ATOM   6674  CB  LEU D 160      -0.051  57.679  83.140  1.00 11.99           C  
ATOM   6675  CG  LEU D 160       0.480  59.111  83.190  1.00 11.43           C  
ATOM   6676  CD1 LEU D 160      -0.424  60.112  82.511  1.00 11.29           C  
ATOM   6677  CD2 LEU D 160       0.775  59.527  84.657  1.00 12.08           C  
ATOM   6678  N   ALA D 161       1.956  56.436  80.962  1.00  9.86           N  
ATOM   6679  CA  ALA D 161       3.146  56.550  80.131  1.00  9.12           C  
ATOM   6680  C   ALA D 161       2.835  56.436  78.639  1.00  9.03           C  
ATOM   6681  O   ALA D 161       3.533  57.030  77.818  1.00  9.96           O  
ATOM   6682  CB  ALA D 161       4.206  55.534  80.539  1.00  9.08           C  
ATOM   6683  N   SER D 162       1.826  55.645  78.309  1.00  9.00           N  
ATOM   6684  CA  SER D 162       1.519  55.398  76.887  1.00  8.74           C  
ATOM   6685  C   SER D 162       0.940  56.636  76.203  1.00  8.04           C  
ATOM   6686  O   SER D 162       0.798  56.654  74.982  1.00  9.02           O  
ATOM   6687  CB  SER D 162       0.530  54.240  76.746  1.00  9.74           C  
ATOM   6688  OG  SER D 162      -0.773  54.607  77.162  1.00 12.84           O  
ATOM   6689  N   ALA D 163       0.579  57.645  76.992  1.00  8.61           N  
ATOM   6690  CA  ALA D 163      -0.045  58.862  76.446  1.00  9.12           C  
ATOM   6691  C   ALA D 163       0.961  59.977  76.148  1.00  9.42           C  
ATOM   6692  O   ALA D 163       0.554  61.053  75.692  1.00  9.25           O  
ATOM   6693  CB  ALA D 163      -1.131  59.380  77.415  1.00  9.42           C  
ATOM   6694  N   TYR D 164       2.248  59.733  76.412  1.00  9.55           N  
ATOM   6695  CA  TYR D 164       3.297  60.747  76.221  1.00 10.19           C  
ATOM   6696  C   TYR D 164       4.501  60.095  75.546  1.00  9.73           C  
ATOM   6697  O   TYR D 164       5.067  59.143  76.095  1.00  9.15           O  
ATOM   6698  CB  TYR D 164       3.712  61.381  77.579  1.00 10.64           C  
ATOM   6699  CG  TYR D 164       2.585  62.206  78.162  1.00 11.72           C  
ATOM   6700  CD1 TYR D 164       2.429  63.537  77.786  1.00 14.11           C  
ATOM   6701  CD2 TYR D 164       1.650  61.650  79.034  1.00 12.99           C  
ATOM   6702  CE1 TYR D 164       1.362  64.300  78.255  1.00 13.44           C  
ATOM   6703  CE2 TYR D 164       0.575  62.399  79.521  1.00 13.61           C  
ATOM   6704  CZ  TYR D 164       0.435  63.731  79.122  1.00 14.30           C  
ATOM   6705  OH  TYR D 164      -0.634  64.486  79.577  1.00 14.09           O  
HETATM 6706  N   MSE D 165       4.929  60.584  74.379  1.00  9.29           N  
HETATM 6707  CA  MSE D 165       6.079  59.980  73.708  1.00  9.80           C  
HETATM 6708  C   MSE D 165       7.358  60.054  74.558  1.00 10.18           C  
HETATM 6709  O   MSE D 165       8.228  59.183  74.457  1.00 11.21           O  
HETATM 6710  CB  MSE D 165       6.360  60.652  72.360  1.00 10.47           C  
HETATM 6711  CG  MSE D 165       5.310  60.352  71.296  1.00 12.14           C  
HETATM 6712 SE   MSE D 165       5.004  58.419  70.928  1.00 19.62          SE  
HETATM 6713  CE  MSE D 165       6.841  57.882  70.428  1.00 18.87           C  
ATOM   6714  N   GLN D 166       7.472  61.099  75.371  1.00  9.84           N  
ATOM   6715  CA  GLN D 166       8.719  61.268  76.126  1.00 11.24           C  
ATOM   6716  C   GLN D 166       8.767  60.476  77.433  1.00 10.97           C  
ATOM   6717  O   GLN D 166       9.807  60.486  78.126  1.00 11.99           O  
ATOM   6718  CB  GLN D 166       8.976  62.742  76.382  1.00 12.20           C  
ATOM   6719  CG  GLN D 166       8.047  63.343  77.391  1.00 15.16           C  
ATOM   6720  CD  GLN D 166       6.688  63.837  76.831  1.00 18.03           C  
ATOM   6721  OE1 GLN D 166       6.201  63.433  75.745  1.00 18.24           O  
ATOM   6722  NE2 GLN D 166       6.065  64.725  77.599  1.00 19.89           N  
ATOM   6723  N   VAL D 167       7.663  59.802  77.769  1.00  9.47           N  
ATOM   6724  CA  VAL D 167       7.583  59.013  79.004  1.00 10.38           C  
ATOM   6725  C   VAL D 167       7.654  57.526  78.688  1.00  9.49           C  
ATOM   6726  O   VAL D 167       6.886  57.020  77.850  1.00  9.89           O  
ATOM   6727  CB  VAL D 167       6.295  59.322  79.788  1.00  9.88           C  
ATOM   6728  CG1 VAL D 167       6.314  58.594  81.138  1.00 10.56           C  
ATOM   6729  CG2 VAL D 167       6.175  60.817  80.015  1.00 10.26           C  
ATOM   6730  N   GLU D 168       8.564  56.828  79.384  1.00  9.73           N  
ATOM   6731  CA  GLU D 168       8.658  55.372  79.269  1.00 10.22           C  
ATOM   6732  C   GLU D 168       8.413  54.800  80.644  1.00 10.75           C  
ATOM   6733  O   GLU D 168       9.067  55.197  81.607  1.00 11.52           O  
ATOM   6734  CB  GLU D 168      10.035  54.924  78.749  1.00 10.39           C  
ATOM   6735  CG  GLU D 168      10.076  53.416  78.519  1.00 13.19           C  
ATOM   6736  CD  GLU D 168      11.412  52.938  78.004  1.00 16.09           C  
ATOM   6737  OE1 GLU D 168      12.417  53.661  78.162  1.00 16.80           O  
ATOM   6738  OE2 GLU D 168      11.452  51.841  77.435  1.00 20.02           O  
ATOM   6739  N   PHE D 169       7.468  53.873  80.744  1.00 10.52           N  
ATOM   6740  CA  PHE D 169       7.292  53.103  81.963  1.00 11.37           C  
ATOM   6741  C   PHE D 169       8.430  52.095  82.098  1.00 11.26           C  
ATOM   6742  O   PHE D 169       8.793  51.408  81.134  1.00 12.32           O  
ATOM   6743  CB  PHE D 169       5.963  52.368  81.899  1.00 11.53           C  
ATOM   6744  CG  PHE D 169       5.670  51.560  83.121  1.00 11.25           C  
ATOM   6745  CD1 PHE D 169       5.398  52.164  84.343  1.00 13.99           C  
ATOM   6746  CD2 PHE D 169       5.639  50.173  83.014  1.00 14.15           C  
ATOM   6747  CE1 PHE D 169       5.117  51.361  85.465  1.00 14.82           C  
ATOM   6748  CE2 PHE D 169       5.377  49.382  84.112  1.00 15.56           C  
ATOM   6749  CZ  PHE D 169       5.093  49.974  85.328  1.00 12.79           C  
ATOM   6750  N   VAL D 170       8.982  52.009  83.309  1.00 11.29           N  
ATOM   6751  CA  VAL D 170      10.134  51.152  83.567  1.00 12.19           C  
ATOM   6752  C   VAL D 170       9.702  50.051  84.538  1.00 11.97           C  
ATOM   6753  O   VAL D 170       9.576  50.287  85.723  1.00 11.81           O  
ATOM   6754  CB  VAL D 170      11.369  51.949  84.117  1.00 12.94           C  
ATOM   6755  CG1 VAL D 170      12.564  51.009  84.307  1.00 13.43           C  
ATOM   6756  CG2 VAL D 170      11.742  53.125  83.188  1.00 13.31           C  
ATOM   6757  N   PRO D 171       9.457  48.830  84.022  1.00 12.35           N  
ATOM   6758  CA  PRO D 171       8.947  47.744  84.863  1.00 13.33           C  
ATOM   6759  C   PRO D 171      10.078  47.119  85.659  1.00 14.73           C  
ATOM   6760  O   PRO D 171      10.848  46.309  85.133  1.00 16.68           O  
ATOM   6761  CB  PRO D 171       8.348  46.768  83.834  1.00 12.94           C  
ATOM   6762  CG  PRO D 171       9.155  46.998  82.586  1.00 14.77           C  
ATOM   6763  CD  PRO D 171       9.644  48.411  82.613  1.00 12.84           C  
ATOM   6764  N   VAL D 172      10.246  47.574  86.896  1.00 14.45           N  
ATOM   6765  CA  VAL D 172      11.285  47.014  87.772  1.00 15.40           C  
ATOM   6766  C   VAL D 172      10.688  46.173  88.911  1.00 15.50           C  
ATOM   6767  O   VAL D 172      11.416  45.465  89.599  1.00 15.80           O  
ATOM   6768  CB  VAL D 172      12.240  48.091  88.358  1.00 15.91           C  
ATOM   6769  CG1 VAL D 172      13.085  48.718  87.271  1.00 19.03           C  
ATOM   6770  CG2 VAL D 172      11.502  49.169  89.106  1.00 17.25           C  
ATOM   6771  N   PHE D 173       9.366  46.274  89.113  1.00 14.44           N  
ATOM   6772  CA  PHE D 173       8.671  45.518  90.153  1.00 14.38           C  
ATOM   6773  C   PHE D 173       9.073  44.043  90.135  1.00 14.51           C  
ATOM   6774  O   PHE D 173       9.530  43.502  91.150  1.00 14.03           O  
ATOM   6775  CB  PHE D 173       7.156  45.688  89.968  1.00 13.80           C  
ATOM   6776  CG  PHE D 173       6.316  44.923  90.948  1.00 13.41           C  
ATOM   6777  CD1 PHE D 173       5.746  45.573  92.037  1.00 13.91           C  
ATOM   6778  CD2 PHE D 173       6.074  43.557  90.773  1.00 14.50           C  
ATOM   6779  CE1 PHE D 173       4.955  44.874  92.945  1.00 12.61           C  
ATOM   6780  CE2 PHE D 173       5.282  42.847  91.683  1.00 13.64           C  
ATOM   6781  CZ  PHE D 173       4.729  43.507  92.773  1.00 13.47           C  
ATOM   6782  N   ASP D 174       8.951  43.404  88.974  1.00 15.25           N  
ATOM   6783  CA  ASP D 174       9.160  41.958  88.909  1.00 16.89           C  
ATOM   6784  C   ASP D 174      10.613  41.567  89.210  1.00 17.17           C  
ATOM   6785  O   ASP D 174      10.872  40.469  89.739  1.00 18.41           O  
ATOM   6786  CB  ASP D 174       8.707  41.407  87.557  1.00 17.52           C  
ATOM   6787  CG  ASP D 174       7.181  41.476  87.359  1.00 20.84           C  
ATOM   6788  OD1 ASP D 174       6.421  41.458  88.353  1.00 21.01           O  
ATOM   6789  OD2 ASP D 174       6.733  41.500  86.187  1.00 25.45           O  
ATOM   6790  N   CYS D 175      11.552  42.467  88.913  1.00 16.47           N  
ATOM   6791  CA  CYS D 175      12.977  42.223  89.200  1.00 17.18           C  
ATOM   6792  C   CYS D 175      13.302  42.110  90.678  1.00 16.03           C  
ATOM   6793  O   CYS D 175      14.325  41.530  91.046  1.00 16.18           O  
ATOM   6794  CB  CYS D 175      13.867  43.303  88.592  1.00 17.03           C  
ATOM   6795  SG  CYS D 175      13.871  43.244  86.769  1.00 23.21           S  
ATOM   6796  N   LEU D 176      12.444  42.678  91.519  1.00 14.39           N  
ATOM   6797  CA  LEU D 176      12.709  42.741  92.954  1.00 14.81           C  
ATOM   6798  C   LEU D 176      11.884  41.728  93.737  1.00 14.85           C  
ATOM   6799  O   LEU D 176      12.066  41.589  94.941  1.00 13.22           O  
ATOM   6800  CB  LEU D 176      12.484  44.161  93.512  1.00 15.27           C  
ATOM   6801  CG  LEU D 176      13.369  45.241  92.896  1.00 16.42           C  
ATOM   6802  CD1 LEU D 176      13.071  46.558  93.595  1.00 18.29           C  
ATOM   6803  CD2 LEU D 176      14.835  44.860  92.977  1.00 19.26           C  
ATOM   6804  N   THR D 177      10.996  41.015  93.047  1.00 15.61           N  
ATOM   6805  CA  THR D 177      10.133  40.040  93.742  1.00 16.66           C  
ATOM   6806  C   THR D 177      10.777  38.673  93.875  1.00 16.27           C  
ATOM   6807  O   THR D 177      11.614  38.277  93.052  1.00 17.05           O  
ATOM   6808  CB  THR D 177       8.765  39.862  93.046  1.00 16.61           C  
ATOM   6809  OG1 THR D 177       8.970  39.475  91.681  1.00 19.87           O  
ATOM   6810  CG2 THR D 177       7.969  41.157  93.094  1.00 18.00           C  
ATOM   6811  N   ASP D 178      10.379  37.943  94.906  1.00 15.97           N  
ATOM   6812  CA  ASP D 178      10.726  36.527  94.995  1.00 15.90           C  
ATOM   6813  C   ASP D 178       9.639  35.741  94.244  1.00 16.63           C  
ATOM   6814  O   ASP D 178       8.778  36.330  93.582  1.00 16.84           O  
ATOM   6815  CB  ASP D 178      10.889  36.092  96.466  1.00 15.90           C  
ATOM   6816  CG  ASP D 178       9.609  36.221  97.269  1.00 14.88           C  
ATOM   6817  OD1 ASP D 178       8.537  36.374  96.664  1.00 13.97           O  
ATOM   6818  OD2 ASP D 178       9.688  36.149  98.516  1.00 17.76           O  
ATOM   6819  N   GLN D 179       9.669  34.421  94.331  1.00 17.58           N  
ATOM   6820  CA  GLN D 179       8.711  33.623  93.576  1.00 17.76           C  
ATOM   6821  C   GLN D 179       7.281  33.678  94.131  1.00 18.04           C  
ATOM   6822  O   GLN D 179       6.351  33.216  93.471  1.00 18.44           O  
ATOM   6823  CB  GLN D 179       9.201  32.175  93.458  1.00 18.36           C  
ATOM   6824  CG  GLN D 179      10.653  32.074  92.960  1.00 18.85           C  
ATOM   6825  CD  GLN D 179      10.892  32.838  91.673  1.00 21.51           C  
ATOM   6826  OE1 GLN D 179      11.794  33.687  91.599  1.00 21.21           O  
ATOM   6827  NE2 GLN D 179      10.077  32.553  90.652  1.00 20.62           N  
ATOM   6828  N   ALA D 180       7.114  34.249  95.320  1.00 17.87           N  
ATOM   6829  CA  ALA D 180       5.793  34.465  95.925  1.00 17.76           C  
ATOM   6830  C   ALA D 180       5.250  35.864  95.619  1.00 18.30           C  
ATOM   6831  O   ALA D 180       4.176  36.243  96.096  1.00 19.12           O  
ATOM   6832  CB  ALA D 180       5.854  34.251  97.420  1.00 17.92           C  
ATOM   6833  N   GLY D 181       6.001  36.626  94.838  1.00 17.54           N  
ATOM   6834  CA  GLY D 181       5.564  37.943  94.404  1.00 17.99           C  
ATOM   6835  C   GLY D 181       5.767  39.001  95.475  1.00 18.17           C  
ATOM   6836  O   GLY D 181       5.158  40.085  95.405  1.00 19.30           O  
ATOM   6837  N   GLN D 182       6.606  38.686  96.462  1.00 16.92           N  
ATOM   6838  CA  GLN D 182       6.974  39.628  97.523  1.00 16.53           C  
ATOM   6839  C   GLN D 182       8.350  40.243  97.251  1.00 14.95           C  
ATOM   6840  O   GLN D 182       9.221  39.604  96.665  1.00 14.77           O  
ATOM   6841  CB  GLN D 182       7.048  38.913  98.882  1.00 16.83           C  
ATOM   6842  CG  GLN D 182       5.822  38.088  99.272  1.00 21.18           C  
ATOM   6843  CD  GLN D 182       4.589  38.948  99.509  1.00 24.70           C  
ATOM   6844  OE1 GLN D 182       4.681  40.046 100.063  1.00 25.03           O  
ATOM   6845  NE2 GLN D 182       3.422  38.447  99.089  1.00 27.44           N  
ATOM   6846  N   LEU D 183       8.575  41.464  97.727  1.00 14.18           N  
ATOM   6847  CA  LEU D 183       9.925  42.002  97.730  1.00 13.30           C  
ATOM   6848  C   LEU D 183      10.849  40.989  98.430  1.00 13.57           C  
ATOM   6849  O   LEU D 183      10.599  40.623  99.579  1.00 13.23           O  
ATOM   6850  CB  LEU D 183       9.958  43.318  98.500  1.00 13.06           C  
ATOM   6851  CG  LEU D 183      11.293  44.024  98.695  1.00 12.23           C  
ATOM   6852  CD1 LEU D 183      11.895  44.386  97.363  1.00 11.92           C  
ATOM   6853  CD2 LEU D 183      11.023  45.276  99.508  1.00 11.51           C  
ATOM   6854  N   LYS D 184      11.908  40.548  97.740  1.00 13.60           N  
ATOM   6855  CA  LYS D 184      12.799  39.501  98.283  1.00 14.99           C  
ATOM   6856  C   LYS D 184      13.325  39.883  99.651  1.00 14.17           C  
ATOM   6857  O   LYS D 184      13.742  41.039  99.861  1.00 13.82           O  
ATOM   6858  CB  LYS D 184      13.993  39.210  97.347  1.00 15.45           C  
ATOM   6859  CG  LYS D 184      13.630  38.582  96.014  1.00 19.25           C  
ATOM   6860  CD  LYS D 184      14.835  38.274  95.107  1.00 19.76           C  
ATOM   6861  CE  LYS D 184      15.982  37.611  95.861  1.00 23.83           C  
ATOM   6862  NZ  LYS D 184      17.066  37.054  94.942  1.00 25.84           N  
ATOM   6863  N   LYS D 185      13.343  38.919 100.570  1.00 13.88           N  
ATOM   6864  CA  LYS D 185      13.853  39.203 101.901  1.00 13.38           C  
ATOM   6865  C   LYS D 185      15.255  39.833 101.842  1.00 13.09           C  
ATOM   6866  O   LYS D 185      15.532  40.822 102.535  1.00 13.55           O  
ATOM   6867  CB  LYS D 185      13.828  37.942 102.788  1.00 13.59           C  
ATOM   6868  CG  LYS D 185      14.055  38.256 104.265  1.00 17.12           C  
ATOM   6869  CD  LYS D 185      13.240  37.351 105.174  1.00 23.52           C  
ATOM   6870  CE  LYS D 185      13.693  37.478 106.605  1.00 26.36           C  
ATOM   6871  NZ  LYS D 185      14.957  36.703 106.805  1.00 29.97           N  
ATOM   6872  N   GLU D 186      16.136  39.297 100.991  1.00 12.98           N  
ATOM   6873  CA  GLU D 186      17.491  39.834 100.928  1.00 12.85           C  
ATOM   6874  C   GLU D 186      17.558  41.259 100.403  1.00 11.53           C  
ATOM   6875  O   GLU D 186      18.555  41.923 100.616  1.00 11.20           O  
ATOM   6876  CB  GLU D 186      18.445  38.964 100.116  1.00 14.18           C  
ATOM   6877  CG  GLU D 186      18.150  38.873  98.674  1.00 17.60           C  
ATOM   6878  CD  GLU D 186      19.375  38.483  97.838  1.00 22.55           C  
ATOM   6879  OE1 GLU D 186      20.484  39.056  98.041  1.00 25.81           O  
ATOM   6880  OE2 GLU D 186      19.222  37.586  96.980  1.00 23.51           O  
ATOM   6881  N   TYR D 187      16.503  41.703  99.719  1.00 10.31           N  
ATOM   6882  CA  TYR D 187      16.486  43.012  99.061  1.00 10.70           C  
ATOM   6883  C   TYR D 187      15.922  44.113  99.947  1.00 10.49           C  
ATOM   6884  O   TYR D 187      15.879  45.261  99.514  1.00  9.38           O  
ATOM   6885  CB  TYR D 187      15.671  42.924  97.747  1.00 11.05           C  
ATOM   6886  CG  TYR D 187      16.301  42.151  96.614  1.00 11.79           C  
ATOM   6887  CD1 TYR D 187      17.608  41.691  96.686  1.00 12.76           C  
ATOM   6888  CD2 TYR D 187      15.565  41.874  95.466  1.00 13.62           C  
ATOM   6889  CE1 TYR D 187      18.181  40.984  95.629  1.00 10.30           C  
ATOM   6890  CE2 TYR D 187      16.114  41.199  94.422  1.00 13.39           C  
ATOM   6891  CZ  TYR D 187      17.412  40.744  94.508  1.00 12.37           C  
ATOM   6892  OH  TYR D 187      17.909  40.063  93.411  1.00 13.77           O  
ATOM   6893  N   THR D 188      15.488  43.754 101.154  1.00 10.19           N  
ATOM   6894  CA  THR D 188      14.809  44.714 102.034  1.00 10.60           C  
ATOM   6895  C   THR D 188      15.433  44.831 103.432  1.00 11.59           C  
ATOM   6896  O   THR D 188      16.000  43.860 103.941  1.00 12.60           O  
ATOM   6897  CB  THR D 188      13.289  44.437 102.119  1.00 11.85           C  
ATOM   6898  OG1 THR D 188      12.627  45.548 102.732  1.00 11.63           O  
ATOM   6899  CG2 THR D 188      12.991  43.187 102.925  1.00 12.07           C  
ATOM   6900  N   THR D 189      15.343  46.025 104.015  1.00 11.79           N  
ATOM   6901  CA  THR D 189      15.706  46.211 105.422  1.00 12.79           C  
ATOM   6902  C   THR D 189      14.499  46.017 106.330  1.00 13.71           C  
ATOM   6903  O   THR D 189      14.593  45.298 107.317  1.00 15.12           O  
ATOM   6904  CB  THR D 189      16.310  47.601 105.679  1.00 12.61           C  
ATOM   6905  OG1 THR D 189      15.423  48.588 105.163  1.00 13.97           O  
ATOM   6906  CG2 THR D 189      17.651  47.727 104.981  1.00 14.60           C  
ATOM   6907  N   ASP D 190      13.363  46.620 105.961  1.00 13.68           N  
ATOM   6908  CA  ASP D 190      12.181  46.650 106.826  1.00 13.89           C  
ATOM   6909  C   ASP D 190      10.870  46.268 106.127  1.00 13.60           C  
ATOM   6910  O   ASP D 190       9.781  46.465 106.688  1.00 14.14           O  
ATOM   6911  CB  ASP D 190      12.029  48.038 107.437  1.00 14.19           C  
ATOM   6912  CG  ASP D 190      11.808  49.113 106.396  1.00 16.01           C  
ATOM   6913  OD1 ASP D 190      11.615  48.772 105.204  1.00 12.19           O  
ATOM   6914  OD2 ASP D 190      11.831  50.304 106.764  1.00 16.56           O  
ATOM   6915  N   GLY D 191      10.977  45.694 104.936  1.00 12.21           N  
ATOM   6916  CA  GLY D 191       9.796  45.267 104.178  1.00 11.66           C  
ATOM   6917  C   GLY D 191       9.360  46.252 103.108  1.00 11.38           C  
ATOM   6918  O   GLY D 191       8.622  45.876 102.187  1.00 12.10           O  
ATOM   6919  N   LEU D 192       9.828  47.496 103.248  1.00 11.42           N  
ATOM   6920  CA  LEU D 192       9.511  48.603 102.335  1.00 11.49           C  
ATOM   6921  C   LEU D 192      10.785  49.204 101.709  1.00 11.31           C  
ATOM   6922  O   LEU D 192      10.891  49.329 100.494  1.00 12.19           O  
ATOM   6923  CB  LEU D 192       8.725  49.670 103.104  1.00 12.10           C  
ATOM   6924  CG  LEU D 192       8.455  51.001 102.412  1.00 14.78           C  
ATOM   6925  CD1 LEU D 192       7.564  50.818 101.200  1.00 14.69           C  
ATOM   6926  CD2 LEU D 192       7.823  51.936 103.429  1.00 17.75           C  
ATOM   6927  N   HIS D 193      11.730  49.617 102.548  1.00 10.48           N  
ATOM   6928  CA  HIS D 193      13.000  50.159 102.079  1.00 10.52           C  
ATOM   6929  C   HIS D 193      13.968  49.078 101.615  1.00 10.10           C  
ATOM   6930  O   HIS D 193      13.878  47.901 102.037  1.00 10.17           O  
ATOM   6931  CB  HIS D 193      13.648  50.960 103.208  1.00 11.71           C  
ATOM   6932  CG  HIS D 193      12.854  52.165 103.584  1.00 14.02           C  
ATOM   6933  ND1 HIS D 193      11.942  52.156 104.619  1.00 17.25           N  
ATOM   6934  CD2 HIS D 193      12.790  53.397 103.023  1.00 17.78           C  
ATOM   6935  CE1 HIS D 193      11.360  53.341 104.688  1.00 18.49           C  
ATOM   6936  NE2 HIS D 193      11.860  54.113 103.739  1.00 19.90           N  
ATOM   6937  N   LEU D 194      14.887  49.477 100.747  1.00  9.78           N  
ATOM   6938  CA  LEU D 194      15.783  48.517 100.140  1.00 10.45           C  
ATOM   6939  C   LEU D 194      17.070  48.358 100.920  1.00 10.68           C  
ATOM   6940  O   LEU D 194      17.620  49.348 101.440  1.00 10.61           O  
ATOM   6941  CB  LEU D 194      16.112  48.943  98.711  1.00 10.45           C  
ATOM   6942  CG  LEU D 194      14.937  49.001  97.736  1.00 10.21           C  
ATOM   6943  CD1 LEU D 194      15.462  49.271  96.334  1.00 11.60           C  
ATOM   6944  CD2 LEU D 194      14.078  47.703  97.703  1.00 10.12           C  
ATOM   6945  N   SER D 195      17.552  47.120 100.992  1.00 10.07           N  
ATOM   6946  CA  SER D 195      18.927  46.854 101.452  1.00  9.98           C  
ATOM   6947  C   SER D 195      19.913  47.182 100.328  1.00 10.09           C  
ATOM   6948  O   SER D 195      19.522  47.446  99.188  1.00 10.24           O  
ATOM   6949  CB  SER D 195      19.046  45.366 101.781  1.00 10.75           C  
ATOM   6950  OG  SER D 195      18.897  44.632 100.562  1.00 10.90           O  
ATOM   6951  N   ILE D 196      21.209  47.112 100.612  1.00  9.73           N  
ATOM   6952  CA  ILE D 196      22.183  47.290  99.552  1.00  9.72           C  
ATOM   6953  C   ILE D 196      22.036  46.232  98.426  1.00  9.52           C  
ATOM   6954  O   ILE D 196      22.144  46.575  97.234  1.00 10.32           O  
ATOM   6955  CB  ILE D 196      23.622  47.409 100.130  1.00  9.83           C  
ATOM   6956  CG1 ILE D 196      23.787  48.739 100.890  1.00 11.39           C  
ATOM   6957  CG2 ILE D 196      24.656  47.259  99.022  1.00 11.22           C  
ATOM   6958  CD1 ILE D 196      23.455  49.978 100.040  1.00 10.68           C  
ATOM   6959  N   ALA D 197      21.772  44.973  98.799  1.00  9.78           N  
ATOM   6960  CA  ALA D 197      21.509  43.944  97.759  1.00  9.40           C  
ATOM   6961  C   ALA D 197      20.301  44.339  96.910  1.00  9.41           C  
ATOM   6962  O   ALA D 197      20.314  44.155  95.693  1.00  9.97           O  
ATOM   6963  CB  ALA D 197      21.266  42.577  98.386  1.00 11.11           C  
ATOM   6964  N   GLY D 198      19.269  44.888  97.553  1.00  9.20           N  
ATOM   6965  CA  GLY D 198      18.089  45.392  96.834  1.00 10.43           C  
ATOM   6966  C   GLY D 198      18.438  46.506  95.863  1.00 10.36           C  
ATOM   6967  O   GLY D 198      18.047  46.481  94.694  1.00 10.69           O  
ATOM   6968  N   TYR D 199      19.201  47.490  96.341  1.00 10.46           N  
ATOM   6969  CA  TYR D 199      19.643  48.564  95.440  1.00  9.17           C  
ATOM   6970  C   TYR D 199      20.540  48.051  94.311  1.00  9.59           C  
ATOM   6971  O   TYR D 199      20.507  48.557  93.179  1.00  9.90           O  
ATOM   6972  CB  TYR D 199      20.363  49.662  96.230  1.00 10.21           C  
ATOM   6973  CG  TYR D 199      19.444  50.646  96.919  1.00  8.65           C  
ATOM   6974  CD1 TYR D 199      18.664  51.533  96.158  1.00 10.62           C  
ATOM   6975  CD2 TYR D 199      19.432  50.771  98.310  1.00  9.07           C  
ATOM   6976  CE1 TYR D 199      17.835  52.465  96.757  1.00  9.83           C  
ATOM   6977  CE2 TYR D 199      18.602  51.717  98.936  1.00  9.23           C  
ATOM   6978  CZ  TYR D 199      17.826  52.571  98.141  1.00 10.47           C  
ATOM   6979  OH  TYR D 199      17.013  53.497  98.734  1.00 11.68           O  
ATOM   6980  N   GLN D 200      21.349  47.046  94.595  1.00  9.03           N  
ATOM   6981  CA  GLN D 200      22.213  46.515  93.538  1.00  9.96           C  
ATOM   6982  C   GLN D 200      21.331  45.895  92.450  1.00 10.09           C  
ATOM   6983  O   GLN D 200      21.585  46.050  91.247  1.00 10.91           O  
ATOM   6984  CB  GLN D 200      23.177  45.469  94.123  1.00 10.32           C  
ATOM   6985  CG  GLN D 200      24.076  44.873  93.060  1.00 12.23           C  
ATOM   6986  CD  GLN D 200      25.002  43.843  93.631  1.00 12.88           C  
ATOM   6987  OE1 GLN D 200      24.563  42.940  94.355  1.00 13.86           O  
ATOM   6988  NE2 GLN D 200      26.294  43.942  93.277  1.00 14.52           N  
ATOM   6989  N   ALA D 201      20.311  45.163  92.900  1.00 10.48           N  
ATOM   6990  CA  ALA D 201      19.406  44.480  91.949  1.00 10.46           C  
ATOM   6991  C   ALA D 201      18.607  45.505  91.147  1.00 11.67           C  
ATOM   6992  O   ALA D 201      18.428  45.349  89.930  1.00 12.37           O  
ATOM   6993  CB  ALA D 201      18.464  43.560  92.705  1.00 10.71           C  
ATOM   6994  N   LEU D 202      18.125  46.548  91.825  1.00 11.30           N  
ATOM   6995  CA  LEU D 202      17.406  47.636  91.154  1.00 11.78           C  
ATOM   6996  C   LEU D 202      18.295  48.303  90.112  1.00 12.23           C  
ATOM   6997  O   LEU D 202      17.867  48.568  88.990  1.00 13.35           O  
ATOM   6998  CB  LEU D 202      16.904  48.670  92.184  1.00 10.58           C  
ATOM   6999  CG  LEU D 202      16.141  49.890  91.621  1.00 12.09           C  
ATOM   7000  CD1 LEU D 202      14.942  49.476  90.728  1.00 12.66           C  
ATOM   7001  CD2 LEU D 202      15.709  50.807  92.756  1.00 13.99           C  
ATOM   7002  N   SER D 203      19.558  48.538  90.470  1.00 11.10           N  
ATOM   7003  CA  SER D 203      20.487  49.182  89.562  1.00 12.10           C  
ATOM   7004  C   SER D 203      20.751  48.347  88.305  1.00 12.33           C  
ATOM   7005  O   SER D 203      20.831  48.877  87.182  1.00 12.61           O  
ATOM   7006  CB  SER D 203      21.795  49.461  90.303  1.00 11.44           C  
ATOM   7007  OG  SER D 203      21.562  50.332  91.385  1.00 12.24           O  
ATOM   7008  N   LYS D 204      20.873  47.037  88.489  1.00 12.63           N  
ATOM   7009  CA  LYS D 204      21.084  46.151  87.349  1.00 13.66           C  
ATOM   7010  C   LYS D 204      19.865  46.216  86.406  1.00 13.20           C  
ATOM   7011  O   LYS D 204      20.029  46.265  85.182  1.00 14.40           O  
ATOM   7012  CB  LYS D 204      21.297  44.727  87.849  1.00 14.43           C  
ATOM   7013  CG  LYS D 204      21.540  43.691  86.766  1.00 17.45           C  
ATOM   7014  CD  LYS D 204      21.868  42.354  87.439  1.00 19.38           C  
ATOM   7015  CE  LYS D 204      21.376  41.168  86.631  1.00 24.17           C  
ATOM   7016  NZ  LYS D 204      22.399  40.626  85.699  1.00 29.74           N  
ATOM   7017  N   SER D 205      18.662  46.269  86.971  1.00 13.24           N  
ATOM   7018  CA  SER D 205      17.470  46.357  86.125  1.00 15.41           C  
ATOM   7019  C   SER D 205      17.353  47.715  85.436  1.00 14.76           C  
ATOM   7020  O   SER D 205      16.812  47.778  84.331  1.00 15.80           O  
ATOM   7021  CB  SER D 205      16.207  46.070  86.922  1.00 15.95           C  
ATOM   7022  OG  SER D 205      15.939  47.116  87.824  1.00 22.92           O  
ATOM   7023  N   LEU D 206      17.871  48.789  86.059  1.00 13.53           N  
ATOM   7024  CA  LEU D 206      17.742  50.155  85.489  1.00 13.31           C  
ATOM   7025  C   LEU D 206      18.824  50.540  84.490  1.00 14.99           C  
ATOM   7026  O   LEU D 206      18.641  51.503  83.741  1.00 15.54           O  
ATOM   7027  CB  LEU D 206      17.751  51.229  86.594  1.00 12.69           C  
ATOM   7028  CG  LEU D 206      16.544  51.239  87.521  1.00 12.82           C  
ATOM   7029  CD1 LEU D 206      16.770  52.262  88.642  1.00 14.47           C  
ATOM   7030  CD2 LEU D 206      15.258  51.553  86.743  1.00 13.50           C  
ATOM   7031  N   LYS D 207      19.951  49.838  84.494  1.00 15.19           N  
ATOM   7032  CA  LYS D 207      21.124  50.323  83.772  1.00 17.07           C  
ATOM   7033  C   LYS D 207      20.874  50.683  82.303  1.00 16.73           C  
ATOM   7034  O   LYS D 207      21.275  51.750  81.841  1.00 16.85           O  
ATOM   7035  CB  LYS D 207      22.271  49.313  83.887  1.00 17.99           C  
ATOM   7036  CG  LYS D 207      23.506  49.753  83.094  1.00 21.43           C  
ATOM   7037  CD  LYS D 207      24.629  48.748  83.197  1.00 27.82           C  
ATOM   7038  CE  LYS D 207      25.999  49.401  82.935  1.00 31.97           C  
ATOM   7039  NZ  LYS D 207      25.907  50.517  81.962  1.00 34.15           N  
ATOM   7040  N   ASP D 208      20.200  49.800  81.571  1.00 16.20           N  
ATOM   7041  CA  ASP D 208      19.962  50.030  80.149  1.00 17.08           C  
ATOM   7042  C   ASP D 208      19.124  51.259  79.903  1.00 16.83           C  
ATOM   7043  O   ASP D 208      19.236  51.895  78.837  1.00 17.34           O  
ATOM   7044  CB  ASP D 208      19.284  48.831  79.492  1.00 18.11           C  
ATOM   7045  CG  ASP D 208      20.255  47.691  79.196  1.00 20.61           C  
ATOM   7046  OD1 ASP D 208      21.427  47.710  79.650  1.00 23.90           O  
ATOM   7047  OD2 ASP D 208      19.829  46.743  78.505  1.00 27.34           O  
ATOM   7048  N   TYR D 209      18.267  51.592  80.871  1.00 14.16           N  
ATOM   7049  CA  TYR D 209      17.364  52.736  80.746  1.00 13.99           C  
ATOM   7050  C   TYR D 209      18.081  54.058  80.946  1.00 14.10           C  
ATOM   7051  O   TYR D 209      17.510  55.118  80.665  1.00 13.69           O  
ATOM   7052  CB  TYR D 209      16.180  52.642  81.735  1.00 13.90           C  
ATOM   7053  CG  TYR D 209      15.268  51.483  81.485  1.00 15.16           C  
ATOM   7054  CD1 TYR D 209      14.165  51.626  80.634  1.00 16.32           C  
ATOM   7055  CD2 TYR D 209      15.499  50.245  82.083  1.00 13.82           C  
ATOM   7056  CE1 TYR D 209      13.305  50.558  80.395  1.00 15.91           C  
ATOM   7057  CE2 TYR D 209      14.638  49.165  81.841  1.00 14.43           C  
ATOM   7058  CZ  TYR D 209      13.547  49.341  80.993  1.00 16.03           C  
ATOM   7059  OH  TYR D 209      12.681  48.272  80.748  1.00 16.50           O  
ATOM   7060  N   LEU D 210      19.325  54.004  81.432  1.00 14.75           N  
ATOM   7061  CA  LEU D 210      20.140  55.214  81.568  1.00 15.38           C  
ATOM   7062  C   LEU D 210      20.605  55.787  80.219  1.00 15.24           C  
ATOM   7063  O   LEU D 210      21.052  56.952  80.162  1.00 14.10           O  
ATOM   7064  CB  LEU D 210      21.380  54.928  82.410  1.00 15.58           C  
ATOM   7065  CG  LEU D 210      21.122  54.624  83.881  1.00 16.12           C  
ATOM   7066  CD1 LEU D 210      22.436  54.156  84.471  1.00 18.80           C  
ATOM   7067  CD2 LEU D 210      20.603  55.827  84.621  1.00 18.09           C  
ATOM   7068  N   TYR D 211      20.510  54.982  79.153  1.00 16.51           N  
ATOM   7069  CA  TYR D 211      20.998  55.362  77.839  1.00 18.32           C  
ATOM   7070  C   TYR D 211      19.853  55.550  76.844  1.00 19.89           C  
ATOM   7071  O   TYR D 211      19.015  54.688  76.699  1.00 22.14           O  
ATOM   7072  CB  TYR D 211      22.025  54.328  77.338  1.00 17.43           C  
ATOM   7073  CG  TYR D 211      23.319  54.436  78.103  1.00 17.58           C  
ATOM   7074  CD1 TYR D 211      24.362  55.233  77.626  1.00 17.04           C  
ATOM   7075  CD2 TYR D 211      23.502  53.753  79.304  1.00 15.69           C  
ATOM   7076  CE1 TYR D 211      25.531  55.356  78.320  1.00 17.86           C  
ATOM   7077  CE2 TYR D 211      24.683  53.883  80.019  1.00 17.85           C  
ATOM   7078  CZ  TYR D 211      25.679  54.690  79.522  1.00 16.73           C  
ATOM   7079  OH  TYR D 211      26.871  54.815  80.188  1.00 19.52           O  
ATOM   7080  OXT TYR D 211      19.754  56.574  76.153  1.00 23.49           O  
TER    7081      TYR D 211                                                      
END
MOLECULE T0448.pdb
ATOM      1  N   HIS    18      27.685  52.788  75.703  1.00 41.21           N  
ATOM      2  CA  HIS    18      26.871  52.722  76.961  1.00 41.43           C  
ATOM      3  C   HIS    18      26.227  54.054  77.296  1.00 40.12           C  
ATOM      4  O   HIS    18      26.808  55.120  77.043  1.00 40.01           O  
ATOM      5  CB  HIS    18      27.711  52.238  78.138  1.00 41.83           C  
ATOM      6  CG  HIS    18      27.566  50.775  78.409  1.00 44.72           C  
ATOM      7  ND1 HIS    18      26.771  50.282  79.424  1.00 45.86           N  
ATOM      8  CD2 HIS    18      28.092  49.695  77.780  1.00 46.55           C  
ATOM      9  CE1 HIS    18      26.823  48.960  79.417  1.00 47.71           C  
ATOM     10  NE2 HIS    18      27.619  48.578  78.431  1.00 48.04           N  
ATOM     11  N   VAL    19      25.021  53.989  77.847  1.00 38.67           N  
ATOM     12  CA  VAL    19      24.290  55.202  78.188  1.00 37.65           C  
ATOM     13  C   VAL    19      24.833  55.783  79.492  1.00 37.04           C  
ATOM     14  O   VAL    19      24.910  55.081  80.509  1.00 36.61           O  
ATOM     15  CB  VAL    19      22.763  54.963  78.254  1.00 37.68           C  
ATOM     16  CG1 VAL    19      22.025  56.258  78.522  1.00 37.64           C  
ATOM     17  CG2 VAL    19      22.274  54.389  76.951  1.00 37.51           C  
ATOM     18  N   SER    20      25.250  57.050  79.429  1.00 36.05           N  
ATOM     19  CA  SER    20      25.633  57.822  80.614  1.00 35.51           C  
ATOM     20  C   SER    20      25.184  59.273  80.456  1.00 34.81           C  
ATOM     21  O   SER    20      24.945  59.730  79.340  1.00 34.96           O  
ATOM     22  CB  SER    20      27.148  57.744  80.869  1.00 35.61           C  
ATOM     23  OG  SER    20      27.882  58.301  79.791  1.00 36.74           O  
ATOM     24  N   PHE    21      25.049  59.981  81.577  1.00 33.82           N  
ATOM     25  CA  PHE    21      24.671  61.401  81.578  1.00 32.76           C  
ATOM     26  C   PHE    21      25.572  62.176  82.540  1.00 32.58           C  
ATOM     27  O   PHE    21      26.101  61.602  83.492  1.00 32.07           O  
ATOM     28  CB  PHE    21      23.208  61.574  82.000  1.00 32.55           C  
ATOM     29  CG  PHE    21      22.244  60.777  81.182  1.00 30.95           C  
ATOM     30  CD1 PHE    21      21.796  61.255  79.952  1.00 30.03           C  
ATOM     31  CD2 PHE    21      21.791  59.541  81.634  1.00 29.40           C  
ATOM     32  CE1 PHE    21      20.911  60.519  79.190  1.00 28.76           C  
ATOM     33  CE2 PHE    21      20.901  58.798  80.887  1.00 27.54           C  
ATOM     34  CZ  PHE    21      20.455  59.282  79.662  1.00 28.97           C  
ATOM     35  N   LYS    22      25.733  63.474  82.303  1.00 32.29           N  
ATOM     36  CA  LYS    22      26.644  64.287  83.117  1.00 32.59           C  
ATOM     37  C   LYS    22      25.942  65.029  84.252  1.00 31.53           C  
ATOM     38  O   LYS    22      26.559  65.314  85.262  1.00 31.60           O  
ATOM     39  CB  LYS    22      27.414  65.283  82.240  1.00 33.38           C  
ATOM     40  CG  LYS    22      28.167  64.630  81.063  1.00 36.28           C  
ATOM     41  CD  LYS    22      28.756  65.665  80.064  1.00 41.10           C  
ATOM     42  CE  LYS    22      27.696  66.600  79.430  1.00 43.45           C  
ATOM     43  NZ  LYS    22      26.456  65.920  78.927  1.00 44.22           N  
ATOM     44  N   ARG    23      24.658  65.339  84.076  1.00 30.84           N  
ATOM     45  CA  ARG    23      23.893  66.137  85.034  1.00 29.80           C  
ATOM     46  C   ARG    23      22.512  65.539  85.307  1.00 28.82           C  
ATOM     47  O   ARG    23      21.483  66.188  85.044  1.00 28.14           O  
ATOM     48  CB  ARG    23      23.754  67.585  84.535  1.00 29.83           C  
ATOM     49  CG  ARG    23      25.044  68.408  84.619  1.00 31.91           C  
ATOM     50  CD  ARG    23      24.927  69.780  83.939  1.00 34.60           C  
ATOM     51  NE  ARG    23      24.241  69.741  82.644  1.00 34.98           N  
ATOM     52  CZ  ARG    23      24.816  69.419  81.488  1.00 35.68           C  
ATOM     53  NH1 ARG    23      26.108  69.096  81.437  1.00 36.63           N  
ATOM     54  NH2 ARG    23      24.092  69.415  80.377  1.00 34.90           N  
ATOM     55  N   PRO    24      22.475  64.298  85.843  1.00 28.01           N  
ATOM     56  CA  PRO    24      21.173  63.675  86.112  1.00 26.81           C  
ATOM     57  C   PRO    24      20.454  64.336  87.280  1.00 26.25           C  
ATOM     58  O   PRO    24      21.098  64.878  88.185  1.00 26.38           O  
ATOM     59  CB  PRO    24      21.540  62.244  86.486  1.00 26.52           C  
ATOM     60  CG  PRO    24      22.928  62.347  87.053  1.00 27.98           C  
ATOM     61  CD  PRO    24      23.596  63.425  86.241  1.00 27.92           C  
ATOM     62  N   ALA    25      19.128  64.286  87.259  1.00 25.14           N  
ATOM     63  CA  ALA    25      18.329  64.744  88.384  1.00 24.40           C  
ATOM     64  C   ALA    25      17.393  63.606  88.793  1.00 23.83           C  
ATOM     65  O   ALA    25      16.708  63.019  87.961  1.00 23.26           O  
ATOM     66  CB  ALA    25      17.545  65.983  88.006  1.00 24.05           C  
ATOM     67  N   TRP    26      17.362  63.320  90.084  1.00 23.39           N  
ATOM     68  CA  TRP    26      16.657  62.161  90.619  1.00 22.89           C  
ATOM     69  C   TRP    26      15.526  62.610  91.531  1.00 23.00           C  
ATOM     70  O   TRP    26      15.763  63.070  92.645  1.00 22.42           O  
ATOM     71  CB  TRP    26      17.648  61.285  91.385  1.00 22.58           C  
ATOM     72  CG  TRP    26      18.888  60.936  90.577  1.00 22.78           C  
ATOM     73  CD1 TRP    26      20.090  61.587  90.600  1.00 22.03           C  
ATOM     74  CD2 TRP    26      19.039  59.851  89.648  1.00 22.77           C  
ATOM     75  NE1 TRP    26      20.982  60.975  89.749  1.00 22.85           N  
ATOM     76  CE2 TRP    26      20.365  59.909  89.148  1.00 22.44           C  
ATOM     77  CE3 TRP    26      18.184  58.839  89.184  1.00 23.04           C  
ATOM     78  CZ2 TRP    26      20.854  58.999  88.202  1.00 22.34           C  
ATOM     79  CZ3 TRP    26      18.681  57.918  88.240  1.00 22.75           C  
ATOM     80  CH2 TRP    26      19.998  58.012  87.764  1.00 23.27           C  
ATOM     81  N   LEU    27      14.294  62.499  91.042  1.00 23.34           N  
ATOM     82  CA  LEU    27      13.120  62.903  91.815  1.00 23.83           C  
ATOM     83  C   LEU    27      12.437  61.678  92.396  1.00 24.35           C  
ATOM     84  O   LEU    27      12.045  60.781  91.655  1.00 25.05           O  
ATOM     85  CB  LEU    27      12.155  63.699  90.927  1.00 23.42           C  
ATOM     86  CG  LEU    27      10.837  64.216  91.515  1.00 23.67           C  
ATOM     87  CD1 LEU    27      11.066  65.257  92.604  1.00 22.91           C  
ATOM     88  CD2 LEU    27       9.924  64.767  90.401  1.00 21.20           C  
ATOM     89  N   GLY    28      12.295  61.627  93.718  1.00 25.03           N  
ATOM     90  CA  GLY    28      11.676  60.467  94.356  1.00 25.77           C  
ATOM     91  C   GLY    28      11.395  60.552  95.842  1.00 26.64           C  
ATOM     92  O   GLY    28      11.275  61.624  96.406  1.00 25.97           O  
ATOM     93  N   ASP    29      11.284  59.384  96.466  1.00 28.49           N  
ATOM     94  CA  ASP    29      10.974  59.265  97.882  1.00 29.77           C  
ATOM     95  C   ASP    29      12.219  58.817  98.658  1.00 30.48           C  
ATOM     96  O   ASP    29      13.328  59.228  98.317  1.00 30.51           O  
ATOM     97  CB  ASP    29       9.754  58.355  98.105  1.00 30.18           C  
ATOM     98  CG  ASP    29       9.797  57.066  97.260  1.00 33.72           C  
ATOM     99  OD1 ASP    29      10.830  56.346  97.285  1.00 36.14           O  
ATOM    100  OD2 ASP    29       8.783  56.763  96.575  1.00 36.24           O  
ATOM    101  N   SER    30      12.046  58.000  99.695  1.00 31.43           N  
ATOM    102  CA  SER    30      13.166  57.587 100.544  1.00 33.16           C  
ATOM    103  C   SER    30      14.190  56.666  99.865  1.00 33.73           C  
ATOM    104  O   SER    30      15.362  56.612 100.274  1.00 34.31           O  
ATOM    105  CB  SER    30      12.647  56.888 101.788  1.00 33.25           C  
ATOM    106  OG  SER    30      13.746  56.515 102.599  1.00 36.86           O  
ATOM    107  N   ILE    31      13.735  55.924  98.858  1.00 33.87           N  
ATOM    108  CA  ILE    31      14.590  55.035  98.080  1.00 34.01           C  
ATOM    109  C   ILE    31      15.609  55.854  97.265  1.00 34.34           C  
ATOM    110  O   ILE    31      16.707  55.393  96.998  1.00 34.09           O  
ATOM    111  CB  ILE    31      13.721  54.107  97.191  1.00 34.15           C  
ATOM    112  CG1 ILE    31      12.685  53.376  98.073  1.00 34.63           C  
ATOM    113  CG2 ILE    31      14.585  53.116  96.401  1.00 33.63           C  
ATOM    114  CD1 ILE    31      11.599  52.598  97.314  1.00 34.39           C  
ATOM    115  N   THR    32      15.230  57.080  96.908  1.00 35.10           N  
ATOM    116  CA  THR    32      16.104  58.053  96.256  1.00 35.64           C  
ATOM    117  C   THR    32      16.787  59.008  97.265  1.00 36.40           C  
ATOM    118  O   THR    32      17.926  59.400  97.066  1.00 36.33           O  
ATOM    119  CB  THR    32      15.301  58.863  95.205  1.00 35.36           C  
ATOM    120  OG1 THR    32      14.736  57.967  94.245  1.00 35.14           O  
ATOM    121  CG2 THR    32      16.179  59.860  94.465  1.00 35.65           C  
ATOM    122  N   ALA    33      16.093  59.376  98.341  1.00 37.68           N  
ATOM    123  CA  ALA    33      16.599  60.379  99.303  1.00 39.10           C  
ATOM    124  C   ALA    33      17.913  59.982  99.970  1.00 40.50           C  
ATOM    125  O   ALA    33      18.104  58.817 100.331  1.00 40.58           O  
ATOM    126  CB  ALA    33      15.558  60.678 100.361  1.00 38.69           C  
ATOM    127  N   ASN    34      18.807  60.955 100.136  1.00 42.05           N  
ATOM    128  CA  ASN    34      20.100  60.724 100.790  1.00 43.80           C  
ATOM    129  C   ASN    34      19.950  60.209 102.241  1.00 44.53           C  
ATOM    130  O   ASN    34      20.752  59.393 102.699  1.00 44.85           O  
ATOM    131  CB  ASN    34      20.966  61.996 100.723  1.00 44.06           C  
ATOM    132  CG  ASN    34      22.341  61.827 101.382  1.00 45.83           C  
ATOM    133  OD1 ASN    34      22.997  60.787 101.248  1.00 47.04           O  
ATOM    134  ND2 ASN    34      22.783  62.867 102.096  1.00 47.28           N  
ATOM    135  N   ASN    35      18.898  60.653 102.928  1.00 45.30           N  
ATOM    136  CA  ASN    35      18.630  60.280 104.324  1.00 46.16           C  
ATOM    137  C   ASN    35      18.279  58.796 104.595  1.00 46.10           C  
ATOM    138  O   ASN    35      17.588  58.477 105.576  1.00 46.62           O  
ATOM    139  CB  ASN    35      17.554  61.223 104.927  1.00 46.78           C  
ATOM    140  CG  ASN    35      16.165  61.100 104.245  1.00 48.37           C  
ATOM    141  OD1 ASN    35      15.746  60.010 103.818  1.00 50.99           O  
ATOM    142  ND2 ASN    35      15.438  62.227 104.175  1.00 48.30           N  
ATOM    143  N   GLY    36      18.786  57.893 103.761  1.00 45.48           N  
ATOM    144  CA  GLY    36      18.266  56.521 103.704  1.00 44.42           C  
ATOM    145  C   GLY    36      18.741  55.503 104.724  1.00 43.34           C  
ATOM    146  O   GLY    36      19.744  55.708 105.411  1.00 43.59           O  
ATOM    147  N   LEU    37      17.998  54.396 104.806  1.00 42.12           N  
ATOM    148  CA  LEU    37      18.380  53.207 105.587  1.00 40.60           C  
ATOM    149  C   LEU    37      19.471  52.375 104.904  1.00 39.92           C  
ATOM    150  O   LEU    37      20.188  51.617 105.557  1.00 40.19           O  
ATOM    151  CB  LEU    37      17.157  52.323 105.816  1.00 40.32           C  
ATOM    152  CG  LEU    37      16.146  52.823 106.843  1.00 39.52           C  
ATOM    153  CD1 LEU    37      14.733  52.507 106.371  1.00 38.72           C  
ATOM    154  CD2 LEU    37      16.450  52.222 108.203  1.00 37.12           C  
ATOM    155  N   ALA    38      19.554  52.499 103.581  1.00 38.73           N  
ATOM    156  CA  ALA    38      20.628  51.937 102.791  1.00 37.32           C  
ATOM    157  C   ALA    38      21.641  53.048 102.574  1.00 36.69           C  
ATOM    158  O   ALA    38      21.270  54.179 102.260  1.00 36.68           O  
ATOM    159  CB  ALA    38      20.095  51.446 101.462  1.00 37.36           C  
ATOM    160  N   THR    39      22.918  52.736 102.743  1.00 35.68           N  
ATOM    161  CA  THR    39      23.954  53.753 102.604  1.00 35.01           C  
ATOM    162  C   THR    39      24.340  54.037 101.154  1.00 34.09           C  
ATOM    163  O   THR    39      24.797  55.138 100.854  1.00 33.89           O  
ATOM    164  CB  THR    39      25.210  53.428 103.448  1.00 35.17           C  
ATOM    165  OG1 THR    39      25.698  52.123 103.116  1.00 36.46           O  
ATOM    166  CG2 THR    39      24.875  53.477 104.950  1.00 35.83           C  
ATOM    167  N   VAL    40      24.146  53.055 100.265  1.00 32.98           N  
ATOM    168  CA  VAL    40      24.543  53.179  98.860  1.00 32.14           C  
ATOM    169  C   VAL    40      23.356  52.941  97.922  1.00 31.56           C  
ATOM    170  O   VAL    40      22.928  51.806  97.728  1.00 31.35           O  
ATOM    171  CB  VAL    40      25.693  52.212  98.493  1.00 32.24           C  
ATOM    172  CG1 VAL    40      26.174  52.480  97.067  1.00 32.33           C  
ATOM    173  CG2 VAL    40      26.856  52.339  99.487  1.00 31.99           C  
ATOM    174  N   HIS    41      22.848  54.023  97.343  1.00 30.72           N  
ATOM    175  CA  HIS    41      21.630  53.993  96.540  1.00 30.42           C  
ATOM    176  C   HIS    41      21.927  53.707  95.067  1.00 29.34           C  
ATOM    177  O   HIS    41      23.063  53.806  94.628  1.00 29.13           O  
ATOM    178  CB  HIS    41      20.876  55.316  96.678  1.00 30.82           C  
ATOM    179  CG  HIS    41      20.283  55.538  98.035  1.00 32.30           C  
ATOM    180  ND1 HIS    41      21.025  55.984  99.108  1.00 34.12           N  
ATOM    181  CD2 HIS    41      19.017  55.387  98.490  1.00 33.06           C  
ATOM    182  CE1 HIS    41      20.239  56.094 100.164  1.00 34.95           C  
ATOM    183  NE2 HIS    41      19.017  55.733  99.818  1.00 32.90           N  
ATOM    184  N   TYR    42      20.900  53.363  94.310  1.00 28.30           N  
ATOM    185  CA  TYR    42      21.070  53.068  92.887  1.00 27.76           C  
ATOM    186  C   TYR    42      21.721  54.246  92.145  1.00 27.40           C  
ATOM    187  O   TYR    42      22.589  54.043  91.293  1.00 26.13           O  
ATOM    188  CB  TYR    42      19.732  52.679  92.234  1.00 27.32           C  
ATOM    189  CG  TYR    42      18.761  53.826  92.170  1.00 27.27           C  
ATOM    190  CD1 TYR    42      18.704  54.655  91.045  1.00 27.33           C  
ATOM    191  CD2 TYR    42      17.937  54.117  93.250  1.00 27.38           C  
ATOM    192  CE1 TYR    42      17.830  55.752  91.000  1.00 28.78           C  
ATOM    193  CE2 TYR    42      17.057  55.200  93.218  1.00 27.49           C  
ATOM    194  CZ  TYR    42      17.011  56.013  92.091  1.00 28.50           C  
ATOM    195  OH  TYR    42      16.142  57.072  92.060  1.00 27.03           O  
ATOM    196  N   HIS    43      21.320  55.471  92.485  1.00 27.55           N  
ATOM    197  CA  HIS    43      21.847  56.636  91.786  1.00 28.62           C  
ATOM    198  C   HIS    43      23.301  56.948  92.182  1.00 29.06           C  
ATOM    199  O   HIS    43      24.021  57.584  91.420  1.00 29.18           O  
ATOM    200  CB  HIS    43      20.934  57.849  91.952  1.00 28.50           C  
ATOM    201  CG  HIS    43      20.666  58.206  93.372  1.00 30.25           C  
ATOM    202  ND1 HIS    43      21.472  59.070  94.084  1.00 30.80           N  
ATOM    203  CD2 HIS    43      19.693  57.802  94.224  1.00 30.97           C  
ATOM    204  CE1 HIS    43      20.997  59.195  95.311  1.00 32.18           C  
ATOM    205  NE2 HIS    43      19.923  58.430  95.423  1.00 32.00           N  
ATOM    206  N   ASP    44      23.727  56.489  93.358  1.00 29.72           N  
ATOM    207  CA  ASP    44      25.112  56.658  93.800  1.00 30.38           C  
ATOM    208  C   ASP    44      26.021  55.735  92.993  1.00 30.30           C  
ATOM    209  O   ASP    44      27.118  56.131  92.572  1.00 30.40           O  
ATOM    210  CB  ASP    44      25.240  56.360  95.292  1.00 30.71           C  
ATOM    211  CG  ASP    44      24.608  57.435  96.160  1.00 32.58           C  
ATOM    212  OD1 ASP    44      24.688  58.627  95.794  1.00 35.99           O  
ATOM    213  OD2 ASP    44      24.032  57.098  97.220  1.00 34.61           O  
ATOM    214  N   ILE    45      25.543  54.512  92.766  1.00 30.06           N  
ATOM    215  CA  ILE    45      26.198  53.564  91.852  1.00 29.58           C  
ATOM    216  C   ILE    45      26.308  54.142  90.438  1.00 29.36           C  
ATOM    217  O   ILE    45      27.398  54.199  89.875  1.00 29.17           O  
ATOM    218  CB  ILE    45      25.486  52.183  91.846  1.00 29.39           C  
ATOM    219  CG1 ILE    45      25.575  51.552  93.237  1.00 28.40           C  
ATOM    220  CG2 ILE    45      26.112  51.239  90.788  1.00 29.30           C  
ATOM    221  CD1 ILE    45      24.475  50.565  93.552  1.00 26.29           C  
ATOM    222  N   LEU    46      25.191  54.601  89.880  1.00 29.45           N  
ATOM    223  CA  LEU    46      25.193  55.128  88.518  1.00 29.90           C  
ATOM    224  C   LEU    46      25.977  56.417  88.371  1.00 30.70           C  
ATOM    225  O   LEU    46      26.679  56.601  87.379  1.00 30.69           O  
ATOM    226  CB  LEU    46      23.770  55.307  87.975  1.00 29.69           C  
ATOM    227  CG  LEU    46      22.968  54.018  87.853  1.00 29.03           C  
ATOM    228  CD1 LEU    46      21.522  54.354  87.770  1.00 28.41           C  
ATOM    229  CD2 LEU    46      23.408  53.199  86.664  1.00 29.59           C  
ATOM    230  N   ALA    47      25.853  57.319  89.342  1.00 31.62           N  
ATOM    231  CA  ALA    47      26.573  58.587  89.261  1.00 32.75           C  
ATOM    232  C   ALA    47      28.088  58.359  89.193  1.00 33.35           C  
ATOM    233  O   ALA    47      28.781  59.053  88.448  1.00 33.62           O  
ATOM    234  CB  ALA    47      26.220  59.500  90.423  1.00 32.88           C  
ATOM    235  N   ALA    48      28.576  57.382  89.959  1.00 33.82           N  
ATOM    236  CA  ALA    48      29.989  56.989  89.955  1.00 34.86           C  
ATOM    237  C   ALA    48      30.421  56.374  88.619  1.00 35.50           C  
ATOM    238  O   ALA    48      31.442  56.774  88.055  1.00 36.17           O  
ATOM    239  CB  ALA    48      30.282  56.037  91.107  1.00 34.67           C  
ATOM    240  N   ASP    49      29.634  55.425  88.111  1.00 36.18           N  
ATOM    241  CA  ASP    49      29.892  54.784  86.820  1.00 36.90           C  
ATOM    242  C   ASP    49      29.864  55.766  85.655  1.00 36.58           C  
ATOM    243  O   ASP    49      30.571  55.578  84.666  1.00 36.40           O  
ATOM    244  CB  ASP    49      28.860  53.684  86.543  1.00 37.32           C  
ATOM    245  CG  ASP    49      28.942  52.537  87.528  1.00 40.55           C  
ATOM    246  OD1 ASP    49      29.898  52.496  88.350  1.00 43.81           O  
ATOM    247  OD2 ASP    49      28.039  51.665  87.485  1.00 43.01           O  
ATOM    248  N   TRP    50      29.028  56.796  85.764  1.00 36.12           N  
ATOM    249  CA  TRP    50      28.873  57.771  84.689  1.00 35.71           C  
ATOM    250  C   TRP    50      29.898  58.899  84.753  1.00 36.30           C  
ATOM    251  O   TRP    50      30.016  59.668  83.805  1.00 36.56           O  
ATOM    252  CB  TRP    50      27.468  58.373  84.712  1.00 34.55           C  
ATOM    253  CG  TRP    50      26.352  57.417  84.404  1.00 33.95           C  
ATOM    254  CD1 TRP    50      26.460  56.153  83.890  1.00 32.25           C  
ATOM    255  CD2 TRP    50      24.951  57.671  84.552  1.00 32.30           C  
ATOM    256  NE1 TRP    50      25.210  55.599  83.733  1.00 31.15           N  
ATOM    257  CE2 TRP    50      24.268  56.513  84.127  1.00 31.95           C  
ATOM    258  CE3 TRP    50      24.206  58.764  85.016  1.00 31.79           C  
ATOM    259  CZ2 TRP    50      22.875  56.412  84.162  1.00 31.89           C  
ATOM    260  CZ3 TRP    50      22.835  58.666  85.043  1.00 32.03           C  
ATOM    261  CH2 TRP    50      22.180  57.494  84.618  1.00 32.32           C  
ATOM    262  N   ASP    51      30.623  58.989  85.870  1.00 36.94           N  
ATOM    263  CA  ASP    51      31.512  60.114  86.183  1.00 37.69           C  
ATOM    264  C   ASP    51      30.801  61.433  85.922  1.00 37.53           C  
ATOM    265  O   ASP    51      31.192  62.229  85.058  1.00 37.53           O  
ATOM    266  CB  ASP    51      32.853  60.027  85.432  1.00 38.14           C  
ATOM    267  CG  ASP    51      33.899  61.010  85.977  1.00 40.52           C  
ATOM    268  OD1 ASP    51      34.296  60.900  87.169  1.00 40.94           O  
ATOM    269  OD2 ASP    51      34.320  61.903  85.202  1.00 42.68           O  
ATOM    270  N   VAL    52      29.735  61.646  86.682  1.00 37.25           N  
ATOM    271  CA  VAL    52      28.880  62.808  86.500  1.00 36.74           C  
ATOM    272  C   VAL    52      29.594  64.084  86.915  1.00 36.97           C  
ATOM    273  O   VAL    52      30.460  64.086  87.794  1.00 36.98           O  
ATOM    274  CB  VAL    52      27.525  62.661  87.267  1.00 36.71           C  
ATOM    275  CG1 VAL    52      26.754  61.466  86.754  1.00 35.20           C  
ATOM    276  CG2 VAL    52      27.750  62.536  88.780  1.00 35.75           C  
ATOM    277  N   GLU    53      29.231  65.155  86.229  1.00 37.31           N  
ATOM    278  CA  GLU    53      29.628  66.504  86.557  1.00 37.60           C  
ATOM    279  C   GLU    53      28.907  66.890  87.855  1.00 37.15           C  
ATOM    280  O   GLU    53      29.521  67.445  88.772  1.00 37.41           O  
ATOM    281  CB  GLU    53      29.282  67.401  85.360  1.00 38.05           C  
ATOM    282  CG  GLU    53      29.135  68.893  85.601  1.00 41.10           C  
ATOM    283  CD  GLU    53      28.639  69.642  84.349  1.00 45.13           C  
ATOM    284  OE1 GLU    53      28.496  69.005  83.266  1.00 45.92           O  
ATOM    285  OE2 GLU    53      28.393  70.871  84.452  1.00 46.27           O  
ATOM    286  N   ARG    54      27.619  66.564  87.945  1.00 36.27           N  
ATOM    287  CA  ARG    54      26.886  66.659  89.212  1.00 35.97           C  
ATOM    288  C   ARG    54      25.639  65.776  89.212  1.00 35.43           C  
ATOM    289  O   ARG    54      25.111  65.444  88.158  1.00 35.32           O  
ATOM    290  CB  ARG    54      26.521  68.111  89.554  1.00 36.32           C  
ATOM    291  CG  ARG    54      25.531  68.748  88.602  1.00 36.73           C  
ATOM    292  CD  ARG    54      24.707  69.830  89.293  1.00 39.63           C  
ATOM    293  NE  ARG    54      23.492  70.097  88.531  1.00 39.30           N  
ATOM    294  CZ  ARG    54      23.417  70.915  87.490  1.00 40.54           C  
ATOM    295  NH1 ARG    54      24.491  71.578  87.070  1.00 39.07           N  
ATOM    296  NH2 ARG    54      22.260  71.062  86.863  1.00 40.72           N  
ATOM    297  N   SER    55      25.187  65.394  90.402  1.00 34.85           N  
ATOM    298  CA  SER    55      24.044  64.500  90.553  1.00 33.95           C  
ATOM    299  C   SER    55      23.097  65.103  91.575  1.00 33.80           C  
ATOM    300  O   SER    55      23.381  65.085  92.778  1.00 34.24           O  
ATOM    301  CB  SER    55      24.507  63.101  90.994  1.00 33.95           C  
ATOM    302  OG  SER    55      23.443  62.150  90.986  1.00 32.31           O  
ATOM    303  N   ASP    56      21.981  65.646  91.091  1.00 33.55           N  
ATOM    304  CA  ASP    56      21.002  66.318  91.947  1.00 33.43           C  
ATOM    305  C   ASP    56      19.976  65.366  92.547  1.00 32.73           C  
ATOM    306  O   ASP    56      19.201  64.719  91.837  1.00 32.42           O  
ATOM    307  CB  ASP    56      20.315  67.453  91.193  1.00 33.82           C  
ATOM    308  CG  ASP    56      21.294  68.545  90.785  1.00 36.70           C  
ATOM    309  OD1 ASP    56      21.527  68.703  89.568  1.00 39.47           O  
ATOM    310  OD2 ASP    56      21.854  69.231  91.675  1.00 39.85           O  
ATOM    311  N   ASN    57      19.985  65.295  93.871  1.00 32.32           N  
ATOM    312  CA  ASN    57      19.124  64.395  94.617  1.00 31.68           C  
ATOM    313  C   ASN    57      17.892  65.143  95.111  1.00 31.62           C  
ATOM    314  O   ASN    57      17.992  65.985  96.011  1.00 31.59           O  
ATOM    315  CB  ASN    57      19.910  63.803  95.786  1.00 31.73           C  
ATOM    316  CG  ASN    57      19.163  62.693  96.508  1.00 31.50           C  
ATOM    317  OD1 ASN    57      17.937  62.702  96.597  1.00 30.51           O  
ATOM    318  ND2 ASN    57      19.913  61.746  97.067  1.00 30.82           N  
ATOM    319  N   LEU    58      16.735  64.837  94.518  1.00 30.55           N  
ATOM    320  CA  LEU    58      15.467  65.438  94.931  1.00 30.18           C  
ATOM    321  C   LEU    58      14.535  64.407  95.578  1.00 29.76           C  
ATOM    322  O   LEU    58      13.331  64.387  95.327  1.00 29.50           O  
ATOM    323  CB  LEU    58      14.788  66.112  93.739  1.00 30.20           C  
ATOM    324  CG  LEU    58      15.658  67.208  93.138  1.00 31.36           C  
ATOM    325  CD1 LEU    58      15.391  67.376  91.662  1.00 32.04           C  
ATOM    326  CD2 LEU    58      15.452  68.505  93.905  1.00 33.94           C  
ATOM    327  N   GLY    59      15.110  63.547  96.408  1.00 29.33           N  
ATOM    328  CA  GLY    59      14.339  62.537  97.121  1.00 28.93           C  
ATOM    329  C   GLY    59      13.964  63.086  98.482  1.00 28.75           C  
ATOM    330  O   GLY    59      14.757  63.779  99.120  1.00 28.57           O  
ATOM    331  N   ILE    60      12.746  62.791  98.915  1.00 28.49           N  
ATOM    332  CA  ILE    60      12.270  63.171 100.240  1.00 27.99           C  
ATOM    333  C   ILE    60      11.569  61.948 100.787  1.00 27.77           C  
ATOM    334  O   ILE    60      10.662  61.416 100.143  1.00 27.84           O  
ATOM    335  CB  ILE    60      11.278  64.357 100.177  1.00 28.40           C  
ATOM    336  CG1 ILE    60      11.980  65.615  99.648  1.00 29.64           C  
ATOM    337  CG2 ILE    60      10.654  64.634 101.554  1.00 27.85           C  
ATOM    338  CD1 ILE    60      11.139  66.892  99.746  1.00 30.02           C  
ATOM    339  N   SER    61      12.018  61.484 101.950  1.00 27.48           N  
ATOM    340  CA  SER    61      11.401  60.385 102.670  1.00 26.97           C  
ATOM    341  C   SER    61       9.896  60.578 102.787  1.00 26.17           C  
ATOM    342  O   SER    61       9.430  61.640 103.205  1.00 25.99           O  
ATOM    343  CB  SER    61      12.006  60.294 104.069  1.00 27.83           C  
ATOM    344  OG  SER    61      11.194  59.495 104.935  1.00 30.62           O  
ATOM    345  N   GLY    62       9.145  59.563 102.383  1.00 25.12           N  
ATOM    346  CA  GLY    62       7.706  59.550 102.587  1.00 24.20           C  
ATOM    347  C   GLY    62       6.877  60.238 101.525  1.00 23.65           C  
ATOM    348  O   GLY    62       5.650  60.191 101.587  1.00 23.71           O  
ATOM    349  N   SER    63       7.542  60.850 100.546  1.00 22.64           N  
ATOM    350  CA  SER    63       6.882  61.682  99.542  1.00 22.47           C  
ATOM    351  C   SER    63       5.986  60.898  98.560  1.00 22.38           C  
ATOM    352  O   SER    63       6.346  59.834  98.079  1.00 22.02           O  
ATOM    353  CB  SER    63       7.938  62.522  98.788  1.00 22.18           C  
ATOM    354  OG  SER    63       7.404  63.125  97.619  1.00 23.35           O  
ATOM    355  N   THR    64       4.817  61.450  98.265  1.00 22.68           N  
ATOM    356  CA  THR    64       3.892  60.871  97.301  1.00 22.80           C  
ATOM    357  C   THR    64       3.993  61.684  96.017  1.00 22.94           C  
ATOM    358  O   THR    64       4.563  62.769  96.018  1.00 23.29           O  
ATOM    359  CB  THR    64       2.451  60.977  97.822  1.00 23.40           C  
ATOM    360  OG1 THR    64       2.174  62.353  98.176  1.00 23.72           O  
ATOM    361  CG2 THR    64       2.243  60.049  99.037  1.00 21.12           C  
ATOM    362  N   ILE    65       3.459  61.161  94.921  1.00 23.25           N  
ATOM    363  CA  ILE    65       3.330  61.954  93.690  1.00 22.83           C  
ATOM    364  C   ILE    65       2.189  62.963  93.874  1.00 22.81           C  
ATOM    365  O   ILE    65       2.308  64.129  93.496  1.00 22.26           O  
ATOM    366  CB  ILE    65       3.091  61.059  92.460  1.00 22.70           C  
ATOM    367  CG1 ILE    65       4.371  60.283  92.121  1.00 23.50           C  
ATOM    368  CG2 ILE    65       2.650  61.901  91.273  1.00 22.53           C  
ATOM    369  CD1 ILE    65       4.200  59.238  91.059  1.00 24.69           C  
ATOM    370  N   GLY    66       1.098  62.497  94.479  1.00 22.74           N  
ATOM    371  CA  GLY    66      -0.055  63.344  94.765  1.00 23.56           C  
ATOM    372  C   GLY    66       0.083  64.222  96.000  1.00 24.01           C  
ATOM    373  O   GLY    66       1.147  64.267  96.652  1.00 23.52           O  
ATOM    374  N   SER    67      -1.024  64.883  96.338  1.00 24.31           N  
ATOM    375  CA  SER    67      -1.062  65.916  97.371  1.00 24.80           C  
ATOM    376  C   SER    67      -0.736  65.546  98.827  1.00 25.18           C  
ATOM    377  O   SER    67      -0.501  66.448  99.639  1.00 25.39           O  
ATOM    378  CB  SER    67      -2.429  66.587  97.344  1.00 24.95           C  
ATOM    379  OG  SER    67      -3.423  65.682  97.782  1.00 26.60           O  
ATOM    380  N   ARG    68      -0.714  64.254  99.158  1.00 24.94           N  
ATOM    381  CA  ARG    68      -0.731  63.812 100.559  1.00 25.55           C  
ATOM    382  C   ARG    68       0.518  64.186 101.346  1.00 25.68           C  
ATOM    383  O   ARG    68       0.410  64.642 102.488  1.00 25.58           O  
ATOM    384  CB  ARG    68      -0.964  62.300 100.663  1.00 25.91           C  
ATOM    385  CG  ARG    68      -2.368  61.815 100.280  1.00 28.19           C  
ATOM    386  CD  ARG    68      -3.405  61.913 101.397  1.00 31.48           C  
ATOM    387  NE  ARG    68      -2.841  61.702 102.726  1.00 34.01           N  
ATOM    388  CZ  ARG    68      -3.201  60.740 103.568  1.00 36.05           C  
ATOM    389  NH1 ARG    68      -4.146  59.867 103.243  1.00 39.20           N  
ATOM    390  NH2 ARG    68      -2.608  60.655 104.747  1.00 38.14           N  
ATOM    391  N   TYR    69       1.689  63.999 100.730  1.00 26.17           N  
ATOM    392  CA  TYR    69       2.993  64.229 101.373  1.00 26.29           C  
ATOM    393  C   TYR    69       4.043  64.765 100.389  1.00 26.25           C  
ATOM    394  O   TYR    69       4.495  64.025  99.520  1.00 25.55           O  
ATOM    395  CB  TYR    69       3.514  62.916 101.969  1.00 26.97           C  
ATOM    396  CG  TYR    69       2.682  62.359 103.092  1.00 28.11           C  
ATOM    397  CD1 TYR    69       1.747  61.354 102.867  1.00 29.15           C  
ATOM    398  CD2 TYR    69       2.828  62.847 104.389  1.00 30.62           C  
ATOM    399  CE1 TYR    69       0.973  60.832 103.919  1.00 30.13           C  
ATOM    400  CE2 TYR    69       2.067  62.340 105.435  1.00 31.47           C  
ATOM    401  CZ  TYR    69       1.148  61.337 105.197  1.00 31.07           C  
ATOM    402  OH  TYR    69       0.411  60.862 106.256  1.00 31.97           O  
ATOM    403  N   ASP    70       4.447  66.029 100.541  1.00 26.16           N  
ATOM    404  CA  ASP    70       5.512  66.621  99.718  1.00 26.85           C  
ATOM    405  C   ASP    70       5.375  66.303  98.236  1.00 26.97           C  
ATOM    406  O   ASP    70       6.313  65.763  97.631  1.00 27.42           O  
ATOM    407  CB  ASP    70       6.892  66.137 100.194  1.00 27.69           C  
ATOM    408  CG  ASP    70       7.286  66.724 101.531  1.00 30.26           C  
ATOM    409  OD1 ASP    70       7.431  65.949 102.513  1.00 32.32           O  
ATOM    410  OD2 ASP    70       7.448  67.963 101.598  1.00 32.52           O  
ATOM    411  N   ALA    71       4.215  66.628  97.662  1.00 26.44           N  
ATOM    412  CA  ALA    71       3.853  66.248  96.292  1.00 26.35           C  
ATOM    413  C   ALA    71       4.969  66.387  95.261  1.00 26.60           C  
ATOM    414  O   ALA    71       5.404  67.493  94.966  1.00 26.20           O  
ATOM    415  CB  ALA    71       2.645  67.057  95.836  1.00 25.85           C  
ATOM    416  N   MET    72       5.404  65.281  94.691  1.00 26.98           N  
ATOM    417  CA  MET    72       6.312  65.335  93.532  1.00 27.48           C  
ATOM    418  C   MET    72       5.727  66.112  92.344  1.00 27.22           C  
ATOM    419  O   MET    72       6.468  66.670  91.522  1.00 27.03           O  
ATOM    420  CB  MET    72       6.710  63.937  93.086  1.00 27.51           C  
ATOM    421  CG  MET    72       7.648  63.223  94.042  1.00 30.91           C  
ATOM    422  SD  MET    72       8.133  61.430  93.370  1.00 39.12          SE  
ATOM    423  CE  MET    72       7.896  60.450  95.051  1.00 34.85           C  
ATOM    424  N   ALA    73       4.411  66.156  92.265  1.00 27.35           N  
ATOM    425  CA  ALA    73       3.728  66.907  91.210  1.00 27.92           C  
ATOM    426  C   ALA    73       3.890  68.422  91.357  1.00 28.25           C  
ATOM    427  O   ALA    73       3.534  69.173  90.450  1.00 28.78           O  
ATOM    428  CB  ALA    73       2.264  66.513  91.127  1.00 28.14           C  
ATOM    429  N   VAL    74       4.435  68.868  92.490  1.00 28.54           N  
ATOM    430  CA  VAL    74       4.903  70.250  92.628  1.00 28.48           C  
ATOM    431  C   VAL    74       6.429  70.331  92.771  1.00 28.30           C  
ATOM    432  O   VAL    74       7.063  71.206  92.193  1.00 28.46           O  
ATOM    433  CB  VAL    74       4.166  71.055  93.763  1.00 28.70           C  
ATOM    434  CG1 VAL    74       4.191  70.339  95.078  1.00 27.89           C  
ATOM    435  CG2 VAL    74       4.783  72.444  93.922  1.00 28.87           C  
ATOM    436  N   ARG    75       7.023  69.395  93.505  1.00 27.92           N  
ATOM    437  CA  ARG    75       8.462  69.448  93.771  1.00 27.43           C  
ATOM    438  C   ARG    75       9.350  69.346  92.526  1.00 27.06           C  
ATOM    439  O   ARG    75      10.519  69.741  92.564  1.00 27.07           O  
ATOM    440  CB  ARG    75       8.867  68.373  94.775  1.00 27.34           C  
ATOM    441  CG  ARG    75       8.381  68.637  96.168  1.00 27.55           C  
ATOM    442  CD  ARG    75       9.140  67.791  97.187  1.00 28.22           C  
ATOM    443  NE  ARG    75       9.045  66.346  96.953  1.00 28.67           N  
ATOM    444  CZ  ARG    75      10.023  65.606  96.451  1.00 29.08           C  
ATOM    445  NH1 ARG    75      11.175  66.170  96.120  1.00 31.05           N  
ATOM    446  NH2 ARG    75       9.860  64.299  96.290  1.00 30.39           N  
ATOM    447  N   TYR    76       8.802  68.816  91.435  1.00 26.41           N  
ATOM    448  CA  TYR    76       9.537  68.705  90.175  1.00 26.24           C  
ATOM    449  C   TYR    76      10.085  70.049  89.688  1.00 26.65           C  
ATOM    450  O   TYR    76      11.033  70.081  88.896  1.00 26.78           O  
ATOM    451  CB  TYR    76       8.637  68.106  89.078  1.00 26.03           C  
ATOM    452  CG  TYR    76       7.718  69.112  88.401  1.00 24.20           C  
ATOM    453  CD1 TYR    76       6.422  69.309  88.855  1.00 22.99           C  
ATOM    454  CD2 TYR    76       8.160  69.868  87.318  1.00 22.21           C  
ATOM    455  CE1 TYR    76       5.566  70.221  88.231  1.00 24.07           C  
ATOM    456  CE2 TYR    76       7.330  70.797  86.695  1.00 25.28           C  
ATOM    457  CZ  TYR    76       6.029  70.969  87.155  1.00 26.32           C  
ATOM    458  OH  TYR    76       5.204  71.894  86.545  1.00 27.42           O  
ATOM    459  N   GLN    77       9.469  71.143  90.143  1.00 27.02           N  
ATOM    460  CA  GLN    77       9.814  72.503  89.714  1.00 27.97           C  
ATOM    461  C   GLN    77      11.164  72.947  90.280  1.00 28.42           C  
ATOM    462  O   GLN    77      11.708  73.973  89.861  1.00 28.41           O  
ATOM    463  CB  GLN    77       8.706  73.489  90.101  1.00 28.39           C  
ATOM    464  CG  GLN    77       7.329  73.063  89.597  1.00 30.48           C  
ATOM    465  CD  GLN    77       6.238  74.126  89.726  1.00 34.91           C  
ATOM    466  OE1 GLN    77       5.335  74.198  88.888  1.00 36.25           O  
ATOM    467  NE2 GLN    77       6.295  74.930  90.782  1.00 36.25           N  
ATOM    468  N   ALA    78      11.709  72.150  91.205  1.00 28.32           N  
ATOM    469  CA  ALA    78      13.057  72.376  91.756  1.00 28.21           C  
ATOM    470  C   ALA    78      14.181  71.678  90.978  1.00 27.88           C  
ATOM    471  O   ALA    78      15.360  71.845  91.305  1.00 27.58           O  
ATOM    472  CB  ALA    78      13.109  71.969  93.239  1.00 28.09           C  
ATOM    473  N   ILE    79      13.816  70.880  89.975  1.00 28.35           N  
ATOM    474  CA  ILE    79      14.797  70.249  89.084  1.00 28.60           C  
ATOM    475  C   ILE    79      15.603  71.363  88.387  1.00 29.23           C  
ATOM    476  O   ILE    79      15.018  72.326  87.870  1.00 28.50           O  
ATOM    477  CB  ILE    79      14.110  69.267  88.058  1.00 28.58           C  
ATOM    478  CG1 ILE    79      13.491  68.056  88.779  1.00 28.40           C  
ATOM    479  CG2 ILE    79      15.077  68.788  86.983  1.00 27.81           C  
ATOM    480  CD1 ILE    79      12.489  67.256  87.917  1.00 26.80           C  
ATOM    481  N   PRO    80      16.948  71.254  88.406  1.00 30.17           N  
ATOM    482  CA  PRO    80      17.825  72.255  87.764  1.00 31.13           C  
ATOM    483  C   PRO    80      17.496  72.459  86.286  1.00 32.30           C  
ATOM    484  O   PRO    80      17.190  71.488  85.573  1.00 32.38           O  
ATOM    485  CB  PRO    80      19.211  71.635  87.898  1.00 30.92           C  
ATOM    486  CG  PRO    80      19.102  70.683  89.036  1.00 30.52           C  
ATOM    487  CD  PRO    80      17.719  70.166  89.042  1.00 30.05           C  
ATOM    488  N   GLU    81      17.556  73.706  85.828  1.00 33.75           N  
ATOM    489  CA  GLU    81      17.210  74.035  84.434  1.00 35.53           C  
ATOM    490  C   GLU    81      18.084  73.318  83.372  1.00 35.52           C  
ATOM    491  O   GLU    81      17.619  73.031  82.261  1.00 35.43           O  
ATOM    492  CB  GLU    81      17.168  75.556  84.222  1.00 36.33           C  
ATOM    493  CG  GLU    81      15.741  76.135  84.296  1.00 40.59           C  
ATOM    494  CD  GLU    81      15.599  77.362  85.218  1.00 45.28           C  
ATOM    495  OE1 GLU    81      16.546  78.186  85.300  1.00 47.86           O  
ATOM    496  OE2 GLU    81      14.521  77.508  85.857  1.00 46.70           O  
ATOM    497  N   ASP    82      19.329  73.011  83.728  1.00 35.53           N  
ATOM    498  CA  ASP    82      20.239  72.322  82.805  1.00 35.78           C  
ATOM    499  C   ASP    82      20.460  70.832  83.141  1.00 35.02           C  
ATOM    500  O   ASP    82      21.515  70.259  82.841  1.00 35.25           O  
ATOM    501  CB  ASP    82      21.571  73.075  82.711  1.00 36.17           C  
ATOM    502  CG  ASP    82      22.296  73.142  84.038  1.00 38.20           C  
ATOM    503  OD1 ASP    82      21.628  73.090  85.099  1.00 39.80           O  
ATOM    504  OD2 ASP    82      23.544  73.258  84.016  1.00 41.53           O  
ATOM    505  N   ALA    83      19.460  70.208  83.758  1.00 33.88           N  
ATOM    506  CA  ALA    83      19.441  68.759  83.923  1.00 32.65           C  
ATOM    507  C   ALA    83      19.511  68.102  82.547  1.00 31.72           C  
ATOM    508  O   ALA    83      18.795  68.514  81.637  1.00 31.12           O  
ATOM    509  CB  ALA    83      18.178  68.338  84.634  1.00 32.49           C  
ATOM    510  N   ASP    84      20.383  67.107  82.383  1.00 31.15           N  
ATOM    511  CA  ASP    84      20.475  66.405  81.095  1.00 30.70           C  
ATOM    512  C   ASP    84      19.767  65.052  81.100  1.00 29.46           C  
ATOM    513  O   ASP    84      19.696  64.378  80.064  1.00 29.68           O  
ATOM    514  CB  ASP    84      21.931  66.285  80.603  1.00 31.62           C  
ATOM    515  CG  ASP    84      22.716  65.214  81.323  1.00 33.72           C  
ATOM    516  OD1 ASP    84      22.283  64.765  82.402  1.00 36.98           O  
ATOM    517  OD2 ASP    84      23.788  64.824  80.813  1.00 37.94           O  
ATOM    518  N   PHE    85      19.249  64.671  82.268  1.00 27.62           N  
ATOM    519  CA  PHE    85      18.471  63.449  82.454  1.00 26.11           C  
ATOM    520  C   PHE    85      17.576  63.630  83.671  1.00 25.26           C  
ATOM    521  O   PHE    85      18.021  64.132  84.706  1.00 25.67           O  
ATOM    522  CB  PHE    85      19.399  62.243  82.657  1.00 25.89           C  
ATOM    523  CG  PHE    85      18.676  60.941  82.964  1.00 25.84           C  
ATOM    524  CD1 PHE    85      17.840  60.341  82.016  1.00 26.30           C  
ATOM    525  CD2 PHE    85      18.858  60.303  84.191  1.00 25.57           C  
ATOM    526  CE1 PHE    85      17.183  59.131  82.296  1.00 25.75           C  
ATOM    527  CE2 PHE    85      18.212  59.109  84.483  1.00 26.03           C  
ATOM    528  CZ  PHE    85      17.373  58.510  83.525  1.00 25.93           C  
ATOM    529  N   ILE    86      16.318  63.232  83.543  1.00 24.05           N  
ATOM    530  CA  ILE    86      15.393  63.275  84.665  1.00 23.36           C  
ATOM    531  C   ILE    86      14.759  61.914  84.910  1.00 23.43           C  
ATOM    532  O   ILE    86      14.126  61.336  84.024  1.00 23.48           O  
ATOM    533  CB  ILE    86      14.296  64.361  84.487  1.00 23.08           C  
ATOM    534  CG1 ILE    86      14.944  65.751  84.413  1.00 21.60           C  
ATOM    535  CG2 ILE    86      13.276  64.293  85.639  1.00 21.99           C  
ATOM    536  CD1 ILE    86      14.119  66.796  83.651  1.00 20.57           C  
ATOM    537  N   ALA    87      14.935  61.421  86.125  1.00 22.87           N  
ATOM    538  CA  ALA    87      14.316  60.189  86.568  1.00 23.15           C  
ATOM    539  C   ALA    87      13.308  60.472  87.691  1.00 23.72           C  
ATOM    540  O   ALA    87      13.593  61.234  88.628  1.00 23.97           O  
ATOM    541  CB  ALA    87      15.375  59.225  87.036  1.00 22.81           C  
ATOM    542  N   VAL    88      12.125  59.874  87.577  1.00 23.58           N  
ATOM    543  CA  VAL    88      11.121  59.942  88.636  1.00 23.94           C  
ATOM    544  C   VAL    88      10.849  58.553  89.190  1.00 23.99           C  
ATOM    545  O   VAL    88      10.514  57.626  88.447  1.00 23.64           O  
ATOM    546  CB  VAL    88       9.808  60.596  88.164  1.00 23.67           C  
ATOM    547  CG1 VAL    88       8.792  60.665  89.311  1.00 24.16           C  
ATOM    548  CG2 VAL    88      10.089  61.980  87.578  1.00 22.90           C  
ATOM    549  N   PHE    89      11.007  58.421  90.500  1.00 24.72           N  
ATOM    550  CA  PHE    89      10.878  57.137  91.167  1.00 25.84           C  
ATOM    551  C   PHE    89       9.833  57.269  92.290  1.00 26.74           C  
ATOM    552  O   PHE    89      10.158  57.548  93.445  1.00 27.63           O  
ATOM    553  CB  PHE    89      12.262  56.715  91.678  1.00 26.18           C  
ATOM    554  CG  PHE    89      12.371  55.263  92.089  1.00 26.27           C  
ATOM    555  CD1 PHE    89      11.251  54.523  92.456  1.00 28.52           C  
ATOM    556  CD2 PHE    89      13.609  54.663  92.159  1.00 28.05           C  
ATOM    557  CE1 PHE    89      11.368  53.210  92.862  1.00 29.83           C  
ATOM    558  CE2 PHE    89      13.743  53.337  92.570  1.00 29.30           C  
ATOM    559  CZ  PHE    89      12.625  52.611  92.918  1.00 29.87           C  
ATOM    560  N   GLY    90       8.566  57.098  91.936  1.00 27.18           N  
ATOM    561  CA  GLY    90       7.481  57.327  92.884  1.00 27.96           C  
ATOM    562  C   GLY    90       6.273  56.428  92.704  1.00 28.20           C  
ATOM    563  O   GLY    90       6.204  55.648  91.747  1.00 29.03           O  
ATOM    564  N   GLY    91       5.328  56.537  93.641  1.00 27.91           N  
ATOM    565  CA  GLY    91       4.092  55.765  93.606  1.00 27.22           C  
ATOM    566  C   GLY    91       3.905  54.808  94.777  1.00 27.06           C  
ATOM    567  O   GLY    91       2.770  54.449  95.107  1.00 26.89           O  
ATOM    568  N   VAL    92       5.003  54.382  95.402  1.00 26.42           N  
ATOM    569  CA  VAL    92       4.886  53.411  96.474  1.00 25.96           C  
ATOM    570  C   VAL    92       4.271  54.028  97.729  1.00 25.40           C  
ATOM    571  O   VAL    92       3.533  53.356  98.447  1.00 24.84           O  
ATOM    572  CB  VAL    92       6.208  52.655  96.776  1.00 26.43           C  
ATOM    573  CG1 VAL    92       7.100  53.428  97.740  1.00 25.17           C  
ATOM    574  CG2 VAL    92       5.872  51.294  97.368  1.00 26.99           C  
ATOM    575  N   ASN    93       4.556  55.310  97.966  1.00 24.70           N  
ATOM    576  CA  ASN    93       3.911  56.045  99.061  1.00 24.84           C  
ATOM    577  C   ASN    93       2.478  56.419  98.725  1.00 24.79           C  
ATOM    578  O   ASN    93       1.610  56.401  99.593  1.00 24.65           O  
ATOM    579  CB  ASN    93       4.704  57.294  99.457  1.00 24.43           C  
ATOM    580  CG  ASN    93       6.025  56.957 100.122  1.00 24.84           C  
ATOM    581  OD1 ASN    93       7.062  57.553  99.805  1.00 23.42           O  
ATOM    582  ND2 ASN    93       5.997  55.994 101.045  1.00 20.63           N  
ATOM    583  N   ASP    94       2.220  56.747  97.464  1.00 24.83           N  
ATOM    584  CA  ASP    94       0.841  56.969  97.057  1.00 25.20           C  
ATOM    585  C   ASP    94       0.016  55.715  97.352  1.00 24.53           C  
ATOM    586  O   ASP    94      -1.086  55.806  97.892  1.00 24.07           O  
ATOM    587  CB  ASP    94       0.761  57.378  95.601  1.00 25.60           C  
ATOM    588  CG  ASP    94       1.568  58.642  95.309  1.00 28.68           C  
ATOM    589  OD1 ASP    94       0.954  59.705  95.024  1.00 31.76           O  
ATOM    590  OD2 ASP    94       2.825  58.572  95.363  1.00 30.95           O  
ATOM    591  N   TYR    95       0.569  54.544  97.039  1.00 24.24           N  
ATOM    592  CA  TYR    95      -0.094  53.286  97.408  1.00 24.26           C  
ATOM    593  C   TYR    95      -0.176  53.113  98.937  1.00 24.30           C  
ATOM    594  O   TYR    95      -1.263  53.040  99.491  1.00 24.11           O  
ATOM    595  CB  TYR    95       0.566  52.057  96.755  1.00 23.84           C  
ATOM    596  CG  TYR    95       0.113  50.739  97.363  1.00 22.56           C  
ATOM    597  CD1 TYR    95      -1.187  50.260  97.154  1.00 21.36           C  
ATOM    598  CD2 TYR    95       0.967  49.995  98.181  1.00 21.78           C  
ATOM    599  CE1 TYR    95      -1.617  49.075  97.733  1.00 21.71           C  
ATOM    600  CE2 TYR    95       0.545  48.806  98.760  1.00 21.63           C  
ATOM    601  CZ  TYR    95      -0.743  48.354  98.532  1.00 22.59           C  
ATOM    602  OH  TYR    95      -1.159  47.168  99.082  1.00 23.23           O  
ATOM    603  N   GLY    96       0.976  53.088  99.600  1.00 24.48           N  
ATOM    604  CA  GLY    96       1.053  52.740 101.013  1.00 25.31           C  
ATOM    605  C   GLY    96       0.545  53.783 101.992  1.00 25.94           C  
ATOM    606  O   GLY    96       0.202  53.459 103.120  1.00 25.71           O  
ATOM    607  N   ARG    97       0.497  55.043 101.572  1.00 26.44           N  
ATOM    608  CA  ARG    97      -0.006  56.092 102.453  1.00 26.91           C  
ATOM    609  C   ARG    97      -1.386  56.595 101.999  1.00 27.44           C  
ATOM    610  O   ARG    97      -1.810  57.696 102.351  1.00 27.73           O  
ATOM    611  CB  ARG    97       1.018  57.221 102.584  1.00 26.28           C  
ATOM    612  CG  ARG    97       2.442  56.710 102.837  1.00 25.92           C  
ATOM    613  CD  ARG    97       3.433  57.834 103.067  1.00 26.03           C  
ATOM    614  NE  ARG    97       3.413  58.282 104.454  1.00 25.60           N  
ATOM    615  CZ  ARG    97       4.099  59.319 104.925  1.00 27.25           C  
ATOM    616  NH1 ARG    97       4.851  60.048 104.113  1.00 26.30           N  
ATOM    617  NH2 ARG    97       4.007  59.651 106.212  1.00 27.19           N  
ATOM    618  N   ASP    98      -2.075  55.773 101.213  1.00 27.60           N  
ATOM    619  CA  ASP    98      -3.471  56.001 100.872  1.00 28.01           C  
ATOM    620  C   ASP    98      -3.734  57.321 100.129  1.00 27.96           C  
ATOM    621  O   ASP    98      -4.581  58.126 100.543  1.00 28.39           O  
ATOM    622  CB  ASP    98      -4.365  55.852 102.134  1.00 28.42           C  
ATOM    623  CG  ASP    98      -4.302  54.439 102.746  1.00 29.85           C  
ATOM    624  OD1 ASP    98      -4.275  53.462 101.968  1.00 30.58           O  
ATOM    625  OD2 ASP    98      -4.301  54.293 103.996  1.00 30.99           O  
ATOM    626  N   GLN    99      -3.021  57.541  99.026  1.00 27.53           N  
ATOM    627  CA  GLN    99      -3.415  58.589  98.073  1.00 27.27           C  
ATOM    628  C   GLN    99      -4.619  58.077  97.275  1.00 26.99           C  
ATOM    629  O   GLN    99      -4.550  56.995  96.694  1.00 26.20           O  
ATOM    630  CB  GLN    99      -2.254  58.944  97.136  1.00 27.18           C  
ATOM    631  CG  GLN    99      -2.518  60.087  96.132  1.00 27.84           C  
ATOM    632  CD  GLN    99      -2.532  61.458  96.787  1.00 29.85           C  
ATOM    633  OE1 GLN    99      -3.543  62.182  96.749  1.00 31.31           O  
ATOM    634  NE2 GLN    99      -1.414  61.820  97.411  1.00 27.63           N  
ATOM    635  N   PRO   100      -5.744  58.834  97.257  1.00 27.31           N  
ATOM    636  CA  PRO   100      -6.837  58.347  96.408  1.00 27.38           C  
ATOM    637  C   PRO   100      -6.298  58.107  95.007  1.00 27.27           C  
ATOM    638  O   PRO   100      -5.473  58.893  94.521  1.00 27.10           O  
ATOM    639  CB  PRO   100      -7.846  59.502  96.420  1.00 27.13           C  
ATOM    640  CG  PRO   100      -7.602  60.176  97.754  1.00 28.00           C  
ATOM    641  CD  PRO   100      -6.097  60.098  97.938  1.00 27.47           C  
ATOM    642  N   LEU   101      -6.718  57.009  94.393  1.00 27.34           N  
ATOM    643  CA  LEU   101      -6.231  56.644  93.068  1.00 28.05           C  
ATOM    644  C   LEU   101      -6.817  57.549  91.992  1.00 28.92           C  
ATOM    645  O   LEU   101      -6.108  58.006  91.090  1.00 29.16           O  
ATOM    646  CB  LEU   101      -6.547  55.182  92.760  1.00 27.85           C  
ATOM    647  CG  LEU   101      -6.057  54.640  91.417  1.00 27.17           C  
ATOM    648  CD1 LEU   101      -4.549  54.678  91.323  1.00 24.57           C  
ATOM    649  CD2 LEU   101      -6.586  53.242  91.189  1.00 28.13           C  
ATOM    650  N   GLY   102      -8.113  57.819  92.097  1.00 29.86           N  
ATOM    651  CA  GLY   102      -8.795  58.580  91.084  1.00 30.67           C  
ATOM    652  C   GLY   102      -9.008  57.730  89.853  1.00 31.74           C  
ATOM    653  O   GLY   102      -8.978  56.503  89.914  1.00 31.60           O  
ATOM    654  N   GLN   103      -9.198  58.403  88.729  1.00 32.76           N  
ATOM    655  CA  GLN   103      -9.647  57.781  87.497  1.00 34.23           C  
ATOM    656  C   GLN   103      -8.885  58.425  86.332  1.00 34.29           C  
ATOM    657  O   GLN   103      -8.541  59.612  86.367  1.00 33.98           O  
ATOM    658  CB  GLN   103     -11.156  58.023  87.369  1.00 34.31           C  
ATOM    659  CG  GLN   103     -11.865  57.181  86.347  1.00 37.86           C  
ATOM    660  CD  GLN   103     -13.385  57.190  86.515  1.00 41.83           C  
ATOM    661  OE1 GLN   103     -13.914  57.285  87.638  1.00 42.19           O  
ATOM    662  NE2 GLN   103     -14.096  57.074  85.393  1.00 43.24           N  
ATOM    663  N   TYR   104      -8.605  57.629  85.309  1.00 35.13           N  
ATOM    664  CA  TYR   104      -7.948  58.123  84.106  1.00 35.78           C  
ATOM    665  C   TYR   104      -8.743  59.313  83.541  1.00 36.02           C  
ATOM    666  O   TYR   104      -9.941  59.215  83.309  1.00 35.75           O  
ATOM    667  CB  TYR   104      -7.820  56.981  83.094  1.00 36.40           C  
ATOM    668  CG  TYR   104      -7.171  57.363  81.791  1.00 36.92           C  
ATOM    669  CD1 TYR   104      -7.936  57.522  80.635  1.00 39.21           C  
ATOM    670  CD2 TYR   104      -5.800  57.553  81.705  1.00 38.55           C  
ATOM    671  CE1 TYR   104      -7.348  57.867  79.417  1.00 39.55           C  
ATOM    672  CE2 TYR   104      -5.195  57.903  80.498  1.00 40.36           C  
ATOM    673  CZ  TYR   104      -5.983  58.058  79.356  1.00 40.61           C  
ATOM    674  OH  TYR   104      -5.405  58.406  78.154  1.00 40.90           O  
ATOM    675  N   GLY   105      -8.078  60.449  83.370  1.00 36.50           N  
ATOM    676  CA  GLY   105      -8.768  61.668  82.957  1.00 37.23           C  
ATOM    677  C   GLY   105      -8.831  62.739  84.035  1.00 37.87           C  
ATOM    678  O   GLY   105      -9.118  63.899  83.734  1.00 37.92           O  
ATOM    679  N   ASP   106      -8.583  62.367  85.291  1.00 38.46           N  
ATOM    680  CA  ASP   106      -8.478  63.365  86.364  1.00 39.49           C  
ATOM    681  C   ASP   106      -7.270  64.254  86.105  1.00 39.91           C  
ATOM    682  O   ASP   106      -6.240  63.777  85.614  1.00 39.88           O  
ATOM    683  CB  ASP   106      -8.330  62.701  87.738  1.00 39.68           C  
ATOM    684  CG  ASP   106      -9.597  62.010  88.197  1.00 40.27           C  
ATOM    685  OD1 ASP   106     -10.682  62.302  87.653  1.00 41.42           O  
ATOM    686  OD2 ASP   106      -9.498  61.167  89.110  1.00 40.80           O  
ATOM    687  N   CYS   107      -7.391  65.536  86.428  1.00 40.51           N  
ATOM    688  CA  CYS   107      -6.305  66.471  86.137  1.00 41.67           C  
ATOM    689  C   CYS   107      -5.871  67.362  87.300  1.00 41.18           C  
ATOM    690  O   CYS   107      -5.196  68.384  87.097  1.00 41.26           O  
ATOM    691  CB  CYS   107      -6.605  67.298  84.881  1.00 42.04           C  
ATOM    692  SG  CYS   107      -8.220  68.010  84.829  1.00 46.75           S  
ATOM    693  N   ASP   108      -6.234  66.968  88.518  1.00 40.47           N  
ATOM    694  CA  ASP   108      -5.666  67.629  89.675  1.00 39.66           C  
ATOM    695  C   ASP   108      -5.020  66.684  90.694  1.00 38.68           C  
ATOM    696  O   ASP   108      -5.312  65.482  90.737  1.00 38.27           O  
ATOM    697  CB  ASP   108      -6.647  68.638  90.298  1.00 40.29           C  
ATOM    698  CG  ASP   108      -7.538  68.038  91.384  1.00 42.21           C  
ATOM    699  OD1 ASP   108      -7.290  66.908  91.867  1.00 43.59           O  
ATOM    700  OD2 ASP   108      -8.497  68.739  91.781  1.00 45.10           O  
ATOM    701  N   MET   109      -4.151  67.269  91.509  1.00 37.05           N  
ATOM    702  CA  MET   109      -3.234  66.578  92.390  1.00 36.34           C  
ATOM    703  C   MET   109      -3.887  65.849  93.553  1.00 34.68           C  
ATOM    704  O   MET   109      -3.212  65.166  94.322  1.00 34.59           O  
ATOM    705  CB  MET   109      -2.299  67.617  92.960  1.00 36.93           C  
ATOM    706  CG  MET   109      -0.910  67.150  93.138  1.00 40.36           C  
ATOM    707  SD  MET   109       0.124  68.730  93.496  1.00 48.78          SE  
ATOM    708  CE  MET   109      -0.125  69.692  91.812  1.00 44.22           C  
ATOM    709  N   THR   110      -5.193  66.035  93.689  1.00 32.86           N  
ATOM    710  CA  THR   110      -6.012  65.359  94.686  1.00 31.65           C  
ATOM    711  C   THR   110      -5.989  63.831  94.520  1.00 30.01           C  
ATOM    712  O   THR   110      -6.122  63.090  95.496  1.00 28.98           O  
ATOM    713  CB  THR   110      -7.454  65.968  94.673  1.00 31.72           C  
ATOM    714  OG1 THR   110      -7.671  66.687  95.893  1.00 33.84           O  
ATOM    715  CG2 THR   110      -8.550  64.924  94.499  1.00 33.00           C  
ATOM    716  N   THR   111      -5.802  63.373  93.280  1.00 28.02           N  
ATOM    717  CA  THR   111      -5.769  61.943  92.998  1.00 26.72           C  
ATOM    718  C   THR   111      -4.450  61.564  92.352  1.00 25.77           C  
ATOM    719  O   THR   111      -3.734  62.423  91.830  1.00 26.17           O  
ATOM    720  CB  THR   111      -6.949  61.486  92.097  1.00 26.51           C  
ATOM    721  OG1 THR   111      -6.889  62.147  90.829  1.00 24.76           O  
ATOM    722  CG2 THR   111      -8.306  61.765  92.765  1.00 27.14           C  
ATOM    723  N   PHE   112      -4.134  60.278  92.387  1.00 24.41           N  
ATOM    724  CA  PHE   112      -2.887  59.773  91.805  1.00 23.76           C  
ATOM    725  C   PHE   112      -2.831  60.030  90.300  1.00 22.96           C  
ATOM    726  O   PHE   112      -1.805  60.440  89.782  1.00 22.79           O  
ATOM    727  CB  PHE   112      -2.743  58.280  92.090  1.00 23.16           C  
ATOM    728  CG  PHE   112      -1.392  57.722  91.742  1.00 23.18           C  
ATOM    729  CD1 PHE   112      -0.239  58.220  92.343  1.00 21.31           C  
ATOM    730  CD2 PHE   112      -1.274  56.684  90.832  1.00 21.54           C  
ATOM    731  CE1 PHE   112       1.008  57.692  92.032  1.00 21.29           C  
ATOM    732  CE2 PHE   112      -0.022  56.151  90.520  1.00 20.81           C  
ATOM    733  CZ  PHE   112       1.116  56.663  91.118  1.00 18.00           C  
ATOM    734  N   TYR   113      -3.944  59.794  89.615  1.00 22.83           N  
ATOM    735  CA  TYR   113      -4.042  60.023  88.171  1.00 22.92           C  
ATOM    736  C   TYR   113      -3.890  61.488  87.798  1.00 23.21           C  
ATOM    737  O   TYR   113      -3.168  61.829  86.853  1.00 23.02           O  
ATOM    738  CB  TYR   113      -5.376  59.522  87.645  1.00 23.04           C  
ATOM    739  CG  TYR   113      -5.408  58.077  87.223  1.00 22.24           C  
ATOM    740  CD1 TYR   113      -4.870  57.668  85.986  1.00 22.61           C  
ATOM    741  CD2 TYR   113      -6.026  57.117  88.021  1.00 23.87           C  
ATOM    742  CE1 TYR   113      -4.936  56.328  85.576  1.00 22.07           C  
ATOM    743  CE2 TYR   113      -6.089  55.778  87.628  1.00 21.82           C  
ATOM    744  CZ  TYR   113      -5.545  55.396  86.411  1.00 23.62           C  
ATOM    745  OH  TYR   113      -5.622  54.081  86.035  1.00 23.78           O  
ATOM    746  N   GLY   114      -4.577  62.354  88.543  1.00 23.49           N  
ATOM    747  CA  GLY   114      -4.466  63.792  88.352  1.00 23.02           C  
ATOM    748  C   GLY   114      -3.066  64.297  88.614  1.00 23.00           C  
ATOM    749  O   GLY   114      -2.565  65.149  87.885  1.00 22.91           O  
ATOM    750  N   ALA   115      -2.412  63.761  89.639  1.00 23.71           N  
ATOM    751  CA  ALA   115      -1.068  64.220  89.980  1.00 24.24           C  
ATOM    752  C   ALA   115      -0.004  63.791  88.952  1.00 25.24           C  
ATOM    753  O   ALA   115       0.869  64.591  88.615  1.00 25.15           O  
ATOM    754  CB  ALA   115      -0.694  63.814  91.371  1.00 23.71           C  
ATOM    755  N   LEU   116      -0.091  62.559  88.441  1.00 26.15           N  
ATOM    756  CA  LEU   116       0.710  62.137  87.279  1.00 27.45           C  
ATOM    757  C   LEU   116       0.559  63.071  86.072  1.00 28.67           C  
ATOM    758  O   LEU   116       1.560  63.464  85.470  1.00 28.49           O  
ATOM    759  CB  LEU   116       0.379  60.697  86.862  1.00 27.43           C  
ATOM    760  CG  LEU   116       0.855  59.591  87.813  1.00 28.07           C  
ATOM    761  CD1 LEU   116       0.160  58.264  87.508  1.00 29.30           C  
ATOM    762  CD2 LEU   116       2.374  59.447  87.749  1.00 28.79           C  
ATOM    763  N   MET   117      -0.678  63.441  85.731  1.00 30.11           N  
ATOM    764  CA  MET   117      -0.916  64.337  84.592  1.00 32.25           C  
ATOM    765  C   MET   117      -0.179  65.677  84.719  1.00 31.82           C  
ATOM    766  O   MET   117       0.461  66.148  83.774  1.00 31.21           O  
ATOM    767  CB  MET   117      -2.410  64.591  84.382  1.00 33.42           C  
ATOM    768  CG  MET   117      -2.671  65.595  83.270  1.00 40.00           C  
ATOM    769  SD  MET   117      -4.555  65.868  82.897  1.00 60.20          SE  
ATOM    770  CE  MET   117      -5.032  64.090  82.167  1.00 54.27           C  
ATOM    771  N   MET   118      -0.273  66.289  85.893  1.00 31.76           N  
ATOM    772  CA  MET   118       0.401  67.546  86.103  1.00 32.45           C  
ATOM    773  C   MET   118       1.910  67.389  86.149  1.00 30.58           C  
ATOM    774  O   MET   118       2.624  68.221  85.591  1.00 30.21           O  
ATOM    775  CB  MET   118      -0.127  68.239  87.337  1.00 33.80           C  
ATOM    776  CG  MET   118      -1.489  68.841  87.087  1.00 41.99           C  
ATOM    777  SD  MET   118      -2.264  69.263  88.791  1.00 61.36          SE  
ATOM    778  CE  MET   118      -1.459  71.050  88.978  1.00 56.21           C  
ATOM    779  N   LEU   119       2.389  66.327  86.791  1.00 28.51           N  
ATOM    780  CA  LEU   119       3.822  66.036  86.805  1.00 27.08           C  
ATOM    781  C   LEU   119       4.349  65.893  85.375  1.00 26.01           C  
ATOM    782  O   LEU   119       5.259  66.602  84.983  1.00 25.32           O  
ATOM    783  CB  LEU   119       4.123  64.764  87.596  1.00 26.39           C  
ATOM    784  CG  LEU   119       5.456  64.562  88.350  1.00 27.36           C  
ATOM    785  CD1 LEU   119       5.797  63.083  88.416  1.00 26.30           C  
ATOM    786  CD2 LEU   119       6.631  65.318  87.791  1.00 25.64           C  
ATOM    787  N   LEU   120       3.750  64.983  84.613  1.00 25.54           N  
ATOM    788  CA  LEU   120       4.134  64.720  83.227  1.00 25.55           C  
ATOM    789  C   LEU   120       4.025  65.933  82.295  1.00 25.84           C  
ATOM    790  O   LEU   120       4.877  66.108  81.430  1.00 26.16           O  
ATOM    791  CB  LEU   120       3.312  63.554  82.659  1.00 25.28           C  
ATOM    792  CG  LEU   120       3.658  62.200  83.277  1.00 25.04           C  
ATOM    793  CD1 LEU   120       2.578  61.166  82.986  1.00 25.38           C  
ATOM    794  CD2 LEU   120       5.033  61.741  82.810  1.00 24.18           C  
ATOM    795  N   THR   121       2.980  66.745  82.455  1.00 25.38           N  
ATOM    796  CA  THR   121       2.842  67.982  81.678  1.00 26.40           C  
ATOM    797  C   THR   121       3.944  68.983  82.054  1.00 26.15           C  
ATOM    798  O   THR   121       4.596  69.550  81.190  1.00 26.51           O  
ATOM    799  CB  THR   121       1.455  68.625  81.871  1.00 26.48           C  
ATOM    800  OG1 THR   121       0.450  67.662  81.533  1.00 26.55           O  
ATOM    801  CG2 THR   121       1.294  69.866  80.978  1.00 27.08           C  
ATOM    802  N   GLY   122       4.172  69.160  83.351  1.00 26.19           N  
ATOM    803  CA  GLY   122       5.263  69.997  83.834  1.00 25.67           C  
ATOM    804  C   GLY   122       6.608  69.649  83.227  1.00 25.32           C  
ATOM    805  O   GLY   122       7.340  70.536  82.762  1.00 25.24           O  
ATOM    806  N   LEU   123       6.933  68.357  83.221  1.00 25.02           N  
ATOM    807  CA  LEU   123       8.237  67.892  82.750  1.00 24.92           C  
ATOM    808  C   LEU   123       8.438  68.113  81.253  1.00 25.50           C  
ATOM    809  O   LEU   123       9.530  68.493  80.818  1.00 25.71           O  
ATOM    810  CB  LEU   123       8.433  66.415  83.085  1.00 24.42           C  
ATOM    811  CG  LEU   123       8.593  66.025  84.556  1.00 24.06           C  
ATOM    812  CD1 LEU   123       8.433  64.526  84.748  1.00 21.79           C  
ATOM    813  CD2 LEU   123       9.923  66.497  85.105  1.00 22.87           C  
ATOM    814  N   GLN   124       7.386  67.856  80.476  1.00 26.09           N  
ATOM    815  CA  GLN   124       7.455  67.911  79.019  1.00 27.20           C  
ATOM    816  C   GLN   124       7.425  69.351  78.528  1.00 28.08           C  
ATOM    817  O   GLN   124       7.993  69.661  77.485  1.00 28.33           O  
ATOM    818  CB  GLN   124       6.305  67.125  78.374  1.00 27.23           C  
ATOM    819  CG  GLN   124       6.326  65.611  78.578  1.00 27.69           C  
ATOM    820  CD  GLN   124       7.549  64.931  77.965  1.00 29.41           C  
ATOM    821  OE1 GLN   124       8.684  65.277  78.285  1.00 29.73           O  
ATOM    822  NE2 GLN   124       7.318  63.947  77.094  1.00 27.33           N  
ATOM    823  N   THR   125       6.759  70.219  79.297  1.00 28.60           N  
ATOM    824  CA  THR   125       6.675  71.637  78.998  1.00 28.65           C  
ATOM    825  C   THR   125       8.009  72.298  79.267  1.00 28.57           C  
ATOM    826  O   THR   125       8.499  73.049  78.427  1.00 28.57           O  
ATOM    827  CB  THR   125       5.572  72.310  79.821  1.00 28.71           C  
ATOM    828  OG1 THR   125       4.324  71.670  79.529  1.00 30.08           O  
ATOM    829  CG2 THR   125       5.463  73.788  79.497  1.00 28.61           C  
ATOM    830  N   ASN   126       8.619  71.990  80.412  1.00 28.24           N  
ATOM    831  CA  ASN   126       9.821  72.729  80.835  1.00 27.99           C  
ATOM    832  C   ASN   126      11.166  72.122  80.453  1.00 27.56           C  
ATOM    833  O   ASN   126      12.159  72.825  80.422  1.00 27.81           O  
ATOM    834  CB  ASN   126       9.753  73.051  82.329  1.00 27.84           C  
ATOM    835  CG  ASN   126       8.581  73.952  82.662  1.00 28.75           C  
ATOM    836  OD1 ASN   126       8.604  75.150  82.359  1.00 30.03           O  
ATOM    837  ND2 ASN   126       7.533  73.380  83.256  1.00 29.36           N  
ATOM    838  N   TRP   127      11.196  70.822  80.181  1.00 27.14           N  
ATOM    839  CA  TRP   127      12.403  70.152  79.671  1.00 26.90           C  
ATOM    840  C   TRP   127      12.050  69.314  78.425  1.00 26.70           C  
ATOM    841  O   TRP   127      12.178  68.087  78.432  1.00 26.71           O  
ATOM    842  CB  TRP   127      13.023  69.268  80.750  1.00 26.62           C  
ATOM    843  CG  TRP   127      13.482  70.007  81.978  1.00 28.17           C  
ATOM    844  CD1 TRP   127      14.727  70.541  82.205  1.00 27.85           C  
ATOM    845  CD2 TRP   127      12.712  70.276  83.157  1.00 27.66           C  
ATOM    846  NE1 TRP   127      14.770  71.120  83.448  1.00 28.47           N  
ATOM    847  CE2 TRP   127      13.550  70.976  84.052  1.00 28.34           C  
ATOM    848  CE3 TRP   127      11.396  69.992  83.544  1.00 27.20           C  
ATOM    849  CZ2 TRP   127      13.112  71.402  85.310  1.00 27.70           C  
ATOM    850  CZ3 TRP   127      10.963  70.414  84.790  1.00 27.16           C  
ATOM    851  CH2 TRP   127      11.820  71.115  85.657  1.00 27.66           C  
ATOM    852  N   PRO   128      11.602  69.979  77.347  1.00 26.96           N  
ATOM    853  CA  PRO   128      11.097  69.259  76.162  1.00 26.72           C  
ATOM    854  C   PRO   128      12.123  68.353  75.463  1.00 27.20           C  
ATOM    855  O   PRO   128      11.741  67.319  74.908  1.00 27.21           O  
ATOM    856  CB  PRO   128      10.628  70.383  75.235  1.00 26.28           C  
ATOM    857  CG  PRO   128      11.361  71.617  75.704  1.00 26.59           C  
ATOM    858  CD  PRO   128      11.534  71.449  77.177  1.00 26.40           C  
ATOM    859  N   THR   129      13.403  68.717  75.509  1.00 27.01           N  
ATOM    860  CA  THR   129      14.426  67.917  74.851  1.00 27.57           C  
ATOM    861  C   THR   129      15.200  66.987  75.805  1.00 27.53           C  
ATOM    862  O   THR   129      16.068  66.249  75.373  1.00 28.14           O  
ATOM    863  CB  THR   129      15.412  68.806  74.047  1.00 28.20           C  
ATOM    864  OG1 THR   129      16.239  69.556  74.945  1.00 29.19           O  
ATOM    865  CG2 THR   129      14.661  69.767  73.123  1.00 27.36           C  
ATOM    866  N   VAL   130      14.886  67.008  77.094  1.00 27.24           N  
ATOM    867  CA  VAL   130      15.634  66.195  78.070  1.00 26.82           C  
ATOM    868  C   VAL   130      15.071  64.767  78.128  1.00 26.62           C  
ATOM    869  O   VAL   130      13.859  64.602  78.242  1.00 26.37           O  
ATOM    870  CB  VAL   130      15.616  66.848  79.481  1.00 26.76           C  
ATOM    871  CG1 VAL   130      16.149  65.906  80.540  1.00 26.41           C  
ATOM    872  CG2 VAL   130      16.415  68.152  79.473  1.00 26.48           C  
ATOM    873  N   PRO   131      15.945  63.739  78.017  1.00 26.21           N  
ATOM    874  CA  PRO   131      15.478  62.368  78.190  1.00 26.25           C  
ATOM    875  C   PRO   131      14.985  62.114  79.615  1.00 26.14           C  
ATOM    876  O   PRO   131      15.609  62.562  80.585  1.00 25.84           O  
ATOM    877  CB  PRO   131      16.722  61.516  77.877  1.00 26.02           C  
ATOM    878  CG  PRO   131      17.874  62.426  78.034  1.00 26.15           C  
ATOM    879  CD  PRO   131      17.384  63.795  77.689  1.00 26.35           C  
ATOM    880  N   LYS   132      13.858  61.418  79.726  1.00 25.78           N  
ATOM    881  CA  LYS   132      13.234  61.163  81.021  1.00 25.71           C  
ATOM    882  C   LYS   132      12.756  59.736  81.107  1.00 25.24           C  
ATOM    883  O   LYS   132      12.333  59.156  80.113  1.00 24.90           O  
ATOM    884  CB  LYS   132      11.998  62.046  81.223  1.00 25.90           C  
ATOM    885  CG  LYS   132      12.182  63.476  80.865  1.00 27.16           C  
ATOM    886  CD  LYS   132      10.850  64.162  80.703  1.00 26.06           C  
ATOM    887  CE  LYS   132      11.084  65.555  80.189  1.00 24.87           C  
ATOM    888  NZ  LYS   132      11.337  65.505  78.728  1.00 23.54           N  
ATOM    889  N   LEU   133      12.794  59.182  82.309  1.00 25.03           N  
ATOM    890  CA  LEU   133      12.075  57.950  82.554  1.00 24.95           C  
ATOM    891  C   LEU   133      11.354  57.928  83.901  1.00 23.86           C  
ATOM    892  O   LEU   133      11.751  58.613  84.853  1.00 24.21           O  
ATOM    893  CB  LEU   133      12.956  56.706  82.340  1.00 25.35           C  
ATOM    894  CG  LEU   133      14.182  56.302  83.159  1.00 26.96           C  
ATOM    895  CD1 LEU   133      14.113  56.760  84.572  1.00 31.16           C  
ATOM    896  CD2 LEU   133      14.299  54.800  83.151  1.00 26.58           C  
ATOM    897  N   PHE   134      10.285  57.140  83.957  0.50 23.40           N  
ATOM    899  CA  PHE   134       9.521  56.903  85.173  0.50 22.63           C  
ATOM    901  C   PHE   134       9.829  55.519  85.703  0.50 22.28           C  
ATOM    903  O   PHE   134       9.750  54.538  84.963  0.50 22.15           O  
ATOM    905  CB  PHE   134       8.022  57.026  84.894  0.50 22.66           C  
ATOM    907  CG  PHE   134       7.452  58.362  85.254  0.50 22.35           C  
ATOM    909  CD1 PHE   134       6.465  58.467  86.221  0.50 21.69           C  
ATOM    911  CD2 PHE   134       7.921  59.524  84.639  0.50 22.86           C  
ATOM    913  CE1 PHE   134       5.936  59.705  86.568  0.50 22.00           C  
ATOM    915  CE2 PHE   134       7.403  60.769  84.985  0.50 21.70           C  
ATOM    917  CZ  PHE   134       6.412  60.857  85.948  0.50 22.06           C  
ATOM    919  N   ILE   135      10.193  55.449  86.980  1.00 21.93           N  
ATOM    920  CA  ILE   135      10.504  54.175  87.630  1.00 21.72           C  
ATOM    921  C   ILE   135       9.441  53.895  88.688  1.00 22.19           C  
ATOM    922  O   ILE   135       9.219  54.718  89.569  1.00 22.43           O  
ATOM    923  CB  ILE   135      11.913  54.187  88.278  1.00 20.69           C  
ATOM    924  CG1 ILE   135      12.983  54.583  87.244  1.00 20.29           C  
ATOM    925  CG2 ILE   135      12.222  52.834  88.850  1.00 19.50           C  
ATOM    926  CD1 ILE   135      14.264  55.076  87.861  1.00 20.69           C  
ATOM    927  N   SER   136       8.770  52.750  88.592  1.00 23.28           N  
ATOM    928  CA  SER   136       7.832  52.348  89.652  1.00 24.17           C  
ATOM    929  C   SER   136       8.381  51.178  90.475  1.00 24.54           C  
ATOM    930  O   SER   136       9.102  50.325  89.952  1.00 25.27           O  
ATOM    931  CB  SER   136       6.464  52.019  89.072  1.00 23.77           C  
ATOM    932  OG  SER   136       6.543  50.927  88.179  1.00 25.34           O  
ATOM    933  N   ALA   137       8.015  51.139  91.752  1.00 24.95           N  
ATOM    934  CA  ALA   137       8.660  50.288  92.754  1.00 24.88           C  
ATOM    935  C   ALA   137       8.330  48.808  92.696  1.00 24.79           C  
ATOM    936  O   ALA   137       7.309  48.394  92.160  1.00 24.86           O  
ATOM    937  CB  ALA   137       8.362  50.816  94.147  1.00 25.06           C  
ATOM    938  N   ILE   138       9.234  48.026  93.274  1.00 24.84           N  
ATOM    939  CA  ILE   138       9.046  46.607  93.581  1.00 25.08           C  
ATOM    940  C   ILE   138       7.764  46.368  94.405  1.00 25.08           C  
ATOM    941  O   ILE   138       7.365  47.222  95.218  1.00 24.89           O  
ATOM    942  CB  ILE   138      10.299  46.081  94.327  1.00 25.23           C  
ATOM    943  CG1 ILE   138      11.527  46.221  93.415  1.00 25.34           C  
ATOM    944  CG2 ILE   138      10.131  44.613  94.792  1.00 24.97           C  
ATOM    945  CD1 ILE   138      12.794  46.515  94.152  1.00 26.74           C  
ATOM    946  N   HIS   139       7.116  45.229  94.147  1.00 25.14           N  
ATOM    947  CA  HIS   139       5.995  44.731  94.950  1.00 25.80           C  
ATOM    948  C   HIS   139       6.453  44.667  96.403  1.00 26.13           C  
ATOM    949  O   HIS   139       7.440  44.003  96.714  1.00 26.14           O  
ATOM    950  CB  HIS   139       5.572  43.327  94.474  1.00 25.79           C  
ATOM    951  CG  HIS   139       4.198  42.913  94.919  1.00 26.75           C  
ATOM    952  ND1 HIS   139       3.773  42.998  96.230  1.00 27.61           N  
ATOM    953  CD2 HIS   139       3.158  42.391  94.227  1.00 27.73           C  
ATOM    954  CE1 HIS   139       2.526  42.568  96.323  1.00 26.09           C  
ATOM    955  NE2 HIS   139       2.131  42.189  95.123  1.00 28.14           N  
ATOM    956  N   ILE   140       5.756  45.376  97.283  1.00 26.15           N  
ATOM    957  CA  ILE   140       6.172  45.440  98.683  1.00 26.50           C  
ATOM    958  C   ILE   140       5.532  44.336  99.514  1.00 26.90           C  
ATOM    959  O   ILE   140       4.557  43.720  99.090  1.00 27.41           O  
ATOM    960  CB  ILE   140       5.876  46.826  99.324  1.00 26.33           C  
ATOM    961  CG1 ILE   140       4.365  47.049  99.466  1.00 25.41           C  
ATOM    962  CG2 ILE   140       6.581  47.950  98.545  1.00 25.94           C  
ATOM    963  CD1 ILE   140       3.984  48.307 100.186  1.00 27.23           C  
ATOM    964  N   GLY   141       6.095  44.087 100.692  1.00 27.64           N  
ATOM    965  CA  GLY   141       5.548  43.113 101.638  1.00 28.55           C  
ATOM    966  C   GLY   141       4.622  43.780 102.636  1.00 29.20           C  
ATOM    967  O   GLY   141       4.144  44.893 102.392  1.00 28.99           O  
ATOM    968  N   SER   142       4.382  43.109 103.761  1.00 29.84           N  
ATOM    969  CA  SER   142       3.380  43.540 104.736  1.00 31.30           C  
ATOM    970  C   SER   142       3.942  43.907 106.111  1.00 31.65           C  
ATOM    971  O   SER   142       3.188  44.072 107.068  1.00 32.26           O  
ATOM    972  CB  SER   142       2.321  42.449 104.904  1.00 31.53           C  
ATOM    973  OG  SER   142       1.381  42.495 103.846  1.00 33.45           O  
ATOM    974  N   ASP   143       5.257  44.040 106.211  1.00 31.98           N  
ATOM    975  CA  ASP   143       5.890  44.153 107.513  1.00 32.60           C  
ATOM    976  C   ASP   143       6.362  45.553 107.886  1.00 31.93           C  
ATOM    977  O   ASP   143       6.887  45.747 108.977  1.00 31.80           O  
ATOM    978  CB  ASP   143       7.035  43.142 107.627  1.00 33.15           C  
ATOM    979  CG  ASP   143       6.541  41.691 107.624  1.00 36.94           C  
ATOM    980  OD1 ASP   143       5.383  41.431 108.050  1.00 39.64           O  
ATOM    981  OD2 ASP   143       7.320  40.801 107.195  1.00 40.59           O  
ATOM    982  N   PHE   144       6.163  46.527 106.997  1.00 31.36           N  
ATOM    983  CA  PHE   144       6.570  47.911 107.277  1.00 30.84           C  
ATOM    984  C   PHE   144       5.682  48.646 108.303  1.00 30.96           C  
ATOM    985  O   PHE   144       6.197  49.295 109.207  1.00 31.21           O  
ATOM    986  CB  PHE   144       6.683  48.741 105.985  1.00 30.11           C  
ATOM    987  CG  PHE   144       7.117  50.166 106.219  1.00 28.46           C  
ATOM    988  CD1 PHE   144       8.458  50.471 106.479  1.00 25.48           C  
ATOM    989  CD2 PHE   144       6.184  51.199 106.202  1.00 25.59           C  
ATOM    990  CE1 PHE   144       8.867  51.792 106.703  1.00 23.60           C  
ATOM    991  CE2 PHE   144       6.580  52.534 106.429  1.00 25.58           C  
ATOM    992  CZ  PHE   144       7.923  52.826 106.679  1.00 25.61           C  
ATOM    993  N   GLY   145       4.363  48.573 108.134  1.00 30.99           N  
ATOM    994  CA  GLY   145       3.431  49.286 109.016  1.00 31.00           C  
ATOM    995  C   GLY   145       2.374  50.048 108.234  1.00 31.15           C  
ATOM    996  O   GLY   145       2.390  50.044 107.001  1.00 31.01           O  
ATOM    997  N   GLY   146       1.454  50.704 108.949  1.00 30.91           N  
ATOM    998  CA  GLY   146       0.372  51.461 108.313  1.00 30.59           C  
ATOM    999  C   GLY   146      -0.327  50.649 107.237  1.00 30.67           C  
ATOM   1000  O   GLY   146      -0.593  49.459 107.441  1.00 30.87           O  
ATOM   1001  N   SER   147      -0.606  51.280 106.095  1.00 29.93           N  
ATOM   1002  CA  SER   147      -1.299  50.623 104.986  1.00 29.64           C  
ATOM   1003  C   SER   147      -0.330  50.062 103.950  1.00 29.10           C  
ATOM   1004  O   SER   147      -0.702  49.868 102.780  1.00 28.72           O  
ATOM   1005  CB  SER   147      -2.265  51.581 104.292  1.00 29.98           C  
ATOM   1006  OG  SER   147      -3.230  52.106 105.191  1.00 32.25           O  
ATOM   1007  N   PHE   148       0.910  49.812 104.373  1.00 27.73           N  
ATOM   1008  CA  PHE   148       1.900  49.221 103.490  1.00 27.13           C  
ATOM   1009  C   PHE   148       1.748  47.702 103.498  1.00 26.81           C  
ATOM   1010  O   PHE   148       2.336  47.014 104.323  1.00 27.11           O  
ATOM   1011  CB  PHE   148       3.311  49.638 103.904  1.00 26.68           C  
ATOM   1012  CG  PHE   148       3.662  51.045 103.533  1.00 24.66           C  
ATOM   1013  CD1 PHE   148       3.423  52.094 104.419  1.00 24.06           C  
ATOM   1014  CD2 PHE   148       4.253  51.324 102.307  1.00 22.89           C  
ATOM   1015  CE1 PHE   148       3.760  53.403 104.081  1.00 23.02           C  
ATOM   1016  CE2 PHE   148       4.591  52.625 101.956  1.00 23.51           C  
ATOM   1017  CZ  PHE   148       4.344  53.670 102.850  1.00 23.08           C  
ATOM   1018  N   SER   149       0.949  47.189 102.574  1.00 26.60           N  
ATOM   1019  CA  SER   149       0.545  45.781 102.605  1.00 26.84           C  
ATOM   1020  C   SER   149       0.866  45.073 101.286  1.00 26.87           C  
ATOM   1021  O   SER   149       0.934  45.699 100.223  1.00 26.27           O  
ATOM   1022  CB  SER   149      -0.956  45.691 102.960  1.00 27.24           C  
ATOM   1023  OG  SER   149      -1.544  44.431 102.683  1.00 27.85           O  
ATOM   1024  N   ALA   150       1.068  43.763 101.359  1.00 26.91           N  
ATOM   1025  CA  ALA   150       1.282  42.963 100.165  1.00 26.95           C  
ATOM   1026  C   ALA   150      -0.028  42.748  99.391  1.00 27.23           C  
ATOM   1027  O   ALA   150      -0.014  42.283  98.249  1.00 27.17           O  
ATOM   1028  CB  ALA   150       1.929  41.633 100.535  1.00 27.41           C  
ATOM   1029  N   VAL   151      -1.149  43.119 100.008  1.00 27.32           N  
ATOM   1030  CA  VAL   151      -2.485  42.811  99.491  1.00 27.58           C  
ATOM   1031  C   VAL   151      -3.228  44.066  98.972  1.00 27.73           C  
ATOM   1032  O   VAL   151      -3.301  44.276  97.755  1.00 27.57           O  
ATOM   1033  CB  VAL   151      -3.347  42.043 100.561  1.00 27.82           C  
ATOM   1034  CG1 VAL   151      -4.699  41.642  99.993  1.00 28.32           C  
ATOM   1035  CG2 VAL   151      -2.617  40.807 101.075  1.00 27.50           C  
ATOM   1036  N   THR   152      -3.774  44.873  99.892  1.00 26.69           N  
ATOM   1037  CA  THR   152      -4.488  46.115  99.574  1.00 26.93           C  
ATOM   1038  C   THR   152      -4.109  47.206 100.594  1.00 25.77           C  
ATOM   1039  O   THR   152      -3.671  46.891 101.694  1.00 25.62           O  
ATOM   1040  CB  THR   152      -6.034  45.920  99.595  1.00 27.27           C  
ATOM   1041  OG1 THR   152      -6.400  45.093 100.709  1.00 29.74           O  
ATOM   1042  CG2 THR   152      -6.543  45.245  98.316  1.00 28.47           C  
ATOM   1043  N   ASN   153      -4.249  48.478 100.219  1.00 24.99           N  
ATOM   1044  CA  ASN   153      -4.034  49.593 101.155  1.00 24.68           C  
ATOM   1045  C   ASN   153      -5.337  49.957 101.883  1.00 25.00           C  
ATOM   1046  O   ASN   153      -6.337  49.288 101.693  1.00 25.05           O  
ATOM   1047  CB  ASN   153      -3.425  50.811 100.439  1.00 23.85           C  
ATOM   1048  CG  ASN   153      -4.379  51.462  99.440  1.00 22.53           C  
ATOM   1049  OD1 ASN   153      -5.570  51.131  99.371  1.00 22.16           O  
ATOM   1050  ND2 ASN   153      -3.853  52.402  98.659  1.00 17.41           N  
ATOM   1051  N   GLY   154      -5.330  51.003 102.712  1.00 25.70           N  
ATOM   1052  CA  GLY   154      -6.526  51.406 103.473  1.00 26.43           C  
ATOM   1053  C   GLY   154      -7.744  51.822 102.645  1.00 27.58           C  
ATOM   1054  O   GLY   154      -8.877  51.847 103.147  1.00 27.97           O  
ATOM   1055  N   LEU   155      -7.523  52.142 101.372  1.00 27.95           N  
ATOM   1056  CA  LEU   155      -8.610  52.513 100.482  1.00 28.50           C  
ATOM   1057  C   LEU   155      -9.071  51.297  99.692  1.00 28.43           C  
ATOM   1058  O   LEU   155      -9.970  51.393  98.870  1.00 28.82           O  
ATOM   1059  CB  LEU   155      -8.166  53.617  99.520  1.00 28.67           C  
ATOM   1060  CG  LEU   155      -7.543  54.864 100.130  1.00 29.99           C  
ATOM   1061  CD1 LEU   155      -7.011  55.730  99.017  1.00 31.39           C  
ATOM   1062  CD2 LEU   155      -8.553  55.630 100.994  1.00 31.65           C  
ATOM   1063  N   GLY   156      -8.429  50.160  99.924  1.00 28.40           N  
ATOM   1064  CA  GLY   156      -8.811  48.921  99.257  1.00 28.37           C  
ATOM   1065  C   GLY   156      -8.277  48.692  97.856  1.00 28.29           C  
ATOM   1066  O   GLY   156      -8.681  47.729  97.212  1.00 28.30           O  
ATOM   1067  N   TYR   157      -7.384  49.564  97.369  1.00 28.22           N  
ATOM   1068  CA  TYR   157      -6.725  49.332  96.084  1.00 27.86           C  
ATOM   1069  C   TYR   157      -5.494  48.467  96.279  1.00 27.58           C  
ATOM   1070  O   TYR   157      -4.962  48.368  97.379  1.00 27.89           O  
ATOM   1071  CB  TYR   157      -6.306  50.633  95.403  1.00 28.45           C  
ATOM   1072  CG  TYR   157      -7.430  51.579  95.093  1.00 29.17           C  
ATOM   1073  CD1 TYR   157      -8.298  51.342  94.030  1.00 30.13           C  
ATOM   1074  CD2 TYR   157      -7.628  52.720  95.873  1.00 31.31           C  
ATOM   1075  CE1 TYR   157      -9.336  52.218  93.750  1.00 31.34           C  
ATOM   1076  CE2 TYR   157      -8.663  53.603  95.606  1.00 32.69           C  
ATOM   1077  CZ  TYR   157      -9.507  53.347  94.546  1.00 33.05           C  
ATOM   1078  OH  TYR   157     -10.521  54.231  94.291  1.00 34.32           O  
ATOM   1079  N   ARG   158      -5.050  47.851  95.188  1.00 27.09           N  
ATOM   1080  CA  ARG   158      -3.840  47.042  95.164  0.50 26.52           C  
ATOM   1082  C   ARG   158      -2.697  47.889  94.608  1.00 26.08           C  
ATOM   1083  O   ARG   158      -2.936  48.850  93.891  1.00 25.24           O  
ATOM   1084  CB  ARG   158      -4.064  45.800  94.291  0.50 26.94           C  
ATOM   1086  CG  ARG   158      -5.391  45.068  94.572  0.50 27.24           C  
ATOM   1088  CD  ARG   158      -5.836  44.165  93.411  0.50 27.38           C  
ATOM   1090  NE  ARG   158      -5.990  44.921  92.170  0.50 27.75           N  
ATOM   1092  CZ  ARG   158      -6.819  44.608  91.178  0.50 27.87           C  
ATOM   1094  NH1 ARG   158      -7.609  43.545  91.259  0.50 26.63           N  
ATOM   1096  NH2 ARG   158      -6.865  45.377  90.098  0.50 28.14           N  
ATOM   1098  N   GLN   159      -1.459  47.527  94.942  1.00 25.47           N  
ATOM   1099  CA  GLN   159      -0.285  48.239  94.416  1.00 24.84           C  
ATOM   1100  C   GLN   159      -0.318  48.292  92.882  1.00 24.69           C  
ATOM   1101  O   GLN   159      -0.025  49.333  92.292  1.00 23.96           O  
ATOM   1102  CB  GLN   159       1.023  47.610  94.933  1.00 24.10           C  
ATOM   1103  CG  GLN   159       2.280  48.434  94.630  1.00 23.18           C  
ATOM   1104  CD  GLN   159       3.563  47.798  95.172  1.00 23.26           C  
ATOM   1105  OE1 GLN   159       3.524  46.845  95.966  1.00 21.67           O  
ATOM   1106  NE2 GLN   159       4.712  48.317  94.733  1.00 22.61           N  
ATOM   1107  N   SER   160      -0.710  47.176  92.258  1.00 24.98           N  
ATOM   1108  CA  SER   160      -0.805  47.064  90.797  1.00 25.73           C  
ATOM   1109  C   SER   160      -1.835  47.995  90.147  1.00 25.60           C  
ATOM   1110  O   SER   160      -1.797  48.200  88.934  1.00 26.01           O  
ATOM   1111  CB  SER   160      -1.078  45.620  90.382  1.00 26.00           C  
ATOM   1112  OG  SER   160      -2.365  45.207  90.820  1.00 28.85           O  
ATOM   1113  N   ASP   161      -2.756  48.555  90.935  1.00 25.72           N  
ATOM   1114  CA  ASP   161      -3.669  49.595  90.405  1.00 25.22           C  
ATOM   1115  C   ASP   161      -2.941  50.920  90.189  1.00 24.39           C  
ATOM   1116  O   ASP   161      -3.204  51.630  89.218  1.00 24.04           O  
ATOM   1117  CB  ASP   161      -4.864  49.794  91.322  1.00 25.64           C  
ATOM   1118  CG  ASP   161      -5.782  48.599  91.338  1.00 27.72           C  
ATOM   1119  OD1 ASP   161      -6.031  48.040  90.249  1.00 30.52           O  
ATOM   1120  OD2 ASP   161      -6.253  48.206  92.429  1.00 29.47           O  
ATOM   1121  N   TYR   162      -2.008  51.232  91.094  1.00 23.50           N  
ATOM   1122  CA  TYR   162      -1.156  52.422  90.968  1.00 22.28           C  
ATOM   1123  C   TYR   162      -0.106  52.231  89.884  1.00 22.12           C  
ATOM   1124  O   TYR   162       0.135  53.105  89.062  1.00 22.29           O  
ATOM   1125  CB  TYR   162      -0.492  52.735  92.305  1.00 21.62           C  
ATOM   1126  CG  TYR   162      -1.468  53.189  93.368  1.00 21.15           C  
ATOM   1127  CD1 TYR   162      -2.304  52.278  94.013  1.00 20.25           C  
ATOM   1128  CD2 TYR   162      -1.554  54.526  93.731  1.00 19.80           C  
ATOM   1129  CE1 TYR   162      -3.196  52.695  94.982  1.00 19.89           C  
ATOM   1130  CE2 TYR   162      -2.448  54.947  94.704  1.00 20.02           C  
ATOM   1131  CZ  TYR   162      -3.259  54.025  95.322  1.00 19.00           C  
ATOM   1132  OH  TYR   162      -4.141  54.433  96.280  1.00 19.05           O  
ATOM   1133  N   GLU   163       0.512  51.069  89.895  1.00 22.53           N  
ATOM   1134  CA  GLU   163       1.427  50.640  88.845  1.00 23.49           C  
ATOM   1135  C   GLU   163       0.800  50.756  87.434  1.00 22.79           C  
ATOM   1136  O   GLU   163       1.446  51.244  86.518  1.00 22.91           O  
ATOM   1137  CB  GLU   163       1.909  49.220  89.171  1.00 24.12           C  
ATOM   1138  CG  GLU   163       2.588  48.479  88.030  1.00 28.94           C  
ATOM   1139  CD  GLU   163       3.943  49.071  87.684  1.00 32.72           C  
ATOM   1140  OE1 GLU   163       4.500  49.808  88.531  1.00 34.60           O  
ATOM   1141  OE2 GLU   163       4.436  48.802  86.565  1.00 33.76           O  
ATOM   1142  N   ALA   164      -0.463  50.361  87.277  1.00 22.26           N  
ATOM   1143  CA  ALA   164      -1.175  50.511  85.998  1.00 22.26           C  
ATOM   1144  C   ALA   164      -1.456  51.971  85.622  1.00 22.23           C  
ATOM   1145  O   ALA   164      -1.380  52.339  84.441  1.00 22.50           O  
ATOM   1146  CB  ALA   164      -2.471  49.705  85.999  1.00 22.27           C  
ATOM   1147  N   ALA   165      -1.767  52.797  86.624  1.00 22.17           N  
ATOM   1148  CA  ALA   165      -1.954  54.241  86.432  1.00 21.58           C  
ATOM   1149  C   ALA   165      -0.690  54.894  85.845  1.00 21.40           C  
ATOM   1150  O   ALA   165      -0.764  55.645  84.865  1.00 21.25           O  
ATOM   1151  CB  ALA   165      -2.366  54.916  87.759  1.00 20.93           C  
ATOM   1152  N   ILE   166       0.462  54.604  86.441  1.00 21.22           N  
ATOM   1153  CA  ILE   166       1.760  55.047  85.911  1.00 21.44           C  
ATOM   1154  C   ILE   166       1.990  54.588  84.458  1.00 22.01           C  
ATOM   1155  O   ILE   166       2.351  55.400  83.586  1.00 21.44           O  
ATOM   1156  CB  ILE   166       2.926  54.606  86.839  1.00 21.55           C  
ATOM   1157  CG1 ILE   166       2.818  55.325  88.198  1.00 21.36           C  
ATOM   1158  CG2 ILE   166       4.268  54.927  86.211  1.00 21.12           C  
ATOM   1159  CD1 ILE   166       3.611  54.677  89.320  1.00 23.74           C  
ATOM   1160  N   ALA   167       1.766  53.301  84.186  1.00 22.49           N  
ATOM   1161  CA  ALA   167       1.907  52.802  82.811  1.00 22.99           C  
ATOM   1162  C   ALA   167       0.980  53.559  81.850  1.00 23.56           C  
ATOM   1163  O   ALA   167       1.441  54.043  80.815  1.00 23.57           O  
ATOM   1164  CB  ALA   167       1.678  51.319  82.739  1.00 23.35           C  
ATOM   1165  N   GLN   168      -0.303  53.701  82.200  1.00 24.13           N  
ATOM   1166  CA  GLN   168      -1.247  54.422  81.324  1.00 25.31           C  
ATOM   1167  C   GLN   168      -0.899  55.894  81.126  1.00 25.17           C  
ATOM   1168  O   GLN   168      -0.882  56.367  79.991  1.00 25.50           O  
ATOM   1169  CB  GLN   168      -2.689  54.317  81.817  1.00 25.77           C  
ATOM   1170  CG  GLN   168      -3.268  52.895  81.825  1.00 30.04           C  
ATOM   1171  CD  GLN   168      -4.457  52.755  82.788  1.00 34.65           C  
ATOM   1172  OE1 GLN   168      -5.104  53.750  83.150  1.00 33.88           O  
ATOM   1173  NE2 GLN   168      -4.752  51.509  83.198  1.00 34.55           N  
ATOM   1174  N   MET   169      -0.643  56.611  82.209  1.00 24.83           N  
ATOM   1175  CA  MET   169      -0.330  58.046  82.139  1.00 25.22           C  
ATOM   1176  C   MET   169       0.997  58.336  81.447  1.00 24.53           C  
ATOM   1177  O   MET   169       1.068  59.262  80.658  1.00 24.87           O  
ATOM   1178  CB  MET   169      -0.329  58.707  83.521  1.00 25.84           C  
ATOM   1179  CG  MET   169      -1.687  58.778  84.180  1.00 29.53           C  
ATOM   1180  SD  MET   169      -2.989  59.654  83.023  1.00 42.28          SE  
ATOM   1181  CE  MET   169      -2.164  61.396  82.800  1.00 36.81           C  
ATOM   1182  N   THR   170       2.047  57.572  81.740  1.00 23.92           N  
ATOM   1183  CA  THR   170       3.338  57.812  81.065  1.00 23.85           C  
ATOM   1184  C   THR   170       3.225  57.649  79.553  1.00 24.46           C  
ATOM   1185  O   THR   170       3.845  58.404  78.807  1.00 24.42           O  
ATOM   1186  CB  THR   170       4.494  56.960  81.598  1.00 23.20           C  
ATOM   1187  OG1 THR   170       4.142  55.577  81.560  1.00 24.10           O  
ATOM   1188  CG2 THR   170       4.825  57.347  83.006  1.00 22.04           C  
ATOM   1189  N   ALA   171       2.408  56.677  79.126  1.00 25.10           N  
ATOM   1190  CA  ALA   171       2.146  56.402  77.722  1.00 25.84           C  
ATOM   1191  C   ALA   171       1.629  57.621  76.980  1.00 26.68           C  
ATOM   1192  O   ALA   171       2.104  57.928  75.887  1.00 26.73           O  
ATOM   1193  CB  ALA   171       1.178  55.242  77.574  1.00 25.89           C  
ATOM   1194  N   ASP   172       0.673  58.321  77.583  1.00 27.37           N  
ATOM   1195  CA  ASP   172       0.076  59.513  76.979  1.00 28.26           C  
ATOM   1196  C   ASP   172       1.035  60.698  76.773  1.00 27.95           C  
ATOM   1197  O   ASP   172       0.733  61.625  76.022  1.00 28.15           O  
ATOM   1198  CB  ASP   172      -1.117  59.965  77.807  1.00 28.70           C  
ATOM   1199  CG  ASP   172      -2.307  59.053  77.653  1.00 30.82           C  
ATOM   1200  OD1 ASP   172      -2.415  58.328  76.635  1.00 32.96           O  
ATOM   1201  OD2 ASP   172      -3.151  59.069  78.569  1.00 34.25           O  
ATOM   1202  N   TYR   173       2.187  60.659  77.424  1.00 27.44           N  
ATOM   1203  CA  TYR   173       3.151  61.739  77.309  1.00 27.15           C  
ATOM   1204  C   TYR   173       4.421  61.282  76.635  1.00 26.61           C  
ATOM   1205  O   TYR   173       5.347  62.065  76.451  1.00 26.86           O  
ATOM   1206  CB  TYR   173       3.427  62.341  78.689  1.00 27.79           C  
ATOM   1207  CG  TYR   173       2.246  63.118  79.198  1.00 28.17           C  
ATOM   1208  CD1 TYR   173       1.161  62.466  79.815  1.00 29.50           C  
ATOM   1209  CD2 TYR   173       2.180  64.494  79.025  1.00 28.61           C  
ATOM   1210  CE1 TYR   173       0.050  63.176  80.265  1.00 29.02           C  
ATOM   1211  CE2 TYR   173       1.082  65.211  79.472  1.00 30.33           C  
ATOM   1212  CZ  TYR   173       0.024  64.547  80.088  1.00 30.39           C  
ATOM   1213  OH  TYR   173      -1.051  65.272  80.524  1.00 31.88           O  
ATOM   1214  N   GLY   174       4.445  60.007  76.255  1.00 26.00           N  
ATOM   1215  CA  GLY   174       5.575  59.414  75.554  1.00 25.07           C  
ATOM   1216  C   GLY   174       6.763  59.096  76.433  1.00 24.66           C  
ATOM   1217  O   GLY   174       7.856  58.836  75.927  1.00 24.73           O  
ATOM   1218  N   VAL   175       6.549  59.098  77.747  1.00 23.74           N  
ATOM   1219  CA  VAL   175       7.633  58.904  78.698  1.00 23.55           C  
ATOM   1220  C   VAL   175       7.878  57.425  78.984  1.00 23.28           C  
ATOM   1221  O   VAL   175       7.007  56.763  79.527  1.00 22.84           O  
ATOM   1222  CB  VAL   175       7.357  59.641  80.048  1.00 23.61           C  
ATOM   1223  CG1 VAL   175       8.475  59.342  81.054  1.00 22.98           C  
ATOM   1224  CG2 VAL   175       7.225  61.121  79.814  1.00 22.74           C  
ATOM   1225  N   PRO   176       9.083  56.917  78.657  1.00 23.41           N  
ATOM   1226  CA  PRO   176       9.391  55.513  78.945  1.00 23.34           C  
ATOM   1227  C   PRO   176       9.141  55.144  80.409  1.00 23.10           C  
ATOM   1228  O   PRO   176       9.292  55.978  81.315  1.00 23.38           O  
ATOM   1229  CB  PRO   176      10.876  55.400  78.603  1.00 23.63           C  
ATOM   1230  CG  PRO   176      11.085  56.458  77.545  1.00 23.96           C  
ATOM   1231  CD  PRO   176      10.218  57.607  78.020  1.00 23.15           C  
ATOM   1232  N   HIS   177       8.718  53.909  80.631  1.00 22.95           N  
ATOM   1233  CA  HIS   177       8.366  53.477  81.970  1.00 22.90           C  
ATOM   1234  C   HIS   177       9.118  52.209  82.295  1.00 22.37           C  
ATOM   1235  O   HIS   177       8.910  51.197  81.650  1.00 22.00           O  
ATOM   1236  CB  HIS   177       6.844  53.268  82.102  1.00 23.14           C  
ATOM   1237  CG  HIS   177       6.433  52.587  83.378  1.00 24.72           C  
ATOM   1238  ND1 HIS   177       5.472  51.600  83.419  1.00 26.09           N  
ATOM   1239  CD2 HIS   177       6.865  52.740  84.655  1.00 27.43           C  
ATOM   1240  CE1 HIS   177       5.321  51.180  84.663  1.00 26.03           C  
ATOM   1241  NE2 HIS   177       6.157  51.854  85.435  1.00 27.08           N  
ATOM   1242  N   LEU   178      10.001  52.284  83.286  1.00 22.40           N  
ATOM   1243  CA  LEU   178      10.697  51.118  83.805  1.00 22.88           C  
ATOM   1244  C   LEU   178       9.969  50.579  85.041  1.00 23.13           C  
ATOM   1245  O   LEU   178       9.963  51.220  86.101  1.00 23.75           O  
ATOM   1246  CB  LEU   178      12.146  51.479  84.159  1.00 22.80           C  
ATOM   1247  CG  LEU   178      13.007  50.474  84.947  1.00 22.96           C  
ATOM   1248  CD1 LEU   178      13.049  49.096  84.302  1.00 23.43           C  
ATOM   1249  CD2 LEU   178      14.417  51.016  85.084  1.00 24.38           C  
ATOM   1250  N   SER   179       9.366  49.403  84.908  1.00 23.07           N  
ATOM   1251  CA  SER   179       8.594  48.827  86.000  1.00 23.24           C  
ATOM   1252  C   SER   179       9.417  47.830  86.793  1.00 23.42           C  
ATOM   1253  O   SER   179       9.550  46.673  86.374  1.00 22.50           O  
ATOM   1254  CB  SER   179       7.352  48.138  85.454  1.00 23.59           C  
ATOM   1255  OG  SER   179       6.699  47.429  86.492  1.00 25.44           O  
ATOM   1256  N   LEU   180       9.983  48.265  87.926  1.00 23.58           N  
ATOM   1257  CA  LEU   180      10.693  47.324  88.819  1.00 24.34           C  
ATOM   1258  C   LEU   180       9.706  46.311  89.381  1.00 24.73           C  
ATOM   1259  O   LEU   180      10.056  45.177  89.697  1.00 25.14           O  
ATOM   1260  CB  LEU   180      11.393  48.046  89.962  1.00 24.38           C  
ATOM   1261  CG  LEU   180      12.443  49.093  89.614  1.00 24.12           C  
ATOM   1262  CD1 LEU   180      13.013  49.654  90.896  1.00 22.98           C  
ATOM   1263  CD2 LEU   180      13.546  48.487  88.741  1.00 22.42           C  
ATOM   1264  N   TYR   181       8.461  46.748  89.501  1.00 25.48           N  
ATOM   1265  CA  TYR   181       7.350  45.886  89.868  1.00 26.49           C  
ATOM   1266  C   TYR   181       7.325  44.596  89.014  1.00 26.82           C  
ATOM   1267  O   TYR   181       7.352  43.498  89.573  1.00 26.02           O  
ATOM   1268  CB  TYR   181       6.023  46.659  89.764  1.00 26.16           C  
ATOM   1269  CG  TYR   181       4.846  45.934  90.361  1.00 27.60           C  
ATOM   1270  CD1 TYR   181       4.101  45.024  89.601  1.00 28.09           C  
ATOM   1271  CD2 TYR   181       4.474  46.144  91.690  1.00 27.06           C  
ATOM   1272  CE1 TYR   181       3.016  44.341  90.159  1.00 29.52           C  
ATOM   1273  CE2 TYR   181       3.396  45.479  92.245  1.00 28.92           C  
ATOM   1274  CZ  TYR   181       2.670  44.575  91.477  1.00 28.96           C  
ATOM   1275  OH  TYR   181       1.595  43.909  92.028  1.00 29.32           O  
ATOM   1276  N   ARG   182       7.305  44.750  87.684  1.00 27.74           N  
ATOM   1277  CA  ARG   182       7.208  43.629  86.722  1.00 29.37           C  
ATOM   1278  C   ARG   182       8.502  42.869  86.440  1.00 29.65           C  
ATOM   1279  O   ARG   182       8.456  41.683  86.098  1.00 30.02           O  
ATOM   1280  CB  ARG   182       6.727  44.114  85.345  1.00 29.97           C  
ATOM   1281  CG  ARG   182       5.348  44.692  85.293  1.00 33.58           C  
ATOM   1282  CD  ARG   182       4.710  44.439  83.927  1.00 38.99           C  
ATOM   1283  NE  ARG   182       3.261  44.619  84.011  1.00 42.09           N  
ATOM   1284  CZ  ARG   182       2.363  43.954  83.286  1.00 44.85           C  
ATOM   1285  NH1 ARG   182       2.748  43.032  82.408  1.00 44.34           N  
ATOM   1286  NH2 ARG   182       1.065  44.205  83.455  1.00 45.81           N  
ATOM   1287  N   ASP   183       9.639  43.560  86.512  1.00 29.64           N  
ATOM   1288  CA  ASP   183      10.868  43.064  85.889  1.00 30.17           C  
ATOM   1289  C   ASP   183      12.134  43.058  86.756  1.00 30.06           C  
ATOM   1290  O   ASP   183      13.188  42.645  86.271  1.00 30.69           O  
ATOM   1291  CB  ASP   183      11.172  43.856  84.608  1.00 30.70           C  
ATOM   1292  CG  ASP   183      10.259  43.489  83.432  1.00 32.92           C  
ATOM   1293  OD1 ASP   183      10.064  42.277  83.110  1.00 33.27           O  
ATOM   1294  OD2 ASP   183       9.757  44.452  82.802  1.00 36.03           O  
ATOM   1295  N   ALA   184      12.046  43.508  88.010  1.00 29.42           N  
ATOM   1296  CA  ALA   184      13.220  43.589  88.904  1.00 28.62           C  
ATOM   1297  C   ALA   184      13.827  42.228  89.259  1.00 28.45           C  
ATOM   1298  O   ALA   184      15.008  42.141  89.614  1.00 28.14           O  
ATOM   1299  CB  ALA   184      12.858  44.335  90.176  1.00 28.56           C  
ATOM   1300  N   GLY   185      13.005  41.180  89.183  1.00 28.03           N  
ATOM   1301  CA  GLY   185      13.423  39.828  89.476  1.00 28.18           C  
ATOM   1302  C   GLY   185      13.046  39.356  90.870  1.00 28.65           C  
ATOM   1303  O   GLY   185      13.363  38.226  91.240  1.00 29.21           O  
ATOM   1304  N   MET   186      12.363  40.209  91.631  1.00 28.71           N  
ATOM   1305  CA  MET   186      12.069  39.962  93.049  1.00 28.94           C  
ATOM   1306  C   MET   186      10.782  40.643  93.500  1.00 27.54           C  
ATOM   1307  O   MET   186      10.308  41.588  92.868  1.00 27.49           O  
ATOM   1308  CB  MET   186      13.223  40.458  93.927  1.00 30.04           C  
ATOM   1309  CG  MET   186      13.413  41.969  93.914  1.00 34.35           C  
ATOM   1310  SD  MET   186      15.208  42.593  94.431  1.00 49.82          SE  
ATOM   1311  CE  MET   186      16.281  41.376  93.316  1.00 46.12           C  
ATOM   1312  N   THR   187      10.223  40.143  94.598  1.00 26.39           N  
ATOM   1313  CA  THR   187       9.108  40.785  95.284  1.00 25.11           C  
ATOM   1314  C   THR   187       9.364  40.735  96.786  1.00 24.76           C  
ATOM   1315  O   THR   187       9.775  39.696  97.313  1.00 25.13           O  
ATOM   1316  CB  THR   187       7.741  40.132  94.908  1.00 25.54           C  
ATOM   1317  OG1 THR   187       6.718  40.554  95.815  1.00 24.81           O  
ATOM   1318  CG2 THR   187       7.822  38.598  94.932  1.00 24.16           C  
ATOM   1319  N   PHE   188       9.146  41.850  97.479  1.00 24.06           N  
ATOM   1320  CA  PHE   188       9.311  41.870  98.946  1.00 24.13           C  
ATOM   1321  C   PHE   188       8.172  41.179  99.709  1.00 24.16           C  
ATOM   1322  O   PHE   188       8.261  40.973 100.924  1.00 24.33           O  
ATOM   1323  CB  PHE   188       9.545  43.294  99.468  1.00 23.74           C  
ATOM   1324  CG  PHE   188      10.789  43.955  98.908  1.00 23.14           C  
ATOM   1325  CD1 PHE   188      11.824  43.196  98.368  1.00 21.66           C  
ATOM   1326  CD2 PHE   188      10.934  45.331  98.947  1.00 21.64           C  
ATOM   1327  CE1 PHE   188      12.965  43.805  97.847  1.00 21.53           C  
ATOM   1328  CE2 PHE   188      12.077  45.946  98.445  1.00 22.29           C  
ATOM   1329  CZ  PHE   188      13.094  45.175  97.883  1.00 20.90           C  
ATOM   1330  N   ALA   189       7.115  40.805  98.988  1.00 24.37           N  
ATOM   1331  CA  ALA   189       6.025  39.988  99.544  1.00 24.29           C  
ATOM   1332  C   ALA   189       6.431  38.524  99.797  1.00 24.90           C  
ATOM   1333  O   ALA   189       5.666  37.753 100.385  1.00 24.20           O  
ATOM   1334  CB  ALA   189       4.823  40.047  98.633  1.00 24.19           C  
ATOM   1335  N   ILE   190       7.613  38.135  99.327  1.00 25.24           N  
ATOM   1336  CA  ILE   190       8.177  36.829  99.672  1.00 26.56           C  
ATOM   1337  C   ILE   190       9.334  37.046 100.643  1.00 26.80           C  
ATOM   1338  O   ILE   190      10.291  37.762 100.315  1.00 27.00           O  
ATOM   1339  CB  ILE   190       8.605  36.005  98.414  1.00 26.69           C  
ATOM   1340  CG1 ILE   190       7.404  35.285  97.828  1.00 27.76           C  
ATOM   1341  CG2 ILE   190       9.601  34.935  98.760  1.00 27.46           C  
ATOM   1342  CD1 ILE   190       6.945  35.861  96.575  1.00 30.28           C  
ATOM   1343  N   PRO   191       9.209  36.491 101.869  1.00 27.29           N  
ATOM   1344  CA  PRO   191      10.177  36.636 102.962  1.00 27.14           C  
ATOM   1345  C   PRO   191      11.620  36.331 102.564  1.00 27.30           C  
ATOM   1346  O   PRO   191      12.510  37.122 102.880  1.00 27.51           O  
ATOM   1347  CB  PRO   191       9.672  35.636 104.008  1.00 26.98           C  
ATOM   1348  CG  PRO   191       8.187  35.639 103.800  1.00 28.10           C  
ATOM   1349  CD  PRO   191       8.034  35.696 102.290  1.00 27.45           C  
ATOM   1350  N   ALA   192      11.848  35.210 101.868  1.00 27.45           N  
ATOM   1351  CA  ALA   192      13.186  34.828 101.410  1.00 26.82           C  
ATOM   1352  C   ALA   192      13.882  35.944 100.616  1.00 26.40           C  
ATOM   1353  O   ALA   192      15.088  36.147 100.764  1.00 26.69           O  
ATOM   1354  CB  ALA   192      13.126  33.559 100.596  1.00 26.60           C  
ATOM   1355  N   GLN   193      13.128  36.664  99.785  1.00 25.57           N  
ATOM   1356  CA  GLN   193      13.688  37.778  99.000  1.00 25.16           C  
ATOM   1357  C   GLN   193      13.725  39.085  99.772  1.00 24.82           C  
ATOM   1358  O   GLN   193      14.678  39.852  99.642  1.00 24.54           O  
ATOM   1359  CB  GLN   193      12.934  37.959  97.693  1.00 24.40           C  
ATOM   1360  CG  GLN   193      13.238  36.861  96.702  1.00 25.78           C  
ATOM   1361  CD  GLN   193      12.640  37.115  95.350  1.00 26.24           C  
ATOM   1362  OE1 GLN   193      11.464  37.470  95.247  1.00 27.16           O  
ATOM   1363  NE2 GLN   193      13.440  36.944  94.296  1.00 23.98           N  
ATOM   1364  N   ALA   194      12.675  39.339 100.561  1.00 24.44           N  
ATOM   1365  CA  ALA   194      12.631  40.494 101.468  1.00 23.97           C  
ATOM   1366  C   ALA   194      13.827  40.477 102.424  1.00 23.76           C  
ATOM   1367  O   ALA   194      14.443  41.513 102.680  1.00 23.65           O  
ATOM   1368  CB  ALA   194      11.305  40.506 102.254  1.00 23.64           C  
ATOM   1369  N   ALA   195      14.154  39.295 102.937  1.00 23.60           N  
ATOM   1370  CA  ALA   195      15.310  39.103 103.830  1.00 23.90           C  
ATOM   1371  C   ALA   195      16.644  39.443 103.155  1.00 23.93           C  
ATOM   1372  O   ALA   195      17.559  39.958 103.796  1.00 24.21           O  
ATOM   1373  CB  ALA   195      15.341  37.676 104.342  1.00 23.60           C  
ATOM   1374  N   ILE   196      16.743  39.184 101.857  1.00 23.43           N  
ATOM   1375  CA  ILE   196      18.010  39.369 101.141  1.00 23.06           C  
ATOM   1376  C   ILE   196      18.160  40.770 100.555  1.00 22.83           C  
ATOM   1377  O   ILE   196      19.259  41.335 100.565  1.00 22.56           O  
ATOM   1378  CB  ILE   196      18.188  38.292 100.028  1.00 22.52           C  
ATOM   1379  CG1 ILE   196      18.350  36.914 100.674  1.00 23.29           C  
ATOM   1380  CG2 ILE   196      19.399  38.605  99.142  1.00 21.65           C  
ATOM   1381  CD1 ILE   196      18.597  35.781  99.671  1.00 23.81           C  
ATOM   1382  N   TYR   197      17.055  41.321 100.050  1.00 22.47           N  
ATOM   1383  CA  TYR   197      17.100  42.552  99.241  1.00 22.95           C  
ATOM   1384  C   TYR   197      16.443  43.790  99.842  1.00 23.07           C  
ATOM   1385  O   TYR   197      16.554  44.880  99.276  1.00 22.93           O  
ATOM   1386  CB  TYR   197      16.479  42.293  97.868  1.00 22.26           C  
ATOM   1387  CG  TYR   197      17.250  41.293  97.055  1.00 23.45           C  
ATOM   1388  CD1 TYR   197      18.546  41.574  96.621  1.00 22.49           C  
ATOM   1389  CD2 TYR   197      16.684  40.061  96.713  1.00 22.61           C  
ATOM   1390  CE1 TYR   197      19.267  40.652  95.863  1.00 24.19           C  
ATOM   1391  CE2 TYR   197      17.392  39.142  95.955  1.00 23.40           C  
ATOM   1392  CZ  TYR   197      18.685  39.447  95.531  1.00 23.52           C  
ATOM   1393  OH  TYR   197      19.402  38.536  94.787  1.00 23.67           O  
ATOM   1394  N   SER   198      15.756  43.622 100.968  1.00 23.73           N  
ATOM   1395  CA  SER   198      15.052  44.724 101.586  1.00 25.22           C  
ATOM   1396  C   SER   198      15.447  44.864 103.037  1.00 25.84           C  
ATOM   1397  O   SER   198      15.884  43.903 103.671  1.00 26.27           O  
ATOM   1398  CB  SER   198      13.534  44.544 101.493  1.00 25.05           C  
ATOM   1399  OG  SER   198      13.062  43.744 102.565  1.00 26.97           O  
ATOM   1400  N   VAL   199      15.264  46.070 103.560  1.00 26.45           N  
ATOM   1401  CA  VAL   199      15.444  46.332 104.988  1.00 27.06           C  
ATOM   1402  C   VAL   199      14.227  45.835 105.798  1.00 27.07           C  
ATOM   1403  O   VAL   199      14.389  45.286 106.892  1.00 27.62           O  
ATOM   1404  CB  VAL   199      15.720  47.857 105.256  1.00 27.02           C  
ATOM   1405  CG1 VAL   199      15.884  48.147 106.759  1.00 28.33           C  
ATOM   1406  CG2 VAL   199      16.959  48.323 104.508  1.00 26.59           C  
ATOM   1407  N   ASP   200      13.023  45.976 105.239  1.00 26.84           N  
ATOM   1408  CA  ASP   200      11.793  45.936 106.034  1.00 26.79           C  
ATOM   1409  C   ASP   200      10.555  45.580 105.203  1.00 26.93           C  
ATOM   1410  O   ASP   200       9.414  45.894 105.601  1.00 27.15           O  
ATOM   1411  CB  ASP   200      11.582  47.325 106.658  1.00 26.81           C  
ATOM   1412  CG  ASP   200      11.641  48.434 105.616  1.00 27.44           C  
ATOM   1413  OD1 ASP   200      11.490  48.126 104.408  1.00 27.34           O  
ATOM   1414  OD2 ASP   200      11.846  49.604 105.989  1.00 26.69           O  
ATOM   1415  N   THR   201      10.789  44.942 104.053  1.00 26.21           N  
ATOM   1416  CA  THR   201       9.766  44.618 103.035  1.00 25.78           C  
ATOM   1417  C   THR   201       9.237  45.811 102.241  1.00 25.51           C  
ATOM   1418  O   THR   201       8.281  45.662 101.484  1.00 24.91           O  
ATOM   1419  CB  THR   201       8.563  43.763 103.553  1.00 25.87           C  
ATOM   1420  OG1 THR   201       7.579  44.607 104.181  1.00 26.30           O  
ATOM   1421  CG2 THR   201       9.017  42.639 104.494  1.00 26.30           C  
ATOM   1422  N   LEU   202       9.859  46.980 102.410  1.00 25.67           N  
ATOM   1423  CA  LEU   202       9.525  48.165 101.615  1.00 25.71           C  
ATOM   1424  C   LEU   202      10.763  48.829 100.975  1.00 25.58           C  
ATOM   1425  O   LEU   202      10.798  49.042  99.758  1.00 25.57           O  
ATOM   1426  CB  LEU   202       8.711  49.168 102.445  1.00 25.91           C  
ATOM   1427  CG  LEU   202       8.547  50.594 101.881  1.00 27.48           C  
ATOM   1428  CD1 LEU   202       7.681  50.655 100.641  1.00 27.51           C  
ATOM   1429  CD2 LEU   202       8.001  51.559 102.940  1.00 30.15           C  
ATOM   1430  N   HIS   203      11.766  49.153 101.792  1.00 25.08           N  
ATOM   1431  CA  HIS   203      12.969  49.823 101.311  1.00 24.99           C  
ATOM   1432  C   HIS   203      13.990  48.798 100.862  1.00 24.27           C  
ATOM   1433  O   HIS   203      14.242  47.844 101.574  1.00 24.19           O  
ATOM   1434  CB  HIS   203      13.591  50.697 102.408  1.00 25.35           C  
ATOM   1435  CG  HIS   203      12.666  51.740 102.942  1.00 25.58           C  
ATOM   1436  ND1 HIS   203      12.360  52.888 102.247  1.00 27.67           N  
ATOM   1437  CD2 HIS   203      11.971  51.804 104.100  1.00 26.25           C  
ATOM   1438  CE1 HIS   203      11.509  53.613 102.954  1.00 28.67           C  
ATOM   1439  NE2 HIS   203      11.260  52.976 104.085  1.00 28.00           N  
ATOM   1440  N   PRO   204      14.579  48.989  99.671  1.00 24.08           N  
ATOM   1441  CA  PRO   204      15.692  48.131  99.292  1.00 23.78           C  
ATOM   1442  C   PRO   204      16.876  48.360 100.216  1.00 23.57           C  
ATOM   1443  O   PRO   204      17.089  49.482 100.676  1.00 23.94           O  
ATOM   1444  CB  PRO   204      16.035  48.603  97.872  1.00 24.13           C  
ATOM   1445  CG  PRO   204      14.843  49.295  97.381  1.00 23.54           C  
ATOM   1446  CD  PRO   204      14.243  49.946  98.604  1.00 23.86           C  
ATOM   1447  N   ASN   205      17.608  47.299 100.529  1.00 23.27           N  
ATOM   1448  CA  ASN   205      18.893  47.454 101.191  1.00 23.49           C  
ATOM   1449  C   ASN   205      19.985  47.718 100.128  1.00 23.50           C  
ATOM   1450  O   ASN   205      19.665  47.986  98.970  1.00 23.19           O  
ATOM   1451  CB  ASN   205      19.189  46.223 102.058  1.00 23.84           C  
ATOM   1452  CG  ASN   205      19.313  44.951 101.238  1.00 23.96           C  
ATOM   1453  OD1 ASN   205      19.481  45.005 100.019  1.00 25.05           O  
ATOM   1454  ND2 ASN   205      19.224  43.801 101.900  1.00 22.83           N  
ATOM   1455  N   ASN   206      21.258  47.637 100.499  1.00 23.25           N  
ATOM   1456  CA  ASN   206      22.337  47.841  99.530  1.00 23.29           C  
ATOM   1457  C   ASN   206      22.376  46.830  98.391  1.00 22.81           C  
ATOM   1458  O   ASN   206      22.672  47.195  97.250  1.00 22.37           O  
ATOM   1459  CB  ASN   206      23.705  47.878 100.212  1.00 23.88           C  
ATOM   1460  CG  ASN   206      23.929  49.149 101.004  1.00 25.10           C  
ATOM   1461  OD1 ASN   206      23.114  50.075 100.996  1.00 25.78           O  
ATOM   1462  ND2 ASN   206      25.054  49.204 101.684  1.00 28.91           N  
ATOM   1463  N   ALA   207      22.089  45.565  98.699  1.00 22.27           N  
ATOM   1464  CA  ALA   207      22.012  44.525  97.660  1.00 22.52           C  
ATOM   1465  C   ALA   207      20.870  44.799  96.675  1.00 21.85           C  
ATOM   1466  O   ALA   207      20.999  44.568  95.469  1.00 22.39           O  
ATOM   1467  CB  ALA   207      21.869  43.126  98.297  1.00 21.94           C  
ATOM   1468  N   GLY   208      19.757  45.305  97.199  1.00 21.77           N  
ATOM   1469  CA  GLY   208      18.580  45.638  96.389  1.00 21.10           C  
ATOM   1470  C   GLY   208      18.877  46.810  95.488  1.00 21.36           C  
ATOM   1471  O   GLY   208      18.461  46.834  94.328  1.00 21.64           O  
ATOM   1472  N   HIS   209      19.623  47.773  96.018  1.00 20.83           N  
ATOM   1473  CA  HIS   209      20.068  48.913  95.241  1.00 20.56           C  
ATOM   1474  C   HIS   209      21.028  48.560  94.113  1.00 20.48           C  
ATOM   1475  O   HIS   209      20.953  49.170  93.053  1.00 19.56           O  
ATOM   1476  CB  HIS   209      20.641  50.006  96.134  1.00 20.59           C  
ATOM   1477  CG  HIS   209      19.587  50.833  96.799  1.00 21.67           C  
ATOM   1478  ND1 HIS   209      18.998  51.915  96.184  1.00 21.01           N  
ATOM   1479  CD2 HIS   209      18.993  50.717  98.011  1.00 21.96           C  
ATOM   1480  CE1 HIS   209      18.102  52.447  96.995  1.00 22.66           C  
ATOM   1481  NE2 HIS   209      18.078  51.739  98.111  1.00 24.04           N  
ATOM   1482  N   ARG   210      21.914  47.588  94.319  1.00 20.79           N  
ATOM   1483  CA  ARG   210      22.812  47.133  93.261  0.50 21.12           C  
ATOM   1485  C   ARG   210      22.000  46.547  92.107  1.00 21.66           C  
ATOM   1486  O   ARG   210      22.291  46.790  90.927  1.00 22.39           O  
ATOM   1487  CB  ARG   210      23.808  46.108  93.805  0.50 20.53           C  
ATOM   1489  CG  ARG   210      24.900  46.728  94.657  0.50 19.64           C  
ATOM   1491  CD  ARG   210      26.064  45.777  94.870  0.50 19.59           C  
ATOM   1493  NE  ARG   210      25.730  44.641  95.726  0.50 18.55           N  
ATOM   1495  CZ  ARG   210      25.667  44.687  97.054  0.50 19.30           C  
ATOM   1497  NH1 ARG   210      25.898  45.822  97.705  0.50 18.67           N  
ATOM   1499  NH2 ARG   210      25.364  43.592  97.736  0.50 19.90           N  
ATOM   1501  N   VAL   211      20.976  45.773  92.468  1.00 21.74           N  
ATOM   1502  CA  VAL   211      20.053  45.184  91.482  1.00 22.06           C  
ATOM   1503  C   VAL   211      19.371  46.299  90.687  1.00 22.07           C  
ATOM   1504  O   VAL   211      19.362  46.271  89.455  1.00 22.00           O  
ATOM   1505  CB  VAL   211      18.989  44.258  92.140  1.00 22.01           C  
ATOM   1506  CG1 VAL   211      17.875  43.906  91.157  1.00 23.84           C  
ATOM   1507  CG2 VAL   211      19.630  42.980  92.669  1.00 22.69           C  
ATOM   1508  N   ILE   212      18.823  47.284  91.397  1.00 21.49           N  
ATOM   1509  CA  ILE   212      18.101  48.388  90.765  1.00 21.10           C  
ATOM   1510  C   ILE   212      18.973  49.164  89.777  1.00 21.13           C  
ATOM   1511  O   ILE   212      18.523  49.501  88.685  1.00 21.45           O  
ATOM   1512  CB  ILE   212      17.479  49.332  91.830  1.00 20.87           C  
ATOM   1513  CG1 ILE   212      16.313  48.625  92.522  1.00 19.84           C  
ATOM   1514  CG2 ILE   212      17.008  50.644  91.190  1.00 20.02           C  
ATOM   1515  CD1 ILE   212      15.859  49.292  93.797  1.00 20.59           C  
ATOM   1516  N   ALA   213      20.221  49.421  90.163  1.00 21.39           N  
ATOM   1517  CA  ALA   213      21.214  50.069  89.307  1.00 21.51           C  
ATOM   1518  C   ALA   213      21.459  49.293  88.021  1.00 22.11           C  
ATOM   1519  O   ALA   213      21.507  49.876  86.934  1.00 22.68           O  
ATOM   1520  CB  ALA   213      22.517  50.260  90.069  1.00 20.88           C  
ATOM   1521  N   ARG   214      21.608  47.978  88.143  1.00 23.12           N  
ATOM   1522  CA  ARG   214      21.760  47.109  86.976  1.00 23.96           C  
ATOM   1523  C   ARG   214      20.517  47.156  86.080  1.00 23.66           C  
ATOM   1524  O   ARG   214      20.627  47.271  84.866  1.00 24.00           O  
ATOM   1525  CB  ARG   214      22.054  45.681  87.413  1.00 24.37           C  
ATOM   1526  CG  ARG   214      23.419  45.527  88.074  1.00 27.81           C  
ATOM   1527  CD  ARG   214      23.813  44.064  88.228  1.00 33.77           C  
ATOM   1528  NE  ARG   214      23.034  43.361  89.246  1.00 38.01           N  
ATOM   1529  CZ  ARG   214      23.488  43.022  90.453  1.00 40.34           C  
ATOM   1530  NH1 ARG   214      24.733  43.312  90.827  1.00 40.89           N  
ATOM   1531  NH2 ARG   214      22.693  42.373  91.287  1.00 41.44           N  
ATOM   1532  N   LYS   215      19.339  47.104  86.687  1.00 23.34           N  
ATOM   1533  CA  LYS   215      18.088  47.118  85.925  1.00 23.40           C  
ATOM   1534  C   LYS   215      17.918  48.434  85.193  1.00 23.10           C  
ATOM   1535  O   LYS   215      17.474  48.449  84.051  1.00 23.03           O  
ATOM   1536  CB  LYS   215      16.881  46.831  86.830  1.00 23.69           C  
ATOM   1537  CG  LYS   215      16.792  45.368  87.291  1.00 25.13           C  
ATOM   1538  CD  LYS   215      16.593  44.404  86.110  1.00 28.48           C  
ATOM   1539  CE  LYS   215      16.814  42.937  86.522  1.00 31.34           C  
ATOM   1540  NZ  LYS   215      18.194  42.444  86.202  1.00 33.82           N  
ATOM   1541  N   LEU   216      18.302  49.533  85.842  1.00 23.06           N  
ATOM   1542  CA  LEU   216      18.184  50.852  85.242  1.00 23.87           C  
ATOM   1543  C   LEU   216      19.169  51.038  84.084  1.00 23.58           C  
ATOM   1544  O   LEU   216      18.790  51.549  83.042  1.00 23.43           O  
ATOM   1545  CB  LEU   216      18.342  51.958  86.296  1.00 23.97           C  
ATOM   1546  CG  LEU   216      18.313  53.434  85.890  1.00 26.39           C  
ATOM   1547  CD1 LEU   216      17.133  53.797  85.000  1.00 27.16           C  
ATOM   1548  CD2 LEU   216      18.256  54.274  87.173  1.00 29.94           C  
ATOM   1549  N   GLN   217      20.422  50.639  84.267  1.00 23.74           N  
ATOM   1550  CA  GLN   217      21.403  50.764  83.179  1.00 24.18           C  
ATOM   1551  C   GLN   217      20.961  49.975  81.937  1.00 24.32           C  
ATOM   1552  O   GLN   217      21.001  50.509  80.823  1.00 24.83           O  
ATOM   1553  CB  GLN   217      22.811  50.368  83.629  1.00 23.61           C  
ATOM   1554  CG  GLN   217      23.908  50.682  82.604  1.00 24.98           C  
ATOM   1555  CD  GLN   217      24.164  52.183  82.423  1.00 26.25           C  
ATOM   1556  OE1 GLN   217      24.442  52.896  83.379  1.00 28.57           O  
ATOM   1557  NE2 GLN   217      24.077  52.654  81.196  1.00 26.08           N  
ATOM   1558  N   SER   218      20.498  48.735  82.138  1.00 24.54           N  
ATOM   1559  CA  SER   218      20.011  47.888  81.044  1.00 24.85           C  
ATOM   1560  C   SER   218      18.906  48.598  80.299  1.00 24.44           C  
ATOM   1561  O   SER   218      18.903  48.623  79.076  1.00 24.27           O  
ATOM   1562  CB  SER   218      19.451  46.565  81.563  1.00 24.93           C  
ATOM   1563  OG  SER   218      20.477  45.755  82.074  1.00 28.12           O  
ATOM   1564  N   PHE   219      17.970  49.165  81.055  1.00 24.17           N  
ATOM   1565  CA  PHE   219      16.815  49.841  80.485  1.00 24.74           C  
ATOM   1566  C   PHE   219      17.249  51.049  79.644  1.00 24.88           C  
ATOM   1567  O   PHE   219      16.751  51.263  78.541  1.00 24.91           O  
ATOM   1568  CB  PHE   219      15.827  50.256  81.588  1.00 24.15           C  
ATOM   1569  CG  PHE   219      14.512  50.757  81.055  1.00 24.39           C  
ATOM   1570  CD1 PHE   219      13.493  49.870  80.747  1.00 23.08           C  
ATOM   1571  CD2 PHE   219      14.307  52.108  80.836  1.00 23.65           C  
ATOM   1572  CE1 PHE   219      12.292  50.320  80.240  1.00 24.30           C  
ATOM   1573  CE2 PHE   219      13.099  52.570  80.323  1.00 24.73           C  
ATOM   1574  CZ  PHE   219      12.091  51.669  80.028  1.00 25.39           C  
ATOM   1575  N   LEU   220      18.187  51.819  80.169  1.00 25.54           N  
ATOM   1576  CA  LEU   220      18.692  52.997  79.476  1.00 27.04           C  
ATOM   1577  C   LEU   220      19.386  52.619  78.174  1.00 28.12           C  
ATOM   1578  O   LEU   220      19.172  53.270  77.144  1.00 28.33           O  
ATOM   1579  CB  LEU   220      19.634  53.807  80.374  1.00 26.43           C  
ATOM   1580  CG  LEU   220      19.002  54.483  81.590  1.00 26.91           C  
ATOM   1581  CD1 LEU   220      20.094  55.036  82.481  1.00 27.57           C  
ATOM   1582  CD2 LEU   220      18.055  55.610  81.179  1.00 27.32           C  
ATOM   1583  N   ASP   221      20.200  51.564  78.225  1.00 29.53           N  
ATOM   1584  CA  ASP   221      20.895  51.032  77.049  1.00 31.16           C  
ATOM   1585  C   ASP   221      19.937  50.615  75.931  1.00 31.94           C  
ATOM   1586  O   ASP   221      20.264  50.755  74.758  1.00 32.24           O  
ATOM   1587  CB  ASP   221      21.791  49.846  77.439  1.00 31.24           C  
ATOM   1588  CG  ASP   221      23.006  50.264  78.275  1.00 32.36           C  
ATOM   1589  OD1 ASP   221      23.280  51.474  78.391  1.00 33.17           O  
ATOM   1590  OD2 ASP   221      23.705  49.376  78.818  1.00 35.61           O  
ATOM   1591  N   SER   222      18.757  50.120  76.305  1.00 32.95           N  
ATOM   1592  CA  SER   222      17.781  49.572  75.364  1.00 33.87           C  
ATOM   1593  C   SER   222      16.750  50.594  74.896  1.00 34.94           C  
ATOM   1594  O   SER   222      15.929  50.294  74.025  1.00 34.97           O  
ATOM   1595  CB  SER   222      17.047  48.385  76.001  1.00 34.09           C  
ATOM   1596  OG  SER   222      17.963  47.513  76.653  1.00 34.66           O  
ATOM   1597  N   HIS   223      16.778  51.798  75.464  1.00 36.03           N  
ATOM   1598  CA  HIS   223      15.757  52.790  75.143  1.00 37.15           C  
ATOM   1599  C   HIS   223      16.294  54.134  74.668  1.00 38.12           C  
ATOM   1600  O   HIS   223      15.551  54.895  74.040  1.00 38.18           O  
ATOM   1601  CB  HIS   223      14.789  52.974  76.323  1.00 37.17           C  
ATOM   1602  CG  HIS   223      13.743  51.909  76.404  1.00 37.36           C  
ATOM   1603  ND1 HIS   223      14.018  50.623  76.826  1.00 37.61           N  
ATOM   1604  CD2 HIS   223      12.425  51.929  76.098  1.00 37.20           C  
ATOM   1605  CE1 HIS   223      12.917  49.897  76.768  1.00 37.08           C  
ATOM   1606  NE2 HIS   223      11.935  50.666  76.335  1.00 37.54           N  
ATOM   1607  N   PHE   224      17.572  54.409  74.950  1.00 39.22           N  
ATOM   1608  CA  PHE   224      18.176  55.732  74.729  1.00 40.84           C  
ATOM   1609  C   PHE   224      19.500  55.665  73.975  1.00 42.17           C  
ATOM   1610  O   PHE   224      20.574  55.813  74.574  1.00 42.30           O  
ATOM   1611  CB  PHE   224      18.410  56.467  76.057  1.00 40.28           C  
ATOM   1612  CG  PHE   224      17.159  56.733  76.846  1.00 40.60           C  
ATOM   1613  CD1 PHE   224      16.437  57.912  76.656  1.00 41.16           C  
ATOM   1614  CD2 PHE   224      16.710  55.818  77.795  1.00 39.79           C  
ATOM   1615  CE1 PHE   224      15.280  58.164  77.394  1.00 40.08           C  
ATOM   1616  CE2 PHE   224      15.556  56.067  78.537  1.00 39.99           C  
ATOM   1617  CZ  PHE   224      14.846  57.245  78.336  1.00 39.69           C  
ATOM   1618  N   LEU   225      19.418  55.491  72.660  1.00 43.99           N  
ATOM   1619  CA  LEU   225      20.603  55.358  71.809  1.00 45.86           C  
ATOM   1620  C   LEU   225      21.442  56.631  71.688  1.00 47.36           C  
ATOM   1621  O   LEU   225      22.664  56.564  71.752  1.00 47.74           O  
ATOM   1622  CB  LEU   225      20.205  54.863  70.418  1.00 45.80           C  
ATOM   1623  CG  LEU   225      21.306  54.334  69.507  1.00 45.27           C  
ATOM   1624  CD1 LEU   225      21.929  53.057  70.070  1.00 45.63           C  
ATOM   1625  CD2 LEU   225      20.739  54.089  68.139  1.00 45.60           C  
ATOM   1626  N   GLU   226      20.786  57.778  71.515  1.00 49.44           N  
ATOM   1627  CA  GLU   226      21.468  59.074  71.357  1.00 51.36           C  
ATOM   1628  C   GLU   226      22.528  59.291  72.425  1.00 52.45           C  
ATOM   1629  O   GLU   226      23.570  59.922  72.176  1.00 52.97           O  
ATOM   1630  CB  GLU   226      20.453  60.223  71.403  1.00 51.46           C  
ATOM   1631  CG  GLU   226      21.032  61.641  71.627  1.00 52.72           C  
ATOM   1632  CD  GLU   226      21.647  62.272  70.373  1.00 54.66           C  
ATOM   1633  OE1 GLU   226      21.072  63.264  69.877  1.00 55.44           O  
ATOM   1634  OE2 GLU   226      22.700  61.794  69.884  1.00 54.72           O  
ATOM   1635  N   HIS   227      22.262  58.748  73.608  1.00 53.45           N  
ATOM   1636  CA  HIS   227      23.068  59.038  74.777  1.00 54.58           C  
ATOM   1637  C   HIS   227      24.036  57.906  75.118  1.00 55.30           C  
ATOM   1638  O   HIS   227      24.594  57.858  76.219  1.00 55.38           O  
ATOM   1639  CB  HIS   227      22.155  59.454  75.930  1.00 54.51           C  
ATOM   1640  CG  HIS   227      21.139  60.477  75.525  1.00 54.96           C  
ATOM   1641  ND1 HIS   227      21.406  61.831  75.521  1.00 55.08           N  
ATOM   1642  CD2 HIS   227      19.874  60.342  75.056  1.00 54.97           C  
ATOM   1643  CE1 HIS   227      20.341  62.486  75.093  1.00 55.61           C  
ATOM   1644  NE2 HIS   227      19.400  61.606  74.800  1.00 55.48           N  
ATOM   1645  N   HIS   228      24.236  57.008  74.149  1.00 56.36           N  
ATOM   1646  CA  HIS   228      25.372  56.085  74.150  1.00 57.52           C  
ATOM   1647  C   HIS   228      26.635  56.917  73.937  1.00 58.06           C  
ATOM   1648  O   HIS   228      26.657  57.819  73.089  1.00 58.17           O  
ATOM   1649  CB  HIS   228      25.252  55.050  73.018  1.00 57.60           C  
ATOM   1650  CG  HIS   228      24.456  53.827  73.372  1.00 58.96           C  
ATOM   1651  ND1 HIS   228      24.986  52.553  73.320  1.00 59.73           N  
ATOM   1652  CD2 HIS   228      23.166  53.678  73.761  1.00 59.37           C  
ATOM   1653  CE1 HIS   228      24.062  51.676  73.672  1.00 59.53           C  
ATOM   1654  NE2 HIS   228      22.948  52.333  73.945  1.00 59.31           N  
ATOM   1655  N   HIS   229      27.671  56.627  74.719  1.00 58.87           N  
ATOM   1656  CA  HIS   229      28.986  57.271  74.578  1.00 59.58           C  
ATOM   1657  C   HIS   229      30.072  56.210  74.687  1.00 59.86           C  
ATOM   1658  O   HIS   229      29.776  55.031  74.898  1.00 59.79           O  
ATOM   1659  CB  HIS   229      29.198  58.358  75.649  1.00 59.59           C  
ATOM   1660  CG  HIS   229      28.194  59.468  75.592  1.00 60.20           C  
ATOM   1661  ND1 HIS   229      28.368  60.593  74.814  1.00 60.56           N  
ATOM   1662  CD2 HIS   229      26.996  59.618  76.206  1.00 60.58           C  
ATOM   1663  CE1 HIS   229      27.322  61.389  74.952  1.00 60.77           C  
ATOM   1664  NE2 HIS   229      26.474  60.820  75.791  1.00 60.72           N  
ATOM   1665  N   HIS   230      31.326  56.631  74.544  1.00 60.45           N  
ATOM   1666  CA  HIS   230      32.465  55.724  74.694  1.00 60.79           C  
ATOM   1667  C   HIS   230      33.388  56.146  75.844  1.00 61.00           C  
ATOM   1668  O   HIS   230      33.291  57.263  76.368  1.00 61.04           O  
ATOM   1669  CB  HIS   230      33.245  55.622  73.379  1.00 60.89           C  
ATOM   1670  CG  HIS   230      32.391  55.317  72.184  1.00 60.82           C  
ATOM   1671  ND1 HIS   230      31.833  54.076  71.962  1.00 61.25           N  
ATOM   1672  CD2 HIS   230      32.013  56.091  71.138  1.00 60.97           C  
ATOM   1673  CE1 HIS   230      31.145  54.099  70.833  1.00 61.29           C  
ATOM   1674  NE2 HIS   230      31.239  55.310  70.313  1.00 60.92           N  
END
