
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  157 ( 1251),  selected  157 , name 2gey_A
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 2gey_A.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      M       2           -
LGA    -       -      T       3           -
LGA    -       -      H       4           -
LGA    -       -      Y       5           -
LGA    -       -      S       6           -
LGA    -       -      D       7           -
LGA    S     2_A      N       8          2.231
LGA    M     3_A      T       9          3.889
LGA    A     4_A      L      10          3.896
LGA    E     5_A      K      11          1.363
LGA    R     6_A      V      12          2.436
LGA    K     7_A      A      13          3.917
LGA    A     8_A      H      14          2.813
LGA    L     9_A      Q      15          1.357
LGA    C    10_A      G      16          2.749
LGA    L    11_A      F      17          2.980
LGA    E    12_A      E      18          2.131
LGA    M    13_A      F      19          2.098
LGA    V    14_A      F      20          3.021
LGA    A    15_A      T      21          3.507
LGA    A    16_A      Q      22          2.267
LGA    W    17_A      G      23          1.949
LGA    -       -      L      24           -
LGA    N    18_A      A      25          2.668
LGA    R    19_A      T      26          3.303
LGA    W    20_A      G      27          2.690
LGA    D    21_A      E      28          1.385
LGA    L    22_A      W      29          0.970
LGA    S    23_A      Q      30          0.750
LGA    G    24_A      K      31          1.538
LGA    I    25_A      F      32          1.259
LGA    I    26_A      L      33          0.713
LGA    K    27_A      D      34          0.899
LGA    H    28_A      M      35          0.821
LGA    W    29_A      L      36          0.447
LGA    S    30_A      T      37          0.325
LGA    P    31_A      E      38          0.639
LGA    D    32_A      D      39          0.981
LGA    I    33_A      F      40          0.918
LGA    V    34_A      T      41          1.522
LGA    H    35_A      F      42          1.391
LGA    Y    36_A      W      43          2.050
LGA    S    37_A      F      44          3.006
LGA    E    38_A      P      45          4.472
LGA    D    39_A      M      46           -
LGA    -       -      G      47           -
LGA    -       -      E      48           -
LGA    -       -      F      49           -
LGA    -       -      H      50           -
LGA    N    40_A      G      51          3.287
LGA    E    41_A      L      52          1.012
LGA    V    42_A      N      53          1.696
LGA    S    43_A      V      54          3.182
LGA    S    44_A      G      55          3.693
LGA    -       -      K      56           -
LGA    A    45_A      E      57          4.030
LGA    D    46_A      R      58          4.050
LGA    M    47_A      A      59          3.717
LGA    V    48_A      K      60          2.627
LGA    K    49_A      E      61          2.278
LGA    L    50_A      F      62          2.891
LGA    M    51_A      F      63          1.803
LGA    E    52_A      T      64          1.193
LGA    G    53_A      Y      65          2.127
LGA    G    54_A      V      66          2.134
LGA    L    55_A      S      67          0.913
LGA    K    56_A      E      68          1.626
LGA    A    57_A      S      69          0.474
LGA    F    58_A      F      70          0.879
LGA    P    59_A      H      71          2.362
LGA    D    60_A      T      72          2.086
LGA    L    61_A      G      73          2.554
LGA    -       -      I      74           -
LGA    Q    62_A      Q      75          1.178
LGA    L    63_A      I      76          2.242
LGA    E    64_A      S      77          3.446
LGA    V    65_A      S      78          4.312
LGA    K    66_A      L      79          2.347
LGA    -       -      D      80           -
LGA    S    67_A      R      81          1.974
LGA    I    68_A      V      82          1.606
LGA    M    69_A      T      83          1.794
LGA    A    70_A      S      84          2.047
LGA    E    71_A      N      85          1.608
LGA    E    72_A      E      86          0.740
LGA    D    73_A      T      87          1.531
LGA    R    74_A      T      88          1.250
LGA    V    75_A      V      89          0.942
LGA    A    76_A      V      90          0.645
LGA    L    77_A      F      91          0.566
LGA    R    78_A      E      92          1.041
LGA    I    79_A      F      93          2.065
LGA    T    80_A      R      94          1.821
LGA    V    81_A      D      95          1.989
LGA    T    82_A      E      96          0.646
LGA    A    83_A      G      97          0.618
LGA    T    84_A      L      98          1.128
LGA    H    85_A      F      99          2.153
LGA    Q    86_A      L     100          2.430
LGA    G    87_A      -       -           -
LGA    E    88_A      -       -           -
LGA    F    89_A      -       -           -
LGA    M    90_A      -       -           -
LGA    G    91_A      -       -           -
LGA    V    92_A      -       -           -
LGA    Q    93_A      -       -           -
LGA    P    94_A      -       -           -
LGA    T    95_A      -       -           -
LGA    G    96_A      G     101          1.831
LGA    Q    97_A      K     102          2.427
LGA    R    98_A      P     103          2.042
LGA    V    99_A      Y     104          1.646
LGA    S   100_A      K     105          1.031
LGA    W   101_A      N     106          1.891
LGA    H   102_A      R     107          2.124
LGA    L   103_A      V     108          1.408
LGA    V   104_A      A     109          0.731
LGA    E   105_A      V     110          0.721
LGA    E   106_A      S     111          0.611
LGA    L   107_A      F     112          0.606
LGA    R   108_A      D     113          0.704
LGA    F   109_A      V     114          0.904
LGA    V   110_A      R     115          0.880
LGA    D   111_A      G     116          1.364
LGA    G   112_A      D     117          1.116
LGA    K   113_A      K     118          0.846
LGA    V   114_A      I     119          0.840
LGA    V   115_A      C     120          0.988
LGA    E   116_A      S     121          1.596
LGA    H   117_A      Y     122          1.284
LGA    W   118_A      R     123          1.371
LGA    D   119_A      E     124          1.347
LGA    V   120_A      Y     125          0.974
LGA    I   121_A      F     126          2.441
LGA    N   122_A      G     127          4.197
LGA    M   123_A      S     128          6.102
LGA    R   124_A      D     129          2.010
LGA    P   125_A      G     130          2.418
LGA    L   126_A      K     131          4.628
LGA    L   127_A      S     132           #
LGA    V   128_A      N     133           -
LGA    R   129_A      -       -           -
LGA    L   130_A      -       -           -
LGA    G   131_A      -       -           -
LGA    K   132_A      -       -           -
LGA    L   133_A      -       -           -
LGA    P   134_A      -       -           -
LGA    D   135_A      -       -           -
LGA    V   136_A      -       -           -
LGA    P   137_A      -       -           -
LGA    K   138_A      -       -           -
LGA    V   139_A      -       -           -
LGA    V   140_A      -       -           -
LGA    L   141_A      -       -           -
LGA    E   142_A      -       -           -
LGA    A   143_A      -       -           -
LGA    S   144_A      -       -           -
LGA    A   145_A      -       -           -
LGA    K   146_A      -       -           -
LGA    L   147_A      -       -           -
LGA    A   148_A      -       -           -
LGA    A   149_A      -       -           -
LGA    A   150_A      -       -           -
LGA    L   151_A      -       -           -
LGA    E   152_A      -       -           -
LGA    H   153_A      -       -           -
LGA    H   154_A      -       -           -
LGA    H   155_A      -       -           -
LGA    H   156_A      -       -           -
LGA    H   157_A      -       -           -
LGA    H   158_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  157  133    5.0    115    2.22     6.96     71.100     4.958

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.966313 * X  +   0.000545 * Y  +  -0.257369 * Z  +  54.836296
  Y_new =  -0.019502 * X  +   0.996968 * Y  +   0.075333 * Z  +  -4.890286
  Z_new =   0.256630 * X  +   0.077815 * Y  +  -0.963372 * Z  +  34.913902 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.060994   -0.080598  [ DEG:   175.3820     -4.6179 ]
  Theta =  -0.259534   -2.882059  [ DEG:   -14.8702   -165.1298 ]
  Phi   =  -3.121413    0.020179  [ DEG:  -178.8438      1.1562 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gey_A                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gey_A.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  157  133   5.0  115   2.22    6.96  71.100
REMARK  ---------------------------------------------------------- 
MOLECULE 2gey_A
HEADER    OXIDOREDUCTASE                          21-MAR-06   2GEY              
TITLE     CRYSTAL STRUCTURE OF ACLR A PUTATIVE HYDROXYLASE FROM                 
TITLE    2 STREPTOMYCES GALILAEUS                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACLR PROTEIN;                                              
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: PUTATIVE HYDROXYLASE;                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES GALILAEUS;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: ATCC31133;                                                   
SOURCE   5 GENE: ACLR;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET30B                                    
KEYWDS    ALPHA+BETA BARREL                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.BEINKER,B.LOHKAMP,G.SCHNEIDER                                       
REVDAT   1   18-JUL-06 2GEY    0                                                
JRNL        AUTH   P.BEINKER,B.LOHKAMP,T.PELTONEN,J.NIEMI,P.MANTSALA,           
JRNL        AUTH 2 G.SCHNEIDER                                                  
JRNL        TITL   CRYSTAL STRUCTURES OF SNOAL2 AND ACLR: TWO                   
JRNL        TITL 2 PUTATIVE HYDROXYLASES IN THE BIOSYNTHESIS OF                 
JRNL        TITL 3 AROMATIC POLYKETIDE ANTIBIOTICS                              
JRNL        REF    J.MOL.BIOL.                   V. 359   728 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2GEY A    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY B    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY C    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY D    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
SEQRES   1 A  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 A  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 A  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 A  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 A  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 A  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 A  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 A  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 A  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 A  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 A  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 A  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 A  158  HIS HIS                                                      
SEQRES   1 B  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 B  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 B  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 B  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 B  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 B  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 B  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 B  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 B  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 B  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 B  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 B  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 B  158  HIS HIS                                                      
SEQRES   1 C  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 C  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 C  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 C  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 C  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 C  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 C  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 C  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 C  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 C  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 C  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 C  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 C  158  HIS HIS                                                      
SEQRES   1 D  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 D  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 D  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 D  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 D  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 D  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 D  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 D  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 D  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 D  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 D  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 D  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 D  158  HIS HIS                                                      
HET    PG4   1001      13                                                       
HET    PG4   1002      13                                                       
HET    PG4   1003      13                                                       
HET    PG4   1004      13                                                       
HET    GOL   2001       6                                                       
HET    GOL   2002       6                                                       
HET    GOL   2003       6                                                       
HET    GOL   2004       6                                                       
HET    GOL   2005       6                                                       
HET    PEG   3001       7                                                       
HETNAM     PG4 TETRAETHYLENE GLYCOL                                             
HETNAM     GOL GLYCEROL                                                         
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
FORMUL   5  PG4    4(C8 H18 O5)                                                 
FORMUL   9  GOL    5(C3 H8 O3)                                                  
FORMUL  14  PEG    C4 H10 O3                                                    
FORMUL  15  HOH   *548(H2 O)                                                    
CRYST1   80.908   81.724  136.640  90.00  90.00  90.00 P 21 21 21   16          
ATOM      1  N   SER A   2      37.619  16.689  10.129  1.00 26.72           N  
ATOM      2  CA  SER A   2      37.766  15.370   9.456  1.00 26.13           C  
ATOM      3  C   SER A   2      36.425  14.665   9.425  1.00 25.81           C  
ATOM      4  O   SER A   2      35.503  15.053  10.142  1.00 24.97           O  
ATOM      5  CB  SER A   2      38.744  14.503  10.238  1.00 26.55           C  
ATOM      6  OG  SER A   2      38.142  14.082  11.447  1.00 26.94           O  
ATOM      7  N   MET A   3      36.338  13.601   8.628  1.00 25.34           N  
ATOM      8  CA  MET A   3      35.128  12.791   8.566  1.00 25.35           C  
ATOM      9  C   MET A   3      34.764  12.239   9.946  1.00 24.81           C  
ATOM     10  O   MET A   3      33.609  12.260  10.333  1.00 24.58           O  
ATOM     11  CB  MET A   3      35.311  11.640   7.575  1.00 25.05           C  
ATOM     12  CG  MET A   3      35.354  12.081   6.120  1.00 25.03           C  
ATOM     13  SD  MET A   3      35.618  10.723   4.969  1.00 26.97           S  
ATOM     14  CE  MET A   3      37.385  10.489   5.131  1.00 28.03           C  
ATOM     15  N   ALA A   4      35.765  11.762  10.681  1.00 24.85           N  
ATOM     16  CA  ALA A   4      35.553  11.212  12.019  1.00 24.80           C  
ATOM     17  C   ALA A   4      34.937  12.247  12.959  1.00 24.79           C  
ATOM     18  O   ALA A   4      34.010  11.939  13.708  1.00 23.92           O  
ATOM     19  CB  ALA A   4      36.860  10.708  12.583  1.00 24.99           C  
ATOM     20  N   GLU A   5      35.444  13.478  12.907  1.00 24.45           N  
ATOM     21  CA  GLU A   5      34.944  14.553  13.762  1.00 25.10           C  
ATOM     22  C   GLU A   5      33.525  14.958  13.388  1.00 24.71           C  
ATOM     23  O   GLU A   5      32.694  15.219  14.264  1.00 24.50           O  
ATOM     24  CB  GLU A   5      35.877  15.760  13.695  1.00 25.33           C  
ATOM     25  CG  GLU A   5      37.184  15.483  14.425  1.00 27.00           C  
ATOM     26  CD  GLU A   5      38.356  16.314  13.949  1.00 28.19           C  
ATOM     27  OE1 GLU A   5      38.216  17.137  13.007  1.00 31.15           O  
ATOM     28  OE2 GLU A   5      39.430  16.136  14.557  1.00 30.53           O  
ATOM     29  N   ARG A   6      33.241  15.012  12.089  1.00 24.61           N  
ATOM     30  CA  ARG A   6      31.899  15.370  11.635  1.00 24.65           C  
ATOM     31  C   ARG A   6      30.885  14.281  12.005  1.00 24.54           C  
ATOM     32  O   ARG A   6      29.764  14.600  12.408  1.00 24.63           O  
ATOM     33  CB  ARG A   6      31.883  15.696  10.145  1.00 24.48           C  
ATOM     34  CG  ARG A   6      32.628  16.995   9.839  1.00 24.31           C  
ATOM     35  CD  ARG A   6      32.560  17.375   8.382  1.00 25.46           C  
ATOM     36  NE  ARG A   6      33.478  16.604   7.547  1.00 25.06           N  
ATOM     37  CZ  ARG A   6      34.777  16.871   7.390  1.00 26.31           C  
ATOM     38  NH1 ARG A   6      35.353  17.885   8.015  1.00 26.08           N  
ATOM     39  NH2 ARG A   6      35.516  16.104   6.597  1.00 26.83           N  
ATOM     40  N   LYS A   7      31.274  13.013  11.898  1.00 24.75           N  
ATOM     41  CA  LYS A   7      30.428  11.915  12.408  1.00 24.97           C  
ATOM     42  C   LYS A   7      30.133  12.098  13.895  1.00 24.88           C  
ATOM     43  O   LYS A   7      28.978  12.004  14.328  1.00 24.53           O  
ATOM     44  CB  LYS A   7      31.059  10.552  12.144  1.00 25.18           C  
ATOM     45  CG  LYS A   7      31.012  10.179  10.671  1.00 25.92           C  
ATOM     46  CD  LYS A   7      31.378   8.717  10.411  1.00 27.53           C  
ATOM     47  CE  LYS A   7      32.855   8.432  10.602  1.00 30.51           C  
ATOM     48  NZ  LYS A   7      33.212   7.082  10.024  1.00 30.62           N  
ATOM     49  N   ALA A   8      31.167  12.394  14.674  1.00 24.72           N  
ATOM     50  CA  ALA A   8      30.994  12.612  16.115  1.00 24.88           C  
ATOM     51  C   ALA A   8      30.022  13.749  16.392  1.00 25.01           C  
ATOM     52  O   ALA A   8      29.164  13.638  17.273  1.00 25.36           O  
ATOM     53  CB  ALA A   8      32.340  12.876  16.784  1.00 25.00           C  
ATOM     54  N   LEU A   9      30.128  14.849  15.644  1.00 24.76           N  
ATOM     55  CA  LEU A   9      29.201  15.971  15.842  1.00 24.84           C  
ATOM     56  C   LEU A   9      27.768  15.557  15.508  1.00 24.49           C  
ATOM     57  O   LEU A   9      26.829  15.880  16.235  1.00 24.30           O  
ATOM     58  CB  LEU A   9      29.618  17.183  15.011  1.00 24.82           C  
ATOM     59  CG  LEU A   9      30.878  17.890  15.530  1.00 25.78           C  
ATOM     60  CD1 LEU A   9      31.440  18.828  14.478  1.00 27.84           C  
ATOM     61  CD2 LEU A   9      30.583  18.627  16.844  1.00 25.82           C  
ATOM     62  N   CYS A  10      27.594  14.806  14.427  1.00 24.72           N  
ATOM     63  CA  CYS A  10      26.255  14.297  14.075  1.00 25.06           C  
ATOM     64  C   CYS A  10      25.681  13.397  15.171  1.00 25.18           C  
ATOM     65  O   CYS A  10      24.489  13.446  15.476  1.00 25.11           O  
ATOM     66  CB  CYS A  10      26.299  13.550  12.741  1.00 24.83           C  
ATOM     67  SG  CYS A  10      26.590  14.655  11.349  1.00 27.30           S  
ATOM     68  N   LEU A  11      26.525  12.588  15.779  1.00 25.16           N  
ATOM     69  CA  LEU A  11      26.061  11.722  16.856  1.00 25.24           C  
ATOM     70  C   LEU A  11      25.730  12.512  18.119  1.00 25.51           C  
ATOM     71  O   LEU A  11      24.907  12.084  18.925  1.00 25.14           O  
ATOM     72  CB  LEU A  11      27.072  10.610  17.114  1.00 25.07           C  
ATOM     73  CG  LEU A  11      27.222   9.626  15.944  1.00 25.50           C  
ATOM     74  CD1 LEU A  11      28.288   8.611  16.252  1.00 27.88           C  
ATOM     75  CD2 LEU A  11      25.901   8.910  15.641  1.00 26.80           C  
ATOM     76  N   GLU A  12      26.328  13.691  18.270  1.00 26.03           N  
ATOM     77  CA  GLU A  12      25.931  14.593  19.353  1.00 26.14           C  
ATOM     78  C   GLU A  12      24.549  15.178  19.122  1.00 25.87           C  
ATOM     79  O   GLU A  12      23.782  15.381  20.074  1.00 26.14           O  
ATOM     80  CB  GLU A  12      26.975  15.699  19.565  1.00 27.15           C  
ATOM     81  CG  GLU A  12      28.266  15.182  20.188  1.00 29.50           C  
ATOM     82  CD  GLU A  12      28.020  14.353  21.422  1.00 36.70           C  
ATOM     83  OE1 GLU A  12      27.684  14.935  22.478  1.00 41.40           O  
ATOM     84  OE2 GLU A  12      28.137  13.106  21.331  1.00 41.96           O  
ATOM     85  N   MET A  13      24.233  15.456  17.864  1.00 25.56           N  
ATOM     86  CA  MET A  13      22.899  15.881  17.486  1.00 25.89           C  
ATOM     87  C   MET A  13      21.873  14.765  17.737  1.00 24.81           C  
ATOM     88  O   MET A  13      20.803  15.023  18.272  1.00 24.33           O  
ATOM     89  CB  MET A  13      22.895  16.354  16.032  1.00 25.82           C  
ATOM     90  CG  MET A  13      23.764  17.571  15.823  1.00 27.64           C  
ATOM     91  SD  MET A  13      23.919  18.020  14.081  1.00 31.40           S  
ATOM     92  CE  MET A  13      22.473  19.023  13.870  1.00 33.06           C  
ATOM     93  N   VAL A  14      22.222  13.527  17.400  1.00 24.80           N  
ATOM     94  CA  VAL A  14      21.382  12.366  17.755  1.00 24.70           C  
ATOM     95  C   VAL A  14      21.191  12.288  19.281  1.00 24.13           C  
ATOM     96  O   VAL A  14      20.069  12.107  19.777  1.00 23.96           O  
ATOM     97  CB  VAL A  14      21.982  11.040  17.208  1.00 25.10           C  
ATOM     98  CG1 VAL A  14      21.212   9.835  17.720  1.00 25.87           C  
ATOM     99  CG2 VAL A  14      21.993  11.030  15.678  1.00 25.84           C  
ATOM    100  N   ALA A  15      22.277  12.450  20.028  1.00 24.07           N  
ATOM    101  CA  ALA A  15      22.198  12.396  21.490  1.00 23.98           C  
ATOM    102  C   ALA A  15      21.258  13.475  22.024  1.00 23.34           C  
ATOM    103  O   ALA A  15      20.507  13.216  22.957  1.00 23.15           O  
ATOM    104  CB  ALA A  15      23.564  12.529  22.116  1.00 24.52           C  
ATOM    105  N   ALA A  16      21.294  14.666  21.419  1.00 23.38           N  
ATOM    106  CA  ALA A  16      20.405  15.765  21.784  1.00 23.30           C  
ATOM    107  C   ALA A  16      18.938  15.380  21.587  1.00 23.26           C  
ATOM    108  O   ALA A  16      18.112  15.608  22.474  1.00 23.10           O  
ATOM    109  CB  ALA A  16      20.739  17.019  20.986  1.00 24.17           C  
ATOM    110  N   TRP A  17      18.620  14.801  20.427  1.00 22.72           N  
ATOM    111  CA  TRP A  17      17.284  14.252  20.186  1.00 23.09           C  
ATOM    112  C   TRP A  17      16.906  13.285  21.299  1.00 22.63           C  
ATOM    113  O   TRP A  17      15.792  13.320  21.807  1.00 23.15           O  
ATOM    114  CB  TRP A  17      17.214  13.507  18.848  1.00 23.68           C  
ATOM    115  CG  TRP A  17      16.737  14.366  17.708  1.00 24.22           C  
ATOM    116  CD1 TRP A  17      17.426  14.700  16.588  1.00 26.00           C  
ATOM    117  CD2 TRP A  17      15.456  14.990  17.594  1.00 25.13           C  
ATOM    118  NE1 TRP A  17      16.654  15.501  15.779  1.00 26.16           N  
ATOM    119  CE2 TRP A  17      15.442  15.700  16.379  1.00 25.94           C  
ATOM    120  CE3 TRP A  17      14.322  15.023  18.408  1.00 24.99           C  
ATOM    121  CZ2 TRP A  17      14.326  16.427  15.947  1.00 26.42           C  
ATOM    122  CZ3 TRP A  17      13.214  15.749  17.979  1.00 26.24           C  
ATOM    123  CH2 TRP A  17      13.231  16.439  16.757  1.00 25.73           C  
ATOM    124  N   ASN A  18      17.839  12.419  21.659  1.00 22.38           N  
ATOM    125  CA  ASN A  18      17.533  11.317  22.575  1.00 22.89           C  
ATOM    126  C   ASN A  18      17.392  11.721  24.035  1.00 22.68           C  
ATOM    127  O   ASN A  18      16.895  10.924  24.845  1.00 22.86           O  
ATOM    128  CB  ASN A  18      18.559  10.195  22.418  1.00 23.32           C  
ATOM    129  CG  ASN A  18      18.291   9.334  21.185  1.00 24.01           C  
ATOM    130  OD1 ASN A  18      17.160   9.302  20.673  1.00 26.00           O  
ATOM    131  ND2 ASN A  18      19.309   8.628  20.717  1.00 24.33           N  
ATOM    132  N   ARG A  19      17.835  12.927  24.370  1.00 22.70           N  
ATOM    133  CA  ARG A  19      17.507  13.539  25.665  1.00 23.44           C  
ATOM    134  C   ARG A  19      16.461  14.654  25.522  1.00 23.32           C  
ATOM    135  O   ARG A  19      16.186  15.397  26.475  1.00 22.30           O  
ATOM    136  CB  ARG A  19      18.769  14.025  26.388  1.00 23.82           C  
ATOM    137  CG  ARG A  19      19.517  15.097  25.699  1.00 24.54           C  
ATOM    138  CD  ARG A  19      20.617  15.714  26.591  1.00 25.25           C  
ATOM    139  NE  ARG A  19      21.140  16.870  25.888  1.00 26.57           N  
ATOM    140  CZ  ARG A  19      22.109  16.834  24.983  1.00 26.12           C  
ATOM    141  NH1 ARG A  19      22.746  15.711  24.712  1.00 27.00           N  
ATOM    142  NH2 ARG A  19      22.458  17.952  24.361  1.00 27.92           N  
ATOM    143  N   TRP A  20      15.851  14.730  24.341  1.00 23.81           N  
ATOM    144  CA  TRP A  20      14.736  15.639  24.071  1.00 24.01           C  
ATOM    145  C   TRP A  20      15.095  17.117  24.263  1.00 24.51           C  
ATOM    146  O   TRP A  20      14.317  17.888  24.844  1.00 24.33           O  
ATOM    147  CB  TRP A  20      13.520  15.221  24.911  1.00 24.48           C  
ATOM    148  CG  TRP A  20      13.318  13.747  24.824  1.00 24.12           C  
ATOM    149  CD1 TRP A  20      13.008  13.031  23.706  1.00 24.36           C  
ATOM    150  CD2 TRP A  20      13.471  12.795  25.878  1.00 24.35           C  
ATOM    151  NE1 TRP A  20      12.943  11.699  24.002  1.00 24.83           N  
ATOM    152  CE2 TRP A  20      13.228  11.522  25.329  1.00 24.71           C  
ATOM    153  CE3 TRP A  20      13.802  12.893  27.233  1.00 24.93           C  
ATOM    154  CZ2 TRP A  20      13.290  10.355  26.088  1.00 25.02           C  
ATOM    155  CZ3 TRP A  20      13.868  11.731  27.986  1.00 25.30           C  
ATOM    156  CH2 TRP A  20      13.603  10.481  27.415  1.00 25.13           C  
ATOM    157  N   ASP A  21      16.264  17.487  23.738  1.00 24.61           N  
ATOM    158  CA  ASP A  21      16.844  18.823  23.872  1.00 24.84           C  
ATOM    159  C   ASP A  21      17.020  19.454  22.490  1.00 24.84           C  
ATOM    160  O   ASP A  21      18.059  19.284  21.858  1.00 24.78           O  
ATOM    161  CB  ASP A  21      18.207  18.718  24.565  1.00 25.34           C  
ATOM    162  CG  ASP A  21      18.953  20.051  24.619  1.00 26.20           C  
ATOM    163  OD1 ASP A  21      18.325  21.117  24.460  1.00 29.18           O  
ATOM    164  OD2 ASP A  21      20.180  20.022  24.829  1.00 30.91           O  
ATOM    165  N   LEU A  22      16.018  20.182  22.015  1.00 24.93           N  
ATOM    166  CA  LEU A  22      16.094  20.716  20.656  1.00 25.32           C  
ATOM    167  C   LEU A  22      17.210  21.752  20.508  1.00 25.35           C  
ATOM    168  O   LEU A  22      17.793  21.873  19.438  1.00 24.93           O  
ATOM    169  CB  LEU A  22      14.753  21.292  20.203  1.00 25.56           C  
ATOM    170  CG  LEU A  22      13.576  20.315  20.135  1.00 26.76           C  
ATOM    171  CD1 LEU A  22      12.339  21.027  19.608  1.00 28.93           C  
ATOM    172  CD2 LEU A  22      13.918  19.121  19.281  1.00 28.72           C  
ATOM    173  N   SER A  23      17.510  22.486  21.580  1.00 25.33           N  
ATOM    174  CA  SER A  23      18.574  23.494  21.549  0.50 25.60           C  
ATOM    176  C   SER A  23      19.928  22.860  21.221  1.00 25.92           C  
ATOM    177  O   SER A  23      20.767  23.479  20.564  1.00 25.89           O  
ATOM    178  CB  SER A  23      18.664  24.250  22.887  0.50 25.59           C  
ATOM    180  OG  SER A  23      19.364  23.490  23.860  0.50 24.24           O  
ATOM    182  N   GLY A  24      20.133  21.622  21.677  1.00 26.01           N  
ATOM    183  CA  GLY A  24      21.365  20.864  21.435  1.00 26.42           C  
ATOM    184  C   GLY A  24      21.541  20.384  20.008  1.00 26.59           C  
ATOM    185  O   GLY A  24      22.628  19.962  19.617  1.00 26.74           O  
ATOM    186  N   ILE A  25      20.464  20.437  19.226  1.00 26.80           N  
ATOM    187  CA  ILE A  25      20.534  20.155  17.803  1.00 26.64           C  
ATOM    188  C   ILE A  25      20.807  21.460  17.052  1.00 26.51           C  
ATOM    189  O   ILE A  25      21.765  21.564  16.283  1.00 26.25           O  
ATOM    190  CB  ILE A  25      19.202  19.549  17.300  1.00 26.68           C  
ATOM    191  CG1 ILE A  25      18.869  18.268  18.072  1.00 27.64           C  
ATOM    192  CG2 ILE A  25      19.245  19.293  15.801  1.00 27.42           C  
ATOM    193  CD1 ILE A  25      17.432  17.924  18.030  1.00 27.95           C  
ATOM    194  N   ILE A  26      19.975  22.468  17.294  1.00 26.23           N  
ATOM    195  CA  ILE A  26      20.013  23.702  16.514  0.50 26.39           C  
ATOM    197  C   ILE A  26      21.316  24.491  16.741  1.00 26.53           C  
ATOM    198  O   ILE A  26      21.728  25.293  15.896  1.00 26.06           O  
ATOM    199  CB  ILE A  26      18.732  24.546  16.790  0.50 26.36           C  
ATOM    201  CG1 ILE A  26      17.508  23.804  16.229  0.50 26.50           C  
ATOM    203  CG2 ILE A  26      18.833  25.933  16.179  0.50 26.20           C  
ATOM    205  CD1 ILE A  26      16.190  24.185  16.862  0.50 26.70           C  
ATOM    207  N   LYS A  27      21.977  24.253  17.871  1.00 26.51           N  
ATOM    208  CA  LYS A  27      23.248  24.945  18.147  1.00 27.20           C  
ATOM    209  C   LYS A  27      24.334  24.604  17.121  1.00 27.02           C  
ATOM    210  O   LYS A  27      25.320  25.330  16.994  1.00 27.04           O  
ATOM    211  CB  LYS A  27      23.750  24.628  19.557  1.00 27.43           C  
ATOM    212  CG  LYS A  27      24.169  23.203  19.771  1.00 29.03           C  
ATOM    213  CD  LYS A  27      24.506  22.932  21.226  1.00 29.89           C  
ATOM    214  CE  LYS A  27      25.860  23.461  21.604  1.00 32.85           C  
ATOM    215  NZ  LYS A  27      26.286  22.933  22.936  1.00 34.42           N  
ATOM    216  N   HIS A  28      24.155  23.498  16.405  1.00 26.67           N  
ATOM    217  CA  HIS A  28      25.122  23.058  15.399  1.00 27.00           C  
ATOM    218  C   HIS A  28      24.787  23.553  14.002  1.00 26.94           C  
ATOM    219  O   HIS A  28      25.550  23.322  13.058  1.00 26.54           O  
ATOM    220  CB  HIS A  28      25.207  21.539  15.401  1.00 27.62           C  
ATOM    221  CG  HIS A  28      25.763  20.979  16.667  1.00 29.56           C  
ATOM    222  ND1 HIS A  28      27.074  21.172  17.048  1.00 32.16           N  
ATOM    223  CD2 HIS A  28      25.183  20.261  17.659  1.00 30.60           C  
ATOM    224  CE1 HIS A  28      27.284  20.569  18.206  1.00 33.21           C  
ATOM    225  NE2 HIS A  28      26.151  20.017  18.602  1.00 31.42           N  
ATOM    226  N   TRP A  29      23.650  24.232  13.863  1.00 26.17           N  
ATOM    227  CA  TRP A  29      23.242  24.763  12.571  1.00 26.52           C  
ATOM    228  C   TRP A  29      23.953  26.061  12.284  1.00 26.42           C  
ATOM    229  O   TRP A  29      24.065  26.925  13.161  1.00 26.12           O  
ATOM    230  CB  TRP A  29      21.747  25.049  12.557  1.00 26.02           C  
ATOM    231  CG  TRP A  29      20.863  23.875  12.612  1.00 25.70           C  
ATOM    232  CD1 TRP A  29      21.215  22.572  12.725  1.00 25.63           C  
ATOM    233  CD2 TRP A  29      19.437  23.910  12.587  1.00 26.58           C  
ATOM    234  NE1 TRP A  29      20.093  21.778  12.751  1.00 25.76           N  
ATOM    235  CE2 TRP A  29      18.985  22.582  12.672  1.00 26.10           C  
ATOM    236  CE3 TRP A  29      18.499  24.940  12.487  1.00 25.98           C  
ATOM    237  CZ2 TRP A  29      17.622  22.256  12.664  1.00 26.15           C  
ATOM    238  CZ3 TRP A  29      17.147  24.613  12.483  1.00 25.92           C  
ATOM    239  CH2 TRP A  29      16.725  23.287  12.573  1.00 25.40           C  
ATOM    240  N   SER A  30      24.411  26.225  11.052  1.00 26.71           N  
ATOM    241  CA  SER A  30      24.862  27.533  10.600  1.00 27.58           C  
ATOM    242  C   SER A  30      23.678  28.507  10.580  1.00 28.18           C  
ATOM    243  O   SER A  30      22.540  28.100  10.339  1.00 28.26           O  
ATOM    244  CB  SER A  30      25.459  27.447   9.198  1.00 27.42           C  
ATOM    245  OG  SER A  30      25.623  28.733   8.629  1.00 28.60           O  
ATOM    246  N   PRO A  31      23.942  29.801  10.809  1.00 28.82           N  
ATOM    247  CA  PRO A  31      22.918  30.816  10.541  1.00 29.21           C  
ATOM    248  C   PRO A  31      22.375  30.767   9.110  1.00 29.46           C  
ATOM    249  O   PRO A  31      21.241  31.179   8.873  1.00 30.03           O  
ATOM    250  CB  PRO A  31      23.661  32.135  10.761  1.00 29.58           C  
ATOM    251  CG  PRO A  31      24.801  31.795  11.642  1.00 29.37           C  
ATOM    252  CD  PRO A  31      25.186  30.390  11.333  1.00 29.16           C  
ATOM    253  N   ASP A  32      23.180  30.275   8.172  1.00 29.50           N  
ATOM    254  CA  ASP A  32      22.797  30.238   6.759  1.00 29.38           C  
ATOM    255  C   ASP A  32      22.350  28.861   6.285  1.00 28.75           C  
ATOM    256  O   ASP A  32      22.294  28.597   5.079  1.00 28.68           O  
ATOM    257  CB  ASP A  32      23.969  30.712   5.904  1.00 30.51           C  
ATOM    258  CG  ASP A  32      24.469  32.081   6.316  1.00 33.05           C  
ATOM    259  OD1 ASP A  32      23.645  33.021   6.393  1.00 37.55           O  
ATOM    260  OD2 ASP A  32      25.685  32.216   6.567  1.00 36.97           O  
ATOM    261  N   ILE A  33      22.018  27.987   7.229  1.00 27.45           N  
ATOM    262  CA  ILE A  33      21.589  26.640   6.908  1.00 26.86           C  
ATOM    263  C   ILE A  33      20.372  26.623   5.980  1.00 26.46           C  
ATOM    264  O   ILE A  33      19.460  27.461   6.095  1.00 25.85           O  
ATOM    265  CB  ILE A  33      21.282  25.825   8.193  1.00 26.47           C  
ATOM    266  CG1 ILE A  33      21.085  24.344   7.860  1.00 25.92           C  
ATOM    267  CG2 ILE A  33      20.057  26.389   8.924  1.00 26.74           C  
ATOM    268  CD1 ILE A  33      21.066  23.456   9.081  1.00 26.37           C  
ATOM    269  N   VAL A  34      20.394  25.693   5.029  1.00 26.11           N  
ATOM    270  CA  VAL A  34      19.239  25.400   4.187  1.00 26.23           C  
ATOM    271  C   VAL A  34      18.799  23.956   4.420  1.00 25.87           C  
ATOM    272  O   VAL A  34      19.626  23.034   4.467  1.00 25.53           O  
ATOM    273  CB  VAL A  34      19.558  25.614   2.693  1.00 26.40           C  
ATOM    274  CG1 VAL A  34      18.328  25.359   1.837  1.00 26.94           C  
ATOM    275  CG2 VAL A  34      20.070  27.007   2.469  1.00 26.99           C  
ATOM    276  N   HIS A  35      17.498  23.768   4.585  1.00 25.63           N  
ATOM    277  CA  HIS A  35      16.912  22.450   4.764  1.00 25.99           C  
ATOM    278  C   HIS A  35      16.134  22.064   3.518  1.00 25.89           C  
ATOM    279  O   HIS A  35      15.392  22.883   2.970  1.00 25.29           O  
ATOM    280  CB  HIS A  35      15.947  22.436   5.944  1.00 26.12           C  
ATOM    281  CG  HIS A  35      16.513  22.995   7.211  1.00 26.76           C  
ATOM    282  ND1 HIS A  35      17.212  22.227   8.116  1.00 28.65           N  
ATOM    283  CD2 HIS A  35      16.440  24.234   7.746  1.00 28.91           C  
ATOM    284  CE1 HIS A  35      17.566  22.976   9.143  1.00 28.50           C  
ATOM    285  NE2 HIS A  35      17.107  24.197   8.944  1.00 28.67           N  
ATOM    286  N   TYR A  36      16.288  20.816   3.091  1.00 25.83           N  
ATOM    287  CA  TYR A  36      15.546  20.280   1.962  1.00 26.43           C  
ATOM    288  C   TYR A  36      14.806  19.007   2.353  1.00 26.44           C  
ATOM    289  O   TYR A  36      15.324  18.166   3.097  1.00 26.60           O  
ATOM    290  CB  TYR A  36      16.476  19.950   0.794  1.00 27.33           C  
ATOM    291  CG  TYR A  36      17.486  21.016   0.449  1.00 27.46           C  
ATOM    292  CD1 TYR A  36      18.740  21.019   1.043  1.00 28.84           C  
ATOM    293  CD2 TYR A  36      17.208  21.995  -0.489  1.00 28.87           C  
ATOM    294  CE1 TYR A  36      19.683  21.976   0.730  1.00 28.91           C  
ATOM    295  CE2 TYR A  36      18.150  22.960  -0.811  1.00 28.59           C  
ATOM    296  CZ  TYR A  36      19.392  22.932  -0.201  1.00 28.25           C  
ATOM    297  OH  TYR A  36      20.343  23.882  -0.505  1.00 29.84           O  
ATOM    298  N   SER A  37      13.597  18.863   1.825  1.00 26.36           N  
ATOM    299  CA  SER A  37      12.826  17.642   1.964  1.00 26.82           C  
ATOM    300  C   SER A  37      11.976  17.459   0.708  1.00 26.87           C  
ATOM    301  O   SER A  37      11.304  18.395   0.272  1.00 26.60           O  
ATOM    302  CB  SER A  37      11.948  17.726   3.213  1.00 27.11           C  
ATOM    303  OG  SER A  37      11.244  16.513   3.403  1.00 29.28           O  
ATOM    304  N   GLU A  38      12.035  16.266   0.122  1.00 27.27           N  
ATOM    305  CA  GLU A  38      11.351  15.962  -1.132  1.00 27.88           C  
ATOM    306  C   GLU A  38      11.739  16.948  -2.242  1.00 28.13           C  
ATOM    307  O   GLU A  38      10.907  17.354  -3.053  1.00 28.41           O  
ATOM    308  CB  GLU A  38       9.831  15.906  -0.919  1.00 27.55           C  
ATOM    309  CG  GLU A  38       9.424  14.942   0.191  1.00 27.65           C  
ATOM    310  CD  GLU A  38       7.922  14.743   0.300  1.00 28.82           C  
ATOM    311  OE1 GLU A  38       7.179  15.414  -0.444  1.00 30.18           O  
ATOM    312  OE2 GLU A  38       7.494  13.909   1.125  1.00 28.43           O  
ATOM    313  N   ASP A  39      13.023  17.309  -2.260  1.00 28.73           N  
ATOM    314  CA  ASP A  39      13.620  18.218  -3.254  1.00 29.26           C  
ATOM    315  C   ASP A  39      13.076  19.650  -3.235  1.00 29.52           C  
ATOM    316  O   ASP A  39      13.273  20.394  -4.189  1.00 30.00           O  
ATOM    317  CB  ASP A  39      13.537  17.622  -4.674  1.00 29.44           C  
ATOM    318  CG  ASP A  39      14.252  16.283  -4.789  1.00 30.52           C  
ATOM    319  OD1 ASP A  39      15.154  16.012  -3.966  1.00 31.71           O  
ATOM    320  OD2 ASP A  39      13.907  15.492  -5.692  1.00 30.87           O  
ATOM    321  N   ASN A  40      12.421  20.037  -2.141  1.00 29.84           N  
ATOM    322  CA  ASN A  40      11.961  21.408  -1.933  1.00 29.84           C  
ATOM    323  C   ASN A  40      12.589  21.942  -0.663  1.00 29.66           C  
ATOM    324  O   ASN A  40      12.778  21.184   0.285  1.00 29.07           O  
ATOM    325  CB  ASN A  40      10.446  21.451  -1.748  1.00 30.58           C  
ATOM    326  CG  ASN A  40       9.690  20.938  -2.949  1.00 32.41           C  
ATOM    327  OD1 ASN A  40       9.871  21.422  -4.064  1.00 36.09           O  
ATOM    328  ND2 ASN A  40       8.824  19.955  -2.725  1.00 34.62           N  
ATOM    329  N   GLU A  41      12.883  23.239  -0.625  1.00 29.48           N  
ATOM    330  CA  GLU A  41      13.437  23.855   0.582  0.50 29.49           C  
ATOM    332  C   GLU A  41      12.357  23.978   1.647  1.00 29.59           C  
ATOM    333  O   GLU A  41      11.190  24.248   1.334  1.00 29.29           O  
ATOM    334  CB  GLU A  41      14.036  25.244   0.308  0.50 29.58           C  
ATOM    336  CG  GLU A  41      14.651  25.892   1.564  0.50 29.39           C  
ATOM    338  CD  GLU A  41      15.216  27.288   1.347  0.50 29.49           C  
ATOM    340  OE1 GLU A  41      15.335  27.728   0.184  0.50 30.46           O  
ATOM    342  OE2 GLU A  41      15.548  27.947   2.357  0.50 26.54           O  
ATOM    344  N   VAL A  42      12.760  23.784   2.895  1.00 29.34           N  
ATOM    345  CA  VAL A  42      11.911  23.967   4.058  1.00 29.41           C  
ATOM    346  C   VAL A  42      12.567  25.046   4.916  1.00 29.29           C  
ATOM    347  O   VAL A  42      13.757  24.954   5.238  1.00 29.17           O  
ATOM    348  CB  VAL A  42      11.801  22.655   4.859  1.00 29.44           C  
ATOM    349  CG1 VAL A  42      10.977  22.852   6.130  1.00 29.51           C  
ATOM    350  CG2 VAL A  42      11.195  21.565   3.991  1.00 30.15           C  
ATOM    351  N   SER A  43      11.812  26.072   5.291  1.00 29.15           N  
ATOM    352  CA  SER A  43      12.378  27.153   6.104  1.00 29.01           C  
ATOM    353  C   SER A  43      12.814  26.625   7.471  1.00 28.97           C  
ATOM    354  O   SER A  43      12.241  25.668   7.982  1.00 28.50           O  
ATOM    355  CB  SER A  43      11.369  28.294   6.281  1.00 29.37           C  
ATOM    356  OG  SER A  43      10.324  27.902   7.147  1.00 29.12           O  
ATOM    357  N   SER A  44      13.833  27.245   8.057  1.00 29.09           N  
ATOM    358  CA  SER A  44      14.275  26.871   9.400  1.00 29.44           C  
ATOM    359  C   SER A  44      13.139  27.049  10.407  1.00 29.60           C  
ATOM    360  O   SER A  44      12.984  26.245  11.322  1.00 29.17           O  
ATOM    361  CB  SER A  44      15.489  27.695   9.830  1.00 29.60           C  
ATOM    362  OG  SER A  44      16.665  27.249   9.182  1.00 29.66           O  
ATOM    363  N   ALA A  45      12.343  28.099  10.217  1.00 29.89           N  
ATOM    364  CA  ALA A  45      11.169  28.350  11.057  1.00 30.04           C  
ATOM    365  C   ALA A  45      10.213  27.163  11.027  1.00 30.33           C  
ATOM    366  O   ALA A  45       9.757  26.700  12.072  1.00 30.52           O  
ATOM    367  CB  ALA A  45      10.457  29.611  10.611  1.00 30.39           C  
ATOM    368  N   ASP A  46       9.928  26.657   9.830  1.00 30.06           N  
ATOM    369  CA  ASP A  46       9.025  25.523   9.682  1.00 29.95           C  
ATOM    370  C   ASP A  46       9.663  24.241  10.217  1.00 29.79           C  
ATOM    371  O   ASP A  46       8.985  23.415  10.823  1.00 29.16           O  
ATOM    372  CB  ASP A  46       8.609  25.344   8.218  1.00 29.94           C  
ATOM    373  CG  ASP A  46       7.636  26.428   7.745  1.00 31.05           C  
ATOM    374  OD1 ASP A  46       7.274  27.316   8.543  1.00 33.49           O  
ATOM    375  OD2 ASP A  46       7.235  26.388   6.569  1.00 32.87           O  
ATOM    376  N   MET A  47      10.966  24.087   9.996  1.00 30.02           N  
ATOM    377  CA  MET A  47      11.683  22.914  10.484  1.00 29.97           C  
ATOM    378  C   MET A  47      11.601  22.831  12.008  1.00 29.68           C  
ATOM    379  O   MET A  47      11.259  21.784  12.564  1.00 29.46           O  
ATOM    380  CB  MET A  47      13.142  22.971  10.037  1.00 30.33           C  
ATOM    381  CG  MET A  47      13.947  21.717  10.357  1.00 31.79           C  
ATOM    382  SD  MET A  47      13.278  20.192   9.650  1.00 37.44           S  
ATOM    383  CE  MET A  47      12.919  20.709   7.982  1.00 36.23           C  
ATOM    384  N   VAL A  48      11.898  23.934  12.682  1.00 29.38           N  
ATOM    385  CA  VAL A  48      11.841  23.954  14.143  1.00 29.65           C  
ATOM    386  C   VAL A  48      10.421  23.655  14.640  1.00 29.35           C  
ATOM    387  O   VAL A  48      10.254  22.924  15.604  1.00 29.09           O  
ATOM    388  CB  VAL A  48      12.381  25.282  14.729  1.00 29.85           C  
ATOM    389  CG1 VAL A  48      12.126  25.355  16.236  1.00 30.63           C  
ATOM    390  CG2 VAL A  48      13.876  25.406  14.444  1.00 30.12           C  
ATOM    391  N   LYS A  49       9.407  24.200  13.970  1.00 29.32           N  
ATOM    392  CA  LYS A  49       8.018  23.902  14.325  1.00 29.66           C  
ATOM    393  C   LYS A  49       7.688  22.418  14.213  1.00 29.05           C  
ATOM    394  O   LYS A  49       6.962  21.887  15.052  1.00 28.53           O  
ATOM    395  CB  LYS A  49       7.039  24.711  13.470  1.00 30.21           C  
ATOM    396  CG  LYS A  49       7.040  26.173  13.816  1.00 31.22           C  
ATOM    397  CD  LYS A  49       6.098  26.972  12.932  1.00 31.62           C  
ATOM    398  CE  LYS A  49       6.339  28.460  13.093  1.00 32.56           C  
ATOM    399  NZ  LYS A  49       5.355  29.258  12.312  1.00 33.93           N  
ATOM    400  N   LEU A  50       8.209  21.760  13.179  1.00 28.54           N  
ATOM    401  CA  LEU A  50       7.982  20.327  12.988  1.00 28.78           C  
ATOM    402  C   LEU A  50       8.692  19.538  14.070  1.00 28.34           C  
ATOM    403  O   LEU A  50       8.188  18.519  14.539  1.00 27.91           O  
ATOM    404  CB  LEU A  50       8.492  19.868  11.622  1.00 29.14           C  
ATOM    405  CG  LEU A  50       7.688  20.348  10.414  1.00 31.00           C  
ATOM    406  CD1 LEU A  50       8.470  20.065   9.143  1.00 32.13           C  
ATOM    407  CD2 LEU A  50       6.322  19.674  10.380  1.00 32.82           C  
ATOM    408  N   MET A  51       9.877  20.011  14.451  1.00 27.97           N  
ATOM    409  CA  MET A  51      10.650  19.361  15.504  1.00 28.01           C  
ATOM    410  C   MET A  51       9.912  19.473  16.838  1.00 27.54           C  
ATOM    411  O   MET A  51       9.768  18.481  17.552  1.00 26.96           O  
ATOM    412  CB  MET A  51      12.049  19.980  15.598  1.00 27.63           C  
ATOM    413  CG  MET A  51      12.904  19.701  14.368  1.00 28.12           C  
ATOM    414  SD  MET A  51      14.372  20.747  14.249  1.00 29.03           S  
ATOM    415  CE  MET A  51      15.372  20.068  15.567  1.00 30.92           C  
ATOM    416  N   GLU A  52       9.437  20.677  17.156  1.00 27.99           N  
ATOM    417  CA  GLU A  52       8.679  20.921  18.389  1.00 28.49           C  
ATOM    418  C   GLU A  52       7.390  20.100  18.431  1.00 28.37           C  
ATOM    419  O   GLU A  52       7.060  19.494  19.454  1.00 27.72           O  
ATOM    420  CB  GLU A  52       8.342  22.414  18.534  1.00 28.77           C  
ATOM    421  CG  GLU A  52       9.563  23.290  18.829  1.00 30.25           C  
ATOM    422  CD  GLU A  52       9.254  24.777  18.838  1.00 31.53           C  
ATOM    423  OE1 GLU A  52       8.359  25.226  18.084  1.00 37.23           O  
ATOM    424  OE2 GLU A  52       9.913  25.510  19.610  1.00 36.91           O  
ATOM    425  N   GLY A  53       6.654  20.103  17.323  1.00 28.37           N  
ATOM    426  CA  GLY A  53       5.388  19.370  17.236  1.00 28.41           C  
ATOM    427  C   GLY A  53       5.599  17.871  17.324  1.00 28.37           C  
ATOM    428  O   GLY A  53       4.811  17.159  17.950  1.00 28.24           O  
ATOM    429  N   GLY A  54       6.669  17.393  16.695  1.00 28.30           N  
ATOM    430  CA  GLY A  54       7.024  15.981  16.740  1.00 28.46           C  
ATOM    431  C   GLY A  54       7.363  15.527  18.146  1.00 28.42           C  
ATOM    432  O   GLY A  54       6.907  14.477  18.599  1.00 28.40           O  
ATOM    433  N   LEU A  55       8.149  16.335  18.847  1.00 28.60           N  
ATOM    434  CA  LEU A  55       8.520  16.031  20.224  1.00 28.73           C  
ATOM    435  C   LEU A  55       7.311  16.030  21.160  1.00 28.76           C  
ATOM    436  O   LEU A  55       7.225  15.211  22.074  1.00 29.37           O  
ATOM    437  CB  LEU A  55       9.574  17.031  20.707  1.00 29.15           C  
ATOM    438  CG  LEU A  55      10.429  16.681  21.924  1.00 29.51           C  
ATOM    439  CD1 LEU A  55      10.928  15.253  21.887  1.00 30.12           C  
ATOM    440  CD2 LEU A  55      11.604  17.661  21.996  1.00 29.55           C  
ATOM    441  N   LYS A  56       6.366  16.937  20.934  1.00 28.39           N  
ATOM    442  CA  LYS A  56       5.142  16.969  21.739  1.00 28.22           C  
ATOM    443  C   LYS A  56       4.286  15.709  21.546  1.00 27.66           C  
ATOM    444  O   LYS A  56       3.749  15.159  22.506  1.00 26.69           O  
ATOM    445  CB  LYS A  56       4.311  18.205  21.393  1.00 28.76           C  
ATOM    446  CG  LYS A  56       3.160  18.430  22.337  1.00 29.46           C  
ATOM    447  CD  LYS A  56       2.219  19.540  21.867  1.00 30.36           C  
ATOM    448  CE  LYS A  56       0.863  19.436  22.560  1.00 31.85           C  
ATOM    449  NZ  LYS A  56       0.117  18.177  22.184  1.00 33.20           N  
ATOM    450  N   ALA A  57       4.171  15.259  20.301  1.00 26.83           N  
ATOM    451  CA  ALA A  57       3.351  14.094  19.966  1.00 26.59           C  
ATOM    452  C   ALA A  57       3.999  12.796  20.453  1.00 26.14           C  
ATOM    453  O   ALA A  57       3.298  11.872  20.893  1.00 25.98           O  
ATOM    454  CB  ALA A  57       3.122  14.034  18.473  1.00 26.59           C  
ATOM    455  N   PHE A  58       5.331  12.759  20.375  1.00 25.52           N  
ATOM    456  CA  PHE A  58       6.139  11.581  20.694  1.00 25.17           C  
ATOM    457  C   PHE A  58       7.231  11.926  21.723  1.00 24.72           C  
ATOM    458  O   PHE A  58       8.427  11.883  21.413  1.00 24.38           O  
ATOM    459  CB  PHE A  58       6.743  11.041  19.402  1.00 25.09           C  
ATOM    460  CG  PHE A  58       5.718  10.793  18.333  1.00 25.13           C  
ATOM    461  CD1 PHE A  58       4.808   9.756  18.466  1.00 24.78           C  
ATOM    462  CD2 PHE A  58       5.628  11.624  17.220  1.00 25.74           C  
ATOM    463  CE1 PHE A  58       3.842   9.528  17.501  1.00 24.72           C  
ATOM    464  CE2 PHE A  58       4.661  11.396  16.241  1.00 25.62           C  
ATOM    465  CZ  PHE A  58       3.766  10.351  16.391  1.00 24.69           C  
ATOM    466  N   PRO A  59       6.817  12.246  22.960  1.00 24.75           N  
ATOM    467  CA  PRO A  59       7.720  12.813  23.978  1.00 24.76           C  
ATOM    468  C   PRO A  59       8.839  11.893  24.463  1.00 24.73           C  
ATOM    469  O   PRO A  59       9.793  12.369  25.090  1.00 24.83           O  
ATOM    470  CB  PRO A  59       6.776  13.147  25.131  1.00 24.92           C  
ATOM    471  CG  PRO A  59       5.618  12.257  24.959  1.00 25.20           C  
ATOM    472  CD  PRO A  59       5.442  12.111  23.477  1.00 24.84           C  
ATOM    473  N   ASP A  60       8.713  10.598  24.186  1.00 24.14           N  
ATOM    474  CA  ASP A  60       9.699   9.608  24.602  1.00 24.33           C  
ATOM    475  C   ASP A  60      10.481   9.053  23.418  1.00 23.91           C  
ATOM    476  O   ASP A  60      11.093   7.985  23.510  1.00 23.63           O  
ATOM    477  CB  ASP A  60       9.003   8.470  25.354  1.00 24.49           C  
ATOM    478  CG  ASP A  60       7.956   7.751  24.518  1.00 25.78           C  
ATOM    479  OD1 ASP A  60       7.729   8.102  23.337  1.00 25.53           O  
ATOM    480  OD2 ASP A  60       7.340   6.819  25.061  1.00 29.42           O  
ATOM    481  N   LEU A  61      10.474   9.767  22.299  1.00 23.64           N  
ATOM    482  CA  LEU A  61      11.053   9.214  21.082  1.00 23.76           C  
ATOM    483  C   LEU A  61      12.537   8.908  21.268  1.00 23.71           C  
ATOM    484  O   LEU A  61      13.234   9.568  22.056  1.00 23.41           O  
ATOM    485  CB  LEU A  61      10.821  10.125  19.877  1.00 23.63           C  
ATOM    486  CG  LEU A  61      11.486  11.503  19.885  1.00 24.49           C  
ATOM    487  CD1 LEU A  61      12.935  11.433  19.396  1.00 25.07           C  
ATOM    488  CD2 LEU A  61      10.675  12.475  19.025  1.00 24.14           C  
ATOM    489  N   GLN A  62      13.000   7.883  20.568  1.00 23.60           N  
ATOM    490  CA  GLN A  62      14.408   7.498  20.577  1.00 24.00           C  
ATOM    491  C   GLN A  62      14.865   7.232  19.156  1.00 24.58           C  
ATOM    492  O   GLN A  62      14.142   6.604  18.378  1.00 24.86           O  
ATOM    493  CB  GLN A  62      14.617   6.243  21.440  1.00 24.01           C  
ATOM    494  CG  GLN A  62      14.455   6.487  22.923  1.00 23.99           C  
ATOM    495  CD  GLN A  62      15.615   7.274  23.497  1.00 24.93           C  
ATOM    496  OE1 GLN A  62      16.720   6.744  23.644  1.00 24.12           O  
ATOM    497  NE2 GLN A  62      15.374   8.551  23.813  1.00 22.30           N  
ATOM    498  N   LEU A  63      16.046   7.742  18.825  1.00 24.74           N  
ATOM    499  CA  LEU A  63      16.677   7.522  17.529  1.00 25.36           C  
ATOM    500  C   LEU A  63      17.714   6.434  17.662  1.00 25.89           C  
ATOM    501  O   LEU A  63      18.605   6.532  18.512  1.00 25.37           O  
ATOM    502  CB  LEU A  63      17.385   8.783  17.042  1.00 25.22           C  
ATOM    503  CG  LEU A  63      16.531   9.877  16.412  1.00 25.76           C  
ATOM    504  CD1 LEU A  63      15.460  10.350  17.353  1.00 27.60           C  
ATOM    505  CD2 LEU A  63      17.429  11.023  15.992  1.00 26.66           C  
ATOM    506  N   GLU A  64      17.609   5.411  16.824  1.00 26.29           N  
ATOM    507  CA  GLU A  64      18.648   4.400  16.726  1.00 27.00           C  
ATOM    508  C   GLU A  64      19.381   4.587  15.410  1.00 26.82           C  
ATOM    509  O   GLU A  64      18.769   4.529  14.340  1.00 25.67           O  
ATOM    510  CB  GLU A  64      18.075   2.990  16.781  1.00 27.59           C  
ATOM    511  CG  GLU A  64      19.174   1.933  16.731  1.00 28.14           C  
ATOM    512  CD  GLU A  64      18.665   0.514  16.614  1.00 30.76           C  
ATOM    513  OE1 GLU A  64      17.436   0.306  16.552  1.00 35.88           O  
ATOM    514  OE2 GLU A  64      19.518  -0.406  16.560  1.00 36.64           O  
ATOM    515  N   VAL A  65      20.690   4.819  15.489  1.00 26.53           N  
ATOM    516  CA  VAL A  65      21.500   4.962  14.282  1.00 26.26           C  
ATOM    517  C   VAL A  65      21.839   3.566  13.755  1.00 26.03           C  
ATOM    518  O   VAL A  65      22.586   2.800  14.378  1.00 25.59           O  
ATOM    519  CB  VAL A  65      22.770   5.810  14.537  1.00 26.05           C  
ATOM    520  CG1 VAL A  65      23.619   5.908  13.276  1.00 26.84           C  
ATOM    521  CG2 VAL A  65      22.369   7.194  15.055  1.00 26.89           C  
ATOM    522  N   LYS A  66      21.247   3.220  12.623  1.00 25.97           N  
ATOM    523  CA  LYS A  66      21.490   1.925  11.991  1.00 26.34           C  
ATOM    524  C   LYS A  66      22.774   1.942  11.176  1.00 26.40           C  
ATOM    525  O   LYS A  66      23.470   0.920  11.046  1.00 26.78           O  
ATOM    526  CB  LYS A  66      20.317   1.550  11.087  1.00 26.64           C  
ATOM    527  CG  LYS A  66      18.951   1.513  11.773  1.00 28.37           C  
ATOM    528  CD  LYS A  66      18.884   0.556  12.950  1.00 30.58           C  
ATOM    529  CE  LYS A  66      19.039  -0.883  12.551  1.00 32.66           C  
ATOM    530  NZ  LYS A  66      18.741  -1.818  13.701  1.00 33.69           N  
ATOM    531  N   SER A  67      23.067   3.088  10.577  1.00 26.00           N  
ATOM    532  CA  SER A  67      24.307   3.254   9.834  0.50 25.92           C  
ATOM    534  C   SER A  67      24.686   4.724   9.768  1.00 26.01           C  
ATOM    535  O   SER A  67      23.831   5.600   9.796  1.00 25.45           O  
ATOM    536  CB  SER A  67      24.188   2.676   8.414  0.50 25.80           C  
ATOM    538  OG  SER A  67      23.611   3.613   7.518  0.50 23.73           O  
ATOM    540  N   ILE A  68      25.989   4.970   9.702  1.00 26.30           N  
ATOM    541  CA  ILE A  68      26.524   6.317   9.550  1.00 26.65           C  
ATOM    542  C   ILE A  68      27.654   6.254   8.517  1.00 27.37           C  
ATOM    543  O   ILE A  68      28.407   5.278   8.463  1.00 27.94           O  
ATOM    544  CB  ILE A  68      26.946   6.939  10.915  1.00 26.62           C  
ATOM    545  CG1 ILE A  68      27.418   8.375  10.723  1.00 26.40           C  
ATOM    546  CG2 ILE A  68      28.015   6.100  11.637  1.00 28.04           C  
ATOM    547  CD1 ILE A  68      27.453   9.172  12.018  1.00 27.48           C  
ATOM    548  N   MET A  69      27.713   7.260   7.655  1.00 26.96           N  
ATOM    549  CA  MET A  69      28.674   7.290   6.577  1.00 27.42           C  
ATOM    550  C   MET A  69      29.128   8.720   6.411  1.00 26.36           C  
ATOM    551  O   MET A  69      28.350   9.634   6.639  1.00 25.56           O  
ATOM    552  CB  MET A  69      28.001   6.804   5.297  1.00 27.52           C  
ATOM    553  CG  MET A  69      28.904   6.658   4.114  1.00 29.29           C  
ATOM    554  SD  MET A  69      27.995   6.069   2.664  1.00 33.54           S  
ATOM    555  CE  MET A  69      27.186   4.624   3.359  1.00 32.42           C  
ATOM    556  N   ALA A  70      30.389   8.905   6.031  1.00 25.71           N  
ATOM    557  CA  ALA A  70      30.934  10.235   5.792  1.00 25.69           C  
ATOM    558  C   ALA A  70      31.853  10.229   4.580  1.00 25.62           C  
ATOM    559  O   ALA A  70      32.602   9.269   4.362  1.00 24.96           O  
ATOM    560  CB  ALA A  70      31.678  10.722   7.006  1.00 25.78           C  
ATOM    561  N   GLU A  71      31.776  11.302   3.799  1.00 25.37           N  
ATOM    562  CA  GLU A  71      32.671  11.523   2.669  1.00 25.85           C  
ATOM    563  C   GLU A  71      32.746  13.021   2.432  1.00 25.61           C  
ATOM    564  O   GLU A  71      31.735  13.723   2.539  1.00 24.74           O  
ATOM    565  CB  GLU A  71      32.177  10.808   1.408  1.00 25.92           C  
ATOM    566  CG  GLU A  71      33.236  10.711   0.293  1.00 26.63           C  
ATOM    567  CD  GLU A  71      32.759   9.961  -0.955  1.00 27.97           C  
ATOM    568  OE1 GLU A  71      31.549   9.795  -1.132  1.00 28.16           O  
ATOM    569  OE2 GLU A  71      33.613   9.529  -1.769  1.00 32.87           O  
ATOM    570  N   GLU A  72      33.944  13.499   2.111  1.00 25.95           N  
ATOM    571  CA  GLU A  72      34.151  14.927   1.920  0.50 26.21           C  
ATOM    573  C   GLU A  72      33.613  15.692   3.146  1.00 26.10           C  
ATOM    574  O   GLU A  72      33.949  15.369   4.280  1.00 26.10           O  
ATOM    575  CB  GLU A  72      33.459  15.385   0.628  0.50 26.37           C  
ATOM    577  CG  GLU A  72      33.808  14.575  -0.606  0.50 27.32           C  
ATOM    579  CD  GLU A  72      33.081  15.083  -1.823  0.50 27.78           C  
ATOM    581  OE1 GLU A  72      31.871  14.799  -1.959  0.50 30.80           O  
ATOM    583  OE2 GLU A  72      33.708  15.800  -2.622  0.50 31.28           O  
ATOM    585  N   ASP A  73      32.744  16.680   2.913  1.00 25.49           N  
ATOM    586  CA  ASP A  73      32.183  17.506   3.998  1.00 25.65           C  
ATOM    587  C   ASP A  73      30.781  17.061   4.437  1.00 25.29           C  
ATOM    588  O   ASP A  73      30.095  17.789   5.175  1.00 25.47           O  
ATOM    589  CB  ASP A  73      32.177  18.992   3.592  1.00 25.79           C  
ATOM    590  CG  ASP A  73      31.508  19.252   2.236  1.00 26.54           C  
ATOM    591  OD1 ASP A  73      31.006  18.308   1.583  1.00 25.63           O  
ATOM    592  OD2 ASP A  73      31.509  20.434   1.804  1.00 28.39           O  
ATOM    593  N   ARG A  74      30.375  15.861   4.018  1.00 24.73           N  
ATOM    594  CA  ARG A  74      29.042  15.359   4.288  1.00 24.94           C  
ATOM    595  C   ARG A  74      29.028  14.145   5.218  1.00 24.14           C  
ATOM    596  O   ARG A  74      29.991  13.378   5.285  1.00 23.29           O  
ATOM    597  CB  ARG A  74      28.357  14.996   2.974  1.00 24.93           C  
ATOM    598  CG  ARG A  74      28.026  16.195   2.109  1.00 26.29           C  
ATOM    599  CD  ARG A  74      27.333  15.787   0.817  1.00 28.21           C  
ATOM    600  NE  ARG A  74      28.256  15.127  -0.103  1.00 31.55           N  
ATOM    601  CZ  ARG A  74      28.091  13.921  -0.663  1.00 32.83           C  
ATOM    602  NH1 ARG A  74      27.020  13.177  -0.438  1.00 33.31           N  
ATOM    603  NH2 ARG A  74      29.027  13.460  -1.475  1.00 33.21           N  
ATOM    604  N   VAL A  75      27.904  13.984   5.910  1.00 23.94           N  
ATOM    605  CA  VAL A  75      27.629  12.812   6.732  1.00 23.90           C  
ATOM    606  C   VAL A  75      26.181  12.397   6.462  1.00 24.00           C  
ATOM    607  O   VAL A  75      25.316  13.265   6.300  1.00 23.84           O  
ATOM    608  CB  VAL A  75      27.805  13.111   8.235  1.00 23.98           C  
ATOM    609  CG1 VAL A  75      27.567  11.840   9.071  1.00 24.07           C  
ATOM    610  CG2 VAL A  75      29.187  13.696   8.519  1.00 24.57           C  
ATOM    611  N   ALA A  76      25.929  11.091   6.402  1.00 23.81           N  
ATOM    612  CA  ALA A  76      24.570  10.554   6.259  1.00 23.84           C  
ATOM    613  C   ALA A  76      24.314   9.501   7.338  1.00 23.95           C  
ATOM    614  O   ALA A  76      25.175   8.649   7.606  1.00 24.52           O  
ATOM    615  CB  ALA A  76      24.372   9.945   4.880  1.00 24.16           C  
ATOM    616  N   LEU A  77      23.131   9.563   7.939  1.00 23.83           N  
ATOM    617  CA  LEU A  77      22.743   8.656   9.008  1.00 24.73           C  
ATOM    618  C   LEU A  77      21.437   8.005   8.619  1.00 24.32           C  
ATOM    619  O   LEU A  77      20.482   8.705   8.271  1.00 25.05           O  
ATOM    620  CB  LEU A  77      22.530   9.399  10.321  1.00 24.96           C  
ATOM    621  CG  LEU A  77      23.770  10.122  10.859  1.00 26.58           C  
ATOM    622  CD1 LEU A  77      23.838  11.526  10.292  1.00 28.80           C  
ATOM    623  CD2 LEU A  77      23.726  10.170  12.361  1.00 27.10           C  
ATOM    624  N   ARG A  78      21.400   6.686   8.685  1.00 24.39           N  
ATOM    625  CA  ARG A  78      20.165   5.936   8.529  1.00 24.82           C  
ATOM    626  C   ARG A  78      19.674   5.628   9.942  1.00 24.91           C  
ATOM    627  O   ARG A  78      20.371   4.974  10.728  1.00 24.50           O  
ATOM    628  CB  ARG A  78      20.403   4.652   7.732  1.00 24.74           C  
ATOM    629  CG  ARG A  78      19.130   3.831   7.518  1.00 24.93           C  
ATOM    630  CD  ARG A  78      19.283   2.788   6.420  1.00 25.90           C  
ATOM    631  NE  ARG A  78      20.470   1.953   6.611  1.00 26.34           N  
ATOM    632  CZ  ARG A  78      20.525   0.877   7.388  1.00 26.24           C  
ATOM    633  NH1 ARG A  78      19.474   0.462   8.060  1.00 26.85           N  
ATOM    634  NH2 ARG A  78      21.651   0.201   7.484  1.00 28.60           N  
ATOM    635  N   ILE A  79      18.470   6.100  10.242  1.00 25.15           N  
ATOM    636  CA  ILE A  79      17.952   6.136  11.598  1.00 25.35           C  
ATOM    637  C   ILE A  79      16.566   5.500  11.674  1.00 25.56           C  
ATOM    638  O   ILE A  79      15.729   5.727  10.798  1.00 25.30           O  
ATOM    639  CB  ILE A  79      17.866   7.595  12.087  1.00 25.59           C  
ATOM    640  CG1 ILE A  79      19.276   8.194  12.196  1.00 26.61           C  
ATOM    641  CG2 ILE A  79      17.123   7.689  13.424  1.00 25.71           C  
ATOM    642  CD1 ILE A  79      19.312   9.693  12.272  1.00 26.98           C  
ATOM    643  N   THR A  80      16.339   4.721  12.727  1.00 25.27           N  
ATOM    644  CA  THR A  80      15.016   4.222  13.065  1.00 25.02           C  
ATOM    645  C   THR A  80      14.547   4.941  14.320  1.00 25.07           C  
ATOM    646  O   THR A  80      15.274   5.005  15.317  1.00 25.03           O  
ATOM    647  CB  THR A  80      15.042   2.706  13.294  1.00 25.32           C  
ATOM    648  OG1 THR A  80      15.422   2.060  12.070  1.00 26.84           O  
ATOM    649  CG2 THR A  80      13.663   2.190  13.755  1.00 25.52           C  
ATOM    650  N   VAL A  81      13.348   5.506  14.251  1.00 24.66           N  
ATOM    651  CA  VAL A  81      12.746   6.193  15.388  1.00 24.73           C  
ATOM    652  C   VAL A  81      11.681   5.300  15.999  1.00 24.66           C  
ATOM    653  O   VAL A  81      10.882   4.697  15.274  1.00 23.81           O  
ATOM    654  CB  VAL A  81      12.101   7.531  14.978  1.00 25.15           C  
ATOM    655  CG1 VAL A  81      11.535   8.248  16.208  1.00 25.49           C  
ATOM    656  CG2 VAL A  81      13.116   8.413  14.261  1.00 25.62           C  
ATOM    657  N   THR A  82      11.682   5.206  17.326  1.00 24.11           N  
ATOM    658  CA  THR A  82      10.620   4.519  18.060  1.00 24.37           C  
ATOM    659  C   THR A  82      10.101   5.427  19.159  1.00 24.17           C  
ATOM    660  O   THR A  82      10.856   6.201  19.737  1.00 23.24           O  
ATOM    661  CB  THR A  82      11.089   3.184  18.657  1.00 24.67           C  
ATOM    662  OG1 THR A  82      12.215   3.391  19.513  1.00 26.06           O  
ATOM    663  CG2 THR A  82      11.478   2.216  17.549  1.00 25.27           C  
ATOM    664  N   ALA A  83       8.806   5.337  19.435  1.00 24.49           N  
ATOM    665  CA  ALA A  83       8.183   6.204  20.417  1.00 25.14           C  
ATOM    666  C   ALA A  83       6.814   5.680  20.808  1.00 25.51           C  
ATOM    667  O   ALA A  83       6.332   4.693  20.250  1.00 25.04           O  
ATOM    668  CB  ALA A  83       8.042   7.605  19.848  1.00 25.05           C  
ATOM    669  N   THR A  84       6.197   6.371  21.760  1.00 26.25           N  
ATOM    670  CA  THR A  84       4.795   6.152  22.097  1.00 26.84           C  
ATOM    671  C   THR A  84       4.006   7.371  21.625  1.00 26.93           C  
ATOM    672  O   THR A  84       4.471   8.507  21.750  1.00 26.21           O  
ATOM    673  CB  THR A  84       4.608   5.978  23.615  1.00 27.09           C  
ATOM    674  OG1 THR A  84       5.619   5.102  24.118  1.00 30.61           O  
ATOM    675  CG2 THR A  84       3.268   5.379  23.911  1.00 27.80           C  
ATOM    676  N   HIS A  85       2.809   7.134  21.095  1.00 27.07           N  
ATOM    677  CA  HIS A  85       1.956   8.213  20.612  1.00 27.52           C  
ATOM    678  C   HIS A  85       1.166   8.792  21.787  1.00 27.79           C  
ATOM    679  O   HIS A  85       0.126   8.250  22.178  1.00 27.44           O  
ATOM    680  CB  HIS A  85       1.021   7.715  19.496  1.00 27.48           C  
ATOM    681  CG  HIS A  85       0.188   8.797  18.878  1.00 27.55           C  
ATOM    682  ND1 HIS A  85      -1.019   8.549  18.260  1.00 27.53           N  
ATOM    683  CD2 HIS A  85       0.384  10.134  18.799  1.00 28.03           C  
ATOM    684  CE1 HIS A  85      -1.525   9.688  17.818  1.00 27.99           C  
ATOM    685  NE2 HIS A  85      -0.698  10.665  18.140  1.00 27.87           N  
ATOM    686  N   GLN A  86       1.684   9.888  22.344  1.00 28.29           N  
ATOM    687  CA  GLN A  86       1.137  10.503  23.556  1.00 28.93           C  
ATOM    688  C   GLN A  86       0.453  11.847  23.309  1.00 29.21           C  
ATOM    689  O   GLN A  86      -0.328  12.297  24.151  1.00 28.86           O  
ATOM    690  CB  GLN A  86       2.246  10.716  24.597  1.00 29.35           C  
ATOM    691  CG  GLN A  86       3.008   9.464  25.018  1.00 31.09           C  
ATOM    692  CD  GLN A  86       2.203   8.499  25.881  1.00 35.56           C  
ATOM    693  OE1 GLN A  86       2.707   7.444  26.271  1.00 39.41           O  
ATOM    694  NE2 GLN A  86       0.960   8.850  26.187  1.00 37.07           N  
ATOM    695  N   GLY A  87       0.743  12.493  22.183  1.00 29.34           N  
ATOM    696  CA  GLY A  87       0.105  13.768  21.833  1.00 30.16           C  
ATOM    697  C   GLY A  87      -0.517  13.724  20.451  1.00 30.48           C  
ATOM    698  O   GLY A  87      -0.127  12.905  19.623  1.00 30.09           O  
ATOM    699  N   GLU A  88      -1.494  14.596  20.200  1.00 31.17           N  
ATOM    700  CA  GLU A  88      -2.158  14.623  18.900  0.50 31.28           C  
ATOM    702  C   GLU A  88      -1.129  14.817  17.784  1.00 31.42           C  
ATOM    703  O   GLU A  88      -0.200  15.616  17.902  1.00 31.25           O  
ATOM    704  CB  GLU A  88      -3.240  15.710  18.835  0.50 31.49           C  
ATOM    706  CG  GLU A  88      -4.188  15.564  17.636  0.50 31.53           C  
ATOM    708  CD  GLU A  88      -5.251  16.652  17.566  0.50 31.97           C  
ATOM    710  OE1 GLU A  88      -5.514  17.157  16.453  0.50 33.46           O  
ATOM    712  OE2 GLU A  88      -5.847  16.985  18.612  0.50 32.85           O  
ATOM    714  N   PHE A  89      -1.299  14.055  16.706  1.00 31.42           N  
ATOM    715  CA  PHE A  89      -0.404  14.124  15.563  1.00 31.96           C  
ATOM    716  C   PHE A  89      -1.175  13.865  14.274  1.00 32.54           C  
ATOM    717  O   PHE A  89      -1.929  12.897  14.184  1.00 32.30           O  
ATOM    718  CB  PHE A  89       0.728  13.107  15.712  1.00 31.36           C  
ATOM    719  CG  PHE A  89       1.854  13.319  14.747  1.00 30.93           C  
ATOM    720  CD1 PHE A  89       2.663  14.441  14.848  1.00 31.19           C  
ATOM    721  CD2 PHE A  89       2.102  12.412  13.734  1.00 30.32           C  
ATOM    722  CE1 PHE A  89       3.702  14.650  13.958  1.00 31.08           C  
ATOM    723  CE2 PHE A  89       3.140  12.612  12.835  1.00 31.20           C  
ATOM    724  CZ  PHE A  89       3.944  13.731  12.949  1.00 31.00           C  
ATOM    725  N   MET A  90      -0.977  14.741  13.288  1.00 33.63           N  
ATOM    726  CA  MET A  90      -1.689  14.689  12.006  1.00 34.61           C  
ATOM    727  C   MET A  90      -3.200  14.549  12.178  1.00 34.44           C  
ATOM    728  O   MET A  90      -3.855  13.826  11.429  1.00 34.77           O  
ATOM    729  CB  MET A  90      -1.165  13.540  11.147  1.00 34.87           C  
ATOM    730  CG  MET A  90       0.319  13.586  10.884  1.00 36.05           C  
ATOM    731  SD  MET A  90       0.872  12.347   9.700  1.00 38.85           S  
ATOM    732  CE  MET A  90       0.040  10.881  10.270  1.00 38.66           C  
ATOM    733  N   GLY A  91      -3.743  15.241  13.178  1.00 34.49           N  
ATOM    734  CA  GLY A  91      -5.170  15.214  13.456  1.00 34.30           C  
ATOM    735  C   GLY A  91      -5.672  13.964  14.158  1.00 34.20           C  
ATOM    736  O   GLY A  91      -6.873  13.819  14.366  1.00 34.29           O  
ATOM    737  N   VAL A  92      -4.767  13.065  14.537  1.00 33.84           N  
ATOM    738  CA  VAL A  92      -5.147  11.817  15.198  1.00 33.71           C  
ATOM    739  C   VAL A  92      -4.879  11.910  16.696  1.00 33.64           C  
ATOM    740  O   VAL A  92      -3.761  12.209  17.111  1.00 33.44           O  
ATOM    741  CB  VAL A  92      -4.366  10.624  14.615  1.00 33.46           C  
ATOM    742  CG1 VAL A  92      -4.751   9.325  15.322  1.00 33.55           C  
ATOM    743  CG2 VAL A  92      -4.615  10.523  13.126  1.00 33.27           C  
ATOM    744  N   GLN A  93      -5.903  11.647  17.505  1.00 33.67           N  
ATOM    745  CA  GLN A  93      -5.755  11.704  18.957  1.00 33.92           C  
ATOM    746  C   GLN A  93      -4.822  10.596  19.446  1.00 33.73           C  
ATOM    747  O   GLN A  93      -4.802   9.504  18.875  1.00 33.58           O  
ATOM    748  CB  GLN A  93      -7.112  11.589  19.651  1.00 34.01           C  
ATOM    749  CG  GLN A  93      -8.079  12.726  19.325  1.00 35.00           C  
ATOM    750  CD  GLN A  93      -7.480  14.101  19.573  1.00 36.03           C  
ATOM    751  OE1 GLN A  93      -6.933  14.372  20.641  1.00 36.81           O  
ATOM    752  NE2 GLN A  93      -7.576  14.972  18.577  1.00 37.53           N  
ATOM    753  N   PRO A  94      -4.050  10.872  20.510  1.00 33.82           N  
ATOM    754  CA  PRO A  94      -3.065   9.910  20.993  1.00 33.99           C  
ATOM    755  C   PRO A  94      -3.677   8.605  21.494  1.00 34.12           C  
ATOM    756  O   PRO A  94      -4.684   8.620  22.205  1.00 33.90           O  
ATOM    757  CB  PRO A  94      -2.373  10.656  22.137  1.00 34.01           C  
ATOM    758  CG  PRO A  94      -3.326  11.697  22.557  1.00 33.68           C  
ATOM    759  CD  PRO A  94      -4.046  12.104  21.318  1.00 33.73           C  
ATOM    760  N   THR A  95      -3.054   7.494  21.104  1.00 34.36           N  
ATOM    761  CA  THR A  95      -3.495   6.154  21.482  1.00 34.36           C  
ATOM    762  C   THR A  95      -2.696   5.612  22.673  1.00 34.19           C  
ATOM    763  O   THR A  95      -3.201   4.818  23.461  1.00 34.50           O  
ATOM    764  CB  THR A  95      -3.334   5.184  20.293  1.00 34.82           C  
ATOM    765  OG1 THR A  95      -2.039   5.350  19.701  1.00 35.80           O  
ATOM    766  CG2 THR A  95      -4.381   5.461  19.227  1.00 35.78           C  
ATOM    767  N   GLY A  96      -1.449   6.050  22.805  1.00 33.38           N  
ATOM    768  CA  GLY A  96      -0.507   5.410  23.715  1.00 33.00           C  
ATOM    769  C   GLY A  96       0.168   4.215  23.057  1.00 32.53           C  
ATOM    770  O   GLY A  96       0.906   3.481  23.715  1.00 32.77           O  
ATOM    771  N   GLN A  97      -0.083   4.026  21.761  1.00 31.91           N  
ATOM    772  CA  GLN A  97       0.512   2.939  20.985  1.00 31.76           C  
ATOM    773  C   GLN A  97       1.987   3.197  20.763  1.00 30.14           C  
ATOM    774  O   GLN A  97       2.386   4.343  20.557  1.00 29.66           O  
ATOM    775  CB  GLN A  97      -0.086   2.862  19.576  1.00 31.91           C  
ATOM    776  CG  GLN A  97      -1.288   1.987  19.376  1.00 34.54           C  
ATOM    777  CD  GLN A  97      -1.406   1.556  17.915  1.00 35.03           C  
ATOM    778  OE1 GLN A  97      -1.406   0.362  17.607  1.00 40.05           O  
ATOM    779  NE2 GLN A  97      -1.461   2.533  17.005  1.00 38.84           N  
ATOM    780  N   ARG A  98       2.778   2.130  20.738  1.00 29.13           N  
ATOM    781  CA  ARG A  98       4.146   2.230  20.246  1.00 28.39           C  
ATOM    782  C   ARG A  98       4.137   2.397  18.731  1.00 27.80           C  
ATOM    783  O   ARG A  98       3.375   1.731  18.023  1.00 26.73           O  
ATOM    784  CB  ARG A  98       4.962   0.996  20.622  1.00 28.75           C  
ATOM    785  CG  ARG A  98       5.170   0.817  22.115  1.00 29.28           C  
ATOM    786  CD  ARG A  98       6.106   1.882  22.686  1.00 31.29           C  
ATOM    787  NE  ARG A  98       7.482   1.650  22.263  1.00 31.92           N  
ATOM    788  CZ  ARG A  98       8.491   2.507  22.421  1.00 31.66           C  
ATOM    789  NH1 ARG A  98       8.306   3.699  22.989  1.00 29.71           N  
ATOM    790  NH2 ARG A  98       9.697   2.157  22.001  1.00 31.52           N  
ATOM    791  N   VAL A  99       5.006   3.273  18.239  1.00 26.57           N  
ATOM    792  CA  VAL A  99       5.102   3.564  16.823  1.00 26.38           C  
ATOM    793  C   VAL A  99       6.565   3.576  16.418  1.00 26.06           C  
ATOM    794  O   VAL A  99       7.452   3.636  17.276  1.00 25.23           O  
ATOM    795  CB  VAL A  99       4.452   4.921  16.460  1.00 26.29           C  
ATOM    796  CG1 VAL A  99       2.969   4.937  16.858  1.00 26.65           C  
ATOM    797  CG2 VAL A  99       5.202   6.097  17.105  1.00 26.29           C  
ATOM    798  N   SER A 100       6.793   3.521  15.111  1.00 25.60           N  
ATOM    799  CA  SER A 100       8.130   3.596  14.539  1.00 25.94           C  
ATOM    800  C   SER A 100       8.104   4.237  13.155  1.00 25.94           C  
ATOM    801  O   SER A 100       7.078   4.227  12.451  1.00 25.68           O  
ATOM    802  CB  SER A 100       8.762   2.201  14.455  1.00 26.34           C  
ATOM    803  OG  SER A 100       8.050   1.382  13.533  1.00 27.87           O  
ATOM    804  N   TRP A 101       9.241   4.799  12.768  1.00 25.14           N  
ATOM    805  CA  TRP A 101       9.456   5.198  11.396  1.00 25.23           C  
ATOM    806  C   TRP A 101      10.951   5.210  11.096  1.00 24.65           C  
ATOM    807  O   TRP A 101      11.768   4.905  11.969  1.00 24.14           O  
ATOM    808  CB  TRP A 101       8.754   6.531  11.066  1.00 25.53           C  
ATOM    809  CG  TRP A 101       9.243   7.745  11.767  1.00 26.01           C  
ATOM    810  CD1 TRP A 101      10.157   8.640  11.307  1.00 26.66           C  
ATOM    811  CD2 TRP A 101       8.801   8.239  13.036  1.00 26.85           C  
ATOM    812  NE1 TRP A 101      10.332   9.651  12.213  1.00 27.43           N  
ATOM    813  CE2 TRP A 101       9.505   9.434  13.284  1.00 27.25           C  
ATOM    814  CE3 TRP A 101       7.875   7.788  13.984  1.00 26.71           C  
ATOM    815  CZ2 TRP A 101       9.316  10.186  14.445  1.00 27.11           C  
ATOM    816  CZ3 TRP A 101       7.694   8.524  15.135  1.00 26.98           C  
ATOM    817  CH2 TRP A 101       8.414   9.714  15.357  1.00 26.85           C  
ATOM    818  N   HIS A 102      11.291   5.497   9.851  1.00 24.53           N  
ATOM    819  CA  HIS A 102      12.659   5.338   9.373  1.00 24.51           C  
ATOM    820  C   HIS A 102      13.009   6.537   8.542  1.00 24.64           C  
ATOM    821  O   HIS A 102      12.159   7.083   7.840  1.00 24.35           O  
ATOM    822  CB  HIS A 102      12.780   4.060   8.542  1.00 24.44           C  
ATOM    823  CG  HIS A 102      12.230   2.853   9.233  1.00 24.55           C  
ATOM    824  ND1 HIS A 102      12.976   2.088  10.102  1.00 23.57           N  
ATOM    825  CD2 HIS A 102      10.987   2.313   9.226  1.00 24.28           C  
ATOM    826  CE1 HIS A 102      12.222   1.118  10.586  1.00 25.48           C  
ATOM    827  NE2 HIS A 102      11.013   1.227  10.065  1.00 24.91           N  
ATOM    828  N   LEU A 103      14.256   6.973   8.621  1.00 24.20           N  
ATOM    829  CA  LEU A 103      14.688   8.115   7.833  0.50 24.34           C  
ATOM    831  C   LEU A 103      16.177   8.060   7.553  1.00 24.13           C  
ATOM    832  O   LEU A 103      16.910   7.348   8.230  1.00 23.68           O  
ATOM    833  CB  LEU A 103      14.333   9.410   8.564  0.50 24.42           C  
ATOM    835  CG  LEU A 103      14.888   9.534   9.990  0.50 24.56           C  
ATOM    837  CD1 LEU A 103      16.164  10.333  10.000  0.50 24.51           C  
ATOM    839  CD2 LEU A 103      13.870  10.157  10.926  0.50 25.47           C  
ATOM    841  N   VAL A 104      16.595   8.819   6.551  1.00 24.38           N  
ATOM    842  CA  VAL A 104      17.996   9.089   6.316  1.00 24.96           C  
ATOM    843  C   VAL A 104      18.151  10.601   6.378  1.00 25.24           C  
ATOM    844  O   VAL A 104      17.398  11.346   5.741  1.00 25.10           O  
ATOM    845  CB  VAL A 104      18.505   8.536   4.965  1.00 24.77           C  
ATOM    846  CG1 VAL A 104      19.948   9.006   4.701  1.00 25.63           C  
ATOM    847  CG2 VAL A 104      18.427   7.024   4.956  1.00 25.49           C  
ATOM    848  N   GLU A 105      19.114  11.057   7.174  1.00 25.85           N  
ATOM    849  CA  GLU A 105      19.466  12.466   7.227  1.00 26.68           C  
ATOM    850  C   GLU A 105      20.841  12.633   6.620  1.00 26.11           C  
ATOM    851  O   GLU A 105      21.745  11.869   6.936  1.00 25.89           O  
ATOM    852  CB  GLU A 105      19.493  12.961   8.670  1.00 27.08           C  
ATOM    853  CG  GLU A 105      18.111  12.983   9.297  1.00 30.60           C  
ATOM    854  CD  GLU A 105      18.068  13.657  10.639  1.00 32.16           C  
ATOM    855  OE1 GLU A 105      18.217  12.936  11.658  1.00 39.92           O  
ATOM    856  OE2 GLU A 105      17.862  14.898  10.686  1.00 39.27           O  
ATOM    857  N   GLU A 106      20.994  13.639   5.767  1.00 25.51           N  
ATOM    858  CA  GLU A 106      22.277  13.954   5.171  1.00 25.55           C  
ATOM    859  C   GLU A 106      22.603  15.388   5.542  1.00 25.08           C  
ATOM    860  O   GLU A 106      21.752  16.269   5.420  1.00 24.33           O  
ATOM    861  CB  GLU A 106      22.237  13.748   3.655  1.00 25.68           C  
ATOM    862  CG  GLU A 106      23.570  13.949   2.952  1.00 25.69           C  
ATOM    863  CD  GLU A 106      23.493  13.753   1.450  1.00 27.23           C  
ATOM    864  OE1 GLU A 106      22.463  13.243   0.939  1.00 29.12           O  
ATOM    865  OE2 GLU A 106      24.484  14.098   0.770  1.00 30.40           O  
ATOM    866  N   LEU A 107      23.840  15.613   5.979  1.00 24.81           N  
ATOM    867  CA  LEU A 107      24.280  16.918   6.462  0.50 24.99           C  
ATOM    869  C   LEU A 107      25.589  17.313   5.796  1.00 24.95           C  
ATOM    870  O   LEU A 107      26.471  16.475   5.624  1.00 24.66           O  
ATOM    871  CB  LEU A 107      24.488  16.885   7.979  0.50 25.07           C  
ATOM    873  CG  LEU A 107      23.293  16.567   8.883  0.50 25.21           C  
ATOM    875  CD1 LEU A 107      23.731  16.641  10.331  0.50 26.55           C  
ATOM    877  CD2 LEU A 107      22.122  17.502   8.634  0.50 26.71           C  
ATOM    879  N   ARG A 108      25.706  18.583   5.419  1.00 24.91           N  
ATOM    880  CA  ARG A 108      26.958  19.126   4.898  1.00 25.18           C  
ATOM    881  C   ARG A 108      27.452  20.196   5.868  1.00 25.08           C  
ATOM    882  O   ARG A 108      26.673  21.055   6.303  1.00 24.40           O  
ATOM    883  CB  ARG A 108      26.785  19.716   3.490  1.00 25.10           C  
ATOM    884  CG  ARG A 108      28.119  20.125   2.862  1.00 25.83           C  
ATOM    885  CD  ARG A 108      27.981  20.509   1.417  1.00 27.26           C  
ATOM    886  NE  ARG A 108      27.412  21.838   1.261  1.00 29.09           N  
ATOM    887  CZ  ARG A 108      28.100  22.978   1.333  1.00 30.55           C  
ATOM    888  NH1 ARG A 108      29.402  22.994   1.610  1.00 31.42           N  
ATOM    889  NH2 ARG A 108      27.468  24.126   1.145  1.00 30.98           N  
ATOM    890  N   PHE A 109      28.748  20.143   6.183  1.00 25.14           N  
ATOM    891  CA  PHE A 109      29.369  21.021   7.176  1.00 25.60           C  
ATOM    892  C   PHE A 109      30.284  22.050   6.544  1.00 25.87           C  
ATOM    893  O   PHE A 109      30.974  21.757   5.571  1.00 25.27           O  
ATOM    894  CB  PHE A 109      30.223  20.203   8.151  1.00 25.51           C  
ATOM    895  CG  PHE A 109      29.421  19.405   9.138  1.00 25.11           C  
ATOM    896  CD1 PHE A 109      28.829  18.207   8.757  1.00 25.31           C  
ATOM    897  CD2 PHE A 109      29.257  19.856  10.447  1.00 25.35           C  
ATOM    898  CE1 PHE A 109      28.074  17.472   9.660  1.00 26.52           C  
ATOM    899  CE2 PHE A 109      28.516  19.120  11.359  1.00 25.60           C  
ATOM    900  CZ  PHE A 109      27.919  17.929  10.957  1.00 25.96           C  
ATOM    901  N   VAL A 110      30.296  23.247   7.129  1.00 26.15           N  
ATOM    902  CA  VAL A 110      31.330  24.250   6.877  1.00 27.17           C  
ATOM    903  C   VAL A 110      31.735  24.827   8.230  1.00 27.61           C  
ATOM    904  O   VAL A 110      30.877  25.249   9.007  1.00 27.26           O  
ATOM    905  CB  VAL A 110      30.846  25.409   5.965  1.00 27.12           C  
ATOM    906  CG1 VAL A 110      31.956  26.443   5.810  1.00 28.24           C  
ATOM    907  CG2 VAL A 110      30.408  24.890   4.605  1.00 27.60           C  
ATOM    908  N   ASP A 111      33.036  24.821   8.513  1.00 28.60           N  
ATOM    909  CA  ASP A 111      33.576  25.330   9.774  1.00 29.23           C  
ATOM    910  C   ASP A 111      32.885  24.749  11.007  1.00 29.27           C  
ATOM    911  O   ASP A 111      32.629  25.466  11.975  1.00 29.54           O  
ATOM    912  CB  ASP A 111      33.506  26.858   9.807  1.00 30.58           C  
ATOM    913  CG  ASP A 111      34.364  27.500   8.744  1.00 34.41           C  
ATOM    914  OD1 ASP A 111      35.396  26.897   8.368  1.00 39.72           O  
ATOM    915  OD2 ASP A 111      34.005  28.604   8.274  1.00 38.85           O  
ATOM    916  N   GLY A 112      32.576  23.457  10.958  1.00 28.26           N  
ATOM    917  CA  GLY A 112      31.965  22.759  12.083  1.00 28.46           C  
ATOM    918  C   GLY A 112      30.466  22.958  12.256  1.00 28.37           C  
ATOM    919  O   GLY A 112      29.879  22.411  13.191  1.00 29.41           O  
ATOM    920  N   LYS A 113      29.835  23.711  11.360  1.00 27.67           N  
ATOM    921  CA  LYS A 113      28.405  23.964  11.452  1.00 27.34           C  
ATOM    922  C   LYS A 113      27.704  23.370  10.231  1.00 26.48           C  
ATOM    923  O   LYS A 113      28.290  23.272   9.150  1.00 25.92           O  
ATOM    924  CB  LYS A 113      28.135  25.463  11.565  1.00 28.36           C  
ATOM    925  CG  LYS A 113      28.680  26.104  12.853  1.00 30.49           C  
ATOM    926  CD  LYS A 113      27.754  25.895  14.056  1.00 33.71           C  
ATOM    927  CE  LYS A 113      28.397  26.327  15.394  1.00 35.18           C  
ATOM    928  NZ  LYS A 113      29.295  25.236  15.988  1.00 38.40           N  
ATOM    929  N   VAL A 114      26.453  22.967  10.414  1.00 25.02           N  
ATOM    930  CA  VAL A 114      25.663  22.387   9.331  1.00 24.84           C  
ATOM    931  C   VAL A 114      25.128  23.518   8.440  1.00 24.43           C  
ATOM    932  O   VAL A 114      24.412  24.399   8.922  1.00 24.27           O  
ATOM    933  CB  VAL A 114      24.487  21.557   9.881  1.00 24.66           C  
ATOM    934  CG1 VAL A 114      23.654  20.971   8.751  1.00 24.32           C  
ATOM    935  CG2 VAL A 114      25.009  20.456  10.803  1.00 25.64           C  
ATOM    936  N   VAL A 115      25.471  23.486   7.152  1.00 23.87           N  
ATOM    937  CA  VAL A 115      24.997  24.484   6.184  1.00 24.26           C  
ATOM    938  C   VAL A 115      23.901  23.971   5.235  1.00 24.32           C  
ATOM    939  O   VAL A 115      23.162  24.769   4.615  1.00 23.95           O  
ATOM    940  CB  VAL A 115      26.163  25.073   5.356  1.00 24.02           C  
ATOM    941  CG1 VAL A 115      27.114  25.839   6.256  1.00 25.13           C  
ATOM    942  CG2 VAL A 115      26.890  23.989   4.575  1.00 24.15           C  
ATOM    943  N   GLU A 116      23.812  22.650   5.100  1.00 24.09           N  
ATOM    944  CA  GLU A 116      22.758  22.019   4.316  1.00 24.67           C  
ATOM    945  C   GLU A 116      22.317  20.745   5.000  1.00 24.40           C  
ATOM    946  O   GLU A 116      23.148  19.994   5.534  1.00 23.74           O  
ATOM    947  CB  GLU A 116      23.225  21.699   2.889  1.00 24.63           C  
ATOM    948  CG  GLU A 116      23.411  22.923   2.007  1.00 25.58           C  
ATOM    949  CD  GLU A 116      23.715  22.566   0.564  1.00 26.81           C  
ATOM    950  OE1 GLU A 116      24.843  22.106   0.294  1.00 28.57           O  
ATOM    951  OE2 GLU A 116      22.838  22.771  -0.309  1.00 28.38           O  
ATOM    952  N   HIS A 117      21.010  20.502   4.939  1.00 24.73           N  
ATOM    953  CA  HIS A 117      20.388  19.358   5.574  0.50 25.03           C  
ATOM    955  C   HIS A 117      19.329  18.786   4.627  1.00 24.94           C  
ATOM    956  O   HIS A 117      18.412  19.501   4.230  1.00 24.80           O  
ATOM    957  CB  HIS A 117      19.789  19.820   6.911  0.50 25.35           C  
ATOM    959  CG  HIS A 117      18.809  18.867   7.512  0.50 25.92           C  
ATOM    961  ND1 HIS A 117      17.596  19.278   8.021  0.50 27.52           N  
ATOM    963  CD2 HIS A 117      18.853  17.523   7.682  0.50 27.43           C  
ATOM    965  CE1 HIS A 117      16.938  18.230   8.484  0.50 28.25           C  
ATOM    967  NE2 HIS A 117      17.678  17.154   8.292  0.50 28.32           N  
ATOM    969  N   TRP A 118      19.475  17.516   4.256  1.00 24.94           N  
ATOM    970  CA  TRP A 118      18.501  16.818   3.420  1.00 25.16           C  
ATOM    971  C   TRP A 118      17.935  15.635   4.197  1.00 25.74           C  
ATOM    972  O   TRP A 118      18.686  14.923   4.877  1.00 26.55           O  
ATOM    973  CB  TRP A 118      19.150  16.267   2.148  1.00 24.83           C  
ATOM    974  CG  TRP A 118      19.840  17.244   1.266  1.00 24.16           C  
ATOM    975  CD1 TRP A 118      19.322  17.857   0.168  1.00 24.80           C  
ATOM    976  CD2 TRP A 118      21.202  17.677   1.363  1.00 24.07           C  
ATOM    977  NE1 TRP A 118      20.268  18.656  -0.421  1.00 24.69           N  
ATOM    978  CE2 TRP A 118      21.432  18.569   0.291  1.00 23.88           C  
ATOM    979  CE3 TRP A 118      22.253  17.391   2.243  1.00 24.50           C  
ATOM    980  CZ2 TRP A 118      22.669  19.193   0.083  1.00 24.41           C  
ATOM    981  CZ3 TRP A 118      23.481  18.016   2.042  1.00 24.16           C  
ATOM    982  CH2 TRP A 118      23.679  18.903   0.970  1.00 24.73           C  
ATOM    983  N   ASP A 119      16.628  15.406   4.102  1.00 25.98           N  
ATOM    984  CA  ASP A 119      16.032  14.213   4.718  1.00 26.33           C  
ATOM    985  C   ASP A 119      15.220  13.410   3.716  1.00 26.01           C  
ATOM    986  O   ASP A 119      14.666  13.963   2.766  1.00 26.30           O  
ATOM    987  CB  ASP A 119      15.177  14.570   5.948  1.00 27.41           C  
ATOM    988  CG  ASP A 119      13.954  15.415   5.609  1.00 29.62           C  
ATOM    989  OD1 ASP A 119      13.155  15.029   4.723  1.00 33.43           O  
ATOM    990  OD2 ASP A 119      13.761  16.473   6.259  1.00 34.60           O  
ATOM    991  N   VAL A 120      15.188  12.104   3.931  1.00 25.27           N  
ATOM    992  CA  VAL A 120      14.256  11.218   3.255  1.00 25.25           C  
ATOM    993  C   VAL A 120      13.592  10.435   4.369  1.00 24.95           C  
ATOM    994  O   VAL A 120      14.245   9.639   5.059  1.00 24.49           O  
ATOM    995  CB  VAL A 120      14.963  10.276   2.260  1.00 24.93           C  
ATOM    996  CG1 VAL A 120      13.981   9.270   1.687  1.00 25.25           C  
ATOM    997  CG2 VAL A 120      15.639  11.072   1.152  1.00 25.37           C  
ATOM    998  N   ILE A 121      12.299  10.676   4.565  1.00 25.34           N  
ATOM    999  CA  ILE A 121      11.588  10.119   5.691  1.00 25.94           C  
ATOM   1000  C   ILE A 121      10.498   9.165   5.222  1.00 25.88           C  
ATOM   1001  O   ILE A 121       9.622   9.547   4.443  1.00 26.14           O  
ATOM   1002  CB  ILE A 121      10.963  11.219   6.564  1.00 25.83           C  
ATOM   1003  CG1 ILE A 121      12.031  12.232   6.992  1.00 26.61           C  
ATOM   1004  CG2 ILE A 121      10.273  10.592   7.786  1.00 25.99           C  
ATOM   1005  CD1 ILE A 121      11.486  13.446   7.662  1.00 27.69           C  
ATOM   1006  N   ASN A 122      10.588   7.923   5.691  1.00 26.31           N  
ATOM   1007  CA  ASN A 122       9.570   6.916   5.473  1.00 26.54           C  
ATOM   1008  C   ASN A 122       8.672   6.820   6.693  1.00 26.46           C  
ATOM   1009  O   ASN A 122       9.023   6.149   7.674  1.00 26.00           O  
ATOM   1010  CB  ASN A 122      10.195   5.545   5.204  1.00 26.49           C  
ATOM   1011  CG  ASN A 122       9.157   4.446   5.133  1.00 26.47           C  
ATOM   1012  OD1 ASN A 122       8.002   4.712   4.825  1.00 26.63           O  
ATOM   1013  ND2 ASN A 122       9.554   3.213   5.436  1.00 26.96           N  
ATOM   1014  N   MET A 123       7.510   7.465   6.597  1.00 26.89           N  
ATOM   1015  CA  MET A 123       6.522   7.446   7.673  0.70 27.92           C  
ATOM   1017  C   MET A 123       5.477   6.345   7.480  1.00 27.39           C  
ATOM   1018  O   MET A 123       4.525   6.234   8.252  1.00 26.58           O  
ATOM   1019  CB  MET A 123       5.818   8.794   7.765  0.70 28.19           C  
ATOM   1021  CG  MET A 123       6.740   9.963   8.061  0.70 30.19           C  
ATOM   1023  SD  MET A 123       6.124  10.960   9.414  0.70 33.17           S  
ATOM   1025  CE  MET A 123       6.926  10.092  10.750  0.70 35.02           C  
ATOM   1027  N   ARG A 124       5.655   5.503   6.466  1.00 27.18           N  
ATOM   1028  CA  ARG A 124       4.657   4.464   6.195  1.00 27.15           C  
ATOM   1029  C   ARG A 124       4.177   3.708   7.456  1.00 26.66           C  
ATOM   1030  O   ARG A 124       2.972   3.640   7.696  1.00 26.50           O  
ATOM   1031  CB  ARG A 124       5.160   3.494   5.116  1.00 27.00           C  
ATOM   1032  CG  ARG A 124       4.079   2.573   4.552  1.00 27.86           C  
ATOM   1033  CD  ARG A 124       4.677   1.274   4.021  1.00 27.39           C  
ATOM   1034  NE  ARG A 124       5.201   0.451   5.111  1.00 27.39           N  
ATOM   1035  CZ  ARG A 124       4.458  -0.310   5.908  1.00 29.59           C  
ATOM   1036  NH1 ARG A 124       5.032  -0.993   6.889  1.00 30.07           N  
ATOM   1037  NH2 ARG A 124       3.145  -0.419   5.726  1.00 30.72           N  
ATOM   1038  N   PRO A 125       5.103   3.174   8.283  1.00 26.78           N  
ATOM   1039  CA  PRO A 125       4.663   2.394   9.447  1.00 26.75           C  
ATOM   1040  C   PRO A 125       3.869   3.230  10.452  1.00 26.83           C  
ATOM   1041  O   PRO A 125       2.933   2.727  11.080  1.00 26.51           O  
ATOM   1042  CB  PRO A 125       5.977   1.914  10.088  1.00 27.15           C  
ATOM   1043  CG  PRO A 125       7.040   2.195   9.119  1.00 27.01           C  
ATOM   1044  CD  PRO A 125       6.574   3.281   8.220  1.00 26.90           C  
ATOM   1045  N   LEU A 126       4.246   4.496  10.598  1.00 26.81           N  
ATOM   1046  CA  LEU A 126       3.521   5.405  11.476  1.00 26.96           C  
ATOM   1047  C   LEU A 126       2.142   5.716  10.914  1.00 26.91           C  
ATOM   1048  O   LEU A 126       1.154   5.761  11.655  1.00 27.15           O  
ATOM   1049  CB  LEU A 126       4.310   6.703  11.675  1.00 26.78           C  
ATOM   1050  CG  LEU A 126       3.663   7.772  12.562  1.00 27.22           C  
ATOM   1051  CD1 LEU A 126       3.404   7.235  13.963  1.00 28.18           C  
ATOM   1052  CD2 LEU A 126       4.549   9.007  12.623  1.00 27.43           C  
ATOM   1053  N   LEU A 127       2.071   5.934   9.603  1.00 27.01           N  
ATOM   1054  CA  LEU A 127       0.789   6.214   8.957  1.00 27.41           C  
ATOM   1055  C   LEU A 127      -0.200   5.062   9.134  1.00 27.43           C  
ATOM   1056  O   LEU A 127      -1.399   5.296   9.307  1.00 26.89           O  
ATOM   1057  CB  LEU A 127       0.975   6.542   7.475  1.00 27.76           C  
ATOM   1058  CG  LEU A 127       1.723   7.847   7.182  1.00 28.52           C  
ATOM   1059  CD1 LEU A 127       2.182   7.880   5.726  1.00 29.53           C  
ATOM   1060  CD2 LEU A 127       0.868   9.065   7.511  1.00 30.14           C  
ATOM   1061  N   VAL A 128       0.306   3.831   9.111  1.00 27.79           N  
ATOM   1062  CA  VAL A 128      -0.523   2.660   9.389  1.00 28.38           C  
ATOM   1063  C   VAL A 128      -1.026   2.688  10.840  1.00 28.74           C  
ATOM   1064  O   VAL A 128      -2.218   2.480  11.088  1.00 28.39           O  
ATOM   1065  CB  VAL A 128       0.236   1.348   9.085  1.00 28.32           C  
ATOM   1066  CG1 VAL A 128      -0.572   0.130   9.532  1.00 29.07           C  
ATOM   1067  CG2 VAL A 128       0.533   1.256   7.604  1.00 28.06           C  
ATOM   1068  N   ARG A 129      -0.127   2.963  11.787  1.00 29.07           N  
ATOM   1069  CA  ARG A 129      -0.485   3.012  13.210  1.00 29.67           C  
ATOM   1070  C   ARG A 129      -1.503   4.098  13.524  1.00 29.58           C  
ATOM   1071  O   ARG A 129      -2.360   3.927  14.401  1.00 29.71           O  
ATOM   1072  CB  ARG A 129       0.757   3.215  14.081  1.00 30.59           C  
ATOM   1073  CG  ARG A 129       1.620   1.984  14.217  1.00 33.26           C  
ATOM   1074  CD  ARG A 129       0.972   0.908  15.090  1.00 38.38           C  
ATOM   1075  NE  ARG A 129       1.127  -0.395  14.447  1.00 40.98           N  
ATOM   1076  CZ  ARG A 129       0.171  -1.085  13.820  1.00 41.69           C  
ATOM   1077  NH1 ARG A 129      -1.087  -0.653  13.756  1.00 41.88           N  
ATOM   1078  NH2 ARG A 129       0.485  -2.247  13.261  1.00 43.33           N  
ATOM   1079  N   LEU A 130      -1.419   5.210  12.801  1.00 29.16           N  
ATOM   1080  CA  LEU A 130      -2.359   6.305  12.975  1.00 29.26           C  
ATOM   1081  C   LEU A 130      -3.639   6.145  12.160  1.00 28.85           C  
ATOM   1082  O   LEU A 130      -4.508   7.016  12.212  1.00 28.28           O  
ATOM   1083  CB  LEU A 130      -1.690   7.629  12.618  1.00 29.32           C  
ATOM   1084  CG  LEU A 130      -0.530   8.008  13.538  1.00 30.92           C  
ATOM   1085  CD1 LEU A 130       0.026   9.328  13.123  1.00 31.97           C  
ATOM   1086  CD2 LEU A 130      -0.951   8.055  14.987  1.00 31.38           C  
ATOM   1087  N   GLY A 131      -3.748   5.049  11.405  1.00 28.71           N  
ATOM   1088  CA  GLY A 131      -4.958   4.737  10.654  1.00 28.84           C  
ATOM   1089  C   GLY A 131      -5.115   5.492   9.346  1.00 28.94           C  
ATOM   1090  O   GLY A 131      -6.210   5.508   8.765  1.00 28.47           O  
ATOM   1091  N   LYS A 132      -4.038   6.115   8.877  1.00 28.67           N  
ATOM   1092  CA  LYS A 132      -4.064   6.869   7.623  1.00 29.20           C  
ATOM   1093  C   LYS A 132      -3.917   5.938   6.429  1.00 29.34           C  
ATOM   1094  O   LYS A 132      -4.337   6.274   5.319  1.00 29.45           O  
ATOM   1095  CB  LYS A 132      -2.939   7.901   7.588  1.00 29.36           C  
ATOM   1096  CG  LYS A 132      -2.986   8.936   8.700  1.00 29.89           C  
ATOM   1097  CD  LYS A 132      -4.213   9.825   8.584  1.00 31.08           C  
ATOM   1098  CE  LYS A 132      -4.042  11.113   9.375  0.50 30.88           C  
ATOM   1099  NZ  LYS A 132      -2.964  11.962   8.794  0.50 31.72           N  
ATOM   1100  N   LEU A 133      -3.276   4.794   6.658  1.00 29.59           N  
ATOM   1101  CA  LEU A 133      -3.173   3.732   5.663  1.00 29.72           C  
ATOM   1102  C   LEU A 133      -3.698   2.432   6.256  1.00 30.05           C  
ATOM   1103  O   LEU A 133      -3.604   2.217   7.462  1.00 29.41           O  
ATOM   1104  CB  LEU A 133      -1.722   3.531   5.236  1.00 29.68           C  
ATOM   1105  CG  LEU A 133      -1.047   4.725   4.565  1.00 29.59           C  
ATOM   1106  CD1 LEU A 133       0.426   4.441   4.367  1.00 30.08           C  
ATOM   1107  CD2 LEU A 133      -1.718   5.055   3.240  1.00 30.51           C  
ATOM   1108  N   PRO A 134      -4.241   1.546   5.406  1.00 30.70           N  
ATOM   1109  CA  PRO A 134      -4.766   0.284   5.917  1.00 30.78           C  
ATOM   1110  C   PRO A 134      -3.690  -0.587   6.549  1.00 30.75           C  
ATOM   1111  O   PRO A 134      -2.557  -0.602   6.082  1.00 30.65           O  
ATOM   1112  CB  PRO A 134      -5.308  -0.414   4.662  1.00 30.92           C  
ATOM   1113  CG  PRO A 134      -5.428   0.639   3.638  1.00 31.05           C  
ATOM   1114  CD  PRO A 134      -4.397   1.658   3.946  1.00 30.92           C  
ATOM   1115  N   ASP A 135      -4.065  -1.305   7.602  1.00 31.21           N  
ATOM   1116  CA  ASP A 135      -3.180  -2.260   8.260  1.00 31.32           C  
ATOM   1117  C   ASP A 135      -3.464  -3.654   7.699  1.00 31.47           C  
ATOM   1118  O   ASP A 135      -4.377  -4.348   8.162  1.00 31.65           O  
ATOM   1119  CB  ASP A 135      -3.416  -2.229   9.773  1.00 31.59           C  
ATOM   1120  CG  ASP A 135      -2.332  -2.947  10.555  1.00 32.49           C  
ATOM   1121  OD1 ASP A 135      -1.397  -3.514   9.943  1.00 33.64           O  
ATOM   1122  OD2 ASP A 135      -2.407  -2.929  11.803  1.00 36.80           O  
ATOM   1123  N   VAL A 136      -2.690  -4.054   6.696  1.00 31.19           N  
ATOM   1124  CA  VAL A 136      -2.925  -5.324   5.994  1.00 31.07           C  
ATOM   1125  C   VAL A 136      -1.822  -6.327   6.317  1.00 30.85           C  
ATOM   1126  O   VAL A 136      -0.654  -6.042   6.097  1.00 30.72           O  
ATOM   1127  CB  VAL A 136      -2.990  -5.128   4.469  1.00 31.14           C  
ATOM   1128  CG1 VAL A 136      -3.503  -6.404   3.795  1.00 31.27           C  
ATOM   1129  CG2 VAL A 136      -3.889  -3.949   4.114  1.00 31.26           C  
ATOM   1130  N   PRO A 137      -2.187  -7.512   6.838  1.00 30.87           N  
ATOM   1131  CA  PRO A 137      -1.178  -8.542   7.111  1.00 30.68           C  
ATOM   1132  C   PRO A 137      -0.399  -8.988   5.872  1.00 30.50           C  
ATOM   1133  O   PRO A 137      -0.948  -9.003   4.765  1.00 30.20           O  
ATOM   1134  CB  PRO A 137      -2.005  -9.716   7.656  1.00 30.87           C  
ATOM   1135  CG  PRO A 137      -3.284  -9.140   8.083  1.00 31.20           C  
ATOM   1136  CD  PRO A 137      -3.539  -7.949   7.225  1.00 31.15           C  
ATOM   1137  N   LYS A 138       0.858  -9.373   6.076  1.00 30.25           N  
ATOM   1138  CA  LYS A 138       1.725  -9.851   5.003  1.00 30.27           C  
ATOM   1139  C   LYS A 138       1.070 -10.983   4.212  1.00 30.03           C  
ATOM   1140  O   LYS A 138       1.146 -11.001   2.987  1.00 29.61           O  
ATOM   1141  CB  LYS A 138       3.075 -10.311   5.575  1.00 30.65           C  
ATOM   1142  CG  LYS A 138       4.018 -11.007   4.597  0.50 30.58           C  
ATOM   1143  CD  LYS A 138       5.340 -11.368   5.281  0.50 30.90           C  
ATOM   1144  CE  LYS A 138       6.057 -12.507   4.574  0.50 31.41           C  
ATOM   1145  NZ  LYS A 138       7.269 -12.955   5.321  0.50 31.70           N  
ATOM   1146  N   VAL A 139       0.434 -11.927   4.906  1.00 29.78           N  
ATOM   1147  CA  VAL A 139      -0.190 -13.066   4.205  1.00 29.37           C  
ATOM   1148  C   VAL A 139      -1.318 -12.607   3.279  1.00 28.64           C  
ATOM   1149  O   VAL A 139      -1.556 -13.215   2.239  1.00 28.06           O  
ATOM   1150  CB  VAL A 139      -0.722 -14.176   5.163  1.00 29.59           C  
ATOM   1151  CG1 VAL A 139       0.426 -14.802   5.952  1.00 30.76           C  
ATOM   1152  CG2 VAL A 139      -1.786 -13.651   6.088  1.00 30.32           C  
ATOM   1153  N   VAL A 140      -2.016 -11.543   3.670  1.00 27.79           N  
ATOM   1154  CA  VAL A 140      -3.098 -11.001   2.853  1.00 27.86           C  
ATOM   1155  C   VAL A 140      -2.526 -10.261   1.637  1.00 27.24           C  
ATOM   1156  O   VAL A 140      -3.024 -10.412   0.528  1.00 26.63           O  
ATOM   1157  CB  VAL A 140      -4.027 -10.081   3.679  1.00 27.55           C  
ATOM   1158  CG1 VAL A 140      -5.062  -9.416   2.787  1.00 27.94           C  
ATOM   1159  CG2 VAL A 140      -4.711 -10.877   4.775  1.00 28.07           C  
ATOM   1160  N   LEU A 141      -1.477  -9.469   1.849  1.00 27.39           N  
ATOM   1161  CA  LEU A 141      -0.723  -8.880   0.735  1.00 27.64           C  
ATOM   1162  C   LEU A 141      -0.230  -9.952  -0.235  1.00 27.46           C  
ATOM   1163  O   LEU A 141      -0.320  -9.770  -1.445  1.00 27.63           O  
ATOM   1164  CB  LEU A 141       0.480  -8.078   1.247  1.00 28.17           C  
ATOM   1165  CG  LEU A 141       0.362  -6.564   1.497  1.00 30.11           C  
ATOM   1166  CD1 LEU A 141      -1.060  -6.067   1.581  1.00 30.91           C  
ATOM   1167  CD2 LEU A 141       1.137  -6.182   2.759  1.00 31.75           C  
ATOM   1168  N   GLU A 142       0.294 -11.057   0.302  1.00 27.07           N  
ATOM   1169  CA  GLU A 142       0.768 -12.172  -0.525  0.50 26.92           C  
ATOM   1171  C   GLU A 142      -0.367 -12.749  -1.372  1.00 26.50           C  
ATOM   1172  O   GLU A 142      -0.212 -12.953  -2.580  1.00 26.67           O  
ATOM   1173  CB  GLU A 142       1.389 -13.273   0.346  0.50 27.00           C  
ATOM   1175  CG  GLU A 142       2.725 -12.893   0.970  0.50 27.44           C  
ATOM   1177  CD  GLU A 142       3.382 -13.724   1.905  0.00 20.00           C  
ATOM   1179  OE1 GLU A 142       4.356 -14.319   1.401  0.00 20.00           O  
ATOM   1181  OE2 GLU A 142       3.008 -13.920   3.082  0.00 20.00           O  
ATOM   1183  N   ALA A 143      -1.504 -13.004  -0.736  1.00 26.17           N  
ATOM   1184  CA  ALA A 143      -2.684 -13.491  -1.438  1.00 25.98           C  
ATOM   1185  C   ALA A 143      -3.137 -12.518  -2.535  1.00 25.45           C  
ATOM   1186  O   ALA A 143      -3.499 -12.935  -3.623  1.00 24.28           O  
ATOM   1187  CB  ALA A 143      -3.810 -13.745  -0.452  1.00 25.93           C  
ATOM   1188  N   SER A 144      -3.115 -11.220  -2.248  1.00 25.66           N  
ATOM   1189  CA  SER A 144      -3.492 -10.210  -3.253  1.00 25.87           C  
ATOM   1190  C   SER A 144      -2.538 -10.218  -4.450  1.00 26.11           C  
ATOM   1191  O   SER A 144      -2.966 -10.083  -5.605  1.00 26.21           O  
ATOM   1192  CB  SER A 144      -3.538  -8.817  -2.621  1.00 26.15           C  
ATOM   1193  OG  SER A 144      -4.644  -8.719  -1.754  1.00 25.81           O  
ATOM   1194  N   ALA A 145      -1.252 -10.394  -4.164  1.00 26.28           N  
ATOM   1195  CA  ALA A 145      -0.227 -10.509  -5.203  1.00 26.29           C  
ATOM   1196  C   ALA A 145      -0.417 -11.756  -6.065  1.00 25.96           C  
ATOM   1197  O   ALA A 145      -0.299 -11.683  -7.281  1.00 26.35           O  
ATOM   1198  CB  ALA A 145       1.146 -10.507  -4.578  1.00 26.55           C  
ATOM   1199  N   LYS A 146      -0.718 -12.892  -5.432  1.00 26.04           N  
ATOM   1200  CA  LYS A 146      -1.035 -14.128  -6.149  1.00 25.85           C  
ATOM   1201  C   LYS A 146      -2.246 -13.931  -7.059  1.00 25.12           C  
ATOM   1202  O   LYS A 146      -2.229 -14.331  -8.217  1.00 24.80           O  
ATOM   1203  CB  LYS A 146      -1.278 -15.293  -5.173  1.00 26.21           C  
ATOM   1204  CG  LYS A 146       0.023 -15.920  -4.641  1.00 27.59           C  
ATOM   1205  CD  LYS A 146      -0.129 -16.524  -3.244  1.00 28.28           C  
ATOM   1206  CE  LYS A 146      -0.683 -17.925  -3.245  1.00 30.36           C  
ATOM   1207  NZ  LYS A 146      -0.608 -18.525  -1.860  1.00 30.53           N  
ATOM   1208  N   LEU A 147      -3.297 -13.307  -6.535  1.00 24.37           N  
ATOM   1209  CA  LEU A 147      -4.488 -13.031  -7.332  1.00 24.36           C  
ATOM   1210  C   LEU A 147      -4.182 -12.134  -8.531  1.00 24.15           C  
ATOM   1211  O   LEU A 147      -4.549 -12.459  -9.646  1.00 23.81           O  
ATOM   1212  CB  LEU A 147      -5.579 -12.387  -6.480  1.00 24.09           C  
ATOM   1213  CG  LEU A 147      -6.835 -11.911  -7.218  1.00 23.84           C  
ATOM   1214  CD1 LEU A 147      -7.537 -13.016  -7.990  1.00 23.61           C  
ATOM   1215  CD2 LEU A 147      -7.786 -11.289  -6.218  1.00 24.84           C  
ATOM   1216  N   ALA A 148      -3.513 -11.010  -8.291  1.00 24.70           N  
ATOM   1217  CA  ALA A 148      -3.178 -10.072  -9.376  1.00 25.29           C  
ATOM   1218  C   ALA A 148      -2.390 -10.781 -10.489  1.00 25.60           C  
ATOM   1219  O   ALA A 148      -2.674 -10.593 -11.674  1.00 26.51           O  
ATOM   1220  CB  ALA A 148      -2.394  -8.886  -8.833  1.00 25.77           C  
ATOM   1221  N   ALA A 149      -1.429 -11.613 -10.100  1.00 26.12           N  
ATOM   1222  CA  ALA A 149      -0.644 -12.402 -11.056  1.00 25.89           C  
ATOM   1223  C   ALA A 149      -1.510 -13.370 -11.848  1.00 25.88           C  
ATOM   1224  O   ALA A 149      -1.315 -13.548 -13.057  1.00 25.89           O  
ATOM   1225  CB  ALA A 149       0.457 -13.164 -10.330  1.00 26.48           C  
ATOM   1226  N   ALA A 150      -2.469 -13.995 -11.166  1.00 25.29           N  
ATOM   1227  CA  ALA A 150      -3.372 -14.949 -11.791  1.00 25.24           C  
ATOM   1228  C   ALA A 150      -4.269 -14.271 -12.821  1.00 24.90           C  
ATOM   1229  O   ALA A 150      -4.516 -14.816 -13.897  1.00 24.23           O  
ATOM   1230  CB  ALA A 150      -4.222 -15.657 -10.730  1.00 25.05           C  
ATOM   1231  N   LEU A 151      -4.759 -13.082 -12.483  1.00 25.04           N  
ATOM   1232  CA  LEU A 151      -5.600 -12.309 -13.398  1.00 25.60           C  
ATOM   1233  C   LEU A 151      -4.809 -11.846 -14.625  1.00 26.16           C  
ATOM   1234  O   LEU A 151      -5.294 -11.949 -15.746  1.00 25.97           O  
ATOM   1235  CB  LEU A 151      -6.220 -11.111 -12.678  1.00 25.33           C  
ATOM   1236  CG  LEU A 151      -7.221 -11.454 -11.566  1.00 24.24           C  
ATOM   1237  CD1 LEU A 151      -7.544 -10.217 -10.734  1.00 24.93           C  
ATOM   1238  CD2 LEU A 151      -8.477 -12.037 -12.143  1.00 24.56           C  
ATOM   1239  N   GLU A 152      -3.595 -11.348 -14.399  1.00 27.66           N  
ATOM   1240  CA  GLU A 152      -2.703 -10.967 -15.498  1.00 27.83           C  
ATOM   1241  C   GLU A 152      -2.452 -12.166 -16.415  1.00 27.88           C  
ATOM   1242  O   GLU A 152      -2.497 -12.046 -17.638  1.00 28.35           O  
ATOM   1243  CB  GLU A 152      -1.381 -10.418 -14.947  1.00 28.58           C  
ATOM   1244  CG  GLU A 152      -0.419  -9.845 -16.000  1.00 30.27           C  
ATOM   1245  CD  GLU A 152      -0.966  -8.620 -16.737  1.00 36.05           C  
ATOM   1246  OE1 GLU A 152      -1.922  -7.980 -16.232  1.00 39.42           O  
ATOM   1247  OE2 GLU A 152      -0.432  -8.295 -17.830  1.00 39.54           O  
ATOM   1248  N   HIS A 153      -2.224 -13.329 -15.818  1.00 28.12           N  
ATOM   1249  CA  HIS A 153      -1.964 -14.545 -16.582  1.00 27.70           C  
ATOM   1250  C   HIS A 153      -3.138 -14.931 -17.474  1.00 27.34           C  
ATOM   1251  O   HIS A 153      -2.947 -15.281 -18.636  1.00 27.02           O  
ATOM   1252  CB  HIS A 153      -1.612 -15.700 -15.650  1.00 28.27           C  
ATOM   1253  CG  HIS A 153      -0.850 -16.796 -16.322  1.00 28.88           C  
ATOM   1254  ND1 HIS A 153      -1.461 -17.896 -16.878  1.00 30.43           N  
ATOM   1255  CD2 HIS A 153       0.479 -16.957 -16.528  1.00 30.91           C  
ATOM   1256  CE1 HIS A 153      -0.542 -18.693 -17.395  1.00 30.17           C  
ATOM   1257  NE2 HIS A 153       0.643 -18.147 -17.194  1.00 30.76           N  
ATOM   1258  N   HIS A 154      -4.356 -14.859 -16.936  1.00 26.68           N  
ATOM   1259  CA  HIS A 154      -5.559 -15.109 -17.723  1.00 26.48           C  
ATOM   1260  C   HIS A 154      -5.609 -14.213 -18.950  1.00 26.29           C  
ATOM   1261  O   HIS A 154      -6.043 -14.631 -20.009  1.00 24.87           O  
ATOM   1262  CB  HIS A 154      -6.830 -14.864 -16.901  1.00 26.05           C  
ATOM   1263  CG  HIS A 154      -7.213 -16.010 -16.020  1.00 25.22           C  
ATOM   1264  ND1 HIS A 154      -7.562 -17.244 -16.519  1.00 24.79           N  
ATOM   1265  CD2 HIS A 154      -7.329 -16.100 -14.674  1.00 24.26           C  
ATOM   1266  CE1 HIS A 154      -7.859 -18.053 -15.516  1.00 24.75           C  
ATOM   1267  NE2 HIS A 154      -7.726 -17.383 -14.386  1.00 24.01           N  
ATOM   1268  N   HIS A 155      -5.167 -12.973 -18.793  1.00 26.64           N  
ATOM   1269  CA  HIS A 155      -5.321 -11.988 -19.859  1.00 27.39           C  
ATOM   1270  C   HIS A 155      -4.368 -12.206 -21.034  1.00 27.75           C  
ATOM   1271  O   HIS A 155      -4.595 -11.660 -22.112  1.00 28.10           O  
ATOM   1272  CB  HIS A 155      -5.174 -10.578 -19.298  1.00 27.44           C  
ATOM   1273  CG  HIS A 155      -6.190 -10.257 -18.245  1.00 27.44           C  
ATOM   1274  ND1 HIS A 155      -5.952  -9.360 -17.228  1.00 27.76           N  
ATOM   1275  CD2 HIS A 155      -7.439 -10.742 -18.039  1.00 28.24           C  
ATOM   1276  CE1 HIS A 155      -7.019  -9.291 -16.448  1.00 28.04           C  
ATOM   1277  NE2 HIS A 155      -7.932 -10.123 -16.914  1.00 26.93           N  
ATOM   1278  N   HIS A 156      -3.328 -13.009 -20.831  1.00 27.88           N  
ATOM   1279  CA  HIS A 156      -2.408 -13.361 -21.917  1.00 28.82           C  
ATOM   1280  C   HIS A 156      -2.476 -14.841 -22.275  1.00 29.11           C  
ATOM   1281  O   HIS A 156      -1.610 -15.348 -22.993  1.00 28.61           O  
ATOM   1282  CB  HIS A 156      -0.988 -12.971 -21.537  1.00 29.05           C  
ATOM   1283  CG  HIS A 156      -0.845 -11.521 -21.208  1.00 30.57           C  
ATOM   1284  ND1 HIS A 156      -0.870 -10.534 -22.171  1.00 32.40           N  
ATOM   1285  CD2 HIS A 156      -0.704 -10.887 -20.021  1.00 31.79           C  
ATOM   1286  CE1 HIS A 156      -0.731  -9.355 -21.589  1.00 32.70           C  
ATOM   1287  NE2 HIS A 156      -0.628  -9.543 -20.286  1.00 32.66           N  
ATOM   1288  N   HIS A 157      -3.510 -15.523 -21.783  1.00 29.53           N  
ATOM   1289  CA  HIS A 157      -3.719 -16.935 -22.087  1.00 30.00           C  
ATOM   1290  C   HIS A 157      -4.669 -17.092 -23.269  1.00 30.39           C  
ATOM   1291  O   HIS A 157      -5.698 -16.419 -23.347  1.00 30.44           O  
ATOM   1292  CB  HIS A 157      -4.274 -17.694 -20.874  1.00 30.21           C  
ATOM   1293  CG  HIS A 157      -4.774 -19.062 -21.213  1.00 30.44           C  
ATOM   1294  ND1 HIS A 157      -4.017 -20.199 -21.032  1.00 31.65           N  
ATOM   1295  CD2 HIS A 157      -5.945 -19.471 -21.756  1.00 32.47           C  
ATOM   1296  CE1 HIS A 157      -4.709 -21.251 -21.434  1.00 32.16           C  
ATOM   1297  NE2 HIS A 157      -5.880 -20.837 -21.886  1.00 32.84           N  
ATOM   1298  N   HIS A 158      -4.340 -18.013 -24.170  1.00 30.78           N  
ATOM   1299  CA  HIS A 158      -5.132 -18.231 -25.374  1.00 31.27           C  
ATOM   1300  C   HIS A 158      -5.481 -19.701 -25.567  1.00 31.74           C  
ATOM   1301  O   HIS A 158      -6.282 -20.054 -26.427  1.00 32.38           O  
ATOM   1302  CB  HIS A 158      -4.382 -17.698 -26.589  1.00 31.57           C  
ATOM   1303  CG  HIS A 158      -4.137 -16.226 -26.534  1.00 31.85           C  
ATOM   1304  ND1 HIS A 158      -4.936 -15.311 -27.186  1.00 33.16           N  
ATOM   1305  CD2 HIS A 158      -3.195 -15.507 -25.882  1.00 32.22           C  
ATOM   1306  CE1 HIS A 158      -4.485 -14.092 -26.950  1.00 32.44           C  
ATOM   1307  NE2 HIS A 158      -3.432 -14.183 -26.158  1.00 32.89           N  
ATOM   1308  OXT HIS A 158      -4.997 -20.571 -24.851  1.00 32.54           O  
TER    1309      HIS A 158                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
