
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  134 ( 1019),  selected  134 , name 3d9r_C
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 3d9r_C.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_C      M       1           -
LGA    S     2_C      M       2           -
LGA    K     3_C      -       -           -
LGA    I     4_C      -       -           -
LGA    F     5_C      T       3          2.901
LGA    N     6_C      H       4          2.400
LGA    E     7_C      Y       5          2.580
LGA    E     8_C      S       6          2.521
LGA    L     9_C      D       7          1.643
LGA    A    10_C      -       -           -
LGA    V    11_C      N       8          3.010
LGA    I    12_C      T       9          1.919
LGA    E    13_C      L      10          1.475
LGA    A    14_C      K      11          2.314
LGA    A    15_C      V      12          1.496
LGA    A    16_C      A      13          1.270
LGA    I    17_C      H      14          1.766
LGA    A    18_C      Q      15          1.826
LGA    Y    19_C      G      16          2.036
LGA    L    20_C      F      17          1.799
LGA    T    21_C      E      18          1.873
LGA    A    22_C      F      19          1.389
LGA    F    23_C      F      20          1.925
LGA    N    24_C      T      21          1.828
LGA    R    25_C      Q      22          1.525
LGA    A    26_C      G      23          1.636
LGA    -       -      L      24           -
LGA    -       -      A      25           -
LGA    -       -      T      26           -
LGA    -       -      G      27           -
LGA    D    27_C      E      28          2.625
LGA    I    28_C      W      29          0.788
LGA    P    29_C      Q      30          0.515
LGA    A    30_C      K      31          0.879
LGA    V    31_C      F      32          1.398
LGA    I    32_C      L      33          0.681
LGA    A    33_C      D      34          1.314
LGA    T    34_C      M      35          1.873
LGA    Y    35_C      L      36          1.172
LGA    T    36_C      T      37          0.663
LGA    D    37_C      E      38          0.774
LGA    D    38_C      D      39          0.919
LGA    G    39_C      F      40          0.358
LGA    V    40_C      T      41          0.715
LGA    L    41_C      F      42          1.355
LGA    X    42_C      W      43          1.164
LGA    G    43_C      F      44          1.830
LGA    P    44_C      P      45          2.900
LGA    G    45_C      M      46          2.183
LGA    -       -      G      47           -
LGA    -       -      E      48           -
LGA    R    46_C      F      49          1.623
LGA    P    47_C      H      50          2.963
LGA    -       -      G      51           -
LGA    A    48_C      L      52          2.681
LGA    A    49_C      N      53          2.489
LGA    V    50_C      V      54          0.986
LGA    G    51_C      G      55          0.852
LGA    K    52_C      K      56          0.841
LGA    D    53_C      E      57          0.671
LGA    E    54_C      R      58          0.657
LGA    L    55_C      A      59          0.461
LGA    A    56_C      K      60          0.603
LGA    E    57_C      E      61          0.941
LGA    V    58_C      F      62          0.773
LGA    Y    59_C      F      63          0.467
LGA    L    60_C      T      64          0.574
LGA    S    61_C      Y      65          0.832
LGA    V    62_C      V      66          0.613
LGA    F    63_C      S      67          0.600
LGA    E    64_C      E      68          0.604
LGA    T    65_C      S      69          1.949
LGA    V    66_C      F      70          2.917
LGA    -       -      H      71           -
LGA    -       -      T      72           -
LGA    G    67_C      G      73          2.628
LGA    F    68_C      I      74          1.190
LGA    D    69_C      Q      75          0.760
LGA    X    70_C      I      76          0.886
LGA    -       -      S      77           -
LGA    A    71_C      S      78          2.992
LGA    Y    72_C      L      79          2.463
LGA    E    73_C      D      80          3.694
LGA    I    74_C      R      81          4.201
LGA    K    75_C      V      82          2.483
LGA    E    76_C      T      83          1.369
LGA    V    77_C      S      84          2.030
LGA    V    78_C      N      85          1.363
LGA    Q    79_C      E      86          1.230
LGA    T    80_C      -       -           -
LGA    S    81_C      -       -           -
LGA    A    82_C      -       -           -
LGA    D    83_C      -       -           -
LGA    W    84_C      -       -           -
LGA    A    85_C      T      87          0.887
LGA    F    86_C      T      88          0.928
LGA    V    87_C      V      89          0.746
LGA    R    88_C      V      90          1.487
LGA    S    89_C      F      91          1.356
LGA    A    90_C      E      92          0.680
LGA    T    91_C      F      93          1.396
LGA    E    92_C      R      94          0.380
LGA    G    93_C      D      95          2.327
LGA    T    94_C      E      96          0.843
LGA    E    95_C      G      97          2.952
LGA    T    96_C      L      98          1.625
LGA    N    97_C      F      99          0.442
LGA    K    98_C      L     100          2.881
LGA    A    99_C      -       -           -
LGA    T   100_C      -       -           -
LGA    G   101_C      G     101          0.194
LGA    V   102_C      K     102          0.719
LGA    V   103_C      P     103          1.330
LGA    T   104_C      Y     104          2.521
LGA    P   105_C      K     105          1.756
LGA    A   106_C      N     106          1.063
LGA    A   107_C      R     107          1.022
LGA    Y   108_C      V     108          0.319
LGA    Q   109_C      A     109          0.733
LGA    E   110_C      V     110          1.711
LGA    L   111_C      S     111          1.577
LGA    F   112_C      F     112          1.329
LGA    L   113_C      D     113          1.333
LGA    L   114_C      V     114          1.090
LGA    R   115_C      R     115          1.229
LGA    K   116_C      G     116          1.604
LGA    S   117_C      -       -           -
LGA    A   118_C      -       -           -
LGA    T   119_C      -       -           -
LGA    G   120_C      -       -           -
LGA    S   121_C      -       -           -
LGA    W   122_C      D     117          2.553
LGA    Q   123_C      K     118          1.391
LGA    T   124_C      I     119          1.228
LGA    A   125_C      C     120          1.025
LGA    R   126_C      S     121          1.326
LGA    Y   127_C      Y     122          0.989
LGA    C   128_C      R     123          0.290
LGA    T   129_C      E     124          0.804
LGA    S   130_C      Y     125          0.726
LGA    K   131_C      F     126          0.955
LGA    I   132_C      G     127          0.468
LGA    S   133_C      S     128          0.741
LGA    P   134_C      D     129          1.247
LGA    -       -      G     130           -
LGA    -       -      K     131           -
LGA    -       -      S     132           -
LGA    -       -      N     133           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  134  133    5.0    117    1.66    15.38     79.670     6.639

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.625298 * X  +  -0.646457 * Y  +  -0.437146 * Z  +  81.659302
  Y_new =  -0.691145 * X  +   0.198630 * Y  +   0.694885 * Z  +  21.301256
  Z_new =  -0.362383 * X  +   0.736641 * Y  +  -0.570998 * Z  +  -8.680182 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.230192   -0.911400  [ DEG:   127.7806    -52.2194 ]
  Theta =   0.370823    2.770769  [ DEG:    21.2466    158.7534 ]
  Phi   =  -2.306217    0.835376  [ DEG:  -132.1365     47.8635 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3d9r_C                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3d9r_C.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  134  133   5.0  117   1.66   15.38  79.670
REMARK  ---------------------------------------------------------- 
MOLECULE 3d9r_C
HEADER    ISOMERASE                               27-MAY-08   3D9R              
TITLE     CRYSTAL STRUCTURE OF KETOSTEROID ISOMERASE-LIKE PROTEIN               
TITLE    2 (YP_049581.1) FROM ERWINIA CAROTOVORA ATROSEPTICA SCRI1043           
TITLE    3 AT 2.40 A RESOLUTION                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: KETOSTEROID ISOMERASE-LIKE PROTEIN;                        
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PECTOBACTERIUM ATROSEPTICUM;                    
SOURCE   3 GENE: YP_049581.1, ECA1476;                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_049581.1, KETOSTEROID ISOMERASE-LIKE PROTEIN, STRUCTURAL           
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI-2                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   01-JUL-08 3D9R    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF KETOSTEROID ISOMERASE-LIKE              
JRNL        TITL 2 PROTEIN (YP_049581.1) FROM ERWINIA CAROTOVORA                
JRNL        TITL 3 ATROSEPTICA SCRI1043 AT 2.40 A RESOLUTION                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  3D9R A    1   134  UNP    Q6D750   Q6D750_ERWCT     1    134             
DBREF  3D9R B    1   134  UNP    Q6D750   Q6D750_ERWCT     1    134             
DBREF  3D9R C    1   134  UNP    Q6D750   Q6D750_ERWCT     1    134             
DBREF  3D9R D    1   134  UNP    Q6D750   Q6D750_ERWCT     1    134             
SEQRES   1 A  135  GLY MSE SER LYS ILE PHE ASN GLU GLU LEU ALA VAL ILE          
SEQRES   2 A  135  GLU ALA ALA ALA ILE ALA TYR LEU THR ALA PHE ASN ARG          
SEQRES   3 A  135  ALA ASP ILE PRO ALA VAL ILE ALA THR TYR THR ASP ASP          
SEQRES   4 A  135  GLY VAL LEU MSE GLY PRO GLY ARG PRO ALA ALA VAL GLY          
SEQRES   5 A  135  LYS ASP GLU LEU ALA GLU VAL TYR LEU SER VAL PHE GLU          
SEQRES   6 A  135  THR VAL GLY PHE ASP MSE ALA TYR GLU ILE LYS GLU VAL          
SEQRES   7 A  135  VAL GLN THR SER ALA ASP TRP ALA PHE VAL ARG SER ALA          
SEQRES   8 A  135  THR GLU GLY THR GLU THR ASN LYS ALA THR GLY VAL VAL          
SEQRES   9 A  135  THR PRO ALA ALA TYR GLN GLU LEU PHE LEU LEU ARG LYS          
SEQRES  10 A  135  SER ALA THR GLY SER TRP GLN THR ALA ARG TYR CYS THR          
SEQRES  11 A  135  SER LYS ILE SER PRO                                          
SEQRES   1 B  135  GLY MSE SER LYS ILE PHE ASN GLU GLU LEU ALA VAL ILE          
SEQRES   2 B  135  GLU ALA ALA ALA ILE ALA TYR LEU THR ALA PHE ASN ARG          
SEQRES   3 B  135  ALA ASP ILE PRO ALA VAL ILE ALA THR TYR THR ASP ASP          
SEQRES   4 B  135  GLY VAL LEU MSE GLY PRO GLY ARG PRO ALA ALA VAL GLY          
SEQRES   5 B  135  LYS ASP GLU LEU ALA GLU VAL TYR LEU SER VAL PHE GLU          
SEQRES   6 B  135  THR VAL GLY PHE ASP MSE ALA TYR GLU ILE LYS GLU VAL          
SEQRES   7 B  135  VAL GLN THR SER ALA ASP TRP ALA PHE VAL ARG SER ALA          
SEQRES   8 B  135  THR GLU GLY THR GLU THR ASN LYS ALA THR GLY VAL VAL          
SEQRES   9 B  135  THR PRO ALA ALA TYR GLN GLU LEU PHE LEU LEU ARG LYS          
SEQRES  10 B  135  SER ALA THR GLY SER TRP GLN THR ALA ARG TYR CYS THR          
SEQRES  11 B  135  SER LYS ILE SER PRO                                          
SEQRES   1 C  135  GLY MSE SER LYS ILE PHE ASN GLU GLU LEU ALA VAL ILE          
SEQRES   2 C  135  GLU ALA ALA ALA ILE ALA TYR LEU THR ALA PHE ASN ARG          
SEQRES   3 C  135  ALA ASP ILE PRO ALA VAL ILE ALA THR TYR THR ASP ASP          
SEQRES   4 C  135  GLY VAL LEU MSE GLY PRO GLY ARG PRO ALA ALA VAL GLY          
SEQRES   5 C  135  LYS ASP GLU LEU ALA GLU VAL TYR LEU SER VAL PHE GLU          
SEQRES   6 C  135  THR VAL GLY PHE ASP MSE ALA TYR GLU ILE LYS GLU VAL          
SEQRES   7 C  135  VAL GLN THR SER ALA ASP TRP ALA PHE VAL ARG SER ALA          
SEQRES   8 C  135  THR GLU GLY THR GLU THR ASN LYS ALA THR GLY VAL VAL          
SEQRES   9 C  135  THR PRO ALA ALA TYR GLN GLU LEU PHE LEU LEU ARG LYS          
SEQRES  10 C  135  SER ALA THR GLY SER TRP GLN THR ALA ARG TYR CYS THR          
SEQRES  11 C  135  SER LYS ILE SER PRO                                          
SEQRES   1 D  135  GLY MSE SER LYS ILE PHE ASN GLU GLU LEU ALA VAL ILE          
SEQRES   2 D  135  GLU ALA ALA ALA ILE ALA TYR LEU THR ALA PHE ASN ARG          
SEQRES   3 D  135  ALA ASP ILE PRO ALA VAL ILE ALA THR TYR THR ASP ASP          
SEQRES   4 D  135  GLY VAL LEU MSE GLY PRO GLY ARG PRO ALA ALA VAL GLY          
SEQRES   5 D  135  LYS ASP GLU LEU ALA GLU VAL TYR LEU SER VAL PHE GLU          
SEQRES   6 D  135  THR VAL GLY PHE ASP MSE ALA TYR GLU ILE LYS GLU VAL          
SEQRES   7 D  135  VAL GLN THR SER ALA ASP TRP ALA PHE VAL ARG SER ALA          
SEQRES   8 D  135  THR GLU GLY THR GLU THR ASN LYS ALA THR GLY VAL VAL          
SEQRES   9 D  135  THR PRO ALA ALA TYR GLN GLU LEU PHE LEU LEU ARG LYS          
SEQRES  10 D  135  SER ALA THR GLY SER TRP GLN THR ALA ARG TYR CYS THR          
SEQRES  11 D  135  SER LYS ILE SER PRO                                          
HET    MSE  A  42      13                                                       
HET    MSE  A  70       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  42      13                                                       
HET    MSE  B  70       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  42       8                                                       
HET    MSE  C  70       8                                                       
HET    MSE  D  42      13                                                       
HET    MSE  D  70       8                                                       
HET     NA  A 135       1                                                       
HET    UNL  A 136       7                                                       
HET    UNL  B 135       7                                                       
HET    UNL  C 135       6                                                       
HET    UNL  D 135       7                                                       
HET    GOL  A 137       6                                                       
HET    GOL  B 136       6                                                       
HET    GOL  B 137       6                                                       
HET    GOL  D 136       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NA SODIUM ION                                                       
HETNAM     UNL UNKNOWN LIGAND                                                   
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   5   NA    NA 1+                                                        
FORMUL  10  GOL    4(C3 H8 O3)                                                  
FORMUL  14  HOH   *215(H2 O)                                                    
CRYST1  115.998  135.416  139.164  90.00  90.00  90.00 C 2 2 21     32          
HETATM 2050  N   MSE C   1      49.660  -3.454   7.319  1.00 62.30           N  
HETATM 2051  CA  MSE C   1      48.238  -3.883   7.153  1.00 63.90           C  
HETATM 2052  C   MSE C   1      47.230  -2.797   7.579  1.00 63.02           C  
HETATM 2053  O   MSE C   1      46.135  -2.715   7.013  1.00 62.24           O  
HETATM 2054  CB  MSE C   1      47.953  -5.219   7.894  1.00 65.63           C  
HETATM 2055  CG  MSE C   1      48.585  -5.422   9.321  1.00 70.18           C  
HETATM 2056 SE   MSE C   1      48.427  -7.335  10.057  0.75 75.91          SE  
HETATM 2057  CE  MSE C   1      46.317  -7.285   9.930  1.00 66.96           C  
ATOM   2058  N   SER C   2      47.618  -1.956   8.545  1.00 61.93           N  
ATOM   2059  CA  SER C   2      46.702  -0.982   9.176  1.00 59.97           C  
ATOM   2060  C   SER C   2      46.121   0.111   8.248  1.00 60.44           C  
ATOM   2061  O   SER C   2      46.753   0.561   7.295  1.00 59.36           O  
ATOM   2062  CB  SER C   2      47.341  -0.350  10.439  1.00 59.41           C  
ATOM   2063  OG  SER C   2      48.263   0.697  10.163  1.00 50.57           O  
ATOM   2064  N   LYS C   3      44.892   0.512   8.542  1.00 62.29           N  
ATOM   2065  CA  LYS C   3      44.194   1.549   7.786  1.00 64.36           C  
ATOM   2066  C   LYS C   3      43.863   2.713   8.712  1.00 63.04           C  
ATOM   2067  O   LYS C   3      43.090   2.547   9.651  1.00 62.04           O  
ATOM   2068  CB  LYS C   3      42.930   0.983   7.103  1.00 64.95           C  
ATOM   2069  CG  LYS C   3      43.295   0.113   5.881  1.00 69.71           C  
ATOM   2070  CD  LYS C   3      42.282  -0.978   5.576  1.00 72.93           C  
ATOM   2071  CE  LYS C   3      42.860  -1.979   4.580  1.00 75.06           C  
ATOM   2072  NZ  LYS C   3      41.902  -3.076   4.263  1.00 76.14           N  
ATOM   2073  N   ILE C   4      44.498   3.866   8.435  1.00 62.57           N  
ATOM   2074  CA  ILE C   4      44.263   5.142   9.123  1.00 60.62           C  
ATOM   2075  C   ILE C   4      43.127   5.911   8.433  1.00 60.70           C  
ATOM   2076  O   ILE C   4      43.124   6.079   7.218  1.00 57.51           O  
ATOM   2077  CB  ILE C   4      45.538   6.066   9.117  1.00 60.19           C  
ATOM   2078  CG1 ILE C   4      46.781   5.352   9.689  1.00 60.34           C  
ATOM   2079  CG2 ILE C   4      45.273   7.382   9.894  1.00 56.64           C  
ATOM   2080  CD1 ILE C   4      47.609   4.555   8.692  1.00 54.97           C  
ATOM   2081  N   PHE C   5      42.168   6.380   9.229  1.00 63.09           N  
ATOM   2082  CA  PHE C   5      41.112   7.277   8.763  1.00 62.26           C  
ATOM   2083  C   PHE C   5      41.729   8.680   8.693  1.00 63.87           C  
ATOM   2084  O   PHE C   5      42.261   9.176   9.701  1.00 62.22           O  
ATOM   2085  CB  PHE C   5      39.943   7.214   9.775  1.00 59.86           C  
ATOM   2086  CG  PHE C   5      38.564   7.635   9.249  1.00 46.78           C  
ATOM   2087  CD1 PHE C   5      38.217   7.627   7.895  1.00 37.70           C  
ATOM   2088  CD2 PHE C   5      37.586   7.951  10.160  1.00 39.58           C  
ATOM   2089  CE1 PHE C   5      36.935   7.985   7.493  1.00 42.79           C  
ATOM   2090  CE2 PHE C   5      36.303   8.319   9.751  1.00 45.81           C  
ATOM   2091  CZ  PHE C   5      35.983   8.326   8.413  1.00 41.53           C  
ATOM   2092  N   ASN C   6      41.685   9.303   7.511  1.00 64.59           N  
ATOM   2093  CA  ASN C   6      42.091  10.718   7.375  1.00 65.51           C  
ATOM   2094  C   ASN C   6      41.515  11.549   8.530  1.00 65.29           C  
ATOM   2095  O   ASN C   6      40.312  11.507   8.829  1.00 62.05           O  
ATOM   2096  CB  ASN C   6      41.664  11.304   6.020  1.00 65.22           C  
ATOM   2097  CG  ASN C   6      41.868  12.804   5.934  1.00 64.25           C  
ATOM   2098  OD1 ASN C   6      41.194  13.582   6.607  1.00 68.35           O  
ATOM   2099  ND2 ASN C   6      42.791  13.216   5.092  1.00 54.22           N  
ATOM   2100  N   GLU C   7      42.400  12.293   9.181  1.00 65.07           N  
ATOM   2101  CA  GLU C   7      42.058  12.941  10.434  1.00 63.09           C  
ATOM   2102  C   GLU C   7      40.865  13.913  10.269  1.00 59.62           C  
ATOM   2103  O   GLU C   7      40.013  13.974  11.162  1.00 55.86           O  
ATOM   2104  CB  GLU C   7      43.318  13.606  11.025  1.00 62.71           C  
ATOM   2105  CG  GLU C   7      43.240  14.111  12.478  1.00 66.73           C  
ATOM   2106  CD  GLU C   7      42.133  13.473  13.348  1.00 68.20           C  
ATOM   2107  OE1 GLU C   7      41.904  12.241  13.271  1.00 64.49           O  
ATOM   2108  OE2 GLU C   7      41.500  14.225  14.130  1.00 66.40           O  
ATOM   2109  N   GLU C   8      40.795  14.626   9.124  1.00 57.08           N  
ATOM   2110  CA  GLU C   8      39.688  15.583   8.842  1.00 53.00           C  
ATOM   2111  C   GLU C   8      38.333  14.910   8.706  1.00 48.00           C  
ATOM   2112  O   GLU C   8      37.362  15.418   9.230  1.00 47.76           O  
ATOM   2113  CB  GLU C   8      39.972  16.474   7.633  1.00 51.59           C  
ATOM   2114  CG  GLU C   8      40.591  17.828   8.023  1.00 59.00           C  
ATOM   2115  CD  GLU C   8      39.624  18.752   8.747  1.00 58.70           C  
ATOM   2116  OE1 GLU C   8      38.491  18.334   8.958  1.00 64.87           O  
ATOM   2117  OE2 GLU C   8      39.988  19.885   9.118  1.00 61.03           O  
ATOM   2118  N   LEU C   9      38.303  13.750   8.053  1.00 45.40           N  
ATOM   2119  CA  LEU C   9      37.116  12.919   7.921  1.00 43.48           C  
ATOM   2120  C   LEU C   9      36.586  12.470   9.283  1.00 42.82           C  
ATOM   2121  O   LEU C   9      35.377  12.319   9.476  1.00 42.98           O  
ATOM   2122  CB  LEU C   9      37.417  11.690   7.042  1.00 43.00           C  
ATOM   2123  CG  LEU C   9      37.783  11.916   5.561  1.00 41.56           C  
ATOM   2124  CD1 LEU C   9      38.135  10.592   4.896  1.00 39.44           C  
ATOM   2125  CD2 LEU C   9      36.682  12.621   4.772  1.00 36.26           C  
ATOM   2126  N   ALA C  10      37.493  12.243  10.225  1.00 43.28           N  
ATOM   2127  CA  ALA C  10      37.117  11.858  11.584  1.00 42.79           C  
ATOM   2128  C   ALA C  10      36.344  12.967  12.294  1.00 44.03           C  
ATOM   2129  O   ALA C  10      35.360  12.710  12.976  1.00 45.12           O  
ATOM   2130  CB  ALA C  10      38.333  11.437  12.388  1.00 39.20           C  
ATOM   2131  N   VAL C  11      36.784  14.200  12.084  1.00 44.96           N  
ATOM   2132  CA  VAL C  11      36.207  15.390  12.686  1.00 44.36           C  
ATOM   2133  C   VAL C  11      34.844  15.737  12.039  1.00 44.78           C  
ATOM   2134  O   VAL C  11      33.919  16.157  12.733  1.00 44.60           O  
ATOM   2135  CB  VAL C  11      37.237  16.567  12.575  1.00 44.30           C  
ATOM   2136  CG1 VAL C  11      36.676  17.843  13.134  1.00 46.50           C  
ATOM   2137  CG2 VAL C  11      38.542  16.179  13.303  1.00 45.14           C  
ATOM   2138  N   ILE C  12      34.745  15.533  10.722  1.00 43.41           N  
ATOM   2139  CA  ILE C  12      33.528  15.711   9.934  1.00 42.70           C  
ATOM   2140  C   ILE C  12      32.463  14.740  10.407  1.00 44.02           C  
ATOM   2141  O   ILE C  12      31.308  15.143  10.612  1.00 45.91           O  
ATOM   2142  CB  ILE C  12      33.786  15.502   8.377  1.00 41.55           C  
ATOM   2143  CG1 ILE C  12      34.692  16.615   7.809  1.00 46.09           C  
ATOM   2144  CG2 ILE C  12      32.472  15.453   7.585  1.00 39.57           C  
ATOM   2145  CD1 ILE C  12      35.390  16.269   6.491  1.00 34.38           C  
ATOM   2146  N   GLU C  13      32.837  13.463  10.550  1.00 43.49           N  
ATOM   2147  CA  GLU C  13      31.926  12.454  11.069  1.00 43.45           C  
ATOM   2148  C   GLU C  13      31.429  12.802  12.474  1.00 43.42           C  
ATOM   2149  O   GLU C  13      30.246  12.656  12.755  1.00 46.75           O  
ATOM   2150  CB  GLU C  13      32.553  11.076  11.081  1.00 41.95           C  
ATOM   2151  CG  GLU C  13      31.626   9.996  11.640  1.00 44.49           C  
ATOM   2152  CD  GLU C  13      32.217   8.620  11.597  1.00 42.36           C  
ATOM   2153  OE1 GLU C  13      33.272   8.459  10.986  1.00 48.87           O  
ATOM   2154  OE2 GLU C  13      31.632   7.696  12.194  1.00 43.00           O  
ATOM   2155  N   ALA C  14      32.331  13.260  13.332  1.00 41.14           N  
ATOM   2156  CA  ALA C  14      31.989  13.677  14.676  1.00 41.86           C  
ATOM   2157  C   ALA C  14      30.937  14.791  14.684  1.00 42.80           C  
ATOM   2158  O   ALA C  14      30.046  14.792  15.530  1.00 46.50           O  
ATOM   2159  CB  ALA C  14      33.291  14.061  15.500  1.00 40.47           C  
ATOM   2160  N   ALA C  15      30.995  15.688  13.707  1.00 44.35           N  
ATOM   2161  CA  ALA C  15      30.000  16.754  13.534  1.00 42.38           C  
ATOM   2162  C   ALA C  15      28.611  16.253  13.103  1.00 44.41           C  
ATOM   2163  O   ALA C  15      27.601  16.716  13.618  1.00 44.79           O  
ATOM   2164  CB  ALA C  15      30.519  17.760  12.539  1.00 42.42           C  
ATOM   2165  N   ALA C  16      28.552  15.336  12.134  1.00 43.30           N  
ATOM   2166  CA  ALA C  16      27.302  14.671  11.797  1.00 42.23           C  
ATOM   2167  C   ALA C  16      26.734  13.950  13.049  1.00 43.66           C  
ATOM   2168  O   ALA C  16      25.554  14.067  13.354  1.00 42.51           O  
ATOM   2169  CB  ALA C  16      27.507  13.675  10.600  1.00 39.52           C  
ATOM   2170  N   ILE C  17      27.587  13.225  13.781  1.00 44.72           N  
ATOM   2171  CA  ILE C  17      27.161  12.473  14.962  1.00 44.55           C  
ATOM   2172  C   ILE C  17      26.718  13.406  16.103  1.00 46.22           C  
ATOM   2173  O   ILE C  17      25.828  13.027  16.868  1.00 46.91           O  
ATOM   2174  CB  ILE C  17      28.244  11.478  15.478  1.00 43.56           C  
ATOM   2175  CG1 ILE C  17      28.465  10.344  14.451  1.00 41.18           C  
ATOM   2176  CG2 ILE C  17      27.825  10.920  16.820  1.00 37.58           C  
ATOM   2177  CD1 ILE C  17      29.601   9.351  14.782  1.00 36.83           C  
ATOM   2178  N   ALA C  18      27.300  14.609  16.198  1.00 44.88           N  
ATOM   2179  CA  ALA C  18      26.841  15.608  17.187  1.00 44.52           C  
ATOM   2180  C   ALA C  18      25.361  15.941  16.995  1.00 44.74           C  
ATOM   2181  O   ALA C  18      24.611  16.006  17.969  1.00 47.94           O  
ATOM   2182  CB  ALA C  18      27.698  16.894  17.160  1.00 40.91           C  
ATOM   2183  N   TYR C  19      24.943  16.126  15.747  1.00 46.44           N  
ATOM   2184  CA  TYR C  19      23.521  16.281  15.409  1.00 46.20           C  
ATOM   2185  C   TYR C  19      22.702  15.090  15.814  1.00 45.26           C  
ATOM   2186  O   TYR C  19      21.692  15.237  16.477  1.00 47.30           O  
ATOM   2187  CB  TYR C  19      23.281  16.506  13.912  1.00 45.69           C  
ATOM   2188  CG  TYR C  19      21.789  16.437  13.556  1.00 48.15           C  
ATOM   2189  CD1 TYR C  19      20.955  17.509  13.792  1.00 49.11           C  
ATOM   2190  CD2 TYR C  19      21.218  15.279  13.023  1.00 45.86           C  
ATOM   2191  CE1 TYR C  19      19.571  17.442  13.498  1.00 46.98           C  
ATOM   2192  CE2 TYR C  19      19.855  15.201  12.745  1.00 46.55           C  
ATOM   2193  CZ  TYR C  19      19.033  16.292  12.983  1.00 46.97           C  
ATOM   2194  OH  TYR C  19      17.672  16.237  12.694  1.00 51.87           O  
ATOM   2195  N   LEU C  20      23.129  13.909  15.387  1.00 47.49           N  
ATOM   2196  CA  LEU C  20      22.346  12.669  15.585  1.00 45.79           C  
ATOM   2197  C   LEU C  20      22.063  12.342  17.038  1.00 43.83           C  
ATOM   2198  O   LEU C  20      20.990  11.868  17.366  1.00 46.53           O  
ATOM   2199  CB  LEU C  20      23.050  11.485  14.918  1.00 46.03           C  
ATOM   2200  CG  LEU C  20      23.026  11.518  13.390  1.00 43.61           C  
ATOM   2201  CD1 LEU C  20      24.029  10.491  12.832  1.00 37.12           C  
ATOM   2202  CD2 LEU C  20      21.600  11.280  12.870  1.00 38.11           C  
ATOM   2203  N   THR C  21      23.033  12.604  17.900  1.00 44.53           N  
ATOM   2204  CA  THR C  21      22.890  12.352  19.301  1.00 45.97           C  
ATOM   2205  C   THR C  21      22.093  13.467  19.965  1.00 45.86           C  
ATOM   2206  O   THR C  21      21.231  13.177  20.792  1.00 46.96           O  
ATOM   2207  CB  THR C  21      24.259  12.107  19.968  1.00 47.49           C  
ATOM   2208  OG1 THR C  21      25.184  13.076  19.533  1.00 50.32           O  
ATOM   2209  CG2 THR C  21      24.817  10.730  19.545  1.00 52.18           C  
ATOM   2210  N   ALA C  22      22.327  14.722  19.570  1.00 45.79           N  
ATOM   2211  CA  ALA C  22      21.482  15.850  20.040  1.00 45.21           C  
ATOM   2212  C   ALA C  22      20.012  15.597  19.723  1.00 45.72           C  
ATOM   2213  O   ALA C  22      19.136  15.876  20.537  1.00 48.25           O  
ATOM   2214  CB  ALA C  22      21.934  17.198  19.438  1.00 42.50           C  
ATOM   2215  N   PHE C  23      19.746  15.075  18.530  1.00 46.66           N  
ATOM   2216  CA  PHE C  23      18.391  14.756  18.103  1.00 45.67           C  
ATOM   2217  C   PHE C  23      17.798  13.620  18.947  1.00 46.99           C  
ATOM   2218  O   PHE C  23      16.618  13.648  19.349  1.00 44.72           O  
ATOM   2219  CB  PHE C  23      18.375  14.354  16.612  1.00 46.46           C  
ATOM   2220  CG  PHE C  23      16.982  14.099  16.083  1.00 46.10           C  
ATOM   2221  CD1 PHE C  23      16.229  15.123  15.566  1.00 49.92           C  
ATOM   2222  CD2 PHE C  23      16.402  12.860  16.197  1.00 46.79           C  
ATOM   2223  CE1 PHE C  23      14.942  14.906  15.136  1.00 49.69           C  
ATOM   2224  CE2 PHE C  23      15.120  12.642  15.763  1.00 48.18           C  
ATOM   2225  CZ  PHE C  23      14.393  13.670  15.231  1.00 47.42           C  
ATOM   2226  N   ASN C  24      18.609  12.597  19.193  1.00 48.35           N  
ATOM   2227  CA  ASN C  24      18.107  11.436  19.904  1.00 48.30           C  
ATOM   2228  C   ASN C  24      17.905  11.728  21.403  1.00 47.32           C  
ATOM   2229  O   ASN C  24      17.170  11.016  22.076  1.00 47.11           O  
ATOM   2230  CB  ASN C  24      18.983  10.193  19.651  1.00 47.88           C  
ATOM   2231  CG  ASN C  24      18.277   8.894  20.069  1.00 52.77           C  
ATOM   2232  OD1 ASN C  24      17.129   8.586  19.634  1.00 52.62           O  
ATOM   2233  ND2 ASN C  24      18.935   8.147  20.952  1.00 44.51           N  
ATOM   2234  N   ARG C  25      18.553  12.780  21.902  1.00 46.97           N  
ATOM   2235  CA  ARG C  25      18.260  13.371  23.213  1.00 46.16           C  
ATOM   2236  C   ARG C  25      17.093  14.357  23.158  1.00 45.54           C  
ATOM   2237  O   ARG C  25      16.706  14.915  24.199  1.00 44.72           O  
ATOM   2238  CB  ARG C  25      19.456  14.189  23.724  1.00 46.79           C  
ATOM   2239  CG  ARG C  25      20.673  13.417  24.093  1.00 54.37           C  
ATOM   2240  CD  ARG C  25      21.556  14.202  25.096  1.00 61.57           C  
ATOM   2241  NE  ARG C  25      21.847  15.596  24.725  1.00 64.03           N  
ATOM   2242  CZ  ARG C  25      22.714  15.987  23.778  1.00 68.22           C  
ATOM   2243  NH1 ARG C  25      23.397  15.109  23.032  1.00 68.05           N  
ATOM   2244  NH2 ARG C  25      22.899  17.285  23.555  1.00 62.36           N  
ATOM   2245  N   ALA C  26      16.582  14.647  21.961  1.00 43.67           N  
ATOM   2246  CA  ALA C  26      15.554  15.680  21.797  1.00 43.25           C  
ATOM   2247  C   ALA C  26      15.982  17.042  22.390  1.00 43.59           C  
ATOM   2248  O   ALA C  26      15.193  17.724  22.966  1.00 42.96           O  
ATOM   2249  CB  ALA C  26      14.223  15.218  22.403  1.00 37.80           C  
ATOM   2250  N   ASP C  27      17.230  17.421  22.190  1.00 44.78           N  
ATOM   2251  CA  ASP C  27      17.806  18.627  22.742  1.00 43.88           C  
ATOM   2252  C   ASP C  27      17.845  19.669  21.625  1.00 43.75           C  
ATOM   2253  O   ASP C  27      18.780  19.717  20.843  1.00 45.30           O  
ATOM   2254  CB  ASP C  27      19.215  18.310  23.291  1.00 42.87           C  
ATOM   2255  CG  ASP C  27      19.942  19.535  23.849  1.00 46.26           C  
ATOM   2256  OD1 ASP C  27      19.537  20.685  23.569  1.00 48.14           O  
ATOM   2257  OD2 ASP C  27      20.951  19.345  24.560  1.00 44.99           O  
ATOM   2258  N   ILE C  28      16.845  20.538  21.593  1.00 43.89           N  
ATOM   2259  CA  ILE C  28      16.645  21.454  20.482  1.00 41.54           C  
ATOM   2260  C   ILE C  28      17.756  22.513  20.350  1.00 42.46           C  
ATOM   2261  O   ILE C  28      18.231  22.729  19.245  1.00 44.72           O  
ATOM   2262  CB  ILE C  28      15.225  22.104  20.518  1.00 43.49           C  
ATOM   2263  CG1 ILE C  28      14.135  21.015  20.649  1.00 42.06           C  
ATOM   2264  CG2 ILE C  28      14.985  22.963  19.270  1.00 40.06           C  
ATOM   2265  CD1 ILE C  28      12.742  21.514  20.889  1.00 32.77           C  
ATOM   2266  N   PRO C  29      18.180  23.181  21.446  1.00 41.72           N  
ATOM   2267  CA  PRO C  29      19.312  24.118  21.269  1.00 42.43           C  
ATOM   2268  C   PRO C  29      20.607  23.477  20.783  1.00 42.28           C  
ATOM   2269  O   PRO C  29      21.333  24.105  20.008  1.00 42.89           O  
ATOM   2270  CB  PRO C  29      19.502  24.736  22.670  1.00 42.44           C  
ATOM   2271  CG  PRO C  29      18.166  24.549  23.349  1.00 39.98           C  
ATOM   2272  CD  PRO C  29      17.647  23.224  22.818  1.00 41.11           C  
ATOM   2273  N   ALA C  30      20.893  22.252  21.228  1.00 42.85           N  
ATOM   2274  CA  ALA C  30      22.063  21.507  20.749  1.00 44.25           C  
ATOM   2275  C   ALA C  30      21.889  21.098  19.275  1.00 43.89           C  
ATOM   2276  O   ALA C  30      22.855  21.072  18.512  1.00 44.81           O  
ATOM   2277  CB  ALA C  30      22.347  20.261  21.643  1.00 41.53           C  
ATOM   2278  N   VAL C  31      20.663  20.768  18.882  1.00 43.86           N  
ATOM   2279  CA  VAL C  31      20.356  20.502  17.471  1.00 45.24           C  
ATOM   2280  C   VAL C  31      20.587  21.761  16.601  1.00 46.40           C  
ATOM   2281  O   VAL C  31      21.332  21.709  15.622  1.00 46.54           O  
ATOM   2282  CB  VAL C  31      18.907  19.917  17.285  1.00 44.29           C  
ATOM   2283  CG1 VAL C  31      18.500  19.916  15.833  1.00 36.73           C  
ATOM   2284  CG2 VAL C  31      18.851  18.512  17.840  1.00 42.43           C  
ATOM   2285  N   ILE C  32      19.974  22.882  16.985  1.00 46.43           N  
ATOM   2286  CA  ILE C  32      20.107  24.144  16.258  1.00 47.54           C  
ATOM   2287  C   ILE C  32      21.560  24.557  16.116  1.00 47.75           C  
ATOM   2288  O   ILE C  32      21.971  25.004  15.049  1.00 50.23           O  
ATOM   2289  CB  ILE C  32      19.306  25.286  16.952  1.00 50.38           C  
ATOM   2290  CG1 ILE C  32      17.798  25.071  16.786  1.00 51.43           C  
ATOM   2291  CG2 ILE C  32      19.699  26.677  16.430  1.00 50.51           C  
ATOM   2292  CD1 ILE C  32      17.418  24.489  15.462  1.00 49.47           C  
ATOM   2293  N   ALA C  33      22.340  24.375  17.175  1.00 47.67           N  
ATOM   2294  CA  ALA C  33      23.728  24.834  17.208  1.00 46.42           C  
ATOM   2295  C   ALA C  33      24.630  24.061  16.264  1.00 45.84           C  
ATOM   2296  O   ALA C  33      25.716  24.530  15.958  1.00 47.04           O  
ATOM   2297  CB  ALA C  33      24.292  24.807  18.662  1.00 43.70           C  
ATOM   2298  N   THR C  34      24.183  22.900  15.776  1.00 46.67           N  
ATOM   2299  CA  THR C  34      24.957  22.139  14.794  1.00 46.62           C  
ATOM   2300  C   THR C  34      24.855  22.681  13.379  1.00 47.00           C  
ATOM   2301  O   THR C  34      25.611  22.238  12.515  1.00 48.23           O  
ATOM   2302  CB  THR C  34      24.556  20.614  14.711  1.00 49.28           C  
ATOM   2303  OG1 THR C  34      23.182  20.492  14.329  1.00 47.22           O  
ATOM   2304  CG2 THR C  34      24.840  19.873  16.008  1.00 38.73           C  
ATOM   2305  N   TYR C  35      23.922  23.605  13.132  1.00 47.43           N  
ATOM   2306  CA  TYR C  35      23.672  24.143  11.799  1.00 45.86           C  
ATOM   2307  C   TYR C  35      24.364  25.491  11.603  1.00 47.17           C  
ATOM   2308  O   TYR C  35      24.525  26.271  12.552  1.00 47.80           O  
ATOM   2309  CB  TYR C  35      22.181  24.361  11.588  1.00 46.09           C  
ATOM   2310  CG  TYR C  35      21.314  23.159  11.239  1.00 47.67           C  
ATOM   2311  CD1 TYR C  35      21.071  22.810   9.914  1.00 43.74           C  
ATOM   2312  CD2 TYR C  35      20.661  22.437  12.233  1.00 44.60           C  
ATOM   2313  CE1 TYR C  35      20.236  21.737   9.590  1.00 47.38           C  
ATOM   2314  CE2 TYR C  35      19.837  21.373  11.930  1.00 43.54           C  
ATOM   2315  CZ  TYR C  35      19.619  21.020  10.612  1.00 48.00           C  
ATOM   2316  OH  TYR C  35      18.790  19.952  10.319  1.00 44.67           O  
ATOM   2317  N   THR C  36      24.723  25.788  10.353  1.00 47.50           N  
ATOM   2318  CA  THR C  36      25.110  27.146   9.956  1.00 46.27           C  
ATOM   2319  C   THR C  36      23.922  28.082  10.209  1.00 48.10           C  
ATOM   2320  O   THR C  36      22.799  27.624  10.399  1.00 50.35           O  
ATOM   2321  CB  THR C  36      25.487  27.214   8.462  1.00 45.69           C  
ATOM   2322  OG1 THR C  36      24.349  26.828   7.685  1.00 41.90           O  
ATOM   2323  CG2 THR C  36      26.679  26.290   8.123  1.00 37.26           C  
ATOM   2324  N   ASP C  37      24.154  29.388  10.182  1.00 49.26           N  
ATOM   2325  CA  ASP C  37      23.076  30.338  10.439  1.00 51.71           C  
ATOM   2326  C   ASP C  37      22.012  30.328   9.362  1.00 51.83           C  
ATOM   2327  O   ASP C  37      20.844  30.626   9.618  1.00 52.81           O  
ATOM   2328  CB  ASP C  37      23.615  31.754  10.572  1.00 52.94           C  
ATOM   2329  CG  ASP C  37      24.473  31.939  11.808  1.00 57.76           C  
ATOM   2330  OD1 ASP C  37      24.342  31.139  12.773  1.00 59.40           O  
ATOM   2331  OD2 ASP C  37      25.281  32.895  11.799  1.00 62.58           O  
ATOM   2332  N   ASP C  38      22.408  29.978   8.152  1.00 52.20           N  
ATOM   2333  CA  ASP C  38      21.451  29.899   7.065  1.00 52.48           C  
ATOM   2334  C   ASP C  38      21.189  28.446   6.675  1.00 49.54           C  
ATOM   2335  O   ASP C  38      20.841  28.159   5.535  1.00 48.61           O  
ATOM   2336  CB  ASP C  38      21.934  30.748   5.885  1.00 54.19           C  
ATOM   2337  CG  ASP C  38      23.352  30.411   5.456  1.00 63.12           C  
ATOM   2338  OD1 ASP C  38      23.972  29.461   6.020  1.00 68.03           O  
ATOM   2339  OD2 ASP C  38      23.838  31.119   4.540  1.00 74.85           O  
ATOM   2340  N   GLY C  39      21.320  27.543   7.651  1.00 47.42           N  
ATOM   2341  CA  GLY C  39      21.142  26.128   7.418  1.00 46.60           C  
ATOM   2342  C   GLY C  39      19.741  25.769   6.988  1.00 47.18           C  
ATOM   2343  O   GLY C  39      18.792  26.478   7.341  1.00 47.08           O  
ATOM   2344  N   VAL C  40      19.615  24.671   6.222  1.00 46.90           N  
ATOM   2345  CA  VAL C  40      18.321  24.208   5.711  1.00 45.55           C  
ATOM   2346  C   VAL C  40      18.051  22.768   6.166  1.00 47.13           C  
ATOM   2347  O   VAL C  40      18.930  21.917   6.083  1.00 49.15           O  
ATOM   2348  CB  VAL C  40      18.236  24.321   4.169  1.00 45.15           C  
ATOM   2349  CG1 VAL C  40      16.793  24.033   3.654  1.00 42.06           C  
ATOM   2350  CG2 VAL C  40      18.651  25.698   3.747  1.00 41.14           C  
ATOM   2351  N   LEU C  41      16.838  22.524   6.669  1.00 46.72           N  
ATOM   2352  CA  LEU C  41      16.325  21.192   6.961  1.00 44.58           C  
ATOM   2353  C   LEU C  41      15.248  20.854   5.944  1.00 45.31           C  
ATOM   2354  O   LEU C  41      14.320  21.624   5.713  1.00 44.48           O  
ATOM   2355  CB  LEU C  41      15.713  21.123   8.377  1.00 45.88           C  
ATOM   2356  CG  LEU C  41      14.720  19.980   8.692  1.00 42.71           C  
ATOM   2357  CD1 LEU C  41      15.460  18.657   8.778  1.00 42.02           C  
ATOM   2358  CD2 LEU C  41      13.923  20.213   9.953  1.00 38.94           C  
HETATM 2359  N   MSE C  42      15.378  19.678   5.354  1.00 47.57           N  
HETATM 2360  CA  MSE C  42      14.368  19.114   4.478  1.00 48.11           C  
HETATM 2361  C   MSE C  42      13.987  17.737   5.026  1.00 48.35           C  
HETATM 2362  O   MSE C  42      14.827  16.844   5.116  1.00 47.74           O  
HETATM 2363  CB  MSE C  42      14.925  18.962   3.085  1.00 47.31           C  
HETATM 2364  CG  MSE C  42      15.044  20.242   2.269  1.00 54.96           C  
HETATM 2365 SE   MSE C  42      16.372  20.003   0.831  0.75 55.23          SE  
HETATM 2366  CE  MSE C  42      17.928  20.280   1.809  1.00 36.58           C  
ATOM   2367  N   GLY C  43      12.719  17.584   5.379  1.00 49.17           N  
ATOM   2368  CA  GLY C  43      12.215  16.407   6.079  1.00 51.83           C  
ATOM   2369  C   GLY C  43      10.751  16.168   5.762  1.00 53.11           C  
ATOM   2370  O   GLY C  43      10.079  17.059   5.262  1.00 50.36           O  
ATOM   2371  N   PRO C  44      10.250  14.954   6.056  1.00 57.64           N  
ATOM   2372  CA  PRO C  44       8.950  14.563   5.493  1.00 56.54           C  
ATOM   2373  C   PRO C  44       7.812  15.352   6.084  1.00 54.17           C  
ATOM   2374  O   PRO C  44       7.871  15.711   7.251  1.00 56.62           O  
ATOM   2375  CB  PRO C  44       8.834  13.070   5.853  1.00 57.36           C  
ATOM   2376  CG  PRO C  44      10.232  12.644   6.267  1.00 59.66           C  
ATOM   2377  CD  PRO C  44      10.813  13.878   6.902  1.00 58.18           C  
ATOM   2378  N   GLY C  45       6.813  15.663   5.264  1.00 52.14           N  
ATOM   2379  CA  GLY C  45       5.596  16.316   5.727  1.00 51.15           C  
ATOM   2380  C   GLY C  45       5.683  17.824   5.896  1.00 51.04           C  
ATOM   2381  O   GLY C  45       4.734  18.454   6.331  1.00 50.53           O  
ATOM   2382  N   ARG C  46       6.822  18.414   5.571  1.00 52.51           N  
ATOM   2383  CA  ARG C  46       7.041  19.831   5.837  1.00 54.49           C  
ATOM   2384  C   ARG C  46       7.872  20.422   4.714  1.00 53.23           C  
ATOM   2385  O   ARG C  46       8.762  19.749   4.177  1.00 53.24           O  
ATOM   2386  CB  ARG C  46       7.810  20.022   7.147  1.00 54.93           C  
ATOM   2387  CG  ARG C  46       7.109  19.502   8.383  1.00 60.35           C  
ATOM   2388  CD  ARG C  46       8.090  19.350   9.534  1.00 65.13           C  
ATOM   2389  NE  ARG C  46       7.516  18.629  10.673  1.00 62.67           N  
ATOM   2390  CZ  ARG C  46       6.724  19.172  11.590  1.00 61.66           C  
ATOM   2391  NH1 ARG C  46       6.389  20.456  11.512  1.00 64.27           N  
ATOM   2392  NH2 ARG C  46       6.267  18.425  12.593  1.00 59.70           N  
ATOM   2393  N   PRO C  47       7.580  21.680   4.345  1.00 51.31           N  
ATOM   2394  CA  PRO C  47       8.465  22.380   3.414  1.00 50.20           C  
ATOM   2395  C   PRO C  47       9.780  22.723   4.103  1.00 47.95           C  
ATOM   2396  O   PRO C  47       9.836  22.693   5.325  1.00 49.68           O  
ATOM   2397  CB  PRO C  47       7.679  23.644   3.048  1.00 49.41           C  
ATOM   2398  CG  PRO C  47       6.716  23.843   4.146  1.00 49.75           C  
ATOM   2399  CD  PRO C  47       6.423  22.495   4.745  1.00 50.25           C  
ATOM   2400  N   ALA C  48      10.807  23.046   3.318  1.00 44.08           N  
ATOM   2401  CA  ALA C  48      12.134  23.337   3.837  1.00 43.30           C  
ATOM   2402  C   ALA C  48      12.094  24.425   4.897  1.00 42.97           C  
ATOM   2403  O   ALA C  48      11.391  25.407   4.743  1.00 44.36           O  
ATOM   2404  CB  ALA C  48      13.068  23.734   2.703  1.00 42.80           C  
ATOM   2405  N   ALA C  49      12.809  24.201   5.994  1.00 43.26           N  
ATOM   2406  CA  ALA C  49      12.965  25.176   7.062  1.00 42.43           C  
ATOM   2407  C   ALA C  49      14.307  25.838   6.813  1.00 43.78           C  
ATOM   2408  O   ALA C  49      15.340  25.172   6.821  1.00 44.66           O  
ATOM   2409  CB  ALA C  49      12.937  24.477   8.432  1.00 41.47           C  
ATOM   2410  N   VAL C  50      14.293  27.136   6.544  1.00 46.13           N  
ATOM   2411  CA  VAL C  50      15.507  27.864   6.171  1.00 46.74           C  
ATOM   2412  C   VAL C  50      15.889  28.824   7.293  1.00 46.74           C  
ATOM   2413  O   VAL C  50      15.132  29.733   7.612  1.00 47.97           O  
ATOM   2414  CB  VAL C  50      15.304  28.651   4.845  1.00 46.25           C  
ATOM   2415  CG1 VAL C  50      16.590  29.422   4.464  1.00 43.09           C  
ATOM   2416  CG2 VAL C  50      14.873  27.702   3.714  1.00 42.01           C  
ATOM   2417  N   GLY C  51      17.054  28.617   7.889  1.00 47.20           N  
ATOM   2418  CA  GLY C  51      17.557  29.504   8.939  1.00 47.75           C  
ATOM   2419  C   GLY C  51      17.211  28.988  10.324  1.00 48.94           C  
ATOM   2420  O   GLY C  51      16.263  28.228  10.479  1.00 50.41           O  
ATOM   2421  N   LYS C  52      17.962  29.410  11.335  1.00 48.84           N  
ATOM   2422  CA  LYS C  52      17.804  28.864  12.694  1.00 50.71           C  
ATOM   2423  C   LYS C  52      16.427  29.081  13.356  1.00 52.02           C  
ATOM   2424  O   LYS C  52      15.951  28.221  14.095  1.00 53.14           O  
ATOM   2425  CB  LYS C  52      18.941  29.358  13.603  1.00 50.76           C  
ATOM   2426  CG  LYS C  52      20.236  28.548  13.381  1.00 53.18           C  
ATOM   2427  CD  LYS C  52      21.380  28.988  14.278  1.00 51.21           C  
ATOM   2428  CE  LYS C  52      22.602  28.197  13.954  1.00 52.63           C  
ATOM   2429  NZ  LYS C  52      23.741  28.569  14.804  1.00 52.05           N  
ATOM   2430  N   ASP C  53      15.788  30.215  13.094  1.00 51.27           N  
ATOM   2431  CA  ASP C  53      14.455  30.462  13.619  1.00 51.20           C  
ATOM   2432  C   ASP C  53      13.430  29.441  13.096  1.00 50.78           C  
ATOM   2433  O   ASP C  53      12.647  28.885  13.886  1.00 50.12           O  
ATOM   2434  CB  ASP C  53      14.003  31.893  13.285  1.00 51.50           C  
ATOM   2435  CG  ASP C  53      14.628  32.943  14.192  1.00 53.97           C  
ATOM   2436  OD1 ASP C  53      15.421  32.607  15.105  1.00 54.22           O  
ATOM   2437  OD2 ASP C  53      14.297  34.125  13.996  1.00 58.98           O  
ATOM   2438  N   GLU C  54      13.427  29.221  11.775  1.00 48.00           N  
ATOM   2439  CA  GLU C  54      12.548  28.236  11.158  1.00 47.53           C  
ATOM   2440  C   GLU C  54      12.906  26.808  11.582  1.00 47.84           C  
ATOM   2441  O   GLU C  54      12.014  25.996  11.835  1.00 47.86           O  
ATOM   2442  CB  GLU C  54      12.592  28.346   9.630  1.00 48.62           C  
ATOM   2443  CG  GLU C  54      11.782  29.493   9.070  1.00 46.04           C  
ATOM   2444  CD  GLU C  54      11.676  29.500   7.541  1.00 51.08           C  
ATOM   2445  OE1 GLU C  54      11.846  28.443   6.884  1.00 46.10           O  
ATOM   2446  OE2 GLU C  54      11.385  30.592   6.997  1.00 50.37           O  
ATOM   2447  N   LEU C  55      14.208  26.513  11.641  1.00 47.59           N  
ATOM   2448  CA  LEU C  55      14.719  25.211  12.074  1.00 46.93           C  
ATOM   2449  C   LEU C  55      14.231  24.840  13.453  1.00 46.70           C  
ATOM   2450  O   LEU C  55      13.802  23.718  13.674  1.00 47.21           O  
ATOM   2451  CB  LEU C  55      16.258  25.213  12.122  1.00 48.83           C  
ATOM   2452  CG  LEU C  55      17.071  25.100  10.835  1.00 46.35           C  
ATOM   2453  CD1 LEU C  55      18.549  25.257  11.156  1.00 43.30           C  
ATOM   2454  CD2 LEU C  55      16.760  23.764  10.191  1.00 42.99           C  
ATOM   2455  N   ALA C  56      14.360  25.789  14.379  1.00 47.80           N  
ATOM   2456  CA  ALA C  56      13.942  25.659  15.782  1.00 47.61           C  
ATOM   2457  C   ALA C  56      12.439  25.418  15.906  1.00 48.12           C  
ATOM   2458  O   ALA C  56      12.015  24.533  16.651  1.00 48.52           O  
ATOM   2459  CB  ALA C  56      14.341  26.925  16.570  1.00 45.15           C  
ATOM   2460  N   GLU C  57      11.641  26.201  15.181  1.00 48.33           N  
ATOM   2461  CA  GLU C  57      10.189  26.011  15.184  1.00 49.85           C  
ATOM   2462  C   GLU C  57       9.805  24.619  14.695  1.00 48.19           C  
ATOM   2463  O   GLU C  57       8.907  24.025  15.269  1.00 49.81           O  
ATOM   2464  CB  GLU C  57       9.437  27.092  14.372  1.00 51.08           C  
ATOM   2465  CG  GLU C  57       9.385  28.534  15.009  1.00 61.86           C  
ATOM   2466  CD  GLU C  57       8.656  28.635  16.378  1.00 71.61           C  
ATOM   2467  OE1 GLU C  57       7.953  27.678  16.766  1.00 82.07           O  
ATOM   2468  OE2 GLU C  57       8.779  29.683  17.068  1.00 74.95           O  
ATOM   2469  N   VAL C  58      10.483  24.084  13.674  1.00 46.95           N  
ATOM   2470  CA  VAL C  58      10.135  22.748  13.151  1.00 44.59           C  
ATOM   2471  C   VAL C  58      10.534  21.650  14.136  1.00 44.76           C  
ATOM   2472  O   VAL C  58       9.764  20.721  14.391  1.00 45.78           O  
ATOM   2473  CB  VAL C  58      10.759  22.441  11.741  1.00 45.04           C  
ATOM   2474  CG1 VAL C  58      10.561  20.964  11.355  1.00 38.92           C  
ATOM   2475  CG2 VAL C  58      10.157  23.329  10.661  1.00 38.04           C  
ATOM   2476  N   TYR C  59      11.728  21.748  14.707  1.00 44.86           N  
ATOM   2477  CA  TYR C  59      12.178  20.718  15.651  1.00 44.40           C  
ATOM   2478  C   TYR C  59      11.260  20.671  16.870  1.00 44.83           C  
ATOM   2479  O   TYR C  59      10.881  19.586  17.320  1.00 45.15           O  
ATOM   2480  CB  TYR C  59      13.658  20.901  16.026  1.00 44.16           C  
ATOM   2481  CG  TYR C  59      14.593  20.334  14.978  1.00 45.59           C  
ATOM   2482  CD1 TYR C  59      14.645  18.959  14.747  1.00 46.04           C  
ATOM   2483  CD2 TYR C  59      15.408  21.158  14.199  1.00 44.56           C  
ATOM   2484  CE1 TYR C  59      15.485  18.408  13.772  1.00 46.21           C  
ATOM   2485  CE2 TYR C  59      16.270  20.606  13.225  1.00 43.04           C  
ATOM   2486  CZ  TYR C  59      16.285  19.226  13.005  1.00 46.23           C  
ATOM   2487  OH  TYR C  59      17.113  18.645  12.051  1.00 47.58           O  
ATOM   2488  N   LEU C  60      10.854  21.841  17.359  1.00 44.53           N  
ATOM   2489  CA  LEU C  60       9.969  21.921  18.500  1.00 46.06           C  
ATOM   2490  C   LEU C  60       8.641  21.255  18.220  1.00 45.33           C  
ATOM   2491  O   LEU C  60       8.078  20.595  19.081  1.00 46.18           O  
ATOM   2492  CB  LEU C  60       9.757  23.384  18.909  1.00 48.16           C  
ATOM   2493  CG  LEU C  60       9.025  23.668  20.226  1.00 53.76           C  
ATOM   2494  CD1 LEU C  60       9.366  22.634  21.306  1.00 54.50           C  
ATOM   2495  CD2 LEU C  60       9.334  25.088  20.696  1.00 57.61           C  
ATOM   2496  N   SER C  61       8.151  21.415  17.003  1.00 46.17           N  
ATOM   2497  CA  SER C  61       6.924  20.763  16.580  1.00 45.61           C  
ATOM   2498  C   SER C  61       7.051  19.232  16.437  1.00 44.43           C  
ATOM   2499  O   SER C  61       6.126  18.485  16.772  1.00 43.98           O  
ATOM   2500  CB  SER C  61       6.456  21.383  15.279  1.00 45.55           C  
ATOM   2501  OG  SER C  61       5.458  20.577  14.706  1.00 51.43           O  
ATOM   2502  N   VAL C  62       8.183  18.772  15.919  1.00 45.33           N  
ATOM   2503  CA  VAL C  62       8.484  17.337  15.834  1.00 45.42           C  
ATOM   2504  C   VAL C  62       8.495  16.713  17.243  1.00 46.69           C  
ATOM   2505  O   VAL C  62       7.810  15.714  17.501  1.00 47.62           O  
ATOM   2506  CB  VAL C  62       9.821  17.098  15.083  1.00 47.35           C  
ATOM   2507  CG1 VAL C  62      10.272  15.655  15.186  1.00 45.48           C  
ATOM   2508  CG2 VAL C  62       9.688  17.518  13.602  1.00 43.80           C  
ATOM   2509  N   PHE C  63       9.218  17.332  18.175  1.00 47.02           N  
ATOM   2510  CA  PHE C  63       9.365  16.748  19.504  1.00 45.34           C  
ATOM   2511  C   PHE C  63       8.127  16.892  20.356  1.00 45.35           C  
ATOM   2512  O   PHE C  63       7.917  16.113  21.279  1.00 45.56           O  
ATOM   2513  CB  PHE C  63      10.571  17.317  20.206  1.00 44.58           C  
ATOM   2514  CG  PHE C  63      11.865  16.949  19.558  1.00 45.63           C  
ATOM   2515  CD1 PHE C  63      12.147  15.619  19.238  1.00 44.68           C  
ATOM   2516  CD2 PHE C  63      12.816  17.922  19.286  1.00 43.72           C  
ATOM   2517  CE1 PHE C  63      13.327  15.275  18.648  1.00 44.63           C  
ATOM   2518  CE2 PHE C  63      14.020  17.580  18.693  1.00 46.98           C  
ATOM   2519  CZ  PHE C  63      14.273  16.254  18.365  1.00 43.99           C  
ATOM   2520  N   GLU C  64       7.295  17.871  20.039  1.00 45.13           N  
ATOM   2521  CA  GLU C  64       5.980  17.977  20.668  1.00 44.56           C  
ATOM   2522  C   GLU C  64       5.040  16.850  20.239  1.00 45.03           C  
ATOM   2523  O   GLU C  64       4.212  16.403  21.024  1.00 45.66           O  
ATOM   2524  CB  GLU C  64       5.332  19.319  20.336  1.00 44.48           C  
ATOM   2525  CG  GLU C  64       5.740  20.452  21.255  1.00 46.00           C  
ATOM   2526  CD  GLU C  64       5.309  21.812  20.730  1.00 48.39           C  
ATOM   2527  OE1 GLU C  64       4.668  21.890  19.645  1.00 43.40           O  
ATOM   2528  OE2 GLU C  64       5.621  22.806  21.413  1.00 52.89           O  
ATOM   2529  N   THR C  65       5.165  16.405  18.994  1.00 46.57           N  
ATOM   2530  CA  THR C  65       4.247  15.432  18.420  1.00 47.16           C  
ATOM   2531  C   THR C  65       4.672  13.994  18.652  1.00 47.13           C  
ATOM   2532  O   THR C  65       3.848  13.137  18.998  1.00 48.72           O  
ATOM   2533  CB  THR C  65       4.157  15.638  16.917  1.00 48.88           C  
ATOM   2534  OG1 THR C  65       3.728  16.979  16.656  1.00 49.87           O  
ATOM   2535  CG2 THR C  65       3.187  14.638  16.300  1.00 48.27           C  
ATOM   2536  N   VAL C  66       5.960  13.743  18.455  1.00 46.43           N  
ATOM   2537  CA  VAL C  66       6.502  12.402  18.407  1.00 47.02           C  
ATOM   2538  C   VAL C  66       7.726  12.245  19.318  1.00 46.66           C  
ATOM   2539  O   VAL C  66       8.541  13.144  19.411  1.00 45.84           O  
ATOM   2540  CB  VAL C  66       6.924  12.071  16.943  1.00 48.89           C  
ATOM   2541  CG1 VAL C  66       7.768  10.826  16.897  1.00 48.71           C  
ATOM   2542  CG2 VAL C  66       5.703  11.928  16.043  1.00 46.33           C  
ATOM   2543  N   GLY C  67       7.829  11.105  20.000  1.00 47.81           N  
ATOM   2544  CA  GLY C  67       9.064  10.688  20.684  1.00 47.91           C  
ATOM   2545  C   GLY C  67       9.824   9.635  19.864  1.00 47.95           C  
ATOM   2546  O   GLY C  67       9.270   8.602  19.480  1.00 47.18           O  
ATOM   2547  N   PHE C  68      11.100   9.894  19.593  1.00 47.51           N  
ATOM   2548  CA  PHE C  68      11.932   8.961  18.824  1.00 46.96           C  
ATOM   2549  C   PHE C  68      12.870   8.177  19.724  1.00 46.02           C  
ATOM   2550  O   PHE C  68      13.445   8.719  20.654  1.00 46.92           O  
ATOM   2551  CB  PHE C  68      12.779   9.709  17.810  1.00 46.83           C  
ATOM   2552  CG  PHE C  68      11.987  10.439  16.777  1.00 48.39           C  
ATOM   2553  CD1 PHE C  68      11.689   9.842  15.569  1.00 50.73           C  
ATOM   2554  CD2 PHE C  68      11.566  11.740  17.003  1.00 51.31           C  
ATOM   2555  CE1 PHE C  68      10.979  10.526  14.595  1.00 53.88           C  
ATOM   2556  CE2 PHE C  68      10.849  12.436  16.035  1.00 53.25           C  
ATOM   2557  CZ  PHE C  68      10.558  11.830  14.828  1.00 50.83           C  
ATOM   2558  N   ASP C  69      13.025   6.895  19.435  1.00 45.83           N  
ATOM   2559  CA  ASP C  69      14.044   6.093  20.067  1.00 46.41           C  
ATOM   2560  C   ASP C  69      14.827   5.377  18.965  1.00 46.02           C  
ATOM   2561  O   ASP C  69      14.425   4.300  18.504  1.00 46.41           O  
ATOM   2562  CB  ASP C  69      13.404   5.104  21.047  1.00 45.88           C  
ATOM   2563  CG  ASP C  69      14.429   4.282  21.811  1.00 50.52           C  
ATOM   2564  OD1 ASP C  69      15.652   4.415  21.554  1.00 52.77           O  
ATOM   2565  OD2 ASP C  69      14.004   3.489  22.680  1.00 58.37           O  
HETATM 2566  N   MSE C  70      15.958   5.959  18.571  1.00 45.42           N  
HETATM 2567  CA  MSE C  70      16.623   5.553  17.336  1.00 45.49           C  
HETATM 2568  C   MSE C  70      18.088   5.268  17.552  1.00 44.61           C  
HETATM 2569  O   MSE C  70      18.751   6.020  18.278  1.00 43.66           O  
HETATM 2570  CB  MSE C  70      16.547   6.697  16.326  1.00 46.60           C  
HETATM 2571  CG  MSE C  70      15.173   7.257  16.093  1.00 50.68           C  
HETATM 2572 SE   MSE C  70      14.174   6.193  14.879  0.75 49.35          SE  
HETATM 2573  CE  MSE C  70      14.438   7.227  13.351  1.00 33.15           C  
ATOM   2574  N   ALA C  71      18.586   4.208  16.903  1.00 41.82           N  
ATOM   2575  CA  ALA C  71      20.021   4.003  16.705  1.00 42.03           C  
ATOM   2576  C   ALA C  71      20.415   4.553  15.324  1.00 44.44           C  
ATOM   2577  O   ALA C  71      19.619   4.514  14.386  1.00 44.24           O  
ATOM   2578  CB  ALA C  71      20.369   2.543  16.797  1.00 37.67           C  
ATOM   2579  N   TYR C  72      21.623   5.092  15.218  1.00 45.15           N  
ATOM   2580  CA  TYR C  72      22.125   5.644  13.960  1.00 46.95           C  
ATOM   2581  C   TYR C  72      23.273   4.787  13.450  1.00 46.80           C  
ATOM   2582  O   TYR C  72      23.858   4.013  14.186  1.00 48.63           O  
ATOM   2583  CB  TYR C  72      22.595   7.090  14.107  1.00 46.61           C  
ATOM   2584  CG  TYR C  72      23.864   7.237  14.902  1.00 47.77           C  
ATOM   2585  CD1 TYR C  72      25.117   7.015  14.323  1.00 48.96           C  
ATOM   2586  CD2 TYR C  72      23.819   7.630  16.227  1.00 47.04           C  
ATOM   2587  CE1 TYR C  72      26.279   7.140  15.067  1.00 46.04           C  
ATOM   2588  CE2 TYR C  72      24.958   7.772  16.965  1.00 45.84           C  
ATOM   2589  CZ  TYR C  72      26.197   7.522  16.397  1.00 50.97           C  
ATOM   2590  OH  TYR C  72      27.338   7.644  17.192  1.00 51.77           O  
ATOM   2591  N   GLU C  73      23.582   4.947  12.180  1.00 47.56           N  
ATOM   2592  CA  GLU C  73      24.621   4.191  11.529  1.00 48.78           C  
ATOM   2593  C   GLU C  73      25.218   5.086  10.436  1.00 47.63           C  
ATOM   2594  O   GLU C  73      24.466   5.617   9.618  1.00 47.38           O  
ATOM   2595  CB  GLU C  73      23.953   2.985  10.939  1.00 49.89           C  
ATOM   2596  CG  GLU C  73      24.836   1.901  10.528  1.00 63.41           C  
ATOM   2597  CD  GLU C  73      24.062   0.824   9.793  1.00 77.02           C  
ATOM   2598  OE1 GLU C  73      23.006   0.401  10.338  1.00 76.15           O  
ATOM   2599  OE2 GLU C  73      24.512   0.423   8.677  1.00 80.88           O  
ATOM   2600  N   ILE C  74      26.540   5.300  10.461  1.00 47.09           N  
ATOM   2601  CA  ILE C  74      27.232   6.137   9.461  1.00 45.83           C  
ATOM   2602  C   ILE C  74      27.583   5.314   8.215  1.00 46.26           C  
ATOM   2603  O   ILE C  74      28.222   4.267   8.303  1.00 48.55           O  
ATOM   2604  CB  ILE C  74      28.481   6.796  10.039  1.00 45.81           C  
ATOM   2605  CG1 ILE C  74      28.129   7.627  11.288  1.00 46.57           C  
ATOM   2606  CG2 ILE C  74      29.157   7.693   9.014  1.00 39.26           C  
ATOM   2607  CD1 ILE C  74      27.173   8.860  11.034  1.00 38.88           C  
ATOM   2608  N   LYS C  75      27.116   5.771   7.056  1.00 45.64           N  
ATOM   2609  CA  LYS C  75      27.212   5.005   5.815  1.00 44.15           C  
ATOM   2610  C   LYS C  75      28.357   5.511   4.956  1.00 44.42           C  
ATOM   2611  O   LYS C  75      29.010   4.729   4.306  1.00 44.89           O  
ATOM   2612  CB  LYS C  75      25.913   5.096   5.017  1.00 44.68           C  
ATOM   2613  CG  LYS C  75      24.689   4.542   5.713  1.00 45.18           C  
ATOM   2614  CD  LYS C  75      24.772   3.061   5.856  1.00 46.99           C  
ATOM   2615  CE  LYS C  75      23.480   2.519   6.392  1.00 55.18           C  
ATOM   2616  NZ  LYS C  75      23.461   1.054   6.228  1.00 58.16           N  
ATOM   2617  N   GLU C  76      28.590   6.821   4.931  1.00 46.60           N  
ATOM   2618  CA  GLU C  76      29.794   7.356   4.291  1.00 45.54           C  
ATOM   2619  C   GLU C  76      30.142   8.756   4.756  1.00 45.04           C  
ATOM   2620  O   GLU C  76      29.273   9.528   5.119  1.00 48.80           O  
ATOM   2621  CB  GLU C  76      29.683   7.321   2.756  1.00 46.15           C  
ATOM   2622  CG  GLU C  76      28.778   8.333   2.177  1.00 48.45           C  
ATOM   2623  CD  GLU C  76      28.508   8.143   0.693  1.00 55.38           C  
ATOM   2624  OE1 GLU C  76      29.420   7.789  -0.089  1.00 52.88           O  
ATOM   2625  OE2 GLU C  76      27.354   8.384   0.310  1.00 53.87           O  
ATOM   2626  N   VAL C  77      31.438   9.058   4.727  1.00 45.27           N  
ATOM   2627  CA  VAL C  77      32.002  10.347   5.060  1.00 43.91           C  
ATOM   2628  C   VAL C  77      32.939  10.742   3.918  1.00 45.30           C  
ATOM   2629  O   VAL C  77      33.930  10.066   3.672  1.00 45.94           O  
ATOM   2630  CB  VAL C  77      32.814  10.282   6.372  1.00 44.59           C  
ATOM   2631  CG1 VAL C  77      33.327  11.682   6.774  1.00 39.93           C  
ATOM   2632  CG2 VAL C  77      31.992   9.609   7.459  1.00 39.68           C  
ATOM   2633  N   VAL C  78      32.610  11.830   3.210  1.00 46.28           N  
ATOM   2634  CA  VAL C  78      33.416  12.307   2.092  1.00 43.03           C  
ATOM   2635  C   VAL C  78      33.666  13.807   2.236  1.00 44.07           C  
ATOM   2636  O   VAL C  78      32.737  14.595   2.429  1.00 44.76           O  
ATOM   2637  CB  VAL C  78      32.756  11.965   0.734  1.00 43.23           C  
ATOM   2638  CG1 VAL C  78      33.599  12.466  -0.448  1.00 39.64           C  
ATOM   2639  CG2 VAL C  78      32.560  10.471   0.619  1.00 39.22           C  
ATOM   2640  N   GLN C  79      34.939  14.181   2.203  1.00 45.29           N  
ATOM   2641  CA  GLN C  79      35.347  15.577   2.141  1.00 44.75           C  
ATOM   2642  C   GLN C  79      35.564  15.900   0.692  1.00 43.96           C  
ATOM   2643  O   GLN C  79      36.312  15.201   0.017  1.00 44.63           O  
ATOM   2644  CB  GLN C  79      36.653  15.814   2.920  1.00 44.25           C  
ATOM   2645  CG  GLN C  79      37.060  17.298   2.936  1.00 46.85           C  
ATOM   2646  CD  GLN C  79      38.154  17.618   3.906  1.00 44.44           C  
ATOM   2647  OE1 GLN C  79      38.799  16.729   4.455  1.00 53.30           O  
ATOM   2648  NE2 GLN C  79      38.382  18.898   4.119  1.00 43.57           N  
ATOM   2649  N   THR C  80      34.924  16.954   0.197  1.00 43.58           N  
ATOM   2650  CA  THR C  80      35.001  17.271  -1.246  1.00 42.60           C  
ATOM   2651  C   THR C  80      35.987  18.423  -1.582  1.00 42.03           C  
ATOM   2652  O   THR C  80      36.534  18.501  -2.690  1.00 42.49           O  
ATOM   2653  CB  THR C  80      33.573  17.531  -1.804  1.00 41.80           C  
ATOM   2654  OG1 THR C  80      32.946  18.569  -1.058  1.00 42.13           O  
ATOM   2655  CG2 THR C  80      32.710  16.299  -1.645  1.00 41.39           C  
ATOM   2656  N   SER C  81      36.180  19.317  -0.621  1.00 42.67           N  
ATOM   2657  CA  SER C  81      37.123  20.418  -0.724  1.00 42.93           C  
ATOM   2658  C   SER C  81      37.535  20.778   0.694  1.00 43.26           C  
ATOM   2659  O   SER C  81      37.040  20.183   1.658  1.00 44.49           O  
ATOM   2660  CB  SER C  81      36.521  21.636  -1.467  1.00 44.90           C  
ATOM   2661  OG  SER C  81      35.458  22.273  -0.750  1.00 45.24           O  
ATOM   2662  N   ALA C  82      38.455  21.730   0.820  1.00 43.54           N  
ATOM   2663  CA  ALA C  82      38.981  22.140   2.123  1.00 43.70           C  
ATOM   2664  C   ALA C  82      37.864  22.415   3.129  1.00 43.42           C  
ATOM   2665  O   ALA C  82      37.972  22.028   4.289  1.00 45.22           O  
ATOM   2666  CB  ALA C  82      39.891  23.373   1.970  1.00 39.74           C  
ATOM   2667  N   ASP C  83      36.791  23.058   2.659  1.00 44.04           N  
ATOM   2668  CA  ASP C  83      35.708  23.567   3.515  1.00 43.20           C  
ATOM   2669  C   ASP C  83      34.346  22.912   3.334  1.00 41.18           C  
ATOM   2670  O   ASP C  83      33.367  23.402   3.869  1.00 40.79           O  
ATOM   2671  CB  ASP C  83      35.541  25.069   3.266  1.00 42.57           C  
ATOM   2672  CG  ASP C  83      36.694  25.869   3.788  1.00 43.39           C  
ATOM   2673  OD1 ASP C  83      37.325  25.431   4.779  1.00 47.78           O  
ATOM   2674  OD2 ASP C  83      36.965  26.943   3.214  1.00 45.52           O  
ATOM   2675  N   TRP C  84      34.273  21.828   2.568  1.00 42.52           N  
ATOM   2676  CA  TRP C  84      33.004  21.156   2.314  1.00 41.07           C  
ATOM   2677  C   TRP C  84      33.142  19.652   2.400  1.00 42.73           C  
ATOM   2678  O   TRP C  84      34.145  19.083   2.026  1.00 42.30           O  
ATOM   2679  CB  TRP C  84      32.465  21.545   0.948  1.00 41.96           C  
ATOM   2680  CG  TRP C  84      32.034  22.971   0.876  1.00 40.10           C  
ATOM   2681  CD1 TRP C  84      32.801  24.046   0.504  1.00 40.56           C  
ATOM   2682  CD2 TRP C  84      30.746  23.493   1.205  1.00 39.95           C  
ATOM   2683  NE1 TRP C  84      32.061  25.195   0.566  1.00 40.94           N  
ATOM   2684  CE2 TRP C  84      30.800  24.889   1.008  1.00 41.13           C  
ATOM   2685  CE3 TRP C  84      29.542  22.917   1.622  1.00 39.58           C  
ATOM   2686  CZ2 TRP C  84      29.690  25.714   1.206  1.00 42.78           C  
ATOM   2687  CZ3 TRP C  84      28.456  23.739   1.852  1.00 41.93           C  
ATOM   2688  CH2 TRP C  84      28.534  25.118   1.646  1.00 42.10           C  
ATOM   2689  N   ALA C  85      32.101  19.016   2.914  1.00 45.96           N  
ATOM   2690  CA  ALA C  85      32.052  17.576   3.069  1.00 45.25           C  
ATOM   2691  C   ALA C  85      30.579  17.137   3.062  1.00 46.54           C  
ATOM   2692  O   ALA C  85      29.668  17.961   3.166  1.00 46.55           O  
ATOM   2693  CB  ALA C  85      32.740  17.165   4.344  1.00 44.58           C  
ATOM   2694  N   PHE C  86      30.359  15.846   2.864  1.00 47.01           N  
ATOM   2695  CA  PHE C  86      29.054  15.240   3.091  1.00 45.54           C  
ATOM   2696  C   PHE C  86      29.169  13.936   3.891  1.00 44.35           C  
ATOM   2697  O   PHE C  86      30.166  13.221   3.835  1.00 42.05           O  
ATOM   2698  CB  PHE C  86      28.229  15.054   1.792  1.00 45.16           C  
ATOM   2699  CG  PHE C  86      28.775  14.029   0.819  1.00 41.01           C  
ATOM   2700  CD1 PHE C  86      28.396  12.697   0.903  1.00 43.83           C  
ATOM   2701  CD2 PHE C  86      29.607  14.408  -0.217  1.00 43.95           C  
ATOM   2702  CE1 PHE C  86      28.868  11.766   0.005  1.00 44.41           C  
ATOM   2703  CE2 PHE C  86      30.087  13.466  -1.139  1.00 46.09           C  
ATOM   2704  CZ  PHE C  86      29.706  12.150  -1.037  1.00 41.53           C  
ATOM   2705  N   VAL C  87      28.132  13.697   4.671  1.00 46.49           N  
ATOM   2706  CA  VAL C  87      27.950  12.478   5.416  1.00 45.94           C  
ATOM   2707  C   VAL C  87      26.603  11.878   5.056  1.00 46.40           C  
ATOM   2708  O   VAL C  87      25.602  12.574   4.876  1.00 45.93           O  
ATOM   2709  CB  VAL C  87      28.026  12.729   6.913  1.00 44.34           C  
ATOM   2710  CG1 VAL C  87      27.583  11.467   7.722  1.00 41.35           C  
ATOM   2711  CG2 VAL C  87      29.443  13.155   7.270  1.00 39.92           C  
ATOM   2712  N   ARG C  88      26.596  10.565   4.923  1.00 47.21           N  
ATOM   2713  CA  ARG C  88      25.359   9.842   4.725  1.00 47.41           C  
ATOM   2714  C   ARG C  88      25.163   8.883   5.894  1.00 45.07           C  
ATOM   2715  O   ARG C  88      26.090   8.204   6.316  1.00 44.97           O  
ATOM   2716  CB  ARG C  88      25.405   9.125   3.380  1.00 47.58           C  
ATOM   2717  CG  ARG C  88      24.093   8.571   2.950  1.00 52.90           C  
ATOM   2718  CD  ARG C  88      24.093   8.291   1.464  1.00 50.03           C  
ATOM   2719  NE  ARG C  88      25.025   7.241   1.044  1.00 44.05           N  
ATOM   2720  CZ  ARG C  88      24.844   5.936   1.212  1.00 43.60           C  
ATOM   2721  NH1 ARG C  88      23.775   5.455   1.822  1.00 52.02           N  
ATOM   2722  NH2 ARG C  88      25.750   5.094   0.750  1.00 46.33           N  
ATOM   2723  N   SER C  89      23.955   8.855   6.436  1.00 44.64           N  
ATOM   2724  CA  SER C  89      23.647   7.992   7.555  1.00 43.75           C  
ATOM   2725  C   SER C  89      22.258   7.359   7.432  1.00 43.57           C  
ATOM   2726  O   SER C  89      21.495   7.684   6.530  1.00 42.97           O  
ATOM   2727  CB  SER C  89      23.783   8.781   8.867  1.00 44.76           C  
ATOM   2728  OG  SER C  89      22.841   9.825   8.980  1.00 44.14           O  
ATOM   2729  N   ALA C  90      21.969   6.433   8.347  1.00 43.95           N  
ATOM   2730  CA  ALA C  90      20.660   5.773   8.484  1.00 42.83           C  
ATOM   2731  C   ALA C  90      20.334   5.654   9.982  1.00 43.79           C  
ATOM   2732  O   ALA C  90      21.235   5.461  10.794  1.00 42.92           O  
ATOM   2733  CB  ALA C  90      20.669   4.395   7.817  1.00 38.83           C  
ATOM   2734  N   THR C  91      19.057   5.823  10.337  1.00 45.11           N  
ATOM   2735  CA  THR C  91      18.572   5.625  11.698  1.00 44.90           C  
ATOM   2736  C   THR C  91      17.407   4.627  11.713  1.00 46.00           C  
ATOM   2737  O   THR C  91      16.647   4.541  10.758  1.00 47.28           O  
ATOM   2738  CB  THR C  91      18.101   6.943  12.333  1.00 45.70           C  
ATOM   2739  OG1 THR C  91      17.225   7.624  11.423  1.00 43.81           O  
ATOM   2740  CG2 THR C  91      19.298   7.859  12.702  1.00 44.79           C  
ATOM   2741  N   GLU C  92      17.286   3.853  12.780  1.00 45.56           N  
ATOM   2742  CA  GLU C  92      16.147   2.967  12.927  1.00 46.63           C  
ATOM   2743  C   GLU C  92      15.812   2.727  14.393  1.00 45.15           C  
ATOM   2744  O   GLU C  92      16.682   2.784  15.254  1.00 45.37           O  
ATOM   2745  CB  GLU C  92      16.347   1.652  12.171  1.00 47.61           C  
ATOM   2746  CG  GLU C  92      17.326   0.652  12.764  1.00 56.29           C  
ATOM   2747  CD  GLU C  92      17.301  -0.697  12.017  1.00 67.17           C  
ATOM   2748  OE1 GLU C  92      16.286  -1.427  12.141  1.00 73.03           O  
ATOM   2749  OE2 GLU C  92      18.291  -1.028  11.309  1.00 70.52           O  
ATOM   2750  N   GLY C  93      14.538   2.481  14.669  1.00 43.17           N  
ATOM   2751  CA  GLY C  93      14.094   2.312  16.037  1.00 42.92           C  
ATOM   2752  C   GLY C  93      12.604   2.478  16.103  1.00 42.96           C  
ATOM   2753  O   GLY C  93      11.901   1.982  15.240  1.00 41.66           O  
ATOM   2754  N   THR C  94      12.121   3.192  17.113  1.00 44.04           N  
ATOM   2755  CA  THR C  94      10.693   3.394  17.273  1.00 44.06           C  
ATOM   2756  C   THR C  94      10.321   4.890  17.279  1.00 45.33           C  
ATOM   2757  O   THR C  94      11.143   5.765  17.504  1.00 44.79           O  
ATOM   2758  CB  THR C  94      10.158   2.683  18.554  1.00 43.45           C  
ATOM   2759  OG1 THR C  94      10.798   3.224  19.707  1.00 44.20           O  
ATOM   2760  CG2 THR C  94      10.405   1.174  18.514  1.00 37.83           C  
ATOM   2761  N   GLU C  95       9.051   5.138  17.014  1.00 48.24           N  
ATOM   2762  CA  GLU C  95       8.424   6.448  17.019  1.00 48.80           C  
ATOM   2763  C   GLU C  95       7.174   6.262  17.888  1.00 48.88           C  
ATOM   2764  O   GLU C  95       6.388   5.353  17.626  1.00 47.34           O  
ATOM   2765  CB  GLU C  95       8.014   6.767  15.584  1.00 51.59           C  
ATOM   2766  CG  GLU C  95       7.985   8.216  15.176  1.00 56.55           C  
ATOM   2767  CD  GLU C  95       7.948   8.391  13.655  1.00 61.98           C  
ATOM   2768  OE1 GLU C  95       8.911   7.967  12.972  1.00 63.15           O  
ATOM   2769  OE2 GLU C  95       6.962   8.970  13.148  1.00 63.85           O  
ATOM   2770  N   THR C  96       7.015   7.058  18.946  1.00 49.80           N  
ATOM   2771  CA  THR C  96       5.766   7.069  19.734  1.00 49.56           C  
ATOM   2772  C   THR C  96       4.991   8.361  19.439  1.00 49.45           C  
ATOM   2773  O   THR C  96       5.567   9.446  19.471  1.00 50.53           O  
ATOM   2774  CB  THR C  96       6.040   6.961  21.253  1.00 49.64           C  
ATOM   2775  OG1 THR C  96       6.830   5.800  21.526  1.00 51.73           O  
ATOM   2776  CG2 THR C  96       4.750   6.854  22.028  1.00 48.33           C  
ATOM   2777  N   ASN C  97       3.700   8.244  19.119  1.00 49.51           N  
ATOM   2778  CA  ASN C  97       2.820   9.421  18.989  1.00 48.77           C  
ATOM   2779  C   ASN C  97       2.455   9.896  20.391  1.00 48.47           C  
ATOM   2780  O   ASN C  97       1.919   9.119  21.190  1.00 45.40           O  
ATOM   2781  CB  ASN C  97       1.546   9.084  18.214  1.00 47.29           C  
ATOM   2782  CG  ASN C  97       0.657  10.298  17.976  1.00 47.36           C  
ATOM   2783  OD1 ASN C  97      -0.291  10.563  18.729  1.00 51.87           O  
ATOM   2784  ND2 ASN C  97       0.953  11.038  16.927  1.00 45.09           N  
ATOM   2785  N   LYS C  98       2.760  11.153  20.703  1.00 48.37           N  
ATOM   2786  CA  LYS C  98       2.565  11.630  22.073  1.00 47.57           C  
ATOM   2787  C   LYS C  98       1.104  11.847  22.426  1.00 47.36           C  
ATOM   2788  O   LYS C  98       0.758  11.839  23.612  1.00 46.00           O  
ATOM   2789  CB  LYS C  98       3.382  12.886  22.341  1.00 47.15           C  
ATOM   2790  CG  LYS C  98       4.838  12.569  22.548  1.00 47.03           C  
ATOM   2791  CD  LYS C  98       5.652  13.804  22.722  1.00 47.45           C  
ATOM   2792  CE  LYS C  98       7.081  13.446  22.940  1.00 47.69           C  
ATOM   2793  NZ  LYS C  98       7.880  14.679  23.010  1.00 55.49           N  
ATOM   2794  N   ALA C  99       0.253  12.026  21.411  1.00 47.67           N  
ATOM   2795  CA  ALA C  99      -1.197  12.133  21.640  1.00 47.86           C  
ATOM   2796  C   ALA C  99      -1.761  10.765  21.989  1.00 48.05           C  
ATOM   2797  O   ALA C  99      -2.303  10.575  23.077  1.00 48.88           O  
ATOM   2798  CB  ALA C  99      -1.920  12.707  20.420  1.00 47.16           C  
ATOM   2799  N   THR C 100      -1.591   9.812  21.074  1.00 48.45           N  
ATOM   2800  CA  THR C 100      -2.240   8.497  21.160  1.00 47.81           C  
ATOM   2801  C   THR C 100      -1.457   7.442  21.964  1.00 47.57           C  
ATOM   2802  O   THR C 100      -2.037   6.477  22.450  1.00 47.54           O  
ATOM   2803  CB  THR C 100      -2.507   7.946  19.749  1.00 48.06           C  
ATOM   2804  OG1 THR C 100      -1.261   7.642  19.112  1.00 46.55           O  
ATOM   2805  CG2 THR C 100      -3.266   8.968  18.904  1.00 47.60           C  
ATOM   2806  N   GLY C 101      -0.146   7.618  22.090  1.00 47.68           N  
ATOM   2807  CA  GLY C 101       0.711   6.667  22.809  1.00 46.90           C  
ATOM   2808  C   GLY C 101       1.188   5.497  21.961  1.00 46.20           C  
ATOM   2809  O   GLY C 101       1.941   4.656  22.446  1.00 44.91           O  
ATOM   2810  N   VAL C 102       0.767   5.463  20.695  1.00 46.10           N  
ATOM   2811  CA  VAL C 102       1.069   4.367  19.765  1.00 46.25           C  
ATOM   2812  C   VAL C 102       2.551   4.329  19.328  1.00 47.00           C  
ATOM   2813  O   VAL C 102       3.056   5.265  18.698  1.00 47.21           O  
ATOM   2814  CB  VAL C 102       0.144   4.447  18.505  1.00 46.26           C  
ATOM   2815  CG1 VAL C 102       0.653   3.563  17.387  1.00 45.91           C  
ATOM   2816  CG2 VAL C 102      -1.280   4.065  18.865  1.00 42.25           C  
ATOM   2817  N   VAL C 103       3.231   3.232  19.662  1.00 46.98           N  
ATOM   2818  CA  VAL C 103       4.622   3.002  19.264  1.00 45.77           C  
ATOM   2819  C   VAL C 103       4.670   2.236  17.944  1.00 46.15           C  
ATOM   2820  O   VAL C 103       4.071   1.177  17.814  1.00 45.16           O  
ATOM   2821  CB  VAL C 103       5.410   2.191  20.329  1.00 45.55           C  
ATOM   2822  CG1 VAL C 103       6.912   2.146  19.967  1.00 41.57           C  
ATOM   2823  CG2 VAL C 103       5.192   2.776  21.727  1.00 39.85           C  
ATOM   2824  N   THR C 104       5.385   2.779  16.963  1.00 47.73           N  
ATOM   2825  CA  THR C 104       5.583   2.102  15.683  1.00 48.19           C  
ATOM   2826  C   THR C 104       7.070   2.083  15.286  1.00 47.93           C  
ATOM   2827  O   THR C 104       7.840   2.945  15.694  1.00 46.43           O  
ATOM   2828  CB  THR C 104       4.754   2.767  14.572  1.00 48.89           C  
ATOM   2829  OG1 THR C 104       5.117   4.147  14.467  1.00 47.62           O  
ATOM   2830  CG2 THR C 104       3.265   2.655  14.880  1.00 48.65           C  
ATOM   2831  N   PRO C 105       7.481   1.066  14.516  1.00 48.39           N  
ATOM   2832  CA  PRO C 105       8.856   1.011  14.034  1.00 47.71           C  
ATOM   2833  C   PRO C 105       9.102   2.124  13.036  1.00 47.37           C  
ATOM   2834  O   PRO C 105       8.189   2.482  12.299  1.00 48.15           O  
ATOM   2835  CB  PRO C 105       8.934  -0.350  13.340  1.00 49.07           C  
ATOM   2836  CG  PRO C 105       7.515  -0.681  12.973  1.00 49.02           C  
ATOM   2837  CD  PRO C 105       6.680  -0.090  14.063  1.00 47.80           C  
ATOM   2838  N   ALA C 106      10.319   2.666  13.024  1.00 46.29           N  
ATOM   2839  CA  ALA C 106      10.663   3.773  12.150  1.00 45.30           C  
ATOM   2840  C   ALA C 106      12.119   3.675  11.701  1.00 46.43           C  
ATOM   2841  O   ALA C 106      12.982   3.225  12.457  1.00 46.01           O  
ATOM   2842  CB  ALA C 106      10.419   5.092  12.845  1.00 43.61           C  
ATOM   2843  N   ALA C 107      12.362   4.126  10.467  1.00 46.51           N  
ATOM   2844  CA  ALA C 107      13.645   4.046   9.798  1.00 44.65           C  
ATOM   2845  C   ALA C 107      13.749   5.242   8.841  1.00 44.10           C  
ATOM   2846  O   ALA C 107      12.814   5.548   8.129  1.00 44.48           O  
ATOM   2847  CB  ALA C 107      13.767   2.717   9.045  1.00 41.53           C  
ATOM   2848  N   TYR C 108      14.886   5.931   8.865  1.00 45.91           N  
ATOM   2849  CA  TYR C 108      15.152   7.109   8.031  1.00 45.81           C  
ATOM   2850  C   TYR C 108      16.576   7.012   7.497  1.00 46.37           C  
ATOM   2851  O   TYR C 108      17.415   6.296   8.052  1.00 44.32           O  
ATOM   2852  CB  TYR C 108      15.049   8.415   8.838  1.00 45.73           C  
ATOM   2853  CG  TYR C 108      13.667   8.751   9.369  1.00 46.88           C  
ATOM   2854  CD1 TYR C 108      13.172   8.147  10.509  1.00 46.45           C  
ATOM   2855  CD2 TYR C 108      12.877   9.718   8.755  1.00 46.94           C  
ATOM   2856  CE1 TYR C 108      11.921   8.462  10.998  1.00 46.98           C  
ATOM   2857  CE2 TYR C 108      11.620  10.030   9.234  1.00 44.83           C  
ATOM   2858  CZ  TYR C 108      11.150   9.405  10.353  1.00 48.99           C  
ATOM   2859  OH  TYR C 108       9.897   9.720  10.832  1.00 51.23           O  
ATOM   2860  N   GLN C 109      16.836   7.764   6.433  1.00 47.24           N  
ATOM   2861  CA  GLN C 109      18.161   7.891   5.857  1.00 46.98           C  
ATOM   2862  C   GLN C 109      18.420   9.382   5.667  1.00 46.26           C  
ATOM   2863  O   GLN C 109      17.511  10.129   5.337  1.00 45.41           O  
ATOM   2864  CB  GLN C 109      18.258   7.115   4.529  1.00 49.50           C  
ATOM   2865  CG  GLN C 109      17.262   7.560   3.454  1.00 54.16           C  
ATOM   2866  CD  GLN C 109      17.006   6.478   2.405  1.00 60.87           C  
ATOM   2867  OE1 GLN C 109      17.841   5.594   2.203  1.00 59.57           O  
ATOM   2868  NE2 GLN C 109      15.837   6.537   1.750  1.00 61.05           N  
ATOM   2869  N   GLU C 110      19.666   9.803   5.884  1.00 45.60           N  
ATOM   2870  CA  GLU C 110      20.022  11.204   6.020  1.00 45.38           C  
ATOM   2871  C   GLU C 110      21.247  11.612   5.208  1.00 44.64           C  
ATOM   2872  O   GLU C 110      22.226  10.877   5.151  1.00 45.17           O  
ATOM   2873  CB  GLU C 110      20.353  11.467   7.479  1.00 46.82           C  
ATOM   2874  CG  GLU C 110      19.206  11.236   8.423  1.00 51.12           C  
ATOM   2875  CD  GLU C 110      19.307   9.997   9.270  1.00 53.35           C  
ATOM   2876  OE1 GLU C 110      20.396   9.384   9.360  1.00 50.90           O  
ATOM   2877  OE2 GLU C 110      18.257   9.658   9.874  1.00 56.81           O  
ATOM   2878  N   LEU C 111      21.193  12.807   4.619  1.00 43.88           N  
ATOM   2879  CA  LEU C 111      22.316  13.397   3.898  1.00 44.43           C  
ATOM   2880  C   LEU C 111      22.642  14.726   4.544  1.00 43.31           C  
ATOM   2881  O   LEU C 111      21.771  15.562   4.664  1.00 40.79           O  
ATOM   2882  CB  LEU C 111      22.025  13.576   2.407  1.00 43.38           C  
ATOM   2883  CG  LEU C 111      23.190  13.988   1.509  1.00 45.36           C  
ATOM   2884  CD1 LEU C 111      24.392  13.011   1.617  1.00 40.33           C  
ATOM   2885  CD2 LEU C 111      22.729  14.141   0.045  1.00 39.81           C  
ATOM   2886  N   PHE C 112      23.890  14.853   5.003  1.00 43.47           N  
ATOM   2887  CA  PHE C 112      24.430  16.071   5.569  1.00 45.55           C  
ATOM   2888  C   PHE C 112      25.373  16.670   4.541  1.00 46.10           C  
ATOM   2889  O   PHE C 112      26.254  15.967   4.034  1.00 42.57           O  
ATOM   2890  CB  PHE C 112      25.299  15.810   6.800  1.00 46.12           C  
ATOM   2891  CG  PHE C 112      24.602  15.153   7.966  1.00 47.78           C  
ATOM   2892  CD1 PHE C 112      24.339  13.793   7.962  1.00 47.53           C  
ATOM   2893  CD2 PHE C 112      24.315  15.879   9.103  1.00 50.37           C  
ATOM   2894  CE1 PHE C 112      23.758  13.178   9.041  1.00 48.45           C  
ATOM   2895  CE2 PHE C 112      23.744  15.266  10.221  1.00 52.78           C  
ATOM   2896  CZ  PHE C 112      23.459  13.914  10.186  1.00 51.71           C  
ATOM   2897  N   LEU C 113      25.158  17.944   4.217  1.00 46.74           N  
ATOM   2898  CA  LEU C 113      26.187  18.783   3.614  1.00 47.36           C  
ATOM   2899  C   LEU C 113      26.771  19.621   4.722  1.00 46.00           C  
ATOM   2900  O   LEU C 113      26.059  20.430   5.325  1.00 46.71           O  
ATOM   2901  CB  LEU C 113      25.598  19.728   2.570  1.00 48.34           C  
ATOM   2902  CG  LEU C 113      25.804  19.424   1.118  1.00 56.28           C  
ATOM   2903  CD1 LEU C 113      25.278  18.022   0.865  1.00 59.70           C  
ATOM   2904  CD2 LEU C 113      25.082  20.491   0.257  1.00 59.18           C  
ATOM   2905  N   LEU C 114      28.065  19.466   4.960  1.00 47.24           N  
ATOM   2906  CA  LEU C 114      28.754  20.166   6.045  1.00 45.96           C  
ATOM   2907  C   LEU C 114      29.753  21.176   5.456  1.00 45.45           C  
ATOM   2908  O   LEU C 114      30.391  20.910   4.430  1.00 44.51           O  
ATOM   2909  CB  LEU C 114      29.455  19.148   6.984  1.00 47.42           C  
ATOM   2910  CG  LEU C 114      28.604  18.115   7.754  1.00 45.80           C  
ATOM   2911  CD1 LEU C 114      28.738  16.739   7.120  1.00 41.89           C  
ATOM   2912  CD2 LEU C 114      28.938  18.018   9.266  1.00 45.60           C  
ATOM   2913  N   ARG C 115      29.832  22.351   6.085  1.00 47.32           N  
ATOM   2914  CA  ARG C 115      30.725  23.458   5.683  1.00 45.85           C  
ATOM   2915  C   ARG C 115      31.595  23.764   6.891  1.00 45.51           C  
ATOM   2916  O   ARG C 115      31.072  23.965   7.974  1.00 43.09           O  
ATOM   2917  CB  ARG C 115      29.922  24.720   5.335  1.00 44.98           C  
ATOM   2918  CG  ARG C 115      30.711  25.816   4.578  1.00 52.40           C  
ATOM   2919  CD  ARG C 115      30.279  27.294   4.856  1.00 58.43           C  
ATOM   2920  NE  ARG C 115      28.834  27.470   4.992  1.00 73.48           N  
ATOM   2921  CZ  ARG C 115      28.086  28.380   4.357  1.00 84.25           C  
ATOM   2922  NH1 ARG C 115      28.645  29.262   3.524  1.00 86.12           N  
ATOM   2923  NH2 ARG C 115      26.753  28.411   4.563  1.00 82.03           N  
ATOM   2924  N   LYS C 116      32.915  23.794   6.704  1.00 46.74           N  
ATOM   2925  CA  LYS C 116      33.839  24.232   7.743  1.00 46.36           C  
ATOM   2926  C   LYS C 116      33.788  25.739   7.864  1.00 46.23           C  
ATOM   2927  O   LYS C 116      33.890  26.412   6.864  1.00 47.91           O  
ATOM   2928  CB  LYS C 116      35.261  23.802   7.416  1.00 46.55           C  
ATOM   2929  CG  LYS C 116      36.219  24.096   8.534  1.00 48.81           C  
ATOM   2930  CD  LYS C 116      37.421  23.196   8.550  1.00 51.92           C  
ATOM   2931  CE  LYS C 116      38.311  23.437   7.410  1.00 55.58           C  
ATOM   2932  NZ  LYS C 116      39.506  22.558   7.562  1.00 62.57           N  
ATOM   2933  N   SER C 117      33.636  26.252   9.085  1.00 46.05           N  
ATOM   2934  CA  SER C 117      33.455  27.677   9.344  1.00 46.64           C  
ATOM   2935  C   SER C 117      34.762  28.466   9.293  1.00 49.19           C  
ATOM   2936  O   SER C 117      35.836  27.896   9.120  1.00 50.20           O  
ATOM   2937  CB  SER C 117      32.778  27.890  10.708  1.00 46.33           C  
ATOM   2938  OG  SER C 117      33.643  27.627  11.803  1.00 45.18           O  
ATOM   2939  N   ALA C 118      34.663  29.790   9.435  1.00 51.12           N  
ATOM   2940  CA  ALA C 118      35.846  30.670   9.457  1.00 51.57           C  
ATOM   2941  C   ALA C 118      36.749  30.412  10.683  1.00 52.71           C  
ATOM   2942  O   ALA C 118      37.953  30.673  10.637  1.00 52.28           O  
ATOM   2943  CB  ALA C 118      35.424  32.145   9.393  1.00 50.44           C  
ATOM   2944  N   THR C 119      36.166  29.894  11.767  1.00 53.88           N  
ATOM   2945  CA  THR C 119      36.946  29.477  12.941  1.00 53.40           C  
ATOM   2946  C   THR C 119      37.281  27.982  12.889  1.00 52.72           C  
ATOM   2947  O   THR C 119      37.858  27.445  13.823  1.00 53.84           O  
ATOM   2948  CB  THR C 119      36.199  29.806  14.262  1.00 54.28           C  
ATOM   2949  OG1 THR C 119      35.032  28.981  14.399  1.00 53.07           O  
ATOM   2950  CG2 THR C 119      35.802  31.299  14.299  1.00 52.82           C  
ATOM   2951  N   GLY C 120      36.897  27.316  11.804  1.00 51.57           N  
ATOM   2952  CA  GLY C 120      37.351  25.958  11.514  1.00 50.62           C  
ATOM   2953  C   GLY C 120      36.499  24.822  12.044  1.00 49.40           C  
ATOM   2954  O   GLY C 120      36.943  23.681  12.025  1.00 50.40           O  
ATOM   2955  N   SER C 121      35.290  25.121  12.521  1.00 47.24           N  
ATOM   2956  CA  SER C 121      34.362  24.097  13.017  0.50 46.37           C  
ATOM   2958  C   SER C 121      33.414  23.670  11.907  1.00 46.13           C  
ATOM   2959  O   SER C 121      32.909  24.515  11.166  1.00 47.57           O  
ATOM   2960  CB  SER C 121      33.546  24.627  14.197  0.50 44.49           C  
ATOM   2962  OG  SER C 121      34.385  24.937  15.294  0.50 47.05           O  
ATOM   2964  N   TRP C 122      33.180  22.366  11.796  1.00 45.83           N  
ATOM   2965  CA  TRP C 122      32.282  21.808  10.783  1.00 44.97           C  
ATOM   2966  C   TRP C 122      30.845  21.932  11.242  1.00 45.99           C  
ATOM   2967  O   TRP C 122      30.496  21.516  12.351  1.00 44.64           O  
ATOM   2968  CB  TRP C 122      32.613  20.338  10.530  1.00 44.34           C  
ATOM   2969  CG  TRP C 122      33.857  20.197   9.751  1.00 41.97           C  
ATOM   2970  CD1 TRP C 122      35.111  19.995  10.239  1.00 40.78           C  
ATOM   2971  CD2 TRP C 122      33.993  20.293   8.324  1.00 43.12           C  
ATOM   2972  NE1 TRP C 122      36.016  19.947   9.212  1.00 39.09           N  
ATOM   2973  CE2 TRP C 122      35.357  20.103   8.023  1.00 41.68           C  
ATOM   2974  CE3 TRP C 122      33.090  20.459   7.271  1.00 40.78           C  
ATOM   2975  CZ2 TRP C 122      35.846  20.116   6.712  1.00 43.99           C  
ATOM   2976  CZ3 TRP C 122      33.588  20.483   5.965  1.00 43.95           C  
ATOM   2977  CH2 TRP C 122      34.951  20.331   5.705  1.00 42.62           C  
ATOM   2978  N   GLN C 123      30.010  22.507  10.383  1.00 46.89           N  
ATOM   2979  CA  GLN C 123      28.591  22.701  10.683  1.00 46.17           C  
ATOM   2980  C   GLN C 123      27.734  22.155   9.557  1.00 46.17           C  
ATOM   2981  O   GLN C 123      28.220  21.987   8.453  1.00 47.16           O  
ATOM   2982  CB  GLN C 123      28.324  24.184  10.858  1.00 46.89           C  
ATOM   2983  CG  GLN C 123      29.189  24.848  11.892  1.00 48.63           C  
ATOM   2984  CD  GLN C 123      28.873  26.303  12.009  1.00 51.65           C  
ATOM   2985  OE1 GLN C 123      28.096  26.681  12.858  1.00 55.51           O  
ATOM   2986  NE2 GLN C 123      29.421  27.124  11.116  1.00 50.01           N  
ATOM   2987  N   THR C 124      26.463  21.869   9.832  1.00 47.83           N  
ATOM   2988  CA  THR C 124      25.538  21.391   8.799  1.00 46.16           C  
ATOM   2989  C   THR C 124      24.956  22.577   8.043  1.00 45.98           C  
ATOM   2990  O   THR C 124      24.266  23.432   8.614  1.00 47.00           O  
ATOM   2991  CB  THR C 124      24.400  20.533   9.397  1.00 46.96           C  
ATOM   2992  OG1 THR C 124      24.964  19.534  10.257  1.00 47.01           O  
ATOM   2993  CG2 THR C 124      23.559  19.866   8.268  1.00 41.74           C  
ATOM   2994  N   ALA C 125      25.249  22.635   6.750  1.00 46.10           N  
ATOM   2995  CA  ALA C 125      24.748  23.709   5.886  1.00 44.07           C  
ATOM   2996  C   ALA C 125      23.375  23.284   5.337  1.00 43.73           C  
ATOM   2997  O   ALA C 125      22.422  24.042   5.370  1.00 39.47           O  
ATOM   2998  CB  ALA C 125      25.748  23.998   4.768  1.00 42.86           C  
ATOM   2999  N   ARG C 126      23.288  22.049   4.846  1.00 45.16           N  
ATOM   3000  CA  ARG C 126      22.058  21.516   4.300  1.00 43.77           C  
ATOM   3001  C   ARG C 126      21.871  20.094   4.780  1.00 43.81           C  
ATOM   3002  O   ARG C 126      22.822  19.305   4.771  1.00 43.69           O  
ATOM   3003  CB  ARG C 126      22.106  21.518   2.771  1.00 44.52           C  
ATOM   3004  CG  ARG C 126      22.427  22.844   2.118  1.00 43.66           C  
ATOM   3005  CD  ARG C 126      21.315  23.855   2.339  1.00 44.25           C  
ATOM   3006  NE  ARG C 126      21.631  25.132   1.715  1.00 44.16           N  
ATOM   3007  CZ  ARG C 126      22.365  26.101   2.256  1.00 43.25           C  
ATOM   3008  NH1 ARG C 126      22.896  25.971   3.451  1.00 46.92           N  
ATOM   3009  NH2 ARG C 126      22.581  27.216   1.572  1.00 42.75           N  
ATOM   3010  N   TYR C 127      20.643  19.761   5.165  1.00 44.82           N  
ATOM   3011  CA  TYR C 127      20.306  18.419   5.638  1.00 45.20           C  
ATOM   3012  C   TYR C 127      18.978  17.933   5.063  1.00 45.48           C  
ATOM   3013  O   TYR C 127      18.010  18.682   5.040  1.00 43.77           O  
ATOM   3014  CB  TYR C 127      20.204  18.473   7.144  1.00 46.74           C  
ATOM   3015  CG  TYR C 127      19.798  17.206   7.841  1.00 47.26           C  
ATOM   3016  CD1 TYR C 127      20.690  16.167   8.010  1.00 45.62           C  
ATOM   3017  CD2 TYR C 127      18.534  17.076   8.385  1.00 43.95           C  
ATOM   3018  CE1 TYR C 127      20.327  15.007   8.683  1.00 47.14           C  
ATOM   3019  CE2 TYR C 127      18.164  15.931   9.062  1.00 46.97           C  
ATOM   3020  CZ  TYR C 127      19.060  14.902   9.198  1.00 48.89           C  
ATOM   3021  OH  TYR C 127      18.680  13.779   9.874  1.00 50.47           O  
ATOM   3022  N   CYS C 128      18.944  16.678   4.601  1.00 45.94           N  
ATOM   3023  CA  CYS C 128      17.724  16.070   4.100  0.50 46.52           C  
ATOM   3025  C   CYS C 128      17.556  14.702   4.777  1.00 46.66           C  
ATOM   3026  O   CYS C 128      18.524  14.000   4.931  1.00 45.28           O  
ATOM   3027  CB  CYS C 128      17.788  15.958   2.567  0.50 46.30           C  
ATOM   3029  SG  CYS C 128      16.220  15.633   1.673  0.50 44.97           S  
ATOM   3031  N   THR C 129      16.320  14.364   5.161  1.00 46.39           N  
ATOM   3032  CA  THR C 129      15.979  13.064   5.698  1.00 47.08           C  
ATOM   3033  C   THR C 129      14.682  12.572   5.055  1.00 49.17           C  
ATOM   3034  O   THR C 129      13.689  13.306   4.992  1.00 50.46           O  
ATOM   3035  CB  THR C 129      15.859  13.094   7.246  1.00 48.72           C  
ATOM   3036  OG1 THR C 129      15.562  11.777   7.732  1.00 51.26           O  
ATOM   3037  CG2 THR C 129      14.784  14.090   7.738  1.00 43.88           C  
ATOM   3038  N   SER C 130      14.708  11.345   4.534  1.00 49.70           N  
ATOM   3039  CA  SER C 130      13.505  10.660   4.089  1.00 49.57           C  
ATOM   3040  C   SER C 130      13.241   9.411   4.920  1.00 48.00           C  
ATOM   3041  O   SER C 130      14.171   8.709   5.324  1.00 46.95           O  
ATOM   3042  CB  SER C 130      13.552  10.326   2.578  1.00 52.07           C  
ATOM   3043  OG  SER C 130      14.850  10.019   2.136  1.00 53.51           O  
ATOM   3044  N   LYS C 131      11.959   9.161   5.173  1.00 48.02           N  
ATOM   3045  CA  LYS C 131      11.487   7.992   5.894  1.00 47.74           C  
ATOM   3046  C   LYS C 131      11.468   6.756   4.986  1.00 47.57           C  
ATOM   3047  O   LYS C 131      10.787   6.741   3.968  1.00 46.34           O  
ATOM   3048  CB  LYS C 131      10.086   8.268   6.438  1.00 48.81           C  
ATOM   3049  CG  LYS C 131       9.657   7.330   7.562  1.00 52.76           C  
ATOM   3050  CD  LYS C 131       8.307   7.749   8.147  1.00 59.70           C  
ATOM   3051  CE  LYS C 131       7.935   6.906   9.389  1.00 65.25           C  
ATOM   3052  NZ  LYS C 131       6.523   7.096   9.846  1.00 61.13           N  
ATOM   3053  N   ILE C 132      12.235   5.731   5.352  1.00 48.05           N  
ATOM   3054  CA  ILE C 132      12.272   4.470   4.625  1.00 49.43           C  
ATOM   3055  C   ILE C 132      11.028   3.616   4.900  1.00 54.20           C  
ATOM   3056  O   ILE C 132      10.554   2.863   4.030  1.00 54.94           O  
ATOM   3057  CB  ILE C 132      13.472   3.633   5.067  1.00 48.82           C  
ATOM   3058  CG1 ILE C 132      14.780   4.346   4.754  1.00 48.85           C  
ATOM   3059  CG2 ILE C 132      13.440   2.265   4.398  1.00 43.05           C  
ATOM   3060  CD1 ILE C 132      15.973   3.699   5.402  1.00 49.14           C  
ATOM   3061  N   SER C 133      10.524   3.706   6.126  1.00 58.79           N  
ATOM   3062  CA  SER C 133       9.478   2.818   6.588  1.00 63.77           C  
ATOM   3063  C   SER C 133       8.887   3.274   7.928  1.00 66.03           C  
ATOM   3064  O   SER C 133       9.593   3.878   8.749  1.00 62.63           O  
ATOM   3065  CB  SER C 133      10.001   1.364   6.709  1.00 65.49           C  
ATOM   3066  OG  SER C 133      11.016   1.228   7.694  1.00 68.84           O  
ATOM   3067  N   PRO C 134       7.583   2.963   8.152  1.00 70.93           N  
ATOM   3068  CA  PRO C 134       6.741   2.223   7.185  1.00 72.21           C  
ATOM   3069  C   PRO C 134       6.272   3.115   6.038  1.00 73.12           C  
ATOM   3070  O   PRO C 134       6.591   4.317   6.007  1.00 73.23           O  
ATOM   3071  CB  PRO C 134       5.543   1.752   8.031  1.00 72.91           C  
ATOM   3072  CG  PRO C 134       5.844   2.189   9.484  1.00 72.07           C  
ATOM   3073  CD  PRO C 134       6.814   3.318   9.362  1.00 71.26           C  
ATOM   3074  OXT PRO C 134       5.581   2.638   5.131  1.00 72.95           O  
TER    3075      PRO C 134                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
