
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  123 (  957),  selected  123 , name 1gs3_A
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 1gs3_A.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     2_A      M       1           -
LGA    L     3_A      M       2           -
LGA    -       -      T       3           -
LGA    -       -      H       4           -
LGA    -       -      Y       5           -
LGA    -       -      S       6           -
LGA    P     4_A      D       7          5.655
LGA    T     5_A      N       8          3.420
LGA    A     6_A      -       -           -
LGA    Q     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    V     9_A      T       9          2.832
LGA    Q    10_A      L      10          2.814
LGA    G    11_A      K      11          3.041
LGA    L    12_A      V      12          2.724
LGA    M    13_A      A      13          2.692
LGA    A    14_A      H      14          2.791
LGA    R    15_A      Q      15          2.568
LGA    Y    16_A      G      16          2.560
LGA    I    17_A      F      17          2.938
LGA    E    18_A      E      18          2.304
LGA    L    19_A      F      19          1.977
LGA    V    20_A      F      20          2.533
LGA    D    21_A      T      21          2.595
LGA    V    22_A      Q      22          2.404
LGA    G    23_A      G      23          2.198
LGA    -       -      L      24           -
LGA    -       -      A      25           -
LGA    -       -      T      26           -
LGA    -       -      G      27           -
LGA    D    24_A      E      28          2.979
LGA    I    25_A      W      29          0.806
LGA    E    26_A      Q      30          0.523
LGA    A    27_A      K      31          0.390
LGA    I    28_A      F      32          1.028
LGA    V    29_A      L      33          0.809
LGA    Q    30_A      D      34          1.150
LGA    M    31_A      M      35          1.528
LGA    F    32_A      L      36          1.109
LGA    A    33_A      T      37          0.558
LGA    D    34_A      E      38          1.117
LGA    D    35_A      D      39          1.469
LGA    A    36_A      F      40          0.672
LGA    T    37_A      T      41          0.446
LGA    V    38_A      F      42          0.281
LGA    E    39_A      W      43          0.385
LGA    N    40_A      F      44          1.564
LGA    P    41_A      P      45          2.498
LGA    F    42_A      M      46           #
LGA    G    43_A      G      47           -
LGA    -       -      E      48           -
LGA    -       -      F      49           -
LGA    Q    44_A      H      50          2.736
LGA    P    45_A      G      51          1.946
LGA    P    46_A      L      52          1.615
LGA    I    47_A      N      53          1.521
LGA    H    48_A      V      54          1.006
LGA    G    49_A      G      55          0.632
LGA    R    50_A      K      56          0.678
LGA    E    51_A      E      57          0.587
LGA    Q    52_A      R      58          0.623
LGA    I    53_A      A      59          0.399
LGA    A    54_A      K      60          0.959
LGA    A    55_A      E      61          1.120
LGA    F    56_A      F      62          0.813
LGA    F    57_A      F      63          0.711
LGA    R    58_A      T      64          1.232
LGA    Q    59_A      Y      65          1.446
LGA    G    60_A      V      66          1.035
LGA    L    61_A      S      67          1.849
LGA    -       -      E      68           -
LGA    -       -      S      69           -
LGA    -       -      F      70           -
LGA    -       -      H      71           -
LGA    K    65_A      T      72          2.223
LGA    V    66_A      G      73          2.230
LGA    R    67_A      I      74          2.950
LGA    -       -      Q      75           -
LGA    A    68_A      I      76          2.415
LGA    C    69_A      S      77          5.061
LGA    L    70_A      S      78          4.688
LGA    T    71_A      L      79          2.205
LGA    G    72_A      D      80          1.557
LGA    P    73_A      R      81          3.534
LGA    V    74_A      V      82          1.608
LGA    R    75_A      T      83          0.875
LGA    A    76_A      S      84          1.241
LGA    S    77_A      N      85          0.991
LGA    H    78_A      E      86          2.223
LGA    N    79_A      T      87          3.748
LGA    G    80_A      -       -           -
LGA    C    81_A      T      88          1.223
LGA    G    82_A      V      89          1.153
LGA    A    83_A      V      90          1.047
LGA    M    84_A      F      91          1.234
LGA    P    85_A      E      92          0.498
LGA    F    86_A      F      93          1.216
LGA    R    87_A      R      94          2.082
LGA    V    88_A      D      95          2.620
LGA    E    89_A      E      96          1.485
LGA    M    90_A      G      97          1.859
LGA    V    91_A      L      98          1.286
LGA    W    92_A      F      99          1.765
LGA    N    93_A      L     100          2.737
LGA    G    94_A      G     101          1.710
LGA    Q    95_A      K     102          0.654
LGA    P    96_A      P     103          1.120
LGA    C    97_A      Y     104          1.386
LGA    A    98_A      K     105          0.916
LGA    L    99_A      N     106          1.588
LGA    D   100_A      R     107          0.824
LGA    V   101_A      V     108          0.563
LGA    I   102_A      A     109          0.665
LGA    D   103_A      V     110          1.235
LGA    V   104_A      S     111          1.500
LGA    M   105_A      F     112          1.434
LGA    R   106_A      D     113          1.062
LGA    F   107_A      V     114          1.163
LGA    D   108_A      R     115          1.476
LGA    E   109_A      G     116          3.406
LGA    H   110_A      -       -           -
LGA    G   111_A      D     117          2.448
LGA    R   112_A      K     118          1.434
LGA    I   113_A      I     119          1.247
LGA    Q   114_A      C     120          1.061
LGA    T   115_A      S     121          1.461
LGA    M   116_A      Y     122          1.271
LGA    Q   117_A      R     123          0.882
LGA    A   118_A      E     124          0.831
LGA    F   119_A      Y     125          1.068
LGA    W   120_A      F     126          1.125
LGA    S   121_A      -       -           -
LGA    E   122_A      -       -           -
LGA    V   123_A      G     127           #
LGA    N   124_A      S     128          0.842
LGA    L   125_A      D     129          2.530
LGA    S   126_A      G     130          3.711
LGA    V   127_A      K     131          2.006
LGA    -       -      S     132           -
LGA    -       -      N     133           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  123  133    5.0    111    1.98    16.22     72.975     5.332

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.001447 * X  +  -0.123505 * Y  +   0.992343 * Z  +  -9.237761
  Y_new =   0.805135 * X  +   0.588694 * Y  +   0.072093 * Z  + -27.255917
  Z_new =  -0.593090 * X  +   0.798865 * Y  +   0.100290 * Z  + -36.833187 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.445910   -1.695683  [ DEG:    82.8445    -97.1555 ]
  Theta =   0.634891    2.506701  [ DEG:    36.3766    143.6234 ]
  Phi   =   1.568999   -1.572593  [ DEG:    89.8970    -90.1030 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1gs3_A                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1gs3_A.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  123  133   5.0  111   1.98   16.22  72.975
REMARK  ---------------------------------------------------------- 
MOLECULE 1gs3_A
HEADER    ISOMERASE                               27-DEC-01   1GS3              
TITLE     HIGH RESOLUTION CRYSTAL STRUCTURE OF PI DELTA-5-3-                    
TITLE    2 KETOSTEROID ISOMERASE MUTANTS Y30F/Y55F/Y115F/ D38N                  
TITLE    3 (Y32F/Y57F/Y119F/D40N, PI NUMBERING)COMPLEXED WITH                   
TITLE    4 EQUILENIN AT 2.1 A RESOLUTION                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: STEROID DELTA-ISOMERASE;                                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: DELTA-5-3-KETOSTEROID ISOMERASE;                            
COMPND   5 EC: 5.3.3.1;                                                         
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS PUTIDA;                             
SOURCE   3 STRAIN: BIOTYPE B;                                                   
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)                                  
KEYWDS    ISOMERASE                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.SHIN,N.-C.HA,B.-H.OH                                                
REVDAT   1   23-JAN-03 1GS3    0                                                
JRNL        AUTH   G.CHOI,S.SHIN,S.-G.YUN,D.S.JANG,G.H.NAM,B.-H.HONG,           
JRNL        AUTH 2 H.-C.LEE,B.-H.OH,K.Y.CHOI                                    
JRNL        TITL   CONTRIBUTION OF A LOW-BARRIER HYDROGEN BOND TO               
JRNL        TITL 2 CATALYSIS BY DELTA-5-3-KETOSTEROID ISOMERASE IS              
JRNL        TITL 3 NOT EXTREMELY HIGH COMPARED TO THAT OF AN ORDINARY           
JRNL        TITL 4 HYDROGEN BOND. LOW-BARRIER HYDROGEN BOND OF PI KSI           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  1GS3 A    1   131  UNP    P07445   SDIS_PSEPU       1    131             
SEQRES   1 A  131  MET ASN LEU PRO THR ALA GLN GLU VAL GLN GLY LEU MET          
SEQRES   2 A  131  ALA ARG TYR ILE GLU LEU VAL ASP VAL GLY ASP ILE GLU          
SEQRES   3 A  131  ALA ILE VAL GLN MET PHE ALA ASP ASP ALA THR VAL GLU          
SEQRES   4 A  131  ASN PRO PHE GLY GLN PRO PRO ILE HIS GLY ARG GLU GLN          
SEQRES   5 A  131  ILE ALA ALA PHE PHE ARG GLN GLY LEU GLY GLY GLY LYS          
SEQRES   6 A  131  VAL ARG ALA CYS LEU THR GLY PRO VAL ARG ALA SER HIS          
SEQRES   7 A  131  ASN GLY CYS GLY ALA MET PRO PHE ARG VAL GLU MET VAL          
SEQRES   8 A  131  TRP ASN GLY GLN PRO CYS ALA LEU ASP VAL ILE ASP VAL          
SEQRES   9 A  131  MET ARG PHE ASP GLU HIS GLY ARG ILE GLN THR MET GLN          
SEQRES  10 A  131  ALA PHE TRP SER GLU VAL ASN LEU SER VAL ARG GLU PRO          
SEQRES  11 A  131  GLN                                                          
HET    EQU  A 801      20                                                       
HETNAM     EQU EQUILENIN                                                        
FORMUL   2  EQU    C18 H18 O2                                                   
FORMUL   3  HOH   *38(H2 O)                                                     
CRYST1   36.319   96.237   74.431  90.00  90.00  90.00 C 2 2 21      8          
ATOM      1  N   ASN A   2      37.485  24.326   9.776  1.00 42.95           N  
ATOM      2  CA  ASN A   2      37.329  24.262   8.287  1.00 42.74           C  
ATOM      3  C   ASN A   2      36.461  23.103   7.830  1.00 40.46           C  
ATOM      4  O   ASN A   2      35.874  22.395   8.652  1.00 40.06           O  
ATOM      5  CB  ASN A   2      38.695  24.147   7.609  1.00 45.00           C  
ATOM      6  CG  ASN A   2      39.599  25.324   7.918  1.00 20.00           C  
ATOM      7  OD1 ASN A   2      39.151  26.469   7.960  1.00 20.00           O  
ATOM      8  ND2 ASN A   2      40.880  25.044   8.135  1.00 20.00           N  
ATOM      9  N   LEU A   3      36.387  22.919   6.514  1.00 36.91           N  
ATOM     10  CA  LEU A   3      35.592  21.846   5.941  1.00 33.91           C  
ATOM     11  C   LEU A   3      35.997  20.564   6.651  1.00 31.65           C  
ATOM     12  O   LEU A   3      37.118  20.089   6.494  1.00 32.71           O  
ATOM     13  CB  LEU A   3      35.861  21.733   4.442  1.00 33.19           C  
ATOM     14  CG  LEU A   3      34.755  21.091   3.601  1.00 33.40           C  
ATOM     15  CD1 LEU A   3      33.476  21.883   3.748  1.00 35.01           C  
ATOM     16  CD2 LEU A   3      35.167  21.059   2.146  1.00 34.23           C  
ATOM     17  N   PRO A   4      35.095  20.003   7.470  1.00 30.17           N  
ATOM     18  CA  PRO A   4      35.426  18.770   8.183  1.00 28.42           C  
ATOM     19  C   PRO A   4      35.943  17.675   7.275  1.00 26.43           C  
ATOM     20  O   PRO A   4      35.590  17.589   6.102  1.00 28.45           O  
ATOM     21  CB  PRO A   4      34.110  18.393   8.863  1.00 27.94           C  
ATOM     22  CG  PRO A   4      33.079  19.033   8.011  1.00 30.03           C  
ATOM     23  CD  PRO A   4      33.692  20.372   7.707  1.00 29.29           C  
ATOM     24  N   THR A   5      36.800  16.841   7.832  1.00 24.44           N  
ATOM     25  CA  THR A   5      37.368  15.741   7.088  1.00 22.23           C  
ATOM     26  C   THR A   5      36.412  14.576   7.259  1.00 21.84           C  
ATOM     27  O   THR A   5      35.498  14.644   8.079  1.00 21.05           O  
ATOM     28  CB  THR A   5      38.746  15.388   7.645  1.00 22.24           C  
ATOM     29  OG1 THR A   5      38.620  14.922   8.999  1.00 18.18           O  
ATOM     30  CG2 THR A   5      39.636  16.628   7.624  1.00 21.52           C  
ATOM     31  N   ALA A   6      36.616  13.516   6.487  1.00 21.60           N  
ATOM     32  CA  ALA A   6      35.751  12.353   6.572  1.00 22.86           C  
ATOM     33  C   ALA A   6      35.537  11.922   8.018  1.00 23.06           C  
ATOM     34  O   ALA A   6      34.401  11.799   8.465  1.00 24.12           O  
ATOM     35  CB  ALA A   6      36.335  11.202   5.763  1.00 22.75           C  
ATOM     36  N   GLN A   7      36.626  11.713   8.753  1.00 24.23           N  
ATOM     37  CA  GLN A   7      36.537  11.283  10.148  1.00 25.06           C  
ATOM     38  C   GLN A   7      35.797  12.280  11.010  1.00 23.42           C  
ATOM     39  O   GLN A   7      35.085  11.903  11.934  1.00 24.00           O  
ATOM     40  CB  GLN A   7      37.933  11.049  10.721  1.00 29.24           C  
ATOM     41  CG  GLN A   7      38.724  10.033   9.920  1.00 34.73           C  
ATOM     42  CD  GLN A   7      40.071   9.708  10.523  1.00 37.38           C  
ATOM     43  OE1 GLN A   7      40.811   8.877   9.991  1.00 39.74           O  
ATOM     44  NE2 GLN A   7      40.399  10.357  11.639  1.00 38.05           N  
ATOM     45  N   GLU A   8      35.970  13.557  10.703  1.00 21.95           N  
ATOM     46  CA  GLU A   8      35.302  14.607  11.444  1.00 21.39           C  
ATOM     47  C   GLU A   8      33.808  14.587  11.184  1.00 20.93           C  
ATOM     48  O   GLU A   8      33.009  14.929  12.062  1.00 22.97           O  
ATOM     49  CB  GLU A   8      35.886  15.967  11.063  1.00 21.57           C  
ATOM     50  CG  GLU A   8      37.101  16.319  11.883  1.00 24.11           C  
ATOM     51  CD  GLU A   8      37.923  17.448  11.301  1.00 26.24           C  
ATOM     52  OE1 GLU A   8      38.832  17.930  12.016  1.00 27.35           O  
ATOM     53  OE2 GLU A   8      37.677  17.845  10.140  1.00 27.26           O  
ATOM     54  N   VAL A   9      33.430  14.183   9.975  1.00 20.28           N  
ATOM     55  CA  VAL A   9      32.025  14.117   9.600  1.00 17.54           C  
ATOM     56  C   VAL A   9      31.334  12.977  10.343  1.00 15.83           C  
ATOM     57  O   VAL A   9      30.221  13.131  10.843  1.00 14.59           O  
ATOM     58  CB  VAL A   9      31.871  13.926   8.079  1.00 17.11           C  
ATOM     59  CG1 VAL A   9      30.401  13.842   7.699  1.00 17.05           C  
ATOM     60  CG2 VAL A   9      32.527  15.088   7.355  1.00 18.01           C  
ATOM     61  N   GLN A  10      31.998  11.832  10.422  1.00 14.99           N  
ATOM     62  CA  GLN A  10      31.428  10.690  11.128  1.00 14.38           C  
ATOM     63  C   GLN A  10      31.081  11.092  12.550  1.00 13.42           C  
ATOM     64  O   GLN A  10      30.088  10.631  13.112  1.00 15.02           O  
ATOM     65  CB  GLN A  10      32.414   9.530  11.185  1.00 13.46           C  
ATOM     66  CG  GLN A  10      32.749   8.947   9.849  1.00 17.21           C  
ATOM     67  CD  GLN A  10      33.487   7.636   9.975  1.00 19.22           C  
ATOM     68  OE1 GLN A  10      34.559   7.564  10.588  1.00 16.52           O  
ATOM     69  NE2 GLN A  10      32.914   6.580   9.393  1.00 18.24           N  
ATOM     70  N   GLY A  11      31.910  11.954  13.127  1.00 12.82           N  
ATOM     71  CA  GLY A  11      31.687  12.402  14.485  1.00 14.50           C  
ATOM     72  C   GLY A  11      30.549  13.384  14.631  1.00 14.17           C  
ATOM     73  O   GLY A  11      29.678  13.206  15.485  1.00 16.03           O  
ATOM     74  N   LEU A  12      30.547  14.424  13.803  1.00 12.54           N  
ATOM     75  CA  LEU A  12      29.497  15.423  13.878  1.00 11.62           C  
ATOM     76  C   LEU A  12      28.131  14.804  13.685  1.00 12.27           C  
ATOM     77  O   LEU A  12      27.192  15.119  14.424  1.00 11.53           O  
ATOM     78  CB  LEU A  12      29.715  16.514  12.833  1.00 12.62           C  
ATOM     79  CG  LEU A  12      30.854  17.483  13.157  1.00 14.44           C  
ATOM     80  CD1 LEU A  12      31.032  18.467  12.012  1.00 16.84           C  
ATOM     81  CD2 LEU A  12      30.543  18.217  14.440  1.00 13.35           C  
ATOM     82  N   MET A  13      28.016  13.920  12.697  1.00 11.65           N  
ATOM     83  CA  MET A  13      26.735  13.284  12.416  1.00 11.11           C  
ATOM     84  C   MET A  13      26.299  12.356  13.525  1.00 10.75           C  
ATOM     85  O   MET A  13      25.120  12.293  13.859  1.00 10.93           O  
ATOM     86  CB  MET A  13      26.785  12.566  11.067  1.00 10.24           C  
ATOM     87  CG  MET A  13      27.010  13.559   9.921  1.00 12.49           C  
ATOM     88  SD  MET A  13      26.828  12.901   8.252  1.00 13.76           S  
ATOM     89  CE  MET A  13      25.063  12.625   8.196  1.00 13.20           C  
ATOM     90  N   ALA A  14      27.250  11.661  14.127  1.00 11.32           N  
ATOM     91  CA  ALA A  14      26.919  10.759  15.229  1.00 12.55           C  
ATOM     92  C   ALA A  14      26.506  11.588  16.443  1.00 13.02           C  
ATOM     93  O   ALA A  14      25.645  11.179  17.232  1.00 12.61           O  
ATOM     94  CB  ALA A  14      28.111   9.901  15.574  1.00  9.83           C  
ATOM     95  N   ARG A  15      27.140  12.752  16.582  1.00 15.29           N  
ATOM     96  CA  ARG A  15      26.869  13.679  17.682  1.00 16.07           C  
ATOM     97  C   ARG A  15      25.425  14.151  17.553  1.00 16.21           C  
ATOM     98  O   ARG A  15      24.656  14.168  18.524  1.00 13.78           O  
ATOM     99  CB  ARG A  15      27.818  14.875  17.592  1.00 16.81           C  
ATOM    100  CG  ARG A  15      27.393  16.061  18.426  1.00 19.46           C  
ATOM    101  CD  ARG A  15      27.909  15.974  19.839  1.00 20.75           C  
ATOM    102  NE  ARG A  15      27.382  17.054  20.672  1.00 22.04           N  
ATOM    103  CZ  ARG A  15      27.419  18.347  20.352  1.00 23.15           C  
ATOM    104  NH1 ARG A  15      27.960  18.747  19.204  1.00 23.17           N  
ATOM    105  NH2 ARG A  15      26.917  19.250  21.188  1.00 24.42           N  
ATOM    106  N   TYR A  16      25.082  14.534  16.327  1.00 15.23           N  
ATOM    107  CA  TYR A  16      23.747  14.993  15.987  1.00 15.17           C  
ATOM    108  C   TYR A  16      22.676  13.994  16.459  1.00 15.83           C  
ATOM    109  O   TYR A  16      21.671  14.391  17.059  1.00 14.03           O  
ATOM    110  CB  TYR A  16      23.666  15.184  14.468  1.00 13.45           C  
ATOM    111  CG  TYR A  16      22.290  15.487  13.946  1.00 12.35           C  
ATOM    112  CD1 TYR A  16      21.792  16.792  13.941  1.00  9.25           C  
ATOM    113  CD2 TYR A  16      21.484  14.470  13.443  1.00 10.62           C  
ATOM    114  CE1 TYR A  16      20.519  17.071  13.439  1.00  9.17           C  
ATOM    115  CE2 TYR A  16      20.220  14.735  12.942  1.00  7.90           C  
ATOM    116  CZ  TYR A  16      19.739  16.033  12.939  1.00  9.85           C  
ATOM    117  OH  TYR A  16      18.478  16.285  12.430  1.00  9.63           O  
ATOM    118  N   ILE A  17      22.882  12.703  16.186  1.00 17.21           N  
ATOM    119  CA  ILE A  17      21.905  11.694  16.606  1.00 18.17           C  
ATOM    120  C   ILE A  17      21.861  11.612  18.134  1.00 17.80           C  
ATOM    121  O   ILE A  17      20.805  11.407  18.726  1.00 18.58           O  
ATOM    122  CB  ILE A  17      22.237  10.297  16.020  1.00 20.40           C  
ATOM    123  CG1 ILE A  17      22.102  10.322  14.496  1.00 21.10           C  
ATOM    124  CG2 ILE A  17      21.289   9.239  16.591  1.00 18.99           C  
ATOM    125  CD1 ILE A  17      20.684  10.554  13.998  1.00 22.27           C  
ATOM    126  N   GLU A  18      23.014  11.780  18.767  1.00 19.01           N  
ATOM    127  CA  GLU A  18      23.100  11.747  20.223  1.00 20.63           C  
ATOM    128  C   GLU A  18      22.159  12.814  20.768  1.00 18.47           C  
ATOM    129  O   GLU A  18      21.321  12.549  21.631  1.00 19.09           O  
ATOM    130  CB  GLU A  18      24.526  12.069  20.679  1.00 24.17           C  
ATOM    131  CG  GLU A  18      24.996  11.273  21.872  1.00 31.97           C  
ATOM    132  CD  GLU A  18      25.774  10.041  21.458  1.00 36.96           C  
ATOM    133  OE1 GLU A  18      26.984  10.181  21.158  1.00 39.73           O  
ATOM    134  OE2 GLU A  18      25.180   8.937  21.416  1.00 39.52           O  
ATOM    135  N   LEU A  19      22.309  14.024  20.243  1.00 16.29           N  
ATOM    136  CA  LEU A  19      21.493  15.138  20.670  1.00 15.05           C  
ATOM    137  C   LEU A  19      20.026  14.890  20.386  1.00 15.70           C  
ATOM    138  O   LEU A  19      19.185  15.050  21.268  1.00 18.87           O  
ATOM    139  CB  LEU A  19      21.957  16.419  19.979  1.00 13.11           C  
ATOM    140  CG  LEU A  19      23.385  16.820  20.342  1.00 11.18           C  
ATOM    141  CD1 LEU A  19      23.754  18.133  19.656  1.00 11.95           C  
ATOM    142  CD2 LEU A  19      23.478  16.957  21.857  1.00  8.69           C  
ATOM    143  N   VAL A  20      19.704  14.502  19.159  1.00 14.86           N  
ATOM    144  CA  VAL A  20      18.313  14.244  18.827  1.00 13.35           C  
ATOM    145  C   VAL A  20      17.743  13.194  19.782  1.00 13.39           C  
ATOM    146  O   VAL A  20      16.592  13.285  20.197  1.00 14.43           O  
ATOM    147  CB  VAL A  20      18.155  13.744  17.383  1.00 12.40           C  
ATOM    148  CG1 VAL A  20      16.712  13.404  17.120  1.00 11.55           C  
ATOM    149  CG2 VAL A  20      18.618  14.808  16.409  1.00 14.65           C  
ATOM    150  N   ASP A  21      18.559  12.212  20.147  1.00 15.54           N  
ATOM    151  CA  ASP A  21      18.111  11.159  21.049  1.00 16.08           C  
ATOM    152  C   ASP A  21      17.761  11.676  22.443  1.00 16.53           C  
ATOM    153  O   ASP A  21      16.776  11.241  23.034  1.00 17.10           O  
ATOM    154  CB  ASP A  21      19.174  10.063  21.150  1.00 17.64           C  
ATOM    155  CG  ASP A  21      18.725   8.885  22.012  1.00 20.23           C  
ATOM    156  OD1 ASP A  21      17.611   8.350  21.782  1.00 17.08           O  
ATOM    157  OD2 ASP A  21      19.499   8.488  22.917  1.00 22.12           O  
ATOM    158  N   VAL A  22      18.558  12.594  22.977  1.00 15.71           N  
ATOM    159  CA  VAL A  22      18.258  13.128  24.303  1.00 13.17           C  
ATOM    160  C   VAL A  22      17.312  14.324  24.228  1.00 13.49           C  
ATOM    161  O   VAL A  22      16.780  14.766  25.243  1.00 13.17           O  
ATOM    162  CB  VAL A  22      19.525  13.557  25.049  1.00 13.50           C  
ATOM    163  CG1 VAL A  22      20.517  12.414  25.058  1.00 14.09           C  
ATOM    164  CG2 VAL A  22      20.125  14.794  24.402  1.00 12.07           C  
ATOM    165  N   GLY A  23      17.106  14.848  23.027  1.00 11.22           N  
ATOM    166  CA  GLY A  23      16.201  15.964  22.869  1.00 13.13           C  
ATOM    167  C   GLY A  23      16.686  17.335  23.303  1.00 14.13           C  
ATOM    168  O   GLY A  23      15.862  18.213  23.568  1.00 17.21           O  
ATOM    169  N   ASP A  24      18.000  17.538  23.388  1.00 13.81           N  
ATOM    170  CA  ASP A  24      18.548  18.843  23.777  1.00 11.89           C  
ATOM    171  C   ASP A  24      18.393  19.757  22.554  1.00 12.54           C  
ATOM    172  O   ASP A  24      19.294  19.880  21.714  1.00 10.38           O  
ATOM    173  CB  ASP A  24      20.028  18.703  24.153  1.00 13.30           C  
ATOM    174  CG  ASP A  24      20.589  19.947  24.817  1.00 13.81           C  
ATOM    175  OD1 ASP A  24      20.274  21.067  24.360  1.00 13.97           O  
ATOM    176  OD2 ASP A  24      21.358  19.808  25.789  1.00 15.44           O  
ATOM    177  N   ILE A  25      17.239  20.406  22.462  1.00 12.60           N  
ATOM    178  CA  ILE A  25      16.928  21.259  21.320  1.00 13.49           C  
ATOM    179  C   ILE A  25      17.866  22.422  21.027  1.00 15.65           C  
ATOM    180  O   ILE A  25      18.212  22.654  19.865  1.00 16.30           O  
ATOM    181  CB  ILE A  25      15.472  21.774  21.416  1.00 13.89           C  
ATOM    182  CG1 ILE A  25      14.521  20.571  21.400  1.00 13.30           C  
ATOM    183  CG2 ILE A  25      15.166  22.727  20.267  1.00 10.72           C  
ATOM    184  CD1 ILE A  25      13.073  20.928  21.254  1.00 16.79           C  
ATOM    185  N   GLU A  26      18.286  23.147  22.056  1.00 16.31           N  
ATOM    186  CA  GLU A  26      19.183  24.272  21.835  1.00 18.15           C  
ATOM    187  C   GLU A  26      20.512  23.787  21.279  1.00 18.86           C  
ATOM    188  O   GLU A  26      21.097  24.415  20.394  1.00 20.00           O  
ATOM    189  CB  GLU A  26      19.380  25.053  23.135  1.00 21.56           C  
ATOM    190  CG  GLU A  26      18.168  25.913  23.477  1.00 28.71           C  
ATOM    191  CD  GLU A  26      17.938  26.063  24.973  1.00 32.93           C  
ATOM    192  OE1 GLU A  26      16.953  26.749  25.349  1.00 34.56           O  
ATOM    193  OE2 GLU A  26      18.731  25.494  25.765  1.00 35.79           O  
ATOM    194  N   ALA A  27      20.978  22.654  21.781  1.00 16.99           N  
ATOM    195  CA  ALA A  27      22.229  22.096  21.309  1.00 16.61           C  
ATOM    196  C   ALA A  27      22.078  21.629  19.855  1.00 16.52           C  
ATOM    197  O   ALA A  27      22.991  21.786  19.041  1.00 17.61           O  
ATOM    198  CB  ALA A  27      22.642  20.940  22.205  1.00 14.53           C  
ATOM    199  N   ILE A  28      20.926  21.063  19.524  1.00 15.75           N  
ATOM    200  CA  ILE A  28      20.698  20.588  18.163  1.00 15.49           C  
ATOM    201  C   ILE A  28      20.693  21.748  17.172  1.00 15.99           C  
ATOM    202  O   ILE A  28      21.421  21.730  16.175  1.00 15.95           O  
ATOM    203  CB  ILE A  28      19.351  19.856  18.045  1.00 14.51           C  
ATOM    204  CG1 ILE A  28      19.413  18.531  18.806  1.00 14.20           C  
ATOM    205  CG2 ILE A  28      18.994  19.658  16.578  1.00 12.97           C  
ATOM    206  CD1 ILE A  28      18.058  17.856  18.951  1.00 14.84           C  
ATOM    207  N   VAL A  29      19.864  22.748  17.448  1.00 15.78           N  
ATOM    208  CA  VAL A  29      19.751  23.904  16.576  1.00 15.39           C  
ATOM    209  C   VAL A  29      21.098  24.575  16.329  1.00 16.15           C  
ATOM    210  O   VAL A  29      21.334  25.145  15.257  1.00 17.04           O  
ATOM    211  CB  VAL A  29      18.770  24.949  17.164  1.00 16.55           C  
ATOM    212  CG1 VAL A  29      18.685  26.157  16.234  1.00 15.41           C  
ATOM    213  CG2 VAL A  29      17.383  24.325  17.355  1.00 14.35           C  
ATOM    214  N   GLN A  30      21.983  24.491  17.320  1.00 17.27           N  
ATOM    215  CA  GLN A  30      23.313  25.100  17.256  1.00 16.57           C  
ATOM    216  C   GLN A  30      24.295  24.452  16.272  1.00 16.25           C  
ATOM    217  O   GLN A  30      25.288  25.075  15.883  1.00 14.36           O  
ATOM    218  CB  GLN A  30      23.933  25.106  18.651  1.00 22.20           C  
ATOM    219  CG  GLN A  30      24.988  26.165  18.850  1.00 27.75           C  
ATOM    220  CD  GLN A  30      24.389  27.552  18.957  1.00 32.48           C  
ATOM    221  OE1 GLN A  30      23.553  27.807  19.827  1.00 34.99           O  
ATOM    222  NE2 GLN A  30      24.816  28.463  18.073  1.00 33.31           N  
ATOM    223  N   MET A  31      24.030  23.210  15.877  1.00 13.35           N  
ATOM    224  CA  MET A  31      24.900  22.522  14.934  1.00 13.08           C  
ATOM    225  C   MET A  31      24.687  23.022  13.510  1.00 12.37           C  
ATOM    226  O   MET A  31      25.525  22.791  12.645  1.00  9.64           O  
ATOM    227  CB  MET A  31      24.657  21.009  14.959  1.00 14.87           C  
ATOM    228  CG  MET A  31      25.167  20.305  16.202  1.00 18.12           C  
ATOM    229  SD  MET A  31      25.213  18.511  15.978  1.00 22.86           S  
ATOM    230  CE  MET A  31      26.806  18.321  15.119  1.00 21.28           C  
ATOM    231  N   PHE A  32      23.564  23.691  13.262  1.00 10.65           N  
ATOM    232  CA  PHE A  32      23.288  24.192  11.921  1.00 11.37           C  
ATOM    233  C   PHE A  32      23.849  25.582  11.692  1.00 12.23           C  
ATOM    234  O   PHE A  32      24.053  26.340  12.638  1.00 12.61           O  
ATOM    235  CB  PHE A  32      21.783  24.252  11.659  1.00 11.58           C  
ATOM    236  CG  PHE A  32      21.108  22.924  11.690  1.00 10.75           C  
ATOM    237  CD1 PHE A  32      20.735  22.348  12.896  1.00 12.71           C  
ATOM    238  CD2 PHE A  32      20.845  22.244  10.513  1.00 11.42           C  
ATOM    239  CE1 PHE A  32      20.104  21.100  12.930  1.00 11.16           C  
ATOM    240  CE2 PHE A  32      20.219  21.003  10.536  1.00 11.51           C  
ATOM    241  CZ  PHE A  32      19.847  20.432  11.755  1.00 11.37           C  
ATOM    242  N   ALA A  33      24.103  25.912  10.430  1.00 11.79           N  
ATOM    243  CA  ALA A  33      24.575  27.245  10.087  1.00 13.76           C  
ATOM    244  C   ALA A  33      23.338  28.116  10.325  1.00 15.17           C  
ATOM    245  O   ALA A  33      22.218  27.600  10.368  1.00 13.58           O  
ATOM    246  CB  ALA A  33      24.991  27.306   8.633  1.00 12.02           C  
ATOM    247  N   ASP A  34      23.528  29.424  10.469  1.00 16.69           N  
ATOM    248  CA  ASP A  34      22.405  30.313  10.744  1.00 17.55           C  
ATOM    249  C   ASP A  34      21.370  30.379   9.631  1.00 18.13           C  
ATOM    250  O   ASP A  34      20.174  30.557   9.893  1.00 18.76           O  
ATOM    251  CB  ASP A  34      22.902  31.731  11.068  1.00 17.15           C  
ATOM    252  CG  ASP A  34      23.627  32.389   9.902  1.00 19.02           C  
ATOM    253  OD1 ASP A  34      24.822  32.094   9.692  1.00 20.01           O  
ATOM    254  OD2 ASP A  34      22.992  33.201   9.196  1.00 17.43           O  
ATOM    255  N   ASP A  35      21.823  30.219   8.394  1.00 18.01           N  
ATOM    256  CA  ASP A  35      20.934  30.288   7.245  1.00 17.04           C  
ATOM    257  C   ASP A  35      20.706  28.929   6.591  1.00 16.24           C  
ATOM    258  O   ASP A  35      20.316  28.857   5.430  1.00 14.82           O  
ATOM    259  CB  ASP A  35      21.526  31.256   6.222  1.00 19.02           C  
ATOM    260  CG  ASP A  35      22.872  30.791   5.702  1.00 19.18           C  
ATOM    261  OD1 ASP A  35      23.674  30.282   6.512  1.00 22.18           O  
ATOM    262  OD2 ASP A  35      23.135  30.935   4.492  1.00 22.15           O  
ATOM    263  N   ALA A  36      20.939  27.856   7.339  1.00 14.67           N  
ATOM    264  CA  ALA A  36      20.780  26.496   6.825  1.00 14.45           C  
ATOM    265  C   ALA A  36      19.391  26.174   6.284  1.00 15.25           C  
ATOM    266  O   ALA A  36      18.418  26.844   6.617  1.00 18.13           O  
ATOM    267  CB  ALA A  36      21.143  25.498   7.918  1.00 13.39           C  
ATOM    268  N   THR A  37      19.303  25.145   5.444  1.00 15.46           N  
ATOM    269  CA  THR A  37      18.017  24.725   4.888  1.00 15.70           C  
ATOM    270  C   THR A  37      17.821  23.245   5.142  1.00 16.31           C  
ATOM    271  O   THR A  37      18.730  22.440   4.944  1.00 19.56           O  
ATOM    272  CB  THR A  37      17.912  24.975   3.369  1.00 14.31           C  
ATOM    273  OG1 THR A  37      18.865  24.162   2.679  1.00 18.31           O  
ATOM    274  CG2 THR A  37      18.178  26.426   3.054  1.00 13.27           C  
ATOM    275  N   VAL A  38      16.631  22.890   5.598  1.00 15.00           N  
ATOM    276  CA  VAL A  38      16.316  21.512   5.895  1.00 12.64           C  
ATOM    277  C   VAL A  38      15.139  21.056   5.059  1.00 13.78           C  
ATOM    278  O   VAL A  38      14.150  21.778   4.936  1.00 13.70           O  
ATOM    279  CB  VAL A  38      15.958  21.364   7.379  1.00 11.43           C  
ATOM    280  CG1 VAL A  38      15.374  20.008   7.646  1.00 10.66           C  
ATOM    281  CG2 VAL A  38      17.186  21.576   8.224  1.00  9.30           C  
ATOM    282  N   GLU A  39      15.262  19.867   4.472  1.00 14.70           N  
ATOM    283  CA  GLU A  39      14.197  19.252   3.678  1.00 16.68           C  
ATOM    284  C   GLU A  39      13.849  17.942   4.369  1.00 17.40           C  
ATOM    285  O   GLU A  39      14.569  16.947   4.241  1.00 15.98           O  
ATOM    286  CB  GLU A  39      14.668  18.987   2.252  1.00 19.04           C  
ATOM    287  CG  GLU A  39      14.824  20.256   1.448  1.00 22.51           C  
ATOM    288  CD  GLU A  39      15.548  20.036   0.151  1.00 26.00           C  
ATOM    289  OE1 GLU A  39      16.749  19.686   0.189  1.00 27.08           O  
ATOM    290  OE2 GLU A  39      14.916  20.213  -0.909  1.00 28.93           O  
ATOM    291  N   ASN A  40      12.748  17.959   5.112  1.00 17.99           N  
ATOM    292  CA  ASN A  40      12.297  16.802   5.868  1.00 18.82           C  
ATOM    293  C   ASN A  40      10.772  16.717   5.794  1.00 19.28           C  
ATOM    294  O   ASN A  40      10.069  17.549   6.354  1.00 21.31           O  
ATOM    295  CB  ASN A  40      12.734  16.957   7.326  1.00 17.17           C  
ATOM    296  CG  ASN A  40      12.736  15.644   8.091  1.00 18.38           C  
ATOM    297  OD1 ASN A  40      11.996  14.711   7.777  1.00 16.54           O  
ATOM    298  ND2 ASN A  40      13.565  15.580   9.124  1.00 19.01           N  
ATOM    299  N   PRO A  41      10.243  15.735   5.058  1.00 20.68           N  
ATOM    300  CA  PRO A  41      10.996  14.732   4.304  1.00 21.58           C  
ATOM    301  C   PRO A  41      11.438  15.310   2.959  1.00 22.49           C  
ATOM    302  O   PRO A  41      10.955  16.364   2.538  1.00 22.32           O  
ATOM    303  CB  PRO A  41       9.984  13.598   4.145  1.00 22.41           C  
ATOM    304  CG  PRO A  41       8.696  14.343   4.011  1.00 22.14           C  
ATOM    305  CD  PRO A  41       8.805  15.409   5.078  1.00 20.70           C  
ATOM    306  N   PHE A  42      12.368  14.633   2.296  1.00 23.16           N  
ATOM    307  CA  PHE A  42      12.835  15.100   0.998  1.00 25.12           C  
ATOM    308  C   PHE A  42      11.638  15.121   0.071  1.00 24.39           C  
ATOM    309  O   PHE A  42      10.864  14.163   0.021  1.00 22.93           O  
ATOM    310  CB  PHE A  42      13.890  14.161   0.417  1.00 25.86           C  
ATOM    311  CG  PHE A  42      14.375  14.571  -0.950  1.00 28.18           C  
ATOM    312  CD1 PHE A  42      15.273  15.620  -1.098  1.00 27.29           C  
ATOM    313  CD2 PHE A  42      13.930  13.901  -2.089  1.00 28.41           C  
ATOM    314  CE1 PHE A  42      15.723  15.991  -2.358  1.00 29.11           C  
ATOM    315  CE2 PHE A  42      14.374  14.263  -3.355  1.00 28.37           C  
ATOM    316  CZ  PHE A  42      15.271  15.308  -3.491  1.00 28.77           C  
ATOM    317  N   GLY A  43      11.496  16.219  -0.659  1.00 25.64           N  
ATOM    318  CA  GLY A  43      10.384  16.355  -1.578  1.00 28.49           C  
ATOM    319  C   GLY A  43       9.442  17.459  -1.149  1.00 30.03           C  
ATOM    320  O   GLY A  43       8.785  18.089  -1.980  1.00 31.23           O  
ATOM    321  N   GLN A  44       9.373  17.688   0.157  1.00 31.04           N  
ATOM    322  CA  GLN A  44       8.518  18.727   0.710  1.00 32.27           C  
ATOM    323  C   GLN A  44       9.271  20.052   0.647  1.00 31.95           C  
ATOM    324  O   GLN A  44      10.493  20.078   0.471  1.00 31.57           O  
ATOM    325  CB  GLN A  44       8.184  18.403   2.168  1.00 35.89           C  
ATOM    326  CG  GLN A  44       6.715  18.524   2.502  1.00 40.43           C  
ATOM    327  CD  GLN A  44       5.855  17.731   1.543  1.00 44.07           C  
ATOM    328  OE1 GLN A  44       6.073  16.535   1.343  1.00 45.42           O  
ATOM    329  NE2 GLN A  44       4.869  18.393   0.940  1.00 46.42           N  
ATOM    330  N   PRO A  45       8.554  21.177   0.771  1.00 30.13           N  
ATOM    331  CA  PRO A  45       9.259  22.457   0.723  1.00 29.25           C  
ATOM    332  C   PRO A  45      10.176  22.565   1.943  1.00 27.00           C  
ATOM    333  O   PRO A  45       9.788  22.233   3.059  1.00 25.34           O  
ATOM    334  CB  PRO A  45       8.121  23.476   0.724  1.00 30.88           C  
ATOM    335  CG  PRO A  45       7.044  22.776   1.495  1.00 32.69           C  
ATOM    336  CD  PRO A  45       7.104  21.380   0.920  1.00 32.39           C  
ATOM    337  N   PRO A  46      11.409  23.028   1.736  1.00 25.42           N  
ATOM    338  CA  PRO A  46      12.404  23.179   2.797  1.00 24.65           C  
ATOM    339  C   PRO A  46      12.132  24.278   3.800  1.00 23.11           C  
ATOM    340  O   PRO A  46      11.445  25.256   3.498  1.00 21.56           O  
ATOM    341  CB  PRO A  46      13.682  23.451   2.022  1.00 26.16           C  
ATOM    342  CG  PRO A  46      13.179  24.284   0.887  1.00 27.52           C  
ATOM    343  CD  PRO A  46      11.934  23.530   0.454  1.00 26.86           C  
ATOM    344  N   ILE A  47      12.671  24.104   5.002  1.00 21.84           N  
ATOM    345  CA  ILE A  47      12.536  25.106   6.034  1.00 19.99           C  
ATOM    346  C   ILE A  47      13.889  25.792   5.985  1.00 19.95           C  
ATOM    347  O   ILE A  47      14.896  25.157   5.667  1.00 20.28           O  
ATOM    348  CB  ILE A  47      12.274  24.489   7.412  1.00 21.45           C  
ATOM    349  CG1 ILE A  47      13.516  23.786   7.928  1.00 23.27           C  
ATOM    350  CG2 ILE A  47      11.154  23.479   7.317  1.00 21.41           C  
ATOM    351  CD1 ILE A  47      13.319  23.261   9.326  1.00 26.96           C  
ATOM    352  N   HIS A  48      13.922  27.083   6.290  1.00 19.56           N  
ATOM    353  CA  HIS A  48      15.165  27.839   6.201  1.00 18.19           C  
ATOM    354  C   HIS A  48      15.499  28.667   7.432  1.00 15.52           C  
ATOM    355  O   HIS A  48      14.643  29.359   7.973  1.00 15.33           O  
ATOM    356  CB  HIS A  48      15.087  28.759   4.973  1.00 21.54           C  
ATOM    357  CG  HIS A  48      16.274  29.655   4.801  1.00 26.73           C  
ATOM    358  ND1 HIS A  48      17.417  29.261   4.137  1.00 29.20           N  
ATOM    359  CD2 HIS A  48      16.497  30.928   5.208  1.00 29.57           C  
ATOM    360  CE1 HIS A  48      18.293  30.252   4.143  1.00 30.38           C  
ATOM    361  NE2 HIS A  48      17.759  31.275   4.787  1.00 31.89           N  
ATOM    362  N   GLY A  49      16.752  28.603   7.864  1.00 13.31           N  
ATOM    363  CA  GLY A  49      17.171  29.394   9.010  1.00 13.54           C  
ATOM    364  C   GLY A  49      16.955  28.756  10.366  1.00 13.14           C  
ATOM    365  O   GLY A  49      16.026  27.971  10.545  1.00 13.05           O  
ATOM    366  N   ARG A  50      17.806  29.111  11.325  1.00 12.85           N  
ATOM    367  CA  ARG A  50      17.714  28.556  12.662  1.00 13.74           C  
ATOM    368  C   ARG A  50      16.379  28.767  13.353  1.00 15.73           C  
ATOM    369  O   ARG A  50      15.943  27.911  14.115  1.00 17.91           O  
ATOM    370  CB  ARG A  50      18.828  29.104  13.542  1.00 13.33           C  
ATOM    371  CG  ARG A  50      20.149  28.398  13.372  1.00 15.86           C  
ATOM    372  CD  ARG A  50      21.180  29.047  14.261  1.00 16.14           C  
ATOM    373  NE  ARG A  50      22.475  28.381  14.219  1.00 19.17           N  
ATOM    374  CZ  ARG A  50      23.559  28.861  14.816  1.00 20.98           C  
ATOM    375  NH1 ARG A  50      23.488  30.002  15.493  1.00 20.68           N  
ATOM    376  NH2 ARG A  50      24.712  28.210  14.742  1.00 23.53           N  
ATOM    377  N   GLU A  51      15.710  29.888  13.116  1.00 16.48           N  
ATOM    378  CA  GLU A  51      14.430  30.059  13.782  1.00 16.76           C  
ATOM    379  C   GLU A  51      13.486  28.938  13.361  1.00 16.31           C  
ATOM    380  O   GLU A  51      12.947  28.223  14.208  1.00 16.00           O  
ATOM    381  CB  GLU A  51      13.790  31.418  13.476  1.00 19.52           C  
ATOM    382  CG  GLU A  51      12.412  31.549  14.136  1.00 23.49           C  
ATOM    383  CD  GLU A  51      11.670  32.821  13.778  1.00 25.96           C  
ATOM    384  OE1 GLU A  51      11.629  33.188  12.581  1.00 27.74           O  
ATOM    385  OE2 GLU A  51      11.107  33.445  14.699  1.00 29.16           O  
ATOM    386  N   GLN A  52      13.292  28.771  12.057  1.00 15.87           N  
ATOM    387  CA  GLN A  52      12.406  27.726  11.573  1.00 16.48           C  
ATOM    388  C   GLN A  52      12.874  26.318  11.961  1.00 16.86           C  
ATOM    389  O   GLN A  52      12.059  25.441  12.254  1.00 15.40           O  
ATOM    390  CB  GLN A  52      12.234  27.846  10.056  1.00 18.07           C  
ATOM    391  CG  GLN A  52      11.236  28.937   9.663  1.00 23.51           C  
ATOM    392  CD  GLN A  52      11.247  29.273   8.180  1.00 26.46           C  
ATOM    393  OE1 GLN A  52      11.083  28.400   7.319  1.00 26.51           O  
ATOM    394  NE2 GLN A  52      11.433  30.558   7.873  1.00 28.82           N  
ATOM    395  N   ILE A  53      14.183  26.104  11.987  1.00 15.62           N  
ATOM    396  CA  ILE A  53      14.714  24.796  12.347  1.00 14.19           C  
ATOM    397  C   ILE A  53      14.404  24.479  13.808  1.00 14.31           C  
ATOM    398  O   ILE A  53      14.007  23.360  14.146  1.00 12.76           O  
ATOM    399  CB  ILE A  53      16.235  24.734  12.103  1.00 15.46           C  
ATOM    400  CG1 ILE A  53      16.523  24.988  10.616  1.00 13.14           C  
ATOM    401  CG2 ILE A  53      16.784  23.373  12.534  1.00 15.28           C  
ATOM    402  CD1 ILE A  53      17.989  25.054  10.269  1.00 13.75           C  
ATOM    403  N   ALA A  54      14.579  25.461  14.681  1.00 13.79           N  
ATOM    404  CA  ALA A  54      14.283  25.248  16.089  1.00 13.79           C  
ATOM    405  C   ALA A  54      12.799  24.921  16.184  1.00 14.08           C  
ATOM    406  O   ALA A  54      12.397  23.965  16.856  1.00 16.09           O  
ATOM    407  CB  ALA A  54      14.601  26.495  16.886  1.00 13.35           C  
ATOM    408  N   ALA A  55      11.983  25.705  15.490  1.00 13.69           N  
ATOM    409  CA  ALA A  55      10.548  25.475  15.499  1.00 13.97           C  
ATOM    410  C   ALA A  55      10.245  24.014  15.126  1.00 14.33           C  
ATOM    411  O   ALA A  55       9.491  23.328  15.812  1.00 13.14           O  
ATOM    412  CB  ALA A  55       9.868  26.417  14.533  1.00 13.64           C  
ATOM    413  N   PHE A  56      10.847  23.541  14.042  1.00 14.24           N  
ATOM    414  CA  PHE A  56      10.634  22.174  13.591  1.00 15.31           C  
ATOM    415  C   PHE A  56      10.965  21.142  14.665  1.00 16.56           C  
ATOM    416  O   PHE A  56      10.152  20.268  14.981  1.00 15.05           O  
ATOM    417  CB  PHE A  56      11.496  21.897  12.363  1.00 17.51           C  
ATOM    418  CG  PHE A  56      11.566  20.445  11.981  1.00 16.62           C  
ATOM    419  CD1 PHE A  56      10.503  19.828  11.337  1.00 17.78           C  
ATOM    420  CD2 PHE A  56      12.706  19.700  12.255  1.00 15.72           C  
ATOM    421  CE1 PHE A  56      10.576  18.485  10.963  1.00 19.31           C  
ATOM    422  CE2 PHE A  56      12.789  18.358  11.887  1.00 16.26           C  
ATOM    423  CZ  PHE A  56      11.724  17.749  11.239  1.00 19.12           C  
ATOM    424  N   PHE A  57      12.165  21.243  15.221  1.00 15.58           N  
ATOM    425  CA  PHE A  57      12.600  20.290  16.229  1.00 18.57           C  
ATOM    426  C   PHE A  57      11.803  20.351  17.516  1.00 19.20           C  
ATOM    427  O   PHE A  57      11.563  19.327  18.151  1.00 18.41           O  
ATOM    428  CB  PHE A  57      14.089  20.473  16.525  1.00 17.25           C  
ATOM    429  CG  PHE A  57      14.988  19.918  15.456  1.00 19.05           C  
ATOM    430  CD1 PHE A  57      15.528  20.745  14.477  1.00 19.58           C  
ATOM    431  CD2 PHE A  57      15.292  18.560  15.427  1.00 19.14           C  
ATOM    432  CE1 PHE A  57      16.367  20.228  13.479  1.00 18.02           C  
ATOM    433  CE2 PHE A  57      16.128  18.028  14.436  1.00 18.87           C  
ATOM    434  CZ  PHE A  57      16.666  18.869  13.461  1.00 18.82           C  
ATOM    435  N   ARG A  58      11.382  21.547  17.897  1.00 21.29           N  
ATOM    436  CA  ARG A  58      10.606  21.694  19.116  1.00 24.30           C  
ATOM    437  C   ARG A  58       9.284  20.963  18.919  1.00 24.43           C  
ATOM    438  O   ARG A  58       8.811  20.260  19.807  1.00 25.51           O  
ATOM    439  CB  ARG A  58      10.382  23.174  19.405  1.00 25.95           C  
ATOM    440  CG  ARG A  58       9.889  23.464  20.798  1.00 29.96           C  
ATOM    441  CD  ARG A  58      10.167  24.905  21.183  1.00 31.98           C  
ATOM    442  NE  ARG A  58      11.574  25.140  21.511  1.00 35.59           N  
ATOM    443  CZ  ARG A  58      12.241  24.520  22.488  1.00 38.51           C  
ATOM    444  NH1 ARG A  58      11.641  23.606  23.245  1.00 39.24           N  
ATOM    445  NH2 ARG A  58      13.509  24.831  22.730  1.00 38.40           N  
ATOM    446  N   GLN A  59       8.718  21.113  17.729  1.00 25.47           N  
ATOM    447  CA  GLN A  59       7.456  20.482  17.361  1.00 26.75           C  
ATOM    448  C   GLN A  59       7.565  18.956  17.316  1.00 26.41           C  
ATOM    449  O   GLN A  59       6.649  18.248  17.735  1.00 26.80           O  
ATOM    450  CB  GLN A  59       7.024  20.982  15.983  1.00 28.88           C  
ATOM    451  CG  GLN A  59       5.664  20.495  15.538  1.00 33.65           C  
ATOM    452  CD  GLN A  59       4.553  21.437  15.957  1.00 36.73           C  
ATOM    453  OE1 GLN A  59       4.446  22.553  15.440  1.00 38.53           O  
ATOM    454  NE2 GLN A  59       3.721  20.998  16.900  1.00 37.23           N  
ATOM    455  N   GLY A  60       8.690  18.464  16.802  1.00 25.13           N  
ATOM    456  CA  GLY A  60       8.901  17.032  16.675  1.00 26.08           C  
ATOM    457  C   GLY A  60       9.318  16.286  17.928  1.00 26.13           C  
ATOM    458  O   GLY A  60       8.834  15.187  18.193  1.00 25.85           O  
ATOM    459  N   LEU A  61      10.228  16.870  18.696  1.00 26.74           N  
ATOM    460  CA  LEU A  61      10.693  16.238  19.916  1.00 26.91           C  
ATOM    461  C   LEU A  61       9.964  16.830  21.109  1.00 27.30           C  
ATOM    462  O   LEU A  61       9.661  16.123  22.064  1.00 28.69           O  
ATOM    463  CB  LEU A  61      12.197  16.440  20.078  1.00 27.59           C  
ATOM    464  CG  LEU A  61      13.151  15.735  19.106  1.00 28.07           C  
ATOM    465  CD1 LEU A  61      12.855  16.134  17.678  1.00 27.99           C  
ATOM    466  CD2 LEU A  61      14.579  16.110  19.463  1.00 28.37           C  
ATOM    467  N   LYS A  65       8.360  11.956  23.772  1.00 41.02           N  
ATOM    468  CA  LYS A  65       8.936  10.618  23.857  1.00 41.21           C  
ATOM    469  C   LYS A  65       9.523  10.166  22.518  1.00 39.08           C  
ATOM    470  O   LYS A  65       8.853   9.492  21.735  1.00 39.60           O  
ATOM    471  CB  LYS A  65       7.876   9.602  24.312  1.00 44.32           C  
ATOM    472  CG  LYS A  65       8.360   8.140  24.291  1.00 47.17           C  
ATOM    473  CD  LYS A  65       7.264   7.147  24.705  1.00 49.91           C  
ATOM    474  CE  LYS A  65       7.735   5.688  24.572  1.00 50.83           C  
ATOM    475  NZ  LYS A  65       6.687   4.676  24.939  1.00 51.38           N  
ATOM    476  N   VAL A  66      10.773  10.529  22.257  1.00 35.17           N  
ATOM    477  CA  VAL A  66      11.405  10.137  21.010  1.00 32.72           C  
ATOM    478  C   VAL A  66      12.852   9.739  21.192  1.00 32.18           C  
ATOM    479  O   VAL A  66      13.652  10.512  21.718  1.00 31.41           O  
ATOM    480  CB  VAL A  66      11.355  11.269  19.965  1.00 31.49           C  
ATOM    481  CG1 VAL A  66      12.098  10.843  18.716  1.00 30.13           C  
ATOM    482  CG2 VAL A  66       9.916  11.606  19.624  1.00 30.97           C  
ATOM    483  N   ARG A  67      13.186   8.524  20.769  1.00 32.28           N  
ATOM    484  CA  ARG A  67      14.561   8.051  20.849  1.00 30.76           C  
ATOM    485  C   ARG A  67      15.039   7.779  19.427  1.00 27.44           C  
ATOM    486  O   ARG A  67      14.253   7.424  18.550  1.00 24.24           O  
ATOM    487  CB  ARG A  67      14.671   6.792  21.724  1.00 34.79           C  
ATOM    488  CG  ARG A  67      13.819   5.607  21.296  1.00 41.78           C  
ATOM    489  CD  ARG A  67      13.988   4.405  22.252  1.00 47.65           C  
ATOM    490  NE  ARG A  67      14.870   3.349  21.733  1.00 53.13           N  
ATOM    491  CZ  ARG A  67      16.194   3.447  21.598  1.00 55.61           C  
ATOM    492  NH1 ARG A  67      16.826   4.562  21.945  1.00 57.11           N  
ATOM    493  NH2 ARG A  67      16.892   2.427  21.108  1.00 55.53           N  
ATOM    494  N   ALA A  68      16.327   7.983  19.197  1.00 24.72           N  
ATOM    495  CA  ALA A  68      16.900   7.782  17.877  1.00 23.36           C  
ATOM    496  C   ALA A  68      18.215   7.063  18.026  1.00 23.17           C  
ATOM    497  O   ALA A  68      18.832   7.114  19.088  1.00 24.50           O  
ATOM    498  CB  ALA A  68      17.117   9.120  17.200  1.00 22.16           C  
ATOM    499  N   CYS A  69      18.656   6.394  16.970  1.00 22.01           N  
ATOM    500  CA  CYS A  69      19.922   5.684  17.036  1.00 21.85           C  
ATOM    501  C   CYS A  69      20.405   5.238  15.674  1.00 20.74           C  
ATOM    502  O   CYS A  69      19.609   4.785  14.849  1.00 19.91           O  
ATOM    503  CB  CYS A  69      19.781   4.468  17.943  1.00 23.08           C  
ATOM    504  SG  CYS A  69      18.311   3.519  17.561  1.00 29.68           S  
ATOM    505  N   LEU A  70      21.710   5.374  15.450  1.00 20.18           N  
ATOM    506  CA  LEU A  70      22.334   4.965  14.198  1.00 19.88           C  
ATOM    507  C   LEU A  70      22.084   3.477  14.014  1.00 19.92           C  
ATOM    508  O   LEU A  70      22.270   2.706  14.953  1.00 20.77           O  
ATOM    509  CB  LEU A  70      23.842   5.199  14.254  1.00 17.84           C  
ATOM    510  CG  LEU A  70      24.375   6.625  14.222  1.00 20.04           C  
ATOM    511  CD1 LEU A  70      25.875   6.585  14.456  1.00 19.56           C  
ATOM    512  CD2 LEU A  70      24.047   7.289  12.877  1.00 18.94           C  
ATOM    513  N   THR A  71      21.675   3.071  12.813  1.00 18.25           N  
ATOM    514  CA  THR A  71      21.408   1.660  12.548  1.00 16.28           C  
ATOM    515  C   THR A  71      22.507   1.066  11.683  1.00 16.39           C  
ATOM    516  O   THR A  71      22.452  -0.102  11.308  1.00 15.82           O  
ATOM    517  CB  THR A  71      20.062   1.476  11.831  1.00 17.80           C  
ATOM    518  OG1 THR A  71      20.032   2.301  10.659  1.00 19.73           O  
ATOM    519  CG2 THR A  71      18.919   1.857  12.746  1.00 15.84           C  
ATOM    520  N   GLY A  72      23.496   1.892  11.364  1.00 13.88           N  
ATOM    521  CA  GLY A  72      24.612   1.468  10.552  1.00 14.04           C  
ATOM    522  C   GLY A  72      25.688   2.526  10.665  1.00 13.14           C  
ATOM    523  O   GLY A  72      25.430   3.597  11.217  1.00 15.71           O  
ATOM    524  N   PRO A  73      26.903   2.273  10.170  1.00 12.34           N  
ATOM    525  CA  PRO A  73      27.916   3.320  10.295  1.00 10.79           C  
ATOM    526  C   PRO A  73      27.629   4.533   9.422  1.00 10.51           C  
ATOM    527  O   PRO A  73      26.783   4.496   8.534  1.00 11.23           O  
ATOM    528  CB  PRO A  73      29.203   2.596   9.902  1.00 11.88           C  
ATOM    529  CG  PRO A  73      28.720   1.557   8.945  1.00 11.87           C  
ATOM    530  CD  PRO A  73      27.488   1.038   9.614  1.00 13.14           C  
ATOM    531  N   VAL A  74      28.342   5.612   9.689  1.00 11.14           N  
ATOM    532  CA  VAL A  74      28.181   6.844   8.939  1.00 11.59           C  
ATOM    533  C   VAL A  74      29.081   6.852   7.708  1.00 12.27           C  
ATOM    534  O   VAL A  74      30.309   6.741   7.803  1.00 11.28           O  
ATOM    535  CB  VAL A  74      28.537   8.067   9.814  1.00 10.39           C  
ATOM    536  CG1 VAL A  74      28.320   9.339   9.042  1.00  9.85           C  
ATOM    537  CG2 VAL A  74      27.692   8.059  11.084  1.00 11.84           C  
ATOM    538  N   ARG A  75      28.473   6.968   6.539  1.00 11.78           N  
ATOM    539  CA  ARG A  75      29.253   7.029   5.320  1.00 12.46           C  
ATOM    540  C   ARG A  75      29.644   8.494   5.115  1.00 15.06           C  
ATOM    541  O   ARG A  75      28.803   9.389   5.256  1.00 16.94           O  
ATOM    542  CB  ARG A  75      28.430   6.523   4.142  1.00 10.36           C  
ATOM    543  CG  ARG A  75      28.365   5.016   4.030  1.00 12.19           C  
ATOM    544  CD  ARG A  75      27.667   4.353   5.205  1.00 12.08           C  
ATOM    545  NE  ARG A  75      27.186   3.038   4.792  1.00 16.07           N  
ATOM    546  CZ  ARG A  75      26.341   2.278   5.485  1.00 15.62           C  
ATOM    547  NH1 ARG A  75      25.863   2.680   6.655  1.00 13.90           N  
ATOM    548  NH2 ARG A  75      25.953   1.115   4.984  1.00 16.73           N  
ATOM    549  N   ALA A  76      30.910   8.750   4.799  1.00 15.75           N  
ATOM    550  CA  ALA A  76      31.360  10.126   4.598  1.00 17.30           C  
ATOM    551  C   ALA A  76      32.255  10.288   3.376  1.00 19.50           C  
ATOM    552  O   ALA A  76      32.924   9.338   2.959  1.00 20.27           O  
ATOM    553  CB  ALA A  76      32.099  10.612   5.839  1.00 15.87           C  
ATOM    554  N   SER A  77      32.259  11.493   2.807  1.00 20.15           N  
ATOM    555  CA  SER A  77      33.096  11.795   1.649  1.00 21.34           C  
ATOM    556  C   SER A  77      34.202  12.763   2.066  1.00 21.37           C  
ATOM    557  O   SER A  77      34.388  13.044   3.248  1.00 19.69           O  
ATOM    558  CB  SER A  77      32.280  12.423   0.523  1.00 21.55           C  
ATOM    559  OG  SER A  77      31.916  13.744   0.857  1.00 23.30           O  
ATOM    560  N   HIS A  78      34.926  13.290   1.088  1.00 23.31           N  
ATOM    561  CA  HIS A  78      36.020  14.200   1.388  1.00 23.82           C  
ATOM    562  C   HIS A  78      35.728  15.654   1.091  1.00 24.60           C  
ATOM    563  O   HIS A  78      36.627  16.496   1.162  1.00 26.67           O  
ATOM    564  CB  HIS A  78      37.273  13.755   0.642  1.00 24.59           C  
ATOM    565  CG  HIS A  78      37.784  12.419   1.078  1.00 22.27           C  
ATOM    566  ND1 HIS A  78      38.295  12.197   2.338  1.00 24.08           N  
ATOM    567  CD2 HIS A  78      37.837  11.231   0.435  1.00 21.87           C  
ATOM    568  CE1 HIS A  78      38.643  10.929   2.451  1.00 20.93           C  
ATOM    569  NE2 HIS A  78      38.375  10.320   1.311  1.00 20.67           N  
ATOM    570  N   ASN A  79      34.482  15.963   0.748  1.00 23.19           N  
ATOM    571  CA  ASN A  79      34.134  17.350   0.482  1.00 21.60           C  
ATOM    572  C   ASN A  79      33.104  17.870   1.482  1.00 20.74           C  
ATOM    573  O   ASN A  79      32.301  18.750   1.177  1.00 19.74           O  
ATOM    574  CB  ASN A  79      33.658  17.550  -0.976  1.00 21.73           C  
ATOM    575  CG  ASN A  79      32.452  16.706  -1.343  1.00 21.10           C  
ATOM    576  OD1 ASN A  79      31.818  16.939  -2.376  1.00 22.62           O  
ATOM    577  ND2 ASN A  79      32.130  15.722  -0.512  1.00 21.56           N  
ATOM    578  N   GLY A  80      33.148  17.313   2.689  1.00 19.40           N  
ATOM    579  CA  GLY A  80      32.253  17.739   3.748  1.00 18.27           C  
ATOM    580  C   GLY A  80      30.828  17.240   3.668  1.00 17.68           C  
ATOM    581  O   GLY A  80      29.907  17.921   4.124  1.00 16.57           O  
ATOM    582  N   CYS A  81      30.635  16.059   3.093  1.00 16.76           N  
ATOM    583  CA  CYS A  81      29.296  15.494   2.984  1.00 16.98           C  
ATOM    584  C   CYS A  81      29.233  14.136   3.680  1.00 15.39           C  
ATOM    585  O   CYS A  81      30.231  13.416   3.767  1.00 13.29           O  
ATOM    586  CB  CYS A  81      28.884  15.345   1.511  1.00 19.04           C  
ATOM    587  SG  CYS A  81      28.274  16.863   0.697  1.00 26.25           S  
ATOM    588  N   GLY A  82      28.052  13.801   4.184  1.00 13.10           N  
ATOM    589  CA  GLY A  82      27.871  12.532   4.852  1.00  9.35           C  
ATOM    590  C   GLY A  82      26.435  12.071   4.751  1.00  7.98           C  
ATOM    591  O   GLY A  82      25.535  12.865   4.510  1.00  9.89           O  
ATOM    592  N   ALA A  83      26.225  10.777   4.926  1.00  5.37           N  
ATOM    593  CA  ALA A  83      24.897  10.193   4.875  1.00  4.07           C  
ATOM    594  C   ALA A  83      24.873   9.095   5.937  1.00  5.97           C  
ATOM    595  O   ALA A  83      25.840   8.346   6.078  1.00  4.99           O  
ATOM    596  CB  ALA A  83      24.644   9.612   3.492  1.00  5.41           C  
ATOM    597  N   MET A  84      23.782   8.992   6.684  1.00  5.68           N  
ATOM    598  CA  MET A  84      23.711   7.989   7.735  1.00  6.41           C  
ATOM    599  C   MET A  84      22.364   7.299   7.856  1.00  7.91           C  
ATOM    600  O   MET A  84      21.324   7.900   7.613  1.00  4.25           O  
ATOM    601  CB  MET A  84      24.058   8.631   9.082  1.00  9.76           C  
ATOM    602  CG  MET A  84      23.105   9.741   9.513  1.00 12.94           C  
ATOM    603  SD  MET A  84      23.603  10.569  11.058  1.00 19.27           S  
ATOM    604  CE  MET A  84      22.452  11.984  11.073  1.00 15.88           C  
ATOM    605  N   PRO A  85      22.374   6.009   8.228  1.00  8.95           N  
ATOM    606  CA  PRO A  85      21.141   5.239   8.390  1.00 10.78           C  
ATOM    607  C   PRO A  85      20.753   5.249   9.876  1.00  9.53           C  
ATOM    608  O   PRO A  85      21.604   5.025  10.740  1.00  9.94           O  
ATOM    609  CB  PRO A  85      21.554   3.852   7.911  1.00 11.57           C  
ATOM    610  CG  PRO A  85      22.942   3.735   8.485  1.00  9.65           C  
ATOM    611  CD  PRO A  85      23.551   5.117   8.236  1.00 11.32           C  
ATOM    612  N   PHE A  86      19.491   5.522  10.185  1.00  8.96           N  
ATOM    613  CA  PHE A  86      19.076   5.532  11.584  1.00 10.32           C  
ATOM    614  C   PHE A  86      17.585   5.342  11.748  1.00 11.76           C  
ATOM    615  O   PHE A  86      16.804   5.559  10.815  1.00 11.70           O  
ATOM    616  CB  PHE A  86      19.518   6.837  12.272  1.00 10.95           C  
ATOM    617  CG  PHE A  86      18.837   8.081  11.738  1.00  9.97           C  
ATOM    618  CD1 PHE A  86      17.722   8.609  12.374  1.00 12.69           C  
ATOM    619  CD2 PHE A  86      19.324   8.726  10.601  1.00 12.57           C  
ATOM    620  CE1 PHE A  86      17.095   9.764  11.892  1.00 10.49           C  
ATOM    621  CE2 PHE A  86      18.710   9.882  10.103  1.00 12.65           C  
ATOM    622  CZ  PHE A  86      17.594  10.400  10.753  1.00 13.29           C  
ATOM    623  N   ARG A  87      17.196   4.930  12.942  1.00 13.86           N  
ATOM    624  CA  ARG A  87      15.797   4.703  13.246  1.00 18.35           C  
ATOM    625  C   ARG A  87      15.273   5.669  14.291  1.00 19.73           C  
ATOM    626  O   ARG A  87      15.952   5.964  15.277  1.00 18.53           O  
ATOM    627  CB  ARG A  87      15.587   3.274  13.739  1.00 20.73           C  
ATOM    628  CG  ARG A  87      14.297   3.104  14.515  1.00 24.83           C  
ATOM    629  CD  ARG A  87      14.001   1.654  14.732  1.00 30.89           C  
ATOM    630  NE  ARG A  87      13.688   1.004  13.467  1.00 38.14           N  
ATOM    631  CZ  ARG A  87      13.343  -0.274  13.348  1.00 42.43           C  
ATOM    632  NH1 ARG A  87      13.270  -1.047  14.426  1.00 42.67           N  
ATOM    633  NH2 ARG A  87      13.062  -0.779  12.150  1.00 45.14           N  
ATOM    634  N   VAL A  88      14.054   6.147  14.069  1.00 21.69           N  
ATOM    635  CA  VAL A  88      13.404   7.073  14.984  1.00 24.89           C  
ATOM    636  C   VAL A  88      12.196   6.384  15.593  1.00 29.06           C  
ATOM    637  O   VAL A  88      11.296   5.952  14.873  1.00 29.69           O  
ATOM    638  CB  VAL A  88      12.894   8.341  14.261  1.00 23.79           C  
ATOM    639  CG1 VAL A  88      12.220   9.273  15.262  1.00 23.81           C  
ATOM    640  CG2 VAL A  88      14.033   9.044  13.562  1.00 22.23           C  
ATOM    641  N   GLU A  89      12.175   6.271  16.916  1.00 32.78           N  
ATOM    642  CA  GLU A  89      11.041   5.655  17.588  1.00 37.77           C  
ATOM    643  C   GLU A  89      10.197   6.719  18.273  1.00 40.93           C  
ATOM    644  O   GLU A  89      10.727   7.696  18.804  1.00 41.33           O  
ATOM    645  CB  GLU A  89      11.513   4.638  18.625  1.00 37.63           C  
ATOM    646  CG  GLU A  89      11.924   3.314  18.045  1.00 39.25           C  
ATOM    647  CD  GLU A  89      12.227   2.297  19.119  1.00 41.24           C  
ATOM    648  OE1 GLU A  89      13.242   2.462  19.825  1.00 41.35           O  
ATOM    649  OE2 GLU A  89      11.441   1.337  19.262  1.00 43.21           O  
ATOM    650  N   MET A  90       8.882   6.533  18.257  1.00 45.13           N  
ATOM    651  CA  MET A  90       7.983   7.481  18.902  1.00 49.44           C  
ATOM    652  C   MET A  90       6.663   6.845  19.310  1.00 51.52           C  
ATOM    653  O   MET A  90       6.497   5.626  19.256  1.00 51.80           O  
ATOM    654  CB  MET A  90       7.697   8.666  17.981  1.00 50.02           C  
ATOM    655  CG  MET A  90       7.002   8.289  16.695  1.00 51.18           C  
ATOM    656  SD  MET A  90       8.162   7.899  15.390  1.00 53.58           S  
ATOM    657  CE  MET A  90       8.062   9.395  14.448  1.00 51.11           C  
ATOM    658  N   VAL A  91       5.727   7.692  19.723  1.00 54.80           N  
ATOM    659  CA  VAL A  91       4.407   7.248  20.138  1.00 57.57           C  
ATOM    660  C   VAL A  91       3.364   8.202  19.588  1.00 59.15           C  
ATOM    661  O   VAL A  91       3.043   9.210  20.212  1.00 59.03           O  
ATOM    662  CB  VAL A  91       4.283   7.214  21.665  1.00 57.39           C  
ATOM    663  CG1 VAL A  91       2.852   6.895  22.056  1.00 58.15           C  
ATOM    664  CG2 VAL A  91       5.230   6.175  22.235  1.00 57.31           C  
ATOM    665  N   TRP A  92       2.843   7.879  18.411  1.00 61.50           N  
ATOM    666  CA  TRP A  92       1.843   8.711  17.769  1.00 64.22           C  
ATOM    667  C   TRP A  92       0.448   8.456  18.329  1.00 64.83           C  
ATOM    668  O   TRP A  92      -0.029   7.319  18.345  1.00 65.63           O  
ATOM    669  CB  TRP A  92       1.860   8.470  16.263  1.00 66.50           C  
ATOM    670  CG  TRP A  92       0.881   9.313  15.522  1.00 69.82           C  
ATOM    671  CD1 TRP A  92       0.341  10.500  15.934  1.00 70.81           C  
ATOM    672  CD2 TRP A  92       0.353   9.063  14.218  1.00 71.30           C  
ATOM    673  NE1 TRP A  92      -0.490  11.005  14.963  1.00 71.82           N  
ATOM    674  CE2 TRP A  92      -0.501  10.143  13.898  1.00 71.88           C  
ATOM    675  CE3 TRP A  92       0.521   8.033  13.284  1.00 71.67           C  
ATOM    676  CZ2 TRP A  92      -1.187  10.221  12.685  1.00 72.80           C  
ATOM    677  CZ3 TRP A  92      -0.162   8.111  12.077  1.00 72.63           C  
ATOM    678  CH2 TRP A  92      -1.005   9.199  11.790  1.00 73.12           C  
ATOM    679  N   ASN A  93      -0.202   9.531  18.774  1.00 64.97           N  
ATOM    680  CA  ASN A  93      -1.540   9.470  19.358  1.00 64.29           C  
ATOM    681  C   ASN A  93      -1.750   8.216  20.192  1.00 63.70           C  
ATOM    682  O   ASN A  93      -2.699   7.459  19.981  1.00 63.73           O  
ATOM    683  CB  ASN A  93      -2.616   9.570  18.271  1.00 64.32           C  
ATOM    684  CG  ASN A  93      -2.874  11.006  17.836  1.00 64.14           C  
ATOM    685  OD1 ASN A  93      -1.984  11.684  17.324  1.00 63.58           O  
ATOM    686  ND2 ASN A  93      -4.098  11.474  18.046  1.00 64.00           N  
ATOM    687  N   GLY A  94      -0.842   8.009  21.143  1.00 62.80           N  
ATOM    688  CA  GLY A  94      -0.924   6.859  22.022  1.00 61.68           C  
ATOM    689  C   GLY A  94      -0.315   5.601  21.444  1.00 60.60           C  
ATOM    690  O   GLY A  94       0.102   4.711  22.187  1.00 60.70           O  
ATOM    691  N   GLN A  95      -0.249   5.523  20.119  1.00 59.33           N  
ATOM    692  CA  GLN A  95       0.301   4.341  19.471  1.00 58.02           C  
ATOM    693  C   GLN A  95       1.788   4.438  19.167  1.00 55.79           C  
ATOM    694  O   GLN A  95       2.262   5.428  18.603  1.00 55.13           O  
ATOM    695  CB  GLN A  95      -0.469   4.039  18.185  1.00 59.76           C  
ATOM    696  CG  GLN A  95      -0.212   2.645  17.638  1.00 61.72           C  
ATOM    697  CD  GLN A  95      -1.347   2.148  16.763  1.00 62.36           C  
ATOM    698  OE1 GLN A  95      -2.504   2.098  17.191  1.00 62.32           O  
ATOM    699  NE2 GLN A  95      -1.023   1.768  15.533  1.00 63.08           N  
ATOM    700  N   PRO A  96       2.548   3.403  19.552  1.00 53.63           N  
ATOM    701  CA  PRO A  96       3.995   3.329  19.338  1.00 51.91           C  
ATOM    702  C   PRO A  96       4.335   2.928  17.902  1.00 49.81           C  
ATOM    703  O   PRO A  96       3.689   2.046  17.328  1.00 51.27           O  
ATOM    704  CB  PRO A  96       4.430   2.274  20.348  1.00 52.78           C  
ATOM    705  CG  PRO A  96       3.271   1.328  20.334  1.00 52.87           C  
ATOM    706  CD  PRO A  96       2.083   2.267  20.369  1.00 53.10           C  
ATOM    707  N   CYS A  97       5.343   3.575  17.324  1.00 45.73           N  
ATOM    708  CA  CYS A  97       5.756   3.267  15.958  1.00 41.45           C  
ATOM    709  C   CYS A  97       7.182   3.714  15.668  1.00 37.72           C  
ATOM    710  O   CYS A  97       7.726   4.584  16.346  1.00 36.04           O  
ATOM    711  CB  CYS A  97       4.795   3.910  14.960  1.00 42.16           C  
ATOM    712  SG  CYS A  97       4.518   5.658  15.257  1.00 46.35           S  
ATOM    713  N   ALA A  98       7.781   3.105  14.649  1.00 34.28           N  
ATOM    714  CA  ALA A  98       9.149   3.413  14.264  1.00 30.38           C  
ATOM    715  C   ALA A  98       9.254   3.837  12.807  1.00 27.87           C  
ATOM    716  O   ALA A  98       8.519   3.354  11.943  1.00 26.42           O  
ATOM    717  CB  ALA A  98      10.041   2.210  14.517  1.00 29.82           C  
ATOM    718  N   LEU A  99      10.189   4.742  12.551  1.00 25.53           N  
ATOM    719  CA  LEU A  99      10.431   5.273  11.216  1.00 21.65           C  
ATOM    720  C   LEU A  99      11.905   5.064  10.857  1.00 20.82           C  
ATOM    721  O   LEU A  99      12.791   5.375  11.656  1.00 19.58           O  
ATOM    722  CB  LEU A  99      10.084   6.759  11.211  1.00 19.71           C  
ATOM    723  CG  LEU A  99      10.111   7.533   9.898  1.00 20.27           C  
ATOM    724  CD1 LEU A  99       9.223   6.838   8.861  1.00 18.18           C  
ATOM    725  CD2 LEU A  99       9.635   8.963  10.159  1.00 17.89           C  
ATOM    726  N   ASP A 100      12.163   4.509   9.671  1.00 19.40           N  
ATOM    727  CA  ASP A 100      13.529   4.265   9.208  1.00 17.45           C  
ATOM    728  C   ASP A 100      13.916   5.413   8.313  1.00 14.60           C  
ATOM    729  O   ASP A 100      13.269   5.662   7.303  1.00 15.48           O  
ATOM    730  CB  ASP A 100      13.618   2.962   8.421  1.00 18.79           C  
ATOM    731  CG  ASP A 100      13.399   1.752   9.285  1.00 20.73           C  
ATOM    732  OD1 ASP A 100      14.068   1.655  10.341  1.00 22.92           O  
ATOM    733  OD2 ASP A 100      12.565   0.902   8.908  1.00 20.35           O  
ATOM    734  N   VAL A 101      14.983   6.102   8.672  1.00 13.06           N  
ATOM    735  CA  VAL A 101      15.403   7.265   7.911  1.00 13.06           C  
ATOM    736  C   VAL A 101      16.871   7.263   7.544  1.00 13.26           C  
ATOM    737  O   VAL A 101      17.691   6.631   8.211  1.00 16.87           O  
ATOM    738  CB  VAL A 101      15.150   8.558   8.723  1.00 12.40           C  
ATOM    739  CG1 VAL A 101      15.497   9.786   7.883  1.00 13.42           C  
ATOM    740  CG2 VAL A 101      13.709   8.610   9.190  1.00 12.44           C  
ATOM    741  N   ILE A 102      17.189   7.954   6.455  1.00 11.73           N  
ATOM    742  CA  ILE A 102      18.570   8.138   6.047  1.00 10.07           C  
ATOM    743  C   ILE A 102      18.711   9.640   5.853  1.00 10.10           C  
ATOM    744  O   ILE A 102      17.916  10.251   5.139  1.00 10.42           O  
ATOM    745  CB  ILE A 102      18.940   7.413   4.733  1.00  9.53           C  
ATOM    746  CG1 ILE A 102      19.391   5.982   5.036  1.00  4.99           C  
ATOM    747  CG2 ILE A 102      20.103   8.136   4.038  1.00  5.72           C  
ATOM    748  CD1 ILE A 102      19.678   5.159   3.794  1.00  3.07           C  
ATOM    749  N   ASP A 103      19.701  10.226   6.526  1.00  9.38           N  
ATOM    750  CA  ASP A 103      19.983  11.658   6.445  1.00  8.74           C  
ATOM    751  C   ASP A 103      21.217  11.976   5.597  1.00 10.69           C  
ATOM    752  O   ASP A 103      22.229  11.278   5.689  1.00 12.21           O  
ATOM    753  CB  ASP A 103      20.235  12.196   7.840  1.00 10.20           C  
ATOM    754  CG  ASP A 103      18.992  12.753   8.492  1.00  8.87           C  
ATOM    755  OD1 ASP A 103      17.864  12.427   8.066  1.00 10.00           O  
ATOM    756  OD2 ASP A 103      19.162  13.521   9.450  1.00  6.47           O  
ATOM    757  N   VAL A 104      21.135  13.019   4.770  1.00 11.38           N  
ATOM    758  CA  VAL A 104      22.285  13.452   3.965  1.00 11.65           C  
ATOM    759  C   VAL A 104      22.544  14.915   4.293  1.00 10.90           C  
ATOM    760  O   VAL A 104      21.721  15.786   4.004  1.00  9.55           O  
ATOM    761  CB  VAL A 104      22.047  13.324   2.445  1.00 10.39           C  
ATOM    762  CG1 VAL A 104      23.276  13.801   1.703  1.00 10.96           C  
ATOM    763  CG2 VAL A 104      21.770  11.879   2.073  1.00  9.99           C  
ATOM    764  N   MET A 105      23.690  15.187   4.904  1.00 11.53           N  
ATOM    765  CA  MET A 105      24.014  16.549   5.298  1.00 12.06           C  
ATOM    766  C   MET A 105      25.260  17.075   4.626  1.00 13.53           C  
ATOM    767  O   MET A 105      26.144  16.316   4.261  1.00 13.10           O  
ATOM    768  CB  MET A 105      24.249  16.623   6.806  1.00 14.56           C  
ATOM    769  CG  MET A 105      23.259  15.861   7.667  1.00 12.02           C  
ATOM    770  SD  MET A 105      23.795  15.952   9.377  1.00 12.27           S  
ATOM    771  CE  MET A 105      22.226  16.424  10.159  1.00 11.48           C  
ATOM    772  N   ARG A 106      25.324  18.388   4.477  1.00 13.69           N  
ATOM    773  CA  ARG A 106      26.495  19.012   3.904  1.00 16.96           C  
ATOM    774  C   ARG A 106      26.943  20.049   4.908  1.00 17.67           C  
ATOM    775  O   ARG A 106      26.153  20.903   5.323  1.00 19.29           O  
ATOM    776  CB  ARG A 106      26.172  19.678   2.583  1.00 19.46           C  
ATOM    777  CG  ARG A 106      27.378  20.312   1.956  1.00 25.64           C  
ATOM    778  CD  ARG A 106      27.097  20.641   0.520  1.00 31.56           C  
ATOM    779  NE  ARG A 106      28.323  20.953  -0.202  1.00 37.84           N  
ATOM    780  CZ  ARG A 106      28.400  21.032  -1.525  1.00 40.92           C  
ATOM    781  NH1 ARG A 106      27.314  20.821  -2.267  1.00 42.59           N  
ATOM    782  NH2 ARG A 106      29.559  21.321  -2.104  1.00 42.74           N  
ATOM    783  N   PHE A 107      28.200  19.961   5.321  1.00 15.86           N  
ATOM    784  CA  PHE A 107      28.736  20.907   6.291  1.00 17.28           C  
ATOM    785  C   PHE A 107      29.408  22.097   5.617  1.00 17.17           C  
ATOM    786  O   PHE A 107      29.764  22.023   4.443  1.00 16.81           O  
ATOM    787  CB  PHE A 107      29.727  20.198   7.220  1.00 14.11           C  
ATOM    788  CG  PHE A 107      29.091  19.160   8.102  1.00 14.46           C  
ATOM    789  CD1 PHE A 107      28.861  17.873   7.630  1.00 14.37           C  
ATOM    790  CD2 PHE A 107      28.682  19.485   9.387  1.00 13.47           C  
ATOM    791  CE1 PHE A 107      28.229  16.922   8.430  1.00 17.30           C  
ATOM    792  CE2 PHE A 107      28.047  18.547  10.202  1.00 16.16           C  
ATOM    793  CZ  PHE A 107      27.818  17.258   9.725  1.00 16.85           C  
ATOM    794  N   ASP A 108      29.569  23.193   6.361  1.00 19.10           N  
ATOM    795  CA  ASP A 108      30.224  24.388   5.830  1.00 20.87           C  
ATOM    796  C   ASP A 108      31.645  24.511   6.381  1.00 23.51           C  
ATOM    797  O   ASP A 108      32.078  23.685   7.192  1.00 23.07           O  
ATOM    798  CB  ASP A 108      29.410  25.656   6.154  1.00 19.60           C  
ATOM    799  CG  ASP A 108      29.414  26.025   7.642  1.00 19.20           C  
ATOM    800  OD1 ASP A 108      28.598  26.894   8.014  1.00 18.08           O  
ATOM    801  OD2 ASP A 108      30.209  25.477   8.440  1.00 17.44           O  
ATOM    802  N   GLU A 109      32.369  25.540   5.944  1.00 26.89           N  
ATOM    803  CA  GLU A 109      33.749  25.746   6.377  1.00 29.81           C  
ATOM    804  C   GLU A 109      33.903  25.998   7.867  1.00 30.34           C  
ATOM    805  O   GLU A 109      34.998  26.308   8.333  1.00 31.71           O  
ATOM    806  CB  GLU A 109      34.408  26.889   5.583  1.00 32.58           C  
ATOM    807  CG  GLU A 109      33.702  28.245   5.624  1.00 37.57           C  
ATOM    808  CD  GLU A 109      32.419  28.278   4.802  1.00 40.76           C  
ATOM    809  OE1 GLU A 109      32.431  27.779   3.656  1.00 43.30           O  
ATOM    810  OE2 GLU A 109      31.401  28.815   5.295  1.00 43.53           O  
ATOM    811  N   HIS A 110      32.814  25.858   8.618  1.00 29.10           N  
ATOM    812  CA  HIS A 110      32.853  26.071  10.059  1.00 28.43           C  
ATOM    813  C   HIS A 110      32.396  24.841  10.813  1.00 26.47           C  
ATOM    814  O   HIS A 110      32.333  24.857  12.035  1.00 27.45           O  
ATOM    815  CB  HIS A 110      31.977  27.260  10.459  1.00 30.20           C  
ATOM    816  CG  HIS A 110      32.389  28.547   9.818  1.00 35.28           C  
ATOM    817  ND1 HIS A 110      32.036  28.884   8.528  1.00 37.58           N  
ATOM    818  CD2 HIS A 110      33.181  29.550  10.264  1.00 36.02           C  
ATOM    819  CE1 HIS A 110      32.594  30.038   8.207  1.00 36.85           C  
ATOM    820  NE2 HIS A 110      33.295  30.462   9.242  1.00 37.72           N  
ATOM    821  N   GLY A 111      32.075  23.779  10.083  1.00 24.42           N  
ATOM    822  CA  GLY A 111      31.626  22.557  10.720  1.00 22.02           C  
ATOM    823  C   GLY A 111      30.154  22.602  11.095  1.00 20.60           C  
ATOM    824  O   GLY A 111      29.688  21.843  11.949  1.00 17.18           O  
ATOM    825  N   ARG A 112      29.416  23.509  10.470  1.00 18.57           N  
ATOM    826  CA  ARG A 112      28.002  23.606  10.751  1.00 19.21           C  
ATOM    827  C   ARG A 112      27.230  22.998   9.588  1.00 17.55           C  
ATOM    828  O   ARG A 112      27.659  23.076   8.436  1.00 17.91           O  
ATOM    829  CB  ARG A 112      27.594  25.066  10.946  1.00 22.22           C  
ATOM    830  CG  ARG A 112      28.224  25.726  12.159  1.00 29.19           C  
ATOM    831  CD  ARG A 112      27.466  26.993  12.550  1.00 34.79           C  
ATOM    832  NE  ARG A 112      28.280  28.204  12.455  1.00 39.70           N  
ATOM    833  CZ  ARG A 112      29.353  28.450  13.201  1.00 42.15           C  
ATOM    834  NH1 ARG A 112      29.752  27.564  14.106  1.00 43.99           N  
ATOM    835  NH2 ARG A 112      30.027  29.586  13.045  1.00 42.84           N  
ATOM    836  N   ILE A 113      26.100  22.376   9.896  1.00 15.25           N  
ATOM    837  CA  ILE A 113      25.272  21.775   8.867  1.00 13.82           C  
ATOM    838  C   ILE A 113      24.740  22.921   8.032  1.00 14.06           C  
ATOM    839  O   ILE A 113      24.069  23.804   8.555  1.00 13.06           O  
ATOM    840  CB  ILE A 113      24.083  21.029   9.472  1.00 14.27           C  
ATOM    841  CG1 ILE A 113      24.584  19.948  10.432  1.00 13.82           C  
ATOM    842  CG2 ILE A 113      23.234  20.427   8.356  1.00 13.33           C  
ATOM    843  CD1 ILE A 113      23.493  19.352  11.302  1.00 15.65           C  
ATOM    844  N   GLN A 114      25.049  22.913   6.742  1.00 15.95           N  
ATOM    845  CA  GLN A 114      24.593  23.969   5.842  1.00 15.96           C  
ATOM    846  C   GLN A 114      23.302  23.562   5.150  1.00 16.25           C  
ATOM    847  O   GLN A 114      22.416  24.378   4.901  1.00 16.91           O  
ATOM    848  CB  GLN A 114      25.660  24.253   4.800  1.00 17.68           C  
ATOM    849  CG  GLN A 114      25.393  25.489   3.992  1.00 26.30           C  
ATOM    850  CD  GLN A 114      26.395  25.649   2.877  1.00 31.42           C  
ATOM    851  OE1 GLN A 114      26.422  24.854   1.928  1.00 35.60           O  
ATOM    852  NE2 GLN A 114      27.244  26.674   2.983  1.00 34.62           N  
ATOM    853  N   THR A 115      23.202  22.291   4.814  1.00 15.52           N  
ATOM    854  CA  THR A 115      22.004  21.805   4.172  1.00 16.16           C  
ATOM    855  C   THR A 115      21.842  20.367   4.610  1.00 15.49           C  
ATOM    856  O   THR A 115      22.826  19.649   4.779  1.00 13.99           O  
ATOM    857  CB  THR A 115      22.100  21.913   2.648  1.00 14.78           C  
ATOM    858  OG1 THR A 115      20.990  21.232   2.059  1.00 21.23           O  
ATOM    859  CG2 THR A 115      23.380  21.309   2.148  1.00 19.31           C  
ATOM    860  N   MET A 116      20.595  19.957   4.809  1.00 15.27           N  
ATOM    861  CA  MET A 116      20.303  18.619   5.279  1.00 15.14           C  
ATOM    862  C   MET A 116      19.058  18.077   4.586  1.00 14.38           C  
ATOM    863  O   MET A 116      18.076  18.795   4.415  1.00 14.79           O  
ATOM    864  CB  MET A 116      20.100  18.683   6.797  1.00 18.25           C  
ATOM    865  CG  MET A 116      19.881  17.353   7.480  1.00 24.57           C  
ATOM    866  SD  MET A 116      18.182  17.125   8.012  1.00 31.79           S  
ATOM    867  CE  MET A 116      18.324  17.419   9.744  1.00 26.90           C  
ATOM    868  N   GLN A 117      19.100  16.814   4.183  1.00 13.38           N  
ATOM    869  CA  GLN A 117      17.962  16.193   3.509  1.00 13.31           C  
ATOM    870  C   GLN A 117      17.637  14.861   4.156  1.00 12.48           C  
ATOM    871  O   GLN A 117      18.518  14.030   4.366  1.00 13.10           O  
ATOM    872  CB  GLN A 117      18.272  15.967   2.036  1.00 16.57           C  
ATOM    873  CG  GLN A 117      18.635  17.225   1.286  1.00 20.74           C  
ATOM    874  CD  GLN A 117      19.112  16.929  -0.115  1.00 22.63           C  
ATOM    875  OE1 GLN A 117      20.083  16.197  -0.308  1.00 23.89           O  
ATOM    876  NE2 GLN A 117      18.436  17.501  -1.110  1.00 25.24           N  
ATOM    877  N   ALA A 118      16.363  14.655   4.452  1.00 11.90           N  
ATOM    878  CA  ALA A 118      15.929  13.437   5.094  1.00 12.06           C  
ATOM    879  C   ALA A 118      15.146  12.574   4.130  1.00 13.53           C  
ATOM    880  O   ALA A 118      14.162  13.014   3.546  1.00 14.00           O  
ATOM    881  CB  ALA A 118      15.081  13.776   6.294  1.00 14.22           C  
ATOM    882  N   PHE A 119      15.584  11.337   3.957  1.00 13.07           N  
ATOM    883  CA  PHE A 119      14.884  10.451   3.060  1.00 12.61           C  
ATOM    884  C   PHE A 119      14.033   9.465   3.842  1.00 13.10           C  
ATOM    885  O   PHE A 119      14.542   8.702   4.663  1.00 13.37           O  
ATOM    886  CB  PHE A 119      15.876   9.716   2.158  1.00 13.31           C  
ATOM    887  CG  PHE A 119      16.568  10.615   1.158  1.00 14.55           C  
ATOM    888  CD1 PHE A 119      17.613  11.441   1.549  1.00 14.00           C  
ATOM    889  CD2 PHE A 119      16.158  10.644  -0.170  1.00 14.32           C  
ATOM    890  CE1 PHE A 119      18.242  12.286   0.637  1.00 14.96           C  
ATOM    891  CE2 PHE A 119      16.782  11.489  -1.094  1.00 16.83           C  
ATOM    892  CZ  PHE A 119      17.827  12.312  -0.686  1.00 14.22           C  
ATOM    893  N   TRP A 120      12.725   9.511   3.589  1.00 13.56           N  
ATOM    894  CA  TRP A 120      11.759   8.625   4.233  1.00 13.19           C  
ATOM    895  C   TRP A 120      10.349   8.952   3.762  1.00 14.80           C  
ATOM    896  O   TRP A 120      10.084  10.050   3.274  1.00 15.16           O  
ATOM    897  CB  TRP A 120      11.806   8.754   5.763  1.00 11.84           C  
ATOM    898  CG  TRP A 120      11.353  10.093   6.302  1.00 12.54           C  
ATOM    899  CD1 TRP A 120      12.134  11.185   6.549  1.00 11.13           C  
ATOM    900  CD2 TRP A 120      10.010  10.478   6.640  1.00 13.76           C  
ATOM    901  NE1 TRP A 120      11.365  12.222   7.018  1.00 10.80           N  
ATOM    902  CE2 TRP A 120      10.059  11.817   7.083  1.00 12.15           C  
ATOM    903  CE3 TRP A 120       8.771   9.821   6.611  1.00 13.82           C  
ATOM    904  CZ2 TRP A 120       8.916  12.515   7.494  1.00 14.28           C  
ATOM    905  CZ3 TRP A 120       7.631  10.518   7.019  1.00 15.28           C  
ATOM    906  CH2 TRP A 120       7.716  11.852   7.454  1.00 14.84           C  
ATOM    907  N   SER A 121       9.454   7.981   3.893  1.00 15.80           N  
ATOM    908  CA  SER A 121       8.057   8.162   3.531  1.00 17.31           C  
ATOM    909  C   SER A 121       7.278   7.122   4.314  1.00 18.02           C  
ATOM    910  O   SER A 121       7.845   6.409   5.142  1.00 19.73           O  
ATOM    911  CB  SER A 121       7.838   7.969   2.030  1.00 16.11           C  
ATOM    912  OG  SER A 121       7.938   6.603   1.673  1.00 17.13           O  
ATOM    913  N   GLU A 122       5.985   7.017   4.043  1.00 19.80           N  
ATOM    914  CA  GLU A 122       5.145   6.069   4.759  1.00 21.42           C  
ATOM    915  C   GLU A 122       5.631   4.627   4.674  1.00 20.82           C  
ATOM    916  O   GLU A 122       5.456   3.860   5.618  1.00 21.32           O  
ATOM    917  CB  GLU A 122       3.694   6.165   4.264  1.00 22.27           C  
ATOM    918  CG  GLU A 122       3.135   7.582   4.283  1.00 26.71           C  
ATOM    919  CD  GLU A 122       3.418   8.356   2.994  1.00 28.92           C  
ATOM    920  OE1 GLU A 122       4.421   8.041   2.312  1.00 29.31           O  
ATOM    921  OE2 GLU A 122       2.640   9.287   2.671  1.00 28.81           O  
ATOM    922  N   VAL A 123       6.256   4.260   3.560  1.00 20.72           N  
ATOM    923  CA  VAL A 123       6.728   2.888   3.393  1.00 21.37           C  
ATOM    924  C   VAL A 123       7.797   2.484   4.407  1.00 21.25           C  
ATOM    925  O   VAL A 123       8.125   1.309   4.534  1.00 21.85           O  
ATOM    926  CB  VAL A 123       7.272   2.646   1.960  1.00 22.55           C  
ATOM    927  CG1 VAL A 123       6.140   2.783   0.942  1.00 22.26           C  
ATOM    928  CG2 VAL A 123       8.393   3.632   1.648  1.00 23.10           C  
ATOM    929  N   ASN A 124       8.326   3.460   5.136  1.00 22.44           N  
ATOM    930  CA  ASN A 124       9.353   3.192   6.138  1.00 21.84           C  
ATOM    931  C   ASN A 124       8.787   3.303   7.536  1.00 24.52           C  
ATOM    932  O   ASN A 124       9.489   3.066   8.518  1.00 23.65           O  
ATOM    933  CB  ASN A 124      10.502   4.178   6.002  1.00 18.27           C  
ATOM    934  CG  ASN A 124      11.125   4.142   4.645  1.00 16.89           C  
ATOM    935  OD1 ASN A 124      11.025   5.104   3.879  1.00 19.55           O  
ATOM    936  ND2 ASN A 124      11.770   3.026   4.321  1.00 12.84           N  
ATOM    937  N   LEU A 125       7.516   3.674   7.615  1.00 27.24           N  
ATOM    938  CA  LEU A 125       6.831   3.833   8.889  1.00 30.07           C  
ATOM    939  C   LEU A 125       6.258   2.503   9.364  1.00 32.03           C  
ATOM    940  O   LEU A 125       5.263   2.027   8.827  1.00 33.60           O  
ATOM    941  CB  LEU A 125       5.710   4.864   8.727  1.00 30.77           C  
ATOM    942  CG  LEU A 125       4.970   5.394   9.952  1.00 30.76           C  
ATOM    943  CD1 LEU A 125       4.128   6.569   9.510  1.00 29.94           C  
ATOM    944  CD2 LEU A 125       4.106   4.309  10.588  1.00 31.15           C  
ATOM    945  N   SER A 126       6.890   1.903  10.367  1.00 33.51           N  
ATOM    946  CA  SER A 126       6.422   0.634  10.914  1.00 35.64           C  
ATOM    947  C   SER A 126       5.676   0.923  12.205  1.00 36.90           C  
ATOM    948  O   SER A 126       6.294   1.236  13.219  1.00 37.24           O  
ATOM    949  CB  SER A 126       7.601  -0.291  11.233  1.00 36.76           C  
ATOM    950  OG  SER A 126       8.444  -0.472  10.111  1.00 40.32           O  
ATOM    951  N   VAL A 127       4.354   0.825  12.184  1.00 37.95           N  
ATOM    952  CA  VAL A 127       3.599   1.091  13.398  1.00 39.66           C  
ATOM    953  C   VAL A 127       3.017  -0.182  13.990  1.00 38.99           C  
ATOM    954  O   VAL A 127       3.635  -0.798  14.860  1.00 39.03           O  
ATOM    955  CB  VAL A 127       2.461   2.099  13.147  1.00 40.51           C  
ATOM    956  CG1 VAL A 127       1.499   1.556  12.110  1.00 42.17           C  
ATOM    957  CG2 VAL A 127       1.740   2.391  14.454  1.00 42.17           C  
TER     958      VAL A 127                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
