
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 (  997),  selected  126 , name 1qma_A
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 1qma_A.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     2_A      M       1           -
LGA    D     3_A      -       -           -
LGA    K     4_A      M       2           #
LGA    P     5_A      T       3          2.921
LGA    -       -      H       4           -
LGA    -       -      Y       5           -
LGA    -       -      S       6           -
LGA    I     6_A      D       7          1.237
LGA    -       -      N       8           -
LGA    A     7_A      T       9          3.529
LGA    E     8_A      L      10          3.156
LGA    Q     9_A      K      11          3.198
LGA    I    10_A      V      12          3.366
LGA    G    11_A      A      13          2.916
LGA    S    12_A      H      14          2.479
LGA    S    13_A      Q      15          3.094
LGA    F    14_A      G      16          2.866
LGA    I    15_A      F      17          1.938
LGA    Q    16_A      E      18          2.262
LGA    H    17_A      F      19          3.027
LGA    Y    18_A      F      20          2.564
LGA    Y    19_A      T      21          1.531
LGA    Q    20_A      Q      22          2.203
LGA    L    21_A      G      23          3.299
LGA    F    22_A      L      24          3.146
LGA    D    23_A      A      25          1.959
LGA    N    24_A      T      26          2.126
LGA    D    25_A      G      27          3.197
LGA    R    26_A      E      28          3.500
LGA    T    27_A      W      29          3.187
LGA    Q    28_A      Q      30          1.251
LGA    -       -      K      31           -
LGA    L    29_A      F      32          3.013
LGA    G    30_A      L      33          2.007
LGA    A    31_A      D      34          1.121
LGA    I    32_A      M      35          1.914
LGA    Y    33_A      L      36          1.773
LGA    I    34_A      T      37          2.546
LGA    D    35_A      E      38          2.369
LGA    A    36_A      D      39          0.737
LGA    S    37_A      F      40          0.743
LGA    C    38_A      T      41          0.579
LGA    L    39_A      F      42          0.886
LGA    T    40_A      W      43          1.048
LGA    W    41_A      F      44          1.980
LGA    E    42_A      P      45          2.399
LGA    -       -      M      46           -
LGA    -       -      G      47           -
LGA    -       -      E      48           -
LGA    G    43_A      F      49           #
LGA    Q    44_A      H      50          1.248
LGA    Q    45_A      G      51          3.034
LGA    -       -      L      52           -
LGA    F    46_A      N      53          1.449
LGA    Q    47_A      V      54          0.630
LGA    G    48_A      G      55          0.451
LGA    K    49_A      K      56          0.413
LGA    A    50_A      E      57          0.257
LGA    A    51_A      R      58          0.712
LGA    I    52_A      A      59          1.052
LGA    V    53_A      K      60          0.601
LGA    E    54_A      E      61          0.626
LGA    K    55_A      F      62          1.332
LGA    L    56_A      F      63          1.131
LGA    S    57_A      T      64          0.485
LGA    S    58_A      Y      65          1.688
LGA    L    59_A      V      66          2.398
LGA    -       -      S      67           -
LGA    -       -      E      68           -
LGA    P    60_A      S      69          2.560
LGA    F    61_A      F      70          1.810
LGA    Q    62_A      H      71          1.831
LGA    K    63_A      T      72          2.586
LGA    I    64_A      G      73          2.700
LGA    -       -      I      74           -
LGA    Q    65_A      Q      75          0.981
LGA    H    66_A      I      76          1.701
LGA    S    67_A      S      77          3.495
LGA    -       -      S      78           -
LGA    I    68_A      L      79          1.446
LGA    T    69_A      D      80          1.448
LGA    A    70_A      R      81          1.361
LGA    Q    71_A      V      82          1.116
LGA    D    72_A      T      83          1.179
LGA    H    73_A      S      84          2.259
LGA    Q    74_A      N      85          2.099
LGA    P    75_A      E      86          1.510
LGA    T    76_A      -       -           -
LGA    P    77_A      -       -           -
LGA    D    78_A      -       -           -
LGA    S    79_A      -       -           -
LGA    C    80_A      -       -           -
LGA    I    81_A      T      87          2.651
LGA    I    82_A      T      88          0.812
LGA    S    83_A      V      89          0.447
LGA    M    84_A      V      90          0.627
LGA    V    85_A      F      91          0.966
LGA    V    86_A      E      92          0.742
LGA    G    87_A      F      93          0.805
LGA    Q    88_A      R      94          0.896
LGA    L    89_A      D      95          0.970
LGA    K    90_A      E      96          0.694
LGA    A    91_A      G      97          1.963
LGA    D    92_A      L      98          1.276
LGA    E    93_A      F      99          5.750
LGA    -       -      L     100           -
LGA    -       -      G     101           -
LGA    -       -      K     102           -
LGA    D    94_A      P     103          1.553
LGA    P    95_A      Y     104          3.380
LGA    I    96_A      K     105          1.919
LGA    M    97_A      N     106          1.005
LGA    G    98_A      R     107          0.738
LGA    F    99_A      V     108          0.874
LGA    H   100_A      A     109          0.981
LGA    Q   101_A      V     110          0.583
LGA    M   102_A      S     111          0.371
LGA    F   103_A      F     112          0.379
LGA    L   104_A      D     113          0.408
LGA    L   105_A      V     114          0.963
LGA    K   106_A      R     115          0.320
LGA    N   107_A      G     116          1.185
LGA    I   108_A      -       -           -
LGA    N   109_A      -       -           -
LGA    D   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    W   112_A      D     117          1.376
LGA    V   113_A      K     118          1.397
LGA    C   114_A      I     119          1.272
LGA    T   115_A      C     120          0.791
LGA    N   116_A      S     121          0.729
LGA    D   117_A      Y     122          0.197
LGA    M   118_A      R     123          0.698
LGA    F   119_A      E     124          1.180
LGA    R   120_A      Y     125          2.275
LGA    L   121_A      F     126          2.473
LGA    A   122_A      G     127          2.617
LGA    L   123_A      S     128          4.203
LGA    H   124_A      D     129          2.403
LGA    -       -      G     130           -
LGA    N   125_A      K     131          3.657
LGA    F   126_A      S     132          3.626
LGA    G   127_A      N     133           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126  133    5.0    112    2.05     8.04     71.462     5.206

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.940331 * X  +   0.013468 * Y  +   0.339995 * Z  +  14.596189
  Y_new =  -0.149175 * X  +   0.914387 * Y  +   0.376356 * Z  +  10.749694
  Z_new =  -0.305819 * X  +  -0.404618 * Y  +   0.861835 * Z  +   0.802456 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.438938    2.702655  [ DEG:   -25.1493    154.8507 ]
  Theta =   0.310798    2.830795  [ DEG:    17.8074    162.1926 ]
  Phi   =  -0.157330    2.984263  [ DEG:    -9.0143    170.9857 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1qma_A                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1qma_A.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126  133   5.0  112   2.05    8.04  71.462
REMARK  ---------------------------------------------------------- 
MOLECULE 1qma_A
HEADER    TRANSPORT                               23-SEP-99   1QMA              
TITLE     NUCLEAR TRANSPORT FACTOR 2 (NTF2) W7A MUTANT                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NUCLEAR TRANSPORT FACTOR 2;                                
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: NTF2, PLACENTAL PROTEIN 15, PP15;                           
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 ORGAN: LIVER;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET VECTOR                                
KEYWDS    TRANSPORT                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.BAYLISS,K.RIBBECK,D.AKIN,H.M.KENT,C.M.FELDHERR,D.GORLICH,           
AUTHOR   2 M.J.STEWART                                                          
REVDAT   4   01-APR-03 1QMA    1       JRNL                                     
REVDAT   3   03-JUL-00 1QMA    1       JRNL                                     
REVDAT   2   30-APR-00 1QMA    1       REMARK                                   
REVDAT   1   03-FEB-00 1QMA    0                                                
JRNL        AUTH   R.BAYLISS,K.RIBBECK,D.AKIN,H.M.KENT,C.M.FELDHERR,            
JRNL        AUTH 2 D.GORLICH,M.STEWART                                          
JRNL        TITL   INTERACTION BETWEEN NTF2 AND XFXFG-CONTAINING                
JRNL        TITL 2 NUCLEOPORINS IS REQUIRED TO MEDIATE NUCLEAR IMPORT           
JRNL        TITL 3 OF RANGDP.                                                   
JRNL        REF    J.MOL.BIOL.                   V. 293   579 1999              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1QMA A    2   127  UNP    P61972   NTF2_RAT         2    127             
DBREF  1QMA B    2   127  UNP    P61972   NTF2_RAT         2    127             
DBREF  1QMA C    2   127  UNP    P61972   NTF2_RAT         2    127             
DBREF  1QMA D    2   127  UNP    P61972   NTF2_RAT         2    127             
SEQRES   1 A  126  GLY ASP LYS PRO ILE ALA GLU GLN ILE GLY SER SER PHE          
SEQRES   2 A  126  ILE GLN HIS TYR TYR GLN LEU PHE ASP ASN ASP ARG THR          
SEQRES   3 A  126  GLN LEU GLY ALA ILE TYR ILE ASP ALA SER CYS LEU THR          
SEQRES   4 A  126  TRP GLU GLY GLN GLN PHE GLN GLY LYS ALA ALA ILE VAL          
SEQRES   5 A  126  GLU LYS LEU SER SER LEU PRO PHE GLN LYS ILE GLN HIS          
SEQRES   6 A  126  SER ILE THR ALA GLN ASP HIS GLN PRO THR PRO ASP SER          
SEQRES   7 A  126  CYS ILE ILE SER MET VAL VAL GLY GLN LEU LYS ALA ASP          
SEQRES   8 A  126  GLU ASP PRO ILE MET GLY PHE HIS GLN MET PHE LEU LEU          
SEQRES   9 A  126  LYS ASN ILE ASN ASP ALA TRP VAL CYS THR ASN ASP MET          
SEQRES  10 A  126  PHE ARG LEU ALA LEU HIS ASN PHE GLY                          
SEQRES   1 B  126  GLY ASP LYS PRO ILE ALA GLU GLN ILE GLY SER SER PHE          
SEQRES   2 B  126  ILE GLN HIS TYR TYR GLN LEU PHE ASP ASN ASP ARG THR          
SEQRES   3 B  126  GLN LEU GLY ALA ILE TYR ILE ASP ALA SER CYS LEU THR          
SEQRES   4 B  126  TRP GLU GLY GLN GLN PHE GLN GLY LYS ALA ALA ILE VAL          
SEQRES   5 B  126  GLU LYS LEU SER SER LEU PRO PHE GLN LYS ILE GLN HIS          
SEQRES   6 B  126  SER ILE THR ALA GLN ASP HIS GLN PRO THR PRO ASP SER          
SEQRES   7 B  126  CYS ILE ILE SER MET VAL VAL GLY GLN LEU LYS ALA ASP          
SEQRES   8 B  126  GLU ASP PRO ILE MET GLY PHE HIS GLN MET PHE LEU LEU          
SEQRES   9 B  126  LYS ASN ILE ASN ASP ALA TRP VAL CYS THR ASN ASP MET          
SEQRES  10 B  126  PHE ARG LEU ALA LEU HIS ASN PHE GLY                          
SEQRES   1 C  126  GLY ASP LYS PRO ILE ALA GLU GLN ILE GLY SER SER PHE          
SEQRES   2 C  126  ILE GLN HIS TYR TYR GLN LEU PHE ASP ASN ASP ARG THR          
SEQRES   3 C  126  GLN LEU GLY ALA ILE TYR ILE ASP ALA SER CYS LEU THR          
SEQRES   4 C  126  TRP GLU GLY GLN GLN PHE GLN GLY LYS ALA ALA ILE VAL          
SEQRES   5 C  126  GLU LYS LEU SER SER LEU PRO PHE GLN LYS ILE GLN HIS          
SEQRES   6 C  126  SER ILE THR ALA GLN ASP HIS GLN PRO THR PRO ASP SER          
SEQRES   7 C  126  CYS ILE ILE SER MET VAL VAL GLY GLN LEU LYS ALA ASP          
SEQRES   8 C  126  GLU ASP PRO ILE MET GLY PHE HIS GLN MET PHE LEU LEU          
SEQRES   9 C  126  LYS ASN ILE ASN ASP ALA TRP VAL CYS THR ASN ASP MET          
SEQRES  10 C  126  PHE ARG LEU ALA LEU HIS ASN PHE GLY                          
SEQRES   1 D  126  GLY ASP LYS PRO ILE ALA GLU GLN ILE GLY SER SER PHE          
SEQRES   2 D  126  ILE GLN HIS TYR TYR GLN LEU PHE ASP ASN ASP ARG THR          
SEQRES   3 D  126  GLN LEU GLY ALA ILE TYR ILE ASP ALA SER CYS LEU THR          
SEQRES   4 D  126  TRP GLU GLY GLN GLN PHE GLN GLY LYS ALA ALA ILE VAL          
SEQRES   5 D  126  GLU LYS LEU SER SER LEU PRO PHE GLN LYS ILE GLN HIS          
SEQRES   6 D  126  SER ILE THR ALA GLN ASP HIS GLN PRO THR PRO ASP SER          
SEQRES   7 D  126  CYS ILE ILE SER MET VAL VAL GLY GLN LEU LYS ALA ASP          
SEQRES   8 D  126  GLU ASP PRO ILE MET GLY PHE HIS GLN MET PHE LEU LEU          
SEQRES   9 D  126  LYS ASN ILE ASN ASP ALA TRP VAL CYS THR ASN ASP MET          
SEQRES  10 D  126  PHE ARG LEU ALA LEU HIS ASN PHE GLY                          
FORMUL   5  HOH   *84(H2 O)                                                     
CRYST1   64.652   75.407   64.543  90.00 115.00  90.00 P 1 21 1      8          
ATOM      1  N   GLY A   2      46.945   8.405  10.083  0.00 44.06           N  
ATOM      2  CA  GLY A   2      47.267   8.413  11.493  0.00 38.61           C  
ATOM      3  C   GLY A   2      46.212   7.694  12.299  0.00 51.20           C  
ATOM      4  O   GLY A   2      46.192   7.686  13.539  0.00 51.80           O  
ATOM      5  N   ASP A   3      45.341   7.093  11.500  0.00 50.00           N  
ATOM      6  CA  ASP A   3      44.186   6.317  11.880  0.00 45.09           C  
ATOM      7  C   ASP A   3      42.878   6.826  11.281  0.00 38.39           C  
ATOM      8  O   ASP A   3      42.623   6.570  10.113  0.00 40.71           O  
ATOM      9  CB  ASP A   3      44.177   5.717  13.305  0.00 49.59           C  
ATOM     10  CG  ASP A   3      44.820   4.346  13.386  0.00 72.86           C  
ATOM     11  OD1 ASP A   3      45.685   4.136  12.412  0.00 84.79           O  
ATOM     12  OD2 ASP A   3      44.563   3.508  14.249  0.00 70.57           O  
ATOM     13  N   LYS A   4      41.897   6.372  12.288  0.00 27.70           N  
ATOM     14  CA  LYS A   4      40.610   6.883  11.808  0.00 19.74           C  
ATOM     15  C   LYS A   4      40.652   8.365  11.210  0.00 25.29           C  
ATOM     16  O   LYS A   4      41.224   9.292  11.821  0.00 25.47           O  
ATOM     17  CB  LYS A   4      39.579   6.776  12.911  0.00 25.80           C  
ATOM     18  CG  LYS A   4      38.639   5.582  12.732  0.00 71.46           C  
ATOM     19  CD  LYS A   4      37.927   5.182  14.024  0.00 73.48           C  
ATOM     20  CE  LYS A   4      37.671   3.676  14.126  0.00100.00           C  
ATOM     21  NZ  LYS A   4      36.950   3.296  15.349  0.00100.00           N  
ATOM     22  N   PRO A   5      39.828   8.673   9.907  1.00 54.32           N  
ATOM     23  CA  PRO A   5      39.845   9.842   9.045  1.00 53.90           C  
ATOM     24  C   PRO A   5      39.051  11.013   9.605  1.00 49.96           C  
ATOM     25  O   PRO A   5      38.056  10.857  10.304  1.00 50.10           O  
ATOM     26  CB  PRO A   5      39.204   9.426   7.731  1.00 56.00           C  
ATOM     27  CG  PRO A   5      38.945   7.961   7.828  1.00 55.43           C  
ATOM     28  CD  PRO A   5      39.065   7.562   9.263  1.00 54.49           C  
ATOM     29  N   ILE A   6      39.470  12.198   9.219  1.00 45.31           N  
ATOM     30  CA  ILE A   6      38.903  13.450   9.685  1.00 51.28           C  
ATOM     31  C   ILE A   6      37.434  13.607   9.436  1.00 51.77           C  
ATOM     32  O   ILE A   6      36.674  13.850  10.407  1.00 54.06           O  
ATOM     33  CB  ILE A   6      39.825  14.618   9.289  1.00 53.95           C  
ATOM     34  CG1 ILE A   6      39.209  15.968   9.546  1.00 53.90           C  
ATOM     35  CG2 ILE A   6      40.414  14.406   7.906  1.00 53.08           C  
ATOM     36  CD1 ILE A   6      38.363  16.614   8.482  1.00 64.80           C  
ATOM     37  N   ALA A   7      36.883  13.351   8.237  1.00 46.75           N  
ATOM     38  CA  ALA A   7      35.461  13.416   7.939  1.00 39.89           C  
ATOM     39  C   ALA A   7      34.635  12.466   8.784  1.00 40.53           C  
ATOM     40  O   ALA A   7      33.590  12.788   9.375  1.00 38.08           O  
ATOM     41  CB  ALA A   7      35.128  13.028   6.501  1.00 35.92           C  
ATOM     42  N   GLU A   8      35.107  11.225   8.954  1.00 38.70           N  
ATOM     43  CA  GLU A   8      34.491  10.245   9.794  1.00 37.93           C  
ATOM     44  C   GLU A   8      34.504  10.688  11.240  1.00 37.04           C  
ATOM     45  O   GLU A   8      33.460  10.549  11.889  1.00 36.58           O  
ATOM     46  CB  GLU A   8      35.133   8.872   9.604  1.00 49.66           C  
ATOM     47  CG  GLU A   8      34.305   7.747  10.213  1.00 61.04           C  
ATOM     48  CD  GLU A   8      35.075   6.462  10.383  1.00 70.17           C  
ATOM     49  OE1 GLU A   8      35.922   6.418  11.307  1.00 81.91           O  
ATOM     50  OE2 GLU A   8      34.906   5.466   9.658  1.00 77.21           O  
ATOM     51  N   GLN A   9      35.583  11.263  11.768  1.00 32.90           N  
ATOM     52  CA  GLN A   9      35.624  11.775  13.122  1.00 30.63           C  
ATOM     53  C   GLN A   9      34.668  12.930  13.321  1.00 32.58           C  
ATOM     54  O   GLN A   9      33.803  12.946  14.219  1.00 37.19           O  
ATOM     55  CB  GLN A   9      37.078  12.149  13.474  1.00 35.30           C  
ATOM     56  CG  GLN A   9      37.245  12.751  14.861  1.00 39.17           C  
ATOM     57  CD  GLN A   9      37.252  11.684  15.945  1.00 37.98           C  
ATOM     58  OE1 GLN A   9      37.631  10.544  15.758  1.00 48.12           O  
ATOM     59  NE2 GLN A   9      36.783  12.104  17.094  1.00 39.69           N  
ATOM     60  N   ILE A  10      34.746  13.954  12.445  1.00 32.40           N  
ATOM     61  CA  ILE A  10      33.835  15.086  12.587  1.00 35.20           C  
ATOM     62  C   ILE A  10      32.396  14.700  12.341  1.00 33.70           C  
ATOM     63  O   ILE A  10      31.504  15.047  13.120  1.00 32.60           O  
ATOM     64  CB  ILE A  10      34.263  16.253  11.706  1.00 41.94           C  
ATOM     65  CG1 ILE A  10      35.637  16.756  12.202  1.00 48.31           C  
ATOM     66  CG2 ILE A  10      33.264  17.409  11.728  1.00 43.77           C  
ATOM     67  CD1 ILE A  10      36.326  17.604  11.141  1.00 52.36           C  
ATOM     68  N   GLY A  11      32.118  13.950  11.257  1.00 35.62           N  
ATOM     69  CA  GLY A  11      30.763  13.517  10.998  1.00 35.25           C  
ATOM     70  C   GLY A  11      30.143  12.759  12.170  1.00 38.01           C  
ATOM     71  O   GLY A  11      28.964  12.994  12.509  1.00 33.59           O  
ATOM     72  N   SER A  12      30.766  11.634  12.578  1.00 36.54           N  
ATOM     73  CA  SER A  12      30.289  10.759  13.624  1.00 36.91           C  
ATOM     74  C   SER A  12      30.099  11.444  14.949  1.00 38.31           C  
ATOM     75  O   SER A  12      29.015  11.315  15.526  1.00 38.41           O  
ATOM     76  CB  SER A  12      31.091   9.470  13.800  1.00 39.65           C  
ATOM     77  OG  SER A  12      32.462   9.632  14.040  1.00 43.81           O  
ATOM     78  N   SER A  13      31.004  12.333  15.400  1.00 40.84           N  
ATOM     79  CA  SER A  13      30.737  13.140  16.591  1.00 41.28           C  
ATOM     80  C   SER A  13      29.499  14.010  16.434  1.00 33.73           C  
ATOM     81  O   SER A  13      28.733  14.195  17.356  1.00 33.43           O  
ATOM     82  CB  SER A  13      31.955  14.049  16.887  1.00 39.33           C  
ATOM     83  OG  SER A  13      32.962  13.227  17.416  1.00 43.99           O  
ATOM     84  N   PHE A  14      29.288  14.675  15.301  1.00 36.14           N  
ATOM     85  CA  PHE A  14      28.094  15.466  15.022  1.00 38.67           C  
ATOM     86  C   PHE A  14      26.831  14.612  15.078  1.00 38.78           C  
ATOM     87  O   PHE A  14      25.823  15.013  15.670  1.00 39.65           O  
ATOM     88  CB  PHE A  14      28.271  16.140  13.660  1.00 41.64           C  
ATOM     89  CG  PHE A  14      27.051  16.932  13.263  1.00 47.01           C  
ATOM     90  CD1 PHE A  14      26.884  18.210  13.737  1.00 43.16           C  
ATOM     91  CD2 PHE A  14      26.048  16.372  12.462  1.00 48.35           C  
ATOM     92  CE1 PHE A  14      25.750  18.932  13.415  1.00 42.42           C  
ATOM     93  CE2 PHE A  14      24.862  17.036  12.244  1.00 44.94           C  
ATOM     94  CZ  PHE A  14      24.743  18.340  12.696  1.00 45.32           C  
ATOM     95  N   ILE A  15      26.761  13.437  14.454  1.00 40.98           N  
ATOM     96  CA  ILE A  15      25.656  12.486  14.453  1.00 42.65           C  
ATOM     97  C   ILE A  15      25.242  12.148  15.873  1.00 43.35           C  
ATOM     98  O   ILE A  15      24.095  12.369  16.287  1.00 42.38           O  
ATOM     99  CB  ILE A  15      25.980  11.171  13.711  1.00 41.90           C  
ATOM    100  CG1 ILE A  15      26.104  11.338  12.196  1.00 44.18           C  
ATOM    101  CG2 ILE A  15      24.996  10.034  13.952  1.00 40.55           C  
ATOM    102  CD1 ILE A  15      25.119  12.234  11.499  1.00 40.55           C  
ATOM    103  N   GLN A  16      26.230  11.697  16.649  1.00 41.39           N  
ATOM    104  CA  GLN A  16      26.113  11.485  18.069  1.00 41.04           C  
ATOM    105  C   GLN A  16      25.526  12.687  18.774  1.00 39.22           C  
ATOM    106  O   GLN A  16      24.529  12.574  19.494  1.00 41.50           O  
ATOM    107  CB  GLN A  16      27.496  11.151  18.639  1.00 45.97           C  
ATOM    108  CG  GLN A  16      27.470  10.829  20.136  1.00 54.23           C  
ATOM    109  N   HIS A  17      26.082  13.885  18.632  1.00 37.28           N  
ATOM    110  CA  HIS A  17      25.527  15.060  19.285  1.00 37.20           C  
ATOM    111  C   HIS A  17      24.078  15.317  18.883  1.00 39.26           C  
ATOM    112  O   HIS A  17      23.139  15.342  19.693  1.00 40.97           O  
ATOM    113  CB  HIS A  17      26.404  16.258  18.955  1.00 27.03           C  
ATOM    114  CG  HIS A  17      25.882  17.504  19.606  1.00 27.16           C  
ATOM    115  ND1 HIS A  17      25.730  17.619  20.960  1.00 33.06           N  
ATOM    116  CD2 HIS A  17      25.493  18.672  19.078  1.00 27.92           C  
ATOM    117  CE1 HIS A  17      25.251  18.817  21.262  1.00 36.59           C  
ATOM    118  NE2 HIS A  17      25.080  19.478  20.104  1.00 35.99           N  
ATOM    119  N   TYR A  18      23.827  15.432  17.585  1.00 39.35           N  
ATOM    120  CA  TYR A  18      22.521  15.585  17.008  1.00 39.04           C  
ATOM    121  C   TYR A  18      21.463  14.661  17.587  1.00 38.41           C  
ATOM    122  O   TYR A  18      20.388  15.178  17.952  1.00 34.67           O  
ATOM    123  CB  TYR A  18      22.576  15.433  15.487  1.00 38.23           C  
ATOM    124  CG  TYR A  18      21.219  15.630  14.842  1.00 43.73           C  
ATOM    125  CD1 TYR A  18      20.741  16.896  14.538  1.00 45.20           C  
ATOM    126  CD2 TYR A  18      20.418  14.532  14.529  1.00 45.96           C  
ATOM    127  CE1 TYR A  18      19.508  17.087  13.938  1.00 44.82           C  
ATOM    128  CE2 TYR A  18      19.150  14.703  14.009  1.00 47.74           C  
ATOM    129  CZ  TYR A  18      18.718  15.983  13.690  1.00 47.99           C  
ATOM    130  OH  TYR A  18      17.471  16.110  13.115  1.00 42.45           O  
ATOM    131  N   TYR A  19      21.629  13.331  17.540  1.00 35.04           N  
ATOM    132  CA  TYR A  19      20.615  12.419  18.056  1.00 39.37           C  
ATOM    133  C   TYR A  19      20.471  12.382  19.553  1.00 41.72           C  
ATOM    134  O   TYR A  19      19.322  12.300  20.030  1.00 43.69           O  
ATOM    135  CB  TYR A  19      20.745  10.974  17.516  1.00 38.82           C  
ATOM    136  CG  TYR A  19      20.540  10.983  16.019  1.00 40.96           C  
ATOM    137  CD1 TYR A  19      19.266  11.133  15.478  1.00 39.95           C  
ATOM    138  CD2 TYR A  19      21.609  10.875  15.137  1.00 40.21           C  
ATOM    139  CE1 TYR A  19      19.076  11.145  14.114  1.00 38.59           C  
ATOM    140  CE2 TYR A  19      21.437  10.924  13.771  1.00 38.75           C  
ATOM    141  CZ  TYR A  19      20.153  11.090  13.263  1.00 40.81           C  
ATOM    142  OH  TYR A  19      19.963  11.149  11.888  1.00 37.38           O  
ATOM    143  N   GLN A  20      21.514  12.679  20.351  1.00 43.29           N  
ATOM    144  CA  GLN A  20      21.324  12.852  21.789  1.00 42.38           C  
ATOM    145  C   GLN A  20      20.464  14.072  22.057  1.00 43.93           C  
ATOM    146  O   GLN A  20      19.493  14.008  22.836  1.00 45.18           O  
ATOM    147  CB  GLN A  20      22.653  12.909  22.525  1.00 39.60           C  
ATOM    148  CG  GLN A  20      22.498  13.172  24.019  1.00 41.74           C  
ATOM    149  CD  GLN A  20      23.867  12.133  24.597  0.00100.00           C  
ATOM    150  OE1 GLN A  20      24.793  11.836  23.848  0.00100.00           O  
ATOM    151  NE2 GLN A  20      23.991  11.938  25.898  0.00100.00           N  
ATOM    152  N   LEU A  21      20.776  15.214  21.408  1.00 42.95           N  
ATOM    153  CA  LEU A  21      19.914  16.387  21.618  1.00 43.29           C  
ATOM    154  C   LEU A  21      18.501  16.110  21.142  1.00 45.95           C  
ATOM    155  O   LEU A  21      17.541  15.998  21.903  1.00 46.16           O  
ATOM    156  CB  LEU A  21      20.510  17.597  20.938  1.00 39.69           C  
ATOM    157  CG  LEU A  21      21.082  18.727  21.775  1.00 48.09           C  
ATOM    158  CD1 LEU A  21      22.112  18.227  22.773  1.00 48.71           C  
ATOM    159  CD2 LEU A  21      21.676  19.766  20.834  1.00 53.09           C  
ATOM    160  N   PHE A  22      18.294  15.618  19.913  1.00 44.42           N  
ATOM    161  CA  PHE A  22      16.997  15.242  19.419  1.00 45.88           C  
ATOM    162  C   PHE A  22      16.224  14.366  20.385  1.00 46.21           C  
ATOM    163  O   PHE A  22      15.065  14.678  20.683  1.00 47.90           O  
ATOM    164  CB  PHE A  22      17.118  14.535  18.055  1.00 44.45           C  
ATOM    165  CG  PHE A  22      15.938  14.810  17.171  1.00 48.63           C  
ATOM    166  CD1 PHE A  22      14.682  14.267  17.441  1.00 46.47           C  
ATOM    167  CD2 PHE A  22      16.089  15.589  16.036  1.00 45.04           C  
ATOM    168  CE1 PHE A  22      13.622  14.541  16.598  1.00 42.64           C  
ATOM    169  CE2 PHE A  22      15.040  15.850  15.192  1.00 44.20           C  
ATOM    170  CZ  PHE A  22      13.799  15.328  15.485  1.00 43.19           C  
ATOM    171  N   ASP A  23      16.745  13.250  20.891  1.00 43.25           N  
ATOM    172  CA  ASP A  23      16.074  12.435  21.873  1.00 42.06           C  
ATOM    173  C   ASP A  23      15.941  13.000  23.263  1.00 45.99           C  
ATOM    174  O   ASP A  23      15.088  12.479  24.000  1.00 48.99           O  
ATOM    175  CB  ASP A  23      16.702  11.032  21.947  1.00 31.32           C  
ATOM    176  CG  ASP A  23      16.707  10.439  20.519  1.00 26.96           C  
ATOM    177  OD1 ASP A  23      16.120  10.507  19.722  0.00  9.04           O  
ATOM    178  OD2 ASP A  23      17.412   9.385  20.501  1.00 31.62           O  
ATOM    179  N   ASN A  24      16.705  13.978  23.751  1.00 49.97           N  
ATOM    180  CA  ASN A  24      16.491  14.552  25.071  1.00 54.54           C  
ATOM    181  C   ASN A  24      15.713  15.848  25.021  1.00 58.85           C  
ATOM    182  O   ASN A  24      14.634  15.937  25.590  1.00 64.20           O  
ATOM    183  CB  ASN A  24      17.836  14.759  25.779  1.00 54.27           C  
ATOM    184  CG  ASN A  24      18.529  13.396  25.962  1.00 50.19           C  
ATOM    185  OD1 ASN A  24      18.484  13.048  27.100  0.00 98.42           O  
ATOM    186  ND2 ASN A  24      18.822  12.772  24.935  0.00 59.17           N  
ATOM    187  N   ASP A  25      16.263  16.859  24.364  1.00 63.44           N  
ATOM    188  CA  ASP A  25      15.608  18.157  24.255  1.00 60.48           C  
ATOM    189  C   ASP A  25      15.869  18.690  22.868  1.00 58.42           C  
ATOM    190  O   ASP A  25      16.900  19.299  22.635  1.00 59.16           O  
ATOM    191  CB  ASP A  25      16.120  19.129  25.308  1.00 62.65           C  
ATOM    192  CG  ASP A  25      15.211  20.324  25.491  1.00 65.21           C  
ATOM    193  OD1 ASP A  25      14.094  20.337  24.951  1.00 62.07           O  
ATOM    194  OD2 ASP A  25      15.640  21.245  26.222  1.00 74.42           O  
ATOM    195  N   ARG A  26      14.933  18.504  21.946  1.00 57.92           N  
ATOM    196  CA  ARG A  26      15.056  18.864  20.560  1.00 62.62           C  
ATOM    197  C   ARG A  26      15.009  20.337  20.230  1.00 62.30           C  
ATOM    198  O   ARG A  26      15.510  20.731  19.181  1.00 64.02           O  
ATOM    199  CB  ARG A  26      14.094  18.075  19.673  1.00 65.37           C  
ATOM    200  CG  ARG A  26      12.622  18.393  19.872  1.00 65.91           C  
ATOM    201  CD  ARG A  26      11.828  17.547  18.892  1.00 69.17           C  
ATOM    202  NE  ARG A  26      10.409  17.809  18.936  1.00 76.09           N  
ATOM    203  CZ  ARG A  26       9.548  17.499  19.885  1.00 76.61           C  
ATOM    204  NH1 ARG A  26       9.925  16.864  20.978  1.00 78.53           N  
ATOM    205  NH2 ARG A  26       8.284  17.848  19.694  1.00 78.55           N  
ATOM    206  N   THR A  27      14.581  21.211  21.099  1.00 63.59           N  
ATOM    207  CA  THR A  27      14.488  22.630  21.142  1.00 66.40           C  
ATOM    208  C   THR A  27      15.809  23.352  21.396  1.00 65.08           C  
ATOM    209  O   THR A  27      15.974  24.477  20.911  1.00 67.57           O  
ATOM    210  CB  THR A  27      13.506  23.047  22.272  1.00 67.33           C  
ATOM    211  OG1 THR A  27      14.033  22.599  23.523  1.00 69.59           O  
ATOM    212  CG2 THR A  27      12.152  22.392  22.038  1.00 69.78           C  
ATOM    213  N   GLN A  28      16.873  22.665  21.786  1.00 63.44           N  
ATOM    214  CA  GLN A  28      18.254  23.046  21.775  1.00 60.47           C  
ATOM    215  C   GLN A  28      19.015  22.624  20.525  1.00 58.88           C  
ATOM    216  O   GLN A  28      20.238  22.819  20.451  1.00 60.51           O  
ATOM    217  CB  GLN A  28      18.979  22.455  23.002  1.00 60.32           C  
ATOM    218  CG  GLN A  28      18.739  23.336  24.229  1.00 67.38           C  
ATOM    219  CD  GLN A  28      19.100  22.201  25.544  0.00100.00           C  
ATOM    220  OE1 GLN A  28      20.145  21.573  25.379  0.00100.00           O  
ATOM    221  NE2 GLN A  28      18.645  22.411  26.767  0.00100.00           N  
ATOM    222  N   LEU A  29      18.349  22.189  19.453  1.00 53.19           N  
ATOM    223  CA  LEU A  29      18.917  21.821  18.189  1.00 49.16           C  
ATOM    224  C   LEU A  29      19.222  22.985  17.285  1.00 49.14           C  
ATOM    225  O   LEU A  29      20.124  22.879  16.433  1.00 47.72           O  
ATOM    226  CB  LEU A  29      18.121  20.758  17.449  1.00 53.57           C  
ATOM    227  CG  LEU A  29      18.399  19.332  17.939  1.00 58.17           C  
ATOM    228  CD1 LEU A  29      17.232  18.428  17.659  1.00 57.20           C  
ATOM    229  CD2 LEU A  29      19.677  18.781  17.331  1.00 56.86           C  
ATOM    230  N   GLY A  30      18.665  24.174  17.514  1.00 44.38           N  
ATOM    231  CA  GLY A  30      18.917  25.392  16.810  1.00 42.06           C  
ATOM    232  C   GLY A  30      20.335  25.900  16.890  1.00 45.82           C  
ATOM    233  O   GLY A  30      20.867  26.259  15.790  1.00 48.75           O  
ATOM    234  N   ALA A  31      21.106  25.651  17.961  1.00 39.66           N  
ATOM    235  CA  ALA A  31      22.527  25.862  18.103  1.00 36.37           C  
ATOM    236  C   ALA A  31      23.370  25.242  17.023  1.00 34.08           C  
ATOM    237  O   ALA A  31      24.329  25.891  16.591  1.00 37.90           O  
ATOM    238  CB  ALA A  31      22.983  25.376  19.480  1.00 39.12           C  
ATOM    239  N   ILE A  32      23.067  24.087  16.437  1.00 37.61           N  
ATOM    240  CA  ILE A  32      23.733  23.494  15.306  1.00 40.05           C  
ATOM    241  C   ILE A  32      23.411  24.158  13.970  1.00 32.98           C  
ATOM    242  O   ILE A  32      24.180  23.971  12.995  1.00 27.51           O  
ATOM    243  CB  ILE A  32      23.518  21.972  15.201  1.00 48.73           C  
ATOM    244  CG1 ILE A  32      22.196  21.616  14.515  1.00 49.97           C  
ATOM    245  CG2 ILE A  32      23.546  21.292  16.573  1.00 49.99           C  
ATOM    246  CD1 ILE A  32      22.100  20.230  13.940  1.00 52.44           C  
ATOM    247  N   TYR A  33      22.333  24.923  13.845  1.00 36.30           N  
ATOM    248  CA  TYR A  33      21.972  25.515  12.556  1.00 42.05           C  
ATOM    249  C   TYR A  33      22.362  26.975  12.429  1.00 44.01           C  
ATOM    250  O   TYR A  33      22.510  27.651  13.442  1.00 50.42           O  
ATOM    251  CB  TYR A  33      20.466  25.440  12.304  1.00 35.56           C  
ATOM    252  CG  TYR A  33      19.990  24.003  12.192  1.00 34.00           C  
ATOM    253  CD1 TYR A  33      20.374  23.210  11.135  1.00 32.63           C  
ATOM    254  CD2 TYR A  33      19.160  23.471  13.167  1.00 32.30           C  
ATOM    255  CE1 TYR A  33      19.901  21.908  11.034  1.00 34.31           C  
ATOM    256  CE2 TYR A  33      18.712  22.181  13.099  1.00 27.72           C  
ATOM    257  CZ  TYR A  33      19.085  21.416  12.029  1.00 28.45           C  
ATOM    258  OH  TYR A  33      18.649  20.129  11.912  1.00 34.27           O  
ATOM    259  N   ILE A  34      22.470  27.456  11.202  1.00 42.97           N  
ATOM    260  CA  ILE A  34      22.756  28.878  11.009  1.00 47.07           C  
ATOM    261  C   ILE A  34      21.569  29.498  10.255  1.00 48.16           C  
ATOM    262  O   ILE A  34      20.756  28.762   9.655  1.00 50.76           O  
ATOM    263  CB  ILE A  34      24.053  29.224  10.264  1.00 36.24           C  
ATOM    264  CG1 ILE A  34      24.148  28.424   8.981  1.00 36.69           C  
ATOM    265  CG2 ILE A  34      25.251  29.054  11.167  1.00 41.22           C  
ATOM    266  CD1 ILE A  34      25.269  28.814   8.039  1.00 37.86           C  
ATOM    267  N   ASP A  35      21.754  30.728   9.790  1.00 42.77           N  
ATOM    268  CA  ASP A  35      20.755  31.535   9.124  1.00 42.11           C  
ATOM    269  C   ASP A  35      20.504  31.005   7.730  1.00 40.68           C  
ATOM    270  O   ASP A  35      19.373  30.892   7.253  1.00 40.00           O  
ATOM    271  CB  ASP A  35      21.175  33.030   9.059  1.00 43.24           C  
ATOM    272  CG  ASP A  35      21.825  33.628  10.411  0.00 92.47           C  
ATOM    273  OD1 ASP A  35      20.885  34.056  11.183  0.00100.00           O  
ATOM    274  OD2 ASP A  35      23.056  33.710  10.783  0.00100.00           O  
ATOM    275  N   ALA A  36      21.535  30.530   7.041  1.00 34.21           N  
ATOM    276  CA  ALA A  36      21.547  29.931   5.752  1.00 31.04           C  
ATOM    277  C   ALA A  36      21.171  28.456   5.660  1.00 37.04           C  
ATOM    278  O   ALA A  36      21.237  27.890   4.535  1.00 35.95           O  
ATOM    279  CB  ALA A  36      22.972  30.032   5.190  1.00 19.70           C  
ATOM    280  N   SER A  37      20.904  27.779   6.760  1.00 38.23           N  
ATOM    281  CA  SER A  37      20.533  26.396   6.836  1.00 40.14           C  
ATOM    282  C   SER A  37      19.184  26.122   6.141  1.00 40.33           C  
ATOM    283  O   SER A  37      18.153  26.770   6.383  1.00 36.54           O  
ATOM    284  CB  SER A  37      20.407  25.916   8.296  1.00 36.61           C  
ATOM    285  OG  SER A  37      21.626  25.957   8.987  1.00 37.86           O  
ATOM    286  N   CYS A  38      19.192  24.987   5.451  1.00 39.84           N  
ATOM    287  CA  CYS A  38      18.001  24.468   4.789  1.00 37.31           C  
ATOM    288  C   CYS A  38      17.609  23.095   5.334  1.00 39.73           C  
ATOM    289  O   CYS A  38      18.425  22.165   5.225  1.00 43.64           O  
ATOM    290  CB  CYS A  38      18.350  24.334   3.319  1.00 35.62           C  
ATOM    291  SG  CYS A  38      18.566  25.876   2.378  1.00 36.45           S  
ATOM    292  N   LEU A  39      16.414  22.938   5.879  1.00 35.60           N  
ATOM    293  CA  LEU A  39      15.873  21.668   6.302  1.00 33.24           C  
ATOM    294  C   LEU A  39      14.752  21.198   5.340  1.00 38.58           C  
ATOM    295  O   LEU A  39      13.944  21.999   4.873  1.00 34.20           O  
ATOM    296  CB  LEU A  39      15.302  21.730   7.713  1.00 32.16           C  
ATOM    297  CG  LEU A  39      14.470  20.531   8.230  1.00 37.76           C  
ATOM    298  CD1 LEU A  39      15.334  19.310   8.559  1.00 36.14           C  
ATOM    299  CD2 LEU A  39      13.721  20.903   9.492  1.00 30.20           C  
ATOM    300  N   THR A  40      14.836  19.957   4.888  1.00 38.76           N  
ATOM    301  CA  THR A  40      13.775  19.249   4.207  1.00 41.60           C  
ATOM    302  C   THR A  40      13.331  18.091   5.139  1.00 41.32           C  
ATOM    303  O   THR A  40      14.144  17.189   5.330  1.00 42.21           O  
ATOM    304  CB  THR A  40      14.144  18.602   2.865  1.00 38.43           C  
ATOM    305  OG1 THR A  40      14.537  19.640   1.973  1.00 36.49           O  
ATOM    306  CG2 THR A  40      12.906  17.894   2.292  1.00 36.29           C  
ATOM    307  N   TRP A  41      12.124  18.169   5.630  1.00 39.71           N  
ATOM    308  CA  TRP A  41      11.579  17.207   6.580  1.00 40.77           C  
ATOM    309  C   TRP A  41      10.333  16.523   6.024  1.00 40.61           C  
ATOM    310  O   TRP A  41       9.349  17.243   5.760  1.00 41.03           O  
ATOM    311  CB  TRP A  41      11.152  17.978   7.843  1.00 34.18           C  
ATOM    312  CG  TRP A  41      10.767  17.041   8.953  1.00 42.26           C  
ATOM    313  CD1 TRP A  41       9.531  16.555   9.238  1.00 37.70           C  
ATOM    314  CD2 TRP A  41      11.636  16.485   9.953  1.00 46.42           C  
ATOM    315  NE1 TRP A  41       9.568  15.713  10.296  1.00 40.51           N  
ATOM    316  CE2 TRP A  41      10.846  15.621  10.752  1.00 45.21           C  
ATOM    317  CE3 TRP A  41      12.987  16.666  10.276  1.00 35.61           C  
ATOM    318  CZ2 TRP A  41      11.351  14.968  11.882  1.00 42.70           C  
ATOM    319  CZ3 TRP A  41      13.501  15.975  11.337  1.00 37.54           C  
ATOM    320  CH2 TRP A  41      12.680  15.153  12.139  1.00 42.69           C  
ATOM    321  N   GLU A  42      10.422  15.279   5.579  1.00 36.25           N  
ATOM    322  CA  GLU A  42       9.256  14.581   4.995  1.00 41.30           C  
ATOM    323  C   GLU A  42       8.768  15.282   3.748  1.00 42.19           C  
ATOM    324  O   GLU A  42       7.628  15.753   3.662  1.00 40.44           O  
ATOM    325  CB  GLU A  42       8.108  14.405   5.995  1.00 38.02           C  
ATOM    326  CG  GLU A  42       8.241  13.329   7.075  1.00 41.69           C  
ATOM    327  CD  GLU A  42       8.624  11.943   6.536  1.00 31.33           C  
ATOM    328  OE1 GLU A  42       7.709  11.416   5.817  0.00 35.07           O  
ATOM    329  OE2 GLU A  42       9.806  11.672   6.547  0.00 51.66           O  
ATOM    330  N   GLY A  43       9.641  15.757   2.844  1.00 43.48           N  
ATOM    331  CA  GLY A  43       9.337  16.493   1.665  1.00 41.41           C  
ATOM    332  C   GLY A  43       9.033  17.951   1.806  1.00 44.43           C  
ATOM    333  O   GLY A  43       9.085  18.681   0.805  1.00 51.42           O  
ATOM    334  N   GLN A  44       8.817  18.530   2.957  1.00 46.66           N  
ATOM    335  CA  GLN A  44       8.569  19.913   3.243  1.00 47.82           C  
ATOM    336  C   GLN A  44       9.867  20.674   3.566  1.00 47.54           C  
ATOM    337  O   GLN A  44      10.635  20.280   4.420  1.00 44.63           O  
ATOM    338  CB  GLN A  44       7.669  20.054   4.480  1.00 52.44           C  
ATOM    339  CG  GLN A  44       6.207  19.720   4.231  1.00 60.17           C  
ATOM    340  CD  GLN A  44       5.331  20.156   5.403  1.00 67.08           C  
ATOM    341  OE1 GLN A  44       5.600  19.761   6.555  1.00 68.43           O  
ATOM    342  NE2 GLN A  44       4.431  19.544   4.954  0.00100.00           N  
ATOM    343  N   GLN A  45       9.975  21.885   3.057  1.00 47.79           N  
ATOM    344  CA  GLN A  45      11.135  22.712   2.913  1.00 44.98           C  
ATOM    345  C   GLN A  45      11.102  23.920   3.820  1.00 48.14           C  
ATOM    346  O   GLN A  45      10.088  24.567   4.106  1.00 47.34           O  
ATOM    347  CB  GLN A  45      11.272  23.213   1.464  1.00 43.52           C  
ATOM    348  CG  GLN A  45      11.301  22.126   0.395  1.00 40.71           C  
ATOM    349  CD  GLN A  45      11.752  22.674  -0.931  1.00 44.00           C  
ATOM    350  OE1 GLN A  45      11.677  23.884  -1.138  1.00 50.28           O  
ATOM    351  NE2 GLN A  45      12.311  21.816  -1.783  1.00 49.23           N  
ATOM    352  N   PHE A  46      12.062  23.961   4.764  1.00 49.67           N  
ATOM    353  CA  PHE A  46      12.178  24.995   5.782  1.00 49.31           C  
ATOM    354  C   PHE A  46      13.520  25.727   5.654  1.00 50.38           C  
ATOM    355  O   PHE A  46      14.604  25.124   5.776  1.00 44.55           O  
ATOM    356  CB  PHE A  46      12.058  24.399   7.208  1.00 49.58           C  
ATOM    357  CG  PHE A  46      10.739  23.712   7.446  1.00 46.84           C  
ATOM    358  CD1 PHE A  46       9.598  24.433   7.760  1.00 41.69           C  
ATOM    359  CD2 PHE A  46      10.640  22.354   7.176  1.00 41.44           C  
ATOM    360  CE1 PHE A  46       8.380  23.781   7.854  1.00 33.71           C  
ATOM    361  CE2 PHE A  46       9.418  21.711   7.270  1.00 45.09           C  
ATOM    362  CZ  PHE A  46       8.294  22.438   7.591  1.00 37.57           C  
ATOM    363  N   GLN A  47      13.493  27.041   5.377  1.00 52.02           N  
ATOM    364  CA  GLN A  47      14.729  27.808   5.270  1.00 48.61           C  
ATOM    365  C   GLN A  47      14.991  28.619   6.526  1.00 46.59           C  
ATOM    366  O   GLN A  47      14.108  29.314   6.989  1.00 51.99           O  
ATOM    367  CB  GLN A  47      14.819  28.778   4.100  1.00 49.60           C  
ATOM    368  CG  GLN A  47      16.216  29.395   3.921  1.00 52.15           C  
ATOM    369  CD  GLN A  47      16.227  30.752   3.264  1.00 51.20           C  
ATOM    370  OE1 GLN A  47      17.275  30.869   2.320  0.00 46.02           O  
ATOM    371  NE2 GLN A  47      15.118  31.298   2.511  0.00 23.45           N  
ATOM    372  N   GLY A  48      16.233  28.605   7.002  1.00 46.47           N  
ATOM    373  CA  GLY A  48      16.623  29.441   8.113  1.00 45.47           C  
ATOM    374  C   GLY A  48      16.347  28.814   9.457  1.00 52.84           C  
ATOM    375  O   GLY A  48      15.355  28.142   9.757  1.00 56.26           O  
ATOM    376  N   LYS A  49      17.198  29.118  10.422  1.00 52.73           N  
ATOM    377  CA  LYS A  49      17.155  28.656  11.781  1.00 54.24           C  
ATOM    378  C   LYS A  49      15.793  28.707  12.452  1.00 55.09           C  
ATOM    379  O   LYS A  49      15.309  27.664  12.934  1.00 55.56           O  
ATOM    380  CB  LYS A  49      18.143  29.512  12.579  1.00 57.00           C  
ATOM    381  CG  LYS A  49      18.382  29.107  14.028  1.00 58.82           C  
ATOM    382  CD  LYS A  49      19.759  29.701  14.362  1.00 68.22           C  
ATOM    383  CE  LYS A  49      20.135  29.581  15.824  1.00 71.78           C  
ATOM    384  NZ  LYS A  49      21.615  29.359  15.933  1.00 74.31           N  
ATOM    385  N   ALA A  50      15.148  29.880  12.515  1.00 48.71           N  
ATOM    386  CA  ALA A  50      13.870  30.078  13.164  1.00 45.12           C  
ATOM    387  C   ALA A  50      12.717  29.248  12.621  1.00 42.37           C  
ATOM    388  O   ALA A  50      11.990  28.678  13.443  1.00 46.07           O  
ATOM    389  CB  ALA A  50      13.459  31.547  13.196  1.00 39.47           C  
ATOM    390  N   ALA A  51      12.578  29.068  11.321  1.00 38.52           N  
ATOM    391  CA  ALA A  51      11.653  28.144  10.687  1.00 38.46           C  
ATOM    392  C   ALA A  51      12.031  26.682  10.931  1.00 42.01           C  
ATOM    393  O   ALA A  51      11.156  25.913  11.373  1.00 46.42           O  
ATOM    394  CB  ALA A  51      11.618  28.402   9.194  1.00 26.43           C  
ATOM    395  N   ILE A  52      13.329  26.329  10.970  1.00 39.29           N  
ATOM    396  CA  ILE A  52      13.732  24.967  11.292  1.00 40.95           C  
ATOM    397  C   ILE A  52      13.411  24.539  12.714  1.00 45.60           C  
ATOM    398  O   ILE A  52      12.898  23.440  12.962  1.00 48.35           O  
ATOM    399  CB  ILE A  52      15.216  24.785  10.974  1.00 41.49           C  
ATOM    400  CG1 ILE A  52      15.432  25.012   9.470  1.00 33.90           C  
ATOM    401  CG2 ILE A  52      15.761  23.443  11.455  1.00 41.14           C  
ATOM    402  CD1 ILE A  52      16.894  25.116   9.065  1.00 34.93           C  
ATOM    403  N   VAL A  53      13.633  25.400  13.694  1.00 43.38           N  
ATOM    404  CA  VAL A  53      13.444  25.225  15.109  1.00 41.24           C  
ATOM    405  C   VAL A  53      11.976  25.145  15.477  1.00 45.82           C  
ATOM    406  O   VAL A  53      11.548  24.307  16.273  1.00 43.91           O  
ATOM    407  CB  VAL A  53      14.159  26.358  15.886  1.00 42.63           C  
ATOM    408  CG1 VAL A  53      13.804  26.428  17.361  1.00 34.09           C  
ATOM    409  CG2 VAL A  53      15.668  26.158  15.711  1.00 45.68           C  
ATOM    410  N   GLU A  54      11.117  25.913  14.825  1.00 48.64           N  
ATOM    411  CA  GLU A  54       9.676  25.877  14.977  1.00 50.35           C  
ATOM    412  C   GLU A  54       9.130  24.575  14.414  1.00 48.09           C  
ATOM    413  O   GLU A  54       8.443  23.780  15.085  1.00 48.35           O  
ATOM    414  CB  GLU A  54       9.017  27.059  14.257  1.00 56.39           C  
ATOM    415  CG  GLU A  54       7.768  26.707  13.742  0.00 97.02           C  
ATOM    416  CD  GLU A  54       7.661  27.369  12.393  0.00100.00           C  
ATOM    417  OE1 GLU A  54       7.502  28.644  12.324  0.00100.00           O  
ATOM    418  OE2 GLU A  54       7.755  26.648  11.336  0.00123.20           O  
ATOM    419  N   LYS A  55       9.617  24.174  13.224  1.00 41.10           N  
ATOM    420  CA  LYS A  55       9.249  22.857  12.720  1.00 43.22           C  
ATOM    421  C   LYS A  55       9.551  21.716  13.682  1.00 47.01           C  
ATOM    422  O   LYS A  55       8.698  20.880  14.026  1.00 44.70           O  
ATOM    423  CB  LYS A  55       9.926  22.566  11.385  1.00 45.94           C  
ATOM    424  CG  LYS A  55       9.688  21.196  10.779  1.00 48.02           C  
ATOM    425  CD  LYS A  55       8.207  20.869  10.672  1.00 49.57           C  
ATOM    426  CE  LYS A  55       7.889  19.588   9.952  1.00 51.40           C  
ATOM    427  NZ  LYS A  55       6.504  19.131  10.313  1.00 54.64           N  
ATOM    428  N   LEU A  56      10.814  21.662  14.146  1.00 49.51           N  
ATOM    429  CA  LEU A  56      11.336  20.684  15.063  1.00 47.54           C  
ATOM    430  C   LEU A  56      10.635  20.635  16.396  1.00 48.00           C  
ATOM    431  O   LEU A  56      10.234  19.562  16.873  1.00 45.85           O  
ATOM    432  CB  LEU A  56      12.848  20.890  15.210  1.00 49.26           C  
ATOM    433  CG  LEU A  56      13.702  20.502  14.005  1.00 50.40           C  
ATOM    434  CD1 LEU A  56      15.167  20.764  14.349  1.00 42.23           C  
ATOM    435  CD2 LEU A  56      13.449  19.079  13.543  1.00 42.52           C  
ATOM    436  N   SER A  57      10.358  21.791  16.999  1.00 49.20           N  
ATOM    437  CA  SER A  57       9.639  21.918  18.250  1.00 54.91           C  
ATOM    438  C   SER A  57       8.178  21.494  18.206  1.00 56.54           C  
ATOM    439  O   SER A  57       7.665  20.890  19.155  1.00 58.20           O  
ATOM    440  CB  SER A  57       9.695  23.405  18.666  1.00 56.51           C  
ATOM    441  OG  SER A  57      11.083  23.735  18.782  1.00 67.50           O  
ATOM    442  N   SER A  58       7.479  21.675  17.077  1.00 52.46           N  
ATOM    443  CA  SER A  58       6.120  21.317  16.881  1.00 48.35           C  
ATOM    444  C   SER A  58       5.866  19.854  16.564  1.00 50.66           C  
ATOM    445  O   SER A  58       4.677  19.524  16.538  1.00 50.70           O  
ATOM    446  CB  SER A  58       5.444  22.127  15.772  1.00 43.00           C  
ATOM    447  OG  SER A  58       5.768  21.597  14.491  1.00 43.32           O  
ATOM    448  N   LEU A  59       6.827  19.009  16.232  1.00 50.06           N  
ATOM    449  CA  LEU A  59       6.470  17.626  15.940  1.00 52.29           C  
ATOM    450  C   LEU A  59       5.679  17.068  17.104  1.00 57.11           C  
ATOM    451  O   LEU A  59       6.011  17.180  18.272  1.00 57.07           O  
ATOM    452  CB  LEU A  59       7.705  16.792  15.657  1.00 54.83           C  
ATOM    453  CG  LEU A  59       8.650  17.286  14.557  1.00 53.77           C  
ATOM    454  CD1 LEU A  59      10.075  16.809  14.803  1.00 48.63           C  
ATOM    455  CD2 LEU A  59       8.152  16.836  13.186  1.00 48.44           C  
ATOM    456  N   PRO A  60       4.669  16.237  16.772  1.00 63.14           N  
ATOM    457  CA  PRO A  60       3.736  15.685  17.728  1.00 65.46           C  
ATOM    458  C   PRO A  60       4.136  14.395  18.402  1.00 67.55           C  
ATOM    459  O   PRO A  60       3.403  13.397  18.333  1.00 75.27           O  
ATOM    460  CB  PRO A  60       2.475  15.490  16.865  1.00 62.83           C  
ATOM    461  CG  PRO A  60       3.038  15.009  15.567  1.00 59.90           C  
ATOM    462  CD  PRO A  60       4.169  16.017  15.381  1.00 62.68           C  
ATOM    463  N   PHE A  61       5.209  14.382  19.162  1.00 64.14           N  
ATOM    464  CA  PHE A  61       5.655  13.243  19.939  1.00 64.19           C  
ATOM    465  C   PHE A  61       6.099  13.824  21.287  1.00 64.92           C  
ATOM    466  O   PHE A  61       6.554  14.973  21.277  1.00 67.74           O  
ATOM    467  CB  PHE A  61       6.760  12.432  19.284  1.00 58.26           C  
ATOM    468  CG  PHE A  61       8.040  13.140  18.971  1.00 58.28           C  
ATOM    469  CD1 PHE A  61       9.049  13.291  19.905  1.00 58.93           C  
ATOM    470  CD2 PHE A  61       8.288  13.591  17.683  1.00 63.33           C  
ATOM    471  CE1 PHE A  61      10.207  13.972  19.614  1.00 61.92           C  
ATOM    472  CE2 PHE A  61       9.484  14.224  17.371  1.00 64.86           C  
ATOM    473  CZ  PHE A  61      10.452  14.403  18.327  1.00 60.53           C  
ATOM    474  N   GLN A  62       6.044  13.031  22.328  1.00 64.27           N  
ATOM    475  CA  GLN A  62       6.568  13.480  23.611  1.00 68.70           C  
ATOM    476  C   GLN A  62       7.891  12.799  23.930  1.00 69.28           C  
ATOM    477  O   GLN A  62       8.715  13.362  24.641  1.00 71.14           O  
ATOM    478  CB  GLN A  62       5.536  13.298  24.726  1.00 71.83           C  
ATOM    479  CG  GLN A  62       4.701  14.583  24.913  1.00 76.47           C  
ATOM    480  CD  GLN A  62       2.852  13.573  24.805  0.00100.00           C  
ATOM    481  OE1 GLN A  62       2.727  12.363  25.015  0.00100.00           O  
ATOM    482  NE2 GLN A  62       1.786  14.352  24.867  0.00100.00           N  
ATOM    483  N   LYS A  63       8.090  11.592  23.430  1.00 67.47           N  
ATOM    484  CA  LYS A  63       9.269  10.787  23.598  1.00 64.02           C  
ATOM    485  C   LYS A  63       9.672  10.163  22.256  1.00 63.04           C  
ATOM    486  O   LYS A  63       8.856   9.599  21.539  1.00 62.26           O  
ATOM    487  CB  LYS A  63       9.105   9.636  24.586  1.00 65.73           C  
ATOM    488  CG  LYS A  63       9.252   9.939  26.062  1.00 66.33           C  
ATOM    489  CD  LYS A  63       8.121   8.730  26.789  0.00100.00           C  
ATOM    490  CE  LYS A  63       8.519   8.615  28.259  0.00100.00           C  
ATOM    491  NZ  LYS A  63       8.412   7.249  28.794  0.00100.00           N  
ATOM    492  N   ILE A  64      10.966  10.262  21.946  1.00 62.81           N  
ATOM    493  CA  ILE A  64      11.497   9.683  20.712  1.00 55.22           C  
ATOM    494  C   ILE A  64      12.808   8.988  21.070  1.00 56.52           C  
ATOM    495  O   ILE A  64      13.513   9.400  21.997  1.00 57.41           O  
ATOM    496  CB  ILE A  64      11.691  10.718  19.602  1.00 51.78           C  
ATOM    497  CG1 ILE A  64      11.900   9.971  18.271  1.00 54.71           C  
ATOM    498  CG2 ILE A  64      12.830  11.695  19.845  1.00 45.98           C  
ATOM    499  CD1 ILE A  64      10.973  10.441  17.171  1.00 51.83           C  
ATOM    500  N   GLN A  65      13.163   7.938  20.345  1.00 54.35           N  
ATOM    501  CA  GLN A  65      14.461   7.311  20.498  1.00 49.74           C  
ATOM    502  C   GLN A  65      14.951   6.931  19.101  1.00 49.42           C  
ATOM    503  O   GLN A  65      14.193   6.222  18.428  1.00 49.09           O  
ATOM    504  CB  GLN A  65      14.360   6.084  21.384  1.00 50.14           C  
ATOM    505  CG  GLN A  65      15.572   5.179  21.433  1.00 52.40           C  
ATOM    506  CD  GLN A  65      15.982   4.350  21.393  0.00100.00           C  
ATOM    507  OE1 GLN A  65      15.127   3.699  20.816  0.00100.00           O  
ATOM    508  NE2 GLN A  65      17.156   3.827  21.688  0.00100.00           N  
ATOM    509  N   HIS A  66      16.183   7.306  18.751  1.00 47.74           N  
ATOM    510  CA  HIS A  66      16.706   6.926  17.441  1.00 46.20           C  
ATOM    511  C   HIS A  66      17.834   5.903  17.619  1.00 45.77           C  
ATOM    512  O   HIS A  66      18.566   5.898  18.589  1.00 48.61           O  
ATOM    513  CB  HIS A  66      17.262   8.051  16.599  1.00 35.37           C  
ATOM    514  CG  HIS A  66      16.337   9.120  16.148  1.00 37.02           C  
ATOM    515  ND1 HIS A  66      15.679   9.937  17.057  1.00 39.99           N  
ATOM    516  CD2 HIS A  66      15.990   9.550  14.911  1.00 32.39           C  
ATOM    517  CE1 HIS A  66      14.967  10.842  16.418  1.00 39.95           C  
ATOM    518  NE2 HIS A  66      15.154  10.604  15.123  1.00 41.67           N  
ATOM    519  N   SER A  67      18.025   5.066  16.631  1.00 46.92           N  
ATOM    520  CA  SER A  67      19.121   4.103  16.660  1.00 46.00           C  
ATOM    521  C   SER A  67      19.676   3.989  15.250  1.00 46.59           C  
ATOM    522  O   SER A  67      18.977   3.786  14.248  1.00 51.61           O  
ATOM    523  CB  SER A  67      18.638   2.794  17.271  1.00 44.69           C  
ATOM    524  OG  SER A  67      18.715   1.767  16.307  1.00 54.28           O  
ATOM    525  N   ILE A  68      20.947   4.287  15.118  1.00 43.86           N  
ATOM    526  CA  ILE A  68      21.648   4.395  13.855  1.00 42.96           C  
ATOM    527  C   ILE A  68      22.200   3.052  13.428  1.00 44.89           C  
ATOM    528  O   ILE A  68      23.167   2.635  14.032  1.00 49.41           O  
ATOM    529  CB  ILE A  68      22.833   5.395  13.997  1.00 42.46           C  
ATOM    530  CG1 ILE A  68      22.368   6.692  14.663  1.00 36.12           C  
ATOM    531  CG2 ILE A  68      23.539   5.665  12.682  1.00 39.84           C  
ATOM    532  CD1 ILE A  68      21.159   7.364  14.019  1.00 27.96           C  
ATOM    533  N   THR A  69      21.741   2.537  12.297  1.00 43.29           N  
ATOM    534  CA  THR A  69      22.215   1.281  11.775  1.00 42.54           C  
ATOM    535  C   THR A  69      23.405   1.515  10.865  1.00 43.42           C  
ATOM    536  O   THR A  69      24.291   0.676  10.724  1.00 47.94           O  
ATOM    537  CB  THR A  69      21.085   0.631  10.919  1.00 49.72           C  
ATOM    538  OG1 THR A  69      19.853   0.940  11.592  1.00 53.85           O  
ATOM    539  CG2 THR A  69      21.339  -0.859  10.822  1.00 43.32           C  
ATOM    540  N   ALA A  70      23.388   2.663  10.187  1.00 37.67           N  
ATOM    541  CA  ALA A  70      24.503   2.972   9.301  1.00 37.33           C  
ATOM    542  C   ALA A  70      24.774   4.463   9.197  1.00 36.73           C  
ATOM    543  O   ALA A  70      23.937   5.335   9.412  1.00 38.49           O  
ATOM    544  CB  ALA A  70      24.208   2.323   7.971  1.00 33.89           C  
ATOM    545  N   GLN A  71      26.030   4.843   9.015  1.00 40.34           N  
ATOM    546  CA  GLN A  71      26.436   6.251   8.926  1.00 40.69           C  
ATOM    547  C   GLN A  71      27.665   6.303   8.033  1.00 37.74           C  
ATOM    548  O   GLN A  71      28.516   5.445   8.203  1.00 38.60           O  
ATOM    549  CB  GLN A  71      26.687   6.918  10.261  1.00 38.96           C  
ATOM    550  CG  GLN A  71      27.654   6.268  11.228  1.00 35.83           C  
ATOM    551  CD  GLN A  71      27.923   7.211  12.403  1.00 40.31           C  
ATOM    552  OE1 GLN A  71      28.378   8.341  12.241  1.00 40.67           O  
ATOM    553  NE2 GLN A  71      27.606   6.821  13.619  1.00 32.56           N  
ATOM    554  N   ASP A  72      27.614   7.044   6.951  1.00 35.66           N  
ATOM    555  CA  ASP A  72      28.677   7.174   5.968  1.00 37.19           C  
ATOM    556  C   ASP A  72      29.033   8.654   5.840  1.00 39.53           C  
ATOM    557  O   ASP A  72      28.197   9.551   6.113  1.00 37.01           O  
ATOM    558  CB  ASP A  72      28.252   6.645   4.599  1.00 41.70           C  
ATOM    559  CG  ASP A  72      28.019   5.143   4.530  1.00 45.89           C  
ATOM    560  OD1 ASP A  72      28.766   4.347   5.137  1.00 44.94           O  
ATOM    561  OD2 ASP A  72      26.984   4.752   3.956  1.00 47.90           O  
ATOM    562  N   HIS A  73      30.329   9.018   5.998  1.00 36.60           N  
ATOM    563  CA  HIS A  73      30.885  10.353   6.019  1.00 33.88           C  
ATOM    564  C   HIS A  73      31.989  10.543   4.981  1.00 33.69           C  
ATOM    565  O   HIS A  73      32.751   9.608   4.738  1.00 33.52           O  
ATOM    566  CB  HIS A  73      31.598  10.765   7.350  1.00 29.57           C  
ATOM    567  CG  HIS A  73      30.727  10.369   8.499  1.00 32.53           C  
ATOM    568  ND1 HIS A  73      29.595  11.065   8.851  1.00 30.77           N  
ATOM    569  CD2 HIS A  73      30.727   9.197   9.196  1.00 33.77           C  
ATOM    570  CE1 HIS A  73      28.958  10.356   9.785  1.00 29.30           C  
ATOM    571  NE2 HIS A  73      29.648   9.252  10.047  1.00 33.54           N  
ATOM    572  N   GLN A  74      32.002  11.682   4.294  1.00 30.50           N  
ATOM    573  CA  GLN A  74      32.993  11.925   3.251  1.00 30.45           C  
ATOM    574  C   GLN A  74      33.274  13.452   3.260  1.00 37.84           C  
ATOM    575  O   GLN A  74      32.379  14.220   3.586  1.00 35.79           O  
ATOM    576  CB  GLN A  74      32.426  11.637   1.865  1.00 39.75           C  
ATOM    577  CG  GLN A  74      32.285  10.275   1.290  1.00 42.64           C  
ATOM    578  CD  GLN A  74      31.426  10.167   0.055  1.00 43.12           C  
ATOM    579  OE1 GLN A  74      31.018  11.192  -0.486  1.00 45.25           O  
ATOM    580  NE2 GLN A  74      31.186   8.926  -0.339  1.00 38.83           N  
ATOM    581  N   PRO A  75      34.554  13.838   3.087  1.00 39.56           N  
ATOM    582  CA  PRO A  75      34.909  15.222   2.877  1.00 35.62           C  
ATOM    583  C   PRO A  75      34.453  15.656   1.471  1.00 37.66           C  
ATOM    584  O   PRO A  75      34.436  14.830   0.546  1.00 32.73           O  
ATOM    585  CB  PRO A  75      36.443  15.175   2.871  1.00 34.36           C  
ATOM    586  CG  PRO A  75      36.846  13.844   2.338  1.00 29.03           C  
ATOM    587  CD  PRO A  75      35.700  12.920   2.725  1.00 37.84           C  
ATOM    588  N   THR A  76      34.107  16.926   1.284  1.00 37.45           N  
ATOM    589  CA  THR A  76      33.716  17.386  -0.054  1.00 41.98           C  
ATOM    590  C   THR A  76      34.832  18.249  -0.602  1.00 45.85           C  
ATOM    591  O   THR A  76      35.626  18.848   0.116  1.00 46.20           O  
ATOM    592  CB  THR A  76      32.390  18.165  -0.083  1.00 41.34           C  
ATOM    593  OG1 THR A  76      32.595  19.526   0.351  1.00 40.27           O  
ATOM    594  CG2 THR A  76      31.320  17.535   0.796  1.00 35.12           C  
ATOM    595  N   PRO A  77      34.739  18.623  -1.901  1.00 50.59           N  
ATOM    596  CA  PRO A  77      35.714  19.459  -2.579  1.00 52.39           C  
ATOM    597  C   PRO A  77      35.808  20.894  -2.112  1.00 56.27           C  
ATOM    598  O   PRO A  77      36.890  21.474  -1.913  1.00 58.69           O  
ATOM    599  CB  PRO A  77      35.309  19.420  -4.047  1.00 51.28           C  
ATOM    600  CG  PRO A  77      34.579  18.138  -4.234  1.00 50.53           C  
ATOM    601  CD  PRO A  77      33.832  17.980  -2.905  1.00 50.70           C  
ATOM    602  N   ASP A  78      34.732  21.484  -1.574  1.00 55.71           N  
ATOM    603  CA  ASP A  78      34.653  22.747  -0.905  1.00 50.81           C  
ATOM    604  C   ASP A  78      35.071  22.697   0.553  1.00 49.76           C  
ATOM    605  O   ASP A  78      34.918  23.667   1.327  1.00 49.79           O  
ATOM    606  CB  ASP A  78      33.278  23.417  -1.016  1.00 46.99           C  
ATOM    607  CG  ASP A  78      32.701  23.486  -2.422  1.00 48.14           C  
ATOM    608  OD1 ASP A  78      33.456  23.752  -3.387  1.00 52.03           O  
ATOM    609  OD2 ASP A  78      33.449  25.016  -2.759  0.00100.00           O  
ATOM    610  N   SER A  79      35.449  21.570   1.131  1.00 47.16           N  
ATOM    611  CA  SER A  79      35.952  21.379   2.465  1.00 43.83           C  
ATOM    612  C   SER A  79      34.856  21.169   3.482  1.00 39.28           C  
ATOM    613  O   SER A  79      35.032  21.351   4.686  1.00 39.23           O  
ATOM    614  CB  SER A  79      36.876  22.535   2.919  1.00 47.55           C  
ATOM    615  OG  SER A  79      38.215  22.219   2.613  1.00 49.52           O  
ATOM    616  N   CYS A  80      33.660  20.832   3.044  1.00 36.46           N  
ATOM    617  CA  CYS A  80      32.568  20.529   3.930  1.00 34.24           C  
ATOM    618  C   CYS A  80      32.638  19.040   4.224  1.00 36.25           C  
ATOM    619  O   CYS A  80      33.501  18.277   3.734  1.00 34.61           O  
ATOM    620  CB  CYS A  80      31.274  20.898   3.210  1.00 38.33           C  
ATOM    621  SG  CYS A  80      31.113  22.655   2.851  1.00 37.72           S  
ATOM    622  N   ILE A  81      31.735  18.594   5.093  1.00 34.96           N  
ATOM    623  CA  ILE A  81      31.633  17.176   5.418  1.00 37.56           C  
ATOM    624  C   ILE A  81      30.175  16.781   5.095  1.00 41.17           C  
ATOM    625  O   ILE A  81      29.229  17.430   5.571  1.00 40.71           O  
ATOM    626  CB  ILE A  81      32.017  16.808   6.853  1.00 40.26           C  
ATOM    627  CG1 ILE A  81      33.563  16.714   6.982  1.00 42.20           C  
ATOM    628  CG2 ILE A  81      31.491  15.446   7.317  1.00 32.19           C  
ATOM    629  CD1 ILE A  81      34.015  17.247   8.310  1.00 48.77           C  
ATOM    630  N   ILE A  82      30.050  15.712   4.311  1.00 36.57           N  
ATOM    631  CA  ILE A  82      28.689  15.232   4.027  1.00 39.79           C  
ATOM    632  C   ILE A  82      28.467  13.901   4.715  1.00 38.23           C  
ATOM    633  O   ILE A  82      29.352  13.031   4.709  1.00 42.84           O  
ATOM    634  CB  ILE A  82      28.465  15.293   2.515  1.00 41.97           C  
ATOM    635  CG1 ILE A  82      26.985  15.128   2.151  1.00 41.60           C  
ATOM    636  CG2 ILE A  82      29.349  14.346   1.743  1.00 38.37           C  
ATOM    637  CD1 ILE A  82      26.667  15.776   0.817  1.00 45.37           C  
ATOM    638  N   SER A  83      27.346  13.715   5.370  1.00 38.11           N  
ATOM    639  CA  SER A  83      26.975  12.510   6.087  1.00 39.83           C  
ATOM    640  C   SER A  83      25.622  11.919   5.662  1.00 41.09           C  
ATOM    641  O   SER A  83      24.600  12.605   5.637  1.00 37.71           O  
ATOM    642  CB  SER A  83      26.826  12.870   7.571  1.00 43.18           C  
ATOM    643  OG  SER A  83      28.004  13.257   8.195  1.00 44.31           O  
ATOM    644  N   MET A  84      25.547  10.611   5.446  1.00 43.09           N  
ATOM    645  CA  MET A  84      24.300   9.916   5.211  1.00 35.73           C  
ATOM    646  C   MET A  84      24.016   8.921   6.324  1.00 37.28           C  
ATOM    647  O   MET A  84      24.809   8.013   6.552  1.00 38.54           O  
ATOM    648  CB  MET A  84      24.326   9.172   3.868  1.00 40.77           C  
ATOM    649  CG  MET A  84      22.964   8.518   3.579  1.00 40.27           C  
ATOM    650  SD  MET A  84      22.712   7.939   1.921  1.00 40.43           S  
ATOM    651  CE  MET A  84      23.603   6.368   1.937  1.00 31.23           C  
ATOM    652  N   VAL A  85      22.866   9.020   6.978  1.00 39.78           N  
ATOM    653  CA  VAL A  85      22.393   8.170   8.051  1.00 37.74           C  
ATOM    654  C   VAL A  85      21.206   7.309   7.635  1.00 43.17           C  
ATOM    655  O   VAL A  85      20.189   7.814   7.158  1.00 46.97           O  
ATOM    656  CB  VAL A  85      21.964   8.991   9.274  1.00 38.28           C  
ATOM    657  CG1 VAL A  85      21.354   8.133  10.389  1.00 41.65           C  
ATOM    658  CG2 VAL A  85      23.134   9.760   9.888  1.00 40.42           C  
ATOM    659  N   VAL A  86      21.246   6.007   7.885  1.00 44.92           N  
ATOM    660  CA  VAL A  86      20.141   5.062   7.812  1.00 44.71           C  
ATOM    661  C   VAL A  86      19.918   4.431   9.193  1.00 47.00           C  
ATOM    662  O   VAL A  86      20.867   3.880   9.768  1.00 52.85           O  
ATOM    663  CB  VAL A  86      20.358   3.908   6.825  1.00 45.96           C  
ATOM    664  CG1 VAL A  86      19.133   2.980   6.787  1.00 44.98           C  
ATOM    665  CG2 VAL A  86      20.635   4.359   5.383  1.00 40.37           C  
ATOM    666  N   GLY A  87      18.710   4.416   9.720  1.00 43.94           N  
ATOM    667  CA  GLY A  87      18.467   3.784  11.011  1.00 45.58           C  
ATOM    668  C   GLY A  87      16.992   3.494  11.256  1.00 46.78           C  
ATOM    669  O   GLY A  87      16.184   3.484  10.333  1.00 52.46           O  
ATOM    670  N   GLN A  88      16.592   3.440  12.507  1.00 45.38           N  
ATOM    671  CA  GLN A  88      15.271   3.233  13.014  1.00 45.38           C  
ATOM    672  C   GLN A  88      14.942   4.247  14.132  1.00 44.57           C  
ATOM    673  O   GLN A  88      15.828   4.692  14.870  1.00 45.19           O  
ATOM    674  CB  GLN A  88      15.181   1.914  13.785  1.00 49.29           C  
ATOM    675  CG  GLN A  88      15.150   0.624  13.021  1.00 58.42           C  
ATOM    676  CD  GLN A  88      15.645  -0.506  13.929  1.00 59.30           C  
ATOM    677  OE1 GLN A  88      16.546  -1.226  13.505  1.00 61.87           O  
ATOM    678  NE2 GLN A  88      15.101  -0.595  15.129  1.00 57.94           N  
ATOM    679  N   LEU A  89      13.657   4.363  14.378  1.00 43.09           N  
ATOM    680  CA  LEU A  89      13.200   5.262  15.431  1.00 49.32           C  
ATOM    681  C   LEU A  89      11.895   4.693  15.998  1.00 47.77           C  
ATOM    682  O   LEU A  89      11.143   4.011  15.329  1.00 46.24           O  
ATOM    683  CB  LEU A  89      13.074   6.704  14.982  1.00 44.91           C  
ATOM    684  CG  LEU A  89      12.019   7.128  13.961  1.00 44.28           C  
ATOM    685  CD1 LEU A  89      10.641   7.407  14.575  1.00 31.28           C  
ATOM    686  CD2 LEU A  89      12.533   8.393  13.247  1.00 43.62           C  
ATOM    687  N   LYS A  90      11.670   5.027  17.237  1.00 50.23           N  
ATOM    688  CA  LYS A  90      10.503   4.633  17.987  1.00 53.50           C  
ATOM    689  C   LYS A  90      10.040   5.903  18.712  1.00 52.95           C  
ATOM    690  O   LYS A  90      10.809   6.449  19.494  1.00 56.54           O  
ATOM    691  CB  LYS A  90      10.810   3.518  18.982  1.00 55.24           C  
ATOM    692  CG  LYS A  90       9.556   2.746  19.397  1.00 59.66           C  
ATOM    693  CD  LYS A  90       9.255   2.199  18.995  0.00100.00           C  
ATOM    694  CE  LYS A  90       8.109   1.577  19.778  0.00 68.05           C  
ATOM    695  NZ  LYS A  90       7.277   0.681  18.929  0.00 80.73           N  
ATOM    696  N   ALA A  91       8.966   6.473  18.205  1.00 54.42           N  
ATOM    697  CA  ALA A  91       8.360   7.645  18.818  1.00 58.37           C  
ATOM    698  C   ALA A  91       7.141   7.191  19.633  1.00 61.97           C  
ATOM    699  O   ALA A  91       6.348   6.371  19.178  1.00 65.68           O  
ATOM    700  CB  ALA A  91       7.896   8.675  17.806  1.00 56.54           C  
ATOM    701  N   ASP A  92       7.001   7.749  20.822  1.00 62.24           N  
ATOM    702  CA  ASP A  92       5.868   7.395  21.680  1.00 64.33           C  
ATOM    703  C   ASP A  92       5.734   5.878  21.730  1.00 64.99           C  
ATOM    704  O   ASP A  92       6.736   5.207  21.985  1.00 65.26           O  
ATOM    705  CB  ASP A  92       4.603   8.109  21.212  1.00 62.75           C  
ATOM    706  CG  ASP A  92       4.635   9.610  21.457  1.00 61.07           C  
ATOM    707  OD1 ASP A  92       5.466  10.073  22.256  1.00 54.93           O  
ATOM    708  OD2 ASP A  92       3.808  10.330  20.854  1.00 64.91           O  
ATOM    709  N   GLU A  93       4.591   5.338  21.359  1.00 64.32           N  
ATOM    710  CA  GLU A  93       4.288   3.928  21.270  1.00 66.50           C  
ATOM    711  C   GLU A  93       3.819   3.602  19.852  1.00 67.77           C  
ATOM    712  O   GLU A  93       2.915   2.807  19.566  1.00 72.20           O  
ATOM    713  CB  GLU A  93       3.224   3.466  22.277  1.00 70.61           C  
ATOM    714  CG  GLU A  93       3.692   3.274  23.710  1.00 70.27           C  
ATOM    715  CD  GLU A  93       4.788   2.226  23.830  1.00 71.49           C  
ATOM    716  OE1 GLU A  93       4.701   1.343  21.984  0.00100.00           O  
ATOM    717  OE2 GLU A  93       5.693   1.897  23.907  0.00100.00           O  
ATOM    718  N   ASP A  94       4.355   4.365  18.903  1.00 63.65           N  
ATOM    719  CA  ASP A  94       4.062   4.083  17.496  1.00 58.63           C  
ATOM    720  C   ASP A  94       4.996   2.955  17.112  1.00 55.08           C  
ATOM    721  O   ASP A  94       5.921   2.561  17.815  1.00 50.64           O  
ATOM    722  CB  ASP A  94       4.218   5.348  16.674  1.00 67.63           C  
ATOM    723  CG  ASP A  94       3.390   6.513  17.176  1.00 77.14           C  
ATOM    724  OD1 ASP A  94       2.138   6.403  17.242  1.00 82.29           O  
ATOM    725  OD2 ASP A  94       3.934   7.578  17.545  1.00 80.57           O  
ATOM    726  N   PRO A  95       4.729   2.338  15.962  1.00 55.01           N  
ATOM    727  CA  PRO A  95       5.581   1.248  15.497  1.00 57.59           C  
ATOM    728  C   PRO A  95       7.016   1.721  15.288  1.00 57.75           C  
ATOM    729  O   PRO A  95       7.294   2.908  15.100  1.00 59.00           O  
ATOM    730  CB  PRO A  95       4.936   0.781  14.189  1.00 55.18           C  
ATOM    731  CG  PRO A  95       4.045   1.876  13.727  1.00 55.12           C  
ATOM    732  CD  PRO A  95       3.673   2.646  14.985  1.00 54.54           C  
ATOM    733  N   ILE A  96       7.947   0.778  15.195  1.00 56.01           N  
ATOM    734  CA  ILE A  96       9.316   1.114  14.826  1.00 54.59           C  
ATOM    735  C   ILE A  96       9.320   1.488  13.343  1.00 53.51           C  
ATOM    736  O   ILE A  96       8.689   0.803  12.542  1.00 52.88           O  
ATOM    737  CB  ILE A  96      10.318  -0.008  15.117  1.00 52.67           C  
ATOM    738  CG1 ILE A  96      10.391  -0.290  16.632  1.00 50.02           C  
ATOM    739  CG2 ILE A  96      11.739   0.315  14.623  1.00 49.90           C  
ATOM    740  CD1 ILE A  96      11.140  -1.591  16.943  1.00 45.03           C  
ATOM    741  N   MET A  97      10.032   2.563  13.006  1.00 52.15           N  
ATOM    742  CA  MET A  97      10.078   2.980  11.607  1.00 51.02           C  
ATOM    743  C   MET A  97      11.507   3.232  11.175  1.00 51.07           C  
ATOM    744  O   MET A  97      12.277   3.843  11.911  1.00 51.59           O  
ATOM    745  CB  MET A  97       9.272   4.262  11.387  1.00 57.94           C  
ATOM    746  CG  MET A  97       7.848   4.073  10.882  1.00 61.04           C  
ATOM    747  SD  MET A  97       6.634   4.542  12.096  1.00 65.89           S  
ATOM    748  CE  MET A  97       6.994   6.272  12.382  1.00 64.63           C  
ATOM    749  N   GLY A  98      11.863   2.806   9.976  1.00 50.50           N  
ATOM    750  CA  GLY A  98      13.177   3.116   9.408  1.00 46.07           C  
ATOM    751  C   GLY A  98      13.111   4.619   9.041  1.00 49.93           C  
ATOM    752  O   GLY A  98      11.998   5.127   8.847  1.00 48.48           O  
ATOM    753  N   PHE A  99      14.266   5.287   9.074  1.00 45.88           N  
ATOM    754  CA  PHE A  99      14.397   6.630   8.550  1.00 41.42           C  
ATOM    755  C   PHE A  99      15.738   6.741   7.789  1.00 42.52           C  
ATOM    756  O   PHE A  99      16.619   5.919   7.993  1.00 39.27           O  
ATOM    757  CB  PHE A  99      14.313   7.719   9.602  1.00 45.56           C  
ATOM    758  CG  PHE A  99      15.524   7.844  10.495  1.00 48.40           C  
ATOM    759  CD1 PHE A  99      15.639   7.035  11.608  1.00 41.82           C  
ATOM    760  CD2 PHE A  99      16.561   8.748  10.212  1.00 46.63           C  
ATOM    761  CE1 PHE A  99      16.754   7.131  12.434  1.00 43.82           C  
ATOM    762  CE2 PHE A  99      17.685   8.819  10.999  1.00 45.85           C  
ATOM    763  CZ  PHE A  99      17.767   8.014  12.136  1.00 45.52           C  
ATOM    764  N   HIS A 100      15.869   7.843   7.069  1.00 39.60           N  
ATOM    765  CA  HIS A 100      17.091   8.202   6.390  1.00 42.57           C  
ATOM    766  C   HIS A 100      17.246   9.734   6.553  1.00 42.95           C  
ATOM    767  O   HIS A 100      16.250  10.495   6.563  1.00 37.95           O  
ATOM    768  CB  HIS A 100      17.221   7.696   5.005  1.00 44.29           C  
ATOM    769  CG  HIS A 100      16.773   8.457   3.813  1.00 55.28           C  
ATOM    770  ND1 HIS A 100      17.371   8.305   2.565  1.00 57.59           N  
ATOM    771  CD2 HIS A 100      15.793   9.346   3.603  1.00 60.27           C  
ATOM    772  CE1 HIS A 100      16.747   9.031   1.675  1.00 58.80           C  
ATOM    773  NE2 HIS A 100      15.780   9.698   2.278  1.00 62.86           N  
ATOM    774  N   GLN A 101      18.470  10.080   6.946  1.00 35.92           N  
ATOM    775  CA  GLN A 101      18.808  11.479   7.150  1.00 35.05           C  
ATOM    776  C   GLN A 101      20.186  11.806   6.572  1.00 38.56           C  
ATOM    777  O   GLN A 101      21.089  10.982   6.462  1.00 39.33           O  
ATOM    778  CB  GLN A 101      18.699  11.808   8.625  1.00 30.72           C  
ATOM    779  CG  GLN A 101      18.641  13.306   8.885  1.00 33.38           C  
ATOM    780  CD  GLN A 101      18.060  13.643  10.232  1.00 33.91           C  
ATOM    781  OE1 GLN A 101      17.903  12.778  11.105  1.00 34.07           O  
ATOM    782  NE2 GLN A 101      17.733  14.933  10.404  1.00 34.34           N  
ATOM    783  N   MET A 102      20.286  12.986   6.003  1.00 37.60           N  
ATOM    784  CA  MET A 102      21.516  13.477   5.364  1.00 36.11           C  
ATOM    785  C   MET A 102      21.876  14.798   6.030  1.00 36.41           C  
ATOM    786  O   MET A 102      21.033  15.667   6.364  1.00 32.87           O  
ATOM    787  CB  MET A 102      21.294  13.647   3.907  1.00 33.34           C  
ATOM    788  CG  MET A 102      21.767  14.632   2.944  1.00 47.50           C  
ATOM    789  SD  MET A 102      22.080  16.355   3.361  1.00 46.83           S  
ATOM    790  CE  MET A 102      23.691  16.518   2.597  1.00 49.55           C  
ATOM    791  N   PHE A 103      23.177  15.010   6.275  1.00 31.08           N  
ATOM    792  CA  PHE A 103      23.642  16.279   6.824  1.00 33.51           C  
ATOM    793  C   PHE A 103      24.886  16.796   6.060  1.00 35.34           C  
ATOM    794  O   PHE A 103      25.777  16.062   5.594  1.00 30.14           O  
ATOM    795  CB  PHE A 103      23.997  16.257   8.289  1.00 27.01           C  
ATOM    796  CG  PHE A 103      23.044  15.720   9.318  1.00 27.11           C  
ATOM    797  CD1 PHE A 103      23.060  14.365   9.581  1.00 24.13           C  
ATOM    798  CD2 PHE A 103      22.126  16.529   9.959  1.00 27.60           C  
ATOM    799  CE1 PHE A 103      22.198  13.823  10.508  1.00 28.04           C  
ATOM    800  CE2 PHE A 103      21.258  15.982  10.893  1.00 31.30           C  
ATOM    801  CZ  PHE A 103      21.314  14.638  11.171  1.00 27.97           C  
ATOM    802  N   LEU A 104      24.858  18.098   5.775  1.00 32.82           N  
ATOM    803  CA  LEU A 104      26.022  18.767   5.215  1.00 35.14           C  
ATOM    804  C   LEU A 104      26.596  19.711   6.286  1.00 34.41           C  
ATOM    805  O   LEU A 104      25.888  20.550   6.861  1.00 35.59           O  
ATOM    806  CB  LEU A 104      25.735  19.497   3.929  1.00 33.77           C  
ATOM    807  CG  LEU A 104      26.917  19.945   3.088  1.00 39.83           C  
ATOM    808  CD1 LEU A 104      27.834  18.783   2.695  1.00 43.57           C  
ATOM    809  CD2 LEU A 104      26.412  20.625   1.825  1.00 38.95           C  
ATOM    810  N   LEU A 105      27.842  19.491   6.665  1.00 35.74           N  
ATOM    811  CA  LEU A 105      28.479  20.335   7.672  1.00 40.50           C  
ATOM    812  C   LEU A 105      29.534  21.260   7.063  1.00 40.83           C  
ATOM    813  O   LEU A 105      30.277  20.830   6.196  1.00 41.94           O  
ATOM    814  CB  LEU A 105      29.165  19.517   8.767  1.00 41.18           C  
ATOM    815  CG  LEU A 105      28.346  18.445   9.480  1.00 38.49           C  
ATOM    816  CD1 LEU A 105      29.226  17.630  10.421  1.00 38.20           C  
ATOM    817  CD2 LEU A 105      27.161  19.084  10.189  1.00 36.69           C  
ATOM    818  N   LYS A 106      29.563  22.498   7.549  1.00 40.24           N  
ATOM    819  CA  LYS A 106      30.563  23.451   7.103  1.00 44.75           C  
ATOM    820  C   LYS A 106      31.273  24.230   8.228  1.00 40.61           C  
ATOM    821  O   LYS A 106      30.719  24.482   9.301  1.00 38.00           O  
ATOM    822  CB  LYS A 106      29.889  24.489   6.173  1.00 50.30           C  
ATOM    823  CG  LYS A 106      30.942  25.213   5.345  1.00 51.77           C  
ATOM    824  CD  LYS A 106      30.460  26.543   4.800  1.00 60.15           C  
ATOM    825  CE  LYS A 106      31.386  26.982   3.666  1.00 64.58           C  
ATOM    826  NZ  LYS A 106      31.315  28.436   3.387  1.00 70.53           N  
ATOM    827  N   ASN A 107      32.562  24.475   8.069  1.00 36.54           N  
ATOM    828  CA  ASN A 107      33.365  25.162   9.078  1.00 42.27           C  
ATOM    829  C   ASN A 107      33.355  26.658   8.798  1.00 44.28           C  
ATOM    830  O   ASN A 107      33.953  27.140   7.851  1.00 40.92           O  
ATOM    831  CB  ASN A 107      34.832  24.690   9.143  1.00 38.78           C  
ATOM    832  CG  ASN A 107      35.390  24.984  10.529  1.00 35.93           C  
ATOM    833  OD1 ASN A 107      35.360  24.141  11.434  1.00 41.95           O  
ATOM    834  ND2 ASN A 107      35.902  26.174  10.718  1.00 31.10           N  
ATOM    835  N   ILE A 108      32.563  27.394   9.569  1.00 47.32           N  
ATOM    836  CA  ILE A 108      32.360  28.827   9.422  1.00 47.88           C  
ATOM    837  C   ILE A 108      32.757  29.518  10.722  1.00 44.07           C  
ATOM    838  O   ILE A 108      32.344  29.165  11.822  1.00 39.02           O  
ATOM    839  CB  ILE A 108      30.910  29.206   9.057  1.00 52.73           C  
ATOM    840  CG1 ILE A 108      30.563  28.782   7.619  1.00 63.10           C  
ATOM    841  CG2 ILE A 108      30.655  30.711   9.124  1.00 56.83           C  
ATOM    842  CD1 ILE A 108      29.090  28.661   7.307  1.00 61.00           C  
ATOM    843  N   ASN A 109      33.724  30.428  10.574  1.00 45.45           N  
ATOM    844  CA  ASN A 109      34.373  31.153  11.669  1.00 47.92           C  
ATOM    845  C   ASN A 109      34.830  30.238  12.787  1.00 46.86           C  
ATOM    846  O   ASN A 109      34.447  30.341  13.937  1.00 47.84           O  
ATOM    847  CB  ASN A 109      33.415  32.245  12.167  1.00 55.59           C  
ATOM    848  CG  ASN A 109      33.226  33.093  10.726  0.00100.00           C  
ATOM    849  OD1 ASN A 109      34.153  33.271   9.932  0.00100.00           O  
ATOM    850  ND2 ASN A 109      32.001  33.561  10.513  0.00100.00           N  
ATOM    851  N   ASP A 110      35.618  29.214  12.448  1.00 49.45           N  
ATOM    852  CA  ASP A 110      36.084  28.151  13.299  1.00 54.67           C  
ATOM    853  C   ASP A 110      34.960  27.433  14.032  1.00 54.82           C  
ATOM    854  O   ASP A 110      34.970  27.241  15.259  1.00 55.28           O  
ATOM    855  CB  ASP A 110      37.176  28.679  14.228  1.00 59.00           C  
ATOM    856  CG  ASP A 110      38.375  28.661  13.142  0.00100.00           C  
ATOM    857  OD1 ASP A 110      38.530  29.313  12.037  0.00100.00           O  
ATOM    858  OD2 ASP A 110      39.307  27.883  13.569  0.00100.00           O  
ATOM    859  N   ALA A 111      33.973  26.931  13.294  1.00 48.83           N  
ATOM    860  CA  ALA A 111      32.850  26.210  13.900  1.00 42.25           C  
ATOM    861  C   ALA A 111      32.103  25.424  12.821  1.00 43.49           C  
ATOM    862  O   ALA A 111      31.843  25.855  11.728  1.00 46.21           O  
ATOM    863  CB  ALA A 111      32.000  27.183  14.659  1.00 35.97           C  
ATOM    864  N   TRP A 112      32.011  24.131  13.090  1.00 41.63           N  
ATOM    865  CA  TRP A 112      31.323  23.101  12.344  1.00 41.25           C  
ATOM    866  C   TRP A 112      29.840  23.374  12.573  1.00 38.90           C  
ATOM    867  O   TRP A 112      29.422  23.428  13.725  1.00 39.67           O  
ATOM    868  CB  TRP A 112      31.679  21.649  12.693  1.00 27.15           C  
ATOM    869  CG  TRP A 112      33.056  21.310  12.183  1.00 35.22           C  
ATOM    870  CD1 TRP A 112      34.186  21.153  12.935  1.00 26.01           C  
ATOM    871  CD2 TRP A 112      33.442  21.130  10.809  1.00 38.57           C  
ATOM    872  NE1 TRP A 112      35.229  20.883  12.073  1.00 36.97           N  
ATOM    873  CE2 TRP A 112      34.838  20.864  10.778  1.00 32.87           C  
ATOM    874  CE3 TRP A 112      32.746  21.142   9.603  1.00 37.15           C  
ATOM    875  CZ2 TRP A 112      35.522  20.633   9.601  1.00 36.69           C  
ATOM    876  CZ3 TRP A 112      33.422  20.933   8.420  1.00 40.96           C  
ATOM    877  CH2 TRP A 112      34.803  20.673   8.424  1.00 41.68           C  
ATOM    878  N   VAL A 113      29.144  23.768  11.517  1.00 37.91           N  
ATOM    879  CA  VAL A 113      27.714  24.033  11.553  1.00 41.23           C  
ATOM    880  C   VAL A 113      26.949  23.254  10.468  1.00 36.99           C  
ATOM    881  O   VAL A 113      27.454  22.975   9.358  1.00 35.42           O  
ATOM    882  CB  VAL A 113      27.354  25.508  11.347  1.00 42.29           C  
ATOM    883  CG1 VAL A 113      27.686  26.420  12.495  1.00 44.01           C  
ATOM    884  CG2 VAL A 113      28.026  26.052  10.095  1.00 47.92           C  
ATOM    885  N   CYS A 114      25.684  22.954  10.752  1.00 36.11           N  
ATOM    886  CA  CYS A 114      24.898  22.219   9.741  1.00 33.55           C  
ATOM    887  C   CYS A 114      24.281  23.194   8.750  1.00 36.51           C  
ATOM    888  O   CYS A 114      23.438  24.021   9.151  1.00 36.95           O  
ATOM    889  CB  CYS A 114      23.762  21.378  10.352  1.00 34.21           C  
ATOM    890  SG  CYS A 114      22.984  20.321   9.064  1.00 35.85           S  
ATOM    891  N   THR A 115      24.671  23.119   7.465  1.00 35.50           N  
ATOM    892  CA  THR A 115      23.983  24.046   6.564  1.00 39.76           C  
ATOM    893  C   THR A 115      22.729  23.389   5.974  1.00 39.27           C  
ATOM    894  O   THR A 115      21.978  24.033   5.221  1.00 39.07           O  
ATOM    895  CB  THR A 115      24.843  24.514   5.382  1.00 38.47           C  
ATOM    896  OG1 THR A 115      25.232  23.339   4.652  1.00 34.81           O  
ATOM    897  CG2 THR A 115      26.020  25.331   5.863  1.00 34.21           C  
ATOM    898  N   ASN A 116      22.844  22.108   5.637  1.00 39.26           N  
ATOM    899  CA  ASN A 116      21.825  21.362   4.936  1.00 39.50           C  
ATOM    900  C   ASN A 116      21.423  20.101   5.695  1.00 41.53           C  
ATOM    901  O   ASN A 116      22.267  19.369   6.204  1.00 38.76           O  
ATOM    902  CB  ASN A 116      22.321  21.032   3.546  1.00 35.94           C  
ATOM    903  CG  ASN A 116      22.361  22.170   2.551  1.00 39.52           C  
ATOM    904  OD1 ASN A 116      21.389  22.586   1.910  1.00 52.44           O  
ATOM    905  ND2 ASN A 116      23.509  22.828   2.566  1.00 46.31           N  
ATOM    906  N   ASP A 117      20.127  19.909   5.900  1.00 43.53           N  
ATOM    907  CA  ASP A 117      19.610  18.700   6.553  1.00 39.42           C  
ATOM    908  C   ASP A 117      18.394  18.201   5.761  1.00 38.16           C  
ATOM    909  O   ASP A 117      17.530  18.991   5.374  1.00 39.24           O  
ATOM    910  CB  ASP A 117      19.319  19.032   7.982  1.00 32.99           C  
ATOM    911  CG  ASP A 117      18.722  17.963   8.853  1.00 42.62           C  
ATOM    912  OD1 ASP A 117      18.347  16.852   8.412  1.00 42.07           O  
ATOM    913  OD2 ASP A 117      18.597  18.249  10.066  1.00 44.01           O  
ATOM    914  N   MET A 118      18.305  16.903   5.488  1.00 36.74           N  
ATOM    915  CA  MET A 118      17.187  16.248   4.831  1.00 38.32           C  
ATOM    916  C   MET A 118      16.808  14.951   5.563  1.00 41.45           C  
ATOM    917  O   MET A 118      17.612  14.013   5.608  1.00 43.58           O  
ATOM    918  CB  MET A 118      17.369  15.820   3.383  1.00 31.40           C  
ATOM    919  CG  MET A 118      17.484  16.959   2.344  1.00 38.29           C  
ATOM    920  SD  MET A 118      18.059  16.310   0.792  1.00 39.35           S  
ATOM    921  CE  MET A 118      18.685  17.689  -0.045  1.00 46.57           C  
ATOM    922  N   PHE A 119      15.608  14.937   6.104  1.00 36.21           N  
ATOM    923  CA  PHE A 119      15.048  13.789   6.788  1.00 38.19           C  
ATOM    924  C   PHE A 119      13.864  13.204   5.997  1.00 41.36           C  
ATOM    925  O   PHE A 119      12.872  13.921   5.754  1.00 38.02           O  
ATOM    926  CB  PHE A 119      14.546  14.213   8.164  1.00 34.32           C  
ATOM    927  CG  PHE A 119      13.865  13.150   8.968  1.00 39.42           C  
ATOM    928  CD1 PHE A 119      14.607  12.201   9.669  1.00 40.14           C  
ATOM    929  CD2 PHE A 119      12.478  13.029   8.978  1.00 40.04           C  
ATOM    930  CE1 PHE A 119      13.992  11.194  10.390  1.00 36.96           C  
ATOM    931  CE2 PHE A 119      11.858  12.038   9.714  1.00 38.11           C  
ATOM    932  CZ  PHE A 119      12.612  11.147  10.445  1.00 34.85           C  
ATOM    933  N   ARG A 120      13.816  11.874   5.955  1.00 41.58           N  
ATOM    934  CA  ARG A 120      12.644  11.203   5.364  1.00 40.45           C  
ATOM    935  C   ARG A 120      12.365   9.896   6.081  1.00 37.75           C  
ATOM    936  O   ARG A 120      13.242   9.055   6.319  1.00 37.47           O  
ATOM    937  CB  ARG A 120      12.781  11.005   3.861  1.00 37.78           C  
ATOM    938  CG  ARG A 120      11.550  10.506   3.156  1.00 45.09           C  
ATOM    939  CD  ARG A 120      11.632  10.478   1.651  1.00 39.71           C  
ATOM    940  NE  ARG A 120      11.410  11.742   0.982  1.00 37.32           N  
ATOM    941  CZ  ARG A 120      10.253  12.385   0.944  1.00 40.36           C  
ATOM    942  NH1 ARG A 120       9.175  11.908   1.571  1.00 47.49           N  
ATOM    943  NH2 ARG A 120      10.169  13.525   0.295  1.00 35.54           N  
ATOM    944  N   LEU A 121      11.147   9.752   6.595  1.00 40.46           N  
ATOM    945  CA  LEU A 121      10.740   8.473   7.185  1.00 39.81           C  
ATOM    946  C   LEU A 121      10.586   7.407   6.093  1.00 42.91           C  
ATOM    947  O   LEU A 121      10.268   7.735   4.938  1.00 43.22           O  
ATOM    948  CB  LEU A 121       9.408   8.571   7.849  1.00 39.01           C  
ATOM    949  CG  LEU A 121       9.233   8.704   9.344  1.00 49.76           C  
ATOM    950  CD1 LEU A 121       7.760   8.368   9.633  1.00 40.90           C  
ATOM    951  CD2 LEU A 121      10.180   7.821  10.155  1.00 45.57           C  
ATOM    952  N   ALA A 122      10.734   6.159   6.503  1.00 44.77           N  
ATOM    953  CA  ALA A 122      10.348   5.047   5.632  1.00 45.12           C  
ATOM    954  C   ALA A 122       8.874   5.237   5.257  1.00 44.37           C  
ATOM    955  O   ALA A 122       8.055   5.743   6.023  1.00 40.78           O  
ATOM    956  CB  ALA A 122      10.478   3.702   6.303  1.00 40.85           C  
ATOM    957  N   LEU A 123       8.568   4.795   4.028  1.00 46.19           N  
ATOM    958  CA  LEU A 123       7.189   4.920   3.553  1.00 51.28           C  
ATOM    959  C   LEU A 123       6.299   3.738   3.916  1.00 52.44           C  
ATOM    960  O   LEU A 123       5.077   3.952   4.043  1.00 51.23           O  
ATOM    961  CB  LEU A 123       7.173   5.328   2.086  1.00 50.36           C  
ATOM    962  CG  LEU A 123       7.587   6.801   1.867  1.00 46.69           C  
ATOM    963  CD1 LEU A 123       7.950   7.015   0.416  1.00 53.11           C  
ATOM    964  CD2 LEU A 123       6.463   7.721   2.286  1.00 41.56           C  
ATOM    965  N   HIS A 124       6.834   2.620   4.390  1.00 51.86           N  
ATOM    966  CA  HIS A 124       6.099   1.482   4.876  1.00 57.66           C  
ATOM    967  C   HIS A 124       6.492   1.017   6.265  1.00 59.89           C  
ATOM    968  O   HIS A 124       7.662   1.044   6.638  1.00 62.86           O  
ATOM    969  CB  HIS A 124       6.297   0.300   3.889  1.00 60.15           C  
ATOM    970  CG  HIS A 124       5.162  -0.670   4.105  1.00 67.79           C  
ATOM    971  ND1 HIS A 124       3.846  -0.279   3.925  1.00 67.81           N  
ATOM    972  CD2 HIS A 124       5.138  -1.906   4.659  1.00 65.21           C  
ATOM    973  CE1 HIS A 124       3.062  -1.290   4.252  1.00 69.98           C  
ATOM    974  NE2 HIS A 124       3.823  -2.284   4.696  1.00 70.25           N  
ATOM    975  N   ASN A 125       5.594   0.446   7.041  1.00 65.28           N  
ATOM    976  CA  ASN A 125       5.850  -0.064   8.381  1.00 68.25           C  
ATOM    977  C   ASN A 125       5.971  -1.567   8.451  1.00 69.63           C  
ATOM    978  O   ASN A 125       6.618  -2.154   7.587  1.00 77.39           O  
ATOM    979  CB  ASN A 125       4.824   0.502   9.372  1.00 69.76           C  
ATOM    980  CG  ASN A 125       3.172  -0.948   8.242  0.00100.00           C  
ATOM    981  OD1 ASN A 125       3.492  -1.727   7.335  0.00100.00           O  
ATOM    982  ND2 ASN A 125       1.911  -0.927   8.650  0.00100.00           N  
ATOM    983  N   PHE A 126       5.492  -2.217   9.486  1.00 70.96           N  
ATOM    984  CA  PHE A 126       5.541  -3.655   9.696  1.00 68.74           C  
ATOM    985  C   PHE A 126       4.566  -3.971  10.832  1.00 69.40           C  
ATOM    986  O   PHE A 126       4.944  -3.619  11.955  1.00 68.93           O  
ATOM    987  CB  PHE A 126       6.972  -4.138   9.992  1.00 65.63           C  
ATOM    988  CG  PHE A 126       7.074  -5.632   9.792  1.00 61.67           C  
ATOM    989  CD1 PHE A 126       7.209  -6.108   8.501  1.00 60.80           C  
ATOM    990  CD2 PHE A 126       6.914  -6.532  10.820  1.00 58.65           C  
ATOM    991  CE1 PHE A 126       7.224  -7.462   8.244  1.00 59.54           C  
ATOM    992  CE2 PHE A 126       6.939  -7.897  10.555  1.00 58.14           C  
ATOM    993  CZ  PHE A 126       7.095  -8.363   9.281  1.00 53.74           C  
ATOM    994  N   GLY A 127       3.313  -4.360  10.523  1.00 69.39           N  
ATOM    995  CA  GLY A 127       2.304  -4.550  11.538  1.00 67.15           C  
ATOM    996  C   GLY A 127       1.107  -5.432  11.287  1.00 70.55           C  
ATOM    997  O   GLY A 127       1.060  -6.576  11.893  1.00 69.24           O  
TER     998      GLY A 127                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
