
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  158 ( 1345),  selected  158 , name 2imj_A
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 2imj_A.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     5_A      M       1           -
LGA    Q     6_A      M       2           -
LGA    V     7_A      T       3           -
LGA    R     8_A      H       4           -
LGA    P     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    L    11_A      Y       5           #
LGA    P    12_A      -       -           -
LGA    P    13_A      -       -           -
LGA    F    14_A      S       6           #
LGA    T    15_A      D       7          3.533
LGA    R    16_A      N       8           -
LGA    E    17_A      T       9           -
LGA    S    18_A      L      10          3.849
LGA    A    19_A      -       -           -
LGA    I    20_A      -       -           -
LGA    E    21_A      K      11          4.346
LGA    K    22_A      V      12          3.924
LGA    I    23_A      A      13          4.492
LGA    R    24_A      H      14          3.861
LGA    L    25_A      Q      15          2.468
LGA    A    26_A      G      16          2.630
LGA    E    27_A      F      17          3.069
LGA    D    28_A      E      18          2.269
LGA    G    29_A      F      19          0.890
LGA    W    30_A      F      20          1.970
LGA    N    31_A      T      21          2.675
LGA    S    32_A      Q      22          2.179
LGA    R    33_A      G      23          2.175
LGA    -       -      L      24           -
LGA    -       -      A      25           -
LGA    -       -      T      26           -
LGA    -       -      G      27           -
LGA    D    34_A      E      28          1.169
LGA    P    35_A      W      29          2.136
LGA    E    36_A      Q      30          1.879
LGA    R    37_A      K      31          1.908
LGA    V    38_A      F      32          1.584
LGA    S    39_A      L      33          1.083
LGA    L    40_A      D      34          1.297
LGA    A    41_A      M      35          1.763
LGA    Y    42_A      L      36          1.251
LGA    T    43_A      T      37          0.847
LGA    L    44_A      E      38          1.267
LGA    D    45_A      D      39          1.543
LGA    T    46_A      F      40          0.451
LGA    Q    47_A      T      41          0.855
LGA    W    48_A      F      42          0.565
LGA    R    49_A      W      43          0.532
LGA    N    50_A      F      44          1.957
LGA    R    51_A      P      45          2.188
LGA    A    52_A      M      46          2.483
LGA    -       -      G      47           -
LGA    -       -      E      48           -
LGA    E    53_A      F      49          2.299
LGA    -       -      H      50           -
LGA    -       -      G      51           -
LGA    F    54_A      L      52          3.577
LGA    A    55_A      N      53          2.111
LGA    H    56_A      V      54          0.314
LGA    N    57_A      G      55          0.320
LGA    R    58_A      K      56          0.954
LGA    E    59_A      E      57          1.132
LGA    E    60_A      R      58          0.611
LGA    A    61_A      A      59          0.556
LGA    K    62_A      K      60          0.955
LGA    A    63_A      E      61          0.941
LGA    F    64_A      F      62          0.563
LGA    L    65_A      F      63          0.557
LGA    T    66_A      T      64          0.630
LGA    R    67_A      Y      65          0.924
LGA    K    68_A      V      66          0.744
LGA    W    69_A      S      67          0.628
LGA    A    70_A      E      68          0.847
LGA    K    71_A      S      69          1.578
LGA    E    72_A      F      70          2.690
LGA    L    73_A      H      71          3.558
LGA    D    74_A      T      72          2.959
LGA    -       -      G      73           -
LGA    Y    75_A      I      74          1.064
LGA    R    76_A      Q      75          0.822
LGA    L    77_A      I      76          1.926
LGA    -       -      S      77           -
LGA    I    78_A      S      78          4.310
LGA    K    79_A      L      79          3.671
LGA    E    80_A      D      80          4.637
LGA    L    81_A      R      81          4.028
LGA    W    82_A      V      82          3.373
LGA    A    83_A      T      83          2.038
LGA    F    84_A      S      84          1.096
LGA    T    85_A      N      85          0.987
LGA    D    86_A      E      86          0.491
LGA    N    87_A      T      87          1.247
LGA    R    88_A      T      88          1.323
LGA    I    89_A      V      89          1.275
LGA    A    90_A      V      90          2.050
LGA    V    91_A      F      91          1.835
LGA    R    92_A      E      92          0.725
LGA    Y    93_A      F      93          1.527
LGA    A    94_A      R      94          1.959
LGA    Y    95_A      D      95          1.526
LGA    E    96_A      E      96          0.613
LGA    W    97_A      G      97          0.729
LGA    H    98_A      L      98          1.211
LGA    D    99_A      F      99          1.164
LGA    D   100_A      L     100          1.057
LGA    S   101_A      G     101          4.171
LGA    G   102_A      K     102          2.754
LGA    N   103_A      -       -           -
LGA    W   104_A      P     103          0.599
LGA    F   105_A      Y     104          1.613
LGA    R   106_A      K     105          1.292
LGA    S   107_A      N     106          1.637
LGA    Y   108_A      R     107          1.029
LGA    G   109_A      V     108          0.864
LGA    N   110_A      A     109          1.243
LGA    E   111_A      V     110          1.727
LGA    N   112_A      S     111          1.823
LGA    W   113_A      F     112          1.591
LGA    E   114_A      D     113          1.129
LGA    F   115_A      V     114          1.211
LGA    D   116_A      R     115          1.222
LGA    E   117_A      G     116          2.554
LGA    Q   118_A      D     117          3.155
LGA    G   119_A      -       -           -
LGA    L   120_A      K     118          1.232
LGA    X   121_A      I     119          1.201
LGA    A   122_A      C     120          1.088
LGA    R   123_A      S     121          1.505
LGA    R   124_A      Y     122          0.999
LGA    F   125_A      R     123          1.181
LGA    A   126_A      E     124          0.920
LGA    C   127_A      Y     125          0.984
LGA    I   128_A      F     126          2.091
LGA    -       -      G     127           -
LGA    N   129_A      S     128          4.060
LGA    D   130_A      D     129          3.535
LGA    X   131_A      G     130          2.890
LGA    P   132_A      K     131          1.474
LGA    I   133_A      S     132          5.049
LGA    K   134_A      -       -           -
LGA    A   135_A      -       -           -
LGA    Q   136_A      -       -           -
LGA    E   137_A      -       -           -
LGA    R   138_A      -       -           -
LGA    K   139_A      -       -           -
LGA    F   140_A      -       -           -
LGA    H   141_A      -       -           -
LGA    W   142_A      -       -           -
LGA    P   143_A      -       -           -
LGA    L   144_A      -       -           -
LGA    G   145_A      -       -           -
LGA    R   146_A      -       -           -
LGA    R   147_A      -       -           -
LGA    P   148_A      -       -           -
LGA    D   149_A      -       -           -
LGA    D   150_A      -       -           -
LGA    H   151_A      -       -           -
LGA    P   152_A      -       -           -
LGA    G   153_A      -       -           -
LGA    L   154_A      -       -           -
LGA    S   155_A      -       -           -
LGA    E   156_A      -       -           -
LGA    L   157_A      -       -           -
LGA    G   158_A      -       -           -
LGA    L   159_A      -       -           -
LGA    E   160_A      N     133          4.746
LGA    H   161_A      -       -           -
LGA    H   162_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  158  133    5.0    114    2.17     7.89     72.569     5.012

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.438944 * X  +   0.750099 * Y  +   0.494650 * Z  + -54.807037
  Y_new =   0.804688 * X  +  -0.083244 * Y  +  -0.587833 * Z  +  83.834579
  Z_new =  -0.399757 * X  +   0.656065 * Y  +  -0.640135 * Z  +  -3.169345 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.343906   -0.797687  [ DEG:   134.2959    -45.7041 ]
  Theta =   0.411251    2.730341  [ DEG:    23.5630    156.4370 ]
  Phi   =   1.071427   -2.070166  [ DEG:    61.3882   -118.6117 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2imj_A                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2imj_A.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  158  133   5.0  114   2.17    7.89  72.569
REMARK  ---------------------------------------------------------- 
MOLECULE 2imj_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   04-OCT-06   2IMJ              
TITLE     X-RAY CRYSTAL STRUCTURE OF PROTEIN PFL_3262 FROM                      
TITLE    2 PSEUDOMONAS FLUORESCENS. NORTHEAST STRUCTURAL GENOMICS               
TITLE    3 CONSORTIUM TARGET PLR14.                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN DUF1348;                              
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PF-5, ATCC BAA-477;                                          
SOURCE   5 GENE: PFL_3262;                                                      
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    ALPHA BETA PROTEIN, STRUCTURAL GENOMICS, PSI-2, PROTEIN               
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    W.ZHOU,F.FOROUHAR,J.SEETHARAMAN,C.X.CHEN,Y.FANG,                      
AUTHOR   2 K.CUNNINGHAM,L.-C.MA,R.XIAO,J.LIU,M.C.BARAN,T.B.ACTON,               
AUTHOR   3 G.T.MONTELIONE,J.F.HUNT,L.TONG,NORTHEAST STRUCTURAL                  
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   24-OCT-06 2IMJ    0                                                
JRNL        AUTH   W.ZHOU,F.FOROUHAR,J.SEETHARAMAN,C.X.CHEN,Y.FANG,             
JRNL        AUTH 2 K.CUNNINGHAM,L.-C.MA,R.XIAO,J.LIU,M.C.BARAN,                 
JRNL        AUTH 3 T.B.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG,                    
JRNL        AUTH 4 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)              
JRNL        TITL   CRYSTAL STRUCTURE OF THE HYPOTHETICAL PROTEIN                
JRNL        TITL 2 (DUF1348) FROM PSEUDOMONAS FLUORESCENS, NORTHEAST            
JRNL        TITL 3 STRUCTURAL GENOMICS TARGET PLR14.                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2IMJ A    1   158  UNP    Q4KBL6   Q4KBL6_PSEF5     1    159             
DBREF  2IMJ B    1   158  UNP    Q4KBL6   Q4KBL6_PSEF5     1    159             
DBREF  2IMJ C    1   158  UNP    Q4KBL6   Q4KBL6_PSEF5     1    159             
DBREF  2IMJ D    1   158  UNP    Q4KBL6   Q4KBL6_PSEF5     1    159             
SEQRES   1 A  166  MSE SER SER ASN ALA GLN VAL ARG PRO PRO LEU PRO PRO          
SEQRES   2 A  166  PHE THR ARG GLU SER ALA ILE GLU LYS ILE ARG LEU ALA          
SEQRES   3 A  166  GLU ASP GLY TRP ASN SER ARG ASP PRO GLU ARG VAL SER          
SEQRES   4 A  166  LEU ALA TYR THR LEU ASP THR GLN TRP ARG ASN ARG ALA          
SEQRES   5 A  166  GLU PHE ALA HIS ASN ARG GLU GLU ALA LYS ALA PHE LEU          
SEQRES   6 A  166  THR ARG LYS TRP ALA LYS GLU LEU ASP TYR ARG LEU ILE          
SEQRES   7 A  166  LYS GLU LEU TRP ALA PHE THR ASP ASN ARG ILE ALA VAL          
SEQRES   8 A  166  ARG TYR ALA TYR GLU TRP HIS ASP ASP SER GLY ASN TRP          
SEQRES   9 A  166  PHE ARG SER TYR GLY ASN GLU ASN TRP GLU PHE ASP GLU          
SEQRES  10 A  166  GLN GLY LEU MSE ALA ARG ARG PHE ALA CYS ILE ASN ASP          
SEQRES  11 A  166  MSE PRO ILE LYS ALA GLN GLU ARG LYS PHE HIS TRP PRO          
SEQRES  12 A  166  LEU GLY ARG ARG PRO ASP ASP HIS PRO GLY LEU SER GLU          
SEQRES  13 A  166  LEU GLY LEU GLU HIS HIS HIS HIS HIS HIS                      
SEQRES   1 B  166  MSE SER SER ASN ALA GLN VAL ARG PRO PRO LEU PRO PRO          
SEQRES   2 B  166  PHE THR ARG GLU SER ALA ILE GLU LYS ILE ARG LEU ALA          
SEQRES   3 B  166  GLU ASP GLY TRP ASN SER ARG ASP PRO GLU ARG VAL SER          
SEQRES   4 B  166  LEU ALA TYR THR LEU ASP THR GLN TRP ARG ASN ARG ALA          
SEQRES   5 B  166  GLU PHE ALA HIS ASN ARG GLU GLU ALA LYS ALA PHE LEU          
SEQRES   6 B  166  THR ARG LYS TRP ALA LYS GLU LEU ASP TYR ARG LEU ILE          
SEQRES   7 B  166  LYS GLU LEU TRP ALA PHE THR ASP ASN ARG ILE ALA VAL          
SEQRES   8 B  166  ARG TYR ALA TYR GLU TRP HIS ASP ASP SER GLY ASN TRP          
SEQRES   9 B  166  PHE ARG SER TYR GLY ASN GLU ASN TRP GLU PHE ASP GLU          
SEQRES  10 B  166  GLN GLY LEU MSE ALA ARG ARG PHE ALA CYS ILE ASN ASP          
SEQRES  11 B  166  MSE PRO ILE LYS ALA GLN GLU ARG LYS PHE HIS TRP PRO          
SEQRES  12 B  166  LEU GLY ARG ARG PRO ASP ASP HIS PRO GLY LEU SER GLU          
SEQRES  13 B  166  LEU GLY LEU GLU HIS HIS HIS HIS HIS HIS                      
SEQRES   1 C  166  MSE SER SER ASN ALA GLN VAL ARG PRO PRO LEU PRO PRO          
SEQRES   2 C  166  PHE THR ARG GLU SER ALA ILE GLU LYS ILE ARG LEU ALA          
SEQRES   3 C  166  GLU ASP GLY TRP ASN SER ARG ASP PRO GLU ARG VAL SER          
SEQRES   4 C  166  LEU ALA TYR THR LEU ASP THR GLN TRP ARG ASN ARG ALA          
SEQRES   5 C  166  GLU PHE ALA HIS ASN ARG GLU GLU ALA LYS ALA PHE LEU          
SEQRES   6 C  166  THR ARG LYS TRP ALA LYS GLU LEU ASP TYR ARG LEU ILE          
SEQRES   7 C  166  LYS GLU LEU TRP ALA PHE THR ASP ASN ARG ILE ALA VAL          
SEQRES   8 C  166  ARG TYR ALA TYR GLU TRP HIS ASP ASP SER GLY ASN TRP          
SEQRES   9 C  166  PHE ARG SER TYR GLY ASN GLU ASN TRP GLU PHE ASP GLU          
SEQRES  10 C  166  GLN GLY LEU MSE ALA ARG ARG PHE ALA CYS ILE ASN ASP          
SEQRES  11 C  166  MSE PRO ILE LYS ALA GLN GLU ARG LYS PHE HIS TRP PRO          
SEQRES  12 C  166  LEU GLY ARG ARG PRO ASP ASP HIS PRO GLY LEU SER GLU          
SEQRES  13 C  166  LEU GLY LEU GLU HIS HIS HIS HIS HIS HIS                      
SEQRES   1 D  166  MSE SER SER ASN ALA GLN VAL ARG PRO PRO LEU PRO PRO          
SEQRES   2 D  166  PHE THR ARG GLU SER ALA ILE GLU LYS ILE ARG LEU ALA          
SEQRES   3 D  166  GLU ASP GLY TRP ASN SER ARG ASP PRO GLU ARG VAL SER          
SEQRES   4 D  166  LEU ALA TYR THR LEU ASP THR GLN TRP ARG ASN ARG ALA          
SEQRES   5 D  166  GLU PHE ALA HIS ASN ARG GLU GLU ALA LYS ALA PHE LEU          
SEQRES   6 D  166  THR ARG LYS TRP ALA LYS GLU LEU ASP TYR ARG LEU ILE          
SEQRES   7 D  166  LYS GLU LEU TRP ALA PHE THR ASP ASN ARG ILE ALA VAL          
SEQRES   8 D  166  ARG TYR ALA TYR GLU TRP HIS ASP ASP SER GLY ASN TRP          
SEQRES   9 D  166  PHE ARG SER TYR GLY ASN GLU ASN TRP GLU PHE ASP GLU          
SEQRES  10 D  166  GLN GLY LEU MSE ALA ARG ARG PHE ALA CYS ILE ASN ASP          
SEQRES  11 D  166  MSE PRO ILE LYS ALA GLN GLU ARG LYS PHE HIS TRP PRO          
SEQRES  12 D  166  LEU GLY ARG ARG PRO ASP ASP HIS PRO GLY LEU SER GLU          
SEQRES  13 D  166  LEU GLY LEU GLU HIS HIS HIS HIS HIS HIS                      
HET    MSE  A 121       8                                                       
HET    MSE  A 131       8                                                       
HET    MSE  B 121       8                                                       
HET    MSE  B 131       8                                                       
HET    MSE  C 121       8                                                       
HET    MSE  C 131       8                                                       
HET    MSE  D 121       8                                                       
HET    MSE  D 131       8                                                       
HET    ACT  A 201       4                                                       
HET    ACT  A 202       4                                                       
HET    ACT  A 203       4                                                       
HET    ACT  B 201       4                                                       
HET    ACT  C 201       4                                                       
HET    ACT  D 201       4                                                       
HET    EDO  A 301       4                                                       
HET    EDO  A 302       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACT ACETATE ION                                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   5  ACT    6(C2 H3 O2 1-)                                               
FORMUL  11  EDO    2(C2 H6 O2)                                                  
FORMUL  13  HOH   *905(H2 O)                                                    
CRYST1   51.858   88.760   74.704  90.00 103.26  90.00 P 1 21 1      8          
ATOM      1  N   ALA A   5      29.604  32.787  15.469  1.00 30.73           N  
ATOM      2  CA  ALA A   5      31.072  32.529  15.500  1.00 31.89           C  
ATOM      3  C   ALA A   5      31.381  31.162  16.101  1.00 30.35           C  
ATOM      4  O   ALA A   5      32.371  31.000  16.824  1.00 30.61           O  
ATOM      5  CB  ALA A   5      31.771  33.624  16.295  1.00 32.22           C  
ATOM      6  N   GLN A   6      30.537  30.178  15.796  1.00 33.78           N  
ATOM      7  CA  GLN A   6      30.732  28.822  16.308  1.00 30.06           C  
ATOM      8  C   GLN A   6      31.718  28.017  15.471  1.00 27.96           C  
ATOM      9  O   GLN A   6      32.005  28.343  14.318  1.00 29.50           O  
ATOM     10  CB  GLN A   6      29.412  28.047  16.342  1.00 29.01           C  
ATOM     11  CG  GLN A   6      28.320  28.596  17.242  1.00 32.46           C  
ATOM     12  CD  GLN A   6      27.188  27.593  17.429  1.00 33.34           C  
ATOM     13  OE1 GLN A   6      27.329  26.607  18.158  1.00 33.29           O  
ATOM     14  NE2 GLN A   6      26.067  27.830  16.753  1.00 33.72           N  
ATOM     15  N   VAL A   7      32.220  26.952  16.082  1.00 26.58           N  
ATOM     16  CA  VAL A   7      33.150  26.025  15.454  1.00 25.28           C  
ATOM     17  C   VAL A   7      32.810  24.691  16.105  1.00 23.27           C  
ATOM     18  O   VAL A   7      33.025  24.508  17.302  1.00 23.42           O  
ATOM     19  CB  VAL A   7      34.617  26.384  15.763  1.00 26.46           C  
ATOM     20  CG1 VAL A   7      35.547  25.405  15.066  1.00 26.71           C  
ATOM     21  CG2 VAL A   7      34.910  27.806  15.315  1.00 26.88           C  
ATOM     22  N   ARG A   8      32.261  23.766  15.324  1.00 20.93           N  
ATOM     23  CA  ARG A   8      31.869  22.472  15.865  1.00 18.67           C  
ATOM     24  C   ARG A   8      32.540  21.296  15.170  1.00 17.36           C  
ATOM     25  O   ARG A   8      32.111  20.864  14.100  1.00 15.97           O  
ATOM     26  CB  ARG A   8      30.346  22.314  15.783  1.00 19.49           C  
ATOM     27  CG  ARG A   8      29.567  23.406  16.511  1.00 22.19           C  
ATOM     28  CD  ARG A   8      28.065  23.248  16.303  1.00 23.75           C  
ATOM     29  NE  ARG A   8      27.503  22.125  17.047  1.00 25.72           N  
ATOM     30  CZ  ARG A   8      26.995  22.216  18.273  1.00 24.59           C  
ATOM     31  NH1 ARG A   8      26.975  23.383  18.902  1.00 24.82           N  
ATOM     32  NH2 ARG A   8      26.501  21.140  18.868  1.00 25.41           N  
ATOM     33  N   PRO A   9      33.608  20.758  15.777  1.00 17.64           N  
ATOM     34  CA  PRO A   9      34.338  19.621  15.214  1.00 17.48           C  
ATOM     35  C   PRO A   9      33.553  18.334  15.431  1.00 16.51           C  
ATOM     36  O   PRO A   9      32.698  18.269  16.319  1.00 17.67           O  
ATOM     37  CB  PRO A   9      35.641  19.635  16.002  1.00 17.58           C  
ATOM     38  CG  PRO A   9      35.173  20.067  17.361  1.00 18.75           C  
ATOM     39  CD  PRO A   9      34.246  21.221  17.024  1.00 18.75           C  
ATOM     40  N   PRO A  10      33.834  17.290  14.634  1.00 15.80           N  
ATOM     41  CA  PRO A  10      34.827  17.236  13.551  1.00 15.63           C  
ATOM     42  C   PRO A  10      34.549  18.215  12.414  1.00 15.63           C  
ATOM     43  O   PRO A  10      33.396  18.520  12.111  1.00 15.18           O  
ATOM     44  CB  PRO A  10      34.740  15.790  13.075  1.00 15.58           C  
ATOM     45  CG  PRO A  10      34.330  15.053  14.305  1.00 15.74           C  
ATOM     46  CD  PRO A  10      33.281  15.951  14.896  1.00 15.15           C  
ATOM     47  N   LEU A  11      35.619  18.685  11.778  1.00 15.75           N  
ATOM     48  CA  LEU A  11      35.524  19.629  10.672  1.00 14.39           C  
ATOM     49  C   LEU A  11      35.828  18.931   9.346  1.00 14.71           C  
ATOM     50  O   LEU A  11      36.632  18.002   9.292  1.00 15.10           O  
ATOM     51  CB  LEU A  11      36.518  20.775  10.887  1.00 15.19           C  
ATOM     52  CG  LEU A  11      36.440  21.501  12.234  1.00 16.70           C  
ATOM     53  CD1 LEU A  11      37.585  22.497  12.348  1.00 18.57           C  
ATOM     54  CD2 LEU A  11      35.096  22.209  12.362  1.00 18.56           C  
ATOM     55  N   PRO A  12      35.178  19.365   8.253  1.00 14.87           N  
ATOM     56  CA  PRO A  12      35.419  18.750   6.945  1.00 15.10           C  
ATOM     57  C   PRO A  12      36.738  19.244   6.351  1.00 14.46           C  
ATOM     58  O   PRO A  12      37.252  20.287   6.758  1.00 14.70           O  
ATOM     59  CB  PRO A  12      34.216  19.210   6.131  1.00 14.63           C  
ATOM     60  CG  PRO A  12      33.998  20.588   6.653  1.00 14.05           C  
ATOM     61  CD  PRO A  12      34.127  20.392   8.159  1.00 15.10           C  
ATOM     62  N   PRO A  13      37.314  18.490   5.398  1.00 14.44           N  
ATOM     63  CA  PRO A  13      36.810  17.222   4.858  1.00 15.12           C  
ATOM     64  C   PRO A  13      36.960  16.094   5.878  1.00 15.37           C  
ATOM     65  O   PRO A  13      37.913  16.074   6.662  1.00 16.84           O  
ATOM     66  CB  PRO A  13      37.670  17.012   3.614  1.00 14.93           C  
ATOM     67  CG  PRO A  13      38.970  17.647   4.006  1.00 17.05           C  
ATOM     68  CD  PRO A  13      38.522  18.922   4.672  1.00 15.43           C  
ATOM     69  N   PHE A  14      36.020  15.156   5.860  1.00 15.00           N  
ATOM     70  CA  PHE A  14      36.015  14.045   6.805  1.00 15.18           C  
ATOM     71  C   PHE A  14      36.791  12.809   6.374  1.00 16.64           C  
ATOM     72  O   PHE A  14      37.073  12.598   5.193  1.00 16.98           O  
ATOM     73  CB  PHE A  14      34.573  13.615   7.093  1.00 15.16           C  
ATOM     74  CG  PHE A  14      33.686  14.731   7.559  1.00 13.75           C  
ATOM     75  CD1 PHE A  14      33.815  15.252   8.842  1.00 13.83           C  
ATOM     76  CD2 PHE A  14      32.731  15.272   6.708  1.00 13.14           C  
ATOM     77  CE1 PHE A  14      33.006  16.300   9.271  1.00 13.81           C  
ATOM     78  CE2 PHE A  14      31.916  16.321   7.125  1.00 12.90           C  
ATOM     79  CZ  PHE A  14      32.052  16.836   8.406  1.00 13.27           C  
ATOM     80  N   THR A  15      37.132  12.002   7.370  1.00 17.05           N  
ATOM     81  CA  THR A  15      37.810  10.732   7.168  1.00 17.11           C  
ATOM     82  C   THR A  15      36.731   9.763   7.630  1.00 17.67           C  
ATOM     83  O   THR A  15      35.701  10.199   8.156  1.00 16.27           O  
ATOM     84  CB  THR A  15      39.057  10.585   8.075  1.00 17.98           C  
ATOM     85  OG1 THR A  15      38.670  10.698   9.451  1.00 18.43           O  
ATOM     86  CG2 THR A  15      40.083  11.664   7.753  1.00 18.32           C  
ATOM     87  N   ARG A  16      36.932   8.465   7.441  1.00 16.58           N  
ATOM     88  CA  ARG A  16      35.918   7.522   7.886  1.00 18.30           C  
ATOM     89  C   ARG A  16      35.713   7.704   9.387  1.00 17.64           C  
ATOM     90  O   ARG A  16      34.582   7.788   9.872  1.00 15.98           O  
ATOM     91  CB  ARG A  16      36.343   6.081   7.600  1.00 20.19           C  
ATOM     92  CG  ARG A  16      35.287   5.063   7.998  1.00 23.33           C  
ATOM     93  CD  ARG A  16      35.750   3.639   7.788  1.00 26.75           C  
ATOM     94  NE  ARG A  16      34.707   2.690   8.167  1.00 31.35           N  
ATOM     95  CZ  ARG A  16      33.534   2.580   7.548  1.00 33.02           C  
ATOM     96  NH1 ARG A  16      32.644   1.690   7.967  1.00 35.55           N  
ATOM     97  NH2 ARG A  16      33.253   3.352   6.505  1.00 34.33           N  
ATOM     98  N   GLU A  17      36.821   7.785  10.115  1.00 17.61           N  
ATOM     99  CA  GLU A  17      36.794   7.945  11.561  1.00 19.11           C  
ATOM    100  C   GLU A  17      36.064   9.204  12.027  1.00 16.05           C  
ATOM    101  O   GLU A  17      35.189   9.127  12.891  1.00 15.80           O  
ATOM    102  CB  GLU A  17      38.225   7.952  12.108  1.00 21.78           C  
ATOM    103  CG  GLU A  17      38.320   8.070  13.623  1.00 28.88           C  
ATOM    104  CD  GLU A  17      39.757   8.087  14.117  1.00 32.07           C  
ATOM    105  OE1 GLU A  17      40.489   7.106  13.859  1.00 33.73           O  
ATOM    106  OE2 GLU A  17      40.156   9.081  14.764  1.00 34.27           O  
ATOM    107  N   SER A  18      36.418  10.357  11.465  1.00 16.19           N  
ATOM    108  CA  SER A  18      35.783  11.602  11.879  1.00 14.54           C  
ATOM    109  C   SER A  18      34.326  11.670  11.421  1.00 13.64           C  
ATOM    110  O   SER A  18      33.506  12.323  12.067  1.00 13.10           O  
ATOM    111  CB  SER A  18      36.570  12.823  11.376  1.00 15.73           C  
ATOM    112  OG  SER A  18      36.503  12.983   9.970  1.00 15.30           O  
ATOM    113  N   ALA A  19      33.999  11.002  10.318  1.00 13.09           N  
ATOM    114  CA  ALA A  19      32.617  10.991   9.842  1.00 12.56           C  
ATOM    115  C   ALA A  19      31.776  10.232  10.869  1.00 13.47           C  
ATOM    116  O   ALA A  19      30.687  10.668  11.239  1.00 12.42           O  
ATOM    117  CB  ALA A  19      32.522  10.306   8.480  1.00 12.75           C  
ATOM    118  N   ILE A  20      32.283   9.092  11.330  1.00 13.75           N  
ATOM    119  CA  ILE A  20      31.567   8.303  12.324  1.00 14.40           C  
ATOM    120  C   ILE A  20      31.404   9.105  13.615  1.00 13.46           C  
ATOM    121  O   ILE A  20      30.358   9.050  14.264  1.00 14.33           O  
ATOM    122  CB  ILE A  20      32.299   6.969  12.612  1.00 14.43           C  
ATOM    123  CG1 ILE A  20      32.201   6.059  11.384  1.00 16.01           C  
ATOM    124  CG2 ILE A  20      31.692   6.285  13.833  1.00 13.36           C  
ATOM    125  CD1 ILE A  20      33.015   4.780  11.484  1.00 17.52           C  
ATOM    126  N   GLU A  21      32.431   9.864  13.985  1.00 13.73           N  
ATOM    127  CA  GLU A  21      32.351  10.674  15.192  1.00 13.59           C  
ATOM    128  C   GLU A  21      31.296  11.766  15.015  1.00 13.08           C  
ATOM    129  O   GLU A  21      30.475  11.991  15.904  1.00 12.22           O  
ATOM    130  CB  GLU A  21      33.707  11.310  15.511  1.00 16.17           C  
ATOM    131  CG  GLU A  21      33.684  12.222  16.728  1.00 19.86           C  
ATOM    132  CD  GLU A  21      35.049  12.782  17.074  1.00 24.28           C  
ATOM    133  OE1 GLU A  21      35.145  13.524  18.074  1.00 26.29           O  
ATOM    134  OE2 GLU A  21      36.025  12.482  16.351  1.00 26.33           O  
ATOM    135  N   LYS A  22      31.322  12.431  13.862  1.00 11.89           N  
ATOM    136  CA  LYS A  22      30.371  13.497  13.558  1.00 11.36           C  
ATOM    137  C   LYS A  22      28.943  12.970  13.701  1.00 11.05           C  
ATOM    138  O   LYS A  22      28.082  13.623  14.282  1.00 11.60           O  
ATOM    139  CB  LYS A  22      30.593  14.005  12.126  1.00 11.01           C  
ATOM    140  CG  LYS A  22      29.910  15.332  11.807  1.00 10.25           C  
ATOM    141  CD  LYS A  22      30.552  16.478  12.576  1.00 12.55           C  
ATOM    142  CE  LYS A  22      29.994  17.817  12.136  1.00 11.20           C  
ATOM    143  NZ  LYS A  22      30.644  18.952  12.856  1.00 11.13           N  
ATOM    144  N   ILE A  23      28.710  11.775  13.172  1.00  9.55           N  
ATOM    145  CA  ILE A  23      27.400  11.142  13.226  1.00 10.01           C  
ATOM    146  C   ILE A  23      26.978  10.802  14.660  1.00 10.12           C  
ATOM    147  O   ILE A  23      25.821  11.002  15.035  1.00 11.41           O  
ATOM    148  CB  ILE A  23      27.387   9.852  12.371  1.00  8.77           C  
ATOM    149  CG1 ILE A  23      27.583  10.201  10.889  1.00  9.61           C  
ATOM    150  CG2 ILE A  23      26.083   9.093  12.576  1.00  9.92           C  
ATOM    151  CD1 ILE A  23      27.860   8.997  10.018  1.00 10.20           C  
ATOM    152  N   ARG A  24      27.913  10.287  15.456  1.00 11.22           N  
ATOM    153  CA  ARG A  24      27.622   9.918  16.841  1.00 12.31           C  
ATOM    154  C   ARG A  24      27.258  11.149  17.666  1.00 10.78           C  
ATOM    155  O   ARG A  24      26.339  11.114  18.487  1.00 11.51           O  
ATOM    156  CB  ARG A  24      28.833   9.217  17.463  1.00 11.75           C  
ATOM    157  CG  ARG A  24      28.530   7.853  18.071  1.00 17.12           C  
ATOM    158  CD  ARG A  24      27.548   7.931  19.233  1.00 14.86           C  
ATOM    159  NE  ARG A  24      27.364   6.628  19.875  1.00 15.04           N  
ATOM    160  CZ  ARG A  24      26.641   6.422  20.974  1.00 15.53           C  
ATOM    161  NH1 ARG A  24      26.536   5.200  21.480  1.00 16.88           N  
ATOM    162  NH2 ARG A  24      26.026   7.433  21.571  1.00 14.46           N  
ATOM    163  N   LEU A  25      27.982  12.239  17.451  1.00 11.96           N  
ATOM    164  CA  LEU A  25      27.703  13.470  18.173  1.00 11.82           C  
ATOM    165  C   LEU A  25      26.319  13.997  17.799  1.00 11.23           C  
ATOM    166  O   LEU A  25      25.590  14.498  18.658  1.00 12.93           O  
ATOM    167  CB  LEU A  25      28.773  14.519  17.864  1.00 11.75           C  
ATOM    168  CG  LEU A  25      30.150  14.222  18.474  1.00 14.79           C  
ATOM    169  CD1 LEU A  25      31.148  15.277  18.022  1.00 16.20           C  
ATOM    170  CD2 LEU A  25      30.044  14.202  19.993  1.00 14.73           C  
ATOM    171  N   ALA A  26      25.966  13.880  16.520  1.00 10.57           N  
ATOM    172  CA  ALA A  26      24.663  14.333  16.038  1.00 10.15           C  
ATOM    173  C   ALA A  26      23.571  13.480  16.678  1.00 10.32           C  
ATOM    174  O   ALA A  26      22.553  13.995  17.152  1.00 10.97           O  
ATOM    175  CB  ALA A  26      24.596  14.220  14.517  1.00 10.54           C  
ATOM    176  N   GLU A  27      23.782  12.169  16.687  1.00  9.51           N  
ATOM    177  CA  GLU A  27      22.826  11.253  17.290  1.00  9.51           C  
ATOM    178  C   GLU A  27      22.603  11.634  18.753  1.00 10.12           C  
ATOM    179  O   GLU A  27      21.465  11.698  19.223  1.00 10.05           O  
ATOM    180  CB  GLU A  27      23.343   9.817  17.202  1.00 10.46           C  
ATOM    181  CG  GLU A  27      22.385   8.779  17.771  1.00 10.85           C  
ATOM    182  CD  GLU A  27      23.043   7.427  17.983  1.00 12.05           C  
ATOM    183  OE1 GLU A  27      23.483   6.806  16.993  1.00 11.56           O  
ATOM    184  OE2 GLU A  27      23.119   6.991  19.149  1.00 12.34           O  
ATOM    185  N   ASP A  28      23.692  11.885  19.477  1.00 10.67           N  
ATOM    186  CA  ASP A  28      23.579  12.269  20.881  1.00 11.25           C  
ATOM    187  C   ASP A  28      22.739  13.538  21.000  1.00 10.97           C  
ATOM    188  O   ASP A  28      21.902  13.660  21.895  1.00 12.34           O  
ATOM    189  CB  ASP A  28      24.963  12.514  21.495  1.00 12.37           C  
ATOM    190  CG  ASP A  28      25.811  11.253  21.571  1.00 14.15           C  
ATOM    191  OD1 ASP A  28      25.295  10.144  21.316  1.00 14.05           O  
ATOM    192  OD2 ASP A  28      27.009  11.378  21.903  1.00 15.84           O  
ATOM    193  N   GLY A  29      22.960  14.476  20.082  1.00 11.38           N  
ATOM    194  CA  GLY A  29      22.215  15.721  20.096  1.00 10.40           C  
ATOM    195  C   GLY A  29      20.725  15.499  19.926  1.00 10.47           C  
ATOM    196  O   GLY A  29      19.921  15.986  20.721  1.00 10.67           O  
ATOM    197  N   TRP A  30      20.342  14.756  18.893  1.00  9.88           N  
ATOM    198  CA  TRP A  30      18.923  14.513  18.679  1.00  9.21           C  
ATOM    199  C   TRP A  30      18.316  13.678  19.804  1.00  9.83           C  
ATOM    200  O   TRP A  30      17.145  13.843  20.140  1.00 10.93           O  
ATOM    201  CB  TRP A  30      18.684  13.855  17.316  1.00 10.10           C  
ATOM    202  CG  TRP A  30      18.916  14.801  16.157  1.00 10.77           C  
ATOM    203  CD1 TRP A  30      20.102  15.366  15.787  1.00  9.62           C  
ATOM    204  CD2 TRP A  30      17.933  15.290  15.232  1.00  8.94           C  
ATOM    205  NE1 TRP A  30      19.923  16.175  14.690  1.00 12.75           N  
ATOM    206  CE2 TRP A  30      18.602  16.146  14.328  1.00  9.04           C  
ATOM    207  CE3 TRP A  30      16.555  15.089  15.082  1.00 10.79           C  
ATOM    208  CZ2 TRP A  30      17.939  16.801  13.281  1.00  9.17           C  
ATOM    209  CZ3 TRP A  30      15.894  15.740  14.042  1.00  8.62           C  
ATOM    210  CH2 TRP A  30      16.591  16.586  13.155  1.00  9.43           C  
ATOM    211  N   ASN A  31      19.105  12.795  20.409  1.00  9.29           N  
ATOM    212  CA  ASN A  31      18.571  11.990  21.500  1.00 10.91           C  
ATOM    213  C   ASN A  31      18.321  12.814  22.761  1.00 10.97           C  
ATOM    214  O   ASN A  31      17.770  12.304  23.736  1.00 11.47           O  
ATOM    215  CB  ASN A  31      19.483  10.802  21.814  1.00 11.69           C  
ATOM    216  CG  ASN A  31      19.107   9.557  21.023  1.00 11.32           C  
ATOM    217  OD1 ASN A  31      17.932   9.191  20.944  1.00 12.44           O  
ATOM    218  ND2 ASN A  31      20.102   8.896  20.445  1.00 12.86           N  
ATOM    219  N   SER A  32      18.729  14.083  22.751  1.00 11.18           N  
ATOM    220  CA  SER A  32      18.481  14.951  23.901  1.00 12.53           C  
ATOM    221  C   SER A  32      17.071  15.532  23.760  1.00 12.57           C  
ATOM    222  O   SER A  32      16.495  16.030  24.726  1.00 12.26           O  
ATOM    223  CB  SER A  32      19.495  16.102  23.964  1.00 12.59           C  
ATOM    224  OG  SER A  32      19.243  17.081  22.970  1.00 13.36           O  
ATOM    225  N   ARG A  33      16.534  15.473  22.543  1.00 12.25           N  
ATOM    226  CA  ARG A  33      15.192  15.988  22.258  1.00 11.92           C  
ATOM    227  C   ARG A  33      15.064  17.449  22.687  1.00 11.31           C  
ATOM    228  O   ARG A  33      13.996  17.903  23.091  1.00 11.93           O  
ATOM    229  CB  ARG A  33      14.146  15.124  22.974  1.00 12.26           C  
ATOM    230  CG  ARG A  33      14.059  13.702  22.428  1.00 14.08           C  
ATOM    231  CD  ARG A  33      13.834  12.663  23.518  1.00 18.54           C  
ATOM    232  NE  ARG A  33      15.012  12.510  24.365  1.00 21.81           N  
ATOM    233  CZ  ARG A  33      15.063  12.839  25.652  1.00 21.14           C  
ATOM    234  NH1 ARG A  33      13.996  13.338  26.263  1.00 22.72           N  
ATOM    235  NH2 ARG A  33      16.190  12.681  26.328  1.00 22.88           N  
ATOM    236  N   ASP A  34      16.170  18.178  22.566  1.00 10.77           N  
ATOM    237  CA  ASP A  34      16.257  19.586  22.945  1.00 12.04           C  
ATOM    238  C   ASP A  34      16.420  20.442  21.684  1.00 11.60           C  
ATOM    239  O   ASP A  34      17.511  20.556  21.139  1.00 12.38           O  
ATOM    240  CB  ASP A  34      17.457  19.745  23.893  1.00 13.76           C  
ATOM    241  CG  ASP A  34      17.714  21.182  24.318  1.00 18.25           C  
ATOM    242  OD1 ASP A  34      18.520  21.364  25.258  1.00 22.05           O  
ATOM    243  OD2 ASP A  34      17.142  22.118  23.731  1.00 19.15           O  
ATOM    244  N   PRO A  35      15.321  21.056  21.207  1.00 11.05           N  
ATOM    245  CA  PRO A  35      15.344  21.898  20.007  1.00 10.66           C  
ATOM    246  C   PRO A  35      16.470  22.933  19.954  1.00 11.06           C  
ATOM    247  O   PRO A  35      17.155  23.063  18.939  1.00 10.73           O  
ATOM    248  CB  PRO A  35      13.957  22.542  20.015  1.00 11.32           C  
ATOM    249  CG  PRO A  35      13.107  21.467  20.603  1.00  9.70           C  
ATOM    250  CD  PRO A  35      13.959  20.983  21.764  1.00 11.47           C  
ATOM    251  N   GLU A  36      16.664  23.669  21.045  1.00 11.92           N  
ATOM    252  CA  GLU A  36      17.708  24.689  21.096  1.00 13.59           C  
ATOM    253  C   GLU A  36      19.092  24.070  20.913  1.00 12.84           C  
ATOM    254  O   GLU A  36      19.854  24.489  20.041  1.00 13.38           O  
ATOM    255  CB  GLU A  36      17.633  25.447  22.426  1.00 13.75           C  
ATOM    256  CG  GLU A  36      18.777  26.427  22.696  1.00 14.48           C  
ATOM    257  CD  GLU A  36      18.914  27.513  21.641  1.00 16.06           C  
ATOM    258  OE1 GLU A  36      17.963  27.726  20.858  1.00 14.19           O  
ATOM    259  OE2 GLU A  36      19.979  28.168  21.604  1.00 19.45           O  
ATOM    260  N   ARG A  37      19.413  23.063  21.719  1.00 13.12           N  
ATOM    261  CA  ARG A  37      20.715  22.411  21.614  1.00 13.29           C  
ATOM    262  C   ARG A  37      20.976  21.886  20.206  1.00 12.00           C  
ATOM    263  O   ARG A  37      22.031  22.135  19.630  1.00 13.81           O  
ATOM    264  CB  ARG A  37      20.817  21.255  22.611  1.00 14.78           C  
ATOM    265  CG  ARG A  37      22.045  20.367  22.406  1.00 15.57           C  
ATOM    266  CD  ARG A  37      22.115  19.267  23.448  1.00 17.23           C  
ATOM    267  NE  ARG A  37      23.155  18.290  23.137  1.00 17.06           N  
ATOM    268  CZ  ARG A  37      23.410  17.209  23.867  1.00 18.25           C  
ATOM    269  NH1 ARG A  37      22.703  16.961  24.962  1.00 18.53           N  
ATOM    270  NH2 ARG A  37      24.366  16.368  23.495  1.00 19.25           N  
ATOM    271  N   VAL A  38      20.012  21.157  19.656  1.00 11.26           N  
ATOM    272  CA  VAL A  38      20.164  20.590  18.324  1.00 11.85           C  
ATOM    273  C   VAL A  38      20.319  21.658  17.247  1.00 11.97           C  
ATOM    274  O   VAL A  38      21.156  21.525  16.355  1.00 10.92           O  
ATOM    275  CB  VAL A  38      18.964  19.673  17.970  1.00 10.98           C  
ATOM    276  CG1 VAL A  38      19.056  19.206  16.522  1.00 12.61           C  
ATOM    277  CG2 VAL A  38      18.948  18.470  18.900  1.00 13.38           C  
ATOM    278  N   SER A  39      19.530  22.726  17.339  1.00 12.65           N  
ATOM    279  CA  SER A  39      19.576  23.795  16.343  1.00 12.22           C  
ATOM    280  C   SER A  39      20.945  24.454  16.183  1.00 12.93           C  
ATOM    281  O   SER A  39      21.274  24.961  15.109  1.00 11.78           O  
ATOM    282  CB  SER A  39      18.533  24.873  16.671  1.00 12.01           C  
ATOM    283  OG  SER A  39      18.928  25.649  17.790  1.00 12.89           O  
ATOM    284  N   LEU A  40      21.743  24.444  17.246  1.00 13.62           N  
ATOM    285  CA  LEU A  40      23.065  25.065  17.208  1.00 13.64           C  
ATOM    286  C   LEU A  40      24.063  24.346  16.301  1.00 13.41           C  
ATOM    287  O   LEU A  40      25.121  24.886  15.978  1.00 13.83           O  
ATOM    288  CB  LEU A  40      23.634  25.164  18.626  1.00 16.43           C  
ATOM    289  CG  LEU A  40      22.796  26.000  19.598  1.00 16.77           C  
ATOM    290  CD1 LEU A  40      23.440  25.974  20.976  1.00 19.50           C  
ATOM    291  CD2 LEU A  40      22.679  27.431  19.086  1.00 19.44           C  
ATOM    292  N   ALA A  41      23.727  23.129  15.884  1.00 11.76           N  
ATOM    293  CA  ALA A  41      24.608  22.368  15.009  1.00 11.94           C  
ATOM    294  C   ALA A  41      24.431  22.768  13.544  1.00 11.68           C  
ATOM    295  O   ALA A  41      25.170  22.313  12.673  1.00 12.08           O  
ATOM    296  CB  ALA A  41      24.336  20.874  15.173  1.00 11.77           C  
ATOM    297  N   TYR A  42      23.458  23.633  13.279  1.00 11.77           N  
ATOM    298  CA  TYR A  42      23.165  24.056  11.913  1.00 11.52           C  
ATOM    299  C   TYR A  42      23.500  25.525  11.686  1.00 11.81           C  
ATOM    300  O   TYR A  42      23.477  26.322  12.618  1.00 11.46           O  
ATOM    301  CB  TYR A  42      21.682  23.783  11.623  1.00 10.88           C  
ATOM    302  CG  TYR A  42      21.340  22.325  11.828  1.00 10.26           C  
ATOM    303  CD1 TYR A  42      21.450  21.409  10.782  1.00 10.22           C  
ATOM    304  CD2 TYR A  42      21.045  21.835  13.101  1.00 11.95           C  
ATOM    305  CE1 TYR A  42      21.291  20.039  11.002  1.00 11.64           C  
ATOM    306  CE2 TYR A  42      20.884  20.471  13.331  1.00 11.69           C  
ATOM    307  CZ  TYR A  42      21.014  19.578  12.281  1.00 13.04           C  
ATOM    308  OH  TYR A  42      20.911  18.224  12.526  1.00 14.91           O  
ATOM    309  N   THR A  43      23.822  25.877  10.444  1.00 10.73           N  
ATOM    310  CA  THR A  43      24.154  27.263  10.116  1.00 12.61           C  
ATOM    311  C   THR A  43      22.947  28.160  10.361  1.00 12.68           C  
ATOM    312  O   THR A  43      21.811  27.687  10.386  1.00 13.79           O  
ATOM    313  CB  THR A  43      24.593  27.409   8.641  1.00 13.24           C  
ATOM    314  OG1 THR A  43      23.561  26.911   7.776  1.00 11.02           O  
ATOM    315  CG2 THR A  43      25.886  26.633   8.392  1.00 12.95           C  
ATOM    316  N   LEU A  44      23.198  29.451  10.556  1.00 13.91           N  
ATOM    317  CA  LEU A  44      22.122  30.405  10.799  1.00 13.83           C  
ATOM    318  C   LEU A  44      21.131  30.429   9.640  1.00 13.38           C  
ATOM    319  O   LEU A  44      19.935  30.663   9.839  1.00 12.31           O  
ATOM    320  CB  LEU A  44      22.696  31.805  11.018  1.00 17.13           C  
ATOM    321  CG  LEU A  44      23.445  31.998  12.338  1.00 18.82           C  
ATOM    322  CD1 LEU A  44      24.120  33.364  12.354  1.00 20.77           C  
ATOM    323  CD2 LEU A  44      22.469  31.861  13.498  1.00 21.28           C  
ATOM    324  N   ASP A  45      21.635  30.188   8.433  1.00 13.39           N  
ATOM    325  CA  ASP A  45      20.795  30.170   7.242  1.00 14.15           C  
ATOM    326  C   ASP A  45      20.704  28.756   6.672  1.00 13.89           C  
ATOM    327  O   ASP A  45      20.665  28.563   5.453  1.00 14.92           O  
ATOM    328  CB  ASP A  45      21.345  31.134   6.180  1.00 17.00           C  
ATOM    329  CG  ASP A  45      22.789  30.831   5.781  1.00 19.62           C  
ATOM    330  OD1 ASP A  45      23.253  31.414   4.777  1.00 22.20           O  
ATOM    331  OD2 ASP A  45      23.468  30.028   6.459  1.00 19.39           O  
ATOM    332  N   THR A  46      20.657  27.771   7.565  1.00 12.28           N  
ATOM    333  CA  THR A  46      20.587  26.373   7.162  1.00 11.84           C  
ATOM    334  C   THR A  46      19.374  26.104   6.270  1.00 12.26           C  
ATOM    335  O   THR A  46      18.314  26.704   6.443  1.00 12.19           O  
ATOM    336  CB  THR A  46      20.546  25.447   8.405  1.00 11.85           C  
ATOM    337  OG1 THR A  46      20.816  24.095   8.013  1.00 10.08           O  
ATOM    338  CG2 THR A  46      19.189  25.516   9.087  1.00 12.16           C  
ATOM    339  N   GLN A  47      19.557  25.208   5.305  1.00 11.97           N  
ATOM    340  CA  GLN A  47      18.502  24.836   4.368  1.00 11.42           C  
ATOM    341  C   GLN A  47      18.149  23.372   4.581  1.00 10.95           C  
ATOM    342  O   GLN A  47      19.005  22.495   4.461  1.00 10.25           O  
ATOM    343  CB  GLN A  47      18.972  25.043   2.930  1.00 13.39           C  
ATOM    344  CG  GLN A  47      19.298  26.485   2.587  1.00 17.88           C  
ATOM    345  CD  GLN A  47      18.106  27.396   2.765  1.00 20.58           C  
ATOM    346  OE1 GLN A  47      17.037  27.155   2.200  1.00 23.68           O  
ATOM    347  NE2 GLN A  47      18.278  28.451   3.554  1.00 22.09           N  
ATOM    348  N   TRP A  48      16.881  23.118   4.889  1.00  9.56           N  
ATOM    349  CA  TRP A  48      16.403  21.766   5.154  1.00  8.86           C  
ATOM    350  C   TRP A  48      15.183  21.344   4.371  1.00  9.51           C  
ATOM    351  O   TRP A  48      14.330  22.159   4.027  1.00 10.44           O  
ATOM    352  CB  TRP A  48      15.920  21.620   6.601  1.00 10.07           C  
ATOM    353  CG  TRP A  48      16.893  21.610   7.717  1.00  9.26           C  
ATOM    354  CD1 TRP A  48      18.118  22.205   7.769  1.00 10.03           C  
ATOM    355  CD2 TRP A  48      16.661  21.047   9.013  1.00  9.16           C  
ATOM    356  NE1 TRP A  48      18.663  22.050   9.025  1.00  7.76           N  
ATOM    357  CE2 TRP A  48      17.789  21.345   9.808  1.00  7.60           C  
ATOM    358  CE3 TRP A  48      15.602  20.321   9.581  1.00 10.79           C  
ATOM    359  CZ2 TRP A  48      17.890  20.941  11.147  1.00 10.47           C  
ATOM    360  CZ3 TRP A  48      15.702  19.919  10.911  1.00  9.49           C  
ATOM    361  CH2 TRP A  48      16.841  20.233  11.679  1.00 10.01           C  
ATOM    362  N   ARG A  49      15.112  20.045   4.112  1.00  9.18           N  
ATOM    363  CA  ARG A  49      13.896  19.448   3.591  1.00  8.75           C  
ATOM    364  C   ARG A  49      13.839  18.203   4.468  1.00  7.37           C  
ATOM    365  O   ARG A  49      14.743  17.362   4.433  1.00  9.64           O  
ATOM    366  CB  ARG A  49      13.910  19.019   2.124  1.00  8.72           C  
ATOM    367  CG  ARG A  49      12.509  18.452   1.758  1.00  9.21           C  
ATOM    368  CD  ARG A  49      12.449  17.722   0.427  1.00  9.13           C  
ATOM    369  NE  ARG A  49      13.570  16.803   0.297  1.00 10.25           N  
ATOM    370  CZ  ARG A  49      13.762  15.714   1.034  1.00 10.40           C  
ATOM    371  NH1 ARG A  49      12.895  15.353   1.976  1.00  8.74           N  
ATOM    372  NH2 ARG A  49      14.875  15.012   0.860  1.00 11.27           N  
ATOM    373  N   ASN A  50      12.814  18.133   5.304  1.00  7.60           N  
ATOM    374  CA  ASN A  50      12.595  16.995   6.188  1.00  7.80           C  
ATOM    375  C   ASN A  50      11.246  16.446   5.745  1.00  8.15           C  
ATOM    376  O   ASN A  50      10.216  17.092   5.945  1.00  8.03           O  
ATOM    377  CB  ASN A  50      12.545  17.463   7.643  1.00  9.37           C  
ATOM    378  CG  ASN A  50      12.188  16.344   8.602  1.00  8.87           C  
ATOM    379  OD1 ASN A  50      11.029  15.926   8.693  1.00 11.71           O  
ATOM    380  ND2 ASN A  50      13.183  15.849   9.316  1.00  7.01           N  
ATOM    381  N   ARG A  51      11.257  15.259   5.145  1.00  8.08           N  
ATOM    382  CA  ARG A  51      10.035  14.657   4.609  1.00  7.97           C  
ATOM    383  C   ARG A  51       9.501  15.641   3.565  1.00  7.44           C  
ATOM    384  O   ARG A  51      10.221  16.001   2.637  1.00  8.76           O  
ATOM    385  CB  ARG A  51       9.004  14.413   5.722  1.00  7.47           C  
ATOM    386  CG  ARG A  51       9.440  13.378   6.763  1.00  8.83           C  
ATOM    387  CD  ARG A  51       8.411  13.258   7.880  1.00  7.02           C  
ATOM    388  NE  ARG A  51       8.833  12.372   8.969  1.00  8.55           N  
ATOM    389  CZ  ARG A  51       8.410  11.123   9.137  1.00  8.96           C  
ATOM    390  NH1 ARG A  51       7.546  10.581   8.289  1.00 11.18           N  
ATOM    391  NH2 ARG A  51       8.841  10.417  10.175  1.00 10.23           N  
ATOM    392  N   ALA A  52       8.260  16.093   3.708  1.00  9.59           N  
ATOM    393  CA  ALA A  52       7.706  17.035   2.740  1.00 10.35           C  
ATOM    394  C   ALA A  52       7.699  18.468   3.270  1.00 11.75           C  
ATOM    395  O   ALA A  52       7.000  19.332   2.736  1.00 12.65           O  
ATOM    396  CB  ALA A  52       6.287  16.615   2.357  1.00 10.73           C  
ATOM    397  N   GLU A  53       8.487  18.715   4.314  1.00 10.21           N  
ATOM    398  CA  GLU A  53       8.565  20.029   4.943  1.00 10.03           C  
ATOM    399  C   GLU A  53       9.919  20.700   4.711  1.00 10.83           C  
ATOM    400  O   GLU A  53      10.957  20.039   4.705  1.00 11.56           O  
ATOM    401  CB  GLU A  53       8.315  19.874   6.447  1.00 11.74           C  
ATOM    402  CG  GLU A  53       8.101  21.170   7.196  1.00 12.95           C  
ATOM    403  CD  GLU A  53       7.845  20.957   8.683  1.00 13.59           C  
ATOM    404  OE1 GLU A  53       7.447  19.838   9.083  1.00 11.74           O  
ATOM    405  OE2 GLU A  53       8.032  21.921   9.453  1.00 14.75           O  
ATOM    406  N   PHE A  54       9.900  22.018   4.529  1.00 10.41           N  
ATOM    407  CA  PHE A  54      11.121  22.786   4.309  1.00 10.94           C  
ATOM    408  C   PHE A  54      11.367  23.799   5.426  1.00 11.13           C  
ATOM    409  O   PHE A  54      10.428  24.298   6.045  1.00 13.17           O  
ATOM    410  CB  PHE A  54      11.061  23.537   2.971  1.00 10.75           C  
ATOM    411  CG  PHE A  54      10.951  22.641   1.769  1.00 10.88           C  
ATOM    412  CD1 PHE A  54       9.737  22.052   1.430  1.00 12.46           C  
ATOM    413  CD2 PHE A  54      12.066  22.379   0.974  1.00 11.32           C  
ATOM    414  CE1 PHE A  54       9.638  21.211   0.317  1.00 12.73           C  
ATOM    415  CE2 PHE A  54      11.975  21.538  -0.141  1.00 11.89           C  
ATOM    416  CZ  PHE A  54      10.760  20.957  -0.468  1.00 12.97           C  
ATOM    417  N   ALA A  55      12.642  24.079   5.674  1.00 11.76           N  
ATOM    418  CA  ALA A  55      13.073  25.051   6.675  1.00 11.71           C  
ATOM    419  C   ALA A  55      14.173  25.844   5.979  1.00 11.88           C  
ATOM    420  O   ALA A  55      14.983  25.272   5.249  1.00 12.32           O  
ATOM    421  CB  ALA A  55      13.618  24.343   7.910  1.00 13.68           C  
ATOM    422  N   HIS A  56      14.206  27.157   6.190  1.00 12.26           N  
ATOM    423  CA  HIS A  56      15.201  27.980   5.514  1.00 13.13           C  
ATOM    424  C   HIS A  56      16.174  28.747   6.393  1.00 13.12           C  
ATOM    425  O   HIS A  56      16.941  29.578   5.903  1.00 13.98           O  
ATOM    426  CB  HIS A  56      14.500  28.931   4.545  1.00 14.80           C  
ATOM    427  CG  HIS A  56      13.658  28.224   3.531  1.00 16.74           C  
ATOM    428  ND1 HIS A  56      12.308  28.015   3.701  1.00 20.53           N  
ATOM    429  CD2 HIS A  56      13.990  27.618   2.366  1.00 17.96           C  
ATOM    430  CE1 HIS A  56      11.843  27.310   2.685  1.00 19.69           C  
ATOM    431  NE2 HIS A  56      12.843  27.057   1.861  1.00 20.37           N  
ATOM    432  N   ASN A  57      16.128  28.480   7.691  1.00 11.44           N  
ATOM    433  CA  ASN A  57      17.057  29.099   8.629  1.00 12.27           C  
ATOM    434  C   ASN A  57      17.034  28.310   9.926  1.00 11.38           C  
ATOM    435  O   ASN A  57      16.210  27.409  10.095  1.00 10.71           O  
ATOM    436  CB  ASN A  57      16.736  30.590   8.862  1.00 13.35           C  
ATOM    437  CG  ASN A  57      15.327  30.832   9.357  1.00 14.10           C  
ATOM    438  OD1 ASN A  57      14.888  30.237  10.334  1.00 14.77           O  
ATOM    439  ND2 ASN A  57      14.614  31.733   8.687  1.00 18.77           N  
ATOM    440  N   ARG A  58      17.953  28.621  10.834  1.00 10.58           N  
ATOM    441  CA  ARG A  58      18.027  27.902  12.094  1.00 10.97           C  
ATOM    442  C   ARG A  58      16.751  28.012  12.926  1.00 12.28           C  
ATOM    443  O   ARG A  58      16.340  27.046  13.569  1.00 11.03           O  
ATOM    444  CB  ARG A  58      19.222  28.397  12.910  1.00 13.25           C  
ATOM    445  CG  ARG A  58      19.430  27.625  14.199  1.00 12.49           C  
ATOM    446  CD  ARG A  58      20.521  28.250  15.049  1.00 11.92           C  
ATOM    447  NE  ARG A  58      21.843  28.101  14.444  1.00 12.74           N  
ATOM    448  CZ  ARG A  58      22.945  28.675  14.918  1.00 14.62           C  
ATOM    449  NH1 ARG A  58      24.110  28.487  14.314  1.00 15.70           N  
ATOM    450  NH2 ARG A  58      22.879  29.443  15.995  1.00 15.60           N  
ATOM    451  N   GLU A  59      16.126  29.185  12.915  1.00 12.97           N  
ATOM    452  CA  GLU A  59      14.899  29.392  13.680  1.00 13.71           C  
ATOM    453  C   GLU A  59      13.775  28.475  13.197  1.00 12.53           C  
ATOM    454  O   GLU A  59      13.047  27.899  14.008  1.00 12.41           O  
ATOM    455  CB  GLU A  59      14.454  30.854  13.594  1.00 17.09           C  
ATOM    456  CG  GLU A  59      13.153  31.144  14.336  1.00 24.33           C  
ATOM    457  CD  GLU A  59      12.748  32.607  14.276  1.00 28.55           C  
ATOM    458  OE1 GLU A  59      11.655  32.943  14.784  1.00 33.77           O  
ATOM    459  OE2 GLU A  59      13.519  33.423  13.726  1.00 32.67           O  
ATOM    460  N   GLU A  60      13.632  28.342  11.880  1.00 12.42           N  
ATOM    461  CA  GLU A  60      12.590  27.480  11.336  1.00 12.74           C  
ATOM    462  C   GLU A  60      12.919  26.032  11.663  1.00 12.54           C  
ATOM    463  O   GLU A  60      12.024  25.238  11.950  1.00 13.23           O  
ATOM    464  CB  GLU A  60      12.454  27.675   9.823  1.00 12.73           C  
ATOM    465  CG  GLU A  60      12.075  29.096   9.435  1.00 13.52           C  
ATOM    466  CD  GLU A  60      11.651  29.224   7.985  1.00 16.00           C  
ATOM    467  OE1 GLU A  60      12.000  28.346   7.169  1.00 15.54           O  
ATOM    468  OE2 GLU A  60      10.970  30.218   7.655  1.00 18.99           O  
ATOM    469  N   ALA A  61      14.203  25.687  11.635  1.00 11.68           N  
ATOM    470  CA  ALA A  61      14.613  24.329  11.972  1.00 11.30           C  
ATOM    471  C   ALA A  61      14.246  24.063  13.433  1.00  9.86           C  
ATOM    472  O   ALA A  61      13.692  23.014  13.767  1.00 10.69           O  
ATOM    473  CB  ALA A  61      16.124  24.162  11.763  1.00  9.76           C  
ATOM    474  N   LYS A  62      14.545  25.023  14.305  1.00 10.46           N  
ATOM    475  CA  LYS A  62      14.233  24.875  15.722  1.00  9.71           C  
ATOM    476  C   LYS A  62      12.723  24.731  15.947  1.00  9.28           C  
ATOM    477  O   LYS A  62      12.288  23.950  16.794  1.00  9.26           O  
ATOM    478  CB  LYS A  62      14.765  26.075  16.518  1.00 10.51           C  
ATOM    479  CG  LYS A  62      14.558  25.946  18.020  1.00 10.94           C  
ATOM    480  CD  LYS A  62      15.099  27.149  18.775  1.00 12.51           C  
ATOM    481  CE  LYS A  62      14.816  27.023  20.262  1.00 14.66           C  
ATOM    482  NZ  LYS A  62      15.250  28.238  21.010  1.00 15.10           N  
ATOM    483  N   ALA A  63      11.927  25.484  15.190  1.00  9.58           N  
ATOM    484  CA  ALA A  63      10.474  25.409  15.326  1.00  9.52           C  
ATOM    485  C   ALA A  63      10.003  24.010  14.931  1.00  9.33           C  
ATOM    486  O   ALA A  63       9.119  23.432  15.571  1.00  8.50           O  
ATOM    487  CB  ALA A  63       9.809  26.467  14.455  1.00 11.48           C  
ATOM    488  N   PHE A  64      10.608  23.466  13.881  1.00  9.67           N  
ATOM    489  CA  PHE A  64      10.275  22.123  13.418  1.00  9.49           C  
ATOM    490  C   PHE A  64      10.585  21.096  14.508  1.00  9.57           C  
ATOM    491  O   PHE A  64       9.789  20.194  14.768  1.00  9.12           O  
ATOM    492  CB  PHE A  64      11.075  21.772  12.156  1.00  9.52           C  
ATOM    493  CG  PHE A  64      11.177  20.291  11.901  1.00  8.99           C  
ATOM    494  CD1 PHE A  64      10.143  19.601  11.271  1.00 10.09           C  
ATOM    495  CD2 PHE A  64      12.283  19.575  12.351  1.00  9.25           C  
ATOM    496  CE1 PHE A  64      10.210  18.217  11.101  1.00 10.00           C  
ATOM    497  CE2 PHE A  64      12.360  18.192  12.188  1.00 10.45           C  
ATOM    498  CZ  PHE A  64      11.324  17.512  11.562  1.00  9.65           C  
ATOM    499  N   LEU A  65      11.753  21.226  15.135  1.00  9.21           N  
ATOM    500  CA  LEU A  65      12.151  20.295  16.187  1.00  8.32           C  
ATOM    501  C   LEU A  65      11.212  20.382  17.394  1.00  8.99           C  
ATOM    502  O   LEU A  65      10.931  19.376  18.050  1.00  9.45           O  
ATOM    503  CB  LEU A  65      13.593  20.579  16.615  1.00  8.82           C  
ATOM    504  CG  LEU A  65      14.677  20.365  15.550  1.00  8.04           C  
ATOM    505  CD1 LEU A  65      15.981  20.981  16.026  1.00  9.06           C  
ATOM    506  CD2 LEU A  65      14.855  18.875  15.273  1.00  9.30           C  
ATOM    507  N   THR A  66      10.727  21.586  17.684  1.00  8.30           N  
ATOM    508  CA  THR A  66       9.813  21.784  18.796  1.00  9.99           C  
ATOM    509  C   THR A  66       8.510  21.025  18.520  1.00  8.19           C  
ATOM    510  O   THR A  66       7.956  20.377  19.407  1.00 10.21           O  
ATOM    511  CB  THR A  66       9.536  23.283  19.008  1.00 11.38           C  
ATOM    512  OG1 THR A  66      10.769  23.948  19.324  1.00 12.52           O  
ATOM    513  CG2 THR A  66       8.550  23.492  20.149  1.00 10.54           C  
ATOM    514  N   ARG A  67       8.025  21.103  17.284  1.00  8.05           N  
ATOM    515  CA  ARG A  67       6.810  20.387  16.915  1.00  9.14           C  
ATOM    516  C   ARG A  67       7.085  18.888  16.942  1.00  8.31           C  
ATOM    517  O   ARG A  67       6.262  18.106  17.416  1.00  9.62           O  
ATOM    518  CB  ARG A  67       6.344  20.779  15.509  1.00  8.37           C  
ATOM    519  CG  ARG A  67       5.704  22.158  15.401  1.00  7.57           C  
ATOM    520  CD  ARG A  67       5.095  22.369  14.024  1.00  8.24           C  
ATOM    521  NE  ARG A  67       6.098  22.460  12.968  1.00  8.36           N  
ATOM    522  CZ  ARG A  67       6.763  23.572  12.660  1.00  7.99           C  
ATOM    523  NH1 ARG A  67       6.533  24.690  13.338  1.00 10.42           N  
ATOM    524  NH2 ARG A  67       7.631  23.576  11.656  1.00  8.33           N  
ATOM    525  N   LYS A  68       8.253  18.504  16.432  1.00  8.53           N  
ATOM    526  CA  LYS A  68       8.658  17.102  16.360  1.00  7.42           C  
ATOM    527  C   LYS A  68       8.563  16.364  17.685  1.00  8.65           C  
ATOM    528  O   LYS A  68       7.909  15.324  17.778  1.00  9.92           O  
ATOM    529  CB  LYS A  68      10.093  16.997  15.832  1.00  7.65           C  
ATOM    530  CG  LYS A  68      10.659  15.581  15.771  1.00  8.37           C  
ATOM    531  CD  LYS A  68      12.125  15.600  15.343  1.00  7.11           C  
ATOM    532  CE  LYS A  68      12.749  14.209  15.335  1.00  9.47           C  
ATOM    533  NZ  LYS A  68      12.114  13.293  14.341  1.00  9.06           N  
ATOM    534  N   TRP A  69       9.216  16.892  18.712  1.00  8.67           N  
ATOM    535  CA  TRP A  69       9.206  16.213  19.995  1.00  9.19           C  
ATOM    536  C   TRP A  69       7.993  16.462  20.878  1.00 10.40           C  
ATOM    537  O   TRP A  69       7.919  15.974  22.004  1.00 11.05           O  
ATOM    538  CB  TRP A  69      10.526  16.477  20.724  1.00  9.52           C  
ATOM    539  CG  TRP A  69      11.651  15.737  20.040  1.00  9.04           C  
ATOM    540  CD1 TRP A  69      11.674  14.405  19.724  1.00  9.60           C  
ATOM    541  CD2 TRP A  69      12.887  16.284  19.555  1.00  9.07           C  
ATOM    542  NE1 TRP A  69      12.844  14.092  19.069  1.00  9.16           N  
ATOM    543  CE2 TRP A  69      13.604  15.223  18.952  1.00  9.53           C  
ATOM    544  CE3 TRP A  69      13.458  17.564  19.568  1.00  9.24           C  
ATOM    545  CZ2 TRP A  69      14.863  15.402  18.368  1.00  8.47           C  
ATOM    546  CZ3 TRP A  69      14.712  17.743  18.987  1.00  9.81           C  
ATOM    547  CH2 TRP A  69      15.399  16.666  18.396  1.00 10.19           C  
ATOM    548  N   ALA A  70       7.035  17.221  20.360  1.00 10.71           N  
ATOM    549  CA  ALA A  70       5.793  17.443  21.083  1.00 10.26           C  
ATOM    550  C   ALA A  70       4.876  16.330  20.569  1.00 11.15           C  
ATOM    551  O   ALA A  70       3.893  15.971  21.212  1.00 12.17           O  
ATOM    552  CB  ALA A  70       5.209  18.807  20.740  1.00 12.10           C  
ATOM    553  N   LYS A  71       5.239  15.779  19.408  1.00  9.88           N  
ATOM    554  CA  LYS A  71       4.482  14.721  18.733  1.00 10.84           C  
ATOM    555  C   LYS A  71       5.069  13.318  18.874  1.00  9.97           C  
ATOM    556  O   LYS A  71       4.342  12.350  19.131  1.00 10.54           O  
ATOM    557  CB  LYS A  71       4.368  15.048  17.239  1.00 11.04           C  
ATOM    558  CG  LYS A  71       3.744  13.940  16.395  1.00 14.78           C  
ATOM    559  CD  LYS A  71       2.273  13.756  16.720  1.00 15.27           C  
ATOM    560  CE  LYS A  71       1.711  12.522  16.037  1.00 18.31           C  
ATOM    561  NZ  LYS A  71       0.272  12.353  16.347  1.00 16.89           N  
ATOM    562  N   GLU A  72       6.379  13.206  18.670  1.00  9.84           N  
ATOM    563  CA  GLU A  72       7.057  11.920  18.760  1.00  9.29           C  
ATOM    564  C   GLU A  72       7.510  11.704  20.199  1.00  9.33           C  
ATOM    565  O   GLU A  72       8.570  12.171  20.618  1.00 11.35           O  
ATOM    566  CB  GLU A  72       8.239  11.891  17.783  1.00  9.26           C  
ATOM    567  CG  GLU A  72       7.799  12.125  16.333  1.00  7.89           C  
ATOM    568  CD  GLU A  72       8.944  12.104  15.332  1.00 10.11           C  
ATOM    569  OE1 GLU A  72      10.115  12.258  15.742  1.00 11.15           O  
ATOM    570  OE2 GLU A  72       8.668  11.951  14.123  1.00 10.76           O  
ATOM    571  N   LEU A  73       6.672  10.996  20.950  1.00  9.12           N  
ATOM    572  CA  LEU A  73       6.908  10.718  22.363  1.00  9.12           C  
ATOM    573  C   LEU A  73       7.830   9.522  22.617  1.00  9.15           C  
ATOM    574  O   LEU A  73       7.805   8.538  21.878  1.00 10.42           O  
ATOM    575  CB  LEU A  73       5.557  10.499  23.055  1.00  9.29           C  
ATOM    576  CG  LEU A  73       4.522  11.581  22.719  1.00 10.85           C  
ATOM    577  CD1 LEU A  73       3.188  11.264  23.381  1.00 11.57           C  
ATOM    578  CD2 LEU A  73       5.047  12.934  23.181  1.00 12.00           C  
ATOM    579  N   ASP A  74       8.636   9.619  23.676  1.00 10.67           N  
ATOM    580  CA  ASP A  74       9.583   8.564  24.043  1.00 11.19           C  
ATOM    581  C   ASP A  74      10.492   8.207  22.869  1.00  9.87           C  
ATOM    582  O   ASP A  74      10.758   7.042  22.592  1.00 11.14           O  
ATOM    583  CB  ASP A  74       8.836   7.324  24.539  1.00 12.87           C  
ATOM    584  CG  ASP A  74       8.271   7.510  25.934  1.00 15.78           C  
ATOM    585  OD1 ASP A  74       9.066   7.777  26.856  1.00 19.51           O  
ATOM    586  OD2 ASP A  74       7.041   7.395  26.116  1.00 18.76           O  
ATOM    587  N   TYR A  75      10.971   9.248  22.204  1.00  9.02           N  
ATOM    588  CA  TYR A  75      11.845   9.152  21.041  1.00  8.19           C  
ATOM    589  C   TYR A  75      13.251   8.641  21.364  1.00  8.05           C  
ATOM    590  O   TYR A  75      13.923   9.175  22.245  1.00  9.95           O  
ATOM    591  CB  TYR A  75      11.907  10.544  20.396  1.00  8.79           C  
ATOM    592  CG  TYR A  75      12.905  10.750  19.281  1.00  8.35           C  
ATOM    593  CD1 TYR A  75      14.242  11.033  19.560  1.00  7.03           C  
ATOM    594  CD2 TYR A  75      12.497  10.748  17.949  1.00  8.36           C  
ATOM    595  CE1 TYR A  75      15.146  11.322  18.537  1.00  9.76           C  
ATOM    596  CE2 TYR A  75      13.391  11.028  16.919  1.00  9.54           C  
ATOM    597  CZ  TYR A  75      14.713  11.317  17.221  1.00  8.01           C  
ATOM    598  OH  TYR A  75      15.606  11.622  16.216  1.00  9.26           O  
ATOM    599  N   ARG A  76      13.674   7.602  20.643  1.00  8.85           N  
ATOM    600  CA  ARG A  76      15.011   7.009  20.779  1.00  9.99           C  
ATOM    601  C   ARG A  76      15.567   6.835  19.369  1.00 10.03           C  
ATOM    602  O   ARG A  76      14.915   6.237  18.512  1.00  8.76           O  
ATOM    603  CB  ARG A  76      14.943   5.654  21.476  1.00  9.95           C  
ATOM    604  CG  ARG A  76      14.645   5.750  22.959  1.00 11.95           C  
ATOM    605  CD  ARG A  76      14.767   4.390  23.636  1.00 11.70           C  
ATOM    606  NE  ARG A  76      14.583   4.490  25.082  1.00 12.76           N  
ATOM    607  CZ  ARG A  76      13.405   4.616  25.684  1.00 14.38           C  
ATOM    608  NH1 ARG A  76      12.287   4.656  24.969  1.00 15.33           N  
ATOM    609  NH2 ARG A  76      13.347   4.709  27.008  1.00 14.55           N  
ATOM    610  N   LEU A  77      16.784   7.329  19.152  1.00  9.14           N  
ATOM    611  CA  LEU A  77      17.419   7.313  17.838  1.00  8.71           C  
ATOM    612  C   LEU A  77      18.780   6.636  17.723  1.00  8.37           C  
ATOM    613  O   LEU A  77      19.582   6.665  18.655  1.00 10.68           O  
ATOM    614  CB  LEU A  77      17.581   8.762  17.372  1.00  8.44           C  
ATOM    615  CG  LEU A  77      18.488   9.044  16.171  1.00  7.69           C  
ATOM    616  CD1 LEU A  77      17.744   8.719  14.885  1.00  8.44           C  
ATOM    617  CD2 LEU A  77      18.907  10.510  16.179  1.00  9.25           C  
ATOM    618  N   ILE A  78      19.033   6.052  16.555  1.00  9.00           N  
ATOM    619  CA  ILE A  78      20.326   5.442  16.249  1.00 10.30           C  
ATOM    620  C   ILE A  78      20.680   5.826  14.809  1.00  9.68           C  
ATOM    621  O   ILE A  78      19.899   5.570  13.885  1.00  9.56           O  
ATOM    622  CB  ILE A  78      20.315   3.901  16.327  1.00 10.13           C  
ATOM    623  CG1 ILE A  78      19.971   3.435  17.742  1.00 10.51           C  
ATOM    624  CG2 ILE A  78      21.702   3.367  15.943  1.00 10.97           C  
ATOM    625  CD1 ILE A  78      20.073   1.921  17.924  1.00 12.67           C  
ATOM    626  N   LYS A  79      21.843   6.453  14.639  1.00 10.34           N  
ATOM    627  CA  LYS A  79      22.350   6.874  13.331  1.00  9.71           C  
ATOM    628  C   LYS A  79      23.562   6.016  12.976  1.00 10.91           C  
ATOM    629  O   LYS A  79      24.245   5.499  13.862  1.00 10.56           O  
ATOM    630  CB  LYS A  79      22.821   8.336  13.356  1.00 10.26           C  
ATOM    631  CG  LYS A  79      21.770   9.412  13.601  1.00 10.44           C  
ATOM    632  CD  LYS A  79      22.427  10.786  13.410  1.00  9.73           C  
ATOM    633  CE  LYS A  79      21.526  11.950  13.793  1.00 10.02           C  
ATOM    634  NZ  LYS A  79      20.301  12.043  12.953  1.00 10.46           N  
ATOM    635  N   GLU A  80      23.842   5.882  11.682  1.00 10.57           N  
ATOM    636  CA  GLU A  80      24.998   5.113  11.235  1.00 10.07           C  
ATOM    637  C   GLU A  80      25.498   5.609   9.882  1.00  9.97           C  
ATOM    638  O   GLU A  80      24.715   5.992   9.011  1.00 10.75           O  
ATOM    639  CB  GLU A  80      24.655   3.630  11.129  1.00 11.65           C  
ATOM    640  CG  GLU A  80      25.879   2.744  10.903  1.00 11.14           C  
ATOM    641  CD  GLU A  80      25.523   1.276  10.878  1.00 13.96           C  
ATOM    642  OE1 GLU A  80      24.906   0.824   9.890  1.00 15.66           O  
ATOM    643  OE2 GLU A  80      25.849   0.575  11.858  1.00 17.75           O  
ATOM    644  N   LEU A  81      26.812   5.592   9.712  1.00 10.17           N  
ATOM    645  CA  LEU A  81      27.436   6.036   8.474  1.00  9.55           C  
ATOM    646  C   LEU A  81      27.103   5.118   7.314  1.00 10.81           C  
ATOM    647  O   LEU A  81      26.992   3.902   7.488  1.00 11.39           O  
ATOM    648  CB  LEU A  81      28.962   6.069   8.640  1.00 10.25           C  
ATOM    649  CG  LEU A  81      29.779   6.262   7.355  1.00  9.86           C  
ATOM    650  CD1 LEU A  81      29.644   7.702   6.885  1.00 11.97           C  
ATOM    651  CD2 LEU A  81      31.242   5.928   7.603  1.00 12.08           C  
ATOM    652  N   TRP A  82      26.908   5.708   6.136  1.00 11.74           N  
ATOM    653  CA  TRP A  82      26.692   4.920   4.929  1.00 10.83           C  
ATOM    654  C   TRP A  82      27.894   5.202   4.036  1.00 10.78           C  
ATOM    655  O   TRP A  82      28.618   4.288   3.649  1.00 12.71           O  
ATOM    656  CB  TRP A  82      25.432   5.313   4.162  1.00 11.56           C  
ATOM    657  CG  TRP A  82      25.249   4.412   2.967  1.00 12.03           C  
ATOM    658  CD1 TRP A  82      25.343   4.754   1.644  1.00 10.89           C  
ATOM    659  CD2 TRP A  82      24.999   3.001   2.998  1.00 12.03           C  
ATOM    660  NE1 TRP A  82      25.162   3.641   0.851  1.00 10.53           N  
ATOM    661  CE2 TRP A  82      24.950   2.552   1.657  1.00 12.09           C  
ATOM    662  CE3 TRP A  82      24.810   2.071   4.029  1.00 11.10           C  
ATOM    663  CZ2 TRP A  82      24.718   1.213   1.322  1.00 10.62           C  
ATOM    664  CZ3 TRP A  82      24.580   0.739   3.699  1.00 10.02           C  
ATOM    665  CH2 TRP A  82      24.536   0.324   2.353  1.00 12.93           C  
ATOM    666  N   ALA A  83      28.094   6.479   3.720  1.00  9.76           N  
ATOM    667  CA  ALA A  83      29.204   6.914   2.876  1.00  9.91           C  
ATOM    668  C   ALA A  83      29.528   8.373   3.176  1.00 10.47           C  
ATOM    669  O   ALA A  83      28.727   9.083   3.783  1.00 11.60           O  
ATOM    670  CB  ALA A  83      28.839   6.758   1.404  1.00 10.39           C  
ATOM    671  N   PHE A  84      30.705   8.822   2.751  1.00 10.75           N  
ATOM    672  CA  PHE A  84      31.102  10.204   2.971  1.00 10.42           C  
ATOM    673  C   PHE A  84      32.041  10.640   1.862  1.00 10.01           C  
ATOM    674  O   PHE A  84      32.763   9.822   1.287  1.00 11.94           O  
ATOM    675  CB  PHE A  84      31.793  10.356   4.331  1.00 10.68           C  
ATOM    676  CG  PHE A  84      33.158   9.727   4.393  1.00 13.64           C  
ATOM    677  CD1 PHE A  84      34.300  10.486   4.159  1.00 13.98           C  
ATOM    678  CD2 PHE A  84      33.296   8.368   4.648  1.00 13.23           C  
ATOM    679  CE1 PHE A  84      35.565   9.898   4.177  1.00 15.15           C  
ATOM    680  CE2 PHE A  84      34.557   7.768   4.668  1.00 15.47           C  
ATOM    681  CZ  PHE A  84      35.691   8.534   4.431  1.00 14.96           C  
ATOM    682  N   THR A  85      32.013  11.928   1.549  1.00 11.10           N  
ATOM    683  CA  THR A  85      32.879  12.478   0.520  1.00 11.68           C  
ATOM    684  C   THR A  85      33.093  13.948   0.810  1.00 13.01           C  
ATOM    685  O   THR A  85      32.145  14.731   0.822  1.00 12.67           O  
ATOM    686  CB  THR A  85      32.271  12.352  -0.884  1.00 11.03           C  
ATOM    687  OG1 THR A  85      31.956  10.981  -1.154  1.00 11.57           O  
ATOM    688  CG2 THR A  85      33.264  12.851  -1.921  1.00 13.12           C  
ATOM    689  N   ASP A  86      34.346  14.312   1.053  1.00 13.64           N  
ATOM    690  CA  ASP A  86      34.696  15.688   1.348  1.00 14.67           C  
ATOM    691  C   ASP A  86      33.878  16.216   2.524  1.00 13.12           C  
ATOM    692  O   ASP A  86      33.966  15.675   3.621  1.00 11.17           O  
ATOM    693  CB  ASP A  86      34.492  16.562   0.107  1.00 17.49           C  
ATOM    694  CG  ASP A  86      35.328  16.097  -1.069  1.00 22.52           C  
ATOM    695  OD1 ASP A  86      36.513  15.765  -0.857  1.00 24.31           O  
ATOM    696  OD2 ASP A  86      34.807  16.067  -2.202  1.00 26.15           O  
ATOM    697  N   ASN A  87      33.076  17.252   2.291  1.00 12.50           N  
ATOM    698  CA  ASN A  87      32.270  17.851   3.353  1.00 11.82           C  
ATOM    699  C   ASN A  87      30.853  17.297   3.438  1.00 11.12           C  
ATOM    700  O   ASN A  87      29.999  17.867   4.117  1.00 10.71           O  
ATOM    701  CB  ASN A  87      32.220  19.372   3.174  1.00 12.54           C  
ATOM    702  CG  ASN A  87      31.488  19.790   1.912  1.00 12.29           C  
ATOM    703  OD1 ASN A  87      31.580  19.133   0.877  1.00 15.84           O  
ATOM    704  ND2 ASN A  87      30.770  20.902   1.990  1.00 14.71           N  
ATOM    705  N   ARG A  88      30.610  16.183   2.756  1.00 10.95           N  
ATOM    706  CA  ARG A  88      29.291  15.561   2.768  1.00 10.28           C  
ATOM    707  C   ARG A  88      29.283  14.200   3.449  1.00 10.12           C  
ATOM    708  O   ARG A  88      30.233  13.431   3.340  1.00 10.47           O  
ATOM    709  CB  ARG A  88      28.767  15.380   1.342  1.00 10.17           C  
ATOM    710  CG  ARG A  88      28.374  16.655   0.631  1.00 10.56           C  
ATOM    711  CD  ARG A  88      27.880  16.343  -0.768  1.00 10.54           C  
ATOM    712  NE  ARG A  88      27.424  17.534  -1.480  1.00 11.97           N  
ATOM    713  CZ  ARG A  88      26.993  17.521  -2.736  1.00 12.22           C  
ATOM    714  NH1 ARG A  88      26.961  16.380  -3.408  1.00 12.38           N  
ATOM    715  NH2 ARG A  88      26.590  18.646  -3.316  1.00 14.60           N  
ATOM    716  N   ILE A  89      28.197  13.914   4.157  1.00  9.42           N  
ATOM    717  CA  ILE A  89      28.041  12.628   4.815  1.00 10.30           C  
ATOM    718  C   ILE A  89      26.649  12.100   4.480  1.00 10.56           C  
ATOM    719  O   ILE A  89      25.683  12.867   4.400  1.00 10.78           O  
ATOM    720  CB  ILE A  89      28.185  12.747   6.352  1.00 10.14           C  
ATOM    721  CG1 ILE A  89      29.551  13.344   6.713  1.00 10.25           C  
ATOM    722  CG2 ILE A  89      28.062  11.361   6.991  1.00  9.88           C  
ATOM    723  CD1 ILE A  89      29.775  13.522   8.218  1.00 10.55           C  
ATOM    724  N   ALA A  90      26.562  10.795   4.250  1.00  9.27           N  
ATOM    725  CA  ALA A  90      25.301  10.122   3.954  1.00  9.90           C  
ATOM    726  C   ALA A  90      25.066   9.222   5.157  1.00  9.55           C  
ATOM    727  O   ALA A  90      25.894   8.357   5.464  1.00 10.19           O  
ATOM    728  CB  ALA A  90      25.423   9.299   2.688  1.00 10.85           C  
ATOM    729  N   VAL A  91      23.935   9.428   5.828  1.00  8.97           N  
ATOM    730  CA  VAL A  91      23.594   8.700   7.045  1.00 10.62           C  
ATOM    731  C   VAL A  91      22.303   7.895   6.981  1.00 10.08           C  
ATOM    732  O   VAL A  91      21.315   8.339   6.394  1.00 10.29           O  
ATOM    733  CB  VAL A  91      23.454   9.699   8.221  1.00 11.00           C  
ATOM    734  CG1 VAL A  91      23.219   8.957   9.526  1.00 11.90           C  
ATOM    735  CG2 VAL A  91      24.689  10.579   8.308  1.00 11.71           C  
ATOM    736  N   ARG A  92      22.320   6.712   7.594  1.00 10.07           N  
ATOM    737  CA  ARG A  92      21.140   5.854   7.687  1.00  9.94           C  
ATOM    738  C   ARG A  92      20.745   5.918   9.152  1.00  9.85           C  
ATOM    739  O   ARG A  92      21.605   6.059  10.022  1.00 10.17           O  
ATOM    740  CB  ARG A  92      21.463   4.399   7.331  1.00 11.00           C  
ATOM    741  CG  ARG A  92      21.663   4.126   5.850  1.00 13.80           C  
ATOM    742  CD  ARG A  92      21.952   2.647   5.625  1.00 16.17           C  
ATOM    743  NE  ARG A  92      20.859   1.801   6.091  1.00 20.17           N  
ATOM    744  CZ  ARG A  92      21.013   0.699   6.818  1.00 21.03           C  
ATOM    745  NH1 ARG A  92      22.226   0.294   7.176  1.00 21.19           N  
ATOM    746  NH2 ARG A  92      19.951   0.002   7.192  1.00 23.38           N  
ATOM    747  N   TYR A  93      19.456   5.824   9.440  1.00  8.81           N  
ATOM    748  CA  TYR A  93      19.035   5.864  10.827  1.00  8.49           C  
ATOM    749  C   TYR A  93      17.653   5.297  11.049  1.00  8.36           C  
ATOM    750  O   TYR A  93      16.915   5.009  10.106  1.00  8.68           O  
ATOM    751  CB  TYR A  93      19.083   7.294  11.377  1.00  8.80           C  
ATOM    752  CG  TYR A  93      18.126   8.296  10.750  1.00  8.13           C  
ATOM    753  CD1 TYR A  93      18.448   8.956   9.562  1.00  7.69           C  
ATOM    754  CD2 TYR A  93      16.960   8.677  11.416  1.00  9.44           C  
ATOM    755  CE1 TYR A  93      17.643   9.990   9.065  1.00  7.90           C  
ATOM    756  CE2 TYR A  93      16.154   9.701  10.930  1.00  9.86           C  
ATOM    757  CZ  TYR A  93      16.503  10.361   9.767  1.00  9.11           C  
ATOM    758  OH  TYR A  93      15.769  11.454   9.355  1.00  9.93           O  
ATOM    759  N   ALA A  94      17.322   5.122  12.321  1.00  9.47           N  
ATOM    760  CA  ALA A  94      16.019   4.629  12.716  1.00  8.27           C  
ATOM    761  C   ALA A  94      15.718   5.174  14.096  1.00  8.47           C  
ATOM    762  O   ALA A  94      16.620   5.338  14.921  1.00  9.17           O  
ATOM    763  CB  ALA A  94      16.002   3.104  12.741  1.00  9.42           C  
ATOM    764  N   TYR A  95      14.455   5.501  14.332  1.00  8.88           N  
ATOM    765  CA  TYR A  95      14.045   5.973  15.636  1.00  8.48           C  
ATOM    766  C   TYR A  95      12.700   5.371  15.997  1.00  9.02           C  
ATOM    767  O   TYR A  95      11.829   5.203  15.141  1.00  9.96           O  
ATOM    768  CB  TYR A  95      14.033   7.515  15.704  1.00  8.31           C  
ATOM    769  CG  TYR A  95      13.062   8.281  14.816  1.00  6.84           C  
ATOM    770  CD1 TYR A  95      11.768   8.564  15.250  1.00  7.25           C  
ATOM    771  CD2 TYR A  95      13.485   8.840  13.605  1.00  8.46           C  
ATOM    772  CE1 TYR A  95      10.919   9.395  14.509  1.00  6.00           C  
ATOM    773  CE2 TYR A  95      12.644   9.676  12.856  1.00  6.81           C  
ATOM    774  CZ  TYR A  95      11.367   9.950  13.320  1.00  8.09           C  
ATOM    775  OH  TYR A  95      10.548  10.809  12.618  1.00  8.83           O  
ATOM    776  N   GLU A  96      12.562   4.979  17.258  1.00  8.41           N  
ATOM    777  CA  GLU A  96      11.317   4.399  17.730  1.00  9.13           C  
ATOM    778  C   GLU A  96      10.630   5.434  18.594  1.00 10.25           C  
ATOM    779  O   GLU A  96      11.285   6.238  19.262  1.00 10.60           O  
ATOM    780  CB  GLU A  96      11.579   3.106  18.510  1.00 10.66           C  
ATOM    781  CG  GLU A  96      12.189   2.024  17.638  1.00 11.52           C  
ATOM    782  CD  GLU A  96      12.338   0.695  18.345  1.00 10.89           C  
ATOM    783  OE1 GLU A  96      12.354   0.680  19.588  1.00 11.82           O  
ATOM    784  OE2 GLU A  96      12.457  -0.333  17.651  1.00 11.28           O  
ATOM    785  N   TRP A  97       9.304   5.419  18.559  1.00  9.33           N  
ATOM    786  CA  TRP A  97       8.509   6.384  19.296  1.00  9.68           C  
ATOM    787  C   TRP A  97       7.056   5.954  19.254  1.00  9.28           C  
ATOM    788  O   TRP A  97       6.707   4.976  18.595  1.00  9.35           O  
ATOM    789  CB  TRP A  97       8.621   7.758  18.622  1.00 10.41           C  
ATOM    790  CG  TRP A  97       8.180   7.752  17.166  1.00  9.92           C  
ATOM    791  CD1 TRP A  97       8.858   7.221  16.103  1.00  9.51           C  
ATOM    792  CD2 TRP A  97       6.968   8.306  16.628  1.00  8.82           C  
ATOM    793  NE1 TRP A  97       8.148   7.413  14.939  1.00  9.59           N  
ATOM    794  CE2 TRP A  97       6.985   8.075  15.232  1.00  9.36           C  
ATOM    795  CE3 TRP A  97       5.871   8.975  17.191  1.00  8.80           C  
ATOM    796  CZ2 TRP A  97       5.943   8.493  14.387  1.00  8.92           C  
ATOM    797  CZ3 TRP A  97       4.833   9.393  16.346  1.00  9.87           C  
ATOM    798  CH2 TRP A  97       4.882   9.147  14.960  1.00 10.32           C  
ATOM    799  N   HIS A  98       6.210   6.695  19.959  1.00  9.23           N  
ATOM    800  CA  HIS A  98       4.782   6.416  19.940  1.00  8.51           C  
ATOM    801  C   HIS A  98       4.034   7.738  19.950  1.00  9.19           C  
ATOM    802  O   HIS A  98       4.561   8.754  20.406  1.00  8.87           O  
ATOM    803  CB  HIS A  98       4.354   5.559  21.146  1.00  8.57           C  
ATOM    804  CG  HIS A  98       4.480   6.253  22.468  1.00  9.95           C  
ATOM    805  ND1 HIS A  98       3.507   7.095  22.967  1.00  9.66           N  
ATOM    806  CD2 HIS A  98       5.478   6.248  23.381  1.00 10.05           C  
ATOM    807  CE1 HIS A  98       3.904   7.579  24.131  1.00 11.03           C  
ATOM    808  NE2 HIS A  98       5.096   7.082  24.406  1.00 12.44           N  
ATOM    809  N   ASP A  99       2.813   7.729  19.427  1.00 10.87           N  
ATOM    810  CA  ASP A  99       2.011   8.943  19.432  1.00 10.30           C  
ATOM    811  C   ASP A  99       1.151   8.930  20.689  1.00 11.25           C  
ATOM    812  O   ASP A  99       1.242   8.000  21.496  1.00 10.38           O  
ATOM    813  CB  ASP A  99       1.141   9.054  18.166  1.00  9.84           C  
ATOM    814  CG  ASP A  99       0.192   7.878  17.975  1.00 11.28           C  
ATOM    815  OD1 ASP A  99      -0.141   7.186  18.960  1.00  9.91           O  
ATOM    816  OD2 ASP A  99      -0.243   7.659  16.821  1.00 11.33           O  
ATOM    817  N   ASP A 100       0.333   9.959  20.872  1.00  9.10           N  
ATOM    818  CA  ASP A 100      -0.505  10.010  22.060  1.00  8.98           C  
ATOM    819  C   ASP A 100      -1.820   9.243  21.945  1.00  9.85           C  
ATOM    820  O   ASP A 100      -2.773   9.505  22.681  1.00 12.25           O  
ATOM    821  CB  ASP A 100      -0.749  11.461  22.505  1.00  9.17           C  
ATOM    822  CG  ASP A 100      -1.216  12.360  21.390  1.00  9.21           C  
ATOM    823  OD1 ASP A 100      -1.559  11.858  20.300  1.00 11.22           O  
ATOM    824  OD2 ASP A 100      -1.243  13.589  21.616  1.00  8.43           O  
ATOM    825  N   SER A 101      -1.858   8.286  21.022  1.00 10.04           N  
ATOM    826  CA  SER A 101      -3.023   7.427  20.853  1.00 10.59           C  
ATOM    827  C   SER A 101      -2.560   6.006  21.167  1.00 12.53           C  
ATOM    828  O   SER A 101      -3.320   5.048  21.042  1.00 14.77           O  
ATOM    829  CB  SER A 101      -3.567   7.499  19.425  1.00 10.53           C  
ATOM    830  OG  SER A 101      -4.073   8.791  19.141  1.00  9.95           O  
ATOM    831  N   GLY A 102      -1.296   5.882  21.567  1.00 11.57           N  
ATOM    832  CA  GLY A 102      -0.753   4.578  21.916  1.00 12.41           C  
ATOM    833  C   GLY A 102      -0.125   3.790  20.783  1.00 13.60           C  
ATOM    834  O   GLY A 102       0.280   2.641  20.982  1.00 14.06           O  
ATOM    835  N   ASN A 103      -0.032   4.392  19.601  1.00 10.84           N  
ATOM    836  CA  ASN A 103       0.555   3.711  18.451  1.00 10.75           C  
ATOM    837  C   ASN A 103       2.068   3.844  18.444  1.00 11.55           C  
ATOM    838  O   ASN A 103       2.594   4.957  18.425  1.00 11.41           O  
ATOM    839  CB  ASN A 103       0.035   4.302  17.138  1.00 11.94           C  
ATOM    840  CG  ASN A 103      -1.471   4.328  17.058  1.00 11.56           C  
ATOM    841  OD1 ASN A 103      -2.068   5.373  16.786  1.00 13.06           O  
ATOM    842  ND2 ASN A 103      -2.099   3.181  17.284  1.00 10.68           N  
ATOM    843  N   TRP A 104       2.764   2.712  18.455  1.00 10.21           N  
ATOM    844  CA  TRP A 104       4.220   2.731  18.392  1.00 10.41           C  
ATOM    845  C   TRP A 104       4.653   2.638  16.934  1.00 10.54           C  
ATOM    846  O   TRP A 104       3.973   2.023  16.108  1.00 10.18           O  
ATOM    847  CB  TRP A 104       4.828   1.555  19.159  1.00 10.55           C  
ATOM    848  CG  TRP A 104       4.935   1.779  20.631  1.00 10.72           C  
ATOM    849  CD1 TRP A 104       4.008   1.458  21.578  1.00 10.60           C  
ATOM    850  CD2 TRP A 104       6.034   2.379  21.329  1.00 10.68           C  
ATOM    851  NE1 TRP A 104       4.461   1.816  22.825  1.00 13.57           N  
ATOM    852  CE2 TRP A 104       5.702   2.383  22.703  1.00 12.17           C  
ATOM    853  CE3 TRP A 104       7.267   2.913  20.927  1.00 11.00           C  
ATOM    854  CZ2 TRP A 104       6.560   2.902  23.682  1.00 13.04           C  
ATOM    855  CZ3 TRP A 104       8.123   3.431  21.904  1.00 13.27           C  
ATOM    856  CH2 TRP A 104       7.761   3.419  23.265  1.00 13.46           C  
ATOM    857  N   PHE A 105       5.787   3.249  16.623  1.00 10.28           N  
ATOM    858  CA  PHE A 105       6.327   3.218  15.273  1.00 10.07           C  
ATOM    859  C   PHE A 105       7.836   3.088  15.295  1.00 10.23           C  
ATOM    860  O   PHE A 105       8.496   3.445  16.275  1.00  9.46           O  
ATOM    861  CB  PHE A 105       6.056   4.527  14.509  1.00 10.27           C  
ATOM    862  CG  PHE A 105       4.608   4.880  14.347  1.00 10.22           C  
ATOM    863  CD1 PHE A 105       3.946   5.624  15.321  1.00 11.16           C  
ATOM    864  CD2 PHE A 105       3.917   4.514  13.196  1.00 10.78           C  
ATOM    865  CE1 PHE A 105       2.616   6.003  15.149  1.00 11.08           C  
ATOM    866  CE2 PHE A 105       2.588   4.888  13.016  1.00 11.90           C  
ATOM    867  CZ  PHE A 105       1.938   5.634  13.993  1.00 12.47           C  
ATOM    868  N   ARG A 106       8.378   2.551  14.211  1.00 10.15           N  
ATOM    869  CA  ARG A 106       9.815   2.538  14.038  1.00  9.54           C  
ATOM    870  C   ARG A 106       9.921   3.307  12.734  1.00 10.06           C  
ATOM    871  O   ARG A 106       9.315   2.930  11.723  1.00 10.41           O  
ATOM    872  CB  ARG A 106      10.429   1.150  13.858  1.00 10.83           C  
ATOM    873  CG  ARG A 106      11.952   1.272  13.664  1.00  9.94           C  
ATOM    874  CD  ARG A 106      12.687  -0.056  13.653  1.00 13.05           C  
ATOM    875  NE  ARG A 106      12.374  -0.838  14.840  1.00 11.89           N  
ATOM    876  CZ  ARG A 106      11.643  -1.944  14.817  1.00 12.47           C  
ATOM    877  NH1 ARG A 106      11.166  -2.396  13.665  1.00 14.38           N  
ATOM    878  NH2 ARG A 106      11.366  -2.578  15.948  1.00 14.24           N  
ATOM    879  N   SER A 107      10.645   4.413  12.773  1.00  8.72           N  
ATOM    880  CA  SER A 107      10.814   5.235  11.592  1.00  9.57           C  
ATOM    881  C   SER A 107      12.199   4.988  11.019  1.00  9.31           C  
ATOM    882  O   SER A 107      13.195   4.975  11.747  1.00 10.18           O  
ATOM    883  CB  SER A 107      10.626   6.713  11.946  1.00  9.04           C  
ATOM    884  OG  SER A 107       9.275   6.965  12.328  1.00  9.46           O  
ATOM    885  N   TYR A 108      12.246   4.761   9.711  1.00  9.35           N  
ATOM    886  CA  TYR A 108      13.497   4.508   9.017  1.00  8.24           C  
ATOM    887  C   TYR A 108      13.847   5.734   8.195  1.00  9.49           C  
ATOM    888  O   TYR A 108      13.026   6.226   7.415  1.00  9.55           O  
ATOM    889  CB  TYR A 108      13.355   3.300   8.094  1.00 10.64           C  
ATOM    890  CG  TYR A 108      12.944   2.037   8.808  1.00 10.60           C  
ATOM    891  CD1 TYR A 108      11.612   1.803   9.150  1.00 11.44           C  
ATOM    892  CD2 TYR A 108      13.892   1.077   9.157  1.00  9.98           C  
ATOM    893  CE1 TYR A 108      11.236   0.640   9.823  1.00 12.84           C  
ATOM    894  CE2 TYR A 108      13.527  -0.083   9.828  1.00 12.45           C  
ATOM    895  CZ  TYR A 108      12.200  -0.295  10.157  1.00 13.72           C  
ATOM    896  OH  TYR A 108      11.840  -1.444  10.824  1.00 14.52           O  
ATOM    897  N   GLY A 109      15.069   6.220   8.359  1.00  8.37           N  
ATOM    898  CA  GLY A 109      15.473   7.395   7.617  1.00  9.36           C  
ATOM    899  C   GLY A 109      16.820   7.323   6.931  1.00  8.87           C  
ATOM    900  O   GLY A 109      17.678   6.501   7.264  1.00  8.82           O  
ATOM    901  N   ASN A 110      16.969   8.190   5.935  1.00  8.20           N  
ATOM    902  CA  ASN A 110      18.195   8.361   5.170  1.00  8.02           C  
ATOM    903  C   ASN A 110      18.334   9.878   5.146  1.00  7.70           C  
ATOM    904  O   ASN A 110      17.448  10.571   4.642  1.00  8.89           O  
ATOM    905  CB  ASN A 110      18.050   7.860   3.726  1.00  8.83           C  
ATOM    906  CG  ASN A 110      18.321   6.366   3.574  1.00 10.15           C  
ATOM    907  OD1 ASN A 110      17.906   5.750   2.583  1.00 13.24           O  
ATOM    908  ND2 ASN A 110      19.033   5.783   4.533  1.00  8.16           N  
ATOM    909  N   GLU A 111      19.414  10.399   5.720  1.00  8.49           N  
ATOM    910  CA  GLU A 111      19.634  11.838   5.725  1.00  9.60           C  
ATOM    911  C   GLU A 111      21.013  12.128   5.143  1.00 10.73           C  
ATOM    912  O   GLU A 111      21.994  11.441   5.446  1.00  9.44           O  
ATOM    913  CB  GLU A 111      19.507  12.400   7.149  1.00 10.00           C  
ATOM    914  CG  GLU A 111      20.499  11.819   8.147  1.00 10.38           C  
ATOM    915  CD  GLU A 111      20.177  12.183   9.585  1.00 11.54           C  
ATOM    916  OE1 GLU A 111      19.598  13.263   9.825  1.00 12.71           O  
ATOM    917  OE2 GLU A 111      20.523  11.387  10.486  1.00 10.45           O  
ATOM    918  N   ASN A 112      21.069  13.137   4.283  1.00  8.37           N  
ATOM    919  CA  ASN A 112      22.307  13.538   3.632  1.00  8.63           C  
ATOM    920  C   ASN A 112      22.677  14.922   4.142  1.00  9.28           C  
ATOM    921  O   ASN A 112      21.866  15.850   4.120  1.00  9.31           O  
ATOM    922  CB  ASN A 112      22.106  13.487   2.118  1.00  9.29           C  
ATOM    923  CG  ASN A 112      21.990  12.055   1.616  1.00  9.69           C  
ATOM    924  OD1 ASN A 112      21.225  11.747   0.693  1.00 13.02           O  
ATOM    925  ND2 ASN A 112      22.755  11.169   2.230  1.00  7.59           N  
ATOM    926  N   TRP A 113      23.909  15.032   4.624  1.00  9.68           N  
ATOM    927  CA  TRP A 113      24.415  16.253   5.230  1.00  8.70           C  
ATOM    928  C   TRP A 113      25.546  16.927   4.468  1.00  9.17           C  
ATOM    929  O   TRP A 113      26.402  16.255   3.897  1.00 10.92           O  
ATOM    930  CB  TRP A 113      24.954  15.948   6.632  1.00  9.51           C  
ATOM    931  CG  TRP A 113      24.049  15.190   7.573  1.00  9.58           C  
ATOM    932  CD1 TRP A 113      22.678  15.157   7.572  1.00  8.81           C  
ATOM    933  CD2 TRP A 113      24.460  14.480   8.749  1.00  9.15           C  
ATOM    934  NE1 TRP A 113      22.218  14.484   8.680  1.00  7.44           N  
ATOM    935  CE2 TRP A 113      23.290  14.059   9.419  1.00  8.89           C  
ATOM    936  CE3 TRP A 113      25.710  14.169   9.305  1.00 10.33           C  
ATOM    937  CZ2 TRP A 113      23.335  13.340  10.620  1.00 10.29           C  
ATOM    938  CZ3 TRP A 113      25.752  13.458  10.496  1.00  9.14           C  
ATOM    939  CH2 TRP A 113      24.572  13.052  11.141  1.00  9.50           C  
ATOM    940  N   GLU A 114      25.558  18.258   4.500  1.00  9.35           N  
ATOM    941  CA  GLU A 114      26.614  19.039   3.867  1.00 10.37           C  
ATOM    942  C   GLU A 114      27.045  20.096   4.885  1.00 10.98           C  
ATOM    943  O   GLU A 114      26.228  20.905   5.339  1.00 11.19           O  
ATOM    944  CB  GLU A 114      26.112  19.697   2.582  1.00 10.32           C  
ATOM    945  CG  GLU A 114      27.189  20.446   1.821  1.00 12.41           C  
ATOM    946  CD  GLU A 114      26.711  20.899   0.465  1.00 14.35           C  
ATOM    947  OE1 GLU A 114      26.613  20.051  -0.448  1.00 16.40           O  
ATOM    948  OE2 GLU A 114      26.415  22.101   0.315  1.00 19.56           O  
ATOM    949  N   PHE A 115      28.328  20.084   5.237  1.00 11.82           N  
ATOM    950  CA  PHE A 115      28.879  20.996   6.242  1.00 12.04           C  
ATOM    951  C   PHE A 115      29.745  22.128   5.717  1.00 12.03           C  
ATOM    952  O   PHE A 115      30.430  21.982   4.705  1.00 13.02           O  
ATOM    953  CB  PHE A 115      29.718  20.196   7.239  1.00 11.80           C  
ATOM    954  CG  PHE A 115      28.944  19.148   7.968  1.00  9.45           C  
ATOM    955  CD1 PHE A 115      28.300  19.450   9.161  1.00 10.18           C  
ATOM    956  CD2 PHE A 115      28.827  17.864   7.446  1.00  9.83           C  
ATOM    957  CE1 PHE A 115      27.551  18.489   9.827  1.00  9.81           C  
ATOM    958  CE2 PHE A 115      28.079  16.894   8.107  1.00 10.17           C  
ATOM    959  CZ  PHE A 115      27.439  17.209   9.302  1.00 10.84           C  
ATOM    960  N   ASP A 116      29.721  23.256   6.424  1.00 11.85           N  
ATOM    961  CA  ASP A 116      30.555  24.384   6.042  1.00 13.52           C  
ATOM    962  C   ASP A 116      31.918  24.159   6.686  1.00 14.76           C  
ATOM    963  O   ASP A 116      32.127  23.163   7.379  1.00 14.49           O  
ATOM    964  CB  ASP A 116      29.935  25.729   6.477  1.00 13.70           C  
ATOM    965  CG  ASP A 116      29.931  25.944   7.990  1.00 15.53           C  
ATOM    966  OD1 ASP A 116      30.512  25.139   8.746  1.00 14.97           O  
ATOM    967  OD2 ASP A 116      29.340  26.955   8.425  1.00 16.29           O  
ATOM    968  N   GLU A 117      32.847  25.076   6.456  1.00 16.54           N  
ATOM    969  CA  GLU A 117      34.195  24.939   6.992  1.00 18.46           C  
ATOM    970  C   GLU A 117      34.294  24.856   8.518  1.00 18.18           C  
ATOM    971  O   GLU A 117      35.241  24.268   9.046  1.00 18.48           O  
ATOM    972  CB  GLU A 117      35.065  26.087   6.474  1.00 21.08           C  
ATOM    973  CG  GLU A 117      35.057  26.227   4.951  1.00 27.69           C  
ATOM    974  CD  GLU A 117      33.730  26.739   4.397  1.00 30.40           C  
ATOM    975  OE1 GLU A 117      33.562  26.729   3.159  1.00 34.69           O  
ATOM    976  OE2 GLU A 117      32.857  27.159   5.188  1.00 30.86           O  
ATOM    977  N   GLN A 118      33.324  25.434   9.222  1.00 16.28           N  
ATOM    978  CA  GLN A 118      33.329  25.427  10.682  1.00 15.98           C  
ATOM    979  C   GLN A 118      32.603  24.243  11.314  1.00 14.80           C  
ATOM    980  O   GLN A 118      32.385  24.216  12.528  1.00 13.61           O  
ATOM    981  CB  GLN A 118      32.734  26.734  11.213  1.00 17.83           C  
ATOM    982  CG  GLN A 118      33.660  27.931  11.072  1.00 21.70           C  
ATOM    983  CD  GLN A 118      34.039  28.207   9.632  1.00 23.88           C  
ATOM    984  OE1 GLN A 118      33.194  28.579   8.817  1.00 25.46           O  
ATOM    985  NE2 GLN A 118      35.315  28.015   9.310  1.00 24.40           N  
ATOM    986  N   GLY A 119      32.234  23.267  10.492  1.00 13.60           N  
ATOM    987  CA  GLY A 119      31.552  22.094  11.007  1.00 13.66           C  
ATOM    988  C   GLY A 119      30.057  22.238  11.236  1.00 12.50           C  
ATOM    989  O   GLY A 119      29.432  21.330  11.783  1.00 13.51           O  
ATOM    990  N   LEU A 120      29.480  23.370  10.837  1.00 13.21           N  
ATOM    991  CA  LEU A 120      28.039  23.578  10.996  1.00 12.78           C  
ATOM    992  C   LEU A 120      27.356  23.028   9.752  1.00 11.67           C  
ATOM    993  O   LEU A 120      27.887  23.149   8.649  1.00 12.41           O  
ATOM    994  CB  LEU A 120      27.716  25.065  11.135  1.00 13.39           C  
ATOM    995  CG  LEU A 120      28.262  25.787  12.369  1.00 16.40           C  
ATOM    996  CD1 LEU A 120      27.860  27.249  12.315  1.00 17.64           C  
ATOM    997  CD2 LEU A 120      27.721  25.138  13.626  1.00 18.22           C  
HETATM  998  N   MSE A 121      26.179  22.429   9.916  1.00 11.66           N  
HETATM  999  CA  MSE A 121      25.491  21.869   8.759  1.00 11.07           C  
HETATM 1000  C   MSE A 121      24.700  22.911   7.980  1.00 10.37           C  
HETATM 1001  O   MSE A 121      23.751  23.506   8.497  1.00 11.15           O  
HETATM 1002  CB  MSE A 121      24.565  20.722   9.165  1.00 12.82           C  
HETATM 1003  CG  MSE A 121      24.282  19.805   7.982  1.00 12.52           C  
HETATM 1004 SE   MSE A 121      23.004  18.397   8.287  1.00 19.84          SE  
HETATM 1005  CE  MSE A 121      23.780  17.644   9.895  1.00 11.25           C  
ATOM   1006  N   ALA A 122      25.097  23.118   6.728  1.00 10.35           N  
ATOM   1007  CA  ALA A 122      24.454  24.100   5.855  1.00  9.51           C  
ATOM   1008  C   ALA A 122      23.238  23.543   5.117  1.00 10.89           C  
ATOM   1009  O   ALA A 122      22.301  24.280   4.804  1.00 11.13           O  
ATOM   1010  CB  ALA A 122      25.471  24.631   4.853  1.00 11.33           C  
ATOM   1011  N   ARG A 123      23.261  22.249   4.820  1.00 11.02           N  
ATOM   1012  CA  ARG A 123      22.146  21.621   4.127  1.00 10.41           C  
ATOM   1013  C   ARG A 123      21.829  20.267   4.730  1.00 10.81           C  
ATOM   1014  O   ARG A 123      22.731  19.479   5.021  1.00 10.75           O  
ATOM   1015  CB  ARG A 123      22.448  21.459   2.630  1.00 12.61           C  
ATOM   1016  CG  ARG A 123      22.689  22.777   1.898  1.00 14.40           C  
ATOM   1017  CD  ARG A 123      22.473  22.632   0.390  1.00 17.74           C  
ATOM   1018  NE  ARG A 123      23.439  21.736  -0.237  1.00 18.86           N  
ATOM   1019  CZ  ARG A 123      23.296  21.207  -1.451  1.00 19.82           C  
ATOM   1020  NH1 ARG A 123      24.231  20.404  -1.938  1.00 18.87           N  
ATOM   1021  NH2 ARG A 123      22.211  21.471  -2.170  1.00 19.51           N  
ATOM   1022  N   ARG A 124      20.539  20.018   4.929  1.00 10.29           N  
ATOM   1023  CA  ARG A 124      20.062  18.761   5.481  1.00  9.36           C  
ATOM   1024  C   ARG A 124      18.893  18.253   4.643  1.00  9.66           C  
ATOM   1025  O   ARG A 124      17.865  18.922   4.531  1.00 11.07           O  
ATOM   1026  CB  ARG A 124      19.603  18.941   6.933  1.00  9.22           C  
ATOM   1027  CG  ARG A 124      19.094  17.647   7.560  1.00  9.29           C  
ATOM   1028  CD  ARG A 124      18.602  17.796   9.001  1.00  9.61           C  
ATOM   1029  NE  ARG A 124      18.289  16.468   9.530  1.00 10.45           N  
ATOM   1030  CZ  ARG A 124      17.066  15.990   9.730  1.00  9.80           C  
ATOM   1031  NH1 ARG A 124      15.995  16.731   9.468  1.00  9.77           N  
ATOM   1032  NH2 ARG A 124      16.920  14.738  10.148  1.00  9.25           N  
ATOM   1033  N   PHE A 125      19.059  17.078   4.047  1.00  9.04           N  
ATOM   1034  CA  PHE A 125      18.005  16.467   3.238  1.00  7.91           C  
ATOM   1035  C   PHE A 125      17.661  15.148   3.916  1.00  8.35           C  
ATOM   1036  O   PHE A 125      18.453  14.205   3.880  1.00  9.84           O  
ATOM   1037  CB  PHE A 125      18.508  16.194   1.821  1.00  8.06           C  
ATOM   1038  CG  PHE A 125      18.849  17.433   1.050  1.00 11.51           C  
ATOM   1039  CD1 PHE A 125      17.844  18.250   0.540  1.00 14.52           C  
ATOM   1040  CD2 PHE A 125      20.177  17.777   0.825  1.00 12.24           C  
ATOM   1041  CE1 PHE A 125      18.159  19.396  -0.186  1.00 16.37           C  
ATOM   1042  CE2 PHE A 125      20.503  18.919   0.101  1.00 13.50           C  
ATOM   1043  CZ  PHE A 125      19.494  19.730  -0.408  1.00 15.39           C  
ATOM   1044  N   ALA A 126      16.491  15.084   4.544  1.00  7.63           N  
ATOM   1045  CA  ALA A 126      16.092  13.868   5.238  1.00  8.64           C  
ATOM   1046  C   ALA A 126      14.796  13.295   4.692  1.00  8.42           C  
ATOM   1047  O   ALA A 126      13.822  14.019   4.477  1.00  7.95           O  
ATOM   1048  CB  ALA A 126      15.950  14.139   6.735  1.00  8.72           C  
ATOM   1049  N   CYS A 127      14.806  11.991   4.448  1.00  8.21           N  
ATOM   1050  CA  CYS A 127      13.639  11.276   3.959  1.00  8.39           C  
ATOM   1051  C   CYS A 127      13.392  10.210   5.011  1.00  9.25           C  
ATOM   1052  O   CYS A 127      14.318   9.504   5.421  1.00  8.86           O  
ATOM   1053  CB  CYS A 127      13.917  10.654   2.591  1.00  9.77           C  
ATOM   1054  SG  CYS A 127      14.175  11.895   1.299  1.00  8.90           S  
ATOM   1055  N   ILE A 128      12.147  10.101   5.452  1.00  8.58           N  
ATOM   1056  CA  ILE A 128      11.804   9.171   6.521  1.00  9.10           C  
ATOM   1057  C   ILE A 128      10.486   8.458   6.278  1.00  9.15           C  
ATOM   1058  O   ILE A 128       9.518   9.075   5.834  1.00  9.12           O  
ATOM   1059  CB  ILE A 128      11.677   9.935   7.858  1.00  8.78           C  
ATOM   1060  CG1 ILE A 128      12.850  10.904   8.029  1.00 10.74           C  
ATOM   1061  CG2 ILE A 128      11.617   8.954   9.021  1.00 10.45           C  
ATOM   1062  CD1 ILE A 128      12.657  11.892   9.172  1.00 11.32           C  
ATOM   1063  N   ASN A 129      10.446   7.163   6.575  1.00  7.63           N  
ATOM   1064  CA  ASN A 129       9.217   6.400   6.429  1.00  9.04           C  
ATOM   1065  C   ASN A 129       8.903   5.716   7.743  1.00  9.93           C  
ATOM   1066  O   ASN A 129       9.804   5.349   8.497  1.00 10.90           O  
ATOM   1067  CB  ASN A 129       9.330   5.413   5.276  1.00  8.50           C  
ATOM   1068  CG  ASN A 129       9.452   6.121   3.949  1.00  8.35           C  
ATOM   1069  OD1 ASN A 129      10.531   6.180   3.354  1.00  8.39           O  
ATOM   1070  ND2 ASN A 129       8.342   6.698   3.487  1.00  9.10           N  
ATOM   1071  N   ASP A 130       7.615   5.552   8.007  1.00 10.66           N  
ATOM   1072  CA  ASP A 130       7.155   5.003   9.270  1.00 10.32           C  
ATOM   1073  C   ASP A 130       6.478   3.649   9.205  1.00 10.67           C  
ATOM   1074  O   ASP A 130       5.578   3.436   8.400  1.00 10.63           O  
ATOM   1075  CB  ASP A 130       6.199   6.013   9.900  1.00 11.62           C  
ATOM   1076  CG  ASP A 130       6.698   7.438   9.758  1.00 12.88           C  
ATOM   1077  OD1 ASP A 130       7.781   7.743  10.297  1.00 10.79           O  
ATOM   1078  OD2 ASP A 130       6.014   8.252   9.099  1.00 12.98           O  
HETATM 1079  N   MSE A 131       6.909   2.742  10.073  1.00 10.71           N  
HETATM 1080  CA  MSE A 131       6.323   1.412  10.131  1.00 11.48           C  
HETATM 1081  C   MSE A 131       5.667   1.186  11.493  1.00 11.67           C  
HETATM 1082  O   MSE A 131       6.317   1.280  12.536  1.00 10.32           O  
HETATM 1083  CB  MSE A 131       7.394   0.349   9.897  1.00 14.73           C  
HETATM 1084  CG  MSE A 131       6.826  -1.052   9.736  1.00 18.26           C  
HETATM 1085 SE   MSE A 131       8.199  -2.369   9.429  1.00 33.17          SE  
HETATM 1086  CE  MSE A 131       8.726  -2.594  11.258  1.00 13.94           C  
ATOM   1087  N   PRO A 132       4.354   0.919  11.503  1.00 12.32           N  
ATOM   1088  CA  PRO A 132       3.661   0.685  12.772  1.00 13.56           C  
ATOM   1089  C   PRO A 132       4.203  -0.598  13.389  1.00 12.74           C  
ATOM   1090  O   PRO A 132       4.418  -1.580  12.682  1.00 13.51           O  
ATOM   1091  CB  PRO A 132       2.202   0.539  12.347  1.00 14.94           C  
ATOM   1092  CG  PRO A 132       2.124   1.385  11.103  1.00 15.84           C  
ATOM   1093  CD  PRO A 132       3.395   1.004  10.388  1.00 13.56           C  
ATOM   1094  N   ILE A 133       4.435  -0.583  14.697  1.00 13.13           N  
ATOM   1095  CA  ILE A 133       4.935  -1.764  15.393  1.00 12.14           C  
ATOM   1096  C   ILE A 133       4.200  -1.940  16.708  1.00 13.45           C  
ATOM   1097  O   ILE A 133       3.595  -1.000  17.225  1.00 13.34           O  
ATOM   1098  CB  ILE A 133       6.447  -1.662  15.733  1.00 10.90           C  
ATOM   1099  CG1 ILE A 133       6.697  -0.455  16.643  1.00 10.14           C  
ATOM   1100  CG2 ILE A 133       7.266  -1.601  14.454  1.00  9.78           C  
ATOM   1101  CD1 ILE A 133       8.084  -0.420  17.258  1.00 14.16           C  
ATOM   1102  N   LYS A 134       4.243  -3.156  17.240  1.00 13.74           N  
ATOM   1103  CA  LYS A 134       3.628  -3.419  18.529  1.00 14.76           C  
ATOM   1104  C   LYS A 134       4.709  -3.071  19.547  1.00 13.41           C  
ATOM   1105  O   LYS A 134       5.905  -3.159  19.245  1.00 13.47           O  
ATOM   1106  CB  LYS A 134       3.240  -4.896  18.649  1.00 15.85           C  
ATOM   1107  CG  LYS A 134       2.252  -5.364  17.590  1.00 20.39           C  
ATOM   1108  CD  LYS A 134       1.825  -6.806  17.815  1.00 24.83           C  
ATOM   1109  CE  LYS A 134       0.951  -6.947  19.053  1.00 28.34           C  
ATOM   1110  NZ  LYS A 134      -0.333  -6.199  18.922  1.00 31.77           N  
ATOM   1111  N   ALA A 135       4.301  -2.668  20.746  1.00 13.97           N  
ATOM   1112  CA  ALA A 135       5.264  -2.312  21.781  1.00 14.68           C  
ATOM   1113  C   ALA A 135       6.286  -3.427  22.011  1.00 15.94           C  
ATOM   1114  O   ALA A 135       7.451  -3.156  22.305  1.00 15.70           O  
ATOM   1115  CB  ALA A 135       4.541  -1.995  23.082  1.00 17.41           C  
ATOM   1116  N   GLN A 136       5.851  -4.676  21.876  1.00 16.64           N  
ATOM   1117  CA  GLN A 136       6.750  -5.806  22.083  1.00 19.24           C  
ATOM   1118  C   GLN A 136       7.833  -5.925  21.014  1.00 18.87           C  
ATOM   1119  O   GLN A 136       8.808  -6.655  21.189  1.00 19.25           O  
ATOM   1120  CB  GLN A 136       5.960  -7.119  22.167  1.00 21.95           C  
ATOM   1121  CG  GLN A 136       4.612  -7.131  21.451  1.00 28.09           C  
ATOM   1122  CD  GLN A 136       3.509  -6.453  22.250  1.00 29.87           C  
ATOM   1123  OE1 GLN A 136       3.262  -5.253  22.107  1.00 30.77           O  
ATOM   1124  NE2 GLN A 136       2.847  -7.222  23.110  1.00 32.61           N  
ATOM   1125  N   GLU A 137       7.665  -5.201  19.912  1.00 18.43           N  
ATOM   1126  CA  GLU A 137       8.637  -5.229  18.823  1.00 17.08           C  
ATOM   1127  C   GLU A 137       9.736  -4.187  18.996  1.00 14.87           C  
ATOM   1128  O   GLU A 137      10.684  -4.151  18.216  1.00 15.77           O  
ATOM   1129  CB  GLU A 137       7.949  -4.981  17.480  1.00 19.01           C  
ATOM   1130  CG  GLU A 137       6.904  -6.002  17.089  1.00 22.22           C  
ATOM   1131  CD  GLU A 137       6.331  -5.717  15.717  1.00 23.42           C  
ATOM   1132  OE1 GLU A 137       7.066  -5.876  14.718  1.00 26.61           O  
ATOM   1133  OE2 GLU A 137       5.153  -5.321  15.634  1.00 23.01           O  
ATOM   1134  N   ARG A 138       9.602  -3.331  20.004  1.00 12.85           N  
ATOM   1135  CA  ARG A 138      10.595  -2.291  20.250  1.00 12.87           C  
ATOM   1136  C   ARG A 138      11.990  -2.867  20.453  1.00 14.43           C  
ATOM   1137  O   ARG A 138      12.159  -3.872  21.148  1.00 15.04           O  
ATOM   1138  CB  ARG A 138      10.224  -1.480  21.489  1.00 12.49           C  
ATOM   1139  CG  ARG A 138       8.960  -0.644  21.362  1.00 13.49           C  
ATOM   1140  CD  ARG A 138       8.583  -0.084  22.725  1.00 12.83           C  
ATOM   1141  NE  ARG A 138       9.697   0.636  23.337  1.00 15.57           N  
ATOM   1142  CZ  ARG A 138       9.780   0.936  24.631  1.00 17.33           C  
ATOM   1143  NH1 ARG A 138       8.810   0.575  25.465  1.00 19.47           N  
ATOM   1144  NH2 ARG A 138      10.838   1.593  25.092  1.00 18.39           N  
ATOM   1145  N   LYS A 139      12.987  -2.221  19.853  1.00 13.60           N  
ATOM   1146  CA  LYS A 139      14.369  -2.664  19.985  1.00 15.44           C  
ATOM   1147  C   LYS A 139      15.217  -1.690  20.809  1.00 15.44           C  
ATOM   1148  O   LYS A 139      16.286  -2.057  21.298  1.00 16.21           O  
ATOM   1149  CB  LYS A 139      15.005  -2.850  18.603  1.00 17.21           C  
ATOM   1150  CG  LYS A 139      14.417  -3.990  17.791  1.00 20.97           C  
ATOM   1151  CD  LYS A 139      15.165  -4.174  16.478  1.00 26.93           C  
ATOM   1152  CE  LYS A 139      14.640  -5.377  15.707  1.00 29.47           C  
ATOM   1153  NZ  LYS A 139      15.445  -5.652  14.482  1.00 32.48           N  
ATOM   1154  N   PHE A 140      14.742  -0.456  20.972  1.00 15.18           N  
ATOM   1155  CA  PHE A 140      15.486   0.557  21.729  1.00 15.03           C  
ATOM   1156  C   PHE A 140      14.882   0.735  23.127  1.00 16.64           C  
ATOM   1157  O   PHE A 140      13.729   1.136  23.259  1.00 15.88           O  
ATOM   1158  CB  PHE A 140      15.468   1.902  20.982  1.00 15.52           C  
ATOM   1159  CG  PHE A 140      15.835   1.809  19.514  1.00 15.28           C  
ATOM   1160  CD1 PHE A 140      16.556   0.727  19.012  1.00 16.81           C  
ATOM   1161  CD2 PHE A 140      15.472   2.830  18.639  1.00 14.97           C  
ATOM   1162  CE1 PHE A 140      16.910   0.665  17.660  1.00 14.81           C  
ATOM   1163  CE2 PHE A 140      15.822   2.780  17.289  1.00 14.42           C  
ATOM   1164  CZ  PHE A 140      16.542   1.695  16.797  1.00 14.93           C  
ATOM   1165  N   HIS A 141      15.670   0.468  24.169  1.00 18.23           N  
ATOM   1166  CA  HIS A 141      15.164   0.553  25.542  1.00 19.11           C  
ATOM   1167  C   HIS A 141      15.984   1.341  26.568  1.00 19.94           C  
ATOM   1168  O   HIS A 141      15.648   1.335  27.756  1.00 20.70           O  
ATOM   1169  CB  HIS A 141      14.967  -0.864  26.079  1.00 19.64           C  
ATOM   1170  CG  HIS A 141      14.054  -1.704  25.244  1.00 18.93           C  
ATOM   1171  ND1 HIS A 141      12.682  -1.609  25.322  1.00 21.51           N  
ATOM   1172  CD2 HIS A 141      14.315  -2.635  24.297  1.00 20.99           C  
ATOM   1173  CE1 HIS A 141      12.136  -2.446  24.458  1.00 20.52           C  
ATOM   1174  NE2 HIS A 141      13.104  -3.081  23.823  1.00 20.74           N  
ATOM   1175  N   TRP A 142      17.041   2.016  26.134  1.00 17.75           N  
ATOM   1176  CA  TRP A 142      17.879   2.769  27.067  1.00 17.48           C  
ATOM   1177  C   TRP A 142      17.171   3.985  27.660  1.00 17.45           C  
ATOM   1178  O   TRP A 142      16.205   4.493  27.089  1.00 17.43           O  
ATOM   1179  CB  TRP A 142      19.174   3.203  26.367  1.00 15.87           C  
ATOM   1180  CG  TRP A 142      18.989   4.220  25.264  1.00 15.36           C  
ATOM   1181  CD1 TRP A 142      18.930   5.578  25.401  1.00 15.49           C  
ATOM   1182  CD2 TRP A 142      18.864   3.954  23.859  1.00 14.61           C  
ATOM   1183  NE1 TRP A 142      18.780   6.174  24.170  1.00 15.56           N  
ATOM   1184  CE2 TRP A 142      18.736   5.201  23.207  1.00 15.31           C  
ATOM   1185  CE3 TRP A 142      18.847   2.784  23.090  1.00 13.13           C  
ATOM   1186  CZ2 TRP A 142      18.596   5.313  21.818  1.00 13.16           C  
ATOM   1187  CZ3 TRP A 142      18.709   2.893  21.706  1.00 13.71           C  
ATOM   1188  CH2 TRP A 142      18.585   4.153  21.086  1.00 12.67           C  
ATOM   1189  N   PRO A 143      17.629   4.459  28.832  1.00 17.96           N  
ATOM   1190  CA  PRO A 143      16.989   5.629  29.447  1.00 18.23           C  
ATOM   1191  C   PRO A 143      17.030   6.788  28.455  1.00 17.37           C  
ATOM   1192  O   PRO A 143      18.081   7.063  27.874  1.00 16.97           O  
ATOM   1193  CB  PRO A 143      17.857   5.887  30.677  1.00 19.48           C  
ATOM   1194  CG  PRO A 143      18.342   4.512  31.037  1.00 20.54           C  
ATOM   1195  CD  PRO A 143      18.706   3.935  29.691  1.00 19.94           C  
ATOM   1196  N   LEU A 144      15.894   7.454  28.251  1.00 16.97           N  
ATOM   1197  CA  LEU A 144      15.834   8.563  27.303  1.00 17.24           C  
ATOM   1198  C   LEU A 144      17.048   9.466  27.417  1.00 15.54           C  
ATOM   1199  O   LEU A 144      17.379   9.960  28.497  1.00 16.57           O  
ATOM   1200  CB  LEU A 144      14.554   9.384  27.492  1.00 18.56           C  
ATOM   1201  CG  LEU A 144      13.241   8.726  27.051  1.00 19.93           C  
ATOM   1202  CD1 LEU A 144      12.106   9.722  27.223  1.00 19.53           C  
ATOM   1203  CD2 LEU A 144      13.332   8.279  25.598  1.00 19.09           C  
ATOM   1204  N   GLY A 145      17.708   9.671  26.283  1.00 12.96           N  
ATOM   1205  CA  GLY A 145      18.908  10.481  26.240  1.00 13.81           C  
ATOM   1206  C   GLY A 145      19.936   9.770  25.379  1.00 12.59           C  
ATOM   1207  O   GLY A 145      19.582   8.953  24.533  1.00 12.90           O  
ATOM   1208  N   ARG A 146      21.213  10.059  25.604  1.00 12.99           N  
ATOM   1209  CA  ARG A 146      22.284   9.446  24.823  1.00 13.25           C  
ATOM   1210  C   ARG A 146      22.289   7.917  24.861  1.00 14.05           C  
ATOM   1211  O   ARG A 146      22.114   7.309  25.917  1.00 14.63           O  
ATOM   1212  CB  ARG A 146      23.641   9.968  25.304  1.00 14.34           C  
ATOM   1213  CG  ARG A 146      24.835   9.440  24.508  1.00 15.69           C  
ATOM   1214  CD  ARG A 146      26.148  10.052  24.995  1.00 17.55           C  
ATOM   1215  NE  ARG A 146      27.292   9.628  24.188  1.00 18.63           N  
ATOM   1216  CZ  ARG A 146      27.849   8.420  24.241  1.00 21.34           C  
ATOM   1217  NH1 ARG A 146      27.375   7.498  25.069  1.00 22.23           N  
ATOM   1218  NH2 ARG A 146      28.881   8.130  23.456  1.00 21.03           N  
ATOM   1219  N   ARG A 147      22.486   7.301  23.699  1.00 13.01           N  
ATOM   1220  CA  ARG A 147      22.551   5.847  23.602  1.00 13.51           C  
ATOM   1221  C   ARG A 147      23.856   5.390  24.255  1.00 15.04           C  
ATOM   1222  O   ARG A 147      24.920   5.927  23.961  1.00 14.50           O  
ATOM   1223  CB  ARG A 147      22.529   5.411  22.127  1.00 13.30           C  
ATOM   1224  CG  ARG A 147      22.802   3.925  21.899  1.00 12.23           C  
ATOM   1225  CD  ARG A 147      22.524   3.508  20.451  1.00 13.53           C  
ATOM   1226  NE  ARG A 147      23.326   4.261  19.488  1.00 14.77           N  
ATOM   1227  CZ  ARG A 147      24.406   3.792  18.867  1.00 14.19           C  
ATOM   1228  NH1 ARG A 147      24.834   2.558  19.096  1.00 15.33           N  
ATOM   1229  NH2 ARG A 147      25.057   4.562  18.006  1.00 12.85           N  
ATOM   1230  N   PRO A 148      23.786   4.402  25.164  1.00 15.45           N  
ATOM   1231  CA  PRO A 148      24.994   3.905  25.832  1.00 18.92           C  
ATOM   1232  C   PRO A 148      26.027   3.420  24.815  1.00 21.23           C  
ATOM   1233  O   PRO A 148      25.666   2.883  23.768  1.00 21.91           O  
ATOM   1234  CB  PRO A 148      24.460   2.767  26.697  1.00 18.26           C  
ATOM   1235  CG  PRO A 148      23.089   3.245  27.058  1.00 16.79           C  
ATOM   1236  CD  PRO A 148      22.580   3.772  25.732  1.00 15.69           C  
ATOM   1237  N   ASP A 149      27.309   3.605  25.120  1.00 26.10           N  
ATOM   1238  CA  ASP A 149      28.361   3.172  24.206  1.00 29.07           C  
ATOM   1239  C   ASP A 149      28.300   1.663  23.995  1.00 30.19           C  
ATOM   1240  O   ASP A 149      28.688   1.159  22.941  1.00 32.21           O  
ATOM   1241  CB  ASP A 149      29.743   3.561  24.744  1.00 31.68           C  
ATOM   1242  CG  ASP A 149      29.930   5.064  24.844  1.00 34.32           C  
ATOM   1243  OD1 ASP A 149      29.458   5.663  25.833  1.00 36.54           O  
ATOM   1244  OD2 ASP A 149      30.544   5.651  23.928  1.00 38.02           O  
ATOM   1245  N   ASP A 150      27.794   0.948  24.994  1.00 30.98           N  
ATOM   1246  CA  ASP A 150      27.690  -0.502  24.914  1.00 31.23           C  
ATOM   1247  C   ASP A 150      26.461  -0.960  24.138  1.00 29.95           C  
ATOM   1248  O   ASP A 150      26.275  -2.155  23.910  1.00 31.46           O  
ATOM   1249  CB  ASP A 150      27.654  -1.113  26.321  1.00 34.70           C  
ATOM   1250  CG  ASP A 150      27.991  -0.107  27.408  1.00 37.46           C  
ATOM   1251  OD1 ASP A 150      27.130   0.747  27.719  1.00 38.59           O  
ATOM   1252  OD2 ASP A 150      29.118  -0.167  27.945  1.00 38.50           O  
ATOM   1253  N   HIS A 151      25.618  -0.017  23.728  1.00 25.61           N  
ATOM   1254  CA  HIS A 151      24.417  -0.379  22.989  1.00 22.10           C  
ATOM   1255  C   HIS A 151      24.714  -0.599  21.511  1.00 20.80           C  
ATOM   1256  O   HIS A 151      25.386   0.212  20.876  1.00 20.37           O  
ATOM   1257  CB  HIS A 151      23.346   0.703  23.124  1.00 21.32           C  
ATOM   1258  CG  HIS A 151      22.005   0.278  22.616  1.00 20.25           C  
ATOM   1259  ND1 HIS A 151      20.986  -0.126  23.451  1.00 19.45           N  
ATOM   1260  CD2 HIS A 151      21.536   0.130  21.354  1.00 18.56           C  
ATOM   1261  CE1 HIS A 151      19.950  -0.506  22.726  1.00 17.49           C  
ATOM   1262  NE2 HIS A 151      20.259  -0.361  21.451  1.00 19.63           N  
ATOM   1263  N   PRO A 152      24.205  -1.704  20.944  1.00 19.99           N  
ATOM   1264  CA  PRO A 152      24.422  -2.020  19.530  1.00 18.77           C  
ATOM   1265  C   PRO A 152      23.887  -0.942  18.599  1.00 17.87           C  
ATOM   1266  O   PRO A 152      22.888  -0.287  18.898  1.00 17.56           O  
ATOM   1267  CB  PRO A 152      23.694  -3.353  19.356  1.00 20.26           C  
ATOM   1268  CG  PRO A 152      22.624  -3.301  20.407  1.00 21.29           C  
ATOM   1269  CD  PRO A 152      23.365  -2.732  21.582  1.00 19.95           C  
ATOM   1270  N   GLY A 153      24.570  -0.761  17.473  1.00 17.71           N  
ATOM   1271  CA  GLY A 153      24.144   0.229  16.503  1.00 17.73           C  
ATOM   1272  C   GLY A 153      23.287  -0.421  15.440  1.00 16.61           C  
ATOM   1273  O   GLY A 153      22.912  -1.586  15.561  1.00 15.89           O  
ATOM   1274  N   LEU A 154      22.975   0.326  14.388  1.00 15.43           N  
ATOM   1275  CA  LEU A 154      22.149  -0.197  13.313  1.00 17.38           C  
ATOM   1276  C   LEU A 154      22.687  -1.518  12.761  1.00 18.17           C  
ATOM   1277  O   LEU A 154      21.926  -2.465  12.554  1.00 21.43           O  
ATOM   1278  CB  LEU A 154      22.047   0.838  12.191  1.00 17.33           C  
ATOM   1279  CG  LEU A 154      20.633   1.228  11.764  1.00 19.46           C  
ATOM   1280  CD1 LEU A 154      19.839   1.720  12.967  1.00 18.66           C  
ATOM   1281  CD2 LEU A 154      20.714   2.305  10.697  1.00 17.36           C  
ATOM   1282  N   SER A 155      23.998  -1.579  12.538  1.00 18.87           N  
ATOM   1283  CA  SER A 155      24.638  -2.779  12.004  1.00 21.22           C  
ATOM   1284  C   SER A 155      24.553  -3.989  12.932  1.00 20.39           C  
ATOM   1285  O   SER A 155      24.337  -5.110  12.473  1.00 19.87           O  
ATOM   1286  CB  SER A 155      26.114  -2.505  11.691  1.00 21.67           C  
ATOM   1287  OG  SER A 155      26.259  -1.586  10.622  1.00 27.08           O  
ATOM   1288  N   GLU A 156      24.735  -3.766  14.230  1.00 20.20           N  
ATOM   1289  CA  GLU A 156      24.691  -4.861  15.191  1.00 20.02           C  
ATOM   1290  C   GLU A 156      23.282  -5.380  15.449  1.00 20.46           C  
ATOM   1291  O   GLU A 156      23.107  -6.526  15.862  1.00 20.86           O  
ATOM   1292  CB  GLU A 156      25.347  -4.442  16.515  1.00 20.69           C  
ATOM   1293  CG  GLU A 156      26.838  -4.141  16.390  1.00 24.12           C  
ATOM   1294  CD  GLU A 156      27.517  -3.913  17.731  1.00 25.18           C  
ATOM   1295  OE1 GLU A 156      28.723  -3.583  17.737  1.00 26.77           O  
ATOM   1296  OE2 GLU A 156      26.853  -4.070  18.777  1.00 26.44           O  
ATOM   1297  N   LEU A 157      22.277  -4.544  15.209  1.00 20.69           N  
ATOM   1298  CA  LEU A 157      20.896  -4.961  15.409  1.00 22.32           C  
ATOM   1299  C   LEU A 157      20.414  -5.738  14.192  1.00 23.12           C  
ATOM   1300  O   LEU A 157      19.503  -6.559  14.288  1.00 24.76           O  
ATOM   1301  CB  LEU A 157      19.993  -3.744  15.635  1.00 23.24           C  
ATOM   1302  CG  LEU A 157      20.179  -2.999  16.960  1.00 23.96           C  
ATOM   1303  CD1 LEU A 157      19.282  -1.774  16.990  1.00 24.11           C  
ATOM   1304  CD2 LEU A 157      19.854  -3.930  18.124  1.00 24.96           C  
ATOM   1305  N   GLY A 158      21.036  -5.473  13.047  1.00 22.93           N  
ATOM   1306  CA  GLY A 158      20.657  -6.155  11.824  1.00 25.22           C  
ATOM   1307  C   GLY A 158      19.392  -5.569  11.230  1.00 26.32           C  
ATOM   1308  O   GLY A 158      18.823  -4.628  11.781  1.00 26.13           O  
ATOM   1309  N   LEU A 159      18.952  -6.122  10.104  1.00 27.31           N  
ATOM   1310  CA  LEU A 159      17.745  -5.643   9.442  1.00 28.04           C  
ATOM   1311  C   LEU A 159      16.593  -5.662  10.439  1.00 28.26           C  
ATOM   1312  O   LEU A 159      16.322  -6.684  11.074  1.00 27.05           O  
ATOM   1313  CB  LEU A 159      17.412  -6.533   8.244  1.00 29.11           C  
ATOM   1314  CG  LEU A 159      16.279  -6.059   7.333  1.00 30.81           C  
ATOM   1315  CD1 LEU A 159      16.659  -4.730   6.691  1.00 31.31           C  
ATOM   1316  CD2 LEU A 159      16.016  -7.109   6.265  1.00 31.74           C  
ATOM   1317  N   GLU A 160      15.916  -4.526  10.572  1.00 28.90           N  
ATOM   1318  CA  GLU A 160      14.804  -4.412  11.503  1.00 30.88           C  
ATOM   1319  C   GLU A 160      13.446  -4.445  10.812  1.00 31.12           C  
ATOM   1320  O   GLU A 160      13.027  -3.469  10.194  1.00 30.59           O  
ATOM   1321  CB  GLU A 160      14.937  -3.122  12.316  1.00 31.55           C  
ATOM   1322  CG  GLU A 160      16.191  -3.066  13.173  1.00 34.91           C  
ATOM   1323  CD  GLU A 160      16.324  -1.760  13.927  1.00 37.14           C  
ATOM   1324  OE1 GLU A 160      15.389  -1.408  14.677  1.00 39.77           O  
ATOM   1325  OE2 GLU A 160      17.363  -1.085  13.771  1.00 39.37           O  
ATOM   1326  N   HIS A 161      12.766  -5.581  10.915  1.00 32.15           N  
ATOM   1327  CA  HIS A 161      11.445  -5.731  10.323  1.00 33.20           C  
ATOM   1328  C   HIS A 161      10.613  -6.699  11.152  1.00 32.97           C  
ATOM   1329  O   HIS A 161      11.145  -7.405  12.010  1.00 33.94           O  
ATOM   1330  CB  HIS A 161      11.549  -6.207   8.865  1.00 35.72           C  
ATOM   1331  CG  HIS A 161      12.347  -7.461   8.681  1.00 36.81           C  
ATOM   1332  ND1 HIS A 161      12.649  -7.970   7.435  1.00 37.43           N  
ATOM   1333  CD2 HIS A 161      12.906  -8.310   9.578  1.00 38.44           C  
ATOM   1334  CE1 HIS A 161      13.359  -9.076   7.571  1.00 38.24           C  
ATOM   1335  NE2 HIS A 161      13.529  -9.305   8.862  1.00 39.61           N  
ATOM   1336  N   HIS A 162       9.308  -6.717  10.908  1.00 32.42           N  
ATOM   1337  CA  HIS A 162       8.408  -7.596  11.645  1.00 32.21           C  
ATOM   1338  C   HIS A 162       8.900  -9.040  11.620  1.00 33.07           C  
ATOM   1339  O   HIS A 162       9.021  -9.680  12.665  1.00 34.94           O  
ATOM   1340  CB  HIS A 162       6.998  -7.522  11.055  1.00 30.14           C  
ATOM   1341  CG  HIS A 162       6.379  -6.160  11.131  1.00 28.74           C  
ATOM   1342  ND1 HIS A 162       6.212  -5.482  12.320  1.00 27.84           N  
ATOM   1343  CD2 HIS A 162       5.862  -5.361  10.168  1.00 27.60           C  
ATOM   1344  CE1 HIS A 162       5.618  -4.326  12.086  1.00 26.45           C  
ATOM   1345  NE2 HIS A 162       5.394  -4.228  10.788  1.00 27.45           N  
TER    1346      HIS A 162                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
