
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  445 ( 3437),  selected  445 , name 2axq_A
# Molecule2: number of CA atoms  320 ( 2378),  selected  320 , name T0452.pdb
# PARAMETERS: 2axq_A.T0452.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     2_A      M       1          3.364
LGA    K     3_A      I       2          2.159
LGA    N     4_A      K       3          1.974
LGA    V     5_A      I       4          1.230
LGA    L     6_A      A       5          0.970
LGA    L     7_A      I       6          0.712
LGA    L     8_A      V       7          0.673
LGA    G     9_A      G       8          0.847
LGA    S    10_A      F       9          2.419
LGA    G    11_A      G      10          2.549
LGA    F    12_A      T      11          1.330
LGA    V    13_A      V      12          1.515
LGA    A    14_A      G      13          1.760
LGA    Q    15_A      Q      14          2.593
LGA    P    16_A      G      15          2.366
LGA    V    17_A      V      16          1.295
LGA    I    18_A      A      17          1.157
LGA    D    19_A      E      18          1.520
LGA    T    20_A      L      19          1.556
LGA    L    21_A      L      20          1.682
LGA    A    22_A      I      21          2.765
LGA    -       -      R      22           -
LGA    A    23_A      K      23          3.608
LGA    N    24_A      R      24          1.356
LGA    D    25_A      E      25          4.883
LGA    -       -      E      26           -
LGA    -       -      I      27           -
LGA    -       -      E      28           -
LGA    -       -      K      29           -
LGA    -       -      A      30           -
LGA    -       -      I      31           -
LGA    -       -      G      32           -
LGA    D    26_A      E      33          2.682
LGA    I    27_A      F      34          2.327
LGA    N    28_A      K      35          1.708
LGA    V    29_A      V      36          2.283
LGA    -       -      T      37           -
LGA    T    30_A      A      38          3.666
LGA    V    31_A      V      39          2.398
LGA    A    32_A      A      40          1.514
LGA    C    33_A      D      41          1.207
LGA    R    34_A      S      42          3.451
LGA    -       -      K      43           -
LGA    T    35_A      S      44          3.304
LGA    L    36_A      S      45           #
LGA    A    37_A      -       -           -
LGA    N    38_A      -       -           -
LGA    A    39_A      -       -           -
LGA    Q    40_A      -       -           -
LGA    A    41_A      -       -           -
LGA    L    42_A      -       -           -
LGA    A    43_A      -       -           -
LGA    K    44_A      -       -           -
LGA    P    45_A      -       -           -
LGA    S    46_A      -       -           -
LGA    G    47_A      -       -           -
LGA    S    48_A      -       -           -
LGA    K    49_A      I      46           #
LGA    A    50_A      S      47           #
LGA    -       -      G      48           -
LGA    -       -      D      49           -
LGA    -       -      F      50           -
LGA    -       -      S      51           -
LGA    -       -      L      52           -
LGA    -       -      V      53           -
LGA    -       -      E      54           -
LGA    -       -      A      55           -
LGA    -       -      L      56           -
LGA    -       -      R      57           -
LGA    -       -      M      58           -
LGA    -       -      K      59           -
LGA    -       -      R      60           -
LGA    -       -      E      61           -
LGA    -       -      T      62           -
LGA    -       -      G      63           -
LGA    -       -      M      64           -
LGA    -       -      L      65           -
LGA    I    51_A      R      66          4.866
LGA    S    52_A      D      67          4.183
LGA    L    53_A      D      68           #
LGA    D    54_A      A      69          5.126
LGA    V    55_A      K      70          4.782
LGA    T    56_A      A      71           #
LGA    D    57_A      I      72          4.575
LGA    D    58_A      -       -           -
LGA    S    59_A      E      73          4.618
LGA    A    60_A      V      74          4.727
LGA    L    61_A      V      75          3.274
LGA    D    62_A      R      76          2.108
LGA    K    63_A      S      77          2.073
LGA    V    64_A      A      78          1.501
LGA    L    65_A      -       -           -
LGA    A    66_A      -       -           -
LGA    D    67_A      D      79          1.395
LGA    N    68_A      Y      80          1.422
LGA    D    69_A      D      81          1.652
LGA    V    70_A      V      82          0.910
LGA    V    71_A      L      83          0.831
LGA    I    72_A      I      84          0.401
LGA    S    73_A      E      85          0.574
LGA    L    74_A      A      86          0.760
LGA    I    75_A      S      87          1.127
LGA    -       -      V      88           -
LGA    P    76_A      T      89          3.138
LGA    Y    77_A      R      90           -
LGA    T    78_A      -       -           -
LGA    F    79_A      E      95          1.993
LGA    H    80_A      G      96          3.086
LGA    P    81_A      V      97          3.218
LGA    N    82_A      N      98          2.173
LGA    V    83_A      Y      99          1.733
LGA    V    84_A      I     100          3.189
LGA    K    85_A      R     101          3.986
LGA    S    86_A      E     102          3.005
LGA    A    87_A      A     103          1.942
LGA    I    88_A      L     104          4.240
LGA    R    89_A      K     105           #
LGA    T    90_A      R     106          3.572
LGA    K    91_A      G     107          2.912
LGA    T    92_A      K     108          2.205
LGA    D    93_A      H     109          1.742
LGA    V    94_A      V     110          1.348
LGA    V    95_A      V     111          1.178
LGA    T    96_A      T     112          1.105
LGA    S    97_A      S     113          2.491
LGA    S    98_A      N     114          3.563
LGA    -       -      K     115           -
LGA    -       -      G     116           -
LGA    Y    99_A      P     117           #
LGA    I   100_A      L     118          2.046
LGA    -       -      V     119           -
LGA    S   101_A      A     120          3.241
LGA    P   102_A      E     121          1.892
LGA    A   103_A      F     122           -
LGA    -       -      H     123           -
LGA    L   104_A      G     124          4.358
LGA    R   105_A      L     125          3.475
LGA    E   106_A      M     126           -
LGA    L   107_A      S     127           #
LGA    E   108_A      L     128          1.732
LGA    P   109_A      -       -           -
LGA    E   110_A      -       -           -
LGA    I   111_A      A     129          3.725
LGA    V   112_A      E     130          3.540
LGA    K   113_A      R     131          3.936
LGA    A   114_A      N     132          3.142
LGA    G   115_A      G     133          2.399
LGA    I   116_A      -       -           -
LGA    T   117_A      V     134          1.718
LGA    V   118_A      R     135          3.407
LGA    M   119_A      L     136          1.656
LGA    N   120_A      M     137          3.257
LGA    E   121_A      Y     138          2.587
LGA    I   122_A      E     139          1.180
LGA    G   123_A      A     140          0.999
LGA    -       -      T     141           -
LGA    L   124_A      V     142          3.459
LGA    D   125_A      G     143          3.417
LGA    P   126_A      G     144           #
LGA    -       -      A     145           -
LGA    G   127_A      M     146           #
LGA    I   128_A      P     147          2.550
LGA    D   129_A      V     148          2.582
LGA    H   130_A      V     149          3.262
LGA    L   131_A      K     150          3.675
LGA    Y   132_A      L     151          4.049
LGA    A   133_A      A     152          4.878
LGA    V   134_A      -       -           -
LGA    K   135_A      K     153           #
LGA    T   136_A      R     154           -
LGA    I   137_A      Y     155           -
LGA    D   138_A      L     156          3.753
LGA    E   139_A      A     157           -
LGA    V   140_A      L     158           -
LGA    -       -      C     159           -
LGA    H   141_A      E     160           #
LGA    R   142_A      I     161           -
LGA    A   143_A      -       -           -
LGA    G   144_A      -       -           -
LGA    G   145_A      -       -           -
LGA    K   146_A      -       -           -
LGA    L   147_A      E     162          5.385
LGA    K   148_A      -       -           -
LGA    S   149_A      S     163           #
LGA    F   150_A      V     164          4.282
LGA    L   151_A      K     165          2.450
LGA    S   152_A      G     166          1.480
LGA    Y   153_A      I     167          1.808
LGA    C   154_A      F     168          2.823
LGA    G   155_A      N     169          2.647
LGA    G   156_A      G     170          1.519
LGA    L   157_A      T     171          3.256
LGA    -       -      C     172           -
LGA    -       -      N     173           -
LGA    P   158_A      Y     174          5.499
LGA    A   159_A      I     175           -
LGA    P   160_A      L     176           -
LGA    E   161_A      S     177           -
LGA    D   162_A      -       -           -
LGA    S   163_A      R     178          6.014
LGA    -       -      M     179           -
LGA    -       -      E     180           -
LGA    D   164_A      E     181           #
LGA    -       -      E     182           -
LGA    -       -      R     183           -
LGA    -       -      L     184           -
LGA    -       -      P     185           -
LGA    -       -      Y     186           -
LGA    -       -      E     187           -
LGA    N   165_A      H     188          4.487
LGA    P   166_A      I     189          2.668
LGA    L   167_A      L     190          2.045
LGA    G   168_A      K     191           #
LGA    -       -      E     192           -
LGA    Y   169_A      A     193          2.399
LGA    K   170_A      Q     194          2.906
LGA    -       -      E     195           -
LGA    -       -      L     196           -
LGA    -       -      G     197           -
LGA    F   171_A      Y     198          4.391
LGA    S   172_A      A     199          5.174
LGA    W   173_A      E     200          3.408
LGA    S   174_A      A     201          4.924
LGA    S   175_A      D     202          2.111
LGA    R   176_A      P     203          4.705
LGA    G   177_A      S     204          2.417
LGA    V   178_A      Y     205          3.751
LGA    L   179_A      D     206           #
LGA    L   180_A      V     207           #
LGA    A   181_A      E     208          0.967
LGA    L   182_A      G     209           #
LGA    R   183_A      -       -           -
LGA    N   184_A      I     210           #
LGA    -       -      D     211           -
LGA    -       -      A     212           -
LGA    -       -      A     213           -
LGA    -       -      L     214           -
LGA    -       -      K     215           -
LGA    -       -      L     216           -
LGA    -       -      V     217           -
LGA    -       -      I     218           -
LGA    -       -      I     219           -
LGA    -       -      A     220           -
LGA    -       -      N     221           -
LGA    -       -      T     222           -
LGA    -       -      I     223           -
LGA    -       -      G     224           -
LGA    -       -      V     225           -
LGA    -       -      K     226           -
LGA    -       -      A     227           -
LGA    -       -      S     228           -
LGA    -       -      Y     229           -
LGA    -       -      E     230           -
LGA    -       -      D     231           -
LGA    S   185_A      V     232           #
LGA    A   186_A      E     233          1.781
LGA    K   187_A      V     234           #
LGA    Y   188_A      -       -           -
LGA    W   189_A      -       -           -
LGA    K   190_A      -       -           -
LGA    D   191_A      -       -           -
LGA    G   192_A      -       -           -
LGA    K   193_A      -       -           -
LGA    I   194_A      -       -           -
LGA    E   195_A      -       -           -
LGA    T   196_A      -       -           -
LGA    V   197_A      -       -           -
LGA    S   198_A      -       -           -
LGA    S   199_A      -       -           -
LGA    E   200_A      -       -           -
LGA    D   201_A      -       -           -
LGA    L   202_A      T     235          4.206
LGA    -       -      G     236           -
LGA    -       -      I     237           -
LGA    M   203_A      T     238           #
LGA    A   204_A      Q     239           #
LGA    T   205_A      -       -           -
LGA    A   206_A      -       -           -
LGA    K   207_A      I     240           #
LGA    -       -      T     241           -
LGA    -       -      P     242           -
LGA    -       -      E     243           -
LGA    -       -      A     244           -
LGA    -       -      F     245           -
LGA    -       -      Q     246           -
LGA    -       -      V     247           -
LGA    -       -      A     248           -
LGA    P   208_A      A     249           #
LGA    -       -      E     250           -
LGA    -       -      K     251           -
LGA    -       -      G     252           -
LGA    Y   209_A      Y     253           #
LGA    F   210_A      T     254           #
LGA    I   211_A      -       -           -
LGA    Y   212_A      -       -           -
LGA    P   213_A      -       -           -
LGA    G   214_A      -       -           -
LGA    Y   215_A      -       -           -
LGA    A   216_A      -       -           -
LGA    F   217_A      I     255          5.341
LGA    V   218_A      R     256          3.001
LGA    C   219_A      L     257          2.356
LGA    Y   220_A      I     258          5.100
LGA    -       -      A     259           -
LGA    -       -      E     260           -
LGA    -       -      V     261           -
LGA    -       -      S     262           -
LGA    -       -      R     263           -
LGA    -       -      E     264           -
LGA    -       -      K     265           -
LGA    -       -      L     266           -
LGA    P   221_A      K     267          4.826
LGA    N   222_A      V     268          1.535
LGA    R   223_A      -       -           -
LGA    D   224_A      -       -           -
LGA    S   225_A      -       -           -
LGA    T   226_A      -       -           -
LGA    L   227_A      -       -           -
LGA    F   228_A      -       -           -
LGA    K   229_A      -       -           -
LGA    D   230_A      -       -           -
LGA    L   231_A      -       -           -
LGA    Y   232_A      -       -           -
LGA    H   233_A      -       -           -
LGA    I   234_A      -       -           -
LGA    P   235_A      -       -           -
LGA    E   236_A      -       -           -
LGA    A   237_A      -       -           -
LGA    E   238_A      -       -           -
LGA    T   239_A      -       -           -
LGA    V   240_A      -       -           -
LGA    I   241_A      -       -           -
LGA    R   242_A      -       -           -
LGA    G   243_A      S     269           #
LGA    T   244_A      P     270           #
LGA    -       -      R     271           -
LGA    -       -      L     272           -
LGA    -       -      V     273           -
LGA    -       -      P     274           -
LGA    -       -      F     275           -
LGA    -       -      H     276           -
LGA    -       -      H     277           -
LGA    -       -      P     278           -
LGA    -       -      L     279           -
LGA    -       -      A     280           -
LGA    -       -      I     281           -
LGA    L   245_A      K     282           #
LGA    R   246_A      G     283           #
LGA    Y   247_A      -       -           -
LGA    Q   248_A      -       -           -
LGA    G   249_A      -       -           -
LGA    F   250_A      -       -           -
LGA    P   251_A      -       -           -
LGA    E   252_A      -       -           -
LGA    F   253_A      -       -           -
LGA    V   254_A      -       -           -
LGA    K   255_A      -       -           -
LGA    A   256_A      -       -           -
LGA    L   257_A      -       -           -
LGA    V   258_A      -       -           -
LGA    D   259_A      -       -           -
LGA    M   260_A      -       -           -
LGA    G   261_A      -       -           -
LGA    M   262_A      -       -           -
LGA    L   263_A      -       -           -
LGA    K   264_A      -       -           -
LGA    D   265_A      -       -           -
LGA    D   266_A      -       -           -
LGA    A   267_A      -       -           -
LGA    N   268_A      -       -           -
LGA    E   269_A      -       -           -
LGA    I   270_A      -       -           -
LGA    F   271_A      -       -           -
LGA    S   272_A      -       -           -
LGA    K   273_A      -       -           -
LGA    P   274_A      -       -           -
LGA    I   275_A      -       -           -
LGA    A   276_A      -       -           -
LGA    W   277_A      -       -           -
LGA    N   278_A      -       -           -
LGA    E   279_A      -       -           -
LGA    A   280_A      -       -           -
LGA    L   281_A      -       -           -
LGA    K   282_A      -       -           -
LGA    Q   283_A      -       -           -
LGA    Y   284_A      -       -           -
LGA    L   285_A      -       -           -
LGA    G   286_A      -       -           -
LGA    A   287_A      -       -           -
LGA    K   288_A      -       -           -
LGA    S   289_A      -       -           -
LGA    T   290_A      -       -           -
LGA    S   291_A      -       -           -
LGA    K   292_A      -       -           -
LGA    E   293_A      -       -           -
LGA    D   294_A      -       -           -
LGA    L   295_A      -       -           -
LGA    I   296_A      -       -           -
LGA    A   297_A      -       -           -
LGA    S   298_A      -       -           -
LGA    I   299_A      -       -           -
LGA    D   300_A      -       -           -
LGA    S   301_A      -       -           -
LGA    K   302_A      -       -           -
LGA    A   303_A      -       -           -
LGA    T   304_A      -       -           -
LGA    W   305_A      -       -           -
LGA    K   306_A      -       -           -
LGA    D   307_A      -       -           -
LGA    D   308_A      -       -           -
LGA    E   309_A      -       -           -
LGA    D   310_A      -       -           -
LGA    R   311_A      -       -           -
LGA    E   312_A      -       -           -
LGA    R   313_A      -       -           -
LGA    I   314_A      -       -           -
LGA    L   315_A      -       -           -
LGA    S   316_A      -       -           -
LGA    G   317_A      -       -           -
LGA    F   318_A      -       -           -
LGA    A   319_A      -       -           -
LGA    W   320_A      -       -           -
LGA    L   321_A      -       -           -
LGA    G   322_A      -       -           -
LGA    L   323_A      -       -           -
LGA    F   324_A      -       -           -
LGA    S   325_A      -       -           -
LGA    D   326_A      -       -           -
LGA    A   327_A      -       -           -
LGA    K   328_A      -       -           -
LGA    I   329_A      -       -           -
LGA    T   330_A      -       -           -
LGA    P   331_A      -       -           -
LGA    R   332_A      -       -           -
LGA    G   333_A      -       -           -
LGA    N   334_A      -       -           -
LGA    A   335_A      -       -           -
LGA    L   336_A      -       -           -
LGA    D   337_A      -       -           -
LGA    T   338_A      -       -           -
LGA    L   339_A      -       -           -
LGA    C   340_A      -       -           -
LGA    A   341_A      -       -           -
LGA    R   342_A      -       -           -
LGA    L   343_A      -       -           -
LGA    E   344_A      -       -           -
LGA    E   345_A      -       -           -
LGA    L   346_A      -       -           -
LGA    M   347_A      -       -           -
LGA    Q   348_A      -       -           -
LGA    Y   349_A      -       -           -
LGA    E   350_A      -       -           -
LGA    D   351_A      -       -           -
LGA    N   352_A      -       -           -
LGA    E   353_A      -       -           -
LGA    R   354_A      -       -           -
LGA    D   355_A      -       -           -
LGA    M   356_A      -       -           -
LGA    V   357_A      T     284          3.717
LGA    V   358_A      M     285          1.277
LGA    L   359_A      N     286          1.919
LGA    Q   360_A      A     287          2.255
LGA    H   361_A      A     288          2.479
LGA    K   362_A      M     289          3.430
LGA    F   363_A      F     290           #
LGA    -       -      K     291           -
LGA    -       -      T     292           -
LGA    -       -      D     293           -
LGA    -       -      T     294           -
LGA    -       -      A     295           -
LGA    G   364_A      G     296           #
LGA    I   365_A      -       -           -
LGA    E   366_A      -       -           -
LGA    W   367_A      -       -           -
LGA    A   368_A      -       -           -
LGA    D   369_A      -       -           -
LGA    G   370_A      -       -           -
LGA    T   371_A      -       -           -
LGA    T   372_A      -       -           -
LGA    E   373_A      -       -           -
LGA    T   374_A      S     297           #
LGA    R   375_A      I     298           #
LGA    T   376_A      F     299          3.849
LGA    S   377_A      V     300          2.928
LGA    T   378_A      A     301          2.690
LGA    L   379_A      G     302          2.417
LGA    V   380_A      -       -           -
LGA    D   381_A      R     303          3.642
LGA    Y   382_A      G     304           -
LGA    G   383_A      -       -           -
LGA    K   384_A      -       -           -
LGA    V   385_A      -       -           -
LGA    G   386_A      -       -           -
LGA    G   387_A      -       -           -
LGA    Y   388_A      -       -           -
LGA    S   389_A      -       -           -
LGA    S   390_A      A     305          4.548
LGA    M   391_A      G     306          2.372
LGA    A   392_A      K     307          2.353
LGA    A   393_A      E     308          2.940
LGA    T   394_A      E     309          2.969
LGA    V   395_A      T     310          2.217
LGA    G   396_A      A     311          1.803
LGA    Y   397_A      S     312          0.834
LGA    P   398_A      A     313          1.253
LGA    V   399_A      I     314          0.958
LGA    A   400_A      L     315          1.434
LGA    I   401_A      S     316          1.826
LGA    A   402_A      D     317          0.808
LGA    T   403_A      L     318          1.728
LGA    K   404_A      Y     319          3.223
LGA    F   405_A      E     320          2.857
LGA    V   406_A      I     321          2.092
LGA    L   407_A      Y     322          3.673
LGA    D   408_A      -       -           -
LGA    G   409_A      -       -           -
LGA    T   410_A      A     323          4.214
LGA    I   411_A      G     324           -
LGA    K   412_A      -       -           -
LGA    G   413_A      -       -           -
LGA    P   414_A      -       -           -
LGA    G   415_A      -       -           -
LGA    L   416_A      -       -           -
LGA    L   417_A      -       -           -
LGA    A   418_A      -       -           -
LGA    P   419_A      -       -           -
LGA    Y   420_A      -       -           -
LGA    S   421_A      -       -           -
LGA    P   422_A      -       -           -
LGA    E   423_A      -       -           -
LGA    I   424_A      -       -           -
LGA    N   425_A      -       -           -
LGA    D   426_A      -       -           -
LGA    P   427_A      -       -           -
LGA    I   428_A      -       -           -
LGA    M   429_A      -       -           -
LGA    K   430_A      -       -           -
LGA    E   431_A      -       -           -
LGA    L   432_A      -       -           -
LGA    K   433_A      -       -           -
LGA    D   434_A      -       -           -
LGA    K   435_A      -       -           -
LGA    Y   436_A      -       -           -
LGA    G   437_A      -       -           -
LGA    I   438_A      -       -           -
LGA    Y   439_A      -       -           -
LGA    L   440_A      -       -           -
LGA    K   441_A      -       -           -
LGA    E   442_A      -       -           -
LGA    K   443_A      -       -           -
LGA    T   444_A      -       -           -
LGA    V   445_A      -       -           -
LGA    A   446_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  445  320    5.0    164    2.96    14.02     29.932     5.356

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.379263 * X  +   0.912144 * Y  +  -0.155412 * Z  +  67.075615
  Y_new =  -0.009055 * X  +   0.164294 * Y  +   0.986370 * Z  +  18.741592
  Z_new =   0.925244 * X  +   0.375501 * Y  +  -0.054051 * Z  + -36.826111 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.713759   -1.427834  [ DEG:    98.1912    -81.8088 ]
  Theta =  -1.181679   -1.959913  [ DEG:   -67.7052   -112.2948 ]
  Phi   =  -3.117722    0.023870  [ DEG:  -178.6323      1.3677 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2axq_A                                        
REMARK     2: T0452.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2axq_A.T0452.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  445  320   5.0  164   2.96   14.02  29.932
REMARK  ---------------------------------------------------------- 
MOLECULE 2axq_A
HEADER    OXIDOREDUCTASE                          05-SEP-05   2AXQ              
TITLE     APO HISTIDINE-TAGGED SACCHAROPINE DEHYDROGENASE (L-GLU                
TITLE    2 FORMING) FROM SACCHAROMYCES CEREVISIAE                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SACCHAROPINE DEHYDROGENASE;                                
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: SACCHAROPINE REDUCTASE;                                     
COMPND   5 EC: 1.5.1.10;                                                        
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 OTHER_DETAILS: L-GLU FORMING                                         
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 GENE: LYS9, LYS13;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21-STAR(DE3)-RIL;                        
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET-16B-LYS9                              
KEYWDS    ROSSMANN FOLD VARIANT, SACCHAROPINE REDUCTASE FOLD (DOMAIN            
KEYWDS   2 II), ALPHA/BETA PROTEIN, ALPHA-AMINOADIPATE PATHWAY, FUNGAL          
KEYWDS   3 LYSINE BIOSYNTHESIS                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.ANDI,P.F.COOK,A.H.WEST                                              
REVDAT   2   22-AUG-06 2AXQ    1       JRNL                                     
REVDAT   1   15-AUG-06 2AXQ    0                                                
JRNL        AUTH   B.ANDI,P.F.COOK,A.H.WEST                                     
JRNL        TITL   CRYSTAL STRUCTURE OF THE HIS-TAGGED SACCHAROPINE             
JRNL        TITL 2 REDUCTASE FROM SACCHAROMYCES CEREVISIAE AT 1.7-A             
JRNL        TITL 3 RESOLUTION.                                                  
JRNL        REF    CELL BIOCHEM.BIOPHYS.         V.  46    17 2006              
JRNL        REFN                US ISSN 1085-9195                               
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  2AXQ A    1   446  UNP    P38999   LYS9_YEAST       1    446             
SEQRES   1 A  467  MET GLY HIS HIS HIS HIS HIS HIS HIS HIS HIS HIS SER          
SEQRES   2 A  467  SER GLY HIS ILE GLU GLY ARG HIS MET GLY LYS ASN VAL          
SEQRES   3 A  467  LEU LEU LEU GLY SER GLY PHE VAL ALA GLN PRO VAL ILE          
SEQRES   4 A  467  ASP THR LEU ALA ALA ASN ASP ASP ILE ASN VAL THR VAL          
SEQRES   5 A  467  ALA CYS ARG THR LEU ALA ASN ALA GLN ALA LEU ALA LYS          
SEQRES   6 A  467  PRO SER GLY SER LYS ALA ILE SER LEU ASP VAL THR ASP          
SEQRES   7 A  467  ASP SER ALA LEU ASP LYS VAL LEU ALA ASP ASN ASP VAL          
SEQRES   8 A  467  VAL ILE SER LEU ILE PRO TYR THR PHE HIS PRO ASN VAL          
SEQRES   9 A  467  VAL LYS SER ALA ILE ARG THR LYS THR ASP VAL VAL THR          
SEQRES  10 A  467  SER SER TYR ILE SER PRO ALA LEU ARG GLU LEU GLU PRO          
SEQRES  11 A  467  GLU ILE VAL LYS ALA GLY ILE THR VAL MET ASN GLU ILE          
SEQRES  12 A  467  GLY LEU ASP PRO GLY ILE ASP HIS LEU TYR ALA VAL LYS          
SEQRES  13 A  467  THR ILE ASP GLU VAL HIS ARG ALA GLY GLY LYS LEU LYS          
SEQRES  14 A  467  SER PHE LEU SER TYR CYS GLY GLY LEU PRO ALA PRO GLU          
SEQRES  15 A  467  ASP SER ASP ASN PRO LEU GLY TYR LYS PHE SER TRP SER          
SEQRES  16 A  467  SER ARG GLY VAL LEU LEU ALA LEU ARG ASN SER ALA LYS          
SEQRES  17 A  467  TYR TRP LYS ASP GLY LYS ILE GLU THR VAL SER SER GLU          
SEQRES  18 A  467  ASP LEU MET ALA THR ALA LYS PRO TYR PHE ILE TYR PRO          
SEQRES  19 A  467  GLY TYR ALA PHE VAL CYS TYR PRO ASN ARG ASP SER THR          
SEQRES  20 A  467  LEU PHE LYS ASP LEU TYR HIS ILE PRO GLU ALA GLU THR          
SEQRES  21 A  467  VAL ILE ARG GLY THR LEU ARG TYR GLN GLY PHE PRO GLU          
SEQRES  22 A  467  PHE VAL LYS ALA LEU VAL ASP MET GLY MET LEU LYS ASP          
SEQRES  23 A  467  ASP ALA ASN GLU ILE PHE SER LYS PRO ILE ALA TRP ASN          
SEQRES  24 A  467  GLU ALA LEU LYS GLN TYR LEU GLY ALA LYS SER THR SER          
SEQRES  25 A  467  LYS GLU ASP LEU ILE ALA SER ILE ASP SER LYS ALA THR          
SEQRES  26 A  467  TRP LYS ASP ASP GLU ASP ARG GLU ARG ILE LEU SER GLY          
SEQRES  27 A  467  PHE ALA TRP LEU GLY LEU PHE SER ASP ALA LYS ILE THR          
SEQRES  28 A  467  PRO ARG GLY ASN ALA LEU ASP THR LEU CYS ALA ARG LEU          
SEQRES  29 A  467  GLU GLU LEU MET GLN TYR GLU ASP ASN GLU ARG ASP MET          
SEQRES  30 A  467  VAL VAL LEU GLN HIS LYS PHE GLY ILE GLU TRP ALA ASP          
SEQRES  31 A  467  GLY THR THR GLU THR ARG THR SER THR LEU VAL ASP TYR          
SEQRES  32 A  467  GLY LYS VAL GLY GLY TYR SER SER MET ALA ALA THR VAL          
SEQRES  33 A  467  GLY TYR PRO VAL ALA ILE ALA THR LYS PHE VAL LEU ASP          
SEQRES  34 A  467  GLY THR ILE LYS GLY PRO GLY LEU LEU ALA PRO TYR SER          
SEQRES  35 A  467  PRO GLU ILE ASN ASP PRO ILE MET LYS GLU LEU LYS ASP          
SEQRES  36 A  467  LYS TYR GLY ILE TYR LEU LYS GLU LYS THR VAL ALA              
HET    SO4    501       5                                                       
HET    SO4    502       5                                                       
HET    SO4    503       5                                                       
HET    SO4    504       5                                                       
HETNAM     SO4 SULFATE ION                                                      
FORMUL   2  SO4    4(O4 S 2-)                                                   
FORMUL   6  HOH   *349(H2 O)                                                    
CRYST1   85.279   85.279  141.977  90.00  90.00 120.00 P 31 2 1      6          
ATOM      1  N   GLY A   2      51.014  14.708  13.472  1.00 45.60           N  
ATOM      2  CA  GLY A   2      50.051  13.905  12.658  1.00 42.87           C  
ATOM      3  C   GLY A   2      49.973  14.350  11.204  1.00 40.74           C  
ATOM      4  O   GLY A   2      50.949  14.835  10.632  1.00 42.49           O  
ATOM      5  N   LYS A   3      48.800  14.182  10.606  1.00 37.55           N  
ATOM      6  CA  LYS A   3      48.599  14.526   9.209  1.00 32.10           C  
ATOM      7  C   LYS A   3      47.978  15.888   9.098  1.00 26.01           C  
ATOM      8  O   LYS A   3      47.168  16.282   9.937  1.00 28.98           O  
ATOM      9  CB  LYS A   3      47.710  13.491   8.518  1.00 33.43           C  
ATOM     10  CG  LYS A   3      48.323  12.093   8.427  1.00 35.87           C  
ATOM     11  CD  LYS A   3      49.504  12.041   7.471  1.00 38.74           C  
ATOM     12  CE  LYS A   3      49.875  10.603   7.174  1.00 40.87           C  
ATOM     13  NZ  LYS A   3      50.706  10.493   5.923  1.00 45.54           N  
ATOM     14  N   ASN A   4      48.355  16.603   8.046  1.00 22.32           N  
ATOM     15  CA  ASN A   4      47.897  17.958   7.839  1.00 24.81           C  
ATOM     16  C   ASN A   4      46.874  18.004   6.689  1.00 24.03           C  
ATOM     17  O   ASN A   4      47.204  17.667   5.568  1.00 21.01           O  
ATOM     18  CB  ASN A   4      49.075  18.869   7.536  1.00 27.71           C  
ATOM     19  CG  ASN A   4      50.043  18.995   8.703  1.00 31.43           C  
ATOM     20  OD1 ASN A   4      51.259  18.926   8.520  1.00 33.66           O  
ATOM     21  ND2 ASN A   4      49.516  19.180   9.895  1.00 28.28           N  
ATOM     22  N   VAL A   5      45.641  18.422   6.996  1.00 20.77           N  
ATOM     23  CA  VAL A   5      44.563  18.479   6.010  1.00 22.55           C  
ATOM     24  C   VAL A   5      44.200  19.925   5.727  1.00 20.07           C  
ATOM     25  O   VAL A   5      43.937  20.691   6.661  1.00 22.89           O  
ATOM     26  CB  VAL A   5      43.296  17.723   6.518  1.00 21.63           C  
ATOM     27  CG1 VAL A   5      42.075  18.065   5.647  1.00 22.10           C  
ATOM     28  CG2 VAL A   5      43.554  16.250   6.515  1.00 23.68           C  
ATOM     29  N   LEU A   6      44.222  20.316   4.448  1.00 21.26           N  
ATOM     30  CA  LEU A   6      43.717  21.632   4.035  1.00 21.58           C  
ATOM     31  C   LEU A   6      42.298  21.482   3.475  1.00 23.18           C  
ATOM     32  O   LEU A   6      42.039  20.641   2.613  1.00 21.43           O  
ATOM     33  CB  LEU A   6      44.615  22.262   2.968  1.00 21.70           C  
ATOM     34  CG  LEU A   6      44.174  23.604   2.385  1.00 24.99           C  
ATOM     35  CD1 LEU A   6      44.256  24.756   3.474  1.00 23.73           C  
ATOM     36  CD2 LEU A   6      45.053  23.906   1.200  1.00 24.88           C  
ATOM     37  N   LEU A   7      41.386  22.306   3.971  1.00 21.03           N  
ATOM     38  CA  LEU A   7      40.040  22.315   3.426  1.00 24.08           C  
ATOM     39  C   LEU A   7      39.760  23.657   2.783  1.00 24.84           C  
ATOM     40  O   LEU A   7      39.842  24.700   3.442  1.00 24.47           O  
ATOM     41  CB  LEU A   7      39.016  21.991   4.523  1.00 27.47           C  
ATOM     42  CG  LEU A   7      37.592  21.869   3.966  1.00 30.72           C  
ATOM     43  CD1 LEU A   7      36.891  20.693   4.585  1.00 30.43           C  
ATOM     44  CD2 LEU A   7      36.813  23.174   4.170  1.00 32.30           C  
ATOM     45  N   LEU A   8      39.440  23.621   1.498  1.00 23.39           N  
ATOM     46  CA  LEU A   8      39.016  24.793   0.767  1.00 27.41           C  
ATOM     47  C   LEU A   8      37.492  24.785   0.699  1.00 32.28           C  
ATOM     48  O   LEU A   8      36.892  23.855   0.159  1.00 29.42           O  
ATOM     49  CB  LEU A   8      39.571  24.778  -0.645  1.00 30.48           C  
ATOM     50  CG  LEU A   8      41.044  24.533  -0.904  1.00 30.73           C  
ATOM     51  CD1 LEU A   8      41.298  24.734  -2.370  1.00 29.89           C  
ATOM     52  CD2 LEU A   8      41.854  25.514  -0.077  1.00 33.18           C  
ATOM     53  N   GLY A   9      36.862  25.827   1.229  1.00 35.25           N  
ATOM     54  CA  GLY A   9      35.417  25.897   1.153  1.00 42.61           C  
ATOM     55  C   GLY A   9      34.749  26.627   2.292  1.00 47.67           C  
ATOM     56  O   GLY A   9      35.226  26.613   3.439  1.00 46.12           O  
ATOM     57  N   SER A  10      33.646  27.286   1.947  1.00 51.85           N  
ATOM     58  CA  SER A  10      32.767  27.922   2.919  1.00 57.21           C  
ATOM     59  C   SER A  10      31.331  27.686   2.462  1.00 58.53           C  
ATOM     60  O   SER A  10      30.600  28.625   2.134  1.00 60.52           O  
ATOM     61  CB  SER A  10      33.062  29.423   3.041  1.00 56.78           C  
ATOM     62  OG  SER A  10      32.670  30.104   1.862  1.00 58.02           O  
ATOM     63  N   GLY A  11      30.964  26.412   2.389  1.00 58.75           N  
ATOM     64  CA  GLY A  11      29.586  26.002   2.191  1.00 56.88           C  
ATOM     65  C   GLY A  11      29.209  25.320   3.485  1.00 56.21           C  
ATOM     66  O   GLY A  11      30.077  25.107   4.340  1.00 53.81           O  
ATOM     67  N   PHE A  12      27.924  24.989   3.640  1.00 53.69           N  
ATOM     68  CA  PHE A  12      27.456  24.253   4.817  1.00 51.34           C  
ATOM     69  C   PHE A  12      28.079  22.854   4.824  1.00 44.83           C  
ATOM     70  O   PHE A  12      28.180  22.235   5.872  1.00 43.41           O  
ATOM     71  CB  PHE A  12      25.917  24.143   4.845  1.00 57.17           C  
ATOM     72  CG  PHE A  12      25.225  25.097   5.816  0.90 59.67           C  
ATOM     73  CD1 PHE A  12      24.283  26.027   5.351  0.90 60.28           C  
ATOM     74  CD2 PHE A  12      25.473  25.034   7.197  0.90 60.56           C  
ATOM     75  CE1 PHE A  12      23.618  26.901   6.248  0.90 60.71           C  
ATOM     76  CE2 PHE A  12      24.811  25.902   8.103  0.90 60.69           C  
ATOM     77  CZ  PHE A  12      23.884  26.835   7.625  0.90 60.18           C  
ATOM     78  N   VAL A  13      28.508  22.370   3.659  1.00 40.45           N  
ATOM     79  CA  VAL A  13      29.184  21.071   3.573  1.00 36.63           C  
ATOM     80  C   VAL A  13      30.508  21.063   4.320  1.00 33.12           C  
ATOM     81  O   VAL A  13      30.911  20.048   4.894  1.00 28.45           O  
ATOM     82  CB  VAL A  13      29.437  20.616   2.118  1.00 39.20           C  
ATOM     83  CG1 VAL A  13      30.044  19.229   2.109  1.00 40.77           C  
ATOM     84  CG2 VAL A  13      28.157  20.608   1.320  1.00 42.91           C  
ATOM     85  N   ALA A  14      31.181  22.212   4.346  1.00 29.53           N  
ATOM     86  CA  ALA A  14      32.457  22.306   5.045  1.00 26.41           C  
ATOM     87  C   ALA A  14      32.391  21.951   6.536  1.00 25.75           C  
ATOM     88  O   ALA A  14      33.289  21.314   7.037  1.00 22.99           O  
ATOM     89  CB  ALA A  14      33.067  23.692   4.838  1.00 27.67           C  
ATOM     90  N   GLN A  15      31.308  22.317   7.234  1.00 26.60           N  
ATOM     91  CA  GLN A  15      31.280  22.156   8.682  1.00 24.56           C  
ATOM     92  C   GLN A  15      31.436  20.724   9.187  1.00 23.21           C  
ATOM     93  O   GLN A  15      32.298  20.474  10.025  1.00 26.94           O  
ATOM     94  CB  GLN A  15      30.058  22.820   9.326  1.00 28.16           C  
ATOM     95  CG  GLN A  15      30.295  23.132  10.813  1.00 31.65           C  
ATOM     96  CD  GLN A  15      31.203  24.352  11.003  1.00 33.35           C  
ATOM     97  OE1 GLN A  15      30.849  25.457  10.597  1.00 37.57           O  
ATOM     98  NE2 GLN A  15      32.364  24.151  11.600  1.00 32.66           N  
ATOM     99  N   PRO A  16      30.607  19.777   8.703  1.00 23.27           N  
ATOM    100  CA  PRO A  16      30.844  18.428   9.240  1.00 21.19           C  
ATOM    101  C   PRO A  16      32.219  17.832   8.903  1.00 20.85           C  
ATOM    102  O   PRO A  16      32.705  16.969   9.641  1.00 23.07           O  
ATOM    103  CB  PRO A  16      29.753  17.570   8.575  1.00 22.51           C  
ATOM    104  CG  PRO A  16      29.238  18.361   7.375  1.00 19.87           C  
ATOM    105  CD  PRO A  16      29.475  19.827   7.744  1.00 21.34           C  
ATOM    106  N   VAL A  17      32.793  18.217   7.769  1.00 21.93           N  
ATOM    107  CA  VAL A  17      34.113  17.677   7.343  1.00 20.95           C  
ATOM    108  C   VAL A  17      35.191  18.174   8.307  1.00 23.24           C  
ATOM    109  O   VAL A  17      35.926  17.382   8.884  1.00 23.29           O  
ATOM    110  CB  VAL A  17      34.470  18.126   5.898  1.00 20.98           C  
ATOM    111  CG1 VAL A  17      35.803  17.563   5.462  1.00 23.10           C  
ATOM    112  CG2 VAL A  17      33.388  17.702   4.933  1.00 21.32           C  
ATOM    113  N   ILE A  18      35.259  19.494   8.494  1.00 23.97           N  
ATOM    114  CA  ILE A  18      36.197  20.080   9.460  1.00 25.75           C  
ATOM    115  C   ILE A  18      35.986  19.412  10.810  1.00 25.81           C  
ATOM    116  O   ILE A  18      36.922  18.865  11.406  1.00 24.75           O  
ATOM    117  CB  ILE A  18      35.991  21.631   9.565  1.00 28.32           C  
ATOM    118  CG1 ILE A  18      36.239  22.304   8.205  1.00 28.82           C  
ATOM    119  CG2 ILE A  18      36.900  22.258  10.650  1.00 29.65           C  
ATOM    120  CD1 ILE A  18      35.440  23.657   7.990  1.00 30.86           C  
ATOM    121  N   ASP A  19      34.737  19.401  11.287  1.00 26.00           N  
ATOM    122  CA  ASP A  19      34.462  18.903  12.629  1.00 28.84           C  
ATOM    123  C   ASP A  19      34.786  17.428  12.853  1.00 28.29           C  
ATOM    124  O   ASP A  19      35.330  17.061  13.898  1.00 30.22           O  
ATOM    125  CB  ASP A  19      33.006  19.189  13.027  1.00 32.68           C  
ATOM    126  CG  ASP A  19      32.669  20.677  13.030  1.00 34.82           C  
ATOM    127  OD1 ASP A  19      31.467  20.980  13.015  1.00 33.91           O  
ATOM    128  OD2 ASP A  19      33.578  21.550  13.053  1.00 36.63           O  
ATOM    129  N   THR A  20      34.453  16.564  11.895  1.00 25.76           N  
ATOM    130  CA  THR A  20      34.744  15.141  12.093  1.00 24.11           C  
ATOM    131  C   THR A  20      36.251  14.848  11.972  1.00 24.05           C  
ATOM    132  O   THR A  20      36.769  13.976  12.676  1.00 26.32           O  
ATOM    133  CB  THR A  20      33.904  14.218  11.168  1.00 22.14           C  
ATOM    134  OG1 THR A  20      34.016  12.858  11.630  1.00 26.52           O  
ATOM    135  CG2 THR A  20      34.368  14.309   9.711  1.00 20.88           C  
ATOM    136  N   LEU A  21      36.948  15.586  11.098  1.00 23.32           N  
ATOM    137  CA  LEU A  21      38.390  15.364  10.909  1.00 24.45           C  
ATOM    138  C   LEU A  21      39.184  15.956  12.077  1.00 24.95           C  
ATOM    139  O   LEU A  21      40.096  15.312  12.590  1.00 26.51           O  
ATOM    140  CB  LEU A  21      38.874  15.943   9.581  1.00 21.64           C  
ATOM    141  CG  LEU A  21      38.428  15.228   8.283  1.00 22.85           C  
ATOM    142  CD1 LEU A  21      38.917  15.997   7.037  1.00 19.31           C  
ATOM    143  CD2 LEU A  21      38.913  13.792   8.195  1.00 20.93           C  
ATOM    144  N   ALA A  22      38.830  17.175  12.490  1.00 29.02           N  
ATOM    145  CA  ALA A  22      39.544  17.858  13.589  1.00 28.17           C  
ATOM    146  C   ALA A  22      39.413  17.142  14.946  1.00 33.17           C  
ATOM    147  O   ALA A  22      40.304  17.250  15.806  1.00 33.58           O  
ATOM    148  CB  ALA A  22      39.107  19.299  13.687  1.00 27.03           C  
ATOM    149  N   ALA A  23      38.323  16.378  15.107  1.00 32.98           N  
ATOM    150  CA  ALA A  23      38.103  15.512  16.261  1.00 35.34           C  
ATOM    151  C   ALA A  23      39.161  14.414  16.394  1.00 35.71           C  
ATOM    152  O   ALA A  23      39.397  13.898  17.485  1.00 38.85           O  
ATOM    153  CB  ALA A  23      36.690  14.901  16.210  1.00 35.34           C  
ATOM    154  N   ASN A  24      39.797  14.061  15.283  1.00 36.58           N  
ATOM    155  CA  ASN A  24      40.897  13.109  15.288  1.00 38.23           C  
ATOM    156  C   ASN A  24      42.177  13.790  15.812  1.00 40.03           C  
ATOM    157  O   ASN A  24      42.574  14.839  15.320  1.00 35.99           O  
ATOM    158  CB  ASN A  24      41.096  12.557  13.873  1.00 35.52           C  
ATOM    159  CG  ASN A  24      42.061  11.392  13.812  1.00 39.57           C  
ATOM    160  OD1 ASN A  24      43.113  11.389  14.461  1.00 39.05           O  
ATOM    161  ND2 ASN A  24      41.723  10.392  12.993  1.00 38.02           N  
ATOM    162  N   ASP A  25      42.812  13.187  16.814  1.00 44.35           N  
ATOM    163  CA  ASP A  25      43.993  13.800  17.442  1.00 47.79           C  
ATOM    164  C   ASP A  25      45.168  13.916  16.488  1.00 46.25           C  
ATOM    165  O   ASP A  25      45.935  14.875  16.574  1.00 47.81           O  
ATOM    166  CB  ASP A  25      44.398  13.048  18.708  1.00 51.62           C  
ATOM    167  CG  ASP A  25      43.498  13.377  19.895  1.00 54.81           C  
ATOM    168  OD1 ASP A  25      42.623  14.268  19.771  1.00 55.68           O  
ATOM    169  OD2 ASP A  25      43.664  12.742  20.958  1.00 56.00           O  
ATOM    170  N   ASP A  26      45.275  12.964  15.562  1.00 44.72           N  
ATOM    171  CA  ASP A  26      46.386  12.925  14.601  1.00 43.33           C  
ATOM    172  C   ASP A  26      46.092  13.590  13.261  1.00 38.97           C  
ATOM    173  O   ASP A  26      46.741  13.279  12.264  1.00 39.15           O  
ATOM    174  CB  ASP A  26      46.820  11.484  14.352  1.00 47.48           C  
ATOM    175  CG  ASP A  26      47.319  10.807  15.615  1.00 52.49           C  
ATOM    176  OD1 ASP A  26      47.858  11.526  16.496  1.00 53.54           O  
ATOM    177  OD2 ASP A  26      47.170   9.563  15.726  1.00 53.23           O  
ATOM    178  N   ILE A  27      45.104  14.480  13.234  1.00 33.30           N  
ATOM    179  CA  ILE A  27      44.817  15.251  12.017  1.00 29.44           C  
ATOM    180  C   ILE A  27      44.735  16.710  12.393  1.00 30.05           C  
ATOM    181  O   ILE A  27      44.020  17.083  13.335  1.00 31.03           O  
ATOM    182  CB  ILE A  27      43.506  14.800  11.322  1.00 27.63           C  
ATOM    183  CG1 ILE A  27      43.596  13.337  10.858  1.00 28.87           C  
ATOM    184  CG2 ILE A  27      43.207  15.694  10.134  1.00 26.92           C  
ATOM    185  CD1 ILE A  27      42.254  12.735  10.313  1.00 29.36           C  
ATOM    186  N   ASN A  28      45.471  17.536  11.654  1.00 29.69           N  
ATOM    187  CA  ASN A  28      45.476  18.973  11.862  1.00 29.22           C  
ATOM    188  C   ASN A  28      44.824  19.626  10.660  1.00 26.81           C  
ATOM    189  O   ASN A  28      45.349  19.559   9.547  1.00 24.39           O  
ATOM    190  CB  ASN A  28      46.917  19.479  12.052  1.00 34.36           C  
ATOM    191  CG  ASN A  28      47.700  18.631  13.049  1.00 38.77           C  
ATOM    192  OD1 ASN A  28      48.685  17.968  12.694  1.00 42.14           O  
ATOM    193  ND2 ASN A  28      47.241  18.618  14.297  1.00 38.93           N  
ATOM    194  N   VAL A  29      43.664  20.225  10.878  1.00 24.93           N  
ATOM    195  CA  VAL A  29      42.921  20.842   9.801  1.00 25.15           C  
ATOM    196  C   VAL A  29      43.212  22.313   9.726  1.00 25.00           C  
ATOM    197  O   VAL A  29      43.261  22.988  10.738  1.00 26.43           O  
ATOM    198  CB  VAL A  29      41.355  20.661   9.925  1.00 26.10           C  
ATOM    199  CG1 VAL A  29      40.620  21.386   8.787  1.00 23.31           C  
ATOM    200  CG2 VAL A  29      40.991  19.190   9.958  1.00 22.86           C  
ATOM    201  N   THR A  30      43.400  22.773   8.500  1.00 23.62           N  
ATOM    202  CA  THR A  30      43.453  24.165   8.187  1.00 25.23           C  
ATOM    203  C   THR A  30      42.294  24.452   7.256  1.00 24.49           C  
ATOM    204  O   THR A  30      42.151  23.825   6.197  1.00 23.31           O  
ATOM    205  CB  THR A  30      44.800  24.550   7.526  1.00 22.98           C  
ATOM    206  OG1 THR A  30      45.862  24.179   8.403  1.00 24.65           O  
ATOM    207  CG2 THR A  30      44.860  26.026   7.242  1.00 25.97           C  
ATOM    208  N   VAL A  31      41.463  25.410   7.669  1.00 23.64           N  
ATOM    209  CA  VAL A  31      40.395  25.935   6.824  1.00 24.05           C  
ATOM    210  C   VAL A  31      40.818  27.187   6.086  1.00 27.22           C  
ATOM    211  O   VAL A  31      41.356  28.142   6.691  1.00 27.46           O  
ATOM    212  CB  VAL A  31      39.152  26.291   7.665  1.00 23.42           C  
ATOM    213  CG1 VAL A  31      37.983  26.653   6.764  1.00 27.38           C  
ATOM    214  CG2 VAL A  31      38.833  25.152   8.622  1.00 27.16           C  
ATOM    215  N   ALA A  32      40.575  27.171   4.781  1.00 23.05           N  
ATOM    216  CA  ALA A  32      40.904  28.271   3.884  1.00 28.69           C  
ATOM    217  C   ALA A  32      39.668  28.739   3.125  1.00 30.96           C  
ATOM    218  O   ALA A  32      39.014  27.959   2.428  1.00 32.77           O  
ATOM    219  CB  ALA A  32      42.006  27.841   2.900  1.00 25.90           C  
ATOM    220  N   CYS A  33      39.331  30.012   3.308  1.00 32.51           N  
ATOM    221  CA  CYS A  33      38.288  30.679   2.543  1.00 35.57           C  
ATOM    222  C   CYS A  33      38.895  32.008   2.089  1.00 37.28           C  
ATOM    223  O   CYS A  33      39.959  32.403   2.578  1.00 37.80           O  
ATOM    224  CB  CYS A  33      37.050  30.959   3.427  1.00 37.74           C  
ATOM    225  SG  CYS A  33      36.595  29.669   4.642  1.00 37.71           S  
ATOM    226  N   ARG A  34      38.218  32.701   1.185  1.00 38.11           N  
ATOM    227  CA  ARG A  34      38.620  34.063   0.826  1.00 42.57           C  
ATOM    228  C   ARG A  34      38.852  34.996   2.032  1.00 42.73           C  
ATOM    229  O   ARG A  34      39.838  35.749   2.029  1.00 40.37           O  
ATOM    230  CB  ARG A  34      37.634  34.708  -0.140  1.00 44.48           C  
ATOM    231  CG  ARG A  34      37.070  33.761  -1.180  1.00 50.29           C  
ATOM    232  CD  ARG A  34      36.964  34.418  -2.542  1.00 52.66           C  
ATOM    233  NE  ARG A  34      36.708  35.854  -2.451  1.00 58.06           N  
ATOM    234  CZ  ARG A  34      36.041  36.565  -3.361  1.00 60.12           C  
ATOM    235  NH1 ARG A  34      35.536  35.970  -4.445  1.00 61.30           N  
ATOM    236  NH2 ARG A  34      35.864  37.876  -3.183  1.00 61.34           N  
ATOM    237  N   THR A  35      37.985  34.941   3.055  1.00 38.38           N  
ATOM    238  CA  THR A  35      38.105  35.856   4.194  1.00 37.79           C  
ATOM    239  C   THR A  35      38.515  35.146   5.495  1.00 38.69           C  
ATOM    240  O   THR A  35      37.878  34.173   5.915  1.00 39.60           O  
ATOM    241  CB  THR A  35      36.779  36.640   4.408  1.00 41.46           C  
ATOM    242  OG1 THR A  35      36.135  36.855   3.139  1.00 40.96           O  
ATOM    243  CG2 THR A  35      37.032  37.988   5.097  1.00 42.39           C  
ATOM    244  N   LEU A  36      39.561  35.642   6.147  1.00 36.52           N  
ATOM    245  CA  LEU A  36      40.044  35.008   7.395  1.00 36.72           C  
ATOM    246  C   LEU A  36      38.917  34.708   8.421  1.00 40.35           C  
ATOM    247  O   LEU A  36      38.935  33.663   9.119  1.00 36.67           O  
ATOM    248  CB  LEU A  36      41.139  35.865   8.042  1.00 35.34           C  
ATOM    249  CG  LEU A  36      41.763  35.344   9.348  1.00 35.42           C  
ATOM    250  CD1 LEU A  36      42.394  33.939   9.208  1.00 35.72           C  
ATOM    251  CD2 LEU A  36      42.792  36.349   9.894  1.00 35.47           C  
ATOM    252  N   ALA A  37      37.957  35.629   8.527  1.00 41.95           N  
ATOM    253  CA  ALA A  37      36.900  35.520   9.545  1.00 41.18           C  
ATOM    254  C   ALA A  37      35.992  34.292   9.311  1.00 41.10           C  
ATOM    255  O   ALA A  37      35.761  33.541  10.259  1.00 36.50           O  
ATOM    256  CB  ALA A  37      36.093  36.823   9.659  1.00 41.70           C  
ATOM    257  N   ASN A  38      35.520  34.083   8.062  1.00 40.34           N  
ATOM    258  CA  ASN A  38      34.830  32.836   7.655  1.00 41.60           C  
ATOM    259  C   ASN A  38      35.542  31.590   8.127  1.00 41.03           C  
ATOM    260  O   ASN A  38      34.938  30.708   8.730  1.00 44.64           O  
ATOM    261  CB  ASN A  38      34.778  32.678   6.138  1.00 42.44           C  
ATOM    262  CG  ASN A  38      34.005  33.741   5.477  1.00 44.61           C  
ATOM    263  OD1 ASN A  38      33.442  34.606   6.132  1.00 48.94           O  
ATOM    264  ND2 ASN A  38      33.950  33.692   4.153  1.00 47.80           N  
ATOM    265  N   ALA A  39      36.827  31.508   7.787  1.00 34.28           N  
ATOM    266  CA  ALA A  39      37.619  30.356   8.090  1.00 32.73           C  
ATOM    267  C   ALA A  39      37.770  30.250   9.609  1.00 34.51           C  
ATOM    268  O   ALA A  39      37.708  29.151  10.166  1.00 36.59           O  
ATOM    269  CB  ALA A  39      38.990  30.459   7.380  1.00 29.81           C  
ATOM    270  N   GLN A  40      37.935  31.391  10.293  1.00 34.57           N  
ATOM    271  CA  GLN A  40      38.097  31.355  11.765  1.00 35.94           C  
ATOM    272  C   GLN A  40      36.799  30.888  12.413  1.00 36.96           C  
ATOM    273  O   GLN A  40      36.831  30.245  13.460  1.00 37.64           O  
ATOM    274  CB  GLN A  40      38.566  32.706  12.340  1.00 36.66           C  
ATOM    275  CG  GLN A  40      40.080  32.927  12.191  1.00 36.76           C  
ATOM    276  CD  GLN A  40      40.580  34.268  12.752  1.00 38.40           C  
ATOM    277  OE1 GLN A  40      39.799  35.192  13.001  1.00 35.58           O  
ATOM    278  NE2 GLN A  40      41.903  34.377  12.922  1.00 38.49           N  
ATOM    279  N   ALA A  41      35.682  31.192  11.749  1.00 33.69           N  
ATOM    280  CA  ALA A  41      34.343  30.835  12.217  1.00 39.88           C  
ATOM    281  C   ALA A  41      34.046  29.356  11.972  1.00 38.87           C  
ATOM    282  O   ALA A  41      33.575  28.653  12.879  1.00 42.41           O  
ATOM    283  CB  ALA A  41      33.281  31.708  11.529  1.00 37.25           C  
ATOM    284  N   LEU A  42      34.311  28.902  10.745  1.00 38.78           N  
ATOM    285  CA  LEU A  42      34.258  27.479  10.403  1.00 34.92           C  
ATOM    286  C   LEU A  42      35.209  26.670  11.253  1.00 35.36           C  
ATOM    287  O   LEU A  42      34.883  25.560  11.669  1.00 37.05           O  
ATOM    288  CB  LEU A  42      34.548  27.277   8.924  1.00 35.14           C  
ATOM    289  CG  LEU A  42      33.433  27.535   7.926  1.00 34.54           C  
ATOM    290  CD1 LEU A  42      33.941  27.439   6.520  1.00 34.19           C  
ATOM    291  CD2 LEU A  42      32.313  26.518   8.146  1.00 37.10           C  
ATOM    292  N   ALA A  43      36.374  27.242  11.554  1.00 34.21           N  
ATOM    293  CA  ALA A  43      37.386  26.552  12.355  1.00 35.10           C  
ATOM    294  C   ALA A  43      37.149  26.644  13.868  1.00 34.77           C  
ATOM    295  O   ALA A  43      37.638  25.806  14.628  1.00 36.31           O  
ATOM    296  CB  ALA A  43      38.811  27.079  11.995  1.00 33.16           C  
ATOM    297  N   LYS A  44      36.406  27.673  14.290  1.00 39.76           N  
ATOM    298  CA  LYS A  44      36.211  27.999  15.706  1.00 42.62           C  
ATOM    299  C   LYS A  44      35.706  26.836  16.562  1.00 40.05           C  
ATOM    300  O   LYS A  44      36.324  26.539  17.578  1.00 42.56           O  
ATOM    301  CB  LYS A  44      35.308  29.231  15.868  1.00 45.23           C  
ATOM    302  CG  LYS A  44      35.214  29.727  17.307  1.00 49.13           C  
ATOM    303  CD  LYS A  44      34.209  30.878  17.459  1.00 49.60           C  
ATOM    304  CE  LYS A  44      34.106  31.297  18.940  1.00 51.27           C  
ATOM    305  NZ  LYS A  44      33.049  32.336  19.164  1.00 52.91           N  
ATOM    306  N   PRO A  45      34.603  26.161  16.152  1.00 39.87           N  
ATOM    307  CA  PRO A  45      34.091  25.038  16.947  1.00 38.95           C  
ATOM    308  C   PRO A  45      35.150  24.007  17.306  1.00 38.58           C  
ATOM    309  O   PRO A  45      35.193  23.527  18.440  1.00 39.37           O  
ATOM    310  CB  PRO A  45      33.024  24.421  16.040  1.00 40.01           C  
ATOM    311  CG  PRO A  45      32.567  25.531  15.181  1.00 39.80           C  
ATOM    312  CD  PRO A  45      33.759  26.418  14.967  1.00 39.37           C  
ATOM    313  N   SER A  46      36.025  23.680  16.360  1.00 39.89           N  
ATOM    314  CA  SER A  46      37.050  22.677  16.614  1.00 39.95           C  
ATOM    315  C   SER A  46      38.406  23.261  16.974  1.00 39.94           C  
ATOM    316  O   SER A  46      39.344  22.520  17.233  1.00 41.57           O  
ATOM    317  CB  SER A  46      37.215  21.779  15.391  1.00 41.12           C  
ATOM    318  OG  SER A  46      37.676  22.533  14.290  1.00 37.99           O  
ATOM    319  N   GLY A  47      38.523  24.580  16.977  1.00 42.49           N  
ATOM    320  CA  GLY A  47      39.822  25.207  17.239  1.00 45.92           C  
ATOM    321  C   GLY A  47      40.857  24.841  16.181  1.00 46.45           C  
ATOM    322  O   GLY A  47      42.033  24.589  16.495  1.00 46.82           O  
ATOM    323  N   SER A  48      40.419  24.801  14.927  1.00 43.98           N  
ATOM    324  CA  SER A  48      41.317  24.478  13.830  1.00 41.93           C  
ATOM    325  C   SER A  48      42.069  25.716  13.400  1.00 40.28           C  
ATOM    326  O   SER A  48      41.643  26.844  13.655  1.00 41.93           O  
ATOM    327  CB  SER A  48      40.551  23.866  12.651  1.00 39.55           C  
ATOM    328  OG  SER A  48      40.285  22.498  12.926  1.00 39.97           O  
ATOM    329  N   LYS A  49      43.194  25.497  12.736  1.00 37.30           N  
ATOM    330  CA  LYS A  49      43.887  26.583  12.073  1.00 35.81           C  
ATOM    331  C   LYS A  49      42.978  27.125  10.965  1.00 33.40           C  
ATOM    332  O   LYS A  49      42.136  26.413  10.423  1.00 32.64           O  
ATOM    333  CB  LYS A  49      45.236  26.089  11.567  1.00 34.51           C  
ATOM    334  CG  LYS A  49      46.098  27.121  10.902  1.00 38.11           C  
ATOM    335  CD  LYS A  49      47.389  26.475  10.395  1.00 40.26           C  
ATOM    336  CE  LYS A  49      48.250  25.910  11.530  1.00 41.25           C  
ATOM    337  NZ  LYS A  49      49.591  25.460  11.029  1.00 43.85           N  
ATOM    338  N   ALA A  50      43.128  28.410  10.664  1.00 32.87           N  
ATOM    339  CA  ALA A  50      42.254  29.127   9.745  1.00 30.91           C  
ATOM    340  C   ALA A  50      43.078  30.181   9.046  1.00 32.71           C  
ATOM    341  O   ALA A  50      43.913  30.855   9.688  1.00 33.33           O  
ATOM    342  CB  ALA A  50      41.129  29.791  10.518  1.00 32.87           C  
ATOM    343  N   ILE A  51      42.878  30.327   7.739  1.00 32.55           N  
ATOM    344  CA  ILE A  51      43.648  31.301   6.947  1.00 33.15           C  
ATOM    345  C   ILE A  51      42.739  31.841   5.893  1.00 28.57           C  
ATOM    346  O   ILE A  51      41.693  31.260   5.647  1.00 32.62           O  
ATOM    347  CB  ILE A  51      44.905  30.697   6.223  1.00 29.90           C  
ATOM    348  CG1 ILE A  51      44.481  29.714   5.098  1.00 32.96           C  
ATOM    349  CG2 ILE A  51      45.857  30.042   7.210  1.00 30.24           C  
ATOM    350  CD1 ILE A  51      45.616  29.291   4.192  1.00 32.33           C  
ATOM    351  N   SER A  52      43.140  32.943   5.261  1.00 29.82           N  
ATOM    352  CA  SER A  52      42.476  33.442   4.047  1.00 26.81           C  
ATOM    353  C   SER A  52      43.266  32.950   2.854  1.00 32.64           C  
ATOM    354  O   SER A  52      44.467  32.694   2.982  1.00 35.12           O  
ATOM    355  CB  SER A  52      42.450  34.968   4.006  1.00 36.28           C  
ATOM    356  OG  SER A  52      43.743  35.499   4.253  1.00 38.56           O  
ATOM    357  N   LEU A  53      42.610  32.841   1.701  1.00 30.42           N  
ATOM    358  CA  LEU A  53      43.242  32.295   0.499  1.00 31.79           C  
ATOM    359  C   LEU A  53      42.488  32.578  -0.779  1.00 31.38           C  
ATOM    360  O   LEU A  53      41.317  32.266  -0.911  1.00 35.03           O  
ATOM    361  CB  LEU A  53      43.446  30.765   0.599  1.00 30.97           C  
ATOM    362  CG  LEU A  53      44.020  30.084  -0.661  1.00 30.31           C  
ATOM    363  CD1 LEU A  53      45.502  30.411  -0.835  1.00 30.84           C  
ATOM    364  CD2 LEU A  53      43.856  28.574  -0.626  1.00 28.76           C  
ATOM    365  N   ASP A  54      43.199  33.135  -1.747  1.00 31.52           N  
ATOM    366  CA  ASP A  54      42.685  33.348  -3.070  1.00 30.05           C  
ATOM    367  C   ASP A  54      43.163  32.202  -3.949  1.00 32.77           C  
ATOM    368  O   ASP A  54      44.349  32.115  -4.225  1.00 31.52           O  
ATOM    369  CB  ASP A  54      43.225  34.687  -3.592  1.00 34.28           C  
ATOM    370  CG  ASP A  54      42.774  34.991  -4.990  1.00 33.64           C  
ATOM    371  OD1 ASP A  54      41.969  34.224  -5.555  1.00 38.57           O  
ATOM    372  OD2 ASP A  54      43.230  36.006  -5.540  1.00 38.15           O  
ATOM    373  N   VAL A  55      42.258  31.331  -4.400  1.00 31.74           N  
ATOM    374  CA  VAL A  55      42.680  30.138  -5.169  1.00 33.13           C  
ATOM    375  C   VAL A  55      43.212  30.453  -6.565  1.00 36.50           C  
ATOM    376  O   VAL A  55      43.885  29.613  -7.168  1.00 39.59           O  
ATOM    377  CB  VAL A  55      41.591  29.009  -5.246  1.00 34.97           C  
ATOM    378  CG1 VAL A  55      41.136  28.629  -3.856  1.00 35.95           C  
ATOM    379  CG2 VAL A  55      40.394  29.422  -6.138  1.00 35.96           C  
ATOM    380  N   THR A  56      42.913  31.645  -7.082  1.00 35.06           N  
ATOM    381  CA  THR A  56      43.438  32.064  -8.386  1.00 34.80           C  
ATOM    382  C   THR A  56      44.884  32.570  -8.309  1.00 32.33           C  
ATOM    383  O   THR A  56      45.527  32.758  -9.330  1.00 37.75           O  
ATOM    384  CB  THR A  56      42.586  33.167  -9.042  1.00 34.90           C  
ATOM    385  OG1 THR A  56      42.492  34.270  -8.138  1.00 34.74           O  
ATOM    386  CG2 THR A  56      41.186  32.648  -9.379  1.00 35.71           C  
ATOM    387  N   ASP A  57      45.391  32.777  -7.101  1.00 32.50           N  
ATOM    388  CA  ASP A  57      46.769  33.209  -6.909  1.00 29.64           C  
ATOM    389  C   ASP A  57      47.617  31.944  -6.804  1.00 28.87           C  
ATOM    390  O   ASP A  57      47.683  31.335  -5.726  1.00 28.35           O  
ATOM    391  CB  ASP A  57      46.851  34.056  -5.635  1.00 31.12           C  
ATOM    392  CG  ASP A  57      48.241  34.574  -5.351  1.00 32.28           C  
ATOM    393  OD1 ASP A  57      49.241  33.985  -5.831  1.00 32.96           O  
ATOM    394  OD2 ASP A  57      48.337  35.565  -4.607  1.00 32.19           O  
ATOM    395  N   ASP A  58      48.230  31.538  -7.921  1.00 28.85           N  
ATOM    396  CA  ASP A  58      49.124  30.354  -7.972  1.00 28.92           C  
ATOM    397  C   ASP A  58      50.149  30.251  -6.837  1.00 30.18           C  
ATOM    398  O   ASP A  58      50.300  29.187  -6.234  1.00 28.05           O  
ATOM    399  CB  ASP A  58      49.867  30.297  -9.315  1.00 31.28           C  
ATOM    400  CG  ASP A  58      48.951  29.962 -10.477  1.00 36.37           C  
ATOM    401  OD1 ASP A  58      47.722  30.085 -10.315  1.00 37.96           O  
ATOM    402  OD2 ASP A  58      49.455  29.570 -11.556  1.00 38.75           O  
ATOM    403  N   SER A  59      50.857  31.347  -6.539  1.00 28.45           N  
ATOM    404  CA  SER A  59      51.848  31.328  -5.458  1.00 26.14           C  
ATOM    405  C   SER A  59      51.211  31.130  -4.081  1.00 22.55           C  
ATOM    406  O   SER A  59      51.755  30.442  -3.233  1.00 24.71           O  
ATOM    407  CB  SER A  59      52.686  32.628  -5.450  1.00 28.34           C  
ATOM    408  OG  SER A  59      53.126  32.957  -6.767  1.00 34.75           O  
ATOM    409  N   ALA A  60      50.073  31.789  -3.832  1.00 22.29           N  
ATOM    410  CA  ALA A  60      49.436  31.675  -2.501  1.00 24.02           C  
ATOM    411  C   ALA A  60      48.953  30.241  -2.327  1.00 21.35           C  
ATOM    412  O   ALA A  60      49.062  29.667  -1.237  1.00 22.21           O  
ATOM    413  CB  ALA A  60      48.243  32.639  -2.354  1.00 23.40           C  
ATOM    414  N   LEU A  61      48.442  29.686  -3.423  1.00 22.33           N  
ATOM    415  CA  LEU A  61      47.860  28.355  -3.427  1.00 19.99           C  
ATOM    416  C   LEU A  61      48.965  27.316  -3.221  1.00 19.78           C  
ATOM    417  O   LEU A  61      48.839  26.447  -2.377  1.00 21.30           O  
ATOM    418  CB  LEU A  61      47.128  28.108  -4.732  1.00 24.06           C  
ATOM    419  CG  LEU A  61      46.187  26.900  -4.875  1.00 26.52           C  
ATOM    420  CD1 LEU A  61      45.144  26.848  -3.749  1.00 26.10           C  
ATOM    421  CD2 LEU A  61      45.515  26.971  -6.251  1.00 24.30           C  
ATOM    422  N   ASP A  62      50.069  27.446  -3.953  1.00 20.98           N  
ATOM    423  CA  ASP A  62      51.203  26.518  -3.728  1.00 22.03           C  
ATOM    424  C   ASP A  62      51.706  26.565  -2.296  1.00 22.34           C  
ATOM    425  O   ASP A  62      52.020  25.512  -1.687  1.00 21.85           O  
ATOM    426  CB  ASP A  62      52.363  26.853  -4.659  1.00 21.05           C  
ATOM    427  CG  ASP A  62      52.131  26.415  -6.102  1.00 24.82           C  
ATOM    428  OD1 ASP A  62      51.000  25.999  -6.496  1.00 22.23           O  
ATOM    429  OD2 ASP A  62      53.111  26.527  -6.856  1.00 21.22           O  
ATOM    430  N   LYS A  63      51.840  27.774  -1.747  1.00 20.93           N  
ATOM    431  CA  LYS A  63      52.391  27.903  -0.404  1.00 22.84           C  
ATOM    432  C   LYS A  63      51.610  27.053   0.569  1.00 22.63           C  
ATOM    433  O   LYS A  63      52.183  26.275   1.319  1.00 21.94           O  
ATOM    434  CB  LYS A  63      52.410  29.358   0.090  1.00 26.94           C  
ATOM    435  CG  LYS A  63      53.216  29.543   1.412  1.00 31.47           C  
ATOM    436  CD  LYS A  63      53.642  31.004   1.612  1.00 33.65           C  
ATOM    437  CE  LYS A  63      54.712  31.152   2.740  1.00 37.16           C  
ATOM    438  NZ  LYS A  63      55.236  32.570   2.915  1.00 37.24           N  
ATOM    439  N   VAL A  64      50.287  27.151   0.541  1.00 23.66           N  
ATOM    440  CA  VAL A  64      49.529  26.403   1.552  1.00 22.54           C  
ATOM    441  C   VAL A  64      49.370  24.902   1.238  1.00 20.11           C  
ATOM    442  O   VAL A  64      49.445  24.085   2.136  1.00 21.21           O  
ATOM    443  CB  VAL A  64      48.198  27.118   1.916  1.00 24.95           C  
ATOM    444  CG1 VAL A  64      47.349  27.304   0.708  1.00 25.09           C  
ATOM    445  CG2 VAL A  64      47.462  26.332   2.977  1.00 26.99           C  
ATOM    446  N   LEU A  65      49.184  24.528  -0.020  1.00 19.98           N  
ATOM    447  CA  LEU A  65      49.166  23.082  -0.356  1.00 20.19           C  
ATOM    448  C   LEU A  65      50.436  22.378   0.103  1.00 20.96           C  
ATOM    449  O   LEU A  65      50.382  21.304   0.691  1.00 23.69           O  
ATOM    450  CB  LEU A  65      48.973  22.843  -1.856  1.00 20.45           C  
ATOM    451  CG  LEU A  65      47.527  22.558  -2.259  1.00 22.21           C  
ATOM    452  CD1 LEU A  65      46.661  23.806  -2.137  1.00 19.56           C  
ATOM    453  CD2 LEU A  65      47.494  22.043  -3.687  1.00 20.34           C  
ATOM    454  N   ALA A  66      51.585  22.998  -0.159  1.00 22.07           N  
ATOM    455  CA  ALA A  66      52.855  22.422   0.265  1.00 22.00           C  
ATOM    456  C   ALA A  66      52.988  22.216   1.772  1.00 23.69           C  
ATOM    457  O   ALA A  66      53.819  21.418   2.191  1.00 26.62           O  
ATOM    458  CB  ALA A  66      54.005  23.294  -0.230  1.00 21.47           C  
ATOM    459  N   ASP A  67      52.213  22.960   2.570  1.00 24.08           N  
ATOM    460  CA  ASP A  67      52.201  22.845   4.029  1.00 25.38           C  
ATOM    461  C   ASP A  67      51.321  21.690   4.501  1.00 26.32           C  
ATOM    462  O   ASP A  67      51.202  21.422   5.697  1.00 24.33           O  
ATOM    463  CB  ASP A  67      51.658  24.139   4.657  1.00 30.12           C  
ATOM    464  CG  ASP A  67      52.679  25.286   4.654  1.00 33.53           C  
ATOM    465  OD1 ASP A  67      53.904  25.006   4.600  1.00 32.71           O  
ATOM    466  OD2 ASP A  67      52.231  26.467   4.717  1.00 35.46           O  
ATOM    467  N   ASN A  68      50.702  20.997   3.553  1.00 24.61           N  
ATOM    468  CA  ASN A  68      49.700  19.997   3.902  1.00 22.03           C  
ATOM    469  C   ASN A  68      49.923  18.682   3.182  1.00 23.28           C  
ATOM    470  O   ASN A  68      50.600  18.644   2.154  1.00 23.97           O  
ATOM    471  CB  ASN A  68      48.318  20.582   3.596  1.00 21.64           C  
ATOM    472  CG  ASN A  68      47.863  21.532   4.663  1.00 22.46           C  
ATOM    473  OD1 ASN A  68      47.369  21.106   5.700  1.00 24.08           O  
ATOM    474  ND2 ASN A  68      48.044  22.836   4.431  1.00 19.22           N  
ATOM    475  N   ASP A  69      49.322  17.614   3.706  1.00 25.50           N  
ATOM    476  CA  ASP A  69      49.405  16.301   3.081  1.00 25.27           C  
ATOM    477  C   ASP A  69      48.311  16.030   2.039  1.00 24.17           C  
ATOM    478  O   ASP A  69      48.498  15.200   1.149  1.00 24.37           O  
ATOM    479  CB  ASP A  69      49.409  15.232   4.166  1.00 25.95           C  
ATOM    480  CG  ASP A  69      50.587  15.394   5.121  1.00 27.56           C  
ATOM    481  OD1 ASP A  69      51.731  15.518   4.614  1.00 29.65           O  
ATOM    482  OD2 ASP A  69      50.382  15.417   6.341  1.00 29.26           O  
ATOM    483  N   VAL A  70      47.167  16.711   2.162  1.00 22.12           N  
ATOM    484  CA  VAL A  70      46.024  16.522   1.272  1.00 20.71           C  
ATOM    485  C   VAL A  70      45.192  17.802   1.321  1.00 19.85           C  
ATOM    486  O   VAL A  70      45.161  18.509   2.349  1.00 24.85           O  
ATOM    487  CB  VAL A  70      45.155  15.268   1.672  1.00 22.53           C  
ATOM    488  CG1 VAL A  70      44.505  15.446   3.056  1.00 23.25           C  
ATOM    489  CG2 VAL A  70      44.093  14.894   0.590  1.00 23.29           C  
ATOM    490  N   VAL A  71      44.545  18.106   0.204  1.00 20.20           N  
ATOM    491  CA  VAL A  71      43.609  19.213   0.142  1.00 19.03           C  
ATOM    492  C   VAL A  71      42.226  18.691  -0.247  1.00 21.29           C  
ATOM    493  O   VAL A  71      42.073  17.912  -1.200  1.00 17.87           O  
ATOM    494  CB  VAL A  71      44.107  20.359  -0.803  1.00 18.59           C  
ATOM    495  CG1 VAL A  71      44.489  19.835  -2.194  1.00 18.69           C  
ATOM    496  CG2 VAL A  71      43.070  21.466  -0.920  1.00 18.09           C  
ATOM    497  N   ILE A  72      41.230  19.122   0.518  1.00 21.12           N  
ATOM    498  CA  ILE A  72      39.847  18.819   0.234  1.00 17.89           C  
ATOM    499  C   ILE A  72      39.316  20.075  -0.419  1.00 17.61           C  
ATOM    500  O   ILE A  72      39.328  21.155   0.181  1.00 19.49           O  
ATOM    501  CB  ILE A  72      39.059  18.508   1.520  1.00 19.65           C  
ATOM    502  CG1 ILE A  72      39.660  17.309   2.259  1.00 18.84           C  
ATOM    503  CG2 ILE A  72      37.573  18.238   1.182  1.00 19.44           C  
ATOM    504  CD1 ILE A  72      38.997  17.050   3.610  1.00 20.57           C  
ATOM    505  N   SER A  73      38.910  19.925  -1.664  1.00 15.78           N  
ATOM    506  CA  SER A  73      38.385  21.044  -2.462  1.00 19.96           C  
ATOM    507  C   SER A  73      36.862  21.023  -2.487  1.00 23.34           C  
ATOM    508  O   SER A  73      36.249  20.233  -3.230  1.00 22.88           O  
ATOM    509  CB  SER A  73      38.895  20.959  -3.881  1.00 19.62           C  
ATOM    510  OG  SER A  73      38.549  22.134  -4.587  1.00 21.49           O  
ATOM    511  N   LEU A  74      36.258  21.867  -1.668  1.00 25.73           N  
ATOM    512  CA  LEU A  74      34.794  21.972  -1.599  1.00 28.55           C  
ATOM    513  C   LEU A  74      34.325  23.300  -2.171  1.00 32.32           C  
ATOM    514  O   LEU A  74      33.317  23.869  -1.728  1.00 34.22           O  
ATOM    515  CB  LEU A  74      34.297  21.830  -0.164  1.00 30.29           C  
ATOM    516  CG  LEU A  74      34.488  20.453   0.478  1.00 33.16           C  
ATOM    517  CD1 LEU A  74      34.078  20.462   1.951  1.00 34.16           C  
ATOM    518  CD2 LEU A  74      33.728  19.373  -0.305  1.00 33.68           C  
ATOM    519  N   ILE A  75      35.085  23.802  -3.129  1.00 29.71           N  
ATOM    520  CA  ILE A  75      34.747  25.040  -3.789  1.00 31.97           C  
ATOM    521  C   ILE A  75      34.162  24.657  -5.138  1.00 32.95           C  
ATOM    522  O   ILE A  75      34.227  23.471  -5.517  1.00 33.59           O  
ATOM    523  CB  ILE A  75      35.977  25.987  -3.905  1.00 31.85           C  
ATOM    524  CG1 ILE A  75      37.150  25.291  -4.601  1.00 29.37           C  
ATOM    525  CG2 ILE A  75      36.374  26.483  -2.517  1.00 29.60           C  
ATOM    526  CD1 ILE A  75      38.403  26.199  -4.789  1.00 28.92           C  
ATOM    527  N   PRO A  76      33.550  25.628  -5.855  1.00 34.25           N  
ATOM    528  CA  PRO A  76      32.982  25.333  -7.169  1.00 32.77           C  
ATOM    529  C   PRO A  76      33.933  24.558  -8.086  1.00 34.81           C  
ATOM    530  O   PRO A  76      35.143  24.830  -8.104  1.00 32.88           O  
ATOM    531  CB  PRO A  76      32.686  26.723  -7.737  1.00 33.76           C  
ATOM    532  CG  PRO A  76      32.424  27.562  -6.540  1.00 33.10           C  
ATOM    533  CD  PRO A  76      33.309  27.034  -5.452  1.00 32.20           C  
ATOM    534  N   TYR A  77      33.371  23.623  -8.859  1.00 35.21           N  
ATOM    535  CA  TYR A  77      34.147  22.696  -9.691  1.00 35.13           C  
ATOM    536  C   TYR A  77      35.009  23.363 -10.778  1.00 35.84           C  
ATOM    537  O   TYR A  77      35.984  22.757 -11.266  1.00 31.91           O  
ATOM    538  CB  TYR A  77      33.235  21.614 -10.298  1.00 42.43           C  
ATOM    539  CG  TYR A  77      32.581  22.020 -11.596  1.00 44.46           C  
ATOM    540  CD1 TYR A  77      33.200  21.761 -12.817  1.00 44.69           C  
ATOM    541  CD2 TYR A  77      31.362  22.689 -11.602  1.00 46.95           C  
ATOM    542  CE1 TYR A  77      32.626  22.151 -14.011  1.00 46.14           C  
ATOM    543  CE2 TYR A  77      30.761  23.084 -12.807  1.00 47.92           C  
ATOM    544  CZ  TYR A  77      31.406  22.809 -14.003  1.00 46.55           C  
ATOM    545  OH  TYR A  77      30.830  23.182 -15.200  1.00 46.66           O  
ATOM    546  N   THR A  78      34.654  24.592 -11.166  1.00 33.90           N  
ATOM    547  CA  THR A  78      35.460  25.320 -12.160  1.00 35.70           C  
ATOM    548  C   THR A  78      36.832  25.682 -11.598  1.00 34.22           C  
ATOM    549  O   THR A  78      37.751  25.976 -12.369  1.00 35.75           O  
ATOM    550  CB  THR A  78      34.790  26.614 -12.702  1.00 36.97           C  
ATOM    551  OG1 THR A  78      34.676  27.583 -11.647  1.00 39.70           O  
ATOM    552  CG2 THR A  78      33.423  26.322 -13.309  1.00 39.22           C  
ATOM    553  N   PHE A  79      36.951  25.677 -10.266  1.00 31.81           N  
ATOM    554  CA  PHE A  79      38.219  25.944  -9.593  1.00 32.56           C  
ATOM    555  C   PHE A  79      39.091  24.714  -9.345  1.00 30.24           C  
ATOM    556  O   PHE A  79      40.260  24.867  -9.010  1.00 28.91           O  
ATOM    557  CB  PHE A  79      37.998  26.685  -8.280  1.00 38.16           C  
ATOM    558  CG  PHE A  79      37.417  28.040  -8.463  1.00 43.15           C  
ATOM    559  CD1 PHE A  79      38.138  29.032  -9.136  1.00 43.96           C  
ATOM    560  CD2 PHE A  79      36.141  28.329  -7.991  1.00 44.35           C  
ATOM    561  CE1 PHE A  79      37.607  30.296  -9.329  1.00 45.63           C  
ATOM    562  CE2 PHE A  79      35.595  29.603  -8.174  1.00 46.62           C  
ATOM    563  CZ  PHE A  79      36.338  30.588  -8.845  1.00 44.76           C  
ATOM    564  N   HIS A  80      38.543  23.505  -9.500  1.00 27.44           N  
ATOM    565  CA  HIS A  80      39.344  22.310  -9.181  1.00 23.50           C  
ATOM    566  C   HIS A  80      40.627  22.236  -9.995  1.00 24.38           C  
ATOM    567  O   HIS A  80      41.651  21.789  -9.481  1.00 26.04           O  
ATOM    568  CB  HIS A  80      38.548  20.985  -9.292  1.00 24.81           C  
ATOM    569  CG  HIS A  80      37.465  20.857  -8.265  1.00 25.69           C  
ATOM    570  ND1 HIS A  80      36.299  20.160  -8.492  1.00 26.55           N  
ATOM    571  CD2 HIS A  80      37.348  21.393  -7.028  1.00 22.86           C  
ATOM    572  CE1 HIS A  80      35.528  20.242  -7.421  1.00 25.67           C  
ATOM    573  NE2 HIS A  80      36.142  20.987  -6.519  1.00 25.67           N  
ATOM    574  N   PRO A  81      40.574  22.627 -11.276  1.00 27.38           N  
ATOM    575  CA  PRO A  81      41.794  22.630 -12.085  1.00 23.05           C  
ATOM    576  C   PRO A  81      42.933  23.461 -11.484  1.00 24.94           C  
ATOM    577  O   PRO A  81      44.066  22.982 -11.472  1.00 24.33           O  
ATOM    578  CB  PRO A  81      41.313  23.218 -13.420  1.00 24.46           C  
ATOM    579  CG  PRO A  81      39.873  22.729 -13.470  1.00 22.60           C  
ATOM    580  CD  PRO A  81      39.402  23.005 -12.092  1.00 24.58           C  
ATOM    581  N   ASN A  82      42.633  24.668 -10.992  1.00 24.88           N  
ATOM    582  CA  ASN A  82      43.598  25.488 -10.243  1.00 23.86           C  
ATOM    583  C   ASN A  82      44.203  24.758  -9.076  1.00 20.88           C  
ATOM    584  O   ASN A  82      45.411  24.816  -8.869  1.00 22.88           O  
ATOM    585  CB  ASN A  82      42.936  26.737  -9.656  1.00 32.45           C  
ATOM    586  CG  ASN A  82      42.404  27.663 -10.706  1.00 35.67           C  
ATOM    587  OD1 ASN A  82      41.401  27.362 -11.374  1.00 39.08           O  
ATOM    588  ND2 ASN A  82      43.050  28.830 -10.843  1.00 38.07           N  
ATOM    589  N   VAL A  83      43.347  24.081  -8.307  1.00 18.78           N  
ATOM    590  CA  VAL A  83      43.761  23.312  -7.150  1.00 19.66           C  
ATOM    591  C   VAL A  83      44.659  22.161  -7.580  1.00 21.84           C  
ATOM    592  O   VAL A  83      45.721  21.933  -6.991  1.00 20.74           O  
ATOM    593  CB  VAL A  83      42.560  22.798  -6.351  1.00 20.96           C  
ATOM    594  CG1 VAL A  83      43.027  21.928  -5.180  1.00 22.13           C  
ATOM    595  CG2 VAL A  83      41.725  23.998  -5.808  1.00 19.19           C  
ATOM    596  N   VAL A  84      44.231  21.454  -8.617  1.00 24.14           N  
ATOM    597  CA  VAL A  84      44.965  20.276  -9.085  1.00 23.18           C  
ATOM    598  C   VAL A  84      46.306  20.667  -9.719  1.00 23.14           C  
ATOM    599  O   VAL A  84      47.298  19.986  -9.497  1.00 21.34           O  
ATOM    600  CB  VAL A  84      44.083  19.357 -10.012  1.00 25.53           C  
ATOM    601  CG1 VAL A  84      44.913  18.306 -10.745  1.00 24.88           C  
ATOM    602  CG2 VAL A  84      42.995  18.689  -9.209  1.00 26.22           C  
ATOM    603  N   LYS A  85      46.334  21.757 -10.491  1.00 23.09           N  
ATOM    604  CA  LYS A  85      47.614  22.272 -11.018  1.00 25.49           C  
ATOM    605  C   LYS A  85      48.608  22.553  -9.889  1.00 22.99           C  
ATOM    606  O   LYS A  85      49.804  22.242 -10.001  1.00 23.92           O  
ATOM    607  CB  LYS A  85      47.413  23.525 -11.888  1.00 25.22           C  
ATOM    608  CG  LYS A  85      46.778  23.217 -13.257  1.00 28.67           C  
ATOM    609  CD  LYS A  85      46.365  24.474 -14.018  1.00 31.97           C  
ATOM    610  CE  LYS A  85      45.660  24.086 -15.322  1.00 37.79           C  
ATOM    611  NZ  LYS A  85      45.572  25.186 -16.338  1.00 40.11           N  
ATOM    612  N   SER A  86      48.107  23.142  -8.812  1.00 20.94           N  
ATOM    613  CA  SER A  86      48.912  23.394  -7.616  1.00 18.89           C  
ATOM    614  C   SER A  86      49.313  22.086  -6.948  1.00 23.13           C  
ATOM    615  O   SER A  86      50.483  21.909  -6.577  1.00 19.21           O  
ATOM    616  CB  SER A  86      48.174  24.318  -6.652  1.00 22.49           C  
ATOM    617  OG  SER A  86      48.955  24.559  -5.493  1.00 19.13           O  
ATOM    618  N   ALA A  87      48.375  21.134  -6.843  1.00 15.90           N  
ATOM    619  CA  ALA A  87      48.705  19.846  -6.258  1.00 16.83           C  
ATOM    620  C   ALA A  87      49.773  19.107  -7.064  1.00 17.84           C  
ATOM    621  O   ALA A  87      50.578  18.415  -6.471  1.00 19.44           O  
ATOM    622  CB  ALA A  87      47.451  18.972  -6.150  1.00 14.94           C  
ATOM    623  N   ILE A  88      49.766  19.261  -8.392  1.00 18.70           N  
ATOM    624  CA  ILE A  88      50.782  18.630  -9.250  1.00 19.02           C  
ATOM    625  C   ILE A  88      52.161  19.256  -8.910  1.00 22.04           C  
ATOM    626  O   ILE A  88      53.147  18.554  -8.654  1.00 20.56           O  
ATOM    627  CB  ILE A  88      50.427  18.798 -10.743  1.00 20.85           C  
ATOM    628  CG1 ILE A  88      49.292  17.825 -11.143  1.00 20.31           C  
ATOM    629  CG2 ILE A  88      51.642  18.520 -11.616  1.00 22.24           C  
ATOM    630  CD1 ILE A  88      48.552  18.241 -12.414  1.00 22.01           C  
ATOM    631  N   ARG A  89      52.207  20.581  -8.847  1.00 22.53           N  
ATOM    632  CA  ARG A  89      53.449  21.277  -8.534  1.00 22.91           C  
ATOM    633  C   ARG A  89      54.004  20.911  -7.163  1.00 22.58           C  
ATOM    634  O   ARG A  89      55.204  20.763  -7.011  1.00 25.57           O  
ATOM    635  CB  ARG A  89      53.267  22.793  -8.623  1.00 21.18           C  
ATOM    636  CG  ARG A  89      53.038  23.291 -10.031  1.00 21.14           C  
ATOM    637  CD  ARG A  89      53.128  24.834 -10.119  1.00 25.05           C  
ATOM    638  NE  ARG A  89      52.091  25.518  -9.337  1.00 24.24           N  
ATOM    639  CZ  ARG A  89      50.891  25.869  -9.805  1.00 23.21           C  
ATOM    640  NH1 ARG A  89      50.537  25.623 -11.069  1.00 21.61           N  
ATOM    641  NH2 ARG A  89      50.047  26.484  -9.000  1.00 23.13           N  
ATOM    642  N   THR A  90      53.135  20.791  -6.166  1.00 21.51           N  
ATOM    643  CA  THR A  90      53.546  20.608  -4.784  1.00 21.25           C  
ATOM    644  C   THR A  90      53.572  19.141  -4.342  1.00 21.85           C  
ATOM    645  O   THR A  90      53.968  18.831  -3.208  1.00 19.51           O  
ATOM    646  CB  THR A  90      52.599  21.387  -3.830  1.00 23.32           C  
ATOM    647  OG1 THR A  90      51.244  20.928  -4.040  1.00 21.57           O  
ATOM    648  CG2 THR A  90      52.672  22.882  -4.128  1.00 18.84           C  
ATOM    649  N   LYS A  91      53.126  18.251  -5.224  1.00 22.43           N  
ATOM    650  CA  LYS A  91      52.921  16.835  -4.889  1.00 24.37           C  
ATOM    651  C   LYS A  91      52.033  16.666  -3.655  1.00 24.75           C  
ATOM    652  O   LYS A  91      52.449  16.122  -2.630  1.00 24.77           O  
ATOM    653  CB  LYS A  91      54.238  16.057  -4.720  1.00 32.39           C  
ATOM    654  CG  LYS A  91      55.278  16.257  -5.810  1.00 37.09           C  
ATOM    655  CD  LYS A  91      54.842  15.812  -7.207  1.00 39.56           C  
ATOM    656  CE  LYS A  91      56.066  15.507  -8.127  1.00 39.98           C  
ATOM    657  NZ  LYS A  91      56.927  14.395  -7.629  1.00 42.13           N  
ATOM    658  N   THR A  92      50.805  17.169  -3.753  1.00 19.75           N  
ATOM    659  CA  THR A  92      49.843  17.094  -2.651  1.00 18.56           C  
ATOM    660  C   THR A  92      48.660  16.275  -3.192  1.00 16.28           C  
ATOM    661  O   THR A  92      48.279  16.456  -4.347  1.00 20.19           O  
ATOM    662  CB  THR A  92      49.368  18.514  -2.284  1.00 19.53           C  
ATOM    663  OG1 THR A  92      50.521  19.333  -1.995  1.00 22.18           O  
ATOM    664  CG2 THR A  92      48.475  18.503  -1.068  1.00 19.30           C  
ATOM    665  N   ASP A  93      48.103  15.396  -2.361  1.00 20.17           N  
ATOM    666  CA  ASP A  93      46.902  14.666  -2.747  1.00 18.75           C  
ATOM    667  C   ASP A  93      45.673  15.562  -2.662  1.00 20.35           C  
ATOM    668  O   ASP A  93      45.675  16.562  -1.934  1.00 16.24           O  
ATOM    669  CB  ASP A  93      46.752  13.394  -1.905  1.00 18.59           C  
ATOM    670  CG  ASP A  93      47.919  12.423  -2.125  1.00 21.46           C  
ATOM    671  OD1 ASP A  93      48.479  12.397  -3.251  1.00 19.12           O  
ATOM    672  OD2 ASP A  93      48.270  11.718  -1.164  1.00 22.05           O  
ATOM    673  N   VAL A  94      44.625  15.200  -3.414  1.00 19.90           N  
ATOM    674  CA  VAL A  94      43.403  16.028  -3.529  1.00 19.00           C  
ATOM    675  C   VAL A  94      42.171  15.133  -3.341  1.00 19.79           C  
ATOM    676  O   VAL A  94      42.176  13.973  -3.761  1.00 17.71           O  
ATOM    677  CB  VAL A  94      43.296  16.692  -4.914  1.00 19.44           C  
ATOM    678  CG1 VAL A  94      42.055  17.574  -4.993  1.00 18.79           C  
ATOM    679  CG2 VAL A  94      44.536  17.540  -5.192  1.00 20.58           C  
ATOM    680  N   VAL A  95      41.149  15.641  -2.659  1.00 18.67           N  
ATOM    681  CA  VAL A  95      39.842  14.967  -2.613  1.00 17.84           C  
ATOM    682  C   VAL A  95      38.748  15.951  -3.008  1.00 17.85           C  
ATOM    683  O   VAL A  95      38.707  17.099  -2.510  1.00 20.24           O  
ATOM    684  CB  VAL A  95      39.522  14.361  -1.220  1.00 14.97           C  
ATOM    685  CG1 VAL A  95      38.117  13.710  -1.186  1.00 16.24           C  
ATOM    686  CG2 VAL A  95      40.595  13.301  -0.825  1.00 17.39           C  
ATOM    687  N   THR A  96      37.884  15.544  -3.942  1.00 20.73           N  
ATOM    688  CA  THR A  96      36.692  16.363  -4.261  1.00 19.39           C  
ATOM    689  C   THR A  96      35.421  15.522  -4.208  1.00 20.61           C  
ATOM    690  O   THR A  96      35.496  14.286  -4.200  1.00 19.78           O  
ATOM    691  CB  THR A  96      36.752  17.035  -5.696  1.00 19.46           C  
ATOM    692  OG1 THR A  96      36.230  16.121  -6.674  1.00 21.72           O  
ATOM    693  CG2 THR A  96      38.171  17.453  -6.110  1.00 22.95           C  
ATOM    694  N   SER A  97      34.272  16.204  -4.153  1.00 21.94           N  
ATOM    695  CA  SER A  97      32.972  15.551  -4.282  1.00 22.97           C  
ATOM    696  C   SER A  97      32.354  15.732  -5.670  1.00 24.35           C  
ATOM    697  O   SER A  97      31.182  15.410  -5.879  1.00 28.03           O  
ATOM    698  CB  SER A  97      31.984  16.073  -3.216  1.00 21.66           C  
ATOM    699  OG  SER A  97      31.645  17.436  -3.495  1.00 21.80           O  
ATOM    700  N   SER A  98      33.125  16.245  -6.618  1.00 24.83           N  
ATOM    701  CA  SER A  98      32.582  16.684  -7.907  1.00 22.39           C  
ATOM    702  C   SER A  98      32.775  15.649  -9.003  1.00 24.58           C  
ATOM    703  O   SER A  98      33.738  14.882  -8.963  1.00 22.87           O  
ATOM    704  CB  SER A  98      33.260  17.987  -8.340  1.00 24.11           C  
ATOM    705  OG  SER A  98      32.928  19.021  -7.460  1.00 23.07           O  
ATOM    706  N   TYR A  99      31.858  15.638  -9.991  1.00 26.58           N  
ATOM    707  CA  TYR A  99      32.073  14.882 -11.231  1.00 27.13           C  
ATOM    708  C   TYR A  99      33.377  15.333 -11.906  1.00 27.54           C  
ATOM    709  O   TYR A  99      33.664  16.524 -11.959  1.00 29.01           O  
ATOM    710  CB  TYR A  99      30.855  14.986 -12.191  1.00 34.77           C  
ATOM    711  CG  TYR A  99      29.846  13.840 -12.030  1.00 36.71           C  
ATOM    712  CD1 TYR A  99      30.232  12.503 -12.268  1.00 38.60           C  
ATOM    713  CD2 TYR A  99      28.522  14.082 -11.634  1.00 39.67           C  
ATOM    714  CE1 TYR A  99      29.342  11.432 -12.119  1.00 38.66           C  
ATOM    715  CE2 TYR A  99      27.602  13.014 -11.482  1.00 38.95           C  
ATOM    716  CZ  TYR A  99      28.029  11.695 -11.727  1.00 39.76           C  
ATOM    717  OH  TYR A  99      27.157  10.631 -11.590  1.00 39.88           O  
ATOM    718  N   ILE A 100      34.185  14.374 -12.365  1.00 25.94           N  
ATOM    719  CA  ILE A 100      35.435  14.668 -13.091  1.00 27.33           C  
ATOM    720  C   ILE A 100      35.119  15.491 -14.329  1.00 29.85           C  
ATOM    721  O   ILE A 100      34.282  15.085 -15.144  1.00 28.28           O  
ATOM    722  CB  ILE A 100      36.174  13.369 -13.499  1.00 25.20           C  
ATOM    723  CG1 ILE A 100      36.676  12.636 -12.244  1.00 25.06           C  
ATOM    724  CG2 ILE A 100      37.298  13.666 -14.524  1.00 26.50           C  
ATOM    725  CD1 ILE A 100      37.131  11.212 -12.506  1.00 24.20           C  
ATOM    726  N   SER A 101      35.766  16.656 -14.440  1.00 25.81           N  
ATOM    727  CA  SER A 101      35.495  17.600 -15.511  1.00 28.08           C  
ATOM    728  C   SER A 101      36.456  17.386 -16.676  1.00 29.34           C  
ATOM    729  O   SER A 101      37.512  16.757 -16.501  1.00 29.17           O  
ATOM    730  CB  SER A 101      35.567  19.042 -14.983  1.00 29.95           C  
ATOM    731  OG  SER A 101      36.902  19.506 -14.933  1.00 32.48           O  
ATOM    732  N   PRO A 102      36.091  17.865 -17.884  1.00 30.03           N  
ATOM    733  CA  PRO A 102      37.075  17.775 -18.982  1.00 29.59           C  
ATOM    734  C   PRO A 102      38.416  18.465 -18.645  1.00 29.38           C  
ATOM    735  O   PRO A 102      39.474  17.949 -19.008  1.00 27.00           O  
ATOM    736  CB  PRO A 102      36.361  18.453 -20.159  1.00 29.79           C  
ATOM    737  CG  PRO A 102      34.888  18.336 -19.830  1.00 31.96           C  
ATOM    738  CD  PRO A 102      34.807  18.452 -18.331  1.00 30.28           C  
ATOM    739  N   ALA A 103      38.386  19.577 -17.911  1.00 27.35           N  
ATOM    740  CA  ALA A 103      39.643  20.217 -17.481  1.00 28.26           C  
ATOM    741  C   ALA A 103      40.523  19.280 -16.654  1.00 28.76           C  
ATOM    742  O   ALA A 103      41.739  19.240 -16.842  1.00 29.13           O  
ATOM    743  CB  ALA A 103      39.367  21.497 -16.723  1.00 31.29           C  
ATOM    744  N   LEU A 104      39.915  18.511 -15.744  1.00 27.85           N  
ATOM    745  CA  LEU A 104      40.678  17.541 -14.954  1.00 22.93           C  
ATOM    746  C   LEU A 104      41.193  16.388 -15.785  1.00 26.06           C  
ATOM    747  O   LEU A 104      42.320  15.908 -15.569  1.00 24.68           O  
ATOM    748  CB  LEU A 104      39.846  16.982 -13.792  1.00 22.99           C  
ATOM    749  CG  LEU A 104      39.632  17.869 -12.577  1.00 26.55           C  
ATOM    750  CD1 LEU A 104      39.205  16.973 -11.401  1.00 22.13           C  
ATOM    751  CD2 LEU A 104      40.915  18.663 -12.238  1.00 25.19           C  
ATOM    752  N   ARG A 105      40.364  15.887 -16.699  1.00 22.91           N  
ATOM    753  CA  ARG A 105      40.867  14.850 -17.618  1.00 27.44           C  
ATOM    754  C   ARG A 105      42.094  15.293 -18.403  1.00 29.00           C  
ATOM    755  O   ARG A 105      42.997  14.482 -18.653  1.00 26.18           O  
ATOM    756  CB  ARG A 105      39.790  14.396 -18.594  1.00 31.16           C  
ATOM    757  CG  ARG A 105      38.996  13.269 -18.034  1.00 36.46           C  
ATOM    758  CD  ARG A 105      37.976  12.741 -18.997  1.00 40.93           C  
ATOM    759  NE  ARG A 105      36.828  12.394 -18.185  1.00 47.25           N  
ATOM    760  CZ  ARG A 105      35.715  13.111 -18.122  1.00 48.62           C  
ATOM    761  NH1 ARG A 105      35.555  14.191 -18.895  1.00 48.61           N  
ATOM    762  NH2 ARG A 105      34.747  12.716 -17.302  1.00 50.11           N  
ATOM    763  N   GLU A 106      42.112  16.567 -18.816  1.00 30.27           N  
ATOM    764  CA  GLU A 106      43.276  17.109 -19.541  1.00 30.25           C  
ATOM    765  C   GLU A 106      44.540  17.044 -18.690  1.00 29.11           C  
ATOM    766  O   GLU A 106      45.627  16.808 -19.213  1.00 27.44           O  
ATOM    767  CB  GLU A 106      43.015  18.537 -20.009  1.00 36.05           C  
ATOM    768  CG  GLU A 106      42.269  18.627 -21.339  1.00 46.86           C  
ATOM    769  CD  GLU A 106      41.568  19.972 -21.536  1.00 50.95           C  
ATOM    770  OE1 GLU A 106      42.077  20.999 -21.003  1.00 53.96           O  
ATOM    771  OE2 GLU A 106      40.507  20.002 -22.220  1.00 54.06           O  
ATOM    772  N   LEU A 107      44.389  17.216 -17.371  1.00 23.82           N  
ATOM    773  CA  LEU A 107      45.526  17.191 -16.461  1.00 23.86           C  
ATOM    774  C   LEU A 107      45.931  15.777 -16.075  1.00 23.91           C  
ATOM    775  O   LEU A 107      46.951  15.575 -15.416  1.00 23.68           O  
ATOM    776  CB  LEU A 107      45.207  17.966 -15.177  1.00 21.16           C  
ATOM    777  CG  LEU A 107      44.936  19.473 -15.350  1.00 23.51           C  
ATOM    778  CD1 LEU A 107      44.338  20.034 -14.096  1.00 21.79           C  
ATOM    779  CD2 LEU A 107      46.252  20.201 -15.681  1.00 21.75           C  
ATOM    780  N   GLU A 108      45.126  14.797 -16.479  1.00 21.76           N  
ATOM    781  CA  GLU A 108      45.300  13.450 -15.919  1.00 20.57           C  
ATOM    782  C   GLU A 108      46.726  12.869 -16.118  1.00 21.30           C  
ATOM    783  O   GLU A 108      47.301  12.338 -15.173  1.00 23.09           O  
ATOM    784  CB  GLU A 108      44.205  12.492 -16.421  1.00 18.88           C  
ATOM    785  CG  GLU A 108      44.242  11.115 -15.725  1.00 20.61           C  
ATOM    786  CD  GLU A 108      43.086  10.177 -16.112  1.00 21.28           C  
ATOM    787  OE1 GLU A 108      42.319  10.504 -17.043  1.00 22.60           O  
ATOM    788  OE2 GLU A 108      43.000   9.080 -15.495  1.00 20.58           O  
ATOM    789  N   PRO A 109      47.311  12.961 -17.334  1.00 21.82           N  
ATOM    790  CA  PRO A 109      48.693  12.416 -17.420  1.00 24.75           C  
ATOM    791  C   PRO A 109      49.728  13.076 -16.487  1.00 25.00           C  
ATOM    792  O   PRO A 109      50.639  12.397 -16.002  1.00 22.43           O  
ATOM    793  CB  PRO A 109      49.068  12.614 -18.895  1.00 25.43           C  
ATOM    794  CG  PRO A 109      47.792  12.747 -19.595  1.00 27.62           C  
ATOM    795  CD  PRO A 109      46.860  13.469 -18.639  1.00 26.49           C  
ATOM    796  N   GLU A 110      49.581  14.375 -16.213  1.00 24.69           N  
ATOM    797  CA  GLU A 110      50.461  15.032 -15.244  1.00 22.54           C  
ATOM    798  C   GLU A 110      50.172  14.620 -13.812  1.00 22.09           C  
ATOM    799  O   GLU A 110      51.078  14.580 -12.984  1.00 21.95           O  
ATOM    800  CB  GLU A 110      50.367  16.558 -15.375  1.00 28.05           C  
ATOM    801  CG  GLU A 110      50.839  17.080 -16.725  1.00 33.30           C  
ATOM    802  CD  GLU A 110      50.385  18.509 -16.973  1.00 38.60           C  
ATOM    803  OE1 GLU A 110      50.989  19.431 -16.361  1.00 41.42           O  
ATOM    804  OE2 GLU A 110      49.432  18.712 -17.776  1.00 38.76           O  
ATOM    805  N   ILE A 111      48.907  14.320 -13.501  1.00 21.07           N  
ATOM    806  CA  ILE A 111      48.572  13.858 -12.155  1.00 18.09           C  
ATOM    807  C   ILE A 111      49.341  12.576 -11.920  1.00 20.39           C  
ATOM    808  O   ILE A 111      49.942  12.396 -10.892  1.00 18.36           O  
ATOM    809  CB  ILE A 111      47.042  13.578 -12.015  1.00 21.65           C  
ATOM    810  CG1 ILE A 111      46.268  14.903 -12.025  1.00 23.09           C  
ATOM    811  CG2 ILE A 111      46.732  12.713 -10.726  1.00 18.13           C  
ATOM    812  CD1 ILE A 111      44.785  14.742 -12.175  1.00 22.54           C  
ATOM    813  N   VAL A 112      49.290  11.668 -12.896  1.00 20.45           N  
ATOM    814  CA  VAL A 112      49.957  10.366 -12.777  1.00 21.80           C  
ATOM    815  C   VAL A 112      51.487  10.541 -12.649  1.00 24.88           C  
ATOM    816  O   VAL A 112      52.119   9.988 -11.743  1.00 24.23           O  
ATOM    817  CB  VAL A 112      49.592   9.461 -13.989  1.00 23.13           C  
ATOM    818  CG1 VAL A 112      50.282   8.108 -13.874  1.00 23.32           C  
ATOM    819  CG2 VAL A 112      48.062   9.251 -14.047  1.00 20.92           C  
ATOM    820  N   LYS A 113      52.060  11.313 -13.567  1.00 25.62           N  
ATOM    821  CA  LYS A 113      53.503  11.599 -13.519  1.00 30.37           C  
ATOM    822  C   LYS A 113      53.916  12.228 -12.197  1.00 27.60           C  
ATOM    823  O   LYS A 113      54.993  11.917 -11.682  1.00 25.77           O  
ATOM    824  CB  LYS A 113      53.924  12.487 -14.686  1.00 33.50           C  
ATOM    825  CG  LYS A 113      54.249  11.691 -15.939  1.00 43.18           C  
ATOM    826  CD  LYS A 113      54.990  12.539 -16.987  1.00 47.10           C  
ATOM    827  CE  LYS A 113      56.505  12.680 -16.682  1.00 51.32           C  
ATOM    828  NZ  LYS A 113      57.298  11.408 -16.876  1.00 52.10           N  
ATOM    829  N   ALA A 114      53.051  13.081 -11.631  1.00 26.08           N  
ATOM    830  CA  ALA A 114      53.370  13.751 -10.369  1.00 23.14           C  
ATOM    831  C   ALA A 114      53.327  12.802  -9.172  1.00 26.07           C  
ATOM    832  O   ALA A 114      53.859  13.100  -8.098  1.00 28.16           O  
ATOM    833  CB  ALA A 114      52.460  14.985 -10.149  1.00 21.06           C  
ATOM    834  N   GLY A 115      52.706  11.640  -9.354  1.00 24.45           N  
ATOM    835  CA  GLY A 115      52.601  10.682  -8.269  1.00 22.86           C  
ATOM    836  C   GLY A 115      51.580  11.035  -7.199  1.00 21.83           C  
ATOM    837  O   GLY A 115      51.638  10.516  -6.087  1.00 23.34           O  
ATOM    838  N   ILE A 116      50.651  11.929  -7.522  1.00 20.43           N  
ATOM    839  CA  ILE A 116      49.606  12.289  -6.554  1.00 19.05           C  
ATOM    840  C   ILE A 116      48.311  11.520  -6.793  1.00 20.31           C  
ATOM    841  O   ILE A 116      48.057  10.985  -7.889  1.00 19.74           O  
ATOM    842  CB  ILE A 116      49.351  13.827  -6.544  1.00 19.37           C  
ATOM    843  CG1 ILE A 116      48.633  14.259  -7.822  1.00 19.60           C  
ATOM    844  CG2 ILE A 116      50.727  14.616  -6.360  1.00 18.87           C  
ATOM    845  CD1 ILE A 116      48.198  15.713  -7.827  1.00 19.70           C  
ATOM    846  N   THR A 117      47.502  11.467  -5.748  1.00 18.29           N  
ATOM    847  CA  THR A 117      46.155  10.882  -5.840  1.00 19.08           C  
ATOM    848  C   THR A 117      45.125  12.009  -5.809  1.00 20.87           C  
ATOM    849  O   THR A 117      45.112  12.803  -4.857  1.00 21.52           O  
ATOM    850  CB  THR A 117      45.929   9.916  -4.681  1.00 22.18           C  
ATOM    851  OG1 THR A 117      46.946   8.903  -4.728  1.00 22.93           O  
ATOM    852  CG2 THR A 117      44.531   9.257  -4.757  1.00 21.37           C  
ATOM    853  N   VAL A 118      44.293  12.093  -6.846  1.00 17.19           N  
ATOM    854  CA  VAL A 118      43.173  13.025  -6.849  1.00 19.99           C  
ATOM    855  C   VAL A 118      41.928  12.145  -6.781  1.00 19.63           C  
ATOM    856  O   VAL A 118      41.594  11.471  -7.745  1.00 22.49           O  
ATOM    857  CB  VAL A 118      43.177  13.882  -8.116  1.00 19.61           C  
ATOM    858  CG1 VAL A 118      41.952  14.826  -8.154  1.00 19.78           C  
ATOM    859  CG2 VAL A 118      44.513  14.700  -8.216  1.00 20.49           C  
ATOM    860  N   MET A 119      41.263  12.130  -5.636  1.00 21.36           N  
ATOM    861  CA  MET A 119      40.050  11.329  -5.480  1.00 20.04           C  
ATOM    862  C   MET A 119      38.849  12.208  -5.779  1.00 21.63           C  
ATOM    863  O   MET A 119      38.755  13.320  -5.275  1.00 23.98           O  
ATOM    864  CB  MET A 119      39.966  10.766  -4.062  1.00 19.34           C  
ATOM    865  CG  MET A 119      38.713   9.958  -3.778  1.00 19.91           C  
ATOM    866  SD  MET A 119      38.709   8.472  -4.849  1.00 20.74           S  
ATOM    867  CE  MET A 119      36.988   7.918  -4.723  1.00 21.50           C  
ATOM    868  N   ASN A 120      37.937  11.704  -6.600  1.00 18.36           N  
ATOM    869  CA  ASN A 120      36.814  12.492  -7.088  1.00 18.63           C  
ATOM    870  C   ASN A 120      35.513  11.800  -6.788  1.00 17.97           C  
ATOM    871  O   ASN A 120      35.512  10.639  -6.371  1.00 17.48           O  
ATOM    872  CB  ASN A 120      36.892  12.683  -8.605  1.00 18.53           C  
ATOM    873  CG  ASN A 120      38.239  13.210  -9.074  1.00 21.19           C  
ATOM    874  OD1 ASN A 120      38.413  14.415  -9.230  1.00 21.95           O  
ATOM    875  ND2 ASN A 120      39.191  12.305  -9.320  1.00 19.07           N  
ATOM    876  N   GLU A 121      34.417  12.542  -7.008  1.00 18.86           N  
ATOM    877  CA  GLU A 121      33.052  11.989  -7.066  1.00 20.23           C  
ATOM    878  C   GLU A 121      32.697  11.198  -5.820  1.00 18.93           C  
ATOM    879  O   GLU A 121      32.143  10.104  -5.901  1.00 20.36           O  
ATOM    880  CB  GLU A 121      32.917  11.108  -8.319  1.00 22.15           C  
ATOM    881  CG  GLU A 121      32.999  11.922  -9.617  1.00 22.31           C  
ATOM    882  CD  GLU A 121      32.830  11.110 -10.909  1.00 24.82           C  
ATOM    883  OE1 GLU A 121      32.279   9.991 -10.886  1.00 23.46           O  
ATOM    884  OE2 GLU A 121      33.240  11.641 -11.967  1.00 28.12           O  
ATOM    885  N   ILE A 122      33.043  11.724  -4.654  1.00 16.29           N  
ATOM    886  CA  ILE A 122      32.791  10.967  -3.418  1.00 16.99           C  
ATOM    887  C   ILE A 122      32.010  11.795  -2.363  1.00 19.50           C  
ATOM    888  O   ILE A 122      32.408  11.902  -1.206  1.00 23.49           O  
ATOM    889  CB  ILE A 122      34.098  10.272  -2.887  1.00 18.63           C  
ATOM    890  CG1 ILE A 122      33.833   9.237  -1.785  1.00 18.06           C  
ATOM    891  CG2 ILE A 122      35.159  11.308  -2.373  1.00 17.53           C  
ATOM    892  CD1 ILE A 122      32.724   8.185  -2.101  1.00 16.48           C  
ATOM    893  N   GLY A 123      30.884  12.363  -2.778  1.00 18.62           N  
ATOM    894  CA  GLY A 123      29.892  12.832  -1.786  1.00 16.10           C  
ATOM    895  C   GLY A 123      28.686  11.903  -1.790  1.00 17.58           C  
ATOM    896  O   GLY A 123      28.805  10.665  -1.621  1.00 16.49           O  
ATOM    897  N   LEU A 124      27.508  12.483  -2.011  1.00 18.34           N  
ATOM    898  CA  LEU A 124      26.272  11.714  -2.080  1.00 17.09           C  
ATOM    899  C   LEU A 124      25.938  11.268  -3.499  1.00 18.79           C  
ATOM    900  O   LEU A 124      25.650  10.093  -3.766  1.00 20.50           O  
ATOM    901  CB  LEU A 124      25.125  12.588  -1.550  1.00 19.83           C  
ATOM    902  CG  LEU A 124      23.722  12.056  -1.842  1.00 20.78           C  
ATOM    903  CD1 LEU A 124      23.469  10.741  -1.093  1.00 19.78           C  
ATOM    904  CD2 LEU A 124      22.738  13.110  -1.445  1.00 22.20           C  
ATOM    905  N   ASP A 125      25.969  12.242  -4.402  1.00 21.51           N  
ATOM    906  CA  ASP A 125      25.492  12.121  -5.761  1.00 25.71           C  
ATOM    907  C   ASP A 125      26.296  13.119  -6.591  1.00 24.91           C  
ATOM    908  O   ASP A 125      25.864  14.255  -6.782  1.00 26.45           O  
ATOM    909  CB  ASP A 125      23.983  12.449  -5.821  1.00 32.11           C  
ATOM    910  CG  ASP A 125      23.459  12.611  -7.249  1.00 39.25           C  
ATOM    911  OD1 ASP A 125      24.020  11.986  -8.193  1.00 40.66           O  
ATOM    912  OD2 ASP A 125      22.466  13.360  -7.421  1.00 41.20           O  
ATOM    913  N   PRO A 126      27.476  12.714  -7.086  1.00 23.24           N  
ATOM    914  CA  PRO A 126      28.053  11.364  -7.051  1.00 20.41           C  
ATOM    915  C   PRO A 126      28.759  11.008  -5.760  1.00 18.95           C  
ATOM    916  O   PRO A 126      29.346  11.877  -5.081  1.00 19.15           O  
ATOM    917  CB  PRO A 126      29.066  11.390  -8.209  1.00 20.05           C  
ATOM    918  CG  PRO A 126      29.494  12.832  -8.299  1.00 20.20           C  
ATOM    919  CD  PRO A 126      28.353  13.672  -7.801  1.00 21.45           C  
ATOM    920  N   GLY A 127      28.719   9.718  -5.429  1.00 16.30           N  
ATOM    921  CA  GLY A 127      29.522   9.181  -4.345  1.00 17.59           C  
ATOM    922  C   GLY A 127      28.822   7.957  -3.802  1.00 18.04           C  
ATOM    923  O   GLY A 127      28.967   6.839  -4.321  1.00 18.95           O  
ATOM    924  N   ILE A 128      27.996   8.197  -2.790  1.00 17.51           N  
ATOM    925  CA  ILE A 128      27.250   7.111  -2.153  1.00 18.32           C  
ATOM    926  C   ILE A 128      26.455   6.305  -3.146  1.00 17.08           C  
ATOM    927  O   ILE A 128      26.403   5.052  -3.029  1.00 15.18           O  
ATOM    928  CB  ILE A 128      26.363   7.648  -1.008  1.00 17.39           C  
ATOM    929  CG1 ILE A 128      27.242   8.133   0.174  1.00 20.24           C  
ATOM    930  CG2 ILE A 128      25.326   6.576  -0.573  1.00 22.79           C  
ATOM    931  CD1 ILE A 128      26.433   8.848   1.336  1.00 20.29           C  
ATOM    932  N   ASP A 129      25.864   6.978  -4.137  1.00 15.62           N  
ATOM    933  CA  ASP A 129      25.123   6.275  -5.177  1.00 18.52           C  
ATOM    934  C   ASP A 129      26.017   5.268  -5.914  1.00 19.20           C  
ATOM    935  O   ASP A 129      25.629   4.087  -6.069  1.00 18.90           O  
ATOM    936  CB  ASP A 129      24.410   7.239  -6.164  1.00 20.21           C  
ATOM    937  CG  ASP A 129      25.378   8.253  -6.889  1.00 22.61           C  
ATOM    938  OD1 ASP A 129      26.591   8.341  -6.613  1.00 20.52           O  
ATOM    939  OD2 ASP A 129      24.884   9.005  -7.751  1.00 25.90           O  
ATOM    940  N   HIS A 130      27.207   5.705  -6.329  1.00 19.27           N  
ATOM    941  CA  HIS A 130      28.135   4.788  -7.010  1.00 14.38           C  
ATOM    942  C   HIS A 130      28.517   3.588  -6.127  1.00 14.84           C  
ATOM    943  O   HIS A 130      28.622   2.457  -6.625  1.00 19.32           O  
ATOM    944  CB  HIS A 130      29.450   5.493  -7.389  1.00 20.28           C  
ATOM    945  CG  HIS A 130      29.305   6.525  -8.459  1.00 21.43           C  
ATOM    946  ND1 HIS A 130      30.071   7.673  -8.482  1.00 26.13           N  
ATOM    947  CD2 HIS A 130      28.493   6.592  -9.538  1.00 20.86           C  
ATOM    948  CE1 HIS A 130      29.742   8.394  -9.537  1.00 23.28           C  
ATOM    949  NE2 HIS A 130      28.789   7.760 -10.194  1.00 27.31           N  
ATOM    950  N   LEU A 131      28.748   3.828  -4.841  1.00 13.82           N  
ATOM    951  CA  LEU A 131      29.235   2.774  -3.938  1.00 14.80           C  
ATOM    952  C   LEU A 131      28.262   1.606  -4.001  1.00 17.81           C  
ATOM    953  O   LEU A 131      28.660   0.431  -4.184  1.00 18.09           O  
ATOM    954  CB  LEU A 131      29.325   3.285  -2.498  1.00 16.97           C  
ATOM    955  CG  LEU A 131      30.295   4.454  -2.221  1.00 17.04           C  
ATOM    956  CD1 LEU A 131      30.133   4.966  -0.763  1.00 18.38           C  
ATOM    957  CD2 LEU A 131      31.748   4.147  -2.516  1.00 18.06           C  
ATOM    958  N   TYR A 132      26.992   1.942  -3.843  1.00 16.77           N  
ATOM    959  CA  TYR A 132      25.961   0.897  -3.713  1.00 19.12           C  
ATOM    960  C   TYR A 132      25.490   0.346  -5.061  1.00 19.74           C  
ATOM    961  O   TYR A 132      25.072  -0.808  -5.121  1.00 20.78           O  
ATOM    962  CB  TYR A 132      24.797   1.354  -2.814  1.00 16.75           C  
ATOM    963  CG  TYR A 132      25.187   1.271  -1.348  1.00 17.91           C  
ATOM    964  CD1 TYR A 132      25.841   2.345  -0.707  1.00 16.06           C  
ATOM    965  CD2 TYR A 132      24.948   0.116  -0.602  1.00 16.03           C  
ATOM    966  CE1 TYR A 132      26.207   2.265   0.642  1.00 15.92           C  
ATOM    967  CE2 TYR A 132      25.317   0.019   0.724  1.00 17.29           C  
ATOM    968  CZ  TYR A 132      25.949   1.098   1.346  1.00 17.49           C  
ATOM    969  OH  TYR A 132      26.317   1.010   2.673  1.00 19.00           O  
ATOM    970  N   ALA A 133      25.527   1.164  -6.114  1.00 17.38           N  
ATOM    971  CA  ALA A 133      25.222   0.663  -7.443  1.00 17.22           C  
ATOM    972  C   ALA A 133      26.286  -0.356  -7.868  1.00 20.32           C  
ATOM    973  O   ALA A 133      25.974  -1.461  -8.297  1.00 20.39           O  
ATOM    974  CB  ALA A 133      25.137   1.798  -8.459  1.00 18.27           C  
ATOM    975  N   VAL A 134      27.548   0.014  -7.714  1.00 17.41           N  
ATOM    976  CA  VAL A 134      28.636  -0.899  -8.087  1.00 19.58           C  
ATOM    977  C   VAL A 134      28.537  -2.183  -7.273  1.00 21.34           C  
ATOM    978  O   VAL A 134      28.740  -3.256  -7.814  1.00 23.34           O  
ATOM    979  CB  VAL A 134      30.017  -0.209  -7.946  1.00 20.74           C  
ATOM    980  CG1 VAL A 134      31.201  -1.245  -8.014  1.00 19.80           C  
ATOM    981  CG2 VAL A 134      30.134   0.874  -9.005  1.00 19.59           C  
ATOM    982  N   LYS A 135      28.162  -2.063  -5.998  1.00 20.17           N  
ATOM    983  CA  LYS A 135      28.152  -3.200  -5.075  1.00 22.41           C  
ATOM    984  C   LYS A 135      27.244  -4.315  -5.599  1.00 23.16           C  
ATOM    985  O   LYS A 135      27.656  -5.474  -5.741  1.00 21.33           O  
ATOM    986  CB  LYS A 135      27.703  -2.744  -3.683  1.00 17.67           C  
ATOM    987  CG  LYS A 135      27.587  -3.876  -2.637  1.00 24.52           C  
ATOM    988  CD  LYS A 135      27.126  -3.329  -1.285  1.00 23.50           C  
ATOM    989  CE  LYS A 135      27.282  -4.337  -0.168  1.00 27.16           C  
ATOM    990  NZ  LYS A 135      26.235  -5.361  -0.273  1.00 32.03           N  
ATOM    991  N   THR A 136      26.003  -3.944  -5.876  1.00 19.79           N  
ATOM    992  CA  THR A 136      24.999  -4.902  -6.332  1.00 20.54           C  
ATOM    993  C   THR A 136      25.329  -5.418  -7.725  1.00 23.02           C  
ATOM    994  O   THR A 136      25.220  -6.607  -7.972  1.00 24.47           O  
ATOM    995  CB  THR A 136      23.581  -4.286  -6.314  1.00 22.35           C  
ATOM    996  OG1 THR A 136      23.202  -4.007  -4.952  1.00 22.35           O  
ATOM    997  CG2 THR A 136      22.561  -5.268  -6.945  1.00 19.75           C  
ATOM    998  N   ILE A 137      25.726  -4.534  -8.642  1.00 16.37           N  
ATOM    999  CA  ILE A 137      26.012  -4.972 -10.012  1.00 20.60           C  
ATOM   1000  C   ILE A 137      27.184  -5.978 -10.000  1.00 23.66           C  
ATOM   1001  O   ILE A 137      27.143  -7.012 -10.692  1.00 26.97           O  
ATOM   1002  CB  ILE A 137      26.283  -3.761 -10.912  1.00 21.12           C  
ATOM   1003  CG1 ILE A 137      24.978  -2.966 -11.095  1.00 21.08           C  
ATOM   1004  CG2 ILE A 137      26.899  -4.165 -12.288  1.00 22.42           C  
ATOM   1005  CD1 ILE A 137      25.205  -1.521 -11.599  1.00 22.12           C  
ATOM   1006  N   ASP A 138      28.186  -5.701  -9.170  1.00 21.85           N  
ATOM   1007  CA  ASP A 138      29.323  -6.606  -9.006  1.00 23.92           C  
ATOM   1008  C   ASP A 138      28.843  -7.970  -8.478  1.00 27.64           C  
ATOM   1009  O   ASP A 138      29.190  -9.014  -9.027  1.00 28.78           O  
ATOM   1010  CB  ASP A 138      30.404  -5.999  -8.093  1.00 25.96           C  
ATOM   1011  CG  ASP A 138      31.545  -6.983  -7.794  1.00 27.46           C  
ATOM   1012  OD1 ASP A 138      32.263  -7.379  -8.744  1.00 28.06           O  
ATOM   1013  OD2 ASP A 138      31.695  -7.381  -6.620  1.00 27.17           O  
ATOM   1014  N   GLU A 139      28.036  -7.955  -7.421  1.00 27.68           N  
ATOM   1015  CA  GLU A 139      27.400  -9.184  -6.903  1.00 29.08           C  
ATOM   1016  C   GLU A 139      26.582  -9.931  -7.958  1.00 27.82           C  
ATOM   1017  O   GLU A 139      26.674 -11.152  -8.063  1.00 28.15           O  
ATOM   1018  CB  GLU A 139      26.497  -8.864  -5.712  1.00 28.42           C  
ATOM   1019  CG  GLU A 139      27.266  -8.601  -4.430  1.00 31.64           C  
ATOM   1020  CD  GLU A 139      26.396  -8.029  -3.303  1.00 31.89           C  
ATOM   1021  OE1 GLU A 139      25.147  -8.148  -3.366  1.00 33.15           O  
ATOM   1022  OE2 GLU A 139      26.974  -7.471  -2.334  1.00 34.72           O  
ATOM   1023  N   VAL A 140      25.790  -9.206  -8.740  1.00 24.58           N  
ATOM   1024  CA  VAL A 140      24.953  -9.827  -9.767  1.00 25.07           C  
ATOM   1025  C   VAL A 140      25.838 -10.466 -10.846  1.00 27.92           C  
ATOM   1026  O   VAL A 140      25.630 -11.626 -11.205  1.00 25.52           O  
ATOM   1027  CB  VAL A 140      23.968  -8.818 -10.389  1.00 24.29           C  
ATOM   1028  CG1 VAL A 140      23.269  -9.411 -11.612  1.00 25.01           C  
ATOM   1029  CG2 VAL A 140      22.932  -8.404  -9.356  1.00 21.16           C  
ATOM   1030  N   HIS A 141      26.835  -9.729 -11.336  1.00 28.05           N  
ATOM   1031  CA  HIS A 141      27.737 -10.263 -12.380  1.00 26.91           C  
ATOM   1032  C   HIS A 141      28.560 -11.468 -11.920  1.00 31.76           C  
ATOM   1033  O   HIS A 141      28.663 -12.450 -12.657  1.00 31.62           O  
ATOM   1034  CB  HIS A 141      28.630  -9.160 -12.955  1.00 26.47           C  
ATOM   1035  CG  HIS A 141      27.906  -8.230 -13.869  1.00 23.82           C  
ATOM   1036  ND1 HIS A 141      28.398  -6.990 -14.209  1.00 25.61           N  
ATOM   1037  CD2 HIS A 141      26.718  -8.355 -14.511  1.00 21.22           C  
ATOM   1038  CE1 HIS A 141      27.540  -6.389 -15.013  1.00 21.36           C  
ATOM   1039  NE2 HIS A 141      26.515  -7.199 -15.212  1.00 25.31           N  
ATOM   1040  N   ARG A 142      29.118 -11.390 -10.713  1.00 32.66           N  
ATOM   1041  CA  ARG A 142      29.882 -12.495 -10.114  1.00 39.06           C  
ATOM   1042  C   ARG A 142      29.086 -13.804  -9.979  1.00 35.98           C  
ATOM   1043  O   ARG A 142      29.663 -14.890 -10.084  1.00 38.92           O  
ATOM   1044  CB  ARG A 142      30.507 -12.072  -8.772  1.00 39.14           C  
ATOM   1045  CG  ARG A 142      31.888 -11.406  -8.921  1.00 44.04           C  
ATOM   1046  CD  ARG A 142      32.338 -10.552  -7.708  1.00 45.59           C  
ATOM   1047  NE  ARG A 142      32.215 -11.228  -6.406  1.00 51.71           N  
ATOM   1048  CZ  ARG A 142      31.483 -10.785  -5.374  1.00 52.73           C  
ATOM   1049  NH1 ARG A 142      30.794  -9.652  -5.449  1.00 52.47           N  
ATOM   1050  NH2 ARG A 142      31.445 -11.481  -4.244  1.00 55.09           N  
ATOM   1051  N   ALA A 143      27.775 -13.703  -9.774  1.00 36.28           N  
ATOM   1052  CA  ALA A 143      26.891 -14.877  -9.709  1.00 36.55           C  
ATOM   1053  C   ALA A 143      26.333 -15.299 -11.087  1.00 38.93           C  
ATOM   1054  O   ALA A 143      25.361 -16.065 -11.166  1.00 42.53           O  
ATOM   1055  CB  ALA A 143      25.759 -14.630  -8.730  1.00 35.51           C  
ATOM   1056  N   GLY A 144      26.949 -14.801 -12.162  1.00 37.69           N  
ATOM   1057  CA  GLY A 144      26.493 -15.053 -13.526  1.00 34.25           C  
ATOM   1058  C   GLY A 144      25.154 -14.445 -13.887  1.00 35.38           C  
ATOM   1059  O   GLY A 144      24.498 -14.895 -14.831  1.00 35.93           O  
ATOM   1060  N   GLY A 145      24.743 -13.417 -13.146  1.00 31.39           N  
ATOM   1061  CA  GLY A 145      23.451 -12.772 -13.392  1.00 31.27           C  
ATOM   1062  C   GLY A 145      23.539 -11.620 -14.376  1.00 26.87           C  
ATOM   1063  O   GLY A 145      24.618 -11.089 -14.609  1.00 24.70           O  
ATOM   1064  N   LYS A 146      22.391 -11.258 -14.941  1.00 27.98           N  
ATOM   1065  CA  LYS A 146      22.256 -10.125 -15.854  1.00 28.11           C  
ATOM   1066  C   LYS A 146      21.479  -8.988 -15.206  1.00 27.78           C  
ATOM   1067  O   LYS A 146      20.376  -9.174 -14.663  1.00 24.28           O  
ATOM   1068  CB  LYS A 146      21.524 -10.509 -17.135  1.00 32.19           C  
ATOM   1069  CG  LYS A 146      22.227 -11.574 -17.994  1.00 36.59           C  
ATOM   1070  CD  LYS A 146      21.464 -11.788 -19.283  1.00 39.73           C  
ATOM   1071  CE  LYS A 146      22.290 -12.631 -20.248  1.00 41.88           C  
ATOM   1072  NZ  LYS A 146      21.459 -13.115 -21.391  1.00 45.89           N  
ATOM   1073  N   LEU A 147      22.022  -7.785 -15.332  1.00 25.31           N  
ATOM   1074  CA  LEU A 147      21.322  -6.626 -14.809  1.00 22.64           C  
ATOM   1075  C   LEU A 147      20.424  -6.093 -15.905  1.00 23.47           C  
ATOM   1076  O   LEU A 147      20.858  -5.315 -16.738  1.00 23.37           O  
ATOM   1077  CB  LEU A 147      22.332  -5.565 -14.316  1.00 24.26           C  
ATOM   1078  CG  LEU A 147      21.961  -4.677 -13.132  1.00 21.36           C  
ATOM   1079  CD1 LEU A 147      20.721  -3.894 -13.419  1.00 25.34           C  
ATOM   1080  CD2 LEU A 147      21.773  -5.561 -11.876  1.00 23.34           C  
ATOM   1081  N   LYS A 148      19.166  -6.517 -15.910  1.00 24.35           N  
ATOM   1082  CA  LYS A 148      18.226  -6.134 -16.947  1.00 23.89           C  
ATOM   1083  C   LYS A 148      17.689  -4.717 -16.799  1.00 23.44           C  
ATOM   1084  O   LYS A 148      17.371  -4.080 -17.785  1.00 23.90           O  
ATOM   1085  CB  LYS A 148      17.019  -7.083 -16.956  1.00 26.87           C  
ATOM   1086  CG  LYS A 148      17.328  -8.502 -17.430  1.00 31.72           C  
ATOM   1087  CD  LYS A 148      17.704  -8.497 -18.905  1.00 34.61           C  
ATOM   1088  CE  LYS A 148      17.888  -9.907 -19.440  1.00 36.79           C  
ATOM   1089  NZ  LYS A 148      17.869  -9.871 -20.942  1.00 37.42           N  
ATOM   1090  N   SER A 149      17.538  -4.247 -15.561  1.00 22.61           N  
ATOM   1091  CA  SER A 149      16.977  -2.912 -15.309  1.00 21.78           C  
ATOM   1092  C   SER A 149      17.718  -2.234 -14.160  1.00 21.52           C  
ATOM   1093  O   SER A 149      17.950  -2.850 -13.109  1.00 16.82           O  
ATOM   1094  CB  SER A 149      15.487  -3.007 -14.970  1.00 20.31           C  
ATOM   1095  OG  SER A 149      15.004  -1.688 -14.705  1.00 21.81           O  
ATOM   1096  N   PHE A 150      18.134  -0.996 -14.381  1.00 19.01           N  
ATOM   1097  CA  PHE A 150      18.663  -0.163 -13.328  1.00 19.06           C  
ATOM   1098  C   PHE A 150      17.856   1.124 -13.251  1.00 20.64           C  
ATOM   1099  O   PHE A 150      17.829   1.894 -14.230  1.00 20.22           O  
ATOM   1100  CB  PHE A 150      20.124   0.197 -13.610  1.00 20.21           C  
ATOM   1101  CG  PHE A 150      20.741   1.096 -12.571  1.00 22.56           C  
ATOM   1102  CD1 PHE A 150      20.912   0.660 -11.256  1.00 22.21           C  
ATOM   1103  CD2 PHE A 150      21.168   2.375 -12.915  1.00 22.78           C  
ATOM   1104  CE1 PHE A 150      21.511   1.468 -10.287  1.00 24.81           C  
ATOM   1105  CE2 PHE A 150      21.768   3.215 -11.958  1.00 23.82           C  
ATOM   1106  CZ  PHE A 150      21.947   2.757 -10.637  1.00 23.43           C  
ATOM   1107  N   LEU A 151      17.196   1.343 -12.105  1.00 17.22           N  
ATOM   1108  CA  LEU A 151      16.444   2.576 -11.835  1.00 19.25           C  
ATOM   1109  C   LEU A 151      17.063   3.218 -10.623  1.00 18.35           C  
ATOM   1110  O   LEU A 151      17.424   2.517  -9.675  1.00 20.38           O  
ATOM   1111  CB  LEU A 151      14.966   2.258 -11.550  1.00 21.48           C  
ATOM   1112  CG  LEU A 151      14.151   1.675 -12.719  1.00 21.98           C  
ATOM   1113  CD1 LEU A 151      12.689   1.373 -12.310  1.00 21.68           C  
ATOM   1114  CD2 LEU A 151      14.174   2.612 -13.930  1.00 23.26           C  
ATOM   1115  N   SER A 152      17.232   4.534 -10.633  1.00 16.52           N  
ATOM   1116  CA  SER A 152      17.883   5.192  -9.519  1.00 16.39           C  
ATOM   1117  C   SER A 152      17.294   6.572  -9.368  1.00 16.01           C  
ATOM   1118  O   SER A 152      17.262   7.336 -10.330  1.00 20.32           O  
ATOM   1119  CB  SER A 152      19.386   5.299  -9.753  1.00 19.95           C  
ATOM   1120  OG  SER A 152      20.013   5.825  -8.601  1.00 20.28           O  
ATOM   1121  N   TYR A 153      16.786   6.864  -8.177  1.00 17.85           N  
ATOM   1122  CA  TYR A 153      16.095   8.143  -7.953  1.00 17.28           C  
ATOM   1123  C   TYR A 153      16.581   8.769  -6.660  1.00 17.72           C  
ATOM   1124  O   TYR A 153      16.801   8.080  -5.661  1.00 18.37           O  
ATOM   1125  CB  TYR A 153      14.580   7.930  -7.955  1.00 16.41           C  
ATOM   1126  CG  TYR A 153      14.039   7.609  -9.322  1.00 17.01           C  
ATOM   1127  CD1 TYR A 153      13.702   8.619 -10.225  1.00 17.67           C  
ATOM   1128  CD2 TYR A 153      13.851   6.277  -9.717  1.00 14.54           C  
ATOM   1129  CE1 TYR A 153      13.228   8.318 -11.474  1.00 17.43           C  
ATOM   1130  CE2 TYR A 153      13.360   5.965 -10.954  1.00 18.52           C  
ATOM   1131  CZ  TYR A 153      13.033   6.985 -11.833  1.00 17.60           C  
ATOM   1132  OH  TYR A 153      12.541   6.669 -13.069  1.00 17.87           O  
ATOM   1133  N   CYS A 154      16.781  10.083  -6.678  1.00 16.95           N  
ATOM   1134  CA  CYS A 154      17.354  10.758  -5.534  1.00 16.60           C  
ATOM   1135  C   CYS A 154      16.740  12.154  -5.421  1.00 15.94           C  
ATOM   1136  O   CYS A 154      16.466  12.788  -6.433  1.00 17.18           O  
ATOM   1137  CB  CYS A 154      18.891  10.851  -5.680  1.00 19.36           C  
ATOM   1138  SG  CYS A 154      19.800  11.549  -4.272  1.00 23.27           S  
ATOM   1139  N   GLY A 155      16.524  12.610  -4.198  1.00 17.14           N  
ATOM   1140  CA  GLY A 155      16.098  13.976  -3.954  1.00 17.66           C  
ATOM   1141  C   GLY A 155      16.557  14.483  -2.597  1.00 15.35           C  
ATOM   1142  O   GLY A 155      16.705  13.716  -1.634  1.00 17.70           O  
ATOM   1143  N   GLY A 156      16.787  15.790  -2.518  1.00 17.95           N  
ATOM   1144  CA  GLY A 156      16.998  16.475  -1.248  1.00 15.59           C  
ATOM   1145  C   GLY A 156      15.753  17.309  -0.999  1.00 17.75           C  
ATOM   1146  O   GLY A 156      15.453  18.233  -1.756  1.00 15.89           O  
ATOM   1147  N   LEU A 157      15.023  16.979   0.062  1.00 16.15           N  
ATOM   1148  CA  LEU A 157      13.684  17.555   0.289  1.00 15.16           C  
ATOM   1149  C   LEU A 157      13.494  17.937   1.740  1.00 14.25           C  
ATOM   1150  O   LEU A 157      14.226  17.448   2.586  1.00 13.43           O  
ATOM   1151  CB  LEU A 157      12.599  16.533  -0.141  1.00 16.40           C  
ATOM   1152  CG  LEU A 157      12.543  16.121  -1.620  1.00 15.18           C  
ATOM   1153  CD1 LEU A 157      11.650  14.863  -1.781  1.00 15.33           C  
ATOM   1154  CD2 LEU A 157      12.154  17.269  -2.576  1.00 14.44           C  
ATOM   1155  N   PRO A 158      12.473  18.793   2.050  1.00 15.77           N  
ATOM   1156  CA  PRO A 158      12.162  18.986   3.473  1.00 13.93           C  
ATOM   1157  C   PRO A 158      11.684  17.674   4.083  1.00 12.63           C  
ATOM   1158  O   PRO A 158      11.112  16.850   3.365  1.00 15.14           O  
ATOM   1159  CB  PRO A 158      11.019  20.006   3.478  1.00 15.23           C  
ATOM   1160  CG  PRO A 158      10.815  20.422   2.059  1.00 15.07           C  
ATOM   1161  CD  PRO A 158      11.616  19.580   1.143  1.00 16.16           C  
ATOM   1162  N   ALA A 159      11.943  17.454   5.368  1.00 14.62           N  
ATOM   1163  CA  ALA A 159      11.210  16.391   6.092  1.00 15.09           C  
ATOM   1164  C   ALA A 159       9.711  16.657   5.820  1.00 15.86           C  
ATOM   1165  O   ALA A 159       9.288  17.817   5.631  1.00 15.99           O  
ATOM   1166  CB  ALA A 159      11.524  16.433   7.572  1.00 15.61           C  
ATOM   1167  N   PRO A 160       8.900  15.583   5.716  1.00 14.67           N  
ATOM   1168  CA  PRO A 160       7.477  15.753   5.391  1.00 15.76           C  
ATOM   1169  C   PRO A 160       6.721  16.712   6.305  1.00 12.05           C  
ATOM   1170  O   PRO A 160       5.902  17.493   5.796  1.00 16.35           O  
ATOM   1171  CB  PRO A 160       6.908  14.336   5.482  1.00 16.08           C  
ATOM   1172  CG  PRO A 160       8.089  13.413   5.349  1.00 16.94           C  
ATOM   1173  CD  PRO A 160       9.291  14.162   5.883  1.00 15.63           C  
ATOM   1174  N   GLU A 161       7.034  16.690   7.599  1.00 14.52           N  
ATOM   1175  CA  GLU A 161       6.403  17.592   8.584  1.00 13.97           C  
ATOM   1176  C   GLU A 161       6.782  19.042   8.342  1.00 18.60           C  
ATOM   1177  O   GLU A 161       6.047  19.928   8.766  1.00 17.54           O  
ATOM   1178  CB  GLU A 161       6.725  17.194  10.023  1.00 19.15           C  
ATOM   1179  CG  GLU A 161       8.215  17.381  10.434  1.00 17.17           C  
ATOM   1180  CD  GLU A 161       9.098  16.186  10.119  1.00 20.18           C  
ATOM   1181  OE1 GLU A 161       8.709  15.317   9.304  1.00 15.41           O  
ATOM   1182  OE2 GLU A 161      10.198  16.120  10.699  1.00 20.17           O  
ATOM   1183  N   ASP A 162       7.894  19.277   7.632  1.00 15.32           N  
ATOM   1184  CA  ASP A 162       8.361  20.628   7.269  1.00 16.38           C  
ATOM   1185  C   ASP A 162       8.120  21.009   5.803  1.00 15.94           C  
ATOM   1186  O   ASP A 162       8.683  21.988   5.312  1.00 18.44           O  
ATOM   1187  CB  ASP A 162       9.853  20.765   7.639  1.00 19.01           C  
ATOM   1188  CG  ASP A 162      10.087  20.586   9.122  1.00 19.47           C  
ATOM   1189  OD1 ASP A 162       9.233  21.077   9.919  1.00 20.23           O  
ATOM   1190  OD2 ASP A 162      11.103  19.980   9.513  1.00 19.02           O  
ATOM   1191  N   SER A 163       7.279  20.245   5.115  1.00 14.84           N  
ATOM   1192  CA  SER A 163       7.068  20.411   3.689  1.00 12.44           C  
ATOM   1193  C   SER A 163       5.892  21.305   3.298  1.00 14.02           C  
ATOM   1194  O   SER A 163       5.610  21.444   2.118  1.00 16.22           O  
ATOM   1195  CB  SER A 163       6.939  19.016   3.020  1.00 14.10           C  
ATOM   1196  OG  SER A 163       5.679  18.446   3.356  1.00 15.35           O  
ATOM   1197  N   ASP A 164       5.265  21.979   4.267  1.00 16.60           N  
ATOM   1198  CA  ASP A 164       4.046  22.719   3.963  1.00 20.09           C  
ATOM   1199  C   ASP A 164       4.295  24.073   3.306  1.00 21.85           C  
ATOM   1200  O   ASP A 164       4.086  25.123   3.916  1.00 20.82           O  
ATOM   1201  CB  ASP A 164       3.172  22.913   5.192  1.00 21.85           C  
ATOM   1202  CG  ASP A 164       1.780  23.497   4.837  1.00 30.63           C  
ATOM   1203  OD1 ASP A 164       1.309  23.296   3.686  1.00 31.37           O  
ATOM   1204  OD2 ASP A 164       1.171  24.148   5.723  1.00 32.86           O  
ATOM   1205  N   ASN A 165       4.714  24.023   2.058  1.00 20.10           N  
ATOM   1206  CA  ASN A 165       4.703  25.186   1.208  1.00 20.11           C  
ATOM   1207  C   ASN A 165       4.244  24.769  -0.183  1.00 22.59           C  
ATOM   1208  O   ASN A 165       4.018  23.587  -0.432  1.00 21.85           O  
ATOM   1209  CB  ASN A 165       6.057  25.929   1.264  1.00 21.19           C  
ATOM   1210  CG  ASN A 165       7.215  25.168   0.603  1.00 18.03           C  
ATOM   1211  OD1 ASN A 165       7.046  24.453  -0.378  1.00 19.17           O  
ATOM   1212  ND2 ASN A 165       8.417  25.368   1.137  1.00 18.97           N  
ATOM   1213  N   PRO A 166       4.006  25.726  -1.094  1.00 22.99           N  
ATOM   1214  CA  PRO A 166       3.443  25.332  -2.356  1.00 21.48           C  
ATOM   1215  C   PRO A 166       4.245  24.370  -3.228  1.00 19.05           C  
ATOM   1216  O   PRO A 166       3.661  23.755  -4.128  1.00 24.98           O  
ATOM   1217  CB  PRO A 166       3.239  26.680  -3.077  1.00 25.27           C  
ATOM   1218  CG  PRO A 166       3.043  27.655  -1.982  1.00 24.08           C  
ATOM   1219  CD  PRO A 166       4.070  27.196  -0.956  1.00 24.87           C  
ATOM   1220  N   LEU A 167       5.551  24.229  -2.997  1.00 16.23           N  
ATOM   1221  CA  LEU A 167       6.352  23.322  -3.796  1.00 18.14           C  
ATOM   1222  C   LEU A 167       6.734  22.054  -3.050  1.00 15.47           C  
ATOM   1223  O   LEU A 167       7.378  21.142  -3.653  1.00 15.32           O  
ATOM   1224  CB  LEU A 167       7.659  24.019  -4.259  1.00 17.27           C  
ATOM   1225  CG  LEU A 167       7.478  25.015  -5.431  1.00 17.22           C  
ATOM   1226  CD1 LEU A 167       8.802  25.735  -5.719  1.00 19.41           C  
ATOM   1227  CD2 LEU A 167       6.943  24.299  -6.707  1.00 17.52           C  
ATOM   1228  N   GLY A 168       6.440  22.019  -1.749  1.00 14.05           N  
ATOM   1229  CA  GLY A 168       7.037  20.998  -0.879  1.00 18.07           C  
ATOM   1230  C   GLY A 168       8.568  20.995  -1.009  1.00 18.31           C  
ATOM   1231  O   GLY A 168       9.197  19.946  -1.071  1.00 18.22           O  
ATOM   1232  N   TYR A 169       9.167  22.183  -1.058  1.00 14.28           N  
ATOM   1233  CA  TYR A 169      10.568  22.303  -1.381  1.00 15.48           C  
ATOM   1234  C   TYR A 169      11.095  23.523  -0.656  1.00 16.23           C  
ATOM   1235  O   TYR A 169      10.399  24.541  -0.559  1.00 19.31           O  
ATOM   1236  CB  TYR A 169      10.770  22.453  -2.909  1.00 15.42           C  
ATOM   1237  CG  TYR A 169      12.206  22.185  -3.293  1.00 17.11           C  
ATOM   1238  CD1 TYR A 169      12.622  20.916  -3.611  1.00 16.88           C  
ATOM   1239  CD2 TYR A 169      13.155  23.213  -3.284  1.00 18.78           C  
ATOM   1240  CE1 TYR A 169      13.967  20.671  -3.929  1.00 16.12           C  
ATOM   1241  CE2 TYR A 169      14.446  22.977  -3.593  1.00 20.18           C  
ATOM   1242  CZ  TYR A 169      14.855  21.712  -3.917  1.00 20.09           C  
ATOM   1243  OH  TYR A 169      16.188  21.508  -4.208  1.00 20.66           O  
ATOM   1244  N   LYS A 170      12.305  23.399  -0.119  1.00 16.42           N  
ATOM   1245  CA  LYS A 170      12.975  24.525   0.530  1.00 22.22           C  
ATOM   1246  C   LYS A 170      14.329  24.785  -0.132  1.00 23.74           C  
ATOM   1247  O   LYS A 170      15.055  23.841  -0.512  1.00 21.44           O  
ATOM   1248  CB  LYS A 170      13.100  24.307   2.056  1.00 22.75           C  
ATOM   1249  CG  LYS A 170      11.784  24.060   2.738  1.00 25.00           C  
ATOM   1250  CD  LYS A 170      11.622  24.777   4.034  1.00 27.40           C  
ATOM   1251  CE  LYS A 170      10.202  24.648   4.507  1.00 27.47           C  
ATOM   1252  NZ  LYS A 170       9.931  25.535   5.632  1.00 32.39           N  
ATOM   1253  N   PHE A 171      14.662  26.072  -0.277  1.00 22.50           N  
ATOM   1254  CA  PHE A 171      15.874  26.501  -0.985  1.00 26.78           C  
ATOM   1255  C   PHE A 171      17.031  26.823  -0.055  1.00 28.86           C  
ATOM   1256  O   PHE A 171      16.842  27.473   0.981  1.00 28.89           O  
ATOM   1257  CB  PHE A 171      15.552  27.708  -1.891  1.00 22.00           C  
ATOM   1258  CG  PHE A 171      14.479  27.406  -2.876  1.00 21.58           C  
ATOM   1259  CD1 PHE A 171      14.752  26.603  -3.972  1.00 20.54           C  
ATOM   1260  CD2 PHE A 171      13.178  27.870  -2.672  1.00 18.39           C  
ATOM   1261  CE1 PHE A 171      13.740  26.247  -4.870  1.00 22.60           C  
ATOM   1262  CE2 PHE A 171      12.147  27.558  -3.582  1.00 19.60           C  
ATOM   1263  CZ  PHE A 171      12.431  26.739  -4.688  1.00 21.04           C  
ATOM   1264  N   SER A 172      18.216  26.351  -0.444  1.00 32.98           N  
ATOM   1265  CA  SER A 172      19.465  26.673   0.255  1.00 39.22           C  
ATOM   1266  C   SER A 172      20.654  26.812  -0.741  1.00 42.41           C  
ATOM   1267  O   SER A 172      21.611  26.042  -0.688  1.00 43.75           O  
ATOM   1268  CB  SER A 172      19.741  25.596   1.300  1.00 38.18           C  
ATOM   1269  OG  SER A 172      19.848  24.337   0.652  1.00 38.23           O  
ATOM   1270  N   TRP A 173      20.633  27.829  -1.601  1.00 44.33           N  
ATOM   1271  CA  TRP A 173      19.761  28.983  -1.430  1.00 47.21           C  
ATOM   1272  C   TRP A 173      18.990  29.387  -2.679  1.00 46.45           C  
ATOM   1273  O   TRP A 173      17.985  30.082  -2.568  1.00 48.52           O  
ATOM   1274  CB  TRP A 173      20.581  30.171  -0.924  1.00 49.50           C  
ATOM   1275  CG  TRP A 173      21.283  29.855   0.344  1.00 50.76           C  
ATOM   1276  CD1 TRP A 173      22.607  29.517   0.499  1.00 50.09           C  
ATOM   1277  CD2 TRP A 173      20.696  29.803   1.642  1.00 49.54           C  
ATOM   1278  NE1 TRP A 173      22.874  29.272   1.831  1.00 50.10           N  
ATOM   1279  CE2 TRP A 173      21.720  29.439   2.551  1.00 49.39           C  
ATOM   1280  CE3 TRP A 173      19.409  30.054   2.134  1.00 49.76           C  
ATOM   1281  CZ2 TRP A 173      21.493  29.311   3.913  1.00 49.61           C  
ATOM   1282  CZ3 TRP A 173      19.183  29.933   3.496  1.00 50.01           C  
ATOM   1283  CH2 TRP A 173      20.217  29.557   4.369  1.00 50.45           C  
ATOM   1284  N   SER A 174      19.451  28.962  -3.853  1.00 45.76           N  
ATOM   1285  CA  SER A 174      18.886  29.447  -5.112  1.00 42.85           C  
ATOM   1286  C   SER A 174      17.853  28.491  -5.684  1.00 40.47           C  
ATOM   1287  O   SER A 174      17.947  27.273  -5.506  1.00 40.52           O  
ATOM   1288  CB  SER A 174      19.992  29.717  -6.137  1.00 44.99           C  
ATOM   1289  OG  SER A 174      20.389  28.530  -6.798  1.00 46.79           O  
ATOM   1290  N   SER A 175      16.884  29.050  -6.397  1.00 31.35           N  
ATOM   1291  CA  SER A 175      15.752  28.286  -6.900  1.00 30.40           C  
ATOM   1292  C   SER A 175      15.747  28.106  -8.409  1.00 27.89           C  
ATOM   1293  O   SER A 175      14.986  27.294  -8.932  1.00 31.09           O  
ATOM   1294  CB  SER A 175      14.471  29.002  -6.501  1.00 30.60           C  
ATOM   1295  OG  SER A 175      14.451  30.248  -7.135  1.00 28.26           O  
ATOM   1296  N   ARG A 176      16.588  28.861  -9.120  1.00 31.65           N  
ATOM   1297  CA  ARG A 176      16.533  28.878 -10.598  1.00 33.83           C  
ATOM   1298  C   ARG A 176      16.674  27.482 -11.231  1.00 30.66           C  
ATOM   1299  O   ARG A 176      15.842  27.070 -12.038  1.00 30.54           O  
ATOM   1300  CB  ARG A 176      17.571  29.855 -11.174  1.00 36.95           C  
ATOM   1301  CG  ARG A 176      17.347  30.243 -12.652  1.00 42.42           C  
ATOM   1302  CD  ARG A 176      18.520  31.096 -13.179  1.00 43.65           C  
ATOM   1303  NE  ARG A 176      18.234  31.759 -14.458  1.00 51.41           N  
ATOM   1304  CZ  ARG A 176      18.420  31.217 -15.667  1.00 53.69           C  
ATOM   1305  NH1 ARG A 176      18.893  29.969 -15.781  1.00 55.75           N  
ATOM   1306  NH2 ARG A 176      18.124  31.916 -16.768  1.00 52.40           N  
ATOM   1307  N   GLY A 177      17.724  26.764 -10.857  1.00 29.08           N  
ATOM   1308  CA  GLY A 177      17.951  25.394 -11.351  1.00 29.49           C  
ATOM   1309  C   GLY A 177      16.832  24.433 -10.984  1.00 30.90           C  
ATOM   1310  O   GLY A 177      16.405  23.616 -11.804  1.00 28.52           O  
ATOM   1311  N   VAL A 178      16.316  24.552  -9.764  1.00 29.43           N  
ATOM   1312  CA  VAL A 178      15.236  23.667  -9.326  1.00 26.93           C  
ATOM   1313  C   VAL A 178      14.032  23.844 -10.213  1.00 26.63           C  
ATOM   1314  O   VAL A 178      13.422  22.879 -10.669  1.00 27.28           O  
ATOM   1315  CB  VAL A 178      14.914  23.914  -7.818  1.00 26.22           C  
ATOM   1316  CG1 VAL A 178      13.583  23.286  -7.401  1.00 24.52           C  
ATOM   1317  CG2 VAL A 178      16.075  23.375  -6.986  1.00 24.22           C  
ATOM   1318  N   LEU A 179      13.742  25.099 -10.518  1.00 26.72           N  
ATOM   1319  CA  LEU A 179      12.596  25.456 -11.340  1.00 28.39           C  
ATOM   1320  C   LEU A 179      12.739  25.004 -12.815  1.00 30.02           C  
ATOM   1321  O   LEU A 179      11.769  24.535 -13.431  1.00 32.79           O  
ATOM   1322  CB  LEU A 179      12.397  26.974 -11.238  1.00 29.92           C  
ATOM   1323  CG  LEU A 179      10.984  27.529 -11.087  1.00 34.26           C  
ATOM   1324  CD1 LEU A 179      10.193  26.804 -10.010  1.00 34.02           C  
ATOM   1325  CD2 LEU A 179      11.021  29.040 -10.817  1.00 31.19           C  
ATOM   1326  N   LEU A 180      13.936  25.144 -13.376  1.00 28.85           N  
ATOM   1327  CA  LEU A 180      14.116  24.900 -14.804  1.00 34.08           C  
ATOM   1328  C   LEU A 180      14.318  23.401 -15.095  1.00 37.07           C  
ATOM   1329  O   LEU A 180      14.243  22.944 -16.253  1.00 34.10           O  
ATOM   1330  CB  LEU A 180      15.257  25.750 -15.358  1.00 34.46           C  
ATOM   1331  CG  LEU A 180      15.029  27.276 -15.410  1.00 35.38           C  
ATOM   1332  CD1 LEU A 180      16.266  27.989 -15.944  1.00 36.03           C  
ATOM   1333  CD2 LEU A 180      13.820  27.623 -16.260  1.00 34.92           C  
ATOM   1334  N   ALA A 181      14.537  22.636 -14.027  1.00 35.35           N  
ATOM   1335  CA  ALA A 181      14.783  21.216 -14.159  1.00 34.33           C  
ATOM   1336  C   ALA A 181      13.655  20.506 -14.893  1.00 34.16           C  
ATOM   1337  O   ALA A 181      13.922  19.581 -15.660  1.00 34.23           O  
ATOM   1338  CB  ALA A 181      15.040  20.584 -12.802  1.00 34.83           C  
ATOM   1339  N   LEU A 182      12.411  20.946 -14.708  1.00 31.30           N  
ATOM   1340  CA  LEU A 182      11.306  20.324 -15.430  1.00 32.33           C  
ATOM   1341  C   LEU A 182      11.149  20.836 -16.866  1.00 30.20           C  
ATOM   1342  O   LEU A 182      10.219  20.435 -17.580  1.00 29.11           O  
ATOM   1343  CB  LEU A 182       9.976  20.427 -14.660  1.00 32.78           C  
ATOM   1344  CG  LEU A 182       9.776  19.410 -13.532  1.00 28.79           C  
ATOM   1345  CD1 LEU A 182       8.618  19.853 -12.716  1.00 29.21           C  
ATOM   1346  CD2 LEU A 182       9.519  18.025 -14.099  1.00 32.56           C  
ATOM   1347  N   ARG A 183      12.054  21.714 -17.278  1.00 34.93           N  
ATOM   1348  CA  ARG A 183      12.106  22.168 -18.681  1.00 38.13           C  
ATOM   1349  C   ARG A 183      13.392  21.707 -19.416  1.00 40.61           C  
ATOM   1350  O   ARG A 183      13.750  22.274 -20.456  1.00 40.64           O  
ATOM   1351  CB  ARG A 183      11.946  23.696 -18.780  1.00 40.80           C  
ATOM   1352  CG  ARG A 183      10.612  24.280 -18.267  1.00 42.11           C  
ATOM   1353  CD  ARG A 183       9.406  24.017 -19.192  1.00 44.17           C  
ATOM   1354  NE  ARG A 183       9.429  24.788 -20.443  1.00 44.95           N  
ATOM   1355  CZ  ARG A 183       8.546  24.636 -21.432  1.00 46.41           C  
ATOM   1356  NH1 ARG A 183       7.557  23.751 -21.325  1.00 46.45           N  
ATOM   1357  NH2 ARG A 183       8.644  25.366 -22.543  1.00 47.42           N  
ATOM   1358  N   ASN A 184      14.075  20.687 -18.875  1.00 37.91           N  
ATOM   1359  CA  ASN A 184      15.239  20.073 -19.521  1.00 36.97           C  
ATOM   1360  C   ASN A 184      14.826  18.894 -20.392  1.00 36.55           C  
ATOM   1361  O   ASN A 184      13.720  18.372 -20.260  1.00 37.08           O  
ATOM   1362  CB  ASN A 184      16.225  19.566 -18.482  1.00 41.02           C  
ATOM   1363  CG  ASN A 184      17.129  20.643 -17.963  1.00 45.08           C  
ATOM   1364  OD1 ASN A 184      17.166  21.748 -18.502  1.00 47.95           O  
ATOM   1365  ND2 ASN A 184      17.866  20.338 -16.901  1.00 45.34           N  
ATOM   1366  N   SER A 185      15.709  18.469 -21.284  1.00 31.20           N  
ATOM   1367  CA  SER A 185      15.466  17.249 -22.018  1.00 29.03           C  
ATOM   1368  C   SER A 185      15.952  16.117 -21.118  1.00 27.47           C  
ATOM   1369  O   SER A 185      16.625  16.361 -20.113  1.00 27.84           O  
ATOM   1370  CB  SER A 185      16.276  17.245 -23.307  1.00 30.90           C  
ATOM   1371  OG  SER A 185      17.656  17.215 -22.980  1.00 31.40           O  
ATOM   1372  N   ALA A 186      15.620  14.883 -21.485  1.00 24.88           N  
ATOM   1373  CA  ALA A 186      16.103  13.715 -20.754  1.00 23.76           C  
ATOM   1374  C   ALA A 186      16.346  12.587 -21.751  1.00 21.64           C  
ATOM   1375  O   ALA A 186      15.567  12.398 -22.683  1.00 24.97           O  
ATOM   1376  CB  ALA A 186      15.062  13.293 -19.698  1.00 23.23           C  
ATOM   1377  N   LYS A 187      17.419  11.825 -21.529  1.00 25.00           N  
ATOM   1378  CA  LYS A 187      17.723  10.673 -22.372  1.00 23.08           C  
ATOM   1379  C   LYS A 187      18.075   9.498 -21.453  1.00 17.74           C  
ATOM   1380  O   LYS A 187      18.850   9.662 -20.530  1.00 19.16           O  
ATOM   1381  CB  LYS A 187      18.874  11.024 -23.356  1.00 25.52           C  
ATOM   1382  CG  LYS A 187      19.387   9.847 -24.208  1.00 29.25           C  
ATOM   1383  CD  LYS A 187      20.484  10.239 -25.230  1.00 29.67           C  
ATOM   1384  CE  LYS A 187      21.667  11.027 -24.611  1.00 33.39           C  
ATOM   1385  NZ  LYS A 187      22.886  11.120 -25.524  1.00 32.20           N  
ATOM   1386  N   TYR A 188      17.497   8.334 -21.722  1.00 18.19           N  
ATOM   1387  CA  TYR A 188      17.674   7.134 -20.885  1.00 23.26           C  
ATOM   1388  C   TYR A 188      17.355   5.895 -21.729  1.00 20.96           C  
ATOM   1389  O   TYR A 188      16.883   6.012 -22.863  1.00 25.11           O  
ATOM   1390  CB  TYR A 188      16.731   7.172 -19.646  1.00 21.84           C  
ATOM   1391  CG  TYR A 188      15.275   7.477 -20.016  1.00 22.34           C  
ATOM   1392  CD1 TYR A 188      14.371   6.457 -20.319  1.00 20.54           C  
ATOM   1393  CD2 TYR A 188      14.810   8.796 -20.056  1.00 22.74           C  
ATOM   1394  CE1 TYR A 188      13.077   6.733 -20.676  1.00 23.10           C  
ATOM   1395  CE2 TYR A 188      13.518   9.082 -20.427  1.00 21.39           C  
ATOM   1396  CZ  TYR A 188      12.651   8.058 -20.717  1.00 22.50           C  
ATOM   1397  OH  TYR A 188      11.346   8.334 -21.087  1.00 27.16           O  
ATOM   1398  N   TRP A 189      17.592   4.720 -21.148  1.00 23.88           N  
ATOM   1399  CA  TRP A 189      17.196   3.441 -21.710  1.00 23.80           C  
ATOM   1400  C   TRP A 189      15.916   2.924 -21.097  1.00 26.09           C  
ATOM   1401  O   TRP A 189      15.757   2.949 -19.861  1.00 23.12           O  
ATOM   1402  CB  TRP A 189      18.273   2.418 -21.437  1.00 23.13           C  
ATOM   1403  CG  TRP A 189      19.466   2.563 -22.325  1.00 24.43           C  
ATOM   1404  CD1 TRP A 189      20.615   3.249 -22.051  1.00 24.18           C  
ATOM   1405  CD2 TRP A 189      19.646   1.965 -23.622  1.00 23.91           C  
ATOM   1406  NE1 TRP A 189      21.500   3.120 -23.103  1.00 22.76           N  
ATOM   1407  CE2 TRP A 189      20.923   2.352 -24.085  1.00 24.89           C  
ATOM   1408  CE3 TRP A 189      18.845   1.153 -24.438  1.00 23.43           C  
ATOM   1409  CZ2 TRP A 189      21.431   1.946 -25.344  1.00 25.41           C  
ATOM   1410  CZ3 TRP A 189      19.355   0.747 -25.711  1.00 23.80           C  
ATOM   1411  CH2 TRP A 189      20.631   1.145 -26.132  1.00 23.77           C  
ATOM   1412  N   LYS A 190      15.019   2.444 -21.964  1.00 26.86           N  
ATOM   1413  CA  LYS A 190      13.790   1.763 -21.546  1.00 28.19           C  
ATOM   1414  C   LYS A 190      13.436   0.609 -22.500  1.00 27.96           C  
ATOM   1415  O   LYS A 190      13.281   0.809 -23.698  1.00 28.43           O  
ATOM   1416  CB  LYS A 190      12.632   2.751 -21.483  1.00 29.82           C  
ATOM   1417  CG  LYS A 190      11.302   2.131 -21.047  1.00 34.73           C  
ATOM   1418  CD  LYS A 190      11.077   2.253 -19.569  1.00 37.69           C  
ATOM   1419  CE  LYS A 190       9.693   1.697 -19.171  1.00 42.87           C  
ATOM   1420  NZ  LYS A 190       9.726   0.222 -18.837  1.00 44.04           N  
ATOM   1421  N   ASP A 191      13.314  -0.596 -21.949  1.00 28.27           N  
ATOM   1422  CA  ASP A 191      12.916  -1.778 -22.712  1.00 28.66           C  
ATOM   1423  C   ASP A 191      13.747  -2.004 -23.964  1.00 26.57           C  
ATOM   1424  O   ASP A 191      13.212  -2.391 -25.005  1.00 29.29           O  
ATOM   1425  CB  ASP A 191      11.432  -1.684 -23.079  1.00 32.35           C  
ATOM   1426  CG  ASP A 191      10.534  -1.602 -21.854  1.00 35.51           C  
ATOM   1427  OD1 ASP A 191      10.942  -2.077 -20.773  1.00 36.00           O  
ATOM   1428  OD2 ASP A 191       9.419  -1.063 -21.982  1.00 36.52           O  
ATOM   1429  N   GLY A 192      15.044  -1.743 -23.859  1.00 23.71           N  
ATOM   1430  CA  GLY A 192      16.006  -2.136 -24.883  1.00 26.41           C  
ATOM   1431  C   GLY A 192      16.128  -1.100 -25.985  1.00 25.10           C  
ATOM   1432  O   GLY A 192      16.780  -1.334 -26.992  1.00 24.96           O  
ATOM   1433  N   LYS A 193      15.552   0.073 -25.759  1.00 24.55           N  
ATOM   1434  CA  LYS A 193      15.684   1.198 -26.676  1.00 26.49           C  
ATOM   1435  C   LYS A 193      15.970   2.456 -25.912  1.00 25.26           C  
ATOM   1436  O   LYS A 193      15.640   2.560 -24.730  1.00 24.62           O  
ATOM   1437  CB  LYS A 193      14.404   1.379 -27.487  1.00 30.58           C  
ATOM   1438  CG  LYS A 193      14.274   0.326 -28.562  1.00 35.66           C  
ATOM   1439  CD  LYS A 193      12.887   0.278 -29.179  1.00 38.52           C  
ATOM   1440  CE  LYS A 193      12.921  -0.602 -30.431  1.00 39.98           C  
ATOM   1441  NZ  LYS A 193      13.119  -2.062 -30.099  1.00 43.71           N  
ATOM   1442  N   ILE A 194      16.584   3.421 -26.582  1.00 23.88           N  
ATOM   1443  CA  ILE A 194      16.759   4.740 -25.977  1.00 24.57           C  
ATOM   1444  C   ILE A 194      15.466   5.549 -26.111  1.00 25.78           C  
ATOM   1445  O   ILE A 194      14.779   5.451 -27.108  1.00 23.98           O  
ATOM   1446  CB  ILE A 194      17.983   5.458 -26.562  1.00 22.99           C  
ATOM   1447  CG1 ILE A 194      19.232   4.879 -25.871  1.00 26.87           C  
ATOM   1448  CG2 ILE A 194      17.917   7.003 -26.377  1.00 21.82           C  
ATOM   1449  CD1 ILE A 194      20.531   5.425 -26.264  1.00 25.35           C  
ATOM   1450  N   GLU A 195      15.105   6.306 -25.071  1.00 28.33           N  
ATOM   1451  CA  GLU A 195      13.993   7.240 -25.177  1.00 30.08           C  
ATOM   1452  C   GLU A 195      14.555   8.574 -24.820  1.00 27.17           C  
ATOM   1453  O   GLU A 195      15.373   8.694 -23.915  1.00 24.44           O  
ATOM   1454  CB  GLU A 195      12.860   6.936 -24.188  1.00 33.32           C  
ATOM   1455  CG  GLU A 195      12.156   5.619 -24.377  1.00 34.84           C  
ATOM   1456  CD  GLU A 195      10.814   5.540 -23.615  1.00 36.69           C  
ATOM   1457  OE1 GLU A 195      10.463   6.454 -22.822  1.00 36.57           O  
ATOM   1458  OE2 GLU A 195      10.110   4.533 -23.818  1.00 39.19           O  
ATOM   1459  N   THR A 196      14.138   9.578 -25.568  1.00 28.98           N  
ATOM   1460  CA  THR A 196      14.501  10.951 -25.265  1.00 30.17           C  
ATOM   1461  C   THR A 196      13.193  11.718 -25.102  1.00 33.89           C  
ATOM   1462  O   THR A 196      12.201  11.436 -25.793  1.00 36.12           O  
ATOM   1463  CB  THR A 196      15.284  11.570 -26.394  1.00 30.24           C  
ATOM   1464  OG1 THR A 196      14.610  11.270 -27.611  1.00 36.13           O  
ATOM   1465  CG2 THR A 196      16.679  10.983 -26.479  1.00 27.63           C  
ATOM   1466  N   VAL A 197      13.201  12.656 -24.162  1.00 32.99           N  
ATOM   1467  CA  VAL A 197      12.061  13.518 -23.882  1.00 33.29           C  
ATOM   1468  C   VAL A 197      12.518  14.956 -24.095  1.00 32.51           C  
ATOM   1469  O   VAL A 197      13.540  15.370 -23.557  1.00 30.43           O  
ATOM   1470  CB  VAL A 197      11.586  13.344 -22.423  1.00 33.08           C  
ATOM   1471  CG1 VAL A 197      10.443  14.267 -22.139  1.00 33.44           C  
ATOM   1472  CG2 VAL A 197      11.163  11.900 -22.153  1.00 34.39           C  
ATOM   1473  N   SER A 198      11.768  15.711 -24.899  1.00 34.51           N  
ATOM   1474  CA  SER A 198      12.116  17.109 -25.142  1.00 36.99           C  
ATOM   1475  C   SER A 198      11.814  17.979 -23.912  1.00 38.41           C  
ATOM   1476  O   SER A 198      11.085  17.551 -22.996  1.00 37.71           O  
ATOM   1477  CB  SER A 198      11.372  17.645 -26.361  1.00 37.20           C  
ATOM   1478  OG  SER A 198       9.979  17.680 -26.111  1.00 37.28           O  
ATOM   1479  N   SER A 199      12.394  19.185 -23.908  1.00 38.60           N  
ATOM   1480  CA  SER A 199      12.161  20.208 -22.884  1.00 42.22           C  
ATOM   1481  C   SER A 199      10.685  20.434 -22.593  1.00 43.32           C  
ATOM   1482  O   SER A 199      10.283  20.494 -21.431  1.00 45.05           O  
ATOM   1483  CB  SER A 199      12.769  21.534 -23.331  1.00 41.74           C  
ATOM   1484  OG  SER A 199      14.131  21.542 -22.999  1.00 45.53           O  
ATOM   1485  N   GLU A 200       9.900  20.570 -23.660  1.00 43.93           N  
ATOM   1486  CA  GLU A 200       8.465  20.797 -23.589  1.00 47.82           C  
ATOM   1487  C   GLU A 200       7.721  19.624 -22.960  1.00 46.04           C  
ATOM   1488  O   GLU A 200       6.690  19.809 -22.309  1.00 46.33           O  
ATOM   1489  CB  GLU A 200       7.891  21.001 -24.997  1.00 50.92           C  
ATOM   1490  CG  GLU A 200       8.444  22.192 -25.755  1.00 58.64           C  
ATOM   1491  CD  GLU A 200       9.778  21.910 -26.468  1.00 60.85           C  
ATOM   1492  OE1 GLU A 200      10.070  20.731 -26.804  1.00 60.84           O  
ATOM   1493  OE2 GLU A 200      10.526  22.893 -26.704  1.00 63.23           O  
ATOM   1494  N   ASP A 201       8.241  18.421 -23.184  1.00 43.98           N  
ATOM   1495  CA  ASP A 201       7.510  17.194 -22.903  1.00 40.87           C  
ATOM   1496  C   ASP A 201       7.893  16.539 -21.592  1.00 37.28           C  
ATOM   1497  O   ASP A 201       7.272  15.553 -21.192  1.00 34.13           O  
ATOM   1498  CB  ASP A 201       7.682  16.209 -24.045  1.00 43.81           C  
ATOM   1499  CG  ASP A 201       6.946  16.649 -25.293  1.00 47.04           C  
ATOM   1500  OD1 ASP A 201       6.071  17.526 -25.171  1.00 49.03           O  
ATOM   1501  OD2 ASP A 201       7.241  16.121 -26.385  1.00 46.93           O  
ATOM   1502  N   LEU A 202       8.919  17.088 -20.947  1.00 35.90           N  
ATOM   1503  CA  LEU A 202       9.426  16.540 -19.697  1.00 35.85           C  
ATOM   1504  C   LEU A 202       8.342  16.556 -18.623  1.00 37.98           C  
ATOM   1505  O   LEU A 202       8.177  15.576 -17.895  1.00 35.83           O  
ATOM   1506  CB  LEU A 202      10.684  17.279 -19.201  1.00 33.35           C  
ATOM   1507  CG  LEU A 202      11.343  16.639 -17.958  1.00 33.18           C  
ATOM   1508  CD1 LEU A 202      11.727  15.179 -18.237  1.00 32.11           C  
ATOM   1509  CD2 LEU A 202      12.536  17.386 -17.456  1.00 32.74           C  
ATOM   1510  N   MET A 203       7.621  17.675 -18.543  1.00 36.24           N  
ATOM   1511  CA  MET A 203       6.587  17.904 -17.533  1.00 36.90           C  
ATOM   1512  C   MET A 203       5.604  16.734 -17.434  1.00 35.88           C  
ATOM   1513  O   MET A 203       5.234  16.299 -16.343  1.00 37.43           O  
ATOM   1514  CB  MET A 203       5.823  19.186 -17.901  1.00 38.54           C  
ATOM   1515  CG  MET A 203       4.719  19.533 -16.920  1.00 41.45           C  
ATOM   1516  SD  MET A 203       5.433  19.749 -15.283  1.00 41.44           S  
ATOM   1517  CE  MET A 203       6.262  21.350 -15.422  1.00 36.36           C  
ATOM   1518  N   ALA A 204       5.201  16.239 -18.598  1.00 35.08           N  
ATOM   1519  CA  ALA A 204       4.194  15.213 -18.732  1.00 34.90           C  
ATOM   1520  C   ALA A 204       4.749  13.865 -18.343  1.00 33.30           C  
ATOM   1521  O   ALA A 204       3.979  12.939 -18.100  1.00 30.72           O  
ATOM   1522  CB  ALA A 204       3.692  15.155 -20.179  1.00 37.12           C  
ATOM   1523  N   THR A 205       6.071  13.745 -18.322  1.00 28.10           N  
ATOM   1524  CA  THR A 205       6.674  12.508 -17.862  1.00 32.15           C  
ATOM   1525  C   THR A 205       6.620  12.348 -16.351  1.00 27.41           C  
ATOM   1526  O   THR A 205       6.764  11.218 -15.851  1.00 27.56           O  
ATOM   1527  CB  THR A 205       8.147  12.346 -18.308  1.00 32.37           C  
ATOM   1528  OG1 THR A 205       9.014  13.177 -17.503  1.00 32.57           O  
ATOM   1529  CG2 THR A 205       8.278  12.659 -19.792  1.00 36.13           C  
ATOM   1530  N   ALA A 206       6.501  13.457 -15.610  1.00 20.76           N  
ATOM   1531  CA  ALA A 206       6.538  13.335 -14.147  1.00 22.58           C  
ATOM   1532  C   ALA A 206       5.418  12.402 -13.673  1.00 19.11           C  
ATOM   1533  O   ALA A 206       4.294  12.437 -14.178  1.00 22.28           O  
ATOM   1534  CB  ALA A 206       6.504  14.687 -13.461  1.00 24.15           C  
ATOM   1535  N   LYS A 207       5.743  11.523 -12.735  1.00 20.05           N  
ATOM   1536  CA  LYS A 207       4.787  10.496 -12.301  1.00 19.65           C  
ATOM   1537  C   LYS A 207       5.101  10.056 -10.867  1.00 21.01           C  
ATOM   1538  O   LYS A 207       6.230  10.234 -10.420  1.00 18.74           O  
ATOM   1539  CB  LYS A 207       4.810   9.302 -13.271  1.00 24.08           C  
ATOM   1540  CG  LYS A 207       6.066   8.511 -13.216  1.00 30.03           C  
ATOM   1541  CD  LYS A 207       6.052   7.389 -14.261  1.00 34.56           C  
ATOM   1542  CE  LYS A 207       7.181   6.382 -13.996  1.00 36.08           C  
ATOM   1543  NZ  LYS A 207       8.504   7.042 -13.988  1.00 34.46           N  
ATOM   1544  N   PRO A 208       4.099   9.515 -10.129  1.00 19.59           N  
ATOM   1545  CA  PRO A 208       4.379   9.014  -8.781  1.00 19.02           C  
ATOM   1546  C   PRO A 208       5.450   7.957  -8.810  1.00 19.32           C  
ATOM   1547  O   PRO A 208       5.537   7.162  -9.759  1.00 19.56           O  
ATOM   1548  CB  PRO A 208       3.044   8.406  -8.342  1.00 19.69           C  
ATOM   1549  CG  PRO A 208       2.020   9.143  -9.127  1.00 21.19           C  
ATOM   1550  CD  PRO A 208       2.670   9.359 -10.475  1.00 20.88           C  
ATOM   1551  N   TYR A 209       6.288   7.966  -7.787  1.00 18.10           N  
ATOM   1552  CA  TYR A 209       7.298   6.967  -7.672  1.00 16.03           C  
ATOM   1553  C   TYR A 209       7.256   6.423  -6.280  1.00 15.76           C  
ATOM   1554  O   TYR A 209       7.637   7.099  -5.322  1.00 16.47           O  
ATOM   1555  CB  TYR A 209       8.698   7.528  -7.976  1.00 18.51           C  
ATOM   1556  CG  TYR A 209       9.706   6.402  -8.061  1.00 20.12           C  
ATOM   1557  CD1 TYR A 209       9.784   5.602  -9.212  1.00 21.42           C  
ATOM   1558  CD2 TYR A 209      10.576   6.133  -7.003  1.00 18.08           C  
ATOM   1559  CE1 TYR A 209      10.696   4.529  -9.299  1.00 22.49           C  
ATOM   1560  CE2 TYR A 209      11.503   5.072  -7.084  1.00 21.47           C  
ATOM   1561  CZ  TYR A 209      11.553   4.300  -8.247  1.00 21.66           C  
ATOM   1562  OH  TYR A 209      12.438   3.261  -8.333  1.00 27.42           O  
ATOM   1563  N   PHE A 210       6.787   5.183  -6.161  1.00 17.50           N  
ATOM   1564  CA  PHE A 210       6.573   4.569  -4.842  1.00 16.10           C  
ATOM   1565  C   PHE A 210       7.859   4.019  -4.248  1.00 19.66           C  
ATOM   1566  O   PHE A 210       8.525   3.156  -4.849  1.00 19.88           O  
ATOM   1567  CB  PHE A 210       5.556   3.428  -4.949  1.00 18.68           C  
ATOM   1568  CG  PHE A 210       5.246   2.792  -3.617  1.00 20.48           C  
ATOM   1569  CD1 PHE A 210       4.282   3.349  -2.787  1.00 19.06           C  
ATOM   1570  CD2 PHE A 210       5.942   1.680  -3.175  1.00 20.66           C  
ATOM   1571  CE1 PHE A 210       3.982   2.769  -1.531  1.00 21.59           C  
ATOM   1572  CE2 PHE A 210       5.671   1.117  -1.911  1.00 25.50           C  
ATOM   1573  CZ  PHE A 210       4.686   1.678  -1.093  1.00 21.76           C  
ATOM   1574  N   ILE A 211       8.200   4.495  -3.059  1.00 13.91           N  
ATOM   1575  CA  ILE A 211       9.305   3.944  -2.299  1.00 16.77           C  
ATOM   1576  C   ILE A 211       8.802   3.293  -1.014  1.00 17.31           C  
ATOM   1577  O   ILE A 211       8.907   2.057  -0.879  1.00 15.30           O  
ATOM   1578  CB  ILE A 211      10.394   5.021  -2.054  1.00 16.25           C  
ATOM   1579  CG1 ILE A 211      11.020   5.417  -3.412  1.00 16.95           C  
ATOM   1580  CG2 ILE A 211      11.439   4.550  -0.984  1.00 17.38           C  
ATOM   1581  CD1 ILE A 211      12.108   6.555  -3.324  1.00 16.69           C  
ATOM   1582  N   TYR A 212       8.272   4.110  -0.066  1.00 16.70           N  
ATOM   1583  CA  TYR A 212       7.626   3.617   1.166  1.00 16.27           C  
ATOM   1584  C   TYR A 212       6.228   4.218   1.278  1.00 17.85           C  
ATOM   1585  O   TYR A 212       6.014   5.313   0.778  1.00 17.58           O  
ATOM   1586  CB  TYR A 212       8.396   4.013   2.455  1.00 14.23           C  
ATOM   1587  CG  TYR A 212       9.813   3.454   2.634  1.00 16.57           C  
ATOM   1588  CD1 TYR A 212      10.291   2.403   1.850  1.00 15.03           C  
ATOM   1589  CD2 TYR A 212      10.649   3.986   3.616  1.00 13.32           C  
ATOM   1590  CE1 TYR A 212      11.589   1.911   2.034  1.00 15.12           C  
ATOM   1591  CE2 TYR A 212      11.946   3.516   3.814  1.00 16.43           C  
ATOM   1592  CZ  TYR A 212      12.416   2.490   3.010  1.00 13.56           C  
ATOM   1593  OH  TYR A 212      13.700   2.036   3.230  1.00 17.63           O  
ATOM   1594  N   PRO A 213       5.277   3.509   1.933  1.00 16.27           N  
ATOM   1595  CA  PRO A 213       3.904   4.045   2.006  1.00 16.43           C  
ATOM   1596  C   PRO A 213       3.797   5.491   2.485  1.00 11.64           C  
ATOM   1597  O   PRO A 213       2.934   6.199   1.986  1.00 15.10           O  
ATOM   1598  CB  PRO A 213       3.200   3.098   2.996  1.00 18.23           C  
ATOM   1599  CG  PRO A 213       3.959   1.765   2.794  1.00 17.66           C  
ATOM   1600  CD  PRO A 213       5.383   2.163   2.556  1.00 15.99           C  
ATOM   1601  N   GLY A 214       4.648   5.906   3.413  1.00 12.75           N  
ATOM   1602  CA  GLY A 214       4.454   7.196   4.116  1.00 13.51           C  
ATOM   1603  C   GLY A 214       4.640   8.400   3.214  1.00 15.97           C  
ATOM   1604  O   GLY A 214       4.064   9.457   3.490  1.00 15.23           O  
ATOM   1605  N   TYR A 215       5.424   8.227   2.151  1.00 16.06           N  
ATOM   1606  CA  TYR A 215       5.881   9.356   1.329  1.00 13.38           C  
ATOM   1607  C   TYR A 215       5.111   9.489   0.048  1.00 14.18           C  
ATOM   1608  O   TYR A 215       4.776   8.486  -0.604  1.00 11.35           O  
ATOM   1609  CB  TYR A 215       7.365   9.239   0.978  1.00 13.90           C  
ATOM   1610  CG  TYR A 215       8.324   9.267   2.120  1.00 15.33           C  
ATOM   1611  CD1 TYR A 215       8.584  10.452   2.826  1.00 14.25           C  
ATOM   1612  CD2 TYR A 215       9.009   8.096   2.491  1.00 13.10           C  
ATOM   1613  CE1 TYR A 215       9.501  10.461   3.894  1.00 15.17           C  
ATOM   1614  CE2 TYR A 215       9.921   8.102   3.536  1.00 14.72           C  
ATOM   1615  CZ  TYR A 215      10.161   9.275   4.244  1.00 15.71           C  
ATOM   1616  OH  TYR A 215      11.075   9.240   5.253  1.00 15.64           O  
ATOM   1617  N   ALA A 216       4.875  10.738  -0.338  1.00 13.40           N  
ATOM   1618  CA  ALA A 216       4.248  11.026  -1.628  1.00 15.64           C  
ATOM   1619  C   ALA A 216       5.252  11.625  -2.620  1.00 18.59           C  
ATOM   1620  O   ALA A 216       5.292  12.832  -2.825  1.00 15.58           O  
ATOM   1621  CB  ALA A 216       2.978  11.934  -1.440  1.00 15.02           C  
ATOM   1622  N   PHE A 217       6.032  10.754  -3.272  1.00 14.57           N  
ATOM   1623  CA  PHE A 217       7.086  11.193  -4.173  1.00 16.56           C  
ATOM   1624  C   PHE A 217       6.565  11.164  -5.579  1.00 17.07           C  
ATOM   1625  O   PHE A 217       5.774  10.297  -5.940  1.00 14.69           O  
ATOM   1626  CB  PHE A 217       8.333  10.245  -4.136  1.00 11.86           C  
ATOM   1627  CG  PHE A 217       9.091  10.234  -2.817  1.00 13.69           C  
ATOM   1628  CD1 PHE A 217       9.595  11.402  -2.222  1.00 10.69           C  
ATOM   1629  CD2 PHE A 217       9.341   9.019  -2.180  1.00 16.77           C  
ATOM   1630  CE1 PHE A 217      10.274  11.348  -0.988  1.00 13.10           C  
ATOM   1631  CE2 PHE A 217      10.026   8.957  -0.965  1.00 12.61           C  
ATOM   1632  CZ  PHE A 217      10.509  10.106  -0.364  1.00 15.38           C  
ATOM   1633  N   VAL A 218       7.032  12.123  -6.375  1.00 18.07           N  
ATOM   1634  CA  VAL A 218       6.951  12.031  -7.834  1.00 15.32           C  
ATOM   1635  C   VAL A 218       8.376  12.078  -8.367  1.00 17.41           C  
ATOM   1636  O   VAL A 218       9.291  12.463  -7.644  1.00 16.24           O  
ATOM   1637  CB  VAL A 218       6.069  13.145  -8.489  1.00 15.84           C  
ATOM   1638  CG1 VAL A 218       4.603  13.015  -8.027  1.00 16.09           C  
ATOM   1639  CG2 VAL A 218       6.610  14.530  -8.190  1.00 17.20           C  
ATOM   1640  N   CYS A 219       8.575  11.632  -9.604  1.00 17.21           N  
ATOM   1641  CA  CYS A 219       9.889  11.619 -10.175  1.00 17.97           C  
ATOM   1642  C   CYS A 219       9.869  12.050 -11.625  1.00 17.61           C  
ATOM   1643  O   CYS A 219       8.827  11.941 -12.296  1.00 18.05           O  
ATOM   1644  CB  CYS A 219      10.498  10.217 -10.079  1.00 16.71           C  
ATOM   1645  SG  CYS A 219       9.733   9.036 -11.150  1.00 19.77           S  
ATOM   1646  N   TYR A 220      11.013  12.529 -12.092  1.00 17.90           N  
ATOM   1647  CA  TYR A 220      11.212  12.826 -13.513  1.00 16.49           C  
ATOM   1648  C   TYR A 220      12.657  12.412 -13.839  1.00 19.13           C  
ATOM   1649  O   TYR A 220      13.525  12.456 -12.961  1.00 15.56           O  
ATOM   1650  CB  TYR A 220      10.940  14.323 -13.812  1.00 16.62           C  
ATOM   1651  CG  TYR A 220      11.796  15.308 -13.031  1.00 19.77           C  
ATOM   1652  CD1 TYR A 220      13.035  15.742 -13.521  1.00 19.93           C  
ATOM   1653  CD2 TYR A 220      11.367  15.832 -11.799  1.00 17.86           C  
ATOM   1654  CE1 TYR A 220      13.841  16.665 -12.795  1.00 19.35           C  
ATOM   1655  CE2 TYR A 220      12.171  16.747 -11.069  1.00 20.64           C  
ATOM   1656  CZ  TYR A 220      13.396  17.156 -11.574  1.00 20.11           C  
ATOM   1657  OH  TYR A 220      14.184  18.056 -10.865  1.00 21.80           O  
ATOM   1658  N   PRO A 221      12.916  12.002 -15.097  1.00 19.26           N  
ATOM   1659  CA  PRO A 221      14.279  11.591 -15.442  1.00 19.63           C  
ATOM   1660  C   PRO A 221      15.280  12.745 -15.589  1.00 21.00           C  
ATOM   1661  O   PRO A 221      14.902  13.870 -15.979  1.00 24.07           O  
ATOM   1662  CB  PRO A 221      14.103  10.863 -16.780  1.00 22.06           C  
ATOM   1663  CG  PRO A 221      12.805  11.439 -17.402  1.00 19.26           C  
ATOM   1664  CD  PRO A 221      11.952  11.852 -16.212  1.00 19.64           C  
ATOM   1665  N   ASN A 222      16.536  12.470 -15.255  1.00 21.09           N  
ATOM   1666  CA  ASN A 222      17.627  13.451 -15.393  1.00 21.38           C  
ATOM   1667  C   ASN A 222      18.058  13.619 -16.858  1.00 23.09           C  
ATOM   1668  O   ASN A 222      17.553  12.914 -17.720  1.00 22.60           O  
ATOM   1669  CB  ASN A 222      18.796  13.060 -14.519  1.00 24.60           C  
ATOM   1670  CG  ASN A 222      18.470  13.190 -13.037  1.00 24.41           C  
ATOM   1671  OD1 ASN A 222      17.499  13.858 -12.663  1.00 30.32           O  
ATOM   1672  ND2 ASN A 222      19.275  12.566 -12.196  1.00 30.46           N  
ATOM   1673  N   ARG A 223      18.973  14.546 -17.133  1.00 22.75           N  
ATOM   1674  CA  ARG A 223      19.336  14.876 -18.530  1.00 29.21           C  
ATOM   1675  C   ARG A 223      19.880  13.686 -19.327  1.00 24.81           C  
ATOM   1676  O   ARG A 223      19.456  13.443 -20.459  1.00 25.31           O  
ATOM   1677  CB  ARG A 223      20.331  16.039 -18.583  1.00 33.78           C  
ATOM   1678  CG  ARG A 223      19.668  17.423 -18.476  1.00 42.78           C  
ATOM   1679  CD  ARG A 223      20.680  18.562 -18.712  1.00 44.67           C  
ATOM   1680  NE  ARG A 223      21.978  18.260 -18.095  1.00 53.50           N  
ATOM   1681  CZ  ARG A 223      22.329  18.575 -16.846  1.00 53.86           C  
ATOM   1682  NH1 ARG A 223      21.486  19.231 -16.052  1.00 55.39           N  
ATOM   1683  NH2 ARG A 223      23.530  18.230 -16.388  1.00 54.49           N  
ATOM   1684  N   ASP A 224      20.787  12.929 -18.725  1.00 23.92           N  
ATOM   1685  CA  ASP A 224      21.320  11.757 -19.402  1.00 27.02           C  
ATOM   1686  C   ASP A 224      21.621  10.579 -18.503  1.00 24.69           C  
ATOM   1687  O   ASP A 224      22.564  10.613 -17.704  1.00 30.84           O  
ATOM   1688  CB  ASP A 224      22.545  12.113 -20.234  1.00 29.82           C  
ATOM   1689  CG  ASP A 224      23.256  10.875 -20.752  1.00 33.77           C  
ATOM   1690  OD1 ASP A 224      22.602  10.010 -21.355  1.00 33.11           O  
ATOM   1691  OD2 ASP A 224      24.465  10.760 -20.511  1.00 40.65           O  
ATOM   1692  N   SER A 225      20.844   9.514 -18.656  1.00 23.73           N  
ATOM   1693  CA  SER A 225      21.093   8.288 -17.892  1.00 23.63           C  
ATOM   1694  C   SER A 225      21.953   7.293 -18.676  1.00 25.68           C  
ATOM   1695  O   SER A 225      22.392   6.288 -18.124  1.00 27.96           O  
ATOM   1696  CB  SER A 225      19.767   7.628 -17.516  1.00 20.62           C  
ATOM   1697  OG  SER A 225      18.986   8.490 -16.697  1.00 22.49           O  
ATOM   1698  N   THR A 226      22.167   7.550 -19.963  1.00 26.28           N  
ATOM   1699  CA  THR A 226      22.821   6.536 -20.807  1.00 28.55           C  
ATOM   1700  C   THR A 226      24.256   6.295 -20.418  1.00 30.22           C  
ATOM   1701  O   THR A 226      24.796   5.219 -20.702  1.00 32.20           O  
ATOM   1702  CB  THR A 226      22.745   6.835 -22.311  1.00 26.32           C  
ATOM   1703  OG1 THR A 226      23.409   8.072 -22.577  1.00 29.83           O  
ATOM   1704  CG2 THR A 226      21.315   6.898 -22.771  1.00 27.00           C  
ATOM   1705  N   LEU A 227      24.867   7.265 -19.739  1.00 31.61           N  
ATOM   1706  CA  LEU A 227      26.277   7.153 -19.356  1.00 33.95           C  
ATOM   1707  C   LEU A 227      26.546   6.018 -18.364  1.00 35.22           C  
ATOM   1708  O   LEU A 227      27.683   5.530 -18.276  1.00 35.65           O  
ATOM   1709  CB  LEU A 227      26.815   8.488 -18.819  1.00 40.92           C  
ATOM   1710  CG  LEU A 227      26.757   9.724 -19.752  1.00 46.63           C  
ATOM   1711  CD1 LEU A 227      27.398  10.975 -19.112  1.00 47.78           C  
ATOM   1712  CD2 LEU A 227      27.331   9.492 -21.189  1.00 47.29           C  
ATOM   1713  N   PHE A 228      25.514   5.600 -17.618  1.00 32.91           N  
ATOM   1714  CA  PHE A 228      25.690   4.572 -16.569  1.00 31.36           C  
ATOM   1715  C   PHE A 228      25.907   3.173 -17.101  1.00 27.08           C  
ATOM   1716  O   PHE A 228      26.419   2.326 -16.374  1.00 29.02           O  
ATOM   1717  CB  PHE A 228      24.544   4.577 -15.561  1.00 34.12           C  
ATOM   1718  CG  PHE A 228      24.483   5.826 -14.773  1.00 35.73           C  
ATOM   1719  CD1 PHE A 228      25.456   6.101 -13.823  1.00 35.34           C  
ATOM   1720  CD2 PHE A 228      23.478   6.756 -15.011  1.00 37.94           C  
ATOM   1721  CE1 PHE A 228      25.444   7.275 -13.119  1.00 37.00           C  
ATOM   1722  CE2 PHE A 228      23.440   7.942 -14.307  1.00 38.77           C  
ATOM   1723  CZ  PHE A 228      24.431   8.207 -13.357  1.00 40.41           C  
ATOM   1724  N   LYS A 229      25.530   2.949 -18.358  1.00 27.60           N  
ATOM   1725  CA  LYS A 229      25.807   1.679 -19.042  1.00 29.43           C  
ATOM   1726  C   LYS A 229      27.300   1.430 -19.106  1.00 31.11           C  
ATOM   1727  O   LYS A 229      27.752   0.378 -18.686  1.00 30.06           O  
ATOM   1728  CB  LYS A 229      25.246   1.658 -20.468  1.00 31.07           C  
ATOM   1729  CG  LYS A 229      23.858   1.099 -20.578  1.00 29.67           C  
ATOM   1730  CD  LYS A 229      23.565   0.522 -21.951  1.00 30.43           C  
ATOM   1731  CE  LYS A 229      22.438  -0.471 -21.833  1.00 30.54           C  
ATOM   1732  NZ  LYS A 229      21.668  -0.781 -23.088  1.00 29.77           N  
ATOM   1733  N   ASP A 230      28.059   2.399 -19.631  1.00 30.20           N  
ATOM   1734  CA  ASP A 230      29.543   2.285 -19.668  1.00 32.46           C  
ATOM   1735  C   ASP A 230      30.165   2.444 -18.275  1.00 29.00           C  
ATOM   1736  O   ASP A 230      31.110   1.738 -17.912  1.00 27.83           O  
ATOM   1737  CB  ASP A 230      30.178   3.275 -20.676  1.00 34.19           C  
ATOM   1738  CG  ASP A 230      29.930   2.881 -22.139  1.00 36.44           C  
ATOM   1739  OD1 ASP A 230      29.490   1.742 -22.399  1.00 38.52           O  
ATOM   1740  OD2 ASP A 230      30.178   3.709 -23.056  1.00 39.39           O  
ATOM   1741  N   LEU A 231      29.621   3.358 -17.479  1.00 26.75           N  
ATOM   1742  CA  LEU A 231      30.157   3.606 -16.157  1.00 26.14           C  
ATOM   1743  C   LEU A 231      30.110   2.400 -15.212  1.00 27.64           C  
ATOM   1744  O   LEU A 231      31.048   2.152 -14.446  1.00 27.55           O  
ATOM   1745  CB  LEU A 231      29.445   4.803 -15.524  1.00 28.55           C  
ATOM   1746  CG  LEU A 231      30.155   5.567 -14.407  1.00 29.87           C  
ATOM   1747  CD1 LEU A 231      31.459   6.231 -14.934  1.00 31.89           C  
ATOM   1748  CD2 LEU A 231      29.228   6.627 -13.896  1.00 28.94           C  
ATOM   1749  N   TYR A 232      28.997   1.673 -15.232  1.00 25.24           N  
ATOM   1750  CA  TYR A 232      28.838   0.528 -14.346  1.00 26.13           C  
ATOM   1751  C   TYR A 232      29.004  -0.788 -15.104  1.00 27.69           C  
ATOM   1752  O   TYR A 232      28.842  -1.865 -14.531  1.00 28.75           O  
ATOM   1753  CB  TYR A 232      27.465   0.554 -13.662  1.00 25.11           C  
ATOM   1754  CG  TYR A 232      27.226   1.712 -12.733  1.00 26.57           C  
ATOM   1755  CD1 TYR A 232      28.276   2.319 -12.022  1.00 25.72           C  
ATOM   1756  CD2 TYR A 232      25.929   2.188 -12.533  1.00 25.65           C  
ATOM   1757  CE1 TYR A 232      28.029   3.392 -11.162  1.00 27.01           C  
ATOM   1758  CE2 TYR A 232      25.680   3.244 -11.696  1.00 25.42           C  
ATOM   1759  CZ  TYR A 232      26.719   3.834 -11.004  1.00 25.08           C  
ATOM   1760  OH  TYR A 232      26.430   4.875 -10.162  1.00 26.31           O  
ATOM   1761  N   HIS A 233      29.327  -0.675 -16.397  1.00 25.73           N  
ATOM   1762  CA  HIS A 233      29.475  -1.806 -17.305  1.00 26.68           C  
ATOM   1763  C   HIS A 233      28.252  -2.732 -17.222  1.00 27.45           C  
ATOM   1764  O   HIS A 233      28.339  -3.897 -16.811  1.00 26.92           O  
ATOM   1765  CB  HIS A 233      30.808  -2.562 -17.134  1.00 24.39           C  
ATOM   1766  CG  HIS A 233      31.243  -3.268 -18.378  1.00 26.58           C  
ATOM   1767  ND1 HIS A 233      32.006  -2.648 -19.350  1.00 25.00           N  
ATOM   1768  CD2 HIS A 233      30.947  -4.501 -18.861  1.00 24.40           C  
ATOM   1769  CE1 HIS A 233      32.177  -3.478 -20.368  1.00 28.19           C  
ATOM   1770  NE2 HIS A 233      31.549  -4.609 -20.091  1.00 25.04           N  
ATOM   1771  N   ILE A 234      27.116  -2.185 -17.624  1.00 22.50           N  
ATOM   1772  CA  ILE A 234      25.886  -2.966 -17.716  1.00 22.73           C  
ATOM   1773  C   ILE A 234      25.357  -2.906 -19.140  1.00 24.66           C  
ATOM   1774  O   ILE A 234      24.237  -2.448 -19.399  1.00 21.11           O  
ATOM   1775  CB  ILE A 234      24.847  -2.563 -16.628  1.00 21.23           C  
ATOM   1776  CG1 ILE A 234      24.633  -1.044 -16.622  1.00 21.90           C  
ATOM   1777  CG2 ILE A 234      25.348  -3.032 -15.266  1.00 20.70           C  
ATOM   1778  CD1 ILE A 234      23.368  -0.568 -15.842  1.00 22.44           C  
ATOM   1779  N   PRO A 235      26.164  -3.435 -20.085  1.00 23.58           N  
ATOM   1780  CA  PRO A 235      25.755  -3.440 -21.465  1.00 25.13           C  
ATOM   1781  C   PRO A 235      24.478  -4.254 -21.681  1.00 22.14           C  
ATOM   1782  O   PRO A 235      23.757  -3.993 -22.621  1.00 22.36           O  
ATOM   1783  CB  PRO A 235      26.971  -4.074 -22.203  1.00 22.89           C  
ATOM   1784  CG  PRO A 235      27.711  -4.831 -21.204  1.00 21.97           C  
ATOM   1785  CD  PRO A 235      27.475  -4.095 -19.893  1.00 22.73           C  
ATOM   1786  N   GLU A 236      24.197  -5.217 -20.807  1.00 23.37           N  
ATOM   1787  CA  GLU A 236      23.030  -6.081 -20.966  1.00 25.02           C  
ATOM   1788  C   GLU A 236      21.712  -5.452 -20.472  1.00 27.81           C  
ATOM   1789  O   GLU A 236      20.631  -6.038 -20.651  1.00 23.74           O  
ATOM   1790  CB  GLU A 236      23.268  -7.414 -20.256  1.00 25.44           C  
ATOM   1791  CG  GLU A 236      23.153  -7.413 -18.718  1.00 26.54           C  
ATOM   1792  CD  GLU A 236      24.347  -6.833 -17.939  1.00 25.82           C  
ATOM   1793  OE1 GLU A 236      25.242  -6.166 -18.504  1.00 25.24           O  
ATOM   1794  OE2 GLU A 236      24.394  -7.066 -16.716  1.00 27.15           O  
ATOM   1795  N   ALA A 237      21.794  -4.270 -19.849  1.00 26.96           N  
ATOM   1796  CA  ALA A 237      20.591  -3.628 -19.291  1.00 24.48           C  
ATOM   1797  C   ALA A 237      19.652  -3.090 -20.371  1.00 27.09           C  
ATOM   1798  O   ALA A 237      20.087  -2.384 -21.279  1.00 30.25           O  
ATOM   1799  CB  ALA A 237      20.992  -2.520 -18.303  1.00 23.76           C  
ATOM   1800  N   GLU A 238      18.361  -3.434 -20.275  1.00 24.62           N  
ATOM   1801  CA  GLU A 238      17.338  -2.962 -21.189  1.00 26.90           C  
ATOM   1802  C   GLU A 238      16.822  -1.590 -20.746  1.00 22.18           C  
ATOM   1803  O   GLU A 238      16.364  -0.791 -21.561  1.00 22.67           O  
ATOM   1804  CB  GLU A 238      16.184  -3.964 -21.245  1.00 31.48           C  
ATOM   1805  CG  GLU A 238      16.514  -5.257 -22.019  1.00 40.17           C  
ATOM   1806  CD  GLU A 238      15.449  -6.351 -21.825  1.00 42.61           C  
ATOM   1807  OE1 GLU A 238      14.428  -6.088 -21.130  1.00 45.87           O  
ATOM   1808  OE2 GLU A 238      15.646  -7.487 -22.346  1.00 47.73           O  
ATOM   1809  N   THR A 239      16.902  -1.346 -19.439  1.00 20.52           N  
ATOM   1810  CA  THR A 239      16.314  -0.149 -18.827  1.00 19.51           C  
ATOM   1811  C   THR A 239      17.358   0.420 -17.873  1.00 17.35           C  
ATOM   1812  O   THR A 239      17.944  -0.309 -17.041  1.00 18.26           O  
ATOM   1813  CB  THR A 239      15.009  -0.507 -18.080  1.00 18.55           C  
ATOM   1814  OG1 THR A 239      14.042  -0.977 -19.016  1.00 23.09           O  
ATOM   1815  CG2 THR A 239      14.427   0.717 -17.336  1.00 22.95           C  
ATOM   1816  N   VAL A 240      17.633   1.705 -18.041  1.00 17.23           N  
ATOM   1817  CA  VAL A 240      18.636   2.425 -17.271  1.00 18.26           C  
ATOM   1818  C   VAL A 240      18.100   3.834 -17.152  1.00 20.17           C  
ATOM   1819  O   VAL A 240      18.144   4.605 -18.115  1.00 18.32           O  
ATOM   1820  CB  VAL A 240      20.038   2.475 -17.987  1.00 19.81           C  
ATOM   1821  CG1 VAL A 240      21.086   3.127 -17.081  1.00 20.06           C  
ATOM   1822  CG2 VAL A 240      20.482   1.088 -18.404  1.00 19.39           C  
ATOM   1823  N   ILE A 241      17.599   4.186 -15.962  1.00 19.31           N  
ATOM   1824  CA  ILE A 241      17.016   5.531 -15.761  1.00 21.69           C  
ATOM   1825  C   ILE A 241      17.428   6.070 -14.402  1.00 19.53           C  
ATOM   1826  O   ILE A 241      17.226   5.408 -13.370  1.00 20.57           O  
ATOM   1827  CB  ILE A 241      15.468   5.554 -15.847  1.00 20.91           C  
ATOM   1828  CG1 ILE A 241      14.966   4.730 -17.036  1.00 22.61           C  
ATOM   1829  CG2 ILE A 241      14.978   6.999 -15.871  1.00 22.55           C  
ATOM   1830  CD1 ILE A 241      13.470   4.528 -17.129  1.00 21.40           C  
ATOM   1831  N   ARG A 242      18.037   7.257 -14.411  1.00 18.68           N  
ATOM   1832  CA  ARG A 242      18.380   7.957 -13.180  1.00 22.06           C  
ATOM   1833  C   ARG A 242      17.463   9.182 -13.139  1.00 21.59           C  
ATOM   1834  O   ARG A 242      17.285   9.849 -14.152  1.00 21.84           O  
ATOM   1835  CB  ARG A 242      19.851   8.390 -13.158  1.00 22.71           C  
ATOM   1836  CG  ARG A 242      20.254   9.207 -11.895  1.00 32.04           C  
ATOM   1837  CD  ARG A 242      21.769   9.667 -11.869  1.00 35.41           C  
ATOM   1838  NE  ARG A 242      21.898  11.021 -12.421  1.00 44.73           N  
ATOM   1839  CZ  ARG A 242      22.450  12.071 -11.815  1.00 45.07           C  
ATOM   1840  NH1 ARG A 242      23.021  11.961 -10.621  1.00 45.72           N  
ATOM   1841  NH2 ARG A 242      22.453  13.244 -12.438  1.00 47.99           N  
ATOM   1842  N   GLY A 243      16.874   9.480 -11.987  1.00 20.42           N  
ATOM   1843  CA  GLY A 243      15.998  10.668 -11.904  1.00 20.73           C  
ATOM   1844  C   GLY A 243      16.001  11.358 -10.538  1.00 14.73           C  
ATOM   1845  O   GLY A 243      16.740  10.998  -9.638  1.00 17.43           O  
ATOM   1846  N   THR A 244      15.138  12.360 -10.426  1.00 16.36           N  
ATOM   1847  CA  THR A 244      15.042  13.224  -9.263  1.00 16.30           C  
ATOM   1848  C   THR A 244      13.689  13.035  -8.587  1.00 17.61           C  
ATOM   1849  O   THR A 244      12.691  12.859  -9.273  1.00 15.15           O  
ATOM   1850  CB  THR A 244      15.219  14.698  -9.722  1.00 18.45           C  
ATOM   1851  OG1 THR A 244      16.549  14.856 -10.220  1.00 20.10           O  
ATOM   1852  CG2 THR A 244      15.016  15.662  -8.570  1.00 16.49           C  
ATOM   1853  N   LEU A 245      13.687  13.030  -7.245  1.00 14.10           N  
ATOM   1854  CA  LEU A 245      12.443  12.920  -6.491  1.00 14.58           C  
ATOM   1855  C   LEU A 245      12.041  14.311  -6.015  1.00 13.35           C  
ATOM   1856  O   LEU A 245      12.884  15.106  -5.595  1.00 16.14           O  
ATOM   1857  CB  LEU A 245      12.608  11.985  -5.283  1.00 14.88           C  
ATOM   1858  CG  LEU A 245      12.959  10.541  -5.699  1.00 12.44           C  
ATOM   1859  CD1 LEU A 245      13.536   9.758  -4.482  1.00 13.20           C  
ATOM   1860  CD2 LEU A 245      11.772   9.747  -6.281  1.00 13.60           C  
ATOM   1861  N   ARG A 246      10.746  14.563  -6.100  1.00 16.25           N  
ATOM   1862  CA  ARG A 246      10.088  15.740  -5.512  1.00 15.53           C  
ATOM   1863  C   ARG A 246       8.825  15.224  -4.810  1.00 16.62           C  
ATOM   1864  O   ARG A 246       8.443  14.087  -4.974  1.00 15.72           O  
ATOM   1865  CB  ARG A 246       9.713  16.753  -6.619  1.00 15.49           C  
ATOM   1866  CG  ARG A 246      10.929  17.352  -7.377  1.00 15.43           C  
ATOM   1867  CD  ARG A 246      11.653  18.362  -6.512  1.00 11.56           C  
ATOM   1868  NE  ARG A 246      12.888  18.889  -7.088  1.00 19.21           N  
ATOM   1869  CZ  ARG A 246      14.110  18.488  -6.766  1.00 14.36           C  
ATOM   1870  NH1 ARG A 246      14.314  17.526  -5.845  1.00 15.97           N  
ATOM   1871  NH2 ARG A 246      15.159  19.097  -7.324  1.00 18.78           N  
ATOM   1872  N   TYR A 247       8.144  16.064  -4.042  1.00 14.04           N  
ATOM   1873  CA  TYR A 247       6.866  15.687  -3.482  1.00 15.61           C  
ATOM   1874  C   TYR A 247       5.702  15.974  -4.425  1.00 16.97           C  
ATOM   1875  O   TYR A 247       5.806  16.816  -5.330  1.00 15.64           O  
ATOM   1876  CB  TYR A 247       6.626  16.413  -2.149  1.00 15.02           C  
ATOM   1877  CG  TYR A 247       7.488  15.952  -0.991  1.00 15.63           C  
ATOM   1878  CD1 TYR A 247       7.695  14.565  -0.715  1.00 12.55           C  
ATOM   1879  CD2 TYR A 247       8.071  16.882  -0.147  1.00 12.38           C  
ATOM   1880  CE1 TYR A 247       8.451  14.150   0.398  1.00 12.82           C  
ATOM   1881  CE2 TYR A 247       8.835  16.475   0.979  1.00 15.11           C  
ATOM   1882  CZ  TYR A 247       9.030  15.122   1.241  1.00 15.80           C  
ATOM   1883  OH  TYR A 247       9.779  14.784   2.347  1.00 13.74           O  
ATOM   1884  N   GLN A 248       4.612  15.255  -4.217  1.00 14.16           N  
ATOM   1885  CA  GLN A 248       3.416  15.439  -4.977  1.00 14.09           C  
ATOM   1886  C   GLN A 248       3.098  16.926  -5.100  1.00 14.22           C  
ATOM   1887  O   GLN A 248       3.288  17.687  -4.137  1.00 15.48           O  
ATOM   1888  CB  GLN A 248       2.221  14.742  -4.329  1.00 13.29           C  
ATOM   1889  CG  GLN A 248       1.844  15.386  -2.956  1.00 16.24           C  
ATOM   1890  CD  GLN A 248       0.836  14.549  -2.174  1.00 16.98           C  
ATOM   1891  OE1 GLN A 248      -0.044  13.936  -2.754  1.00 15.51           O  
ATOM   1892  NE2 GLN A 248       0.999  14.498  -0.861  1.00 14.01           N  
ATOM   1893  N   GLY A 249       2.633  17.321  -6.281  1.00 16.94           N  
ATOM   1894  CA  GLY A 249       2.176  18.708  -6.489  1.00 20.10           C  
ATOM   1895  C   GLY A 249       3.211  19.623  -7.121  1.00 21.39           C  
ATOM   1896  O   GLY A 249       2.859  20.636  -7.736  1.00 20.97           O  
ATOM   1897  N   PHE A 250       4.483  19.266  -6.986  1.00 19.25           N  
ATOM   1898  CA  PHE A 250       5.607  20.092  -7.476  1.00 19.59           C  
ATOM   1899  C   PHE A 250       5.537  20.303  -9.009  1.00 19.67           C  
ATOM   1900  O   PHE A 250       5.564  21.436  -9.476  1.00 19.03           O  
ATOM   1901  CB  PHE A 250       6.951  19.500  -6.980  1.00 18.38           C  
ATOM   1902  CG  PHE A 250       8.176  20.220  -7.494  1.00 19.95           C  
ATOM   1903  CD1 PHE A 250       8.870  21.101  -6.661  1.00 19.88           C  
ATOM   1904  CD2 PHE A 250       8.668  19.953  -8.776  1.00 19.23           C  
ATOM   1905  CE1 PHE A 250      10.030  21.784  -7.117  1.00 19.09           C  
ATOM   1906  CE2 PHE A 250       9.812  20.607  -9.240  1.00 19.99           C  
ATOM   1907  CZ  PHE A 250      10.501  21.524  -8.424  1.00 19.88           C  
ATOM   1908  N   PRO A 251       5.392  19.227  -9.800  1.00 19.55           N  
ATOM   1909  CA  PRO A 251       5.356  19.450 -11.256  1.00 18.99           C  
ATOM   1910  C   PRO A 251       4.167  20.271 -11.707  1.00 20.48           C  
ATOM   1911  O   PRO A 251       4.327  21.110 -12.586  1.00 22.70           O  
ATOM   1912  CB  PRO A 251       5.252  18.021 -11.843  1.00 21.14           C  
ATOM   1913  CG  PRO A 251       5.750  17.137 -10.742  1.00 19.02           C  
ATOM   1914  CD  PRO A 251       5.303  17.793  -9.468  1.00 19.83           C  
ATOM   1915  N   GLU A 252       3.000  20.041 -11.110  1.00 21.03           N  
ATOM   1916  CA  GLU A 252       1.779  20.748 -11.498  1.00 21.60           C  
ATOM   1917  C   GLU A 252       1.906  22.235 -11.178  1.00 22.13           C  
ATOM   1918  O   GLU A 252       1.392  23.081 -11.917  1.00 21.17           O  
ATOM   1919  CB  GLU A 252       0.567  20.186 -10.765  1.00 24.89           C  
ATOM   1920  CG  GLU A 252       0.211  18.763 -11.121  1.00 29.11           C  
ATOM   1921  CD  GLU A 252       0.901  17.721 -10.210  1.00 31.05           C  
ATOM   1922  OE1 GLU A 252       2.063  17.899  -9.793  1.00 29.85           O  
ATOM   1923  OE2 GLU A 252       0.267  16.693  -9.924  1.00 35.57           O  
ATOM   1924  N   PHE A 253       2.558  22.544 -10.062  1.00 20.50           N  
ATOM   1925  CA  PHE A 253       2.755  23.932  -9.665  1.00 21.73           C  
ATOM   1926  C   PHE A 253       3.657  24.630 -10.692  1.00 20.77           C  
ATOM   1927  O   PHE A 253       3.357  25.720 -11.194  1.00 20.34           O  
ATOM   1928  CB  PHE A 253       3.383  24.005  -8.258  1.00 18.45           C  
ATOM   1929  CG  PHE A 253       3.228  25.340  -7.618  1.00 19.06           C  
ATOM   1930  CD1 PHE A 253       2.049  25.679  -6.995  1.00 22.52           C  
ATOM   1931  CD2 PHE A 253       4.241  26.276  -7.692  1.00 18.05           C  
ATOM   1932  CE1 PHE A 253       1.880  26.947  -6.412  1.00 23.12           C  
ATOM   1933  CE2 PHE A 253       4.090  27.555  -7.087  1.00 21.02           C  
ATOM   1934  CZ  PHE A 253       2.894  27.872  -6.451  1.00 19.51           C  
ATOM   1935  N   VAL A 254       4.781  23.984 -10.990  1.00 20.83           N  
ATOM   1936  CA  VAL A 254       5.721  24.521 -11.983  1.00 23.14           C  
ATOM   1937  C   VAL A 254       5.079  24.679 -13.370  1.00 24.40           C  
ATOM   1938  O   VAL A 254       5.266  25.709 -14.023  1.00 23.99           O  
ATOM   1939  CB  VAL A 254       6.993  23.657 -12.043  1.00 18.02           C  
ATOM   1940  CG1 VAL A 254       7.978  24.187 -13.102  1.00 21.71           C  
ATOM   1941  CG2 VAL A 254       7.651  23.654 -10.680  1.00 20.88           C  
ATOM   1942  N   LYS A 255       4.297  23.686 -13.790  1.00 18.60           N  
ATOM   1943  CA  LYS A 255       3.558  23.747 -15.063  1.00 24.99           C  
ATOM   1944  C   LYS A 255       2.637  24.960 -15.154  1.00 23.02           C  
ATOM   1945  O   LYS A 255       2.603  25.640 -16.175  1.00 26.37           O  
ATOM   1946  CB  LYS A 255       2.752  22.476 -15.322  1.00 27.92           C  
ATOM   1947  CG  LYS A 255       1.980  22.522 -16.653  1.00 31.40           C  
ATOM   1948  CD  LYS A 255       1.006  21.362 -16.823  1.00 33.95           C  
ATOM   1949  CE  LYS A 255       0.039  21.602 -18.000  1.00 35.92           C  
ATOM   1950  NZ  LYS A 255       0.701  22.376 -19.111  1.00 41.12           N  
ATOM   1951  N   ALA A 256       1.884  25.230 -14.094  1.00 20.74           N  
ATOM   1952  CA  ALA A 256       1.014  26.411 -14.062  1.00 20.04           C  
ATOM   1953  C   ALA A 256       1.874  27.676 -14.284  1.00 20.38           C  
ATOM   1954  O   ALA A 256       1.501  28.551 -15.093  1.00 20.66           O  
ATOM   1955  CB  ALA A 256       0.240  26.494 -12.740  1.00 21.18           C  
ATOM   1956  N   LEU A 257       3.013  27.756 -13.590  1.00 17.14           N  
ATOM   1957  CA  LEU A 257       3.932  28.898 -13.736  1.00 21.02           C  
ATOM   1958  C   LEU A 257       4.481  29.013 -15.171  1.00 23.35           C  
ATOM   1959  O   LEU A 257       4.547  30.106 -15.755  1.00 22.26           O  
ATOM   1960  CB  LEU A 257       5.047  28.839 -12.688  1.00 19.32           C  
ATOM   1961  CG  LEU A 257       4.657  29.121 -11.204  1.00 21.37           C  
ATOM   1962  CD1 LEU A 257       5.766  28.784 -10.191  1.00 17.44           C  
ATOM   1963  CD2 LEU A 257       4.255  30.592 -11.041  1.00 19.44           C  
ATOM   1964  N   VAL A 258       4.901  27.888 -15.738  1.00 23.41           N  
ATOM   1965  CA  VAL A 258       5.215  27.816 -17.175  1.00 24.37           C  
ATOM   1966  C   VAL A 258       4.107  28.385 -18.079  1.00 23.79           C  
ATOM   1967  O   VAL A 258       4.383  29.288 -18.895  1.00 28.44           O  
ATOM   1968  CB  VAL A 258       5.492  26.358 -17.595  1.00 26.02           C  
ATOM   1969  CG1 VAL A 258       5.525  26.217 -19.127  1.00 28.16           C  
ATOM   1970  CG2 VAL A 258       6.773  25.905 -16.964  1.00 29.23           C  
ATOM   1971  N   ASP A 259       2.881  27.859 -17.961  1.00 26.37           N  
ATOM   1972  CA  ASP A 259       1.732  28.350 -18.738  1.00 27.00           C  
ATOM   1973  C   ASP A 259       1.522  29.864 -18.595  1.00 28.65           C  
ATOM   1974  O   ASP A 259       0.999  30.502 -19.506  1.00 29.06           O  
ATOM   1975  CB  ASP A 259       0.435  27.637 -18.362  1.00 28.67           C  
ATOM   1976  CG  ASP A 259       0.447  26.149 -18.717  1.00 32.44           C  
ATOM   1977  OD1 ASP A 259       1.274  25.730 -19.540  1.00 33.44           O  
ATOM   1978  OD2 ASP A 259      -0.368  25.406 -18.139  1.00 33.84           O  
ATOM   1979  N   MET A 260       1.940  30.433 -17.469  1.00 27.56           N  
ATOM   1980  CA  MET A 260       1.805  31.884 -17.235  1.00 25.23           C  
ATOM   1981  C   MET A 260       2.943  32.707 -17.808  1.00 26.08           C  
ATOM   1982  O   MET A 260       2.926  33.942 -17.728  1.00 27.42           O  
ATOM   1983  CB  MET A 260       1.712  32.166 -15.739  1.00 22.78           C  
ATOM   1984  CG  MET A 260       0.479  31.555 -15.105  1.00 24.81           C  
ATOM   1985  SD  MET A 260       0.569  31.560 -13.304  1.00 24.91           S  
ATOM   1986  CE  MET A 260       0.837  33.298 -12.899  1.00 23.15           C  
ATOM   1987  N   GLY A 261       3.951  32.023 -18.342  1.00 23.77           N  
ATOM   1988  CA  GLY A 261       5.134  32.666 -18.880  1.00 24.73           C  
ATOM   1989  C   GLY A 261       6.146  33.003 -17.810  1.00 25.77           C  
ATOM   1990  O   GLY A 261       7.147  33.660 -18.078  1.00 25.13           O  
ATOM   1991  N   MET A 262       5.912  32.531 -16.581  1.00 23.36           N  
ATOM   1992  CA  MET A 262       6.755  32.959 -15.446  1.00 23.33           C  
ATOM   1993  C   MET A 262       8.163  32.353 -15.360  1.00 22.35           C  
ATOM   1994  O   MET A 262       8.962  32.759 -14.525  1.00 26.21           O  
ATOM   1995  CB  MET A 262       6.018  32.780 -14.100  1.00 20.95           C  
ATOM   1996  CG  MET A 262       4.866  33.767 -13.858  1.00 22.19           C  
ATOM   1997  SD  MET A 262       5.380  35.488 -13.979  1.00 23.29           S  
ATOM   1998  CE  MET A 262       6.592  35.639 -12.690  1.00 21.37           C  
ATOM   1999  N   LEU A 263       8.473  31.373 -16.207  1.00 27.26           N  
ATOM   2000  CA  LEU A 263       9.837  30.841 -16.257  1.00 28.08           C  
ATOM   2001  C   LEU A 263      10.654  31.428 -17.433  1.00 30.61           C  
ATOM   2002  O   LEU A 263      11.761  30.972 -17.705  1.00 31.20           O  
ATOM   2003  CB  LEU A 263       9.835  29.296 -16.294  1.00 29.03           C  
ATOM   2004  CG  LEU A 263       9.721  28.524 -14.963  1.00 29.47           C  
ATOM   2005  CD1 LEU A 263       8.398  28.759 -14.308  1.00 26.01           C  
ATOM   2006  CD2 LEU A 263       9.905  27.013 -15.195  1.00 28.96           C  
ATOM   2007  N   LYS A 264      10.106  32.439 -18.109  1.00 30.30           N  
ATOM   2008  CA  LYS A 264      10.830  33.148 -19.183  1.00 30.76           C  
ATOM   2009  C   LYS A 264      11.826  34.152 -18.626  1.00 31.13           C  
ATOM   2010  O   LYS A 264      11.487  34.998 -17.783  1.00 30.44           O  
ATOM   2011  CB  LYS A 264       9.860  33.856 -20.120  1.00 32.11           C  
ATOM   2012  CG  LYS A 264       8.934  32.940 -20.866  1.00 34.01           C  
ATOM   2013  CD  LYS A 264       8.010  33.773 -21.731  1.00 40.18           C  
ATOM   2014  CE  LYS A 264       7.421  32.958 -22.868  1.00 42.39           C  
ATOM   2015  NZ  LYS A 264       6.681  31.780 -22.340  1.00 46.77           N  
ATOM   2016  N   ASP A 265      13.063  34.068 -19.107  1.00 30.33           N  
ATOM   2017  CA  ASP A 265      14.128  34.915 -18.600  1.00 30.74           C  
ATOM   2018  C   ASP A 265      14.446  36.134 -19.502  1.00 29.24           C  
ATOM   2019  O   ASP A 265      15.382  36.880 -19.228  1.00 28.64           O  
ATOM   2020  CB  ASP A 265      15.375  34.074 -18.331  1.00 35.15           C  
ATOM   2021  CG  ASP A 265      16.090  33.637 -19.611  1.00 36.82           C  
ATOM   2022  OD1 ASP A 265      15.516  33.676 -20.726  1.00 36.45           O  
ATOM   2023  OD2 ASP A 265      17.258  33.244 -19.484  1.00 40.54           O  
ATOM   2024  N   ASP A 266      13.640  36.339 -20.536  1.00 32.03           N  
ATOM   2025  CA  ASP A 266      13.777  37.490 -21.428  1.00 34.73           C  
ATOM   2026  C   ASP A 266      13.686  38.809 -20.658  1.00 34.74           C  
ATOM   2027  O   ASP A 266      12.820  38.962 -19.793  1.00 29.80           O  
ATOM   2028  CB  ASP A 266      12.683  37.430 -22.496  1.00 41.46           C  
ATOM   2029  CG  ASP A 266      12.686  36.112 -23.242  1.00 46.90           C  
ATOM   2030  OD1 ASP A 266      13.020  36.113 -24.451  1.00 50.52           O  
ATOM   2031  OD2 ASP A 266      12.394  35.066 -22.616  1.00 47.85           O  
ATOM   2032  N   ALA A 267      14.587  39.751 -20.950  1.00 32.06           N  
ATOM   2033  CA  ALA A 267      14.535  41.056 -20.304  1.00 31.85           C  
ATOM   2034  C   ALA A 267      13.136  41.603 -20.541  1.00 27.22           C  
ATOM   2035  O   ALA A 267      12.652  41.610 -21.668  1.00 29.55           O  
ATOM   2036  CB  ALA A 267      15.601  42.001 -20.877  1.00 33.89           C  
ATOM   2037  N   ASN A 268      12.463  42.015 -19.476  1.00 25.74           N  
ATOM   2038  CA  ASN A 268      11.101  42.497 -19.606  1.00 23.48           C  
ATOM   2039  C   ASN A 268      10.845  43.586 -18.596  1.00 23.21           C  
ATOM   2040  O   ASN A 268      10.888  43.353 -17.381  1.00 18.50           O  
ATOM   2041  CB  ASN A 268      10.075  41.338 -19.486  1.00 21.86           C  
ATOM   2042  CG  ASN A 268       8.641  41.779 -19.792  1.00 25.20           C  
ATOM   2043  OD1 ASN A 268       8.272  42.934 -19.580  1.00 19.42           O  
ATOM   2044  ND2 ASN A 268       7.824  40.853 -20.304  1.00 25.18           N  
ATOM   2045  N   GLU A 269      10.571  44.791 -19.097  1.00 21.73           N  
ATOM   2046  CA  GLU A 269      10.482  45.963 -18.229  1.00 21.31           C  
ATOM   2047  C   GLU A 269       9.417  45.880 -17.132  1.00 22.87           C  
ATOM   2048  O   GLU A 269       9.446  46.646 -16.154  1.00 23.21           O  
ATOM   2049  CB  GLU A 269      10.263  47.228 -19.063  1.00 20.70           C  
ATOM   2050  CG  GLU A 269       9.049  47.141 -20.008  1.00 18.81           C  
ATOM   2051  CD  GLU A 269       7.713  47.418 -19.326  1.00 21.35           C  
ATOM   2052  OE1 GLU A 269       6.674  46.899 -19.827  1.00 23.03           O  
ATOM   2053  OE2 GLU A 269       7.686  48.108 -18.285  1.00 20.16           O  
ATOM   2054  N   ILE A 270       8.468  44.967 -17.285  1.00 19.21           N  
ATOM   2055  CA  ILE A 270       7.457  44.790 -16.235  1.00 17.99           C  
ATOM   2056  C   ILE A 270       8.176  44.422 -14.931  1.00 19.53           C  
ATOM   2057  O   ILE A 270       7.689  44.717 -13.844  1.00 20.77           O  
ATOM   2058  CB  ILE A 270       6.420  43.702 -16.641  1.00 15.39           C  
ATOM   2059  CG1 ILE A 270       5.508  44.226 -17.764  1.00 16.77           C  
ATOM   2060  CG2 ILE A 270       5.589  43.249 -15.472  1.00 16.11           C  
ATOM   2061  CD1 ILE A 270       4.908  43.089 -18.613  1.00 17.41           C  
ATOM   2062  N   PHE A 271       9.378  43.843 -15.046  1.00 19.06           N  
ATOM   2063  CA  PHE A 271      10.070  43.389 -13.840  1.00 21.08           C  
ATOM   2064  C   PHE A 271      11.280  44.229 -13.487  1.00 22.36           C  
ATOM   2065  O   PHE A 271      12.100  43.814 -12.693  1.00 23.25           O  
ATOM   2066  CB  PHE A 271      10.421  41.899 -13.967  1.00 19.39           C  
ATOM   2067  CG  PHE A 271       9.212  41.036 -14.229  1.00 19.12           C  
ATOM   2068  CD1 PHE A 271       8.422  40.600 -13.168  1.00 18.01           C  
ATOM   2069  CD2 PHE A 271       8.837  40.699 -15.543  1.00 21.16           C  
ATOM   2070  CE1 PHE A 271       7.276  39.814 -13.400  1.00 20.66           C  
ATOM   2071  CE2 PHE A 271       7.703  39.905 -15.778  1.00 23.08           C  
ATOM   2072  CZ  PHE A 271       6.928  39.467 -14.717  1.00 19.46           C  
ATOM   2073  N   SER A 272      11.337  45.438 -14.049  1.00 22.08           N  
ATOM   2074  CA  SER A 272      12.499  46.336 -13.942  1.00 26.49           C  
ATOM   2075  C   SER A 272      12.602  47.081 -12.612  1.00 23.34           C  
ATOM   2076  O   SER A 272      13.697  47.450 -12.171  1.00 25.10           O  
ATOM   2077  CB  SER A 272      12.506  47.348 -15.128  1.00 24.29           C  
ATOM   2078  OG  SER A 272      11.338  48.198 -15.116  1.00 26.73           O  
ATOM   2079  N   LYS A 273      11.460  47.307 -11.975  1.00 21.79           N  
ATOM   2080  CA  LYS A 273      11.352  48.205 -10.819  1.00 21.95           C  
ATOM   2081  C   LYS A 273      10.437  47.599  -9.752  1.00 24.45           C  
ATOM   2082  O   LYS A 273       9.581  46.777 -10.080  1.00 21.96           O  
ATOM   2083  CB  LYS A 273      10.803  49.584 -11.275  1.00 19.06           C  
ATOM   2084  CG  LYS A 273      11.702  50.294 -12.339  1.00 18.80           C  
ATOM   2085  CD  LYS A 273      11.157  51.680 -12.709  1.00 20.48           C  
ATOM   2086  CE  LYS A 273       9.831  51.649 -13.526  1.00 20.95           C  
ATOM   2087  NZ  LYS A 273       9.879  50.690 -14.691  1.00 20.89           N  
ATOM   2088  N   PRO A 274      10.628  47.977  -8.472  1.00 23.74           N  
ATOM   2089  CA  PRO A 274       9.881  47.353  -7.365  1.00 24.70           C  
ATOM   2090  C   PRO A 274       8.410  47.722  -7.270  1.00 25.61           C  
ATOM   2091  O   PRO A 274       7.991  48.313  -6.282  1.00 27.31           O  
ATOM   2092  CB  PRO A 274      10.632  47.836  -6.113  1.00 23.24           C  
ATOM   2093  CG  PRO A 274      11.257  49.161  -6.543  1.00 27.14           C  
ATOM   2094  CD  PRO A 274      11.651  48.932  -7.983  1.00 23.51           C  
ATOM   2095  N   ILE A 275       7.624  47.337  -8.268  1.00 23.66           N  
ATOM   2096  CA  ILE A 275       6.181  47.523  -8.227  1.00 21.61           C  
ATOM   2097  C   ILE A 275       5.520  46.336  -7.504  1.00 21.98           C  
ATOM   2098  O   ILE A 275       6.180  45.346  -7.234  1.00 20.80           O  
ATOM   2099  CB  ILE A 275       5.619  47.694  -9.670  1.00 22.30           C  
ATOM   2100  CG1 ILE A 275       5.804  46.387 -10.479  1.00 21.00           C  
ATOM   2101  CG2 ILE A 275       6.263  48.923 -10.375  1.00 21.74           C  
ATOM   2102  CD1 ILE A 275       5.103  46.400 -11.893  1.00 23.72           C  
ATOM   2103  N   ALA A 276       4.226  46.436  -7.225  1.00 20.69           N  
ATOM   2104  CA  ALA A 276       3.488  45.375  -6.544  1.00 21.80           C  
ATOM   2105  C   ALA A 276       3.387  44.143  -7.443  1.00 23.54           C  
ATOM   2106  O   ALA A 276       3.237  44.257  -8.662  1.00 21.10           O  
ATOM   2107  CB  ALA A 276       2.109  45.855  -6.179  1.00 22.02           C  
ATOM   2108  N   TRP A 277       3.440  42.970  -6.821  1.00 19.29           N  
ATOM   2109  CA  TRP A 277       3.245  41.719  -7.538  1.00 21.09           C  
ATOM   2110  C   TRP A 277       1.956  41.697  -8.357  1.00 17.17           C  
ATOM   2111  O   TRP A 277       1.957  41.292  -9.526  1.00 19.65           O  
ATOM   2112  CB  TRP A 277       3.280  40.549  -6.560  1.00 15.73           C  
ATOM   2113  CG  TRP A 277       4.654  39.857  -6.562  1.00 16.26           C  
ATOM   2114  CD1 TRP A 277       5.627  39.924  -5.582  1.00 17.45           C  
ATOM   2115  CD2 TRP A 277       5.195  39.053  -7.611  1.00 16.38           C  
ATOM   2116  NE1 TRP A 277       6.733  39.176  -5.964  1.00 15.75           N  
ATOM   2117  CE2 TRP A 277       6.488  38.627  -7.197  1.00 16.48           C  
ATOM   2118  CE3 TRP A 277       4.705  38.626  -8.856  1.00 17.35           C  
ATOM   2119  CZ2 TRP A 277       7.303  37.812  -7.993  1.00 16.18           C  
ATOM   2120  CZ3 TRP A 277       5.522  37.798  -9.648  1.00 16.06           C  
ATOM   2121  CH2 TRP A 277       6.802  37.412  -9.212  1.00 18.14           C  
ATOM   2122  N   ASN A 278       0.859  42.179  -7.773  1.00 17.01           N  
ATOM   2123  CA  ASN A 278      -0.420  42.168  -8.506  1.00 17.16           C  
ATOM   2124  C   ASN A 278      -0.406  43.094  -9.731  1.00 19.08           C  
ATOM   2125  O   ASN A 278      -1.059  42.810 -10.725  1.00 17.58           O  
ATOM   2126  CB  ASN A 278      -1.642  42.407  -7.588  1.00 19.41           C  
ATOM   2127  CG  ASN A 278      -1.579  43.724  -6.811  1.00 26.10           C  
ATOM   2128  OD1 ASN A 278      -0.789  44.613  -7.113  1.00 25.76           O  
ATOM   2129  ND2 ASN A 278      -2.427  43.839  -5.788  1.00 26.95           N  
ATOM   2130  N   GLU A 279       0.376  44.168  -9.670  1.00 17.94           N  
ATOM   2131  CA  GLU A 279       0.521  45.055 -10.818  1.00 20.29           C  
ATOM   2132  C   GLU A 279       1.450  44.434 -11.867  1.00 19.99           C  
ATOM   2133  O   GLU A 279       1.173  44.470 -13.073  1.00 18.76           O  
ATOM   2134  CB  GLU A 279       0.997  46.447 -10.361  1.00 20.77           C  
ATOM   2135  CG  GLU A 279       1.201  47.428 -11.514  1.00 22.90           C  
ATOM   2136  CD  GLU A 279      -0.098  47.821 -12.180  1.00 25.43           C  
ATOM   2137  OE1 GLU A 279      -1.123  48.011 -11.479  1.00 25.23           O  
ATOM   2138  OE2 GLU A 279      -0.088  47.938 -13.412  1.00 24.60           O  
ATOM   2139  N   ALA A 280       2.539  43.829 -11.404  1.00 16.66           N  
ATOM   2140  CA  ALA A 280       3.401  43.109 -12.312  1.00 15.52           C  
ATOM   2141  C   ALA A 280       2.627  42.042 -13.073  1.00 16.75           C  
ATOM   2142  O   ALA A 280       2.762  41.960 -14.274  1.00 18.03           O  
ATOM   2143  CB  ALA A 280       4.583  42.495 -11.549  1.00 17.82           C  
ATOM   2144  N   LEU A 281       1.837  41.223 -12.364  1.00 15.76           N  
ATOM   2145  CA  LEU A 281       1.092  40.133 -13.008  1.00 19.53           C  
ATOM   2146  C   LEU A 281      -0.004  40.702 -13.902  1.00 21.89           C  
ATOM   2147  O   LEU A 281      -0.256  40.181 -14.987  1.00 21.89           O  
ATOM   2148  CB  LEU A 281       0.473  39.186 -11.978  1.00 21.51           C  
ATOM   2149  CG  LEU A 281       1.302  38.056 -11.358  1.00 27.12           C  
ATOM   2150  CD1 LEU A 281       0.338  37.084 -10.655  1.00 25.93           C  
ATOM   2151  CD2 LEU A 281       2.202  37.315 -12.384  1.00 26.15           C  
ATOM   2152  N   LYS A 282      -0.633  41.793 -13.466  1.00 18.89           N  
ATOM   2153  CA  LYS A 282      -1.655  42.427 -14.316  1.00 20.11           C  
ATOM   2154  C   LYS A 282      -1.055  42.750 -15.667  1.00 21.12           C  
ATOM   2155  O   LYS A 282      -1.642  42.422 -16.701  1.00 20.43           O  
ATOM   2156  CB  LYS A 282      -2.262  43.684 -13.667  1.00 21.45           C  
ATOM   2157  CG  LYS A 282      -3.330  44.413 -14.566  1.00 25.59           C  
ATOM   2158  CD  LYS A 282      -3.467  45.870 -14.159  1.00 29.57           C  
ATOM   2159  CE  LYS A 282      -4.490  46.626 -15.003  1.00 30.19           C  
ATOM   2160  NZ  LYS A 282      -3.851  47.077 -16.257  1.00 38.12           N  
ATOM   2161  N   GLN A 283       0.104  43.422 -15.669  1.00 19.80           N  
ATOM   2162  CA  GLN A 283       0.748  43.806 -16.927  1.00 19.86           C  
ATOM   2163  C   GLN A 283       1.225  42.609 -17.738  1.00 19.83           C  
ATOM   2164  O   GLN A 283       1.088  42.571 -18.971  1.00 19.68           O  
ATOM   2165  CB  GLN A 283       1.936  44.730 -16.650  1.00 21.75           C  
ATOM   2166  CG  GLN A 283       1.478  46.060 -16.004  1.00 21.13           C  
ATOM   2167  CD  GLN A 283       2.638  46.988 -15.662  1.00 20.81           C  
ATOM   2168  OE1 GLN A 283       3.711  46.958 -16.292  1.00 19.29           O  
ATOM   2169  NE2 GLN A 283       2.422  47.825 -14.647  1.00 21.76           N  
ATOM   2170  N   TYR A 284       1.803  41.642 -17.042  1.00 17.89           N  
ATOM   2171  CA  TYR A 284       2.391  40.484 -17.691  1.00 21.15           C  
ATOM   2172  C   TYR A 284       1.346  39.533 -18.296  1.00 20.92           C  
ATOM   2173  O   TYR A 284       1.536  39.037 -19.411  1.00 24.71           O  
ATOM   2174  CB  TYR A 284       3.310  39.748 -16.705  1.00 20.78           C  
ATOM   2175  CG  TYR A 284       4.237  38.767 -17.361  1.00 21.25           C  
ATOM   2176  CD1 TYR A 284       5.037  39.148 -18.426  1.00 20.99           C  
ATOM   2177  CD2 TYR A 284       4.332  37.462 -16.898  1.00 19.23           C  
ATOM   2178  CE1 TYR A 284       5.895  38.249 -19.046  1.00 21.76           C  
ATOM   2179  CE2 TYR A 284       5.208  36.559 -17.494  1.00 21.61           C  
ATOM   2180  CZ  TYR A 284       5.984  36.961 -18.559  1.00 22.76           C  
ATOM   2181  OH  TYR A 284       6.856  36.104 -19.159  1.00 24.06           O  
ATOM   2182  N   LEU A 285       0.259  39.297 -17.556  1.00 24.60           N  
ATOM   2183  CA  LEU A 285      -0.823  38.409 -17.987  1.00 24.39           C  
ATOM   2184  C   LEU A 285      -1.874  39.128 -18.845  1.00 26.42           C  
ATOM   2185  O   LEU A 285      -2.736  38.468 -19.448  1.00 28.87           O  
ATOM   2186  CB  LEU A 285      -1.520  37.790 -16.781  1.00 24.01           C  
ATOM   2187  CG  LEU A 285      -0.654  37.032 -15.764  1.00 26.09           C  
ATOM   2188  CD1 LEU A 285      -1.474  36.473 -14.567  1.00 25.99           C  
ATOM   2189  CD2 LEU A 285       0.199  35.947 -16.423  1.00 24.87           C  
ATOM   2190  N   GLY A 286      -1.796  40.456 -18.911  1.00 26.00           N  
ATOM   2191  CA  GLY A 286      -2.822  41.262 -19.552  1.00 24.35           C  
ATOM   2192  C   GLY A 286      -4.166  41.150 -18.866  1.00 28.46           C  
ATOM   2193  O   GLY A 286      -5.221  41.079 -19.518  1.00 28.60           O  
ATOM   2194  N   ALA A 287      -4.141  41.152 -17.546  1.00 24.78           N  
ATOM   2195  CA  ALA A 287      -5.359  41.035 -16.777  1.00 24.68           C  
ATOM   2196  C   ALA A 287      -6.141  42.352 -16.805  1.00 30.05           C  
ATOM   2197  O   ALA A 287      -5.561  43.417 -17.051  1.00 29.14           O  
ATOM   2198  CB  ALA A 287      -5.043  40.648 -15.353  1.00 25.17           C  
ATOM   2199  N   LYS A 288      -7.448  42.277 -16.527  1.00 31.11           N  
ATOM   2200  CA  LYS A 288      -8.318  43.464 -16.512  1.00 36.31           C  
ATOM   2201  C   LYS A 288      -7.908  44.483 -15.464  1.00 33.82           C  
ATOM   2202  O   LYS A 288      -7.981  45.691 -15.688  1.00 31.12           O  
ATOM   2203  CB  LYS A 288      -9.790  43.066 -16.313  1.00 40.09           C  
ATOM   2204  CG  LYS A 288     -10.417  42.524 -17.595  1.00 44.37           C  
ATOM   2205  CD  LYS A 288     -11.808  41.908 -17.422  1.00 44.71           C  
ATOM   2206  CE  LYS A 288     -12.274  41.332 -18.779  1.00 46.09           C  
ATOM   2207  NZ  LYS A 288     -13.677  40.799 -18.756  1.00 49.58           N  
ATOM   2208  N   SER A 289      -7.485  43.971 -14.317  1.00 30.51           N  
ATOM   2209  CA  SER A 289      -7.093  44.783 -13.186  1.00 29.40           C  
ATOM   2210  C   SER A 289      -6.186  43.926 -12.294  1.00 28.39           C  
ATOM   2211  O   SER A 289      -5.863  42.774 -12.638  1.00 26.12           O  
ATOM   2212  CB  SER A 289      -8.325  45.275 -12.418  1.00 28.85           C  
ATOM   2213  OG  SER A 289      -8.851  44.266 -11.554  1.00 32.63           O  
ATOM   2214  N   THR A 290      -5.782  44.513 -11.173  1.00 24.99           N  
ATOM   2215  CA  THR A 290      -4.958  43.860 -10.156  1.00 25.72           C  
ATOM   2216  C   THR A 290      -5.773  43.051  -9.152  1.00 25.60           C  
ATOM   2217  O   THR A 290      -5.193  42.453  -8.250  1.00 25.88           O  
ATOM   2218  CB  THR A 290      -4.198  44.895  -9.315  1.00 28.32           C  
ATOM   2219  OG1 THR A 290      -5.138  45.843  -8.787  1.00 28.39           O  
ATOM   2220  CG2 THR A 290      -3.151  45.630 -10.153  1.00 26.27           C  
ATOM   2221  N   SER A 291      -7.109  43.055  -9.273  1.00 24.69           N  
ATOM   2222  CA  SER A 291      -7.951  42.297  -8.336  1.00 27.74           C  
ATOM   2223  C   SER A 291      -7.627  40.809  -8.465  1.00 27.18           C  
ATOM   2224  O   SER A 291      -7.298  40.327  -9.558  1.00 22.54           O  
ATOM   2225  CB  SER A 291      -9.450  42.504  -8.605  1.00 28.27           C  
ATOM   2226  OG  SER A 291      -9.870  41.851  -9.801  1.00 28.37           O  
ATOM   2227  N   LYS A 292      -7.738  40.088  -7.351  1.00 27.05           N  
ATOM   2228  CA  LYS A 292      -7.452  38.661  -7.377  1.00 28.96           C  
ATOM   2229  C   LYS A 292      -8.324  37.992  -8.425  1.00 28.43           C  
ATOM   2230  O   LYS A 292      -7.877  37.113  -9.167  1.00 25.36           O  
ATOM   2231  CB  LYS A 292      -7.690  38.029  -6.005  1.00 34.24           C  
ATOM   2232  CG  LYS A 292      -7.480  36.519  -6.011  1.00 39.52           C  
ATOM   2233  CD  LYS A 292      -8.071  35.843  -4.787  1.00 42.98           C  
ATOM   2234  CE  LYS A 292      -7.069  35.832  -3.640  1.00 45.36           C  
ATOM   2235  NZ  LYS A 292      -7.203  34.609  -2.755  1.00 48.54           N  
ATOM   2236  N   GLU A 293      -9.571  38.441  -8.505  1.00 28.44           N  
ATOM   2237  CA  GLU A 293     -10.521  37.889  -9.430  1.00 30.80           C  
ATOM   2238  C   GLU A 293     -10.044  38.018 -10.868  1.00 29.95           C  
ATOM   2239  O   GLU A 293     -10.127  37.056 -11.641  1.00 27.29           O  
ATOM   2240  CB  GLU A 293     -11.885  38.578  -9.259  1.00 32.69           C  
ATOM   2241  CG  GLU A 293     -12.904  38.119 -10.284  1.00 39.47           C  
ATOM   2242  CD  GLU A 293     -14.310  38.681 -10.058  1.00 41.40           C  
ATOM   2243  OE1 GLU A 293     -14.492  39.638  -9.261  1.00 43.46           O  
ATOM   2244  OE2 GLU A 293     -15.236  38.150 -10.696  1.00 43.83           O  
ATOM   2245  N   ASP A 294      -9.562  39.200 -11.253  1.00 26.58           N  
ATOM   2246  CA  ASP A 294      -9.115  39.403 -12.639  1.00 26.65           C  
ATOM   2247  C   ASP A 294      -7.799  38.713 -12.964  1.00 22.80           C  
ATOM   2248  O   ASP A 294      -7.571  38.274 -14.102  1.00 25.89           O  
ATOM   2249  CB  ASP A 294      -9.012  40.891 -12.970  1.00 29.92           C  
ATOM   2250  CG  ASP A 294     -10.382  41.564 -13.055  1.00 35.51           C  
ATOM   2251  OD1 ASP A 294     -11.395  40.855 -13.310  1.00 34.27           O  
ATOM   2252  OD2 ASP A 294     -10.439  42.797 -12.854  1.00 32.29           O  
ATOM   2253  N   LEU A 295      -6.921  38.662 -11.971  1.00 23.59           N  
ATOM   2254  CA  LEU A 295      -5.641  37.946 -12.144  1.00 24.03           C  
ATOM   2255  C   LEU A 295      -5.906  36.456 -12.413  1.00 23.90           C  
ATOM   2256  O   LEU A 295      -5.350  35.868 -13.352  1.00 22.73           O  
ATOM   2257  CB  LEU A 295      -4.742  38.150 -10.927  1.00 23.83           C  
ATOM   2258  CG  LEU A 295      -4.252  39.602 -10.728  1.00 23.79           C  
ATOM   2259  CD1 LEU A 295      -3.427  39.732  -9.492  1.00 20.39           C  
ATOM   2260  CD2 LEU A 295      -3.448  40.098 -11.951  1.00 23.58           C  
ATOM   2261  N   ILE A 296      -6.788  35.871 -11.603  1.00 24.96           N  
ATOM   2262  CA  ILE A 296      -7.154  34.446 -11.756  1.00 24.27           C  
ATOM   2263  C   ILE A 296      -7.806  34.185 -13.093  1.00 26.69           C  
ATOM   2264  O   ILE A 296      -7.485  33.201 -13.761  1.00 26.59           O  
ATOM   2265  CB  ILE A 296      -8.007  33.953 -10.563  1.00 26.01           C  
ATOM   2266  CG1 ILE A 296      -7.140  33.938  -9.299  1.00 24.41           C  
ATOM   2267  CG2 ILE A 296      -8.624  32.567 -10.845  1.00 26.52           C  
ATOM   2268  CD1 ILE A 296      -7.848  33.535  -7.991  1.00 25.65           C  
ATOM   2269  N   ALA A 297      -8.699  35.086 -13.516  1.00 26.29           N  
ATOM   2270  CA  ALA A 297      -9.261  34.979 -14.862  1.00 27.16           C  
ATOM   2271  C   ALA A 297      -8.200  34.863 -15.949  1.00 26.00           C  
ATOM   2272  O   ALA A 297      -8.294  34.014 -16.830  1.00 29.74           O  
ATOM   2273  CB  ALA A 297     -10.204  36.141 -15.156  1.00 27.36           C  
ATOM   2274  N   SER A 298      -7.176  35.706 -15.908  1.00 27.12           N  
ATOM   2275  CA  SER A 298      -6.150  35.607 -16.935  1.00 26.54           C  
ATOM   2276  C   SER A 298      -5.306  34.343 -16.779  1.00 26.75           C  
ATOM   2277  O   SER A 298      -4.839  33.807 -17.775  1.00 29.09           O  
ATOM   2278  CB  SER A 298      -5.292  36.879 -17.041  1.00 31.23           C  
ATOM   2279  OG  SER A 298      -5.137  37.497 -15.786  1.00 41.78           O  
ATOM   2280  N   ILE A 299      -5.116  33.872 -15.545  1.00 24.52           N  
ATOM   2281  CA  ILE A 299      -4.388  32.604 -15.346  1.00 23.54           C  
ATOM   2282  C   ILE A 299      -5.229  31.461 -15.936  1.00 25.71           C  
ATOM   2283  O   ILE A 299      -4.720  30.676 -16.744  1.00 25.32           O  
ATOM   2284  CB  ILE A 299      -4.073  32.328 -13.867  1.00 18.76           C  
ATOM   2285  CG1 ILE A 299      -3.032  33.350 -13.370  1.00 17.27           C  
ATOM   2286  CG2 ILE A 299      -3.532  30.887 -13.650  1.00 18.16           C  
ATOM   2287  CD1 ILE A 299      -2.862  33.385 -11.845  1.00 17.79           C  
ATOM   2288  N   ASP A 300      -6.500  31.405 -15.538  1.00 27.15           N  
ATOM   2289  CA  ASP A 300      -7.445  30.374 -16.025  1.00 33.13           C  
ATOM   2290  C   ASP A 300      -7.419  30.292 -17.546  1.00 34.61           C  
ATOM   2291  O   ASP A 300      -7.406  29.201 -18.114  1.00 37.04           O  
ATOM   2292  CB  ASP A 300      -8.877  30.642 -15.522  1.00 28.91           C  
ATOM   2293  CG  ASP A 300      -9.093  30.183 -14.088  1.00 29.11           C  
ATOM   2294  OD1 ASP A 300      -8.321  29.327 -13.623  1.00 30.33           O  
ATOM   2295  OD2 ASP A 300     -10.027  30.670 -13.416  1.00 29.41           O  
ATOM   2296  N   SER A 301      -7.360  31.449 -18.207  1.00 36.50           N  
ATOM   2297  CA  SER A 301      -7.403  31.497 -19.666  1.00 37.10           C  
ATOM   2298  C   SER A 301      -6.123  30.958 -20.320  1.00 38.47           C  
ATOM   2299  O   SER A 301      -6.068  30.769 -21.533  1.00 38.15           O  
ATOM   2300  CB  SER A 301      -7.697  32.928 -20.133  1.00 37.13           C  
ATOM   2301  OG  SER A 301      -6.502  33.680 -20.190  1.00 40.77           O  
ATOM   2302  N   LYS A 302      -5.095  30.704 -19.510  1.00 38.30           N  
ATOM   2303  CA  LYS A 302      -3.794  30.313 -20.024  1.00 37.19           C  
ATOM   2304  C   LYS A 302      -3.403  28.935 -19.554  1.00 39.15           C  
ATOM   2305  O   LYS A 302      -2.532  28.296 -20.164  1.00 37.37           O  
ATOM   2306  CB  LYS A 302      -2.705  31.273 -19.548  1.00 39.67           C  
ATOM   2307  CG  LYS A 302      -2.742  32.662 -20.150  1.00 40.97           C  
ATOM   2308  CD  LYS A 302      -1.626  33.513 -19.554  1.00 39.48           C  
ATOM   2309  CE  LYS A 302      -1.581  34.885 -20.190  1.00 41.55           C  
ATOM   2310  NZ  LYS A 302      -2.812  35.658 -19.839  1.00 41.76           N  
ATOM   2311  N   ALA A 303      -4.010  28.505 -18.447  1.00 40.36           N  
ATOM   2312  CA  ALA A 303      -3.577  27.295 -17.759  1.00 41.01           C  
ATOM   2313  C   ALA A 303      -4.472  26.112 -18.067  1.00 41.36           C  
ATOM   2314  O   ALA A 303      -5.688  26.264 -18.192  1.00 43.24           O  
ATOM   2315  CB  ALA A 303      -3.510  27.522 -16.262  1.00 39.82           C  
ATOM   2316  N   THR A 304      -3.851  24.939 -18.177  1.00 40.18           N  
ATOM   2317  CA  THR A 304      -4.570  23.663 -18.213  1.00 40.77           C  
ATOM   2318  C   THR A 304      -4.469  23.017 -16.849  1.00 36.43           C  
ATOM   2319  O   THR A 304      -3.386  22.612 -16.440  1.00 38.21           O  
ATOM   2320  CB  THR A 304      -3.963  22.710 -19.253  1.00 42.05           C  
ATOM   2321  OG1 THR A 304      -3.695  23.439 -20.460  1.00 45.19           O  
ATOM   2322  CG2 THR A 304      -4.915  21.547 -19.548  1.00 44.18           C  
ATOM   2323  N   TRP A 305      -5.597  22.934 -16.147  1.00 34.23           N  
ATOM   2324  CA  TRP A 305      -5.638  22.338 -14.823  1.00 33.12           C  
ATOM   2325  C   TRP A 305      -5.958  20.843 -14.871  1.00 36.60           C  
ATOM   2326  O   TRP A 305      -6.798  20.411 -15.655  1.00 35.34           O  
ATOM   2327  CB  TRP A 305      -6.711  23.008 -13.991  1.00 31.63           C  
ATOM   2328  CG  TRP A 305      -6.619  24.488 -13.909  1.00 32.20           C  
ATOM   2329  CD1 TRP A 305      -7.523  25.383 -14.391  1.00 31.52           C  
ATOM   2330  CD2 TRP A 305      -5.575  25.256 -13.283  1.00 31.16           C  
ATOM   2331  NE1 TRP A 305      -7.114  26.670 -14.099  1.00 32.95           N  
ATOM   2332  CE2 TRP A 305      -5.931  26.621 -13.410  1.00 31.46           C  
ATOM   2333  CE3 TRP A 305      -4.387  24.923 -12.607  1.00 30.87           C  
ATOM   2334  CZ2 TRP A 305      -5.131  27.659 -12.908  1.00 29.35           C  
ATOM   2335  CZ3 TRP A 305      -3.594  25.951 -12.097  1.00 30.48           C  
ATOM   2336  CH2 TRP A 305      -3.976  27.310 -12.252  1.00 30.28           C  
ATOM   2337  N   LYS A 306      -5.325  20.071 -13.991  1.00 38.05           N  
ATOM   2338  CA  LYS A 306      -5.616  18.634 -13.867  1.00 40.07           C  
ATOM   2339  C   LYS A 306      -7.041  18.390 -13.393  1.00 40.51           C  
ATOM   2340  O   LYS A 306      -7.724  17.494 -13.888  1.00 41.88           O  
ATOM   2341  CB  LYS A 306      -4.630  17.966 -12.905  1.00 42.28           C  
ATOM   2342  CG  LYS A 306      -3.314  17.621 -13.556  1.00 44.83           C  
ATOM   2343  CD  LYS A 306      -2.516  16.600 -12.753  1.00 46.03           C  
ATOM   2344  CE  LYS A 306      -1.204  16.255 -13.498  1.00 45.58           C  
ATOM   2345  NZ  LYS A 306      -0.227  15.610 -12.578  1.00 44.36           N  
ATOM   2346  N   ASP A 307      -7.474  19.193 -12.425  1.00 39.49           N  
ATOM   2347  CA  ASP A 307      -8.817  19.128 -11.862  1.00 38.06           C  
ATOM   2348  C   ASP A 307      -9.048  20.341 -10.964  1.00 38.59           C  
ATOM   2349  O   ASP A 307      -8.138  21.147 -10.766  1.00 36.11           O  
ATOM   2350  CB  ASP A 307      -9.057  17.797 -11.106  1.00 42.58           C  
ATOM   2351  CG  ASP A 307      -7.986  17.495 -10.047  1.00 45.37           C  
ATOM   2352  OD1 ASP A 307      -7.738  18.327  -9.146  1.00 44.43           O  
ATOM   2353  OD2 ASP A 307      -7.409  16.383 -10.100  1.00 47.97           O  
ATOM   2354  N   ASP A 308     -10.254  20.470 -10.419  1.00 36.54           N  
ATOM   2355  CA  ASP A 308     -10.608  21.632  -9.617  1.00 37.44           C  
ATOM   2356  C   ASP A 308      -9.823  21.655  -8.314  1.00 35.34           C  
ATOM   2357  O   ASP A 308      -9.507  22.731  -7.804  1.00 31.85           O  
ATOM   2358  CB  ASP A 308     -12.117  21.672  -9.318  1.00 40.40           C  
ATOM   2359  CG  ASP A 308     -12.968  21.847 -10.573  1.00 43.90           C  
ATOM   2360  OD1 ASP A 308     -12.417  22.121 -11.669  1.00 43.37           O  
ATOM   2361  OD2 ASP A 308     -14.210  21.693 -10.463  1.00 45.54           O  
ATOM   2362  N   GLU A 309      -9.525  20.471  -7.766  1.00 33.37           N  
ATOM   2363  CA  GLU A 309      -8.785  20.397  -6.520  1.00 34.81           C  
ATOM   2364  C   GLU A 309      -7.359  20.966  -6.721  1.00 31.05           C  
ATOM   2365  O   GLU A 309      -6.853  21.706  -5.879  1.00 28.10           O  
ATOM   2366  CB  GLU A 309      -8.764  18.948  -5.980  1.00 36.51           C  
ATOM   2367  CG  GLU A 309      -7.842  18.720  -4.769  1.00 38.92           C  
ATOM   2368  CD  GLU A 309      -7.754  17.241  -4.319  1.00 41.46           C  
ATOM   2369  OE1 GLU A 309      -8.568  16.408  -4.783  1.00 41.73           O  
ATOM   2370  OE2 GLU A 309      -6.870  16.920  -3.486  1.00 44.06           O  
ATOM   2371  N   ASP A 310      -6.738  20.595  -7.834  1.00 27.70           N  
ATOM   2372  CA  ASP A 310      -5.400  21.042  -8.188  1.00 31.71           C  
ATOM   2373  C   ASP A 310      -5.376  22.545  -8.498  1.00 30.63           C  
ATOM   2374  O   ASP A 310      -4.503  23.275  -8.027  1.00 30.95           O  
ATOM   2375  CB  ASP A 310      -4.910  20.275  -9.411  1.00 34.82           C  
ATOM   2376  CG  ASP A 310      -3.511  19.720  -9.226  1.00 39.50           C  
ATOM   2377  OD1 ASP A 310      -3.205  19.235  -8.104  1.00 42.35           O  
ATOM   2378  OD2 ASP A 310      -2.727  19.760 -10.195  1.00 38.54           O  
ATOM   2379  N   ARG A 311      -6.336  22.985  -9.310  1.00 29.95           N  
ATOM   2380  CA  ARG A 311      -6.534  24.411  -9.566  1.00 27.68           C  
ATOM   2381  C   ARG A 311      -6.641  25.182  -8.264  1.00 27.89           C  
ATOM   2382  O   ARG A 311      -5.937  26.168  -8.070  1.00 25.70           O  
ATOM   2383  CB  ARG A 311      -7.761  24.653 -10.450  1.00 29.27           C  
ATOM   2384  CG  ARG A 311      -8.092  26.142 -10.629  1.00 25.34           C  
ATOM   2385  CD  ARG A 311      -9.353  26.334 -11.476  1.00 26.75           C  
ATOM   2386  NE  ARG A 311      -9.706  27.753 -11.586  1.00 28.62           N  
ATOM   2387  CZ  ARG A 311     -10.344  28.442 -10.651  1.00 26.86           C  
ATOM   2388  NH1 ARG A 311     -10.725  27.843  -9.529  1.00 27.88           N  
ATOM   2389  NH2 ARG A 311     -10.603  29.743 -10.847  1.00 29.08           N  
ATOM   2390  N   GLU A 312      -7.502  24.728  -7.353  1.00 25.50           N  
ATOM   2391  CA  GLU A 312      -7.667  25.404  -6.075  1.00 27.70           C  
ATOM   2392  C   GLU A 312      -6.356  25.444  -5.301  1.00 28.50           C  
ATOM   2393  O   GLU A 312      -5.998  26.480  -4.695  1.00 23.77           O  
ATOM   2394  CB  GLU A 312      -8.780  24.730  -5.266  1.00 30.33           C  
ATOM   2395  CG  GLU A 312      -9.144  25.438  -3.972  1.00 35.90           C  
ATOM   2396  CD  GLU A 312     -10.416  24.888  -3.303  0.80 36.70           C  
ATOM   2397  OE1 GLU A 312     -11.027  23.933  -3.831  0.80 41.91           O  
ATOM   2398  OE2 GLU A 312     -10.807  25.419  -2.240  0.80 40.71           O  
ATOM   2399  N   ARG A 313      -5.635  24.314  -5.321  1.00 26.80           N  
ATOM   2400  CA  ARG A 313      -4.376  24.159  -4.589  1.00 22.34           C  
ATOM   2401  C   ARG A 313      -3.288  25.116  -5.123  1.00 21.35           C  
ATOM   2402  O   ARG A 313      -2.631  25.817  -4.359  1.00 20.86           O  
ATOM   2403  CB  ARG A 313      -3.875  22.700  -4.689  1.00 29.26           C  
ATOM   2404  CG  ARG A 313      -2.468  22.475  -4.097  1.00 32.52           C  
ATOM   2405  CD  ARG A 313      -1.853  21.070  -4.332  1.00 31.40           C  
ATOM   2406  NE  ARG A 313      -1.746  20.622  -5.737  0.80 34.32           N  
ATOM   2407  CZ  ARG A 313      -0.726  20.852  -6.582  0.80 35.89           C  
ATOM   2408  NH1 ARG A 313       0.364  21.555  -6.251  0.80 31.25           N  
ATOM   2409  NH2 ARG A 313      -0.807  20.358  -7.799  0.80 36.60           N  
ATOM   2410  N   ILE A 314      -3.139  25.118  -6.439  1.00 20.01           N  
ATOM   2411  CA  ILE A 314      -2.130  25.934  -7.118  1.00 19.57           C  
ATOM   2412  C   ILE A 314      -2.439  27.439  -6.957  1.00 20.85           C  
ATOM   2413  O   ILE A 314      -1.550  28.228  -6.604  1.00 20.10           O  
ATOM   2414  CB  ILE A 314      -2.025  25.522  -8.583  1.00 20.54           C  
ATOM   2415  CG1 ILE A 314      -1.368  24.123  -8.660  1.00 21.37           C  
ATOM   2416  CG2 ILE A 314      -1.190  26.536  -9.389  1.00 22.10           C  
ATOM   2417  CD1 ILE A 314      -1.543  23.406 -10.051  1.00 19.25           C  
ATOM   2418  N   LEU A 315      -3.682  27.833  -7.216  1.00 20.44           N  
ATOM   2419  CA  LEU A 315      -4.047  29.246  -6.995  1.00 20.80           C  
ATOM   2420  C   LEU A 315      -3.868  29.673  -5.549  1.00 23.24           C  
ATOM   2421  O   LEU A 315      -3.425  30.799  -5.268  1.00 22.73           O  
ATOM   2422  CB  LEU A 315      -5.470  29.530  -7.456  1.00 21.64           C  
ATOM   2423  CG  LEU A 315      -5.780  29.406  -8.951  1.00 23.18           C  
ATOM   2424  CD1 LEU A 315      -7.272  29.673  -9.125  1.00 22.89           C  
ATOM   2425  CD2 LEU A 315      -4.938  30.304  -9.876  1.00 21.70           C  
ATOM   2426  N   SER A 316      -4.195  28.781  -4.609  1.00 20.11           N  
ATOM   2427  CA  SER A 316      -3.971  29.087  -3.213  1.00 20.28           C  
ATOM   2428  C   SER A 316      -2.475  29.289  -2.980  1.00 20.15           C  
ATOM   2429  O   SER A 316      -2.061  30.187  -2.245  1.00 23.02           O  
ATOM   2430  CB  SER A 316      -4.499  27.953  -2.295  1.00 20.66           C  
ATOM   2431  OG  SER A 316      -4.104  28.216  -0.970  1.00 26.52           O  
ATOM   2432  N   GLY A 317      -1.666  28.453  -3.628  1.00 21.42           N  
ATOM   2433  CA  GLY A 317      -0.218  28.601  -3.498  1.00 17.49           C  
ATOM   2434  C   GLY A 317       0.296  29.925  -4.053  1.00 15.73           C  
ATOM   2435  O   GLY A 317       1.188  30.535  -3.462  1.00 19.27           O  
ATOM   2436  N   PHE A 318      -0.259  30.351  -5.192  1.00 18.85           N  
ATOM   2437  CA  PHE A 318       0.064  31.679  -5.748  1.00 17.75           C  
ATOM   2438  C   PHE A 318      -0.273  32.764  -4.734  1.00 21.56           C  
ATOM   2439  O   PHE A 318       0.525  33.690  -4.523  1.00 20.68           O  
ATOM   2440  CB  PHE A 318      -0.674  31.962  -7.052  1.00 18.40           C  
ATOM   2441  CG  PHE A 318      -0.255  31.093  -8.205  1.00 18.20           C  
ATOM   2442  CD1 PHE A 318       0.897  30.297  -8.145  1.00 19.02           C  
ATOM   2443  CD2 PHE A 318      -1.025  31.085  -9.356  1.00 18.34           C  
ATOM   2444  CE1 PHE A 318       1.282  29.508  -9.231  1.00 19.16           C  
ATOM   2445  CE2 PHE A 318      -0.694  30.289 -10.429  1.00 19.02           C  
ATOM   2446  CZ  PHE A 318       0.490  29.494 -10.374  1.00 19.04           C  
ATOM   2447  N   ALA A 319      -1.463  32.657  -4.130  1.00 19.60           N  
ATOM   2448  CA  ALA A 319      -1.880  33.597  -3.075  1.00 19.79           C  
ATOM   2449  C   ALA A 319      -0.922  33.604  -1.897  1.00 20.65           C  
ATOM   2450  O   ALA A 319      -0.560  34.670  -1.383  1.00 20.55           O  
ATOM   2451  CB  ALA A 319      -3.357  33.292  -2.593  1.00 21.11           C  
ATOM   2452  N   TRP A 320      -0.508  32.415  -1.452  1.00 19.17           N  
ATOM   2453  CA  TRP A 320       0.411  32.267  -0.334  1.00 18.54           C  
ATOM   2454  C   TRP A 320       1.719  32.980  -0.649  1.00 18.81           C  
ATOM   2455  O   TRP A 320       2.313  33.673   0.207  1.00 20.08           O  
ATOM   2456  CB  TRP A 320       0.636  30.757  -0.108  1.00 22.00           C  
ATOM   2457  CG  TRP A 320       1.514  30.363   1.026  1.00 23.99           C  
ATOM   2458  CD1 TRP A 320       1.107  29.991   2.278  1.00 25.16           C  
ATOM   2459  CD2 TRP A 320       2.961  30.229   1.012  1.00 22.91           C  
ATOM   2460  NE1 TRP A 320       2.204  29.649   3.051  1.00 26.40           N  
ATOM   2461  CE2 TRP A 320       3.350  29.781   2.304  1.00 24.17           C  
ATOM   2462  CE3 TRP A 320       3.954  30.442   0.042  1.00 23.03           C  
ATOM   2463  CZ2 TRP A 320       4.693  29.554   2.649  1.00 23.79           C  
ATOM   2464  CZ3 TRP A 320       5.291  30.204   0.385  1.00 22.34           C  
ATOM   2465  CH2 TRP A 320       5.648  29.777   1.678  1.00 22.01           C  
ATOM   2466  N   LEU A 321       2.140  32.862  -1.906  1.00 21.05           N  
ATOM   2467  CA  LEU A 321       3.393  33.454  -2.369  1.00 21.83           C  
ATOM   2468  C   LEU A 321       3.326  34.960  -2.451  1.00 24.23           C  
ATOM   2469  O   LEU A 321       4.362  35.618  -2.643  1.00 23.40           O  
ATOM   2470  CB  LEU A 321       3.766  32.899  -3.725  1.00 22.59           C  
ATOM   2471  CG  LEU A 321       4.468  31.556  -3.664  1.00 24.57           C  
ATOM   2472  CD1 LEU A 321       4.550  31.030  -5.102  1.00 24.15           C  
ATOM   2473  CD2 LEU A 321       5.868  31.683  -2.974  1.00 22.20           C  
ATOM   2474  N   GLY A 322       2.107  35.482  -2.311  1.00 23.08           N  
ATOM   2475  CA  GLY A 322       1.849  36.914  -2.420  1.00 21.35           C  
ATOM   2476  C   GLY A 322       1.750  37.440  -3.846  1.00 24.48           C  
ATOM   2477  O   GLY A 322       1.815  38.654  -4.040  1.00 21.84           O  
ATOM   2478  N   LEU A 323       1.601  36.550  -4.839  1.00 19.87           N  
ATOM   2479  CA  LEU A 323       1.513  36.966  -6.251  1.00 19.20           C  
ATOM   2480  C   LEU A 323       0.273  37.812  -6.562  1.00 20.12           C  
ATOM   2481  O   LEU A 323       0.239  38.517  -7.555  1.00 18.91           O  
ATOM   2482  CB  LEU A 323       1.596  35.781  -7.216  1.00 18.99           C  
ATOM   2483  CG  LEU A 323       2.737  34.751  -7.087  1.00 21.33           C  
ATOM   2484  CD1 LEU A 323       2.791  33.874  -8.320  1.00 19.73           C  
ATOM   2485  CD2 LEU A 323       4.113  35.424  -6.805  1.00 19.52           C  
ATOM   2486  N   PHE A 324      -0.754  37.716  -5.727  1.00 21.05           N  
ATOM   2487  CA  PHE A 324      -1.959  38.515  -5.950  1.00 20.24           C  
ATOM   2488  C   PHE A 324      -1.998  39.706  -5.001  1.00 24.49           C  
ATOM   2489  O   PHE A 324      -3.067  40.277  -4.794  1.00 23.89           O  
ATOM   2490  CB  PHE A 324      -3.204  37.673  -5.696  1.00 20.68           C  
ATOM   2491  CG  PHE A 324      -3.289  36.437  -6.537  1.00 20.73           C  
ATOM   2492  CD1 PHE A 324      -2.862  36.434  -7.870  1.00 21.67           C  
ATOM   2493  CD2 PHE A 324      -3.841  35.277  -6.003  1.00 21.68           C  
ATOM   2494  CE1 PHE A 324      -2.951  35.276  -8.640  1.00 23.11           C  
ATOM   2495  CE2 PHE A 324      -3.962  34.124  -6.784  1.00 22.43           C  
ATOM   2496  CZ  PHE A 324      -3.521  34.113  -8.085  1.00 21.54           C  
ATOM   2497  N   SER A 325      -0.852  40.066  -4.430  1.00 22.81           N  
ATOM   2498  CA  SER A 325      -0.801  41.018  -3.323  1.00 22.77           C  
ATOM   2499  C   SER A 325      -0.074  42.301  -3.709  1.00 25.97           C  
ATOM   2500  O   SER A 325       0.499  42.403  -4.797  1.00 24.11           O  
ATOM   2501  CB  SER A 325      -0.115  40.410  -2.087  1.00 24.22           C  
ATOM   2502  OG  SER A 325       1.312  40.440  -2.202  1.00 20.88           O  
ATOM   2503  N   ASP A 326      -0.085  43.257  -2.782  1.00 24.20           N  
ATOM   2504  CA  ASP A 326       0.656  44.501  -2.948  1.00 26.53           C  
ATOM   2505  C   ASP A 326       2.142  44.387  -2.633  1.00 26.51           C  
ATOM   2506  O   ASP A 326       2.865  45.379  -2.789  1.00 26.21           O  
ATOM   2507  CB  ASP A 326       0.041  45.625  -2.101  1.00 33.38           C  
ATOM   2508  CG  ASP A 326       0.720  46.967  -2.338  1.00 39.25           C  
ATOM   2509  OD1 ASP A 326       0.648  47.492  -3.481  1.00 39.54           O  
ATOM   2510  OD2 ASP A 326       1.337  47.503  -1.382  1.00 42.11           O  
ATOM   2511  N   ALA A 327       2.616  43.212  -2.189  1.00 19.02           N  
ATOM   2512  CA  ALA A 327       4.057  43.040  -1.944  1.00 20.15           C  
ATOM   2513  C   ALA A 327       4.863  43.418  -3.179  1.00 23.09           C  
ATOM   2514  O   ALA A 327       4.534  43.011  -4.296  1.00 22.67           O  
ATOM   2515  CB  ALA A 327       4.385  41.608  -1.529  1.00 18.15           C  
ATOM   2516  N   LYS A 328       5.945  44.167  -2.960  1.00 24.93           N  
ATOM   2517  CA  LYS A 328       6.795  44.679  -4.053  1.00 24.87           C  
ATOM   2518  C   LYS A 328       7.718  43.598  -4.537  1.00 23.40           C  
ATOM   2519  O   LYS A 328       8.303  42.868  -3.729  1.00 24.51           O  
ATOM   2520  CB  LYS A 328       7.637  45.881  -3.588  1.00 26.26           C  
ATOM   2521  CG  LYS A 328       6.823  47.013  -2.995  1.00 28.40           C  
ATOM   2522  CD  LYS A 328       5.680  47.386  -3.923  1.00 29.84           C  
ATOM   2523  CE  LYS A 328       4.845  48.513  -3.353  1.00 33.75           C  
ATOM   2524  NZ  LYS A 328       4.023  47.992  -2.216  1.00 35.53           N  
ATOM   2525  N   ILE A 329       7.856  43.497  -5.855  1.00 20.04           N  
ATOM   2526  CA  ILE A 329       8.764  42.534  -6.455  1.00 20.06           C  
ATOM   2527  C   ILE A 329      10.218  42.896  -6.157  1.00 22.06           C  
ATOM   2528  O   ILE A 329      10.548  44.072  -5.960  1.00 21.04           O  
ATOM   2529  CB  ILE A 329       8.570  42.404  -8.010  1.00 21.81           C  
ATOM   2530  CG1 ILE A 329       8.950  43.716  -8.724  1.00 21.48           C  
ATOM   2531  CG2 ILE A 329       7.125  41.995  -8.386  1.00 20.29           C  
ATOM   2532  CD1 ILE A 329       9.265  43.515 -10.186  1.00 18.84           C  
ATOM   2533  N   THR A 330      11.083  41.894  -6.090  1.00 18.02           N  
ATOM   2534  CA  THR A 330      12.517  42.152  -6.235  1.00 20.95           C  
ATOM   2535  C   THR A 330      12.715  42.464  -7.732  1.00 25.90           C  
ATOM   2536  O   THR A 330      12.451  41.613  -8.588  1.00 27.79           O  
ATOM   2537  CB  THR A 330      13.384  40.941  -5.773  1.00 21.10           C  
ATOM   2538  OG1 THR A 330      13.153  40.712  -4.380  1.00 20.92           O  
ATOM   2539  CG2 THR A 330      14.899  41.210  -5.947  1.00 21.85           C  
ATOM   2540  N   PRO A 331      13.166  43.700  -8.055  1.00 26.17           N  
ATOM   2541  CA  PRO A 331      13.238  44.108  -9.451  1.00 28.56           C  
ATOM   2542  C   PRO A 331      14.389  43.466 -10.211  1.00 30.90           C  
ATOM   2543  O   PRO A 331      15.409  44.113 -10.423  1.00 38.22           O  
ATOM   2544  CB  PRO A 331      13.439  45.620  -9.356  1.00 28.62           C  
ATOM   2545  CG  PRO A 331      14.115  45.846  -8.066  1.00 27.25           C  
ATOM   2546  CD  PRO A 331      13.606  44.771  -7.133  1.00 25.83           C  
ATOM   2547  N   ARG A 332      14.216  42.227 -10.650  1.00 26.45           N  
ATOM   2548  CA  ARG A 332      15.271  41.501 -11.374  1.00 26.12           C  
ATOM   2549  C   ARG A 332      15.291  41.661 -12.887  1.00 29.55           C  
ATOM   2550  O   ARG A 332      16.158  41.077 -13.539  1.00 31.29           O  
ATOM   2551  CB  ARG A 332      15.233  39.992 -11.064  1.00 25.63           C  
ATOM   2552  CG  ARG A 332      15.339  39.635  -9.581  1.00 28.93           C  
ATOM   2553  CD  ARG A 332      16.709  39.912  -9.010  1.00 35.26           C  
ATOM   2554  NE  ARG A 332      17.772  39.073  -9.570  1.00 40.07           N  
ATOM   2555  CZ  ARG A 332      18.986  38.960  -9.018  1.00 43.27           C  
ATOM   2556  NH1 ARG A 332      19.270  39.634  -7.899  1.00 42.07           N  
ATOM   2557  NH2 ARG A 332      19.919  38.180  -9.574  1.00 43.13           N  
ATOM   2558  N   GLY A 333      14.340  42.413 -13.448  1.00 28.73           N  
ATOM   2559  CA  GLY A 333      14.333  42.713 -14.883  1.00 27.30           C  
ATOM   2560  C   GLY A 333      13.880  41.631 -15.845  1.00 28.09           C  
ATOM   2561  O   GLY A 333      13.889  41.844 -17.045  1.00 29.76           O  
ATOM   2562  N   ASN A 334      13.501  40.461 -15.328  1.00 26.36           N  
ATOM   2563  CA  ASN A 334      12.874  39.421 -16.127  1.00 24.31           C  
ATOM   2564  C   ASN A 334      11.933  38.581 -15.229  1.00 21.39           C  
ATOM   2565  O   ASN A 334      12.073  38.627 -14.002  1.00 23.61           O  
ATOM   2566  CB  ASN A 334      13.928  38.548 -16.840  1.00 27.16           C  
ATOM   2567  CG  ASN A 334      14.788  37.737 -15.877  1.00 30.18           C  
ATOM   2568  OD1 ASN A 334      15.844  38.187 -15.423  1.00 31.84           O  
ATOM   2569  ND2 ASN A 334      14.331  36.534 -15.554  1.00 29.15           N  
ATOM   2570  N   ALA A 335      10.989  37.845 -15.835  1.00 22.03           N  
ATOM   2571  CA  ALA A 335       9.941  37.124 -15.068  1.00 22.68           C  
ATOM   2572  C   ALA A 335      10.539  36.065 -14.163  1.00 22.21           C  
ATOM   2573  O   ALA A 335      10.270  36.025 -12.956  1.00 20.41           O  
ATOM   2574  CB  ALA A 335       8.886  36.495 -15.996  1.00 23.05           C  
ATOM   2575  N   LEU A 336      11.356  35.213 -14.765  1.00 22.70           N  
ATOM   2576  CA  LEU A 336      11.995  34.100 -14.058  1.00 25.12           C  
ATOM   2577  C   LEU A 336      12.725  34.502 -12.796  1.00 27.81           C  
ATOM   2578  O   LEU A 336      12.410  33.992 -11.708  1.00 25.46           O  
ATOM   2579  CB  LEU A 336      12.951  33.311 -14.987  1.00 26.61           C  
ATOM   2580  CG  LEU A 336      13.731  32.179 -14.321  1.00 27.23           C  
ATOM   2581  CD1 LEU A 336      12.762  31.163 -13.753  1.00 24.19           C  
ATOM   2582  CD2 LEU A 336      14.642  31.492 -15.341  1.00 27.85           C  
ATOM   2583  N   ASP A 337      13.695  35.415 -12.918  1.00 23.98           N  
ATOM   2584  CA  ASP A 337      14.522  35.746 -11.774  1.00 24.27           C  
ATOM   2585  C   ASP A 337      13.716  36.465 -10.725  1.00 22.20           C  
ATOM   2586  O   ASP A 337      14.038  36.378  -9.538  1.00 22.31           O  
ATOM   2587  CB  ASP A 337      15.691  36.633 -12.174  1.00 28.78           C  
ATOM   2588  CG  ASP A 337      16.697  35.922 -13.037  1.00 32.06           C  
ATOM   2589  OD1 ASP A 337      16.739  34.674 -13.031  1.00 29.94           O  
ATOM   2590  OD2 ASP A 337      17.435  36.630 -13.742  1.00 32.85           O  
ATOM   2591  N   THR A 338      12.702  37.228 -11.162  1.00 19.02           N  
ATOM   2592  CA  THR A 338      11.829  37.893 -10.208  1.00 21.27           C  
ATOM   2593  C   THR A 338      11.032  36.842  -9.419  1.00 20.25           C  
ATOM   2594  O   THR A 338      10.915  36.925  -8.174  1.00 19.44           O  
ATOM   2595  CB  THR A 338      10.888  38.884 -10.885  1.00 20.77           C  
ATOM   2596  OG1 THR A 338      11.664  39.836 -11.636  1.00 24.67           O  
ATOM   2597  CG2 THR A 338      10.055  39.609  -9.815  1.00 20.13           C  
ATOM   2598  N   LEU A 339      10.504  35.854 -10.144  1.00 20.23           N  
ATOM   2599  CA  LEU A 339       9.842  34.737  -9.464  1.00 20.10           C  
ATOM   2600  C   LEU A 339      10.786  34.038  -8.475  1.00 21.13           C  
ATOM   2601  O   LEU A 339      10.427  33.812  -7.302  1.00 19.44           O  
ATOM   2602  CB  LEU A 339       9.297  33.730 -10.489  1.00 20.41           C  
ATOM   2603  CG  LEU A 339       8.750  32.413  -9.897  1.00 19.10           C  
ATOM   2604  CD1 LEU A 339       7.610  32.779  -8.946  1.00 21.44           C  
ATOM   2605  CD2 LEU A 339       8.236  31.525 -11.050  1.00 21.87           C  
ATOM   2606  N   CYS A 340      11.981  33.687  -8.948  1.00 21.44           N  
ATOM   2607  CA  CYS A 340      12.968  32.978  -8.119  1.00 21.78           C  
ATOM   2608  C   CYS A 340      13.303  33.743  -6.845  1.00 22.94           C  
ATOM   2609  O   CYS A 340      13.446  33.154  -5.763  1.00 20.43           O  
ATOM   2610  CB  CYS A 340      14.228  32.669  -8.935  1.00 21.29           C  
ATOM   2611  SG  CYS A 340      13.968  31.485 -10.224  1.00 26.48           S  
ATOM   2612  N   ALA A 341      13.376  35.073  -6.941  1.00 19.48           N  
ATOM   2613  CA  ALA A 341      13.666  35.882  -5.771  1.00 21.17           C  
ATOM   2614  C   ALA A 341      12.575  35.735  -4.703  1.00 18.60           C  
ATOM   2615  O   ALA A 341      12.853  35.707  -3.496  1.00 20.43           O  
ATOM   2616  CB  ALA A 341      13.798  37.360  -6.180  1.00 20.09           C  
ATOM   2617  N   ARG A 342      11.321  35.672  -5.156  1.00 18.34           N  
ATOM   2618  CA  ARG A 342      10.210  35.563  -4.221  1.00 18.60           C  
ATOM   2619  C   ARG A 342      10.190  34.156  -3.599  1.00 18.38           C  
ATOM   2620  O   ARG A 342       9.905  34.010  -2.391  1.00 19.44           O  
ATOM   2621  CB  ARG A 342       8.872  35.863  -4.920  1.00 19.24           C  
ATOM   2622  CG  ARG A 342       7.682  35.856  -3.968  1.00 20.02           C  
ATOM   2623  CD  ARG A 342       7.709  37.076  -3.050  1.00 20.04           C  
ATOM   2624  NE  ARG A 342       6.528  37.173  -2.212  1.00 21.21           N  
ATOM   2625  CZ  ARG A 342       6.358  38.107  -1.276  1.00 22.58           C  
ATOM   2626  NH1 ARG A 342       7.276  39.064  -1.106  1.00 25.27           N  
ATOM   2627  NH2 ARG A 342       5.268  38.114  -0.539  1.00 21.34           N  
ATOM   2628  N   LEU A 343      10.435  33.144  -4.429  1.00 19.27           N  
ATOM   2629  CA  LEU A 343      10.480  31.731  -3.941  1.00 19.41           C  
ATOM   2630  C   LEU A 343      11.531  31.606  -2.873  1.00 21.16           C  
ATOM   2631  O   LEU A 343      11.265  31.139  -1.754  1.00 21.56           O  
ATOM   2632  CB  LEU A 343      10.787  30.741  -5.079  1.00 16.16           C  
ATOM   2633  CG  LEU A 343       9.755  30.629  -6.221  1.00 18.14           C  
ATOM   2634  CD1 LEU A 343      10.323  29.713  -7.306  1.00 17.64           C  
ATOM   2635  CD2 LEU A 343       8.377  30.156  -5.715  1.00 16.98           C  
ATOM   2636  N   GLU A 344      12.740  32.039  -3.224  1.00 20.95           N  
ATOM   2637  CA  GLU A 344      13.861  32.079  -2.273  1.00 22.64           C  
ATOM   2638  C   GLU A 344      13.554  32.850  -0.978  1.00 24.05           C  
ATOM   2639  O   GLU A 344      13.884  32.397   0.102  1.00 26.74           O  
ATOM   2640  CB  GLU A 344      15.122  32.605  -2.945  1.00 25.26           C  
ATOM   2641  CG  GLU A 344      15.538  31.769  -4.115  1.00 29.23           C  
ATOM   2642  CD  GLU A 344      16.513  32.472  -5.029  1.00 31.48           C  
ATOM   2643  OE1 GLU A 344      17.173  33.421  -4.559  1.00 34.17           O  
ATOM   2644  OE2 GLU A 344      16.620  32.069  -6.206  1.00 33.06           O  
ATOM   2645  N   GLU A 345      12.910  34.003  -1.086  1.00 22.84           N  
ATOM   2646  CA  GLU A 345      12.615  34.784   0.098  1.00 25.19           C  
ATOM   2647  C   GLU A 345      11.671  34.040   1.069  1.00 22.93           C  
ATOM   2648  O   GLU A 345      11.822  34.115   2.295  1.00 24.56           O  
ATOM   2649  CB  GLU A 345      12.020  36.129  -0.332  1.00 22.46           C  
ATOM   2650  CG  GLU A 345      11.600  37.010   0.814  1.00 28.88           C  
ATOM   2651  CD  GLU A 345      11.025  38.340   0.349  1.00 27.02           C  
ATOM   2652  OE1 GLU A 345      10.984  38.590  -0.877  1.00 27.66           O  
ATOM   2653  OE2 GLU A 345      10.619  39.124   1.219  1.00 28.94           O  
ATOM   2654  N   LEU A 346      10.722  33.289   0.511  1.00 21.95           N  
ATOM   2655  CA  LEU A 346       9.626  32.710   1.310  1.00 21.61           C  
ATOM   2656  C   LEU A 346       9.810  31.255   1.673  1.00 24.12           C  
ATOM   2657  O   LEU A 346       9.090  30.745   2.532  1.00 25.83           O  
ATOM   2658  CB  LEU A 346       8.301  32.849   0.580  1.00 24.11           C  
ATOM   2659  CG  LEU A 346       7.395  34.066   0.864  1.00 23.96           C  
ATOM   2660  CD1 LEU A 346       8.127  35.377   1.045  1.00 24.59           C  
ATOM   2661  CD2 LEU A 346       6.362  34.203  -0.187  1.00 27.01           C  
ATOM   2662  N   MET A 347      10.744  30.586   1.016  1.00 20.78           N  
ATOM   2663  CA  MET A 347      10.827  29.121   1.155  1.00 21.53           C  
ATOM   2664  C   MET A 347      12.197  28.609   1.602  1.00 21.78           C  
ATOM   2665  O   MET A 347      12.716  27.621   1.102  1.00 21.69           O  
ATOM   2666  CB  MET A 347      10.342  28.469  -0.128  1.00 20.40           C  
ATOM   2667  CG  MET A 347       8.908  28.825  -0.443  1.00 21.87           C  
ATOM   2668  SD  MET A 347       8.443  28.488  -2.163  1.00 26.69           S  
ATOM   2669  CE  MET A 347       8.724  26.777  -2.196  1.00 23.55           C  
ATOM   2670  N   GLN A 348      12.786  29.290   2.578  1.00 22.94           N  
ATOM   2671  CA  GLN A 348      14.020  28.816   3.185  1.00 21.04           C  
ATOM   2672  C   GLN A 348      13.727  27.942   4.419  1.00 21.56           C  
ATOM   2673  O   GLN A 348      12.627  28.013   4.972  1.00 21.92           O  
ATOM   2674  CB  GLN A 348      14.847  30.022   3.613  1.00 29.88           C  
ATOM   2675  CG  GLN A 348      15.484  30.744   2.452  1.00 36.31           C  
ATOM   2676  CD  GLN A 348      16.045  32.064   2.898  1.00 40.43           C  
ATOM   2677  OE1 GLN A 348      16.555  32.184   4.024  1.00 41.10           O  
ATOM   2678  NE2 GLN A 348      15.934  33.086   2.033  1.00 42.68           N  
ATOM   2679  N   TYR A 349      14.703  27.143   4.852  1.00 24.17           N  
ATOM   2680  CA  TYR A 349      14.571  26.432   6.136  1.00 23.11           C  
ATOM   2681  C   TYR A 349      14.504  27.391   7.328  1.00 26.23           C  
ATOM   2682  O   TYR A 349      15.208  28.405   7.347  1.00 26.92           O  
ATOM   2683  CB  TYR A 349      15.724  25.449   6.315  1.00 23.50           C  
ATOM   2684  CG  TYR A 349      15.536  24.212   5.499  1.00 19.96           C  
ATOM   2685  CD1 TYR A 349      14.642  23.228   5.922  1.00 20.01           C  
ATOM   2686  CD2 TYR A 349      16.193  24.046   4.275  1.00 20.60           C  
ATOM   2687  CE1 TYR A 349      14.429  22.105   5.183  1.00 17.35           C  
ATOM   2688  CE2 TYR A 349      15.967  22.891   3.507  1.00 17.22           C  
ATOM   2689  CZ  TYR A 349      15.086  21.932   4.000  1.00 19.48           C  
ATOM   2690  OH  TYR A 349      14.815  20.791   3.271  1.00 18.74           O  
ATOM   2691  N   GLU A 350      13.661  27.076   8.306  1.00 27.73           N  
ATOM   2692  CA  GLU A 350      13.648  27.785   9.600  1.00 34.69           C  
ATOM   2693  C   GLU A 350      14.396  26.936  10.609  1.00 36.77           C  
ATOM   2694  O   GLU A 350      14.627  25.755  10.360  1.00 32.09           O  
ATOM   2695  CB  GLU A 350      12.221  28.013  10.095  1.00 41.04           C  
ATOM   2696  CG  GLU A 350      11.268  28.617   9.071  1.00 46.47           C  
ATOM   2697  CD  GLU A 350      11.570  30.069   8.773  1.00 47.53           C  
ATOM   2698  OE1 GLU A 350      10.657  30.907   8.931  1.00 49.70           O  
ATOM   2699  OE2 GLU A 350      12.716  30.374   8.378  1.00 50.96           O  
ATOM   2700  N   ASP A 351      14.759  27.510  11.754  1.00 38.94           N  
ATOM   2701  CA  ASP A 351      15.778  26.869  12.615  1.00 41.40           C  
ATOM   2702  C   ASP A 351      15.398  25.525  13.225  1.00 38.80           C  
ATOM   2703  O   ASP A 351      16.277  24.694  13.501  1.00 40.60           O  
ATOM   2704  CB  ASP A 351      16.264  27.822  13.716  1.00 45.85           C  
ATOM   2705  CG  ASP A 351      17.250  28.845  13.202  0.80 48.57           C  
ATOM   2706  OD1 ASP A 351      17.914  28.586  12.162  0.80 47.51           O  
ATOM   2707  OD2 ASP A 351      17.353  29.912  13.850  0.80 50.42           O  
ATOM   2708  N   ASN A 352      14.103  25.310  13.438  1.00 32.05           N  
ATOM   2709  CA  ASN A 352      13.638  24.044  13.998  1.00 34.35           C  
ATOM   2710  C   ASN A 352      13.167  23.059  12.920  1.00 29.61           C  
ATOM   2711  O   ASN A 352      12.497  22.073  13.222  1.00 31.78           O  
ATOM   2712  CB  ASN A 352      12.479  24.323  14.940  1.00 37.35           C  
ATOM   2713  CG  ASN A 352      11.450  25.246  14.312  0.80 39.04           C  
ATOM   2714  OD1 ASN A 352      11.668  25.798  13.224  0.80 36.40           O  
ATOM   2715  ND2 ASN A 352      10.326  25.432  15.002  0.80 40.14           N  
ATOM   2716  N   GLU A 353      13.521  23.333  11.673  1.00 25.15           N  
ATOM   2717  CA  GLU A 353      13.115  22.468  10.567  1.00 19.43           C  
ATOM   2718  C   GLU A 353      14.237  21.521  10.150  1.00 16.61           C  
ATOM   2719  O   GLU A 353      15.403  21.798  10.407  1.00 19.76           O  
ATOM   2720  CB  GLU A 353      12.632  23.317   9.408  1.00 19.79           C  
ATOM   2721  CG  GLU A 353      11.363  24.057   9.774  1.00 21.11           C  
ATOM   2722  CD  GLU A 353      10.866  24.954   8.664  1.00 24.88           C  
ATOM   2723  OE1 GLU A 353      11.623  25.221   7.709  1.00 22.07           O  
ATOM   2724  OE2 GLU A 353       9.699  25.387   8.746  1.00 27.12           O  
ATOM   2725  N   ARG A 354      13.859  20.390   9.550  1.00 16.44           N  
ATOM   2726  CA  ARG A 354      14.798  19.346   9.123  1.00 18.78           C  
ATOM   2727  C   ARG A 354      14.702  19.137   7.623  1.00 15.00           C  
ATOM   2728  O   ARG A 354      13.598  19.130   7.053  1.00 15.13           O  
ATOM   2729  CB  ARG A 354      14.418  17.987   9.743  0.50 16.17           C  
ATOM   2731  CG  ARG A 354      14.634  17.816  11.236  0.50 19.61           C  
ATOM   2733  CD  ARG A 354      14.541  16.329  11.617  0.50 17.42           C  
ATOM   2735  NE  ARG A 354      13.319  15.676  11.144  0.50 17.10           N  
ATOM   2737  CZ  ARG A 354      13.068  14.366  11.244  0.50 16.00           C  
ATOM   2739  NH1 ARG A 354      13.968  13.542  11.811  0.50 11.29           N  
ATOM   2741  NH2 ARG A 354      11.926  13.879  10.765  0.50  9.98           N  
ATOM   2743  N   ASP A 355      15.862  18.903   6.992  1.00 16.04           N  
ATOM   2744  CA  ASP A 355      15.873  18.461   5.619  1.00 14.94           C  
ATOM   2745  C   ASP A 355      15.931  16.931   5.574  1.00 14.46           C  
ATOM   2746  O   ASP A 355      15.980  16.256   6.628  1.00 13.72           O  
ATOM   2747  CB  ASP A 355      17.053  19.122   4.840  1.00 12.46           C  
ATOM   2748  CG  ASP A 355      18.385  18.409   5.061  1.00 16.59           C  
ATOM   2749  OD1 ASP A 355      18.642  17.961   6.190  1.00 17.71           O  
ATOM   2750  OD2 ASP A 355      19.182  18.351   4.101  1.00 17.76           O  
ATOM   2751  N   MET A 356      15.904  16.393   4.357  1.00 17.06           N  
ATOM   2752  CA  MET A 356      15.913  14.944   4.158  1.00 18.37           C  
ATOM   2753  C   MET A 356      16.595  14.637   2.829  1.00 18.05           C  
ATOM   2754  O   MET A 356      16.454  15.397   1.863  1.00 17.47           O  
ATOM   2755  CB  MET A 356      14.464  14.404   4.159  1.00 16.15           C  
ATOM   2756  CG  MET A 356      14.357  12.881   4.050  1.00 16.77           C  
ATOM   2757  SD  MET A 356      12.608  12.424   3.893  1.00 17.15           S  
ATOM   2758  CE  MET A 356      12.271  12.715   2.157  1.00 16.93           C  
ATOM   2759  N   VAL A 357      17.367  13.545   2.813  1.00 13.83           N  
ATOM   2760  CA  VAL A 357      17.900  12.966   1.590  1.00 16.34           C  
ATOM   2761  C   VAL A 357      17.266  11.595   1.448  1.00 13.89           C  
ATOM   2762  O   VAL A 357      17.229  10.805   2.404  1.00 16.34           O  
ATOM   2763  CB  VAL A 357      19.430  12.852   1.668  1.00 19.47           C  
ATOM   2764  CG1 VAL A 357      19.983  11.926   0.586  1.00 16.84           C  
ATOM   2765  CG2 VAL A 357      20.046  14.267   1.568  1.00 19.21           C  
ATOM   2766  N   VAL A 358      16.751  11.336   0.252  1.00 16.05           N  
ATOM   2767  CA  VAL A 358      16.238  10.004  -0.122  1.00 15.05           C  
ATOM   2768  C   VAL A 358      16.932   9.542  -1.407  1.00 15.16           C  
ATOM   2769  O   VAL A 358      16.988  10.255  -2.413  1.00 15.68           O  
ATOM   2770  CB  VAL A 358      14.666  10.004  -0.260  1.00 14.14           C  
ATOM   2771  CG1 VAL A 358      14.140  11.266  -1.044  1.00 18.00           C  
ATOM   2772  CG2 VAL A 358      14.126   8.635  -0.806  1.00 13.14           C  
ATOM   2773  N   LEU A 359      17.431   8.315  -1.390  1.00 14.63           N  
ATOM   2774  CA  LEU A 359      18.101   7.777  -2.553  1.00 14.36           C  
ATOM   2775  C   LEU A 359      17.707   6.318  -2.599  1.00 15.40           C  
ATOM   2776  O   LEU A 359      17.831   5.606  -1.600  1.00 16.95           O  
ATOM   2777  CB  LEU A 359      19.632   7.916  -2.395  1.00 17.22           C  
ATOM   2778  CG  LEU A 359      20.522   7.009  -3.274  1.00 18.60           C  
ATOM   2779  CD1 LEU A 359      20.306   7.337  -4.791  1.00 16.56           C  
ATOM   2780  CD2 LEU A 359      21.999   7.158  -2.837  1.00 17.84           C  
ATOM   2781  N   GLN A 360      17.193   5.891  -3.739  1.00 15.59           N  
ATOM   2782  CA  GLN A 360      16.913   4.465  -3.934  1.00 15.03           C  
ATOM   2783  C   GLN A 360      17.393   3.971  -5.265  1.00 16.76           C  
ATOM   2784  O   GLN A 360      17.044   4.574  -6.287  1.00 16.57           O  
ATOM   2785  CB  GLN A 360      15.419   4.171  -3.840  1.00 13.85           C  
ATOM   2786  CG  GLN A 360      15.146   2.618  -3.878  1.00 14.52           C  
ATOM   2787  CD  GLN A 360      13.651   2.243  -3.877  1.00 14.47           C  
ATOM   2788  OE1 GLN A 360      12.943   2.389  -4.885  1.00 16.44           O  
ATOM   2789  NE2 GLN A 360      13.186   1.749  -2.752  1.00 16.57           N  
ATOM   2790  N   HIS A 361      18.162   2.870  -5.266  1.00 13.18           N  
ATOM   2791  CA  HIS A 361      18.454   2.138  -6.480  1.00 13.95           C  
ATOM   2792  C   HIS A 361      17.486   0.957  -6.539  1.00 15.87           C  
ATOM   2793  O   HIS A 361      17.231   0.322  -5.525  1.00 15.58           O  
ATOM   2794  CB  HIS A 361      19.852   1.548  -6.468  1.00 13.37           C  
ATOM   2795  CG  HIS A 361      20.934   2.565  -6.540  1.00 17.06           C  
ATOM   2796  ND1 HIS A 361      22.103   2.479  -5.814  1.00 20.04           N  
ATOM   2797  CD2 HIS A 361      21.017   3.703  -7.266  1.00 16.62           C  
ATOM   2798  CE1 HIS A 361      22.876   3.514  -6.117  1.00 10.84           C  
ATOM   2799  NE2 HIS A 361      22.238   4.263  -6.996  1.00 20.72           N  
ATOM   2800  N   LYS A 362      16.949   0.690  -7.719  1.00 15.89           N  
ATOM   2801  CA  LYS A 362      16.177  -0.525  -7.907  1.00 13.99           C  
ATOM   2802  C   LYS A 362      16.704  -1.332  -9.090  1.00 17.85           C  
ATOM   2803  O   LYS A 362      16.778  -0.834 -10.235  1.00 17.38           O  
ATOM   2804  CB  LYS A 362      14.719  -0.162  -8.086  1.00 18.59           C  
ATOM   2805  CG  LYS A 362      13.770  -1.371  -8.191  1.00 20.80           C  
ATOM   2806  CD  LYS A 362      12.431  -0.938  -8.721  1.00 26.86           C  
ATOM   2807  CE  LYS A 362      11.601  -0.239  -7.708  1.00 30.15           C  
ATOM   2808  NZ  LYS A 362      10.492   0.544  -8.395  1.00 28.95           N  
ATOM   2809  N   PHE A 363      17.028  -2.598  -8.818  1.00 18.59           N  
ATOM   2810  CA  PHE A 363      17.676  -3.451  -9.818  1.00 19.11           C  
ATOM   2811  C   PHE A 363      16.777  -4.611 -10.217  1.00 20.93           C  
ATOM   2812  O   PHE A 363      16.400  -5.410  -9.349  1.00 21.03           O  
ATOM   2813  CB  PHE A 363      18.948  -4.063  -9.261  1.00 18.23           C  
ATOM   2814  CG  PHE A 363      19.868  -3.085  -8.564  1.00 19.89           C  
ATOM   2815  CD1 PHE A 363      20.951  -2.526  -9.237  1.00 21.50           C  
ATOM   2816  CD2 PHE A 363      19.690  -2.776  -7.208  1.00 21.04           C  
ATOM   2817  CE1 PHE A 363      21.847  -1.649  -8.569  1.00 16.83           C  
ATOM   2818  CE2 PHE A 363      20.570  -1.915  -6.552  1.00 17.93           C  
ATOM   2819  CZ  PHE A 363      21.642  -1.333  -7.245  1.00 19.41           C  
ATOM   2820  N   GLY A 364      16.489  -4.711 -11.518  1.00 19.95           N  
ATOM   2821  CA  GLY A 364      15.826  -5.880 -12.092  1.00 19.89           C  
ATOM   2822  C   GLY A 364      16.867  -6.837 -12.659  1.00 23.96           C  
ATOM   2823  O   GLY A 364      17.599  -6.493 -13.599  1.00 22.29           O  
ATOM   2824  N   ILE A 365      16.916  -8.039 -12.075  1.00 24.41           N  
ATOM   2825  CA  ILE A 365      17.934  -9.035 -12.343  1.00 24.67           C  
ATOM   2826  C   ILE A 365      17.328 -10.262 -13.033  1.00 29.36           C  
ATOM   2827  O   ILE A 365      16.242 -10.723 -12.663  1.00 26.90           O  
ATOM   2828  CB  ILE A 365      18.593  -9.473 -11.038  1.00 25.02           C  
ATOM   2829  CG1 ILE A 365      19.293  -8.281 -10.373  1.00 22.53           C  
ATOM   2830  CG2 ILE A 365      19.593 -10.645 -11.254  1.00 26.80           C  
ATOM   2831  CD1 ILE A 365      19.459  -8.463  -8.861  1.00 25.81           C  
ATOM   2832  N   GLU A 366      18.030 -10.763 -14.048  1.00 30.23           N  
ATOM   2833  CA  GLU A 366      17.755 -12.088 -14.592  1.00 31.76           C  
ATOM   2834  C   GLU A 366      18.951 -13.017 -14.343  1.00 31.63           C  
ATOM   2835  O   GLU A 366      20.072 -12.786 -14.822  1.00 31.53           O  
ATOM   2836  CB  GLU A 366      17.381 -12.012 -16.059  1.00 34.98           C  
ATOM   2837  CG  GLU A 366      16.854 -13.324 -16.596  1.00 38.56           C  
ATOM   2838  CD  GLU A 366      16.529 -13.228 -18.057  1.00 41.58           C  
ATOM   2839  OE1 GLU A 366      15.619 -12.463 -18.433  1.00 44.65           O  
ATOM   2840  OE2 GLU A 366      17.203 -13.915 -18.836  1.00 46.57           O  
ATOM   2841  N   TRP A 367      18.717 -14.048 -13.544  1.00 34.39           N  
ATOM   2842  CA  TRP A 367      19.783 -14.985 -13.187  1.00 35.60           C  
ATOM   2843  C   TRP A 367      20.049 -15.947 -14.348  1.00 35.45           C  
ATOM   2844  O   TRP A 367      19.234 -16.040 -15.276  1.00 32.71           O  
ATOM   2845  CB  TRP A 367      19.421 -15.763 -11.915  1.00 38.05           C  
ATOM   2846  CG  TRP A 367      19.290 -14.894 -10.708  1.00 39.40           C  
ATOM   2847  CD1 TRP A 367      18.151 -14.650  -9.992  1.00 37.73           C  
ATOM   2848  CD2 TRP A 367      20.332 -14.124 -10.080  1.00 38.90           C  
ATOM   2849  NE1 TRP A 367      18.422 -13.794  -8.947  1.00 38.42           N  
ATOM   2850  CE2 TRP A 367      19.747 -13.451  -8.980  1.00 38.13           C  
ATOM   2851  CE3 TRP A 367      21.700 -13.937 -10.345  1.00 38.68           C  
ATOM   2852  CZ2 TRP A 367      20.478 -12.610  -8.140  1.00 38.54           C  
ATOM   2853  CZ3 TRP A 367      22.428 -13.099  -9.508  1.00 38.69           C  
ATOM   2854  CH2 TRP A 367      21.813 -12.444  -8.417  1.00 38.71           C  
ATOM   2855  N   ALA A 368      21.196 -16.634 -14.294  1.00 34.22           N  
ATOM   2856  CA  ALA A 368      21.590 -17.611 -15.329  1.00 41.67           C  
ATOM   2857  C   ALA A 368      20.489 -18.627 -15.652  1.00 42.52           C  
ATOM   2858  O   ALA A 368      20.197 -18.889 -16.829  1.00 46.01           O  
ATOM   2859  CB  ALA A 368      22.856 -18.332 -14.913  1.00 39.24           C  
ATOM   2860  N   ASP A 369      19.871 -19.183 -14.610  1.00 45.88           N  
ATOM   2861  CA  ASP A 369      18.780 -20.158 -14.763  1.00 46.16           C  
ATOM   2862  C   ASP A 369      17.501 -19.553 -15.345  1.00 46.00           C  
ATOM   2863  O   ASP A 369      16.514 -20.260 -15.549  1.00 44.55           O  
ATOM   2864  CB  ASP A 369      18.466 -20.799 -13.408  1.00 50.35           C  
ATOM   2865  CG  ASP A 369      18.151 -19.761 -12.335  1.00 52.70           C  
ATOM   2866  OD1 ASP A 369      17.494 -18.752 -12.667  1.00 51.33           O  
ATOM   2867  OD2 ASP A 369      18.575 -19.941 -11.170  1.00 54.22           O  
ATOM   2868  N   GLY A 370      17.499 -18.242 -15.578  1.00 42.31           N  
ATOM   2869  CA  GLY A 370      16.321 -17.577 -16.131  1.00 40.31           C  
ATOM   2870  C   GLY A 370      15.348 -17.026 -15.095  1.00 39.86           C  
ATOM   2871  O   GLY A 370      14.357 -16.375 -15.455  1.00 38.90           O  
ATOM   2872  N   THR A 371      15.613 -17.285 -13.813  1.00 39.26           N  
ATOM   2873  CA  THR A 371      14.779 -16.700 -12.756  1.00 40.82           C  
ATOM   2874  C   THR A 371      15.081 -15.196 -12.573  1.00 40.16           C  
ATOM   2875  O   THR A 371      16.230 -14.754 -12.736  1.00 41.12           O  
ATOM   2876  CB  THR A 371      14.815 -17.501 -11.412  1.00 42.81           C  
ATOM   2877  OG1 THR A 371      13.782 -17.012 -10.547  1.00 47.73           O  
ATOM   2878  CG2 THR A 371      16.142 -17.371 -10.697  1.00 44.00           C  
ATOM   2879  N   THR A 372      14.047 -14.416 -12.278  1.00 35.99           N  
ATOM   2880  CA  THR A 372      14.217 -12.981 -12.174  1.00 32.48           C  
ATOM   2881  C   THR A 372      13.972 -12.549 -10.745  1.00 33.28           C  
ATOM   2882  O   THR A 372      13.242 -13.221  -9.993  1.00 31.23           O  
ATOM   2883  CB  THR A 372      13.270 -12.224 -13.095  1.00 34.13           C  
ATOM   2884  OG1 THR A 372      11.915 -12.587 -12.801  1.00 34.34           O  
ATOM   2885  CG2 THR A 372      13.596 -12.488 -14.584  1.00 34.62           C  
ATOM   2886  N   GLU A 373      14.578 -11.430 -10.356  1.00 25.16           N  
ATOM   2887  CA  GLU A 373      14.297 -10.859  -9.038  1.00 27.25           C  
ATOM   2888  C   GLU A 373      14.510  -9.371  -9.095  1.00 27.17           C  
ATOM   2889  O   GLU A 373      15.181  -8.897 -10.013  1.00 24.13           O  
ATOM   2890  CB  GLU A 373      15.121 -11.509  -7.940  1.00 28.78           C  
ATOM   2891  CG  GLU A 373      16.481 -10.948  -7.662  1.00 36.43           C  
ATOM   2892  CD  GLU A 373      17.099 -11.656  -6.476  1.00 38.46           C  
ATOM   2893  OE1 GLU A 373      17.414 -12.849  -6.627  1.00 38.86           O  
ATOM   2894  OE2 GLU A 373      17.229 -11.048  -5.386  1.00 43.47           O  
ATOM   2895  N   THR A 374      13.902  -8.644  -8.155  1.00 23.94           N  
ATOM   2896  CA  THR A 374      14.098  -7.200  -8.049  1.00 24.05           C  
ATOM   2897  C   THR A 374      14.696  -6.933  -6.678  1.00 25.04           C  
ATOM   2898  O   THR A 374      14.201  -7.448  -5.659  1.00 21.83           O  
ATOM   2899  CB  THR A 374      12.771  -6.437  -8.214  1.00 23.16           C  
ATOM   2900  OG1 THR A 374      12.245  -6.659  -9.527  1.00 27.75           O  
ATOM   2901  CG2 THR A 374      12.968  -4.937  -8.061  1.00 23.34           C  
ATOM   2902  N   ARG A 375      15.777  -6.159  -6.645  1.00 20.96           N  
ATOM   2903  CA  ARG A 375      16.356  -5.708  -5.399  1.00 20.65           C  
ATOM   2904  C   ARG A 375      16.248  -4.206  -5.259  1.00 21.18           C  
ATOM   2905  O   ARG A 375      16.259  -3.501  -6.252  1.00 19.47           O  
ATOM   2906  CB  ARG A 375      17.821  -6.086  -5.343  1.00 25.13           C  
ATOM   2907  CG  ARG A 375      18.035  -7.570  -5.278  1.00 28.44           C  
ATOM   2908  CD  ARG A 375      19.488  -7.861  -5.158  1.00 33.68           C  
ATOM   2909  NE  ARG A 375      19.700  -9.289  -5.024  1.00 36.75           N  
ATOM   2910  CZ  ARG A 375      20.894  -9.854  -4.905  1.00 39.21           C  
ATOM   2911  NH1 ARG A 375      21.987  -9.102  -4.895  1.00 39.42           N  
ATOM   2912  NH2 ARG A 375      20.985 -11.173  -4.785  1.00 40.31           N  
ATOM   2913  N   THR A 376      16.149  -3.730  -4.019  1.00 19.12           N  
ATOM   2914  CA  THR A 376      16.271  -2.292  -3.770  1.00 17.15           C  
ATOM   2915  C   THR A 376      17.401  -1.975  -2.799  1.00 17.27           C  
ATOM   2916  O   THR A 376      17.723  -2.763  -1.889  1.00 18.46           O  
ATOM   2917  CB  THR A 376      14.899  -1.633  -3.303  1.00 16.57           C  
ATOM   2918  OG1 THR A 376      14.458  -2.261  -2.093  1.00 18.47           O  
ATOM   2919  CG2 THR A 376      13.795  -1.774  -4.357  1.00 17.44           C  
ATOM   2920  N   SER A 377      18.001  -0.793  -2.966  1.00 16.93           N  
ATOM   2921  CA  SER A 377      18.932  -0.277  -1.983  1.00 15.68           C  
ATOM   2922  C   SER A 377      18.472   1.127  -1.666  1.00 17.74           C  
ATOM   2923  O   SER A 377      18.444   1.974  -2.560  1.00 17.29           O  
ATOM   2924  CB  SER A 377      20.376  -0.257  -2.523  1.00 15.82           C  
ATOM   2925  OG  SER A 377      20.722  -1.561  -2.976  1.00 18.04           O  
ATOM   2926  N   THR A 378      18.101   1.359  -0.403  1.00 15.64           N  
ATOM   2927  CA  THR A 378      17.374   2.597  -0.028  1.00 15.18           C  
ATOM   2928  C   THR A 378      17.984   3.345   1.148  1.00 12.99           C  
ATOM   2929  O   THR A 378      18.242   2.788   2.217  1.00 15.57           O  
ATOM   2930  CB  THR A 378      15.904   2.300   0.318  1.00 15.08           C  
ATOM   2931  OG1 THR A 378      15.392   1.413  -0.687  1.00 17.11           O  
ATOM   2932  CG2 THR A 378      15.050   3.627   0.423  1.00 16.08           C  
ATOM   2933  N   LEU A 379      18.206   4.637   0.943  1.00 14.95           N  
ATOM   2934  CA  LEU A 379      18.693   5.499   1.998  1.00 12.00           C  
ATOM   2935  C   LEU A 379      17.650   6.606   2.254  1.00 14.57           C  
ATOM   2936  O   LEU A 379      17.186   7.280   1.339  1.00 17.82           O  
ATOM   2937  CB  LEU A 379      20.028   6.152   1.633  1.00 14.96           C  
ATOM   2938  CG  LEU A 379      20.442   7.295   2.569  1.00 12.89           C  
ATOM   2939  CD1 LEU A 379      20.864   6.785   3.987  1.00 17.73           C  
ATOM   2940  CD2 LEU A 379      21.567   8.085   1.857  1.00 17.56           C  
ATOM   2941  N   VAL A 380      17.246   6.724   3.507  1.00 13.32           N  
ATOM   2942  CA  VAL A 380      16.512   7.918   3.934  1.00 14.16           C  
ATOM   2943  C   VAL A 380      17.300   8.521   5.094  1.00 15.40           C  
ATOM   2944  O   VAL A 380      17.623   7.817   6.069  1.00 17.55           O  
ATOM   2945  CB  VAL A 380      15.047   7.570   4.415  1.00 16.30           C  
ATOM   2946  CG1 VAL A 380      14.362   8.841   4.926  1.00 17.22           C  
ATOM   2947  CG2 VAL A 380      14.246   6.890   3.312  1.00 18.38           C  
ATOM   2948  N   ASP A 381      17.611   9.814   5.023  1.00 14.98           N  
ATOM   2949  CA  ASP A 381      18.445  10.400   6.059  1.00 16.72           C  
ATOM   2950  C   ASP A 381      17.891  11.791   6.346  1.00 14.14           C  
ATOM   2951  O   ASP A 381      17.457  12.457   5.419  1.00 16.12           O  
ATOM   2952  CB  ASP A 381      19.902  10.466   5.581  1.00 20.12           C  
ATOM   2953  CG  ASP A 381      20.851  10.896   6.671  1.00 22.81           C  
ATOM   2954  OD1 ASP A 381      20.967  10.149   7.669  1.00 23.55           O  
ATOM   2955  OD2 ASP A 381      21.480  11.970   6.538  1.00 22.01           O  
ATOM   2956  N   TYR A 382      17.824  12.175   7.620  1.00 15.99           N  
ATOM   2957  CA  TYR A 382      17.289  13.491   8.002  1.00 17.15           C  
ATOM   2958  C   TYR A 382      18.355  14.376   8.633  1.00 14.97           C  
ATOM   2959  O   TYR A 382      19.207  13.909   9.411  1.00 15.39           O  
ATOM   2960  CB  TYR A 382      16.173  13.335   9.024  1.00 18.20           C  
ATOM   2961  CG  TYR A 382      14.910  12.739   8.496  1.00 18.30           C  
ATOM   2962  CD1 TYR A 382      13.945  13.543   7.890  1.00 17.18           C  
ATOM   2963  CD2 TYR A 382      14.646  11.382   8.660  1.00 20.86           C  
ATOM   2964  CE1 TYR A 382      12.742  13.016   7.433  1.00 20.75           C  
ATOM   2965  CE2 TYR A 382      13.471  10.835   8.191  1.00 20.77           C  
ATOM   2966  CZ  TYR A 382      12.508  11.660   7.595  1.00 22.09           C  
ATOM   2967  OH  TYR A 382      11.325  11.100   7.175  1.00 21.72           O  
ATOM   2968  N   GLY A 383      18.252  15.684   8.387  1.00 17.75           N  
ATOM   2969  CA  GLY A 383      19.041  16.650   9.146  1.00 19.02           C  
ATOM   2970  C   GLY A 383      18.717  16.646  10.642  1.00 22.30           C  
ATOM   2971  O   GLY A 383      17.651  16.171  11.078  1.00 20.52           O  
ATOM   2972  N   LYS A 384      19.649  17.189  11.425  1.00 20.33           N  
ATOM   2973  CA  LYS A 384      19.521  17.278  12.889  1.00 23.73           C  
ATOM   2974  C   LYS A 384      19.381  18.736  13.283  1.00 27.89           C  
ATOM   2975  O   LYS A 384      20.201  19.557  12.901  1.00 29.24           O  
ATOM   2976  CB  LYS A 384      20.721  16.628  13.569  1.00 25.96           C  
ATOM   2977  CG  LYS A 384      20.713  15.137  13.379  1.00 34.03           C  
ATOM   2978  CD  LYS A 384      22.048  14.479  13.653  1.00 39.06           C  
ATOM   2979  CE  LYS A 384      21.887  12.949  13.585  1.00 40.84           C  
ATOM   2980  NZ  LYS A 384      21.381  12.495  12.245  1.00 43.43           N  
ATOM   2981  N   VAL A 385      18.320  19.063  14.023  1.00 30.12           N  
ATOM   2982  CA  VAL A 385      18.110  20.433  14.472  1.00 32.51           C  
ATOM   2983  C   VAL A 385      19.238  20.776  15.432  1.00 31.26           C  
ATOM   2984  O   VAL A 385      19.579  19.976  16.307  1.00 30.14           O  
ATOM   2985  CB  VAL A 385      16.717  20.604  15.120  1.00 36.30           C  
ATOM   2986  CG1 VAL A 385      16.582  21.969  15.826  1.00 39.05           C  
ATOM   2987  CG2 VAL A 385      15.640  20.439  14.058  1.00 37.12           C  
ATOM   2988  N   GLY A 386      19.827  21.954  15.239  1.00 31.50           N  
ATOM   2989  CA  GLY A 386      21.050  22.338  15.961  1.00 35.39           C  
ATOM   2990  C   GLY A 386      22.291  21.496  15.631  1.00 36.78           C  
ATOM   2991  O   GLY A 386      23.284  21.548  16.353  1.00 35.68           O  
ATOM   2992  N   GLY A 387      22.213  20.697  14.564  1.00 33.91           N  
ATOM   2993  CA  GLY A 387      23.353  19.925  14.046  1.00 31.61           C  
ATOM   2994  C   GLY A 387      23.446  20.103  12.543  1.00 27.67           C  
ATOM   2995  O   GLY A 387      23.060  21.151  12.004  1.00 29.69           O  
ATOM   2996  N   TYR A 388      23.929  19.073  11.849  1.00 25.97           N  
ATOM   2997  CA  TYR A 388      24.148  19.174  10.406  1.00 23.34           C  
ATOM   2998  C   TYR A 388      22.931  18.695   9.655  1.00 23.29           C  
ATOM   2999  O   TYR A 388      22.307  17.712  10.075  1.00 20.55           O  
ATOM   3000  CB  TYR A 388      25.353  18.321   9.947  1.00 22.57           C  
ATOM   3001  CG  TYR A 388      26.577  18.476  10.791  1.00 25.02           C  
ATOM   3002  CD1 TYR A 388      27.207  19.734  10.926  1.00 24.93           C  
ATOM   3003  CD2 TYR A 388      27.099  17.394  11.475  1.00 25.15           C  
ATOM   3004  CE1 TYR A 388      28.332  19.897  11.719  1.00 25.91           C  
ATOM   3005  CE2 TYR A 388      28.229  17.527  12.272  1.00 25.65           C  
ATOM   3006  CZ  TYR A 388      28.840  18.792  12.385  1.00 26.62           C  
ATOM   3007  OH  TYR A 388      29.951  18.928  13.185  1.00 28.21           O  
ATOM   3008  N   SER A 389      22.634  19.379   8.547  1.00 19.78           N  
ATOM   3009  CA  SER A 389      21.643  18.946   7.574  1.00 20.23           C  
ATOM   3010  C   SER A 389      22.071  17.608   6.970  1.00 19.67           C  
ATOM   3011  O   SER A 389      23.252  17.232   6.996  1.00 17.49           O  
ATOM   3012  CB  SER A 389      21.461  20.016   6.483  1.00 19.63           C  
ATOM   3013  OG  SER A 389      22.573  20.038   5.632  1.00 21.30           O  
ATOM   3014  N   SER A 390      21.097  16.853   6.476  1.00 20.83           N  
ATOM   3015  CA  SER A 390      21.419  15.632   5.757  1.00 19.39           C  
ATOM   3016  C   SER A 390      22.167  15.944   4.449  1.00 20.06           C  
ATOM   3017  O   SER A 390      23.077  15.189   4.047  1.00 20.71           O  
ATOM   3018  CB  SER A 390      20.128  14.841   5.493  1.00 18.22           C  
ATOM   3019  OG  SER A 390      20.442  13.714   4.683  1.00 22.15           O  
ATOM   3020  N   MET A 391      21.797  17.043   3.784  1.00 19.54           N  
ATOM   3021  CA  MET A 391      22.491  17.485   2.579  1.00 25.10           C  
ATOM   3022  C   MET A 391      23.981  17.721   2.874  1.00 25.95           C  
ATOM   3023  O   MET A 391      24.821  17.315   2.076  1.00 26.22           O  
ATOM   3024  CB  MET A 391      21.798  18.679   1.896  1.00 23.91           C  
ATOM   3025  CG  MET A 391      22.036  20.053   2.487  1.00 33.75           C  
ATOM   3026  SD  MET A 391      21.039  21.412   1.744  0.60 36.82           S  
ATOM   3027  CE  MET A 391      19.576  21.353   2.819  0.85 31.77           C  
ATOM   3028  N   ALA A 392      24.305  18.302   4.039  1.00 21.80           N  
ATOM   3029  CA  ALA A 392      25.723  18.485   4.419  1.00 21.20           C  
ATOM   3030  C   ALA A 392      26.403  17.181   4.805  1.00 21.47           C  
ATOM   3031  O   ALA A 392      27.530  16.897   4.390  1.00 23.68           O  
ATOM   3032  CB  ALA A 392      25.882  19.534   5.556  1.00 19.36           C  
ATOM   3033  N   ALA A 393      25.730  16.398   5.632  1.00 18.72           N  
ATOM   3034  CA  ALA A 393      26.336  15.207   6.197  1.00 19.98           C  
ATOM   3035  C   ALA A 393      26.581  14.157   5.131  1.00 20.45           C  
ATOM   3036  O   ALA A 393      27.621  13.502   5.157  1.00 20.75           O  
ATOM   3037  CB  ALA A 393      25.487  14.630   7.351  1.00 21.27           C  
ATOM   3038  N   THR A 394      25.643  13.985   4.200  1.00 20.75           N  
ATOM   3039  CA  THR A 394      25.795  12.882   3.213  1.00 20.85           C  
ATOM   3040  C   THR A 394      26.830  13.192   2.128  1.00 18.07           C  
ATOM   3041  O   THR A 394      27.259  12.282   1.418  1.00 19.04           O  
ATOM   3042  CB  THR A 394      24.478  12.485   2.537  1.00 21.57           C  
ATOM   3043  OG1 THR A 394      23.915  13.627   1.900  1.00 20.72           O  
ATOM   3044  CG2 THR A 394      23.509  11.917   3.551  1.00 22.00           C  
ATOM   3045  N   VAL A 395      27.204  14.461   1.974  1.00 19.40           N  
ATOM   3046  CA  VAL A 395      28.379  14.809   1.166  1.00 20.32           C  
ATOM   3047  C   VAL A 395      29.658  14.804   1.987  1.00 20.41           C  
ATOM   3048  O   VAL A 395      30.685  14.279   1.545  1.00 18.62           O  
ATOM   3049  CB  VAL A 395      28.213  16.201   0.525  1.00 23.12           C  
ATOM   3050  CG1 VAL A 395      29.454  16.542  -0.312  1.00 25.83           C  
ATOM   3051  CG2 VAL A 395      26.947  16.225  -0.314  1.00 25.49           C  
ATOM   3052  N   GLY A 396      29.594  15.391   3.186  1.00 15.85           N  
ATOM   3053  CA  GLY A 396      30.772  15.668   4.009  1.00 16.41           C  
ATOM   3054  C   GLY A 396      31.375  14.398   4.577  1.00 15.45           C  
ATOM   3055  O   GLY A 396      32.595  14.231   4.601  1.00 21.12           O  
ATOM   3056  N   TYR A 397      30.532  13.487   5.039  1.00 16.38           N  
ATOM   3057  CA  TYR A 397      31.086  12.267   5.630  1.00 14.69           C  
ATOM   3058  C   TYR A 397      31.833  11.344   4.638  1.00 17.23           C  
ATOM   3059  O   TYR A 397      32.882  10.850   4.973  1.00 16.44           O  
ATOM   3060  CB  TYR A 397      30.024  11.519   6.446  1.00 20.64           C  
ATOM   3061  CG  TYR A 397      29.601  12.291   7.683  1.00 21.53           C  
ATOM   3062  CD1 TYR A 397      30.475  13.208   8.289  1.00 20.78           C  
ATOM   3063  CD2 TYR A 397      28.337  12.099   8.247  1.00 21.75           C  
ATOM   3064  CE1 TYR A 397      30.085  13.929   9.459  1.00 24.70           C  
ATOM   3065  CE2 TYR A 397      27.944  12.782   9.407  1.00 21.61           C  
ATOM   3066  CZ  TYR A 397      28.823  13.693  10.004  1.00 21.36           C  
ATOM   3067  OH  TYR A 397      28.455  14.382  11.141  1.00 25.80           O  
ATOM   3068  N   PRO A 398      31.257  11.054   3.449  1.00 16.23           N  
ATOM   3069  CA  PRO A 398      32.056  10.301   2.462  1.00 17.79           C  
ATOM   3070  C   PRO A 398      33.373  11.035   2.111  1.00 17.80           C  
ATOM   3071  O   PRO A 398      34.422  10.397   1.934  1.00 16.99           O  
ATOM   3072  CB  PRO A 398      31.139  10.231   1.230  1.00 17.03           C  
ATOM   3073  CG  PRO A 398      29.783  10.394   1.756  1.00 18.88           C  
ATOM   3074  CD  PRO A 398      29.883  11.308   2.980  1.00 15.29           C  
ATOM   3075  N   VAL A 399      33.322  12.358   2.017  1.00 17.32           N  
ATOM   3076  CA  VAL A 399      34.531  13.117   1.702  1.00 17.70           C  
ATOM   3077  C   VAL A 399      35.563  12.941   2.823  1.00 19.76           C  
ATOM   3078  O   VAL A 399      36.744  12.653   2.571  1.00 19.22           O  
ATOM   3079  CB  VAL A 399      34.208  14.622   1.480  1.00 18.19           C  
ATOM   3080  CG1 VAL A 399      35.494  15.459   1.575  1.00 19.86           C  
ATOM   3081  CG2 VAL A 399      33.534  14.824   0.126  1.00 18.17           C  
ATOM   3082  N   ALA A 400      35.116  13.061   4.075  1.00 16.75           N  
ATOM   3083  CA  ALA A 400      36.035  12.908   5.212  1.00 19.20           C  
ATOM   3084  C   ALA A 400      36.655  11.504   5.241  1.00 16.32           C  
ATOM   3085  O   ALA A 400      37.835  11.362   5.518  1.00 19.25           O  
ATOM   3086  CB  ALA A 400      35.328  13.207   6.537  1.00 17.57           C  
ATOM   3087  N   ILE A 401      35.847  10.483   4.939  1.00 16.61           N  
ATOM   3088  CA  ILE A 401      36.303   9.085   5.000  1.00 17.21           C  
ATOM   3089  C   ILE A 401      37.331   8.871   3.902  1.00 17.08           C  
ATOM   3090  O   ILE A 401      38.396   8.334   4.170  1.00 18.17           O  
ATOM   3091  CB  ILE A 401      35.093   8.074   4.877  1.00 18.16           C  
ATOM   3092  CG1 ILE A 401      34.248   8.140   6.145  1.00 19.32           C  
ATOM   3093  CG2 ILE A 401      35.579   6.593   4.645  1.00 15.23           C  
ATOM   3094  CD1 ILE A 401      32.899   7.465   6.007  1.00 17.23           C  
ATOM   3095  N   ALA A 402      37.033   9.346   2.699  1.00 19.60           N  
ATOM   3096  CA  ALA A 402      37.952   9.219   1.576  1.00 17.14           C  
ATOM   3097  C   ALA A 402      39.256   9.936   1.844  1.00 21.69           C  
ATOM   3098  O   ALA A 402      40.326   9.455   1.475  1.00 18.27           O  
ATOM   3099  CB  ALA A 402      37.310   9.763   0.272  1.00 15.50           C  
ATOM   3100  N   THR A 403      39.174  11.106   2.476  1.00 17.38           N  
ATOM   3101  CA  THR A 403      40.398  11.857   2.820  1.00 16.97           C  
ATOM   3102  C   THR A 403      41.275  11.058   3.762  1.00 20.11           C  
ATOM   3103  O   THR A 403      42.487  10.943   3.554  1.00 19.49           O  
ATOM   3104  CB  THR A 403      40.054  13.231   3.453  1.00 18.58           C  
ATOM   3105  OG1 THR A 403      39.244  13.954   2.537  1.00 19.15           O  
ATOM   3106  CG2 THR A 403      41.332  14.054   3.758  1.00 20.81           C  
ATOM   3107  N   LYS A 404      40.672  10.477   4.791  1.00 19.69           N  
ATOM   3108  CA  LYS A 404      41.474   9.664   5.699  1.00 21.44           C  
ATOM   3109  C   LYS A 404      42.076   8.455   4.971  1.00 20.15           C  
ATOM   3110  O   LYS A 404      43.205   8.038   5.251  1.00 20.79           O  
ATOM   3111  CB  LYS A 404      40.655   9.238   6.921  1.00 21.80           C  
ATOM   3112  CG  LYS A 404      40.429  10.380   7.907  1.00 24.47           C  
ATOM   3113  CD  LYS A 404      39.476   9.974   9.036  1.00 21.23           C  
ATOM   3114  CE  LYS A 404      39.976   8.751   9.839  1.00 27.10           C  
ATOM   3115  NZ  LYS A 404      39.034   8.515  10.983  1.00 27.30           N  
ATOM   3116  N   PHE A 405      41.331   7.883   4.042  1.00 19.58           N  
ATOM   3117  CA  PHE A 405      41.859   6.748   3.286  1.00 20.40           C  
ATOM   3118  C   PHE A 405      42.961   7.130   2.278  1.00 22.51           C  
ATOM   3119  O   PHE A 405      43.841   6.314   1.967  1.00 22.33           O  
ATOM   3120  CB  PHE A 405      40.733   6.008   2.565  1.00 18.69           C  
ATOM   3121  CG  PHE A 405      39.827   5.218   3.460  1.00 19.48           C  
ATOM   3122  CD1 PHE A 405      40.230   4.804   4.733  1.00 21.67           C  
ATOM   3123  CD2 PHE A 405      38.598   4.805   2.979  1.00 21.14           C  
ATOM   3124  CE1 PHE A 405      39.402   4.040   5.524  1.00 22.39           C  
ATOM   3125  CE2 PHE A 405      37.754   4.039   3.760  1.00 22.16           C  
ATOM   3126  CZ  PHE A 405      38.157   3.651   5.042  1.00 22.45           C  
ATOM   3127  N   VAL A 406      42.910   8.351   1.744  1.00 19.46           N  
ATOM   3128  CA  VAL A 406      44.004   8.843   0.907  1.00 21.28           C  
ATOM   3129  C   VAL A 406      45.241   9.045   1.795  1.00 22.31           C  
ATOM   3130  O   VAL A 406      46.358   8.648   1.444  1.00 21.18           O  
ATOM   3131  CB  VAL A 406      43.621  10.141   0.131  1.00 19.11           C  
ATOM   3132  CG1 VAL A 406      44.843  10.765  -0.493  1.00 22.39           C  
ATOM   3133  CG2 VAL A 406      42.610   9.813  -0.967  1.00 21.37           C  
ATOM   3134  N   LEU A 407      45.029   9.607   2.974  1.00 19.07           N  
ATOM   3135  CA  LEU A 407      46.135   9.885   3.892  1.00 24.75           C  
ATOM   3136  C   LEU A 407      46.835   8.615   4.355  1.00 27.48           C  
ATOM   3137  O   LEU A 407      48.062   8.575   4.457  1.00 28.53           O  
ATOM   3138  CB  LEU A 407      45.649  10.683   5.114  1.00 24.83           C  
ATOM   3139  CG  LEU A 407      45.335  12.167   4.918  1.00 23.98           C  
ATOM   3140  CD1 LEU A 407      44.692  12.640   6.240  1.00 24.27           C  
ATOM   3141  CD2 LEU A 407      46.578  12.989   4.598  1.00 23.70           C  
ATOM   3142  N   ASP A 408      46.070   7.566   4.623  1.00 27.73           N  
ATOM   3143  CA  ASP A 408      46.678   6.373   5.200  1.00 28.38           C  
ATOM   3144  C   ASP A 408      46.963   5.297   4.148  1.00 27.50           C  
ATOM   3145  O   ASP A 408      47.407   4.202   4.476  1.00 29.95           O  
ATOM   3146  CB  ASP A 408      45.894   5.858   6.424  1.00 27.66           C  
ATOM   3147  CG  ASP A 408      44.622   5.088   6.065  1.00 26.36           C  
ATOM   3148  OD1 ASP A 408      44.348   4.816   4.877  1.00 27.50           O  
ATOM   3149  OD2 ASP A 408      43.880   4.738   7.015  1.00 29.92           O  
ATOM   3150  N   GLY A 409      46.680   5.625   2.894  1.00 27.76           N  
ATOM   3151  CA  GLY A 409      46.924   4.725   1.762  1.00 31.67           C  
ATOM   3152  C   GLY A 409      45.961   3.547   1.619  1.00 30.86           C  
ATOM   3153  O   GLY A 409      46.249   2.598   0.878  1.00 32.35           O  
ATOM   3154  N   THR A 410      44.830   3.579   2.330  1.00 28.74           N  
ATOM   3155  CA  THR A 410      43.750   2.618   2.057  1.00 25.23           C  
ATOM   3156  C   THR A 410      43.293   2.814   0.619  1.00 27.24           C  
ATOM   3157  O   THR A 410      42.983   1.855  -0.080  1.00 25.62           O  
ATOM   3158  CB  THR A 410      42.553   2.765   3.036  1.00 23.63           C  
ATOM   3159  OG1 THR A 410      43.000   2.533   4.365  1.00 22.02           O  
ATOM   3160  CG2 THR A 410      41.409   1.791   2.726  1.00 24.40           C  
ATOM   3161  N   ILE A 411      43.226   4.071   0.188  1.00 27.09           N  
ATOM   3162  CA  ILE A 411      42.957   4.370  -1.211  1.00 24.78           C  
ATOM   3163  C   ILE A 411      44.322   4.540  -1.833  1.00 27.27           C  
ATOM   3164  O   ILE A 411      45.064   5.460  -1.490  1.00 26.49           O  
ATOM   3165  CB  ILE A 411      42.068   5.611  -1.404  1.00 22.32           C  
ATOM   3166  CG1 ILE A 411      40.611   5.293  -1.026  1.00 21.51           C  
ATOM   3167  CG2 ILE A 411      42.097   6.061  -2.885  1.00 22.75           C  
ATOM   3168  CD1 ILE A 411      39.657   6.483  -0.982  1.00 21.84           C  
ATOM   3169  N   LYS A 412      44.659   3.612  -2.725  1.00 30.94           N  
ATOM   3170  CA  LYS A 412      45.997   3.546  -3.284  1.00 33.75           C  
ATOM   3171  C   LYS A 412      46.018   4.167  -4.673  1.00 29.72           C  
ATOM   3172  O   LYS A 412      45.315   3.694  -5.589  1.00 25.06           O  
ATOM   3173  CB  LYS A 412      46.497   2.091  -3.325  1.00 38.58           C  
ATOM   3174  CG  LYS A 412      47.874   1.959  -3.981  1.00 43.83           C  
ATOM   3175  CD  LYS A 412      48.718   0.835  -3.372  1.00 45.91           C  
ATOM   3176  CE  LYS A 412      50.040   0.656  -4.122  1.00 46.21           C  
ATOM   3177  NZ  LYS A 412      49.882  -0.181  -5.347  1.00 48.52           N  
ATOM   3178  N   GLY A 413      46.825   5.223  -4.807  1.00 22.73           N  
ATOM   3179  CA  GLY A 413      47.048   5.881  -6.076  1.00 21.58           C  
ATOM   3180  C   GLY A 413      48.426   5.498  -6.598  1.00 24.09           C  
ATOM   3181  O   GLY A 413      48.939   4.426  -6.243  1.00 20.98           O  
ATOM   3182  N   PRO A 414      49.055   6.371  -7.411  1.00 22.25           N  
ATOM   3183  CA  PRO A 414      48.567   7.694  -7.824  1.00 22.40           C  
ATOM   3184  C   PRO A 414      47.472   7.627  -8.876  1.00 20.99           C  
ATOM   3185  O   PRO A 414      47.195   6.550  -9.410  1.00 20.24           O  
ATOM   3186  CB  PRO A 414      49.814   8.344  -8.429  1.00 22.55           C  
ATOM   3187  CG  PRO A 414      50.612   7.128  -9.011  1.00 25.29           C  
ATOM   3188  CD  PRO A 414      50.387   6.060  -7.970  1.00 24.17           C  
ATOM   3189  N   GLY A 415      46.848   8.764  -9.172  1.00 19.76           N  
ATOM   3190  CA  GLY A 415      45.926   8.843 -10.297  1.00 18.81           C  
ATOM   3191  C   GLY A 415      44.677   9.634 -10.017  1.00 19.25           C  
ATOM   3192  O   GLY A 415      44.469  10.104  -8.890  1.00 18.05           O  
ATOM   3193  N   LEU A 416      43.839   9.750 -11.041  1.00 19.30           N  
ATOM   3194  CA  LEU A 416      42.611  10.515 -10.970  1.00 19.08           C  
ATOM   3195  C   LEU A 416      41.549   9.457 -10.734  1.00 21.32           C  
ATOM   3196  O   LEU A 416      41.094   8.800 -11.682  1.00 22.45           O  
ATOM   3197  CB  LEU A 416      42.406  11.267 -12.277  1.00 21.46           C  
ATOM   3198  CG  LEU A 416      41.199  12.179 -12.458  1.00 22.12           C  
ATOM   3199  CD1 LEU A 416      41.312  13.478 -11.620  1.00 18.01           C  
ATOM   3200  CD2 LEU A 416      41.018  12.523 -13.932  1.00 20.56           C  
ATOM   3201  N   LEU A 417      41.200   9.270  -9.465  1.00 18.01           N  
ATOM   3202  CA  LEU A 417      40.402   8.116  -9.034  1.00 18.74           C  
ATOM   3203  C   LEU A 417      38.947   8.502  -8.748  1.00 18.75           C  
ATOM   3204  O   LEU A 417      38.637   9.677  -8.589  1.00 20.80           O  
ATOM   3205  CB  LEU A 417      41.053   7.473  -7.809  1.00 18.30           C  
ATOM   3206  CG  LEU A 417      42.521   7.044  -7.927  1.00 20.71           C  
ATOM   3207  CD1 LEU A 417      42.964   6.395  -6.610  1.00 20.23           C  
ATOM   3208  CD2 LEU A 417      42.765   6.127  -9.121  1.00 22.46           C  
ATOM   3209  N   ALA A 418      38.063   7.503  -8.738  1.00 18.36           N  
ATOM   3210  CA  ALA A 418      36.624   7.702  -8.500  1.00 18.52           C  
ATOM   3211  C   ALA A 418      36.088   6.368  -7.965  1.00 20.19           C  
ATOM   3212  O   ALA A 418      36.763   5.351  -8.110  1.00 19.54           O  
ATOM   3213  CB  ALA A 418      35.918   8.137  -9.770  1.00 18.33           C  
ATOM   3214  N   PRO A 419      34.914   6.377  -7.277  1.00 20.11           N  
ATOM   3215  CA  PRO A 419      34.427   5.199  -6.571  1.00 21.65           C  
ATOM   3216  C   PRO A 419      33.725   4.165  -7.488  1.00 23.59           C  
ATOM   3217  O   PRO A 419      32.478   3.950  -7.406  1.00 21.46           O  
ATOM   3218  CB  PRO A 419      33.438   5.783  -5.560  1.00 21.18           C  
ATOM   3219  CG  PRO A 419      32.894   6.995  -6.240  1.00 22.60           C  
ATOM   3220  CD  PRO A 419      34.007   7.532  -7.103  1.00 22.43           C  
ATOM   3221  N   TYR A 420      34.526   3.516  -8.330  1.00 21.39           N  
ATOM   3222  CA  TYR A 420      33.960   2.740  -9.431  1.00 22.95           C  
ATOM   3223  C   TYR A 420      34.205   1.258  -9.298  1.00 19.76           C  
ATOM   3224  O   TYR A 420      33.839   0.524 -10.200  1.00 25.04           O  
ATOM   3225  CB  TYR A 420      34.532   3.167 -10.781  1.00 23.08           C  
ATOM   3226  CG  TYR A 420      34.196   4.548 -11.239  1.00 24.56           C  
ATOM   3227  CD1 TYR A 420      33.132   5.259 -10.678  1.00 24.63           C  
ATOM   3228  CD2 TYR A 420      34.915   5.133 -12.284  1.00 25.02           C  
ATOM   3229  CE1 TYR A 420      32.813   6.527 -11.113  1.00 23.38           C  
ATOM   3230  CE2 TYR A 420      34.609   6.403 -12.734  1.00 25.04           C  
ATOM   3231  CZ  TYR A 420      33.549   7.089 -12.131  1.00 25.41           C  
ATOM   3232  OH  TYR A 420      33.246   8.349 -12.556  1.00 27.89           O  
ATOM   3233  N   SER A 421      34.819   0.826  -8.211  1.00 23.02           N  
ATOM   3234  CA  SER A 421      35.164  -0.580  -8.030  1.00 26.05           C  
ATOM   3235  C   SER A 421      35.086  -0.980  -6.566  1.00 27.14           C  
ATOM   3236  O   SER A 421      35.321  -0.152  -5.684  1.00 28.31           O  
ATOM   3237  CB  SER A 421      36.588  -0.824  -8.544  1.00 26.84           C  
ATOM   3238  OG  SER A 421      37.495  -0.234  -7.629  1.00 34.76           O  
ATOM   3239  N   PRO A 422      34.746  -2.261  -6.284  1.00 28.07           N  
ATOM   3240  CA  PRO A 422      34.625  -2.733  -4.915  1.00 28.56           C  
ATOM   3241  C   PRO A 422      35.878  -2.468  -4.075  1.00 28.81           C  
ATOM   3242  O   PRO A 422      35.764  -2.220  -2.875  1.00 25.33           O  
ATOM   3243  CB  PRO A 422      34.414  -4.243  -5.094  1.00 28.16           C  
ATOM   3244  CG  PRO A 422      33.726  -4.345  -6.424  1.00 27.35           C  
ATOM   3245  CD  PRO A 422      34.429  -3.328  -7.258  1.00 28.33           C  
ATOM   3246  N   GLU A 423      37.062  -2.510  -4.703  1.00 30.73           N  
ATOM   3247  CA  GLU A 423      38.333  -2.335  -3.985  1.00 32.68           C  
ATOM   3248  C   GLU A 423      38.397  -0.956  -3.307  1.00 29.94           C  
ATOM   3249  O   GLU A 423      38.765  -0.849  -2.123  1.00 27.58           O  
ATOM   3250  CB  GLU A 423      39.533  -2.558  -4.932  1.00 40.61           C  
ATOM   3251  CG  GLU A 423      40.927  -2.175  -4.355  1.00 49.18           C  
ATOM   3252  CD  GLU A 423      41.498  -3.183  -3.325  1.00 53.77           C  
ATOM   3253  OE1 GLU A 423      40.916  -4.290  -3.161  1.00 56.04           O  
ATOM   3254  OE2 GLU A 423      42.549  -2.871  -2.686  1.00 55.51           O  
ATOM   3255  N   ILE A 424      38.043   0.090  -4.053  1.00 24.99           N  
ATOM   3256  CA  ILE A 424      37.935   1.450  -3.475  1.00 27.43           C  
ATOM   3257  C   ILE A 424      36.656   1.601  -2.630  1.00 25.47           C  
ATOM   3258  O   ILE A 424      36.652   2.242  -1.555  1.00 22.59           O  
ATOM   3259  CB  ILE A 424      37.912   2.537  -4.583  1.00 30.24           C  
ATOM   3260  CG1 ILE A 424      39.320   2.857  -5.042  1.00 34.65           C  
ATOM   3261  CG2 ILE A 424      37.280   3.865  -4.070  1.00 35.29           C  
ATOM   3262  CD1 ILE A 424      39.405   4.159  -5.872  1.00 32.47           C  
ATOM   3263  N   ASN A 425      35.572   1.018  -3.132  1.00 22.07           N  
ATOM   3264  CA  ASN A 425      34.230   1.237  -2.552  1.00 23.09           C  
ATOM   3265  C   ASN A 425      33.961   0.543  -1.222  1.00 23.92           C  
ATOM   3266  O   ASN A 425      33.358   1.127  -0.300  1.00 18.94           O  
ATOM   3267  CB  ASN A 425      33.131   0.887  -3.571  1.00 20.24           C  
ATOM   3268  CG  ASN A 425      33.135   1.798  -4.766  1.00 21.08           C  
ATOM   3269  OD1 ASN A 425      33.929   2.745  -4.838  1.00 22.73           O  
ATOM   3270  ND2 ASN A 425      32.252   1.540  -5.710  1.00 20.59           N  
ATOM   3271  N   ASP A 426      34.401  -0.703  -1.081  1.00 21.37           N  
ATOM   3272  CA  ASP A 426      34.048  -1.448   0.126  1.00 23.98           C  
ATOM   3273  C   ASP A 426      34.454  -0.779   1.441  1.00 25.13           C  
ATOM   3274  O   ASP A 426      33.621  -0.652   2.336  1.00 22.43           O  
ATOM   3275  CB  ASP A 426      34.577  -2.898   0.059  1.00 25.21           C  
ATOM   3276  CG  ASP A 426      33.802  -3.781  -0.920  1.00 29.78           C  
ATOM   3277  OD1 ASP A 426      32.677  -3.424  -1.330  1.00 26.47           O  
ATOM   3278  OD2 ASP A 426      34.324  -4.866  -1.276  1.00 27.43           O  
ATOM   3279  N   PRO A 427      35.733  -0.339   1.568  1.00 23.98           N  
ATOM   3280  CA  PRO A 427      36.185   0.299   2.806  1.00 23.28           C  
ATOM   3281  C   PRO A 427      35.363   1.563   3.160  1.00 20.82           C  
ATOM   3282  O   PRO A 427      35.119   1.828   4.325  1.00 20.27           O  
ATOM   3283  CB  PRO A 427      37.645   0.674   2.500  1.00 24.56           C  
ATOM   3284  CG  PRO A 427      38.059  -0.280   1.399  1.00 28.91           C  
ATOM   3285  CD  PRO A 427      36.827  -0.453   0.570  1.00 25.86           C  
ATOM   3286  N   ILE A 428      34.951   2.307   2.145  1.00 20.55           N  
ATOM   3287  CA  ILE A 428      34.188   3.558   2.334  1.00 18.61           C  
ATOM   3288  C   ILE A 428      32.790   3.224   2.831  1.00 20.36           C  
ATOM   3289  O   ILE A 428      32.331   3.792   3.828  1.00 21.45           O  
ATOM   3290  CB  ILE A 428      34.087   4.382   1.036  1.00 21.44           C  
ATOM   3291  CG1 ILE A 428      35.487   4.796   0.519  1.00 20.54           C  
ATOM   3292  CG2 ILE A 428      33.225   5.667   1.268  1.00 21.29           C  
ATOM   3293  CD1 ILE A 428      35.433   5.552  -0.794  1.00 20.28           C  
ATOM   3294  N   MET A 429      32.103   2.302   2.147  1.00 21.18           N  
ATOM   3295  CA  MET A 429      30.774   1.853   2.601  1.00 21.60           C  
ATOM   3296  C   MET A 429      30.805   1.342   4.035  1.00 21.81           C  
ATOM   3297  O   MET A 429      29.945   1.713   4.844  1.00 20.43           O  
ATOM   3298  CB  MET A 429      30.227   0.751   1.711  1.00 19.31           C  
ATOM   3299  CG  MET A 429      29.727   1.241   0.364  1.00 17.70           C  
ATOM   3300  SD  MET A 429      28.910  -0.079  -0.558  1.00 23.16           S  
ATOM   3301  CE  MET A 429      30.365  -1.068  -1.019  1.00 22.11           C  
ATOM   3302  N   LYS A 430      31.801   0.505   4.358  1.00 23.07           N  
ATOM   3303  CA  LYS A 430      31.910  -0.070   5.703  1.00 21.78           C  
ATOM   3304  C   LYS A 430      32.108   1.027   6.764  1.00 20.15           C  
ATOM   3305  O   LYS A 430      31.435   1.026   7.794  1.00 21.52           O  
ATOM   3306  CB  LYS A 430      33.035  -1.114   5.785  1.00 26.33           C  
ATOM   3307  CG  LYS A 430      33.208  -1.724   7.176  1.00 31.46           C  
ATOM   3308  CD  LYS A 430      34.255  -2.828   7.186  1.00 31.35           C  
ATOM   3309  CE  LYS A 430      34.476  -3.321   8.607  1.00 36.52           C  
ATOM   3310  NZ  LYS A 430      35.656  -4.230   8.698  1.00 41.70           N  
ATOM   3311  N   GLU A 431      32.991   1.976   6.486  1.00 19.11           N  
ATOM   3312  CA  GLU A 431      33.272   3.043   7.447  1.00 18.78           C  
ATOM   3313  C   GLU A 431      32.111   4.041   7.565  1.00 22.90           C  
ATOM   3314  O   GLU A 431      31.797   4.543   8.652  1.00 18.85           O  
ATOM   3315  CB  GLU A 431      34.607   3.723   7.068  1.00 21.70           C  
ATOM   3316  CG  GLU A 431      35.052   4.882   7.962  1.00 24.17           C  
ATOM   3317  CD  GLU A 431      35.457   4.502   9.385  1.00 28.47           C  
ATOM   3318  OE1 GLU A 431      35.426   3.308   9.768  1.00 27.88           O  
ATOM   3319  OE2 GLU A 431      35.783   5.439  10.148  1.00 26.55           O  
ATOM   3320  N   LEU A 432      31.453   4.299   6.441  1.00 23.65           N  
ATOM   3321  CA  LEU A 432      30.290   5.168   6.453  1.00 21.98           C  
ATOM   3322  C   LEU A 432      29.173   4.608   7.353  1.00 24.30           C  
ATOM   3323  O   LEU A 432      28.559   5.342   8.133  1.00 18.73           O  
ATOM   3324  CB  LEU A 432      29.851   5.425   5.015  1.00 22.66           C  
ATOM   3325  CG  LEU A 432      28.856   6.530   4.726  1.00 25.09           C  
ATOM   3326  CD1 LEU A 432      29.358   7.963   5.072  1.00 21.45           C  
ATOM   3327  CD2 LEU A 432      28.492   6.376   3.249  1.00 23.47           C  
ATOM   3328  N   LYS A 433      28.946   3.305   7.275  1.00 19.05           N  
ATOM   3329  CA  LYS A 433      27.958   2.643   8.134  1.00 20.84           C  
ATOM   3330  C   LYS A 433      28.419   2.576   9.597  1.00 21.14           C  
ATOM   3331  O   LYS A 433      27.695   2.947  10.511  1.00 22.81           O  
ATOM   3332  CB  LYS A 433      27.708   1.227   7.631  1.00 20.38           C  
ATOM   3333  CG  LYS A 433      26.428   0.594   8.255  1.00 21.87           C  
ATOM   3334  CD  LYS A 433      26.222  -0.819   7.743  1.00 24.34           C  
ATOM   3335  CE  LYS A 433      24.898  -1.347   8.260  1.00 25.21           C  
ATOM   3336  NZ  LYS A 433      24.734  -2.775   7.888  1.00 26.37           N  
ATOM   3337  N   ASP A 434      29.633   2.083   9.794  1.00 25.27           N  
ATOM   3338  CA  ASP A 434      30.167   1.889  11.123  1.00 26.95           C  
ATOM   3339  C   ASP A 434      30.337   3.192  11.917  1.00 28.50           C  
ATOM   3340  O   ASP A 434      29.908   3.260  13.074  1.00 28.27           O  
ATOM   3341  CB  ASP A 434      31.469   1.075  11.049  1.00 31.76           C  
ATOM   3342  CG  ASP A 434      31.216  -0.415  10.719  1.00 36.65           C  
ATOM   3343  OD1 ASP A 434      30.038  -0.807  10.481  1.00 35.57           O  
ATOM   3344  OD2 ASP A 434      32.200  -1.200  10.700  1.00 36.84           O  
ATOM   3345  N   LYS A 435      30.930   4.218  11.304  1.00 24.89           N  
ATOM   3346  CA  LYS A 435      31.181   5.467  12.005  1.00 22.65           C  
ATOM   3347  C   LYS A 435      29.941   6.353  12.089  1.00 25.67           C  
ATOM   3348  O   LYS A 435      29.666   6.934  13.160  1.00 23.55           O  
ATOM   3349  CB  LYS A 435      32.349   6.241  11.368  1.00 25.47           C  
ATOM   3350  CG  LYS A 435      32.827   7.485  12.150  1.00 25.66           C  
ATOM   3351  CD  LYS A 435      34.140   8.049  11.541  1.00 25.97           C  
ATOM   3352  CE  LYS A 435      34.585   9.362  12.194  1.00 29.20           C  
ATOM   3353  NZ  LYS A 435      34.816   9.196  13.660  1.00 26.26           N  
ATOM   3354  N   TYR A 436      29.201   6.484  10.985  1.00 23.14           N  
ATOM   3355  CA  TYR A 436      28.119   7.470  10.954  1.00 23.43           C  
ATOM   3356  C   TYR A 436      26.710   6.909  10.874  1.00 24.72           C  
ATOM   3357  O   TYR A 436      25.750   7.668  10.873  1.00 25.23           O  
ATOM   3358  CB  TYR A 436      28.326   8.448   9.795  1.00 24.02           C  
ATOM   3359  CG  TYR A 436      29.664   9.139   9.818  1.00 22.51           C  
ATOM   3360  CD1 TYR A 436      29.921  10.167  10.724  1.00 21.51           C  
ATOM   3361  CD2 TYR A 436      30.669   8.763   8.923  1.00 22.18           C  
ATOM   3362  CE1 TYR A 436      31.143  10.822  10.736  1.00 20.17           C  
ATOM   3363  CE2 TYR A 436      31.889   9.413   8.909  1.00 22.19           C  
ATOM   3364  CZ  TYR A 436      32.119  10.446   9.825  1.00 23.94           C  
ATOM   3365  OH  TYR A 436      33.332  11.111   9.851  1.00 24.87           O  
ATOM   3366  N   GLY A 437      26.583   5.592  10.783  1.00 23.21           N  
ATOM   3367  CA  GLY A 437      25.265   4.988  10.641  1.00 22.95           C  
ATOM   3368  C   GLY A 437      24.611   5.220   9.298  1.00 23.37           C  
ATOM   3369  O   GLY A 437      23.401   5.021   9.173  1.00 22.34           O  
ATOM   3370  N   ILE A 438      25.399   5.621   8.288  1.00 20.56           N  
ATOM   3371  CA  ILE A 438      24.874   5.906   6.940  1.00 20.46           C  
ATOM   3372  C   ILE A 438      25.114   4.730   5.972  1.00 21.11           C  
ATOM   3373  O   ILE A 438      26.252   4.342   5.690  1.00 18.79           O  
ATOM   3374  CB  ILE A 438      25.444   7.243   6.390  1.00 23.55           C  
ATOM   3375  CG1 ILE A 438      24.890   8.420   7.217  1.00 22.94           C  
ATOM   3376  CG2 ILE A 438      25.167   7.404   4.883  1.00 19.62           C  
ATOM   3377  CD1 ILE A 438      25.679   9.739   7.053  1.00 25.07           C  
ATOM   3378  N   TYR A 439      24.027   4.149   5.487  1.00 21.35           N  
ATOM   3379  CA  TYR A 439      24.110   3.001   4.592  1.00 20.83           C  
ATOM   3380  C   TYR A 439      22.766   2.889   3.878  1.00 22.17           C  
ATOM   3381  O   TYR A 439      21.780   3.498   4.286  1.00 23.15           O  
ATOM   3382  CB  TYR A 439      24.457   1.699   5.372  1.00 22.59           C  
ATOM   3383  CG  TYR A 439      23.324   1.181   6.253  1.00 24.93           C  
ATOM   3384  CD1 TYR A 439      22.551   0.062   5.867  1.00 26.02           C  
ATOM   3385  CD2 TYR A 439      22.993   1.832   7.448  1.00 25.69           C  
ATOM   3386  CE1 TYR A 439      21.480  -0.400   6.650  1.00 25.00           C  
ATOM   3387  CE2 TYR A 439      21.924   1.376   8.250  1.00 24.57           C  
ATOM   3388  CZ  TYR A 439      21.175   0.254   7.841  1.00 27.66           C  
ATOM   3389  OH  TYR A 439      20.104  -0.184   8.629  1.00 28.38           O  
ATOM   3390  N   LEU A 440      22.766   2.151   2.777  1.00 20.66           N  
ATOM   3391  CA  LEU A 440      21.567   1.884   2.016  1.00 18.14           C  
ATOM   3392  C   LEU A 440      21.047   0.525   2.441  1.00 20.96           C  
ATOM   3393  O   LEU A 440      21.795  -0.462   2.414  1.00 22.27           O  
ATOM   3394  CB  LEU A 440      21.846   1.930   0.502  1.00 16.55           C  
ATOM   3395  CG  LEU A 440      21.692   3.322  -0.151  1.00 16.43           C  
ATOM   3396  CD1 LEU A 440      22.814   4.277   0.323  1.00 14.78           C  
ATOM   3397  CD2 LEU A 440      21.706   3.259  -1.645  1.00 15.92           C  
ATOM   3398  N   LYS A 441      19.778   0.490   2.845  1.00 21.56           N  
ATOM   3399  CA  LYS A 441      19.086  -0.775   3.192  1.00 21.51           C  
ATOM   3400  C   LYS A 441      18.870  -1.614   1.938  1.00 19.11           C  
ATOM   3401  O   LYS A 441      18.317  -1.141   0.938  1.00 18.04           O  
ATOM   3402  CB  LYS A 441      17.736  -0.502   3.869  1.00 24.47           C  
ATOM   3403  CG  LYS A 441      17.820   0.079   5.262  1.00 31.14           C  
ATOM   3404  CD  LYS A 441      16.442   0.038   5.971  1.00 29.82           C  
ATOM   3405  CE  LYS A 441      16.432   0.850   7.278  1.00 33.11           C  
ATOM   3406  NZ  LYS A 441      15.029   0.930   7.868  1.00 34.80           N  
ATOM   3407  N   GLU A 442      19.350  -2.849   1.979  1.00 20.95           N  
ATOM   3408  CA  GLU A 442      19.301  -3.727   0.799  1.00 22.41           C  
ATOM   3409  C   GLU A 442      18.270  -4.809   1.008  1.00 25.51           C  
ATOM   3410  O   GLU A 442      18.343  -5.571   1.996  1.00 26.55           O  
ATOM   3411  CB  GLU A 442      20.683  -4.314   0.488  1.00 25.35           C  
ATOM   3412  CG  GLU A 442      21.703  -3.248   0.059  1.00 26.94           C  
ATOM   3413  CD  GLU A 442      23.130  -3.772  -0.044  1.00 27.39           C  
ATOM   3414  OE1 GLU A 442      23.786  -3.911   1.004  1.00 31.60           O  
ATOM   3415  OE2 GLU A 442      23.613  -3.992  -1.182  1.00 32.90           O  
ATOM   3416  N   LYS A 443      17.297  -4.851   0.106  1.00 25.88           N  
ATOM   3417  CA  LYS A 443      16.176  -5.783   0.202  1.00 27.91           C  
ATOM   3418  C   LYS A 443      15.930  -6.421  -1.146  1.00 28.12           C  
ATOM   3419  O   LYS A 443      16.165  -5.809  -2.194  1.00 23.39           O  
ATOM   3420  CB  LYS A 443      14.877  -5.061   0.613  1.00 33.96           C  
ATOM   3421  CG  LYS A 443      14.983  -4.070   1.763  1.00 39.64           C  
ATOM   3422  CD  LYS A 443      14.394  -4.589   3.057  1.00 43.57           C  
ATOM   3423  CE  LYS A 443      14.476  -3.524   4.185  1.00 42.61           C  
ATOM   3424  NZ  LYS A 443      13.403  -2.441   4.147  1.00 46.78           N  
ATOM   3425  N   THR A 444      15.449  -7.662  -1.116  1.00 28.12           N  
ATOM   3426  CA  THR A 444      14.897  -8.293  -2.295  1.00 30.84           C  
ATOM   3427  C   THR A 444      13.401  -8.099  -2.195  1.00 31.76           C  
ATOM   3428  O   THR A 444      12.811  -8.283  -1.116  1.00 33.58           O  
ATOM   3429  CB  THR A 444      15.317  -9.789  -2.356  1.00 31.05           C  
ATOM   3430  OG1 THR A 444      16.748  -9.850  -2.472  1.00 36.67           O  
ATOM   3431  CG2 THR A 444      14.699 -10.501  -3.531  1.00 33.08           C  
ATOM   3432  N   VAL A 445      12.788  -7.686  -3.300  1.00 26.43           N  
ATOM   3433  CA  VAL A 445      11.346  -7.525  -3.338  1.00 29.54           C  
ATOM   3434  C   VAL A 445      10.740  -8.943  -3.293  1.00 31.84           C  
ATOM   3435  O   VAL A 445      11.104  -9.831  -4.088  1.00 28.97           O  
ATOM   3436  CB  VAL A 445      10.881  -6.702  -4.559  1.00 31.01           C  
ATOM   3437  CG1 VAL A 445       9.367  -6.637  -4.642  1.00 32.41           C  
ATOM   3438  CG2 VAL A 445      11.443  -5.295  -4.478  1.00 32.20           C  
ATOM   3439  N   ALA A 446       9.880  -9.151  -2.295  1.00 32.08           N  
ATOM   3440  CA  ALA A 446       9.279 -10.449  -2.024  1.00 32.85           C  
ATOM   3441  C   ALA A 446       8.431 -10.911  -3.209  1.00 29.69           C  
ATOM   3442  O   ALA A 446       7.758 -10.117  -3.861  1.00 30.12           O  
ATOM   3443  CB  ALA A 446       8.441 -10.386  -0.744  1.00 31.61           C  
ATOM   3444  OXT ALA A 446       8.400 -12.102  -3.541  1.00 32.49           O  
TER    3445      ALA A 446                                                      
END
MOLECULE T0452.pdb
ATOM      1  N   MET     1      52.780  12.131   9.830  1.00 64.27           N  
ATOM      2  CA  MET     1      51.866  13.329   9.884  1.00 62.83           C  
ATOM      3  C   MET     1      51.173  13.643   8.544  1.00 60.55           C  
ATOM      4  O   MET     1      51.817  14.126   7.602  1.00 57.92           O  
ATOM      5  CB  MET     1      52.673  14.551  10.319  1.00 66.08           C  
ATOM      6  CG  MET     1      51.875  15.808  10.723  1.00 68.81           C  
ATOM      7  SD  MET     1      50.702  15.464  12.236  0.75 84.58          SE  
ATOM      8  CE  MET     1      51.122  17.040  13.324  1.00 62.48           C  
ATOM      9  N   ILE     2      49.865  13.365   8.474  1.00 58.05           N  
ATOM     10  CA  ILE     2      49.049  13.668   7.280  1.00 58.01           C  
ATOM     11  C   ILE     2      48.619  15.140   7.290  1.00 55.65           C  
ATOM     12  O   ILE     2      47.911  15.582   8.206  1.00 53.04           O  
ATOM     13  CB  ILE     2      47.760  12.805   7.198  1.00 58.03           C  
ATOM     14  CG1 ILE     2      48.102  11.309   7.195  1.00 54.77           C  
ATOM     15  CG2 ILE     2      46.954  13.201   5.952  1.00 57.20           C  
ATOM     16  CD1 ILE     2      46.907  10.395   7.282  1.00 57.93           C  
ATOM     17  N   LYS     3      49.008  15.877   6.251  1.00 55.60           N  
ATOM     18  CA  LYS     3      48.740  17.321   6.172  1.00 56.35           C  
ATOM     19  C   LYS     3      47.600  17.604   5.221  1.00 55.84           C  
ATOM     20  O   LYS     3      47.654  17.245   4.049  1.00 55.14           O  
ATOM     21  CB  LYS     3      50.035  18.069   5.816  1.00 57.38           C  
ATOM     22  CG  LYS     3      51.033  17.984   6.990  1.00 58.52           C  
ATOM     23  CD  LYS     3      52.475  17.739   6.602  1.00 60.97           C  
ATOM     24  CE  LYS     3      53.207  18.959   6.163  1.00 63.65           C  
ATOM     25  NZ  LYS     3      54.708  18.695   6.249  1.00 66.08           N  
ATOM     26  N   ILE     4      46.562  18.239   5.765  1.00 53.56           N  
ATOM     27  CA  ILE     4      45.340  18.514   5.056  1.00 53.76           C  
ATOM     28  C   ILE     4      45.113  20.003   4.818  1.00 53.93           C  
ATOM     29  O   ILE     4      45.241  20.810   5.741  1.00 53.51           O  
ATOM     30  CB  ILE     4      44.105  18.015   5.905  1.00 55.30           C  
ATOM     31  CG1 ILE     4      44.159  16.496   6.186  1.00 55.04           C  
ATOM     32  CG2 ILE     4      42.821  18.376   5.214  1.00 50.36           C  
ATOM     33  CD1 ILE     4      43.204  16.037   7.255  1.00 53.20           C  
ATOM     34  N   ALA     5      44.778  20.365   3.584  1.00 52.17           N  
ATOM     35  CA  ALA     5      44.327  21.720   3.286  1.00 51.01           C  
ATOM     36  C   ALA     5      42.835  21.602   3.012  1.00 50.72           C  
ATOM     37  O   ALA     5      42.402  20.614   2.424  1.00 50.92           O  
ATOM     38  CB  ALA     5      45.041  22.295   2.077  1.00 51.38           C  
ATOM     39  N   ILE     6      42.053  22.567   3.502  1.00 49.77           N  
ATOM     40  CA  ILE     6      40.637  22.647   3.226  1.00 47.38           C  
ATOM     41  C   ILE     6      40.416  23.919   2.411  1.00 48.11           C  
ATOM     42  O   ILE     6      40.780  24.992   2.841  1.00 47.01           O  
ATOM     43  CB  ILE     6      39.782  22.717   4.472  1.00 47.03           C  
ATOM     44  CG1 ILE     6      39.970  21.496   5.353  1.00 51.49           C  
ATOM     45  CG2 ILE     6      38.311  22.816   4.072  1.00 46.79           C  
ATOM     46  CD1 ILE     6      39.234  21.618   6.720  1.00 41.91           C  
ATOM     47  N   VAL     7      39.830  23.789   1.228  1.00 47.88           N  
ATOM     48  CA  VAL     7      39.543  24.920   0.368  1.00 47.35           C  
ATOM     49  C   VAL     7      38.056  24.961   0.193  1.00 49.39           C  
ATOM     50  O   VAL     7      37.452  24.018  -0.300  1.00 50.39           O  
ATOM     51  CB  VAL     7      40.252  24.813  -0.981  1.00 49.31           C  
ATOM     52  CG1 VAL     7      39.610  25.733  -1.959  1.00 53.41           C  
ATOM     53  CG2 VAL     7      41.722  25.158  -0.807  1.00 43.12           C  
ATOM     54  N   GLY     8      37.456  26.063   0.593  1.00 50.03           N  
ATOM     55  CA  GLY     8      36.004  26.154   0.599  1.00 50.42           C  
ATOM     56  C   GLY     8      35.642  26.000   2.054  1.00 47.71           C  
ATOM     57  O   GLY     8      35.959  24.985   2.672  1.00 47.68           O  
ATOM     58  N   PHE     9      35.050  27.038   2.614  1.00 45.40           N  
ATOM     59  CA  PHE     9      34.735  27.048   4.020  1.00 44.91           C  
ATOM     60  C   PHE     9      33.347  27.619   4.296  1.00 44.43           C  
ATOM     61  O   PHE     9      33.143  28.367   5.264  1.00 44.10           O  
ATOM     62  CB  PHE     9      35.832  27.773   4.797  1.00 44.89           C  
ATOM     63  CG  PHE     9      36.080  27.213   6.187  1.00 46.74           C  
ATOM     64  CD1 PHE     9      36.321  25.852   6.367  1.00 45.28           C  
ATOM     65  CD2 PHE     9      36.171  28.053   7.293  1.00 44.41           C  
ATOM     66  CE1 PHE     9      36.605  25.329   7.622  1.00 46.75           C  
ATOM     67  CE2 PHE     9      36.465  27.547   8.553  1.00 40.55           C  
ATOM     68  CZ  PHE     9      36.696  26.169   8.720  1.00 40.87           C  
ATOM     69  N   GLY    10      32.401  27.246   3.429  1.00 43.72           N  
ATOM     70  CA  GLY    10      30.998  27.527   3.667  1.00 44.66           C  
ATOM     71  C   GLY    10      30.510  26.334   4.482  1.00 48.29           C  
ATOM     72  O   GLY    10      31.269  25.749   5.241  1.00 49.37           O  
ATOM     73  N   THR    11      29.254  25.953   4.292  1.00 50.86           N  
ATOM     74  CA  THR    11      28.627  24.852   5.019  1.00 51.81           C  
ATOM     75  C   THR    11      29.371  23.522   5.011  1.00 49.50           C  
ATOM     76  O   THR    11      29.564  22.923   6.059  1.00 51.59           O  
ATOM     77  CB  THR    11      27.191  24.637   4.490  1.00 53.76           C  
ATOM     78  OG1 THR    11      26.379  25.748   4.915  1.00 53.97           O  
ATOM     79  CG2 THR    11      26.590  23.379   5.041  1.00 57.42           C  
ATOM     80  N   VAL    12      29.827  23.082   3.851  1.00 46.51           N  
ATOM     81  CA  VAL    12      30.500  21.800   3.752  1.00 47.29           C  
ATOM     82  C   VAL    12      31.869  21.826   4.436  1.00 50.52           C  
ATOM     83  O   VAL    12      32.173  20.965   5.268  1.00 51.91           O  
ATOM     84  CB  VAL    12      30.693  21.382   2.287  1.00 49.55           C  
ATOM     85  CG1 VAL    12      31.536  20.094   2.183  1.00 40.83           C  
ATOM     86  CG2 VAL    12      29.302  21.256   1.548  1.00 42.52           C  
ATOM     87  N   GLY    13      32.683  22.820   4.075  1.00 49.44           N  
ATOM     88  CA  GLY    13      34.035  22.947   4.600  1.00 46.72           C  
ATOM     89  C   GLY    13      34.013  23.103   6.086  1.00 44.10           C  
ATOM     90  O   GLY    13      34.875  22.570   6.754  1.00 46.40           O  
ATOM     91  N   GLN    14      33.056  23.861   6.614  1.00 45.08           N  
ATOM     92  CA  GLN    14      32.964  24.028   8.061  1.00 46.74           C  
ATOM     93  C   GLN    14      32.542  22.687   8.684  1.00 47.58           C  
ATOM     94  O   GLN    14      33.015  22.328   9.756  1.00 51.45           O  
ATOM     95  CB  GLN    14      32.006  25.147   8.437  1.00 46.08           C  
ATOM     96  CG  GLN    14      32.486  26.525   8.017  1.00 47.44           C  
ATOM     97  CD  GLN    14      31.468  27.593   8.266  1.00 46.95           C  
ATOM     98  OE1 GLN    14      30.745  27.562   9.275  1.00 51.27           O  
ATOM     99  NE2 GLN    14      31.409  28.578   7.358  1.00 42.84           N  
ATOM    100  N   GLY    15      31.663  21.962   7.995  1.00 47.70           N  
ATOM    101  CA  GLY    15      31.237  20.600   8.388  1.00 46.12           C  
ATOM    102  C   GLY    15      32.400  19.637   8.510  1.00 46.71           C  
ATOM    103  O   GLY    15      32.479  18.855   9.460  1.00 49.04           O  
ATOM    104  N   VAL    16      33.327  19.707   7.564  1.00 46.53           N  
ATOM    105  CA  VAL    16      34.524  18.879   7.594  1.00 45.65           C  
ATOM    106  C   VAL    16      35.404  19.222   8.804  1.00 48.76           C  
ATOM    107  O   VAL    16      35.902  18.321   9.483  1.00 52.31           O  
ATOM    108  CB  VAL    16      35.329  19.006   6.247  1.00 47.14           C  
ATOM    109  CG1 VAL    16      36.711  18.302   6.347  1.00 42.27           C  
ATOM    110  CG2 VAL    16      34.473  18.477   5.045  1.00 42.69           C  
ATOM    111  N   ALA    17      35.568  20.510   9.108  1.00 45.69           N  
ATOM    112  CA  ALA    17      36.354  20.909  10.251  1.00 45.90           C  
ATOM    113  C   ALA    17      35.674  20.444  11.546  1.00 46.43           C  
ATOM    114  O   ALA    17      36.327  19.942  12.456  1.00 45.17           O  
ATOM    115  CB  ALA    17      36.590  22.427  10.243  1.00 43.86           C  
ATOM    116  N   GLU    18      34.365  20.612  11.648  1.00 47.89           N  
ATOM    117  CA  GLU    18      33.655  20.172  12.850  1.00 51.23           C  
ATOM    118  C   GLU    18      33.869  18.667  13.098  1.00 52.35           C  
ATOM    119  O   GLU    18      34.136  18.234  14.223  1.00 50.83           O  
ATOM    120  CB  GLU    18      32.166  20.422  12.710  1.00 48.26           C  
ATOM    121  CG  GLU    18      31.747  21.852  12.867  1.00 56.31           C  
ATOM    122  CD  GLU    18      30.335  22.104  12.327  1.00 60.70           C  
ATOM    123  OE1 GLU    18      29.628  21.141  11.892  1.00 72.28           O  
ATOM    124  OE2 GLU    18      29.938  23.278  12.321  1.00 67.63           O  
ATOM    125  N   LEU    19      33.766  17.883  12.030  1.00 52.89           N  
ATOM    126  CA  LEU    19      33.887  16.439  12.139  1.00 54.26           C  
ATOM    127  C   LEU    19      35.334  16.029  12.471  1.00 53.09           C  
ATOM    128  O   LEU    19      35.555  15.184  13.342  1.00 53.03           O  
ATOM    129  CB  LEU    19      33.392  15.798  10.846  1.00 55.45           C  
ATOM    130  CG  LEU    19      32.420  14.642  11.012  1.00 63.13           C  
ATOM    131  CD1 LEU    19      31.289  15.037  12.018  1.00 59.21           C  
ATOM    132  CD2 LEU    19      31.879  14.292   9.621  1.00 58.38           C  
ATOM    133  N   LEU    20      36.310  16.628  11.791  1.00 51.90           N  
ATOM    134  CA  LEU    20      37.719  16.374  12.075  1.00 51.88           C  
ATOM    135  C   LEU    20      38.049  16.642  13.536  1.00 53.28           C  
ATOM    136  O   LEU    20      38.901  15.943  14.115  1.00 51.85           O  
ATOM    137  CB  LEU    20      38.645  17.239  11.219  1.00 51.14           C  
ATOM    138  CG  LEU    20      38.829  16.884   9.745  1.00 53.15           C  
ATOM    139  CD1 LEU    20      39.788  17.894   9.182  1.00 43.05           C  
ATOM    140  CD2 LEU    20      39.342  15.459   9.496  1.00 48.98           C  
ATOM    141  N   ILE    21      37.402  17.666  14.118  1.00 54.64           N  
ATOM    142  CA  ILE    21      37.587  18.017  15.536  1.00 54.55           C  
ATOM    143  C   ILE    21      36.880  16.988  16.421  1.00 56.62           C  
ATOM    144  O   ILE    21      37.502  16.361  17.271  1.00 56.43           O  
ATOM    145  CB  ILE    21      37.038  19.436  15.877  1.00 55.74           C  
ATOM    146  CG1 ILE    21      37.904  20.531  15.229  1.00 53.49           C  
ATOM    147  CG2 ILE    21      37.002  19.660  17.408  1.00 51.22           C  
ATOM    148  CD1 ILE    21      37.263  21.896  15.245  1.00 51.16           C  
ATOM    149  N   ARG    22      35.578  16.846  16.215  1.00 57.54           N  
ATOM    150  CA  ARG    22      34.734  15.925  16.976  1.00 59.75           C  
ATOM    151  C   ARG    22      35.217  14.442  16.971  1.00 58.99           C  
ATOM    152  O   ARG    22      35.242  13.781  18.020  1.00 56.93           O  
ATOM    153  CB  ARG    22      33.289  16.101  16.478  1.00 59.84           C  
ATOM    154  CG  ARG    22      32.304  14.970  16.713  1.00 65.23           C  
ATOM    155  CD  ARG    22      30.893  15.451  16.313  1.00 66.81           C  
ATOM    156  NE  ARG    22      29.973  14.389  15.896  1.00 72.65           N  
ATOM    157  CZ  ARG    22      29.467  13.450  16.697  1.00 78.63           C  
ATOM    158  NH1 ARG    22      29.832  13.374  17.981  1.00 85.78           N  
ATOM    159  NH2 ARG    22      28.620  12.546  16.206  1.00 74.42           N  
ATOM    160  N   LYS    23      35.620  13.938  15.807  1.00 59.10           N  
ATOM    161  CA  LYS    23      36.115  12.562  15.660  1.00 58.67           C  
ATOM    162  C   LYS    23      37.656  12.477  15.597  1.00 56.52           C  
ATOM    163  O   LYS    23      38.190  11.561  15.005  1.00 57.54           O  
ATOM    164  CB  LYS    23      35.542  11.946  14.373  1.00 59.36           C  
ATOM    165  CG  LYS    23      33.995  11.816  14.279  1.00 61.86           C  
ATOM    166  CD  LYS    23      33.474  10.645  15.084  1.00 67.73           C  
ATOM    167  CE  LYS    23      32.043  10.279  14.717  1.00 68.93           C  
ATOM    168  NZ  LYS    23      31.620   9.080  15.497  1.00 69.41           N  
ATOM    169  N   ARG    24      38.382  13.392  16.215  1.00 56.81           N  
ATOM    170  CA  ARG    24      39.857  13.360  16.122  1.00 58.96           C  
ATOM    171  C   ARG    24      40.510  12.061  16.670  1.00 60.92           C  
ATOM    172  O   ARG    24      41.434  11.509  16.045  1.00 57.97           O  
ATOM    173  CB  ARG    24      40.481  14.576  16.825  1.00 58.10           C  
ATOM    174  CG  ARG    24      42.014  14.698  16.650  1.00 59.47           C  
ATOM    175  CD  ARG    24      42.603  15.885  17.417  1.00 56.47           C  
ATOM    176  N   GLU    25      40.052  11.584  17.831  1.00 62.93           N  
ATOM    177  CA  GLU    25      40.651  10.379  18.429  1.00 63.11           C  
ATOM    178  C   GLU    25      40.434   9.182  17.486  1.00 62.24           C  
ATOM    179  O   GLU    25      41.389   8.502  17.107  1.00 62.51           O  
ATOM    180  CB  GLU    25      40.136  10.106  19.865  1.00 63.51           C  
ATOM    181  CG  GLU    25      41.118   9.248  20.728  1.00 65.66           C  
ATOM    182  CD  GLU    25      40.757   9.175  22.216  1.00 63.61           C  
ATOM    183  N   GLU    26      39.200   8.966  17.055  1.00 61.11           N  
ATOM    184  CA  GLU    26      38.902   7.833  16.165  1.00 61.23           C  
ATOM    185  C   GLU    26      39.605   7.940  14.799  1.00 60.58           C  
ATOM    186  O   GLU    26      40.126   6.939  14.291  1.00 63.12           O  
ATOM    187  CB  GLU    26      37.391   7.521  16.058  1.00 60.40           C  
ATOM    188  CG  GLU    26      36.428   8.692  16.135  1.00 65.99           C  
ATOM    189  CD  GLU    26      36.232   9.259  17.550  1.00 69.89           C  
ATOM    190  OE1 GLU    26      37.204   9.779  18.145  1.00 73.11           O  
ATOM    191  OE2 GLU    26      35.086   9.227  18.053  1.00 74.67           O  
ATOM    192  N   ILE    27      39.670   9.140  14.232  1.00 57.22           N  
ATOM    193  CA  ILE    27      40.368   9.316  12.960  1.00 55.95           C  
ATOM    194  C   ILE    27      41.849   8.995  13.113  1.00 57.56           C  
ATOM    195  O   ILE    27      42.430   8.329  12.268  1.00 56.95           O  
ATOM    196  CB  ILE    27      40.261  10.769  12.399  1.00 55.02           C  
ATOM    197  CG1 ILE    27      38.821  11.132  12.039  1.00 49.34           C  
ATOM    198  CG2 ILE    27      41.133  10.922  11.165  1.00 50.75           C  
ATOM    199  CD1 ILE    27      38.624  12.577  11.770  1.00 52.22           C  
ATOM    200  N   GLU    28      42.465   9.479  14.184  1.00 61.32           N  
ATOM    201  CA  GLU    28      43.903   9.271  14.373  1.00 64.28           C  
ATOM    202  C   GLU    28      44.266   7.807  14.654  1.00 64.22           C  
ATOM    203  O   GLU    28      45.319   7.331  14.211  1.00 62.93           O  
ATOM    204  CB  GLU    28      44.489  10.218  15.439  1.00 64.78           C  
ATOM    205  CG  GLU    28      44.654  11.679  14.954  1.00 68.38           C  
ATOM    206  CD  GLU    28      45.433  12.572  15.939  1.00 68.30           C  
ATOM    207  OE1 GLU    28      45.742  12.102  17.058  1.00 70.55           O  
ATOM    208  OE2 GLU    28      45.730  13.744  15.587  1.00 73.13           O  
ATOM    209  N   LYS    29      43.405   7.086  15.367  1.00 64.63           N  
ATOM    210  CA  LYS    29      43.688   5.674  15.625  1.00 66.71           C  
ATOM    211  C   LYS    29      43.320   4.792  14.440  1.00 64.27           C  
ATOM    212  O   LYS    29      43.488   3.590  14.516  1.00 66.43           O  
ATOM    213  CB  LYS    29      43.073   5.170  16.949  1.00 68.44           C  
ATOM    214  CG  LYS    29      41.549   5.216  17.117  1.00 71.38           C  
ATOM    215  CD  LYS    29      41.198   5.127  18.641  1.00 71.88           C  
ATOM    216  CE  LYS    29      39.729   5.491  18.956  1.00 76.70           C  
ATOM    217  NZ  LYS    29      39.490   5.736  20.420  1.00 78.05           N  
ATOM    218  N   ALA    30      42.842   5.401  13.350  1.00 62.35           N  
ATOM    219  CA  ALA    30      42.498   4.704  12.117  1.00 59.58           C  
ATOM    220  C   ALA    30      43.511   4.999  10.990  1.00 59.19           C  
ATOM    221  O   ALA    30      43.926   4.084  10.282  1.00 58.82           O  
ATOM    222  CB  ALA    30      41.104   5.089  11.679  1.00 58.95           C  
ATOM    223  N   ILE    31      43.905   6.264  10.824  1.00 58.50           N  
ATOM    224  CA  ILE    31      44.836   6.662   9.747  1.00 58.25           C  
ATOM    225  C   ILE    31      46.124   7.324  10.230  1.00 56.93           C  
ATOM    226  O   ILE    31      46.986   7.654   9.415  1.00 56.58           O  
ATOM    227  CB  ILE    31      44.148   7.616   8.698  1.00 60.03           C  
ATOM    228  CG1 ILE    31      43.729   8.952   9.327  1.00 63.44           C  
ATOM    229  CG2 ILE    31      42.920   6.948   8.083  1.00 59.44           C  
ATOM    230  CD1 ILE    31      43.310  10.005   8.313  1.00 57.81           C  
ATOM    231  N   GLY    32      46.265   7.504  11.544  1.00 56.22           N  
ATOM    232  CA  GLY    32      47.450   8.154  12.123  1.00 56.26           C  
ATOM    233  C   GLY    32      47.259   9.639  12.384  1.00 56.15           C  
ATOM    234  O   GLY    32      46.173  10.193  12.194  1.00 54.12           O  
ATOM    235  N   GLU    33      48.332  10.296  12.799  1.00 57.20           N  
ATOM    236  CA  GLU    33      48.274  11.730  13.117  1.00 57.41           C  
ATOM    237  C   GLU    33      47.980  12.615  11.898  1.00 56.42           C  
ATOM    238  O   GLU    33      48.489  12.381  10.791  1.00 55.32           O  
ATOM    239  CB  GLU    33      49.571  12.202  13.797  1.00 54.88           C  
ATOM    240  N   PHE    34      47.153  13.635  12.122  1.00 56.05           N  
ATOM    241  CA  PHE    34      46.853  14.621  11.082  1.00 55.66           C  
ATOM    242  C   PHE    34      46.741  16.029  11.657  1.00 54.59           C  
ATOM    243  O   PHE    34      46.352  16.223  12.810  1.00 52.19           O  
ATOM    244  CB  PHE    34      45.539  14.293  10.356  1.00 53.22           C  
ATOM    245  CG  PHE    34      44.307  14.535  11.191  1.00 51.30           C  
ATOM    246  CD1 PHE    34      43.696  15.778  11.207  1.00 52.89           C  
ATOM    247  CD2 PHE    34      43.764  13.525  11.972  1.00 52.61           C  
ATOM    248  CE1 PHE    34      42.561  16.004  11.992  1.00 56.64           C  
ATOM    249  CE2 PHE    34      42.622  13.754  12.749  1.00 52.83           C  
ATOM    250  CZ  PHE    34      42.030  14.997  12.759  1.00 49.58           C  
ATOM    251  N   LYS    35      47.048  16.999  10.806  1.00 55.52           N  
ATOM    252  CA  LYS    35      46.903  18.402  11.119  1.00 55.01           C  
ATOM    253  C   LYS    35      46.397  19.124   9.852  1.00 53.92           C  
ATOM    254  O   LYS    35      46.825  18.822   8.738  1.00 52.95           O  
ATOM    255  CB  LYS    35      48.248  18.998  11.581  1.00 55.35           C  
ATOM    256  N   VAL    36      45.463  20.052  10.021  1.00 53.85           N  
ATOM    257  CA  VAL    36      45.023  20.896   8.912  1.00 51.19           C  
ATOM    258  C   VAL    36      46.012  22.068   8.889  1.00 50.76           C  
ATOM    259  O   VAL    36      46.081  22.869   9.825  1.00 51.72           O  
ATOM    260  CB  VAL    36      43.595  21.377   9.116  1.00 51.26           C  
ATOM    261  CG1 VAL    36      43.214  22.449   8.086  1.00 50.58           C  
ATOM    262  CG2 VAL    36      42.643  20.177   9.107  1.00 51.69           C  
ATOM    263  N   THR    37      46.798  22.142   7.825  1.00 49.63           N  
ATOM    264  CA  THR    37      47.828  23.154   7.685  1.00 48.79           C  
ATOM    265  C   THR    37      47.379  24.424   6.954  1.00 49.33           C  
ATOM    266  O   THR    37      48.097  25.425   6.971  1.00 48.55           O  
ATOM    267  CB  THR    37      49.039  22.547   6.963  1.00 51.11           C  
ATOM    268  OG1 THR    37      48.633  22.053   5.675  1.00 49.84           O  
ATOM    269  CG2 THR    37      49.661  21.384   7.816  1.00 47.18           C  
ATOM    270  N   ALA    38      46.211  24.385   6.303  1.00 48.85           N  
ATOM    271  CA  ALA    38      45.661  25.561   5.615  1.00 48.33           C  
ATOM    272  C   ALA    38      44.151  25.472   5.443  1.00 47.20           C  
ATOM    273  O   ALA    38      43.596  24.393   5.295  1.00 47.14           O  
ATOM    274  CB  ALA    38      46.319  25.748   4.256  1.00 48.10           C  
ATOM    275  N   VAL    39      43.474  26.614   5.516  1.00 46.50           N  
ATOM    276  CA  VAL    39      42.029  26.679   5.235  1.00 41.88           C  
ATOM    277  C   VAL    39      41.837  27.944   4.433  1.00 42.19           C  
ATOM    278  O   VAL    39      42.487  28.952   4.705  1.00 42.21           O  
ATOM    279  CB  VAL    39      41.134  26.697   6.499  1.00 41.10           C  
ATOM    280  CG1 VAL    39      39.640  26.750   6.099  1.00 34.79           C  
ATOM    281  CG2 VAL    39      41.379  25.436   7.334  1.00 37.90           C  
ATOM    282  N   ALA    40      40.965  27.891   3.438  1.00 42.83           N  
ATOM    283  CA  ALA    40      40.698  29.054   2.605  1.00 43.95           C  
ATOM    284  C   ALA    40      39.229  29.118   2.235  1.00 44.80           C  
ATOM    285  O   ALA    40      38.595  28.097   2.022  1.00 45.76           O  
ATOM    286  CB  ALA    40      41.583  29.062   1.350  1.00 41.09           C  
ATOM    287  N   ASP    41      38.678  30.332   2.260  1.00 47.12           N  
ATOM    288  CA  ASP    41      37.309  30.548   1.849  1.00 48.13           C  
ATOM    289  C   ASP    41      37.362  31.268   0.495  1.00 48.80           C  
ATOM    290  O   ASP    41      38.365  31.177  -0.211  1.00 46.41           O  
ATOM    291  CB  ASP    41      36.437  31.219   2.935  1.00 47.62           C  
ATOM    292  CG  ASP    41      36.796  32.655   3.226  1.00 49.98           C  
ATOM    293  OD1 ASP    41      37.592  33.291   2.504  1.00 58.19           O  
ATOM    294  OD2 ASP    41      36.230  33.163   4.208  1.00 51.58           O  
ATOM    295  N   SER    42      36.302  31.967   0.120  1.00 49.95           N  
ATOM    296  CA  SER    42      36.264  32.567  -1.204  1.00 52.64           C  
ATOM    297  C   SER    42      37.116  33.819  -1.333  1.00 52.63           C  
ATOM    298  O   SER    42      37.251  34.311  -2.423  1.00 55.48           O  
ATOM    299  CB  SER    42      34.820  32.904  -1.582  1.00 52.96           C  
ATOM    300  OG  SER    42      34.336  34.013  -0.823  1.00 58.23           O  
ATOM    301  N   LYS    43      37.665  34.347  -0.241  1.00 51.92           N  
ATOM    302  CA  LYS    43      38.480  35.552  -0.305  1.00 52.93           C  
ATOM    303  C   LYS    43      39.599  35.700   0.718  1.00 47.85           C  
ATOM    304  O   LYS    43      40.298  36.685   0.689  1.00 45.16           O  
ATOM    305  CB  LYS    43      37.585  36.781  -0.203  1.00 55.82           C  
ATOM    306  CG  LYS    43      36.657  36.790   0.999  1.00 60.82           C  
ATOM    307  CD  LYS    43      35.892  38.100   1.051  1.00 61.10           C  
ATOM    308  CE  LYS    43      34.742  38.052   2.059  1.00 71.03           C  
ATOM    309  NZ  LYS    43      34.194  39.422   2.317  1.00 69.35           N  
ATOM    310  N   SER    44      39.796  34.718   1.583  1.00 47.19           N  
ATOM    311  CA  SER    44      40.817  34.796   2.632  1.00 44.50           C  
ATOM    312  C   SER    44      41.304  33.408   3.011  1.00 43.16           C  
ATOM    313  O   SER    44      40.816  32.381   2.497  1.00 43.03           O  
ATOM    314  CB  SER    44      40.216  35.482   3.859  1.00 43.90           C  
ATOM    315  OG  SER    44      39.006  34.830   4.247  1.00 40.74           O  
ATOM    316  N   SER    45      42.257  33.361   3.929  1.00 43.34           N  
ATOM    317  CA  SER    45      42.822  32.086   4.339  1.00 44.16           C  
ATOM    318  C   SER    45      43.499  32.135   5.691  1.00 43.92           C  
ATOM    319  O   SER    45      43.653  33.190   6.280  1.00 45.20           O  
ATOM    320  CB  SER    45      43.819  31.603   3.276  1.00 43.89           C  
ATOM    321  OG  SER    45      44.824  32.582   3.070  1.00 44.61           O  
ATOM    322  N   ILE    46      43.822  30.958   6.207  1.00 44.82           N  
ATOM    323  CA  ILE    46      44.567  30.829   7.448  1.00 45.74           C  
ATOM    324  C   ILE    46      45.498  29.626   7.232  1.00 48.74           C  
ATOM    325  O   ILE    46      45.074  28.574   6.760  1.00 48.63           O  
ATOM    326  CB  ILE    46      43.651  30.702   8.698  1.00 45.65           C  
ATOM    327  CG1 ILE    46      44.485  30.784   9.991  1.00 46.96           C  
ATOM    328  CG2 ILE    46      42.820  29.444   8.634  1.00 39.08           C  
ATOM    329  CD1 ILE    46      43.657  30.960  11.292  1.00 44.17           C  
ATOM    330  N   SER    47      46.772  29.825   7.533  1.00 51.76           N  
ATOM    331  CA  SER    47      47.810  28.828   7.336  1.00 55.63           C  
ATOM    332  C   SER    47      48.871  28.999   8.418  1.00 59.36           C  
ATOM    333  O   SER    47      48.792  29.920   9.232  1.00 59.41           O  
ATOM    334  CB  SER    47      48.405  28.970   5.934  1.00 55.81           C  
ATOM    335  OG  SER    47      48.695  30.327   5.660  1.00 60.76           O  
ATOM    336  N   GLY    48      49.858  28.113   8.438  1.00 62.08           N  
ATOM    337  CA  GLY    48      50.859  28.117   9.496  1.00 64.35           C  
ATOM    338  C   GLY    48      50.278  27.283  10.621  1.00 66.48           C  
ATOM    339  O   GLY    48      49.457  26.385  10.379  1.00 68.53           O  
ATOM    340  N   ASP    49      50.707  27.547  11.849  1.00 69.50           N  
ATOM    341  CA  ASP    49      50.151  26.823  12.986  1.00 69.13           C  
ATOM    342  C   ASP    49      48.987  27.680  13.482  1.00 66.46           C  
ATOM    343  O   ASP    49      49.128  28.880  13.721  1.00 64.46           O  
ATOM    344  CB  ASP    49      51.192  26.564  14.094  1.00 71.09           C  
ATOM    345  CG  ASP    49      50.708  25.533  15.149  1.00 73.05           C  
ATOM    346  OD1 ASP    49      49.573  25.006  15.036  1.00 77.90           O  
ATOM    347  OD2 ASP    49      51.474  25.243  16.099  1.00 84.77           O  
ATOM    348  N   PHE    50      47.829  27.042  13.569  1.00 63.84           N  
ATOM    349  CA  PHE    50      46.599  27.667  14.005  1.00 61.11           C  
ATOM    350  C   PHE    50      45.774  26.477  14.406  1.00 61.21           C  
ATOM    351  O   PHE    50      46.136  25.360  14.054  1.00 65.03           O  
ATOM    352  CB  PHE    50      45.944  28.441  12.845  1.00 60.61           C  
ATOM    353  CG  PHE    50      45.450  27.562  11.718  1.00 56.00           C  
ATOM    354  CD1 PHE    50      46.296  27.183  10.687  1.00 57.36           C  
ATOM    355  CD2 PHE    50      44.134  27.104  11.698  1.00 60.04           C  
ATOM    356  CE1 PHE    50      45.838  26.367   9.652  1.00 54.45           C  
ATOM    357  CE2 PHE    50      43.683  26.282  10.679  1.00 53.05           C  
ATOM    358  CZ  PHE    50      44.542  25.922   9.658  1.00 54.95           C  
ATOM    359  N   SER    51      44.685  26.657  15.137  1.00 61.52           N  
ATOM    360  CA  SER    51      43.842  25.505  15.454  1.00 61.50           C  
ATOM    361  C   SER    51      42.601  25.509  14.543  1.00 62.12           C  
ATOM    362  O   SER    51      42.165  26.569  14.080  1.00 62.67           O  
ATOM    363  CB  SER    51      43.459  25.482  16.943  1.00 61.95           C  
ATOM    364  OG  SER    51      42.527  26.486  17.308  1.00 60.44           O  
ATOM    365  N   LEU    52      42.052  24.331  14.263  1.00 60.09           N  
ATOM    366  CA  LEU    52      40.833  24.252  13.472  1.00 60.05           C  
ATOM    367  C   LEU    52      39.696  24.966  14.153  1.00 59.93           C  
ATOM    368  O   LEU    52      38.865  25.578  13.482  1.00 60.87           O  
ATOM    369  CB  LEU    52      40.377  22.809  13.213  1.00 61.30           C  
ATOM    370  CG  LEU    52      40.904  22.097  11.981  1.00 58.66           C  
ATOM    371  CD1 LEU    52      40.284  20.695  11.921  1.00 53.94           C  
ATOM    372  CD2 LEU    52      40.584  22.906  10.726  1.00 52.52           C  
ATOM    373  N   VAL    53      39.638  24.874  15.475  1.00 58.86           N  
ATOM    374  CA  VAL    53      38.578  25.528  16.212  1.00 59.32           C  
ATOM    375  C   VAL    53      38.797  27.061  16.134  1.00 59.34           C  
ATOM    376  O   VAL    53      37.839  27.826  16.222  1.00 58.98           O  
ATOM    377  CB  VAL    53      38.498  25.009  17.680  1.00 60.99           C  
ATOM    378  CG1 VAL    53      39.747  25.416  18.481  1.00 59.44           C  
ATOM    379  CG2 VAL    53      37.251  25.532  18.356  1.00 63.08           C  
ATOM    380  N   GLU    54      40.053  27.491  15.970  1.00 58.08           N  
ATOM    381  CA  GLU    54      40.382  28.916  15.783  1.00 58.11           C  
ATOM    382  C   GLU    54      39.791  29.372  14.453  1.00 54.78           C  
ATOM    383  O   GLU    54      39.060  30.351  14.393  1.00 51.96           O  
ATOM    384  CB  GLU    54      41.911  29.142  15.808  1.00 57.95           C  
ATOM    385  CG  GLU    54      42.433  30.512  15.286  1.00 60.54           C  
ATOM    386  CD  GLU    54      43.974  30.637  15.312  1.00 63.57           C  
ATOM    387  OE1 GLU    54      44.645  29.639  15.675  1.00 69.48           O  
ATOM    388  OE2 GLU    54      44.511  31.734  14.978  1.00 64.98           O  
ATOM    389  N   ALA    55      40.106  28.628  13.397  1.00 52.28           N  
ATOM    390  CA  ALA    55      39.628  28.928  12.057  1.00 50.48           C  
ATOM    391  C   ALA    55      38.105  29.014  12.006  1.00 50.08           C  
ATOM    392  O   ALA    55      37.523  29.899  11.369  1.00 48.20           O  
ATOM    393  CB  ALA    55      40.128  27.854  11.084  1.00 47.73           C  
ATOM    394  N   LEU    56      37.479  28.089  12.715  1.00 50.68           N  
ATOM    395  CA  LEU    56      36.040  27.925  12.734  1.00 48.42           C  
ATOM    396  C   LEU    56      35.405  29.084  13.485  1.00 48.89           C  
ATOM    397  O   LEU    56      34.422  29.675  13.027  1.00 49.34           O  
ATOM    398  CB  LEU    56      35.749  26.567  13.386  1.00 49.56           C  
ATOM    399  CG  LEU    56      34.499  25.721  13.144  1.00 52.04           C  
ATOM    400  CD1 LEU    56      34.203  25.561  11.685  1.00 38.31           C  
ATOM    401  CD2 LEU    56      34.698  24.344  13.791  1.00 47.26           C  
ATOM    402  N   ARG    57      35.973  29.419  14.637  1.00 46.37           N  
ATOM    403  CA  ARG    57      35.474  30.521  15.430  1.00 48.89           C  
ATOM    404  C   ARG    57      35.549  31.828  14.619  1.00 46.79           C  
ATOM    405  O   ARG    57      34.608  32.605  14.544  1.00 46.32           O  
ATOM    406  CB  ARG    57      36.298  30.654  16.742  1.00 51.31           C  
ATOM    407  CG  ARG    57      36.110  29.490  17.783  1.00 56.80           C  
ATOM    408  CD  ARG    57      37.030  29.595  19.028  1.00 49.52           C  
ATOM    409  N   MET    58      36.694  32.040  14.000  1.00 45.43           N  
ATOM    410  CA  MET    58      36.952  33.231  13.205  1.00 47.00           C  
ATOM    411  C   MET    58      35.968  33.370  12.026  1.00 44.58           C  
ATOM    412  O   MET    58      35.461  34.448  11.784  1.00 44.79           O  
ATOM    413  CB  MET    58      38.398  33.160  12.703  1.00 46.90           C  
ATOM    414  CG  MET    58      38.910  34.397  12.064  1.00 47.83           C  
ATOM    415  SD  MET    58      40.713  34.060  11.481  0.75 49.26          SE  
ATOM    416  CE  MET    58      41.667  34.170  13.280  1.00 37.49           C  
ATOM    417  N   LYS    59      35.692  32.285  11.313  1.00 45.02           N  
ATOM    418  CA  LYS    59      34.772  32.318  10.170  1.00 44.70           C  
ATOM    419  C   LYS    59      33.356  32.681  10.611  1.00 48.20           C  
ATOM    420  O   LYS    59      32.692  33.542  10.016  1.00 49.01           O  
ATOM    421  CB  LYS    59      34.811  30.975   9.455  1.00 43.78           C  
ATOM    422  CG  LYS    59      33.941  30.862   8.201  1.00 46.14           C  
ATOM    423  CD  LYS    59      34.236  31.951   7.144  1.00 42.99           C  
ATOM    424  CE  LYS    59      33.424  31.659   5.852  1.00 41.18           C  
ATOM    425  NZ  LYS    59      33.477  32.781   4.910  1.00 42.03           N  
ATOM    426  N   ARG    60      32.914  32.073  11.702  1.00 51.20           N  
ATOM    427  CA  ARG    60      31.569  32.311  12.219  1.00 53.26           C  
ATOM    428  C   ARG    60      31.456  33.712  12.766  1.00 50.92           C  
ATOM    429  O   ARG    60      30.478  34.414  12.503  1.00 49.06           O  
ATOM    430  CB  ARG    60      31.236  31.290  13.306  1.00 54.29           C  
ATOM    431  CG  ARG    60      31.258  29.845  12.781  1.00 60.02           C  
ATOM    432  CD  ARG    60      31.161  28.754  13.885  1.00 61.47           C  
ATOM    433  NE  ARG    60      31.138  27.446  13.233  1.00 72.90           N  
ATOM    434  CZ  ARG    60      30.086  26.940  12.579  1.00 79.62           C  
ATOM    435  NH1 ARG    60      28.925  27.591  12.512  1.00 89.86           N  
ATOM    436  NH2 ARG    60      30.186  25.765  11.989  1.00 71.49           N  
ATOM    437  N   GLU    61      32.479  34.114  13.518  1.00 52.25           N  
ATOM    438  CA  GLU    61      32.532  35.431  14.158  1.00 50.35           C  
ATOM    439  C   GLU    61      32.672  36.615  13.194  1.00 47.88           C  
ATOM    440  O   GLU    61      32.191  37.705  13.494  1.00 49.25           O  
ATOM    441  CB  GLU    61      33.737  35.503  15.129  1.00 51.84           C  
ATOM    442  CG  GLU    61      33.666  34.671  16.443  1.00 59.20           C  
ATOM    443  CD  GLU    61      35.045  34.509  17.193  1.00 59.29           C  
ATOM    444  OE1 GLU    61      36.086  35.085  16.766  1.00 61.69           O  
ATOM    445  OE2 GLU    61      35.076  33.780  18.225  1.00 72.24           O  
ATOM    446  N   THR    62      33.389  36.428  12.085  1.00 42.88           N  
ATOM    447  CA  THR    62      33.716  37.549  11.186  1.00 43.33           C  
ATOM    448  C   THR    62      33.312  37.384   9.719  1.00 40.36           C  
ATOM    449  O   THR    62      33.360  38.340   8.954  1.00 42.65           O  
ATOM    450  CB  THR    62      35.255  37.824  11.195  1.00 40.65           C  
ATOM    451  OG1 THR    62      35.926  36.769  10.495  1.00 35.15           O  
ATOM    452  CG2 THR    62      35.833  37.990  12.648  1.00 34.73           C  
ATOM    453  N   GLY    63      32.923  36.184   9.336  1.00 40.64           N  
ATOM    454  CA  GLY    63      32.560  35.872   7.952  1.00 41.41           C  
ATOM    455  C   GLY    63      33.742  35.592   7.044  1.00 43.27           C  
ATOM    456  O   GLY    63      33.561  35.358   5.845  1.00 45.21           O  
ATOM    457  N   MET    64      34.953  35.619   7.603  1.00 44.51           N  
ATOM    458  CA  MET    64      36.175  35.382   6.839  1.00 45.50           C  
ATOM    459  C   MET    64      37.294  34.864   7.728  1.00 44.26           C  
ATOM    460  O   MET    64      37.122  34.693   8.941  1.00 41.59           O  
ATOM    461  CB  MET    64      36.605  36.663   6.121  1.00 45.04           C  
ATOM    462  CG  MET    64      36.613  37.860   6.986  1.00 47.01           C  
ATOM    463  SD  MET    64      37.029  39.482   6.004  0.75 47.90          SE  
ATOM    464  CE  MET    64      38.901  38.862   5.439  1.00 59.66           C  
ATOM    465  N   LEU    65      38.448  34.626   7.115  1.00 44.77           N  
ATOM    466  CA  LEU    65      39.608  34.125   7.841  1.00 43.33           C  
ATOM    467  C   LEU    65      40.633  35.227   8.089  1.00 42.87           C  
ATOM    468  O   LEU    65      40.295  36.395   8.095  1.00 44.04           O  
ATOM    469  CB  LEU    65      40.167  32.869   7.154  1.00 42.69           C  
ATOM    470  CG  LEU    65      39.144  31.724   7.110  1.00 44.17           C  
ATOM    471  CD1 LEU    65      39.490  30.693   6.027  1.00 35.33           C  
ATOM    472  CD2 LEU    65      38.968  31.084   8.505  1.00 39.69           C  
ATOM    473  N   ARG    66      41.884  34.845   8.293  1.00 43.65           N  
ATOM    474  CA  ARG    66      42.884  35.734   8.801  1.00 44.40           C  
ATOM    475  C   ARG    66      43.758  36.465   7.784  1.00 45.38           C  
ATOM    476  O   ARG    66      44.102  37.626   7.979  1.00 44.47           O  
ATOM    477  CB  ARG    66      43.789  34.898   9.713  1.00 43.61           C  
ATOM    478  CG  ARG    66      44.744  35.697  10.608  1.00 48.49           C  
ATOM    479  CD  ARG    66      45.695  34.730  11.281  1.00 47.22           C  
ATOM    480  NE  ARG    66      46.594  34.150  10.295  1.00 45.47           N  
ATOM    481  CZ  ARG    66      47.396  33.103  10.502  1.00 50.34           C  
ATOM    482  NH1 ARG    66      47.450  32.484  11.683  1.00 48.62           N  
ATOM    483  NH2 ARG    66      48.155  32.672   9.502  1.00 48.61           N  
ATOM    484  N   ASP    67      44.128  35.766   6.730  1.00 46.81           N  
ATOM    485  CA  ASP    67      45.040  36.281   5.741  1.00 47.75           C  
ATOM    486  C   ASP    67      44.333  36.578   4.453  1.00 49.32           C  
ATOM    487  O   ASP    67      43.305  36.007   4.133  1.00 47.49           O  
ATOM    488  CB  ASP    67      46.117  35.235   5.482  1.00 48.48           C  
ATOM    489  CG  ASP    67      46.804  34.797   6.752  1.00 47.99           C  
ATOM    490  OD1 ASP    67      46.953  35.636   7.668  1.00 44.98           O  
ATOM    491  OD2 ASP    67      47.179  33.620   6.840  1.00 48.00           O  
ATOM    492  N   ASP    68      44.976  37.423   3.679  1.00 51.15           N  
ATOM    493  CA  ASP    68      44.436  37.930   2.447  1.00 52.86           C  
ATOM    494  C   ASP    68      44.663  36.946   1.300  1.00 51.66           C  
ATOM    495  O   ASP    68      43.905  36.955   0.329  1.00 52.78           O  
ATOM    496  CB  ASP    68      45.090  39.285   2.168  1.00 55.83           C  
ATOM    497  CG  ASP    68      44.094  40.319   1.731  1.00 63.82           C  
ATOM    498  OD1 ASP    68      43.435  40.113   0.679  1.00 74.55           O  
ATOM    499  OD2 ASP    68      43.973  41.326   2.465  1.00 63.73           O  
ATOM    500  N   ALA    69      45.687  36.101   1.432  1.00 48.53           N  
ATOM    501  CA  ALA    69      45.999  35.066   0.444  1.00 48.57           C  
ATOM    502  C   ALA    69      44.772  34.204   0.079  1.00 48.52           C  
ATOM    503  O   ALA    69      44.108  33.618   0.943  1.00 48.23           O  
ATOM    504  CB  ALA    69      47.113  34.187   0.943  1.00 48.89           C  
ATOM    505  N   LYS    70      44.518  34.119  -1.226  1.00 47.87           N  
ATOM    506  CA  LYS    70      43.378  33.426  -1.768  1.00 47.57           C  
ATOM    507  C   LYS    70      43.628  31.917  -1.869  1.00 48.60           C  
ATOM    508  O   LYS    70      44.767  31.449  -1.745  1.00 49.21           O  
ATOM    509  CB  LYS    70      43.005  34.016  -3.129  1.00 44.83           C  
ATOM    510  CG  LYS    70      42.774  35.545  -3.104  1.00 49.98           C  
ATOM    511  CD  LYS    70      41.537  35.965  -2.297  1.00 48.83           C  
ATOM    512  CE  LYS    70      41.353  37.514  -2.246  1.00 44.39           C  
ATOM    513  NZ  LYS    70      42.399  38.226  -1.427  1.00 45.46           N  
ATOM    514  N   ALA    71      42.526  31.188  -2.046  1.00 46.47           N  
ATOM    515  CA  ALA    71      42.513  29.729  -2.160  1.00 48.77           C  
ATOM    516  C   ALA    71      43.544  29.228  -3.176  1.00 48.96           C  
ATOM    517  O   ALA    71      44.238  28.233  -2.930  1.00 48.08           O  
ATOM    518  CB  ALA    71      41.104  29.246  -2.554  1.00 45.13           C  
ATOM    519  N   ILE    72      43.668  29.938  -4.298  1.00 49.21           N  
ATOM    520  CA  ILE    72      44.594  29.502  -5.340  1.00 49.29           C  
ATOM    521  C   ILE    72      46.038  29.493  -4.796  1.00 49.91           C  
ATOM    522  O   ILE    72      46.765  28.530  -5.020  1.00 49.57           O  
ATOM    523  CB  ILE    72      44.416  30.310  -6.659  1.00 50.44           C  
ATOM    524  CG1 ILE    72      45.048  29.560  -7.851  1.00 54.22           C  
ATOM    525  CG2 ILE    72      44.959  31.731  -6.521  1.00 43.02           C  
ATOM    526  CD1 ILE    72      44.386  28.211  -8.196  1.00 52.07           C  
ATOM    527  N   GLU    73      46.424  30.516  -4.025  1.00 48.92           N  
ATOM    528  CA  GLU    73      47.773  30.575  -3.422  1.00 48.38           C  
ATOM    529  C   GLU    73      47.994  29.436  -2.412  1.00 49.08           C  
ATOM    530  O   GLU    73      49.084  28.844  -2.353  1.00 51.64           O  
ATOM    531  CB  GLU    73      48.056  31.960  -2.789  1.00 44.72           C  
ATOM    532  N   VAL    74      46.982  29.133  -1.606  1.00 48.95           N  
ATOM    533  CA  VAL    74      47.082  28.009  -0.667  1.00 48.44           C  
ATOM    534  C   VAL    74      47.245  26.694  -1.431  1.00 49.47           C  
ATOM    535  O   VAL    74      48.026  25.811  -1.033  1.00 46.63           O  
ATOM    536  CB  VAL    74      45.847  27.929   0.247  1.00 48.50           C  
ATOM    537  CG1 VAL    74      45.675  26.519   0.870  1.00 42.05           C  
ATOM    538  CG2 VAL    74      45.918  29.060   1.306  1.00 50.41           C  
ATOM    539  N   VAL    75      46.495  26.553  -2.523  1.00 50.49           N  
ATOM    540  CA  VAL    75      46.587  25.340  -3.336  1.00 50.30           C  
ATOM    541  C   VAL    75      47.957  25.175  -3.988  1.00 51.72           C  
ATOM    542  O   VAL    75      48.516  24.091  -3.968  1.00 49.57           O  
ATOM    543  CB  VAL    75      45.533  25.289  -4.436  1.00 50.92           C  
ATOM    544  CG1 VAL    75      45.860  24.141  -5.398  1.00 48.68           C  
ATOM    545  CG2 VAL    75      44.119  25.153  -3.812  1.00 47.79           C  
ATOM    546  N   ARG    76      48.495  26.253  -4.550  1.00 54.91           N  
ATOM    547  CA  ARG    76      49.776  26.162  -5.238  1.00 57.13           C  
ATOM    548  C   ARG    76      50.999  26.330  -4.351  1.00 55.63           C  
ATOM    549  O   ARG    76      52.078  25.993  -4.788  1.00 56.56           O  
ATOM    550  CB  ARG    76      49.841  27.044  -6.514  1.00 57.62           C  
ATOM    551  CG  ARG    76      49.219  28.414  -6.426  1.00 62.82           C  
ATOM    552  CD  ARG    76      49.329  29.243  -7.718  1.00 61.44           C  
ATOM    553  NE  ARG    76      48.558  28.687  -8.827  1.00 68.70           N  
ATOM    554  CZ  ARG    76      48.114  29.388  -9.876  1.00 72.60           C  
ATOM    555  NH1 ARG    76      48.301  30.707  -9.949  1.00 71.64           N  
ATOM    556  NH2 ARG    76      47.428  28.771 -10.839  1.00 74.37           N  
ATOM    557  N   SER    77      50.841  26.766  -3.102  1.00 56.55           N  
ATOM    558  CA  SER    77      52.011  26.999  -2.230  1.00 56.57           C  
ATOM    559  C   SER    77      51.990  26.386  -0.839  1.00 56.05           C  
ATOM    560  O   SER    77      53.052  26.152  -0.275  1.00 58.37           O  
ATOM    561  CB  SER    77      52.242  28.499  -2.049  1.00 55.87           C  
ATOM    562  OG  SER    77      52.404  29.148  -3.298  1.00 60.87           O  
ATOM    563  N   ALA    78      50.816  26.152  -0.264  1.00 53.72           N  
ATOM    564  CA  ALA    78      50.739  25.637   1.102  1.00 51.81           C  
ATOM    565  C   ALA    78      51.302  24.229   1.200  1.00 52.20           C  
ATOM    566  O   ALA    78      51.362  23.489   0.203  1.00 49.94           O  
ATOM    567  CB  ALA    78      49.297  25.683   1.616  1.00 50.36           C  
ATOM    568  N   ASP    79      51.708  23.862   2.413  1.00 54.01           N  
ATOM    569  CA  ASP    79      52.279  22.537   2.670  1.00 55.96           C  
ATOM    570  C   ASP    79      51.217  21.544   3.152  1.00 55.20           C  
ATOM    571  O   ASP    79      50.816  21.537   4.330  1.00 57.13           O  
ATOM    572  CB  ASP    79      53.413  22.632   3.691  1.00 57.64           C  
ATOM    573  CG  ASP    79      54.084  21.292   3.941  1.00 63.21           C  
ATOM    574  OD1 ASP    79      53.813  20.320   3.183  1.00 72.09           O  
ATOM    575  OD2 ASP    79      54.875  21.211   4.904  1.00 70.17           O  
ATOM    576  N   TYR    80      50.770  20.704   2.226  1.00 52.70           N  
ATOM    577  CA  TYR    80      49.740  19.707   2.511  1.00 50.65           C  
ATOM    578  C   TYR    80      49.966  18.467   1.647  1.00 50.59           C  
ATOM    579  O   TYR    80      50.675  18.507   0.631  1.00 48.13           O  
ATOM    580  CB  TYR    80      48.336  20.285   2.275  1.00 49.01           C  
ATOM    581  CG  TYR    80      48.087  20.691   0.838  1.00 48.83           C  
ATOM    582  CD1 TYR    80      48.447  21.950   0.376  1.00 46.01           C  
ATOM    583  CD2 TYR    80      47.512  19.806  -0.066  1.00 50.85           C  
ATOM    584  CE1 TYR    80      48.244  22.306  -0.956  1.00 48.56           C  
ATOM    585  CE2 TYR    80      47.298  20.160  -1.389  1.00 49.09           C  
ATOM    586  CZ  TYR    80      47.664  21.405  -1.827  1.00 45.04           C  
ATOM    587  OH  TYR    80      47.448  21.760  -3.136  1.00 46.31           O  
ATOM    588  N   ASP    81      49.359  17.372   2.094  1.00 50.85           N  
ATOM    589  CA  ASP    81      49.426  16.077   1.445  1.00 50.80           C  
ATOM    590  C   ASP    81      48.141  15.778   0.682  1.00 49.39           C  
ATOM    591  O   ASP    81      48.193  15.248  -0.423  1.00 48.44           O  
ATOM    592  CB  ASP    81      49.680  15.009   2.504  1.00 51.60           C  
ATOM    593  CG  ASP    81      51.024  15.184   3.165  1.00 52.29           C  
ATOM    594  OD1 ASP    81      51.983  15.436   2.413  1.00 50.80           O  
ATOM    595  OD2 ASP    81      51.114  15.094   4.405  1.00 52.87           O  
ATOM    596  N   VAL    82      47.005  16.131   1.280  1.00 48.04           N  
ATOM    597  CA  VAL    82      45.679  15.929   0.673  1.00 49.37           C  
ATOM    598  C   VAL    82      44.902  17.249   0.701  1.00 51.01           C  
ATOM    599  O   VAL    82      44.898  17.942   1.713  1.00 49.19           O  
ATOM    600  CB  VAL    82      44.861  14.815   1.432  1.00 50.01           C  
ATOM    601  CG1 VAL    82      44.888  15.036   2.950  1.00 45.54           C  
ATOM    602  CG2 VAL    82      43.413  14.695   0.911  1.00 45.57           C  
ATOM    603  N   LEU    83      44.281  17.601  -0.431  1.00 51.29           N  
ATOM    604  CA  LEU    83      43.392  18.753  -0.515  1.00 49.17           C  
ATOM    605  C   LEU    83      41.920  18.317  -0.411  1.00 49.00           C  
ATOM    606  O   LEU    83      41.450  17.460  -1.165  1.00 48.75           O  
ATOM    607  CB  LEU    83      43.555  19.471  -1.847  1.00 46.98           C  
ATOM    608  CG  LEU    83      42.636  20.677  -2.069  1.00 48.83           C  
ATOM    609  CD1 LEU    83      42.959  21.779  -1.048  1.00 42.31           C  
ATOM    610  CD2 LEU    83      42.764  21.161  -3.508  1.00 42.84           C  
ATOM    611  N   ILE    84      41.197  18.934   0.516  1.00 48.92           N  
ATOM    612  CA  ILE    84      39.746  18.767   0.619  1.00 46.97           C  
ATOM    613  C   ILE    84      39.160  19.989  -0.089  1.00 45.43           C  
ATOM    614  O   ILE    84      39.314  21.113   0.354  1.00 44.83           O  
ATOM    615  CB  ILE    84      39.276  18.666   2.071  1.00 46.15           C  
ATOM    616  CG1 ILE    84      39.852  17.365   2.668  1.00 47.29           C  
ATOM    617  CG2 ILE    84      37.762  18.689   2.092  1.00 46.24           C  
ATOM    618  CD1 ILE    84      39.445  17.067   4.080  1.00 50.14           C  
ATOM    619  N   GLU    85      38.522  19.748  -1.216  1.00 46.60           N  
ATOM    620  CA  GLU    85      38.039  20.784  -2.084  1.00 47.89           C  
ATOM    621  C   GLU    85      36.520  20.804  -2.013  1.00 49.62           C  
ATOM    622  O   GLU    85      35.832  20.028  -2.692  1.00 51.63           O  
ATOM    623  CB  GLU    85      38.573  20.475  -3.490  1.00 51.71           C  
ATOM    624  CG  GLU    85      38.765  21.692  -4.368  1.00 57.75           C  
ATOM    625  CD  GLU    85      37.511  22.140  -5.000  1.00 60.03           C  
ATOM    626  OE1 GLU    85      37.080  21.474  -5.960  1.00 68.42           O  
ATOM    627  OE2 GLU    85      36.983  23.178  -4.569  1.00 72.90           O  
ATOM    628  N   ALA    86      36.025  21.714  -1.175  1.00 50.24           N  
ATOM    629  CA  ALA    86      34.621  21.906  -0.862  1.00 51.22           C  
ATOM    630  C   ALA    86      34.248  23.339  -1.231  1.00 51.93           C  
ATOM    631  O   ALA    86      33.511  24.004  -0.489  1.00 47.88           O  
ATOM    632  CB  ALA    86      34.436  21.671   0.646  1.00 42.93           C  
ATOM    633  N   SER    87      34.774  23.845  -2.363  1.00 55.52           N  
ATOM    634  CA  SER    87      34.591  25.281  -2.700  1.00 57.00           C  
ATOM    635  C   SER    87      33.147  25.630  -3.017  1.00 61.90           C  
ATOM    636  O   SER    87      32.398  24.811  -3.514  1.00 59.30           O  
ATOM    637  CB  SER    87      35.575  25.809  -3.754  1.00 55.15           C  
ATOM    638  OG  SER    87      35.372  25.244  -5.030  1.00 56.86           O  
ATOM    639  N   VAL    88      32.775  26.852  -2.642  1.00 69.20           N  
ATOM    640  CA  VAL    88      31.417  27.390  -2.824  1.00 73.90           C  
ATOM    641  C   VAL    88      31.318  27.964  -4.261  1.00 76.16           C  
ATOM    642  O   VAL    88      31.702  29.098  -4.513  1.00 73.54           O  
ATOM    643  CB  VAL    88      31.120  28.461  -1.715  1.00 73.08           C  
ATOM    644  CG1 VAL    88      29.731  29.066  -1.894  1.00 69.80           C  
ATOM    645  CG2 VAL    88      31.289  27.840  -0.312  1.00 61.02           C  
ATOM    646  N   THR    89      30.828  27.137  -5.190  1.00 81.00           N  
ATOM    647  CA  THR    89      30.745  27.468  -6.637  1.00 82.65           C  
ATOM    648  C   THR    89      30.000  28.772  -6.989  1.00 85.93           C  
ATOM    649  O   THR    89      30.596  29.691  -7.569  1.00 87.51           O  
ATOM    650  CB  THR    89      30.105  26.289  -7.430  1.00 83.25           C  
ATOM    651  OG1 THR    89      30.674  25.064  -6.969  1.00 82.01           O  
ATOM    652  CG2 THR    89      30.323  26.436  -8.944  1.00 80.95           C  
ATOM    653  N   ARG    90      28.711  28.843  -6.654  1.00 87.96           N  
ATOM    654  CA  ARG    90      27.909  30.034  -6.955  1.00 90.26           C  
ATOM    655  C   ARG    90      28.283  31.197  -6.028  1.00 91.70           C  
ATOM    656  O   ARG    90      29.381  31.757  -6.132  1.00 92.21           O  
ATOM    657  CB  ARG    90      26.401  29.730  -6.884  1.00 90.72           C  
ATOM    658  CG  ARG    90      25.902  28.808  -7.988  1.00 88.44           C  
ATOM    659  N   GLU    95      36.980  27.853 -10.944  1.00 71.42           N  
ATOM    660  CA  GLU    95      37.985  27.902  -9.881  1.00 70.39           C  
ATOM    661  C   GLU    95      38.234  26.504  -9.345  1.00 67.32           C  
ATOM    662  O   GLU    95      39.382  26.078  -9.244  1.00 66.47           O  
ATOM    663  CB  GLU    95      37.552  28.843  -8.747  1.00 70.36           C  
ATOM    664  CG  GLU    95      37.322  30.293  -9.198  1.00 74.88           C  
ATOM    665  CD  GLU    95      37.005  31.238  -8.055  1.00 74.03           C  
ATOM    666  N   GLY    96      37.146  25.793  -9.032  1.00 64.05           N  
ATOM    667  CA  GLY    96      37.204  24.430  -8.510  1.00 61.48           C  
ATOM    668  C   GLY    96      38.060  23.472  -9.322  1.00 59.51           C  
ATOM    669  O   GLY    96      38.877  22.737  -8.755  1.00 56.52           O  
ATOM    670  N   VAL    97      37.863  23.492 -10.646  1.00 56.94           N  
ATOM    671  CA  VAL    97      38.614  22.650 -11.595  1.00 55.26           C  
ATOM    672  C   VAL    97      40.127  22.928 -11.513  1.00 56.32           C  
ATOM    673  O   VAL    97      40.927  21.991 -11.518  1.00 55.09           O  
ATOM    674  CB  VAL    97      38.070  22.803 -13.045  1.00 53.78           C  
ATOM    675  CG1 VAL    97      38.066  24.261 -13.494  1.00 58.74           C  
ATOM    676  CG2 VAL    97      38.864  21.960 -14.008  1.00 59.11           C  
ATOM    677  N   ASN    98      40.480  24.214 -11.389  1.00 54.22           N  
ATOM    678  CA  ASN    98      41.857  24.660 -11.246  1.00 54.30           C  
ATOM    679  C   ASN    98      42.453  24.285  -9.882  1.00 51.57           C  
ATOM    680  O   ASN    98      43.645  23.998  -9.795  1.00 47.91           O  
ATOM    681  CB  ASN    98      41.962  26.177 -11.474  1.00 55.52           C  
ATOM    682  CG  ASN    98      41.589  26.593 -12.901  1.00 61.57           C  
ATOM    683  OD1 ASN    98      41.665  25.800 -13.848  1.00 71.44           O  
ATOM    684  ND2 ASN    98      41.197  27.849 -13.056  1.00 66.79           N  
ATOM    685  N   TYR    99      41.643  24.288  -8.820  1.00 48.54           N  
ATOM    686  CA  TYR    99      42.161  23.863  -7.522  1.00 49.64           C  
ATOM    687  C   TYR    99      42.500  22.371  -7.569  1.00 49.05           C  
ATOM    688  O   TYR    99      43.541  21.952  -7.053  1.00 51.64           O  
ATOM    689  CB  TYR    99      41.194  24.121  -6.350  1.00 48.05           C  
ATOM    690  CG  TYR    99      40.754  25.556  -6.162  1.00 46.23           C  
ATOM    691  CD1 TYR    99      41.623  26.625  -6.348  1.00 46.50           C  
ATOM    692  CD2 TYR    99      39.490  25.832  -5.724  1.00 45.42           C  
ATOM    693  CE1 TYR    99      41.192  27.936  -6.155  1.00 46.16           C  
ATOM    694  CE2 TYR    99      39.064  27.119  -5.519  1.00 46.77           C  
ATOM    695  CZ  TYR    99      39.904  28.166  -5.733  1.00 45.70           C  
ATOM    696  OH  TYR    99      39.402  29.434  -5.514  1.00 51.84           O  
ATOM    697  N   ILE   100      41.628  21.574  -8.179  1.00 47.86           N  
ATOM    698  CA  ILE   100      41.874  20.132  -8.314  1.00 49.67           C  
ATOM    699  C   ILE   100      43.122  19.875  -9.195  1.00 51.71           C  
ATOM    700  O   ILE   100      44.067  19.252  -8.743  1.00 51.29           O  
ATOM    701  CB  ILE   100      40.659  19.376  -8.896  1.00 48.81           C  
ATOM    702  CG1 ILE   100      39.469  19.386  -7.930  1.00 48.30           C  
ATOM    703  CG2 ILE   100      41.003  17.910  -9.176  1.00 44.61           C  
ATOM    704  CD1 ILE   100      38.199  18.752  -8.519  1.00 49.51           C  
ATOM    705  N   ARG   101      43.108  20.369 -10.431  1.00 52.51           N  
ATOM    706  CA  ARG   101      44.230  20.194 -11.364  1.00 55.14           C  
ATOM    707  C   ARG   101      45.554  20.601 -10.734  1.00 54.85           C  
ATOM    708  O   ARG   101      46.535  19.874 -10.839  1.00 55.38           O  
ATOM    709  CB  ARG   101      44.035  21.011 -12.650  1.00 55.82           C  
ATOM    710  CG  ARG   101      42.778  20.674 -13.456  1.00 58.03           C  
ATOM    711  CD  ARG   101      42.829  21.241 -14.900  1.00 62.37           C  
ATOM    712  NE  ARG   101      43.768  20.500 -15.761  1.00 74.76           N  
ATOM    713  CZ  ARG   101      43.525  19.324 -16.364  1.00 73.10           C  
ATOM    714  NH1 ARG   101      42.371  18.678 -16.211  1.00 82.89           N  
ATOM    715  NH2 ARG   101      44.462  18.763 -17.113  1.00 77.93           N  
ATOM    716  N   GLU   102      45.570  21.741 -10.047  1.00 55.06           N  
ATOM    717  CA  GLU   102      46.809  22.249  -9.432  1.00 52.94           C  
ATOM    718  C   GLU   102      47.251  21.434  -8.207  1.00 50.92           C  
ATOM    719  O   GLU   102      48.438  21.306  -7.962  1.00 50.71           O  
ATOM    720  CB  GLU   102      46.692  23.751  -9.127  1.00 53.31           C  
ATOM    721  CG  GLU   102      47.894  24.396  -8.412  1.00 59.26           C  
ATOM    722  CD  GLU   102      49.247  24.233  -9.132  1.00 73.51           C  
ATOM    723  OE1 GLU   102      49.290  23.801 -10.310  1.00 79.16           O  
ATOM    724  OE2 GLU   102      50.281  24.545  -8.500  1.00 74.49           O  
ATOM    725  N   ALA   103      46.331  20.875  -7.431  1.00 48.87           N  
ATOM    726  CA  ALA   103      46.771  20.000  -6.334  1.00 49.59           C  
ATOM    727  C   ALA   103      47.291  18.658  -6.928  1.00 50.34           C  
ATOM    728  O   ALA   103      48.342  18.160  -6.523  1.00 49.72           O  
ATOM    729  CB  ALA   103      45.681  19.771  -5.339  1.00 49.73           C  
ATOM    730  N   LEU   104      46.581  18.114  -7.920  1.00 49.91           N  
ATOM    731  CA  LEU   104      46.985  16.867  -8.575  1.00 51.67           C  
ATOM    732  C   LEU   104      48.338  17.020  -9.279  1.00 52.40           C  
ATOM    733  O   LEU   104      49.191  16.145  -9.171  1.00 50.76           O  
ATOM    734  CB  LEU   104      45.928  16.407  -9.568  1.00 49.76           C  
ATOM    735  CG  LEU   104      44.547  16.002  -9.041  1.00 53.38           C  
ATOM    736  CD1 LEU   104      43.662  15.662 -10.233  1.00 37.65           C  
ATOM    737  CD2 LEU   104      44.609  14.837  -8.066  1.00 50.22           C  
ATOM    738  N   LYS   105      48.533  18.144  -9.976  1.00 56.09           N  
ATOM    739  CA  LYS   105      49.814  18.446 -10.655  1.00 57.24           C  
ATOM    740  C   LYS   105      50.963  18.669  -9.692  1.00 57.39           C  
ATOM    741  O   LYS   105      52.103  18.672 -10.107  1.00 59.78           O  
ATOM    742  CB  LYS   105      49.703  19.640 -11.618  1.00 57.94           C  
ATOM    743  CG  LYS   105      49.032  19.267 -12.935  1.00 61.88           C  
ATOM    744  CD  LYS   105      49.179  20.332 -14.006  1.00 62.50           C  
ATOM    745  CE  LYS   105      48.876  19.739 -15.402  1.00 70.85           C  
ATOM    746  NZ  LYS   105      49.886  18.699 -15.892  1.00 70.98           N  
ATOM    747  N   ARG   106      50.658  18.892  -8.420  1.00 58.13           N  
ATOM    748  CA  ARG   106      51.672  19.005  -7.369  1.00 56.77           C  
ATOM    749  C   ARG   106      51.905  17.619  -6.740  1.00 56.15           C  
ATOM    750  O   ARG   106      52.762  17.458  -5.857  1.00 54.66           O  
ATOM    751  CB  ARG   106      51.227  19.993  -6.282  1.00 56.17           C  
ATOM    752  CG  ARG   106      51.323  21.464  -6.672  1.00 56.67           C  
ATOM    753  CD  ARG   106      51.087  22.367  -5.465  1.00 55.82           C  
ATOM    754  NE  ARG   106      52.073  22.124  -4.405  1.00 53.50           N  
ATOM    755  CZ  ARG   106      51.980  22.577  -3.155  1.00 56.94           C  
ATOM    756  NH1 ARG   106      50.933  23.294  -2.762  1.00 58.09           N  
ATOM    757  NH2 ARG   106      52.925  22.285  -2.278  1.00 50.02           N  
ATOM    758  N   GLY   107      51.131  16.628  -7.195  1.00 55.48           N  
ATOM    759  CA  GLY   107      51.208  15.275  -6.654  1.00 55.17           C  
ATOM    760  C   GLY   107      50.539  15.197  -5.295  1.00 54.21           C  
ATOM    761  O   GLY   107      51.081  14.619  -4.345  1.00 54.11           O  
ATOM    762  N   LYS   108      49.371  15.816  -5.186  1.00 51.69           N  
ATOM    763  CA  LYS   108      48.619  15.784  -3.935  1.00 51.31           C  
ATOM    764  C   LYS   108      47.323  15.041  -4.178  1.00 48.74           C  
ATOM    765  O   LYS   108      46.741  15.138  -5.251  1.00 48.93           O  
ATOM    766  CB  LYS   108      48.273  17.194  -3.456  1.00 51.38           C  
ATOM    767  CG  LYS   108      49.419  18.169  -3.456  1.00 56.15           C  
ATOM    768  CD  LYS   108      50.515  17.765  -2.520  1.00 58.85           C  
ATOM    769  CE  LYS   108      51.599  18.829  -2.498  1.00 60.63           C  
ATOM    770  NZ  LYS   108      52.697  18.433  -1.593  1.00 62.62           N  
ATOM    771  N   HIS   109      46.874  14.297  -3.182  1.00 49.47           N  
ATOM    772  CA  HIS   109      45.569  13.666  -3.256  1.00 49.40           C  
ATOM    773  C   HIS   109      44.517  14.758  -3.203  1.00 50.51           C  
ATOM    774  O   HIS   109      44.791  15.847  -2.689  1.00 47.92           O  
ATOM    775  CB  HIS   109      45.343  12.730  -2.073  1.00 49.59           C  
ATOM    776  CG  HIS   109      46.234  11.536  -2.078  1.00 48.32           C  
ATOM    777  ND1 HIS   109      46.214  10.603  -3.090  1.00 46.44           N  
ATOM    778  CD2 HIS   109      47.148  11.101  -1.183  1.00 56.19           C  
ATOM    779  CE1 HIS   109      47.073   9.642  -2.817  1.00 46.97           C  
ATOM    780  NE2 HIS   109      47.665   9.927  -1.671  1.00 52.45           N  
ATOM    781  N   VAL   110      43.330  14.473  -3.752  1.00 50.11           N  
ATOM    782  CA  VAL   110      42.217  15.417  -3.717  1.00 48.52           C  
ATOM    783  C   VAL   110      40.909  14.683  -3.375  1.00 49.34           C  
ATOM    784  O   VAL   110      40.607  13.641  -3.948  1.00 48.90           O  
ATOM    785  CB  VAL   110      42.041  16.184  -5.047  1.00 48.35           C  
ATOM    786  CG1 VAL   110      40.770  17.073  -5.010  1.00 44.89           C  
ATOM    787  CG2 VAL   110      43.297  17.022  -5.380  1.00 49.41           C  
ATOM    788  N   VAL   111      40.183  15.217  -2.388  1.00 49.95           N  
ATOM    789  CA  VAL   111      38.847  14.747  -2.023  1.00 47.72           C  
ATOM    790  C   VAL   111      37.955  15.932  -2.284  1.00 47.79           C  
ATOM    791  O   VAL   111      38.155  16.980  -1.698  1.00 48.65           O  
ATOM    792  CB  VAL   111      38.744  14.330  -0.539  1.00 50.88           C  
ATOM    793  CG1 VAL   111      37.274  13.885  -0.179  1.00 43.38           C  
ATOM    794  CG2 VAL   111      39.822  13.221  -0.211  1.00 37.10           C  
ATOM    795  N   THR   112      36.975  15.786  -3.170  1.00 48.71           N  
ATOM    796  CA  THR   112      36.090  16.889  -3.497  1.00 48.68           C  
ATOM    797  C   THR   112      34.581  16.600  -3.306  1.00 47.62           C  
ATOM    798  O   THR   112      34.144  15.451  -3.292  1.00 46.68           O  
ATOM    799  CB  THR   112      36.337  17.321  -4.968  1.00 50.41           C  
ATOM    800  OG1 THR   112      35.673  18.561  -5.241  1.00 47.66           O  
ATOM    801  CG2 THR   112      35.852  16.241  -5.934  1.00 45.32           C  
ATOM    802  N   SER   113      33.820  17.681  -3.147  1.00 45.75           N  
ATOM    803  CA  SER   113      32.375  17.659  -3.096  1.00 46.09           C  
ATOM    804  C   SER   113      31.789  18.458  -4.240  1.00 47.40           C  
ATOM    805  O   SER   113      30.560  18.580  -4.317  1.00 45.48           O  
ATOM    806  CB  SER   113      31.875  18.236  -1.788  1.00 45.43           C  
ATOM    807  OG  SER   113      32.284  19.584  -1.646  1.00 48.74           O  
ATOM    808  N   ASN   114      32.644  19.035  -5.109  1.00 50.21           N  
ATOM    809  CA  ASN   114      32.192  19.825  -6.272  1.00 48.59           C  
ATOM    810  C   ASN   114      31.952  18.966  -7.482  1.00 50.23           C  
ATOM    811  O   ASN   114      32.851  18.267  -7.955  1.00 53.11           O  
ATOM    812  CB  ASN   114      33.234  20.855  -6.728  1.00 53.83           C  
ATOM    813  CG  ASN   114      33.505  21.943  -5.724  1.00 55.30           C  
ATOM    814  OD1 ASN   114      32.666  22.306  -4.903  1.00 62.72           O  
ATOM    815  ND2 ASN   114      34.684  22.520  -5.836  1.00 64.14           N  
ATOM    816  N   LYS   115      30.766  19.082  -8.045  1.00 50.56           N  
ATOM    817  CA  LYS   115      30.398  18.316  -9.208  1.00 51.29           C  
ATOM    818  C   LYS   115      30.955  18.846 -10.506  1.00 51.41           C  
ATOM    819  O   LYS   115      31.316  18.065 -11.374  1.00 51.72           O  
ATOM    820  CB  LYS   115      28.881  18.263  -9.341  1.00 49.65           C  
ATOM    821  CG  LYS   115      28.202  17.499  -8.226  1.00 52.75           C  
ATOM    822  CD  LYS   115      26.694  17.359  -8.422  1.00 53.62           C  
ATOM    823  CE  LYS   115      25.950  18.662  -8.349  1.00 50.26           C  
ATOM    824  NZ  LYS   115      26.141  19.356  -7.059  1.00 50.30           N  
ATOM    825  N   GLY   116      30.971  20.166 -10.651  1.00 52.85           N  
ATOM    826  CA  GLY   116      31.371  20.831 -11.893  1.00 53.63           C  
ATOM    827  C   GLY   116      32.590  20.334 -12.641  1.00 52.17           C  
ATOM    828  O   GLY   116      32.525  20.138 -13.850  1.00 52.80           O  
ATOM    829  N   PRO   117      33.732  20.230 -11.942  1.00 54.21           N  
ATOM    830  CA  PRO   117      34.969  19.755 -12.567  1.00 54.55           C  
ATOM    831  C   PRO   117      34.874  18.330 -13.110  1.00 54.36           C  
ATOM    832  O   PRO   117      35.433  18.031 -14.153  1.00 53.77           O  
ATOM    833  CB  PRO   117      36.012  19.857 -11.431  1.00 55.95           C  
ATOM    834  CG  PRO   117      35.430  20.794 -10.416  1.00 56.94           C  
ATOM    835  CD  PRO   117      33.940  20.671 -10.539  1.00 53.64           C  
ATOM    836  N   LEU   118      34.183  17.465 -12.378  1.00 55.23           N  
ATOM    837  CA  LEU   118      33.987  16.075 -12.757  1.00 55.96           C  
ATOM    838  C   LEU   118      33.057  15.968 -13.965  1.00 55.80           C  
ATOM    839  O   LEU   118      33.257  15.138 -14.825  1.00 58.23           O  
ATOM    840  CB  LEU   118      33.446  15.262 -11.545  1.00 58.62           C  
ATOM    841  CG  LEU   118      34.500  15.044 -10.441  1.00 61.54           C  
ATOM    842  CD1 LEU   118      33.928  14.742  -9.107  1.00 71.04           C  
ATOM    843  CD2 LEU   118      35.406  13.924 -10.859  1.00 68.06           C  
ATOM    844  N   VAL   119      32.046  16.817 -14.035  1.00 54.86           N  
ATOM    845  CA  VAL   119      31.113  16.814 -15.154  1.00 53.09           C  
ATOM    846  C   VAL   119      31.791  17.310 -16.443  1.00 55.58           C  
ATOM    847  O   VAL   119      31.652  16.694 -17.498  1.00 56.38           O  
ATOM    848  CB  VAL   119      29.889  17.628 -14.764  1.00 54.44           C  
ATOM    849  CG1 VAL   119      28.941  17.805 -15.914  1.00 52.88           C  
ATOM    850  CG2 VAL   119      29.207  16.909 -13.621  1.00 44.67           C  
ATOM    851  N   ALA   120      32.582  18.373 -16.318  1.00 54.44           N  
ATOM    852  CA  ALA   120      33.290  18.992 -17.435  1.00 54.29           C  
ATOM    853  C   ALA   120      34.518  18.235 -17.921  1.00 55.34           C  
ATOM    854  O   ALA   120      34.811  18.247 -19.105  1.00 57.54           O  
ATOM    855  CB  ALA   120      33.737  20.410 -17.029  1.00 51.93           C  
ATOM    856  N   GLU   121      35.213  17.545 -17.025  1.00 56.00           N  
ATOM    857  CA  GLU   121      36.541  17.038 -17.323  1.00 58.35           C  
ATOM    858  C   GLU   121      36.841  15.724 -16.611  1.00 55.53           C  
ATOM    859  O   GLU   121      37.940  15.530 -16.113  1.00 56.64           O  
ATOM    860  CB  GLU   121      37.464  18.167 -16.815  1.00 59.18           C  
ATOM    861  CG  GLU   121      38.830  18.362 -17.439  1.00 70.74           C  
ATOM    862  CD  GLU   121      39.409  19.783 -17.142  1.00 65.74           C  
ATOM    863  OE1 GLU   121      38.645  20.684 -16.743  1.00 79.01           O  
ATOM    864  OE2 GLU   121      40.619  20.015 -17.355  1.00 85.72           O  
ATOM    865  N   PHE   122      35.876  14.802 -16.601  1.00 56.63           N  
ATOM    866  CA  PHE   122      36.010  13.547 -15.844  1.00 55.23           C  
ATOM    867  C   PHE   122      37.264  12.738 -16.151  1.00 54.15           C  
ATOM    868  O   PHE   122      38.086  12.516 -15.264  1.00 52.49           O  
ATOM    869  CB  PHE   122      34.777  12.655 -16.018  1.00 54.88           C  
ATOM    870  CG  PHE   122      34.693  11.521 -15.020  1.00 50.49           C  
ATOM    871  CD1 PHE   122      35.355  10.327 -15.244  1.00 55.24           C  
ATOM    872  CD2 PHE   122      33.935  11.644 -13.876  1.00 50.51           C  
ATOM    873  CE1 PHE   122      35.289   9.278 -14.335  1.00 51.72           C  
ATOM    874  CE2 PHE   122      33.841  10.587 -12.970  1.00 51.01           C  
ATOM    875  CZ  PHE   122      34.524   9.416 -13.196  1.00 52.74           C  
ATOM    876  N   HIS   123      37.401  12.272 -17.392  1.00 56.63           N  
ATOM    877  CA  HIS   123      38.563  11.450 -17.733  0.50 55.39           C  
ATOM    879  C   HIS   123      39.863  12.266 -17.699  1.00 54.42           C  
ATOM    880  O   HIS   123      40.909  11.736 -17.299  1.00 53.57           O  
ATOM    881  CB  HIS   123      38.302  10.658 -19.024  0.50 56.22           C  
ATOM    883  CG  HIS   123      37.164   9.680 -18.890  0.50 57.00           C  
ATOM    885  ND1 HIS   123      37.353   8.347 -18.593  0.50 58.87           N  
ATOM    887  CD2 HIS   123      35.821   9.859 -18.951  0.50 55.15           C  
ATOM    889  CE1 HIS   123      36.178   7.744 -18.505  0.50 56.16           C  
ATOM    891  NE2 HIS   123      35.233   8.640 -18.717  0.50 47.93           N  
ATOM    893  N   GLY   124      39.796  13.550 -18.054  1.00 53.91           N  
ATOM    894  CA  GLY   124      40.978  14.415 -17.976  1.00 53.04           C  
ATOM    895  C   GLY   124      41.543  14.511 -16.555  1.00 51.96           C  
ATOM    896  O   GLY   124      42.753  14.529 -16.351  1.00 50.24           O  
ATOM    897  N   LEU   125      40.664  14.563 -15.559  1.00 53.43           N  
ATOM    898  CA  LEU   125      41.097  14.673 -14.155  1.00 52.48           C  
ATOM    899  C   LEU   125      41.531  13.328 -13.551  1.00 50.24           C  
ATOM    900  O   LEU   125      42.487  13.275 -12.777  1.00 49.73           O  
ATOM    901  CB  LEU   125      40.000  15.344 -13.308  1.00 53.01           C  
ATOM    902  CG  LEU   125      39.695  16.826 -13.543  1.00 54.32           C  
ATOM    903  CD1 LEU   125      38.510  17.280 -12.725  1.00 55.94           C  
ATOM    904  CD2 LEU   125      40.916  17.652 -13.194  1.00 52.48           C  
ATOM    905  N   MET   126      40.808  12.256 -13.865  1.00 52.81           N  
ATOM    906  CA  MET   126      41.185  10.893 -13.402  1.00 54.54           C  
ATOM    907  C   MET   126      42.575  10.517 -13.924  1.00 53.83           C  
ATOM    908  O   MET   126      43.378   9.944 -13.184  1.00 53.10           O  
ATOM    909  CB  MET   126      40.189   9.807 -13.835  1.00 54.20           C  
ATOM    910  CG  MET   126      38.795   9.855 -13.183  1.00 58.18           C  
ATOM    911  SD  MET   126      38.751  10.091 -11.219  0.75 60.16          SE  
ATOM    912  CE  MET   126      39.752   8.577 -10.538  1.00 78.54           C  
ATOM    913  N   SER   127      42.844  10.862 -15.186  1.00 54.62           N  
ATOM    914  CA  SER   127      44.147  10.597 -15.831  1.00 54.86           C  
ATOM    915  C   SER   127      45.267  11.425 -15.241  1.00 53.47           C  
ATOM    916  O   SER   127      46.381  10.950 -15.131  1.00 55.47           O  
ATOM    917  CB  SER   127      44.094  10.894 -17.332  1.00 54.90           C  
ATOM    918  OG  SER   127      43.186  10.041 -17.993  1.00 61.83           O  
ATOM    919  N   LEU   128      44.978  12.684 -14.919  1.00 52.40           N  
ATOM    920  CA  LEU   128      45.966  13.574 -14.325  1.00 50.90           C  
ATOM    921  C   LEU   128      46.372  13.016 -12.972  1.00 51.93           C  
ATOM    922  O   LEU   128      47.555  12.994 -12.633  1.00 53.62           O  
ATOM    923  CB  LEU   128      45.395  14.980 -14.198  1.00 51.03           C  
ATOM    924  CG  LEU   128      46.234  16.105 -13.596  1.00 49.96           C  
ATOM    925  CD1 LEU   128      47.568  16.259 -14.343  1.00 56.86           C  
ATOM    926  CD2 LEU   128      45.413  17.380 -13.639  1.00 50.06           C  
ATOM    927  N   ALA   129      45.385  12.556 -12.208  1.00 51.61           N  
ATOM    928  CA  ALA   129      45.632  11.936 -10.915  1.00 51.88           C  
ATOM    929  C   ALA   129      46.487  10.673 -11.099  1.00 52.40           C  
ATOM    930  O   ALA   129      47.434  10.443 -10.339  1.00 50.89           O  
ATOM    931  CB  ALA   129      44.296  11.596 -10.207  1.00 50.63           C  
ATOM    932  N   GLU   130      46.137   9.856 -12.094  1.00 53.27           N  
ATOM    933  CA  GLU   130      46.895   8.632 -12.398  1.00 54.20           C  
ATOM    934  C   GLU   130      48.324   8.963 -12.851  1.00 54.83           C  
ATOM    935  O   GLU   130      49.264   8.333 -12.362  1.00 54.37           O  
ATOM    936  CB  GLU   130      46.193   7.791 -13.462  1.00 52.41           C  
ATOM    937  N   ARG   131      48.492   9.955 -13.743  1.00 55.42           N  
ATOM    938  CA  ARG   131      49.840  10.356 -14.250  1.00 56.32           C  
ATOM    939  C   ARG   131      50.738  10.829 -13.114  1.00 55.67           C  
ATOM    940  O   ARG   131      51.926  10.576 -13.118  1.00 56.70           O  
ATOM    941  CB  ARG   131      49.758  11.431 -15.348  1.00 56.34           C  
ATOM    942  CG  ARG   131      49.050  10.967 -16.660  1.00 62.98           C  
ATOM    943  CD  ARG   131      48.982  12.092 -17.710  1.00 61.66           C  
ATOM    944  NE  ARG   131      48.426  13.344 -17.177  1.00 64.09           N  
ATOM    945  N   ASN   132      50.177  11.568 -12.168  1.00 56.65           N  
ATOM    946  CA  ASN   132      50.895  11.901 -10.943  1.00 56.97           C  
ATOM    947  C   ASN   132      50.559  10.651 -10.117  1.00 58.00           C  
ATOM    948  O   ASN   132      49.869   9.779 -10.637  1.00 59.78           O  
ATOM    949  CB  ASN   132      50.415  13.238 -10.413  1.00 57.33           C  
ATOM    950  CG  ASN   132      50.664  14.355 -11.420  1.00 57.24           C  
ATOM    951  OD1 ASN   132      51.786  14.816 -11.570  1.00 61.01           O  
ATOM    952  ND2 ASN   132      49.626  14.760 -12.140  1.00 60.01           N  
ATOM    953  N   GLY   133      51.018  10.477  -8.889  1.00 57.07           N  
ATOM    954  CA  GLY   133      50.747   9.159  -8.251  1.00 56.86           C  
ATOM    955  C   GLY   133      49.713   9.238  -7.162  1.00 56.82           C  
ATOM    956  O   GLY   133      49.919   8.703  -6.070  1.00 58.77           O  
ATOM    957  N   VAL   134      48.579   9.858  -7.474  1.00 53.08           N  
ATOM    958  CA  VAL   134      47.616  10.206  -6.441  1.00 51.32           C  
ATOM    959  C   VAL   134      46.175   9.874  -6.828  1.00 50.72           C  
ATOM    960  O   VAL   134      45.910   9.435  -7.945  1.00 48.58           O  
ATOM    961  CB  VAL   134      47.796  11.703  -6.057  1.00 51.01           C  
ATOM    962  CG1 VAL   134      49.012  11.872  -5.150  1.00 54.40           C  
ATOM    963  CG2 VAL   134      47.930  12.580  -7.305  1.00 45.88           C  
ATOM    964  N   ARG   135      45.268  10.139  -5.895  0.50 49.42           N  
ATOM    966  CA  ARG   135      43.865   9.791  -6.030  0.50 48.64           C  
ATOM    968  C   ARG   135      42.945  11.001  -6.034  0.50 49.96           C  
ATOM    970  O   ARG   135      43.253  12.019  -5.408  0.50 49.55           O  
ATOM    972  CB  ARG   135      43.520   8.818  -4.889  0.50 49.07           C  
ATOM    974  CG  ARG   135      44.238   7.447  -5.089  0.50 42.86           C  
ATOM    976  CD  ARG   135      44.600   6.726  -3.784  0.50 47.77           C  
ATOM    978  NE  ARG   135      43.639   5.901  -3.034  0.50 45.67           N  
ATOM    980  CZ  ARG   135      42.520   5.335  -3.464  0.50 34.61           C  
ATOM    982  NH1 ARG   135      42.107   5.428  -4.715  0.50 49.68           N  
ATOM    984  NH2 ARG   135      41.807   4.612  -2.611  0.50 41.15           N  
ATOM    986  N   LEU   136      41.850  10.901  -6.803  1.00 51.89           N  
ATOM    987  CA  LEU   136      40.819  11.910  -6.827  1.00 50.18           C  
ATOM    988  C   LEU   136      39.542  11.204  -6.338  1.00 49.36           C  
ATOM    989  O   LEU   136      38.971  10.354  -7.025  1.00 47.37           O  
ATOM    990  CB  LEU   136      40.644  12.459  -8.244  1.00 48.45           C  
ATOM    991  CG  LEU   136      39.474  13.415  -8.427  1.00 52.91           C  
ATOM    992  CD1 LEU   136      39.544  14.575  -7.432  1.00 49.89           C  
ATOM    993  CD2 LEU   136      39.446  13.914  -9.835  1.00 50.66           C  
ATOM    994  N   MET   137      39.124  11.584  -5.133  1.00 49.57           N  
ATOM    995  CA  MET   137      37.985  11.000  -4.440  1.00 47.97           C  
ATOM    996  C   MET   137      36.838  11.987  -4.519  1.00 47.50           C  
ATOM    997  O   MET   137      37.051  13.185  -4.449  1.00 47.68           O  
ATOM    998  CB  MET   137      38.368  10.700  -2.991  1.00 48.53           C  
ATOM    999  CG  MET   137      39.656   9.905  -2.862  1.00 42.73           C  
ATOM   1000  SD  MET   137      39.679   8.179  -3.673  0.75 46.98          SE  
ATOM   1001  CE  MET   137      38.432   7.168  -2.288  1.00 38.10           C  
ATOM   1002  N   TYR   138      35.630  11.460  -4.661  1.00 48.91           N  
ATOM   1003  CA  TYR   138      34.475  12.256  -4.923  1.00 47.22           C  
ATOM   1004  C   TYR   138      33.151  11.698  -4.424  1.00 47.83           C  
ATOM   1005  O   TYR   138      32.087  12.015  -4.959  1.00 45.61           O  
ATOM   1006  CB  TYR   138      34.424  12.553  -6.412  1.00 44.71           C  
ATOM   1007  CG  TYR   138      34.385  11.379  -7.364  1.00 46.33           C  
ATOM   1008  CD1 TYR   138      35.546  10.696  -7.704  1.00 52.94           C  
ATOM   1009  CD2 TYR   138      33.214  11.025  -8.019  1.00 44.16           C  
ATOM   1010  CE1 TYR   138      35.532   9.650  -8.594  1.00 43.58           C  
ATOM   1011  CE2 TYR   138      33.201  10.003  -8.915  1.00 46.47           C  
ATOM   1012  CZ  TYR   138      34.374   9.332  -9.212  1.00 48.02           C  
ATOM   1013  OH  TYR   138      34.369   8.298 -10.104  1.00 46.71           O  
ATOM   1014  N   GLU   139      33.216  10.954  -3.334  1.00 45.83           N  
ATOM   1015  CA  GLU   139      32.017  10.400  -2.731  1.00 47.57           C  
ATOM   1016  C   GLU   139      30.970  11.444  -2.426  1.00 49.18           C  
ATOM   1017  O   GLU   139      29.768  11.190  -2.572  1.00 50.54           O  
ATOM   1018  CB  GLU   139      32.335   9.668  -1.414  1.00 48.35           C  
ATOM   1019  CG  GLU   139      31.164   8.835  -0.884  1.00 47.00           C  
ATOM   1020  CD  GLU   139      30.758   7.711  -1.860  1.00 43.98           C  
ATOM   1021  OE1 GLU   139      31.478   6.693  -1.942  1.00 46.77           O  
ATOM   1022  OE2 GLU   139      29.693   7.834  -2.501  1.00 51.48           O  
ATOM   1023  N   ALA   140      31.410  12.632  -2.008  1.00 47.25           N  
ATOM   1024  CA  ALA   140      30.466  13.630  -1.608  1.00 46.58           C  
ATOM   1025  C   ALA   140      29.757  14.314  -2.779  1.00 47.40           C  
ATOM   1026  O   ALA   140      28.847  15.054  -2.526  1.00 48.49           O  
ATOM   1027  CB  ALA   140      31.140  14.651  -0.721  1.00 44.92           C  
ATOM   1028  N   THR   141      30.195  14.090  -4.022  1.00 46.91           N  
ATOM   1029  CA  THR   141      29.588  14.714  -5.207  1.00 48.12           C  
ATOM   1030  C   THR   141      28.202  14.200  -5.568  1.00 50.80           C  
ATOM   1031  O   THR   141      27.416  14.944  -6.177  1.00 51.29           O  
ATOM   1032  CB  THR   141      30.478  14.659  -6.488  1.00 47.24           C  
ATOM   1033  OG1 THR   141      30.723  13.294  -6.859  1.00 48.28           O  
ATOM   1034  CG2 THR   141      31.825  15.414  -6.262  1.00 43.30           C  
ATOM   1035  N   VAL   142      27.914  12.957  -5.200  1.00 53.48           N  
ATOM   1036  CA  VAL   142      26.622  12.313  -5.469  1.00 53.95           C  
ATOM   1037  C   VAL   142      26.171  11.369  -4.346  1.00 54.69           C  
ATOM   1038  O   VAL   142      26.930  10.513  -3.878  1.00 55.37           O  
ATOM   1039  CB  VAL   142      26.618  11.611  -6.854  1.00 54.18           C  
ATOM   1040  CG1 VAL   142      27.955  10.999  -7.161  1.00 57.67           C  
ATOM   1041  CG2 VAL   142      25.479  10.619  -6.943  1.00 52.95           C  
ATOM   1042  N   GLY   143      24.958  11.600  -3.856  1.00 52.14           N  
ATOM   1043  CA  GLY   143      24.374  10.750  -2.838  1.00 50.98           C  
ATOM   1044  C   GLY   143      24.609  11.204  -1.432  1.00 51.28           C  
ATOM   1045  O   GLY   143      24.085  10.613  -0.496  1.00 55.26           O  
ATOM   1046  N   GLY   144      25.396  12.256  -1.251  1.00 52.65           N  
ATOM   1047  CA  GLY   144      25.723  12.698   0.083  1.00 51.40           C  
ATOM   1048  C   GLY   144      26.376  11.565   0.871  1.00 50.65           C  
ATOM   1049  O   GLY   144      27.388  11.001   0.447  1.00 48.18           O  
ATOM   1050  N   ALA   145      25.768  11.212   2.002  1.00 51.56           N  
ATOM   1051  CA  ALA   145      26.327  10.204   2.909  1.00 52.26           C  
ATOM   1052  C   ALA   145      26.139   8.777   2.348  1.00 53.05           C  
ATOM   1053  O   ALA   145      26.863   7.857   2.708  1.00 53.99           O  
ATOM   1054  CB  ALA   145      25.677  10.322   4.270  1.00 50.99           C  
ATOM   1055  N   MET   146      25.158   8.618   1.462  1.00 50.60           N  
ATOM   1056  CA  MET   146      24.891   7.368   0.851  1.00 50.52           C  
ATOM   1057  C   MET   146      26.084   6.894   0.012  1.00 50.64           C  
ATOM   1058  O   MET   146      26.504   7.577  -0.892  1.00 48.54           O  
ATOM   1059  CB  MET   146      23.694   7.542  -0.055  1.00 51.68           C  
ATOM   1060  CG  MET   146      23.106   6.288  -0.514  1.00 53.42           C  
ATOM   1061  SD  MET   146      21.639   6.652  -1.726  0.75 51.40          SE  
ATOM   1062  CE  MET   146      22.421   7.137  -3.397  1.00 41.76           C  
ATOM   1063  N   PRO   147      26.590   5.680   0.272  1.00 55.27           N  
ATOM   1064  CA  PRO   147      27.666   5.168  -0.554  1.00 59.57           C  
ATOM   1065  C   PRO   147      27.109   4.969  -1.970  1.00 62.01           C  
ATOM   1066  O   PRO   147      26.020   4.430  -2.168  1.00 69.27           O  
ATOM   1067  CB  PRO   147      27.996   3.825   0.115  1.00 62.74           C  
ATOM   1068  CG  PRO   147      26.726   3.399   0.712  1.00 58.36           C  
ATOM   1069  CD  PRO   147      26.153   4.675   1.262  1.00 57.17           C  
ATOM   1070  N   VAL   148      27.811   5.458  -2.944  1.00 58.57           N  
ATOM   1071  CA  VAL   148      27.372   5.354  -4.306  1.00 57.54           C  
ATOM   1072  C   VAL   148      28.616   5.216  -5.127  1.00 54.59           C  
ATOM   1073  O   VAL   148      28.723   4.308  -5.944  1.00 52.23           O  
ATOM   1074  CB  VAL   148      26.547   6.614  -4.724  1.00 60.30           C  
ATOM   1075  CG1 VAL   148      26.965   7.147  -6.068  1.00 66.42           C  
ATOM   1076  CG2 VAL   148      25.075   6.275  -4.725  1.00 68.44           C  
ATOM   1077  N   VAL   149      29.574   6.114  -4.890  1.00 52.03           N  
ATOM   1078  CA  VAL   149      30.798   6.115  -5.672  1.00 51.15           C  
ATOM   1079  C   VAL   149      31.675   4.920  -5.288  1.00 50.57           C  
ATOM   1080  O   VAL   149      32.071   4.145  -6.167  1.00 45.42           O  
ATOM   1081  CB  VAL   149      31.546   7.468  -5.571  1.00 53.38           C  
ATOM   1082  CG1 VAL   149      32.893   7.384  -6.303  1.00 49.14           C  
ATOM   1083  CG2 VAL   149      30.649   8.600  -6.096  1.00 47.53           C  
ATOM   1084  N   LYS   150      31.952   4.755  -3.989  1.00 48.79           N  
ATOM   1085  CA  LYS   150      32.784   3.626  -3.512  1.00 49.43           C  
ATOM   1086  C   LYS   150      32.095   2.320  -3.764  1.00 47.11           C  
ATOM   1087  O   LYS   150      32.760   1.332  -4.023  1.00 46.70           O  
ATOM   1088  CB  LYS   150      33.287   3.796  -2.039  1.00 47.93           C  
ATOM   1089  CG  LYS   150      34.373   4.877  -1.975  1.00 54.17           C  
ATOM   1090  CD  LYS   150      35.164   5.020  -0.677  1.00 51.38           C  
ATOM   1091  CE  LYS   150      34.367   5.564   0.440  1.00 49.40           C  
ATOM   1092  NZ  LYS   150      33.730   6.839   0.047  1.00 45.36           N  
ATOM   1093  N   LEU   151      30.766   2.343  -3.813  1.00 47.45           N  
ATOM   1094  CA  LEU   151      29.981   1.164  -4.115  1.00 50.05           C  
ATOM   1095  C   LEU   151      30.137   0.788  -5.590  1.00 50.80           C  
ATOM   1096  O   LEU   151      30.518  -0.323  -5.894  1.00 50.90           O  
ATOM   1097  CB  LEU   151      28.510   1.423  -3.788  1.00 50.10           C  
ATOM   1098  CG  LEU   151      27.572   0.282  -3.453  1.00 53.83           C  
ATOM   1099  CD1 LEU   151      28.191  -0.557  -2.376  1.00 52.95           C  
ATOM   1100  CD2 LEU   151      26.256   0.818  -2.940  1.00 51.54           C  
ATOM   1101  N   ALA   152      29.828   1.712  -6.498  1.00 51.01           N  
ATOM   1102  CA  ALA   152      30.003   1.494  -7.945  1.00 51.04           C  
ATOM   1103  C   ALA   152      31.442   1.116  -8.305  1.00 53.77           C  
ATOM   1104  O   ALA   152      31.685   0.143  -9.005  1.00 60.02           O  
ATOM   1105  CB  ALA   152      29.575   2.740  -8.712  1.00 52.32           C  
ATOM   1106  N   LYS   153      32.398   1.805  -7.706  1.00 54.40           N  
ATOM   1107  CA  LYS   153      33.807   1.695  -8.037  1.00 53.36           C  
ATOM   1108  C   LYS   153      34.665   0.702  -7.258  1.00 55.14           C  
ATOM   1109  O   LYS   153      35.620   0.158  -7.812  1.00 57.79           O  
ATOM   1110  CB  LYS   153      34.377   3.115  -7.900  1.00 54.63           C  
ATOM   1111  CG  LYS   153      35.746   3.330  -8.418  1.00 58.39           C  
ATOM   1112  CD  LYS   153      36.106   4.819  -8.468  1.00 52.71           C  
ATOM   1113  CE  LYS   153      37.502   4.973  -9.105  1.00 61.35           C  
ATOM   1114  NZ  LYS   153      37.926   6.379  -9.270  1.00 66.54           N  
ATOM   1115  N   ARG   154      34.395   0.477  -5.980  1.00 54.31           N  
ATOM   1116  CA  ARG   154      35.188  -0.505  -5.228  1.00 54.23           C  
ATOM   1117  C   ARG   154      34.476  -1.840  -4.948  1.00 55.81           C  
ATOM   1118  O   ARG   154      34.992  -2.916  -5.324  1.00 57.05           O  
ATOM   1119  CB  ARG   154      35.708   0.073  -3.925  1.00 54.10           C  
ATOM   1120  CG  ARG   154      36.583   1.271  -4.109  1.00 57.75           C  
ATOM   1121  CD  ARG   154      37.445   1.469  -2.909  1.00 70.09           C  
ATOM   1122  NE  ARG   154      38.334   0.318  -2.732  1.00 74.67           N  
ATOM   1123  CZ  ARG   154      39.451   0.100  -3.430  1.00 77.44           C  
ATOM   1124  NH1 ARG   154      39.846   0.949  -4.379  1.00 81.46           N  
ATOM   1125  NH2 ARG   154      40.178  -0.983  -3.187  1.00 76.63           N  
ATOM   1126  N   TYR   155      33.295  -1.785  -4.322  0.50 54.71           N  
ATOM   1128  CA  TYR   155      32.536  -3.010  -4.014  0.50 53.40           C  
ATOM   1130  C   TYR   155      32.141  -3.747  -5.269  0.50 54.30           C  
ATOM   1132  O   TYR   155      32.419  -4.925  -5.428  0.50 53.99           O  
ATOM   1134  CB  TYR   155      31.255  -2.734  -3.218  0.50 51.83           C  
ATOM   1136  CG  TYR   155      30.583  -4.021  -2.795  0.50 43.29           C  
ATOM   1138  CD1 TYR   155      31.041  -4.726  -1.709  0.50 41.08           C  
ATOM   1140  CD2 TYR   155      29.518  -4.539  -3.500  0.50 48.09           C  
ATOM   1142  CE1 TYR   155      30.462  -5.905  -1.330  0.50 48.06           C  
ATOM   1144  CE2 TYR   155      28.924  -5.719  -3.138  0.50 42.41           C  
ATOM   1146  CZ  TYR   155      29.397  -6.402  -2.040  0.50 45.37           C  
ATOM   1148  OH  TYR   155      28.828  -7.589  -1.643  0.50 44.65           O  
ATOM   1150  N   LEU   156      31.501  -3.034  -6.177  1.00 55.32           N  
ATOM   1151  CA  LEU   156      31.031  -3.657  -7.435  1.00 56.06           C  
ATOM   1152  C   LEU   156      32.119  -3.608  -8.588  1.00 57.02           C  
ATOM   1153  O   LEU   156      31.785  -3.715  -9.780  1.00 59.87           O  
ATOM   1154  CB  LEU   156      29.713  -2.989  -7.882  1.00 55.67           C  
ATOM   1155  CG  LEU   156      28.350  -3.341  -7.236  1.00 60.67           C  
ATOM   1156  CD1 LEU   156      28.451  -3.636  -5.794  1.00 66.28           C  
ATOM   1157  CD2 LEU   156      27.290  -2.228  -7.457  1.00 57.19           C  
ATOM   1158  N   ALA   157      33.400  -3.468  -8.226  1.00 56.54           N  
ATOM   1159  CA  ALA   157      34.521  -3.350  -9.184  1.00 56.55           C  
ATOM   1160  C   ALA   157      34.622  -4.450 -10.263  1.00 59.66           C  
ATOM   1161  O   ALA   157      34.781  -4.134 -11.446  1.00 61.89           O  
ATOM   1162  CB  ALA   157      35.839  -3.295  -8.418  1.00 55.50           C  
ATOM   1163  N   LEU   158      34.555  -5.728  -9.864  1.00 56.71           N  
ATOM   1164  CA  LEU   158      34.674  -6.827 -10.825  1.00 55.58           C  
ATOM   1165  C   LEU   158      33.330  -7.304 -11.373  1.00 53.88           C  
ATOM   1166  O   LEU   158      33.243  -8.387 -11.927  1.00 54.06           O  
ATOM   1167  CB  LEU   158      35.522  -7.974 -10.251  1.00 52.64           C  
ATOM   1168  CG  LEU   158      36.933  -7.510  -9.841  1.00 55.52           C  
ATOM   1169  CD1 LEU   158      37.710  -8.657  -9.185  1.00 48.73           C  
ATOM   1170  CD2 LEU   158      37.732  -6.940 -11.023  1.00 52.52           C  
ATOM   1171  N   CYS   159      32.288  -6.496 -11.200  1.00 56.59           N  
ATOM   1172  CA  CYS   159      30.969  -6.723 -11.822  1.00 59.68           C  
ATOM   1173  C   CYS   159      30.829  -5.783 -12.996  1.00 61.90           C  
ATOM   1174  O   CYS   159      31.402  -4.686 -13.006  1.00 62.77           O  
ATOM   1175  CB  CYS   159      29.800  -6.251 -10.943  1.00 61.49           C  
ATOM   1176  SG  CYS   159      29.435  -7.136  -9.519  1.00 64.20           S  
ATOM   1177  N   GLU   160      29.971  -6.169 -13.921  1.00 61.80           N  
ATOM   1178  CA  GLU   160      29.610  -5.314 -15.002  1.00 63.32           C  
ATOM   1179  C   GLU   160      28.327  -4.673 -14.491  1.00 59.95           C  
ATOM   1180  O   GLU   160      27.312  -5.341 -14.330  1.00 58.39           O  
ATOM   1181  CB  GLU   160      29.344  -6.146 -16.256  1.00 65.37           C  
ATOM   1182  CG  GLU   160      29.285  -5.391 -17.590  1.00 70.26           C  
ATOM   1183  CD  GLU   160      28.942  -6.339 -18.739  1.00 72.53           C  
ATOM   1184  OE1 GLU   160      27.785  -6.829 -18.776  1.00 88.10           O  
ATOM   1185  OE2 GLU   160      29.825  -6.598 -19.602  1.00 88.52           O  
ATOM   1186  N   ILE   161      28.384  -3.387 -14.175  1.00 59.80           N  
ATOM   1187  CA  ILE   161      27.187  -2.659 -13.768  1.00 57.54           C  
ATOM   1188  C   ILE   161      26.499  -2.299 -15.053  1.00 58.17           C  
ATOM   1189  O   ILE   161      27.023  -1.517 -15.833  1.00 60.25           O  
ATOM   1190  CB  ILE   161      27.495  -1.412 -12.991  1.00 56.04           C  
ATOM   1191  CG1 ILE   161      28.227  -1.781 -11.711  1.00 52.54           C  
ATOM   1192  CG2 ILE   161      26.190  -0.668 -12.657  1.00 55.86           C  
ATOM   1193  CD1 ILE   161      28.695  -0.602 -10.903  1.00 50.27           C  
ATOM   1194  N   GLU   162      25.334  -2.887 -15.275  1.00 57.24           N  
ATOM   1195  CA  GLU   162      24.576  -2.677 -16.487  1.00 58.11           C  
ATOM   1196  C   GLU   162      23.718  -1.408 -16.454  1.00 57.49           C  
ATOM   1197  O   GLU   162      23.480  -0.797 -17.494  1.00 59.56           O  
ATOM   1198  CB  GLU   162      23.697  -3.889 -16.727  1.00 57.98           C  
ATOM   1199  CG  GLU   162      24.499  -5.191 -16.812  1.00 62.57           C  
ATOM   1200  CD  GLU   162      23.610  -6.411 -16.803  1.00 64.20           C  
ATOM   1201  OE1 GLU   162      22.363  -6.256 -16.710  1.00 79.58           O  
ATOM   1202  OE2 GLU   162      24.159  -7.536 -16.893  1.00 79.67           O  
ATOM   1203  N   SER   163      23.227  -1.024 -15.281  1.00 55.55           N  
ATOM   1204  CA  SER   163      22.434   0.196 -15.163  1.00 53.26           C  
ATOM   1205  C   SER   163      22.339   0.681 -13.745  1.00 53.60           C  
ATOM   1206  O   SER   163      22.535  -0.078 -12.796  1.00 51.06           O  
ATOM   1207  CB  SER   163      21.015  -0.012 -15.689  1.00 54.07           C  
ATOM   1208  OG  SER   163      20.234  -0.788 -14.798  1.00 55.86           O  
ATOM   1209  N   VAL   164      22.066   1.972 -13.619  1.00 53.90           N  
ATOM   1210  CA  VAL   164      21.791   2.593 -12.351  1.00 52.14           C  
ATOM   1211  C   VAL   164      20.548   3.461 -12.555  1.00 53.15           C  
ATOM   1212  O   VAL   164      20.476   4.212 -13.504  1.00 53.64           O  
ATOM   1213  CB  VAL   164      22.943   3.463 -11.847  1.00 53.97           C  
ATOM   1214  CG1 VAL   164      22.580   4.024 -10.475  1.00 47.02           C  
ATOM   1215  CG2 VAL   164      24.252   2.669 -11.801  1.00 49.17           C  
ATOM   1216  N   LYS   165      19.550   3.286 -11.700  1.00 50.54           N  
ATOM   1217  CA  LYS   165      18.361   4.096 -11.694  1.00 50.85           C  
ATOM   1218  C   LYS   165      18.305   4.638 -10.285  1.00 49.44           C  
ATOM   1219  O   LYS   165      18.298   3.869  -9.361  1.00 51.81           O  
ATOM   1220  CB  LYS   165      17.078   3.267 -11.907  1.00 48.82           C  
ATOM   1221  CG  LYS   165      16.852   2.702 -13.298  1.00 58.14           C  
ATOM   1222  CD  LYS   165      15.757   1.614 -13.278  1.00 56.98           C  
ATOM   1223  CE  LYS   165      15.609   0.870 -14.656  1.00 62.75           C  
ATOM   1224  N   GLY   166      18.215   5.940 -10.096  1.00 50.52           N  
ATOM   1225  CA  GLY   166      18.076   6.433  -8.737  1.00 52.09           C  
ATOM   1226  C   GLY   166      17.413   7.776  -8.608  1.00 50.03           C  
ATOM   1227  O   GLY   166      16.976   8.384  -9.574  1.00 50.54           O  
ATOM   1228  N   ILE   167      17.360   8.196  -7.363  1.00 50.68           N  
ATOM   1229  CA  ILE   167      16.806   9.440  -6.913  1.00 48.61           C  
ATOM   1230  C   ILE   167      18.001  10.209  -6.380  1.00 47.71           C  
ATOM   1231  O   ILE   167      18.515   9.831  -5.339  1.00 48.18           O  
ATOM   1232  CB  ILE   167      15.807   9.155  -5.766  1.00 48.07           C  
ATOM   1233  CG1 ILE   167      14.529   8.498  -6.338  1.00 50.59           C  
ATOM   1234  CG2 ILE   167      15.538  10.450  -4.952  1.00 43.73           C  
ATOM   1235  CD1 ILE   167      13.550   8.006  -5.275  1.00 50.03           C  
ATOM   1236  N   PHE   168      18.457  11.255  -7.076  1.00 49.17           N  
ATOM   1237  CA  PHE   168      19.643  11.994  -6.629  1.00 53.28           C  
ATOM   1238  C   PHE   168      19.449  13.446  -6.169  1.00 53.86           C  
ATOM   1239  O   PHE   168      20.428  14.171  -5.955  1.00 56.61           O  
ATOM   1240  CB  PHE   168      20.742  11.946  -7.665  1.00 55.25           C  
ATOM   1241  CG  PHE   168      21.126  10.555  -8.061  1.00 60.38           C  
ATOM   1242  CD1 PHE   168      21.444   9.618  -7.095  1.00 55.13           C  
ATOM   1243  CD2 PHE   168      21.242  10.209  -9.403  1.00 64.34           C  
ATOM   1244  CE1 PHE   168      21.818   8.343  -7.445  1.00 62.51           C  
ATOM   1245  CE2 PHE   168      21.631   8.925  -9.766  1.00 65.66           C  
ATOM   1246  CZ  PHE   168      21.889   7.986  -8.783  1.00 61.09           C  
ATOM   1247  N   ASN   169      18.208  13.835  -5.936  1.00 50.08           N  
ATOM   1248  CA  ASN   169      17.913  15.167  -5.468  1.00 49.52           C  
ATOM   1249  C   ASN   169      16.835  15.097  -4.392  1.00 49.88           C  
ATOM   1250  O   ASN   169      15.668  14.786  -4.680  1.00 47.54           O  
ATOM   1251  CB  ASN   169      17.444  16.047  -6.615  1.00 50.62           C  
ATOM   1252  CG  ASN   169      17.304  17.487  -6.203  1.00 56.69           C  
ATOM   1253  OD1 ASN   169      16.187  17.970  -5.928  1.00 59.40           O  
ATOM   1254  ND2 ASN   169      18.438  18.169  -6.081  1.00 49.38           N  
ATOM   1255  N   GLY   170      17.250  15.344  -3.149  1.00 49.57           N  
ATOM   1256  CA  GLY   170      16.328  15.345  -2.010  1.00 48.89           C  
ATOM   1257  C   GLY   170      15.186  16.344  -2.083  1.00 50.94           C  
ATOM   1258  O   GLY   170      14.064  16.056  -1.634  1.00 54.52           O  
ATOM   1259  N   THR   171      15.461  17.532  -2.608  1.00 51.55           N  
ATOM   1260  CA  THR   171      14.452  18.594  -2.699  1.00 51.75           C  
ATOM   1261  C   THR   171      13.273  18.219  -3.600  1.00 48.23           C  
ATOM   1262  O   THR   171      12.120  18.396  -3.208  1.00 51.94           O  
ATOM   1263  CB  THR   171      15.096  19.923  -3.121  1.00 51.47           C  
ATOM   1264  OG1 THR   171      16.043  20.287  -2.117  1.00 54.73           O  
ATOM   1265  CG2 THR   171      14.038  21.044  -3.258  1.00 49.75           C  
ATOM   1266  N   CYS   172      13.551  17.705  -4.788  1.00 47.31           N  
ATOM   1267  CA  CYS   172      12.497  17.214  -5.672  1.00 50.28           C  
ATOM   1268  C   CYS   172      11.789  16.024  -5.055  1.00 50.89           C  
ATOM   1269  O   CYS   172      10.593  15.883  -5.205  1.00 52.21           O  
ATOM   1270  CB  CYS   172      13.058  16.770  -7.016  1.00 51.40           C  
ATOM   1271  SG  CYS   172      13.781  18.090  -7.952  1.00 62.23           S  
ATOM   1272  N   ASN   173      12.520  15.163  -4.345  1.00 51.55           N  
ATOM   1273  CA  ASN   173      11.874  14.014  -3.749  1.00 50.79           C  
ATOM   1274  C   ASN   173      10.907  14.494  -2.683  1.00 49.78           C  
ATOM   1275  O   ASN   173       9.780  14.000  -2.573  1.00 51.45           O  
ATOM   1276  CB  ASN   173      12.862  12.977  -3.160  1.00 48.42           C  
ATOM   1277  CG  ASN   173      12.263  11.591  -3.178  1.00 49.97           C  
ATOM   1278  OD1 ASN   173      12.061  11.052  -4.259  1.00 50.87           O  
ATOM   1279  ND2 ASN   173      11.912  11.032  -2.010  1.00 48.67           N  
ATOM   1280  N   TYR   174      11.345  15.473  -1.910  1.00 48.66           N  
ATOM   1281  CA  TYR   174      10.493  16.058  -0.873  1.00 49.81           C  
ATOM   1282  C   TYR   174       9.258  16.724  -1.488  1.00 48.59           C  
ATOM   1283  O   TYR   174       8.148  16.559  -1.001  1.00 48.45           O  
ATOM   1284  CB  TYR   174      11.280  17.093  -0.040  1.00 50.52           C  
ATOM   1285  CG  TYR   174      10.400  17.838   0.950  1.00 54.37           C  
ATOM   1286  CD1 TYR   174      10.127  17.311   2.196  1.00 49.94           C  
ATOM   1287  CD2 TYR   174       9.821  19.058   0.610  1.00 54.64           C  
ATOM   1288  CE1 TYR   174       9.282  17.977   3.083  1.00 58.48           C  
ATOM   1289  CE2 TYR   174       9.005  19.735   1.476  1.00 51.60           C  
ATOM   1290  CZ  TYR   174       8.726  19.194   2.719  1.00 57.19           C  
ATOM   1291  OH  TYR   174       7.888  19.867   3.593  1.00 55.85           O  
ATOM   1292  N   ILE   175       9.463  17.510  -2.541  1.00 50.25           N  
ATOM   1293  CA  ILE   175       8.360  18.244  -3.157  1.00 51.12           C  
ATOM   1294  C   ILE   175       7.298  17.276  -3.693  1.00 49.03           C  
ATOM   1295  O   ILE   175       6.111  17.472  -3.486  1.00 47.68           O  
ATOM   1296  CB  ILE   175       8.845  19.265  -4.238  1.00 50.51           C  
ATOM   1297  CG1 ILE   175       9.587  20.428  -3.556  1.00 56.75           C  
ATOM   1298  CG2 ILE   175       7.646  19.785  -5.041  1.00 50.40           C  
ATOM   1299  CD1 ILE   175      10.293  21.433  -4.496  1.00 52.24           C  
ATOM   1300  N   LEU   176       7.746  16.224  -4.356  1.00 50.24           N  
ATOM   1301  CA  LEU   176       6.846  15.197  -4.892  1.00 48.11           C  
ATOM   1302  C   LEU   176       6.146  14.396  -3.775  1.00 47.17           C  
ATOM   1303  O   LEU   176       4.947  14.184  -3.846  1.00 47.47           O  
ATOM   1304  CB  LEU   176       7.610  14.299  -5.857  1.00 46.39           C  
ATOM   1305  CG  LEU   176       8.149  14.968  -7.122  1.00 50.90           C  
ATOM   1306  CD1 LEU   176       9.070  14.008  -7.864  1.00 47.93           C  
ATOM   1307  CD2 LEU   176       6.983  15.471  -8.048  1.00 40.04           C  
ATOM   1308  N   SER   177       6.876  13.961  -2.747  1.00 48.51           N  
ATOM   1309  CA  SER   177       6.260  13.258  -1.586  1.00 50.08           C  
ATOM   1310  C   SER   177       5.239  14.115  -0.880  1.00 47.81           C  
ATOM   1311  O   SER   177       4.202  13.645  -0.454  1.00 48.79           O  
ATOM   1312  CB  SER   177       7.300  12.921  -0.525  1.00 50.57           C  
ATOM   1313  OG  SER   177       8.221  12.006  -1.027  1.00 61.77           O  
ATOM   1314  N   ARG   178       5.583  15.380  -0.719  1.00 48.42           N  
ATOM   1315  CA  ARG   178       4.713  16.333  -0.051  1.00 47.43           C  
ATOM   1316  C   ARG   178       3.465  16.603  -0.904  1.00 46.52           C  
ATOM   1317  O   ARG   178       2.338  16.681  -0.393  1.00 45.49           O  
ATOM   1318  CB  ARG   178       5.493  17.621   0.221  1.00 47.04           C  
ATOM   1319  CG  ARG   178       4.848  18.508   1.208  1.00 56.97           C  
ATOM   1320  CD  ARG   178       5.183  18.038   2.594  1.00 68.09           C  
ATOM   1321  NE  ARG   178       4.508  18.837   3.606  1.00 68.53           N  
ATOM   1322  CZ  ARG   178       3.527  18.390   4.384  1.00 75.35           C  
ATOM   1323  NH1 ARG   178       3.128  17.121   4.313  1.00 77.00           N  
ATOM   1324  NH2 ARG   178       2.968  19.210   5.274  1.00 71.97           N  
ATOM   1325  N   MET   179       3.658  16.766  -2.208  1.00 47.62           N  
ATOM   1326  CA  MET   179       2.519  16.939  -3.122  1.00 48.36           C  
ATOM   1327  C   MET   179       1.618  15.713  -3.112  1.00 48.14           C  
ATOM   1328  O   MET   179       0.399  15.833  -3.217  1.00 51.18           O  
ATOM   1329  CB  MET   179       3.000  17.205  -4.542  1.00 45.91           C  
ATOM   1330  CG  MET   179       1.840  17.597  -5.483  1.00 56.49           C  
ATOM   1331  SD  MET   179       2.441  18.167  -7.258  0.75 54.81          SE  
ATOM   1332  CE  MET   179       3.997  19.219  -6.628  1.00 45.84           C  
ATOM   1333  N   GLU   180       2.210  14.528  -3.009  1.00 50.05           N  
ATOM   1334  CA  GLU   180       1.427  13.294  -2.941  1.00 51.64           C  
ATOM   1335  C   GLU   180       0.542  13.294  -1.715  1.00 49.64           C  
ATOM   1336  O   GLU   180      -0.611  12.941  -1.776  1.00 52.27           O  
ATOM   1337  CB  GLU   180       2.357  12.069  -2.866  1.00 51.90           C  
ATOM   1338  CG  GLU   180       1.658  10.718  -2.586  1.00 55.71           C  
ATOM   1339  CD  GLU   180       0.995  10.086  -3.817  1.00 66.02           C  
ATOM   1340  OE1 GLU   180      -0.195  10.339  -4.091  1.00 63.96           O  
ATOM   1341  OE2 GLU   180       1.665   9.268  -4.479  1.00 73.52           O  
ATOM   1342  N   GLU   181       1.101  13.697  -0.590  1.00 51.44           N  
ATOM   1343  CA  GLU   181       0.395  13.645   0.684  1.00 52.99           C  
ATOM   1344  C   GLU   181      -0.657  14.751   0.851  1.00 50.86           C  
ATOM   1345  O   GLU   181      -1.810  14.491   1.236  1.00 51.34           O  
ATOM   1346  CB  GLU   181       1.436  13.741   1.807  1.00 52.57           C  
ATOM   1347  CG  GLU   181       0.877  13.620   3.202  1.00 57.00           C  
ATOM   1348  CD  GLU   181       1.872  14.069   4.266  1.00 61.56           C  
ATOM   1349  OE1 GLU   181       3.071  14.272   3.921  1.00 76.08           O  
ATOM   1350  OE2 GLU   181       1.440  14.230   5.443  1.00 74.24           O  
ATOM   1351  N   GLU   182      -0.250  15.985   0.578  1.00 48.88           N  
ATOM   1352  CA  GLU   182      -1.125  17.139   0.748  1.00 47.99           C  
ATOM   1353  C   GLU   182      -2.036  17.408  -0.428  1.00 45.65           C  
ATOM   1354  O   GLU   182      -3.071  17.995  -0.243  1.00 43.85           O  
ATOM   1355  CB  GLU   182      -0.299  18.401   0.986  1.00 48.49           C  
ATOM   1356  CG  GLU   182       0.459  18.450   2.284  1.00 49.55           C  
ATOM   1357  CD  GLU   182       1.087  19.809   2.486  1.00 49.39           C  
ATOM   1358  OE1 GLU   182       2.133  20.060   1.866  1.00 57.73           O  
ATOM   1359  OE2 GLU   182       0.523  20.637   3.252  1.00 63.87           O  
ATOM   1360  N   ARG   183      -1.627  17.016  -1.635  1.00 47.50           N  
ATOM   1361  CA  ARG   183      -2.409  17.260  -2.848  1.00 46.60           C  
ATOM   1362  C   ARG   183      -2.627  18.761  -3.060  1.00 46.49           C  
ATOM   1363  O   ARG   183      -3.739  19.197  -3.345  1.00 45.39           O  
ATOM   1364  CB  ARG   183      -3.746  16.526  -2.785  1.00 46.84           C  
ATOM   1365  CG  ARG   183      -3.667  14.996  -2.917  1.00 50.98           C  
ATOM   1366  CD  ARG   183      -3.969  14.539  -4.367  1.00 60.13           C  
ATOM   1367  NE  ARG   183      -4.200  13.094  -4.504  1.00 49.76           N  
ATOM   1368  CZ  ARG   183      -3.221  12.221  -4.391  1.00 47.02           C  
ATOM   1369  NH1 ARG   183      -2.019  12.672  -4.106  1.00 42.53           N  
ATOM   1370  NH2 ARG   183      -3.439  10.925  -4.523  1.00 48.32           N  
ATOM   1371  N   LEU   184      -1.560  19.549  -2.937  1.00 46.90           N  
ATOM   1372  CA  LEU   184      -1.668  20.996  -3.130  1.00 48.03           C  
ATOM   1373  C   LEU   184      -0.774  21.392  -4.292  1.00 47.57           C  
ATOM   1374  O   LEU   184       0.155  20.676  -4.603  1.00 46.62           O  
ATOM   1375  CB  LEU   184      -1.320  21.766  -1.847  1.00 48.11           C  
ATOM   1376  CG  LEU   184      -2.272  21.591  -0.657  1.00 45.33           C  
ATOM   1377  CD1 LEU   184      -1.624  22.116   0.616  1.00 46.80           C  
ATOM   1378  CD2 LEU   184      -3.630  22.262  -0.909  1.00 42.37           C  
ATOM   1379  N   PRO   185      -1.075  22.524  -4.956  1.00 49.82           N  
ATOM   1380  CA  PRO   185      -0.326  22.941  -6.135  1.00 49.73           C  
ATOM   1381  C   PRO   185       1.167  23.068  -5.930  1.00 50.62           C  
ATOM   1382  O   PRO   185       1.633  23.337  -4.819  1.00 52.62           O  
ATOM   1383  CB  PRO   185      -0.927  24.310  -6.469  1.00 49.87           C  
ATOM   1384  CG  PRO   185      -2.269  24.269  -5.920  1.00 49.71           C  
ATOM   1385  CD  PRO   185      -2.161  23.473  -4.657  1.00 49.76           C  
ATOM   1386  N   TYR   186       1.906  22.900  -7.019  1.00 49.39           N  
ATOM   1387  CA  TYR   186       3.342  23.010  -6.975  1.00 49.71           C  
ATOM   1388  C   TYR   186       3.824  24.304  -6.315  1.00 48.74           C  
ATOM   1389  O   TYR   186       4.752  24.261  -5.496  1.00 49.05           O  
ATOM   1390  CB  TYR   186       3.951  22.845  -8.398  1.00 50.69           C  
ATOM   1391  CG  TYR   186       5.397  23.260  -8.475  1.00 51.42           C  
ATOM   1392  CD1 TYR   186       6.405  22.412  -8.061  1.00 51.78           C  
ATOM   1393  CD2 TYR   186       5.748  24.536  -8.926  1.00 54.64           C  
ATOM   1394  CE1 TYR   186       7.726  22.810  -8.111  1.00 56.91           C  
ATOM   1395  CE2 TYR   186       7.056  24.945  -8.961  1.00 49.56           C  
ATOM   1396  CZ  TYR   186       8.039  24.084  -8.555  1.00 52.76           C  
ATOM   1397  OH  TYR   186       9.349  24.487  -8.606  1.00 57.36           O  
ATOM   1398  N   GLU   187       3.229  25.443  -6.692  1.00 49.83           N  
ATOM   1399  CA  GLU   187       3.615  26.773  -6.155  1.00 50.15           C  
ATOM   1400  C   GLU   187       3.642  26.798  -4.611  1.00 50.21           C  
ATOM   1401  O   GLU   187       4.594  27.299  -4.002  1.00 50.99           O  
ATOM   1402  CB  GLU   187       2.692  27.871  -6.712  1.00 49.73           C  
ATOM   1403  N   HIS   188       2.601  26.220  -4.009  1.00 50.31           N  
ATOM   1404  CA  HIS   188       2.453  26.097  -2.565  1.00 50.29           C  
ATOM   1405  C   HIS   188       3.445  25.125  -1.913  1.00 50.89           C  
ATOM   1406  O   HIS   188       4.006  25.447  -0.865  1.00 49.57           O  
ATOM   1407  CB  HIS   188       1.049  25.611  -2.243  1.00 51.54           C  
ATOM   1408  CG  HIS   188       0.729  25.625  -0.782  1.00 57.63           C  
ATOM   1409  ND1 HIS   188       1.225  24.686   0.098  1.00 61.10           N  
ATOM   1410  CD2 HIS   188      -0.056  26.450  -0.049  1.00 58.91           C  
ATOM   1411  CE1 HIS   188       0.774  24.943   1.312  1.00 57.63           C  
ATOM   1412  NE2 HIS   188      -0.012  26.003   1.250  1.00 60.26           N  
ATOM   1413  N   ILE   189       3.653  23.941  -2.506  1.00 50.32           N  
ATOM   1414  CA  ILE   189       4.562  22.950  -1.921  1.00 50.34           C  
ATOM   1415  C   ILE   189       5.993  23.477  -2.014  1.00 53.25           C  
ATOM   1416  O   ILE   189       6.816  23.219  -1.131  1.00 54.26           O  
ATOM   1417  CB  ILE   189       4.474  21.550  -2.589  1.00 50.20           C  
ATOM   1418  CG1 ILE   189       3.048  20.984  -2.564  1.00 53.02           C  
ATOM   1419  CG2 ILE   189       5.414  20.583  -1.911  1.00 48.21           C  
ATOM   1420  CD1 ILE   189       2.486  20.718  -1.189  1.00 50.90           C  
ATOM   1421  N   LEU   190       6.301  24.195  -3.094  1.00 54.47           N  
ATOM   1422  CA  LEU   190       7.611  24.836  -3.241  1.00 54.56           C  
ATOM   1423  C   LEU   190       7.853  25.850  -2.119  1.00 56.21           C  
ATOM   1424  O   LEU   190       8.951  25.913  -1.591  1.00 55.77           O  
ATOM   1425  CB  LEU   190       7.738  25.529  -4.594  1.00 53.43           C  
ATOM   1426  CG  LEU   190       8.984  26.378  -4.847  1.00 53.95           C  
ATOM   1427  CD1 LEU   190      10.191  25.499  -4.858  1.00 54.46           C  
ATOM   1428  CD2 LEU   190       8.878  27.181  -6.145  1.00 53.20           C  
ATOM   1429  N   LYS   191       6.836  26.643  -1.764  1.00 59.35           N  
ATOM   1430  CA  LYS   191       6.970  27.625  -0.664  1.00 59.85           C  
ATOM   1431  C   LYS   191       7.256  26.942   0.675  1.00 62.71           C  
ATOM   1432  O   LYS   191       8.009  27.478   1.487  1.00 65.04           O  
ATOM   1433  CB  LYS   191       5.760  28.544  -0.565  1.00 59.39           C  
ATOM   1434  CG  LYS   191       5.594  29.462  -1.764  1.00 62.81           C  
ATOM   1435  N   GLU   192       6.667  25.766   0.901  1.00 64.24           N  
ATOM   1436  CA  GLU   192       6.983  24.973   2.093  1.00 65.95           C  
ATOM   1437  C   GLU   192       8.445  24.528   2.004  1.00 65.32           C  
ATOM   1438  O   GLU   192       9.215  24.662   2.951  1.00 66.59           O  
ATOM   1439  CB  GLU   192       6.114  23.722   2.189  1.00 66.21           C  
ATOM   1440  CG  GLU   192       4.627  23.967   2.325  1.00 68.09           C  
ATOM   1441  CD  GLU   192       3.848  22.657   2.393  1.00 68.34           C  
ATOM   1442  OE1 GLU   192       4.186  21.795   3.237  1.00 68.68           O  
ATOM   1443  OE2 GLU   192       2.892  22.493   1.604  1.00 72.99           O  
ATOM   1444  N   ALA   193       8.822  23.990   0.850  1.00 64.18           N  
ATOM   1445  CA  ALA   193      10.191  23.554   0.631  1.00 64.49           C  
ATOM   1446  C   ALA   193      11.188  24.699   0.926  1.00 65.36           C  
ATOM   1447  O   ALA   193      12.274  24.479   1.480  1.00 66.60           O  
ATOM   1448  CB  ALA   193      10.356  23.036  -0.788  1.00 63.88           C  
ATOM   1449  N   GLN   194      10.806  25.913   0.556  1.00 64.64           N  
ATOM   1450  CA  GLN   194      11.630  27.088   0.789  1.00 64.41           C  
ATOM   1451  C   GLN   194      11.662  27.458   2.279  1.00 65.12           C  
ATOM   1452  O   GLN   194      12.744  27.704   2.823  1.00 61.97           O  
ATOM   1453  CB  GLN   194      11.180  28.244  -0.123  1.00 63.16           C  
ATOM   1454  CG  GLN   194      11.572  27.983  -1.600  1.00 61.72           C  
ATOM   1455  CD  GLN   194      10.958  28.958  -2.585  1.00 58.96           C  
ATOM   1456  OE1 GLN   194       9.811  29.344  -2.449  1.00 49.46           O  
ATOM   1457  NE2 GLN   194      11.717  29.329  -3.605  1.00 50.16           N  
ATOM   1458  N   GLU   195      10.498  27.457   2.935  1.00 67.33           N  
ATOM   1459  CA  GLU   195      10.419  27.725   4.380  1.00 68.56           C  
ATOM   1460  C   GLU   195      11.315  26.735   5.150  1.00 70.71           C  
ATOM   1461  O   GLU   195      12.058  27.136   6.042  1.00 73.46           O  
ATOM   1462  CB  GLU   195       8.969  27.668   4.888  1.00 67.50           C  
ATOM   1463  N   LEU   196      11.272  25.456   4.781  1.00 72.16           N  
ATOM   1464  CA  LEU   196      12.104  24.409   5.424  1.00 71.93           C  
ATOM   1465  C   LEU   196      13.613  24.514   5.119  1.00 72.29           C  
ATOM   1466  O   LEU   196      14.428  23.867   5.782  1.00 72.44           O  
ATOM   1467  CB  LEU   196      11.602  23.001   5.032  1.00 72.75           C  
ATOM   1468  CG  LEU   196      10.386  22.463   5.785  1.00 73.55           C  
ATOM   1469  CD1 LEU   196      10.794  22.218   7.234  1.00 71.91           C  
ATOM   1470  CD2 LEU   196       9.164  23.396   5.711  1.00 80.49           C  
ATOM   1471  N   GLY   197      13.974  25.299   4.103  1.00 71.91           N  
ATOM   1472  CA  GLY   197      15.365  25.504   3.721  1.00 69.37           C  
ATOM   1473  C   GLY   197      15.841  24.542   2.662  1.00 71.28           C  
ATOM   1474  O   GLY   197      17.023  24.568   2.284  1.00 71.05           O  
ATOM   1475  N   TYR   198      14.943  23.690   2.158  1.00 71.91           N  
ATOM   1476  CA  TYR   198      15.350  22.701   1.151  1.00 70.29           C  
ATOM   1477  C   TYR   198      15.620  23.320  -0.211  1.00 68.90           C  
ATOM   1478  O   TYR   198      16.493  22.848  -0.935  1.00 69.01           O  
ATOM   1479  CB  TYR   198      14.334  21.569   1.003  1.00 70.32           C  
ATOM   1480  CG  TYR   198      14.013  20.843   2.282  1.00 71.40           C  
ATOM   1481  CD1 TYR   198      14.969  20.670   3.280  1.00 71.74           C  
ATOM   1482  CD2 TYR   198      12.770  20.255   2.460  1.00 70.09           C  
ATOM   1483  CE1 TYR   198      14.658  19.993   4.454  1.00 73.66           C  
ATOM   1484  CE2 TYR   198      12.463  19.571   3.610  1.00 69.46           C  
ATOM   1485  CZ  TYR   198      13.404  19.438   4.607  1.00 71.92           C  
ATOM   1486  OH  TYR   198      13.069  18.758   5.765  1.00 73.80           O  
ATOM   1487  N   ALA   199      14.862  24.357  -0.556  1.00 68.19           N  
ATOM   1488  CA  ALA   199      15.021  25.035  -1.829  1.00 66.85           C  
ATOM   1489  C   ALA   199      15.321  26.524  -1.634  1.00 66.32           C  
ATOM   1490  O   ALA   199      14.768  27.161  -0.738  1.00 64.86           O  
ATOM   1491  CB  ALA   199      13.753  24.841  -2.687  1.00 67.08           C  
ATOM   1492  N   GLU   200      16.197  27.053  -2.488  1.00 65.83           N  
ATOM   1493  CA  GLU   200      16.566  28.461  -2.496  1.00 67.83           C  
ATOM   1494  C   GLU   200      15.466  29.277  -3.185  1.00 68.19           C  
ATOM   1495  O   GLU   200      14.520  28.705  -3.757  1.00 65.69           O  
ATOM   1496  CB  GLU   200      17.908  28.669  -3.225  1.00 67.97           C  
ATOM   1497  CG  GLU   200      19.120  27.995  -2.549  1.00 72.33           C  
ATOM   1498  CD  GLU   200      20.349  27.924  -3.451  1.00 69.69           C  
ATOM   1499  N   ALA   201      15.607  30.610  -3.111  1.00 68.46           N  
ATOM   1500  CA  ALA   201      14.672  31.576  -3.717  1.00 68.54           C  
ATOM   1501  C   ALA   201      14.496  31.297  -5.200  1.00 68.47           C  
ATOM   1502  O   ALA   201      13.428  31.519  -5.758  1.00 68.13           O  
ATOM   1503  CB  ALA   201      15.165  33.006  -3.506  1.00 68.07           C  
ATOM   1504  N   ASP   202      15.586  30.866  -5.831  1.00 69.18           N  
ATOM   1505  CA  ASP   202      15.580  30.368  -7.202  1.00 68.04           C  
ATOM   1506  C   ASP   202      15.849  28.869  -7.019  1.00 64.63           C  
ATOM   1507  O   ASP   202      16.992  28.476  -6.817  1.00 62.25           O  
ATOM   1508  CB  ASP   202      16.676  31.025  -8.048  1.00 70.21           C  
ATOM   1509  CG  ASP   202      16.945  30.266  -9.352  1.00 79.05           C  
ATOM   1510  OD1 ASP   202      15.961  29.692  -9.892  1.00 78.98           O  
ATOM   1511  OD2 ASP   202      18.133  30.242  -9.813  1.00 76.93           O  
ATOM   1512  N   PRO   203      14.789  28.034  -7.056  1.00 63.72           N  
ATOM   1513  CA  PRO   203      14.898  26.580  -6.832  1.00 61.75           C  
ATOM   1514  C   PRO   203      15.229  25.740  -8.078  1.00 59.45           C  
ATOM   1515  O   PRO   203      15.237  24.521  -7.998  1.00 59.32           O  
ATOM   1516  CB  PRO   203      13.482  26.233  -6.353  1.00 61.07           C  
ATOM   1517  CG  PRO   203      12.622  27.105  -7.172  1.00 59.95           C  
ATOM   1518  CD  PRO   203      13.390  28.413  -7.351  1.00 63.64           C  
ATOM   1519  N   SER   204      15.447  26.412  -9.201  1.00 58.82           N  
ATOM   1520  CA  SER   204      15.723  25.858 -10.537  1.00 60.32           C  
ATOM   1521  C   SER   204      16.726  24.693 -10.641  1.00 58.74           C  
ATOM   1522  O   SER   204      16.479  23.682 -11.315  1.00 57.35           O  
ATOM   1523  CB  SER   204      16.203  27.042 -11.401  1.00 61.40           C  
ATOM   1524  OG  SER   204      16.597  26.650 -12.692  1.00 74.01           O  
ATOM   1525  N   TYR   205      17.871  24.859  -9.996  1.00 58.63           N  
ATOM   1526  CA  TYR   205      18.929  23.844  -9.958  1.00 58.51           C  
ATOM   1527  C   TYR   205      18.345  22.511  -9.489  1.00 56.16           C  
ATOM   1528  O   TYR   205      18.691  21.463 -10.007  1.00 52.02           O  
ATOM   1529  CB  TYR   205      20.009  24.334  -9.021  1.00 59.98           C  
ATOM   1530  CG  TYR   205      21.303  23.546  -8.918  1.00 66.63           C  
ATOM   1531  CD1 TYR   205      22.284  23.633  -9.926  1.00 58.78           C  
ATOM   1532  CD2 TYR   205      21.608  22.819  -7.744  1.00 69.11           C  
ATOM   1533  CE1 TYR   205      23.504  22.973  -9.798  1.00 64.53           C  
ATOM   1534  CE2 TYR   205      22.837  22.125  -7.610  1.00 68.87           C  
ATOM   1535  CZ  TYR   205      23.773  22.215  -8.639  1.00 71.51           C  
ATOM   1536  OH  TYR   205      24.970  21.573  -8.495  1.00 70.59           O  
ATOM   1537  N   ASP   206      17.409  22.570  -8.543  1.00 55.98           N  
ATOM   1538  CA  ASP   206      16.725  21.382  -8.071  1.00 54.69           C  
ATOM   1539  C   ASP   206      15.564  21.016  -8.983  1.00 54.42           C  
ATOM   1540  O   ASP   206      15.590  19.965  -9.606  1.00 54.38           O  
ATOM   1541  CB  ASP   206      16.173  21.563  -6.643  1.00 54.91           C  
ATOM   1542  CG  ASP   206      17.258  21.735  -5.592  1.00 55.86           C  
ATOM   1543  OD1 ASP   206      18.302  21.060  -5.674  1.00 61.04           O  
ATOM   1544  OD2 ASP   206      17.034  22.521  -4.645  1.00 64.32           O  
ATOM   1545  N   VAL   207      14.548  21.884  -9.040  1.00 52.94           N  
ATOM   1546  CA  VAL   207      13.286  21.567  -9.714  1.00 51.67           C  
ATOM   1547  C   VAL   207      13.301  21.354 -11.232  1.00 52.00           C  
ATOM   1548  O   VAL   207      12.367  20.748 -11.769  1.00 52.24           O  
ATOM   1549  CB  VAL   207      12.123  22.512  -9.272  1.00 52.21           C  
ATOM   1550  CG1 VAL   207      12.009  22.472  -7.741  1.00 45.97           C  
ATOM   1551  CG2 VAL   207      12.271  23.948  -9.823  1.00 47.72           C  
ATOM   1552  N   GLU   208      14.331  21.858 -11.911  1.00 52.85           N  
ATOM   1553  CA  GLU   208      14.482  21.642 -13.345  1.00 54.65           C  
ATOM   1554  C   GLU   208      15.363  20.399 -13.623  1.00 54.89           C  
ATOM   1555  O   GLU   208      15.709  20.113 -14.770  1.00 54.82           O  
ATOM   1556  CB  GLU   208      15.072  22.879 -14.037  1.00 52.72           C  
ATOM   1557  CG  GLU   208      14.282  24.159 -13.869  1.00 52.72           C  
ATOM   1558  CD  GLU   208      12.881  24.099 -14.478  1.00 53.88           C  
ATOM   1559  OE1 GLU   208      12.543  23.109 -15.164  1.00 50.07           O  
ATOM   1560  OE2 GLU   208      12.117  25.068 -14.280  1.00 57.93           O  
ATOM   1561  N   GLY   209      15.743  19.687 -12.565  1.00 56.82           N  
ATOM   1562  CA  GLY   209      16.528  18.452 -12.688  1.00 55.27           C  
ATOM   1563  C   GLY   209      18.003  18.604 -12.995  1.00 54.85           C  
ATOM   1564  O   GLY   209      18.652  17.625 -13.323  1.00 55.73           O  
ATOM   1565  N   ILE   210      18.542  19.821 -12.861  1.00 54.76           N  
ATOM   1566  CA  ILE   210      19.938  20.078 -13.186  1.00 54.36           C  
ATOM   1567  C   ILE   210      20.869  19.337 -12.215  1.00 53.25           C  
ATOM   1568  O   ILE   210      21.816  18.673 -12.622  1.00 52.64           O  
ATOM   1569  CB  ILE   210      20.291  21.605 -13.141  1.00 52.69           C  
ATOM   1570  CG1 ILE   210      19.380  22.462 -14.046  1.00 59.17           C  
ATOM   1571  CG2 ILE   210      21.751  21.828 -13.472  1.00 49.21           C  
ATOM   1572  CD1 ILE   210      19.444  22.148 -15.502  1.00 66.10           C  
ATOM   1573  N   ASP   211      20.618  19.479 -10.921  1.00 54.09           N  
ATOM   1574  CA  ASP   211      21.428  18.807  -9.892  1.00 51.97           C  
ATOM   1575  C   ASP   211      21.493  17.301 -10.113  1.00 49.67           C  
ATOM   1576  O   ASP   211      22.586  16.702 -10.113  1.00 51.24           O  
ATOM   1577  CB  ASP   211      20.846  19.123  -8.512  1.00 53.71           C  
ATOM   1578  CG  ASP   211      21.631  18.481  -7.370  1.00 55.47           C  
ATOM   1579  OD1 ASP   211      22.812  18.853  -7.180  1.00 55.59           O  
ATOM   1580  OD2 ASP   211      21.033  17.648  -6.633  1.00 58.46           O  
ATOM   1581  N   ALA   212      20.327  16.679 -10.309  1.00 48.11           N  
ATOM   1582  CA  ALA   212      20.238  15.237 -10.529  1.00 45.99           C  
ATOM   1583  C   ALA   212      21.009  14.799 -11.795  1.00 46.22           C  
ATOM   1584  O   ALA   212      21.658  13.743 -11.797  1.00 48.01           O  
ATOM   1585  CB  ALA   212      18.789  14.778 -10.612  1.00 43.79           C  
ATOM   1586  N   ALA   213      20.930  15.613 -12.836  1.00 43.54           N  
ATOM   1587  CA  ALA   213      21.603  15.326 -14.133  1.00 45.45           C  
ATOM   1588  C   ALA   213      23.138  15.428 -14.047  1.00 45.51           C  
ATOM   1589  O   ALA   213      23.840  14.670 -14.675  1.00 48.79           O  
ATOM   1590  CB  ALA   213      21.073  16.230 -15.185  1.00 42.66           C  
ATOM   1591  N   LEU   214      23.642  16.435 -13.335  1.00 46.63           N  
ATOM   1592  CA  LEU   214      25.075  16.566 -13.043  1.00 45.43           C  
ATOM   1593  C   LEU   214      25.588  15.300 -12.366  1.00 46.14           C  
ATOM   1594  O   LEU   214      26.591  14.722 -12.778  1.00 49.16           O  
ATOM   1595  CB  LEU   214      25.324  17.796 -12.168  1.00 48.56           C  
ATOM   1596  CG  LEU   214      25.104  19.180 -12.854  1.00 53.32           C  
ATOM   1597  CD1 LEU   214      25.037  20.368 -11.881  1.00 43.38           C  
ATOM   1598  CD2 LEU   214      26.140  19.444 -13.913  1.00 50.20           C  
ATOM   1599  N   LYS   215      24.876  14.864 -11.331  1.00 46.82           N  
ATOM   1600  CA  LYS   215      25.162  13.647 -10.580  1.00 45.75           C  
ATOM   1601  C   LYS   215      25.074  12.405 -11.442  1.00 47.88           C  
ATOM   1602  O   LYS   215      25.912  11.521 -11.321  1.00 49.56           O  
ATOM   1603  CB  LYS   215      24.183  13.547  -9.403  1.00 45.01           C  
ATOM   1604  CG  LYS   215      24.509  14.589  -8.295  1.00 50.10           C  
ATOM   1605  CD  LYS   215      23.415  14.675  -7.203  1.00 47.84           C  
ATOM   1606  CE  LYS   215      23.750  15.716  -6.145  1.00 48.71           C  
ATOM   1607  NZ  LYS   215      22.596  15.971  -5.201  1.00 46.57           N  
ATOM   1608  N   LEU   216      24.074  12.350 -12.327  1.00 47.48           N  
ATOM   1609  CA  LEU   216      23.907  11.245 -13.264  1.00 45.00           C  
ATOM   1610  C   LEU   216      25.121  11.167 -14.163  1.00 45.39           C  
ATOM   1611  O   LEU   216      25.597  10.072 -14.432  1.00 45.92           O  
ATOM   1612  CB  LEU   216      22.619  11.407 -14.114  1.00 43.78           C  
ATOM   1613  CG  LEU   216      22.337  10.265 -15.126  1.00 49.21           C  
ATOM   1614  CD1 LEU   216      22.286   8.883 -14.438  1.00 48.68           C  
ATOM   1615  CD2 LEU   216      21.096  10.551 -15.976  1.00 46.60           C  
ATOM   1616  N   VAL   217      25.642  12.313 -14.619  1.00 45.94           N  
ATOM   1617  CA  VAL   217      26.867  12.291 -15.450  1.00 47.16           C  
ATOM   1618  C   VAL   217      28.091  11.698 -14.696  1.00 47.12           C  
ATOM   1619  O   VAL   217      28.905  10.941 -15.254  1.00 45.73           O  
ATOM   1620  CB  VAL   217      27.214  13.691 -16.050  1.00 50.11           C  
ATOM   1621  CG1 VAL   217      28.552  13.659 -16.786  1.00 47.66           C  
ATOM   1622  CG2 VAL   217      26.103  14.167 -17.012  1.00 49.14           C  
ATOM   1623  N   ILE   218      28.220  12.056 -13.433  1.00 47.15           N  
ATOM   1624  CA  ILE   218      29.319  11.568 -12.622  1.00 48.08           C  
ATOM   1625  C   ILE   218      29.211  10.046 -12.488  1.00 47.79           C  
ATOM   1626  O   ILE   218      30.167   9.343 -12.742  1.00 48.88           O  
ATOM   1627  CB  ILE   218      29.338  12.277 -11.269  1.00 45.60           C  
ATOM   1628  CG1 ILE   218      29.710  13.744 -11.498  1.00 49.59           C  
ATOM   1629  CG2 ILE   218      30.280  11.563 -10.283  1.00 49.52           C  
ATOM   1630  CD1 ILE   218      29.738  14.603 -10.283  1.00 46.99           C  
ATOM   1631  N   ILE   219      28.019   9.559 -12.152  1.00 47.86           N  
ATOM   1632  CA  ILE   219      27.752   8.136 -12.022  1.00 47.51           C  
ATOM   1633  C   ILE   219      27.966   7.329 -13.304  1.00 48.65           C  
ATOM   1634  O   ILE   219      28.525   6.247 -13.254  1.00 46.75           O  
ATOM   1635  CB  ILE   219      26.325   7.884 -11.565  1.00 47.39           C  
ATOM   1636  CG1 ILE   219      26.167   8.369 -10.142  1.00 54.24           C  
ATOM   1637  CG2 ILE   219      26.008   6.405 -11.579  1.00 46.64           C  
ATOM   1638  CD1 ILE   219      24.762   8.300  -9.693  1.00 67.32           C  
ATOM   1639  N   ALA   220      27.448   7.840 -14.420  1.00 49.50           N  
ATOM   1640  CA  ALA   220      27.589   7.210 -15.733  1.00 47.31           C  
ATOM   1641  C   ALA   220      29.053   6.992 -15.974  1.00 46.34           C  
ATOM   1642  O   ALA   220      29.476   5.900 -16.280  1.00 48.33           O  
ATOM   1643  CB  ALA   220      26.996   8.113 -16.830  1.00 46.80           C  
ATOM   1644  N   ASN   221      29.841   8.045 -15.835  1.00 49.27           N  
ATOM   1645  CA  ASN   221      31.275   7.937 -16.036  1.00 49.43           C  
ATOM   1646  C   ASN   221      31.992   6.989 -15.073  1.00 48.47           C  
ATOM   1647  O   ASN   221      32.946   6.296 -15.464  1.00 48.69           O  
ATOM   1648  CB  ASN   221      31.919   9.332 -15.988  1.00 52.71           C  
ATOM   1649  CG  ASN   221      31.734  10.109 -17.297  1.00 54.77           C  
ATOM   1650  OD1 ASN   221      32.409   9.834 -18.299  1.00 55.54           O  
ATOM   1651  ND2 ASN   221      30.865  11.117 -17.269  1.00 51.91           N  
ATOM   1652  N   THR   222      31.556   6.979 -13.818  1.00 49.74           N  
ATOM   1653  CA  THR   222      32.152   6.126 -12.781  1.00 48.37           C  
ATOM   1654  C   THR   222      31.970   4.642 -13.142  1.00 47.02           C  
ATOM   1655  O   THR   222      32.849   3.842 -12.910  1.00 50.70           O  
ATOM   1656  CB  THR   222      31.548   6.442 -11.365  1.00 49.83           C  
ATOM   1657  OG1 THR   222      31.871   7.791 -10.976  1.00 47.96           O  
ATOM   1658  CG2 THR   222      32.084   5.501 -10.322  1.00 47.19           C  
ATOM   1659  N   ILE   223      30.841   4.296 -13.743  1.00 48.55           N  
ATOM   1660  CA  ILE   223      30.549   2.926 -14.121  1.00 48.58           C  
ATOM   1661  C   ILE   223      31.020   2.587 -15.542  1.00 49.45           C  
ATOM   1662  O   ILE   223      30.683   1.518 -16.068  1.00 50.54           O  
ATOM   1663  CB  ILE   223      29.035   2.536 -13.963  1.00 49.21           C  
ATOM   1664  CG1 ILE   223      28.150   3.202 -15.036  1.00 53.85           C  
ATOM   1665  CG2 ILE   223      28.507   2.838 -12.521  1.00 42.11           C  
ATOM   1666  CD1 ILE   223      26.711   2.618 -15.127  1.00 44.95           C  
ATOM   1667  N   GLY   224      31.784   3.468 -16.171  1.00 48.78           N  
ATOM   1668  CA  GLY   224      32.353   3.156 -17.506  1.00 47.84           C  
ATOM   1669  C   GLY   224      31.582   3.624 -18.721  1.00 49.39           C  
ATOM   1670  O   GLY   224      31.932   3.253 -19.834  1.00 50.20           O  
ATOM   1671  N   VAL   225      30.521   4.409 -18.523  1.00 50.37           N  
ATOM   1672  CA  VAL   225      29.749   4.972 -19.631  1.00 51.28           C  
ATOM   1673  C   VAL   225      30.218   6.425 -19.850  1.00 53.00           C  
ATOM   1674  O   VAL   225      29.899   7.310 -19.063  1.00 53.69           O  
ATOM   1675  CB  VAL   225      28.242   4.906 -19.342  1.00 52.17           C  
ATOM   1676  CG1 VAL   225      27.435   5.576 -20.441  1.00 52.80           C  
ATOM   1677  CG2 VAL   225      27.783   3.424 -19.177  1.00 48.22           C  
ATOM   1678  N   LYS   226      31.046   6.658 -20.870  1.00 52.56           N  
ATOM   1679  CA  LYS   226      31.503   8.019 -21.182  1.00 52.99           C  
ATOM   1680  C   LYS   226      30.235   8.850 -21.450  1.00 54.80           C  
ATOM   1681  O   LYS   226      29.377   8.462 -22.244  1.00 59.18           O  
ATOM   1682  CB  LYS   226      32.445   8.028 -22.396  1.00 48.62           C  
ATOM   1683  N   ALA   227      30.079   9.956 -20.747  1.00 53.19           N  
ATOM   1684  CA  ALA   227      28.902  10.780 -20.915  1.00 51.60           C  
ATOM   1685  C   ALA   227      29.222  12.223 -20.595  1.00 50.01           C  
ATOM   1686  O   ALA   227      30.017  12.500 -19.713  1.00 47.38           O  
ATOM   1687  CB  ALA   227      27.754  10.282 -19.982  1.00 48.88           C  
ATOM   1688  N   SER   228      28.600  13.137 -21.337  1.00 51.41           N  
ATOM   1689  CA  SER   228      28.678  14.567 -21.064  1.00 51.50           C  
ATOM   1690  C   SER   228      27.276  15.047 -20.658  1.00 48.76           C  
ATOM   1691  O   SER   228      26.305  14.323 -20.819  1.00 47.86           O  
ATOM   1692  CB  SER   228      29.170  15.301 -22.300  1.00 52.99           C  
ATOM   1693  OG  SER   228      28.314  15.003 -23.387  1.00 69.90           O  
ATOM   1694  N   TYR   229      27.171  16.252 -20.107  1.00 48.74           N  
ATOM   1695  CA  TYR   229      25.865  16.800 -19.734  1.00 48.29           C  
ATOM   1696  C   TYR   229      24.890  16.855 -20.940  1.00 48.25           C  
ATOM   1697  O   TYR   229      23.708  16.575 -20.798  1.00 47.01           O  
ATOM   1698  CB  TYR   229      26.006  18.203 -19.101  1.00 48.01           C  
ATOM   1699  CG  TYR   229      24.718  18.650 -18.473  1.00 49.61           C  
ATOM   1700  CD1 TYR   229      23.719  19.281 -19.229  1.00 48.16           C  
ATOM   1701  CD2 TYR   229      24.476  18.403 -17.128  1.00 47.46           C  
ATOM   1702  CE1 TYR   229      22.505  19.635 -18.642  1.00 47.96           C  
ATOM   1703  CE2 TYR   229      23.302  18.771 -16.549  1.00 46.96           C  
ATOM   1704  CZ  TYR   229      22.322  19.384 -17.303  1.00 47.60           C  
ATOM   1705  OH  TYR   229      21.150  19.690 -16.687  1.00 48.70           O  
ATOM   1706  N   GLU   230      25.390  17.199 -22.125  1.00 46.91           N  
ATOM   1707  CA  GLU   230      24.523  17.360 -23.279  1.00 51.69           C  
ATOM   1708  C   GLU   230      23.897  16.068 -23.740  1.00 51.62           C  
ATOM   1709  O   GLU   230      22.951  16.115 -24.529  1.00 52.91           O  
ATOM   1710  CB  GLU   230      25.267  17.991 -24.449  1.00 52.98           C  
ATOM   1711  CG  GLU   230      26.377  17.113 -25.003  1.00 59.12           C  
ATOM   1712  CD  GLU   230      27.116  17.758 -26.156  1.00 60.66           C  
ATOM   1713  OE1 GLU   230      26.703  18.862 -26.588  1.00 64.84           O  
ATOM   1714  OE2 GLU   230      28.104  17.141 -26.621  1.00 73.65           O  
ATOM   1715  N   ASP   231      24.432  14.936 -23.271  1.00 49.16           N  
ATOM   1716  CA  ASP   231      23.905  13.619 -23.603  1.00 48.16           C  
ATOM   1717  C   ASP   231      22.683  13.247 -22.771  1.00 47.73           C  
ATOM   1718  O   ASP   231      21.976  12.344 -23.136  1.00 48.39           O  
ATOM   1719  CB  ASP   231      24.976  12.526 -23.385  1.00 46.15           C  
ATOM   1720  CG  ASP   231      26.167  12.665 -24.301  1.00 51.11           C  
ATOM   1721  OD1 ASP   231      25.989  13.031 -25.473  1.00 60.41           O  
ATOM   1722  OD2 ASP   231      27.292  12.419 -23.848  1.00 54.74           O  
ATOM   1723  N   VAL   232      22.452  13.914 -21.642  1.00 48.20           N  
ATOM   1724  CA  VAL   232      21.338  13.577 -20.752  1.00 47.24           C  
ATOM   1725  C   VAL   232      20.055  14.265 -21.206  1.00 49.91           C  
ATOM   1726  O   VAL   232      20.080  15.431 -21.577  1.00 51.25           O  
ATOM   1727  CB  VAL   232      21.631  14.023 -19.295  1.00 50.55           C  
ATOM   1728  CG1 VAL   232      20.552  13.483 -18.336  1.00 41.85           C  
ATOM   1729  CG2 VAL   232      23.044  13.579 -18.852  1.00 47.15           C  
ATOM   1730  N   GLU   233      18.944  13.537 -21.239  1.00 48.85           N  
ATOM   1731  CA  GLU   233      17.648  14.149 -21.527  1.00 53.13           C  
ATOM   1732  C   GLU   233      17.132  14.530 -20.160  1.00 49.36           C  
ATOM   1733  O   GLU   233      16.885  13.648 -19.330  1.00 47.10           O  
ATOM   1734  CB  GLU   233      16.668  13.170 -22.132  1.00 54.59           C  
ATOM   1735  CG  GLU   233      16.961  12.735 -23.549  1.00 65.54           C  
ATOM   1736  CD  GLU   233      15.904  11.725 -24.068  1.00 65.50           C  
ATOM   1737  OE1 GLU   233      15.341  10.954 -23.234  1.00 66.60           O  
ATOM   1738  OE2 GLU   233      15.659  11.718 -25.308  1.00 74.23           O  
ATOM   1739  N   VAL   234      17.018  15.829 -19.910  1.00 49.46           N  
ATOM   1740  CA  VAL   234      16.619  16.350 -18.595  1.00 51.05           C  
ATOM   1741  C   VAL   234      15.191  16.925 -18.609  1.00 51.67           C  
ATOM   1742  O   VAL   234      14.884  17.749 -19.432  1.00 49.34           O  
ATOM   1743  CB  VAL   234      17.574  17.477 -18.150  1.00 51.02           C  
ATOM   1744  CG1 VAL   234      17.289  17.869 -16.680  1.00 53.81           C  
ATOM   1745  CG2 VAL   234      19.054  17.058 -18.306  1.00 47.25           C  
ATOM   1746  N   THR   235      14.339  16.479 -17.691  1.00 53.01           N  
ATOM   1747  CA  THR   235      12.985  17.024 -17.508  1.00 52.97           C  
ATOM   1748  C   THR   235      12.769  17.196 -16.000  1.00 51.14           C  
ATOM   1749  O   THR   235      13.036  16.296 -15.235  1.00 52.16           O  
ATOM   1750  CB  THR   235      11.902  16.077 -18.040  1.00 54.80           C  
ATOM   1751  OG1 THR   235      12.152  15.813 -19.409  1.00 51.05           O  
ATOM   1752  CG2 THR   235      10.514  16.681 -17.896  1.00 55.94           C  
ATOM   1753  N   GLY   236      12.313  18.374 -15.598  1.00 51.80           N  
ATOM   1754  CA  GLY   236      12.066  18.716 -14.194  1.00 53.90           C  
ATOM   1755  C   GLY   236      10.688  18.305 -13.707  1.00 52.14           C  
ATOM   1756  O   GLY   236       9.980  17.518 -14.380  1.00 51.12           O  
ATOM   1757  N   ILE   237      10.312  18.844 -12.550  1.00 51.45           N  
ATOM   1758  CA  ILE   237       9.046  18.470 -11.882  1.00 50.57           C  
ATOM   1759  C   ILE   237       7.962  19.527 -11.830  1.00 50.30           C  
ATOM   1760  O   ILE   237       6.879  19.296 -11.274  1.00 47.12           O  
ATOM   1761  CB  ILE   237       9.289  18.041 -10.404  1.00 50.11           C  
ATOM   1762  CG1 ILE   237       9.712  19.221  -9.521  1.00 52.04           C  
ATOM   1763  CG2 ILE   237      10.299  16.904 -10.330  1.00 47.51           C  
ATOM   1764  CD1 ILE   237       9.653  18.912  -7.994  1.00 47.30           C  
ATOM   1765  N   THR   238       8.227  20.676 -12.428  1.00 51.91           N  
ATOM   1766  CA  THR   238       7.322  21.804 -12.310  1.00 52.06           C  
ATOM   1767  C   THR   238       5.966  21.616 -12.996  1.00 51.29           C  
ATOM   1768  O   THR   238       5.079  22.411 -12.750  1.00 49.88           O  
ATOM   1769  CB  THR   238       7.992  23.079 -12.835  1.00 53.51           C  
ATOM   1770  OG1 THR   238       8.062  23.024 -14.263  1.00 53.36           O  
ATOM   1771  CG2 THR   238       9.384  23.208 -12.261  1.00 52.87           C  
ATOM   1772  N   GLN   239       5.806  20.593 -13.852  1.00 51.70           N  
ATOM   1773  CA  GLN   239       4.500  20.332 -14.506  1.00 51.14           C  
ATOM   1774  C   GLN   239       3.770  19.083 -13.956  1.00 50.90           C  
ATOM   1775  O   GLN   239       2.852  18.542 -14.606  1.00 50.87           O  
ATOM   1776  CB  GLN   239       4.651  20.213 -16.025  1.00 50.95           C  
ATOM   1777  CG  GLN   239       5.346  21.370 -16.684  1.00 49.53           C  
ATOM   1778  CD  GLN   239       4.687  22.714 -16.431  1.00 53.21           C  
ATOM   1779  OE1 GLN   239       3.488  22.914 -16.677  1.00 52.14           O  
ATOM   1780  NE2 GLN   239       5.489  23.661 -15.965  1.00 60.22           N  
ATOM   1781  N   ILE   240       4.187  18.627 -12.774  1.00 50.50           N  
ATOM   1782  CA  ILE   240       3.534  17.526 -12.068  1.00 49.76           C  
ATOM   1783  C   ILE   240       2.551  18.217 -11.127  1.00 49.62           C  
ATOM   1784  O   ILE   240       2.916  19.113 -10.366  1.00 50.34           O  
ATOM   1785  CB  ILE   240       4.531  16.637 -11.289  1.00 51.40           C  
ATOM   1786  CG1 ILE   240       5.580  16.030 -12.240  1.00 50.23           C  
ATOM   1787  CG2 ILE   240       3.794  15.516 -10.526  1.00 51.15           C  
ATOM   1788  CD1 ILE   240       5.047  15.071 -13.283  1.00 40.36           C  
ATOM   1789  N   THR   241       1.287  17.826 -11.231  1.00 48.18           N  
ATOM   1790  CA  THR   241       0.218  18.419 -10.464  1.00 44.92           C  
ATOM   1791  C   THR   241      -0.417  17.385  -9.522  1.00 45.39           C  
ATOM   1792  O   THR   241      -0.223  16.160  -9.666  1.00 48.75           O  
ATOM   1793  CB  THR   241      -0.903  18.900 -11.423  1.00 45.41           C  
ATOM   1794  OG1 THR   241      -1.461  17.762 -12.093  1.00 42.33           O  
ATOM   1795  CG2 THR   241      -0.385  19.906 -12.461  1.00 39.55           C  
ATOM   1796  N   PRO   242      -1.178  17.862  -8.540  1.00 43.72           N  
ATOM   1797  CA  PRO   242      -1.898  16.935  -7.697  1.00 42.02           C  
ATOM   1798  C   PRO   242      -2.739  15.965  -8.512  1.00 40.79           C  
ATOM   1799  O   PRO   242      -2.818  14.793  -8.167  1.00 40.36           O  
ATOM   1800  CB  PRO   242      -2.789  17.855  -6.875  1.00 45.16           C  
ATOM   1801  CG  PRO   242      -1.977  19.111  -6.759  1.00 40.89           C  
ATOM   1802  CD  PRO   242      -1.351  19.257  -8.098  1.00 43.85           C  
ATOM   1803  N   GLU   243      -3.326  16.439  -9.607  1.00 41.11           N  
ATOM   1804  CA  GLU   243      -4.181  15.595 -10.436  1.00 40.13           C  
ATOM   1805  C   GLU   243      -3.392  14.439 -11.052  1.00 40.44           C  
ATOM   1806  O   GLU   243      -3.890  13.332 -11.171  1.00 39.81           O  
ATOM   1807  CB  GLU   243      -4.916  16.436 -11.483  1.00 43.04           C  
ATOM   1808  CG  GLU   243      -5.965  15.667 -12.266  1.00 43.85           C  
ATOM   1809  CD  GLU   243      -6.988  14.994 -11.381  1.00 45.41           C  
ATOM   1810  OE1 GLU   243      -7.357  15.601 -10.365  1.00 41.82           O  
ATOM   1811  OE2 GLU   243      -7.443  13.874 -11.714  1.00 55.23           O  
ATOM   1812  N   ALA   244      -2.142  14.685 -11.401  1.00 40.95           N  
ATOM   1813  CA  ALA   244      -1.283  13.629 -11.875  1.00 42.78           C  
ATOM   1814  C   ALA   244      -1.108  12.543 -10.786  1.00 40.92           C  
ATOM   1815  O   ALA   244      -1.111  11.358 -11.086  1.00 41.81           O  
ATOM   1816  CB  ALA   244       0.125  14.216 -12.341  1.00 40.76           C  
ATOM   1817  N   PHE   245      -0.923  12.949  -9.537  1.00 42.02           N  
ATOM   1818  CA  PHE   245      -0.764  11.996  -8.432  1.00 41.77           C  
ATOM   1819  C   PHE   245      -2.051  11.208  -8.199  1.00 42.19           C  
ATOM   1820  O   PHE   245      -2.029  10.038  -7.840  1.00 47.13           O  
ATOM   1821  CB  PHE   245      -0.344  12.695  -7.121  1.00 42.89           C  
ATOM   1822  CG  PHE   245       1.125  12.972  -7.017  1.00 40.18           C  
ATOM   1823  CD1 PHE   245       1.991  11.972  -6.609  1.00 39.79           C  
ATOM   1824  CD2 PHE   245       1.640  14.247  -7.280  1.00 42.93           C  
ATOM   1825  CE1 PHE   245       3.358  12.220  -6.490  1.00 42.20           C  
ATOM   1826  CE2 PHE   245       2.994  14.499  -7.176  1.00 45.15           C  
ATOM   1827  CZ  PHE   245       3.860  13.478  -6.792  1.00 47.39           C  
ATOM   1828  N   GLN   246      -3.181  11.842  -8.408  1.00 41.99           N  
ATOM   1829  CA  GLN   246      -4.450  11.162  -8.233  1.00 41.40           C  
ATOM   1830  C   GLN   246      -4.657  10.066  -9.283  1.00 42.17           C  
ATOM   1831  O   GLN   246      -5.041   8.964  -8.938  1.00 44.25           O  
ATOM   1832  CB  GLN   246      -5.586  12.155  -8.301  1.00 38.86           C  
ATOM   1833  CG  GLN   246      -6.995  11.535  -8.182  1.00 39.79           C  
ATOM   1834  CD  GLN   246      -7.226  10.792  -6.872  1.00 39.15           C  
ATOM   1835  OE1 GLN   246      -6.626  11.101  -5.848  1.00 43.01           O  
ATOM   1836  NE2 GLN   246      -8.108   9.803  -6.909  1.00 40.19           N  
ATOM   1837  N   VAL   247      -4.403  10.354 -10.554  1.00 43.07           N  
ATOM   1838  CA  VAL   247      -4.644   9.347 -11.614  1.00 40.38           C  
ATOM   1839  C   VAL   247      -3.631   8.202 -11.505  1.00 40.18           C  
ATOM   1840  O   VAL   247      -3.953   7.047 -11.779  1.00 40.19           O  
ATOM   1841  CB  VAL   247      -4.683   9.963 -13.031  1.00 39.05           C  
ATOM   1842  CG1 VAL   247      -5.787  10.993 -13.100  1.00 35.51           C  
ATOM   1843  CG2 VAL   247      -3.361  10.586 -13.417  1.00 35.10           C  
ATOM   1844  N   ALA   248      -2.418   8.524 -11.081  1.00 41.55           N  
ATOM   1845  CA  ALA   248      -1.380   7.504 -10.858  1.00 43.61           C  
ATOM   1846  C   ALA   248      -1.725   6.612  -9.628  1.00 44.76           C  
ATOM   1847  O   ALA   248      -1.574   5.389  -9.671  1.00 45.16           O  
ATOM   1848  CB  ALA   248      -0.031   8.158 -10.698  1.00 39.93           C  
ATOM   1849  N   ALA   249      -2.221   7.231  -8.558  1.00 46.58           N  
ATOM   1850  CA  ALA   249      -2.593   6.516  -7.324  1.00 45.65           C  
ATOM   1851  C   ALA   249      -3.641   5.455  -7.600  1.00 45.82           C  
ATOM   1852  O   ALA   249      -3.556   4.343  -7.109  1.00 48.91           O  
ATOM   1853  CB  ALA   249      -3.098   7.493  -6.272  1.00 44.69           C  
ATOM   1854  N   GLU   250      -4.604   5.790  -8.442  1.00 46.64           N  
ATOM   1855  CA  GLU   250      -5.681   4.892  -8.778  1.00 44.96           C  
ATOM   1856  C   GLU   250      -5.190   3.582  -9.409  1.00 43.24           C  
ATOM   1857  O   GLU   250      -5.881   2.579  -9.352  1.00 43.54           O  
ATOM   1858  CB  GLU   250      -6.685   5.625  -9.684  1.00 44.73           C  
ATOM   1859  CG  GLU   250      -7.422   6.787  -8.970  1.00 46.14           C  
ATOM   1860  CD  GLU   250      -8.346   7.599  -9.889  1.00 49.43           C  
ATOM   1861  OE1 GLU   250      -8.366   7.356 -11.120  1.00 45.92           O  
ATOM   1862  OE2 GLU   250      -9.068   8.486  -9.372  1.00 59.08           O  
ATOM   1863  N   LYS   251      -3.984   3.578  -9.961  1.00 44.52           N  
ATOM   1864  CA  LYS   251      -3.406   2.384 -10.600  1.00 45.68           C  
ATOM   1865  C   LYS   251      -2.169   1.837  -9.853  1.00 48.30           C  
ATOM   1866  O   LYS   251      -1.402   1.056 -10.409  1.00 50.79           O  
ATOM   1867  CB  LYS   251      -3.034   2.707 -12.066  1.00 43.07           C  
ATOM   1868  CG  LYS   251      -4.193   3.318 -12.900  1.00 43.05           C  
ATOM   1869  CD  LYS   251      -5.392   2.388 -13.003  1.00 45.17           C  
ATOM   1870  CE  LYS   251      -6.557   2.995 -13.834  1.00 48.14           C  
ATOM   1871  N   GLY   252      -1.955   2.291  -8.622  1.00 48.48           N  
ATOM   1872  CA  GLY   252      -0.867   1.797  -7.782  1.00 47.58           C  
ATOM   1873  C   GLY   252       0.466   2.488  -7.861  1.00 48.28           C  
ATOM   1874  O   GLY   252       1.452   1.972  -7.316  1.00 47.63           O  
ATOM   1875  N   TYR   253       0.497   3.673  -8.473  1.00 46.78           N  
ATOM   1876  CA  TYR   253       1.734   4.393  -8.659  1.00 47.90           C  
ATOM   1877  C   TYR   253       1.828   5.714  -7.926  1.00 47.46           C  
ATOM   1878  O   TYR   253       0.847   6.393  -7.699  1.00 46.82           O  
ATOM   1879  CB  TYR   253       1.936   4.728 -10.139  1.00 49.96           C  
ATOM   1880  CG  TYR   253       1.994   3.555 -11.078  1.00 49.64           C  
ATOM   1881  CD1 TYR   253       3.191   2.906 -11.319  1.00 52.34           C  
ATOM   1882  CD2 TYR   253       0.861   3.108 -11.735  1.00 50.30           C  
ATOM   1883  CE1 TYR   253       3.265   1.824 -12.168  1.00 52.09           C  
ATOM   1884  CE2 TYR   253       0.915   2.030 -12.591  1.00 59.56           C  
ATOM   1885  CZ  TYR   253       2.127   1.382 -12.812  1.00 63.02           C  
ATOM   1886  OH  TYR   253       2.213   0.304 -13.682  1.00 58.75           O  
ATOM   1887  N   THR   254       3.054   6.059  -7.571  1.00 48.76           N  
ATOM   1888  CA  THR   254       3.372   7.392  -7.097  1.00 47.08           C  
ATOM   1889  C   THR   254       4.245   7.928  -8.228  1.00 49.16           C  
ATOM   1890  O   THR   254       4.402   7.259  -9.259  1.00 48.78           O  
ATOM   1891  CB  THR   254       4.072   7.429  -5.731  1.00 46.40           C  
ATOM   1892  OG1 THR   254       4.178   8.792  -5.330  1.00 42.73           O  
ATOM   1893  CG2 THR   254       5.444   6.781  -5.772  1.00 41.30           C  
ATOM   1894  N   ILE   255       4.780   9.130  -8.066  1.00 51.63           N  
ATOM   1895  CA  ILE   255       5.599   9.773  -9.103  1.00 49.60           C  
ATOM   1896  C   ILE   255       6.888  10.243  -8.454  1.00 50.49           C  
ATOM   1897  O   ILE   255       6.858  10.837  -7.367  1.00 47.75           O  
ATOM   1898  CB  ILE   255       4.891  11.000  -9.715  1.00 48.87           C  
ATOM   1899  CG1 ILE   255       3.530  10.607 -10.320  1.00 47.92           C  
ATOM   1900  CG2 ILE   255       5.777  11.660 -10.774  1.00 46.19           C  
ATOM   1901  CD1 ILE   255       2.656  11.771 -10.677  1.00 47.03           C  
ATOM   1902  N   ARG   256       8.011   9.986  -9.125  1.00 50.08           N  
ATOM   1903  CA  ARG   256       9.330  10.376  -8.613  1.00 50.31           C  
ATOM   1904  C   ARG   256      10.209  10.882  -9.721  1.00 49.70           C  
ATOM   1905  O   ARG   256      10.014  10.517 -10.874  1.00 50.83           O  
ATOM   1906  CB  ARG   256      10.002   9.153  -7.995  1.00 51.89           C  
ATOM   1907  CG  ARG   256       9.358   8.667  -6.706  1.00 53.29           C  
ATOM   1908  CD  ARG   256       9.722   9.572  -5.582  1.00 55.52           C  
ATOM   1909  NE  ARG   256       9.123   9.135  -4.334  1.00 55.85           N  
ATOM   1910  CZ  ARG   256       7.874   9.391  -3.947  1.00 54.21           C  
ATOM   1911  NH1 ARG   256       7.025  10.085  -4.709  1.00 56.43           N  
ATOM   1912  NH2 ARG   256       7.465   8.921  -2.780  1.00 59.54           N  
ATOM   1913  N   LEU   257      11.207  11.697  -9.383  1.00 51.04           N  
ATOM   1914  CA  LEU   257      12.173  12.161 -10.376  1.00 47.61           C  
ATOM   1915  C   LEU   257      13.278  11.112 -10.339  1.00 49.86           C  
ATOM   1916  O   LEU   257      13.995  10.959  -9.340  1.00 50.23           O  
ATOM   1917  CB  LEU   257      12.722  13.556 -10.073  1.00 47.72           C  
ATOM   1918  CG  LEU   257      13.746  14.106 -11.093  1.00 49.63           C  
ATOM   1919  CD1 LEU   257      13.060  14.484 -12.363  1.00 52.20           C  
ATOM   1920  CD2 LEU   257      14.508  15.303 -10.533  1.00 50.78           C  
ATOM   1921  N   ILE   258      13.407  10.392 -11.443  1.00 49.48           N  
ATOM   1922  CA  ILE   258      14.334   9.305 -11.546  1.00 50.05           C  
ATOM   1923  C   ILE   258      15.436   9.615 -12.550  1.00 50.57           C  
ATOM   1924  O   ILE   258      15.166  10.017 -13.692  1.00 50.24           O  
ATOM   1925  CB  ILE   258      13.600   7.972 -11.984  1.00 48.16           C  
ATOM   1926  CG1 ILE   258      12.490   7.570 -10.985  1.00 49.81           C  
ATOM   1927  CG2 ILE   258      14.567   6.829 -12.134  1.00 44.38           C  
ATOM   1928  CD1 ILE   258      12.970   7.197  -9.627  1.00 44.62           C  
ATOM   1929  N   ALA   259      16.674   9.393 -12.107  1.00 49.90           N  
ATOM   1930  CA  ALA   259      17.877   9.530 -12.937  1.00 50.69           C  
ATOM   1931  C   ALA   259      18.273   8.100 -13.356  1.00 50.89           C  
ATOM   1932  O   ALA   259      18.341   7.205 -12.511  1.00 50.11           O  
ATOM   1933  CB  ALA   259      19.039  10.257 -12.136  1.00 47.55           C  
ATOM   1934  N   GLU   260      18.501   7.880 -14.651  1.00 51.07           N  
ATOM   1935  CA  GLU   260      18.846   6.576 -15.138  1.00 52.95           C  
ATOM   1936  C   GLU   260      19.957   6.562 -16.149  1.00 50.27           C  
ATOM   1937  O   GLU   260      19.947   7.360 -17.070  1.00 54.09           O  
ATOM   1938  CB  GLU   260      17.610   5.915 -15.801  1.00 54.66           C  
ATOM   1939  CG  GLU   260      17.984   4.637 -16.571  1.00 56.10           C  
ATOM   1940  CD  GLU   260      16.811   3.823 -17.087  1.00 61.73           C  
ATOM   1941  OE1 GLU   260      15.656   4.100 -16.697  1.00 61.72           O  
ATOM   1942  OE2 GLU   260      17.063   2.893 -17.898  1.00 69.02           O  
ATOM   1943  N   VAL   261      20.909   5.639 -15.990  1.00 48.24           N  
ATOM   1944  CA  VAL   261      21.954   5.381 -16.989  1.00 48.31           C  
ATOM   1945  C   VAL   261      21.846   3.876 -17.266  1.00 51.87           C  
ATOM   1946  O   VAL   261      21.948   3.070 -16.352  1.00 51.60           O  
ATOM   1947  CB  VAL   261      23.425   5.795 -16.585  1.00 48.63           C  
ATOM   1948  CG1 VAL   261      23.837   5.279 -15.231  1.00 48.90           C  
ATOM   1949  CG2 VAL   261      24.421   5.316 -17.661  1.00 41.92           C  
ATOM   1950  N   SER   262      21.544   3.520 -18.506  1.00 53.92           N  
ATOM   1951  CA  SER   262      21.405   2.117 -18.961  1.00 54.45           C  
ATOM   1952  C   SER   262      21.855   2.099 -20.380  1.00 55.86           C  
ATOM   1953  O   SER   262      22.365   3.111 -20.863  1.00 57.01           O  
ATOM   1954  CB  SER   262      19.957   1.623 -18.892  1.00 54.67           C  
ATOM   1955  OG  SER   262      19.077   2.430 -19.661  1.00 59.40           O  
ATOM   1956  N   ARG   263      21.672   0.964 -21.045  1.00 59.14           N  
ATOM   1957  CA  ARG   263      22.034   0.802 -22.459  1.00 59.93           C  
ATOM   1958  C   ARG   263      21.059   1.632 -23.301  1.00 62.30           C  
ATOM   1959  O   ARG   263      21.455   2.339 -24.218  1.00 63.10           O  
ATOM   1960  CB  ARG   263      21.976  -0.692 -22.855  1.00 59.62           C  
ATOM   1961  CG  ARG   263      22.596  -1.039 -24.229  1.00 60.73           C  
ATOM   1962  N   GLU   264      19.781   1.566 -22.939  1.00 65.99           N  
ATOM   1963  CA  GLU   264      18.722   2.291 -23.633  1.00 68.06           C  
ATOM   1964  C   GLU   264      18.665   3.813 -23.330  1.00 69.57           C  
ATOM   1965  O   GLU   264      18.291   4.616 -24.199  1.00 70.88           O  
ATOM   1966  CB  GLU   264      17.363   1.661 -23.250  1.00 68.88           C  
ATOM   1967  N   LYS   265      19.079   4.206 -22.123  1.00 67.14           N  
ATOM   1968  CA  LYS   265      18.847   5.557 -21.641  1.00 65.36           C  
ATOM   1969  C   LYS   265      19.928   6.290 -20.858  1.00 60.82           C  
ATOM   1970  O   LYS   265      20.834   5.712 -20.273  1.00 56.75           O  
ATOM   1971  CB  LYS   265      17.634   5.474 -20.694  1.00 65.07           C  
ATOM   1972  CG  LYS   265      16.370   5.080 -21.410  1.00 67.60           C  
ATOM   1973  CD  LYS   265      15.201   4.860 -20.482  1.00 73.63           C  
ATOM   1974  CE  LYS   265      13.889   4.905 -21.267  1.00 79.42           C  
ATOM   1975  NZ  LYS   265      13.993   4.235 -22.594  1.00 74.09           N  
ATOM   1976  N   LEU   266      19.769   7.606 -20.862  1.00 56.90           N  
ATOM   1977  CA  LEU   266      20.560   8.522 -20.069  1.00 52.32           C  
ATOM   1978  C   LEU   266      19.590   9.686 -19.842  1.00 49.93           C  
ATOM   1979  O   LEU   266      19.467  10.576 -20.674  1.00 46.28           O  
ATOM   1980  CB  LEU   266      21.845   8.934 -20.793  1.00 49.25           C  
ATOM   1981  CG  LEU   266      22.812   9.786 -19.974  1.00 53.47           C  
ATOM   1982  CD1 LEU   266      23.260   9.026 -18.727  1.00 52.75           C  
ATOM   1983  CD2 LEU   266      24.012  10.263 -20.800  1.00 51.30           C  
ATOM   1984  N   LYS   267      18.834   9.633 -18.758  1.00 47.82           N  
ATOM   1985  CA  LYS   267      17.887  10.660 -18.510  1.00 51.06           C  
ATOM   1986  C   LYS   267      17.526  10.887 -17.072  1.00 49.84           C  
ATOM   1987  O   LYS   267      17.724  10.027 -16.200  1.00 49.24           O  
ATOM   1988  CB  LYS   267      16.598  10.390 -19.297  1.00 53.67           C  
ATOM   1989  CG  LYS   267      15.810   9.149 -18.924  1.00 60.78           C  
ATOM   1990  CD  LYS   267      14.541   8.944 -19.815  1.00 60.18           C  
ATOM   1991  CE  LYS   267      13.575  10.193 -19.966  1.00 76.63           C  
ATOM   1992  NZ  LYS   267      13.784  11.228 -21.118  1.00 67.91           N  
ATOM   1993  N   VAL   268      17.003  12.087 -16.860  1.00 49.68           N  
ATOM   1994  CA  VAL   268      16.426  12.519 -15.606  1.00 51.35           C  
ATOM   1995  C   VAL   268      15.037  13.025 -15.979  1.00 51.93           C  
ATOM   1996  O   VAL   268      14.903  13.866 -16.867  1.00 48.66           O  
ATOM   1997  CB  VAL   268      17.234  13.667 -14.963  1.00 52.83           C  
ATOM   1998  CG1 VAL   268      16.513  14.203 -13.740  1.00 49.39           C  
ATOM   1999  CG2 VAL   268      18.658  13.167 -14.599  1.00 47.14           C  
ATOM   2000  N   SER   269      14.010  12.457 -15.359  1.00 51.69           N  
ATOM   2001  CA  SER   269      12.653  12.879 -15.592  1.00 53.24           C  
ATOM   2002  C   SER   269      11.710  12.306 -14.563  1.00 53.14           C  
ATOM   2003  O   SER   269      12.048  11.354 -13.829  1.00 54.67           O  
ATOM   2004  CB  SER   269      12.152  12.423 -16.965  1.00 53.66           C  
ATOM   2005  OG  SER   269      12.163  11.010 -17.043  1.00 57.01           O  
ATOM   2006  N   PRO   270      10.522  12.919 -14.450  1.00 51.63           N  
ATOM   2007  CA  PRO   270       9.501  12.260 -13.627  1.00 52.74           C  
ATOM   2008  C   PRO   270       9.123  10.884 -14.204  1.00 51.85           C  
ATOM   2009  O   PRO   270       9.159  10.691 -15.414  1.00 53.70           O  
ATOM   2010  CB  PRO   270       8.330  13.226 -13.689  1.00 52.28           C  
ATOM   2011  CG  PRO   270       9.016  14.589 -13.893  1.00 53.95           C  
ATOM   2012  CD  PRO   270      10.110  14.258 -14.872  1.00 48.97           C  
ATOM   2013  N   ARG   271       8.723   9.969 -13.335  1.00 49.90           N  
ATOM   2014  CA  ARG   271       8.358   8.651 -13.730  1.00 53.06           C  
ATOM   2015  C   ARG   271       7.373   8.023 -12.742  1.00 50.72           C  
ATOM   2016  O   ARG   271       7.444   8.310 -11.557  1.00 50.11           O  
ATOM   2017  CB  ARG   271       9.624   7.817 -13.760  1.00 54.71           C  
ATOM   2018  CG  ARG   271       9.445   6.443 -14.341  1.00 60.14           C  
ATOM   2019  CD  ARG   271      10.752   5.656 -14.346  1.00 60.69           C  
ATOM   2020  NE  ARG   271      11.780   6.259 -15.198  1.00 63.06           N  
ATOM   2021  CZ  ARG   271      12.936   5.661 -15.502  1.00 68.10           C  
ATOM   2022  NH1 ARG   271      13.195   4.432 -15.042  1.00 61.75           N  
ATOM   2023  NH2 ARG   271      13.827   6.274 -16.296  1.00 63.05           N  
ATOM   2024  N   LEU   272       6.461   7.173 -13.243  1.00 49.75           N  
ATOM   2025  CA  LEU   272       5.549   6.418 -12.381  1.00 50.07           C  
ATOM   2026  C   LEU   272       6.342   5.288 -11.692  1.00 52.05           C  
ATOM   2027  O   LEU   272       7.090   4.570 -12.348  1.00 56.31           O  
ATOM   2028  CB  LEU   272       4.385   5.853 -13.165  1.00 47.30           C  
ATOM   2029  CG  LEU   272       3.434   6.882 -13.793  1.00 46.63           C  
ATOM   2030  CD1 LEU   272       2.246   6.223 -14.527  1.00 40.52           C  
ATOM   2031  CD2 LEU   272       2.954   7.860 -12.713  1.00 40.96           C  
ATOM   2032  N   VAL   273       6.201   5.181 -10.374  1.00 51.42           N  
ATOM   2033  CA  VAL   273       6.858   4.165  -9.560  1.00 51.89           C  
ATOM   2034  C   VAL   273       5.812   3.483  -8.666  1.00 53.90           C  
ATOM   2035  O   VAL   273       5.110   4.174  -7.912  1.00 55.96           O  
ATOM   2036  CB  VAL   273       7.916   4.799  -8.620  1.00 53.50           C  
ATOM   2037  CG1 VAL   273       8.583   3.717  -7.749  1.00 49.92           C  
ATOM   2038  CG2 VAL   273       8.955   5.633  -9.421  1.00 47.84           C  
ATOM   2039  N   PRO   274       5.675   2.135  -8.755  1.00 52.64           N  
ATOM   2040  CA  PRO   274       4.728   1.432  -7.891  1.00 53.96           C  
ATOM   2041  C   PRO   274       4.977   1.737  -6.425  1.00 54.64           C  
ATOM   2042  O   PRO   274       6.127   1.797  -6.004  1.00 54.38           O  
ATOM   2043  CB  PRO   274       4.995  -0.035  -8.194  1.00 53.52           C  
ATOM   2044  CG  PRO   274       5.512  -0.028  -9.586  1.00 51.92           C  
ATOM   2045  CD  PRO   274       6.332   1.208  -9.692  1.00 53.02           C  
ATOM   2046  N   PHE   275       3.899   1.932  -5.675  1.00 54.72           N  
ATOM   2047  CA  PHE   275       3.974   2.293  -4.272  1.00 55.62           C  
ATOM   2048  C   PHE   275       4.891   1.449  -3.413  1.00 58.81           C  
ATOM   2049  O   PHE   275       5.520   1.943  -2.483  1.00 60.70           O  
ATOM   2050  CB  PHE   275       2.588   2.209  -3.655  1.00 57.01           C  
ATOM   2051  CG  PHE   275       1.686   3.318  -4.045  1.00 55.28           C  
ATOM   2052  CD1 PHE   275       2.029   4.624  -3.764  1.00 56.36           C  
ATOM   2053  CD2 PHE   275       0.454   3.057  -4.604  1.00 55.16           C  
ATOM   2054  CE1 PHE   275       1.184   5.657  -4.092  1.00 59.77           C  
ATOM   2055  CE2 PHE   275      -0.402   4.086  -4.922  1.00 58.80           C  
ATOM   2056  CZ  PHE   275      -0.037   5.391  -4.666  1.00 54.00           C  
ATOM   2057  N   HIS   276       4.944   0.160  -3.681  1.00 63.00           N  
ATOM   2058  CA  HIS   276       5.792  -0.693  -2.857  1.00 66.83           C  
ATOM   2059  C   HIS   276       7.177  -0.994  -3.461  1.00 66.08           C  
ATOM   2060  O   HIS   276       7.884  -1.870  -2.970  1.00 68.94           O  
ATOM   2061  CB  HIS   276       5.045  -1.990  -2.492  1.00 69.40           C  
ATOM   2062  CG  HIS   276       3.897  -1.777  -1.545  1.00 77.16           C  
ATOM   2063  ND1 HIS   276       2.577  -1.957  -1.910  1.00 84.07           N  
ATOM   2064  CD2 HIS   276       3.879  -1.381  -0.251  1.00 76.56           C  
ATOM   2065  CE1 HIS   276       1.800  -1.695  -0.873  1.00 86.57           C  
ATOM   2066  NE2 HIS   276       2.565  -1.339   0.143  1.00 82.10           N  
ATOM   2067  N   HIS   277       7.551  -0.272  -4.528  0.50 63.14           N  
ATOM   2069  CA  HIS   277       8.868  -0.436  -5.158  0.50 61.64           C  
ATOM   2071  C   HIS   277       9.907   0.297  -4.304  0.50 59.06           C  
ATOM   2073  O   HIS   277       9.579   1.288  -3.648  0.50 57.93           O  
ATOM   2075  CB  HIS   277       8.892   0.092  -6.606  0.50 60.27           C  
ATOM   2077  CG  HIS   277      10.214  -0.095  -7.300  0.50 60.02           C  
ATOM   2079  ND1 HIS   277      11.153   0.911  -7.410  0.50 40.88           N  
ATOM   2081  CD2 HIS   277      10.760  -1.182  -7.896  0.50 56.22           C  
ATOM   2083  CE1 HIS   277      12.226   0.446  -8.026  0.50 44.71           C  
ATOM   2085  NE2 HIS   277      12.015  -0.820  -8.332  0.50 55.69           N  
ATOM   2087  N   PRO   278      11.150  -0.214  -4.260  1.00 57.57           N  
ATOM   2088  CA  PRO   278      12.187   0.488  -3.504  1.00 55.58           C  
ATOM   2089  C   PRO   278      12.443   1.954  -3.879  1.00 53.90           C  
ATOM   2090  O   PRO   278      12.796   2.721  -3.013  1.00 55.60           O  
ATOM   2091  CB  PRO   278      13.427  -0.369  -3.747  1.00 54.22           C  
ATOM   2092  CG  PRO   278      12.895  -1.721  -3.973  1.00 54.80           C  
ATOM   2093  CD  PRO   278      11.685  -1.478  -4.812  1.00 57.70           C  
ATOM   2094  N   LEU   279      12.219   2.352  -5.123  1.00 52.42           N  
ATOM   2095  CA  LEU   279      12.427   3.737  -5.518  1.00 53.39           C  
ATOM   2096  C   LEU   279      11.205   4.624  -5.231  1.00 54.49           C  
ATOM   2097  O   LEU   279      11.191   5.766  -5.658  1.00 55.60           O  
ATOM   2098  CB  LEU   279      12.864   3.842  -6.983  1.00 52.72           C  
ATOM   2099  CG  LEU   279      14.279   3.350  -7.343  1.00 59.22           C  
ATOM   2100  CD1 LEU   279      14.465   3.288  -8.857  1.00 50.14           C  
ATOM   2101  CD2 LEU   279      15.331   4.266  -6.687  1.00 47.94           C  
ATOM   2102  N   ALA   280      10.207   4.121  -4.489  1.00 57.24           N  
ATOM   2103  CA  ALA   280       9.030   4.925  -4.056  1.00 56.16           C  
ATOM   2104  C   ALA   280       9.281   5.644  -2.719  1.00 57.69           C  
ATOM   2105  O   ALA   280       8.379   6.213  -2.131  1.00 58.14           O  
ATOM   2106  CB  ALA   280       7.779   4.045  -3.936  1.00 56.25           C  
ATOM   2107  N   ILE   281      10.508   5.582  -2.235  1.00 59.74           N  
ATOM   2108  CA  ILE   281      10.947   6.265  -1.016  1.00 60.78           C  
ATOM   2109  C   ILE   281      10.517   7.750  -0.945  1.00 60.99           C  
ATOM   2110  O   ILE   281      10.586   8.508  -1.927  1.00 58.34           O  
ATOM   2111  CB  ILE   281      12.498   6.161  -0.924  1.00 60.10           C  
ATOM   2112  CG1 ILE   281      12.971   6.338   0.509  1.00 66.46           C  
ATOM   2113  CG2 ILE   281      13.189   7.127  -1.969  1.00 57.81           C  
ATOM   2114  CD1 ILE   281      14.303   5.653   0.779  1.00 67.85           C  
ATOM   2115  N   LYS   282      10.080   8.173   0.229  1.00 61.35           N  
ATOM   2116  CA  LYS   282       9.619   9.539   0.388  1.00 63.67           C  
ATOM   2117  C   LYS   282      10.551  10.419   1.229  1.00 61.25           C  
ATOM   2118  O   LYS   282      11.502   9.933   1.803  1.00 61.51           O  
ATOM   2119  CB  LYS   282       8.141   9.570   0.846  1.00 64.98           C  
ATOM   2120  CG  LYS   282       7.766   8.583   1.882  1.00 67.64           C  
ATOM   2121  CD  LYS   282       6.285   8.645   2.238  1.00 67.61           C  
ATOM   2122  CE  LYS   282       5.385   8.048   1.180  1.00 67.77           C  
ATOM   2123  NZ  LYS   282       4.075   7.599   1.782  1.00 67.80           N  
ATOM   2124  N   GLY   283      10.295  11.729   1.221  1.00 60.05           N  
ATOM   2125  CA  GLY   283      11.082  12.711   1.977  1.00 56.85           C  
ATOM   2126  C   GLY   283      12.323  13.165   1.249  1.00 55.49           C  
ATOM   2127  O   GLY   283      12.490  12.857   0.075  1.00 56.61           O  
ATOM   2128  N   THR   284      13.186  13.922   1.937  1.00 55.16           N  
ATOM   2129  CA  THR   284      14.458  14.352   1.366  1.00 58.60           C  
ATOM   2130  C   THR   284      15.396  13.158   1.510  1.00 58.29           C  
ATOM   2131  O   THR   284      16.127  13.025   2.498  1.00 64.26           O  
ATOM   2132  CB  THR   284      15.068  15.562   2.103  1.00 58.81           C  
ATOM   2133  OG1 THR   284      15.282  15.184   3.465  1.00 61.42           O  
ATOM   2134  CG2 THR   284      14.130  16.791   2.063  1.00 54.55           C  
ATOM   2135  N   MET   285      15.348  12.279   0.533  1.00 55.74           N  
ATOM   2136  CA  MET   285      16.149  11.090   0.542  1.00 54.80           C  
ATOM   2137  C   MET   285      16.820  10.866  -0.798  1.00 53.76           C  
ATOM   2138  O   MET   285      16.468  11.517  -1.812  1.00 51.16           O  
ATOM   2139  CB  MET   285      15.254   9.895   0.817  1.00 59.08           C  
ATOM   2140  CG  MET   285      16.023   8.803   1.486  1.00 70.72           C  
ATOM   2141  SD  MET   285      15.988   9.191   3.365  0.75 72.71          SE  
ATOM   2142  CE  MET   285      14.036   7.971   3.245  1.00 55.49           C  
ATOM   2143  N   ASN   286      17.863  10.041  -0.795  1.00 50.19           N  
ATOM   2144  CA  ASN   286      18.458   9.596  -2.055  1.00 50.76           C  
ATOM   2145  C   ASN   286      18.290   8.081  -2.142  1.00 50.97           C  
ATOM   2146  O   ASN   286      17.978   7.440  -1.131  1.00 44.71           O  
ATOM   2147  CB  ASN   286      19.923   9.981  -2.224  1.00 49.58           C  
ATOM   2148  CG  ASN   286      20.112  11.403  -2.696  1.00 50.93           C  
ATOM   2149  OD1 ASN   286      21.105  11.690  -3.318  1.00 57.81           O  
ATOM   2150  ND2 ASN   286      19.143  12.297  -2.415  1.00 52.94           N  
ATOM   2151  N   ALA   287      18.425   7.550  -3.367  1.00 47.85           N  
ATOM   2152  CA  ALA   287      18.376   6.142  -3.571  1.00 50.04           C  
ATOM   2153  C   ALA   287      18.981   5.740  -4.931  1.00 48.49           C  
ATOM   2154  O   ALA   287      19.136   6.564  -5.846  1.00 49.11           O  
ATOM   2155  CB  ALA   287      16.931   5.601  -3.350  1.00 50.22           C  
ATOM   2156  N   ALA   288      19.445   4.498  -5.024  1.00 45.47           N  
ATOM   2157  CA  ALA   288      20.031   4.040  -6.281  1.00 47.90           C  
ATOM   2158  C   ALA   288      19.895   2.544  -6.375  1.00 48.41           C  
ATOM   2159  O   ALA   288      20.132   1.835  -5.394  1.00 49.24           O  
ATOM   2160  CB  ALA   288      21.514   4.466  -6.395  1.00 45.62           C  
ATOM   2161  N   MET   289      19.483   2.070  -7.545  1.00 48.34           N  
ATOM   2162  CA  MET   289      19.390   0.672  -7.800  1.00 48.98           C  
ATOM   2163  C   MET   289      20.462   0.335  -8.825  1.00 48.97           C  
ATOM   2164  O   MET   289      20.379   0.806  -9.935  1.00 48.56           O  
ATOM   2165  CB  MET   289      17.991   0.333  -8.359  1.00 52.88           C  
ATOM   2166  CG  MET   289      17.745  -1.165  -8.616  1.00 52.27           C  
ATOM   2167  SD  MET   289      17.752  -2.323  -7.100  0.75 51.82          SE  
ATOM   2168  CE  MET   289      15.943  -2.000  -6.436  1.00 70.48           C  
ATOM   2169  N   PHE   290      21.442  -0.498  -8.466  1.00 49.09           N  
ATOM   2170  CA  PHE   290      22.459  -0.980  -9.434  1.00 48.88           C  
ATOM   2171  C   PHE   290      22.062  -2.356  -9.940  1.00 50.07           C  
ATOM   2172  O   PHE   290      21.818  -3.239  -9.154  1.00 49.92           O  
ATOM   2173  CB  PHE   290      23.842  -1.103  -8.779  1.00 48.79           C  
ATOM   2174  CG  PHE   290      24.349   0.158  -8.204  1.00 48.96           C  
ATOM   2175  CD1 PHE   290      23.896   0.613  -6.969  1.00 46.94           C  
ATOM   2176  CD2 PHE   290      25.285   0.908  -8.884  1.00 55.03           C  
ATOM   2177  CE1 PHE   290      24.328   1.791  -6.463  1.00 52.75           C  
ATOM   2178  CE2 PHE   290      25.744   2.085  -8.363  1.00 56.17           C  
ATOM   2179  CZ  PHE   290      25.264   2.539  -7.158  1.00 55.13           C  
ATOM   2180  N   LYS   291      21.959  -2.515 -11.248  1.00 51.01           N  
ATOM   2181  CA  LYS   291      21.694  -3.786 -11.860  1.00 52.81           C  
ATOM   2182  C   LYS   291      23.043  -4.249 -12.413  1.00 51.70           C  
ATOM   2183  O   LYS   291      23.681  -3.528 -13.179  1.00 46.61           O  
ATOM   2184  CB  LYS   291      20.655  -3.672 -12.988  1.00 55.77           C  
ATOM   2185  CG  LYS   291      20.211  -5.026 -13.568  1.00 60.53           C  
ATOM   2186  CD  LYS   291      19.325  -4.887 -14.824  1.00 60.07           C  
ATOM   2187  CE  LYS   291      19.053  -6.265 -15.511  1.00 65.73           C  
ATOM   2188  N   THR   292      23.471  -5.450 -12.003  1.00 51.30           N  
ATOM   2189  CA  THR   292      24.770  -5.989 -12.373  1.00 49.62           C  
ATOM   2190  C   THR   292      24.610  -7.333 -12.985  1.00 49.16           C  
ATOM   2191  O   THR   292      23.529  -7.930 -12.921  1.00 48.79           O  
ATOM   2192  CB  THR   292      25.703  -6.186 -11.143  1.00 48.95           C  
ATOM   2193  OG1 THR   292      25.250  -7.297 -10.356  1.00 50.84           O  
ATOM   2194  CG2 THR   292      25.770  -4.949 -10.307  1.00 46.35           C  
ATOM   2195  N   ASP   293      25.702  -7.828 -13.561  1.00 50.04           N  
ATOM   2196  CA  ASP   293      25.686  -9.165 -14.146  1.00 51.52           C  
ATOM   2197  C   ASP   293      25.922 -10.287 -13.124  1.00 49.74           C  
ATOM   2198  O   ASP   293      25.258 -11.309 -13.205  1.00 48.01           O  
ATOM   2199  CB  ASP   293      26.698  -9.294 -15.298  1.00 54.21           C  
ATOM   2200  CG  ASP   293      28.150  -9.077 -14.857  1.00 59.78           C  
ATOM   2201  OD1 ASP   293      28.405  -8.547 -13.750  1.00 65.09           O  
ATOM   2202  OD2 ASP   293      29.048  -9.430 -15.645  1.00 72.52           O  
ATOM   2203  N   THR   294      26.840 -10.111 -12.170  1.00 49.18           N  
ATOM   2204  CA  THR   294      27.170 -11.225 -11.231  1.00 51.89           C  
ATOM   2205  C   THR   294      26.646 -11.106  -9.783  1.00 50.82           C  
ATOM   2206  O   THR   294      26.422 -12.115  -9.128  1.00 53.77           O  
ATOM   2207  CB  THR   294      28.695 -11.537 -11.205  1.00 51.02           C  
ATOM   2208  OG1 THR   294      29.416 -10.394 -10.734  1.00 55.62           O  
ATOM   2209  CG2 THR   294      29.192 -11.907 -12.592  1.00 48.56           C  
ATOM   2210  N   ALA   295      26.447  -9.891  -9.299  1.00 50.60           N  
ATOM   2211  CA  ALA   295      25.931  -9.652  -7.943  1.00 51.30           C  
ATOM   2212  C   ALA   295      24.421  -9.398  -7.876  1.00 51.09           C  
ATOM   2213  O   ALA   295      23.939  -8.902  -6.864  1.00 55.53           O  
ATOM   2214  CB  ALA   295      26.662  -8.445  -7.319  1.00 46.14           C  
ATOM   2215  N   GLY   296      23.684  -9.701  -8.938  1.00 50.47           N  
ATOM   2216  CA  GLY   296      22.274  -9.345  -9.021  1.00 47.00           C  
ATOM   2217  C   GLY   296      22.038  -7.833  -9.002  1.00 46.99           C  
ATOM   2218  O   GLY   296      22.866  -7.023  -9.452  1.00 47.94           O  
ATOM   2219  N   SER   297      20.890  -7.462  -8.447  1.00 45.29           N  
ATOM   2220  CA  SER   297      20.485  -6.093  -8.245  1.00 47.70           C  
ATOM   2221  C   SER   297      20.820  -5.625  -6.796  1.00 46.66           C  
ATOM   2222  O   SER   297      20.489  -6.288  -5.816  1.00 44.07           O  
ATOM   2223  CB  SER   297      18.998  -5.935  -8.600  1.00 49.61           C  
ATOM   2224  OG  SER   297      18.838  -5.667  -9.996  1.00 52.39           O  
ATOM   2225  N   ILE   298      21.514  -4.502  -6.693  1.00 45.48           N  
ATOM   2226  CA  ILE   298      21.926  -3.930  -5.421  1.00 47.62           C  
ATOM   2227  C   ILE   298      21.326  -2.541  -5.248  1.00 48.50           C  
ATOM   2228  O   ILE   298      21.430  -1.691  -6.129  1.00 46.75           O  
ATOM   2229  CB  ILE   298      23.437  -3.863  -5.292  1.00 48.14           C  
ATOM   2230  CG1 ILE   298      24.008  -5.275  -5.412  1.00 52.40           C  
ATOM   2231  CG2 ILE   298      23.839  -3.298  -3.937  1.00 46.53           C  
ATOM   2232  CD1 ILE   298      25.442  -5.340  -5.113  1.00 58.92           C  
ATOM   2233  N   PHE   299      20.665  -2.360  -4.103  1.00 47.41           N  
ATOM   2234  CA  PHE   299      19.949  -1.156  -3.780  1.00 46.70           C  
ATOM   2235  C   PHE   299      20.528  -0.494  -2.544  1.00 46.08           C  
ATOM   2236  O   PHE   299      20.912  -1.168  -1.560  1.00 43.64           O  
ATOM   2237  CB  PHE   299      18.478  -1.497  -3.523  1.00 48.44           C  
ATOM   2238  CG  PHE   299      17.602  -0.290  -3.232  1.00 47.77           C  
ATOM   2239  CD1 PHE   299      17.231   0.577  -4.250  1.00 54.31           C  
ATOM   2240  CD2 PHE   299      17.121  -0.051  -1.962  1.00 51.44           C  
ATOM   2241  CE1 PHE   299      16.429   1.664  -3.983  1.00 58.81           C  
ATOM   2242  CE2 PHE   299      16.302   1.044  -1.694  1.00 53.15           C  
ATOM   2243  CZ  PHE   299      15.966   1.892  -2.684  1.00 50.25           C  
ATOM   2244  N   VAL   300      20.611   0.835  -2.631  1.00 45.97           N  
ATOM   2245  CA  VAL   300      21.075   1.669  -1.543  1.00 48.52           C  
ATOM   2246  C   VAL   300      20.181   2.923  -1.440  1.00 47.59           C  
ATOM   2247  O   VAL   300      19.665   3.417  -2.434  1.00 46.65           O  
ATOM   2248  CB  VAL   300      22.596   2.002  -1.680  1.00 46.77           C  
ATOM   2249  CG1 VAL   300      22.890   2.751  -2.965  1.00 43.95           C  
ATOM   2250  CG2 VAL   300      23.089   2.794  -0.501  1.00 60.08           C  
ATOM   2251  N   ALA   301      19.992   3.392  -0.208  1.00 50.33           N  
ATOM   2252  CA  ALA   301      19.200   4.567   0.119  1.00 51.53           C  
ATOM   2253  C   ALA   301      19.778   5.233   1.390  1.00 53.33           C  
ATOM   2254  O   ALA   301      20.325   4.544   2.281  1.00 51.18           O  
ATOM   2255  CB  ALA   301      17.762   4.175   0.341  1.00 49.38           C  
ATOM   2256  N   GLY   302      19.701   6.569   1.436  1.00 53.20           N  
ATOM   2257  CA  GLY   302      20.105   7.365   2.605  1.00 55.07           C  
ATOM   2258  C   GLY   302      19.862   8.871   2.399  1.00 58.52           C  
ATOM   2259  O   GLY   302      19.121   9.260   1.513  1.00 56.23           O  
ATOM   2260  N   ARG   303      20.488   9.717   3.224  1.00 59.94           N  
ATOM   2261  CA  ARG   303      20.404  11.197   3.094  1.00 62.24           C  
ATOM   2262  C   ARG   303      21.276  11.642   1.924  1.00 64.44           C  
ATOM   2263  O   ARG   303      22.448  11.243   1.845  1.00 68.05           O  
ATOM   2264  CB  ARG   303      20.869  11.921   4.391  1.00 63.46           C  
ATOM   2265  CG  ARG   303      19.777  12.296   5.367  1.00 65.42           C  
ATOM   2266  CD  ARG   303      18.777  11.215   5.621  1.00 63.53           C  
ATOM   2267  NE  ARG   303      17.603  11.763   6.311  1.00 68.32           N  
ATOM   2268  N   GLY   304      20.724  12.474   1.041  1.00 61.92           N  
ATOM   2269  CA  GLY   304      21.473  12.933  -0.135  1.00 62.60           C  
ATOM   2270  C   GLY   304      22.240  14.246  -0.001  1.00 64.51           C  
ATOM   2271  O   GLY   304      22.921  14.670  -0.953  1.00 64.41           O  
ATOM   2272  N   ALA   305      22.127  14.880   1.170  1.00 64.80           N  
ATOM   2273  CA  ALA   305      22.749  16.192   1.444  1.00 67.40           C  
ATOM   2274  C   ALA   305      22.657  16.541   2.944  1.00 69.25           C  
ATOM   2275  O   ALA   305      22.008  15.827   3.739  1.00 71.21           O  
ATOM   2276  CB  ALA   305      22.084  17.306   0.597  1.00 64.41           C  
ATOM   2277  N   GLY   306      23.261  17.669   3.312  1.00 68.12           N  
ATOM   2278  CA  GLY   306      23.350  18.082   4.708  1.00 65.78           C  
ATOM   2279  C   GLY   306      24.808  18.328   5.029  1.00 64.76           C  
ATOM   2280  O   GLY   306      25.708  17.837   4.332  1.00 63.93           O  
ATOM   2281  N   LYS   307      25.046  19.108   6.073  1.00 62.64           N  
ATOM   2282  CA  LYS   307      26.399  19.476   6.443  1.00 62.49           C  
ATOM   2283  C   LYS   307      27.186  18.288   6.978  1.00 59.09           C  
ATOM   2284  O   LYS   307      28.273  17.993   6.470  1.00 59.47           O  
ATOM   2285  CB  LYS   307      26.409  20.646   7.456  1.00 61.25           C  
ATOM   2286  CG  LYS   307      27.799  20.931   7.994  1.00 64.49           C  
ATOM   2287  CD  LYS   307      27.953  22.314   8.630  1.00 66.08           C  
ATOM   2288  CE  LYS   307      27.276  22.452   9.964  1.00 72.37           C  
ATOM   2289  NZ  LYS   307      27.655  23.784  10.595  1.00 74.14           N  
ATOM   2290  N   GLU   308      26.636  17.617   7.989  1.00 59.41           N  
ATOM   2291  CA  GLU   308      27.331  16.507   8.639  1.00 60.01           C  
ATOM   2292  C   GLU   308      27.386  15.318   7.665  1.00 58.28           C  
ATOM   2293  O   GLU   308      28.396  14.646   7.582  1.00 57.19           O  
ATOM   2294  CB  GLU   308      26.672  16.146   9.994  1.00 62.01           C  
ATOM   2295  CG  GLU   308      27.710  15.741  11.112  1.00 64.45           C  
ATOM   2296  CD  GLU   308      27.100  15.204  12.438  1.00 66.17           C  
ATOM   2297  OE1 GLU   308      26.057  14.504  12.406  1.00 74.01           O  
ATOM   2298  OE2 GLU   308      27.705  15.442  13.523  1.00 82.29           O  
ATOM   2299  N   GLU   309      26.323  15.131   6.884  1.00 56.89           N  
ATOM   2300  CA  GLU   309      26.215  14.060   5.906  1.00 57.35           C  
ATOM   2301  C   GLU   309      27.263  14.198   4.803  1.00 57.25           C  
ATOM   2302  O   GLU   309      27.924  13.219   4.446  1.00 56.95           O  
ATOM   2303  CB  GLU   309      24.797  14.007   5.285  1.00 59.26           C  
ATOM   2304  CG  GLU   309      23.674  13.493   6.241  1.00 63.49           C  
ATOM   2305  CD  GLU   309      23.312  14.466   7.369  1.00 73.49           C  
ATOM   2306  OE1 GLU   309      23.256  15.706   7.132  1.00 72.66           O  
ATOM   2307  OE2 GLU   309      23.080  13.975   8.495  1.00 76.48           O  
ATOM   2308  N   THR   310      27.432  15.404   4.266  1.00 54.46           N  
ATOM   2309  CA  THR   310      28.431  15.620   3.229  1.00 51.76           C  
ATOM   2310  C   THR   310      29.824  15.483   3.822  1.00 52.76           C  
ATOM   2311  O   THR   310      30.729  14.912   3.197  1.00 55.41           O  
ATOM   2312  CB  THR   310      28.256  16.986   2.567  1.00 53.49           C  
ATOM   2313  OG1 THR   310      26.956  17.041   1.990  1.00 55.20           O  
ATOM   2314  CG2 THR   310      29.285  17.211   1.444  1.00 52.64           C  
ATOM   2315  N   ALA   311      30.008  16.034   5.019  1.00 50.52           N  
ATOM   2316  CA  ALA   311      31.277  15.932   5.720  1.00 49.19           C  
ATOM   2317  C   ALA   311      31.689  14.452   5.889  1.00 48.65           C  
ATOM   2318  O   ALA   311      32.884  14.124   5.745  1.00 49.41           O  
ATOM   2319  CB  ALA   311      31.169  16.616   7.114  1.00 47.13           C  
ATOM   2320  N   SER   312      30.723  13.599   6.263  1.00 46.95           N  
ATOM   2321  CA  SER   312      30.915  12.131   6.434  1.00 50.66           C  
ATOM   2322  C   SER   312      31.468  11.472   5.178  1.00 46.93           C  
ATOM   2323  O   SER   312      32.356  10.659   5.257  1.00 50.54           O  
ATOM   2324  CB  SER   312      29.588  11.393   6.731  1.00 51.96           C  
ATOM   2325  OG  SER   312      29.093  11.705   8.000  1.00 67.21           O  
ATOM   2326  N   ALA   313      30.857  11.775   4.046  1.00 44.96           N  
ATOM   2327  CA  ALA   313      31.306  11.265   2.741  1.00 46.84           C  
ATOM   2328  C   ALA   313      32.756  11.664   2.510  1.00 45.11           C  
ATOM   2329  O   ALA   313      33.556  10.848   2.101  1.00 48.10           O  
ATOM   2330  CB  ALA   313      30.397  11.801   1.619  1.00 44.44           C  
ATOM   2331  N   ILE   314      33.097  12.925   2.792  1.00 47.45           N  
ATOM   2332  CA  ILE   314      34.449  13.394   2.616  1.00 46.75           C  
ATOM   2333  C   ILE   314      35.403  12.565   3.491  1.00 47.25           C  
ATOM   2334  O   ILE   314      36.446  12.090   3.020  1.00 45.24           O  
ATOM   2335  CB  ILE   314      34.558  14.915   2.895  1.00 47.78           C  
ATOM   2336  CG1 ILE   314      33.914  15.679   1.745  1.00 48.95           C  
ATOM   2337  CG2 ILE   314      36.023  15.318   3.057  1.00 44.35           C  
ATOM   2338  CD1 ILE   314      33.797  17.158   1.936  1.00 51.85           C  
ATOM   2339  N   LEU   315      35.031  12.368   4.753  1.00 48.16           N  
ATOM   2340  CA  LEU   315      35.822  11.560   5.653  1.00 49.56           C  
ATOM   2341  C   LEU   315      35.978  10.110   5.207  1.00 49.36           C  
ATOM   2342  O   LEU   315      37.047   9.538   5.409  1.00 47.25           O  
ATOM   2343  CB  LEU   315      35.255  11.563   7.078  1.00 51.04           C  
ATOM   2344  CG  LEU   315      35.854  12.567   8.060  1.00 59.62           C  
ATOM   2345  CD1 LEU   315      35.674  14.044   7.569  1.00 51.16           C  
ATOM   2346  CD2 LEU   315      35.221  12.282   9.446  1.00 52.56           C  
ATOM   2347  N   SER   316      34.923   9.512   4.640  1.00 49.02           N  
ATOM   2348  CA  SER   316      34.996   8.106   4.182  1.00 47.88           C  
ATOM   2349  C   SER   316      36.082   8.026   3.098  1.00 47.56           C  
ATOM   2350  O   SER   316      36.860   7.078   3.063  1.00 49.39           O  
ATOM   2351  CB  SER   316      33.642   7.620   3.698  1.00 48.36           C  
ATOM   2352  OG  SER   316      33.242   8.292   2.495  1.00 55.46           O  
ATOM   2353  N   ASP   317      36.191   9.078   2.273  1.00 46.72           N  
ATOM   2354  CA  ASP   317      37.227   9.137   1.230  1.00 46.53           C  
ATOM   2355  C   ASP   317      38.627   9.292   1.807  1.00 50.16           C  
ATOM   2356  O   ASP   317      39.573   8.696   1.312  1.00 53.23           O  
ATOM   2357  CB  ASP   317      36.938  10.256   0.239  1.00 41.60           C  
ATOM   2358  CG  ASP   317      35.834   9.908  -0.751  1.00 43.80           C  
ATOM   2359  OD1 ASP   317      35.538   8.695  -0.958  1.00 52.19           O  
ATOM   2360  OD2 ASP   317      35.326  10.862  -1.390  1.00 50.91           O  
ATOM   2361  N   LEU   318      38.760  10.086   2.862  1.00 52.68           N  
ATOM   2362  CA  LEU   318      40.060  10.306   3.503  1.00 52.67           C  
ATOM   2363  C   LEU   318      40.528   8.961   4.104  1.00 50.21           C  
ATOM   2364  O   LEU   318      41.663   8.570   3.915  1.00 48.06           O  
ATOM   2365  CB  LEU   318      39.920  11.404   4.559  1.00 54.71           C  
ATOM   2366  CG  LEU   318      41.133  12.145   5.091  1.00 58.12           C  
ATOM   2367  CD1 LEU   318      41.863  12.903   3.970  1.00 62.27           C  
ATOM   2368  CD2 LEU   318      40.626  13.101   6.178  1.00 56.81           C  
ATOM   2369  N   TYR   319      39.620   8.261   4.789  1.00 48.95           N  
ATOM   2370  CA  TYR   319      39.844   6.910   5.310  1.00 50.03           C  
ATOM   2371  C   TYR   319      40.305   5.925   4.213  1.00 49.32           C  
ATOM   2372  O   TYR   319      41.253   5.163   4.388  1.00 49.39           O  
ATOM   2373  CB  TYR   319      38.543   6.354   5.911  1.00 49.58           C  
ATOM   2374  CG  TYR   319      38.735   5.000   6.509  1.00 50.71           C  
ATOM   2375  CD1 TYR   319      39.209   4.868   7.816  1.00 53.95           C  
ATOM   2376  CD2 TYR   319      38.503   3.839   5.769  1.00 49.76           C  
ATOM   2377  CE1 TYR   319      39.417   3.611   8.382  1.00 50.20           C  
ATOM   2378  CE2 TYR   319      38.715   2.570   6.332  1.00 50.70           C  
ATOM   2379  CZ  TYR   319      39.181   2.473   7.636  1.00 48.87           C  
ATOM   2380  OH  TYR   319      39.412   1.243   8.222  1.00 55.17           O  
ATOM   2381  N   GLU   320      39.610   5.942   3.087  1.00 48.44           N  
ATOM   2382  CA  GLU   320      39.949   5.081   1.969  1.00 47.40           C  
ATOM   2383  C   GLU   320      41.382   5.376   1.478  1.00 47.27           C  
ATOM   2384  O   GLU   320      42.144   4.470   1.218  1.00 47.01           O  
ATOM   2385  CB  GLU   320      38.899   5.230   0.862  1.00 48.25           C  
ATOM   2386  CG  GLU   320      39.146   4.413  -0.404  1.00 53.06           C  
ATOM   2387  CD  GLU   320      39.248   2.937  -0.131  1.00 60.01           C  
ATOM   2388  OE1 GLU   320      38.389   2.421   0.625  1.00 62.46           O  
ATOM   2389  OE2 GLU   320      40.173   2.300  -0.683  1.00 64.07           O  
ATOM   2390  N   ILE   321      41.783   6.634   1.401  1.00 47.78           N  
ATOM   2391  CA  ILE   321      43.124   6.945   0.927  1.00 46.61           C  
ATOM   2392  C   ILE   321      44.188   6.472   1.918  1.00 49.20           C  
ATOM   2393  O   ILE   321      45.181   5.905   1.503  1.00 49.99           O  
ATOM   2394  CB  ILE   321      43.345   8.474   0.697  1.00 46.65           C  
ATOM   2395  CG1 ILE   321      42.435   9.044  -0.399  1.00 47.24           C  
ATOM   2396  CG2 ILE   321      44.833   8.770   0.354  1.00 46.81           C  
ATOM   2397  CD1 ILE   321      42.475  10.581  -0.480  1.00 44.25           C  
ATOM   2398  N   TYR   322      43.944   6.659   3.217  1.00 51.37           N  
ATOM   2399  CA  TYR   322      44.955   6.426   4.255  1.00 52.11           C  
ATOM   2400  C   TYR   322      44.790   5.294   5.274  1.00 52.84           C  
ATOM   2401  O   TYR   322      45.648   5.158   6.141  1.00 52.73           O  
ATOM   2402  CB  TYR   322      45.131   7.731   5.054  1.00 52.56           C  
ATOM   2403  CG  TYR   322      45.728   8.878   4.272  1.00 50.98           C  
ATOM   2404  CD1 TYR   322      47.060   8.846   3.839  1.00 48.79           C  
ATOM   2405  CD2 TYR   322      44.983  10.011   4.001  1.00 45.02           C  
ATOM   2406  CE1 TYR   322      47.617   9.924   3.125  1.00 52.27           C  
ATOM   2407  CE2 TYR   322      45.528  11.084   3.301  1.00 45.41           C  
ATOM   2408  CZ  TYR   322      46.823  11.035   2.861  1.00 48.21           C  
ATOM   2409  OH  TYR   322      47.315  12.106   2.173  1.00 52.00           O  
ATOM   2410  N   ALA   323      43.736   4.487   5.217  1.00 53.51           N  
ATOM   2411  CA  ALA   323      43.591   3.392   6.196  1.00 53.48           C  
ATOM   2412  C   ALA   323      44.597   2.246   5.980  1.00 58.30           C  
ATOM   2413  O   ALA   323      44.793   1.789   4.856  1.00 59.82           O  
ATOM   2414  CB  ALA   323      42.200   2.847   6.174  1.00 53.05           C  
ATOM   2415  N   GLY   324      45.207   1.768   7.069  1.00 60.94           N  
ATOM   2416  CA  GLY   324      46.171   0.668   7.002  1.00 63.08           C  
ATOM   2417  C   GLY   324      46.514   0.095   8.376  1.00 65.62           C  
ATOM   2418  O   GLY   324      47.440  -0.725   8.525  1.00 67.71           O  
END
