
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   76 (  611),  selected   76 , name 2o3g_A
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2o3g_A.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E   180_A      D       5           -
LGA    -       -      E       6           -
LGA    -       -      I       7           -
LGA    S   181_A      V       8          5.695
LGA    -       -      Q       9           -
LGA    -       -      R      10           -
LGA    -       -      E      11           -
LGA    -       -      D      12           -
LGA    -       -      G      13           -
LGA    -       -      S      14           -
LGA    L   182_A      W      15          1.287
LGA    T   183_A      L      16          0.854
LGA    V   184_A      V      17          0.843
LGA    E   185_A      D      18          0.404
LGA    G   186_A      G      19          0.538
LGA    A   187_A      M      20          1.139
LGA    L   188_A      V      21          0.586
LGA    E   189_A      S      22          0.867
LGA    Y   190_A      L      23          0.967
LGA    V   191_A      D      24          1.033
LGA    E   192_A      R      25          0.861
LGA    L   193_A      F      26          0.586
LGA    A   194_A      R      27          0.666
LGA    P   195_A      E      28          0.838
LGA    Q   196_A      F      29          0.758
LGA    L   197_A      F      30          0.443
LGA    N   198_A      E      31          1.096
LGA    L   199_A      L      32          1.466
LGA    P   200_A      E      33          2.713
LGA    Q   201_A      A      34          4.641
LGA    Q   202_A      P      35          3.724
LGA    -       -      L      36           -
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    E   203_A      E      39           #
LGA    E   204_A      A      40          5.566
LGA    D   205_A      G      41          2.292
LGA    A   206_A      G      42          2.432
LGA    D   207_A      N      43          4.754
LGA    F   208_A      I      44          1.989
LGA    H   209_A      H      45          1.300
LGA    T   210_A      T      46          1.157
LGA    V   211_A      L      47          1.024
LGA    A   212_A      A      48          1.016
LGA    G   213_A      G      49          1.137
LGA    L   214_A      V      50          1.118
LGA    I   215_A      M      51          1.301
LGA    X   216_A      L      52          1.409
LGA    E   217_A      Y      53          1.213
LGA    E   218_A      Q      54          1.544
LGA    L   219_A      L      55          1.824
LGA    Q   220_A      G      56          3.177
LGA    T   221_A      R      57          4.058
LGA    I   222_A      V      58          1.630
LGA    P   223_A      P      59          0.861
LGA    D   224_A      S      60          0.855
LGA    V   225_A      V      61          0.975
LGA    G   226_A      T      62          1.092
LGA    D   227_A      D      63          0.817
LGA    F   228_A      R      64          1.655
LGA    A   229_A      F      65          2.546
LGA    D   230_A      E      66          1.950
LGA    F   231_A      W      67          1.764
LGA    H   232_A      N      68          1.524
LGA    G   233_A      G      69          1.169
LGA    W   234_A      F      70          0.575
LGA    R   235_A      S      71          0.918
LGA    F   236_A      F      72          0.929
LGA    E   237_A      E      73          1.033
LGA    V   238_A      V      74          1.061
LGA    V   239_A      V      75          0.869
LGA    E   240_A      D      76          1.066
LGA    K   241_A      M      77          0.883
LGA    E   242_A      D      78          1.272
LGA    G   243_A      R      79          1.541
LGA    Q   244_A      T      80          0.942
LGA    R   245_A      R      81          0.532
LGA    I   246_A      V      82          0.781
LGA    E   247_A      D      83          0.712
LGA    R   248_A      K      84          0.749
LGA    V   249_A      I      85          0.739
LGA    K   250_A      L      86          0.685
LGA    I   251_A      V      87          0.513
LGA    T   252_A      Q      88          1.522
LGA    K   253_A      R      89          2.746
LGA    -       -      H      90           -
LGA    L   254_A      H      91           #
LGA    P   255_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   76   87    5.0     72    1.88    23.61     76.177     3.633

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.300818 * X  +   0.299436 * Y  +  -0.905454 * Z  +  49.004066
  Y_new =   0.709168 * X  +  -0.705036 * Y  +   0.002449 * Z  +  12.757528
  Z_new =  -0.637644 * X  +  -0.642855 * Y  +  -0.424438 * Z  +  76.408211 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.154336    0.987257  [ DEG:  -123.4344     56.5656 ]
  Theta =   0.691436    2.450157  [ DEG:    39.6163    140.3837 ]
  Phi   =   1.169616   -1.971977  [ DEG:    67.0141   -112.9859 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2o3g_A                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2o3g_A.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   76   87   5.0   72   1.88   23.61  76.177
REMARK  ---------------------------------------------------------- 
MOLECULE 2o3g_A
HEADER    MEMBRANE PROTEIN                        01-DEC-06   2O3G              
TITLE     STRUCTURAL GENOMICS, THE CRYSTAL STRUCTURE OF A CONSERVED             
TITLE    2 PUTATIVE DOMAIN FROM NEISSERIA MENINGITIDIS MC58                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE PROTEIN;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 428-516;                                          
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NEISSERIA MENINGITIDIS SEROGROUP B;             
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: MC58;                                                        
SOURCE   5 GENE: NMB1485;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG19                                   
KEYWDS    APC85631.1, CONSERVED PUTATIVE PROTEIN, NEISSERIA                     
KEYWDS   2 MENINGITIDIS MC58, STRUCTURAL GENOMICS, PSI-2, PROTEIN               
KEYWDS   3 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   4 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.TAN,L.VOLKART,M.GU,A.JOACHIMIAK,MIDWEST CENTER FOR                  
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   02-JAN-07 2O3G    0                                                
JRNL        AUTH   K.TAN,L.VOLKART,M.GU,A.JOACHIMIAK                            
JRNL        TITL   THE CRYSTAL STRUCTURE OF A CONSERVED PUTATIVE                
JRNL        TITL 2 DOMAIN FROM NEISSERIA MENINGITIDIS MC58                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.55 ANGSTROMS.                                          
DBREF  2O3G A  167   255  UNP    Q9JYP7   Q9JYP7_NEIMB   428    516             
SEQRES   1 A   92  SER ASN ALA GLU ARG GLU GLU GLU PRO ALA VAL GLN GLY          
SEQRES   2 A   92  ASN PRO ASP GLU SER LEU THR VAL GLU GLY ALA LEU GLU          
SEQRES   3 A   92  TYR VAL GLU LEU ALA PRO GLN LEU ASN LEU PRO GLN GLN          
SEQRES   4 A   92  GLU GLU ASP ALA ASP PHE HIS THR VAL ALA GLY LEU ILE          
SEQRES   5 A   92  MSE GLU GLU LEU GLN THR ILE PRO ASP VAL GLY ASP PHE          
SEQRES   6 A   92  ALA ASP PHE HIS GLY TRP ARG PHE GLU VAL VAL GLU LYS          
SEQRES   7 A   92  GLU GLY GLN ARG ILE GLU ARG VAL LYS ILE THR LYS LEU          
SEQRES   8 A   92  PRO                                                          
HET    MSE  A 216       8                                                       
HET    EDO    101       4                                                       
HET    EDO    102       4                                                       
HET    EDO    103       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    C5 H11 N O2 SE                                               
FORMUL   2  EDO    3(C2 H6 O2)                                                  
FORMUL   5  HOH   *6(H2 O)                                                      
CRYST1  129.828  129.828  129.828  90.00  90.00  90.00 I 4 3 2      48          
ATOM      1  N   GLU A 180      17.319  -5.314  22.834  1.00 77.35           N  
ATOM      2  CA  GLU A 180      18.196  -4.532  21.891  1.00 77.44           C  
ATOM      3  C   GLU A 180      19.089  -3.379  22.478  1.00 75.85           C  
ATOM      4  O   GLU A 180      18.628  -2.235  22.702  1.00 74.70           O  
ATOM      5  CB  GLU A 180      17.374  -4.013  20.697  1.00 78.36           C  
ATOM      6  CG  GLU A 180      17.523  -4.831  19.410  1.00 81.80           C  
ATOM      7  CD  GLU A 180      18.673  -4.332  18.499  1.00 87.43           C  
ATOM      8  OE1 GLU A 180      19.861  -4.555  18.865  1.00 88.97           O  
ATOM      9  OE2 GLU A 180      18.382  -3.749  17.404  1.00 87.37           O  
ATOM     10  N   SER A 181      20.366  -3.746  22.727  1.00 74.03           N  
ATOM     11  CA  SER A 181      21.614  -2.861  22.673  1.00 70.05           C  
ATOM     12  C   SER A 181      21.689  -1.423  21.969  1.00 69.19           C  
ATOM     13  O   SER A 181      21.985  -1.317  20.731  1.00 69.14           O  
ATOM     14  CB  SER A 181      22.834  -3.732  22.197  1.00 71.00           C  
ATOM     15  OG  SER A 181      22.773  -4.099  20.818  1.00 68.14           O  
ATOM     16  N   LEU A 182      21.507  -0.354  22.781  1.00 66.34           N  
ATOM     17  CA  LEU A 182      21.796   1.068  22.386  1.00 64.16           C  
ATOM     18  C   LEU A 182      20.865   1.697  21.366  1.00 60.87           C  
ATOM     19  O   LEU A 182      21.259   1.998  20.192  1.00 61.00           O  
ATOM     20  CB  LEU A 182      23.164   1.167  21.805  1.00 63.04           C  
ATOM     21  CG  LEU A 182      24.213   1.044  22.849  1.00 63.33           C  
ATOM     22  CD1 LEU A 182      25.373   0.676  21.926  1.00 65.03           C  
ATOM     23  CD2 LEU A 182      24.350   2.350  23.624  1.00 59.13           C  
ATOM     24  N   THR A 183      19.623   1.882  21.774  1.00 56.39           N  
ATOM     25  CA  THR A 183      18.663   2.342  20.815  1.00 53.23           C  
ATOM     26  C   THR A 183      17.716   3.262  21.533  1.00 51.30           C  
ATOM     27  O   THR A 183      17.429   3.107  22.718  1.00 50.88           O  
ATOM     28  CB  THR A 183      17.879   1.165  20.165  1.00 53.21           C  
ATOM     29  OG1 THR A 183      17.302   0.412  21.210  1.00 49.66           O  
ATOM     30  CG2 THR A 183      18.756   0.267  19.302  1.00 49.69           C  
ATOM     31  N   VAL A 184      17.234   4.237  20.799  1.00 48.96           N  
ATOM     32  CA  VAL A 184      16.317   5.191  21.393  1.00 46.69           C  
ATOM     33  C   VAL A 184      15.192   5.295  20.434  1.00 47.30           C  
ATOM     34  O   VAL A 184      15.290   4.934  19.202  1.00 45.68           O  
ATOM     35  CB  VAL A 184      16.915   6.604  21.544  1.00 46.10           C  
ATOM     36  CG1 VAL A 184      17.920   6.626  22.630  1.00 44.70           C  
ATOM     37  CG2 VAL A 184      17.497   7.028  20.271  1.00 38.42           C  
ATOM     38  N   GLU A 185      14.111   5.783  21.019  1.00 48.47           N  
ATOM     39  CA  GLU A 185      13.023   6.257  20.197  1.00 50.95           C  
ATOM     40  C   GLU A 185      13.284   7.537  19.417  1.00 50.06           C  
ATOM     41  O   GLU A 185      13.796   8.556  19.941  1.00 50.56           O  
ATOM     42  CB  GLU A 185      11.776   6.384  21.003  1.00 52.09           C  
ATOM     43  CG  GLU A 185      11.944   7.176  22.262  1.00 59.32           C  
ATOM     44  CD  GLU A 185      10.548   7.370  22.943  1.00 69.17           C  
ATOM     45  OE1 GLU A 185      10.306   8.478  23.598  1.00 71.48           O  
ATOM     46  OE2 GLU A 185       9.719   6.394  22.763  1.00 64.12           O  
ATOM     47  N   GLY A 186      12.936   7.428  18.144  1.00 48.96           N  
ATOM     48  CA  GLY A 186      12.784   8.548  17.232  1.00 48.06           C  
ATOM     49  C   GLY A 186      12.387   9.900  17.812  1.00 45.97           C  
ATOM     50  O   GLY A 186      12.744  10.932  17.259  1.00 46.26           O  
ATOM     51  N   ALA A 187      11.681   9.897  18.910  1.00 43.63           N  
ATOM     52  CA  ALA A 187      11.047  11.069  19.359  1.00 44.13           C  
ATOM     53  C   ALA A 187      11.687  11.401  20.631  1.00 45.02           C  
ATOM     54  O   ALA A 187      11.148  12.147  21.418  1.00 46.91           O  
ATOM     55  CB  ALA A 187       9.562  10.770  19.639  1.00 44.33           C  
ATOM     56  N   LEU A 188      12.824  10.815  20.935  1.00 46.32           N  
ATOM     57  CA  LEU A 188      13.592  11.365  22.077  1.00 45.44           C  
ATOM     58  C   LEU A 188      13.998  12.790  21.643  1.00 44.78           C  
ATOM     59  O   LEU A 188      14.318  13.074  20.436  1.00 44.32           O  
ATOM     60  CB  LEU A 188      14.854  10.548  22.278  1.00 44.86           C  
ATOM     61  CG  LEU A 188      15.191  10.312  23.727  1.00 43.71           C  
ATOM     62  CD1 LEU A 188      16.675  10.389  23.774  1.00 43.04           C  
ATOM     63  CD2 LEU A 188      14.528  11.154  24.837  1.00 32.05           C  
ATOM     64  N   GLU A 189      13.949  13.667  22.613  1.00 43.54           N  
ATOM     65  CA  GLU A 189      14.368  15.048  22.413  1.00 43.75           C  
ATOM     66  C   GLU A 189      15.873  15.164  22.495  1.00 42.17           C  
ATOM     67  O   GLU A 189      16.484  14.775  23.492  1.00 40.66           O  
ATOM     68  CB  GLU A 189      13.727  15.938  23.500  1.00 43.51           C  
ATOM     69  CG  GLU A 189      12.230  16.135  23.212  1.00 45.20           C  
ATOM     70  CD  GLU A 189      11.486  16.981  24.188  1.00 51.75           C  
ATOM     71  OE1 GLU A 189      11.942  17.211  25.332  1.00 53.40           O  
ATOM     72  OE2 GLU A 189      10.369  17.427  23.809  1.00 61.98           O  
ATOM     73  N   TYR A 190      16.437  15.723  21.450  1.00 42.21           N  
ATOM     74  CA  TYR A 190      17.824  16.133  21.450  1.00 44.23           C  
ATOM     75  C   TYR A 190      18.260  16.737  22.724  1.00 44.76           C  
ATOM     76  O   TYR A 190      19.329  16.426  23.243  1.00 46.37           O  
ATOM     77  CB  TYR A 190      18.090  17.110  20.396  1.00 43.98           C  
ATOM     78  CG  TYR A 190      19.546  17.330  20.176  1.00 42.97           C  
ATOM     79  CD1 TYR A 190      20.217  16.659  19.190  1.00 43.19           C  
ATOM     80  CD2 TYR A 190      20.227  18.228  20.924  1.00 44.61           C  
ATOM     81  CE1 TYR A 190      21.575  16.842  18.969  1.00 42.92           C  
ATOM     82  CE2 TYR A 190      21.592  18.463  20.714  1.00 48.61           C  
ATOM     83  CZ  TYR A 190      22.251  17.748  19.722  1.00 45.09           C  
ATOM     84  OH  TYR A 190      23.591  17.993  19.508  1.00 44.74           O  
ATOM     85  N   VAL A 191      17.385  17.490  23.322  1.00 44.83           N  
ATOM     86  CA  VAL A 191      17.759  18.153  24.536  1.00 45.78           C  
ATOM     87  C   VAL A 191      17.919  17.165  25.629  1.00 46.21           C  
ATOM     88  O   VAL A 191      18.507  17.433  26.661  1.00 46.82           O  
ATOM     89  CB  VAL A 191      16.700  19.248  24.796  1.00 46.37           C  
ATOM     90  CG1 VAL A 191      16.417  19.480  26.268  1.00 47.96           C  
ATOM     91  CG2 VAL A 191      17.229  20.483  24.171  1.00 46.16           C  
ATOM     92  N   GLU A 192      17.341  15.998  25.440  1.00 48.84           N  
ATOM     93  CA  GLU A 192      17.367  14.983  26.503  1.00 50.31           C  
ATOM     94  C   GLU A 192      18.524  13.963  26.302  1.00 48.35           C  
ATOM     95  O   GLU A 192      19.212  13.659  27.245  1.00 47.71           O  
ATOM     96  CB  GLU A 192      16.000  14.301  26.606  1.00 52.04           C  
ATOM     97  CG  GLU A 192      14.908  15.107  27.490  1.00 60.70           C  
ATOM     98  CD  GLU A 192      15.279  15.357  29.002  1.00 72.44           C  
ATOM     99  OE1 GLU A 192      15.868  14.420  29.642  1.00 74.77           O  
ATOM    100  OE2 GLU A 192      14.971  16.493  29.550  1.00 75.57           O  
ATOM    101  N   LEU A 193      18.698  13.468  25.073  1.00 46.47           N  
ATOM    102  CA  LEU A 193      19.797  12.634  24.648  1.00 45.96           C  
ATOM    103  C   LEU A 193      21.156  13.347  24.796  1.00 46.27           C  
ATOM    104  O   LEU A 193      22.060  12.821  25.447  1.00 47.23           O  
ATOM    105  CB  LEU A 193      19.634  12.344  23.177  1.00 44.79           C  
ATOM    106  CG  LEU A 193      20.117  10.989  22.643  1.00 45.51           C  
ATOM    107  CD1 LEU A 193      20.718  11.184  21.302  1.00 40.61           C  
ATOM    108  CD2 LEU A 193      21.067  10.241  23.635  1.00 43.06           C  
ATOM    109  N   ALA A 194      21.294  14.528  24.195  1.00 45.67           N  
ATOM    110  CA  ALA A 194      22.600  15.209  24.044  1.00 44.97           C  
ATOM    111  C   ALA A 194      23.391  15.393  25.298  1.00 43.94           C  
ATOM    112  O   ALA A 194      24.512  15.015  25.364  1.00 45.68           O  
ATOM    113  CB  ALA A 194      22.460  16.509  23.340  1.00 45.28           C  
ATOM    114  N   PRO A 195      22.802  15.879  26.342  1.00 43.62           N  
ATOM    115  CA  PRO A 195      23.617  16.012  27.525  1.00 42.91           C  
ATOM    116  C   PRO A 195      24.087  14.686  27.973  1.00 44.77           C  
ATOM    117  O   PRO A 195      24.969  14.560  28.745  1.00 46.01           O  
ATOM    118  CB  PRO A 195      22.642  16.444  28.571  1.00 41.08           C  
ATOM    119  CG  PRO A 195      21.426  16.857  27.874  1.00 42.07           C  
ATOM    120  CD  PRO A 195      21.403  16.281  26.535  1.00 44.08           C  
ATOM    121  N   GLN A 196      23.467  13.631  27.559  1.00 48.14           N  
ATOM    122  CA  GLN A 196      23.975  12.363  28.032  1.00 49.83           C  
ATOM    123  C   GLN A 196      25.087  11.862  27.097  1.00 48.35           C  
ATOM    124  O   GLN A 196      25.906  11.123  27.532  1.00 50.00           O  
ATOM    125  CB  GLN A 196      22.844  11.315  28.009  1.00 49.63           C  
ATOM    126  CG  GLN A 196      21.837  11.231  29.192  1.00 52.82           C  
ATOM    127  CD  GLN A 196      20.706  10.184  28.840  1.00 55.72           C  
ATOM    128  OE1 GLN A 196      20.772   8.987  29.227  1.00 65.11           O  
ATOM    129  NE2 GLN A 196      19.729  10.621  28.031  1.00 56.69           N  
ATOM    130  N   LEU A 197      25.044  12.091  25.801  1.00 45.79           N  
ATOM    131  CA  LEU A 197      26.147  11.636  25.008  1.00 44.25           C  
ATOM    132  C   LEU A 197      27.223  12.768  24.810  1.00 45.55           C  
ATOM    133  O   LEU A 197      27.971  12.802  23.820  1.00 46.54           O  
ATOM    134  CB  LEU A 197      25.581  11.195  23.690  1.00 41.46           C  
ATOM    135  CG  LEU A 197      25.208   9.720  23.655  1.00 44.70           C  
ATOM    136  CD1 LEU A 197      24.655   9.294  25.038  1.00 37.81           C  
ATOM    137  CD2 LEU A 197      24.357   9.365  22.420  1.00 37.77           C  
ATOM    138  N   ASN A 198      27.268  13.754  25.689  1.00 45.57           N  
ATOM    139  CA  ASN A 198      27.887  15.038  25.305  1.00 45.14           C  
ATOM    140  C   ASN A 198      27.760  15.469  23.895  1.00 44.52           C  
ATOM    141  O   ASN A 198      28.753  15.886  23.323  1.00 46.78           O  
ATOM    142  CB  ASN A 198      29.357  15.015  25.659  1.00 43.99           C  
ATOM    143  CG  ASN A 198      29.510  15.011  27.128  1.00 45.91           C  
ATOM    144  OD1 ASN A 198      28.566  15.431  27.809  1.00 46.16           O  
ATOM    145  ND2 ASN A 198      30.621  14.492  27.666  1.00 49.44           N  
ATOM    146  N   LEU A 199      26.605  15.346  23.283  1.00 43.10           N  
ATOM    147  CA  LEU A 199      26.476  15.929  21.934  1.00 43.10           C  
ATOM    148  C   LEU A 199      26.560  17.436  21.964  1.00 43.57           C  
ATOM    149  O   LEU A 199      26.271  18.081  22.963  1.00 41.28           O  
ATOM    150  CB  LEU A 199      25.162  15.571  21.295  1.00 42.39           C  
ATOM    151  CG  LEU A 199      25.089  14.092  21.052  1.00 42.62           C  
ATOM    152  CD1 LEU A 199      23.700  13.635  20.673  1.00 43.57           C  
ATOM    153  CD2 LEU A 199      26.045  13.882  19.945  1.00 41.55           C  
ATOM    154  N   PRO A 200      26.906  18.033  20.837  1.00 44.43           N  
ATOM    155  CA  PRO A 200      27.111  19.433  21.022  1.00 46.22           C  
ATOM    156  C   PRO A 200      25.735  20.298  21.112  1.00 47.03           C  
ATOM    157  O   PRO A 200      24.740  20.028  20.455  1.00 45.59           O  
ATOM    158  CB  PRO A 200      27.908  19.769  19.782  1.00 46.08           C  
ATOM    159  CG  PRO A 200      27.265  19.010  18.739  1.00 45.95           C  
ATOM    160  CD  PRO A 200      27.011  17.657  19.425  1.00 44.39           C  
ATOM    161  N   GLN A 201      25.711  21.271  21.988  1.00 48.57           N  
ATOM    162  CA  GLN A 201      24.650  22.229  22.107  1.00 50.37           C  
ATOM    163  C   GLN A 201      24.139  22.762  20.786  1.00 52.51           C  
ATOM    164  O   GLN A 201      24.903  23.095  19.904  1.00 52.99           O  
ATOM    165  CB  GLN A 201      25.236  23.365  22.899  1.00 49.93           C  
ATOM    166  CG  GLN A 201      24.457  24.659  22.907  1.00 46.80           C  
ATOM    167  CD  GLN A 201      23.255  24.609  23.832  1.00 40.89           C  
ATOM    168  OE1 GLN A 201      23.298  24.133  25.013  1.00 37.19           O  
ATOM    169  NE2 GLN A 201      22.138  25.018  23.275  1.00 41.03           N  
ATOM    170  N   GLN A 202      22.832  22.846  20.639  1.00 55.89           N  
ATOM    171  CA  GLN A 202      22.309  23.520  19.446  1.00 60.62           C  
ATOM    172  C   GLN A 202      22.106  25.057  19.596  1.00 63.82           C  
ATOM    173  O   GLN A 202      22.033  25.621  20.722  1.00 63.35           O  
ATOM    174  CB  GLN A 202      21.059  22.820  18.880  1.00 60.33           C  
ATOM    175  CG  GLN A 202      20.302  22.055  19.918  1.00 60.36           C  
ATOM    176  CD  GLN A 202      18.885  21.678  19.493  1.00 61.70           C  
ATOM    177  OE1 GLN A 202      17.949  21.864  20.286  1.00 63.47           O  
ATOM    178  NE2 GLN A 202      18.715  21.138  18.260  1.00 55.92           N  
ATOM    179  N   GLU A 203      22.096  25.732  18.444  1.00 68.14           N  
ATOM    180  CA  GLU A 203      21.739  27.157  18.362  1.00 72.74           C  
ATOM    181  C   GLU A 203      20.232  27.357  18.559  1.00 74.79           C  
ATOM    182  O   GLU A 203      19.446  26.387  18.506  1.00 75.30           O  
ATOM    183  CB  GLU A 203      22.196  27.781  17.011  1.00 73.90           C  
ATOM    184  CG  GLU A 203      21.954  26.922  15.761  1.00 76.80           C  
ATOM    185  CD  GLU A 203      22.754  25.643  15.816  1.00 84.24           C  
ATOM    186  OE1 GLU A 203      22.185  24.566  16.183  1.00 84.77           O  
ATOM    187  OE2 GLU A 203      23.984  25.738  15.545  1.00 87.07           O  
ATOM    188  N   GLU A 204      19.823  28.612  18.755  1.00 77.20           N  
ATOM    189  CA  GLU A 204      18.400  28.973  18.705  1.00 79.39           C  
ATOM    190  C   GLU A 204      17.641  28.620  17.361  1.00 78.30           C  
ATOM    191  O   GLU A 204      16.512  28.133  17.405  1.00 77.37           O  
ATOM    192  CB  GLU A 204      18.234  30.455  19.080  1.00 79.63           C  
ATOM    193  CG  GLU A 204      18.995  30.933  20.346  1.00 82.77           C  
ATOM    194  CD  GLU A 204      19.059  32.506  20.421  1.00 83.93           C  
ATOM    195  OE1 GLU A 204      19.998  33.131  19.822  1.00 87.99           O  
ATOM    196  OE2 GLU A 204      18.149  33.111  21.063  1.00 89.16           O  
ATOM    197  N   ASP A 205      18.253  28.848  16.184  1.00 78.78           N  
ATOM    198  CA  ASP A 205      17.547  28.583  14.870  1.00 79.52           C  
ATOM    199  C   ASP A 205      17.409  27.039  14.539  1.00 77.42           C  
ATOM    200  O   ASP A 205      17.292  26.615  13.373  1.00 77.16           O  
ATOM    201  CB  ASP A 205      18.128  29.442  13.685  1.00 80.23           C  
ATOM    202  CG  ASP A 205      19.312  28.721  12.918  1.00 85.13           C  
ATOM    203  OD1 ASP A 205      20.271  28.178  13.577  1.00 84.41           O  
ATOM    204  OD2 ASP A 205      19.263  28.698  11.642  1.00 89.51           O  
ATOM    205  N   ALA A 206      17.437  26.251  15.618  1.00 75.47           N  
ATOM    206  CA  ALA A 206      17.328  24.777  15.685  1.00 72.87           C  
ATOM    207  C   ALA A 206      16.595  24.100  14.533  1.00 70.98           C  
ATOM    208  O   ALA A 206      15.385  24.267  14.386  1.00 72.09           O  
ATOM    209  CB  ALA A 206      16.603  24.442  17.014  1.00 72.73           C  
ATOM    210  N   ASP A 207      17.239  23.295  13.727  1.00 67.77           N  
ATOM    211  CA  ASP A 207      16.385  22.555  12.795  1.00 65.50           C  
ATOM    212  C   ASP A 207      15.670  21.239  13.163  1.00 63.02           C  
ATOM    213  O   ASP A 207      15.073  20.618  12.252  1.00 62.80           O  
ATOM    214  CB  ASP A 207      17.177  22.235  11.603  1.00 67.33           C  
ATOM    215  CG  ASP A 207      17.708  23.436  10.990  1.00 73.21           C  
ATOM    216  OD1 ASP A 207      16.829  24.251  10.584  1.00 79.49           O  
ATOM    217  OD2 ASP A 207      18.966  23.561  10.947  1.00 77.95           O  
ATOM    218  N   PHE A 208      15.740  20.775  14.416  1.00 58.47           N  
ATOM    219  CA  PHE A 208      15.106  19.520  14.790  1.00 55.31           C  
ATOM    220  C   PHE A 208      14.981  19.474  16.293  1.00 53.79           C  
ATOM    221  O   PHE A 208      15.588  20.250  16.954  1.00 53.32           O  
ATOM    222  CB  PHE A 208      15.838  18.306  14.192  1.00 55.53           C  
ATOM    223  CG  PHE A 208      17.337  18.221  14.531  1.00 55.98           C  
ATOM    224  CD1 PHE A 208      17.762  17.793  15.808  1.00 51.15           C  
ATOM    225  CD2 PHE A 208      18.304  18.554  13.573  1.00 51.80           C  
ATOM    226  CE1 PHE A 208      19.085  17.716  16.127  1.00 52.20           C  
ATOM    227  CE2 PHE A 208      19.644  18.487  13.901  1.00 56.92           C  
ATOM    228  CZ  PHE A 208      20.045  18.081  15.204  1.00 53.72           C  
ATOM    229  N   HIS A 209      14.144  18.650  16.868  1.00 52.21           N  
ATOM    230  CA  HIS A 209      14.174  18.654  18.316  1.00 51.81           C  
ATOM    231  C   HIS A 209      14.371  17.284  18.853  1.00 49.05           C  
ATOM    232  O   HIS A 209      14.421  17.128  20.079  1.00 47.94           O  
ATOM    233  CB  HIS A 209      12.897  19.219  18.905  1.00 53.87           C  
ATOM    234  CG  HIS A 209      12.601  20.576  18.399  1.00 62.03           C  
ATOM    235  ND1 HIS A 209      12.060  20.794  17.145  1.00 67.39           N  
ATOM    236  CD2 HIS A 209      12.857  21.798  18.930  1.00 66.98           C  
ATOM    237  CE1 HIS A 209      11.962  22.095  16.942  1.00 69.85           C  
ATOM    238  NE2 HIS A 209      12.444  22.725  18.005  1.00 68.14           N  
ATOM    239  N   THR A 210      14.454  16.313  17.935  1.00 46.77           N  
ATOM    240  CA  THR A 210      14.419  14.891  18.278  1.00 45.78           C  
ATOM    241  C   THR A 210      15.400  14.061  17.453  1.00 46.08           C  
ATOM    242  O   THR A 210      15.840  14.478  16.283  1.00 44.30           O  
ATOM    243  CB  THR A 210      12.969  14.262  18.022  1.00 46.25           C  
ATOM    244  OG1 THR A 210      12.682  14.209  16.599  1.00 46.05           O  
ATOM    245  CG2 THR A 210      11.913  15.033  18.772  1.00 42.14           C  
ATOM    246  N   VAL A 211      15.694  12.865  18.008  1.00 44.65           N  
ATOM    247  CA  VAL A 211      16.585  11.942  17.312  1.00 43.89           C  
ATOM    248  C   VAL A 211      16.071  11.745  15.911  1.00 45.12           C  
ATOM    249  O   VAL A 211      16.794  11.891  14.900  1.00 46.76           O  
ATOM    250  CB  VAL A 211      16.750  10.626  18.101  1.00 43.82           C  
ATOM    251  CG1 VAL A 211      17.750   9.725  17.438  1.00 42.86           C  
ATOM    252  CG2 VAL A 211      17.128  10.943  19.513  1.00 41.85           C  
ATOM    253  N   ALA A 212      14.790  11.481  15.807  1.00 46.18           N  
ATOM    254  CA  ALA A 212      14.255  11.193  14.477  1.00 48.06           C  
ATOM    255  C   ALA A 212      14.459  12.385  13.649  1.00 48.85           C  
ATOM    256  O   ALA A 212      14.861  12.230  12.503  1.00 50.26           O  
ATOM    257  CB  ALA A 212      12.725  10.877  14.527  1.00 47.60           C  
ATOM    258  N   GLY A 213      14.166  13.579  14.225  1.00 49.48           N  
ATOM    259  CA  GLY A 213      14.272  14.843  13.489  1.00 49.76           C  
ATOM    260  C   GLY A 213      15.698  15.042  12.996  1.00 51.35           C  
ATOM    261  O   GLY A 213      15.921  15.431  11.819  1.00 52.55           O  
ATOM    262  N   LEU A 214      16.678  14.739  13.869  1.00 51.11           N  
ATOM    263  CA  LEU A 214      18.084  14.787  13.479  1.00 51.37           C  
ATOM    264  C   LEU A 214      18.280  14.008  12.246  1.00 51.96           C  
ATOM    265  O   LEU A 214      18.897  14.501  11.292  1.00 52.66           O  
ATOM    266  CB  LEU A 214      19.022  14.330  14.620  1.00 50.34           C  
ATOM    267  CG  LEU A 214      20.373  13.619  14.531  1.00 49.14           C  
ATOM    268  CD1 LEU A 214      21.048  13.598  13.204  1.00 41.42           C  
ATOM    269  CD2 LEU A 214      21.258  14.223  15.592  1.00 50.43           C  
ATOM    270  N   ILE A 215      17.784  12.779  12.225  1.00 54.03           N  
ATOM    271  CA  ILE A 215      18.049  11.951  11.016  1.00 55.01           C  
ATOM    272  C   ILE A 215      17.477  12.571   9.774  1.00 57.86           C  
ATOM    273  O   ILE A 215      18.162  12.632   8.767  1.00 58.67           O  
ATOM    274  CB  ILE A 215      17.499  10.514  11.100  1.00 54.16           C  
ATOM    275  CG1 ILE A 215      17.998   9.828  12.371  1.00 48.59           C  
ATOM    276  CG2 ILE A 215      17.756   9.774   9.772  1.00 51.49           C  
ATOM    277  CD1 ILE A 215      17.802   8.349  12.385  1.00 47.37           C  
HETATM  278  N   MSE A 216      16.219  13.012   9.836  1.00 60.85           N  
HETATM  279  CA  MSE A 216      15.542  13.643   8.652  1.00 65.15           C  
HETATM  280  C   MSE A 216      16.244  14.864   8.166  1.00 64.37           C  
HETATM  281  O   MSE A 216      16.450  15.026   6.946  1.00 64.64           O  
HETATM  282  CB  MSE A 216      14.121  14.075   8.957  1.00 64.01           C  
HETATM  283  CG  MSE A 216      13.538  13.470  10.196  1.00 67.38           C  
HETATM  284 SE   MSE A 216      11.666  13.312   9.761  0.80 74.07          SE  
HETATM  285  CE  MSE A 216      10.670  13.265  11.504  1.00 62.66           C  
ATOM    286  N   GLU A 217      16.586  15.728   9.118  1.00 64.94           N  
ATOM    287  CA  GLU A 217      17.466  16.854   8.845  1.00 66.69           C  
ATOM    288  C   GLU A 217      18.715  16.482   8.048  1.00 67.41           C  
ATOM    289  O   GLU A 217      18.850  16.971   6.954  1.00 67.99           O  
ATOM    290  CB  GLU A 217      17.837  17.569  10.134  1.00 67.26           C  
ATOM    291  CG  GLU A 217      19.010  18.518  10.006  1.00 71.80           C  
ATOM    292  CD  GLU A 217      18.606  19.804   9.328  1.00 79.45           C  
ATOM    293  OE1 GLU A 217      17.789  19.762   8.382  1.00 81.71           O  
ATOM    294  OE2 GLU A 217      19.094  20.874   9.748  1.00 82.78           O  
ATOM    295  N   GLU A 218      19.628  15.629   8.553  1.00 68.88           N  
ATOM    296  CA  GLU A 218      20.817  15.304   7.752  1.00 69.94           C  
ATOM    297  C   GLU A 218      20.414  14.657   6.416  1.00 70.75           C  
ATOM    298  O   GLU A 218      20.761  15.163   5.380  1.00 71.83           O  
ATOM    299  CB  GLU A 218      21.891  14.532   8.538  1.00 70.68           C  
ATOM    300  CG  GLU A 218      23.092  15.407   9.158  1.00 74.15           C  
ATOM    301  CD  GLU A 218      24.387  15.569   8.234  1.00 81.13           C  
ATOM    302  OE1 GLU A 218      24.356  15.241   7.010  1.00 81.17           O  
ATOM    303  OE2 GLU A 218      25.468  16.044   8.733  1.00 85.21           O  
ATOM    304  N   LEU A 219      19.610  13.602   6.392  1.00 71.52           N  
ATOM    305  CA  LEU A 219      19.329  12.940   5.121  1.00 72.26           C  
ATOM    306  C   LEU A 219      18.686  13.861   4.116  1.00 73.51           C  
ATOM    307  O   LEU A 219      19.015  13.799   2.921  1.00 73.91           O  
ATOM    308  CB  LEU A 219      18.416  11.753   5.327  1.00 72.16           C  
ATOM    309  CG  LEU A 219      19.230  10.803   6.158  1.00 72.75           C  
ATOM    310  CD1 LEU A 219      18.321   9.829   6.860  1.00 70.76           C  
ATOM    311  CD2 LEU A 219      20.228  10.197   5.180  1.00 72.04           C  
ATOM    312  N   GLN A 220      17.786  14.721   4.624  1.00 74.05           N  
ATOM    313  CA  GLN A 220      16.907  15.540   3.814  1.00 74.54           C  
ATOM    314  C   GLN A 220      15.953  14.613   3.107  1.00 74.56           C  
ATOM    315  O   GLN A 220      15.602  14.862   1.982  1.00 74.30           O  
ATOM    316  CB  GLN A 220      17.681  16.355   2.758  1.00 74.62           C  
ATOM    317  CG  GLN A 220      18.679  17.359   3.309  1.00 77.35           C  
ATOM    318  CD  GLN A 220      17.988  18.552   3.943  1.00 80.67           C  
ATOM    319  OE1 GLN A 220      17.358  19.351   3.257  1.00 84.25           O  
ATOM    320  NE2 GLN A 220      18.107  18.681   5.250  1.00 79.80           N  
ATOM    321  N   THR A 221      15.540  13.518   3.721  1.00 74.81           N  
ATOM    322  CA  THR A 221      14.513  12.725   3.056  1.00 74.73           C  
ATOM    323  C   THR A 221      13.824  11.777   4.019  1.00 74.84           C  
ATOM    324  O   THR A 221      14.213  11.777   5.174  1.00 75.95           O  
ATOM    325  CB  THR A 221      15.054  12.003   1.851  1.00 74.73           C  
ATOM    326  OG1 THR A 221      14.115  10.994   1.533  1.00 77.43           O  
ATOM    327  CG2 THR A 221      16.420  11.359   2.115  1.00 74.69           C  
ATOM    328  N   ILE A 222      12.792  11.017   3.619  1.00 74.20           N  
ATOM    329  CA  ILE A 222      12.138  10.151   4.603  1.00 74.26           C  
ATOM    330  C   ILE A 222      13.009   8.939   4.724  1.00 73.98           C  
ATOM    331  O   ILE A 222      13.195   8.241   3.735  1.00 74.18           O  
ATOM    332  CB  ILE A 222      10.750   9.651   4.234  1.00 74.56           C  
ATOM    333  CG1 ILE A 222       9.982  10.724   3.461  1.00 77.02           C  
ATOM    334  CG2 ILE A 222       9.942   9.281   5.544  1.00 74.69           C  
ATOM    335  CD1 ILE A 222       9.613  11.976   4.290  1.00 76.65           C  
ATOM    336  N   PRO A 223      13.595   8.715   5.923  1.00 72.59           N  
ATOM    337  CA  PRO A 223      14.501   7.612   6.050  1.00 71.45           C  
ATOM    338  C   PRO A 223      13.781   6.264   6.084  1.00 70.73           C  
ATOM    339  O   PRO A 223      12.857   6.081   6.832  1.00 70.45           O  
ATOM    340  CB  PRO A 223      15.189   7.918   7.376  1.00 70.84           C  
ATOM    341  CG  PRO A 223      14.188   8.626   8.158  1.00 71.04           C  
ATOM    342  CD  PRO A 223      13.504   9.495   7.174  1.00 72.01           C  
ATOM    343  N   ASP A 224      14.217   5.316   5.276  1.00 70.56           N  
ATOM    344  CA  ASP A 224      13.782   3.936   5.462  1.00 71.05           C  
ATOM    345  C   ASP A 224      14.456   3.289   6.632  1.00 70.45           C  
ATOM    346  O   ASP A 224      15.439   3.788   7.152  1.00 71.10           O  
ATOM    347  CB  ASP A 224      14.203   3.119   4.262  1.00 71.50           C  
ATOM    348  CG  ASP A 224      13.437   3.499   3.046  1.00 75.36           C  
ATOM    349  OD1 ASP A 224      12.199   3.680   3.237  1.00 78.10           O  
ATOM    350  OD2 ASP A 224      14.054   3.648   1.936  1.00 77.38           O  
ATOM    351  N   VAL A 225      13.983   2.113   6.997  1.00 69.80           N  
ATOM    352  CA  VAL A 225      14.711   1.298   7.933  1.00 68.09           C  
ATOM    353  C   VAL A 225      16.122   1.061   7.380  1.00 67.62           C  
ATOM    354  O   VAL A 225      16.328   0.943   6.147  1.00 66.96           O  
ATOM    355  CB  VAL A 225      13.980   0.020   8.209  1.00 68.19           C  
ATOM    356  CG1 VAL A 225      14.883  -0.881   8.999  1.00 67.00           C  
ATOM    357  CG2 VAL A 225      12.682   0.333   8.974  1.00 66.16           C  
ATOM    358  N   GLY A 226      17.103   1.096   8.282  1.00 66.53           N  
ATOM    359  CA  GLY A 226      18.484   0.923   7.867  1.00 65.53           C  
ATOM    360  C   GLY A 226      19.105   2.069   7.087  1.00 65.28           C  
ATOM    361  O   GLY A 226      20.256   1.969   6.630  1.00 65.93           O  
ATOM    362  N   ASP A 227      18.364   3.166   6.915  1.00 64.45           N  
ATOM    363  CA  ASP A 227      19.026   4.470   6.642  1.00 62.89           C  
ATOM    364  C   ASP A 227      19.620   5.031   7.942  1.00 59.70           C  
ATOM    365  O   ASP A 227      19.155   4.714   9.077  1.00 57.54           O  
ATOM    366  CB  ASP A 227      18.059   5.495   6.003  1.00 64.20           C  
ATOM    367  CG  ASP A 227      17.716   5.179   4.525  1.00 68.85           C  
ATOM    368  OD1 ASP A 227      17.075   6.039   3.848  1.00 74.08           O  
ATOM    369  OD2 ASP A 227      18.060   4.071   4.042  1.00 72.47           O  
ATOM    370  N   PHE A 228      20.643   5.864   7.788  1.00 56.50           N  
ATOM    371  CA  PHE A 228      21.308   6.351   8.993  1.00 53.89           C  
ATOM    372  C   PHE A 228      21.890   7.694   8.709  1.00 52.11           C  
ATOM    373  O   PHE A 228      22.097   8.069   7.575  1.00 52.54           O  
ATOM    374  CB  PHE A 228      22.424   5.391   9.402  1.00 54.06           C  
ATOM    375  CG  PHE A 228      23.457   5.240   8.347  1.00 53.08           C  
ATOM    376  CD1 PHE A 228      23.308   4.278   7.337  1.00 55.50           C  
ATOM    377  CD2 PHE A 228      24.543   6.098   8.305  1.00 52.57           C  
ATOM    378  CE1 PHE A 228      24.218   4.186   6.250  1.00 56.07           C  
ATOM    379  CE2 PHE A 228      25.486   6.018   7.263  1.00 54.03           C  
ATOM    380  CZ  PHE A 228      25.318   5.055   6.219  1.00 55.62           C  
ATOM    381  N   ALA A 229      22.201   8.433   9.739  1.00 50.09           N  
ATOM    382  CA  ALA A 229      22.787   9.723   9.513  1.00 47.80           C  
ATOM    383  C   ALA A 229      23.926   9.779  10.391  1.00 45.89           C  
ATOM    384  O   ALA A 229      23.777   9.401  11.577  1.00 47.89           O  
ATOM    385  CB  ALA A 229      21.793  10.836   9.922  1.00 46.97           C  
ATOM    386  N   ASP A 230      25.029  10.318   9.907  1.00 44.51           N  
ATOM    387  CA  ASP A 230      26.209  10.554  10.810  1.00 45.77           C  
ATOM    388  C   ASP A 230      26.268  11.973  11.322  1.00 44.16           C  
ATOM    389  O   ASP A 230      26.160  12.888  10.516  1.00 44.69           O  
ATOM    390  CB  ASP A 230      27.541  10.249  10.084  1.00 46.92           C  
ATOM    391  CG  ASP A 230      27.691   8.724   9.695  1.00 52.56           C  
ATOM    392  OD1 ASP A 230      28.698   8.353   9.040  1.00 61.23           O  
ATOM    393  OD2 ASP A 230      26.846   7.879  10.096  1.00 54.95           O  
ATOM    394  N   PHE A 231      26.513  12.158  12.626  1.00 42.29           N  
ATOM    395  CA  PHE A 231      26.467  13.446  13.230  1.00 40.02           C  
ATOM    396  C   PHE A 231      27.471  13.600  14.400  1.00 40.90           C  
ATOM    397  O   PHE A 231      27.359  12.899  15.376  1.00 41.80           O  
ATOM    398  CB  PHE A 231      25.010  13.561  13.743  1.00 40.22           C  
ATOM    399  CG  PHE A 231      24.647  14.869  14.457  1.00 33.65           C  
ATOM    400  CD1 PHE A 231      24.152  15.955  13.733  1.00 32.02           C  
ATOM    401  CD2 PHE A 231      24.728  14.952  15.834  1.00 32.89           C  
ATOM    402  CE1 PHE A 231      23.808  17.214  14.390  1.00 29.92           C  
ATOM    403  CE2 PHE A 231      24.332  16.161  16.533  1.00 35.51           C  
ATOM    404  CZ  PHE A 231      23.872  17.281  15.786  1.00 34.29           C  
ATOM    405  N   HIS A 232      28.401  14.550  14.341  1.00 40.46           N  
ATOM    406  CA  HIS A 232      29.325  14.770  15.411  1.00 41.12           C  
ATOM    407  C   HIS A 232      29.899  13.525  16.051  1.00 42.90           C  
ATOM    408  O   HIS A 232      29.963  13.442  17.290  1.00 40.64           O  
ATOM    409  CB  HIS A 232      28.735  15.613  16.516  1.00 42.36           C  
ATOM    410  CG  HIS A 232      28.742  17.068  16.206  1.00 46.62           C  
ATOM    411  ND1 HIS A 232      27.880  17.634  15.265  1.00 50.65           N  
ATOM    412  CD2 HIS A 232      29.531  18.070  16.656  1.00 47.12           C  
ATOM    413  CE1 HIS A 232      28.105  18.928  15.174  1.00 44.28           C  
ATOM    414  NE2 HIS A 232      29.087  19.222  16.022  1.00 53.16           N  
ATOM    415  N   GLY A 233      30.367  12.585  15.221  1.00 44.53           N  
ATOM    416  CA  GLY A 233      31.077  11.441  15.748  1.00 46.53           C  
ATOM    417  C   GLY A 233      30.195  10.240  16.087  1.00 47.81           C  
ATOM    418  O   GLY A 233      30.687   9.282  16.644  1.00 49.30           O  
ATOM    419  N   TRP A 234      28.898  10.324  15.813  1.00 46.93           N  
ATOM    420  CA  TRP A 234      27.996   9.234  16.063  1.00 45.03           C  
ATOM    421  C   TRP A 234      27.177   8.944  14.805  1.00 44.56           C  
ATOM    422  O   TRP A 234      27.099   9.787  13.906  1.00 45.14           O  
ATOM    423  CB  TRP A 234      27.067   9.595  17.144  1.00 44.61           C  
ATOM    424  CG  TRP A 234      27.669   9.988  18.387  1.00 43.83           C  
ATOM    425  CD1 TRP A 234      28.155  11.169  18.681  1.00 43.46           C  
ATOM    426  CD2 TRP A 234      27.730   9.211  19.598  1.00 46.35           C  
ATOM    427  NE1 TRP A 234      28.592  11.209  20.017  1.00 42.20           N  
ATOM    428  CE2 TRP A 234      28.344  10.004  20.579  1.00 44.49           C  
ATOM    429  CE3 TRP A 234      27.421   7.886  19.908  1.00 48.56           C  
ATOM    430  CZ2 TRP A 234      28.596   9.559  21.852  1.00 48.62           C  
ATOM    431  CZ3 TRP A 234      27.648   7.437  21.213  1.00 47.67           C  
ATOM    432  CH2 TRP A 234      28.234   8.271  22.167  1.00 46.46           C  
ATOM    433  N   ARG A 235      26.603   7.742  14.742  1.00 43.99           N  
ATOM    434  CA  ARG A 235      25.732   7.266  13.647  1.00 44.88           C  
ATOM    435  C   ARG A 235      24.345   6.997  14.193  1.00 44.53           C  
ATOM    436  O   ARG A 235      24.172   6.526  15.328  1.00 43.96           O  
ATOM    437  CB  ARG A 235      26.269   5.973  13.150  1.00 45.38           C  
ATOM    438  CG  ARG A 235      25.503   5.401  12.053  1.00 48.32           C  
ATOM    439  CD  ARG A 235      26.401   4.498  11.272  1.00 46.95           C  
ATOM    440  NE  ARG A 235      27.037   5.266  10.232  1.00 54.62           N  
ATOM    441  CZ  ARG A 235      27.870   4.789   9.304  1.00 56.05           C  
ATOM    442  NH1 ARG A 235      28.170   3.497   9.232  1.00 58.53           N  
ATOM    443  NH2 ARG A 235      28.394   5.632   8.432  1.00 54.92           N  
ATOM    444  N   PHE A 236      23.335   7.338  13.418  1.00 45.35           N  
ATOM    445  CA  PHE A 236      21.968   7.212  13.915  1.00 44.96           C  
ATOM    446  C   PHE A 236      21.262   6.451  12.891  1.00 46.61           C  
ATOM    447  O   PHE A 236      21.306   6.829  11.729  1.00 46.95           O  
ATOM    448  CB  PHE A 236      21.384   8.569  14.035  1.00 42.99           C  
ATOM    449  CG  PHE A 236      21.958   9.340  15.178  1.00 41.39           C  
ATOM    450  CD1 PHE A 236      21.373   9.296  16.394  1.00 33.98           C  
ATOM    451  CD2 PHE A 236      23.106  10.099  15.015  1.00 35.49           C  
ATOM    452  CE1 PHE A 236      21.903  10.065  17.451  1.00 34.81           C  
ATOM    453  CE2 PHE A 236      23.593  10.849  16.060  1.00 36.91           C  
ATOM    454  CZ  PHE A 236      22.992  10.818  17.282  1.00 30.86           C  
ATOM    455  N   GLU A 237      20.691   5.318  13.270  1.00 49.30           N  
ATOM    456  CA  GLU A 237      20.179   4.422  12.225  1.00 51.92           C  
ATOM    457  C   GLU A 237      18.786   4.010  12.518  1.00 51.45           C  
ATOM    458  O   GLU A 237      18.459   3.623  13.638  1.00 52.37           O  
ATOM    459  CB  GLU A 237      21.033   3.177  12.125  1.00 51.84           C  
ATOM    460  CG  GLU A 237      20.616   2.228  10.996  1.00 52.88           C  
ATOM    461  CD  GLU A 237      21.412   0.919  10.982  1.00 54.53           C  
ATOM    462  OE1 GLU A 237      22.209   0.653  11.933  1.00 58.14           O  
ATOM    463  OE2 GLU A 237      21.252   0.151  10.010  1.00 58.93           O  
ATOM    464  N   VAL A 238      17.944   4.104  11.526  1.00 52.33           N  
ATOM    465  CA  VAL A 238      16.548   3.815  11.808  1.00 53.20           C  
ATOM    466  C   VAL A 238      16.374   2.318  11.731  1.00 54.24           C  
ATOM    467  O   VAL A 238      16.677   1.652  10.714  1.00 53.99           O  
ATOM    468  CB  VAL A 238      15.621   4.601  10.894  1.00 52.15           C  
ATOM    469  CG1 VAL A 238      16.376   5.050   9.767  1.00 53.98           C  
ATOM    470  CG2 VAL A 238      14.446   3.772  10.429  1.00 51.75           C  
ATOM    471  N   VAL A 239      15.915   1.786  12.836  1.00 55.17           N  
ATOM    472  CA  VAL A 239      15.819   0.358  12.886  1.00 58.68           C  
ATOM    473  C   VAL A 239      14.380  -0.121  12.778  1.00 62.21           C  
ATOM    474  O   VAL A 239      14.090  -1.086  12.035  1.00 63.45           O  
ATOM    475  CB  VAL A 239      16.571  -0.326  14.099  1.00 56.99           C  
ATOM    476  CG1 VAL A 239      18.034  -0.154  13.919  1.00 55.27           C  
ATOM    477  CG2 VAL A 239      16.071   0.142  15.451  1.00 55.15           C  
ATOM    478  N   GLU A 240      13.496   0.559  13.504  1.00 65.19           N  
ATOM    479  CA  GLU A 240      12.077   0.386  13.327  1.00 67.56           C  
ATOM    480  C   GLU A 240      11.334   1.705  12.908  1.00 68.34           C  
ATOM    481  O   GLU A 240      11.445   2.755  13.554  1.00 68.56           O  
ATOM    482  CB  GLU A 240      11.561  -0.178  14.623  1.00 68.31           C  
ATOM    483  CG  GLU A 240      10.320  -0.939  14.551  1.00 72.61           C  
ATOM    484  CD  GLU A 240       9.716  -0.949  15.917  1.00 80.08           C  
ATOM    485  OE1 GLU A 240      10.512  -0.857  16.892  1.00 82.72           O  
ATOM    486  OE2 GLU A 240       8.464  -1.019  16.030  1.00 83.85           O  
ATOM    487  N   LYS A 241      10.601   1.630  11.795  1.00 69.63           N  
ATOM    488  CA  LYS A 241       9.535   2.580  11.470  1.00 69.36           C  
ATOM    489  C   LYS A 241       8.209   1.970  11.895  1.00 70.14           C  
ATOM    490  O   LYS A 241       7.902   0.806  11.532  1.00 71.30           O  
ATOM    491  CB  LYS A 241       9.480   2.799   9.980  1.00 68.70           C  
ATOM    492  CG  LYS A 241      10.740   3.299   9.394  1.00 68.02           C  
ATOM    493  CD  LYS A 241      10.554   4.700   8.944  1.00 67.95           C  
ATOM    494  CE  LYS A 241       9.535   4.740   7.846  1.00 64.82           C  
ATOM    495  NZ  LYS A 241      10.052   5.651   6.836  1.00 65.92           N  
ATOM    496  N   GLU A 242       7.442   2.729  12.682  1.00 70.66           N  
ATOM    497  CA  GLU A 242       5.988   2.518  12.839  1.00 70.64           C  
ATOM    498  C   GLU A 242       5.238   3.459  11.897  1.00 69.87           C  
ATOM    499  O   GLU A 242       4.998   4.647  12.197  1.00 69.40           O  
ATOM    500  CB  GLU A 242       5.518   2.760  14.265  1.00 71.16           C  
ATOM    501  CG  GLU A 242       4.013   2.549  14.417  1.00 75.84           C  
ATOM    502  CD  GLU A 242       3.612   1.056  14.578  1.00 82.94           C  
ATOM    503  OE1 GLU A 242       2.431   0.839  15.006  1.00 83.61           O  
ATOM    504  OE2 GLU A 242       4.471   0.128  14.306  1.00 82.53           O  
ATOM    505  N   GLY A 243       4.884   2.917  10.747  1.00 68.49           N  
ATOM    506  CA  GLY A 243       4.163   3.702   9.808  1.00 67.85           C  
ATOM    507  C   GLY A 243       5.114   4.695   9.215  1.00 67.35           C  
ATOM    508  O   GLY A 243       6.073   4.360   8.485  1.00 69.13           O  
ATOM    509  N   GLN A 244       4.860   5.951   9.474  1.00 66.06           N  
ATOM    510  CA  GLN A 244       5.713   6.916   8.817  1.00 63.97           C  
ATOM    511  C   GLN A 244       6.554   7.575   9.902  1.00 62.74           C  
ATOM    512  O   GLN A 244       7.325   8.437   9.608  1.00 62.59           O  
ATOM    513  CB  GLN A 244       4.878   7.889   7.972  1.00 63.26           C  
ATOM    514  CG  GLN A 244       5.639   8.570   6.876  1.00 61.61           C  
ATOM    515  CD  GLN A 244       5.793   7.776   5.629  1.00 63.44           C  
ATOM    516  OE1 GLN A 244       6.825   7.879   4.934  1.00 63.15           O  
ATOM    517  NE2 GLN A 244       4.769   6.975   5.301  1.00 63.29           N  
ATOM    518  N   ARG A 245       6.398   7.123  11.140  1.00 61.07           N  
ATOM    519  CA  ARG A 245       7.123   7.628  12.261  1.00 61.26           C  
ATOM    520  C   ARG A 245       8.375   6.774  12.367  1.00 60.24           C  
ATOM    521  O   ARG A 245       8.318   5.561  12.117  1.00 60.75           O  
ATOM    522  CB  ARG A 245       6.302   7.461  13.548  1.00 60.25           C  
ATOM    523  CG  ARG A 245       6.938   8.096  14.786  1.00 62.64           C  
ATOM    524  CD  ARG A 245       6.062   8.040  16.049  1.00 65.49           C  
ATOM    525  NE  ARG A 245       5.512   6.688  16.266  1.00 79.77           N  
ATOM    526  CZ  ARG A 245       4.250   6.288  15.986  1.00 85.36           C  
ATOM    527  NH1 ARG A 245       3.878   5.027  16.246  1.00 87.03           N  
ATOM    528  NH2 ARG A 245       3.336   7.131  15.470  1.00 87.30           N  
ATOM    529  N   ILE A 246       9.495   7.408  12.746  1.00 58.35           N  
ATOM    530  CA  ILE A 246      10.735   6.707  13.066  1.00 54.90           C  
ATOM    531  C   ILE A 246      10.555   6.287  14.482  1.00 54.25           C  
ATOM    532  O   ILE A 246      10.522   7.090  15.408  1.00 53.39           O  
ATOM    533  CB  ILE A 246      11.924   7.632  12.974  1.00 54.55           C  
ATOM    534  CG1 ILE A 246      12.171   8.038  11.529  1.00 54.47           C  
ATOM    535  CG2 ILE A 246      13.149   6.927  13.345  1.00 55.15           C  
ATOM    536  CD1 ILE A 246      12.844   9.411  11.421  1.00 56.22           C  
ATOM    537  N   GLU A 247      10.423   4.988  14.669  1.00 54.57           N  
ATOM    538  CA  GLU A 247      10.073   4.478  15.974  1.00 55.40           C  
ATOM    539  C   GLU A 247      11.306   4.280  16.901  1.00 53.66           C  
ATOM    540  O   GLU A 247      11.291   4.703  18.100  1.00 51.42           O  
ATOM    541  CB  GLU A 247       9.231   3.183  15.783  1.00 57.55           C  
ATOM    542  CG  GLU A 247       8.633   2.591  17.095  1.00 65.56           C  
ATOM    543  CD  GLU A 247       7.348   3.292  17.511  1.00 77.26           C  
ATOM    544  OE1 GLU A 247       6.360   2.600  17.947  1.00 84.17           O  
ATOM    545  OE2 GLU A 247       7.310   4.542  17.367  1.00 78.76           O  
ATOM    546  N   ARG A 248      12.346   3.622  16.339  1.00 53.11           N  
ATOM    547  CA  ARG A 248      13.606   3.258  17.066  1.00 53.13           C  
ATOM    548  C   ARG A 248      14.816   3.578  16.261  1.00 50.86           C  
ATOM    549  O   ARG A 248      14.904   3.212  15.041  1.00 49.53           O  
ATOM    550  CB  ARG A 248      13.719   1.743  17.314  1.00 53.77           C  
ATOM    551  CG  ARG A 248      12.905   1.265  18.392  1.00 58.71           C  
ATOM    552  CD  ARG A 248      13.684   0.770  19.555  1.00 66.57           C  
ATOM    553  NE  ARG A 248      12.924   1.287  20.681  1.00 73.45           N  
ATOM    554  CZ  ARG A 248      13.407   1.508  21.893  1.00 74.03           C  
ATOM    555  NH1 ARG A 248      12.588   2.012  22.811  1.00 76.29           N  
ATOM    556  NH2 ARG A 248      14.676   1.218  22.189  1.00 72.30           N  
ATOM    557  N   VAL A 249      15.772   4.198  16.946  1.00 49.22           N  
ATOM    558  CA  VAL A 249      17.057   4.384  16.292  1.00 49.64           C  
ATOM    559  C   VAL A 249      18.217   3.799  17.100  1.00 49.26           C  
ATOM    560  O   VAL A 249      18.187   3.740  18.362  1.00 47.96           O  
ATOM    561  CB  VAL A 249      17.232   5.843  15.720  1.00 50.31           C  
ATOM    562  CG1 VAL A 249      16.201   6.736  16.267  1.00 48.45           C  
ATOM    563  CG2 VAL A 249      18.604   6.400  15.999  1.00 50.09           C  
ATOM    564  N   LYS A 250      19.179   3.265  16.363  1.00 50.30           N  
ATOM    565  CA  LYS A 250      20.376   2.611  16.952  1.00 51.56           C  
ATOM    566  C   LYS A 250      21.556   3.594  16.870  1.00 51.60           C  
ATOM    567  O   LYS A 250      21.939   4.010  15.766  1.00 50.69           O  
ATOM    568  CB  LYS A 250      20.748   1.326  16.153  1.00 52.41           C  
ATOM    569  CG  LYS A 250      21.876   0.435  16.803  1.00 52.20           C  
ATOM    570  CD  LYS A 250      22.535  -0.662  15.918  1.00 52.57           C  
ATOM    571  CE  LYS A 250      23.165  -1.796  16.836  1.00 57.44           C  
ATOM    572  NZ  LYS A 250      22.525  -2.047  18.300  1.00 55.81           N  
ATOM    573  N   ILE A 251      22.088   3.982  18.035  1.00 52.04           N  
ATOM    574  CA  ILE A 251      23.250   4.843  18.082  1.00 51.58           C  
ATOM    575  C   ILE A 251      24.540   3.999  18.141  1.00 53.22           C  
ATOM    576  O   ILE A 251      24.763   3.209  19.158  1.00 52.82           O  
ATOM    577  CB  ILE A 251      23.356   5.629  19.356  1.00 50.22           C  
ATOM    578  CG1 ILE A 251      22.071   6.235  19.926  1.00 50.64           C  
ATOM    579  CG2 ILE A 251      24.199   6.716  19.055  1.00 54.05           C  
ATOM    580  CD1 ILE A 251      21.355   7.205  19.090  1.00 42.23           C  
ATOM    581  N   THR A 252      25.391   4.147  17.112  1.00 52.63           N  
ATOM    582  CA  THR A 252      26.792   3.743  17.230  1.00 52.70           C  
ATOM    583  C   THR A 252      27.919   4.869  17.166  1.00 54.70           C  
ATOM    584  O   THR A 252      27.594   6.056  16.976  1.00 55.46           O  
ATOM    585  CB  THR A 252      27.106   2.565  16.337  1.00 52.76           C  
ATOM    586  OG1 THR A 252      27.032   2.895  14.940  1.00 50.54           O  
ATOM    587  CG2 THR A 252      26.197   1.372  16.685  1.00 53.49           C  
ATOM    588  N   LYS A 253      29.225   4.503  17.338  1.00 54.24           N  
ATOM    589  CA  LYS A 253      30.377   5.446  17.268  1.00 53.64           C  
ATOM    590  C   LYS A 253      31.095   5.554  15.885  1.00 55.24           C  
ATOM    591  O   LYS A 253      31.277   4.552  15.183  1.00 56.90           O  
ATOM    592  CB  LYS A 253      31.365   5.125  18.343  1.00 53.15           C  
ATOM    593  CG  LYS A 253      31.316   6.047  19.485  1.00 51.93           C  
ATOM    594  CD  LYS A 253      32.249   7.048  19.150  1.00 52.47           C  
ATOM    595  CE  LYS A 253      32.086   8.354  19.876  1.00 53.36           C  
ATOM    596  NZ  LYS A 253      32.834   9.186  18.831  1.00 55.43           N  
ATOM    597  N   LEU A 254      31.450   6.738  15.405  1.00 55.47           N  
ATOM    598  CA  LEU A 254      32.137   6.719  14.156  1.00 55.37           C  
ATOM    599  C   LEU A 254      33.628   6.549  14.481  1.00 56.33           C  
ATOM    600  O   LEU A 254      33.991   6.869  15.659  1.00 55.14           O  
ATOM    601  CB  LEU A 254      31.828   7.947  13.356  1.00 55.84           C  
ATOM    602  CG  LEU A 254      30.771   7.680  12.302  1.00 55.75           C  
ATOM    603  CD1 LEU A 254      30.519   6.230  12.187  1.00 56.29           C  
ATOM    604  CD2 LEU A 254      29.556   8.342  12.723  1.00 60.00           C  
ATOM    605  N   PRO A 255      34.418   5.874  13.552  1.00 57.24           N  
ATOM    606  CA  PRO A 255      35.854   5.955  13.408  1.00 58.13           C  
ATOM    607  C   PRO A 255      36.426   7.194  14.022  1.00 59.57           C  
ATOM    608  O   PRO A 255      36.401   7.304  15.261  1.00 61.70           O  
ATOM    609  CB  PRO A 255      36.025   5.948  11.895  1.00 56.91           C  
ATOM    610  CG  PRO A 255      34.995   4.875  11.459  1.00 58.87           C  
ATOM    611  CD  PRO A 255      33.938   4.818  12.612  1.00 57.84           C  
TER     612      PRO A 255                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
