
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   80 (  644),  selected   80 , name 2oai_A
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2oai_A.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E     5_A      -       -           -
LGA    D     6_A      -       -           -
LGA    A     7_A      D       5          5.951
LGA    L     8_A      E       6          0.656
LGA    X     9_A      I       7          0.754
LGA    V    10_A      V       8          0.492
LGA    T    11_A      Q       9          0.752
LGA    R    12_A      R      10          0.548
LGA    E    13_A      E      11          0.856
LGA    D    14_A      D      12          1.134
LGA    G    15_A      G      13          1.409
LGA    S    16_A      S      14          1.012
LGA    F    17_A      W      15          0.770
LGA    L    18_A      L      16          0.707
LGA    I    19_A      V      17          0.425
LGA    D    20_A      D      18          0.330
LGA    G    21_A      G      19          0.154
LGA    T    22_A      M      20          0.479
LGA    L    23_A      V      21          0.469
LGA    P    24_A      S      22          0.581
LGA    I    25_A      L      23          0.851
LGA    E    26_A      D      24          1.089
LGA    E    27_A      R      25          0.973
LGA    L    28_A      F      26          0.818
LGA    R    29_A      R      27          0.620
LGA    E    30_A      E      28          1.160
LGA    V    31_A      F      29          1.378
LGA    L    32_A      F      30          0.954
LGA    G    33_A      E      31          0.751
LGA    A    34_A      L      32          0.704
LGA    -       -      E      33           -
LGA    -       -      A      34           -
LGA    -       -      P      35           -
LGA    -       -      L      36           -
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    -       -      E      39           -
LGA    -       -      A      40           -
LGA    -       -      G      41           -
LGA    N    42_A      G      42          2.411
LGA    N    43_A      N      43          3.033
LGA    Y    44_A      I      44          0.968
LGA    H    45_A      H      45          0.492
LGA    T    46_A      T      46          0.323
LGA    L    47_A      L      47          0.065
LGA    A    48_A      A      48          0.053
LGA    G    49_A      G      49          0.336
LGA    X    50_A      V      50          0.599
LGA    C    51_A      M      51          0.642
LGA    I    52_A      L      52          0.482
LGA    S    53_A      Y      53          0.824
LGA    Y    54_A      Q      54          0.972
LGA    F    55_A      L      55          1.554
LGA    G    56_A      G      56          2.472
LGA    R    57_A      R      57          2.089
LGA    I    58_A      V      58          1.487
LGA    P    59_A      P      59          0.754
LGA    H    60_A      S      60          0.399
LGA    V    61_A      V      61          0.392
LGA    G    62_A      T      62          0.296
LGA    E    63_A      D      63          0.695
LGA    Y    64_A      R      64          0.787
LGA    F    65_A      F      65          1.158
LGA    D    66_A      E      66          1.659
LGA    W    67_A      W      67          2.159
LGA    A    68_A      N      68          2.714
LGA    G    69_A      G      69          1.555
LGA    W    70_A      F      70          0.533
LGA    R    71_A      S      71          0.383
LGA    I    72_A      F      72          0.502
LGA    E    73_A      E      73          0.484
LGA    I    74_A      V      74          0.402
LGA    V    75_A      V      75          0.455
LGA    D    76_A      D      76          0.310
LGA    L    77_A      M      77          0.438
LGA    D    78_A      D      78          0.489
LGA    G    79_A      R      79          0.462
LGA    A    80_A      T      80          0.431
LGA    R    81_A      R      81          0.477
LGA    I    82_A      V      82          0.308
LGA    D    83_A      D      83          0.275
LGA    X    84_A      K      84          0.358
LGA    L    85_A      I      85          0.382
LGA    L    86_A      L      86          0.470
LGA    L    87_A      V      87          0.576
LGA    Q    88_A      Q      88          0.920
LGA    R    89_A      R      89          1.099
LGA    L    90_A      H      90          2.314
LGA    N    91_A      H      91          4.689

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   80   87    5.0     78    1.35    42.31     86.182     5.392

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.975365 * X  +  -0.200150 * Y  +   0.092757 * Z  +  45.522552
  Y_new =   0.213100 * X  +  -0.963569 * Y  +   0.161627 * Z  +  36.162003
  Z_new =   0.057028 * X  +   0.177412 * Y  +   0.982483 * Z  +   6.744534 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.178650   -2.962943  [ DEG:    10.2359   -169.7641 ]
  Theta =  -0.057059   -3.084533  [ DEG:    -3.2693   -176.7307 ]
  Phi   =   2.926491   -0.215102  [ DEG:   167.6756    -12.3244 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2oai_A                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2oai_A.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   80   87   5.0   78   1.35   42.31  86.182
REMARK  ---------------------------------------------------------- 
MOLECULE 2oai_A
HEADER    TOXIN                                   15-DEC-06   2OAI              
TITLE     THE STRUCTURE OF TRANSPORTER ASSOCIATED DOMAIN CORC_HLYC              
TITLE    2 FROM A XYLELLA FASTIDIOSA TEMECULA1 HEMOLYSIN.                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HEMOLYSIN;                                                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CORC_HLYC DOMAIN: RESIDUES 349-439;                        
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 OTHER_DETAILS: AUTHORS STATE THAT ALTHOUGH THIS PROTEIN IS           
COMPND   7 A FRAGMENT OF A PUTATIVE HEMOLYSIN (A TOXIN), THE FUNCTION           
COMPND   8 OF THIS DOMAIN IS UNKNOWN                                            
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: XYLELLA FASTIDIOSA;                             
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: TEMECULA1;                                                   
SOURCE   5 ATCC: 700964;                                                        
SOURCE   6 GENE: TLYC;                                                          
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    PFAM03471, XYLELLA FASTIDIOSA TEMECULA1, HEMOLYSIN,                   
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.CUFF,L.VOLKART,J.ABDULLAH,T.A.BINKOWSKI,A.JOACHIMIAK,             
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   16-JAN-07 2OAI    0                                                
JRNL        AUTH   M.E.CUFF,L.VOLKART,J.ABDULLAH,T.A.BINKOWSKI,                 
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   THE STRUCTURE OF TRANSPORTER ASSOCIATED DOMAIN               
JRNL        TITL 2 CORC_HLYC FROM A XYLELLA FASTIDIOSA TEMECULA1                
JRNL        TITL 3 HEMOLYSIN.                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2OAI A    1    91  UNP    Q87DZ3   Q87DZ3_XYLFT   349    439             
SEQRES   1 A   94  SER ASN ALA GLU ASN THR ASP GLU ASP ALA LEU MSE VAL          
SEQRES   2 A   94  THR ARG GLU ASP GLY SER PHE LEU ILE ASP GLY THR LEU          
SEQRES   3 A   94  PRO ILE GLU GLU LEU ARG GLU VAL LEU GLY ALA GLU LEU          
SEQRES   4 A   94  PRO ASP GLY GLU GLU ASN ASN TYR HIS THR LEU ALA GLY          
SEQRES   5 A   94  MSE CYS ILE SER TYR PHE GLY ARG ILE PRO HIS VAL GLY          
SEQRES   6 A   94  GLU TYR PHE ASP TRP ALA GLY TRP ARG ILE GLU ILE VAL          
SEQRES   7 A   94  ASP LEU ASP GLY ALA ARG ILE ASP MLY LEU LEU LEU GLN          
SEQRES   8 A   94  ARG LEU ASN                                                  
HET    MSE  A   9       8                                                       
HET    MSE  A  50       8                                                       
HET    MLY  A  84      11                                                       
HET     CA  A 101       1                                                       
HET     CA  A 102       1                                                       
HET    EDO  A 201       4                                                       
HET    EDO  A 202       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     MLY N-DIMETHYL-LYSINE                                                
HETNAM      CA CALCIUM ION                                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   1  MLY    C8 H18 N2 O2                                                 
FORMUL   2   CA    2(CA 2+)                                                     
FORMUL   4  EDO    2(C2 H6 O2)                                                  
FORMUL   6  HOH   *86(H2 O)                                                     
CRYST1   87.905   87.905   87.905  90.00  90.00  90.00 I 2 3        24          
ATOM      1  N   GLU A   5       5.378   2.481  30.752  1.00 68.76           N  
ATOM      2  CA  GLU A   5       5.454   2.365  29.257  1.00 68.61           C  
ATOM      3  C   GLU A   5       6.905   2.233  28.759  1.00 67.33           C  
ATOM      4  O   GLU A   5       7.841   2.270  29.566  1.00 67.30           O  
ATOM      5  CB  GLU A   5       4.750   3.545  28.587  1.00 68.84           C  
ATOM      6  CG  GLU A   5       5.410   4.884  28.855  1.00 71.70           C  
ATOM      7  CD  GLU A   5       4.858   5.986  27.970  1.00 75.71           C  
ATOM      8  OE1 GLU A   5       4.477   5.694  26.807  1.00 77.64           O  
ATOM      9  OE2 GLU A   5       4.807   7.151  28.435  1.00 77.70           O  
ATOM     10  N   ASP A   6       7.074   2.096  27.438  1.00 65.78           N  
ATOM     11  CA  ASP A   6       8.354   1.704  26.831  1.00 64.22           C  
ATOM     12  C   ASP A   6       9.530   2.615  27.230  1.00 63.40           C  
ATOM     13  O   ASP A   6       9.427   3.843  27.150  1.00 62.89           O  
ATOM     14  CB  ASP A   6       8.264   1.659  25.279  1.00 64.43           C  
ATOM     15  CG  ASP A   6       7.357   0.516  24.726  1.00 64.12           C  
ATOM     16  OD1 ASP A   6       6.814  -0.295  25.525  1.00 67.55           O  
ATOM     17  OD2 ASP A   6       7.181   0.462  23.473  1.00 53.59           O  
ATOM     18  N   ALA A   7      10.644   1.996  27.639  1.00 62.18           N  
ATOM     19  CA  ALA A   7      11.936   2.684  27.837  1.00 60.44           C  
ATOM     20  C   ALA A   7      12.297   3.506  26.596  1.00 58.95           C  
ATOM     21  O   ALA A   7      12.106   3.021  25.470  1.00 59.85           O  
ATOM     22  CB  ALA A   7      13.026   1.650  28.094  1.00 60.76           C  
ATOM     23  N   LEU A   8      12.818   4.723  26.782  1.00 56.19           N  
ATOM     24  CA  LEU A   8      13.149   5.568  25.642  1.00 54.24           C  
ATOM     25  C   LEU A   8      14.548   5.260  25.118  1.00 53.94           C  
ATOM     26  O   LEU A   8      14.864   5.585  23.979  1.00 51.36           O  
ATOM     27  CB  LEU A   8      13.065   7.048  26.002  1.00 54.34           C  
ATOM     28  CG  LEU A   8      11.840   7.880  25.526  1.00 54.84           C  
ATOM     29  CD1 LEU A   8      10.580   7.087  25.292  1.00 53.96           C  
ATOM     30  CD2 LEU A   8      11.597   9.103  26.404  1.00 55.14           C  
HETATM   31  N   MSE A   9      15.377   4.670  25.970  1.00 53.05           N  
HETATM   32  CA  MSE A   9      16.766   4.409  25.607  1.00 57.28           C  
HETATM   33  C   MSE A   9      17.260   3.162  26.301  1.00 53.13           C  
HETATM   34  O   MSE A   9      17.023   2.984  27.499  1.00 52.96           O  
HETATM   35  CB  MSE A   9      17.618   5.570  26.065  1.00 55.88           C  
HETATM   36  CG  MSE A   9      18.739   5.785  25.174  1.00 64.21           C  
HETATM   37 SE   MSE A   9      19.832   7.082  26.047  0.80 75.08          SE  
HETATM   38  CE  MSE A   9      20.992   5.766  26.921  1.00 73.87           C  
ATOM     39  N   VAL A  10      17.931   2.286  25.563  1.00 50.07           N  
ATOM     40  CA  VAL A  10      18.488   1.096  26.174  1.00 48.91           C  
ATOM     41  C   VAL A  10      19.896   0.864  25.644  1.00 47.49           C  
ATOM     42  O   VAL A  10      20.211   1.271  24.534  1.00 47.72           O  
ATOM     43  CB  VAL A  10      17.645  -0.193  25.932  1.00 49.77           C  
ATOM     44  CG1 VAL A  10      16.121   0.025  26.282  1.00 48.87           C  
ATOM     45  CG2 VAL A  10      17.848  -0.692  24.589  1.00 51.44           C  
ATOM     46  N   THR A  11      20.728   0.228  26.461  1.00 45.64           N  
ATOM     47  CA  THR A  11      22.113  -0.025  26.102  1.00 46.20           C  
ATOM     48  C   THR A  11      22.229  -1.454  25.600  1.00 46.37           C  
ATOM     49  O   THR A  11      21.787  -2.382  26.283  1.00 46.19           O  
ATOM     50  CB  THR A  11      23.008   0.096  27.357  1.00 47.72           C  
ATOM     51  OG1 THR A  11      22.713   1.343  28.005  1.00 50.52           O  
ATOM     52  CG2 THR A  11      24.479   0.073  26.933  1.00 49.67           C  
ATOM     53  N   ARG A  12      22.850  -1.633  24.447  1.00 44.85           N  
ATOM     54  CA  ARG A  12      23.192  -2.961  23.939  1.00 44.19           C  
ATOM     55  C   ARG A  12      24.446  -3.536  24.568  1.00 44.42           C  
ATOM     56  O   ARG A  12      25.235  -2.822  25.227  1.00 44.35           O  
ATOM     57  CB  ARG A  12      23.371  -2.874  22.410  1.00 43.53           C  
ATOM     58  CG  ARG A  12      22.083  -2.440  21.680  1.00 45.17           C  
ATOM     59  CD  ARG A  12      22.389  -2.345  20.190  1.00 46.45           C  
ATOM     60  NE  ARG A  12      22.675  -3.656  19.601  1.00 47.82           N  
ATOM     61  CZ  ARG A  12      23.598  -3.886  18.656  1.00 53.00           C  
ATOM     62  NH1 ARG A  12      24.427  -2.921  18.244  1.00 51.85           N  
ATOM     63  NH2 ARG A  12      23.743  -5.108  18.160  1.00 52.41           N  
ATOM     64  N   GLU A  13      24.653  -4.842  24.373  1.00 44.33           N  
ATOM     65  CA  GLU A  13      25.800  -5.522  24.954  1.00 45.95           C  
ATOM     66  C   GLU A  13      27.143  -4.841  24.627  1.00 45.21           C  
ATOM     67  O   GLU A  13      28.020  -4.808  25.466  1.00 44.56           O  
ATOM     68  CB  GLU A  13      25.819  -6.989  24.510  1.00 47.57           C  
ATOM     69  CG  GLU A  13      26.932  -7.778  25.178  1.00 52.52           C  
ATOM     70  CD  GLU A  13      26.853  -9.242  24.863  1.00 58.97           C  
ATOM     71  OE1 GLU A  13      27.354  -9.640  23.785  1.00 62.82           O  
ATOM     72  OE2 GLU A  13      26.276  -9.973  25.697  1.00 59.78           O  
ATOM     73  N   ASP A  14      27.272  -4.294  23.413  1.00 45.92           N  
ATOM     74  CA  ASP A  14      28.556  -3.697  22.989  1.00 46.95           C  
ATOM     75  C   ASP A  14      28.680  -2.219  23.405  1.00 46.91           C  
ATOM     76  O   ASP A  14      29.654  -1.538  23.043  1.00 46.87           O  
ATOM     77  CB  ASP A  14      28.746  -3.865  21.471  1.00 47.91           C  
ATOM     78  CG  ASP A  14      27.762  -3.073  20.646  1.00 51.87           C  
ATOM     79  OD1 ASP A  14      26.857  -2.361  21.153  1.00 51.15           O  
ATOM     80  OD2 ASP A  14      27.875  -3.185  19.405  1.00 57.19           O  
ATOM     81  N   GLY A  15      27.668  -1.718  24.115  1.00 45.57           N  
ATOM     82  CA  GLY A  15      27.715  -0.359  24.644  1.00 45.19           C  
ATOM     83  C   GLY A  15      26.989   0.640  23.745  1.00 45.30           C  
ATOM     84  O   GLY A  15      26.811   1.795  24.155  1.00 45.84           O  
ATOM     85  N   SER A  16      26.595   0.228  22.537  1.00 44.67           N  
ATOM     86  CA  SER A  16      25.813   1.101  21.640  1.00 44.78           C  
ATOM     87  C   SER A  16      24.408   1.298  22.226  1.00 45.19           C  
ATOM     88  O   SER A  16      24.028   0.602  23.164  1.00 44.79           O  
ATOM     89  CB  SER A  16      25.768   0.549  20.186  1.00 45.94           C  
ATOM     90  OG  SER A  16      25.220  -0.763  20.131  1.00 45.26           O  
ATOM     91  N   PHE A  17      23.656   2.274  21.698  1.00 45.22           N  
ATOM     92  CA  PHE A  17      22.377   2.620  22.301  1.00 45.24           C  
ATOM     93  C   PHE A  17      21.295   2.442  21.282  1.00 45.73           C  
ATOM     94  O   PHE A  17      21.445   2.857  20.121  1.00 46.92           O  
ATOM     95  CB  PHE A  17      22.349   4.098  22.722  1.00 46.38           C  
ATOM     96  CG  PHE A  17      23.342   4.466  23.820  1.00 47.79           C  
ATOM     97  CD1 PHE A  17      23.437   3.717  24.983  1.00 51.06           C  
ATOM     98  CD2 PHE A  17      24.132   5.598  23.693  1.00 50.22           C  
ATOM     99  CE1 PHE A  17      24.345   4.084  25.995  1.00 50.55           C  
ATOM    100  CE2 PHE A  17      25.035   5.982  24.703  1.00 52.70           C  
ATOM    101  CZ  PHE A  17      25.147   5.227  25.841  1.00 51.33           C  
ATOM    102  N   LEU A  18      20.179   1.896  21.718  1.00 44.97           N  
ATOM    103  CA  LEU A  18      18.961   1.901  20.924  1.00 44.65           C  
ATOM    104  C   LEU A  18      18.012   2.938  21.539  1.00 45.84           C  
ATOM    105  O   LEU A  18      17.681   2.876  22.749  1.00 45.20           O  
ATOM    106  CB  LEU A  18      18.335   0.511  20.916  1.00 43.97           C  
ATOM    107  CG  LEU A  18      19.111  -0.484  20.022  1.00 45.93           C  
ATOM    108  CD1 LEU A  18      18.734  -1.960  20.346  1.00 45.87           C  
ATOM    109  CD2 LEU A  18      18.767  -0.179  18.535  1.00 45.86           C  
ATOM    110  N   ILE A  19      17.592   3.900  20.706  1.00 46.23           N  
ATOM    111  CA  ILE A  19      16.925   5.111  21.215  1.00 46.26           C  
ATOM    112  C   ILE A  19      15.614   5.394  20.468  1.00 46.49           C  
ATOM    113  O   ILE A  19      15.545   5.276  19.249  1.00 47.33           O  
ATOM    114  CB  ILE A  19      17.842   6.334  21.123  1.00 46.28           C  
ATOM    115  CG1 ILE A  19      19.192   6.046  21.833  1.00 46.60           C  
ATOM    116  CG2 ILE A  19      17.130   7.581  21.743  1.00 47.04           C  
ATOM    117  CD1 ILE A  19      20.133   7.263  21.920  1.00 47.32           C  
ATOM    118  N   ASP A  20      14.574   5.737  21.219  1.00 46.14           N  
ATOM    119  CA  ASP A  20      13.253   6.069  20.643  1.00 46.78           C  
ATOM    120  C   ASP A  20      13.375   7.381  19.842  1.00 47.07           C  
ATOM    121  O   ASP A  20      14.095   8.311  20.261  1.00 46.85           O  
ATOM    122  CB  ASP A  20      12.245   6.238  21.790  1.00 47.30           C  
ATOM    123  CG  ASP A  20      10.832   6.276  21.299  1.00 48.93           C  
ATOM    124  OD1 ASP A  20      10.425   7.311  20.740  1.00 54.25           O  
ATOM    125  OD2 ASP A  20      10.118   5.265  21.460  1.00 50.61           O  
ATOM    126  N   GLY A  21      12.731   7.458  18.670  1.00 46.72           N  
ATOM    127  CA  GLY A  21      12.763   8.705  17.891  1.00 46.43           C  
ATOM    128  C   GLY A  21      12.262   9.934  18.632  1.00 47.25           C  
ATOM    129  O   GLY A  21      12.614  11.055  18.274  1.00 47.85           O  
ATOM    130  N   THR A  22      11.427   9.758  19.660  1.00 47.09           N  
ATOM    131  CA  THR A  22      10.897  10.922  20.386  1.00 46.76           C  
ATOM    132  C   THR A  22      11.848  11.531  21.426  1.00 47.12           C  
ATOM    133  O   THR A  22      11.501  12.534  22.082  1.00 46.05           O  
ATOM    134  CB  THR A  22       9.568  10.592  21.094  1.00 46.90           C  
ATOM    135  OG1 THR A  22       9.818   9.600  22.094  1.00 48.14           O  
ATOM    136  CG2 THR A  22       8.542  10.106  20.092  1.00 48.15           C  
ATOM    137  N   LEU A  23      13.043  10.969  21.592  1.00 46.97           N  
ATOM    138  CA  LEU A  23      13.935  11.491  22.636  1.00 47.86           C  
ATOM    139  C   LEU A  23      14.270  12.962  22.308  1.00 48.22           C  
ATOM    140  O   LEU A  23      14.703  13.239  21.188  1.00 48.73           O  
ATOM    141  CB  LEU A  23      15.225  10.655  22.739  1.00 47.52           C  
ATOM    142  CG  LEU A  23      16.127  11.061  23.924  1.00 50.02           C  
ATOM    143  CD1 LEU A  23      15.484  10.631  25.241  1.00 52.23           C  
ATOM    144  CD2 LEU A  23      17.522  10.506  23.768  1.00 50.86           C  
ATOM    145  N   PRO A  24      14.066  13.895  23.254  1.00 49.95           N  
ATOM    146  CA  PRO A  24      14.400  15.286  22.894  1.00 50.48           C  
ATOM    147  C   PRO A  24      15.907  15.444  22.641  1.00 51.11           C  
ATOM    148  O   PRO A  24      16.703  14.762  23.285  1.00 50.69           O  
ATOM    149  CB  PRO A  24      13.985  16.105  24.128  1.00 51.35           C  
ATOM    150  CG  PRO A  24      13.096  15.190  24.939  1.00 51.78           C  
ATOM    151  CD  PRO A  24      13.550  13.777  24.626  1.00 50.17           C  
ATOM    152  N   ILE A  25      16.287  16.337  21.719  1.00 51.18           N  
ATOM    153  CA  ILE A  25      17.706  16.570  21.378  1.00 51.92           C  
ATOM    154  C   ILE A  25      18.518  17.039  22.599  1.00 51.81           C  
ATOM    155  O   ILE A  25      19.688  16.686  22.746  1.00 51.45           O  
ATOM    156  CB  ILE A  25      17.845  17.586  20.197  1.00 52.42           C  
ATOM    157  CG1 ILE A  25      17.335  16.975  18.889  1.00 52.40           C  
ATOM    158  CG2 ILE A  25      19.304  18.125  20.046  1.00 53.52           C  
ATOM    159  CD1 ILE A  25      18.090  15.749  18.361  1.00 52.21           C  
ATOM    160  N   GLU A  26      17.896  17.808  23.485  1.00 52.47           N  
ATOM    161  CA  GLU A  26      18.584  18.275  24.691  1.00 54.11           C  
ATOM    162  C   GLU A  26      19.039  17.090  25.511  1.00 53.38           C  
ATOM    163  O   GLU A  26      20.166  17.059  26.016  1.00 52.89           O  
ATOM    164  CB  GLU A  26      17.661  19.103  25.567  1.00 55.27           C  
ATOM    165  CG  GLU A  26      17.237  20.400  24.985  1.00 60.63           C  
ATOM    166  CD  GLU A  26      16.669  21.309  26.056  1.00 66.85           C  
ATOM    167  OE1 GLU A  26      15.488  21.112  26.436  1.00 70.21           O  
ATOM    168  OE2 GLU A  26      17.408  22.205  26.528  1.00 69.24           O  
ATOM    169  N   GLU A  27      18.140  16.123  25.650  1.00 52.44           N  
ATOM    170  CA  GLU A  27      18.416  14.940  26.437  0.50 52.21           C  
ATOM    172  C   GLU A  27      19.418  14.048  25.715  1.00 51.90           C  
ATOM    173  O   GLU A  27      20.279  13.446  26.339  1.00 51.68           O  
ATOM    174  CB  GLU A  27      17.118  14.175  26.731  0.50 52.76           C  
ATOM    176  CG  GLU A  27      16.639  14.279  28.180  0.50 54.12           C  
ATOM    178  CD  GLU A  27      17.523  13.476  29.145  0.50 57.36           C  
ATOM    180  OE1 GLU A  27      18.316  12.623  28.681  0.50 58.74           O  
ATOM    182  OE2 GLU A  27      17.424  13.694  30.370  0.50 59.44           O  
ATOM    184  N   LEU A  28      19.303  13.969  24.395  1.00 50.64           N  
ATOM    185  CA  LEU A  28      20.265  13.229  23.587  1.00 50.38           C  
ATOM    186  C   LEU A  28      21.682  13.806  23.774  1.00 50.26           C  
ATOM    187  O   LEU A  28      22.649  13.051  23.953  1.00 48.68           O  
ATOM    188  CB  LEU A  28      19.855  13.257  22.113  1.00 49.77           C  
ATOM    189  CG  LEU A  28      20.734  12.459  21.139  1.00 51.63           C  
ATOM    190  CD1 LEU A  28      20.744  10.948  21.424  1.00 52.30           C  
ATOM    191  CD2 LEU A  28      20.329  12.735  19.675  1.00 53.00           C  
ATOM    192  N   ARG A  29      21.805  15.137  23.775  1.00 49.85           N  
ATOM    193  CA  ARG A  29      23.108  15.763  23.929  1.00 52.81           C  
ATOM    194  C   ARG A  29      23.730  15.337  25.243  1.00 52.45           C  
ATOM    195  O   ARG A  29      24.938  15.107  25.310  1.00 52.27           O  
ATOM    196  CB  ARG A  29      23.024  17.296  23.909  1.00 51.62           C  
ATOM    197  CG  ARG A  29      22.768  17.843  22.526  1.00 55.42           C  
ATOM    198  CD  ARG A  29      23.033  19.381  22.428  1.00 58.21           C  
ATOM    199  NE  ARG A  29      22.459  19.886  21.175  1.00 69.20           N  
ATOM    200  CZ  ARG A  29      23.038  19.792  19.971  1.00 72.83           C  
ATOM    201  NH1 ARG A  29      22.403  20.265  18.900  1.00 75.08           N  
ATOM    202  NH2 ARG A  29      24.248  19.244  19.828  1.00 73.28           N  
ATOM    203  N   GLU A  30      22.903  15.279  26.280  1.00 53.17           N  
ATOM    204  CA  GLU A  30      23.397  14.958  27.622  1.00 55.81           C  
ATOM    205  C   GLU A  30      23.889  13.518  27.662  1.00 55.37           C  
ATOM    206  O   GLU A  30      24.981  13.253  28.167  1.00 55.67           O  
ATOM    207  CB  GLU A  30      22.325  15.164  28.694  1.00 55.44           C  
ATOM    208  CG  GLU A  30      21.815  16.583  28.816  1.00 59.95           C  
ATOM    209  CD  GLU A  30      20.787  16.757  29.955  1.00 60.02           C  
ATOM    210  OE1 GLU A  30      19.624  16.266  29.829  1.00 66.22           O  
ATOM    211  OE2 GLU A  30      21.149  17.404  30.961  1.00 64.99           O  
ATOM    212  N   VAL A  31      23.117  12.590  27.100  0.50 55.34           N  
ATOM    214  CA  VAL A  31      23.451  11.153  27.181  0.50 55.76           C  
ATOM    216  C   VAL A  31      24.590  10.692  26.260  0.50 56.12           C  
ATOM    218  O   VAL A  31      25.187   9.632  26.474  0.50 56.46           O  
ATOM    220  CB  VAL A  31      22.211  10.249  26.976  0.50 55.54           C  
ATOM    222  CG1 VAL A  31      21.062  10.731  27.858  0.50 55.30           C  
ATOM    224  CG2 VAL A  31      21.809  10.200  25.503  0.50 55.23           C  
ATOM    226  N   LEU A  32      24.883  11.479  25.234  1.00 56.53           N  
ATOM    227  CA  LEU A  32      26.038  11.222  24.390  1.00 57.86           C  
ATOM    228  C   LEU A  32      27.259  12.024  24.811  1.00 59.26           C  
ATOM    229  O   LEU A  32      28.356  11.769  24.311  1.00 59.97           O  
ATOM    230  CB  LEU A  32      25.729  11.584  22.947  1.00 58.03           C  
ATOM    231  CG  LEU A  32      24.530  10.947  22.230  1.00 59.39           C  
ATOM    232  CD1 LEU A  32      24.494  11.456  20.783  1.00 60.08           C  
ATOM    233  CD2 LEU A  32      24.510   9.397  22.298  1.00 60.32           C  
ATOM    234  N   GLY A  33      27.068  13.002  25.700  1.00 59.80           N  
ATOM    235  CA  GLY A  33      28.101  13.992  25.995  1.00 61.31           C  
ATOM    236  C   GLY A  33      28.477  14.799  24.761  1.00 62.34           C  
ATOM    237  O   GLY A  33      29.643  15.125  24.568  1.00 62.37           O  
ATOM    238  N   ALA A  34      27.483  15.134  23.937  1.00 63.20           N  
ATOM    239  CA  ALA A  34      27.703  15.833  22.665  1.00 64.34           C  
ATOM    240  C   ALA A  34      27.242  17.279  22.721  1.00 64.65           C  
ATOM    241  O   ALA A  34      27.634  18.021  23.616  1.00 66.09           O  
ATOM    242  CB  ALA A  34      26.989  15.117  21.545  1.00 64.34           C  
ATOM    243  N   ASN A  42      15.813  25.088  16.599  1.00 70.04           N  
ATOM    244  CA  ASN A  42      15.977  24.594  15.233  1.00 69.62           C  
ATOM    245  C   ASN A  42      14.657  24.399  14.466  1.00 68.71           C  
ATOM    246  O   ASN A  42      13.650  25.085  14.724  1.00 69.11           O  
ATOM    247  CB  ASN A  42      16.809  23.306  15.233  1.00 69.93           C  
ATOM    248  CG  ASN A  42      18.294  23.578  15.341  1.00 71.42           C  
ATOM    249  OD1 ASN A  42      18.710  24.630  15.830  1.00 72.12           O  
ATOM    250  ND2 ASN A  42      19.107  22.632  14.879  1.00 72.46           N  
ATOM    251  N   ASN A  43      14.691  23.504  13.487  1.00 67.21           N  
ATOM    252  CA  ASN A  43      13.473  22.977  12.890  1.00 65.71           C  
ATOM    253  C   ASN A  43      13.166  21.605  13.481  1.00 63.54           C  
ATOM    254  O   ASN A  43      12.309  20.866  12.963  1.00 63.24           O  
ATOM    255  CB  ASN A  43      13.574  22.913  11.355  1.00 66.81           C  
ATOM    256  CG  ASN A  43      14.815  22.174  10.874  1.00 69.29           C  
ATOM    257  OD1 ASN A  43      15.938  22.488  11.291  1.00 73.52           O  
ATOM    258  ND2 ASN A  43      14.623  21.204   9.974  1.00 69.72           N  
ATOM    259  N   TYR A  44      13.871  21.276  14.567  1.00 60.37           N  
ATOM    260  CA  TYR A  44      13.647  20.018  15.272  1.00 57.56           C  
ATOM    261  C   TYR A  44      14.016  20.070  16.746  1.00 55.62           C  
ATOM    262  O   TYR A  44      14.892  20.852  17.157  1.00 55.63           O  
ATOM    263  CB  TYR A  44      14.399  18.881  14.584  1.00 57.62           C  
ATOM    264  CG  TYR A  44      15.895  19.035  14.565  1.00 57.22           C  
ATOM    265  CD1 TYR A  44      16.664  18.660  15.674  1.00 57.37           C  
ATOM    266  CD2 TYR A  44      16.555  19.520  13.427  1.00 57.47           C  
ATOM    267  CE1 TYR A  44      18.052  18.787  15.666  1.00 58.14           C  
ATOM    268  CE2 TYR A  44      17.952  19.650  13.404  1.00 58.06           C  
ATOM    269  CZ  TYR A  44      18.685  19.267  14.533  1.00 58.74           C  
ATOM    270  OH  TYR A  44      20.056  19.385  14.555  1.00 60.26           O  
ATOM    271  N   HIS A  45      13.326  19.268  17.546  1.00 52.59           N  
ATOM    272  CA  HIS A  45      13.634  19.190  18.960  1.00 51.48           C  
ATOM    273  C   HIS A  45      13.757  17.746  19.434  1.00 49.85           C  
ATOM    274  O   HIS A  45      14.010  17.512  20.611  1.00 48.63           O  
ATOM    275  CB  HIS A  45      12.619  19.967  19.807  1.00 51.83           C  
ATOM    276  CG  HIS A  45      11.257  19.348  19.825  1.00 53.73           C  
ATOM    277  ND1 HIS A  45      10.373  19.462  18.770  1.00 58.07           N  
ATOM    278  CD2 HIS A  45      10.636  18.585  20.757  1.00 55.73           C  
ATOM    279  CE1 HIS A  45       9.266  18.792  19.049  1.00 57.70           C  
ATOM    280  NE2 HIS A  45       9.402  18.248  20.248  1.00 58.63           N  
ATOM    281  N   THR A  46      13.567  16.795  18.526  1.00 49.04           N  
ATOM    282  CA  THR A  46      13.693  15.382  18.864  1.00 48.52           C  
ATOM    283  C   THR A  46      14.646  14.679  17.891  1.00 48.05           C  
ATOM    284  O   THR A  46      14.942  15.185  16.791  1.00 47.63           O  
ATOM    285  CB  THR A  46      12.341  14.606  18.799  1.00 47.67           C  
ATOM    286  OG1 THR A  46      11.926  14.476  17.428  1.00 49.54           O  
ATOM    287  CG2 THR A  46      11.251  15.269  19.629  1.00 49.23           C  
ATOM    288  N   LEU A  47      15.101  13.501  18.301  1.00 47.65           N  
ATOM    289  CA  LEU A  47      15.932  12.653  17.439  1.00 47.77           C  
ATOM    290  C   LEU A  47      15.285  12.329  16.084  1.00 47.86           C  
ATOM    291  O   LEU A  47      15.949  12.461  15.037  1.00 48.38           O  
ATOM    292  CB  LEU A  47      16.340  11.381  18.204  1.00 47.73           C  
ATOM    293  CG  LEU A  47      17.207  10.325  17.490  1.00 48.30           C  
ATOM    294  CD1 LEU A  47      18.463  10.953  16.849  1.00 48.59           C  
ATOM    295  CD2 LEU A  47      17.590   9.247  18.502  1.00 47.89           C  
ATOM    296  N   ALA A  48      14.003  11.932  16.062  1.00 47.57           N  
ATOM    297  CA  ALA A  48      13.355  11.653  14.771  1.00 48.00           C  
ATOM    298  C   ALA A  48      13.337  12.925  13.910  1.00 48.76           C  
ATOM    299  O   ALA A  48      13.584  12.879  12.702  1.00 48.25           O  
ATOM    300  CB  ALA A  48      11.924  11.132  14.980  1.00 47.72           C  
ATOM    301  N   GLY A  49      13.016  14.055  14.546  1.00 48.10           N  
ATOM    302  CA  GLY A  49      12.974  15.357  13.867  1.00 50.02           C  
ATOM    303  C   GLY A  49      14.316  15.684  13.222  1.00 50.32           C  
ATOM    304  O   GLY A  49      14.357  16.172  12.082  1.00 49.61           O  
HETATM  305  N   MSE A  50      15.401  15.384  13.938  1.00 50.61           N  
HETATM  306  CA  MSE A  50      16.724  15.643  13.425  1.00 52.90           C  
HETATM  307  C   MSE A  50      17.007  14.778  12.198  1.00 51.22           C  
HETATM  308  O   MSE A  50      17.611  15.250  11.229  1.00 50.67           O  
HETATM  309  CB  MSE A  50      17.786  15.392  14.484  1.00 52.07           C  
HETATM  310  CG  MSE A  50      19.147  15.610  13.912  1.00 55.29           C  
HETATM  311 SE   MSE A  50      20.544  15.759  15.249  0.80 61.80          SE  
HETATM  312  CE  MSE A  50      20.661  14.045  15.762  1.00 49.67           C  
ATOM    313  N   CYS A  51      16.571  13.519  12.250  1.00 50.56           N  
ATOM    314  CA  CYS A  51      16.688  12.643  11.089  1.00 50.51           C  
ATOM    315  C   CYS A  51      15.962  13.184   9.858  1.00 50.86           C  
ATOM    316  O   CYS A  51      16.530  13.192   8.765  1.00 50.82           O  
ATOM    317  CB  CYS A  51      16.181  11.245  11.405  1.00 50.14           C  
ATOM    318  SG  CYS A  51      17.209  10.414  12.635  1.00 52.62           S  
ATOM    319  N   ILE A  52      14.710  13.613  10.030  1.00 50.76           N  
ATOM    320  CA  ILE A  52      13.908  14.084   8.888  1.00 51.67           C  
ATOM    321  C   ILE A  52      14.581  15.331   8.308  1.00 52.12           C  
ATOM    322  O   ILE A  52      14.661  15.504   7.085  1.00 52.61           O  
ATOM    323  CB  ILE A  52      12.415  14.377   9.303  1.00 51.65           C  
ATOM    324  CG1 ILE A  52      11.695  13.080   9.715  1.00 51.27           C  
ATOM    325  CG2 ILE A  52      11.674  15.168   8.201  1.00 52.79           C  
ATOM    326  CD1 ILE A  52      11.413  12.065   8.583  1.00 53.06           C  
ATOM    327  N   SER A  53      15.088  16.184   9.194  1.00 51.83           N  
ATOM    328  CA  SER A  53      15.768  17.399   8.796  1.00 53.02           C  
ATOM    329  C   SER A  53      17.005  17.066   7.946  1.00 52.52           C  
ATOM    330  O   SER A  53      17.225  17.680   6.903  1.00 51.61           O  
ATOM    331  CB  SER A  53      16.146  18.206  10.039  1.00 52.67           C  
ATOM    332  OG  SER A  53      16.768  19.418   9.689  1.00 55.01           O  
ATOM    333  N   TYR A  54      17.773  16.069   8.381  1.00 52.50           N  
ATOM    334  CA  TYR A  54      18.986  15.681   7.674  1.00 52.53           C  
ATOM    335  C   TYR A  54      18.696  15.078   6.301  1.00 52.78           C  
ATOM    336  O   TYR A  54      19.296  15.506   5.320  1.00 52.72           O  
ATOM    337  CB  TYR A  54      19.833  14.712   8.498  1.00 53.12           C  
ATOM    338  CG  TYR A  54      21.060  14.237   7.740  1.00 53.14           C  
ATOM    339  CD1 TYR A  54      22.235  14.991   7.734  1.00 55.42           C  
ATOM    340  CD2 TYR A  54      21.035  13.038   7.010  1.00 53.37           C  
ATOM    341  CE1 TYR A  54      23.354  14.569   7.029  1.00 55.28           C  
ATOM    342  CE2 TYR A  54      22.148  12.610   6.299  1.00 53.41           C  
ATOM    343  CZ  TYR A  54      23.300  13.377   6.319  1.00 55.00           C  
ATOM    344  OH  TYR A  54      24.417  12.947   5.628  1.00 55.78           O  
ATOM    345  N   PHE A  55      17.791  14.100   6.235  1.00 52.31           N  
ATOM    346  CA  PHE A  55      17.499  13.419   4.977  1.00 53.22           C  
ATOM    347  C   PHE A  55      16.594  14.215   4.045  1.00 53.74           C  
ATOM    348  O   PHE A  55      16.658  14.037   2.819  1.00 54.29           O  
ATOM    349  CB  PHE A  55      16.928  12.024   5.210  1.00 53.45           C  
ATOM    350  CG  PHE A  55      17.909  11.076   5.845  1.00 53.52           C  
ATOM    351  CD1 PHE A  55      18.968  10.553   5.106  1.00 54.50           C  
ATOM    352  CD2 PHE A  55      17.774  10.706   7.184  1.00 53.32           C  
ATOM    353  CE1 PHE A  55      19.896   9.663   5.709  1.00 54.10           C  
ATOM    354  CE2 PHE A  55      18.687   9.819   7.795  1.00 54.66           C  
ATOM    355  CZ  PHE A  55      19.750   9.304   7.041  1.00 53.69           C  
ATOM    356  N   GLY A  56      15.751  15.076   4.612  1.00 53.41           N  
ATOM    357  CA  GLY A  56      14.786  15.850   3.822  1.00 54.01           C  
ATOM    358  C   GLY A  56      13.717  14.960   3.217  1.00 53.60           C  
ATOM    359  O   GLY A  56      13.157  15.287   2.172  1.00 53.42           O  
ATOM    360  N   ARG A  57      13.482  13.822   3.878  1.00 52.90           N  
ATOM    361  CA  ARG A  57      12.489  12.804   3.516  1.00 52.20           C  
ATOM    362  C   ARG A  57      12.462  11.798   4.667  1.00 52.23           C  
ATOM    363  O   ARG A  57      13.285  11.873   5.583  1.00 52.11           O  
ATOM    364  CB  ARG A  57      12.865  12.074   2.206  1.00 52.22           C  
ATOM    365  CG  ARG A  57      14.283  11.529   2.212  1.00 50.76           C  
ATOM    366  CD  ARG A  57      14.725  10.874   0.895  1.00 52.19           C  
ATOM    367  NE  ARG A  57      16.161  10.622   0.972  1.00 51.51           N  
ATOM    368  CZ  ARG A  57      16.713   9.549   1.541  1.00 51.29           C  
ATOM    369  NH1 ARG A  57      18.026   9.440   1.594  1.00 51.08           N  
ATOM    370  NH2 ARG A  57      15.959   8.575   2.034  1.00 50.90           N  
ATOM    371  N   ILE A  58      11.513  10.872   4.627  1.00 52.56           N  
ATOM    372  CA  ILE A  58      11.478   9.778   5.590  1.00 52.60           C  
ATOM    373  C   ILE A  58      12.502   8.727   5.151  1.00 52.40           C  
ATOM    374  O   ILE A  58      12.324   8.082   4.122  1.00 52.58           O  
ATOM    375  CB  ILE A  58      10.086   9.126   5.689  1.00 52.92           C  
ATOM    376  CG1 ILE A  58       9.021  10.191   6.007  1.00 53.33           C  
ATOM    377  CG2 ILE A  58      10.115   8.029   6.770  1.00 54.29           C  
ATOM    378  CD1 ILE A  58       7.593   9.778   5.675  1.00 54.65           C  
ATOM    379  N   PRO A  59      13.558   8.534   5.954  1.00 52.47           N  
ATOM    380  CA  PRO A  59      14.662   7.635   5.544  1.00 52.16           C  
ATOM    381  C   PRO A  59      14.259   6.157   5.532  1.00 52.46           C  
ATOM    382  O   PRO A  59      13.257   5.793   6.149  1.00 53.68           O  
ATOM    383  CB  PRO A  59      15.741   7.907   6.590  1.00 51.77           C  
ATOM    384  CG  PRO A  59      14.957   8.272   7.827  1.00 53.08           C  
ATOM    385  CD  PRO A  59      13.772   9.104   7.298  1.00 51.84           C  
ATOM    386  N   HIS A  60      14.990   5.318   4.791  1.00 50.60           N  
ATOM    387  CA  HIS A  60      14.753   3.886   4.830  1.00 51.07           C  
ATOM    388  C   HIS A  60      15.459   3.356   6.081  1.00 49.01           C  
ATOM    389  O   HIS A  60      16.498   3.886   6.517  1.00 48.53           O  
ATOM    390  CB  HIS A  60      15.416   3.148   3.645  1.00 50.86           C  
ATOM    391  CG  HIS A  60      14.698   3.270   2.344  1.00 55.84           C  
ATOM    392  ND1 HIS A  60      14.404   4.483   1.755  1.00 59.72           N  
ATOM    393  CD2 HIS A  60      14.277   2.316   1.476  1.00 58.34           C  
ATOM    394  CE1 HIS A  60      13.798   4.271   0.598  1.00 60.10           C  
ATOM    395  NE2 HIS A  60      13.714   2.964   0.400  1.00 60.74           N  
ATOM    396  N   VAL A  61      14.949   2.262   6.630  1.00 48.49           N  
ATOM    397  CA  VAL A  61      15.713   1.541   7.661  1.00 48.49           C  
ATOM    398  C   VAL A  61      17.072   1.166   7.074  1.00 48.49           C  
ATOM    399  O   VAL A  61      17.156   0.729   5.918  1.00 48.85           O  
ATOM    400  CB  VAL A  61      14.952   0.269   8.146  1.00 48.56           C  
ATOM    401  CG1 VAL A  61      15.839  -0.604   9.029  1.00 47.41           C  
ATOM    402  CG2 VAL A  61      13.648   0.673   8.883  1.00 51.04           C  
ATOM    403  N   GLY A  62      18.119   1.361   7.871  1.00 47.71           N  
ATOM    404  CA  GLY A  62      19.481   1.058   7.477  1.00 47.44           C  
ATOM    405  C   GLY A  62      20.256   2.282   6.985  1.00 47.06           C  
ATOM    406  O   GLY A  62      21.486   2.210   6.846  1.00 47.11           O  
ATOM    407  N   GLU A  63      19.562   3.368   6.677  1.00 45.71           N  
ATOM    408  CA  GLU A  63      20.268   4.611   6.335  1.00 45.87           C  
ATOM    409  C   GLU A  63      20.850   5.213   7.611  1.00 45.92           C  
ATOM    410  O   GLU A  63      20.372   4.911   8.706  1.00 46.12           O  
ATOM    411  CB  GLU A  63      19.370   5.608   5.629  1.00 45.40           C  
ATOM    412  CG  GLU A  63      18.923   5.151   4.240  1.00 46.60           C  
ATOM    413  CD  GLU A  63      18.283   6.290   3.469  1.00 49.84           C  
ATOM    414  OE1 GLU A  63      19.016   7.121   2.900  1.00 51.96           O  
ATOM    415  OE2 GLU A  63      17.037   6.374   3.434  1.00 54.15           O  
ATOM    416  N   TYR A  64      21.926   5.988   7.474  1.00 45.75           N  
ATOM    417  CA  TYR A  64      22.594   6.549   8.654  1.00 45.93           C  
ATOM    418  C   TYR A  64      23.296   7.840   8.311  1.00 46.32           C  
ATOM    419  O   TYR A  64      23.480   8.166   7.116  1.00 44.37           O  
ATOM    420  CB  TYR A  64      23.619   5.571   9.250  1.00 46.35           C  
ATOM    421  CG  TYR A  64      24.763   5.225   8.301  1.00 48.79           C  
ATOM    422  CD1 TYR A  64      25.924   6.021   8.234  1.00 49.10           C  
ATOM    423  CD2 TYR A  64      24.657   4.135   7.424  1.00 49.77           C  
ATOM    424  CE1 TYR A  64      26.968   5.690   7.374  1.00 50.13           C  
ATOM    425  CE2 TYR A  64      25.688   3.800   6.559  1.00 52.69           C  
ATOM    426  CZ  TYR A  64      26.844   4.585   6.539  1.00 51.88           C  
ATOM    427  OH  TYR A  64      27.866   4.260   5.680  1.00 51.41           O  
ATOM    428  N   PHE A  65      23.654   8.587   9.354  1.00 46.43           N  
ATOM    429  CA  PHE A  65      24.487   9.774   9.178  1.00 47.91           C  
ATOM    430  C   PHE A  65      25.309   9.932  10.450  1.00 49.16           C  
ATOM    431  O   PHE A  65      25.001   9.317  11.468  1.00 48.19           O  
ATOM    432  CB  PHE A  65      23.638  11.029   8.894  1.00 47.73           C  
ATOM    433  CG  PHE A  65      22.699  11.417  10.026  1.00 49.44           C  
ATOM    434  CD1 PHE A  65      21.445  10.806  10.150  1.00 49.48           C  
ATOM    435  CD2 PHE A  65      23.064  12.392  10.960  1.00 51.36           C  
ATOM    436  CE1 PHE A  65      20.547  11.154  11.183  1.00 51.90           C  
ATOM    437  CE2 PHE A  65      22.170  12.746  12.010  1.00 52.33           C  
ATOM    438  CZ  PHE A  65      20.908  12.109  12.108  1.00 51.91           C  
ATOM    439  N   ASP A  66      26.343  10.773  10.382  1.00 50.59           N  
ATOM    440  CA  ASP A  66      27.188  11.028  11.537  1.00 53.17           C  
ATOM    441  C   ASP A  66      26.946  12.421  12.092  1.00 54.60           C  
ATOM    442  O   ASP A  66      26.775  13.395  11.328  1.00 53.91           O  
ATOM    443  CB  ASP A  66      28.646  10.838  11.164  1.00 53.26           C  
ATOM    444  CG  ASP A  66      28.933   9.428  10.632  1.00 54.66           C  
ATOM    445  OD1 ASP A  66      28.212   8.457  10.967  1.00 56.56           O  
ATOM    446  OD2 ASP A  66      29.882   9.287   9.860  1.00 56.04           O  
ATOM    447  N   TRP A  67      26.930  12.516  13.419  1.00 56.17           N  
ATOM    448  CA  TRP A  67      26.605  13.770  14.094  1.00 57.77           C  
ATOM    449  C   TRP A  67      27.311  13.768  15.431  1.00 57.94           C  
ATOM    450  O   TRP A  67      27.148  12.837  16.226  1.00 57.79           O  
ATOM    451  CB  TRP A  67      25.085  13.875  14.271  1.00 59.33           C  
ATOM    452  CG  TRP A  67      24.606  15.024  15.142  1.00 61.31           C  
ATOM    453  CD1 TRP A  67      24.509  16.357  14.791  1.00 62.79           C  
ATOM    454  CD2 TRP A  67      24.129  14.930  16.492  1.00 62.46           C  
ATOM    455  NE1 TRP A  67      24.023  17.091  15.855  1.00 63.34           N  
ATOM    456  CE2 TRP A  67      23.771  16.238  16.905  1.00 64.05           C  
ATOM    457  CE3 TRP A  67      23.973  13.869  17.393  1.00 62.31           C  
ATOM    458  CZ2 TRP A  67      23.270  16.509  18.195  1.00 64.17           C  
ATOM    459  CZ3 TRP A  67      23.466  14.141  18.672  1.00 62.79           C  
ATOM    460  CH2 TRP A  67      23.126  15.450  19.054  1.00 61.91           C  
ATOM    461  N   ALA A  68      28.127  14.795  15.654  1.00 58.60           N  
ATOM    462  CA  ALA A  68      28.837  14.981  16.930  1.00 58.51           C  
ATOM    463  C   ALA A  68      29.689  13.781  17.385  1.00 58.29           C  
ATOM    464  O   ALA A  68      29.696  13.449  18.582  1.00 59.60           O  
ATOM    465  CB  ALA A  68      27.822  15.356  18.019  1.00 58.85           C  
ATOM    466  N   GLY A  69      30.405  13.143  16.453  1.00 57.00           N  
ATOM    467  CA  GLY A  69      31.218  11.951  16.743  1.00 54.55           C  
ATOM    468  C   GLY A  69      30.428  10.641  16.941  1.00 53.73           C  
ATOM    469  O   GLY A  69      30.978   9.656  17.439  1.00 53.97           O  
ATOM    470  N   TRP A  70      29.153  10.621  16.546  1.00 52.65           N  
ATOM    471  CA  TRP A  70      28.319   9.406  16.664  1.00 51.57           C  
ATOM    472  C   TRP A  70      27.706   9.066  15.315  1.00 51.78           C  
ATOM    473  O   TRP A  70      27.436   9.981  14.515  1.00 52.36           O  
ATOM    474  CB  TRP A  70      27.174   9.654  17.665  1.00 52.23           C  
ATOM    475  CG  TRP A  70      27.660   9.742  19.079  1.00 52.08           C  
ATOM    476  CD1 TRP A  70      28.255  10.812  19.689  1.00 54.40           C  
ATOM    477  CD2 TRP A  70      27.589   8.705  20.045  1.00 52.77           C  
ATOM    478  NE1 TRP A  70      28.566  10.497  20.996  1.00 54.12           N  
ATOM    479  CE2 TRP A  70      28.170   9.207  21.242  1.00 52.32           C  
ATOM    480  CE3 TRP A  70      27.087   7.395  20.023  1.00 51.97           C  
ATOM    481  CZ2 TRP A  70      28.262   8.447  22.406  1.00 53.03           C  
ATOM    482  CZ3 TRP A  70      27.199   6.621  21.191  1.00 55.38           C  
ATOM    483  CH2 TRP A  70      27.786   7.166  22.367  1.00 52.09           C  
ATOM    484  N   ARG A  71      27.443   7.785  15.082  1.00 49.55           N  
ATOM    485  CA  ARG A  71      26.677   7.379  13.918  1.00 48.97           C  
ATOM    486  C   ARG A  71      25.251   7.077  14.361  1.00 48.13           C  
ATOM    487  O   ARG A  71      25.037   6.338  15.325  1.00 48.82           O  
ATOM    488  CB  ARG A  71      27.271   6.126  13.282  1.00 49.41           C  
ATOM    489  CG  ARG A  71      26.464   5.579  12.088  1.00 51.76           C  
ATOM    490  CD  ARG A  71      27.367   4.817  11.169  1.00 56.41           C  
ATOM    491  NE  ARG A  71      28.376   5.706  10.575  1.00 56.99           N  
ATOM    492  CZ  ARG A  71      29.350   5.288   9.774  1.00 59.30           C  
ATOM    493  NH1 ARG A  71      29.431   3.998   9.452  1.00 59.61           N  
ATOM    494  NH2 ARG A  71      30.220   6.161   9.269  1.00 59.53           N  
ATOM    495  N   ILE A  72      24.293   7.637  13.636  0.50 47.45           N  
ATOM    497  CA  ILE A  72      22.872   7.460  13.927  0.50 47.57           C  
ATOM    499  C   ILE A  72      22.212   6.712  12.777  0.50 47.15           C  
ATOM    501  O   ILE A  72      22.141   7.227  11.662  0.50 46.47           O  
ATOM    503  CB  ILE A  72      22.168   8.828  14.105  0.50 47.83           C  
ATOM    505  CG1 ILE A  72      22.896   9.668  15.162  0.50 48.72           C  
ATOM    507  CG2 ILE A  72      20.681   8.636  14.475  0.50 48.49           C  
ATOM    509  CD1 ILE A  72      22.418  11.104  15.225  0.50 47.85           C  
ATOM    511  N   GLU A  73      21.725   5.513  13.064  1.00 46.77           N  
ATOM    512  CA  GLU A  73      21.208   4.621  12.027  1.00 46.25           C  
ATOM    513  C   GLU A  73      19.729   4.354  12.280  1.00 46.82           C  
ATOM    514  O   GLU A  73      19.331   4.109  13.416  1.00 46.43           O  
ATOM    515  CB  GLU A  73      22.013   3.310  12.016  1.00 47.23           C  
ATOM    516  CG  GLU A  73      21.430   2.301  11.002  1.00 47.65           C  
ATOM    517  CD  GLU A  73      22.224   0.986  10.941  1.00 50.07           C  
ATOM    518  OE1 GLU A  73      23.269   0.848  11.652  1.00 53.32           O  
ATOM    519  OE2 GLU A  73      21.779   0.096  10.184  1.00 52.88           O  
ATOM    520  N   ILE A  74      18.906   4.431  11.234  1.00 45.83           N  
ATOM    521  CA  ILE A  74      17.483   4.171  11.377  1.00 46.51           C  
ATOM    522  C   ILE A  74      17.330   2.666  11.523  1.00 47.24           C  
ATOM    523  O   ILE A  74      17.782   1.930  10.662  1.00 47.43           O  
ATOM    524  CB  ILE A  74      16.717   4.605  10.087  1.00 46.25           C  
ATOM    525  CG1 ILE A  74      17.034   6.083   9.764  1.00 49.17           C  
ATOM    526  CG2 ILE A  74      15.192   4.272  10.210  1.00 45.63           C  
ATOM    527  CD1 ILE A  74      16.746   6.992  10.838  1.00 52.56           C  
ATOM    528  N   VAL A  75      16.694   2.191  12.593  1.00 48.40           N  
ATOM    529  CA  VAL A  75      16.533   0.722  12.683  1.00 48.84           C  
ATOM    530  C   VAL A  75      15.089   0.230  12.692  1.00 48.29           C  
ATOM    531  O   VAL A  75      14.851  -0.945  12.425  1.00 47.28           O  
ATOM    532  CB  VAL A  75      17.348   0.061  13.812  1.00 52.21           C  
ATOM    533  CG1 VAL A  75      18.880   0.253  13.608  1.00 52.51           C  
ATOM    534  CG2 VAL A  75      16.867   0.520  15.118  1.00 52.77           C  
ATOM    535  N   ASP A  76      14.132   1.135  12.944  1.00 46.91           N  
ATOM    536  CA  ASP A  76      12.716   0.790  12.795  1.00 47.65           C  
ATOM    537  C   ASP A  76      11.865   1.961  12.438  1.00 47.99           C  
ATOM    538  O   ASP A  76      11.997   3.006  13.056  1.00 47.87           O  
ATOM    539  CB  ASP A  76      12.133   0.181  14.072  1.00 47.78           C  
ATOM    540  CG  ASP A  76      10.676  -0.234  13.896  1.00 47.10           C  
ATOM    541  OD1 ASP A  76      10.394  -1.073  13.021  1.00 46.15           O  
ATOM    542  OD2 ASP A  76       9.811   0.285  14.605  1.00 47.88           O  
ATOM    543  N   LEU A  77      10.979   1.742  11.454  1.00 47.97           N  
ATOM    544  CA  LEU A  77       9.904   2.691  11.131  1.00 48.47           C  
ATOM    545  C   LEU A  77       8.580   2.067  11.546  1.00 47.93           C  
ATOM    546  O   LEU A  77       8.419   0.827  11.491  1.00 47.72           O  
ATOM    547  CB  LEU A  77       9.878   2.946   9.620  1.00 49.18           C  
ATOM    548  CG  LEU A  77      11.129   3.571   8.979  1.00 51.90           C  
ATOM    549  CD1 LEU A  77      10.948   3.643   7.464  1.00 56.39           C  
ATOM    550  CD2 LEU A  77      11.376   4.964   9.543  1.00 53.11           C  
ATOM    551  N   ASP A  78       7.619   2.908  11.918  1.00 47.01           N  
ATOM    552  CA  ASP A  78       6.236   2.457  11.996  1.00 47.93           C  
ATOM    553  C   ASP A  78       5.477   3.364  11.078  1.00 48.39           C  
ATOM    554  O   ASP A  78       5.163   4.500  11.466  1.00 47.58           O  
ATOM    555  CB  ASP A  78       5.707   2.527  13.421  1.00 47.23           C  
ATOM    556  CG  ASP A  78       6.455   1.611  14.340  1.00 48.65           C  
ATOM    557  OD1 ASP A  78       6.834   0.504  13.900  1.00 46.27           O  
ATOM    558  OD2 ASP A  78       6.685   1.975  15.487  1.00 45.64           O  
ATOM    559  N   GLY A  79       5.261   2.899   9.851  1.00 48.13           N  
ATOM    560  CA  GLY A  79       4.690   3.777   8.822  1.00 50.07           C  
ATOM    561  C   GLY A  79       5.669   4.920   8.629  1.00 50.13           C  
ATOM    562  O   GLY A  79       6.845   4.694   8.383  1.00 50.18           O  
ATOM    563  N   ALA A  80       5.188   6.151   8.784  1.00 50.48           N  
ATOM    564  CA  ALA A  80       6.035   7.333   8.611  1.00 50.07           C  
ATOM    565  C   ALA A  80       6.911   7.666   9.841  1.00 49.92           C  
ATOM    566  O   ALA A  80       7.858   8.463   9.742  1.00 50.84           O  
ATOM    567  CB  ALA A  80       5.168   8.544   8.229  1.00 50.56           C  
ATOM    568  N   ARG A  81       6.588   7.065  10.985  0.70 48.80           N  
ATOM    570  CA  ARG A  81       7.285   7.376  12.232  0.70 48.06           C  
ATOM    572  C   ARG A  81       8.663   6.728  12.263  0.70 48.63           C  
ATOM    574  O   ARG A  81       8.794   5.527  12.024  0.70 48.70           O  
ATOM    576  CB  ARG A  81       6.465   6.938  13.453  0.70 47.68           C  
ATOM    578  CG  ARG A  81       7.115   7.290  14.805  0.70 48.11           C  
ATOM    580  CD  ARG A  81       6.192   6.964  15.986  0.70 48.38           C  
ATOM    582  NE  ARG A  81       6.046   5.514  16.188  0.70 49.79           N  
ATOM    584  CZ  ARG A  81       4.988   4.933  16.759  0.70 50.29           C  
ATOM    586  NH1 ARG A  81       3.955   5.666  17.178  0.70 51.50           N  
ATOM    588  NH2 ARG A  81       4.946   3.609  16.894  0.70 45.12           N  
ATOM    590  N   ILE A  82       9.685   7.530  12.546  1.00 48.33           N  
ATOM    591  CA  ILE A  82      11.040   6.986  12.795  1.00 48.89           C  
ATOM    592  C   ILE A  82      11.019   6.530  14.247  1.00 47.86           C  
ATOM    593  O   ILE A  82      11.167   7.344  15.189  1.00 49.39           O  
ATOM    594  CB  ILE A  82      12.138   8.029  12.543  1.00 49.66           C  
ATOM    595  CG1 ILE A  82      12.025   8.555  11.103  1.00 52.12           C  
ATOM    596  CG2 ILE A  82      13.538   7.449  12.895  1.00 51.08           C  
ATOM    597  CD1 ILE A  82      12.981   9.676  10.773  1.00 53.47           C  
ATOM    598  N   ASP A  83      10.834   5.228  14.424  1.00 47.34           N  
ATOM    599  CA  ASP A  83      10.506   4.718  15.727  1.00 47.01           C  
ATOM    600  C   ASP A  83      11.721   4.344  16.588  1.00 46.05           C  
ATOM    601  O   ASP A  83      11.682   4.557  17.792  1.00 46.65           O  
ATOM    602  CB  ASP A  83       9.519   3.564  15.635  1.00 47.17           C  
ATOM    603  CG  ASP A  83       8.912   3.210  16.990  1.00 47.01           C  
ATOM    604  OD1 ASP A  83       8.290   4.111  17.606  1.00 46.99           O  
ATOM    605  OD2 ASP A  83       9.082   2.042  17.476  1.00 46.62           O  
HETATM  606  N   MLY A  84      12.791   3.819  15.982  1.00 45.87           N  
HETATM  607  CA  MLY A  84      13.956   3.397  16.759  1.00 45.64           C  
HETATM  608  CB  MLY A  84      13.862   1.898  17.076  1.00 44.52           C  
HETATM  609  CG  MLY A  84      14.710   1.490  18.302  1.00 45.67           C  
HETATM  610  CD  MLY A  84      13.850   1.725  19.588  1.00 49.68           C  
HETATM  611  CE  MLY A  84      14.562   1.351  20.863  1.00 49.77           C  
HETATM  612  NZ  MLY A  84      13.665   1.325  22.033  1.00 49.16           N  
HETATM  613  CH1 MLY A  84      14.565   1.046  23.159  1.00 47.78           C  
HETATM  614  CH2 MLY A  84      13.026   2.655  22.252  1.00 46.83           C  
HETATM  615  C   MLY A  84      15.210   3.695  15.978  1.00 46.29           C  
HETATM  616  O   MLY A  84      15.251   3.452  14.749  1.00 46.73           O  
ATOM    617  N   LEU A  85      16.234   4.182  16.681  1.00 46.79           N  
ATOM    618  CA  LEU A  85      17.527   4.509  16.084  1.00 47.56           C  
ATOM    619  C   LEU A  85      18.617   3.752  16.823  1.00 48.44           C  
ATOM    620  O   LEU A  85      18.475   3.494  18.023  1.00 48.32           O  
ATOM    621  CB  LEU A  85      17.840   6.009  16.276  1.00 47.53           C  
ATOM    622  CG  LEU A  85      17.044   7.115  15.549  1.00 49.02           C  
ATOM    623  CD1 LEU A  85      17.006   6.890  14.069  1.00 49.92           C  
ATOM    624  CD2 LEU A  85      15.610   7.212  16.102  1.00 48.07           C  
ATOM    625  N   LEU A  86      19.710   3.433  16.129  1.00 47.04           N  
ATOM    626  CA  LEU A  86      20.875   2.865  16.781  1.00 47.44           C  
ATOM    627  C   LEU A  86      21.945   3.949  16.778  1.00 48.53           C  
ATOM    628  O   LEU A  86      22.247   4.514  15.699  1.00 48.10           O  
ATOM    629  CB  LEU A  86      21.346   1.652  15.996  1.00 47.04           C  
ATOM    630  CG  LEU A  86      22.727   1.108  16.390  1.00 48.51           C  
ATOM    631  CD1 LEU A  86      22.680   0.490  17.827  1.00 46.99           C  
ATOM    632  CD2 LEU A  86      23.186   0.069  15.373  1.00 49.01           C  
ATOM    633  N   LEU A  87      22.530   4.223  17.950  1.00 47.40           N  
ATOM    634  CA  LEU A  87      23.604   5.231  18.101  1.00 49.03           C  
ATOM    635  C   LEU A  87      24.898   4.502  18.463  1.00 49.45           C  
ATOM    636  O   LEU A  87      24.924   3.735  19.443  1.00 46.40           O  
ATOM    637  CB  LEU A  87      23.231   6.202  19.230  1.00 50.14           C  
ATOM    638  CG  LEU A  87      22.421   7.475  18.910  1.00 52.71           C  
ATOM    639  CD1 LEU A  87      23.350   8.590  18.464  1.00 54.98           C  
ATOM    640  CD2 LEU A  87      21.268   7.201  17.922  1.00 52.69           C  
ATOM    641  N   GLN A  88      25.965   4.709  17.677  1.00 49.25           N  
ATOM    642  CA  GLN A  88      27.244   4.045  17.927  1.00 53.32           C  
ATOM    643  C   GLN A  88      28.320   5.104  17.876  1.00 53.32           C  
ATOM    644  O   GLN A  88      28.328   5.943  16.973  1.00 50.92           O  
ATOM    645  CB  GLN A  88      27.583   2.998  16.867  1.00 53.32           C  
ATOM    646  CG  GLN A  88      26.611   1.882  16.711  1.00 57.54           C  
ATOM    647  CD  GLN A  88      27.067   0.903  15.618  1.00 57.74           C  
ATOM    648  OE1 GLN A  88      26.636   0.994  14.464  1.00 63.84           O  
ATOM    649  NE2 GLN A  88      27.952  -0.008  15.979  1.00 60.97           N  
ATOM    650  N   ARG A  89      29.228   5.078  18.840  1.00 54.91           N  
ATOM    651  CA  ARG A  89      30.277   6.092  18.873  1.00 57.69           C  
ATOM    652  C   ARG A  89      31.257   5.816  17.747  1.00 58.95           C  
ATOM    653  O   ARG A  89      31.629   4.662  17.541  1.00 59.57           O  
ATOM    654  CB  ARG A  89      30.996   6.131  20.240  1.00 58.09           C  
ATOM    655  CG  ARG A  89      31.701   7.465  20.424  1.00 60.24           C  
ATOM    656  CD  ARG A  89      31.733   7.909  21.870  1.00 65.21           C  
ATOM    657  NE  ARG A  89      32.877   7.335  22.563  1.00 67.82           N  
ATOM    658  CZ  ARG A  89      33.075   7.372  23.881  1.00 69.04           C  
ATOM    659  NH1 ARG A  89      34.160   6.803  24.378  1.00 70.15           N  
ATOM    660  NH2 ARG A  89      32.197   7.951  24.702  1.00 68.23           N  
ATOM    661  N   LEU A  90      31.647   6.857  17.006  1.00 60.24           N  
ATOM    662  CA  LEU A  90      32.559   6.665  15.873  1.00 62.04           C  
ATOM    663  C   LEU A  90      33.945   6.242  16.383  1.00 63.59           C  
ATOM    664  O   LEU A  90      34.509   6.867  17.279  1.00 62.93           O  
ATOM    665  CB  LEU A  90      32.597   7.886  14.957  1.00 61.68           C  
ATOM    666  CG  LEU A  90      31.299   8.085  14.159  1.00 62.54           C  
ATOM    667  CD1 LEU A  90      31.281   9.481  13.533  1.00 62.47           C  
ATOM    668  CD2 LEU A  90      31.122   6.993  13.090  1.00 62.68           C  
ATOM    669  N   ASN A  91      34.441   5.161  15.780  1.00 65.35           N  
ATOM    670  CA  ASN A  91      35.349   4.182  16.407  1.00 67.34           C  
ATOM    671  C   ASN A  91      36.363   4.685  17.423  1.00 67.83           C  
ATOM    672  O   ASN A  91      36.612   4.004  18.420  1.00 68.61           O  
ATOM    673  CB  ASN A  91      36.038   3.324  15.334  1.00 67.92           C  
ATOM    674  CG  ASN A  91      35.057   2.811  14.284  1.00 70.16           C  
ATOM    675  OD1 ASN A  91      34.306   3.596  13.673  1.00 72.03           O  
ATOM    676  ND2 ASN A  91      35.048   1.491  14.071  1.00 71.76           N  
TER     677      ASN A  91                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
