
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   84 (  671),  selected   84 , name 2r2z_A
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2r2z_A.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     5_A      D       5          3.894
LGA    L     6_A      E       6          1.353
LGA    Y     7_A      I       7          0.538
LGA    T     8_A      V       8          0.523
LGA    Q     9_A      Q       9          0.289
LGA    V    10_A      R      10          0.952
LGA    A    11_A      E      11          2.075
LGA    D    12_A      D      12          3.021
LGA    N    13_A      G      13          2.457
LGA    E    14_A      S      14          0.320
LGA    Y    15_A      W      15          0.335
LGA    L    16_A      L      16          0.632
LGA    V    17_A      V      17          0.670
LGA    Q    18_A      D      18          0.692
LGA    G    19_A      G      19          0.595
LGA    R    20_A      M      20          0.708
LGA    X    21_A      V      21          0.485
LGA    L    22_A      S      22          0.760
LGA    I    23_A      L      23          1.109
LGA    D    24_A      D      24          1.331
LGA    E    25_A      R      25          0.710
LGA    F    26_A      F      26          0.445
LGA    N    27_A      R      27          0.979
LGA    E    28_A      E      28          0.897
LGA    V    29_A      F      29          0.986
LGA    F    30_A      F      30          1.136
LGA    E    31_A      E      31          0.782
LGA    T    32_A      L      32          1.501
LGA    D    33_A      E      33          3.237
LGA    -       -      A      34           -
LGA    L    34_A      P      35          3.146
LGA    H    35_A      L      36          3.556
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    X    36_A      E      39          0.687
LGA    S    37_A      A      40          3.751
LGA    -       -      G      41           -
LGA    -       -      G      42           -
LGA    D    38_A      N      43          0.727
LGA    V    39_A      I      44          0.461
LGA    D    40_A      H      45          0.308
LGA    T    41_A      T      46          0.138
LGA    X    42_A      L      47          0.314
LGA    A    43_A      A      48          0.466
LGA    G    44_A      G      49          0.416
LGA    Y    45_A      V      50          0.614
LGA    L    46_A      M      51          1.160
LGA    I    47_A      L      52          1.352
LGA    T    48_A      Y      53          0.749
LGA    A    49_A      Q      54          0.943
LGA    L    50_A      L      55          1.249
LGA    G    51_A      G      56          2.518
LGA    T    52_A      R      57          4.264
LGA    I    53_A      V      58          1.424
LGA    P    54_A      P      59          2.079
LGA    D    55_A      S      60          3.873
LGA    E    56_A      -       -           -
LGA    G    57_A      -       -           -
LGA    E    58_A      V      61          2.496
LGA    K    59_A      T      62          1.453
LGA    P    60_A      D      63          0.488
LGA    S    61_A      R      64          0.453
LGA    F    62_A      F      65          1.507
LGA    E    63_A      E      66          0.901
LGA    V    64_A      W      67          0.307
LGA    G    65_A      N      68          0.958
LGA    N    66_A      G      69          0.595
LGA    I    67_A      F      70          0.151
LGA    K    68_A      S      71          0.300
LGA    L    69_A      F      72          0.300
LGA    T    70_A      E      73          0.516
LGA    A    71_A      V      74          0.729
LGA    E    72_A      V      75          1.015
LGA    E    73_A      D      76          0.558
LGA    X    74_A      M      77          0.309
LGA    E    75_A      D      78          0.204
LGA    G    76_A      R      79          0.409
LGA    T    77_A      T      80          0.568
LGA    R    78_A      R      81          0.404
LGA    L    79_A      V      82          0.363
LGA    L    80_A      D      83          0.589
LGA    V    81_A      K      84          0.737
LGA    L    82_A      I      85          0.599
LGA    R    83_A      L      86          0.415
LGA    V    84_A      V      87          0.470
LGA    H    85_A      Q      88          1.241
LGA    F    86_A      R      89          1.001
LGA    Y    87_A      H      90          0.508
LGA    D    88_A      H      91          2.154

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   84   87    5.0     82    1.48    25.61     89.045     5.202

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.248863 * X  +  -0.702783 * Y  +  -0.666456 * Z  +  31.141068
  Y_new =  -0.293798 * X  +   0.600906 * Y  +  -0.743367 * Z  +   2.311801
  Z_new =   0.922903 * X  +   0.380800 * Y  +  -0.056933 * Z  +   6.110171 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.719206   -1.422386  [ DEG:    98.5033    -81.4967 ]
  Theta =  -1.175553   -1.966039  [ DEG:   -67.3542   -112.6458 ]
  Phi   =  -0.868015    2.273578  [ DEG:   -49.7336    130.2664 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2r2z_A                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2r2z_A.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   84   87   5.0   82   1.48   25.61  89.045
REMARK  ---------------------------------------------------------- 
MOLECULE 2r2z_A
HEADER    TOXIN                                   28-AUG-07   2R2Z              
TITLE     THE CRYSTAL STRUCTURE OF A HEMOLYSIN DOMAIN FROM                      
TITLE    2 ENTEROCOCCUS FAECALIS V583                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HEMOLYSIN;                                                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: DOMAIN: RESIDUES 346-435;                                  
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ENTEROCOCCUS FAECALIS V583;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: V583;                                                        
SOURCE   5 ATCC: 700802;                                                        
SOURCE   6 GENE: EF_0700;                                                       
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    APC85144, HEMOLYSIN DOMAIN, ENTEROCOCCUS FAECALIS V583,               
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG, PSI-2, PROTEIN STRUCTURE INITIATIVE,                 
KEYWDS   4 MEMBRANE, TRANSMEMBRANE, TOXIN                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,K.TAN,M.ZHOU,M.BARGASSA,A.JOACHIMIAK,MIDWEST CENTER           
AUTHOR   2 FOR STRUCTURAL GENOMICS (MCSG)                                       
REVDAT   1   04-SEP-07 2R2Z    0                                                
JRNL        AUTH   R.ZHANG,K.TAN,M.ZHOU,M.BARGASSA,A.JOACHIMIAK                 
JRNL        TITL   THE CRYSTAL STRUCTURE OF A HEMOLYSIN DOMAIN FROM             
JRNL        TITL 2 ENTEROCOCCUS FAECALIS V583.                                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.20 ANGSTROMS.                                          
DBREF  2R2Z A    1    90  UNP    Q837X5   Q837X5_ENTFA   346    435             
SEQRES   1 A   93  SER ASN ALA ASP GLU VAL GLU ASN LEU TYR THR GLN VAL          
SEQRES   2 A   93  ALA ASP ASN GLU TYR LEU VAL GLN GLY ARG MSE LEU ILE          
SEQRES   3 A   93  ASP GLU PHE ASN GLU VAL PHE GLU THR ASP LEU HIS MSE          
SEQRES   4 A   93  SER ASP VAL ASP THR MSE ALA GLY TYR LEU ILE THR ALA          
SEQRES   5 A   93  LEU GLY THR ILE PRO ASP GLU GLY GLU LYS PRO SER PHE          
SEQRES   6 A   93  GLU VAL GLY ASN ILE LYS LEU THR ALA GLU GLU MSE GLU          
SEQRES   7 A   93  GLY THR ARG LEU LEU VAL LEU ARG VAL HIS PHE TYR ASP          
SEQRES   8 A   93  GLU GLU                                                      
HET    MSE  A  21       8                                                       
HET    MSE  A  36       8                                                       
HET    MSE  A  42       8                                                       
HET    MSE  A  74       8                                                       
HET     ZN  A  91       1                                                       
HET     ZN  A  92       1                                                       
HET     ZN  A  93       1                                                       
HET     ZN  A  94       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      ZN ZINC ION                                                         
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   2   ZN    4(ZN 2+)                                                     
FORMUL   6  HOH   *144(H2 O)                                                    
CRYST1   39.494   39.494  101.258  90.00  90.00 120.00 P 65          6          
ATOM      1  N   ASN A   5      11.717   3.591  29.248  1.00 22.25           N  
ATOM      2  CA  ASN A   5      12.926   4.440  29.057  1.00 21.47           C  
ATOM      3  C   ASN A   5      13.068   4.957  27.626  1.00 19.44           C  
ATOM      4  O   ASN A   5      12.581   4.354  26.666  1.00 19.61           O  
ATOM      5  CB  ASN A   5      14.205   3.715  29.528  1.00 23.10           C  
ATOM      6  CG  ASN A   5      14.199   2.231  29.209  1.00 24.73           C  
ATOM      7  OD1 ASN A   5      14.183   1.388  30.115  0.70 27.87           O  
ATOM      8  ND2 ASN A   5      14.219   1.898  27.926  0.70 27.50           N  
ATOM      9  N   LEU A   6      13.739   6.094  27.492  1.00 16.19           N  
ATOM     10  CA  LEU A   6      13.907   6.742  26.198  1.00 13.81           C  
ATOM     11  C   LEU A   6      15.028   6.128  25.382  1.00 12.11           C  
ATOM     12  O   LEU A   6      15.127   6.379  24.188  1.00 11.24           O  
ATOM     13  CB  LEU A   6      14.172   8.227  26.392  1.00 14.29           C  
ATOM     14  CG  LEU A   6      13.008   9.063  26.913  1.00 15.70           C  
ATOM     15  CD1 LEU A   6      13.535  10.390  27.451  1.00 18.29           C  
ATOM     16  CD2 LEU A   6      12.010   9.284  25.796  1.00 18.13           C  
ATOM     17  N   TYR A   7      15.881   5.348  26.032  1.00 11.29           N  
ATOM     18  CA  TYR A   7      16.986   4.687  25.335  1.00 11.19           C  
ATOM     19  C   TYR A   7      17.347   3.426  26.071  1.00 11.35           C  
ATOM     20  O   TYR A   7      17.028   3.272  27.255  1.00 11.52           O  
ATOM     21  CB  TYR A   7      18.220   5.598  25.224  1.00 12.82           C  
ATOM     22  CG  TYR A   7      18.915   5.827  26.540  1.00 14.17           C  
ATOM     23  CD1 TYR A   7      20.011   5.042  26.923  1.00 17.60           C  
ATOM     24  CD2 TYR A   7      18.463   6.806  27.426  1.00 14.77           C  
ATOM     25  CE1 TYR A   7      20.640   5.244  28.146  1.00 18.59           C  
ATOM     26  CE2 TYR A   7      19.074   6.999  28.659  1.00 18.29           C  
ATOM     27  CZ  TYR A   7      20.151   6.209  29.004  1.00 18.54           C  
ATOM     28  OH  TYR A   7      20.782   6.417  30.211  1.00 20.03           O  
ATOM     29  N   THR A   8      18.049   2.542  25.380  1.00 11.67           N  
ATOM     30  CA  THR A   8      18.658   1.402  26.025  1.00 13.30           C  
ATOM     31  C   THR A   8      19.978   1.092  25.350  1.00 12.43           C  
ATOM     32  O   THR A   8      20.136   1.235  24.130  1.00 12.69           O  
ATOM     33  CB  THR A   8      17.799   0.135  25.991  1.00 14.31           C  
ATOM     34  OG1 THR A   8      18.515  -0.914  26.672  1.00 17.25           O  
ATOM     35  CG2 THR A   8      17.490  -0.288  24.558  1.00 14.94           C  
ATOM     36  N   GLN A   9      20.949   0.677  26.141  1.00 11.71           N  
ATOM     37  CA  GLN A   9      22.140   0.076  25.576  1.00 11.13           C  
ATOM     38  C   GLN A   9      21.814  -1.276  24.961  1.00 10.22           C  
ATOM     39  O   GLN A   9      20.886  -1.964  25.411  1.00 10.46           O  
ATOM     40  CB  GLN A   9      23.210  -0.051  26.645  1.00 10.83           C  
ATOM     41  CG  GLN A   9      24.571  -0.364  26.091  1.00 11.71           C  
ATOM     42  CD  GLN A   9      25.644  -0.339  27.154  1.00 11.77           C  
ATOM     43  OE1 GLN A   9      25.356  -0.256  28.349  1.00 13.35           O  
ATOM     44  NE2 GLN A   9      26.884  -0.459  26.733  1.00 11.48           N  
ATOM     45  N   VAL A  10      22.571  -1.633  23.922  1.00  9.12           N  
ATOM     46  CA  VAL A  10      22.564  -2.995  23.397  1.00  8.58           C  
ATOM     47  C   VAL A  10      23.944  -3.653  23.439  1.00  8.46           C  
ATOM     48  O   VAL A  10      24.040  -4.883  23.526  1.00  8.37           O  
ATOM     49  CB  VAL A  10      21.903  -3.112  21.992  1.00  8.77           C  
ATOM     50  CG1 VAL A  10      20.418  -2.807  22.090  1.00 10.36           C  
ATOM     51  CG2 VAL A  10      22.569  -2.211  20.965  1.00  8.94           C  
ATOM     52  N   ALA A  11      25.022  -2.875  23.389  1.00  8.14           N  
ATOM     53  CA  ALA A  11      26.364  -3.443  23.381  1.00  8.38           C  
ATOM     54  C   ALA A  11      27.330  -2.317  23.681  1.00  8.03           C  
ATOM     55  O   ALA A  11      26.927  -1.160  23.800  1.00  8.49           O  
ATOM     56  CB  ALA A  11      26.702  -4.076  22.032  1.00  9.25           C  
ATOM     57  N   ASP A  12      28.616  -2.640  23.812  1.00  9.43           N  
ATOM     58  CA  ASP A  12      29.600  -1.577  23.954  1.00  9.82           C  
ATOM     59  C   ASP A  12      29.400  -0.563  22.824  1.00  9.77           C  
ATOM     60  O   ASP A  12      29.318  -0.922  21.641  1.00 10.30           O  
ATOM     61  CB  ASP A  12      31.029  -2.109  23.840  1.00 10.91           C  
ATOM     62  CG  ASP A  12      31.470  -2.909  25.045  1.00 11.96           C  
ATOM     63  OD1 ASP A  12      30.628  -3.234  25.865  1.00 12.58           O  
ATOM     64  OD2 ASP A  12      32.687  -3.178  25.163  1.00 15.87           O  
ATOM     65  N   ASN A  13      29.297   0.710  23.188  1.00  9.02           N  
ATOM     66  CA  ASN A  13      29.234   1.796  22.221  1.00  8.81           C  
ATOM     67  C   ASN A  13      28.020   1.791  21.301  1.00  9.51           C  
ATOM     68  O   ASN A  13      28.031   2.485  20.287  1.00  9.85           O  
ATOM     69  CB  ASN A  13      30.517   1.853  21.377  1.00 10.22           C  
ATOM     70  CG  ASN A  13      31.747   1.805  22.222  1.00 11.98           C  
ATOM     71  OD1 ASN A  13      32.624   0.950  22.017  1.00 17.88           O  
ATOM     72  ND2 ASN A  13      31.782   2.643  23.234  1.00 11.17           N  
ATOM     73  N   GLU A  14      26.962   1.084  21.686  1.00  8.61           N  
ATOM     74  CA  GLU A  14      25.801   0.963  20.807  1.00  8.71           C  
ATOM     75  C   GLU A  14      24.513   0.943  21.603  1.00  8.07           C  
ATOM     76  O   GLU A  14      24.381   0.191  22.579  1.00  8.20           O  
ATOM     77  CB  GLU A  14      25.929  -0.295  19.970  1.00  9.39           C  
ATOM     78  CG  GLU A  14      25.018  -0.350  18.761  1.00 12.29           C  
ATOM     79  CD  GLU A  14      25.379  -1.495  17.839  1.00 16.14           C  
ATOM     80  OE1 GLU A  14      26.470  -2.096  17.972  1.00 20.40           O  
ATOM     81  OE2 GLU A  14      24.573  -1.811  16.965  1.00 16.80           O  
ATOM     82  N   TYR A  15      23.559   1.757  21.146  1.00  7.97           N  
ATOM     83  CA  TYR A  15      22.320   2.017  21.886  1.00  7.25           C  
ATOM     84  C   TYR A  15      21.161   2.101  20.910  1.00  7.64           C  
ATOM     85  O   TYR A  15      21.357   2.403  19.718  1.00  8.80           O  
ATOM     86  CB  TYR A  15      22.418   3.357  22.656  1.00  8.79           C  
ATOM     87  CG  TYR A  15      23.561   3.414  23.644  1.00  8.55           C  
ATOM     88  CD1 TYR A  15      23.338   3.217  25.006  1.00  9.11           C  
ATOM     89  CD2 TYR A  15      24.870   3.599  23.208  1.00  9.73           C  
ATOM     90  CE1 TYR A  15      24.405   3.248  25.913  1.00  9.71           C  
ATOM     91  CE2 TYR A  15      25.930   3.600  24.093  1.00 10.03           C  
ATOM     92  CZ  TYR A  15      25.688   3.414  25.439  1.00  9.90           C  
ATOM     93  OH  TYR A  15      26.771   3.444  26.295  1.00 11.90           O  
ATOM     94  N   LEU A  16      19.957   1.841  21.412  1.00  7.47           N  
ATOM     95  CA  LEU A  16      18.714   2.133  20.701  1.00  7.59           C  
ATOM     96  C   LEU A  16      18.054   3.305  21.403  1.00  8.05           C  
ATOM     97  O   LEU A  16      17.939   3.323  22.625  1.00  9.73           O  
ATOM     98  CB  LEU A  16      17.777   0.914  20.701  1.00  8.56           C  
ATOM     99  CG  LEU A  16      18.345  -0.325  20.007  1.00  8.50           C  
ATOM    100  CD1 LEU A  16      17.414  -1.526  20.201  1.00 10.69           C  
ATOM    101  CD2 LEU A  16      18.579  -0.088  18.516  1.00 10.95           C  
ATOM    102  N   VAL A  17      17.640   4.285  20.618  1.00  8.02           N  
ATOM    103  CA  VAL A  17      17.086   5.533  21.143  1.00  8.27           C  
ATOM    104  C   VAL A  17      15.702   5.743  20.550  1.00  8.49           C  
ATOM    105  O   VAL A  17      15.528   5.660  19.329  1.00  8.94           O  
ATOM    106  CB  VAL A  17      18.017   6.712  20.793  1.00  8.54           C  
ATOM    107  CG1 VAL A  17      17.338   8.082  21.063  1.00 10.96           C  
ATOM    108  CG2 VAL A  17      19.320   6.566  21.570  1.00 10.34           C  
ATOM    109  N   GLN A  18      14.708   5.983  21.400  1.00  8.94           N  
ATOM    110  CA  GLN A  18      13.375   6.285  20.917  0.50  9.04           C  
ATOM    112  C   GLN A  18      13.370   7.625  20.186  1.00  9.57           C  
ATOM    113  O   GLN A  18      13.987   8.599  20.630  1.00  9.30           O  
ATOM    114  CB  GLN A  18      12.383   6.284  22.093  0.50  9.56           C  
ATOM    116  CG  GLN A  18      12.359   4.938  22.853  0.50 10.08           C  
ATOM    118  CD  GLN A  18      11.834   3.803  21.996  0.50  9.97           C  
ATOM    120  OE1 GLN A  18      10.781   3.933  21.381  0.50 11.58           O  
ATOM    122  NE2 GLN A  18      12.560   2.687  21.948  0.50 10.87           N  
ATOM    124  N   GLY A  19      12.657   7.674  19.065  1.00  9.45           N  
ATOM    125  CA  GLY A  19      12.529   8.898  18.271  1.00  9.16           C  
ATOM    126  C   GLY A  19      12.045  10.097  19.075  1.00  8.77           C  
ATOM    127  O   GLY A  19      12.414  11.244  18.786  1.00  9.13           O  
ATOM    128  N   ARG A  20      11.198   9.844  20.076  1.00  9.57           N  
ATOM    129  CA  ARG A  20      10.664  10.935  20.886  1.00 10.83           C  
ATOM    130  C   ARG A  20      11.663  11.571  21.849  1.00  9.98           C  
ATOM    131  O   ARG A  20      11.364  12.614  22.430  1.00 10.94           O  
ATOM    132  CB  ARG A  20       9.450  10.468  21.692  1.00 10.95           C  
ATOM    133  CG  ARG A  20       9.769   9.362  22.693  1.00 12.44           C  
ATOM    134  CD  ARG A  20       8.626   9.127  23.694  1.00 13.88           C  
ATOM    135  NE  ARG A  20       7.330   8.912  23.052  1.00 18.76           N  
ATOM    136  CZ  ARG A  20       6.890   7.754  22.584  1.00 20.29           C  
ATOM    137  NH1 ARG A  20       7.650   6.668  22.651  1.00 20.46           N  
ATOM    138  NH2 ARG A  20       5.681   7.691  22.033  1.00 19.61           N  
HETATM  139  N   MSE A  21      12.830  10.953  22.043  1.00  9.68           N  
HETATM  140  CA  MSE A  21      13.827  11.523  22.936  1.00  9.60           C  
HETATM  141  C   MSE A  21      14.216  12.901  22.429  1.00  8.81           C  
HETATM  142  O   MSE A  21      14.485  13.084  21.242  1.00  9.02           O  
HETATM  143  CB  MSE A  21      15.046  10.619  23.021  1.00  9.28           C  
HETATM  144  CG  MSE A  21      16.026  11.063  24.086  1.00  9.93           C  
HETATM  145 SE   MSE A  21      17.537   9.825  24.260  0.70 11.07          SE  
HETATM  146  CE  MSE A  21      18.138  10.342  26.054  1.00 12.17           C  
ATOM    147  N   LEU A  22      14.251  13.874  23.327  1.00  9.09           N  
ATOM    148  CA  LEU A  22      14.671  15.204  22.930  1.00  9.00           C  
ATOM    149  C   LEU A  22      16.156  15.243  22.600  1.00  8.93           C  
ATOM    150  O   LEU A  22      16.956  14.579  23.255  1.00  9.60           O  
ATOM    151  CB  LEU A  22      14.384  16.196  24.063  1.00 10.69           C  
ATOM    152  CG  LEU A  22      12.902  16.355  24.400  1.00 11.78           C  
ATOM    153  CD1 LEU A  22      12.787  17.253  25.610  1.00 14.29           C  
ATOM    154  CD2 LEU A  22      12.121  16.947  23.246  1.00 14.53           C  
ATOM    155  N   ILE A  23      16.532  16.038  21.599  1.00  9.35           N  
ATOM    156  CA  ILE A  23      17.946  16.252  21.290  1.00  9.41           C  
ATOM    157  C   ILE A  23      18.692  16.698  22.553  1.00  9.88           C  
ATOM    158  O   ILE A  23      19.787  16.211  22.845  1.00  9.19           O  
ATOM    159  CB  ILE A  23      18.122  17.303  20.165  1.00  9.47           C  
ATOM    160  CG1 ILE A  23      17.474  16.830  18.866  1.00 10.63           C  
ATOM    161  CG2 ILE A  23      19.604  17.616  19.949  1.00 11.31           C  
ATOM    162  CD1 ILE A  23      17.296  17.944  17.841  1.00 11.59           C  
ATOM    163  N   ASP A  24      18.112  17.635  23.301  1.00  9.66           N  
ATOM    164  CA  ASP A  24      18.775  18.112  24.511  1.00 11.13           C  
ATOM    165  C   ASP A  24      18.977  16.993  25.552  1.00 11.28           C  
ATOM    166  O   ASP A  24      20.002  16.944  26.234  1.00 11.62           O  
ATOM    167  CB  ASP A  24      17.989  19.288  25.110  1.00 11.70           C  
ATOM    168  CG  ASP A  24      17.999  20.528  24.217  1.00 14.13           C  
ATOM    169  OD1 ASP A  24      18.907  20.667  23.367  1.00 16.18           O  
ATOM    170  OD2 ASP A  24      17.104  21.407  24.387  1.00 15.64           O  
ATOM    171  N   GLU A  25      17.999  16.099  25.668  1.00 11.46           N  
ATOM    172  CA  GLU A  25      18.086  14.926  26.552  1.00 12.56           C  
ATOM    173  C   GLU A  25      19.200  13.981  26.086  1.00 11.30           C  
ATOM    174  O   GLU A  25      19.995  13.499  26.890  1.00 11.48           O  
ATOM    175  CB  GLU A  25      16.743  14.163  26.567  1.00 13.09           C  
ATOM    176  CG  GLU A  25      15.608  14.844  27.360  1.00 15.89           C  
ATOM    177  CD  GLU A  25      14.213  14.202  27.180  1.00 15.15           C  
ATOM    178  OE1 GLU A  25      13.902  13.547  26.138  1.00 13.73           O  
ATOM    179  OE2 GLU A  25      13.389  14.403  28.110  1.00 19.61           O  
ATOM    180  N   PHE A  26      19.243  13.728  24.783  1.00  9.92           N  
ATOM    181  CA  PHE A  26      20.285  12.897  24.198  1.00  9.36           C  
ATOM    182  C   PHE A  26      21.674  13.461  24.534  1.00  8.81           C  
ATOM    183  O   PHE A  26      22.558  12.731  24.972  1.00  8.99           O  
ATOM    184  CB  PHE A  26      20.070  12.821  22.675  1.00  9.68           C  
ATOM    185  CG  PHE A  26      21.078  11.974  21.947  1.00  8.79           C  
ATOM    186  CD1 PHE A  26      20.808  10.640  21.654  1.00 10.68           C  
ATOM    187  CD2 PHE A  26      22.283  12.521  21.530  1.00  9.45           C  
ATOM    188  CE1 PHE A  26      21.737   9.862  20.970  1.00 11.79           C  
ATOM    189  CE2 PHE A  26      23.214  11.758  20.857  1.00 10.19           C  
ATOM    190  CZ  PHE A  26      22.943  10.421  20.575  1.00 10.69           C  
ATOM    191  N   ASN A  27      21.866  14.769  24.346  1.00  9.00           N  
ATOM    192  CA  ASN A  27      23.162  15.363  24.647  1.00  9.41           C  
ATOM    193  C   ASN A  27      23.538  15.242  26.118  1.00 10.48           C  
ATOM    194  O   ASN A  27      24.689  14.989  26.448  1.00 10.25           O  
ATOM    195  CB  ASN A  27      23.198  16.843  24.270  1.00  9.38           C  
ATOM    196  CG  ASN A  27      23.273  17.083  22.780  1.00  9.80           C  
ATOM    197  OD1 ASN A  27      23.710  16.239  21.992  1.00  9.41           O  
ATOM    198  ND2 ASN A  27      22.881  18.282  22.385  1.00 10.59           N  
ATOM    199  N   GLU A  28      22.562  15.405  27.001  1.00 11.21           N  
ATOM    200  CA  GLU A  28      22.816  15.270  28.436  1.00 13.51           C  
ATOM    201  C   GLU A  28      23.234  13.835  28.791  1.00 12.28           C  
ATOM    202  O   GLU A  28      24.203  13.610  29.519  1.00 13.39           O  
ATOM    203  CB  GLU A  28      21.575  15.681  29.237  1.00 13.99           C  
ATOM    204  CG  GLU A  28      21.785  15.692  30.751  1.00 17.23           C  
ATOM    205  CD  GLU A  28      20.667  16.387  31.509  1.00 17.84           C  
ATOM    206  OE1 GLU A  28      20.465  17.603  31.302  0.30 20.06           O  
ATOM    207  OE2 GLU A  28      19.999  15.726  32.334  0.30 19.53           O  
ATOM    208  N   VAL A  29      22.497  12.861  28.280  1.00 11.04           N  
ATOM    209  CA  VAL A  29      22.779  11.453  28.580  1.00 11.72           C  
ATOM    210  C   VAL A  29      24.111  10.997  28.010  1.00 11.94           C  
ATOM    211  O   VAL A  29      24.889  10.336  28.706  1.00 12.42           O  
ATOM    212  CB  VAL A  29      21.631  10.553  28.082  1.00 11.67           C  
ATOM    213  CG1 VAL A  29      22.015   9.089  28.129  1.00 13.58           C  
ATOM    214  CG2 VAL A  29      20.376  10.795  28.915  1.00 12.83           C  
ATOM    215  N   PHE A  30      24.374  11.363  26.760  1.00 11.19           N  
ATOM    216  CA  PHE A  30      25.514  10.825  26.014  1.00 11.67           C  
ATOM    217  C   PHE A  30      26.726  11.732  25.907  1.00 12.70           C  
ATOM    218  O   PHE A  30      27.737  11.329  25.319  1.00 14.03           O  
ATOM    219  CB  PHE A  30      25.056  10.378  24.620  1.00 11.47           C  
ATOM    220  CG  PHE A  30      24.097   9.226  24.656  1.00 10.97           C  
ATOM    221  CD1 PHE A  30      24.525   7.956  25.038  1.00 11.87           C  
ATOM    222  CD2 PHE A  30      22.769   9.412  24.340  1.00 12.43           C  
ATOM    223  CE1 PHE A  30      23.642   6.893  25.086  1.00 12.98           C  
ATOM    224  CE2 PHE A  30      21.876   8.345  24.372  1.00 14.46           C  
ATOM    225  CZ  PHE A  30      22.314   7.082  24.755  1.00 13.17           C  
ATOM    226  N   GLU A  31      26.646  12.934  26.486  1.00 12.86           N  
ATOM    227  CA  GLU A  31      27.772  13.875  26.449  0.50 13.86           C  
ATOM    229  C   GLU A  31      28.133  14.289  25.025  1.00 13.68           C  
ATOM    230  O   GLU A  31      29.318  14.350  24.664  1.00 15.05           O  
ATOM    231  CB  GLU A  31      29.001  13.286  27.162  0.50 14.43           C  
ATOM    233  CG  GLU A  31      29.055  13.609  28.631  0.50 17.80           C  
ATOM    235  CD  GLU A  31      29.349  15.084  28.870  0.50 16.81           C  
ATOM    237  OE1 GLU A  31      28.398  15.858  29.102  0.50 19.63           O  
ATOM    239  OE2 GLU A  31      30.531  15.473  28.820  0.50 20.50           O  
ATOM    241  N   THR A  32      27.125  14.564  24.225  1.00 12.45           N  
ATOM    242  CA  THR A  32      27.317  14.918  22.831  1.00 11.69           C  
ATOM    243  C   THR A  32      26.920  16.370  22.597  1.00 10.82           C  
ATOM    244  O   THR A  32      26.409  17.049  23.505  1.00 11.24           O  
ATOM    245  CB  THR A  32      26.505  13.966  21.919  1.00 11.34           C  
ATOM    246  OG1 THR A  32      25.140  13.953  22.352  1.00 11.05           O  
ATOM    247  CG2 THR A  32      27.064  12.538  21.981  1.00 13.49           C  
ATOM    248  N   ASP A  33      27.124  16.811  21.359  0.50 10.33           N  
ATOM    250  CA  ASP A  33      26.997  18.217  20.977  0.50 10.38           C  
ATOM    252  C   ASP A  33      26.104  18.400  19.757  0.50  9.34           C  
ATOM    254  O   ASP A  33      26.354  19.277  18.918  0.50 10.25           O  
ATOM    256  CB  ASP A  33      28.379  18.818  20.709  0.50 10.97           C  
ATOM    258  CG  ASP A  33      29.214  18.908  21.955  0.50 13.98           C  
ATOM    260  OD1 ASP A  33      28.815  19.613  22.906  0.50 15.87           O  
ATOM    262  OD2 ASP A  33      30.286  18.281  21.968  0.50 17.82           O  
ATOM    264  N   LEU A  34      25.050  17.599  19.657  1.00  9.35           N  
ATOM    265  CA  LEU A  34      24.111  17.773  18.558  1.00  8.84           C  
ATOM    266  C   LEU A  34      23.288  19.030  18.728  1.00  8.78           C  
ATOM    267  O   LEU A  34      22.848  19.344  19.839  1.00 10.07           O  
ATOM    268  CB  LEU A  34      23.175  16.560  18.465  1.00  9.53           C  
ATOM    269  CG  LEU A  34      23.829  15.185  18.370  1.00  9.57           C  
ATOM    270  CD1 LEU A  34      22.752  14.109  18.141  1.00 11.74           C  
ATOM    271  CD2 LEU A  34      24.885  15.132  17.262  1.00 11.61           C  
ATOM    272  N   HIS A  35      23.061  19.747  17.635  1.00  9.13           N  
ATOM    273  CA  HIS A  35      22.201  20.927  17.662  1.00 10.72           C  
ATOM    274  C   HIS A  35      21.509  21.046  16.327  1.00 11.09           C  
ATOM    275  O   HIS A  35      22.140  20.805  15.291  1.00 11.50           O  
ATOM    276  CB  HIS A  35      23.003  22.213  17.865  1.00 11.80           C  
ATOM    277  CG  HIS A  35      23.766  22.281  19.152  1.00 12.77           C  
ATOM    278  ND1 HIS A  35      23.157  22.448  20.381  1.00 17.16           N  
ATOM    279  CD2 HIS A  35      25.095  22.224  19.397  1.00 12.20           C  
ATOM    280  CE1 HIS A  35      24.081  22.486  21.325  1.00 16.86           C  
ATOM    281  NE2 HIS A  35      25.269  22.385  20.754  1.00 16.77           N  
HETATM  282  N   MSE A  36      20.247  21.459  16.348  1.00 11.42           N  
HETATM  283  CA  MSE A  36      19.477  21.705  15.136  1.00 12.10           C  
HETATM  284  C   MSE A  36      18.324  22.652  15.475  1.00 13.52           C  
HETATM  285  O   MSE A  36      17.508  22.353  16.350  1.00 14.03           O  
HETATM  286  CB  MSE A  36      18.939  20.390  14.556  1.00 11.84           C  
HETATM  287  CG  MSE A  36      18.157  20.554  13.257  1.00 11.39           C  
HETATM  288 SE   MSE A  36      17.636  18.821  12.550  0.70 12.88          SE  
HETATM  289  CE  MSE A  36      19.392  18.188  11.930  1.00 12.35           C  
ATOM    290  N   SER A  37      18.232  23.784  14.780  1.00 15.26           N  
ATOM    291  CA  SER A  37      17.158  24.734  15.063  0.50 16.55           C  
ATOM    293  C   SER A  37      15.804  24.231  14.589  1.00 17.00           C  
ATOM    294  O   SER A  37      15.698  23.539  13.578  1.00 17.17           O  
ATOM    295  CB  SER A  37      17.465  26.102  14.461  0.50 16.90           C  
ATOM    297  OG  SER A  37      18.574  26.672  15.122  0.50 17.39           O  
ATOM    299  N   ASP A  38      14.768  24.588  15.352  1.00 17.73           N  
ATOM    300  CA  ASP A  38      13.373  24.306  15.006  1.00 19.25           C  
ATOM    301  C   ASP A  38      13.010  22.822  14.970  1.00 18.25           C  
ATOM    302  O   ASP A  38      11.975  22.449  14.413  1.00 19.07           O  
ATOM    303  CB  ASP A  38      13.004  24.974  13.671  1.00 20.61           C  
ATOM    304  CG  ASP A  38      13.070  26.499  13.720  1.00 23.16           C  
ATOM    305  OD1 ASP A  38      12.960  27.095  14.815  0.70 24.21           O  
ATOM    306  OD2 ASP A  38      13.239  27.102  12.640  0.70 26.44           O  
ATOM    307  N   VAL A  39      13.866  21.987  15.558  1.00 16.40           N  
ATOM    308  CA  VAL A  39      13.646  20.547  15.642  1.00 14.75           C  
ATOM    309  C   VAL A  39      14.010  20.174  17.061  1.00 13.64           C  
ATOM    310  O   VAL A  39      15.061  20.580  17.559  1.00 14.45           O  
ATOM    311  CB  VAL A  39      14.544  19.787  14.648  1.00 14.96           C  
ATOM    312  CG1 VAL A  39      14.384  18.302  14.821  1.00 15.11           C  
ATOM    313  CG2 VAL A  39      14.218  20.204  13.202  1.00 16.21           C  
ATOM    314  N   ASP A  40      13.148  19.406  17.719  1.00 12.13           N  
ATOM    315  CA  ASP A  40      13.364  19.110  19.126  1.00 12.17           C  
ATOM    316  C   ASP A  40      13.679  17.653  19.454  1.00 10.15           C  
ATOM    317  O   ASP A  40      14.279  17.408  20.485  1.00 10.21           O  
ATOM    318  CB  ASP A  40      12.170  19.603  19.953  1.00 13.49           C  
ATOM    319  CG  ASP A  40      12.039  21.113  19.922  1.00 16.36           C  
ATOM    320  OD1 ASP A  40      13.059  21.812  20.137  0.70 17.05           O  
ATOM    321  OD2 ASP A  40      10.918  21.590  19.691  0.70 16.80           O  
ATOM    322  N   THR A  41      13.282  16.722  18.587  1.00 10.03           N  
ATOM    323  CA  THR A  41      13.432  15.300  18.898  1.00  9.49           C  
ATOM    324  C   THR A  41      14.474  14.627  18.020  1.00  8.91           C  
ATOM    325  O   THR A  41      14.829  15.133  16.950  1.00  8.97           O  
ATOM    326  CB  THR A  41      12.106  14.531  18.741  1.00 10.61           C  
ATOM    327  OG1 THR A  41      11.767  14.468  17.353  1.00 11.01           O  
ATOM    328  CG2 THR A  41      10.972  15.204  19.516  1.00 12.31           C  
HETATM  329  N   MSE A  42      14.934  13.468  18.480  1.00  8.01           N  
HETATM  330  CA  MSE A  42      15.897  12.677  17.718  1.00  8.55           C  
HETATM  331  C   MSE A  42      15.319  12.133  16.428  1.00  8.86           C  
HETATM  332  O   MSE A  42      16.034  12.049  15.436  1.00  8.48           O  
HETATM  333  CB  MSE A  42      16.502  11.559  18.568  1.00  8.58           C  
HETATM  334  CG  MSE A  42      17.405  12.102  19.691  1.00  9.13           C  
HETATM  335 SE   MSE A  42      18.924  13.144  19.029  0.70 10.01          SE  
HETATM  336  CE  MSE A  42      19.861  11.728  18.067  1.00 10.80           C  
ATOM    337  N   ALA A  43      14.029  11.814  16.413  1.00  8.83           N  
ATOM    338  CA  ALA A  43      13.373  11.439  15.150  1.00  9.48           C  
ATOM    339  C   ALA A  43      13.442  12.580  14.130  1.00  9.58           C  
ATOM    340  O   ALA A  43      13.788  12.380  12.961  1.00  9.95           O  
ATOM    341  CB  ALA A  43      11.917  11.046  15.372  1.00  9.78           C  
ATOM    342  N   GLY A  44      13.090  13.786  14.568  1.00  9.30           N  
ATOM    343  CA  GLY A  44      13.129  14.951  13.695  1.00  9.54           C  
ATOM    344  C   GLY A  44      14.550  15.221  13.250  1.00  9.10           C  
ATOM    345  O   GLY A  44      14.792  15.571  12.095  1.00  9.21           O  
ATOM    346  N   TYR A  45      15.508  15.064  14.162  1.00  8.73           N  
ATOM    347  CA  TYR A  45      16.912  15.290  13.849  1.00  8.46           C  
ATOM    348  C   TYR A  45      17.363  14.385  12.699  1.00  8.57           C  
ATOM    349  O   TYR A  45      17.913  14.855  11.695  1.00  8.37           O  
ATOM    350  CB  TYR A  45      17.758  15.042  15.103  1.00  8.43           C  
ATOM    351  CG  TYR A  45      19.232  15.308  14.887  1.00  8.16           C  
ATOM    352  CD1 TYR A  45      19.781  16.563  15.170  1.00  8.91           C  
ATOM    353  CD2 TYR A  45      20.066  14.318  14.374  1.00  7.94           C  
ATOM    354  CE1 TYR A  45      21.133  16.804  14.941  1.00  8.69           C  
ATOM    355  CE2 TYR A  45      21.409  14.560  14.129  1.00  8.21           C  
ATOM    356  CZ  TYR A  45      21.940  15.794  14.421  1.00  8.18           C  
ATOM    357  OH  TYR A  45      23.278  15.976  14.185  1.00  8.62           O  
ATOM    358  N   LEU A  46      17.151  13.088  12.844  1.00  8.14           N  
ATOM    359  CA  LEU A  46      17.678  12.162  11.854  1.00  8.48           C  
ATOM    360  C   LEU A  46      16.956  12.288  10.518  1.00  8.70           C  
ATOM    361  O   LEU A  46      17.596  12.261   9.473  1.00  8.55           O  
ATOM    362  CB  LEU A  46      17.693  10.724  12.373  1.00  8.75           C  
ATOM    363  CG  LEU A  46      18.282   9.690  11.401  1.00  9.31           C  
ATOM    364  CD1 LEU A  46      19.715  10.050  10.952  1.00  9.43           C  
ATOM    365  CD2 LEU A  46      18.289   8.296  12.008  1.00  9.41           C  
ATOM    366  N   ILE A  47      15.634  12.420  10.554  0.50  8.57           N  
ATOM    368  CA  ILE A  47      14.873  12.602   9.323  0.50  9.87           C  
ATOM    370  C   ILE A  47      15.375  13.831   8.557  0.50  9.76           C  
ATOM    372  O   ILE A  47      15.640  13.758   7.356  0.50 10.58           O  
ATOM    374  CB  ILE A  47      13.347  12.682   9.606  0.50  9.96           C  
ATOM    376  CG1 ILE A  47      12.786  11.306  10.019  0.50  9.85           C  
ATOM    378  CG2 ILE A  47      12.584  13.291   8.403  0.50 10.11           C  
ATOM    380  CD1 ILE A  47      13.011  10.159   9.019  0.50 10.56           C  
ATOM    382  N   THR A  48      15.547  14.944   9.270  1.00  9.96           N  
ATOM    383  CA  THR A  48      16.017  16.185   8.658  1.00 11.27           C  
ATOM    384  C   THR A  48      17.416  15.983   8.082  1.00 11.01           C  
ATOM    385  O   THR A  48      17.681  16.382   6.955  1.00 11.87           O  
ATOM    386  CB  THR A  48      16.042  17.328   9.670  1.00 11.92           C  
ATOM    387  OG1 THR A  48      14.717  17.524  10.183  1.00 13.21           O  
ATOM    388  CG2 THR A  48      16.521  18.632   9.003  1.00 13.92           C  
ATOM    389  N   ALA A  49      18.309  15.357   8.845  1.00  9.60           N  
ATOM    390  CA  ALA A  49      19.685  15.168   8.400  1.00 10.58           C  
ATOM    391  C   ALA A  49      19.766  14.258   7.177  1.00 10.75           C  
ATOM    392  O   ALA A  49      20.566  14.509   6.270  1.00 11.42           O  
ATOM    393  CB  ALA A  49      20.527  14.625   9.520  1.00 10.46           C  
ATOM    394  N   LEU A  50      18.956  13.203   7.143  1.00 10.39           N  
ATOM    395  CA  LEU A  50      18.929  12.284   5.995  1.00 11.85           C  
ATOM    396  C   LEU A  50      18.391  12.970   4.749  1.00 12.94           C  
ATOM    397  O   LEU A  50      18.843  12.693   3.633  1.00 14.39           O  
ATOM    398  CB  LEU A  50      18.073  11.053   6.295  1.00 11.59           C  
ATOM    399  CG  LEU A  50      18.631  10.068   7.318  1.00 11.70           C  
ATOM    400  CD1 LEU A  50      17.540   9.060   7.648  1.00 12.82           C  
ATOM    401  CD2 LEU A  50      19.904   9.382   6.822  1.00 13.09           C  
ATOM    402  N   GLY A  51      17.406  13.838   4.945  1.00 13.42           N  
ATOM    403  CA  GLY A  51      16.783  14.586   3.858  1.00 15.03           C  
ATOM    404  C   GLY A  51      15.660  13.853   3.145  1.00 15.45           C  
ATOM    405  O   GLY A  51      15.002  14.427   2.277  1.00 16.67           O  
ATOM    406  N   THR A  52      15.446  12.588   3.510  1.00 15.81           N  
ATOM    407  CA  THR A  52      14.421  11.744   2.889  1.00 16.65           C  
ATOM    408  C   THR A  52      13.918  10.783   3.955  1.00 16.32           C  
ATOM    409  O   THR A  52      14.694  10.315   4.780  1.00 16.93           O  
ATOM    410  CB  THR A  52      14.991  10.923   1.710  1.00 17.26           C  
ATOM    411  OG1 THR A  52      15.427  11.805   0.672  1.00 19.18           O  
ATOM    412  CG2 THR A  52      13.933   9.992   1.114  1.00 18.90           C  
ATOM    413  N   ILE A  53      12.618  10.492   3.935  1.00 15.38           N  
ATOM    414  CA  ILE A  53      12.023   9.540   4.883  1.00 15.55           C  
ATOM    415  C   ILE A  53      12.271   8.120   4.365  1.00 14.89           C  
ATOM    416  O   ILE A  53      11.899   7.798   3.242  1.00 15.65           O  
ATOM    417  CB  ILE A  53      10.508   9.810   5.088  1.00 16.04           C  
ATOM    418  CG1 ILE A  53      10.277  11.237   5.608  1.00 17.52           C  
ATOM    419  CG2 ILE A  53       9.910   8.806   6.058  1.00 16.73           C  
ATOM    420  CD1 ILE A  53       8.815  11.633   5.748  1.00 18.35           C  
ATOM    421  N   PRO A  54      12.941   7.277   5.167  1.00 14.24           N  
ATOM    422  CA  PRO A  54      13.189   5.897   4.760  1.00 13.81           C  
ATOM    423  C   PRO A  54      11.886   5.084   4.642  1.00 13.31           C  
ATOM    424  O   PRO A  54      10.959   5.318   5.427  1.00 13.16           O  
ATOM    425  CB  PRO A  54      14.034   5.345   5.926  1.00 13.91           C  
ATOM    426  CG  PRO A  54      14.598   6.561   6.623  1.00 15.76           C  
ATOM    427  CD  PRO A  54      13.553   7.602   6.473  1.00 14.46           C  
ATOM    428  N   ASP A  55      11.857   4.138   3.696  1.00 13.46           N  
ATOM    429  CA  ASP A  55      10.822   3.074   3.576  1.00 13.90           C  
ATOM    430  C   ASP A  55      10.884   2.202   4.836  1.00 13.69           C  
ATOM    431  O   ASP A  55      11.960   2.075   5.457  1.00 12.41           O  
ATOM    432  CB  ASP A  55      11.147   2.242   2.295  1.00 15.12           C  
ATOM    433  CG  ASP A  55      10.067   1.207   1.873  1.00 15.49           C  
ATOM    434  OD1 ASP A  55       8.956   1.143   2.444  0.60 14.18           O  
ATOM    435  OD2 ASP A  55      10.365   0.443   0.904  0.60 13.56           O  
ATOM    436  N   GLU A  56       9.758   1.628   5.253  1.00 13.63           N  
ATOM    437  CA  GLU A  56       9.812   0.633   6.319  1.00 12.23           C  
ATOM    438  C   GLU A  56      10.780  -0.459   5.885  1.00 12.30           C  
ATOM    439  O   GLU A  56      10.723  -0.932   4.736  1.00 13.54           O  
ATOM    440  CB  GLU A  56       8.442   0.042   6.590  1.00 11.60           C  
ATOM    441  CG  GLU A  56       7.500   1.000   7.276  1.00 14.38           C  
ATOM    442  CD  GLU A  56       6.092   0.419   7.434  1.00 14.98           C  
ATOM    443  OE1 GLU A  56       5.746  -0.444   6.616  0.90 15.47           O  
ATOM    444  OE2 GLU A  56       5.384   0.840   8.359  0.90 12.89           O  
ATOM    445  N   GLY A  57      11.692  -0.819   6.782  1.00 12.73           N  
ATOM    446  CA  GLY A  57      12.690  -1.837   6.515  1.00 13.40           C  
ATOM    447  C   GLY A  57      13.992  -1.295   5.950  1.00 13.16           C  
ATOM    448  O   GLY A  57      14.972  -2.025   5.882  1.00 15.06           O  
ATOM    449  N   GLU A  58      13.997  -0.026   5.542  1.00 12.29           N  
ATOM    450  CA  GLU A  58      15.216   0.603   5.018  1.00 12.35           C  
ATOM    451  C   GLU A  58      15.926   1.317   6.153  1.00 11.57           C  
ATOM    452  O   GLU A  58      15.284   2.060   6.920  1.00 12.40           O  
ATOM    453  CB  GLU A  58      14.827   1.632   3.984  1.00 14.08           C  
ATOM    454  CG  GLU A  58      15.922   2.050   3.068  1.00 15.63           C  
ATOM    455  CD  GLU A  58      15.373   2.841   1.898  1.00 17.56           C  
ATOM    456  OE1 GLU A  58      14.224   3.381   1.998  0.80 14.12           O  
ATOM    457  OE2 GLU A  58      16.094   2.911   0.870  0.80 18.06           O  
ATOM    458  N   LYS A  59      17.240   1.123   6.246  1.00 10.96           N  
ATOM    459  CA  LYS A  59      17.996   1.565   7.425  1.00 10.29           C  
ATOM    460  C   LYS A  59      19.202   2.437   7.057  1.00 10.45           C  
ATOM    461  O   LYS A  59      20.359   2.066   7.294  1.00 10.78           O  
ATOM    462  CB  LYS A  59      18.409   0.350   8.258  1.00 11.06           C  
ATOM    463  CG  LYS A  59      17.234  -0.502   8.715  1.00 11.88           C  
ATOM    464  CD  LYS A  59      17.689  -1.581   9.660  1.00 13.78           C  
ATOM    465  CE  LYS A  59      16.512  -2.431  10.123  1.00 15.68           C  
ATOM    466  NZ  LYS A  59      17.004  -3.576  10.946  1.00 17.24           N  
ATOM    467  N   PRO A  60      18.941   3.627   6.499  1.00 10.01           N  
ATOM    468  CA  PRO A  60      20.039   4.526   6.184  1.00 10.12           C  
ATOM    469  C   PRO A  60      20.634   5.121   7.451  1.00  9.23           C  
ATOM    470  O   PRO A  60      19.998   5.120   8.512  1.00  9.23           O  
ATOM    471  CB  PRO A  60      19.364   5.609   5.356  1.00 11.10           C  
ATOM    472  CG  PRO A  60      17.980   5.661   5.894  1.00 11.47           C  
ATOM    473  CD  PRO A  60      17.633   4.210   6.147  1.00 10.53           C  
ATOM    474  N   SER A  61      21.834   5.670   7.307  1.00  9.38           N  
ATOM    475  CA  SER A  61      22.520   6.268   8.434  0.50  9.66           C  
ATOM    477  C   SER A  61      23.041   7.659   8.117  1.00  9.12           C  
ATOM    478  O   SER A  61      23.197   8.060   6.951  1.00  9.53           O  
ATOM    479  CB  SER A  61      23.671   5.381   8.885  0.50 11.67           C  
ATOM    481  OG  SER A  61      24.624   5.255   7.852  0.50 12.96           O  
ATOM    483  N   PHE A  62      23.286   8.410   9.182  1.00  8.74           N  
ATOM    484  CA  PHE A  62      23.878   9.737   9.131  1.00  8.86           C  
ATOM    485  C   PHE A  62      24.994   9.754  10.162  1.00  8.87           C  
ATOM    486  O   PHE A  62      24.785   9.392  11.326  1.00  9.25           O  
ATOM    487  CB  PHE A  62      22.836  10.800   9.470  1.00  8.96           C  
ATOM    488  CG  PHE A  62      23.388  12.190   9.482  1.00  8.82           C  
ATOM    489  CD1 PHE A  62      23.756  12.824   8.291  1.00  9.09           C  
ATOM    490  CD2 PHE A  62      23.537  12.876  10.676  1.00  9.66           C  
ATOM    491  CE1 PHE A  62      24.274  14.119   8.291  1.00 10.16           C  
ATOM    492  CE2 PHE A  62      24.042  14.167  10.693  1.00  9.65           C  
ATOM    493  CZ  PHE A  62      24.412  14.786   9.496  1.00  9.98           C  
ATOM    494  N   GLU A  63      26.170  10.185   9.730  1.00  8.99           N  
ATOM    495  CA  GLU A  63      27.308  10.280  10.632  0.50  9.49           C  
ATOM    497  C   GLU A  63      27.573  11.741  10.961  1.00  9.35           C  
ATOM    498  O   GLU A  63      27.449  12.615  10.096  1.00 10.01           O  
ATOM    499  CB  GLU A  63      28.529   9.608  10.007  0.50 11.25           C  
ATOM    501  CG  GLU A  63      28.215   8.169   9.571  0.50 14.08           C  
ATOM    503  CD  GLU A  63      29.427   7.376   9.131  0.50 12.27           C  
ATOM    505  OE1 GLU A  63      30.459   7.403   9.842  0.50 20.58           O  
ATOM    507  OE2 GLU A  63      29.334   6.709   8.075  0.50 19.37           O  
ATOM    509  N   VAL A  64      27.930  12.006  12.215  1.00  9.22           N  
ATOM    510  CA  VAL A  64      28.227  13.354  12.670  1.00 10.32           C  
ATOM    511  C   VAL A  64      29.203  13.213  13.836  1.00 10.67           C  
ATOM    512  O   VAL A  64      28.924  12.505  14.795  1.00 10.46           O  
ATOM    513  CB  VAL A  64      26.922  14.144  13.015  1.00 10.51           C  
ATOM    514  CG1 VAL A  64      26.028  13.408  14.017  1.00 12.55           C  
ATOM    515  CG2 VAL A  64      27.264  15.537  13.508  1.00 13.12           C  
ATOM    516  N   GLY A  65      30.370  13.847  13.740  1.00 13.24           N  
ATOM    517  CA  GLY A  65      31.382  13.697  14.781  1.00 15.57           C  
ATOM    518  C   GLY A  65      31.739  12.237  14.950  1.00 15.78           C  
ATOM    519  O   GLY A  65      31.998  11.534  13.984  1.00 17.34           O  
ATOM    520  N   ASN A  66      31.766  11.716  16.170  0.50 15.54           N  
ATOM    522  CA  ASN A  66      32.091  10.289  16.318  0.50 14.65           C  
ATOM    524  C   ASN A  66      30.858   9.396  16.436  0.50 13.53           C  
ATOM    526  O   ASN A  66      30.949   8.247  16.868  0.50 13.47           O  
ATOM    528  CB  ASN A  66      33.032  10.052  17.504  0.50 15.29           C  
ATOM    530  CG  ASN A  66      32.362  10.320  18.841  0.50 16.26           C  
ATOM    532  OD1 ASN A  66      31.570  11.247  18.972  0.50 16.26           O  
ATOM    534  ND2 ASN A  66      32.675   9.500  19.841  0.50 17.76           N  
ATOM    536  N   ILE A  67      29.706   9.934  16.048  1.00 11.93           N  
ATOM    537  CA  ILE A  67      28.422   9.241  16.156  0.50 11.04           C  
ATOM    539  C   ILE A  67      27.931   8.773  14.780  1.00 10.37           C  
ATOM    540  O   ILE A  67      28.074   9.514  13.796  1.00 10.62           O  
ATOM    541  CB  ILE A  67      27.355  10.202  16.757  0.50 11.25           C  
ATOM    543  CG1 ILE A  67      27.935  10.983  17.947  0.50 11.80           C  
ATOM    545  CG2 ILE A  67      26.074   9.449  17.125  0.50 12.72           C  
ATOM    547  CD1 ILE A  67      27.089  12.167  18.377  0.50 12.83           C  
ATOM    549  N   LYS A  68      27.320   7.597  14.742  1.00  9.24           N  
ATOM    550  CA  LYS A  68      26.557   7.184  13.585  1.00  8.82           C  
ATOM    551  C   LYS A  68      25.131   6.911  14.047  1.00  8.10           C  
ATOM    552  O   LYS A  68      24.910   6.136  14.989  1.00  9.27           O  
ATOM    553  CB  LYS A  68      27.159   5.949  12.926  1.00 10.32           C  
ATOM    554  CG  LYS A  68      26.370   5.528  11.693  1.00 13.09           C  
ATOM    555  CD  LYS A  68      27.085   4.501  10.845  1.00 18.44           C  
ATOM    556  CE  LYS A  68      26.726   3.125  11.276  1.00 22.48           C  
ATOM    557  NZ  LYS A  68      27.437   2.777  12.508  1.00 25.94           N  
ATOM    558  N   LEU A  69      24.171   7.556  13.382  1.00  7.38           N  
ATOM    559  CA  LEU A  69      22.743   7.406  13.688  1.00  7.79           C  
ATOM    560  C   LEU A  69      22.090   6.642  12.545  1.00  8.08           C  
ATOM    561  O   LEU A  69      22.229   7.044  11.392  1.00  9.61           O  
ATOM    562  CB  LEU A  69      22.096   8.779  13.798  1.00  8.50           C  
ATOM    563  CG  LEU A  69      22.616   9.694  14.901  1.00  8.94           C  
ATOM    564  CD1 LEU A  69      21.971  11.071  14.738  1.00 12.01           C  
ATOM    565  CD2 LEU A  69      22.325   9.125  16.272  1.00 11.15           C  
ATOM    566  N   THR A  70      21.382   5.575  12.866  1.00  8.01           N  
ATOM    567  CA  THR A  70      20.738   4.756  11.845  1.00  8.14           C  
ATOM    568  C   THR A  70      19.251   4.722  12.109  1.00  8.01           C  
ATOM    569  O   THR A  70      18.813   4.635  13.253  1.00  8.54           O  
ATOM    570  CB  THR A  70      21.304   3.317  11.860  1.00  9.31           C  
ATOM    571  OG1 THR A  70      22.715   3.374  11.625  1.00  9.93           O  
ATOM    572  CG2 THR A  70      20.641   2.444  10.804  1.00 11.73           C  
ATOM    573  N   ALA A  71      18.449   4.780  11.052  1.00  8.22           N  
ATOM    574  CA  ALA A  71      17.008   4.665  11.194  1.00  9.67           C  
ATOM    575  C   ALA A  71      16.691   3.188  11.360  1.00 10.23           C  
ATOM    576  O   ALA A  71      16.615   2.449  10.362  1.00 11.69           O  
ATOM    577  CB  ALA A  71      16.322   5.233   9.942  1.00 10.79           C  
ATOM    578  N   GLU A  72      16.479   2.753  12.598  1.00  9.49           N  
ATOM    579  CA  GLU A  72      16.347   1.334  12.887  1.00 10.90           C  
ATOM    580  C   GLU A  72      14.946   0.797  12.665  1.00 10.42           C  
ATOM    581  O   GLU A  72      14.784  -0.327  12.201  1.00 10.79           O  
ATOM    582  CB  GLU A  72      16.805   1.051  14.313  1.00 10.87           C  
ATOM    583  CG  GLU A  72      17.038  -0.415  14.563  1.00 15.01           C  
ATOM    584  CD  GLU A  72      18.112  -1.018  13.643  1.00 15.42           C  
ATOM    585  OE1 GLU A  72      19.062  -0.326  13.186  1.00 17.61           O  
ATOM    586  OE2 GLU A  72      18.006  -2.203  13.361  1.00 15.32           O  
ATOM    587  N   GLU A  73      13.938   1.588  13.032  1.00  9.70           N  
ATOM    588  CA  GLU A  73      12.547   1.157  12.916  1.00 10.01           C  
ATOM    589  C   GLU A  73      11.666   2.311  12.530  1.00  9.71           C  
ATOM    590  O   GLU A  73      11.579   3.308  13.263  1.00  9.71           O  
ATOM    591  CB  GLU A  73      12.040   0.546  14.228  1.00 11.15           C  
ATOM    592  CG  GLU A  73      10.665  -0.068  14.072  1.00 14.15           C  
ATOM    593  CD  GLU A  73      10.132  -0.738  15.322  1.00 15.85           C  
ATOM    594  OE1 GLU A  73      10.777  -0.659  16.390  1.00 17.49           O  
ATOM    595  OE2 GLU A  73       9.040  -1.349  15.229  1.00 18.65           O  
HETATM  596  N   MSE A  74      10.978   2.133  11.402  1.00 10.01           N  
HETATM  597  CA  MSE A  74       9.939   3.058  10.927  1.00 10.44           C  
HETATM  598  C   MSE A  74       8.573   2.475  11.216  1.00 11.12           C  
HETATM  599  O   MSE A  74       8.378   1.257  11.122  1.00 11.75           O  
HETATM  600  CB  MSE A  74      10.024   3.255   9.412  1.00 10.91           C  
HETATM  601  CG  MSE A  74      11.364   3.743   8.910  1.00 11.18           C  
HETATM  602 SE   MSE A  74      11.846   5.493   9.581  0.65 11.41          SE  
HETATM  603  CE  MSE A  74      10.347   6.508   8.822  1.00 12.30           C  
ATOM    604  N   GLU A  75       7.637   3.343  11.573  1.00 11.39           N  
ATOM    605  CA  GLU A  75       6.224   2.967  11.631  0.50 11.65           C  
ATOM    607  C   GLU A  75       5.518   3.912  10.679  1.00 11.57           C  
ATOM    608  O   GLU A  75       5.252   5.065  11.021  1.00 11.25           O  
ATOM    609  CB  GLU A  75       5.671   3.057  13.064  0.50 11.90           C  
ATOM    611  CG  GLU A  75       4.183   2.666  13.200  0.50 12.42           C  
ATOM    613  CD  GLU A  75       3.736   2.488  14.641  0.50 14.63           C  
ATOM    615  OE1 GLU A  75       4.314   1.623  15.334  0.50 13.29           O  
ATOM    617  OE2 GLU A  75       2.807   3.209  15.075  0.50 12.57           O  
ATOM    619  N   GLY A  76       5.249   3.425   9.475  1.00 11.55           N  
ATOM    620  CA  GLY A  76       4.848   4.325   8.390  1.00 11.78           C  
ATOM    621  C   GLY A  76       5.970   5.331   8.204  1.00 12.15           C  
ATOM    622  O   GLY A  76       7.156   4.956   8.171  1.00 12.75           O  
ATOM    623  N   THR A  77       5.623   6.608   8.161  1.00 11.95           N  
ATOM    624  CA  THR A  77       6.640   7.628   7.985  1.00 13.58           C  
ATOM    625  C   THR A  77       7.214   8.153   9.297  1.00 12.77           C  
ATOM    626  O   THR A  77       8.061   9.050   9.273  1.00 13.45           O  
ATOM    627  CB  THR A  77       6.127   8.793   7.148  1.00 15.03           C  
ATOM    628  OG1 THR A  77       4.992   9.374   7.785  1.00 16.34           O  
ATOM    629  CG2 THR A  77       5.745   8.334   5.751  1.00 16.19           C  
ATOM    630  N   ARG A  78       6.775   7.596  10.427  1.00 11.79           N  
ATOM    631  CA  ARG A  78       7.347   7.962  11.709  1.00 11.85           C  
ATOM    632  C   ARG A  78       8.614   7.167  12.008  1.00 10.93           C  
ATOM    633  O   ARG A  78       8.626   5.932  11.917  1.00 10.88           O  
ATOM    634  CB  ARG A  78       6.337   7.704  12.814  1.00 12.29           C  
ATOM    635  CG  ARG A  78       6.895   7.917  14.198  1.00 12.84           C  
ATOM    636  CD  ARG A  78       5.848   7.597  15.235  1.00 15.07           C  
ATOM    637  NE  ARG A  78       6.310   7.862  16.591  1.00 15.74           N  
ATOM    638  CZ  ARG A  78       5.527   7.750  17.657  1.00 16.37           C  
ATOM    639  NH1 ARG A  78       4.255   7.398  17.512  1.00 17.97           N  
ATOM    640  NH2 ARG A  78       6.008   8.000  18.859  1.00 17.89           N  
ATOM    641  N   LEU A  79       9.679   7.878  12.368  1.00 10.50           N  
ATOM    642  CA  LEU A  79      10.896   7.230  12.826  1.00 10.54           C  
ATOM    643  C   LEU A  79      10.744   6.882  14.296  1.00 10.10           C  
ATOM    644  O   LEU A  79      10.788   7.757  15.164  1.00 10.71           O  
ATOM    645  CB  LEU A  79      12.103   8.128  12.566  1.00 10.61           C  
ATOM    646  CG  LEU A  79      13.435   7.708  13.195  1.00 10.30           C  
ATOM    647  CD1 LEU A  79      13.800   6.264  12.838  1.00 10.48           C  
ATOM    648  CD2 LEU A  79      14.537   8.656  12.735  1.00 10.52           C  
ATOM    649  N   LEU A  80      10.524   5.617  14.567  1.00  9.88           N  
ATOM    650  CA  LEU A  80      10.232   5.114  15.909  0.50 10.42           C  
ATOM    652  C   LEU A  80      11.497   4.957  16.767  1.00  9.66           C  
ATOM    653  O   LEU A  80      11.478   5.296  17.916  1.00  9.49           O  
ATOM    654  CB  LEU A  80       9.513   3.761  15.854  0.50 11.71           C  
ATOM    656  CG  LEU A  80       8.007   3.608  15.676  0.50 12.93           C  
ATOM    658  CD1 LEU A  80       7.625   2.153  15.922  0.50 14.41           C  
ATOM    660  CD2 LEU A  80       7.220   4.511  16.610  0.50 13.68           C  
ATOM    662  N   VAL A  81      12.501   4.306  16.175  1.00  8.67           N  
ATOM    663  CA  VAL A  81      13.701   3.945  16.937  1.00  8.92           C  
ATOM    664  C   VAL A  81      14.927   4.211  16.089  1.00  8.38           C  
ATOM    665  O   VAL A  81      14.973   3.830  14.906  1.00  9.05           O  
ATOM    666  CB  VAL A  81      13.666   2.439  17.374  1.00  9.09           C  
ATOM    667  CG1 VAL A  81      14.876   2.105  18.223  1.00 10.52           C  
ATOM    668  CG2 VAL A  81      12.388   2.129  18.172  1.00 11.18           C  
ATOM    669  N   LEU A  82      15.919   4.843  16.715  1.00  7.90           N  
ATOM    670  CA  LEU A  82      17.234   5.056  16.104  1.00  8.11           C  
ATOM    671  C   LEU A  82      18.220   4.083  16.707  1.00  8.05           C  
ATOM    672  O   LEU A  82      18.138   3.785  17.889  1.00  9.33           O  
ATOM    673  CB  LEU A  82      17.744   6.482  16.417  1.00  8.53           C  
ATOM    674  CG  LEU A  82      17.067   7.674  15.749  1.00  8.35           C  
ATOM    675  CD1 LEU A  82      15.714   7.977  16.409  1.00  9.18           C  
ATOM    676  CD2 LEU A  82      17.955   8.900  15.850  1.00  9.04           C  
ATOM    677  N   ARG A  83      19.178   3.626  15.918  1.00  7.37           N  
ATOM    678  CA  ARG A  83      20.349   2.975  16.465  1.00  8.51           C  
ATOM    679  C   ARG A  83      21.478   3.991  16.484  1.00  8.00           C  
ATOM    680  O   ARG A  83      21.630   4.767  15.545  1.00  9.31           O  
ATOM    681  CB  ARG A  83      20.722   1.762  15.622  1.00  8.57           C  
ATOM    682  CG  ARG A  83      21.925   0.966  16.151  1.00  9.28           C  
ATOM    683  CD  ARG A  83      22.355  -0.113  15.152  1.00 10.68           C  
ATOM    684  NE  ARG A  83      21.309  -1.104  14.851  1.00 11.46           N  
ATOM    685  CZ  ARG A  83      21.297  -2.362  15.278  1.00 10.53           C  
ATOM    686  NH1 ARG A  83      22.230  -2.826  16.092  1.00 11.08           N  
ATOM    687  NH2 ARG A  83      20.325  -3.156  14.887  1.00 10.54           N  
ATOM    688  N   VAL A  84      22.235   4.012  17.573  1.00  7.66           N  
ATOM    689  CA  VAL A  84      23.348   4.928  17.705  1.00  8.91           C  
ATOM    690  C   VAL A  84      24.622   4.164  18.010  1.00  8.18           C  
ATOM    691  O   VAL A  84      24.646   3.358  18.946  1.00  9.11           O  
ATOM    692  CB  VAL A  84      23.075   5.906  18.851  1.00 10.91           C  
ATOM    693  CG1 VAL A  84      24.154   6.963  18.914  1.00 12.94           C  
ATOM    694  CG2 VAL A  84      21.660   6.507  18.743  1.00 13.39           C  
ATOM    695  N   HIS A  85      25.653   4.373  17.184  1.00  8.46           N  
ATOM    696  CA  HIS A  85      26.969   3.868  17.506  0.50  9.05           C  
ATOM    698  C   HIS A  85      27.928   5.009  17.777  1.00  8.89           C  
ATOM    699  O   HIS A  85      27.926   6.036  17.093  1.00  9.58           O  
ATOM    700  CB  HIS A  85      27.503   2.979  16.399  0.50 10.05           C  
ATOM    702  CG  HIS A  85      28.534   2.014  16.878  0.50 11.62           C  
ATOM    704  ND1 HIS A  85      29.846   2.367  17.106  0.50 13.99           N  
ATOM    706  CD2 HIS A  85      28.432   0.711  17.211  0.50 12.42           C  
ATOM    708  CE1 HIS A  85      30.512   1.318  17.543  0.50 13.52           C  
ATOM    710  NE2 HIS A  85      29.678   0.298  17.617  0.50 13.35           N  
ATOM    712  N   PHE A  86      28.745   4.834  18.808  1.00  9.58           N  
ATOM    713  CA  PHE A  86      29.786   5.790  19.168  1.00 10.87           C  
ATOM    714  C   PHE A  86      31.155   5.261  18.791  1.00 12.64           C  
ATOM    715  O   PHE A  86      31.471   4.110  19.052  1.00 13.01           O  
ATOM    716  CB  PHE A  86      29.755   6.079  20.674  1.00 11.30           C  
ATOM    717  CG  PHE A  86      28.513   6.774  21.117  1.00 11.71           C  
ATOM    718  CD1 PHE A  86      28.451   8.154  21.104  1.00 14.96           C  
ATOM    719  CD2 PHE A  86      27.398   6.071  21.539  1.00 12.48           C  
ATOM    720  CE1 PHE A  86      27.307   8.818  21.492  1.00 16.39           C  
ATOM    721  CE2 PHE A  86      26.243   6.732  21.931  1.00 12.85           C  
ATOM    722  CZ  PHE A  86      26.200   8.112  21.904  1.00 13.65           C  
ATOM    723  N   TYR A  87      31.951   6.106  18.148  1.00 15.60           N  
ATOM    724  CA  TYR A  87      33.318   5.759  17.758  1.00 19.20           C  
ATOM    725  C   TYR A  87      34.345   6.600  18.507  1.00 21.79           C  
ATOM    726  O   TYR A  87      34.001   7.568  19.186  1.00 23.00           O  
ATOM    727  CB  TYR A  87      33.493   5.906  16.250  1.00 20.45           C  
ATOM    728  CG  TYR A  87      32.510   5.077  15.481  1.00 22.05           C  
ATOM    729  CD1 TYR A  87      32.752   3.729  15.221  1.00 22.75           C  
ATOM    730  CD2 TYR A  87      31.310   5.633  15.041  1.00 22.98           C  
ATOM    731  CE1 TYR A  87      31.824   2.958  14.521  1.00 23.25           C  
ATOM    732  CE2 TYR A  87      30.387   4.882  14.348  1.00 23.76           C  
ATOM    733  CZ  TYR A  87      30.644   3.551  14.086  1.00 23.53           C  
ATOM    734  OH  TYR A  87      29.710   2.816  13.404  1.00 23.90           O  
ATOM    735  N   ASP A  88      35.610   6.210  18.389  1.00 24.40           N  
ATOM    736  CA  ASP A  88      36.719   6.968  18.957  1.00 26.80           C  
ATOM    737  C   ASP A  88      37.364   7.811  17.867  1.00 27.10           C  
ATOM    738  O   ASP A  88      37.533   7.347  16.737  1.00 29.16           O  
ATOM    739  CB  ASP A  88      37.754   6.012  19.542  1.00 27.29           C  
ATOM    740  CG  ASP A  88      37.160   5.070  20.556  1.00 23.21           C  
ATOM    741  OD1 ASP A  88      36.349   5.535  21.390  0.50 30.16           O  
ATOM    742  OD2 ASP A  88      37.512   3.869  20.523  0.50 32.13           O  
TER     743      ASP A  88                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
