
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  158 ( 1158),  selected  158 , name 2np5_D
# Molecule2: number of CA atoms  140 ( 1095),  selected  140 , name T0454_57_196.pdb
# PARAMETERS: 2np5_D.T0454_57_196.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    10_D      -       -           -
LGA    P    11_D      -       -           -
LGA    E    12_D      -       -           -
LGA    R    13_D      -       -           -
LGA    L    14_D      -       -           -
LGA    A    15_D      -       -           -
LGA    A    16_D      -       -           -
LGA    A    17_D      -       -           -
LGA    L    18_D      -       -           -
LGA    F    19_D      -       -           -
LGA    D    20_D      -       -           -
LGA    V    21_D      -       -           -
LGA    A    22_D      -       -           -
LGA    A    23_D      -       -           -
LGA    E    24_D      -       -           -
LGA    S    25_D      -       -           -
LGA    G    26_D      -       -           -
LGA    L    27_D      -       -           -
LGA    K    53_D      -       -           -
LGA    D    54_D      -       -           -
LGA    E    55_D      -       -           -
LGA    X    56_D      -       -           -
LGA    F    57_D      L      57          1.860
LGA    A    58_D      Q      58          2.102
LGA    F    59_D      E      59          4.053
LGA    A    60_D      Q      60          3.469
LGA    L    61_D      F      61          0.769
LGA    R    62_D      A      62          2.928
LGA    T    63_D      C      63          1.968
LGA    L    64_D      -       -           -
LGA    V    65_D      F      64          1.365
LGA    D    66_D      G      65          3.185
LGA    K    67_D      Q      66          3.743
LGA    L    68_D      -       -           -
LGA    L    69_D      L      67          2.187
LGA    A    70_D      D      68          1.216
LGA    R    71_D      D      69          2.024
LGA    L    72_D      I      70          1.954
LGA    S    73_D      R      71          1.415
LGA    E    74_D      G      72          2.398
LGA    V    75_D      Q      73          2.725
LGA    E    76_D      A      74          3.257
LGA    R    77_D      G      75           #
LGA    G    78_D      -       -           -
LGA    G    79_D      -       -           -
LGA    D    80_D      D      76          3.405
LGA    P    81_D      P      77          2.290
LGA    A    82_D      L      78          1.573
LGA    R    83_D      A      79          2.717
LGA    A    84_D      V      80          2.721
LGA    L    85_D      M      81          1.261
LGA    F    86_D      T      82          1.414
LGA    A    87_D      A      83          2.037
LGA    A    88_D      Y      84          1.751
LGA    X    89_D      L      85          1.742
LGA    S    90_D      R      86          2.366
LGA    Q    91_D      W      87          2.470
LGA    L    92_D      T      88          2.007
LGA    L    93_D      I      89          2.638
LGA    P    94_D      Q      90           #
LGA    L    95_D      -       -           -
LGA    D    96_D      -       -           -
LGA    E    97_D      -       -           -
LGA    A    98_D      R      91           #
LGA    R    99_D      X      92          3.712
LGA    S   100_D      R      93          2.613
LGA    R   101_D      N      94          4.852
LGA    E   102_D      N      95          1.760
LGA    A   103_D      -       -           -
LGA    H   104_D      P      96          2.929
LGA    V   105_D      Q      97          1.593
LGA    X   106_D      L      98          1.947
LGA    A   107_D      L      99          1.230
LGA    A   108_D      R     100          0.258
LGA    F   109_D      F     101          0.859
LGA    A   110_D      Y     102          2.464
LGA    V   111_D      T     103          3.072
LGA    R   112_D      S     104          2.103
LGA    A   113_D      E     105          1.252
LGA    -       -      L     106           -
LGA    A   114_D      T     107          2.253
LGA    T   115_D      N     108          2.517
LGA    S   116_D      P     109          3.481
LGA    P   117_D      T     110          2.126
LGA    S   118_D      P     111          2.380
LGA    L   119_D      C     112          3.999
LGA    A   120_D      F     113          3.026
LGA    E   121_D      A     114          2.473
LGA    -       -      A     115           -
LGA    I   122_D      I     116          2.635
LGA    R   123_D      V     117          2.260
LGA    R   124_D      S     118          1.946
LGA    K   125_D      P     119          1.742
LGA    T   126_D      A     120          1.690
LGA    L   127_D      I     121          1.452
LGA    F   128_D      A     122          0.809
LGA    T   129_D      S     123          0.833
LGA    I   130_D      V     124          0.445
LGA    R   131_D      I     125          0.431
LGA    T   132_D      R     126          0.640
LGA    G   133_D      L     127          0.584
LGA    L   134_D      L     128          0.432
LGA    S   135_D      A     129          0.734
LGA    A   136_D      E     130          0.999
LGA    V   137_D      S     131          0.888
LGA    L   138_D      I     132          0.938
LGA    I   139_D      E     133          1.024
LGA    G   140_D      A     134          1.311
LGA    I   141_D      G     135          1.442
LGA    G   142_D      M     136          1.283
LGA    -       -      T     137           -
LGA    -       -      R     138           -
LGA    -       -      G     139           -
LGA    -       -      L     140           -
LGA    T   143_D      F     141          3.587
LGA    P   144_D      R     142          3.774
LGA    -       -      R     143           -
LGA    -       -      D     144           -
LGA    -       -      L     145           -
LGA    E   145_D      X     146          1.912
LGA    A   146_D      A     147          1.458
LGA    E   147_D      V     148          1.740
LGA    T   148_D      N     149          1.264
LGA    R   149_D      S     150          0.407
LGA    A   150_D      A     151          0.905
LGA    A   151_D      L     152          1.515
LGA    L   152_D      A     153          1.251
LGA    L   153_D      L     154          1.059
LGA    L   154_D      A     155          1.035
LGA    A   155_D      G     156          1.681
LGA    T   156_D      M     157          1.789
LGA    V   157_D      V     158          1.607
LGA    D   158_D      N     159          1.361
LGA    G   159_D      Y     160          0.940
LGA    L   160_D      F     161          1.372
LGA    A   161_D      F     162          1.533
LGA    L   162_D      L     163          0.609
LGA    D   163_D      S     164          1.478
LGA    A   164_D      T     165          2.675
LGA    I   165_D      L     166          5.150
LGA    G   166_D      A     167          4.586
LGA    S   167_D      T     168          3.053
LGA    P   168_D      E     169          3.878
LGA    A   169_D      G     170          4.074
LGA    L   170_D      L     171          2.915
LGA    Y   171_D      T     172          3.555
LGA    P   172_D      S     173          2.349
LGA    -       -      X     174           -
LGA    P   173_D      S     175          4.676
LGA    -       -      P     176           -
LGA    -       -      D     177           -
LGA    E   174_D      Q     178          2.736
LGA    Y   175_D      D     179           #
LGA    -       -      E     180           -
LGA    -       -      E     181           -
LGA    L   176_D      L     182          2.655
LGA    E   177_D      I     183          2.782
LGA    H   178_D      R     184          3.868
LGA    A   179_D      Q     185          3.301
LGA    L   180_D      Y     186          1.745
LGA    D   181_D      V     187          2.237
LGA    I   182_D      A     188          2.428
LGA    Q   183_D      I     189          3.121
LGA    I   184_D      F     190          3.081
LGA    G   185_D      T     191          1.682
LGA    X   186_D      R     192          3.788
LGA    I   187_D      G     193           -
LGA    L   188_D      I     194           -
LGA    Q   189_D      M     195           -
LGA    G   190_D      A     196           -
LGA    A   191_D      -       -           -
LGA    D   192_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  158  140    5.0    118    2.40    11.86     57.836     4.724

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.882611 * X  +   0.268815 * Y  +   0.385662 * Z  + -38.781696
  Y_new =   0.224305 * X  +  -0.961781 * Y  +   0.157048 * Z  +  11.906454
  Z_new =   0.413140 * X  +  -0.052107 * Y  +  -0.909176 * Z  + -32.871155 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.084343    0.057250  [ DEG:  -176.7198      3.2802 ]
  Theta =  -0.425899   -2.715693  [ DEG:   -24.4022   -155.5978 ]
  Phi   =   0.248869   -2.892724  [ DEG:    14.2591   -165.7409 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2np5_D                                        
REMARK     2: T0454_57_196.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2np5_D.T0454_57_196.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  158  140   5.0  118   2.40   11.86  57.836
REMARK  ---------------------------------------------------------- 
MOLECULE 2np5_D
HEADER    TRANSCRIPTION                           26-OCT-06   2NP5              
TITLE     CRYSTAL STRUCTURE OF A TRANSCRIPTIONAL REGULATOR                      
TITLE    2 (RHA1_RO04179) FROM RHODOCOCCUS SP. RHA1.                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR;                                 
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHODOCOCCUS SP.;                                
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: RHA1;                                                        
SOURCE   5 GENE: RHA1_RO04179;                                                  
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21-CODONPLUS(DE3)-RP;                    
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: P15TV LIC                                 
KEYWDS    TETR FAMILY, TRANSCRIPTIONAL REGULATOR, STRUCTURAL GENOMICS,          
KEYWDS   2 PSI-2, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR              
KEYWDS   3 STRUCTURAL GENOMICS, MCSG                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.CHRUSZCZ,E.EVDOKIMOVA,O.KAGAN,M.CYMBOROWSKI,A.SAVCHENKO,            
AUTHOR   2 A.EDWARDS,W.MINOR,MIDWEST CENTER FOR STRUCTURAL GENOMICS             
AUTHOR   3 (MCSG)                                                               
REVDAT   1   28-NOV-06 2NP5    0                                                
JRNL        AUTH   M.CHRUSZCZ,E.EVDOKIMOVA,O.KAGAN,M.CYMBOROWSKI,               
JRNL        AUTH 2 A.SAVCHENKO,A.EDWARDS,W.MINOR,                               
JRNL        AUTH 3 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                
JRNL        TITL   CRYSTAL STRUCTURE OF A TRANSCRIPTIONAL REGULATOR             
JRNL        TITL 2 (RHA1_RO04179) FROM RHODOCOCCUS SP. RHA1.                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2NP5 A    1   203  UNP    Q0S914   Q0S914_RHOSR     1    203             
DBREF  2NP5 B    1   203  UNP    Q0S914   Q0S914_RHOSR     1    203             
DBREF  2NP5 C    1   203  UNP    Q0S914   Q0S914_RHOSR     1    203             
DBREF  2NP5 D    1   203  UNP    Q0S914   Q0S914_RHOSR     1    203             
SEQRES   1 A  203  MSE ARG GLU ARG ARG TYR SER SER THR SER PRO GLU ARG          
SEQRES   2 A  203  LEU ALA ALA ALA LEU PHE ASP VAL ALA ALA GLU SER GLY          
SEQRES   3 A  203  LEU GLU GLY ALA SER VAL ARG GLU VAL ALA LYS ARG ALA          
SEQRES   4 A  203  GLY VAL SER ILE GLY ALA VAL GLN HIS HIS PHE SER THR          
SEQRES   5 A  203  LYS ASP GLU MSE PHE ALA PHE ALA LEU ARG THR LEU VAL          
SEQRES   6 A  203  ASP LYS LEU LEU ALA ARG LEU SER GLU VAL GLU ARG GLY          
SEQRES   7 A  203  GLY ASP PRO ALA ARG ALA LEU PHE ALA ALA MSE SER GLN          
SEQRES   8 A  203  LEU LEU PRO LEU ASP GLU ALA ARG SER ARG GLU ALA HIS          
SEQRES   9 A  203  VAL MSE ALA ALA PHE ALA VAL ARG ALA ALA THR SER PRO          
SEQRES  10 A  203  SER LEU ALA GLU ILE ARG ARG LYS THR LEU PHE THR ILE          
SEQRES  11 A  203  ARG THR GLY LEU SER ALA VAL LEU ILE GLY ILE GLY THR          
SEQRES  12 A  203  PRO GLU ALA GLU THR ARG ALA ALA LEU LEU LEU ALA THR          
SEQRES  13 A  203  VAL ASP GLY LEU ALA LEU ASP ALA ILE GLY SER PRO ALA          
SEQRES  14 A  203  LEU TYR PRO PRO GLU TYR LEU GLU HIS ALA LEU ASP ILE          
SEQRES  15 A  203  GLN ILE GLY MSE ILE LEU GLN GLY ALA ASP VAL VAL PRO          
SEQRES  16 A  203  SER SER SER ILE GLU LEU ALA SER                              
SEQRES   1 B  203  MSE ARG GLU ARG ARG TYR SER SER THR SER PRO GLU ARG          
SEQRES   2 B  203  LEU ALA ALA ALA LEU PHE ASP VAL ALA ALA GLU SER GLY          
SEQRES   3 B  203  LEU GLU GLY ALA SER VAL ARG GLU VAL ALA LYS ARG ALA          
SEQRES   4 B  203  GLY VAL SER ILE GLY ALA VAL GLN HIS HIS PHE SER THR          
SEQRES   5 B  203  LYS ASP GLU MSE PHE ALA PHE ALA LEU ARG THR LEU VAL          
SEQRES   6 B  203  ASP LYS LEU LEU ALA ARG LEU SER GLU VAL GLU ARG GLY          
SEQRES   7 B  203  GLY ASP PRO ALA ARG ALA LEU PHE ALA ALA MSE SER GLN          
SEQRES   8 B  203  LEU LEU PRO LEU ASP GLU ALA ARG SER ARG GLU ALA HIS          
SEQRES   9 B  203  VAL MSE ALA ALA PHE ALA VAL ARG ALA ALA THR SER PRO          
SEQRES  10 B  203  SER LEU ALA GLU ILE ARG ARG LYS THR LEU PHE THR ILE          
SEQRES  11 B  203  ARG THR GLY LEU SER ALA VAL LEU ILE GLY ILE GLY THR          
SEQRES  12 B  203  PRO GLU ALA GLU THR ARG ALA ALA LEU LEU LEU ALA THR          
SEQRES  13 B  203  VAL ASP GLY LEU ALA LEU ASP ALA ILE GLY SER PRO ALA          
SEQRES  14 B  203  LEU TYR PRO PRO GLU TYR LEU GLU HIS ALA LEU ASP ILE          
SEQRES  15 B  203  GLN ILE GLY MSE ILE LEU GLN GLY ALA ASP VAL VAL PRO          
SEQRES  16 B  203  SER SER SER ILE GLU LEU ALA SER                              
SEQRES   1 C  203  MSE ARG GLU ARG ARG TYR SER SER THR SER PRO GLU ARG          
SEQRES   2 C  203  LEU ALA ALA ALA LEU PHE ASP VAL ALA ALA GLU SER GLY          
SEQRES   3 C  203  LEU GLU GLY ALA SER VAL ARG GLU VAL ALA LYS ARG ALA          
SEQRES   4 C  203  GLY VAL SER ILE GLY ALA VAL GLN HIS HIS PHE SER THR          
SEQRES   5 C  203  LYS ASP GLU MSE PHE ALA PHE ALA LEU ARG THR LEU VAL          
SEQRES   6 C  203  ASP LYS LEU LEU ALA ARG LEU SER GLU VAL GLU ARG GLY          
SEQRES   7 C  203  GLY ASP PRO ALA ARG ALA LEU PHE ALA ALA MSE SER GLN          
SEQRES   8 C  203  LEU LEU PRO LEU ASP GLU ALA ARG SER ARG GLU ALA HIS          
SEQRES   9 C  203  VAL MSE ALA ALA PHE ALA VAL ARG ALA ALA THR SER PRO          
SEQRES  10 C  203  SER LEU ALA GLU ILE ARG ARG LYS THR LEU PHE THR ILE          
SEQRES  11 C  203  ARG THR GLY LEU SER ALA VAL LEU ILE GLY ILE GLY THR          
SEQRES  12 C  203  PRO GLU ALA GLU THR ARG ALA ALA LEU LEU LEU ALA THR          
SEQRES  13 C  203  VAL ASP GLY LEU ALA LEU ASP ALA ILE GLY SER PRO ALA          
SEQRES  14 C  203  LEU TYR PRO PRO GLU TYR LEU GLU HIS ALA LEU ASP ILE          
SEQRES  15 C  203  GLN ILE GLY MSE ILE LEU GLN GLY ALA ASP VAL VAL PRO          
SEQRES  16 C  203  SER SER SER ILE GLU LEU ALA SER                              
SEQRES   1 D  203  MSE ARG GLU ARG ARG TYR SER SER THR SER PRO GLU ARG          
SEQRES   2 D  203  LEU ALA ALA ALA LEU PHE ASP VAL ALA ALA GLU SER GLY          
SEQRES   3 D  203  LEU GLU GLY ALA SER VAL ARG GLU VAL ALA LYS ARG ALA          
SEQRES   4 D  203  GLY VAL SER ILE GLY ALA VAL GLN HIS HIS PHE SER THR          
SEQRES   5 D  203  LYS ASP GLU MSE PHE ALA PHE ALA LEU ARG THR LEU VAL          
SEQRES   6 D  203  ASP LYS LEU LEU ALA ARG LEU SER GLU VAL GLU ARG GLY          
SEQRES   7 D  203  GLY ASP PRO ALA ARG ALA LEU PHE ALA ALA MSE SER GLN          
SEQRES   8 D  203  LEU LEU PRO LEU ASP GLU ALA ARG SER ARG GLU ALA HIS          
SEQRES   9 D  203  VAL MSE ALA ALA PHE ALA VAL ARG ALA ALA THR SER PRO          
SEQRES  10 D  203  SER LEU ALA GLU ILE ARG ARG LYS THR LEU PHE THR ILE          
SEQRES  11 D  203  ARG THR GLY LEU SER ALA VAL LEU ILE GLY ILE GLY THR          
SEQRES  12 D  203  PRO GLU ALA GLU THR ARG ALA ALA LEU LEU LEU ALA THR          
SEQRES  13 D  203  VAL ASP GLY LEU ALA LEU ASP ALA ILE GLY SER PRO ALA          
SEQRES  14 D  203  LEU TYR PRO PRO GLU TYR LEU GLU HIS ALA LEU ASP ILE          
SEQRES  15 D  203  GLN ILE GLY MSE ILE LEU GLN GLY ALA ASP VAL VAL PRO          
SEQRES  16 D  203  SER SER SER ILE GLU LEU ALA SER                              
HET    MSE  A  56       8                                                       
HET    MSE  A  89       8                                                       
HET    MSE  A 106       8                                                       
HET    MSE  A 186       8                                                       
HET    MSE  B  56       8                                                       
HET    MSE  B  89       8                                                       
HET    MSE  B 106       8                                                       
HET    MSE  B 186       8                                                       
HET    MSE  C  56       8                                                       
HET    MSE  C  89       8                                                       
HET    MSE  C 106       8                                                       
HET    MSE  C 186       8                                                       
HET    MSE  D  56      13                                                       
HET    MSE  D  89       8                                                       
HET    MSE  D 106       8                                                       
HET    MSE  D 186       8                                                       
HET    LMT  A 201      35                                                       
HET    LMT  B 201      35                                                       
HET    NDS    601      12                                                       
HET    NDS    602      12                                                       
HET    NDS    603      12                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     LMT DODECYL-BETA-D-MALTOSIDE                                         
HETNAM     NDS ETHYL DIMETHYL AMMONIO PROPANE SULFONATE                         
FORMUL   1  MSE    16(C5 H11 N O2 SE)                                           
FORMUL   5  LMT    2(C24 H46 O11)                                               
FORMUL   7  NDS    3(C7 H17 N O3 S)                                             
FORMUL  10  HOH   *421(H2 O)                                                    
CRYST1   50.721   52.230   72.853 102.31 107.25  89.71 P 1           4          
ATOM   4181  N   SER D  10     -19.011  16.004  -4.083  1.00 59.18           N  
ATOM   4182  CA  SER D  10     -18.621  17.441  -4.223  1.00 59.10           C  
ATOM   4183  C   SER D  10     -19.851  18.365  -4.352  1.00 58.93           C  
ATOM   4184  O   SER D  10     -20.042  19.240  -3.502  1.00 58.75           O  
ATOM   4185  CB  SER D  10     -17.636  17.625  -5.384  1.00 59.13           C  
ATOM   4186  OG  SER D  10     -16.857  18.795  -5.218  1.00 59.65           O  
ATOM   4187  N   PRO D  11     -20.685  18.185  -5.404  1.00 58.88           N  
ATOM   4188  CA  PRO D  11     -21.984  18.872  -5.440  1.00 58.82           C  
ATOM   4189  C   PRO D  11     -22.781  18.714  -4.134  1.00 58.63           C  
ATOM   4190  O   PRO D  11     -23.595  19.571  -3.795  1.00 58.57           O  
ATOM   4191  CB  PRO D  11     -22.704  18.180  -6.599  1.00 58.99           C  
ATOM   4192  CG  PRO D  11     -21.607  17.816  -7.526  1.00 58.88           C  
ATOM   4193  CD  PRO D  11     -20.478  17.384  -6.628  1.00 58.86           C  
ATOM   4194  N   GLU D  12     -22.553  17.608  -3.433  1.00 58.37           N  
ATOM   4195  CA  GLU D  12     -22.900  17.481  -2.022  1.00 57.97           C  
ATOM   4196  C   GLU D  12     -21.569  17.313  -1.269  1.00 57.63           C  
ATOM   4197  O   GLU D  12     -20.716  16.502  -1.685  1.00 57.73           O  
ATOM   4198  CB  GLU D  12     -23.818  16.283  -1.800  1.00 58.21           C  
ATOM   4199  N   ARG D  13     -21.367  18.038  -0.163  1.00 56.83           N  
ATOM   4200  CA  ARG D  13     -22.404  18.773   0.564  1.00 55.88           C  
ATOM   4201  C   ARG D  13     -22.448  20.269   0.245  1.00 55.11           C  
ATOM   4202  O   ARG D  13     -22.737  21.084   1.123  1.00 55.07           O  
ATOM   4203  CB  ARG D  13     -22.216  18.571   2.075  1.00 56.09           C  
ATOM   4204  N   LEU D  14     -22.159  20.617  -1.008  1.00 53.87           N  
ATOM   4205  CA  LEU D  14     -22.312  21.988  -1.489  1.00 53.03           C  
ATOM   4206  C   LEU D  14     -23.798  22.344  -1.512  1.00 52.25           C  
ATOM   4207  O   LEU D  14     -24.198  23.440  -1.100  1.00 51.63           O  
ATOM   4208  CB  LEU D  14     -21.712  22.112  -2.887  1.00 53.01           C  
ATOM   4209  CG  LEU D  14     -21.349  23.492  -3.421  1.00 53.17           C  
ATOM   4210  CD1 LEU D  14     -20.163  23.373  -4.380  1.00 53.21           C  
ATOM   4211  CD2 LEU D  14     -22.534  24.083  -4.103  1.00 52.39           C  
ATOM   4212  N   ALA D  15     -24.599  21.400  -2.012  1.00 51.62           N  
ATOM   4213  CA  ALA D  15     -26.058  21.494  -1.982  1.00 50.98           C  
ATOM   4214  C   ALA D  15     -26.530  21.625  -0.536  1.00 50.70           C  
ATOM   4215  O   ALA D  15     -27.284  22.546  -0.207  1.00 50.95           O  
ATOM   4216  CB  ALA D  15     -26.682  20.270  -2.649  1.00 50.90           C  
ATOM   4217  N   ALA D  16     -26.052  20.725   0.323  1.00 50.21           N  
ATOM   4218  CA  ALA D  16     -26.401  20.703   1.745  1.00 49.89           C  
ATOM   4219  C   ALA D  16     -25.992  21.973   2.491  1.00 49.83           C  
ATOM   4220  O   ALA D  16     -26.659  22.383   3.445  1.00 49.88           O  
ATOM   4221  CB  ALA D  16     -25.782  19.479   2.411  1.00 49.96           C  
ATOM   4222  N   ALA D  17     -24.880  22.569   2.060  1.00 49.56           N  
ATOM   4223  CA  ALA D  17     -24.363  23.811   2.629  1.00 49.32           C  
ATOM   4224  C   ALA D  17     -25.284  24.968   2.298  1.00 49.16           C  
ATOM   4225  O   ALA D  17     -25.496  25.853   3.133  1.00 48.75           O  
ATOM   4226  CB  ALA D  17     -22.943  24.100   2.102  1.00 49.44           C  
ATOM   4227  N   LEU D  18     -25.817  24.970   1.071  1.00 49.06           N  
ATOM   4228  CA  LEU D  18     -26.761  26.014   0.701  1.00 49.30           C  
ATOM   4229  C   LEU D  18     -27.937  25.970   1.667  1.00 49.05           C  
ATOM   4230  O   LEU D  18     -28.221  26.966   2.334  1.00 48.96           O  
ATOM   4231  CB  LEU D  18     -27.219  25.925  -0.762  1.00 49.73           C  
ATOM   4232  CG  LEU D  18     -28.186  27.041  -1.219  1.00 51.18           C  
ATOM   4233  CD1 LEU D  18     -28.050  28.371  -0.425  1.00 54.08           C  
ATOM   4234  CD2 LEU D  18     -27.923  27.343  -2.657  1.00 55.42           C  
ATOM   4235  N   PHE D  19     -28.584  24.811   1.783  1.00 49.25           N  
ATOM   4236  CA  PHE D  19     -29.782  24.721   2.615  1.00 50.14           C  
ATOM   4237  C   PHE D  19     -29.507  25.133   4.056  1.00 50.42           C  
ATOM   4238  O   PHE D  19     -30.319  25.836   4.658  1.00 50.68           O  
ATOM   4239  CB  PHE D  19     -30.430  23.348   2.529  1.00 50.21           C  
ATOM   4240  CG  PHE D  19     -31.093  23.102   1.225  1.00 50.80           C  
ATOM   4241  CD1 PHE D  19     -32.321  23.705   0.936  1.00 51.42           C  
ATOM   4242  CD2 PHE D  19     -30.487  22.286   0.265  1.00 51.45           C  
ATOM   4243  CE1 PHE D  19     -32.946  23.485  -0.290  1.00 52.36           C  
ATOM   4244  CE2 PHE D  19     -31.101  22.052  -0.968  1.00 51.68           C  
ATOM   4245  CZ  PHE D  19     -32.331  22.664  -1.251  1.00 52.28           C  
ATOM   4246  N   ASP D  20     -28.340  24.731   4.574  1.00 50.96           N  
ATOM   4247  CA  ASP D  20     -27.942  25.036   5.957  1.00 50.94           C  
ATOM   4248  C   ASP D  20     -27.756  26.531   6.192  1.00 51.30           C  
ATOM   4249  O   ASP D  20     -28.269  27.076   7.168  1.00 50.62           O  
ATOM   4250  CB  ASP D  20     -26.666  24.278   6.345  1.00 51.23           C  
ATOM   4251  N   VAL D  21     -27.017  27.179   5.289  1.00 51.89           N  
ATOM   4252  CA  VAL D  21     -26.791  28.629   5.327  1.00 52.49           C  
ATOM   4253  C   VAL D  21     -28.103  29.415   5.150  1.00 52.84           C  
ATOM   4254  O   VAL D  21     -28.411  30.313   5.951  1.00 52.79           O  
ATOM   4255  CB  VAL D  21     -25.747  29.067   4.248  1.00 52.46           C  
ATOM   4256  CG1 VAL D  21     -25.806  30.580   3.995  1.00 52.76           C  
ATOM   4257  CG2 VAL D  21     -24.329  28.634   4.648  1.00 52.80           C  
ATOM   4258  N   ALA D  22     -28.857  29.070   4.100  1.00 53.13           N  
ATOM   4259  CA  ALA D  22     -30.140  29.706   3.810  1.00 53.57           C  
ATOM   4260  C   ALA D  22     -31.146  29.487   4.954  1.00 53.77           C  
ATOM   4261  O   ALA D  22     -31.954  30.369   5.264  1.00 54.14           O  
ATOM   4262  CB  ALA D  22     -30.699  29.202   2.475  1.00 53.06           C  
ATOM   4263  N   ALA D  23     -31.071  28.319   5.588  1.00 54.37           N  
ATOM   4264  CA  ALA D  23     -31.929  28.007   6.736  1.00 55.39           C  
ATOM   4265  C   ALA D  23     -31.654  28.936   7.911  1.00 55.92           C  
ATOM   4266  O   ALA D  23     -32.585  29.441   8.534  1.00 55.91           O  
ATOM   4267  CB  ALA D  23     -31.746  26.565   7.158  1.00 55.21           C  
ATOM   4268  N   GLU D  24     -30.372  29.168   8.192  1.00 56.93           N  
ATOM   4269  CA  GLU D  24     -29.961  29.948   9.361  1.00 58.05           C  
ATOM   4270  C   GLU D  24     -30.067  31.463   9.182  1.00 58.69           C  
ATOM   4271  O   GLU D  24     -30.471  32.170  10.112  1.00 59.02           O  
ATOM   4272  CB  GLU D  24     -28.537  29.585   9.799  1.00 57.91           C  
ATOM   4273  CG  GLU D  24     -28.208  30.060  11.213  1.00 58.33           C  
ATOM   4274  CD  GLU D  24     -26.722  30.039  11.538  1.00 58.22           C  
ATOM   4275  OE1 GLU D  24     -26.014  29.106  11.104  1.00 58.50           O  
ATOM   4276  OE2 GLU D  24     -26.265  30.960  12.248  1.00 58.57           O  
ATOM   4277  N   SER D  25     -29.696  31.965   8.005  1.00 59.36           N  
ATOM   4278  CA  SER D  25     -29.587  33.419   7.807  1.00 59.93           C  
ATOM   4279  C   SER D  25     -30.610  34.006   6.822  1.00 60.09           C  
ATOM   4280  O   SER D  25     -30.544  35.194   6.485  1.00 60.27           O  
ATOM   4281  CB  SER D  25     -28.147  33.813   7.425  1.00 59.86           C  
ATOM   4282  OG  SER D  25     -27.673  33.069   6.312  1.00 60.31           O  
ATOM   4283  N   GLY D  26     -31.559  33.178   6.383  1.00 60.24           N  
ATOM   4284  CA  GLY D  26     -32.577  33.590   5.411  1.00 60.26           C  
ATOM   4285  C   GLY D  26     -32.026  33.647   3.996  1.00 60.31           C  
ATOM   4286  O   GLY D  26     -30.803  33.727   3.792  1.00 60.33           O  
ATOM   4287  N   LEU D  27     -32.926  33.607   3.015  1.00 60.21           N  
ATOM   4288  CA  LEU D  27     -32.543  33.677   1.598  1.00 60.07           C  
ATOM   4289  C   LEU D  27     -31.760  34.952   1.280  1.00 60.20           C  
ATOM   4290  O   LEU D  27     -30.876  34.943   0.428  1.00 59.97           O  
ATOM   4291  CB  LEU D  27     -33.787  33.605   0.716  1.00 60.13           C  
ATOM   4292  CG  LEU D  27     -34.326  32.277   0.174  1.00 60.35           C  
ATOM   4293  CD1 LEU D  27     -33.951  31.036   0.990  1.00 61.00           C  
ATOM   4294  CD2 LEU D  27     -35.829  32.391   0.044  1.00 60.39           C  
ATOM   4295  N   LYS D  53     -27.288  33.287  -4.779  1.00 62.12           N  
ATOM   4296  CA  LYS D  53     -27.519  33.669  -6.167  1.00 62.14           C  
ATOM   4297  C   LYS D  53     -28.506  32.724  -6.843  1.00 62.27           C  
ATOM   4298  O   LYS D  53     -28.869  31.689  -6.285  1.00 62.65           O  
ATOM   4299  CB  LYS D  53     -26.200  33.695  -6.942  1.00 61.87           C  
ATOM   4300  CG  LYS D  53     -26.121  34.790  -7.995  1.00 61.81           C  
ATOM   4301  CD  LYS D  53     -24.994  34.565  -8.984  1.00 61.85           C  
ATOM   4302  N   ASP D  54     -28.935  33.086  -8.047  1.00 20.00           N  
ATOM   4303  CA  ASP D  54     -29.898  32.283  -8.791  1.00 20.00           C  
ATOM   4304  C   ASP D  54     -29.328  30.909  -9.127  1.00 20.00           C  
ATOM   4305  O   ASP D  54     -30.047  29.910  -9.128  1.00 61.83           O  
ATOM   4306  CB  ASP D  54     -30.322  33.004 -10.073  1.00 20.00           C  
ATOM   4307  CG  ASP D  54     -29.182  33.155 -11.060  1.00 20.00           C  
ATOM   4308  OD1 ASP D  54     -28.046  32.757 -10.725  1.00 20.00           O  
ATOM   4309  OD2 ASP D  54     -29.421  33.672 -12.172  1.00 20.00           O  
ATOM   4310  N   GLU D  55     -28.029  30.867  -9.412  1.00 61.37           N  
ATOM   4311  CA  GLU D  55     -27.395  29.653  -9.912  1.00 60.51           C  
ATOM   4312  C   GLU D  55     -27.245  28.613  -8.807  1.00 59.78           C  
ATOM   4313  O   GLU D  55     -27.285  27.410  -9.065  1.00 59.44           O  
ATOM   4314  CB  GLU D  55     -26.028  29.976 -10.521  1.00 60.88           C  
HETATM 4315  N   MSE D  56     -27.071  29.085  -7.578  1.00 58.99           N  
HETATM 4316  CA  MSE D  56     -26.877  28.392  -6.515  0.50 58.57           C  
HETATM 4318  C   MSE D  56     -28.152  27.716  -6.000  1.00 57.86           C  
HETATM 4319  O   MSE D  56     -28.149  26.550  -5.607  1.00 57.89           O  
HETATM 4320  CB  MSE D  56     -26.205  29.091  -5.332  0.50 58.50           C  
HETATM 4322  CG  MSE D  56     -24.676  29.189  -5.428  0.50 58.95           C  
HETATM 4324 SE   MSE D  56     -23.875  28.912  -3.633  0.50 59.48          SE  
HETATM 4326  CE  MSE D  56     -24.879  30.343  -2.645  0.50 57.94           C  
ATOM   4328  N   PHE D  57     -29.264  28.431  -6.139  1.00 56.44           N  
ATOM   4329  CA  PHE D  57     -30.563  27.911  -5.731  1.00 55.01           C  
ATOM   4330  C   PHE D  57     -31.135  26.967  -6.783  1.00 53.42           C  
ATOM   4331  O   PHE D  57     -31.725  25.938  -6.454  1.00 52.75           O  
ATOM   4332  CB  PHE D  57     -31.541  29.060  -5.468  1.00 55.33           C  
ATOM   4333  CG  PHE D  57     -31.472  29.606  -4.071  1.00 56.28           C  
ATOM   4334  CD1 PHE D  57     -32.098  28.948  -3.024  1.00 57.86           C  
ATOM   4335  CD2 PHE D  57     -30.782  30.776  -3.804  1.00 57.04           C  
ATOM   4336  CE1 PHE D  57     -32.036  29.449  -1.738  1.00 58.78           C  
ATOM   4337  CE2 PHE D  57     -30.718  31.282  -2.519  1.00 57.24           C  
ATOM   4338  CZ  PHE D  57     -31.345  30.617  -1.485  1.00 57.48           C  
ATOM   4339  N   ALA D  58     -30.958  27.325  -8.051  1.00 51.63           N  
ATOM   4340  CA  ALA D  58     -31.222  26.405  -9.150  1.00 50.02           C  
ATOM   4341  C   ALA D  58     -30.488  25.083  -8.954  1.00 49.35           C  
ATOM   4342  O   ALA D  58     -31.063  24.009  -9.132  1.00 48.62           O  
ATOM   4343  CB  ALA D  58     -30.832  27.038 -10.477  1.00 49.97           C  
ATOM   4344  N   PHE D  59     -29.213  25.170  -8.584  1.00 47.86           N  
ATOM   4345  CA  PHE D  59     -28.414  23.982  -8.308  1.00 47.43           C  
ATOM   4346  C   PHE D  59     -28.956  23.221  -7.101  1.00 46.98           C  
ATOM   4347  O   PHE D  59     -29.119  22.002  -7.147  1.00 47.04           O  
ATOM   4348  CB  PHE D  59     -26.951  24.364  -8.074  1.00 47.76           C  
ATOM   4349  CG  PHE D  59     -26.143  23.288  -7.407  1.00 48.33           C  
ATOM   4350  CD1 PHE D  59     -25.684  22.200  -8.129  1.00 48.67           C  
ATOM   4351  CD2 PHE D  59     -25.843  23.364  -6.057  1.00 48.57           C  
ATOM   4352  CE1 PHE D  59     -24.939  21.208  -7.518  1.00 49.16           C  
ATOM   4353  CE2 PHE D  59     -25.100  22.376  -5.441  1.00 49.85           C  
ATOM   4354  CZ  PHE D  59     -24.647  21.297  -6.172  1.00 48.74           C  
ATOM   4355  N   ALA D  60     -29.234  23.949  -6.025  1.00 45.73           N  
ATOM   4356  CA  ALA D  60     -29.760  23.346  -4.806  1.00 44.82           C  
ATOM   4357  C   ALA D  60     -31.062  22.600  -5.078  1.00 44.15           C  
ATOM   4358  O   ALA D  60     -31.202  21.428  -4.727  1.00 44.24           O  
ATOM   4359  CB  ALA D  60     -29.968  24.406  -3.737  1.00 45.10           C  
ATOM   4360  N   LEU D  61     -32.011  23.286  -5.706  1.00 42.43           N  
ATOM   4361  CA  LEU D  61     -33.311  22.697  -6.008  1.00 42.03           C  
ATOM   4362  C   LEU D  61     -33.169  21.499  -6.942  1.00 40.98           C  
ATOM   4363  O   LEU D  61     -33.885  20.506  -6.807  1.00 40.29           O  
ATOM   4364  CB  LEU D  61     -34.242  23.740  -6.628  1.00 41.70           C  
ATOM   4365  CG  LEU D  61     -34.672  24.892  -5.718  1.00 45.16           C  
ATOM   4366  CD1 LEU D  61     -36.012  25.456  -6.162  1.00 45.52           C  
ATOM   4367  CD2 LEU D  61     -34.731  24.437  -4.267  1.00 45.26           C  
ATOM   4368  N   ARG D  62     -32.241  21.599  -7.889  1.00 39.94           N  
ATOM   4369  CA  ARG D  62     -31.978  20.510  -8.821  1.00 40.04           C  
ATOM   4370  C   ARG D  62     -31.506  19.259  -8.088  1.00 39.12           C  
ATOM   4371  O   ARG D  62     -31.922  18.146  -8.409  1.00 38.15           O  
ATOM   4372  CB  ARG D  62     -30.939  20.935  -9.861  1.00 40.22           C  
ATOM   4373  CG  ARG D  62     -30.393  19.789 -10.696  1.00 45.20           C  
ATOM   4374  CD  ARG D  62     -31.190  19.612 -11.978  1.00 51.66           C  
ATOM   4375  NE  ARG D  62     -30.645  18.550 -12.819  1.00 56.59           N  
ATOM   4376  CZ  ARG D  62     -30.947  18.383 -14.103  1.00 58.35           C  
ATOM   4377  NH1 ARG D  62     -31.791  19.213 -14.699  1.00 56.96           N  
ATOM   4378  NH2 ARG D  62     -30.403  17.388 -14.790  1.00 57.55           N  
ATOM   4379  N   THR D  63     -30.634  19.449  -7.104  1.00 38.29           N  
ATOM   4380  CA  THR D  63     -30.137  18.338  -6.290  1.00 38.66           C  
ATOM   4381  C   THR D  63     -31.287  17.706  -5.513  1.00 38.35           C  
ATOM   4382  O   THR D  63     -31.388  16.469  -5.403  1.00 38.14           O  
ATOM   4383  CB  THR D  63     -29.006  18.793  -5.331  1.00 38.58           C  
ATOM   4384  OG1 THR D  63     -27.916  19.301  -6.110  1.00 40.12           O  
ATOM   4385  CG2 THR D  63     -28.494  17.643  -4.501  1.00 39.73           C  
ATOM   4386  N   LEU D  64     -32.167  18.553  -5.004  1.00 37.70           N  
ATOM   4387  CA  LEU D  64     -33.364  18.072  -4.351  1.00 38.19           C  
ATOM   4388  C   LEU D  64     -34.242  17.261  -5.302  1.00 36.78           C  
ATOM   4389  O   LEU D  64     -34.698  16.174  -4.958  1.00 36.67           O  
ATOM   4390  CB  LEU D  64     -34.164  19.248  -3.773  1.00 38.88           C  
ATOM   4391  CG  LEU D  64     -35.408  18.838  -2.991  1.00 40.46           C  
ATOM   4392  CD1 LEU D  64     -34.979  17.960  -1.790  1.00 43.98           C  
ATOM   4393  CD2 LEU D  64     -36.175  20.076  -2.529  1.00 41.32           C  
ATOM   4394  N   VAL D  65     -34.482  17.796  -6.501  1.00 36.71           N  
ATOM   4395  CA  VAL D  65     -35.315  17.108  -7.476  1.00 36.06           C  
ATOM   4396  C   VAL D  65     -34.676  15.755  -7.823  1.00 34.71           C  
ATOM   4397  O   VAL D  65     -35.363  14.725  -7.861  1.00 31.52           O  
ATOM   4398  CB  VAL D  65     -35.571  17.968  -8.724  1.00 36.83           C  
ATOM   4399  CG1 VAL D  65     -36.238  17.143  -9.821  1.00 39.35           C  
ATOM   4400  CG2 VAL D  65     -36.452  19.181  -8.358  1.00 38.08           C  
ATOM   4401  N   ASP D  66     -33.362  15.775  -8.060  1.00 33.91           N  
ATOM   4402  CA  ASP D  66     -32.632  14.580  -8.460  1.00 34.74           C  
ATOM   4403  C   ASP D  66     -32.675  13.483  -7.375  1.00 34.16           C  
ATOM   4404  O   ASP D  66     -32.789  12.301  -7.692  1.00 33.30           O  
ATOM   4405  CB  ASP D  66     -31.192  14.930  -8.891  1.00 35.39           C  
ATOM   4406  CG  ASP D  66     -31.131  15.805 -10.163  1.00 39.73           C  
ATOM   4407  OD1 ASP D  66     -32.155  15.931 -10.891  1.00 42.72           O  
ATOM   4408  OD2 ASP D  66     -30.042  16.400 -10.439  1.00 45.61           O  
ATOM   4409  N   LYS D  67     -32.608  13.872  -6.099  1.00 34.06           N  
ATOM   4410  CA  LYS D  67     -32.788  12.915  -4.997  1.00 34.39           C  
ATOM   4411  C   LYS D  67     -34.167  12.274  -4.956  1.00 33.28           C  
ATOM   4412  O   LYS D  67     -34.266  11.072  -4.777  1.00 32.89           O  
ATOM   4413  CB  LYS D  67     -32.453  13.552  -3.646  1.00 35.04           C  
ATOM   4414  CG  LYS D  67     -30.963  13.833  -3.536  1.00 38.82           C  
ATOM   4415  CD  LYS D  67     -30.574  14.626  -2.290  1.00 43.20           C  
ATOM   4416  CE  LYS D  67     -29.044  14.754  -2.238  1.00 45.99           C  
ATOM   4417  NZ  LYS D  67     -28.539  14.928  -0.832  1.00 47.42           N  
ATOM   4418  N   LEU D  68     -35.221  13.089  -5.086  1.00 32.74           N  
ATOM   4419  CA  LEU D  68     -36.626  12.618  -5.160  1.00 32.15           C  
ATOM   4420  C   LEU D  68     -36.859  11.657  -6.342  1.00 29.81           C  
ATOM   4421  O   LEU D  68     -37.509  10.632  -6.185  1.00 29.19           O  
ATOM   4422  CB  LEU D  68     -37.598  13.814  -5.308  1.00 32.67           C  
ATOM   4423  CG  LEU D  68     -38.530  14.161  -4.181  1.00 37.18           C  
ATOM   4424  CD1 LEU D  68     -37.650  14.488  -2.960  1.00 41.31           C  
ATOM   4425  CD2 LEU D  68     -39.453  15.367  -4.479  1.00 35.90           C  
ATOM   4426  N   LEU D  69     -36.335  12.010  -7.514  1.00 29.19           N  
ATOM   4427  CA  LEU D  69     -36.545  11.188  -8.702  1.00 28.73           C  
ATOM   4428  C   LEU D  69     -35.855   9.818  -8.514  1.00 28.14           C  
ATOM   4429  O   LEU D  69     -36.357   8.790  -8.940  1.00 27.52           O  
ATOM   4430  CB  LEU D  69     -36.041  11.892  -9.947  1.00 28.75           C  
ATOM   4431  CG  LEU D  69     -36.795  13.167 -10.367  1.00 27.60           C  
ATOM   4432  CD1 LEU D  69     -36.239  13.691 -11.718  1.00 28.74           C  
ATOM   4433  CD2 LEU D  69     -38.301  12.828 -10.414  1.00 28.30           C  
ATOM   4434  N   ALA D  70     -34.723   9.830  -7.826  1.00 29.40           N  
ATOM   4435  CA  ALA D  70     -33.962   8.597  -7.545  1.00 29.79           C  
ATOM   4436  C   ALA D  70     -34.860   7.639  -6.762  1.00 29.22           C  
ATOM   4437  O   ALA D  70     -34.913   6.438  -7.047  1.00 29.80           O  
ATOM   4438  CB  ALA D  70     -32.675   8.926  -6.760  1.00 29.36           C  
ATOM   4439  N   ARG D  71     -35.612   8.184  -5.805  1.00 29.89           N  
ATOM   4440  CA  ARG D  71     -36.520   7.390  -5.013  1.00 29.59           C  
ATOM   4441  C   ARG D  71     -37.684   6.900  -5.846  1.00 28.73           C  
ATOM   4442  O   ARG D  71     -38.009   5.720  -5.815  1.00 28.49           O  
ATOM   4443  CB  ARG D  71     -36.930   8.147  -3.731  1.00 31.84           C  
ATOM   4444  CG  ARG D  71     -35.617   8.659  -3.007  1.00 32.60           C  
ATOM   4445  CD  ARG D  71     -35.855   9.517  -1.771  1.00 34.09           C  
ATOM   4446  NE  ARG D  71     -34.644   9.649  -0.945  1.00 38.61           N  
ATOM   4447  CZ  ARG D  71     -34.263   8.738  -0.043  1.00 43.65           C  
ATOM   4448  NH1 ARG D  71     -34.989   7.637   0.130  1.00 45.46           N  
ATOM   4449  NH2 ARG D  71     -33.158   8.909   0.677  1.00 45.56           N  
ATOM   4450  N   LEU D  72     -38.274   7.779  -6.653  1.00 28.18           N  
ATOM   4451  CA  LEU D  72     -39.373   7.353  -7.579  1.00 27.13           C  
ATOM   4452  C   LEU D  72     -38.915   6.331  -8.590  1.00 26.78           C  
ATOM   4453  O   LEU D  72     -39.700   5.496  -9.038  1.00 27.51           O  
ATOM   4454  CB  LEU D  72     -39.969   8.574  -8.311  1.00 27.84           C  
ATOM   4455  CG  LEU D  72     -40.683   9.598  -7.439  1.00 28.94           C  
ATOM   4456  CD1 LEU D  72     -41.253  10.759  -8.331  1.00 28.15           C  
ATOM   4457  CD2 LEU D  72     -41.821   8.949  -6.621  1.00 30.15           C  
ATOM   4458  N   SER D  73     -37.637   6.389  -8.968  1.00 23.84           N  
ATOM   4459  CA  SER D  73     -37.092   5.520 -10.011  1.00 24.05           C  
ATOM   4460  C   SER D  73     -37.144   4.020  -9.583  1.00 23.84           C  
ATOM   4461  O   SER D  73     -37.131   3.123 -10.419  1.00 24.10           O  
ATOM   4462  CB  SER D  73     -35.651   5.931 -10.311  1.00 23.67           C  
ATOM   4463  OG  SER D  73     -34.746   5.256  -9.440  1.00 19.72           O  
ATOM   4464  N   GLU D  74     -37.214   3.752  -8.269  1.00 25.25           N  
ATOM   4465  CA  GLU D  74     -37.247   2.357  -7.774  1.00 27.86           C  
ATOM   4466  C   GLU D  74     -38.458   1.552  -8.314  1.00 27.77           C  
ATOM   4467  O   GLU D  74     -38.410   0.325  -8.399  1.00 29.07           O  
ATOM   4468  CB  GLU D  74     -37.252   2.301  -6.223  1.00 28.76           C  
ATOM   4469  CG  GLU D  74     -36.098   3.062  -5.532  1.00 32.00           C  
ATOM   4470  CD  GLU D  74     -34.736   2.458  -5.729  1.00 35.63           C  
ATOM   4471  OE1 GLU D  74     -34.579   1.485  -6.505  1.00 36.87           O  
ATOM   4472  OE2 GLU D  74     -33.802   2.977  -5.079  1.00 36.43           O  
ATOM   4473  N   VAL D  75     -39.539   2.249  -8.662  1.00 28.17           N  
ATOM   4474  CA  VAL D  75     -40.711   1.568  -9.243  1.00 30.00           C  
ATOM   4475  C   VAL D  75     -40.369   0.805 -10.537  1.00 30.33           C  
ATOM   4476  O   VAL D  75     -40.814  -0.335 -10.736  1.00 30.08           O  
ATOM   4477  CB  VAL D  75     -41.877   2.557  -9.438  1.00 30.30           C  
ATOM   4478  CG1 VAL D  75     -43.053   1.880 -10.148  1.00 33.08           C  
ATOM   4479  CG2 VAL D  75     -42.336   3.051  -8.062  1.00 28.65           C  
ATOM   4480  N   GLU D  76     -39.529   1.410 -11.389  1.00 31.98           N  
ATOM   4481  CA  GLU D  76     -38.992   0.731 -12.604  1.00 33.98           C  
ATOM   4482  C   GLU D  76     -38.434  -0.654 -12.386  1.00 34.33           C  
ATOM   4483  O   GLU D  76     -38.521  -1.533 -13.257  1.00 35.03           O  
ATOM   4484  CB  GLU D  76     -37.792   1.490 -13.185  1.00 34.93           C  
ATOM   4485  CG  GLU D  76     -38.056   2.818 -13.765  1.00 34.87           C  
ATOM   4486  CD  GLU D  76     -37.032   3.129 -14.894  1.00 34.93           C  
ATOM   4487  OE1 GLU D  76     -35.817   2.767 -14.787  1.00 30.62           O  
ATOM   4488  OE2 GLU D  76     -37.460   3.742 -15.889  1.00 35.02           O  
ATOM   4489  N   ARG D  77     -37.763  -0.835 -11.256  1.00 34.75           N  
ATOM   4490  CA  ARG D  77     -37.110  -2.088 -11.008  1.00 34.35           C  
ATOM   4491  C   ARG D  77     -37.892  -3.055 -10.098  1.00 33.96           C  
ATOM   4492  O   ARG D  77     -37.366  -4.045  -9.580  1.00 33.37           O  
ATOM   4493  CB  ARG D  77     -35.635  -1.886 -10.634  1.00 35.96           C  
ATOM   4494  CG  ARG D  77     -35.367  -1.127  -9.388  1.00 35.24           C  
ATOM   4495  CD  ARG D  77     -33.888  -1.273  -9.122  1.00 36.99           C  
ATOM   4496  NE  ARG D  77     -33.499  -0.635  -7.876  1.00 36.41           N  
ATOM   4497  CZ  ARG D  77     -32.371  -0.893  -7.218  1.00 36.32           C  
ATOM   4498  NH1 ARG D  77     -31.506  -1.783  -7.677  1.00 33.73           N  
ATOM   4499  NH2 ARG D  77     -32.114  -0.228  -6.100  1.00 37.47           N  
ATOM   4500  N   GLY D  78     -39.186  -2.783  -9.983  1.00 32.54           N  
ATOM   4501  CA  GLY D  78     -40.110  -3.705  -9.335  1.00 32.18           C  
ATOM   4502  C   GLY D  78     -40.463  -3.244  -7.936  1.00 32.21           C  
ATOM   4503  O   GLY D  78     -41.130  -3.959  -7.208  1.00 31.87           O  
ATOM   4504  N   GLY D  79     -40.044  -2.030  -7.569  1.00 31.83           N  
ATOM   4505  CA  GLY D  79     -40.328  -1.538  -6.232  1.00 31.67           C  
ATOM   4506  C   GLY D  79     -41.823  -1.221  -6.089  1.00 32.42           C  
ATOM   4507  O   GLY D  79     -42.551  -1.048  -7.081  1.00 32.85           O  
ATOM   4508  N   ASP D  80     -42.283  -1.181  -4.854  1.00 32.14           N  
ATOM   4509  CA  ASP D  80     -43.693  -0.972  -4.584  1.00 32.15           C  
ATOM   4510  C   ASP D  80     -44.023   0.496  -4.748  1.00 31.69           C  
ATOM   4511  O   ASP D  80     -43.344   1.335  -4.165  1.00 32.80           O  
ATOM   4512  CB  ASP D  80     -44.017  -1.390  -3.163  1.00 32.59           C  
ATOM   4513  CG  ASP D  80     -45.478  -1.188  -2.831  1.00 33.69           C  
ATOM   4514  OD1 ASP D  80     -46.324  -1.939  -3.365  1.00 36.83           O  
ATOM   4515  OD2 ASP D  80     -45.786  -0.276  -2.039  1.00 32.60           O  
ATOM   4516  N   PRO D  81     -45.066   0.816  -5.537  1.00 31.90           N  
ATOM   4517  CA  PRO D  81     -45.431   2.196  -5.794  1.00 31.39           C  
ATOM   4518  C   PRO D  81     -45.702   2.982  -4.527  1.00 31.12           C  
ATOM   4519  O   PRO D  81     -45.180   4.089  -4.379  1.00 29.65           O  
ATOM   4520  CB  PRO D  81     -46.704   2.077  -6.647  1.00 32.69           C  
ATOM   4521  CG  PRO D  81     -46.513   0.746  -7.345  1.00 32.14           C  
ATOM   4522  CD  PRO D  81     -45.962  -0.114  -6.245  1.00 32.87           C  
ATOM   4523  N   ALA D  82     -46.481   2.410  -3.597  1.00 30.24           N  
ATOM   4524  CA  ALA D  82     -46.814   3.125  -2.363  1.00 29.89           C  
ATOM   4525  C   ALA D  82     -45.554   3.468  -1.550  1.00 29.30           C  
ATOM   4526  O   ALA D  82     -45.381   4.599  -1.113  1.00 29.74           O  
ATOM   4527  CB  ALA D  82     -47.869   2.327  -1.531  1.00 30.23           C  
ATOM   4528  N   ARG D  83     -44.630   2.511  -1.419  1.00 27.66           N  
ATOM   4529  CA  ARG D  83     -43.412   2.750  -0.650  0.50 27.46           C  
ATOM   4531  C   ARG D  83     -42.473   3.761  -1.322  1.00 27.19           C  
ATOM   4532  O   ARG D  83     -41.844   4.578  -0.643  1.00 26.69           O  
ATOM   4533  CB  ARG D  83     -42.699   1.420  -0.351  0.50 27.02           C  
ATOM   4535  CG  ARG D  83     -43.625   0.440   0.361  0.50 27.37           C  
ATOM   4537  CD  ARG D  83     -42.874  -0.666   1.057  0.50 27.13           C  
ATOM   4539  NE  ARG D  83     -42.306  -1.647   0.134  0.50 29.23           N  
ATOM   4541  CZ  ARG D  83     -42.978  -2.686  -0.353  0.50 28.88           C  
ATOM   4543  NH1 ARG D  83     -44.264  -2.847  -0.046  0.50 28.47           N  
ATOM   4545  NH2 ARG D  83     -42.381  -3.540  -1.174  0.50 28.34           N  
ATOM   4547  N   ALA D  84     -42.396   3.725  -2.655  1.00 26.91           N  
ATOM   4548  CA  ALA D  84     -41.578   4.673  -3.430  1.00 26.23           C  
ATOM   4549  C   ALA D  84     -42.156   6.107  -3.285  1.00 26.21           C  
ATOM   4550  O   ALA D  84     -41.417   7.061  -3.086  1.00 27.40           O  
ATOM   4551  CB  ALA D  84     -41.573   4.274  -4.898  1.00 25.85           C  
ATOM   4552  N   LEU D  85     -43.470   6.236  -3.406  1.00 26.53           N  
ATOM   4553  CA  LEU D  85     -44.116   7.549  -3.282  1.00 27.33           C  
ATOM   4554  C   LEU D  85     -43.852   8.129  -1.891  1.00 26.84           C  
ATOM   4555  O   LEU D  85     -43.568   9.320  -1.744  1.00 27.06           O  
ATOM   4556  CB  LEU D  85     -45.626   7.413  -3.514  1.00 27.14           C  
ATOM   4557  CG  LEU D  85     -46.054   7.031  -4.941  1.00 27.52           C  
ATOM   4558  CD1 LEU D  85     -47.541   6.726  -4.964  1.00 32.45           C  
ATOM   4559  CD2 LEU D  85     -45.740   8.204  -5.844  1.00 29.64           C  
ATOM   4560  N   PHE D  86     -43.976   7.285  -0.872  1.00 26.66           N  
ATOM   4561  CA  PHE D  86     -43.730   7.704   0.508  1.00 26.73           C  
ATOM   4562  C   PHE D  86     -42.274   8.103   0.684  1.00 28.22           C  
ATOM   4563  O   PHE D  86     -41.995   9.186   1.212  1.00 28.66           O  
ATOM   4564  CB  PHE D  86     -44.082   6.623   1.534  1.00 26.23           C  
ATOM   4565  CG  PHE D  86     -43.910   7.085   2.942  1.00 27.49           C  
ATOM   4566  CD1 PHE D  86     -45.014   7.556   3.670  1.00 29.53           C  
ATOM   4567  CD2 PHE D  86     -42.638   7.142   3.525  1.00 28.88           C  
ATOM   4568  CE1 PHE D  86     -44.852   8.013   4.980  1.00 29.44           C  
ATOM   4569  CE2 PHE D  86     -42.477   7.604   4.824  1.00 31.36           C  
ATOM   4570  CZ  PHE D  86     -43.585   8.039   5.547  1.00 29.82           C  
ATOM   4571  N   ALA D  87     -41.358   7.232   0.246  1.00 27.44           N  
ATOM   4572  CA  ALA D  87     -39.918   7.511   0.406  1.00 28.44           C  
ATOM   4573  C   ALA D  87     -39.567   8.864  -0.256  1.00 28.27           C  
ATOM   4574  O   ALA D  87     -38.816   9.644   0.346  1.00 29.19           O  
ATOM   4575  CB  ALA D  87     -39.043   6.381  -0.128  1.00 27.22           C  
ATOM   4576  N   ALA D  88     -40.146   9.138  -1.431  1.00 28.30           N  
ATOM   4577  CA  ALA D  88     -39.873  10.363  -2.225  1.00 28.10           C  
ATOM   4578  C   ALA D  88     -40.500  11.584  -1.536  1.00 29.63           C  
ATOM   4579  O   ALA D  88     -39.835  12.603  -1.283  1.00 31.07           O  
ATOM   4580  CB  ALA D  88     -40.485  10.232  -3.603  1.00 27.28           C  
HETATM 4581  N   MSE D  89     -41.789  11.482  -1.237  1.00 28.45           N  
HETATM 4582  CA  MSE D  89     -42.516  12.643  -0.688  1.00 29.20           C  
HETATM 4583  C   MSE D  89     -42.057  12.952   0.754  1.00 27.54           C  
HETATM 4584  O   MSE D  89     -42.032  14.115   1.154  1.00 28.29           O  
HETATM 4585  CB  MSE D  89     -44.028  12.395  -0.706  1.00 29.04           C  
HETATM 4586  CG  MSE D  89     -44.669  12.375  -2.089  1.00 32.15           C  
HETATM 4587 SE   MSE D  89     -44.446  14.148  -3.050  1.00 44.73          SE  
HETATM 4588  CE  MSE D  89     -42.767  13.802  -3.849  1.00 32.08           C  
ATOM   4589  N   SER D  90     -41.659  11.937   1.530  1.00 27.21           N  
ATOM   4590  CA  SER D  90     -41.273  12.178   2.954  1.00 28.75           C  
ATOM   4591  C   SER D  90     -40.011  13.046   3.069  1.00 29.09           C  
ATOM   4592  O   SER D  90     -39.736  13.603   4.135  1.00 29.45           O  
ATOM   4593  CB  SER D  90     -41.099  10.871   3.763  1.00 28.54           C  
ATOM   4594  OG  SER D  90     -39.999  10.168   3.263  1.00 29.91           O  
ATOM   4595  N   GLN D  91     -39.276  13.164   1.965  1.00 30.09           N  
ATOM   4596  CA  GLN D  91     -38.072  13.991   1.912  1.00 30.85           C  
ATOM   4597  C   GLN D  91     -38.419  15.493   1.983  1.00 31.05           C  
ATOM   4598  O   GLN D  91     -37.597  16.293   2.403  1.00 31.00           O  
ATOM   4599  CB  GLN D  91     -37.267  13.703   0.644  1.00 31.15           C  
ATOM   4600  CG  GLN D  91     -36.628  12.268   0.622  1.00 34.60           C  
ATOM   4601  CD  GLN D  91     -36.071  11.850   1.980  1.00 37.26           C  
ATOM   4602  OE1 GLN D  91     -35.110  12.436   2.469  1.00 37.54           O  
ATOM   4603  NE2 GLN D  91     -36.691  10.836   2.605  1.00 38.33           N  
ATOM   4604  N   LEU D  92     -39.640  15.816   1.598  1.00 29.54           N  
ATOM   4605  CA  LEU D  92     -40.143  17.196   1.590  1.00 29.65           C  
ATOM   4606  C   LEU D  92     -40.812  17.586   2.933  1.00 30.19           C  
ATOM   4607  O   LEU D  92     -41.266  18.699   3.100  1.00 30.20           O  
ATOM   4608  CB  LEU D  92     -41.118  17.357   0.405  1.00 29.51           C  
ATOM   4609  CG  LEU D  92     -40.535  17.115  -1.007  1.00 30.51           C  
ATOM   4610  CD1 LEU D  92     -41.692  17.257  -2.013  1.00 33.24           C  
ATOM   4611  CD2 LEU D  92     -39.483  18.142  -1.282  1.00 31.77           C  
ATOM   4612  N   LEU D  93     -40.903  16.658   3.876  1.00 30.40           N  
ATOM   4613  CA  LEU D  93     -41.581  16.951   5.136  1.00 31.28           C  
ATOM   4614  C   LEU D  93     -40.547  17.158   6.229  1.00 32.11           C  
ATOM   4615  O   LEU D  93     -39.495  16.506   6.178  1.00 32.09           O  
ATOM   4616  CB  LEU D  93     -42.509  15.825   5.522  1.00 31.46           C  
ATOM   4617  CG  LEU D  93     -43.724  15.623   4.611  1.00 32.74           C  
ATOM   4618  CD1 LEU D  93     -44.490  14.389   5.117  1.00 33.05           C  
ATOM   4619  CD2 LEU D  93     -44.641  16.857   4.528  1.00 32.18           C  
ATOM   4620  N   PRO D  94     -40.846  18.041   7.224  1.00 32.89           N  
ATOM   4621  CA  PRO D  94     -39.861  18.305   8.295  1.00 33.47           C  
ATOM   4622  C   PRO D  94     -39.920  17.204   9.360  1.00 34.37           C  
ATOM   4623  O   PRO D  94     -40.494  17.369  10.428  1.00 35.09           O  
ATOM   4624  CB  PRO D  94     -40.256  19.678   8.825  1.00 34.03           C  
ATOM   4625  CG  PRO D  94     -41.755  19.807   8.548  1.00 33.70           C  
ATOM   4626  CD  PRO D  94     -42.071  18.859   7.366  1.00 32.94           C  
ATOM   4627  N   LEU D  95     -39.345  16.067   9.020  1.00 34.64           N  
ATOM   4628  CA  LEU D  95     -39.435  14.878   9.870  1.00 36.40           C  
ATOM   4629  C   LEU D  95     -38.194  14.702  10.739  1.00 37.55           C  
ATOM   4630  O   LEU D  95     -38.181  13.885  11.669  1.00 37.56           O  
ATOM   4631  CB  LEU D  95     -39.654  13.647   9.001  1.00 35.53           C  
ATOM   4632  CG  LEU D  95     -41.002  13.637   8.263  1.00 35.40           C  
ATOM   4633  CD1 LEU D  95     -41.154  12.368   7.489  1.00 34.58           C  
ATOM   4634  CD2 LEU D  95     -42.154  13.783   9.257  1.00 36.68           C  
ATOM   4635  N   ASP D  96     -37.143  15.444  10.395  1.00 38.79           N  
ATOM   4636  CA  ASP D  96     -35.908  15.532  11.207  1.00 40.64           C  
ATOM   4637  C   ASP D  96     -35.242  16.904  10.981  1.00 40.87           C  
ATOM   4638  O   ASP D  96     -35.705  17.695  10.152  1.00 40.17           O  
ATOM   4639  CB  ASP D  96     -34.937  14.371  10.933  1.00 40.36           C  
ATOM   4640  CG  ASP D  96     -34.424  14.335   9.494  1.00 42.22           C  
ATOM   4641  OD1 ASP D  96     -34.289  15.393   8.836  1.00 43.91           O  
ATOM   4642  OD2 ASP D  96     -34.153  13.222   9.002  1.00 45.67           O  
ATOM   4643  N   GLU D  97     -34.169  17.176  11.718  1.00 41.97           N  
ATOM   4644  CA  GLU D  97     -33.515  18.491  11.673  1.00 42.37           C  
ATOM   4645  C   GLU D  97     -33.131  18.934  10.260  1.00 41.75           C  
ATOM   4646  O   GLU D  97     -33.471  20.046   9.860  1.00 42.21           O  
ATOM   4647  CB  GLU D  97     -32.313  18.551  12.638  1.00 43.06           C  
ATOM   4648  CG  GLU D  97     -31.507  19.870  12.617  1.00 45.68           C  
ATOM   4649  CD  GLU D  97     -32.367  21.140  12.746  1.00 49.53           C  
ATOM   4650  OE1 GLU D  97     -33.319  21.162  13.565  1.00 51.41           O  
ATOM   4651  OE2 GLU D  97     -32.070  22.129  12.029  1.00 50.44           O  
ATOM   4652  N   ALA D  98     -32.472  18.055   9.501  1.00 41.37           N  
ATOM   4653  CA  ALA D  98     -31.958  18.397   8.165  1.00 41.09           C  
ATOM   4654  C   ALA D  98     -33.100  18.713   7.203  1.00 40.42           C  
ATOM   4655  O   ALA D  98     -33.049  19.688   6.455  1.00 39.97           O  
ATOM   4656  CB  ALA D  98     -31.097  17.278   7.614  1.00 40.82           C  
ATOM   4657  N   ARG D  99     -34.135  17.877   7.256  1.00 40.05           N  
ATOM   4658  CA  ARG D  99     -35.314  18.046   6.444  1.00 38.43           C  
ATOM   4659  C   ARG D  99     -36.177  19.201   6.950  1.00 37.94           C  
ATOM   4660  O   ARG D  99     -36.888  19.819   6.181  1.00 36.62           O  
ATOM   4661  CB  ARG D  99     -36.102  16.746   6.384  1.00 38.64           C  
ATOM   4662  CG  ARG D  99     -35.558  15.749   5.368  1.00 39.04           C  
ATOM   4663  CD  ARG D  99     -36.415  14.475   5.319  1.00 39.17           C  
ATOM   4664  NE  ARG D  99     -36.246  13.646   6.507  1.00 40.07           N  
ATOM   4665  CZ  ARG D  99     -36.845  12.480   6.711  1.00 41.97           C  
ATOM   4666  NH1 ARG D  99     -37.683  11.994   5.802  1.00 42.95           N  
ATOM   4667  NH2 ARG D  99     -36.617  11.809   7.841  1.00 42.69           N  
ATOM   4668  N   SER D 100     -36.094  19.509   8.233  1.00 37.41           N  
ATOM   4669  CA  SER D 100     -36.771  20.675   8.752  1.00 37.48           C  
ATOM   4670  C   SER D 100     -36.208  21.986   8.188  1.00 37.87           C  
ATOM   4671  O   SER D 100     -36.967  22.867   7.802  1.00 37.83           O  
ATOM   4672  CB  SER D 100     -36.742  20.696  10.269  1.00 37.33           C  
ATOM   4673  OG  SER D 100     -37.537  21.766  10.740  1.00 39.80           O  
ATOM   4674  N   ARG D 101     -34.886  22.125   8.130  1.00 37.52           N  
ATOM   4675  CA  ARG D 101     -34.358  23.339   7.530  1.00 37.01           C  
ATOM   4676  C   ARG D 101     -34.429  23.389   5.999  1.00 35.85           C  
ATOM   4677  O   ARG D 101     -34.611  24.457   5.450  1.00 35.34           O  
ATOM   4678  CB  ARG D 101     -33.014  23.744   8.110  1.00 38.08           C  
ATOM   4679  CG  ARG D 101     -31.902  22.823   7.803  1.00 40.64           C  
ATOM   4680  CD  ARG D 101     -30.770  23.043   8.803  1.00 45.22           C  
ATOM   4681  NE  ARG D 101     -30.336  21.736   9.288  1.00 48.90           N  
ATOM   4682  CZ  ARG D 101     -29.207  21.475   9.932  1.00 50.78           C  
ATOM   4683  NH1 ARG D 101     -28.327  22.438  10.206  1.00 51.81           N  
ATOM   4684  NH2 ARG D 101     -28.967  20.222  10.302  1.00 52.07           N  
ATOM   4685  N   GLU D 102     -34.351  22.240   5.314  1.00 34.40           N  
ATOM   4686  CA  GLU D 102     -34.667  22.212   3.881  1.00 34.34           C  
ATOM   4687  C   GLU D 102     -36.120  22.701   3.645  1.00 33.69           C  
ATOM   4688  O   GLU D 102     -36.392  23.507   2.726  1.00 32.28           O  
ATOM   4689  CB  GLU D 102     -34.490  20.815   3.298  1.00 35.13           C  
ATOM   4690  CG  GLU D 102     -33.065  20.508   2.924  1.00 38.08           C  
ATOM   4691  CD  GLU D 102     -32.806  19.017   2.739  1.00 43.99           C  
ATOM   4692  OE1 GLU D 102     -33.724  18.302   2.290  1.00 45.14           O  
ATOM   4693  OE2 GLU D 102     -31.671  18.561   3.040  1.00 45.57           O  
ATOM   4694  N   ALA D 103     -37.045  22.208   4.470  1.00 32.94           N  
ATOM   4695  CA  ALA D 103     -38.454  22.551   4.286  1.00 32.50           C  
ATOM   4696  C   ALA D 103     -38.657  24.060   4.525  1.00 31.86           C  
ATOM   4697  O   ALA D 103     -39.383  24.707   3.764  1.00 32.48           O  
ATOM   4698  CB  ALA D 103     -39.360  21.707   5.206  1.00 32.58           C  
ATOM   4699  N   HIS D 104     -38.015  24.607   5.563  1.00 31.08           N  
ATOM   4700  CA  HIS D 104     -38.024  26.046   5.844  1.00 31.31           C  
ATOM   4701  C   HIS D 104     -37.524  26.823   4.632  1.00 30.31           C  
ATOM   4702  O   HIS D 104     -38.174  27.758   4.192  1.00 28.94           O  
ATOM   4703  CB  HIS D 104     -37.174  26.381   7.089  1.00 31.76           C  
ATOM   4704  CG  HIS D 104     -37.294  27.808   7.572  1.00 35.81           C  
ATOM   4705  ND1 HIS D 104     -36.601  28.275   8.673  1.00 39.20           N  
ATOM   4706  CD2 HIS D 104     -38.019  28.863   7.119  1.00 37.23           C  
ATOM   4707  CE1 HIS D 104     -36.902  29.547   8.880  1.00 37.80           C  
ATOM   4708  NE2 HIS D 104     -37.763  29.926   7.952  1.00 35.85           N  
ATOM   4709  N   VAL D 105     -36.380  26.409   4.080  1.00 28.83           N  
ATOM   4710  CA  VAL D 105     -35.825  27.099   2.900  1.00 28.93           C  
ATOM   4711  C   VAL D 105     -36.744  26.978   1.690  1.00 27.92           C  
ATOM   4712  O   VAL D 105     -37.025  27.977   1.047  1.00 27.85           O  
ATOM   4713  CB  VAL D 105     -34.393  26.614   2.579  1.00 29.00           C  
ATOM   4714  CG1 VAL D 105     -33.900  27.172   1.218  1.00 29.56           C  
ATOM   4715  CG2 VAL D 105     -33.484  27.060   3.679  1.00 30.32           C  
HETATM 4716  N   MSE D 106     -37.260  25.780   1.416  1.00 28.07           N  
HETATM 4717  CA  MSE D 106     -38.148  25.583   0.265  1.00 29.37           C  
HETATM 4718  C   MSE D 106     -39.428  26.447   0.358  1.00 28.35           C  
HETATM 4719  O   MSE D 106     -39.884  26.995  -0.634  1.00 27.10           O  
HETATM 4720  CB  MSE D 106     -38.550  24.128   0.131  1.00 30.54           C  
HETATM 4721  CG  MSE D 106     -37.411  23.230  -0.244  1.00 39.24           C  
HETATM 4722 SE   MSE D 106     -36.762  23.725  -2.018  1.00 61.52          SE  
HETATM 4723  CE  MSE D 106     -38.327  22.957  -3.107  1.00 54.57           C  
ATOM   4724  N   ALA D 107     -40.020  26.520   1.551  1.00 27.67           N  
ATOM   4725  CA  ALA D 107     -41.186  27.381   1.728  1.00 27.49           C  
ATOM   4726  C   ALA D 107     -40.831  28.874   1.519  1.00 27.69           C  
ATOM   4727  O   ALA D 107     -41.584  29.606   0.874  1.00 27.45           O  
ATOM   4728  CB  ALA D 107     -41.809  27.164   3.111  1.00 28.22           C  
ATOM   4729  N   ALA D 108     -39.696  29.319   2.072  1.00 27.63           N  
ATOM   4730  CA  ALA D 108     -39.233  30.681   1.878  1.00 27.74           C  
ATOM   4731  C   ALA D 108     -39.045  30.965   0.380  1.00 28.13           C  
ATOM   4732  O   ALA D 108     -39.403  32.058  -0.094  1.00 27.69           O  
ATOM   4733  CB  ALA D 108     -37.905  30.942   2.648  1.00 27.92           C  
ATOM   4734  N   PHE D 109     -38.534  29.973  -0.353  1.00 28.78           N  
ATOM   4735  CA  PHE D 109     -38.302  30.117  -1.810  1.00 30.84           C  
ATOM   4736  C   PHE D 109     -39.653  30.290  -2.514  1.00 29.93           C  
ATOM   4737  O   PHE D 109     -39.804  31.181  -3.375  1.00 30.49           O  
ATOM   4738  CB  PHE D 109     -37.555  28.900  -2.381  1.00 32.33           C  
ATOM   4739  CG  PHE D 109     -37.054  29.101  -3.786  1.00 37.39           C  
ATOM   4740  CD1 PHE D 109     -35.878  29.804  -4.021  1.00 41.47           C  
ATOM   4741  CD2 PHE D 109     -37.745  28.556  -4.866  1.00 42.09           C  
ATOM   4742  CE1 PHE D 109     -35.387  29.993  -5.339  1.00 43.77           C  
ATOM   4743  CE2 PHE D 109     -37.283  28.734  -6.178  1.00 42.12           C  
ATOM   4744  CZ  PHE D 109     -36.090  29.456  -6.414  1.00 42.12           C  
ATOM   4745  N   ALA D 110     -40.625  29.476  -2.111  1.00 30.17           N  
ATOM   4746  CA  ALA D 110     -41.969  29.497  -2.704  1.00 30.89           C  
ATOM   4747  C   ALA D 110     -42.573  30.855  -2.480  1.00 30.62           C  
ATOM   4748  O   ALA D 110     -43.119  31.416  -3.426  1.00 31.28           O  
ATOM   4749  CB  ALA D 110     -42.870  28.406  -2.134  1.00 32.10           C  
ATOM   4750  N   VAL D 111     -42.413  31.419  -1.264  1.00 29.03           N  
ATOM   4751  CA  VAL D 111     -42.873  32.784  -0.969  1.00 28.46           C  
ATOM   4752  C   VAL D 111     -42.155  33.840  -1.809  1.00 28.64           C  
ATOM   4753  O   VAL D 111     -42.793  34.659  -2.446  1.00 28.30           O  
ATOM   4754  CB  VAL D 111     -42.814  33.141   0.577  1.00 27.34           C  
ATOM   4755  CG1 VAL D 111     -43.144  34.654   0.856  1.00 29.66           C  
ATOM   4756  CG2 VAL D 111     -43.753  32.228   1.372  1.00 27.85           C  
ATOM   4757  N   ARG D 112     -40.824  33.800  -1.826  1.00 29.47           N  
ATOM   4758  CA  ARG D 112     -40.027  34.675  -2.661  1.00 31.02           C  
ATOM   4759  C   ARG D 112     -40.430  34.654  -4.159  1.00 30.80           C  
ATOM   4760  O   ARG D 112     -40.421  35.695  -4.818  1.00 30.61           O  
ATOM   4761  CB  ARG D 112     -38.547  34.304  -2.465  1.00 31.58           C  
ATOM   4762  CG  ARG D 112     -37.566  35.297  -2.984  1.00 36.68           C  
ATOM   4763  CD  ARG D 112     -37.389  36.465  -2.042  1.00 42.67           C  
ATOM   4764  NE  ARG D 112     -36.619  37.507  -2.714  1.00 49.38           N  
ATOM   4765  CZ  ARG D 112     -37.146  38.378  -3.572  1.00 52.47           C  
ATOM   4766  NH1 ARG D 112     -38.449  38.333  -3.851  1.00 53.71           N  
ATOM   4767  NH2 ARG D 112     -36.370  39.293  -4.154  1.00 52.84           N  
ATOM   4768  N   ALA D 113     -40.796  33.479  -4.673  1.00 30.64           N  
ATOM   4769  CA  ALA D 113     -41.264  33.323  -6.067  1.00 31.28           C  
ATOM   4770  C   ALA D 113     -42.472  34.194  -6.424  1.00 32.51           C  
ATOM   4771  O   ALA D 113     -42.657  34.552  -7.591  1.00 32.52           O  
ATOM   4772  CB  ALA D 113     -41.588  31.876  -6.358  1.00 32.30           C  
ATOM   4773  N   ALA D 114     -43.296  34.526  -5.432  1.00 32.64           N  
ATOM   4774  CA  ALA D 114     -44.445  35.403  -5.671  1.00 33.39           C  
ATOM   4775  C   ALA D 114     -44.037  36.786  -6.164  1.00 34.49           C  
ATOM   4776  O   ALA D 114     -44.792  37.450  -6.875  1.00 35.24           O  
ATOM   4777  CB  ALA D 114     -45.277  35.525  -4.403  1.00 33.13           C  
ATOM   4778  N   THR D 115     -42.841  37.222  -5.775  1.00 35.54           N  
ATOM   4779  CA  THR D 115     -42.329  38.554  -6.127  1.00 36.46           C  
ATOM   4780  C   THR D 115     -41.101  38.552  -7.064  1.00 36.45           C  
ATOM   4781  O   THR D 115     -40.625  39.614  -7.482  1.00 36.17           O  
ATOM   4782  CB  THR D 115     -42.045  39.397  -4.846  1.00 37.01           C  
ATOM   4783  OG1 THR D 115     -41.211  38.659  -3.941  1.00 37.31           O  
ATOM   4784  CG2 THR D 115     -43.343  39.717  -4.137  1.00 36.66           C  
ATOM   4785  N   SER D 116     -40.621  37.368  -7.431  1.00 36.22           N  
ATOM   4786  CA  SER D 116     -39.412  37.276  -8.224  1.00 36.89           C  
ATOM   4787  C   SER D 116     -39.585  36.309  -9.392  1.00 36.94           C  
ATOM   4788  O   SER D 116     -39.488  35.099  -9.205  1.00 36.45           O  
ATOM   4789  CB  SER D 116     -38.213  36.907  -7.331  1.00 37.05           C  
ATOM   4790  OG  SER D 116     -37.140  36.386  -8.090  1.00 38.39           O  
ATOM   4791  N   PRO D 117     -39.815  36.851 -10.610  1.00 37.21           N  
ATOM   4792  CA  PRO D 117     -40.081  36.078 -11.835  1.00 37.23           C  
ATOM   4793  C   PRO D 117     -39.047  35.004 -12.144  1.00 37.44           C  
ATOM   4794  O   PRO D 117     -39.407  33.947 -12.651  1.00 37.82           O  
ATOM   4795  CB  PRO D 117     -40.047  37.143 -12.940  1.00 37.49           C  
ATOM   4796  CG  PRO D 117     -40.447  38.406 -12.246  1.00 37.55           C  
ATOM   4797  CD  PRO D 117     -39.843  38.305 -10.870  1.00 37.86           C  
ATOM   4798  N   SER D 118     -37.782  35.276 -11.859  1.00 37.66           N  
ATOM   4799  CA  SER D 118     -36.709  34.333 -12.146  1.00 38.79           C  
ATOM   4800  C   SER D 118     -36.779  33.129 -11.193  1.00 38.35           C  
ATOM   4801  O   SER D 118     -36.582  31.982 -11.621  1.00 38.50           O  
ATOM   4802  CB  SER D 118     -35.336  35.039 -12.088  1.00 38.98           C  
ATOM   4803  OG  SER D 118     -35.114  35.581 -10.783  1.00 41.91           O  
ATOM   4804  N   LEU D 119     -37.092  33.393  -9.919  1.00 37.81           N  
ATOM   4805  CA  LEU D 119     -37.268  32.345  -8.916  1.00 37.67           C  
ATOM   4806  C   LEU D 119     -38.527  31.529  -9.188  1.00 35.91           C  
ATOM   4807  O   LEU D 119     -38.525  30.300  -9.047  1.00 34.66           O  
ATOM   4808  CB  LEU D 119     -37.321  32.935  -7.501  1.00 37.86           C  
ATOM   4809  CG  LEU D 119     -35.986  33.129  -6.770  1.00 40.36           C  
ATOM   4810  CD1 LEU D 119     -35.114  34.241  -7.360  1.00 40.94           C  
ATOM   4811  CD2 LEU D 119     -36.248  33.356  -5.276  1.00 39.05           C  
ATOM   4812  N   ALA D 120     -39.587  32.227  -9.579  1.00 34.83           N  
ATOM   4813  CA  ALA D 120     -40.831  31.584 -10.000  1.00 34.50           C  
ATOM   4814  C   ALA D 120     -40.611  30.590 -11.146  1.00 34.89           C  
ATOM   4815  O   ALA D 120     -41.158  29.484 -11.101  1.00 35.12           O  
ATOM   4816  CB  ALA D 120     -41.878  32.626 -10.372  1.00 34.77           C  
ATOM   4817  N   GLU D 121     -39.821  30.966 -12.165  1.00 35.29           N  
ATOM   4818  CA  GLU D 121     -39.496  30.024 -13.240  1.00 35.59           C  
ATOM   4819  C   GLU D 121     -38.769  28.771 -12.730  1.00 35.27           C  
ATOM   4820  O   GLU D 121     -39.108  27.656 -13.137  1.00 34.93           O  
ATOM   4821  CB  GLU D 121     -38.694  30.682 -14.370  1.00 37.15           C  
ATOM   4822  CG  GLU D 121     -38.095  29.664 -15.384  1.00 41.01           C  
ATOM   4823  CD  GLU D 121     -39.157  28.847 -16.157  1.00 47.76           C  
ATOM   4824  OE1 GLU D 121     -40.344  29.274 -16.191  1.00 50.16           O  
ATOM   4825  OE2 GLU D 121     -38.789  27.794 -16.758  1.00 50.30           O  
ATOM   4826  N   ILE D 122     -37.768  28.962 -11.864  1.00 34.43           N  
ATOM   4827  CA  ILE D 122     -37.005  27.862 -11.265  1.00 34.59           C  
ATOM   4828  C   ILE D 122     -37.952  26.960 -10.473  1.00 34.15           C  
ATOM   4829  O   ILE D 122     -37.923  25.739 -10.615  1.00 33.22           O  
ATOM   4830  CB  ILE D 122     -35.840  28.387 -10.344  1.00 34.63           C  
ATOM   4831  CG1 ILE D 122     -34.691  28.958 -11.192  1.00 35.81           C  
ATOM   4832  CG2 ILE D 122     -35.292  27.271  -9.460  1.00 34.40           C  
ATOM   4833  CD1 ILE D 122     -33.701  29.824 -10.422  1.00 35.82           C  
ATOM   4834  N   ARG D 123     -38.819  27.585  -9.677  1.00 33.96           N  
ATOM   4835  CA  ARG D 123     -39.818  26.841  -8.919  1.00 34.21           C  
ATOM   4836  C   ARG D 123     -40.797  26.075  -9.825  1.00 33.71           C  
ATOM   4837  O   ARG D 123     -41.012  24.879  -9.617  1.00 33.37           O  
ATOM   4838  CB  ARG D 123     -40.547  27.704  -7.911  1.00 34.45           C  
ATOM   4839  CG  ARG D 123     -41.184  26.779  -6.860  1.00 36.60           C  
ATOM   4840  CD  ARG D 123     -41.533  27.488  -5.575  1.00 39.65           C  
ATOM   4841  NE  ARG D 123     -42.761  26.943  -4.979  1.00 43.32           N  
ATOM   4842  CZ  ARG D 123     -42.877  25.741  -4.435  1.00 45.28           C  
ATOM   4843  NH1 ARG D 123     -41.838  24.907  -4.411  1.00 49.45           N  
ATOM   4844  NH2 ARG D 123     -44.031  25.359  -3.914  1.00 45.17           N  
ATOM   4845  N   ARG D 124     -41.306  26.751 -10.859  1.00 33.63           N  
ATOM   4846  CA  ARG D 124     -42.248  26.133 -11.798  1.00 34.63           C  
ATOM   4847  C   ARG D 124     -41.636  24.857 -12.404  1.00 33.25           C  
ATOM   4848  O   ARG D 124     -42.276  23.799 -12.436  1.00 32.15           O  
ATOM   4849  CB  ARG D 124     -42.674  27.116 -12.898  1.00 34.60           C  
ATOM   4850  CG  ARG D 124     -43.714  26.520 -13.849  1.00 37.61           C  
ATOM   4851  CD  ARG D 124     -44.032  27.382 -15.082  1.00 38.46           C  
ATOM   4852  NE  ARG D 124     -42.904  27.545 -16.017  1.00 47.59           N  
ATOM   4853  CZ  ARG D 124     -42.365  26.580 -16.768  1.00 49.70           C  
ATOM   4854  NH1 ARG D 124     -42.815  25.323 -16.712  1.00 51.78           N  
ATOM   4855  NH2 ARG D 124     -41.348  26.878 -17.576  1.00 52.84           N  
ATOM   4856  N   LYS D 125     -40.385  24.956 -12.839  1.00 32.89           N  
ATOM   4857  CA  LYS D 125     -39.706  23.821 -13.444  1.00 34.32           C  
ATOM   4858  C   LYS D 125     -39.545  22.674 -12.454  1.00 33.37           C  
ATOM   4859  O   LYS D 125     -39.780  21.520 -12.794  1.00 33.81           O  
ATOM   4860  CB  LYS D 125     -38.348  24.244 -14.023  1.00 34.74           C  
ATOM   4861  CG  LYS D 125     -38.515  25.050 -15.314  1.00 39.91           C  
ATOM   4862  CD  LYS D 125     -39.574  24.419 -16.249  1.00 44.93           C  
ATOM   4863  CE  LYS D 125     -39.111  23.074 -16.867  1.00 48.14           C  
ATOM   4864  NZ  LYS D 125     -39.969  22.632 -18.016  1.00 45.05           N  
ATOM   4865  N   THR D 126     -39.149  23.027 -11.244  1.00 32.84           N  
ATOM   4866  CA  THR D 126     -38.980  22.069 -10.141  1.00 34.67           C  
ATOM   4867  C   THR D 126     -40.285  21.315  -9.914  1.00 33.14           C  
ATOM   4868  O   THR D 126     -40.317  20.086  -9.983  1.00 33.83           O  
ATOM   4869  CB  THR D 126     -38.586  22.844  -8.875  1.00 34.43           C  
ATOM   4870  OG1 THR D 126     -37.377  23.576  -9.151  1.00 37.74           O  
ATOM   4871  CG2 THR D 126     -38.424  21.910  -7.637  1.00 38.46           C  
ATOM   4872  N   LEU D 127     -41.346  22.066  -9.682  1.00 33.12           N  
ATOM   4873  CA  LEU D 127     -42.682  21.501  -9.446  1.00 33.02           C  
ATOM   4874  C   LEU D 127     -43.099  20.577 -10.609  1.00 31.39           C  
ATOM   4875  O   LEU D 127     -43.535  19.439 -10.386  1.00 31.16           O  
ATOM   4876  CB  LEU D 127     -43.697  22.635  -9.280  1.00 34.16           C  
ATOM   4877  CG  LEU D 127     -43.673  23.468  -7.990  1.00 37.28           C  
ATOM   4878  CD1 LEU D 127     -44.831  24.483  -7.987  1.00 39.89           C  
ATOM   4879  CD2 LEU D 127     -43.720  22.636  -6.744  1.00 42.68           C  
ATOM   4880  N   PHE D 128     -42.946  21.066 -11.842  1.00 29.92           N  
ATOM   4881  CA  PHE D 128     -43.423  20.347 -12.989  1.00 28.22           C  
ATOM   4882  C   PHE D 128     -42.623  19.060 -13.195  1.00 28.19           C  
ATOM   4883  O   PHE D 128     -43.200  18.033 -13.568  1.00 27.62           O  
ATOM   4884  CB  PHE D 128     -43.416  21.204 -14.243  1.00 29.90           C  
ATOM   4885  CG  PHE D 128     -44.340  20.695 -15.303  1.00 32.49           C  
ATOM   4886  CD1 PHE D 128     -45.721  20.880 -15.167  1.00 36.05           C  
ATOM   4887  CD2 PHE D 128     -43.854  20.012 -16.407  1.00 32.80           C  
ATOM   4888  CE1 PHE D 128     -46.607  20.410 -16.136  1.00 37.00           C  
ATOM   4889  CE2 PHE D 128     -44.720  19.541 -17.402  1.00 33.55           C  
ATOM   4890  CZ  PHE D 128     -46.103  19.733 -17.266  1.00 35.55           C  
ATOM   4891  N   THR D 129     -41.314  19.110 -12.947  1.00 26.96           N  
ATOM   4892  CA  THR D 129     -40.490  17.898 -13.077  1.00 26.93           C  
ATOM   4893  C   THR D 129     -40.851  16.827 -12.053  1.00 26.61           C  
ATOM   4894  O   THR D 129     -40.956  15.634 -12.381  1.00 27.01           O  
ATOM   4895  CB  THR D 129     -38.988  18.253 -13.013  1.00 27.76           C  
ATOM   4896  OG1 THR D 129     -38.705  19.157 -14.095  1.00 27.96           O  
ATOM   4897  CG2 THR D 129     -38.124  16.989 -13.168  1.00 29.50           C  
ATOM   4898  N   ILE D 130     -41.048  17.240 -10.806  1.00 26.71           N  
ATOM   4899  CA  ILE D 130     -41.482  16.282  -9.771  1.00 27.55           C  
ATOM   4900  C   ILE D 130     -42.857  15.690 -10.141  1.00 26.68           C  
ATOM   4901  O   ILE D 130     -43.056  14.472 -10.044  1.00 27.10           O  
ATOM   4902  CB  ILE D 130     -41.558  16.975  -8.379  1.00 28.49           C  
ATOM   4903  CG1 ILE D 130     -40.150  17.472  -7.981  1.00 28.99           C  
ATOM   4904  CG2 ILE D 130     -42.234  16.015  -7.315  1.00 29.84           C  
ATOM   4905  CD1 ILE D 130     -40.129  18.363  -6.661  1.00 29.40           C  
ATOM   4906  N   ARG D 131     -43.770  16.539 -10.594  1.00 26.97           N  
ATOM   4907  CA  ARG D 131     -45.120  16.085 -10.995  1.00 28.50           C  
ATOM   4908  C   ARG D 131     -45.066  15.083 -12.164  1.00 28.23           C  
ATOM   4909  O   ARG D 131     -45.823  14.124 -12.188  1.00 28.89           O  
ATOM   4910  CB  ARG D 131     -46.010  17.288 -11.344  1.00 28.46           C  
ATOM   4911  CG  ARG D 131     -46.599  17.981 -10.122  1.00 31.07           C  
ATOM   4912  CD  ARG D 131     -47.326  19.290 -10.452  1.00 30.36           C  
ATOM   4913  NE  ARG D 131     -48.288  19.123 -11.538  1.00 35.17           N  
ATOM   4914  CZ  ARG D 131     -48.944  20.134 -12.106  1.00 36.42           C  
ATOM   4915  NH1 ARG D 131     -48.768  21.391 -11.666  1.00 34.75           N  
ATOM   4916  NH2 ARG D 131     -49.757  19.888 -13.118  1.00 36.40           N  
ATOM   4917  N   THR D 132     -44.166  15.315 -13.121  1.00 26.86           N  
ATOM   4918  CA  THR D 132     -44.025  14.433 -14.277  1.00 26.93           C  
ATOM   4919  C   THR D 132     -43.615  13.043 -13.760  1.00 27.16           C  
ATOM   4920  O   THR D 132     -44.228  12.059 -14.130  1.00 28.26           O  
ATOM   4921  CB  THR D 132     -42.997  15.006 -15.309  1.00 27.03           C  
ATOM   4922  OG1 THR D 132     -43.479  16.256 -15.816  1.00 27.40           O  
ATOM   4923  CG2 THR D 132     -42.794  14.021 -16.498  1.00 25.72           C  
ATOM   4924  N   GLY D 133     -42.620  12.984 -12.866  1.00 27.99           N  
ATOM   4925  CA  GLY D 133     -42.168  11.713 -12.231  1.00 27.63           C  
ATOM   4926  C   GLY D 133     -43.292  11.034 -11.459  1.00 27.83           C  
ATOM   4927  O   GLY D 133     -43.530   9.819 -11.597  1.00 28.16           O  
ATOM   4928  N   LEU D 134     -43.988  11.805 -10.622  1.00 27.74           N  
ATOM   4929  CA  LEU D 134     -45.159  11.284  -9.877  1.00 27.76           C  
ATOM   4930  C   LEU D 134     -46.237  10.730 -10.790  1.00 28.66           C  
ATOM   4931  O   LEU D 134     -46.688   9.595 -10.607  1.00 29.42           O  
ATOM   4932  CB  LEU D 134     -45.761  12.397  -8.959  1.00 27.03           C  
ATOM   4933  CG  LEU D 134     -44.867  12.791  -7.765  1.00 26.52           C  
ATOM   4934  CD1 LEU D 134     -45.474  14.036  -7.085  1.00 26.48           C  
ATOM   4935  CD2 LEU D 134     -44.699  11.655  -6.745  1.00 30.86           C  
ATOM   4936  N   SER D 135     -46.628  11.512 -11.792  1.00 29.00           N  
ATOM   4937  CA  SER D 135     -47.709  11.099 -12.662  1.00 29.95           C  
ATOM   4938  C   SER D 135     -47.311   9.849 -13.492  1.00 29.77           C  
ATOM   4939  O   SER D 135     -48.161   8.976 -13.715  1.00 30.87           O  
ATOM   4940  CB  SER D 135     -48.272  12.286 -13.480  1.00 30.63           C  
ATOM   4941  OG  SER D 135     -47.299  12.816 -14.351  1.00 31.19           O  
ATOM   4942  N   ALA D 136     -46.036   9.699 -13.847  1.00 29.10           N  
ATOM   4943  CA  ALA D 136     -45.628   8.510 -14.598  1.00 30.66           C  
ATOM   4944  C   ALA D 136     -45.827   7.244 -13.755  1.00 30.41           C  
ATOM   4945  O   ALA D 136     -46.231   6.216 -14.278  1.00 30.35           O  
ATOM   4946  CB  ALA D 136     -44.214   8.636 -15.046  1.00 29.91           C  
ATOM   4947  N   VAL D 137     -45.581   7.338 -12.449  1.00 30.28           N  
ATOM   4948  CA  VAL D 137     -45.735   6.197 -11.569  1.00 29.90           C  
ATOM   4949  C   VAL D 137     -47.212   5.839 -11.498  1.00 30.44           C  
ATOM   4950  O   VAL D 137     -47.608   4.665 -11.670  1.00 29.87           O  
ATOM   4951  CB  VAL D 137     -45.155   6.467 -10.157  1.00 30.34           C  
ATOM   4952  CG1 VAL D 137     -45.601   5.353  -9.175  1.00 30.00           C  
ATOM   4953  CG2 VAL D 137     -43.621   6.598 -10.209  1.00 30.32           C  
ATOM   4954  N   LEU D 138     -48.025   6.869 -11.285  1.00 29.21           N  
ATOM   4955  CA  LEU D 138     -49.475   6.694 -11.180  1.00 30.68           C  
ATOM   4956  C   LEU D 138     -50.141   6.192 -12.472  1.00 30.57           C  
ATOM   4957  O   LEU D 138     -51.056   5.361 -12.421  1.00 30.36           O  
ATOM   4958  CB  LEU D 138     -50.107   8.001 -10.704  1.00 31.04           C  
ATOM   4959  CG  LEU D 138     -49.763   8.417  -9.275  1.00 30.49           C  
ATOM   4960  CD1 LEU D 138     -50.650   9.637  -8.927  1.00 29.45           C  
ATOM   4961  CD2 LEU D 138     -49.975   7.314  -8.218  1.00 31.59           C  
ATOM   4962  N   ILE D 139     -49.677   6.688 -13.617  1.00 30.38           N  
ATOM   4963  CA  ILE D 139     -50.150   6.216 -14.926  1.00 30.67           C  
ATOM   4964  C   ILE D 139     -49.815   4.716 -15.129  1.00 30.86           C  
ATOM   4965  O   ILE D 139     -50.658   3.944 -15.615  1.00 30.24           O  
ATOM   4966  CB  ILE D 139     -49.579   7.090 -16.111  1.00 30.53           C  
ATOM   4967  CG1 ILE D 139     -50.230   8.489 -16.136  1.00 31.23           C  
ATOM   4968  CG2 ILE D 139     -49.786   6.388 -17.461  1.00 31.14           C  
ATOM   4969  CD1 ILE D 139     -49.443   9.592 -16.871  1.00 30.53           C  
ATOM   4970  N   GLY D 140     -48.604   4.318 -14.727  1.00 30.52           N  
ATOM   4971  CA  GLY D 140     -48.096   2.967 -14.929  1.00 31.91           C  
ATOM   4972  C   GLY D 140     -48.920   1.929 -14.199  1.00 32.21           C  
ATOM   4973  O   GLY D 140     -48.936   0.762 -14.580  1.00 32.68           O  
ATOM   4974  N   ILE D 141     -49.627   2.345 -13.156  1.00 32.62           N  
ATOM   4975  CA  ILE D 141     -50.476   1.417 -12.421  1.00 32.78           C  
ATOM   4976  C   ILE D 141     -51.969   1.653 -12.686  1.00 33.16           C  
ATOM   4977  O   ILE D 141     -52.820   1.056 -12.030  1.00 34.32           O  
ATOM   4978  CB  ILE D 141     -50.119   1.406 -10.913  1.00 33.03           C  
ATOM   4979  CG1 ILE D 141     -50.246   2.822 -10.322  1.00 31.46           C  
ATOM   4980  CG2 ILE D 141     -48.664   0.876 -10.737  1.00 32.76           C  
ATOM   4981  CD1 ILE D 141     -50.047   2.864  -8.770  1.00 33.77           C  
ATOM   4982  N   GLY D 142     -52.289   2.514 -13.647  1.00 33.39           N  
ATOM   4983  CA  GLY D 142     -53.692   2.716 -14.055  1.00 33.12           C  
ATOM   4984  C   GLY D 142     -54.475   3.482 -13.002  1.00 33.35           C  
ATOM   4985  O   GLY D 142     -55.661   3.202 -12.724  1.00 32.74           O  
ATOM   4986  N   THR D 143     -53.817   4.474 -12.419  1.00 32.78           N  
ATOM   4987  CA  THR D 143     -54.474   5.326 -11.450  1.00 31.99           C  
ATOM   4988  C   THR D 143     -55.500   6.234 -12.119  1.00 31.90           C  
ATOM   4989  O   THR D 143     -55.184   6.901 -13.118  1.00 31.59           O  
ATOM   4990  CB  THR D 143     -53.451   6.174 -10.661  1.00 31.99           C  
ATOM   4991  OG1 THR D 143     -52.466   5.299 -10.096  1.00 31.18           O  
ATOM   4992  CG2 THR D 143     -54.158   6.947  -9.531  1.00 31.72           C  
ATOM   4993  N   PRO D 144     -56.741   6.253 -11.593  1.00 32.69           N  
ATOM   4994  CA  PRO D 144     -57.718   7.208 -12.101  1.00 32.46           C  
ATOM   4995  C   PRO D 144     -57.227   8.626 -11.864  1.00 31.81           C  
ATOM   4996  O   PRO D 144     -56.592   8.869 -10.820  1.00 31.02           O  
ATOM   4997  CB  PRO D 144     -58.942   6.947 -11.209  1.00 32.96           C  
ATOM   4998  CG  PRO D 144     -58.780   5.574 -10.761  1.00 33.67           C  
ATOM   4999  CD  PRO D 144     -57.331   5.404 -10.531  1.00 32.79           C  
ATOM   5000  N   GLU D 145     -57.508   9.548 -12.803  1.00 31.13           N  
ATOM   5001  CA  GLU D 145     -57.158  10.990 -12.696  0.50 31.36           C  
ATOM   5003  C   GLU D 145     -55.694  11.213 -12.321  1.00 30.58           C  
ATOM   5004  O   GLU D 145     -55.342  12.092 -11.540  1.00 30.94           O  
ATOM   5005  CB  GLU D 145     -58.087  11.735 -11.726  0.50 31.58           C  
ATOM   5007  CG  GLU D 145     -59.501  11.997 -12.241  0.50 32.80           C  
ATOM   5009  CD  GLU D 145     -59.639  13.274 -13.066  0.50 34.99           C  
ATOM   5011  OE1 GLU D 145     -58.644  14.017 -13.242  0.50 34.24           O  
ATOM   5013  OE2 GLU D 145     -60.771  13.538 -13.542  0.50 37.39           O  
ATOM   5015  N   ALA D 146     -54.828  10.421 -12.954  1.00 30.42           N  
ATOM   5016  CA  ALA D 146     -53.404  10.317 -12.596  1.00 29.21           C  
ATOM   5017  C   ALA D 146     -52.675  11.658 -12.449  1.00 29.28           C  
ATOM   5018  O   ALA D 146     -51.966  11.874 -11.471  1.00 29.87           O  
ATOM   5019  CB  ALA D 146     -52.670   9.434 -13.615  1.00 30.17           C  
ATOM   5020  N   GLU D 147     -52.797  12.518 -13.460  1.00 28.24           N  
ATOM   5021  CA  GLU D 147     -52.077  13.815 -13.472  1.00 29.48           C  
ATOM   5022  C   GLU D 147     -52.529  14.768 -12.380  1.00 28.57           C  
ATOM   5023  O   GLU D 147     -51.705  15.347 -11.655  1.00 27.22           O  
ATOM   5024  CB  GLU D 147     -52.177  14.480 -14.837  1.00 31.13           C  
ATOM   5025  CG  GLU D 147     -51.263  13.759 -15.840  1.00 33.56           C  
ATOM   5026  CD  GLU D 147     -51.387  14.278 -17.262  1.00 39.51           C  
ATOM   5027  OE1 GLU D 147     -52.513  14.667 -17.680  1.00 43.51           O  
ATOM   5028  OE2 GLU D 147     -50.356  14.294 -17.968  1.00 39.34           O  
ATOM   5029  N   THR D 148     -53.839  14.873 -12.219  1.00 28.70           N  
ATOM   5030  CA  THR D 148     -54.364  15.692 -11.124  1.00 28.16           C  
ATOM   5031  C   THR D 148     -54.011  15.131  -9.751  1.00 27.70           C  
ATOM   5032  O   THR D 148     -53.609  15.875  -8.861  1.00 27.54           O  
ATOM   5033  CB  THR D 148     -55.863  15.942 -11.256  1.00 28.28           C  
ATOM   5034  OG1 THR D 148     -56.122  16.566 -12.523  1.00 28.76           O  
ATOM   5035  CG2 THR D 148     -56.320  16.887 -10.107  1.00 29.09           C  
ATOM   5036  N   ARG D 149     -54.130  13.814  -9.568  1.00 27.41           N  
ATOM   5037  CA  ARG D 149     -53.724  13.214  -8.290  1.00 26.74           C  
ATOM   5038  C   ARG D 149     -52.242  13.436  -8.010  1.00 26.64           C  
ATOM   5039  O   ARG D 149     -51.874  13.723  -6.864  1.00 26.94           O  
ATOM   5040  CB  ARG D 149     -54.109  11.733  -8.230  1.00 25.21           C  
ATOM   5041  CG  ARG D 149     -55.629  11.538  -8.161  1.00 24.83           C  
ATOM   5042  CD  ARG D 149     -55.963  10.073  -7.884  1.00 30.20           C  
ATOM   5043  NE  ARG D 149     -57.404   9.818  -7.919  1.00 29.73           N  
ATOM   5044  CZ  ARG D 149     -57.965   8.648  -7.614  1.00 31.23           C  
ATOM   5045  NH1 ARG D 149     -57.205   7.630  -7.255  1.00 34.39           N  
ATOM   5046  NH2 ARG D 149     -59.284   8.492  -7.696  1.00 32.65           N  
ATOM   5047  N   ALA D 150     -51.389  13.344  -9.048  1.00 27.00           N  
ATOM   5048  CA  ALA D 150     -49.959  13.671  -8.891  1.00 27.96           C  
ATOM   5049  C   ALA D 150     -49.746  15.116  -8.367  1.00 28.03           C  
ATOM   5050  O   ALA D 150     -48.986  15.352  -7.402  1.00 26.93           O  
ATOM   5051  CB  ALA D 150     -49.200  13.455 -10.209  1.00 27.64           C  
ATOM   5052  N   ALA D 151     -50.414  16.062  -9.011  1.00 28.24           N  
ATOM   5053  CA  ALA D 151     -50.344  17.458  -8.585  1.00 29.43           C  
ATOM   5054  C   ALA D 151     -50.827  17.613  -7.126  1.00 28.93           C  
ATOM   5055  O   ALA D 151     -50.237  18.379  -6.323  1.00 29.28           O  
ATOM   5056  CB  ALA D 151     -51.173  18.330  -9.509  1.00 29.76           C  
ATOM   5057  N   LEU D 152     -51.908  16.913  -6.792  1.00 28.31           N  
ATOM   5058  CA  LEU D 152     -52.443  16.924  -5.401  1.00 27.09           C  
ATOM   5059  C   LEU D 152     -51.516  16.371  -4.392  1.00 27.27           C  
ATOM   5060  O   LEU D 152     -51.398  16.911  -3.293  1.00 27.43           O  
ATOM   5061  CB  LEU D 152     -53.755  16.168  -5.288  1.00 26.45           C  
ATOM   5062  CG  LEU D 152     -54.906  16.958  -5.855  1.00 26.71           C  
ATOM   5063  CD1 LEU D 152     -56.190  16.082  -5.837  1.00 30.18           C  
ATOM   5064  CD2 LEU D 152     -55.155  18.257  -5.024  1.00 24.34           C  
ATOM   5065  N   LEU D 153     -50.848  15.270  -4.739  1.00 27.38           N  
ATOM   5066  CA  LEU D 153     -49.912  14.700  -3.798  1.00 27.78           C  
ATOM   5067  C   LEU D 153     -48.818  15.710  -3.439  1.00 27.67           C  
ATOM   5068  O   LEU D 153     -48.459  15.872  -2.277  1.00 28.04           O  
ATOM   5069  CB  LEU D 153     -49.343  13.370  -4.290  1.00 27.89           C  
ATOM   5070  CG  LEU D 153     -48.376  12.645  -3.342  1.00 27.80           C  
ATOM   5071  CD1 LEU D 153     -48.887  12.449  -1.887  1.00 28.38           C  
ATOM   5072  CD2 LEU D 153     -47.851  11.303  -3.998  1.00 28.48           C  
ATOM   5073  N   LEU D 154     -48.239  16.325  -4.450  1.00 28.30           N  
ATOM   5074  CA  LEU D 154     -47.125  17.249  -4.225  1.00 29.63           C  
ATOM   5075  C   LEU D 154     -47.646  18.468  -3.434  1.00 30.02           C  
ATOM   5076  O   LEU D 154     -47.000  18.939  -2.540  1.00 29.63           O  
ATOM   5077  CB  LEU D 154     -46.549  17.687  -5.575  1.00 30.20           C  
ATOM   5078  CG  LEU D 154     -45.313  18.602  -5.536  1.00 32.68           C  
ATOM   5079  CD1 LEU D 154     -44.326  18.151  -4.502  1.00 31.53           C  
ATOM   5080  CD2 LEU D 154     -44.641  18.607  -6.967  1.00 34.23           C  
ATOM   5081  N   ALA D 155     -48.821  18.960  -3.804  1.00 31.31           N  
ATOM   5082  CA  ALA D 155     -49.442  20.108  -3.119  1.00 32.13           C  
ATOM   5083  C   ALA D 155     -49.700  19.831  -1.667  1.00 32.93           C  
ATOM   5084  O   ALA D 155     -49.454  20.676  -0.781  1.00 33.12           O  
ATOM   5085  CB  ALA D 155     -50.728  20.531  -3.860  1.00 31.72           C  
ATOM   5086  N   THR D 156     -50.196  18.624  -1.389  1.00 33.68           N  
ATOM   5087  CA  THR D 156     -50.571  18.267  -0.048  1.00 34.64           C  
ATOM   5088  C   THR D 156     -49.306  18.196   0.796  1.00 33.04           C  
ATOM   5089  O   THR D 156     -49.262  18.673   1.956  1.00 30.98           O  
ATOM   5090  CB  THR D 156     -51.478  16.953  -0.015  1.00 34.96           C  
ATOM   5091  OG1 THR D 156     -52.529  17.142  -0.980  1.00 39.52           O  
ATOM   5092  CG2 THR D 156     -52.115  16.813   1.351  1.00 37.10           C  
ATOM   5093  N   VAL D 157     -48.231  17.687   0.202  1.00 32.92           N  
ATOM   5094  CA  VAL D 157     -46.962  17.654   0.908  1.00 31.08           C  
ATOM   5095  C   VAL D 157     -46.328  19.069   1.159  1.00 30.90           C  
ATOM   5096  O   VAL D 157     -45.791  19.343   2.233  1.00 29.89           O  
ATOM   5097  CB  VAL D 157     -46.002  16.674   0.185  1.00 33.83           C  
ATOM   5098  CG1 VAL D 157     -44.669  16.730   0.809  1.00 32.90           C  
ATOM   5099  CG2 VAL D 157     -46.616  15.219   0.275  1.00 32.01           C  
ATOM   5100  N   ASP D 158     -46.332  19.907   0.124  1.00 29.84           N  
ATOM   5101  CA  ASP D 158     -45.907  21.314   0.230  1.00 29.54           C  
ATOM   5102  C   ASP D 158     -46.719  22.010   1.348  1.00 29.00           C  
ATOM   5103  O   ASP D 158     -46.188  22.786   2.153  1.00 28.68           O  
ATOM   5104  CB  ASP D 158     -46.121  22.015  -1.125  1.00 30.54           C  
ATOM   5105  CG  ASP D 158     -45.094  21.571  -2.191  1.00 34.49           C  
ATOM   5106  OD1 ASP D 158     -44.140  20.834  -1.802  1.00 37.88           O  
ATOM   5107  OD2 ASP D 158     -45.255  21.929  -3.408  1.00 35.39           O  
ATOM   5108  N   GLY D 159     -48.017  21.743   1.368  1.00 27.94           N  
ATOM   5109  CA  GLY D 159     -48.886  22.364   2.409  1.00 28.39           C  
ATOM   5110  C   GLY D 159     -48.650  21.835   3.809  1.00 28.63           C  
ATOM   5111  O   GLY D 159     -48.599  22.599   4.763  1.00 28.07           O  
ATOM   5112  N   LEU D 160     -48.447  20.518   3.937  1.00 27.62           N  
ATOM   5113  CA  LEU D 160     -48.183  19.934   5.244  1.00 27.89           C  
ATOM   5114  C   LEU D 160     -46.894  20.487   5.795  1.00 28.03           C  
ATOM   5115  O   LEU D 160     -46.784  20.747   6.982  1.00 28.15           O  
ATOM   5116  CB  LEU D 160     -48.065  18.400   5.144  1.00 28.93           C  
ATOM   5117  CG  LEU D 160     -49.347  17.613   5.181  1.00 28.91           C  
ATOM   5118  CD1 LEU D 160     -49.053  16.099   4.807  1.00 30.95           C  
ATOM   5119  CD2 LEU D 160     -50.068  17.739   6.558  1.00 29.55           C  
ATOM   5120  N   ALA D 161     -45.899  20.673   4.908  1.00 27.22           N  
ATOM   5121  CA  ALA D 161     -44.606  21.167   5.345  1.00 26.61           C  
ATOM   5122  C   ALA D 161     -44.776  22.620   5.770  1.00 27.01           C  
ATOM   5123  O   ALA D 161     -44.273  23.012   6.820  1.00 27.66           O  
ATOM   5124  CB  ALA D 161     -43.524  21.044   4.213  1.00 27.32           C  
ATOM   5125  N   LEU D 162     -45.497  23.394   4.971  1.00 26.60           N  
ATOM   5126  CA  LEU D 162     -45.734  24.828   5.322  1.00 28.09           C  
ATOM   5127  C   LEU D 162     -46.460  24.936   6.689  1.00 29.26           C  
ATOM   5128  O   LEU D 162     -46.062  25.719   7.588  1.00 30.45           O  
ATOM   5129  CB  LEU D 162     -46.533  25.525   4.217  1.00 25.92           C  
ATOM   5130  CG  LEU D 162     -46.732  27.021   4.511  1.00 27.95           C  
ATOM   5131  CD1 LEU D 162     -45.432  27.766   4.287  1.00 26.40           C  
ATOM   5132  CD2 LEU D 162     -47.762  27.489   3.537  1.00 29.83           C  
ATOM   5133  N   ASP D 163     -47.528  24.160   6.839  1.00 30.93           N  
ATOM   5134  CA  ASP D 163     -48.387  24.213   8.051  1.00 31.95           C  
ATOM   5135  C   ASP D 163     -47.569  23.765   9.270  1.00 33.04           C  
ATOM   5136  O   ASP D 163     -47.674  24.337  10.355  1.00 33.18           O  
ATOM   5137  CB  ASP D 163     -49.613  23.324   7.877  1.00 31.64           C  
ATOM   5138  CG  ASP D 163     -50.672  23.906   6.888  1.00 33.38           C  
ATOM   5139  OD1 ASP D 163     -50.602  25.092   6.568  1.00 36.40           O  
ATOM   5140  OD2 ASP D 163     -51.567  23.162   6.418  1.00 36.17           O  
ATOM   5141  N   ALA D 164     -46.730  22.751   9.075  1.00 33.91           N  
ATOM   5142  CA  ALA D 164     -45.881  22.224  10.151  1.00 35.80           C  
ATOM   5143  C   ALA D 164     -44.717  23.146  10.493  1.00 36.53           C  
ATOM   5144  O   ALA D 164     -44.265  23.158  11.640  1.00 38.56           O  
ATOM   5145  CB  ALA D 164     -45.361  20.816   9.798  1.00 34.83           C  
ATOM   5146  N   ILE D 165     -44.222  23.900   9.515  1.00 38.12           N  
ATOM   5147  CA  ILE D 165     -43.143  24.882   9.722  1.00 39.76           C  
ATOM   5148  C   ILE D 165     -43.670  26.012  10.634  1.00 40.36           C  
ATOM   5149  O   ILE D 165     -43.036  26.394  11.640  1.00 39.05           O  
ATOM   5150  CB  ILE D 165     -42.650  25.448   8.320  1.00 39.40           C  
ATOM   5151  CG1 ILE D 165     -41.706  24.467   7.629  1.00 42.98           C  
ATOM   5152  CG2 ILE D 165     -41.939  26.762   8.428  1.00 42.66           C  
ATOM   5153  CD1 ILE D 165     -41.487  24.811   6.161  1.00 40.94           C  
ATOM   5154  N   GLY D 166     -44.852  26.511  10.255  1.00 41.35           N  
ATOM   5155  CA  GLY D 166     -45.541  27.605  10.938  1.00 42.65           C  
ATOM   5156  C   GLY D 166     -46.358  27.234  12.173  1.00 43.40           C  
ATOM   5157  O   GLY D 166     -46.831  28.138  12.870  1.00 43.78           O  
ATOM   5158  N   SER D 167     -46.555  25.927  12.415  1.00 43.32           N  
ATOM   5159  CA  SER D 167     -47.262  25.372  13.595  1.00 44.18           C  
ATOM   5160  C   SER D 167     -46.761  23.969  14.014  1.00 44.58           C  
ATOM   5161  O   SER D 167     -47.531  22.990  13.951  1.00 44.60           O  
ATOM   5162  CB  SER D 167     -48.773  25.279  13.336  1.00 44.16           C  
ATOM   5163  OG  SER D 167     -49.349  26.557  13.160  1.00 45.12           O  
ATOM   5164  N   PRO D 168     -45.483  23.854  14.448  1.00 44.89           N  
ATOM   5165  CA  PRO D 168     -44.892  22.530  14.731  1.00 44.69           C  
ATOM   5166  C   PRO D 168     -45.702  21.594  15.658  1.00 45.18           C  
ATOM   5167  O   PRO D 168     -45.740  20.365  15.424  1.00 45.91           O  
ATOM   5168  CB  PRO D 168     -43.526  22.880  15.345  1.00 44.13           C  
ATOM   5169  CG  PRO D 168     -43.176  24.160  14.790  1.00 44.86           C  
ATOM   5170  CD  PRO D 168     -44.497  24.931  14.670  1.00 44.80           C  
ATOM   5171  N   ALA D 169     -46.350  22.143  16.687  1.00 44.96           N  
ATOM   5172  CA  ALA D 169     -47.014  21.314  17.708  1.00 44.54           C  
ATOM   5173  C   ALA D 169     -48.226  20.503  17.219  1.00 44.41           C  
ATOM   5174  O   ALA D 169     -48.526  19.436  17.770  1.00 43.86           O  
ATOM   5175  CB  ALA D 169     -47.394  22.167  18.942  1.00 44.38           C  
ATOM   5176  N   LEU D 170     -48.927  21.017  16.206  1.00 43.80           N  
ATOM   5177  CA  LEU D 170     -50.099  20.335  15.630  1.00 43.57           C  
ATOM   5178  C   LEU D 170     -49.657  19.261  14.634  1.00 42.96           C  
ATOM   5179  O   LEU D 170     -50.481  18.454  14.184  1.00 42.85           O  
ATOM   5180  CB  LEU D 170     -51.021  21.332  14.893  1.00 44.17           C  
ATOM   5181  CG  LEU D 170     -52.066  22.193  15.610  1.00 45.22           C  
ATOM   5182  CD1 LEU D 170     -52.615  23.312  14.682  1.00 43.65           C  
ATOM   5183  CD2 LEU D 170     -53.215  21.337  16.155  1.00 47.20           C  
ATOM   5184  N   TYR D 171     -48.363  19.272  14.296  1.00 41.15           N  
ATOM   5185  CA  TYR D 171     -47.794  18.432  13.230  1.00 40.15           C  
ATOM   5186  C   TYR D 171     -46.465  17.740  13.638  1.00 39.57           C  
ATOM   5187  O   TYR D 171     -45.430  17.963  13.005  1.00 39.69           O  
ATOM   5188  CB  TYR D 171     -47.574  19.265  11.942  1.00 39.37           C  
ATOM   5189  CG  TYR D 171     -48.843  19.863  11.385  1.00 38.52           C  
ATOM   5190  CD1 TYR D 171     -49.626  19.158  10.459  1.00 40.71           C  
ATOM   5191  CD2 TYR D 171     -49.260  21.119  11.778  1.00 36.47           C  
ATOM   5192  CE1 TYR D 171     -50.831  19.698   9.963  1.00 39.24           C  
ATOM   5193  CE2 TYR D 171     -50.441  21.676  11.289  1.00 36.03           C  
ATOM   5194  CZ  TYR D 171     -51.224  20.968  10.393  1.00 39.38           C  
ATOM   5195  OH  TYR D 171     -52.394  21.536   9.918  1.00 39.99           O  
ATOM   5196  N   PRO D 172     -46.494  16.881  14.674  1.00 39.58           N  
ATOM   5197  CA  PRO D 172     -45.308  16.075  14.983  1.00 38.54           C  
ATOM   5198  C   PRO D 172     -44.941  15.063  13.865  1.00 38.55           C  
ATOM   5199  O   PRO D 172     -45.799  14.695  13.053  1.00 37.26           O  
ATOM   5200  CB  PRO D 172     -45.717  15.334  16.268  1.00 39.18           C  
ATOM   5201  CG  PRO D 172     -47.188  15.307  16.243  1.00 40.11           C  
ATOM   5202  CD  PRO D 172     -47.592  16.616  15.627  1.00 39.30           C  
ATOM   5203  N   PRO D 173     -43.672  14.603  13.826  1.00 37.89           N  
ATOM   5204  CA  PRO D 173     -43.249  13.718  12.731  1.00 37.80           C  
ATOM   5205  C   PRO D 173     -44.156  12.494  12.522  1.00 37.45           C  
ATOM   5206  O   PRO D 173     -44.414  12.103  11.376  1.00 35.33           O  
ATOM   5207  CB  PRO D 173     -41.850  13.284  13.157  1.00 38.23           C  
ATOM   5208  CG  PRO D 173     -41.353  14.438  13.958  1.00 38.35           C  
ATOM   5209  CD  PRO D 173     -42.560  14.898  14.747  1.00 38.32           C  
ATOM   5210  N   GLU D 174     -44.633  11.909  13.620  1.00 36.58           N  
ATOM   5211  CA  GLU D 174     -45.475  10.719  13.532  1.00 36.49           C  
ATOM   5212  C   GLU D 174     -46.809  11.077  12.882  1.00 34.72           C  
ATOM   5213  O   GLU D 174     -47.342  10.295  12.072  1.00 34.45           O  
ATOM   5214  CB  GLU D 174     -45.687  10.065  14.907  1.00 37.22           C  
ATOM   5215  CG  GLU D 174     -44.461  10.112  15.845  1.00 42.13           C  
ATOM   5216  CD  GLU D 174     -44.439  11.380  16.703  1.00 46.38           C  
ATOM   5217  OE1 GLU D 174     -45.191  11.445  17.721  1.00 47.93           O  
ATOM   5218  OE2 GLU D 174     -43.676  12.314  16.353  1.00 45.85           O  
ATOM   5219  N   TYR D 175     -47.316  12.262  13.210  1.00 32.78           N  
ATOM   5220  CA  TYR D 175     -48.533  12.762  12.583  1.00 32.24           C  
ATOM   5221  C   TYR D 175     -48.335  12.989  11.099  1.00 31.00           C  
ATOM   5222  O   TYR D 175     -49.158  12.589  10.300  1.00 29.10           O  
ATOM   5223  CB  TYR D 175     -49.018  14.089  13.191  1.00 34.50           C  
ATOM   5224  CG  TYR D 175     -50.386  14.449  12.666  1.00 35.87           C  
ATOM   5225  CD1 TYR D 175     -51.516  13.757  13.121  1.00 40.61           C  
ATOM   5226  CD2 TYR D 175     -50.562  15.459  11.690  1.00 39.86           C  
ATOM   5227  CE1 TYR D 175     -52.805  14.061  12.656  1.00 42.52           C  
ATOM   5228  CE2 TYR D 175     -51.865  15.783  11.214  1.00 39.73           C  
ATOM   5229  CZ  TYR D 175     -52.967  15.070  11.699  1.00 41.24           C  
ATOM   5230  OH  TYR D 175     -54.255  15.331  11.279  1.00 40.79           O  
ATOM   5231  N   LEU D 176     -47.249  13.669  10.747  1.00 29.53           N  
ATOM   5232  CA  LEU D 176     -46.891  13.901   9.320  1.00 29.49           C  
ATOM   5233  C   LEU D 176     -46.802  12.627   8.482  1.00 29.03           C  
ATOM   5234  O   LEU D 176     -47.345  12.549   7.383  1.00 28.25           O  
ATOM   5235  CB  LEU D 176     -45.556  14.650   9.247  1.00 29.27           C  
ATOM   5236  CG  LEU D 176     -45.734  16.112   9.683  1.00 30.66           C  
ATOM   5237  CD1 LEU D 176     -44.349  16.756   9.884  1.00 31.08           C  
ATOM   5238  CD2 LEU D 176     -46.595  16.875   8.672  1.00 31.99           C  
ATOM   5239  N   GLU D 177     -46.096  11.635   9.011  1.00 28.58           N  
ATOM   5240  CA  GLU D 177     -45.959  10.344   8.360  1.00 29.34           C  
ATOM   5241  C   GLU D 177     -47.319   9.665   8.191  1.00 28.41           C  
ATOM   5242  O   GLU D 177     -47.612   9.150   7.115  1.00 27.18           O  
ATOM   5243  CB  GLU D 177     -44.960   9.467   9.143  1.00 29.53           C  
ATOM   5244  CG  GLU D 177     -43.517   9.961   8.919  1.00 32.24           C  
ATOM   5245  CD  GLU D 177     -42.486   9.304   9.818  1.00 35.33           C  
ATOM   5246  OE1 GLU D 177     -42.849   8.599  10.797  1.00 41.40           O  
ATOM   5247  OE2 GLU D 177     -41.290   9.529   9.555  1.00 43.88           O  
ATOM   5248  N   HIS D 178     -48.150   9.694   9.230  1.00 26.42           N  
ATOM   5249  CA  HIS D 178     -49.502   9.109   9.115  1.00 27.12           C  
ATOM   5250  C   HIS D 178     -50.329   9.817   8.034  1.00 26.47           C  
ATOM   5251  O   HIS D 178     -51.011   9.171   7.247  1.00 25.43           O  
ATOM   5252  CB  HIS D 178     -50.290   9.225  10.426  1.00 26.09           C  
ATOM   5253  CG  HIS D 178     -51.659   8.612  10.342  1.00 28.76           C  
ATOM   5254  ND1 HIS D 178     -51.856   7.266  10.115  1.00 31.46           N  
ATOM   5255  CD2 HIS D 178     -52.897   9.157  10.463  1.00 32.33           C  
ATOM   5256  CE1 HIS D 178     -53.152   7.003  10.105  1.00 31.63           C  
ATOM   5257  NE2 HIS D 178     -53.804   8.132  10.319  1.00 31.77           N  
ATOM   5258  N   ALA D 179     -50.345  11.151   8.082  1.00 26.80           N  
ATOM   5259  CA  ALA D 179     -51.037  11.974   7.071  1.00 26.01           C  
ATOM   5260  C   ALA D 179     -50.593  11.650   5.647  1.00 26.45           C  
ATOM   5261  O   ALA D 179     -51.417  11.461   4.741  1.00 26.27           O  
ATOM   5262  CB  ALA D 179     -50.838  13.515   7.397  1.00 26.83           C  
ATOM   5263  N   LEU D 180     -49.284  11.519   5.444  1.00 25.72           N  
ATOM   5264  CA  LEU D 180     -48.770  11.234   4.123  1.00 26.30           C  
ATOM   5265  C   LEU D 180     -49.257   9.830   3.703  1.00 26.23           C  
ATOM   5266  O   LEU D 180     -49.685   9.650   2.565  1.00 26.38           O  
ATOM   5267  CB  LEU D 180     -47.245  11.297   4.121  1.00 26.36           C  
ATOM   5268  CG  LEU D 180     -46.566  10.881   2.769  1.00 25.76           C  
ATOM   5269  CD1 LEU D 180     -47.098  11.650   1.528  1.00 26.01           C  
ATOM   5270  CD2 LEU D 180     -45.088  11.115   2.940  1.00 28.23           C  
ATOM   5271  N   ASP D 181     -49.220   8.889   4.646  1.00 26.82           N  
ATOM   5272  CA  ASP D 181     -49.684   7.496   4.421  1.00 27.19           C  
ATOM   5273  C   ASP D 181     -51.147   7.518   3.960  1.00 27.09           C  
ATOM   5274  O   ASP D 181     -51.531   6.842   3.019  1.00 26.89           O  
ATOM   5275  CB  ASP D 181     -49.640   6.690   5.719  1.00 28.49           C  
ATOM   5276  CG  ASP D 181     -48.268   6.103   6.032  1.00 33.28           C  
ATOM   5277  OD1 ASP D 181     -47.345   6.145   5.172  1.00 33.49           O  
ATOM   5278  OD2 ASP D 181     -48.120   5.578   7.164  1.00 36.10           O  
ATOM   5279  N   ILE D 182     -51.960   8.318   4.650  1.00 26.85           N  
ATOM   5280  CA  ILE D 182     -53.375   8.363   4.352  1.00 26.49           C  
ATOM   5281  C   ILE D 182     -53.596   8.985   2.970  1.00 26.84           C  
ATOM   5282  O   ILE D 182     -54.386   8.462   2.179  1.00 26.34           O  
ATOM   5283  CB  ILE D 182     -54.168   9.096   5.444  1.00 27.29           C  
ATOM   5284  CG1 ILE D 182     -54.257   8.238   6.744  1.00 26.67           C  
ATOM   5285  CG2 ILE D 182     -55.583   9.502   4.925  1.00 24.89           C  
ATOM   5286  CD1 ILE D 182     -54.939   6.871   6.594  1.00 28.51           C  
ATOM   5287  N   GLN D 183     -52.884  10.092   2.670  1.00 27.70           N  
ATOM   5288  CA  GLN D 183     -52.972  10.713   1.328  1.00 27.77           C  
ATOM   5289  C   GLN D 183     -52.590   9.749   0.189  1.00 28.42           C  
ATOM   5290  O   GLN D 183     -53.312   9.634  -0.822  1.00 27.67           O  
ATOM   5291  CB  GLN D 183     -52.152  12.016   1.255  1.00 27.22           C  
ATOM   5292  CG  GLN D 183     -52.263  12.683  -0.157  1.00 29.83           C  
ATOM   5293  CD  GLN D 183     -53.547  13.465  -0.388  1.00 31.39           C  
ATOM   5294  OE1 GLN D 183     -54.353  13.670   0.520  1.00 35.98           O  
ATOM   5295  NE2 GLN D 183     -53.706  13.985  -1.607  1.00 35.90           N  
ATOM   5296  N   ILE D 184     -51.456   9.065   0.352  1.00 27.99           N  
ATOM   5297  CA  ILE D 184     -51.029   8.027  -0.622  1.00 28.87           C  
ATOM   5298  C   ILE D 184     -52.088   6.944  -0.845  1.00 29.16           C  
ATOM   5299  O   ILE D 184     -52.406   6.614  -2.004  1.00 29.51           O  
ATOM   5300  CB  ILE D 184     -49.657   7.453  -0.239  1.00 28.12           C  
ATOM   5301  CG1 ILE D 184     -48.638   8.570  -0.485  1.00 26.50           C  
ATOM   5302  CG2 ILE D 184     -49.350   6.166  -1.071  1.00 28.57           C  
ATOM   5303  CD1 ILE D 184     -47.213   8.268   0.066  1.00 29.57           C  
ATOM   5304  N   GLY D 185     -52.658   6.422   0.239  1.00 29.46           N  
ATOM   5305  CA  GLY D 185     -53.755   5.438   0.136  1.00 30.57           C  
ATOM   5306  C   GLY D 185     -54.929   5.952  -0.689  1.00 30.63           C  
ATOM   5307  O   GLY D 185     -55.470   5.230  -1.547  1.00 29.58           O  
HETATM 5308  N   MSE D 186     -55.314   7.212  -0.447  1.00 30.47           N  
HETATM 5309  CA  MSE D 186     -56.366   7.839  -1.227  1.00 32.74           C  
HETATM 5310  C   MSE D 186     -55.979   7.942  -2.706  1.00 31.97           C  
HETATM 5311  O   MSE D 186     -56.776   7.604  -3.575  1.00 31.65           O  
HETATM 5312  CB  MSE D 186     -56.733   9.205  -0.661  1.00 31.35           C  
HETATM 5313  CG  MSE D 186     -57.421   9.073   0.681  1.00 32.04           C  
HETATM 5314 SE   MSE D 186     -58.279  10.765   1.168  1.00 42.76          SE  
HETATM 5315  CE  MSE D 186     -56.751  11.591   1.562  1.00 27.46           C  
ATOM   5316  N   ILE D 187     -54.756   8.387  -2.968  1.00 32.37           N  
ATOM   5317  CA  ILE D 187     -54.246   8.586  -4.349  1.00 33.13           C  
ATOM   5318  C   ILE D 187     -54.325   7.270  -5.141  1.00 34.30           C  
ATOM   5319  O   ILE D 187     -54.694   7.253  -6.322  1.00 34.10           O  
ATOM   5320  CB  ILE D 187     -52.789   9.155  -4.278  1.00 33.73           C  
ATOM   5321  CG1 ILE D 187     -52.764  10.585  -3.674  1.00 34.44           C  
ATOM   5322  CG2 ILE D 187     -52.031   9.070  -5.618  1.00 33.56           C  
ATOM   5323  CD1 ILE D 187     -53.097  11.683  -4.599  1.00 38.58           C  
ATOM   5324  N   LEU D 188     -54.020   6.172  -4.451  1.00 35.16           N  
ATOM   5325  CA  LEU D 188     -53.879   4.852  -5.063  1.00 36.14           C  
ATOM   5326  C   LEU D 188     -55.191   4.056  -5.151  1.00 37.47           C  
ATOM   5327  O   LEU D 188     -55.214   2.937  -5.704  1.00 37.52           O  
ATOM   5328  CB  LEU D 188     -52.832   4.064  -4.304  1.00 36.12           C  
ATOM   5329  CG  LEU D 188     -51.392   4.543  -4.382  1.00 35.66           C  
ATOM   5330  CD1 LEU D 188     -50.504   3.611  -3.556  1.00 36.75           C  
ATOM   5331  CD2 LEU D 188     -50.883   4.685  -5.815  1.00 38.87           C  
ATOM   5332  N   GLN D 189     -56.270   4.629  -4.613  1.00 38.37           N  
ATOM   5333  CA  GLN D 189     -57.602   4.069  -4.730  1.00 40.54           C  
ATOM   5334  C   GLN D 189     -58.016   3.981  -6.208  1.00 41.46           C  
ATOM   5335  O   GLN D 189     -58.057   4.994  -6.921  1.00 40.49           O  
ATOM   5336  CB  GLN D 189     -58.585   4.929  -3.928  1.00 41.77           C  
ATOM   5337  CG  GLN D 189     -59.795   4.186  -3.413  1.00 44.52           C  
ATOM   5338  CD  GLN D 189     -59.504   3.369  -2.149  1.00 49.35           C  
ATOM   5339  OE1 GLN D 189     -59.933   3.743  -1.056  1.00 52.57           O  
ATOM   5340  NE2 GLN D 189     -58.796   2.253  -2.296  1.00 49.53           N  
ATOM   5341  N   GLY D 190     -58.299   2.760  -6.665  1.00 42.28           N  
ATOM   5342  CA  GLY D 190     -58.660   2.527  -8.058  1.00 43.89           C  
ATOM   5343  C   GLY D 190     -57.502   2.115  -8.948  1.00 44.95           C  
ATOM   5344  O   GLY D 190     -57.719   1.788 -10.120  1.00 45.92           O  
ATOM   5345  N   ALA D 191     -56.283   2.127  -8.409  1.00 45.99           N  
ATOM   5346  CA  ALA D 191     -55.082   1.651  -9.134  1.00 47.44           C  
ATOM   5347  C   ALA D 191     -54.844   0.133  -9.013  1.00 49.00           C  
ATOM   5348  O   ALA D 191     -55.490  -0.535  -8.202  1.00 49.74           O  
ATOM   5349  CB  ALA D 191     -53.850   2.403  -8.679  1.00 46.69           C  
ATOM   5350  N   ASP D 192     -53.905  -0.385  -9.816  1.00 50.38           N  
ATOM   5351  CA  ASP D 192     -53.525  -1.811  -9.851  1.00 52.07           C  
ATOM   5352  C   ASP D 192     -54.686  -2.772  -9.557  1.00 52.44           C  
ATOM   5353  O   ASP D 192     -55.760  -2.682 -10.165  1.00 53.16           O  
ATOM   5354  CB  ASP D 192     -52.307  -2.108  -8.942  1.00 52.21           C  
ATOM   5355  CG  ASP D 192     -52.666  -2.157  -7.446  1.00 54.71           C  
ATOM   5356  OD1 ASP D 192     -52.667  -1.086  -6.783  1.00 58.15           O  
ATOM   5357  OD2 ASP D 192     -52.936  -3.266  -6.926  1.00 56.19           O  
TER    5358      ASP D 192                                                      
END
MOLECULE T0454_57_196.pdb
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83          
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44          
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98          
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44          
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83          
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85          
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90          
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75          
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09          
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36          
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54          
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99          
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26          
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09          
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37          
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27          
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87          
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38          
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43          
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44          
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69          
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85          
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49          
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88          
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81          
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84          
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01          
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01          
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91          
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57          
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52          
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17          
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26          
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38          
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77          
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84          
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05          
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50          
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29          
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96          
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57          
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05          
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94          
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84          
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86          
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68          
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75          
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70          
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27          
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89          
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43          
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09          
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45          
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93          
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26          
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59          
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76          
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75          
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96          
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37          
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26          
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73          
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87          
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71          
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01          
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03          
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96          
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37          
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10          
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22          
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11          
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63          
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05          
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54          
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47          
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42          
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44          
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74          
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88          
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92          
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62          
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78          
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55          
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58          
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33          
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06          
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71          
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26          
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77          
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58          
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06          
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43          
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47          
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33          
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49          
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11          
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72          
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70          
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27          
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13          
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48          
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84          
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42          
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42          
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59          
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38          
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85          
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52          
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19          
ATOM    580  CD  ILE    70     -38.809  11.665  -5.486  1.00 21.34          
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97          
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62          
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07          
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37          
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19          
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11          
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99          
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24          
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78          
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05          
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38          
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66          
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93          
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88          
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49          
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79          
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28          
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03          
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08          
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26          
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37          
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75          
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82          
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36          
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08          
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89          
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88          
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26          
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16          
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22          
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26          
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19          
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65          
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70          
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25          
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59          
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06          
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36          
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42          
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66          
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24          
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57          
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68          
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41          
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71          
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93          
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23          
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27          
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18          
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31          
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85          
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21          
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74          
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51          
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73          
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25          
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04          
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01          
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86          
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15          
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03          
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22          
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54          
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09          
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58          
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21          
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22          
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32          
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84          
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05          
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23          
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38          
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69          
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82          
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01          
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28          
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11          
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95          
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97          
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13          
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76          
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08          
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65          
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27          
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09          
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10          
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71          
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64          
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31          
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65          
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01          
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80          
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47          
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01          
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70          
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72          
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90          
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60          
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03          
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93          
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96          
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13          
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86          
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85          
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34          
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08          
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10          
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81          
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59          
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89          
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70          
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21          
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48          
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80          
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02          
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50          
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33          
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93          
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38          
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94          
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86          
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06          
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54          
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78          
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45          
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95          
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75          
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69          
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32          
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71          
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30          
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32          
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12          
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68          
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77          
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01          
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22          
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10          
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19          
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36          
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14          
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63          
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71          
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44          
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62          
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67          
ATOM    744  CD  ILE    89     -42.368  13.154   5.612  1.00 14.32          
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76          
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65          
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49          
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78          
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90          
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23          
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71          
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36          
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60          
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22          
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09          
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76          
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06          
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96          
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06          
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79          
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49          
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73          
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41          
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87          
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44          
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92          
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63          
ATOM    777  N   HSD    92     -36.985  19.171   3.324  1.00 11.45          
ATOM    778  CA  HSD    92     -37.369  20.231   4.257  1.00 12.36          
ATOM    779  CB  HSD    92     -38.873  20.203   4.534  1.00 13.78          
ATOM    780  CG  HSD    92     -39.696  20.557   3.336  1.00 14.40          
ATOM    781  ND1 HSD    92     -39.591  21.777   2.684  1.00 19.47          
ATOM    782  CE1 HSD    92     -40.452  21.801   1.674  1.00 21.35          
ATOM    783  NE2 HSD    92     -41.103  20.649   1.649  1.00 16.69          
ATOM    784  CD2 HSD    92     -40.635  19.846   2.660  1.00 16.03          
ATOM    785  C   HSD    92     -36.565  20.215   5.544  1.00 12.15          
ATOM    786  O   HSD    92     -36.192  21.268   6.056  1.00 11.95          
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79          
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70          
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66          
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84          
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09          
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47          
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59          
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37          
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53          
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20          
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46          
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51          
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01          
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34          
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74          
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63          
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90          
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91          
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63          
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29          
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16          
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24          
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00          
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84          
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24          
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67          
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80          
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89          
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18          
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94          
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40          
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29          
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64          
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08          
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55          
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15          
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11          
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27          
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68          
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40          
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04          
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78          
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98          
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64          
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07          
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25          
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48          
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69          
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12          
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66          
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22          
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90          
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68          
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84          
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27          
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86          
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59          
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51          
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22          
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91          
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19          
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36          
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57          
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26          
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03          
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22          
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30          
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04          
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56          
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17          
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88          
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74          
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07          
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31          
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65          
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39          
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45          
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90          
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33          
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41          
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06          
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06          
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90          
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79          
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54          
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03          
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63          
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76          
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14          
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45          
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19          
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00          
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22          
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23          
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10          
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33          
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06          
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46          
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57          
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60          
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12          
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88          
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85          
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21          
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66          
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59          
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72          
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18          
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45          
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14          
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19          
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04          
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04          
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12          
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81          
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79          
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03          
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32          
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60          
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04          
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22          
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88          
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21          
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52          
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75          
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09          
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50          
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05          
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81          
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25          
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70          
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59          
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99          
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07          
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45          
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17          
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86          
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46          
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87          
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20          
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29          
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47          
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72          
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60          
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09          
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05          
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32          
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57          
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30          
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98          
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94          
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35          
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83          
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52          
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75          
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98          
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83          
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86          
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75          
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46          
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19          
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56          
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40          
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18          
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79          
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58          
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29          
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73          
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75          
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13          
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20          
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39          
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70          
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87          
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81          
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92          
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60          
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88          
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97          
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92          
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21          
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45          
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81          
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14          
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95          
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70          
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04          
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69          
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98          
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37          
ATOM    985  CD  ILE   116     -31.751  29.071 -11.039  1.00 12.57          
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49          
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29          
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24          
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95          
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57          
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02          
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64          
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50          
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77          
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14          
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59          
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47          
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39          
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41          
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92          
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39          
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64          
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77          
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21          
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76          
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90          
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38          
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44          
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79          
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96          
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33          
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25          
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32          
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92          
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42          
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91          
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53          
ATOM   1018  CD  ILE   121     -42.273  24.600  -7.882  1.00 11.61          
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13          
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00          
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24          
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30          
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54          
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24          
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86          
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38          
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72          
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69          
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37          
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01          
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56          
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30          
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19          
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66          
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39          
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37          
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44          
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08          
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51          
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88          
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74          
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75          
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55          
ATOM   1044  CD  ILE   125     -46.274  17.830  -8.232  1.00 11.11          
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72          
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24          
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73          
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47          
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91          
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78          
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97          
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78          
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41          
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19          
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32          
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28          
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39          
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26          
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18          
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49          
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45          
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70          
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81          
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67          
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91          
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50          
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79          
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28          
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38          
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13          
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82          
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49          
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57          
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87          
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99          
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43          
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04          
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53          
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22          
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54          
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65          
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71          
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98          
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12          
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80          
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61          
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74          
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75          
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14          
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49          
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10          
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69          
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47          
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95          
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30          
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27          
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43          
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19          
ATOM   1116  CD  ILE   132     -50.537  10.321  -8.694  1.00 10.55          
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86          
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09          
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47          
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08          
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68          
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91          
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45          
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41          
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78          
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07          
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88          
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09          
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31          
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01          
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38          
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17          
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07          
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74          
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68          
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54          
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18          
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78          
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00          
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19          
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50          
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50          
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62          
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88          
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74          
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88          
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89          
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23          
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49          
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70          
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79          
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06          
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50          
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22          
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00          
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40          
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48          
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65          
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97          
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04          
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15          
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80          
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43          
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85          
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77          
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21          
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40          
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70          
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02          
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06          
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89          
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25          
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92          
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43          
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97          
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04          
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91          
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77          
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85          
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85          
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20          
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44          
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75          
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74          
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26          
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15          
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47          
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67          
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73          
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28          
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28          
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99          
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88          
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92          
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70          
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50          
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41          
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17          
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39          
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29          
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49          
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12          
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21          
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67          
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42          
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83          
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12          
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76          
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37          
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63          
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52          
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03          
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81          
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58          
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22          
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65          
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62          
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58          
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00          
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60          
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09          
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00          
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96          
ATOM   1253  N   HSD   146     -57.762  12.235 -12.428  1.00 12.38          
ATOM   1254  CA  HSD   146     -56.767  12.749 -13.335  1.00 11.72          
ATOM   1255  CB  HSD   146     -57.099  14.174 -13.754  1.00 13.12          
ATOM   1256  CG  HSD   146     -58.088  14.223 -14.890  1.00 18.87          
ATOM   1257  ND1 HSD   146     -59.407  14.593 -14.717  1.00 23.34          
ATOM   1258  CE1 HSD   146     -60.041  14.495 -15.875  1.00 23.61          
ATOM   1259  NE2 HSD   146     -59.189  14.056 -16.787  1.00 22.78          
ATOM   1260  CD2 HSD   146     -57.966  13.859 -16.194  1.00 21.18          
ATOM   1261  C   HSD   146     -55.432  12.632 -12.658  1.00  9.97          
ATOM   1262  O   HSD   146     -55.283  13.064 -11.523  1.00  8.48          
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06          
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43          
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64          
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37          
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42          
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91          
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28          
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29          
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38          
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18          
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21          
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80          
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51          
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65          
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66          
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17          
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80          
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10          
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11          
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78          
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76          
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08          
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78          
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08          
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66          
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57          
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77          
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41          
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18          
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91          
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61          
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31          
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72          
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81          
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27          
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58          
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18          
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70          
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69          
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37          
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16          
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65          
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42          
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88          
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98          
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94          
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06          
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43          
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45          
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02          
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85          
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15          
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37          
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90          
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15          
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59          
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17          
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53          
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23          
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33          
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18          
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22          
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40          
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03          
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44          
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36          
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33          
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60          
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62          
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60          
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87          
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80          
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50          
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05          
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94          
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99          
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56          
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44          
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46          
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49          
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04          
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55          
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77          
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99          
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46          
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05          
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76          
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16          
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68          
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05          
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88          
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56          
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31          
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41          
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66          
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26          
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86          
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74          
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30          
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83          
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42          
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71          
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83          
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04          
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95          
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32          
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72          
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65          
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99          
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27          
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78          
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91          
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69          
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79          
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23          
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36          
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77          
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53          
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76          
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66          
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04          
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53          
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47          
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16          
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46          
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30          
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61          
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19          
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73          
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56          
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21          
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79          
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26          
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23          
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44          
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11          
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75          
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25          
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75          
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51          
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68          
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81          
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81          
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69          
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46          
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56          
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08          
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18          
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47          
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91          
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05          
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62          
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98          
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39          
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50          
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79          
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56          
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79          
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47          
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51          
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58          
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67          
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06          
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34          
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77          
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80          
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84          
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31          
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34          
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96          
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30          
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97          
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07          
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20          
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56          
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40          
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09          
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32          
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27          
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32          
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36          
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94          
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35          
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29          
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72          
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87          
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97          
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93          
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97          
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44          
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33          
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42          
ATOM   1464  N   HSD   174     -44.824  18.610  15.068  1.00 12.00          
ATOM   1465  CA  HSD   174     -43.970  18.721  13.876  1.00 14.23          
ATOM   1466  CB  HSD   174     -43.909  20.171  13.391  1.00 14.23          
ATOM   1467  CG  HSD   174     -45.247  20.722  13.030  1.00 15.81          
ATOM   1468  ND1 HSD   174     -46.071  21.324  13.968  1.00 16.61          
ATOM   1469  CE1 HSD   174     -47.185  21.718  13.368  1.00 20.91          
ATOM   1470  NE2 HSD   174     -47.116  21.386  12.085  1.00 19.63          
ATOM   1471  CD2 HSD   174     -45.900  20.785  11.839  1.00 17.42          
ATOM   1472  C   HSD   174     -42.578  18.183  14.149  1.00 13.15          
ATOM   1473  O   HSD   174     -41.625  18.515  13.427  1.00 14.79          
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28          
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71          
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35          
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37          
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44          
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58          
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15          
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22          
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70          
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98          
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08          
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24          
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21          
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82          
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58          
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92          
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07          
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89          
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05          
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97          
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38          
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77          
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23          
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28          
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38          
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89          
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81          
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68          
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33          
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25          
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75          
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28          
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21          
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00          
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73          
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97          
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43          
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55          
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85          
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39          
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36          
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71          
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99          
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42          
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63          
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71          
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28          
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78          
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42          
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10          
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01          
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11          
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17          
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06          
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14          
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26          
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08          
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64          
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83          
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91          
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08          
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95          
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14          
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11          
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68          
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35          
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84          
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02          
ATOM   1542  CD  ILE   183     -41.658   9.195   5.429  1.00 11.23          
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12          
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45          
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62          
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53          
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75          
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01          
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69          
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23          
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38          
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61          
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24          
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19          
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09          
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52          
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20          
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34          
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76          
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90          
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31          
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88          
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00          
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79          
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92          
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48          
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97          
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73          
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89          
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50          
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69          
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60          
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29          
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60          
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97          
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48          
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25          
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81          
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07          
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17          
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64          
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10          
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78          
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55          
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35          
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34          
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03          
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52          
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14          
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18          
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18          
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61          
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98          
ATOM   1605  CD  ILE   189     -54.723  11.960   5.716  1.00 13.83          
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30          
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70          
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40          
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58          
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58          
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23          
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45          
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44          
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91          
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37          
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34          
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34          
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23          
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36          
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49          
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39          
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16          
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70          
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85          
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49          
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57          
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47          
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54          
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38          
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78          
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83          
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16          
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70          
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65          
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86          
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41          
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66          
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15          
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23          
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71          
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66          
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09          
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51          
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22          
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15          
ATOM   1646  CD  ILE   194     -62.095  12.150   6.229  1.00 10.65          
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26          
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00          
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91          
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74          
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32          
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64          
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42          
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19          
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09          
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40          
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54          
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64          
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48          
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42          
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76          
END
