
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  280 ( 2269),  selected  280 , name 1ig1_A
# Molecule2: number of CA atoms  265 ( 2104),  selected  265 , name T0456.pdb
# PARAMETERS: 1ig1_A.T0456.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     2_A      Y      15           -
LGA    V     3_A      F      16           -
LGA    F     4_A      Q      17           -
LGA    R     5_A      -       -           -
LGA    Q     6_A      G      18          3.151
LGA    E     7_A      T      19          2.509
LGA    N     8_A      F      20          4.388
LGA    V     9_A      A      21          2.062
LGA    D    10_A      -       -           -
LGA    D    11_A      E      22          3.407
LGA    Y    12_A      R      23          2.805
LGA    Y    13_A      Y      24          2.334
LGA    D    14_A      N      25          3.304
LGA    T    15_A      I      26          2.098
LGA    G    16_A      V      27          3.127
LGA    E    17_A      C      28          3.859
LGA    E    18_A      M      29          2.899
LGA    L    19_A      L      30          2.836
LGA    G    20_A      G      31          3.506
LGA    S    21_A      K      32          2.050
LGA    G    22_A      G      33          3.582
LGA    Q    23_A      S      34           #
LGA    F    24_A      F      35          4.258
LGA    A    25_A      G      36          1.185
LGA    V    26_A      E      37          1.126
LGA    V    27_A      V      38          0.835
LGA    K    28_A      L      39          1.276
LGA    K    29_A      K      40          1.607
LGA    C    30_A      C      41          1.700
LGA    R    31_A      K      42          1.827
LGA    E    32_A      D      43          1.542
LGA    K    33_A      R      44          2.714
LGA    S    34_A      I      45          1.948
LGA    T    35_A      T      46          2.058
LGA    G    36_A      Q      47          2.440
LGA    L    37_A      Q      48          1.504
LGA    Q    38_A      E      49          1.523
LGA    Y    39_A      Y      50          0.922
LGA    A    40_A      A      51          0.483
LGA    A    41_A      V      52          0.465
LGA    K    42_A      K      53          0.395
LGA    F    43_A      V      54          0.226
LGA    I    44_A      I      55          0.180
LGA    K    45_A      N      56          0.560
LGA    K    46_A      K      57          1.104
LGA    R    47_A      A      58          1.667
LGA    R    48_A      -       -           -
LGA    T    49_A      -       -           -
LGA    K    50_A      -       -           -
LGA    S    51_A      -       -           -
LGA    S    52_A      -       -           -
LGA    R    53_A      -       -           -
LGA    R    54_A      -       -           -
LGA    G    55_A      S      59          3.083
LGA    V    56_A      A      60          2.931
LGA    S    57_A      K      61          3.777
LGA    R    58_A      N      62          4.641
LGA    -       -      K      63           -
LGA    -       -      D      64           -
LGA    E    59_A      T      65          5.141
LGA    D    60_A      S      66           -
LGA    I    61_A      T      67           #
LGA    E    62_A      I      68          1.443
LGA    R    63_A      -       -           -
LGA    E    64_A      -       -           -
LGA    V    65_A      L      69          5.163
LGA    S    66_A      R      70          3.843
LGA    I    67_A      E      71          3.995
LGA    -       -      V      72           -
LGA    -       -      E      73           -
LGA    -       -      L      74           -
LGA    L    68_A      L      75          2.432
LGA    K    69_A      K      76          1.968
LGA    E    70_A      K      77          3.285
LGA    I    71_A      L      78          1.680
LGA    Q    72_A      D      79          1.135
LGA    H    73_A      H      80          1.036
LGA    P    74_A      P      81          0.903
LGA    N    75_A      N      82          0.888
LGA    V    76_A      I      83          0.678
LGA    I    77_A      M      84          1.397
LGA    T    78_A      K      85          1.546
LGA    L    79_A      L      86          1.815
LGA    H    80_A      F      87          1.641
LGA    E    81_A      E      88          2.177
LGA    V    82_A      I      89          1.905
LGA    Y    83_A      L      90          1.600
LGA    E    84_A      E      91          0.956
LGA    N    85_A      D      92          0.865
LGA    K    86_A      S      93          1.075
LGA    T    87_A      S      94          0.976
LGA    D    88_A      S      95          0.745
LGA    V    89_A      F      96          0.641
LGA    I    90_A      Y      97          0.610
LGA    L    91_A      I      98          1.010
LGA    I    92_A      V      99          0.801
LGA    L    93_A      G     100          0.673
LGA    E    94_A      E     101          1.462
LGA    L    95_A      L     102          1.574
LGA    V    96_A      Y     103          2.035
LGA    A    97_A      T     104          1.928
LGA    G    98_A      -       -           -
LGA    G    99_A      G     106          1.697
LGA    E   100_A      E     107          1.260
LGA    L   101_A      L     108          1.111
LGA    F   102_A      F     109          1.097
LGA    D   103_A      D     110          1.449
LGA    F   104_A      E     111          2.038
LGA    L   105_A      I     112          1.732
LGA    A   106_A      I     113          1.610
LGA    E   107_A      K     114          1.884
LGA    K   108_A      R     115          1.922
LGA    E   109_A      K     116          1.468
LGA    S   110_A      R     117          1.392
LGA    L   111_A      F     118          1.245
LGA    T   112_A      S     119          1.029
LGA    E   113_A      E     120          1.016
LGA    E   114_A      H     121          1.192
LGA    E   115_A      D     122          1.056
LGA    A   116_A      A     123          0.565
LGA    T   117_A      A     124          0.849
LGA    E   118_A      R     125          1.020
LGA    F   119_A      I     126          0.789
LGA    L   120_A      I     127          0.412
LGA    K   121_A      K     128          0.698
LGA    Q   122_A      Q     129          0.480
LGA    I   123_A      V     130          0.364
LGA    L   124_A      F     131          0.348
LGA    N   125_A      S     132          0.344
LGA    G   126_A      G     133          0.226
LGA    V   127_A      I     134          0.400
LGA    Y   128_A      T     135          0.618
LGA    Y   129_A      Y     136          0.291
LGA    L   130_A      M     137          0.482
LGA    H   131_A      H     138          0.698
LGA    S   132_A      K     139          0.705
LGA    L   133_A      H     140          0.731
LGA    Q   134_A      N     141          1.317
LGA    I   135_A      I     142          1.202
LGA    A   136_A      V     143          1.202
LGA    H   137_A      H     144          1.100
LGA    F   138_A      R     145          0.783
LGA    D   139_A      D     146          0.893
LGA    L   140_A      L     147          0.734
LGA    K   141_A      K     148          0.830
LGA    P   142_A      P     149          0.550
LGA    E   143_A      E     150          0.851
LGA    N   144_A      N     151          0.968
LGA    I   145_A      I     152          1.039
LGA    M   146_A      L     153          1.285
LGA    L   147_A      L     154          1.668
LGA    L   148_A      -       -           -
LGA    D   149_A      -       -           -
LGA    R   150_A      -       -           -
LGA    N   151_A      K     159          2.694
LGA    V   152_A      D     160          1.875
LGA    P   153_A      -       -           -
LGA    K   154_A      -       -           -
LGA    P   155_A      C     161          1.913
LGA    R   156_A      D     162          0.530
LGA    I   157_A      I     163          1.194
LGA    K   158_A      K     164          1.105
LGA    I   159_A      I     165          0.857
LGA    I   160_A      I     166          0.774
LGA    D   161_A      D     167          1.753
LGA    F   162_A      F     168          3.329
LGA    -       -      G     169           -
LGA    -       -      L     170           -
LGA    G   163_A      S     171          2.113
LGA    L   164_A      T     172          3.641
LGA    A   165_A      C     173           #
LGA    H   166_A      F     174           -
LGA    K   167_A      -       -           -
LGA    I   168_A      -       -           -
LGA    D   169_A      -       -           -
LGA    F   170_A      -       -           -
LGA    G   171_A      -       -           -
LGA    N   172_A      -       -           -
LGA    E   173_A      -       -           -
LGA    F   174_A      -       -           -
LGA    K   175_A      -       -           -
LGA    N   176_A      -       -           -
LGA    I   177_A      -       -           -
LGA    F   178_A      Q     175           #
LGA    G   179_A      Q     176           #
LGA    -       -      N     177           -
LGA    -       -      T     178           -
LGA    -       -      K     179           -
LGA    -       -      M     180           -
LGA    -       -      K     181           -
LGA    -       -      D     182           -
LGA    -       -      R     183           -
LGA    -       -      I     184           -
LGA    -       -      G     185           -
LGA    T   180_A      T     186          1.411
LGA    P   181_A      A     187          1.462
LGA    E   182_A      Y     188          0.922
LGA    F   183_A      Y     189          0.665
LGA    V   184_A      I     190          0.871
LGA    A   185_A      A     191          0.703
LGA    P   186_A      P     192          0.879
LGA    E   187_A      E     193          0.553
LGA    I   188_A      V     194          0.847
LGA    V   189_A      L     195          1.562
LGA    N   190_A      R     196          1.599
LGA    Y   191_A      G     197          1.693
LGA    E   192_A      T     198          3.619
LGA    P   193_A      -       -           -
LGA    L   194_A      Y     199          1.888
LGA    G   195_A      D     200          1.135
LGA    L   196_A      E     201          0.817
LGA    E   197_A      K     202          0.934
LGA    A   198_A      C     203          0.986
LGA    D   199_A      D     204          0.895
LGA    M   200_A      V     205          0.778
LGA    W   201_A      W     206          0.618
LGA    S   202_A      S     207          0.659
LGA    I   203_A      A     208          0.994
LGA    G   204_A      G     209          0.539
LGA    V   205_A      V     210          0.338
LGA    I   206_A      I     211          0.683
LGA    T   207_A      L     212          0.303
LGA    Y   208_A      Y     213          0.376
LGA    I   209_A      I     214          0.747
LGA    L   210_A      L     215          0.902
LGA    L   211_A      L     216          0.925
LGA    S   212_A      S     217          1.315
LGA    G   213_A      G     218          1.204
LGA    A   214_A      T     219          0.969
LGA    S   215_A      P     220          0.889
LGA    P   216_A      P     221          0.798
LGA    F   217_A      F     222          0.389
LGA    L   218_A      Y     223          2.085
LGA    G   219_A      G     224          1.384
LGA    D   220_A      K     225          1.688
LGA    T   221_A      N     226          1.933
LGA    K   222_A      E     227          1.556
LGA    Q   223_A      Y     228          1.900
LGA    E   224_A      D     229          1.518
LGA    T   225_A      I     230          1.251
LGA    L   226_A      L     231          1.385
LGA    A   227_A      K     232          1.305
LGA    N   228_A      R     233          0.576
LGA    V   229_A      V     234          0.840
LGA    S   230_A      E     235          1.643
LGA    A   231_A      T     236          0.899
LGA    V   232_A      G     237          1.268
LGA    N   233_A      K     238          2.250
LGA    Y   234_A      Y     239          1.347
LGA    E   235_A      A     240          1.047
LGA    F   236_A      F     241          1.789
LGA    E   237_A      D     242          3.476
LGA    D   238_A      L     243          2.823
LGA    E   239_A      P     244          2.747
LGA    Y   240_A      Q     245          2.279
LGA    F   241_A      W     246          1.817
LGA    S   242_A      R     247          2.539
LGA    N   243_A      T     248          2.652
LGA    T   244_A      I     249          1.595
LGA    S   245_A      S     250          1.408
LGA    A   246_A      D     251          1.641
LGA    L   247_A      D     252          1.079
LGA    A   248_A      A     253          0.805
LGA    K   249_A      K     254          1.005
LGA    D   250_A      D     255          1.000
LGA    F   251_A      L     256          0.700
LGA    I   252_A      I     257          0.394
LGA    R   253_A      R     258          0.834
LGA    R   254_A      K     259          0.859
LGA    L   255_A      M     260          0.734
LGA    L   256_A      L     261          0.608
LGA    V   257_A      T     262          0.892
LGA    K   258_A      F     263          0.739
LGA    D   259_A      H     264          0.895
LGA    P   260_A      P     265          0.903
LGA    K   261_A      S     266          1.320
LGA    K   262_A      L     267          1.168
LGA    R   263_A      R     268          0.852
LGA    M   264_A      I     269          0.859
LGA    T   265_A      T     270          0.724
LGA    I   266_A      A     271          1.059
LGA    Q   267_A      T     272          1.602
LGA    D   268_A      Q     273          1.254
LGA    S   269_A      C     274          1.064
LGA    L   270_A      L     275          1.730
LGA    Q   271_A      E     276          1.853
LGA    H   272_A      H     277          1.060
LGA    P   273_A      P     278          0.714
LGA    W   274_A      W     279          0.235
LGA    I   275_A      I     280          1.066
LGA    K   276_A      Q     281          2.394
LGA    -       -      K     282           -
LGA    -       -      Y     283           -
LGA    P   277_A      S     284          4.636
LGA    P   291_A      -       -           -
LGA    Q   292_A      -       -           -
LGA    F   293_A      -       -           -
LGA    E   294_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  280  265    5.0    237    1.77    37.97     79.772    12.682

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.358143 * X  +  -0.773668 * Y  +   0.522658 * Z  +  37.401230
  Y_new =   0.330424 * X  +  -0.628590 * Y  +  -0.704056 * Z  +   3.529819
  Z_new =   0.873243 * X  +  -0.079455 * Y  +   0.480763 * Z  + -32.331242 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.163787    2.977806  [ DEG:    -9.3843    170.6157 ]
  Theta =  -1.061819   -2.079774  [ DEG:   -60.8377   -119.1623 ]
  Phi   =   2.396430   -0.745163  [ DEG:   137.3053    -42.6947 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ig1_A                                        
REMARK     2: T0456.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ig1_A.T0456.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  280  265   5.0  237   1.77   37.97  79.772
REMARK  ---------------------------------------------------------- 
MOLECULE 1ig1_A
HEADER    TRANSFERASE                             16-APR-01   1IG1              
TITLE     1.8A X-RAY STRUCTURE OF TERNARY COMPLEX OF A CATALYTIC                
TITLE    2 DOMAIN OF DEATH-ASSOCIATED PROTEIN KINASE WITH ATP                   
TITLE    3 ANALOGUE AND MN.                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DEATH-ASSOCIATED PROTEIN KINASE;                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CATALYTIC DOMAIN, PROTEIN KINASE DOMAIN;                   
COMPND   5 SYNONYM: DAP KINASE 1;                                               
COMPND   6 EC: 2.7.1.-;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    TRANSFERASE                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    V.TERESHKO,M.TEPLOVA,J.BRUNZELLE,D.M.WATTERSON,M.EGLI                 
REVDAT   1   01-APR-02 1IG1    0                                                
JRNL        AUTH   V.TERESHKO,M.TEPLOVA,J.BRUNZELLE,D.M.WATTERSON,              
JRNL        AUTH 2 M.EGLI                                                       
JRNL        TITL   CRYSTAL STRUCTURES OF THE CATALYTIC DOMAIN OF                
JRNL        TITL 2 HUMAN PROTEIN KINASE ASSOCIATED WITH APOPTOSIS AND           
JRNL        TITL 3 TUMOR SUPPRESSION.                                           
JRNL        REF    NAT.STRUCT.BIOL.              V.   8   899 2001              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1IG1 A    2   285  UNP    P53355   DAPK1_HUMAN      2    285             
SEQRES   1 A  294  THR VAL PHE ARG GLN GLU ASN VAL ASP ASP TYR TYR ASP          
SEQRES   2 A  294  THR GLY GLU GLU LEU GLY SER GLY GLN PHE ALA VAL VAL          
SEQRES   3 A  294  LYS LYS CYS ARG GLU LYS SER THR GLY LEU GLN TYR ALA          
SEQRES   4 A  294  ALA LYS PHE ILE LYS LYS ARG ARG THR LYS SER SER ARG          
SEQRES   5 A  294  ARG GLY VAL SER ARG GLU ASP ILE GLU ARG GLU VAL SER          
SEQRES   6 A  294  ILE LEU LYS GLU ILE GLN HIS PRO ASN VAL ILE THR LEU          
SEQRES   7 A  294  HIS GLU VAL TYR GLU ASN LYS THR ASP VAL ILE LEU ILE          
SEQRES   8 A  294  LEU GLU LEU VAL ALA GLY GLY GLU LEU PHE ASP PHE LEU          
SEQRES   9 A  294  ALA GLU LYS GLU SER LEU THR GLU GLU GLU ALA THR GLU          
SEQRES  10 A  294  PHE LEU LYS GLN ILE LEU ASN GLY VAL TYR TYR LEU HIS          
SEQRES  11 A  294  SER LEU GLN ILE ALA HIS PHE ASP LEU LYS PRO GLU ASN          
SEQRES  12 A  294  ILE MET LEU LEU ASP ARG ASN VAL PRO LYS PRO ARG ILE          
SEQRES  13 A  294  LYS ILE ILE ASP PHE GLY LEU ALA HIS LYS ILE ASP PHE          
SEQRES  14 A  294  GLY ASN GLU PHE LYS ASN ILE PHE GLY THR PRO GLU PHE          
SEQRES  15 A  294  VAL ALA PRO GLU ILE VAL ASN TYR GLU PRO LEU GLY LEU          
SEQRES  16 A  294  GLU ALA ASP MET TRP SER ILE GLY VAL ILE THR TYR ILE          
SEQRES  17 A  294  LEU LEU SER GLY ALA SER PRO PHE LEU GLY ASP THR LYS          
SEQRES  18 A  294  GLN GLU THR LEU ALA ASN VAL SER ALA VAL ASN TYR GLU          
SEQRES  19 A  294  PHE GLU ASP GLU TYR PHE SER ASN THR SER ALA LEU ALA          
SEQRES  20 A  294  LYS ASP PHE ILE ARG ARG LEU LEU VAL LYS ASP PRO LYS          
SEQRES  21 A  294  LYS ARG MET THR ILE GLN ASP SER LEU GLN HIS PRO TRP          
SEQRES  22 A  294  ILE LYS PRO LYS ASP THR GLN GLN ALA LEU SER SER ALA          
SEQRES  23 A  294  TRP SER HIS PRO GLN PHE GLU LYS                              
HET     MN  A3510       1                                                       
HET    ANP    300      31                                                       
HETNAM      MN MANGANESE (II) ION                                               
HETNAM     ANP PHOSPHOAMINOPHOSPHONIC ACID-ADENYLATE ESTER                      
FORMUL   2   MN    MN 2+                                                        
FORMUL   3  ANP    C10 H17 N6 O12 P3                                            
FORMUL   4  HOH   *267(H2 O)                                                    
CRYST1   46.710   62.340   88.600  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   THR A   2      -5.027  -0.364 -10.910  1.00 24.65           N  
ATOM      2  CA  THR A   2      -4.412  -0.081 -12.239  1.00 24.51           C  
ATOM      3  C   THR A   2      -4.557  -1.283 -13.167  1.00 21.97           C  
ATOM      4  O   THR A   2      -4.382  -2.427 -12.748  1.00 20.18           O  
ATOM      5  CB  THR A   2      -2.907   0.245 -12.091  1.00 27.37           C  
ATOM      6  OG1 THR A   2      -2.751   1.395 -11.249  1.00 34.30           O  
ATOM      7  CG2 THR A   2      -2.280   0.526 -13.449  1.00 29.31           C  
ATOM      8  N   VAL A   3      -4.888  -1.036 -14.400  1.00 20.35           N  
ATOM      9  CA  VAL A   3      -5.003  -2.139 -15.350  1.00 20.37           C  
ATOM     10  C   VAL A   3      -3.696  -2.273 -16.123  1.00 19.83           C  
ATOM     11  O   VAL A   3      -3.055  -1.274 -16.453  1.00 21.79           O  
ATOM     12  CB  VAL A   3      -6.179  -1.927 -16.340  1.00 21.22           C  
ATOM     13  CG1 VAL A   3      -7.450  -1.611 -15.567  1.00 20.97           C  
ATOM     14  CG2 VAL A   3      -5.861  -0.826 -17.311  1.00 24.51           C  
ATOM     15  N   PHE A   4      -3.326  -3.488 -16.427  1.00 17.99           N  
ATOM     16  CA  PHE A   4      -2.071  -3.760 -17.119  1.00 18.03           C  
ATOM     17  C   PHE A   4      -2.296  -4.223 -18.556  1.00 17.74           C  
ATOM     18  O   PHE A   4      -3.432  -4.433 -18.976  1.00 17.32           O  
ATOM     19  CB  PHE A   4      -1.280  -4.810 -16.341  1.00 17.39           C  
ATOM     20  CG  PHE A   4      -1.131  -4.480 -14.884  1.00 18.60           C  
ATOM     21  CD1 PHE A   4      -0.492  -3.307 -14.485  1.00 18.05           C  
ATOM     22  CD2 PHE A   4      -1.656  -5.322 -13.913  1.00 18.54           C  
ATOM     23  CE1 PHE A   4      -0.379  -2.979 -13.134  1.00 19.60           C  
ATOM     24  CE2 PHE A   4      -1.549  -5.006 -12.561  1.00 21.16           C  
ATOM     25  CZ  PHE A   4      -0.908  -3.829 -12.170  1.00 20.00           C  
ATOM     26  N   ARG A   5      -1.205  -4.369 -19.305  1.00 17.63           N  
ATOM     27  CA  ARG A   5      -1.283  -4.798 -20.699  1.00 17.66           C  
ATOM     28  C   ARG A   5      -1.953  -6.158 -20.820  1.00 17.43           C  
ATOM     29  O   ARG A   5      -1.529  -7.130 -20.196  1.00 17.67           O  
ATOM     30  CB  ARG A   5       0.115  -4.844 -21.321  1.00 18.74           C  
ATOM     31  CG  ARG A   5       0.748  -3.475 -21.465  1.00 23.06           C  
ATOM     32  CD  ARG A   5       2.055  -3.526 -22.249  1.00 26.37           C  
ATOM     33  NE  ARG A   5       1.864  -4.047 -23.601  1.00 26.58           N  
ATOM     34  CZ  ARG A   5       2.801  -4.026 -24.545  1.00 29.87           C  
ATOM     35  NH1 ARG A   5       3.994  -3.508 -24.287  1.00 27.70           N  
ATOM     36  NH2 ARG A   5       2.550  -4.527 -25.748  1.00 29.14           N  
ATOM     37  N   GLN A   6      -2.997  -6.228 -21.636  1.00 17.57           N  
ATOM     38  CA  GLN A   6      -3.725  -7.473 -21.792  1.00 18.00           C  
ATOM     39  C   GLN A   6      -3.492  -8.235 -23.089  1.00 19.42           C  
ATOM     40  O   GLN A   6      -4.211  -9.184 -23.398  1.00 19.93           O  
ATOM     41  CB  GLN A   6      -5.214  -7.216 -21.549  1.00 18.10           C  
ATOM     42  CG  GLN A   6      -5.517  -7.115 -20.057  1.00 18.77           C  
ATOM     43  CD  GLN A   6      -6.785  -6.356 -19.751  1.00 17.76           C  
ATOM     44  OE1 GLN A   6      -7.726  -6.366 -20.536  1.00 17.94           O  
ATOM     45  NE2 GLN A   6      -6.823  -5.706 -18.586  1.00 16.07           N  
ATOM     46  N   GLU A   7      -2.482  -7.829 -23.849  1.00 20.92           N  
ATOM     47  CA  GLU A   7      -2.152  -8.552 -25.068  1.00 22.27           C  
ATOM     48  C   GLU A   7      -1.433  -9.807 -24.585  1.00 22.01           C  
ATOM     49  O   GLU A   7      -0.873  -9.818 -23.487  1.00 20.00           O  
ATOM     50  CB  GLU A   7      -1.225  -7.722 -25.957  1.00 25.69           C  
ATOM     51  CG  GLU A   7      -1.931  -6.599 -26.690  1.00 29.86           C  
ATOM     52  CD  GLU A   7      -0.996  -5.797 -27.568  1.00 33.21           C  
ATOM     53  OE1 GLU A   7      -0.103  -5.117 -27.023  1.00 34.24           O  
ATOM     54  OE2 GLU A   7      -1.154  -5.852 -28.806  1.00 36.00           O  
ATOM     55  N   ASN A   8      -1.453 -10.865 -25.385  1.00 20.98           N  
ATOM     56  CA  ASN A   8      -0.794 -12.102 -24.989  1.00 22.56           C  
ATOM     57  C   ASN A   8       0.703 -11.849 -24.845  1.00 20.78           C  
ATOM     58  O   ASN A   8       1.347 -11.398 -25.786  1.00 20.15           O  
ATOM     59  CB  ASN A   8      -1.028 -13.191 -26.035  1.00 23.56           C  
ATOM     60  CG  ASN A   8      -0.693 -14.573 -25.517  1.00 27.00           C  
ATOM     61  OD1 ASN A   8       0.390 -14.802 -24.976  1.00 29.21           O  
ATOM     62  ND2 ASN A   8      -1.624 -15.507 -25.679  1.00 29.02           N  
ATOM     63  N   VAL A   9       1.251 -12.141 -23.670  1.00 20.77           N  
ATOM     64  CA  VAL A   9       2.672 -11.923 -23.423  1.00 20.71           C  
ATOM     65  C   VAL A   9       3.527 -12.696 -24.431  1.00 19.81           C  
ATOM     66  O   VAL A   9       4.615 -12.256 -24.809  1.00 17.23           O  
ATOM     67  CB  VAL A   9       3.061 -12.354 -21.983  1.00 21.72           C  
ATOM     68  CG1 VAL A   9       2.862 -13.850 -21.809  1.00 23.72           C  
ATOM     69  CG2 VAL A   9       4.498 -11.968 -21.693  1.00 25.29           C  
ATOM     70  N   ASP A  10       3.015 -13.839 -24.877  1.00 20.31           N  
ATOM     71  CA  ASP A  10       3.734 -14.678 -25.830  1.00 22.83           C  
ATOM     72  C   ASP A  10       3.925 -14.041 -27.198  1.00 22.33           C  
ATOM     73  O   ASP A  10       4.727 -14.521 -28.003  1.00 22.32           O  
ATOM     74  CB  ASP A  10       3.026 -16.022 -25.983  1.00 28.15           C  
ATOM     75  CG  ASP A  10       3.008 -16.809 -24.696  1.00 32.49           C  
ATOM     76  OD1 ASP A  10       4.096 -17.017 -24.118  1.00 36.49           O  
ATOM     77  OD2 ASP A  10       1.912 -17.218 -24.256  1.00 37.42           O  
ATOM     78  N   ASP A  11       3.194 -12.966 -27.471  1.00 21.52           N  
ATOM     79  CA  ASP A  11       3.333 -12.294 -28.753  1.00 22.13           C  
ATOM     80  C   ASP A  11       4.512 -11.329 -28.752  1.00 21.50           C  
ATOM     81  O   ASP A  11       4.932 -10.856 -29.811  1.00 21.69           O  
ATOM     82  CB  ASP A  11       2.058 -11.525 -29.108  1.00 25.97           C  
ATOM     83  CG  ASP A  11       0.900 -12.443 -29.461  1.00 27.74           C  
ATOM     84  OD1 ASP A  11       1.128 -13.460 -30.151  1.00 32.25           O  
ATOM     85  OD2 ASP A  11      -0.238 -12.136 -29.064  1.00 31.38           O  
ATOM     86  N   TYR A  12       5.046 -11.047 -27.566  1.00 18.86           N  
ATOM     87  CA  TYR A  12       6.161 -10.112 -27.425  1.00 19.33           C  
ATOM     88  C   TYR A  12       7.391 -10.713 -26.761  1.00 18.83           C  
ATOM     89  O   TYR A  12       8.473 -10.131 -26.816  1.00 17.78           O  
ATOM     90  CB  TYR A  12       5.704  -8.895 -26.614  1.00 21.16           C  
ATOM     91  CG  TYR A  12       4.638  -8.083 -27.302  1.00 24.45           C  
ATOM     92  CD1 TYR A  12       4.972  -7.123 -28.254  1.00 25.34           C  
ATOM     93  CD2 TYR A  12       3.290  -8.300 -27.028  1.00 25.43           C  
ATOM     94  CE1 TYR A  12       3.988  -6.395 -28.918  1.00 26.02           C  
ATOM     95  CE2 TYR A  12       2.300  -7.583 -27.685  1.00 25.13           C  
ATOM     96  CZ  TYR A  12       2.656  -6.632 -28.629  1.00 26.46           C  
ATOM     97  OH  TYR A  12       1.674  -5.930 -29.288  1.00 26.32           O  
ATOM     98  N   TYR A  13       7.221 -11.876 -26.144  1.00 18.40           N  
ATOM     99  CA  TYR A  13       8.307 -12.547 -25.439  1.00 18.99           C  
ATOM    100  C   TYR A  13       8.309 -14.049 -25.674  1.00 20.20           C  
ATOM    101  O   TYR A  13       7.267 -14.654 -25.923  1.00 20.75           O  
ATOM    102  CB  TYR A  13       8.171 -12.335 -23.927  1.00 17.81           C  
ATOM    103  CG  TYR A  13       8.335 -10.914 -23.446  1.00 16.50           C  
ATOM    104  CD1 TYR A  13       9.567 -10.454 -22.979  1.00 16.18           C  
ATOM    105  CD2 TYR A  13       7.260 -10.027 -23.454  1.00 16.14           C  
ATOM    106  CE1 TYR A  13       9.723  -9.146 -22.529  1.00 15.90           C  
ATOM    107  CE2 TYR A  13       7.406  -8.711 -23.008  1.00 17.50           C  
ATOM    108  CZ  TYR A  13       8.642  -8.281 -22.548  1.00 15.21           C  
ATOM    109  OH  TYR A  13       8.801  -6.983 -22.118  1.00 16.89           O  
ATOM    110  N   ASP A  14       9.493 -14.641 -25.578  1.00 20.01           N  
ATOM    111  CA  ASP A  14       9.658 -16.082 -25.698  1.00 21.30           C  
ATOM    112  C   ASP A  14      10.194 -16.491 -24.335  1.00 20.80           C  
ATOM    113  O   ASP A  14      11.135 -15.875 -23.837  1.00 21.55           O  
ATOM    114  CB  ASP A  14      10.674 -16.432 -26.784  1.00 20.38           C  
ATOM    115  CG  ASP A  14      10.126 -16.213 -28.176  1.00 23.58           C  
ATOM    116  OD1 ASP A  14       9.068 -16.800 -28.485  1.00 26.39           O  
ATOM    117  OD2 ASP A  14      10.744 -15.458 -28.952  1.00 22.74           O  
ATOM    118  N   THR A  15       9.595 -17.506 -23.723  1.00 21.50           N  
ATOM    119  CA  THR A  15      10.050 -17.944 -22.409  1.00 22.35           C  
ATOM    120  C   THR A  15      10.960 -19.163 -22.491  1.00 22.75           C  
ATOM    121  O   THR A  15      10.942 -19.902 -23.478  1.00 22.03           O  
ATOM    122  CB  THR A  15       8.858 -18.268 -21.469  1.00 23.89           C  
ATOM    123  OG1 THR A  15       8.071 -19.326 -22.030  1.00 23.81           O  
ATOM    124  CG2 THR A  15       7.987 -17.039 -21.274  1.00 24.82           C  
ATOM    125  N   GLY A  16      11.755 -19.364 -21.447  1.00 22.02           N  
ATOM    126  CA  GLY A  16      12.666 -20.489 -21.422  1.00 20.49           C  
ATOM    127  C   GLY A  16      12.762 -21.156 -20.066  1.00 21.04           C  
ATOM    128  O   GLY A  16      11.754 -21.530 -19.466  1.00 19.48           O  
ATOM    129  N   GLU A  17      13.995 -21.298 -19.592  1.00 19.57           N  
ATOM    130  CA  GLU A  17      14.287 -21.931 -18.312  1.00 21.16           C  
ATOM    131  C   GLU A  17      13.494 -21.347 -17.150  1.00 20.66           C  
ATOM    132  O   GLU A  17      13.272 -20.139 -17.082  1.00 21.17           O  
ATOM    133  CB  GLU A  17      15.788 -21.807 -18.020  1.00 24.60           C  
ATOM    134  CG  GLU A  17      16.177 -22.032 -16.571  1.00 29.08           C  
ATOM    135  CD  GLU A  17      17.639 -21.715 -16.303  1.00 33.31           C  
ATOM    136  OE1 GLU A  17      18.138 -20.703 -16.841  1.00 35.20           O  
ATOM    137  OE2 GLU A  17      18.285 -22.466 -15.540  1.00 36.50           O  
ATOM    138  N   GLU A  18      13.063 -22.211 -16.239  1.00 19.96           N  
ATOM    139  CA  GLU A  18      12.335 -21.751 -15.063  1.00 19.58           C  
ATOM    140  C   GLU A  18      13.405 -21.323 -14.065  1.00 20.40           C  
ATOM    141  O   GLU A  18      14.309 -22.093 -13.744  1.00 21.06           O  
ATOM    142  CB  GLU A  18      11.486 -22.875 -14.476  1.00 20.22           C  
ATOM    143  CG  GLU A  18      10.594 -22.430 -13.329  1.00 21.43           C  
ATOM    144  CD  GLU A  18       9.628 -23.511 -12.902  1.00 22.65           C  
ATOM    145  OE1 GLU A  18       8.760 -23.889 -13.712  1.00 23.39           O  
ATOM    146  OE2 GLU A  18       9.736 -23.982 -11.755  1.00 25.95           O  
ATOM    147  N   LEU A  19      13.302 -20.090 -13.582  1.00 18.75           N  
ATOM    148  CA  LEU A  19      14.275 -19.540 -12.647  1.00 18.60           C  
ATOM    149  C   LEU A  19      13.968 -19.794 -11.183  1.00 19.82           C  
ATOM    150  O   LEU A  19      14.881 -19.962 -10.369  1.00 20.76           O  
ATOM    151  CB  LEU A  19      14.398 -18.035 -12.881  1.00 19.44           C  
ATOM    152  CG  LEU A  19      14.915 -17.676 -14.271  1.00 19.72           C  
ATOM    153  CD1 LEU A  19      14.695 -16.197 -14.556  1.00 21.92           C  
ATOM    154  CD2 LEU A  19      16.391 -18.041 -14.344  1.00 21.84           C  
ATOM    155  N   GLY A  20      12.686 -19.816 -10.844  1.00 17.69           N  
ATOM    156  CA  GLY A  20      12.307 -20.031  -9.466  1.00 21.39           C  
ATOM    157  C   GLY A  20      10.809 -20.154  -9.315  1.00 23.50           C  
ATOM    158  O   GLY A  20      10.057 -19.937 -10.264  1.00 22.65           O  
ATOM    159  N   SER A  21      10.372 -20.486  -8.109  1.00 25.16           N  
ATOM    160  CA  SER A  21       8.955 -20.672  -7.864  1.00 28.65           C  
ATOM    161  C   SER A  21       8.568 -20.240  -6.455  1.00 29.34           C  
ATOM    162  O   SER A  21       9.414 -20.136  -5.565  1.00 28.58           O  
ATOM    163  CB  SER A  21       8.607 -22.150  -8.074  1.00 30.06           C  
ATOM    164  OG  SER A  21       7.206 -22.364  -8.083  1.00 37.48           O  
ATOM    165  N   GLY A  22       7.277 -19.987  -6.272  1.00 29.43           N  
ATOM    166  CA  GLY A  22       6.755 -19.584  -4.982  1.00 29.63           C  
ATOM    167  C   GLY A  22       5.396 -20.225  -4.792  1.00 29.77           C  
ATOM    168  O   GLY A  22       4.913 -20.924  -5.684  1.00 28.86           O  
ATOM    169  N   GLN A  23       4.764 -19.991  -3.645  1.00 31.13           N  
ATOM    170  CA  GLN A  23       3.455 -20.578  -3.381  1.00 31.55           C  
ATOM    171  C   GLN A  23       2.407 -20.148  -4.401  1.00 30.77           C  
ATOM    172  O   GLN A  23       1.539 -20.938  -4.772  1.00 30.49           O  
ATOM    173  CB  GLN A  23       2.974 -20.215  -1.975  1.00 34.56           C  
ATOM    174  CG  GLN A  23       1.643 -20.863  -1.613  1.00 37.50           C  
ATOM    175  CD  GLN A  23       1.191 -20.555  -0.198  1.00 38.93           C  
ATOM    176  OE1 GLN A  23       0.128 -21.001   0.230  1.00 40.56           O  
ATOM    177  NE2 GLN A  23       1.995 -19.793   0.532  1.00 40.21           N  
ATOM    178  N   PHE A  24       2.492 -18.900  -4.859  1.00 28.71           N  
ATOM    179  CA  PHE A  24       1.532 -18.382  -5.834  1.00 28.11           C  
ATOM    180  C   PHE A  24       2.191 -17.803  -7.088  1.00 26.97           C  
ATOM    181  O   PHE A  24       1.540 -17.108  -7.870  1.00 24.75           O  
ATOM    182  CB  PHE A  24       0.658 -17.302  -5.187  1.00 29.85           C  
ATOM    183  CG  PHE A  24      -0.167 -17.799  -4.034  1.00 32.42           C  
ATOM    184  CD1 PHE A  24      -1.143 -18.770  -4.228  1.00 32.46           C  
ATOM    185  CD2 PHE A  24       0.039 -17.302  -2.751  1.00 33.50           C  
ATOM    186  CE1 PHE A  24      -1.906 -19.242  -3.158  1.00 34.06           C  
ATOM    187  CE2 PHE A  24      -0.719 -17.767  -1.673  1.00 35.11           C  
ATOM    188  CZ  PHE A  24      -1.693 -18.740  -1.880  1.00 33.99           C  
ATOM    189  N   ALA A  25       3.473 -18.095  -7.290  1.00 23.73           N  
ATOM    190  CA  ALA A  25       4.171 -17.560  -8.450  1.00 22.38           C  
ATOM    191  C   ALA A  25       5.262 -18.466  -9.009  1.00 21.68           C  
ATOM    192  O   ALA A  25       5.848 -19.280  -8.293  1.00 22.10           O  
ATOM    193  CB  ALA A  25       4.766 -16.203  -8.099  1.00 21.44           C  
ATOM    194  N   VAL A  26       5.520 -18.310 -10.303  1.00 20.94           N  
ATOM    195  CA  VAL A  26       6.562 -19.056 -10.995  1.00 18.64           C  
ATOM    196  C   VAL A  26       7.315 -18.031 -11.841  1.00 17.51           C  
ATOM    197  O   VAL A  26       6.705 -17.157 -12.467  1.00 15.07           O  
ATOM    198  CB  VAL A  26       5.978 -20.168 -11.906  1.00 17.86           C  
ATOM    199  CG1 VAL A  26       5.072 -19.566 -12.968  1.00 20.24           C  
ATOM    200  CG2 VAL A  26       7.115 -20.948 -12.557  1.00 17.17           C  
ATOM    201  N   VAL A  27       8.639 -18.127 -11.844  1.00 14.90           N  
ATOM    202  CA  VAL A  27       9.466 -17.187 -12.590  1.00 15.26           C  
ATOM    203  C   VAL A  27      10.215 -17.908 -13.696  1.00 16.46           C  
ATOM    204  O   VAL A  27      10.860 -18.932 -13.459  1.00 15.87           O  
ATOM    205  CB  VAL A  27      10.477 -16.493 -11.656  1.00 15.02           C  
ATOM    206  CG1 VAL A  27      11.247 -15.421 -12.421  1.00 15.06           C  
ATOM    207  CG2 VAL A  27       9.740 -15.875 -10.465  1.00 15.12           C  
ATOM    208  N   LYS A  28      10.132 -17.362 -14.903  1.00 17.03           N  
ATOM    209  CA  LYS A  28      10.783 -17.964 -16.053  1.00 18.32           C  
ATOM    210  C   LYS A  28      11.612 -16.969 -16.849  1.00 18.86           C  
ATOM    211  O   LYS A  28      11.215 -15.819 -17.039  1.00 16.61           O  
ATOM    212  CB  LYS A  28       9.725 -18.599 -16.960  1.00 18.97           C  
ATOM    213  CG  LYS A  28       8.962 -19.736 -16.280  1.00 24.40           C  
ATOM    214  CD  LYS A  28       7.970 -20.398 -17.213  1.00 26.61           C  
ATOM    215  CE  LYS A  28       7.222 -21.533 -16.512  1.00 27.40           C  
ATOM    216  NZ  LYS A  28       8.111 -22.681 -16.149  1.00 26.81           N  
ATOM    217  N   LYS A  29      12.778 -17.411 -17.304  1.00 19.31           N  
ATOM    218  CA  LYS A  29      13.630 -16.552 -18.106  1.00 20.35           C  
ATOM    219  C   LYS A  29      12.888 -16.301 -19.409  1.00 19.75           C  
ATOM    220  O   LYS A  29      12.195 -17.184 -19.914  1.00 19.96           O  
ATOM    221  CB  LYS A  29      14.972 -17.239 -18.385  1.00 23.89           C  
ATOM    222  CG  LYS A  29      16.060 -16.899 -17.374  1.00 30.50           C  
ATOM    223  CD  LYS A  29      17.299 -17.781 -17.537  1.00 35.41           C  
ATOM    224  CE  LYS A  29      18.497 -17.213 -16.782  1.00 37.68           C  
ATOM    225  NZ  LYS A  29      19.753 -17.975 -17.057  1.00 40.10           N  
ATOM    226  N   CYS A  30      13.005 -15.097 -19.949  1.00 17.62           N  
ATOM    227  CA  CYS A  30      12.327 -14.799 -21.197  1.00 19.85           C  
ATOM    228  C   CYS A  30      13.154 -13.851 -22.045  1.00 19.64           C  
ATOM    229  O   CYS A  30      14.118 -13.252 -21.564  1.00 19.52           O  
ATOM    230  CB  CYS A  30      10.934 -14.206 -20.930  1.00 18.96           C  
ATOM    231  SG  CYS A  30      10.901 -12.586 -20.129  1.00 20.76           S  
ATOM    232  N   ARG A  31      12.771 -13.728 -23.311  1.00 19.09           N  
ATOM    233  CA  ARG A  31      13.466 -12.868 -24.257  1.00 19.20           C  
ATOM    234  C   ARG A  31      12.459 -12.014 -25.018  1.00 18.11           C  
ATOM    235  O   ARG A  31      11.538 -12.542 -25.654  1.00 17.50           O  
ATOM    236  CB  ARG A  31      14.262 -13.736 -25.239  1.00 19.57           C  
ATOM    237  CG  ARG A  31      15.014 -12.985 -26.327  1.00 18.95           C  
ATOM    238  CD  ARG A  31      15.651 -13.984 -27.281  1.00 18.11           C  
ATOM    239  NE  ARG A  31      16.398 -13.358 -28.369  1.00 20.32           N  
ATOM    240  CZ  ARG A  31      15.850 -12.764 -29.423  1.00 22.08           C  
ATOM    241  NH1 ARG A  31      14.529 -12.703 -29.551  1.00 22.51           N  
ATOM    242  NH2 ARG A  31      16.629 -12.245 -30.365  1.00 22.17           N  
ATOM    243  N   GLU A  32      12.619 -10.697 -24.942  1.00 17.21           N  
ATOM    244  CA  GLU A  32      11.722  -9.795 -25.654  1.00 17.29           C  
ATOM    245  C   GLU A  32      12.080  -9.896 -27.136  1.00 18.84           C  
ATOM    246  O   GLU A  32      13.250  -9.799 -27.506  1.00 17.61           O  
ATOM    247  CB  GLU A  32      11.896  -8.357 -25.151  1.00 18.11           C  
ATOM    248  CG  GLU A  32      10.925  -7.357 -25.766  1.00 18.20           C  
ATOM    249  CD  GLU A  32      10.737  -6.112 -24.912  1.00 19.08           C  
ATOM    250  OE1 GLU A  32      11.636  -5.801 -24.105  1.00 18.70           O  
ATOM    251  OE2 GLU A  32       9.699  -5.434 -25.052  1.00 18.69           O  
ATOM    252  N   LYS A  33      11.071 -10.102 -27.974  1.00 18.01           N  
ATOM    253  CA  LYS A  33      11.282 -10.250 -29.411  1.00 20.91           C  
ATOM    254  C   LYS A  33      11.821  -9.022 -30.131  1.00 20.75           C  
ATOM    255  O   LYS A  33      12.639  -9.144 -31.043  1.00 21.96           O  
ATOM    256  CB  LYS A  33       9.977 -10.678 -30.088  1.00 21.13           C  
ATOM    257  CG  LYS A  33       9.451 -12.031 -29.643  1.00 20.89           C  
ATOM    258  CD  LYS A  33       8.124 -12.332 -30.329  1.00 24.81           C  
ATOM    259  CE  LYS A  33       7.565 -13.670 -29.887  1.00 24.22           C  
ATOM    260  NZ  LYS A  33       6.312 -13.996 -30.616  1.00 26.48           N  
ATOM    261  N   SER A  34      11.360  -7.844 -29.732  1.00 21.51           N  
ATOM    262  CA  SER A  34      11.783  -6.608 -30.380  1.00 22.97           C  
ATOM    263  C   SER A  34      13.211  -6.155 -30.080  1.00 22.43           C  
ATOM    264  O   SER A  34      13.790  -5.394 -30.852  1.00 22.72           O  
ATOM    265  CB  SER A  34      10.819  -5.477 -30.022  1.00 22.18           C  
ATOM    266  OG  SER A  34      10.849  -5.207 -28.632  1.00 24.77           O  
ATOM    267  N   THR A  35      13.789  -6.624 -28.977  1.00 22.04           N  
ATOM    268  CA  THR A  35      15.139  -6.195 -28.607  1.00 20.55           C  
ATOM    269  C   THR A  35      16.145  -7.316 -28.403  1.00 20.91           C  
ATOM    270  O   THR A  35      17.355  -7.076 -28.402  1.00 21.20           O  
ATOM    271  CB  THR A  35      15.120  -5.386 -27.305  1.00 20.59           C  
ATOM    272  OG1 THR A  35      14.643  -6.219 -26.241  1.00 17.93           O  
ATOM    273  CG2 THR A  35      14.220  -4.172 -27.442  1.00 21.91           C  
ATOM    274  N   GLY A  36      15.646  -8.532 -28.212  1.00 19.08           N  
ATOM    275  CA  GLY A  36      16.525  -9.661 -27.980  1.00 19.89           C  
ATOM    276  C   GLY A  36      17.056  -9.667 -26.555  1.00 19.05           C  
ATOM    277  O   GLY A  36      17.830 -10.544 -26.178  1.00 20.15           O  
ATOM    278  N   LEU A  37      16.635  -8.687 -25.758  1.00 20.10           N  
ATOM    279  CA  LEU A  37      17.080  -8.595 -24.371  1.00 18.79           C  
ATOM    280  C   LEU A  37      16.344  -9.588 -23.479  1.00 19.21           C  
ATOM    281  O   LEU A  37      15.174  -9.909 -23.711  1.00 17.18           O  
ATOM    282  CB  LEU A  37      16.888  -7.173 -23.846  1.00 18.61           C  
ATOM    283  CG  LEU A  37      17.719  -6.104 -24.563  1.00 18.55           C  
ATOM    284  CD1 LEU A  37      17.323  -4.730 -24.055  1.00 17.26           C  
ATOM    285  CD2 LEU A  37      19.207  -6.359 -24.326  1.00 19.60           C  
ATOM    286  N   GLN A  38      17.036 -10.055 -22.445  1.00 19.54           N  
ATOM    287  CA  GLN A  38      16.483 -11.043 -21.533  1.00 19.81           C  
ATOM    288  C   GLN A  38      15.972 -10.484 -20.216  1.00 18.64           C  
ATOM    289  O   GLN A  38      16.516  -9.519 -19.674  1.00 16.53           O  
ATOM    290  CB  GLN A  38      17.523 -12.130 -21.285  1.00 23.49           C  
ATOM    291  CG  GLN A  38      17.803 -12.957 -22.533  1.00 27.32           C  
ATOM    292  CD  GLN A  38      19.081 -13.758 -22.433  1.00 29.66           C  
ATOM    293  OE1 GLN A  38      20.168 -13.251 -22.714  1.00 33.51           O  
ATOM    294  NE2 GLN A  38      18.962 -15.012 -22.024  1.00 30.85           N  
ATOM    295  N   TYR A  39      14.923 -11.124 -19.709  1.00 15.13           N  
ATOM    296  CA  TYR A  39      14.270 -10.713 -18.474  1.00 14.69           C  
ATOM    297  C   TYR A  39      13.812 -11.919 -17.668  1.00 14.25           C  
ATOM    298  O   TYR A  39      13.977 -13.067 -18.082  1.00 13.64           O  
ATOM    299  CB  TYR A  39      13.047  -9.858 -18.817  1.00 14.41           C  
ATOM    300  CG  TYR A  39      13.391  -8.576 -19.533  1.00 13.01           C  
ATOM    301  CD1 TYR A  39      13.851  -7.472 -18.824  1.00 15.24           C  
ATOM    302  CD2 TYR A  39      13.310  -8.482 -20.926  1.00 13.08           C  
ATOM    303  CE1 TYR A  39      14.231  -6.305 -19.475  1.00 16.05           C  
ATOM    304  CE2 TYR A  39      13.690  -7.315 -21.589  1.00 15.64           C  
ATOM    305  CZ  TYR A  39      14.153  -6.234 -20.854  1.00 16.06           C  
ATOM    306  OH  TYR A  39      14.569  -5.087 -21.487  1.00 15.04           O  
ATOM    307  N   ALA A  40      13.240 -11.642 -16.506  1.00 14.29           N  
ATOM    308  CA  ALA A  40      12.712 -12.692 -15.653  1.00 13.91           C  
ATOM    309  C   ALA A  40      11.218 -12.402 -15.550  1.00 15.45           C  
ATOM    310  O   ALA A  40      10.813 -11.372 -15.009  1.00 13.20           O  
ATOM    311  CB  ALA A  40      13.365 -12.645 -14.277  1.00 13.53           C  
ATOM    312  N   ALA A  41      10.405 -13.299 -16.094  1.00 14.16           N  
ATOM    313  CA  ALA A  41       8.960 -13.112 -16.055  1.00 14.91           C  
ATOM    314  C   ALA A  41       8.361 -13.813 -14.846  1.00 14.50           C  
ATOM    315  O   ALA A  41       8.400 -15.035 -14.744  1.00 15.00           O  
ATOM    316  CB  ALA A  41       8.329 -13.641 -17.339  1.00 13.04           C  
ATOM    317  N   LYS A  42       7.817 -13.025 -13.924  1.00 14.14           N  
ATOM    318  CA  LYS A  42       7.193 -13.563 -12.720  1.00 13.93           C  
ATOM    319  C   LYS A  42       5.682 -13.636 -12.936  1.00 14.77           C  
ATOM    320  O   LYS A  42       5.016 -12.602 -13.021  1.00 15.41           O  
ATOM    321  CB  LYS A  42       7.502 -12.662 -11.520  1.00 12.90           C  
ATOM    322  CG  LYS A  42       6.986 -13.186 -10.182  1.00 14.44           C  
ATOM    323  CD  LYS A  42       7.394 -12.262  -9.041  1.00 15.39           C  
ATOM    324  CE  LYS A  42       6.889 -12.764  -7.695  1.00 15.77           C  
ATOM    325  NZ  LYS A  42       7.277 -11.828  -6.600  1.00 15.92           N  
ATOM    326  N   PHE A  43       5.152 -14.854 -13.034  1.00 14.90           N  
ATOM    327  CA  PHE A  43       3.714 -15.062 -13.227  1.00 15.60           C  
ATOM    328  C   PHE A  43       3.066 -15.223 -11.855  1.00 15.16           C  
ATOM    329  O   PHE A  43       3.346 -16.191 -11.152  1.00 15.62           O  
ATOM    330  CB  PHE A  43       3.450 -16.337 -14.042  1.00 15.85           C  
ATOM    331  CG  PHE A  43       3.991 -16.299 -15.444  1.00 16.66           C  
ATOM    332  CD1 PHE A  43       5.355 -16.432 -15.687  1.00 15.41           C  
ATOM    333  CD2 PHE A  43       3.131 -16.139 -16.526  1.00 15.65           C  
ATOM    334  CE1 PHE A  43       5.855 -16.410 -16.991  1.00 16.56           C  
ATOM    335  CE2 PHE A  43       3.620 -16.115 -17.833  1.00 16.46           C  
ATOM    336  CZ  PHE A  43       4.988 -16.251 -18.064  1.00 16.77           C  
ATOM    337  N   ILE A  44       2.207 -14.282 -11.476  1.00 15.68           N  
ATOM    338  CA  ILE A  44       1.531 -14.338 -10.180  1.00 15.83           C  
ATOM    339  C   ILE A  44       0.067 -14.720 -10.382  1.00 16.63           C  
ATOM    340  O   ILE A  44      -0.656 -14.081 -11.150  1.00 14.85           O  
ATOM    341  CB  ILE A  44       1.609 -12.975  -9.451  1.00 16.66           C  
ATOM    342  CG1 ILE A  44       3.074 -12.554  -9.290  1.00 16.71           C  
ATOM    343  CG2 ILE A  44       0.939 -13.074  -8.083  1.00 16.21           C  
ATOM    344  CD1 ILE A  44       3.286 -11.087  -8.918  1.00 18.76           C  
ATOM    345  N   LYS A  45      -0.362 -15.770  -9.690  1.00 17.39           N  
ATOM    346  CA  LYS A  45      -1.732 -16.253  -9.799  1.00 18.80           C  
ATOM    347  C   LYS A  45      -2.713 -15.315  -9.103  1.00 18.44           C  
ATOM    348  O   LYS A  45      -2.531 -14.959  -7.936  1.00 18.04           O  
ATOM    349  CB  LYS A  45      -1.838 -17.651  -9.187  1.00 20.56           C  
ATOM    350  CG  LYS A  45      -3.106 -18.395  -9.554  1.00 27.36           C  
ATOM    351  CD  LYS A  45      -3.140 -18.726 -11.046  1.00 32.97           C  
ATOM    352  CE  LYS A  45      -1.969 -19.619 -11.447  1.00 35.37           C  
ATOM    353  NZ  LYS A  45      -1.950 -19.902 -12.912  1.00 36.19           N  
ATOM    354  N   LYS A  46      -3.754 -14.918  -9.831  1.00 18.29           N  
ATOM    355  CA  LYS A  46      -4.782 -14.027  -9.301  1.00 19.34           C  
ATOM    356  C   LYS A  46      -5.835 -14.813  -8.529  1.00 21.57           C  
ATOM    357  O   LYS A  46      -6.013 -16.012  -8.745  1.00 20.22           O  
ATOM    358  CB  LYS A  46      -5.503 -13.301 -10.438  1.00 18.40           C  
ATOM    359  CG  LYS A  46      -4.669 -12.334 -11.249  1.00 18.59           C  
ATOM    360  CD  LYS A  46      -5.520 -11.751 -12.372  1.00 18.85           C  
ATOM    361  CE  LYS A  46      -4.748 -10.752 -13.211  1.00 19.00           C  
ATOM    362  NZ  LYS A  46      -5.598 -10.162 -14.283  1.00 18.68           N  
ATOM    363  N   ARG A  47      -6.541 -14.129  -7.636  1.00 25.64           N  
ATOM    364  CA  ARG A  47      -7.617 -14.770  -6.891  1.00 29.78           C  
ATOM    365  C   ARG A  47      -8.829 -14.819  -7.817  1.00 31.18           C  
ATOM    366  O   ARG A  47      -9.092 -13.861  -8.548  1.00 31.39           O  
ATOM    367  CB  ARG A  47      -7.958 -13.972  -5.632  1.00 31.22           C  
ATOM    368  CG  ARG A  47      -6.953 -14.155  -4.520  1.00 36.07           C  
ATOM    369  CD  ARG A  47      -7.456 -13.596  -3.201  1.00 37.16           C  
ATOM    370  NE  ARG A  47      -6.574 -13.983  -2.104  1.00 39.51           N  
ATOM    371  CZ  ARG A  47      -6.666 -13.511  -0.866  1.00 39.94           C  
ATOM    372  NH1 ARG A  47      -7.605 -12.629  -0.556  1.00 40.60           N  
ATOM    373  NH2 ARG A  47      -5.814 -13.926   0.063  1.00 43.10           N  
ATOM    374  N   ARG A  48      -9.555 -15.934  -7.799  1.00 33.55           N  
ATOM    375  CA  ARG A  48     -10.733 -16.099  -8.646  1.00 37.50           C  
ATOM    376  C   ARG A  48     -11.995 -15.523  -8.013  1.00 38.00           C  
ATOM    377  O   ARG A  48     -12.981 -15.280  -8.705  1.00 37.63           O  
ATOM    378  CB  ARG A  48     -10.956 -17.577  -8.969  1.00 41.24           C  
ATOM    379  CG  ARG A  48     -10.935 -18.483  -7.748  1.00 46.41           C  
ATOM    380  CD  ARG A  48     -12.137 -19.415  -7.704  1.00 49.74           C  
ATOM    381  NE  ARG A  48     -11.961 -20.474  -6.713  1.00 52.74           N  
ATOM    382  CZ  ARG A  48     -11.801 -20.266  -5.409  1.00 54.26           C  
ATOM    383  NH1 ARG A  48     -11.797 -19.031  -4.927  1.00 54.78           N  
ATOM    384  NH2 ARG A  48     -11.638 -21.296  -4.588  1.00 54.87           N  
ATOM    385  N   THR A  49     -11.967 -15.321  -6.699  1.00 38.61           N  
ATOM    386  CA  THR A  49     -13.110 -14.752  -5.983  1.00 40.61           C  
ATOM    387  C   THR A  49     -12.588 -13.886  -4.841  1.00 41.97           C  
ATOM    388  O   THR A  49     -11.414 -13.973  -4.481  1.00 42.34           O  
ATOM    389  CB  THR A  49     -14.024 -15.851  -5.389  1.00 40.20           C  
ATOM    390  OG1 THR A  49     -13.354 -16.501  -4.304  1.00 39.18           O  
ATOM    391  CG2 THR A  49     -14.382 -16.885  -6.449  1.00 38.85           C  
ATOM    392  N   LYS A  50     -13.454 -13.054  -4.272  1.00 44.31           N  
ATOM    393  CA  LYS A  50     -13.054 -12.179  -3.173  1.00 46.75           C  
ATOM    394  C   LYS A  50     -12.659 -12.963  -1.926  1.00 47.67           C  
ATOM    395  O   LYS A  50     -11.673 -12.638  -1.264  1.00 47.64           O  
ATOM    396  CB  LYS A  50     -14.186 -11.207  -2.821  1.00 48.89           C  
ATOM    397  CG  LYS A  50     -14.481 -10.181  -3.898  1.00 50.71           C  
ATOM    398  CD  LYS A  50     -15.546  -9.192  -3.447  1.00 52.72           C  
ATOM    399  CE  LYS A  50     -15.810  -8.148  -4.522  1.00 52.93           C  
ATOM    400  NZ  LYS A  50     -16.828  -7.145  -4.100  1.00 54.07           N  
ATOM    401  N   SER A  51     -13.434 -13.996  -1.608  1.00 48.13           N  
ATOM    402  CA  SER A  51     -13.160 -14.821  -0.437  1.00 48.94           C  
ATOM    403  C   SER A  51     -12.457 -16.116  -0.829  1.00 49.43           C  
ATOM    404  O   SER A  51     -13.080 -17.176  -0.905  1.00 50.40           O  
ATOM    405  CB  SER A  51     -14.466 -15.144   0.293  1.00 48.83           C  
ATOM    406  OG  SER A  51     -15.379 -15.805  -0.567  1.00 48.22           O  
ATOM    407  N   SER A  52     -11.155 -16.026  -1.078  1.00 49.35           N  
ATOM    408  CA  SER A  52     -10.370 -17.192  -1.462  1.00 48.93           C  
ATOM    409  C   SER A  52      -8.962 -17.115  -0.884  1.00 48.55           C  
ATOM    410  O   SER A  52      -8.444 -16.026  -0.633  1.00 49.14           O  
ATOM    411  CB  SER A  52     -10.289 -17.293  -2.986  1.00 49.28           C  
ATOM    412  OG  SER A  52      -9.492 -18.396  -3.382  1.00 49.67           O  
ATOM    413  N   ARG A  53      -8.352 -18.277  -0.665  1.00 47.50           N  
ATOM    414  CA  ARG A  53      -6.995 -18.346  -0.132  1.00 46.26           C  
ATOM    415  C   ARG A  53      -6.030 -18.503  -1.298  1.00 43.70           C  
ATOM    416  O   ARG A  53      -4.892 -18.033  -1.249  1.00 43.95           O  
ATOM    417  CB  ARG A  53      -6.829 -19.546   0.806  1.00 48.46           C  
ATOM    418  CG  ARG A  53      -7.878 -19.660   1.892  1.00 52.11           C  
ATOM    419  CD  ARG A  53      -7.473 -20.677   2.969  1.00 54.55           C  
ATOM    420  NE  ARG A  53      -7.101 -21.989   2.436  1.00 56.75           N  
ATOM    421  CZ  ARG A  53      -5.872 -22.328   2.053  1.00 57.77           C  
ATOM    422  NH1 ARG A  53      -5.636 -23.547   1.582  1.00 58.43           N  
ATOM    423  NH2 ARG A  53      -4.876 -21.454   2.148  1.00 57.85           N  
ATOM    424  N   ARG A  54      -6.493 -19.178  -2.344  1.00 40.28           N  
ATOM    425  CA  ARG A  54      -5.680 -19.408  -3.528  1.00 37.56           C  
ATOM    426  C   ARG A  54      -5.469 -18.104  -4.289  1.00 34.45           C  
ATOM    427  O   ARG A  54      -6.379 -17.277  -4.395  1.00 33.80           O  
ATOM    428  CB  ARG A  54      -6.349 -20.428  -4.454  1.00 39.35           C  
ATOM    429  CG  ARG A  54      -6.518 -21.826  -3.864  1.00 43.55           C  
ATOM    430  CD  ARG A  54      -7.049 -22.780  -4.926  1.00 46.24           C  
ATOM    431  NE  ARG A  54      -8.341 -22.345  -5.455  1.00 49.88           N  
ATOM    432  CZ  ARG A  54      -8.771 -22.599  -6.689  1.00 51.26           C  
ATOM    433  NH1 ARG A  54      -8.012 -23.285  -7.533  1.00 51.49           N  
ATOM    434  NH2 ARG A  54      -9.962 -22.167  -7.080  1.00 52.04           N  
ATOM    435  N   GLY A  55      -4.261 -17.927  -4.811  1.00 30.08           N  
ATOM    436  CA  GLY A  55      -3.956 -16.728  -5.565  1.00 24.69           C  
ATOM    437  C   GLY A  55      -3.644 -15.530  -4.697  1.00 21.59           C  
ATOM    438  O   GLY A  55      -3.746 -15.582  -3.471  1.00 21.37           O  
ATOM    439  N   VAL A  56      -3.263 -14.440  -5.350  1.00 18.44           N  
ATOM    440  CA  VAL A  56      -2.912 -13.206  -4.671  1.00 18.23           C  
ATOM    441  C   VAL A  56      -3.961 -12.142  -4.975  1.00 18.01           C  
ATOM    442  O   VAL A  56      -4.390 -11.983  -6.121  1.00 18.22           O  
ATOM    443  CB  VAL A  56      -1.520 -12.714  -5.135  1.00 17.94           C  
ATOM    444  CG1 VAL A  56      -1.087 -11.511  -4.319  1.00 16.20           C  
ATOM    445  CG2 VAL A  56      -0.507 -13.849  -5.015  1.00 16.85           C  
ATOM    446  N   SER A  57      -4.382 -11.421  -3.941  1.00 18.96           N  
ATOM    447  CA  SER A  57      -5.382 -10.377  -4.104  1.00 17.49           C  
ATOM    448  C   SER A  57      -4.849  -9.271  -5.015  1.00 18.06           C  
ATOM    449  O   SER A  57      -3.645  -9.016  -5.064  1.00 16.87           O  
ATOM    450  CB  SER A  57      -5.752  -9.779  -2.744  1.00 17.86           C  
ATOM    451  OG  SER A  57      -4.737  -8.900  -2.288  1.00 17.39           O  
ATOM    452  N   ARG A  58      -5.759  -8.622  -5.732  1.00 18.35           N  
ATOM    453  CA  ARG A  58      -5.409  -7.534  -6.636  1.00 19.21           C  
ATOM    454  C   ARG A  58      -4.619  -6.472  -5.880  1.00 18.82           C  
ATOM    455  O   ARG A  58      -3.644  -5.916  -6.391  1.00 18.21           O  
ATOM    456  CB  ARG A  58      -6.684  -6.894  -7.197  1.00 23.06           C  
ATOM    457  CG  ARG A  58      -6.442  -5.815  -8.240  1.00 25.76           C  
ATOM    458  CD  ARG A  58      -6.289  -6.440  -9.608  1.00 26.74           C  
ATOM    459  NE  ARG A  58      -5.833  -5.492 -10.622  1.00 26.09           N  
ATOM    460  CZ  ARG A  58      -5.647  -5.821 -11.897  1.00 24.73           C  
ATOM    461  NH1 ARG A  58      -5.889  -7.061 -12.295  1.00 24.76           N  
ATOM    462  NH2 ARG A  58      -5.198  -4.926 -12.766  1.00 20.54           N  
ATOM    463  N   GLU A  59      -5.060  -6.188  -4.660  1.00 18.72           N  
ATOM    464  CA  GLU A  59      -4.419  -5.186  -3.824  1.00 19.14           C  
ATOM    465  C   GLU A  59      -2.957  -5.528  -3.565  1.00 17.89           C  
ATOM    466  O   GLU A  59      -2.088  -4.665  -3.657  1.00 17.46           O  
ATOM    467  CB  GLU A  59      -5.160  -5.068  -2.491  1.00 24.60           C  
ATOM    468  CG  GLU A  59      -4.647  -3.956  -1.592  1.00 29.74           C  
ATOM    469  CD  GLU A  59      -5.315  -3.957  -0.231  1.00 35.45           C  
ATOM    470  OE1 GLU A  59      -6.564  -3.927  -0.180  1.00 37.98           O  
ATOM    471  OE2 GLU A  59      -4.591  -3.985   0.789  1.00 38.30           O  
ATOM    472  N   ASP A  60      -2.685  -6.785  -3.242  1.00 16.91           N  
ATOM    473  CA  ASP A  60      -1.314  -7.194  -2.979  1.00 16.90           C  
ATOM    474  C   ASP A  60      -0.460  -7.192  -4.246  1.00 16.27           C  
ATOM    475  O   ASP A  60       0.734  -6.894  -4.197  1.00 16.30           O  
ATOM    476  CB  ASP A  60      -1.288  -8.574  -2.315  1.00 16.96           C  
ATOM    477  CG  ASP A  60      -1.839  -8.546  -0.898  1.00 20.02           C  
ATOM    478  OD1 ASP A  60      -1.952  -7.440  -0.328  1.00 19.23           O  
ATOM    479  OD2 ASP A  60      -2.148  -9.628  -0.352  1.00 21.37           O  
ATOM    480  N   ILE A  61      -1.060  -7.519  -5.387  1.00 15.80           N  
ATOM    481  CA  ILE A  61      -0.297  -7.528  -6.630  1.00 14.91           C  
ATOM    482  C   ILE A  61       0.039  -6.095  -7.024  1.00 14.95           C  
ATOM    483  O   ILE A  61       1.181  -5.788  -7.382  1.00 14.12           O  
ATOM    484  CB  ILE A  61      -1.085  -8.204  -7.791  1.00 15.21           C  
ATOM    485  CG1 ILE A  61      -1.392  -9.663  -7.434  1.00 17.52           C  
ATOM    486  CG2 ILE A  61      -0.258  -8.161  -9.077  1.00 15.43           C  
ATOM    487  CD1 ILE A  61      -2.460 -10.328  -8.301  1.00 19.54           C  
ATOM    488  N   GLU A  62      -0.949  -5.211  -6.940  1.00 15.98           N  
ATOM    489  CA  GLU A  62      -0.733  -3.816  -7.305  1.00 16.12           C  
ATOM    490  C   GLU A  62       0.281  -3.136  -6.392  1.00 15.78           C  
ATOM    491  O   GLU A  62       1.004  -2.239  -6.823  1.00 14.73           O  
ATOM    492  CB  GLU A  62      -2.058  -3.048  -7.293  1.00 17.05           C  
ATOM    493  CG  GLU A  62      -3.076  -3.600  -8.283  1.00 20.88           C  
ATOM    494  CD  GLU A  62      -4.337  -2.755  -8.367  1.00 25.16           C  
ATOM    495  OE1 GLU A  62      -4.593  -1.977  -7.424  1.00 30.18           O  
ATOM    496  OE2 GLU A  62      -5.078  -2.879  -9.366  1.00 22.94           O  
ATOM    497  N   ARG A  63       0.340  -3.564  -5.134  1.00 15.04           N  
ATOM    498  CA  ARG A  63       1.303  -2.978  -4.205  1.00 16.43           C  
ATOM    499  C   ARG A  63       2.720  -3.345  -4.648  1.00 14.42           C  
ATOM    500  O   ARG A  63       3.602  -2.488  -4.692  1.00 15.44           O  
ATOM    501  CB  ARG A  63       1.068  -3.477  -2.774  1.00 16.22           C  
ATOM    502  CG  ARG A  63       2.055  -2.868  -1.777  1.00 20.68           C  
ATOM    503  CD  ARG A  63       1.849  -3.361  -0.355  1.00 20.52           C  
ATOM    504  NE  ARG A  63       0.524  -3.031   0.159  1.00 24.40           N  
ATOM    505  CZ  ARG A  63      -0.466  -3.908   0.294  1.00 24.32           C  
ATOM    506  NH1 ARG A  63      -0.280  -5.178  -0.044  1.00 23.98           N  
ATOM    507  NH2 ARG A  63      -1.643  -3.514   0.764  1.00 25.72           N  
ATOM    508  N   GLU A  64       2.935  -4.615  -4.978  1.00 13.50           N  
ATOM    509  CA  GLU A  64       4.256  -5.059  -5.423  1.00 14.96           C  
ATOM    510  C   GLU A  64       4.653  -4.311  -6.700  1.00 14.76           C  
ATOM    511  O   GLU A  64       5.792  -3.856  -6.840  1.00 14.44           O  
ATOM    512  CB  GLU A  64       4.265  -6.578  -5.684  1.00 16.03           C  
ATOM    513  CG  GLU A  64       5.662  -7.144  -5.982  1.00 17.15           C  
ATOM    514  CD  GLU A  64       5.690  -8.655  -6.222  1.00 18.42           C  
ATOM    515  OE1 GLU A  64       4.734  -9.356  -5.832  1.00 20.17           O  
ATOM    516  OE2 GLU A  64       6.691  -9.149  -6.789  1.00 19.55           O  
ATOM    517  N   VAL A  65       3.712  -4.183  -7.631  1.00 14.40           N  
ATOM    518  CA  VAL A  65       3.987  -3.487  -8.887  1.00 14.15           C  
ATOM    519  C   VAL A  65       4.306  -2.011  -8.655  1.00 14.26           C  
ATOM    520  O   VAL A  65       5.256  -1.472  -9.233  1.00 13.99           O  
ATOM    521  CB  VAL A  65       2.786  -3.574  -9.863  1.00 13.54           C  
ATOM    522  CG1 VAL A  65       3.035  -2.668 -11.071  1.00 13.71           C  
ATOM    523  CG2 VAL A  65       2.580  -5.021 -10.317  1.00 12.70           C  
ATOM    524  N   SER A  66       3.507  -1.366  -7.811  1.00 15.71           N  
ATOM    525  CA  SER A  66       3.687   0.049  -7.504  1.00 18.56           C  
ATOM    526  C   SER A  66       5.058   0.328  -6.886  1.00 17.94           C  
ATOM    527  O   SER A  66       5.713   1.319  -7.216  1.00 18.43           O  
ATOM    528  CB  SER A  66       2.584   0.518  -6.555  1.00 20.09           C  
ATOM    529  OG  SER A  66       2.757   1.883  -6.214  1.00 26.62           O  
ATOM    530  N   ILE A  67       5.486  -0.543  -5.983  1.00 17.19           N  
ATOM    531  CA  ILE A  67       6.786  -0.377  -5.346  1.00 17.12           C  
ATOM    532  C   ILE A  67       7.891  -0.590  -6.378  1.00 17.18           C  
ATOM    533  O   ILE A  67       8.815   0.217  -6.483  1.00 16.63           O  
ATOM    534  CB  ILE A  67       6.946  -1.360  -4.170  1.00 18.23           C  
ATOM    535  CG1 ILE A  67       5.971  -0.968  -3.057  1.00 19.80           C  
ATOM    536  CG2 ILE A  67       8.384  -1.351  -3.663  1.00 19.07           C  
ATOM    537  CD1 ILE A  67       6.146   0.434  -2.406  1.00 27.80           C  
ATOM    538  N   LEU A  68       7.784  -1.665  -7.154  1.00 15.83           N  
ATOM    539  CA  LEU A  68       8.778  -1.961  -8.175  1.00 16.10           C  
ATOM    540  C   LEU A  68       8.931  -0.835  -9.198  1.00 17.50           C  
ATOM    541  O   LEU A  68      10.040  -0.531  -9.624  1.00 17.75           O  
ATOM    542  CB  LEU A  68       8.425  -3.267  -8.902  1.00 16.22           C  
ATOM    543  CG  LEU A  68       8.775  -4.576  -8.188  1.00 17.61           C  
ATOM    544  CD1 LEU A  68       8.122  -5.758  -8.900  1.00 17.45           C  
ATOM    545  CD2 LEU A  68      10.295  -4.736  -8.154  1.00 18.59           C  
ATOM    546  N   LYS A  69       7.823  -0.215  -9.594  1.00 18.27           N  
ATOM    547  CA  LYS A  69       7.888   0.860 -10.581  1.00 21.03           C  
ATOM    548  C   LYS A  69       8.664   2.079 -10.102  1.00 22.61           C  
ATOM    549  O   LYS A  69       9.225   2.824 -10.904  1.00 23.97           O  
ATOM    550  CB  LYS A  69       6.480   1.300 -10.996  1.00 21.37           C  
ATOM    551  CG  LYS A  69       5.809   0.364 -11.984  1.00 25.40           C  
ATOM    552  CD  LYS A  69       4.527   0.967 -12.534  1.00 29.00           C  
ATOM    553  CE  LYS A  69       3.970   0.124 -13.669  1.00 31.62           C  
ATOM    554  NZ  LYS A  69       2.688   0.671 -14.190  1.00 35.62           N  
ATOM    555  N   GLU A  70       8.702   2.277  -8.793  1.00 23.67           N  
ATOM    556  CA  GLU A  70       9.391   3.426  -8.222  1.00 24.90           C  
ATOM    557  C   GLU A  70      10.896   3.260  -8.027  1.00 24.13           C  
ATOM    558  O   GLU A  70      11.626   4.250  -7.973  1.00 24.89           O  
ATOM    559  CB  GLU A  70       8.734   3.792  -6.883  1.00 26.75           C  
ATOM    560  CG  GLU A  70       9.533   4.755  -6.019  1.00 31.57           C  
ATOM    561  CD  GLU A  70       8.746   5.254  -4.822  1.00 32.58           C  
ATOM    562  OE1 GLU A  70       8.065   4.437  -4.170  1.00 32.23           O  
ATOM    563  OE2 GLU A  70       8.815   6.467  -4.528  1.00 36.36           O  
ATOM    564  N   ILE A  71      11.372   2.023  -7.949  1.00 22.01           N  
ATOM    565  CA  ILE A  71      12.791   1.806  -7.697  1.00 21.08           C  
ATOM    566  C   ILE A  71      13.742   1.656  -8.881  1.00 20.72           C  
ATOM    567  O   ILE A  71      13.421   1.058  -9.906  1.00 19.39           O  
ATOM    568  CB  ILE A  71      13.001   0.599  -6.737  1.00 21.63           C  
ATOM    569  CG1 ILE A  71      12.548  -0.702  -7.401  1.00 21.77           C  
ATOM    570  CG2 ILE A  71      12.208   0.817  -5.455  1.00 20.82           C  
ATOM    571  CD1 ILE A  71      13.045  -1.978  -6.723  1.00 24.00           C  
ATOM    572  N   GLN A  72      14.929   2.229  -8.714  1.00 19.05           N  
ATOM    573  CA  GLN A  72      15.985   2.159  -9.716  1.00 18.80           C  
ATOM    574  C   GLN A  72      17.282   2.361  -8.949  1.00 17.43           C  
ATOM    575  O   GLN A  72      17.606   3.480  -8.545  1.00 15.72           O  
ATOM    576  CB  GLN A  72      15.818   3.254 -10.771  1.00 23.01           C  
ATOM    577  CG  GLN A  72      16.890   3.224 -11.863  1.00 28.33           C  
ATOM    578  CD  GLN A  72      16.828   1.967 -12.712  1.00 31.77           C  
ATOM    579  OE1 GLN A  72      15.841   1.717 -13.406  1.00 34.56           O  
ATOM    580  NE2 GLN A  72      17.887   1.167 -12.660  1.00 34.38           N  
ATOM    581  N   HIS A  73      18.004   1.266  -8.732  1.00 15.08           N  
ATOM    582  CA  HIS A  73      19.264   1.293  -7.991  1.00 14.65           C  
ATOM    583  C   HIS A  73      20.059   0.036  -8.354  1.00 14.20           C  
ATOM    584  O   HIS A  73      19.474  -1.018  -8.624  1.00 14.86           O  
ATOM    585  CB  HIS A  73      18.964   1.335  -6.483  1.00 15.42           C  
ATOM    586  CG  HIS A  73      20.182   1.477  -5.623  1.00 15.44           C  
ATOM    587  ND1 HIS A  73      21.030   0.426  -5.351  1.00 15.87           N  
ATOM    588  CD2 HIS A  73      20.714   2.559  -5.007  1.00 16.11           C  
ATOM    589  CE1 HIS A  73      22.034   0.854  -4.604  1.00 16.51           C  
ATOM    590  NE2 HIS A  73      21.866   2.146  -4.382  1.00 16.66           N  
ATOM    591  N   PRO A  74      21.400   0.128  -8.370  1.00 13.67           N  
ATOM    592  CA  PRO A  74      22.235  -1.029  -8.714  1.00 14.47           C  
ATOM    593  C   PRO A  74      21.977  -2.294  -7.903  1.00 14.13           C  
ATOM    594  O   PRO A  74      22.130  -3.410  -8.411  1.00 14.20           O  
ATOM    595  CB  PRO A  74      23.652  -0.507  -8.495  1.00 16.57           C  
ATOM    596  CG  PRO A  74      23.533   0.928  -8.841  1.00 16.85           C  
ATOM    597  CD  PRO A  74      22.238   1.323  -8.160  1.00 14.68           C  
ATOM    598  N   ASN A  75      21.581  -2.130  -6.647  1.00 13.32           N  
ATOM    599  CA  ASN A  75      21.364  -3.291  -5.798  1.00 13.09           C  
ATOM    600  C   ASN A  75      19.926  -3.750  -5.611  1.00 13.25           C  
ATOM    601  O   ASN A  75      19.630  -4.505  -4.683  1.00 13.37           O  
ATOM    602  CB  ASN A  75      22.036  -3.055  -4.444  1.00 14.05           C  
ATOM    603  CG  ASN A  75      23.532  -2.870  -4.578  1.00 14.27           C  
ATOM    604  OD1 ASN A  75      24.087  -1.862  -4.143  1.00 14.40           O  
ATOM    605  ND2 ASN A  75      24.196  -3.847  -5.194  1.00 13.78           N  
ATOM    606  N   VAL A  76      19.034  -3.299  -6.488  1.00 13.60           N  
ATOM    607  CA  VAL A  76      17.639  -3.727  -6.433  1.00 15.35           C  
ATOM    608  C   VAL A  76      17.181  -4.030  -7.852  1.00 15.28           C  
ATOM    609  O   VAL A  76      17.669  -3.442  -8.818  1.00 14.58           O  
ATOM    610  CB  VAL A  76      16.693  -2.654  -5.836  1.00 16.04           C  
ATOM    611  CG1 VAL A  76      17.200  -2.207  -4.476  1.00 14.41           C  
ATOM    612  CG2 VAL A  76      16.557  -1.487  -6.794  1.00 18.30           C  
ATOM    613  N   ILE A  77      16.242  -4.957  -7.968  1.00 15.72           N  
ATOM    614  CA  ILE A  77      15.719  -5.351  -9.261  1.00 18.74           C  
ATOM    615  C   ILE A  77      14.793  -4.261  -9.793  1.00 19.86           C  
ATOM    616  O   ILE A  77      14.195  -3.508  -9.021  1.00 17.26           O  
ATOM    617  CB  ILE A  77      14.960  -6.696  -9.138  1.00 21.76           C  
ATOM    618  CG1 ILE A  77      14.887  -7.367 -10.499  1.00 26.20           C  
ATOM    619  CG2 ILE A  77      13.590  -6.489  -8.546  1.00 23.53           C  
ATOM    620  CD1 ILE A  77      13.821  -6.905 -11.445  1.00 31.32           C  
ATOM    621  N   THR A  78      14.691  -4.167 -11.113  1.00 21.23           N  
ATOM    622  CA  THR A  78      13.828  -3.169 -11.724  1.00 21.89           C  
ATOM    623  C   THR A  78      12.696  -3.810 -12.517  1.00 20.67           C  
ATOM    624  O   THR A  78      12.816  -4.941 -12.980  1.00 21.95           O  
ATOM    625  CB  THR A  78      14.610  -2.268 -12.664  1.00 23.25           C  
ATOM    626  OG1 THR A  78      15.348  -3.064 -13.598  1.00 27.28           O  
ATOM    627  CG2 THR A  78      15.538  -1.381 -11.902  1.00 23.80           C  
ATOM    628  N   LEU A  79      11.602  -3.072 -12.673  1.00 17.88           N  
ATOM    629  CA  LEU A  79      10.442  -3.562 -13.410  1.00 18.17           C  
ATOM    630  C   LEU A  79      10.481  -3.045 -14.848  1.00 17.41           C  
ATOM    631  O   LEU A  79      10.590  -1.840 -15.076  1.00 16.88           O  
ATOM    632  CB  LEU A  79       9.153  -3.089 -12.732  1.00 18.25           C  
ATOM    633  CG  LEU A  79       7.845  -3.506 -13.417  1.00 19.86           C  
ATOM    634  CD1 LEU A  79       7.680  -5.015 -13.335  1.00 17.49           C  
ATOM    635  CD2 LEU A  79       6.670  -2.807 -12.749  1.00 21.21           C  
ATOM    636  N   HIS A  80      10.382  -3.956 -15.812  1.00 14.88           N  
ATOM    637  CA  HIS A  80      10.412  -3.575 -17.220  1.00 15.87           C  
ATOM    638  C   HIS A  80       9.006  -3.337 -17.768  1.00 16.20           C  
ATOM    639  O   HIS A  80       8.731  -2.289 -18.361  1.00 16.05           O  
ATOM    640  CB  HIS A  80      11.106  -4.659 -18.045  1.00 14.05           C  
ATOM    641  CG  HIS A  80      11.317  -4.283 -19.477  1.00 14.34           C  
ATOM    642  ND1 HIS A  80      10.905  -5.079 -20.526  1.00 17.81           N  
ATOM    643  CD2 HIS A  80      11.897  -3.194 -20.036  1.00 14.19           C  
ATOM    644  CE1 HIS A  80      11.221  -4.496 -21.669  1.00 16.93           C  
ATOM    645  NE2 HIS A  80      11.824  -3.351 -21.400  1.00 21.56           N  
ATOM    646  N   GLU A  81       8.124  -4.317 -17.571  1.00 15.31           N  
ATOM    647  CA  GLU A  81       6.735  -4.235 -18.032  1.00 16.45           C  
ATOM    648  C   GLU A  81       5.838  -5.096 -17.160  1.00 16.15           C  
ATOM    649  O   GLU A  81       6.321  -5.922 -16.385  1.00 13.95           O  
ATOM    650  CB  GLU A  81       6.574  -4.782 -19.449  1.00 18.05           C  
ATOM    651  CG  GLU A  81       7.186  -4.006 -20.571  1.00 19.68           C  
ATOM    652  CD  GLU A  81       6.469  -4.307 -21.866  1.00 22.05           C  
ATOM    653  OE1 GLU A  81       5.497  -3.589 -22.174  1.00 23.50           O  
ATOM    654  OE2 GLU A  81       6.853  -5.280 -22.556  1.00 21.95           O  
ATOM    655  N   VAL A  82       4.528  -4.909 -17.316  1.00 13.87           N  
ATOM    656  CA  VAL A  82       3.543  -5.710 -16.597  1.00 14.47           C  
ATOM    657  C   VAL A  82       2.397  -6.082 -17.542  1.00 14.28           C  
ATOM    658  O   VAL A  82       1.796  -5.212 -18.178  1.00 15.72           O  
ATOM    659  CB  VAL A  82       2.945  -4.963 -15.380  1.00 13.73           C  
ATOM    660  CG1 VAL A  82       1.981  -5.888 -14.635  1.00 12.46           C  
ATOM    661  CG2 VAL A  82       4.054  -4.506 -14.440  1.00 15.89           C  
ATOM    662  N   TYR A  83       2.126  -7.378 -17.656  1.00 13.37           N  
ATOM    663  CA  TYR A  83       1.034  -7.879 -18.490  1.00 15.37           C  
ATOM    664  C   TYR A  83       0.079  -8.607 -17.558  1.00 15.40           C  
ATOM    665  O   TYR A  83       0.410  -8.870 -16.399  1.00 15.95           O  
ATOM    666  CB  TYR A  83       1.530  -8.885 -19.530  1.00 15.62           C  
ATOM    667  CG  TYR A  83       2.347  -8.301 -20.653  1.00 17.13           C  
ATOM    668  CD1 TYR A  83       3.658  -7.878 -20.445  1.00 17.34           C  
ATOM    669  CD2 TYR A  83       1.801  -8.159 -21.928  1.00 16.44           C  
ATOM    670  CE1 TYR A  83       4.404  -7.324 -21.481  1.00 16.09           C  
ATOM    671  CE2 TYR A  83       2.536  -7.609 -22.971  1.00 16.05           C  
ATOM    672  CZ  TYR A  83       3.835  -7.190 -22.740  1.00 17.23           C  
ATOM    673  OH  TYR A  83       4.553  -6.614 -23.758  1.00 19.16           O  
ATOM    674  N   GLU A  84      -1.104  -8.939 -18.061  1.00 16.04           N  
ATOM    675  CA  GLU A  84      -2.062  -9.676 -17.255  1.00 14.79           C  
ATOM    676  C   GLU A  84      -3.129 -10.311 -18.136  1.00 16.62           C  
ATOM    677  O   GLU A  84      -3.366  -9.884 -19.265  1.00 16.66           O  
ATOM    678  CB  GLU A  84      -2.734  -8.758 -16.218  1.00 14.88           C  
ATOM    679  CG  GLU A  84      -3.851  -7.872 -16.772  1.00 15.19           C  
ATOM    680  CD  GLU A  84      -4.540  -7.057 -15.688  1.00 17.85           C  
ATOM    681  OE1 GLU A  84      -4.814  -7.617 -14.603  1.00 18.05           O  
ATOM    682  OE2 GLU A  84      -4.821  -5.861 -15.923  1.00 18.27           O  
ATOM    683  N   ASN A  85      -3.731 -11.368 -17.623  1.00 17.12           N  
ATOM    684  CA  ASN A  85      -4.817 -12.037 -18.311  1.00 18.65           C  
ATOM    685  C   ASN A  85      -5.738 -12.522 -17.200  1.00 19.87           C  
ATOM    686  O   ASN A  85      -5.539 -12.176 -16.033  1.00 19.82           O  
ATOM    687  CB  ASN A  85      -4.318 -13.205 -19.177  1.00 17.59           C  
ATOM    688  CG  ASN A  85      -3.449 -14.180 -18.413  1.00 19.40           C  
ATOM    689  OD1 ASN A  85      -3.727 -14.507 -17.262  1.00 19.07           O  
ATOM    690  ND2 ASN A  85      -2.394 -14.666 -19.064  1.00 20.80           N  
ATOM    691  N   LYS A  86      -6.736 -13.319 -17.554  1.00 20.81           N  
ATOM    692  CA  LYS A  86      -7.694 -13.819 -16.580  1.00 23.03           C  
ATOM    693  C   LYS A  86      -7.100 -14.541 -15.363  1.00 22.75           C  
ATOM    694  O   LYS A  86      -7.611 -14.409 -14.252  1.00 19.84           O  
ATOM    695  CB  LYS A  86      -8.688 -14.756 -17.280  1.00 26.47           C  
ATOM    696  CG  LYS A  86     -10.059 -14.152 -17.553  1.00 31.70           C  
ATOM    697  CD  LYS A  86     -10.797 -13.869 -16.252  1.00 34.72           C  
ATOM    698  CE  LYS A  86     -12.307 -13.864 -16.444  1.00 35.67           C  
ATOM    699  NZ  LYS A  86     -12.764 -12.822 -17.400  1.00 40.40           N  
ATOM    700  N   THR A  87      -6.018 -15.284 -15.564  1.00 22.03           N  
ATOM    701  CA  THR A  87      -5.433 -16.058 -14.471  1.00 23.05           C  
ATOM    702  C   THR A  87      -4.192 -15.517 -13.767  1.00 22.50           C  
ATOM    703  O   THR A  87      -3.983 -15.803 -12.583  1.00 21.72           O  
ATOM    704  CB  THR A  87      -5.101 -17.481 -14.944  1.00 24.80           C  
ATOM    705  OG1 THR A  87      -4.068 -17.417 -15.933  1.00 26.72           O  
ATOM    706  CG2 THR A  87      -6.337 -18.141 -15.552  1.00 25.54           C  
ATOM    707  N   ASP A  88      -3.372 -14.749 -14.483  1.00 21.62           N  
ATOM    708  CA  ASP A  88      -2.136 -14.215 -13.908  1.00 20.87           C  
ATOM    709  C   ASP A  88      -1.831 -12.769 -14.258  1.00 19.59           C  
ATOM    710  O   ASP A  88      -2.359 -12.215 -15.222  1.00 18.47           O  
ATOM    711  CB  ASP A  88      -0.917 -15.005 -14.400  1.00 23.57           C  
ATOM    712  CG  ASP A  88      -0.987 -16.474 -14.081  1.00 25.97           C  
ATOM    713  OD1 ASP A  88      -1.081 -16.825 -12.889  1.00 29.13           O  
ATOM    714  OD2 ASP A  88      -0.932 -17.278 -15.031  1.00 30.36           O  
ATOM    715  N   VAL A  89      -0.958 -12.177 -13.450  1.00 16.14           N  
ATOM    716  CA  VAL A  89      -0.438 -10.847 -13.715  1.00 16.80           C  
ATOM    717  C   VAL A  89       1.003 -11.268 -13.971  1.00 16.10           C  
ATOM    718  O   VAL A  89       1.558 -12.081 -13.223  1.00 17.68           O  
ATOM    719  CB  VAL A  89      -0.499  -9.903 -12.496  1.00 16.45           C  
ATOM    720  CG1 VAL A  89       0.218  -8.603 -12.823  1.00 14.72           C  
ATOM    721  CG2 VAL A  89      -1.942  -9.601 -12.146  1.00 16.77           C  
ATOM    722  N   ILE A  90       1.597 -10.767 -15.043  1.00 16.59           N  
ATOM    723  CA  ILE A  90       2.957 -11.152 -15.376  1.00 16.04           C  
ATOM    724  C   ILE A  90       3.903  -9.970 -15.275  1.00 16.16           C  
ATOM    725  O   ILE A  90       3.808  -9.029 -16.065  1.00 16.33           O  
ATOM    726  CB  ILE A  90       3.043 -11.720 -16.815  1.00 16.39           C  
ATOM    727  CG1 ILE A  90       2.038 -12.858 -17.001  1.00 20.55           C  
ATOM    728  CG2 ILE A  90       4.448 -12.248 -17.087  1.00 16.62           C  
ATOM    729  CD1 ILE A  90       0.603 -12.411 -17.237  1.00 22.59           C  
ATOM    730  N   LEU A  91       4.809 -10.014 -14.299  1.00 14.10           N  
ATOM    731  CA  LEU A  91       5.780  -8.941 -14.137  1.00 15.70           C  
ATOM    732  C   LEU A  91       7.054  -9.286 -14.903  1.00 15.68           C  
ATOM    733  O   LEU A  91       7.680 -10.322 -14.662  1.00 15.33           O  
ATOM    734  CB  LEU A  91       6.133  -8.732 -12.660  1.00 15.91           C  
ATOM    735  CG  LEU A  91       5.005  -8.455 -11.663  1.00 18.81           C  
ATOM    736  CD1 LEU A  91       5.617  -8.002 -10.338  1.00 19.02           C  
ATOM    737  CD2 LEU A  91       4.084  -7.385 -12.195  1.00 22.26           C  
ATOM    738  N   ILE A  92       7.427  -8.426 -15.841  1.00 14.78           N  
ATOM    739  CA  ILE A  92       8.649  -8.642 -16.601  1.00 13.25           C  
ATOM    740  C   ILE A  92       9.718  -7.900 -15.804  1.00 13.29           C  
ATOM    741  O   ILE A  92       9.785  -6.670 -15.833  1.00 15.09           O  
ATOM    742  CB  ILE A  92       8.535  -8.056 -18.016  1.00 14.60           C  
ATOM    743  CG1 ILE A  92       7.299  -8.626 -18.713  1.00 15.40           C  
ATOM    744  CG2 ILE A  92       9.794  -8.379 -18.812  1.00 14.13           C  
ATOM    745  CD1 ILE A  92       7.235 -10.166 -18.925  1.00 16.24           C  
ATOM    746  N   LEU A  93      10.541  -8.656 -15.083  1.00 13.43           N  
ATOM    747  CA  LEU A  93      11.571  -8.079 -14.226  1.00 14.11           C  
ATOM    748  C   LEU A  93      12.991  -8.157 -14.777  1.00 14.44           C  
ATOM    749  O   LEU A  93      13.302  -8.983 -15.633  1.00 13.15           O  
ATOM    750  CB  LEU A  93      11.556  -8.783 -12.863  1.00 13.96           C  
ATOM    751  CG  LEU A  93      10.217  -8.939 -12.143  1.00 15.52           C  
ATOM    752  CD1 LEU A  93      10.377  -9.936 -10.998  1.00 15.62           C  
ATOM    753  CD2 LEU A  93       9.731  -7.582 -11.637  1.00 15.83           C  
ATOM    754  N   GLU A  94      13.857  -7.293 -14.261  1.00 15.02           N  
ATOM    755  CA  GLU A  94      15.252  -7.313 -14.673  1.00 15.47           C  
ATOM    756  C   GLU A  94      15.769  -8.706 -14.311  1.00 15.40           C  
ATOM    757  O   GLU A  94      15.485  -9.222 -13.229  1.00 14.59           O  
ATOM    758  CB  GLU A  94      16.040  -6.237 -13.918  1.00 18.17           C  
ATOM    759  CG  GLU A  94      17.550  -6.362 -14.018  1.00 19.45           C  
ATOM    760  CD  GLU A  94      18.266  -5.252 -13.261  1.00 23.04           C  
ATOM    761  OE1 GLU A  94      17.730  -4.803 -12.227  1.00 22.38           O  
ATOM    762  OE2 GLU A  94      19.363  -4.837 -13.692  1.00 22.22           O  
ATOM    763  N   LEU A  95      16.504  -9.322 -15.227  1.00 14.39           N  
ATOM    764  CA  LEU A  95      17.043 -10.653 -14.992  1.00 16.39           C  
ATOM    765  C   LEU A  95      18.324 -10.627 -14.166  1.00 16.16           C  
ATOM    766  O   LEU A  95      19.206  -9.809 -14.405  1.00 18.28           O  
ATOM    767  CB  LEU A  95      17.334 -11.345 -16.328  1.00 15.60           C  
ATOM    768  CG  LEU A  95      18.006 -12.718 -16.243  1.00 16.06           C  
ATOM    769  CD1 LEU A  95      17.065 -13.708 -15.561  1.00 16.56           C  
ATOM    770  CD2 LEU A  95      18.371 -13.197 -17.642  1.00 17.46           C  
ATOM    771  N   VAL A  96      18.405 -11.519 -13.185  1.00 17.75           N  
ATOM    772  CA  VAL A  96      19.593 -11.662 -12.342  1.00 18.49           C  
ATOM    773  C   VAL A  96      19.901 -13.143 -12.546  1.00 18.46           C  
ATOM    774  O   VAL A  96      19.230 -14.012 -11.992  1.00 19.71           O  
ATOM    775  CB  VAL A  96      19.287 -11.359 -10.861  1.00 17.13           C  
ATOM    776  CG1 VAL A  96      20.583 -11.256 -10.084  1.00 18.03           C  
ATOM    777  CG2 VAL A  96      18.510 -10.052 -10.748  1.00 16.53           C  
ATOM    778  N   ALA A  97      20.918 -13.415 -13.354  1.00 19.47           N  
ATOM    779  CA  ALA A  97      21.262 -14.780 -13.735  1.00 21.42           C  
ATOM    780  C   ALA A  97      22.326 -15.535 -12.949  1.00 22.53           C  
ATOM    781  O   ALA A  97      22.759 -16.606 -13.384  1.00 23.21           O  
ATOM    782  CB  ALA A  97      21.624 -14.790 -15.211  1.00 21.95           C  
ATOM    783  N   GLY A  98      22.739 -15.004 -11.802  1.00 19.48           N  
ATOM    784  CA  GLY A  98      23.758 -15.674 -11.011  1.00 20.22           C  
ATOM    785  C   GLY A  98      23.223 -16.541  -9.881  1.00 19.73           C  
ATOM    786  O   GLY A  98      23.988 -17.023  -9.045  1.00 19.86           O  
ATOM    787  N   GLY A  99      21.909 -16.737  -9.849  1.00 19.87           N  
ATOM    788  CA  GLY A  99      21.309 -17.565  -8.817  1.00 20.78           C  
ATOM    789  C   GLY A  99      21.126 -16.911  -7.460  1.00 20.36           C  
ATOM    790  O   GLY A  99      21.579 -15.789  -7.225  1.00 20.03           O  
ATOM    791  N   GLU A 100      20.462 -17.635  -6.562  1.00 20.15           N  
ATOM    792  CA  GLU A 100      20.191 -17.155  -5.210  1.00 21.27           C  
ATOM    793  C   GLU A 100      21.419 -17.168  -4.312  1.00 20.82           C  
ATOM    794  O   GLU A 100      22.277 -18.044  -4.425  1.00 20.87           O  
ATOM    795  CB  GLU A 100      19.113 -18.017  -4.548  1.00 21.26           C  
ATOM    796  CG  GLU A 100      17.709 -17.850  -5.103  1.00 22.40           C  
ATOM    797  CD  GLU A 100      16.752 -18.880  -4.543  1.00 24.54           C  
ATOM    798  OE1 GLU A 100      17.064 -19.452  -3.473  1.00 25.85           O  
ATOM    799  OE2 GLU A 100      15.692 -19.114  -5.161  1.00 27.11           O  
ATOM    800  N   LEU A 101      21.496 -16.192  -3.418  1.00 20.92           N  
ATOM    801  CA  LEU A 101      22.594 -16.134  -2.465  1.00 21.31           C  
ATOM    802  C   LEU A 101      22.467 -17.419  -1.650  1.00 21.57           C  
ATOM    803  O   LEU A 101      23.455 -17.992  -1.202  1.00 20.36           O  
ATOM    804  CB  LEU A 101      22.440 -14.919  -1.546  1.00 21.36           C  
ATOM    805  CG  LEU A 101      23.426 -14.800  -0.380  1.00 22.51           C  
ATOM    806  CD1 LEU A 101      24.845 -14.662  -0.914  1.00 20.85           C  
ATOM    807  CD2 LEU A 101      23.054 -13.594   0.480  1.00 21.70           C  
ATOM    808  N   PHE A 102      21.227 -17.866  -1.473  1.00 21.49           N  
ATOM    809  CA  PHE A 102      20.948 -19.089  -0.730  1.00 22.21           C  
ATOM    810  C   PHE A 102      21.723 -20.272  -1.314  1.00 23.87           C  
ATOM    811  O   PHE A 102      22.322 -21.057  -0.585  1.00 20.61           O  
ATOM    812  CB  PHE A 102      19.452 -19.411  -0.780  1.00 25.23           C  
ATOM    813  CG  PHE A 102      19.095 -20.715  -0.123  1.00 27.52           C  
ATOM    814  CD1 PHE A 102      18.964 -20.799   1.259  1.00 27.90           C  
ATOM    815  CD2 PHE A 102      18.930 -21.871  -0.886  1.00 28.95           C  
ATOM    816  CE1 PHE A 102      18.676 -22.016   1.878  1.00 30.10           C  
ATOM    817  CE2 PHE A 102      18.642 -23.095  -0.277  1.00 29.50           C  
ATOM    818  CZ  PHE A 102      18.515 -23.167   1.107  1.00 28.95           C  
ATOM    819  N   ASP A 103      21.694 -20.401  -2.637  1.00 24.93           N  
ATOM    820  CA  ASP A 103      22.386 -21.503  -3.289  1.00 25.53           C  
ATOM    821  C   ASP A 103      23.898 -21.309  -3.300  1.00 26.15           C  
ATOM    822  O   ASP A 103      24.651 -22.277  -3.229  1.00 27.05           O  
ATOM    823  CB  ASP A 103      21.840 -21.691  -4.706  1.00 28.11           C  
ATOM    824  CG  ASP A 103      20.391 -22.151  -4.704  1.00 30.07           C  
ATOM    825  OD1 ASP A 103      20.098 -23.167  -4.038  1.00 31.00           O  
ATOM    826  OD2 ASP A 103      19.547 -21.504  -5.354  1.00 32.20           O  
ATOM    827  N   PHE A 104      24.337 -20.057  -3.373  1.00 25.65           N  
ATOM    828  CA  PHE A 104      25.760 -19.747  -3.369  1.00 26.55           C  
ATOM    829  C   PHE A 104      26.341 -20.166  -2.023  1.00 27.50           C  
ATOM    830  O   PHE A 104      27.398 -20.796  -1.959  1.00 27.37           O  
ATOM    831  CB  PHE A 104      25.966 -18.246  -3.594  1.00 26.02           C  
ATOM    832  CG  PHE A 104      27.409 -17.819  -3.627  1.00 27.97           C  
ATOM    833  CD1 PHE A 104      28.071 -17.454  -2.459  1.00 26.32           C  
ATOM    834  CD2 PHE A 104      28.103 -17.764  -4.834  1.00 28.23           C  
ATOM    835  CE1 PHE A 104      29.400 -17.035  -2.490  1.00 28.57           C  
ATOM    836  CE2 PHE A 104      29.435 -17.348  -4.878  1.00 27.62           C  
ATOM    837  CZ  PHE A 104      30.086 -16.981  -3.704  1.00 28.51           C  
ATOM    838  N   LEU A 105      25.634 -19.823  -0.950  1.00 27.12           N  
ATOM    839  CA  LEU A 105      26.070 -20.160   0.400  1.00 28.32           C  
ATOM    840  C   LEU A 105      26.061 -21.667   0.631  1.00 30.48           C  
ATOM    841  O   LEU A 105      26.912 -22.200   1.344  1.00 29.22           O  
ATOM    842  CB  LEU A 105      25.169 -19.476   1.434  1.00 26.65           C  
ATOM    843  CG  LEU A 105      25.197 -17.944   1.455  1.00 27.47           C  
ATOM    844  CD1 LEU A 105      24.162 -17.420   2.446  1.00 26.66           C  
ATOM    845  CD2 LEU A 105      26.592 -17.463   1.832  1.00 28.88           C  
ATOM    846  N   ALA A 106      25.097 -22.353   0.027  1.00 32.36           N  
ATOM    847  CA  ALA A 106      24.994 -23.798   0.185  1.00 36.64           C  
ATOM    848  C   ALA A 106      26.200 -24.506  -0.422  1.00 39.56           C  
ATOM    849  O   ALA A 106      26.593 -25.579   0.036  1.00 41.22           O  
ATOM    850  CB  ALA A 106      23.710 -24.307  -0.462  1.00 34.91           C  
ATOM    851  N   GLU A 107      26.793 -23.897  -1.443  1.00 43.09           N  
ATOM    852  CA  GLU A 107      27.941 -24.491  -2.116  1.00 47.25           C  
ATOM    853  C   GLU A 107      29.296 -24.103  -1.530  1.00 49.28           C  
ATOM    854  O   GLU A 107      30.301 -24.756  -1.812  1.00 50.78           O  
ATOM    855  CB  GLU A 107      27.902 -24.140  -3.605  1.00 48.31           C  
ATOM    856  CG  GLU A 107      26.641 -24.625  -4.305  1.00 52.10           C  
ATOM    857  CD  GLU A 107      26.601 -24.260  -5.776  1.00 54.38           C  
ATOM    858  OE1 GLU A 107      27.521 -24.670  -6.518  1.00 55.93           O  
ATOM    859  OE2 GLU A 107      25.648 -23.564  -6.192  1.00 55.47           O  
ATOM    860  N   LYS A 108      29.332 -23.056  -0.712  1.00 51.08           N  
ATOM    861  CA  LYS A 108      30.593 -22.615  -0.118  1.00 52.24           C  
ATOM    862  C   LYS A 108      30.694 -22.811   1.396  1.00 52.66           C  
ATOM    863  O   LYS A 108      31.770 -22.643   1.979  1.00 53.03           O  
ATOM    864  CB  LYS A 108      30.845 -21.142  -0.453  1.00 52.75           C  
ATOM    865  CG  LYS A 108      31.060 -20.878  -1.933  1.00 54.38           C  
ATOM    866  CD  LYS A 108      31.656 -19.498  -2.171  1.00 55.35           C  
ATOM    867  CE  LYS A 108      33.035 -19.370  -1.537  1.00 56.20           C  
ATOM    868  NZ  LYS A 108      33.656 -18.045  -1.817  1.00 56.88           N  
ATOM    869  N   GLU A 109      29.580 -23.166   2.026  1.00 52.12           N  
ATOM    870  CA  GLU A 109      29.544 -23.377   3.472  1.00 52.13           C  
ATOM    871  C   GLU A 109      29.791 -22.091   4.263  1.00 51.53           C  
ATOM    872  O   GLU A 109      28.845 -21.471   4.759  1.00 52.64           O  
ATOM    873  N   SER A 110      31.054 -21.685   4.381  1.00 49.48           N  
ATOM    874  CA  SER A 110      31.374 -20.479   5.138  1.00 46.90           C  
ATOM    875  C   SER A 110      32.305 -19.490   4.431  1.00 43.40           C  
ATOM    876  O   SER A 110      33.235 -19.883   3.725  1.00 43.80           O  
ATOM    877  CB  SER A 110      31.956 -20.857   6.503  1.00 48.09           C  
ATOM    878  OG  SER A 110      31.823 -19.786   7.421  1.00 48.88           O  
ATOM    879  N   LEU A 111      32.045 -18.202   4.648  1.00 39.10           N  
ATOM    880  CA  LEU A 111      32.820 -17.120   4.037  1.00 34.49           C  
ATOM    881  C   LEU A 111      33.743 -16.424   5.034  1.00 31.66           C  
ATOM    882  O   LEU A 111      33.619 -16.608   6.243  1.00 31.01           O  
ATOM    883  CB  LEU A 111      31.876 -16.065   3.464  1.00 33.23           C  
ATOM    884  CG  LEU A 111      30.711 -16.509   2.583  1.00 33.02           C  
ATOM    885  CD1 LEU A 111      29.738 -15.349   2.435  1.00 32.53           C  
ATOM    886  CD2 LEU A 111      31.220 -16.977   1.230  1.00 32.00           C  
ATOM    887  N   THR A 112      34.660 -15.614   4.512  1.00 28.88           N  
ATOM    888  CA  THR A 112      35.583 -14.846   5.344  1.00 26.28           C  
ATOM    889  C   THR A 112      34.827 -13.565   5.692  1.00 25.43           C  
ATOM    890  O   THR A 112      33.816 -13.266   5.057  1.00 24.35           O  
ATOM    891  CB  THR A 112      36.852 -14.464   4.565  1.00 25.12           C  
ATOM    892  OG1 THR A 112      36.489 -13.662   3.436  1.00 22.13           O  
ATOM    893  CG2 THR A 112      37.579 -15.705   4.073  1.00 25.28           C  
ATOM    894  N   GLU A 113      35.296 -12.807   6.684  1.00 23.97           N  
ATOM    895  CA  GLU A 113      34.604 -11.570   7.046  1.00 24.58           C  
ATOM    896  C   GLU A 113      34.633 -10.598   5.877  1.00 24.34           C  
ATOM    897  O   GLU A 113      33.728  -9.780   5.716  1.00 24.51           O  
ATOM    898  CB  GLU A 113      35.234 -10.918   8.288  1.00 23.96           C  
ATOM    899  CG  GLU A 113      35.213 -11.819   9.509  1.00 24.80           C  
ATOM    900  CD  GLU A 113      35.529 -11.102  10.816  1.00 24.72           C  
ATOM    901  OE1 GLU A 113      35.870 -11.806  11.789  1.00 23.76           O  
ATOM    902  OE2 GLU A 113      35.428  -9.854  10.885  1.00 21.13           O  
ATOM    903  N   GLU A 114      35.674 -10.691   5.054  1.00 25.36           N  
ATOM    904  CA  GLU A 114      35.795  -9.818   3.891  1.00 25.62           C  
ATOM    905  C   GLU A 114      34.730 -10.186   2.860  1.00 24.09           C  
ATOM    906  O   GLU A 114      34.054  -9.308   2.311  1.00 23.20           O  
ATOM    907  CB  GLU A 114      37.190  -9.945   3.278  1.00 31.32           C  
ATOM    908  CG  GLU A 114      38.314  -9.499   4.214  1.00 39.99           C  
ATOM    909  CD  GLU A 114      38.344  -7.997   4.435  1.00 45.29           C  
ATOM    910  OE1 GLU A 114      38.726  -7.262   3.497  1.00 47.96           O  
ATOM    911  OE2 GLU A 114      37.983  -7.549   5.547  1.00 48.21           O  
ATOM    912  N   GLU A 115      34.581 -11.483   2.599  1.00 22.46           N  
ATOM    913  CA  GLU A 115      33.583 -11.950   1.644  1.00 23.75           C  
ATOM    914  C   GLU A 115      32.196 -11.611   2.186  1.00 22.43           C  
ATOM    915  O   GLU A 115      31.303 -11.208   1.437  1.00 22.03           O  
ATOM    916  CB  GLU A 115      33.690 -13.464   1.442  1.00 26.77           C  
ATOM    917  CG  GLU A 115      35.003 -13.943   0.839  1.00 30.16           C  
ATOM    918  CD  GLU A 115      35.043 -15.452   0.677  1.00 33.48           C  
ATOM    919  OE1 GLU A 115      34.767 -16.160   1.669  1.00 33.55           O  
ATOM    920  OE2 GLU A 115      35.355 -15.931  -0.437  1.00 35.61           O  
ATOM    921  N   ALA A 116      32.022 -11.773   3.494  1.00 21.81           N  
ATOM    922  CA  ALA A 116      30.743 -11.479   4.128  1.00 20.73           C  
ATOM    923  C   ALA A 116      30.405  -9.997   3.997  1.00 20.65           C  
ATOM    924  O   ALA A 116      29.297  -9.645   3.595  1.00 21.21           O  
ATOM    925  CB  ALA A 116      30.775 -11.884   5.607  1.00 19.94           C  
ATOM    926  N   THR A 117      31.356  -9.127   4.329  1.00 20.12           N  
ATOM    927  CA  THR A 117      31.104  -7.691   4.246  1.00 21.34           C  
ATOM    928  C   THR A 117      30.941  -7.210   2.809  1.00 20.27           C  
ATOM    929  O   THR A 117      30.278  -6.207   2.565  1.00 19.99           O  
ATOM    930  CB  THR A 117      32.213  -6.866   4.945  1.00 21.06           C  
ATOM    931  OG1 THR A 117      33.492  -7.201   4.399  1.00 24.10           O  
ATOM    932  CG2 THR A 117      32.218  -7.151   6.434  1.00 22.59           C  
ATOM    933  N   GLU A 118      31.543  -7.921   1.859  1.00 21.63           N  
ATOM    934  CA  GLU A 118      31.411  -7.553   0.450  1.00 22.37           C  
ATOM    935  C   GLU A 118      29.952  -7.699   0.052  1.00 22.13           C  
ATOM    936  O   GLU A 118      29.396  -6.846  -0.644  1.00 21.87           O  
ATOM    937  CB  GLU A 118      32.262  -8.462  -0.439  1.00 25.74           C  
ATOM    938  CG  GLU A 118      33.691  -7.998  -0.624  1.00 30.74           C  
ATOM    939  CD  GLU A 118      33.769  -6.596  -1.199  1.00 35.02           C  
ATOM    940  OE1 GLU A 118      33.827  -5.627  -0.409  1.00 37.66           O  
ATOM    941  OE2 GLU A 118      33.755  -6.462  -2.443  1.00 38.25           O  
ATOM    942  N   PHE A 119      29.342  -8.794   0.494  1.00 19.16           N  
ATOM    943  CA  PHE A 119      27.934  -9.064   0.211  1.00 21.13           C  
ATOM    944  C   PHE A 119      27.066  -8.118   1.028  1.00 19.81           C  
ATOM    945  O   PHE A 119      26.144  -7.488   0.508  1.00 18.58           O  
ATOM    946  CB  PHE A 119      27.567 -10.498   0.601  1.00 20.92           C  
ATOM    947  CG  PHE A 119      27.859 -11.522  -0.459  1.00 24.57           C  
ATOM    948  CD1 PHE A 119      28.619 -12.649  -0.160  1.00 23.84           C  
ATOM    949  CD2 PHE A 119      27.336 -11.385  -1.743  1.00 24.56           C  
ATOM    950  CE1 PHE A 119      28.855 -13.628  -1.124  1.00 25.78           C  
ATOM    951  CE2 PHE A 119      27.566 -12.361  -2.716  1.00 24.24           C  
ATOM    952  CZ  PHE A 119      28.324 -13.483  -2.406  1.00 27.53           C  
ATOM    953  N   LEU A 120      27.376  -8.027   2.317  1.00 19.49           N  
ATOM    954  CA  LEU A 120      26.603  -7.187   3.220  1.00 20.02           C  
ATOM    955  C   LEU A 120      26.589  -5.723   2.815  1.00 19.40           C  
ATOM    956  O   LEU A 120      25.541  -5.084   2.851  1.00 18.46           O  
ATOM    957  CB  LEU A 120      27.124  -7.326   4.657  1.00 21.50           C  
ATOM    958  CG  LEU A 120      26.057  -7.644   5.710  1.00 26.77           C  
ATOM    959  CD1 LEU A 120      25.021  -6.533   5.783  1.00 28.14           C  
ATOM    960  CD2 LEU A 120      25.378  -8.948   5.349  1.00 27.52           C  
ATOM    961  N   LYS A 121      27.740  -5.184   2.427  1.00 18.56           N  
ATOM    962  CA  LYS A 121      27.790  -3.783   2.033  1.00 18.95           C  
ATOM    963  C   LYS A 121      26.842  -3.479   0.879  1.00 18.22           C  
ATOM    964  O   LYS A 121      26.236  -2.412   0.835  1.00 15.93           O  
ATOM    965  CB  LYS A 121      29.219  -3.375   1.667  1.00 21.29           C  
ATOM    966  CG  LYS A 121      30.129  -3.249   2.880  1.00 25.51           C  
ATOM    967  CD  LYS A 121      31.543  -2.829   2.503  1.00 29.86           C  
ATOM    968  CE  LYS A 121      32.401  -2.666   3.754  1.00 31.68           C  
ATOM    969  NZ  LYS A 121      33.793  -2.258   3.437  1.00 34.24           N  
ATOM    970  N   GLN A 122      26.710  -4.418  -0.054  1.00 16.59           N  
ATOM    971  CA  GLN A 122      25.811  -4.219  -1.185  1.00 15.83           C  
ATOM    972  C   GLN A 122      24.377  -4.301  -0.702  1.00 14.93           C  
ATOM    973  O   GLN A 122      23.529  -3.513  -1.110  1.00 15.63           O  
ATOM    974  CB  GLN A 122      26.043  -5.283  -2.249  1.00 15.60           C  
ATOM    975  CG  GLN A 122      27.438  -5.276  -2.813  1.00 17.92           C  
ATOM    976  CD  GLN A 122      27.606  -6.305  -3.901  1.00 19.44           C  
ATOM    977  OE1 GLN A 122      27.038  -6.172  -4.983  1.00 19.28           O  
ATOM    978  NE2 GLN A 122      28.378  -7.348  -3.617  1.00 18.89           N  
ATOM    979  N   ILE A 123      24.108  -5.269   0.167  1.00 13.68           N  
ATOM    980  CA  ILE A 123      22.768  -5.430   0.709  1.00 13.22           C  
ATOM    981  C   ILE A 123      22.397  -4.151   1.455  1.00 13.45           C  
ATOM    982  O   ILE A 123      21.299  -3.632   1.280  1.00 12.19           O  
ATOM    983  CB  ILE A 123      22.695  -6.651   1.663  1.00 13.17           C  
ATOM    984  CG1 ILE A 123      22.881  -7.942   0.852  1.00 15.49           C  
ATOM    985  CG2 ILE A 123      21.354  -6.669   2.409  1.00 12.65           C  
ATOM    986  CD1 ILE A 123      23.173  -9.187   1.686  1.00 16.29           C  
ATOM    987  N   LEU A 124      23.316  -3.639   2.271  1.00 12.27           N  
ATOM    988  CA  LEU A 124      23.046  -2.415   3.026  1.00 13.50           C  
ATOM    989  C   LEU A 124      22.776  -1.245   2.092  1.00 12.85           C  
ATOM    990  O   LEU A 124      21.880  -0.435   2.349  1.00 14.41           O  
ATOM    991  CB  LEU A 124      24.219  -2.071   3.955  1.00 13.02           C  
ATOM    992  CG  LEU A 124      24.573  -3.103   5.032  1.00 14.98           C  
ATOM    993  CD1 LEU A 124      25.824  -2.643   5.782  1.00 13.85           C  
ATOM    994  CD2 LEU A 124      23.402  -3.284   5.993  1.00 15.26           C  
ATOM    995  N   ASN A 125      23.551  -1.144   1.014  1.00 12.83           N  
ATOM    996  CA  ASN A 125      23.345  -0.055   0.065  1.00 13.54           C  
ATOM    997  C   ASN A 125      21.956  -0.154  -0.561  1.00 12.69           C  
ATOM    998  O   ASN A 125      21.273   0.852  -0.735  1.00 13.61           O  
ATOM    999  CB  ASN A 125      24.421  -0.059  -1.025  1.00 14.03           C  
ATOM   1000  CG  ASN A 125      25.791   0.324  -0.495  1.00 18.40           C  
ATOM   1001  OD1 ASN A 125      25.905   1.041   0.500  1.00 19.06           O  
ATOM   1002  ND2 ASN A 125      26.841  -0.133  -1.175  1.00 17.53           N  
ATOM   1003  N   GLY A 126      21.535  -1.370  -0.889  1.00 12.66           N  
ATOM   1004  CA  GLY A 126      20.217  -1.549  -1.478  1.00 11.57           C  
ATOM   1005  C   GLY A 126      19.115  -1.189  -0.491  1.00 11.00           C  
ATOM   1006  O   GLY A 126      18.134  -0.529  -0.839  1.00 10.09           O  
ATOM   1007  N   VAL A 127      19.271  -1.627   0.752  1.00 11.29           N  
ATOM   1008  CA  VAL A 127      18.275  -1.342   1.782  1.00 10.90           C  
ATOM   1009  C   VAL A 127      18.285   0.143   2.139  1.00 12.19           C  
ATOM   1010  O   VAL A 127      17.252   0.714   2.479  1.00 12.85           O  
ATOM   1011  CB  VAL A 127      18.538  -2.203   3.039  1.00 11.21           C  
ATOM   1012  CG1 VAL A 127      17.574  -1.828   4.154  1.00 11.83           C  
ATOM   1013  CG2 VAL A 127      18.378  -3.681   2.679  1.00 11.14           C  
ATOM   1014  N   TYR A 128      19.452   0.773   2.060  1.00 12.22           N  
ATOM   1015  CA  TYR A 128      19.549   2.203   2.354  1.00 12.68           C  
ATOM   1016  C   TYR A 128      18.679   2.947   1.340  1.00 14.07           C  
ATOM   1017  O   TYR A 128      17.942   3.876   1.682  1.00 13.63           O  
ATOM   1018  CB  TYR A 128      20.998   2.670   2.228  1.00 13.87           C  
ATOM   1019  CG  TYR A 128      21.194   4.137   2.543  1.00 15.29           C  
ATOM   1020  CD1 TYR A 128      20.884   4.643   3.803  1.00 16.46           C  
ATOM   1021  CD2 TYR A 128      21.709   5.016   1.591  1.00 17.00           C  
ATOM   1022  CE1 TYR A 128      21.085   5.993   4.113  1.00 19.12           C  
ATOM   1023  CE2 TYR A 128      21.914   6.373   1.892  1.00 19.00           C  
ATOM   1024  CZ  TYR A 128      21.600   6.849   3.156  1.00 19.00           C  
ATOM   1025  OH  TYR A 128      21.811   8.175   3.478  1.00 20.00           O  
ATOM   1026  N   TYR A 129      18.775   2.526   0.084  1.00 13.52           N  
ATOM   1027  CA  TYR A 129      17.992   3.129  -0.981  1.00 13.56           C  
ATOM   1028  C   TYR A 129      16.504   2.959  -0.677  1.00 13.75           C  
ATOM   1029  O   TYR A 129      15.742   3.926  -0.685  1.00 12.98           O  
ATOM   1030  CB  TYR A 129      18.343   2.467  -2.318  1.00 13.95           C  
ATOM   1031  CG  TYR A 129      17.481   2.916  -3.473  1.00 13.66           C  
ATOM   1032  CD1 TYR A 129      17.709   4.137  -4.109  1.00 15.58           C  
ATOM   1033  CD2 TYR A 129      16.404   2.140  -3.899  1.00 14.98           C  
ATOM   1034  CE1 TYR A 129      16.882   4.575  -5.142  1.00 16.63           C  
ATOM   1035  CE2 TYR A 129      15.573   2.570  -4.928  1.00 14.77           C  
ATOM   1036  CZ  TYR A 129      15.818   3.786  -5.544  1.00 15.35           C  
ATOM   1037  OH  TYR A 129      15.000   4.209  -6.570  1.00 15.40           O  
ATOM   1038  N   LEU A 130      16.098   1.723  -0.397  1.00 12.95           N  
ATOM   1039  CA  LEU A 130      14.701   1.432  -0.097  1.00 12.91           C  
ATOM   1040  C   LEU A 130      14.183   2.217   1.111  1.00 12.15           C  
ATOM   1041  O   LEU A 130      13.145   2.867   1.036  1.00 11.39           O  
ATOM   1042  CB  LEU A 130      14.518  -0.078   0.139  1.00 12.81           C  
ATOM   1043  CG  LEU A 130      14.777  -0.994  -1.069  1.00 12.36           C  
ATOM   1044  CD1 LEU A 130      14.566  -2.447  -0.663  1.00 13.02           C  
ATOM   1045  CD2 LEU A 130      13.836  -0.634  -2.224  1.00 13.61           C  
ATOM   1046  N   HIS A 131      14.910   2.156   2.222  1.00 12.25           N  
ATOM   1047  CA  HIS A 131      14.508   2.865   3.434  1.00 13.23           C  
ATOM   1048  C   HIS A 131      14.455   4.379   3.214  1.00 13.16           C  
ATOM   1049  O   HIS A 131      13.635   5.070   3.828  1.00 14.46           O  
ATOM   1050  CB  HIS A 131      15.465   2.525   4.580  1.00  9.88           C  
ATOM   1051  CG  HIS A 131      15.225   1.180   5.192  1.00 12.01           C  
ATOM   1052  ND1 HIS A 131      14.506   0.187   4.560  1.00 14.00           N  
ATOM   1053  CD2 HIS A 131      15.619   0.659   6.380  1.00 10.63           C  
ATOM   1054  CE1 HIS A 131      14.466  -0.887   5.332  1.00 10.85           C  
ATOM   1055  NE2 HIS A 131      15.134  -0.626   6.442  1.00 14.49           N  
ATOM   1056  N   SER A 132      15.326   4.886   2.344  1.00 13.23           N  
ATOM   1057  CA  SER A 132      15.349   6.315   2.026  1.00 15.27           C  
ATOM   1058  C   SER A 132      14.006   6.709   1.400  1.00 16.31           C  
ATOM   1059  O   SER A 132      13.534   7.837   1.562  1.00 16.32           O  
ATOM   1060  CB  SER A 132      16.487   6.633   1.049  1.00 15.84           C  
ATOM   1061  OG  SER A 132      17.754   6.505   1.672  1.00 15.62           O  
ATOM   1062  N   LEU A 133      13.395   5.763   0.691  1.00 15.88           N  
ATOM   1063  CA  LEU A 133      12.101   5.982   0.046  1.00 15.15           C  
ATOM   1064  C   LEU A 133      10.963   5.507   0.947  1.00 16.93           C  
ATOM   1065  O   LEU A 133       9.809   5.428   0.519  1.00 17.54           O  
ATOM   1066  CB  LEU A 133      12.041   5.228  -1.283  1.00 13.99           C  
ATOM   1067  CG  LEU A 133      12.956   5.725  -2.405  1.00 15.88           C  
ATOM   1068  CD1 LEU A 133      12.877   4.776  -3.598  1.00 15.89           C  
ATOM   1069  CD2 LEU A 133      12.538   7.129  -2.808  1.00 17.95           C  
ATOM   1070  N   GLN A 134      11.302   5.194   2.194  1.00 16.64           N  
ATOM   1071  CA  GLN A 134      10.340   4.705   3.175  1.00 17.34           C  
ATOM   1072  C   GLN A 134       9.704   3.392   2.738  1.00 16.96           C  
ATOM   1073  O   GLN A 134       8.524   3.147   2.971  1.00 16.90           O  
ATOM   1074  CB  GLN A 134       9.258   5.754   3.448  1.00 17.61           C  
ATOM   1075  CG  GLN A 134       9.762   6.948   4.235  1.00 19.95           C  
ATOM   1076  CD  GLN A 134      10.322   6.556   5.592  1.00 23.80           C  
ATOM   1077  OE1 GLN A 134      11.411   6.978   5.972  1.00 24.86           O  
ATOM   1078  NE2 GLN A 134       9.568   5.751   6.336  1.00 25.01           N  
ATOM   1079  N   ILE A 135      10.499   2.545   2.098  1.00 15.63           N  
ATOM   1080  CA  ILE A 135      10.004   1.252   1.653  1.00 14.53           C  
ATOM   1081  C   ILE A 135      10.603   0.145   2.508  1.00 14.36           C  
ATOM   1082  O   ILE A 135      11.818  -0.028   2.535  1.00 13.44           O  
ATOM   1083  CB  ILE A 135      10.371   0.981   0.177  1.00 14.24           C  
ATOM   1084  CG1 ILE A 135       9.693   2.015  -0.728  1.00 17.11           C  
ATOM   1085  CG2 ILE A 135       9.943  -0.426  -0.212  1.00 15.05           C  
ATOM   1086  CD1 ILE A 135      10.243   2.083  -2.152  1.00 19.08           C  
ATOM   1087  N   ALA A 136       9.747  -0.580   3.226  1.00 12.01           N  
ATOM   1088  CA  ALA A 136      10.191  -1.702   4.044  1.00 11.72           C  
ATOM   1089  C   ALA A 136      10.048  -2.927   3.145  1.00 12.85           C  
ATOM   1090  O   ALA A 136       9.005  -3.114   2.511  1.00 13.25           O  
ATOM   1091  CB  ALA A 136       9.306  -1.850   5.276  1.00 12.15           C  
ATOM   1092  N   HIS A 137      11.087  -3.755   3.081  1.00 12.30           N  
ATOM   1093  CA  HIS A 137      11.046  -4.946   2.230  1.00 12.21           C  
ATOM   1094  C   HIS A 137      10.241  -6.066   2.895  1.00 12.98           C  
ATOM   1095  O   HIS A 137       9.408  -6.712   2.257  1.00 13.52           O  
ATOM   1096  CB  HIS A 137      12.476  -5.403   1.921  1.00 12.30           C  
ATOM   1097  CG  HIS A 137      12.556  -6.534   0.946  1.00 12.30           C  
ATOM   1098  ND1 HIS A 137      12.279  -7.839   1.294  1.00 11.18           N  
ATOM   1099  CD2 HIS A 137      12.884  -6.557  -0.368  1.00 11.48           C  
ATOM   1100  CE1 HIS A 137      12.434  -8.617   0.237  1.00 11.99           C  
ATOM   1101  NE2 HIS A 137      12.800  -7.863  -0.785  1.00 12.76           N  
ATOM   1102  N   PHE A 138      10.493  -6.272   4.183  1.00 12.77           N  
ATOM   1103  CA  PHE A 138       9.809  -7.279   4.995  1.00 13.74           C  
ATOM   1104  C   PHE A 138      10.043  -8.752   4.648  1.00 15.35           C  
ATOM   1105  O   PHE A 138       9.441  -9.630   5.268  1.00 16.40           O  
ATOM   1106  CB  PHE A 138       8.296  -7.011   5.032  1.00 15.72           C  
ATOM   1107  CG  PHE A 138       7.900  -5.811   5.863  1.00 13.59           C  
ATOM   1108  CD1 PHE A 138       8.534  -5.538   7.073  1.00 15.81           C  
ATOM   1109  CD2 PHE A 138       6.866  -4.973   5.446  1.00 15.06           C  
ATOM   1110  CE1 PHE A 138       8.145  -4.447   7.863  1.00 15.90           C  
ATOM   1111  CE2 PHE A 138       6.465  -3.878   6.223  1.00 15.02           C  
ATOM   1112  CZ  PHE A 138       7.106  -3.613   7.435  1.00 16.20           C  
ATOM   1113  N   ASP A 139      10.901  -9.043   3.673  1.00 13.43           N  
ATOM   1114  CA  ASP A 139      11.155 -10.446   3.347  1.00 15.21           C  
ATOM   1115  C   ASP A 139      12.620 -10.676   2.969  1.00 14.44           C  
ATOM   1116  O   ASP A 139      12.928 -11.458   2.070  1.00 15.18           O  
ATOM   1117  CB  ASP A 139      10.218 -10.912   2.217  1.00 16.28           C  
ATOM   1118  CG  ASP A 139      10.013 -12.427   2.206  1.00 19.68           C  
ATOM   1119  OD1 ASP A 139      10.314 -13.082   3.227  1.00 20.21           O  
ATOM   1120  OD2 ASP A 139       9.532 -12.965   1.184  1.00 21.92           O  
ATOM   1121  N   LEU A 140      13.523  -9.996   3.673  1.00 13.55           N  
ATOM   1122  CA  LEU A 140      14.953 -10.134   3.412  1.00 12.80           C  
ATOM   1123  C   LEU A 140      15.495 -11.455   3.946  1.00 13.67           C  
ATOM   1124  O   LEU A 140      15.361 -11.770   5.129  1.00 13.95           O  
ATOM   1125  CB  LEU A 140      15.726  -8.976   4.043  1.00 12.18           C  
ATOM   1126  CG  LEU A 140      15.451  -7.589   3.458  1.00 12.49           C  
ATOM   1127  CD1 LEU A 140      16.155  -6.536   4.303  1.00 12.61           C  
ATOM   1128  CD2 LEU A 140      15.923  -7.536   2.013  1.00 11.37           C  
ATOM   1129  N   LYS A 141      16.096 -12.223   3.048  1.00 13.86           N  
ATOM   1130  CA  LYS A 141      16.683 -13.517   3.372  1.00 16.32           C  
ATOM   1131  C   LYS A 141      17.463 -13.953   2.137  1.00 16.58           C  
ATOM   1132  O   LYS A 141      17.245 -13.424   1.048  1.00 14.56           O  
ATOM   1133  CB  LYS A 141      15.589 -14.533   3.705  1.00 15.29           C  
ATOM   1134  CG  LYS A 141      14.517 -14.668   2.635  1.00 17.50           C  
ATOM   1135  CD  LYS A 141      13.449 -15.652   3.067  1.00 21.08           C  
ATOM   1136  CE  LYS A 141      12.400 -15.844   1.986  1.00 22.95           C  
ATOM   1137  NZ  LYS A 141      11.479 -16.959   2.333  1.00 28.67           N  
ATOM   1138  N   PRO A 142      18.374 -14.927   2.290  1.00 17.79           N  
ATOM   1139  CA  PRO A 142      19.198 -15.433   1.186  1.00 18.31           C  
ATOM   1140  C   PRO A 142      18.482 -15.799  -0.114  1.00 19.28           C  
ATOM   1141  O   PRO A 142      19.027 -15.574  -1.194  1.00 19.36           O  
ATOM   1142  CB  PRO A 142      19.921 -16.625   1.817  1.00 18.77           C  
ATOM   1143  CG  PRO A 142      20.121 -16.155   3.228  1.00 18.34           C  
ATOM   1144  CD  PRO A 142      18.747 -15.584   3.557  1.00 16.45           C  
ATOM   1145  N   GLU A 143      17.275 -16.354  -0.043  1.00 18.45           N  
ATOM   1146  CA  GLU A 143      16.601 -16.701  -1.294  1.00 19.75           C  
ATOM   1147  C   GLU A 143      16.032 -15.485  -2.024  1.00 17.79           C  
ATOM   1148  O   GLU A 143      15.638 -15.588  -3.187  1.00 17.85           O  
ATOM   1149  CB  GLU A 143      15.496 -17.740  -1.076  1.00 24.49           C  
ATOM   1150  CG  GLU A 143      14.328 -17.314  -0.221  1.00 32.61           C  
ATOM   1151  CD  GLU A 143      13.207 -18.344  -0.249  1.00 36.97           C  
ATOM   1152  OE1 GLU A 143      13.496 -19.532  -0.518  1.00 40.53           O  
ATOM   1153  OE2 GLU A 143      12.039 -17.976   0.003  1.00 38.06           O  
ATOM   1154  N   ASN A 144      15.998 -14.338  -1.351  1.00 15.39           N  
ATOM   1155  CA  ASN A 144      15.493 -13.117  -1.975  1.00 15.24           C  
ATOM   1156  C   ASN A 144      16.608 -12.139  -2.321  1.00 15.16           C  
ATOM   1157  O   ASN A 144      16.378 -10.938  -2.471  1.00 15.49           O  
ATOM   1158  CB  ASN A 144      14.446 -12.443  -1.084  1.00 14.41           C  
ATOM   1159  CG  ASN A 144      13.134 -13.194  -1.079  1.00 14.97           C  
ATOM   1160  OD1 ASN A 144      12.844 -13.943  -2.012  1.00 16.93           O  
ATOM   1161  ND2 ASN A 144      12.327 -12.992  -0.045  1.00 14.96           N  
ATOM   1162  N   ILE A 145      17.822 -12.669  -2.423  1.00 14.72           N  
ATOM   1163  CA  ILE A 145      18.995 -11.886  -2.794  1.00 16.35           C  
ATOM   1164  C   ILE A 145      19.646 -12.687  -3.916  1.00 17.25           C  
ATOM   1165  O   ILE A 145      19.933 -13.875  -3.756  1.00 19.22           O  
ATOM   1166  CB  ILE A 145      19.980 -11.723  -1.616  1.00 16.26           C  
ATOM   1167  CG1 ILE A 145      19.295 -10.955  -0.478  1.00 16.74           C  
ATOM   1168  CG2 ILE A 145      21.219 -10.950  -2.080  1.00 19.56           C  
ATOM   1169  CD1 ILE A 145      20.012 -11.028   0.868  1.00 21.86           C  
ATOM   1170  N   MET A 146      19.859 -12.040  -5.055  1.00 17.27           N  
ATOM   1171  CA  MET A 146      20.429 -12.712  -6.219  1.00 17.70           C  
ATOM   1172  C   MET A 146      21.785 -12.157  -6.631  1.00 17.74           C  
ATOM   1173  O   MET A 146      22.053 -10.975  -6.454  1.00 16.98           O  
ATOM   1174  CB  MET A 146      19.480 -12.557  -7.401  1.00 20.20           C  
ATOM   1175  CG  MET A 146      18.492 -12.923  -7.085  1.00 23.89           C  
ATOM   1176  SD  MET A 146      18.067 -14.490  -7.813  1.00 30.39           S  
ATOM   1177  CE  MET A 146      16.634 -14.108  -8.550  1.00 24.57           C  
ATOM   1178  N   LEU A 147      22.625 -13.019  -7.199  1.00 18.77           N  
ATOM   1179  CA  LEU A 147      23.944 -12.622  -7.679  1.00 18.99           C  
ATOM   1180  C   LEU A 147      23.859 -12.434  -9.187  1.00 20.36           C  
ATOM   1181  O   LEU A 147      23.176 -13.194  -9.870  1.00 19.60           O  
ATOM   1182  CB  LEU A 147      24.986 -13.704  -7.378  1.00 18.10           C  
ATOM   1183  CG  LEU A 147      25.496 -13.848  -5.943  1.00 18.35           C  
ATOM   1184  CD1 LEU A 147      24.361 -14.217  -4.992  1.00 19.03           C  
ATOM   1185  CD2 LEU A 147      26.575 -14.915  -5.931  1.00 19.66           C  
ATOM   1186  N   LEU A 148      24.541 -11.419  -9.703  1.00 21.13           N  
ATOM   1187  CA  LEU A 148      24.533 -11.169 -11.138  1.00 24.41           C  
ATOM   1188  C   LEU A 148      25.393 -12.212 -11.839  1.00 24.49           C  
ATOM   1189  O   LEU A 148      25.051 -12.688 -12.917  1.00 22.90           O  
ATOM   1190  CB  LEU A 148      25.063  -9.765 -11.446  1.00 25.21           C  
ATOM   1191  CG  LEU A 148      24.129  -8.592 -11.150  1.00 26.83           C  
ATOM   1192  CD1 LEU A 148      24.809  -7.290 -11.547  1.00 27.55           C  
ATOM   1193  CD2 LEU A 148      22.826  -8.765 -11.925  1.00 30.22           C  
ATOM   1194  N   ASP A 149      26.507 -12.565 -11.202  1.00 26.94           N  
ATOM   1195  CA  ASP A 149      27.449 -13.553 -11.732  1.00 29.52           C  
ATOM   1196  C   ASP A 149      28.118 -14.215 -10.528  1.00 31.47           C  
ATOM   1197  O   ASP A 149      28.841 -13.550  -9.791  1.00 31.59           O  
ATOM   1198  CB  ASP A 149      28.515 -12.852 -12.579  1.00 29.88           C  
ATOM   1199  CG  ASP A 149      29.427 -13.826 -13.301  1.00 31.29           C  
ATOM   1200  OD1 ASP A 149      29.676 -14.929 -12.771  1.00 32.82           O  
ATOM   1201  OD2 ASP A 149      29.911 -13.480 -14.399  1.00 33.33           O  
ATOM   1202  N   ARG A 150      27.890 -15.508 -10.318  1.00 33.51           N  
ATOM   1203  CA  ARG A 150      28.501 -16.154  -9.160  1.00 37.90           C  
ATOM   1204  C   ARG A 150      29.877 -16.759  -9.413  1.00 38.36           C  
ATOM   1205  O   ARG A 150      30.476 -17.335  -8.507  1.00 39.28           O  
ATOM   1206  CB  ARG A 150      27.568 -17.221  -8.559  1.00 40.47           C  
ATOM   1207  CG  ARG A 150      27.506 -18.560  -9.285  1.00 44.44           C  
ATOM   1208  CD  ARG A 150      26.636 -18.499 -10.522  1.00 48.15           C  
ATOM   1209  NE  ARG A 150      26.210 -19.828 -10.957  1.00 51.84           N  
ATOM   1210  CZ  ARG A 150      27.032 -20.795 -11.357  1.00 53.13           C  
ATOM   1211  NH1 ARG A 150      28.342 -20.592 -11.383  1.00 54.29           N  
ATOM   1212  NH2 ARG A 150      26.540 -21.970 -11.730  1.00 53.57           N  
ATOM   1213  N   ASN A 151      30.381 -16.622 -10.637  1.00 39.02           N  
ATOM   1214  CA  ASN A 151      31.698 -17.158 -10.978  1.00 40.06           C  
ATOM   1215  C   ASN A 151      32.756 -16.063 -10.922  1.00 40.17           C  
ATOM   1216  O   ASN A 151      33.700 -16.055 -11.712  1.00 41.06           O  
ATOM   1217  CB  ASN A 151      31.682 -17.784 -12.377  1.00 40.66           C  
ATOM   1218  CG  ASN A 151      30.764 -18.987 -12.467  1.00 41.80           C  
ATOM   1219  OD1 ASN A 151      30.909 -19.951 -11.713  1.00 43.03           O  
ATOM   1220  ND2 ASN A 151      29.815 -18.937 -13.394  1.00 41.23           N  
ATOM   1221  N   VAL A 152      32.583 -15.137  -9.982  1.00 39.43           N  
ATOM   1222  CA  VAL A 152      33.506 -14.024  -9.793  1.00 38.90           C  
ATOM   1223  C   VAL A 152      33.848 -13.979  -8.300  1.00 38.65           C  
ATOM   1224  O   VAL A 152      33.006 -14.289  -7.460  1.00 37.77           O  
ATOM   1225  CB  VAL A 152      32.850 -12.694 -10.243  1.00 38.99           C  
ATOM   1226  CG1 VAL A 152      33.828 -11.549 -10.122  1.00 40.48           C  
ATOM   1227  CG2 VAL A 152      32.381 -12.814 -11.683  1.00 39.08           C  
ATOM   1228  N   PRO A 153      35.091 -13.603  -7.953  1.00 38.74           N  
ATOM   1229  CA  PRO A 153      35.509 -13.539  -6.546  1.00 37.98           C  
ATOM   1230  C   PRO A 153      34.637 -12.708  -5.605  1.00 36.98           C  
ATOM   1231  O   PRO A 153      34.438 -13.082  -4.448  1.00 37.23           O  
ATOM   1232  CB  PRO A 153      36.946 -13.013  -6.633  1.00 39.06           C  
ATOM   1233  CG  PRO A 153      36.960 -12.242  -7.928  1.00 39.25           C  
ATOM   1234  CD  PRO A 153      36.174 -13.143  -8.840  1.00 38.97           C  
ATOM   1235  N   LYS A 154      34.121 -11.588  -6.101  1.00 35.42           N  
ATOM   1236  CA  LYS A 154      33.279 -10.702  -5.301  1.00 33.99           C  
ATOM   1237  C   LYS A 154      31.970 -10.426  -6.042  1.00 31.35           C  
ATOM   1238  O   LYS A 154      31.766  -9.334  -6.571  1.00 30.67           O  
ATOM   1239  CB  LYS A 154      34.012  -9.387  -5.047  1.00 35.24           C  
ATOM   1240  CG  LYS A 154      35.412  -9.565  -4.476  1.00 38.77           C  
ATOM   1241  CD  LYS A 154      36.173  -8.249  -4.450  1.00 42.56           C  
ATOM   1242  CE  LYS A 154      36.358  -7.688  -5.857  1.00 44.90           C  
ATOM   1243  NZ  LYS A 154      37.102  -6.398  -5.849  1.00 46.66           N  
ATOM   1244  N   PRO A 155      31.065 -11.416  -6.080  1.00 29.51           N  
ATOM   1245  CA  PRO A 155      29.769 -11.302  -6.760  1.00 26.81           C  
ATOM   1246  C   PRO A 155      28.940 -10.079  -6.370  1.00 25.20           C  
ATOM   1247  O   PRO A 155      28.865  -9.714  -5.196  1.00 22.55           O  
ATOM   1248  CB  PRO A 155      29.068 -12.604  -6.383  1.00 27.65           C  
ATOM   1249  CG  PRO A 155      30.213 -13.567  -6.225  1.00 30.49           C  
ATOM   1250  CD  PRO A 155      31.205 -12.739  -5.446  1.00 28.59           C  
ATOM   1251  N   ARG A 156      28.320  -9.451  -7.367  1.00 22.85           N  
ATOM   1252  CA  ARG A 156      27.470  -8.293  -7.126  1.00 22.28           C  
ATOM   1253  C   ARG A 156      26.063  -8.840  -6.942  1.00 20.64           C  
ATOM   1254  O   ARG A 156      25.699  -9.849  -7.552  1.00 19.49           O  
ATOM   1255  CB  ARG A 156      27.514  -7.324  -8.311  1.00 24.08           C  
ATOM   1256  CG  ARG A 156      28.922  -7.019  -8.818  1.00 29.08           C  
ATOM   1257  CD  ARG A 156      29.950  -6.977  -7.689  1.00 32.44           C  
ATOM   1258  NE  ARG A 156      29.847  -5.787  -6.847  1.00 36.81           N  
ATOM   1259  CZ  ARG A 156      30.456  -5.653  -5.671  1.00 36.90           C  
ATOM   1260  NH1 ARG A 156      31.206  -6.638  -5.193  1.00 37.68           N  
ATOM   1261  NH2 ARG A 156      30.327  -4.532  -4.974  1.00 37.64           N  
ATOM   1262  N   ILE A 157      25.267  -8.186  -6.108  1.00 18.29           N  
ATOM   1263  CA  ILE A 157      23.926  -8.684  -5.861  1.00 16.76           C  
ATOM   1264  C   ILE A 157      22.826  -7.659  -6.044  1.00 16.30           C  
ATOM   1265  O   ILE A 157      23.077  -6.459  -6.118  1.00 14.42           O  
ATOM   1266  CB  ILE A 157      23.808  -9.267  -4.430  1.00 18.94           C  
ATOM   1267  CG1 ILE A 157      24.058  -8.173  -3.383  1.00 17.67           C  
ATOM   1268  CG2 ILE A 157      24.810 -10.393  -4.244  1.00 18.31           C  
ATOM   1269  CD1 ILE A 157      22.833  -7.356  -3.005  1.00 18.10           C  
ATOM   1270  N   LYS A 158      21.601  -8.167  -6.121  1.00 14.34           N  
ATOM   1271  CA  LYS A 158      20.410  -7.346  -6.241  1.00 14.66           C  
ATOM   1272  C   LYS A 158      19.348  -7.981  -5.356  1.00 14.00           C  
ATOM   1273  O   LYS A 158      19.209  -9.203  -5.314  1.00 14.80           O  
ATOM   1274  CB  LYS A 158      19.901  -7.300  -7.690  1.00 16.37           C  
ATOM   1275  CG  LYS A 158      20.629  -6.305  -8.577  1.00 17.66           C  
ATOM   1276  CD  LYS A 158      20.160  -6.393 -10.019  1.00 20.82           C  
ATOM   1277  CE  LYS A 158      20.819  -5.321 -10.884  1.00 19.77           C  
ATOM   1278  NZ  LYS A 158      20.220  -3.975 -10.671  1.00 25.06           N  
ATOM   1279  N   ILE A 159      18.613  -7.147  -4.639  1.00 13.28           N  
ATOM   1280  CA  ILE A 159      17.548  -7.634  -3.781  1.00 13.52           C  
ATOM   1281  C   ILE A 159      16.340  -7.861  -4.683  1.00 13.62           C  
ATOM   1282  O   ILE A 159      16.057  -7.036  -5.555  1.00 13.74           O  
ATOM   1283  CB  ILE A 159      17.176  -6.582  -2.714  1.00 14.86           C  
ATOM   1284  CG1 ILE A 159      18.357  -6.356  -1.766  1.00 13.15           C  
ATOM   1285  CG2 ILE A 159      15.942  -7.036  -1.942  1.00 13.32           C  
ATOM   1286  CD1 ILE A 159      18.861  -7.575  -0.944  1.00 24.86           C  
ATOM   1287  N   ILE A 160      15.646  -8.979  -4.488  1.00 12.23           N  
ATOM   1288  CA  ILE A 160      14.455  -9.284  -5.282  1.00 13.70           C  
ATOM   1289  C   ILE A 160      13.252  -9.550  -4.376  1.00 13.06           C  
ATOM   1290  O   ILE A 160      13.319  -9.355  -3.160  1.00 11.19           O  
ATOM   1291  CB  ILE A 160      14.659 -10.541  -6.167  1.00 13.73           C  
ATOM   1292  CG1 ILE A 160      14.859 -11.777  -5.286  1.00 12.87           C  
ATOM   1293  CG2 ILE A 160      15.857 -10.340  -7.088  1.00 13.41           C  
ATOM   1294  CD1 ILE A 160      14.792 -13.082  -6.035  1.00 14.30           C  
ATOM   1295  N   ASP A 161      12.159  -9.998  -4.994  1.00 12.29           N  
ATOM   1296  CA  ASP A 161      10.919 -10.342  -4.304  1.00 13.73           C  
ATOM   1297  C   ASP A 161      10.318  -9.254  -3.424  1.00 13.39           C  
ATOM   1298  O   ASP A 161      10.530  -9.228  -2.210  1.00 13.16           O  
ATOM   1299  CB  ASP A 161      11.115 -11.605  -3.466  1.00 15.82           C  
ATOM   1300  CG  ASP A 161       9.820 -12.071  -2.808  1.00 18.44           C  
ATOM   1301  OD1 ASP A 161       8.756 -11.485  -3.087  1.00 17.30           O  
ATOM   1302  OD2 ASP A 161       9.866 -13.026  -2.014  1.00 20.70           O  
ATOM   1303  N   PHE A 162       9.539  -8.376  -4.039  1.00 13.63           N  
ATOM   1304  CA  PHE A 162       8.904  -7.303  -3.295  1.00 14.39           C  
ATOM   1305  C   PHE A 162       7.449  -7.635  -2.966  1.00 13.93           C  
ATOM   1306  O   PHE A 162       6.618  -6.747  -2.796  1.00 14.73           O  
ATOM   1307  CB  PHE A 162       9.040  -5.991  -4.080  1.00 14.68           C  
ATOM   1308  CG  PHE A 162      10.448  -5.442  -4.080  1.00 15.06           C  
ATOM   1309  CD1 PHE A 162      11.433  -6.006  -4.888  1.00 14.35           C  
ATOM   1310  CD2 PHE A 162      10.809  -4.428  -3.199  1.00 15.70           C  
ATOM   1311  CE1 PHE A 162      12.761  -5.575  -4.818  1.00 16.27           C  
ATOM   1312  CE2 PHE A 162      12.132  -3.985  -3.115  1.00 16.09           C  
ATOM   1313  CZ  PHE A 162      13.113  -4.560  -3.925  1.00 16.77           C  
ATOM   1314  N   GLY A 163       7.171  -8.932  -2.845  1.00 14.45           N  
ATOM   1315  CA  GLY A 163       5.831  -9.409  -2.539  1.00 15.05           C  
ATOM   1316  C   GLY A 163       5.278  -8.995  -1.188  1.00 16.30           C  
ATOM   1317  O   GLY A 163       4.061  -8.972  -0.996  1.00 17.82           O  
ATOM   1318  N   LEU A 164       6.157  -8.676  -0.244  1.00 15.36           N  
ATOM   1319  CA  LEU A 164       5.711  -8.242   1.076  1.00 16.09           C  
ATOM   1320  C   LEU A 164       6.058  -6.782   1.339  1.00 14.19           C  
ATOM   1321  O   LEU A 164       5.685  -6.232   2.371  1.00 14.65           O  
ATOM   1322  CB  LEU A 164       6.334  -9.105   2.179  1.00 17.60           C  
ATOM   1323  CG  LEU A 164       5.864 -10.555   2.315  1.00 22.46           C  
ATOM   1324  CD1 LEU A 164       6.473 -11.157   3.578  1.00 21.60           C  
ATOM   1325  CD2 LEU A 164       4.342 -10.603   2.395  1.00 22.59           C  
ATOM   1326  N   ALA A 165       6.759  -6.155   0.401  1.00 12.95           N  
ATOM   1327  CA  ALA A 165       7.168  -4.764   0.561  1.00 12.94           C  
ATOM   1328  C   ALA A 165       6.000  -3.801   0.765  1.00 14.51           C  
ATOM   1329  O   ALA A 165       4.943  -3.943   0.148  1.00 14.55           O  
ATOM   1330  CB  ALA A 165       8.007  -4.327  -0.635  1.00 12.71           C  
ATOM   1331  N   HIS A 166       6.204  -2.818   1.638  1.00 14.43           N  
ATOM   1332  CA  HIS A 166       5.184  -1.817   1.939  1.00 15.85           C  
ATOM   1333  C   HIS A 166       5.777  -0.426   2.117  1.00 16.90           C  
ATOM   1334  O   HIS A 166       6.918  -0.277   2.567  1.00 14.48           O  
ATOM   1335  CB  HIS A 166       4.448  -2.171   3.236  1.00 17.01           C  
ATOM   1336  CG  HIS A 166       3.421  -3.248   3.087  1.00 19.99           C  
ATOM   1337  ND1 HIS A 166       2.068  -2.995   3.156  1.00 21.50           N  
ATOM   1338  CD2 HIS A 166       3.544  -4.581   2.888  1.00 20.66           C  
ATOM   1339  CE1 HIS A 166       1.403  -4.126   3.007  1.00 20.44           C  
ATOM   1340  NE2 HIS A 166       2.274  -5.104   2.842  1.00 22.06           N  
ATOM   1341  N   LYS A 167       4.993   0.590   1.770  1.00 18.22           N  
ATOM   1342  CA  LYS A 167       5.409   1.974   1.963  1.00 22.01           C  
ATOM   1343  C   LYS A 167       5.098   2.288   3.427  1.00 23.32           C  
ATOM   1344  O   LYS A 167       4.006   1.977   3.913  1.00 24.21           O  
ATOM   1345  CB  LYS A 167       4.605   2.913   1.061  1.00 23.18           C  
ATOM   1346  CG  LYS A 167       5.248   3.185  -0.286  1.00 27.77           C  
ATOM   1347  CD  LYS A 167       6.524   3.995  -0.110  1.00 30.89           C  
ATOM   1348  CE  LYS A 167       7.093   4.431  -1.445  1.00 31.28           C  
ATOM   1349  NZ  LYS A 167       6.141   5.311  -2.172  1.00 34.42           N  
ATOM   1350  N   ILE A 168       6.051   2.891   4.132  1.00 21.12           N  
ATOM   1351  CA  ILE A 168       5.852   3.232   5.538  1.00 22.69           C  
ATOM   1352  C   ILE A 168       5.817   4.751   5.664  1.00 23.12           C  
ATOM   1353  O   ILE A 168       6.771   5.365   6.143  1.00 24.09           O  
ATOM   1354  CB  ILE A 168       7.005   2.695   6.420  1.00 23.32           C  
ATOM   1355  CG1 ILE A 168       7.175   1.187   6.216  1.00 22.60           C  
ATOM   1356  CG2 ILE A 168       6.715   2.989   7.890  1.00 22.71           C  
ATOM   1357  CD1 ILE A 168       5.959   0.275   6.542  1.00 23.52           C  
ATOM   1358  N   ASP A 169       4.719   5.357   5.232  1.00 23.53           N  
ATOM   1359  CA  ASP A 169       4.607   6.809   5.296  1.00 25.01           C  
ATOM   1360  C   ASP A 169       4.166   7.334   6.651  1.00 24.75           C  
ATOM   1361  O   ASP A 169       4.258   8.537   6.913  1.00 20.38           O  
ATOM   1362  CB  ASP A 169       3.672   7.310   4.198  1.00 28.71           C  
ATOM   1363  CG  ASP A 169       4.205   7.007   2.811  1.00 32.48           C  
ATOM   1364  OD1 ASP A 169       5.432   7.164   2.607  1.00 31.58           O  
ATOM   1365  OD2 ASP A 169       3.407   6.623   1.927  1.00 33.42           O  
ATOM   1366  N   PHE A 170       3.697   6.434   7.513  1.00 24.50           N  
ATOM   1367  CA  PHE A 170       3.261   6.816   8.853  1.00 27.48           C  
ATOM   1368  C   PHE A 170       4.190   6.264   9.932  1.00 28.54           C  
ATOM   1369  O   PHE A 170       3.798   6.145  11.091  1.00 30.75           O  
ATOM   1370  CB  PHE A 170       1.835   6.326   9.127  1.00 27.80           C  
ATOM   1371  CG  PHE A 170       0.791   6.998   8.288  1.00 28.39           C  
ATOM   1372  CD1 PHE A 170       0.504   6.538   7.009  1.00 29.80           C  
ATOM   1373  CD2 PHE A 170       0.107   8.108   8.771  1.00 28.13           C  
ATOM   1374  CE1 PHE A 170      -0.452   7.174   6.219  1.00 31.28           C  
ATOM   1375  CE2 PHE A 170      -0.849   8.753   7.992  1.00 28.07           C  
ATOM   1376  CZ  PHE A 170      -1.130   8.287   6.715  1.00 29.58           C  
ATOM   1377  N   GLY A 171       5.416   5.922   9.553  1.00 26.69           N  
ATOM   1378  CA  GLY A 171       6.353   5.397  10.531  1.00 28.04           C  
ATOM   1379  C   GLY A 171       6.165   3.923  10.846  1.00 27.55           C  
ATOM   1380  O   GLY A 171       7.108   3.256  11.280  1.00 26.65           O  
ATOM   1381  N   ASN A 172       4.953   3.410  10.636  1.00 26.01           N  
ATOM   1382  CA  ASN A 172       4.673   2.000  10.893  1.00 26.79           C  
ATOM   1383  C   ASN A 172       3.402   1.511  10.200  1.00 27.66           C  
ATOM   1384  O   ASN A 172       2.494   2.293   9.913  1.00 27.62           O  
ATOM   1385  CB  ASN A 172       4.565   1.738  12.403  1.00 25.16           C  
ATOM   1386  CG  ASN A 172       3.258   2.239  12.999  1.00 26.25           C  
ATOM   1387  OD1 ASN A 172       2.187   1.673  12.754  1.00 24.81           O  
ATOM   1388  ND2 ASN A 172       3.338   3.306  13.785  1.00 26.05           N  
ATOM   1389  N   GLU A 173       3.363   0.212   9.919  1.00 28.00           N  
ATOM   1390  CA  GLU A 173       2.216  -0.432   9.285  1.00 29.77           C  
ATOM   1391  C   GLU A 173       1.706  -1.520  10.226  1.00 30.72           C  
ATOM   1392  O   GLU A 173       2.492  -2.284  10.785  1.00 28.45           O  
ATOM   1393  CB  GLU A 173       2.617  -1.057   7.946  1.00 31.39           C  
ATOM   1394  CG  GLU A 173       2.360  -0.171   6.736  1.00 35.25           C  
ATOM   1395  CD  GLU A 173       0.879  -0.010   6.425  1.00 37.54           C  
ATOM   1396  OE1 GLU A 173       0.135   0.520   7.277  1.00 38.77           O  
ATOM   1397  OE2 GLU A 173       0.452  -0.417   5.324  1.00 40.45           O  
ATOM   1398  N   PHE A 174       0.391  -1.591  10.395  1.00 32.26           N  
ATOM   1399  CA  PHE A 174      -0.205  -2.577  11.288  1.00 34.54           C  
ATOM   1400  C   PHE A 174      -1.200  -3.452  10.530  1.00 36.48           C  
ATOM   1401  O   PHE A 174      -2.402  -3.175  10.526  1.00 36.92           O  
ATOM   1402  CB  PHE A 174      -0.901  -1.845  12.439  1.00 35.13           C  
ATOM   1403  CG  PHE A 174      -1.362  -2.743  13.551  1.00 36.17           C  
ATOM   1404  CD1 PHE A 174      -0.487  -3.653  14.137  1.00 37.16           C  
ATOM   1405  CD2 PHE A 174      -2.659  -2.648  14.043  1.00 36.70           C  
ATOM   1406  CE1 PHE A 174      -0.899  -4.453  15.199  1.00 37.82           C  
ATOM   1407  CE2 PHE A 174      -3.080  -3.445  15.105  1.00 37.39           C  
ATOM   1408  CZ  PHE A 174      -2.198  -4.347  15.684  1.00 38.16           C  
ATOM   1409  N   LYS A 175      -0.704  -4.510   9.892  1.00 38.03           N  
ATOM   1410  CA  LYS A 175      -1.580  -5.387   9.123  1.00 40.26           C  
ATOM   1411  C   LYS A 175      -1.184  -6.865   9.052  1.00 40.70           C  
ATOM   1412  O   LYS A 175      -1.347  -7.508   8.014  1.00 40.69           O  
ATOM   1413  CB  LYS A 175      -1.736  -4.833   7.705  1.00 40.79           C  
ATOM   1414  CG  LYS A 175      -0.422  -4.539   7.014  1.00 42.26           C  
ATOM   1415  CD  LYS A 175      -0.644  -4.149   5.565  1.00 42.70           C  
ATOM   1416  CE  LYS A 175      -1.265  -5.299   4.783  1.00 43.64           C  
ATOM   1417  NZ  LYS A 175      -1.422  -4.969   3.345  1.00 43.70           N  
ATOM   1418  N   ASN A 176      -0.670  -7.396  10.155  1.00 41.19           N  
ATOM   1419  CA  ASN A 176      -0.287  -8.806  10.239  1.00 42.12           C  
ATOM   1420  C   ASN A 176       0.642  -9.306   9.134  1.00 41.54           C  
ATOM   1421  O   ASN A 176       0.573 -10.475   8.749  1.00 43.08           O  
ATOM   1422  CB  ASN A 176      -1.544  -9.687  10.267  1.00 43.58           C  
ATOM   1423  CG  ASN A 176      -2.516  -9.291  11.367  1.00 45.96           C  
ATOM   1424  OD1 ASN A 176      -2.162  -9.268  12.547  1.00 47.13           O  
ATOM   1425  ND2 ASN A 176      -3.749  -8.979  10.983  1.00 46.58           N  
ATOM   1426  N   ILE A 177       1.496  -8.430   8.615  1.00 39.50           N  
ATOM   1427  CA  ILE A 177       2.456  -8.822   7.584  1.00 36.63           C  
ATOM   1428  C   ILE A 177       3.334  -9.883   8.248  1.00 34.63           C  
ATOM   1429  O   ILE A 177       3.738  -9.713   9.398  1.00 34.80           O  
ATOM   1430  CB  ILE A 177       3.327  -7.613   7.160  1.00 36.42           C  
ATOM   1431  CG1 ILE A 177       2.432  -6.518   6.571  1.00 35.94           C  
ATOM   1432  CG2 ILE A 177       4.385  -8.048   6.155  1.00 36.05           C  
ATOM   1433  CD1 ILE A 177       1.615  -6.868   5.296  1.00 39.62           C  
ATOM   1434  N   PHE A 178       3.628 -10.971   7.543  1.00 32.71           N  
ATOM   1435  CA  PHE A 178       4.438 -12.037   8.132  1.00 31.01           C  
ATOM   1436  C   PHE A 178       5.242 -12.828   7.092  1.00 29.68           C  
ATOM   1437  O   PHE A 178       4.697 -13.282   6.084  1.00 29.53           O  
ATOM   1438  CB  PHE A 178       3.524 -12.992   8.904  1.00 30.37           C  
ATOM   1439  CG  PHE A 178       4.155 -13.594  10.131  1.00 31.22           C  
ATOM   1440  CD1 PHE A 178       5.359 -14.284  10.052  1.00 30.81           C  
ATOM   1441  CD2 PHE A 178       3.519 -13.496  11.369  1.00 30.59           C  
ATOM   1442  CE1 PHE A 178       5.919 -14.877  11.187  1.00 32.48           C  
ATOM   1443  CE2 PHE A 178       4.069 -14.085  12.509  1.00 30.87           C  
ATOM   1444  CZ  PHE A 178       5.271 -14.777  12.417  1.00 30.76           C  
ATOM   1445  N   GLY A 179       6.535 -13.001   7.356  1.00 29.07           N  
ATOM   1446  CA  GLY A 179       7.392 -13.736   6.441  1.00 26.62           C  
ATOM   1447  C   GLY A 179       7.859 -15.087   6.960  1.00 25.25           C  
ATOM   1448  O   GLY A 179       7.091 -15.817   7.590  1.00 25.90           O  
ATOM   1449  N   THR A 180       9.125 -15.411   6.688  1.00 22.25           N  
ATOM   1450  CA  THR A 180       9.746 -16.672   7.102  1.00 21.28           C  
ATOM   1451  C   THR A 180      10.225 -16.612   8.549  1.00 18.76           C  
ATOM   1452  O   THR A 180      11.082 -15.802   8.888  1.00 17.73           O  
ATOM   1453  CB  THR A 180      10.960 -17.007   6.205  1.00 22.22           C  
ATOM   1454  OG1 THR A 180      10.531 -17.089   4.843  1.00 23.19           O  
ATOM   1455  CG2 THR A 180      11.590 -18.333   6.614  1.00 23.26           C  
ATOM   1456  N   PRO A 181       9.688 -17.487   9.417  1.00 17.82           N  
ATOM   1457  CA  PRO A 181      10.054 -17.536  10.837  1.00 17.27           C  
ATOM   1458  C   PRO A 181      11.532 -17.297  11.155  1.00 15.11           C  
ATOM   1459  O   PRO A 181      11.855 -16.519  12.046  1.00 15.15           O  
ATOM   1460  CB  PRO A 181       9.585 -18.925  11.258  1.00 17.49           C  
ATOM   1461  CG  PRO A 181       8.326 -19.074  10.472  1.00 19.40           C  
ATOM   1462  CD  PRO A 181       8.737 -18.566   9.088  1.00 17.61           C  
ATOM   1463  N   GLU A 182      12.427 -17.954  10.425  1.00 16.49           N  
ATOM   1464  CA  GLU A 182      13.859 -17.794  10.677  1.00 17.08           C  
ATOM   1465  C   GLU A 182      14.365 -16.364  10.568  1.00 16.08           C  
ATOM   1466  O   GLU A 182      15.336 -16.000  11.234  1.00 16.16           O  
ATOM   1467  CB  GLU A 182      14.683 -18.634   9.702  1.00 20.69           C  
ATOM   1468  CG  GLU A 182      14.669 -20.109   9.941  1.00 28.25           C  
ATOM   1469  CD  GLU A 182      15.370 -20.845   8.821  1.00 30.77           C  
ATOM   1470  OE1 GLU A 182      16.593 -20.642   8.652  1.00 31.07           O  
ATOM   1471  OE2 GLU A 182      14.686 -21.607   8.103  1.00 34.17           O  
ATOM   1472  N   PHE A 183      13.717 -15.555   9.733  1.00 16.02           N  
ATOM   1473  CA  PHE A 183      14.177 -14.184   9.514  1.00 14.32           C  
ATOM   1474  C   PHE A 183      13.302 -13.042  10.005  1.00 15.78           C  
ATOM   1475  O   PHE A 183      13.720 -11.884   9.961  1.00 15.97           O  
ATOM   1476  CB  PHE A 183      14.459 -13.969   8.022  1.00 15.39           C  
ATOM   1477  CG  PHE A 183      15.434 -14.954   7.443  1.00 16.31           C  
ATOM   1478  CD1 PHE A 183      15.003 -16.200   6.995  1.00 17.76           C  
ATOM   1479  CD2 PHE A 183      16.794 -14.648   7.382  1.00 17.00           C  
ATOM   1480  CE1 PHE A 183      15.916 -17.134   6.492  1.00 18.07           C  
ATOM   1481  CE2 PHE A 183      17.713 -15.571   6.885  1.00 17.92           C  
ATOM   1482  CZ  PHE A 183      17.272 -16.818   6.438  1.00 18.12           C  
ATOM   1483  N   VAL A 184      12.099 -13.341  10.477  1.00 14.31           N  
ATOM   1484  CA  VAL A 184      11.225 -12.267  10.936  1.00 14.62           C  
ATOM   1485  C   VAL A 184      11.637 -11.718  12.297  1.00 15.40           C  
ATOM   1486  O   VAL A 184      12.153 -12.447  13.138  1.00 14.84           O  
ATOM   1487  CB  VAL A 184       9.754 -12.737  10.996  1.00 15.07           C  
ATOM   1488  CG1 VAL A 184       9.246 -13.011   9.581  1.00 17.05           C  
ATOM   1489  CG2 VAL A 184       9.634 -13.988  11.857  1.00 15.39           C  
ATOM   1490  N   ALA A 185      11.408 -10.424  12.492  1.00 14.46           N  
ATOM   1491  CA  ALA A 185      11.738  -9.751  13.744  1.00 16.65           C  
ATOM   1492  C   ALA A 185      10.678 -10.042  14.801  1.00 15.85           C  
ATOM   1493  O   ALA A 185       9.570 -10.461  14.480  1.00 16.02           O  
ATOM   1494  CB  ALA A 185      11.831  -8.247  13.513  1.00 16.75           C  
ATOM   1495  N   PRO A 186      11.011  -9.822  16.081  1.00 16.44           N  
ATOM   1496  CA  PRO A 186      10.078 -10.059  17.187  1.00 16.92           C  
ATOM   1497  C   PRO A 186       8.732  -9.349  17.009  1.00 16.65           C  
ATOM   1498  O   PRO A 186       7.692  -9.911  17.342  1.00 17.26           O  
ATOM   1499  CB  PRO A 186      10.849  -9.546  18.400  1.00 16.14           C  
ATOM   1500  CG  PRO A 186      12.268  -9.873  18.043  1.00 16.81           C  
ATOM   1501  CD  PRO A 186      12.345  -9.449  16.589  1.00 16.63           C  
ATOM   1502  N   GLU A 187       8.753  -8.121  16.484  1.00 16.79           N  
ATOM   1503  CA  GLU A 187       7.520  -7.367  16.277  1.00 15.75           C  
ATOM   1504  C   GLU A 187       6.603  -8.079  15.280  1.00 16.37           C  
ATOM   1505  O   GLU A 187       5.379  -7.995  15.390  1.00 16.06           O  
ATOM   1506  CB  GLU A 187       7.817  -5.936  15.794  1.00 14.78           C  
ATOM   1507  CG  GLU A 187       8.702  -5.850  14.561  1.00 16.55           C  
ATOM   1508  CD  GLU A 187      10.159  -5.578  14.896  1.00 15.99           C  
ATOM   1509  OE1 GLU A 187      10.646  -6.098  15.923  1.00 15.11           O  
ATOM   1510  OE2 GLU A 187      10.820  -4.855  14.121  1.00 13.56           O  
ATOM   1511  N   ILE A 188       7.188  -8.787  14.315  1.00 15.11           N  
ATOM   1512  CA  ILE A 188       6.381  -9.522  13.340  1.00 15.96           C  
ATOM   1513  C   ILE A 188       5.762 -10.745  14.029  1.00 16.42           C  
ATOM   1514  O   ILE A 188       4.582 -11.063  13.839  1.00 15.52           O  
ATOM   1515  CB  ILE A 188       7.238  -9.990  12.131  1.00 17.47           C  
ATOM   1516  CG1 ILE A 188       7.640  -8.775  11.282  1.00 17.81           C  
ATOM   1517  CG2 ILE A 188       6.452 -10.983  11.274  1.00 15.54           C  
ATOM   1518  CD1 ILE A 188       8.767  -9.031  10.284  1.00 20.32           C  
ATOM   1519  N   VAL A 189       6.574 -11.425  14.830  1.00 16.17           N  
ATOM   1520  CA  VAL A 189       6.134 -12.600  15.569  1.00 16.44           C  
ATOM   1521  C   VAL A 189       4.997 -12.247  16.529  1.00 16.82           C  
ATOM   1522  O   VAL A 189       4.041 -13.012  16.687  1.00 16.25           O  
ATOM   1523  CB  VAL A 189       7.301 -13.197  16.380  1.00 17.21           C  
ATOM   1524  CG1 VAL A 189       6.817 -14.356  17.244  1.00 17.65           C  
ATOM   1525  CG2 VAL A 189       8.403 -13.648  15.431  1.00 16.35           C  
ATOM   1526  N   ASN A 190       5.106 -11.085  17.163  1.00 16.04           N  
ATOM   1527  CA  ASN A 190       4.096 -10.640  18.117  1.00 16.78           C  
ATOM   1528  C   ASN A 190       2.950  -9.829  17.507  1.00 17.69           C  
ATOM   1529  O   ASN A 190       2.094  -9.317  18.232  1.00 17.21           O  
ATOM   1530  CB  ASN A 190       4.758  -9.843  19.244  1.00 19.68           C  
ATOM   1531  CG  ASN A 190       5.629 -10.713  20.140  1.00 22.10           C  
ATOM   1532  OD1 ASN A 190       6.795 -10.977  19.838  1.00 22.97           O  
ATOM   1533  ND2 ASN A 190       5.057 -11.174  21.241  1.00 21.61           N  
ATOM   1534  N   TYR A 191       2.936  -9.714  16.183  1.00 15.53           N  
ATOM   1535  CA  TYR A 191       1.876  -8.985  15.481  1.00 17.23           C  
ATOM   1536  C   TYR A 191       1.729  -7.537  15.933  1.00 17.77           C  
ATOM   1537  O   TYR A 191       0.618  -7.035  16.109  1.00 18.11           O  
ATOM   1538  CB  TYR A 191       0.549  -9.720  15.668  1.00 16.58           C  
ATOM   1539  CG  TYR A 191       0.560 -11.107  15.081  1.00 18.54           C  
ATOM   1540  CD1 TYR A 191       0.291 -11.315  13.727  1.00 19.46           C  
ATOM   1541  CD2 TYR A 191       0.867 -12.216  15.872  1.00 18.53           C  
ATOM   1542  CE1 TYR A 191       0.323 -12.597  13.175  1.00 19.82           C  
ATOM   1543  CE2 TYR A 191       0.902 -13.498  15.328  1.00 18.88           C  
ATOM   1544  CZ  TYR A 191       0.629 -13.681  13.985  1.00 19.01           C  
ATOM   1545  OH  TYR A 191       0.652 -14.949  13.453  1.00 21.13           O  
ATOM   1546  N   GLU A 192       2.859  -6.866  16.114  1.00 18.70           N  
ATOM   1547  CA  GLU A 192       2.850  -5.475  16.538  1.00 20.09           C  
ATOM   1548  C   GLU A 192       3.101  -4.576  15.330  1.00 20.19           C  
ATOM   1549  O   GLU A 192       3.434  -5.064  14.244  1.00 20.11           O  
ATOM   1550  CB  GLU A 192       3.929  -5.266  17.601  1.00 23.89           C  
ATOM   1551  CG  GLU A 192       3.773  -6.202  18.791  1.00 30.71           C  
ATOM   1552  CD  GLU A 192       4.943  -6.141  19.743  1.00 35.14           C  
ATOM   1553  OE1 GLU A 192       6.095  -6.225  19.267  1.00 38.68           O  
ATOM   1554  OE2 GLU A 192       4.717  -6.020  20.969  1.00 39.91           O  
ATOM   1555  N   PRO A 193       2.914  -3.255  15.493  1.00 19.40           N  
ATOM   1556  CA  PRO A 193       3.137  -2.315  14.392  1.00 19.67           C  
ATOM   1557  C   PRO A 193       4.527  -2.552  13.830  1.00 18.15           C  
ATOM   1558  O   PRO A 193       5.471  -2.785  14.588  1.00 19.84           O  
ATOM   1559  CB  PRO A 193       2.997  -0.960  15.071  1.00 17.54           C  
ATOM   1560  CG  PRO A 193       1.919  -1.232  16.082  1.00 20.24           C  
ATOM   1561  CD  PRO A 193       2.365  -2.557  16.671  1.00 19.48           C  
ATOM   1562  N   LEU A 194       4.644  -2.497  12.506  1.00 18.66           N  
ATOM   1563  CA  LEU A 194       5.916  -2.750  11.839  1.00 17.69           C  
ATOM   1564  C   LEU A 194       6.449  -1.531  11.094  1.00 18.25           C  
ATOM   1565  O   LEU A 194       5.685  -0.715  10.580  1.00 16.99           O  
ATOM   1566  CB  LEU A 194       5.754  -3.907  10.850  1.00 19.40           C  
ATOM   1567  CG  LEU A 194       5.100  -5.200  11.351  1.00 19.57           C  
ATOM   1568  CD1 LEU A 194       5.020  -6.198  10.196  1.00 18.96           C  
ATOM   1569  CD2 LEU A 194       5.903  -5.789  12.507  1.00 18.91           C  
ATOM   1570  N   GLY A 195       7.769  -1.426  11.025  1.00 16.86           N  
ATOM   1571  CA  GLY A 195       8.390  -0.310  10.338  1.00 17.42           C  
ATOM   1572  C   GLY A 195       9.677  -0.771   9.686  1.00 17.31           C  
ATOM   1573  O   GLY A 195       9.940  -1.970   9.609  1.00 15.18           O  
ATOM   1574  N   LEU A 196      10.486   0.178   9.222  1.00 15.43           N  
ATOM   1575  CA  LEU A 196      11.746  -0.152   8.572  1.00 15.74           C  
ATOM   1576  C   LEU A 196      12.658  -0.976   9.473  1.00 15.29           C  
ATOM   1577  O   LEU A 196      13.516  -1.710   8.985  1.00 12.74           O  
ATOM   1578  CB  LEU A 196      12.478   1.126   8.163  1.00 14.38           C  
ATOM   1579  CG  LEU A 196      11.669   2.140   7.352  1.00 14.46           C  
ATOM   1580  CD1 LEU A 196      12.521   3.381   7.106  1.00 15.89           C  
ATOM   1581  CD2 LEU A 196      11.227   1.518   6.036  1.00 15.77           C  
ATOM   1582  N   GLU A 197      12.475  -0.850  10.786  1.00 13.37           N  
ATOM   1583  CA  GLU A 197      13.311  -1.577  11.735  1.00 13.47           C  
ATOM   1584  C   GLU A 197      13.320  -3.095  11.538  1.00 12.54           C  
ATOM   1585  O   GLU A 197      14.331  -3.745  11.785  1.00 10.03           O  
ATOM   1586  CB  GLU A 197      12.892  -1.258  13.175  1.00 17.37           C  
ATOM   1587  CG  GLU A 197      12.877   0.230  13.534  1.00 20.14           C  
ATOM   1588  CD  GLU A 197      11.652   0.960  13.001  1.00 26.24           C  
ATOM   1589  OE1 GLU A 197      10.654   0.294  12.654  1.00 26.55           O  
ATOM   1590  OE2 GLU A 197      11.677   2.210  12.946  1.00 30.69           O  
ATOM   1591  N   ALA A 198      12.197  -3.662  11.104  1.00 11.95           N  
ATOM   1592  CA  ALA A 198      12.108  -5.107  10.895  1.00 11.56           C  
ATOM   1593  C   ALA A 198      13.166  -5.600   9.901  1.00 11.69           C  
ATOM   1594  O   ALA A 198      13.724  -6.690  10.063  1.00 11.92           O  
ATOM   1595  CB  ALA A 198      10.704  -5.483  10.402  1.00 10.30           C  
ATOM   1596  N   ASP A 199      13.436  -4.804   8.871  1.00 11.58           N  
ATOM   1597  CA  ASP A 199      14.444  -5.182   7.885  1.00 11.71           C  
ATOM   1598  C   ASP A 199      15.837  -5.274   8.503  1.00 10.88           C  
ATOM   1599  O   ASP A 199      16.633  -6.133   8.124  1.00 10.97           O  
ATOM   1600  CB  ASP A 199      14.500  -4.173   6.733  1.00 13.00           C  
ATOM   1601  CG  ASP A 199      13.340  -4.315   5.762  1.00 14.05           C  
ATOM   1602  OD1 ASP A 199      12.733  -5.408   5.697  1.00 13.28           O  
ATOM   1603  OD2 ASP A 199      13.053  -3.331   5.043  1.00 13.83           O  
ATOM   1604  N   MET A 200      16.137  -4.376   9.439  1.00 11.16           N  
ATOM   1605  CA  MET A 200      17.451  -4.359  10.072  1.00 10.55           C  
ATOM   1606  C   MET A 200      17.671  -5.628  10.889  1.00 11.34           C  
ATOM   1607  O   MET A 200      18.785  -6.151  10.956  1.00  9.64           O  
ATOM   1608  CB  MET A 200      17.603  -3.107  10.939  1.00 11.26           C  
ATOM   1609  CG  MET A 200      17.453  -1.802  10.139  1.00 11.47           C  
ATOM   1610  SD  MET A 200      18.438  -1.800   8.594  1.00 13.64           S  
ATOM   1611  CE  MET A 200      20.097  -1.995   9.263  1.00 11.87           C  
ATOM   1612  N   TRP A 201      16.604  -6.126  11.503  1.00 11.24           N  
ATOM   1613  CA  TRP A 201      16.706  -7.367  12.255  1.00 10.22           C  
ATOM   1614  C   TRP A 201      17.048  -8.483  11.270  1.00  9.86           C  
ATOM   1615  O   TRP A 201      17.940  -9.286  11.520  1.00 10.06           O  
ATOM   1616  CB  TRP A 201      15.383  -7.681  12.963  1.00  9.56           C  
ATOM   1617  CG  TRP A 201      15.316  -9.071  13.546  1.00  8.96           C  
ATOM   1618  CD1 TRP A 201      15.115 -10.244  12.869  1.00 12.54           C  
ATOM   1619  CD2 TRP A 201      15.456  -9.425  14.924  1.00 12.55           C  
ATOM   1620  NE1 TRP A 201      15.121 -11.305  13.741  1.00 12.93           N  
ATOM   1621  CE2 TRP A 201      15.327 -10.832  15.010  1.00 11.64           C  
ATOM   1622  CE3 TRP A 201      15.675  -8.691  16.095  1.00 12.43           C  
ATOM   1623  CZ2 TRP A 201      15.411 -11.517  16.226  1.00 12.94           C  
ATOM   1624  CZ3 TRP A 201      15.759  -9.374  17.305  1.00 14.67           C  
ATOM   1625  CH2 TRP A 201      15.625 -10.775  17.359  1.00 13.32           C  
ATOM   1626  N   SER A 202      16.337  -8.536  10.145  1.00 11.44           N  
ATOM   1627  CA  SER A 202      16.596  -9.575   9.152  1.00 11.23           C  
ATOM   1628  C   SER A 202      18.046  -9.511   8.674  1.00 11.76           C  
ATOM   1629  O   SER A 202      18.661 -10.535   8.404  1.00 11.42           O  
ATOM   1630  CB  SER A 202      15.652  -9.427   7.953  1.00 12.93           C  
ATOM   1631  OG  SER A 202      14.300  -9.558   8.352  1.00 14.95           O  
ATOM   1632  N   ILE A 203      18.583  -8.302   8.561  1.00 11.64           N  
ATOM   1633  CA  ILE A 203      19.967  -8.134   8.133  1.00 12.82           C  
ATOM   1634  C   ILE A 203      20.898  -8.760   9.173  1.00 12.37           C  
ATOM   1635  O   ILE A 203      21.920  -9.357   8.827  1.00 13.14           O  
ATOM   1636  CB  ILE A 203      20.294  -6.630   7.926  1.00 13.98           C  
ATOM   1637  CG1 ILE A 203      19.554  -6.134   6.673  1.00 18.62           C  
ATOM   1638  CG2 ILE A 203      21.803  -6.416   7.787  1.00 15.79           C  
ATOM   1639  CD1 ILE A 203      19.893  -6.818   5.325  1.00 23.86           C  
ATOM   1640  N   GLY A 204      20.546  -8.627  10.449  1.00 11.45           N  
ATOM   1641  CA  GLY A 204      21.371  -9.214  11.495  1.00 12.06           C  
ATOM   1642  C   GLY A 204      21.408 -10.729  11.355  1.00 11.68           C  
ATOM   1643  O   GLY A 204      22.456 -11.361  11.501  1.00 11.78           O  
ATOM   1644  N   VAL A 205      20.252 -11.317  11.071  1.00 11.30           N  
ATOM   1645  CA  VAL A 205      20.158 -12.767  10.901  1.00 10.98           C  
ATOM   1646  C   VAL A 205      20.997 -13.204   9.697  1.00  9.90           C  
ATOM   1647  O   VAL A 205      21.760 -14.168   9.767  1.00  9.88           O  
ATOM   1648  CB  VAL A 205      18.687 -13.203  10.692  1.00 10.90           C  
ATOM   1649  CG1 VAL A 205      18.621 -14.705  10.420  1.00 10.73           C  
ATOM   1650  CG2 VAL A 205      17.850 -12.838  11.934  1.00 12.22           C  
ATOM   1651  N   ILE A 206      20.858 -12.489   8.589  1.00 11.39           N  
ATOM   1652  CA  ILE A 206      21.622 -12.804   7.389  1.00 12.60           C  
ATOM   1653  C   ILE A 206      23.132 -12.726   7.663  1.00 12.74           C  
ATOM   1654  O   ILE A 206      23.898 -13.587   7.233  1.00 12.88           O  
ATOM   1655  CB  ILE A 206      21.258 -11.835   6.237  1.00 13.66           C  
ATOM   1656  CG1 ILE A 206      19.837 -12.129   5.753  1.00 16.34           C  
ATOM   1657  CG2 ILE A 206      22.267 -11.968   5.093  1.00 12.76           C  
ATOM   1658  CD1 ILE A 206      18.696 -12.177   6.717  1.00 28.17           C  
ATOM   1659  N   THR A 207      23.556 -11.702   8.394  1.00 11.65           N  
ATOM   1660  CA  THR A 207      24.977 -11.538   8.703  1.00 11.84           C  
ATOM   1661  C   THR A 207      25.492 -12.718   9.524  1.00 11.71           C  
ATOM   1662  O   THR A 207      26.571 -13.257   9.255  1.00 11.40           O  
ATOM   1663  CB  THR A 207      25.211 -10.222   9.464  1.00 12.70           C  
ATOM   1664  OG1 THR A 207      24.734  -9.139   8.662  1.00 12.19           O  
ATOM   1665  CG2 THR A 207      26.698 -10.015   9.751  1.00 12.90           C  
ATOM   1666  N   TYR A 208      24.708 -13.118  10.522  1.00 11.40           N  
ATOM   1667  CA  TYR A 208      25.059 -14.250  11.376  1.00 12.71           C  
ATOM   1668  C   TYR A 208      25.278 -15.485  10.506  1.00 12.62           C  
ATOM   1669  O   TYR A 208      26.256 -16.209  10.677  1.00 14.29           O  
ATOM   1670  CB  TYR A 208      23.931 -14.496  12.392  1.00 12.39           C  
ATOM   1671  CG  TYR A 208      24.202 -15.577  13.421  1.00 12.87           C  
ATOM   1672  CD1 TYR A 208      24.173 -16.929  13.072  1.00 13.09           C  
ATOM   1673  CD2 TYR A 208      24.430 -15.250  14.760  1.00 14.20           C  
ATOM   1674  CE1 TYR A 208      24.354 -17.928  14.032  1.00 15.20           C  
ATOM   1675  CE2 TYR A 208      24.615 -16.241  15.728  1.00 12.34           C  
ATOM   1676  CZ  TYR A 208      24.572 -17.573  15.359  1.00 13.63           C  
ATOM   1677  OH  TYR A 208      24.731 -18.553  16.316  1.00 15.23           O  
ATOM   1678  N   ILE A 209      24.370 -15.711   9.560  1.00 13.10           N  
ATOM   1679  CA  ILE A 209      24.455 -16.854   8.656  1.00 13.22           C  
ATOM   1680  C   ILE A 209      25.673 -16.768   7.739  1.00 13.31           C  
ATOM   1681  O   ILE A 209      26.387 -17.754   7.541  1.00 13.03           O  
ATOM   1682  CB  ILE A 209      23.173 -16.953   7.787  1.00 15.20           C  
ATOM   1683  CG1 ILE A 209      21.985 -17.349   8.665  1.00 19.65           C  
ATOM   1684  CG2 ILE A 209      23.373 -17.947   6.652  1.00 16.56           C  
ATOM   1685  CD1 ILE A 209      21.753 -18.847   8.866  1.00 29.53           C  
ATOM   1686  N   LEU A 210      25.909 -15.587   7.182  1.00 10.95           N  
ATOM   1687  CA  LEU A 210      27.041 -15.388   6.283  1.00 13.87           C  
ATOM   1688  C   LEU A 210      28.370 -15.747   6.933  1.00 14.62           C  
ATOM   1689  O   LEU A 210      29.244 -16.341   6.302  1.00 16.03           O  
ATOM   1690  CB  LEU A 210      27.100 -13.933   5.819  1.00 14.04           C  
ATOM   1691  CG  LEU A 210      26.042 -13.444   4.833  1.00 15.94           C  
ATOM   1692  CD1 LEU A 210      26.233 -11.958   4.584  1.00 16.02           C  
ATOM   1693  CD2 LEU A 210      26.161 -14.224   3.525  1.00 18.71           C  
ATOM   1694  N   LEU A 211      28.506 -15.388   8.202  1.00 15.51           N  
ATOM   1695  CA  LEU A 211      29.733 -15.616   8.948  1.00 16.99           C  
ATOM   1696  C   LEU A 211      29.924 -17.009   9.542  1.00 19.58           C  
ATOM   1697  O   LEU A 211      31.061 -17.461   9.713  1.00 20.94           O  
ATOM   1698  CB  LEU A 211      29.831 -14.574  10.073  1.00 16.68           C  
ATOM   1699  CG  LEU A 211      29.965 -13.116   9.621  1.00 16.21           C  
ATOM   1700  CD1 LEU A 211      29.848 -12.177  10.821  1.00 16.90           C  
ATOM   1701  CD2 LEU A 211      31.310 -12.932   8.919  1.00 19.01           C  
ATOM   1702  N   SER A 212      28.828 -17.698   9.835  1.00 18.84           N  
ATOM   1703  CA  SER A 212      28.919 -19.009  10.473  1.00 18.56           C  
ATOM   1704  C   SER A 212      28.343 -20.192   9.714  1.00 18.50           C  
ATOM   1705  O   SER A 212      28.738 -21.330   9.956  1.00 19.66           O  
ATOM   1706  CB  SER A 212      28.236 -18.944  11.832  1.00 20.01           C  
ATOM   1707  OG  SER A 212      26.844 -18.760  11.659  1.00 17.17           O  
ATOM   1708  N   GLY A 213      27.395 -19.937   8.820  1.00 18.82           N  
ATOM   1709  CA  GLY A 213      26.777 -21.024   8.084  1.00 18.47           C  
ATOM   1710  C   GLY A 213      25.688 -21.644   8.943  1.00 18.90           C  
ATOM   1711  O   GLY A 213      25.149 -22.706   8.620  1.00 20.13           O  
ATOM   1712  N   ALA A 214      25.369 -20.974  10.047  1.00 16.57           N  
ATOM   1713  CA  ALA A 214      24.339 -21.436  10.974  1.00 17.76           C  
ATOM   1714  C   ALA A 214      23.283 -20.349  11.177  1.00 18.43           C  
ATOM   1715  O   ALA A 214      23.579 -19.153  11.064  1.00 16.93           O  
ATOM   1716  CB  ALA A 214      24.976 -21.796  12.314  1.00 17.86           C  
ATOM   1717  N   SER A 215      22.053 -20.767  11.470  1.00 17.44           N  
ATOM   1718  CA  SER A 215      20.951 -19.836  11.689  1.00 18.08           C  
ATOM   1719  C   SER A 215      20.853 -19.584  13.195  1.00 17.62           C  
ATOM   1720  O   SER A 215      20.851 -20.525  13.986  1.00 18.23           O  
ATOM   1721  CB  SER A 215      19.647 -20.437  11.157  1.00 17.45           C  
ATOM   1722  OG  SER A 215      18.638 -19.454  11.058  1.00 18.48           O  
ATOM   1723  N   PRO A 216      20.756 -18.311  13.612  1.00 16.29           N  
ATOM   1724  CA  PRO A 216      20.674 -17.980  15.038  1.00 15.76           C  
ATOM   1725  C   PRO A 216      19.457 -18.422  15.857  1.00 16.67           C  
ATOM   1726  O   PRO A 216      19.603 -18.766  17.030  1.00 15.77           O  
ATOM   1727  CB  PRO A 216      20.852 -16.462  15.047  1.00 16.90           C  
ATOM   1728  CG  PRO A 216      20.215 -16.049  13.754  1.00 14.19           C  
ATOM   1729  CD  PRO A 216      20.716 -17.091  12.781  1.00 14.77           C  
ATOM   1730  N   PHE A 217      18.276 -18.430  15.247  1.00 15.64           N  
ATOM   1731  CA  PHE A 217      17.049 -18.783  15.967  1.00 15.59           C  
ATOM   1732  C   PHE A 217      16.354 -20.056  15.498  1.00 16.11           C  
ATOM   1733  O   PHE A 217      15.332 -20.453  16.064  1.00 16.16           O  
ATOM   1734  CB  PHE A 217      16.053 -17.624  15.856  1.00 13.68           C  
ATOM   1735  CG  PHE A 217      16.590 -16.317  16.345  1.00 14.28           C  
ATOM   1736  CD1 PHE A 217      16.753 -16.082  17.708  1.00 15.37           C  
ATOM   1737  CD2 PHE A 217      16.948 -15.319  15.444  1.00 14.79           C  
ATOM   1738  CE1 PHE A 217      17.266 -14.869  18.168  1.00 14.89           C  
ATOM   1739  CE2 PHE A 217      17.462 -14.103  15.892  1.00 14.36           C  
ATOM   1740  CZ  PHE A 217      17.623 -13.878  17.259  1.00 14.84           C  
ATOM   1741  N   LEU A 218      16.910 -20.700  14.481  1.00 15.63           N  
ATOM   1742  CA  LEU A 218      16.291 -21.894  13.919  1.00 17.79           C  
ATOM   1743  C   LEU A 218      16.021 -23.032  14.899  1.00 17.39           C  
ATOM   1744  O   LEU A 218      16.935 -23.539  15.549  1.00 16.58           O  
ATOM   1745  CB  LEU A 218      17.130 -22.419  12.752  1.00 19.90           C  
ATOM   1746  CG  LEU A 218      16.510 -23.589  11.981  1.00 21.00           C  
ATOM   1747  CD1 LEU A 218      15.177 -23.152  11.383  1.00 21.32           C  
ATOM   1748  CD2 LEU A 218      17.467 -24.056  10.883  1.00 22.55           C  
ATOM   1749  N   GLY A 219      14.753 -23.427  14.988  1.00 18.41           N  
ATOM   1750  CA  GLY A 219      14.358 -24.522  15.860  1.00 20.41           C  
ATOM   1751  C   GLY A 219      13.928 -25.715  15.016  1.00 22.18           C  
ATOM   1752  O   GLY A 219      14.045 -25.678  13.788  1.00 21.73           O  
ATOM   1753  N   ASP A 220      13.439 -26.775  15.655  1.00 23.50           N  
ATOM   1754  CA  ASP A 220      13.000 -27.960  14.919  1.00 24.46           C  
ATOM   1755  C   ASP A 220      11.636 -27.766  14.274  1.00 23.66           C  
ATOM   1756  O   ASP A 220      11.257 -28.514  13.374  1.00 23.93           O  
ATOM   1757  CB  ASP A 220      12.938 -29.185  15.836  1.00 27.77           C  
ATOM   1758  CG  ASP A 220      14.306 -29.695  16.226  1.00 31.79           C  
ATOM   1759  OD1 ASP A 220      15.196 -29.751  15.351  1.00 34.17           O  
ATOM   1760  OD2 ASP A 220      14.486 -30.054  17.409  1.00 34.96           O  
ATOM   1761  N   THR A 221      10.895 -26.770  14.744  1.00 21.10           N  
ATOM   1762  CA  THR A 221       9.572 -26.490  14.200  1.00 20.51           C  
ATOM   1763  C   THR A 221       9.406 -24.986  14.057  1.00 21.03           C  
ATOM   1764  O   THR A 221      10.176 -24.215  14.627  1.00 19.90           O  
ATOM   1765  CB  THR A 221       8.460 -27.004  15.132  1.00 19.21           C  
ATOM   1766  OG1 THR A 221       8.500 -26.274  16.363  1.00 15.77           O  
ATOM   1767  CG2 THR A 221       8.649 -28.494  15.420  1.00 19.72           C  
ATOM   1768  N   LYS A 222       8.401 -24.570  13.295  1.00 20.57           N  
ATOM   1769  CA  LYS A 222       8.160 -23.149  13.105  1.00 20.81           C  
ATOM   1770  C   LYS A 222       7.851 -22.458  14.428  1.00 20.58           C  
ATOM   1771  O   LYS A 222       8.366 -21.370  14.689  1.00 18.12           O  
ATOM   1772  CB  LYS A 222       7.011 -22.931  12.122  1.00 23.24           C  
ATOM   1773  CG  LYS A 222       7.387 -23.186  10.673  1.00 26.81           C  
ATOM   1774  CD  LYS A 222       6.190 -22.988   9.756  1.00 31.14           C  
ATOM   1775  CE  LYS A 222       6.624 -22.889   8.303  1.00 34.19           C  
ATOM   1776  NZ  LYS A 222       7.459 -21.673   8.077  1.00 37.10           N  
ATOM   1777  N   GLN A 223       7.024 -23.082  15.268  1.00 19.01           N  
ATOM   1778  CA  GLN A 223       6.682 -22.465  16.549  1.00 18.75           C  
ATOM   1779  C   GLN A 223       7.918 -22.277  17.422  1.00 16.98           C  
ATOM   1780  O   GLN A 223       8.049 -21.257  18.092  1.00 17.32           O  
ATOM   1781  CB  GLN A 223       5.630 -23.288  17.311  1.00 19.79           C  
ATOM   1782  CG  GLN A 223       6.041 -24.723  17.600  1.00 19.63           C  
ATOM   1783  CD  GLN A 223       5.555 -25.686  16.535  1.00 21.84           C  
ATOM   1784  OE1 GLN A 223       5.483 -25.339  15.353  1.00 20.55           O  
ATOM   1785  NE2 GLN A 223       5.238 -26.910  16.945  1.00 20.52           N  
ATOM   1786  N   GLU A 224       8.820 -23.254  17.419  1.00 15.86           N  
ATOM   1787  CA  GLU A 224      10.047 -23.138  18.202  1.00 16.63           C  
ATOM   1788  C   GLU A 224      10.880 -21.955  17.706  1.00 14.58           C  
ATOM   1789  O   GLU A 224      11.423 -21.182  18.497  1.00 15.51           O  
ATOM   1790  CB  GLU A 224      10.885 -24.417  18.098  1.00 19.84           C  
ATOM   1791  CG  GLU A 224      10.494 -25.501  19.087  1.00 25.62           C  
ATOM   1792  CD  GLU A 224      11.454 -26.682  19.071  1.00 27.60           C  
ATOM   1793  OE1 GLU A 224      12.686 -26.462  18.995  1.00 30.19           O  
ATOM   1794  OE2 GLU A 224      10.980 -27.832  19.147  1.00 28.83           O  
ATOM   1795  N   THR A 225      10.987 -21.822  16.390  1.00 13.98           N  
ATOM   1796  CA  THR A 225      11.763 -20.726  15.808  1.00 15.49           C  
ATOM   1797  C   THR A 225      11.184 -19.376  16.211  1.00 15.99           C  
ATOM   1798  O   THR A 225      11.912 -18.467  16.621  1.00 16.66           O  
ATOM   1799  CB  THR A 225      11.783 -20.825  14.270  1.00 14.16           C  
ATOM   1800  OG1 THR A 225      12.396 -22.065  13.893  1.00 13.44           O  
ATOM   1801  CG2 THR A 225      12.570 -19.664  13.660  1.00 14.57           C  
ATOM   1802  N   LEU A 226       9.867 -19.256  16.090  1.00 16.70           N  
ATOM   1803  CA  LEU A 226       9.180 -18.023  16.434  1.00 15.45           C  
ATOM   1804  C   LEU A 226       9.355 -17.704  17.912  1.00 15.48           C  
ATOM   1805  O   LEU A 226       9.526 -16.543  18.282  1.00 16.97           O  
ATOM   1806  CB  LEU A 226       7.697 -18.142  16.075  1.00 16.37           C  
ATOM   1807  CG  LEU A 226       7.435 -18.262  14.570  1.00 16.63           C  
ATOM   1808  CD1 LEU A 226       5.981 -18.634  14.312  1.00 19.06           C  
ATOM   1809  CD2 LEU A 226       7.786 -16.937  13.890  1.00 15.24           C  
ATOM   1810  N   ALA A 227       9.314 -18.732  18.755  1.00 14.50           N  
ATOM   1811  CA  ALA A 227       9.492 -18.538  20.192  1.00 16.60           C  
ATOM   1812  C   ALA A 227      10.910 -18.046  20.471  1.00 16.14           C  
ATOM   1813  O   ALA A 227      11.118 -17.169  21.314  1.00 16.42           O  
ATOM   1814  CB  ALA A 227       9.231 -19.852  20.946  1.00 14.56           C  
ATOM   1815  N   ASN A 228      11.881 -18.619  19.764  1.00 13.74           N  
ATOM   1816  CA  ASN A 228      13.287 -18.231  19.919  1.00 16.73           C  
ATOM   1817  C   ASN A 228      13.481 -16.775  19.504  1.00 15.63           C  
ATOM   1818  O   ASN A 228      14.181 -16.010  20.171  1.00 16.77           O  
ATOM   1819  CB  ASN A 228      14.187 -19.122  19.053  1.00 16.14           C  
ATOM   1820  CG  ASN A 228      14.353 -20.521  19.618  1.00 18.97           C  
ATOM   1821  OD1 ASN A 228      14.748 -21.446  18.907  1.00 19.84           O  
ATOM   1822  ND2 ASN A 228      14.070 -20.678  20.902  1.00 14.50           N  
ATOM   1823  N   VAL A 229      12.858 -16.399  18.392  1.00 14.61           N  
ATOM   1824  CA  VAL A 229      12.952 -15.035  17.886  1.00 15.10           C  
ATOM   1825  C   VAL A 229      12.401 -14.032  18.895  1.00 14.59           C  
ATOM   1826  O   VAL A 229      13.059 -13.045  19.219  1.00 15.26           O  
ATOM   1827  CB  VAL A 229      12.176 -14.874  16.558  1.00 12.48           C  
ATOM   1828  CG1 VAL A 229      12.047 -13.393  16.196  1.00 14.64           C  
ATOM   1829  CG2 VAL A 229      12.897 -15.616  15.445  1.00 12.32           C  
ATOM   1830  N   SER A 230      11.200 -14.292  19.401  1.00 15.90           N  
ATOM   1831  CA  SER A 230      10.571 -13.381  20.356  1.00 15.85           C  
ATOM   1832  C   SER A 230      11.371 -13.200  21.645  1.00 17.74           C  
ATOM   1833  O   SER A 230      11.391 -12.111  22.227  1.00 16.41           O  
ATOM   1834  CB  SER A 230       9.149 -13.857  20.687  1.00 18.05           C  
ATOM   1835  OG  SER A 230       8.472 -12.886  21.467  1.00 18.53           O  
ATOM   1836  N   ALA A 231      12.033 -14.265  22.089  1.00 16.26           N  
ATOM   1837  CA  ALA A 231      12.834 -14.217  23.309  1.00 16.74           C  
ATOM   1838  C   ALA A 231      14.279 -13.813  23.012  1.00 17.35           C  
ATOM   1839  O   ALA A 231      15.104 -13.711  23.929  1.00 16.86           O  
ATOM   1840  CB  ALA A 231      12.814 -15.579  23.987  1.00 16.90           C  
ATOM   1841  N   VAL A 232      14.576 -13.574  21.735  1.00 15.60           N  
ATOM   1842  CA  VAL A 232      15.927 -13.218  21.299  1.00 15.27           C  
ATOM   1843  C   VAL A 232      16.873 -14.283  21.840  1.00 16.09           C  
ATOM   1844  O   VAL A 232      17.919 -13.996  22.430  1.00 15.50           O  
ATOM   1845  CB  VAL A 232      16.359 -11.822  21.806  1.00 15.95           C  
ATOM   1846  CG1 VAL A 232      17.643 -11.400  21.105  1.00 17.83           C  
ATOM   1847  CG2 VAL A 232      15.259 -10.806  21.532  1.00 15.41           C  
ATOM   1848  N   ASN A 233      16.474 -15.525  21.606  1.00 14.68           N  
ATOM   1849  CA  ASN A 233      17.194 -16.710  22.042  1.00 15.70           C  
ATOM   1850  C   ASN A 233      18.274 -17.143  21.044  1.00 15.10           C  
ATOM   1851  O   ASN A 233      18.041 -18.018  20.217  1.00 16.51           O  
ATOM   1852  CB  ASN A 233      16.183 -17.848  22.232  1.00 15.40           C  
ATOM   1853  CG  ASN A 233      16.774 -19.055  22.931  1.00 16.96           C  
ATOM   1854  OD1 ASN A 233      16.673 -19.190  24.149  1.00 19.10           O  
ATOM   1855  ND2 ASN A 233      17.395 -19.939  22.162  1.00 15.45           N  
ATOM   1856  N   TYR A 234      19.447 -16.521  21.113  1.00 16.01           N  
ATOM   1857  CA  TYR A 234      20.551 -16.892  20.232  1.00 15.62           C  
ATOM   1858  C   TYR A 234      21.874 -16.607  20.930  1.00 15.60           C  
ATOM   1859  O   TYR A 234      21.920 -15.860  21.912  1.00 15.95           O  
ATOM   1860  CB  TYR A 234      20.509 -16.110  18.909  1.00 14.85           C  
ATOM   1861  CG  TYR A 234      21.159 -14.740  18.982  1.00 14.72           C  
ATOM   1862  CD1 TYR A 234      20.480 -13.650  19.525  1.00 13.78           C  
ATOM   1863  CD2 TYR A 234      22.472 -14.547  18.546  1.00 16.70           C  
ATOM   1864  CE1 TYR A 234      21.090 -12.400  19.638  1.00 12.63           C  
ATOM   1865  CE2 TYR A 234      23.095 -13.300  18.658  1.00 15.60           C  
ATOM   1866  CZ  TYR A 234      22.397 -12.234  19.207  1.00 14.00           C  
ATOM   1867  OH  TYR A 234      23.012 -11.010  19.335  1.00 15.70           O  
ATOM   1868  N   GLU A 235      22.946 -17.195  20.412  1.00 15.63           N  
ATOM   1869  CA  GLU A 235      24.280 -16.984  20.960  1.00 16.76           C  
ATOM   1870  C   GLU A 235      25.315 -17.284  19.883  1.00 15.99           C  
ATOM   1871  O   GLU A 235      25.016 -17.952  18.895  1.00 16.22           O  
ATOM   1872  CB  GLU A 235      24.511 -17.876  22.187  1.00 18.08           C  
ATOM   1873  CG  GLU A 235      24.565 -19.369  21.899  1.00 18.89           C  
ATOM   1874  CD  GLU A 235      24.524 -20.211  23.169  1.00 19.58           C  
ATOM   1875  OE1 GLU A 235      24.696 -21.447  23.073  1.00 17.98           O  
ATOM   1876  OE2 GLU A 235      24.313 -19.639  24.259  1.00 20.21           O  
ATOM   1877  N   PHE A 236      26.526 -16.774  20.072  1.00 17.50           N  
ATOM   1878  CA  PHE A 236      27.612 -16.981  19.116  1.00 17.71           C  
ATOM   1879  C   PHE A 236      28.401 -18.230  19.500  1.00 18.06           C  
ATOM   1880  O   PHE A 236      29.383 -18.140  20.237  1.00 20.26           O  
ATOM   1881  CB  PHE A 236      28.552 -15.769  19.124  1.00 16.64           C  
ATOM   1882  CG  PHE A 236      27.901 -14.485  18.683  1.00 17.35           C  
ATOM   1883  CD1 PHE A 236      27.545 -14.291  17.351  1.00 16.10           C  
ATOM   1884  CD2 PHE A 236      27.649 -13.468  19.598  1.00 16.49           C  
ATOM   1885  CE1 PHE A 236      26.949 -13.098  16.936  1.00 15.96           C  
ATOM   1886  CE2 PHE A 236      27.051 -12.273  19.192  1.00 18.22           C  
ATOM   1887  CZ  PHE A 236      26.702 -12.090  17.855  1.00 16.95           C  
ATOM   1888  N   GLU A 237      27.985 -19.390  19.000  1.00 16.64           N  
ATOM   1889  CA  GLU A 237      28.674 -20.641  19.323  1.00 18.14           C  
ATOM   1890  C   GLU A 237      30.161 -20.549  18.979  1.00 19.26           C  
ATOM   1891  O   GLU A 237      30.532 -20.215  17.851  1.00 18.17           O  
ATOM   1892  CB  GLU A 237      28.041 -21.812  18.563  1.00 20.18           C  
ATOM   1893  CG  GLU A 237      26.551 -21.983  18.826  1.00 20.75           C  
ATOM   1894  CD  GLU A 237      26.235 -22.288  20.285  1.00 22.80           C  
ATOM   1895  OE1 GLU A 237      25.054 -22.163  20.674  1.00 22.00           O  
ATOM   1896  OE2 GLU A 237      27.163 -22.661  21.039  1.00 23.06           O  
ATOM   1897  N   ASP A 238      31.015 -20.845  19.955  1.00 20.41           N  
ATOM   1898  CA  ASP A 238      32.453 -20.785  19.728  1.00 22.24           C  
ATOM   1899  C   ASP A 238      32.906 -21.660  18.563  1.00 21.60           C  
ATOM   1900  O   ASP A 238      33.807 -21.281  17.813  1.00 21.45           O  
ATOM   1901  CB  ASP A 238      33.215 -21.183  20.998  1.00 25.76           C  
ATOM   1902  CG  ASP A 238      33.043 -20.175  22.118  1.00 28.64           C  
ATOM   1903  OD1 ASP A 238      32.992 -18.964  21.822  1.00 32.58           O  
ATOM   1904  OD2 ASP A 238      32.973 -20.586  23.298  1.00 32.24           O  
ATOM   1905  N   GLU A 239      32.286 -22.825  18.400  1.00 19.63           N  
ATOM   1906  CA  GLU A 239      32.682 -23.709  17.311  1.00 20.76           C  
ATOM   1907  C   GLU A 239      32.535 -23.016  15.960  1.00 21.32           C  
ATOM   1908  O   GLU A 239      33.269 -23.313  15.016  1.00 18.95           O  
ATOM   1909  CB  GLU A 239      31.851 -24.997  17.318  1.00 20.50           C  
ATOM   1910  CG  GLU A 239      32.201 -25.940  16.173  1.00 21.14           C  
ATOM   1911  CD  GLU A 239      31.496 -27.280  16.255  1.00 22.27           C  
ATOM   1912  OE1 GLU A 239      31.582 -28.049  15.273  1.00 24.18           O  
ATOM   1913  OE2 GLU A 239      30.867 -27.574  17.292  1.00 18.58           O  
ATOM   1914  N   TYR A 240      31.597 -22.075  15.886  1.00 21.65           N  
ATOM   1915  CA  TYR A 240      31.331 -21.342  14.655  1.00 23.04           C  
ATOM   1916  C   TYR A 240      31.982 -19.957  14.597  1.00 23.00           C  
ATOM   1917  O   TYR A 240      32.397 -19.510  13.527  1.00 23.98           O  
ATOM   1918  CB  TYR A 240      29.817 -21.187  14.473  1.00 26.69           C  
ATOM   1919  CG  TYR A 240      29.058 -22.495  14.355  1.00 30.87           C  
ATOM   1920  CD1 TYR A 240      27.712 -22.571  14.704  1.00 33.96           C  
ATOM   1921  CD2 TYR A 240      29.680 -23.647  13.865  1.00 34.13           C  
ATOM   1922  CE1 TYR A 240      26.999 -23.759  14.570  1.00 34.98           C  
ATOM   1923  CE2 TYR A 240      28.974 -24.843  13.726  1.00 36.31           C  
ATOM   1924  CZ  TYR A 240      27.633 -24.889  14.081  1.00 36.79           C  
ATOM   1925  OH  TYR A 240      26.921 -26.060  13.932  1.00 37.49           O  
ATOM   1926  N   PHE A 241      32.083 -19.288  15.743  1.00 22.21           N  
ATOM   1927  CA  PHE A 241      32.634 -17.935  15.780  1.00 23.41           C  
ATOM   1928  C   PHE A 241      33.992 -17.732  16.446  1.00 24.32           C  
ATOM   1929  O   PHE A 241      34.415 -16.590  16.627  1.00 23.93           O  
ATOM   1930  CB  PHE A 241      31.635 -16.984  16.451  1.00 20.48           C  
ATOM   1931  CG  PHE A 241      30.350 -16.812  15.690  1.00 19.73           C  
ATOM   1932  CD1 PHE A 241      29.298 -17.700  15.863  1.00 18.63           C  
ATOM   1933  CD2 PHE A 241      30.202 -15.762  14.784  1.00 18.40           C  
ATOM   1934  CE1 PHE A 241      28.110 -17.551  15.147  1.00 17.90           C  
ATOM   1935  CE2 PHE A 241      29.021 -15.603  14.063  1.00 19.49           C  
ATOM   1936  CZ  PHE A 241      27.970 -16.503  14.248  1.00 17.39           C  
ATOM   1937  N   SER A 242      34.674 -18.816  16.804  1.00 26.31           N  
ATOM   1938  CA  SER A 242      35.973 -18.706  17.470  1.00 27.93           C  
ATOM   1939  C   SER A 242      36.959 -17.791  16.747  1.00 27.22           C  
ATOM   1940  O   SER A 242      37.743 -17.094  17.388  1.00 29.11           O  
ATOM   1941  CB  SER A 242      36.608 -20.089  17.645  1.00 28.11           C  
ATOM   1942  OG  SER A 242      36.928 -20.661  16.390  1.00 30.18           O  
ATOM   1943  N   ASN A 243      36.921 -17.784  15.420  1.00 27.24           N  
ATOM   1944  CA  ASN A 243      37.835 -16.947  14.649  1.00 28.06           C  
ATOM   1945  C   ASN A 243      37.181 -15.727  14.011  1.00 25.47           C  
ATOM   1946  O   ASN A 243      37.728 -15.147  13.072  1.00 25.80           O  
ATOM   1947  CB  ASN A 243      38.526 -17.784  13.571  1.00 31.67           C  
ATOM   1948  CG  ASN A 243      39.583 -18.711  14.141  1.00 35.99           C  
ATOM   1949  OD1 ASN A 243      40.077 -19.603  13.453  1.00 39.49           O  
ATOM   1950  ND2 ASN A 243      39.943 -18.496  15.406  1.00 37.51           N  
ATOM   1951  N   THR A 244      36.011 -15.345  14.516  1.00 21.90           N  
ATOM   1952  CA  THR A 244      35.292 -14.178  14.006  1.00 20.70           C  
ATOM   1953  C   THR A 244      35.652 -13.000  14.907  1.00 18.54           C  
ATOM   1954  O   THR A 244      35.756 -13.161  16.119  1.00 18.67           O  
ATOM   1955  CB  THR A 244      33.774 -14.404  14.052  1.00 20.81           C  
ATOM   1956  OG1 THR A 244      33.452 -15.575  13.298  1.00 22.65           O  
ATOM   1957  CG2 THR A 244      33.030 -13.204  13.465  1.00 17.55           C  
ATOM   1958  N   SER A 245      35.841 -11.819  14.324  1.00 17.88           N  
ATOM   1959  CA  SER A 245      36.223 -10.648  15.109  1.00 16.25           C  
ATOM   1960  C   SER A 245      35.127 -10.209  16.062  1.00 16.74           C  
ATOM   1961  O   SER A 245      33.946 -10.445  15.821  1.00 13.75           O  
ATOM   1962  CB  SER A 245      36.587  -9.479  14.190  1.00 15.07           C  
ATOM   1963  OG  SER A 245      35.440  -8.966  13.533  1.00 15.87           O  
ATOM   1964  N   ALA A 246      35.524  -9.557  17.150  1.00 16.61           N  
ATOM   1965  CA  ALA A 246      34.562  -9.076  18.127  1.00 16.83           C  
ATOM   1966  C   ALA A 246      33.705  -7.974  17.505  1.00 16.17           C  
ATOM   1967  O   ALA A 246      32.553  -7.793  17.893  1.00 14.70           O  
ATOM   1968  CB  ALA A 246      35.284  -8.553  19.359  1.00 18.08           C  
ATOM   1969  N   LEU A 247      34.267  -7.246  16.536  1.00 15.09           N  
ATOM   1970  CA  LEU A 247      33.533  -6.171  15.869  1.00 16.25           C  
ATOM   1971  C   LEU A 247      32.386  -6.728  15.042  1.00 14.68           C  
ATOM   1972  O   LEU A 247      31.325  -6.115  14.947  1.00 14.96           O  
ATOM   1973  CB  LEU A 247      34.453  -5.358  14.951  1.00 19.05           C  
ATOM   1974  CG  LEU A 247      34.885  -3.960  15.393  1.00 19.77           C  
ATOM   1975  CD1 LEU A 247      35.561  -3.270  14.219  1.00 18.75           C  
ATOM   1976  CD2 LEU A 247      33.678  -3.143  15.859  1.00 20.52           C  
ATOM   1977  N   ALA A 248      32.609  -7.884  14.425  1.00 15.35           N  
ATOM   1978  CA  ALA A 248      31.574  -8.529  13.621  1.00 13.90           C  
ATOM   1979  C   ALA A 248      30.418  -8.928  14.539  1.00 14.15           C  
ATOM   1980  O   ALA A 248      29.246  -8.757  14.195  1.00 13.38           O  
ATOM   1981  CB  ALA A 248      32.141  -9.761  12.922  1.00 11.64           C  
ATOM   1982  N   LYS A 249      30.754  -9.465  15.710  1.00 14.11           N  
ATOM   1983  CA  LYS A 249      29.733  -9.866  16.670  1.00 12.92           C  
ATOM   1984  C   LYS A 249      29.001  -8.634  17.197  1.00 13.53           C  
ATOM   1985  O   LYS A 249      27.796  -8.674  17.433  1.00 13.01           O  
ATOM   1986  CB  LYS A 249      30.364 -10.639  17.832  1.00 14.21           C  
ATOM   1987  CG  LYS A 249      30.937 -11.994  17.437  1.00 16.66           C  
ATOM   1988  CD  LYS A 249      31.571 -12.688  18.634  1.00 20.15           C  
ATOM   1989  CE  LYS A 249      32.135 -14.042  18.246  1.00 23.39           C  
ATOM   1990  NZ  LYS A 249      32.689 -14.774  19.427  1.00 26.06           N  
ATOM   1991  N   ASP A 250      29.735  -7.542  17.379  1.00 12.05           N  
ATOM   1992  CA  ASP A 250      29.153  -6.292  17.858  1.00 13.43           C  
ATOM   1993  C   ASP A 250      28.093  -5.818  16.862  1.00 13.03           C  
ATOM   1994  O   ASP A 250      26.991  -5.424  17.250  1.00 12.81           O  
ATOM   1995  CB  ASP A 250      30.257  -5.237  18.013  1.00 15.05           C  
ATOM   1996  CG  ASP A 250      29.730  -3.892  18.499  1.00 17.49           C  
ATOM   1997  OD1 ASP A 250      29.106  -3.162  17.700  1.00 17.36           O  
ATOM   1998  OD2 ASP A 250      29.944  -3.563  19.685  1.00 20.03           O  
ATOM   1999  N   PHE A 251      28.431  -5.871  15.576  1.00 12.86           N  
ATOM   2000  CA  PHE A 251      27.515  -5.467  14.512  1.00 12.86           C  
ATOM   2001  C   PHE A 251      26.208  -6.254  14.619  1.00 12.69           C  
ATOM   2002  O   PHE A 251      25.120  -5.679  14.634  1.00 12.59           O  
ATOM   2003  CB  PHE A 251      28.182  -5.710  13.150  1.00 13.05           C  
ATOM   2004  CG  PHE A 251      27.340  -5.314  11.971  1.00 11.85           C  
ATOM   2005  CD1 PHE A 251      26.511  -6.238  11.347  1.00 12.28           C  
ATOM   2006  CD2 PHE A 251      27.403  -4.021  11.465  1.00 12.21           C  
ATOM   2007  CE1 PHE A 251      25.757  -5.879  10.229  1.00 13.68           C  
ATOM   2008  CE2 PHE A 251      26.651  -3.651  10.346  1.00 11.76           C  
ATOM   2009  CZ  PHE A 251      25.830  -4.583   9.729  1.00 13.59           C  
ATOM   2010  N   ILE A 252      26.327  -7.576  14.704  1.00 13.38           N  
ATOM   2011  CA  ILE A 252      25.166  -8.450  14.818  1.00 14.45           C  
ATOM   2012  C   ILE A 252      24.361  -8.166  16.082  1.00 14.60           C  
ATOM   2013  O   ILE A 252      23.136  -8.055  16.041  1.00 14.16           O  
ATOM   2014  CB  ILE A 252      25.598  -9.936  14.830  1.00 15.70           C  
ATOM   2015  CG1 ILE A 252      26.194 -10.312  13.471  1.00 15.31           C  
ATOM   2016  CG2 ILE A 252      24.402 -10.830  15.141  1.00 16.63           C  
ATOM   2017  CD1 ILE A 252      26.984 -11.619  13.453  1.00 15.39           C  
ATOM   2018  N   ARG A 253      25.060  -8.051  17.206  1.00 14.65           N  
ATOM   2019  CA  ARG A 253      24.420  -7.800  18.492  1.00 15.39           C  
ATOM   2020  C   ARG A 253      23.542  -6.546  18.504  1.00 15.22           C  
ATOM   2021  O   ARG A 253      22.511  -6.508  19.180  1.00 15.79           O  
ATOM   2022  CB  ARG A 253      25.498  -7.687  19.571  1.00 18.57           C  
ATOM   2023  CG  ARG A 253      24.998  -7.782  20.994  1.00 25.91           C  
ATOM   2024  CD  ARG A 253      25.640  -8.972  21.700  1.00 31.13           C  
ATOM   2025  NE  ARG A 253      27.081  -9.047  21.463  1.00 33.67           N  
ATOM   2026  CZ  ARG A 253      27.868 -10.012  21.931  1.00 35.69           C  
ATOM   2027  NH1 ARG A 253      29.169 -10.002  21.661  1.00 36.31           N  
ATOM   2028  NH2 ARG A 253      27.360 -10.988  22.674  1.00 37.96           N  
ATOM   2029  N   ARG A 254      23.944  -5.524  17.756  1.00 13.63           N  
ATOM   2030  CA  ARG A 254      23.188  -4.273  17.712  1.00 12.87           C  
ATOM   2031  C   ARG A 254      21.995  -4.305  16.762  1.00 13.99           C  
ATOM   2032  O   ARG A 254      21.203  -3.360  16.714  1.00 14.43           O  
ATOM   2033  CB  ARG A 254      24.122  -3.115  17.355  1.00 13.68           C  
ATOM   2034  CG  ARG A 254      25.214  -2.901  18.393  1.00 16.38           C  
ATOM   2035  CD  ARG A 254      26.118  -1.724  18.056  1.00 18.91           C  
ATOM   2036  NE  ARG A 254      27.264  -1.680  18.960  1.00 20.53           N  
ATOM   2037  CZ  ARG A 254      27.208  -1.292  20.229  1.00 22.04           C  
ATOM   2038  NH1 ARG A 254      26.056  -0.898  20.758  1.00 23.15           N  
ATOM   2039  NH2 ARG A 254      28.303  -1.323  20.977  1.00 21.55           N  
ATOM   2040  N   LEU A 255      21.871  -5.390  16.004  1.00 13.52           N  
ATOM   2041  CA  LEU A 255      20.757  -5.560  15.072  1.00 12.84           C  
ATOM   2042  C   LEU A 255      19.723  -6.519  15.652  1.00 12.91           C  
ATOM   2043  O   LEU A 255      18.517  -6.334  15.472  1.00 11.68           O  
ATOM   2044  CB  LEU A 255      21.264  -6.099  13.727  1.00 11.78           C  
ATOM   2045  CG  LEU A 255      22.099  -5.127  12.889  1.00 11.46           C  
ATOM   2046  CD1 LEU A 255      22.779  -5.877  11.747  1.00 12.05           C  
ATOM   2047  CD2 LEU A 255      21.206  -4.021  12.344  1.00 13.67           C  
ATOM   2048  N   LEU A 256      20.198  -7.552  16.345  1.00 12.27           N  
ATOM   2049  CA  LEU A 256      19.304  -8.537  16.945  1.00 11.61           C  
ATOM   2050  C   LEU A 256      18.876  -8.038  18.326  1.00 13.59           C  
ATOM   2051  O   LEU A 256      19.182  -8.637  19.353  1.00 13.32           O  
ATOM   2052  CB  LEU A 256      20.009  -9.900  17.028  1.00 14.14           C  
ATOM   2053  CG  LEU A 256      20.425 -10.483  15.666  1.00 13.62           C  
ATOM   2054  CD1 LEU A 256      20.965 -11.899  15.853  1.00 14.73           C  
ATOM   2055  CD2 LEU A 256      19.232 -10.507  14.710  1.00 14.11           C  
ATOM   2056  N   VAL A 257      18.155  -6.922  18.308  1.00 11.45           N  
ATOM   2057  CA  VAL A 257      17.656  -6.235  19.495  1.00 15.62           C  
ATOM   2058  C   VAL A 257      16.131  -6.257  19.449  1.00 14.36           C  
ATOM   2059  O   VAL A 257      15.535  -5.823  18.467  1.00 15.12           O  
ATOM   2060  CB  VAL A 257      18.142  -4.775  19.480  1.00 15.34           C  
ATOM   2061  CG1 VAL A 257      17.592  -4.002  20.663  1.00 18.27           C  
ATOM   2062  CG2 VAL A 257      19.648  -4.762  19.469  1.00 15.35           C  
ATOM   2063  N   LYS A 258      15.501  -6.744  20.511  1.00 13.69           N  
ATOM   2064  CA  LYS A 258      14.046  -6.834  20.528  1.00 16.38           C  
ATOM   2065  C   LYS A 258      13.292  -5.513  20.325  1.00 16.40           C  
ATOM   2066  O   LYS A 258      12.367  -5.442  19.508  1.00 15.72           O  
ATOM   2067  CB  LYS A 258      13.567  -7.512  21.814  1.00 16.40           C  
ATOM   2068  CG  LYS A 258      12.071  -7.781  21.793  1.00 21.43           C  
ATOM   2069  CD  LYS A 258      11.635  -8.799  22.826  1.00 23.57           C  
ATOM   2070  CE  LYS A 258      10.164  -9.159  22.603  1.00 24.66           C  
ATOM   2071  NZ  LYS A 258       9.693 -10.233  23.511  1.00 26.54           N  
ATOM   2072  N   ASP A 259      13.675  -4.474  21.058  1.00 18.10           N  
ATOM   2073  CA  ASP A 259      13.014  -3.177  20.930  1.00 18.11           C  
ATOM   2074  C   ASP A 259      13.444  -2.516  19.616  1.00 18.06           C  
ATOM   2075  O   ASP A 259      14.596  -2.109  19.466  1.00 16.44           O  
ATOM   2076  CB  ASP A 259      13.392  -2.275  22.109  1.00 20.75           C  
ATOM   2077  CG  ASP A 259      12.595  -0.985  22.135  1.00 23.55           C  
ATOM   2078  OD1 ASP A 259      11.920  -0.679  21.129  1.00 25.17           O  
ATOM   2079  OD2 ASP A 259      12.649  -0.274  23.164  1.00 22.98           O  
ATOM   2080  N   PRO A 260      12.515  -2.389  18.653  1.00 18.78           N  
ATOM   2081  CA  PRO A 260      12.808  -1.779  17.349  1.00 20.33           C  
ATOM   2082  C   PRO A 260      13.467  -0.409  17.463  1.00 21.17           C  
ATOM   2083  O   PRO A 260      14.291  -0.037  16.627  1.00 19.53           O  
ATOM   2084  CB  PRO A 260      11.431  -1.682  16.686  1.00 19.52           C  
ATOM   2085  CG  PRO A 260      10.640  -2.756  17.347  1.00 21.56           C  
ATOM   2086  CD  PRO A 260      11.076  -2.673  18.786  1.00 18.05           C  
ATOM   2087  N   LYS A 261      13.106   0.339  18.503  1.00 21.12           N  
ATOM   2088  CA  LYS A 261      13.653   1.678  18.694  1.00 23.46           C  
ATOM   2089  C   LYS A 261      15.121   1.712  19.113  1.00 22.20           C  
ATOM   2090  O   LYS A 261      15.807   2.709  18.890  1.00 21.60           O  
ATOM   2091  CB  LYS A 261      12.805   2.452  19.713  1.00 26.78           C  
ATOM   2092  CG  LYS A 261      11.343   2.602  19.296  1.00 30.98           C  
ATOM   2093  CD  LYS A 261      10.582   3.593  20.176  1.00 35.18           C  
ATOM   2094  CE  LYS A 261      10.509   3.131  21.622  1.00 37.32           C  
ATOM   2095  NZ  LYS A 261       9.787   4.119  22.480  1.00 41.29           N  
ATOM   2096  N   LYS A 262      15.602   0.622  19.703  1.00 20.20           N  
ATOM   2097  CA  LYS A 262      16.987   0.540  20.155  1.00 19.37           C  
ATOM   2098  C   LYS A 262      17.883  -0.168  19.141  1.00 18.36           C  
ATOM   2099  O   LYS A 262      19.101  -0.201  19.291  1.00 16.40           O  
ATOM   2100  CB  LYS A 262      17.045  -0.201  21.495  1.00 20.39           C  
ATOM   2101  CG  LYS A 262      16.293   0.500  22.621  1.00 24.13           C  
ATOM   2102  CD  LYS A 262      16.086  -0.427  23.805  1.00 27.44           C  
ATOM   2103  CE  LYS A 262      15.161   0.204  24.845  1.00 29.33           C  
ATOM   2104  NZ  LYS A 262      14.483  -0.828  25.686  1.00 31.65           N  
ATOM   2105  N   ARG A 263      17.266  -0.728  18.109  1.00 16.69           N  
ATOM   2106  CA  ARG A 263      17.976  -1.452  17.054  1.00 15.85           C  
ATOM   2107  C   ARG A 263      18.700  -0.469  16.119  1.00 15.54           C  
ATOM   2108  O   ARG A 263      18.225   0.642  15.900  1.00 16.43           O  
ATOM   2109  CB  ARG A 263      16.945  -2.277  16.273  1.00 17.22           C  
ATOM   2110  CG  ARG A 263      17.481  -3.376  15.371  1.00 17.65           C  
ATOM   2111  CD  ARG A 263      16.296  -4.121  14.735  1.00 15.09           C  
ATOM   2112  NE  ARG A 263      15.438  -4.757  15.738  1.00 15.21           N  
ATOM   2113  CZ  ARG A 263      14.141  -5.007  15.564  1.00 15.30           C  
ATOM   2114  NH1 ARG A 263      13.542  -4.674  14.423  1.00 12.70           N  
ATOM   2115  NH2 ARG A 263      13.438  -5.584  16.530  1.00 15.25           N  
ATOM   2116  N   MET A 264      19.853  -0.863  15.580  1.00 15.51           N  
ATOM   2117  CA  MET A 264      20.571   0.022  14.663  1.00 15.04           C  
ATOM   2118  C   MET A 264      19.711   0.287  13.433  1.00 15.00           C  
ATOM   2119  O   MET A 264      18.981  -0.596  12.972  1.00 15.12           O  
ATOM   2120  CB  MET A 264      21.892  -0.596  14.182  1.00 16.84           C  
ATOM   2121  CG  MET A 264      23.052  -0.543  15.160  1.00 15.57           C  
ATOM   2122  SD  MET A 264      24.632  -0.667  14.263  1.00 17.30           S  
ATOM   2123  CE  MET A 264      24.551  -2.327  13.561  1.00 14.28           C  
ATOM   2124  N   THR A 265      19.797   1.504  12.911  1.00 13.97           N  
ATOM   2125  CA  THR A 265      19.059   1.879  11.712  1.00 13.96           C  
ATOM   2126  C   THR A 265      19.979   1.559  10.537  1.00 13.58           C  
ATOM   2127  O   THR A 265      21.133   1.175  10.738  1.00 12.38           O  
ATOM   2128  CB  THR A 265      18.741   3.382  11.684  1.00 15.15           C  
ATOM   2129  OG1 THR A 265      19.966   4.123  11.683  1.00 14.05           O  
ATOM   2130  CG2 THR A 265      17.906   3.776  12.894  1.00 14.78           C  
ATOM   2131  N   ILE A 266      19.480   1.710   9.314  1.00 13.26           N  
ATOM   2132  CA  ILE A 266      20.304   1.420   8.147  1.00 13.42           C  
ATOM   2133  C   ILE A 266      21.489   2.384   8.095  1.00 15.00           C  
ATOM   2134  O   ILE A 266      22.595   1.997   7.711  1.00 13.18           O  
ATOM   2135  CB  ILE A 266      19.478   1.491   6.836  1.00 14.42           C  
ATOM   2136  CG1 ILE A 266      20.337   1.020   5.656  1.00 13.07           C  
ATOM   2137  CG2 ILE A 266      18.948   2.903   6.619  1.00 12.37           C  
ATOM   2138  CD1 ILE A 266      20.577  -0.486   5.598  1.00 15.92           C  
ATOM   2139  N   GLN A 267      21.274   3.630   8.509  1.00 15.61           N  
ATOM   2140  CA  GLN A 267      22.367   4.600   8.519  1.00 17.94           C  
ATOM   2141  C   GLN A 267      23.393   4.215   9.592  1.00 17.17           C  
ATOM   2142  O   GLN A 267      24.597   4.348   9.380  1.00 16.76           O  
ATOM   2143  CB  GLN A 267      21.830   6.020   8.755  1.00 18.76           C  
ATOM   2144  CG  GLN A 267      20.887   6.484   7.643  1.00 25.64           C  
ATOM   2145  CD  GLN A 267      20.484   7.947   7.757  1.00 28.16           C  
ATOM   2146  OE1 GLN A 267      19.733   8.461   6.923  1.00 31.89           O  
ATOM   2147  NE2 GLN A 267      20.981   8.621   8.782  1.00 29.98           N  
ATOM   2148  N   ASP A 268      22.917   3.733  10.741  1.00 16.36           N  
ATOM   2149  CA  ASP A 268      23.823   3.307  11.808  1.00 16.34           C  
ATOM   2150  C   ASP A 268      24.697   2.162  11.301  1.00 15.19           C  
ATOM   2151  O   ASP A 268      25.905   2.146  11.532  1.00 14.20           O  
ATOM   2152  CB  ASP A 268      23.066   2.784  13.038  1.00 16.13           C  
ATOM   2153  CG  ASP A 268      22.359   3.874  13.815  1.00 19.67           C  
ATOM   2154  OD1 ASP A 268      22.843   5.027  13.824  1.00 19.72           O  
ATOM   2155  OD2 ASP A 268      21.318   3.561  14.438  1.00 17.97           O  
ATOM   2156  N   SER A 269      24.074   1.202  10.617  1.00 13.38           N  
ATOM   2157  CA  SER A 269      24.793   0.039  10.107  1.00 13.41           C  
ATOM   2158  C   SER A 269      25.888   0.413   9.123  1.00 14.00           C  
ATOM   2159  O   SER A 269      26.940  -0.223   9.097  1.00 13.07           O  
ATOM   2160  CB  SER A 269      23.823  -0.956   9.453  1.00 13.73           C  
ATOM   2161  OG  SER A 269      23.403  -0.518   8.174  1.00 16.87           O  
ATOM   2162  N   LEU A 270      25.653   1.451   8.323  1.00 13.99           N  
ATOM   2163  CA  LEU A 270      26.651   1.890   7.349  1.00 14.69           C  
ATOM   2164  C   LEU A 270      27.811   2.642   7.999  1.00 15.59           C  
ATOM   2165  O   LEU A 270      28.901   2.725   7.425  1.00 16.20           O  
ATOM   2166  CB  LEU A 270      26.000   2.771   6.278  1.00 16.44           C  
ATOM   2167  CG  LEU A 270      25.064   2.028   5.315  1.00 17.43           C  
ATOM   2168  CD1 LEU A 270      24.308   3.024   4.455  1.00 18.26           C  
ATOM   2169  CD2 LEU A 270      25.873   1.071   4.448  1.00 17.27           C  
ATOM   2170  N   GLN A 271      27.581   3.186   9.189  1.00 16.06           N  
ATOM   2171  CA  GLN A 271      28.618   3.925   9.909  1.00 17.46           C  
ATOM   2172  C   GLN A 271      29.305   3.077  10.984  1.00 14.94           C  
ATOM   2173  O   GLN A 271      30.270   3.518  11.611  1.00 15.35           O  
ATOM   2174  CB  GLN A 271      28.022   5.178  10.555  1.00 18.18           C  
ATOM   2175  CG  GLN A 271      27.324   6.090   9.564  1.00 25.01           C  
ATOM   2176  CD  GLN A 271      28.256   6.574   8.471  1.00 27.01           C  
ATOM   2177  OE1 GLN A 271      27.835   6.798   7.337  1.00 31.96           O  
ATOM   2178  NE2 GLN A 271      29.529   6.748   8.810  1.00 28.00           N  
ATOM   2179  N   HIS A 272      28.800   1.869  11.207  1.00 14.76           N  
ATOM   2180  CA  HIS A 272      29.382   0.967  12.202  1.00 13.74           C  
ATOM   2181  C   HIS A 272      30.832   0.682  11.815  1.00 14.75           C  
ATOM   2182  O   HIS A 272      31.136   0.451  10.646  1.00 15.52           O  
ATOM   2183  CB  HIS A 272      28.571  -0.331  12.254  1.00 14.50           C  
ATOM   2184  CG  HIS A 272      28.984  -1.273  13.345  1.00 13.44           C  
ATOM   2185  ND1 HIS A 272      30.123  -2.043  13.274  1.00 12.67           N  
ATOM   2186  CD2 HIS A 272      28.386  -1.592  14.519  1.00 14.52           C  
ATOM   2187  CE1 HIS A 272      30.209  -2.799  14.356  1.00 16.11           C  
ATOM   2188  NE2 HIS A 272      29.168  -2.544  15.127  1.00 14.54           N  
ATOM   2189  N   PRO A 273      31.749   0.692  12.798  1.00 17.10           N  
ATOM   2190  CA  PRO A 273      33.180   0.446  12.599  1.00 17.65           C  
ATOM   2191  C   PRO A 273      33.540  -0.774  11.757  1.00 18.14           C  
ATOM   2192  O   PRO A 273      34.567  -0.784  11.081  1.00 18.86           O  
ATOM   2193  CB  PRO A 273      33.705   0.331  14.026  1.00 17.94           C  
ATOM   2194  CG  PRO A 273      32.833   1.276  14.767  1.00 18.58           C  
ATOM   2195  CD  PRO A 273      31.461   0.945  14.221  1.00 17.37           C  
ATOM   2196  N   TRP A 274      32.707  -1.808  11.806  1.00 17.10           N  
ATOM   2197  CA  TRP A 274      32.971  -3.021  11.036  1.00 18.00           C  
ATOM   2198  C   TRP A 274      32.732  -2.787   9.543  1.00 19.60           C  
ATOM   2199  O   TRP A 274      33.397  -3.387   8.698  1.00 19.62           O  
ATOM   2200  CB  TRP A 274      32.063  -4.157  11.527  1.00 17.18           C  
ATOM   2201  CG  TRP A 274      32.405  -5.520  10.978  1.00 16.99           C  
ATOM   2202  CD1 TRP A 274      33.614  -6.154  11.041  1.00 16.96           C  
ATOM   2203  CD2 TRP A 274      31.507  -6.438  10.342  1.00 16.89           C  
ATOM   2204  NE1 TRP A 274      33.524  -7.411  10.489  1.00 15.49           N  
ATOM   2205  CE2 TRP A 274      32.241  -7.610  10.053  1.00 16.10           C  
ATOM   2206  CE3 TRP A 274      30.151  -6.383   9.991  1.00 15.42           C  
ATOM   2207  CZ2 TRP A 274      31.665  -8.721   9.429  1.00 16.11           C  
ATOM   2208  CZ3 TRP A 274      29.577  -7.489   9.368  1.00 17.26           C  
ATOM   2209  CH2 TRP A 274      30.336  -8.643   9.093  1.00 18.08           C  
ATOM   2210  N   ILE A 275      31.787  -1.905   9.234  1.00 19.64           N  
ATOM   2211  CA  ILE A 275      31.423  -1.592   7.851  1.00 21.95           C  
ATOM   2212  C   ILE A 275      32.116  -0.350   7.298  1.00 24.22           C  
ATOM   2213  O   ILE A 275      32.651  -0.374   6.191  1.00 24.83           O  
ATOM   2214  CB  ILE A 275      29.896  -1.373   7.717  1.00 20.11           C  
ATOM   2215  CG1 ILE A 275      29.136  -2.640   8.130  1.00 19.54           C  
ATOM   2216  CG2 ILE A 275      29.548  -0.952   6.291  1.00 18.99           C  
ATOM   2217  CD1 ILE A 275      29.400  -3.927   7.305  1.00 21.69           C  
ATOM   2218  N   LYS A 276      32.075   0.733   8.071  1.00 27.23           N  
ATOM   2219  CA  LYS A 276      32.669   2.016   7.692  1.00 31.61           C  
ATOM   2220  C   LYS A 276      34.091   1.846   7.165  1.00 33.86           C  
ATOM   2221  O   LYS A 276      34.970   1.349   7.868  1.00 33.99           O  
ATOM   2222  CB  LYS A 276      32.672   2.956   8.901  1.00 33.31           C  
ATOM   2223  CG  LYS A 276      33.140   4.381   8.621  1.00 35.09           C  
ATOM   2224  CD  LYS A 276      32.114   5.168   7.821  1.00 37.20           C  
ATOM   2225  CE  LYS A 276      32.500   6.642   7.734  1.00 37.94           C  
ATOM   2226  NZ  LYS A 276      31.464   7.454   7.044  1.00 36.17           N  
ATOM   2227  N   PRO A 277      34.334   2.261   5.911  1.00 36.62           N  
ATOM   2228  CA  PRO A 277      35.657   2.151   5.287  1.00 38.49           C  
ATOM   2229  C   PRO A 277      36.633   3.220   5.771  1.00 39.34           C  
ATOM   2230  O   PRO A 277      36.902   3.227   6.991  1.00 41.83           O  
ATOM   2231  CB  PRO A 277      35.339   2.285   3.805  1.00 38.69           C  
ATOM   2232  CG  PRO A 277      34.236   3.290   3.816  1.00 38.76           C  
ATOM   2233  CD  PRO A 277      33.351   2.798   4.952  1.00 38.03           C  
ATOM   2234  N   PRO A 291       2.306 -19.831   5.626  1.00 63.19           N  
ATOM   2235  CA  PRO A 291       3.354 -18.809   5.848  1.00 62.47           C  
ATOM   2236  C   PRO A 291       4.167 -19.132   7.099  1.00 61.70           C  
ATOM   2237  O   PRO A 291       5.193 -19.813   7.034  1.00 61.47           O  
ATOM   2238  CB  PRO A 291       2.648 -17.470   5.999  1.00 62.83           C  
ATOM   2239  CG  PRO A 291       1.333 -17.732   5.259  1.00 63.37           C  
ATOM   2240  CD  PRO A 291       0.982 -19.188   5.586  1.00 63.34           C  
ATOM   2241  N   GLN A 292       3.700 -18.640   8.241  1.00 60.60           N  
ATOM   2242  CA  GLN A 292       4.374 -18.881   9.509  1.00 59.22           C  
ATOM   2243  C   GLN A 292       3.583 -19.893  10.322  1.00 58.30           C  
ATOM   2244  O   GLN A 292       3.714 -19.949  11.543  1.00 57.82           O  
ATOM   2245  CB  GLN A 292       4.491 -17.578  10.308  1.00 59.23           C  
ATOM   2246  CG  GLN A 292       3.189 -17.085  10.954  1.00 59.28           C  
ATOM   2247  CD  GLN A 292       2.239 -16.410   9.979  1.00 59.86           C  
ATOM   2248  OE1 GLN A 292       1.165 -15.947  10.367  1.00 59.55           O  
ATOM   2249  NE2 GLN A 292       2.632 -16.344   8.713  1.00 59.57           N  
ATOM   2250  N   PHE A 293       2.778 -20.708   9.649  1.00 57.77           N  
ATOM   2251  CA  PHE A 293       1.950 -21.671  10.364  1.00 57.62           C  
ATOM   2252  C   PHE A 293       2.130 -23.166  10.202  1.00 58.20           C  
ATOM   2253  O   PHE A 293       2.876 -23.651   9.353  1.00 58.39           O  
ATOM   2254  CB  PHE A 293       0.476 -21.335  10.139  1.00 56.77           C  
ATOM   2255  CG  PHE A 293      -0.014 -20.253  11.027  1.00 55.56           C  
ATOM   2256  CD1 PHE A 293       0.030 -20.418  12.404  1.00 55.23           C  
ATOM   2257  CD2 PHE A 293      -0.431 -19.038  10.506  1.00 55.41           C  
ATOM   2258  CE1 PHE A 293      -0.325 -19.390  13.254  1.00 54.65           C  
ATOM   2259  CE2 PHE A 293      -0.788 -18.004  11.349  1.00 54.91           C  
ATOM   2260  CZ  PHE A 293      -0.730 -18.183  12.729  1.00 54.48           C  
ATOM   2261  N   GLU A 294       1.406 -23.869  11.066  0.00 58.43           N  
ATOM   2262  CA  GLU A 294       1.369 -25.317  11.141  0.00 58.67           C  
ATOM   2263  C   GLU A 294       0.943 -25.943   9.818  0.00 58.72           C  
ATOM   2264  O   GLU A 294       1.557 -26.966   9.460  0.00 58.76           O  
ATOM   2265  CB  GLU A 294       0.391 -25.718  12.244  0.00 58.84           C  
ATOM   2266  CG  GLU A 294      -0.581 -24.595  12.623  0.00 59.06           C  
ATOM   2267  CD  GLU A 294      -1.560 -24.253  11.513  0.00 59.17           C  
ATOM   2268  OE1 GLU A 294      -1.104 -23.895  10.408  0.00 59.24           O  
ATOM   2269  OE2 GLU A 294      -2.782 -24.338  11.748  0.00 59.24           O  
TER    2270      GLU A 294                                                      
END
MOLECULE T0456.pdb
ATOM      1  N   TYR    15      -8.528 -16.941 -28.683  1.00 32.70           N
ATOM      2  CA  TYR    15      -7.549 -17.202 -27.583  1.00 32.76           C
ATOM      3  CB  TYR    15      -6.142 -17.430 -28.151  1.00 32.76           C
ATOM      4  CG  TYR    15      -5.905 -18.852 -28.611  1.00 32.74           C
ATOM      5  CD1 TYR    15      -5.266 -19.775 -27.781  1.00 32.73           C
ATOM      6  CE1 TYR    15      -5.050 -21.089 -28.196  1.00 32.87           C
ATOM      7  CZ  TYR    15      -5.483 -21.489 -29.454  1.00 32.91           C
ATOM      8  OH  TYR    15      -5.276 -22.784 -29.874  1.00 32.88           O
ATOM      9  CE2 TYR    15      -6.124 -20.591 -30.294  1.00 32.90           C
ATOM     10  CD2 TYR    15      -6.332 -19.280 -29.869  1.00 32.82           C
ATOM     11  C   TYR    15      -7.535 -16.113 -26.506  1.00 32.75           C
ATOM     12  O   TYR    15      -6.929 -16.296 -25.446  1.00 32.76           O
ATOM     13  N   PHE    16      -8.206 -14.992 -26.789  1.00 32.74           N
ATOM     14  CA  PHE    16      -8.354 -13.855 -25.863  1.00 32.72           C
ATOM     15  CB  PHE    16      -9.652 -13.975 -25.047  1.00 32.54           C
ATOM     16  CG  PHE    16     -10.905 -13.868 -25.873  1.00 32.23           C
ATOM     17  CD1 PHE    16     -11.621 -15.008 -26.221  1.00 31.82           C
ATOM     18  CE1 PHE    16     -12.782 -14.917 -26.986  1.00 31.83           C
ATOM     19  CZ  PHE    16     -13.235 -13.672 -27.411  1.00 32.10           C
ATOM     20  CE2 PHE    16     -12.527 -12.524 -27.068  1.00 31.82           C
ATOM     21  CD2 PHE    16     -11.370 -12.627 -26.302  1.00 31.90           C
ATOM     22  C   PHE    16      -7.152 -13.637 -24.939  1.00 32.93           C
ATOM     23  O   PHE    16      -7.300 -13.533 -23.717  1.00 32.92           O
ATOM     24  N   GLN    17      -5.966 -13.576 -25.541  1.00 33.17           N
ATOM     25  CA  GLN    17      -4.715 -13.408 -24.806  1.00 33.34           C
ATOM     26  CB  GLN    17      -3.528 -13.756 -25.699  1.00 33.35           C
ATOM     27  C   GLN    17      -4.591 -11.984 -24.263  1.00 33.46           C
ATOM     28  O   GLN    17      -5.263 -11.067 -24.746  1.00 33.47           O
ATOM     29  N   GLY    18      -3.737 -11.810 -23.257  1.00 33.55           N
ATOM     30  CA  GLY    18      -3.571 -10.516 -22.595  1.00 33.66           C
ATOM     31  C   GLY    18      -2.540  -9.611 -23.244  1.00 33.70           C
ATOM     32  O   GLY    18      -2.092  -9.863 -24.369  1.00 33.70           O
ATOM     33  N   THR    19      -2.168  -8.553 -22.525  1.00 33.69           N
ATOM     34  CA  THR    19      -1.147  -7.605 -22.973  1.00 33.69           C
ATOM     35  CB  THR    19      -1.157  -6.323 -22.113  1.00 33.65           C
ATOM     38  C   THR    19       0.251  -8.233 -22.948  1.00 33.68           C
ATOM     39  O   THR    19       1.166  -7.772 -23.644  1.00 33.76           O
ATOM     40  N   PHE    20       0.396  -9.289 -22.148  1.00 33.56           N
ATOM     41  CA  PHE    20       1.654 -10.016 -22.004  1.00 33.45           C
ATOM     42  CB  PHE    20       1.632 -10.882 -20.734  1.00 33.44           C
ATOM     43  CG  PHE    20       2.713 -11.927 -20.688  1.00 33.35           C
ATOM     44  CD1 PHE    20       4.033 -11.573 -20.422  1.00 33.33           C
ATOM     45  CE1 PHE    20       5.036 -12.540 -20.384  1.00 33.46           C
ATOM     46  CZ  PHE    20       4.721 -13.877 -20.608  1.00 33.34           C
ATOM     47  CE2 PHE    20       3.406 -14.243 -20.872  1.00 33.27           C
ATOM     48  CD2 PHE    20       2.410 -13.268 -20.910  1.00 33.40           C
ATOM     49  C   PHE    20       1.993 -10.864 -23.230  1.00 33.42           C
ATOM     50  O   PHE    20       3.088 -10.742 -23.778  1.00 33.51           O
ATOM     51  N   ALA    21       1.057 -11.718 -23.647  1.00 33.36           N
ATOM     52  CA  ALA    21       1.281 -12.658 -24.756  1.00 33.30           C
ATOM     53  CB  ALA    21       0.125 -13.646 -24.862  1.00 33.26           C
ATOM     54  C   ALA    21       1.532 -11.973 -26.104  1.00 33.23           C
ATOM     55  O   ALA    21       2.216 -12.526 -26.969  1.00 33.17           O
ATOM     56  N   GLU    22       0.977 -10.774 -26.270  1.00 33.16           N
ATOM     57  CA  GLU    22       1.190  -9.975 -27.475  1.00 33.18           C
ATOM     58  CB  GLU    22       0.113  -8.892 -27.604  1.00 33.18           C
ATOM     59  CG  GLU    22      -1.252  -9.411 -28.056  1.00 33.35           C
ATOM     60  CD  GLU    22      -2.260  -8.296 -28.306  1.00 33.36           C
ATOM     61  OE1 GLU    22      -2.712  -8.150 -29.463  1.00 33.59           O
ATOM     62  OE2 GLU    22      -2.598  -7.563 -27.351  1.00 33.58           O
ATOM     63  C   GLU    22       2.576  -9.335 -27.481  1.00 33.09           C
ATOM     64  O   GLU    22       3.156  -9.097 -28.542  1.00 33.03           O
ATOM     65  N   ARG    23       3.098  -9.067 -26.287  1.00 32.99           N
ATOM     66  CA  ARG    23       4.376  -8.383 -26.125  1.00 33.04           C
ATOM     67  CB  ARG    23       4.281  -7.387 -24.962  1.00 33.10           C
ATOM     68  CG  ARG    23       5.382  -6.336 -24.906  1.00 33.00           C
ATOM     69  CD  ARG    23       5.055  -5.270 -23.873  1.00 32.94           C
ATOM     70  NE  ARG    23       6.239  -4.523 -23.466  1.00 32.63           N
ATOM     74  C   ARG    23       5.541  -9.365 -25.920  1.00 33.08           C
ATOM     75  O   ARG    23       6.666  -9.098 -26.350  1.00 33.12           O
ATOM     76  N   TYR    24       5.257 -10.495 -25.271  1.00 33.02           N
ATOM     77  CA  TYR    24       6.263 -11.520 -24.976  1.00 32.96           C
ATOM     78  CB  TYR    24       6.617 -11.515 -23.484  1.00 33.02           C
ATOM     79  CG  TYR    24       7.131 -10.205 -22.920  1.00 33.19           C
ATOM     80  CD1 TYR    24       6.250  -9.210 -22.494  1.00 33.49           C
ATOM     81  CE1 TYR    24       6.720  -8.012 -21.962  1.00 33.55           C
ATOM     82  CZ  TYR    24       8.084  -7.806 -21.839  1.00 33.33           C
ATOM     83  OH  TYR    24       8.547  -6.623 -21.310  1.00 33.21           O
ATOM     84  CE2 TYR    24       8.979  -8.783 -22.242  1.00 33.01           C
ATOM     85  CD2 TYR    24       8.499  -9.977 -22.773  1.00 33.15           C
ATOM     86  C   TYR    24       5.787 -12.928 -25.347  1.00 32.89           C
ATOM     87  O   TYR    24       4.584 -13.191 -25.419  1.00 32.96           O
ATOM     88  N   ASN    25       6.740 -13.829 -25.584  1.00 32.74           N
ATOM     89  CA  ASN    25       6.457 -15.266 -25.640  1.00 32.60           C
ATOM     90  CB  ASN    25       6.155 -15.752 -27.072  1.00 32.60           C
ATOM     91  CG  ASN    25       7.328 -15.573 -28.032  1.00 32.53           C
ATOM     92  OD1 ASN    25       8.144 -14.663 -27.885  1.00 32.44           O
ATOM     93  ND2 ASN    25       7.401 -16.444 -29.034  1.00 32.19           N
ATOM     94  C   ASN    25       7.569 -16.074 -24.969  1.00 32.47           C
ATOM     95  O   ASN    25       8.747 -15.914 -25.294  1.00 32.51           O
ATOM     96  N   ILE    26       7.176 -16.924 -24.022  1.00 32.31           N
ATOM     97  CA  ILE    26       8.111 -17.635 -23.147  1.00 32.15           C
ATOM     98  CB  ILE    26       7.370 -18.566 -22.166  1.00 32.08           C
ATOM    102  C   ILE    26       9.152 -18.450 -23.907  1.00 32.12           C
ATOM    103  O   ILE    26       8.833 -19.129 -24.884  1.00 32.01           O
ATOM    104  N   VAL    27      10.399 -18.359 -23.453  1.00 32.10           N
ATOM    105  CA  VAL    27      11.493 -19.162 -23.999  1.00 32.06           C
ATOM    106  CB  VAL    27      12.862 -18.422 -23.910  1.00 32.04           C
ATOM    107  CG1 VAL    27      14.018 -19.348 -24.270  1.00 31.86           C
ATOM    108  CG2 VAL    27      12.872 -17.198 -24.815  1.00 32.06           C
ATOM    109  C   VAL    27      11.547 -20.508 -23.269  1.00 32.05           C
ATOM    110  O   VAL    27      11.557 -21.565 -23.905  1.00 32.08           O
ATOM    111  N   CYS    28      11.567 -20.453 -21.936  1.00 31.98           N
ATOM    112  CA  CYS    28      11.621 -21.647 -21.087  1.00 31.88           C
ATOM    113  CB  CYS    28      13.032 -22.249 -21.094  1.00 31.93           C
ATOM    114  SG  CYS    28      14.333 -21.125 -20.527  1.00 31.78           S
ATOM    115  C   CYS    28      11.196 -21.336 -19.652  1.00 31.81           C
ATOM    116  O   CYS    28      11.034 -20.171 -19.282  1.00 31.76           O
ATOM    117  N   MET    29      11.012 -22.386 -18.853  1.00 31.72           N
ATOM    118  CA  MET    29      10.733 -22.244 -17.428  1.00 31.66           C
ATOM    119  CB  MET    29       9.953 -23.458 -16.912  1.00 31.61           C
ATOM    120  CG  MET    29       9.391 -23.300 -15.505  1.00 31.65           C
ATOM    123  C   MET    29      12.046 -22.079 -16.662  1.00 31.66           C
ATOM    124  O   MET    29      12.990 -22.847 -16.862  1.00 31.68           O
ATOM    125  N   LEU    30      12.103 -21.070 -15.794  1.00 31.67           N
ATOM    126  CA  LEU    30      13.302 -20.794 -14.997  1.00 31.67           C
ATOM    127  CB  LEU    30      13.486 -19.287 -14.789  1.00 31.69           C
ATOM    128  CG  LEU    30      14.039 -18.481 -15.965  1.00 31.40           C
ATOM    131  C   LEU    30      13.293 -21.512 -13.647  1.00 31.68           C
ATOM    132  O   LEU    30      14.348 -21.751 -13.059  1.00 31.78           O
ATOM    133  N   GLY    31      12.101 -21.852 -13.165  1.00 31.65           N
ATOM    134  CA  GLY    31      11.951 -22.541 -11.888  1.00 31.62           C
ATOM    135  C   GLY    31      10.887 -21.908 -11.014  1.00 31.66           C
ATOM    136  O   GLY    31      10.558 -20.733 -11.177  1.00 31.56           O
ATOM    137  N   LYS    32      10.349 -22.697 -10.086  1.00 31.68           N
ATOM    138  CA  LYS    32       9.332 -22.227  -9.146  1.00 31.65           C
ATOM    139  CB  LYS    32       8.777 -23.386  -8.300  1.00 31.65           C
ATOM    140  CG  LYS    32       8.286 -24.609  -9.080  1.00 31.64           C
ATOM    141  CD  LYS    32       9.358 -25.699  -9.169  1.00 31.72           C
ATOM    144  C   LYS    32       9.911 -21.147  -8.230  1.00 31.63           C
ATOM    145  O   LYS    32      11.032 -21.280  -7.733  1.00 31.65           O
ATOM    146  N   GLY    33       9.148 -20.079  -8.021  1.00 31.58           N
ATOM    147  CA  GLY    33       9.558 -18.994  -7.133  1.00 31.56           C
ATOM    148  C   GLY    33       8.705 -18.914  -5.882  1.00 31.63           C
ATOM    149  O   GLY    33       7.869 -19.784  -5.625  1.00 31.46           O
ATOM    150  N   SER    34       8.919 -17.861  -5.102  1.00 31.85           N
ATOM    151  CA  SER    34       8.162 -17.645  -3.877  1.00 32.12           C
ATOM    152  CB  SER    34       8.864 -16.610  -2.994  1.00 31.98           C
ATOM    154  C   SER    34       6.716 -17.221  -4.159  1.00 32.48           C
ATOM    155  O   SER    34       5.845 -17.400  -3.307  1.00 32.29           O
ATOM    156  N   PHE    35       6.470 -16.679  -5.356  1.00 32.93           N
ATOM    157  CA  PHE    35       5.150 -16.139  -5.737  1.00 33.86           C
ATOM    158  CB  PHE    35       5.267 -14.687  -6.227  1.00 33.87           C
ATOM    159  CG  PHE    35       5.760 -13.721  -5.184  1.00 34.30           C
ATOM    160  CD1 PHE    35       7.121 -13.441  -5.065  1.00 34.45           C
ATOM    161  CE1 PHE    35       7.582 -12.540  -4.109  1.00 35.04           C
ATOM    162  CZ  PHE    35       6.675 -11.906  -3.260  1.00 34.57           C
ATOM    163  CE2 PHE    35       5.312 -12.180  -3.372  1.00 34.57           C
ATOM    164  CD2 PHE    35       4.864 -13.082  -4.331  1.00 34.24           C
ATOM    165  C   PHE    35       4.406 -16.948  -6.806  1.00 34.30           C
ATOM    166  O   PHE    35       3.219 -16.714  -7.050  1.00 34.50           O
ATOM    167  N   GLY    36       5.106 -17.884  -7.441  1.00 34.80           N
ATOM    168  CA  GLY    36       4.539 -18.685  -8.521  1.00 35.28           C
ATOM    169  C   GLY    36       5.635 -19.194  -9.432  1.00 35.72           C
ATOM    170  O   GLY    36       6.785 -19.330  -9.011  1.00 35.60           O
ATOM    171  N   GLU    37       5.282 -19.482 -10.682  1.00 36.11           N
ATOM    172  CA  GLU    37       6.266 -19.901 -11.677  1.00 36.52           C
ATOM    173  CB  GLU    37       5.578 -20.575 -12.868  1.00 36.44           C
ATOM    178  C   GLU    37       7.100 -18.703 -12.142  1.00 36.86           C
ATOM    179  O   GLU    37       6.586 -17.585 -12.256  1.00 36.96           O
ATOM    180  N   VAL    38       8.388 -18.940 -12.381  1.00 37.19           N
ATOM    181  CA  VAL    38       9.284 -17.924 -12.938  1.00 37.62           C
ATOM    182  CB  VAL    38      10.534 -17.684 -12.045  1.00 37.60           C
ATOM    183  CG1 VAL    38      11.388 -16.537 -12.588  1.00 37.37           C
ATOM    184  CG2 VAL    38      10.119 -17.400 -10.604  1.00 37.81           C
ATOM    185  C   VAL    38       9.699 -18.354 -14.348  1.00 37.88           C
ATOM    186  O   VAL    38      10.199 -19.465 -14.547  1.00 37.99           O
ATOM    187  N   LEU    39       9.475 -17.469 -15.317  1.00 38.09           N
ATOM    188  CA  LEU    39       9.718 -17.765 -16.727  1.00 38.31           C
ATOM    189  CB  LEU    39       8.418 -17.608 -17.529  1.00 38.29           C
ATOM    190  CG  LEU    39       7.505 -18.808 -17.816  1.00 38.75           C
ATOM    191  CD1 LEU    39       7.194 -19.645 -16.576  1.00 39.53           C
ATOM    192  CD2 LEU    39       6.214 -18.329 -18.465  1.00 38.53           C
ATOM    193  C   LEU    39      10.808 -16.885 -17.336  1.00 38.40           C
ATOM    194  O   LEU    39      11.014 -15.746 -16.913  1.00 38.27           O
ATOM    195  N   LYS    40      11.507 -17.436 -18.325  1.00 38.73           N
ATOM    196  CA  LYS    40      12.422 -16.665 -19.160  1.00 39.05           C
ATOM    197  CB  LYS    40      13.677 -17.481 -19.492  1.00 38.96           C
ATOM    198  CG  LYS    40      14.738 -16.746 -20.303  1.00 38.79           C
ATOM    199  CD  LYS    40      15.905 -17.672 -20.605  1.00 39.03           C
ATOM    200  CE  LYS    40      16.760 -17.156 -21.748  1.00 39.13           C
ATOM    201  NZ  LYS    40      17.728 -18.186 -22.230  1.00 38.99           N
ATOM    202  C   LYS    40      11.667 -16.283 -20.426  1.00 39.30           C
ATOM    203  O   LYS    40      11.205 -17.152 -21.173  1.00 39.31           O
ATOM    204  N   CYS    41      11.532 -14.979 -20.649  1.00 39.62           N
ATOM    205  CA  CYS    41      10.764 -14.465 -21.776  1.00 40.02           C
ATOM    206  CB  CYS    41       9.539 -13.712 -21.273  1.00 40.01           C
ATOM    207  SG  CYS    41       8.408 -14.756 -20.360  1.00 41.20           S
ATOM    208  C   CYS    41      11.581 -13.557 -22.675  1.00 40.08           C
ATOM    209  O   CYS    41      12.505 -12.883 -22.219  1.00 40.12           O
ATOM    210  N   LYS    42      11.228 -13.555 -23.958  1.00 40.18           N
ATOM    211  CA  LYS    42      11.782 -12.609 -24.916  1.00 40.28           C
ATOM    212  CB  LYS    42      12.303 -13.335 -26.160  1.00 40.21           C
ATOM    217  C   LYS    42      10.720 -11.586 -25.308  1.00 40.36           C
ATOM    218  O   LYS    42       9.545 -11.927 -25.476  1.00 40.30           O
ATOM    219  N   ASP    43      11.141 -10.330 -25.426  1.00 40.47           N
ATOM    220  CA  ASP    43      10.310  -9.275 -25.992  1.00 40.55           C
ATOM    221  CB  ASP    43      10.985  -7.915 -25.787  1.00 40.54           C
ATOM    222  CG  ASP    43      10.085  -6.744 -26.150  1.00 40.65           C
ATOM    223  OD1 ASP    43       9.804  -6.549 -27.351  1.00 40.58           O
ATOM    224  OD2 ASP    43       9.676  -6.002 -25.231  1.00 40.79           O
ATOM    225  C   ASP    43      10.136  -9.575 -27.478  1.00 40.62           C
ATOM    226  O   ASP    43      11.098  -9.931 -28.155  1.00 40.63           O
ATOM    227  N   ARG    44       8.908  -9.452 -27.975  1.00 40.78           N
ATOM    228  CA  ARG    44       8.609  -9.779 -29.375  1.00 40.93           C
ATOM    229  CB  ARG    44       7.104  -9.987 -29.586  1.00 41.02           C
ATOM    230  CG  ARG    44       6.580 -11.331 -29.090  1.00 41.16           C
ATOM    231  CD  ARG    44       5.168 -11.595 -29.591  1.00 41.15           C
ATOM    232  NE  ARG    44       4.695 -12.922 -29.210  1.00 41.27           N
ATOM    236  C   ARG    44       9.149  -8.743 -30.362  1.00 40.95           C
ATOM    237  O   ARG    44       9.359  -9.048 -31.537  1.00 40.92           O
ATOM    238  N   ILE    45       9.380  -7.525 -29.878  1.00 41.02           N
ATOM    239  CA  ILE    45       9.873  -6.437 -30.724  1.00 41.06           C
ATOM    240  CB  ILE    45       9.088  -5.115 -30.482  1.00 41.08           C
ATOM    241  CG1 ILE    45       7.579  -5.387 -30.424  1.00 41.08           C
ATOM    242  CD1 ILE    45       6.812  -4.480 -29.473  1.00 41.08           C
ATOM    243  CG2 ILE    45       9.405  -4.089 -31.570  1.00 40.95           C
ATOM    244  C   ILE    45      11.386  -6.233 -30.546  1.00 41.08           C
ATOM    245  O   ILE    45      12.148  -6.419 -31.498  1.00 41.08           O
ATOM    246  N   THR    46      11.814  -5.875 -29.333  1.00 41.06           N
ATOM    247  CA  THR    46      13.230  -5.573 -29.060  1.00 41.04           C
ATOM    248  CB  THR    46      13.423  -4.719 -27.773  1.00 41.02           C
ATOM    249  OG1 THR    46      13.138  -5.507 -26.611  1.00 41.15           O
ATOM    250  CG2 THR    46      12.524  -3.483 -27.787  1.00 41.03           C
ATOM    251  C   THR    46      14.120  -6.822 -28.990  1.00 41.04           C
ATOM    252  O   THR    46      15.328  -6.739 -29.231  1.00 40.98           O
ATOM    253  N   GLN    47      13.514  -7.963 -28.656  1.00 41.04           N
ATOM    254  CA  GLN    47      14.194  -9.276 -28.588  1.00 41.02           C
ATOM    255  CB  GLN    47      14.920  -9.618 -29.906  1.00 41.04           C
ATOM    256  CG  GLN    47      13.994  -9.871 -31.104  1.00 41.19           C
ATOM    257  CD  GLN    47      13.309 -11.239 -31.083  1.00 41.43           C
ATOM    258  OE1 GLN    47      13.259 -11.921 -30.056  1.00 41.69           O
ATOM    259  NE2 GLN    47      12.772 -11.638 -32.229  1.00 41.42           N
ATOM    260  C   GLN    47      15.119  -9.472 -27.377  1.00 40.96           C
ATOM    261  O   GLN    47      15.850 -10.465 -27.303  1.00 40.99           O
ATOM    262  N   GLN    48      15.073  -8.532 -26.434  1.00 40.81           N
ATOM    263  CA  GLN    48      15.812  -8.640 -25.178  1.00 40.76           C
ATOM    264  CB  GLN    48      15.884  -7.274 -24.494  1.00 40.79           C
ATOM    265  CG  GLN    48      16.842  -7.202 -23.310  1.00 41.21           C
ATOM    266  CD  GLN    48      16.893  -5.819 -22.683  1.00 41.33           C
ATOM    267  OE1 GLN    48      16.538  -5.638 -21.512  1.00 41.70           O
ATOM    268  NE2 GLN    48      17.331  -4.831 -23.462  1.00 41.78           N
ATOM    269  C   GLN    48      15.129  -9.658 -24.267  1.00 40.44           C
ATOM    270  O   GLN    48      13.915  -9.854 -24.352  1.00 40.41           O
ATOM    271  N   GLU    49      15.905 -10.299 -23.398  1.00 40.13           N
ATOM    272  CA  GLU    49      15.373 -11.351 -22.530  1.00 39.94           C
ATOM    273  CB  GLU    49      16.266 -12.593 -22.585  1.00 39.95           C
ATOM    274  CG  GLU    49      16.288 -13.260 -23.954  1.00 40.05           C
ATOM    275  CD  GLU    49      17.167 -14.493 -24.006  1.00 40.21           C
ATOM    276  OE1 GLU    49      18.249 -14.495 -23.375  1.00 40.42           O
ATOM    277  OE2 GLU    49      16.775 -15.464 -24.691  1.00 40.63           O
ATOM    278  C   GLU    49      15.154 -10.899 -21.086  1.00 39.66           C
ATOM    279  O   GLU    49      15.946 -10.133 -20.539  1.00 39.82           O
ATOM    280  N   TYR    50      14.068 -11.376 -20.480  1.00 39.28           N
ATOM    281  CA  TYR    50      13.676 -10.962 -19.134  1.00 38.91           C
ATOM    282  CB  TYR    50      12.545  -9.933 -19.198  1.00 38.78           C
ATOM    283  CG  TYR    50      12.919  -8.615 -19.836  1.00 38.67           C
ATOM    284  CD1 TYR    50      13.337  -7.536 -19.057  1.00 38.48           C
ATOM    285  CE1 TYR    50      13.676  -6.320 -19.639  1.00 38.27           C
ATOM    286  CZ  TYR    50      13.594  -6.176 -21.014  1.00 38.51           C
ATOM    287  OH  TYR    50      13.931  -4.976 -21.597  1.00 38.64           O
ATOM    288  CE2 TYR    50      13.182  -7.232 -21.810  1.00 38.43           C
ATOM    289  CD2 TYR    50      12.842  -8.440 -21.219  1.00 38.41           C
ATOM    290  C   TYR    50      13.212 -12.142 -18.294  1.00 38.79           C
ATOM    291  O   TYR    50      12.768 -13.161 -18.832  1.00 38.84           O
ATOM    292  N   ALA    51      13.308 -11.989 -16.973  1.00 38.50           N
ATOM    293  CA  ALA    51      12.797 -12.980 -16.030  1.00 38.21           C
ATOM    294  CB  ALA    51      13.767 -13.172 -14.870  1.00 38.24           C
ATOM    295  C   ALA    51      11.430 -12.536 -15.525  1.00 37.99           C
ATOM    296  O   ALA    51      11.321 -11.557 -14.780  1.00 37.84           O
ATOM    297  N   VAL    52      10.393 -13.265 -15.933  1.00 37.78           N
ATOM    298  CA  VAL    52       9.008 -12.878 -15.656  1.00 37.65           C
ATOM    299  CB  VAL    52       8.153 -12.837 -16.953  1.00 37.62           C
ATOM    300  CG1 VAL    52       6.704 -12.486 -16.643  1.00 37.42           C
ATOM    301  CG2 VAL    52       8.740 -11.840 -17.951  1.00 37.61           C
ATOM    302  C   VAL    52       8.345 -13.775 -14.610  1.00 37.66           C
ATOM    303  O   VAL    52       8.280 -14.997 -14.769  1.00 37.69           O
ATOM    304  N   LYS    53       7.850 -13.156 -13.544  1.00 37.57           N
ATOM    305  CA  LYS    53       7.143 -13.885 -12.497  1.00 37.65           C
ATOM    306  CB  LYS    53       7.471 -13.306 -11.114  1.00 37.58           C
ATOM    307  CG  LYS    53       8.936 -12.937 -10.964  1.00 38.35           C
ATOM    308  CD  LYS    53       9.522 -13.368  -9.627  1.00 39.55           C
ATOM    309  CE  LYS    53      11.055 -13.503  -9.698  1.00 39.64           C
ATOM    310  NZ  LYS    53      11.747 -12.210 -10.027  1.00 39.13           N
ATOM    311  C   LYS    53       5.635 -13.895 -12.765  1.00 37.50           C
ATOM    312  O   LYS    53       4.989 -12.843 -12.788  1.00 37.40           O
ATOM    313  N   VAL    54       5.097 -15.089 -13.000  1.00 37.37           N
ATOM    314  CA  VAL    54       3.662 -15.278 -13.190  1.00 37.46           C
ATOM    315  CB  VAL    54       3.340 -16.522 -14.063  1.00 37.46           C
ATOM    316  CG1 VAL    54       1.852 -16.582 -14.381  1.00 36.89           C
ATOM    317  CG2 VAL    54       4.167 -16.525 -15.349  1.00 37.23           C
ATOM    318  C   VAL    54       3.010 -15.434 -11.818  1.00 37.57           C
ATOM    319  O   VAL    54       3.315 -16.368 -11.079  1.00 37.64           O
ATOM    320  N   ILE    55       2.127 -14.502 -11.475  1.00 37.86           N
ATOM    321  CA  ILE    55       1.481 -14.511 -10.167  1.00 37.94           C
ATOM    322  CB  ILE    55       1.872 -13.277  -9.317  1.00 37.75           C
ATOM    323  CG1 ILE    55       3.395 -13.167  -9.206  1.00 37.62           C
ATOM    324  CD1 ILE    55       3.882 -11.925  -8.498  1.00 37.90           C
ATOM    325  CG2 ILE    55       1.243 -13.365  -7.925  1.00 37.98           C
ATOM    326  C   ILE    55      -0.030 -14.578 -10.324  1.00 38.02           C
ATOM    327  O   ILE    55      -0.636 -13.672 -10.893  1.00 38.10           O
ATOM    328  N   ASN    56      -0.629 -15.651  -9.817  1.00 38.25           N
ATOM    329  CA  ASN    56      -2.080 -15.818  -9.857  1.00 38.55           C
ATOM    330  CB  ASN    56      -2.486 -17.127  -9.176  1.00 38.64           C
ATOM    331  CG  ASN    56      -3.935 -17.500  -9.446  1.00 39.08           C
ATOM    332  OD1 ASN    56      -4.856 -16.754  -9.108  1.00 39.45           O
ATOM    333  ND2 ASN    56      -4.141 -18.662 -10.054  1.00 39.06           N
ATOM    334  C   ASN    56      -2.807 -14.635  -9.215  1.00 38.61           C
ATOM    335  O   ASN    56      -2.439 -14.191  -8.123  1.00 38.52           O
ATOM    336  N   LYS    57      -3.838 -14.132  -9.891  1.00 38.62           N
ATOM    337  CA  LYS    57      -4.561 -12.951  -9.412  1.00 38.82           C
ATOM    338  CB  LYS    57      -5.561 -12.448 -10.456  1.00 38.84           C
ATOM    339  CG  LYS    57      -4.889 -11.660 -11.555  1.00 39.27           C
ATOM    340  CD  LYS    57      -5.869 -10.963 -12.476  1.00 39.70           C
ATOM    341  CE  LYS    57      -5.113 -10.034 -13.418  1.00 39.31           C
ATOM    342  NZ  LYS    57      -5.991  -9.498 -14.478  1.00 39.20           N
ATOM    343  C   LYS    57      -5.229 -13.132  -8.047  1.00 38.81           C
ATOM    344  O   LYS    57      -5.472 -12.151  -7.342  1.00 39.09           O
ATOM    345  N   ALA    58      -5.504 -14.381  -7.676  1.00 38.64           N
ATOM    346  CA  ALA    58      -6.040 -14.707  -6.355  1.00 38.54           C
ATOM    347  CB  ALA    58      -6.532 -16.154  -6.317  1.00 38.51           C
ATOM    348  C   ALA    58      -5.019 -14.459  -5.241  1.00 38.43           C
ATOM    349  O   ALA    58      -5.386 -14.370  -4.069  1.00 38.56           O
ATOM    350  N   SER    59      -3.744 -14.352  -5.612  1.00 38.27           N
ATOM    351  CA  SER    59      -2.676 -14.076  -4.652  1.00 38.08           C
ATOM    352  CB  SER    59      -1.345 -14.668  -5.136  1.00 38.04           C
ATOM    354  C   SER    59      -2.534 -12.578  -4.340  1.00 37.98           C
ATOM    355  O   SER    59      -1.745 -12.191  -3.474  1.00 38.03           O
ATOM    356  N   ALA    60      -3.306 -11.746  -5.038  1.00 37.84           N
ATOM    357  CA  ALA    60      -3.345 -10.309  -4.775  1.00 37.84           C
ATOM    358  CB  ALA    60      -4.227  -9.600  -5.795  1.00 37.85           C
ATOM    359  C   ALA    60      -3.841 -10.034  -3.363  1.00 37.80           C
ATOM    360  O   ALA    60      -4.845 -10.606  -2.935  1.00 37.90           O
ATOM    361  N   LYS    61      -3.125  -9.168  -2.646  1.00 37.79           N
ATOM    362  CA  LYS    61      -3.439  -8.847  -1.249  1.00 37.72           C
ATOM    363  CB  LYS    61      -2.178  -8.421  -0.497  1.00 37.70           C
ATOM    364  CG  LYS    61      -1.275  -9.556  -0.058  1.00 37.20           C
ATOM    365  CD  LYS    61      -0.420  -9.092   1.100  1.00 36.43           C
ATOM    366  CE  LYS    61       0.442 -10.185   1.647  1.00 35.78           C
ATOM    367  NZ  LYS    61       1.341  -9.607   2.675  1.00 36.82           N
ATOM    368  C   LYS    61      -4.470  -7.733  -1.155  1.00 37.93           C
ATOM    369  O   LYS    61      -5.130  -7.561  -0.122  1.00 38.09           O
ATOM    370  N   ASN    62      -4.588  -6.969  -2.236  1.00 37.86           N
ATOM    371  CA  ASN    62      -5.523  -5.864  -2.307  1.00 37.94           C
ATOM    372  CB  ASN    62      -4.767  -4.546  -2.498  1.00 37.95           C
ATOM    373  CG  ASN    62      -5.626  -3.330  -2.197  1.00 37.82           C
ATOM    374  OD1 ASN    62      -6.673  -3.125  -2.809  1.00 36.82           O
ATOM    375  ND2 ASN    62      -5.181  -2.517  -1.248  1.00 37.70           N
ATOM    376  C   ASN    62      -6.540  -6.082  -3.426  1.00 38.02           C
ATOM    377  O   ASN    62      -6.171  -6.317  -4.577  1.00 37.99           O
ATOM    378  N   LYS    63      -7.820  -6.016  -3.070  1.00 38.23           N
ATOM    379  CA  LYS    63      -8.916  -6.233  -4.020  1.00 38.24           C
ATOM    380  CB  LYS    63     -10.257  -6.378  -3.283  1.00 38.57           C
ATOM    381  CG  LYS    63     -10.430  -5.483  -2.045  1.00 38.80           C
ATOM    382  CD  LYS    63     -11.611  -5.947  -1.184  1.00 38.51           C
ATOM    385  C   LYS    63      -8.981  -5.144  -5.094  1.00 37.93           C
ATOM    386  O   LYS    63      -9.442  -5.387  -6.210  1.00 37.85           O
ATOM    387  N   ASP    64      -8.498  -3.954  -4.743  1.00 37.52           N
ATOM    388  CA  ASP    64      -8.361  -2.841  -5.674  1.00 37.09           C
ATOM    389  CB  ASP    64      -8.380  -1.517  -4.901  1.00 37.06           C
ATOM    390  CG  ASP    64      -8.392  -0.297  -5.805  1.00 37.29           C
ATOM    391  OD1 ASP    64      -8.374   0.821  -5.251  1.00 36.69           O
ATOM    392  OD2 ASP    64      -8.430  -0.442  -7.051  1.00 37.41           O
ATOM    393  C   ASP    64      -7.051  -2.979  -6.441  1.00 36.70           C
ATOM    394  O   ASP    64      -5.991  -2.597  -5.947  1.00 36.76           O
ATOM    395  N   THR    65      -7.134  -3.527  -7.649  1.00 36.42           N
ATOM    396  CA  THR    65      -5.967  -3.731  -8.505  1.00 36.06           C
ATOM    397  CB  THR    65      -6.367  -4.398  -9.847  1.00 35.97           C
ATOM    398  OG1 THR    65      -6.942  -5.686  -9.583  1.00 35.57           O
ATOM    399  CG2 THR    65      -5.163  -4.580 -10.766  1.00 35.27           C
ATOM    400  C   THR    65      -5.166  -2.443  -8.745  1.00 36.34           C
ATOM    401  O   THR    65      -3.932  -2.484  -8.795  1.00 36.51           O
ATOM    402  N   SER    66      -5.856  -1.308  -8.872  1.00 36.27           N
ATOM    403  CA  SER    66      -5.191  -0.046  -9.211  1.00 36.36           C
ATOM    404  CB  SER    66      -6.206   1.080  -9.445  1.00 36.32           C
ATOM    405  OG  SER    66      -6.913   1.399  -8.261  1.00 36.54           O
ATOM    406  C   SER    66      -4.173   0.350  -8.149  1.00 36.54           C
ATOM    407  O   SER    66      -3.121   0.919  -8.466  1.00 36.62           O
ATOM    408  N   THR    67      -4.490   0.037  -6.895  1.00 36.48           N
ATOM    409  CA  THR    67      -3.576   0.268  -5.781  1.00 36.72           C
ATOM    410  CB  THR    67      -4.248  -0.060  -4.421  1.00 36.71           C
ATOM    411  OG1 THR    67      -5.224   0.952  -4.122  1.00 36.83           O
ATOM    412  CG2 THR    67      -3.231  -0.098  -3.306  1.00 36.48           C
ATOM    413  C   THR    67      -2.270  -0.507  -5.969  1.00 36.82           C
ATOM    414  O   THR    67      -1.187   0.044  -5.778  1.00 37.27           O
ATOM    415  N   ILE    68      -2.383  -1.774  -6.360  1.00 36.97           N
ATOM    416  CA  ILE    68      -1.229  -2.616  -6.676  1.00 36.85           C
ATOM    417  CB  ILE    68      -1.653  -4.095  -6.895  1.00 36.92           C
ATOM    418  CG1 ILE    68      -1.912  -4.776  -5.538  1.00 36.87           C
ATOM    419  CD1 ILE    68      -2.726  -6.053  -5.614  1.00 35.79           C
ATOM    420  CG2 ILE    68      -0.590  -4.862  -7.689  1.00 37.05           C
ATOM    421  C   ILE    68      -0.428  -2.082  -7.874  1.00 37.11           C
ATOM    422  O   ILE    68       0.805  -2.042  -7.826  1.00 37.30           O
ATOM    423  N   LEU    69      -1.118  -1.662  -8.934  1.00 36.90           N
ATOM    424  CA  LEU    69      -0.435  -1.119 -10.109  1.00 37.22           C
ATOM    425  CB  LEU    69      -1.420  -0.869 -11.261  1.00 37.15           C
ATOM    426  CG  LEU    69      -2.185  -2.098 -11.784  1.00 37.19           C
ATOM    427  CD1 LEU    69      -3.063  -1.726 -12.969  1.00 37.38           C
ATOM    428  CD2 LEU    69      -1.245  -3.258 -12.152  1.00 35.51           C
ATOM    429  C   LEU    69       0.357   0.149  -9.777  1.00 37.56           C
ATOM    430  O   LEU    69       1.370   0.447 -10.421  1.00 37.40           O
ATOM    431  N   ARG    70      -0.113   0.872  -8.757  1.00 37.85           N
ATOM    432  CA  ARG    70       0.520   2.089  -8.263  1.00 37.92           C
ATOM    433  CB  ARG    70      -0.488   2.913  -7.452  1.00 37.89           C
ATOM    434  CG  ARG    70       0.106   3.921  -6.466  1.00 36.81           C
ATOM    435  CD  ARG    70       0.614   5.170  -7.156  1.00 35.82           C
ATOM    436  NE  ARG    70       1.164   6.123  -6.199  1.00 34.69           N
ATOM    437  CZ  ARG    70       1.794   7.248  -6.525  1.00 35.53           C
ATOM    438  NH1 ARG    70       1.962   7.582  -7.802  1.00 35.22           N
ATOM    439  NH2 ARG    70       2.253   8.048  -5.567  1.00 35.81           N
ATOM    440  C   ARG    70       1.777   1.796  -7.439  1.00 38.65           C
ATOM    441  O   ARG    70       2.796   2.481  -7.609  1.00 38.94           O
ATOM    442  N   GLU    71       1.703   0.806  -6.540  1.00 38.76           N
ATOM    443  CA  GLU    71       2.885   0.351  -5.803  1.00 39.10           C
ATOM    444  CB  GLU    71       2.573  -0.852  -4.902  1.00 39.27           C
ATOM    445  CG  GLU    71       2.316  -0.544  -3.428  1.00 40.39           C
ATOM    446  CD  GLU    71       3.468   0.174  -2.736  1.00 40.72           C
ATOM    447  OE1 GLU    71       3.471   1.423  -2.747  1.00 41.51           O
ATOM    448  OE2 GLU    71       4.343  -0.499  -2.148  1.00 40.19           O
ATOM    449  C   GLU    71       3.988  -0.047  -6.773  1.00 39.04           C
ATOM    450  O   GLU    71       5.130   0.410  -6.644  1.00 39.31           O
ATOM    451  N   VAL    72       3.639  -0.904  -7.737  1.00 38.61           N
ATOM    452  CA  VAL    72       4.598  -1.405  -8.720  1.00 38.10           C
ATOM    453  CB  VAL    72       3.986  -2.482  -9.654  1.00 37.97           C
ATOM    454  CG1 VAL    72       4.999  -2.931 -10.691  1.00 37.90           C
ATOM    455  CG2 VAL    72       3.500  -3.679  -8.854  1.00 37.92           C
ATOM    456  C   VAL    72       5.170  -0.239  -9.526  1.00 37.83           C
ATOM    457  O   VAL    72       6.377  -0.172  -9.751  1.00 37.66           O
ATOM    458  N   GLU    73       4.306   0.688  -9.932  1.00 37.66           N
ATOM    459  CA  GLU    73       4.748   1.869 -10.679  1.00 37.61           C
ATOM    460  CB  GLU    73       3.568   2.790 -10.999  1.00 37.43           C
ATOM    461  CG  GLU    73       3.848   3.817 -12.103  1.00 38.45           C
ATOM    462  CD  GLU    73       4.145   3.189 -13.465  1.00 38.72           C
ATOM    463  OE1 GLU    73       3.715   2.039 -13.714  1.00 38.11           O
ATOM    464  OE2 GLU    73       4.802   3.859 -14.293  1.00 39.33           O
ATOM    465  C   GLU    73       5.851   2.623  -9.929  1.00 37.42           C
ATOM    466  O   GLU    73       6.877   2.966 -10.514  1.00 37.30           O
ATOM    467  N   LEU    74       5.642   2.849  -8.632  1.00 37.37           N
ATOM    468  CA  LEU    74       6.653   3.455  -7.769  1.00 37.33           C
ATOM    469  CB  LEU    74       6.117   3.628  -6.343  1.00 37.39           C
ATOM    470  CG  LEU    74       5.054   4.694  -6.047  1.00 37.62           C
ATOM    471  CD1 LEU    74       4.347   4.392  -4.722  1.00 37.71           C
ATOM    472  CD2 LEU    74       5.658   6.100  -6.024  1.00 37.43           C
ATOM    473  C   LEU    74       7.962   2.649  -7.753  1.00 37.23           C
ATOM    474  O   LEU    74       9.045   3.229  -7.769  1.00 37.03           O
ATOM    475  N   LEU    75       7.849   1.321  -7.735  1.00 37.11           N
ATOM    476  CA  LEU    75       9.016   0.426  -7.776  1.00 37.23           C
ATOM    477  CB  LEU    75       8.610  -1.017  -7.452  1.00 37.16           C
ATOM    478  CG  LEU    75       8.007  -1.295  -6.070  1.00 36.80           C
ATOM    479  CD1 LEU    75       7.466  -2.716  -5.993  1.00 36.87           C
ATOM    480  CD2 LEU    75       9.011  -1.031  -4.947  1.00 35.24           C
ATOM    481  C   LEU    75       9.752   0.466  -9.117  1.00 37.44           C
ATOM    482  O   LEU    75      10.974   0.306  -9.163  1.00 37.61           O
ATOM    483  N   LYS    76       9.011   0.690 -10.201  1.00 37.58           N
ATOM    484  CA  LYS    76       9.607   0.771 -11.535  1.00 37.67           C
ATOM    485  CB  LYS    76       8.533   0.776 -12.625  1.00 37.54           C
ATOM    486  CG  LYS    76       7.541  -0.392 -12.549  1.00 37.63           C
ATOM    487  CD  LYS    76       6.830  -0.665 -13.870  1.00 37.67           C
ATOM    488  CE  LYS    76       6.530   0.608 -14.644  1.00 38.19           C
ATOM    489  NZ  LYS    76       5.612   0.367 -15.791  1.00 39.15           N
ATOM    490  C   LYS    76      10.503   1.998 -11.672  1.00 37.79           C
ATOM    491  O   LYS    76      11.485   1.974 -12.411  1.00 37.92           O
ATOM    492  N   LYS    77      10.163   3.058 -10.945  1.00 37.88           N
ATOM    493  CA  LYS    77      10.892   4.318 -11.004  1.00 38.08           C
ATOM    494  CB  LYS    77      10.006   5.466 -10.499  1.00 38.19           C
ATOM    495  CG  LYS    77       9.133   6.128 -11.578  1.00 38.52           C
ATOM    496  CD  LYS    77       7.987   5.231 -12.044  1.00 39.40           C
ATOM    497  CE  LYS    77       7.449   5.636 -13.411  1.00 40.16           C
ATOM    498  NZ  LYS    77       6.783   6.975 -13.411  1.00 39.99           N
ATOM    499  C   LYS    77      12.208   4.256 -10.227  1.00 38.20           C
ATOM    500  O   LYS    77      13.122   5.032 -10.484  1.00 38.22           O
ATOM    501  N   LEU    78      12.298   3.315  -9.292  1.00 38.52           N
ATOM    502  CA  LEU    78      13.487   3.134  -8.455  1.00 38.59           C
ATOM    503  CB  LEU    78      13.139   2.348  -7.185  1.00 38.40           C
ATOM    504  CG  LEU    78      12.214   3.078  -6.209  1.00 38.35           C
ATOM    505  CD1 LEU    78      11.886   2.208  -5.017  1.00 38.70           C
ATOM    506  CD2 LEU    78      12.820   4.401  -5.760  1.00 38.40           C
ATOM    507  C   LEU    78      14.642   2.461  -9.185  1.00 38.70           C
ATOM    508  O   LEU    78      14.434   1.684 -10.123  1.00 38.81           O
ATOM    509  N   ASP    79      15.858   2.758  -8.732  1.00 38.79           N
ATOM    510  CA  ASP    79      17.066   2.291  -9.396  1.00 39.09           C
ATOM    511  CB  ASP    79      17.365   3.174 -10.616  1.00 39.43           C
ATOM    512  CG  ASP    79      17.778   2.366 -11.830  1.00 40.90           C
ATOM    513  OD1 ASP    79      18.091   1.163 -11.675  1.00 42.91           O
ATOM    514  OD2 ASP    79      17.784   2.933 -12.945  1.00 42.47           O
ATOM    515  C   ASP    79      18.270   2.275  -8.451  1.00 38.81           C
ATOM    516  O   ASP    79      18.722   3.326  -7.980  1.00 38.89           O
ATOM    517  N   HIS    80      18.785   1.077  -8.180  1.00 38.36           N
ATOM    518  CA  HIS    80      19.958   0.914  -7.321  1.00 37.81           C
ATOM    519  CB  HIS    80      19.540   0.849  -5.853  1.00 37.64           C
ATOM    520  CG  HIS    80      20.692   0.837  -4.904  1.00 37.22           C
ATOM    521  ND1 HIS    80      21.260  -0.330  -4.439  1.00 36.55           N
ATOM    522  CE1 HIS    80      22.262  -0.035  -3.629  1.00 36.58           C
ATOM    523  NE2 HIS    80      22.364   1.279  -3.553  1.00 36.64           N
ATOM    524  CD2 HIS    80      21.399   1.849  -4.348  1.00 36.63           C
ATOM    525  C   HIS    80      20.749  -0.339  -7.698  1.00 37.62           C
ATOM    526  O   HIS    80      20.160  -1.408  -7.855  1.00 37.72           O
ATOM    527  N   PRO    81      22.088  -0.213  -7.833  1.00 37.35           N
ATOM    528  CA  PRO    81      22.955  -1.324  -8.257  1.00 37.10           C
ATOM    529  CB  PRO    81      24.361  -0.823  -7.903  1.00 37.12           C
ATOM    530  CG  PRO    81      24.267   0.650  -7.992  1.00 37.10           C
ATOM    531  CD  PRO    81      22.863   1.021  -7.590  1.00 37.36           C
ATOM    532  C   PRO    81      22.681  -2.671  -7.565  1.00 36.87           C
ATOM    533  O   PRO    81      22.861  -3.722  -8.182  1.00 36.75           O
ATOM    534  N   ASN    82      22.244  -2.628  -6.306  1.00 36.60           N
ATOM    535  CA  ASN    82      22.006  -3.832  -5.506  1.00 36.39           C
ATOM    536  CB  ASN    82      22.615  -3.667  -4.108  1.00 36.25           C
ATOM    537  CG  ASN    82      24.104  -3.365  -4.143  1.00 36.00           C
ATOM    538  OD1 ASN    82      24.559  -2.388  -3.550  1.00 35.86           O
ATOM    539  ND2 ASN    82      24.869  -4.204  -4.834  1.00 35.32           N
ATOM    540  C   ASN    82      20.521  -4.221  -5.394  1.00 36.48           C
ATOM    541  O   ASN    82      20.139  -5.042  -4.552  1.00 36.11           O
ATOM    542  N   ILE    83      19.694  -3.626  -6.248  1.00 36.60           N
ATOM    543  CA  ILE    83      18.269  -3.924  -6.278  1.00 36.73           C
ATOM    544  CB  ILE    83      17.409  -2.698  -5.852  1.00 36.61           C
ATOM    545  CG1 ILE    83      17.736  -2.262  -4.413  1.00 36.44           C
ATOM    546  CD1 ILE    83      17.455  -3.312  -3.334  1.00 36.21           C
ATOM    547  CG2 ILE    83      15.902  -2.992  -6.021  1.00 36.54           C
ATOM    548  C   ILE    83      17.854  -4.405  -7.665  1.00 36.96           C
ATOM    549  O   ILE    83      18.030  -3.693  -8.659  1.00 36.76           O
ATOM    550  N   MET    84      17.303  -5.618  -7.719  1.00 37.34           N
ATOM    551  CA  MET    84      16.803  -6.182  -8.968  1.00 37.66           C
ATOM    552  CB  MET    84      16.173  -7.553  -8.732  1.00 37.89           C
ATOM    553  CG  MET    84      16.402  -8.549  -9.868  1.00 38.38           C
ATOM    554  SD  MET    84      18.149  -8.954 -10.150  1.00 39.13           S
ATOM    555  CE  MET    84      17.998 -10.661 -10.650  1.00 38.84           C
ATOM    556  C   MET    84      15.787  -5.232  -9.581  1.00 37.67           C
ATOM    557  O   MET    84      14.897  -4.727  -8.891  1.00 37.66           O
ATOM    558  N   LYS    85      15.950  -4.967 -10.872  1.00 37.62           N
ATOM    559  CA  LYS    85      15.128  -3.993 -11.570  1.00 37.56           C
ATOM    560  CB  LYS    85      15.851  -3.489 -12.823  1.00 37.73           C
ATOM    561  CG  LYS    85      15.208  -2.290 -13.498  1.00 38.32           C
ATOM    562  CD  LYS    85      15.765  -0.977 -12.967  1.00 39.30           C
ATOM    563  CE  LYS    85      15.280   0.200 -13.809  1.00 38.77           C
ATOM    564  NZ  LYS    85      13.821   0.438 -13.621  1.00 38.51           N
ATOM    565  C   LYS    85      13.792  -4.606 -11.943  1.00 37.35           C
ATOM    566  O   LYS    85      13.729  -5.711 -12.475  1.00 37.17           O
ATOM    567  N   LEU    86      12.725  -3.880 -11.637  1.00 37.39           N
ATOM    568  CA  LEU    86      11.387  -4.271 -12.032  1.00 37.27           C
ATOM    569  CB  LEU    86      10.442  -4.181 -10.824  1.00 37.26           C
ATOM    570  CG  LEU    86       8.902  -4.240 -10.821  1.00 37.70           C
ATOM    571  CD1 LEU    86       8.230  -4.646 -12.140  1.00 37.81           C
ATOM    572  CD2 LEU    86       8.456  -5.145  -9.681  1.00 38.16           C
ATOM    573  C   LEU    86      10.984  -3.375 -13.202  1.00 37.06           C
ATOM    574  O   LEU    86      10.870  -2.159 -13.057  1.00 36.96           O
ATOM    575  N   PHE    87      10.802  -3.992 -14.369  1.00 37.03           N
ATOM    576  CA  PHE    87      10.583  -3.257 -15.619  1.00 37.03           C
ATOM    577  CB  PHE    87      11.182  -4.008 -16.816  1.00 36.86           C
ATOM    578  CG  PHE    87      12.684  -4.027 -16.829  1.00 36.68           C
ATOM    579  CD1 PHE    87      13.382  -5.139 -16.369  1.00 36.65           C
ATOM    580  CE1 PHE    87      14.776  -5.164 -16.378  1.00 36.33           C
ATOM    581  CZ  PHE    87      15.485  -4.065 -16.842  1.00 36.49           C
ATOM    582  CE2 PHE    87      14.798  -2.944 -17.299  1.00 36.73           C
ATOM    583  CD2 PHE    87      13.403  -2.931 -17.291  1.00 36.52           C
ATOM    584  C   PHE    87       9.120  -2.901 -15.874  1.00 37.09           C
ATOM    585  O   PHE    87       8.805  -1.739 -16.126  1.00 37.14           O
ATOM    586  N   GLU    88       8.237  -3.898 -15.823  1.00 37.20           N
ATOM    587  CA  GLU    88       6.796  -3.654 -15.935  1.00 37.37           C
ATOM    588  CB  GLU    88       6.383  -3.342 -17.387  1.00 37.52           C
ATOM    589  CG  GLU    88       6.623  -4.448 -18.404  1.00 37.49           C
ATOM    590  CD  GLU    88       6.315  -4.002 -19.827  1.00 37.94           C
ATOM    591  OE1 GLU    88       6.461  -2.794 -20.131  1.00 38.37           O
ATOM    592  OE2 GLU    88       5.927  -4.861 -20.648  1.00 39.16           O
ATOM    593  C   GLU    88       5.922  -4.753 -15.333  1.00 37.15           C
ATOM    594  O   GLU    88       6.412  -5.824 -14.965  1.00 37.10           O
ATOM    595  N   ILE    89       4.630  -4.452 -15.218  1.00 37.16           N
ATOM    596  CA  ILE    89       3.621  -5.389 -14.721  1.00 37.09           C
ATOM    597  CB  ILE    89       3.060  -4.970 -13.311  1.00 37.12           C
ATOM    598  CG1 ILE    89       2.010  -5.964 -12.799  1.00 36.67           C
ATOM    600  CG2 ILE    89       2.492  -3.542 -13.319  1.00 37.01           C
ATOM    601  C   ILE    89       2.512  -5.512 -15.762  1.00 37.14           C
ATOM    602  O   ILE    89       1.964  -4.505 -16.214  1.00 37.09           O
ATOM    603  N   LEU    90       2.206  -6.744 -16.162  1.00 37.27           N
ATOM    604  CA  LEU    90       1.164  -6.991 -17.165  1.00 37.31           C
ATOM    605  CB  LEU    90       1.778  -7.474 -18.488  1.00 37.16           C
ATOM    606  CG  LEU    90       2.685  -6.482 -19.233  1.00 36.68           C
ATOM    607  CD1 LEU    90       3.563  -7.191 -20.238  1.00 36.06           C
ATOM    608  CD2 LEU    90       1.890  -5.370 -19.913  1.00 36.77           C
ATOM    609  C   LEU    90       0.113  -7.967 -16.640  1.00 37.53           C
ATOM    610  O   LEU    90       0.325  -8.612 -15.613  1.00 37.64           O
ATOM    611  N   GLU    91      -1.017  -8.065 -17.339  1.00 37.79           N
ATOM    612  CA  GLU    91      -2.171  -8.819 -16.847  1.00 38.13           C
ATOM    613  CB  GLU    91      -3.290  -7.871 -16.399  1.00 38.09           C
ATOM    614  CG  GLU    91      -2.996  -7.103 -15.113  1.00 38.39           C
ATOM    615  CD  GLU    91      -4.174  -6.264 -14.638  1.00 38.34           C
ATOM    616  OE1 GLU    91      -3.963  -5.067 -14.346  1.00 38.50           O
ATOM    617  OE2 GLU    91      -5.305  -6.798 -14.556  1.00 37.70           O
ATOM    618  C   GLU    91      -2.752  -9.813 -17.845  1.00 38.42           C
ATOM    619  O   GLU    91      -2.810  -9.551 -19.052  1.00 38.58           O
ATOM    620  N   ASP    92      -3.172 -10.957 -17.307  1.00 38.43           N
ATOM    621  CA  ASP    92      -4.020 -11.916 -17.996  1.00 38.26           C
ATOM    622  CB  ASP    92      -3.524 -13.336 -17.720  1.00 38.52           C
ATOM    623  CG  ASP    92      -2.786 -13.944 -18.892  1.00 39.09           C
ATOM    624  OD1 ASP    92      -2.831 -13.385 -20.011  1.00 40.80           O
ATOM    625  OD2 ASP    92      -2.165 -15.003 -18.689  1.00 39.16           O
ATOM    626  C   ASP    92      -5.424 -11.790 -17.434  1.00 38.06           C
ATOM    627  O   ASP    92      -5.708 -10.887 -16.650  1.00 37.96           O
ATOM    628  N   SER    93      -6.303 -12.702 -17.834  1.00 37.92           N
ATOM    629  CA  SER    93      -7.557 -12.904 -17.127  1.00 37.81           C
ATOM    630  CB  SER    93      -8.508 -13.771 -17.959  1.00 37.80           C
ATOM    631  OG  SER    93      -9.232 -12.996 -18.900  1.00 37.71           O
ATOM    632  C   SER    93      -7.276 -13.568 -15.772  1.00 37.69           C
ATOM    633  O   SER    93      -7.967 -13.306 -14.782  1.00 37.53           O
ATOM    634  N   SER    94      -6.238 -14.402 -15.736  1.00 37.51           N
ATOM    635  CA  SER    94      -5.946 -15.234 -14.573  1.00 37.51           C
ATOM    636  CB  SER    94      -5.663 -16.672 -15.018  1.00 37.61           C
ATOM    637  OG  SER    94      -6.738 -17.201 -15.790  1.00 38.14           O
ATOM    638  C   SER    94      -4.801 -14.732 -13.683  1.00 37.50           C
ATOM    639  O   SER    94      -4.810 -14.970 -12.474  1.00 37.51           O
ATOM    640  N   SER    95      -3.822 -14.039 -14.267  1.00 37.26           N
ATOM    641  CA  SER    95      -2.585 -13.749 -13.538  1.00 37.08           C
ATOM    642  CB  SER    95      -1.591 -14.923 -13.660  1.00 37.18           C
ATOM    643  OG  SER    95      -1.698 -15.598 -14.903  1.00 37.35           O
ATOM    644  C   SER    95      -1.892 -12.429 -13.863  1.00 36.91           C
ATOM    645  O   SER    95      -2.181 -11.785 -14.873  1.00 36.94           O
ATOM    646  N   PHE    96      -0.996 -12.028 -12.963  1.00 36.65           N
ATOM    647  CA  PHE    96      -0.093 -10.898 -13.177  1.00 36.39           C
ATOM    648  CB  PHE    96       0.133 -10.122 -11.878  1.00 36.25           C
ATOM    649  CG  PHE    96      -1.059  -9.328 -11.421  1.00 35.96           C
ATOM    650  CD1 PHE    96      -1.338  -8.083 -11.976  1.00 35.75           C
ATOM    651  CE1 PHE    96      -2.443  -7.339 -11.551  1.00 35.77           C
ATOM    652  CZ  PHE    96      -3.270  -7.840 -10.553  1.00 35.92           C
ATOM    653  CE2 PHE    96      -2.993  -9.081  -9.984  1.00 36.03           C
ATOM    654  CD2 PHE    96      -1.894  -9.818 -10.423  1.00 35.66           C
ATOM    655  C   PHE    96       1.250 -11.392 -13.694  1.00 36.33           C
ATOM    656  O   PHE    96       1.651 -12.531 -13.434  1.00 36.25           O
ATOM    657  N   TYR    97       1.943 -10.524 -14.420  1.00 36.35           N
ATOM    658  CA  TYR    97       3.258 -10.833 -14.952  1.00 36.30           C
ATOM    659  CB  TYR    97       3.192 -10.992 -16.469  1.00 36.50           C
ATOM    660  CG  TYR    97       2.346 -12.151 -16.912  1.00 36.66           C
ATOM    661  CD1 TYR    97       0.996 -11.980 -17.208  1.00 36.85           C
ATOM    662  CE1 TYR    97       0.209 -13.051 -17.609  1.00 37.00           C
ATOM    663  CZ  TYR    97       0.774 -14.311 -17.720  1.00 36.93           C
ATOM    664  OH  TYR    97       0.008 -15.381 -18.122  1.00 36.89           O
ATOM    665  CE2 TYR    97       2.112 -14.505 -17.431  1.00 37.02           C
ATOM    666  CD2 TYR    97       2.890 -13.427 -17.028  1.00 37.08           C
ATOM    667  C   TYR    97       4.235  -9.735 -14.578  1.00 36.23           C
ATOM    668  O   TYR    97       4.147  -8.612 -15.088  1.00 36.22           O
ATOM    669  N   ILE    98       5.153 -10.065 -13.674  1.00 36.23           N
ATOM    670  CA  ILE    98       6.181  -9.127 -13.229  1.00 36.16           C
ATOM    671  CB  ILE    98       6.538  -9.319 -11.732  1.00 36.20           C
ATOM    672  CG1 ILE    98       5.282  -9.276 -10.844  1.00 36.21           C
ATOM    673  CD1 ILE    98       4.464  -7.983 -10.914  1.00 36.31           C
ATOM    674  CG2 ILE    98       7.600  -8.308 -11.291  1.00 36.10           C
ATOM    675  C   ILE    98       7.427  -9.300 -14.087  1.00 36.14           C
ATOM    676  O   ILE    98       8.144 -10.293 -13.965  1.00 36.14           O
ATOM    677  N   VAL    99       7.667  -8.334 -14.964  1.00 36.22           N
ATOM    678  CA  VAL    99       8.810  -8.382 -15.861  1.00 36.31           C
ATOM    679  CB  VAL    99       8.511  -7.673 -17.201  1.00 36.28           C
ATOM    680  CG1 VAL    99       9.641  -7.898 -18.191  1.00 36.08           C
ATOM    681  CG2 VAL    99       7.197  -8.175 -17.785  1.00 36.36           C
ATOM    682  C   VAL    99      10.016  -7.752 -15.169  1.00 36.46           C
ATOM    683  O   VAL    99      10.031  -6.547 -14.900  1.00 36.48           O
ATOM    684  N   GLY   100      11.016  -8.580 -14.873  1.00 36.62           N
ATOM    685  CA  GLY   100      12.243  -8.114 -14.232  1.00 36.87           C
ATOM    686  C   GLY   100      13.536  -8.547 -14.904  1.00 37.09           C
ATOM    687  O   GLY   100      13.525  -9.162 -15.975  1.00 36.96           O
ATOM    688  N   GLU   101      14.650  -8.212 -14.251  1.00 37.49           N
ATOM    689  CA  GLU   101      16.002  -8.568 -14.691  1.00 37.86           C
ATOM    690  CB  GLU   101      17.035  -7.968 -13.737  1.00 37.93           C
ATOM    691  CG  GLU   101      17.468  -6.553 -14.046  1.00 38.36           C
ATOM    692  CD  GLU   101      18.699  -6.152 -13.253  1.00 38.60           C
ATOM    693  OE1 GLU   101      19.813  -6.599 -13.607  1.00 38.92           O
ATOM    694  OE2 GLU   101      18.553  -5.391 -12.274  1.00 38.75           O
ATOM    695  C   GLU   101      16.250 -10.071 -14.744  1.00 38.02           C
ATOM    696  O   GLU   101      15.879 -10.806 -13.824  1.00 38.21           O
ATOM    697  N   LEU   102      16.895 -10.512 -15.818  1.00 38.12           N
ATOM    698  CA  LEU   102      17.386 -11.876 -15.922  1.00 38.32           C
ATOM    699  CB  LEU   102      17.420 -12.300 -17.394  1.00 38.26           C
ATOM    700  CG  LEU   102      17.501 -13.778 -17.781  1.00 38.19           C
ATOM    701  CD1 LEU   102      16.282 -14.555 -17.308  1.00 38.27           C
ATOM    702  CD2 LEU   102      17.654 -13.909 -19.286  1.00 38.27           C
ATOM    703  C   LEU   102      18.785 -11.906 -15.308  1.00 38.61           C
ATOM    704  O   LEU   102      19.610 -11.039 -15.609  1.00 38.57           O
ATOM    705  N   TYR   103      19.049 -12.882 -14.438  1.00 38.99           N
ATOM    706  CA  TYR   103      20.336 -12.954 -13.727  1.00 39.46           C
ATOM    707  CB  TYR   103      20.271 -12.132 -12.430  1.00 39.67           C
ATOM    708  CG  TYR   103      21.609 -11.628 -11.910  1.00 40.14           C
ATOM    709  CD1 TYR   103      22.018 -10.312 -12.136  1.00 40.32           C
ATOM    710  CE1 TYR   103      23.248  -9.847 -11.658  1.00 40.34           C
ATOM    711  CZ  TYR   103      24.074 -10.702 -10.942  1.00 40.18           C
ATOM    712  OH  TYR   103      25.281 -10.254 -10.464  1.00 40.20           O
ATOM    713  CE2 TYR   103      23.691 -12.008 -10.702  1.00 40.40           C
ATOM    714  CD2 TYR   103      22.462 -12.464 -11.180  1.00 40.73           C
ATOM    715  C   TYR   103      20.779 -14.389 -13.415  1.00 39.53           C
ATOM    716  O   TYR   103      19.951 -15.251 -13.116  1.00 39.69           O
ATOM    717  N   THR   104      22.089 -14.628 -13.486  1.00 39.57           N
ATOM    718  CA  THR   104      22.690 -15.913 -13.109  1.00 39.61           C
ATOM    719  CB  THR   104      23.042 -16.782 -14.339  1.00 39.67           C
ATOM    720  OG1 THR   104      23.551 -15.951 -15.392  1.00 39.48           O
ATOM    721  CG2 THR   104      21.816 -17.540 -14.842  1.00 39.86           C
ATOM    722  C   THR   104      23.953 -15.703 -12.281  1.00 39.65           C
ATOM    723  O   THR   104      23.885 -15.438 -11.079  1.00 39.64           O
ATOM    724  N   GLY   106      23.261 -17.538  -9.332  1.00 33.49           N
ATOM    725  CA  GLY   106      22.701 -18.357  -8.257  1.00 33.63           C
ATOM    726  C   GLY   106      22.431 -17.577  -6.980  1.00 33.48           C
ATOM    727  O   GLY   106      22.877 -16.443  -6.833  1.00 33.62           O
ATOM    728  N   GLU   107      21.701 -18.190  -6.052  1.00 33.52           N
ATOM    729  CA  GLU   107      21.319 -17.533  -4.797  1.00 33.48           C
ATOM    730  CB  GLU   107      20.104 -18.228  -4.179  1.00 33.55           C
ATOM    731  CG  GLU   107      18.865 -18.275  -5.060  1.00 33.79           C
ATOM    732  CD  GLU   107      17.904 -19.382  -4.665  1.00 34.37           C
ATOM    733  OE1 GLU   107      18.279 -20.252  -3.848  1.00 34.44           O
ATOM    734  OE2 GLU   107      16.769 -19.386  -5.183  1.00 35.08           O
ATOM    735  C   GLU   107      22.454 -17.530  -3.777  1.00 33.49           C
ATOM    736  O   GLU   107      23.302 -18.424  -3.783  1.00 33.49           O
ATOM    737  N   LEU   108      22.451 -16.533  -2.891  1.00 33.49           N
ATOM    738  CA  LEU   108      23.377 -16.489  -1.761  1.00 33.54           C
ATOM    739  CB  LEU   108      23.170 -15.211  -0.942  1.00 33.42           C
ATOM    740  CG  LEU   108      23.974 -15.053   0.358  1.00 33.34           C
ATOM    741  CD1 LEU   108      25.475 -14.959   0.088  1.00 32.85           C
ATOM    742  CD2 LEU   108      23.501 -13.857   1.166  1.00 33.16           C
ATOM    743  C   LEU   108      23.233 -17.728  -0.873  1.00 34.17           C
ATOM    744  O   LEU   108      24.202 -18.158  -0.236  1.00 34.01           O
ATOM    745  N   PHE   109      22.024 -18.293  -0.843  1.00 34.89           N
ATOM    746  CA  PHE   109      21.749 -19.548  -0.139  1.00 35.64           C
ATOM    747  CB  PHE   109      20.267 -19.935  -0.267  1.00 36.02           C
ATOM    748  CG  PHE   109      19.936 -21.299   0.296  1.00 36.63           C
ATOM    749  CD1 PHE   109      20.035 -21.549   1.668  1.00 37.40           C
ATOM    750  CE1 PHE   109      19.728 -22.810   2.193  1.00 37.93           C
ATOM    751  CZ  PHE   109      19.308 -23.840   1.338  1.00 37.98           C
ATOM    752  CE2 PHE   109      19.202 -23.602  -0.036  1.00 38.23           C
ATOM    753  CD2 PHE   109      19.518 -22.330  -0.547  1.00 37.77           C
ATOM    754  C   PHE   109      22.634 -20.685  -0.633  1.00 35.90           C
ATOM    755  O   PHE   109      23.195 -21.429   0.173  1.00 36.23           O
ATOM    756  N   ASP   110      22.753 -20.816  -1.955  1.00 36.15           N
ATOM    757  CA  ASP   110      23.589 -21.853  -2.561  1.00 36.28           C
ATOM    758  CB  ASP   110      23.398 -21.887  -4.078  1.00 36.23           C
ATOM    759  CG  ASP   110      22.042 -22.437  -4.483  1.00 36.64           C
ATOM    760  OD1 ASP   110      21.417 -21.852  -5.392  1.00 37.74           O
ATOM    761  OD2 ASP   110      21.593 -23.445  -3.891  1.00 36.09           O
ATOM    762  C   ASP   110      25.061 -21.664  -2.208  1.00 36.30           C
ATOM    763  O   ASP   110      25.805 -22.638  -2.073  1.00 36.12           O
ATOM    764  N   GLU   111      25.464 -20.407  -2.046  1.00 36.37           N
ATOM    765  CA  GLU   111      26.830 -20.081  -1.667  1.00 36.60           C
ATOM    766  CB  GLU   111      27.132 -18.608  -1.950  1.00 36.54           C
ATOM    767  CG  GLU   111      28.625 -18.269  -1.994  1.00 37.31           C
ATOM    768  CD  GLU   111      29.389 -19.047  -3.057  1.00 38.10           C
ATOM    769  OE1 GLU   111      30.522 -19.490  -2.770  1.00 38.38           O
ATOM    770  OE2 GLU   111      28.859 -19.218  -4.177  1.00 38.84           O
ATOM    771  C   GLU   111      27.102 -20.429  -0.205  1.00 36.61           C
ATOM    772  O   GLU   111      28.206 -20.854   0.133  1.00 36.67           O
ATOM    773  N   ILE   112      26.097 -20.250   0.653  1.00 36.70           N
ATOM    774  CA  ILE   112      26.201 -20.643   2.059  1.00 36.50           C
ATOM    775  CB  ILE   112      24.973 -20.191   2.883  1.00 36.47           C
ATOM    776  CG1 ILE   112      25.011 -18.674   3.086  1.00 36.37           C
ATOM    777  CD1 ILE   112      23.685 -18.073   3.524  1.00 36.16           C
ATOM    778  CG2 ILE   112      24.929 -20.892   4.242  1.00 36.56           C
ATOM    779  C   ILE   112      26.443 -22.148   2.176  1.00 36.50           C
ATOM    780  O   ILE   112      27.347 -22.569   2.894  1.00 36.44           O
ATOM    781  N   ILE   113      25.659 -22.946   1.451  1.00 36.66           N
ATOM    782  CA  ILE   113      25.867 -24.400   1.396  1.00 36.69           C
ATOM    783  CB  ILE   113      24.861 -25.122   0.445  1.00 36.66           C
ATOM    784  CG1 ILE   113      23.413 -24.901   0.897  1.00 36.88           C
ATOM    785  CD1 ILE   113      22.359 -25.417  -0.091  1.00 36.70           C
ATOM    786  CG2 ILE   113      25.164 -26.629   0.358  1.00 36.32           C
ATOM    787  C   ILE   113      27.294 -24.743   0.969  1.00 36.84           C
ATOM    788  O   ILE   113      27.923 -25.612   1.571  1.00 36.89           O
ATOM    789  N   LYS   114      27.796 -24.049  -0.054  1.00 37.07           N
ATOM    790  CA  LYS   114      29.108 -24.347  -0.644  1.00 37.48           C
ATOM    791  CB  LYS   114      29.271 -23.658  -2.009  1.00 37.43           C
ATOM    792  CG  LYS   114      30.544 -24.048  -2.765  1.00 37.61           C
ATOM    793  CD  LYS   114      30.754 -23.186  -4.004  1.00 37.66           C
ATOM    796  C   LYS   114      30.279 -23.992   0.276  1.00 37.69           C
ATOM    797  O   LYS   114      31.138 -24.835   0.535  1.00 37.73           O
ATOM    798  N   ARG   115      30.309 -22.751   0.758  1.00 37.97           N
ATOM    799  CA  ARG   115      31.419 -22.266   1.582  1.00 38.30           C
ATOM    800  CB  ARG   115      31.552 -20.747   1.482  1.00 38.46           C
ATOM    801  CG  ARG   115      32.084 -20.230   0.163  1.00 39.08           C
ATOM    802  CD  ARG   115      32.802 -18.912   0.385  1.00 40.50           C
ATOM    803  NE  ARG   115      32.388 -17.880  -0.564  1.00 41.66           N
ATOM    804  CZ  ARG   115      32.840 -16.628  -0.556  1.00 42.14           C
ATOM    805  NH1 ARG   115      33.735 -16.242   0.347  1.00 42.55           N
ATOM    806  NH2 ARG   115      32.398 -15.760  -1.456  1.00 42.51           N
ATOM    807  C   ARG   115      31.304 -22.650   3.054  1.00 38.39           C
ATOM    808  O   ARG   115      32.311 -22.670   3.767  1.00 38.33           O
ATOM    809  N   LYS   116      30.079 -22.944   3.501  1.00 38.47           N
ATOM    810  CA  LYS   116      29.766 -23.235   4.916  1.00 38.51           C
ATOM    811  CB  LYS   116      30.640 -24.369   5.493  1.00 38.50           C
ATOM    812  CG  LYS   116      30.640 -25.674   4.688  1.00 39.20           C
ATOM    813  CD  LYS   116      29.309 -26.418   4.779  1.00 40.13           C
ATOM    814  CE  LYS   116      29.247 -27.577   3.791  1.00 40.55           C
ATOM    815  NZ  LYS   116      30.306 -28.599   4.027  1.00 40.66           N
ATOM    816  C   LYS   116      29.853 -21.985   5.793  1.00 38.28           C
ATOM    817  O   LYS   116      28.910 -21.657   6.509  1.00 38.31           O
ATOM    818  N   ARG   117      30.997 -21.305   5.734  1.00 38.17           N
ATOM    819  CA  ARG   117      31.236 -20.058   6.457  1.00 38.04           C
ATOM    820  CB  ARG   117      32.042 -20.308   7.741  1.00 38.13           C
ATOM    821  CG  ARG   117      31.334 -21.167   8.781  1.00 38.77           C
ATOM    822  CD  ARG   117      31.927 -20.994  10.172  1.00 39.99           C
ATOM    823  NE  ARG   117      33.217 -21.659  10.333  1.00 41.28           N
ATOM    824  CZ  ARG   117      33.373 -22.950  10.625  1.00 42.06           C
ATOM    825  NH1 ARG   117      34.592 -23.458  10.751  1.00 41.84           N
ATOM    826  NH2 ARG   117      32.315 -23.738  10.782  1.00 42.52           N
ATOM    827  C   ARG   117      31.981 -19.064   5.563  1.00 37.86           C
ATOM    828  O   ARG   117      32.629 -19.446   4.582  1.00 37.76           O
ATOM    829  N   PHE   118      31.879 -17.786   5.910  1.00 37.62           N
ATOM    830  CA  PHE   118      32.569 -16.725   5.191  1.00 37.36           C
ATOM    831  CB  PHE   118      31.562 -15.696   4.662  1.00 37.23           C
ATOM    832  CG  PHE   118      30.636 -16.234   3.603  1.00 37.48           C
ATOM    833  CD1 PHE   118      29.620 -17.134   3.928  1.00 37.66           C
ATOM    834  CE1 PHE   118      28.763 -17.634   2.943  1.00 37.56           C
ATOM    835  CZ  PHE   118      28.914 -17.227   1.620  1.00 36.86           C
ATOM    836  CE2 PHE   118      29.918 -16.328   1.286  1.00 37.08           C
ATOM    837  CD2 PHE   118      30.773 -15.833   2.276  1.00 37.60           C
ATOM    838  C   PHE   118      33.541 -16.045   6.134  1.00 37.18           C
ATOM    839  O   PHE   118      33.249 -15.891   7.321  1.00 37.34           O
ATOM    840  N   SER   119      34.697 -15.645   5.612  1.00 36.91           N
ATOM    841  CA  SER   119      35.624 -14.812   6.372  1.00 36.85           C
ATOM    842  CB  SER   119      36.961 -14.660   5.635  1.00 36.88           C
ATOM    843  OG  SER   119      36.800 -13.946   4.420  1.00 36.81           O
ATOM    844  C   SER   119      34.989 -13.443   6.616  1.00 36.70           C
ATOM    845  O   SER   119      34.089 -13.032   5.875  1.00 36.71           O
ATOM    846  N   GLU   120      35.449 -12.748   7.654  1.00 36.56           N
ATOM    847  CA  GLU   120      34.903 -11.433   8.007  1.00 36.56           C
ATOM    848  CB  GLU   120      35.581 -10.876   9.263  1.00 36.52           C
ATOM    849  CG  GLU   120      35.304 -11.677  10.535  1.00 36.21           C
ATOM    850  CD  GLU   120      35.610 -10.899  11.807  1.00 36.20           C
ATOM    851  OE1 GLU   120      35.161  -9.739  11.915  1.00 35.47           O
ATOM    852  OE2 GLU   120      36.284 -11.449  12.704  1.00 35.08           O
ATOM    853  C   GLU   120      35.001 -10.439   6.845  1.00 36.72           C
ATOM    854  O   GLU   120      34.075  -9.662   6.606  1.00 36.78           O
ATOM    855  N   HIS   121      36.117 -10.503   6.122  1.00 36.79           N
ATOM    856  CA  HIS   121      36.375  -9.699   4.925  1.00 37.00           C
ATOM    857  CB  HIS   121      37.817  -9.948   4.447  1.00 37.26           C
ATOM    858  CG  HIS   121      38.141  -9.348   3.113  1.00 38.32           C
ATOM    859  ND1 HIS   121      37.564  -9.781   1.937  1.00 39.06           N
ATOM    860  CE1 HIS   121      38.053  -9.086   0.925  1.00 39.93           C
ATOM    861  NE2 HIS   121      38.941  -8.230   1.399  1.00 40.12           N
ATOM    862  CD2 HIS   121      39.019  -8.377   2.763  1.00 39.74           C
ATOM    863  C   HIS   121      35.366  -9.982   3.806  1.00 36.79           C
ATOM    864  O   HIS   121      34.743  -9.055   3.289  1.00 36.83           O
ATOM    865  N   ASP   122      35.217 -11.255   3.436  1.00 36.68           N
ATOM    866  CA  ASP   122      34.287 -11.669   2.379  1.00 36.37           C
ATOM    867  CB  ASP   122      34.475 -13.148   2.033  1.00 36.39           C
ATOM    868  CG  ASP   122      35.711 -13.409   1.173  1.00 36.34           C
ATOM    869  OD1 ASP   122      36.258 -12.455   0.571  1.00 35.80           O
ATOM    870  OD2 ASP   122      36.128 -14.586   1.092  1.00 35.41           O
ATOM    871  C   ASP   122      32.832 -11.415   2.756  1.00 36.45           C
ATOM    872  O   ASP   122      32.026 -11.011   1.910  1.00 36.51           O
ATOM    873  N   ALA   123      32.496 -11.655   4.023  1.00 36.22           N
ATOM    874  CA  ALA   123      31.146 -11.397   4.515  1.00 36.04           C
ATOM    875  CB  ALA   123      30.962 -11.954   5.926  1.00 35.90           C
ATOM    876  C   ALA   123      30.822  -9.904   4.476  1.00 36.00           C
ATOM    877  O   ALA   123      29.725  -9.515   4.067  1.00 36.35           O
ATOM    878  N   ALA   124      31.782  -9.076   4.886  1.00 35.66           N
ATOM    879  CA  ALA   124      31.590  -7.628   4.939  1.00 35.34           C
ATOM    880  CB  ALA   124      32.799  -6.945   5.567  1.00 35.44           C
ATOM    881  C   ALA   124      31.292  -7.031   3.573  1.00 35.16           C
ATOM    882  O   ALA   124      30.430  -6.169   3.456  1.00 34.99           O
ATOM    883  N   ARG   125      32.005  -7.489   2.547  1.00 35.21           N
ATOM    884  CA  ARG   125      31.808  -6.977   1.192  1.00 35.45           C
ATOM    885  CB  ARG   125      32.883  -7.502   0.242  1.00 35.29           C
ATOM    886  CG  ARG   125      34.236  -6.817   0.419  1.00 36.30           C
ATOM    887  CD  ARG   125      35.146  -7.044  -0.779  1.00 36.79           C
ATOM    888  NE  ARG   125      36.217  -6.054  -0.838  1.00 37.72           N
ATOM    892  C   ARG   125      30.409  -7.308   0.674  1.00 35.51           C
ATOM    893  O   ARG   125      29.740  -6.456   0.089  1.00 35.59           O
ATOM    894  N   ILE   126      29.978  -8.544   0.917  1.00 35.54           N
ATOM    895  CA  ILE   126      28.656  -9.022   0.528  1.00 35.88           C
ATOM    896  CB  ILE   126      28.496 -10.548   0.816  1.00 36.07           C
ATOM    897  CG1 ILE   126      29.344 -11.382  -0.156  1.00 35.58           C
ATOM    899  CG2 ILE   126      27.025 -10.971   0.750  1.00 35.70           C
ATOM    900  C   ILE   126      27.529  -8.253   1.224  1.00 35.87           C
ATOM    901  O   ILE   126      26.607  -7.763   0.569  1.00 35.90           O
ATOM    902  N   ILE   127      27.609  -8.148   2.548  1.00 36.00           N
ATOM    903  CA  ILE   127      26.514  -7.573   3.332  1.00 36.12           C
ATOM    904  CB  ILE   127      26.524  -8.082   4.809  1.00 35.91           C
ATOM    905  CG1 ILE   127      25.123  -8.010   5.433  1.00 36.32           C
ATOM    906  CD1 ILE   127      24.123  -9.036   4.901  1.00 35.52           C
ATOM    907  CG2 ILE   127      27.564  -7.338   5.658  1.00 35.44           C
ATOM    908  C   ILE   127      26.450  -6.039   3.231  1.00 36.39           C
ATOM    909  O   ILE   127      25.380  -5.455   3.405  1.00 36.55           O
ATOM    910  N   LYS   128      27.582  -5.401   2.931  1.00 36.57           N
ATOM    911  CA  LYS   128      27.619  -3.957   2.687  1.00 37.02           C
ATOM    912  CB  LYS   128      29.048  -3.466   2.436  1.00 36.87           C
ATOM    913  CG  LYS   128      29.160  -1.947   2.383  1.00 37.58           C
ATOM    914  CD  LYS   128      30.522  -1.451   1.924  1.00 37.09           C
ATOM    915  CE  LYS   128      30.477   0.051   1.651  1.00 37.69           C
ATOM    916  NZ  LYS   128      31.823   0.654   1.370  1.00 37.93           N
ATOM    917  C   LYS   128      26.729  -3.601   1.500  1.00 37.24           C
ATOM    918  O   LYS   128      25.963  -2.634   1.551  1.00 37.25           O
ATOM    919  N   GLN   129      26.839  -4.396   0.437  1.00 37.54           N
ATOM    920  CA  GLN   129      26.002  -4.233  -0.745  1.00 37.86           C
ATOM    921  CB  GLN   129      26.434  -5.191  -1.850  1.00 37.70           C
ATOM    922  CG  GLN   129      27.671  -4.724  -2.583  1.00 38.27           C
ATOM    923  CD  GLN   129      28.219  -5.773  -3.522  1.00 39.02           C
ATOM    924  OE1 GLN   129      28.055  -5.677  -4.738  1.00 39.16           O
ATOM    925  NE2 GLN   129      28.871  -6.788  -2.962  1.00 39.43           N
ATOM    926  C   GLN   129      24.530  -4.428  -0.402  1.00 38.06           C
ATOM    927  O   GLN   129      23.680  -3.685  -0.894  1.00 38.16           O
ATOM    928  N   VAL   130      24.245  -5.414   0.454  1.00 38.16           N
ATOM    929  CA  VAL   130      22.891  -5.648   0.974  1.00 38.26           C
ATOM    930  CB  VAL   130      22.827  -6.910   1.895  1.00 38.23           C
ATOM    931  CG1 VAL   130      21.446  -7.087   2.503  1.00 37.91           C
ATOM    932  CG2 VAL   130      23.209  -8.162   1.120  1.00 38.57           C
ATOM    933  C   VAL   130      22.377  -4.414   1.720  1.00 38.44           C
ATOM    934  O   VAL   130      21.217  -4.027   1.544  1.00 38.76           O
ATOM    935  N   PHE   131      23.243  -3.801   2.534  1.00 38.51           N
ATOM    936  CA  PHE   131      22.902  -2.588   3.291  1.00 38.50           C
ATOM    937  CB  PHE   131      24.013  -2.201   4.281  1.00 38.56           C
ATOM    938  CG  PHE   131      24.243  -3.201   5.383  1.00 38.34           C
ATOM    939  CD1 PHE   131      23.247  -4.097   5.768  1.00 38.39           C
ATOM    940  CE1 PHE   131      23.470  -5.017   6.789  1.00 38.38           C
ATOM    941  CZ  PHE   131      24.688  -5.033   7.456  1.00 38.10           C
ATOM    942  CE2 PHE   131      25.683  -4.135   7.091  1.00 38.61           C
ATOM    943  CD2 PHE   131      25.457  -3.225   6.060  1.00 38.32           C
ATOM    944  C   PHE   131      22.648  -1.410   2.363  1.00 38.56           C
ATOM    945  O   PHE   131      21.714  -0.631   2.574  1.00 38.51           O
ATOM    946  N   SER   132      23.486  -1.284   1.338  1.00 38.55           N
ATOM    947  CA  SER   132      23.352  -0.207   0.374  1.00 38.70           C
ATOM    948  CB  SER   132      24.447  -0.297  -0.683  1.00 38.79           C
ATOM    949  OG  SER   132      24.417   0.844  -1.525  1.00 39.77           O
ATOM    950  C   SER   132      21.974  -0.248  -0.281  1.00 38.66           C
ATOM    951  O   SER   132      21.317   0.789  -0.422  1.00 39.01           O
ATOM    952  N   GLY   133      21.541  -1.450  -0.664  1.00 38.31           N
ATOM    953  CA  GLY   133      20.230  -1.655  -1.279  1.00 37.83           C
ATOM    954  C   GLY   133      19.086  -1.346  -0.330  1.00 37.66           C
ATOM    955  O   GLY   133      18.174  -0.592  -0.676  1.00 37.42           O
ATOM    956  N   ILE   134      19.145  -1.929   0.867  1.00 37.33           N
ATOM    957  CA  ILE   134      18.147  -1.697   1.914  1.00 37.04           C
ATOM    958  CB  ILE   134      18.474  -2.505   3.194  1.00 37.18           C
ATOM    959  CG1 ILE   134      18.214  -3.992   2.967  1.00 37.31           C
ATOM    960  CD1 ILE   134      18.740  -4.860   4.090  1.00 38.64           C
ATOM    961  CG2 ILE   134      17.636  -2.036   4.377  1.00 37.43           C
ATOM    962  C   ILE   134      18.014  -0.211   2.243  1.00 36.65           C
ATOM    963  O   ILE   134      16.903   0.321   2.270  1.00 36.84           O
ATOM    964  N   THR   135      19.147   0.448   2.480  1.00 36.30           N
ATOM    965  CA  THR   135      19.186   1.886   2.741  1.00 35.98           C
ATOM    966  CB  THR   135      20.656   2.404   2.827  1.00 36.00           C
ATOM    967  OG1 THR   135      21.331   1.754   3.910  1.00 35.31           O
ATOM    968  CG2 THR   135      20.715   3.920   3.035  1.00 35.30           C
ATOM    969  C   THR   135      18.406   2.665   1.673  1.00 36.03           C
ATOM    970  O   THR   135      17.551   3.497   2.000  1.00 35.98           O
ATOM    971  N   TYR   136      18.705   2.381   0.405  1.00 35.86           N
ATOM    972  CA  TYR   136      18.094   3.091  -0.711  1.00 35.85           C
ATOM    973  CB  TYR   136      18.751   2.689  -2.039  1.00 35.59           C
ATOM    974  CG  TYR   136      18.043   3.217  -3.269  1.00 35.22           C
ATOM    975  CD1 TYR   136      18.323   4.484  -3.768  1.00 34.60           C
ATOM    976  CE1 TYR   136      17.673   4.972  -4.898  1.00 34.44           C
ATOM    977  CZ  TYR   136      16.733   4.183  -5.542  1.00 34.97           C
ATOM    978  OH  TYR   136      16.090   4.659  -6.661  1.00 34.87           O
ATOM    979  CE2 TYR   136      16.435   2.921  -5.068  1.00 34.41           C
ATOM    980  CD2 TYR   136      17.088   2.443  -3.936  1.00 35.11           C
ATOM    981  C   TYR   136      16.585   2.870  -0.763  1.00 36.15           C
ATOM    982  O   TYR   136      15.831   3.812  -1.019  1.00 36.25           O
ATOM    983  N   MET   137      16.149   1.633  -0.528  1.00 36.19           N
ATOM    984  CA  MET   137      14.726   1.318  -0.565  1.00 36.60           C
ATOM    985  CB  MET   137      14.484  -0.194  -0.659  1.00 36.57           C
ATOM    986  CG  MET   137      15.080  -0.882  -1.889  1.00 36.67           C
ATOM    987  SD  MET   137      14.485  -0.279  -3.490  1.00 39.34           S
ATOM    988  CE  MET   137      12.859  -1.052  -3.570  1.00 37.93           C
ATOM    989  C   MET   137      13.998   1.921   0.640  1.00 36.77           C
ATOM    990  O   MET   137      12.875   2.409   0.508  1.00 36.50           O
ATOM    991  N   HIS   138      14.660   1.910   1.799  1.00 37.07           N
ATOM    992  CA  HIS   138      14.099   2.460   3.039  1.00 37.48           C
ATOM    993  CB  HIS   138      14.950   2.046   4.239  1.00 37.56           C
ATOM    994  CG  HIS   138      14.751   0.619   4.646  1.00 37.99           C
ATOM    995  ND1 HIS   138      15.144   0.133   5.873  1.00 38.22           N
ATOM    996  CE1 HIS   138      14.825  -1.146   5.959  1.00 38.06           C
ATOM    997  NE2 HIS   138      14.241  -1.507   4.830  1.00 38.16           N
ATOM    998  CD2 HIS   138      14.179  -0.421   3.994  1.00 37.57           C
ATOM    999  C   HIS   138      13.935   3.973   3.000  1.00 37.78           C
ATOM   1000  O   HIS   138      13.043   4.525   3.656  1.00 37.97           O
ATOM   1001  N   LYS   139      14.798   4.633   2.228  1.00 37.85           N
ATOM   1002  CA  LYS   139      14.692   6.064   1.967  1.00 38.05           C
ATOM   1003  CB  LYS   139      15.876   6.528   1.121  1.00 38.01           C
ATOM   1004  CG  LYS   139      16.333   7.946   1.395  1.00 38.54           C
ATOM   1005  CD  LYS   139      17.494   8.349   0.481  1.00 38.59           C
ATOM   1006  CE  LYS   139      17.005   8.808  -0.896  1.00 39.38           C
ATOM   1007  NZ  LYS   139      18.119   9.260  -1.778  0.50 38.90           N
ATOM   1008  C   LYS   139      13.387   6.359   1.234  1.00 37.83           C
ATOM   1009  O   LYS   139      12.820   7.443   1.372  1.00 37.81           O
ATOM   1010  N   HIS   140      12.923   5.380   0.462  1.00 37.76           N
ATOM   1011  CA  HIS   140      11.685   5.488  -0.297  1.00 37.84           C
ATOM   1012  CB  HIS   140      11.904   4.999  -1.727  1.00 37.68           C
ATOM   1013  CG  HIS   140      12.732   5.926  -2.561  1.00 37.65           C
ATOM   1014  ND1 HIS   140      14.085   5.750  -2.750  1.00 37.51           N
ATOM   1015  CE1 HIS   140      14.548   6.715  -3.526  1.00 38.12           C
ATOM   1016  NE2 HIS   140      13.542   7.506  -3.853  1.00 37.89           N
ATOM   1017  CD2 HIS   140      12.394   7.035  -3.262  1.00 37.76           C
ATOM   1018  C   HIS   140      10.528   4.728   0.365  1.00 38.12           C
ATOM   1019  O   HIS   140       9.542   4.386  -0.297  1.00 38.03           O
ATOM   1020  N   ASN   141      10.665   4.468   1.669  1.00 38.34           N
ATOM   1021  CA  ASN   141       9.613   3.846   2.492  1.00 38.41           C
ATOM   1022  CB  ASN   141       8.352   4.719   2.526  1.00 38.42           C
ATOM   1023  CG  ASN   141       8.635   6.144   2.955  1.00 38.82           C
ATOM   1024  OD1 ASN   141       9.148   6.388   4.046  1.00 39.07           O
ATOM   1025  ND2 ASN   141       8.290   7.097   2.098  1.00 39.44           N
ATOM   1026  C   ASN   141       9.241   2.414   2.100  1.00 38.55           C
ATOM   1027  O   ASN   141       8.202   1.888   2.541  1.00 38.39           O
ATOM   1028  N   ILE   142      10.087   1.778   1.289  1.00 38.47           N
ATOM   1029  CA  ILE   142       9.802   0.427   0.803  1.00 38.44           C
ATOM   1030  CB  ILE   142      10.140   0.258  -0.700  1.00 38.55           C
ATOM   1031  CG1 ILE   142       9.294   1.209  -1.554  1.00 38.43           C
ATOM   1033  CG2 ILE   142       9.892  -1.188  -1.150  1.00 38.79           C
ATOM   1034  C   ILE   142      10.498  -0.631   1.658  1.00 38.24           C
ATOM   1035  O   ILE   142      11.726  -0.674   1.736  1.00 38.21           O
ATOM   1036  N   VAL   143       9.687  -1.470   2.301  1.00 38.06           N
ATOM   1037  CA  VAL   143      10.165  -2.535   3.178  1.00 37.80           C
ATOM   1038  CB  VAL   143       9.337  -2.593   4.493  1.00 37.85           C
ATOM   1039  CG1 VAL   143       9.975  -3.561   5.499  1.00 37.17           C
ATOM   1040  CG2 VAL   143       9.185  -1.194   5.106  1.00 37.28           C
ATOM   1041  C   VAL   143      10.079  -3.891   2.463  1.00 38.00           C
ATOM   1042  O   VAL   143       9.041  -4.230   1.883  1.00 38.14           O
ATOM   1043  N   HIS   144      11.159  -4.666   2.508  1.00 37.82           N
ATOM   1044  CA  HIS   144      11.163  -5.976   1.864  1.00 37.95           C
ATOM   1045  CB  HIS   144      12.582  -6.543   1.718  1.00 37.73           C
ATOM   1046  CG  HIS   144      12.660  -7.720   0.793  1.00 38.01           C
ATOM   1047  ND1 HIS   144      12.079  -8.938   1.082  1.00 37.54           N
ATOM   1048  CE1 HIS   144      12.300  -9.778   0.086  1.00 37.75           C
ATOM   1049  NE2 HIS   144      12.997  -9.149  -0.843  1.00 38.13           N
ATOM   1050  CD2 HIS   144      13.236  -7.861  -0.427  1.00 38.48           C
ATOM   1051  C   HIS   144      10.256  -6.970   2.589  1.00 37.91           C
ATOM   1052  O   HIS   144       9.370  -7.561   1.968  1.00 37.73           O
ATOM   1053  N   ARG   145      10.504  -7.153   3.890  1.00 37.97           N
ATOM   1054  CA  ARG   145       9.711  -8.026   4.779  1.00 37.97           C
ATOM   1055  CB  ARG   145       8.199  -7.848   4.572  1.00 37.80           C
ATOM   1056  CG  ARG   145       7.640  -6.462   4.881  1.00 37.93           C
ATOM   1057  CD  ARG   145       6.160  -6.369   4.470  1.00 38.06           C
ATOM   1058  NE  ARG   145       5.302  -7.227   5.296  1.00 37.67           N
ATOM   1059  CZ  ARG   145       4.033  -7.519   5.031  1.00 36.50           C
ATOM   1060  NH1 ARG   145       3.357  -8.309   5.846  1.00 35.78           N
ATOM   1061  NH2 ARG   145       3.437  -7.028   3.954  1.00 37.40           N
ATOM   1062  C   ARG   145      10.057  -9.512   4.687  1.00 38.14           C
ATOM   1063  O   ARG   145       9.674 -10.293   5.563  1.00 38.05           O
ATOM   1064  N   ASP   146      10.753  -9.914   3.629  1.00 38.34           N
ATOM   1065  CA  ASP   146      11.065 -11.331   3.429  1.00 38.90           C
ATOM   1066  CB  ASP   146      10.087 -11.976   2.440  1.00 39.10           C
ATOM   1067  CG  ASP   146       8.720 -12.219   3.043  1.00 40.68           C
ATOM   1068  OD1 ASP   146       7.830 -11.361   2.861  1.00 43.27           O
ATOM   1069  OD2 ASP   146       8.521 -13.264   3.703  1.00 43.42           O
ATOM   1070  C   ASP   146      12.513 -11.536   2.979  1.00 38.86           C
ATOM   1071  O   ASP   146      12.801 -12.404   2.153  1.00 38.69           O
ATOM   1072  N   LEU   147      13.416 -10.726   3.530  1.00 38.87           N
ATOM   1073  CA  LEU   147      14.839 -10.839   3.243  1.00 39.04           C
ATOM   1074  CB  LEU   147      15.611  -9.696   3.896  1.00 39.26           C
ATOM   1075  CG  LEU   147      16.114  -8.513   3.075  1.00 40.03           C
ATOM   1076  CD1 LEU   147      17.281  -7.917   3.817  1.00 40.42           C
ATOM   1077  CD2 LEU   147      16.562  -8.928   1.676  1.00 41.79           C
ATOM   1078  C   LEU   147      15.423 -12.179   3.699  1.00 38.92           C
ATOM   1079  O   LEU   147      15.436 -12.488   4.890  1.00 38.67           O
ATOM   1080  N   LYS   148      15.895 -12.964   2.731  1.00 38.75           N
ATOM   1081  CA  LYS   148      16.563 -14.242   2.986  1.00 38.66           C
ATOM   1082  CB  LYS   148      15.556 -15.409   3.007  1.00 38.38           C
ATOM   1083  CG  LYS   148      14.406 -15.315   1.997  1.00 39.21           C
ATOM   1084  CD  LYS   148      13.594 -16.612   1.912  1.00 39.48           C
ATOM   1085  CE  LYS   148      12.572 -16.753   3.040  1.00 42.02           C
ATOM   1086  NZ  LYS   148      11.274 -16.044   2.773  1.00 43.81           N
ATOM   1087  C   LYS   148      17.673 -14.460   1.948  1.00 38.28           C
ATOM   1088  O   LYS   148      17.683 -13.787   0.911  1.00 38.13           O
ATOM   1089  N   PRO   149      18.622 -15.383   2.224  1.00 38.05           N
ATOM   1090  CA  PRO   149      19.702 -15.637   1.271  1.00 38.02           C
ATOM   1091  CB  PRO   149      20.534 -16.729   1.957  1.00 38.16           C
ATOM   1092  CG  PRO   149      20.180 -16.641   3.403  1.00 37.85           C
ATOM   1093  CD  PRO   149      18.750 -16.229   3.426  1.00 38.04           C
ATOM   1094  C   PRO   149      19.183 -16.121  -0.085  1.00 38.07           C
ATOM   1095  O   PRO   149      19.845 -15.902  -1.105  1.00 37.99           O
ATOM   1096  N   GLU   150      18.003 -16.751  -0.090  1.00 37.92           N
ATOM   1097  CA  GLU   150      17.317 -17.161  -1.325  1.00 37.89           C
ATOM   1098  CB  GLU   150      16.091 -18.028  -1.014  1.00 38.04           C
ATOM   1099  CG  GLU   150      16.400 -19.395  -0.411  1.00 38.38           C
ATOM   1100  CD  GLU   150      16.369 -19.405   1.111  1.00 38.74           C
ATOM   1101  OE1 GLU   150      16.829 -18.432   1.749  1.00 38.30           O
ATOM   1102  OE2 GLU   150      15.879 -20.407   1.675  1.00 39.93           O
ATOM   1103  C   GLU   150      16.884 -15.965  -2.175  1.00 37.77           C
ATOM   1104  O   GLU   150      16.699 -16.095  -3.387  1.00 37.60           O
ATOM   1105  N   ASN   151      16.722 -14.811  -1.529  1.00 37.70           N
ATOM   1106  CA  ASN   151      16.319 -13.569  -2.198  1.00 38.03           C
ATOM   1107  CB  ASN   151      15.286 -12.821  -1.346  1.00 38.05           C
ATOM   1108  CG  ASN   151      13.906 -13.430  -1.434  1.00 38.59           C
ATOM   1109  OD1 ASN   151      13.578 -14.124  -2.396  1.00 39.49           O
ATOM   1110  ND2 ASN   151      13.078 -13.158  -0.434  1.00 38.97           N
ATOM   1111  C   ASN   151      17.487 -12.632  -2.539  1.00 38.09           C
ATOM   1112  O   ASN   151      17.280 -11.470  -2.900  1.00 37.79           O
ATOM   1113  N   ILE   152      18.709 -13.139  -2.407  1.00 38.47           N
ATOM   1114  CA  ILE   152      19.906 -12.383  -2.757  1.00 38.76           C
ATOM   1115  CB  ILE   152      20.795 -12.092  -1.527  1.00 38.70           C
ATOM   1116  CG1 ILE   152      19.985 -11.371  -0.440  1.00 38.20           C
ATOM   1117  CD1 ILE   152      20.587 -11.437   0.941  1.00 37.23           C
ATOM   1118  CG2 ILE   152      22.017 -11.262  -1.942  1.00 38.69           C
ATOM   1119  C   ILE   152      20.691 -13.170  -3.788  1.00 39.20           C
ATOM   1120  O   ILE   152      21.098 -14.307  -3.530  1.00 39.32           O
ATOM   1121  N   LEU   153      20.901 -12.563  -4.952  1.00 39.70           N
ATOM   1122  CA  LEU   153      21.590 -13.234  -6.046  1.00 40.26           C
ATOM   1123  CB  LEU   153      20.797 -13.083  -7.347  1.00 40.20           C
ATOM   1124  CG  LEU   153      19.712 -14.133  -7.623  1.00 40.26           C
ATOM   1125  CD1 LEU   153      18.552 -14.062  -6.629  1.00 40.60           C
ATOM   1126  CD2 LEU   153      19.196 -13.984  -9.039  1.00 40.44           C
ATOM   1127  C   LEU   153      23.041 -12.777  -6.220  1.00 40.67           C
ATOM   1128  O   LEU   153      23.398 -11.658  -5.838  1.00 40.83           O
ATOM   1129  N   LEU   154      23.862 -13.665  -6.786  1.00 41.11           N
ATOM   1130  CA  LEU   154      25.279 -13.408  -7.061  1.00 41.29           C
ATOM   1131  CB  LEU   154      26.182 -14.322  -6.219  1.00 41.31           C
ATOM   1132  CG  LEU   154      26.104 -14.399  -4.691  1.00 41.80           C
ATOM   1133  CD1 LEU   154      27.351 -15.101  -4.184  1.00 42.11           C
ATOM   1134  CD2 LEU   154      25.977 -13.029  -4.035  1.00 42.39           C
ATOM   1135  C   LEU   154      25.580 -13.627  -8.543  1.00 41.48           C
ATOM   1136  O   LEU   154      26.740 -13.769  -8.951  1.00 41.64           O
ATOM   1137  N   LYS   159      30.107 -16.087 -11.893  1.00 38.12           N
ATOM   1138  CA  LYS   159      29.925 -15.137 -10.800  1.00 38.20           C
ATOM   1139  CB  LYS   159      29.233 -15.814  -9.612  1.00 38.23           C
ATOM   1144  C   LYS   159      31.255 -14.514 -10.365  1.00 38.16           C
ATOM   1145  O   LYS   159      32.324 -15.073 -10.615  1.00 38.04           O
ATOM   1146  N   ASP   160      31.175 -13.352  -9.715  1.00 38.22           N
ATOM   1147  CA  ASP   160      32.366 -12.636  -9.253  1.00 38.15           C
ATOM   1148  CB  ASP   160      32.810 -11.594 -10.292  1.00 38.13           C
ATOM   1149  CG  ASP   160      34.142 -10.954  -9.948  1.00 38.28           C
ATOM   1150  OD1 ASP   160      34.182 -10.136  -9.004  1.00 38.23           O
ATOM   1151  OD2 ASP   160      35.146 -11.259 -10.630  1.00 38.14           O
ATOM   1152  C   ASP   160      32.213 -12.013  -7.849  1.00 38.09           C
ATOM   1153  O   ASP   160      32.832 -12.500  -6.900  1.00 38.29           O
ATOM   1154  N   CYS   161      31.402 -10.955  -7.720  1.00 37.75           N
ATOM   1155  CA  CYS   161      31.299 -10.194  -6.458  1.00 37.35           C
ATOM   1156  CB  CYS   161      32.422  -9.143  -6.362  1.00 37.35           C
ATOM   1157  SG  CYS   161      34.038  -9.730  -5.757  0.50 37.23           S
ATOM   1158  C   CYS   161      29.950  -9.499  -6.203  1.00 37.18           C
ATOM   1159  O   CYS   161      29.635  -9.185  -5.053  1.00 36.88           O
ATOM   1160  N   ASP   162      29.171  -9.264  -7.263  1.00 36.97           N
ATOM   1161  CA  ASP   162      27.985  -8.391  -7.207  1.00 36.80           C
ATOM   1162  CB  ASP   162      27.684  -7.809  -8.592  1.00 36.90           C
ATOM   1163  CG  ASP   162      28.818  -6.968  -9.137  1.00 37.34           C
ATOM   1164  OD1 ASP   162      29.017  -6.988 -10.371  1.00 37.88           O
ATOM   1165  OD2 ASP   162      29.510  -6.288  -8.345  1.00 37.33           O
ATOM   1166  C   ASP   162      26.724  -9.068  -6.679  1.00 36.66           C
ATOM   1167  O   ASP   162      26.345 -10.136  -7.159  1.00 36.97           O
ATOM   1168  N   ILE   163      26.064  -8.428  -5.711  1.00 36.22           N
ATOM   1169  CA  ILE   163      24.827  -8.952  -5.126  1.00 35.77           C
ATOM   1170  CB  ILE   163      24.908  -9.026  -3.583  1.00 35.74           C
ATOM   1174  C   ILE   163      23.616  -8.109  -5.521  1.00 35.51           C
ATOM   1175  O   ILE   163      23.707  -6.884  -5.608  1.00 35.54           O
ATOM   1176  N   LYS   164      22.484  -8.765  -5.761  1.00 35.04           N
ATOM   1177  CA  LYS   164      21.239  -8.055  -6.061  1.00 34.70           C
ATOM   1178  CB  LYS   164      20.983  -8.015  -7.576  1.00 34.79           C
ATOM   1179  CG  LYS   164      21.775  -6.920  -8.301  1.00 34.67           C
ATOM   1180  CD  LYS   164      21.802  -7.114  -9.808  1.00 34.72           C
ATOM   1183  C   LYS   164      20.057  -8.665  -5.316  1.00 34.38           C
ATOM   1184  O   LYS   164      19.853  -9.878  -5.356  1.00 34.43           O
ATOM   1185  N   ILE   165      19.298  -7.821  -4.621  1.00 34.12           N
ATOM   1186  CA  ILE   165      18.123  -8.263  -3.865  1.00 33.72           C
ATOM   1187  CB  ILE   165      17.842  -7.366  -2.638  1.00 33.72           C
ATOM   1188  CG1 ILE   165      19.109  -7.162  -1.799  1.00 33.32           C
ATOM   1189  CD1 ILE   165      18.971  -6.104  -0.728  1.00 33.19           C
ATOM   1190  CG2 ILE   165      16.701  -7.954  -1.800  1.00 33.22           C
ATOM   1191  C   ILE   165      16.882  -8.269  -4.752  1.00 33.98           C
ATOM   1192  O   ILE   165      16.545  -7.245  -5.354  1.00 33.96           O
ATOM   1193  N   ILE   166      16.203  -9.417  -4.817  1.00 34.12           N
ATOM   1194  CA  ILE   166      15.036  -9.587  -5.696  1.00 34.31           C
ATOM   1195  CB  ILE   166      15.028 -10.961  -6.431  1.00 34.24           C
ATOM   1196  CG1 ILE   166      14.757 -12.116  -5.456  1.00 34.23           C
ATOM   1197  CD1 ILE   166      14.203 -13.367  -6.124  1.00 34.30           C
ATOM   1198  CG2 ILE   166      16.325 -11.164  -7.212  1.00 34.38           C
ATOM   1199  C   ILE   166      13.697  -9.376  -4.991  1.00 34.54           C
ATOM   1200  O   ILE   166      13.611  -9.437  -3.758  1.00 34.52           O
ATOM   1201  N   ASP   167      12.666  -9.119  -5.799  1.00 34.74           N
ATOM   1202  CA  ASP   167      11.280  -8.975  -5.340  1.00 34.80           C
ATOM   1203  CB  ASP   167      10.724 -10.330  -4.888  1.00 34.87           C
ATOM   1204  CG  ASP   167      10.837 -11.388  -5.958  1.00 35.57           C
ATOM   1205  OD1 ASP   167      10.837 -12.588  -5.610  1.00 36.86           O
ATOM   1206  OD2 ASP   167      10.939 -11.020  -7.148  1.00 36.39           O
ATOM   1207  C   ASP   167      11.089  -7.933  -4.241  1.00 34.56           C
ATOM   1208  O   ASP   167      10.157  -8.036  -3.432  1.00 34.55           O
ATOM   1209  N   PHE   168      11.959  -6.927  -4.221  1.00 34.33           N
ATOM   1210  CA  PHE   168      11.928  -5.919  -3.161  1.00 34.15           C
ATOM   1211  CB  PHE   168      13.165  -5.009  -3.203  1.00 33.90           C
ATOM   1212  CG  PHE   168      13.570  -4.474  -1.851  1.00 33.72           C
ATOM   1213  CD1 PHE   168      12.705  -3.668  -1.112  1.00 33.22           C
ATOM   1214  CE1 PHE   168      13.077  -3.177   0.142  1.00 33.30           C
ATOM   1215  CZ  PHE   168      14.326  -3.493   0.664  1.00 33.77           C
ATOM   1216  CE2 PHE   168      15.197  -4.300  -0.065  1.00 33.06           C
ATOM   1217  CD2 PHE   168      14.814  -4.785  -1.314  1.00 33.34           C
ATOM   1218  C   PHE   168      10.642  -5.097  -3.211  1.00 34.08           C
ATOM   1219  O   PHE   168      10.421  -4.327  -4.142  1.00 33.93           O
ATOM   1220  N   GLY   169       9.797  -5.292  -2.203  1.00 34.33           N
ATOM   1221  CA  GLY   169       8.536  -4.565  -2.084  1.00 34.49           C
ATOM   1222  C   GLY   169       7.308  -5.308  -2.575  1.00 34.63           C
ATOM   1223  O   GLY   169       6.182  -4.831  -2.395  1.00 34.62           O
ATOM   1224  N   LEU   170       7.515  -6.469  -3.196  1.00 34.82           N
ATOM   1225  CA  LEU   170       6.414  -7.233  -3.788  1.00 35.04           C
ATOM   1226  CB  LEU   170       6.936  -8.273  -4.788  1.00 35.13           C
ATOM   1227  CG  LEU   170       7.441  -7.840  -6.172  1.00 35.16           C
ATOM   1228  CD1 LEU   170       7.729  -9.063  -7.011  1.00 34.43           C
ATOM   1229  CD2 LEU   170       6.445  -6.935  -6.900  1.00 35.71           C
ATOM   1230  C   LEU   170       5.489  -7.905  -2.767  1.00 35.19           C
ATOM   1231  O   LEU   170       4.301  -8.100  -3.043  1.00 35.21           O
ATOM   1232  N   SER   171       6.029  -8.245  -1.596  1.00 35.45           N
ATOM   1233  CA  SER   171       5.276  -8.954  -0.552  1.00 35.77           C
ATOM   1234  CB  SER   171       6.199  -9.368   0.588  1.00 35.75           C
ATOM   1235  OG  SER   171       6.638  -8.217   1.287  1.00 37.47           O
ATOM   1236  C   SER   171       4.077  -8.182   0.019  1.00 35.71           C
ATOM   1237  O   SER   171       3.174  -8.791   0.594  1.00 35.82           O
ATOM   1238  N   THR   172       4.063  -6.855  -0.123  1.00 35.52           N
ATOM   1239  CA  THR   172       2.884  -6.086   0.291  1.00 35.69           C
ATOM   1240  CB  THR   172       3.191  -4.598   0.649  1.00 35.74           C
ATOM   1241  OG1 THR   172       3.613  -3.881  -0.520  1.00 36.13           O
ATOM   1242  CG2 THR   172       4.261  -4.499   1.736  1.00 35.49           C
ATOM   1243  C   THR   172       1.772  -6.171  -0.760  1.00 35.73           C
ATOM   1244  O   THR   172       0.592  -6.016  -0.435  1.00 36.05           O
ATOM   1245  N   CYS   173       2.154  -6.437  -2.008  1.00 35.48           N
ATOM   1246  CA  CYS   173       1.199  -6.563  -3.104  1.00 35.45           C
ATOM   1247  CB  CYS   173       1.844  -6.146  -4.425  1.00 35.58           C
ATOM   1248  SG  CYS   173       2.446  -4.452  -4.468  1.00 35.57           S
ATOM   1249  C   CYS   173       0.647  -7.973  -3.250  1.00 35.34           C
ATOM   1250  O   CYS   173      -0.538  -8.154  -3.526  1.00 35.43           O
ATOM   1251  N   PHE   174       1.513  -8.967  -3.070  1.00 35.34           N
ATOM   1252  CA  PHE   174       1.174 -10.349  -3.379  1.00 35.18           C
ATOM   1253  CB  PHE   174       1.861 -10.779  -4.675  1.00 34.71           C
ATOM   1254  CG  PHE   174       1.563  -9.888  -5.850  1.00 34.28           C
ATOM   1255  CD1 PHE   174       0.312  -9.916  -6.466  1.00 34.11           C
ATOM   1256  CE1 PHE   174       0.037  -9.088  -7.557  1.00 33.46           C
ATOM   1257  CZ  PHE   174       1.018  -8.227  -8.040  1.00 33.32           C
ATOM   1258  CE2 PHE   174       2.265  -8.194  -7.433  1.00 32.69           C
ATOM   1259  CD2 PHE   174       2.533  -9.023  -6.346  1.00 32.90           C
ATOM   1260  C   PHE   174       1.512 -11.327  -2.256  1.00 35.54           C
ATOM   1261  O   PHE   174       2.541 -11.204  -1.589  1.00 35.49           O
ATOM   1262  N   GLN   175       0.623 -12.297  -2.073  1.00 36.06           N
ATOM   1263  CA  GLN   175       0.786 -13.374  -1.107  1.00 36.86           C
ATOM   1264  CB  GLN   175      -0.584 -13.981  -0.780  1.00 37.09           C
ATOM   1265  CG  GLN   175      -0.635 -14.741   0.536  1.00 38.88           C
ATOM   1266  CD  GLN   175      -0.791 -13.820   1.735  1.00 40.93           C
ATOM   1267  OE1 GLN   175       0.191 -13.488   2.413  1.00 41.26           O
ATOM   1268  NE2 GLN   175      -2.030 -13.389   1.995  1.00 41.04           N
ATOM   1269  C   GLN   175       1.719 -14.460  -1.655  1.00 36.95           C
ATOM   1270  O   GLN   175       1.607 -14.858  -2.817  1.00 36.84           O
ATOM   1271  N   GLN   176       2.630 -14.937  -0.810  1.00 37.34           N
ATOM   1272  CA  GLN   176       3.631 -15.934  -1.206  1.00 37.90           C
ATOM   1273  CB  GLN   176       4.929 -15.716  -0.426  1.00 37.96           C
ATOM   1274  CG  GLN   176       5.533 -14.347  -0.613  1.00 39.55           C
ATOM   1275  CD  GLN   176       6.461 -13.969   0.514  1.00 41.39           C
ATOM   1276  OE1 GLN   176       7.436 -14.672   0.798  1.00 42.73           O
ATOM   1277  NE2 GLN   176       6.167 -12.849   1.168  1.00 41.94           N
ATOM   1278  C   GLN   176       3.156 -17.370  -0.991  1.00 37.88           C
ATOM   1279  O   GLN   176       2.075 -17.599  -0.446  1.00 37.91           O
ATOM   1280  N   ASN   177       3.972 -18.328  -1.432  1.00 38.05           N
ATOM   1281  CA  ASN   177       3.774 -19.738  -1.100  1.00 38.30           C
ATOM   1282  CB  ASN   177       4.692 -20.640  -1.938  1.00 38.37           C
ATOM   1283  CG  ASN   177       4.340 -20.641  -3.424  1.00 38.40           C
ATOM   1284  OD1 ASN   177       3.218 -20.318  -3.820  1.00 38.55           O
ATOM   1285  ND2 ASN   177       5.308 -21.019  -4.252  1.00 38.16           N
ATOM   1286  C   ASN   177       4.043 -19.960   0.386  1.00 38.27           C
ATOM   1287  O   ASN   177       4.979 -19.383   0.949  1.00 38.31           O
ATOM   1288  N   THR   178       3.214 -20.787   1.017  1.00 38.31           N
ATOM   1289  CA  THR   178       3.335 -21.063   2.450  1.00 38.29           C
ATOM   1290  CB  THR   178       2.262 -20.299   3.272  1.00 38.36           C
ATOM   1291  OG1 THR   178       0.981 -20.442   2.644  1.00 37.83           O
ATOM   1292  CG2 THR   178       2.608 -18.816   3.384  1.00 38.27           C
ATOM   1293  C   THR   178       3.282 -22.562   2.778  1.00 38.35           C
ATOM   1294  O   THR   178       2.639 -22.973   3.747  1.00 38.25           O
ATOM   1295  N   LYS   179       3.965 -23.372   1.969  1.00 38.47           N
ATOM   1296  CA  LYS   179       4.131 -24.797   2.262  1.00 38.63           C
ATOM   1297  CB  LYS   179       4.611 -25.569   1.023  1.00 38.63           C
ATOM   1298  CG  LYS   179       3.685 -25.507  -0.200  1.00 38.96           C
ATOM   1299  CD  LYS   179       2.469 -26.438  -0.094  1.00 39.55           C
ATOM   1300  CE  LYS   179       2.773 -27.872  -0.544  1.00 39.79           C
ATOM   1301  NZ  LYS   179       3.418 -28.702   0.519  1.00 39.98           N
ATOM   1302  C   LYS   179       5.136 -24.946   3.405  1.00 38.75           C
ATOM   1303  O   LYS   179       5.796 -23.973   3.780  1.00 38.59           O
ATOM   1304  N   MET   180       5.250 -26.156   3.955  1.00 38.84           N
ATOM   1305  CA  MET   180       6.173 -26.425   5.059  1.00 38.95           C
ATOM   1306  CB  MET   180       6.262 -27.929   5.344  1.00 39.03           C
ATOM   1310  C   MET   180       7.563 -25.852   4.786  1.00 39.06           C
ATOM   1311  O   MET   180       8.142 -25.180   5.641  1.00 39.05           O
ATOM   1312  N   LYS   181       8.073 -26.105   3.582  1.00 39.14           N
ATOM   1313  CA  LYS   181       9.388 -25.628   3.153  1.00 39.16           C
ATOM   1314  CB  LYS   181       9.698 -26.162   1.750  1.00 39.22           C
ATOM   1315  CG  LYS   181      11.100 -25.853   1.233  1.00 39.32           C
ATOM   1316  CD  LYS   181      11.249 -26.210  -0.249  1.00 39.38           C
ATOM   1317  CE  LYS   181      10.400 -25.316  -1.159  1.00 39.68           C
ATOM   1318  NZ  LYS   181      10.813 -23.876  -1.134  1.00 39.91           N
ATOM   1319  C   LYS   181       9.498 -24.097   3.190  1.00 39.08           C
ATOM   1320  O   LYS   181      10.511 -23.552   3.641  1.00 39.00           O
ATOM   1321  N   ASP   182       8.452 -23.416   2.718  1.00 38.99           N
ATOM   1322  CA  ASP   182       8.389 -21.950   2.725  1.00 38.81           C
ATOM   1323  CB  ASP   182       7.118 -21.455   2.026  1.00 38.89           C
ATOM   1324  CG  ASP   182       7.026 -21.899   0.580  1.00 39.26           C
ATOM   1325  OD1 ASP   182       6.147 -22.737   0.273  1.00 39.26           O
ATOM   1326  OD2 ASP   182       7.824 -21.407  -0.247  1.00 39.73           O
ATOM   1327  C   ASP   182       8.411 -21.389   4.144  1.00 38.69           C
ATOM   1328  O   ASP   182       9.150 -20.437   4.436  1.00 38.60           O
ATOM   1329  N   ARG   183       7.595 -21.990   5.012  1.00 38.43           N
ATOM   1330  CA  ARG   183       7.393 -21.509   6.378  1.00 38.36           C
ATOM   1331  CB  ARG   183       6.173 -22.186   7.026  1.00 38.34           C
ATOM   1332  CG  ARG   183       4.839 -21.848   6.348  1.00 38.39           C
ATOM   1333  CD  ARG   183       3.694 -21.754   7.354  1.00 38.41           C
ATOM   1334  NE  ARG   183       3.094 -23.049   7.680  1.00 38.67           N
ATOM   1335  CZ  ARG   183       1.829 -23.379   7.422  1.00 39.68           C
ATOM   1336  NH1 ARG   183       1.012 -22.514   6.829  1.00 39.89           N
ATOM   1337  NH2 ARG   183       1.370 -24.578   7.761  1.00 39.79           N
ATOM   1338  C   ARG   183       8.639 -21.635   7.267  1.00 38.33           C
ATOM   1339  O   ARG   183       8.947 -20.713   8.021  1.00 38.18           O
ATOM   1340  N   ILE   184       9.344 -22.765   7.175  1.00 38.35           N
ATOM   1341  CA  ILE   184      10.594 -22.965   7.919  1.00 38.51           C
ATOM   1342  CB  ILE   184      11.162 -24.414   7.762  1.00 38.50           C
ATOM   1343  CG1 ILE   184      10.196 -25.457   8.335  1.00 38.68           C
ATOM   1345  CG2 ILE   184      12.500 -24.565   8.475  1.00 38.39           C
ATOM   1346  C   ILE   184      11.642 -21.919   7.502  1.00 38.64           C
ATOM   1347  O   ILE   184      12.329 -21.346   8.353  1.00 38.57           O
ATOM   1348  N   GLY   185      11.741 -21.665   6.197  1.00 38.67           N
ATOM   1349  CA  GLY   185      12.692 -20.695   5.659  1.00 38.79           C
ATOM   1350  C   GLY   185      12.403 -19.286   6.136  1.00 38.98           C
ATOM   1351  O   GLY   185      13.311 -18.556   6.524  1.00 39.10           O
ATOM   1352  N   THR   186      11.128 -18.912   6.104  1.00 39.16           N
ATOM   1353  CA  THR   186      10.660 -17.630   6.615  1.00 39.20           C
ATOM   1354  CB  THR   186       9.143 -17.451   6.317  1.00 39.34           C
ATOM   1355  OG1 THR   186       8.951 -17.312   4.904  1.00 39.99           O
ATOM   1356  CG2 THR   186       8.564 -16.223   7.010  1.00 39.73           C
ATOM   1357  C   THR   186      10.948 -17.491   8.116  1.00 38.96           C
ATOM   1358  O   THR   186      11.318 -16.411   8.582  1.00 39.21           O
ATOM   1359  N   ALA   187      10.805 -18.595   8.850  1.00 38.56           N
ATOM   1360  CA  ALA   187      10.900 -18.608  10.314  1.00 38.22           C
ATOM   1361  CB  ALA   187      10.521 -19.974  10.854  1.00 37.99           C
ATOM   1362  C   ALA   187      12.253 -18.166  10.877  1.00 38.12           C
ATOM   1363  O   ALA   187      12.298 -17.484  11.900  1.00 38.04           O
ATOM   1364  N   TYR   188      13.341 -18.550  10.209  1.00 38.01           N
ATOM   1365  CA  TYR   188      14.696 -18.176  10.632  1.00 37.85           C
ATOM   1366  CB  TYR   188      15.751 -18.811   9.721  1.00 37.48           C
ATOM   1367  CG  TYR   188      15.918 -20.306   9.862  1.00 37.38           C
ATOM   1368  CD1 TYR   188      15.657 -21.159   8.788  1.00 36.60           C
ATOM   1369  CE1 TYR   188      15.816 -22.536   8.905  1.00 36.75           C
ATOM   1370  CZ  TYR   188      16.244 -23.079  10.107  1.00 37.09           C
ATOM   1371  OH  TYR   188      16.399 -24.441  10.225  1.00 37.16           O
ATOM   1372  CE2 TYR   188      16.516 -22.258  11.191  1.00 37.20           C
ATOM   1373  CD2 TYR   188      16.357 -20.874  11.063  1.00 37.59           C
ATOM   1374  C   TYR   188      14.934 -16.664  10.664  1.00 37.94           C
ATOM   1375  O   TYR   188      15.634 -16.165  11.544  1.00 38.22           O
ATOM   1376  N   TYR   189      14.341 -15.943   9.714  1.00 37.90           N
ATOM   1377  CA  TYR   189      14.725 -14.554   9.442  1.00 37.75           C
ATOM   1378  CB  TYR   189      15.012 -14.377   7.942  1.00 37.83           C
ATOM   1379  CG  TYR   189      15.978 -15.403   7.401  1.00 38.55           C
ATOM   1380  CD1 TYR   189      17.361 -15.208   7.488  1.00 38.58           C
ATOM   1381  CE1 TYR   189      18.252 -16.161   7.002  1.00 38.67           C
ATOM   1382  CZ  TYR   189      17.760 -17.326   6.420  1.00 38.87           C
ATOM   1383  OH  TYR   189      18.633 -18.277   5.933  1.00 39.29           O
ATOM   1384  CE2 TYR   189      16.396 -17.544   6.325  1.00 38.57           C
ATOM   1385  CD2 TYR   189      15.514 -16.583   6.813  1.00 38.67           C
ATOM   1386  C   TYR   189      13.712 -13.511   9.918  1.00 37.50           C
ATOM   1387  O   TYR   189      14.003 -12.306   9.918  1.00 37.64           O
ATOM   1388  N   ILE   190      12.533 -13.971  10.323  1.00 37.02           N
ATOM   1389  CA  ILE   190      11.438 -13.075  10.691  1.00 36.88           C
ATOM   1390  CB  ILE   190      10.067 -13.819  10.680  1.00 36.67           C
ATOM   1391  CG1 ILE   190       8.903 -12.839  10.817  1.00 36.08           C
ATOM   1392  CD1 ILE   190       7.590 -13.391  10.272  1.00 35.62           C
ATOM   1393  CG2 ILE   190      10.009 -14.933  11.735  1.00 36.63           C
ATOM   1394  C   ILE   190      11.708 -12.361  12.019  1.00 37.11           C
ATOM   1395  O   ILE   190      12.157 -12.982  12.983  1.00 37.09           O
ATOM   1396  N   ALA   191      11.458 -11.052  12.043  1.00 37.29           N
ATOM   1397  CA  ALA   191      11.612 -10.233  13.249  1.00 37.76           C
ATOM   1398  CB  ALA   191      11.666  -8.750  12.883  1.00 37.44           C
ATOM   1399  C   ALA   191      10.484 -10.494  14.243  1.00 38.09           C
ATOM   1400  O   ALA   191       9.365 -10.810  13.835  1.00 38.61           O
ATOM   1401  N   PRO   192      10.761 -10.339  15.553  1.00 38.50           N
ATOM   1402  CA  PRO   192       9.735 -10.586  16.573  1.00 38.60           C
ATOM   1403  CB  PRO   192      10.441 -10.223  17.886  1.00 38.52           C
ATOM   1404  CG  PRO   192      11.892 -10.355  17.591  1.00 38.67           C
ATOM   1405  CD  PRO   192      12.044  -9.932  16.158  1.00 38.56           C
ATOM   1406  C   PRO   192       8.454  -9.758  16.393  1.00 38.87           C
ATOM   1407  O   PRO   192       7.364 -10.290  16.607  1.00 39.53           O
ATOM   1408  N   GLU   193       8.573  -8.489  15.995  1.00 39.06           N
ATOM   1409  CA  GLU   193       7.399  -7.617  15.799  1.00 39.15           C
ATOM   1410  CB  GLU   193       7.768  -6.196  15.349  1.00 39.40           C
ATOM   1411  CG  GLU   193       9.014  -5.606  15.910  1.00 40.73           C
ATOM   1412  CD  GLU   193      10.248  -5.958  15.106  1.00 41.29           C
ATOM   1413  OE1 GLU   193      11.119  -6.630  15.676  1.00 41.60           O
ATOM   1414  OE2 GLU   193      10.351  -5.569  13.921  1.00 42.28           O
ATOM   1415  C   GLU   193       6.483  -8.160  14.730  1.00 38.99           C
ATOM   1416  O   GLU   193       5.266  -8.009  14.826  1.00 39.34           O
ATOM   1417  N   VAL   194       7.076  -8.742  13.688  1.00 38.93           N
ATOM   1418  CA  VAL   194       6.317  -9.243  12.543  1.00 38.97           C
ATOM   1419  CB  VAL   194       7.230  -9.658  11.361  1.00 38.93           C
ATOM   1420  CG1 VAL   194       6.407 -10.114  10.161  1.00 38.01           C
ATOM   1421  CG2 VAL   194       8.112  -8.499  10.951  1.00 39.04           C
ATOM   1422  C   VAL   194       5.391 -10.372  12.984  1.00 39.06           C
ATOM   1423  O   VAL   194       4.275 -10.478  12.490  1.00 39.13           O
ATOM   1424  N   LEU   195       5.848 -11.182  13.940  1.00 39.54           N
ATOM   1425  CA  LEU   195       5.001 -12.204  14.569  1.00 39.81           C
ATOM   1426  CB  LEU   195       5.820 -13.148  15.449  1.00 39.85           C
ATOM   1427  CG  LEU   195       6.984 -13.902  14.803  1.00 40.14           C
ATOM   1428  CD1 LEU   195       7.819 -14.597  15.871  1.00 39.60           C
ATOM   1429  CD2 LEU   195       6.480 -14.898  13.758  1.00 40.10           C
ATOM   1430  C   LEU   195       3.896 -11.570  15.396  1.00 40.01           C
ATOM   1431  O   LEU   195       2.747 -11.994  15.311  1.00 40.62           O
ATOM   1432  N   ARG   196       4.239 -10.551  16.187  1.00 40.17           N
ATOM   1433  CA  ARG   196       3.248  -9.844  17.020  1.00 40.09           C
ATOM   1434  CB  ARG   196       3.927  -8.933  18.055  1.00 40.28           C
ATOM   1435  CG  ARG   196       4.812  -9.650  19.082  1.00 40.42           C
ATOM   1436  CD  ARG   196       5.222  -8.721  20.235  1.00 40.22           C
ATOM   1437  NE  ARG   196       5.908  -7.507  19.783  0.50 40.39           N
ATOM   1438  CZ  ARG   196       7.229  -7.335  19.773  0.50 40.68           C
ATOM   1439  NH1 ARG   196       8.044  -8.298  20.191  0.50 40.57           N
ATOM   1440  NH2 ARG   196       7.741  -6.188  19.342  0.50 40.87           N
ATOM   1441  C   ARG   196       2.228  -9.043  16.194  1.00 39.80           C
ATOM   1442  O   ARG   196       1.225  -8.565  16.731  1.00 39.73           O
ATOM   1443  N   GLY   197       2.492  -8.888  14.896  1.00 39.59           N
ATOM   1444  CA  GLY   197       1.502  -8.318  13.971  1.00 38.99           C
ATOM   1445  C   GLY   197       1.788  -6.938  13.398  1.00 38.83           C
ATOM   1446  O   GLY   197       0.897  -6.308  12.819  1.00 38.70           O
ATOM   1447  N   THR   198       3.017  -6.453  13.558  1.00 38.52           N
ATOM   1448  CA  THR   198       3.406  -5.169  12.975  1.00 38.47           C
ATOM   1449  CB  THR   198       3.360  -3.979  13.986  1.00 38.47           C
ATOM   1450  OG1 THR   198       4.479  -4.052  14.877  1.00 39.33           O
ATOM   1451  CG2 THR   198       2.055  -3.949  14.787  1.00 38.74           C
ATOM   1452  C   THR   198       4.805  -5.254  12.387  1.00 38.23           C
ATOM   1453  O   THR   198       5.608  -6.104  12.777  1.00 38.18           O
ATOM   1454  N   TYR   199       5.080  -4.364  11.443  1.00 37.74           N
ATOM   1455  CA  TYR   199       6.381  -4.265  10.814  1.00 37.25           C
ATOM   1456  CB  TYR   199       6.467  -5.198   9.596  1.00 36.96           C
ATOM   1457  CG  TYR   199       5.760  -4.689   8.342  1.00 36.09           C
ATOM   1458  CD1 TYR   199       4.441  -5.042   8.068  1.00 35.65           C
ATOM   1459  CE1 TYR   199       3.795  -4.577   6.927  1.00 36.00           C
ATOM   1460  CZ  TYR   199       4.479  -3.751   6.041  1.00 36.12           C
ATOM   1461  OH  TYR   199       3.858  -3.287   4.903  1.00 35.49           O
ATOM   1462  CE2 TYR   199       5.792  -3.390   6.296  1.00 35.39           C
ATOM   1463  CD2 TYR   199       6.420  -3.858   7.434  1.00 35.67           C
ATOM   1464  C   TYR   199       6.609  -2.822  10.392  1.00 37.31           C
ATOM   1465  O   TYR   199       5.659  -2.077  10.154  1.00 37.34           O
ATOM   1466  N   ASP   200       7.875  -2.437  10.326  1.00 37.58           N
ATOM   1467  CA  ASP   200       8.303  -1.216   9.660  1.00 37.84           C
ATOM   1468  CB  ASP   200       8.379  -0.026  10.642  1.00 37.99           C
ATOM   1469  CG  ASP   200       9.367  -0.250  11.791  1.00 38.44           C
ATOM   1470  OD1 ASP   200      10.121  -1.243  11.773  1.00 39.06           O
ATOM   1471  OD2 ASP   200       9.389   0.581  12.720  1.00 38.97           O
ATOM   1472  C   ASP   200       9.643  -1.551   9.003  1.00 37.79           C
ATOM   1473  O   ASP   200       9.937  -2.725   8.796  1.00 37.94           O
ATOM   1474  N   GLU   201      10.452  -0.544   8.685  1.00 37.98           N
ATOM   1475  CA  GLU   201      11.746  -0.763   8.029  1.00 38.11           C
ATOM   1476  CB  GLU   201      12.453   0.568   7.745  1.00 37.92           C
ATOM   1477  CG  GLU   201      11.551   1.782   7.736  1.00 39.38           C
ATOM   1478  CD  GLU   201      11.419   2.415   9.105  1.00 40.05           C
ATOM   1479  OE1 GLU   201      12.459   2.786   9.695  1.00 40.01           O
ATOM   1480  OE2 GLU   201      10.275   2.549   9.581  1.00 39.78           O
ATOM   1481  C   GLU   201      12.681  -1.649   8.858  1.00 37.99           C
ATOM   1482  O   GLU   201      13.502  -2.385   8.308  1.00 38.38           O
ATOM   1483  N   LYS   202      12.551  -1.569  10.179  1.00 37.92           N
ATOM   1484  CA  LYS   202      13.461  -2.245  11.100  1.00 37.83           C
ATOM   1485  CB  LYS   202      13.204  -1.789  12.544  1.00 37.68           C
ATOM   1486  CG  LYS   202      13.509  -0.308  12.816  1.00 37.08           C
ATOM   1487  CD  LYS   202      15.016  -0.031  12.840  1.00 36.55           C
ATOM   1488  CE  LYS   202      15.312   1.456  12.917  1.00 35.99           C
ATOM   1489  NZ  LYS   202      15.267   1.965  14.309  1.00 35.74           N
ATOM   1490  C   LYS   202      13.438  -3.772  11.001  1.00 38.01           C
ATOM   1491  O   LYS   202      14.342  -4.437  11.502  1.00 38.58           O
ATOM   1492  N   CYS   203      12.420  -4.335  10.356  1.00 38.11           N
ATOM   1493  CA  CYS   203      12.345  -5.790  10.224  1.00 38.04           C
ATOM   1494  CB  CYS   203      10.905  -6.275   9.987  1.00 37.71           C
ATOM   1495  SG  CYS   203      10.220  -6.068   8.318  1.00 39.04           S
ATOM   1496  C   CYS   203      13.315  -6.285   9.150  1.00 37.79           C
ATOM   1497  O   CYS   203      13.733  -7.443   9.174  1.00 37.79           O
ATOM   1498  N   ASP   204      13.680  -5.397   8.224  1.00 37.43           N
ATOM   1499  CA  ASP   204      14.686  -5.713   7.206  1.00 37.34           C
ATOM   1500  CB  ASP   204      14.642  -4.718   6.041  1.00 37.02           C
ATOM   1501  CG  ASP   204      13.502  -4.987   5.061  1.00 37.07           C
ATOM   1502  OD1 ASP   204      12.889  -6.086   5.074  1.00 36.17           O
ATOM   1503  OD2 ASP   204      13.222  -4.074   4.258  1.00 37.74           O
ATOM   1504  C   ASP   204      16.088  -5.732   7.807  1.00 37.19           C
ATOM   1505  O   ASP   204      16.945  -6.469   7.345  1.00 37.44           O
ATOM   1506  N   VAL   205      16.315  -4.913   8.830  1.00 37.21           N
ATOM   1507  CA  VAL   205      17.605  -4.876   9.512  1.00 37.01           C
ATOM   1508  CB  VAL   205      17.812  -3.561  10.326  1.00 37.10           C
ATOM   1509  CG1 VAL   205      19.024  -3.665  11.250  1.00 36.49           C
ATOM   1510  CG2 VAL   205      17.967  -2.362   9.386  1.00 36.12           C
ATOM   1511  C   VAL   205      17.773  -6.115  10.386  1.00 37.14           C
ATOM   1512  O   VAL   205      18.871  -6.674  10.467  1.00 37.29           O
ATOM   1513  N   TRP   206      16.689  -6.550  11.026  1.00 36.96           N
ATOM   1514  CA  TRP   206      16.715  -7.788  11.803  1.00 36.69           C
ATOM   1515  CB  TRP   206      15.363  -8.059  12.465  1.00 36.43           C
ATOM   1516  CG  TRP   206      15.296  -9.379  13.209  1.00 36.43           C
ATOM   1517  CD1 TRP   206      15.077 -10.617  12.669  1.00 36.64           C
ATOM   1518  NE1 TRP   206      15.086 -11.579  13.657  1.00 36.52           N
ATOM   1519  CE2 TRP   206      15.299 -10.968  14.864  1.00 36.03           C
ATOM   1520  CD2 TRP   206      15.441  -9.582  14.622  1.00 35.58           C
ATOM   1521  CE3 TRP   206      15.676  -8.727  15.705  1.00 35.05           C
ATOM   1522  CZ3 TRP   206      15.758  -9.272  16.978  1.00 35.89           C
ATOM   1523  CH2 TRP   206      15.617 -10.658  17.186  1.00 36.23           C
ATOM   1524  CZ2 TRP   206      15.387 -11.517  16.144  1.00 35.60           C
ATOM   1525  C   TRP   206      17.088  -8.948  10.891  1.00 36.91           C
ATOM   1526  O   TRP   206      18.028  -9.705  11.184  1.00 37.29           O
ATOM   1527  N   SER   207      16.360  -9.070   9.780  1.00 36.66           N
ATOM   1528  CA  SER   207      16.571 -10.153   8.836  1.00 36.59           C
ATOM   1529  CB  SER   207      15.553 -10.081   7.700  1.00 36.62           C
ATOM   1530  OG  SER   207      14.231 -10.092   8.219  1.00 36.87           O
ATOM   1531  C   SER   207      18.006 -10.171   8.309  1.00 36.77           C
ATOM   1532  O   SER   207      18.640 -11.230   8.285  1.00 37.17           O
ATOM   1533  N   ALA   208      18.528  -9.007   7.916  1.00 36.58           N
ATOM   1534  CA  ALA   208      19.937  -8.890   7.489  1.00 36.35           C
ATOM   1535  CB  ALA   208      20.236  -7.483   6.998  1.00 36.28           C
ATOM   1536  C   ALA   208      20.924  -9.287   8.591  1.00 36.13           C
ATOM   1537  O   ALA   208      21.998  -9.822   8.307  1.00 36.25           O
ATOM   1538  N   GLY   209      20.558  -9.012   9.841  1.00 35.92           N
ATOM   1539  CA  GLY   209      21.357  -9.416  10.995  1.00 36.05           C
ATOM   1540  C   GLY   209      21.459 -10.926  11.115  1.00 36.18           C
ATOM   1541  O   GLY   209      22.536 -11.455  11.370  1.00 36.56           O
ATOM   1542  N   VAL   210      20.335 -11.613  10.922  1.00 36.06           N
ATOM   1543  CA  VAL   210      20.295 -13.074  10.939  1.00 36.00           C
ATOM   1544  CB  VAL   210      18.834 -13.609  10.814  1.00 36.00           C
ATOM   1545  CG1 VAL   210      18.811 -15.120  10.614  1.00 35.47           C
ATOM   1546  CG2 VAL   210      18.018 -13.221  12.040  1.00 35.53           C
ATOM   1547  C   VAL   210      21.173 -13.628   9.822  1.00 36.19           C
ATOM   1548  O   VAL   210      21.987 -14.536  10.057  1.00 36.53           O
ATOM   1549  N   ILE   211      21.020 -13.069   8.619  1.00 36.01           N
ATOM   1550  CA  ILE   211      21.868 -13.435   7.478  1.00 35.89           C
ATOM   1551  CB  ILE   211      21.524 -12.638   6.186  1.00 35.69           C
ATOM   1552  CG1 ILE   211      20.063 -12.873   5.784  1.00 35.66           C
ATOM   1553  CD1 ILE   211      19.590 -12.062   4.583  1.00 35.85           C
ATOM   1554  CG2 ILE   211      22.456 -13.049   5.043  1.00 35.09           C
ATOM   1555  C   ILE   211      23.342 -13.247   7.826  1.00 36.02           C
ATOM   1556  O   ILE   211      24.158 -14.132   7.568  1.00 36.24           O
ATOM   1557  N   LEU   212      23.675 -12.104   8.422  1.00 35.97           N
ATOM   1558  CA  LEU   212      25.061 -11.820   8.775  1.00 36.26           C
ATOM   1559  CB  LEU   212      25.219 -10.398   9.325  1.00 36.17           C
ATOM   1560  CG  LEU   212      26.638  -9.963   9.710  1.00 36.17           C
ATOM   1561  CD1 LEU   212      27.666 -10.214   8.577  1.00 36.07           C
ATOM   1562  CD2 LEU   212      26.647  -8.510  10.148  1.00 36.05           C
ATOM   1563  C   LEU   212      25.583 -12.846   9.768  1.00 36.39           C
ATOM   1564  O   LEU   212      26.694 -13.347   9.621  1.00 36.50           O
ATOM   1565  N   TYR   213      24.763 -13.160  10.766  1.00 36.87           N
ATOM   1566  CA  TYR   213      25.083 -14.189  11.747  1.00 37.27           C
ATOM   1567  CB  TYR   213      23.921 -14.335  12.735  1.00 37.32           C
ATOM   1568  CG  TYR   213      24.184 -15.220  13.941  1.00 37.38           C
ATOM   1569  CD1 TYR   213      24.279 -14.675  15.220  1.00 36.88           C
ATOM   1570  CE1 TYR   213      24.505 -15.484  16.330  1.00 37.09           C
ATOM   1571  CZ  TYR   213      24.638 -16.857  16.164  1.00 37.13           C
ATOM   1572  OH  TYR   213      24.861 -17.671  17.250  1.00 37.08           O
ATOM   1573  CE2 TYR   213      24.548 -17.419  14.903  1.00 37.36           C
ATOM   1574  CD2 TYR   213      24.316 -16.603  13.805  1.00 37.28           C
ATOM   1575  C   TYR   213      25.393 -15.521  11.050  1.00 37.40           C
ATOM   1576  O   TYR   213      26.323 -16.221  11.440  1.00 37.80           O
ATOM   1577  N   ILE   214      24.628 -15.852  10.011  1.00 37.69           N
ATOM   1578  CA  ILE   214      24.836 -17.092   9.253  1.00 37.78           C
ATOM   1579  CB  ILE   214      23.598 -17.475   8.400  1.00 37.93           C
ATOM   1580  CG1 ILE   214      22.410 -17.816   9.317  1.00 37.51           C
ATOM   1581  CD1 ILE   214      21.063 -17.800   8.631  1.00 37.10           C
ATOM   1582  CG2 ILE   214      23.915 -18.662   7.481  1.00 37.73           C
ATOM   1583  C   ILE   214      26.102 -17.048   8.398  1.00 37.97           C
ATOM   1584  O   ILE   214      26.851 -18.027   8.348  1.00 37.97           O
ATOM   1585  N   LEU   215      26.357 -15.913   7.749  1.00 38.19           N
ATOM   1586  CA  LEU   215      27.560 -15.759   6.919  1.00 38.35           C
ATOM   1587  CB  LEU   215      27.666 -14.342   6.335  1.00 38.20           C
ATOM   1588  CG  LEU   215      26.618 -13.900   5.297  1.00 38.04           C
ATOM   1589  CD1 LEU   215      26.883 -12.481   4.823  1.00 37.26           C
ATOM   1590  CD2 LEU   215      26.569 -14.840   4.109  1.00 37.70           C
ATOM   1591  C   LEU   215      28.826 -16.105   7.690  1.00 38.58           C
ATOM   1592  O   LEU   215      29.728 -16.750   7.157  1.00 38.72           O
ATOM   1593  N   LEU   216      28.869 -15.699   8.955  1.00 38.99           N
ATOM   1594  CA  LEU   216      30.064 -15.848   9.780  1.00 39.33           C
ATOM   1595  CB  LEU   216      30.159 -14.705  10.800  1.00 39.43           C
ATOM   1596  CG  LEU   216      30.218 -13.268  10.275  1.00 39.31           C
ATOM   1597  CD1 LEU   216      30.029 -12.288  11.420  1.00 39.01           C
ATOM   1598  CD2 LEU   216      31.537 -13.006   9.549  1.00 39.26           C
ATOM   1599  C   LEU   216      30.167 -17.191  10.497  1.00 39.54           C
ATOM   1600  O   LEU   216      31.263 -17.739  10.615  1.00 39.71           O
ATOM   1601  N   SER   217      29.039 -17.714  10.983  1.00 39.73           N
ATOM   1602  CA  SER   217      29.045 -18.953  11.781  1.00 39.59           C
ATOM   1603  CB  SER   217      28.218 -18.780  13.060  1.00 39.57           C
ATOM   1604  OG  SER   217      26.829 -18.728  12.770  1.00 39.90           O
ATOM   1605  C   SER   217      28.562 -20.190  11.022  1.00 39.53           C
ATOM   1606  O   SER   217      28.912 -21.315  11.382  1.00 39.72           O
ATOM   1607  N   GLY   218      27.752 -19.979   9.985  1.00 39.30           N
ATOM   1608  CA  GLY   218      27.160 -21.079   9.224  1.00 39.01           C
ATOM   1609  C   GLY   218      26.030 -21.725   9.997  1.00 38.80           C
ATOM   1610  O   GLY   218      25.651 -22.864   9.720  1.00 38.68           O
ATOM   1611  N   THR   219      25.492 -20.969  10.954  1.00 38.69           N
ATOM   1612  CA  THR   219      24.509 -21.442  11.928  1.00 38.70           C
ATOM   1613  CB  THR   219      25.218 -21.849  13.256  1.00 38.61           C
ATOM   1614  OG1 THR   219      25.629 -23.216  13.167  1.00 39.25           O
ATOM   1615  CG2 THR   219      24.319 -21.690  14.477  1.00 39.27           C
ATOM   1616  C   THR   219      23.464 -20.348  12.175  1.00 38.45           C
ATOM   1617  O   THR   219      23.823 -19.182  12.307  1.00 38.52           O
ATOM   1618  N   PRO   220      22.167 -20.723  12.219  1.00 38.37           N
ATOM   1619  CA  PRO   220      21.089 -19.784  12.566  1.00 38.06           C
ATOM   1620  CB  PRO   220      19.812 -20.620  12.402  1.00 37.90           C
ATOM   1621  CG  PRO   220      20.201 -21.837  11.670  1.00 38.15           C
ATOM   1622  CD  PRO   220      21.650 -22.076  11.937  1.00 38.42           C
ATOM   1623  C   PRO   220      21.184 -19.313  14.016  1.00 37.85           C
ATOM   1624  O   PRO   220      21.410 -20.133  14.913  1.00 37.87           O
ATOM   1625  N   PRO   221      21.020 -18.000  14.249  1.00 37.63           N
ATOM   1626  CA  PRO   221      20.913 -17.483  15.614  1.00 37.53           C
ATOM   1627  CB  PRO   221      20.721 -15.971  15.414  1.00 37.54           C
ATOM   1628  CG  PRO   221      20.311 -15.800  13.984  1.00 37.26           C
ATOM   1629  CD  PRO   221      20.942 -16.931  13.236  1.00 37.51           C
ATOM   1630  C   PRO   221      19.707 -18.081  16.334  1.00 37.84           C
ATOM   1631  O   PRO   221      19.788 -18.374  17.529  1.00 38.10           O
ATOM   1632  N   PHE   222      18.609 -18.266  15.600  1.00 37.67           N
ATOM   1633  CA  PHE   222      17.393 -18.866  16.127  1.00 37.75           C
ATOM   1634  CB  PHE   222      16.217 -17.882  16.008  1.00 37.80           C
ATOM   1635  CG  PHE   222      16.524 -16.532  16.590  1.00 37.77           C
ATOM   1636  CD1 PHE   222      16.941 -15.487  15.770  1.00 37.48           C
ATOM   1637  CE1 PHE   222      17.263 -14.250  16.313  1.00 37.79           C
ATOM   1638  CZ  PHE   222      17.179 -14.050  17.692  1.00 38.18           C
ATOM   1639  CE2 PHE   222      16.773 -15.092  18.522  1.00 37.76           C
ATOM   1640  CD2 PHE   222      16.458 -16.324  17.969  1.00 37.41           C
ATOM   1641  C   PHE   222      17.122 -20.178  15.404  1.00 37.76           C
ATOM   1642  O   PHE   222      16.789 -20.192  14.218  1.00 37.61           O
ATOM   1643  N   TYR   223      17.271 -21.274  16.143  1.00 37.84           N
ATOM   1644  CA  TYR   223      17.334 -22.616  15.574  1.00 37.98           C
ATOM   1645  CB  TYR   223      18.695 -23.239  15.903  1.00 37.91           C
ATOM   1646  CG  TYR   223      19.077 -23.213  17.372  1.00 38.04           C
ATOM   1647  CD1 TYR   223      18.635 -24.205  18.252  1.00 38.15           C
ATOM   1648  CE1 TYR   223      18.997 -24.186  19.600  1.00 37.91           C
ATOM   1649  CZ  TYR   223      19.814 -23.170  20.073  1.00 38.01           C
ATOM   1650  OH  TYR   223      20.180 -23.142  21.400  1.00 38.38           O
ATOM   1651  CE2 TYR   223      20.268 -22.179  19.220  1.00 37.76           C
ATOM   1652  CD2 TYR   223      19.902 -22.207  17.877  1.00 38.29           C
ATOM   1653  C   TYR   223      16.207 -23.546  16.037  1.00 38.10           C
ATOM   1654  O   TYR   223      15.464 -23.220  16.965  1.00 38.35           O
ATOM   1655  N   GLY   224      16.105 -24.711  15.395  1.00 38.08           N
ATOM   1656  CA  GLY   224      15.075 -25.696  15.712  1.00 38.24           C
ATOM   1657  C   GLY   224      14.800 -26.708  14.609  1.00 38.49           C
ATOM   1658  O   GLY   224      15.005 -26.430  13.425  1.00 38.44           O
ATOM   1659  N   LYS   225      14.318 -27.885  15.010  1.00 38.73           N
ATOM   1660  CA  LYS   225      14.047 -28.994  14.093  1.00 38.85           C
ATOM   1661  CB  LYS   225      14.081 -30.328  14.848  1.00 38.78           C
ATOM   1666  C   LYS   225      12.721 -28.846  13.333  1.00 38.88           C
ATOM   1667  O   LYS   225      12.411 -29.651  12.447  1.00 38.93           O
ATOM   1668  N   ASN   226      11.941 -27.826  13.688  1.00 38.80           N
ATOM   1669  CA  ASN   226      10.677 -27.533  13.006  1.00 38.66           C
ATOM   1670  CB  ASN   226       9.528 -28.393  13.562  1.00 38.54           C
ATOM   1671  CG  ASN   226       9.294 -28.180  15.052  1.00 38.57           C
ATOM   1672  OD1 ASN   226       9.191 -27.047  15.530  1.00 37.97           O
ATOM   1673  ND2 ASN   226       9.189 -29.281  15.792  1.00 38.45           N
ATOM   1674  C   ASN   226      10.319 -26.056  13.073  1.00 38.55           C
ATOM   1675  O   ASN   226      10.945 -25.296  13.811  1.00 38.60           O
ATOM   1676  N   GLU   227       9.301 -25.665  12.309  1.00 38.50           N
ATOM   1677  CA  GLU   227       8.824 -24.282  12.271  1.00 38.28           C
ATOM   1678  CB  GLU   227       7.601 -24.161  11.357  1.00 38.37           C
ATOM   1679  CG  GLU   227       7.245 -22.721  11.018  1.00 38.89           C
ATOM   1680  CD  GLU   227       5.787 -22.521  10.617  1.00 39.55           C
ATOM   1681  OE1 GLU   227       5.432 -21.363  10.311  1.00 39.16           O
ATOM   1682  OE2 GLU   227       5.001 -23.500  10.611  1.00 40.40           O
ATOM   1683  C   GLU   227       8.483 -23.730  13.658  1.00 38.05           C
ATOM   1684  O   GLU   227       8.889 -22.616  14.004  1.00 38.10           O
ATOM   1685  N   TYR   228       7.730 -24.508  14.437  1.00 37.68           N
ATOM   1686  CA  TYR   228       7.290 -24.085  15.765  1.00 37.17           C
ATOM   1687  CB  TYR   228       6.419 -25.161  16.414  1.00 36.93           C
ATOM   1688  CG  TYR   228       5.981 -24.831  17.826  1.00 36.71           C
ATOM   1689  CD1 TYR   228       4.913 -23.959  18.062  1.00 36.21           C
ATOM   1690  CE1 TYR   228       4.504 -23.654  19.356  1.00 35.79           C
ATOM   1691  CZ  TYR   228       5.159 -24.231  20.434  1.00 36.67           C
ATOM   1692  OH  TYR   228       4.757 -23.934  21.717  1.00 36.85           O
ATOM   1693  CE2 TYR   228       6.223 -25.102  20.230  1.00 36.60           C
ATOM   1694  CD2 TYR   228       6.627 -25.396  18.928  1.00 36.59           C
ATOM   1695  C   TYR   228       8.456 -23.723  16.684  1.00 37.01           C
ATOM   1696  O   TYR   228       8.450 -22.653  17.298  1.00 36.92           O
ATOM   1697  N   ASP   229       9.444 -24.616  16.766  1.00 36.82           N
ATOM   1698  CA  ASP   229      10.586 -24.453  17.668  1.00 36.71           C
ATOM   1699  CB  ASP   229      11.474 -25.697  17.646  1.00 36.74           C
ATOM   1700  CG  ASP   229      10.900 -26.848  18.458  1.00 36.74           C
ATOM   1701  OD1 ASP   229       9.786 -26.725  19.013  1.00 36.28           O
ATOM   1702  OD2 ASP   229      11.581 -27.886  18.551  1.00 37.23           O
ATOM   1703  C   ASP   229      11.416 -23.219  17.351  1.00 36.73           C
ATOM   1704  O   ASP   229      11.839 -22.503  18.261  1.00 36.65           O
ATOM   1705  N   ILE   230      11.642 -22.981  16.061  1.00 36.74           N
ATOM   1706  CA  ILE   230      12.366 -21.802  15.598  1.00 36.94           C
ATOM   1707  CB  ILE   230      12.530 -21.795  14.061  1.00 37.02           C
ATOM   1708  CG1 ILE   230      13.388 -22.985  13.614  1.00 37.06           C
ATOM   1709  CD1 ILE   230      13.156 -23.401  12.161  1.00 37.72           C
ATOM   1710  CG2 ILE   230      13.139 -20.470  13.590  1.00 36.88           C
ATOM   1711  C   ILE   230      11.635 -20.538  16.032  1.00 36.99           C
ATOM   1712  O   ILE   230      12.246 -19.627  16.599  1.00 36.78           O
ATOM   1713  N   LEU   231      10.325 -20.504  15.784  1.00 37.16           N
ATOM   1714  CA  LEU   231       9.511 -19.311  16.047  1.00 37.26           C
ATOM   1715  CB  LEU   231       8.113 -19.446  15.433  1.00 37.04           C
ATOM   1716  CG  LEU   231       8.033 -19.409  13.902  1.00 36.84           C
ATOM   1717  CD1 LEU   231       6.616 -19.620  13.428  1.00 36.22           C
ATOM   1718  CD2 LEU   231       8.588 -18.108  13.342  1.00 37.39           C
ATOM   1719  C   LEU   231       9.424 -18.963  17.531  1.00 37.47           C
ATOM   1720  O   LEU   231       9.308 -17.791  17.883  1.00 37.55           O
ATOM   1721  N   LYS   232       9.494 -19.983  18.386  1.00 37.63           N
ATOM   1722  CA  LYS   232       9.508 -19.794  19.839  1.00 37.84           C
ATOM   1723  CB  LYS   232       9.348 -21.134  20.557  1.00 37.91           C
ATOM   1724  CG  LYS   232       7.969 -21.772  20.419  1.00 38.77           C
ATOM   1725  CD  LYS   232       7.144 -21.694  21.710  1.00 41.10           C
ATOM   1726  CE  LYS   232       6.538 -20.315  21.972  1.00 42.57           C
ATOM   1727  NZ  LYS   232       5.640 -19.825  20.879  1.00 43.95           N
ATOM   1728  C   LYS   232      10.785 -19.100  20.313  1.00 37.87           C
ATOM   1729  O   LYS   232      10.742 -18.284  21.233  1.00 38.04           O
ATOM   1730  N   ARG   233      11.914 -19.425  19.684  1.00 37.78           N
ATOM   1731  CA  ARG   233      13.189 -18.790  20.013  1.00 37.73           C
ATOM   1732  CB  ARG   233      14.372 -19.622  19.514  1.00 37.75           C
ATOM   1733  CG  ARG   233      14.723 -20.779  20.434  1.00 37.93           C
ATOM   1734  CD  ARG   233      15.958 -21.532  19.964  1.00 38.50           C
ATOM   1735  NE  ARG   233      16.307 -22.611  20.892  1.00 40.42           N
ATOM   1736  CZ  ARG   233      15.689 -23.793  20.954  1.00 40.76           C
ATOM   1737  NH1 ARG   233      16.086 -24.698  21.838  1.00 41.16           N
ATOM   1738  NH2 ARG   233      14.674 -24.077  20.140  1.00 40.70           N
ATOM   1739  C   ARG   233      13.269 -17.363  19.482  1.00 37.72           C
ATOM   1740  O   ARG   233      13.817 -16.482  20.149  1.00 37.82           O
ATOM   1741  N   VAL   234      12.728 -17.140  18.285  1.00 37.49           N
ATOM   1742  CA  VAL   234      12.622 -15.790  17.723  1.00 37.57           C
ATOM   1743  CB  VAL   234      11.967 -15.789  16.308  1.00 37.51           C
ATOM   1744  CG1 VAL   234      11.822 -14.371  15.789  1.00 37.59           C
ATOM   1745  CG2 VAL   234      12.790 -16.605  15.326  1.00 37.38           C
ATOM   1746  C   VAL   234      11.807 -14.908  18.673  1.00 37.59           C
ATOM   1747  O   VAL   234      12.203 -13.789  19.003  1.00 37.67           O
ATOM   1748  N   GLU   235      10.680 -15.447  19.122  1.00 37.49           N
ATOM   1749  CA  GLU   235       9.755 -14.767  20.020  1.00 37.61           C
ATOM   1750  CB  GLU   235       8.643 -15.737  20.399  1.00 37.30           C
ATOM   1751  CG  GLU   235       7.437 -15.103  21.025  1.00 37.36           C
ATOM   1752  CD  GLU   235       6.330 -16.103  21.226  1.00 37.27           C
ATOM   1753  OE1 GLU   235       6.567 -17.130  21.897  1.00 37.92           O
ATOM   1754  OE2 GLU   235       5.226 -15.868  20.703  1.00 37.53           O
ATOM   1755  C   GLU   235      10.428 -14.224  21.284  1.00 37.67           C
ATOM   1756  O   GLU   235      10.114 -13.119  21.735  1.00 37.71           O
ATOM   1757  N   THR   236      11.344 -15.009  21.847  1.00 37.60           N
ATOM   1758  CA  THR   236      12.078 -14.627  23.049  1.00 37.73           C
ATOM   1759  CB  THR   236      12.667 -15.871  23.755  1.00 37.87           C
ATOM   1760  OG1 THR   236      11.644 -16.866  23.897  1.00 38.30           O
ATOM   1761  CG2 THR   236      13.196 -15.521  25.139  1.00 38.37           C
ATOM   1762  C   THR   236      13.181 -13.617  22.712  1.00 37.60           C
ATOM   1763  O   THR   236      13.539 -12.774  23.536  1.00 37.46           O
ATOM   1764  N   GLY   237      13.705 -13.705  21.492  1.00 37.51           N
ATOM   1765  CA  GLY   237      14.756 -12.810  21.035  1.00 37.46           C
ATOM   1766  C   GLY   237      16.128 -13.138  21.594  1.00 37.52           C
ATOM   1767  O   GLY   237      17.071 -12.373  21.410  1.00 37.63           O
ATOM   1768  N   LYS   238      16.245 -14.277  22.270  1.00 37.54           N
ATOM   1769  CA  LYS   238      17.502 -14.660  22.916  1.00 37.42           C
ATOM   1770  CB  LYS   238      17.254 -15.338  24.273  1.00 37.27           C
ATOM   1771  CG  LYS   238      16.883 -14.370  25.389  1.00 37.23           C
ATOM   1772  CD  LYS   238      16.542 -15.100  26.683  1.00 37.37           C
ATOM   1775  C   LYS   238      18.371 -15.533  22.012  1.00 37.37           C
ATOM   1776  O   LYS   238      17.919 -16.539  21.456  1.00 37.31           O
ATOM   1777  N   TYR   239      19.623 -15.119  21.869  1.00 37.27           N
ATOM   1778  CA  TYR   239      20.594 -15.825  21.053  1.00 37.31           C
ATOM   1779  CB  TYR   239      20.593 -15.267  19.623  1.00 37.06           C
ATOM   1780  CG  TYR   239      21.088 -13.847  19.525  1.00 37.03           C
ATOM   1781  CD1 TYR   239      22.396 -13.580  19.131  1.00 36.53           C
ATOM   1782  CE1 TYR   239      22.864 -12.289  19.048  1.00 36.42           C
ATOM   1783  CZ  TYR   239      22.028 -11.238  19.358  1.00 36.81           C
ATOM   1784  OH  TYR   239      22.514  -9.956  19.267  1.00 37.64           O
ATOM   1785  CE2 TYR   239      20.719 -11.466  19.759  1.00 36.69           C
ATOM   1786  CD2 TYR   239      20.257 -12.769  19.840  1.00 36.65           C
ATOM   1787  C   TYR   239      21.962 -15.679  21.718  1.00 37.41           C
ATOM   1788  O   TYR   239      22.113 -14.902  22.664  1.00 37.27           O
ATOM   1789  N   ALA   240      22.951 -16.421  21.226  1.00 37.63           N
ATOM   1790  CA  ALA   240      24.266 -16.451  21.861  1.00 37.85           C
ATOM   1791  CB  ALA   240      24.377 -17.668  22.760  1.00 38.03           C
ATOM   1792  C   ALA   240      25.424 -16.425  20.867  1.00 38.01           C
ATOM   1793  O   ALA   240      25.284 -16.861  19.721  1.00 37.97           O
ATOM   1794  N   PHE   241      26.561 -15.898  21.321  1.00 38.18           N
ATOM   1795  CA  PHE   241      27.824 -15.996  20.594  1.00 38.26           C
ATOM   1796  CB  PHE   241      28.564 -14.652  20.598  1.00 37.95           C
ATOM   1797  CG  PHE   241      27.912 -13.581  19.762  1.00 37.70           C
ATOM   1798  CD1 PHE   241      27.503 -12.384  20.346  1.00 37.03           C
ATOM   1799  CE1 PHE   241      26.910 -11.386  19.584  1.00 36.73           C
ATOM   1800  CZ  PHE   241      26.718 -11.578  18.214  1.00 37.02           C
ATOM   1801  CE2 PHE   241      27.126 -12.767  17.620  1.00 36.41           C
ATOM   1802  CD2 PHE   241      27.720 -13.760  18.393  1.00 36.82           C
ATOM   1803  C   PHE   241      28.682 -17.064  21.264  1.00 38.53           C
ATOM   1804  O   PHE   241      29.892 -16.888  21.451  1.00 38.56           O
ATOM   1805  N   ASP   242      28.051 -18.177  21.623  1.00 38.92           N
ATOM   1806  CA  ASP   242      28.693 -19.178  22.476  1.00 39.33           C
ATOM   1807  CB  ASP   242      27.671 -19.783  23.444  1.00 39.76           C
ATOM   1808  CG  ASP   242      27.562 -18.998  24.744  1.00 40.63           C
ATOM   1809  OD1 ASP   242      28.534 -18.295  25.106  1.00 41.10           O
ATOM   1810  OD2 ASP   242      26.505 -19.093  25.408  1.00 42.12           O
ATOM   1811  C   ASP   242      29.439 -20.278  21.734  1.00 39.12           C
ATOM   1812  O   ASP   242      30.298 -20.950  22.314  1.00 39.27           O
ATOM   1813  N   LEU   243      29.107 -20.458  20.461  1.00 38.99           N
ATOM   1814  CA  LEU   243      29.721 -21.487  19.630  1.00 39.00           C
ATOM   1815  CB  LEU   243      28.988 -21.585  18.290  1.00 39.03           C
ATOM   1816  CG  LEU   243      27.614 -22.266  18.174  1.00 39.61           C
ATOM   1817  CD1 LEU   243      26.898 -22.527  19.508  1.00 40.20           C
ATOM   1818  CD2 LEU   243      26.732 -21.452  17.242  1.00 39.67           C
ATOM   1819  C   LEU   243      31.194 -21.164  19.403  1.00 38.94           C
ATOM   1820  O   LEU   243      31.530 -20.002  19.158  1.00 38.87           O
ATOM   1821  N   PRO   244      32.077 -22.187  19.488  1.00 38.86           N
ATOM   1822  CA  PRO   244      33.527 -22.017  19.303  1.00 38.83           C
ATOM   1823  CB  PRO   244      34.037 -23.458  19.132  1.00 38.84           C
ATOM   1824  CG  PRO   244      32.803 -24.325  19.030  1.00 38.83           C
ATOM   1825  CD  PRO   244      31.736 -23.592  19.761  1.00 38.81           C
ATOM   1826  C   PRO   244      33.869 -21.169  18.071  1.00 38.85           C
ATOM   1827  O   PRO   244      34.774 -20.339  18.118  1.00 38.72           O
ATOM   1828  N   GLN   245      33.115 -21.378  16.995  1.00 38.99           N
ATOM   1829  CA  GLN   245      33.170 -20.579  15.765  1.00 39.05           C
ATOM   1830  CB  GLN   245      31.967 -20.943  14.884  1.00 39.31           C
ATOM   1831  CG  GLN   245      31.830 -22.439  14.644  1.00 40.23           C
ATOM   1832  CD  GLN   245      30.399 -22.901  14.686  1.00 41.43           C
ATOM   1833  OE1 GLN   245      30.013 -23.684  15.557  1.00 42.47           O
ATOM   1834  NE2 GLN   245      29.594 -22.414  13.753  1.00 42.00           N
ATOM   1835  C   GLN   245      33.185 -19.057  15.983  1.00 38.65           C
ATOM   1836  O   GLN   245      33.688 -18.313  15.140  1.00 38.81           O
ATOM   1837  N   TRP   246      32.615 -18.601  17.097  1.00 37.87           N
ATOM   1838  CA  TRP   246      32.605 -17.176  17.431  1.00 37.11           C
ATOM   1839  CB  TRP   246      31.332 -16.819  18.207  1.00 36.67           C
ATOM   1840  CG  TRP   246      30.113 -16.887  17.346  1.00 36.36           C
ATOM   1841  CD1 TRP   246      29.208 -17.909  17.278  1.00 35.93           C
ATOM   1842  NE1 TRP   246      28.229 -17.616  16.354  1.00 35.83           N
ATOM   1843  CE2 TRP   246      28.492 -16.389  15.803  1.00 35.55           C
ATOM   1844  CD2 TRP   246      29.678 -15.903  16.398  1.00 35.88           C
ATOM   1845  CE3 TRP   246      30.167 -14.648  16.006  1.00 35.50           C
ATOM   1846  CZ3 TRP   246      29.472 -13.933  15.040  1.00 35.55           C
ATOM   1847  CH2 TRP   246      28.300 -14.448  14.460  1.00 35.89           C
ATOM   1848  CZ2 TRP   246      27.794 -15.669  14.829  1.00 35.87           C
ATOM   1849  C   TRP   246      33.856 -16.699  18.183  1.00 36.98           C
ATOM   1850  O   TRP   246      34.112 -15.495  18.246  1.00 37.09           O
ATOM   1851  N   ARG   247      34.634 -17.638  18.725  1.00 36.65           N
ATOM   1852  CA  ARG   247      35.781 -17.326  19.593  1.00 36.51           C
ATOM   1853  CB  ARG   247      36.447 -18.620  20.102  1.00 36.43           C
ATOM   1854  CG  ARG   247      37.706 -18.442  20.949  1.00 36.68           C
ATOM   1855  CD  ARG   247      37.413 -18.029  22.392  1.00 36.88           C
ATOM   1856  NE  ARG   247      38.636 -17.694  23.134  1.00 36.15           N
ATOM   1857  CZ  ARG   247      39.203 -18.472  24.056  1.00 36.35           C
ATOM   1858  NH1 ARG   247      40.310 -18.072  24.671  1.00 35.59           N
ATOM   1859  NH2 ARG   247      38.666 -19.649  24.372  1.00 36.90           N
ATOM   1860  C   ARG   247      36.815 -16.384  18.965  1.00 36.38           C
ATOM   1861  O   ARG   247      37.383 -15.541  19.664  1.00 36.55           O
ATOM   1862  N   THR   248      37.050 -16.514  17.658  1.00 36.20           N
ATOM   1863  CA  THR   248      38.044 -15.674  16.966  1.00 35.91           C
ATOM   1864  CB  THR   248      39.133 -16.510  16.254  1.00 35.83           C
ATOM   1865  OG1 THR   248      38.539 -17.251  15.180  1.00 35.25           O
ATOM   1866  CG2 THR   248      39.829 -17.453  17.229  1.00 35.75           C
ATOM   1867  C   THR   248      37.439 -14.692  15.956  1.00 35.86           C
ATOM   1868  O   THR   248      38.122 -14.240  15.030  1.00 35.73           O
ATOM   1869  N   ILE   249      36.161 -14.374  16.133  1.00 35.76           N
ATOM   1870  CA  ILE   249      35.513 -13.336  15.342  1.00 35.77           C
ATOM   1871  CB  ILE   249      34.075 -13.743  14.939  1.00 35.99           C
ATOM   1872  CG1 ILE   249      34.122 -15.049  14.134  1.00 36.24           C
ATOM   1873  CD1 ILE   249      32.801 -15.496  13.573  1.00 36.55           C
ATOM   1874  CG2 ILE   249      33.396 -12.637  14.126  1.00 35.85           C
ATOM   1875  C   ILE   249      35.562 -12.025  16.129  1.00 35.74           C
ATOM   1876  O   ILE   249      35.485 -12.033  17.361  1.00 35.61           O
ATOM   1877  N   SER   250      35.711 -10.911  15.412  1.00 35.81           N
ATOM   1878  CA  SER   250      35.985  -9.600  16.018  1.00 35.97           C
ATOM   1879  CB  SER   250      36.333  -8.583  14.931  1.00 35.91           C
ATOM   1880  OG  SER   250      35.218  -8.356  14.087  1.00 35.93           O
ATOM   1881  C   SER   250      34.847  -9.050  16.878  1.00 36.23           C
ATOM   1882  O   SER   250      33.671  -9.306  16.606  1.00 35.81           O
ATOM   1883  N   ASP   251      35.213  -8.284  17.908  1.00 36.56           N
ATOM   1884  CA  ASP   251      34.237  -7.595  18.755  1.00 36.87           C
ATOM   1885  CB  ASP   251      34.939  -6.765  19.838  1.00 36.75           C
ATOM   1886  CG  ASP   251      35.608  -7.625  20.908  1.00 36.45           C
ATOM   1887  OD1 ASP   251      35.124  -8.741  21.197  1.00 35.39           O
ATOM   1888  OD2 ASP   251      36.622  -7.171  21.478  1.00 36.42           O
ATOM   1889  C   ASP   251      33.308  -6.707  17.923  1.00 37.25           C
ATOM   1890  O   ASP   251      32.109  -6.630  18.198  1.00 37.54           O
ATOM   1891  N   ASP   252      33.869  -6.063  16.898  1.00 37.73           N
ATOM   1892  CA  ASP   252      33.122  -5.181  15.994  1.00 38.29           C
ATOM   1893  CB  ASP   252      34.065  -4.524  14.984  1.00 38.31           C
ATOM   1894  CG  ASP   252      34.966  -3.480  15.614  1.00 39.51           C
ATOM   1895  OD1 ASP   252      34.627  -2.964  16.705  1.00 40.68           O
ATOM   1896  OD2 ASP   252      36.016  -3.169  15.008  1.00 40.32           O
ATOM   1897  C   ASP   252      31.997  -5.893  15.245  1.00 38.40           C
ATOM   1898  O   ASP   252      30.908  -5.347  15.097  1.00 38.56           O
ATOM   1899  N   ALA   253      32.276  -7.103  14.767  1.00 38.64           N
ATOM   1900  CA  ALA   253      31.294  -7.908  14.049  1.00 38.68           C
ATOM   1901  CB  ALA   253      31.947  -9.150  13.475  1.00 38.72           C
ATOM   1902  C   ALA   253      30.158  -8.296  14.974  1.00 38.80           C
ATOM   1903  O   ALA   253      28.985  -8.246  14.589  1.00 39.01           O
ATOM   1904  N   LYS   254      30.516  -8.681  16.195  1.00 38.74           N
ATOM   1905  CA  LYS   254      29.540  -9.043  17.213  1.00 38.72           C
ATOM   1906  CB  LYS   254      30.239  -9.649  18.433  1.00 38.73           C
ATOM   1907  CG  LYS   254      30.852 -11.022  18.177  1.00 38.48           C
ATOM   1908  CD  LYS   254      31.647 -11.507  19.373  1.00 39.46           C
ATOM   1909  CE  LYS   254      32.538 -12.683  18.994  1.00 39.65           C
ATOM   1910  NZ  LYS   254      33.341 -13.181  20.143  1.00 39.55           N
ATOM   1911  C   LYS   254      28.706  -7.828  17.609  1.00 38.74           C
ATOM   1912  O   LYS   254      27.493  -7.939  17.835  1.00 38.81           O
ATOM   1913  N   ASP   255      29.361  -6.670  17.679  1.00 38.61           N
ATOM   1914  CA  ASP   255      28.688  -5.418  17.999  1.00 38.42           C
ATOM   1915  CB  ASP   255      29.698  -4.274  18.077  1.00 38.45           C
ATOM   1916  CG  ASP   255      29.056  -2.961  18.469  1.00 38.86           C
ATOM   1917  OD1 ASP   255      28.618  -2.836  19.632  1.00 39.77           O
ATOM   1918  OD2 ASP   255      28.989  -2.057  17.613  1.00 38.67           O
ATOM   1919  C   ASP   255      27.610  -5.102  16.965  1.00 38.20           C
ATOM   1920  O   ASP   255      26.471  -4.785  17.318  1.00 37.99           O
ATOM   1921  N   LEU   256      27.978  -5.197  15.691  1.00 38.04           N
ATOM   1922  CA  LEU   256      27.044  -4.957  14.596  1.00 37.96           C
ATOM   1923  CB  LEU   256      27.733  -5.170  13.245  1.00 38.08           C
ATOM   1924  CG  LEU   256      26.912  -4.952  11.970  1.00 38.33           C
ATOM   1925  CD1 LEU   256      26.171  -3.614  11.979  1.00 38.93           C
ATOM   1926  CD2 LEU   256      27.823  -5.035  10.766  1.00 38.19           C
ATOM   1927  C   LEU   256      25.813  -5.846  14.716  1.00 37.67           C
ATOM   1928  O   LEU   256      24.682  -5.349  14.765  1.00 37.65           O
ATOM   1929  N   ILE   257      26.044  -7.154  14.784  1.00 37.49           N
ATOM   1930  CA  ILE   257      24.967  -8.132  14.937  1.00 37.66           C
ATOM   1931  CB  ILE   257      25.513  -9.578  14.969  1.00 37.46           C
ATOM   1932  CG1 ILE   257      26.203  -9.909  13.640  1.00 37.24           C
ATOM   1933  CD1 ILE   257      27.106 -11.132  13.683  1.00 36.69           C
ATOM   1934  CG2 ILE   257      24.392 -10.571  15.246  1.00 37.31           C
ATOM   1935  C   ILE   257      24.082  -7.849  16.163  1.00 37.71           C
ATOM   1936  O   ILE   257      22.864  -7.972  16.078  1.00 37.97           O
ATOM   1937  N   ARG   258      24.698  -7.458  17.280  1.00 37.80           N
ATOM   1938  CA  ARG   258      23.969  -7.098  18.505  1.00 37.84           C
ATOM   1939  CB  ARG   258      24.939  -6.754  19.646  1.00 37.95           C
ATOM   1940  CG  ARG   258      25.290  -7.932  20.540  1.00 39.17           C
ATOM   1941  CD  ARG   258      25.998  -7.489  21.811  1.00 40.51           C
ATOM   1942  NE  ARG   258      27.446  -7.599  21.678  1.00 43.18           N
ATOM   1943  CZ  ARG   258      28.155  -8.650  22.085  1.00 44.28           C
ATOM   1944  NH1 ARG   258      27.552  -9.683  22.662  1.00 45.78           N
ATOM   1945  NH2 ARG   258      29.467  -8.670  21.919  1.00 44.33           N
ATOM   1946  C   ARG   258      23.003  -5.937  18.287  1.00 37.66           C
ATOM   1947  O   ARG   258      21.858  -5.963  18.763  1.00 37.57           O
ATOM   1948  N   LYS   259      23.473  -4.922  17.569  1.00 37.36           N
ATOM   1949  CA  LYS   259      22.669  -3.738  17.286  1.00 37.12           C
ATOM   1950  CB  LYS   259      23.550  -2.616  16.744  1.00 37.26           C
ATOM   1951  CG  LYS   259      24.498  -2.005  17.768  1.00 37.00           C
ATOM   1952  CD  LYS   259      25.279  -0.866  17.137  1.00 37.51           C
ATOM   1953  CE  LYS   259      25.799   0.124  18.179  1.00 38.31           C
ATOM   1954  NZ  LYS   259      27.021  -0.365  18.862  1.00 37.62           N
ATOM   1955  C   LYS   259      21.544  -4.053  16.302  1.00 36.92           C
ATOM   1956  O   LYS   259      20.450  -3.482  16.389  1.00 36.93           O
ATOM   1957  N   MET   260      21.819  -4.972  15.377  1.00 36.50           N
ATOM   1958  CA  MET   260      20.846  -5.374  14.367  1.00 36.12           C
ATOM   1959  CB  MET   260      21.553  -5.982  13.158  1.00 36.03           C
ATOM   1960  CG  MET   260      22.546  -5.074  12.483  1.00 35.11           C
ATOM   1961  SD  MET   260      23.408  -5.982  11.192  1.00 36.43           S
ATOM   1962  CE  MET   260      22.167  -5.991   9.900  1.00 34.16           C
ATOM   1963  C   MET   260      19.829  -6.374  14.907  1.00 36.11           C
ATOM   1964  O   MET   260      18.690  -6.416  14.448  1.00 36.26           O
ATOM   1965  N   LEU   261      20.242  -7.203  15.859  1.00 36.02           N
ATOM   1966  CA  LEU   261      19.312  -8.130  16.493  1.00 36.06           C
ATOM   1967  CB  LEU   261      19.946  -9.518  16.650  1.00 35.91           C
ATOM   1968  CG  LEU   261      20.336 -10.273  15.372  1.00 35.93           C
ATOM   1969  CD1 LEU   261      20.792 -11.679  15.724  1.00 36.12           C
ATOM   1970  CD2 LEU   261      19.191 -10.335  14.340  1.00 35.78           C
ATOM   1971  C   LEU   261      18.771  -7.591  17.831  1.00 36.14           C
ATOM   1972  O   LEU   261      18.379  -8.367  18.716  1.00 35.99           O
ATOM   1973  N   THR   262      18.751  -6.261  17.963  1.00 35.95           N
ATOM   1974  CA  THR   262      18.139  -5.592  19.111  1.00 36.27           C
ATOM   1975  CB  THR   262      18.344  -4.052  19.062  1.00 36.34           C
ATOM   1976  OG1 THR   262      19.746  -3.747  19.023  1.00 36.64           O
ATOM   1977  CG2 THR   262      17.734  -3.384  20.281  1.00 36.20           C
ATOM   1978  C   THR   262      16.647  -5.922  19.135  1.00 36.37           C
ATOM   1979  O   THR   262      15.968  -5.829  18.106  1.00 36.17           O
ATOM   1980  N   PHE   263      16.148  -6.313  20.307  1.00 36.60           N
ATOM   1981  CA  PHE   263      14.777  -6.802  20.429  1.00 36.83           C
ATOM   1982  CB  PHE   263      14.470  -7.287  21.856  1.00 37.09           C
ATOM   1983  CG  PHE   263      13.177  -8.059  21.964  1.00 37.43           C
ATOM   1984  CD1 PHE   263      13.082  -9.360  21.465  1.00 37.91           C
ATOM   1985  CE1 PHE   263      11.891 -10.076  21.549  1.00 37.54           C
ATOM   1986  CZ  PHE   263      10.776  -9.491  22.134  1.00 37.93           C
ATOM   1987  CE2 PHE   263      10.856  -8.188  22.633  1.00 38.30           C
ATOM   1988  CD2 PHE   263      12.054  -7.482  22.544  1.00 37.90           C
ATOM   1989  C   PHE   263      13.734  -5.791  19.938  1.00 36.84           C
ATOM   1990  O   PHE   263      13.006  -6.079  18.988  1.00 36.64           O
ATOM   1991  N   HIS   264      13.679  -4.614  20.567  1.00 36.77           N
ATOM   1992  CA  HIS   264      12.716  -3.573  20.185  1.00 36.84           C
ATOM   1993  CB  HIS   264      12.517  -2.565  21.319  1.00 36.91           C
ATOM   1994  CG  HIS   264      12.011  -3.172  22.589  1.00 37.26           C
ATOM   1995  ND1 HIS   264      10.804  -3.832  22.670  1.00 37.78           N
ATOM   1996  CE1 HIS   264      10.619  -4.255  23.908  1.00 38.24           C
ATOM   1997  NE2 HIS   264      11.661  -3.892  24.633  1.00 38.11           N
ATOM   1998  CD2 HIS   264      12.545  -3.211  23.833  1.00 38.01           C
ATOM   1999  C   HIS   264      13.132  -2.838  18.906  1.00 36.89           C
ATOM   2000  O   HIS   264      14.234  -2.287  18.839  1.00 36.77           O
ATOM   2001  N   PRO   265      12.240  -2.814  17.891  1.00 37.06           N
ATOM   2002  CA  PRO   265      12.532  -2.193  16.596  1.00 37.06           C
ATOM   2003  CB  PRO   265      11.203  -2.319  15.838  1.00 37.06           C
ATOM   2004  CG  PRO   265      10.172  -2.548  16.901  1.00 36.73           C
ATOM   2005  CD  PRO   265      10.874  -3.365  17.925  1.00 36.82           C
ATOM   2006  C   PRO   265      12.957  -0.728  16.724  1.00 37.35           C
ATOM   2007  O   PRO   265      13.883  -0.299  16.032  1.00 37.41           O
ATOM   2008  N   SER   266      12.304   0.019  17.616  1.00 37.60           N
ATOM   2009  CA  SER   266      12.649   1.423  17.877  1.00 38.00           C
ATOM   2010  CB  SER   266      11.651   2.051  18.852  1.00 38.00           C
ATOM   2011  OG  SER   266      11.596   1.311  20.061  1.00 38.23           O
ATOM   2012  C   SER   266      14.069   1.597  18.423  1.00 38.16           C
ATOM   2013  O   SER   266      14.690   2.644  18.225  1.00 38.33           O
ATOM   2014  N   LEU   267      14.568   0.578  19.120  1.00 38.30           N
ATOM   2015  CA  LEU   267      15.921   0.608  19.682  1.00 38.34           C
ATOM   2016  CB  LEU   267      15.968  -0.064  21.063  1.00 38.31           C
ATOM   2017  CG  LEU   267      15.284   0.643  22.250  1.00 38.53           C
ATOM   2018  CD1 LEU   267      15.223  -0.263  23.476  1.00 38.21           C
ATOM   2019  CD2 LEU   267      15.954   1.967  22.605  1.00 38.29           C
ATOM   2020  C   LEU   267      16.919  -0.043  18.732  1.00 38.41           C
ATOM   2021  O   LEU   267      18.128   0.066  18.917  1.00 38.47           O
ATOM   2022  N   ARG   268      16.395  -0.718  17.712  1.00 38.59           N
ATOM   2023  CA  ARG   268      17.216  -1.341  16.685  1.00 38.52           C
ATOM   2024  CB  ARG   268      16.374  -2.297  15.853  1.00 38.42           C
ATOM   2025  CG  ARG   268      17.181  -3.292  15.040  1.00 38.33           C
ATOM   2026  CD  ARG   268      16.267  -4.331  14.446  1.00 38.14           C
ATOM   2027  NE  ARG   268      15.405  -4.908  15.474  1.00 36.86           N
ATOM   2028  CZ  ARG   268      14.164  -5.326  15.259  1.00 36.50           C
ATOM   2029  NH1 ARG   268      13.466  -5.836  16.262  1.00 36.11           N
ATOM   2030  NH2 ARG   268      13.622  -5.231  14.049  1.00 35.73           N
ATOM   2031  C   ARG   268      17.843  -0.290  15.777  1.00 38.52           C
ATOM   2032  O   ARG   268      17.261   0.762  15.528  1.00 38.66           O
ATOM   2033  N   ILE   269      19.027  -0.603  15.274  1.00 38.59           N
ATOM   2034  CA  ILE   269      19.793   0.313  14.447  1.00 38.59           C
ATOM   2035  CB  ILE   269      21.296  -0.126  14.442  1.00 38.81           C
ATOM   2036  CG1 ILE   269      22.203   1.015  14.896  1.00 38.61           C
ATOM   2038  CG2 ILE   269      21.728  -0.775  13.115  1.00 39.47           C
ATOM   2039  C   ILE   269      19.158   0.410  13.047  1.00 38.19           C
ATOM   2040  O   ILE   269      18.491  -0.530  12.595  1.00 38.29           O
ATOM   2041  N   THR   270      19.324   1.561  12.394  1.00 37.66           N
ATOM   2042  CA  THR   270      18.815   1.781  11.037  1.00 37.11           C
ATOM   2043  CB  THR   270      18.745   3.278  10.687  1.00 37.16           C
ATOM   2044  OG1 THR   270      20.064   3.840  10.734  1.00 36.61           O
ATOM   2045  CG2 THR   270      17.835   4.033  11.649  1.00 37.16           C
ATOM   2046  C   THR   270      19.711   1.112   9.999  1.00 37.04           C
ATOM   2047  O   THR   270      20.811   0.655  10.317  1.00 37.18           O
ATOM   2048  N   ALA   271      19.245   1.066   8.754  1.00 36.71           N
ATOM   2049  CA  ALA   271      20.043   0.520   7.654  1.00 36.56           C
ATOM   2050  CB  ALA   271      19.185   0.325   6.424  1.00 36.48           C
ATOM   2051  C   ALA   271      21.268   1.379   7.318  1.00 36.47           C
ATOM   2052  O   ALA   271      22.296   0.845   6.903  1.00 36.42           O
ATOM   2053  N   THR   272      21.143   2.698   7.485  1.00 36.30           N
ATOM   2054  CA  THR   272      22.243   3.630   7.250  1.00 36.41           C
ATOM   2055  CB  THR   272      21.774   5.112   7.282  1.00 36.27           C
ATOM   2056  OG1 THR   272      20.750   5.317   6.306  1.00 36.02           O
ATOM   2057  CG2 THR   272      22.927   6.064   6.970  1.00 36.59           C
ATOM   2058  C   THR   272      23.330   3.409   8.298  1.00 36.74           C
ATOM   2059  O   THR   272      24.522   3.470   7.992  1.00 36.73           O
ATOM   2060  N   GLN   273      22.902   3.141   9.531  1.00 37.14           N
ATOM   2061  CA  GLN   273      23.815   2.862  10.635  1.00 37.37           C
ATOM   2062  CB  GLN   273      23.067   2.886  11.970  1.00 37.22           C
ATOM   2063  CG  GLN   273      22.714   4.291  12.463  1.00 37.20           C
ATOM   2064  CD  GLN   273      21.738   4.296  13.637  1.00 37.26           C
ATOM   2065  OE1 GLN   273      20.723   3.603  13.625  1.00 37.60           O
ATOM   2066  NE2 GLN   273      22.040   5.095  14.649  1.00 36.68           N
ATOM   2067  C   GLN   273      24.561   1.536  10.430  1.00 37.84           C
ATOM   2068  O   GLN   273      25.704   1.393  10.869  1.00 37.97           O
ATOM   2069  N   CYS   274      23.918   0.581   9.756  1.00 38.35           N
ATOM   2070  CA  CYS   274      24.586  -0.654   9.326  1.00 38.88           C
ATOM   2071  CB  CYS   274      23.584  -1.640   8.730  1.00 38.78           C
ATOM   2072  SG  CYS   274      22.440  -2.315   9.907  1.00 40.23           S
ATOM   2073  C   CYS   274      25.658  -0.352   8.287  1.00 38.92           C
ATOM   2074  O   CYS   274      26.808  -0.768   8.430  1.00 38.95           O
ATOM   2075  N   LEU   275      25.267   0.388   7.250  1.00 39.12           N
ATOM   2076  CA  LEU   275      26.159   0.743   6.151  1.00 39.17           C
ATOM   2077  CB  LEU   275      25.415   1.627   5.144  1.00 39.08           C
ATOM   2078  CG  LEU   275      25.483   1.359   3.633  1.00 39.29           C
ATOM   2079  CD1 LEU   275      25.244   2.654   2.865  1.00 39.20           C
ATOM   2080  CD2 LEU   275      26.792   0.719   3.185  1.00 38.99           C
ATOM   2081  C   LEU   275      27.393   1.481   6.664  1.00 39.32           C
ATOM   2082  O   LEU   275      28.440   1.476   6.019  1.00 39.60           O
ATOM   2083  N   GLU   276      27.270   2.102   7.833  1.00 39.30           N
ATOM   2084  CA  GLU   276      28.321   2.965   8.352  1.00 39.41           C
ATOM   2085  CB  GLU   276      27.790   4.395   8.507  1.00 39.63           C
ATOM   2086  CG  GLU   276      27.779   5.192   7.197  1.00 40.58           C
ATOM   2087  CD  GLU   276      26.794   6.356   7.197  1.00 41.51           C
ATOM   2088  OE1 GLU   276      26.034   6.511   8.179  1.00 42.08           O
ATOM   2089  OE2 GLU   276      26.776   7.113   6.203  1.00 41.37           O
ATOM   2090  C   GLU   276      28.964   2.463   9.649  1.00 39.18           C
ATOM   2091  O   GLU   276      29.749   3.181  10.274  1.00 39.01           O
ATOM   2092  N   HIS   277      28.641   1.232  10.044  1.00 38.95           N
ATOM   2093  CA  HIS   277      29.266   0.606  11.212  1.00 38.72           C
ATOM   2094  CB  HIS   277      28.594  -0.732  11.524  1.00 38.45           C
ATOM   2095  CG  HIS   277      28.964  -1.307  12.859  1.00 37.76           C
ATOM   2096  ND1 HIS   277      30.120  -2.028  13.066  1.00 36.70           N
ATOM   2097  CE1 HIS   277      30.181  -2.407  14.330  1.00 36.35           C
ATOM   2098  NE2 HIS   277      29.104  -1.964  14.950  1.00 36.59           N
ATOM   2099  CD2 HIS   277      28.325  -1.273  14.053  1.00 37.12           C
ATOM   2100  C   HIS   277      30.770   0.402  10.973  1.00 38.87           C
ATOM   2101  O   HIS   277      31.166   0.004   9.870  1.00 38.82           O
ATOM   2102  N   PRO   278      31.610   0.678  11.999  1.00 38.94           N
ATOM   2103  CA  PRO   278      33.074   0.516  11.897  1.00 39.06           C
ATOM   2104  CB  PRO   278      33.544   0.610  13.353  1.00 39.02           C
ATOM   2105  CG  PRO   278      32.524   1.457  14.023  1.00 39.02           C
ATOM   2106  CD  PRO   278      31.209   1.193  13.325  1.00 38.93           C
ATOM   2107  C   PRO   278      33.533  -0.812  11.284  1.00 39.18           C
ATOM   2108  O   PRO   278      34.606  -0.864  10.682  1.00 39.17           O
ATOM   2109  N   TRP   279      32.726  -1.864  11.434  1.00 39.42           N
ATOM   2110  CA  TRP   279      33.043  -3.184  10.883  1.00 39.78           C
ATOM   2111  CB  TRP   279      32.133  -4.270  11.477  1.00 39.82           C
ATOM   2112  CG  TRP   279      32.551  -5.671  11.075  1.00 39.89           C
ATOM   2113  CD1 TRP   279      33.632  -6.367  11.537  1.00 39.46           C
ATOM   2114  NE1 TRP   279      33.696  -7.599  10.937  1.00 39.10           N
ATOM   2115  CE2 TRP   279      32.651  -7.724  10.063  1.00 39.53           C
ATOM   2116  CD2 TRP   279      31.906  -6.524  10.120  1.00 39.50           C
ATOM   2117  CE3 TRP   279      30.771  -6.396   9.313  1.00 38.90           C
ATOM   2118  CZ3 TRP   279      30.415  -7.456   8.485  1.00 39.25           C
ATOM   2119  CH2 TRP   279      31.175  -8.639   8.451  1.00 39.36           C
ATOM   2120  CZ2 TRP   279      32.293  -8.792   9.229  1.00 39.60           C
ATOM   2121  C   TRP   279      32.974  -3.223   9.355  1.00 40.06           C
ATOM   2122  O   TRP   279      33.823  -3.842   8.712  1.00 40.06           O
ATOM   2123  N   ILE   280      31.956  -2.573   8.790  1.00 40.41           N
ATOM   2124  CA  ILE   280      31.809  -2.443   7.336  1.00 40.78           C
ATOM   2125  CB  ILE   280      30.375  -1.941   6.944  1.00 40.78           C
ATOM   2126  CG1 ILE   280      29.515  -3.103   6.443  1.00 40.79           C
ATOM   2127  CD1 ILE   280      29.080  -4.057   7.502  1.00 41.07           C
ATOM   2128  CG2 ILE   280      30.416  -0.904   5.839  1.00 40.63           C
ATOM   2129  C   ILE   280      32.907  -1.570   6.723  1.00 41.05           C
ATOM   2130  O   ILE   280      33.396  -1.857   5.627  1.00 41.21           O
ATOM   2131  N   GLN   281      33.296  -0.521   7.445  1.00 41.47           N
ATOM   2132  CA  GLN   281      34.310   0.428   6.973  1.00 41.91           C
ATOM   2133  CB  GLN   281      34.285   1.705   7.811  1.00 41.87           C
ATOM   2134  CG  GLN   281      32.952   2.444   7.769  1.00 42.15           C
ATOM   2135  CD  GLN   281      32.956   3.730   8.581  1.00 42.28           C
ATOM   2136  OE1 GLN   281      34.005   4.201   9.031  1.00 42.41           O
ATOM   2137  NE2 GLN   281      31.774   4.308   8.768  1.00 42.75           N
ATOM   2138  C   GLN   281      35.718  -0.167   6.958  1.00 42.01           C
ATOM   2139  O   GLN   281      36.540   0.203   6.122  1.00 41.90           O
ATOM   2140  N   LYS   282      35.980  -1.093   7.878  1.00 42.34           N
ATOM   2141  CA  LYS   282      37.279  -1.761   7.963  1.00 42.74           C
ATOM   2142  CB  LYS   282      37.391  -2.569   9.260  1.00 42.63           C
ATOM   2147  C   LYS   282      37.584  -2.649   6.750  1.00 43.06           C
ATOM   2148  O   LYS   282      38.750  -2.829   6.397  1.00 43.05           O
ATOM   2149  N   TYR   283      36.547  -3.193   6.110  1.00 43.54           N
ATOM   2150  CA  TYR   283      36.750  -4.092   4.960  1.00 43.80           C
ATOM   2151  CB  TYR   283      36.098  -5.459   5.218  1.00 43.57           C
ATOM   2152  CG  TYR   283      36.623  -6.126   6.475  1.00 43.49           C
ATOM   2153  CD1 TYR   283      37.888  -6.725   6.502  1.00 44.00           C
ATOM   2154  CE1 TYR   283      38.382  -7.329   7.668  1.00 44.11           C
ATOM   2155  CZ  TYR   283      37.601  -7.329   8.821  1.00 43.93           C
ATOM   2156  OH  TYR   283      38.071  -7.916   9.980  1.00 43.43           O
ATOM   2157  CE2 TYR   283      36.347  -6.732   8.815  1.00 43.35           C
ATOM   2158  CD2 TYR   283      35.869  -6.132   7.648  1.00 43.24           C
ATOM   2159  C   TYR   283      36.341  -3.491   3.603  1.00 44.02           C
ATOM   2160  O   TYR   283      36.228  -4.207   2.599  1.00 44.17           O
ATOM   2161  N   SER   284      36.160  -2.171   3.580  1.00 44.15           N
ATOM   2162  CA  SER   284      35.769  -1.450   2.370  1.00 44.18           C
ATOM   2163  CB  SER   284      34.509  -0.631   2.633  1.00 44.21           C
ATOM   2164  C   SER   284      36.896  -0.556   1.857  1.00 44.08           C
ATOM   2165  O   SER   284      37.955  -1.040   1.452  0.50 44.05           O
END
