
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  107 ( 1653),  selected  107 , name 1dby_A
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 1dby_A.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    E     2_A      -       -           -
LGA    A     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    A     5_A      -       -           -
LGA    V     6_A      -       -           -
LGA    N     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    D     9_A      -       -           -
LGA    T    10_A      -       -           -
LGA    F    11_A      -       -           -
LGA    K    12_A      -       -           -
LGA    N    13_A      -       -           -
LGA    V    14_A      -       -           -
LGA    V    15_A      -       -           -
LGA    L    16_A      -       -           -
LGA    E    17_A      -       -           -
LGA    S    18_A      -       -           -
LGA    S    19_A      -       -           -
LGA    V    20_A      T      12          1.693
LGA    P    21_A      H      13          1.320
LGA    V    22_A      R      14          1.170
LGA    L    23_A      V      15          1.179
LGA    V    24_A      Q      16          0.796
LGA    D    25_A      I      17          0.795
LGA    F    26_A      E      18          1.117
LGA    W    27_A      Y      19          1.845
LGA    A    28_A      C      20          3.667
LGA    P    29_A      T      21          2.822
LGA    W    30_A      Q      22          1.631
LGA    C    31_A      C      23          2.727
LGA    G    32_A      R      24          3.698
LGA    P    33_A      W      25          4.410
LGA    C    34_A      -       -           -
LGA    R    35_A      L      26          2.721
LGA    I    36_A      P      27          4.236
LGA    I    37_A      R      28          2.588
LGA    A    38_A      A      29          1.813
LGA    -       -      A      30           -
LGA    P    39_A      W      31          0.637
LGA    V    40_A      L      32          2.245
LGA    V    41_A      A      33          2.501
LGA    D    42_A      Q      34          1.993
LGA    E    43_A      E      35          2.382
LGA    I    44_A      L      36          1.766
LGA    A    45_A      L      37          1.685
LGA    G    46_A      T      38          2.215
LGA    E    47_A      T      39          1.769
LGA    Y    48_A      F      40          0.497
LGA    K    49_A      E      41          0.830
LGA    D    50_A      T      42          3.337
LGA    K    51_A      E      43          2.336
LGA    L    52_A      L      44          2.042
LGA    -       -      T      45           -
LGA    K    53_A      E      46          2.009
LGA    C    54_A      L      47          1.294
LGA    V    55_A      A      48          0.956
LGA    K    56_A      L      49          0.231
LGA    L    57_A      K      50          0.812
LGA    N    58_A      P      51          1.503
LGA    T    59_A      G      52          2.289
LGA    D    60_A      T      53          4.864
LGA    E    61_A      G      54           -
LGA    S    62_A      -       -           -
LGA    P    63_A      -       -           -
LGA    N    64_A      -       -           -
LGA    V    65_A      -       -           -
LGA    A    66_A      -       -           -
LGA    S    67_A      -       -           -
LGA    E    68_A      -       -           -
LGA    Y    69_A      -       -           -
LGA    G    70_A      -       -           -
LGA    I    71_A      -       -           -
LGA    R    72_A      -       -           -
LGA    S    73_A      G      55          4.041
LGA    I    74_A      V      56          1.041
LGA    P    75_A      F      57          0.602
LGA    T    76_A      V      58          1.414
LGA    I    77_A      V      59          1.351
LGA    M    78_A      R      60          1.430
LGA    V    79_A      V      61          1.312
LGA    F    80_A      D      62          0.391
LGA    K    81_A      -       -           -
LGA    G    82_A      -       -           -
LGA    G    83_A      -       -           -
LGA    K    84_A      -       -           -
LGA    K    85_A      D      63          2.182
LGA    C    86_A      E      64          3.008
LGA    E    87_A      V      65          3.291
LGA    T    88_A      V      66          2.920
LGA    I    89_A      W      67          0.891
LGA    I    90_A      D      68          0.996
LGA    G    91_A      R      69          1.420
LGA    -       -      R      70           -
LGA    -       -      E      71           -
LGA    -       -      Q      72           -
LGA    -       -      G      73           -
LGA    A    92_A      F      74          2.076
LGA    V    93_A      P      75          1.468
LGA    P    94_A      E      76          0.920
LGA    K    95_A      P      77          0.543
LGA    A    96_A      T      78          0.824
LGA    T    97_A      A      79          0.666
LGA    I    98_A      V      80          1.296
LGA    V    99_A      K      81          1.205
LGA    Q   100_A      R      82          0.940
LGA    T   101_A      L      83          1.128
LGA    V   102_A      V      84          0.952
LGA    E   103_A      R      85          1.013
LGA    K   104_A      D      86          1.282
LGA    Y   105_A      R      87          1.231
LGA    L   106_A      V      88          1.046
LGA    N   107_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  107   77    5.0     70    2.04     8.57     73.435     3.270

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.936139 * X  +   0.338407 * Y  +  -0.095520 * Z  +  22.823633
  Y_new =   0.139223 * X  +   0.107264 * Y  +  -0.984435 * Z  + 108.723534
  Z_new =  -0.322894 * X  +  -0.934866 * Y  +  -0.147528 * Z  + -13.033039 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.727312    1.414281  [ DEG:   -98.9677     81.0323 ]
  Theta =   0.328785    2.812807  [ DEG:    18.8380    161.1620 ]
  Phi   =   2.993955   -0.147638  [ DEG:   171.5410     -8.4590 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1dby_A                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1dby_A.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  107   77   5.0   70   2.04    8.57  73.435
REMARK  ---------------------------------------------------------- 
MOLECULE 1dby_A
HEADER    OXIDOREDUCTASE                          03-NOV-99   1DBY              
TITLE     NMR STRUCTURES OF CHLOROPLAST THIOREDOXIN M CH2 FROM THE              
TITLE    2 GREEN ALGA CHLAMYDOMONAS REINHARDTII                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CHLOROPLAST THIOREDOXIN M CH2;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CHLAMYDOMONAS REINHARDTII;                      
SOURCE   3 ORGANELLE: CHLOROPLAST;                                              
SOURCE   4 GENE: NUCLEAR;                                                       
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR: PET3                                       
KEYWDS    THIOREDOXIN M, THIOREDOXIN CH2, CHLOROPLASTIC THIOREDOXIN             
EXPDTA    NMR, 28 STRUCTURES                                                    
AUTHOR    J.-M.LANCELIN,L.GUILHAUDIS,I.KRIMM,M.J.BLACKLEDGE,D.MARION            
REVDAT   4   01-APR-03 1DBY    1       JRNL                                     
REVDAT   3   23-MAY-01 1DBY    1       REMARK DBREF  SEQADV                     
REVDAT   2   09-OCT-00 1DBY    1       JRNL                                     
REVDAT   1   08-NOV-99 1DBY    0                                                
JRNL        AUTH   J.M.LANCELIN,L.GUILHAUDIS,I.KRIMM,M.J.BLACKLEDGE,            
JRNL        AUTH 2 D.MARION,J.P.JACQUOT                                         
JRNL        TITL   NMR STRUCTURES OF THIOREDOXIN M FROM THE GREEN               
JRNL        TITL 2 ALGA CHLAMYDOMONAS REINHARDTII.                              
JRNL        REF    PROTEINS                      V.  41   334 2000              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1DBY A    1   107  UNP    P23400   TRXM_CHLRE       1    107             
SEQRES   1 A  107  MET GLU ALA GLY ALA VAL ASN ASP ASP THR PHE LYS ASN          
SEQRES   2 A  107  VAL VAL LEU GLU SER SER VAL PRO VAL LEU VAL ASP PHE          
SEQRES   3 A  107  TRP ALA PRO TRP CYS GLY PRO CYS ARG ILE ILE ALA PRO          
SEQRES   4 A  107  VAL VAL ASP GLU ILE ALA GLY GLU TYR LYS ASP LYS LEU          
SEQRES   5 A  107  LYS CYS VAL LYS LEU ASN THR ASP GLU SER PRO ASN VAL          
SEQRES   6 A  107  ALA SER GLU TYR GLY ILE ARG SER ILE PRO THR ILE MET          
SEQRES   7 A  107  VAL PHE LYS GLY GLY LYS LYS CYS GLU THR ILE ILE GLY          
SEQRES   8 A  107  ALA VAL PRO LYS ALA THR ILE VAL GLN THR VAL GLU LYS          
SEQRES   9 A  107  TYR LEU ASN                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      32.201 114.699 -11.514  1.00  0.00           N  
ATOM      2  CA  MET A   1      32.067 116.053 -10.934  1.00  0.00           C  
ATOM      3  C   MET A   1      30.618 116.246 -10.485  1.00  0.00           C  
ATOM      4  O   MET A   1      29.824 115.334 -10.691  1.00  0.00           O  
ATOM      5  CB  MET A   1      32.570 117.167 -11.874  1.00  0.00           C  
ATOM      6  CG  MET A   1      31.577 117.643 -12.943  1.00  0.00           C  
ATOM      7  SD  MET A   1      30.931 116.359 -14.024  1.00  0.00           S  
ATOM      8  CE  MET A   1      32.384 115.999 -15.031  1.00  0.00           C  
ATOM      9  HA  MET A   1      32.683 116.083 -10.035  1.00  0.00           H  
ATOM     10  HB2 MET A   1      32.820 118.036 -11.263  1.00  0.00           H  
ATOM     11  HB3 MET A   1      33.486 116.838 -12.361  1.00  0.00           H  
ATOM     12  HG2 MET A   1      30.719 118.115 -12.469  1.00  0.00           H  
ATOM     13  HG3 MET A   1      32.062 118.398 -13.562  1.00  0.00           H  
ATOM     14  HE1 MET A   1      33.186 115.631 -14.395  1.00  0.00           H  
ATOM     15  HE2 MET A   1      32.708 116.903 -15.548  1.00  0.00           H  
ATOM     16  HE3 MET A   1      32.130 115.236 -15.765  1.00  0.00           H  
ATOM     17  H1  MET A   1      31.553 114.531 -12.280  1.00  0.00           H  
ATOM     18  H2  MET A   1      31.899 114.073 -10.774  1.00  0.00           H  
ATOM     19  H3  MET A   1      33.135 114.391 -11.745  1.00  0.00           H  
ATOM     20  N   GLU A   2      30.281 117.384  -9.870  1.00  0.00           N  
ATOM     21  CA  GLU A   2      28.948 117.660  -9.344  1.00  0.00           C  
ATOM     22  C   GLU A   2      27.833 117.268 -10.329  1.00  0.00           C  
ATOM     23  O   GLU A   2      27.935 117.512 -11.532  1.00  0.00           O  
ATOM     24  CB  GLU A   2      28.835 119.134  -8.909  1.00  0.00           C  
ATOM     25  CG  GLU A   2      28.983 120.193 -10.019  1.00  0.00           C  
ATOM     26  CD  GLU A   2      30.382 120.298 -10.624  1.00  0.00           C  
ATOM     27  OE1 GLU A   2      31.346 119.916  -9.924  1.00  0.00           O  
ATOM     28  OE2 GLU A   2      30.465 120.745 -11.788  1.00  0.00           O  
ATOM     29  H   GLU A   2      30.979 118.111  -9.756  1.00  0.00           H  
ATOM     30  HA  GLU A   2      28.830 117.043  -8.451  1.00  0.00           H  
ATOM     31  HB2 GLU A   2      27.845 119.260  -8.465  1.00  0.00           H  
ATOM     32  HB3 GLU A   2      29.567 119.331  -8.124  1.00  0.00           H  
ATOM     33  HG2 GLU A   2      28.264 119.998 -10.816  1.00  0.00           H  
ATOM     34  HG3 GLU A   2      28.747 121.167  -9.590  1.00  0.00           H  
ATOM     35  N   ALA A   3      26.782 116.640  -9.800  1.00  0.00           N  
ATOM     36  CA  ALA A   3      25.662 116.114 -10.557  1.00  0.00           C  
ATOM     37  C   ALA A   3      24.772 117.196 -11.172  1.00  0.00           C  
ATOM     38  O   ALA A   3      24.211 118.017 -10.448  1.00  0.00           O  
ATOM     39  CB  ALA A   3      24.831 115.225  -9.633  1.00  0.00           C  
ATOM     40  H   ALA A   3      26.776 116.473  -8.799  1.00  0.00           H  
ATOM     41  HA  ALA A   3      26.082 115.511 -11.348  1.00  0.00           H  
ATOM     42  HB1 ALA A   3      24.364 115.832  -8.856  1.00  0.00           H  
ATOM     43  HB2 ALA A   3      25.471 114.486  -9.158  1.00  0.00           H  
ATOM     44  HB3 ALA A   3      24.065 114.719 -10.220  1.00  0.00           H  
ATOM     45  N   GLY A   4      24.593 117.164 -12.497  1.00  0.00           N  
ATOM     46  CA  GLY A   4      23.719 118.098 -13.197  1.00  0.00           C  
ATOM     47  C   GLY A   4      22.265 117.608 -13.201  1.00  0.00           C  
ATOM     48  O   GLY A   4      21.915 116.635 -12.532  1.00  0.00           O  
ATOM     49  H   GLY A   4      25.051 116.434 -13.040  1.00  0.00           H  
ATOM     50  HA2 GLY A   4      23.766 119.085 -12.735  1.00  0.00           H  
ATOM     51  HA3 GLY A   4      24.065 118.183 -14.227  1.00  0.00           H  
ATOM     52  N   ALA A   5      21.409 118.260 -13.990  1.00  0.00           N  
ATOM     53  CA  ALA A   5      20.009 117.894 -14.166  1.00  0.00           C  
ATOM     54  C   ALA A   5      19.760 117.731 -15.662  1.00  0.00           C  
ATOM     55  O   ALA A   5      20.323 118.493 -16.448  1.00  0.00           O  
ATOM     56  CB  ALA A   5      19.112 118.984 -13.574  1.00  0.00           C  
ATOM     57  H   ALA A   5      21.750 119.002 -14.586  1.00  0.00           H  
ATOM     58  HA  ALA A   5      19.786 116.956 -13.659  1.00  0.00           H  
ATOM     59  HB1 ALA A   5      19.311 119.084 -12.506  1.00  0.00           H  
ATOM     60  HB2 ALA A   5      18.065 118.710 -13.716  1.00  0.00           H  
ATOM     61  HB3 ALA A   5      19.302 119.937 -14.067  1.00  0.00           H  
ATOM     62  N   VAL A   6      18.958 116.740 -16.058  1.00  0.00           N  
ATOM     63  CA  VAL A   6      18.640 116.474 -17.457  1.00  0.00           C  
ATOM     64  C   VAL A   6      17.160 116.155 -17.617  1.00  0.00           C  
ATOM     65  O   VAL A   6      16.448 115.872 -16.656  1.00  0.00           O  
ATOM     66  CB  VAL A   6      19.482 115.306 -18.014  1.00  0.00           C  
ATOM     67  CG1 VAL A   6      20.823 115.801 -18.554  1.00  0.00           C  
ATOM     68  CG2 VAL A   6      19.684 114.180 -16.995  1.00  0.00           C  
ATOM     69  H   VAL A   6      18.511 116.147 -15.362  1.00  0.00           H  
ATOM     70  HA  VAL A   6      18.837 117.366 -18.051  1.00  0.00           H  
ATOM     71  HB  VAL A   6      18.969 114.866 -18.871  1.00  0.00           H  
ATOM     72 HG11 VAL A   6      20.652 116.403 -19.445  1.00  0.00           H  
ATOM     73 HG12 VAL A   6      21.443 114.947 -18.825  1.00  0.00           H  
ATOM     74 HG13 VAL A   6      21.330 116.410 -17.809  1.00  0.00           H  
ATOM     75 HG21 VAL A   6      20.189 113.336 -17.468  1.00  0.00           H  
ATOM     76 HG22 VAL A   6      20.280 114.522 -16.153  1.00  0.00           H  
ATOM     77 HG23 VAL A   6      18.716 113.854 -16.629  1.00  0.00           H  
ATOM     78  N   ASN A   7      16.727 116.197 -18.875  1.00  0.00           N  
ATOM     79  CA  ASN A   7      15.405 115.832 -19.354  1.00  0.00           C  
ATOM     80  C   ASN A   7      15.612 115.251 -20.742  1.00  0.00           C  
ATOM     81  O   ASN A   7      16.742 115.245 -21.223  1.00  0.00           O  
ATOM     82  CB  ASN A   7      14.458 117.035 -19.373  1.00  0.00           C  
ATOM     83  CG  ASN A   7      13.881 117.296 -17.988  1.00  0.00           C  
ATOM     84  OD1 ASN A   7      14.088 118.355 -17.406  1.00  0.00           O  
ATOM     85  ND2 ASN A   7      13.135 116.327 -17.466  1.00  0.00           N  
ATOM     86  H   ASN A   7      17.410 116.399 -19.607  1.00  0.00           H  
ATOM     87  HA  ASN A   7      14.994 115.049 -18.726  1.00  0.00           H  
ATOM     88  HB2 ASN A   7      14.981 117.909 -19.757  1.00  0.00           H  
ATOM     89  HB3 ASN A   7      13.613 116.839 -20.032  1.00  0.00           H  
ATOM     90 HD21 ASN A   7      12.983 115.473 -17.989  1.00  0.00           H  
ATOM     91 HD22 ASN A   7      12.700 116.470 -16.569  1.00  0.00           H  
ATOM     92  N   ASP A   8      14.543 114.775 -21.381  1.00  0.00           N  
ATOM     93  CA  ASP A   8      14.597 114.134 -22.696  1.00  0.00           C  
ATOM     94  C   ASP A   8      15.582 114.822 -23.643  1.00  0.00           C  
ATOM     95  O   ASP A   8      16.522 114.207 -24.137  1.00  0.00           O  
ATOM     96  CB  ASP A   8      13.202 114.144 -23.327  1.00  0.00           C  
ATOM     97  CG  ASP A   8      13.206 113.415 -24.667  1.00  0.00           C  
ATOM     98  OD1 ASP A   8      13.633 114.037 -25.662  1.00  0.00           O  
ATOM     99  OD2 ASP A   8      12.776 112.240 -24.680  1.00  0.00           O  
ATOM    100  H   ASP A   8      13.670 114.787 -20.864  1.00  0.00           H  
ATOM    101  HA  ASP A   8      14.918 113.103 -22.565  1.00  0.00           H  
ATOM    102  HB2 ASP A   8      12.500 113.663 -22.652  1.00  0.00           H  
ATOM    103  HB3 ASP A   8      12.858 115.166 -23.491  1.00  0.00           H  
ATOM    104  N   ASP A   9      15.355 116.111 -23.873  1.00  0.00           N  
ATOM    105  CA  ASP A   9      16.128 116.940 -24.782  1.00  0.00           C  
ATOM    106  C   ASP A   9      17.618 116.943 -24.430  1.00  0.00           C  
ATOM    107  O   ASP A   9      18.460 116.587 -25.251  1.00  0.00           O  
ATOM    108  CB  ASP A   9      15.567 118.369 -24.737  1.00  0.00           C  
ATOM    109  CG  ASP A   9      14.067 118.420 -25.007  1.00  0.00           C  
ATOM    110  OD1 ASP A   9      13.324 117.965 -24.108  1.00  0.00           O  
ATOM    111  OD2 ASP A   9      13.694 118.913 -26.093  1.00  0.00           O  
ATOM    112  H   ASP A   9      14.505 116.502 -23.485  1.00  0.00           H  
ATOM    113  HA  ASP A   9      16.010 116.548 -25.794  1.00  0.00           H  
ATOM    114  HB2 ASP A   9      15.745 118.816 -23.759  1.00  0.00           H  
ATOM    115  HB3 ASP A   9      16.082 118.967 -25.487  1.00  0.00           H  
ATOM    116  N   THR A  10      17.951 117.364 -23.209  1.00  0.00           N  
ATOM    117  CA  THR A  10      19.326 117.514 -22.764  1.00  0.00           C  
ATOM    118  C   THR A  10      20.036 116.162 -22.657  1.00  0.00           C  
ATOM    119  O   THR A  10      21.223 116.079 -22.961  1.00  0.00           O  
ATOM    120  CB  THR A  10      19.314 118.280 -21.435  1.00  0.00           C  
ATOM    121  OG1 THR A  10      18.290 117.781 -20.593  1.00  0.00           O  
ATOM    122  CG2 THR A  10      19.033 119.764 -21.687  1.00  0.00           C  
ATOM    123  H   THR A  10      17.234 117.546 -22.520  1.00  0.00           H  
ATOM    124  HA  THR A  10      19.876 118.101 -23.499  1.00  0.00           H  
ATOM    125  HB  THR A  10      20.288 118.189 -20.950  1.00  0.00           H  
ATOM    126  HG1 THR A  10      18.186 118.397 -19.861  1.00  0.00           H  
ATOM    127 HG21 THR A  10      18.059 119.892 -22.162  1.00  0.00           H  
ATOM    128 HG22 THR A  10      19.803 120.182 -22.338  1.00  0.00           H  
ATOM    129 HG23 THR A  10      19.043 120.311 -20.744  1.00  0.00           H  
ATOM    130  N   PHE A  11      19.317 115.114 -22.249  1.00  0.00           N  
ATOM    131  CA  PHE A  11      19.814 113.747 -22.110  1.00  0.00           C  
ATOM    132  C   PHE A  11      20.626 113.334 -23.332  1.00  0.00           C  
ATOM    133  O   PHE A  11      21.714 112.777 -23.230  1.00  0.00           O  
ATOM    134  CB  PHE A  11      18.621 112.802 -21.958  1.00  0.00           C  
ATOM    135  CG  PHE A  11      18.981 111.348 -21.758  1.00  0.00           C  
ATOM    136  CD1 PHE A  11      19.261 110.862 -20.471  1.00  0.00           C  
ATOM    137  CD2 PHE A  11      19.054 110.480 -22.864  1.00  0.00           C  
ATOM    138  CE1 PHE A  11      19.630 109.519 -20.290  1.00  0.00           C  
ATOM    139  CE2 PHE A  11      19.427 109.139 -22.684  1.00  0.00           C  
ATOM    140  CZ  PHE A  11      19.746 108.665 -21.399  1.00  0.00           C  
ATOM    141  H   PHE A  11      18.348 115.287 -22.015  1.00  0.00           H  
ATOM    142  HA  PHE A  11      20.435 113.694 -21.217  1.00  0.00           H  
ATOM    143  HB2 PHE A  11      18.020 113.142 -21.127  1.00  0.00           H  
ATOM    144  HB3 PHE A  11      18.000 112.871 -22.844  1.00  0.00           H  
ATOM    145  HD1 PHE A  11      19.226 111.529 -19.620  1.00  0.00           H  
ATOM    146  HD2 PHE A  11      18.830 110.841 -23.857  1.00  0.00           H  
ATOM    147  HE1 PHE A  11      19.856 109.151 -19.302  1.00  0.00           H  
ATOM    148  HE2 PHE A  11      19.469 108.485 -23.540  1.00  0.00           H  
ATOM    149  HZ  PHE A  11      20.095 107.654 -21.254  1.00  0.00           H  
ATOM    150  N   LYS A  12      20.071 113.602 -24.508  1.00  0.00           N  
ATOM    151  CA  LYS A  12      20.722 113.298 -25.777  1.00  0.00           C  
ATOM    152  C   LYS A  12      22.167 113.825 -25.770  1.00  0.00           C  
ATOM    153  O   LYS A  12      23.119 113.075 -25.965  1.00  0.00           O  
ATOM    154  CB  LYS A  12      19.922 113.905 -26.940  1.00  0.00           C  
ATOM    155  CG  LYS A  12      18.435 113.518 -26.954  1.00  0.00           C  
ATOM    156  CD  LYS A  12      18.186 112.013 -27.123  1.00  0.00           C  
ATOM    157  CE  LYS A  12      16.684 111.699 -27.157  1.00  0.00           C  
ATOM    158  NZ  LYS A  12      16.039 111.924 -25.851  1.00  0.00           N  
ATOM    159  H   LYS A  12      19.159 114.033 -24.462  1.00  0.00           H  
ATOM    160  HA  LYS A  12      20.763 112.215 -25.897  1.00  0.00           H  
ATOM    161  HB2 LYS A  12      19.977 114.994 -26.878  1.00  0.00           H  
ATOM    162  HB3 LYS A  12      20.385 113.599 -27.878  1.00  0.00           H  
ATOM    163  HG2 LYS A  12      17.968 113.862 -26.036  1.00  0.00           H  
ATOM    164  HG3 LYS A  12      17.961 114.049 -27.782  1.00  0.00           H  
ATOM    165  HD2 LYS A  12      18.637 111.687 -28.063  1.00  0.00           H  
ATOM    166  HD3 LYS A  12      18.640 111.461 -26.302  1.00  0.00           H  
ATOM    167  HE2 LYS A  12      16.193 112.317 -27.909  1.00  0.00           H  
ATOM    168  HE3 LYS A  12      16.545 110.651 -27.429  1.00  0.00           H  
ATOM    169  HZ1 LYS A  12      16.172 112.884 -25.553  1.00  0.00           H  
ATOM    170  HZ2 LYS A  12      15.047 111.743 -25.924  1.00  0.00           H  
ATOM    171  HZ3 LYS A  12      16.439 111.308 -25.159  1.00  0.00           H  
ATOM    172  N   ASN A  13      22.329 115.120 -25.502  1.00  0.00           N  
ATOM    173  CA  ASN A  13      23.625 115.786 -25.455  1.00  0.00           C  
ATOM    174  C   ASN A  13      24.477 115.279 -24.295  1.00  0.00           C  
ATOM    175  O   ASN A  13      25.570 114.749 -24.478  1.00  0.00           O  
ATOM    176  CB  ASN A  13      23.410 117.302 -25.291  1.00  0.00           C  
ATOM    177  CG  ASN A  13      23.330 118.081 -26.605  1.00  0.00           C  
ATOM    178  OD1 ASN A  13      23.562 119.284 -26.617  1.00  0.00           O  
ATOM    179  ND2 ASN A  13      22.998 117.440 -27.724  1.00  0.00           N  
ATOM    180  H   ASN A  13      21.504 115.646 -25.244  1.00  0.00           H  
ATOM    181  HA  ASN A  13      24.185 115.596 -26.368  1.00  0.00           H  
ATOM    182  HB2 ASN A  13      22.494 117.495 -24.733  1.00  0.00           H  
ATOM    183  HB3 ASN A  13      24.232 117.710 -24.695  1.00  0.00           H  
ATOM    184 HD21 ASN A  13      22.854 116.434 -27.753  1.00  0.00           H  
ATOM    185 HD22 ASN A  13      22.957 117.976 -28.577  1.00  0.00           H  
ATOM    186  N   VAL A  14      23.966 115.494 -23.089  1.00  0.00           N  
ATOM    187  CA  VAL A  14      24.646 115.266 -21.829  1.00  0.00           C  
ATOM    188  C   VAL A  14      24.966 113.791 -21.579  1.00  0.00           C  
ATOM    189  O   VAL A  14      25.927 113.501 -20.868  1.00  0.00           O  
ATOM    190  CB  VAL A  14      23.750 115.875 -20.733  1.00  0.00           C  
ATOM    191  CG1 VAL A  14      24.283 115.618 -19.325  1.00  0.00           C  
ATOM    192  CG2 VAL A  14      23.621 117.397 -20.918  1.00  0.00           C  
ATOM    193  H   VAL A  14      23.022 115.862 -23.048  1.00  0.00           H  
ATOM    194  HA  VAL A  14      25.614 115.773 -21.843  1.00  0.00           H  
ATOM    195  HB  VAL A  14      22.757 115.431 -20.802  1.00  0.00           H  
ATOM    196 HG11 VAL A  14      24.184 114.561 -19.081  1.00  0.00           H  
ATOM    197 HG12 VAL A  14      23.701 116.199 -18.613  1.00  0.00           H  
ATOM    198 HG13 VAL A  14      25.327 115.921 -19.272  1.00  0.00           H  
ATOM    199 HG21 VAL A  14      22.982 117.811 -20.140  1.00  0.00           H  
ATOM    200 HG22 VAL A  14      24.605 117.861 -20.852  1.00  0.00           H  
ATOM    201 HG23 VAL A  14      23.179 117.643 -21.884  1.00  0.00           H  
ATOM    202  N   VAL A  15      24.183 112.869 -22.142  1.00  0.00           N  
ATOM    203  CA  VAL A  15      24.344 111.441 -21.925  1.00  0.00           C  
ATOM    204  C   VAL A  15      24.727 110.740 -23.229  1.00  0.00           C  
ATOM    205  O   VAL A  15      25.888 110.386 -23.383  1.00  0.00           O  
ATOM    206  CB  VAL A  15      23.076 110.851 -21.278  1.00  0.00           C  
ATOM    207  CG1 VAL A  15      23.360 109.428 -20.783  1.00  0.00           C  
ATOM    208  CG2 VAL A  15      22.602 111.734 -20.116  1.00  0.00           C  
ATOM    209  H   VAL A  15      23.403 113.166 -22.715  1.00  0.00           H  
ATOM    210  HA  VAL A  15      25.160 111.261 -21.227  1.00  0.00           H  
ATOM    211  HB  VAL A  15      22.265 110.788 -21.997  1.00  0.00           H  
ATOM    212 HG11 VAL A  15      24.149 109.436 -20.030  1.00  0.00           H  
ATOM    213 HG12 VAL A  15      22.458 109.003 -20.346  1.00  0.00           H  
ATOM    214 HG13 VAL A  15      23.670 108.794 -21.613  1.00  0.00           H  
ATOM    215 HG21 VAL A  15      23.406 111.892 -19.402  1.00  0.00           H  
ATOM    216 HG22 VAL A  15      21.762 111.267 -19.611  1.00  0.00           H  
ATOM    217 HG23 VAL A  15      22.271 112.703 -20.484  1.00  0.00           H  
ATOM    218  N   LEU A  16      23.808 110.542 -24.176  1.00  0.00           N  
ATOM    219  CA  LEU A  16      24.070 109.747 -25.379  1.00  0.00           C  
ATOM    220  C   LEU A  16      25.295 110.222 -26.158  1.00  0.00           C  
ATOM    221  O   LEU A  16      26.073 109.402 -26.638  1.00  0.00           O  
ATOM    222  CB  LEU A  16      22.850 109.743 -26.307  1.00  0.00           C  
ATOM    223  CG  LEU A  16      21.594 109.102 -25.701  1.00  0.00           C  
ATOM    224  CD1 LEU A  16      20.504 109.054 -26.776  1.00  0.00           C  
ATOM    225  CD2 LEU A  16      21.852 107.678 -25.191  1.00  0.00           C  
ATOM    226  H   LEU A  16      22.903 110.966 -24.060  1.00  0.00           H  
ATOM    227  HA  LEU A  16      24.282 108.724 -25.074  1.00  0.00           H  
ATOM    228  HB2 LEU A  16      22.616 110.761 -26.609  1.00  0.00           H  
ATOM    229  HB3 LEU A  16      23.134 109.199 -27.206  1.00  0.00           H  
ATOM    230  HG  LEU A  16      21.241 109.720 -24.875  1.00  0.00           H  
ATOM    231 HD11 LEU A  16      20.795 108.367 -27.571  1.00  0.00           H  
ATOM    232 HD12 LEU A  16      19.564 108.717 -26.339  1.00  0.00           H  
ATOM    233 HD13 LEU A  16      20.363 110.046 -27.203  1.00  0.00           H  
ATOM    234 HD21 LEU A  16      22.438 107.703 -24.272  1.00  0.00           H  
ATOM    235 HD22 LEU A  16      20.904 107.184 -24.982  1.00  0.00           H  
ATOM    236 HD23 LEU A  16      22.386 107.100 -25.946  1.00  0.00           H  
ATOM    237  N   GLU A  17      25.459 111.535 -26.307  1.00  0.00           N  
ATOM    238  CA  GLU A  17      26.571 112.133 -27.028  1.00  0.00           C  
ATOM    239  C   GLU A  17      27.745 112.476 -26.092  1.00  0.00           C  
ATOM    240  O   GLU A  17      28.607 113.266 -26.472  1.00  0.00           O  
ATOM    241  CB  GLU A  17      26.046 113.395 -27.724  1.00  0.00           C  
ATOM    242  CG  GLU A  17      24.902 113.116 -28.714  1.00  0.00           C  
ATOM    243  CD  GLU A  17      24.257 114.415 -29.190  1.00  0.00           C  
ATOM    244  OE1 GLU A  17      24.833 115.029 -30.112  1.00  0.00           O  
ATOM    245  OE2 GLU A  17      23.206 114.781 -28.616  1.00  0.00           O  
ATOM    246  H   GLU A  17      24.717 112.148 -25.992  1.00  0.00           H  
ATOM    247  HA  GLU A  17      26.943 111.450 -27.793  1.00  0.00           H  
ATOM    248  HB2 GLU A  17      25.707 114.088 -26.958  1.00  0.00           H  
ATOM    249  HB3 GLU A  17      26.863 113.867 -28.262  1.00  0.00           H  
ATOM    250  HG2 GLU A  17      25.298 112.575 -29.574  1.00  0.00           H  
ATOM    251  HG3 GLU A  17      24.127 112.504 -28.256  1.00  0.00           H  
ATOM    252  N   SER A  18      27.802 111.918 -24.876  1.00  0.00           N  
ATOM    253  CA  SER A  18      28.869 112.251 -23.937  1.00  0.00           C  
ATOM    254  C   SER A  18      30.209 111.629 -24.350  1.00  0.00           C  
ATOM    255  O   SER A  18      30.259 110.564 -24.964  1.00  0.00           O  
ATOM    256  CB  SER A  18      28.478 111.796 -22.528  1.00  0.00           C  
ATOM    257  OG  SER A  18      28.411 110.385 -22.454  1.00  0.00           O  
ATOM    258  H   SER A  18      27.091 111.261 -24.579  1.00  0.00           H  
ATOM    259  HA  SER A  18      28.980 113.337 -23.917  1.00  0.00           H  
ATOM    260  HB2 SER A  18      29.200 112.178 -21.805  1.00  0.00           H  
ATOM    261  HB3 SER A  18      27.508 112.221 -22.273  1.00  0.00           H  
ATOM    262  HG  SER A  18      27.523 110.122 -22.730  1.00  0.00           H  
ATOM    263  N   SER A  19      31.304 112.309 -24.002  1.00  0.00           N  
ATOM    264  CA  SER A  19      32.672 111.879 -24.236  1.00  0.00           C  
ATOM    265  C   SER A  19      33.171 111.114 -23.009  1.00  0.00           C  
ATOM    266  O   SER A  19      33.563 109.954 -23.092  1.00  0.00           O  
ATOM    267  CB  SER A  19      33.501 113.144 -24.474  1.00  0.00           C  
ATOM    268  OG  SER A  19      33.098 114.135 -23.537  1.00  0.00           O  
ATOM    269  H   SER A  19      31.221 113.206 -23.544  1.00  0.00           H  
ATOM    270  HA  SER A  19      32.738 111.234 -25.114  1.00  0.00           H  
ATOM    271  HB2 SER A  19      34.565 112.919 -24.372  1.00  0.00           H  
ATOM    272  HB3 SER A  19      33.310 113.508 -25.484  1.00  0.00           H  
ATOM    273  HG  SER A  19      33.585 114.947 -23.711  1.00  0.00           H  
ATOM    274  N   VAL A  20      33.149 111.803 -21.868  1.00  0.00           N  
ATOM    275  CA  VAL A  20      33.534 111.281 -20.560  1.00  0.00           C  
ATOM    276  C   VAL A  20      32.384 110.429 -20.002  1.00  0.00           C  
ATOM    277  O   VAL A  20      31.259 110.539 -20.494  1.00  0.00           O  
ATOM    278  CB  VAL A  20      33.842 112.445 -19.587  1.00  0.00           C  
ATOM    279  CG1 VAL A  20      35.344 112.607 -19.348  1.00  0.00           C  
ATOM    280  CG2 VAL A  20      33.223 113.800 -19.959  1.00  0.00           C  
ATOM    281  H   VAL A  20      32.846 112.763 -21.949  1.00  0.00           H  
ATOM    282  HA  VAL A  20      34.417 110.652 -20.667  1.00  0.00           H  
ATOM    283  HB  VAL A  20      33.411 112.196 -18.625  1.00  0.00           H  
ATOM    284 HG11 VAL A  20      35.510 113.408 -18.627  1.00  0.00           H  
ATOM    285 HG12 VAL A  20      35.850 112.852 -20.279  1.00  0.00           H  
ATOM    286 HG13 VAL A  20      35.754 111.682 -18.941  1.00  0.00           H  
ATOM    287 HG21 VAL A  20      32.153 113.687 -20.139  1.00  0.00           H  
ATOM    288 HG22 VAL A  20      33.360 114.495 -19.130  1.00  0.00           H  
ATOM    289 HG23 VAL A  20      33.710 114.220 -20.840  1.00  0.00           H  
ATOM    290  N   PRO A  21      32.644 109.579 -18.990  1.00  0.00           N  
ATOM    291  CA  PRO A  21      31.606 108.797 -18.340  1.00  0.00           C  
ATOM    292  C   PRO A  21      30.470 109.667 -17.807  1.00  0.00           C  
ATOM    293  O   PRO A  21      30.612 110.876 -17.640  1.00  0.00           O  
ATOM    294  CB  PRO A  21      32.282 108.058 -17.186  1.00  0.00           C  
ATOM    295  CG  PRO A  21      33.728 107.948 -17.644  1.00  0.00           C  
ATOM    296  CD  PRO A  21      33.948 109.242 -18.429  1.00  0.00           C  
ATOM    297  HA  PRO A  21      31.211 108.091 -19.069  1.00  0.00           H  
ATOM    298  HB2 PRO A  21      32.254 108.677 -16.290  1.00  0.00           H  
ATOM    299  HB3 PRO A  21      31.833 107.086 -16.982  1.00  0.00           H  
ATOM    300  HG2 PRO A  21      34.384 107.852 -16.785  1.00  0.00           H  
ATOM    301  HG3 PRO A  21      33.836 107.091 -18.309  1.00  0.00           H  
ATOM    302  HD2 PRO A  21      34.276 110.042 -17.780  1.00  0.00           H  
ATOM    303  HD3 PRO A  21      34.733 109.073 -19.158  1.00  0.00           H  
ATOM    304  N   VAL A  22      29.341 109.036 -17.492  1.00  0.00           N  
ATOM    305  CA  VAL A  22      28.153 109.724 -17.008  1.00  0.00           C  
ATOM    306  C   VAL A  22      27.444 108.827 -15.996  1.00  0.00           C  
ATOM    307  O   VAL A  22      27.442 107.610 -16.175  1.00  0.00           O  
ATOM    308  CB  VAL A  22      27.207 110.061 -18.184  1.00  0.00           C  
ATOM    309  CG1 VAL A  22      26.070 111.018 -17.817  1.00  0.00           C  
ATOM    310  CG2 VAL A  22      27.943 110.637 -19.397  1.00  0.00           C  
ATOM    311  H   VAL A  22      29.341 108.022 -17.534  1.00  0.00           H  
ATOM    312  HA  VAL A  22      28.477 110.633 -16.519  1.00  0.00           H  
ATOM    313  HB  VAL A  22      26.715 109.146 -18.493  1.00  0.00           H  
ATOM    314 HG11 VAL A  22      25.570 110.693 -16.908  1.00  0.00           H  
ATOM    315 HG12 VAL A  22      26.439 112.034 -17.695  1.00  0.00           H  
ATOM    316 HG13 VAL A  22      25.343 111.022 -18.625  1.00  0.00           H  
ATOM    317 HG21 VAL A  22      27.213 110.934 -20.146  1.00  0.00           H  
ATOM    318 HG22 VAL A  22      28.602 109.888 -19.836  1.00  0.00           H  
ATOM    319 HG23 VAL A  22      28.529 111.510 -19.115  1.00  0.00           H  
ATOM    320  N   LEU A  23      26.849 109.408 -14.948  1.00  0.00           N  
ATOM    321  CA  LEU A  23      26.058 108.660 -13.966  1.00  0.00           C  
ATOM    322  C   LEU A  23      24.687 109.334 -13.860  1.00  0.00           C  
ATOM    323  O   LEU A  23      24.547 110.340 -13.173  1.00  0.00           O  
ATOM    324  CB  LEU A  23      26.818 108.572 -12.631  1.00  0.00           C  
ATOM    325  CG  LEU A  23      26.119 107.672 -11.594  1.00  0.00           C  
ATOM    326  CD1 LEU A  23      27.122 106.760 -10.875  1.00  0.00           C  
ATOM    327  CD2 LEU A  23      25.408 108.512 -10.527  1.00  0.00           C  
ATOM    328  H   LEU A  23      26.912 110.426 -14.868  1.00  0.00           H  
ATOM    329  HA  LEU A  23      25.903 107.640 -14.310  1.00  0.00           H  
ATOM    330  HB2 LEU A  23      27.780 108.128 -12.869  1.00  0.00           H  
ATOM    331  HB3 LEU A  23      27.006 109.559 -12.210  1.00  0.00           H  
ATOM    332  HG  LEU A  23      25.399 107.029 -12.102  1.00  0.00           H  
ATOM    333 HD11 LEU A  23      27.717 106.203 -11.597  1.00  0.00           H  
ATOM    334 HD12 LEU A  23      26.584 106.049 -10.247  1.00  0.00           H  
ATOM    335 HD13 LEU A  23      27.784 107.349 -10.242  1.00  0.00           H  
ATOM    336 HD21 LEU A  23      26.125 109.185 -10.057  1.00  0.00           H  
ATOM    337 HD22 LEU A  23      24.996 107.871  -9.749  1.00  0.00           H  
ATOM    338 HD23 LEU A  23      24.598 109.089 -10.967  1.00  0.00           H  
ATOM    339  N   VAL A  24      23.679 108.814 -14.567  1.00  0.00           N  
ATOM    340  CA  VAL A  24      22.349 109.415 -14.605  1.00  0.00           C  
ATOM    341  C   VAL A  24      21.457 108.747 -13.567  1.00  0.00           C  
ATOM    342  O   VAL A  24      21.204 107.545 -13.669  1.00  0.00           O  
ATOM    343  CB  VAL A  24      21.717 109.252 -15.999  1.00  0.00           C  
ATOM    344  CG1 VAL A  24      20.361 109.971 -16.061  1.00  0.00           C  
ATOM    345  CG2 VAL A  24      22.620 109.816 -17.101  1.00  0.00           C  
ATOM    346  H   VAL A  24      23.807 107.895 -14.981  1.00  0.00           H  
ATOM    347  HA  VAL A  24      22.417 110.484 -14.402  1.00  0.00           H  
ATOM    348  HB  VAL A  24      21.551 108.193 -16.197  1.00  0.00           H  
ATOM    349 HG11 VAL A  24      19.945 109.893 -17.064  1.00  0.00           H  
ATOM    350 HG12 VAL A  24      19.651 109.519 -15.366  1.00  0.00           H  
ATOM    351 HG13 VAL A  24      20.482 111.025 -15.810  1.00  0.00           H  
ATOM    352 HG21 VAL A  24      22.737 110.891 -16.975  1.00  0.00           H  
ATOM    353 HG22 VAL A  24      23.599 109.341 -17.086  1.00  0.00           H  
ATOM    354 HG23 VAL A  24      22.158 109.616 -18.065  1.00  0.00           H  
ATOM    355  N   ASP A  25      20.945 109.517 -12.602  1.00  0.00           N  
ATOM    356  CA  ASP A  25      20.009 109.023 -11.613  1.00  0.00           C  
ATOM    357  C   ASP A  25      18.603 109.315 -12.121  1.00  0.00           C  
ATOM    358  O   ASP A  25      18.213 110.480 -12.203  1.00  0.00           O  
ATOM    359  CB  ASP A  25      20.250 109.682 -10.250  1.00  0.00           C  
ATOM    360  CG  ASP A  25      19.182 109.281  -9.230  1.00  0.00           C  
ATOM    361  OD1 ASP A  25      18.691 108.134  -9.323  1.00  0.00           O  
ATOM    362  OD2 ASP A  25      18.872 110.135  -8.373  1.00  0.00           O  
ATOM    363  H   ASP A  25      21.136 110.516 -12.590  1.00  0.00           H  
ATOM    364  HA  ASP A  25      20.118 107.951 -11.475  1.00  0.00           H  
ATOM    365  HB2 ASP A  25      21.228 109.385  -9.871  1.00  0.00           H  
ATOM    366  HB3 ASP A  25      20.238 110.763 -10.369  1.00  0.00           H  
ATOM    367  N   PHE A  26      17.834 108.288 -12.478  1.00  0.00           N  
ATOM    368  CA  PHE A  26      16.451 108.492 -12.878  1.00  0.00           C  
ATOM    369  C   PHE A  26      15.702 108.673 -11.560  1.00  0.00           C  
ATOM    370  O   PHE A  26      15.616 107.717 -10.789  1.00  0.00           O  
ATOM    371  CB  PHE A  26      15.924 107.291 -13.673  1.00  0.00           C  
ATOM    372  CG  PHE A  26      16.387 107.215 -15.120  1.00  0.00           C  
ATOM    373  CD1 PHE A  26      17.729 106.916 -15.428  1.00  0.00           C  
ATOM    374  CD2 PHE A  26      15.457 107.386 -16.164  1.00  0.00           C  
ATOM    375  CE1 PHE A  26      18.130 106.764 -16.767  1.00  0.00           C  
ATOM    376  CE2 PHE A  26      15.853 107.206 -17.502  1.00  0.00           C  
ATOM    377  CZ  PHE A  26      17.186 106.874 -17.803  1.00  0.00           C  
ATOM    378  H   PHE A  26      18.184 107.339 -12.389  1.00  0.00           H  
ATOM    379  HA  PHE A  26      16.354 109.378 -13.503  1.00  0.00           H  
ATOM    380  HB2 PHE A  26      16.197 106.373 -13.159  1.00  0.00           H  
ATOM    381  HB3 PHE A  26      14.836 107.347 -13.668  1.00  0.00           H  
ATOM    382  HD1 PHE A  26      18.460 106.795 -14.642  1.00  0.00           H  
ATOM    383  HD2 PHE A  26      14.433 107.651 -15.945  1.00  0.00           H  
ATOM    384  HE1 PHE A  26      19.161 106.543 -16.997  1.00  0.00           H  
ATOM    385  HE2 PHE A  26      15.136 107.327 -18.299  1.00  0.00           H  
ATOM    386  HZ  PHE A  26      17.484 106.702 -18.828  1.00  0.00           H  
ATOM    387  N   TRP A  27      15.230 109.892 -11.283  1.00  0.00           N  
ATOM    388  CA  TRP A  27      14.582 110.245 -10.026  1.00  0.00           C  
ATOM    389  C   TRP A  27      13.190 110.817 -10.266  1.00  0.00           C  
ATOM    390  O   TRP A  27      12.675 110.810 -11.383  1.00  0.00           O  
ATOM    391  CB  TRP A  27      15.442 111.277  -9.273  1.00  0.00           C  
ATOM    392  CG  TRP A  27      15.363 112.668  -9.820  1.00  0.00           C  
ATOM    393  CD1 TRP A  27      15.871 113.064 -11.002  1.00  0.00           C  
ATOM    394  CD2 TRP A  27      14.610 113.807  -9.311  1.00  0.00           C  
ATOM    395  NE1 TRP A  27      15.401 114.321 -11.323  1.00  0.00           N  
ATOM    396  CE2 TRP A  27      14.587 114.813 -10.322  1.00  0.00           C  
ATOM    397  CE3 TRP A  27      13.899 114.078  -8.121  1.00  0.00           C  
ATOM    398  CZ2 TRP A  27      13.842 115.993 -10.182  1.00  0.00           C  
ATOM    399  CZ3 TRP A  27      13.226 115.298  -7.941  1.00  0.00           C  
ATOM    400  CH2 TRP A  27      13.178 116.247  -8.974  1.00  0.00           C  
ATOM    401  H   TRP A  27      15.285 110.601 -12.008  1.00  0.00           H  
ATOM    402  HA  TRP A  27      14.477 109.358  -9.416  1.00  0.00           H  
ATOM    403  HB2 TRP A  27      15.099 111.330  -8.242  1.00  0.00           H  
ATOM    404  HB3 TRP A  27      16.474 110.942  -9.255  1.00  0.00           H  
ATOM    405  HD1 TRP A  27      16.472 112.435 -11.636  1.00  0.00           H  
ATOM    406  HE1 TRP A  27      15.597 114.822 -12.179  1.00  0.00           H  
ATOM    407  HE3 TRP A  27      13.871 113.351  -7.322  1.00  0.00           H  
ATOM    408  HZ2 TRP A  27      13.752 116.693 -10.994  1.00  0.00           H  
ATOM    409  HZ3 TRP A  27      12.718 115.494  -7.011  1.00  0.00           H  
ATOM    410  HH2 TRP A  27      12.631 117.169  -8.837  1.00  0.00           H  
ATOM    411  N   ALA A  28      12.572 111.338  -9.208  1.00  0.00           N  
ATOM    412  CA  ALA A  28      11.304 112.051  -9.258  1.00  0.00           C  
ATOM    413  C   ALA A  28      11.047 112.661  -7.881  1.00  0.00           C  
ATOM    414  O   ALA A  28      11.496 112.097  -6.885  1.00  0.00           O  
ATOM    415  CB  ALA A  28      10.146 111.113  -9.610  1.00  0.00           C  
ATOM    416  H   ALA A  28      13.047 111.309  -8.314  1.00  0.00           H  
ATOM    417  HA  ALA A  28      11.396 112.827 -10.018  1.00  0.00           H  
ATOM    418  HB1 ALA A  28      10.072 110.332  -8.854  1.00  0.00           H  
ATOM    419  HB2 ALA A  28       9.217 111.682  -9.619  1.00  0.00           H  
ATOM    420  HB3 ALA A  28      10.289 110.666 -10.591  1.00  0.00           H  
ATOM    421  N   PRO A  29      10.322 113.781  -7.780  1.00  0.00           N  
ATOM    422  CA  PRO A  29      10.002 114.390  -6.499  1.00  0.00           C  
ATOM    423  C   PRO A  29       9.234 113.446  -5.569  1.00  0.00           C  
ATOM    424  O   PRO A  29       9.412 113.500  -4.355  1.00  0.00           O  
ATOM    425  CB  PRO A  29       9.213 115.654  -6.834  1.00  0.00           C  
ATOM    426  CG  PRO A  29       8.707 115.423  -8.260  1.00  0.00           C  
ATOM    427  CD  PRO A  29       9.851 114.619  -8.867  1.00  0.00           C  
ATOM    428  HA  PRO A  29      10.918 114.671  -5.984  1.00  0.00           H  
ATOM    429  HB2 PRO A  29       8.405 115.825  -6.123  1.00  0.00           H  
ATOM    430  HB3 PRO A  29       9.919 116.486  -6.832  1.00  0.00           H  
ATOM    431  HG2 PRO A  29       7.799 114.817  -8.237  1.00  0.00           H  
ATOM    432  HG3 PRO A  29       8.525 116.358  -8.792  1.00  0.00           H  
ATOM    433  HD2 PRO A  29       9.545 114.070  -9.754  1.00  0.00           H  
ATOM    434  HD3 PRO A  29      10.649 115.303  -9.147  1.00  0.00           H  
ATOM    435  N   TRP A  30       8.384 112.572  -6.112  1.00  0.00           N  
ATOM    436  CA  TRP A  30       7.685 111.594  -5.286  1.00  0.00           C  
ATOM    437  C   TRP A  30       8.633 110.468  -4.845  1.00  0.00           C  
ATOM    438  O   TRP A  30       8.310 109.712  -3.930  1.00  0.00           O  
ATOM    439  CB  TRP A  30       6.465 111.052  -6.046  1.00  0.00           C  
ATOM    440  CG  TRP A  30       6.666 110.599  -7.464  1.00  0.00           C  
ATOM    441  CD1 TRP A  30       6.238 111.266  -8.559  1.00  0.00           C  
ATOM    442  CD2 TRP A  30       7.267 109.365  -7.966  1.00  0.00           C  
ATOM    443  NE1 TRP A  30       6.533 110.549  -9.699  1.00  0.00           N  
ATOM    444  CE2 TRP A  30       7.184 109.370  -9.391  1.00  0.00           C  
ATOM    445  CE3 TRP A  30       7.861 108.234  -7.364  1.00  0.00           C  
ATOM    446  CZ2 TRP A  30       7.691 108.321 -10.174  1.00  0.00           C  
ATOM    447  CZ3 TRP A  30       8.380 107.181  -8.141  1.00  0.00           C  
ATOM    448  CH2 TRP A  30       8.306 107.229  -9.543  1.00  0.00           C  
ATOM    449  H   TRP A  30       8.236 112.561  -7.109  1.00  0.00           H  
ATOM    450  HA  TRP A  30       7.315 112.074  -4.378  1.00  0.00           H  
ATOM    451  HB2 TRP A  30       6.048 110.218  -5.479  1.00  0.00           H  
ATOM    452  HB3 TRP A  30       5.712 111.841  -6.054  1.00  0.00           H  
ATOM    453  HD1 TRP A  30       5.714 112.211  -8.548  1.00  0.00           H  
ATOM    454  HE1 TRP A  30       6.266 110.828 -10.643  1.00  0.00           H  
ATOM    455  HE3 TRP A  30       7.914 108.168  -6.288  1.00  0.00           H  
ATOM    456  HZ2 TRP A  30       7.632 108.358 -11.251  1.00  0.00           H  
ATOM    457  HZ3 TRP A  30       8.853 106.340  -7.655  1.00  0.00           H  
ATOM    458  HH2 TRP A  30       8.783 106.460 -10.132  1.00  0.00           H  
ATOM    459  N   CYS A  31       9.814 110.344  -5.459  1.00  0.00           N  
ATOM    460  CA  CYS A  31      10.736 109.264  -5.144  1.00  0.00           C  
ATOM    461  C   CYS A  31      11.588 109.599  -3.915  1.00  0.00           C  
ATOM    462  O   CYS A  31      12.735 110.038  -4.019  1.00  0.00           O  
ATOM    463  CB  CYS A  31      11.599 108.938  -6.359  1.00  0.00           C  
ATOM    464  SG  CYS A  31      12.727 107.575  -6.038  1.00  0.00           S  
ATOM    465  H   CYS A  31      10.126 111.070  -6.093  1.00  0.00           H  
ATOM    466  HA  CYS A  31      10.172 108.354  -4.930  1.00  0.00           H  
ATOM    467  HB2 CYS A  31      10.962 108.666  -7.198  1.00  0.00           H  
ATOM    468  HB3 CYS A  31      12.198 109.799  -6.636  1.00  0.00           H  
ATOM    469  N   GLY A  32      11.013 109.360  -2.735  1.00  0.00           N  
ATOM    470  CA  GLY A  32      11.675 109.508  -1.442  1.00  0.00           C  
ATOM    471  C   GLY A  32      13.122 108.991  -1.422  1.00  0.00           C  
ATOM    472  O   GLY A  32      14.027 109.769  -1.107  1.00  0.00           O  
ATOM    473  H   GLY A  32      10.030 109.108  -2.752  1.00  0.00           H  
ATOM    474  HA2 GLY A  32      11.692 110.564  -1.171  1.00  0.00           H  
ATOM    475  HA3 GLY A  32      11.101 108.969  -0.688  1.00  0.00           H  
ATOM    476  N   PRO A  33      13.379 107.706  -1.742  1.00  0.00           N  
ATOM    477  CA  PRO A  33      14.735 107.182  -1.731  1.00  0.00           C  
ATOM    478  C   PRO A  33      15.641 107.979  -2.667  1.00  0.00           C  
ATOM    479  O   PRO A  33      16.775 108.283  -2.313  1.00  0.00           O  
ATOM    480  CB  PRO A  33      14.645 105.699  -2.102  1.00  0.00           C  
ATOM    481  CG  PRO A  33      13.261 105.538  -2.724  1.00  0.00           C  
ATOM    482  CD  PRO A  33      12.432 106.653  -2.088  1.00  0.00           C  
ATOM    483  HA  PRO A  33      15.137 107.249  -0.726  1.00  0.00           H  
ATOM    484  HB2 PRO A  33      15.441 105.386  -2.781  1.00  0.00           H  
ATOM    485  HB3 PRO A  33      14.690 105.104  -1.188  1.00  0.00           H  
ATOM    486  HG2 PRO A  33      13.321 105.710  -3.797  1.00  0.00           H  
ATOM    487  HG3 PRO A  33      12.852 104.543  -2.538  1.00  0.00           H  
ATOM    488  HD2 PRO A  33      11.681 106.958  -2.812  1.00  0.00           H  
ATOM    489  HD3 PRO A  33      11.951 106.289  -1.179  1.00  0.00           H  
ATOM    490  N   CYS A  34      15.140 108.360  -3.844  1.00  0.00           N  
ATOM    491  CA  CYS A  34      15.928 109.137  -4.792  1.00  0.00           C  
ATOM    492  C   CYS A  34      16.367 110.435  -4.125  1.00  0.00           C  
ATOM    493  O   CYS A  34      17.548 110.764  -4.114  1.00  0.00           O  
ATOM    494  CB  CYS A  34      15.161 109.486  -6.069  1.00  0.00           C  
ATOM    495  SG  CYS A  34      14.446 108.152  -7.050  1.00  0.00           S  
ATOM    496  H   CYS A  34      14.158 108.211  -4.011  1.00  0.00           H  
ATOM    497  HA  CYS A  34      16.810 108.568  -5.083  1.00  0.00           H  
ATOM    498  HB2 CYS A  34      14.378 110.211  -5.865  1.00  0.00           H  
ATOM    499  HB3 CYS A  34      15.893 109.963  -6.717  1.00  0.00           H  
ATOM    500  N   ARG A  35      15.407 111.166  -3.554  1.00  0.00           N  
ATOM    501  CA  ARG A  35      15.670 112.436  -2.901  1.00  0.00           C  
ATOM    502  C   ARG A  35      16.723 112.303  -1.801  1.00  0.00           C  
ATOM    503  O   ARG A  35      17.646 113.109  -1.759  1.00  0.00           O  
ATOM    504  CB  ARG A  35      14.360 112.990  -2.338  1.00  0.00           C  
ATOM    505  CG  ARG A  35      13.533 113.617  -3.464  1.00  0.00           C  
ATOM    506  CD  ARG A  35      12.094 113.883  -3.027  1.00  0.00           C  
ATOM    507  NE  ARG A  35      12.005 114.641  -1.774  1.00  0.00           N  
ATOM    508  CZ  ARG A  35      10.844 114.962  -1.187  1.00  0.00           C  
ATOM    509  NH1 ARG A  35       9.682 114.625  -1.761  1.00  0.00           N  
ATOM    510  NH2 ARG A  35      10.852 115.624  -0.026  1.00  0.00           N  
ATOM    511  H   ARG A  35      14.452 110.819  -3.570  1.00  0.00           H  
ATOM    512  HA  ARG A  35      16.062 113.138  -3.639  1.00  0.00           H  
ATOM    513  HB2 ARG A  35      13.793 112.199  -1.847  1.00  0.00           H  
ATOM    514  HB3 ARG A  35      14.592 113.757  -1.602  1.00  0.00           H  
ATOM    515  HG2 ARG A  35      14.001 114.554  -3.772  1.00  0.00           H  
ATOM    516  HG3 ARG A  35      13.503 112.945  -4.323  1.00  0.00           H  
ATOM    517  HD2 ARG A  35      11.613 114.462  -3.812  1.00  0.00           H  
ATOM    518  HD3 ARG A  35      11.578 112.926  -2.915  1.00  0.00           H  
ATOM    519  HE  ARG A  35      12.872 114.925  -1.341  1.00  0.00           H  
ATOM    520 HH11 ARG A  35       9.683 114.146  -2.658  1.00  0.00           H  
ATOM    521 HH12 ARG A  35       8.800 114.851  -1.331  1.00  0.00           H  
ATOM    522 HH21 ARG A  35      11.731 115.874   0.401  1.00  0.00           H  
ATOM    523 HH22 ARG A  35       9.989 115.875   0.432  1.00  0.00           H  
ATOM    524  N   ILE A  36      16.599 111.319  -0.905  1.00  0.00           N  
ATOM    525  CA  ILE A  36      17.574 111.196   0.181  1.00  0.00           C  
ATOM    526  C   ILE A  36      18.918 110.637  -0.319  1.00  0.00           C  
ATOM    527  O   ILE A  36      19.933 110.861   0.335  1.00  0.00           O  
ATOM    528  CB  ILE A  36      16.985 110.432   1.388  1.00  0.00           C  
ATOM    529  CG1 ILE A  36      16.602 108.977   1.089  1.00  0.00           C  
ATOM    530  CG2 ILE A  36      15.737 111.179   1.883  1.00  0.00           C  
ATOM    531  CD1 ILE A  36      17.743 107.999   1.383  1.00  0.00           C  
ATOM    532  H   ILE A  36      15.810 110.681  -0.966  1.00  0.00           H  
ATOM    533  HA  ILE A  36      17.808 112.197   0.551  1.00  0.00           H  
ATOM    534  HB  ILE A  36      17.714 110.440   2.199  1.00  0.00           H  
ATOM    535 HG12 ILE A  36      15.762 108.682   1.719  1.00  0.00           H  
ATOM    536 HG13 ILE A  36      16.287 108.903   0.055  1.00  0.00           H  
ATOM    537 HG21 ILE A  36      15.389 110.734   2.816  1.00  0.00           H  
ATOM    538 HG22 ILE A  36      15.978 112.226   2.071  1.00  0.00           H  
ATOM    539 HG23 ILE A  36      14.933 111.124   1.148  1.00  0.00           H  
ATOM    540 HD11 ILE A  36      17.960 108.003   2.451  1.00  0.00           H  
ATOM    541 HD12 ILE A  36      17.439 106.994   1.089  1.00  0.00           H  
ATOM    542 HD13 ILE A  36      18.646 108.268   0.842  1.00  0.00           H  
ATOM    543  N   ILE A  37      18.956 109.928  -1.456  1.00  0.00           N  
ATOM    544  CA  ILE A  37      20.192 109.412  -2.048  1.00  0.00           C  
ATOM    545  C   ILE A  37      20.910 110.510  -2.862  1.00  0.00           C  
ATOM    546  O   ILE A  37      22.136 110.579  -2.862  1.00  0.00           O  
ATOM    547  CB  ILE A  37      19.847 108.150  -2.871  1.00  0.00           C  
ATOM    548  CG1 ILE A  37      19.491 106.970  -1.945  1.00  0.00           C  
ATOM    549  CG2 ILE A  37      20.971 107.709  -3.812  1.00  0.00           C  
ATOM    550  CD1 ILE A  37      20.665 106.394  -1.143  1.00  0.00           C  
ATOM    551  H   ILE A  37      18.085 109.646  -1.896  1.00  0.00           H  
ATOM    552  HA  ILE A  37      20.885 109.137  -1.256  1.00  0.00           H  
ATOM    553  HB  ILE A  37      18.983 108.362  -3.500  1.00  0.00           H  
ATOM    554 HG12 ILE A  37      18.727 107.271  -1.234  1.00  0.00           H  
ATOM    555 HG13 ILE A  37      19.072 106.174  -2.559  1.00  0.00           H  
ATOM    556 HG21 ILE A  37      20.816 106.678  -4.128  1.00  0.00           H  
ATOM    557 HG22 ILE A  37      21.946 107.800  -3.333  1.00  0.00           H  
ATOM    558 HG23 ILE A  37      20.926 108.331  -4.703  1.00  0.00           H  
ATOM    559 HD11 ILE A  37      21.080 107.139  -0.466  1.00  0.00           H  
ATOM    560 HD12 ILE A  37      21.447 106.032  -1.809  1.00  0.00           H  
ATOM    561 HD13 ILE A  37      20.302 105.563  -0.543  1.00  0.00           H  
ATOM    562  N   ALA A  38      20.175 111.408  -3.518  1.00  0.00           N  
ATOM    563  CA  ALA A  38      20.684 112.513  -4.335  1.00  0.00           C  
ATOM    564  C   ALA A  38      21.920 113.241  -3.765  1.00  0.00           C  
ATOM    565  O   ALA A  38      22.851 113.503  -4.526  1.00  0.00           O  
ATOM    566  CB  ALA A  38      19.555 113.515  -4.605  1.00  0.00           C  
ATOM    567  H   ALA A  38      19.179 111.243  -3.540  1.00  0.00           H  
ATOM    568  HA  ALA A  38      20.974 112.093  -5.298  1.00  0.00           H  
ATOM    569  HB1 ALA A  38      19.212 113.985  -3.686  1.00  0.00           H  
ATOM    570  HB2 ALA A  38      18.715 113.008  -5.081  1.00  0.00           H  
ATOM    571  HB3 ALA A  38      19.918 114.292  -5.278  1.00  0.00           H  
ATOM    572  N   PRO A  39      21.993 113.602  -2.470  1.00  0.00           N  
ATOM    573  CA  PRO A  39      23.168 114.263  -1.918  1.00  0.00           C  
ATOM    574  C   PRO A  39      24.383 113.339  -2.029  1.00  0.00           C  
ATOM    575  O   PRO A  39      25.482 113.774  -2.365  1.00  0.00           O  
ATOM    576  CB  PRO A  39      22.842 114.576  -0.451  1.00  0.00           C  
ATOM    577  CG  PRO A  39      21.324 114.417  -0.365  1.00  0.00           C  
ATOM    578  CD  PRO A  39      21.060 113.328  -1.398  1.00  0.00           C  
ATOM    579  HA  PRO A  39      23.354 115.192  -2.461  1.00  0.00           H  
ATOM    580  HB2 PRO A  39      23.310 113.842   0.209  1.00  0.00           H  
ATOM    581  HB3 PRO A  39      23.164 115.579  -0.168  1.00  0.00           H  
ATOM    582  HG2 PRO A  39      20.988 114.130   0.633  1.00  0.00           H  
ATOM    583  HG3 PRO A  39      20.837 115.342  -0.679  1.00  0.00           H  
ATOM    584  HD2 PRO A  39      21.327 112.362  -0.969  1.00  0.00           H  
ATOM    585  HD3 PRO A  39      20.024 113.332  -1.711  1.00  0.00           H  
ATOM    586  N   VAL A  40      24.155 112.049  -1.758  1.00  0.00           N  
ATOM    587  CA  VAL A  40      25.158 111.004  -1.818  1.00  0.00           C  
ATOM    588  C   VAL A  40      25.645 110.904  -3.268  1.00  0.00           C  
ATOM    589  O   VAL A  40      26.846 110.915  -3.534  1.00  0.00           O  
ATOM    590  CB  VAL A  40      24.577 109.673  -1.299  1.00  0.00           C  
ATOM    591  CG1 VAL A  40      25.715 108.694  -1.033  1.00  0.00           C  
ATOM    592  CG2 VAL A  40      23.793 109.849   0.011  1.00  0.00           C  
ATOM    593  H   VAL A  40      23.193 111.748  -1.654  1.00  0.00           H  
ATOM    594  HA  VAL A  40      25.982 111.283  -1.167  1.00  0.00           H  
ATOM    595  HB  VAL A  40      23.929 109.213  -2.043  1.00  0.00           H  
ATOM    596 HG11 VAL A  40      26.363 109.107  -0.260  1.00  0.00           H  
ATOM    597 HG12 VAL A  40      26.284 108.536  -1.948  1.00  0.00           H  
ATOM    598 HG13 VAL A  40      25.304 107.741  -0.697  1.00  0.00           H  
ATOM    599 HG21 VAL A  40      23.506 108.873   0.402  1.00  0.00           H  
ATOM    600 HG22 VAL A  40      24.413 110.358   0.750  1.00  0.00           H  
ATOM    601 HG23 VAL A  40      22.883 110.426  -0.149  1.00  0.00           H  
ATOM    602  N   VAL A  41      24.693 110.840  -4.208  1.00  0.00           N  
ATOM    603  CA  VAL A  41      24.965 110.807  -5.642  1.00  0.00           C  
ATOM    604  C   VAL A  41      25.889 111.977  -5.998  1.00  0.00           C  
ATOM    605  O   VAL A  41      26.927 111.787  -6.632  1.00  0.00           O  
ATOM    606  CB  VAL A  41      23.638 110.878  -6.430  1.00  0.00           C  
ATOM    607  CG1 VAL A  41      23.834 111.025  -7.943  1.00  0.00           C  
ATOM    608  CG2 VAL A  41      22.749 109.667  -6.150  1.00  0.00           C  
ATOM    609  H   VAL A  41      23.728 110.839  -3.890  1.00  0.00           H  
ATOM    610  HA  VAL A  41      25.476 109.875  -5.888  1.00  0.00           H  
ATOM    611  HB  VAL A  41      23.088 111.758  -6.118  1.00  0.00           H  
ATOM    612 HG11 VAL A  41      22.884 110.919  -8.470  1.00  0.00           H  
ATOM    613 HG12 VAL A  41      24.211 112.026  -8.145  1.00  0.00           H  
ATOM    614 HG13 VAL A  41      24.531 110.275  -8.318  1.00  0.00           H  
ATOM    615 HG21 VAL A  41      21.755 109.829  -6.571  1.00  0.00           H  
ATOM    616 HG22 VAL A  41      23.184 108.764  -6.574  1.00  0.00           H  
ATOM    617 HG23 VAL A  41      22.652 109.540  -5.078  1.00  0.00           H  
ATOM    618  N   ASP A  42      25.512 113.189  -5.576  1.00  0.00           N  
ATOM    619  CA  ASP A  42      26.274 114.387  -5.884  1.00  0.00           C  
ATOM    620  C   ASP A  42      27.680 114.348  -5.305  1.00  0.00           C  
ATOM    621  O   ASP A  42      28.649 114.494  -6.040  1.00  0.00           O  
ATOM    622  CB  ASP A  42      25.570 115.634  -5.352  1.00  0.00           C  
ATOM    623  CG  ASP A  42      26.290 116.883  -5.854  1.00  0.00           C  
ATOM    624  OD1 ASP A  42      26.475 116.974  -7.088  1.00  0.00           O  
ATOM    625  OD2 ASP A  42      26.661 117.710  -4.996  1.00  0.00           O  
ATOM    626  H   ASP A  42      24.641 113.278  -5.057  1.00  0.00           H  
ATOM    627  HA  ASP A  42      26.353 114.456  -6.970  1.00  0.00           H  
ATOM    628  HB2 ASP A  42      24.540 115.630  -5.686  1.00  0.00           H  
ATOM    629  HB3 ASP A  42      25.564 115.636  -4.262  1.00  0.00           H  
ATOM    630  N   GLU A  43      27.801 114.192  -3.987  1.00  0.00           N  
ATOM    631  CA  GLU A  43      29.109 114.226  -3.348  1.00  0.00           C  
ATOM    632  C   GLU A  43      30.033 113.151  -3.935  1.00  0.00           C  
ATOM    633  O   GLU A  43      31.184 113.451  -4.257  1.00  0.00           O  
ATOM    634  CB  GLU A  43      28.962 114.146  -1.827  1.00  0.00           C  
ATOM    635  CG  GLU A  43      28.554 112.766  -1.317  1.00  0.00           C  
ATOM    636  CD  GLU A  43      28.281 112.777   0.179  1.00  0.00           C  
ATOM    637  OE1 GLU A  43      27.131 113.103   0.545  1.00  0.00           O  
ATOM    638  OE2 GLU A  43      29.225 112.452   0.932  1.00  0.00           O  
ATOM    639  H   GLU A  43      26.960 114.127  -3.422  1.00  0.00           H  
ATOM    640  HA  GLU A  43      29.560 115.194  -3.576  1.00  0.00           H  
ATOM    641  HB2 GLU A  43      29.923 114.407  -1.398  1.00  0.00           H  
ATOM    642  HB3 GLU A  43      28.228 114.885  -1.501  1.00  0.00           H  
ATOM    643  HG2 GLU A  43      27.651 112.473  -1.835  1.00  0.00           H  
ATOM    644  HG3 GLU A  43      29.338 112.039  -1.524  1.00  0.00           H  
ATOM    645  N   ILE A  44      29.538 111.924  -4.145  1.00  0.00           N  
ATOM    646  CA  ILE A  44      30.327 110.887  -4.802  1.00  0.00           C  
ATOM    647  C   ILE A  44      30.776 111.414  -6.162  1.00  0.00           C  
ATOM    648  O   ILE A  44      31.951 111.345  -6.523  1.00  0.00           O  
ATOM    649  CB  ILE A  44      29.497 109.598  -4.932  1.00  0.00           C  
ATOM    650  CG1 ILE A  44      29.384 108.964  -3.535  1.00  0.00           C  
ATOM    651  CG2 ILE A  44      30.139 108.605  -5.919  1.00  0.00           C  
ATOM    652  CD1 ILE A  44      28.579 107.669  -3.576  1.00  0.00           C  
ATOM    653  H   ILE A  44      28.579 111.707  -3.885  1.00  0.00           H  
ATOM    654  HA  ILE A  44      31.222 110.686  -4.215  1.00  0.00           H  
ATOM    655  HB  ILE A  44      28.503 109.842  -5.308  1.00  0.00           H  
ATOM    656 HG12 ILE A  44      30.379 108.761  -3.144  1.00  0.00           H  
ATOM    657 HG13 ILE A  44      28.893 109.655  -2.852  1.00  0.00           H  
ATOM    658 HG21 ILE A  44      30.244 109.046  -6.908  1.00  0.00           H  
ATOM    659 HG22 ILE A  44      31.115 108.298  -5.549  1.00  0.00           H  
ATOM    660 HG23 ILE A  44      29.510 107.728  -6.048  1.00  0.00           H  
ATOM    661 HD11 ILE A  44      27.630 107.849  -4.081  1.00  0.00           H  
ATOM    662 HD12 ILE A  44      29.147 106.898  -4.091  1.00  0.00           H  
ATOM    663 HD13 ILE A  44      28.378 107.310  -2.573  1.00  0.00           H  
ATOM    664  N   ALA A  45      29.842 111.957  -6.938  1.00  0.00           N  
ATOM    665  CA  ALA A  45      30.187 112.500  -8.236  1.00  0.00           C  
ATOM    666  C   ALA A  45      31.235 113.607  -8.124  1.00  0.00           C  
ATOM    667  O   ALA A  45      32.080 113.735  -9.008  1.00  0.00           O  
ATOM    668  CB  ALA A  45      28.929 113.003  -8.914  1.00  0.00           C  
ATOM    669  H   ALA A  45      28.873 111.999  -6.632  1.00  0.00           H  
ATOM    670  HA  ALA A  45      30.612 111.698  -8.837  1.00  0.00           H  
ATOM    671  HB1 ALA A  45      28.561 113.920  -8.458  1.00  0.00           H  
ATOM    672  HB2 ALA A  45      28.164 112.230  -8.862  1.00  0.00           H  
ATOM    673  HB3 ALA A  45      29.202 113.190  -9.944  1.00  0.00           H  
ATOM    674  N   GLY A  46      31.178 114.407  -7.058  1.00  0.00           N  
ATOM    675  CA  GLY A  46      32.162 115.430  -6.758  1.00  0.00           C  
ATOM    676  C   GLY A  46      33.531 114.772  -6.614  1.00  0.00           C  
ATOM    677  O   GLY A  46      34.497 115.220  -7.229  1.00  0.00           O  
ATOM    678  H   GLY A  46      30.423 114.273  -6.394  1.00  0.00           H  
ATOM    679  HA2 GLY A  46      32.183 116.174  -7.555  1.00  0.00           H  
ATOM    680  HA3 GLY A  46      31.898 115.919  -5.820  1.00  0.00           H  
ATOM    681  N   GLU A  47      33.602 113.694  -5.821  1.00  0.00           N  
ATOM    682  CA  GLU A  47      34.828 112.927  -5.646  1.00  0.00           C  
ATOM    683  C   GLU A  47      35.344 112.477  -7.020  1.00  0.00           C  
ATOM    684  O   GLU A  47      36.518 112.675  -7.330  1.00  0.00           O  
ATOM    685  CB  GLU A  47      34.602 111.746  -4.683  1.00  0.00           C  
ATOM    686  CG  GLU A  47      34.284 112.231  -3.255  1.00  0.00           C  
ATOM    687  CD  GLU A  47      33.938 111.106  -2.274  1.00  0.00           C  
ATOM    688  OE1 GLU A  47      33.314 110.117  -2.720  1.00  0.00           O  
ATOM    689  OE2 GLU A  47      34.284 111.265  -1.082  1.00  0.00           O  
ATOM    690  H   GLU A  47      32.756 113.386  -5.348  1.00  0.00           H  
ATOM    691  HA  GLU A  47      35.585 113.581  -5.221  1.00  0.00           H  
ATOM    692  HB2 GLU A  47      33.802 111.107  -5.046  1.00  0.00           H  
ATOM    693  HB3 GLU A  47      35.512 111.145  -4.658  1.00  0.00           H  
ATOM    694  HG2 GLU A  47      35.148 112.775  -2.870  1.00  0.00           H  
ATOM    695  HG3 GLU A  47      33.437 112.913  -3.272  1.00  0.00           H  
ATOM    696  N   TYR A  48      34.476 111.918  -7.866  1.00  0.00           N  
ATOM    697  CA  TYR A  48      34.840 111.494  -9.224  1.00  0.00           C  
ATOM    698  C   TYR A  48      34.783 112.672 -10.214  1.00  0.00           C  
ATOM    699  O   TYR A  48      34.069 112.675 -11.227  1.00  0.00           O  
ATOM    700  CB  TYR A  48      33.994 110.284  -9.636  1.00  0.00           C  
ATOM    701  CG  TYR A  48      34.298 109.065  -8.782  1.00  0.00           C  
ATOM    702  CD1 TYR A  48      35.530 108.395  -8.928  1.00  0.00           C  
ATOM    703  CD2 TYR A  48      33.480 108.767  -7.678  1.00  0.00           C  
ATOM    704  CE1 TYR A  48      35.990 107.531  -7.918  1.00  0.00           C  
ATOM    705  CE2 TYR A  48      33.957 107.938  -6.650  1.00  0.00           C  
ATOM    706  CZ  TYR A  48      35.231 107.359  -6.748  1.00  0.00           C  
ATOM    707  OH  TYR A  48      35.735 106.701  -5.668  1.00  0.00           O  
ATOM    708  H   TYR A  48      33.534 111.779  -7.515  1.00  0.00           H  
ATOM    709  HA  TYR A  48      35.882 111.173  -9.254  1.00  0.00           H  
ATOM    710  HB2 TYR A  48      32.937 110.539  -9.572  1.00  0.00           H  
ATOM    711  HB3 TYR A  48      34.229 110.032 -10.670  1.00  0.00           H  
ATOM    712  HD1 TYR A  48      36.152 108.582  -9.792  1.00  0.00           H  
ATOM    713  HD2 TYR A  48      32.504 109.212  -7.600  1.00  0.00           H  
ATOM    714  HE1 TYR A  48      36.943 107.032  -8.036  1.00  0.00           H  
ATOM    715  HE2 TYR A  48      33.363 107.767  -5.767  1.00  0.00           H  
ATOM    716  HH  TYR A  48      36.596 106.289  -5.807  1.00  0.00           H  
ATOM    717  N   LYS A  49      35.589 113.686  -9.900  1.00  0.00           N  
ATOM    718  CA  LYS A  49      35.752 114.885 -10.705  1.00  0.00           C  
ATOM    719  C   LYS A  49      36.243 114.534 -12.118  1.00  0.00           C  
ATOM    720  O   LYS A  49      36.812 113.467 -12.355  1.00  0.00           O  
ATOM    721  CB  LYS A  49      36.679 115.899 -10.003  1.00  0.00           C  
ATOM    722  CG  LYS A  49      37.821 115.337  -9.139  1.00  0.00           C  
ATOM    723  CD  LYS A  49      38.784 114.418  -9.902  1.00  0.00           C  
ATOM    724  CE  LYS A  49      39.845 113.837  -8.963  1.00  0.00           C  
ATOM    725  NZ  LYS A  49      39.277 112.798  -8.084  1.00  0.00           N  
ATOM    726  H   LYS A  49      36.120 113.596  -9.042  1.00  0.00           H  
ATOM    727  HA  LYS A  49      34.782 115.361 -10.808  1.00  0.00           H  
ATOM    728  HB2 LYS A  49      37.101 116.576 -10.747  1.00  0.00           H  
ATOM    729  HB3 LYS A  49      36.058 116.497  -9.335  1.00  0.00           H  
ATOM    730  HG2 LYS A  49      38.393 116.191  -8.769  1.00  0.00           H  
ATOM    731  HG3 LYS A  49      37.406 114.838  -8.266  1.00  0.00           H  
ATOM    732  HD2 LYS A  49      38.253 113.588 -10.365  1.00  0.00           H  
ATOM    733  HD3 LYS A  49      39.274 114.997 -10.689  1.00  0.00           H  
ATOM    734  HE2 LYS A  49      40.637 113.383  -9.560  1.00  0.00           H  
ATOM    735  HE3 LYS A  49      40.282 114.633  -8.358  1.00  0.00           H  
ATOM    736  HZ1 LYS A  49      38.482 113.159  -7.573  1.00  0.00           H  
ATOM    737  HZ2 LYS A  49      39.980 112.482  -7.430  1.00  0.00           H  
ATOM    738  HZ3 LYS A  49      38.966 112.017  -8.642  1.00  0.00           H  
ATOM    739  N   ASP A  50      35.941 115.436 -13.060  1.00  0.00           N  
ATOM    740  CA  ASP A  50      36.299 115.442 -14.475  1.00  0.00           C  
ATOM    741  C   ASP A  50      35.610 114.347 -15.284  1.00  0.00           C  
ATOM    742  O   ASP A  50      34.945 114.637 -16.274  1.00  0.00           O  
ATOM    743  CB  ASP A  50      37.823 115.359 -14.657  1.00  0.00           C  
ATOM    744  CG  ASP A  50      38.529 116.565 -14.049  1.00  0.00           C  
ATOM    745  OD1 ASP A  50      38.607 117.594 -14.754  1.00  0.00           O  
ATOM    746  OD2 ASP A  50      38.950 116.442 -12.879  1.00  0.00           O  
ATOM    747  H   ASP A  50      35.475 116.264 -12.742  1.00  0.00           H  
ATOM    748  HA  ASP A  50      35.966 116.387 -14.896  1.00  0.00           H  
ATOM    749  HB2 ASP A  50      38.214 114.441 -14.219  1.00  0.00           H  
ATOM    750  HB3 ASP A  50      38.047 115.344 -15.725  1.00  0.00           H  
ATOM    751  N   LYS A  51      35.758 113.094 -14.865  1.00  0.00           N  
ATOM    752  CA  LYS A  51      35.291 111.956 -15.643  1.00  0.00           C  
ATOM    753  C   LYS A  51      33.808 111.674 -15.441  1.00  0.00           C  
ATOM    754  O   LYS A  51      33.049 111.554 -16.393  1.00  0.00           O  
ATOM    755  CB  LYS A  51      36.103 110.698 -15.303  1.00  0.00           C  
ATOM    756  CG  LYS A  51      37.621 110.904 -15.430  1.00  0.00           C  
ATOM    757  CD  LYS A  51      38.397 109.758 -14.765  1.00  0.00           C  
ATOM    758  CE  LYS A  51      38.824 110.087 -13.325  1.00  0.00           C  
ATOM    759  NZ  LYS A  51      37.691 110.463 -12.460  1.00  0.00           N  
ATOM    760  H   LYS A  51      36.232 112.967 -13.978  1.00  0.00           H  
ATOM    761  HA  LYS A  51      35.440 112.165 -16.694  1.00  0.00           H  
ATOM    762  HB2 LYS A  51      35.835 110.360 -14.312  1.00  0.00           H  
ATOM    763  HB3 LYS A  51      35.806 109.899 -15.983  1.00  0.00           H  
ATOM    764  HG2 LYS A  51      37.862 110.931 -16.495  1.00  0.00           H  
ATOM    765  HG3 LYS A  51      37.945 111.849 -14.993  1.00  0.00           H  
ATOM    766  HD2 LYS A  51      37.805 108.841 -14.784  1.00  0.00           H  
ATOM    767  HD3 LYS A  51      39.308 109.577 -15.339  1.00  0.00           H  
ATOM    768  HE2 LYS A  51      39.313 109.211 -12.896  1.00  0.00           H  
ATOM    769  HE3 LYS A  51      39.540 110.910 -13.335  1.00  0.00           H  
ATOM    770  HZ1 LYS A  51      36.993 109.732 -12.471  1.00  0.00           H  
ATOM    771  HZ2 LYS A  51      37.281 111.330 -12.783  1.00  0.00           H  
ATOM    772  HZ3 LYS A  51      38.020 110.594 -11.514  1.00  0.00           H  
ATOM    773  N   LEU A  52      33.388 111.531 -14.191  1.00  0.00           N  
ATOM    774  CA  LEU A  52      32.029 111.073 -13.943  1.00  0.00           C  
ATOM    775  C   LEU A  52      31.040 112.229 -14.067  1.00  0.00           C  
ATOM    776  O   LEU A  52      30.883 113.015 -13.127  1.00  0.00           O  
ATOM    777  CB  LEU A  52      31.951 110.369 -12.585  1.00  0.00           C  
ATOM    778  CG  LEU A  52      30.651 109.558 -12.458  1.00  0.00           C  
ATOM    779  CD1 LEU A  52      30.816 108.170 -13.093  1.00  0.00           C  
ATOM    780  CD2 LEU A  52      30.286 109.401 -10.981  1.00  0.00           C  
ATOM    781  H   LEU A  52      34.027 111.769 -13.444  1.00  0.00           H  
ATOM    782  HA  LEU A  52      31.765 110.330 -14.695  1.00  0.00           H  
ATOM    783  HB2 LEU A  52      32.796 109.690 -12.483  1.00  0.00           H  
ATOM    784  HB3 LEU A  52      32.021 111.107 -11.791  1.00  0.00           H  
ATOM    785  HG  LEU A  52      29.831 110.080 -12.957  1.00  0.00           H  
ATOM    786 HD11 LEU A  52      29.897 107.596 -13.005  1.00  0.00           H  
ATOM    787 HD12 LEU A  52      31.067 108.255 -14.148  1.00  0.00           H  
ATOM    788 HD13 LEU A  52      31.602 107.621 -12.576  1.00  0.00           H  
ATOM    789 HD21 LEU A  52      29.402 108.773 -10.888  1.00  0.00           H  
ATOM    790 HD22 LEU A  52      30.061 110.378 -10.561  1.00  0.00           H  
ATOM    791 HD23 LEU A  52      31.110 108.945 -10.433  1.00  0.00           H  
ATOM    792  N   LYS A  53      30.371 112.338 -15.217  1.00  0.00           N  
ATOM    793  CA  LYS A  53      29.355 113.350 -15.432  1.00  0.00           C  
ATOM    794  C   LYS A  53      28.081 112.859 -14.760  1.00  0.00           C  
ATOM    795  O   LYS A  53      27.235 112.207 -15.363  1.00  0.00           O  
ATOM    796  CB  LYS A  53      29.185 113.628 -16.932  1.00  0.00           C  
ATOM    797  CG  LYS A  53      28.789 115.083 -17.219  1.00  0.00           C  
ATOM    798  CD  LYS A  53      27.383 115.424 -16.699  1.00  0.00           C  
ATOM    799  CE  LYS A  53      27.043 116.903 -16.906  1.00  0.00           C  
ATOM    800  NZ  LYS A  53      27.843 117.773 -16.024  1.00  0.00           N  
ATOM    801  H   LYS A  53      30.575 111.707 -15.992  1.00  0.00           H  
ATOM    802  HA  LYS A  53      29.659 114.272 -14.955  1.00  0.00           H  
ATOM    803  HB2 LYS A  53      30.139 113.439 -17.416  1.00  0.00           H  
ATOM    804  HB3 LYS A  53      28.462 112.952 -17.378  1.00  0.00           H  
ATOM    805  HG2 LYS A  53      29.535 115.746 -16.780  1.00  0.00           H  
ATOM    806  HG3 LYS A  53      28.803 115.228 -18.301  1.00  0.00           H  
ATOM    807  HD2 LYS A  53      26.659 114.810 -17.238  1.00  0.00           H  
ATOM    808  HD3 LYS A  53      27.293 115.209 -15.634  1.00  0.00           H  
ATOM    809  HE2 LYS A  53      27.213 117.183 -17.948  1.00  0.00           H  
ATOM    810  HE3 LYS A  53      25.988 117.056 -16.673  1.00  0.00           H  
ATOM    811  HZ1 LYS A  53      28.825 117.666 -16.229  1.00  0.00           H  
ATOM    812  HZ2 LYS A  53      27.576 118.738 -16.167  1.00  0.00           H  
ATOM    813  HZ3 LYS A  53      27.676 117.524 -15.058  1.00  0.00           H  
ATOM    814  N   CYS A  54      27.924 113.154 -13.478  1.00  0.00           N  
ATOM    815  CA  CYS A  54      26.737 112.685 -12.793  1.00  0.00           C  
ATOM    816  C   CYS A  54      25.565 113.588 -13.166  1.00  0.00           C  
ATOM    817  O   CYS A  54      25.761 114.751 -13.533  1.00  0.00           O  
ATOM    818  CB  CYS A  54      26.997 112.671 -11.305  1.00  0.00           C  
ATOM    819  SG  CYS A  54      25.564 111.992 -10.468  1.00  0.00           S  
ATOM    820  H   CYS A  54      28.639 113.667 -12.979  1.00  0.00           H  
ATOM    821  HA  CYS A  54      26.534 111.663 -13.094  1.00  0.00           H  
ATOM    822  HB2 CYS A  54      27.845 112.030 -11.104  1.00  0.00           H  
ATOM    823  HB3 CYS A  54      27.203 113.676 -10.964  1.00  0.00           H  
ATOM    824  HG  CYS A  54      26.035 112.152  -9.226  1.00  0.00           H  
ATOM    825  N   VAL A  55      24.344 113.061 -13.133  1.00  0.00           N  
ATOM    826  CA  VAL A  55      23.176 113.809 -13.535  1.00  0.00           C  
ATOM    827  C   VAL A  55      21.937 113.204 -12.903  1.00  0.00           C  
ATOM    828  O   VAL A  55      21.976 112.086 -12.396  1.00  0.00           O  
ATOM    829  CB  VAL A  55      23.027 113.829 -15.075  1.00  0.00           C  
ATOM    830  CG1 VAL A  55      22.904 115.274 -15.550  1.00  0.00           C  
ATOM    831  CG2 VAL A  55      24.136 113.140 -15.879  1.00  0.00           C  
ATOM    832  H   VAL A  55      24.196 112.111 -12.787  1.00  0.00           H  
ATOM    833  HA  VAL A  55      23.284 114.809 -13.123  1.00  0.00           H  
ATOM    834  HB  VAL A  55      22.108 113.307 -15.346  1.00  0.00           H  
ATOM    835 HG11 VAL A  55      22.842 115.284 -16.634  1.00  0.00           H  
ATOM    836 HG12 VAL A  55      23.774 115.849 -15.238  1.00  0.00           H  
ATOM    837 HG13 VAL A  55      22.000 115.720 -15.138  1.00  0.00           H  
ATOM    838 HG21 VAL A  55      24.281 112.118 -15.528  1.00  0.00           H  
ATOM    839 HG22 VAL A  55      25.069 113.693 -15.803  1.00  0.00           H  
ATOM    840 HG23 VAL A  55      23.851 113.105 -16.931  1.00  0.00           H  
ATOM    841  N   LYS A  56      20.837 113.950 -12.954  1.00  0.00           N  
ATOM    842  CA  LYS A  56      19.545 113.549 -12.433  1.00  0.00           C  
ATOM    843  C   LYS A  56      18.473 113.781 -13.500  1.00  0.00           C  
ATOM    844  O   LYS A  56      18.296 114.907 -13.970  1.00  0.00           O  
ATOM    845  CB  LYS A  56      19.281 114.357 -11.167  1.00  0.00           C  
ATOM    846  CG  LYS A  56      19.979 113.699  -9.972  1.00  0.00           C  
ATOM    847  CD  LYS A  56      20.070 114.631  -8.761  1.00  0.00           C  
ATOM    848  CE  LYS A  56      21.396 115.404  -8.717  1.00  0.00           C  
ATOM    849  NZ  LYS A  56      21.501 116.435  -9.764  1.00  0.00           N  
ATOM    850  H   LYS A  56      20.928 114.906 -13.278  1.00  0.00           H  
ATOM    851  HA  LYS A  56      19.554 112.495 -12.172  1.00  0.00           H  
ATOM    852  HB2 LYS A  56      19.635 115.373 -11.329  1.00  0.00           H  
ATOM    853  HB3 LYS A  56      18.214 114.381 -10.971  1.00  0.00           H  
ATOM    854  HG2 LYS A  56      19.386 112.828  -9.689  1.00  0.00           H  
ATOM    855  HG3 LYS A  56      20.979 113.354 -10.243  1.00  0.00           H  
ATOM    856  HD2 LYS A  56      19.213 115.307  -8.742  1.00  0.00           H  
ATOM    857  HD3 LYS A  56      20.027 114.000  -7.871  1.00  0.00           H  
ATOM    858  HE2 LYS A  56      21.487 115.904  -7.753  1.00  0.00           H  
ATOM    859  HE3 LYS A  56      22.223 114.702  -8.819  1.00  0.00           H  
ATOM    860  HZ1 LYS A  56      22.370 116.946  -9.662  1.00  0.00           H  
ATOM    861  HZ2 LYS A  56      21.491 116.013 -10.684  1.00  0.00           H  
ATOM    862  HZ3 LYS A  56      20.730 117.081  -9.688  1.00  0.00           H  
ATOM    863  N   LEU A  57      17.770 112.712 -13.884  1.00  0.00           N  
ATOM    864  CA  LEU A  57      16.712 112.726 -14.891  1.00  0.00           C  
ATOM    865  C   LEU A  57      15.352 112.542 -14.225  1.00  0.00           C  
ATOM    866  O   LEU A  57      15.099 111.529 -13.576  1.00  0.00           O  
ATOM    867  CB  LEU A  57      16.964 111.605 -15.906  1.00  0.00           C  
ATOM    868  CG  LEU A  57      15.936 111.512 -17.034  1.00  0.00           C  
ATOM    869  CD1 LEU A  57      15.799 112.829 -17.789  1.00  0.00           C  
ATOM    870  CD2 LEU A  57      16.400 110.438 -18.013  1.00  0.00           C  
ATOM    871  H   LEU A  57      17.954 111.838 -13.395  1.00  0.00           H  
ATOM    872  HA  LEU A  57      16.724 113.678 -15.415  1.00  0.00           H  
ATOM    873  HB2 LEU A  57      17.952 111.731 -16.345  1.00  0.00           H  
ATOM    874  HB3 LEU A  57      16.911 110.652 -15.391  1.00  0.00           H  
ATOM    875  HG  LEU A  57      14.968 111.217 -16.627  1.00  0.00           H  
ATOM    876 HD11 LEU A  57      15.244 113.532 -17.170  1.00  0.00           H  
ATOM    877 HD12 LEU A  57      15.263 112.661 -18.721  1.00  0.00           H  
ATOM    878 HD13 LEU A  57      16.783 113.234 -18.023  1.00  0.00           H  
ATOM    879 HD21 LEU A  57      15.537 110.070 -18.563  1.00  0.00           H  
ATOM    880 HD22 LEU A  57      16.860 109.617 -17.470  1.00  0.00           H  
ATOM    881 HD23 LEU A  57      17.129 110.848 -18.709  1.00  0.00           H  
ATOM    882  N   ASN A  58      14.460 113.526 -14.361  1.00  0.00           N  
ATOM    883  CA  ASN A  58      13.125 113.410 -13.786  1.00  0.00           C  
ATOM    884  C   ASN A  58      12.310 112.427 -14.631  1.00  0.00           C  
ATOM    885  O   ASN A  58      11.975 112.696 -15.779  1.00  0.00           O  
ATOM    886  CB  ASN A  58      12.469 114.783 -13.681  1.00  0.00           C  
ATOM    887  CG  ASN A  58      11.102 114.670 -13.010  1.00  0.00           C  
ATOM    888  OD1 ASN A  58      10.250 113.890 -13.423  1.00  0.00           O  
ATOM    889  ND2 ASN A  58      10.876 115.426 -11.944  1.00  0.00           N  
ATOM    890  H   ASN A  58      14.685 114.330 -14.931  1.00  0.00           H  
ATOM    891  HA  ASN A  58      13.202 113.022 -12.772  1.00  0.00           H  
ATOM    892  HB2 ASN A  58      13.115 115.432 -13.091  1.00  0.00           H  
ATOM    893  HB3 ASN A  58      12.379 115.217 -14.672  1.00  0.00           H  
ATOM    894 HD21 ASN A  58      11.604 116.026 -11.591  1.00  0.00           H  
ATOM    895 HD22 ASN A  58       9.960 115.413 -11.526  1.00  0.00           H  
ATOM    896  N   THR A  59      11.982 111.288 -14.031  1.00  0.00           N  
ATOM    897  CA  THR A  59      11.335 110.153 -14.673  1.00  0.00           C  
ATOM    898  C   THR A  59       9.881 110.469 -15.040  1.00  0.00           C  
ATOM    899  O   THR A  59       9.353 109.928 -16.006  1.00  0.00           O  
ATOM    900  CB  THR A  59      11.461 108.937 -13.731  1.00  0.00           C  
ATOM    901  OG1 THR A  59      12.810 108.822 -13.317  1.00  0.00           O  
ATOM    902  CG2 THR A  59      11.072 107.632 -14.429  1.00  0.00           C  
ATOM    903  H   THR A  59      12.185 111.221 -13.044  1.00  0.00           H  
ATOM    904  HA  THR A  59      11.871 109.932 -15.598  1.00  0.00           H  
ATOM    905  HB  THR A  59      10.836 109.059 -12.839  1.00  0.00           H  
ATOM    906  HG1 THR A  59      12.998 109.534 -12.692  1.00  0.00           H  
ATOM    907 HG21 THR A  59      11.696 107.483 -15.309  1.00  0.00           H  
ATOM    908 HG22 THR A  59      10.025 107.655 -14.728  1.00  0.00           H  
ATOM    909 HG23 THR A  59      11.223 106.796 -13.743  1.00  0.00           H  
ATOM    910  N   ASP A  60       9.237 111.361 -14.288  1.00  0.00           N  
ATOM    911  CA  ASP A  60       7.846 111.743 -14.499  1.00  0.00           C  
ATOM    912  C   ASP A  60       7.734 112.696 -15.698  1.00  0.00           C  
ATOM    913  O   ASP A  60       6.835 112.595 -16.529  1.00  0.00           O  
ATOM    914  CB  ASP A  60       7.353 112.400 -13.204  1.00  0.00           C  
ATOM    915  CG  ASP A  60       5.845 112.282 -13.027  1.00  0.00           C  
ATOM    916  OD1 ASP A  60       5.108 112.827 -13.877  1.00  0.00           O  
ATOM    917  OD2 ASP A  60       5.462 111.632 -12.028  1.00  0.00           O  
ATOM    918  H   ASP A  60       9.759 111.879 -13.591  1.00  0.00           H  
ATOM    919  HA  ASP A  60       7.253 110.846 -14.697  1.00  0.00           H  
ATOM    920  HB2 ASP A  60       7.819 111.896 -12.356  1.00  0.00           H  
ATOM    921  HB3 ASP A  60       7.656 113.446 -13.174  1.00  0.00           H  
ATOM    922  N   GLU A  61       8.701 113.614 -15.772  1.00  0.00           N  
ATOM    923  CA  GLU A  61       8.850 114.659 -16.777  1.00  0.00           C  
ATOM    924  C   GLU A  61       9.536 114.144 -18.050  1.00  0.00           C  
ATOM    925  O   GLU A  61       9.358 114.703 -19.130  1.00  0.00           O  
ATOM    926  CB  GLU A  61       9.691 115.760 -16.127  1.00  0.00           C  
ATOM    927  CG  GLU A  61       9.861 117.034 -16.961  1.00  0.00           C  
ATOM    928  CD  GLU A  61      10.679 118.073 -16.198  1.00  0.00           C  
ATOM    929  OE1 GLU A  61      11.619 117.642 -15.492  1.00  0.00           O  
ATOM    930  OE2 GLU A  61      10.346 119.271 -16.328  1.00  0.00           O  
ATOM    931  H   GLU A  61       9.368 113.606 -15.009  1.00  0.00           H  
ATOM    932  HA  GLU A  61       7.869 115.058 -17.038  1.00  0.00           H  
ATOM    933  HB2 GLU A  61       9.238 116.037 -15.172  1.00  0.00           H  
ATOM    934  HB3 GLU A  61      10.674 115.335 -15.948  1.00  0.00           H  
ATOM    935  HG2 GLU A  61      10.380 116.812 -17.894  1.00  0.00           H  
ATOM    936  HG3 GLU A  61       8.877 117.441 -17.194  1.00  0.00           H  
ATOM    937  N   SER A  62      10.369 113.110 -17.933  1.00  0.00           N  
ATOM    938  CA  SER A  62      11.094 112.491 -19.029  1.00  0.00           C  
ATOM    939  C   SER A  62      10.941 110.966 -18.954  1.00  0.00           C  
ATOM    940  O   SER A  62      11.927 110.243 -18.827  1.00  0.00           O  
ATOM    941  CB  SER A  62      12.542 112.970 -18.977  1.00  0.00           C  
ATOM    942  OG  SER A  62      12.551 114.350 -19.308  1.00  0.00           O  
ATOM    943  H   SER A  62      10.517 112.703 -17.020  1.00  0.00           H  
ATOM    944  HA  SER A  62      10.707 112.804 -19.998  1.00  0.00           H  
ATOM    945  HB2 SER A  62      13.020 112.750 -18.013  1.00  0.00           H  
ATOM    946  HB3 SER A  62      13.087 112.445 -19.746  1.00  0.00           H  
ATOM    947  HG  SER A  62      11.634 114.632 -19.438  1.00  0.00           H  
ATOM    948  N   PRO A  63       9.693 110.486 -19.074  1.00  0.00           N  
ATOM    949  CA  PRO A  63       9.327 109.083 -19.079  1.00  0.00           C  
ATOM    950  C   PRO A  63       9.846 108.418 -20.335  1.00  0.00           C  
ATOM    951  O   PRO A  63      10.170 107.241 -20.342  1.00  0.00           O  
ATOM    952  CB  PRO A  63       7.804 109.071 -19.091  1.00  0.00           C  
ATOM    953  CG  PRO A  63       7.403 110.372 -19.778  1.00  0.00           C  
ATOM    954  CD  PRO A  63       8.514 111.307 -19.306  1.00  0.00           C  
ATOM    955  HA  PRO A  63       9.709 108.568 -18.197  1.00  0.00           H  
ATOM    956  HB2 PRO A  63       7.367 108.180 -19.544  1.00  0.00           H  
ATOM    957  HB3 PRO A  63       7.503 109.168 -18.066  1.00  0.00           H  
ATOM    958  HG2 PRO A  63       7.415 110.256 -20.862  1.00  0.00           H  
ATOM    959  HG3 PRO A  63       6.421 110.718 -19.455  1.00  0.00           H  
ATOM    960  HD2 PRO A  63       8.681 112.095 -20.035  1.00  0.00           H  
ATOM    961  HD3 PRO A  63       8.238 111.746 -18.356  1.00  0.00           H  
ATOM    962  N   ASN A  64       9.859 109.199 -21.405  1.00  0.00           N  
ATOM    963  CA  ASN A  64      10.338 108.862 -22.743  1.00  0.00           C  
ATOM    964  C   ASN A  64      11.464 107.833 -22.704  1.00  0.00           C  
ATOM    965  O   ASN A  64      11.278 106.653 -23.007  1.00  0.00           O  
ATOM    966  CB  ASN A  64      10.831 110.140 -23.437  1.00  0.00           C  
ATOM    967  CG  ASN A  64       9.714 111.110 -23.806  1.00  0.00           C  
ATOM    968  OD1 ASN A  64       8.588 110.998 -23.332  1.00  0.00           O  
ATOM    969  ND2 ASN A  64      10.035 112.097 -24.633  1.00  0.00           N  
ATOM    970  H   ASN A  64       9.381 110.075 -21.227  1.00  0.00           H  
ATOM    971  HA  ASN A  64       9.548 108.431 -23.347  1.00  0.00           H  
ATOM    972  HB2 ASN A  64      11.530 110.674 -22.792  1.00  0.00           H  
ATOM    973  HB3 ASN A  64      11.355 109.847 -24.347  1.00  0.00           H  
ATOM    974 HD21 ASN A  64      11.005 112.176 -24.939  1.00  0.00           H  
ATOM    975 HD22 ASN A  64       9.334 112.765 -24.909  1.00  0.00           H  
ATOM    976  N   VAL A  65      12.642 108.289 -22.289  1.00  0.00           N  
ATOM    977  CA  VAL A  65      13.829 107.458 -22.292  1.00  0.00           C  
ATOM    978  C   VAL A  65      13.688 106.332 -21.277  1.00  0.00           C  
ATOM    979  O   VAL A  65      14.142 105.219 -21.526  1.00  0.00           O  
ATOM    980  CB  VAL A  65      15.074 108.328 -22.075  1.00  0.00           C  
ATOM    981  CG1 VAL A  65      15.551 108.826 -23.441  1.00  0.00           C  
ATOM    982  CG2 VAL A  65      14.835 109.531 -21.155  1.00  0.00           C  
ATOM    983  H   VAL A  65      12.708 109.252 -22.005  1.00  0.00           H  
ATOM    984  HA  VAL A  65      13.836 107.077 -23.310  1.00  0.00           H  
ATOM    985  HB  VAL A  65      15.804 107.755 -21.501  1.00  0.00           H  
ATOM    986 HG11 VAL A  65      16.395 109.499 -23.319  1.00  0.00           H  
ATOM    987 HG12 VAL A  65      14.733 109.363 -23.929  1.00  0.00           H  
ATOM    988 HG13 VAL A  65      15.835 107.979 -24.065  1.00  0.00           H  
ATOM    989 HG21 VAL A  65      14.266 110.315 -21.650  1.00  0.00           H  
ATOM    990 HG22 VAL A  65      15.806 109.941 -20.871  1.00  0.00           H  
ATOM    991 HG23 VAL A  65      14.312 109.203 -20.256  1.00  0.00           H  
ATOM    992  N   ALA A  66      13.035 106.606 -20.146  1.00  0.00           N  
ATOM    993  CA  ALA A  66      12.792 105.587 -19.134  1.00  0.00           C  
ATOM    994  C   ALA A  66      12.041 104.412 -19.770  1.00  0.00           C  
ATOM    995  O   ALA A  66      12.371 103.258 -19.530  1.00  0.00           O  
ATOM    996  CB  ALA A  66      12.024 106.190 -17.952  1.00  0.00           C  
ATOM    997  H   ALA A  66      12.599 107.515 -20.054  1.00  0.00           H  
ATOM    998  HA  ALA A  66      13.753 105.221 -18.776  1.00  0.00           H  
ATOM    999  HB1 ALA A  66      11.007 106.451 -18.232  1.00  0.00           H  
ATOM   1000  HB2 ALA A  66      12.537 107.084 -17.597  1.00  0.00           H  
ATOM   1001  HB3 ALA A  66      11.964 105.472 -17.137  1.00  0.00           H  
ATOM   1002  N   SER A  67      11.067 104.707 -20.631  1.00  0.00           N  
ATOM   1003  CA  SER A  67      10.275 103.716 -21.335  1.00  0.00           C  
ATOM   1004  C   SER A  67      11.154 102.979 -22.341  1.00  0.00           C  
ATOM   1005  O   SER A  67      11.134 101.754 -22.404  1.00  0.00           O  
ATOM   1006  CB  SER A  67       9.082 104.396 -22.019  1.00  0.00           C  
ATOM   1007  OG  SER A  67       8.387 105.214 -21.096  1.00  0.00           O  
ATOM   1008  H   SER A  67      10.893 105.683 -20.829  1.00  0.00           H  
ATOM   1009  HA  SER A  67       9.898 102.993 -20.614  1.00  0.00           H  
ATOM   1010  HB2 SER A  67       9.416 105.005 -22.859  1.00  0.00           H  
ATOM   1011  HB3 SER A  67       8.408 103.627 -22.399  1.00  0.00           H  
ATOM   1012  HG  SER A  67       8.982 105.902 -20.770  1.00  0.00           H  
ATOM   1013  N   GLU A  68      11.934 103.735 -23.120  1.00  0.00           N  
ATOM   1014  CA  GLU A  68      12.849 103.180 -24.116  1.00  0.00           C  
ATOM   1015  C   GLU A  68      13.823 102.182 -23.475  1.00  0.00           C  
ATOM   1016  O   GLU A  68      14.079 101.120 -24.037  1.00  0.00           O  
ATOM   1017  CB  GLU A  68      13.630 104.314 -24.791  1.00  0.00           C  
ATOM   1018  CG  GLU A  68      12.732 105.206 -25.661  1.00  0.00           C  
ATOM   1019  CD  GLU A  68      13.425 106.515 -26.026  1.00  0.00           C  
ATOM   1020  OE1 GLU A  68      14.563 106.433 -26.537  1.00  0.00           O  
ATOM   1021  OE2 GLU A  68      12.814 107.576 -25.772  1.00  0.00           O  
ATOM   1022  H   GLU A  68      11.875 104.741 -23.003  1.00  0.00           H  
ATOM   1023  HA  GLU A  68      12.271 102.649 -24.874  1.00  0.00           H  
ATOM   1024  HB2 GLU A  68      14.127 104.912 -24.029  1.00  0.00           H  
ATOM   1025  HB3 GLU A  68      14.406 103.878 -25.422  1.00  0.00           H  
ATOM   1026  HG2 GLU A  68      12.479 104.673 -26.579  1.00  0.00           H  
ATOM   1027  HG3 GLU A  68      11.805 105.437 -25.140  1.00  0.00           H  
ATOM   1028  N   TYR A  69      14.368 102.526 -22.305  1.00  0.00           N  
ATOM   1029  CA  TYR A  69      15.323 101.684 -21.596  1.00  0.00           C  
ATOM   1030  C   TYR A  69      14.616 100.546 -20.855  1.00  0.00           C  
ATOM   1031  O   TYR A  69      15.176  99.459 -20.743  1.00  0.00           O  
ATOM   1032  CB  TYR A  69      16.125 102.538 -20.604  1.00  0.00           C  
ATOM   1033  CG  TYR A  69      17.323 103.250 -21.207  1.00  0.00           C  
ATOM   1034  CD1 TYR A  69      18.447 102.507 -21.615  1.00  0.00           C  
ATOM   1035  CD2 TYR A  69      17.326 104.648 -21.350  1.00  0.00           C  
ATOM   1036  CE1 TYR A  69      19.548 103.156 -22.200  1.00  0.00           C  
ATOM   1037  CE2 TYR A  69      18.398 105.290 -21.993  1.00  0.00           C  
ATOM   1038  CZ  TYR A  69      19.514 104.544 -22.407  1.00  0.00           C  
ATOM   1039  OH  TYR A  69      20.575 105.163 -22.996  1.00  0.00           O  
ATOM   1040  H   TYR A  69      14.157 103.445 -21.935  1.00  0.00           H  
ATOM   1041  HA  TYR A  69      16.013 101.229 -22.310  1.00  0.00           H  
ATOM   1042  HB2 TYR A  69      15.461 103.258 -20.126  1.00  0.00           H  
ATOM   1043  HB3 TYR A  69      16.502 101.883 -19.821  1.00  0.00           H  
ATOM   1044  HD1 TYR A  69      18.463 101.434 -21.486  1.00  0.00           H  
ATOM   1045  HD2 TYR A  69      16.511 105.240 -20.970  1.00  0.00           H  
ATOM   1046  HE1 TYR A  69      20.409 102.590 -22.523  1.00  0.00           H  
ATOM   1047  HE2 TYR A  69      18.343 106.351 -22.170  1.00  0.00           H  
ATOM   1048  HH  TYR A  69      20.417 106.091 -23.181  1.00  0.00           H  
ATOM   1049  N   GLY A  70      13.413 100.793 -20.331  1.00  0.00           N  
ATOM   1050  CA  GLY A  70      12.643  99.806 -19.586  1.00  0.00           C  
ATOM   1051  C   GLY A  70      12.838 100.027 -18.092  1.00  0.00           C  
ATOM   1052  O   GLY A  70      13.260  99.129 -17.368  1.00  0.00           O  
ATOM   1053  H   GLY A  70      13.035 101.730 -20.398  1.00  0.00           H  
ATOM   1054  HA2 GLY A  70      11.587  99.917 -19.833  1.00  0.00           H  
ATOM   1055  HA3 GLY A  70      12.958  98.794 -19.834  1.00  0.00           H  
ATOM   1056  N   ILE A  71      12.532 101.243 -17.641  1.00  0.00           N  
ATOM   1057  CA  ILE A  71      12.674 101.703 -16.272  1.00  0.00           C  
ATOM   1058  C   ILE A  71      11.298 102.161 -15.793  1.00  0.00           C  
ATOM   1059  O   ILE A  71      10.514 102.684 -16.584  1.00  0.00           O  
ATOM   1060  CB  ILE A  71      13.676 102.873 -16.226  1.00  0.00           C  
ATOM   1061  CG1 ILE A  71      14.975 102.536 -16.984  1.00  0.00           C  
ATOM   1062  CG2 ILE A  71      13.965 103.258 -14.767  1.00  0.00           C  
ATOM   1063  CD1 ILE A  71      15.916 103.741 -17.058  1.00  0.00           C  
ATOM   1064  H   ILE A  71      12.176 101.923 -18.304  1.00  0.00           H  
ATOM   1065  HA  ILE A  71      13.037 100.891 -15.639  1.00  0.00           H  
ATOM   1066  HB  ILE A  71      13.227 103.728 -16.728  1.00  0.00           H  
ATOM   1067 HG12 ILE A  71      15.470 101.671 -16.542  1.00  0.00           H  
ATOM   1068 HG13 ILE A  71      14.733 102.293 -18.017  1.00  0.00           H  
ATOM   1069 HG21 ILE A  71      14.331 102.393 -14.217  1.00  0.00           H  
ATOM   1070 HG22 ILE A  71      14.702 104.059 -14.721  1.00  0.00           H  
ATOM   1071 HG23 ILE A  71      13.062 103.628 -14.284  1.00  0.00           H  
ATOM   1072 HD11 ILE A  71      16.456 103.888 -16.124  1.00  0.00           H  
ATOM   1073 HD12 ILE A  71      15.338 104.633 -17.279  1.00  0.00           H  
ATOM   1074 HD13 ILE A  71      16.634 103.600 -17.864  1.00  0.00           H  
ATOM   1075  N   ARG A  72      11.008 101.970 -14.505  1.00  0.00           N  
ATOM   1076  CA  ARG A  72       9.776 102.422 -13.877  1.00  0.00           C  
ATOM   1077  C   ARG A  72      10.089 102.735 -12.422  1.00  0.00           C  
ATOM   1078  O   ARG A  72       9.947 103.874 -11.980  1.00  0.00           O  
ATOM   1079  CB  ARG A  72       8.675 101.357 -14.015  1.00  0.00           C  
ATOM   1080  CG  ARG A  72       7.487 101.590 -13.065  1.00  0.00           C  
ATOM   1081  CD  ARG A  72       6.819 102.959 -13.262  1.00  0.00           C  
ATOM   1082  NE  ARG A  72       5.855 103.233 -12.189  1.00  0.00           N  
ATOM   1083  CZ  ARG A  72       6.151 103.778 -10.998  1.00  0.00           C  
ATOM   1084  NH1 ARG A  72       7.407 104.107 -10.673  1.00  0.00           N  
ATOM   1085  NH2 ARG A  72       5.166 103.994 -10.120  1.00  0.00           N  
ATOM   1086  H   ARG A  72      11.717 101.567 -13.908  1.00  0.00           H  
ATOM   1087  HA  ARG A  72       9.451 103.345 -14.361  1.00  0.00           H  
ATOM   1088  HB2 ARG A  72       8.317 101.352 -15.046  1.00  0.00           H  
ATOM   1089  HB3 ARG A  72       9.091 100.374 -13.794  1.00  0.00           H  
ATOM   1090  HG2 ARG A  72       6.742 100.814 -13.248  1.00  0.00           H  
ATOM   1091  HG3 ARG A  72       7.818 101.482 -12.029  1.00  0.00           H  
ATOM   1092  HD2 ARG A  72       7.542 103.772 -13.298  1.00  0.00           H  
ATOM   1093  HD3 ARG A  72       6.289 102.954 -14.217  1.00  0.00           H  
ATOM   1094  HE  ARG A  72       4.892 103.000 -12.386  1.00  0.00           H  
ATOM   1095 HH11 ARG A  72       8.173 103.970 -11.326  1.00  0.00           H  
ATOM   1096 HH12 ARG A  72       7.611 104.519  -9.775  1.00  0.00           H  
ATOM   1097 HH21 ARG A  72       4.217 103.747 -10.359  1.00  0.00           H  
ATOM   1098 HH22 ARG A  72       5.356 104.409  -9.220  1.00  0.00           H  
ATOM   1099  N   SER A  73      10.471 101.708 -11.664  1.00  0.00           N  
ATOM   1100  CA  SER A  73      10.874 101.883 -10.288  1.00  0.00           C  
ATOM   1101  C   SER A  73      12.139 102.736 -10.289  1.00  0.00           C  
ATOM   1102  O   SER A  73      12.971 102.617 -11.192  1.00  0.00           O  
ATOM   1103  CB  SER A  73      11.136 100.514  -9.661  1.00  0.00           C  
ATOM   1104  OG  SER A  73      10.300  99.540 -10.267  1.00  0.00           O  
ATOM   1105  H   SER A  73      10.467 100.758 -12.007  1.00  0.00           H  
ATOM   1106  HA  SER A  73      10.068 102.383  -9.747  1.00  0.00           H  
ATOM   1107  HB2 SER A  73      12.181 100.262  -9.831  1.00  0.00           H  
ATOM   1108  HB3 SER A  73      10.959 100.562  -8.585  1.00  0.00           H  
ATOM   1109  HG  SER A  73      10.450  98.689  -9.844  1.00  0.00           H  
ATOM   1110  N   ILE A  74      12.284 103.588  -9.281  1.00  0.00           N  
ATOM   1111  CA  ILE A  74      13.420 104.474  -9.151  1.00  0.00           C  
ATOM   1112  C   ILE A  74      13.739 104.564  -7.654  1.00  0.00           C  
ATOM   1113  O   ILE A  74      12.851 104.301  -6.842  1.00  0.00           O  
ATOM   1114  CB  ILE A  74      13.131 105.832  -9.835  1.00  0.00           C  
ATOM   1115  CG1 ILE A  74      11.700 106.362  -9.659  1.00  0.00           C  
ATOM   1116  CG2 ILE A  74      13.423 105.704 -11.340  1.00  0.00           C  
ATOM   1117  CD1 ILE A  74      11.657 107.867  -9.936  1.00  0.00           C  
ATOM   1118  H   ILE A  74      11.665 103.545  -8.486  1.00  0.00           H  
ATOM   1119  HA  ILE A  74      14.262 103.999  -9.640  1.00  0.00           H  
ATOM   1120  HB  ILE A  74      13.792 106.580  -9.416  1.00  0.00           H  
ATOM   1121 HG12 ILE A  74      11.021 105.839 -10.333  1.00  0.00           H  
ATOM   1122 HG13 ILE A  74      11.355 106.225  -8.640  1.00  0.00           H  
ATOM   1123 HG21 ILE A  74      14.418 105.293 -11.493  1.00  0.00           H  
ATOM   1124 HG22 ILE A  74      12.690 105.061 -11.826  1.00  0.00           H  
ATOM   1125 HG23 ILE A  74      13.388 106.678 -11.819  1.00  0.00           H  
ATOM   1126 HD11 ILE A  74      11.969 108.085 -10.952  1.00  0.00           H  
ATOM   1127 HD12 ILE A  74      10.652 108.247  -9.799  1.00  0.00           H  
ATOM   1128 HD13 ILE A  74      12.314 108.380  -9.238  1.00  0.00           H  
ATOM   1129  N   PRO A  75      14.976 104.901  -7.249  1.00  0.00           N  
ATOM   1130  CA  PRO A  75      16.098 105.273  -8.095  1.00  0.00           C  
ATOM   1131  C   PRO A  75      16.616 104.127  -8.957  1.00  0.00           C  
ATOM   1132  O   PRO A  75      16.635 102.967  -8.546  1.00  0.00           O  
ATOM   1133  CB  PRO A  75      17.199 105.770  -7.158  1.00  0.00           C  
ATOM   1134  CG  PRO A  75      16.880 105.078  -5.833  1.00  0.00           C  
ATOM   1135  CD  PRO A  75      15.356 104.967  -5.849  1.00  0.00           C  
ATOM   1136  HA  PRO A  75      15.820 106.103  -8.742  1.00  0.00           H  
ATOM   1137  HB2 PRO A  75      18.202 105.524  -7.513  1.00  0.00           H  
ATOM   1138  HB3 PRO A  75      17.109 106.850  -7.069  1.00  0.00           H  
ATOM   1139  HG2 PRO A  75      17.313 104.080  -5.859  1.00  0.00           H  
ATOM   1140  HG3 PRO A  75      17.254 105.633  -4.971  1.00  0.00           H  
ATOM   1141  HD2 PRO A  75      15.011 104.098  -5.286  1.00  0.00           H  
ATOM   1142  HD3 PRO A  75      14.926 105.862  -5.414  1.00  0.00           H  
ATOM   1143  N   THR A  76      16.979 104.503 -10.179  1.00  0.00           N  
ATOM   1144  CA  THR A  76      17.606 103.673 -11.185  1.00  0.00           C  
ATOM   1145  C   THR A  76      18.737 104.559 -11.696  1.00  0.00           C  
ATOM   1146  O   THR A  76      18.508 105.526 -12.424  1.00  0.00           O  
ATOM   1147  CB  THR A  76      16.605 103.229 -12.268  1.00  0.00           C  
ATOM   1148  OG1 THR A  76      15.687 102.301 -11.715  1.00  0.00           O  
ATOM   1149  CG2 THR A  76      17.339 102.533 -13.417  1.00  0.00           C  
ATOM   1150  H   THR A  76      16.933 105.498 -10.373  1.00  0.00           H  
ATOM   1151  HA  THR A  76      18.019 102.777 -10.726  1.00  0.00           H  
ATOM   1152  HB  THR A  76      16.072 104.092 -12.665  1.00  0.00           H  
ATOM   1153  HG1 THR A  76      14.828 102.715 -11.553  1.00  0.00           H  
ATOM   1154 HG21 THR A  76      17.976 103.239 -13.951  1.00  0.00           H  
ATOM   1155 HG22 THR A  76      16.623 102.114 -14.121  1.00  0.00           H  
ATOM   1156 HG23 THR A  76      17.951 101.722 -13.022  1.00  0.00           H  
ATOM   1157  N   ILE A  77      19.945 104.273 -11.218  1.00  0.00           N  
ATOM   1158  CA  ILE A  77      21.153 105.021 -11.495  1.00  0.00           C  
ATOM   1159  C   ILE A  77      21.886 104.311 -12.623  1.00  0.00           C  
ATOM   1160  O   ILE A  77      22.534 103.296 -12.375  1.00  0.00           O  
ATOM   1161  CB  ILE A  77      21.992 105.108 -10.205  1.00  0.00           C  
ATOM   1162  CG1 ILE A  77      21.218 105.879  -9.116  1.00  0.00           C  
ATOM   1163  CG2 ILE A  77      23.327 105.805 -10.492  1.00  0.00           C  
ATOM   1164  CD1 ILE A  77      21.885 105.812  -7.738  1.00  0.00           C  
ATOM   1165  H   ILE A  77      20.047 103.434 -10.659  1.00  0.00           H  
ATOM   1166  HA  ILE A  77      20.909 106.026 -11.808  1.00  0.00           H  
ATOM   1167  HB  ILE A  77      22.189 104.102  -9.845  1.00  0.00           H  
ATOM   1168 HG12 ILE A  77      21.117 106.922  -9.410  1.00  0.00           H  
ATOM   1169 HG13 ILE A  77      20.221 105.456  -9.002  1.00  0.00           H  
ATOM   1170 HG21 ILE A  77      23.897 105.265 -11.247  1.00  0.00           H  
ATOM   1171 HG22 ILE A  77      23.933 105.832  -9.588  1.00  0.00           H  
ATOM   1172 HG23 ILE A  77      23.139 106.819 -10.845  1.00  0.00           H  
ATOM   1173 HD11 ILE A  77      22.060 104.772  -7.459  1.00  0.00           H  
ATOM   1174 HD12 ILE A  77      21.223 106.268  -7.002  1.00  0.00           H  
ATOM   1175 HD13 ILE A  77      22.830 106.355  -7.735  1.00  0.00           H  
ATOM   1176  N   MET A  78      21.770 104.808 -13.857  1.00  0.00           N  
ATOM   1177  CA  MET A  78      22.480 104.218 -14.980  1.00  0.00           C  
ATOM   1178  C   MET A  78      23.859 104.856 -15.096  1.00  0.00           C  
ATOM   1179  O   MET A  78      24.043 106.035 -14.795  1.00  0.00           O  
ATOM   1180  CB  MET A  78      21.725 104.388 -16.294  1.00  0.00           C  
ATOM   1181  CG  MET A  78      20.313 103.802 -16.254  1.00  0.00           C  
ATOM   1182  SD  MET A  78      19.553 103.596 -17.887  1.00  0.00           S  
ATOM   1183  CE  MET A  78      18.912 101.916 -17.709  1.00  0.00           C  
ATOM   1184  H   MET A  78      21.331 105.716 -13.976  1.00  0.00           H  
ATOM   1185  HA  MET A  78      22.594 103.149 -14.829  1.00  0.00           H  
ATOM   1186  HB2 MET A  78      21.702 105.439 -16.539  1.00  0.00           H  
ATOM   1187  HB3 MET A  78      22.287 103.873 -17.074  1.00  0.00           H  
ATOM   1188  HG2 MET A  78      20.366 102.820 -15.795  1.00  0.00           H  
ATOM   1189  HG3 MET A  78      19.667 104.429 -15.643  1.00  0.00           H  
ATOM   1190  HE1 MET A  78      18.446 101.613 -18.642  1.00  0.00           H  
ATOM   1191  HE2 MET A  78      18.179 101.887 -16.904  1.00  0.00           H  
ATOM   1192  HE3 MET A  78      19.728 101.232 -17.483  1.00  0.00           H  
ATOM   1193  N   VAL A  79      24.810 104.054 -15.562  1.00  0.00           N  
ATOM   1194  CA  VAL A  79      26.198 104.425 -15.782  1.00  0.00           C  
ATOM   1195  C   VAL A  79      26.463 104.354 -17.273  1.00  0.00           C  
ATOM   1196  O   VAL A  79      26.038 103.400 -17.922  1.00  0.00           O  
ATOM   1197  CB  VAL A  79      27.152 103.454 -15.062  1.00  0.00           C  
ATOM   1198  CG1 VAL A  79      28.614 103.672 -15.503  1.00  0.00           C  
ATOM   1199  CG2 VAL A  79      27.024 103.614 -13.544  1.00  0.00           C  
ATOM   1200  H   VAL A  79      24.498 103.159 -15.919  1.00  0.00           H  
ATOM   1201  HA  VAL A  79      26.383 105.434 -15.415  1.00  0.00           H  
ATOM   1202  HB  VAL A  79      26.877 102.433 -15.322  1.00  0.00           H  
ATOM   1203 HG11 VAL A  79      29.278 103.012 -14.949  1.00  0.00           H  
ATOM   1204 HG12 VAL A  79      28.912 104.708 -15.343  1.00  0.00           H  
ATOM   1205 HG13 VAL A  79      28.751 103.445 -16.562  1.00  0.00           H  
ATOM   1206 HG21 VAL A  79      26.000 103.411 -13.228  1.00  0.00           H  
ATOM   1207 HG22 VAL A  79      27.290 104.631 -13.260  1.00  0.00           H  
ATOM   1208 HG23 VAL A  79      27.689 102.914 -13.040  1.00  0.00           H  
ATOM   1209  N   PHE A  80      27.214 105.327 -17.782  1.00  0.00           N  
ATOM   1210  CA  PHE A  80      27.676 105.399 -19.152  1.00  0.00           C  
ATOM   1211  C   PHE A  80      29.179 105.645 -19.059  1.00  0.00           C  
ATOM   1212  O   PHE A  80      29.631 106.322 -18.136  1.00  0.00           O  
ATOM   1213  CB  PHE A  80      26.957 106.521 -19.916  1.00  0.00           C  
ATOM   1214  CG  PHE A  80      25.439 106.505 -19.803  1.00  0.00           C  
ATOM   1215  CD1 PHE A  80      24.812 106.884 -18.600  1.00  0.00           C  
ATOM   1216  CD2 PHE A  80      24.648 106.047 -20.873  1.00  0.00           C  
ATOM   1217  CE1 PHE A  80      23.431 106.703 -18.435  1.00  0.00           C  
ATOM   1218  CE2 PHE A  80      23.266 105.855 -20.705  1.00  0.00           C  
ATOM   1219  CZ  PHE A  80      22.658 106.165 -19.477  1.00  0.00           C  
ATOM   1220  H   PHE A  80      27.546 106.060 -17.160  1.00  0.00           H  
ATOM   1221  HA  PHE A  80      27.505 104.447 -19.650  1.00  0.00           H  
ATOM   1222  HB2 PHE A  80      27.339 107.467 -19.551  1.00  0.00           H  
ATOM   1223  HB3 PHE A  80      27.240 106.466 -20.967  1.00  0.00           H  
ATOM   1224  HD1 PHE A  80      25.393 107.277 -17.779  1.00  0.00           H  
ATOM   1225  HD2 PHE A  80      25.095 105.827 -21.828  1.00  0.00           H  
ATOM   1226  HE1 PHE A  80      22.976 106.973 -17.497  1.00  0.00           H  
ATOM   1227  HE2 PHE A  80      22.677 105.465 -21.521  1.00  0.00           H  
ATOM   1228  HZ  PHE A  80      21.599 106.001 -19.339  1.00  0.00           H  
ATOM   1229  N   LYS A  81      29.942 105.070 -19.987  1.00  0.00           N  
ATOM   1230  CA  LYS A  81      31.399 105.218 -20.014  1.00  0.00           C  
ATOM   1231  C   LYS A  81      31.833 106.244 -21.063  1.00  0.00           C  
ATOM   1232  O   LYS A  81      32.881 106.868 -20.916  1.00  0.00           O  
ATOM   1233  CB  LYS A  81      32.087 103.854 -20.203  1.00  0.00           C  
ATOM   1234  CG  LYS A  81      31.975 103.176 -21.576  1.00  0.00           C  
ATOM   1235  CD  LYS A  81      30.539 102.775 -21.924  1.00  0.00           C  
ATOM   1236  CE  LYS A  81      30.486 101.732 -23.044  1.00  0.00           C  
ATOM   1237  NZ  LYS A  81      31.083 102.243 -24.291  1.00  0.00           N  
ATOM   1238  H   LYS A  81      29.462 104.549 -20.709  1.00  0.00           H  
ATOM   1239  HA  LYS A  81      31.750 105.593 -19.052  1.00  0.00           H  
ATOM   1240  HB2 LYS A  81      33.152 104.007 -20.014  1.00  0.00           H  
ATOM   1241  HB3 LYS A  81      31.718 103.168 -19.437  1.00  0.00           H  
ATOM   1242  HG2 LYS A  81      32.389 103.824 -22.350  1.00  0.00           H  
ATOM   1243  HG3 LYS A  81      32.586 102.272 -21.531  1.00  0.00           H  
ATOM   1244  HD2 LYS A  81      30.055 102.359 -21.040  1.00  0.00           H  
ATOM   1245  HD3 LYS A  81      29.993 103.652 -22.254  1.00  0.00           H  
ATOM   1246  HE2 LYS A  81      31.011 100.828 -22.733  1.00  0.00           H  
ATOM   1247  HE3 LYS A  81      29.442 101.473 -23.232  1.00  0.00           H  
ATOM   1248  HZ1 LYS A  81      30.599 103.081 -24.582  1.00  0.00           H  
ATOM   1249  HZ2 LYS A  81      32.058 102.455 -24.140  1.00  0.00           H  
ATOM   1250  HZ3 LYS A  81      31.003 101.543 -25.016  1.00  0.00           H  
ATOM   1251  N   GLY A  82      31.025 106.419 -22.109  1.00  0.00           N  
ATOM   1252  CA  GLY A  82      31.294 107.339 -23.196  1.00  0.00           C  
ATOM   1253  C   GLY A  82      30.114 107.248 -24.148  1.00  0.00           C  
ATOM   1254  O   GLY A  82      30.097 106.398 -25.039  1.00  0.00           O  
ATOM   1255  H   GLY A  82      30.173 105.882 -22.160  1.00  0.00           H  
ATOM   1256  HA2 GLY A  82      31.405 108.357 -22.818  1.00  0.00           H  
ATOM   1257  HA3 GLY A  82      32.206 107.034 -23.710  1.00  0.00           H  
ATOM   1258  N   GLY A  83      29.079 108.050 -23.902  1.00  0.00           N  
ATOM   1259  CA  GLY A  83      27.862 108.054 -24.692  1.00  0.00           C  
ATOM   1260  C   GLY A  83      26.970 106.858 -24.380  1.00  0.00           C  
ATOM   1261  O   GLY A  83      25.850 107.011 -23.898  1.00  0.00           O  
ATOM   1262  H   GLY A  83      29.166 108.778 -23.198  1.00  0.00           H  
ATOM   1263  HA2 GLY A  83      27.328 108.954 -24.453  1.00  0.00           H  
ATOM   1264  HA3 GLY A  83      28.062 108.097 -25.758  1.00  0.00           H  
ATOM   1265  N   LYS A  84      27.472 105.656 -24.655  1.00  0.00           N  
ATOM   1266  CA  LYS A  84      26.741 104.415 -24.461  1.00  0.00           C  
ATOM   1267  C   LYS A  84      26.773 103.992 -22.989  1.00  0.00           C  
ATOM   1268  O   LYS A  84      27.676 104.360 -22.229  1.00  0.00           O  
ATOM   1269  CB  LYS A  84      27.321 103.317 -25.362  1.00  0.00           C  
ATOM   1270  CG  LYS A  84      27.579 103.773 -26.808  1.00  0.00           C  
ATOM   1271  CD  LYS A  84      26.311 104.325 -27.482  1.00  0.00           C  
ATOM   1272  CE  LYS A  84      26.585 104.774 -28.922  1.00  0.00           C  
ATOM   1273  NZ  LYS A  84      27.482 105.944 -28.971  1.00  0.00           N  
ATOM   1274  H   LYS A  84      28.425 105.626 -24.995  1.00  0.00           H  
ATOM   1275  HA  LYS A  84      25.699 104.576 -24.739  1.00  0.00           H  
ATOM   1276  HB2 LYS A  84      28.261 102.977 -24.928  1.00  0.00           H  
ATOM   1277  HB3 LYS A  84      26.631 102.472 -25.372  1.00  0.00           H  
ATOM   1278  HG2 LYS A  84      28.369 104.525 -26.816  1.00  0.00           H  
ATOM   1279  HG3 LYS A  84      27.934 102.912 -27.375  1.00  0.00           H  
ATOM   1280  HD2 LYS A  84      25.549 103.544 -27.493  1.00  0.00           H  
ATOM   1281  HD3 LYS A  84      25.922 105.179 -26.928  1.00  0.00           H  
ATOM   1282  HE2 LYS A  84      27.025 103.953 -29.491  1.00  0.00           H  
ATOM   1283  HE3 LYS A  84      25.638 105.049 -29.389  1.00  0.00           H  
ATOM   1284  HZ1 LYS A  84      28.380 105.706 -28.575  1.00  0.00           H  
ATOM   1285  HZ2 LYS A  84      27.077 106.706 -28.446  1.00  0.00           H  
ATOM   1286  HZ3 LYS A  84      27.609 106.232 -29.930  1.00  0.00           H  
ATOM   1287  N   LYS A  85      25.753 103.223 -22.605  1.00  0.00           N  
ATOM   1288  CA  LYS A  85      25.560 102.727 -21.253  1.00  0.00           C  
ATOM   1289  C   LYS A  85      26.603 101.651 -20.944  1.00  0.00           C  
ATOM   1290  O   LYS A  85      27.165 101.045 -21.856  1.00  0.00           O  
ATOM   1291  CB  LYS A  85      24.128 102.178 -21.116  1.00  0.00           C  
ATOM   1292  CG  LYS A  85      23.673 102.114 -19.650  1.00  0.00           C  
ATOM   1293  CD  LYS A  85      22.203 101.716 -19.464  1.00  0.00           C  
ATOM   1294  CE  LYS A  85      21.895 100.257 -19.830  1.00  0.00           C  
ATOM   1295  NZ  LYS A  85      21.586 100.087 -21.260  1.00  0.00           N  
ATOM   1296  H   LYS A  85      25.108 102.915 -23.316  1.00  0.00           H  
ATOM   1297  HA  LYS A  85      25.682 103.557 -20.562  1.00  0.00           H  
ATOM   1298  HB2 LYS A  85      23.440 102.837 -21.648  1.00  0.00           H  
ATOM   1299  HB3 LYS A  85      24.096 101.187 -21.571  1.00  0.00           H  
ATOM   1300  HG2 LYS A  85      24.291 101.417 -19.084  1.00  0.00           H  
ATOM   1301  HG3 LYS A  85      23.796 103.108 -19.216  1.00  0.00           H  
ATOM   1302  HD2 LYS A  85      21.988 101.832 -18.400  1.00  0.00           H  
ATOM   1303  HD3 LYS A  85      21.550 102.401 -20.008  1.00  0.00           H  
ATOM   1304  HE2 LYS A  85      22.730  99.614 -19.547  1.00  0.00           H  
ATOM   1305  HE3 LYS A  85      21.016  99.938 -19.268  1.00  0.00           H  
ATOM   1306  HZ1 LYS A  85      20.784 100.651 -21.501  1.00  0.00           H  
ATOM   1307  HZ2 LYS A  85      22.372 100.368 -21.826  1.00  0.00           H  
ATOM   1308  HZ3 LYS A  85      21.375  99.116 -21.445  1.00  0.00           H  
ATOM   1309  N   CYS A  86      26.858 101.423 -19.655  1.00  0.00           N  
ATOM   1310  CA  CYS A  86      27.781 100.414 -19.159  1.00  0.00           C  
ATOM   1311  C   CYS A  86      27.086  99.523 -18.137  1.00  0.00           C  
ATOM   1312  O   CYS A  86      27.047  98.309 -18.309  1.00  0.00           O  
ATOM   1313  CB  CYS A  86      28.993 101.074 -18.495  1.00  0.00           C  
ATOM   1314  SG  CYS A  86      30.322  99.850 -18.385  1.00  0.00           S  
ATOM   1315  H   CYS A  86      26.374 102.000 -18.978  1.00  0.00           H  
ATOM   1316  HA  CYS A  86      28.132  99.791 -19.983  1.00  0.00           H  
ATOM   1317  HB2 CYS A  86      29.333 101.929 -19.067  1.00  0.00           H  
ATOM   1318  HB3 CYS A  86      28.753 101.415 -17.492  1.00  0.00           H  
ATOM   1319  HG  CYS A  86      29.568  98.806 -18.020  1.00  0.00           H  
ATOM   1320  N   GLU A  87      26.566 100.129 -17.062  1.00  0.00           N  
ATOM   1321  CA  GLU A  87      25.960  99.435 -15.929  1.00  0.00           C  
ATOM   1322  C   GLU A  87      24.740 100.212 -15.426  1.00  0.00           C  
ATOM   1323  O   GLU A  87      24.436 101.293 -15.939  1.00  0.00           O  
ATOM   1324  CB  GLU A  87      26.994  99.314 -14.795  1.00  0.00           C  
ATOM   1325  CG  GLU A  87      28.382  98.828 -15.242  1.00  0.00           C  
ATOM   1326  CD  GLU A  87      28.395  97.415 -15.816  1.00  0.00           C  
ATOM   1327  OE1 GLU A  87      27.547  96.608 -15.375  1.00  0.00           O  
ATOM   1328  OE2 GLU A  87      29.281  97.161 -16.659  1.00  0.00           O  
ATOM   1329  H   GLU A  87      26.552 101.140 -17.040  1.00  0.00           H  
ATOM   1330  HA  GLU A  87      25.632  98.438 -16.232  1.00  0.00           H  
ATOM   1331  HB2 GLU A  87      27.126 100.293 -14.332  1.00  0.00           H  
ATOM   1332  HB3 GLU A  87      26.614  98.634 -14.030  1.00  0.00           H  
ATOM   1333  HG2 GLU A  87      28.843  99.540 -15.924  1.00  0.00           H  
ATOM   1334  HG3 GLU A  87      29.025  98.799 -14.378  1.00  0.00           H  
ATOM   1335  N   THR A  88      24.039  99.683 -14.417  1.00  0.00           N  
ATOM   1336  CA  THR A  88      22.888 100.323 -13.792  1.00  0.00           C  
ATOM   1337  C   THR A  88      22.708  99.779 -12.370  1.00  0.00           C  
ATOM   1338  O   THR A  88      22.771  98.568 -12.180  1.00  0.00           O  
ATOM   1339  CB  THR A  88      21.623 100.076 -14.634  1.00  0.00           C  
ATOM   1340  OG1 THR A  88      21.754 100.645 -15.923  1.00  0.00           O  
ATOM   1341  CG2 THR A  88      20.380 100.682 -13.977  1.00  0.00           C  
ATOM   1342  H   THR A  88      24.317  98.790 -14.029  1.00  0.00           H  
ATOM   1343  HA  THR A  88      23.096 101.383 -13.724  1.00  0.00           H  
ATOM   1344  HB  THR A  88      21.475  98.999 -14.742  1.00  0.00           H  
ATOM   1345  HG1 THR A  88      22.634 101.027 -16.014  1.00  0.00           H  
ATOM   1346 HG21 THR A  88      20.552 101.731 -13.733  1.00  0.00           H  
ATOM   1347 HG22 THR A  88      19.536 100.605 -14.664  1.00  0.00           H  
ATOM   1348 HG23 THR A  88      20.128 100.144 -13.064  1.00  0.00           H  
ATOM   1349  N   ILE A  89      22.512 100.661 -11.389  1.00  0.00           N  
ATOM   1350  CA  ILE A  89      22.249 100.332  -9.992  1.00  0.00           C  
ATOM   1351  C   ILE A  89      20.781 100.705  -9.755  1.00  0.00           C  
ATOM   1352  O   ILE A  89      20.313 101.679 -10.342  1.00  0.00           O  
ATOM   1353  CB  ILE A  89      23.188 101.125  -9.058  1.00  0.00           C  
ATOM   1354  CG1 ILE A  89      24.659 101.029  -9.511  1.00  0.00           C  
ATOM   1355  CG2 ILE A  89      23.042 100.608  -7.617  1.00  0.00           C  
ATOM   1356  CD1 ILE A  89      25.584 101.940  -8.696  1.00  0.00           C  
ATOM   1357  H   ILE A  89      22.443 101.644 -11.636  1.00  0.00           H  
ATOM   1358  HA  ILE A  89      22.394  99.264  -9.823  1.00  0.00           H  
ATOM   1359  HB  ILE A  89      22.901 102.174  -9.079  1.00  0.00           H  
ATOM   1360 HG12 ILE A  89      25.006  99.997  -9.443  1.00  0.00           H  
ATOM   1361 HG13 ILE A  89      24.751 101.357 -10.546  1.00  0.00           H  
ATOM   1362 HG21 ILE A  89      22.008 100.691  -7.282  1.00  0.00           H  
ATOM   1363 HG22 ILE A  89      23.353  99.566  -7.557  1.00  0.00           H  
ATOM   1364 HG23 ILE A  89      23.650 101.201  -6.936  1.00  0.00           H  
ATOM   1365 HD11 ILE A  89      26.560 101.984  -9.181  1.00  0.00           H  
ATOM   1366 HD12 ILE A  89      25.717 101.559  -7.684  1.00  0.00           H  
ATOM   1367 HD13 ILE A  89      25.172 102.949  -8.655  1.00  0.00           H  
ATOM   1368  N   ILE A  90      20.044  99.947  -8.936  1.00  0.00           N  
ATOM   1369  CA  ILE A  90      18.632 100.200  -8.663  1.00  0.00           C  
ATOM   1370  C   ILE A  90      18.423 100.190  -7.149  1.00  0.00           C  
ATOM   1371  O   ILE A  90      19.043  99.390  -6.451  1.00  0.00           O  
ATOM   1372  CB  ILE A  90      17.760  99.139  -9.373  1.00  0.00           C  
ATOM   1373  CG1 ILE A  90      18.066  99.136 -10.884  1.00  0.00           C  
ATOM   1374  CG2 ILE A  90      16.268  99.430  -9.140  1.00  0.00           C  
ATOM   1375  CD1 ILE A  90      17.205  98.161 -11.693  1.00  0.00           C  
ATOM   1376  H   ILE A  90      20.474  99.192  -8.419  1.00  0.00           H  
ATOM   1377  HA  ILE A  90      18.349 101.182  -9.036  1.00  0.00           H  
ATOM   1378  HB  ILE A  90      17.994  98.153  -8.966  1.00  0.00           H  
ATOM   1379 HG12 ILE A  90      17.927 100.140 -11.285  1.00  0.00           H  
ATOM   1380 HG13 ILE A  90      19.103  98.837 -11.043  1.00  0.00           H  
ATOM   1381 HG21 ILE A  90      16.035  99.432  -8.076  1.00  0.00           H  
ATOM   1382 HG22 ILE A  90      15.654  98.655  -9.595  1.00  0.00           H  
ATOM   1383 HG23 ILE A  90      16.002 100.396  -9.568  1.00  0.00           H  
ATOM   1384 HD11 ILE A  90      16.177  98.518 -11.758  1.00  0.00           H  
ATOM   1385 HD12 ILE A  90      17.605  98.088 -12.705  1.00  0.00           H  
ATOM   1386 HD13 ILE A  90      17.225  97.174 -11.231  1.00  0.00           H  
ATOM   1387  N   GLY A  91      17.550 101.072  -6.653  1.00  0.00           N  
ATOM   1388  CA  GLY A  91      17.214 101.169  -5.241  1.00  0.00           C  
ATOM   1389  C   GLY A  91      18.255 101.957  -4.445  1.00  0.00           C  
ATOM   1390  O   GLY A  91      19.279 102.381  -4.978  1.00  0.00           O  
ATOM   1391  H   GLY A  91      17.114 101.726  -7.294  1.00  0.00           H  
ATOM   1392  HA2 GLY A  91      16.250 101.671  -5.155  1.00  0.00           H  
ATOM   1393  HA3 GLY A  91      17.122 100.168  -4.814  1.00  0.00           H  
ATOM   1394  N   ALA A  92      17.953 102.205  -3.167  1.00  0.00           N  
ATOM   1395  CA  ALA A  92      18.857 102.907  -2.265  1.00  0.00           C  
ATOM   1396  C   ALA A  92      20.111 102.062  -2.019  1.00  0.00           C  
ATOM   1397  O   ALA A  92      20.072 100.840  -2.151  1.00  0.00           O  
ATOM   1398  CB  ALA A  92      18.129 103.201  -0.950  1.00  0.00           C  
ATOM   1399  H   ALA A  92      17.090 101.843  -2.789  1.00  0.00           H  
ATOM   1400  HA  ALA A  92      19.153 103.848  -2.729  1.00  0.00           H  
ATOM   1401  HB1 ALA A  92      17.805 102.269  -0.488  1.00  0.00           H  
ATOM   1402  HB2 ALA A  92      18.797 103.721  -0.263  1.00  0.00           H  
ATOM   1403  HB3 ALA A  92      17.260 103.831  -1.142  1.00  0.00           H  
ATOM   1404  N   VAL A  93      21.220 102.708  -1.646  1.00  0.00           N  
ATOM   1405  CA  VAL A  93      22.503 102.059  -1.417  1.00  0.00           C  
ATOM   1406  C   VAL A  93      23.277 102.841  -0.345  1.00  0.00           C  
ATOM   1407  O   VAL A  93      23.040 104.042  -0.212  1.00  0.00           O  
ATOM   1408  CB  VAL A  93      23.372 102.092  -2.692  1.00  0.00           C  
ATOM   1409  CG1 VAL A  93      24.105 100.792  -2.993  1.00  0.00           C  
ATOM   1410  CG2 VAL A  93      22.676 102.600  -3.965  1.00  0.00           C  
ATOM   1411  H   VAL A  93      21.201 103.709  -1.499  1.00  0.00           H  
ATOM   1412  HA  VAL A  93      22.332 101.032  -1.106  1.00  0.00           H  
ATOM   1413  HB  VAL A  93      24.213 102.720  -2.439  1.00  0.00           H  
ATOM   1414 HG11 VAL A  93      24.845 100.988  -3.774  1.00  0.00           H  
ATOM   1415 HG12 VAL A  93      24.641 100.468  -2.108  1.00  0.00           H  
ATOM   1416 HG13 VAL A  93      23.404 100.030  -3.310  1.00  0.00           H  
ATOM   1417 HG21 VAL A  93      21.856 101.932  -4.234  1.00  0.00           H  
ATOM   1418 HG22 VAL A  93      22.294 103.611  -3.822  1.00  0.00           H  
ATOM   1419 HG23 VAL A  93      23.381 102.618  -4.795  1.00  0.00           H  
ATOM   1420  N   PRO A  94      24.234 102.221   0.369  1.00  0.00           N  
ATOM   1421  CA  PRO A  94      25.138 102.921   1.255  1.00  0.00           C  
ATOM   1422  C   PRO A  94      26.277 103.476   0.394  1.00  0.00           C  
ATOM   1423  O   PRO A  94      26.788 102.802  -0.502  1.00  0.00           O  
ATOM   1424  CB  PRO A  94      25.655 101.895   2.269  1.00  0.00           C  
ATOM   1425  CG  PRO A  94      24.845 100.627   1.975  1.00  0.00           C  
ATOM   1426  CD  PRO A  94      24.497 100.806   0.501  1.00  0.00           C  
ATOM   1427  HA  PRO A  94      24.609 103.720   1.779  1.00  0.00           H  
ATOM   1428  HB2 PRO A  94      26.716 101.714   2.093  1.00  0.00           H  
ATOM   1429  HB3 PRO A  94      25.510 102.247   3.290  1.00  0.00           H  
ATOM   1430  HG2 PRO A  94      25.417  99.716   2.159  1.00  0.00           H  
ATOM   1431  HG3 PRO A  94      23.929 100.627   2.568  1.00  0.00           H  
ATOM   1432  HD2 PRO A  94      25.383 100.552  -0.071  1.00  0.00           H  
ATOM   1433  HD3 PRO A  94      23.674 100.183   0.176  1.00  0.00           H  
ATOM   1434  N   LYS A  95      26.694 104.701   0.694  1.00  0.00           N  
ATOM   1435  CA  LYS A  95      27.692 105.443  -0.054  1.00  0.00           C  
ATOM   1436  C   LYS A  95      28.947 104.619  -0.339  1.00  0.00           C  
ATOM   1437  O   LYS A  95      29.448 104.643  -1.459  1.00  0.00           O  
ATOM   1438  CB  LYS A  95      28.059 106.698   0.765  1.00  0.00           C  
ATOM   1439  CG  LYS A  95      29.051 107.655   0.084  1.00  0.00           C  
ATOM   1440  CD  LYS A  95      29.678 108.617   1.101  1.00  0.00           C  
ATOM   1441  CE  LYS A  95      30.599 109.637   0.417  1.00  0.00           C  
ATOM   1442  NZ  LYS A  95      31.768 109.006  -0.221  1.00  0.00           N  
ATOM   1443  H   LYS A  95      26.226 105.173   1.445  1.00  0.00           H  
ATOM   1444  HA  LYS A  95      27.204 105.639  -1.017  1.00  0.00           H  
ATOM   1445  HB2 LYS A  95      27.152 107.251   1.013  1.00  0.00           H  
ATOM   1446  HB3 LYS A  95      28.506 106.360   1.702  1.00  0.00           H  
ATOM   1447  HG2 LYS A  95      29.847 107.093  -0.405  1.00  0.00           H  
ATOM   1448  HG3 LYS A  95      28.522 108.247  -0.659  1.00  0.00           H  
ATOM   1449  HD2 LYS A  95      28.881 109.163   1.611  1.00  0.00           H  
ATOM   1450  HD3 LYS A  95      30.245 108.057   1.846  1.00  0.00           H  
ATOM   1451  HE2 LYS A  95      30.039 110.182  -0.341  1.00  0.00           H  
ATOM   1452  HE3 LYS A  95      30.957 110.350   1.163  1.00  0.00           H  
ATOM   1453  HZ1 LYS A  95      32.354 109.716  -0.640  1.00  0.00           H  
ATOM   1454  HZ2 LYS A  95      32.304 108.500   0.469  1.00  0.00           H  
ATOM   1455  HZ3 LYS A  95      31.461 108.370  -0.943  1.00  0.00           H  
ATOM   1456  N   ALA A  96      29.465 103.904   0.662  1.00  0.00           N  
ATOM   1457  CA  ALA A  96      30.653 103.074   0.504  1.00  0.00           C  
ATOM   1458  C   ALA A  96      30.488 102.115  -0.679  1.00  0.00           C  
ATOM   1459  O   ALA A  96      31.386 101.973  -1.509  1.00  0.00           O  
ATOM   1460  CB  ALA A  96      30.902 102.297   1.800  1.00  0.00           C  
ATOM   1461  H   ALA A  96      28.998 103.926   1.556  1.00  0.00           H  
ATOM   1462  HA  ALA A  96      31.513 103.718   0.312  1.00  0.00           H  
ATOM   1463  HB1 ALA A  96      30.052 101.653   2.025  1.00  0.00           H  
ATOM   1464  HB2 ALA A  96      31.055 102.992   2.626  1.00  0.00           H  
ATOM   1465  HB3 ALA A  96      31.796 101.680   1.688  1.00  0.00           H  
ATOM   1466  N   THR A  97      29.324 101.468  -0.763  1.00  0.00           N  
ATOM   1467  CA  THR A  97      29.033 100.540  -1.836  1.00  0.00           C  
ATOM   1468  C   THR A  97      28.988 101.306  -3.154  1.00  0.00           C  
ATOM   1469  O   THR A  97      29.581 100.857  -4.130  1.00  0.00           O  
ATOM   1470  CB  THR A  97      27.704  99.838  -1.545  1.00  0.00           C  
ATOM   1471  OG1 THR A  97      27.677  99.448  -0.185  1.00  0.00           O  
ATOM   1472  CG2 THR A  97      27.510  98.600  -2.425  1.00  0.00           C  
ATOM   1473  H   THR A  97      28.560 101.688  -0.134  1.00  0.00           H  
ATOM   1474  HA  THR A  97      29.830  99.796  -1.882  1.00  0.00           H  
ATOM   1475  HB  THR A  97      26.892 100.537  -1.737  1.00  0.00           H  
ATOM   1476  HG1 THR A  97      28.441  98.895  -0.007  1.00  0.00           H  
ATOM   1477 HG21 THR A  97      26.561  98.124  -2.174  1.00  0.00           H  
ATOM   1478 HG22 THR A  97      27.488  98.886  -3.477  1.00  0.00           H  
ATOM   1479 HG23 THR A  97      28.319  97.888  -2.264  1.00  0.00           H  
ATOM   1480  N   ILE A  98      28.304 102.456  -3.190  1.00  0.00           N  
ATOM   1481  CA  ILE A  98      28.209 103.263  -4.404  1.00  0.00           C  
ATOM   1482  C   ILE A  98      29.623 103.603  -4.894  1.00  0.00           C  
ATOM   1483  O   ILE A  98      29.946 103.351  -6.051  1.00  0.00           O  
ATOM   1484  CB  ILE A  98      27.366 104.536  -4.177  1.00  0.00           C  
ATOM   1485  CG1 ILE A  98      25.965 104.187  -3.672  1.00  0.00           C  
ATOM   1486  CG2 ILE A  98      27.259 105.304  -5.508  1.00  0.00           C  
ATOM   1487  CD1 ILE A  98      25.063 105.409  -3.459  1.00  0.00           C  
ATOM   1488  H   ILE A  98      27.872 102.790  -2.333  1.00  0.00           H  
ATOM   1489  HA  ILE A  98      27.721 102.662  -5.174  1.00  0.00           H  
ATOM   1490  HB  ILE A  98      27.831 105.144  -3.400  1.00  0.00           H  
ATOM   1491 HG12 ILE A  98      25.488 103.495  -4.366  1.00  0.00           H  
ATOM   1492 HG13 ILE A  98      26.082 103.708  -2.706  1.00  0.00           H  
ATOM   1493 HG21 ILE A  98      26.759 104.682  -6.251  1.00  0.00           H  
ATOM   1494 HG22 ILE A  98      28.243 105.576  -5.886  1.00  0.00           H  
ATOM   1495 HG23 ILE A  98      26.689 106.222  -5.385  1.00  0.00           H  
ATOM   1496 HD11 ILE A  98      25.602 106.180  -2.910  1.00  0.00           H  
ATOM   1497 HD12 ILE A  98      24.725 105.809  -4.415  1.00  0.00           H  
ATOM   1498 HD13 ILE A  98      24.186 105.118  -2.882  1.00  0.00           H  
ATOM   1499  N   VAL A  99      30.462 104.154  -4.013  1.00  0.00           N  
ATOM   1500  CA  VAL A  99      31.851 104.493  -4.293  1.00  0.00           C  
ATOM   1501  C   VAL A  99      32.542 103.301  -4.948  1.00  0.00           C  
ATOM   1502  O   VAL A  99      33.044 103.408  -6.067  1.00  0.00           O  
ATOM   1503  CB  VAL A  99      32.554 104.897  -2.979  1.00  0.00           C  
ATOM   1504  CG1 VAL A  99      34.080 104.715  -3.016  1.00  0.00           C  
ATOM   1505  CG2 VAL A  99      32.219 106.352  -2.634  1.00  0.00           C  
ATOM   1506  H   VAL A  99      30.120 104.312  -3.073  1.00  0.00           H  
ATOM   1507  HA  VAL A  99      31.884 105.327  -4.996  1.00  0.00           H  
ATOM   1508  HB  VAL A  99      32.187 104.274  -2.165  1.00  0.00           H  
ATOM   1509 HG11 VAL A  99      34.346 103.657  -3.034  1.00  0.00           H  
ATOM   1510 HG12 VAL A  99      34.527 105.145  -2.121  1.00  0.00           H  
ATOM   1511 HG13 VAL A  99      34.497 105.202  -3.896  1.00  0.00           H  
ATOM   1512 HG21 VAL A  99      32.614 107.022  -3.399  1.00  0.00           H  
ATOM   1513 HG22 VAL A  99      32.662 106.611  -1.672  1.00  0.00           H  
ATOM   1514 HG23 VAL A  99      31.139 106.478  -2.569  1.00  0.00           H  
ATOM   1515  N   GLN A 100      32.553 102.160  -4.258  1.00  0.00           N  
ATOM   1516  CA  GLN A 100      33.252 100.985  -4.748  1.00  0.00           C  
ATOM   1517  C   GLN A 100      32.716 100.576  -6.120  1.00  0.00           C  
ATOM   1518  O   GLN A 100      33.497 100.318  -7.039  1.00  0.00           O  
ATOM   1519  CB  GLN A 100      33.125  99.867  -3.707  1.00  0.00           C  
ATOM   1520  CG  GLN A 100      34.340  98.932  -3.709  1.00  0.00           C  
ATOM   1521  CD  GLN A 100      34.158  97.711  -4.605  1.00  0.00           C  
ATOM   1522  OE1 GLN A 100      33.964  96.603  -4.120  1.00  0.00           O  
ATOM   1523  NE2 GLN A 100      34.219  97.883  -5.921  1.00  0.00           N  
ATOM   1524  H   GLN A 100      32.108 102.129  -3.344  1.00  0.00           H  
ATOM   1525  HA  GLN A 100      34.299 101.263  -4.858  1.00  0.00           H  
ATOM   1526  HB2 GLN A 100      33.097 100.333  -2.723  1.00  0.00           H  
ATOM   1527  HB3 GLN A 100      32.198  99.305  -3.834  1.00  0.00           H  
ATOM   1528  HG2 GLN A 100      35.250  99.462  -3.988  1.00  0.00           H  
ATOM   1529  HG3 GLN A 100      34.469  98.597  -2.682  1.00  0.00           H  
ATOM   1530 HE21 GLN A 100      34.340  98.801  -6.338  1.00  0.00           H  
ATOM   1531 HE22 GLN A 100      34.113  97.073  -6.506  1.00  0.00           H  
ATOM   1532  N   THR A 101      31.391 100.519  -6.243  1.00  0.00           N  
ATOM   1533  CA  THR A 101      30.690 100.175  -7.473  1.00  0.00           C  
ATOM   1534  C   THR A 101      31.121 101.117  -8.607  1.00  0.00           C  
ATOM   1535  O   THR A 101      31.371 100.658  -9.717  1.00  0.00           O  
ATOM   1536  CB  THR A 101      29.173 100.195  -7.233  1.00  0.00           C  
ATOM   1537  OG1 THR A 101      28.850  99.280  -6.207  1.00  0.00           O  
ATOM   1538  CG2 THR A 101      28.405  99.760  -8.480  1.00  0.00           C  
ATOM   1539  H   THR A 101      30.847 100.734  -5.418  1.00  0.00           H  
ATOM   1540  HA  THR A 101      30.963  99.157  -7.750  1.00  0.00           H  
ATOM   1541  HB  THR A 101      28.850 101.196  -6.949  1.00  0.00           H  
ATOM   1542  HG1 THR A 101      29.176  99.633  -5.373  1.00  0.00           H  
ATOM   1543 HG21 THR A 101      28.776  98.797  -8.828  1.00  0.00           H  
ATOM   1544 HG22 THR A 101      28.525 100.507  -9.262  1.00  0.00           H  
ATOM   1545 HG23 THR A 101      27.346  99.664  -8.241  1.00  0.00           H  
ATOM   1546  N   VAL A 102      31.232 102.423  -8.353  1.00  0.00           N  
ATOM   1547  CA  VAL A 102      31.702 103.358  -9.366  1.00  0.00           C  
ATOM   1548  C   VAL A 102      33.150 103.019  -9.728  1.00  0.00           C  
ATOM   1549  O   VAL A 102      33.471 102.832 -10.902  1.00  0.00           O  
ATOM   1550  CB  VAL A 102      31.537 104.809  -8.870  1.00  0.00           C  
ATOM   1551  CG1 VAL A 102      32.303 105.816  -9.740  1.00  0.00           C  
ATOM   1552  CG2 VAL A 102      30.055 105.209  -8.883  1.00  0.00           C  
ATOM   1553  H   VAL A 102      31.020 102.776  -7.424  1.00  0.00           H  
ATOM   1554  HA  VAL A 102      31.112 103.232 -10.269  1.00  0.00           H  
ATOM   1555  HB  VAL A 102      31.916 104.891  -7.852  1.00  0.00           H  
ATOM   1556 HG11 VAL A 102      32.083 106.829  -9.403  1.00  0.00           H  
ATOM   1557 HG12 VAL A 102      33.378 105.660  -9.661  1.00  0.00           H  
ATOM   1558 HG13 VAL A 102      31.997 105.716 -10.782  1.00  0.00           H  
ATOM   1559 HG21 VAL A 102      29.679 105.213  -9.906  1.00  0.00           H  
ATOM   1560 HG22 VAL A 102      29.937 106.207  -8.461  1.00  0.00           H  
ATOM   1561 HG23 VAL A 102      29.461 104.510  -8.295  1.00  0.00           H  
ATOM   1562  N   GLU A 103      34.017 102.909  -8.722  1.00  0.00           N  
ATOM   1563  CA  GLU A 103      35.438 102.656  -8.907  1.00  0.00           C  
ATOM   1564  C   GLU A 103      35.712 101.439  -9.785  1.00  0.00           C  
ATOM   1565  O   GLU A 103      36.516 101.512 -10.708  1.00  0.00           O  
ATOM   1566  CB  GLU A 103      36.113 102.507  -7.544  1.00  0.00           C  
ATOM   1567  CG  GLU A 103      36.202 103.866  -6.844  1.00  0.00           C  
ATOM   1568  CD  GLU A 103      36.831 103.777  -5.460  1.00  0.00           C  
ATOM   1569  OE1 GLU A 103      36.570 102.770  -4.765  1.00  0.00           O  
ATOM   1570  OE2 GLU A 103      37.540 104.746  -5.107  1.00  0.00           O  
ATOM   1571  H   GLU A 103      33.675 103.045  -7.779  1.00  0.00           H  
ATOM   1572  HA  GLU A 103      35.862 103.508  -9.426  1.00  0.00           H  
ATOM   1573  HB2 GLU A 103      35.577 101.784  -6.930  1.00  0.00           H  
ATOM   1574  HB3 GLU A 103      37.128 102.148  -7.701  1.00  0.00           H  
ATOM   1575  HG2 GLU A 103      36.818 104.519  -7.462  1.00  0.00           H  
ATOM   1576  HG3 GLU A 103      35.216 104.314  -6.752  1.00  0.00           H  
ATOM   1577  N   LYS A 104      35.041 100.316  -9.526  1.00  0.00           N  
ATOM   1578  CA  LYS A 104      35.271  99.119 -10.334  1.00  0.00           C  
ATOM   1579  C   LYS A 104      34.933  99.353 -11.818  1.00  0.00           C  
ATOM   1580  O   LYS A 104      35.435  98.622 -12.669  1.00  0.00           O  
ATOM   1581  CB  LYS A 104      34.500  97.913  -9.776  1.00  0.00           C  
ATOM   1582  CG  LYS A 104      32.999  98.179  -9.668  1.00  0.00           C  
ATOM   1583  CD  LYS A 104      32.143  96.912  -9.648  1.00  0.00           C  
ATOM   1584  CE  LYS A 104      32.405  96.051  -8.409  1.00  0.00           C  
ATOM   1585  NZ  LYS A 104      31.545  94.856  -8.396  1.00  0.00           N  
ATOM   1586  H   LYS A 104      34.400 100.318  -8.739  1.00  0.00           H  
ATOM   1587  HA  LYS A 104      36.333  98.873 -10.290  1.00  0.00           H  
ATOM   1588  HB2 LYS A 104      34.659  97.067 -10.445  1.00  0.00           H  
ATOM   1589  HB3 LYS A 104      34.895  97.656  -8.794  1.00  0.00           H  
ATOM   1590  HG2 LYS A 104      32.824  98.756  -8.769  1.00  0.00           H  
ATOM   1591  HG3 LYS A 104      32.672  98.762 -10.525  1.00  0.00           H  
ATOM   1592  HD2 LYS A 104      31.098  97.228  -9.654  1.00  0.00           H  
ATOM   1593  HD3 LYS A 104      32.341  96.346 -10.560  1.00  0.00           H  
ATOM   1594  HE2 LYS A 104      33.446  95.726  -8.395  1.00  0.00           H  
ATOM   1595  HE3 LYS A 104      32.195  96.635  -7.512  1.00  0.00           H  
ATOM   1596  HZ1 LYS A 104      31.728  94.294  -9.216  1.00  0.00           H  
ATOM   1597  HZ2 LYS A 104      31.736  94.310  -7.568  1.00  0.00           H  
ATOM   1598  HZ3 LYS A 104      30.574  95.135  -8.391  1.00  0.00           H  
ATOM   1599  N   TYR A 105      34.069 100.326 -12.138  1.00  0.00           N  
ATOM   1600  CA  TYR A 105      33.703 100.636 -13.514  1.00  0.00           C  
ATOM   1601  C   TYR A 105      34.662 101.692 -14.078  1.00  0.00           C  
ATOM   1602  O   TYR A 105      35.105 101.565 -15.217  1.00  0.00           O  
ATOM   1603  CB  TYR A 105      32.241 101.106 -13.579  1.00  0.00           C  
ATOM   1604  CG  TYR A 105      31.190 100.207 -12.947  1.00  0.00           C  
ATOM   1605  CD1 TYR A 105      31.355  98.809 -12.880  1.00  0.00           C  
ATOM   1606  CD2 TYR A 105      30.003 100.789 -12.462  1.00  0.00           C  
ATOM   1607  CE1 TYR A 105      30.362  98.008 -12.286  1.00  0.00           C  
ATOM   1608  CE2 TYR A 105      28.996  99.984 -11.904  1.00  0.00           C  
ATOM   1609  CZ  TYR A 105      29.190  98.600 -11.784  1.00  0.00           C  
ATOM   1610  OH  TYR A 105      28.185  97.821 -11.294  1.00  0.00           O  
ATOM   1611  H   TYR A 105      33.706 100.935 -11.412  1.00  0.00           H  
ATOM   1612  HA  TYR A 105      33.796  99.749 -14.143  1.00  0.00           H  
ATOM   1613  HB2 TYR A 105      32.168 102.065 -13.075  1.00  0.00           H  
ATOM   1614  HB3 TYR A 105      31.974 101.254 -14.627  1.00  0.00           H  
ATOM   1615  HD1 TYR A 105      32.239  98.336 -13.277  1.00  0.00           H  
ATOM   1616  HD2 TYR A 105      29.861 101.858 -12.517  1.00  0.00           H  
ATOM   1617  HE1 TYR A 105      30.494  96.937 -12.253  1.00  0.00           H  
ATOM   1618  HE2 TYR A 105      28.067 100.429 -11.580  1.00  0.00           H  
ATOM   1619  HH  TYR A 105      28.357  96.882 -11.379  1.00  0.00           H  
ATOM   1620  N   LEU A 106      34.957 102.743 -13.302  1.00  0.00           N  
ATOM   1621  CA  LEU A 106      35.901 103.790 -13.680  1.00  0.00           C  
ATOM   1622  C   LEU A 106      37.281 103.394 -13.141  1.00  0.00           C  
ATOM   1623  O   LEU A 106      38.005 102.639 -13.786  1.00  0.00           O  
ATOM   1624  CB  LEU A 106      35.443 105.163 -13.146  1.00  0.00           C  
ATOM   1625  CG  LEU A 106      34.378 105.866 -14.005  1.00  0.00           C  
ATOM   1626  CD1 LEU A 106      33.026 105.145 -13.975  1.00  0.00           C  
ATOM   1627  CD2 LEU A 106      34.216 107.310 -13.507  1.00  0.00           C  
ATOM   1628  H   LEU A 106      34.560 102.775 -12.369  1.00  0.00           H  
ATOM   1629  HA  LEU A 106      35.987 103.863 -14.763  1.00  0.00           H  
ATOM   1630  HB2 LEU A 106      35.087 105.069 -12.119  1.00  0.00           H  
ATOM   1631  HB3 LEU A 106      36.311 105.824 -13.148  1.00  0.00           H  
ATOM   1632  HG  LEU A 106      34.724 105.902 -15.038  1.00  0.00           H  
ATOM   1633 HD11 LEU A 106      32.711 104.978 -12.945  1.00  0.00           H  
ATOM   1634 HD12 LEU A 106      32.275 105.747 -14.487  1.00  0.00           H  
ATOM   1635 HD13 LEU A 106      33.100 104.188 -14.489  1.00  0.00           H  
ATOM   1636 HD21 LEU A 106      33.485 107.838 -14.119  1.00  0.00           H  
ATOM   1637 HD22 LEU A 106      35.164 107.845 -13.578  1.00  0.00           H  
ATOM   1638 HD23 LEU A 106      33.892 107.317 -12.467  1.00  0.00           H  
ATOM   1639  N   ASN A 107      37.652 103.930 -11.980  1.00  0.00           N  
ATOM   1640  CA  ASN A 107      38.878 103.683 -11.245  1.00  0.00           C  
ATOM   1641  C   ASN A 107      38.608 104.286  -9.868  1.00  0.00           C  
ATOM   1642  O   ASN A 107      39.282 103.873  -8.900  1.00  0.00           O  
ATOM   1643  CB  ASN A 107      40.077 104.359 -11.926  1.00  0.00           C  
ATOM   1644  CG  ASN A 107      41.438 103.858 -11.436  1.00  0.00           C  
ATOM   1645  OD1 ASN A 107      42.360 103.704 -12.232  1.00  0.00           O  
ATOM   1646  ND2 ASN A 107      41.616 103.603 -10.144  1.00  0.00           N  
ATOM   1647  OXT ASN A 107      37.715 105.164  -9.820  1.00  0.00           O  
ATOM   1648  H   ASN A 107      37.036 104.545 -11.457  1.00  0.00           H  
ATOM   1649  HA  ASN A 107      39.042 102.606 -11.169  1.00  0.00           H  
ATOM   1650  HB2 ASN A 107      40.034 104.168 -12.998  1.00  0.00           H  
ATOM   1651  HB3 ASN A 107      40.019 105.438 -11.771  1.00  0.00           H  
ATOM   1652 HD21 ASN A 107      40.827 103.707  -9.494  1.00  0.00           H  
ATOM   1653 HD22 ASN A 107      42.509 103.273  -9.822  1.00  0.00           H  
TER    1654      ASN A 107                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
