
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  109 (  833),  selected  109 , name 1tho_A
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 1tho_A.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_A      -       -           -
LGA    D     2_A      -       -           -
LGA    K     3_A      -       -           -
LGA    I     4_A      -       -           -
LGA    I     5_A      -       -           -
LGA    H     6_A      -       -           -
LGA    L     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    D     9_A      -       -           -
LGA    D    10_A      -       -           -
LGA    S    11_A      -       -           -
LGA    F    12_A      -       -           -
LGA    D    13_A      -       -           -
LGA    T    14_A      -       -           -
LGA    D    15_A      -       -           -
LGA    V    16_A      -       -           -
LGA    L    17_A      -       -           -
LGA    K    18_A      -       -           -
LGA    A    19_A      -       -           -
LGA    D    20_A      -       -           -
LGA    G    21_A      T      12          2.501
LGA    A    22_A      H      13          1.481
LGA    I    23_A      R      14          1.026
LGA    L    24_A      V      15          0.983
LGA    V    25_A      Q      16          0.758
LGA    D    26_A      I      17          1.082
LGA    F    27_A      E      18          1.298
LGA    W    28_A      Y      19          2.362
LGA    A    29_A      C      20          4.065
LGA    E    30_A      T      21          2.721
LGA    W    31_A      Q      22          0.655
LGA    C    32_A      C      23          2.040
LGA    G    33_A      R      24          3.125
LGA    R   33A_A      -       -           -
LGA    P    34_A      W      25          5.133
LGA    C    35_A      L      26          4.819
LGA    K    36_A      P      27          3.278
LGA    M    37_A      R      28          2.897
LGA    I    38_A      A      29          3.850
LGA    A    39_A      A      30          2.251
LGA    P    40_A      W      31          1.352
LGA    I    41_A      L      32          2.689
LGA    L    42_A      A      33          1.577
LGA    D    43_A      Q      34          0.958
LGA    E    44_A      E      35          2.480
LGA    I    45_A      L      36          1.544
LGA    A    46_A      L      37          0.884
LGA    D    47_A      T      38          2.280
LGA    E    48_A      T      39          2.360
LGA    Y    49_A      F      40          1.036
LGA    Q    50_A      E      41          1.210
LGA    G    51_A      T      42          2.481
LGA    K    52_A      E      43          0.248
LGA    L    53_A      L      44          1.316
LGA    -       -      T      45           -
LGA    T    54_A      E      46          2.206
LGA    V    55_A      L      47          1.165
LGA    A    56_A      A      48          0.813
LGA    K    57_A      L      49          0.859
LGA    L    58_A      K      50          1.567
LGA    N    59_A      P      51          1.845
LGA    I    60_A      G      52          3.633
LGA    D    61_A      T      53           #
LGA    Q    62_A      -       -           -
LGA    N    63_A      -       -           -
LGA    P    64_A      -       -           -
LGA    G    65_A      -       -           -
LGA    T    66_A      -       -           -
LGA    A    67_A      -       -           -
LGA    P    68_A      -       -           -
LGA    K    69_A      -       -           -
LGA    Y    70_A      -       -           -
LGA    G    71_A      -       -           -
LGA    I    72_A      -       -           -
LGA    R    73_A      -       -           -
LGA    G    74_A      G      54          5.466
LGA    -       -      G      55           -
LGA    I    75_A      V      56          1.439
LGA    P    76_A      F      57          1.265
LGA    T    77_A      V      58          1.345
LGA    L    78_A      V      59          1.375
LGA    L    79_A      R      60          1.345
LGA    L    80_A      V      61          1.131
LGA    F    81_A      D      62          0.771
LGA    K    82_A      -       -           -
LGA    N    83_A      -       -           -
LGA    G    84_A      -       -           -
LGA    E    85_A      -       -           -
LGA    V    86_A      D      63          2.646
LGA    A    87_A      E      64          3.184
LGA    A    88_A      V      65          3.246
LGA    T    89_A      V      66          3.043
LGA    K    90_A      W      67          1.038
LGA    V    91_A      D      68          1.224
LGA    G    92_A      R      69          2.012
LGA    -       -      R      70           -
LGA    -       -      E      71           -
LGA    -       -      Q      72           -
LGA    -       -      G      73           -
LGA    A    93_A      F      74          2.984
LGA    L    94_A      P      75          0.808
LGA    S    95_A      E      76          1.190
LGA    K    96_A      P      77          0.872
LGA    G    97_A      T      78          0.485
LGA    Q    98_A      A      79          0.957
LGA    L    99_A      V      80          1.394
LGA    K   100_A      K      81          0.800
LGA    E   101_A      R      82          1.153
LGA    F   102_A      L      83          1.145
LGA    L   103_A      V      84          0.593
LGA    D   104_A      R      85          1.244
LGA    A   105_A      D      86          1.511
LGA    N   106_A      R      87          1.362
LGA    L   107_A      V      88          1.094
LGA    A   108_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  109   77    5.0     70    2.16    10.00     71.979     3.100

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.589700 * X  +  -0.081585 * Y  +   0.803491 * Z  +  39.296303
  Y_new =  -0.349146 * X  +   0.871358 * Y  +   0.344722 * Z  + 102.026955
  Z_new =  -0.728252 * X  +  -0.483818 * Y  +   0.485355 * Z  +  49.590775 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.783812    2.357780  [ DEG:   -44.9091    135.0909 ]
  Theta =   0.815768    2.325825  [ DEG:    46.7401    133.2599 ]
  Phi   =  -0.534571    2.607022  [ DEG:   -30.6286    149.3714 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1tho_A                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1tho_A.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  109   77   5.0   70   2.16   10.00  71.979
REMARK  ---------------------------------------------------------- 
MOLECULE 1tho_A
HEADER    ELECTRON TRANSPORT                      28-JAN-93   1THO              
TITLE     CRYSTAL STRUCTURE OF A MUTANT ESCHERICHIA COLI THIOREDOXIN            
TITLE    2 WITH AN ARGININE INSERTION IN THE ACTIVE SITE                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOREDOXIN;                                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ELECTRON TRANSPORT                                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.NIKKOLA,K.LANGSETMO,J.A.FUCHS,H.EKLUND                              
REVDAT   1   31-OCT-93 1THO    0                                                
JRNL        AUTH   M.NIKKOLA,K.LANGSETMO,J.A.FUCHS,H.EKLUND                     
JRNL        TITL   CRYSTAL STRUCTURE OF A MUTANT ESCHERICHIA COLI               
JRNL        TITL 2 THIOREDOXIN WITH AN ARGININE INSERTION IN THE                
JRNL        TITL 3 ACTIVE SITE                                                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  1THO A    1   108  UNP    P0AA25   THIO_ECOLI       1    108             
SEQRES   1 A  109  SER ASP LYS ILE ILE HIS LEU THR ASP ASP SER PHE ASP          
SEQRES   2 A  109  THR ASP VAL LEU LYS ALA ASP GLY ALA ILE LEU VAL ASP          
SEQRES   3 A  109  PHE TRP ALA GLU TRP CYS GLY ARG PRO CYS LYS MET ILE          
SEQRES   4 A  109  ALA PRO ILE LEU ASP GLU ILE ALA ASP GLU TYR GLN GLY          
SEQRES   5 A  109  LYS LEU THR VAL ALA LYS LEU ASN ILE ASP GLN ASN PRO          
SEQRES   6 A  109  GLY THR ALA PRO LYS TYR GLY ILE ARG GLY ILE PRO THR          
SEQRES   7 A  109  LEU LEU LEU PHE LYS ASN GLY GLU VAL ALA ALA THR LYS          
SEQRES   8 A  109  VAL GLY ALA LEU SER LYS GLY GLN LEU LYS GLU PHE LEU          
SEQRES   9 A  109  ASP ALA ASN LEU ALA                                          
HET     CU    109       1                                                       
HETNAM      CU COPPER (II) ION                                                  
FORMUL   2   CU    CU 2+                                                        
FORMUL   3  HOH   *26(H2 O)                                                     
CRYST1   78.400   78.400   35.100  90.00  90.00 120.00 P 61          6          
ATOM      1  N   SER A   1      24.238 120.769  -5.295  1.00 84.87           N  
ATOM      2  CA  SER A   1      23.944 120.493  -6.638  1.00 83.39           C  
ATOM      3  C   SER A   1      24.708 121.268  -7.668  1.00 81.57           C  
ATOM      4  O   SER A   1      24.287 121.279  -8.820  1.00 83.70           O  
ATOM      5  CB  SER A   1      22.461 120.675  -6.768  1.00 85.02           C  
ATOM      6  OG  SER A   1      22.017 119.575  -5.995  1.00 85.92           O  
ATOM      7  N   ASP A   2      25.856 121.881  -7.368  1.00 78.44           N  
ATOM      8  CA  ASP A   2      26.486 122.707  -8.394  1.00 75.44           C  
ATOM      9  C   ASP A   2      27.116 122.065  -9.630  1.00 69.49           C  
ATOM     10  O   ASP A   2      27.222 122.678 -10.710  1.00 69.15           O  
ATOM     11  CB  ASP A   2      27.498 123.600  -7.669  1.00 79.67           C  
ATOM     12  CG  ASP A   2      28.607 122.903  -6.893  1.00 80.38           C  
ATOM     13  OD1 ASP A   2      28.351 122.026  -6.045  1.00 78.50           O  
ATOM     14  OD2 ASP A   2      29.745 123.312  -7.137  1.00 80.79           O  
ATOM     15  N   LYS A   3      27.563 120.811  -9.439  1.00 59.54           N  
ATOM     16  CA  LYS A   3      28.245 120.111 -10.524  1.00 48.42           C  
ATOM     17  C   LYS A   3      27.395 119.202 -11.366  1.00 38.58           C  
ATOM     18  O   LYS A   3      27.807 118.773 -12.416  1.00 37.26           O  
ATOM     19  CB  LYS A   3      29.416 119.326  -9.924  1.00 52.33           C  
ATOM     20  CG  LYS A   3      30.550 120.332  -9.648  1.00 58.64           C  
ATOM     21  CD  LYS A   3      31.721 119.865  -8.739  1.00 61.86           C  
ATOM     22  CE  LYS A   3      32.549 121.015  -8.091  1.00 64.81           C  
ATOM     23  NZ  LYS A   3      32.022 121.543  -6.823  1.00 69.19           N  
ATOM     24  N   ILE A   4      26.118 119.087 -11.010  1.00 29.60           N  
ATOM     25  CA  ILE A   4      25.200 118.060 -11.507  1.00 25.18           C  
ATOM     26  C   ILE A   4      24.440 118.612 -12.714  1.00 26.65           C  
ATOM     27  O   ILE A   4      23.723 119.600 -12.574  1.00 33.21           O  
ATOM     28  CB  ILE A   4      24.288 117.646 -10.285  1.00 22.19           C  
ATOM     29  CG1 ILE A   4      25.185 117.043  -9.227  1.00 18.02           C  
ATOM     30  CG2 ILE A   4      23.243 116.623 -10.671  1.00 21.87           C  
ATOM     31  CD1 ILE A   4      24.536 116.187  -8.116  1.00 15.45           C  
ATOM     32  N   ILE A   5      24.643 118.026 -13.898  1.00 24.14           N  
ATOM     33  CA  ILE A   5      23.976 118.437 -15.124  1.00 22.32           C  
ATOM     34  C   ILE A   5      22.494 118.130 -14.903  1.00 21.60           C  
ATOM     35  O   ILE A   5      22.125 117.019 -14.556  1.00 18.86           O  
ATOM     36  CB  ILE A   5      24.400 117.637 -16.434  1.00 25.67           C  
ATOM     37  CG1 ILE A   5      25.902 117.474 -16.687  1.00 26.16           C  
ATOM     38  CG2 ILE A   5      23.928 118.481 -17.594  1.00 26.24           C  
ATOM     39  CD1 ILE A   5      26.653 118.781 -16.298  1.00 30.52           C  
ATOM     40  N   HIS A   6      21.594 119.078 -15.099  1.00 23.46           N  
ATOM     41  CA  HIS A   6      20.169 118.850 -15.086  1.00 24.31           C  
ATOM     42  C   HIS A   6      19.818 118.473 -16.517  1.00 24.27           C  
ATOM     43  O   HIS A   6      20.054 119.299 -17.397  1.00 21.91           O  
ATOM     44  CB  HIS A   6      19.491 120.146 -14.660  1.00 31.23           C  
ATOM     45  CG  HIS A   6      17.980 120.240 -14.892  1.00 37.71           C  
ATOM     46  ND1 HIS A   6      16.966 119.913 -14.078  1.00 39.99           N  
ATOM     47  CD2 HIS A   6      17.437 120.708 -16.077  1.00 38.65           C  
ATOM     48  CE1 HIS A   6      15.855 120.160 -14.737  1.00 42.69           C  
ATOM     49  NE2 HIS A   6      16.151 120.645 -15.923  1.00 41.48           N  
ATOM     50  N   LEU A   7      19.292 117.279 -16.783  1.00 22.73           N  
ATOM     51  CA  LEU A   7      18.957 116.862 -18.135  1.00 19.06           C  
ATOM     52  C   LEU A   7      17.507 117.043 -18.465  1.00 20.36           C  
ATOM     53  O   LEU A   7      16.626 117.084 -17.600  1.00 21.03           O  
ATOM     54  CB  LEU A   7      19.231 115.393 -18.379  1.00 15.45           C  
ATOM     55  CG  LEU A   7      20.637 114.910 -18.073  1.00 13.40           C  
ATOM     56  CD1 LEU A   7      20.610 113.404 -18.151  1.00 11.84           C  
ATOM     57  CD2 LEU A   7      21.668 115.524 -19.006  1.00 10.52           C  
ATOM     58  N   THR A   8      17.288 117.094 -19.768  1.00 22.58           N  
ATOM     59  CA  THR A   8      15.963 117.010 -20.330  1.00 23.54           C  
ATOM     60  C   THR A   8      16.052 115.962 -21.427  1.00 26.94           C  
ATOM     61  O   THR A   8      17.158 115.615 -21.873  1.00 26.89           O  
ATOM     62  CB  THR A   8      15.501 118.334 -20.961  1.00 21.86           C  
ATOM     63  OG1 THR A   8      16.505 118.685 -21.911  1.00 21.78           O  
ATOM     64  CG2 THR A   8      15.218 119.410 -19.925  1.00 16.31           C  
ATOM     65  N   ASP A   9      14.896 115.567 -21.980  1.00 31.26           N  
ATOM     66  CA  ASP A   9      14.855 114.677 -23.153  1.00 34.79           C  
ATOM     67  C   ASP A   9      15.564 115.341 -24.341  1.00 35.01           C  
ATOM     68  O   ASP A   9      16.423 114.733 -24.980  1.00 40.27           O  
ATOM     69  CB  ASP A   9      13.406 114.351 -23.539  1.00 32.97           C  
ATOM     70  CG  ASP A   9      12.653 113.423 -22.600  1.00 34.41           C  
ATOM     71  OD1 ASP A   9      13.231 112.719 -21.773  1.00 35.61           O  
ATOM     72  OD2 ASP A   9      11.435 113.406 -22.700  1.00 38.26           O  
ATOM     73  N   ASP A  10      15.329 116.631 -24.565  1.00 33.17           N  
ATOM     74  CA  ASP A  10      15.990 117.381 -25.605  1.00 34.55           C  
ATOM     75  C   ASP A  10      17.500 117.388 -25.445  1.00 32.20           C  
ATOM     76  O   ASP A  10      18.198 117.343 -26.451  1.00 35.27           O  
ATOM     77  CB  ASP A  10      15.486 118.810 -25.576  1.00 45.84           C  
ATOM     78  CG  ASP A  10      14.783 119.343 -26.831  1.00 54.59           C  
ATOM     79  OD1 ASP A  10      15.152 118.968 -27.963  1.00 55.89           O  
ATOM     80  OD2 ASP A  10      13.876 120.180 -26.647  1.00 58.60           O  
ATOM     81  N   SER A  11      18.073 117.418 -24.234  1.00 28.03           N  
ATOM     82  CA  SER A  11      19.513 117.551 -24.108  1.00 23.39           C  
ATOM     83  C   SER A  11      20.257 116.238 -23.912  1.00 23.63           C  
ATOM     84  O   SER A  11      21.468 116.189 -24.142  1.00 21.05           O  
ATOM     85  CB  SER A  11      19.810 118.499 -22.962  1.00 24.73           C  
ATOM     86  OG  SER A  11      19.579 117.934 -21.685  1.00 25.77           O  
ATOM     87  N   PHE A  12      19.550 115.176 -23.524  1.00 19.31           N  
ATOM     88  CA  PHE A  12      20.135 113.894 -23.256  1.00 20.21           C  
ATOM     89  C   PHE A  12      21.005 113.424 -24.421  1.00 20.63           C  
ATOM     90  O   PHE A  12      22.163 113.071 -24.174  1.00 21.14           O  
ATOM     91  CB  PHE A  12      18.967 112.897 -22.928  1.00 17.64           C  
ATOM     92  CG  PHE A  12      19.388 111.560 -22.320  1.00 14.64           C  
ATOM     93  CD1 PHE A  12      19.852 110.525 -23.115  1.00 13.50           C  
ATOM     94  CD2 PHE A  12      19.334 111.404 -20.962  1.00 13.70           C  
ATOM     95  CE1 PHE A  12      20.271 109.354 -22.548  1.00 11.73           C  
ATOM     96  CE2 PHE A  12      19.747 110.221 -20.405  1.00 12.11           C  
ATOM     97  CZ  PHE A  12      20.220 109.201 -21.189  1.00 12.25           C  
ATOM     98  N   ASP A  13      20.615 113.470 -25.689  1.00 26.43           N  
ATOM     99  CA  ASP A  13      21.484 112.926 -26.733  1.00 32.33           C  
ATOM    100  C   ASP A  13      22.830 113.652 -26.806  1.00 30.53           C  
ATOM    101  O   ASP A  13      23.896 113.052 -26.896  1.00 34.03           O  
ATOM    102  CB  ASP A  13      20.715 112.968 -28.084  1.00 39.71           C  
ATOM    103  CG  ASP A  13      21.526 112.483 -29.302  1.00 48.58           C  
ATOM    104  OD1 ASP A  13      21.529 111.292 -29.636  1.00 51.84           O  
ATOM    105  OD2 ASP A  13      22.193 113.312 -29.927  1.00 53.06           O  
ATOM    106  N   THR A  14      22.815 114.934 -26.558  1.00 31.70           N  
ATOM    107  CA  THR A  14      24.002 115.761 -26.607  1.00 34.27           C  
ATOM    108  C   THR A  14      24.901 115.659 -25.361  1.00 33.98           C  
ATOM    109  O   THR A  14      26.118 115.454 -25.391  1.00 35.49           O  
ATOM    110  CB  THR A  14      23.511 117.196 -26.811  1.00 38.02           C  
ATOM    111  OG1 THR A  14      22.251 117.201 -27.512  1.00 39.77           O  
ATOM    112  CG2 THR A  14      24.599 117.955 -27.550  1.00 40.67           C  
ATOM    113  N   ASP A  15      24.234 115.805 -24.218  1.00 29.83           N  
ATOM    114  CA  ASP A  15      24.906 115.819 -22.958  1.00 26.04           C  
ATOM    115  C   ASP A  15      25.372 114.451 -22.528  1.00 24.74           C  
ATOM    116  O   ASP A  15      26.356 114.333 -21.786  1.00 25.25           O  
ATOM    117  CB  ASP A  15      23.987 116.369 -21.893  1.00 29.47           C  
ATOM    118  CG  ASP A  15      23.628 117.840 -22.000  1.00 33.79           C  
ATOM    119  OD1 ASP A  15      24.376 118.570 -22.653  1.00 37.22           O  
ATOM    120  OD2 ASP A  15      22.616 118.258 -21.414  1.00 37.17           O  
ATOM    121  N   VAL A  16      24.657 113.397 -22.929  1.00 19.27           N  
ATOM    122  CA  VAL A  16      24.996 112.074 -22.439  1.00 15.49           C  
ATOM    123  C   VAL A  16      25.569 111.232 -23.530  1.00 14.00           C  
ATOM    124  O   VAL A  16      26.705 110.779 -23.421  1.00 14.49           O  
ATOM    125  CB  VAL A  16      23.738 111.362 -21.830  1.00 13.25           C  
ATOM    126  CG1 VAL A  16      24.090 109.990 -21.329  1.00 10.50           C  
ATOM    127  CG2 VAL A  16      23.216 112.147 -20.661  1.00  8.06           C  
ATOM    128  N   LEU A  17      24.790 111.034 -24.584  1.00 16.11           N  
ATOM    129  CA  LEU A  17      25.217 110.111 -25.609  1.00 16.42           C  
ATOM    130  C   LEU A  17      26.336 110.542 -26.509  1.00 21.50           C  
ATOM    131  O   LEU A  17      27.034 109.678 -27.080  1.00 23.46           O  
ATOM    132  CB  LEU A  17      24.066 109.736 -26.482  1.00 16.20           C  
ATOM    133  CG  LEU A  17      22.905 109.066 -25.816  1.00 17.51           C  
ATOM    134  CD1 LEU A  17      21.986 108.650 -26.925  1.00 18.94           C  
ATOM    135  CD2 LEU A  17      23.295 107.842 -25.004  1.00 16.85           C  
ATOM    136  N   LYS A  18      26.537 111.856 -26.632  1.00 24.96           N  
ATOM    137  CA  LYS A  18      27.645 112.368 -27.420  1.00 30.30           C  
ATOM    138  C   LYS A  18      28.873 112.847 -26.646  1.00 30.75           C  
ATOM    139  O   LYS A  18      29.835 113.349 -27.232  1.00 32.98           O  
ATOM    140  CB  LYS A  18      27.097 113.478 -28.283  1.00 34.00           C  
ATOM    141  CG  LYS A  18      27.002 112.921 -29.682  1.00 40.25           C  
ATOM    142  CD  LYS A  18      25.568 112.834 -30.161  1.00 43.43           C  
ATOM    143  CE  LYS A  18      25.464 112.180 -31.556  1.00 45.03           C  
ATOM    144  NZ  LYS A  18      26.147 112.902 -32.628  1.00 46.43           N  
ATOM    145  N   ALA A  19      28.893 112.632 -25.332  1.00 31.05           N  
ATOM    146  CA  ALA A  19      29.937 113.095 -24.440  1.00 31.38           C  
ATOM    147  C   ALA A  19      31.189 112.248 -24.340  1.00 33.47           C  
ATOM    148  O   ALA A  19      31.151 111.034 -24.541  1.00 29.76           O  
ATOM    149  CB  ALA A  19      29.338 113.234 -23.053  1.00 31.53           C  
ATOM    150  N   ASP A  20      32.347 112.849 -24.084  1.00 39.31           N  
ATOM    151  CA  ASP A  20      33.517 112.007 -23.927  1.00 44.77           C  
ATOM    152  C   ASP A  20      33.461 111.441 -22.533  1.00 40.51           C  
ATOM    153  O   ASP A  20      33.110 112.176 -21.596  1.00 43.84           O  
ATOM    154  CB  ASP A  20      34.834 112.797 -24.091  1.00 55.74           C  
ATOM    155  CG  ASP A  20      35.067 114.008 -23.174  1.00 65.04           C  
ATOM    156  OD1 ASP A  20      35.425 113.814 -22.000  1.00 70.31           O  
ATOM    157  OD2 ASP A  20      34.903 115.145 -23.648  1.00 69.09           O  
ATOM    158  N   GLY A  21      33.822 110.190 -22.347  1.00 33.78           N  
ATOM    159  CA  GLY A  21      33.856 109.679 -20.994  1.00 30.52           C  
ATOM    160  C   GLY A  21      32.519 109.197 -20.423  1.00 25.49           C  
ATOM    161  O   GLY A  21      31.578 108.789 -21.116  1.00 26.97           O  
ATOM    162  N   ALA A  22      32.560 109.171 -19.091  1.00 20.86           N  
ATOM    163  CA  ALA A  22      31.533 108.592 -18.264  1.00 13.31           C  
ATOM    164  C   ALA A  22      30.564 109.564 -17.684  1.00 15.39           C  
ATOM    165  O   ALA A  22      30.897 110.696 -17.318  1.00 13.71           O  
ATOM    166  CB  ALA A  22      32.173 107.870 -17.141  1.00  4.00           C  
ATOM    167  N   ILE A  23      29.324 109.138 -17.595  1.00 16.18           N  
ATOM    168  CA  ILE A  23      28.380 109.962 -16.902  1.00 13.42           C  
ATOM    169  C   ILE A  23      27.377 109.050 -16.234  1.00 11.61           C  
ATOM    170  O   ILE A  23      27.014 107.976 -16.707  1.00  9.01           O  
ATOM    171  CB  ILE A  23      27.763 111.061 -17.914  1.00 19.06           C  
ATOM    172  CG1 ILE A  23      26.382 111.479 -17.427  1.00 16.84           C  
ATOM    173  CG2 ILE A  23      27.739 110.600 -19.353  1.00 22.25           C  
ATOM    174  CD1 ILE A  23      26.074 112.871 -17.974  1.00 23.55           C  
ATOM    175  N   LEU A  24      27.124 109.395 -14.980  1.00  7.03           N  
ATOM    176  CA  LEU A  24      26.154 108.708 -14.161  1.00  9.04           C  
ATOM    177  C   LEU A  24      24.838 109.479 -14.236  1.00  7.97           C  
ATOM    178  O   LEU A  24      24.819 110.656 -13.889  1.00  9.81           O  
ATOM    179  CB  LEU A  24      26.650 108.644 -12.704  1.00  6.24           C  
ATOM    180  CG  LEU A  24      25.850 107.958 -11.594  1.00  4.72           C  
ATOM    181  CD1 LEU A  24      25.810 106.469 -11.788  1.00  2.04           C  
ATOM    182  CD2 LEU A  24      26.492 108.335 -10.284  1.00  3.06           C  
ATOM    183  N   VAL A  25      23.711 108.880 -14.618  1.00  9.18           N  
ATOM    184  CA  VAL A  25      22.447 109.597 -14.674  1.00  7.39           C  
ATOM    185  C   VAL A  25      21.518 109.045 -13.621  1.00  8.32           C  
ATOM    186  O   VAL A  25      21.240 107.843 -13.556  1.00  8.13           O  
ATOM    187  CB  VAL A  25      21.765 109.429 -16.020  1.00  8.13           C  
ATOM    188  CG1 VAL A  25      20.488 110.245 -16.061  1.00  7.57           C  
ATOM    189  CG2 VAL A  25      22.720 109.851 -17.110  1.00  7.65           C  
ATOM    190  N   ASP A  26      21.015 109.940 -12.801  1.00  8.54           N  
ATOM    191  CA  ASP A  26      20.025 109.627 -11.804  1.00 10.30           C  
ATOM    192  C   ASP A  26      18.625 109.937 -12.336  1.00  9.94           C  
ATOM    193  O   ASP A  26      18.238 111.094 -12.607  1.00 11.19           O  
ATOM    194  CB  ASP A  26      20.377 110.446 -10.554  1.00  9.44           C  
ATOM    195  CG  ASP A  26      19.346 110.506  -9.434  1.00 15.05           C  
ATOM    196  OD1 ASP A  26      18.505 109.620  -9.320  1.00 16.31           O  
ATOM    197  OD2 ASP A  26      19.369 111.449  -8.648  1.00 17.63           O  
ATOM    198  N   PHE A  27      17.840 108.880 -12.484  1.00 10.10           N  
ATOM    199  CA  PHE A  27      16.452 109.045 -12.893  1.00  9.93           C  
ATOM    200  C   PHE A  27      15.630 109.232 -11.642  1.00  9.70           C  
ATOM    201  O   PHE A  27      15.719 108.383 -10.750  1.00 10.59           O  
ATOM    202  CB  PHE A  27      15.950 107.824 -13.617  1.00  6.49           C  
ATOM    203  CG  PHE A  27      16.598 107.737 -14.973  1.00  8.68           C  
ATOM    204  CD1 PHE A  27      17.849 107.160 -15.105  1.00  9.85           C  
ATOM    205  CD2 PHE A  27      15.961 108.286 -16.065  1.00  8.56           C  
ATOM    206  CE1 PHE A  27      18.422 107.158 -16.355  1.00 11.60           C  
ATOM    207  CE2 PHE A  27      16.549 108.270 -17.311  1.00  4.62           C  
ATOM    208  CZ  PHE A  27      17.784 107.703 -17.452  1.00  8.43           C  
ATOM    209  N   TRP A  28      14.807 110.261 -11.518  1.00 11.29           N  
ATOM    210  CA  TRP A  28      14.053 110.501 -10.290  1.00 12.29           C  
ATOM    211  C   TRP A  28      12.685 111.194 -10.570  1.00 13.78           C  
ATOM    212  O   TRP A  28      12.373 111.508 -11.730  1.00 12.41           O  
ATOM    213  CB  TRP A  28      14.976 111.345  -9.388  1.00  9.30           C  
ATOM    214  CG  TRP A  28      15.183 112.783  -9.860  1.00 10.91           C  
ATOM    215  CD1 TRP A  28      16.021 113.156 -10.886  1.00 15.09           C  
ATOM    216  CD2 TRP A  28      14.504 113.872  -9.353  1.00 13.55           C  
ATOM    217  NE1 TRP A  28      15.856 114.466 -11.045  1.00 11.58           N  
ATOM    218  CE2 TRP A  28      14.967 114.911 -10.146  1.00 13.42           C  
ATOM    219  CE3 TRP A  28      13.578 114.090  -8.348  1.00 11.50           C  
ATOM    220  CZ2 TRP A  28      14.512 116.189  -9.933  1.00 15.47           C  
ATOM    221  CZ3 TRP A  28      13.131 115.372  -8.144  1.00 14.79           C  
ATOM    222  CH2 TRP A  28      13.590 116.414  -8.930  1.00 14.86           C  
ATOM    223  N   ALA A  29      11.819 111.451  -9.574  1.00 11.81           N  
ATOM    224  CA  ALA A  29      10.609 112.263  -9.701  1.00 13.79           C  
ATOM    225  C   ALA A  29      10.295 112.737  -8.302  1.00 19.24           C  
ATOM    226  O   ALA A  29      10.685 112.032  -7.357  1.00 25.47           O  
ATOM    227  CB  ALA A  29       9.442 111.484 -10.119  1.00 14.42           C  
ATOM    228  N   GLU A  30       9.612 113.869  -8.068  1.00 21.97           N  
ATOM    229  CA  GLU A  30       9.256 114.326  -6.714  1.00 23.77           C  
ATOM    230  C   GLU A  30       8.421 113.335  -5.916  1.00 21.69           C  
ATOM    231  O   GLU A  30       8.512 113.325  -4.694  1.00 25.71           O  
ATOM    232  CB  GLU A  30       8.484 115.646  -6.743  1.00 29.54           C  
ATOM    233  CG  GLU A  30       9.301 116.912  -6.941  1.00 35.01           C  
ATOM    234  CD  GLU A  30       9.995 117.356  -5.664  1.00 40.72           C  
ATOM    235  OE1 GLU A  30       9.347 118.053  -4.882  1.00 45.18           O  
ATOM    236  OE2 GLU A  30      11.163 117.008  -5.442  1.00 42.92           O  
ATOM    237  N   TRP A  31       7.638 112.481  -6.583  1.00 18.45           N  
ATOM    238  CA  TRP A  31       6.840 111.465  -5.903  1.00 21.73           C  
ATOM    239  C   TRP A  31       7.640 110.283  -5.367  1.00 24.09           C  
ATOM    240  O   TRP A  31       7.089 109.398  -4.719  1.00 27.81           O  
ATOM    241  CB  TRP A  31       5.736 110.928  -6.837  1.00 18.46           C  
ATOM    242  CG  TRP A  31       6.140 110.335  -8.171  1.00 15.66           C  
ATOM    243  CD1 TRP A  31       6.161 111.122  -9.284  1.00 17.10           C  
ATOM    244  CD2 TRP A  31       6.459 109.029  -8.444  1.00 15.18           C  
ATOM    245  NE1 TRP A  31       6.483 110.317 -10.274  1.00 15.66           N  
ATOM    246  CE2 TRP A  31       6.667 109.062  -9.820  1.00 12.48           C  
ATOM    247  CE3 TRP A  31       6.590 107.850  -7.751  1.00 14.16           C  
ATOM    248  CZ2 TRP A  31       7.002 107.942 -10.541  1.00  8.24           C  
ATOM    249  CZ3 TRP A  31       6.927 106.721  -8.481  1.00 13.25           C  
ATOM    250  CH2 TRP A  31       7.127 106.770  -9.853  1.00 11.99           C  
ATOM    251  N   CYS A  32       8.919 110.139  -5.722  1.00 29.99           N  
ATOM    252  CA  CYS A  32       9.851 109.171  -5.121  1.00 30.11           C  
ATOM    253  C   CYS A  32      10.140 109.795  -3.751  1.00 35.60           C  
ATOM    254  O   CYS A  32      10.515 110.981  -3.662  1.00 43.58           O  
ATOM    255  CB  CYS A  32      11.119 109.136  -5.955  1.00 28.46           C  
ATOM    256  SG  CYS A  32      12.567 108.179  -5.403  1.00 22.09           S  
ATOM    257  N   GLY A  33      10.004 109.092  -2.639  1.00 35.36           N  
ATOM    258  CA  GLY A  33      10.198 109.804  -1.386  1.00 32.67           C  
ATOM    259  C   GLY A  33      11.627 109.702  -0.900  1.00 32.11           C  
ATOM    260  O   GLY A  33      12.607 110.031  -1.581  1.00 33.46           O  
ATOM    261  N   ARG A  33A     11.670 109.114   0.300  1.00 30.17           N  
ATOM    262  CA  ARG A  33A     12.883 108.835   1.013  1.00 29.11           C  
ATOM    263  C   ARG A  33A     13.936 108.194   0.097  1.00 24.23           C  
ATOM    264  O   ARG A  33A     14.976 108.837   0.080  1.00 19.40           O  
ATOM    265  CB  ARG A  33A     12.478 107.965   2.197  1.00 34.77           C  
ATOM    266  CG  ARG A  33A     13.523 107.484   3.220  1.00 45.71           C  
ATOM    267  CD  ARG A  33A     13.873 108.485   4.327  1.00 54.66           C  
ATOM    268  NE  ARG A  33A     14.619 107.856   5.438  1.00 61.47           N  
ATOM    269  CZ  ARG A  33A     14.745 108.441   6.648  1.00 65.40           C  
ATOM    270  NH1 ARG A  33A     14.216 109.649   6.895  1.00 69.15           N  
ATOM    271  NH2 ARG A  33A     15.423 107.857   7.644  1.00 65.23           N  
ATOM    272  N   PRO A  34      13.842 107.104  -0.714  1.00 21.68           N  
ATOM    273  CA  PRO A  34      14.959 106.548  -1.462  1.00 18.34           C  
ATOM    274  C   PRO A  34      15.692 107.534  -2.362  1.00 18.63           C  
ATOM    275  O   PRO A  34      16.924 107.500  -2.352  1.00 19.69           O  
ATOM    276  CB  PRO A  34      14.341 105.369  -2.189  1.00 17.94           C  
ATOM    277  CG  PRO A  34      12.902 105.736  -2.311  1.00 17.08           C  
ATOM    278  CD  PRO A  34      12.660 106.271  -0.936  1.00 19.87           C  
ATOM    279  N   CYS A  35      15.004 108.450  -3.075  1.00 17.55           N  
ATOM    280  CA  CYS A  35      15.624 109.507  -3.873  1.00 16.49           C  
ATOM    281  C   CYS A  35      16.297 110.559  -3.035  1.00 20.81           C  
ATOM    282  O   CYS A  35      17.325 111.108  -3.432  1.00 23.94           O  
ATOM    283  CB  CYS A  35      14.653 110.271  -4.691  1.00 16.59           C  
ATOM    284  SG  CYS A  35      14.096 109.302  -6.083  1.00 17.94           S  
ATOM    285  N   LYS A  36      15.656 110.908  -1.915  1.00 26.08           N  
ATOM    286  CA  LYS A  36      16.132 111.906  -0.954  1.00 28.79           C  
ATOM    287  C   LYS A  36      17.420 111.459  -0.308  1.00 24.51           C  
ATOM    288  O   LYS A  36      18.352 112.236  -0.208  1.00 22.20           O  
ATOM    289  CB  LYS A  36      15.099 112.160   0.153  1.00 35.27           C  
ATOM    290  CG  LYS A  36      13.906 112.933  -0.368  1.00 46.00           C  
ATOM    291  CD  LYS A  36      12.938 113.314   0.763  1.00 56.67           C  
ATOM    292  CE  LYS A  36      11.739 114.171   0.255  1.00 63.41           C  
ATOM    293  NZ  LYS A  36      10.900 114.679   1.341  1.00 68.90           N  
ATOM    294  N   MET A  37      17.467 110.181   0.039  1.00 24.37           N  
ATOM    295  CA  MET A  37      18.635 109.550   0.593  1.00 21.75           C  
ATOM    296  C   MET A  37      19.822 109.562  -0.323  1.00 21.95           C  
ATOM    297  O   MET A  37      20.902 109.644   0.237  1.00 23.35           O  
ATOM    298  CB  MET A  37      18.354 108.144   0.928  1.00 21.76           C  
ATOM    299  CG  MET A  37      17.483 108.209   2.150  1.00 28.65           C  
ATOM    300  SD  MET A  37      16.966 106.533   2.547  1.00 37.91           S  
ATOM    301  CE  MET A  37      18.571 105.782   2.598  1.00 33.92           C  
ATOM    302  N   ILE A  38      19.728 109.463  -1.668  1.00 22.31           N  
ATOM    303  CA  ILE A  38      20.949 109.425  -2.488  1.00 20.91           C  
ATOM    304  C   ILE A  38      21.424 110.788  -2.987  1.00 21.44           C  
ATOM    305  O   ILE A  38      22.630 110.942  -3.246  1.00 25.84           O  
ATOM    306  CB  ILE A  38      20.833 108.468  -3.744  1.00 17.41           C  
ATOM    307  CG1 ILE A  38      19.587 108.616  -4.545  1.00 20.58           C  
ATOM    308  CG2 ILE A  38      20.831 107.086  -3.210  1.00 15.48           C  
ATOM    309  CD1 ILE A  38      19.870 108.246  -5.999  1.00 22.96           C  
ATOM    310  N   ALA A  39      20.558 111.810  -3.072  1.00 21.62           N  
ATOM    311  CA  ALA A  39      20.906 113.153  -3.510  1.00 16.86           C  
ATOM    312  C   ALA A  39      22.054 113.806  -2.751  1.00 17.73           C  
ATOM    313  O   ALA A  39      22.915 114.355  -3.437  1.00 21.30           O  
ATOM    314  CB  ALA A  39      19.681 114.041  -3.414  1.00 18.45           C  
ATOM    315  N   PRO A  40      22.273 113.805  -1.426  1.00 16.01           N  
ATOM    316  CA  PRO A  40      23.500 114.293  -0.791  1.00 14.99           C  
ATOM    317  C   PRO A  40      24.759 113.555  -1.200  1.00 14.94           C  
ATOM    318  O   PRO A  40      25.833 114.124  -1.367  1.00 17.21           O  
ATOM    319  CB  PRO A  40      23.272 114.178   0.686  1.00 15.76           C  
ATOM    320  CG  PRO A  40      21.763 114.169   0.813  1.00 19.07           C  
ATOM    321  CD  PRO A  40      21.359 113.342  -0.399  1.00 18.13           C  
ATOM    322  N   ILE A  41      24.656 112.250  -1.322  1.00 16.42           N  
ATOM    323  CA  ILE A  41      25.774 111.413  -1.715  1.00 13.35           C  
ATOM    324  C   ILE A  41      26.185 111.745  -3.136  1.00 11.25           C  
ATOM    325  O   ILE A  41      27.384 111.846  -3.413  1.00 12.63           O  
ATOM    326  CB  ILE A  41      25.338 109.957  -1.586  1.00 15.96           C  
ATOM    327  CG1 ILE A  41      25.074 109.645  -0.123  1.00 13.20           C  
ATOM    328  CG2 ILE A  41      26.395 109.042  -2.190  1.00  9.85           C  
ATOM    329  CD1 ILE A  41      24.170 108.378  -0.052  1.00 17.62           C  
ATOM    330  N   LEU A  42      25.263 111.901  -4.079  1.00 11.47           N  
ATOM    331  CA  LEU A  42      25.663 112.270  -5.427  1.00 12.02           C  
ATOM    332  C   LEU A  42      26.444 113.576  -5.425  1.00 14.61           C  
ATOM    333  O   LEU A  42      27.432 113.648  -6.149  1.00 18.54           O  
ATOM    334  CB  LEU A  42      24.457 112.423  -6.299  1.00 10.43           C  
ATOM    335  CG  LEU A  42      23.655 111.195  -6.591  1.00 11.16           C  
ATOM    336  CD1 LEU A  42      22.392 111.677  -7.264  1.00  9.33           C  
ATOM    337  CD2 LEU A  42      24.443 110.198  -7.439  1.00 11.04           C  
ATOM    338  N   ASP A  43      26.160 114.596  -4.600  1.00 21.26           N  
ATOM    339  CA  ASP A  43      26.950 115.835  -4.600  1.00 22.22           C  
ATOM    340  C   ASP A  43      28.386 115.548  -4.207  1.00 22.24           C  
ATOM    341  O   ASP A  43      29.314 116.069  -4.821  1.00 26.47           O  
ATOM    342  CB  ASP A  43      26.346 116.877  -3.625  1.00 27.38           C  
ATOM    343  CG  ASP A  43      24.933 117.379  -4.000  1.00 29.61           C  
ATOM    344  OD1 ASP A  43      24.676 117.677  -5.166  1.00 24.70           O  
ATOM    345  OD2 ASP A  43      24.077 117.480  -3.115  1.00 35.92           O  
ATOM    346  N   GLU A  44      28.594 114.636  -3.260  1.00 23.53           N  
ATOM    347  CA  GLU A  44      29.921 114.192  -2.863  1.00 22.36           C  
ATOM    348  C   GLU A  44      30.616 113.466  -3.968  1.00 22.52           C  
ATOM    349  O   GLU A  44      31.734 113.802  -4.312  1.00 23.92           O  
ATOM    350  CB  GLU A  44      29.858 113.258  -1.666  1.00 22.79           C  
ATOM    351  CG  GLU A  44      29.347 113.998  -0.463  1.00 28.17           C  
ATOM    352  CD  GLU A  44      29.471 113.191   0.814  1.00 32.51           C  
ATOM    353  OE1 GLU A  44      30.518 113.265   1.460  1.00 32.59           O  
ATOM    354  OE2 GLU A  44      28.511 112.501   1.172  1.00 37.66           O  
ATOM    355  N   ILE A  45      30.005 112.471  -4.581  1.00 23.24           N  
ATOM    356  CA  ILE A  45      30.590 111.715  -5.688  1.00 19.86           C  
ATOM    357  C   ILE A  45      30.958 112.645  -6.838  1.00 21.70           C  
ATOM    358  O   ILE A  45      32.045 112.540  -7.400  1.00 20.53           O  
ATOM    359  CB  ILE A  45      29.550 110.640  -6.083  1.00 16.49           C  
ATOM    360  CG1 ILE A  45      29.664 109.525  -5.047  1.00 17.79           C  
ATOM    361  CG2 ILE A  45      29.742 110.099  -7.454  1.00 16.50           C  
ATOM    362  CD1 ILE A  45      31.030 108.862  -4.720  1.00 17.80           C  
ATOM    363  N   ALA A  46      30.122 113.610  -7.192  1.00 23.46           N  
ATOM    364  CA  ALA A  46      30.387 114.511  -8.309  1.00 28.14           C  
ATOM    365  C   ALA A  46      31.649 115.347  -8.081  1.00 28.87           C  
ATOM    366  O   ALA A  46      32.458 115.637  -8.983  1.00 28.85           O  
ATOM    367  CB  ALA A  46      29.175 115.437  -8.489  1.00 28.43           C  
ATOM    368  N   ASP A  47      31.818 115.691  -6.808  1.00 32.11           N  
ATOM    369  CA  ASP A  47      32.965 116.445  -6.340  1.00 34.34           C  
ATOM    370  C   ASP A  47      34.200 115.605  -6.446  1.00 30.33           C  
ATOM    371  O   ASP A  47      35.157 115.886  -7.149  1.00 30.82           O  
ATOM    372  CB  ASP A  47      32.742 116.813  -4.912  1.00 40.63           C  
ATOM    373  CG  ASP A  47      32.757 118.301  -4.737  1.00 45.78           C  
ATOM    374  OD1 ASP A  47      31.826 118.974  -5.185  1.00 45.85           O  
ATOM    375  OD2 ASP A  47      33.721 118.780  -4.131  1.00 52.51           O  
ATOM    376  N   GLU A  48      34.097 114.504  -5.733  1.00 29.49           N  
ATOM    377  CA  GLU A  48      35.142 113.519  -5.619  1.00 31.94           C  
ATOM    378  C   GLU A  48      35.637 112.912  -6.934  1.00 33.43           C  
ATOM    379  O   GLU A  48      36.832 112.605  -7.021  1.00 37.41           O  
ATOM    380  CB  GLU A  48      34.676 112.382  -4.742  1.00 32.51           C  
ATOM    381  CG  GLU A  48      34.425 112.672  -3.269  1.00 32.84           C  
ATOM    382  CD  GLU A  48      34.017 111.444  -2.452  1.00 34.65           C  
ATOM    383  OE1 GLU A  48      34.347 110.290  -2.799  1.00 31.13           O  
ATOM    384  OE2 GLU A  48      33.367 111.682  -1.432  1.00 33.42           O  
ATOM    385  N   TYR A  49      34.777 112.657  -7.938  1.00 31.18           N  
ATOM    386  CA  TYR A  49      35.199 112.057  -9.205  1.00 26.43           C  
ATOM    387  C   TYR A  49      35.374 113.045 -10.319  1.00 26.69           C  
ATOM    388  O   TYR A  49      35.338 112.627 -11.484  1.00 25.89           O  
ATOM    389  CB  TYR A  49      34.204 110.998  -9.685  1.00 24.15           C  
ATOM    390  CG  TYR A  49      34.296 109.716  -8.900  1.00 22.92           C  
ATOM    391  CD1 TYR A  49      33.802 109.682  -7.621  1.00 23.93           C  
ATOM    392  CD2 TYR A  49      34.906 108.623  -9.468  1.00 22.78           C  
ATOM    393  CE1 TYR A  49      33.933 108.527  -6.895  1.00 26.51           C  
ATOM    394  CE2 TYR A  49      35.038 107.466  -8.748  1.00 21.00           C  
ATOM    395  CZ  TYR A  49      34.557 107.440  -7.469  1.00 25.88           C  
ATOM    396  OH  TYR A  49      34.746 106.311  -6.710  1.00 27.55           O  
ATOM    397  N   GLN A  50      35.510 114.338  -9.964  1.00 32.79           N  
ATOM    398  CA  GLN A  50      35.806 115.438 -10.884  1.00 36.96           C  
ATOM    399  C   GLN A  50      36.808 115.056 -11.968  1.00 34.52           C  
ATOM    400  O   GLN A  50      37.880 114.530 -11.672  1.00 36.03           O  
ATOM    401  CB  GLN A  50      36.405 116.624 -10.148  1.00 41.81           C  
ATOM    402  CG  GLN A  50      35.404 117.648  -9.645  1.00 50.30           C  
ATOM    403  CD  GLN A  50      36.053 119.004  -9.371  1.00 55.17           C  
ATOM    404  OE1 GLN A  50      35.524 120.038  -9.783  1.00 59.09           O  
ATOM    405  NE2 GLN A  50      37.221 119.139  -8.740  1.00 55.91           N  
ATOM    406  N   GLY A  51      36.487 115.240 -13.250  1.00 35.52           N  
ATOM    407  CA  GLY A  51      37.396 114.886 -14.340  1.00 33.22           C  
ATOM    408  C   GLY A  51      37.440 113.371 -14.604  1.00 35.63           C  
ATOM    409  O   GLY A  51      37.916 112.965 -15.670  1.00 35.60           O  
ATOM    410  N   LYS A  52      37.016 112.501 -13.669  1.00 33.72           N  
ATOM    411  CA  LYS A  52      36.844 111.065 -13.898  1.00 30.81           C  
ATOM    412  C   LYS A  52      35.410 110.793 -14.390  1.00 24.70           C  
ATOM    413  O   LYS A  52      35.175 109.833 -15.124  1.00 18.97           O  
ATOM    414  CB  LYS A  52      37.033 110.291 -12.593  1.00 36.42           C  
ATOM    415  CG  LYS A  52      38.141 109.260 -12.461  1.00 42.06           C  
ATOM    416  CD  LYS A  52      39.338 109.831 -11.686  1.00 46.17           C  
ATOM    417  CE  LYS A  52      39.136 109.849 -10.164  1.00 50.70           C  
ATOM    418  NZ  LYS A  52      39.214 108.515  -9.581  1.00 51.21           N  
ATOM    419  N   LEU A  53      34.409 111.610 -14.012  1.00 20.63           N  
ATOM    420  CA  LEU A  53      33.006 111.265 -14.217  1.00 16.21           C  
ATOM    421  C   LEU A  53      32.122 112.476 -14.127  1.00 17.49           C  
ATOM    422  O   LEU A  53      32.451 113.299 -13.282  1.00 19.26           O  
ATOM    423  CB  LEU A  53      32.609 110.287 -13.125  1.00 15.71           C  
ATOM    424  CG  LEU A  53      31.196 109.990 -12.720  1.00 13.59           C  
ATOM    425  CD1 LEU A  53      30.565 109.168 -13.791  1.00 15.20           C  
ATOM    426  CD2 LEU A  53      31.167 109.282 -11.402  1.00 10.90           C  
ATOM    427  N   THR A  54      31.022 112.583 -14.892  1.00 17.21           N  
ATOM    428  CA  THR A  54      29.994 113.624 -14.749  1.00 14.44           C  
ATOM    429  C   THR A  54      28.705 113.020 -14.154  1.00 13.73           C  
ATOM    430  O   THR A  54      28.289 111.937 -14.589  1.00 11.39           O  
ATOM    431  CB  THR A  54      29.656 114.232 -16.112  1.00 17.02           C  
ATOM    432  OG1 THR A  54      30.849 114.854 -16.566  1.00 23.27           O  
ATOM    433  CG2 THR A  54      28.476 115.171 -16.066  1.00 14.94           C  
ATOM    434  N   VAL A  55      28.059 113.658 -13.159  1.00  8.77           N  
ATOM    435  CA  VAL A  55      26.825 113.185 -12.580  1.00  7.87           C  
ATOM    436  C   VAL A  55      25.726 113.991 -13.183  1.00  8.18           C  
ATOM    437  O   VAL A  55      25.946 115.187 -13.391  1.00 10.18           O  
ATOM    438  CB  VAL A  55      26.821 113.367 -11.034  1.00  8.94           C  
ATOM    439  CG1 VAL A  55      25.497 112.901 -10.379  1.00  2.86           C  
ATOM    440  CG2 VAL A  55      27.966 112.513 -10.473  1.00  9.35           C  
ATOM    441  N   ALA A  56      24.567 113.430 -13.501  1.00  3.34           N  
ATOM    442  CA  ALA A  56      23.510 114.235 -14.118  1.00  2.95           C  
ATOM    443  C   ALA A  56      22.182 113.712 -13.603  1.00  7.24           C  
ATOM    444  O   ALA A  56      22.119 112.548 -13.169  1.00  6.18           O  
ATOM    445  CB  ALA A  56      23.591 114.062 -15.611  1.00  5.61           C  
ATOM    446  N   LYS A  57      21.115 114.494 -13.505  1.00  5.39           N  
ATOM    447  CA  LYS A  57      19.811 114.019 -13.053  1.00  6.57           C  
ATOM    448  C   LYS A  57      18.751 114.173 -14.116  1.00  8.05           C  
ATOM    449  O   LYS A  57      18.811 115.183 -14.817  1.00 13.77           O  
ATOM    450  CB  LYS A  57      19.323 114.786 -11.894  1.00  8.43           C  
ATOM    451  CG  LYS A  57      20.054 114.480 -10.629  1.00 15.42           C  
ATOM    452  CD  LYS A  57      19.523 115.388  -9.568  1.00 16.65           C  
ATOM    453  CE  LYS A  57      20.136 114.862  -8.279  1.00 23.80           C  
ATOM    454  NZ  LYS A  57      20.029 115.807  -7.172  1.00 24.53           N  
ATOM    455  N   LEU A  58      17.779 113.296 -14.304  1.00  5.58           N  
ATOM    456  CA  LEU A  58      16.682 113.512 -15.223  1.00  3.47           C  
ATOM    457  C   LEU A  58      15.443 113.123 -14.453  1.00  7.01           C  
ATOM    458  O   LEU A  58      15.323 112.047 -13.865  1.00  7.98           O  
ATOM    459  CB  LEU A  58      16.794 112.623 -16.483  1.00 11.47           C  
ATOM    460  CG  LEU A  58      15.672 112.736 -17.535  1.00 12.83           C  
ATOM    461  CD1 LEU A  58      16.259 112.969 -18.908  1.00 13.45           C  
ATOM    462  CD2 LEU A  58      14.831 111.479 -17.492  1.00 13.38           C  
ATOM    463  N   ASN A  59      14.556 114.104 -14.354  1.00 14.02           N  
ATOM    464  CA  ASN A  59      13.271 113.990 -13.706  1.00 15.79           C  
ATOM    465  C   ASN A  59      12.372 113.395 -14.759  1.00 16.59           C  
ATOM    466  O   ASN A  59      12.151 114.043 -15.792  1.00 15.61           O  
ATOM    467  CB  ASN A  59      12.788 115.385 -13.313  1.00 16.92           C  
ATOM    468  CG  ASN A  59      11.427 115.411 -12.636  1.00 17.26           C  
ATOM    469  OD1 ASN A  59      10.365 115.049 -13.152  1.00 21.92           O  
ATOM    470  ND2 ASN A  59      11.444 115.874 -11.419  1.00 13.90           N  
ATOM    471  N   ILE A  60      11.849 112.211 -14.477  1.00 20.50           N  
ATOM    472  CA  ILE A  60      11.037 111.432 -15.399  1.00 21.71           C  
ATOM    473  C   ILE A  60       9.647 111.989 -15.599  1.00 22.80           C  
ATOM    474  O   ILE A  60       9.066 111.766 -16.656  1.00 27.53           O  
ATOM    475  CB  ILE A  60      10.894 109.939 -14.955  1.00 19.30           C  
ATOM    476  CG1 ILE A  60      10.333 109.743 -13.549  1.00 18.15           C  
ATOM    477  CG2 ILE A  60      12.275 109.356 -15.107  1.00 17.73           C  
ATOM    478  CD1 ILE A  60       9.694 108.367 -13.169  1.00 14.83           C  
ATOM    479  N   ASP A  61       9.119 112.773 -14.676  1.00 22.98           N  
ATOM    480  CA  ASP A  61       7.788 113.326 -14.889  1.00 24.50           C  
ATOM    481  C   ASP A  61       7.829 114.437 -15.936  1.00 24.79           C  
ATOM    482  O   ASP A  61       7.061 114.510 -16.909  1.00 22.43           O  
ATOM    483  CB  ASP A  61       7.246 113.883 -13.583  1.00 27.85           C  
ATOM    484  CG  ASP A  61       6.799 112.869 -12.537  1.00 31.07           C  
ATOM    485  OD1 ASP A  61       6.173 111.868 -12.892  1.00 31.92           O  
ATOM    486  OD2 ASP A  61       7.057 113.108 -11.353  1.00 31.28           O  
ATOM    487  N   GLN A  62       8.776 115.335 -15.658  1.00 24.91           N  
ATOM    488  CA  GLN A  62       8.997 116.482 -16.503  1.00 25.23           C  
ATOM    489  C   GLN A  62       9.564 116.002 -17.816  1.00 26.98           C  
ATOM    490  O   GLN A  62       9.343 116.658 -18.817  1.00 29.69           O  
ATOM    491  CB  GLN A  62       9.989 117.474 -15.872  1.00 23.92           C  
ATOM    492  CG  GLN A  62       9.690 118.031 -14.484  1.00 25.02           C  
ATOM    493  CD  GLN A  62      10.723 119.032 -13.983  1.00 26.33           C  
ATOM    494  OE1 GLN A  62      11.876 118.728 -13.647  1.00 26.97           O  
ATOM    495  NE2 GLN A  62      10.321 120.282 -13.939  1.00 28.51           N  
ATOM    496  N   ASN A  63      10.330 114.895 -17.860  1.00 32.77           N  
ATOM    497  CA  ASN A  63      10.927 114.358 -19.084  1.00 32.12           C  
ATOM    498  C   ASN A  63      10.535 112.887 -19.289  1.00 36.73           C  
ATOM    499  O   ASN A  63      11.243 111.965 -18.842  1.00 37.80           O  
ATOM    500  CB  ASN A  63      12.443 114.466 -19.020  1.00 27.14           C  
ATOM    501  CG  ASN A  63      12.860 115.893 -18.894  1.00 24.32           C  
ATOM    502  OD1 ASN A  63      13.182 116.569 -19.861  1.00 26.17           O  
ATOM    503  ND2 ASN A  63      12.864 116.373 -17.672  1.00 23.41           N  
ATOM    504  N   PRO A  64       9.413 112.584 -19.978  1.00 40.04           N  
ATOM    505  CA  PRO A  64       8.878 111.222 -20.013  1.00 39.23           C  
ATOM    506  C   PRO A  64       9.392 110.257 -21.087  1.00 38.88           C  
ATOM    507  O   PRO A  64       9.140 109.052 -21.004  1.00 39.80           O  
ATOM    508  CB  PRO A  64       7.392 111.495 -20.062  1.00 38.78           C  
ATOM    509  CG  PRO A  64       7.296 112.693 -20.976  1.00 37.98           C  
ATOM    510  CD  PRO A  64       8.444 113.556 -20.512  1.00 37.43           C  
ATOM    511  N   GLY A  65      10.115 110.708 -22.118  1.00 37.50           N  
ATOM    512  CA  GLY A  65      10.567 109.826 -23.191  1.00 36.15           C  
ATOM    513  C   GLY A  65      11.895 109.088 -23.006  1.00 34.00           C  
ATOM    514  O   GLY A  65      12.157 108.182 -23.796  1.00 33.41           O  
ATOM    515  N   THR A  66      12.724 109.387 -22.006  1.00 31.84           N  
ATOM    516  CA  THR A  66      14.020 108.750 -21.884  1.00 25.86           C  
ATOM    517  C   THR A  66      13.999 107.418 -21.173  1.00 20.81           C  
ATOM    518  O   THR A  66      14.566 106.446 -21.681  1.00 16.24           O  
ATOM    519  CB  THR A  66      14.945 109.745 -21.189  1.00 26.65           C  
ATOM    520  OG1 THR A  66      14.982 110.845 -22.063  1.00 26.16           O  
ATOM    521  CG2 THR A  66      16.375 109.308 -21.025  1.00 24.26           C  
ATOM    522  N   ALA A  67      13.328 107.334 -20.031  1.00 18.84           N  
ATOM    523  CA  ALA A  67      13.325 106.100 -19.301  1.00 19.89           C  
ATOM    524  C   ALA A  67      12.747 105.007 -20.181  1.00 26.24           C  
ATOM    525  O   ALA A  67      13.400 103.965 -20.174  1.00 30.34           O  
ATOM    526  CB  ALA A  67      12.497 106.224 -18.044  1.00 15.31           C  
ATOM    527  N   PRO A  68      11.660 105.090 -21.005  1.00 33.67           N  
ATOM    528  CA  PRO A  68      11.272 104.047 -21.985  1.00 32.57           C  
ATOM    529  C   PRO A  68      12.361 103.444 -22.862  1.00 30.74           C  
ATOM    530  O   PRO A  68      12.489 102.224 -22.964  1.00 32.96           O  
ATOM    531  CB  PRO A  68      10.152 104.683 -22.840  1.00 34.41           C  
ATOM    532  CG  PRO A  68       9.805 106.009 -22.195  1.00 34.47           C  
ATOM    533  CD  PRO A  68      10.487 105.967 -20.822  1.00 31.27           C  
ATOM    534  N   LYS A  69      13.205 104.253 -23.474  1.00 29.91           N  
ATOM    535  CA  LYS A  69      14.237 103.725 -24.354  1.00 32.29           C  
ATOM    536  C   LYS A  69      15.296 102.949 -23.587  1.00 29.82           C  
ATOM    537  O   LYS A  69      16.076 102.258 -24.235  1.00 31.53           O  
ATOM    538  CB  LYS A  69      14.945 104.845 -25.120  1.00 36.38           C  
ATOM    539  CG  LYS A  69      13.990 105.936 -25.538  1.00 39.48           C  
ATOM    540  CD  LYS A  69      14.678 106.904 -26.452  1.00 46.26           C  
ATOM    541  CE  LYS A  69      13.614 107.922 -26.798  1.00 50.48           C  
ATOM    542  NZ  LYS A  69      13.761 108.378 -28.171  1.00 57.57           N  
ATOM    543  N   TYR A  70      15.386 103.076 -22.254  1.00 24.98           N  
ATOM    544  CA  TYR A  70      16.371 102.325 -21.489  1.00 21.39           C  
ATOM    545  C   TYR A  70      15.717 101.347 -20.535  1.00 21.98           C  
ATOM    546  O   TYR A  70      16.382 100.638 -19.790  1.00 24.28           O  
ATOM    547  CB  TYR A  70      17.311 103.266 -20.699  1.00 17.84           C  
ATOM    548  CG  TYR A  70      18.177 104.075 -21.644  1.00 16.05           C  
ATOM    549  CD1 TYR A  70      19.288 103.544 -22.256  1.00 16.69           C  
ATOM    550  CD2 TYR A  70      17.779 105.344 -21.972  1.00 16.23           C  
ATOM    551  CE1 TYR A  70      19.997 104.263 -23.201  1.00 16.88           C  
ATOM    552  CE2 TYR A  70      18.474 106.076 -22.915  1.00 18.60           C  
ATOM    553  CZ  TYR A  70      19.560 105.513 -23.527  1.00 16.83           C  
ATOM    554  OH  TYR A  70      20.196 106.234 -24.495  1.00 27.23           O  
ATOM    555  N   GLY A  71      14.397 101.282 -20.521  1.00 20.76           N  
ATOM    556  CA  GLY A  71      13.691 100.305 -19.743  1.00 18.47           C  
ATOM    557  C   GLY A  71      13.636 100.558 -18.268  1.00 20.86           C  
ATOM    558  O   GLY A  71      13.532  99.609 -17.496  1.00 20.00           O  
ATOM    559  N   ILE A  72      13.659 101.793 -17.793  1.00 25.99           N  
ATOM    560  CA  ILE A  72      13.579 101.980 -16.343  1.00 28.98           C  
ATOM    561  C   ILE A  72      12.166 101.686 -15.903  1.00 30.41           C  
ATOM    562  O   ILE A  72      11.203 102.093 -16.545  1.00 33.60           O  
ATOM    563  CB  ILE A  72      14.076 103.439 -15.993  1.00 26.95           C  
ATOM    564  CG1 ILE A  72      15.584 103.290 -16.148  1.00 23.39           C  
ATOM    565  CG2 ILE A  72      13.725 104.012 -14.607  1.00 28.66           C  
ATOM    566  CD1 ILE A  72      15.959 104.293 -17.172  1.00 20.97           C  
ATOM    567  N   ARG A  73      12.125 100.855 -14.865  1.00 33.30           N  
ATOM    568  CA  ARG A  73      10.887 100.445 -14.238  1.00 38.82           C  
ATOM    569  C   ARG A  73      10.794 101.299 -12.977  1.00 36.85           C  
ATOM    570  O   ARG A  73       9.835 102.053 -12.818  1.00 43.79           O  
ATOM    571  CB  ARG A  73      10.932  98.946 -13.869  1.00 44.55           C  
ATOM    572  CG  ARG A  73      11.292  97.950 -14.981  1.00 49.62           C  
ATOM    573  CD  ARG A  73      10.210  97.834 -16.053  1.00 57.09           C  
ATOM    574  NE  ARG A  73       9.372  96.645 -15.883  1.00 66.00           N  
ATOM    575  CZ  ARG A  73       8.114  96.655 -15.382  1.00 70.01           C  
ATOM    576  NH1 ARG A  73       7.531  97.793 -14.957  1.00 70.42           N  
ATOM    577  NH2 ARG A  73       7.447  95.481 -15.279  1.00 70.80           N  
ATOM    578  N   GLY A  74      11.743 101.283 -12.036  1.00 34.17           N  
ATOM    579  CA  GLY A  74      11.583 102.114 -10.858  1.00 26.75           C  
ATOM    580  C   GLY A  74      12.636 103.182 -10.777  1.00 24.16           C  
ATOM    581  O   GLY A  74      13.622 103.108 -11.486  1.00 24.17           O  
ATOM    582  N   ILE A  75      12.379 104.145  -9.901  1.00 21.26           N  
ATOM    583  CA  ILE A  75      13.274 105.234  -9.563  1.00 19.27           C  
ATOM    584  C   ILE A  75      13.605 105.069  -8.063  1.00 18.40           C  
ATOM    585  O   ILE A  75      12.794 104.451  -7.355  1.00 13.96           O  
ATOM    586  CB  ILE A  75      12.622 106.629  -9.814  1.00 18.81           C  
ATOM    587  CG1 ILE A  75      11.237 106.782  -9.182  1.00 20.14           C  
ATOM    588  CG2 ILE A  75      12.630 106.824 -11.324  1.00 20.17           C  
ATOM    589  CD1 ILE A  75      10.676 108.221  -9.204  1.00 21.84           C  
ATOM    590  N   PRO A  76      14.780 105.456  -7.522  1.00 17.47           N  
ATOM    591  CA  PRO A  76      15.898 105.925  -8.312  1.00 14.16           C  
ATOM    592  C   PRO A  76      16.502 104.749  -9.035  1.00 13.74           C  
ATOM    593  O   PRO A  76      16.475 103.614  -8.554  1.00 17.94           O  
ATOM    594  CB  PRO A  76      16.825 106.558  -7.288  1.00 14.65           C  
ATOM    595  CG  PRO A  76      16.675 105.652  -6.068  1.00 14.07           C  
ATOM    596  CD  PRO A  76      15.221 105.146  -6.137  1.00 11.40           C  
ATOM    597  N   THR A  77      16.880 105.033 -10.252  1.00 14.10           N  
ATOM    598  CA  THR A  77      17.715 104.160 -11.010  1.00 12.03           C  
ATOM    599  C   THR A  77      18.866 105.057 -11.414  1.00 11.40           C  
ATOM    600  O   THR A  77      18.700 106.210 -11.804  1.00 13.10           O  
ATOM    601  CB  THR A  77      17.045 103.659 -12.272  1.00 16.97           C  
ATOM    602  OG1 THR A  77      16.030 102.745 -11.844  1.00 15.95           O  
ATOM    603  CG2 THR A  77      18.041 102.994 -13.248  1.00 15.17           C  
ATOM    604  N   LEU A  78      20.076 104.491 -11.372  1.00 11.28           N  
ATOM    605  CA  LEU A  78      21.290 105.173 -11.731  1.00  8.74           C  
ATOM    606  C   LEU A  78      21.840 104.393 -12.919  1.00  6.10           C  
ATOM    607  O   LEU A  78      21.959 103.163 -12.726  1.00  8.07           O  
ATOM    608  CB  LEU A  78      22.318 105.101 -10.618  1.00  5.97           C  
ATOM    609  CG  LEU A  78      22.125 105.725  -9.294  1.00  8.68           C  
ATOM    610  CD1 LEU A  78      23.296 105.228  -8.502  1.00 12.08           C  
ATOM    611  CD2 LEU A  78      21.998 107.239  -9.333  1.00  9.80           C  
ATOM    612  N   LEU A  79      22.045 105.014 -14.082  1.00  4.84           N  
ATOM    613  CA  LEU A  79      22.642 104.342 -15.194  1.00  6.65           C  
ATOM    614  C   LEU A  79      24.015 104.919 -15.418  1.00 10.19           C  
ATOM    615  O   LEU A  79      24.097 106.140 -15.581  1.00 12.99           O  
ATOM    616  CB  LEU A  79      21.979 104.539 -16.542  1.00  8.15           C  
ATOM    617  CG  LEU A  79      20.525 104.147 -16.873  1.00 13.00           C  
ATOM    618  CD1 LEU A  79      20.271 104.338 -18.408  1.00  9.91           C  
ATOM    619  CD2 LEU A  79      20.389 102.661 -16.599  1.00 12.13           C  
ATOM    620  N   LEU A  80      25.055 104.081 -15.550  1.00  6.79           N  
ATOM    621  CA  LEU A  80      26.369 104.573 -15.906  1.00 10.21           C  
ATOM    622  C   LEU A  80      26.600 104.433 -17.418  1.00 14.39           C  
ATOM    623  O   LEU A  80      26.478 103.349 -18.021  1.00 11.68           O  
ATOM    624  CB  LEU A  80      27.432 103.813 -15.123  1.00  5.93           C  
ATOM    625  CG  LEU A  80      28.860 104.196 -15.418  1.00  5.52           C  
ATOM    626  CD1 LEU A  80      29.108 105.567 -14.901  1.00  2.00           C  
ATOM    627  CD2 LEU A  80      29.818 103.221 -14.754  1.00  3.07           C  
ATOM    628  N   PHE A  81      26.905 105.560 -18.087  1.00 17.43           N  
ATOM    629  CA  PHE A  81      27.217 105.586 -19.518  1.00 13.27           C  
ATOM    630  C   PHE A  81      28.703 105.804 -19.749  1.00 14.31           C  
ATOM    631  O   PHE A  81      29.284 106.657 -19.059  1.00 13.32           O  
ATOM    632  CB  PHE A  81      26.493 106.720 -20.211  1.00 10.63           C  
ATOM    633  CG  PHE A  81      25.023 106.476 -20.456  1.00  8.64           C  
ATOM    634  CD1 PHE A  81      24.111 106.728 -19.473  1.00  3.90           C  
ATOM    635  CD2 PHE A  81      24.602 106.099 -21.714  1.00  9.21           C  
ATOM    636  CE1 PHE A  81      22.772 106.591 -19.760  1.00  7.22           C  
ATOM    637  CE2 PHE A  81      23.266 105.960 -21.982  1.00  7.77           C  
ATOM    638  CZ  PHE A  81      22.344 106.209 -21.001  1.00  9.25           C  
ATOM    639  N   LYS A  82      29.337 105.075 -20.666  1.00 12.79           N  
ATOM    640  CA  LYS A  82      30.719 105.352 -21.018  1.00 15.97           C  
ATOM    641  C   LYS A  82      30.625 105.489 -22.507  1.00 17.18           C  
ATOM    642  O   LYS A  82      30.204 104.536 -23.157  1.00 15.79           O  
ATOM    643  CB  LYS A  82      31.681 104.213 -20.737  1.00 15.55           C  
ATOM    644  CG  LYS A  82      31.671 103.927 -19.241  1.00 20.51           C  
ATOM    645  CD  LYS A  82      32.464 102.701 -18.863  1.00 22.06           C  
ATOM    646  CE  LYS A  82      33.966 102.963 -18.903  1.00 27.51           C  
ATOM    647  NZ  LYS A  82      34.680 101.755 -18.508  1.00 29.74           N  
ATOM    648  N   ASN A  83      30.846 106.711 -23.016  1.00 21.05           N  
ATOM    649  CA  ASN A  83      30.957 107.022 -24.441  1.00 24.67           C  
ATOM    650  C   ASN A  83      29.767 106.537 -25.270  1.00 24.50           C  
ATOM    651  O   ASN A  83      29.858 105.751 -26.207  1.00 28.12           O  
ATOM    652  CB  ASN A  83      32.272 106.409 -24.997  1.00 25.08           C  
ATOM    653  CG  ASN A  83      33.523 106.875 -24.272  1.00 26.56           C  
ATOM    654  OD1 ASN A  83      33.817 108.061 -24.214  1.00 29.89           O  
ATOM    655  ND2 ASN A  83      34.319 106.034 -23.622  1.00 25.80           N  
ATOM    656  N   GLY A  84      28.586 106.947 -24.916  1.00 24.98           N  
ATOM    657  CA  GLY A  84      27.401 106.540 -25.639  1.00 25.65           C  
ATOM    658  C   GLY A  84      26.804 105.224 -25.128  1.00 26.51           C  
ATOM    659  O   GLY A  84      25.629 105.005 -25.431  1.00 29.52           O  
ATOM    660  N   GLU A  85      27.450 104.348 -24.338  1.00 24.29           N  
ATOM    661  CA  GLU A  85      26.821 103.073 -24.042  1.00 24.46           C  
ATOM    662  C   GLU A  85      26.517 102.861 -22.569  1.00 18.98           C  
ATOM    663  O   GLU A  85      27.202 103.366 -21.681  1.00 20.53           O  
ATOM    664  CB  GLU A  85      27.717 101.901 -24.505  1.00 31.49           C  
ATOM    665  CG  GLU A  85      28.455 102.028 -25.841  1.00 44.04           C  
ATOM    666  CD  GLU A  85      28.089 101.068 -26.986  1.00 51.53           C  
ATOM    667  OE1 GLU A  85      26.968 101.213 -27.494  1.00 54.01           O  
ATOM    668  OE2 GLU A  85      28.920 100.233 -27.412  1.00 53.25           O  
ATOM    669  N   VAL A  86      25.443 102.116 -22.267  1.00 15.53           N  
ATOM    670  CA  VAL A  86      25.188 101.775 -20.853  1.00 16.98           C  
ATOM    671  C   VAL A  86      26.232 100.794 -20.418  1.00 15.72           C  
ATOM    672  O   VAL A  86      26.403  99.735 -21.015  1.00 22.39           O  
ATOM    673  CB  VAL A  86      23.832 101.103 -20.585  1.00 15.41           C  
ATOM    674  CG1 VAL A  86      23.697 100.921 -19.120  1.00 18.27           C  
ATOM    675  CG2 VAL A  86      22.714 101.942 -21.059  1.00 19.36           C  
ATOM    676  N   ALA A  87      27.003 101.101 -19.410  1.00 15.46           N  
ATOM    677  CA  ALA A  87      27.989 100.186 -18.887  1.00  9.58           C  
ATOM    678  C   ALA A  87      27.295  99.402 -17.806  1.00 12.54           C  
ATOM    679  O   ALA A  87      27.650  98.266 -17.704  1.00 17.67           O  
ATOM    680  CB  ALA A  87      29.072 100.992 -18.275  1.00  5.99           C  
ATOM    681  N   ALA A  88      26.366  99.932 -16.987  1.00 10.77           N  
ATOM    682  CA  ALA A  88      25.867  99.216 -15.798  1.00  8.95           C  
ATOM    683  C   ALA A  88      24.703  99.978 -15.158  1.00  9.72           C  
ATOM    684  O   ALA A  88      24.574 101.172 -15.468  1.00  9.36           O  
ATOM    685  CB  ALA A  88      26.924  99.104 -14.697  1.00  7.46           C  
ATOM    686  N   THR A  89      23.909  99.351 -14.296  1.00  5.88           N  
ATOM    687  CA  THR A  89      22.680  99.912 -13.771  1.00  8.57           C  
ATOM    688  C   THR A  89      22.637  99.625 -12.281  1.00  7.36           C  
ATOM    689  O   THR A  89      23.084  98.552 -11.914  1.00 10.52           O  
ATOM    690  CB  THR A  89      21.538  99.230 -14.503  1.00  8.67           C  
ATOM    691  OG1 THR A  89      21.712  99.617 -15.855  1.00  9.22           O  
ATOM    692  CG2 THR A  89      20.171  99.533 -13.949  1.00  8.11           C  
ATOM    693  N   LYS A  90      22.120 100.482 -11.422  1.00  7.43           N  
ATOM    694  CA  LYS A  90      21.983 100.266  -9.986  1.00  7.73           C  
ATOM    695  C   LYS A  90      20.581 100.753  -9.723  1.00 10.89           C  
ATOM    696  O   LYS A  90      20.237 101.854 -10.160  1.00 10.25           O  
ATOM    697  CB  LYS A  90      22.850 101.133  -9.136  1.00  9.95           C  
ATOM    698  CG  LYS A  90      24.061 100.427  -8.615  1.00 19.49           C  
ATOM    699  CD  LYS A  90      23.734  99.398  -7.561  1.00 23.90           C  
ATOM    700  CE  LYS A  90      24.978  98.540  -7.273  1.00 31.16           C  
ATOM    701  NZ  LYS A  90      24.862  97.822  -6.003  1.00 35.59           N  
ATOM    702  N   VAL A  91      19.702  99.968  -9.100  1.00 14.05           N  
ATOM    703  CA  VAL A  91      18.322 100.366  -8.846  1.00 14.61           C  
ATOM    704  C   VAL A  91      18.132 100.593  -7.325  1.00 13.22           C  
ATOM    705  O   VAL A  91      18.695  99.883  -6.494  1.00 12.95           O  
ATOM    706  CB  VAL A  91      17.419  99.235  -9.448  1.00 12.96           C  
ATOM    707  CG1 VAL A  91      15.982  99.688  -9.436  1.00 15.96           C  
ATOM    708  CG2 VAL A  91      17.668  99.012 -10.915  1.00  6.06           C  
ATOM    709  N   GLY A  92      17.337 101.576  -6.935  1.00 12.80           N  
ATOM    710  CA  GLY A  92      17.119 101.902  -5.549  1.00 14.65           C  
ATOM    711  C   GLY A  92      18.251 102.706  -4.897  1.00 16.54           C  
ATOM    712  O   GLY A  92      19.253 103.155  -5.480  1.00 20.22           O  
ATOM    713  N   ALA A  93      17.952 102.957  -3.626  1.00 17.85           N  
ATOM    714  CA  ALA A  93      18.823 103.721  -2.754  1.00 20.55           C  
ATOM    715  C   ALA A  93      20.017 102.901  -2.289  1.00 20.80           C  
ATOM    716  O   ALA A  93      19.904 101.694  -2.042  1.00 25.14           O  
ATOM    717  CB  ALA A  93      18.051 104.191  -1.528  1.00 16.21           C  
ATOM    718  N   LEU A  94      21.195 103.501  -2.177  1.00 21.56           N  
ATOM    719  CA  LEU A  94      22.358 102.770  -1.745  1.00 16.95           C  
ATOM    720  C   LEU A  94      23.262 103.758  -1.020  1.00 18.64           C  
ATOM    721  O   LEU A  94      23.031 104.976  -0.959  1.00 19.41           O  
ATOM    722  CB  LEU A  94      23.003 102.117  -2.981  1.00 15.89           C  
ATOM    723  CG  LEU A  94      23.923 102.745  -3.999  1.00 14.79           C  
ATOM    724  CD1 LEU A  94      24.389 101.607  -4.859  1.00 11.74           C  
ATOM    725  CD2 LEU A  94      23.268 103.791  -4.858  1.00 17.71           C  
ATOM    726  N   SER A  95      24.213 103.205  -0.314  1.00 16.24           N  
ATOM    727  CA  SER A  95      25.134 103.973   0.464  1.00 15.55           C  
ATOM    728  C   SER A  95      26.236 104.532  -0.429  1.00 14.85           C  
ATOM    729  O   SER A  95      26.507 104.021  -1.506  1.00 16.63           O  
ATOM    730  CB  SER A  95      25.680 103.038   1.521  1.00 15.96           C  
ATOM    731  OG  SER A  95      26.571 102.088   0.943  1.00 11.02           O  
ATOM    732  N   LYS A  96      27.004 105.478   0.077  1.00 13.93           N  
ATOM    733  CA  LYS A  96      28.096 106.069  -0.646  1.00 15.76           C  
ATOM    734  C   LYS A  96      29.186 105.057  -0.910  1.00 16.07           C  
ATOM    735  O   LYS A  96      29.762 105.058  -1.994  1.00 21.11           O  
ATOM    736  CB  LYS A  96      28.663 107.225   0.149  1.00 15.00           C  
ATOM    737  CG  LYS A  96      29.380 108.224  -0.683  1.00 14.73           C  
ATOM    738  CD  LYS A  96      30.738 108.265  -0.150  1.00 15.96           C  
ATOM    739  CE  LYS A  96      31.162 109.675  -0.311  1.00 20.19           C  
ATOM    740  NZ  LYS A  96      32.243 109.922   0.623  1.00 25.64           N  
ATOM    741  N   GLY A  97      29.442 104.202   0.080  1.00 14.61           N  
ATOM    742  CA  GLY A  97      30.457 103.175   0.028  1.00  8.53           C  
ATOM    743  C   GLY A  97      30.044 102.180  -1.021  1.00 10.42           C  
ATOM    744  O   GLY A  97      30.854 101.861  -1.901  1.00 12.68           O  
ATOM    745  N   GLN A  98      28.802 101.677  -1.012  1.00 10.79           N  
ATOM    746  CA  GLN A  98      28.518 100.789  -2.093  1.00 16.05           C  
ATOM    747  C   GLN A  98      28.327 101.534  -3.435  1.00 16.67           C  
ATOM    748  O   GLN A  98      28.580 100.975  -4.513  1.00 20.41           O  
ATOM    749  CB  GLN A  98      27.366  99.945  -1.587  1.00 15.62           C  
ATOM    750  CG  GLN A  98      26.024 100.511  -1.702  1.00 20.88           C  
ATOM    751  CD  GLN A  98      25.038  99.723  -0.872  1.00 20.79           C  
ATOM    752  OE1 GLN A  98      24.279 100.294  -0.089  1.00 25.06           O  
ATOM    753  NE2 GLN A  98      24.861  98.429  -1.030  1.00 22.08           N  
ATOM    754  N   LEU A  99      28.032 102.838  -3.490  1.00 18.92           N  
ATOM    755  CA  LEU A  99      28.008 103.540  -4.768  1.00 13.52           C  
ATOM    756  C   LEU A  99      29.444 103.662  -5.267  1.00 16.66           C  
ATOM    757  O   LEU A  99      29.701 103.456  -6.465  1.00 18.83           O  
ATOM    758  CB  LEU A  99      27.367 104.915  -4.614  1.00 11.22           C  
ATOM    759  CG  LEU A  99      27.476 105.822  -5.847  1.00  9.81           C  
ATOM    760  CD1 LEU A  99      26.910 105.196  -7.113  1.00  8.33           C  
ATOM    761  CD2 LEU A  99      26.690 107.036  -5.567  1.00 10.72           C  
ATOM    762  N   LYS A 100      30.427 103.927  -4.409  1.00 16.62           N  
ATOM    763  CA  LYS A 100      31.827 103.909  -4.815  1.00 18.37           C  
ATOM    764  C   LYS A 100      32.271 102.543  -5.298  1.00 19.15           C  
ATOM    765  O   LYS A 100      33.100 102.487  -6.207  1.00 22.35           O  
ATOM    766  CB  LYS A 100      32.716 104.304  -3.669  1.00 23.26           C  
ATOM    767  CG  LYS A 100      32.562 105.800  -3.421  1.00 30.61           C  
ATOM    768  CD  LYS A 100      33.343 106.287  -2.217  1.00 35.30           C  
ATOM    769  CE  LYS A 100      34.818 105.861  -2.269  1.00 42.14           C  
ATOM    770  NZ  LYS A 100      35.628 106.608  -3.221  1.00 42.73           N  
ATOM    771  N   GLU A 101      31.751 101.426  -4.781  1.00 16.45           N  
ATOM    772  CA  GLU A 101      32.134 100.122  -5.283  1.00 15.24           C  
ATOM    773  C   GLU A 101      31.617 100.036  -6.702  1.00 17.18           C  
ATOM    774  O   GLU A 101      32.396  99.659  -7.591  1.00 20.03           O  
ATOM    775  CB  GLU A 101      31.494  98.941  -4.537  1.00 20.28           C  
ATOM    776  CG  GLU A 101      31.767  98.791  -3.044  1.00 26.62           C  
ATOM    777  CD  GLU A 101      31.427  97.423  -2.423  1.00 28.66           C  
ATOM    778  OE1 GLU A 101      30.296  96.917  -2.539  1.00 27.24           O  
ATOM    779  OE2 GLU A 101      32.335  96.863  -1.806  1.00 31.90           O  
ATOM    780  N   PHE A 102      30.334 100.374  -6.953  1.00 17.10           N  
ATOM    781  CA  PHE A 102      29.808 100.309  -8.315  1.00 15.30           C  
ATOM    782  C   PHE A 102      30.639 101.184  -9.265  1.00 14.44           C  
ATOM    783  O   PHE A 102      31.058 100.666 -10.301  1.00 17.14           O  
ATOM    784  CB  PHE A 102      28.340 100.733  -8.293  1.00 13.40           C  
ATOM    785  CG  PHE A 102      27.616 100.996  -9.619  1.00 16.27           C  
ATOM    786  CD1 PHE A 102      27.046  99.955 -10.333  1.00 17.17           C  
ATOM    787  CD2 PHE A 102      27.488 102.292 -10.096  1.00 15.95           C  
ATOM    788  CE1 PHE A 102      26.361 100.231 -11.506  1.00 16.94           C  
ATOM    789  CE2 PHE A 102      26.803 102.544 -11.268  1.00 16.67           C  
ATOM    790  CZ  PHE A 102      26.230 101.521 -11.977  1.00 17.04           C  
ATOM    791  N   LEU A 103      30.969 102.443  -8.985  1.00 14.63           N  
ATOM    792  CA  LEU A 103      31.711 103.259  -9.927  1.00 14.39           C  
ATOM    793  C   LEU A 103      33.128 102.784 -10.062  1.00 18.36           C  
ATOM    794  O   LEU A 103      33.645 102.821 -11.172  1.00 19.01           O  
ATOM    795  CB  LEU A 103      31.815 104.714  -9.533  1.00 11.19           C  
ATOM    796  CG  LEU A 103      30.547 105.519  -9.222  1.00 12.01           C  
ATOM    797  CD1 LEU A 103      30.871 106.804  -8.480  1.00  8.90           C  
ATOM    798  CD2 LEU A 103      29.837 105.783 -10.519  1.00  4.79           C  
ATOM    799  N   ASP A 104      33.818 102.351  -9.020  1.00 21.03           N  
ATOM    800  CA  ASP A 104      35.188 101.890  -9.202  1.00 26.84           C  
ATOM    801  C   ASP A 104      35.336 100.641 -10.087  1.00 29.40           C  
ATOM    802  O   ASP A 104      36.129 100.614 -11.043  1.00 31.04           O  
ATOM    803  CB  ASP A 104      35.771 101.701  -7.804  1.00 28.80           C  
ATOM    804  CG  ASP A 104      36.078 103.050  -7.115  1.00 35.21           C  
ATOM    805  OD1 ASP A 104      36.285 104.084  -7.766  1.00 34.78           O  
ATOM    806  OD2 ASP A 104      36.121 103.068  -5.883  1.00 40.31           O  
ATOM    807  N   ALA A 105      34.471  99.650  -9.886  1.00 26.37           N  
ATOM    808  CA  ALA A 105      34.460  98.463 -10.725  1.00 23.42           C  
ATOM    809  C   ALA A 105      34.205  98.688 -12.200  1.00 22.04           C  
ATOM    810  O   ALA A 105      34.600  97.881 -13.027  1.00 25.52           O  
ATOM    811  CB  ALA A 105      33.398  97.511 -10.239  1.00 22.00           C  
ATOM    812  N   ASN A 106      33.594  99.809 -12.531  1.00 23.55           N  
ATOM    813  CA  ASN A 106      33.131 100.096 -13.872  1.00 25.55           C  
ATOM    814  C   ASN A 106      33.868 101.219 -14.545  1.00 28.19           C  
ATOM    815  O   ASN A 106      33.568 101.586 -15.664  1.00 31.46           O  
ATOM    816  CB  ASN A 106      31.652 100.432 -13.794  1.00 25.74           C  
ATOM    817  CG  ASN A 106      30.681  99.263 -13.621  1.00 28.33           C  
ATOM    818  OD1 ASN A 106      30.292  98.657 -14.618  1.00 32.50           O  
ATOM    819  ND2 ASN A 106      30.168  98.866 -12.456  1.00 26.64           N  
ATOM    820  N   LEU A 107      34.809 101.863 -13.899  1.00 35.11           N  
ATOM    821  CA  LEU A 107      35.566 102.935 -14.523  1.00 41.95           C  
ATOM    822  C   LEU A 107      36.997 102.384 -14.709  1.00 49.65           C  
ATOM    823  O   LEU A 107      37.992 103.087 -14.475  1.00 54.13           O  
ATOM    824  CB  LEU A 107      35.521 104.180 -13.580  1.00 36.31           C  
ATOM    825  CG  LEU A 107      34.653 105.424 -13.745  1.00 32.28           C  
ATOM    826  CD1 LEU A 107      33.266 105.153 -14.311  1.00 33.73           C  
ATOM    827  CD2 LEU A 107      34.603 106.033 -12.366  1.00 26.43           C  
ATOM    828  N   ALA A 108      37.133 101.106 -15.086  1.00 56.93           N  
ATOM    829  CA  ALA A 108      38.419 100.439 -15.248  1.00 59.96           C  
ATOM    830  C   ALA A 108      38.418  99.659 -16.572  1.00 61.97           C  
ATOM    831  O   ALA A 108      39.483  99.213 -17.018  1.00 63.40           O  
ATOM    832  CB  ALA A 108      38.627  99.496 -14.040  1.00 58.54           C  
ATOM    833  OXT ALA A 108      37.339  99.520 -17.165  1.00 63.44           O  
TER     834      ALA A 108                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
