
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 (  715),  selected   92 , name 1v98_A
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 1v98_A.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    49_A      -       -           -
LGA    A    50_A      -       -           -
LGA    P    51_A      T      12          1.885
LGA    L    52_A      H      13          1.482
LGA    T    53_A      R      14          0.986
LGA    L    54_A      V      15          1.063
LGA    V    55_A      Q      16          0.918
LGA    D    56_A      I      17          0.899
LGA    F    57_A      E      18          0.997
LGA    F    58_A      Y      19          1.598
LGA    A    59_A      C      20          2.900
LGA    P    60_A      T      21          2.521
LGA    W    61_A      Q      22          2.129
LGA    C    62_A      C      23          2.033
LGA    G    63_A      R      24          4.514
LGA    P    64_A      W      25          4.894
LGA    C    65_A      L      26          5.037
LGA    R    66_A      P      27          3.025
LGA    L    67_A      R      28          2.279
LGA    V    68_A      A      29          3.661
LGA    S    69_A      A      30          2.656
LGA    P    70_A      W      31          0.894
LGA    I    71_A      L      32          1.993
LGA    L    72_A      A      33          2.040
LGA    E    73_A      Q      34          2.056
LGA    E    74_A      E      35          2.591
LGA    L    75_A      L      36          1.426
LGA    A    76_A      L      37          1.056
LGA    R    77_A      T      38          2.812
LGA    D    78_A      T      39          2.773
LGA    H    79_A      F      40          1.597
LGA    A    80_A      E      41          1.283
LGA    G    81_A      T      42          1.697
LGA    R    82_A      E      43          0.783
LGA    L    83_A      L      44          1.573
LGA    -       -      T      45           -
LGA    K    84_A      E      46          2.159
LGA    V    85_A      L      47          0.925
LGA    V    86_A      A      48          0.292
LGA    K    87_A      L      49          0.580
LGA    V    88_A      K      50          1.004
LGA    N    89_A      P      51          1.292
LGA    V    90_A      G      52          2.592
LGA    D    91_A      T      53          5.553
LGA    E    92_A      G      54           -
LGA    H    93_A      -       -           -
LGA    P    94_A      -       -           -
LGA    G    95_A      -       -           -
LGA    L    96_A      -       -           -
LGA    A    97_A      -       -           -
LGA    A    98_A      -       -           -
LGA    R    99_A      -       -           -
LGA    Y   100_A      -       -           -
LGA    G   101_A      -       -           -
LGA    V   102_A      -       -           -
LGA    R   103_A      -       -           -
LGA    S   104_A      G      55          4.338
LGA    V   105_A      V      56          1.270
LGA    P   106_A      F      57          0.959
LGA    T   107_A      V      58          1.344
LGA    L   108_A      V      59          1.338
LGA    V   109_A      R      60          1.441
LGA    L   110_A      V      61          1.248
LGA    F   111_A      D      62          0.859
LGA    R   112_A      -       -           -
LGA    R   113_A      -       -           -
LGA    G   114_A      -       -           -
LGA    A   115_A      -       -           -
LGA    P   116_A      D      63          2.035
LGA    V   117_A      E      64          2.892
LGA    A   118_A      -       -           -
LGA    T   119_A      V      65          0.998
LGA    W   120_A      V      66          3.841
LGA    -       -      W      67           -
LGA    V   121_A      D      68          0.935
LGA    G   122_A      R      69          1.300
LGA    -       -      R      70           -
LGA    -       -      E      71           -
LGA    -       -      Q      72           -
LGA    -       -      G      73           -
LGA    A   123_A      F      74          3.027
LGA    S   124_A      P      75          1.201
LGA    P   125_A      E      76          0.883
LGA    R   126_A      P      77          0.584
LGA    R   127_A      T      78          0.746
LGA    V   128_A      A      79          0.945
LGA    L   129_A      V      80          1.014
LGA    E   130_A      K      81          0.876
LGA    E   131_A      R      82          0.911
LGA    R   132_A      L      83          0.785
LGA    L   133_A      V      84          0.868
LGA    R   134_A      R      85          1.342
LGA    P   135_A      D      86          1.273
LGA    Y   136_A      R      87          1.717
LGA    L   137_A      V      88          2.331
LGA    E   138_A      -       -           -
LGA    G   139_A      -       -           -
LGA    R   140_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92   77    5.0     70    2.15     8.57     72.795     3.104

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.614941 * X  +   0.788537 * Y  +   0.007486 * Z  +   9.586857
  Y_new =   0.147899 * X  +  -0.106004 * Y  +  -0.983305 * Z  + 122.468269
  Z_new =  -0.774579 * X  +   0.605782 * Y  +  -0.181810 * Z  +   5.309682 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.862367   -1.279226  [ DEG:   106.7058    -73.2942 ]
  Theta =   0.886050    2.255543  [ DEG:    50.7669    129.2331 ]
  Phi   =   0.236026   -2.905566  [ DEG:    13.5233   -166.4767 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1v98_A                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1v98_A.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92   77   5.0   70   2.15    8.57  72.795
REMARK  ---------------------------------------------------------- 
MOLECULE 1v98_A
HEADER    OXIDOREDUCTASE                          21-JAN-04   1V98              
TITLE     CRYSTAL STRUCTURE ANALYSIS OF THIOREDOXIN FROM THERMUS                
TITLE    2 THERMOPHILUS                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOREDOXIN;                                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 1.8.1.9;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET-11A                                   
KEYWDS    OXIDOREDUCTASE, STRUCTURAL GENOMICS, RIKEN STRUCTURAL                 
KEYWDS   2 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.H.REHSE,T.H.TAHIROV,RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
AUTHOR   2 INITIATIVE (RSGI)                                                    
REVDAT   1   01-FEB-05 1V98    0                                                
JRNL        AUTH   P.H.REHSE,T.H.TAHIROV                                        
JRNL        TITL   CRYSTALLOGRAPHIC ANALYSIS OF THIOREDOXIN FROM THE            
JRNL        TITL 2 THERMOPHILIC BACTERIA THERMUS THERMOPHILUS                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.82 ANGSTROMS.                                          
DBREF  1V98 A    1   140  UNP    Q5SI93   Q5SI93_THET8     1    140             
DBREF  1V98 B    1   140  UNP    Q5SI93   Q5SI93_THET8     1    140             
SEQRES   1 A  140  MET VAL VAL THR CYS PRO LYS CYS GLY ALA LYS ASN ARG          
SEQRES   2 A  140  LEU GLY THR PRO PRO PRO GLY GLN VAL PRO VAL CYS GLY          
SEQRES   3 A  140  ALA CYS LYS THR PRO LEU PRO TRP VAL VAL GLU ALA ASP          
SEQRES   4 A  140  GLU LYS GLY PHE ALA GLN GLU VAL ALA GLY ALA PRO LEU          
SEQRES   5 A  140  THR LEU VAL ASP PHE PHE ALA PRO TRP CYS GLY PRO CYS          
SEQRES   6 A  140  ARG LEU VAL SER PRO ILE LEU GLU GLU LEU ALA ARG ASP          
SEQRES   7 A  140  HIS ALA GLY ARG LEU LYS VAL VAL LYS VAL ASN VAL ASP          
SEQRES   8 A  140  GLU HIS PRO GLY LEU ALA ALA ARG TYR GLY VAL ARG SER          
SEQRES   9 A  140  VAL PRO THR LEU VAL LEU PHE ARG ARG GLY ALA PRO VAL          
SEQRES  10 A  140  ALA THR TRP VAL GLY ALA SER PRO ARG ARG VAL LEU GLU          
SEQRES  11 A  140  GLU ARG LEU ARG PRO TYR LEU GLU GLY ARG                      
SEQRES   1 B  140  MET VAL VAL THR CYS PRO LYS CYS GLY ALA LYS ASN ARG          
SEQRES   2 B  140  LEU GLY THR PRO PRO PRO GLY GLN VAL PRO VAL CYS GLY          
SEQRES   3 B  140  ALA CYS LYS THR PRO LEU PRO TRP VAL VAL GLU ALA ASP          
SEQRES   4 B  140  GLU LYS GLY PHE ALA GLN GLU VAL ALA GLY ALA PRO LEU          
SEQRES   5 B  140  THR LEU VAL ASP PHE PHE ALA PRO TRP CYS GLY PRO CYS          
SEQRES   6 B  140  ARG LEU VAL SER PRO ILE LEU GLU GLU LEU ALA ARG ASP          
SEQRES   7 B  140  HIS ALA GLY ARG LEU LYS VAL VAL LYS VAL ASN VAL ASP          
SEQRES   8 B  140  GLU HIS PRO GLY LEU ALA ALA ARG TYR GLY VAL ARG SER          
SEQRES   9 B  140  VAL PRO THR LEU VAL LEU PHE ARG ARG GLY ALA PRO VAL          
SEQRES  10 B  140  ALA THR TRP VAL GLY ALA SER PRO ARG ARG VAL LEU GLU          
SEQRES  11 B  140  GLU ARG LEU ARG PRO TYR LEU GLU GLY ARG                      
HET     MG    501       1                                                       
HET     MG    502       1                                                       
HET    SO4    601       5                                                       
HET    SO4    602       5                                                       
HET    SO4    603       5                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     SO4 SULFATE ION                                                      
FORMUL   3   MG    2(MG 2+)                                                     
FORMUL   5  SO4    3(O4 S 2-)                                                   
FORMUL   8  HOH   *197(H2 O)                                                    
CRYST1   40.910   95.441   56.683  90.00  91.41  90.00 C 1 2 1       8          
ATOM      1  N   GLY A  49      41.285 108.209 -19.811  1.00 51.98           N  
ATOM      2  CA  GLY A  49      40.100 107.319 -19.606  1.00 49.00           C  
ATOM      3  C   GLY A  49      38.883 107.851 -20.333  1.00 44.38           C  
ATOM      4  O   GLY A  49      38.738 109.060 -20.487  1.00 44.92           O  
ATOM      5  N   ALA A  50      38.011 106.969 -20.804  1.00 38.47           N  
ATOM      6  CA  ALA A  50      36.831 107.451 -21.504  1.00 35.97           C  
ATOM      7  C   ALA A  50      35.935 108.147 -20.476  1.00 39.81           C  
ATOM      8  O   ALA A  50      35.832 107.709 -19.329  1.00 30.54           O  
ATOM      9  CB  ALA A  50      36.096 106.292 -22.175  1.00 29.70           C  
ATOM     10  N   PRO A  51      35.293 109.262 -20.864  1.00 36.33           N  
ATOM     11  CA  PRO A  51      34.426 109.959 -19.908  1.00 33.44           C  
ATOM     12  C   PRO A  51      33.251 109.095 -19.479  1.00 23.57           C  
ATOM     13  O   PRO A  51      32.742 108.294 -20.258  1.00 29.69           O  
ATOM     14  CB  PRO A  51      33.989 111.209 -20.678  1.00 42.43           C  
ATOM     15  CG  PRO A  51      34.064 110.786 -22.109  1.00 38.97           C  
ATOM     16  CD  PRO A  51      35.331 109.969 -22.155  1.00 32.05           C  
ATOM     17  N   LEU A  52      32.834 109.247 -18.230  1.00 23.24           N  
ATOM     18  CA  LEU A  52      31.713 108.476 -17.714  1.00 24.42           C  
ATOM     19  C   LEU A  52      30.625 109.446 -17.285  1.00 20.52           C  
ATOM     20  O   LEU A  52      30.919 110.524 -16.771  1.00 21.17           O  
ATOM     21  CB  LEU A  52      32.152 107.649 -16.503  1.00 19.33           C  
ATOM     22  CG  LEU A  52      33.268 106.615 -16.696  1.00 21.28           C  
ATOM     23  CD1 LEU A  52      33.695 106.088 -15.337  1.00 19.80           C  
ATOM     24  CD2 LEU A  52      32.776 105.485 -17.583  1.00 21.02           C  
ATOM     25  N   THR A  53      29.372 109.080 -17.520  1.00 20.43           N  
ATOM     26  CA  THR A  53      28.254 109.915 -17.100  1.00 17.27           C  
ATOM     27  C   THR A  53      27.281 109.009 -16.359  1.00 18.46           C  
ATOM     28  O   THR A  53      26.839 107.998 -16.904  1.00 14.75           O  
ATOM     29  CB  THR A  53      27.493 110.551 -18.292  1.00 22.45           C  
ATOM     30  OG1 THR A  53      28.386 111.364 -19.065  1.00 22.89           O  
ATOM     31  CG2 THR A  53      26.336 111.425 -17.776  1.00 16.41           C  
ATOM     32  N   LEU A  54      26.982 109.359 -15.111  1.00 15.34           N  
ATOM     33  CA  LEU A  54      26.039 108.603 -14.306  1.00 17.76           C  
ATOM     34  C   LEU A  54      24.718 109.356 -14.357  1.00 15.56           C  
ATOM     35  O   LEU A  54      24.660 110.533 -13.999  1.00 17.61           O  
ATOM     36  CB  LEU A  54      26.498 108.509 -12.846  1.00 18.56           C  
ATOM     37  CG  LEU A  54      25.611 107.612 -11.966  1.00 29.24           C  
ATOM     38  CD1 LEU A  54      25.741 106.169 -12.446  1.00 16.06           C  
ATOM     39  CD2 LEU A  54      26.015 107.738 -10.507  1.00 31.08           C  
ATOM     40  N   VAL A  55      23.660 108.694 -14.815  1.00 14.00           N  
ATOM     41  CA  VAL A  55      22.363 109.341 -14.884  1.00 13.30           C  
ATOM     42  C   VAL A  55      21.495 108.826 -13.743  1.00 14.49           C  
ATOM     43  O   VAL A  55      21.317 107.621 -13.554  1.00 14.53           O  
ATOM     44  CB  VAL A  55      21.689 109.107 -16.258  1.00 15.58           C  
ATOM     45  CG1 VAL A  55      20.329 109.805 -16.318  1.00 17.91           C  
ATOM     46  CG2 VAL A  55      22.595 109.640 -17.372  1.00 15.91           C  
ATOM     47  N   ASP A  56      20.980 109.767 -12.968  1.00 12.08           N  
ATOM     48  CA  ASP A  56      20.157 109.460 -11.812  1.00 17.74           C  
ATOM     49  C   ASP A  56      18.696 109.707 -12.159  1.00 17.64           C  
ATOM     50  O   ASP A  56      18.244 110.848 -12.222  1.00 13.89           O  
ATOM     51  CB  ASP A  56      20.659 110.327 -10.640  1.00 17.56           C  
ATOM     52  CG  ASP A  56      19.706 110.369  -9.443  1.00 22.95           C  
ATOM     53  OD1 ASP A  56      18.925 109.425  -9.232  1.00 22.29           O  
ATOM     54  OD2 ASP A  56      19.769 111.371  -8.698  1.00 27.56           O  
ATOM     55  N   PHE A  57      17.982 108.620 -12.440  1.00 15.89           N  
ATOM     56  CA  PHE A  57      16.559 108.681 -12.762  1.00 18.35           C  
ATOM     57  C   PHE A  57      15.843 108.696 -11.410  1.00 20.47           C  
ATOM     58  O   PHE A  57      15.954 107.747 -10.626  1.00 19.49           O  
ATOM     59  CB  PHE A  57      16.148 107.452 -13.590  1.00 17.37           C  
ATOM     60  CG  PHE A  57      16.688 107.468 -15.003  1.00 16.98           C  
ATOM     61  CD1 PHE A  57      16.004 108.127 -16.022  1.00 17.56           C  
ATOM     62  CD2 PHE A  57      17.879 106.817 -15.315  1.00 15.07           C  
ATOM     63  CE1 PHE A  57      16.514 108.154 -17.322  1.00 20.65           C  
ATOM     64  CE2 PHE A  57      18.393 106.841 -16.609  1.00 19.76           C  
ATOM     65  CZ  PHE A  57      17.705 107.500 -17.620  1.00 14.96           C  
ATOM     66  N   PHE A  58      15.118 109.780 -11.143  1.00 17.88           N  
ATOM     67  CA  PHE A  58      14.422 109.967  -9.869  1.00 14.34           C  
ATOM     68  C   PHE A  58      13.022 110.542 -10.062  1.00 19.23           C  
ATOM     69  O   PHE A  58      12.631 110.875 -11.172  1.00 16.22           O  
ATOM     70  CB  PHE A  58      15.215 110.961  -8.995  1.00 17.73           C  
ATOM     71  CG  PHE A  58      15.081 112.424  -9.432  1.00 16.75           C  
ATOM     72  CD1 PHE A  58      15.790 112.924 -10.528  1.00 15.36           C  
ATOM     73  CD2 PHE A  58      14.206 113.284  -8.768  1.00 17.44           C  
ATOM     74  CE1 PHE A  58      15.619 114.258 -10.957  1.00 15.59           C  
ATOM     75  CE2 PHE A  58      14.030 114.610  -9.190  1.00 20.75           C  
ATOM     76  CZ  PHE A  58      14.735 115.099 -10.282  1.00 18.67           C  
ATOM     77  N   ALA A  59      12.260 110.648  -8.980  1.00 17.19           N  
ATOM     78  CA  ALA A  59      10.952 111.293  -9.061  1.00 14.48           C  
ATOM     79  C   ALA A  59      10.853 112.149  -7.805  1.00 17.07           C  
ATOM     80  O   ALA A  59      11.422 111.800  -6.766  1.00 15.59           O  
ATOM     81  CB  ALA A  59       9.816 110.263  -9.123  1.00 21.31           C  
ATOM     82  N   PRO A  60      10.166 113.299  -7.891  1.00 21.43           N  
ATOM     83  CA  PRO A  60      10.037 114.166  -6.710  1.00 25.08           C  
ATOM     84  C   PRO A  60       9.282 113.550  -5.538  1.00 26.60           C  
ATOM     85  O   PRO A  60       9.381 114.026  -4.417  1.00 28.30           O  
ATOM     86  CB  PRO A  60       9.296 115.396  -7.244  1.00 30.55           C  
ATOM     87  CG  PRO A  60       9.523 115.366  -8.711  1.00 29.97           C  
ATOM     88  CD  PRO A  60       9.539 113.913  -9.075  1.00 20.20           C  
ATOM     89  N   TRP A  61       8.522 112.501  -5.805  1.00 26.21           N  
ATOM     90  CA  TRP A  61       7.739 111.860  -4.765  1.00 27.85           C  
ATOM     91  C   TRP A  61       8.418 110.617  -4.218  1.00 30.04           C  
ATOM     92  O   TRP A  61       7.795 109.818  -3.527  1.00 26.19           O  
ATOM     93  CB  TRP A  61       6.350 111.507  -5.314  1.00 28.03           C  
ATOM     94  CG  TRP A  61       6.386 110.928  -6.692  1.00 33.67           C  
ATOM     95  CD1 TRP A  61       6.005 111.553  -7.841  1.00 27.34           C  
ATOM     96  CD2 TRP A  61       6.849 109.634  -7.076  1.00 28.11           C  
ATOM     97  NE1 TRP A  61       6.199 110.732  -8.923  1.00 29.74           N  
ATOM     98  CE2 TRP A  61       6.717 109.552  -8.483  1.00 34.46           C  
ATOM     99  CE3 TRP A  61       7.365 108.542  -6.374  1.00 40.24           C  
ATOM    100  CZ2 TRP A  61       7.090 108.403  -9.199  1.00 36.27           C  
ATOM    101  CZ3 TRP A  61       7.732 107.408  -7.091  1.00 39.31           C  
ATOM    102  CH2 TRP A  61       7.593 107.349  -8.489  1.00 35.96           C  
ATOM    103  N   CYS A  62       9.700 110.462  -4.526  1.00 24.48           N  
ATOM    104  CA  CYS A  62      10.453 109.295  -4.090  1.00 24.20           C  
ATOM    105  C   CYS A  62      11.355 109.563  -2.876  1.00 20.74           C  
ATOM    106  O   CYS A  62      12.263 110.392  -2.938  1.00 21.52           O  
ATOM    107  CB  CYS A  62      11.286 108.791  -5.264  1.00 24.47           C  
ATOM    108  SG  CYS A  62      12.393 107.464  -4.843  1.00 29.62           S  
ATOM    109  N   GLY A  63      11.111 108.861  -1.771  1.00 25.96           N  
ATOM    110  CA  GLY A  63      11.908 109.070  -0.567  1.00 21.95           C  
ATOM    111  C   GLY A  63      13.371 108.688  -0.698  1.00 28.24           C  
ATOM    112  O   GLY A  63      14.263 109.501  -0.451  1.00 27.08           O  
ATOM    113  N   PRO A  64      13.646 107.434  -1.068  1.00 25.70           N  
ATOM    114  CA  PRO A  64      15.019 106.958  -1.229  1.00 33.39           C  
ATOM    115  C   PRO A  64      15.822 107.855  -2.171  1.00 33.32           C  
ATOM    116  O   PRO A  64      17.016 108.065  -1.956  1.00 34.17           O  
ATOM    117  CB  PRO A  64      14.823 105.549  -1.774  1.00 30.29           C  
ATOM    118  CG  PRO A  64      13.559 105.113  -1.087  1.00 33.18           C  
ATOM    119  CD  PRO A  64      12.680 106.331  -1.219  1.00 24.98           C  
ATOM    120  N   CYS A  65      15.173 108.396  -3.201  1.00 23.39           N  
ATOM    121  CA  CYS A  65      15.884 109.266  -4.137  1.00 25.96           C  
ATOM    122  C   CYS A  65      16.477 110.453  -3.401  1.00 32.55           C  
ATOM    123  O   CYS A  65      17.518 110.977  -3.794  1.00 26.04           O  
ATOM    124  CB  CYS A  65      14.957 109.799  -5.228  1.00 24.34           C  
ATOM    125  SG  CYS A  65      14.304 108.588  -6.372  1.00 26.80           S  
ATOM    126  N   ARG A  66      15.804 110.890  -2.341  1.00 35.01           N  
ATOM    127  CA  ARG A  66      16.282 112.028  -1.565  1.00 33.58           C  
ATOM    128  C   ARG A  66      17.623 111.715  -0.911  1.00 32.28           C  
ATOM    129  O   ARG A  66      18.467 112.600  -0.763  1.00 37.56           O  
ATOM    130  CB  ARG A  66      15.252 112.411  -0.495  1.00 36.48           C  
ATOM    131  CG  ARG A  66      13.947 112.989  -1.034  1.00 39.42           C  
ATOM    132  CD  ARG A  66      12.865 112.969   0.034  1.00 45.05           C  
ATOM    133  NE  ARG A  66      13.355 113.471   1.315  1.00 37.61           N  
ATOM    134  CZ  ARG A  66      13.543 114.754   1.603  1.00 43.01           C  
ATOM    135  NH1 ARG A  66      13.279 115.688   0.700  1.00 46.55           N  
ATOM    136  NH2 ARG A  66      13.998 115.105   2.798  1.00 46.54           N  
ATOM    137  N   LEU A  67      17.801 110.455  -0.515  1.00 37.73           N  
ATOM    138  CA  LEU A  67      19.040 109.973   0.117  1.00 39.75           C  
ATOM    139  C   LEU A  67      20.168 109.959  -0.890  1.00 35.44           C  
ATOM    140  O   LEU A  67      21.249 110.501  -0.674  1.00 32.24           O  
ATOM    141  CB  LEU A  67      18.923 108.512   0.565  1.00 46.67           C  
ATOM    142  CG  LEU A  67      18.235 107.882   1.772  1.00 53.61           C  
ATOM    143  CD1 LEU A  67      18.493 106.369   1.730  1.00 52.48           C  
ATOM    144  CD2 LEU A  67      18.785 108.466   3.054  1.00 49.60           C  
ATOM    145  N   VAL A  68      19.895 109.272  -1.990  1.00 25.91           N  
ATOM    146  CA  VAL A  68      20.865 109.078  -3.042  1.00 28.72           C  
ATOM    147  C   VAL A  68      21.364 110.296  -3.787  1.00 28.28           C  
ATOM    148  O   VAL A  68      22.562 110.419  -4.033  1.00 26.74           O  
ATOM    149  CB  VAL A  68      20.325 108.067  -4.069  1.00 27.75           C  
ATOM    150  CG1 VAL A  68      21.336 107.852  -5.182  1.00 38.50           C  
ATOM    151  CG2 VAL A  68      20.021 106.761  -3.373  1.00 34.98           C  
ATOM    152  N   SER A  69      20.477 111.209  -4.140  1.00 26.85           N  
ATOM    153  CA  SER A  69      20.929 112.342  -4.919  1.00 33.19           C  
ATOM    154  C   SER A  69      22.133 113.131  -4.362  1.00 32.25           C  
ATOM    155  O   SER A  69      23.080 113.388  -5.103  1.00 32.48           O  
ATOM    156  CB  SER A  69      19.719 113.206  -5.272  1.00 40.84           C  
ATOM    157  OG  SER A  69      18.855 112.430  -6.115  1.00 40.72           O  
ATOM    158  N   PRO A  70      22.138 113.495  -3.064  1.00 26.01           N  
ATOM    159  CA  PRO A  70      23.298 114.234  -2.536  1.00 33.95           C  
ATOM    160  C   PRO A  70      24.565 113.356  -2.486  1.00 29.67           C  
ATOM    161  O   PRO A  70      25.686 113.856  -2.581  1.00 30.51           O  
ATOM    162  CB  PRO A  70      22.827 114.691  -1.151  1.00 37.74           C  
ATOM    163  CG  PRO A  70      21.781 113.677  -0.790  1.00 40.70           C  
ATOM    164  CD  PRO A  70      21.044 113.472  -2.081  1.00 32.14           C  
ATOM    165  N   ILE A  71      24.386 112.046  -2.343  1.00 24.50           N  
ATOM    166  CA  ILE A  71      25.533 111.155  -2.336  1.00 22.20           C  
ATOM    167  C   ILE A  71      26.144 111.180  -3.739  1.00 30.99           C  
ATOM    168  O   ILE A  71      27.360 111.278  -3.891  1.00 23.75           O  
ATOM    169  CB  ILE A  71      25.126 109.710  -1.943  1.00 24.85           C  
ATOM    170  CG1 ILE A  71      24.823 109.670  -0.437  1.00 32.43           C  
ATOM    171  CG2 ILE A  71      26.221 108.725  -2.352  1.00 27.84           C  
ATOM    172  CD1 ILE A  71      24.209 108.375   0.066  1.00 32.33           C  
ATOM    173  N   LEU A  72      25.299 111.122  -4.764  1.00 29.38           N  
ATOM    174  CA  LEU A  72      25.779 111.150  -6.143  1.00 32.01           C  
ATOM    175  C   LEU A  72      26.498 112.454  -6.477  1.00 36.40           C  
ATOM    176  O   LEU A  72      27.514 112.443  -7.169  1.00 31.90           O  
ATOM    177  CB  LEU A  72      24.616 110.949  -7.116  1.00 33.04           C  
ATOM    178  CG  LEU A  72      23.895 109.612  -6.938  1.00 37.40           C  
ATOM    179  CD1 LEU A  72      22.742 109.504  -7.918  1.00 38.40           C  
ATOM    180  CD2 LEU A  72      24.884 108.479  -7.146  1.00 38.75           C  
ATOM    181  N   GLU A  73      25.977 113.576  -5.988  1.00 33.96           N  
ATOM    182  CA  GLU A  73      26.606 114.860  -6.269  1.00 40.02           C  
ATOM    183  C   GLU A  73      27.946 114.967  -5.552  1.00 36.13           C  
ATOM    184  O   GLU A  73      28.867 115.610  -6.045  1.00 37.81           O  
ATOM    185  CB  GLU A  73      25.700 116.015  -5.849  1.00 41.96           C  
ATOM    186  CG  GLU A  73      25.580 116.198  -4.352  1.00 59.69           C  
ATOM    187  CD  GLU A  73      24.765 117.417  -3.996  1.00 69.18           C  
ATOM    188  OE1 GLU A  73      23.585 117.479  -4.400  1.00 69.42           O  
ATOM    189  OE2 GLU A  73      25.302 118.317  -3.318  1.00 77.03           O  
ATOM    190  N   GLU A  74      28.051 114.349  -4.384  1.00 30.61           N  
ATOM    191  CA  GLU A  74      29.301 114.367  -3.648  1.00 29.29           C  
ATOM    192  C   GLU A  74      30.310 113.547  -4.458  1.00 33.91           C  
ATOM    193  O   GLU A  74      31.462 113.936  -4.599  1.00 28.70           O  
ATOM    194  CB  GLU A  74      29.094 113.762  -2.258  1.00 36.39           C  
ATOM    195  CG  GLU A  74      30.337 113.717  -1.391  1.00 49.36           C  
ATOM    196  CD  GLU A  74      30.104 112.935  -0.106  1.00 64.92           C  
ATOM    197  OE1 GLU A  74      29.058 112.257  -0.022  1.00 71.63           O  
ATOM    198  OE2 GLU A  74      30.963 112.994   0.803  1.00 68.63           O  
ATOM    199  N   LEU A  75      29.864 112.415  -4.989  1.00 28.24           N  
ATOM    200  CA  LEU A  75      30.709 111.541  -5.801  1.00 32.03           C  
ATOM    201  C   LEU A  75      31.268 112.244  -7.035  1.00 29.22           C  
ATOM    202  O   LEU A  75      32.438 112.086  -7.374  1.00 30.77           O  
ATOM    203  CB  LEU A  75      29.912 110.324  -6.281  1.00 38.38           C  
ATOM    204  CG  LEU A  75      29.786 109.110  -5.365  1.00 45.31           C  
ATOM    205  CD1 LEU A  75      28.668 108.194  -5.857  1.00 47.47           C  
ATOM    206  CD2 LEU A  75      31.110 108.371  -5.343  1.00 52.12           C  
ATOM    207  N   ALA A  76      30.421 113.021  -7.700  1.00 26.99           N  
ATOM    208  CA  ALA A  76      30.798 113.730  -8.921  1.00 35.54           C  
ATOM    209  C   ALA A  76      31.835 114.786  -8.623  1.00 37.62           C  
ATOM    210  O   ALA A  76      32.749 115.056  -9.409  1.00 39.05           O  
ATOM    211  CB  ALA A  76      29.573 114.389  -9.516  1.00 30.62           C  
ATOM    212  N   ARG A  77      31.650 115.406  -7.477  1.00 30.89           N  
ATOM    213  CA  ARG A  77      32.514 116.461  -7.000  1.00 30.17           C  
ATOM    214  C   ARG A  77      33.873 115.831  -6.657  1.00 33.07           C  
ATOM    215  O   ARG A  77      34.935 116.362  -7.004  1.00 30.97           O  
ATOM    216  CB  ARG A  77      31.761 117.060  -5.804  1.00 37.39           C  
ATOM    217  CG  ARG A  77      32.389 118.198  -4.974  1.00 49.76           C  
ATOM    218  CD  ARG A  77      31.302 118.767  -4.079  1.00 54.74           C  
ATOM    219  NE  ARG A  77      30.258 119.084  -5.039  1.00 69.03           N  
ATOM    220  CZ  ARG A  77      28.937 118.970  -4.954  1.00 72.77           C  
ATOM    221  NH1 ARG A  77      28.334 118.505  -3.888  1.00 73.78           N  
ATOM    222  NH2 ARG A  77      28.243 119.404  -5.986  1.00 74.00           N  
ATOM    223  N   ASP A  78      33.813 114.666  -6.026  1.00 30.14           N  
ATOM    224  CA  ASP A  78      35.000 113.945  -5.598  1.00 34.96           C  
ATOM    225  C   ASP A  78      35.759 113.227  -6.728  1.00 36.56           C  
ATOM    226  O   ASP A  78      36.896 112.809  -6.535  1.00 34.34           O  
ATOM    227  CB  ASP A  78      34.592 112.950  -4.511  1.00 40.66           C  
ATOM    228  CG  ASP A  78      35.745 112.537  -3.631  1.00 55.46           C  
ATOM    229  OD1 ASP A  78      36.454 113.422  -3.113  1.00 60.05           O  
ATOM    230  OD2 ASP A  78      35.945 111.320  -3.454  1.00 58.70           O  
ATOM    231  N   HIS A  79      35.147 113.092  -7.902  1.00 29.89           N  
ATOM    232  CA  HIS A  79      35.795 112.426  -9.036  1.00 32.86           C  
ATOM    233  C   HIS A  79      35.506 113.245 -10.281  1.00 37.37           C  
ATOM    234  O   HIS A  79      35.324 112.707 -11.378  1.00 32.15           O  
ATOM    235  CB  HIS A  79      35.244 111.009  -9.208  1.00 31.71           C  
ATOM    236  CG  HIS A  79      35.541 110.108  -8.052  1.00 31.35           C  
ATOM    237  ND1 HIS A  79      36.773 109.521  -7.864  1.00 35.20           N  
ATOM    238  CD2 HIS A  79      34.776 109.728  -7.002  1.00 32.40           C  
ATOM    239  CE1 HIS A  79      36.755 108.816  -6.745  1.00 42.12           C  
ATOM    240  NE2 HIS A  79      35.557 108.926  -6.203  1.00 38.86           N  
ATOM    241  N   ALA A  80      35.472 114.559 -10.085  1.00 38.05           N  
ATOM    242  CA  ALA A  80      35.173 115.522 -11.135  1.00 36.55           C  
ATOM    243  C   ALA A  80      35.885 115.325 -12.468  1.00 40.48           C  
ATOM    244  O   ALA A  80      35.306 115.588 -13.518  1.00 36.01           O  
ATOM    245  CB  ALA A  80      35.421 116.944 -10.612  1.00 38.68           C  
ATOM    246  N   GLY A  81      37.130 114.866 -12.444  1.00 41.84           N  
ATOM    247  CA  GLY A  81      37.842 114.685 -13.696  1.00 41.91           C  
ATOM    248  C   GLY A  81      37.317 113.559 -14.568  1.00 45.64           C  
ATOM    249  O   GLY A  81      37.338 113.655 -15.795  1.00 46.96           O  
ATOM    250  N   ARG A  82      36.821 112.500 -13.936  1.00 41.95           N  
ATOM    251  CA  ARG A  82      36.336 111.326 -14.659  1.00 37.29           C  
ATOM    252  C   ARG A  82      34.838 111.112 -14.725  1.00 35.04           C  
ATOM    253  O   ARG A  82      34.340 110.436 -15.632  1.00 32.87           O  
ATOM    254  CB  ARG A  82      36.930 110.069 -14.030  1.00 45.75           C  
ATOM    255  CG  ARG A  82      38.414 109.925 -14.180  1.00 53.70           C  
ATOM    256  CD  ARG A  82      38.755 109.391 -15.554  1.00 53.74           C  
ATOM    257  NE  ARG A  82      38.766 107.930 -15.646  1.00 56.33           N  
ATOM    258  CZ  ARG A  82      37.939 107.226 -16.411  1.00 53.15           C  
ATOM    259  NH1 ARG A  82      37.026 107.853 -17.138  1.00 46.12           N  
ATOM    260  NH2 ARG A  82      38.033 105.904 -16.463  1.00 46.09           N  
ATOM    261  N   LEU A  83      34.118 111.682 -13.769  1.00 28.84           N  
ATOM    262  CA  LEU A  83      32.684 111.445 -13.686  1.00 28.68           C  
ATOM    263  C   LEU A  83      31.721 112.626 -13.651  1.00 23.14           C  
ATOM    264  O   LEU A  83      31.861 113.511 -12.817  1.00 29.67           O  
ATOM    265  CB  LEU A  83      32.443 110.591 -12.451  1.00 21.76           C  
ATOM    266  CG  LEU A  83      31.016 110.126 -12.200  1.00 20.67           C  
ATOM    267  CD1 LEU A  83      30.617 109.078 -13.226  1.00 23.62           C  
ATOM    268  CD2 LEU A  83      30.950 109.568 -10.796  1.00 26.20           C  
ATOM    269  N   LYS A  84      30.724 112.596 -14.532  1.00 24.07           N  
ATOM    270  CA  LYS A  84      29.684 113.625 -14.618  1.00 27.75           C  
ATOM    271  C   LYS A  84      28.382 112.957 -14.150  1.00 25.24           C  
ATOM    272  O   LYS A  84      28.139 111.807 -14.498  1.00 21.59           O  
ATOM    273  CB  LYS A  84      29.509 114.089 -16.072  1.00 27.97           C  
ATOM    274  CG  LYS A  84      28.386 115.094 -16.315  1.00 36.80           C  
ATOM    275  CD  LYS A  84      28.277 115.358 -17.810  1.00 35.38           C  
ATOM    276  CE  LYS A  84      26.952 115.961 -18.241  1.00 42.25           C  
ATOM    277  NZ  LYS A  84      26.886 117.428 -18.029  1.00 49.03           N  
ATOM    278  N   VAL A  85      27.589 113.646 -13.331  1.00 16.69           N  
ATOM    279  CA  VAL A  85      26.317 113.104 -12.857  1.00 16.90           C  
ATOM    280  C   VAL A  85      25.194 113.997 -13.391  1.00 20.66           C  
ATOM    281  O   VAL A  85      25.291 115.229 -13.329  1.00 20.75           O  
ATOM    282  CB  VAL A  85      26.229 113.076 -11.292  1.00 21.64           C  
ATOM    283  CG1 VAL A  85      24.796 112.806 -10.837  1.00 28.43           C  
ATOM    284  CG2 VAL A  85      27.140 111.983 -10.740  1.00 27.19           C  
ATOM    285  N   VAL A  86      24.154 113.387 -13.962  1.00 14.98           N  
ATOM    286  CA  VAL A  86      23.010 114.146 -14.480  1.00 15.16           C  
ATOM    287  C   VAL A  86      21.738 113.564 -13.881  1.00 18.18           C  
ATOM    288  O   VAL A  86      21.555 112.345 -13.885  1.00 18.67           O  
ATOM    289  CB  VAL A  86      22.850 114.023 -16.013  1.00 16.30           C  
ATOM    290  CG1 VAL A  86      21.640 114.845 -16.459  1.00 21.85           C  
ATOM    291  CG2 VAL A  86      24.107 114.483 -16.730  1.00 20.61           C  
ATOM    292  N   LYS A  87      20.856 114.418 -13.375  1.00 16.14           N  
ATOM    293  CA  LYS A  87      19.597 113.941 -12.805  1.00 13.26           C  
ATOM    294  C   LYS A  87      18.479 114.070 -13.834  1.00 22.15           C  
ATOM    295  O   LYS A  87      18.347 115.100 -14.498  1.00 20.84           O  
ATOM    296  CB  LYS A  87      19.240 114.749 -11.541  1.00 15.16           C  
ATOM    297  CG  LYS A  87      20.191 114.555 -10.357  1.00 21.83           C  
ATOM    298  CD  LYS A  87      19.731 115.332  -9.111  1.00 32.13           C  
ATOM    299  CE  LYS A  87      18.428 114.777  -8.531  1.00 40.41           C  
ATOM    300  NZ  LYS A  87      17.744 115.725  -7.602  1.00 46.43           N  
ATOM    301  N   VAL A  88      17.691 113.013 -13.982  1.00 16.69           N  
ATOM    302  CA  VAL A  88      16.572 113.031 -14.912  1.00 19.22           C  
ATOM    303  C   VAL A  88      15.316 112.711 -14.125  1.00 17.84           C  
ATOM    304  O   VAL A  88      15.203 111.636 -13.531  1.00 14.68           O  
ATOM    305  CB  VAL A  88      16.730 111.980 -16.046  1.00 18.05           C  
ATOM    306  CG1 VAL A  88      15.460 111.931 -16.911  1.00 21.19           C  
ATOM    307  CG2 VAL A  88      17.936 112.332 -16.908  1.00 15.48           C  
ATOM    308  N   ASN A  89      14.395 113.667 -14.098  1.00 15.80           N  
ATOM    309  CA  ASN A  89      13.116 113.526 -13.401  1.00 13.55           C  
ATOM    310  C   ASN A  89      12.258 112.654 -14.321  1.00 14.32           C  
ATOM    311  O   ASN A  89      11.888 113.088 -15.413  1.00 16.99           O  
ATOM    312  CB  ASN A  89      12.493 114.925 -13.235  1.00 15.73           C  
ATOM    313  CG  ASN A  89      11.177 114.903 -12.483  1.00 18.82           C  
ATOM    314  OD1 ASN A  89      10.389 113.970 -12.628  1.00 18.04           O  
ATOM    315  ND2 ASN A  89      10.925 115.937 -11.688  1.00 15.73           N  
ATOM    316  N   VAL A  90      11.946 111.430 -13.904  1.00 16.62           N  
ATOM    317  CA  VAL A  90      11.160 110.548 -14.770  1.00 18.38           C  
ATOM    318  C   VAL A  90       9.740 111.044 -15.087  1.00 22.49           C  
ATOM    319  O   VAL A  90       9.143 110.595 -16.061  1.00 20.36           O  
ATOM    320  CB  VAL A  90      11.050 109.093 -14.215  1.00 17.55           C  
ATOM    321  CG1 VAL A  90      12.450 108.504 -13.952  1.00 16.81           C  
ATOM    322  CG2 VAL A  90      10.181 109.068 -12.981  1.00 21.16           C  
ATOM    323  N   ASP A  91       9.190 111.954 -14.283  1.00 19.54           N  
ATOM    324  CA  ASP A  91       7.850 112.471 -14.571  1.00 25.25           C  
ATOM    325  C   ASP A  91       7.965 113.621 -15.567  1.00 24.65           C  
ATOM    326  O   ASP A  91       6.995 113.969 -16.241  1.00 26.63           O  
ATOM    327  CB  ASP A  91       7.139 112.947 -13.293  1.00 28.72           C  
ATOM    328  CG  ASP A  91       6.597 111.796 -12.456  1.00 39.30           C  
ATOM    329  OD1 ASP A  91       6.923 110.629 -12.759  1.00 38.14           O  
ATOM    330  OD2 ASP A  91       5.846 112.054 -11.487  1.00 40.96           O  
ATOM    331  N   GLU A  92       9.157 114.209 -15.661  1.00 18.86           N  
ATOM    332  CA  GLU A  92       9.385 115.304 -16.599  1.00 17.35           C  
ATOM    333  C   GLU A  92       9.729 114.731 -17.974  1.00 27.86           C  
ATOM    334  O   GLU A  92       9.342 115.289 -19.001  1.00 25.56           O  
ATOM    335  CB  GLU A  92      10.525 116.220 -16.120  1.00 17.92           C  
ATOM    336  CG  GLU A  92      10.852 117.363 -17.095  1.00 25.19           C  
ATOM    337  CD  GLU A  92      11.986 118.261 -16.622  1.00 24.76           C  
ATOM    338  OE1 GLU A  92      12.756 117.845 -15.730  1.00 26.28           O  
ATOM    339  OE2 GLU A  92      12.120 119.385 -17.156  1.00 29.60           O  
ATOM    340  N   HIS A  93      10.440 113.604 -17.980  1.00 26.48           N  
ATOM    341  CA  HIS A  93      10.852 112.945 -19.221  1.00 26.81           C  
ATOM    342  C   HIS A  93      10.540 111.444 -19.245  1.00 23.90           C  
ATOM    343  O   HIS A  93      11.457 110.620 -19.260  1.00 24.85           O  
ATOM    344  CB  HIS A  93      12.359 113.136 -19.431  1.00 25.04           C  
ATOM    345  CG  HIS A  93      12.770 114.568 -19.590  1.00 27.10           C  
ATOM    346  ND1 HIS A  93      12.362 115.342 -20.652  1.00 26.02           N  
ATOM    347  CD2 HIS A  93      13.530 115.370 -18.806  1.00 29.38           C  
ATOM    348  CE1 HIS A  93      12.852 116.564 -20.517  1.00 22.17           C  
ATOM    349  NE2 HIS A  93      13.562 116.606 -19.406  1.00 25.13           N  
ATOM    350  N   PRO A  94       9.252 111.061 -19.296  1.00 26.74           N  
ATOM    351  CA  PRO A  94       8.902 109.636 -19.312  1.00 24.27           C  
ATOM    352  C   PRO A  94       9.392 108.846 -20.525  1.00 25.01           C  
ATOM    353  O   PRO A  94       9.650 107.646 -20.424  1.00 25.65           O  
ATOM    354  CB  PRO A  94       7.379 109.651 -19.183  1.00 30.54           C  
ATOM    355  CG  PRO A  94       7.006 110.905 -19.894  1.00 26.58           C  
ATOM    356  CD  PRO A  94       8.059 111.900 -19.477  1.00 28.17           C  
ATOM    357  N   GLY A  95       9.534 109.515 -21.664  1.00 22.83           N  
ATOM    358  CA  GLY A  95      10.013 108.835 -22.854  1.00 27.25           C  
ATOM    359  C   GLY A  95      11.456 108.410 -22.673  1.00 25.28           C  
ATOM    360  O   GLY A  95      11.855 107.313 -23.069  1.00 26.80           O  
ATOM    361  N   LEU A  96      12.242 109.289 -22.064  1.00 21.24           N  
ATOM    362  CA  LEU A  96      13.645 109.013 -21.811  1.00 25.09           C  
ATOM    363  C   LEU A  96      13.733 107.852 -20.817  1.00 25.15           C  
ATOM    364  O   LEU A  96      14.487 106.904 -21.029  1.00 20.42           O  
ATOM    365  CB  LEU A  96      14.323 110.276 -21.262  1.00 22.45           C  
ATOM    366  CG  LEU A  96      15.849 110.382 -21.188  1.00 30.23           C  
ATOM    367  CD1 LEU A  96      16.469 110.096 -22.552  1.00 28.30           C  
ATOM    368  CD2 LEU A  96      16.229 111.781 -20.704  1.00 32.37           C  
ATOM    369  N   ALA A  97      12.949 107.920 -19.743  1.00 17.38           N  
ATOM    370  CA  ALA A  97      12.947 106.851 -18.745  1.00 16.92           C  
ATOM    371  C   ALA A  97      12.619 105.520 -19.418  1.00 23.09           C  
ATOM    372  O   ALA A  97      13.263 104.502 -19.153  1.00 21.64           O  
ATOM    373  CB  ALA A  97      11.924 107.152 -17.637  1.00 20.74           C  
ATOM    374  N   ALA A  98      11.625 105.525 -20.301  1.00 24.35           N  
ATOM    375  CA  ALA A  98      11.245 104.300 -21.002  1.00 25.88           C  
ATOM    376  C   ALA A  98      12.355 103.825 -21.948  1.00 24.12           C  
ATOM    377  O   ALA A  98      12.643 102.631 -22.008  1.00 23.88           O  
ATOM    378  CB  ALA A  98       9.938 104.516 -21.769  1.00 23.59           C  
ATOM    379  N   ARG A  99      12.984 104.752 -22.671  1.00 17.60           N  
ATOM    380  CA  ARG A  99      14.071 104.396 -23.583  1.00 19.74           C  
ATOM    381  C   ARG A  99      15.155 103.578 -22.878  1.00 29.78           C  
ATOM    382  O   ARG A  99      15.727 102.662 -23.461  1.00 25.43           O  
ATOM    383  CB  ARG A  99      14.686 105.664 -24.191  1.00 21.24           C  
ATOM    384  CG  ARG A  99      16.017 105.435 -24.891  1.00 26.04           C  
ATOM    385  CD  ARG A  99      15.932 104.419 -26.015  1.00 37.46           C  
ATOM    386  NE  ARG A  99      17.243 104.262 -26.635  1.00 39.59           N  
ATOM    387  CZ  ARG A  99      18.207 103.475 -26.170  1.00 38.51           C  
ATOM    388  NH1 ARG A  99      18.013 102.750 -25.074  1.00 33.74           N  
ATOM    389  NH2 ARG A  99      19.373 103.421 -26.797  1.00 38.69           N  
ATOM    390  N   TYR A 100      15.435 103.911 -21.622  1.00 18.93           N  
ATOM    391  CA  TYR A 100      16.449 103.193 -20.872  1.00 24.16           C  
ATOM    392  C   TYR A 100      15.923 102.188 -19.855  1.00 27.37           C  
ATOM    393  O   TYR A 100      16.629 101.832 -18.906  1.00 22.38           O  
ATOM    394  CB  TYR A 100      17.411 104.193 -20.227  1.00 23.27           C  
ATOM    395  CG  TYR A 100      18.255 104.880 -21.274  1.00 26.61           C  
ATOM    396  CD1 TYR A 100      19.199 104.160 -22.014  1.00 21.43           C  
ATOM    397  CD2 TYR A 100      18.071 106.229 -21.572  1.00 21.51           C  
ATOM    398  CE1 TYR A 100      19.935 104.768 -23.023  1.00 25.49           C  
ATOM    399  CE2 TYR A 100      18.806 106.842 -22.581  1.00 24.43           C  
ATOM    400  CZ  TYR A 100      19.730 106.108 -23.299  1.00 25.68           C  
ATOM    401  OH  TYR A 100      20.453 106.720 -24.290  1.00 23.83           O  
ATOM    402  N   GLY A 101      14.685 101.745 -20.068  1.00 24.43           N  
ATOM    403  CA  GLY A 101      14.061 100.740 -19.225  1.00 27.96           C  
ATOM    404  C   GLY A 101      13.876 101.024 -17.755  1.00 32.46           C  
ATOM    405  O   GLY A 101      13.848 100.102 -16.943  1.00 28.00           O  
ATOM    406  N   VAL A 102      13.748 102.291 -17.398  1.00 26.14           N  
ATOM    407  CA  VAL A 102      13.553 102.648 -16.004  1.00 19.88           C  
ATOM    408  C   VAL A 102      12.105 102.352 -15.602  1.00 26.10           C  
ATOM    409  O   VAL A 102      11.170 102.939 -16.147  1.00 33.40           O  
ATOM    410  CB  VAL A 102      13.878 104.143 -15.785  1.00 19.86           C  
ATOM    411  CG1 VAL A 102      13.575 104.549 -14.348  1.00 18.77           C  
ATOM    412  CG2 VAL A 102      15.346 104.395 -16.118  1.00 24.44           C  
ATOM    413  N   ARG A 103      11.928 101.420 -14.668  1.00 23.06           N  
ATOM    414  CA  ARG A 103      10.597 101.062 -14.192  1.00 27.88           C  
ATOM    415  C   ARG A 103      10.376 101.381 -12.719  1.00 28.74           C  
ATOM    416  O   ARG A 103       9.287 101.176 -12.188  1.00 30.61           O  
ATOM    417  CB  ARG A 103      10.305  99.591 -14.475  1.00 30.19           C  
ATOM    418  CG  ARG A 103      10.196  99.317 -15.956  1.00 29.50           C  
ATOM    419  CD  ARG A 103       9.977  97.855 -16.227  1.00 40.81           C  
ATOM    420  NE  ARG A 103      10.119  97.564 -17.646  1.00 50.65           N  
ATOM    421  CZ  ARG A 103       9.134  97.122 -18.418  1.00 54.60           C  
ATOM    422  NH1 ARG A 103       7.928  96.917 -17.907  1.00 47.27           N  
ATOM    423  NH2 ARG A 103       9.355  96.883 -19.702  1.00 51.15           N  
ATOM    424  N   SER A 104      11.409 101.869 -12.048  1.00 22.67           N  
ATOM    425  CA  SER A 104      11.257 102.280 -10.656  1.00 25.40           C  
ATOM    426  C   SER A 104      12.375 103.248 -10.331  1.00 22.00           C  
ATOM    427  O   SER A 104      13.378 103.312 -11.043  1.00 19.65           O  
ATOM    428  CB  SER A 104      11.291 101.091  -9.700  1.00 26.13           C  
ATOM    429  OG  SER A 104      12.593 100.559  -9.592  1.00 23.13           O  
ATOM    430  N   VAL A 105      12.203 104.017  -9.268  1.00 17.92           N  
ATOM    431  CA  VAL A 105      13.220 104.983  -8.899  1.00 14.24           C  
ATOM    432  C   VAL A 105      13.682 104.782  -7.459  1.00 20.35           C  
ATOM    433  O   VAL A 105      12.924 104.309  -6.614  1.00 23.44           O  
ATOM    434  CB  VAL A 105      12.703 106.429  -9.098  1.00 21.27           C  
ATOM    435  CG1 VAL A 105      12.531 106.716 -10.596  1.00 18.17           C  
ATOM    436  CG2 VAL A 105      11.380 106.625  -8.366  1.00 22.73           C  
ATOM    437  N   PRO A 106      14.951 105.101  -7.170  1.00 20.25           N  
ATOM    438  CA  PRO A 106      15.925 105.631  -8.127  1.00 20.21           C  
ATOM    439  C   PRO A 106      16.574 104.530  -8.954  1.00 19.42           C  
ATOM    440  O   PRO A 106      16.723 103.401  -8.484  1.00 18.13           O  
ATOM    441  CB  PRO A 106      16.940 106.326  -7.227  1.00 21.80           C  
ATOM    442  CG  PRO A 106      16.964 105.425  -6.022  1.00 23.01           C  
ATOM    443  CD  PRO A 106      15.504 105.083  -5.801  1.00 21.72           C  
ATOM    444  N   THR A 107      16.924 104.850 -10.194  1.00 17.02           N  
ATOM    445  CA  THR A 107      17.639 103.901 -11.042  1.00 15.32           C  
ATOM    446  C   THR A 107      18.825 104.714 -11.533  1.00 21.31           C  
ATOM    447  O   THR A 107      18.668 105.845 -12.011  1.00 18.06           O  
ATOM    448  CB  THR A 107      16.810 103.394 -12.242  1.00 17.82           C  
ATOM    449  OG1 THR A 107      15.712 102.598 -11.774  1.00 19.30           O  
ATOM    450  CG2 THR A 107      17.683 102.521 -13.158  1.00 16.71           C  
ATOM    451  N   LEU A 108      20.011 104.144 -11.356  1.00 15.40           N  
ATOM    452  CA  LEU A 108      21.248 104.792 -11.761  1.00 14.67           C  
ATOM    453  C   LEU A 108      21.795 104.061 -12.980  1.00 14.75           C  
ATOM    454  O   LEU A 108      21.958 102.835 -12.965  1.00 14.68           O  
ATOM    455  CB  LEU A 108      22.274 104.739 -10.626  1.00 14.91           C  
ATOM    456  CG  LEU A 108      21.824 105.117  -9.210  1.00 27.98           C  
ATOM    457  CD1 LEU A 108      23.062 105.276  -8.343  1.00 32.29           C  
ATOM    458  CD2 LEU A 108      21.004 106.403  -9.220  1.00 25.69           C  
ATOM    459  N   VAL A 109      22.064 104.816 -14.038  1.00 12.98           N  
ATOM    460  CA  VAL A 109      22.583 104.238 -15.265  1.00 13.59           C  
ATOM    461  C   VAL A 109      23.922 104.893 -15.609  1.00 18.21           C  
ATOM    462  O   VAL A 109      24.013 106.125 -15.720  1.00 13.10           O  
ATOM    463  CB  VAL A 109      21.590 104.446 -16.446  1.00 17.82           C  
ATOM    464  CG1 VAL A 109      22.128 103.775 -17.691  1.00 13.95           C  
ATOM    465  CG2 VAL A 109      20.200 103.884 -16.087  1.00 12.99           C  
ATOM    466  N   LEU A 110      24.959 104.067 -15.759  1.00 14.94           N  
ATOM    467  CA  LEU A 110      26.308 104.532 -16.100  1.00 13.73           C  
ATOM    468  C   LEU A 110      26.531 104.430 -17.609  1.00 12.30           C  
ATOM    469  O   LEU A 110      26.375 103.355 -18.192  1.00 14.08           O  
ATOM    470  CB  LEU A 110      27.367 103.679 -15.371  1.00 12.06           C  
ATOM    471  CG  LEU A 110      28.840 104.054 -15.615  1.00 20.67           C  
ATOM    472  CD1 LEU A 110      29.038 105.487 -15.158  1.00 17.29           C  
ATOM    473  CD2 LEU A 110      29.802 103.116 -14.872  1.00 17.58           C  
ATOM    474  N   PHE A 111      26.898 105.552 -18.226  1.00 13.74           N  
ATOM    475  CA  PHE A 111      27.161 105.612 -19.664  1.00 18.00           C  
ATOM    476  C   PHE A 111      28.641 105.737 -19.964  1.00 19.80           C  
ATOM    477  O   PHE A 111      29.351 106.506 -19.318  1.00 17.92           O  
ATOM    478  CB  PHE A 111      26.503 106.833 -20.319  1.00 15.77           C  
ATOM    479  CG  PHE A 111      25.016 106.767 -20.389  1.00 17.49           C  
ATOM    480  CD1 PHE A 111      24.250 106.907 -19.240  1.00 16.55           C  
ATOM    481  CD2 PHE A 111      24.378 106.555 -21.605  1.00 16.04           C  
ATOM    482  CE1 PHE A 111      22.861 106.834 -19.298  1.00 11.24           C  
ATOM    483  CE2 PHE A 111      22.991 106.480 -21.676  1.00 15.26           C  
ATOM    484  CZ  PHE A 111      22.235 106.620 -20.522  1.00 11.30           C  
ATOM    485  N   ARG A 112      29.097 104.983 -20.956  1.00 14.96           N  
ATOM    486  CA  ARG A 112      30.477 105.060 -21.406  1.00 19.54           C  
ATOM    487  C   ARG A 112      30.318 105.031 -22.919  1.00 15.31           C  
ATOM    488  O   ARG A 112      29.548 104.227 -23.462  1.00 16.93           O  
ATOM    489  CB  ARG A 112      31.311 103.872 -20.909  1.00 22.91           C  
ATOM    490  CG  ARG A 112      32.803 103.998 -21.247  1.00 23.23           C  
ATOM    491  CD  ARG A 112      33.632 102.788 -20.824  1.00 24.95           C  
ATOM    492  NE  ARG A 112      35.007 102.919 -21.299  1.00 32.59           N  
ATOM    493  CZ  ARG A 112      35.416 102.596 -22.520  1.00 32.34           C  
ATOM    494  NH1 ARG A 112      34.563 102.104 -23.413  1.00 34.23           N  
ATOM    495  NH2 ARG A 112      36.686 102.773 -22.847  1.00 39.93           N  
ATOM    496  N   ARG A 113      31.018 105.936 -23.591  1.00 23.70           N  
ATOM    497  CA  ARG A 113      30.936 106.050 -25.039  1.00 23.58           C  
ATOM    498  C   ARG A 113      29.486 106.217 -25.486  1.00 24.23           C  
ATOM    499  O   ARG A 113      29.068 105.645 -26.490  1.00 28.39           O  
ATOM    500  CB  ARG A 113      31.542 104.824 -25.726  1.00 26.47           C  
ATOM    501  CG  ARG A 113      33.017 104.592 -25.438  1.00 36.71           C  
ATOM    502  CD  ARG A 113      33.867 105.829 -25.697  1.00 38.53           C  
ATOM    503  NE  ARG A 113      35.290 105.497 -25.766  1.00 43.93           N  
ATOM    504  CZ  ARG A 113      36.276 106.385 -25.667  1.00 41.01           C  
ATOM    505  NH1 ARG A 113      36.002 107.669 -25.487  1.00 37.08           N  
ATOM    506  NH2 ARG A 113      37.539 105.994 -25.745  1.00 43.55           N  
ATOM    507  N   GLY A 114      28.720 106.989 -24.718  1.00 22.08           N  
ATOM    508  CA  GLY A 114      27.334 107.261 -25.061  1.00 19.26           C  
ATOM    509  C   GLY A 114      26.293 106.166 -24.938  1.00 21.04           C  
ATOM    510  O   GLY A 114      25.161 106.333 -25.408  1.00 22.17           O  
ATOM    511  N   ALA A 115      26.651 105.056 -24.305  1.00 19.49           N  
ATOM    512  CA  ALA A 115      25.713 103.944 -24.149  1.00 16.49           C  
ATOM    513  C   ALA A 115      25.810 103.388 -22.729  1.00 19.77           C  
ATOM    514  O   ALA A 115      26.868 103.447 -22.102  1.00 14.97           O  
ATOM    515  CB  ALA A 115      26.034 102.855 -25.157  1.00 21.93           C  
ATOM    516  N   PRO A 116      24.702 102.852 -22.194  1.00 15.63           N  
ATOM    517  CA  PRO A 116      24.767 102.312 -20.834  1.00 18.90           C  
ATOM    518  C   PRO A 116      25.695 101.109 -20.750  1.00 17.06           C  
ATOM    519  O   PRO A 116      25.708 100.274 -21.655  1.00 17.86           O  
ATOM    520  CB  PRO A 116      23.322 101.890 -20.555  1.00 21.98           C  
ATOM    521  CG  PRO A 116      22.512 102.758 -21.451  1.00 19.44           C  
ATOM    522  CD  PRO A 116      23.328 102.780 -22.719  1.00 22.01           C  
ATOM    523  N   VAL A 117      26.488 101.027 -19.684  1.00 16.01           N  
ATOM    524  CA  VAL A 117      27.329  99.854 -19.486  1.00 16.46           C  
ATOM    525  C   VAL A 117      26.871  99.161 -18.211  1.00 14.70           C  
ATOM    526  O   VAL A 117      27.072  97.962 -18.050  1.00 17.93           O  
ATOM    527  CB  VAL A 117      28.859 100.175 -19.395  1.00 17.25           C  
ATOM    528  CG1 VAL A 117      29.362 100.641 -20.749  1.00 16.55           C  
ATOM    529  CG2 VAL A 117      29.143 101.192 -18.308  1.00 15.47           C  
ATOM    530  N   ALA A 118      26.225  99.904 -17.317  1.00 15.44           N  
ATOM    531  CA  ALA A 118      25.728  99.310 -16.072  1.00 18.28           C  
ATOM    532  C   ALA A 118      24.501 100.064 -15.581  1.00 17.87           C  
ATOM    533  O   ALA A 118      24.383 101.268 -15.809  1.00 13.18           O  
ATOM    534  CB  ALA A 118      26.815  99.342 -15.007  1.00 17.20           C  
ATOM    535  N   THR A 119      23.584  99.356 -14.923  1.00 14.78           N  
ATOM    536  CA  THR A 119      22.377  99.971 -14.373  1.00 14.35           C  
ATOM    537  C   THR A 119      22.127  99.338 -13.001  1.00 18.35           C  
ATOM    538  O   THR A 119      22.110  98.115 -12.876  1.00 18.25           O  
ATOM    539  CB  THR A 119      21.132  99.719 -15.282  1.00 20.54           C  
ATOM    540  OG1 THR A 119      21.322 100.361 -16.552  1.00 16.86           O  
ATOM    541  CG2 THR A 119      19.866 100.274 -14.625  1.00 19.64           C  
ATOM    542  N   TRP A 120      21.965 100.164 -11.972  1.00 14.65           N  
ATOM    543  CA  TRP A 120      21.703  99.648 -10.631  1.00 15.41           C  
ATOM    544  C   TRP A 120      20.360 100.205 -10.185  1.00 18.13           C  
ATOM    545  O   TRP A 120      20.113 101.408 -10.286  1.00 15.09           O  
ATOM    546  CB  TRP A 120      22.793 100.078  -9.656  1.00 14.58           C  
ATOM    547  CG  TRP A 120      24.153  99.614 -10.061  1.00 15.55           C  
ATOM    548  CD1 TRP A 120      24.702  98.387  -9.843  1.00 15.16           C  
ATOM    549  CD2 TRP A 120      25.136 100.381 -10.757  1.00 17.44           C  
ATOM    550  NE1 TRP A 120      25.977  98.343 -10.358  1.00 18.68           N  
ATOM    551  CE2 TRP A 120      26.268  99.559 -10.927  1.00 17.76           C  
ATOM    552  CE3 TRP A 120      25.171 101.691 -11.252  1.00 20.63           C  
ATOM    553  CZ2 TRP A 120      27.425  99.998 -11.574  1.00 17.08           C  
ATOM    554  CZ3 TRP A 120      26.321 102.131 -11.894  1.00 23.91           C  
ATOM    555  CH2 TRP A 120      27.433 101.284 -12.048  1.00 24.86           C  
ATOM    556  N   VAL A 121      19.493  99.327  -9.697  1.00 14.18           N  
ATOM    557  CA  VAL A 121      18.161  99.731  -9.279  1.00 11.92           C  
ATOM    558  C   VAL A 121      18.035  99.855  -7.769  1.00 18.60           C  
ATOM    559  O   VAL A 121      18.431  98.948  -7.033  1.00 22.36           O  
ATOM    560  CB  VAL A 121      17.120  98.714  -9.810  1.00 18.40           C  
ATOM    561  CG1 VAL A 121      15.729  99.074  -9.337  1.00 16.05           C  
ATOM    562  CG2 VAL A 121      17.168  98.679 -11.340  1.00 16.98           C  
ATOM    563  N   GLY A 122      17.493 100.982  -7.307  1.00 19.80           N  
ATOM    564  CA  GLY A 122      17.307 101.189  -5.876  1.00 20.94           C  
ATOM    565  C   GLY A 122      18.382 102.006  -5.185  1.00 21.52           C  
ATOM    566  O   GLY A 122      19.469 102.210  -5.722  1.00 18.75           O  
ATOM    567  N   ALA A 123      18.088 102.476  -3.980  1.00 22.91           N  
ATOM    568  CA  ALA A 123      19.060 103.274  -3.239  1.00 28.95           C  
ATOM    569  C   ALA A 123      20.092 102.385  -2.554  1.00 26.03           C  
ATOM    570  O   ALA A 123      19.791 101.260  -2.166  1.00 27.75           O  
ATOM    571  CB  ALA A 123      18.346 104.129  -2.194  1.00 35.16           C  
ATOM    572  N   SER A 124      21.316 102.879  -2.420  1.00 28.96           N  
ATOM    573  CA  SER A 124      22.359 102.113  -1.740  1.00 29.70           C  
ATOM    574  C   SER A 124      23.249 103.086  -0.981  1.00 28.91           C  
ATOM    575  O   SER A 124      23.350 104.255  -1.352  1.00 24.94           O  
ATOM    576  CB  SER A 124      23.191 101.297  -2.742  1.00 32.74           C  
ATOM    577  OG  SER A 124      22.404 100.299  -3.378  1.00 40.07           O  
ATOM    578  N   PRO A 125      23.894 102.622   0.103  1.00 29.91           N  
ATOM    579  CA  PRO A 125      24.761 103.528   0.864  1.00 31.07           C  
ATOM    580  C   PRO A 125      25.906 104.055   0.009  1.00 29.72           C  
ATOM    581  O   PRO A 125      26.227 103.482  -1.027  1.00 23.40           O  
ATOM    582  CB  PRO A 125      25.291 102.653   2.002  1.00 34.52           C  
ATOM    583  CG  PRO A 125      24.339 101.509   2.080  1.00 33.97           C  
ATOM    584  CD  PRO A 125      23.939 101.257   0.654  1.00 33.92           C  
ATOM    585  N   ARG A 126      26.530 105.134   0.466  1.00 25.07           N  
ATOM    586  CA  ARG A 126      27.657 105.749  -0.226  1.00 21.34           C  
ATOM    587  C   ARG A 126      28.776 104.755  -0.546  1.00 21.05           C  
ATOM    588  O   ARG A 126      29.301 104.724  -1.661  1.00 20.83           O  
ATOM    589  CB  ARG A 126      28.232 106.876   0.638  1.00 20.78           C  
ATOM    590  CG  ARG A 126      29.480 107.529   0.067  1.00 29.12           C  
ATOM    591  CD  ARG A 126      30.171 108.388   1.120  1.00 41.34           C  
ATOM    592  NE  ARG A 126      30.294 107.696   2.405  1.00 40.80           N  
ATOM    593  CZ  ARG A 126      31.231 106.798   2.703  1.00 48.98           C  
ATOM    594  NH1 ARG A 126      32.156 106.462   1.814  1.00 48.04           N  
ATOM    595  NH2 ARG A 126      31.238 106.227   3.900  1.00 45.04           N  
ATOM    596  N   ARG A 127      29.146 103.959   0.451  1.00 23.68           N  
ATOM    597  CA  ARG A 127      30.219 102.974   0.324  1.00 28.76           C  
ATOM    598  C   ARG A 127      29.941 101.985  -0.803  1.00 25.13           C  
ATOM    599  O   ARG A 127      30.831 101.652  -1.585  1.00 20.63           O  
ATOM    600  CB  ARG A 127      30.368 102.221   1.650  1.00 40.22           C  
ATOM    601  CG  ARG A 127      31.682 101.465   1.855  1.00 52.41           C  
ATOM    602  CD  ARG A 127      32.840 102.438   2.017  1.00 64.55           C  
ATOM    603  NE  ARG A 127      33.753 102.147   3.129  1.00 69.15           N  
ATOM    604  CZ  ARG A 127      33.462 102.280   4.423  1.00 74.93           C  
ATOM    605  NH1 ARG A 127      32.262 102.691   4.814  1.00 72.61           N  
ATOM    606  NH2 ARG A 127      34.389 102.018   5.334  1.00 75.07           N  
ATOM    607  N   VAL A 128      28.700 101.519  -0.881  1.00 23.86           N  
ATOM    608  CA  VAL A 128      28.313 100.571  -1.913  1.00 24.94           C  
ATOM    609  C   VAL A 128      28.401 101.210  -3.310  1.00 22.24           C  
ATOM    610  O   VAL A 128      28.903 100.582  -4.239  1.00 21.34           O  
ATOM    611  CB  VAL A 128      26.888 100.015  -1.632  1.00 25.17           C  
ATOM    612  CG1 VAL A 128      26.422  99.133  -2.782  1.00 20.86           C  
ATOM    613  CG2 VAL A 128      26.904  99.211  -0.322  1.00 27.03           C  
ATOM    614  N   LEU A 129      27.941 102.455  -3.457  1.00 22.17           N  
ATOM    615  CA  LEU A 129      27.998 103.145  -4.750  1.00 21.91           C  
ATOM    616  C   LEU A 129      29.446 103.404  -5.177  1.00 22.01           C  
ATOM    617  O   LEU A 129      29.797 103.240  -6.348  1.00 21.10           O  
ATOM    618  CB  LEU A 129      27.236 104.479  -4.697  1.00 25.79           C  
ATOM    619  CG  LEU A 129      25.726 104.438  -4.431  1.00 36.01           C  
ATOM    620  CD1 LEU A 129      25.203 105.845  -4.140  1.00 32.41           C  
ATOM    621  CD2 LEU A 129      25.023 103.833  -5.633  1.00 38.68           C  
ATOM    622  N   GLU A 130      30.279 103.822  -4.225  1.00 21.79           N  
ATOM    623  CA  GLU A 130      31.693 104.084  -4.495  1.00 25.86           C  
ATOM    624  C   GLU A 130      32.307 102.826  -5.078  1.00 23.75           C  
ATOM    625  O   GLU A 130      32.954 102.854  -6.125  1.00 24.37           O  
ATOM    626  CB  GLU A 130      32.438 104.412  -3.196  1.00 34.87           C  
ATOM    627  CG  GLU A 130      32.167 105.790  -2.629  1.00 40.91           C  
ATOM    628  CD  GLU A 130      33.068 106.847  -3.224  1.00 55.92           C  
ATOM    629  OE1 GLU A 130      33.445 106.706  -4.405  1.00 53.00           O  
ATOM    630  OE2 GLU A 130      33.391 107.825  -2.519  1.00 58.76           O  
ATOM    631  N   GLU A 131      32.102 101.715  -4.386  1.00 22.64           N  
ATOM    632  CA  GLU A 131      32.677 100.476  -4.846  1.00 24.39           C  
ATOM    633  C   GLU A 131      32.125 100.013  -6.193  1.00 20.39           C  
ATOM    634  O   GLU A 131      32.866  99.428  -6.971  1.00 26.28           O  
ATOM    635  CB  GLU A 131      32.576  99.436  -3.723  1.00 26.10           C  
ATOM    636  CG  GLU A 131      33.401  99.941  -2.527  1.00 39.84           C  
ATOM    637  CD  GLU A 131      33.442  99.025  -1.323  1.00 50.68           C  
ATOM    638  OE1 GLU A 131      32.715  98.011  -1.291  1.00 54.02           O  
ATOM    639  OE2 GLU A 131      34.211  99.343  -0.390  1.00 51.42           O  
ATOM    640  N   ARG A 132      30.862 100.296  -6.511  1.00 21.10           N  
ATOM    641  CA  ARG A 132      30.374  99.888  -7.832  1.00 18.91           C  
ATOM    642  C   ARG A 132      31.053 100.706  -8.926  1.00 21.31           C  
ATOM    643  O   ARG A 132      31.359 100.184  -9.996  1.00 20.07           O  
ATOM    644  CB  ARG A 132      28.866 100.098  -7.989  1.00 22.61           C  
ATOM    645  CG  ARG A 132      28.018  99.213  -7.134  1.00 19.74           C  
ATOM    646  CD  ARG A 132      26.568  99.641  -7.146  1.00 21.53           C  
ATOM    647  NE  ARG A 132      25.805  98.707  -6.333  1.00 18.37           N  
ATOM    648  CZ  ARG A 132      24.576  98.914  -5.878  1.00 20.97           C  
ATOM    649  NH1 ARG A 132      23.935 100.042  -6.146  1.00 23.21           N  
ATOM    650  NH2 ARG A 132      23.983  97.977  -5.153  1.00 22.09           N  
ATOM    651  N   LEU A 133      31.274 101.992  -8.666  1.00 15.29           N  
ATOM    652  CA  LEU A 133      31.873 102.874  -9.665  1.00 16.76           C  
ATOM    653  C   LEU A 133      33.391 102.736  -9.824  1.00 20.24           C  
ATOM    654  O   LEU A 133      33.912 102.875 -10.933  1.00 20.44           O  
ATOM    655  CB  LEU A 133      31.511 104.333  -9.343  1.00 21.91           C  
ATOM    656  CG  LEU A 133      30.009 104.677  -9.381  1.00 24.74           C  
ATOM    657  CD1 LEU A 133      29.750 106.015  -8.703  1.00 28.35           C  
ATOM    658  CD2 LEU A 133      29.529 104.698 -10.823  1.00 20.32           C  
ATOM    659  N   ARG A 134      34.086 102.433  -8.730  1.00 22.80           N  
ATOM    660  CA  ARG A 134      35.544 102.311  -8.736  1.00 25.30           C  
ATOM    661  C   ARG A 134      36.177 101.571  -9.925  1.00 26.66           C  
ATOM    662  O   ARG A 134      37.093 102.103 -10.545  1.00 25.91           O  
ATOM    663  CB  ARG A 134      36.021 101.703  -7.400  1.00 27.12           C  
ATOM    664  CG  ARG A 134      37.531 101.847  -7.137  1.00 29.14           C  
ATOM    665  CD  ARG A 134      37.872 101.666  -5.651  1.00 28.85           C  
ATOM    666  NE  ARG A 134      37.309 102.741  -4.836  1.00 31.40           N  
ATOM    667  CZ  ARG A 134      37.049 102.649  -3.535  1.00 36.10           C  
ATOM    668  NH1 ARG A 134      37.297 101.525  -2.873  1.00 43.61           N  
ATOM    669  NH2 ARG A 134      36.534 103.688  -2.892  1.00 34.64           N  
ATOM    670  N   PRO A 135      35.710 100.350 -10.263  1.00 26.32           N  
ATOM    671  CA  PRO A 135      36.333  99.663 -11.405  1.00 22.70           C  
ATOM    672  C   PRO A 135      36.228 100.446 -12.723  1.00 25.29           C  
ATOM    673  O   PRO A 135      37.141 100.403 -13.551  1.00 22.02           O  
ATOM    674  CB  PRO A 135      35.586  98.327 -11.479  1.00 27.19           C  
ATOM    675  CG  PRO A 135      35.059  98.127 -10.098  1.00 27.94           C  
ATOM    676  CD  PRO A 135      34.678  99.508  -9.635  1.00 23.46           C  
ATOM    677  N   TYR A 136      35.115 101.148 -12.927  1.00 18.29           N  
ATOM    678  CA  TYR A 136      34.932 101.935 -14.150  1.00 21.89           C  
ATOM    679  C   TYR A 136      35.826 103.174 -14.097  1.00 17.83           C  
ATOM    680  O   TYR A 136      36.413 103.568 -15.105  1.00 23.04           O  
ATOM    681  CB  TYR A 136      33.464 102.350 -14.303  1.00 16.33           C  
ATOM    682  CG  TYR A 136      32.521 101.174 -14.456  1.00 14.93           C  
ATOM    683  CD1 TYR A 136      32.338 100.559 -15.691  1.00 18.92           C  
ATOM    684  CD2 TYR A 136      31.834 100.662 -13.356  1.00 20.81           C  
ATOM    685  CE1 TYR A 136      31.494  99.457 -15.828  1.00 17.71           C  
ATOM    686  CE2 TYR A 136      30.985  99.571 -13.478  1.00 17.48           C  
ATOM    687  CZ  TYR A 136      30.820  98.973 -14.717  1.00 20.62           C  
ATOM    688  OH  TYR A 136      29.982  97.891 -14.850  1.00 21.42           O  
ATOM    689  N   LEU A 137      35.935 103.782 -12.920  1.00 21.45           N  
ATOM    690  CA  LEU A 137      36.780 104.961 -12.744  1.00 28.42           C  
ATOM    691  C   LEU A 137      38.252 104.607 -12.913  1.00 32.66           C  
ATOM    692  O   LEU A 137      39.055 105.447 -13.315  1.00 38.14           O  
ATOM    693  CB  LEU A 137      36.574 105.547 -11.353  1.00 32.70           C  
ATOM    694  CG  LEU A 137      35.191 106.136 -11.095  1.00 35.57           C  
ATOM    695  CD1 LEU A 137      35.057 106.504  -9.629  1.00 37.00           C  
ATOM    696  CD2 LEU A 137      34.986 107.352 -11.992  1.00 33.77           C  
ATOM    697  N   GLU A 138      38.603 103.365 -12.584  1.00 36.23           N  
ATOM    698  CA  GLU A 138      39.983 102.898 -12.690  1.00 38.67           C  
ATOM    699  C   GLU A 138      40.250 102.202 -14.020  1.00 35.58           C  
ATOM    700  O   GLU A 138      41.384 101.825 -14.317  1.00 43.93           O  
ATOM    701  CB  GLU A 138      40.317 101.947 -11.527  1.00 33.57           C  
ATOM    702  CG  GLU A 138      40.558 102.661 -10.194  1.00 38.24           C  
ATOM    703  CD  GLU A 138      40.710 101.723  -8.999  1.00 42.45           C  
ATOM    704  OE1 GLU A 138      40.698 100.484  -9.173  1.00 43.89           O  
ATOM    705  OE2 GLU A 138      40.842 102.239  -7.869  1.00 47.47           O  
ATOM    706  N   GLY A 139      39.200 102.040 -14.817  1.00 39.46           N  
ATOM    707  CA  GLY A 139      39.337 101.382 -16.104  1.00 37.94           C  
ATOM    708  C   GLY A 139      39.506 102.349 -17.260  1.00 48.80           C  
ATOM    709  O   GLY A 139      39.468 103.565 -17.071  1.00 47.73           O  
ATOM    710  N   ARG A 140      39.685 101.809 -18.462  1.00 43.41           N  
ATOM    711  CA  ARG A 140      39.874 102.628 -19.654  1.00 48.89           C  
ATOM    712  C   ARG A 140      38.654 103.486 -19.972  1.00 52.81           C  
ATOM    713  O   ARG A 140      37.552 103.165 -19.481  1.00 50.20           O  
ATOM    714  CB  ARG A 140      40.190 101.729 -20.850  1.00 50.06           C  
ATOM    715  OXT ARG A 140      38.827 104.465 -20.726  1.00 55.08           O  
TER     716      ARG A 140                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
