
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   86 (  682),  selected   86 , name 2obk_F
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2obk_F.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R     4_F      -       -           -
LGA    K     5_F      T      12          0.590
LGA    P     6_F      H      13          0.933
LGA    E     7_F      R      14          0.501
LGA    V     8_F      V      15          0.593
LGA    I     9_F      Q      16          0.315
LGA    I    10_F      I      17          0.258
LGA    T    11_F      E      18          0.200
LGA    Y    12_F      Y      19          0.292
LGA    C    13_F      C      20          0.364
LGA    T    14_F      T      21          0.487
LGA    Q    15_F      Q      22          1.136
LGA    C    16_F      C      23          0.546
LGA    Q    17_F      R      24          0.452
LGA    W    18_F      W      25          0.313
LGA    L    19_F      L      26          0.356
LGA    L    20_F      P      27          0.482
LGA    R    21_F      R      28          0.416
LGA    A    22_F      A      29          0.404
LGA    A    23_F      A      30          0.423
LGA    W    24_F      W      31          0.248
LGA    L    25_F      L      32          0.294
LGA    A    26_F      A      33          0.471
LGA    Q    27_F      Q      34          0.460
LGA    E    28_F      E      35          0.207
LGA    L    29_F      L      36          0.498
LGA    L    30_F      L      37          0.574
LGA    S    31_F      T      38          0.573
LGA    T    32_F      T      39          0.763
LGA    F    33_F      F      40          0.705
LGA    S    34_F      E      41          0.924
LGA    D    35_F      T      42          0.991
LGA    D    36_F      E      43          0.571
LGA    L    37_F      L      44          0.608
LGA    G    38_F      T      45          0.708
LGA    K    39_F      E      46          0.577
LGA    V    40_F      L      47          0.550
LGA    S    41_F      A      48          0.440
LGA    L    42_F      L      49          0.261
LGA    E    43_F      K      50          0.219
LGA    P    44_F      P      51          0.232
LGA    A    45_F      G      52          0.985
LGA    T    46_F      T      53          1.432
LGA    G    47_F      G      54          1.065
LGA    G    48_F      G      55          1.152
LGA    A    49_F      V      56          0.526
LGA    F    50_F      F      57          0.560
LGA    R    51_F      V      58          0.773
LGA    I    52_F      V      59          0.606
LGA    T    53_F      R      60          0.528
LGA    C    54_F      V      61          0.319
LGA    D    55_F      D      62          0.077
LGA    G    56_F      D      63          1.156
LGA    V    57_F      E      64          1.254
LGA    Q    58_F      V      65          0.875
LGA    I    59_F      V      66          0.660
LGA    W    60_F      W      67          0.450
LGA    E    61_F      D      68          0.536
LGA    R    62_F      R      69          0.689
LGA    K    63_F      R      70          0.748
LGA    A    64_F      E      71          0.989
LGA    D    65_F      Q      72          0.832
LGA    G    66_F      G      73          2.389
LGA    G    67_F      F      74          3.292
LGA    F    68_F      -       -           -
LGA    P    69_F      P      75          1.219
LGA    E    70_F      E      76          0.849
LGA    A    71_F      P      77          0.774
LGA    K    72_F      T      78          0.955
LGA    V    73_F      A      79          1.112
LGA    L    74_F      V      80          1.203
LGA    K    75_F      K      81          0.978
LGA    Q    76_F      R      82          0.609
LGA    R    77_F      L      83          0.743
LGA    V    78_F      V      84          0.716
LGA    R    79_F      R      85          0.350
LGA    D    80_F      D      86          0.721
LGA    Q    81_F      R      87          0.703
LGA    I    82_F      V      88          0.422
LGA    D    83_F      -       -           -
LGA    P    84_F      -       -           -
LGA    E    85_F      -       -           -
LGA    R    86_F      -       -           -
LGA    D    87_F      -       -           -
LGA    L    88_F      -       -           -
LGA    G    89_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   86   77    5.0     77    0.83    49.35     98.690     8.264

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.370802 * X  +   0.362385 * Y  +   0.855092 * Z  +  -8.671826
  Y_new =   0.925267 * X  +  -0.064913 * Y  +  -0.373722 * Z  + 112.760925
  Z_new =  -0.079924 * X  +   0.929765 * Y  +  -0.359373 * Z  +  -2.485742 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.939628   -1.201964  [ DEG:   111.1325    -68.8675 ]
  Theta =   0.080010    3.061583  [ DEG:     4.5842    175.4158 ]
  Phi   =   1.189642   -1.951950  [ DEG:    68.1615   -111.8385 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2obk_F                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2obk_F.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   86   77   5.0   77   0.83   49.35  98.690
REMARK  ---------------------------------------------------------- 
MOLECULE 2obk_F
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   19-DEC-06   2OBK              
TITLE     X-RAY STRUCTURE OF THE PUTATIVE SE BINDING PROTEIN FROM               
TITLE    2 PSEUDOMONAS FLUORESCENS. NORTHEAST STRUCTURAL GENOMICS               
TITLE    3 CONSORTIUM TARGET PLR6.                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SELT/SELW/SELH SELENOPROTEIN DOMAIN;                       
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PF-5;                                                        
SOURCE   5 ATCC: BAA-477;                                                       
SOURCE   6 GENE: PFL_1582;                                                      
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    X-RAY NESG PLR6 Q4KGC5, STRUCTURAL GENOMICS, PSI-2, PROTEIN           
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.KUZIN,M.SU,J.SEETHARAMAN,C.X.CHEN,Y.FANG,K.CUNNINGHAM,            
AUTHOR   2 L.C.MA,R.XIAO,J.LIU,M.C.BARAN,T.B.ACTON,B.ROST,                      
AUTHOR   3 G.T.MONTELIONE,L.TONG,J.F.HUNT,NORTHEAST STRUCTURAL                  
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   02-JAN-07 2OBK    0                                                
JRNL        AUTH   A.P.KUZIN,M.SU,J.SEETHARAMAN,C.CHEN,Y.FANG,                  
JRNL        AUTH 2 K.CUNNINGHAM,L.C.MA,R.XIAO,J.LIU,M.C.BARAN,                  
JRNL        AUTH 3 T.B.ACTON,B.ROST,G.T.MONTELIONE,L.TONG,J.F.HUNT              
JRNL        TITL   X-RAY STRUCTURE OF THE PUTATIVE SE BINDING PROTEIN           
JRNL        TITL 2 FROM PSEUDOMONAS FLUORESCENS                                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  2OBK A    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK B    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK C    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK D    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK E    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK F    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK G    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK H    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
SEQRES   1 A  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 A  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 A  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 A  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 A  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 A  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 A  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 A  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 B  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 B  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 B  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 B  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 B  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 B  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 B  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 B  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 C  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 C  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 C  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 C  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 C  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 C  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 C  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 C  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 D  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 D  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 D  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 D  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 D  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 D  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 D  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 D  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 E  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 E  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 E  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 E  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 E  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 E  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 E  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 E  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 F  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 F  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 F  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 F  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 F  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 F  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 F  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 F  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 G  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 G  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 G  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 G  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 G  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 G  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 G  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 G  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 H  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 H  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 H  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 H  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 H  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 H  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 H  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 H  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
FORMUL   9  HOH   *132(H2 O)                                                    
CRYST1   54.311  112.251  148.459  90.00  90.00  90.00 P 21 21 21   32          
ATOM   3306  N   ARG F   4      35.398 111.916 -24.052  1.00 64.28           N  
ATOM   3307  CA  ARG F   4      34.792 110.575 -23.807  1.00 63.73           C  
ATOM   3308  C   ARG F   4      34.661 110.333 -22.300  1.00 61.12           C  
ATOM   3309  O   ARG F   4      34.340 109.220 -21.876  1.00 61.26           O  
ATOM   3310  CB  ARG F   4      35.658 109.477 -24.466  1.00 68.05           C  
ATOM   3311  CG  ARG F   4      34.933 108.143 -24.796  1.00 72.77           C  
ATOM   3312  CD  ARG F   4      34.853 107.171 -23.601  1.00 77.34           C  
ATOM   3313  NE  ARG F   4      33.922 106.056 -23.833  1.00 81.34           N  
ATOM   3314  CZ  ARG F   4      33.587 105.138 -22.921  1.00 82.60           C  
ATOM   3315  NH1 ARG F   4      34.103 105.180 -21.696  1.00 82.68           N  
ATOM   3316  NH2 ARG F   4      32.725 104.177 -23.232  1.00 82.20           N  
ATOM   3317  N   LYS F   5      34.908 111.369 -21.493  1.00 57.28           N  
ATOM   3318  CA  LYS F   5      34.792 111.235 -20.038  1.00 52.64           C  
ATOM   3319  C   LYS F   5      33.405 110.691 -19.750  1.00 50.44           C  
ATOM   3320  O   LYS F   5      32.414 111.232 -20.232  1.00 50.47           O  
ATOM   3321  CB  LYS F   5      34.985 112.584 -19.334  1.00 52.19           C  
ATOM   3322  CG  LYS F   5      36.380 113.169 -19.477  1.00 50.70           C  
ATOM   3323  CD  LYS F   5      36.586 114.408 -18.610  1.00 49.81           C  
ATOM   3324  CE  LYS F   5      36.606 114.066 -17.132  1.00 48.38           C  
ATOM   3325  NZ  LYS F   5      36.801 115.277 -16.282  1.00 47.09           N  
ATOM   3326  N   PRO F   6      33.323 109.602 -18.965  1.00 48.33           N  
ATOM   3327  CA  PRO F   6      32.070 108.938 -18.595  1.00 45.53           C  
ATOM   3328  C   PRO F   6      31.087 109.787 -17.803  1.00 43.19           C  
ATOM   3329  O   PRO F   6      31.476 110.683 -17.059  1.00 42.43           O  
ATOM   3330  CB  PRO F   6      32.551 107.723 -17.810  1.00 44.99           C  
ATOM   3331  CG  PRO F   6      33.763 108.233 -17.133  1.00 46.22           C  
ATOM   3332  CD  PRO F   6      34.457 109.005 -18.236  1.00 47.35           C  
ATOM   3333  N   GLU F   7      29.806 109.484 -17.969  1.00 41.70           N  
ATOM   3334  CA  GLU F   7      28.752 110.206 -17.274  1.00 41.10           C  
ATOM   3335  C   GLU F   7      27.845 109.222 -16.541  1.00 40.04           C  
ATOM   3336  O   GLU F   7      27.551 108.142 -17.065  1.00 38.88           O  
ATOM   3337  CB  GLU F   7      27.926 110.995 -18.287  1.00 41.84           C  
ATOM   3338  CG  GLU F   7      28.751 111.916 -19.167  1.00 43.91           C  
ATOM   3339  CD  GLU F   7      27.958 112.470 -20.329  1.00 44.69           C  
ATOM   3340  OE1 GLU F   7      28.426 113.437 -20.968  1.00 44.78           O  
ATOM   3341  OE2 GLU F   7      26.866 111.927 -20.606  1.00 44.92           O  
ATOM   3342  N   VAL F   8      27.420 109.576 -15.330  1.00 37.61           N  
ATOM   3343  CA  VAL F   8      26.515 108.704 -14.594  1.00 38.08           C  
ATOM   3344  C   VAL F   8      25.193 109.444 -14.443  1.00 39.01           C  
ATOM   3345  O   VAL F   8      25.160 110.673 -14.407  1.00 40.44           O  
ATOM   3346  CB  VAL F   8      27.054 108.310 -13.179  1.00 36.22           C  
ATOM   3347  CG1 VAL F   8      28.556 108.308 -13.183  1.00 36.52           C  
ATOM   3348  CG2 VAL F   8      26.506 109.226 -12.110  1.00 36.52           C  
ATOM   3349  N   ILE F   9      24.097 108.707 -14.373  1.00 39.37           N  
ATOM   3350  CA  ILE F   9      22.812 109.352 -14.219  1.00 38.62           C  
ATOM   3351  C   ILE F   9      21.967 108.619 -13.200  1.00 37.09           C  
ATOM   3352  O   ILE F   9      21.823 107.403 -13.259  1.00 36.41           O  
ATOM   3353  CB  ILE F   9      22.064 109.473 -15.581  1.00 40.03           C  
ATOM   3354  CG1 ILE F   9      20.580 109.178 -15.391  1.00 39.79           C  
ATOM   3355  CG2 ILE F   9      22.695 108.571 -16.620  1.00 38.83           C  
ATOM   3356  CD1 ILE F   9      19.764 109.412 -16.631  1.00 42.44           C  
ATOM   3357  N   ILE F  10      21.443 109.390 -12.251  1.00 36.18           N  
ATOM   3358  CA  ILE F  10      20.598 108.885 -11.183  1.00 35.55           C  
ATOM   3359  C   ILE F  10      19.133 109.190 -11.492  1.00 36.17           C  
ATOM   3360  O   ILE F  10      18.695 110.343 -11.426  1.00 34.80           O  
ATOM   3361  CB  ILE F  10      20.939 109.546  -9.824  1.00 35.34           C  
ATOM   3362  CG1 ILE F  10      22.384 109.256  -9.438  1.00 36.95           C  
ATOM   3363  CG2 ILE F  10      20.016 109.014  -8.735  1.00 33.88           C  
ATOM   3364  CD1 ILE F  10      22.755 109.787  -8.053  1.00 37.99           C  
ATOM   3365  N   THR F  11      18.376 108.157 -11.837  1.00 36.22           N  
ATOM   3366  CA  THR F  11      16.969 108.350 -12.119  1.00 37.56           C  
ATOM   3367  C   THR F  11      16.267 108.132 -10.794  1.00 38.88           C  
ATOM   3368  O   THR F  11      16.396 107.076 -10.199  1.00 40.35           O  
ATOM   3369  CB  THR F  11      16.472 107.343 -13.149  1.00 35.35           C  
ATOM   3370  OG1 THR F  11      17.333 107.380 -14.290  1.00 38.06           O  
ATOM   3371  CG2 THR F  11      15.068 107.692 -13.592  1.00 34.45           C  
ATOM   3372  N   TYR F  12      15.544 109.133 -10.312  1.00 41.10           N  
ATOM   3373  CA  TYR F  12      14.859 108.989  -9.036  1.00 43.54           C  
ATOM   3374  C   TYR F  12      13.372 109.251  -9.181  1.00 45.14           C  
ATOM   3375  O   TYR F  12      12.935 109.920 -10.113  1.00 46.06           O  
ATOM   3376  CB  TYR F  12      15.453 109.953  -8.002  1.00 43.48           C  
ATOM   3377  CG  TYR F  12      15.208 111.399  -8.333  1.00 44.39           C  
ATOM   3378  CD1 TYR F  12      14.307 112.163  -7.597  1.00 43.36           C  
ATOM   3379  CD2 TYR F  12      15.846 111.995  -9.416  1.00 45.63           C  
ATOM   3380  CE1 TYR F  12      14.046 113.488  -7.934  1.00 43.16           C  
ATOM   3381  CE2 TYR F  12      15.588 113.321  -9.764  1.00 44.74           C  
ATOM   3382  CZ  TYR F  12      14.692 114.056  -9.024  1.00 43.45           C  
ATOM   3383  OH  TYR F  12      14.452 115.353  -9.384  1.00 42.94           O  
ATOM   3384  N   CYS F  13      12.595 108.706  -8.254  1.00 47.51           N  
ATOM   3385  CA  CYS F  13      11.155 108.886  -8.263  1.00 50.07           C  
ATOM   3386  C   CYS F  13      10.845 110.230  -7.606  1.00 51.47           C  
ATOM   3387  O   CYS F  13      11.067 110.423  -6.406  1.00 52.11           O  
ATOM   3388  CB  CYS F  13      10.479 107.722  -7.522  1.00 50.95           C  
ATOM   3389  SG  CYS F  13       8.751 108.031  -7.053  1.00 52.14           S  
ATOM   3390  N   THR F  14      10.345 111.161  -8.413  1.00 52.50           N  
ATOM   3391  CA  THR F  14      10.028 112.501  -7.941  1.00 53.79           C  
ATOM   3392  C   THR F  14       8.978 112.559  -6.830  1.00 55.64           C  
ATOM   3393  O   THR F  14       9.280 112.953  -5.698  1.00 56.93           O  
ATOM   3394  CB  THR F  14       9.580 113.395  -9.112  1.00 52.81           C  
ATOM   3395  OG1 THR F  14       9.084 114.634  -8.600  1.00 53.87           O  
ATOM   3396  CG2 THR F  14       8.496 112.715  -9.918  1.00 53.46           C  
ATOM   3397  N   GLN F  15       7.751 112.164  -7.140  1.00 55.68           N  
ATOM   3398  CA  GLN F  15       6.700 112.213  -6.143  1.00 56.65           C  
ATOM   3399  C   GLN F  15       7.070 111.497  -4.844  1.00 55.73           C  
ATOM   3400  O   GLN F  15       6.506 111.784  -3.789  1.00 55.03           O  
ATOM   3401  CB  GLN F  15       5.399 111.640  -6.715  1.00 59.25           C  
ATOM   3402  CG  GLN F  15       4.781 112.472  -7.845  1.00 61.81           C  
ATOM   3403  CD  GLN F  15       4.621 113.951  -7.486  1.00 62.52           C  
ATOM   3404  OE1 GLN F  15       4.290 114.295  -6.347  1.00 61.14           O  
ATOM   3405  NE2 GLN F  15       4.845 114.830  -8.468  1.00 62.16           N  
ATOM   3406  N   CYS F  16       8.023 110.575  -4.919  1.00 54.72           N  
ATOM   3407  CA  CYS F  16       8.451 109.834  -3.737  1.00 54.97           C  
ATOM   3408  C   CYS F  16       9.252 110.725  -2.780  1.00 55.36           C  
ATOM   3409  O   CYS F  16       9.478 110.358  -1.621  1.00 55.47           O  
ATOM   3410  CB  CYS F  16       9.336 108.648  -4.124  1.00 55.00           C  
ATOM   3411  SG  CYS F  16       8.647 107.310  -5.158  1.00 54.90           S  
ATOM   3412  N   GLN F  17       9.681 111.887  -3.268  1.00 54.32           N  
ATOM   3413  CA  GLN F  17      10.474 112.812  -2.465  1.00 52.44           C  
ATOM   3414  C   GLN F  17      11.854 112.202  -2.222  1.00 50.72           C  
ATOM   3415  O   GLN F  17      12.334 112.139  -1.094  1.00 49.69           O  
ATOM   3416  CB  GLN F  17       9.777 113.099  -1.131  1.00 54.01           C  
ATOM   3417  CG  GLN F  17       8.444 113.817  -1.270  1.00 56.33           C  
ATOM   3418  CD  GLN F  17       8.601 115.283  -1.652  1.00 57.25           C  
ATOM   3419  OE1 GLN F  17       7.807 115.825  -2.428  1.00 57.56           O  
ATOM   3420  NE2 GLN F  17       9.615 115.937  -1.091  1.00 56.45           N  
ATOM   3421  N   TRP F  18      12.481 111.747  -3.299  1.00 49.93           N  
ATOM   3422  CA  TRP F  18      13.806 111.144  -3.232  1.00 49.32           C  
ATOM   3423  C   TRP F  18      14.874 112.022  -3.883  1.00 48.11           C  
ATOM   3424  O   TRP F  18      15.989 111.565  -4.157  1.00 46.80           O  
ATOM   3425  CB  TRP F  18      13.802 109.772  -3.909  1.00 50.89           C  
ATOM   3426  CG  TRP F  18      12.969 108.751  -3.202  1.00 53.03           C  
ATOM   3427  CD1 TRP F  18      12.335 108.890  -1.998  1.00 53.61           C  
ATOM   3428  CD2 TRP F  18      12.688 107.422  -3.653  1.00 54.08           C  
ATOM   3429  NE1 TRP F  18      11.675 107.727  -1.674  1.00 54.21           N  
ATOM   3430  CE2 TRP F  18      11.875 106.809  -2.672  1.00 54.59           C  
ATOM   3431  CE3 TRP F  18      13.046 106.686  -4.795  1.00 54.32           C  
ATOM   3432  CZ2 TRP F  18      11.414 105.496  -2.797  1.00 53.18           C  
ATOM   3433  CZ3 TRP F  18      12.590 105.379  -4.920  1.00 52.62           C  
ATOM   3434  CH2 TRP F  18      11.781 104.800  -3.924  1.00 53.81           C  
ATOM   3435  N   LEU F  19      14.526 113.281  -4.138  1.00 45.70           N  
ATOM   3436  CA  LEU F  19      15.458 114.215  -4.739  1.00 41.50           C  
ATOM   3437  C   LEU F  19      16.614 114.431  -3.757  1.00 40.56           C  
ATOM   3438  O   LEU F  19      17.769 114.580  -4.156  1.00 40.13           O  
ATOM   3439  CB  LEU F  19      14.746 115.542  -5.038  1.00 39.80           C  
ATOM   3440  CG  LEU F  19      15.604 116.711  -5.544  1.00 37.58           C  
ATOM   3441  CD1 LEU F  19      16.126 116.393  -6.935  1.00 36.41           C  
ATOM   3442  CD2 LEU F  19      14.794 117.989  -5.574  1.00 35.33           C  
ATOM   3443  N   LEU F  20      16.297 114.433  -2.467  1.00 39.47           N  
ATOM   3444  CA  LEU F  20      17.306 114.635  -1.436  1.00 39.42           C  
ATOM   3445  C   LEU F  20      18.425 113.615  -1.480  1.00 39.32           C  
ATOM   3446  O   LEU F  20      19.594 113.973  -1.358  1.00 40.50           O  
ATOM   3447  CB  LEU F  20      16.674 114.604  -0.045  1.00 39.83           C  
ATOM   3448  CG  LEU F  20      16.069 115.898   0.487  1.00 39.61           C  
ATOM   3449  CD1 LEU F  20      15.567 115.662   1.900  1.00 36.49           C  
ATOM   3450  CD2 LEU F  20      17.122 117.014   0.458  1.00 39.32           C  
ATOM   3451  N   ARG F  21      18.073 112.346  -1.644  1.00 38.22           N  
ATOM   3452  CA  ARG F  21      19.084 111.307  -1.679  1.00 38.90           C  
ATOM   3453  C   ARG F  21      19.774 111.202  -3.036  1.00 39.16           C  
ATOM   3454  O   ARG F  21      20.989 111.000  -3.101  1.00 41.66           O  
ATOM   3455  CB  ARG F  21      18.466 109.966  -1.289  1.00 40.49           C  
ATOM   3456  CG  ARG F  21      17.399 109.466  -2.245  1.00 43.18           C  
ATOM   3457  CD  ARG F  21      16.656 108.281  -1.672  1.00 41.59           C  
ATOM   3458  NE  ARG F  21      16.101 108.623  -0.370  1.00 43.75           N  
ATOM   3459  CZ  ARG F  21      15.188 107.904   0.268  1.00 44.73           C  
ATOM   3460  NH1 ARG F  21      14.720 106.790  -0.281  1.00 44.75           N  
ATOM   3461  NH2 ARG F  21      14.746 108.297   1.455  1.00 43.74           N  
ATOM   3462  N   ALA F  22      19.012 111.337  -4.119  1.00 37.82           N  
ATOM   3463  CA  ALA F  22      19.599 111.258  -5.452  1.00 36.35           C  
ATOM   3464  C   ALA F  22      20.609 112.394  -5.597  1.00 34.90           C  
ATOM   3465  O   ALA F  22      21.682 112.228  -6.183  1.00 33.33           O  
ATOM   3466  CB  ALA F  22      18.511 111.361  -6.523  1.00 36.15           C  
ATOM   3467  N   ALA F  23      20.260 113.548  -5.045  1.00 33.33           N  
ATOM   3468  CA  ALA F  23      21.143 114.696  -5.098  1.00 35.26           C  
ATOM   3469  C   ALA F  23      22.375 114.439  -4.215  1.00 35.89           C  
ATOM   3470  O   ALA F  23      23.500 114.728  -4.610  1.00 38.09           O  
ATOM   3471  CB  ALA F  23      20.401 115.933  -4.634  1.00 35.11           C  
ATOM   3472  N   TRP F  24      22.158 113.892  -3.023  1.00 35.24           N  
ATOM   3473  CA  TRP F  24      23.246 113.582  -2.107  1.00 34.32           C  
ATOM   3474  C   TRP F  24      24.251 112.644  -2.762  1.00 35.13           C  
ATOM   3475  O   TRP F  24      25.451 112.868  -2.684  1.00 36.00           O  
ATOM   3476  CB  TRP F  24      22.694 112.925  -0.853  1.00 35.29           C  
ATOM   3477  CG  TRP F  24      23.720 112.235   0.010  1.00 35.20           C  
ATOM   3478  CD1 TRP F  24      24.757 112.815   0.679  1.00 34.72           C  
ATOM   3479  CD2 TRP F  24      23.758 110.838   0.343  1.00 34.81           C  
ATOM   3480  NE1 TRP F  24      25.432 111.869   1.416  1.00 36.16           N  
ATOM   3481  CE2 TRP F  24      24.840 110.648   1.227  1.00 34.50           C  
ATOM   3482  CE3 TRP F  24      22.976 109.728  -0.019  1.00 33.91           C  
ATOM   3483  CZ2 TRP F  24      25.164 109.393   1.758  1.00 33.73           C  
ATOM   3484  CZ3 TRP F  24      23.299 108.477   0.512  1.00 32.83           C  
ATOM   3485  CH2 TRP F  24      24.385 108.324   1.391  1.00 31.09           C  
ATOM   3486  N   LEU F  25      23.765 111.582  -3.396  1.00 34.81           N  
ATOM   3487  CA  LEU F  25      24.663 110.640  -4.056  1.00 35.59           C  
ATOM   3488  C   LEU F  25      25.431 111.316  -5.191  1.00 36.10           C  
ATOM   3489  O   LEU F  25      26.648 111.136  -5.311  1.00 37.94           O  
ATOM   3490  CB  LEU F  25      23.892 109.426  -4.599  1.00 35.65           C  
ATOM   3491  CG  LEU F  25      23.345 108.425  -3.576  1.00 36.72           C  
ATOM   3492  CD1 LEU F  25      22.675 107.276  -4.297  1.00 36.86           C  
ATOM   3493  CD2 LEU F  25      24.484 107.895  -2.720  1.00 38.33           C  
ATOM   3494  N   ALA F  26      24.734 112.095  -6.019  1.00 35.06           N  
ATOM   3495  CA  ALA F  26      25.398 112.772  -7.125  1.00 33.74           C  
ATOM   3496  C   ALA F  26      26.576 113.568  -6.593  1.00 32.66           C  
ATOM   3497  O   ALA F  26      27.620 113.639  -7.235  1.00 36.31           O  
ATOM   3498  CB  ALA F  26      24.435 113.690  -7.850  1.00 34.12           C  
ATOM   3499  N   GLN F  27      26.421 114.152  -5.413  1.00 28.73           N  
ATOM   3500  CA  GLN F  27      27.507 114.927  -4.833  1.00 27.78           C  
ATOM   3501  C   GLN F  27      28.596 114.046  -4.263  1.00 27.47           C  
ATOM   3502  O   GLN F  27      29.771 114.374  -4.355  1.00 29.18           O  
ATOM   3503  CB  GLN F  27      26.973 115.870  -3.759  1.00 27.38           C  
ATOM   3504  CG  GLN F  27      26.393 117.153  -4.343  1.00 25.23           C  
ATOM   3505  CD  GLN F  27      25.639 117.941  -3.321  1.00 23.91           C  
ATOM   3506  OE1 GLN F  27      24.470 117.674  -3.064  1.00 25.32           O  
ATOM   3507  NE2 GLN F  27      26.304 118.906  -2.709  1.00 23.26           N  
ATOM   3508  N   GLU F  28      28.208 112.928  -3.664  1.00 27.24           N  
ATOM   3509  CA  GLU F  28      29.178 111.999  -3.112  1.00 26.90           C  
ATOM   3510  C   GLU F  28      30.119 111.571  -4.226  1.00 27.30           C  
ATOM   3511  O   GLU F  28      31.333 111.536  -4.037  1.00 25.14           O  
ATOM   3512  CB  GLU F  28      28.487 110.760  -2.549  1.00 27.42           C  
ATOM   3513  CG  GLU F  28      28.085 110.862  -1.094  1.00 29.26           C  
ATOM   3514  CD  GLU F  28      29.261 111.143  -0.186  1.00 30.29           C  
ATOM   3515  OE1 GLU F  28      30.390 110.754  -0.532  1.00 32.08           O  
ATOM   3516  OE2 GLU F  28      29.064 111.744   0.883  1.00 31.01           O  
ATOM   3517  N   LEU F  29      29.549 111.239  -5.384  1.00 27.89           N  
ATOM   3518  CA  LEU F  29      30.344 110.816  -6.532  1.00 27.91           C  
ATOM   3519  C   LEU F  29      31.206 111.941  -7.085  1.00 30.72           C  
ATOM   3520  O   LEU F  29      32.375 111.729  -7.426  1.00 32.89           O  
ATOM   3521  CB  LEU F  29      29.447 110.292  -7.645  1.00 25.41           C  
ATOM   3522  CG  LEU F  29      28.749 108.948  -7.424  1.00 24.73           C  
ATOM   3523  CD1 LEU F  29      27.842 108.659  -8.608  1.00 25.04           C  
ATOM   3524  CD2 LEU F  29      29.772 107.844  -7.264  1.00 24.30           C  
ATOM   3525  N   LEU F  30      30.642 113.140  -7.179  1.00 31.55           N  
ATOM   3526  CA  LEU F  30      31.397 114.265  -7.702  1.00 31.33           C  
ATOM   3527  C   LEU F  30      32.504 114.746  -6.767  1.00 32.78           C  
ATOM   3528  O   LEU F  30      33.464 115.367  -7.210  1.00 33.93           O  
ATOM   3529  CB  LEU F  30      30.450 115.410  -8.050  1.00 30.98           C  
ATOM   3530  CG  LEU F  30      29.631 115.171  -9.329  1.00 30.73           C  
ATOM   3531  CD1 LEU F  30      28.661 116.297  -9.508  1.00 28.43           C  
ATOM   3532  CD2 LEU F  30      30.538 115.065 -10.544  1.00 28.23           C  
ATOM   3533  N   SER F  31      32.396 114.453  -5.478  1.00 33.87           N  
ATOM   3534  CA  SER F  31      33.440 114.885  -4.558  1.00 35.08           C  
ATOM   3535  C   SER F  31      34.616 113.902  -4.600  1.00 36.95           C  
ATOM   3536  O   SER F  31      35.705 114.191  -4.087  1.00 39.50           O  
ATOM   3537  CB  SER F  31      32.893 115.005  -3.129  1.00 34.49           C  
ATOM   3538  OG  SER F  31      32.668 113.740  -2.541  1.00 38.34           O  
ATOM   3539  N   THR F  32      34.402 112.748  -5.227  1.00 36.33           N  
ATOM   3540  CA  THR F  32      35.443 111.737  -5.327  1.00 34.87           C  
ATOM   3541  C   THR F  32      35.857 111.429  -6.758  1.00 34.51           C  
ATOM   3542  O   THR F  32      36.879 110.787  -6.974  1.00 36.55           O  
ATOM   3543  CB  THR F  32      35.017 110.408  -4.632  1.00 35.21           C  
ATOM   3544  OG1 THR F  32      35.771 109.319  -5.176  1.00 35.80           O  
ATOM   3545  CG2 THR F  32      33.555 110.126  -4.836  1.00 34.54           C  
ATOM   3546  N   PHE F  33      35.081 111.890  -7.732  1.00 33.26           N  
ATOM   3547  CA  PHE F  33      35.405 111.627  -9.133  1.00 32.83           C  
ATOM   3548  C   PHE F  33      35.461 112.871 -10.020  1.00 33.01           C  
ATOM   3549  O   PHE F  33      35.181 112.779 -11.214  1.00 33.37           O  
ATOM   3550  CB  PHE F  33      34.392 110.644  -9.734  1.00 32.77           C  
ATOM   3551  CG  PHE F  33      34.458 109.265  -9.148  1.00 32.06           C  
ATOM   3552  CD1 PHE F  33      35.532 108.430  -9.417  1.00 32.61           C  
ATOM   3553  CD2 PHE F  33      33.437 108.788  -8.337  1.00 33.38           C  
ATOM   3554  CE1 PHE F  33      35.587 107.127  -8.884  1.00 34.06           C  
ATOM   3555  CE2 PHE F  33      33.480 107.487  -7.796  1.00 33.72           C  
ATOM   3556  CZ  PHE F  33      34.555 106.659  -8.072  1.00 33.51           C  
ATOM   3557  N   SER F  34      35.836 114.017  -9.454  1.00 33.52           N  
ATOM   3558  CA  SER F  34      35.918 115.288 -10.203  1.00 34.97           C  
ATOM   3559  C   SER F  34      36.637 115.222 -11.548  1.00 35.58           C  
ATOM   3560  O   SER F  34      36.050 115.443 -12.612  1.00 34.73           O  
ATOM   3561  CB  SER F  34      36.627 116.361  -9.375  1.00 34.66           C  
ATOM   3562  OG  SER F  34      35.963 116.617  -8.159  1.00 38.56           O  
ATOM   3563  N   ASP F  35      37.930 114.937 -11.480  1.00 37.23           N  
ATOM   3564  CA  ASP F  35      38.767 114.870 -12.667  1.00 39.50           C  
ATOM   3565  C   ASP F  35      38.355 113.727 -13.603  1.00 38.86           C  
ATOM   3566  O   ASP F  35      38.851 113.644 -14.727  1.00 38.95           O  
ATOM   3567  CB  ASP F  35      40.249 114.700 -12.257  1.00 42.83           C  
ATOM   3568  CG  ASP F  35      40.632 115.512 -10.991  1.00 47.46           C  
ATOM   3569  OD1 ASP F  35      40.410 116.746 -10.950  1.00 48.70           O  
ATOM   3570  OD2 ASP F  35      41.167 114.907 -10.030  1.00 46.98           O  
ATOM   3571  N   ASP F  36      37.429 112.873 -13.160  1.00 37.71           N  
ATOM   3572  CA  ASP F  36      37.025 111.718 -13.963  1.00 38.01           C  
ATOM   3573  C   ASP F  36      35.623 111.704 -14.567  1.00 37.52           C  
ATOM   3574  O   ASP F  36      35.456 111.401 -15.748  1.00 38.16           O  
ATOM   3575  CB  ASP F  36      37.232 110.444 -13.149  1.00 39.99           C  
ATOM   3576  CG  ASP F  36      38.583 110.413 -12.465  1.00 41.85           C  
ATOM   3577  OD1 ASP F  36      38.740 111.096 -11.427  1.00 43.65           O  
ATOM   3578  OD2 ASP F  36      39.488 109.721 -12.972  1.00 42.26           O  
ATOM   3579  N   LEU F  37      34.608 111.988 -13.761  1.00 36.96           N  
ATOM   3580  CA  LEU F  37      33.254 112.018 -14.285  1.00 34.83           C  
ATOM   3581  C   LEU F  37      33.139 113.291 -15.112  1.00 33.94           C  
ATOM   3582  O   LEU F  37      33.828 114.278 -14.846  1.00 35.48           O  
ATOM   3583  CB  LEU F  37      32.241 112.026 -13.144  1.00 34.82           C  
ATOM   3584  CG  LEU F  37      32.165 110.742 -12.308  1.00 35.56           C  
ATOM   3585  CD1 LEU F  37      31.252 110.975 -11.113  1.00 35.31           C  
ATOM   3586  CD2 LEU F  37      31.654 109.578 -13.166  1.00 32.03           C  
ATOM   3587  N   GLY F  38      32.292 113.269 -16.129  1.00 32.51           N  
ATOM   3588  CA  GLY F  38      32.156 114.446 -16.961  1.00 30.89           C  
ATOM   3589  C   GLY F  38      30.815 115.104 -16.775  1.00 29.39           C  
ATOM   3590  O   GLY F  38      30.573 116.223 -17.231  1.00 28.06           O  
ATOM   3591  N   LYS F  39      29.939 114.405 -16.071  1.00 30.93           N  
ATOM   3592  CA  LYS F  39      28.604 114.910 -15.842  1.00 30.72           C  
ATOM   3593  C   LYS F  39      27.853 113.848 -15.046  1.00 30.58           C  
ATOM   3594  O   LYS F  39      27.869 112.674 -15.402  1.00 31.61           O  
ATOM   3595  CB  LYS F  39      27.947 115.144 -17.210  1.00 31.13           C  
ATOM   3596  CG  LYS F  39      26.617 115.848 -17.216  1.00 36.52           C  
ATOM   3597  CD  LYS F  39      25.991 115.838 -18.615  1.00 37.24           C  
ATOM   3598  CE  LYS F  39      26.836 116.594 -19.631  1.00 40.35           C  
ATOM   3599  NZ  LYS F  39      26.129 116.747 -20.940  1.00 41.63           N  
ATOM   3600  N   VAL F  40      27.245 114.246 -13.942  1.00 31.10           N  
ATOM   3601  CA  VAL F  40      26.443 113.329 -13.146  1.00 31.80           C  
ATOM   3602  C   VAL F  40      25.032 113.910 -13.285  1.00 34.79           C  
ATOM   3603  O   VAL F  40      24.779 115.044 -12.860  1.00 36.98           O  
ATOM   3604  CB  VAL F  40      26.871 113.332 -11.673  1.00 30.37           C  
ATOM   3605  CG1 VAL F  40      25.950 112.450 -10.868  1.00 31.35           C  
ATOM   3606  CG2 VAL F  40      28.281 112.834 -11.549  1.00 29.28           C  
ATOM   3607  N   SER F  41      24.115 113.160 -13.889  1.00 35.06           N  
ATOM   3608  CA  SER F  41      22.761 113.671 -14.102  1.00 35.89           C  
ATOM   3609  C   SER F  41      21.684 113.178 -13.164  1.00 35.49           C  
ATOM   3610  O   SER F  41      21.702 112.033 -12.730  1.00 36.80           O  
ATOM   3611  CB  SER F  41      22.308 113.384 -15.536  1.00 35.51           C  
ATOM   3612  OG  SER F  41      23.139 114.052 -16.463  1.00 38.83           O  
ATOM   3613  N   LEU F  42      20.743 114.063 -12.859  1.00 36.33           N  
ATOM   3614  CA  LEU F  42      19.606 113.726 -12.017  1.00 37.78           C  
ATOM   3615  C   LEU F  42      18.378 113.723 -12.940  1.00 40.08           C  
ATOM   3616  O   LEU F  42      18.000 114.749 -13.508  1.00 38.24           O  
ATOM   3617  CB  LEU F  42      19.433 114.748 -10.888  1.00 35.75           C  
ATOM   3618  CG  LEU F  42      20.620 114.920  -9.935  1.00 35.22           C  
ATOM   3619  CD1 LEU F  42      20.209 115.775  -8.755  1.00 35.45           C  
ATOM   3620  CD2 LEU F  42      21.086 113.575  -9.444  1.00 35.32           C  
ATOM   3621  N   GLU F  43      17.777 112.550 -13.104  1.00 44.31           N  
ATOM   3622  CA  GLU F  43      16.621 112.396 -13.971  1.00 48.05           C  
ATOM   3623  C   GLU F  43      15.353 112.045 -13.199  1.00 50.41           C  
ATOM   3624  O   GLU F  43      15.219 110.933 -12.674  1.00 49.46           O  
ATOM   3625  CB  GLU F  43      16.903 111.305 -14.998  1.00 49.15           C  
ATOM   3626  CG  GLU F  43      15.906 111.231 -16.131  1.00 52.10           C  
ATOM   3627  CD  GLU F  43      16.185 110.061 -17.048  1.00 53.73           C  
ATOM   3628  OE1 GLU F  43      15.755 110.098 -18.223  1.00 54.56           O  
ATOM   3629  OE2 GLU F  43      16.833 109.099 -16.585  1.00 54.31           O  
ATOM   3630  N   PRO F  44      14.400 112.991 -13.119  1.00 52.74           N  
ATOM   3631  CA  PRO F  44      13.154 112.728 -12.400  1.00 54.94           C  
ATOM   3632  C   PRO F  44      12.291 111.679 -13.110  1.00 56.81           C  
ATOM   3633  O   PRO F  44      12.201 111.647 -14.342  1.00 56.38           O  
ATOM   3634  CB  PRO F  44      12.493 114.104 -12.344  1.00 54.03           C  
ATOM   3635  CG  PRO F  44      12.953 114.741 -13.605  1.00 53.51           C  
ATOM   3636  CD  PRO F  44      14.416 114.366 -13.647  1.00 53.79           C  
ATOM   3637  N   ALA F  45      11.679 110.812 -12.312  1.00 58.72           N  
ATOM   3638  CA  ALA F  45      10.820 109.752 -12.821  1.00 60.14           C  
ATOM   3639  C   ALA F  45       9.753 109.456 -11.770  1.00 61.01           C  
ATOM   3640  O   ALA F  45       9.679 110.126 -10.738  1.00 61.65           O  
ATOM   3641  CB  ALA F  45      11.645 108.502 -13.108  1.00 58.83           C  
ATOM   3642  N   THR F  46       8.932 108.450 -12.037  1.00 61.71           N  
ATOM   3643  CA  THR F  46       7.864 108.073 -11.120  1.00 61.24           C  
ATOM   3644  C   THR F  46       7.811 106.568 -10.940  1.00 61.25           C  
ATOM   3645  O   THR F  46       8.629 105.833 -11.494  1.00 62.19           O  
ATOM   3646  CB  THR F  46       6.508 108.520 -11.660  1.00 61.42           C  
ATOM   3647  OG1 THR F  46       6.435 108.204 -13.058  1.00 58.86           O  
ATOM   3648  CG2 THR F  46       6.312 110.022 -11.446  1.00 62.83           C  
ATOM   3649  N   GLY F  47       6.840 106.115 -10.161  1.00 60.05           N  
ATOM   3650  CA  GLY F  47       6.693 104.693  -9.936  1.00 59.10           C  
ATOM   3651  C   GLY F  47       7.693 104.151  -8.944  1.00 57.81           C  
ATOM   3652  O   GLY F  47       8.021 102.965  -8.973  1.00 58.53           O  
ATOM   3653  N   GLY F  48       8.176 105.025  -8.064  1.00 56.93           N  
ATOM   3654  CA  GLY F  48       9.141 104.615  -7.059  1.00 55.45           C  
ATOM   3655  C   GLY F  48      10.430 104.065  -7.641  1.00 54.66           C  
ATOM   3656  O   GLY F  48      11.104 103.243  -7.018  1.00 55.75           O  
ATOM   3657  N   ALA F  49      10.775 104.515  -8.842  1.00 52.20           N  
ATOM   3658  CA  ALA F  49      11.988 104.054  -9.492  1.00 49.92           C  
ATOM   3659  C   ALA F  49      13.210 104.697  -8.863  1.00 48.42           C  
ATOM   3660  O   ALA F  49      13.116 105.764  -8.256  1.00 47.28           O  
ATOM   3661  CB  ALA F  49      11.941 104.380 -10.979  1.00 51.05           C  
ATOM   3662  N   PHE F  50      14.346 104.016  -8.994  1.00 46.59           N  
ATOM   3663  CA  PHE F  50      15.631 104.495  -8.499  1.00 44.66           C  
ATOM   3664  C   PHE F  50      16.730 103.629  -9.100  1.00 45.22           C  
ATOM   3665  O   PHE F  50      17.088 102.583  -8.545  1.00 45.25           O  
ATOM   3666  CB  PHE F  50      15.719 104.435  -6.984  1.00 42.73           C  
ATOM   3667  CG  PHE F  50      16.881 105.195  -6.438  1.00 39.27           C  
ATOM   3668  CD1 PHE F  50      16.862 106.579  -6.412  1.00 39.58           C  
ATOM   3669  CD2 PHE F  50      18.015 104.531  -5.994  1.00 39.87           C  
ATOM   3670  CE1 PHE F  50      17.964 107.303  -5.950  1.00 41.19           C  
ATOM   3671  CE2 PHE F  50      19.127 105.241  -5.531  1.00 40.47           C  
ATOM   3672  CZ  PHE F  50      19.099 106.631  -5.508  1.00 40.01           C  
ATOM   3673  N   ARG F  51      17.253 104.077 -10.241  1.00 43.91           N  
ATOM   3674  CA  ARG F  51      18.293 103.365 -10.963  1.00 42.53           C  
ATOM   3675  C   ARG F  51      19.459 104.280 -11.343  1.00 42.83           C  
ATOM   3676  O   ARG F  51      19.268 105.378 -11.886  1.00 43.83           O  
ATOM   3677  CB  ARG F  51      17.691 102.734 -12.213  1.00 40.45           C  
ATOM   3678  CG  ARG F  51      18.587 101.714 -12.868  1.00 42.72           C  
ATOM   3679  CD  ARG F  51      17.835 100.922 -13.915  1.00 42.05           C  
ATOM   3680  NE  ARG F  51      17.719 101.658 -15.167  1.00 42.33           N  
ATOM   3681  CZ  ARG F  51      18.554 101.528 -16.192  1.00 43.63           C  
ATOM   3682  NH1 ARG F  51      19.573 100.679 -16.119  1.00 42.75           N  
ATOM   3683  NH2 ARG F  51      18.370 102.249 -17.293  1.00 43.92           N  
ATOM   3684  N   ILE F  52      20.673 103.820 -11.067  1.00 40.67           N  
ATOM   3685  CA  ILE F  52      21.862 104.601 -11.363  1.00 38.48           C  
ATOM   3686  C   ILE F  52      22.720 103.973 -12.450  1.00 38.25           C  
ATOM   3687  O   ILE F  52      23.372 102.967 -12.217  1.00 39.29           O  
ATOM   3688  CB  ILE F  52      22.718 104.751 -10.108  1.00 37.20           C  
ATOM   3689  CG1 ILE F  52      21.848 105.241  -8.955  1.00 36.71           C  
ATOM   3690  CG2 ILE F  52      23.847 105.729 -10.364  1.00 38.21           C  
ATOM   3691  CD1 ILE F  52      22.593 105.418  -7.649  1.00 37.90           C  
ATOM   3692  N   THR F  53      22.731 104.565 -13.638  1.00 39.33           N  
ATOM   3693  CA  THR F  53      23.545 104.029 -14.734  1.00 39.62           C  
ATOM   3694  C   THR F  53      24.849 104.797 -14.919  1.00 40.02           C  
ATOM   3695  O   THR F  53      24.942 105.978 -14.579  1.00 41.39           O  
ATOM   3696  CB  THR F  53      22.803 104.069 -16.084  1.00 39.01           C  
ATOM   3697  OG1 THR F  53      22.572 105.434 -16.468  1.00 37.59           O  
ATOM   3698  CG2 THR F  53      21.494 103.318 -15.985  1.00 37.00           C  
ATOM   3699  N   CYS F  54      25.855 104.118 -15.459  1.00 39.59           N  
ATOM   3700  CA  CYS F  54      27.146 104.745 -15.714  1.00 39.03           C  
ATOM   3701  C   CYS F  54      27.558 104.463 -17.146  1.00 39.06           C  
ATOM   3702  O   CYS F  54      27.873 103.331 -17.503  1.00 40.84           O  
ATOM   3703  CB  CYS F  54      28.220 104.220 -14.769  1.00 34.85           C  
ATOM   3704  SG  CYS F  54      29.830 104.901 -15.168  1.00 35.86           S  
ATOM   3705  N   ASP F  55      27.555 105.501 -17.968  1.00 40.02           N  
ATOM   3706  CA  ASP F  55      27.914 105.347 -19.366  1.00 40.96           C  
ATOM   3707  C   ASP F  55      27.036 104.282 -19.994  1.00 41.41           C  
ATOM   3708  O   ASP F  55      27.446 103.594 -20.926  1.00 42.71           O  
ATOM   3709  CB  ASP F  55      29.393 104.985 -19.501  1.00 39.32           C  
ATOM   3710  CG  ASP F  55      30.230 106.166 -19.955  1.00 40.78           C  
ATOM   3711  OD1 ASP F  55      29.747 107.310 -19.801  1.00 41.50           O  
ATOM   3712  OD2 ASP F  55      31.359 105.963 -20.460  1.00 41.30           O  
ATOM   3713  N   GLY F  56      25.819 104.155 -19.473  1.00 40.39           N  
ATOM   3714  CA  GLY F  56      24.885 103.184 -20.002  1.00 41.26           C  
ATOM   3715  C   GLY F  56      24.799 101.933 -19.157  1.00 42.15           C  
ATOM   3716  O   GLY F  56      23.741 101.306 -19.062  1.00 44.49           O  
ATOM   3717  N   VAL F  57      25.910 101.569 -18.531  1.00 39.89           N  
ATOM   3718  CA  VAL F  57      25.944 100.381 -17.707  1.00 37.43           C  
ATOM   3719  C   VAL F  57      25.235 100.586 -16.391  1.00 37.53           C  
ATOM   3720  O   VAL F  57      25.571 101.500 -15.644  1.00 37.44           O  
ATOM   3721  CB  VAL F  57      27.382  99.960 -17.401  1.00 37.48           C  
ATOM   3722  CG1 VAL F  57      27.381  98.758 -16.459  1.00 36.47           C  
ATOM   3723  CG2 VAL F  57      28.109  99.635 -18.692  1.00 36.16           C  
ATOM   3724  N   GLN F  58      24.259  99.732 -16.105  1.00 37.94           N  
ATOM   3725  CA  GLN F  58      23.535  99.820 -14.841  1.00 39.35           C  
ATOM   3726  C   GLN F  58      24.463  99.397 -13.677  1.00 39.37           C  
ATOM   3727  O   GLN F  58      25.175  98.396 -13.759  1.00 36.70           O  
ATOM   3728  CB  GLN F  58      22.281  98.932 -14.881  1.00 38.99           C  
ATOM   3729  CG  GLN F  58      21.400  99.064 -13.640  1.00 44.92           C  
ATOM   3730  CD  GLN F  58      20.065  98.327 -13.752  1.00 48.08           C  
ATOM   3731  OE1 GLN F  58      19.272  98.584 -14.663  1.00 48.63           O  
ATOM   3732  NE2 GLN F  58      19.808  97.418 -12.813  1.00 46.55           N  
ATOM   3733  N   ILE F  59      24.476 100.178 -12.602  1.00 39.93           N  
ATOM   3734  CA  ILE F  59      25.310  99.838 -11.466  1.00 43.07           C  
ATOM   3735  C   ILE F  59      24.490  99.832 -10.194  1.00 44.71           C  
ATOM   3736  O   ILE F  59      25.025  99.619  -9.103  1.00 45.30           O  
ATOM   3737  CB  ILE F  59      26.493 100.817 -11.283  1.00 45.01           C  
ATOM   3738  CG1 ILE F  59      25.958 102.229 -11.026  1.00 46.35           C  
ATOM   3739  CG2 ILE F  59      27.422 100.753 -12.500  1.00 44.62           C  
ATOM   3740  CD1 ILE F  59      27.025 103.248 -10.705  1.00 47.04           C  
ATOM   3741  N   TRP F  60      23.191 100.081 -10.336  1.00 46.51           N  
ATOM   3742  CA  TRP F  60      22.281 100.067  -9.191  1.00 49.44           C  
ATOM   3743  C   TRP F  60      20.825 100.240  -9.587  1.00 50.38           C  
ATOM   3744  O   TRP F  60      20.505 100.988 -10.503  1.00 51.85           O  
ATOM   3745  CB  TRP F  60      22.650 101.138  -8.169  1.00 50.09           C  
ATOM   3746  CG  TRP F  60      21.870 100.990  -6.905  1.00 52.23           C  
ATOM   3747  CD1 TRP F  60      20.633 101.484  -6.646  1.00 52.81           C  
ATOM   3748  CD2 TRP F  60      22.260 100.253  -5.741  1.00 53.87           C  
ATOM   3749  NE1 TRP F  60      20.222 101.104  -5.392  1.00 53.95           N  
ATOM   3750  CE2 TRP F  60      21.205 100.347  -4.813  1.00 54.41           C  
ATOM   3751  CE3 TRP F  60      23.405  99.522  -5.391  1.00 55.67           C  
ATOM   3752  CZ2 TRP F  60      21.253  99.737  -3.552  1.00 55.12           C  
ATOM   3753  CZ3 TRP F  60      23.456  98.914  -4.131  1.00 56.43           C  
ATOM   3754  CH2 TRP F  60      22.384  99.029  -3.231  1.00 55.64           C  
ATOM   3755  N   GLU F  61      19.948  99.541  -8.876  1.00 50.89           N  
ATOM   3756  CA  GLU F  61      18.518  99.594  -9.132  1.00 52.08           C  
ATOM   3757  C   GLU F  61      17.842  99.059  -7.874  1.00 53.83           C  
ATOM   3758  O   GLU F  61      17.993  97.897  -7.531  1.00 54.31           O  
ATOM   3759  CB  GLU F  61      18.177  98.735 -10.357  1.00 50.35           C  
ATOM   3760  CG  GLU F  61      16.719  98.770 -10.773  1.00 51.10           C  
ATOM   3761  CD  GLU F  61      15.809  98.058  -9.785  1.00 51.38           C  
ATOM   3762  OE1 GLU F  61      15.763  96.813  -9.801  1.00 50.12           O  
ATOM   3763  OE2 GLU F  61      15.142  98.749  -8.988  1.00 51.17           O  
ATOM   3764  N   ARG F  62      17.109  99.924  -7.185  1.00 56.60           N  
ATOM   3765  CA  ARG F  62      16.422  99.578  -5.936  1.00 59.13           C  
ATOM   3766  C   ARG F  62      15.961  98.122  -5.767  1.00 60.42           C  
ATOM   3767  O   ARG F  62      16.512  97.385  -4.946  1.00 59.77           O  
ATOM   3768  CB  ARG F  62      15.230 100.521  -5.748  1.00 59.67           C  
ATOM   3769  CG  ARG F  62      14.475 100.371  -4.435  1.00 59.19           C  
ATOM   3770  CD  ARG F  62      13.420 101.469  -4.307  1.00 57.57           C  
ATOM   3771  NE  ARG F  62      12.441 101.427  -5.395  1.00 55.34           N  
ATOM   3772  CZ  ARG F  62      11.320 100.712  -5.368  1.00 55.34           C  
ATOM   3773  NH1 ARG F  62      11.026  99.979  -4.301  1.00 55.05           N  
ATOM   3774  NH2 ARG F  62      10.501 100.722  -6.412  1.00 53.28           N  
ATOM   3775  N   LYS F  63      14.949  97.722  -6.539  1.00 62.20           N  
ATOM   3776  CA  LYS F  63      14.374  96.370  -6.488  1.00 62.74           C  
ATOM   3777  C   LYS F  63      15.390  95.231  -6.609  1.00 61.82           C  
ATOM   3778  O   LYS F  63      15.271  94.204  -5.935  1.00 61.11           O  
ATOM   3779  CB  LYS F  63      13.313  96.226  -7.591  1.00 64.33           C  
ATOM   3780  CG  LYS F  63      12.164  97.228  -7.470  1.00 67.77           C  
ATOM   3781  CD  LYS F  63      11.468  97.506  -8.805  1.00 69.13           C  
ATOM   3782  CE  LYS F  63      10.616  96.341  -9.282  1.00 69.45           C  
ATOM   3783  NZ  LYS F  63       9.840  96.716 -10.499  1.00 69.62           N  
ATOM   3784  N   ALA F  64      16.386  95.426  -7.469  1.00 61.53           N  
ATOM   3785  CA  ALA F  64      17.423  94.426  -7.713  1.00 59.98           C  
ATOM   3786  C   ALA F  64      18.556  94.390  -6.685  1.00 59.18           C  
ATOM   3787  O   ALA F  64      19.066  93.320  -6.375  1.00 60.46           O  
ATOM   3788  CB  ALA F  64      18.006  94.620  -9.116  1.00 59.40           C  
ATOM   3789  N   ASP F  65      18.951  95.542  -6.154  1.00 58.10           N  
ATOM   3790  CA  ASP F  65      20.041  95.585  -5.182  1.00 57.02           C  
ATOM   3791  C   ASP F  65      19.565  95.782  -3.757  1.00 56.70           C  
ATOM   3792  O   ASP F  65      20.372  96.016  -2.855  1.00 56.88           O  
ATOM   3793  CB  ASP F  65      21.028  96.692  -5.542  1.00 56.52           C  
ATOM   3794  CG  ASP F  65      21.623  96.505  -6.911  1.00 56.11           C  
ATOM   3795  OD1 ASP F  65      22.334  95.496  -7.120  1.00 54.78           O  
ATOM   3796  OD2 ASP F  65      21.371  97.367  -7.778  1.00 55.82           O  
ATOM   3797  N   GLY F  66      18.251  95.709  -3.564  1.00 56.73           N  
ATOM   3798  CA  GLY F  66      17.682  95.853  -2.234  1.00 55.68           C  
ATOM   3799  C   GLY F  66      17.481  97.261  -1.712  1.00 54.54           C  
ATOM   3800  O   GLY F  66      17.464  97.467  -0.499  1.00 53.49           O  
ATOM   3801  N   GLY F  67      17.335  98.230  -2.611  1.00 54.82           N  
ATOM   3802  CA  GLY F  67      17.121  99.599  -2.175  1.00 55.11           C  
ATOM   3803  C   GLY F  67      18.066 100.650  -2.727  1.00 55.02           C  
ATOM   3804  O   GLY F  67      18.358 100.689  -3.921  1.00 53.86           O  
ATOM   3805  N   PHE F  68      18.535 101.515  -1.837  1.00 54.82           N  
ATOM   3806  CA  PHE F  68      19.444 102.597  -2.193  1.00 55.05           C  
ATOM   3807  C   PHE F  68      20.835 102.196  -1.734  1.00 53.77           C  
ATOM   3808  O   PHE F  68      20.993 101.532  -0.717  1.00 54.16           O  
ATOM   3809  CB  PHE F  68      18.988 103.874  -1.502  1.00 56.11           C  
ATOM   3810  CG  PHE F  68      17.500 104.034  -1.493  1.00 57.11           C  
ATOM   3811  CD1 PHE F  68      16.808 104.279  -2.672  1.00 58.58           C  
ATOM   3812  CD2 PHE F  68      16.778 103.868  -0.315  1.00 57.73           C  
ATOM   3813  CE1 PHE F  68      15.413 104.355  -2.680  1.00 59.55           C  
ATOM   3814  CE2 PHE F  68      15.389 103.940  -0.311  1.00 57.90           C  
ATOM   3815  CZ  PHE F  68      14.708 104.182  -1.498  1.00 59.01           C  
ATOM   3816  N   PRO F  69      21.867 102.606  -2.472  1.00 52.26           N  
ATOM   3817  CA  PRO F  69      23.231 102.242  -2.099  1.00 51.44           C  
ATOM   3818  C   PRO F  69      23.874 103.055  -0.981  1.00 50.12           C  
ATOM   3819  O   PRO F  69      23.486 104.190  -0.725  1.00 50.45           O  
ATOM   3820  CB  PRO F  69      23.970 102.399  -3.414  1.00 51.26           C  
ATOM   3821  CG  PRO F  69      23.339 103.630  -3.960  1.00 50.23           C  
ATOM   3822  CD  PRO F  69      21.865 103.406  -3.709  1.00 50.89           C  
ATOM   3823  N   GLU F  70      24.856 102.450  -0.313  1.00 48.55           N  
ATOM   3824  CA  GLU F  70      25.604 103.132   0.734  1.00 46.39           C  
ATOM   3825  C   GLU F  70      26.538 104.018  -0.080  1.00 44.85           C  
ATOM   3826  O   GLU F  70      26.825 103.711  -1.236  1.00 45.39           O  
ATOM   3827  CB  GLU F  70      26.447 102.152   1.553  1.00 45.78           C  
ATOM   3828  CG  GLU F  70      25.773 100.834   1.887  1.00 47.48           C  
ATOM   3829  CD  GLU F  70      26.571 100.020   2.896  1.00 48.46           C  
ATOM   3830  OE1 GLU F  70      26.835 100.549   3.994  1.00 50.02           O  
ATOM   3831  OE2 GLU F  70      26.933  98.860   2.600  1.00 46.86           O  
ATOM   3832  N   ALA F  71      27.023 105.104   0.500  1.00 43.02           N  
ATOM   3833  CA  ALA F  71      27.906 105.969  -0.263  1.00 41.74           C  
ATOM   3834  C   ALA F  71      29.127 105.215  -0.774  1.00 40.86           C  
ATOM   3835  O   ALA F  71      29.463 105.303  -1.954  1.00 40.71           O  
ATOM   3836  CB  ALA F  71      28.338 107.162   0.575  1.00 41.27           C  
ATOM   3837  N   LYS F  72      29.782 104.458   0.101  1.00 39.96           N  
ATOM   3838  CA  LYS F  72      30.981 103.735  -0.306  1.00 38.95           C  
ATOM   3839  C   LYS F  72      30.757 102.673  -1.374  1.00 37.10           C  
ATOM   3840  O   LYS F  72      31.640 102.444  -2.191  1.00 37.57           O  
ATOM   3841  CB  LYS F  72      31.678 103.106   0.908  1.00 40.39           C  
ATOM   3842  CG  LYS F  72      31.180 101.723   1.308  1.00 43.79           C  
ATOM   3843  CD  LYS F  72      31.991 101.181   2.481  1.00 45.72           C  
ATOM   3844  CE  LYS F  72      31.856  99.659   2.623  1.00 47.31           C  
ATOM   3845  NZ  LYS F  72      30.469  99.177   2.893  1.00 47.11           N  
ATOM   3846  N   VAL F  73      29.590 102.033  -1.388  1.00 35.55           N  
ATOM   3847  CA  VAL F  73      29.331 100.992  -2.380  1.00 35.72           C  
ATOM   3848  C   VAL F  73      29.142 101.539  -3.787  1.00 35.77           C  
ATOM   3849  O   VAL F  73      29.575 100.925  -4.758  1.00 35.38           O  
ATOM   3850  CB  VAL F  73      28.105 100.132  -2.001  1.00 36.20           C  
ATOM   3851  CG1 VAL F  73      27.861  99.051  -3.050  1.00 31.22           C  
ATOM   3852  CG2 VAL F  73      28.344  99.479  -0.656  1.00 37.66           C  
ATOM   3853  N   LEU F  74      28.497 102.689  -3.913  1.00 35.70           N  
ATOM   3854  CA  LEU F  74      28.326 103.254  -5.239  1.00 36.42           C  
ATOM   3855  C   LEU F  74      29.690 103.721  -5.741  1.00 37.76           C  
ATOM   3856  O   LEU F  74      30.032 103.532  -6.909  1.00 39.29           O  
ATOM   3857  CB  LEU F  74      27.360 104.436  -5.218  1.00 35.94           C  
ATOM   3858  CG  LEU F  74      27.025 104.976  -6.611  1.00 36.09           C  
ATOM   3859  CD1 LEU F  74      26.171 103.954  -7.361  1.00 36.83           C  
ATOM   3860  CD2 LEU F  74      26.291 106.292  -6.488  1.00 33.14           C  
ATOM   3861  N   LYS F  75      30.481 104.326  -4.863  1.00 37.32           N  
ATOM   3862  CA  LYS F  75      31.794 104.789  -5.285  1.00 37.82           C  
ATOM   3863  C   LYS F  75      32.614 103.634  -5.851  1.00 37.78           C  
ATOM   3864  O   LYS F  75      33.266 103.776  -6.889  1.00 38.06           O  
ATOM   3865  CB  LYS F  75      32.532 105.443  -4.119  1.00 38.00           C  
ATOM   3866  CG  LYS F  75      31.819 106.656  -3.561  1.00 38.47           C  
ATOM   3867  CD  LYS F  75      32.715 107.452  -2.642  1.00 38.20           C  
ATOM   3868  CE  LYS F  75      32.009 108.694  -2.161  1.00 37.88           C  
ATOM   3869  NZ  LYS F  75      32.968 109.689  -1.616  1.00 42.68           N  
ATOM   3870  N   GLN F  76      32.583 102.491  -5.173  1.00 37.33           N  
ATOM   3871  CA  GLN F  76      33.324 101.326  -5.640  1.00 36.75           C  
ATOM   3872  C   GLN F  76      32.820 100.937  -7.021  1.00 35.73           C  
ATOM   3873  O   GLN F  76      33.605 100.771  -7.952  1.00 35.66           O  
ATOM   3874  CB  GLN F  76      33.138 100.137  -4.695  1.00 36.03           C  
ATOM   3875  CG  GLN F  76      33.608 100.365  -3.280  1.00 36.03           C  
ATOM   3876  CD  GLN F  76      33.136  99.267  -2.335  1.00 38.43           C  
ATOM   3877  OE1 GLN F  76      33.318  99.355  -1.119  1.00 38.19           O  
ATOM   3878  NE2 GLN F  76      32.527  98.222  -2.895  1.00 41.17           N  
ATOM   3879  N   ARG F  77      31.502 100.809  -7.150  1.00 35.71           N  
ATOM   3880  CA  ARG F  77      30.892 100.418  -8.415  1.00 35.37           C  
ATOM   3881  C   ARG F  77      31.258 101.304  -9.591  1.00 35.30           C  
ATOM   3882  O   ARG F  77      31.560 100.794 -10.668  1.00 34.77           O  
ATOM   3883  CB  ARG F  77      29.379 100.334  -8.259  1.00 36.16           C  
ATOM   3884  CG  ARG F  77      28.974  99.340  -7.185  1.00 37.52           C  
ATOM   3885  CD  ARG F  77      27.600  98.734  -7.419  1.00 38.37           C  
ATOM   3886  NE  ARG F  77      27.171  97.969  -6.248  1.00 40.15           N  
ATOM   3887  CZ  ARG F  77      26.155  97.112  -6.229  1.00 39.60           C  
ATOM   3888  NH1 ARG F  77      25.446  96.889  -7.326  1.00 40.24           N  
ATOM   3889  NH2 ARG F  77      25.844  96.485  -5.104  1.00 41.36           N  
ATOM   3890  N   VAL F  78      31.240 102.623  -9.389  1.00 36.43           N  
ATOM   3891  CA  VAL F  78      31.605 103.561 -10.454  1.00 36.29           C  
ATOM   3892  C   VAL F  78      33.108 103.443 -10.686  1.00 37.69           C  
ATOM   3893  O   VAL F  78      33.575 103.574 -11.817  1.00 38.68           O  
ATOM   3894  CB  VAL F  78      31.236 105.038 -10.100  1.00 35.39           C  
ATOM   3895  CG1 VAL F  78      31.813 106.003 -11.131  1.00 31.55           C  
ATOM   3896  CG2 VAL F  78      29.723 105.200 -10.057  1.00 33.93           C  
ATOM   3897  N   ARG F  79      33.871 103.192  -9.623  1.00 39.11           N  
ATOM   3898  CA  ARG F  79      35.308 103.029  -9.791  1.00 40.04           C  
ATOM   3899  C   ARG F  79      35.560 101.756 -10.583  1.00 41.57           C  
ATOM   3900  O   ARG F  79      36.285 101.772 -11.577  1.00 42.20           O  
ATOM   3901  CB  ARG F  79      36.043 102.918  -8.461  1.00 38.06           C  
ATOM   3902  CG  ARG F  79      37.464 102.369  -8.658  1.00 37.86           C  
ATOM   3903  CD  ARG F  79      37.599 100.914  -8.223  1.00 33.55           C  
ATOM   3904  NE  ARG F  79      37.834 100.881  -6.789  1.00 33.79           N  
ATOM   3905  CZ  ARG F  79      37.293 100.004  -5.963  1.00 34.09           C  
ATOM   3906  NH1 ARG F  79      36.482  99.071  -6.437  1.00 36.99           N  
ATOM   3907  NH2 ARG F  79      37.534 100.089  -4.661  1.00 35.77           N  
ATOM   3908  N   ASP F  80      34.971 100.651 -10.133  1.00 42.81           N  
ATOM   3909  CA  ASP F  80      35.132  99.372 -10.822  1.00 44.22           C  
ATOM   3910  C   ASP F  80      34.802  99.540 -12.307  1.00 44.59           C  
ATOM   3911  O   ASP F  80      35.238  98.750 -13.143  1.00 46.03           O  
ATOM   3912  CB  ASP F  80      34.210  98.313 -10.206  1.00 44.03           C  
ATOM   3913  CG  ASP F  80      34.749  97.745  -8.908  1.00 44.73           C  
ATOM   3914  OD1 ASP F  80      33.986  97.070  -8.188  1.00 44.73           O  
ATOM   3915  OD2 ASP F  80      35.937  97.958  -8.608  1.00 48.68           O  
ATOM   3916  N   GLN F  81      34.038 100.580 -12.617  1.00 43.46           N  
ATOM   3917  CA  GLN F  81      33.624 100.885 -13.979  1.00 43.90           C  
ATOM   3918  C   GLN F  81      34.613 101.713 -14.815  1.00 44.17           C  
ATOM   3919  O   GLN F  81      35.002 101.315 -15.918  1.00 45.18           O  
ATOM   3920  CB  GLN F  81      32.298 101.637 -13.939  1.00 44.26           C  
ATOM   3921  CG  GLN F  81      31.098 100.793 -13.611  1.00 46.91           C  
ATOM   3922  CD  GLN F  81      30.626  99.980 -14.798  1.00 48.12           C  
ATOM   3923  OE1 GLN F  81      30.424 100.513 -15.894  1.00 48.15           O  
ATOM   3924  NE2 GLN F  81      30.437  98.683 -14.585  1.00 47.81           N  
ATOM   3925  N   ILE F  82      34.998 102.873 -14.288  1.00 43.02           N  
ATOM   3926  CA  ILE F  82      35.880 103.796 -14.994  1.00 42.97           C  
ATOM   3927  C   ILE F  82      37.340 103.829 -14.553  1.00 42.99           C  
ATOM   3928  O   ILE F  82      38.164 104.498 -15.177  1.00 43.40           O  
ATOM   3929  CB  ILE F  82      35.341 105.241 -14.881  1.00 43.70           C  
ATOM   3930  CG1 ILE F  82      35.320 105.662 -13.409  1.00 43.49           C  
ATOM   3931  CG2 ILE F  82      33.943 105.331 -15.469  1.00 42.85           C  
ATOM   3932  CD1 ILE F  82      34.996 107.104 -13.183  1.00 40.94           C  
ATOM   3933  N   ASP F  83      37.670 103.106 -13.492  1.00 42.80           N  
ATOM   3934  CA  ASP F  83      39.036 103.118 -12.982  1.00 40.72           C  
ATOM   3935  C   ASP F  83      39.186 101.952 -12.010  1.00 39.86           C  
ATOM   3936  O   ASP F  83      39.427 102.141 -10.811  1.00 39.83           O  
ATOM   3937  CB  ASP F  83      39.276 104.444 -12.252  1.00 40.50           C  
ATOM   3938  CG  ASP F  83      40.735 104.785 -12.121  1.00 39.19           C  
ATOM   3939  OD1 ASP F  83      41.041 105.793 -11.457  1.00 40.74           O  
ATOM   3940  OD2 ASP F  83      41.573 104.058 -12.683  1.00 40.46           O  
ATOM   3941  N   PRO F  84      39.044 100.723 -12.516  1.00 38.22           N  
ATOM   3942  CA  PRO F  84      39.173  99.577 -11.621  1.00 37.59           C  
ATOM   3943  C   PRO F  84      40.405  99.666 -10.734  1.00 36.67           C  
ATOM   3944  O   PRO F  84      40.323  99.544  -9.519  1.00 37.13           O  
ATOM   3945  CB  PRO F  84      39.224  98.398 -12.592  1.00 36.54           C  
ATOM   3946  CG  PRO F  84      39.807  98.982 -13.820  1.00 34.52           C  
ATOM   3947  CD  PRO F  84      39.083 100.294 -13.922  1.00 37.09           C  
ATOM   3948  N   GLU F  85      41.534  99.925 -11.377  1.00 36.06           N  
ATOM   3949  CA  GLU F  85      42.840 100.012 -10.748  1.00 35.09           C  
ATOM   3950  C   GLU F  85      43.018 101.001  -9.611  1.00 35.65           C  
ATOM   3951  O   GLU F  85      44.084 101.028  -9.001  1.00 36.96           O  
ATOM   3952  CB  GLU F  85      43.870 100.327 -11.827  1.00 34.75           C  
ATOM   3953  CG  GLU F  85      45.031  99.372 -11.923  1.00 31.95           C  
ATOM   3954  CD  GLU F  85      45.682  99.423 -13.291  1.00 32.23           C  
ATOM   3955  OE1 GLU F  85      45.016  99.038 -14.277  1.00 28.65           O  
ATOM   3956  OE2 GLU F  85      46.852  99.854 -13.387  1.00 33.24           O  
ATOM   3957  N   ARG F  86      42.001 101.800  -9.305  1.00 37.09           N  
ATOM   3958  CA  ARG F  86      42.152 102.803  -8.254  1.00 38.70           C  
ATOM   3959  C   ARG F  86      41.756 102.436  -6.830  1.00 39.60           C  
ATOM   3960  O   ARG F  86      40.614 102.076  -6.567  1.00 39.91           O  
ATOM   3961  CB  ARG F  86      41.405 104.076  -8.619  1.00 38.77           C  
ATOM   3962  CG  ARG F  86      41.728 105.183  -7.646  1.00 40.75           C  
ATOM   3963  CD  ARG F  86      40.598 106.149  -7.469  1.00 41.88           C  
ATOM   3964  NE  ARG F  86      40.247 106.813  -8.713  1.00 43.14           N  
ATOM   3965  CZ  ARG F  86      39.454 107.877  -8.774  1.00 45.39           C  
ATOM   3966  NH1 ARG F  86      38.946 108.382  -7.645  1.00 41.94           N  
ATOM   3967  NH2 ARG F  86      39.164 108.422  -9.957  1.00 43.00           N  
ATOM   3968  N   ASP F  87      42.697 102.578  -5.903  1.00 40.48           N  
ATOM   3969  CA  ASP F  87      42.425 102.273  -4.506  1.00 43.27           C  
ATOM   3970  C   ASP F  87      41.732 103.444  -3.855  1.00 43.74           C  
ATOM   3971  O   ASP F  87      42.348 104.469  -3.610  1.00 44.70           O  
ATOM   3972  CB  ASP F  87      43.725 101.958  -3.761  1.00 44.32           C  
ATOM   3973  CG  ASP F  87      43.521 101.779  -2.258  1.00 45.14           C  
ATOM   3974  OD1 ASP F  87      42.423 101.337  -1.838  1.00 45.42           O  
ATOM   3975  OD2 ASP F  87      44.480 102.067  -1.505  1.00 44.40           O  
ATOM   3976  N   LEU F  88      40.445 103.279  -3.574  1.00 46.65           N  
ATOM   3977  CA  LEU F  88      39.640 104.330  -2.956  1.00 48.48           C  
ATOM   3978  C   LEU F  88      39.920 104.525  -1.461  1.00 50.86           C  
ATOM   3979  O   LEU F  88      39.044 104.974  -0.721  1.00 50.15           O  
ATOM   3980  CB  LEU F  88      38.149 104.036  -3.166  1.00 47.20           C  
ATOM   3981  CG  LEU F  88      37.634 104.022  -4.612  1.00 46.95           C  
ATOM   3982  CD1 LEU F  88      36.208 103.482  -4.663  1.00 44.13           C  
ATOM   3983  CD2 LEU F  88      37.711 105.427  -5.192  1.00 45.75           C  
ATOM   3984  N   GLY F  89      41.138 104.196  -1.029  1.00 53.30           N  
ATOM   3985  CA  GLY F  89      41.507 104.346   0.374  1.00 55.26           C  
ATOM   3986  C   GLY F  89      40.640 103.555   1.345  1.00 56.24           C  
ATOM   3987  O   GLY F  89      40.174 104.138   2.351  1.00 55.65           O  
TER    3988      GLY F  89                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
