
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  105 (  807),  selected  105 , name 1nsw_A
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 1nsw_A.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      -       -           -
LGA    T     2_A      -       -           -
LGA    M     3_A      -       -           -
LGA    T     4_A      -       -           -
LGA    L     5_A      -       -           -
LGA    T     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    A     8_A      -       -           -
LGA    N     9_A      -       -           -
LGA    F    10_A      -       -           -
LGA    Q    11_A      -       -           -
LGA    Q    12_A      -       -           -
LGA    A    13_A      -       -           -
LGA    I    14_A      -       -           -
LGA    Q    15_A      -       -           -
LGA    G    16_A      -       -           -
LGA    D    17_A      -       -           -
LGA    G    18_A      T      12          3.082
LGA    P    19_A      H      13          1.737
LGA    V    20_A      R      14          1.003
LGA    L    21_A      V      15          0.994
LGA    V    22_A      Q      16          0.680
LGA    D    23_A      I      17          0.864
LGA    F    24_A      E      18          0.977
LGA    W    25_A      Y      19          2.006
LGA    A    26_A      C      20          3.887
LGA    A    27_A      T      21          3.309
LGA    W    28_A      Q      22          2.347
LGA    C    29_A      C      23          2.055
LGA    G    30_A      R      24          4.218
LGA    P    31_A      W      25          4.617
LGA    C    32_A      L      26          4.882
LGA    R    33_A      P      27          2.917
LGA    M    34_A      R      28          2.153
LGA    M    35_A      A      29          3.328
LGA    A    36_A      A      30          1.835
LGA    P    37_A      W      31          1.084
LGA    V    38_A      L      32          2.450
LGA    L    39_A      A      33          1.753
LGA    E    40_A      Q      34          1.395
LGA    E    41_A      E      35          2.745
LGA    F    42_A      L      36          1.727
LGA    A    43_A      L      37          0.912
LGA    E    44_A      T      38          2.469
LGA    A    45_A      T      39          2.449
LGA    H    46_A      F      40          0.891
LGA    A    47_A      E      41          1.244
LGA    D    48_A      T      42          1.221
LGA    K    49_A      E      43          1.266
LGA    V    50_A      L      44          2.102
LGA    -       -      T      45           -
LGA    T    51_A      E      46          2.573
LGA    V    52_A      L      47          1.280
LGA    A    53_A      A      48          0.894
LGA    K    54_A      L      49          0.936
LGA    L    55_A      K      50          1.304
LGA    N    56_A      P      51          1.702
LGA    V    57_A      G      52          3.029
LGA    D    58_A      T      53           #
LGA    E    59_A      G      54           -
LGA    N    60_A      -       -           -
LGA    P    61_A      -       -           -
LGA    E    62_A      -       -           -
LGA    T    63_A      -       -           -
LGA    T    64_A      -       -           -
LGA    S    65_A      -       -           -
LGA    Q    66_A      -       -           -
LGA    F    67_A      -       -           -
LGA    G    68_A      -       -           -
LGA    I    69_A      -       -           -
LGA    M    70_A      -       -           -
LGA    S    71_A      G      55          4.789
LGA    I    72_A      V      56          1.046
LGA    P    73_A      F      57          0.891
LGA    T    74_A      V      58          1.110
LGA    L    75_A      V      59          1.308
LGA    I    76_A      R      60          1.430
LGA    L    77_A      V      61          1.213
LGA    F    78_A      D      62          1.004
LGA    K    79_A      -       -           -
LGA    G    80_A      -       -           -
LGA    G    81_A      -       -           -
LGA    R    82_A      -       -           -
LGA    P    83_A      D      63          2.251
LGA    V    84_A      E      64          2.666
LGA    K    85_A      V      65          3.050
LGA    Q    86_A      V      66          3.255
LGA    L    87_A      W      67          1.096
LGA    I    88_A      D      68          0.806
LGA    G    89_A      R      69          1.724
LGA    -       -      R      70           -
LGA    -       -      E      71           -
LGA    -       -      Q      72           -
LGA    -       -      G      73           -
LGA    Y    90_A      F      74          2.979
LGA    Q    91_A      P      75          0.817
LGA    P    92_A      E      76          1.907
LGA    K    93_A      P      77          1.122
LGA    E    94_A      T      78          0.563
LGA    Q    95_A      A      79          1.355
LGA    L    96_A      V      80          1.412
LGA    E    97_A      K      81          1.265
LGA    A    98_A      R      82          1.642
LGA    Q    99_A      L      83          1.382
LGA    L   100_A      V      84          1.261
LGA    A   101_A      R      85          2.146
LGA    D   102_A      D      86          1.474
LGA    V   103_A      R      87          3.040
LGA    L   104_A      V      88          4.027
LGA    Q   105_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  105   77    5.0     70    2.22     7.14     70.586     3.021

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.640793 * X  +   0.419645 * Y  +   0.642871 * Z  + -35.797626
  Y_new =  -0.535852 * X  +   0.844143 * Y  +  -0.016908 * Z  +  89.056664
  Z_new =  -0.549770 * X  +  -0.333649 * Y  +   0.765788 * Z  + -24.446335 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.410893    2.730699  [ DEG:   -23.5424    156.4576 ]
  Theta =   0.582089    2.559504  [ DEG:    33.3512    146.6488 ]
  Phi   =  -0.696447    2.445146  [ DEG:   -39.9035    140.0965 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1nsw_A                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1nsw_A.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  105   77   5.0   70   2.22    7.14  70.586
REMARK  ---------------------------------------------------------- 
MOLECULE 1nsw_A
HEADER    ELECTRON TRANSPORT                      28-JAN-03   1NSW              
TITLE     THE CRYSTAL STRUCTURE OF THE K18G MUTANT OF THE THIOREDOXIN           
TITLE    2 FROM ALICYCLOBACILLUS ACIDOCALDARIUS                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOREDOXIN;                                               
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: TRX;                                                        
COMPND   5 EC: 1.8.1.9;                                                         
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ALICYCLOBACILLUS ACIDOCALDARIUS;                
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    THERMOSTABILITY, THIOREDOXIN                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.BARTOLUCCI,G.DE SIMONE,S.GALDIERO,R.IMPROTA,V.MENCHISE,             
AUTHOR   2 C.PEDONE,E.PEDONE,M.SAVIANO                                          
REVDAT   1   05-AUG-03 1NSW    0                                                
JRNL        AUTH   S.BARTOLUCCI,G.DE SIMONE,S.GALDIERO,R.IMPROTA,               
JRNL        AUTH 2 V.MENCHISE,C.PEDONE,E.PEDONE,M.SAVIANO                       
JRNL        TITL   AN INTEGRATED STRUCTURAL AND COMPUTATIONAL STUDY             
JRNL        TITL 2 OF THE THERMOSTABILITY OF TWO THIOREDOXIN MUTANTS            
JRNL        TITL 3 FROM ALICYCLOBACILLUS ACIDOCALDARIUS                         
JRNL        REF    J.BACTERIOL.                  V. 185  4285 2003              
JRNL        REFN   ASTM JOBAAY  US ISSN 0021-9193                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1NSW A    1   105  UNP    P80579   THIO_ALIAC       1    105             
DBREF  1NSW B    1   105  UNP    P80579   THIO_ALIAC       1    105             
DBREF  1NSW C    1   105  UNP    P80579   THIO_ALIAC       1    105             
DBREF  1NSW D    1   105  UNP    P80579   THIO_ALIAC       1    105             
SEQRES   1 A  105  ALA THR MET THR LEU THR ASP ALA ASN PHE GLN GLN ALA          
SEQRES   2 A  105  ILE GLN GLY ASP GLY PRO VAL LEU VAL ASP PHE TRP ALA          
SEQRES   3 A  105  ALA TRP CYS GLY PRO CYS ARG MET MET ALA PRO VAL LEU          
SEQRES   4 A  105  GLU GLU PHE ALA GLU ALA HIS ALA ASP LYS VAL THR VAL          
SEQRES   5 A  105  ALA LYS LEU ASN VAL ASP GLU ASN PRO GLU THR THR SER          
SEQRES   6 A  105  GLN PHE GLY ILE MET SER ILE PRO THR LEU ILE LEU PHE          
SEQRES   7 A  105  LYS GLY GLY ARG PRO VAL LYS GLN LEU ILE GLY TYR GLN          
SEQRES   8 A  105  PRO LYS GLU GLN LEU GLU ALA GLN LEU ALA ASP VAL LEU          
SEQRES   9 A  105  GLN                                                          
SEQRES   1 B  105  ALA THR MET THR LEU THR ASP ALA ASN PHE GLN GLN ALA          
SEQRES   2 B  105  ILE GLN GLY ASP GLY PRO VAL LEU VAL ASP PHE TRP ALA          
SEQRES   3 B  105  ALA TRP CYS GLY PRO CYS ARG MET MET ALA PRO VAL LEU          
SEQRES   4 B  105  GLU GLU PHE ALA GLU ALA HIS ALA ASP LYS VAL THR VAL          
SEQRES   5 B  105  ALA LYS LEU ASN VAL ASP GLU ASN PRO GLU THR THR SER          
SEQRES   6 B  105  GLN PHE GLY ILE MET SER ILE PRO THR LEU ILE LEU PHE          
SEQRES   7 B  105  LYS GLY GLY ARG PRO VAL LYS GLN LEU ILE GLY TYR GLN          
SEQRES   8 B  105  PRO LYS GLU GLN LEU GLU ALA GLN LEU ALA ASP VAL LEU          
SEQRES   9 B  105  GLN                                                          
SEQRES   1 C  105  ALA THR MET THR LEU THR ASP ALA ASN PHE GLN GLN ALA          
SEQRES   2 C  105  ILE GLN GLY ASP GLY PRO VAL LEU VAL ASP PHE TRP ALA          
SEQRES   3 C  105  ALA TRP CYS GLY PRO CYS ARG MET MET ALA PRO VAL LEU          
SEQRES   4 C  105  GLU GLU PHE ALA GLU ALA HIS ALA ASP LYS VAL THR VAL          
SEQRES   5 C  105  ALA LYS LEU ASN VAL ASP GLU ASN PRO GLU THR THR SER          
SEQRES   6 C  105  GLN PHE GLY ILE MET SER ILE PRO THR LEU ILE LEU PHE          
SEQRES   7 C  105  LYS GLY GLY ARG PRO VAL LYS GLN LEU ILE GLY TYR GLN          
SEQRES   8 C  105  PRO LYS GLU GLN LEU GLU ALA GLN LEU ALA ASP VAL LEU          
SEQRES   9 C  105  GLN                                                          
SEQRES   1 D  105  ALA THR MET THR LEU THR ASP ALA ASN PHE GLN GLN ALA          
SEQRES   2 D  105  ILE GLN GLY ASP GLY PRO VAL LEU VAL ASP PHE TRP ALA          
SEQRES   3 D  105  ALA TRP CYS GLY PRO CYS ARG MET MET ALA PRO VAL LEU          
SEQRES   4 D  105  GLU GLU PHE ALA GLU ALA HIS ALA ASP LYS VAL THR VAL          
SEQRES   5 D  105  ALA LYS LEU ASN VAL ASP GLU ASN PRO GLU THR THR SER          
SEQRES   6 D  105  GLN PHE GLY ILE MET SER ILE PRO THR LEU ILE LEU PHE          
SEQRES   7 D  105  LYS GLY GLY ARG PRO VAL LYS GLN LEU ILE GLY TYR GLN          
SEQRES   8 D  105  PRO LYS GLU GLN LEU GLU ALA GLN LEU ALA ASP VAL LEU          
SEQRES   9 D  105  GLN                                                          
FORMUL   5  HOH   *242(H2 O)                                                    
CRYST1   46.730   73.890   54.910  90.00 103.79  90.00 P 1 21 1      8          
ATOM      1  N   ALA A   1      28.815 117.981 -11.179  1.00 35.86           N  
ATOM      2  CA  ALA A   1      28.318 118.455  -9.861  1.00 38.78           C  
ATOM      3  C   ALA A   1      26.813 118.239  -9.864  1.00 39.39           C  
ATOM      4  O   ALA A   1      26.059 118.881  -9.144  1.00 42.91           O  
ATOM      5  CB  ALA A   1      28.652 119.923  -9.678  1.00 41.75           C  
ATOM      6  N   THR A   2      26.422 117.278 -10.681  1.00 38.98           N  
ATOM      7  CA  THR A   2      25.041 116.920 -10.911  1.00 37.57           C  
ATOM      8  C   THR A   2      24.437 117.998 -11.742  1.00 38.24           C  
ATOM      9  O   THR A   2      23.739 118.889 -11.257  1.00 42.79           O  
ATOM     10  CB  THR A   2      24.209 116.758  -9.634  1.00 35.76           C  
ATOM     11  OG1 THR A   2      23.863 118.045  -9.096  1.00 35.28           O  
ATOM     12  CG2 THR A   2      24.959 115.913  -8.621  1.00 30.11           C  
ATOM     13  N   MET A   3      24.754 117.938 -13.021  1.00 35.40           N  
ATOM     14  CA  MET A   3      24.172 118.870 -13.941  1.00 33.50           C  
ATOM     15  C   MET A   3      22.849 118.156 -14.243  1.00 30.47           C  
ATOM     16  O   MET A   3      22.722 116.941 -14.049  1.00 31.90           O  
ATOM     17  CB  MET A   3      25.059 119.027 -15.174  1.00 33.84           C  
ATOM     18  CG  MET A   3      25.892 117.804 -15.499  1.00 37.22           C  
ATOM     19  SD  MET A   3      25.322 116.909 -16.955  1.00 46.92           S  
ATOM     20  CE  MET A   3      23.636 117.169 -16.858  1.00 39.83           C  
ATOM     21  N   THR A   4      21.864 118.917 -14.685  1.00 27.85           N  
ATOM     22  CA  THR A   4      20.534 118.416 -14.994  1.00 24.72           C  
ATOM     23  C   THR A   4      20.389 118.178 -16.492  1.00 22.98           C  
ATOM     24  O   THR A   4      20.787 119.020 -17.293  1.00 19.87           O  
ATOM     25  CB  THR A   4      19.494 119.454 -14.558  1.00 27.40           C  
ATOM     26  OG1 THR A   4      19.622 119.670 -13.140  1.00 28.49           O  
ATOM     27  CG2 THR A   4      18.083 118.999 -14.916  1.00 26.22           C  
ATOM     28  N   LEU A   5      19.838 117.030 -16.874  1.00 18.98           N  
ATOM     29  CA  LEU A   5      19.608 116.742 -18.293  1.00 18.72           C  
ATOM     30  C   LEU A   5      18.101 116.661 -18.515  1.00 16.67           C  
ATOM     31  O   LEU A   5      17.346 116.459 -17.570  1.00 18.78           O  
ATOM     32  CB  LEU A   5      20.281 115.421 -18.697  1.00 17.41           C  
ATOM     33  CG  LEU A   5      21.812 115.444 -18.707  1.00 20.78           C  
ATOM     34  CD1 LEU A   5      22.372 114.059 -18.991  1.00 19.70           C  
ATOM     35  CD2 LEU A   5      22.273 116.452 -19.771  1.00 19.18           C  
ATOM     36  N   THR A   6      17.669 116.840 -19.759  1.00 16.65           N  
ATOM     37  CA  THR A   6      16.252 116.789 -20.113  1.00 17.33           C  
ATOM     38  C   THR A   6      16.113 116.013 -21.394  1.00 16.66           C  
ATOM     39  O   THR A   6      17.108 115.644 -22.012  1.00 15.03           O  
ATOM     40  CB  THR A   6      15.659 118.172 -20.426  1.00 16.51           C  
ATOM     41  OG1 THR A   6      16.352 118.733 -21.551  1.00 16.74           O  
ATOM     42  CG2 THR A   6      15.769 119.084 -19.232  1.00 16.94           C  
ATOM     43  N   ASP A   7      14.871 115.792 -21.800  1.00 15.80           N  
ATOM     44  CA  ASP A   7      14.600 115.095 -23.043  1.00 17.68           C  
ATOM     45  C   ASP A   7      15.204 115.889 -24.206  1.00 17.89           C  
ATOM     46  O   ASP A   7      15.567 115.310 -25.222  1.00 20.13           O  
ATOM     47  CB  ASP A   7      13.088 114.929 -23.263  1.00 14.93           C  
ATOM     48  CG  ASP A   7      12.483 113.828 -22.387  1.00 19.37           C  
ATOM     49  OD1 ASP A   7      13.190 112.872 -22.049  1.00 17.92           O  
ATOM     50  OD2 ASP A   7      11.256 113.915 -22.078  1.00 15.96           O  
ATOM     51  N   ALA A   8      15.328 117.206 -24.075  1.00 15.45           N  
ATOM     52  CA  ALA A   8      15.903 117.970 -25.190  1.00 18.80           C  
ATOM     53  C   ALA A   8      17.431 117.912 -25.336  1.00 17.25           C  
ATOM     54  O   ALA A   8      17.956 118.211 -26.402  1.00 20.81           O  
ATOM     55  CB  ALA A   8      15.423 119.458 -25.158  1.00 12.90           C  
ATOM     56  N   ASN A   9      18.154 117.520 -24.292  1.00 16.47           N  
ATOM     57  CA  ASN A   9      19.611 117.474 -24.406  1.00 16.08           C  
ATOM     58  C   ASN A   9      20.234 116.130 -23.995  1.00 17.78           C  
ATOM     59  O   ASN A   9      21.442 115.933 -24.120  1.00 17.76           O  
ATOM     60  CB  ASN A   9      20.233 118.626 -23.578  1.00 17.52           C  
ATOM     61  CG  ASN A   9      19.833 118.573 -22.100  1.00 17.65           C  
ATOM     62  OD1 ASN A   9      19.644 117.492 -21.547  1.00 18.20           O  
ATOM     63  ND2 ASN A   9      19.706 119.741 -21.459  1.00 17.03           N  
ATOM     64  N   PHE A  10      19.411 115.187 -23.548  1.00 16.51           N  
ATOM     65  CA  PHE A  10      19.938 113.904 -23.089  1.00 15.27           C  
ATOM     66  C   PHE A  10      20.805 113.132 -24.070  1.00 14.69           C  
ATOM     67  O   PHE A  10      21.923 112.740 -23.753  1.00 14.35           O  
ATOM     68  CB  PHE A  10      18.810 112.976 -22.666  1.00 16.18           C  
ATOM     69  CG  PHE A  10      19.286 111.826 -21.834  1.00 17.13           C  
ATOM     70  CD1 PHE A  10      19.497 111.994 -20.467  1.00 17.20           C  
ATOM     71  CD2 PHE A  10      19.573 110.598 -22.417  1.00 18.78           C  
ATOM     72  CE1 PHE A  10      20.001 110.956 -19.688  1.00 17.91           C  
ATOM     73  CE2 PHE A  10      20.078 109.554 -21.645  1.00 21.86           C  
ATOM     74  CZ  PHE A  10      20.286 109.742 -20.270  1.00 19.75           C  
ATOM     75  N   GLN A  11      20.260 112.899 -25.260  1.00 16.02           N  
ATOM     76  CA  GLN A  11      20.947 112.135 -26.290  1.00 19.11           C  
ATOM     77  C   GLN A  11      22.376 112.565 -26.593  1.00 20.28           C  
ATOM     78  O   GLN A  11      23.273 111.721 -26.611  1.00 17.67           O  
ATOM     79  CB  GLN A  11      20.137 112.144 -27.587  1.00 22.54           C  
ATOM     80  CG  GLN A  11      18.871 111.322 -27.545  1.00 30.56           C  
ATOM     81  CD  GLN A  11      19.123 109.883 -27.161  1.00 33.81           C  
ATOM     82  OE1 GLN A  11      20.108 109.274 -27.589  1.00 36.55           O  
ATOM     83  NE2 GLN A  11      18.228 109.324 -26.350  1.00 35.97           N  
ATOM     84  N   GLN A  12      22.614 113.851 -26.843  1.00 18.08           N  
ATOM     85  CA  GLN A  12      23.985 114.254 -27.147  1.00 21.74           C  
ATOM     86  C   GLN A  12      24.840 114.360 -25.927  1.00 19.96           C  
ATOM     87  O   GLN A  12      26.062 114.359 -26.026  1.00 23.04           O  
ATOM     88  CB  GLN A  12      24.045 115.570 -27.920  1.00 26.17           C  
ATOM     89  CG  GLN A  12      23.670 115.414 -29.384  1.00 31.04           C  
ATOM     90  CD  GLN A  12      24.422 114.265 -30.072  1.00 33.56           C  
ATOM     91  OE1 GLN A  12      25.649 114.194 -30.027  1.00 41.99           O  
ATOM     92  NE2 GLN A  12      23.679 113.377 -30.723  1.00 36.57           N  
ATOM     93  N   ALA A  13      24.202 114.472 -24.771  1.00 17.42           N  
ATOM     94  CA  ALA A  13      24.960 114.548 -23.544  1.00 20.00           C  
ATOM     95  C   ALA A  13      25.681 113.220 -23.382  1.00 22.77           C  
ATOM     96  O   ALA A  13      26.859 113.184 -23.051  1.00 24.56           O  
ATOM     97  CB  ALA A  13      24.048 114.769 -22.386  1.00 15.88           C  
ATOM     98  N   ILE A  14      24.968 112.125 -23.630  1.00 20.96           N  
ATOM     99  CA  ILE A  14      25.558 110.802 -23.476  1.00 25.34           C  
ATOM    100  C   ILE A  14      26.254 110.285 -24.723  1.00 26.66           C  
ATOM    101  O   ILE A  14      27.051 109.358 -24.632  1.00 29.64           O  
ATOM    102  CB  ILE A  14      24.501 109.751 -23.033  1.00 27.57           C  
ATOM    103  CG1 ILE A  14      23.521 109.504 -24.169  1.00 27.15           C  
ATOM    104  CG2 ILE A  14      23.785 110.225 -21.763  1.00 27.99           C  
ATOM    105  CD1 ILE A  14      23.251 108.030 -24.428  1.00 32.11           C  
ATOM    106  N   GLN A  15      25.935 110.856 -25.886  1.00 31.39           N  
ATOM    107  CA  GLN A  15      26.542 110.451 -27.158  1.00 37.91           C  
ATOM    108  C   GLN A  15      27.960 110.956 -27.142  1.00 42.10           C  
ATOM    109  O   GLN A  15      28.346 111.870 -27.897  1.00 45.24           O  
ATOM    110  CB  GLN A  15      25.801 111.048 -28.347  1.00 37.48           C  
ATOM    111  CG  GLN A  15      25.788 110.140 -29.590  1.00 38.74           C  
ATOM    112  CD  GLN A  15      24.383 109.627 -29.911  0.00 33.82           C  
ATOM    113  OE1 GLN A  15      23.430 109.954 -29.230  0.00 32.65           O  
ATOM    114  NE2 GLN A  15      24.278 108.815 -30.973  0.00 32.65           N  
ATOM    115  N   GLY A  16      28.767 110.376 -26.266  1.00 44.59           N  
ATOM    116  CA  GLY A  16      30.152 110.769 -26.134  1.00 46.71           C  
ATOM    117  C   GLY A  16      30.900 109.730 -25.342  1.00 48.75           C  
ATOM    118  O   GLY A  16      30.301 108.893 -24.670  1.00 48.08           O  
ATOM    119  N   ASP A  17      32.221 109.779 -25.427  1.00 49.55           N  
ATOM    120  CA  ASP A  17      33.045 108.824 -24.711  1.00 49.82           C  
ATOM    121  C   ASP A  17      32.822 109.060 -23.219  1.00 49.52           C  
ATOM    122  O   ASP A  17      32.742 108.117 -22.423  1.00 49.16           O  
ATOM    123  CB  ASP A  17      34.521 109.028 -25.083  1.00 51.42           C  
ATOM    124  CG  ASP A  17      35.176 110.158 -24.305  1.00 51.79           C  
ATOM    125  OD1 ASP A  17      35.395 109.986 -23.086  1.00 55.15           O  
ATOM    126  OD2 ASP A  17      35.477 111.214 -24.907  1.00 52.59           O  
ATOM    127  N   GLY A  18      32.690 110.337 -22.876  1.00 48.28           N  
ATOM    128  CA  GLY A  18      32.500 110.755 -21.504  1.00 46.12           C  
ATOM    129  C   GLY A  18      31.630 109.872 -20.634  1.00 42.25           C  
ATOM    130  O   GLY A  18      30.430 109.754 -20.892  1.00 44.92           O  
ATOM    131  N   PRO A  19      32.213 109.233 -19.595  1.00 36.43           N  
ATOM    132  CA  PRO A  19      31.473 108.356 -18.676  1.00 31.26           C  
ATOM    133  C   PRO A  19      30.455 109.240 -17.968  1.00 26.00           C  
ATOM    134  O   PRO A  19      30.816 110.246 -17.355  1.00 22.74           O  
ATOM    135  CB  PRO A  19      32.544 107.859 -17.703  1.00 32.74           C  
ATOM    136  CG  PRO A  19      33.850 108.066 -18.447  1.00 30.60           C  
ATOM    137  CD  PRO A  19      33.623 109.346 -19.198  1.00 33.81           C  
ATOM    138  N   VAL A  20      29.183 108.875 -18.049  1.00 23.43           N  
ATOM    139  CA  VAL A  20      28.156 109.679 -17.421  1.00 20.31           C  
ATOM    140  C   VAL A  20      27.252 108.830 -16.550  1.00 18.05           C  
ATOM    141  O   VAL A  20      26.686 107.864 -17.020  1.00 18.10           O  
ATOM    142  CB  VAL A  20      27.289 110.372 -18.481  1.00 22.00           C  
ATOM    143  CG1 VAL A  20      26.276 111.296 -17.799  1.00 21.79           C  
ATOM    144  CG2 VAL A  20      28.182 111.147 -19.453  1.00 25.22           C  
ATOM    145  N   LEU A  21      27.135 109.184 -15.280  1.00 15.79           N  
ATOM    146  CA  LEU A  21      26.258 108.447 -14.366  1.00 14.40           C  
ATOM    147  C   LEU A  21      24.965 109.253 -14.280  1.00 12.92           C  
ATOM    148  O   LEU A  21      24.966 110.373 -13.793  1.00 19.12           O  
ATOM    149  CB  LEU A  21      26.902 108.340 -12.979  1.00 15.71           C  
ATOM    150  CG  LEU A  21      26.127 107.567 -11.901  1.00 11.46           C  
ATOM    151  CD1 LEU A  21      26.172 106.075 -12.167  1.00 13.57           C  
ATOM    152  CD2 LEU A  21      26.733 107.859 -10.552  1.00 18.01           C  
ATOM    153  N   VAL A  22      23.866 108.664 -14.744  1.00 13.99           N  
ATOM    154  CA  VAL A  22      22.576 109.328 -14.766  1.00 14.48           C  
ATOM    155  C   VAL A  22      21.655 108.872 -13.644  1.00 13.38           C  
ATOM    156  O   VAL A  22      21.398 107.683 -13.497  1.00 14.20           O  
ATOM    157  CB  VAL A  22      21.863 109.080 -16.115  1.00 14.85           C  
ATOM    158  CG1 VAL A  22      20.485 109.772 -16.101  1.00 13.59           C  
ATOM    159  CG2 VAL A  22      22.731 109.590 -17.279  1.00 17.22           C  
ATOM    160  N   ASP A  23      21.149 109.833 -12.883  1.00  9.48           N  
ATOM    161  CA  ASP A  23      20.254 109.550 -11.752  1.00 12.76           C  
ATOM    162  C   ASP A  23      18.805 109.849 -12.162  1.00 14.27           C  
ATOM    163  O   ASP A  23      18.449 111.000 -12.388  1.00 12.91           O  
ATOM    164  CB  ASP A  23      20.675 110.415 -10.548  1.00 10.95           C  
ATOM    165  CG  ASP A  23      19.676 110.349  -9.389  1.00 16.67           C  
ATOM    166  OD1 ASP A  23      19.241 109.251  -9.033  1.00 15.10           O  
ATOM    167  OD2 ASP A  23      19.344 111.413  -8.817  1.00 17.24           O  
ATOM    168  N   PHE A  24      18.013 108.788 -12.307  1.00 13.47           N  
ATOM    169  CA  PHE A  24      16.602 108.854 -12.679  1.00 13.13           C  
ATOM    170  C   PHE A  24      15.858 109.011 -11.357  1.00 15.93           C  
ATOM    171  O   PHE A  24      15.876 108.102 -10.521  1.00 15.49           O  
ATOM    172  CB  PHE A  24      16.222 107.559 -13.395  1.00 14.42           C  
ATOM    173  CG  PHE A  24      16.828 107.423 -14.766  1.00 15.79           C  
ATOM    174  CD1 PHE A  24      16.205 108.002 -15.863  1.00 16.62           C  
ATOM    175  CD2 PHE A  24      18.061 106.794 -14.947  1.00 18.00           C  
ATOM    176  CE1 PHE A  24      16.782 107.933 -17.136  1.00 17.00           C  
ATOM    177  CE2 PHE A  24      18.657 106.718 -16.223  1.00 18.09           C  
ATOM    178  CZ  PHE A  24      18.015 107.305 -17.310  1.00 18.46           C  
ATOM    179  N   TRP A  25      15.196 110.157 -11.198  1.00 13.02           N  
ATOM    180  CA  TRP A  25      14.513 110.500  -9.956  1.00 15.12           C  
ATOM    181  C   TRP A  25      13.222 111.305 -10.132  1.00 13.36           C  
ATOM    182  O   TRP A  25      12.842 111.699 -11.234  1.00 16.35           O  
ATOM    183  CB  TRP A  25      15.472 111.328  -9.086  1.00 12.13           C  
ATOM    184  CG  TRP A  25      15.666 112.760  -9.597  1.00 12.73           C  
ATOM    185  CD1 TRP A  25      16.317 113.163 -10.726  1.00 11.70           C  
ATOM    186  CD2 TRP A  25      15.073 113.931  -9.035  1.00 14.54           C  
ATOM    187  NE1 TRP A  25      16.155 114.518 -10.907  1.00 14.84           N  
ATOM    188  CE2 TRP A  25      15.400 115.008  -9.887  1.00 13.96           C  
ATOM    189  CE3 TRP A  25      14.301 114.165  -7.895  1.00 13.91           C  
ATOM    190  CZ2 TRP A  25      14.961 116.316  -9.619  1.00 17.22           C  
ATOM    191  CZ3 TRP A  25      13.867 115.455  -7.640  1.00 18.84           C  
ATOM    192  CH2 TRP A  25      14.201 116.515  -8.496  1.00 19.44           C  
ATOM    193  N   ALA A  26      12.556 111.545  -9.012  1.00 12.14           N  
ATOM    194  CA  ALA A  26      11.342 112.347  -8.981  1.00 15.33           C  
ATOM    195  C   ALA A  26      11.232 112.870  -7.554  1.00 15.99           C  
ATOM    196  O   ALA A  26      11.716 112.232  -6.606  1.00 16.04           O  
ATOM    197  CB  ALA A  26      10.120 111.516  -9.342  1.00 12.89           C  
ATOM    198  N   ALA A  27      10.591 114.023  -7.401  1.00 15.74           N  
ATOM    199  CA  ALA A  27      10.464 114.631  -6.088  1.00 17.68           C  
ATOM    200  C   ALA A  27       9.639 113.799  -5.102  1.00 18.28           C  
ATOM    201  O   ALA A  27       9.855 113.873  -3.893  1.00 18.25           O  
ATOM    202  CB  ALA A  27       9.878 116.025  -6.241  1.00 16.64           C  
ATOM    203  N   TRP A  28       8.716 112.986  -5.614  1.00 16.67           N  
ATOM    204  CA  TRP A  28       7.868 112.178  -4.740  1.00 15.05           C  
ATOM    205  C   TRP A  28       8.519 110.921  -4.206  1.00 17.42           C  
ATOM    206  O   TRP A  28       7.976 110.254  -3.330  1.00 15.37           O  
ATOM    207  CB  TRP A  28       6.583 111.767  -5.466  1.00 13.15           C  
ATOM    208  CG  TRP A  28       6.791 111.225  -6.856  1.00 13.92           C  
ATOM    209  CD1 TRP A  28       6.669 111.928  -8.026  1.00 13.49           C  
ATOM    210  CD2 TRP A  28       7.099 109.871  -7.236  1.00 13.38           C  
ATOM    211  NE1 TRP A  28       6.870 111.102  -9.093  1.00 11.25           N  
ATOM    212  CE2 TRP A  28       7.134 109.842  -8.645  1.00 12.58           C  
ATOM    213  CE3 TRP A  28       7.349 108.688  -6.525  1.00 11.43           C  
ATOM    214  CZ2 TRP A  28       7.398 108.667  -9.362  1.00 10.73           C  
ATOM    215  CZ3 TRP A  28       7.617 107.521  -7.251  1.00 11.50           C  
ATOM    216  CH2 TRP A  28       7.637 107.522  -8.653  1.00 13.44           C  
ATOM    217  N   CYS A  29       9.683 110.592  -4.745  1.00 16.89           N  
ATOM    218  CA  CYS A  29      10.387 109.378  -4.368  1.00 15.86           C  
ATOM    219  C   CYS A  29      11.373 109.623  -3.216  1.00 18.39           C  
ATOM    220  O   CYS A  29      12.378 110.305  -3.397  1.00 17.22           O  
ATOM    221  CB  CYS A  29      11.069 108.850  -5.643  1.00 17.19           C  
ATOM    222  SG  CYS A  29      12.418 107.674  -5.426  1.00 15.73           S  
ATOM    223  N   GLY A  30      11.060 109.086  -2.030  1.00 16.21           N  
ATOM    224  CA  GLY A  30      11.918 109.274  -0.868  1.00 16.34           C  
ATOM    225  C   GLY A  30      13.371 108.830  -1.027  1.00 14.74           C  
ATOM    226  O   GLY A  30      14.292 109.614  -0.780  1.00 17.47           O  
ATOM    227  N   PRO A  31      13.612 107.579  -1.429  1.00 16.15           N  
ATOM    228  CA  PRO A  31      14.981 107.082  -1.603  1.00 17.72           C  
ATOM    229  C   PRO A  31      15.748 107.923  -2.617  1.00 17.86           C  
ATOM    230  O   PRO A  31      16.976 108.046  -2.543  1.00 19.27           O  
ATOM    231  CB  PRO A  31      14.766 105.647  -2.080  1.00 17.78           C  
ATOM    232  CG  PRO A  31      13.461 105.281  -1.468  1.00 19.01           C  
ATOM    233  CD  PRO A  31      12.633 106.513  -1.698  1.00 14.20           C  
ATOM    234  N   CYS A  32      15.020 108.505  -3.568  1.00 16.29           N  
ATOM    235  CA  CYS A  32      15.644 109.343  -4.583  1.00 14.25           C  
ATOM    236  C   CYS A  32      16.183 110.608  -3.923  1.00 16.16           C  
ATOM    237  O   CYS A  32      17.275 111.069  -4.235  1.00 20.42           O  
ATOM    238  CB  CYS A  32      14.633 109.741  -5.652  1.00 11.66           C  
ATOM    239  SG  CYS A  32      13.888 108.409  -6.649  1.00 15.59           S  
ATOM    240  N   ARG A  33      15.392 111.181  -3.020  1.00 19.56           N  
ATOM    241  CA  ARG A  33      15.799 112.386  -2.321  1.00 20.00           C  
ATOM    242  C   ARG A  33      16.948 112.029  -1.370  1.00 23.12           C  
ATOM    243  O   ARG A  33      17.845 112.835  -1.146  1.00 25.59           O  
ATOM    244  CB  ARG A  33      14.616 112.989  -1.534  1.00 16.99           C  
ATOM    245  CG  ARG A  33      13.445 113.486  -2.392  1.00 19.94           C  
ATOM    246  CD  ARG A  33      12.488 114.405  -1.591  1.00 18.75           C  
ATOM    247  NE  ARG A  33      12.083 113.747  -0.358  1.00 21.15           N  
ATOM    248  CZ  ARG A  33      11.100 112.862  -0.264  1.00 20.18           C  
ATOM    249  NH1 ARG A  33      10.388 112.533  -1.333  1.00 17.89           N  
ATOM    250  NH2 ARG A  33      10.868 112.263   0.892  1.00 20.55           N  
ATOM    251  N   MET A  34      16.912 110.819  -0.821  1.00 25.73           N  
ATOM    252  CA  MET A  34      17.954 110.346   0.093  1.00 27.01           C  
ATOM    253  C   MET A  34      19.296 110.258  -0.659  1.00 27.45           C  
ATOM    254  O   MET A  34      20.367 110.498  -0.098  1.00 28.30           O  
ATOM    255  CB  MET A  34      17.609 108.943   0.634  1.00 30.99           C  
ATOM    256  CG  MET A  34      16.364 108.804   1.515  1.00 37.75           C  
ATOM    257  SD  MET A  34      16.235 107.109   2.222  1.00 44.71           S  
ATOM    258  CE  MET A  34      14.828 106.447   1.394  1.00 48.86           C  
ATOM    259  N   MET A  35      19.242 109.913  -1.936  1.00 24.61           N  
ATOM    260  CA  MET A  35      20.480 109.790  -2.693  1.00 22.02           C  
ATOM    261  C   MET A  35      21.024 111.086  -3.325  1.00 21.72           C  
ATOM    262  O   MET A  35      22.187 111.121  -3.740  1.00 20.70           O  
ATOM    263  CB  MET A  35      20.326 108.690  -3.752  1.00 22.43           C  
ATOM    264  CG  MET A  35      21.089 107.379  -3.440  1.00 21.46           C  
ATOM    265  SD  MET A  35      21.848 106.785  -4.959  1.00 35.86           S  
ATOM    266  CE  MET A  35      20.532 107.094  -6.211  1.00 26.13           C  
ATOM    267  N   ALA A  36      20.221 112.148  -3.381  1.00 18.44           N  
ATOM    268  CA  ALA A  36      20.665 113.401  -3.985  1.00 19.57           C  
ATOM    269  C   ALA A  36      21.950 113.936  -3.333  1.00 19.83           C  
ATOM    270  O   ALA A  36      22.895 114.253  -4.047  1.00 18.37           O  
ATOM    271  CB  ALA A  36      19.563 114.454  -3.924  1.00 18.24           C  
ATOM    272  N   PRO A  37      22.006 114.014  -1.981  1.00 20.25           N  
ATOM    273  CA  PRO A  37      23.204 114.513  -1.283  1.00 21.15           C  
ATOM    274  C   PRO A  37      24.413 113.621  -1.479  1.00 22.05           C  
ATOM    275  O   PRO A  37      25.549 114.098  -1.545  1.00 25.63           O  
ATOM    276  CB  PRO A  37      22.788 114.546   0.181  1.00 20.27           C  
ATOM    277  CG  PRO A  37      21.256 114.605   0.132  1.00 22.24           C  
ATOM    278  CD  PRO A  37      20.943 113.690  -1.016  1.00 20.33           C  
ATOM    279  N   VAL A  38      24.168 112.315  -1.525  1.00 20.16           N  
ATOM    280  CA  VAL A  38      25.257 111.356  -1.715  1.00 20.34           C  
ATOM    281  C   VAL A  38      25.875 111.567  -3.084  1.00 22.34           C  
ATOM    282  O   VAL A  38      27.094 111.661  -3.227  1.00 22.17           O  
ATOM    283  CB  VAL A  38      24.744 109.905  -1.589  1.00 21.20           C  
ATOM    284  CG1 VAL A  38      25.891 108.913  -1.760  1.00 19.30           C  
ATOM    285  CG2 VAL A  38      24.108 109.717  -0.228  1.00 19.88           C  
ATOM    286  N   LEU A  39      25.023 111.657  -4.094  1.00 18.86           N  
ATOM    287  CA  LEU A  39      25.478 111.874  -5.450  1.00 19.70           C  
ATOM    288  C   LEU A  39      26.200 113.212  -5.611  1.00 21.79           C  
ATOM    289  O   LEU A  39      27.185 113.299  -6.337  1.00 23.10           O  
ATOM    290  CB  LEU A  39      24.309 111.809  -6.411  1.00 17.33           C  
ATOM    291  CG  LEU A  39      23.743 110.417  -6.664  1.00 20.04           C  
ATOM    292  CD1 LEU A  39      22.464 110.539  -7.508  1.00 19.99           C  
ATOM    293  CD2 LEU A  39      24.805 109.566  -7.392  1.00 16.48           C  
ATOM    294  N   GLU A  40      25.693 114.250  -4.957  1.00 23.52           N  
ATOM    295  CA  GLU A  40      26.325 115.563  -5.061  1.00 25.84           C  
ATOM    296  C   GLU A  40      27.767 115.440  -4.555  1.00 25.90           C  
ATOM    297  O   GLU A  40      28.719 115.880  -5.213  1.00 28.52           O  
ATOM    298  CB  GLU A  40      25.506 116.590  -4.246  1.00 26.51           C  
ATOM    299  CG  GLU A  40      24.002 116.553  -4.559  0.00 30.66           C  
ATOM    300  CD  GLU A  40      23.116 117.148  -3.472  0.00 32.50           C  
ATOM    301  OE1 GLU A  40      23.170 116.683  -2.324  0.00 33.87           O  
ATOM    302  OE2 GLU A  40      22.358 118.095  -3.772  0.00 33.95           O  
ATOM    303  N   GLU A  41      27.932 114.801  -3.404  1.00 25.67           N  
ATOM    304  CA  GLU A  41      29.258 114.602  -2.827  1.00 26.20           C  
ATOM    305  C   GLU A  41      30.085 113.699  -3.751  1.00 25.42           C  
ATOM    306  O   GLU A  41      31.266 113.951  -3.978  1.00 23.24           O  
ATOM    307  CB  GLU A  41      29.128 114.005  -1.412  1.00 26.50           C  
ATOM    308  CG  GLU A  41      30.414 113.994  -0.581  1.00 30.25           C  
ATOM    309  CD  GLU A  41      31.152 115.334  -0.586  1.00 32.06           C  
ATOM    310  OE1 GLU A  41      30.485 116.390  -0.540  1.00 32.03           O  
ATOM    311  OE2 GLU A  41      32.404 115.332  -0.624  1.00 36.26           O  
ATOM    312  N   PHE A  42      29.456 112.672  -4.321  1.00 24.91           N  
ATOM    313  CA  PHE A  42      30.138 111.751  -5.235  1.00 23.50           C  
ATOM    314  C   PHE A  42      30.623 112.448  -6.506  1.00 25.64           C  
ATOM    315  O   PHE A  42      31.734 112.217  -6.962  1.00 24.20           O  
ATOM    316  CB  PHE A  42      29.203 110.618  -5.654  1.00 21.58           C  
ATOM    317  CG  PHE A  42      29.868 109.546  -6.464  1.00 20.54           C  
ATOM    318  CD1 PHE A  42      30.541 108.506  -5.831  1.00 24.71           C  
ATOM    319  CD2 PHE A  42      29.761 109.527  -7.854  1.00 18.76           C  
ATOM    320  CE1 PHE A  42      31.099 107.459  -6.568  1.00 22.52           C  
ATOM    321  CE2 PHE A  42      30.309 108.491  -8.600  1.00 22.18           C  
ATOM    322  CZ  PHE A  42      30.980 107.447  -7.956  1.00 23.03           C  
ATOM    323  N   ALA A  43      29.773 113.279  -7.093  1.00 25.22           N  
ATOM    324  CA  ALA A  43      30.139 113.983  -8.318  1.00 26.20           C  
ATOM    325  C   ALA A  43      31.374 114.848  -8.060  1.00 27.66           C  
ATOM    326  O   ALA A  43      32.307 114.895  -8.872  1.00 27.63           O  
ATOM    327  CB  ALA A  43      28.973 114.865  -8.778  1.00 19.06           C  
ATOM    328  N   GLU A  44      31.359 115.525  -6.917  1.00 26.05           N  
ATOM    329  CA  GLU A  44      32.442 116.392  -6.513  1.00 32.71           C  
ATOM    330  C   GLU A  44      33.745 115.638  -6.314  1.00 33.54           C  
ATOM    331  O   GLU A  44      34.807 116.101  -6.713  1.00 35.71           O  
ATOM    332  CB  GLU A  44      32.082 117.119  -5.212  1.00 30.67           C  
ATOM    333  CG  GLU A  44      33.295 117.433  -4.315  1.00 19.95           C  
ATOM    334  CD  GLU A  44      32.966 118.349  -3.121  0.00 19.95           C  
ATOM    335  OE1 GLU A  44      31.902 118.979  -3.159  0.00 19.95           O  
ATOM    336  OE2 GLU A  44      33.785 118.408  -2.191  0.00 19.95           O  
ATOM    337  N   ALA A  45      33.647 114.450  -5.714  1.00 35.09           N  
ATOM    338  CA  ALA A  45      34.819 113.630  -5.414  1.00 35.91           C  
ATOM    339  C   ALA A  45      35.436 112.845  -6.569  1.00 36.37           C  
ATOM    340  O   ALA A  45      36.616 112.509  -6.518  1.00 36.04           O  
ATOM    341  CB  ALA A  45      34.497 112.679  -4.256  1.00 34.75           C  
ATOM    342  N   HIS A  46      34.655 112.553  -7.603  1.00 36.19           N  
ATOM    343  CA  HIS A  46      35.171 111.789  -8.741  1.00 35.98           C  
ATOM    344  C   HIS A  46      34.929 112.501 -10.081  1.00 35.50           C  
ATOM    345  O   HIS A  46      34.828 111.862 -11.134  1.00 34.95           O  
ATOM    346  CB  HIS A  46      34.510 110.412  -8.766  1.00 36.02           C  
ATOM    347  CG  HIS A  46      34.432 109.752  -7.423  1.00 36.93           C  
ATOM    348  ND1 HIS A  46      35.348 108.824  -6.982  1.00 38.99           N  
ATOM    349  CD2 HIS A  46      33.525 109.887  -6.427  1.00 39.86           C  
ATOM    350  CE1 HIS A  46      35.008 108.408  -5.782  1.00 37.43           C  
ATOM    351  NE2 HIS A  46      33.903 109.034  -5.415  1.00 39.98           N  
ATOM    352  N   ALA A  47      34.845 113.825 -10.029  1.00 35.88           N  
ATOM    353  CA  ALA A  47      34.608 114.633 -11.220  1.00 35.88           C  
ATOM    354  C   ALA A  47      35.559 114.329 -12.378  1.00 37.65           C  
ATOM    355  O   ALA A  47      35.197 114.488 -13.539  1.00 39.30           O  
ATOM    356  CB  ALA A  47      34.687 116.113 -10.859  1.00 37.82           C  
ATOM    357  N   ASP A  48      36.768 113.885 -12.063  1.00 37.26           N  
ATOM    358  CA  ASP A  48      37.757 113.579 -13.086  1.00 37.21           C  
ATOM    359  C   ASP A  48      37.523 112.239 -13.791  1.00 36.85           C  
ATOM    360  O   ASP A  48      38.044 112.012 -14.890  1.00 36.41           O  
ATOM    361  CB  ASP A  48      39.153 113.580 -12.465  1.00 41.11           C  
ATOM    362  CG  ASP A  48      39.349 112.438 -11.490  1.00 45.03           C  
ATOM    363  OD1 ASP A  48      38.710 112.445 -10.414  1.00 46.08           O  
ATOM    364  OD2 ASP A  48      40.135 111.521 -11.808  1.00 49.24           O  
ATOM    365  N   LYS A  49      36.756 111.351 -13.161  1.00 31.50           N  
ATOM    366  CA  LYS A  49      36.486 110.041 -13.742  1.00 31.19           C  
ATOM    367  C   LYS A  49      35.046 109.810 -14.203  1.00 29.60           C  
ATOM    368  O   LYS A  49      34.778 108.887 -14.976  1.00 31.64           O  
ATOM    369  CB  LYS A  49      36.924 108.941 -12.768  1.00 32.21           C  
ATOM    370  CG  LYS A  49      38.375 108.498 -13.012  1.00 29.51           C  
ATOM    371  CD  LYS A  49      38.901 107.573 -11.942  0.00 27.51           C  
ATOM    372  CE  LYS A  49      39.196 108.307 -10.649  0.00 26.36           C  
ATOM    373  NZ  LYS A  49      39.884 107.423  -9.666  0.00 25.39           N  
ATOM    374  N   VAL A  50      34.124 110.651 -13.753  1.00 27.98           N  
ATOM    375  CA  VAL A  50      32.736 110.499 -14.166  1.00 28.39           C  
ATOM    376  C   VAL A  50      31.962 111.801 -14.002  1.00 24.77           C  
ATOM    377  O   VAL A  50      32.267 112.597 -13.118  1.00 30.29           O  
ATOM    378  CB  VAL A  50      32.028 109.406 -13.327  1.00 27.74           C  
ATOM    379  CG1 VAL A  50      32.078 109.769 -11.866  1.00 29.67           C  
ATOM    380  CG2 VAL A  50      30.581 109.256 -13.766  1.00 26.09           C  
ATOM    381  N   THR A  51      30.976 112.030 -14.868  1.00 25.30           N  
ATOM    382  CA  THR A  51      30.124 113.220 -14.760  1.00 21.13           C  
ATOM    383  C   THR A  51      28.747 112.740 -14.303  1.00 20.82           C  
ATOM    384  O   THR A  51      28.147 111.882 -14.952  1.00 20.87           O  
ATOM    385  CB  THR A  51      29.912 113.943 -16.102  1.00 22.72           C  
ATOM    386  OG1 THR A  51      31.176 114.301 -16.680  1.00 22.86           O  
ATOM    387  CG2 THR A  51      29.077 115.202 -15.867  1.00 19.88           C  
ATOM    388  N   VAL A  52      28.237 113.304 -13.214  1.00 18.98           N  
ATOM    389  CA  VAL A  52      26.939 112.883 -12.693  1.00 19.21           C  
ATOM    390  C   VAL A  52      25.803 113.796 -13.183  1.00 17.43           C  
ATOM    391  O   VAL A  52      25.833 115.012 -12.988  1.00 20.22           O  
ATOM    392  CB  VAL A  52      26.967 112.838 -11.126  1.00 18.19           C  
ATOM    393  CG1 VAL A  52      25.732 112.164 -10.594  1.00 23.34           C  
ATOM    394  CG2 VAL A  52      28.201 112.065 -10.642  1.00 18.08           C  
ATOM    395  N   ALA A  53      24.817 113.199 -13.848  1.00 15.67           N  
ATOM    396  CA  ALA A  53      23.662 113.937 -14.373  1.00 17.73           C  
ATOM    397  C   ALA A  53      22.369 113.477 -13.689  1.00 18.63           C  
ATOM    398  O   ALA A  53      22.254 112.322 -13.275  1.00 19.99           O  
ATOM    399  CB  ALA A  53      23.539 113.705 -15.886  1.00 15.99           C  
ATOM    400  N   LYS A  54      21.399 114.378 -13.582  1.00 15.14           N  
ATOM    401  CA  LYS A  54      20.106 114.044 -13.001  1.00 19.32           C  
ATOM    402  C   LYS A  54      19.037 114.144 -14.089  1.00 16.77           C  
ATOM    403  O   LYS A  54      19.019 115.091 -14.869  1.00 16.20           O  
ATOM    404  CB  LYS A  54      19.761 114.999 -11.859  1.00 20.97           C  
ATOM    405  CG  LYS A  54      20.713 114.860 -10.685  1.00 30.79           C  
ATOM    406  CD  LYS A  54      20.349 115.777  -9.551  1.00 34.36           C  
ATOM    407  CE  LYS A  54      19.082 115.340  -8.864  1.00 36.34           C  
ATOM    408  NZ  LYS A  54      18.831 116.233  -7.703  1.00 40.49           N  
ATOM    409  N   LEU A  55      18.146 113.161 -14.128  1.00 13.95           N  
ATOM    410  CA  LEU A  55      17.072 113.138 -15.106  1.00 12.88           C  
ATOM    411  C   LEU A  55      15.776 112.941 -14.329  1.00 12.39           C  
ATOM    412  O   LEU A  55      15.517 111.863 -13.800  1.00 12.60           O  
ATOM    413  CB  LEU A  55      17.278 111.983 -16.095  1.00 13.73           C  
ATOM    414  CG  LEU A  55      16.383 111.813 -17.331  1.00 14.26           C  
ATOM    415  CD1 LEU A  55      14.955 111.520 -16.927  1.00 12.50           C  
ATOM    416  CD2 LEU A  55      16.465 113.066 -18.202  1.00 12.62           C  
ATOM    417  N   ASN A  56      14.962 113.983 -14.248  1.00 14.28           N  
ATOM    418  CA  ASN A  56      13.696 113.858 -13.514  1.00 14.85           C  
ATOM    419  C   ASN A  56      12.680 113.122 -14.408  1.00 13.28           C  
ATOM    420  O   ASN A  56      12.337 113.603 -15.491  1.00 13.07           O  
ATOM    421  CB  ASN A  56      13.226 115.262 -13.118  1.00 13.90           C  
ATOM    422  CG  ASN A  56      11.921 115.246 -12.374  1.00 18.06           C  
ATOM    423  OD1 ASN A  56      10.880 114.936 -12.945  1.00 16.49           O  
ATOM    424  ND2 ASN A  56      11.972 115.558 -11.083  1.00 13.44           N  
ATOM    425  N   VAL A  57      12.196 111.950 -13.981  1.00 14.80           N  
ATOM    426  CA  VAL A  57      11.288 111.184 -14.846  1.00 13.73           C  
ATOM    427  C   VAL A  57       9.900 111.754 -15.144  1.00 11.95           C  
ATOM    428  O   VAL A  57       9.366 111.520 -16.233  1.00 15.15           O  
ATOM    429  CB  VAL A  57      11.139 109.709 -14.365  1.00 14.42           C  
ATOM    430  CG1 VAL A  57      12.522 109.047 -14.304  1.00 12.73           C  
ATOM    431  CG2 VAL A  57      10.447 109.662 -13.018  1.00 15.08           C  
ATOM    432  N   ASP A  58       9.318 112.485 -14.200  1.00 13.84           N  
ATOM    433  CA  ASP A  58       8.012 113.097 -14.397  1.00 16.79           C  
ATOM    434  C   ASP A  58       8.080 114.154 -15.494  1.00 19.71           C  
ATOM    435  O   ASP A  58       7.151 114.295 -16.280  1.00 18.66           O  
ATOM    436  CB  ASP A  58       7.516 113.795 -13.122  1.00 20.41           C  
ATOM    437  CG  ASP A  58       7.331 112.831 -11.958  1.00 20.32           C  
ATOM    438  OD1 ASP A  58       7.003 111.666 -12.205  1.00 22.33           O  
ATOM    439  OD2 ASP A  58       7.507 113.251 -10.801  1.00 22.39           O  
ATOM    440  N   GLU A  59       9.197 114.877 -15.545  1.00 19.32           N  
ATOM    441  CA  GLU A  59       9.386 115.970 -16.511  1.00 20.79           C  
ATOM    442  C   GLU A  59       9.950 115.569 -17.859  1.00 20.40           C  
ATOM    443  O   GLU A  59       9.847 116.325 -18.836  1.00 17.39           O  
ATOM    444  CB  GLU A  59      10.320 117.033 -15.919  1.00 16.64           C  
ATOM    445  CG  GLU A  59       9.779 117.663 -14.661  1.00 22.12           C  
ATOM    446  CD  GLU A  59      10.794 118.527 -13.932  1.00 26.83           C  
ATOM    447  OE1 GLU A  59      12.018 118.321 -14.106  1.00 22.99           O  
ATOM    448  OE2 GLU A  59      10.349 119.404 -13.156  1.00 26.78           O  
ATOM    449  N   ASN A  60      10.557 114.391 -17.901  1.00 16.39           N  
ATOM    450  CA  ASN A  60      11.196 113.905 -19.114  1.00 16.74           C  
ATOM    451  C   ASN A  60      10.708 112.505 -19.423  1.00 21.06           C  
ATOM    452  O   ASN A  60      11.391 111.520 -19.188  1.00 14.59           O  
ATOM    453  CB  ASN A  60      12.697 113.950 -18.878  1.00 18.37           C  
ATOM    454  CG  ASN A  60      13.164 115.359 -18.567  1.00 17.68           C  
ATOM    455  OD1 ASN A  60      13.172 116.193 -19.460  1.00 14.35           O  
ATOM    456  ND2 ASN A  60      13.512 115.642 -17.300  1.00 16.20           N  
ATOM    457  N   PRO A  61       9.497 112.407 -19.973  1.00 21.84           N  
ATOM    458  CA  PRO A  61       8.973 111.077 -20.280  1.00 24.10           C  
ATOM    459  C   PRO A  61       9.661 110.326 -21.402  1.00 24.14           C  
ATOM    460  O   PRO A  61       9.671 109.098 -21.394  1.00 21.04           O  
ATOM    461  CB  PRO A  61       7.498 111.347 -20.573  1.00 25.70           C  
ATOM    462  CG  PRO A  61       7.203 112.558 -19.716  1.00 28.09           C  
ATOM    463  CD  PRO A  61       8.424 113.411 -19.983  1.00 23.61           C  
ATOM    464  N   GLU A  62      10.249 111.040 -22.363  1.00 21.39           N  
ATOM    465  CA  GLU A  62      10.902 110.368 -23.484  1.00 21.94           C  
ATOM    466  C   GLU A  62      12.118 109.559 -23.075  1.00 22.72           C  
ATOM    467  O   GLU A  62      12.259 108.395 -23.436  1.00 18.32           O  
ATOM    468  CB  GLU A  62      11.316 111.381 -24.555  1.00 23.88           C  
ATOM    469  CG  GLU A  62      10.145 112.050 -25.258  1.00 31.74           C  
ATOM    470  CD  GLU A  62      10.583 113.127 -26.238  1.00 36.19           C  
ATOM    471  OE1 GLU A  62      11.675 112.986 -26.834  1.00 41.65           O  
ATOM    472  OE2 GLU A  62       9.827 114.106 -26.420  1.00 38.89           O  
ATOM    473  N   THR A  63      13.002 110.187 -22.317  1.00 18.32           N  
ATOM    474  CA  THR A  63      14.198 109.518 -21.877  1.00 16.48           C  
ATOM    475  C   THR A  63      13.837 108.343 -20.960  1.00 17.26           C  
ATOM    476  O   THR A  63      14.416 107.251 -21.067  1.00 16.04           O  
ATOM    477  CB  THR A  63      15.115 110.534 -21.161  1.00 17.13           C  
ATOM    478  OG1 THR A  63      15.470 111.580 -22.086  1.00 16.73           O  
ATOM    479  CG2 THR A  63      16.353 109.870 -20.641  1.00 13.42           C  
ATOM    480  N   THR A  64      12.858 108.563 -20.091  1.00 15.34           N  
ATOM    481  CA  THR A  64      12.432 107.534 -19.144  1.00 15.61           C  
ATOM    482  C   THR A  64      11.980 106.261 -19.873  1.00 17.84           C  
ATOM    483  O   THR A  64      12.346 105.148 -19.483  1.00 18.89           O  
ATOM    484  CB  THR A  64      11.293 108.062 -18.238  1.00 14.45           C  
ATOM    485  OG1 THR A  64      11.728 109.249 -17.561  1.00 17.05           O  
ATOM    486  CG2 THR A  64      10.907 107.010 -17.194  1.00 15.68           C  
ATOM    487  N   SER A  65      11.187 106.434 -20.927  1.00 19.93           N  
ATOM    488  CA  SER A  65      10.701 105.309 -21.739  1.00 21.28           C  
ATOM    489  C   SER A  65      11.822 104.648 -22.524  1.00 22.37           C  
ATOM    490  O   SER A  65      11.982 103.425 -22.496  1.00 21.92           O  
ATOM    491  CB  SER A  65       9.638 105.785 -22.738  1.00 24.08           C  
ATOM    492  OG  SER A  65       8.609 106.488 -22.083  1.00 28.52           O  
ATOM    493  N   GLN A  66      12.593 105.460 -23.247  1.00 22.54           N  
ATOM    494  CA  GLN A  66      13.700 104.946 -24.043  1.00 22.58           C  
ATOM    495  C   GLN A  66      14.555 104.001 -23.222  1.00 21.75           C  
ATOM    496  O   GLN A  66      14.985 102.968 -23.719  1.00 19.55           O  
ATOM    497  CB  GLN A  66      14.592 106.086 -24.551  1.00 23.43           C  
ATOM    498  CG  GLN A  66      15.655 105.661 -25.575  1.00 31.48           C  
ATOM    499  CD  GLN A  66      16.568 106.812 -26.011  1.00 34.20           C  
ATOM    500  OE1 GLN A  66      16.157 107.976 -26.045  1.00 35.85           O  
ATOM    501  NE2 GLN A  66      17.811 106.481 -26.363  1.00 35.31           N  
ATOM    502  N   PHE A  67      14.830 104.353 -21.966  1.00 16.26           N  
ATOM    503  CA  PHE A  67      15.647 103.468 -21.175  1.00 19.79           C  
ATOM    504  C   PHE A  67      14.924 102.494 -20.259  1.00 18.81           C  
ATOM    505  O   PHE A  67      15.536 101.911 -19.371  1.00 22.16           O  
ATOM    506  CB  PHE A  67      16.720 104.270 -20.432  1.00 20.32           C  
ATOM    507  CG  PHE A  67      17.685 104.941 -21.358  1.00 17.24           C  
ATOM    508  CD1 PHE A  67      17.428 106.222 -21.837  1.00 19.53           C  
ATOM    509  CD2 PHE A  67      18.786 104.247 -21.855  1.00 22.85           C  
ATOM    510  CE1 PHE A  67      18.258 106.807 -22.795  1.00 24.12           C  
ATOM    511  CE2 PHE A  67      19.617 104.823 -22.811  1.00 24.18           C  
ATOM    512  CZ  PHE A  67      19.345 106.103 -23.285  1.00 22.84           C  
ATOM    513  N   GLY A  68      13.629 102.308 -20.516  1.00 17.99           N  
ATOM    514  CA  GLY A  68      12.803 101.379 -19.751  1.00 18.35           C  
ATOM    515  C   GLY A  68      12.908 101.458 -18.242  1.00 19.17           C  
ATOM    516  O   GLY A  68      13.019 100.440 -17.550  1.00 18.73           O  
ATOM    517  N   ILE A  69      12.846 102.678 -17.732  1.00 16.49           N  
ATOM    518  CA  ILE A  69      12.946 102.939 -16.305  1.00 16.28           C  
ATOM    519  C   ILE A  69      11.589 102.623 -15.714  1.00 18.17           C  
ATOM    520  O   ILE A  69      10.616 103.272 -16.049  1.00 18.85           O  
ATOM    521  CB  ILE A  69      13.304 104.423 -16.058  1.00 14.90           C  
ATOM    522  CG1 ILE A  69      14.662 104.725 -16.697  1.00 16.62           C  
ATOM    523  CG2 ILE A  69      13.394 104.725 -14.557  1.00 15.12           C  
ATOM    524  CD1 ILE A  69      15.737 103.755 -16.282  1.00 16.67           C  
ATOM    525  N   MET A  70      11.525 101.627 -14.837  1.00 15.74           N  
ATOM    526  CA  MET A  70      10.254 101.244 -14.231  1.00 16.51           C  
ATOM    527  C   MET A  70      10.285 101.413 -12.727  1.00 17.87           C  
ATOM    528  O   MET A  70       9.247 101.373 -12.070  1.00 16.99           O  
ATOM    529  CB  MET A  70       9.939  99.763 -14.492  1.00 19.65           C  
ATOM    530  CG  MET A  70      10.149  99.269 -15.910  1.00 20.94           C  
ATOM    531  SD  MET A  70       9.052 100.061 -17.055  1.00 24.75           S  
ATOM    532  CE  MET A  70       7.507  99.481 -16.488  1.00 27.81           C  
ATOM    533  N   SER A  71      11.483 101.591 -12.184  1.00 16.82           N  
ATOM    534  CA  SER A  71      11.672 101.676 -10.740  1.00 15.38           C  
ATOM    535  C   SER A  71      12.632 102.815 -10.434  1.00 15.08           C  
ATOM    536  O   SER A  71      13.692 102.886 -11.032  1.00 15.45           O  
ATOM    537  CB  SER A  71      12.288 100.337 -10.275  1.00 17.43           C  
ATOM    538  OG  SER A  71      12.604 100.275  -8.890  1.00 15.53           O  
ATOM    539  N   ILE A  72      12.267 103.731  -9.553  1.00 14.70           N  
ATOM    540  CA  ILE A  72      13.241 104.763  -9.216  1.00 14.15           C  
ATOM    541  C   ILE A  72      13.450 104.715  -7.705  1.00 16.29           C  
ATOM    542  O   ILE A  72      12.538 104.341  -6.956  1.00 15.03           O  
ATOM    543  CB  ILE A  72      12.809 106.200  -9.670  1.00 14.28           C  
ATOM    544  CG1 ILE A  72      11.413 106.550  -9.170  1.00 12.54           C  
ATOM    545  CG2 ILE A  72      12.873 106.311 -11.206  1.00 17.21           C  
ATOM    546  CD1 ILE A  72      11.151 108.055  -9.287  1.00 11.37           C  
ATOM    547  N   PRO A  73      14.662 105.073  -7.230  1.00 15.20           N  
ATOM    548  CA  PRO A  73      15.808 105.529  -8.015  1.00 14.25           C  
ATOM    549  C   PRO A  73      16.516 104.455  -8.830  1.00 16.62           C  
ATOM    550  O   PRO A  73      16.568 103.287  -8.441  1.00 15.76           O  
ATOM    551  CB  PRO A  73      16.746 106.120  -6.957  1.00 18.37           C  
ATOM    552  CG  PRO A  73      16.462 105.287  -5.759  1.00 17.14           C  
ATOM    553  CD  PRO A  73      14.946 105.171  -5.789  1.00 17.53           C  
ATOM    554  N   THR A  74      17.044 104.870  -9.975  1.00 15.24           N  
ATOM    555  CA  THR A  74      17.835 103.987 -10.827  1.00 15.78           C  
ATOM    556  C   THR A  74      18.995 104.850 -11.291  1.00 14.11           C  
ATOM    557  O   THR A  74      18.824 106.024 -11.553  1.00 14.21           O  
ATOM    558  CB  THR A  74      17.069 103.478 -12.074  1.00 16.50           C  
ATOM    559  OG1 THR A  74      16.165 102.434 -11.694  1.00 18.75           O  
ATOM    560  CG2 THR A  74      18.041 102.914 -13.103  1.00 19.76           C  
ATOM    561  N   LEU A  75      20.177 104.265 -11.332  1.00 13.11           N  
ATOM    562  CA  LEU A  75      21.344 104.964 -11.804  1.00 14.29           C  
ATOM    563  C   LEU A  75      21.761 104.127 -13.007  1.00 14.23           C  
ATOM    564  O   LEU A  75      21.688 102.896 -12.966  1.00 16.12           O  
ATOM    565  CB  LEU A  75      22.454 104.943 -10.752  1.00 12.52           C  
ATOM    566  CG  LEU A  75      22.308 105.833  -9.522  1.00 14.47           C  
ATOM    567  CD1 LEU A  75      23.240 105.341  -8.442  1.00 14.69           C  
ATOM    568  CD2 LEU A  75      22.619 107.291  -9.894  1.00 19.47           C  
ATOM    569  N   ILE A  76      22.141 104.794 -14.091  1.00 16.90           N  
ATOM    570  CA  ILE A  76      22.637 104.105 -15.285  1.00 15.64           C  
ATOM    571  C   ILE A  76      23.973 104.790 -15.633  1.00 20.11           C  
ATOM    572  O   ILE A  76      24.034 106.019 -15.769  1.00 16.43           O  
ATOM    573  CB  ILE A  76      21.673 104.229 -16.534  1.00 16.17           C  
ATOM    574  CG1 ILE A  76      20.354 103.492 -16.290  1.00 17.54           C  
ATOM    575  CG2 ILE A  76      22.344 103.628 -17.768  1.00 19.81           C  
ATOM    576  CD1 ILE A  76      19.400 103.513 -17.488  1.00 15.43           C  
ATOM    577  N   LEU A  77      25.042 104.001 -15.741  1.00 21.13           N  
ATOM    578  CA  LEU A  77      26.348 104.534 -16.110  1.00 21.83           C  
ATOM    579  C   LEU A  77      26.528 104.305 -17.600  1.00 22.14           C  
ATOM    580  O   LEU A  77      26.436 103.173 -18.080  1.00 24.83           O  
ATOM    581  CB  LEU A  77      27.484 103.824 -15.371  1.00 22.60           C  
ATOM    582  CG  LEU A  77      28.889 104.352 -15.701  1.00 21.39           C  
ATOM    583  CD1 LEU A  77      29.031 105.746 -15.161  1.00 25.27           C  
ATOM    584  CD2 LEU A  77      29.968 103.455 -15.098  1.00 24.26           C  
ATOM    585  N   PHE A  78      26.794 105.389 -18.317  1.00 23.24           N  
ATOM    586  CA  PHE A  78      26.985 105.352 -19.756  1.00 20.81           C  
ATOM    587  C   PHE A  78      28.455 105.528 -20.053  1.00 26.67           C  
ATOM    588  O   PHE A  78      29.115 106.362 -19.441  1.00 25.13           O  
ATOM    589  CB  PHE A  78      26.225 106.493 -20.426  1.00 21.34           C  
ATOM    590  CG  PHE A  78      24.739 106.314 -20.447  1.00 19.06           C  
ATOM    591  CD1 PHE A  78      24.122 105.647 -21.490  1.00 17.94           C  
ATOM    592  CD2 PHE A  78      23.952 106.835 -19.425  1.00 18.40           C  
ATOM    593  CE1 PHE A  78      22.732 105.496 -21.524  1.00 17.64           C  
ATOM    594  CE2 PHE A  78      22.577 106.692 -19.445  1.00 17.36           C  
ATOM    595  CZ  PHE A  78      21.961 106.017 -20.507  1.00 19.40           C  
ATOM    596  N   LYS A  79      28.958 104.717 -20.979  1.00 29.56           N  
ATOM    597  CA  LYS A  79      30.343 104.793 -21.419  1.00 33.06           C  
ATOM    598  C   LYS A  79      30.286 104.544 -22.920  1.00 32.61           C  
ATOM    599  O   LYS A  79      29.579 103.644 -23.377  1.00 32.34           O  
ATOM    600  CB  LYS A  79      31.198 103.724 -20.736  1.00 34.86           C  
ATOM    601  CG  LYS A  79      32.684 103.995 -20.847  1.00 37.65           C  
ATOM    602  CD  LYS A  79      33.499 102.985 -20.063  1.00 43.15           C  
ATOM    603  CE  LYS A  79      33.138 103.003 -18.591  1.00 42.36           C  
ATOM    604  NZ  LYS A  79      33.955 102.014 -17.830  1.00 49.06           N  
ATOM    605  N   GLY A  80      31.012 105.351 -23.687  1.00 32.55           N  
ATOM    606  CA  GLY A  80      30.994 105.199 -25.130  1.00 32.14           C  
ATOM    607  C   GLY A  80      29.607 105.400 -25.710  1.00 32.16           C  
ATOM    608  O   GLY A  80      29.294 104.871 -26.772  1.00 31.30           O  
ATOM    609  N   GLY A  81      28.765 106.161 -25.014  1.00 32.31           N  
ATOM    610  CA  GLY A  81      27.417 106.406 -25.507  1.00 29.58           C  
ATOM    611  C   GLY A  81      26.417 105.275 -25.298  1.00 30.77           C  
ATOM    612  O   GLY A  81      25.315 105.316 -25.845  1.00 29.47           O  
ATOM    613  N   ARG A  82      26.794 104.263 -24.521  1.00 27.49           N  
ATOM    614  CA  ARG A  82      25.904 103.129 -24.251  1.00 29.69           C  
ATOM    615  C   ARG A  82      25.851 102.793 -22.767  1.00 28.41           C  
ATOM    616  O   ARG A  82      26.858 102.872 -22.065  1.00 28.99           O  
ATOM    617  CB  ARG A  82      26.370 101.871 -24.996  1.00 30.73           C  
ATOM    618  CG  ARG A  82      26.255 101.923 -26.515  1.00 36.03           C  
ATOM    619  CD  ARG A  82      25.308 100.836 -27.049  1.00 40.52           C  
ATOM    620  NE  ARG A  82      23.887 101.165 -26.891  1.00 45.00           N  
ATOM    621  CZ  ARG A  82      22.892 100.307 -27.106  1.00 45.21           C  
ATOM    622  NH1 ARG A  82      23.152  99.062 -27.486  1.00 45.58           N  
ATOM    623  NH2 ARG A  82      21.640 100.689 -26.948  1.00 45.66           N  
ATOM    624  N   PRO A  83      24.671 102.400 -22.270  1.00 30.66           N  
ATOM    625  CA  PRO A  83      24.551 102.054 -20.850  1.00 32.70           C  
ATOM    626  C   PRO A  83      25.380 100.802 -20.576  1.00 33.94           C  
ATOM    627  O   PRO A  83      25.250  99.801 -21.281  1.00 40.32           O  
ATOM    628  CB  PRO A  83      23.054 101.819 -20.674  1.00 30.40           C  
ATOM    629  CG  PRO A  83      22.617 101.331 -22.006  1.00 33.64           C  
ATOM    630  CD  PRO A  83      23.393 102.203 -22.977  1.00 29.20           C  
ATOM    631  N   VAL A  84      26.251 100.848 -19.575  1.00 33.86           N  
ATOM    632  CA  VAL A  84      27.067  99.685 -19.270  1.00 33.00           C  
ATOM    633  C   VAL A  84      26.735  99.108 -17.895  1.00 32.39           C  
ATOM    634  O   VAL A  84      27.023  97.944 -17.604  1.00 30.62           O  
ATOM    635  CB  VAL A  84      28.580 100.012 -19.364  1.00 34.66           C  
ATOM    636  CG1 VAL A  84      28.938 100.395 -20.802  1.00 33.38           C  
ATOM    637  CG2 VAL A  84      28.939 101.142 -18.412  1.00 35.43           C  
ATOM    638  N   LYS A  85      26.107  99.910 -17.049  1.00 26.81           N  
ATOM    639  CA  LYS A  85      25.742  99.417 -15.732  1.00 25.21           C  
ATOM    640  C   LYS A  85      24.545 100.148 -15.176  1.00 25.96           C  
ATOM    641  O   LYS A  85      24.412 101.358 -15.372  1.00 24.17           O  
ATOM    642  CB  LYS A  85      26.902  99.563 -14.753  1.00 25.81           C  
ATOM    643  CG  LYS A  85      26.721  98.682 -13.544  1.00 28.14           C  
ATOM    644  CD  LYS A  85      27.957  98.633 -12.699  1.00 34.34           C  
ATOM    645  CE  LYS A  85      27.879  97.465 -11.732  1.00 36.76           C  
ATOM    646  NZ  LYS A  85      29.021  97.463 -10.775  1.00 42.57           N  
ATOM    647  N   GLN A  86      23.671  99.402 -14.502  1.00 23.16           N  
ATOM    648  CA  GLN A  86      22.488  99.973 -13.862  1.00 23.06           C  
ATOM    649  C   GLN A  86      22.506  99.639 -12.384  1.00 21.83           C  
ATOM    650  O   GLN A  86      22.871  98.530 -12.005  1.00 22.12           O  
ATOM    651  CB  GLN A  86      21.200  99.377 -14.421  1.00 25.19           C  
ATOM    652  CG  GLN A  86      20.539 100.122 -15.538  1.00 29.02           C  
ATOM    653  CD  GLN A  86      19.122  99.635 -15.734  1.00 26.76           C  
ATOM    654  OE1 GLN A  86      18.479  99.130 -14.796  1.00 29.69           O  
ATOM    655  NE2 GLN A  86      18.617  99.785 -16.946  1.00 32.44           N  
ATOM    656  N   LEU A  87      22.121 100.587 -11.542  1.00 19.51           N  
ATOM    657  CA  LEU A  87      22.048 100.311 -10.114  1.00 19.18           C  
ATOM    658  C   LEU A  87      20.642 100.660  -9.684  1.00 19.96           C  
ATOM    659  O   LEU A  87      20.197 101.795  -9.854  1.00 21.02           O  
ATOM    660  CB  LEU A  87      23.042 101.148  -9.317  1.00 21.25           C  
ATOM    661  CG  LEU A  87      24.515 100.889  -9.620  1.00 22.30           C  
ATOM    662  CD1 LEU A  87      25.384 101.663  -8.624  1.00 23.42           C  
ATOM    663  CD2 LEU A  87      24.782  99.385  -9.525  1.00 24.13           C  
ATOM    664  N   ILE A  88      19.933  99.689  -9.126  1.00 19.11           N  
ATOM    665  CA  ILE A  88      18.566  99.932  -8.705  1.00 15.73           C  
ATOM    666  C   ILE A  88      18.441 100.134  -7.199  1.00 16.90           C  
ATOM    667  O   ILE A  88      18.975  99.353  -6.413  1.00 15.01           O  
ATOM    668  CB  ILE A  88      17.653  98.767  -9.166  1.00 15.68           C  
ATOM    669  CG1 ILE A  88      17.758  98.628 -10.689  1.00 19.16           C  
ATOM    670  CG2 ILE A  88      16.190  99.065  -8.797  1.00 17.26           C  
ATOM    671  CD1 ILE A  88      16.991  97.454 -11.303  1.00 18.37           C  
ATOM    672  N   GLY A  89      17.755 101.205  -6.805  1.00 17.56           N  
ATOM    673  CA  GLY A  89      17.557 101.482  -5.393  1.00 18.70           C  
ATOM    674  C   GLY A  89      18.583 102.409  -4.770  1.00 18.64           C  
ATOM    675  O   GLY A  89      19.612 102.735  -5.368  1.00 18.99           O  
ATOM    676  N   TYR A  90      18.295 102.828  -3.547  1.00 16.21           N  
ATOM    677  CA  TYR A  90      19.170 103.723  -2.805  1.00 20.97           C  
ATOM    678  C   TYR A  90      20.570 103.140  -2.700  1.00 17.57           C  
ATOM    679  O   TYR A  90      20.723 101.990  -2.302  1.00 18.99           O  
ATOM    680  CB  TYR A  90      18.608 103.943  -1.399  1.00 20.13           C  
ATOM    681  CG  TYR A  90      19.498 104.812  -0.546  1.00 20.70           C  
ATOM    682  CD1 TYR A  90      19.547 106.189  -0.747  1.00 24.25           C  
ATOM    683  CD2 TYR A  90      20.288 104.261   0.464  1.00 26.20           C  
ATOM    684  CE1 TYR A  90      20.386 106.993   0.002  1.00 27.47           C  
ATOM    685  CE2 TYR A  90      21.139 105.063   1.225  1.00 28.30           C  
ATOM    686  CZ  TYR A  90      21.163 106.432   0.999  1.00 28.23           C  
ATOM    687  OH  TYR A  90      21.981 107.247   1.745  1.00 34.61           O  
ATOM    688  N   GLN A  91      21.594 103.922  -3.042  1.00 17.55           N  
ATOM    689  CA  GLN A  91      22.972 103.427  -2.943  1.00 19.61           C  
ATOM    690  C   GLN A  91      23.773 104.341  -2.018  1.00 18.35           C  
ATOM    691  O   GLN A  91      23.980 105.512  -2.329  1.00 20.01           O  
ATOM    692  CB  GLN A  91      23.665 103.407  -4.323  1.00 21.51           C  
ATOM    693  CG  GLN A  91      22.909 102.697  -5.456  1.00 18.49           C  
ATOM    694  CD  GLN A  91      22.867 101.207  -5.262  1.00 23.40           C  
ATOM    695  OE1 GLN A  91      23.856 100.606  -4.863  1.00 24.39           O  
ATOM    696  NE2 GLN A  91      21.720 100.596  -5.546  1.00 18.69           N  
ATOM    697  N   PRO A  92      24.200 103.833  -0.849  1.00 19.50           N  
ATOM    698  CA  PRO A  92      24.986 104.687   0.050  1.00 19.93           C  
ATOM    699  C   PRO A  92      26.364 104.890  -0.563  1.00 21.67           C  
ATOM    700  O   PRO A  92      26.719 104.210  -1.526  1.00 20.60           O  
ATOM    701  CB  PRO A  92      25.029 103.895   1.355  1.00 21.61           C  
ATOM    702  CG  PRO A  92      24.848 102.462   0.909  1.00 24.93           C  
ATOM    703  CD  PRO A  92      23.849 102.551  -0.212  1.00 21.50           C  
ATOM    704  N   LYS A  93      27.127 105.833  -0.016  1.00 22.19           N  
ATOM    705  CA  LYS A  93      28.458 106.130  -0.512  1.00 24.65           C  
ATOM    706  C   LYS A  93      29.324 104.884  -0.767  1.00 22.73           C  
ATOM    707  O   LYS A  93      29.877 104.740  -1.842  1.00 21.46           O  
ATOM    708  CB  LYS A  93      29.167 107.062   0.479  1.00 24.60           C  
ATOM    709  CG  LYS A  93      30.633 107.335   0.196  1.00 29.11           C  
ATOM    710  CD  LYS A  93      31.185 108.242   1.294  1.00 33.34           C  
ATOM    711  CE  LYS A  93      32.636 108.647   1.072  1.00 35.17           C  
ATOM    712  NZ  LYS A  93      33.581 107.496   1.092  1.00 37.19           N  
ATOM    713  N   GLU A  94      29.419 104.005   0.227  1.00 22.86           N  
ATOM    714  CA  GLU A  94      30.222 102.792   0.098  1.00 25.95           C  
ATOM    715  C   GLU A  94      29.828 101.874  -1.064  1.00 24.89           C  
ATOM    716  O   GLU A  94      30.663 101.318  -1.740  1.00 24.61           O  
ATOM    717  CB  GLU A  94      30.168 101.996   1.422  1.00 25.21           C  
ATOM    718  CG  GLU A  94      30.613 102.775   2.652  0.00 19.95           C  
ATOM    719  CD  GLU A  94      30.509 101.962   3.972  0.00 19.95           C  
ATOM    720  OE1 GLU A  94      30.087 100.802   3.908  0.00 19.95           O  
ATOM    721  OE2 GLU A  94      30.854 102.517   5.025  0.00 19.95           O  
ATOM    722  N   GLN A  95      28.519 101.731  -1.257  1.00 26.61           N  
ATOM    723  CA  GLN A  95      28.031 100.895  -2.355  1.00 27.43           C  
ATOM    724  C   GLN A  95      28.365 101.513  -3.705  1.00 26.91           C  
ATOM    725  O   GLN A  95      28.887 100.839  -4.593  1.00 24.04           O  
ATOM    726  CB  GLN A  95      26.528 100.676  -2.232  1.00 28.87           C  
ATOM    727  CG  GLN A  95      26.179  99.630  -1.201  1.00 35.72           C  
ATOM    728  CD  GLN A  95      26.844  98.302  -1.505  1.00 39.19           C  
ATOM    729  OE1 GLN A  95      27.541  97.736  -0.662  1.00 41.21           O  
ATOM    730  NE2 GLN A  95      26.649  97.807  -2.721  1.00 42.58           N  
ATOM    731  N   LEU A  96      28.043 102.793  -3.860  1.00 27.76           N  
ATOM    732  CA  LEU A  96      28.335 103.497  -5.102  1.00 30.37           C  
ATOM    733  C   LEU A  96      29.815 103.333  -5.413  1.00 31.77           C  
ATOM    734  O   LEU A  96      30.189 102.972  -6.527  1.00 32.35           O  
ATOM    735  CB  LEU A  96      28.022 104.986  -4.969  1.00 32.82           C  
ATOM    736  CG  LEU A  96      26.651 105.502  -5.376  1.00 32.63           C  
ATOM    737  CD1 LEU A  96      26.634 107.026  -5.224  1.00 34.44           C  
ATOM    738  CD2 LEU A  96      26.359 105.097  -6.815  1.00 32.55           C  
ATOM    739  N   GLU A  97      30.661 103.616  -4.425  1.00 31.45           N  
ATOM    740  CA  GLU A  97      32.099 103.481  -4.621  1.00 32.15           C  
ATOM    741  C   GLU A  97      32.462 102.084  -5.091  1.00 30.79           C  
ATOM    742  O   GLU A  97      33.157 101.922  -6.090  1.00 31.69           O  
ATOM    743  CB  GLU A  97      32.848 103.773  -3.328  1.00 33.75           C  
ATOM    744  CG  GLU A  97      33.104 105.233  -3.080  1.00 38.92           C  
ATOM    745  CD  GLU A  97      33.724 105.474  -1.727  1.00 40.32           C  
ATOM    746  OE1 GLU A  97      34.565 104.658  -1.299  1.00 45.55           O  
ATOM    747  OE2 GLU A  97      33.376 106.482  -1.092  1.00 41.71           O  
ATOM    748  N   ALA A  98      31.981 101.079  -4.366  1.00 28.96           N  
ATOM    749  CA  ALA A  98      32.255  99.684  -4.700  1.00 28.59           C  
ATOM    750  C   ALA A  98      31.698  99.285  -6.073  1.00 28.31           C  
ATOM    751  O   ALA A  98      32.399  98.685  -6.887  1.00 27.30           O  
ATOM    752  CB  ALA A  98      31.676  98.777  -3.618  1.00 31.25           C  
ATOM    753  N   GLN A  99      30.437  99.622  -6.326  1.00 24.69           N  
ATOM    754  CA  GLN A  99      29.784  99.291  -7.593  1.00 27.84           C  
ATOM    755  C   GLN A  99      30.404  99.966  -8.811  1.00 28.41           C  
ATOM    756  O   GLN A  99      30.441  99.396  -9.899  1.00 30.43           O  
ATOM    757  CB  GLN A  99      28.309  99.688  -7.547  1.00 27.87           C  
ATOM    758  CG  GLN A  99      27.474  98.912  -6.566  1.00 34.31           C  
ATOM    759  CD  GLN A  99      27.557  97.429  -6.811  1.00 38.47           C  
ATOM    760  OE1 GLN A  99      27.263  96.951  -7.907  1.00 37.01           O  
ATOM    761  NE2 GLN A  99      27.975  96.687  -5.792  1.00 42.43           N  
ATOM    762  N   LEU A 100      30.884 101.187  -8.630  1.00 27.78           N  
ATOM    763  CA  LEU A 100      31.439 101.931  -9.747  1.00 28.80           C  
ATOM    764  C   LEU A 100      32.965 101.987  -9.721  1.00 30.46           C  
ATOM    765  O   LEU A 100      33.573 102.856 -10.337  1.00 28.64           O  
ATOM    766  CB  LEU A 100      30.817 103.337  -9.766  1.00 28.07           C  
ATOM    767  CG  LEU A 100      29.275 103.323  -9.720  1.00 27.54           C  
ATOM    768  CD1 LEU A 100      28.724 104.722  -9.481  1.00 27.32           C  
ATOM    769  CD2 LEU A 100      28.729 102.780 -11.005  1.00 27.94           C  
ATOM    770  N   ALA A 101      33.585 101.042  -9.019  1.00 32.78           N  
ATOM    771  CA  ALA A 101      35.046 100.998  -8.943  1.00 35.11           C  
ATOM    772  C   ALA A 101      35.650 101.023 -10.350  1.00 36.22           C  
ATOM    773  O   ALA A 101      36.721 101.578 -10.558  1.00 39.53           O  
ATOM    774  CB  ALA A 101      35.500  99.750  -8.186  1.00 33.59           C  
ATOM    775  N   ASP A 102      34.933 100.449 -11.311  1.00 37.94           N  
ATOM    776  CA  ASP A 102      35.372 100.406 -12.701  1.00 41.01           C  
ATOM    777  C   ASP A 102      35.627 101.808 -13.283  1.00 41.67           C  
ATOM    778  O   ASP A 102      36.767 102.153 -13.612  1.00 45.63           O  
ATOM    779  CB  ASP A 102      34.340  99.650 -13.563  1.00 40.68           C  
ATOM    780  CG  ASP A 102      33.042 100.442 -13.794  1.00 43.95           C  
ATOM    781  OD1 ASP A 102      32.271 100.652 -12.831  1.00 40.50           O  
ATOM    782  OD2 ASP A 102      32.801 100.852 -14.958  1.00 43.94           O  
ATOM    783  N   VAL A 103      34.563 102.603 -13.391  1.00 41.67           N  
ATOM    784  CA  VAL A 103      34.621 103.967 -13.922  1.00 40.45           C  
ATOM    785  C   VAL A 103      35.562 104.803 -13.071  1.00 40.51           C  
ATOM    786  O   VAL A 103      36.107 105.805 -13.524  1.00 43.65           O  
ATOM    787  CB  VAL A 103      33.218 104.649 -13.888  1.00 39.22           C  
ATOM    788  CG1 VAL A 103      32.973 105.293 -12.524  1.00 38.83           C  
ATOM    789  CG2 VAL A 103      33.108 105.690 -14.982  1.00 37.69           C  
ATOM    790  N   LEU A 104      35.741 104.381 -11.825  1.00 39.44           N  
ATOM    791  CA  LEU A 104      36.594 105.097 -10.890  1.00 40.34           C  
ATOM    792  C   LEU A 104      38.096 104.916 -11.107  1.00 42.80           C  
ATOM    793  O   LEU A 104      38.888 105.269 -10.234  1.00 45.97           O  
ATOM    794  CB  LEU A 104      36.227 104.709  -9.456  0.00 36.23           C  
ATOM    795  CG  LEU A 104      34.778 105.016  -9.060  0.00 33.17           C  
ATOM    796  CD1 LEU A 104      34.538 104.604  -7.618  0.00 31.29           C  
ATOM    797  CD2 LEU A 104      34.496 106.496  -9.251  0.00 31.30           C  
ATOM    798  N   GLN A 105      38.481 104.389 -12.270  1.00 42.66           N  
ATOM    799  CA  GLN A 105      39.887 104.190 -12.594  1.00 42.17           C  
ATOM    800  C   GLN A 105      40.507 105.287 -13.463  1.00 43.44           C  
ATOM    801  O   GLN A 105      41.189 106.160 -12.950  1.00 48.72           O  
ATOM    802  CB  GLN A 105      40.097 102.857 -13.323  1.00 38.76           C  
ATOM    803  CG  GLN A 105      39.806 101.614 -12.512  0.00 32.86           C  
ATOM    804  CD  GLN A 105      39.923 100.357 -13.347  0.00 29.93           C  
ATOM    805  OE1 GLN A 105      40.487 100.380 -14.442  0.00 28.01           O  
ATOM    806  NE2 GLN A 105      39.399  99.251 -12.834  0.00 28.01           N  
ATOM    807  OXT GLN A 105      40.253 105.272 -14.708  0.00 19.95           O  
TER     808      GLN A 105                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
