
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   88 ( 1369),  selected   88 , name 2npb_A
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2npb_A.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    A     2_A      T      12          1.445
LGA    L     3_A      H      13          0.959
LGA    A     4_A      R      14          0.926
LGA    V     5_A      V      15          1.025
LGA    R     6_A      Q      16          1.244
LGA    V     7_A      I      17          1.744
LGA    V     8_A      E      18          1.982
LGA    Y     9_A      Y      19          2.287
LGA    S    10_A      C      20          1.720
LGA    G    11_A      T      21          0.395
LGA    A    12_A      Q      22          1.926
LGA    C    13_A      C      23          5.382
LGA    G    14_A      R      24          3.419
LGA    Y    15_A      W      25          2.995
LGA    K    16_A      L      26          3.107
LGA    P    17_A      P      27          2.045
LGA    K    18_A      R      28          0.969
LGA    Y    19_A      A      29          1.132
LGA    L    20_A      A      30          1.893
LGA    Q    21_A      W      31          1.580
LGA    L    22_A      L      32          0.974
LGA    K    23_A      A      33          0.720
LGA    E    24_A      Q      34          0.362
LGA    K    25_A      E      35          0.720
LGA    L    26_A      L      36          0.483
LGA    E    27_A      L      37          0.475
LGA    H    28_A      T      38          0.485
LGA    E    29_A      T      39          0.537
LGA    F    30_A      F      40          1.246
LGA    P    31_A      E      41          0.958
LGA    G    32_A      T      42          4.083
LGA    C    33_A      E      43          1.900
LGA    L    34_A      L      44          0.895
LGA    -       -      T      45           -
LGA    D    35_A      E      46          2.376
LGA    I    36_A      L      47          1.711
LGA    C    37_A      A      48          1.008
LGA    G    38_A      L      49          1.976
LGA    E    39_A      K      50          1.813
LGA    G    40_A      P      51          2.090
LGA    T    41_A      G      52          3.453
LGA    P    42_A      T      53          3.390
LGA    Q    43_A      -       -           -
LGA    V    44_A      -       -           -
LGA    T    45_A      G      54          1.085
LGA    G    46_A      G      55          1.343
LGA    F    47_A      V      56          1.804
LGA    F    48_A      F      57          0.341
LGA    E    49_A      V      58          1.502
LGA    V    50_A      V      59          1.421
LGA    T    51_A      R      60          1.080
LGA    V    52_A      V      61          0.522
LGA    A    53_A      D      62          0.618
LGA    G    54_A      D      63          1.665
LGA    K    55_A      E      64          1.503
LGA    L    56_A      V      65          1.487
LGA    V    57_A      V      66          1.329
LGA    H    58_A      W      67          1.150
LGA    S    59_A      D      68          1.150
LGA    K    60_A      R      69          1.436
LGA    K    61_A      R      70          2.970
LGA    R    62_A      E      71          3.128
LGA    G    63_A      -       -           -
LGA    D    64_A      Q      72          1.568
LGA    G    65_A      G      73          1.100
LGA    Y    66_A      F      74          1.539
LGA    V    67_A      P      75          1.910
LGA    D    68_A      -       -           -
LGA    T    69_A      -       -           -
LGA    E    70_A      -       -           -
LGA    S    71_A      -       -           -
LGA    K    72_A      E      76          3.957
LGA    F    73_A      P      77          2.611
LGA    R    74_A      T      78          1.764
LGA    K    75_A      A      79          2.265
LGA    L    76_A      V      80          1.873
LGA    V    77_A      K      81          1.453
LGA    T    78_A      R      82          1.717
LGA    A    79_A      L      83          2.510
LGA    I    80_A      V      84          2.046
LGA    K    81_A      R      85          2.392
LGA    A    82_A      D      86          3.225
LGA    A    83_A      R      87          2.559
LGA    L    84_A      V      88          2.630
LGA    A    85_A      -       -           -
LGA    Q    86_A      -       -           -
LGA    C    87_A      -       -           -
LGA    Q    88_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   88   77    5.0     76    1.99    18.42     87.241     3.629

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.034774 * X  +  -0.140835 * Y  +   0.989422 * Z  +  37.345558
  Y_new =   0.818689 * X  +  -0.571821 * Y  +  -0.052620 * Z  + 109.089790
  Z_new =   0.573183 * X  +   0.808199 * Y  +   0.135185 * Z  + -22.950111 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.405064   -1.736529  [ DEG:    80.5042    -99.4958 ]
  Theta =  -0.610385   -2.531207  [ DEG:   -34.9725   -145.0275 ]
  Phi   =   1.613246   -1.528346  [ DEG:    92.4322    -87.5678 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2npb_A                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2npb_A.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   88   77   5.0   76   1.99   18.42  87.241
REMARK  ---------------------------------------------------------- 
MOLECULE 2npb_A
HEADER    OXIDOREDUCTASE                          27-OCT-06   2NPB              
TITLE     NMR SOLUTION STRUCTURE OF MOUSE SELW                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SELENOPROTEIN W;                                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 STRAIN: C57BL-6;                                                     
SOURCE   5 TISSUE: BRAIN;                                                       
SOURCE   6 GENE: SEPW1;                                                         
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: ER2566;                                    
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PFA6 DERIVATE OF PET21B                   
KEYWDS    NMR, SELENOPROTEIN, STRUCTURE, THIOREDOXIN-LIKE FOLD,                 
KEYWDS   2 OXIDOREDUCTASE                                                       
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    F.L.AACHMANN,D.E.FOMENKO,A.SORAGNI,V.N.GLADYSHEV,A.DIKIY              
REVDAT   2   18-MAR-08 2NPB    1       JRNL   VERSN                             
REVDAT   1   14-NOV-06 2NPB    0                                                
JRNL        AUTH   F.L.AACHMANN,D.E.FOMENKO,A.SORAGNI,V.N.GLADYSHEV,            
JRNL        AUTH 2 A.DIKIY                                                      
JRNL        TITL   SOLUTION STRUCTURE OF SELENOPROTEIN W AND NMR                
JRNL        TITL 2 ANALYSIS OF ITS INTERACTION WITH 14-3-3 PROTEINS             
JRNL        REF    J.BIOL.CHEM.                  V. 282 37036 2007              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2NPB A    1    88  UNP    P63300   SEPW1_MOUSE      1     88             
SEQRES   1 A   96  MET ALA LEU ALA VAL ARG VAL VAL TYR SER GLY ALA CYS          
SEQRES   2 A   96  GLY TYR LYS PRO LYS TYR LEU GLN LEU LYS GLU LYS LEU          
SEQRES   3 A   96  GLU HIS GLU PHE PRO GLY CYS LEU ASP ILE CYS GLY GLU          
SEQRES   4 A   96  GLY THR PRO GLN VAL THR GLY PHE PHE GLU VAL THR VAL          
SEQRES   5 A   96  ALA GLY LYS LEU VAL HIS SER LYS LYS ARG GLY ASP GLY          
SEQRES   6 A   96  TYR VAL ASP THR GLU SER LYS PHE ARG LYS LEU VAL THR          
SEQRES   7 A   96  ALA ILE LYS ALA ALA LEU ALA GLN CYS GLN LEU GLU HIS          
SEQRES   8 A   96  HIS HIS HIS HIS HIS                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      38.095 109.910 -21.845  1.00  0.00           N  
ATOM      2  CA  MET A   1      36.828 110.668 -21.779  1.00  0.00           C  
ATOM      3  C   MET A   1      36.429 110.877 -20.324  1.00  0.00           C  
ATOM      4  O   MET A   1      36.899 110.137 -19.462  1.00  0.00           O  
ATOM      5  CB  MET A   1      35.713 109.932 -22.551  1.00  0.00           C  
ATOM      6  CG  MET A   1      34.485 110.786 -22.889  1.00  0.00           C  
ATOM      7  SD  MET A   1      34.873 112.405 -23.594  1.00  0.00           S  
ATOM      8  CE  MET A   1      33.398 112.662 -24.614  1.00  0.00           C  
ATOM      9  H1  MET A   1      38.039 109.066 -21.287  1.00  0.00           H  
ATOM     10  H2  MET A   1      38.878 110.446 -21.501  1.00  0.00           H  
ATOM     11  H3  MET A   1      38.303 109.658 -22.805  1.00  0.00           H  
ATOM     12  HA  MET A   1      36.990 111.637 -22.247  1.00  0.00           H  
ATOM     13  HB2 MET A   1      36.101 109.588 -23.503  1.00  0.00           H  
ATOM     14  HB3 MET A   1      35.393 109.053 -21.992  1.00  0.00           H  
ATOM     15  HG2 MET A   1      33.883 110.228 -23.606  1.00  0.00           H  
ATOM     16  HG3 MET A   1      33.876 110.939 -22.002  1.00  0.00           H  
ATOM     17  HE1 MET A   1      32.509 112.687 -23.983  1.00  0.00           H  
ATOM     18  HE2 MET A   1      33.489 113.605 -25.151  1.00  0.00           H  
ATOM     19  HE3 MET A   1      33.310 111.854 -25.340  1.00  0.00           H  
ATOM     20  N   ALA A   2      35.528 111.826 -20.050  1.00  0.00           N  
ATOM     21  CA  ALA A   2      34.704 111.782 -18.841  1.00  0.00           C  
ATOM     22  C   ALA A   2      33.744 110.566 -18.867  1.00  0.00           C  
ATOM     23  O   ALA A   2      33.675 109.828 -19.854  1.00  0.00           O  
ATOM     24  CB  ALA A   2      33.945 113.113 -18.715  1.00  0.00           C  
ATOM     25  H   ALA A   2      35.178 112.401 -20.802  1.00  0.00           H  
ATOM     26  HA  ALA A   2      35.354 111.671 -17.973  1.00  0.00           H  
ATOM     27  HB1 ALA A   2      33.361 113.124 -17.792  1.00  0.00           H  
ATOM     28  HB2 ALA A   2      34.649 113.946 -18.680  1.00  0.00           H  
ATOM     29  HB3 ALA A   2      33.266 113.244 -19.559  1.00  0.00           H  
ATOM     30  N   LEU A   3      32.949 110.380 -17.811  1.00  0.00           N  
ATOM     31  CA  LEU A   3      31.943 109.323 -17.704  1.00  0.00           C  
ATOM     32  C   LEU A   3      30.600 109.878 -17.218  1.00  0.00           C  
ATOM     33  O   LEU A   3      30.550 110.604 -16.239  1.00  0.00           O  
ATOM     34  CB  LEU A   3      32.473 108.246 -16.744  1.00  0.00           C  
ATOM     35  CG  LEU A   3      32.013 106.811 -17.057  1.00  0.00           C  
ATOM     36  CD1 LEU A   3      32.482 106.311 -18.423  1.00  0.00           C  
ATOM     37  CD2 LEU A   3      32.608 105.847 -16.029  1.00  0.00           C  
ATOM     38  H   LEU A   3      33.065 110.996 -17.021  1.00  0.00           H  
ATOM     39  HA  LEU A   3      31.792 108.898 -18.693  1.00  0.00           H  
ATOM     40  HB2 LEU A   3      33.563 108.266 -16.741  1.00  0.00           H  
ATOM     41  HB3 LEU A   3      32.132 108.518 -15.744  1.00  0.00           H  
ATOM     42  HG  LEU A   3      30.924 106.762 -17.013  1.00  0.00           H  
ATOM     43 HD11 LEU A   3      32.003 106.863 -19.229  1.00  0.00           H  
ATOM     44 HD12 LEU A   3      32.245 105.254 -18.538  1.00  0.00           H  
ATOM     45 HD13 LEU A   3      33.558 106.444 -18.497  1.00  0.00           H  
ATOM     46 HD21 LEU A   3      32.242 104.836 -16.201  1.00  0.00           H  
ATOM     47 HD22 LEU A   3      32.324 106.159 -15.025  1.00  0.00           H  
ATOM     48 HD23 LEU A   3      33.698 105.845 -16.097  1.00  0.00           H  
ATOM     49  N   ALA A   4      29.514 109.502 -17.878  1.00  0.00           N  
ATOM     50  CA  ALA A   4      28.139 109.859 -17.536  1.00  0.00           C  
ATOM     51  C   ALA A   4      27.487 108.808 -16.619  1.00  0.00           C  
ATOM     52  O   ALA A   4      27.402 107.631 -16.987  1.00  0.00           O  
ATOM     53  CB  ALA A   4      27.353 110.041 -18.840  1.00  0.00           C  
ATOM     54  H   ALA A   4      29.692 108.890 -18.641  1.00  0.00           H  
ATOM     55  HA  ALA A   4      28.126 110.810 -17.012  1.00  0.00           H  
ATOM     56  HB1 ALA A   4      27.345 109.114 -19.412  1.00  0.00           H  
ATOM     57  HB2 ALA A   4      26.328 110.332 -18.610  1.00  0.00           H  
ATOM     58  HB3 ALA A   4      27.812 110.835 -19.432  1.00  0.00           H  
ATOM     59  N   VAL A   5      26.985 109.237 -15.456  1.00  0.00           N  
ATOM     60  CA  VAL A   5      26.172 108.434 -14.523  1.00  0.00           C  
ATOM     61  C   VAL A   5      24.748 108.980 -14.509  1.00  0.00           C  
ATOM     62  O   VAL A   5      24.508 110.171 -14.699  1.00  0.00           O  
ATOM     63  CB  VAL A   5      26.747 108.417 -13.089  1.00  0.00           C  
ATOM     64  CG1 VAL A   5      26.022 107.491 -12.099  1.00  0.00           C  
ATOM     65  CG2 VAL A   5      28.220 108.016 -13.018  1.00  0.00           C  
ATOM     66  H   VAL A   5      27.161 110.206 -15.190  1.00  0.00           H  
ATOM     67  HA  VAL A   5      26.138 107.414 -14.872  1.00  0.00           H  
ATOM     68  HB  VAL A   5      26.637 109.413 -12.703  1.00  0.00           H  
ATOM     69 HG11 VAL A   5      26.486 107.579 -11.116  1.00  0.00           H  
ATOM     70 HG12 VAL A   5      24.975 107.765 -11.992  1.00  0.00           H  
ATOM     71 HG13 VAL A   5      26.093 106.455 -12.427  1.00  0.00           H  
ATOM     72 HG21 VAL A   5      28.792 108.567 -13.760  1.00  0.00           H  
ATOM     73 HG22 VAL A   5      28.616 108.259 -12.034  1.00  0.00           H  
ATOM     74 HG23 VAL A   5      28.335 106.951 -13.191  1.00  0.00           H  
ATOM     75  N   ARG A   6      23.776 108.114 -14.269  1.00  0.00           N  
ATOM     76  CA  ARG A   6      22.344 108.423 -14.213  1.00  0.00           C  
ATOM     77  C   ARG A   6      21.645 107.726 -13.062  1.00  0.00           C  
ATOM     78  O   ARG A   6      22.074 106.653 -12.641  1.00  0.00           O  
ATOM     79  CB  ARG A   6      21.657 108.064 -15.546  1.00  0.00           C  
ATOM     80  CG  ARG A   6      22.136 108.915 -16.727  1.00  0.00           C  
ATOM     81  CD  ARG A   6      21.856 110.402 -16.493  1.00  0.00           C  
ATOM     82  NE  ARG A   6      22.278 111.210 -17.639  1.00  0.00           N  
ATOM     83  CZ  ARG A   6      23.424 111.836 -17.800  1.00  0.00           C  
ATOM     84  NH1 ARG A   6      24.402 111.700 -16.963  1.00  0.00           N  
ATOM     85  NH2 ARG A   6      23.611 112.641 -18.796  1.00  0.00           N  
ATOM     86  H   ARG A   6      24.121 107.191 -14.034  1.00  0.00           H  
ATOM     87  HA  ARG A   6      22.231 109.480 -14.020  1.00  0.00           H  
ATOM     88  HB2 ARG A   6      21.841 107.012 -15.772  1.00  0.00           H  
ATOM     89  HB3 ARG A   6      20.577 108.209 -15.446  1.00  0.00           H  
ATOM     90  HG2 ARG A   6      23.205 108.765 -16.874  1.00  0.00           H  
ATOM     91  HG3 ARG A   6      21.608 108.592 -17.627  1.00  0.00           H  
ATOM     92  HD2 ARG A   6      20.784 110.534 -16.338  1.00  0.00           H  
ATOM     93  HD3 ARG A   6      22.364 110.762 -15.603  1.00  0.00           H  
ATOM     94  HE  ARG A   6      21.520 111.382 -18.309  1.00  0.00           H  
ATOM     95 HH11 ARG A   6      24.295 111.103 -16.161  1.00  0.00           H  
ATOM     96 HH12 ARG A   6      25.246 112.277 -17.045  1.00  0.00           H  
ATOM     97 HH21 ARG A   6      22.844 112.803 -19.424  1.00  0.00           H  
ATOM     98 HH22 ARG A   6      24.455 113.194 -18.788  1.00  0.00           H  
ATOM     99  N   VAL A   7      20.530 108.313 -12.627  1.00  0.00           N  
ATOM    100  CA  VAL A   7      19.564 107.744 -11.688  1.00  0.00           C  
ATOM    101  C   VAL A   7      18.174 108.030 -12.238  1.00  0.00           C  
ATOM    102  O   VAL A   7      17.742 109.188 -12.268  1.00  0.00           O  
ATOM    103  CB  VAL A   7      19.702 108.331 -10.271  1.00  0.00           C  
ATOM    104  CG1 VAL A   7      18.737 107.636  -9.302  1.00  0.00           C  
ATOM    105  CG2 VAL A   7      21.128 108.245  -9.716  1.00  0.00           C  
ATOM    106  H   VAL A   7      20.292 109.208 -13.035  1.00  0.00           H  
ATOM    107  HA  VAL A   7      19.711 106.666 -11.621  1.00  0.00           H  
ATOM    108  HB  VAL A   7      19.440 109.383 -10.307  1.00  0.00           H  
ATOM    109 HG11 VAL A   7      17.705 107.760  -9.630  1.00  0.00           H  
ATOM    110 HG12 VAL A   7      18.965 106.572  -9.235  1.00  0.00           H  
ATOM    111 HG13 VAL A   7      18.830 108.081  -8.313  1.00  0.00           H  
ATOM    112 HG21 VAL A   7      21.478 107.215  -9.752  1.00  0.00           H  
ATOM    113 HG22 VAL A   7      21.793 108.876 -10.306  1.00  0.00           H  
ATOM    114 HG23 VAL A   7      21.140 108.602  -8.686  1.00  0.00           H  
ATOM    115  N   VAL A   8      17.484 106.999 -12.712  1.00  0.00           N  
ATOM    116  CA  VAL A   8      16.054 107.096 -13.046  1.00  0.00           C  
ATOM    117  C   VAL A   8      15.225 106.943 -11.766  1.00  0.00           C  
ATOM    118  O   VAL A   8      15.460 106.012 -10.998  1.00  0.00           O  
ATOM    119  CB  VAL A   8      15.615 106.069 -14.109  1.00  0.00           C  
ATOM    120  CG1 VAL A   8      14.377 106.603 -14.846  1.00  0.00           C  
ATOM    121  CG2 VAL A   8      16.667 105.782 -15.183  1.00  0.00           C  
ATOM    122  H   VAL A   8      17.943 106.093 -12.695  1.00  0.00           H  
ATOM    123  HA  VAL A   8      15.869 108.085 -13.450  1.00  0.00           H  
ATOM    124  HB  VAL A   8      15.374 105.126 -13.623  1.00  0.00           H  
ATOM    125 HG11 VAL A   8      13.608 106.907 -14.140  1.00  0.00           H  
ATOM    126 HG12 VAL A   8      14.652 107.464 -15.454  1.00  0.00           H  
ATOM    127 HG13 VAL A   8      13.974 105.831 -15.502  1.00  0.00           H  
ATOM    128 HG21 VAL A   8      16.237 105.131 -15.945  1.00  0.00           H  
ATOM    129 HG22 VAL A   8      16.987 106.715 -15.650  1.00  0.00           H  
ATOM    130 HG23 VAL A   8      17.522 105.274 -14.737  1.00  0.00           H  
ATOM    131  N   TYR A   9      14.297 107.867 -11.484  1.00  0.00           N  
ATOM    132  CA  TYR A   9      13.550 107.913 -10.220  1.00  0.00           C  
ATOM    133  C   TYR A   9      12.098 108.405 -10.375  1.00  0.00           C  
ATOM    134  O   TYR A   9      11.759 109.112 -11.317  1.00  0.00           O  
ATOM    135  CB  TYR A   9      14.324 108.839  -9.265  1.00  0.00           C  
ATOM    136  CG  TYR A   9      13.771 108.946  -7.857  1.00  0.00           C  
ATOM    137  CD1 TYR A   9      13.858 107.833  -7.007  1.00  0.00           C  
ATOM    138  CD2 TYR A   9      13.176 110.137  -7.395  1.00  0.00           C  
ATOM    139  CE1 TYR A   9      13.392 107.911  -5.682  1.00  0.00           C  
ATOM    140  CE2 TYR A   9      12.696 110.215  -6.072  1.00  0.00           C  
ATOM    141  CZ  TYR A   9      12.813 109.106  -5.208  1.00  0.00           C  
ATOM    142  OH  TYR A   9      12.391 109.187  -3.917  1.00  0.00           O  
ATOM    143  H   TYR A   9      14.148 108.628 -12.125  1.00  0.00           H  
ATOM    144  HA  TYR A   9      13.515 106.909  -9.793  1.00  0.00           H  
ATOM    145  HB2 TYR A   9      15.349 108.471  -9.184  1.00  0.00           H  
ATOM    146  HB3 TYR A   9      14.358 109.834  -9.707  1.00  0.00           H  
ATOM    147  HD1 TYR A   9      14.294 106.917  -7.383  1.00  0.00           H  
ATOM    148  HD2 TYR A   9      13.078 110.981  -8.065  1.00  0.00           H  
ATOM    149  HE1 TYR A   9      13.451 107.052  -5.036  1.00  0.00           H  
ATOM    150  HE2 TYR A   9      12.205 111.106  -5.719  1.00  0.00           H  
ATOM    151  HH  TYR A   9      11.780 109.922  -3.800  1.00  0.00           H  
ATOM    152  N   SER A  10      11.254 108.087  -9.394  1.00  0.00           N  
ATOM    153  CA  SER A  10       9.874 108.551  -9.231  1.00  0.00           C  
ATOM    154  C   SER A  10       9.806 109.698  -8.217  1.00  0.00           C  
ATOM    155  O   SER A  10       9.973 109.447  -7.022  1.00  0.00           O  
ATOM    156  CB  SER A  10       8.996 107.392  -8.742  1.00  0.00           C  
ATOM    157  OG  SER A  10       9.552 106.745  -7.605  1.00  0.00           O  
ATOM    158  H   SER A  10      11.627 107.502  -8.665  1.00  0.00           H  
ATOM    159  HA  SER A  10       9.480 108.894 -10.189  1.00  0.00           H  
ATOM    160  HB2 SER A  10       8.017 107.790  -8.483  1.00  0.00           H  
ATOM    161  HB3 SER A  10       8.878 106.668  -9.544  1.00  0.00           H  
ATOM    162  HG  SER A  10       9.796 107.454  -6.989  1.00  0.00           H  
ATOM    163  N   GLY A  11       9.562 110.936  -8.666  1.00  0.00           N  
ATOM    164  CA  GLY A  11       9.576 112.173  -7.857  1.00  0.00           C  
ATOM    165  C   GLY A  11       8.489 112.315  -6.772  1.00  0.00           C  
ATOM    166  O   GLY A  11       7.763 113.304  -6.746  1.00  0.00           O  
ATOM    167  H   GLY A  11       9.449 111.039  -9.666  1.00  0.00           H  
ATOM    168  HA2 GLY A  11      10.547 112.256  -7.365  1.00  0.00           H  
ATOM    169  HA3 GLY A  11       9.471 113.023  -8.533  1.00  0.00           H  
ATOM    170  N   ALA A  12       8.392 111.353  -5.855  1.00  0.00           N  
ATOM    171  CA  ALA A  12       7.493 111.305  -4.703  1.00  0.00           C  
ATOM    172  C   ALA A  12       7.918 112.283  -3.582  1.00  0.00           C  
ATOM    173  O   ALA A  12       8.187 111.882  -2.450  1.00  0.00           O  
ATOM    174  CB  ALA A  12       7.430 109.843  -4.235  1.00  0.00           C  
ATOM    175  H   ALA A  12       9.041 110.585  -5.967  1.00  0.00           H  
ATOM    176  HA  ALA A  12       6.492 111.598  -5.028  1.00  0.00           H  
ATOM    177  HB1 ALA A  12       7.088 109.205  -5.051  1.00  0.00           H  
ATOM    178  HB2 ALA A  12       8.417 109.512  -3.908  1.00  0.00           H  
ATOM    179  HB3 ALA A  12       6.731 109.754  -3.402  1.00  0.00           H  
ATOM    180  N   CYS A  13       7.977 113.579  -3.907  1.00  0.00           N  
ATOM    181  CA  CYS A  13       8.537 114.655  -3.073  1.00  0.00           C  
ATOM    182  C   CYS A  13      10.026 114.410  -2.714  1.00  0.00           C  
ATOM    183  O   CYS A  13      10.657 113.498  -3.246  1.00  0.00           O  
ATOM    184  CB  CYS A  13       7.607 114.868  -1.859  1.00  0.00           C  
ATOM    185  SG  CYS A  13       7.842 116.513  -1.120  1.00  0.00           S  
ATOM    186  H   CYS A  13       7.780 113.763  -4.885  1.00  0.00           H  
ATOM    187  HA  CYS A  13       8.505 115.567  -3.669  1.00  0.00           H  
ATOM    188  HB2 CYS A  13       6.568 114.787  -2.189  1.00  0.00           H  
ATOM    189  HB3 CYS A  13       7.795 114.089  -1.114  1.00  0.00           H  
ATOM    190  HG  CYS A  13       6.877 116.416  -0.193  1.00  0.00           H  
ATOM    191  N   GLY A  14      10.632 115.270  -1.880  1.00  0.00           N  
ATOM    192  CA  GLY A  14      11.931 115.108  -1.188  1.00  0.00           C  
ATOM    193  C   GLY A  14      13.205 114.789  -2.001  1.00  0.00           C  
ATOM    194  O   GLY A  14      14.277 114.628  -1.418  1.00  0.00           O  
ATOM    195  H   GLY A  14      10.014 115.986  -1.519  1.00  0.00           H  
ATOM    196  HA2 GLY A  14      12.134 116.025  -0.632  1.00  0.00           H  
ATOM    197  HA3 GLY A  14      11.819 114.302  -0.460  1.00  0.00           H  
ATOM    198  N   TYR A  15      13.124 114.658  -3.325  1.00  0.00           N  
ATOM    199  CA  TYR A  15      14.132 113.945  -4.110  1.00  0.00           C  
ATOM    200  C   TYR A  15      15.504 114.626  -4.167  1.00  0.00           C  
ATOM    201  O   TYR A  15      16.517 113.939  -4.094  1.00  0.00           O  
ATOM    202  CB  TYR A  15      13.587 113.626  -5.507  1.00  0.00           C  
ATOM    203  CG  TYR A  15      13.535 114.750  -6.524  1.00  0.00           C  
ATOM    204  CD1 TYR A  15      12.624 115.814  -6.368  1.00  0.00           C  
ATOM    205  CD2 TYR A  15      14.333 114.674  -7.686  1.00  0.00           C  
ATOM    206  CE1 TYR A  15      12.517 116.798  -7.367  1.00  0.00           C  
ATOM    207  CE2 TYR A  15      14.215 115.647  -8.695  1.00  0.00           C  
ATOM    208  CZ  TYR A  15      13.299 116.708  -8.537  1.00  0.00           C  
ATOM    209  OH  TYR A  15      13.151 117.634  -9.516  1.00  0.00           O  
ATOM    210  H   TYR A  15      12.180 114.668  -3.688  1.00  0.00           H  
ATOM    211  HA  TYR A  15      14.291 112.988  -3.614  1.00  0.00           H  
ATOM    212  HB2 TYR A  15      14.217 112.836  -5.912  1.00  0.00           H  
ATOM    213  HB3 TYR A  15      12.575 113.234  -5.399  1.00  0.00           H  
ATOM    214  HD1 TYR A  15      11.968 115.863  -5.511  1.00  0.00           H  
ATOM    215  HD2 TYR A  15      15.008 113.844  -7.836  1.00  0.00           H  
ATOM    216  HE1 TYR A  15      11.805 117.606  -7.285  1.00  0.00           H  
ATOM    217  HE2 TYR A  15      14.808 115.569  -9.596  1.00  0.00           H  
ATOM    218  HH  TYR A  15      13.467 117.305 -10.359  1.00  0.00           H  
ATOM    219  N   LYS A  16      15.557 115.959  -4.247  1.00  0.00           N  
ATOM    220  CA  LYS A  16      16.795 116.752  -4.307  1.00  0.00           C  
ATOM    221  C   LYS A  16      17.866 116.358  -3.273  1.00  0.00           C  
ATOM    222  O   LYS A  16      18.941 115.956  -3.714  1.00  0.00           O  
ATOM    223  CB  LYS A  16      16.456 118.256  -4.293  1.00  0.00           C  
ATOM    224  CG  LYS A  16      16.508 118.890  -5.694  1.00  0.00           C  
ATOM    225  CD  LYS A  16      17.924 119.036  -6.283  1.00  0.00           C  
ATOM    226  CE  LYS A  16      18.820 119.857  -5.346  1.00  0.00           C  
ATOM    227  NZ  LYS A  16      20.085 120.292  -5.994  1.00  0.00           N  
ATOM    228  H   LYS A  16      14.671 116.426  -4.366  1.00  0.00           H  
ATOM    229  HA  LYS A  16      17.263 116.496  -5.258  1.00  0.00           H  
ATOM    230  HB2 LYS A  16      15.447 118.396  -3.892  1.00  0.00           H  
ATOM    231  HB3 LYS A  16      17.140 118.787  -3.628  1.00  0.00           H  
ATOM    232  HG2 LYS A  16      15.899 118.293  -6.377  1.00  0.00           H  
ATOM    233  HG3 LYS A  16      16.065 119.887  -5.629  1.00  0.00           H  
ATOM    234  HD2 LYS A  16      18.364 118.053  -6.454  1.00  0.00           H  
ATOM    235  HD3 LYS A  16      17.834 119.545  -7.244  1.00  0.00           H  
ATOM    236  HE2 LYS A  16      18.233 120.719  -5.011  1.00  0.00           H  
ATOM    237  HE3 LYS A  16      19.052 119.248  -4.465  1.00  0.00           H  
ATOM    238  HZ1 LYS A  16      20.641 119.492  -6.274  1.00  0.00           H  
ATOM    239  HZ2 LYS A  16      20.655 120.827  -5.348  1.00  0.00           H  
ATOM    240  HZ3 LYS A  16      19.906 120.859  -6.811  1.00  0.00           H  
ATOM    241  N   PRO A  17      17.646 116.443  -1.946  1.00  0.00           N  
ATOM    242  CA  PRO A  17      18.650 116.010  -0.967  1.00  0.00           C  
ATOM    243  C   PRO A  17      18.947 114.502  -1.033  1.00  0.00           C  
ATOM    244  O   PRO A  17      20.106 114.108  -0.919  1.00  0.00           O  
ATOM    245  CB  PRO A  17      18.107 116.438   0.401  1.00  0.00           C  
ATOM    246  CG  PRO A  17      16.598 116.547   0.182  1.00  0.00           C  
ATOM    247  CD  PRO A  17      16.497 117.024  -1.267  1.00  0.00           C  
ATOM    248  HA  PRO A  17      19.590 116.535  -1.147  1.00  0.00           H  
ATOM    249  HB2 PRO A  17      18.349 115.720   1.188  1.00  0.00           H  
ATOM    250  HB3 PRO A  17      18.506 117.422   0.655  1.00  0.00           H  
ATOM    251  HG2 PRO A  17      16.143 115.561   0.280  1.00  0.00           H  
ATOM    252  HG3 PRO A  17      16.136 117.253   0.873  1.00  0.00           H  
ATOM    253  HD2 PRO A  17      15.553 116.711  -1.707  1.00  0.00           H  
ATOM    254  HD3 PRO A  17      16.577 118.112  -1.293  1.00  0.00           H  
ATOM    255  N   LYS A  18      17.934 113.658  -1.284  1.00  0.00           N  
ATOM    256  CA  LYS A  18      18.077 112.198  -1.454  1.00  0.00           C  
ATOM    257  C   LYS A  18      19.025 111.819  -2.600  1.00  0.00           C  
ATOM    258  O   LYS A  18      19.824 110.898  -2.454  1.00  0.00           O  
ATOM    259  CB  LYS A  18      16.679 111.588  -1.640  1.00  0.00           C  
ATOM    260  CG  LYS A  18      16.692 110.061  -1.804  1.00  0.00           C  
ATOM    261  CD  LYS A  18      15.255 109.525  -1.897  1.00  0.00           C  
ATOM    262  CE  LYS A  18      15.202 108.046  -2.299  1.00  0.00           C  
ATOM    263  NZ  LYS A  18      15.866 107.162  -1.307  1.00  0.00           N  
ATOM    264  H   LYS A  18      17.015 114.067  -1.394  1.00  0.00           H  
ATOM    265  HA  LYS A  18      18.527 111.789  -0.548  1.00  0.00           H  
ATOM    266  HB2 LYS A  18      16.073 111.849  -0.770  1.00  0.00           H  
ATOM    267  HB3 LYS A  18      16.210 112.020  -2.525  1.00  0.00           H  
ATOM    268  HG2 LYS A  18      17.224 109.797  -2.719  1.00  0.00           H  
ATOM    269  HG3 LYS A  18      17.200 109.609  -0.951  1.00  0.00           H  
ATOM    270  HD2 LYS A  18      14.747 109.669  -0.942  1.00  0.00           H  
ATOM    271  HD3 LYS A  18      14.715 110.098  -2.654  1.00  0.00           H  
ATOM    272  HE2 LYS A  18      14.149 107.765  -2.409  1.00  0.00           H  
ATOM    273  HE3 LYS A  18      15.677 107.936  -3.279  1.00  0.00           H  
ATOM    274  HZ1 LYS A  18      16.853 107.371  -1.258  1.00  0.00           H  
ATOM    275  HZ2 LYS A  18      15.776 106.188  -1.586  1.00  0.00           H  
ATOM    276  HZ3 LYS A  18      15.458 107.272  -0.390  1.00  0.00           H  
ATOM    277  N   TYR A  19      18.939 112.535  -3.722  1.00  0.00           N  
ATOM    278  CA  TYR A  19      19.912 112.511  -4.815  1.00  0.00           C  
ATOM    279  C   TYR A  19      21.270 113.015  -4.333  1.00  0.00           C  
ATOM    280  O   TYR A  19      22.234 112.259  -4.315  1.00  0.00           O  
ATOM    281  CB  TYR A  19      19.413 113.375  -5.992  1.00  0.00           C  
ATOM    282  CG  TYR A  19      18.724 112.627  -7.113  1.00  0.00           C  
ATOM    283  CD1 TYR A  19      17.386 112.209  -6.979  1.00  0.00           C  
ATOM    284  CD2 TYR A  19      19.413 112.407  -8.322  1.00  0.00           C  
ATOM    285  CE1 TYR A  19      16.730 111.596  -8.066  1.00  0.00           C  
ATOM    286  CE2 TYR A  19      18.761 111.792  -9.405  1.00  0.00           C  
ATOM    287  CZ  TYR A  19      17.409 111.398  -9.288  1.00  0.00           C  
ATOM    288  OH  TYR A  19      16.746 110.842 -10.337  1.00  0.00           O  
ATOM    289  H   TYR A  19      18.209 113.239  -3.761  1.00  0.00           H  
ATOM    290  HA  TYR A  19      20.066 111.483  -5.149  1.00  0.00           H  
ATOM    291  HB2 TYR A  19      18.734 114.148  -5.624  1.00  0.00           H  
ATOM    292  HB3 TYR A  19      20.268 113.891  -6.431  1.00  0.00           H  
ATOM    293  HD1 TYR A  19      16.856 112.367  -6.051  1.00  0.00           H  
ATOM    294  HD2 TYR A  19      20.443 112.722  -8.427  1.00  0.00           H  
ATOM    295  HE1 TYR A  19      15.706 111.271  -7.987  1.00  0.00           H  
ATOM    296  HE2 TYR A  19      19.305 111.630 -10.322  1.00  0.00           H  
ATOM    297  HH  TYR A  19      17.322 110.396 -10.977  1.00  0.00           H  
ATOM    298  N   LEU A  20      21.359 114.292  -3.949  1.00  0.00           N  
ATOM    299  CA  LEU A  20      22.616 114.991  -3.680  1.00  0.00           C  
ATOM    300  C   LEU A  20      23.501 114.278  -2.663  1.00  0.00           C  
ATOM    301  O   LEU A  20      24.705 114.215  -2.844  1.00  0.00           O  
ATOM    302  CB  LEU A  20      22.319 116.422  -3.210  1.00  0.00           C  
ATOM    303  CG  LEU A  20      22.369 117.453  -4.343  1.00  0.00           C  
ATOM    304  CD1 LEU A  20      21.366 117.242  -5.480  1.00  0.00           C  
ATOM    305  CD2 LEU A  20      22.182 118.864  -3.779  1.00  0.00           C  
ATOM    306  H   LEU A  20      20.500 114.831  -3.927  1.00  0.00           H  
ATOM    307  HA  LEU A  20      23.196 115.045  -4.603  1.00  0.00           H  
ATOM    308  HB2 LEU A  20      21.358 116.440  -2.715  1.00  0.00           H  
ATOM    309  HB3 LEU A  20      23.074 116.712  -2.476  1.00  0.00           H  
ATOM    310  HG  LEU A  20      23.349 117.375  -4.777  1.00  0.00           H  
ATOM    311 HD11 LEU A  20      21.620 117.914  -6.297  1.00  0.00           H  
ATOM    312 HD12 LEU A  20      20.353 117.400  -5.129  1.00  0.00           H  
ATOM    313 HD13 LEU A  20      21.463 116.228  -5.867  1.00  0.00           H  
ATOM    314 HD21 LEU A  20      22.892 119.014  -2.964  1.00  0.00           H  
ATOM    315 HD22 LEU A  20      21.171 119.000  -3.401  1.00  0.00           H  
ATOM    316 HD23 LEU A  20      22.438 119.588  -4.550  1.00  0.00           H  
ATOM    317  N   GLN A  21      22.951 113.693  -1.605  1.00  0.00           N  
ATOM    318  CA  GLN A  21      23.821 113.069  -0.607  1.00  0.00           C  
ATOM    319  C   GLN A  21      24.576 111.842  -1.164  1.00  0.00           C  
ATOM    320  O   GLN A  21      25.626 111.504  -0.626  1.00  0.00           O  
ATOM    321  CB  GLN A  21      22.995 112.730   0.653  1.00  0.00           C  
ATOM    322  CG  GLN A  21      23.610 113.239   1.965  1.00  0.00           C  
ATOM    323  CD  GLN A  21      24.867 112.486   2.386  1.00  0.00           C  
ATOM    324  OE1 GLN A  21      25.973 113.008   2.337  1.00  0.00           O  
ATOM    325  NE2 GLN A  21      24.743 111.262   2.845  1.00  0.00           N  
ATOM    326  H   GLN A  21      21.941 113.696  -1.514  1.00  0.00           H  
ATOM    327  HA  GLN A  21      24.599 113.825  -0.397  1.00  0.00           H  
ATOM    328  HB2 GLN A  21      22.013 113.199   0.576  1.00  0.00           H  
ATOM    329  HB3 GLN A  21      22.839 111.649   0.714  1.00  0.00           H  
ATOM    330  HG2 GLN A  21      23.846 114.300   1.862  1.00  0.00           H  
ATOM    331  HG3 GLN A  21      22.869 113.130   2.758  1.00  0.00           H  
ATOM    332 HE21 GLN A  21      23.853 110.802   2.930  1.00  0.00           H  
ATOM    333 HE22 GLN A  21      25.611 110.802   3.063  1.00  0.00           H  
ATOM    334  N   LEU A  22      24.107 111.243  -2.271  1.00  0.00           N  
ATOM    335  CA  LEU A  22      24.875 110.324  -3.123  1.00  0.00           C  
ATOM    336  C   LEU A  22      25.630 111.069  -4.245  1.00  0.00           C  
ATOM    337  O   LEU A  22      26.804 110.788  -4.488  1.00  0.00           O  
ATOM    338  CB  LEU A  22      23.892 109.263  -3.660  1.00  0.00           C  
ATOM    339  CG  LEU A  22      24.520 108.141  -4.513  1.00  0.00           C  
ATOM    340  CD1 LEU A  22      23.617 106.906  -4.477  1.00  0.00           C  
ATOM    341  CD2 LEU A  22      24.664 108.507  -5.993  1.00  0.00           C  
ATOM    342  H   LEU A  22      23.218 111.568  -2.640  1.00  0.00           H  
ATOM    343  HA  LEU A  22      25.625 109.816  -2.513  1.00  0.00           H  
ATOM    344  HB2 LEU A  22      23.427 108.803  -2.784  1.00  0.00           H  
ATOM    345  HB3 LEU A  22      23.102 109.748  -4.237  1.00  0.00           H  
ATOM    346  HG  LEU A  22      25.492 107.870  -4.103  1.00  0.00           H  
ATOM    347 HD11 LEU A  22      22.646 107.134  -4.918  1.00  0.00           H  
ATOM    348 HD12 LEU A  22      23.478 106.599  -3.444  1.00  0.00           H  
ATOM    349 HD13 LEU A  22      24.081 106.082  -5.019  1.00  0.00           H  
ATOM    350 HD21 LEU A  22      23.706 108.837  -6.396  1.00  0.00           H  
ATOM    351 HD22 LEU A  22      25.005 107.641  -6.557  1.00  0.00           H  
ATOM    352 HD23 LEU A  22      25.406 109.290  -6.127  1.00  0.00           H  
ATOM    353  N   LYS A  23      24.975 112.010  -4.938  1.00  0.00           N  
ATOM    354  CA  LYS A  23      25.477 112.682  -6.156  1.00  0.00           C  
ATOM    355  C   LYS A  23      26.685 113.581  -5.877  1.00  0.00           C  
ATOM    356  O   LYS A  23      27.744 113.411  -6.472  1.00  0.00           O  
ATOM    357  CB  LYS A  23      24.340 113.506  -6.796  1.00  0.00           C  
ATOM    358  CG  LYS A  23      24.241 113.402  -8.320  1.00  0.00           C  
ATOM    359  CD  LYS A  23      24.248 114.761  -9.030  1.00  0.00           C  
ATOM    360  CE  LYS A  23      25.562 115.447  -8.689  1.00  0.00           C  
ATOM    361  NZ  LYS A  23      25.907 116.552  -9.604  1.00  0.00           N  
ATOM    362  H   LYS A  23      24.037 112.219  -4.605  1.00  0.00           H  
ATOM    363  HA  LYS A  23      25.822 111.912  -6.848  1.00  0.00           H  
ATOM    364  HB2 LYS A  23      23.384 113.180  -6.418  1.00  0.00           H  
ATOM    365  HB3 LYS A  23      24.471 114.546  -6.514  1.00  0.00           H  
ATOM    366  HG2 LYS A  23      25.075 112.806  -8.676  1.00  0.00           H  
ATOM    367  HG3 LYS A  23      23.315 112.893  -8.575  1.00  0.00           H  
ATOM    368  HD2 LYS A  23      24.174 114.601 -10.102  1.00  0.00           H  
ATOM    369  HD3 LYS A  23      23.407 115.371  -8.698  1.00  0.00           H  
ATOM    370  HE2 LYS A  23      25.480 115.829  -7.676  1.00  0.00           H  
ATOM    371  HE3 LYS A  23      26.342 114.684  -8.678  1.00  0.00           H  
ATOM    372  HZ1 LYS A  23      26.792 116.971  -9.297  1.00  0.00           H  
ATOM    373  HZ2 LYS A  23      25.220 117.282  -9.650  1.00  0.00           H  
ATOM    374  HZ3 LYS A  23      26.199 116.206 -10.519  1.00  0.00           H  
ATOM    375  N   GLU A  24      26.508 114.475  -4.904  1.00  0.00           N  
ATOM    376  CA  GLU A  24      27.504 115.375  -4.316  1.00  0.00           C  
ATOM    377  C   GLU A  24      28.568 114.615  -3.495  1.00  0.00           C  
ATOM    378  O   GLU A  24      29.467 115.227  -2.923  1.00  0.00           O  
ATOM    379  CB  GLU A  24      26.782 116.466  -3.472  1.00  0.00           C  
ATOM    380  CG  GLU A  24      26.789 117.863  -4.135  1.00  0.00           C  
ATOM    381  CD  GLU A  24      25.749 117.999  -5.271  1.00  0.00           C  
ATOM    382  OE1 GLU A  24      25.531 117.006  -5.998  1.00  0.00           O  
ATOM    383  OE2 GLU A  24      25.075 119.053  -5.363  1.00  0.00           O  
ATOM    384  H   GLU A  24      25.578 114.526  -4.494  1.00  0.00           H  
ATOM    385  HA  GLU A  24      28.040 115.870  -5.129  1.00  0.00           H  
ATOM    386  HB2 GLU A  24      25.737 116.214  -3.302  1.00  0.00           H  
ATOM    387  HB3 GLU A  24      27.219 116.508  -2.468  1.00  0.00           H  
ATOM    388  HG2 GLU A  24      26.556 118.597  -3.359  1.00  0.00           H  
ATOM    389  HG3 GLU A  24      27.791 118.081  -4.516  1.00  0.00           H  
ATOM    390  N   LYS A  25      28.478 113.278  -3.405  1.00  0.00           N  
ATOM    391  CA  LYS A  25      29.580 112.364  -3.081  1.00  0.00           C  
ATOM    392  C   LYS A  25      30.351 111.958  -4.337  1.00  0.00           C  
ATOM    393  O   LYS A  25      31.513 112.297  -4.485  1.00  0.00           O  
ATOM    394  CB  LYS A  25      29.033 111.134  -2.320  1.00  0.00           C  
ATOM    395  CG  LYS A  25      29.583 111.040  -0.892  1.00  0.00           C  
ATOM    396  CD  LYS A  25      28.832 111.853   0.177  1.00  0.00           C  
ATOM    397  CE  LYS A  25      28.374 113.208  -0.365  1.00  0.00           C  
ATOM    398  NZ  LYS A  25      27.886 114.121   0.687  1.00  0.00           N  
ATOM    399  H   LYS A  25      27.637 112.848  -3.760  1.00  0.00           H  
ATOM    400  HA  LYS A  25      30.326 112.877  -2.475  1.00  0.00           H  
ATOM    401  HB2 LYS A  25      27.943 111.143  -2.272  1.00  0.00           H  
ATOM    402  HB3 LYS A  25      29.334 110.235  -2.856  1.00  0.00           H  
ATOM    403  HG2 LYS A  25      29.539 109.996  -0.593  1.00  0.00           H  
ATOM    404  HG3 LYS A  25      30.625 111.351  -0.913  1.00  0.00           H  
ATOM    405  HD2 LYS A  25      27.958 111.284   0.503  1.00  0.00           H  
ATOM    406  HD3 LYS A  25      29.499 111.993   1.029  1.00  0.00           H  
ATOM    407  HE2 LYS A  25      29.212 113.658  -0.906  1.00  0.00           H  
ATOM    408  HE3 LYS A  25      27.570 113.022  -1.086  1.00  0.00           H  
ATOM    409  HZ1 LYS A  25      27.574 114.983   0.264  1.00  0.00           H  
ATOM    410  HZ2 LYS A  25      28.619 114.317   1.353  1.00  0.00           H  
ATOM    411  HZ3 LYS A  25      27.107 113.687   1.185  1.00  0.00           H  
ATOM    412  N   LEU A  26      29.691 111.348  -5.310  1.00  0.00           N  
ATOM    413  CA  LEU A  26      30.356 110.753  -6.469  1.00  0.00           C  
ATOM    414  C   LEU A  26      31.180 111.762  -7.299  1.00  0.00           C  
ATOM    415  O   LEU A  26      32.271 111.468  -7.779  1.00  0.00           O  
ATOM    416  CB  LEU A  26      29.273 110.032  -7.287  1.00  0.00           C  
ATOM    417  CG  LEU A  26      29.708 108.638  -7.736  1.00  0.00           C  
ATOM    418  CD1 LEU A  26      29.870 107.633  -6.588  1.00  0.00           C  
ATOM    419  CD2 LEU A  26      28.658 108.075  -8.700  1.00  0.00           C  
ATOM    420  H   LEU A  26      28.709 111.211  -5.143  1.00  0.00           H  
ATOM    421  HA  LEU A  26      31.076 110.036  -6.079  1.00  0.00           H  
ATOM    422  HB2 LEU A  26      28.351 109.960  -6.709  1.00  0.00           H  
ATOM    423  HB3 LEU A  26      29.060 110.624  -8.173  1.00  0.00           H  
ATOM    424  HG  LEU A  26      30.657 108.757  -8.251  1.00  0.00           H  
ATOM    425 HD11 LEU A  26      30.218 106.679  -6.980  1.00  0.00           H  
ATOM    426 HD12 LEU A  26      28.923 107.501  -6.069  1.00  0.00           H  
ATOM    427 HD13 LEU A  26      30.608 107.990  -5.867  1.00  0.00           H  
ATOM    428 HD21 LEU A  26      27.685 108.055  -8.209  1.00  0.00           H  
ATOM    429 HD22 LEU A  26      28.921 107.064  -8.997  1.00  0.00           H  
ATOM    430 HD23 LEU A  26      28.609 108.704  -9.588  1.00  0.00           H  
ATOM    431  N   GLU A  27      30.675 112.985  -7.411  1.00  0.00           N  
ATOM    432  CA  GLU A  27      31.383 114.161  -7.932  1.00  0.00           C  
ATOM    433  C   GLU A  27      32.486 114.737  -7.025  1.00  0.00           C  
ATOM    434  O   GLU A  27      33.478 115.244  -7.533  1.00  0.00           O  
ATOM    435  CB  GLU A  27      30.336 115.247  -8.200  1.00  0.00           C  
ATOM    436  CG  GLU A  27      30.088 115.366  -9.705  1.00  0.00           C  
ATOM    437  CD  GLU A  27      28.843 116.204 -10.022  1.00  0.00           C  
ATOM    438  OE1 GLU A  27      28.523 117.143  -9.256  1.00  0.00           O  
ATOM    439  OE2 GLU A  27      28.088 115.851 -10.959  1.00  0.00           O  
ATOM    440  H   GLU A  27      29.711 113.068  -7.118  1.00  0.00           H  
ATOM    441  HA  GLU A  27      31.882 113.889  -8.864  1.00  0.00           H  
ATOM    442  HB2 GLU A  27      29.411 115.007  -7.670  1.00  0.00           H  
ATOM    443  HB3 GLU A  27      30.693 116.204  -7.824  1.00  0.00           H  
ATOM    444  HG2 GLU A  27      30.975 115.819 -10.134  1.00  0.00           H  
ATOM    445  HG3 GLU A  27      29.983 114.369 -10.136  1.00  0.00           H  
ATOM    446  N   HIS A  28      32.346 114.669  -5.703  1.00  0.00           N  
ATOM    447  CA  HIS A  28      33.401 114.954  -4.719  1.00  0.00           C  
ATOM    448  C   HIS A  28      34.580 113.971  -4.812  1.00  0.00           C  
ATOM    449  O   HIS A  28      35.742 114.368  -4.718  1.00  0.00           O  
ATOM    450  CB  HIS A  28      32.768 114.943  -3.316  1.00  0.00           C  
ATOM    451  CG  HIS A  28      33.667 114.557  -2.166  1.00  0.00           C  
ATOM    452  ND1 HIS A  28      33.706 113.317  -1.568  1.00  0.00           N  
ATOM    453  CD2 HIS A  28      34.574 115.353  -1.524  1.00  0.00           C  
ATOM    454  CE1 HIS A  28      34.613 113.368  -0.581  1.00  0.00           C  
ATOM    455  NE2 HIS A  28      35.155 114.595  -0.501  1.00  0.00           N  
ATOM    456  H   HIS A  28      31.518 114.205  -5.364  1.00  0.00           H  
ATOM    457  HA  HIS A  28      33.795 115.947  -4.917  1.00  0.00           H  
ATOM    458  HB2 HIS A  28      32.349 115.922  -3.143  1.00  0.00           H  
ATOM    459  HB3 HIS A  28      31.929 114.256  -3.286  1.00  0.00           H  
ATOM    460  HD1 HIS A  28      33.229 112.456  -1.871  1.00  0.00           H  
ATOM    461  HD2 HIS A  28      34.804 116.376  -1.773  1.00  0.00           H  
ATOM    462  HE1 HIS A  28      34.880 112.524   0.041  1.00  0.00           H  
ATOM    463  N   GLU A  29      34.267 112.691  -4.998  1.00  0.00           N  
ATOM    464  CA  GLU A  29      35.201 111.586  -5.148  1.00  0.00           C  
ATOM    465  C   GLU A  29      35.999 111.651  -6.462  1.00  0.00           C  
ATOM    466  O   GLU A  29      37.194 111.348  -6.490  1.00  0.00           O  
ATOM    467  CB  GLU A  29      34.396 110.281  -5.119  1.00  0.00           C  
ATOM    468  CG  GLU A  29      34.171 109.653  -3.735  1.00  0.00           C  
ATOM    469  CD  GLU A  29      32.792 109.988  -3.149  1.00  0.00           C  
ATOM    470  OE1 GLU A  29      31.791 109.391  -3.619  1.00  0.00           O  
ATOM    471  OE2 GLU A  29      32.730 110.825  -2.215  1.00  0.00           O  
ATOM    472  H   GLU A  29      33.276 112.467  -5.020  1.00  0.00           H  
ATOM    473  HA  GLU A  29      35.908 111.593  -4.323  1.00  0.00           H  
ATOM    474  HB2 GLU A  29      33.437 110.436  -5.610  1.00  0.00           H  
ATOM    475  HB3 GLU A  29      34.946 109.576  -5.725  1.00  0.00           H  
ATOM    476  HG2 GLU A  29      34.241 108.568  -3.843  1.00  0.00           H  
ATOM    477  HG3 GLU A  29      34.970 109.954  -3.052  1.00  0.00           H  
ATOM    478  N   PHE A  30      35.332 112.013  -7.563  1.00  0.00           N  
ATOM    479  CA  PHE A  30      35.863 111.919  -8.926  1.00  0.00           C  
ATOM    480  C   PHE A  30      35.612 113.175  -9.806  1.00  0.00           C  
ATOM    481  O   PHE A  30      35.153 113.033 -10.946  1.00  0.00           O  
ATOM    482  CB  PHE A  30      35.269 110.654  -9.570  1.00  0.00           C  
ATOM    483  CG  PHE A  30      35.270 109.388  -8.726  1.00  0.00           C  
ATOM    484  CD1 PHE A  30      36.483 108.818  -8.294  1.00  0.00           C  
ATOM    485  CD2 PHE A  30      34.050 108.811  -8.319  1.00  0.00           C  
ATOM    486  CE1 PHE A  30      36.473 107.706  -7.434  1.00  0.00           C  
ATOM    487  CE2 PHE A  30      34.037 107.689  -7.472  1.00  0.00           C  
ATOM    488  CZ  PHE A  30      35.249 107.145  -7.021  1.00  0.00           C  
ATOM    489  H   PHE A  30      34.331 112.121  -7.441  1.00  0.00           H  
ATOM    490  HA  PHE A  30      36.944 111.788  -8.876  1.00  0.00           H  
ATOM    491  HB2 PHE A  30      34.237 110.873  -9.844  1.00  0.00           H  
ATOM    492  HB3 PHE A  30      35.827 110.459 -10.481  1.00  0.00           H  
ATOM    493  HD1 PHE A  30      37.420 109.279  -8.572  1.00  0.00           H  
ATOM    494  HD2 PHE A  30      33.116 109.258  -8.624  1.00  0.00           H  
ATOM    495  HE1 PHE A  30      37.408 107.317  -7.061  1.00  0.00           H  
ATOM    496  HE2 PHE A  30      33.096 107.281  -7.131  1.00  0.00           H  
ATOM    497  HZ  PHE A  30      35.226 106.322  -6.325  1.00  0.00           H  
ATOM    498  N   PRO A  31      35.906 114.409  -9.343  1.00  0.00           N  
ATOM    499  CA  PRO A  31      35.458 115.644  -9.999  1.00  0.00           C  
ATOM    500  C   PRO A  31      36.008 115.820 -11.418  1.00  0.00           C  
ATOM    501  O   PRO A  31      37.185 115.556 -11.672  1.00  0.00           O  
ATOM    502  CB  PRO A  31      35.904 116.792  -9.085  1.00  0.00           C  
ATOM    503  CG  PRO A  31      37.039 116.188  -8.257  1.00  0.00           C  
ATOM    504  CD  PRO A  31      36.638 114.722  -8.127  1.00  0.00           C  
ATOM    505  HA  PRO A  31      34.368 115.639 -10.045  1.00  0.00           H  
ATOM    506  HB2 PRO A  31      36.246 117.659  -9.652  1.00  0.00           H  
ATOM    507  HB3 PRO A  31      35.079 117.076  -8.432  1.00  0.00           H  
ATOM    508  HG2 PRO A  31      37.976 116.261  -8.811  1.00  0.00           H  
ATOM    509  HG3 PRO A  31      37.127 116.667  -7.282  1.00  0.00           H  
ATOM    510  HD2 PRO A  31      37.522 114.092  -8.014  1.00  0.00           H  
ATOM    511  HD3 PRO A  31      35.977 114.606  -7.268  1.00  0.00           H  
ATOM    512  N   GLY A  32      35.152 116.275 -12.342  1.00  0.00           N  
ATOM    513  CA  GLY A  32      35.442 116.552 -13.762  1.00  0.00           C  
ATOM    514  C   GLY A  32      35.785 115.336 -14.622  1.00  0.00           C  
ATOM    515  O   GLY A  32      35.527 115.298 -15.822  1.00  0.00           O  
ATOM    516  H   GLY A  32      34.206 116.456 -12.036  1.00  0.00           H  
ATOM    517  HA2 GLY A  32      34.579 117.037 -14.215  1.00  0.00           H  
ATOM    518  HA3 GLY A  32      36.290 117.223 -13.823  1.00  0.00           H  
ATOM    519  N   CYS A  33      36.312 114.285 -14.004  1.00  0.00           N  
ATOM    520  CA  CYS A  33      36.461 112.974 -14.602  1.00  0.00           C  
ATOM    521  C   CYS A  33      35.100 112.291 -14.823  1.00  0.00           C  
ATOM    522  O   CYS A  33      34.997 111.318 -15.572  1.00  0.00           O  
ATOM    523  CB  CYS A  33      37.368 112.131 -13.705  1.00  0.00           C  
ATOM    524  SG  CYS A  33      38.864 113.022 -13.169  1.00  0.00           S  
ATOM    525  H   CYS A  33      36.540 114.391 -13.030  1.00  0.00           H  
ATOM    526  HA  CYS A  33      36.941 113.094 -15.558  1.00  0.00           H  
ATOM    527  HB2 CYS A  33      36.787 111.798 -12.840  1.00  0.00           H  
ATOM    528  HB3 CYS A  33      37.679 111.256 -14.277  1.00  0.00           H  
ATOM    529  HG  CYS A  33      38.258 114.042 -12.535  1.00  0.00           H  
ATOM    530  N   LEU A  34      34.057 112.785 -14.158  1.00  0.00           N  
ATOM    531  CA  LEU A  34      32.735 112.183 -14.108  1.00  0.00           C  
ATOM    532  C   LEU A  34      31.619 113.231 -14.106  1.00  0.00           C  
ATOM    533  O   LEU A  34      31.790 114.375 -13.691  1.00  0.00           O  
ATOM    534  CB  LEU A  34      32.644 111.310 -12.839  1.00  0.00           C  
ATOM    535  CG  LEU A  34      32.730 109.800 -13.123  1.00  0.00           C  
ATOM    536  CD1 LEU A  34      33.373 109.043 -11.969  1.00  0.00           C  
ATOM    537  CD2 LEU A  34      31.341 109.197 -13.268  1.00  0.00           C  
ATOM    538  H   LEU A  34      34.204 113.621 -13.604  1.00  0.00           H  
ATOM    539  HA  LEU A  34      32.584 111.559 -14.988  1.00  0.00           H  
ATOM    540  HB2 LEU A  34      33.437 111.592 -12.145  1.00  0.00           H  
ATOM    541  HB3 LEU A  34      31.693 111.530 -12.356  1.00  0.00           H  
ATOM    542  HG  LEU A  34      33.312 109.619 -14.026  1.00  0.00           H  
ATOM    543 HD11 LEU A  34      34.375 109.417 -11.808  1.00  0.00           H  
ATOM    544 HD12 LEU A  34      33.437 107.985 -12.214  1.00  0.00           H  
ATOM    545 HD13 LEU A  34      32.788 109.188 -11.063  1.00  0.00           H  
ATOM    546 HD21 LEU A  34      30.800 109.312 -12.331  1.00  0.00           H  
ATOM    547 HD22 LEU A  34      31.418 108.143 -13.522  1.00  0.00           H  
ATOM    548 HD23 LEU A  34      30.795 109.728 -14.037  1.00  0.00           H  
ATOM    549  N   ASP A  35      30.452 112.738 -14.488  1.00  0.00           N  
ATOM    550  CA  ASP A  35      29.130 113.360 -14.448  1.00  0.00           C  
ATOM    551  C   ASP A  35      28.154 112.424 -13.732  1.00  0.00           C  
ATOM    552  O   ASP A  35      28.246 111.200 -13.848  1.00  0.00           O  
ATOM    553  CB  ASP A  35      28.689 113.531 -15.903  1.00  0.00           C  
ATOM    554  CG  ASP A  35      27.208 113.831 -16.157  1.00  0.00           C  
ATOM    555  OD1 ASP A  35      26.602 114.651 -15.438  1.00  0.00           O  
ATOM    556  OD2 ASP A  35      26.643 113.170 -17.062  1.00  0.00           O  
ATOM    557  H   ASP A  35      30.498 111.798 -14.891  1.00  0.00           H  
ATOM    558  HA  ASP A  35      29.158 114.329 -13.945  1.00  0.00           H  
ATOM    559  HB2 ASP A  35      29.323 114.262 -16.389  1.00  0.00           H  
ATOM    560  HB3 ASP A  35      28.878 112.581 -16.372  1.00  0.00           H  
ATOM    561  N   ILE A  36      27.148 112.996 -13.080  1.00  0.00           N  
ATOM    562  CA  ILE A  36      25.926 112.319 -12.679  1.00  0.00           C  
ATOM    563  C   ILE A  36      24.737 113.246 -12.959  1.00  0.00           C  
ATOM    564  O   ILE A  36      24.691 114.396 -12.519  1.00  0.00           O  
ATOM    565  CB  ILE A  36      25.902 111.964 -11.186  1.00  0.00           C  
ATOM    566  CG1 ILE A  36      27.205 111.427 -10.552  1.00  0.00           C  
ATOM    567  CG2 ILE A  36      24.733 111.008 -10.870  1.00  0.00           C  
ATOM    568  CD1 ILE A  36      27.900 112.566  -9.804  1.00  0.00           C  
ATOM    569  H   ILE A  36      27.092 113.999 -13.171  1.00  0.00           H  
ATOM    570  HA  ILE A  36      25.841 111.403 -13.257  1.00  0.00           H  
ATOM    571  HB  ILE A  36      25.699 112.921 -10.730  1.00  0.00           H  
ATOM    572 HG12 ILE A  36      26.993 110.634  -9.834  1.00  0.00           H  
ATOM    573 HG13 ILE A  36      27.870 111.020 -11.311  1.00  0.00           H  
ATOM    574 HG21 ILE A  36      24.829 110.090 -11.445  1.00  0.00           H  
ATOM    575 HG22 ILE A  36      24.719 110.760  -9.809  1.00  0.00           H  
ATOM    576 HG23 ILE A  36      23.779 111.473 -11.115  1.00  0.00           H  
ATOM    577 HD11 ILE A  36      27.969 113.427 -10.459  1.00  0.00           H  
ATOM    578 HD12 ILE A  36      27.321 112.844  -8.918  1.00  0.00           H  
ATOM    579 HD13 ILE A  36      28.907 112.274  -9.521  1.00  0.00           H  
ATOM    580  N   CYS A  37      23.712 112.675 -13.571  1.00  0.00           N  
ATOM    581  CA  CYS A  37      22.402 113.295 -13.774  1.00  0.00           C  
ATOM    582  C   CYS A  37      21.230 112.392 -13.359  1.00  0.00           C  
ATOM    583  O   CYS A  37      21.396 111.277 -12.861  1.00  0.00           O  
ATOM    584  CB  CYS A  37      22.306 113.826 -15.215  1.00  0.00           C  
ATOM    585  SG  CYS A  37      21.852 115.579 -15.169  1.00  0.00           S  
ATOM    586  H   CYS A  37      23.908 111.715 -13.814  1.00  0.00           H  
ATOM    587  HA  CYS A  37      22.324 114.151 -13.109  1.00  0.00           H  
ATOM    588  HB2 CYS A  37      23.278 113.754 -15.703  1.00  0.00           H  
ATOM    589  HB3 CYS A  37      21.567 113.266 -15.793  1.00  0.00           H  
ATOM    590  HG  CYS A  37      23.075 116.014 -14.813  1.00  0.00           H  
ATOM    591  N   GLY A  38      20.007 112.889 -13.536  1.00  0.00           N  
ATOM    592  CA  GLY A  38      18.783 112.160 -13.186  1.00  0.00           C  
ATOM    593  C   GLY A  38      17.580 112.521 -14.048  1.00  0.00           C  
ATOM    594  O   GLY A  38      17.321 113.686 -14.332  1.00  0.00           O  
ATOM    595  H   GLY A  38      19.951 113.797 -13.980  1.00  0.00           H  
ATOM    596  HA2 GLY A  38      18.969 111.092 -13.301  1.00  0.00           H  
ATOM    597  HA3 GLY A  38      18.524 112.356 -12.152  1.00  0.00           H  
ATOM    598  N   GLU A  39      16.854 111.490 -14.471  1.00  0.00           N  
ATOM    599  CA  GLU A  39      15.996 111.494 -15.664  1.00  0.00           C  
ATOM    600  C   GLU A  39      14.649 110.845 -15.326  1.00  0.00           C  
ATOM    601  O   GLU A  39      14.154 109.933 -15.983  1.00  0.00           O  
ATOM    602  CB  GLU A  39      16.762 110.780 -16.790  1.00  0.00           C  
ATOM    603  CG  GLU A  39      17.903 111.654 -17.355  1.00  0.00           C  
ATOM    604  CD  GLU A  39      18.981 110.877 -18.125  1.00  0.00           C  
ATOM    605  OE1 GLU A  39      19.074 109.641 -17.961  1.00  0.00           O  
ATOM    606  OE2 GLU A  39      19.822 111.543 -18.776  1.00  0.00           O  
ATOM    607  H   GLU A  39      17.079 110.575 -14.104  1.00  0.00           H  
ATOM    608  HA  GLU A  39      15.782 112.518 -15.971  1.00  0.00           H  
ATOM    609  HB2 GLU A  39      17.157 109.854 -16.370  1.00  0.00           H  
ATOM    610  HB3 GLU A  39      16.083 110.539 -17.606  1.00  0.00           H  
ATOM    611  HG2 GLU A  39      17.466 112.418 -18.003  1.00  0.00           H  
ATOM    612  HG3 GLU A  39      18.411 112.174 -16.542  1.00  0.00           H  
ATOM    613  N   GLY A  40      14.099 111.289 -14.198  1.00  0.00           N  
ATOM    614  CA  GLY A  40      12.992 110.682 -13.464  1.00  0.00           C  
ATOM    615  C   GLY A  40      11.632 110.729 -14.155  1.00  0.00           C  
ATOM    616  O   GLY A  40      10.811 111.591 -13.852  1.00  0.00           O  
ATOM    617  H   GLY A  40      14.629 112.038 -13.780  1.00  0.00           H  
ATOM    618  HA2 GLY A  40      13.230 109.635 -13.288  1.00  0.00           H  
ATOM    619  HA3 GLY A  40      12.889 111.184 -12.500  1.00  0.00           H  
ATOM    620  N   THR A  41      11.384 109.789 -15.072  1.00  0.00           N  
ATOM    621  CA  THR A  41      10.082 109.596 -15.726  1.00  0.00           C  
ATOM    622  C   THR A  41       8.927 109.373 -14.730  1.00  0.00           C  
ATOM    623  O   THR A  41       9.097 108.657 -13.738  1.00  0.00           O  
ATOM    624  CB  THR A  41      10.141 108.446 -16.747  1.00  0.00           C  
ATOM    625  OG1 THR A  41       8.930 108.325 -17.459  1.00  0.00           O  
ATOM    626  CG2 THR A  41      10.461 107.066 -16.168  1.00  0.00           C  
ATOM    627  H   THR A  41      12.181 109.239 -15.367  1.00  0.00           H  
ATOM    628  HA  THR A  41       9.891 110.504 -16.290  1.00  0.00           H  
ATOM    629  HB  THR A  41      10.927 108.700 -17.459  1.00  0.00           H  
ATOM    630  HG1 THR A  41       8.281 107.868 -16.903  1.00  0.00           H  
ATOM    631 HG21 THR A  41      10.514 106.338 -16.978  1.00  0.00           H  
ATOM    632 HG22 THR A  41       9.688 106.759 -15.464  1.00  0.00           H  
ATOM    633 HG23 THR A  41      11.424 107.093 -15.660  1.00  0.00           H  
ATOM    634  N   PRO A  42       7.725 109.920 -15.013  1.00  0.00           N  
ATOM    635  CA  PRO A  42       6.481 109.530 -14.354  1.00  0.00           C  
ATOM    636  C   PRO A  42       5.985 108.165 -14.878  1.00  0.00           C  
ATOM    637  O   PRO A  42       6.683 107.491 -15.642  1.00  0.00           O  
ATOM    638  CB  PRO A  42       5.520 110.686 -14.662  1.00  0.00           C  
ATOM    639  CG  PRO A  42       5.935 111.113 -16.068  1.00  0.00           C  
ATOM    640  CD  PRO A  42       7.445 110.879 -16.078  1.00  0.00           C  
ATOM    641  HA  PRO A  42       6.634 109.453 -13.276  1.00  0.00           H  
ATOM    642  HB2 PRO A  42       4.471 110.397 -14.621  1.00  0.00           H  
ATOM    643  HB3 PRO A  42       5.713 111.506 -13.967  1.00  0.00           H  
ATOM    644  HG2 PRO A  42       5.461 110.463 -16.804  1.00  0.00           H  
ATOM    645  HG3 PRO A  42       5.688 112.159 -16.262  1.00  0.00           H  
ATOM    646  HD2 PRO A  42       7.739 110.495 -17.055  1.00  0.00           H  
ATOM    647  HD3 PRO A  42       7.984 111.806 -15.873  1.00  0.00           H  
ATOM    648  N   GLN A  43       4.779 107.759 -14.457  1.00  0.00           N  
ATOM    649  CA  GLN A  43       4.119 106.458 -14.683  1.00  0.00           C  
ATOM    650  C   GLN A  43       4.821 105.279 -13.988  1.00  0.00           C  
ATOM    651  O   GLN A  43       4.166 104.510 -13.287  1.00  0.00           O  
ATOM    652  CB  GLN A  43       3.869 106.218 -16.186  1.00  0.00           C  
ATOM    653  CG  GLN A  43       2.906 105.046 -16.439  1.00  0.00           C  
ATOM    654  CD  GLN A  43       2.633 104.850 -17.928  1.00  0.00           C  
ATOM    655  OE1 GLN A  43       3.511 104.532 -18.708  1.00  0.00           O  
ATOM    656  NE2 GLN A  43       1.414 105.026 -18.390  1.00  0.00           N  
ATOM    657  H   GLN A  43       4.314 108.384 -13.818  1.00  0.00           H  
ATOM    658  HA  GLN A  43       3.138 106.529 -14.212  1.00  0.00           H  
ATOM    659  HB2 GLN A  43       3.435 107.119 -16.621  1.00  0.00           H  
ATOM    660  HB3 GLN A  43       4.814 106.012 -16.688  1.00  0.00           H  
ATOM    661  HG2 GLN A  43       3.344 104.125 -16.053  1.00  0.00           H  
ATOM    662  HG3 GLN A  43       1.967 105.228 -15.915  1.00  0.00           H  
ATOM    663 HE21 GLN A  43       0.644 105.278 -17.802  1.00  0.00           H  
ATOM    664 HE22 GLN A  43       1.340 104.856 -19.379  1.00  0.00           H  
ATOM    665  N   VAL A  44       6.143 105.155 -14.123  1.00  0.00           N  
ATOM    666  CA  VAL A  44       6.974 104.285 -13.277  1.00  0.00           C  
ATOM    667  C   VAL A  44       6.968 104.819 -11.832  1.00  0.00           C  
ATOM    668  O   VAL A  44       6.832 106.018 -11.594  1.00  0.00           O  
ATOM    669  CB  VAL A  44       8.411 104.167 -13.834  1.00  0.00           C  
ATOM    670  CG1 VAL A  44       9.162 102.983 -13.200  1.00  0.00           C  
ATOM    671  CG2 VAL A  44       8.429 103.933 -15.354  1.00  0.00           C  
ATOM    672  H   VAL A  44       6.596 105.842 -14.716  1.00  0.00           H  
ATOM    673  HA  VAL A  44       6.524 103.293 -13.276  1.00  0.00           H  
ATOM    674  HB  VAL A  44       8.950 105.090 -13.628  1.00  0.00           H  
ATOM    675 HG11 VAL A  44      10.171 102.929 -13.610  1.00  0.00           H  
ATOM    676 HG12 VAL A  44       9.258 103.116 -12.125  1.00  0.00           H  
ATOM    677 HG13 VAL A  44       8.638 102.049 -13.408  1.00  0.00           H  
ATOM    678 HG21 VAL A  44       7.821 103.065 -15.611  1.00  0.00           H  
ATOM    679 HG22 VAL A  44       8.040 104.807 -15.879  1.00  0.00           H  
ATOM    680 HG23 VAL A  44       9.452 103.771 -15.694  1.00  0.00           H  
ATOM    681  N   THR A  45       7.094 103.922 -10.850  1.00  0.00           N  
ATOM    682  CA  THR A  45       7.012 104.226  -9.414  1.00  0.00           C  
ATOM    683  C   THR A  45       7.895 103.298  -8.570  1.00  0.00           C  
ATOM    684  O   THR A  45       8.376 102.270  -9.049  1.00  0.00           O  
ATOM    685  CB  THR A  45       5.545 104.189  -8.952  1.00  0.00           C  
ATOM    686  OG1 THR A  45       5.446 104.683  -7.638  1.00  0.00           O  
ATOM    687  CG2 THR A  45       4.919 102.794  -8.969  1.00  0.00           C  
ATOM    688  H   THR A  45       7.252 102.959 -11.104  1.00  0.00           H  
ATOM    689  HA  THR A  45       7.358 105.244  -9.253  1.00  0.00           H  
ATOM    690  HB  THR A  45       4.959 104.839  -9.603  1.00  0.00           H  
ATOM    691  HG1 THR A  45       4.512 104.699  -7.413  1.00  0.00           H  
ATOM    692 HG21 THR A  45       5.451 102.127  -8.290  1.00  0.00           H  
ATOM    693 HG22 THR A  45       4.955 102.384  -9.979  1.00  0.00           H  
ATOM    694 HG23 THR A  45       3.877 102.857  -8.659  1.00  0.00           H  
ATOM    695  N   GLY A  46       8.106 103.665  -7.302  1.00  0.00           N  
ATOM    696  CA  GLY A  46       8.766 102.841  -6.286  1.00  0.00           C  
ATOM    697  C   GLY A  46      10.223 102.465  -6.577  1.00  0.00           C  
ATOM    698  O   GLY A  46      10.671 101.428  -6.078  1.00  0.00           O  
ATOM    699  H   GLY A  46       7.590 104.486  -7.009  1.00  0.00           H  
ATOM    700  HA2 GLY A  46       8.742 103.373  -5.334  1.00  0.00           H  
ATOM    701  HA3 GLY A  46       8.201 101.914  -6.178  1.00  0.00           H  
ATOM    702  N   PHE A  47      10.956 103.270  -7.359  1.00  0.00           N  
ATOM    703  CA  PHE A  47      12.243 102.903  -7.975  1.00  0.00           C  
ATOM    704  C   PHE A  47      13.402 103.883  -7.660  1.00  0.00           C  
ATOM    705  O   PHE A  47      13.209 104.787  -6.845  1.00  0.00           O  
ATOM    706  CB  PHE A  47      12.001 102.605  -9.465  1.00  0.00           C  
ATOM    707  CG  PHE A  47      11.883 103.760 -10.444  1.00  0.00           C  
ATOM    708  CD1 PHE A  47      10.819 104.682 -10.385  1.00  0.00           C  
ATOM    709  CD2 PHE A  47      12.766 103.800 -11.537  1.00  0.00           C  
ATOM    710  CE1 PHE A  47      10.648 105.630 -11.414  1.00  0.00           C  
ATOM    711  CE2 PHE A  47      12.572 104.723 -12.573  1.00  0.00           C  
ATOM    712  CZ  PHE A  47      11.526 105.654 -12.505  1.00  0.00           C  
ATOM    713  H   PHE A  47      10.527 104.132  -7.667  1.00  0.00           H  
ATOM    714  HA  PHE A  47      12.546 101.952  -7.546  1.00  0.00           H  
ATOM    715  HB2 PHE A  47      12.814 101.972  -9.809  1.00  0.00           H  
ATOM    716  HB3 PHE A  47      11.092 102.004  -9.551  1.00  0.00           H  
ATOM    717  HD1 PHE A  47      10.105 104.642  -9.581  1.00  0.00           H  
ATOM    718  HD2 PHE A  47      13.573 103.087 -11.608  1.00  0.00           H  
ATOM    719  HE1 PHE A  47       9.823 106.328 -11.410  1.00  0.00           H  
ATOM    720  HE2 PHE A  47      13.214 104.685 -13.434  1.00  0.00           H  
ATOM    721  HZ  PHE A  47      11.369 106.370 -13.300  1.00  0.00           H  
ATOM    722  N   PHE A  48      14.616 103.637  -8.183  1.00  0.00           N  
ATOM    723  CA  PHE A  48      15.904 104.373  -8.063  1.00  0.00           C  
ATOM    724  C   PHE A  48      16.992 103.592  -8.840  1.00  0.00           C  
ATOM    725  O   PHE A  48      17.774 102.833  -8.264  1.00  0.00           O  
ATOM    726  CB  PHE A  48      16.321 104.589  -6.585  1.00  0.00           C  
ATOM    727  CG  PHE A  48      17.406 105.614  -6.304  1.00  0.00           C  
ATOM    728  CD1 PHE A  48      18.761 105.231  -6.315  1.00  0.00           C  
ATOM    729  CD2 PHE A  48      17.067 106.922  -5.908  1.00  0.00           C  
ATOM    730  CE1 PHE A  48      19.762 106.149  -5.954  1.00  0.00           C  
ATOM    731  CE2 PHE A  48      18.067 107.843  -5.551  1.00  0.00           C  
ATOM    732  CZ  PHE A  48      19.418 107.457  -5.571  1.00  0.00           C  
ATOM    733  H   PHE A  48      14.661 102.837  -8.819  1.00  0.00           H  
ATOM    734  HA  PHE A  48      15.794 105.351  -8.535  1.00  0.00           H  
ATOM    735  HB2 PHE A  48      15.444 104.869  -6.015  1.00  0.00           H  
ATOM    736  HB3 PHE A  48      16.674 103.656  -6.154  1.00  0.00           H  
ATOM    737  HD1 PHE A  48      19.039 104.223  -6.593  1.00  0.00           H  
ATOM    738  HD2 PHE A  48      16.038 107.226  -5.866  1.00  0.00           H  
ATOM    739  HE1 PHE A  48      20.799 105.843  -5.969  1.00  0.00           H  
ATOM    740  HE2 PHE A  48      17.800 108.852  -5.268  1.00  0.00           H  
ATOM    741  HZ  PHE A  48      20.188 108.162  -5.295  1.00  0.00           H  
ATOM    742  N   GLU A  49      17.005 103.688 -10.167  1.00  0.00           N  
ATOM    743  CA  GLU A  49      17.732 102.753 -11.032  1.00  0.00           C  
ATOM    744  C   GLU A  49      19.047 103.387 -11.510  1.00  0.00           C  
ATOM    745  O   GLU A  49      19.003 104.389 -12.235  1.00  0.00           O  
ATOM    746  CB  GLU A  49      16.788 102.408 -12.193  1.00  0.00           C  
ATOM    747  CG  GLU A  49      15.871 101.179 -12.020  1.00  0.00           C  
ATOM    748  CD  GLU A  49      15.633 100.628 -10.600  1.00  0.00           C  
ATOM    749  OE1 GLU A  49      15.121 101.325  -9.696  1.00  0.00           O  
ATOM    750  OE2 GLU A  49      15.867  99.417 -10.409  1.00  0.00           O  
ATOM    751  H   GLU A  49      16.384 104.342 -10.643  1.00  0.00           H  
ATOM    752  HA  GLU A  49      17.989 101.837 -10.497  1.00  0.00           H  
ATOM    753  HB2 GLU A  49      16.156 103.275 -12.405  1.00  0.00           H  
ATOM    754  HB3 GLU A  49      17.396 102.243 -13.080  1.00  0.00           H  
ATOM    755  HG2 GLU A  49      14.905 101.421 -12.461  1.00  0.00           H  
ATOM    756  HG3 GLU A  49      16.291 100.377 -12.630  1.00  0.00           H  
ATOM    757  N   VAL A  50      20.209 102.856 -11.072  1.00  0.00           N  
ATOM    758  CA  VAL A  50      21.478 103.591 -11.200  1.00  0.00           C  
ATOM    759  C   VAL A  50      22.337 102.977 -12.295  1.00  0.00           C  
ATOM    760  O   VAL A  50      22.623 101.777 -12.271  1.00  0.00           O  
ATOM    761  CB  VAL A  50      22.262 103.657  -9.877  1.00  0.00           C  
ATOM    762  CG1 VAL A  50      23.470 104.597  -9.993  1.00  0.00           C  
ATOM    763  CG2 VAL A  50      21.393 104.157  -8.711  1.00  0.00           C  
ATOM    764  H   VAL A  50      20.264 101.935 -10.619  1.00  0.00           H  
ATOM    765  HA  VAL A  50      21.256 104.620 -11.480  1.00  0.00           H  
ATOM    766  HB  VAL A  50      22.641 102.666  -9.641  1.00  0.00           H  
ATOM    767 HG11 VAL A  50      24.191 104.197 -10.704  1.00  0.00           H  
ATOM    768 HG12 VAL A  50      23.150 105.584 -10.327  1.00  0.00           H  
ATOM    769 HG13 VAL A  50      23.966 104.685  -9.027  1.00  0.00           H  
ATOM    770 HG21 VAL A  50      21.986 104.193  -7.798  1.00  0.00           H  
ATOM    771 HG22 VAL A  50      21.011 105.151  -8.934  1.00  0.00           H  
ATOM    772 HG23 VAL A  50      20.548 103.490  -8.550  1.00  0.00           H  
ATOM    773  N   THR A  51      22.795 103.817 -13.221  1.00  0.00           N  
ATOM    774  CA  THR A  51      23.531 103.419 -14.425  1.00  0.00           C  
ATOM    775  C   THR A  51      24.759 104.302 -14.607  1.00  0.00           C  
ATOM    776  O   THR A  51      24.698 105.503 -14.372  1.00  0.00           O  
ATOM    777  CB  THR A  51      22.649 103.577 -15.677  1.00  0.00           C  
ATOM    778  OG1 THR A  51      21.340 103.115 -15.444  1.00  0.00           O  
ATOM    779  CG2 THR A  51      23.123 102.823 -16.903  1.00  0.00           C  
ATOM    780  H   THR A  51      22.526 104.791 -13.131  1.00  0.00           H  
ATOM    781  HA  THR A  51      23.827 102.380 -14.329  1.00  0.00           H  
ATOM    782  HB  THR A  51      22.659 104.619 -15.971  1.00  0.00           H  
ATOM    783  HG1 THR A  51      20.791 103.335 -16.199  1.00  0.00           H  
ATOM    784 HG21 THR A  51      22.462 103.042 -17.741  1.00  0.00           H  
ATOM    785 HG22 THR A  51      23.093 101.753 -16.703  1.00  0.00           H  
ATOM    786 HG23 THR A  51      24.127 103.152 -17.152  1.00  0.00           H  
ATOM    787  N   VAL A  52      25.852 103.747 -15.121  1.00  0.00           N  
ATOM    788  CA  VAL A  52      27.033 104.475 -15.610  1.00  0.00           C  
ATOM    789  C   VAL A  52      27.392 104.014 -17.019  1.00  0.00           C  
ATOM    790  O   VAL A  52      27.378 102.822 -17.302  1.00  0.00           O  
ATOM    791  CB  VAL A  52      28.203 104.343 -14.621  1.00  0.00           C  
ATOM    792  CG1 VAL A  52      28.683 102.897 -14.425  1.00  0.00           C  
ATOM    793  CG2 VAL A  52      29.403 105.185 -15.059  1.00  0.00           C  
ATOM    794  H   VAL A  52      25.840 102.739 -15.208  1.00  0.00           H  
ATOM    795  HA  VAL A  52      26.784 105.532 -15.677  1.00  0.00           H  
ATOM    796  HB  VAL A  52      27.850 104.727 -13.662  1.00  0.00           H  
ATOM    797 HG11 VAL A  52      29.127 102.509 -15.340  1.00  0.00           H  
ATOM    798 HG12 VAL A  52      29.425 102.859 -13.630  1.00  0.00           H  
ATOM    799 HG13 VAL A  52      27.846 102.258 -14.147  1.00  0.00           H  
ATOM    800 HG21 VAL A  52      30.155 105.199 -14.268  1.00  0.00           H  
ATOM    801 HG22 VAL A  52      29.852 104.765 -15.959  1.00  0.00           H  
ATOM    802 HG23 VAL A  52      29.097 106.212 -15.264  1.00  0.00           H  
ATOM    803  N   ALA A  53      27.631 104.950 -17.938  1.00  0.00           N  
ATOM    804  CA  ALA A  53      27.903 104.705 -19.364  1.00  0.00           C  
ATOM    805  C   ALA A  53      27.009 103.607 -20.001  1.00  0.00           C  
ATOM    806  O   ALA A  53      27.472 102.765 -20.781  1.00  0.00           O  
ATOM    807  CB  ALA A  53      29.405 104.446 -19.524  1.00  0.00           C  
ATOM    808  H   ALA A  53      27.618 105.904 -17.591  1.00  0.00           H  
ATOM    809  HA  ALA A  53      27.683 105.631 -19.899  1.00  0.00           H  
ATOM    810  HB1 ALA A  53      29.958 105.283 -19.100  1.00  0.00           H  
ATOM    811  HB2 ALA A  53      29.685 103.528 -19.004  1.00  0.00           H  
ATOM    812  HB3 ALA A  53      29.658 104.357 -20.582  1.00  0.00           H  
ATOM    813  N   GLY A  54      25.719 103.583 -19.633  1.00  0.00           N  
ATOM    814  CA  GLY A  54      24.748 102.579 -20.094  1.00  0.00           C  
ATOM    815  C   GLY A  54      24.886 101.187 -19.458  1.00  0.00           C  
ATOM    816  O   GLY A  54      24.630 100.190 -20.125  1.00  0.00           O  
ATOM    817  H   GLY A  54      25.433 104.303 -18.983  1.00  0.00           H  
ATOM    818  HA2 GLY A  54      23.736 102.941 -19.898  1.00  0.00           H  
ATOM    819  HA3 GLY A  54      24.860 102.455 -21.170  1.00  0.00           H  
ATOM    820  N   LYS A  55      25.330 101.096 -18.200  1.00  0.00           N  
ATOM    821  CA  LYS A  55      25.604  99.867 -17.436  1.00  0.00           C  
ATOM    822  C   LYS A  55      25.015  99.998 -16.025  1.00  0.00           C  
ATOM    823  O   LYS A  55      25.414 100.900 -15.289  1.00  0.00           O  
ATOM    824  CB  LYS A  55      27.116  99.613 -17.363  1.00  0.00           C  
ATOM    825  CG  LYS A  55      27.912  99.757 -18.674  1.00  0.00           C  
ATOM    826  CD  LYS A  55      27.625  98.668 -19.727  1.00  0.00           C  
ATOM    827  CE  LYS A  55      27.442  99.187 -21.167  1.00  0.00           C  
ATOM    828  NZ  LYS A  55      28.409 100.246 -21.549  1.00  0.00           N  
ATOM    829  H   LYS A  55      25.544 101.967 -17.721  1.00  0.00           H  
ATOM    830  HA  LYS A  55      25.160  99.013 -17.922  1.00  0.00           H  
ATOM    831  HB2 LYS A  55      27.492 100.359 -16.682  1.00  0.00           H  
ATOM    832  HB3 LYS A  55      27.302  98.631 -16.925  1.00  0.00           H  
ATOM    833  HG2 LYS A  55      27.718 100.744 -19.088  1.00  0.00           H  
ATOM    834  HG3 LYS A  55      28.976  99.714 -18.429  1.00  0.00           H  
ATOM    835  HD2 LYS A  55      28.445  97.948 -19.709  1.00  0.00           H  
ATOM    836  HD3 LYS A  55      26.717  98.126 -19.457  1.00  0.00           H  
ATOM    837  HE2 LYS A  55      27.523  98.334 -21.850  1.00  0.00           H  
ATOM    838  HE3 LYS A  55      26.428  99.582 -21.263  1.00  0.00           H  
ATOM    839  HZ1 LYS A  55      28.187 101.106 -21.046  1.00  0.00           H  
ATOM    840  HZ2 LYS A  55      28.327 100.464 -22.533  1.00  0.00           H  
ATOM    841  HZ3 LYS A  55      29.360  99.975 -21.340  1.00  0.00           H  
ATOM    842  N   LEU A  56      24.003  99.200 -15.685  1.00  0.00           N  
ATOM    843  CA  LEU A  56      23.373  99.181 -14.356  1.00  0.00           C  
ATOM    844  C   LEU A  56      24.385  98.807 -13.272  1.00  0.00           C  
ATOM    845  O   LEU A  56      25.167  97.876 -13.441  1.00  0.00           O  
ATOM    846  CB  LEU A  56      22.162  98.231 -14.416  1.00  0.00           C  
ATOM    847  CG  LEU A  56      21.381  97.966 -13.111  1.00  0.00           C  
ATOM    848  CD1 LEU A  56      19.956  97.529 -13.470  1.00  0.00           C  
ATOM    849  CD2 LEU A  56      21.961  96.838 -12.252  1.00  0.00           C  
ATOM    850  H   LEU A  56      23.711  98.494 -16.337  1.00  0.00           H  
ATOM    851  HA  LEU A  56      22.995 100.177 -14.112  1.00  0.00           H  
ATOM    852  HB2 LEU A  56      21.471  98.725 -15.093  1.00  0.00           H  
ATOM    853  HB3 LEU A  56      22.464  97.275 -14.846  1.00  0.00           H  
ATOM    854  HG  LEU A  56      21.332  98.884 -12.526  1.00  0.00           H  
ATOM    855 HD11 LEU A  56      19.378  97.367 -12.562  1.00  0.00           H  
ATOM    856 HD12 LEU A  56      19.975  96.613 -14.060  1.00  0.00           H  
ATOM    857 HD13 LEU A  56      19.463  98.316 -14.039  1.00  0.00           H  
ATOM    858 HD21 LEU A  56      22.002  95.911 -12.823  1.00  0.00           H  
ATOM    859 HD22 LEU A  56      21.339  96.692 -11.368  1.00  0.00           H  
ATOM    860 HD23 LEU A  56      22.964  97.084 -11.913  1.00  0.00           H  
ATOM    861  N   VAL A  57      24.319  99.525 -12.153  1.00  0.00           N  
ATOM    862  CA  VAL A  57      25.115  99.257 -10.940  1.00  0.00           C  
ATOM    863  C   VAL A  57      24.213  99.008  -9.727  1.00  0.00           C  
ATOM    864  O   VAL A  57      24.615  98.333  -8.781  1.00  0.00           O  
ATOM    865  CB  VAL A  57      26.120 100.396 -10.656  1.00  0.00           C  
ATOM    866  CG1 VAL A  57      27.211  99.951  -9.670  1.00  0.00           C  
ATOM    867  CG2 VAL A  57      26.843 100.888 -11.921  1.00  0.00           C  
ATOM    868  H   VAL A  57      23.644 100.290 -12.174  1.00  0.00           H  
ATOM    869  HA  VAL A  57      25.689  98.342 -11.094  1.00  0.00           H  
ATOM    870  HB  VAL A  57      25.584 101.245 -10.229  1.00  0.00           H  
ATOM    871 HG11 VAL A  57      27.936 100.750  -9.526  1.00  0.00           H  
ATOM    872 HG12 VAL A  57      26.768  99.714  -8.703  1.00  0.00           H  
ATOM    873 HG13 VAL A  57      27.727  99.071 -10.056  1.00  0.00           H  
ATOM    874 HG21 VAL A  57      27.593 101.632 -11.653  1.00  0.00           H  
ATOM    875 HG22 VAL A  57      27.324 100.048 -12.424  1.00  0.00           H  
ATOM    876 HG23 VAL A  57      26.131 101.353 -12.601  1.00  0.00           H  
ATOM    877  N   HIS A  58      22.977  99.519  -9.768  1.00  0.00           N  
ATOM    878  CA  HIS A  58      21.995  99.400  -8.696  1.00  0.00           C  
ATOM    879  C   HIS A  58      20.570  99.344  -9.236  1.00  0.00           C  
ATOM    880  O   HIS A  58      20.263  99.962 -10.258  1.00  0.00           O  
ATOM    881  CB  HIS A  58      22.142 100.631  -7.815  1.00  0.00           C  
ATOM    882  CG  HIS A  58      21.663 100.517  -6.397  1.00  0.00           C  
ATOM    883  ND1 HIS A  58      21.701  99.433  -5.545  1.00  0.00           N  
ATOM    884  CD2 HIS A  58      21.139 101.570  -5.708  1.00  0.00           C  
ATOM    885  CE1 HIS A  58      21.206  99.840  -4.365  1.00  0.00           C  
ATOM    886  NE2 HIS A  58      20.882 101.142  -4.408  1.00  0.00           N  
ATOM    887  H   HIS A  58      22.703 100.082 -10.564  1.00  0.00           H  
ATOM    888  HA  HIS A  58      22.190  98.506  -8.121  1.00  0.00           H  
ATOM    889  HB2 HIS A  58      23.183 100.951  -7.817  1.00  0.00           H  
ATOM    890  HB3 HIS A  58      21.544 101.415  -8.273  1.00  0.00           H  
ATOM    891  HD1 HIS A  58      22.005  98.465  -5.707  1.00  0.00           H  
ATOM    892  HD2 HIS A  58      20.970 102.547  -6.132  1.00  0.00           H  
ATOM    893  HE1 HIS A  58      21.071  99.200  -3.502  1.00  0.00           H  
ATOM    894  N   SER A  59      19.682  98.660  -8.515  1.00  0.00           N  
ATOM    895  CA  SER A  59      18.293  98.508  -8.923  1.00  0.00           C  
ATOM    896  C   SER A  59      17.324  98.467  -7.745  1.00  0.00           C  
ATOM    897  O   SER A  59      17.015  97.401  -7.195  1.00  0.00           O  
ATOM    898  CB  SER A  59      18.142  97.212  -9.702  1.00  0.00           C  
ATOM    899  OG  SER A  59      16.849  97.095 -10.263  1.00  0.00           O  
ATOM    900  H   SER A  59      19.985  98.233  -7.655  1.00  0.00           H  
ATOM    901  HA  SER A  59      18.036  99.352  -9.558  1.00  0.00           H  
ATOM    902  HB2 SER A  59      18.903  97.079 -10.457  1.00  0.00           H  
ATOM    903  HB3 SER A  59      18.319  96.429  -8.982  1.00  0.00           H  
ATOM    904  HG  SER A  59      16.511  98.019 -10.436  1.00  0.00           H  
ATOM    905  N   LYS A  60      16.756  99.606  -7.362  1.00  0.00           N  
ATOM    906  CA  LYS A  60      15.694  99.645  -6.376  1.00  0.00           C  
ATOM    907  C   LYS A  60      14.487  98.796  -6.810  1.00  0.00           C  
ATOM    908  O   LYS A  60      13.806  98.225  -5.951  1.00  0.00           O  
ATOM    909  CB  LYS A  60      15.365 101.132  -6.201  1.00  0.00           C  
ATOM    910  CG  LYS A  60      15.239 101.619  -4.754  1.00  0.00           C  
ATOM    911  CD  LYS A  60      14.319 100.760  -3.899  1.00  0.00           C  
ATOM    912  CE  LYS A  60      12.953 100.771  -4.566  1.00  0.00           C  
ATOM    913  NZ  LYS A  60      12.056  99.697  -4.103  1.00  0.00           N  
ATOM    914  H   LYS A  60      16.942 100.496  -7.808  1.00  0.00           H  
ATOM    915  HA  LYS A  60      16.096  99.223  -5.455  1.00  0.00           H  
ATOM    916  HB2 LYS A  60      16.166 101.718  -6.643  1.00  0.00           H  
ATOM    917  HB3 LYS A  60      14.464 101.363  -6.762  1.00  0.00           H  
ATOM    918  HG2 LYS A  60      16.221 101.628  -4.295  1.00  0.00           H  
ATOM    919  HG3 LYS A  60      14.857 102.638  -4.769  1.00  0.00           H  
ATOM    920  HD2 LYS A  60      14.721  99.753  -3.837  1.00  0.00           H  
ATOM    921  HD3 LYS A  60      14.268 101.192  -2.904  1.00  0.00           H  
ATOM    922  HE2 LYS A  60      12.521 101.763  -4.455  1.00  0.00           H  
ATOM    923  HE3 LYS A  60      13.075 100.627  -5.639  1.00  0.00           H  
ATOM    924  HZ1 LYS A  60      11.946  99.703  -3.100  1.00  0.00           H  
ATOM    925  HZ2 LYS A  60      12.430  98.807  -4.420  1.00  0.00           H  
ATOM    926  HZ3 LYS A  60      11.160  99.843  -4.558  1.00  0.00           H  
ATOM    927  N   LYS A  61      14.228  98.677  -8.119  1.00  0.00           N  
ATOM    928  CA  LYS A  61      13.141  97.879  -8.706  1.00  0.00           C  
ATOM    929  C   LYS A  61      13.372  96.361  -8.651  1.00  0.00           C  
ATOM    930  O   LYS A  61      12.399  95.635  -8.458  1.00  0.00           O  
ATOM    931  CB  LYS A  61      12.854  98.397 -10.130  1.00  0.00           C  
ATOM    932  CG  LYS A  61      11.514  97.904 -10.704  1.00  0.00           C  
ATOM    933  CD  LYS A  61      11.660  96.626 -11.541  1.00  0.00           C  
ATOM    934  CE  LYS A  61      10.283  95.995 -11.768  1.00  0.00           C  
ATOM    935  NZ  LYS A  61      10.403  94.694 -12.465  1.00  0.00           N  
ATOM    936  H   LYS A  61      14.826  99.217  -8.752  1.00  0.00           H  
ATOM    937  HA  LYS A  61      12.251  98.054  -8.103  1.00  0.00           H  
ATOM    938  HB2 LYS A  61      12.801  99.488 -10.085  1.00  0.00           H  
ATOM    939  HB3 LYS A  61      13.670  98.124 -10.803  1.00  0.00           H  
ATOM    940  HG2 LYS A  61      10.811  97.740  -9.886  1.00  0.00           H  
ATOM    941  HG3 LYS A  61      11.101  98.683 -11.346  1.00  0.00           H  
ATOM    942  HD2 LYS A  61      12.121  96.878 -12.499  1.00  0.00           H  
ATOM    943  HD3 LYS A  61      12.297  95.911 -11.028  1.00  0.00           H  
ATOM    944  HE2 LYS A  61       9.805  95.849 -10.793  1.00  0.00           H  
ATOM    945  HE3 LYS A  61       9.664  96.687 -12.349  1.00  0.00           H  
ATOM    946  HZ1 LYS A  61       9.492  94.267 -12.570  1.00  0.00           H  
ATOM    947  HZ2 LYS A  61      10.987  94.066 -11.928  1.00  0.00           H  
ATOM    948  HZ3 LYS A  61      10.813  94.822 -13.381  1.00  0.00           H  
ATOM    949  N   ARG A  62      14.607  95.849  -8.790  1.00  0.00           N  
ATOM    950  CA  ARG A  62      14.924  94.414  -8.584  1.00  0.00           C  
ATOM    951  C   ARG A  62      14.985  93.989  -7.115  1.00  0.00           C  
ATOM    952  O   ARG A  62      15.123  92.806  -6.809  1.00  0.00           O  
ATOM    953  CB  ARG A  62      16.209  94.040  -9.344  1.00  0.00           C  
ATOM    954  CG  ARG A  62      17.551  94.166  -8.597  1.00  0.00           C  
ATOM    955  CD  ARG A  62      18.053  92.883  -7.947  1.00  0.00           C  
ATOM    956  NE  ARG A  62      18.664  93.128  -6.625  1.00  0.00           N  
ATOM    957  CZ  ARG A  62      18.438  92.499  -5.491  1.00  0.00           C  
ATOM    958  NH1 ARG A  62      17.381  91.759  -5.301  1.00  0.00           N  
ATOM    959  NH2 ARG A  62      19.296  92.618  -4.524  1.00  0.00           N  
ATOM    960  H   ARG A  62      15.366  96.462  -9.082  1.00  0.00           H  
ATOM    961  HA  ARG A  62      14.114  93.825  -9.016  1.00  0.00           H  
ATOM    962  HB2 ARG A  62      16.088  93.019  -9.670  1.00  0.00           H  
ATOM    963  HB3 ARG A  62      16.267  94.661 -10.234  1.00  0.00           H  
ATOM    964  HG2 ARG A  62      18.316  94.434  -9.325  1.00  0.00           H  
ATOM    965  HG3 ARG A  62      17.462  94.940  -7.839  1.00  0.00           H  
ATOM    966  HD2 ARG A  62      17.212  92.212  -7.873  1.00  0.00           H  
ATOM    967  HD3 ARG A  62      18.796  92.420  -8.604  1.00  0.00           H  
ATOM    968  HE  ARG A  62      19.393  93.831  -6.539  1.00  0.00           H  
ATOM    969 HH11 ARG A  62      16.647  91.805  -6.001  1.00  0.00           H  
ATOM    970 HH12 ARG A  62      17.205  91.348  -4.405  1.00  0.00           H  
ATOM    971 HH21 ARG A  62      20.101  93.224  -4.717  1.00  0.00           H  
ATOM    972 HH22 ARG A  62      19.133  92.235  -3.615  1.00  0.00           H  
ATOM    973  N   GLY A  63      14.922  94.962  -6.213  1.00  0.00           N  
ATOM    974  CA  GLY A  63      15.034  94.756  -4.775  1.00  0.00           C  
ATOM    975  C   GLY A  63      16.455  94.896  -4.248  1.00  0.00           C  
ATOM    976  O   GLY A  63      16.790  94.260  -3.253  1.00  0.00           O  
ATOM    977  H   GLY A  63      14.903  95.898  -6.589  1.00  0.00           H  
ATOM    978  HA2 GLY A  63      14.458  95.522  -4.276  1.00  0.00           H  
ATOM    979  HA3 GLY A  63      14.648  93.773  -4.494  1.00  0.00           H  
ATOM    980  N   ASP A  64      17.292  95.697  -4.909  1.00  0.00           N  
ATOM    981  CA  ASP A  64      18.626  96.006  -4.402  1.00  0.00           C  
ATOM    982  C   ASP A  64      18.636  97.006  -3.235  1.00  0.00           C  
ATOM    983  O   ASP A  64      19.640  97.105  -2.539  1.00  0.00           O  
ATOM    984  CB  ASP A  64      19.504  96.464  -5.573  1.00  0.00           C  
ATOM    985  CG  ASP A  64      20.905  95.874  -5.462  1.00  0.00           C  
ATOM    986  OD1 ASP A  64      20.958  94.619  -5.451  1.00  0.00           O  
ATOM    987  OD2 ASP A  64      21.875  96.667  -5.447  1.00  0.00           O  
ATOM    988  H   ASP A  64      17.038  96.150  -5.787  1.00  0.00           H  
ATOM    989  HA  ASP A  64      19.050  95.092  -3.995  1.00  0.00           H  
ATOM    990  HB2 ASP A  64      19.091  96.090  -6.510  1.00  0.00           H  
ATOM    991  HB3 ASP A  64      19.521  97.554  -5.618  1.00  0.00           H  
ATOM    992  N   GLY A  65      17.522  97.701  -2.965  1.00  0.00           N  
ATOM    993  CA  GLY A  65      17.434  98.777  -1.982  1.00  0.00           C  
ATOM    994  C   GLY A  65      17.871 100.094  -2.607  1.00  0.00           C  
ATOM    995  O   GLY A  65      18.068 100.164  -3.816  1.00  0.00           O  
ATOM    996  H   GLY A  65      16.821  97.736  -3.679  1.00  0.00           H  
ATOM    997  HA2 GLY A  65      16.411  98.893  -1.627  1.00  0.00           H  
ATOM    998  HA3 GLY A  65      18.073  98.555  -1.130  1.00  0.00           H  
ATOM    999  N   TYR A  66      17.965 101.141  -1.797  1.00  0.00           N  
ATOM   1000  CA  TYR A  66      18.860 102.270  -2.036  1.00  0.00           C  
ATOM   1001  C   TYR A  66      20.269 101.922  -1.509  1.00  0.00           C  
ATOM   1002  O   TYR A  66      20.524 100.772  -1.138  1.00  0.00           O  
ATOM   1003  CB  TYR A  66      18.295 103.507  -1.328  1.00  0.00           C  
ATOM   1004  CG  TYR A  66      16.847 103.846  -1.634  1.00  0.00           C  
ATOM   1005  CD1 TYR A  66      16.508 104.479  -2.846  1.00  0.00           C  
ATOM   1006  CD2 TYR A  66      15.840 103.536  -0.699  1.00  0.00           C  
ATOM   1007  CE1 TYR A  66      15.161 104.771  -3.134  1.00  0.00           C  
ATOM   1008  CE2 TYR A  66      14.490 103.823  -0.992  1.00  0.00           C  
ATOM   1009  CZ  TYR A  66      14.145 104.415  -2.225  1.00  0.00           C  
ATOM   1010  OH  TYR A  66      12.849 104.671  -2.526  1.00  0.00           O  
ATOM   1011  H   TYR A  66      17.768 100.973  -0.824  1.00  0.00           H  
ATOM   1012  HA  TYR A  66      18.934 102.463  -3.106  1.00  0.00           H  
ATOM   1013  HB2 TYR A  66      18.418 103.391  -0.251  1.00  0.00           H  
ATOM   1014  HB3 TYR A  66      18.905 104.343  -1.628  1.00  0.00           H  
ATOM   1015  HD1 TYR A  66      17.281 104.713  -3.570  1.00  0.00           H  
ATOM   1016  HD2 TYR A  66      16.112 103.047   0.234  1.00  0.00           H  
ATOM   1017  HE1 TYR A  66      14.887 105.246  -4.060  1.00  0.00           H  
ATOM   1018  HE2 TYR A  66      13.707 103.573  -0.290  1.00  0.00           H  
ATOM   1019  HH  TYR A  66      12.720 104.933  -3.442  1.00  0.00           H  
ATOM   1020  N   VAL A  67      21.192 102.889  -1.408  1.00  0.00           N  
ATOM   1021  CA  VAL A  67      22.429 102.679  -0.630  1.00  0.00           C  
ATOM   1022  C   VAL A  67      22.172 102.797   0.874  1.00  0.00           C  
ATOM   1023  O   VAL A  67      22.472 103.767   1.557  1.00  0.00           O  
ATOM   1024  CB  VAL A  67      23.644 103.480  -1.077  1.00  0.00           C  
ATOM   1025  CG1 VAL A  67      24.098 103.008  -2.468  1.00  0.00           C  
ATOM   1026  CG2 VAL A  67      23.443 105.000  -1.117  1.00  0.00           C  
ATOM   1027  H   VAL A  67      20.942 103.814  -1.706  1.00  0.00           H  
ATOM   1028  HA  VAL A  67      22.735 101.646  -0.791  1.00  0.00           H  
ATOM   1029  HB  VAL A  67      24.399 103.206  -0.340  1.00  0.00           H  
ATOM   1030 HG11 VAL A  67      24.378 101.956  -2.434  1.00  0.00           H  
ATOM   1031 HG12 VAL A  67      23.289 103.128  -3.191  1.00  0.00           H  
ATOM   1032 HG13 VAL A  67      24.952 103.593  -2.803  1.00  0.00           H  
ATOM   1033 HG21 VAL A  67      24.357 105.485  -1.456  1.00  0.00           H  
ATOM   1034 HG22 VAL A  67      22.624 105.252  -1.789  1.00  0.00           H  
ATOM   1035 HG23 VAL A  67      23.215 105.387  -0.125  1.00  0.00           H  
ATOM   1036  N   ASP A  68      21.597 101.715   1.361  1.00  0.00           N  
ATOM   1037  CA  ASP A  68      21.061 101.488   2.696  1.00  0.00           C  
ATOM   1038  C   ASP A  68      22.154 101.199   3.746  1.00  0.00           C  
ATOM   1039  O   ASP A  68      21.890 101.081   4.941  1.00  0.00           O  
ATOM   1040  CB  ASP A  68      20.142 100.282   2.603  1.00  0.00           C  
ATOM   1041  CG  ASP A  68      18.926 100.397   1.660  1.00  0.00           C  
ATOM   1042  OD1 ASP A  68      18.437 101.507   1.363  1.00  0.00           O  
ATOM   1043  OD2 ASP A  68      18.547  99.334   1.122  1.00  0.00           O  
ATOM   1044  H   ASP A  68      21.381 101.046   0.645  1.00  0.00           H  
ATOM   1045  HA  ASP A  68      20.464 102.330   3.020  1.00  0.00           H  
ATOM   1046  HB2 ASP A  68      20.764  99.458   2.272  1.00  0.00           H  
ATOM   1047  HB3 ASP A  68      19.818 100.062   3.604  1.00  0.00           H  
ATOM   1048  N   THR A  69      23.398 101.000   3.310  1.00  0.00           N  
ATOM   1049  CA  THR A  69      24.539 100.764   4.206  1.00  0.00           C  
ATOM   1050  C   THR A  69      25.832 101.257   3.581  1.00  0.00           C  
ATOM   1051  O   THR A  69      25.948 101.349   2.360  1.00  0.00           O  
ATOM   1052  CB  THR A  69      24.700  99.274   4.555  1.00  0.00           C  
ATOM   1053  OG1 THR A  69      23.508  98.541   4.384  1.00  0.00           O  
ATOM   1054  CG2 THR A  69      25.134  99.055   6.005  1.00  0.00           C  
ATOM   1055  H   THR A  69      23.547 101.023   2.310  1.00  0.00           H  
ATOM   1056  HA  THR A  69      24.402 101.314   5.129  1.00  0.00           H  
ATOM   1057  HB  THR A  69      25.473  98.872   3.905  1.00  0.00           H  
ATOM   1058  HG1 THR A  69      22.808  99.058   4.807  1.00  0.00           H  
ATOM   1059 HG21 THR A  69      26.104  99.513   6.190  1.00  0.00           H  
ATOM   1060 HG22 THR A  69      25.212  97.986   6.202  1.00  0.00           H  
ATOM   1061 HG23 THR A  69      24.395  99.484   6.684  1.00  0.00           H  
ATOM   1062  N   GLU A  70      26.841 101.447   4.432  1.00  0.00           N  
ATOM   1063  CA  GLU A  70      28.235 101.758   4.072  1.00  0.00           C  
ATOM   1064  C   GLU A  70      28.698 100.816   2.973  1.00  0.00           C  
ATOM   1065  O   GLU A  70      28.966 101.208   1.846  1.00  0.00           O  
ATOM   1066  CB  GLU A  70      29.119 101.600   5.331  1.00  0.00           C  
ATOM   1067  CG  GLU A  70      30.347 102.519   5.386  1.00  0.00           C  
ATOM   1068  CD  GLU A  70      31.479 102.048   4.463  1.00  0.00           C  
ATOM   1069  OE1 GLU A  70      32.256 101.151   4.866  1.00  0.00           O  
ATOM   1070  OE2 GLU A  70      31.585 102.566   3.337  1.00  0.00           O  
ATOM   1071  H   GLU A  70      26.620 101.286   5.400  1.00  0.00           H  
ATOM   1072  HA  GLU A  70      28.291 102.770   3.679  1.00  0.00           H  
ATOM   1073  HB2 GLU A  70      28.488 101.794   6.193  1.00  0.00           H  
ATOM   1074  HB3 GLU A  70      29.458 100.565   5.440  1.00  0.00           H  
ATOM   1075  HG2 GLU A  70      30.046 103.539   5.134  1.00  0.00           H  
ATOM   1076  HG3 GLU A  70      30.717 102.531   6.415  1.00  0.00           H  
ATOM   1077  N   SER A  71      28.589  99.529   3.281  1.00  0.00           N  
ATOM   1078  CA  SER A  71      29.017  98.444   2.387  1.00  0.00           C  
ATOM   1079  C   SER A  71      28.309  98.465   1.029  1.00  0.00           C  
ATOM   1080  O   SER A  71      28.881  98.072   0.009  1.00  0.00           O  
ATOM   1081  CB  SER A  71      28.789  97.102   3.077  1.00  0.00           C  
ATOM   1082  OG  SER A  71      29.795  96.186   2.698  1.00  0.00           O  
ATOM   1083  H   SER A  71      28.263  99.408   4.233  1.00  0.00           H  
ATOM   1084  HA  SER A  71      30.082  98.576   2.200  1.00  0.00           H  
ATOM   1085  HB2 SER A  71      28.823  97.263   4.152  1.00  0.00           H  
ATOM   1086  HB3 SER A  71      27.804  96.706   2.817  1.00  0.00           H  
ATOM   1087  HG  SER A  71      29.848  95.484   3.356  1.00  0.00           H  
ATOM   1088  N   LYS A  72      27.071  98.980   1.002  1.00  0.00           N  
ATOM   1089  CA  LYS A  72      26.304  99.156  -0.230  1.00  0.00           C  
ATOM   1090  C   LYS A  72      26.695 100.407  -1.014  1.00  0.00           C  
ATOM   1091  O   LYS A  72      26.832 100.336  -2.230  1.00  0.00           O  
ATOM   1092  CB  LYS A  72      24.791  99.075   0.005  1.00  0.00           C  
ATOM   1093  CG  LYS A  72      24.204  98.193  -1.114  1.00  0.00           C  
ATOM   1094  CD  LYS A  72      22.693  98.304  -1.267  1.00  0.00           C  
ATOM   1095  CE  LYS A  72      21.931  97.961   0.015  1.00  0.00           C  
ATOM   1096  NZ  LYS A  72      20.491  98.154  -0.218  1.00  0.00           N  
ATOM   1097  H   LYS A  72      26.763  99.421   1.859  1.00  0.00           H  
ATOM   1098  HA  LYS A  72      26.577  98.321  -0.855  1.00  0.00           H  
ATOM   1099  HB2 LYS A  72      24.573  98.617   0.973  1.00  0.00           H  
ATOM   1100  HB3 LYS A  72      24.361 100.079  -0.021  1.00  0.00           H  
ATOM   1101  HG2 LYS A  72      24.643  98.484  -2.071  1.00  0.00           H  
ATOM   1102  HG3 LYS A  72      24.469  97.152  -0.922  1.00  0.00           H  
ATOM   1103  HD2 LYS A  72      22.465  99.321  -1.579  1.00  0.00           H  
ATOM   1104  HD3 LYS A  72      22.376  97.630  -2.067  1.00  0.00           H  
ATOM   1105  HE2 LYS A  72      22.133  96.922   0.290  1.00  0.00           H  
ATOM   1106  HE3 LYS A  72      22.263  98.619   0.822  1.00  0.00           H  
ATOM   1107  HZ1 LYS A  72      20.143  97.531  -0.942  1.00  0.00           H  
ATOM   1108  HZ2 LYS A  72      20.307  99.096  -0.559  1.00  0.00           H  
ATOM   1109  HZ3 LYS A  72      19.904  98.083   0.612  1.00  0.00           H  
ATOM   1110  N   PHE A  73      26.948 101.526  -0.339  1.00  0.00           N  
ATOM   1111  CA  PHE A  73      27.526 102.713  -0.985  1.00  0.00           C  
ATOM   1112  C   PHE A  73      28.929 102.411  -1.543  1.00  0.00           C  
ATOM   1113  O   PHE A  73      29.221 102.679  -2.702  1.00  0.00           O  
ATOM   1114  CB  PHE A  73      27.528 103.908  -0.017  1.00  0.00           C  
ATOM   1115  CG  PHE A  73      28.123 105.176  -0.608  1.00  0.00           C  
ATOM   1116  CD1 PHE A  73      27.625 105.705  -1.816  1.00  0.00           C  
ATOM   1117  CD2 PHE A  73      29.208 105.811   0.029  1.00  0.00           C  
ATOM   1118  CE1 PHE A  73      28.243 106.820  -2.411  1.00  0.00           C  
ATOM   1119  CE2 PHE A  73      29.818 106.933  -0.561  1.00  0.00           C  
ATOM   1120  CZ  PHE A  73      29.353 107.417  -1.794  1.00  0.00           C  
ATOM   1121  H   PHE A  73      26.875 101.472   0.675  1.00  0.00           H  
ATOM   1122  HA  PHE A  73      26.905 102.972  -1.841  1.00  0.00           H  
ATOM   1123  HB2 PHE A  73      26.504 104.121   0.288  1.00  0.00           H  
ATOM   1124  HB3 PHE A  73      28.085 103.636   0.881  1.00  0.00           H  
ATOM   1125  HD1 PHE A  73      26.786 105.247  -2.313  1.00  0.00           H  
ATOM   1126  HD2 PHE A  73      29.601 105.431   0.961  1.00  0.00           H  
ATOM   1127  HE1 PHE A  73      27.888 107.208  -3.355  1.00  0.00           H  
ATOM   1128  HE2 PHE A  73      30.673 107.407  -0.097  1.00  0.00           H  
ATOM   1129  HZ  PHE A  73      29.880 108.231  -2.275  1.00  0.00           H  
ATOM   1130  N   ARG A  74      29.775 101.735  -0.766  1.00  0.00           N  
ATOM   1131  CA  ARG A  74      31.166 101.363  -1.071  1.00  0.00           C  
ATOM   1132  C   ARG A  74      31.323 100.463  -2.296  1.00  0.00           C  
ATOM   1133  O   ARG A  74      32.355 100.515  -2.960  1.00  0.00           O  
ATOM   1134  CB  ARG A  74      31.730 100.733   0.211  1.00  0.00           C  
ATOM   1135  CG  ARG A  74      33.257 100.712   0.311  1.00  0.00           C  
ATOM   1136  CD  ARG A  74      33.622 100.278   1.737  1.00  0.00           C  
ATOM   1137  NE  ARG A  74      35.057 100.449   2.013  1.00  0.00           N  
ATOM   1138  CZ  ARG A  74      35.586 100.943   3.121  1.00  0.00           C  
ATOM   1139  NH1 ARG A  74      34.883 101.321   4.149  1.00  0.00           N  
ATOM   1140  NH2 ARG A  74      36.880 101.063   3.211  1.00  0.00           N  
ATOM   1141  H   ARG A  74      29.437 101.548   0.174  1.00  0.00           H  
ATOM   1142  HA  ARG A  74      31.703 102.282  -1.294  1.00  0.00           H  
ATOM   1143  HB2 ARG A  74      31.374 101.331   1.052  1.00  0.00           H  
ATOM   1144  HB3 ARG A  74      31.341  99.718   0.322  1.00  0.00           H  
ATOM   1145  HG2 ARG A  74      33.678 100.015  -0.415  1.00  0.00           H  
ATOM   1146  HG3 ARG A  74      33.642 101.716   0.127  1.00  0.00           H  
ATOM   1147  HD2 ARG A  74      33.045 100.883   2.433  1.00  0.00           H  
ATOM   1148  HD3 ARG A  74      33.338  99.236   1.887  1.00  0.00           H  
ATOM   1149  HE  ARG A  74      35.682 100.187   1.275  1.00  0.00           H  
ATOM   1150 HH11 ARG A  74      33.855 101.228   4.143  1.00  0.00           H  
ATOM   1151 HH12 ARG A  74      35.275 101.708   4.979  1.00  0.00           H  
ATOM   1152 HH21 ARG A  74      37.468 100.781   2.451  1.00  0.00           H  
ATOM   1153 HH22 ARG A  74      37.266 101.433   4.056  1.00  0.00           H  
ATOM   1154  N   LYS A  75      30.270  99.720  -2.652  1.00  0.00           N  
ATOM   1155  CA  LYS A  75      30.055  99.026  -3.925  1.00  0.00           C  
ATOM   1156  C   LYS A  75      30.155  99.982  -5.114  1.00  0.00           C  
ATOM   1157  O   LYS A  75      30.897  99.732  -6.060  1.00  0.00           O  
ATOM   1158  CB  LYS A  75      28.657  98.374  -3.890  1.00  0.00           C  
ATOM   1159  CG  LYS A  75      28.519  97.188  -4.847  1.00  0.00           C  
ATOM   1160  CD  LYS A  75      29.133  95.945  -4.204  1.00  0.00           C  
ATOM   1161  CE  LYS A  75      28.965  94.744  -5.140  1.00  0.00           C  
ATOM   1162  NZ  LYS A  75      29.482  93.503  -4.513  1.00  0.00           N  
ATOM   1163  H   LYS A  75      29.495  99.758  -2.012  1.00  0.00           H  
ATOM   1164  HA  LYS A  75      30.832  98.276  -4.033  1.00  0.00           H  
ATOM   1165  HB2 LYS A  75      28.427  98.039  -2.874  1.00  0.00           H  
ATOM   1166  HB3 LYS A  75      27.904  99.112  -4.172  1.00  0.00           H  
ATOM   1167  HG2 LYS A  75      27.458  97.003  -5.025  1.00  0.00           H  
ATOM   1168  HG3 LYS A  75      29.004  97.407  -5.798  1.00  0.00           H  
ATOM   1169  HD2 LYS A  75      30.189  96.131  -3.996  1.00  0.00           H  
ATOM   1170  HD3 LYS A  75      28.612  95.761  -3.261  1.00  0.00           H  
ATOM   1171  HE2 LYS A  75      27.901  94.631  -5.374  1.00  0.00           H  
ATOM   1172  HE3 LYS A  75      29.492  94.948  -6.077  1.00  0.00           H  
ATOM   1173  HZ1 LYS A  75      28.969  93.307  -3.663  1.00  0.00           H  
ATOM   1174  HZ2 LYS A  75      30.461  93.613  -4.281  1.00  0.00           H  
ATOM   1175  HZ3 LYS A  75      29.377  92.715  -5.140  1.00  0.00           H  
ATOM   1176  N   LEU A  76      29.439 101.098  -5.007  1.00  0.00           N  
ATOM   1177  CA  LEU A  76      29.437 102.169  -5.993  1.00  0.00           C  
ATOM   1178  C   LEU A  76      30.772 102.882  -6.000  1.00  0.00           C  
ATOM   1179  O   LEU A  76      31.406 102.972  -7.044  1.00  0.00           O  
ATOM   1180  CB  LEU A  76      28.268 103.136  -5.712  1.00  0.00           C  
ATOM   1181  CG  LEU A  76      27.975 104.147  -6.829  1.00  0.00           C  
ATOM   1182  CD1 LEU A  76      27.437 103.466  -8.084  1.00  0.00           C  
ATOM   1183  CD2 LEU A  76      26.921 105.153  -6.361  1.00  0.00           C  
ATOM   1184  H   LEU A  76      29.008 101.261  -4.100  1.00  0.00           H  
ATOM   1185  HA  LEU A  76      29.367 101.705  -6.969  1.00  0.00           H  
ATOM   1186  HB2 LEU A  76      27.371 102.552  -5.505  1.00  0.00           H  
ATOM   1187  HB3 LEU A  76      28.500 103.723  -4.823  1.00  0.00           H  
ATOM   1188  HG  LEU A  76      28.885 104.690  -7.072  1.00  0.00           H  
ATOM   1189 HD11 LEU A  76      26.560 102.865  -7.840  1.00  0.00           H  
ATOM   1190 HD12 LEU A  76      28.205 102.828  -8.514  1.00  0.00           H  
ATOM   1191 HD13 LEU A  76      27.161 104.214  -8.828  1.00  0.00           H  
ATOM   1192 HD21 LEU A  76      26.737 105.885  -7.146  1.00  0.00           H  
ATOM   1193 HD22 LEU A  76      27.286 105.677  -5.477  1.00  0.00           H  
ATOM   1194 HD23 LEU A  76      25.991 104.639  -6.116  1.00  0.00           H  
ATOM   1195  N   VAL A  77      31.240 103.310  -4.832  1.00  0.00           N  
ATOM   1196  CA  VAL A  77      32.520 104.031  -4.750  1.00  0.00           C  
ATOM   1197  C   VAL A  77      33.656 103.204  -5.332  1.00  0.00           C  
ATOM   1198  O   VAL A  77      34.458 103.706  -6.118  1.00  0.00           O  
ATOM   1199  CB  VAL A  77      32.847 104.476  -3.312  1.00  0.00           C  
ATOM   1200  CG1 VAL A  77      34.213 105.168  -3.206  1.00  0.00           C  
ATOM   1201  CG2 VAL A  77      31.792 105.445  -2.782  1.00  0.00           C  
ATOM   1202  H   VAL A  77      30.623 103.134  -4.038  1.00  0.00           H  
ATOM   1203  HA  VAL A  77      32.438 104.892  -5.407  1.00  0.00           H  
ATOM   1204  HB  VAL A  77      32.866 103.597  -2.669  1.00  0.00           H  
ATOM   1205 HG11 VAL A  77      34.358 105.549  -2.194  1.00  0.00           H  
ATOM   1206 HG12 VAL A  77      35.019 104.470  -3.427  1.00  0.00           H  
ATOM   1207 HG13 VAL A  77      34.257 106.009  -3.900  1.00  0.00           H  
ATOM   1208 HG21 VAL A  77      30.809 104.975  -2.765  1.00  0.00           H  
ATOM   1209 HG22 VAL A  77      32.045 105.745  -1.766  1.00  0.00           H  
ATOM   1210 HG23 VAL A  77      31.752 106.340  -3.406  1.00  0.00           H  
ATOM   1211  N   THR A  78      33.676 101.904  -5.051  1.00  0.00           N  
ATOM   1212  CA  THR A  78      34.685 101.013  -5.614  1.00  0.00           C  
ATOM   1213  C   THR A  78      34.541 100.844  -7.112  1.00  0.00           C  
ATOM   1214  O   THR A  78      35.545 100.896  -7.830  1.00  0.00           O  
ATOM   1215  CB  THR A  78      34.706  99.649  -4.908  1.00  0.00           C  
ATOM   1216  OG1 THR A  78      34.906  99.834  -3.528  1.00  0.00           O  
ATOM   1217  CG2 THR A  78      35.839  98.739  -5.379  1.00  0.00           C  
ATOM   1218  H   THR A  78      32.943 101.534  -4.459  1.00  0.00           H  
ATOM   1219  HA  THR A  78      35.624 101.517  -5.489  1.00  0.00           H  
ATOM   1220  HB  THR A  78      33.751  99.143  -5.063  1.00  0.00           H  
ATOM   1221  HG1 THR A  78      34.049 100.135  -3.177  1.00  0.00           H  
ATOM   1222 HG21 THR A  78      36.795  99.242  -5.247  1.00  0.00           H  
ATOM   1223 HG22 THR A  78      35.702  98.475  -6.428  1.00  0.00           H  
ATOM   1224 HG23 THR A  78      35.834  97.822  -4.789  1.00  0.00           H  
ATOM   1225  N   ALA A  79      33.310 100.685  -7.597  1.00  0.00           N  
ATOM   1226  CA  ALA A  79      33.107 100.400  -9.011  1.00  0.00           C  
ATOM   1227  C   ALA A  79      33.323 101.627  -9.884  1.00  0.00           C  
ATOM   1228  O   ALA A  79      33.923 101.549 -10.955  1.00  0.00           O  
ATOM   1229  CB  ALA A  79      31.718  99.785  -9.215  1.00  0.00           C  
ATOM   1230  H   ALA A  79      32.509 100.871  -6.989  1.00  0.00           H  
ATOM   1231  HA  ALA A  79      33.883  99.716  -9.320  1.00  0.00           H  
ATOM   1232  HB1 ALA A  79      31.628  98.871  -8.628  1.00  0.00           H  
ATOM   1233  HB2 ALA A  79      30.946 100.491  -8.902  1.00  0.00           H  
ATOM   1234  HB3 ALA A  79      31.572  99.546 -10.269  1.00  0.00           H  
ATOM   1235  N   ILE A  80      32.932 102.785  -9.369  1.00  0.00           N  
ATOM   1236  CA  ILE A  80      32.990 104.037 -10.111  1.00  0.00           C  
ATOM   1237  C   ILE A  80      34.433 104.530 -10.124  1.00  0.00           C  
ATOM   1238  O   ILE A  80      34.888 105.032 -11.143  1.00  0.00           O  
ATOM   1239  CB  ILE A  80      31.967 105.039  -9.541  1.00  0.00           C  
ATOM   1240  CG1 ILE A  80      30.517 104.516  -9.701  1.00  0.00           C  
ATOM   1241  CG2 ILE A  80      32.100 106.421 -10.193  1.00  0.00           C  
ATOM   1242  CD1 ILE A  80      29.947 104.489 -11.126  1.00  0.00           C  
ATOM   1243  H   ILE A  80      32.665 102.765  -8.384  1.00  0.00           H  
ATOM   1244  HA  ILE A  80      32.724 103.844 -11.149  1.00  0.00           H  
ATOM   1245  HB  ILE A  80      32.169 105.149  -8.474  1.00  0.00           H  
ATOM   1246 HG12 ILE A  80      30.447 103.501  -9.310  1.00  0.00           H  
ATOM   1247 HG13 ILE A  80      29.867 105.141  -9.094  1.00  0.00           H  
ATOM   1248 HG21 ILE A  80      31.329 107.091  -9.815  1.00  0.00           H  
ATOM   1249 HG22 ILE A  80      33.071 106.851  -9.954  1.00  0.00           H  
ATOM   1250 HG23 ILE A  80      32.010 106.345 -11.276  1.00  0.00           H  
ATOM   1251 HD11 ILE A  80      28.956 104.035 -11.104  1.00  0.00           H  
ATOM   1252 HD12 ILE A  80      29.850 105.502 -11.516  1.00  0.00           H  
ATOM   1253 HD13 ILE A  80      30.590 103.902 -11.779  1.00  0.00           H  
ATOM   1254  N   LYS A  81      35.217 104.232  -9.080  1.00  0.00           N  
ATOM   1255  CA  LYS A  81      36.656 104.534  -9.049  1.00  0.00           C  
ATOM   1256  C   LYS A  81      37.403 103.744 -10.114  1.00  0.00           C  
ATOM   1257  O   LYS A  81      38.282 104.250 -10.806  1.00  0.00           O  
ATOM   1258  CB  LYS A  81      37.194 104.179  -7.658  1.00  0.00           C  
ATOM   1259  CG  LYS A  81      38.657 104.594  -7.414  1.00  0.00           C  
ATOM   1260  CD  LYS A  81      39.676 103.464  -7.628  1.00  0.00           C  
ATOM   1261  CE  LYS A  81      39.477 102.351  -6.589  1.00  0.00           C  
ATOM   1262  NZ  LYS A  81      40.494 101.282  -6.722  1.00  0.00           N  
ATOM   1263  H   LYS A  81      34.794 103.677  -8.337  1.00  0.00           H  
ATOM   1264  HA  LYS A  81      36.780 105.605  -9.252  1.00  0.00           H  
ATOM   1265  HB2 LYS A  81      36.577 104.696  -6.939  1.00  0.00           H  
ATOM   1266  HB3 LYS A  81      37.059 103.111  -7.475  1.00  0.00           H  
ATOM   1267  HG2 LYS A  81      38.908 105.434  -8.063  1.00  0.00           H  
ATOM   1268  HG3 LYS A  81      38.747 104.940  -6.383  1.00  0.00           H  
ATOM   1269  HD2 LYS A  81      39.582 103.062  -8.636  1.00  0.00           H  
ATOM   1270  HD3 LYS A  81      40.676 103.888  -7.520  1.00  0.00           H  
ATOM   1271  HE2 LYS A  81      39.524 102.802  -5.592  1.00  0.00           H  
ATOM   1272  HE3 LYS A  81      38.477 101.922  -6.717  1.00  0.00           H  
ATOM   1273  HZ1 LYS A  81      40.352 100.578  -6.008  1.00  0.00           H  
ATOM   1274  HZ2 LYS A  81      41.429 101.660  -6.621  1.00  0.00           H  
ATOM   1275  HZ3 LYS A  81      40.417 100.836  -7.627  1.00  0.00           H  
ATOM   1276  N   ALA A  82      37.074 102.459 -10.182  1.00  0.00           N  
ATOM   1277  CA  ALA A  82      37.636 101.528 -11.158  1.00  0.00           C  
ATOM   1278  C   ALA A  82      37.270 101.930 -12.596  1.00  0.00           C  
ATOM   1279  O   ALA A  82      38.154 102.028 -13.446  1.00  0.00           O  
ATOM   1280  CB  ALA A  82      37.185 100.102 -10.818  1.00  0.00           C  
ATOM   1281  H   ALA A  82      36.334 102.195  -9.543  1.00  0.00           H  
ATOM   1282  HA  ALA A  82      38.723 101.573 -11.089  1.00  0.00           H  
ATOM   1283  HB1 ALA A  82      36.100 100.020 -10.893  1.00  0.00           H  
ATOM   1284  HB2 ALA A  82      37.640  99.402 -11.520  1.00  0.00           H  
ATOM   1285  HB3 ALA A  82      37.493  99.844  -9.805  1.00  0.00           H  
ATOM   1286  N   ALA A  83      35.990 102.216 -12.851  1.00  0.00           N  
ATOM   1287  CA  ALA A  83      35.489 102.684 -14.145  1.00  0.00           C  
ATOM   1288  C   ALA A  83      36.075 104.035 -14.574  1.00  0.00           C  
ATOM   1289  O   ALA A  83      36.285 104.283 -15.764  1.00  0.00           O  
ATOM   1290  CB  ALA A  83      33.958 102.733 -14.091  1.00  0.00           C  
ATOM   1291  H   ALA A  83      35.318 102.099 -12.100  1.00  0.00           H  
ATOM   1292  HA  ALA A  83      35.800 101.973 -14.897  1.00  0.00           H  
ATOM   1293  HB1 ALA A  83      33.634 103.484 -13.370  1.00  0.00           H  
ATOM   1294  HB2 ALA A  83      33.568 102.995 -15.075  1.00  0.00           H  
ATOM   1295  HB3 ALA A  83      33.562 101.759 -13.802  1.00  0.00           H  
ATOM   1296  N   LEU A  84      36.396 104.879 -13.594  1.00  0.00           N  
ATOM   1297  CA  LEU A  84      37.064 106.153 -13.835  1.00  0.00           C  
ATOM   1298  C   LEU A  84      38.466 105.932 -14.388  1.00  0.00           C  
ATOM   1299  O   LEU A  84      38.776 106.392 -15.483  1.00  0.00           O  
ATOM   1300  CB  LEU A  84      37.070 106.978 -12.536  1.00  0.00           C  
ATOM   1301  CG  LEU A  84      37.279 108.481 -12.700  1.00  0.00           C  
ATOM   1302  CD1 LEU A  84      38.724 108.854 -13.029  1.00  0.00           C  
ATOM   1303  CD2 LEU A  84      36.288 109.021 -13.736  1.00  0.00           C  
ATOM   1304  H   LEU A  84      36.167 104.591 -12.646  1.00  0.00           H  
ATOM   1305  HA  LEU A  84      36.495 106.672 -14.606  1.00  0.00           H  
ATOM   1306  HB2 LEU A  84      36.092 106.908 -12.084  1.00  0.00           H  
ATOM   1307  HB3 LEU A  84      37.794 106.574 -11.829  1.00  0.00           H  
ATOM   1308  HG  LEU A  84      37.041 108.916 -11.731  1.00  0.00           H  
ATOM   1309 HD11 LEU A  84      38.872 109.919 -12.868  1.00  0.00           H  
ATOM   1310 HD12 LEU A  84      38.959 108.618 -14.063  1.00  0.00           H  
ATOM   1311 HD13 LEU A  84      39.404 108.319 -12.367  1.00  0.00           H  
ATOM   1312 HD21 LEU A  84      35.941 109.997 -13.431  1.00  0.00           H  
ATOM   1313 HD22 LEU A  84      35.399 108.393 -13.786  1.00  0.00           H  
ATOM   1314 HD23 LEU A  84      36.738 109.070 -14.729  1.00  0.00           H  
ATOM   1315  N   ALA A  85      39.280 105.167 -13.662  1.00  0.00           N  
ATOM   1316  CA  ALA A  85      40.654 104.847 -14.057  1.00  0.00           C  
ATOM   1317  C   ALA A  85      40.792 104.052 -15.374  1.00  0.00           C  
ATOM   1318  O   ALA A  85      41.887 103.972 -15.925  1.00  0.00           O  
ATOM   1319  CB  ALA A  85      41.332 104.126 -12.886  1.00  0.00           C  
ATOM   1320  H   ALA A  85      38.900 104.856 -12.772  1.00  0.00           H  
ATOM   1321  HA  ALA A  85      41.163 105.792 -14.246  1.00  0.00           H  
ATOM   1322  HB1 ALA A  85      41.283 104.749 -11.992  1.00  0.00           H  
ATOM   1323  HB2 ALA A  85      40.828 103.178 -12.698  1.00  0.00           H  
ATOM   1324  HB3 ALA A  85      42.378 103.937 -13.133  1.00  0.00           H  
ATOM   1325  N   GLN A  86      39.693 103.515 -15.910  1.00  0.00           N  
ATOM   1326  CA  GLN A  86      39.602 102.966 -17.267  1.00  0.00           C  
ATOM   1327  C   GLN A  86      39.435 104.093 -18.291  1.00  0.00           C  
ATOM   1328  O   GLN A  86      40.250 104.287 -19.191  1.00  0.00           O  
ATOM   1329  CB  GLN A  86      38.436 101.963 -17.362  1.00  0.00           C  
ATOM   1330  CG  GLN A  86      38.660 100.659 -16.575  1.00  0.00           C  
ATOM   1331  CD  GLN A  86      39.671  99.707 -17.211  1.00  0.00           C  
ATOM   1332  OE1 GLN A  86      40.122  99.857 -18.331  1.00  0.00           O  
ATOM   1333  NE2 GLN A  86      40.055  98.654 -16.522  1.00  0.00           N  
ATOM   1334  H   GLN A  86      38.852 103.703 -15.389  1.00  0.00           H  
ATOM   1335  HA  GLN A  86      40.522 102.460 -17.520  1.00  0.00           H  
ATOM   1336  HB2 GLN A  86      37.529 102.432 -16.987  1.00  0.00           H  
ATOM   1337  HB3 GLN A  86      38.259 101.714 -18.410  1.00  0.00           H  
ATOM   1338  HG2 GLN A  86      38.994 100.894 -15.567  1.00  0.00           H  
ATOM   1339  HG3 GLN A  86      37.707 100.135 -16.506  1.00  0.00           H  
ATOM   1340 HE21 GLN A  86      39.730  98.464 -15.594  1.00  0.00           H  
ATOM   1341 HE22 GLN A  86      40.706  98.078 -17.030  1.00  0.00           H  
ATOM   1342  N   CYS A  87      38.365 104.867 -18.129  1.00  0.00           N  
ATOM   1343  CA  CYS A  87      38.001 105.966 -19.030  1.00  0.00           C  
ATOM   1344  C   CYS A  87      39.001 107.133 -19.045  1.00  0.00           C  
ATOM   1345  O   CYS A  87      39.087 107.852 -20.044  1.00  0.00           O  
ATOM   1346  CB  CYS A  87      36.597 106.473 -18.679  1.00  0.00           C  
ATOM   1347  SG  CYS A  87      35.692 106.751 -20.230  1.00  0.00           S  
ATOM   1348  H   CYS A  87      37.806 104.634 -17.323  1.00  0.00           H  
ATOM   1349  HA  CYS A  87      37.988 105.558 -20.041  1.00  0.00           H  
ATOM   1350  HB2 CYS A  87      36.080 105.734 -18.068  1.00  0.00           H  
ATOM   1351  HB3 CYS A  87      36.665 107.408 -18.113  1.00  0.00           H  
ATOM   1352  HG  CYS A  87      35.691 105.479 -20.641  1.00  0.00           H  
ATOM   1353  N   GLN A  88      39.785 107.300 -17.972  1.00  0.00           N  
ATOM   1354  CA  GLN A  88      40.862 108.295 -17.928  1.00  0.00           C  
ATOM   1355  C   GLN A  88      42.042 107.965 -18.860  1.00  0.00           C  
ATOM   1356  O   GLN A  88      42.779 108.872 -19.241  1.00  0.00           O  
ATOM   1357  CB  GLN A  88      41.368 108.484 -16.488  1.00  0.00           C  
ATOM   1358  CG  GLN A  88      41.945 109.897 -16.268  1.00  0.00           C  
ATOM   1359  CD  GLN A  88      43.167 109.928 -15.350  1.00  0.00           C  
ATOM   1360  OE1 GLN A  88      43.299 109.183 -14.395  1.00  0.00           O  
ATOM   1361  NE2 GLN A  88      44.114 110.810 -15.592  1.00  0.00           N  
ATOM   1362  H   GLN A  88      39.576 106.734 -17.150  1.00  0.00           H  
ATOM   1363  HA  GLN A  88      40.442 109.233 -18.288  1.00  0.00           H  
ATOM   1364  HB2 GLN A  88      40.546 108.347 -15.782  1.00  0.00           H  
ATOM   1365  HB3 GLN A  88      42.127 107.723 -16.282  1.00  0.00           H  
ATOM   1366  HG2 GLN A  88      42.236 110.334 -17.225  1.00  0.00           H  
ATOM   1367  HG3 GLN A  88      41.170 110.528 -15.831  1.00  0.00           H  
ATOM   1368 HE21 GLN A  88      44.078 111.449 -16.363  1.00  0.00           H  
ATOM   1369 HE22 GLN A  88      44.872 110.751 -14.937  1.00  0.00           H  
TER    1370      GLN A  88                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
