
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  785),  selected   98 , name 2hzt_A
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 2hzt_A.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S       1           -
LGA    -       -      N       2           -
LGA    -       -      A       3           -
LGA    -       -      M       4           -
LGA    -       -      L       5           -
LGA    -       -      R       6           -
LGA    -       -      Y       7           -
LGA    -       -      G       8           -
LGA    -       -      D       9           -
LGA    -       -      T      10           -
LGA    -       -      E      11           -
LGA    -       -      I      12           -
LGA    -       -      C      13           -
LGA    X     1_A      I      14           #
LGA    S     2_A      D      15          1.445
LGA    L     3_A      P      16          5.383
LGA    V     4_A      -       -           -
LGA    E     5_A      S      17          5.612
LGA    -       -      E      18           -
LGA    A     6_A      S      19          0.990
LGA    T     7_A      V      20          3.130
LGA    L     8_A      L      21          2.054
LGA    E     9_A      H      22          2.277
LGA    V    10_A      L      23          2.896
LGA    I    11_A      L      24          1.161
LGA    G    12_A      G      25          1.464
LGA    G    13_A      K      26          1.703
LGA    K    14_A      K      27          1.523
LGA    W    15_A      Y      28          1.225
LGA    K    16_A      T      29          1.242
LGA    X    17_A      M      30          1.045
LGA    V    18_A      L      31          0.770
LGA    I    19_A      I      32          0.899
LGA    L    20_A      I      33          0.928
LGA    X    21_A      S      34          0.759
LGA    H    22_A      V      35          0.636
LGA    L    23_A      L      36          0.547
LGA    T    24_A      G      37          0.559
LGA    H    25_A      N      38          1.610
LGA    -       -      G      39           -
LGA    -       -      S      40           -
LGA    G    26_A      T      41          4.281
LGA    K    27_A      R      42          1.866
LGA    K    28_A      Q      43          0.769
LGA    R    29_A      N      44          0.863
LGA    T    30_A      F      45          0.727
LGA    S    31_A      N      46          1.398
LGA    E    32_A      D      47          1.244
LGA    L    33_A      I      48          1.465
LGA    K    34_A      R      49          2.138
LGA    R    35_A      S      50          1.665
LGA    L    36_A      S      51          1.487
LGA    X    37_A      I      52          2.220
LGA    P    38_A      P      53          3.832
LGA    N    39_A      G      54          1.072
LGA    I    40_A      I      55          1.521
LGA    T    41_A      S      56          1.502
LGA    Q    42_A      S      57          1.525
LGA    K    43_A      T      58          1.533
LGA    X    44_A      I      59          1.553
LGA    L    45_A      L      60          1.274
LGA    T    46_A      S      61          1.162
LGA    Q    47_A      R      62          1.063
LGA    Q    48_A      R      63          1.085
LGA    L    49_A      I      64          0.864
LGA    R    50_A      K      65          0.684
LGA    E    51_A      D      66          0.745
LGA    L    52_A      L      67          0.664
LGA    E    53_A      I      68          0.519
LGA    A    54_A      D      69          0.530
LGA    D    55_A      S      70          0.516
LGA    G    56_A      G      71          0.557
LGA    V    57_A      L      72          0.416
LGA    I    58_A      V      73          0.545
LGA    N    59_A      E      74          0.851
LGA    R    60_A      R      75          0.639
LGA    I    61_A      R      76          0.579
LGA    V    62_A      S      77          0.754
LGA    Y    63_A      G      78          0.344
LGA    N    64_A      Q      79          4.841
LGA    Q    65_A      -       -           -
LGA    V    66_A      -       -           -
LGA    P    67_A      -       -           -
LGA    P    68_A      -       -           -
LGA    K    69_A      I      80          2.207
LGA    V    70_A      T      81          0.882
LGA    E    71_A      T      82          0.501
LGA    Y    72_A      Y      83          0.336
LGA    E    73_A      A      84          0.221
LGA    L    74_A      L      85          0.747
LGA    S    75_A      T      86          0.643
LGA    E    76_A      E      87          0.652
LGA    Y    77_A      K      88          0.755
LGA    G    78_A      G      89          0.439
LGA    R    79_A      M      90          0.883
LGA    S    80_A      N      91          1.011
LGA    L    81_A      V      92          0.940
LGA    E    82_A      R      93          2.527
LGA    G    83_A      N      94          3.408
LGA    I    84_A      S      95          2.568
LGA    L    85_A      L      96          1.274
LGA    D    86_A      M      97          2.261
LGA    X    87_A      P      98          2.559
LGA    L    88_A      L      99          1.015
LGA    X    89_A      L     100          2.094
LGA    A    90_A      Q     101          3.497
LGA    W    91_A      Y     102          2.546
LGA    G    92_A      I     103          1.136
LGA    A    93_A      S     104          3.522
LGA    N    94_A      V     105          3.709
LGA    H    95_A      L     106          1.756
LGA    I    96_A      D     107          2.505
LGA    N    97_A      R     108          3.463
LGA    R    98_A      N     109          2.530

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98  109    5.0     92    1.94    18.48     77.223     4.521

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.347041 * X  +  -0.665048 * Y  +  -0.661267 * Z  +  34.710079
  Y_new =  -0.853052 * X  +  -0.516823 * Y  +   0.072087 * Z  +  27.528278
  Z_new =  -0.389699 * X  +   0.539078 * Y  +  -0.746679 * Z  +   8.239423 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.516275   -0.625317  [ DEG:   144.1720    -35.8281 ]
  Theta =   0.400305    2.741288  [ DEG:    22.9358    157.0642 ]
  Phi   =  -1.184422    1.957170  [ DEG:   -67.8624    112.1376 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hzt_A                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hzt_A.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98  109   5.0   92   1.94   18.48  77.223
REMARK  ---------------------------------------------------------- 
MOLECULE 2hzt_A
HEADER    TRANSCRIPTION REGULATOR                 09-AUG-06   2HZT              
TITLE     CRYSTAL STRUCTURE OF A PUTATIVE HTH-TYPE TRANSCRIPTIONAL              
TITLE    2 REGULATOR YTCD                                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE HTH-TYPE TRANSCRIPTIONAL REGULATOR YTCD;          
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    DNA-BINDING PROTEIN, HTH-TYPE TRANSCRIPTION REGULATORS,               
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM, NYSGXRC             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.MADEGOWDA,S.ESWARAMOORTHY,K.DESIGAN,S.K.BURLEY,                     
AUTHOR   2 S.SWAMINATHAN,NEW YORK STRUCTURAL GENOMIX RESEARCH                   
AUTHOR   3 CONSORTIUM (NYSGXRC)                                                 
REVDAT   1   29-AUG-06 2HZT    0                                                
JRNL        AUTH   M.MADEGOWDA,S.ESWARAMOORTHY,K.DESIGAN,S.K.BURLEY,            
JRNL        AUTH 2 S.SWAMINATHAN                                                
JRNL        TITL   CRYSTAL STRUCTURE OF A PUTATIVE HTH-TYPE                     
JRNL        TITL 2 TRANSCRIPTION REGULATOR YTCD                                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2HZT A    4    99  UNP    O34533   YTCD_BACSU      10    107             
DBREF  2HZT B    4    99  UNP    O34533   YTCD_BACSU      10    107             
DBREF  2HZT C    4    99  UNP    O34533   YTCD_BACSU      10    107             
DBREF  2HZT D    4    99  UNP    O34533   YTCD_BACSU      10    107             
SEQRES   1 A  107  MSE SER LEU VAL GLU ALA THR LEU GLU VAL ILE GLY GLY          
SEQRES   2 A  107  LYS TRP LYS CSU VAL ILE LEU CSU HIS LEU THR HIS GLY          
SEQRES   3 A  107  LYS LYS ARG THR SER GLU LEU LYS ARG LEU MSE PRO ASN          
SEQRES   4 A  107  ILE THR GLN LYS MSE LEU THR GLN GLN LEU ARG GLU LEU          
SEQRES   5 A  107  GLU ALA ASP GLY VAL ILE ASN ARG ILE VAL TYR ASN GLN          
SEQRES   6 A  107  VAL PRO PRO LYS VAL GLU TYR GLU LEU SER GLU TYR GLY          
SEQRES   7 A  107  ARG SER LEU GLU GLY ILE LEU ASP MSE LEU CSU ALA TRP          
SEQRES   8 A  107  GLY ALA ASN HIS ILE ASN ARG VAL GLU GLY HIS HIS HIS          
SEQRES   9 A  107  HIS HIS HIS                                                  
SEQRES   1 B  107  MSE SER LEU VAL GLU ALA THR LEU GLU VAL ILE GLY GLY          
SEQRES   2 B  107  LYS TRP LYS CSU VAL ILE LEU CSU HIS LEU THR HIS GLY          
SEQRES   3 B  107  LYS LYS ARG THR SER GLU LEU LYS ARG LEU MSE PRO ASN          
SEQRES   4 B  107  ILE THR GLN LYS MSE LEU THR GLN GLN LEU ARG GLU LEU          
SEQRES   5 B  107  GLU ALA ASP GLY VAL ILE ASN ARG ILE VAL TYR ASN GLN          
SEQRES   6 B  107  VAL PRO PRO LYS VAL GLU TYR GLU LEU SER GLU TYR GLY          
SEQRES   7 B  107  ARG SER LEU GLU GLY ILE LEU ASP MSE LEU CSU ALA TRP          
SEQRES   8 B  107  GLY ALA ASN HIS ILE ASN ARG VAL GLU GLY HIS HIS HIS          
SEQRES   9 B  107  HIS HIS HIS                                                  
SEQRES   1 C  107  MSE SER LEU VAL GLU ALA THR LEU GLU VAL ILE GLY GLY          
SEQRES   2 C  107  LYS TRP LYS CSU VAL ILE LEU CSU HIS LEU THR HIS GLY          
SEQRES   3 C  107  LYS LYS ARG THR SER GLU LEU LYS ARG LEU MSE PRO ASN          
SEQRES   4 C  107  ILE THR GLN LYS MSE LEU THR GLN GLN LEU ARG GLU LEU          
SEQRES   5 C  107  GLU ALA ASP GLY VAL ILE ASN ARG ILE VAL TYR ASN GLN          
SEQRES   6 C  107  VAL PRO PRO LYS VAL GLU TYR GLU LEU SER GLU TYR GLY          
SEQRES   7 C  107  ARG SER LEU GLU GLY ILE LEU ASP MSE LEU CSU ALA TRP          
SEQRES   8 C  107  GLY ALA ASN HIS ILE ASN ARG VAL GLU GLY HIS HIS HIS          
SEQRES   9 C  107  HIS HIS HIS                                                  
SEQRES   1 D  107  MSE SER LEU VAL GLU ALA THR LEU GLU VAL ILE GLY GLY          
SEQRES   2 D  107  LYS TRP LYS CSU VAL ILE LEU CSU HIS LEU THR HIS GLY          
SEQRES   3 D  107  LYS LYS ARG THR SER GLU LEU LYS ARG LEU MSE PRO ASN          
SEQRES   4 D  107  ILE THR GLN LYS MSE LEU THR GLN GLN LEU ARG GLU LEU          
SEQRES   5 D  107  GLU ALA ASP GLY VAL ILE ASN ARG ILE VAL TYR ASN GLN          
SEQRES   6 D  107  VAL PRO PRO LYS VAL GLU TYR GLU LEU SER GLU TYR GLY          
SEQRES   7 D  107  ARG SER LEU GLU GLY ILE LEU ASP MSE LEU CSU ALA TRP          
SEQRES   8 D  107  GLY ALA ASN HIS ILE ASN ARG VAL GLU GLY HIS HIS HIS          
SEQRES   9 D  107  HIS HIS HIS                                                  
HET    MSE  A   1       8                                                       
HET    CSU  A  17      10                                                       
HET    CSU  A  21      10                                                       
HET    MSE  A  37       8                                                       
HET    MSE  A  44       8                                                       
HET    MSE  A  87      11                                                       
HET    CSU  A  89       6                                                       
HET    MSE  B   1       8                                                       
HET    CSU  B  17      10                                                       
HET    CSU  B  21      10                                                       
HET    MSE  B  37       8                                                       
HET    MSE  B  44      10                                                       
HET    MSE  B  87       8                                                       
HET    CSU  B  89      10                                                       
HET    MSE  C   1       8                                                       
HET    CSU  C  17      10                                                       
HET    CSU  C  21      10                                                       
HET    MSE  C  37       8                                                       
HET    MSE  C  44       8                                                       
HET    MSE  C  87       8                                                       
HET    CSU  C  89       6                                                       
HET    MSE  D   1       8                                                       
HET    CSU  D  17      10                                                       
HET    CSU  D  21      10                                                       
HET    MSE  D  37       8                                                       
HET    MSE  D  44       8                                                       
HET    MSE  D  87       8                                                       
HET    CSU  D  89      10                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     CSU CYSTEINE-S-SULFONIC ACID                                         
FORMUL   1  MSE    16(C5 H11 N O2 SE)                                           
FORMUL   1  CSU    12(C3 H7 N O5 S2)                                            
FORMUL   5  HOH   *240(H2 O)                                                    
CRYST1   45.273   45.521  230.276  90.00  90.00  90.00 P 21 21 21   16          
HETATM    1  N   MSE A   1     -11.161  20.677  12.218  1.00 35.23           N  
HETATM    2  CA  MSE A   1      -9.763  20.947  11.773  1.00 33.22           C  
HETATM    3  C   MSE A   1      -9.365  22.406  12.001  1.00 30.11           C  
HETATM    4  O   MSE A   1     -10.221  23.271  12.189  1.00 27.14           O  
HETATM    5  CB  MSE A   1      -9.614  20.598  10.289  1.00 39.03           C  
HETATM    6  CG  MSE A   1     -10.643  21.252   9.388  1.00 44.47           C  
HETATM    7 SE   MSE A   1     -10.384  20.780   7.528  1.00 56.86          SE  
HETATM    8  CE  MSE A   1     -10.728  18.875   7.622  1.00 52.19           C  
ATOM      9  N   SER A   2      -8.060  22.672  11.977  1.00 24.31           N  
ATOM     10  CA  SER A   2      -7.549  24.023  12.186  1.00 21.45           C  
ATOM     11  C   SER A   2      -7.878  24.916  10.994  1.00 19.58           C  
ATOM     12  O   SER A   2      -8.372  24.442   9.966  1.00 19.45           O  
ATOM     13  CB  SER A   2      -6.027  23.992  12.401  1.00 21.79           C  
ATOM     14  OG  SER A   2      -5.349  23.544  11.233  1.00 18.98           O  
ATOM     15  N   LEU A   3      -7.609  26.208  11.135  1.00 16.92           N  
ATOM     16  CA  LEU A   3      -7.876  27.152  10.063  1.00 17.95           C  
ATOM     17  C   LEU A   3      -6.958  26.859   8.862  1.00 17.13           C  
ATOM     18  O   LEU A   3      -7.421  26.828   7.719  1.00 15.72           O  
ATOM     19  CB  LEU A   3      -7.654  28.590  10.549  1.00 19.33           C  
ATOM     20  CG  LEU A   3      -8.430  29.032  11.801  1.00 20.62           C  
ATOM     21  CD1 LEU A   3      -8.188  30.515  12.038  1.00 19.85           C  
ATOM     22  CD2 LEU A   3      -9.918  28.760  11.628  1.00 17.69           C  
ATOM     23  N   VAL A   4      -5.666  26.648   9.113  1.00 16.74           N  
ATOM     24  CA  VAL A   4      -4.745  26.360   8.005  1.00 18.00           C  
ATOM     25  C   VAL A   4      -5.179  25.101   7.272  1.00 16.38           C  
ATOM     26  O   VAL A   4      -5.165  25.059   6.045  1.00 16.85           O  
ATOM     27  CB  VAL A   4      -3.284  26.157   8.469  1.00 19.62           C  
ATOM     28  CG1 VAL A   4      -2.721  27.451   8.970  1.00 23.13           C  
ATOM     29  CG2 VAL A   4      -3.214  25.086   9.546  1.00 24.64           C  
ATOM     30  N   GLU A   5      -5.561  24.074   8.020  1.00 16.30           N  
ATOM     31  CA  GLU A   5      -6.005  22.834   7.399  1.00 18.77           C  
ATOM     32  C   GLU A   5      -7.213  23.071   6.493  1.00 19.70           C  
ATOM     33  O   GLU A   5      -7.282  22.516   5.396  1.00 19.56           O  
ATOM     34  CB  GLU A   5      -6.322  21.784   8.467  1.00 20.09           C  
ATOM     35  CG  GLU A   5      -5.070  21.229   9.137  1.00 24.56           C  
ATOM     36  CD  GLU A   5      -5.367  20.444  10.409  1.00 28.82           C  
ATOM     37  OE1 GLU A   5      -6.018  21.003  11.317  1.00 29.74           O  
ATOM     38  OE2 GLU A   5      -4.941  19.273  10.504  1.00 30.58           O  
ATOM     39  N   ALA A   6      -8.157  23.901   6.937  1.00 18.54           N  
ATOM     40  CA  ALA A   6      -9.331  24.189   6.118  1.00 16.82           C  
ATOM     41  C   ALA A   6      -8.896  24.744   4.755  1.00 16.27           C  
ATOM     42  O   ALA A   6      -9.377  24.304   3.709  1.00 16.13           O  
ATOM     43  CB  ALA A   6     -10.247  25.186   6.831  1.00 15.70           C  
ATOM     44  N   THR A   7      -7.973  25.699   4.771  1.00 16.36           N  
ATOM     45  CA  THR A   7      -7.474  26.299   3.537  1.00 15.53           C  
ATOM     46  C   THR A   7      -6.750  25.268   2.655  1.00 17.35           C  
ATOM     47  O   THR A   7      -6.961  25.233   1.434  1.00 14.63           O  
ATOM     48  CB  THR A   7      -6.526  27.467   3.845  1.00 16.37           C  
ATOM     49  OG1 THR A   7      -7.252  28.489   4.546  1.00 14.69           O  
ATOM     50  CG2 THR A   7      -5.954  28.059   2.551  1.00 15.70           C  
ATOM     51  N   LEU A   8      -5.917  24.424   3.268  1.00 15.36           N  
ATOM     52  CA  LEU A   8      -5.189  23.397   2.515  1.00 17.68           C  
ATOM     53  C   LEU A   8      -6.117  22.345   1.917  1.00 17.35           C  
ATOM     54  O   LEU A   8      -5.770  21.697   0.928  1.00 17.25           O  
ATOM     55  CB  LEU A   8      -4.142  22.716   3.402  1.00 17.60           C  
ATOM     56  CG  LEU A   8      -3.036  23.647   3.908  1.00 22.29           C  
ATOM     57  CD1 LEU A   8      -2.028  22.848   4.720  1.00 22.44           C  
ATOM     58  CD2 LEU A   8      -2.353  24.324   2.733  1.00 24.06           C  
ATOM     59  N   GLU A   9      -7.291  22.155   2.516  1.00 19.06           N  
ATOM     60  CA  GLU A   9      -8.250  21.197   1.964  1.00 20.14           C  
ATOM     61  C   GLU A   9      -8.659  21.706   0.584  1.00 19.63           C  
ATOM     62  O   GLU A   9      -8.907  20.925  -0.339  1.00 19.18           O  
ATOM     63  CB  GLU A   9      -9.503  21.090   2.843  1.00 24.15           C  
ATOM     64  CG  GLU A   9      -9.334  20.258   4.103  1.00 30.10           C  
ATOM     65  CD  GLU A   9      -9.115  18.776   3.816  1.00 33.70           C  
ATOM     66  OE1 GLU A   9     -10.003  18.143   3.202  1.00 35.46           O  
ATOM     67  OE2 GLU A   9      -8.054  18.245   4.210  1.00 36.49           O  
ATOM     68  N   VAL A  10      -8.707  23.029   0.443  1.00 18.21           N  
ATOM     69  CA  VAL A  10      -9.101  23.640  -0.817  1.00 18.52           C  
ATOM     70  C   VAL A  10      -7.962  23.833  -1.817  1.00 20.52           C  
ATOM     71  O   VAL A  10      -8.144  23.614  -3.016  1.00 21.55           O  
ATOM     72  CB  VAL A  10      -9.765  25.023  -0.583  1.00 19.70           C  
ATOM     73  CG1 VAL A  10     -10.206  25.634  -1.917  1.00 17.92           C  
ATOM     74  CG2 VAL A  10     -10.953  24.871   0.347  1.00 17.80           C  
ATOM     75  N   ILE A  11      -6.790  24.228  -1.329  1.00 20.01           N  
ATOM     76  CA  ILE A  11      -5.667  24.494  -2.218  1.00 20.87           C  
ATOM     77  C   ILE A  11      -4.423  23.612  -2.059  1.00 21.72           C  
ATOM     78  O   ILE A  11      -3.468  23.757  -2.821  1.00 24.33           O  
ATOM     79  CB  ILE A  11      -5.218  25.961  -2.080  1.00 21.57           C  
ATOM     80  CG1 ILE A  11      -4.661  26.195  -0.668  1.00 19.91           C  
ATOM     81  CG2 ILE A  11      -6.403  26.903  -2.337  1.00 22.54           C  
ATOM     82  CD1 ILE A  11      -4.013  27.546  -0.488  1.00 23.05           C  
ATOM     83  N   GLY A  12      -4.431  22.706  -1.088  1.00 22.58           N  
ATOM     84  CA  GLY A  12      -3.269  21.857  -0.865  1.00 24.48           C  
ATOM     85  C   GLY A  12      -3.103  20.644  -1.767  1.00 25.01           C  
ATOM     86  O   GLY A  12      -1.989  20.140  -1.924  1.00 25.62           O  
ATOM     87  N   GLY A  13      -4.198  20.164  -2.348  1.00 25.95           N  
ATOM     88  CA  GLY A  13      -4.125  19.008  -3.227  1.00 27.38           C  
ATOM     89  C   GLY A  13      -3.141  19.250  -4.355  1.00 27.45           C  
ATOM     90  O   GLY A  13      -2.971  20.383  -4.798  1.00 27.35           O  
ATOM     91  N   LYS A  14      -2.487  18.196  -4.831  1.00 28.94           N  
ATOM     92  CA  LYS A  14      -1.510  18.368  -5.902  1.00 28.30           C  
ATOM     93  C   LYS A  14      -2.117  18.988  -7.158  1.00 27.33           C  
ATOM     94  O   LYS A  14      -3.173  18.553  -7.629  1.00 27.77           O  
ATOM     95  CB  LYS A  14      -0.846  17.030  -6.251  1.00 31.37           C  
ATOM     96  CG  LYS A  14       0.272  17.153  -7.291  1.00 34.39           C  
ATOM     97  CD  LYS A  14       1.220  18.317  -6.974  1.00 36.36           C  
ATOM     98  CE  LYS A  14       2.377  18.387  -7.961  1.00 37.06           C  
ATOM     99  NZ  LYS A  14       3.263  17.191  -7.850  1.00 35.71           N  
ATOM    100  N   TRP A  15      -1.442  20.014  -7.677  1.00 24.88           N  
ATOM    101  CA  TRP A  15      -1.857  20.725  -8.882  1.00 24.31           C  
ATOM    102  C   TRP A  15      -2.909  21.807  -8.673  1.00 22.29           C  
ATOM    103  O   TRP A  15      -3.009  22.729  -9.479  1.00 21.15           O  
ATOM    104  CB  TRP A  15      -2.390  19.747  -9.934  1.00 24.36           C  
ATOM    105  CG  TRP A  15      -1.437  18.660 -10.284  1.00 28.08           C  
ATOM    106  CD1 TRP A  15      -1.577  17.327 -10.024  1.00 28.41           C  
ATOM    107  CD2 TRP A  15      -0.190  18.809 -10.965  1.00 27.99           C  
ATOM    108  NE1 TRP A  15      -0.491  16.636 -10.503  1.00 30.34           N  
ATOM    109  CE2 TRP A  15       0.374  17.524 -11.086  1.00 29.24           C  
ATOM    110  CE3 TRP A  15       0.506  19.909 -11.485  1.00 29.85           C  
ATOM    111  CZ2 TRP A  15       1.606  17.306 -11.708  1.00 30.50           C  
ATOM    112  CZ3 TRP A  15       1.732  19.689 -12.104  1.00 31.93           C  
ATOM    113  CH2 TRP A  15       2.266  18.397 -12.209  1.00 30.66           C  
ATOM    114  N   LYS A  16      -3.697  21.698  -7.605  1.00 21.86           N  
ATOM    115  CA  LYS A  16      -4.758  22.675  -7.368  1.00 20.74           C  
ATOM    116  C   LYS A  16      -4.323  24.130  -7.462  1.00 19.78           C  
ATOM    117  O   LYS A  16      -4.945  24.931  -8.162  1.00 18.74           O  
ATOM    118  CB  LYS A  16      -5.434  22.418  -6.018  1.00 21.62           C  
ATOM    119  CG  LYS A  16      -6.402  21.237  -6.057  1.00 25.44           C  
ATOM    120  CD  LYS A  16      -7.127  21.055  -4.742  1.00 26.75           C  
ATOM    121  CE  LYS A  16      -8.069  19.869  -4.801  1.00 27.82           C  
ATOM    122  NZ  LYS A  16      -8.788  19.680  -3.517  1.00 26.43           N  
HETATM  123  N   CSU A  17      -3.247  24.479  -6.770  1.00 19.20           N  
HETATM  124  CA  CSU A  17      -2.778  25.851  -6.802  1.00 19.06           C  
HETATM  125  CB  CSU A  17      -1.682  26.058  -5.763  1.00 22.67           C  
HETATM  126  SG  CSU A  17      -1.336  27.785  -5.471  1.00 28.40           S  
HETATM  127  S   CSU A  17      -3.019  28.713  -4.780  1.00 20.97           S  
HETATM  128  C   CSU A  17      -2.267  26.260  -8.187  1.00 19.70           C  
HETATM  129  O   CSU A  17      -2.409  27.418  -8.591  1.00 19.67           O  
HETATM  130  OD1 CSU A  17      -2.643  29.956  -4.103  1.00 32.18           O  
HETATM  131  OD2 CSU A  17      -3.692  27.825  -3.839  1.00 32.91           O  
HETATM  132  OD3 CSU A  17      -3.907  29.016  -5.897  1.00 31.34           O  
ATOM    133  N   VAL A  18      -1.656  25.322  -8.907  1.00 16.67           N  
ATOM    134  CA  VAL A  18      -1.145  25.621 -10.240  1.00 17.21           C  
ATOM    135  C   VAL A  18      -2.324  25.845 -11.177  1.00 15.92           C  
ATOM    136  O   VAL A  18      -2.305  26.756 -11.999  1.00 17.16           O  
ATOM    137  CB  VAL A  18      -0.259  24.466 -10.794  1.00 17.32           C  
ATOM    138  CG1 VAL A  18       0.125  24.744 -12.247  1.00 19.29           C  
ATOM    139  CG2 VAL A  18       0.988  24.323  -9.948  1.00 16.61           C  
ATOM    140  N   ILE A  19      -3.348  25.006 -11.050  1.00 17.34           N  
ATOM    141  CA  ILE A  19      -4.541  25.138 -11.885  1.00 18.74           C  
ATOM    142  C   ILE A  19      -5.111  26.542 -11.711  1.00 19.25           C  
ATOM    143  O   ILE A  19      -5.324  27.262 -12.683  1.00 19.31           O  
ATOM    144  CB  ILE A  19      -5.611  24.090 -11.495  1.00 17.88           C  
ATOM    145  CG1 ILE A  19      -5.114  22.689 -11.861  1.00 19.74           C  
ATOM    146  CG2 ILE A  19      -6.933  24.392 -12.202  1.00 15.67           C  
ATOM    147  CD1 ILE A  19      -6.004  21.571 -11.371  1.00 18.31           C  
ATOM    148  N   LEU A  20      -5.348  26.934 -10.462  1.00 20.99           N  
ATOM    149  CA  LEU A  20      -5.881  28.259 -10.177  1.00 22.00           C  
ATOM    150  C   LEU A  20      -4.958  29.316 -10.759  1.00 23.68           C  
ATOM    151  O   LEU A  20      -5.420  30.330 -11.289  1.00 21.97           O  
ATOM    152  CB  LEU A  20      -6.034  28.459  -8.667  1.00 22.85           C  
ATOM    153  CG  LEU A  20      -7.087  27.528  -8.055  1.00 25.13           C  
ATOM    154  CD1 LEU A  20      -7.136  27.680  -6.538  1.00 24.07           C  
ATOM    155  CD2 LEU A  20      -8.439  27.851  -8.671  1.00 24.36           C  
HETATM  156  N   CSU A  21      -3.654  29.076 -10.667  1.00 22.42           N  
HETATM  157  CA  CSU A  21      -2.682  30.012 -11.212  1.00 24.63           C  
HETATM  158  CB  CSU A  21      -1.262  29.499 -10.961  1.00 26.40           C  
HETATM  159  SG  CSU A  21       0.029  30.571 -11.591  1.00 32.61           S  
HETATM  160  S   CSU A  21       0.775  29.758 -13.302  1.00 31.93           S  
HETATM  161  C   CSU A  21      -2.922  30.194 -12.714  1.00 23.60           C  
HETATM  162  O   CSU A  21      -3.022  31.318 -13.205  1.00 25.22           O  
HETATM  163  OD1 CSU A  21       1.374  30.816 -14.123  1.00 35.94           O  
HETATM  164  OD2 CSU A  21      -0.275  29.093 -14.045  1.00 31.30           O  
HETATM  165  OD3 CSU A  21       1.812  28.765 -12.940  1.00 37.58           O  
ATOM    166  N   HIS A  22      -3.028  29.088 -13.444  1.00 23.01           N  
ATOM    167  CA  HIS A  22      -3.263  29.163 -14.884  1.00 23.83           C  
ATOM    168  C   HIS A  22      -4.572  29.866 -15.211  1.00 23.61           C  
ATOM    169  O   HIS A  22      -4.650  30.615 -16.182  1.00 24.55           O  
ATOM    170  CB  HIS A  22      -3.260  27.764 -15.514  1.00 23.22           C  
ATOM    171  CG  HIS A  22      -1.892  27.177 -15.656  1.00 24.98           C  
ATOM    172  ND1 HIS A  22      -0.885  27.800 -16.367  1.00 25.00           N  
ATOM    173  CD2 HIS A  22      -1.343  26.045 -15.150  1.00 24.27           C  
ATOM    174  CE1 HIS A  22       0.219  27.082 -16.288  1.00 24.50           C  
ATOM    175  NE2 HIS A  22      -0.033  26.010 -15.554  1.00 25.09           N  
ATOM    176  N   LEU A  23      -5.594  29.624 -14.394  1.00 23.61           N  
ATOM    177  CA  LEU A  23      -6.899  30.236 -14.608  1.00 25.05           C  
ATOM    178  C   LEU A  23      -6.946  31.741 -14.342  1.00 27.17           C  
ATOM    179  O   LEU A  23      -7.931  32.392 -14.679  1.00 28.16           O  
ATOM    180  CB  LEU A  23      -7.960  29.532 -13.759  1.00 22.57           C  
ATOM    181  CG  LEU A  23      -8.248  28.070 -14.110  1.00 21.78           C  
ATOM    182  CD1 LEU A  23      -9.336  27.530 -13.206  1.00 23.40           C  
ATOM    183  CD2 LEU A  23      -8.660  27.962 -15.572  1.00 23.55           C  
ATOM    184  N   THR A  24      -5.898  32.301 -13.740  1.00 29.15           N  
ATOM    185  CA  THR A  24      -5.893  33.737 -13.476  1.00 31.57           C  
ATOM    186  C   THR A  24      -5.733  34.488 -14.789  1.00 33.87           C  
ATOM    187  O   THR A  24      -5.920  35.702 -14.851  1.00 35.42           O  
ATOM    188  CB  THR A  24      -4.742  34.165 -12.549  1.00 30.85           C  
ATOM    189  OG1 THR A  24      -3.493  34.007 -13.233  1.00 31.01           O  
ATOM    190  CG2 THR A  24      -4.744  33.339 -11.265  1.00 30.51           C  
ATOM    191  N   HIS A  25      -5.378  33.759 -15.839  1.00 35.79           N  
ATOM    192  CA  HIS A  25      -5.200  34.371 -17.150  1.00 37.50           C  
ATOM    193  C   HIS A  25      -6.496  34.350 -17.956  1.00 36.77           C  
ATOM    194  O   HIS A  25      -6.630  35.075 -18.938  1.00 37.40           O  
ATOM    195  CB  HIS A  25      -4.094  33.647 -17.926  1.00 38.89           C  
ATOM    196  CG  HIS A  25      -2.739  33.759 -17.294  1.00 40.77           C  
ATOM    197  ND1 HIS A  25      -1.608  33.212 -17.858  1.00 41.09           N  
ATOM    198  CD2 HIS A  25      -2.334  34.370 -16.154  1.00 41.02           C  
ATOM    199  CE1 HIS A  25      -0.561  33.484 -17.094  1.00 40.87           C  
ATOM    200  NE2 HIS A  25      -0.976  34.184 -16.056  1.00 41.77           N  
ATOM    201  N   GLY A  26      -7.447  33.521 -17.536  1.00 35.23           N  
ATOM    202  CA  GLY A  26      -8.713  33.437 -18.242  1.00 34.24           C  
ATOM    203  C   GLY A  26      -9.280  32.030 -18.255  1.00 33.99           C  
ATOM    204  O   GLY A  26      -8.612  31.077 -17.856  1.00 33.81           O  
ATOM    205  N   LYS A  27     -10.518  31.899 -18.713  1.00 33.38           N  
ATOM    206  CA  LYS A  27     -11.170  30.599 -18.773  1.00 32.18           C  
ATOM    207  C   LYS A  27     -10.409  29.660 -19.707  1.00 31.52           C  
ATOM    208  O   LYS A  27      -9.748  30.113 -20.642  1.00 30.33           O  
ATOM    209  CB  LYS A  27     -12.616  30.768 -19.251  1.00 34.67           C  
ATOM    210  CG  LYS A  27     -12.752  31.464 -20.595  1.00 37.14           C  
ATOM    211  CD  LYS A  27     -14.206  31.825 -20.883  1.00 40.77           C  
ATOM    212  CE  LYS A  27     -14.358  32.470 -22.255  1.00 41.33           C  
ATOM    213  NZ  LYS A  27     -13.968  31.544 -23.359  1.00 42.85           N  
ATOM    214  N   LYS A  28     -10.497  28.358 -19.445  1.00 28.65           N  
ATOM    215  CA  LYS A  28      -9.818  27.354 -20.261  1.00 28.76           C  
ATOM    216  C   LYS A  28     -10.531  26.010 -20.150  1.00 28.65           C  
ATOM    217  O   LYS A  28     -11.167  25.724 -19.137  1.00 27.60           O  
ATOM    218  CB  LYS A  28      -8.362  27.197 -19.795  1.00 29.48           C  
ATOM    219  CG  LYS A  28      -7.578  28.500 -19.805  1.00 31.20           C  
ATOM    220  CD  LYS A  28      -6.155  28.359 -19.307  1.00 30.72           C  
ATOM    221  CE  LYS A  28      -5.422  29.683 -19.491  1.00 32.62           C  
ATOM    222  NZ  LYS A  28      -4.037  29.662 -18.949  1.00 34.76           N  
ATOM    223  N   ARG A  29     -10.445  25.185 -21.190  1.00 28.26           N  
ATOM    224  CA  ARG A  29     -11.073  23.868 -21.125  1.00 29.32           C  
ATOM    225  C   ARG A  29     -10.007  22.872 -20.685  1.00 27.49           C  
ATOM    226  O   ARG A  29      -8.830  23.206 -20.663  1.00 26.11           O  
ATOM    227  CB  ARG A  29     -11.685  23.475 -22.485  1.00 32.05           C  
ATOM    228  CG  ARG A  29     -10.783  23.658 -23.691  1.00 35.26           C  
ATOM    229  CD  ARG A  29     -11.590  23.614 -24.993  1.00 38.41           C  
ATOM    230  NE  ARG A  29     -12.219  22.311 -25.209  1.00 41.16           N  
ATOM    231  CZ  ARG A  29     -12.968  22.002 -26.263  1.00 41.31           C  
ATOM    232  NH1 ARG A  29     -13.193  22.904 -27.211  1.00 42.17           N  
ATOM    233  NH2 ARG A  29     -13.489  20.786 -26.373  1.00 40.43           N  
ATOM    234  N   THR A  30     -10.413  21.662 -20.317  1.00 28.51           N  
ATOM    235  CA  THR A  30      -9.454  20.656 -19.864  1.00 30.20           C  
ATOM    236  C   THR A  30      -8.273  20.434 -20.813  1.00 31.01           C  
ATOM    237  O   THR A  30      -7.137  20.276 -20.367  1.00 30.19           O  
ATOM    238  CB  THR A  30     -10.144  19.298 -19.601  1.00 31.14           C  
ATOM    239  OG1 THR A  30     -10.839  18.871 -20.778  1.00 33.00           O  
ATOM    240  CG2 THR A  30     -11.132  19.417 -18.445  1.00 31.15           C  
ATOM    241  N   SER A  31      -8.533  20.436 -22.117  1.00 31.99           N  
ATOM    242  CA  SER A  31      -7.477  20.218 -23.104  1.00 31.75           C  
ATOM    243  C   SER A  31      -6.354  21.249 -23.004  1.00 31.34           C  
ATOM    244  O   SER A  31      -5.175  20.896 -23.044  1.00 31.16           O  
ATOM    245  CB  SER A  31      -8.061  20.223 -24.523  1.00 32.88           C  
ATOM    246  OG  SER A  31      -8.516  21.513 -24.895  1.00 33.92           O  
ATOM    247  N   GLU A  32      -6.713  22.522 -22.867  1.00 30.12           N  
ATOM    248  CA  GLU A  32      -5.708  23.574 -22.759  1.00 29.87           C  
ATOM    249  C   GLU A  32      -4.894  23.379 -21.478  1.00 28.86           C  
ATOM    250  O   GLU A  32      -3.661  23.411 -21.499  1.00 29.25           O  
ATOM    251  CB  GLU A  32      -6.380  24.950 -22.726  1.00 32.23           C  
ATOM    252  CG  GLU A  32      -7.371  25.194 -23.851  1.00 36.29           C  
ATOM    253  CD  GLU A  32      -8.243  26.417 -23.599  1.00 37.34           C  
ATOM    254  OE1 GLU A  32      -7.700  27.539 -23.522  1.00 38.66           O  
ATOM    255  OE2 GLU A  32      -9.472  26.247 -23.473  1.00 36.85           O  
ATOM    256  N   LEU A  33      -5.591  23.181 -20.363  1.00 26.61           N  
ATOM    257  CA  LEU A  33      -4.926  22.985 -19.080  1.00 25.83           C  
ATOM    258  C   LEU A  33      -3.926  21.836 -19.170  1.00 26.76           C  
ATOM    259  O   LEU A  33      -2.871  21.867 -18.532  1.00 26.18           O  
ATOM    260  CB  LEU A  33      -5.964  22.714 -17.984  1.00 24.33           C  
ATOM    261  CG  LEU A  33      -6.874  23.892 -17.606  1.00 22.19           C  
ATOM    262  CD1 LEU A  33      -7.885  23.430 -16.560  1.00 23.55           C  
ATOM    263  CD2 LEU A  33      -6.042  25.040 -17.049  1.00 23.77           C  
ATOM    264  N   LYS A  34      -4.265  20.829 -19.971  1.00 26.34           N  
ATOM    265  CA  LYS A  34      -3.389  19.681 -20.185  1.00 28.86           C  
ATOM    266  C   LYS A  34      -2.075  20.123 -20.832  1.00 27.96           C  
ATOM    267  O   LYS A  34      -0.993  19.672 -20.446  1.00 28.22           O  
ATOM    268  CB  LYS A  34      -4.082  18.654 -21.083  1.00 29.02           C  
ATOM    269  CG  LYS A  34      -4.938  17.649 -20.341  1.00 30.34           C  
ATOM    270  CD  LYS A  34      -4.080  16.612 -19.635  1.00 31.55           C  
ATOM    271  CE  LYS A  34      -3.193  15.872 -20.632  1.00 31.55           C  
ATOM    272  NZ  LYS A  34      -2.369  14.795 -20.004  1.00 33.04           N  
ATOM    273  N   ARG A  35      -2.181  21.010 -21.816  1.00 28.27           N  
ATOM    274  CA  ARG A  35      -1.018  21.530 -22.531  1.00 29.37           C  
ATOM    275  C   ARG A  35      -0.133  22.381 -21.622  1.00 28.10           C  
ATOM    276  O   ARG A  35       1.090  22.383 -21.759  1.00 26.90           O  
ATOM    277  CB  ARG A  35      -1.462  22.395 -23.717  1.00 31.65           C  
ATOM    278  CG  ARG A  35      -2.292  21.685 -24.778  1.00 37.09           C  
ATOM    279  CD  ARG A  35      -1.472  20.670 -25.559  1.00 40.87           C  
ATOM    280  NE  ARG A  35      -2.263  20.000 -26.591  1.00 43.28           N  
ATOM    281  CZ  ARG A  35      -1.863  18.923 -27.262  1.00 44.32           C  
ATOM    282  NH1 ARG A  35      -0.674  18.389 -27.011  1.00 43.28           N  
ATOM    283  NH2 ARG A  35      -2.655  18.378 -28.177  1.00 44.00           N  
ATOM    284  N   LEU A  36      -0.756  23.112 -20.703  1.00 26.11           N  
ATOM    285  CA  LEU A  36      -0.023  23.979 -19.791  1.00 25.56           C  
ATOM    286  C   LEU A  36       0.608  23.220 -18.631  1.00 23.44           C  
ATOM    287  O   LEU A  36       1.579  23.682 -18.034  1.00 24.09           O  
ATOM    288  CB  LEU A  36      -0.954  25.069 -19.250  1.00 27.80           C  
ATOM    289  CG  LEU A  36      -1.464  26.104 -20.259  1.00 31.01           C  
ATOM    290  CD1 LEU A  36      -2.558  26.958 -19.617  1.00 29.92           C  
ATOM    291  CD2 LEU A  36      -0.313  26.972 -20.735  1.00 31.25           C  
HETATM  292  N   MSE A  37       0.050  22.056 -18.320  1.00 21.67           N  
HETATM  293  CA  MSE A  37       0.531  21.215 -17.227  1.00 22.12           C  
HETATM  294  C   MSE A  37       0.767  19.825 -17.809  1.00 22.71           C  
HETATM  295  O   MSE A  37      -0.004  18.889 -17.572  1.00 20.42           O  
HETATM  296  CB  MSE A  37      -0.521  21.175 -16.119  1.00 23.88           C  
HETATM  297  CG  MSE A  37      -0.957  22.569 -15.672  1.00 25.68           C  
HETATM  298 SE   MSE A  37      -2.444  22.525 -14.426  1.00 36.94          SE  
HETATM  299  CE  MSE A  37      -3.848  22.239 -15.696  1.00 30.61           C  
ATOM    300  N   PRO A  38       1.859  19.676 -18.578  1.00 22.73           N  
ATOM    301  CA  PRO A  38       2.270  18.441 -19.247  1.00 24.75           C  
ATOM    302  C   PRO A  38       2.502  17.222 -18.373  1.00 25.29           C  
ATOM    303  O   PRO A  38       2.634  16.113 -18.882  1.00 27.13           O  
ATOM    304  CB  PRO A  38       3.529  18.866 -20.001  1.00 24.73           C  
ATOM    305  CG  PRO A  38       4.123  19.886 -19.090  1.00 25.11           C  
ATOM    306  CD  PRO A  38       2.905  20.706 -18.715  1.00 23.51           C  
ATOM    307  N   ASN A  39       2.548  17.404 -17.063  1.00 26.60           N  
ATOM    308  CA  ASN A  39       2.778  16.260 -16.199  1.00 28.00           C  
ATOM    309  C   ASN A  39       1.559  15.731 -15.457  1.00 27.80           C  
ATOM    310  O   ASN A  39       1.636  14.696 -14.796  1.00 29.32           O  
ATOM    311  CB  ASN A  39       3.911  16.573 -15.222  1.00 28.89           C  
ATOM    312  CG  ASN A  39       5.247  16.703 -15.926  1.00 30.07           C  
ATOM    313  OD1 ASN A  39       5.729  15.748 -16.534  1.00 30.41           O  
ATOM    314  ND2 ASN A  39       5.844  17.889 -15.865  1.00 31.95           N  
ATOM    315  N   ILE A  40       0.427  16.416 -15.570  1.00 27.66           N  
ATOM    316  CA  ILE A  40      -0.773  15.947 -14.883  1.00 26.94           C  
ATOM    317  C   ILE A  40      -1.552  14.959 -15.755  1.00 28.17           C  
ATOM    318  O   ILE A  40      -1.662  15.152 -16.966  1.00 27.82           O  
ATOM    319  CB  ILE A  40      -1.705  17.125 -14.494  1.00 25.09           C  
ATOM    320  CG1 ILE A  40      -2.731  16.648 -13.468  1.00 24.30           C  
ATOM    321  CG2 ILE A  40      -2.406  17.686 -15.735  1.00 23.17           C  
ATOM    322  CD1 ILE A  40      -3.600  17.759 -12.915  1.00 26.18           C  
ATOM    323  N   THR A  41      -2.072  13.897 -15.139  1.00 28.92           N  
ATOM    324  CA  THR A  41      -2.848  12.892 -15.867  1.00 31.25           C  
ATOM    325  C   THR A  41      -4.287  13.374 -16.049  1.00 32.29           C  
ATOM    326  O   THR A  41      -4.780  14.202 -15.278  1.00 30.75           O  
ATOM    327  CB  THR A  41      -2.885  11.532 -15.121  1.00 31.86           C  
ATOM    328  OG1 THR A  41      -3.600  11.674 -13.887  1.00 31.71           O  
ATOM    329  CG2 THR A  41      -1.473  11.038 -14.832  1.00 34.17           C  
ATOM    330  N   GLN A  42      -4.955  12.848 -17.070  1.00 32.58           N  
ATOM    331  CA  GLN A  42      -6.334  13.218 -17.361  1.00 34.18           C  
ATOM    332  C   GLN A  42      -7.242  12.959 -16.167  1.00 33.65           C  
ATOM    333  O   GLN A  42      -8.097  13.783 -15.843  1.00 33.36           O  
ATOM    334  CB  GLN A  42      -6.850  12.434 -18.571  1.00 35.80           C  
ATOM    335  CG  GLN A  42      -8.286  12.761 -18.960  1.00 36.36           C  
ATOM    336  CD  GLN A  42      -8.499  14.241 -19.238  1.00 38.34           C  
ATOM    337  OE1 GLN A  42      -7.741  14.863 -19.985  1.00 37.82           O  
ATOM    338  NE2 GLN A  42      -9.543  14.810 -18.642  1.00 38.29           N  
ATOM    339  N   LYS A  43      -7.050  11.814 -15.518  1.00 33.78           N  
ATOM    340  CA  LYS A  43      -7.858  11.443 -14.362  1.00 33.82           C  
ATOM    341  C   LYS A  43      -7.639  12.406 -13.204  1.00 32.64           C  
ATOM    342  O   LYS A  43      -8.596  12.864 -12.585  1.00 31.95           O  
ATOM    343  CB  LYS A  43      -7.524  10.021 -13.900  1.00 35.66           C  
ATOM    344  CG  LYS A  43      -8.408   9.535 -12.755  1.00 38.76           C  
ATOM    345  CD  LYS A  43      -7.985   8.168 -12.225  1.00 40.82           C  
ATOM    346  CE  LYS A  43      -8.887   7.739 -11.072  1.00 43.58           C  
ATOM    347  NZ  LYS A  43      -8.431   6.489 -10.403  1.00 44.51           N  
HETATM  348  N   MSE A  44      -6.376  12.701 -12.913  1.00 31.14           N  
HETATM  349  CA  MSE A  44      -6.030  13.610 -11.826  1.00 32.04           C  
HETATM  350  C   MSE A  44      -6.587  15.016 -12.064  1.00 29.90           C  
HETATM  351  O   MSE A  44      -7.175  15.613 -11.162  1.00 28.56           O  
HETATM  352  CB  MSE A  44      -4.511  13.668 -11.649  1.00 35.18           C  
HETATM  353  CG  MSE A  44      -4.043  14.558 -10.510  1.00 41.00           C  
HETATM  354 SE   MSE A  44      -4.790  14.039  -8.802  1.00 51.41          SE  
HETATM  355  CE  MSE A  44      -3.630  12.539  -8.405  1.00 48.72           C  
ATOM    356  N   LEU A  45      -6.398  15.542 -13.273  1.00 26.39           N  
ATOM    357  CA  LEU A  45      -6.906  16.869 -13.605  1.00 25.64           C  
ATOM    358  C   LEU A  45      -8.412  16.889 -13.371  1.00 26.25           C  
ATOM    359  O   LEU A  45      -8.933  17.776 -12.699  1.00 23.73           O  
ATOM    360  CB  LEU A  45      -6.601  17.220 -15.068  1.00 24.23           C  
ATOM    361  CG  LEU A  45      -7.174  18.520 -15.656  1.00 21.93           C  
ATOM    362  CD1 LEU A  45      -6.850  19.699 -14.761  1.00 22.27           C  
ATOM    363  CD2 LEU A  45      -6.598  18.751 -17.047  1.00 23.42           C  
ATOM    364  N   THR A  46      -9.103  15.899 -13.927  1.00 26.05           N  
ATOM    365  CA  THR A  46     -10.549  15.793 -13.771  1.00 27.56           C  
ATOM    366  C   THR A  46     -10.925  15.803 -12.289  1.00 26.36           C  
ATOM    367  O   THR A  46     -11.831  16.522 -11.878  1.00 25.38           O  
ATOM    368  CB  THR A  46     -11.075  14.500 -14.430  1.00 28.77           C  
ATOM    369  OG1 THR A  46     -10.808  14.546 -15.838  1.00 29.93           O  
ATOM    370  CG2 THR A  46     -12.565  14.350 -14.206  1.00 29.45           C  
ATOM    371  N   GLN A  47     -10.218  15.011 -11.490  1.00 26.73           N  
ATOM    372  CA  GLN A  47     -10.478  14.946 -10.054  1.00 27.36           C  
ATOM    373  C   GLN A  47     -10.336  16.318  -9.385  1.00 26.22           C  
ATOM    374  O   GLN A  47     -11.227  16.762  -8.659  1.00 25.00           O  
ATOM    375  CB  GLN A  47      -9.502  13.970  -9.395  1.00 30.34           C  
ATOM    376  CG  GLN A  47      -9.718  13.767  -7.904  1.00 35.52           C  
ATOM    377  CD  GLN A  47      -8.548  13.055  -7.244  1.00 39.42           C  
ATOM    378  OE1 GLN A  47      -7.543  13.679  -6.888  1.00 42.02           O  
ATOM    379  NE2 GLN A  47      -8.665  11.739  -7.090  1.00 40.30           N  
ATOM    380  N   GLN A  48      -9.212  16.984  -9.631  1.00 24.63           N  
ATOM    381  CA  GLN A  48      -8.954  18.281  -9.022  1.00 23.90           C  
ATOM    382  C   GLN A  48      -9.912  19.389  -9.462  1.00 23.13           C  
ATOM    383  O   GLN A  48     -10.315  20.223  -8.649  1.00 22.52           O  
ATOM    384  CB  GLN A  48      -7.504  18.709  -9.277  1.00 24.59           C  
ATOM    385  CG  GLN A  48      -6.451  17.650  -8.915  1.00 25.58           C  
ATOM    386  CD  GLN A  48      -6.632  17.054  -7.524  1.00 28.95           C  
ATOM    387  OE1 GLN A  48      -7.598  16.331  -7.264  1.00 31.58           O  
ATOM    388  NE2 GLN A  48      -5.697  17.353  -6.623  1.00 28.46           N  
ATOM    389  N   LEU A  49     -10.270  19.414 -10.742  1.00 22.18           N  
ATOM    390  CA  LEU A  49     -11.192  20.436 -11.219  1.00 21.44           C  
ATOM    391  C   LEU A  49     -12.529  20.296 -10.496  1.00 20.82           C  
ATOM    392  O   LEU A  49     -13.180  21.287 -10.175  1.00 20.30           O  
ATOM    393  CB  LEU A  49     -11.386  20.318 -12.732  1.00 20.17           C  
ATOM    394  CG  LEU A  49     -10.197  20.826 -13.553  1.00 21.71           C  
ATOM    395  CD1 LEU A  49     -10.384  20.500 -15.032  1.00 20.30           C  
ATOM    396  CD2 LEU A  49     -10.050  22.333 -13.341  1.00 17.58           C  
ATOM    397  N   ARG A  50     -12.926  19.059 -10.220  1.00 22.65           N  
ATOM    398  CA  ARG A  50     -14.189  18.809  -9.536  1.00 24.49           C  
ATOM    399  C   ARG A  50     -14.150  19.277  -8.085  1.00 23.50           C  
ATOM    400  O   ARG A  50     -15.122  19.836  -7.578  1.00 21.22           O  
ATOM    401  CB  ARG A  50     -14.534  17.321  -9.580  1.00 29.34           C  
ATOM    402  CG  ARG A  50     -14.993  16.841 -10.940  1.00 33.86           C  
ATOM    403  CD  ARG A  50     -15.295  15.352 -10.941  1.00 38.43           C  
ATOM    404  NE  ARG A  50     -14.112  14.547 -10.639  1.00 43.85           N  
ATOM    405  CZ  ARG A  50     -13.950  13.281 -11.013  1.00 45.47           C  
ATOM    406  NH1 ARG A  50     -14.896  12.666 -11.711  1.00 47.30           N  
ATOM    407  NH2 ARG A  50     -12.841  12.629 -10.688  1.00 46.48           N  
ATOM    408  N   GLU A  51     -13.031  19.043  -7.413  1.00 22.71           N  
ATOM    409  CA  GLU A  51     -12.917  19.465  -6.023  1.00 22.68           C  
ATOM    410  C   GLU A  51     -12.892  20.990  -5.962  1.00 20.95           C  
ATOM    411  O   GLU A  51     -13.542  21.593  -5.112  1.00 20.20           O  
ATOM    412  CB  GLU A  51     -11.653  18.880  -5.384  1.00 24.54           C  
ATOM    413  CG  GLU A  51     -11.575  17.360  -5.464  1.00 29.14           C  
ATOM    414  CD  GLU A  51     -10.578  16.766  -4.484  1.00 32.07           C  
ATOM    415  OE1 GLU A  51      -9.445  17.280  -4.385  1.00 34.25           O  
ATOM    416  OE2 GLU A  51     -10.930  15.775  -3.818  1.00 35.57           O  
ATOM    417  N   LEU A  52     -12.148  21.609  -6.871  1.00 20.08           N  
ATOM    418  CA  LEU A  52     -12.055  23.068  -6.908  1.00 19.58           C  
ATOM    419  C   LEU A  52     -13.431  23.702  -7.145  1.00 20.72           C  
ATOM    420  O   LEU A  52     -13.742  24.758  -6.579  1.00 20.83           O  
ATOM    421  CB  LEU A  52     -11.089  23.514  -8.007  1.00 17.61           C  
ATOM    422  CG  LEU A  52      -9.585  23.343  -7.746  1.00 17.11           C  
ATOM    423  CD1 LEU A  52      -8.805  23.555  -9.040  1.00 16.34           C  
ATOM    424  CD2 LEU A  52      -9.141  24.336  -6.682  1.00 14.61           C  
ATOM    425  N   GLU A  53     -14.249  23.065  -7.981  1.00 20.42           N  
ATOM    426  CA  GLU A  53     -15.582  23.593  -8.265  1.00 22.14           C  
ATOM    427  C   GLU A  53     -16.443  23.444  -7.018  1.00 20.15           C  
ATOM    428  O   GLU A  53     -17.149  24.364  -6.634  1.00 21.02           O  
ATOM    429  CB  GLU A  53     -16.242  22.848  -9.434  1.00 22.87           C  
ATOM    430  CG  GLU A  53     -17.633  23.410  -9.792  1.00 27.16           C  
ATOM    431  CD  GLU A  53     -18.360  22.623 -10.881  1.00 29.70           C  
ATOM    432  OE1 GLU A  53     -19.507  22.995 -11.213  1.00 33.74           O  
ATOM    433  OE2 GLU A  53     -17.800  21.640 -11.404  1.00 29.93           O  
ATOM    434  N   ALA A  54     -16.363  22.276  -6.389  1.00 22.22           N  
ATOM    435  CA  ALA A  54     -17.133  21.994  -5.185  1.00 23.16           C  
ATOM    436  C   ALA A  54     -16.804  22.969  -4.061  1.00 23.34           C  
ATOM    437  O   ALA A  54     -17.685  23.339  -3.283  1.00 22.07           O  
ATOM    438  CB  ALA A  54     -16.881  20.556  -4.726  1.00 23.82           C  
ATOM    439  N   ASP A  55     -15.541  23.381  -3.964  1.00 21.95           N  
ATOM    440  CA  ASP A  55     -15.145  24.325  -2.925  1.00 22.76           C  
ATOM    441  C   ASP A  55     -15.458  25.768  -3.315  1.00 21.71           C  
ATOM    442  O   ASP A  55     -15.145  26.702  -2.574  1.00 22.10           O  
ATOM    443  CB  ASP A  55     -13.653  24.182  -2.590  1.00 25.14           C  
ATOM    444  CG  ASP A  55     -13.321  22.835  -1.982  1.00 27.40           C  
ATOM    445  OD1 ASP A  55     -14.224  22.215  -1.385  1.00 30.46           O  
ATOM    446  OD2 ASP A  55     -12.158  22.395  -2.088  1.00 25.88           O  
ATOM    447  N   GLY A  56     -16.052  25.943  -4.491  1.00 21.35           N  
ATOM    448  CA  GLY A  56     -16.443  27.267  -4.951  1.00 20.32           C  
ATOM    449  C   GLY A  56     -15.391  28.232  -5.469  1.00 20.17           C  
ATOM    450  O   GLY A  56     -15.681  29.415  -5.656  1.00 19.25           O  
ATOM    451  N   VAL A  57     -14.182  27.755  -5.735  1.00 18.91           N  
ATOM    452  CA  VAL A  57     -13.137  28.654  -6.210  1.00 15.94           C  
ATOM    453  C   VAL A  57     -13.077  28.771  -7.735  1.00 15.73           C  
ATOM    454  O   VAL A  57     -12.417  29.662  -8.264  1.00 15.07           O  
ATOM    455  CB  VAL A  57     -11.772  28.238  -5.645  1.00 15.69           C  
ATOM    456  CG1 VAL A  57     -11.788  28.402  -4.116  1.00 16.54           C  
ATOM    457  CG2 VAL A  57     -11.472  26.794  -6.011  1.00 14.60           C  
ATOM    458  N   ILE A  58     -13.754  27.867  -8.433  1.00 16.62           N  
ATOM    459  CA  ILE A  58     -13.812  27.928  -9.889  1.00 19.28           C  
ATOM    460  C   ILE A  58     -15.236  27.577 -10.304  1.00 20.51           C  
ATOM    461  O   ILE A  58     -15.926  26.844  -9.604  1.00 20.41           O  
ATOM    462  CB  ILE A  58     -12.844  26.930 -10.585  1.00 19.56           C  
ATOM    463  CG1 ILE A  58     -13.285  25.493 -10.314  1.00 17.35           C  
ATOM    464  CG2 ILE A  58     -11.414  27.165 -10.107  1.00 18.99           C  
ATOM    465  CD1 ILE A  58     -12.521  24.470 -11.122  1.00 20.62           C  
ATOM    466  N   ASN A  59     -15.663  28.110 -11.441  1.00 22.38           N  
ATOM    467  CA  ASN A  59     -16.996  27.854 -11.978  1.00 24.28           C  
ATOM    468  C   ASN A  59     -16.795  27.118 -13.294  1.00 25.52           C  
ATOM    469  O   ASN A  59     -15.856  27.419 -14.025  1.00 24.87           O  
ATOM    470  CB  ASN A  59     -17.705  29.174 -12.264  1.00 24.25           C  
ATOM    471  CG  ASN A  59     -17.985  29.968 -11.012  1.00 25.00           C  
ATOM    472  OD1 ASN A  59     -17.879  31.193 -11.005  1.00 28.81           O  
ATOM    473  ND2 ASN A  59     -18.362  29.276  -9.949  1.00 25.55           N  
ATOM    474  N   ARG A  60     -17.648  26.149 -13.598  1.00 25.53           N  
ATOM    475  CA  ARG A  60     -17.487  25.464 -14.865  1.00 27.73           C  
ATOM    476  C   ARG A  60     -18.553  26.005 -15.811  1.00 27.13           C  
ATOM    477  O   ARG A  60     -19.714  26.177 -15.430  1.00 27.07           O  
ATOM    478  CB  ARG A  60     -17.586  23.945 -14.701  1.00 29.85           C  
ATOM    479  CG  ARG A  60     -18.975  23.366 -14.669  1.00 35.88           C  
ATOM    480  CD  ARG A  60     -18.899  21.839 -14.642  1.00 38.21           C  
ATOM    481  NE  ARG A  60     -20.197  21.230 -14.919  1.00 41.04           N  
ATOM    482  CZ  ARG A  60     -21.282  21.419 -14.175  1.00 43.17           C  
ATOM    483  NH1 ARG A  60     -21.227  22.199 -13.106  1.00 43.10           N  
ATOM    484  NH2 ARG A  60     -22.429  20.837 -14.507  1.00 44.54           N  
ATOM    485  N   ILE A  61     -18.130  26.307 -17.032  1.00 25.59           N  
ATOM    486  CA  ILE A  61     -18.999  26.870 -18.055  1.00 24.97           C  
ATOM    487  C   ILE A  61     -19.325  25.830 -19.123  1.00 25.19           C  
ATOM    488  O   ILE A  61     -18.457  25.426 -19.898  1.00 25.68           O  
ATOM    489  CB  ILE A  61     -18.310  28.082 -18.704  1.00 22.81           C  
ATOM    490  CG1 ILE A  61     -17.864  29.061 -17.611  1.00 23.28           C  
ATOM    491  CG2 ILE A  61     -19.258  28.754 -19.694  1.00 22.64           C  
ATOM    492  CD1 ILE A  61     -16.863  30.100 -18.071  1.00 22.78           C  
ATOM    493  N   VAL A  62     -20.580  25.398 -19.154  1.00 26.08           N  
ATOM    494  CA  VAL A  62     -21.019  24.389 -20.109  1.00 24.01           C  
ATOM    495  C   VAL A  62     -21.627  25.005 -21.362  1.00 26.59           C  
ATOM    496  O   VAL A  62     -22.637  25.696 -21.286  1.00 24.38           O  
ATOM    497  CB  VAL A  62     -22.065  23.443 -19.479  1.00 24.17           C  
ATOM    498  CG1 VAL A  62     -22.500  22.394 -20.499  1.00 22.28           C  
ATOM    499  CG2 VAL A  62     -21.490  22.778 -18.231  1.00 24.14           C  
ATOM    500  N   TYR A  63     -20.996  24.748 -22.507  1.00 27.81           N  
ATOM    501  CA  TYR A  63     -21.476  25.250 -23.789  1.00 30.45           C  
ATOM    502  C   TYR A  63     -22.349  24.195 -24.455  1.00 33.02           C  
ATOM    503  O   TYR A  63     -21.844  23.218 -25.015  1.00 33.88           O  
ATOM    504  CB  TYR A  63     -20.313  25.582 -24.723  1.00 30.00           C  
ATOM    505  CG  TYR A  63     -19.470  26.745 -24.270  1.00 30.71           C  
ATOM    506  CD1 TYR A  63     -18.591  26.618 -23.194  1.00 31.66           C  
ATOM    507  CD2 TYR A  63     -19.562  27.982 -24.904  1.00 29.78           C  
ATOM    508  CE1 TYR A  63     -17.825  27.699 -22.760  1.00 32.54           C  
ATOM    509  CE2 TYR A  63     -18.806  29.070 -24.476  1.00 31.74           C  
ATOM    510  CZ  TYR A  63     -17.938  28.920 -23.406  1.00 32.30           C  
ATOM    511  OH  TYR A  63     -17.185  29.990 -22.981  1.00 33.90           O  
ATOM    512  N   ASN A  64     -23.659  24.395 -24.379  1.00 33.44           N  
ATOM    513  CA  ASN A  64     -24.610  23.479 -24.989  1.00 35.02           C  
ATOM    514  C   ASN A  64     -24.701  23.832 -26.466  1.00 35.38           C  
ATOM    515  O   ASN A  64     -25.578  24.583 -26.894  1.00 36.67           O  
ATOM    516  CB  ASN A  64     -25.964  23.620 -24.302  1.00 34.13           C  
ATOM    517  CG  ASN A  64     -25.890  23.292 -22.827  1.00 35.88           C  
ATOM    518  OD1 ASN A  64     -25.818  22.125 -22.446  1.00 33.83           O  
ATOM    519  ND2 ASN A  64     -25.882  24.323 -21.988  1.00 35.07           N  
ATOM    520  N   GLN A  65     -23.757  23.293 -27.228  1.00 36.67           N  
ATOM    521  CA  GLN A  65     -23.660  23.521 -28.661  1.00 37.18           C  
ATOM    522  C   GLN A  65     -23.173  22.238 -29.320  1.00 38.71           C  
ATOM    523  O   GLN A  65     -23.061  21.197 -28.669  1.00 38.35           O  
ATOM    524  CB  GLN A  65     -22.651  24.633 -28.934  1.00 36.85           C  
ATOM    525  CG  GLN A  65     -21.278  24.324 -28.358  1.00 36.60           C  
ATOM    526  CD  GLN A  65     -20.278  25.438 -28.570  1.00 36.75           C  
ATOM    527  OE1 GLN A  65     -20.493  26.573 -28.136  1.00 37.26           O  
ATOM    528  NE2 GLN A  65     -19.170  25.120 -29.229  1.00 36.73           N  
ATOM    529  N   VAL A  66     -22.878  22.324 -30.614  1.00 40.56           N  
ATOM    530  CA  VAL A  66     -22.376  21.179 -31.370  1.00 42.30           C  
ATOM    531  C   VAL A  66     -21.076  21.600 -32.047  1.00 43.01           C  
ATOM    532  O   VAL A  66     -21.077  22.452 -32.934  1.00 44.13           O  
ATOM    533  CB  VAL A  66     -23.382  20.725 -32.453  1.00 42.91           C  
ATOM    534  CG1 VAL A  66     -22.848  19.494 -33.178  1.00 43.80           C  
ATOM    535  CG2 VAL A  66     -24.738  20.423 -31.819  1.00 42.45           C  
ATOM    536  N   PRO A  67     -19.943  21.002 -31.637  1.00 43.86           N  
ATOM    537  CA  PRO A  67     -19.796  19.982 -30.591  1.00 43.66           C  
ATOM    538  C   PRO A  67     -19.839  20.567 -29.177  1.00 43.45           C  
ATOM    539  O   PRO A  67     -19.434  21.709 -28.961  1.00 43.46           O  
ATOM    540  CB  PRO A  67     -18.426  19.366 -30.895  1.00 43.97           C  
ATOM    541  CG  PRO A  67     -18.145  19.761 -32.329  1.00 44.53           C  
ATOM    542  CD  PRO A  67     -18.682  21.157 -32.376  1.00 44.31           C  
ATOM    543  N   PRO A  68     -20.335  19.786 -28.198  1.00 43.48           N  
ATOM    544  CA  PRO A  68     -20.423  20.234 -26.802  1.00 42.94           C  
ATOM    545  C   PRO A  68     -19.029  20.583 -26.289  1.00 41.44           C  
ATOM    546  O   PRO A  68     -18.050  19.934 -26.653  1.00 42.66           O  
ATOM    547  CB  PRO A  68     -21.020  19.023 -26.091  1.00 43.71           C  
ATOM    548  CG  PRO A  68     -21.899  18.428 -27.148  1.00 43.80           C  
ATOM    549  CD  PRO A  68     -21.002  18.484 -28.367  1.00 43.93           C  
ATOM    550  N   LYS A  69     -18.944  21.600 -25.441  1.00 39.74           N  
ATOM    551  CA  LYS A  69     -17.659  22.054 -24.918  1.00 38.44           C  
ATOM    552  C   LYS A  69     -17.809  22.652 -23.517  1.00 37.95           C  
ATOM    553  O   LYS A  69     -18.795  23.323 -23.220  1.00 37.73           O  
ATOM    554  CB  LYS A  69     -17.081  23.073 -25.906  1.00 37.97           C  
ATOM    555  CG  LYS A  69     -16.181  24.151 -25.343  1.00 37.39           C  
ATOM    556  CD  LYS A  69     -16.003  25.223 -26.408  1.00 37.96           C  
ATOM    557  CE  LYS A  69     -15.417  26.511 -25.853  1.00 38.24           C  
ATOM    558  NZ  LYS A  69     -15.445  27.590 -26.882  1.00 35.26           N  
ATOM    559  N   VAL A  70     -16.822  22.399 -22.662  1.00 36.23           N  
ATOM    560  CA  VAL A  70     -16.849  22.887 -21.288  1.00 33.70           C  
ATOM    561  C   VAL A  70     -15.569  23.626 -20.912  1.00 32.61           C  
ATOM    562  O   VAL A  70     -14.470  23.152 -21.191  1.00 32.93           O  
ATOM    563  CB  VAL A  70     -17.042  21.711 -20.300  1.00 33.80           C  
ATOM    564  CG1 VAL A  70     -17.003  22.209 -18.862  1.00 34.98           C  
ATOM    565  CG2 VAL A  70     -18.357  21.012 -20.584  1.00 34.03           C  
ATOM    566  N   GLU A  71     -15.718  24.789 -20.282  1.00 30.53           N  
ATOM    567  CA  GLU A  71     -14.569  25.580 -19.849  1.00 29.24           C  
ATOM    568  C   GLU A  71     -14.640  25.853 -18.350  1.00 27.70           C  
ATOM    569  O   GLU A  71     -15.692  25.694 -17.727  1.00 24.86           O  
ATOM    570  CB  GLU A  71     -14.508  26.913 -20.594  1.00 29.70           C  
ATOM    571  CG  GLU A  71     -14.544  26.787 -22.104  1.00 33.48           C  
ATOM    572  CD  GLU A  71     -14.211  28.089 -22.793  1.00 33.67           C  
ATOM    573  OE1 GLU A  71     -14.725  29.139 -22.360  1.00 36.71           O  
ATOM    574  OE2 GLU A  71     -13.440  28.063 -23.775  1.00 36.97           O  
ATOM    575  N   TYR A  72     -13.514  26.277 -17.783  1.00 27.10           N  
ATOM    576  CA  TYR A  72     -13.425  26.577 -16.355  1.00 25.33           C  
ATOM    577  C   TYR A  72     -12.885  27.982 -16.142  1.00 24.53           C  
ATOM    578  O   TYR A  72     -11.995  28.427 -16.865  1.00 24.84           O  
ATOM    579  CB  TYR A  72     -12.510  25.561 -15.676  1.00 25.90           C  
ATOM    580  CG  TYR A  72     -13.033  24.154 -15.759  1.00 28.70           C  
ATOM    581  CD1 TYR A  72     -13.933  23.669 -14.811  1.00 30.13           C  
ATOM    582  CD2 TYR A  72     -12.670  23.319 -16.815  1.00 30.11           C  
ATOM    583  CE1 TYR A  72     -14.457  22.389 -14.908  1.00 31.92           C  
ATOM    584  CE2 TYR A  72     -13.193  22.038 -16.926  1.00 31.00           C  
ATOM    585  CZ  TYR A  72     -14.084  21.581 -15.971  1.00 32.09           C  
ATOM    586  OH  TYR A  72     -14.604  20.312 -16.077  1.00 35.61           O  
ATOM    587  N   GLU A  73     -13.428  28.687 -15.154  1.00 23.23           N  
ATOM    588  CA  GLU A  73     -12.980  30.039 -14.862  1.00 23.62           C  
ATOM    589  C   GLU A  73     -12.837  30.237 -13.358  1.00 23.47           C  
ATOM    590  O   GLU A  73     -13.508  29.581 -12.563  1.00 22.12           O  
ATOM    591  CB  GLU A  73     -13.976  31.069 -15.407  1.00 25.93           C  
ATOM    592  CG  GLU A  73     -15.222  31.250 -14.541  1.00 29.52           C  
ATOM    593  CD  GLU A  73     -16.200  32.269 -15.114  1.00 32.13           C  
ATOM    594  OE1 GLU A  73     -15.737  33.275 -15.694  1.00 33.29           O  
ATOM    595  OE2 GLU A  73     -17.427  32.073 -14.966  1.00 31.83           O  
ATOM    596  N   LEU A  74     -11.957  31.150 -12.977  1.00 24.99           N  
ATOM    597  CA  LEU A  74     -11.742  31.451 -11.571  1.00 26.53           C  
ATOM    598  C   LEU A  74     -12.984  32.203 -11.093  1.00 27.26           C  
ATOM    599  O   LEU A  74     -13.311  33.268 -11.624  1.00 27.73           O  
ATOM    600  CB  LEU A  74     -10.502  32.333 -11.417  1.00 27.41           C  
ATOM    601  CG  LEU A  74      -9.855  32.405 -10.031  1.00 29.95           C  
ATOM    602  CD1 LEU A  74      -9.447  31.016  -9.581  1.00 29.26           C  
ATOM    603  CD2 LEU A  74      -8.640  33.302 -10.086  1.00 29.79           C  
ATOM    604  N   SER A  75     -13.689  31.651 -10.112  1.00 25.17           N  
ATOM    605  CA  SER A  75     -14.885  32.318  -9.603  1.00 25.53           C  
ATOM    606  C   SER A  75     -14.463  33.577  -8.859  1.00 25.94           C  
ATOM    607  O   SER A  75     -13.278  33.771  -8.564  1.00 21.98           O  
ATOM    608  CB  SER A  75     -15.653  31.401  -8.652  1.00 25.76           C  
ATOM    609  OG  SER A  75     -14.959  31.236  -7.426  1.00 25.61           O  
ATOM    610  N   GLU A  76     -15.432  34.437  -8.562  1.00 24.93           N  
ATOM    611  CA  GLU A  76     -15.151  35.668  -7.836  1.00 27.84           C  
ATOM    612  C   GLU A  76     -14.511  35.317  -6.490  1.00 26.31           C  
ATOM    613  O   GLU A  76     -13.573  35.977  -6.040  1.00 27.16           O  
ATOM    614  CB  GLU A  76     -16.448  36.455  -7.617  1.00 30.42           C  
ATOM    615  CG  GLU A  76     -16.315  37.646  -6.678  1.00 36.18           C  
ATOM    616  CD  GLU A  76     -17.611  38.435  -6.540  1.00 40.62           C  
ATOM    617  OE1 GLU A  76     -17.995  39.137  -7.505  1.00 43.06           O  
ATOM    618  OE2 GLU A  76     -18.252  38.348  -5.468  1.00 42.85           O  
ATOM    619  N   TYR A  77     -15.024  34.266  -5.859  1.00 24.97           N  
ATOM    620  CA  TYR A  77     -14.504  33.818  -4.574  1.00 26.03           C  
ATOM    621  C   TYR A  77     -13.069  33.319  -4.756  1.00 25.38           C  
ATOM    622  O   TYR A  77     -12.195  33.617  -3.947  1.00 27.46           O  
ATOM    623  CB  TYR A  77     -15.404  32.709  -4.007  1.00 24.08           C  
ATOM    624  CG  TYR A  77     -14.940  32.127  -2.684  1.00 22.79           C  
ATOM    625  CD1 TYR A  77     -14.654  32.948  -1.591  1.00 22.79           C  
ATOM    626  CD2 TYR A  77     -14.786  30.751  -2.530  1.00 23.50           C  
ATOM    627  CE1 TYR A  77     -14.220  32.404  -0.372  1.00 22.18           C  
ATOM    628  CE2 TYR A  77     -14.356  30.198  -1.323  1.00 21.54           C  
ATOM    629  CZ  TYR A  77     -14.076  31.028  -0.252  1.00 21.44           C  
ATOM    630  OH  TYR A  77     -13.651  30.471   0.929  1.00 23.34           O  
ATOM    631  N   GLY A  78     -12.835  32.573  -5.831  1.00 25.10           N  
ATOM    632  CA  GLY A  78     -11.504  32.064  -6.110  1.00 23.32           C  
ATOM    633  C   GLY A  78     -10.509  33.204  -6.234  1.00 23.96           C  
ATOM    634  O   GLY A  78      -9.343  33.074  -5.859  1.00 20.96           O  
ATOM    635  N   ARG A  79     -10.978  34.329  -6.762  1.00 22.61           N  
ATOM    636  CA  ARG A  79     -10.145  35.506  -6.934  1.00 24.29           C  
ATOM    637  C   ARG A  79      -9.583  35.990  -5.596  1.00 22.27           C  
ATOM    638  O   ARG A  79      -8.542  36.644  -5.560  1.00 21.86           O  
ATOM    639  CB  ARG A  79     -10.960  36.635  -7.579  1.00 29.69           C  
ATOM    640  CG  ARG A  79     -10.265  37.349  -8.739  1.00 35.53           C  
ATOM    641  CD  ARG A  79     -10.701  36.787 -10.087  1.00 39.44           C  
ATOM    642  NE  ARG A  79     -12.104  37.075 -10.379  1.00 43.33           N  
ATOM    643  CZ  ARG A  79     -12.762  36.615 -11.441  1.00 45.70           C  
ATOM    644  NH1 ARG A  79     -12.146  35.839 -12.324  1.00 46.51           N  
ATOM    645  NH2 ARG A  79     -14.041  36.928 -11.619  1.00 47.22           N  
ATOM    646  N   SER A  80     -10.264  35.673  -4.496  1.00 20.06           N  
ATOM    647  CA  SER A  80      -9.801  36.115  -3.179  1.00 20.05           C  
ATOM    648  C   SER A  80      -8.530  35.405  -2.713  1.00 20.09           C  
ATOM    649  O   SER A  80      -8.053  35.644  -1.611  1.00 20.75           O  
ATOM    650  CB  SER A  80     -10.901  35.936  -2.120  1.00 20.42           C  
ATOM    651  OG  SER A  80     -11.117  34.569  -1.796  1.00 20.45           O  
ATOM    652  N   LEU A  81      -7.985  34.531  -3.550  1.00 20.52           N  
ATOM    653  CA  LEU A  81      -6.757  33.813  -3.203  1.00 21.72           C  
ATOM    654  C   LEU A  81      -5.554  34.468  -3.889  1.00 21.68           C  
ATOM    655  O   LEU A  81      -4.402  34.106  -3.632  1.00 22.23           O  
ATOM    656  CB  LEU A  81      -6.865  32.338  -3.622  1.00 20.04           C  
ATOM    657  CG  LEU A  81      -7.795  31.432  -2.797  1.00 20.26           C  
ATOM    658  CD1 LEU A  81      -8.104  30.165  -3.571  1.00 19.23           C  
ATOM    659  CD2 LEU A  81      -7.146  31.078  -1.469  1.00 18.72           C  
ATOM    660  N   GLU A  82      -5.823  35.449  -4.748  1.00 23.27           N  
ATOM    661  CA  GLU A  82      -4.752  36.128  -5.473  1.00 24.34           C  
ATOM    662  C   GLU A  82      -3.696  36.736  -4.559  1.00 22.42           C  
ATOM    663  O   GLU A  82      -2.517  36.732  -4.895  1.00 21.10           O  
ATOM    664  CB  GLU A  82      -5.326  37.205  -6.412  1.00 26.68           C  
ATOM    665  CG  GLU A  82      -6.253  38.214  -5.758  1.00 33.77           C  
ATOM    666  CD  GLU A  82      -6.850  39.192  -6.767  1.00 37.37           C  
ATOM    667  OE1 GLU A  82      -7.075  38.789  -7.926  1.00 38.23           O  
ATOM    668  OE2 GLU A  82      -7.105  40.357  -6.399  1.00 40.44           O  
ATOM    669  N   GLY A  83      -4.115  37.248  -3.405  1.00 20.24           N  
ATOM    670  CA  GLY A  83      -3.162  37.838  -2.485  1.00 20.18           C  
ATOM    671  C   GLY A  83      -2.194  36.811  -1.922  1.00 18.37           C  
ATOM    672  O   GLY A  83      -1.000  37.074  -1.771  1.00 20.27           O  
ATOM    673  N   ILE A  84      -2.714  35.640  -1.591  1.00 18.10           N  
ATOM    674  CA  ILE A  84      -1.883  34.570  -1.058  1.00 17.29           C  
ATOM    675  C   ILE A  84      -0.912  34.143  -2.162  1.00 17.93           C  
ATOM    676  O   ILE A  84       0.261  33.893  -1.907  1.00 16.51           O  
ATOM    677  CB  ILE A  84      -2.759  33.370  -0.614  1.00 15.92           C  
ATOM    678  CG1 ILE A  84      -3.499  33.734   0.682  1.00 18.05           C  
ATOM    679  CG2 ILE A  84      -1.911  32.117  -0.460  1.00 16.20           C  
ATOM    680  CD1 ILE A  84      -4.500  32.694   1.161  1.00 15.49           C  
ATOM    681  N   LEU A  85      -1.410  34.089  -3.394  1.00 19.91           N  
ATOM    682  CA  LEU A  85      -0.580  33.699  -4.525  1.00 21.17           C  
ATOM    683  C   LEU A  85       0.554  34.721  -4.691  1.00 21.49           C  
ATOM    684  O   LEU A  85       1.704  34.344  -4.893  1.00 21.56           O  
ATOM    685  CB  LEU A  85      -1.440  33.615  -5.790  1.00 23.15           C  
ATOM    686  CG  LEU A  85      -0.783  33.043  -7.047  1.00 23.81           C  
ATOM    687  CD1 LEU A  85      -0.121  31.701  -6.742  1.00 22.88           C  
ATOM    688  CD2 LEU A  85      -1.850  32.891  -8.120  1.00 24.58           C  
ATOM    689  N   ASP A  86       0.233  36.008  -4.576  1.00 22.38           N  
ATOM    690  CA  ASP A  86       1.253  37.052  -4.702  1.00 23.98           C  
ATOM    691  C   ASP A  86       2.376  36.901  -3.661  1.00 23.86           C  
ATOM    692  O   ASP A  86       3.553  37.012  -3.996  1.00 20.65           O  
ATOM    693  CB  ASP A  86       0.632  38.445  -4.554  1.00 24.67           C  
ATOM    694  CG  ASP A  86      -0.189  38.859  -5.757  1.00 29.49           C  
ATOM    695  OD1 ASP A  86       0.194  38.527  -6.901  1.00 31.52           O  
ATOM    696  OD2 ASP A  86      -1.218  39.534  -5.558  1.00 32.14           O  
HETATM  697  N   MSE A  87       2.003  36.666  -2.405  1.00 25.02           N  
HETATM  698  CA  MSE A  87       2.974  36.501  -1.330  1.00 27.70           C  
HETATM  699  C   MSE A  87       3.776  35.197  -1.524  1.00 24.97           C  
HETATM  700  O   MSE A  87       4.990  35.163  -1.292  1.00 22.78           O  
HETATM  701  CB  MSE A  87       2.238  36.538   0.027  1.00 32.25           C  
HETATM  702  CG  MSE A  87       1.740  37.936   0.410  0.50 39.30           C  
HETATM  704 SE   MSE A  87       3.156  39.291   0.435  0.50 50.16          SE  
HETATM  706  CE  MSE A  87       2.929  40.000  -1.350  0.50 47.21           C  
ATOM    708  N   LEU A  88       3.107  34.133  -1.965  1.00 23.38           N  
ATOM    709  CA  LEU A  88       3.792  32.865  -2.203  1.00 24.09           C  
ATOM    710  C   LEU A  88       4.908  33.033  -3.224  1.00 23.69           C  
ATOM    711  O   LEU A  88       6.019  32.549  -3.018  1.00 22.04           O  
ATOM    712  CB  LEU A  88       2.832  31.790  -2.725  1.00 25.31           C  
ATOM    713  CG  LEU A  88       1.960  30.988  -1.757  1.00 28.48           C  
ATOM    714  CD1 LEU A  88       1.372  29.804  -2.516  1.00 30.10           C  
ATOM    715  CD2 LEU A  88       2.772  30.484  -0.566  1.00 29.17           C  
HETATM  716  N   CSU A  89       4.599  33.704  -4.328  1.00 23.70           N  
HETATM  717  CA  CSU A  89       5.579  33.931  -5.375  1.00 23.94           C  
HETATM  718  CB  CSU A  89       4.893  34.495  -6.622  1.00 26.41           C  
HETATM  719  SG  CSU A  89       3.772  33.297  -7.408  1.00 32.29           S  
HETATM  720  C   CSU A  89       6.679  34.865  -4.883  1.00 22.53           C  
HETATM  721  O   CSU A  89       7.852  34.647  -5.163  1.00 23.69           O  
ATOM    722  N   ALA A  90       6.300  35.897  -4.139  1.00 22.39           N  
ATOM    723  CA  ALA A  90       7.273  36.836  -3.594  1.00 22.78           C  
ATOM    724  C   ALA A  90       8.268  36.074  -2.718  1.00 23.02           C  
ATOM    725  O   ALA A  90       9.480  36.276  -2.817  1.00 22.54           O  
ATOM    726  CB  ALA A  90       6.568  37.904  -2.777  1.00 22.29           C  
ATOM    727  N   TRP A  91       7.749  35.185  -1.871  1.00 21.82           N  
ATOM    728  CA  TRP A  91       8.591  34.385  -0.979  1.00 19.20           C  
ATOM    729  C   TRP A  91       9.421  33.377  -1.773  1.00 20.75           C  
ATOM    730  O   TRP A  91      10.602  33.165  -1.486  1.00 19.46           O  
ATOM    731  CB  TRP A  91       7.735  33.622   0.039  1.00 19.45           C  
ATOM    732  CG  TRP A  91       8.547  32.985   1.136  1.00 18.18           C  
ATOM    733  CD1 TRP A  91       8.887  33.544   2.336  1.00 18.69           C  
ATOM    734  CD2 TRP A  91       9.153  31.687   1.113  1.00 18.61           C  
ATOM    735  NE1 TRP A  91       9.663  32.673   3.060  1.00 18.64           N  
ATOM    736  CE2 TRP A  91       9.843  31.527   2.335  1.00 19.14           C  
ATOM    737  CE3 TRP A  91       9.178  30.641   0.177  1.00 20.15           C  
ATOM    738  CZ2 TRP A  91      10.555  30.361   2.647  1.00 19.92           C  
ATOM    739  CZ3 TRP A  91       9.887  29.482   0.491  1.00 20.06           C  
ATOM    740  CH2 TRP A  91      10.564  29.355   1.719  1.00 18.86           C  
ATOM    741  N   GLY A  92       8.793  32.745  -2.761  1.00 18.61           N  
ATOM    742  CA  GLY A  92       9.502  31.782  -3.575  1.00 21.49           C  
ATOM    743  C   GLY A  92      10.648  32.423  -4.337  1.00 22.74           C  
ATOM    744  O   GLY A  92      11.732  31.850  -4.438  1.00 22.41           O  
ATOM    745  N   ALA A  93      10.420  33.616  -4.877  1.00 23.11           N  
ATOM    746  CA  ALA A  93      11.466  34.301  -5.630  1.00 24.91           C  
ATOM    747  C   ALA A  93      12.681  34.574  -4.741  1.00 25.78           C  
ATOM    748  O   ALA A  93      13.824  34.391  -5.156  1.00 23.78           O  
ATOM    749  CB  ALA A  93      10.927  35.606  -6.214  1.00 24.42           C  
ATOM    750  N   ASN A  94      12.427  35.001  -3.509  1.00 25.23           N  
ATOM    751  CA  ASN A  94      13.508  35.284  -2.571  1.00 27.50           C  
ATOM    752  C   ASN A  94      14.222  34.001  -2.177  1.00 26.83           C  
ATOM    753  O   ASN A  94      15.422  34.009  -1.918  1.00 27.41           O  
ATOM    754  CB  ASN A  94      12.956  35.960  -1.320  1.00 31.93           C  
ATOM    755  CG  ASN A  94      12.285  37.284  -1.624  1.00 36.51           C  
ATOM    756  OD1 ASN A  94      11.466  37.773  -0.840  1.00 39.51           O  
ATOM    757  ND2 ASN A  94      12.637  37.881  -2.759  1.00 37.04           N  
ATOM    758  N   HIS A  95      13.478  32.899  -2.149  1.00 24.69           N  
ATOM    759  CA  HIS A  95      14.028  31.601  -1.779  1.00 25.70           C  
ATOM    760  C   HIS A  95      14.954  30.980  -2.824  1.00 27.17           C  
ATOM    761  O   HIS A  95      16.080  30.605  -2.516  1.00 25.41           O  
ATOM    762  CB  HIS A  95      12.897  30.613  -1.484  1.00 23.74           C  
ATOM    763  CG  HIS A  95      13.381  29.268  -1.042  1.00 23.96           C  
ATOM    764  ND1 HIS A  95      13.831  29.024   0.236  1.00 23.17           N  
ATOM    765  CD2 HIS A  95      13.534  28.108  -1.723  1.00 24.17           C  
ATOM    766  CE1 HIS A  95      14.242  27.773   0.324  1.00 21.60           C  
ATOM    767  NE2 HIS A  95      14.073  27.194  -0.852  1.00 22.68           N  
ATOM    768  N   ILE A  96      14.464  30.861  -4.053  1.00 29.25           N  
ATOM    769  CA  ILE A  96      15.235  30.258  -5.138  1.00 33.14           C  
ATOM    770  C   ILE A  96      16.483  31.049  -5.497  1.00 35.66           C  
ATOM    771  O   ILE A  96      17.558  30.479  -5.714  1.00 36.80           O  
ATOM    772  CB  ILE A  96      14.378  30.095  -6.404  1.00 33.11           C  
ATOM    773  CG1 ILE A  96      13.826  31.454  -6.836  1.00 32.35           C  
ATOM    774  CG2 ILE A  96      13.248  29.111  -6.148  1.00 33.46           C  
ATOM    775  CD1 ILE A  96      12.952  31.394  -8.055  1.00 33.22           C  
ATOM    776  N   ASN A  97      16.342  32.366  -5.561  1.00 37.56           N  
ATOM    777  CA  ASN A  97      17.475  33.219  -5.864  1.00 40.57           C  
ATOM    778  C   ASN A  97      18.318  33.292  -4.591  1.00 42.93           C  
ATOM    779  O   ASN A  97      18.959  34.300  -4.315  1.00 44.18           O  
ATOM    780  CB  ASN A  97      16.990  34.621  -6.289  1.00 40.24           C  
ATOM    781  CG  ASN A  97      16.268  34.612  -7.638  1.00 42.09           C  
ATOM    782  OD1 ASN A  97      16.859  34.300  -8.677  1.00 41.55           O  
ATOM    783  ND2 ASN A  97      14.980  34.943  -7.620  1.00 39.82           N  
ATOM    784  N   ARG A  98      18.293  32.198  -3.832  1.00 45.60           N  
ATOM    785  CA  ARG A  98      19.032  32.062  -2.584  1.00 47.65           C  
ATOM    786  C   ARG A  98      18.684  33.123  -1.556  1.00 48.68           C  
ATOM    787  O   ARG A  98      18.099  34.158  -1.896  1.00 50.69           O  
ATOM    788  CB  ARG A  98      20.540  32.082  -2.865  1.00 48.10           C  
TER     789      ARG A  98                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
