
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 (  727),  selected   92 , name 2pg4_A
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 2pg4_A.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S       1           -
LGA    -       -      N       2           -
LGA    -       -      A       3           -
LGA    -       -      M       4           -
LGA    -       -      L       5           -
LGA    -       -      R       6           -
LGA    -       -      Y       7           -
LGA    -       -      G       8           -
LGA    -       -      D       9           -
LGA    -       -      T      10           -
LGA    -       -      E      11           -
LGA    -       -      I      12           -
LGA    -       -      C      13           -
LGA    -       -      I      14           -
LGA    -       -      D      15           -
LGA    -       -      P      16           -
LGA    X     1_A      S      17          6.940
LGA    D     2_A      E      18          3.322
LGA    D     3_A      S      19          3.679
LGA    E     4_A      V      20          3.651
LGA    T     5_A      L      21          4.643
LGA    L     6_A      H      22          2.655
LGA    R     7_A      L      23          3.186
LGA    L     8_A      L      24          3.832
LGA    Q     9_A      G      25          3.017
LGA    F    10_A      K      26          4.661
LGA    G    11_A      K      27          3.862
LGA    H    12_A      Y      28          1.399
LGA    L    13_A      T      29          2.144
LGA    I    14_A      M      30          2.135
LGA    R    15_A      L      31          0.869
LGA    I    16_A      I      32          0.710
LGA    L    17_A      I      33          0.677
LGA    P    18_A      S      34          0.975
LGA    T    19_A      V      35          0.549
LGA    L    20_A      L      36          0.877
LGA    L    21_A      G      37          1.011
LGA    E    22_A      N      38          1.440
LGA    F    23_A      G      39          2.544
LGA    E    24_A      -       -           -
LGA    K    25_A      -       -           -
LGA    K    26_A      -       -           -
LGA    G    27_A      S      40          2.296
LGA    Y    28_A      T      41          1.130
LGA    E    29_A      R      42          1.448
LGA    P    30_A      Q      43          1.054
LGA    S    31_A      N      44          0.586
LGA    L    32_A      F      45          1.198
LGA    A    33_A      N      46          1.206
LGA    E    34_A      D      47          0.507
LGA    I    35_A      I      48          1.033
LGA    V    36_A      R      49          1.242
LGA    K    37_A      S      50          0.977
LGA    A    38_A      S      51          1.121
LGA    S    39_A      I      52          2.669
LGA    G    40_A      P      53          3.053
LGA    -       -      G      54           -
LGA    V    41_A      I      55          2.393
LGA    S    42_A      S      56          1.974
LGA    E    43_A      S      57          1.593
LGA    K    44_A      T      58          2.438
LGA    T    45_A      I      59          1.191
LGA    F    46_A      L      60          1.395
LGA    F    47_A      S      61          2.606
LGA    X    48_A      -       -           -
LGA    G    49_A      R      62          1.679
LGA    L    50_A      R      63          1.596
LGA    K    51_A      I      64          1.523
LGA    D    52_A      K      65          0.763
LGA    R    53_A      D      66          0.897
LGA    L    54_A      L      67          1.009
LGA    I    55_A      I      68          0.990
LGA    R    56_A      D      69          1.332
LGA    A    57_A      S      70          1.642
LGA    G    58_A      G      71          1.484
LGA    L    59_A      L      72          1.012
LGA    V    60_A      V      73          0.428
LGA    K    61_A      E      74          0.968
LGA    E    62_A      R      75          0.945
LGA    E    63_A      R      76          0.870
LGA    T    64_A      S      77          1.401
LGA    L    65_A      G      78          3.857
LGA    S    66_A      Q      79          1.674
LGA    Y    67_A      -       -           -
LGA    R    68_A      -       -           -
LGA    V    69_A      I      80          2.875
LGA    K    70_A      T      81          1.363
LGA    T    71_A      T      82          1.285
LGA    L    72_A      Y      83          1.325
LGA    K    73_A      A      84          1.787
LGA    L    74_A      L      85          0.723
LGA    T    75_A      T      86          1.223
LGA    E    76_A      E      87          1.221
LGA    K    77_A      K      88          1.283
LGA    G    78_A      G      89          0.629
LGA    R    79_A      M      90          0.414
LGA    R    80_A      N      91          0.709
LGA    L    81_A      V      92          0.747
LGA    A    82_A      R      93          0.922
LGA    E    83_A      N      94          1.665
LGA    C    84_A      S      95          1.603
LGA    L    85_A      L      96          1.563
LGA    E    86_A      M      97          1.428
LGA    K    87_A      P      98          1.414
LGA    C    88_A      L      99          1.582
LGA    R    89_A      L     100          1.399
LGA    D    90_A      Q     101          1.122
LGA    V    91_A      Y     102          1.288
LGA    L    92_A      I     103          1.277
LGA    -       -      S     104           -
LGA    -       -      V     105           -
LGA    -       -      L     106           -
LGA    -       -      D     107           -
LGA    -       -      R     108           -
LGA    -       -      N     109           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92  109    5.0     86    2.04    19.77     70.313     4.014

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.157055 * X  +  -0.428025 * Y  +   0.890016 * Z  +   0.265000
  Y_new =   0.034216 * X  +  -0.903017 * Y  +  -0.428240 * Z  +  57.668785
  Z_new =   0.986997 * X  +  -0.036804 * Y  +   0.156468 * Z  + -61.010548 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.231018    2.910575  [ DEG:   -13.2363    166.7637 ]
  Theta =  -1.409357   -1.732235  [ DEG:   -80.7502    -99.2498 ]
  Phi   =   2.927083   -0.214510  [ DEG:   167.7095    -12.2905 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pg4_A                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pg4_A.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92  109   5.0   86   2.04   19.77  70.313
REMARK  ---------------------------------------------------------- 
MOLECULE 2pg4_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   06-APR-07   2PG4              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN (NP_147569.1)            
TITLE    2 FROM AEROPYRUM PERNIX AT 2.21 A RESOLUTION                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AEROPYRUM PERNIX;                               
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 STRAIN: K1;                                                          
SOURCE   5 GENE: NP_147569.1, APE0880.1, APES039, APE_0880A;                    
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_147569.1, UNCHARACTERIZED PROTEIN, STRUCTURAL GENOMICS,            
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI-2                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   24-APR-07 2PG4    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN                 
JRNL        TITL 2 (NP_147569.1) FROM AEROPYRUM PERNIX AT 2.21 A                
JRNL        TITL 3 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.21 ANGSTROMS.                                          
DBREF  2PG4 A    1    94  UNP    Q9YDN4   Q9YDN4_AERPE     1     94             
DBREF  2PG4 B    1    94  UNP    Q9YDN4   Q9YDN4_AERPE     1     94             
SEQRES   1 A   95  GLY MSE ASP ASP GLU THR LEU ARG LEU GLN PHE GLY HIS          
SEQRES   2 A   95  LEU ILE ARG ILE LEU PRO THR LEU LEU GLU PHE GLU LYS          
SEQRES   3 A   95  LYS GLY TYR GLU PRO SER LEU ALA GLU ILE VAL LYS ALA          
SEQRES   4 A   95  SER GLY VAL SER GLU LYS THR PHE PHE MSE GLY LEU LYS          
SEQRES   5 A   95  ASP ARG LEU ILE ARG ALA GLY LEU VAL LYS GLU GLU THR          
SEQRES   6 A   95  LEU SER TYR ARG VAL LYS THR LEU LYS LEU THR GLU LYS          
SEQRES   7 A   95  GLY ARG ARG LEU ALA GLU CYS LEU GLU LYS CYS ARG ASP          
SEQRES   8 A   95  VAL LEU GLY SER                                              
SEQRES   1 B   95  GLY MSE ASP ASP GLU THR LEU ARG LEU GLN PHE GLY HIS          
SEQRES   2 B   95  LEU ILE ARG ILE LEU PRO THR LEU LEU GLU PHE GLU LYS          
SEQRES   3 B   95  LYS GLY TYR GLU PRO SER LEU ALA GLU ILE VAL LYS ALA          
SEQRES   4 B   95  SER GLY VAL SER GLU LYS THR PHE PHE MSE GLY LEU LYS          
SEQRES   5 B   95  ASP ARG LEU ILE ARG ALA GLY LEU VAL LYS GLU GLU THR          
SEQRES   6 B   95  LEU SER TYR ARG VAL LYS THR LEU LYS LEU THR GLU LYS          
SEQRES   7 B   95  GLY ARG ARG LEU ALA GLU CYS LEU GLU LYS CYS ARG ASP          
SEQRES   8 B   95  VAL LEU GLY SER                                              
HET    MSE  A   1      16                                                       
HET    MSE  A  48       5                                                       
HET    MSE  B  48       8                                                       
HET     CL      1       1                                                       
HET     CL      2       1                                                       
HET     CL      3       1                                                       
HET    CIT      4      13                                                       
HET    EDO      5       4                                                       
HET    EDO      6       4                                                       
HET    EDO      7       4                                                       
HET    EDO      8       4                                                       
HET    EDO      9       4                                                       
HET    EDO     10       4                                                       
HET    EDO     11       4                                                       
HET    PEG     12       7                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     CIT CITRIC ACID                                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   3   CL    3(CL 1-)                                                     
FORMUL   6  CIT    C6 H8 O7                                                     
FORMUL   7  EDO    7(C2 H6 O2)                                                  
FORMUL  14  PEG    C4 H10 O3                                                    
FORMUL  15  HOH   *34(H2 O)                                                     
CRYST1  109.840  109.840   36.760  90.00  90.00  90.00 P 4 21 2     16          
HETATM    1  N   MSE A   1     -12.484  26.642   9.466  0.50 45.60           N  
HETATM    3  CA  MSE A   1     -11.953  25.315   9.884  0.50 44.89           C  
HETATM    5  C   MSE A   1     -12.272  24.251   8.851  0.50 51.20           C  
HETATM    7  O   MSE A   1     -11.413  23.453   8.459  0.50 52.16           O  
HETATM    9  CB  MSE A   1     -12.573  24.899  11.202  0.50 45.53           C  
HETATM   11  CG  MSE A   1     -12.173  23.519  11.647  0.50 38.66           C  
HETATM   13 SE   MSE A   1     -12.995  23.105  13.325  0.37 34.25          SE  
HETATM   15  CE  MSE A   1     -12.335  24.565  14.435  0.50 34.56           C  
ATOM     17  N   ASP A   2     -13.523  24.227   8.419  0.50 55.21           N  
ATOM     19  CA  ASP A   2     -13.981  23.173   7.519  0.50 57.80           C  
ATOM     21  C   ASP A   2     -13.823  23.468   6.018  0.50 61.04           C  
ATOM     23  O   ASP A   2     -14.298  22.660   5.199  0.50 60.06           O  
ATOM     25  CB  ASP A   2     -15.449  22.828   7.814  0.50 57.50           C  
ATOM     27  CG  ASP A   2     -16.396  23.952   7.458  0.50 54.64           C  
ATOM     29  OD1 ASP A   2     -16.022  25.136   7.624  0.50 41.32           O  
ATOM     31  OD2 ASP A   2     -17.522  23.645   7.015  0.50 60.11           O  
ATOM     33  N   ASP A   3     -13.183  24.579   5.615  1.00 63.54           N  
ATOM     34  CA  ASP A   3     -13.059  24.782   4.187  1.00 62.74           C  
ATOM     35  C   ASP A   3     -12.319  23.560   3.600  1.00 61.88           C  
ATOM     36  O   ASP A   3     -11.316  23.105   4.151  1.00 61.98           O  
ATOM     37  CB  ASP A   3     -12.333  26.115   3.898  1.00 61.48           C  
ATOM     38  CG  ASP A   3     -12.587  26.637   2.468  1.00 61.40           C  
ATOM     39  OD1 ASP A   3     -12.697  25.823   1.519  1.00 55.82           O  
ATOM     40  OD2 ASP A   3     -12.664  27.870   2.286  1.00 58.68           O  
ATOM     41  N   GLU A   4     -12.862  23.001   2.523  1.00 58.98           N  
ATOM     42  CA  GLU A   4     -12.231  21.871   1.856  1.00 58.96           C  
ATOM     43  C   GLU A   4     -11.016  22.354   1.074  1.00 54.98           C  
ATOM     44  O   GLU A   4     -10.203  21.538   0.650  1.00 55.25           O  
ATOM     45  CB  GLU A   4     -13.229  21.159   0.932  1.00 61.99           C  
ATOM     46  CG  GLU A   4     -13.029  19.621   0.824  1.00 69.14           C  
ATOM     47  CD  GLU A   4     -12.172  19.180  -0.368  1.00 67.63           C  
ATOM     48  OE1 GLU A   4     -12.372  19.708  -1.491  1.00 71.20           O  
ATOM     49  OE2 GLU A   4     -11.324  18.280  -0.174  1.00 66.14           O  
ATOM     50  N   THR A   5     -10.902  23.679   0.910  1.00 50.19           N  
ATOM     51  CA  THR A   5      -9.690  24.332   0.422  1.00 48.81           C  
ATOM     52  C   THR A   5      -8.441  23.915   1.217  1.00 44.85           C  
ATOM     53  O   THR A   5      -7.358  23.775   0.670  1.00 41.21           O  
ATOM     54  CB  THR A   5      -9.813  25.902   0.434  1.00 50.76           C  
ATOM     55  OG1 THR A   5     -10.895  26.343  -0.414  1.00 53.85           O  
ATOM     56  CG2 THR A   5      -8.539  26.538  -0.076  1.00 50.95           C  
ATOM     57  N   LEU A   6      -8.606  23.732   2.518  1.00 43.82           N  
ATOM     58  CA  LEU A   6      -7.512  23.345   3.392  1.00 43.30           C  
ATOM     59  C   LEU A   6      -6.958  21.955   3.073  1.00 42.00           C  
ATOM     60  O   LEU A   6      -5.812  21.681   3.328  1.00 41.80           O  
ATOM     61  CB  LEU A   6      -7.971  23.423   4.851  1.00 40.90           C  
ATOM     62  CG  LEU A   6      -8.429  24.817   5.291  1.00 43.93           C  
ATOM     63  CD1 LEU A   6      -8.997  24.723   6.667  1.00 49.42           C  
ATOM     64  CD2 LEU A   6      -7.346  25.863   5.246  1.00 43.71           C  
ATOM     65  N   ARG A   7      -7.780  21.112   2.460  1.00 44.05           N  
ATOM     66  CA  ARG A   7      -7.457  19.736   2.198  1.00 46.82           C  
ATOM     67  C   ARG A   7      -6.729  19.584   0.886  1.00 45.69           C  
ATOM     68  O   ARG A   7      -6.261  18.499   0.581  1.00 46.41           O  
ATOM     69  CB  ARG A   7      -8.745  18.886   2.181  1.00 49.10           C  
ATOM     70  CG  ARG A   7      -9.591  18.964   3.501  1.00 49.33           C  
ATOM     71  CD  ARG A   7     -10.726  17.945   3.480  1.00 54.00           C  
ATOM     72  NE  ARG A   7     -11.819  18.247   4.413  1.00 62.45           N  
ATOM     73  N   LEU A   8      -6.637  20.659   0.101  1.00 43.81           N  
ATOM     74  CA  LEU A   8      -6.006  20.583  -1.217  1.00 43.67           C  
ATOM     75  C   LEU A   8      -4.466  20.595  -1.072  1.00 42.85           C  
ATOM     76  O   LEU A   8      -3.933  20.977  -0.041  1.00 40.15           O  
ATOM     77  CB  LEU A   8      -6.522  21.689  -2.119  1.00 41.94           C  
ATOM     78  CG  LEU A   8      -8.051  21.623  -2.310  1.00 43.00           C  
ATOM     79  CD1 LEU A   8      -8.559  22.849  -3.041  1.00 46.69           C  
ATOM     80  CD2 LEU A   8      -8.414  20.385  -3.057  1.00 43.94           C  
ATOM     81  N   GLN A   9      -3.789  20.089  -2.088  1.00 40.90           N  
ATOM     82  CA  GLN A   9      -2.344  20.046  -2.143  1.00 43.24           C  
ATOM     83  C   GLN A   9      -1.863  21.427  -2.580  1.00 42.51           C  
ATOM     84  O   GLN A   9      -2.508  22.107  -3.383  1.00 39.20           O  
ATOM     85  CB  GLN A   9      -1.884  18.984  -3.145  1.00 41.88           C  
ATOM     86  CG  GLN A   9      -0.428  18.619  -3.049  1.00 42.59           C  
ATOM     87  CD  GLN A   9       0.205  18.294  -4.390  1.00 47.72           C  
ATOM     88  OE1 GLN A   9       0.185  19.104  -5.294  1.00 43.02           O  
ATOM     89  NE2 GLN A   9       0.813  17.111  -4.503  1.00 39.78           N  
ATOM     90  N   PHE A  10      -0.719  21.844  -2.056  1.00 41.02           N  
ATOM     91  CA  PHE A  10      -0.278  23.209  -2.275  1.00 38.20           C  
ATOM     92  C   PHE A  10       0.054  23.372  -3.743  1.00 41.04           C  
ATOM     93  O   PHE A  10      -0.369  24.350  -4.356  1.00 43.49           O  
ATOM     94  CB  PHE A  10       0.899  23.563  -1.324  1.00 38.65           C  
ATOM     95  CG  PHE A  10       1.368  24.993  -1.428  1.00 37.79           C  
ATOM     96  CD1 PHE A  10       0.459  26.054  -1.345  1.00 38.98           C  
ATOM     97  CD2 PHE A  10       2.712  25.285  -1.648  1.00 36.32           C  
ATOM     98  CE1 PHE A  10       0.884  27.384  -1.467  1.00 39.88           C  
ATOM     99  CE2 PHE A  10       3.132  26.610  -1.753  1.00 39.18           C  
ATOM    100  CZ  PHE A  10       2.200  27.653  -1.674  1.00 37.18           C  
ATOM    101  N   GLY A  11       0.805  22.418  -4.303  1.00 42.01           N  
ATOM    102  CA  GLY A  11       1.188  22.433  -5.727  1.00 47.08           C  
ATOM    103  C   GLY A  11       0.069  22.561  -6.760  1.00 48.46           C  
ATOM    104  O   GLY A  11       0.151  23.379  -7.677  1.00 51.61           O  
ATOM    105  N   HIS A  12      -0.955  21.735  -6.611  1.00 48.86           N  
ATOM    106  CA  HIS A  12      -2.188  21.816  -7.399  1.00 48.75           C  
ATOM    107  C   HIS A  12      -2.857  23.189  -7.341  1.00 49.16           C  
ATOM    108  O   HIS A  12      -3.345  23.712  -8.354  1.00 50.47           O  
ATOM    109  CB  HIS A  12      -3.191  20.724  -6.915  1.00 49.35           C  
ATOM    110  CG  HIS A  12      -2.691  19.303  -7.083  1.00 38.49           C  
ATOM    111  ND1 HIS A  12      -3.180  18.245  -6.342  1.00 41.83           N  
ATOM    112  CD2 HIS A  12      -1.729  18.783  -7.881  1.00 45.86           C  
ATOM    113  CE1 HIS A  12      -2.551  17.135  -6.690  1.00 41.69           C  
ATOM    114  NE2 HIS A  12      -1.665  17.431  -7.624  1.00 40.15           N  
ATOM    115  N   LEU A  13      -2.915  23.767  -6.153  1.00 48.88           N  
ATOM    116  CA  LEU A  13      -3.465  25.120  -5.967  1.00 48.92           C  
ATOM    117  C   LEU A  13      -2.619  26.205  -6.651  1.00 48.66           C  
ATOM    118  O   LEU A  13      -3.118  26.994  -7.408  1.00 47.77           O  
ATOM    119  CB  LEU A  13      -3.563  25.466  -4.466  1.00 50.96           C  
ATOM    120  CG  LEU A  13      -4.735  24.893  -3.679  1.00 51.42           C  
ATOM    121  CD1 LEU A  13      -4.623  25.215  -2.172  1.00 47.46           C  
ATOM    122  CD2 LEU A  13      -6.029  25.425  -4.279  1.00 52.28           C  
ATOM    123  N   ILE A  14      -1.334  26.225  -6.333  1.00 47.35           N  
ATOM    124  CA  ILE A  14      -0.392  27.209  -6.841  1.00 46.59           C  
ATOM    125  C   ILE A  14      -0.199  27.149  -8.363  1.00 47.86           C  
ATOM    126  O   ILE A  14       0.197  28.142  -9.013  1.00 45.55           O  
ATOM    127  CB  ILE A  14       0.965  27.121  -6.009  1.00 46.15           C  
ATOM    128  CG1 ILE A  14       1.717  28.453  -6.047  1.00 52.77           C  
ATOM    129  CG2 ILE A  14       1.886  25.944  -6.429  1.00 39.92           C  
ATOM    130  CD1 ILE A  14       2.144  28.916  -4.709  1.00 46.91           C  
ATOM    131  N   ARG A  15      -0.484  25.978  -8.923  1.00 49.01           N  
ATOM    132  CA  ARG A  15      -0.522  25.787 -10.378  1.00 49.51           C  
ATOM    133  C   ARG A  15      -1.827  26.244 -11.068  1.00 47.80           C  
ATOM    134  O   ARG A  15      -1.782  27.085 -11.960  1.00 43.15           O  
ATOM    135  CB  ARG A  15      -0.261  24.314 -10.707  1.00 52.76           C  
ATOM    136  CG  ARG A  15       1.176  23.953 -10.701  1.00 51.81           C  
ATOM    137  CD  ARG A  15       1.385  22.544 -11.137  1.00 60.84           C  
ATOM    138  NE  ARG A  15       2.811  22.292 -11.350  1.00 63.71           N  
ATOM    139  CZ  ARG A  15       3.611  21.643 -10.508  1.00 74.28           C  
ATOM    140  NH1 ARG A  15       3.148  21.138  -9.359  1.00 84.25           N  
ATOM    141  NH2 ARG A  15       4.897  21.485 -10.815  1.00 74.82           N  
ATOM    142  N   ILE A  16      -2.964  25.679 -10.657  1.00 47.80           N  
ATOM    143  CA  ILE A  16      -4.232  25.889 -11.366  1.00 47.72           C  
ATOM    144  C   ILE A  16      -4.819  27.260 -11.129  1.00 45.56           C  
ATOM    145  O   ILE A  16      -5.263  27.871 -12.048  1.00 44.53           O  
ATOM    146  CB  ILE A  16      -5.343  24.866 -11.022  1.00 48.39           C  
ATOM    147  CG1 ILE A  16      -4.977  23.439 -11.464  1.00 49.36           C  
ATOM    148  CG2 ILE A  16      -6.608  25.267 -11.749  1.00 46.65           C  
ATOM    149  CD1 ILE A  16      -5.769  22.404 -10.758  1.00 59.06           C  
ATOM    150  N   LEU A  17      -4.757  27.758  -9.903  1.00 46.22           N  
ATOM    151  CA  LEU A  17      -5.479  28.980  -9.557  1.00 46.24           C  
ATOM    152  C   LEU A  17      -4.855  30.242 -10.170  1.00 46.10           C  
ATOM    153  O   LEU A  17      -5.567  31.028 -10.797  1.00 44.00           O  
ATOM    154  CB  LEU A  17      -5.669  29.087  -8.051  1.00 45.41           C  
ATOM    155  CG  LEU A  17      -7.092  28.751  -7.590  1.00 44.81           C  
ATOM    156  CD1 LEU A  17      -7.646  27.439  -8.141  1.00 40.50           C  
ATOM    157  CD2 LEU A  17      -7.144  28.765  -6.068  1.00 44.56           C  
ATOM    158  N   PRO A  18      -3.525  30.454 -10.005  1.00 43.57           N  
ATOM    159  CA  PRO A  18      -2.843  31.425 -10.876  1.00 43.21           C  
ATOM    160  C   PRO A  18      -2.975  31.272 -12.405  1.00 43.69           C  
ATOM    161  O   PRO A  18      -3.056  32.287 -13.112  1.00 41.93           O  
ATOM    162  CB  PRO A  18      -1.392  31.261 -10.459  1.00 43.00           C  
ATOM    163  CG  PRO A  18      -1.521  31.003  -9.010  1.00 40.93           C  
ATOM    164  CD  PRO A  18      -2.601  29.968  -8.982  1.00 44.31           C  
ATOM    165  N   THR A  19      -2.940  30.047 -12.938  1.00 44.72           N  
ATOM    166  CA  THR A  19      -3.132  29.884 -14.385  1.00 45.19           C  
ATOM    167  C   THR A  19      -4.506  30.483 -14.818  1.00 45.62           C  
ATOM    168  O   THR A  19      -4.620  31.221 -15.801  1.00 49.55           O  
ATOM    169  CB  THR A  19      -3.033  28.392 -14.780  1.00 48.15           C  
ATOM    170  OG1 THR A  19      -1.700  27.955 -14.600  1.00 45.76           O  
ATOM    171  CG2 THR A  19      -3.436  28.140 -16.238  1.00 54.19           C  
ATOM    172  N   LEU A  20      -5.559  30.177 -14.071  1.00 44.89           N  
ATOM    173  CA  LEU A  20      -6.883  30.683 -14.411  1.00 41.70           C  
ATOM    174  C   LEU A  20      -7.001  32.203 -14.250  1.00 40.00           C  
ATOM    175  O   LEU A  20      -7.686  32.876 -15.039  1.00 38.29           O  
ATOM    176  CB  LEU A  20      -7.940  29.996 -13.552  1.00 43.98           C  
ATOM    177  CG  LEU A  20      -8.277  28.516 -13.600  1.00 48.91           C  
ATOM    178  CD1 LEU A  20      -9.361  28.238 -12.555  1.00 46.82           C  
ATOM    179  CD2 LEU A  20      -8.766  28.139 -14.970  1.00 50.19           C  
ATOM    180  N   LEU A  21      -6.364  32.760 -13.224  1.00 37.62           N  
ATOM    181  CA  LEU A  21      -6.299  34.233 -13.096  1.00 42.11           C  
ATOM    182  C   LEU A  21      -5.579  34.917 -14.303  1.00 44.81           C  
ATOM    183  O   LEU A  21      -5.987  35.975 -14.782  1.00 43.55           O  
ATOM    184  CB  LEU A  21      -5.662  34.612 -11.756  1.00 40.05           C  
ATOM    185  CG  LEU A  21      -5.686  36.059 -11.320  1.00 43.08           C  
ATOM    186  CD1 LEU A  21      -7.073  36.549 -10.988  1.00 43.85           C  
ATOM    187  CD2 LEU A  21      -4.782  36.162 -10.148  1.00 44.57           C  
ATOM    188  N   GLU A  22      -4.525  34.288 -14.800  1.00 46.38           N  
ATOM    189  CA  GLU A  22      -3.744  34.873 -15.880  1.00 46.77           C  
ATOM    190  C   GLU A  22      -4.476  34.835 -17.224  1.00 44.15           C  
ATOM    191  O   GLU A  22      -4.382  35.787 -17.982  1.00 44.14           O  
ATOM    192  CB  GLU A  22      -2.372  34.189 -15.947  1.00 48.17           C  
ATOM    193  CG  GLU A  22      -1.459  34.569 -14.770  1.00 51.96           C  
ATOM    194  CD  GLU A  22      -0.223  33.656 -14.602  1.00 54.11           C  
ATOM    195  OE1 GLU A  22       0.183  32.963 -15.569  1.00 56.22           O  
ATOM    196  OE2 GLU A  22       0.342  33.657 -13.481  1.00 63.16           O  
ATOM    197  N   PHE A  23      -5.207  33.749 -17.504  1.00 42.12           N  
ATOM    198  CA  PHE A  23      -6.137  33.683 -18.641  1.00 37.35           C  
ATOM    199  C   PHE A  23      -7.212  34.752 -18.521  1.00 38.52           C  
ATOM    200  O   PHE A  23      -7.524  35.447 -19.488  1.00 41.11           O  
ATOM    201  CB  PHE A  23      -6.856  32.346 -18.726  1.00 35.30           C  
ATOM    202  CG  PHE A  23      -6.051  31.219 -19.346  1.00 32.48           C  
ATOM    203  CD1 PHE A  23      -5.515  31.340 -20.624  1.00 37.30           C  
ATOM    204  CD2 PHE A  23      -5.882  30.018 -18.654  1.00 44.33           C  
ATOM    205  CE1 PHE A  23      -4.782  30.298 -21.207  1.00 48.86           C  
ATOM    206  CE2 PHE A  23      -5.160  28.957 -19.200  1.00 42.23           C  
ATOM    207  CZ  PHE A  23      -4.600  29.085 -20.501  1.00 44.41           C  
ATOM    208  N   GLU A  24      -7.790  34.881 -17.342  1.00 40.46           N  
ATOM    209  CA  GLU A  24      -8.837  35.875 -17.094  1.00 41.50           C  
ATOM    210  C   GLU A  24      -8.369  37.319 -17.294  1.00 42.69           C  
ATOM    211  O   GLU A  24      -9.091  38.138 -17.850  1.00 40.53           O  
ATOM    212  CB  GLU A  24      -9.313  35.702 -15.664  1.00 43.43           C  
ATOM    213  CG  GLU A  24     -10.702  36.200 -15.334  1.00 50.52           C  
ATOM    214  CD  GLU A  24     -11.027  35.917 -13.868  1.00 48.07           C  
ATOM    215  OE1 GLU A  24     -10.505  36.649 -13.004  1.00 52.72           O  
ATOM    216  OE2 GLU A  24     -11.783  34.955 -13.598  1.00 65.10           O  
ATOM    217  N   LYS A  25      -7.169  37.638 -16.808  1.00 44.23           N  
ATOM    218  CA  LYS A  25      -6.587  38.955 -17.045  1.00 44.15           C  
ATOM    219  C   LYS A  25      -6.395  39.206 -18.546  1.00 43.46           C  
ATOM    220  O   LYS A  25      -6.544  40.318 -18.993  1.00 43.09           O  
ATOM    221  CB  LYS A  25      -5.288  39.161 -16.237  1.00 41.81           C  
ATOM    222  CG  LYS A  25      -5.532  38.978 -14.728  1.00 45.57           C  
ATOM    223  CD  LYS A  25      -4.643  39.810 -13.782  1.00 45.56           C  
ATOM    224  CE  LYS A  25      -3.512  39.021 -13.158  1.00 53.83           C  
ATOM    225  NZ  LYS A  25      -3.163  39.536 -11.793  1.00 53.98           N  
ATOM    226  N   LYS A  26      -6.111  38.176 -19.329  1.00 43.71           N  
ATOM    227  CA  LYS A  26      -6.002  38.334 -20.791  1.00 46.03           C  
ATOM    228  C   LYS A  26      -7.344  38.328 -21.554  1.00 43.00           C  
ATOM    229  O   LYS A  26      -7.348  38.482 -22.762  1.00 42.00           O  
ATOM    230  CB  LYS A  26      -5.088  37.231 -21.365  1.00 49.22           C  
ATOM    231  CG  LYS A  26      -3.601  37.341 -20.942  1.00 49.75           C  
ATOM    232  CD  LYS A  26      -2.779  36.138 -21.489  1.00 51.74           C  
ATOM    233  CE  LYS A  26      -1.324  36.101 -20.935  1.00 56.38           C  
ATOM    234  NZ  LYS A  26      -1.243  36.075 -19.417  1.00 51.59           N  
ATOM    235  N   GLY A  27      -8.469  38.097 -20.864  1.00 42.85           N  
ATOM    236  CA  GLY A  27      -9.784  37.940 -21.501  1.00 40.37           C  
ATOM    237  C   GLY A  27     -10.076  36.579 -22.161  1.00 41.53           C  
ATOM    238  O   GLY A  27     -11.024  36.458 -22.913  1.00 41.98           O  
ATOM    239  N   TYR A  28      -9.297  35.546 -21.859  1.00 38.38           N  
ATOM    240  CA  TYR A  28      -9.417  34.271 -22.554  1.00 39.61           C  
ATOM    241  C   TYR A  28     -10.140  33.241 -21.687  1.00 38.86           C  
ATOM    242  O   TYR A  28      -9.881  33.148 -20.495  1.00 40.72           O  
ATOM    243  CB  TYR A  28      -8.024  33.754 -22.937  1.00 39.28           C  
ATOM    244  CG  TYR A  28      -7.971  32.553 -23.861  1.00 35.26           C  
ATOM    245  CD1 TYR A  28      -8.132  32.701 -25.218  1.00 33.58           C  
ATOM    246  CD2 TYR A  28      -7.680  31.272 -23.379  1.00 45.95           C  
ATOM    247  CE1 TYR A  28      -8.078  31.631 -26.088  1.00 37.62           C  
ATOM    248  CE2 TYR A  28      -7.609  30.145 -24.269  1.00 36.55           C  
ATOM    249  CZ  TYR A  28      -7.797  30.344 -25.612  1.00 43.09           C  
ATOM    250  OH  TYR A  28      -7.740  29.269 -26.495  1.00 37.42           O  
ATOM    251  N   GLU A  29     -11.064  32.513 -22.321  1.00 40.77           N  
ATOM    252  CA  GLU A  29     -11.799  31.387 -21.750  1.00 40.86           C  
ATOM    253  C   GLU A  29     -11.245  30.047 -22.199  1.00 40.18           C  
ATOM    254  O   GLU A  29     -11.603  29.572 -23.294  1.00 38.55           O  
ATOM    255  CB  GLU A  29     -13.270  31.449 -22.181  1.00 39.51           C  
ATOM    256  CG  GLU A  29     -13.966  32.633 -21.595  1.00 47.42           C  
ATOM    257  CD  GLU A  29     -15.322  32.864 -22.196  1.00 53.62           C  
ATOM    258  OE1 GLU A  29     -15.566  32.506 -23.368  1.00 53.53           O  
ATOM    259  OE2 GLU A  29     -16.145  33.437 -21.490  1.00 57.70           O  
ATOM    260  N   PRO A  30     -10.406  29.421 -21.346  1.00 39.67           N  
ATOM    261  CA  PRO A  30      -9.714  28.221 -21.733  1.00 40.65           C  
ATOM    262  C   PRO A  30     -10.519  26.941 -21.495  1.00 42.68           C  
ATOM    263  O   PRO A  30     -11.345  26.857 -20.548  1.00 44.57           O  
ATOM    264  CB  PRO A  30      -8.497  28.243 -20.828  1.00 37.38           C  
ATOM    265  CG  PRO A  30      -9.085  28.725 -19.560  1.00 41.52           C  
ATOM    266  CD  PRO A  30     -10.035  29.809 -19.973  1.00 37.74           C  
ATOM    267  N   SER A  31     -10.267  25.960 -22.352  1.00 39.81           N  
ATOM    268  CA  SER A  31     -10.871  24.632 -22.209  1.00 38.21           C  
ATOM    269  C   SER A  31     -10.205  23.891 -21.058  1.00 38.44           C  
ATOM    270  O   SER A  31      -9.136  24.254 -20.623  1.00 41.26           O  
ATOM    271  CB  SER A  31     -10.655  23.839 -23.472  1.00 37.28           C  
ATOM    272  OG  SER A  31      -9.253  23.552 -23.553  1.00 39.09           O  
ATOM    273  N   LEU A  32     -10.847  22.854 -20.537  1.00 40.57           N  
ATOM    274  CA  LEU A  32     -10.251  22.044 -19.447  1.00 40.99           C  
ATOM    275  C   LEU A  32      -8.872  21.543 -19.842  1.00 39.18           C  
ATOM    276  O   LEU A  32      -7.984  21.486 -19.040  1.00 41.93           O  
ATOM    277  CB  LEU A  32     -11.160  20.861 -19.086  1.00 39.44           C  
ATOM    278  CG  LEU A  32     -12.581  21.224 -18.617  1.00 38.47           C  
ATOM    279  CD1 LEU A  32     -13.267  19.954 -18.241  1.00 29.25           C  
ATOM    280  CD2 LEU A  32     -12.587  22.172 -17.457  1.00 34.96           C  
ATOM    281  N   ALA A  33      -8.726  21.183 -21.112  1.00 39.61           N  
ATOM    282  CA  ALA A  33      -7.498  20.698 -21.680  1.00 41.53           C  
ATOM    283  C   ALA A  33      -6.393  21.808 -21.674  1.00 43.66           C  
ATOM    284  O   ALA A  33      -5.223  21.531 -21.380  1.00 42.11           O  
ATOM    285  CB  ALA A  33      -7.792  20.208 -23.101  1.00 39.66           C  
ATOM    286  N   GLU A  34      -6.761  23.051 -22.017  1.00 42.47           N  
ATOM    287  CA  GLU A  34      -5.801  24.179 -22.041  1.00 42.16           C  
ATOM    288  C   GLU A  34      -5.399  24.537 -20.635  1.00 44.19           C  
ATOM    289  O   GLU A  34      -4.242  24.901 -20.390  1.00 45.49           O  
ATOM    290  CB  GLU A  34      -6.388  25.436 -22.716  1.00 43.09           C  
ATOM    291  CG  GLU A  34      -6.478  25.354 -24.243  1.00 48.80           C  
ATOM    292  CD  GLU A  34      -7.271  26.505 -24.859  1.00 41.88           C  
ATOM    293  OE1 GLU A  34      -8.330  26.863 -24.341  1.00 43.84           O  
ATOM    294  OE2 GLU A  34      -6.864  26.999 -25.911  1.00 39.81           O  
ATOM    295  N   ILE A  35      -6.365  24.479 -19.710  1.00 42.24           N  
ATOM    296  CA  ILE A  35      -6.078  24.687 -18.289  1.00 40.76           C  
ATOM    297  C   ILE A  35      -5.043  23.691 -17.764  1.00 41.67           C  
ATOM    298  O   ILE A  35      -4.087  24.063 -17.047  1.00 43.83           O  
ATOM    299  CB  ILE A  35      -7.351  24.590 -17.407  1.00 41.52           C  
ATOM    300  CG1 ILE A  35      -8.322  25.727 -17.750  1.00 38.11           C  
ATOM    301  CG2 ILE A  35      -6.916  24.544 -15.898  1.00 39.98           C  
ATOM    302  CD1 ILE A  35      -9.796  25.520 -17.284  1.00 40.50           C  
ATOM    303  N   VAL A  36      -5.230  22.417 -18.090  1.00 42.32           N  
ATOM    304  CA  VAL A  36      -4.266  21.393 -17.680  1.00 44.02           C  
ATOM    305  C   VAL A  36      -2.885  21.656 -18.289  1.00 44.31           C  
ATOM    306  O   VAL A  36      -1.861  21.626 -17.593  1.00 44.83           O  
ATOM    307  CB  VAL A  36      -4.772  19.975 -18.045  1.00 45.88           C  
ATOM    308  CG1 VAL A  36      -3.671  18.933 -17.899  1.00 42.41           C  
ATOM    309  CG2 VAL A  36      -5.964  19.636 -17.182  1.00 40.12           C  
ATOM    310  N   LYS A  37      -2.875  21.895 -19.588  1.00 43.97           N  
ATOM    311  CA  LYS A  37      -1.665  22.137 -20.361  1.00 42.38           C  
ATOM    312  C   LYS A  37      -0.887  23.328 -19.851  1.00 44.58           C  
ATOM    313  O   LYS A  37       0.304  23.195 -19.614  1.00 43.81           O  
ATOM    314  CB  LYS A  37      -2.020  22.364 -21.836  1.00 44.59           C  
ATOM    315  CG  LYS A  37      -0.788  22.564 -22.803  1.00 50.59           C  
ATOM    316  CD  LYS A  37       0.352  21.583 -22.513  1.00 57.21           C  
ATOM    317  N   ALA A  38      -1.537  24.492 -19.694  1.00 42.57           N  
ATOM    318  CA  ALA A  38      -0.845  25.715 -19.170  1.00 44.23           C  
ATOM    319  C   ALA A  38      -0.367  25.573 -17.708  1.00 46.05           C  
ATOM    320  O   ALA A  38       0.712  26.054 -17.335  1.00 47.84           O  
ATOM    321  CB  ALA A  38      -1.760  27.005 -19.345  1.00 41.15           C  
ATOM    322  N   SER A  39      -1.158  24.900 -16.872  1.00 48.86           N  
ATOM    323  CA  SER A  39      -0.851  24.750 -15.402  1.00 45.88           C  
ATOM    324  C   SER A  39       0.207  23.718 -15.074  1.00 44.67           C  
ATOM    325  O   SER A  39       0.920  23.857 -14.098  1.00 47.68           O  
ATOM    326  CB  SER A  39      -2.102  24.328 -14.639  1.00 46.67           C  
ATOM    327  OG  SER A  39      -2.432  22.992 -14.959  1.00 48.24           O  
ATOM    328  N   GLY A  40       0.282  22.645 -15.832  1.00 45.33           N  
ATOM    329  CA  GLY A  40       1.307  21.642 -15.584  1.00 45.55           C  
ATOM    330  C   GLY A  40       0.855  20.528 -14.645  1.00 46.93           C  
ATOM    331  O   GLY A  40       1.637  19.661 -14.323  1.00 45.28           O  
ATOM    332  N   VAL A  41      -0.419  20.489 -14.247  1.00 48.56           N  
ATOM    333  CA  VAL A  41      -0.918  19.321 -13.513  1.00 48.69           C  
ATOM    334  C   VAL A  41      -1.080  18.155 -14.506  1.00 48.11           C  
ATOM    335  O   VAL A  41      -1.125  18.361 -15.707  1.00 45.77           O  
ATOM    336  CB  VAL A  41      -2.224  19.582 -12.765  1.00 49.51           C  
ATOM    337  CG1 VAL A  41      -2.021  20.749 -11.761  1.00 48.07           C  
ATOM    338  CG2 VAL A  41      -3.344  19.820 -13.759  1.00 47.44           C  
ATOM    339  N   SER A  42      -1.117  16.920 -14.013  1.00 47.98           N  
ATOM    340  CA  SER A  42      -1.325  15.804 -14.925  1.00 47.92           C  
ATOM    341  C   SER A  42      -2.812  15.743 -15.266  1.00 46.35           C  
ATOM    342  O   SER A  42      -3.679  16.081 -14.428  1.00 48.33           O  
ATOM    343  CB  SER A  42      -0.785  14.491 -14.334  1.00 47.77           C  
ATOM    344  OG  SER A  42      -1.711  13.809 -13.512  1.00 52.43           O  
ATOM    345  N   GLU A  43      -3.128  15.343 -16.489  0.50 46.54           N  
ATOM    347  CA  GLU A  43      -4.526  15.217 -16.885  0.50 45.30           C  
ATOM    349  C   GLU A  43      -5.226  14.116 -16.087  0.50 44.89           C  
ATOM    351  O   GLU A  43      -6.395  14.256 -15.747  0.50 44.47           O  
ATOM    353  CB  GLU A  43      -4.667  15.015 -18.398  0.50 45.49           C  
ATOM    355  CG  GLU A  43      -4.809  16.342 -19.156  0.50 47.45           C  
ATOM    357  CD  GLU A  43      -4.944  16.170 -20.634  0.50 43.73           C  
ATOM    359  OE1 GLU A  43      -4.497  15.121 -21.129  0.50 43.50           O  
ATOM    361  OE2 GLU A  43      -5.494  17.080 -21.293  0.50 38.02           O  
ATOM    363  N   LYS A  44      -4.501  13.051 -15.754  1.00 45.37           N  
ATOM    364  CA  LYS A  44      -5.031  11.988 -14.896  1.00 45.83           C  
ATOM    365  C   LYS A  44      -5.395  12.494 -13.481  1.00 44.75           C  
ATOM    366  O   LYS A  44      -6.509  12.285 -13.031  1.00 46.71           O  
ATOM    367  CB  LYS A  44      -4.042  10.824 -14.821  1.00 46.59           C  
ATOM    368  CG  LYS A  44      -4.681   9.410 -14.774  1.00 52.31           C  
ATOM    369  CD  LYS A  44      -5.271   9.033 -13.424  1.00 52.67           C  
ATOM    370  CE  LYS A  44      -6.729   8.579 -13.554  1.00 48.71           C  
ATOM    371  NZ  LYS A  44      -6.843   7.182 -14.111  1.00 47.14           N  
ATOM    372  N   THR A  45      -4.481  13.177 -12.807  1.00 43.23           N  
ATOM    373  CA  THR A  45      -4.801  13.901 -11.553  1.00 45.42           C  
ATOM    374  C   THR A  45      -6.004  14.871 -11.660  1.00 44.45           C  
ATOM    375  O   THR A  45      -6.827  14.934 -10.755  1.00 45.28           O  
ATOM    376  CB  THR A  45      -3.596  14.781 -11.073  1.00 48.12           C  
ATOM    377  OG1 THR A  45      -2.448  13.964 -10.846  1.00 47.08           O  
ATOM    378  CG2 THR A  45      -3.932  15.493  -9.790  1.00 43.49           C  
ATOM    379  N   PHE A  46      -6.077  15.640 -12.747  1.00 43.97           N  
ATOM    380  CA  PHE A  46      -7.192  16.582 -12.976  1.00 43.12           C  
ATOM    381  C   PHE A  46      -8.556  15.894 -13.090  1.00 47.04           C  
ATOM    382  O   PHE A  46      -9.491  16.156 -12.321  1.00 49.19           O  
ATOM    383  CB  PHE A  46      -6.927  17.391 -14.234  1.00 44.83           C  
ATOM    384  CG  PHE A  46      -7.828  18.615 -14.397  1.00 44.87           C  
ATOM    385  CD1 PHE A  46      -7.595  19.782 -13.666  1.00 45.57           C  
ATOM    386  CD2 PHE A  46      -8.901  18.602 -15.285  1.00 41.16           C  
ATOM    387  CE1 PHE A  46      -8.423  20.936 -13.833  1.00 42.25           C  
ATOM    388  CE2 PHE A  46      -9.727  19.730 -15.430  1.00 35.43           C  
ATOM    389  CZ  PHE A  46      -9.479  20.887 -14.715  1.00 39.43           C  
ATOM    390  N   PHE A  47      -8.655  14.964 -14.030  1.00 49.24           N  
ATOM    391  CA  PHE A  47      -9.923  14.331 -14.360  1.00 48.11           C  
ATOM    392  C   PHE A  47     -10.334  13.207 -13.444  1.00 46.79           C  
ATOM    393  O   PHE A  47     -11.435  12.689 -13.581  1.00 44.67           O  
ATOM    394  CB  PHE A  47      -9.891  13.839 -15.835  1.00 51.38           C  
ATOM    395  CG  PHE A  47      -9.902  14.970 -16.828  1.00 46.96           C  
ATOM    396  CD1 PHE A  47     -11.087  15.635 -17.112  1.00 49.52           C  
ATOM    397  CD2 PHE A  47      -8.721  15.402 -17.439  1.00 50.72           C  
ATOM    398  CE1 PHE A  47     -11.093  16.712 -17.988  1.00 48.20           C  
ATOM    399  CE2 PHE A  47      -8.717  16.475 -18.321  1.00 41.69           C  
ATOM    400  CZ  PHE A  47      -9.891  17.142 -18.581  1.00 48.29           C  
HETATM  401  N   MSE A  48      -9.438  12.795 -12.548  1.00 46.84           N  
HETATM  402  CA  MSE A  48      -9.671  11.677 -11.654  1.00 44.05           C  
HETATM  403  C   MSE A  48      -9.874  12.180 -10.232  1.00 44.39           C  
HETATM  404  O   MSE A  48      -9.743  11.414  -9.305  1.00 46.03           O  
HETATM  405  CB  MSE A  48      -8.488  10.681 -11.691  1.00 44.00           C  
ATOM    406  N   GLY A  49     -10.168  13.467 -10.069  1.00 43.33           N  
ATOM    407  CA  GLY A  49     -10.496  14.025  -8.754  1.00 43.26           C  
ATOM    408  C   GLY A  49     -10.244  15.505  -8.519  1.00 42.11           C  
ATOM    409  O   GLY A  49     -11.029  16.157  -7.858  1.00 45.24           O  
ATOM    410  N   LEU A  50      -9.155  16.050  -9.023  1.00 40.94           N  
ATOM    411  CA  LEU A  50      -8.780  17.451  -8.687  1.00 41.56           C  
ATOM    412  C   LEU A  50      -9.819  18.510  -9.065  1.00 41.57           C  
ATOM    413  O   LEU A  50     -10.219  19.345  -8.243  1.00 44.05           O  
ATOM    414  CB  LEU A  50      -7.415  17.803  -9.291  1.00 41.61           C  
ATOM    415  CG  LEU A  50      -6.847  19.198  -8.998  1.00 42.42           C  
ATOM    416  CD1 LEU A  50      -6.862  19.564  -7.477  1.00 39.53           C  
ATOM    417  CD2 LEU A  50      -5.433  19.274  -9.566  1.00 39.65           C  
ATOM    418  N   LYS A  51     -10.258  18.483 -10.306  1.00 41.00           N  
ATOM    419  CA  LYS A  51     -11.318  19.369 -10.761  1.00 42.63           C  
ATOM    420  C   LYS A  51     -12.503  19.432  -9.814  1.00 43.00           C  
ATOM    421  O   LYS A  51     -12.940  20.498  -9.410  1.00 44.18           O  
ATOM    422  CB  LYS A  51     -11.822  18.921 -12.140  1.00 43.41           C  
ATOM    423  CG  LYS A  51     -12.741  19.927 -12.807  1.00 42.13           C  
ATOM    424  CD  LYS A  51     -13.191  19.521 -14.215  1.00 39.20           C  
ATOM    425  CE  LYS A  51     -13.983  18.254 -14.288  1.00 42.58           C  
ATOM    426  NZ  LYS A  51     -15.431  18.396 -13.971  1.00 43.44           N  
ATOM    427  N   ASP A  52     -13.048  18.281  -9.492  1.00 44.03           N  
ATOM    428  CA  ASP A  52     -14.234  18.239  -8.644  1.00 44.50           C  
ATOM    429  C   ASP A  52     -13.946  18.738  -7.225  1.00 42.17           C  
ATOM    430  O   ASP A  52     -14.836  19.290  -6.590  1.00 42.69           O  
ATOM    431  CB  ASP A  52     -14.848  16.826  -8.645  1.00 43.87           C  
ATOM    432  CG  ASP A  52     -15.624  16.503  -9.936  1.00 50.74           C  
ATOM    433  OD1 ASP A  52     -15.873  17.403 -10.799  1.00 51.24           O  
ATOM    434  OD2 ASP A  52     -16.002  15.320 -10.083  1.00 57.54           O  
ATOM    435  N   ARG A  53     -12.713  18.579  -6.746  1.00 39.81           N  
ATOM    436  CA  ARG A  53     -12.334  19.093  -5.431  1.00 42.54           C  
ATOM    437  C   ARG A  53     -12.261  20.602  -5.408  1.00 43.08           C  
ATOM    438  O   ARG A  53     -12.583  21.224  -4.374  1.00 45.41           O  
ATOM    439  CB  ARG A  53     -10.988  18.529  -4.924  1.00 42.29           C  
ATOM    440  CG  ARG A  53     -11.060  17.037  -4.584  1.00 42.46           C  
ATOM    441  CD  ARG A  53      -9.884  16.526  -3.775  1.00 42.34           C  
ATOM    442  NE  ARG A  53      -8.642  16.531  -4.537  1.00 47.85           N  
ATOM    443  CZ  ARG A  53      -8.224  15.578  -5.378  1.00 47.46           C  
ATOM    444  NH1 ARG A  53      -8.932  14.479  -5.611  1.00 47.87           N  
ATOM    445  NH2 ARG A  53      -7.049  15.722  -5.979  1.00 48.18           N  
ATOM    446  N   LEU A  54     -11.798  21.194  -6.510  1.00 45.01           N  
ATOM    447  CA  LEU A  54     -11.743  22.660  -6.629  1.00 43.33           C  
ATOM    448  C   LEU A  54     -13.154  23.219  -6.696  1.00 44.96           C  
ATOM    449  O   LEU A  54     -13.430  24.264  -6.132  1.00 44.53           O  
ATOM    450  CB  LEU A  54     -10.969  23.078  -7.866  1.00 44.97           C  
ATOM    451  CG  LEU A  54      -9.515  22.690  -7.907  1.00 42.32           C  
ATOM    452  CD1 LEU A  54      -8.971  22.818  -9.303  1.00 37.06           C  
ATOM    453  CD2 LEU A  54      -8.683  23.501  -6.914  1.00 41.46           C  
ATOM    454  N   ILE A  55     -14.054  22.509  -7.388  1.00 46.86           N  
ATOM    455  CA  ILE A  55     -15.476  22.874  -7.382  1.00 45.46           C  
ATOM    456  C   ILE A  55     -16.094  22.773  -5.955  1.00 47.54           C  
ATOM    457  O   ILE A  55     -16.719  23.728  -5.471  1.00 45.34           O  
ATOM    458  CB  ILE A  55     -16.322  22.058  -8.409  1.00 44.57           C  
ATOM    459  CG1 ILE A  55     -15.867  22.318  -9.862  1.00 41.52           C  
ATOM    460  CG2 ILE A  55     -17.802  22.456  -8.272  1.00 38.09           C  
ATOM    461  CD1 ILE A  55     -16.465  21.381 -10.910  1.00 41.20           C  
ATOM    462  N   ARG A  56     -15.926  21.619  -5.315  0.50 48.84           N  
ATOM    464  CA  ARG A  56     -16.393  21.410  -3.948  0.50 49.08           C  
ATOM    466  C   ARG A  56     -15.903  22.515  -3.021  0.50 47.61           C  
ATOM    468  O   ARG A  56     -16.677  23.072  -2.257  0.50 51.06           O  
ATOM    470  CB  ARG A  56     -15.889  20.075  -3.404  0.50 50.17           C  
ATOM    472  CG  ARG A  56     -16.683  18.852  -3.840  0.50 52.65           C  
ATOM    474  CD  ARG A  56     -16.180  17.590  -3.106  0.50 52.65           C  
ATOM    476  NE  ARG A  56     -15.128  16.881  -3.835  0.50 52.52           N  
ATOM    478  CZ  ARG A  56     -15.337  16.106  -4.895  0.50 49.44           C  
ATOM    480  NH1 ARG A  56     -16.567  15.936  -5.381  0.50 51.34           N  
ATOM    482  NH2 ARG A  56     -14.308  15.505  -5.480  0.50 53.13           N  
ATOM    484  N   ALA A  57     -14.614  22.822  -3.090  1.00 46.74           N  
ATOM    485  CA  ALA A  57     -14.006  23.855  -2.247  1.00 42.83           C  
ATOM    486  C   ALA A  57     -14.417  25.312  -2.523  1.00 43.36           C  
ATOM    487  O   ALA A  57     -13.933  26.232  -1.832  1.00 43.85           O  
ATOM    488  CB  ALA A  57     -12.534  23.735  -2.312  1.00 40.40           C  
ATOM    489  N   GLY A  58     -15.302  25.544  -3.507  1.00 44.54           N  
ATOM    490  CA  GLY A  58     -15.875  26.890  -3.747  1.00 41.87           C  
ATOM    491  C   GLY A  58     -14.916  27.813  -4.473  1.00 40.76           C  
ATOM    492  O   GLY A  58     -15.061  29.045  -4.427  1.00 39.80           O  
ATOM    493  N   LEU A  59     -13.941  27.214  -5.162  1.00 40.37           N  
ATOM    494  CA  LEU A  59     -12.831  27.970  -5.788  1.00 41.70           C  
ATOM    495  C   LEU A  59     -13.057  28.241  -7.275  1.00 40.97           C  
ATOM    496  O   LEU A  59     -12.505  29.201  -7.838  1.00 42.25           O  
ATOM    497  CB  LEU A  59     -11.478  27.222  -5.593  1.00 38.93           C  
ATOM    498  CG  LEU A  59     -10.906  27.091  -4.172  1.00 39.17           C  
ATOM    499  CD1 LEU A  59      -9.619  26.329  -4.217  1.00 41.14           C  
ATOM    500  CD2 LEU A  59     -10.701  28.440  -3.524  1.00 33.64           C  
ATOM    501  N   VAL A  60     -13.852  27.382  -7.904  1.00 40.88           N  
ATOM    502  CA  VAL A  60     -14.135  27.474  -9.337  1.00 42.24           C  
ATOM    503  C   VAL A  60     -15.521  26.929  -9.592  1.00 44.50           C  
ATOM    504  O   VAL A  60     -16.051  26.190  -8.789  1.00 44.27           O  
ATOM    505  CB  VAL A  60     -13.123  26.675 -10.274  1.00 42.79           C  
ATOM    506  CG1 VAL A  60     -11.743  27.272 -10.234  1.00 36.42           C  
ATOM    507  CG2 VAL A  60     -13.060  25.151  -9.953  1.00 38.15           C  
ATOM    508  N   LYS A  61     -16.090  27.307 -10.729  1.00 45.64           N  
ATOM    509  CA  LYS A  61     -17.295  26.674 -11.219  1.00 48.86           C  
ATOM    510  C   LYS A  61     -17.103  26.285 -12.675  1.00 43.78           C  
ATOM    511  O   LYS A  61     -16.473  27.000 -13.413  1.00 43.97           O  
ATOM    512  CB  LYS A  61     -18.495  27.619 -11.065  1.00 51.21           C  
ATOM    513  CG  LYS A  61     -19.807  26.867 -10.905  1.00 62.68           C  
ATOM    514  CD  LYS A  61     -19.817  25.998  -9.609  1.00 63.03           C  
ATOM    515  CE  LYS A  61     -20.246  24.540  -9.881  1.00 64.55           C  
ATOM    516  NZ  LYS A  61     -19.636  23.943 -11.142  1.00 33.46           N  
ATOM    517  N   GLU A  62     -17.626  25.128 -13.057  1.00 44.96           N  
ATOM    518  CA  GLU A  62     -17.532  24.604 -14.422  1.00 44.25           C  
ATOM    519  C   GLU A  62     -18.686  25.123 -15.265  1.00 45.40           C  
ATOM    520  O   GLU A  62     -19.844  25.143 -14.810  1.00 47.17           O  
ATOM    521  CB  GLU A  62     -17.540  23.069 -14.421  1.00 44.12           C  
ATOM    522  CG  GLU A  62     -16.902  22.479 -15.665  1.00 47.10           C  
ATOM    523  CD  GLU A  62     -16.913  20.985 -15.689  1.00 46.60           C  
ATOM    524  OE1 GLU A  62     -17.205  20.390 -14.649  1.00 59.26           O  
ATOM    525  OE2 GLU A  62     -16.645  20.411 -16.758  1.00 55.91           O  
ATOM    526  N   GLU A  63     -18.368  25.558 -16.478  1.00 45.35           N  
ATOM    527  CA  GLU A  63     -19.369  26.038 -17.407  1.00 46.73           C  
ATOM    528  C   GLU A  63     -19.118  25.438 -18.780  1.00 47.19           C  
ATOM    529  O   GLU A  63     -18.000  25.071 -19.120  1.00 48.34           O  
ATOM    530  CB  GLU A  63     -19.323  27.561 -17.513  1.00 45.22           C  
ATOM    531  CG  GLU A  63     -19.580  28.289 -16.189  1.00 55.68           C  
ATOM    532  CD  GLU A  63     -20.165  29.678 -16.374  1.00 57.90           C  
ATOM    533  OE1 GLU A  63     -19.801  30.384 -17.345  1.00 65.87           O  
ATOM    534  OE2 GLU A  63     -21.000  30.062 -15.535  1.00 69.97           O  
ATOM    535  N   THR A  64     -20.176  25.343 -19.559  1.00 48.66           N  
ATOM    536  CA  THR A  64     -20.083  24.969 -20.964  1.00 49.12           C  
ATOM    537  C   THR A  64     -19.468  26.097 -21.762  1.00 50.01           C  
ATOM    538  O   THR A  64     -19.931  27.233 -21.661  1.00 52.77           O  
ATOM    539  CB  THR A  64     -21.452  24.703 -21.533  1.00 45.69           C  
ATOM    540  OG1 THR A  64     -21.988  23.555 -20.876  1.00 50.53           O  
ATOM    541  CG2 THR A  64     -21.358  24.461 -23.023  1.00 41.56           C  
ATOM    542  N   LEU A  65     -18.445  25.773 -22.553  1.00 48.67           N  
ATOM    543  CA  LEU A  65     -17.814  26.719 -23.469  1.00 50.61           C  
ATOM    544  C   LEU A  65     -18.498  26.594 -24.857  1.00 54.02           C  
ATOM    545  O   LEU A  65     -19.182  27.522 -25.361  1.00 51.34           O  
ATOM    546  CB  LEU A  65     -16.325  26.411 -23.517  1.00 50.57           C  
ATOM    547  CG  LEU A  65     -15.356  27.512 -23.924  1.00 54.47           C  
ATOM    548  CD1 LEU A  65     -15.380  28.683 -22.931  1.00 52.80           C  
ATOM    549  CD2 LEU A  65     -13.969  26.930 -24.039  1.00 50.17           C  
ATOM    550  N   SER A  66     -18.360  25.417 -25.459  1.00 56.54           N  
ATOM    551  CA  SER A  66     -19.125  25.085 -26.656  1.00 57.97           C  
ATOM    552  C   SER A  66     -19.512  23.595 -26.625  1.00 59.45           C  
ATOM    553  O   SER A  66     -19.446  22.940 -25.569  1.00 61.26           O  
ATOM    554  CB  SER A  66     -18.348  25.494 -27.920  1.00 58.26           C  
ATOM    555  OG  SER A  66     -17.136  24.793 -28.020  1.00 56.57           O  
ATOM    556  N   TYR A  67     -19.982  23.065 -27.742  1.00 57.47           N  
ATOM    557  CA  TYR A  67     -20.283  21.637 -27.803  1.00 58.38           C  
ATOM    558  C   TYR A  67     -19.082  20.802 -27.372  1.00 58.34           C  
ATOM    559  O   TYR A  67     -18.000  20.883 -27.993  1.00 58.41           O  
ATOM    560  CB  TYR A  67     -20.666  21.243 -29.235  1.00 60.88           C  
ATOM    561  CG  TYR A  67     -21.059  19.784 -29.399  1.00 59.51           C  
ATOM    562  CD1 TYR A  67     -22.056  19.218 -28.608  1.00 63.62           C  
ATOM    563  CD2 TYR A  67     -20.442  18.982 -30.358  1.00 62.86           C  
ATOM    564  CE1 TYR A  67     -22.429  17.882 -28.762  1.00 72.13           C  
ATOM    565  CE2 TYR A  67     -20.803  17.650 -30.531  1.00 66.22           C  
ATOM    566  CZ  TYR A  67     -21.801  17.100 -29.736  1.00 69.03           C  
ATOM    567  OH  TYR A  67     -22.165  15.774 -29.913  1.00 70.02           O  
ATOM    568  N   ARG A  68     -19.247  20.000 -26.321  1.00 56.03           N  
ATOM    569  CA  ARG A  68     -18.183  19.070 -25.933  1.00 54.46           C  
ATOM    570  C   ARG A  68     -17.015  19.755 -25.193  1.00 55.30           C  
ATOM    571  O   ARG A  68     -16.023  19.086 -24.856  1.00 57.42           O  
ATOM    572  CB  ARG A  68     -17.637  18.350 -27.188  1.00 52.81           C  
ATOM    573  N   VAL A  69     -17.120  21.059 -24.922  1.00 49.72           N  
ATOM    574  CA  VAL A  69     -15.992  21.798 -24.346  1.00 49.19           C  
ATOM    575  C   VAL A  69     -16.454  22.612 -23.152  1.00 46.51           C  
ATOM    576  O   VAL A  69     -17.383  23.426 -23.263  1.00 38.65           O  
ATOM    577  CB  VAL A  69     -15.241  22.665 -25.388  1.00 49.49           C  
ATOM    578  CG1 VAL A  69     -14.033  23.349 -24.770  1.00 53.71           C  
ATOM    579  CG2 VAL A  69     -14.791  21.775 -26.536  1.00 46.94           C  
ATOM    580  N   LYS A  70     -15.793  22.336 -22.019  1.00 45.69           N  
ATOM    581  CA  LYS A  70     -16.065  22.965 -20.726  1.00 45.07           C  
ATOM    582  C   LYS A  70     -14.905  23.867 -20.322  1.00 42.29           C  
ATOM    583  O   LYS A  70     -13.788  23.722 -20.780  1.00 38.74           O  
ATOM    584  CB  LYS A  70     -16.273  21.913 -19.633  1.00 46.50           C  
ATOM    585  CG  LYS A  70     -17.439  20.923 -19.866  1.00 49.39           C  
ATOM    586  CD  LYS A  70     -18.779  21.619 -19.774  1.00 57.39           C  
ATOM    587  CE  LYS A  70     -19.951  20.634 -19.618  1.00 57.58           C  
ATOM    588  NZ  LYS A  70     -20.242  20.358 -18.168  1.00 69.63           N  
ATOM    589  N   THR A  71     -15.193  24.804 -19.446  1.00 41.57           N  
ATOM    590  CA  THR A  71     -14.182  25.685 -18.900  1.00 40.91           C  
ATOM    591  C   THR A  71     -14.387  25.735 -17.392  1.00 42.02           C  
ATOM    592  O   THR A  71     -15.395  25.215 -16.870  1.00 38.88           O  
ATOM    593  CB  THR A  71     -14.272  27.085 -19.573  1.00 40.61           C  
ATOM    594  OG1 THR A  71     -13.129  27.874 -19.227  1.00 39.56           O  
ATOM    595  CG2 THR A  71     -15.533  27.809 -19.224  1.00 34.92           C  
ATOM    596  N   LEU A  72     -13.407  26.283 -16.683  1.00 43.27           N  
ATOM    597  CA  LEU A  72     -13.570  26.636 -15.262  1.00 41.18           C  
ATOM    598  C   LEU A  72     -13.584  28.133 -15.157  1.00 45.67           C  
ATOM    599  O   LEU A  72     -12.751  28.792 -15.793  1.00 42.23           O  
ATOM    600  CB  LEU A  72     -12.427  26.071 -14.393  1.00 41.95           C  
ATOM    601  CG  LEU A  72     -12.318  24.524 -14.383  1.00 33.62           C  
ATOM    602  CD1 LEU A  72     -11.141  24.031 -13.596  1.00 34.85           C  
ATOM    603  CD2 LEU A  72     -13.600  23.844 -13.879  1.00 37.32           C  
ATOM    604  N   LYS A  73     -14.547  28.665 -14.378  1.00 44.49           N  
ATOM    605  CA  LYS A  73     -14.554  30.079 -13.985  1.00 47.21           C  
ATOM    606  C   LYS A  73     -14.168  30.229 -12.492  1.00 46.18           C  
ATOM    607  O   LYS A  73     -14.704  29.547 -11.628  1.00 46.28           O  
ATOM    608  CB  LYS A  73     -15.935  30.697 -14.234  1.00 47.54           C  
ATOM    609  CG  LYS A  73     -16.148  31.296 -15.625  1.00 55.03           C  
ATOM    610  CD  LYS A  73     -15.919  32.798 -15.626  1.00 63.81           C  
ATOM    611  N   LEU A  74     -13.237  31.121 -12.198  1.00 44.59           N  
ATOM    612  CA  LEU A  74     -12.936  31.466 -10.824  1.00 43.03           C  
ATOM    613  C   LEU A  74     -14.144  32.068 -10.090  1.00 42.50           C  
ATOM    614  O   LEU A  74     -14.916  32.787 -10.685  1.00 40.31           O  
ATOM    615  CB  LEU A  74     -11.781  32.449 -10.779  1.00 43.77           C  
ATOM    616  CG  LEU A  74     -10.384  31.933 -11.080  1.00 36.71           C  
ATOM    617  CD1 LEU A  74      -9.509  33.180 -11.314  1.00 33.06           C  
ATOM    618  CD2 LEU A  74      -9.794  31.059  -9.999  1.00 33.87           C  
ATOM    619  N   THR A  75     -14.309  31.740  -8.800  1.00 44.17           N  
ATOM    620  CA  THR A  75     -15.305  32.382  -7.932  1.00 41.62           C  
ATOM    621  C   THR A  75     -14.566  33.605  -7.365  1.00 44.47           C  
ATOM    622  O   THR A  75     -13.354  33.723  -7.578  1.00 45.26           O  
ATOM    623  CB  THR A  75     -15.772  31.445  -6.801  1.00 41.64           C  
ATOM    624  OG1 THR A  75     -14.634  30.885  -6.123  1.00 45.43           O  
ATOM    625  CG2 THR A  75     -16.648  30.308  -7.321  1.00 34.15           C  
ATOM    626  N   GLU A  76     -15.271  34.505  -6.675  0.50 44.15           N  
ATOM    628  CA  GLU A  76     -14.617  35.673  -6.076  0.50 43.97           C  
ATOM    630  C   GLU A  76     -13.556  35.235  -5.035  0.50 44.07           C  
ATOM    632  O   GLU A  76     -12.482  35.832  -4.950  0.50 43.86           O  
ATOM    634  CB  GLU A  76     -15.648  36.655  -5.490  0.50 45.13           C  
ATOM    636  CG  GLU A  76     -16.453  37.443  -6.560  0.50 43.06           C  
ATOM    638  CD  GLU A  76     -17.634  38.224  -5.987  0.50 42.59           C  
ATOM    640  OE1 GLU A  76     -17.500  38.748  -4.862  0.50 42.18           O  
ATOM    642  OE2 GLU A  76     -18.691  38.328  -6.664  0.50 30.87           O  
ATOM    644  N   LYS A  77     -13.860  34.179  -4.275  1.00 43.81           N  
ATOM    645  CA  LYS A  77     -12.910  33.521  -3.370  1.00 43.57           C  
ATOM    646  C   LYS A  77     -11.725  32.850  -4.065  1.00 46.02           C  
ATOM    647  O   LYS A  77     -10.608  32.892  -3.556  1.00 48.91           O  
ATOM    648  CB  LYS A  77     -13.644  32.450  -2.594  1.00 42.27           C  
ATOM    649  CG  LYS A  77     -12.775  31.655  -1.663  1.00 49.60           C  
ATOM    650  CD  LYS A  77     -13.648  30.782  -0.763  1.00 49.80           C  
ATOM    651  CE  LYS A  77     -12.956  29.507  -0.330  1.00 49.74           C  
ATOM    652  NZ  LYS A  77     -13.951  28.407  -0.155  1.00 42.00           N  
ATOM    653  N   GLY A  78     -11.976  32.187  -5.198  1.00 44.48           N  
ATOM    654  CA  GLY A  78     -10.912  31.576  -5.965  1.00 43.39           C  
ATOM    655  C   GLY A  78     -10.007  32.621  -6.557  1.00 42.40           C  
ATOM    656  O   GLY A  78      -8.809  32.433  -6.610  1.00 43.25           O  
ATOM    657  N   ARG A  79     -10.577  33.738  -7.000  1.00 43.72           N  
ATOM    658  CA  ARG A  79      -9.776  34.848  -7.530  1.00 45.45           C  
ATOM    659  C   ARG A  79      -8.998  35.587  -6.438  1.00 45.25           C  
ATOM    660  O   ARG A  79      -7.862  35.988  -6.650  1.00 46.01           O  
ATOM    661  CB  ARG A  79     -10.668  35.815  -8.303  1.00 46.07           C  
ATOM    662  CG  ARG A  79     -10.017  37.168  -8.656  1.00 48.39           C  
ATOM    663  CD  ARG A  79     -10.907  37.974  -9.617  1.00 52.59           C  
ATOM    664  NE  ARG A  79     -11.682  37.112 -10.536  1.00 57.47           N  
ATOM    665  CZ  ARG A  79     -12.995  36.840 -10.452  1.00 55.93           C  
ATOM    666  NH1 ARG A  79     -13.764  37.334  -9.473  1.00 62.21           N  
ATOM    667  NH2 ARG A  79     -13.544  36.025 -11.356  1.00 47.13           N  
ATOM    668  N   ARG A  80      -9.611  35.787  -5.279  1.00 44.12           N  
ATOM    669  CA  ARG A  80      -8.902  36.379  -4.168  1.00 45.96           C  
ATOM    670  C   ARG A  80      -7.685  35.522  -3.765  1.00 44.90           C  
ATOM    671  O   ARG A  80      -6.581  36.054  -3.550  1.00 45.88           O  
ATOM    672  CB  ARG A  80      -9.853  36.616  -2.974  1.00 45.64           C  
ATOM    673  CG  ARG A  80     -10.796  37.795  -3.176  1.00 52.21           C  
ATOM    674  CD  ARG A  80     -11.653  38.060  -1.942  1.00 52.25           C  
ATOM    675  NE  ARG A  80     -10.848  38.618  -0.864  1.00 60.59           N  
ATOM    676  CZ  ARG A  80     -11.249  38.738   0.401  1.00 62.67           C  
ATOM    677  NH1 ARG A  80     -12.459  38.334   0.776  1.00 67.70           N  
ATOM    678  NH2 ARG A  80     -10.428  39.263   1.304  1.00 61.53           N  
ATOM    679  N   LEU A  81      -7.886  34.208  -3.674  1.00 41.94           N  
ATOM    680  CA  LEU A  81      -6.808  33.273  -3.354  1.00 43.01           C  
ATOM    681  C   LEU A  81      -5.757  33.163  -4.460  1.00 42.96           C  
ATOM    682  O   LEU A  81      -4.565  33.154  -4.154  1.00 43.91           O  
ATOM    683  CB  LEU A  81      -7.378  31.890  -3.050  1.00 42.36           C  
ATOM    684  CG  LEU A  81      -6.461  30.894  -2.333  1.00 48.85           C  
ATOM    685  CD1 LEU A  81      -6.016  31.392  -0.933  1.00 54.88           C  
ATOM    686  CD2 LEU A  81      -7.178  29.565  -2.233  1.00 49.45           C  
ATOM    687  N   ALA A  82      -6.186  33.066  -5.727  1.00 39.68           N  
ATOM    688  CA  ALA A  82      -5.292  33.092  -6.878  1.00 39.03           C  
ATOM    689  C   ALA A  82      -4.242  34.228  -6.797  1.00 43.55           C  
ATOM    690  O   ALA A  82      -3.040  34.009  -7.019  1.00 40.94           O  
ATOM    691  CB  ALA A  82      -6.121  33.203  -8.198  1.00 37.89           C  
ATOM    692  N   GLU A  83      -4.708  35.434  -6.470  1.00 44.47           N  
ATOM    693  CA  GLU A  83      -3.836  36.588  -6.325  1.00 48.07           C  
ATOM    694  C   GLU A  83      -2.838  36.403  -5.186  1.00 48.88           C  
ATOM    695  O   GLU A  83      -1.671  36.741  -5.336  1.00 48.44           O  
ATOM    696  CB  GLU A  83      -4.647  37.870  -6.097  1.00 49.22           C  
ATOM    697  CG  GLU A  83      -5.395  38.373  -7.318  1.00 51.24           C  
ATOM    698  CD  GLU A  83      -4.510  39.225  -8.280  1.00 61.92           C  
ATOM    699  OE1 GLU A  83      -3.255  39.206  -8.159  1.00 51.31           O  
ATOM    700  OE2 GLU A  83      -5.086  39.903  -9.174  1.00 56.93           O  
ATOM    701  N   CYS A  84      -3.292  35.862  -4.054  1.00 49.17           N  
ATOM    702  CA  CYS A  84      -2.386  35.556  -2.956  1.00 48.18           C  
ATOM    703  C   CYS A  84      -1.379  34.508  -3.370  1.00 46.10           C  
ATOM    704  O   CYS A  84      -0.215  34.618  -3.063  1.00 47.20           O  
ATOM    705  CB  CYS A  84      -3.149  35.078  -1.720  1.00 47.47           C  
ATOM    706  SG  CYS A  84      -4.228  36.341  -1.023  1.00 55.82           S  
ATOM    707  N   LEU A  85      -1.824  33.486  -4.074  1.00 48.64           N  
ATOM    708  CA  LEU A  85      -0.902  32.435  -4.569  1.00 50.25           C  
ATOM    709  C   LEU A  85       0.114  32.888  -5.644  1.00 51.95           C  
ATOM    710  O   LEU A  85       1.095  32.185  -5.909  1.00 53.90           O  
ATOM    711  CB  LEU A  85      -1.696  31.234  -5.074  1.00 48.10           C  
ATOM    712  CG  LEU A  85      -2.490  30.519  -3.986  1.00 48.25           C  
ATOM    713  CD1 LEU A  85      -3.485  29.561  -4.575  1.00 41.18           C  
ATOM    714  CD2 LEU A  85      -1.544  29.806  -3.032  1.00 42.79           C  
ATOM    715  N   GLU A  86      -0.106  34.051  -6.260  1.00 52.42           N  
ATOM    716  CA  GLU A  86       0.836  34.581  -7.260  1.00 51.08           C  
ATOM    717  C   GLU A  86       2.091  35.039  -6.558  1.00 49.53           C  
ATOM    718  O   GLU A  86       3.176  34.908  -7.101  1.00 48.39           O  
ATOM    719  CB  GLU A  86       0.244  35.768  -8.033  1.00 51.97           C  
ATOM    720  CG  GLU A  86      -0.879  35.425  -8.995  1.00 55.31           C  
ATOM    721  CD  GLU A  86      -0.398  34.984 -10.384  1.00 62.47           C  
ATOM    722  OE1 GLU A  86       0.758  34.513 -10.501  1.00 61.61           O  
ATOM    723  OE2 GLU A  86      -1.200  35.070 -11.353  1.00 52.84           O  
ATOM    724  N   LYS A  87       1.927  35.577  -5.347  1.00 48.54           N  
ATOM    725  CA  LYS A  87       3.040  36.077  -4.574  1.00 47.23           C  
ATOM    726  C   LYS A  87       3.812  34.896  -3.986  1.00 46.06           C  
ATOM    727  O   LYS A  87       5.041  34.920  -3.915  1.00 44.92           O  
ATOM    728  CB  LYS A  87       2.573  37.036  -3.475  1.00 49.35           C  
ATOM    729  CG  LYS A  87       1.529  38.075  -3.885  1.00 53.52           C  
ATOM    730  CD  LYS A  87       1.878  38.814  -5.157  1.00 62.84           C  
ATOM    731  CE  LYS A  87       0.672  39.597  -5.670  1.00 69.90           C  
ATOM    732  NZ  LYS A  87      -0.406  38.739  -6.272  1.00 63.62           N  
ATOM    733  N   CYS A  88       3.095  33.856  -3.582  1.00 46.87           N  
ATOM    734  CA  CYS A  88       3.734  32.637  -3.128  1.00 49.03           C  
ATOM    735  C   CYS A  88       4.673  32.146  -4.223  1.00 51.95           C  
ATOM    736  O   CYS A  88       5.787  31.759  -3.934  1.00 52.39           O  
ATOM    737  CB  CYS A  88       2.700  31.540  -2.786  1.00 49.57           C  
ATOM    738  SG  CYS A  88       1.744  31.829  -1.275  1.00 45.95           S  
ATOM    739  N   ARG A  89       4.220  32.159  -5.477  1.00 55.10           N  
ATOM    740  CA  ARG A  89       5.052  31.712  -6.605  1.00 58.10           C  
ATOM    741  C   ARG A  89       6.355  32.493  -6.745  1.00 57.63           C  
ATOM    742  O   ARG A  89       7.383  31.900  -7.049  1.00 56.96           O  
ATOM    743  CB  ARG A  89       4.287  31.796  -7.917  1.00 58.26           C  
ATOM    744  CG  ARG A  89       3.448  30.601  -8.227  1.00 61.57           C  
ATOM    745  CD  ARG A  89       2.695  30.771  -9.570  1.00 63.49           C  
ATOM    746  NE  ARG A  89       3.549  31.241 -10.665  1.00 69.07           N  
ATOM    747  CZ  ARG A  89       3.134  31.462 -11.915  1.00 71.96           C  
ATOM    748  NH1 ARG A  89       1.866  31.241 -12.269  1.00 72.38           N  
ATOM    749  NH2 ARG A  89       4.000  31.897 -12.824  1.00 70.59           N  
ATOM    750  N   ASP A  90       6.302  33.810  -6.522  1.00 59.14           N  
ATOM    751  CA  ASP A  90       7.496  34.668  -6.565  1.00 60.86           C  
ATOM    752  C   ASP A  90       8.535  34.190  -5.574  1.00 61.70           C  
ATOM    753  O   ASP A  90       9.690  33.983  -5.941  1.00 62.77           O  
ATOM    754  CB  ASP A  90       7.164  36.133  -6.233  1.00 61.94           C  
ATOM    755  CG  ASP A  90       6.255  36.786  -7.260  1.00 62.55           C  
ATOM    756  OD1 ASP A  90       6.021  36.198  -8.335  1.00 56.75           O  
ATOM    757  OD2 ASP A  90       5.772  37.904  -6.989  1.00 70.47           O  
ATOM    758  N   VAL A  91       8.106  34.037  -4.316  1.00 61.15           N  
ATOM    759  CA  VAL A  91       8.941  33.518  -3.244  1.00 60.13           C  
ATOM    760  C   VAL A  91       9.615  32.221  -3.673  1.00 60.81           C  
ATOM    761  O   VAL A  91      10.839  32.088  -3.576  1.00 64.52           O  
ATOM    762  CB  VAL A  91       8.126  33.268  -1.936  1.00 60.82           C  
ATOM    763  CG1 VAL A  91       8.919  32.362  -0.952  1.00 56.98           C  
ATOM    764  CG2 VAL A  91       7.722  34.605  -1.297  1.00 54.93           C  
ATOM    765  N   LEU A  92       8.820  31.267  -4.135  1.00 59.48           N  
ATOM    766  CA  LEU A  92       9.346  29.996  -4.606  1.00 60.38           C  
ATOM    767  C   LEU A  92      10.002  30.217  -5.967  1.00 61.27           C  
ATOM    768  O   LEU A  92      11.213  30.072  -6.094  1.00 62.85           O  
ATOM    769  CB  LEU A  92       8.243  28.939  -4.743  1.00 60.28           C  
ATOM    770  CG  LEU A  92       7.098  28.797  -3.732  1.00 62.63           C  
ATOM    771  CD1 LEU A  92       6.123  27.698  -4.236  1.00 61.04           C  
ATOM    772  CD2 LEU A  92       7.622  28.519  -2.342  1.00 50.80           C  
TER     773      LEU A  92                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
