
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  141 ( 1069),  selected  141 , name 1r5t_A
# Molecule2: number of CA atoms  162 ( 1272),  selected  162 , name T0461.pdb
# PARAMETERS: 1r5t_A.T0461.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_A      E      16           -
LGA    V     3_A      N      17           -
LGA    G     4_A      L      18           -
LGA    G     5_A      Y      19           #
LGA    -       -      F      20           -
LGA    I     6_A      Q      21          2.717
LGA    E     7_A      S      22          1.141
LGA    D     8_A      M      23          2.387
LGA    R     9_A      E      24          3.071
LGA    Q    10_A      E      25          1.831
LGA    L    11_A      T      26          0.681
LGA    E    12_A      E      27          1.885
LGA    A    13_A      K      28          1.803
LGA    L    14_A      W      29          1.064
LGA    K    15_A      M      30          0.709
LGA    R    16_A      E      31          1.492
LGA    A    17_A      E      32          1.643
LGA    A    18_A      A      33          0.706
LGA    L    19_A      M      34          0.613
LGA    K    20_A      H      35          1.626
LGA    A    21_A      M      36          1.775
LGA    C    22_A      A      37          1.686
LGA    E    23_A      K      38          4.123
LGA    L    24_A      E      39          4.487
LGA    S    25_A      A      40          2.590
LGA    Y    26_A      L      41           #
LGA    -       -      E      42           -
LGA    -       -      N      43           -
LGA    S    27_A      T      44          3.562
LGA    P    28_A      E      45           #
LGA    Y    29_A      -       -           -
LGA    S    30_A      -       -           -
LGA    H    31_A      -       -           -
LGA    F    32_A      V      46          2.661
LGA    R    33_A      P      47          1.126
LGA    V    34_A      V      48          0.692
LGA    G    35_A      G      49          0.740
LGA    C    36_A      C      50          0.878
LGA    S    37_A      L      51          1.256
LGA    I    38_A      M      52          1.129
LGA    L    39_A      V      53          0.858
LGA    T    40_A      Y      54          1.201
LGA    N    41_A      N      55          2.686
LGA    N    42_A      N      56          4.406
LGA    D    43_A      E      57          3.057
LGA    V    44_A      V      58          2.653
LGA    I    45_A      V      59          4.962
LGA    F    46_A      G      60          2.809
LGA    T    47_A      K      61          1.701
LGA    G    48_A      G      62          0.652
LGA    A    49_A      R      63          0.484
LGA    N    50_A      N      64          0.596
LGA    V    51_A      E      65          1.093
LGA    E    52_A      V      66          1.392
LGA    N    53_A      N      67          3.384
LGA    A    54_A      Q      68           -
LGA    S    55_A      T      69           -
LGA    Y    56_A      K      70           #
LGA    S    57_A      N      71          5.793
LGA    N    58_A      A      72          2.725
LGA    C    59_A      T      73          3.804
LGA    I    60_A      R      74          0.999
LGA    C    61_A      H      75          0.752
LGA    A    62_A      A      76          0.867
LGA    E    63_A      E      77          1.007
LGA    R    64_A      M      78          1.090
LGA    S    65_A      V      79          1.048
LGA    A    66_A      A      80          1.269
LGA    M    67_A      I      81          1.361
LGA    I    68_A      D      82          1.191
LGA    Q    69_A      Q      83          0.966
LGA    V    70_A      V      84          1.095
LGA    L    71_A      L      85          1.222
LGA    M    72_A      D      86          0.966
LGA    A    73_A      W      87          0.891
LGA    G    74_A      C      88          0.540
LGA    H    75_A      R      89           #
LGA    -       -      Q      90           -
LGA    -       -      S      91           -
LGA    -       -      G      92           -
LGA    -       -      K      93           -
LGA    -       -      S      94           -
LGA    R    76_A      P      95          1.448
LGA    S    77_A      S      96          3.755
LGA    -       -      E      97           -
LGA    -       -      V      98           -
LGA    -       -      F      99           -
LGA    G    78_A      E     100          3.535
LGA    W    79_A      H     101          3.255
LGA    K    80_A      T     102          3.192
LGA    C    81_A      V     103          1.332
LGA    M    82_A      L     104          1.158
LGA    V    83_A      Y     105          1.317
LGA    I    84_A      V     106          1.007
LGA    C    85_A      T     107          0.708
LGA    G    86_A      -       -           -
LGA    D    87_A      -       -           -
LGA    S    88_A      -       -           -
LGA    E    89_A      -       -           -
LGA    D    90_A      -       -           -
LGA    Q    91_A      -       -           -
LGA    C    92_A      -       -           -
LGA    V    93_A      V     108          2.347
LGA    S    94_A      E     109          1.115
LGA    P    95_A      P     110          0.443
LGA    C    96_A      C     111          0.422
LGA    G    97_A      I     112          0.936
LGA    V    98_A      M     113          0.681
LGA    C    99_A      C     114          0.444
LGA    R   100_A      A     115          0.894
LGA    Q   101_A      A     116          1.450
LGA    F   102_A      A     117          1.310
LGA    I   103_A      L     118          1.194
LGA    N   104_A      R     119          1.385
LGA    E   105_A      L     120          1.919
LGA    F   106_A      M     121          1.846
LGA    V   107_A      K     122          1.965
LGA    V   108_A      I     123          5.066
LGA    K   109_A      -       -           -
LGA    D   110_A      -       -           -
LGA    F   111_A      P     124          1.440
LGA    P   112_A      L     125          1.633
LGA    I   113_A      V     126          1.038
LGA    V   114_A      V     127          1.224
LGA    M   115_A      Y     128          1.400
LGA    L   116_A      G     129          0.833
LGA    N   117_A      C     130          3.329
LGA    S   118_A      -       -           -
LGA    T   119_A      -       -           -
LGA    G   120_A      -       -           -
LGA    S   121_A      -       -           -
LGA    R   122_A      -       -           -
LGA    S   123_A      -       -           -
LGA    K   124_A      Q     131           #
LGA    V   125_A      N     132           -
LGA    M   126_A      E     133           -
LGA    T   127_A      R     134           -
LGA    M   128_A      F     135           -
LGA    G   129_A      G     136           -
LGA    E   130_A      G     137           -
LGA    L   131_A      C     138          3.659
LGA    -       -      G     139           -
LGA    -       -      S     140           -
LGA    -       -      V     141           -
LGA    -       -      L     142           -
LGA    -       -      N     143           -
LGA    -       -      I     144           -
LGA    L   132_A      A     145          2.767
LGA    -       -      S     146           -
LGA    P   133_A      A     147          0.826
LGA    M   134_A      D     148          3.132
LGA    A   135_A      L     149          4.058
LGA    -       -      P     150           -
LGA    -       -      N     151           -
LGA    F   136_A      T     152          3.603
LGA    G   137_A      G     153          4.846
LGA    P   138_A      R     154           -
LGA    S   139_A      P     155           -
LGA    H   140_A      F     156           -
LGA    L   141_A      Q     157           -
LGA    N   142_A      C     158           -
LGA    -       -      I     159           -
LGA    -       -      P     160           -
LGA    -       -      G     161           -
LGA    -       -      Y     162           -
LGA    -       -      R     163           -
LGA    -       -      A     164           -
LGA    -       -      E     165           -
LGA    -       -      E     166           -
LGA    -       -      A     167           -
LGA    -       -      V     168           -
LGA    -       -      E     169           -
LGA    -       -      M     170           -
LGA    -       -      L     171           -
LGA    -       -      K     172           -
LGA    -       -      T     173           -
LGA    -       -      F     174           -
LGA    -       -      Y     175           -
LGA    -       -      K     176           -
LGA    -       -      Q     177           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  141  162    5.0    101    2.23    23.76     44.694     4.334

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.923537 * X  +  -0.253783 * Y  +  -0.287529 * Z  +  37.240963
  Y_new =  -0.332950 * X  +   0.158500 * Y  +   0.929528 * Z  +  -8.199738
  Z_new =  -0.190325 * X  +   0.954187 * Y  +  -0.230877 * Z  +  17.129925 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.808196   -1.333396  [ DEG:   103.6020    -76.3980 ]
  Theta =   0.191493    2.950100  [ DEG:    10.9717    169.0283 ]
  Phi   =  -2.795581    0.346012  [ DEG:  -160.1750     19.8250 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1r5t_A                                        
REMARK     2: T0461.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1r5t_A.T0461.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  141  162   5.0  101   2.23   23.76  44.694
REMARK  ---------------------------------------------------------- 
MOLECULE 1r5t_A
HEADER    HYDROLASE                               13-OCT-03   1R5T              
TITLE     THE CRYSTAL STRUCTURE OF CYTIDINE DEAMINASE CDD1, AN ORPHAN           
TITLE    2 C TO U EDITASE FROM YEAST                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CYTIDINE DEAMINASE;                                        
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: CYTIDINE AMINOHYDROLASE, CDA;                               
COMPND   5 EC: 3.5.4.5;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 GENE: CDD1P;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) CODONPLUS(TM);                   
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28A                                    
KEYWDS    ZINC DEPENDENT DEAMINASE, RNA EDITING, APOBEC-1 RELATED               
KEYWDS   2 PROTEIN                                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.XIE,M.P.SOWDEN,G.S.C.DANCE,A.T.TORELLI,H.C.SMITH,                   
AUTHOR   2 J.E.WEDEKIND                                                         
REVDAT   1   25-MAY-04 1R5T    0                                                
JRNL        AUTH   K.XIE,M.P.SOWDEN,G.S.DANCE,A.T.TORELLI,H.C.SMITH,            
JRNL        AUTH 2 J.E.WEDEKIND                                                 
JRNL        TITL   THE STRUCTURE OF A YEAST RNA-EDITING DEAMINASE               
JRNL        TITL 2 PROVIDES INSIGHT INTO THE FOLD AND FUNCTION OF               
JRNL        TITL 3 ACTIVATION-INDUCED DEAMINASE AND APOBEC-1.                   
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V. 101  8114 2004              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1R5T A    1   142  UNP    Q06549   CDD_YEAST        1    142             
DBREF  1R5T B    1   142  UNP    Q06549   CDD_YEAST        1    142             
DBREF  1R5T C    1   142  UNP    Q06549   CDD_YEAST        1    142             
DBREF  1R5T D    1   142  UNP    Q06549   CDD_YEAST        1    142             
SEQRES   1 A  142  MET LYS VAL GLY GLY ILE GLU ASP ARG GLN LEU GLU ALA          
SEQRES   2 A  142  LEU LYS ARG ALA ALA LEU LYS ALA CYS GLU LEU SER TYR          
SEQRES   3 A  142  SER PRO TYR SER HIS PHE ARG VAL GLY CYS SER ILE LEU          
SEQRES   4 A  142  THR ASN ASN ASP VAL ILE PHE THR GLY ALA ASN VAL GLU          
SEQRES   5 A  142  ASN ALA SER TYR SER ASN CYS ILE CYS ALA GLU ARG SER          
SEQRES   6 A  142  ALA MET ILE GLN VAL LEU MET ALA GLY HIS ARG SER GLY          
SEQRES   7 A  142  TRP LYS CYS MET VAL ILE CYS GLY ASP SER GLU ASP GLN          
SEQRES   8 A  142  CYS VAL SER PRO CYS GLY VAL CYS ARG GLN PHE ILE ASN          
SEQRES   9 A  142  GLU PHE VAL VAL LYS ASP PHE PRO ILE VAL MET LEU ASN          
SEQRES  10 A  142  SER THR GLY SER ARG SER LYS VAL MET THR MET GLY GLU          
SEQRES  11 A  142  LEU LEU PRO MET ALA PHE GLY PRO SER HIS LEU ASN              
SEQRES   1 B  142  MET LYS VAL GLY GLY ILE GLU ASP ARG GLN LEU GLU ALA          
SEQRES   2 B  142  LEU LYS ARG ALA ALA LEU LYS ALA CYS GLU LEU SER TYR          
SEQRES   3 B  142  SER PRO TYR SER HIS PHE ARG VAL GLY CYS SER ILE LEU          
SEQRES   4 B  142  THR ASN ASN ASP VAL ILE PHE THR GLY ALA ASN VAL GLU          
SEQRES   5 B  142  ASN ALA SER TYR SER ASN CYS ILE CYS ALA GLU ARG SER          
SEQRES   6 B  142  ALA MET ILE GLN VAL LEU MET ALA GLY HIS ARG SER GLY          
SEQRES   7 B  142  TRP LYS CYS MET VAL ILE CYS GLY ASP SER GLU ASP GLN          
SEQRES   8 B  142  CYS VAL SER PRO CYS GLY VAL CYS ARG GLN PHE ILE ASN          
SEQRES   9 B  142  GLU PHE VAL VAL LYS ASP PHE PRO ILE VAL MET LEU ASN          
SEQRES  10 B  142  SER THR GLY SER ARG SER LYS VAL MET THR MET GLY GLU          
SEQRES  11 B  142  LEU LEU PRO MET ALA PHE GLY PRO SER HIS LEU ASN              
SEQRES   1 C  142  MET LYS VAL GLY GLY ILE GLU ASP ARG GLN LEU GLU ALA          
SEQRES   2 C  142  LEU LYS ARG ALA ALA LEU LYS ALA CYS GLU LEU SER TYR          
SEQRES   3 C  142  SER PRO TYR SER HIS PHE ARG VAL GLY CYS SER ILE LEU          
SEQRES   4 C  142  THR ASN ASN ASP VAL ILE PHE THR GLY ALA ASN VAL GLU          
SEQRES   5 C  142  ASN ALA SER TYR SER ASN CYS ILE CYS ALA GLU ARG SER          
SEQRES   6 C  142  ALA MET ILE GLN VAL LEU MET ALA GLY HIS ARG SER GLY          
SEQRES   7 C  142  TRP LYS CYS MET VAL ILE CYS GLY ASP SER GLU ASP GLN          
SEQRES   8 C  142  CYS VAL SER PRO CYS GLY VAL CYS ARG GLN PHE ILE ASN          
SEQRES   9 C  142  GLU PHE VAL VAL LYS ASP PHE PRO ILE VAL MET LEU ASN          
SEQRES  10 C  142  SER THR GLY SER ARG SER LYS VAL MET THR MET GLY GLU          
SEQRES  11 C  142  LEU LEU PRO MET ALA PHE GLY PRO SER HIS LEU ASN              
SEQRES   1 D  142  MET LYS VAL GLY GLY ILE GLU ASP ARG GLN LEU GLU ALA          
SEQRES   2 D  142  LEU LYS ARG ALA ALA LEU LYS ALA CYS GLU LEU SER TYR          
SEQRES   3 D  142  SER PRO TYR SER HIS PHE ARG VAL GLY CYS SER ILE LEU          
SEQRES   4 D  142  THR ASN ASN ASP VAL ILE PHE THR GLY ALA ASN VAL GLU          
SEQRES   5 D  142  ASN ALA SER TYR SER ASN CYS ILE CYS ALA GLU ARG SER          
SEQRES   6 D  142  ALA MET ILE GLN VAL LEU MET ALA GLY HIS ARG SER GLY          
SEQRES   7 D  142  TRP LYS CYS MET VAL ILE CYS GLY ASP SER GLU ASP GLN          
SEQRES   8 D  142  CYS VAL SER PRO CYS GLY VAL CYS ARG GLN PHE ILE ASN          
SEQRES   9 D  142  GLU PHE VAL VAL LYS ASP PHE PRO ILE VAL MET LEU ASN          
SEQRES  10 D  142  SER THR GLY SER ARG SER LYS VAL MET THR MET GLY GLU          
SEQRES  11 D  142  LEU LEU PRO MET ALA PHE GLY PRO SER HIS LEU ASN              
HET     ZN  A 150       1                                                       
HET     ZN  B 151       1                                                       
HET     ZN  C 152       1                                                       
HET     ZN  D 153       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   5   ZN    4(ZN 2+)                                                     
FORMUL   9  HOH   *318(H2 O)                                                    
CRYST1   78.520   86.370  156.260  90.00  90.00  90.00 C 2 2 21     32          
ATOM      1  N   LYS A   2      -1.406  20.021  45.737  1.00 63.10           N  
ATOM      2  CA  LYS A   2      -0.299  21.009  45.589  1.00 62.45           C  
ATOM      3  C   LYS A   2       1.038  20.475  46.099  1.00 61.96           C  
ATOM      4  O   LYS A   2       1.765  21.147  46.834  1.00 61.85           O  
ATOM      5  CB  LYS A   2      -0.658  22.316  46.300  1.00 62.38           C  
ATOM      6  CG  LYS A   2      -0.676  23.511  45.359  1.00 63.53           C  
ATOM      7  CD  LYS A   2       0.687  23.702  44.716  1.00 63.66           C  
ATOM      8  CE  LYS A   2       0.665  24.769  43.633  1.00 65.18           C  
ATOM      9  NZ  LYS A   2      -0.126  24.349  42.443  1.00 64.82           N  
ATOM     10  N   VAL A   3       1.337  19.243  45.697  1.00 61.33           N  
ATOM     11  CA  VAL A   3       2.584  18.559  46.032  1.00 59.76           C  
ATOM     12  C   VAL A   3       2.929  18.418  47.514  1.00 58.71           C  
ATOM     13  O   VAL A   3       3.404  19.357  48.151  1.00 58.02           O  
ATOM     14  CB  VAL A   3       3.777  19.232  45.325  1.00 58.74           C  
ATOM     15  CG1 VAL A   3       4.822  18.193  44.994  1.00 58.70           C  
ATOM     16  CG2 VAL A   3       3.312  19.942  44.063  1.00 58.82           C  
ATOM     17  N   GLY A   4       2.708  17.220  48.045  1.00 58.33           N  
ATOM     18  CA  GLY A   4       3.002  16.955  49.442  1.00 56.96           C  
ATOM     19  C   GLY A   4       4.479  16.736  49.703  1.00 56.37           C  
ATOM     20  O   GLY A   4       5.193  16.174  48.872  1.00 56.53           O  
ATOM     21  N   GLY A   5       4.939  17.176  50.868  1.00 56.05           N  
ATOM     22  CA  GLY A   5       6.340  17.025  51.214  1.00 56.10           C  
ATOM     23  C   GLY A   5       7.175  18.180  50.692  1.00 55.35           C  
ATOM     24  O   GLY A   5       8.405  18.135  50.734  1.00 54.07           O  
ATOM     25  N   ILE A   6       6.507  19.224  50.207  1.00 54.79           N  
ATOM     26  CA  ILE A   6       7.203  20.384  49.665  1.00 55.33           C  
ATOM     27  C   ILE A   6       6.599  21.700  50.132  1.00 55.54           C  
ATOM     28  O   ILE A   6       5.430  21.986  49.877  1.00 54.46           O  
ATOM     29  CB  ILE A   6       7.181  20.363  48.126  1.00 55.72           C  
ATOM     30  CG1 ILE A   6       7.708  19.020  47.628  1.00 55.05           C  
ATOM     31  CG2 ILE A   6       8.025  21.505  47.572  1.00 54.67           C  
ATOM     32  CD1 ILE A   6       7.610  18.859  46.155  1.00 55.59           C  
ATOM     33  N   GLU A   7       7.417  22.497  50.810  1.00 57.05           N  
ATOM     34  CA  GLU A   7       7.007  23.798  51.326  1.00 58.79           C  
ATOM     35  C   GLU A   7       6.508  24.673  50.182  1.00 59.33           C  
ATOM     36  O   GLU A   7       6.951  24.521  49.043  1.00 59.72           O  
ATOM     37  CB  GLU A   7       8.198  24.478  52.004  1.00 59.81           C  
ATOM     38  CG  GLU A   7       8.922  23.593  53.010  1.00 63.07           C  
ATOM     39  CD  GLU A   7      10.265  24.166  53.424  1.00 66.15           C  
ATOM     40  OE1 GLU A   7      10.958  23.540  54.257  1.00 67.08           O  
ATOM     41  OE2 GLU A   7      10.631  25.245  52.910  1.00 68.11           O  
ATOM     42  N   ASP A   8       5.591  25.589  50.482  1.00 59.60           N  
ATOM     43  CA  ASP A   8       5.055  26.483  49.460  1.00 59.83           C  
ATOM     44  C   ASP A   8       6.145  27.348  48.835  1.00 58.47           C  
ATOM     45  O   ASP A   8       6.136  27.599  47.629  1.00 57.71           O  
ATOM     46  CB  ASP A   8       3.962  27.379  50.046  1.00 62.44           C  
ATOM     47  CG  ASP A   8       2.633  26.661  50.181  1.00 66.24           C  
ATOM     48  OD1 ASP A   8       2.141  26.131  49.159  1.00 68.56           O  
ATOM     49  OD2 ASP A   8       2.078  26.628  51.302  1.00 67.86           O  
ATOM     50  N   ARG A   9       7.083  27.803  49.658  1.00 57.44           N  
ATOM     51  CA  ARG A   9       8.179  28.631  49.174  1.00 56.37           C  
ATOM     52  C   ARG A   9       9.058  27.855  48.197  1.00 54.67           C  
ATOM     53  O   ARG A   9       9.450  28.387  47.158  1.00 55.05           O  
ATOM     54  CB  ARG A   9       9.024  29.134  50.346  1.00 58.12           C  
ATOM     55  CG  ARG A   9       9.404  28.059  51.351  1.00 60.66           C  
ATOM     56  CD  ARG A   9      10.290  28.627  52.446  1.00 64.66           C  
ATOM     57  NE  ARG A   9      10.406  27.716  53.581  1.00 67.85           N  
ATOM     58  CZ  ARG A   9      11.205  27.918  54.624  1.00 69.67           C  
ATOM     59  NH1 ARG A   9      11.967  29.003  54.683  1.00 70.59           N  
ATOM     60  NH2 ARG A   9      11.239  27.036  55.616  1.00 70.21           N  
ATOM     61  N   GLN A  10       9.361  26.603  48.534  1.00 52.45           N  
ATOM     62  CA  GLN A  10      10.191  25.752  47.685  1.00 49.59           C  
ATOM     63  C   GLN A  10       9.527  25.528  46.339  1.00 48.40           C  
ATOM     64  O   GLN A  10      10.166  25.637  45.295  1.00 48.14           O  
ATOM     65  CB  GLN A  10      10.435  24.392  48.346  1.00 48.88           C  
ATOM     66  CG  GLN A  10      11.258  24.437  49.621  1.00 48.63           C  
ATOM     67  CD  GLN A  10      11.572  23.047  50.155  1.00 48.41           C  
ATOM     68  OE1 GLN A  10      10.671  22.262  50.449  1.00 46.37           O  
ATOM     69  NE2 GLN A  10      12.857  22.740  50.280  1.00 48.03           N  
ATOM     70  N   LEU A  11       8.239  25.212  46.366  1.00 47.55           N  
ATOM     71  CA  LEU A  11       7.496  24.970  45.138  1.00 46.49           C  
ATOM     72  C   LEU A  11       7.457  26.231  44.275  1.00 47.01           C  
ATOM     73  O   LEU A  11       7.573  26.157  43.048  1.00 45.49           O  
ATOM     74  CB  LEU A  11       6.080  24.504  45.470  1.00 44.17           C  
ATOM     75  CG  LEU A  11       5.243  23.964  44.311  1.00 44.22           C  
ATOM     76  CD1 LEU A  11       5.936  22.767  43.668  1.00 44.68           C  
ATOM     77  CD2 LEU A  11       3.882  23.565  44.835  1.00 43.51           C  
ATOM     78  N   GLU A  12       7.295  27.389  44.913  1.00 46.59           N  
ATOM     79  CA  GLU A  12       7.267  28.651  44.183  1.00 46.67           C  
ATOM     80  C   GLU A  12       8.620  28.858  43.518  1.00 44.29           C  
ATOM     81  O   GLU A  12       8.701  29.249  42.355  1.00 43.68           O  
ATOM     82  CB  GLU A  12       6.981  29.827  45.123  1.00 51.37           C  
ATOM     83  CG  GLU A  12       5.531  29.947  45.566  1.00 58.50           C  
ATOM     84  CD  GLU A  12       5.256  31.246  46.308  1.00 62.65           C  
ATOM     85  OE1 GLU A  12       5.496  32.326  45.722  1.00 63.23           O  
ATOM     86  OE2 GLU A  12       4.802  31.186  47.474  1.00 64.30           O  
ATOM     87  N   ALA A  13       9.680  28.593  44.275  1.00 41.91           N  
ATOM     88  CA  ALA A  13      11.039  28.736  43.779  1.00 39.90           C  
ATOM     89  C   ALA A  13      11.279  27.781  42.611  1.00 38.83           C  
ATOM     90  O   ALA A  13      11.836  28.178  41.587  1.00 38.45           O  
ATOM     91  CB  ALA A  13      12.031  28.457  44.896  1.00 37.83           C  
ATOM     92  N   LEU A  14      10.858  26.527  42.764  1.00 37.40           N  
ATOM     93  CA  LEU A  14      11.035  25.535  41.706  1.00 36.77           C  
ATOM     94  C   LEU A  14      10.405  25.990  40.400  1.00 36.42           C  
ATOM     95  O   LEU A  14      11.019  25.875  39.340  1.00 35.41           O  
ATOM     96  CB  LEU A  14      10.423  24.187  42.102  1.00 36.24           C  
ATOM     97  CG  LEU A  14      11.312  23.197  42.855  1.00 39.85           C  
ATOM     98  CD1 LEU A  14      10.505  21.936  43.167  1.00 40.31           C  
ATOM     99  CD2 LEU A  14      12.541  22.855  42.017  1.00 37.90           C  
ATOM    100  N   LYS A  15       9.178  26.503  40.480  1.00 36.70           N  
ATOM    101  CA  LYS A  15       8.460  26.964  39.293  1.00 37.98           C  
ATOM    102  C   LYS A  15       9.168  28.138  38.626  1.00 37.79           C  
ATOM    103  O   LYS A  15       9.211  28.224  37.399  1.00 37.25           O  
ATOM    104  CB  LYS A  15       7.020  27.352  39.649  1.00 37.41           C  
ATOM    105  CG  LYS A  15       6.209  26.198  40.216  1.00 40.40           C  
ATOM    106  CD  LYS A  15       4.710  26.470  40.186  1.00 42.15           C  
ATOM    107  CE  LYS A  15       3.929  25.286  40.755  1.00 43.54           C  
ATOM    108  NZ  LYS A  15       2.451  25.422  40.600  1.00 44.83           N  
ATOM    109  N   ARG A  16       9.716  29.037  39.437  1.00 37.40           N  
ATOM    110  CA  ARG A  16      10.445  30.188  38.922  1.00 37.55           C  
ATOM    111  C   ARG A  16      11.695  29.685  38.203  1.00 35.16           C  
ATOM    112  O   ARG A  16      12.056  30.178  37.139  1.00 34.54           O  
ATOM    113  CB  ARG A  16      10.856  31.114  40.071  1.00 40.97           C  
ATOM    114  CG  ARG A  16       9.768  32.069  40.552  1.00 46.73           C  
ATOM    115  CD  ARG A  16       9.784  33.353  39.734  1.00 54.08           C  
ATOM    116  NE  ARG A  16       8.824  34.344  40.217  1.00 59.04           N  
ATOM    117  CZ  ARG A  16       7.506  34.250  40.067  1.00 62.04           C  
ATOM    118  NH1 ARG A  16       6.977  33.203  39.443  1.00 62.95           N  
ATOM    119  NH2 ARG A  16       6.716  35.204  40.542  1.00 63.88           N  
ATOM    120  N   ALA A  17      12.350  28.699  38.798  1.00 33.69           N  
ATOM    121  CA  ALA A  17      13.561  28.120  38.229  1.00 32.82           C  
ATOM    122  C   ALA A  17      13.285  27.450  36.878  1.00 32.02           C  
ATOM    123  O   ALA A  17      14.087  27.551  35.953  1.00 31.25           O  
ATOM    124  CB  ALA A  17      14.159  27.122  39.203  1.00 29.69           C  
ATOM    125  N   ALA A  18      12.143  26.779  36.769  1.00 32.13           N  
ATOM    126  CA  ALA A  18      11.769  26.098  35.536  1.00 32.05           C  
ATOM    127  C   ALA A  18      11.485  27.070  34.394  1.00 32.81           C  
ATOM    128  O   ALA A  18      11.897  26.829  33.263  1.00 31.97           O  
ATOM    129  CB  ALA A  18      10.560  25.210  35.778  1.00 31.93           C  
ATOM    130  N   LEU A  19      10.780  28.164  34.685  1.00 33.27           N  
ATOM    131  CA  LEU A  19      10.467  29.163  33.660  1.00 34.21           C  
ATOM    132  C   LEU A  19      11.751  29.812  33.149  1.00 33.07           C  
ATOM    133  O   LEU A  19      11.911  30.035  31.952  1.00 32.84           O  
ATOM    134  CB  LEU A  19       9.560  30.261  34.225  1.00 37.83           C  
ATOM    135  CG  LEU A  19       8.217  29.897  34.858  1.00 42.66           C  
ATOM    136  CD1 LEU A  19       7.646  31.128  35.551  1.00 45.40           C  
ATOM    137  CD2 LEU A  19       7.256  29.391  33.804  1.00 45.29           C  
ATOM    138  N   LYS A  20      12.657  30.121  34.073  1.00 33.01           N  
ATOM    139  CA  LYS A  20      13.934  30.747  33.742  1.00 32.50           C  
ATOM    140  C   LYS A  20      14.901  29.787  33.034  1.00 30.78           C  
ATOM    141  O   LYS A  20      15.741  30.213  32.246  1.00 31.07           O  
ATOM    142  CB  LYS A  20      14.583  31.299  35.018  1.00 34.58           C  
ATOM    143  CG  LYS A  20      16.076  31.563  34.899  1.00 39.10           C  
ATOM    144  CD  LYS A  20      16.603  32.374  36.073  1.00 43.75           C  
ATOM    145  CE  LYS A  20      16.211  33.836  35.944  1.00 47.53           C  
ATOM    146  NZ  LYS A  20      16.702  34.419  34.657  1.00 49.16           N  
ATOM    147  N   ALA A  21      14.786  28.497  33.327  1.00 28.05           N  
ATOM    148  CA  ALA A  21      15.642  27.495  32.703  1.00 27.55           C  
ATOM    149  C   ALA A  21      15.450  27.491  31.182  1.00 26.56           C  
ATOM    150  O   ALA A  21      16.379  27.202  30.438  1.00 26.25           O  
ATOM    151  CB  ALA A  21      15.334  26.111  33.276  1.00 25.34           C  
ATOM    152  N   CYS A  22      14.244  27.817  30.728  1.00 26.35           N  
ATOM    153  CA  CYS A  22      13.950  27.855  29.298  1.00 28.56           C  
ATOM    154  C   CYS A  22      14.931  28.721  28.508  1.00 27.40           C  
ATOM    155  O   CYS A  22      15.149  28.487  27.322  1.00 24.30           O  
ATOM    156  CB  CYS A  22      12.532  28.379  29.052  1.00 32.03           C  
ATOM    157  SG  CYS A  22      11.196  27.202  29.389  1.00 44.64           S  
ATOM    158  N   GLU A  23      15.511  29.722  29.160  1.00 26.91           N  
ATOM    159  CA  GLU A  23      16.450  30.610  28.480  1.00 28.93           C  
ATOM    160  C   GLU A  23      17.735  29.901  28.055  1.00 28.86           C  
ATOM    161  O   GLU A  23      18.459  30.386  27.184  1.00 29.09           O  
ATOM    162  CB  GLU A  23      16.791  31.800  29.377  1.00 31.15           C  
ATOM    163  CG  GLU A  23      15.573  32.611  29.819  1.00 36.66           C  
ATOM    164  CD  GLU A  23      15.954  33.888  30.545  1.00 41.91           C  
ATOM    165  OE1 GLU A  23      16.747  33.814  31.509  1.00 44.60           O  
ATOM    166  OE2 GLU A  23      15.459  34.968  30.154  1.00 46.46           O  
ATOM    167  N   LEU A  24      18.013  28.755  28.668  1.00 27.55           N  
ATOM    168  CA  LEU A  24      19.213  27.980  28.355  1.00 27.17           C  
ATOM    169  C   LEU A  24      19.001  27.029  27.185  1.00 25.83           C  
ATOM    170  O   LEU A  24      19.938  26.379  26.724  1.00 25.07           O  
ATOM    171  CB  LEU A  24      19.661  27.182  29.583  1.00 28.23           C  
ATOM    172  CG  LEU A  24      20.434  27.981  30.641  1.00 32.14           C  
ATOM    173  CD1 LEU A  24      21.874  28.154  30.207  1.00 33.05           C  
ATOM    174  CD2 LEU A  24      19.785  29.338  30.842  1.00 36.12           C  
ATOM    175  N   SER A  25      17.768  26.962  26.701  1.00 24.39           N  
ATOM    176  CA  SER A  25      17.428  26.084  25.588  1.00 22.67           C  
ATOM    177  C   SER A  25      18.197  26.366  24.298  1.00 22.07           C  
ATOM    178  O   SER A  25      18.441  27.517  23.942  1.00 20.38           O  
ATOM    179  CB  SER A  25      15.932  26.186  25.290  1.00 24.17           C  
ATOM    180  OG  SER A  25      15.608  25.501  24.086  1.00 24.51           O  
ATOM    181  N   TYR A  26      18.595  25.297  23.615  1.00 20.15           N  
ATOM    182  CA  TYR A  26      19.267  25.408  22.324  1.00 19.41           C  
ATOM    183  C   TYR A  26      18.290  24.688  21.410  1.00 18.24           C  
ATOM    184  O   TYR A  26      18.272  23.459  21.348  1.00 16.54           O  
ATOM    185  CB  TYR A  26      20.620  24.688  22.322  1.00 20.68           C  
ATOM    186  CG  TYR A  26      21.275  24.643  20.957  1.00 22.50           C  
ATOM    187  CD1 TYR A  26      21.843  25.788  20.387  1.00 23.78           C  
ATOM    188  CD2 TYR A  26      21.304  23.461  20.221  1.00 23.21           C  
ATOM    189  CE1 TYR A  26      22.420  25.749  19.114  1.00 23.78           C  
ATOM    190  CE2 TYR A  26      21.876  23.412  18.948  1.00 22.92           C  
ATOM    191  CZ  TYR A  26      22.429  24.560  18.402  1.00 23.61           C  
ATOM    192  OH  TYR A  26      22.954  24.524  17.126  1.00 24.28           O  
ATOM    193  N   SER A  27      17.455  25.451  20.718  1.00 18.61           N  
ATOM    194  CA  SER A  27      16.462  24.839  19.852  1.00 21.43           C  
ATOM    195  C   SER A  27      16.253  25.591  18.551  1.00 21.29           C  
ATOM    196  O   SER A  27      15.153  26.056  18.266  1.00 21.27           O  
ATOM    197  CB  SER A  27      15.139  24.720  20.617  1.00 23.70           C  
ATOM    198  OG  SER A  27      14.822  25.940  21.278  1.00 26.33           O  
ATOM    199  N   PRO A  28      17.306  25.694  17.725  1.00 22.40           N  
ATOM    200  CA  PRO A  28      17.203  26.404  16.451  1.00 23.29           C  
ATOM    201  C   PRO A  28      16.385  25.661  15.390  1.00 24.32           C  
ATOM    202  O   PRO A  28      16.119  26.204  14.319  1.00 25.88           O  
ATOM    203  CB  PRO A  28      18.665  26.576  16.047  1.00 24.44           C  
ATOM    204  CG  PRO A  28      19.278  25.288  16.523  1.00 24.76           C  
ATOM    205  CD  PRO A  28      18.663  25.141  17.908  1.00 24.62           C  
ATOM    206  N   TYR A  29      15.971  24.434  15.683  1.00 24.87           N  
ATOM    207  CA  TYR A  29      15.204  23.668  14.701  1.00 26.60           C  
ATOM    208  C   TYR A  29      13.692  23.691  14.921  1.00 27.83           C  
ATOM    209  O   TYR A  29      12.928  23.878  13.977  1.00 31.04           O  
ATOM    210  CB  TYR A  29      15.721  22.223  14.651  1.00 26.82           C  
ATOM    211  CG  TYR A  29      17.212  22.169  14.391  1.00 28.49           C  
ATOM    212  CD1 TYR A  29      18.120  22.071  15.442  1.00 27.62           C  
ATOM    213  CD2 TYR A  29      17.716  22.328  13.105  1.00 28.44           C  
ATOM    214  CE1 TYR A  29      19.491  22.139  15.222  1.00 28.98           C  
ATOM    215  CE2 TYR A  29      19.087  22.400  12.872  1.00 31.07           C  
ATOM    216  CZ  TYR A  29      19.968  22.307  13.935  1.00 30.01           C  
ATOM    217  OH  TYR A  29      21.324  22.410  13.712  1.00 29.08           O  
ATOM    218  N   SER A  30      13.257  23.506  16.158  1.00 28.41           N  
ATOM    219  CA  SER A  30      11.832  23.529  16.460  1.00 29.22           C  
ATOM    220  C   SER A  30      11.447  24.878  17.064  1.00 30.39           C  
ATOM    221  O   SER A  30      10.293  25.300  16.979  1.00 30.27           O  
ATOM    222  CB  SER A  30      11.484  22.433  17.457  1.00 28.63           C  
ATOM    223  OG  SER A  30      11.950  22.783  18.745  1.00 30.44           O  
ATOM    224  N   HIS A  31      12.426  25.545  17.674  1.00 29.88           N  
ATOM    225  CA  HIS A  31      12.210  26.833  18.318  1.00 29.09           C  
ATOM    226  C   HIS A  31      11.312  26.648  19.531  1.00 28.73           C  
ATOM    227  O   HIS A  31      10.819  27.621  20.090  1.00 31.21           O  
ATOM    228  CB  HIS A  31      11.554  27.830  17.358  1.00 28.12           C  
ATOM    229  CG  HIS A  31      12.262  27.966  16.047  1.00 29.54           C  
ATOM    230  ND1 HIS A  31      13.594  28.312  15.950  1.00 29.35           N  
ATOM    231  CD2 HIS A  31      11.821  27.808  14.776  1.00 28.16           C  
ATOM    232  CE1 HIS A  31      13.941  28.362  14.676  1.00 31.55           C  
ATOM    233  NE2 HIS A  31      12.883  28.061  13.943  1.00 29.61           N  
ATOM    234  N   PHE A  32      11.095  25.401  19.933  1.00 28.16           N  
ATOM    235  CA  PHE A  32      10.251  25.107  21.096  1.00 28.02           C  
ATOM    236  C   PHE A  32      11.147  24.903  22.313  1.00 26.62           C  
ATOM    237  O   PHE A  32      11.879  23.917  22.392  1.00 26.99           O  
ATOM    238  CB  PHE A  32       9.426  23.844  20.847  1.00 30.59           C  
ATOM    239  CG  PHE A  32       8.310  23.644  21.836  1.00 36.10           C  
ATOM    240  CD1 PHE A  32       7.101  24.317  21.683  1.00 37.63           C  
ATOM    241  CD2 PHE A  32       8.472  22.793  22.928  1.00 37.86           C  
ATOM    242  CE1 PHE A  32       6.064  24.145  22.602  1.00 40.73           C  
ATOM    243  CE2 PHE A  32       7.443  22.613  23.856  1.00 41.03           C  
ATOM    244  CZ  PHE A  32       6.236  23.291  23.691  1.00 41.54           C  
ATOM    245  N   ARG A  33      11.086  25.833  23.261  1.00 23.39           N  
ATOM    246  CA  ARG A  33      11.924  25.753  24.451  1.00 22.88           C  
ATOM    247  C   ARG A  33      11.222  25.086  25.627  1.00 22.12           C  
ATOM    248  O   ARG A  33      10.039  25.318  25.872  1.00 20.10           O  
ATOM    249  CB  ARG A  33      12.363  27.154  24.893  1.00 22.21           C  
ATOM    250  CG  ARG A  33      12.850  28.073  23.776  1.00 23.80           C  
ATOM    251  CD  ARG A  33      13.059  29.493  24.323  1.00 25.49           C  
ATOM    252  NE  ARG A  33      11.850  29.988  24.982  1.00 28.34           N  
ATOM    253  CZ  ARG A  33      11.827  30.958  25.895  1.00 31.42           C  
ATOM    254  NH1 ARG A  33      12.950  31.554  26.269  1.00 30.36           N  
ATOM    255  NH2 ARG A  33      10.675  31.326  26.446  1.00 32.91           N  
ATOM    256  N   VAL A  34      11.970  24.269  26.359  1.00 21.39           N  
ATOM    257  CA  VAL A  34      11.446  23.591  27.533  1.00 22.54           C  
ATOM    258  C   VAL A  34      12.464  23.742  28.650  1.00 22.67           C  
ATOM    259  O   VAL A  34      13.674  23.631  28.424  1.00 21.93           O  
ATOM    260  CB  VAL A  34      11.210  22.091  27.273  1.00 23.92           C  
ATOM    261  CG1 VAL A  34      10.603  21.446  28.513  1.00 26.48           C  
ATOM    262  CG2 VAL A  34      10.292  21.911  26.081  1.00 24.56           C  
ATOM    263  N   GLY A  35      11.963  24.014  29.851  1.00 22.42           N  
ATOM    264  CA  GLY A  35      12.821  24.180  31.003  1.00 22.63           C  
ATOM    265  C   GLY A  35      12.416  23.183  32.070  1.00 23.99           C  
ATOM    266  O   GLY A  35      11.264  22.742  32.107  1.00 23.10           O  
ATOM    267  N   CYS A  36      13.357  22.825  32.936  1.00 24.62           N  
ATOM    268  CA  CYS A  36      13.074  21.859  33.993  1.00 25.76           C  
ATOM    269  C   CYS A  36      13.930  22.096  35.226  1.00 27.13           C  
ATOM    270  O   CYS A  36      15.121  22.417  35.130  1.00 27.26           O  
ATOM    271  CB  CYS A  36      13.309  20.440  33.475  1.00 26.81           C  
ATOM    272  SG  CYS A  36      13.247  19.131  34.729  1.00 31.66           S  
ATOM    273  N   SER A  37      13.314  21.942  36.391  1.00 25.60           N  
ATOM    274  CA  SER A  37      14.019  22.115  37.644  1.00 26.51           C  
ATOM    275  C   SER A  37      13.780  20.889  38.518  1.00 27.36           C  
ATOM    276  O   SER A  37      12.718  20.261  38.460  1.00 26.04           O  
ATOM    277  CB  SER A  37      13.537  23.385  38.361  1.00 27.21           C  
ATOM    278  OG  SER A  37      12.159  23.305  38.670  1.00 29.38           O  
ATOM    279  N   ILE A  38      14.782  20.545  39.318  1.00 27.30           N  
ATOM    280  CA  ILE A  38      14.701  19.398  40.209  1.00 26.90           C  
ATOM    281  C   ILE A  38      15.174  19.818  41.598  1.00 29.20           C  
ATOM    282  O   ILE A  38      16.170  20.530  41.738  1.00 28.62           O  
ATOM    283  CB  ILE A  38      15.609  18.230  39.720  1.00 27.17           C  
ATOM    284  CG1 ILE A  38      15.163  17.749  38.333  1.00 24.91           C  
ATOM    285  CG2 ILE A  38      15.559  17.073  40.719  1.00 26.65           C  
ATOM    286  CD1 ILE A  38      16.085  16.687  37.731  1.00 25.96           C  
ATOM    287  N   LEU A  39      14.448  19.381  42.620  1.00 30.32           N  
ATOM    288  CA  LEU A  39      14.801  19.696  43.994  1.00 31.28           C  
ATOM    289  C   LEU A  39      15.399  18.434  44.595  1.00 32.74           C  
ATOM    290  O   LEU A  39      14.764  17.376  44.578  1.00 32.59           O  
ATOM    291  CB  LEU A  39      13.557  20.113  44.782  1.00 31.54           C  
ATOM    292  CG  LEU A  39      13.797  20.498  46.247  1.00 33.62           C  
ATOM    293  CD1 LEU A  39      14.695  21.720  46.302  1.00 30.67           C  
ATOM    294  CD2 LEU A  39      12.473  20.774  46.946  1.00 31.22           C  
ATOM    295  N   THR A  40      16.622  18.536  45.107  1.00 35.20           N  
ATOM    296  CA  THR A  40      17.294  17.384  45.706  1.00 38.86           C  
ATOM    297  C   THR A  40      16.804  17.149  47.133  1.00 40.58           C  
ATOM    298  O   THR A  40      16.032  17.942  47.667  1.00 39.19           O  
ATOM    299  CB  THR A  40      18.821  17.581  45.738  1.00 39.84           C  
ATOM    300  OG1 THR A  40      19.146  18.697  46.576  1.00 41.01           O  
ATOM    301  CG2 THR A  40      19.349  17.831  44.334  1.00 42.07           C  
ATOM    302  N   ASN A  41      17.249  16.055  47.746  1.00 44.26           N  
ATOM    303  CA  ASN A  41      16.840  15.746  49.113  1.00 47.65           C  
ATOM    304  C   ASN A  41      17.549  16.695  50.063  1.00 48.59           C  
ATOM    305  O   ASN A  41      17.255  16.741  51.254  1.00 49.98           O  
ATOM    306  CB  ASN A  41      17.178  14.293  49.483  1.00 49.28           C  
ATOM    307  CG  ASN A  41      18.656  14.084  49.788  1.00 53.01           C  
ATOM    308  OD1 ASN A  41      19.427  15.038  49.926  1.00 53.42           O  
ATOM    309  ND2 ASN A  41      19.054  12.821  49.907  1.00 54.47           N  
ATOM    310  N   ASN A  42      18.501  17.442  49.521  1.00 49.61           N  
ATOM    311  CA  ASN A  42      19.266  18.405  50.297  1.00 49.72           C  
ATOM    312  C   ASN A  42      18.704  19.800  50.018  1.00 48.66           C  
ATOM    313  O   ASN A  42      19.319  20.814  50.337  1.00 48.08           O  
ATOM    314  CB  ASN A  42      20.743  18.329  49.899  1.00 52.78           C  
ATOM    315  CG  ASN A  42      21.651  19.064  50.865  1.00 56.77           C  
ATOM    316  OD1 ASN A  42      22.871  19.063  50.704  1.00 59.93           O  
ATOM    317  ND2 ASN A  42      21.062  19.691  51.878  1.00 57.93           N  
ATOM    318  N   ASP A  43      17.525  19.827  49.408  1.00 47.92           N  
ATOM    319  CA  ASP A  43      16.839  21.066  49.074  1.00 47.51           C  
ATOM    320  C   ASP A  43      17.587  21.995  48.122  1.00 45.78           C  
ATOM    321  O   ASP A  43      17.410  23.209  48.167  1.00 45.83           O  
ATOM    322  CB  ASP A  43      16.478  21.810  50.355  1.00 51.44           C  
ATOM    323  CG  ASP A  43      15.501  21.030  51.213  1.00 55.30           C  
ATOM    324  OD1 ASP A  43      14.406  20.702  50.705  1.00 56.32           O  
ATOM    325  OD2 ASP A  43      15.828  20.740  52.386  1.00 57.24           O  
ATOM    326  N   VAL A  44      18.417  21.418  47.259  1.00 43.85           N  
ATOM    327  CA  VAL A  44      19.166  22.190  46.272  1.00 41.34           C  
ATOM    328  C   VAL A  44      18.412  22.104  44.944  1.00 39.64           C  
ATOM    329  O   VAL A  44      17.876  21.054  44.595  1.00 37.73           O  
ATOM    330  CB  VAL A  44      20.592  21.622  46.072  1.00 41.88           C  
ATOM    331  CG1 VAL A  44      21.309  22.388  44.972  1.00 41.32           C  
ATOM    332  CG2 VAL A  44      21.375  21.705  47.374  1.00 41.85           C  
ATOM    333  N   ILE A  45      18.379  23.205  44.204  1.00 38.84           N  
ATOM    334  CA  ILE A  45      17.678  23.241  42.927  1.00 37.06           C  
ATOM    335  C   ILE A  45      18.617  23.158  41.720  1.00 35.83           C  
ATOM    336  O   ILE A  45      19.607  23.882  41.639  1.00 35.77           O  
ATOM    337  CB  ILE A  45      16.834  24.535  42.804  1.00 37.15           C  
ATOM    338  CG1 ILE A  45      15.830  24.615  43.958  1.00 38.23           C  
ATOM    339  CG2 ILE A  45      16.098  24.556  41.469  1.00 37.43           C  
ATOM    340  CD1 ILE A  45      14.967  25.867  43.949  1.00 36.63           C  
ATOM    341  N   PHE A  46      18.297  22.257  40.793  1.00 33.75           N  
ATOM    342  CA  PHE A  46      19.070  22.082  39.567  1.00 32.00           C  
ATOM    343  C   PHE A  46      18.133  22.358  38.400  1.00 30.75           C  
ATOM    344  O   PHE A  46      16.948  22.039  38.469  1.00 29.75           O  
ATOM    345  CB  PHE A  46      19.607  20.653  39.446  1.00 31.29           C  
ATOM    346  CG  PHE A  46      20.777  20.367  40.336  1.00 32.09           C  
ATOM    347  CD1 PHE A  46      20.590  20.064  41.680  1.00 32.44           C  
ATOM    348  CD2 PHE A  46      22.075  20.417  39.829  1.00 32.53           C  
ATOM    349  CE1 PHE A  46      21.678  19.816  42.515  1.00 32.41           C  
ATOM    350  CE2 PHE A  46      23.173  20.172  40.654  1.00 32.68           C  
ATOM    351  CZ  PHE A  46      22.973  19.869  42.001  1.00 34.71           C  
ATOM    352  N   THR A  47      18.654  22.948  37.329  1.00 28.42           N  
ATOM    353  CA  THR A  47      17.813  23.252  36.178  1.00 28.74           C  
ATOM    354  C   THR A  47      18.385  22.690  34.885  1.00 26.97           C  
ATOM    355  O   THR A  47      19.575  22.399  34.795  1.00 29.01           O  
ATOM    356  CB  THR A  47      17.623  24.775  35.999  1.00 29.31           C  
ATOM    357  OG1 THR A  47      18.887  25.382  35.712  1.00 32.63           O  
ATOM    358  CG2 THR A  47      17.039  25.399  37.275  1.00 31.98           C  
ATOM    359  N   GLY A  48      17.526  22.546  33.886  1.00 23.98           N  
ATOM    360  CA  GLY A  48      17.959  22.037  32.598  1.00 23.62           C  
ATOM    361  C   GLY A  48      17.048  22.563  31.507  1.00 21.73           C  
ATOM    362  O   GLY A  48      15.945  23.046  31.791  1.00 23.23           O  
ATOM    363  N   ALA A  49      17.507  22.486  30.263  1.00 18.50           N  
ATOM    364  CA  ALA A  49      16.723  22.946  29.124  1.00 16.89           C  
ATOM    365  C   ALA A  49      16.973  21.982  27.975  1.00 16.54           C  
ATOM    366  O   ALA A  49      17.967  21.257  27.985  1.00 18.03           O  
ATOM    367  CB  ALA A  49      17.145  24.362  28.739  1.00 16.78           C  
ATOM    368  N   ASN A  50      16.085  21.962  26.986  1.00 17.22           N  
ATOM    369  CA  ASN A  50      16.262  21.048  25.859  1.00 18.14           C  
ATOM    370  C   ASN A  50      17.403  21.507  24.955  1.00 19.04           C  
ATOM    371  O   ASN A  50      17.683  22.706  24.856  1.00 17.53           O  
ATOM    372  CB  ASN A  50      14.948  20.905  25.057  1.00 20.08           C  
ATOM    373  CG  ASN A  50      14.425  22.230  24.527  1.00 20.64           C  
ATOM    374  OD1 ASN A  50      14.499  23.252  25.199  1.00 21.18           O  
ATOM    375  ND2 ASN A  50      13.864  22.206  23.324  1.00 22.34           N  
ATOM    376  N   VAL A  51      18.071  20.545  24.328  1.00 17.01           N  
ATOM    377  CA  VAL A  51      19.190  20.815  23.424  1.00 19.61           C  
ATOM    378  C   VAL A  51      18.961  20.009  22.153  1.00 20.81           C  
ATOM    379  O   VAL A  51      19.040  18.780  22.172  1.00 21.84           O  
ATOM    380  CB  VAL A  51      20.549  20.370  24.037  1.00 18.39           C  
ATOM    381  CG1 VAL A  51      21.686  20.665  23.052  1.00 19.37           C  
ATOM    382  CG2 VAL A  51      20.796  21.094  25.359  1.00 19.76           C  
ATOM    383  N   GLU A  52      18.674  20.700  21.055  1.00 23.21           N  
ATOM    384  CA  GLU A  52      18.419  20.037  19.784  1.00 24.53           C  
ATOM    385  C   GLU A  52      19.703  19.835  18.983  1.00 25.53           C  
ATOM    386  O   GLU A  52      20.788  20.266  19.401  1.00 25.18           O  
ATOM    387  CB  GLU A  52      17.388  20.837  18.979  1.00 24.85           C  
ATOM    388  CG  GLU A  52      16.147  21.181  19.800  1.00 29.58           C  
ATOM    389  CD  GLU A  52      14.986  21.717  18.968  1.00 31.39           C  
ATOM    390  OE1 GLU A  52      15.221  22.485  18.007  1.00 26.91           O  
ATOM    391  OE2 GLU A  52      13.828  21.375  19.297  1.00 34.37           O  
ATOM    392  N   ASN A  53      19.571  19.172  17.834  1.00 25.07           N  
ATOM    393  CA  ASN A  53      20.705  18.866  16.967  1.00 25.31           C  
ATOM    394  C   ASN A  53      20.193  18.709  15.528  1.00 26.78           C  
ATOM    395  O   ASN A  53      19.024  18.394  15.318  1.00 25.63           O  
ATOM    396  CB  ASN A  53      21.346  17.563  17.469  1.00 25.79           C  
ATOM    397  CG  ASN A  53      22.629  17.207  16.745  1.00 29.11           C  
ATOM    398  OD1 ASN A  53      22.612  16.734  15.606  1.00 27.99           O  
ATOM    399  ND2 ASN A  53      23.755  17.427  17.412  1.00 27.54           N  
ATOM    400  N   ALA A  54      21.062  18.938  14.544  1.00 27.14           N  
ATOM    401  CA  ALA A  54      20.674  18.793  13.143  1.00 27.87           C  
ATOM    402  C   ALA A  54      20.065  17.410  12.943  1.00 28.77           C  
ATOM    403  O   ALA A  54      19.083  17.257  12.216  1.00 28.25           O  
ATOM    404  CB  ALA A  54      21.885  18.974  12.234  1.00 29.14           C  
ATOM    405  N   SER A  55      20.666  16.403  13.579  1.00 28.78           N  
ATOM    406  CA  SER A  55      20.163  15.035  13.521  1.00 30.25           C  
ATOM    407  C   SER A  55      19.158  14.940  14.668  1.00 31.25           C  
ATOM    408  O   SER A  55      19.536  14.906  15.843  1.00 30.25           O  
ATOM    409  CB  SER A  55      21.293  14.024  13.737  1.00 30.11           C  
ATOM    410  OG  SER A  55      20.766  12.710  13.815  1.00 35.89           O  
ATOM    411  N   TYR A  56      17.876  14.898  14.329  1.00 31.72           N  
ATOM    412  CA  TYR A  56      16.836  14.872  15.346  1.00 33.15           C  
ATOM    413  C   TYR A  56      16.898  13.793  16.416  1.00 33.20           C  
ATOM    414  O   TYR A  56      16.384  13.991  17.518  1.00 32.72           O  
ATOM    415  CB  TYR A  56      15.461  14.878  14.677  1.00 35.87           C  
ATOM    416  CG  TYR A  56      15.128  16.208  14.042  1.00 39.63           C  
ATOM    417  CD1 TYR A  56      13.818  16.534  13.720  1.00 41.71           C  
ATOM    418  CD2 TYR A  56      16.129  17.152  13.773  1.00 42.23           C  
ATOM    419  CE1 TYR A  56      13.502  17.770  13.156  1.00 42.20           C  
ATOM    420  CE2 TYR A  56      15.827  18.383  13.210  1.00 42.42           C  
ATOM    421  CZ  TYR A  56      14.511  18.685  12.900  1.00 43.94           C  
ATOM    422  OH  TYR A  56      14.205  19.904  12.339  1.00 45.86           O  
ATOM    423  N   SER A  57      17.526  12.664  16.114  1.00 33.94           N  
ATOM    424  CA  SER A  57      17.628  11.586  17.099  1.00 34.67           C  
ATOM    425  C   SER A  57      18.512  12.004  18.278  1.00 33.37           C  
ATOM    426  O   SER A  57      18.380  11.474  19.384  1.00 33.56           O  
ATOM    427  CB  SER A  57      18.216  10.334  16.451  1.00 34.39           C  
ATOM    428  OG  SER A  57      17.635  10.119  15.178  1.00 41.56           O  
ATOM    429  N   ASN A  58      19.404  12.963  18.040  1.00 32.12           N  
ATOM    430  CA  ASN A  58      20.318  13.438  19.076  1.00 33.05           C  
ATOM    431  C   ASN A  58      19.779  14.441  20.096  1.00 32.38           C  
ATOM    432  O   ASN A  58      20.477  14.767  21.052  1.00 33.95           O  
ATOM    433  CB  ASN A  58      21.571  14.041  18.439  1.00 35.03           C  
ATOM    434  CG  ASN A  58      22.695  13.040  18.306  1.00 38.39           C  
ATOM    435  OD1 ASN A  58      22.750  12.274  17.345  1.00 44.61           O  
ATOM    436  ND2 ASN A  58      23.595  13.032  19.279  1.00 36.92           N  
ATOM    437  N   CYS A  59      18.561  14.933  19.909  1.00 30.29           N  
ATOM    438  CA  CYS A  59      17.999  15.907  20.842  1.00 30.80           C  
ATOM    439  C   CYS A  59      17.897  15.417  22.292  1.00 28.93           C  
ATOM    440  O   CYS A  59      17.468  14.293  22.558  1.00 28.42           O  
ATOM    441  CB  CYS A  59      16.611  16.359  20.370  1.00 32.34           C  
ATOM    442  SG  CYS A  59      16.584  17.248  18.784  1.00 38.69           S  
ATOM    443  N   ILE A  60      18.298  16.269  23.229  1.00 25.51           N  
ATOM    444  CA  ILE A  60      18.210  15.930  24.644  1.00 26.29           C  
ATOM    445  C   ILE A  60      17.172  16.840  25.301  1.00 24.92           C  
ATOM    446  O   ILE A  60      17.324  18.055  25.294  1.00 24.98           O  
ATOM    447  CB  ILE A  60      19.559  16.128  25.369  1.00 27.06           C  
ATOM    448  CG1 ILE A  60      20.646  15.268  24.712  1.00 30.14           C  
ATOM    449  CG2 ILE A  60      19.414  15.762  26.849  1.00 27.73           C  
ATOM    450  CD1 ILE A  60      20.353  13.778  24.717  1.00 32.25           C  
ATOM    451  N   CYS A  61      16.127  16.248  25.871  1.00 24.48           N  
ATOM    452  CA  CYS A  61      15.062  17.010  26.534  1.00 25.46           C  
ATOM    453  C   CYS A  61      15.514  17.737  27.805  1.00 24.14           C  
ATOM    454  O   CYS A  61      16.530  17.381  28.406  1.00 22.59           O  
ATOM    455  CB  CYS A  61      13.898  16.074  26.877  1.00 27.46           C  
ATOM    456  SG  CYS A  61      13.113  15.287  25.428  1.00 35.40           S  
ATOM    457  N   ALA A  62      14.745  18.746  28.219  1.00 22.09           N  
ATOM    458  CA  ALA A  62      15.063  19.518  29.418  1.00 21.44           C  
ATOM    459  C   ALA A  62      15.142  18.640  30.666  1.00 21.50           C  
ATOM    460  O   ALA A  62      15.987  18.857  31.535  1.00 20.66           O  
ATOM    461  CB  ALA A  62      14.013  20.620  29.630  1.00 20.16           C  
ATOM    462  N   GLU A  63      14.258  17.652  30.755  1.00 22.72           N  
ATOM    463  CA  GLU A  63      14.241  16.769  31.918  1.00 24.22           C  
ATOM    464  C   GLU A  63      15.536  15.981  32.021  1.00 23.96           C  
ATOM    465  O   GLU A  63      16.134  15.891  33.092  1.00 23.66           O  
ATOM    466  CB  GLU A  63      13.049  15.806  31.855  1.00 25.93           C  
ATOM    467  CG  GLU A  63      11.687  16.496  31.787  1.00 29.58           C  
ATOM    468  CD  GLU A  63      11.167  16.651  30.360  1.00 36.40           C  
ATOM    469  OE1 GLU A  63      11.809  17.355  29.548  1.00 34.94           O  
ATOM    470  OE2 GLU A  63      10.109  16.060  30.049  1.00 39.92           O  
ATOM    471  N   ARG A  64      15.978  15.411  30.908  1.00 24.07           N  
ATOM    472  CA  ARG A  64      17.213  14.652  30.932  1.00 24.44           C  
ATOM    473  C   ARG A  64      18.419  15.539  31.217  1.00 22.85           C  
ATOM    474  O   ARG A  64      19.345  15.117  31.905  1.00 22.04           O  
ATOM    475  CB  ARG A  64      17.378  13.878  29.625  1.00 25.19           C  
ATOM    476  CG  ARG A  64      16.472  12.655  29.584  1.00 29.27           C  
ATOM    477  CD  ARG A  64      16.623  11.885  28.300  1.00 33.05           C  
ATOM    478  NE  ARG A  64      16.011  12.591  27.183  1.00 35.62           N  
ATOM    479  CZ  ARG A  64      16.311  12.364  25.910  1.00 37.36           C  
ATOM    480  NH1 ARG A  64      17.222  11.447  25.599  1.00 37.15           N  
ATOM    481  NH2 ARG A  64      15.692  13.039  24.953  1.00 34.93           N  
ATOM    482  N   SER A  65      18.405  16.768  30.703  1.00 22.31           N  
ATOM    483  CA  SER A  65      19.499  17.702  30.959  1.00 23.34           C  
ATOM    484  C   SER A  65      19.548  17.980  32.463  1.00 23.23           C  
ATOM    485  O   SER A  65      20.613  17.944  33.079  1.00 24.98           O  
ATOM    486  CB  SER A  65      19.273  19.017  30.207  1.00 23.96           C  
ATOM    487  OG  SER A  65      19.337  18.815  28.807  1.00 28.97           O  
ATOM    488  N   ALA A  66      18.390  18.267  33.050  1.00 22.78           N  
ATOM    489  CA  ALA A  66      18.313  18.533  34.482  1.00 24.08           C  
ATOM    490  C   ALA A  66      18.838  17.335  35.283  1.00 24.65           C  
ATOM    491  O   ALA A  66      19.637  17.504  36.204  1.00 25.74           O  
ATOM    492  CB  ALA A  66      16.869  18.845  34.891  1.00 24.64           C  
ATOM    493  N   MET A  67      18.400  16.126  34.933  1.00 24.84           N  
ATOM    494  CA  MET A  67      18.850  14.935  35.656  1.00 26.10           C  
ATOM    495  C   MET A  67      20.352  14.700  35.529  1.00 26.46           C  
ATOM    496  O   MET A  67      21.006  14.310  36.497  1.00 26.10           O  
ATOM    497  CB  MET A  67      18.068  13.700  35.188  1.00 28.70           C  
ATOM    498  CG  MET A  67      16.625  13.723  35.678  1.00 30.89           C  
ATOM    499  SD  MET A  67      15.628  12.323  35.169  1.00 33.60           S  
ATOM    500  CE  MET A  67      15.135  12.848  33.518  1.00 31.36           C  
ATOM    501  N   ILE A  68      20.901  14.935  34.340  1.00 26.06           N  
ATOM    502  CA  ILE A  68      22.334  14.767  34.131  1.00 26.11           C  
ATOM    503  C   ILE A  68      23.074  15.655  35.132  1.00 25.91           C  
ATOM    504  O   ILE A  68      24.016  15.215  35.780  1.00 26.16           O  
ATOM    505  CB  ILE A  68      22.750  15.155  32.678  1.00 26.41           C  
ATOM    506  CG1 ILE A  68      22.279  14.081  31.696  1.00 27.36           C  
ATOM    507  CG2 ILE A  68      24.263  15.322  32.579  1.00 24.16           C  
ATOM    508  CD1 ILE A  68      22.825  12.685  32.004  1.00 30.46           C  
ATOM    509  N   GLN A  69      22.634  16.905  35.251  1.00 26.62           N  
ATOM    510  CA  GLN A  69      23.239  17.868  36.171  1.00 27.58           C  
ATOM    511  C   GLN A  69      23.211  17.351  37.612  1.00 27.92           C  
ATOM    512  O   GLN A  69      24.214  17.411  38.327  1.00 26.98           O  
ATOM    513  CB  GLN A  69      22.483  19.193  36.111  1.00 29.75           C  
ATOM    514  CG  GLN A  69      22.570  19.937  34.793  1.00 37.13           C  
ATOM    515  CD  GLN A  69      23.339  21.226  34.933  1.00 39.73           C  
ATOM    516  OE1 GLN A  69      24.539  21.285  34.661  1.00 44.34           O  
ATOM    517  NE2 GLN A  69      22.656  22.270  35.381  1.00 42.63           N  
ATOM    518  N   VAL A  70      22.047  16.862  38.033  1.00 28.02           N  
ATOM    519  CA  VAL A  70      21.865  16.324  39.383  1.00 27.31           C  
ATOM    520  C   VAL A  70      22.773  15.125  39.648  1.00 27.18           C  
ATOM    521  O   VAL A  70      23.456  15.061  40.678  1.00 26.61           O  
ATOM    522  CB  VAL A  70      20.392  15.898  39.608  1.00 26.63           C  
ATOM    523  CG1 VAL A  70      20.250  15.126  40.903  1.00 27.64           C  
ATOM    524  CG2 VAL A  70      19.508  17.121  39.648  1.00 28.33           C  
ATOM    525  N   LEU A  71      22.783  14.178  38.715  1.00 24.24           N  
ATOM    526  CA  LEU A  71      23.596  12.983  38.857  1.00 26.42           C  
ATOM    527  C   LEU A  71      25.091  13.270  38.869  1.00 27.16           C  
ATOM    528  O   LEU A  71      25.834  12.656  39.632  1.00 28.09           O  
ATOM    529  CB  LEU A  71      23.281  11.991  37.732  1.00 26.57           C  
ATOM    530  CG  LEU A  71      21.877  11.394  37.745  1.00 26.81           C  
ATOM    531  CD1 LEU A  71      21.612  10.676  36.430  1.00 26.29           C  
ATOM    532  CD2 LEU A  71      21.744  10.439  38.924  1.00 24.76           C  
ATOM    533  N   MET A  72      25.537  14.187  38.015  1.00 26.28           N  
ATOM    534  CA  MET A  72      26.955  14.515  37.953  1.00 29.04           C  
ATOM    535  C   MET A  72      27.398  15.246  39.219  1.00 31.10           C  
ATOM    536  O   MET A  72      28.588  15.295  39.533  1.00 30.62           O  
ATOM    537  CB  MET A  72      27.254  15.380  36.720  1.00 27.74           C  
ATOM    538  CG  MET A  72      27.054  14.658  35.384  1.00 28.42           C  
ATOM    539  SD  MET A  72      28.048  13.149  35.250  1.00 30.93           S  
ATOM    540  CE  MET A  72      26.830  11.878  35.681  1.00 28.42           C  
ATOM    541  N   ALA A  73      26.434  15.813  39.938  1.00 32.62           N  
ATOM    542  CA  ALA A  73      26.731  16.541  41.166  1.00 34.85           C  
ATOM    543  C   ALA A  73      26.740  15.620  42.384  1.00 36.68           C  
ATOM    544  O   ALA A  73      26.902  16.086  43.510  1.00 37.56           O  
ATOM    545  CB  ALA A  73      25.724  17.668  41.368  1.00 31.67           C  
ATOM    546  N   GLY A  74      26.552  14.321  42.154  1.00 37.49           N  
ATOM    547  CA  GLY A  74      26.572  13.357  43.245  1.00 39.19           C  
ATOM    548  C   GLY A  74      25.246  12.903  43.839  1.00 39.71           C  
ATOM    549  O   GLY A  74      25.209  11.940  44.609  1.00 41.14           O  
ATOM    550  N   HIS A  75      24.157  13.575  43.490  1.00 39.12           N  
ATOM    551  CA  HIS A  75      22.842  13.214  44.014  1.00 39.79           C  
ATOM    552  C   HIS A  75      22.252  12.020  43.260  1.00 40.13           C  
ATOM    553  O   HIS A  75      21.535  12.185  42.271  1.00 39.72           O  
ATOM    554  CB  HIS A  75      21.907  14.416  43.915  1.00 39.67           C  
ATOM    555  CG  HIS A  75      22.448  15.654  44.555  1.00 43.73           C  
ATOM    556  ND1 HIS A  75      22.353  15.901  45.910  1.00 44.32           N  
ATOM    557  CD2 HIS A  75      23.108  16.716  44.033  1.00 44.11           C  
ATOM    558  CE1 HIS A  75      22.924  17.055  46.191  1.00 45.03           C  
ATOM    559  NE2 HIS A  75      23.393  17.571  45.066  1.00 45.38           N  
ATOM    560  N   ARG A  76      22.562  10.821  43.744  1.00 39.79           N  
ATOM    561  CA  ARG A  76      22.094   9.575  43.143  1.00 41.65           C  
ATOM    562  C   ARG A  76      20.598   9.318  43.306  1.00 41.24           C  
ATOM    563  O   ARG A  76      19.967   8.728  42.428  1.00 40.81           O  
ATOM    564  CB  ARG A  76      22.863   8.388  43.733  1.00 44.77           C  
ATOM    565  CG  ARG A  76      24.105   7.966  42.962  1.00 50.65           C  
ATOM    566  CD  ARG A  76      23.739   7.314  41.632  1.00 53.32           C  
ATOM    567  NE  ARG A  76      24.667   6.241  41.276  1.00 54.34           N  
ATOM    568  CZ  ARG A  76      25.955   6.420  40.997  1.00 55.34           C  
ATOM    569  NH1 ARG A  76      26.481   7.638  41.027  1.00 54.35           N  
ATOM    570  NH2 ARG A  76      26.719   5.374  40.697  1.00 53.71           N  
ATOM    571  N   SER A  77      20.031   9.744  44.429  1.00 40.81           N  
ATOM    572  CA  SER A  77      18.610   9.523  44.679  1.00 41.15           C  
ATOM    573  C   SER A  77      18.047  10.460  45.737  1.00 39.90           C  
ATOM    574  O   SER A  77      18.717  11.388  46.182  1.00 39.14           O  
ATOM    575  CB  SER A  77      18.371   8.072  45.114  1.00 43.69           C  
ATOM    576  OG  SER A  77      19.087   7.769  46.303  1.00 46.96           O  
ATOM    577  N   GLY A  78      16.804  10.206  46.132  1.00 39.27           N  
ATOM    578  CA  GLY A  78      16.163  11.030  47.135  1.00 38.76           C  
ATOM    579  C   GLY A  78      15.614  12.344  46.612  1.00 38.87           C  
ATOM    580  O   GLY A  78      15.251  13.217  47.401  1.00 39.13           O  
ATOM    581  N   TRP A  79      15.544  12.503  45.292  1.00 37.84           N  
ATOM    582  CA  TRP A  79      15.023  13.746  44.735  1.00 36.12           C  
ATOM    583  C   TRP A  79      13.621  13.951  45.290  1.00 36.02           C  
ATOM    584  O   TRP A  79      12.892  12.988  45.519  1.00 36.49           O  
ATOM    585  CB  TRP A  79      14.981  13.686  43.207  1.00 36.86           C  
ATOM    586  CG  TRP A  79      16.281  13.283  42.575  1.00 34.72           C  
ATOM    587  CD1 TRP A  79      17.518  13.289  43.155  1.00 33.73           C  
ATOM    588  CD2 TRP A  79      16.466  12.812  41.236  1.00 34.75           C  
ATOM    589  NE1 TRP A  79      18.461  12.845  42.259  1.00 34.32           N  
ATOM    590  CE2 TRP A  79      17.843  12.548  41.072  1.00 34.15           C  
ATOM    591  CE3 TRP A  79      15.599  12.586  40.157  1.00 33.77           C  
ATOM    592  CZ2 TRP A  79      18.375  12.067  39.872  1.00 35.94           C  
ATOM    593  CZ3 TRP A  79      16.126  12.108  38.965  1.00 33.93           C  
ATOM    594  CH2 TRP A  79      17.502  11.854  38.832  1.00 34.69           C  
ATOM    595  N   LYS A  80      13.242  15.209  45.492  1.00 34.64           N  
ATOM    596  CA  LYS A  80      11.945  15.529  46.064  1.00 34.22           C  
ATOM    597  C   LYS A  80      10.859  15.990  45.106  1.00 33.07           C  
ATOM    598  O   LYS A  80       9.674  15.770  45.358  1.00 31.73           O  
ATOM    599  CB  LYS A  80      12.133  16.580  47.157  1.00 37.06           C  
ATOM    600  CG  LYS A  80      12.815  16.040  48.408  1.00 41.89           C  
ATOM    601  CD  LYS A  80      13.245  17.161  49.343  1.00 45.34           C  
ATOM    602  CE  LYS A  80      13.539  16.632  50.743  1.00 48.78           C  
ATOM    603  NZ  LYS A  80      14.487  15.478  50.749  1.00 48.56           N  
ATOM    604  N   CYS A  81      11.241  16.628  44.007  1.00 31.93           N  
ATOM    605  CA  CYS A  81      10.236  17.111  43.075  1.00 31.04           C  
ATOM    606  C   CYS A  81      10.862  17.571  41.769  1.00 30.04           C  
ATOM    607  O   CYS A  81      12.039  17.925  41.718  1.00 30.90           O  
ATOM    608  CB  CYS A  81       9.472  18.278  43.713  1.00 31.95           C  
ATOM    609  SG  CYS A  81       8.047  18.907  42.789  1.00 40.03           S  
ATOM    610  N   MET A  82      10.059  17.567  40.718  1.00 27.42           N  
ATOM    611  CA  MET A  82      10.509  18.001  39.412  1.00 28.19           C  
ATOM    612  C   MET A  82       9.439  18.888  38.804  1.00 27.21           C  
ATOM    613  O   MET A  82       8.252  18.557  38.843  1.00 27.50           O  
ATOM    614  CB  MET A  82      10.749  16.791  38.500  1.00 30.25           C  
ATOM    615  CG  MET A  82      10.949  17.144  37.033  1.00 33.67           C  
ATOM    616  SD  MET A  82      11.263  15.690  36.002  1.00 38.64           S  
ATOM    617  CE  MET A  82      13.029  15.590  36.117  1.00 36.33           C  
ATOM    618  N   VAL A  83       9.857  20.027  38.268  1.00 24.65           N  
ATOM    619  CA  VAL A  83       8.933  20.937  37.612  1.00 24.87           C  
ATOM    620  C   VAL A  83       9.348  21.067  36.154  1.00 26.41           C  
ATOM    621  O   VAL A  83      10.529  21.252  35.847  1.00 25.97           O  
ATOM    622  CB  VAL A  83       8.944  22.334  38.256  1.00 25.41           C  
ATOM    623  CG1 VAL A  83       8.108  23.291  37.419  1.00 25.27           C  
ATOM    624  CG2 VAL A  83       8.378  22.254  39.674  1.00 26.85           C  
ATOM    625  N   ILE A  84       8.373  20.955  35.260  1.00 27.11           N  
ATOM    626  CA  ILE A  84       8.627  21.061  33.832  1.00 28.90           C  
ATOM    627  C   ILE A  84       7.780  22.194  33.253  1.00 30.50           C  
ATOM    628  O   ILE A  84       6.579  22.289  33.523  1.00 30.01           O  
ATOM    629  CB  ILE A  84       8.286  19.740  33.111  1.00 29.51           C  
ATOM    630  CG1 ILE A  84       8.994  18.576  33.813  1.00 29.43           C  
ATOM    631  CG2 ILE A  84       8.713  19.822  31.650  1.00 29.63           C  
ATOM    632  CD1 ILE A  84       8.676  17.218  33.238  1.00 30.82           C  
ATOM    633  N   CYS A  85       8.422  23.046  32.460  1.00 31.06           N  
ATOM    634  CA  CYS A  85       7.773  24.192  31.839  1.00 34.46           C  
ATOM    635  C   CYS A  85       8.154  24.262  30.361  1.00 35.14           C  
ATOM    636  O   CYS A  85       9.311  24.040  30.008  1.00 35.08           O  
ATOM    637  CB  CYS A  85       8.226  25.468  32.552  1.00 36.54           C  
ATOM    638  SG  CYS A  85       7.548  26.988  31.876  1.00 51.13           S  
ATOM    639  N   GLY A  86       7.190  24.574  29.500  1.00 35.27           N  
ATOM    640  CA  GLY A  86       7.484  24.653  28.079  1.00 36.41           C  
ATOM    641  C   GLY A  86       6.769  25.774  27.347  1.00 37.39           C  
ATOM    642  O   GLY A  86       5.845  26.387  27.887  1.00 36.35           O  
ATOM    643  N   ASP A  87       7.192  26.030  26.111  1.00 37.28           N  
ATOM    644  CA  ASP A  87       6.610  27.083  25.286  1.00 39.39           C  
ATOM    645  C   ASP A  87       5.227  26.744  24.754  1.00 40.67           C  
ATOM    646  O   ASP A  87       4.869  27.122  23.637  1.00 42.76           O  
ATOM    647  CB  ASP A  87       7.541  27.412  24.116  1.00 38.68           C  
ATOM    648  CG  ASP A  87       8.668  28.343  24.516  1.00 38.50           C  
ATOM    649  OD1 ASP A  87       9.633  28.491  23.736  1.00 41.21           O  
ATOM    650  OD2 ASP A  87       8.582  28.935  25.610  1.00 38.96           O  
ATOM    651  N   SER A  88       4.458  26.011  25.547  1.00 41.05           N  
ATOM    652  CA  SER A  88       3.104  25.657  25.161  1.00 41.17           C  
ATOM    653  C   SER A  88       2.226  26.764  25.720  1.00 42.22           C  
ATOM    654  O   SER A  88       2.253  27.036  26.918  1.00 41.26           O  
ATOM    655  CB  SER A  88       2.703  24.316  25.770  1.00 41.98           C  
ATOM    656  OG  SER A  88       1.358  24.008  25.444  1.00 42.86           O  
ATOM    657  N   GLU A  89       1.455  27.407  24.851  1.00 43.31           N  
ATOM    658  CA  GLU A  89       0.596  28.500  25.271  1.00 45.53           C  
ATOM    659  C   GLU A  89      -0.573  28.023  26.138  1.00 45.80           C  
ATOM    660  O   GLU A  89      -0.790  28.542  27.236  1.00 45.10           O  
ATOM    661  CB  GLU A  89       0.075  29.245  24.035  1.00 49.65           C  
ATOM    662  CG  GLU A  89      -0.172  30.743  24.240  1.00 55.63           C  
ATOM    663  CD  GLU A  89       1.107  31.527  24.535  1.00 58.54           C  
ATOM    664  OE1 GLU A  89       1.673  31.375  25.640  1.00 59.84           O  
ATOM    665  OE2 GLU A  89       1.549  32.296  23.655  1.00 60.19           O  
ATOM    666  N   ASP A  90      -1.306  27.018  25.664  1.00 45.59           N  
ATOM    667  CA  ASP A  90      -2.466  26.518  26.395  1.00 45.66           C  
ATOM    668  C   ASP A  90      -2.266  25.264  27.251  1.00 46.04           C  
ATOM    669  O   ASP A  90      -2.433  25.307  28.471  1.00 45.24           O  
ATOM    670  CB  ASP A  90      -3.621  26.296  25.410  1.00 46.38           C  
ATOM    671  CG  ASP A  90      -4.853  25.706  26.073  1.00 49.32           C  
ATOM    672  OD1 ASP A  90      -5.149  26.086  27.226  1.00 51.40           O  
ATOM    673  OD2 ASP A  90      -5.532  24.870  25.436  1.00 49.71           O  
ATOM    674  N   GLN A  91      -1.909  24.151  26.621  1.00 46.49           N  
ATOM    675  CA  GLN A  91      -1.721  22.894  27.340  1.00 45.40           C  
ATOM    676  C   GLN A  91      -0.427  22.831  28.151  1.00 43.45           C  
ATOM    677  O   GLN A  91       0.545  23.523  27.851  1.00 41.72           O  
ATOM    678  CB  GLN A  91      -1.779  21.727  26.349  1.00 49.07           C  
ATOM    679  CG  GLN A  91      -1.640  20.351  26.979  1.00 57.29           C  
ATOM    680  CD  GLN A  91      -1.950  19.226  26.001  1.00 61.99           C  
ATOM    681  OE1 GLN A  91      -1.799  18.046  26.326  1.00 64.20           O  
ATOM    682  NE2 GLN A  91      -2.394  19.587  24.799  1.00 63.53           N  
ATOM    683  N   CYS A  92      -0.432  22.005  29.194  1.00 41.05           N  
ATOM    684  CA  CYS A  92       0.742  21.830  30.037  1.00 41.05           C  
ATOM    685  C   CYS A  92       1.750  20.958  29.298  1.00 40.10           C  
ATOM    686  O   CYS A  92       1.375  20.113  28.487  1.00 39.19           O  
ATOM    687  CB  CYS A  92       0.364  21.142  31.349  1.00 42.55           C  
ATOM    688  SG  CYS A  92      -0.819  22.052  32.345  1.00 49.22           S  
ATOM    689  N   VAL A  93       3.031  21.162  29.579  1.00 38.82           N  
ATOM    690  CA  VAL A  93       4.067  20.369  28.938  1.00 37.96           C  
ATOM    691  C   VAL A  93       4.323  19.116  29.762  1.00 37.07           C  
ATOM    692  O   VAL A  93       4.814  19.190  30.889  1.00 37.63           O  
ATOM    693  CB  VAL A  93       5.380  21.161  28.807  1.00 37.15           C  
ATOM    694  CG1 VAL A  93       6.460  20.280  28.210  1.00 40.65           C  
ATOM    695  CG2 VAL A  93       5.159  22.378  27.926  1.00 40.43           C  
ATOM    696  N   SER A  94       3.980  17.966  29.198  1.00 35.04           N  
ATOM    697  CA  SER A  94       4.179  16.698  29.884  1.00 34.94           C  
ATOM    698  C   SER A  94       5.449  16.041  29.356  1.00 33.94           C  
ATOM    699  O   SER A  94       5.765  16.150  28.173  1.00 32.27           O  
ATOM    700  CB  SER A  94       2.987  15.776  29.638  1.00 36.06           C  
ATOM    701  OG  SER A  94       2.854  15.496  28.255  1.00 37.12           O  
ATOM    702  N   PRO A  95       6.198  15.351  30.229  1.00 32.43           N  
ATOM    703  CA  PRO A  95       7.426  14.707  29.757  1.00 31.16           C  
ATOM    704  C   PRO A  95       7.130  13.641  28.701  1.00 28.71           C  
ATOM    705  O   PRO A  95       6.105  12.964  28.764  1.00 28.58           O  
ATOM    706  CB  PRO A  95       8.022  14.126  31.038  1.00 31.26           C  
ATOM    707  CG  PRO A  95       6.812  13.835  31.869  1.00 33.46           C  
ATOM    708  CD  PRO A  95       5.949  15.049  31.649  1.00 32.55           C  
ATOM    709  N   CYS A  96       8.017  13.516  27.717  1.00 26.85           N  
ATOM    710  CA  CYS A  96       7.836  12.522  26.668  1.00 24.56           C  
ATOM    711  C   CYS A  96       8.219  11.171  27.247  1.00 23.16           C  
ATOM    712  O   CYS A  96       8.840  11.103  28.306  1.00 22.39           O  
ATOM    713  CB  CYS A  96       8.719  12.836  25.458  1.00 24.92           C  
ATOM    714  SG  CYS A  96      10.471  12.478  25.677  1.00 26.60           S  
ATOM    715  N   GLY A  97       7.861  10.102  26.546  1.00 24.12           N  
ATOM    716  CA  GLY A  97       8.159   8.764  27.027  1.00 23.75           C  
ATOM    717  C   GLY A  97       9.625   8.493  27.294  1.00 24.33           C  
ATOM    718  O   GLY A  97       9.960   7.747  28.217  1.00 22.26           O  
ATOM    719  N   VAL A  98      10.506   9.087  26.491  1.00 23.85           N  
ATOM    720  CA  VAL A  98      11.937   8.884  26.675  1.00 25.25           C  
ATOM    721  C   VAL A  98      12.364   9.400  28.046  1.00 25.85           C  
ATOM    722  O   VAL A  98      13.132   8.748  28.757  1.00 25.55           O  
ATOM    723  CB  VAL A  98      12.755   9.616  25.588  1.00 26.67           C  
ATOM    724  CG1 VAL A  98      14.241   9.449  25.852  1.00 27.12           C  
ATOM    725  CG2 VAL A  98      12.395   9.069  24.214  1.00 30.61           C  
ATOM    726  N   CYS A  99      11.858  10.572  28.416  1.00 25.37           N  
ATOM    727  CA  CYS A  99      12.179  11.172  29.707  1.00 25.48           C  
ATOM    728  C   CYS A  99      11.564  10.397  30.873  1.00 25.01           C  
ATOM    729  O   CYS A  99      12.208  10.214  31.907  1.00 22.28           O  
ATOM    730  CB  CYS A  99      11.705  12.628  29.744  1.00 27.29           C  
ATOM    731  SG  CYS A  99      12.635  13.717  28.625  1.00 29.06           S  
ATOM    732  N   ARG A 100      10.323   9.941  30.709  1.00 23.91           N  
ATOM    733  CA  ARG A 100       9.664   9.190  31.775  1.00 24.15           C  
ATOM    734  C   ARG A 100      10.482   7.955  32.116  1.00 25.09           C  
ATOM    735  O   ARG A 100      10.650   7.616  33.288  1.00 25.62           O  
ATOM    736  CB  ARG A 100       8.252   8.771  31.353  1.00 24.53           C  
ATOM    737  CG  ARG A 100       7.323   9.945  31.082  1.00 23.33           C  
ATOM    738  CD  ARG A 100       5.899   9.512  30.769  1.00 25.09           C  
ATOM    739  NE  ARG A 100       5.157  10.616  30.161  1.00 25.56           N  
ATOM    740  CZ  ARG A 100       3.834  10.680  30.052  1.00 25.24           C  
ATOM    741  NH1 ARG A 100       3.069   9.699  30.510  1.00 21.54           N  
ATOM    742  NH2 ARG A 100       3.273  11.745  29.489  1.00 25.31           N  
ATOM    743  N   GLN A 101      10.997   7.292  31.085  1.00 25.10           N  
ATOM    744  CA  GLN A 101      11.803   6.091  31.266  1.00 25.87           C  
ATOM    745  C   GLN A 101      13.084   6.443  32.010  1.00 25.52           C  
ATOM    746  O   GLN A 101      13.555   5.683  32.848  1.00 24.85           O  
ATOM    747  CB  GLN A 101      12.145   5.470  29.903  1.00 26.72           C  
ATOM    748  CG  GLN A 101      12.868   4.126  29.982  1.00 27.51           C  
ATOM    749  CD  GLN A 101      11.994   3.012  30.551  1.00 29.70           C  
ATOM    750  OE1 GLN A 101      10.883   2.777  30.074  1.00 28.36           O  
ATOM    751  NE2 GLN A 101      12.499   2.317  31.568  1.00 29.79           N  
ATOM    752  N   PHE A 102      13.641   7.608  31.708  1.00 26.02           N  
ATOM    753  CA  PHE A 102      14.874   8.055  32.350  1.00 27.49           C  
ATOM    754  C   PHE A 102      14.638   8.390  33.825  1.00 27.46           C  
ATOM    755  O   PHE A 102      15.411   7.996  34.703  1.00 27.79           O  
ATOM    756  CB  PHE A 102      15.412   9.292  31.630  1.00 28.57           C  
ATOM    757  CG  PHE A 102      16.894   9.466  31.748  1.00 32.48           C  
ATOM    758  CD1 PHE A 102      17.754   8.809  30.874  1.00 36.28           C  
ATOM    759  CD2 PHE A 102      17.435  10.286  32.733  1.00 34.34           C  
ATOM    760  CE1 PHE A 102      19.136   8.975  30.972  1.00 38.44           C  
ATOM    761  CE2 PHE A 102      18.812  10.459  32.842  1.00 36.45           C  
ATOM    762  CZ  PHE A 102      19.667   9.801  31.962  1.00 36.50           C  
ATOM    763  N   ILE A 103      13.568   9.132  34.090  1.00 26.31           N  
ATOM    764  CA  ILE A 103      13.237   9.520  35.451  1.00 28.52           C  
ATOM    765  C   ILE A 103      12.955   8.282  36.297  1.00 28.15           C  
ATOM    766  O   ILE A 103      13.406   8.189  37.435  1.00 27.84           O  
ATOM    767  CB  ILE A 103      11.986  10.444  35.484  1.00 29.13           C  
ATOM    768  CG1 ILE A 103      12.235  11.691  34.630  1.00 30.36           C  
ATOM    769  CG2 ILE A 103      11.686  10.861  36.911  1.00 31.16           C  
ATOM    770  CD1 ILE A 103      11.013  12.598  34.472  1.00 30.75           C  
ATOM    771  N   ASN A 104      12.223   7.329  35.729  1.00 28.05           N  
ATOM    772  CA  ASN A 104      11.863   6.104  36.442  1.00 29.93           C  
ATOM    773  C   ASN A 104      13.051   5.350  37.017  1.00 30.15           C  
ATOM    774  O   ASN A 104      12.927   4.663  38.026  1.00 30.51           O  
ATOM    775  CB  ASN A 104      11.094   5.157  35.526  1.00 30.17           C  
ATOM    776  CG  ASN A 104      10.436   4.028  36.292  1.00 33.94           C  
ATOM    777  OD1 ASN A 104       9.436   4.232  36.981  1.00 37.19           O  
ATOM    778  ND2 ASN A 104      11.001   2.833  36.189  1.00 34.31           N  
ATOM    779  N   GLU A 105      14.195   5.473  36.360  1.00 30.62           N  
ATOM    780  CA  GLU A 105      15.415   4.801  36.780  1.00 30.98           C  
ATOM    781  C   GLU A 105      15.956   5.323  38.115  1.00 31.27           C  
ATOM    782  O   GLU A 105      16.679   4.609  38.810  1.00 29.85           O  
ATOM    783  CB  GLU A 105      16.480   4.973  35.687  1.00 32.34           C  
ATOM    784  CG  GLU A 105      17.828   4.289  35.932  1.00 32.43           C  
ATOM    785  CD  GLU A 105      17.813   2.800  35.622  1.00 34.74           C  
ATOM    786  OE1 GLU A 105      17.023   2.373  34.753  1.00 36.18           O  
ATOM    787  OE2 GLU A 105      18.609   2.054  36.230  1.00 36.09           O  
ATOM    788  N   PHE A 106      15.590   6.548  38.495  1.00 30.39           N  
ATOM    789  CA  PHE A 106      16.129   7.114  39.728  1.00 30.65           C  
ATOM    790  C   PHE A 106      15.170   7.562  40.829  1.00 30.52           C  
ATOM    791  O   PHE A 106      15.617   7.908  41.921  1.00 31.67           O  
ATOM    792  CB  PHE A 106      17.045   8.291  39.391  1.00 28.99           C  
ATOM    793  CG  PHE A 106      18.097   7.966  38.366  1.00 29.78           C  
ATOM    794  CD1 PHE A 106      17.909   8.299  37.029  1.00 28.95           C  
ATOM    795  CD2 PHE A 106      19.270   7.321  38.739  1.00 27.04           C  
ATOM    796  CE1 PHE A 106      18.875   7.994  36.077  1.00 28.42           C  
ATOM    797  CE2 PHE A 106      20.240   7.010  37.796  1.00 27.37           C  
ATOM    798  CZ  PHE A 106      20.045   7.348  36.463  1.00 28.15           C  
ATOM    799  N   VAL A 107      13.871   7.564  40.569  1.00 29.48           N  
ATOM    800  CA  VAL A 107      12.932   8.017  41.593  1.00 31.21           C  
ATOM    801  C   VAL A 107      11.945   6.944  42.046  1.00 32.23           C  
ATOM    802  O   VAL A 107      11.794   5.908  41.401  1.00 30.09           O  
ATOM    803  CB  VAL A 107      12.111   9.221  41.092  1.00 29.24           C  
ATOM    804  CG1 VAL A 107      13.040  10.298  40.547  1.00 29.53           C  
ATOM    805  CG2 VAL A 107      11.134   8.763  40.021  1.00 26.67           C  
ATOM    806  N   VAL A 108      11.278   7.212  43.168  1.00 34.32           N  
ATOM    807  CA  VAL A 108      10.280   6.305  43.715  1.00 34.03           C  
ATOM    808  C   VAL A 108       8.963   6.541  42.983  1.00 35.18           C  
ATOM    809  O   VAL A 108       8.766   7.590  42.372  1.00 34.30           O  
ATOM    810  CB  VAL A 108      10.068   6.537  45.226  1.00 32.73           C  
ATOM    811  CG1 VAL A 108      11.300   6.091  45.991  1.00 33.11           C  
ATOM    812  CG2 VAL A 108       9.772   8.008  45.503  1.00 33.59           C  
ATOM    813  N   LYS A 109       8.072   5.559  43.049  1.00 36.36           N  
ATOM    814  CA  LYS A 109       6.775   5.618  42.387  1.00 37.62           C  
ATOM    815  C   LYS A 109       5.957   6.875  42.673  1.00 38.02           C  
ATOM    816  O   LYS A 109       5.262   7.382  41.786  1.00 37.19           O  
ATOM    817  CB  LYS A 109       5.945   4.391  42.765  1.00 40.91           C  
ATOM    818  CG  LYS A 109       5.839   3.342  41.667  1.00 45.17           C  
ATOM    819  CD  LYS A 109       7.199   2.826  41.221  1.00 49.87           C  
ATOM    820  CE  LYS A 109       7.427   3.122  39.751  1.00 52.22           C  
ATOM    821  NZ  LYS A 109       8.627   2.425  39.213  1.00 54.41           N  
ATOM    822  N   ASP A 110       6.037   7.375  43.903  1.00 37.41           N  
ATOM    823  CA  ASP A 110       5.278   8.563  44.287  1.00 37.45           C  
ATOM    824  C   ASP A 110       5.952   9.898  43.957  1.00 35.77           C  
ATOM    825  O   ASP A 110       5.388  10.958  44.230  1.00 34.87           O  
ATOM    826  CB  ASP A 110       4.951   8.508  45.783  1.00 42.09           C  
ATOM    827  CG  ASP A 110       4.048   7.336  46.138  1.00 48.83           C  
ATOM    828  OD1 ASP A 110       2.947   7.231  45.550  1.00 51.69           O  
ATOM    829  OD2 ASP A 110       4.437   6.522  47.005  1.00 51.59           O  
ATOM    830  N   PHE A 111       7.150   9.849  43.376  1.00 32.89           N  
ATOM    831  CA  PHE A 111       7.872  11.069  43.006  1.00 30.73           C  
ATOM    832  C   PHE A 111       6.937  12.002  42.242  1.00 29.01           C  
ATOM    833  O   PHE A 111       6.365  11.616  41.227  1.00 29.20           O  
ATOM    834  CB  PHE A 111       9.073  10.727  42.117  1.00 29.71           C  
ATOM    835  CG  PHE A 111       9.893  11.921  41.707  1.00 26.94           C  
ATOM    836  CD1 PHE A 111      10.661  12.609  42.641  1.00 28.77           C  
ATOM    837  CD2 PHE A 111       9.925  12.336  40.381  1.00 28.03           C  
ATOM    838  CE1 PHE A 111      11.457  13.696  42.258  1.00 28.24           C  
ATOM    839  CE2 PHE A 111      10.715  13.421  39.984  1.00 28.32           C  
ATOM    840  CZ  PHE A 111      11.483  14.099  40.930  1.00 28.87           C  
ATOM    841  N   PRO A 112       6.770  13.245  42.728  1.00 30.38           N  
ATOM    842  CA  PRO A 112       5.906  14.252  42.109  1.00 30.58           C  
ATOM    843  C   PRO A 112       6.535  15.010  40.943  1.00 31.78           C  
ATOM    844  O   PRO A 112       7.679  15.473  41.021  1.00 31.03           O  
ATOM    845  CB  PRO A 112       5.588  15.181  43.270  1.00 30.61           C  
ATOM    846  CG  PRO A 112       6.871  15.193  44.005  1.00 32.20           C  
ATOM    847  CD  PRO A 112       7.260  13.725  44.034  1.00 31.82           C  
ATOM    848  N   ILE A 113       5.763  15.135  39.869  1.00 31.05           N  
ATOM    849  CA  ILE A 113       6.189  15.842  38.673  1.00 31.70           C  
ATOM    850  C   ILE A 113       5.147  16.910  38.363  1.00 30.67           C  
ATOM    851  O   ILE A 113       3.999  16.597  38.052  1.00 30.34           O  
ATOM    852  CB  ILE A 113       6.318  14.870  37.478  1.00 32.60           C  
ATOM    853  CG1 ILE A 113       7.450  13.878  37.751  1.00 32.48           C  
ATOM    854  CG2 ILE A 113       6.567  15.645  36.190  1.00 30.97           C  
ATOM    855  CD1 ILE A 113       7.516  12.719  36.768  1.00 35.38           C  
ATOM    856  N   VAL A 114       5.551  18.170  38.471  1.00 30.20           N  
ATOM    857  CA  VAL A 114       4.663  19.295  38.203  1.00 30.26           C  
ATOM    858  C   VAL A 114       4.850  19.777  36.765  1.00 30.22           C  
ATOM    859  O   VAL A 114       5.959  20.139  36.365  1.00 30.68           O  
ATOM    860  CB  VAL A 114       4.965  20.471  39.158  1.00 30.16           C  
ATOM    861  CG1 VAL A 114       3.971  21.591  38.932  1.00 29.75           C  
ATOM    862  CG2 VAL A 114       4.931  19.988  40.609  1.00 31.08           C  
ATOM    863  N   MET A 115       3.766  19.781  35.995  1.00 29.24           N  
ATOM    864  CA  MET A 115       3.809  20.220  34.601  1.00 30.59           C  
ATOM    865  C   MET A 115       3.048  21.533  34.410  1.00 31.88           C  
ATOM    866  O   MET A 115       1.892  21.659  34.821  1.00 31.70           O  
ATOM    867  CB  MET A 115       3.224  19.131  33.702  1.00 30.62           C  
ATOM    868  CG  MET A 115       3.992  17.817  33.806  1.00 33.27           C  
ATOM    869  SD  MET A 115       2.988  16.361  33.497  1.00 38.16           S  
ATOM    870  CE  MET A 115       2.252  16.100  35.140  1.00 34.68           C  
ATOM    871  N   LEU A 116       3.715  22.499  33.780  1.00 30.82           N  
ATOM    872  CA  LEU A 116       3.150  23.822  33.526  1.00 31.54           C  
ATOM    873  C   LEU A 116       3.132  24.196  32.050  1.00 31.91           C  
ATOM    874  O   LEU A 116       3.854  23.613  31.235  1.00 29.30           O  
ATOM    875  CB  LEU A 116       3.976  24.892  34.235  1.00 29.61           C  
ATOM    876  CG  LEU A 116       4.372  24.682  35.690  1.00 29.22           C  
ATOM    877  CD1 LEU A 116       5.314  25.806  36.110  1.00 32.93           C  
ATOM    878  CD2 LEU A 116       3.135  24.648  36.559  1.00 27.89           C  
ATOM    879  N   ASN A 117       2.304  25.180  31.715  1.00 31.22           N  
ATOM    880  CA  ASN A 117       2.257  25.680  30.353  1.00 31.56           C  
ATOM    881  C   ASN A 117       3.291  26.808  30.382  1.00 32.64           C  
ATOM    882  O   ASN A 117       3.969  26.980  31.395  1.00 33.28           O  
ATOM    883  CB  ASN A 117       0.846  26.173  29.994  1.00 30.43           C  
ATOM    884  CG  ASN A 117       0.413  27.383  30.793  1.00 30.05           C  
ATOM    885  OD1 ASN A 117       0.807  27.571  31.947  1.00 28.90           O  
ATOM    886  ND2 ASN A 117      -0.425  28.207  30.181  1.00 29.54           N  
ATOM    887  N   SER A 118       3.422  27.576  29.308  1.00 33.81           N  
ATOM    888  CA  SER A 118       4.438  28.633  29.256  1.00 34.85           C  
ATOM    889  C   SER A 118       4.422  29.686  30.360  1.00 36.34           C  
ATOM    890  O   SER A 118       5.472  30.219  30.725  1.00 37.25           O  
ATOM    891  CB  SER A 118       4.394  29.336  27.898  1.00 34.11           C  
ATOM    892  OG  SER A 118       3.188  30.059  27.743  1.00 37.03           O  
ATOM    893  N   THR A 119       3.250  29.999  30.896  1.00 37.02           N  
ATOM    894  CA  THR A 119       3.166  31.013  31.939  1.00 38.39           C  
ATOM    895  C   THR A 119       2.865  30.430  33.313  1.00 38.95           C  
ATOM    896  O   THR A 119       3.116  31.065  34.340  1.00 39.12           O  
ATOM    897  CB  THR A 119       2.083  32.063  31.608  1.00 39.53           C  
ATOM    898  OG1 THR A 119       0.843  31.399  31.334  1.00 41.45           O  
ATOM    899  CG2 THR A 119       2.486  32.888  30.394  1.00 39.34           C  
ATOM    900  N   GLY A 120       2.339  29.211  33.331  1.00 38.85           N  
ATOM    901  CA  GLY A 120       1.996  28.587  34.594  1.00 38.71           C  
ATOM    902  C   GLY A 120       0.540  28.865  34.919  1.00 39.28           C  
ATOM    903  O   GLY A 120       0.096  28.654  36.050  1.00 39.46           O  
ATOM    904  N   SER A 121      -0.201  29.349  33.924  1.00 39.20           N  
ATOM    905  CA  SER A 121      -1.617  29.646  34.090  1.00 38.80           C  
ATOM    906  C   SER A 121      -2.396  28.332  34.085  1.00 39.03           C  
ATOM    907  O   SER A 121      -3.583  28.295  34.402  1.00 39.84           O  
ATOM    908  CB  SER A 121      -2.107  30.568  32.966  1.00 38.93           C  
ATOM    909  OG  SER A 121      -1.881  30.003  31.687  1.00 38.98           O  
ATOM    910  N   ARG A 122      -1.715  27.255  33.707  1.00 38.76           N  
ATOM    911  CA  ARG A 122      -2.305  25.918  33.701  1.00 39.22           C  
ATOM    912  C   ARG A 122      -1.235  25.013  34.303  1.00 38.97           C  
ATOM    913  O   ARG A 122      -0.064  25.094  33.927  1.00 38.77           O  
ATOM    914  CB  ARG A 122      -2.648  25.450  32.277  1.00 40.23           C  
ATOM    915  CG  ARG A 122      -3.394  24.111  32.250  1.00 44.18           C  
ATOM    916  CD  ARG A 122      -3.532  23.522  30.848  1.00 45.36           C  
ATOM    917  NE  ARG A 122      -4.502  24.231  30.016  1.00 46.93           N  
ATOM    918  CZ  ARG A 122      -5.817  24.210  30.207  1.00 48.03           C  
ATOM    919  NH1 ARG A 122      -6.339  23.514  31.207  1.00 48.85           N  
ATOM    920  NH2 ARG A 122      -6.615  24.887  29.391  1.00 49.53           N  
ATOM    921  N   SER A 123      -1.631  24.165  35.246  1.00 38.29           N  
ATOM    922  CA  SER A 123      -0.680  23.277  35.896  1.00 38.41           C  
ATOM    923  C   SER A 123      -1.327  21.954  36.265  1.00 37.93           C  
ATOM    924  O   SER A 123      -2.540  21.872  36.453  1.00 37.93           O  
ATOM    925  CB  SER A 123      -0.124  23.936  37.155  1.00 39.13           C  
ATOM    926  OG  SER A 123      -1.155  24.116  38.107  1.00 42.03           O  
ATOM    927  N   LYS A 124      -0.497  20.926  36.386  1.00 36.70           N  
ATOM    928  CA  LYS A 124      -0.962  19.589  36.712  1.00 36.79           C  
ATOM    929  C   LYS A 124       0.141  18.877  37.483  1.00 36.83           C  
ATOM    930  O   LYS A 124       1.325  19.106  37.238  1.00 37.08           O  
ATOM    931  CB  LYS A 124      -1.269  18.839  35.413  1.00 38.23           C  
ATOM    932  CG  LYS A 124      -1.705  17.393  35.568  1.00 41.28           C  
ATOM    933  CD  LYS A 124      -3.214  17.254  35.692  1.00 43.76           C  
ATOM    934  CE  LYS A 124      -3.630  15.788  35.620  1.00 44.63           C  
ATOM    935  NZ  LYS A 124      -5.107  15.616  35.613  1.00 44.05           N  
ATOM    936  N   VAL A 125      -0.242  18.024  38.425  1.00 35.77           N  
ATOM    937  CA  VAL A 125       0.736  17.277  39.201  1.00 36.87           C  
ATOM    938  C   VAL A 125       0.414  15.791  39.114  1.00 36.30           C  
ATOM    939  O   VAL A 125      -0.708  15.374  39.395  1.00 35.80           O  
ATOM    940  CB  VAL A 125       0.733  17.690  40.690  1.00 38.67           C  
ATOM    941  CG1 VAL A 125       1.914  17.040  41.405  1.00 39.68           C  
ATOM    942  CG2 VAL A 125       0.797  19.203  40.816  1.00 40.63           C  
ATOM    943  N   MET A 126       1.402  14.998  38.712  1.00 35.30           N  
ATOM    944  CA  MET A 126       1.236  13.552  38.594  1.00 35.79           C  
ATOM    945  C   MET A 126       2.492  12.870  39.118  1.00 35.60           C  
ATOM    946  O   MET A 126       3.592  13.407  38.995  1.00 36.16           O  
ATOM    947  CB  MET A 126       1.010  13.152  37.135  1.00 37.80           C  
ATOM    948  CG  MET A 126      -0.324  13.584  36.564  1.00 41.02           C  
ATOM    949  SD  MET A 126      -0.499  13.099  34.836  1.00 48.62           S  
ATOM    950  CE  MET A 126      -1.162  11.423  34.982  1.00 43.90           C  
ATOM    951  N   THR A 127       2.332  11.688  39.699  1.00 33.94           N  
ATOM    952  CA  THR A 127       3.474  10.958  40.236  1.00 32.19           C  
ATOM    953  C   THR A 127       4.162  10.141  39.150  1.00 30.28           C  
ATOM    954  O   THR A 127       3.587   9.868  38.095  1.00 26.42           O  
ATOM    955  CB  THR A 127       3.044   9.985  41.358  1.00 33.35           C  
ATOM    956  OG1 THR A 127       2.185   8.978  40.806  1.00 32.83           O  
ATOM    957  CG2 THR A 127       2.303  10.732  42.466  1.00 34.16           C  
ATOM    958  N   MET A 128       5.397   9.738  39.423  1.00 31.54           N  
ATOM    959  CA  MET A 128       6.152   8.930  38.475  1.00 33.09           C  
ATOM    960  C   MET A 128       5.325   7.699  38.112  1.00 33.85           C  
ATOM    961  O   MET A 128       5.229   7.319  36.946  1.00 34.95           O  
ATOM    962  CB  MET A 128       7.474   8.489  39.100  1.00 33.44           C  
ATOM    963  CG  MET A 128       8.329   7.628  38.190  1.00 35.28           C  
ATOM    964  SD  MET A 128       8.846   8.522  36.712  1.00 40.25           S  
ATOM    965  CE  MET A 128       7.672   7.936  35.500  1.00 36.40           C  
ATOM    966  N   GLY A 129       4.726   7.088  39.130  1.00 34.43           N  
ATOM    967  CA  GLY A 129       3.912   5.904  38.923  1.00 35.01           C  
ATOM    968  C   GLY A 129       2.751   6.118  37.971  1.00 35.41           C  
ATOM    969  O   GLY A 129       2.442   5.240  37.165  1.00 35.22           O  
ATOM    970  N   GLU A 130       2.106   7.278  38.063  1.00 35.40           N  
ATOM    971  CA  GLU A 130       0.975   7.594  37.194  1.00 36.01           C  
ATOM    972  C   GLU A 130       1.403   7.797  35.741  1.00 33.44           C  
ATOM    973  O   GLU A 130       0.736   7.331  34.825  1.00 34.69           O  
ATOM    974  CB  GLU A 130       0.267   8.865  37.671  1.00 38.95           C  
ATOM    975  CG  GLU A 130      -0.328   8.802  39.067  1.00 45.01           C  
ATOM    976  CD  GLU A 130      -0.908  10.143  39.495  1.00 47.97           C  
ATOM    977  OE1 GLU A 130      -1.794  10.660  38.784  1.00 50.30           O  
ATOM    978  OE2 GLU A 130      -0.473  10.684  40.535  1.00 50.73           O  
ATOM    979  N   LEU A 131       2.517   8.495  35.535  1.00 32.45           N  
ATOM    980  CA  LEU A 131       3.006   8.773  34.185  1.00 30.68           C  
ATOM    981  C   LEU A 131       3.592   7.571  33.441  1.00 28.99           C  
ATOM    982  O   LEU A 131       3.616   7.558  32.212  1.00 28.65           O  
ATOM    983  CB  LEU A 131       4.035   9.913  34.227  1.00 29.47           C  
ATOM    984  CG  LEU A 131       3.450  11.297  34.549  1.00 30.14           C  
ATOM    985  CD1 LEU A 131       4.555  12.323  34.797  1.00 29.49           C  
ATOM    986  CD2 LEU A 131       2.576  11.737  33.397  1.00 29.07           C  
ATOM    987  N   LEU A 132       4.075   6.572  34.170  1.00 29.08           N  
ATOM    988  CA  LEU A 132       4.644   5.389  33.522  1.00 29.59           C  
ATOM    989  C   LEU A 132       4.220   4.097  34.229  1.00 29.63           C  
ATOM    990  O   LEU A 132       4.988   3.515  34.992  1.00 29.52           O  
ATOM    991  CB  LEU A 132       6.174   5.484  33.488  1.00 28.93           C  
ATOM    992  CG  LEU A 132       6.899   4.529  32.531  1.00 27.99           C  
ATOM    993  CD1 LEU A 132       6.647   4.949  31.099  1.00 27.10           C  
ATOM    994  CD2 LEU A 132       8.386   4.536  32.815  1.00 27.30           C  
ATOM    995  N   PRO A 133       2.978   3.646  33.994  1.00 31.27           N  
ATOM    996  CA  PRO A 133       2.452   2.419  34.606  1.00 33.04           C  
ATOM    997  C   PRO A 133       3.191   1.185  34.084  1.00 35.27           C  
ATOM    998  O   PRO A 133       3.600   1.149  32.923  1.00 34.09           O  
ATOM    999  CB  PRO A 133       0.983   2.423  34.183  1.00 32.78           C  
ATOM   1000  CG  PRO A 133       0.678   3.878  33.987  1.00 32.38           C  
ATOM   1001  CD  PRO A 133       1.911   4.372  33.284  1.00 31.14           C  
ATOM   1002  N   MET A 134       3.360   0.179  34.939  1.00 38.76           N  
ATOM   1003  CA  MET A 134       4.057  -1.045  34.544  1.00 43.47           C  
ATOM   1004  C   MET A 134       5.426  -0.726  33.959  1.00 44.54           C  
ATOM   1005  O   MET A 134       5.825  -1.303  32.949  1.00 43.73           O  
ATOM   1006  CB  MET A 134       3.258  -1.811  33.492  1.00 47.20           C  
ATOM   1007  CG  MET A 134       2.083  -2.597  34.009  1.00 53.72           C  
ATOM   1008  SD  MET A 134       1.534  -3.742  32.723  1.00 61.98           S  
ATOM   1009  CE  MET A 134       2.736  -5.075  32.920  1.00 60.65           C  
ATOM   1010  N   ALA A 135       6.145   0.189  34.597  1.00 46.51           N  
ATOM   1011  CA  ALA A 135       7.458   0.592  34.117  1.00 48.30           C  
ATOM   1012  C   ALA A 135       8.383  -0.582  33.833  1.00 50.39           C  
ATOM   1013  O   ALA A 135       8.432  -1.548  34.593  1.00 50.36           O  
ATOM   1014  CB  ALA A 135       8.108   1.529  35.122  1.00 47.93           C  
ATOM   1015  N   PHE A 136       9.106  -0.495  32.720  1.00 51.97           N  
ATOM   1016  CA  PHE A 136      10.065  -1.522  32.337  1.00 53.67           C  
ATOM   1017  C   PHE A 136      11.337  -1.213  33.117  1.00 55.91           C  
ATOM   1018  O   PHE A 136      11.905  -0.131  32.974  1.00 55.99           O  
ATOM   1019  CB  PHE A 136      10.331  -1.462  30.828  1.00 53.00           C  
ATOM   1020  CG  PHE A 136      11.552  -2.225  30.389  1.00 53.80           C  
ATOM   1021  CD1 PHE A 136      12.817  -1.647  30.472  1.00 53.08           C  
ATOM   1022  CD2 PHE A 136      11.441  -3.527  29.907  1.00 54.57           C  
ATOM   1023  CE1 PHE A 136      13.954  -2.351  30.085  1.00 52.57           C  
ATOM   1024  CE2 PHE A 136      12.575  -4.243  29.516  1.00 54.55           C  
ATOM   1025  CZ  PHE A 136      13.834  -3.652  29.606  1.00 53.92           C  
ATOM   1026  N   GLY A 137      11.781  -2.155  33.947  1.00 58.19           N  
ATOM   1027  CA  GLY A 137      12.978  -1.923  34.737  1.00 61.21           C  
ATOM   1028  C   GLY A 137      13.998  -3.048  34.738  1.00 63.81           C  
ATOM   1029  O   GLY A 137      13.917  -3.970  33.926  1.00 63.30           O  
ATOM   1030  N   PRO A 138      14.990  -2.986  35.645  1.00 66.20           N  
ATOM   1031  CA  PRO A 138      16.060  -3.983  35.791  1.00 68.24           C  
ATOM   1032  C   PRO A 138      15.529  -5.383  36.111  1.00 70.02           C  
ATOM   1033  O   PRO A 138      16.232  -6.381  35.940  1.00 69.70           O  
ATOM   1034  CB  PRO A 138      16.898  -3.423  36.938  1.00 67.90           C  
ATOM   1035  CG  PRO A 138      16.708  -1.942  36.800  1.00 67.65           C  
ATOM   1036  CD  PRO A 138      15.226  -1.841  36.541  1.00 66.69           C  
ATOM   1037  N   SER A 139      14.284  -5.439  36.581  1.00 71.99           N  
ATOM   1038  CA  SER A 139      13.638  -6.700  36.933  1.00 74.17           C  
ATOM   1039  C   SER A 139      13.352  -7.522  35.681  1.00 75.43           C  
ATOM   1040  O   SER A 139      13.324  -8.754  35.744  1.00 75.48           O  
ATOM   1041  CB  SER A 139      12.333  -6.434  37.700  1.00 74.49           C  
ATOM   1042  OG  SER A 139      11.472  -5.580  36.964  1.00 74.87           O  
ATOM   1043  N   HIS A 140      13.150  -6.843  34.550  1.00 77.02           N  
ATOM   1044  CA  HIS A 140      12.890  -7.544  33.302  1.00 78.32           C  
ATOM   1045  C   HIS A 140      14.248  -8.229  32.793  1.00 79.38           C  
ATOM   1046  O   HIS A 140      14.193  -9.174  31.996  1.00 79.48           O  
ATOM   1047  CB  HIS A 140      12.237  -6.557  32.258  1.00 78.68           C  
ATOM   1048  CG  HIS A 140      10.877  -5.964  32.646  1.00 79.53           C  
ATOM   1049  ND1 HIS A 140       9.669  -6.594  32.407  1.00 79.96           N  
ATOM   1050  CD2 HIS A 140      10.551  -4.730  33.117  1.00 79.28           C  
ATOM   1051  CE1 HIS A 140       8.664  -5.774  32.700  1.00 79.74           C  
ATOM   1052  NE2 HIS A 140       9.176  -4.640  33.131  1.00 79.65           N  
ATOM   1053  N   LEU A 141      15.430  -7.820  33.320  1.00 80.40           N  
ATOM   1054  CA  LEU A 141      16.796  -8.381  32.965  1.00 81.38           C  
ATOM   1055  C   LEU A 141      17.292  -9.498  33.944  1.00 81.83           C  
ATOM   1056  O   LEU A 141      16.723  -9.631  35.015  1.00 81.79           O  
ATOM   1057  CB  LEU A 141      17.816  -7.238  32.910  1.00 81.69           C  
ATOM   1058  CG  LEU A 141      17.401  -6.019  32.056  1.00 81.97           C  
ATOM   1059  CD1 LEU A 141      18.270  -4.776  32.301  1.00 81.54           C  
ATOM   1060  CD2 LEU A 141      17.450  -6.419  30.588  1.00 81.50           C  
ATOM   1061  N   ASN A 142      18.338 -10.275  33.666  1.00 82.54           N  
ATOM   1062  CA  ASN A 142      18.540 -11.325  34.660  1.00 83.46           C  
ATOM   1063  C   ASN A 142      19.862 -11.969  35.136  1.00 83.71           C  
ATOM   1064  O   ASN A 142      20.734 -12.497  34.375  1.00 84.11           O  
ATOM   1065  CB  ASN A 142      17.666 -12.517  34.344  1.00 84.07           C  
ATOM   1066  CG  ASN A 142      17.880 -13.048  32.912  1.00 85.04           C  
ATOM   1067  OD1 ASN A 142      18.145 -14.234  32.695  1.00 85.48           O  
ATOM   1068  ND2 ASN A 142      17.745 -12.151  31.923  1.00 85.73           N  
ATOM   1069  OXT ASN A 142      20.122 -12.115  36.348  1.00 84.48           O  
TER    1070      ASN A 142                                                      
END
MOLECULE T0461.pdb
ATOM      1  N   GLU    16      19.319  11.894  58.181  1.00 47.03           N  
ATOM      2  CA  GLU    16      18.212  11.089  57.593  1.00 47.23           C  
ATOM      4  CB  GLU    16      18.010   9.793  58.377  1.00 47.32           C  
ATOM      7  CG  GLU    16      17.576   8.619  57.509  1.00 48.39           C  
ATOM     10  CD  GLU    16      17.064   7.416  58.327  1.00 50.46           C  
ATOM     11  OE1 GLU    16      16.178   6.689  57.811  1.00 51.91           O  
ATOM     12  OE2 GLU    16      17.526   7.196  59.479  1.00 50.93           O  
ATOM     13  C   GLU    16      16.896  11.864  57.561  1.00 47.09           C  
ATOM     14  O   GLU    16      15.891  11.376  57.001  1.00 48.08           O  
ATOM     18  N   ASN    17      16.888  13.066  58.143  1.00 46.06           N  
ATOM     19  CA  ASN    17      15.679  13.870  58.188  1.00 45.28           C  
ATOM     21  CB  ASN    17      15.631  14.676  59.487  1.00 45.17           C  
ATOM     24  CG  ASN    17      14.246  15.250  59.773  1.00 44.92           C  
ATOM     25  OD1 ASN    17      13.421  15.378  58.885  1.00 45.51           O  
ATOM     26  ND2 ASN    17      13.989  15.591  61.023  1.00 45.12           N  
ATOM     29  C   ASN    17      15.619  14.792  56.990  1.00 44.97           C  
ATOM     30  O   ASN    17      16.071  15.922  57.046  1.00 44.78           O  
ATOM     32  N   LEU    18      15.026  14.320  55.910  1.00 45.02           N  
ATOM     33  CA  LEU    18      14.988  15.101  54.659  1.00 45.41           C  
ATOM     35  CB  LEU    18      14.792  14.167  53.453  1.00 45.35           C  
ATOM     38  CG  LEU    18      15.875  13.083  53.322  1.00 45.26           C  
ATOM     40  CD1 LEU    18      15.492  12.097  52.210  1.00 45.69           C  
ATOM     44  CD2 LEU    18      17.267  13.703  53.084  1.00 42.76           C  
ATOM     48  C   LEU    18      13.920  16.202  54.656  1.00 45.40           C  
ATOM     49  O   LEU    18      12.854  16.047  55.244  1.00 46.03           O  
ATOM     51  N   TYR    19      14.208  17.291  53.954  1.00 45.10           N  
ATOM     52  CA  TYR    19      13.361  18.473  53.903  1.00 44.79           C  
ATOM     54  CB  TYR    19      14.284  19.669  53.829  1.00 45.04           C  
ATOM     57  CG  TYR    19      13.663  21.040  53.814  1.00 45.91           C  
ATOM     58  CD1 TYR    19      13.769  21.878  54.930  1.00 46.50           C  
ATOM     60  CE1 TYR    19      13.223  23.142  54.930  1.00 46.23           C  
ATOM     62  CZ  TYR    19      12.595  23.603  53.806  1.00 45.82           C  
ATOM     63  OH  TYR    19      12.078  24.858  53.838  1.00 47.34           O  
ATOM     65  CE2 TYR    19      12.478  22.813  52.668  1.00 46.79           C  
ATOM     67  CD2 TYR    19      13.017  21.538  52.672  1.00 46.25           C  
ATOM     69  C   TYR    19      12.486  18.434  52.655  1.00 45.02           C  
ATOM     70  O   TYR    19      12.973  18.134  51.545  1.00 44.56           O  
ATOM     72  N   PHE    20      11.200  18.768  52.836  1.00 45.35           N  
ATOM     73  CA  PHE    20      10.180  18.735  51.761  1.00 44.99           C  
ATOM     75  CB  PHE    20       8.875  18.070  52.229  1.00 44.60           C  
ATOM     78  CG  PHE    20       8.967  16.583  52.430  1.00 44.31           C  
ATOM     79  CD1 PHE    20       8.814  16.023  53.683  1.00 45.43           C  
ATOM     81  CE1 PHE    20       8.871  14.634  53.877  1.00 44.99           C  
ATOM     83  CZ  PHE    20       9.077  13.820  52.843  1.00 43.54           C  
ATOM     85  CE2 PHE    20       9.199  14.351  51.588  1.00 44.96           C  
ATOM     87  CD2 PHE    20       9.152  15.735  51.379  1.00 44.56           C  
ATOM     89  C   PHE    20       9.859  20.151  51.339  1.00 44.84           C  
ATOM     90  O   PHE    20       9.575  20.984  52.162  1.00 45.26           O  
ATOM     92  N   GLN    21       9.875  20.414  50.048  1.00 45.39           N  
ATOM     93  CA  GLN    21       9.553  21.743  49.542  1.00 45.85           C  
ATOM     95  CB  GLN    21       9.966  21.882  48.065  1.00 46.10           C  
ATOM     98  CG  GLN    21      11.462  21.638  47.776  1.00 45.85           C  
ATOM    101  CD  GLN    21      12.355  22.618  48.495  1.00 46.50           C  
ATOM    102  OE1 GLN    21      12.212  23.845  48.353  1.00 47.26           O  
ATOM    103  NE2 GLN    21      13.273  22.092  49.288  1.00 45.90           N  
ATOM    106  C   GLN    21       8.049  22.035  49.714  1.00 46.07           C  
ATOM    107  O   GLN    21       7.198  21.166  49.469  1.00 45.86           O  
ATOM    109  N   SER    22       7.741  23.259  50.150  1.00 45.86           N  
ATOM    110  CA  SER    22       6.375  23.680  50.384  1.00 45.60           C  
ATOM    112  CB  SER    22       6.366  24.830  51.367  1.00 45.59           C  
ATOM    115  OG  SER    22       6.782  26.037  50.750  1.00 46.30           O  
ATOM    117  C   SER    22       5.742  24.134  49.088  1.00 45.80           C  
ATOM    118  O   SER    22       6.407  24.114  48.046  1.00 45.84           O  
ATOM    120  N   MET    23       4.473  24.560  49.153  1.00 46.02           N  
ATOM    121  CA  MET    23       3.772  25.115  47.983  1.00 46.05           C  
ATOM    123  CB  MET    23       2.313  25.460  48.298  1.00 46.56           C  
ATOM    126  CG  MET    23       1.275  24.330  48.059  1.00 48.82           C  
ATOM    129  SD  MET    23       1.254  23.496  46.412  1.00 52.49           S  
ATOM    130  CE  MET    23      -0.396  22.776  46.537  1.00 50.38           C  
ATOM    134  C   MET    23       4.432  26.367  47.439  1.00 45.55           C  
ATOM    135  O   MET    23       4.601  26.477  46.236  1.00 45.57           O  
ATOM    137  N   GLU    24       4.773  27.312  48.309  1.00 45.12           N  
ATOM    138  CA  GLU    24       5.405  28.529  47.862  1.00 45.24           C  
ATOM    140  CB  GLU    24       5.574  29.505  49.001  1.00 45.00           C  
ATOM    143  CG  GLU    24       4.249  30.004  49.540  1.00 45.52           C  
ATOM    146  CD  GLU    24       4.420  31.305  50.323  1.00 47.26           C  
ATOM    147  OE1 GLU    24       5.446  31.973  50.070  1.00 48.66           O  
ATOM    148  OE2 GLU    24       3.543  31.676  51.171  1.00 46.60           O  
ATOM    149  C   GLU    24       6.756  28.195  47.248  1.00 45.58           C  
ATOM    150  O   GLU    24       7.118  28.700  46.165  1.00 45.97           O  
ATOM    152  N   GLU    25       7.499  27.321  47.916  1.00 45.42           N  
ATOM    153  CA  GLU    25       8.791  26.893  47.383  1.00 45.38           C  
ATOM    155  CB  GLU    25       9.527  26.016  48.395  1.00 45.48           C  
ATOM    158  CG  GLU    25       9.801  26.759  49.699  1.00 46.23           C  
ATOM    161  CD  GLU    25      10.373  25.873  50.810  1.00 47.64           C  
ATOM    162  OE1 GLU    25       9.890  24.719  51.016  1.00 46.52           O  
ATOM    163  OE2 GLU    25      11.298  26.364  51.498  1.00 48.29           O  
ATOM    164  C   GLU    25       8.695  26.205  46.022  1.00 44.72           C  
ATOM    165  O   GLU    25       9.574  26.385  45.200  1.00 44.67           O  
ATOM    167  N   THR    26       7.633  25.425  45.805  1.00 44.33           N  
ATOM    168  CA  THR    26       7.333  24.809  44.497  1.00 43.62           C  
ATOM    170  CB  THR    26       6.097  23.810  44.583  1.00 43.61           C  
ATOM    172  OG1 THR    26       6.387  22.773  45.511  1.00 42.09           O  
ATOM    174  CG2 THR    26       5.748  23.157  43.247  1.00 42.42           C  
ATOM    178  C   THR    26       7.092  25.942  43.492  1.00 43.04           C  
ATOM    179  O   THR    26       7.712  25.993  42.437  1.00 42.50           O  
ATOM    181  N   GLU    27       6.220  26.875  43.843  1.00 42.37           N  
ATOM    182  CA  GLU    27       5.971  28.002  42.978  1.00 42.31           C  
ATOM    184  CB  GLU    27       5.035  29.005  43.622  1.00 42.84           C  
ATOM    187  CG  GLU    27       3.580  28.566  43.707  1.00 44.60           C  
ATOM    190  CD  GLU    27       2.700  29.690  44.267  1.00 47.31           C  
ATOM    191  OE1 GLU    27       3.193  30.857  44.272  1.00 48.72           O  
ATOM    192  OE2 GLU    27       1.529  29.432  44.703  1.00 48.41           O  
ATOM    193  C   GLU    27       7.270  28.692  42.631  1.00 40.95           C  
ATOM    194  O   GLU    27       7.497  29.041  41.480  1.00 41.59           O  
ATOM    196  N   LYS    28       8.126  28.886  43.622  1.00 39.03           N  
ATOM    197  CA  LYS    28       9.440  29.455  43.359  1.00 37.62           C  
ATOM    199  CB  LYS    28      10.250  29.534  44.641  1.00 37.50           C  
ATOM    202  CG  LYS    28      11.590  30.230  44.447  1.00 38.41           C  
ATOM    205  CD  LYS    28      12.753  29.466  45.069  1.00 39.23           C  
ATOM    208  CE  LYS    28      12.679  29.456  46.565  1.00 38.91           C  
ATOM    211  NZ  LYS    28      13.578  28.418  47.073  1.00 40.24           N  
ATOM    215  C   LYS    28      10.246  28.672  42.302  1.00 35.90           C  
ATOM    216  O   LYS    28      10.746  29.267  41.371  1.00 36.93           O  
ATOM    218  N   TRP    29      10.371  27.357  42.443  1.00 33.27           N  
ATOM    219  CA  TRP    29      11.165  26.570  41.498  1.00 31.54           C  
ATOM    221  CB  TRP    29      11.338  25.115  41.957  1.00 30.99           C  
ATOM    224  CG  TRP    29      11.998  24.926  43.278  1.00 30.44           C  
ATOM    225  CD1 TRP    29      11.570  24.110  44.281  1.00 30.13           C  
ATOM    227  NE1 TRP    29      12.435  24.175  45.351  1.00 30.02           N  
ATOM    229  CE2 TRP    29      13.444  25.050  45.056  1.00 29.08           C  
ATOM    230  CD2 TRP    29      13.206  25.551  43.764  1.00 29.84           C  
ATOM    231  CE3 TRP    29      14.106  26.479  43.230  1.00 30.17           C  
ATOM    233  CZ3 TRP    29      15.182  26.878  43.993  1.00 29.10           C  
ATOM    235  CH2 TRP    29      15.381  26.365  45.270  1.00 28.82           C  
ATOM    237  CZ2 TRP    29      14.522  25.453  45.820  1.00 28.69           C  
ATOM    239  C   TRP    29      10.577  26.553  40.093  1.00 30.66           C  
ATOM    240  O   TRP    29      11.321  26.503  39.114  1.00 30.04           O  
ATOM    242  N   MET    30       9.250  26.560  39.994  1.00 29.83           N  
ATOM    243  CA  MET    30       8.583  26.606  38.693  1.00 29.32           C  
ATOM    245  CB  MET    30       7.080  26.363  38.827  1.00 29.13           C  
ATOM    248  CG  MET    30       6.695  24.908  39.105  1.00 28.73           C  
ATOM    251  SD  MET    30       7.113  23.702  37.840  1.00 25.62           S  
ATOM    252  CE  MET    30       6.050  24.188  36.496  1.00 25.40           C  
ATOM    256  C   MET    30       8.816  27.922  37.964  1.00 28.82           C  
ATOM    257  O   MET    30       8.940  27.927  36.765  1.00 28.66           O  
ATOM    259  N   GLU    31       8.873  29.027  38.689  1.00 28.72           N  
ATOM    260  CA  GLU    31       9.214  30.321  38.090  1.00 29.06           C  
ATOM    262  CB  GLU    31       9.174  31.465  39.137  1.00 29.45           C  
ATOM    265  CG  GLU    31       7.991  32.434  39.044  1.00 29.57           C  
ATOM    268  CD  GLU    31       7.831  33.294  40.339  1.00 33.21           C  
ATOM    269  OE1 GLU    31       7.467  34.564  40.270  1.00 32.31           O  
ATOM    270  OE2 GLU    31       8.075  32.684  41.452  1.00 35.33           O  
ATOM    271  C   GLU    31      10.604  30.262  37.479  1.00 28.87           C  
ATOM    272  O   GLU    31      10.827  30.752  36.382  1.00 28.74           O  
ATOM    274  N   GLU    32      11.544  29.670  38.205  1.00 28.87           N  
ATOM    275  CA  GLU    32      12.909  29.533  37.701  1.00 29.07           C  
ATOM    277  CB  GLU    32      13.876  29.003  38.777  1.00 29.29           C  
ATOM    280  CG  GLU    32      15.319  29.531  38.660  1.00 30.35           C  
ATOM    283  CD  GLU    32      16.038  29.670  40.034  1.00 32.92           C  
ATOM    284  OE1 GLU    32      16.446  28.584  40.580  1.00 33.02           O  
ATOM    285  OE2 GLU    32      16.223  30.868  40.532  1.00 32.31           O  
ATOM    286  C   GLU    32      12.932  28.636  36.474  1.00 29.00           C  
ATOM    287  O   GLU    32      13.630  28.954  35.536  1.00 29.87           O  
ATOM    289  N   ALA    33      12.176  27.534  36.469  1.00 28.65           N  
ATOM    290  CA  ALA    33      12.074  26.677  35.272  1.00 28.41           C  
ATOM    292  CB  ALA    33      11.272  25.376  35.580  1.00 28.13           C  
ATOM    296  C   ALA    33      11.467  27.433  34.073  1.00 27.98           C  
ATOM    297  O   ALA    33      11.779  27.140  32.919  1.00 27.17           O  
ATOM    299  N   MET    34      10.613  28.412  34.367  1.00 27.93           N  
ATOM    300  CA  MET    34       9.948  29.219  33.339  1.00 28.14           C  
ATOM    302  CB  MET    34       8.803  30.030  33.949  1.00 28.21           C  
ATOM    305  CG  MET    34       7.517  29.250  34.113  1.00 28.80           C  
ATOM    308  SD  MET    34       6.705  28.872  32.536  1.00 30.50           S  
ATOM    309  CE  MET    34       6.132  30.522  32.012  1.00 29.12           C  
ATOM    313  C   MET    34      10.916  30.175  32.664  1.00 28.10           C  
ATOM    314  O   MET    34      10.875  30.374  31.449  1.00 27.67           O  
ATOM    316  N   HIS    35      11.789  30.765  33.467  1.00 28.28           N  
ATOM    317  CA  HIS    35      12.821  31.630  32.951  1.00 28.33           C  
ATOM    319  CB  HIS    35      13.581  32.265  34.112  1.00 28.41           C  
ATOM    322  CG  HIS    35      12.858  33.425  34.730  1.00 29.93           C  
ATOM    323  ND1 HIS    35      11.876  34.132  34.062  1.00 31.57           N  
ATOM    325  CE1 HIS    35      11.437  35.118  34.832  1.00 31.30           C  
ATOM    327  NE2 HIS    35      12.092  35.071  35.978  1.00 31.32           N  
ATOM    329  CD2 HIS    35      12.985  34.021  35.943  1.00 31.00           C  
ATOM    331  C   HIS    35      13.742  30.839  32.027  1.00 28.17           C  
ATOM    332  O   HIS    35      14.065  31.289  30.934  1.00 27.82           O  
ATOM    334  N   MET    36      14.123  29.641  32.458  1.00 28.15           N  
ATOM    335  CA  MET    36      14.961  28.760  31.661  1.00 28.40           C  
ATOM    337  CB  MET    36      15.322  27.506  32.450  1.00 28.40           C  
ATOM    340  CG  MET    36      16.315  27.796  33.560  1.00 29.25           C  
ATOM    343  SD  MET    36      16.813  26.309  34.428  1.00 31.57           S  
ATOM    344  CE  MET    36      18.067  25.576  33.340  1.00 32.53           C  
ATOM    348  C   MET    36      14.308  28.388  30.336  1.00 28.59           C  
ATOM    349  O   MET    36      14.979  28.316  29.303  1.00 28.44           O  
ATOM    351  N   ALA    37      12.999  28.161  30.359  1.00 28.78           N  
ATOM    352  CA  ALA    37      12.272  27.908  29.139  1.00 28.45           C  
ATOM    354  CB  ALA    37      10.865  27.523  29.464  1.00 28.21           C  
ATOM    358  C   ALA    37      12.350  29.138  28.203  1.00 28.53           C  
ATOM    359  O   ALA    37      12.535  28.976  26.991  1.00 28.74           O  
ATOM    361  N   LYS    38      12.254  30.353  28.753  1.00 28.46           N  
ATOM    362  CA  LYS    38      12.479  31.585  27.952  1.00 28.77           C  
ATOM    364  CB  LYS    38      12.362  32.855  28.810  1.00 28.84           C  
ATOM    367  CG  LYS    38      11.173  33.763  28.490  1.00 29.78           C  
ATOM    370  CD  LYS    38      10.670  34.538  29.775  1.00 31.42           C  
ATOM    373  CE  LYS    38       9.790  33.635  30.740  1.00 31.00           C  
ATOM    376  NZ  LYS    38       9.628  34.146  32.144  1.00 30.04           N  
ATOM    380  C   LYS    38      13.844  31.602  27.254  1.00 28.67           C  
ATOM    381  O   LYS    38      13.935  31.826  26.059  1.00 28.60           O  
ATOM    383  N   GLU    39      14.903  31.388  28.029  1.00 28.92           N  
ATOM    384  CA  GLU    39      16.255  31.241  27.491  1.00 29.07           C  
ATOM    386  CB  GLU    39      17.256  30.896  28.615  1.00 29.32           C  
ATOM    389  CG  GLU    39      17.683  32.092  29.525  1.00 29.97           C  
ATOM    392  CD  GLU    39      18.618  31.675  30.698  1.00 30.95           C  
ATOM    393  OE1 GLU    39      18.395  30.602  31.336  1.00 31.36           O  
ATOM    394  OE2 GLU    39      19.579  32.435  30.976  1.00 30.64           O  
ATOM    395  C   GLU    39      16.323  30.161  26.391  1.00 29.31           C  
ATOM    396  O   GLU    39      16.994  30.352  25.385  1.00 29.93           O  
ATOM    398  N   ALA    40      15.655  29.025  26.568  1.00 29.26           N  
ATOM    399  CA  ALA    40      15.675  27.990  25.538  1.00 29.14           C  
ATOM    401  CB  ALA    40      14.954  26.733  26.023  1.00 29.09           C  
ATOM    405  C   ALA    40      15.052  28.523  24.233  1.00 29.31           C  
ATOM    406  O   ALA    40      15.647  28.416  23.135  1.00 29.24           O  
ATOM    408  N   LEU    41      13.866  29.115  24.357  1.00 29.40           N  
ATOM    409  CA  LEU    41      13.176  29.725  23.208  1.00 29.34           C  
ATOM    411  CB  LEU    41      12.006  30.573  23.716  1.00 29.30           C  
ATOM    414  CG  LEU    41      11.070  31.167  22.677  1.00 28.71           C  
ATOM    416  CD1 LEU    41      10.148  30.062  22.197  1.00 28.68           C  
ATOM    420  CD2 LEU    41      10.302  32.340  23.267  1.00 27.42           C  
ATOM    424  C   LEU    41      14.117  30.616  22.372  1.00 29.48           C  
ATOM    425  O   LEU    41      14.211  30.475  21.134  1.00 29.85           O  
ATOM    427  N   GLU    42      14.821  31.511  23.067  1.00 29.00           N  
ATOM    428  CA  GLU    42      15.649  32.517  22.438  1.00 28.74           C  
ATOM    430  CB  GLU    42      15.908  33.598  23.449  1.00 28.67           C  
ATOM    433  CG  GLU    42      14.645  34.363  23.746  1.00 29.55           C  
ATOM    436  CD  GLU    42      14.781  35.250  24.971  1.00 31.30           C  
ATOM    437  OE1 GLU    42      15.008  34.664  26.080  1.00 30.85           O  
ATOM    438  OE2 GLU    42      14.659  36.515  24.804  1.00 30.70           O  
ATOM    439  C   GLU    42      16.957  31.966  21.908  1.00 28.87           C  
ATOM    440  O   GLU    42      17.677  32.661  21.201  1.00 28.72           O  
ATOM    442  N   ASN    43      17.266  30.718  22.268  1.00 29.31           N  
ATOM    443  CA  ASN    43      18.369  29.949  21.660  1.00 29.26           C  
ATOM    445  CB  ASN    43      19.164  29.173  22.728  1.00 29.03           C  
ATOM    448  CG  ASN    43      19.818  30.083  23.766  1.00 29.03           C  
ATOM    449  OD1 ASN    43      20.204  31.217  23.469  1.00 28.55           O  
ATOM    450  ND2 ASN    43      19.954  29.576  24.993  1.00 28.89           N  
ATOM    453  C   ASN    43      17.872  28.958  20.602  1.00 29.20           C  
ATOM    454  O   ASN    43      18.569  27.989  20.314  1.00 29.62           O  
ATOM    456  N   THR    44      16.686  29.195  20.033  1.00 28.87           N  
ATOM    457  CA  THR    44      16.102  28.289  19.041  1.00 28.84           C  
ATOM    459  CB  THR    44      16.897  28.318  17.748  1.00 28.74           C  
ATOM    461  OG1 THR    44      17.471  29.619  17.586  1.00 29.50           O  
ATOM    463  CG2 THR    44      15.986  27.971  16.552  1.00 28.77           C  
ATOM    467  C   THR    44      16.009  26.828  19.506  1.00 28.90           C  
ATOM    468  O   THR    44      16.232  25.893  18.716  1.00 28.57           O  
ATOM    470  N   GLU    45      15.692  26.641  20.789  1.00 28.78           N  
ATOM    471  CA  GLU    45      15.473  25.302  21.339  1.00 28.92           C  
ATOM    473  CB  GLU    45      16.415  25.012  22.521  1.00 28.92           C  
ATOM    476  CG  GLU    45      17.931  25.000  22.196  1.00 29.45           C  
ATOM    479  CD  GLU    45      18.448  23.676  21.635  1.00 29.36           C  
ATOM    480  OE1 GLU    45      19.688  23.562  21.442  1.00 27.01           O  
ATOM    481  OE2 GLU    45      17.612  22.771  21.370  1.00 30.17           O  
ATOM    482  C   GLU    45      14.006  25.190  21.777  1.00 28.65           C  
ATOM    483  O   GLU    45      13.339  26.213  22.050  1.00 29.00           O  
ATOM    485  N   VAL    46      13.501  23.955  21.814  1.00 27.84           N  
ATOM    486  CA  VAL    46      12.162  23.715  22.317  1.00 27.20           C  
ATOM    488  CB  VAL    46      11.844  22.202  22.430  1.00 27.04           C  
ATOM    490  CG1 VAL    46      10.470  22.021  22.949  1.00 26.48           C  
ATOM    494  CG2 VAL    46      11.994  21.495  21.085  1.00 25.84           C  
ATOM    498  C   VAL    46      12.218  24.332  23.700  1.00 26.94           C  
ATOM    499  O   VAL    46      13.138  24.032  24.430  1.00 27.21           O  
ATOM    501  N   PRO    47      11.286  25.236  24.048  1.00 26.78           N  
ATOM    502  CA  PRO    47      11.296  25.903  25.373  1.00 26.70           C  
ATOM    504  CB  PRO    47      10.367  27.113  25.179  1.00 26.66           C  
ATOM    507  CG  PRO    47       9.422  26.670  24.121  1.00 27.05           C  
ATOM    510  CD  PRO    47      10.184  25.723  23.207  1.00 26.93           C  
ATOM    513  C   PRO    47      10.822  25.037  26.522  1.00 26.24           C  
ATOM    514  O   PRO    47       9.673  25.088  26.918  1.00 26.00           O  
ATOM    515  N   VAL    48      11.735  24.233  27.027  1.00 26.62           N  
ATOM    516  CA  VAL    48      11.513  23.417  28.200  1.00 27.16           C  
ATOM    518  CB  VAL    48      11.457  21.880  27.852  1.00 27.41           C  
ATOM    520  CG1 VAL    48      11.253  21.035  29.132  1.00 26.53           C  
ATOM    524  CG2 VAL    48      10.393  21.571  26.783  1.00 25.65           C  
ATOM    528  C   VAL    48      12.716  23.717  29.106  1.00 27.85           C  
ATOM    529  O   VAL    48      13.887  23.614  28.672  1.00 28.19           O  
ATOM    531  N   GLY    49      12.435  24.143  30.334  1.00 27.89           N  
ATOM    532  CA  GLY    49      13.460  24.283  31.361  1.00 27.79           C  
ATOM    535  C   GLY    49      13.077  23.403  32.544  1.00 27.95           C  
ATOM    536  O   GLY    49      11.895  23.182  32.778  1.00 28.14           O  
ATOM    538  N   CYS    50      14.052  22.876  33.284  1.00 27.93           N  
ATOM    539  CA  CYS    50      13.715  22.173  34.504  1.00 28.84           C  
ATOM    541  CB  CYS    50      13.297  20.749  34.174  1.00 28.84           C  
ATOM    544  SG  CYS    50      14.643  19.606  34.018  1.00 33.39           S  
ATOM    546  C   CYS    50      14.794  22.187  35.602  1.00 28.72           C  
ATOM    547  O   CYS    50      15.972  22.404  35.318  1.00 28.99           O  
ATOM    549  N   LEU    51      14.348  21.985  36.849  1.00 28.66           N  
ATOM    550  CA  LEU    51      15.194  21.936  38.050  1.00 28.44           C  
ATOM    552  CB  LEU    51      14.880  23.128  38.954  1.00 28.29           C  
ATOM    555  CG  LEU    51      15.232  24.521  38.431  1.00 28.29           C  
ATOM    557  CD1 LEU    51      14.136  25.489  38.675  1.00 29.32           C  
ATOM    561  CD2 LEU    51      16.480  25.050  39.095  1.00 30.45           C  
ATOM    565  C   LEU    51      14.956  20.617  38.827  1.00 28.35           C  
ATOM    566  O   LEU    51      13.876  20.048  38.798  1.00 28.95           O  
ATOM    568  N   MET    52      15.958  20.126  39.526  1.00 27.97           N  
ATOM    569  CA  MET    52      15.745  19.011  40.400  1.00 28.22           C  
ATOM    571  CB  MET    52      16.413  17.765  39.825  1.00 28.57           C  
ATOM    574  CG  MET    52      15.607  17.113  38.742  1.00 29.75           C  
ATOM    577  SD  MET    52      16.528  15.808  37.882  1.00 30.98           S  
ATOM    578  CE  MET    52      16.168  14.414  38.917  1.00 33.55           C  
ATOM    582  C   MET    52      16.255  19.354  41.807  1.00 28.12           C  
ATOM    583  O   MET    52      17.427  19.709  42.002  1.00 27.75           O  
ATOM    585  N   VAL    53      15.354  19.242  42.781  1.00 27.75           N  
ATOM    586  CA  VAL    53      15.642  19.628  44.149  1.00 27.86           C  
ATOM    588  CB  VAL    53      14.603  20.664  44.634  1.00 27.43           C  
ATOM    590  CG1 VAL    53      14.756  20.937  46.109  1.00 27.32           C  
ATOM    594  CG2 VAL    53      14.729  21.953  43.833  1.00 27.25           C  
ATOM    598  C   VAL    53      15.710  18.395  45.089  1.00 28.27           C  
ATOM    599  O   VAL    53      14.819  17.559  45.116  1.00 28.02           O  
ATOM    601  N   TYR    54      16.790  18.308  45.863  1.00 28.71           N  
ATOM    602  CA  TYR    54      16.978  17.239  46.855  1.00 28.55           C  
ATOM    604  CB  TYR    54      18.085  16.279  46.430  1.00 28.75           C  
ATOM    607  CG  TYR    54      18.551  15.359  47.499  1.00 27.40           C  
ATOM    608  CD1 TYR    54      17.820  14.230  47.830  1.00 28.08           C  
ATOM    610  CE1 TYR    54      18.244  13.355  48.820  1.00 28.43           C  
ATOM    612  CZ  TYR    54      19.430  13.620  49.480  1.00 29.94           C  
ATOM    613  OH  TYR    54      19.905  12.759  50.454  1.00 32.14           O  
ATOM    615  CE2 TYR    54      20.192  14.739  49.135  1.00 29.42           C  
ATOM    617  CD2 TYR    54      19.745  15.591  48.148  1.00 27.87           C  
ATOM    619  C   TYR    54      17.366  17.869  48.152  1.00 28.27           C  
ATOM    620  O   TYR    54      18.279  18.662  48.173  1.00 28.82           O  
ATOM    622  N   ASN    55      16.677  17.488  49.221  1.00 28.12           N  
ATOM    623  CA  ASN    55      16.918  18.006  50.563  1.00 28.03           C  
ATOM    625  CB  ASN    55      18.059  17.234  51.242  1.00 28.30           C  
ATOM    628  CG  ASN    55      18.050  17.374  52.753  1.00 28.25           C  
ATOM    629  OD1 ASN    55      17.015  17.664  53.345  1.00 27.11           O  
ATOM    630  ND2 ASN    55      19.190  17.134  53.381  1.00 25.68           N  
ATOM    633  C   ASN    55      17.189  19.501  50.573  1.00 27.90           C  
ATOM    634  O   ASN    55      18.159  19.980  51.170  1.00 27.64           O  
ATOM    636  N   ASN    56      16.320  20.224  49.887  1.00 27.79           N  
ATOM    637  CA  ASN    56      16.363  21.691  49.865  1.00 28.13           C  
ATOM    639  CB  ASN    56      16.324  22.254  51.279  1.00 28.01           C  
ATOM    642  CG  ASN    56      15.882  23.683  51.311  1.00 27.94           C  
ATOM    643  OD1 ASN    56      15.237  24.172  50.381  1.00 31.08           O  
ATOM    644  ND2 ASN    56      16.215  24.367  52.378  1.00 27.46           N  
ATOM    647  C   ASN    56      17.533  22.307  49.134  1.00 27.87           C  
ATOM    648  O   ASN    56      17.908  23.425  49.409  1.00 28.32           O  
ATOM    650  N   GLU    57      18.082  21.574  48.183  1.00 27.86           N  
ATOM    651  CA  GLU    57      19.217  22.024  47.409  1.00 27.68           C  
ATOM    653  CB  GLU    57      20.472  21.281  47.847  1.00 27.08           C  
ATOM    656  CG  GLU    57      21.672  21.541  46.962  1.00 28.55           C  
ATOM    659  CD  GLU    57      23.044  21.418  47.718  1.00 30.79           C  
ATOM    660  OE1 GLU    57      24.101  21.861  47.139  1.00 30.38           O  
ATOM    661  OE2 GLU    57      23.061  20.888  48.874  1.00 30.25           O  
ATOM    662  C   GLU    57      18.879  21.798  45.937  1.00 27.63           C  
ATOM    663  O   GLU    57      18.169  20.830  45.585  1.00 27.10           O  
ATOM    665  N   VAL    58      19.321  22.734  45.093  1.00 27.91           N  
ATOM    666  CA  VAL    58      19.139  22.617  43.654  1.00 27.84           C  
ATOM    668  CB  VAL    58      19.194  23.956  42.914  1.00 27.95           C  
ATOM    670  CG1 VAL    58      19.081  23.684  41.414  1.00 27.53           C  
ATOM    674  CG2 VAL    58      18.097  24.893  43.401  1.00 27.26           C  
ATOM    678  C   VAL    58      20.250  21.735  43.142  1.00 27.85           C  
ATOM    679  O   VAL    58      21.372  22.153  42.975  1.00 27.19           O  
ATOM    681  N   VAL    59      19.894  20.494  42.876  1.00 28.57           N  
ATOM    682  CA  VAL    59      20.856  19.448  42.563  1.00 28.61           C  
ATOM    684  CB  VAL    59      20.415  18.170  43.356  1.00 28.52           C  
ATOM    686  CG1 VAL    59      19.333  17.410  42.623  1.00 27.61           C  
ATOM    690  CG2 VAL    59      21.584  17.307  43.628  1.00 30.18           C  
ATOM    694  C   VAL    59      21.022  19.190  41.019  1.00 28.74           C  
ATOM    695  O   VAL    59      21.896  18.437  40.605  1.00 28.89           O  
ATOM    697  N   GLY    60      20.192  19.812  40.180  1.00 28.38           N  
ATOM    698  CA  GLY    60      20.330  19.712  38.737  1.00 28.23           C  
ATOM    701  C   GLY    60      19.404  20.682  38.007  1.00 28.41           C  
ATOM    702  O   GLY    60      18.276  20.866  38.404  1.00 28.63           O  
ATOM    704  N   LYS    61      19.916  21.324  36.960  1.00 28.65           N  
ATOM    705  CA  LYS    61      19.168  22.227  36.093  1.00 28.54           C  
ATOM    707  CB  LYS    61      19.780  23.640  36.140  1.00 28.95           C  
ATOM    710  CG  LYS    61      19.463  24.488  37.367  1.00 28.34           C  
ATOM    713  CD  LYS    61      20.179  25.840  37.225  1.00 29.50           C  
ATOM    716  CE  LYS    61      20.207  26.654  38.541  1.00 30.91           C  
ATOM    719  NZ  LYS    61      18.964  27.499  38.849  1.00 30.87           N  
ATOM    723  C   LYS    61      19.282  21.710  34.650  1.00 28.73           C  
ATOM    724  O   LYS    61      20.198  20.928  34.303  1.00 28.29           O  
ATOM    726  N   GLY    62      18.379  22.158  33.784  1.00 28.67           N  
ATOM    727  CA  GLY    62      18.523  21.784  32.389  1.00 28.85           C  
ATOM    730  C   GLY    62      17.522  22.399  31.467  1.00 28.68           C  
ATOM    731  O   GLY    62      16.377  22.533  31.822  1.00 29.05           O  
ATOM    733  N   ARG    63      17.983  22.761  30.279  1.00 28.89           N  
ATOM    734  CA  ARG    63      17.144  23.177  29.179  1.00 28.89           C  
ATOM    736  CB  ARG    63      17.613  24.542  28.668  1.00 29.02           C  
ATOM    739  CG  ARG    63      17.129  25.716  29.490  1.00 29.86           C  
ATOM    742  CD  ARG    63      18.067  26.929  29.395  1.00 30.14           C  
ATOM    745  NE  ARG    63      19.316  26.658  30.105  1.00 31.33           N  
ATOM    747  CZ  ARG    63      20.264  27.559  30.367  1.00 31.77           C  
ATOM    748  NH1 ARG    63      20.100  28.830  29.992  1.00 31.57           N  
ATOM    751  NH2 ARG    63      21.380  27.181  31.007  1.00 30.99           N  
ATOM    754  C   ARG    63      17.358  22.195  28.056  1.00 29.11           C  
ATOM    755  O   ARG    63      18.388  21.496  28.019  1.00 29.15           O  
ATOM    757  N   ASN    64      16.420  22.169  27.108  1.00 29.06           N  
ATOM    758  CA  ASN    64      16.671  21.481  25.849  1.00 28.97           C  
ATOM    760  CB  ASN    64      15.497  21.629  24.909  1.00 29.21           C  
ATOM    763  CG  ASN    64      14.555  20.442  24.966  1.00 30.76           C  
ATOM    764  OD1 ASN    64      14.095  20.021  26.061  1.00 31.58           O  
ATOM    765  ND2 ASN    64      14.238  19.899  23.783  1.00 30.37           N  
ATOM    768  C   ASN    64      17.914  22.003  25.151  1.00 28.78           C  
ATOM    769  O   ASN    64      18.100  23.209  25.044  1.00 28.39           O  
ATOM    771  N   GLU    65      18.741  21.063  24.683  1.00 28.83           N  
ATOM    772  CA  GLU    65      19.991  21.336  23.956  1.00 28.70           C  
ATOM    774  CB  GLU    65      21.208  20.948  24.811  1.00 28.43           C  
ATOM    777  CG  GLU    65      21.363  21.803  26.060  1.00 29.26           C  
ATOM    780  CD  GLU    65      22.567  21.420  26.935  1.00 31.11           C  
ATOM    781  OE1 GLU    65      23.208  20.350  26.722  1.00 32.83           O  
ATOM    782  OE2 GLU    65      22.862  22.193  27.874  1.00 32.15           O  
ATOM    783  C   GLU    65      20.053  20.599  22.593  1.00 28.61           C  
ATOM    784  O   GLU    65      21.143  20.477  22.010  1.00 28.58           O  
ATOM    786  N   VAL    66      18.896  20.169  22.062  1.00 27.88           N  
ATOM    787  CA  VAL    66      18.886  19.316  20.880  1.00 27.67           C  
ATOM    789  CB  VAL    66      17.459  18.841  20.468  1.00 27.53           C  
ATOM    791  CG1 VAL    66      17.529  18.039  19.197  1.00 26.83           C  
ATOM    795  CG2 VAL    66      16.898  17.936  21.521  1.00 26.62           C  
ATOM    799  C   VAL    66      19.638  19.911  19.702  1.00 27.74           C  
ATOM    800  O   VAL    66      20.368  19.174  19.054  1.00 27.05           O  
ATOM    802  N   ASN    67      19.485  21.227  19.463  1.00 28.26           N  
ATOM    803  CA  ASN    67      20.095  21.919  18.295  1.00 28.74           C  
ATOM    805  CB  ASN    67      19.369  23.234  17.954  1.00 29.15           C  
ATOM    808  CG  ASN    67      17.862  23.046  17.756  1.00 30.45           C  
ATOM    809  OD1 ASN    67      17.316  21.924  17.886  1.00 31.70           O  
ATOM    810  ND2 ASN    67      17.175  24.152  17.467  1.00 29.61           N  
ATOM    813  C   ASN    67      21.546  22.272  18.503  1.00 28.57           C  
ATOM    814  O   ASN    67      22.382  22.068  17.625  1.00 28.06           O  
ATOM    816  N   GLN    68      21.820  22.854  19.661  1.00 28.68           N  
ATOM    817  CA  GLN    68      23.187  23.164  20.074  1.00 29.07           C  
ATOM    819  CB  GLN    68      23.182  23.668  21.536  1.00 29.90           C  
ATOM    822  CG  GLN    68      22.524  25.095  21.719  1.00 32.43           C  
ATOM    825  CD  GLN    68      22.188  25.490  23.188  1.00 32.48           C  
ATOM    826  OE1 GLN    68      21.718  24.669  23.999  1.00 31.76           O  
ATOM    827  NE2 GLN    68      22.424  26.777  23.507  1.00 31.80           N  
ATOM    830  C   GLN    68      24.041  21.912  20.001  1.00 28.56           C  
ATOM    831  O   GLN    68      25.150  21.918  19.494  1.00 27.79           O  
ATOM    833  N   THR    69      23.495  20.836  20.554  1.00 28.62           N  
ATOM    834  CA  THR    69      24.199  19.575  20.692  1.00 28.33           C  
ATOM    836  CB  THR    69      23.715  18.855  21.942  1.00 27.93           C  
ATOM    838  OG1 THR    69      24.674  17.873  22.314  1.00 30.06           O  
ATOM    840  CG2 THR    69      22.403  18.168  21.682  1.00 28.03           C  
ATOM    844  C   THR    69      24.028  18.652  19.476  1.00 28.16           C  
ATOM    845  O   THR    69      24.864  17.762  19.267  1.00 28.11           O  
ATOM    847  N   LYS    70      22.972  18.895  18.683  1.00 27.74           N  
ATOM    848  CA  LYS    70      22.589  18.065  17.531  1.00 27.50           C  
ATOM    850  CB  LYS    70      23.563  18.266  16.384  1.00 27.34           C  
ATOM    853  CG  LYS    70      23.246  19.525  15.632  1.00 28.15           C  
ATOM    856  CD  LYS    70      24.390  19.949  14.775  1.00 29.05           C  
ATOM    859  CE  LYS    70      24.183  21.367  14.275  1.00 29.94           C  
ATOM    862  NZ  LYS    70      25.274  21.771  13.281  1.00 31.00           N  
ATOM    866  C   LYS    70      22.383  16.586  17.886  1.00 27.49           C  
ATOM    867  O   LYS    70      22.638  15.688  17.088  1.00 27.02           O  
ATOM    869  N   ASN    71      21.857  16.364  19.083  1.00 27.55           N  
ATOM    870  CA  ASN    71      21.554  15.046  19.586  1.00 27.78           C  
ATOM    872  CB  ASN    71      22.528  14.710  20.740  1.00 28.42           C  
ATOM    875  CG  ASN    71      22.027  13.539  21.665  1.00 28.76           C  
ATOM    876  OD1 ASN    71      20.966  12.957  21.460  1.00 27.98           O  
ATOM    877  ND2 ASN    71      22.818  13.221  22.698  1.00 28.49           N  
ATOM    880  C   ASN    71      20.093  15.093  20.051  1.00 27.58           C  
ATOM    881  O   ASN    71      19.764  15.768  21.038  1.00 27.17           O  
ATOM    883  N   ALA    72      19.246  14.340  19.348  1.00 27.15           N  
ATOM    884  CA  ALA    72      17.800  14.367  19.546  1.00 27.07           C  
ATOM    886  CB  ALA    72      17.127  13.525  18.488  1.00 26.68           C  
ATOM    890  C   ALA    72      17.315  13.950  20.941  1.00 27.13           C  
ATOM    891  O   ALA    72      16.182  14.226  21.301  1.00 26.86           O  
ATOM    893  N   THR    73      18.163  13.293  21.726  1.00 27.64           N  
ATOM    894  CA  THR    73      17.794  12.844  23.087  1.00 27.77           C  
ATOM    896  CB  THR    73      18.487  11.475  23.481  1.00 27.68           C  
ATOM    898  OG1 THR    73      19.896  11.661  23.586  1.00 28.68           O  
ATOM    900  CG2 THR    73      18.245  10.386  22.484  1.00 27.37           C  
ATOM    904  C   THR    73      18.077  13.870  24.222  1.00 27.70           C  
ATOM    905  O   THR    73      17.605  13.670  25.328  1.00 28.04           O  
ATOM    907  N   ARG    74      18.804  14.962  23.970  1.00 28.06           N  
ATOM    908  CA  ARG    74      19.126  15.931  25.042  1.00 28.19           C  
ATOM    910  CB  ARG    74      20.501  16.601  24.849  1.00 28.37           C  
ATOM    913  CG  ARG    74      21.630  15.661  25.334  1.00 29.65           C  
ATOM    916  CD  ARG    74      23.077  16.273  25.365  1.00 31.98           C  
ATOM    919  NE  ARG    74      23.948  15.483  24.442  1.00 33.67           N  
ATOM    921  CZ  ARG    74      25.287  15.545  24.348  1.00 32.37           C  
ATOM    922  NH1 ARG    74      26.000  16.370  25.135  1.00 33.11           N  
ATOM    925  NH2 ARG    74      25.913  14.770  23.451  1.00 30.11           N  
ATOM    928  C   ARG    74      18.008  16.914  25.334  1.00 27.96           C  
ATOM    929  O   ARG    74      18.098  18.113  25.095  1.00 27.54           O  
ATOM    931  N   HIS    75      16.947  16.332  25.881  1.00 28.13           N  
ATOM    932  CA  HIS    75      15.808  17.019  26.439  1.00 27.64           C  
ATOM    934  CB  HIS    75      14.667  16.007  26.623  1.00 27.64           C  
ATOM    937  CG  HIS    75      13.933  15.675  25.364  1.00 26.85           C  
ATOM    938  ND1 HIS    75      12.684  15.091  25.365  1.00 27.16           N  
ATOM    940  CE1 HIS    75      12.273  14.929  24.123  1.00 25.35           C  
ATOM    942  NE2 HIS    75      13.203  15.398  23.314  1.00 25.61           N  
ATOM    944  CD2 HIS    75      14.241  15.891  24.066  1.00 26.69           C  
ATOM    946  C   HIS    75      16.212  17.565  27.809  1.00 27.62           C  
ATOM    947  O   HIS    75      17.040  16.976  28.486  1.00 27.41           O  
ATOM    949  N   ALA    76      15.605  18.680  28.215  1.00 27.85           N  
ATOM    950  CA  ALA    76      15.914  19.361  29.477  1.00 27.68           C  
ATOM    952  CB  ALA    76      14.837  20.315  29.795  1.00 27.83           C  
ATOM    956  C   ALA    76      16.071  18.407  30.627  1.00 27.54           C  
ATOM    957  O   ALA    76      16.949  18.557  31.454  1.00 27.23           O  
ATOM    959  N   GLU    77      15.202  17.415  30.660  1.00 27.94           N  
ATOM    960  CA  GLU    77      15.174  16.423  31.759  1.00 28.19           C  
ATOM    962  CB  GLU    77      13.931  15.503  31.638  1.00 28.04           C  
ATOM    965  CG  GLU    77      12.535  16.240  31.554  1.00 28.70           C  
ATOM    968  CD  GLU    77      12.024  16.560  30.121  1.00 29.00           C  
ATOM    969  OE1 GLU    77      12.744  17.225  29.338  1.00 26.96           O  
ATOM    970  OE2 GLU    77      10.890  16.137  29.788  1.00 30.20           O  
ATOM    971  C   GLU    77      16.453  15.576  31.775  1.00 28.12           C  
ATOM    972  O   GLU    77      16.977  15.267  32.831  1.00 27.91           O  
ATOM    974  N   MET    78      16.945  15.218  30.590  1.00 28.34           N  
ATOM    975  CA  MET    78      18.162  14.405  30.454  1.00 28.57           C  
ATOM    977  CB  MET    78      18.256  13.796  29.033  1.00 28.60           C  
ATOM    980  CG  MET    78      17.083  12.903  28.658  1.00 29.43           C  
ATOM    983  SD  MET    78      17.088  11.230  29.438  1.00 32.79           S  
ATOM    984  CE  MET    78      18.680  10.560  28.910  1.00 33.89           C  
ATOM    988  C   MET    78      19.438  15.196  30.807  1.00 27.97           C  
ATOM    989  O   MET    78      20.374  14.636  31.382  1.00 27.32           O  
ATOM    991  N   VAL    79      19.449  16.485  30.467  1.00 27.87           N  
ATOM    992  CA  VAL    79      20.504  17.412  30.894  1.00 27.89           C  
ATOM    994  CB  VAL    79      20.252  18.842  30.335  1.00 27.64           C  
ATOM    996  CG1 VAL    79      21.200  19.821  30.957  1.00 26.57           C  
ATOM   1000  CG2 VAL    79      20.390  18.846  28.827  1.00 27.02           C  
ATOM   1004  C   VAL    79      20.582  17.472  32.428  1.00 28.20           C  
ATOM   1005  O   VAL    79      21.663  17.343  33.013  1.00 28.42           O  
ATOM   1007  N   ALA    80      19.422  17.663  33.060  1.00 28.46           N  
ATOM   1008  CA  ALA    80      19.292  17.726  34.514  1.00 28.47           C  
ATOM   1010  CB  ALA    80      17.846  18.000  34.891  1.00 28.80           C  
ATOM   1014  C   ALA    80      19.776  16.452  35.211  1.00 28.83           C  
ATOM   1015  O   ALA    80      20.513  16.536  36.211  1.00 28.83           O  
ATOM   1017  N   ILE    81      19.346  15.286  34.702  1.00 28.53           N  
ATOM   1018  CA  ILE    81      19.759  14.004  35.257  1.00 28.44           C  
ATOM   1020  CB  ILE    81      19.134  12.836  34.510  1.00 28.66           C  
ATOM   1022  CG1 ILE    81      17.624  12.783  34.805  1.00 28.89           C  
ATOM   1025  CD1 ILE    81      16.882  11.805  33.992  1.00 26.60           C  
ATOM   1029  CG2 ILE    81      19.789  11.514  34.943  1.00 28.72           C  
ATOM   1033  C   ILE    81      21.275  13.851  35.248  1.00 28.72           C  
ATOM   1034  O   ILE    81      21.854  13.413  36.239  1.00 29.25           O  
ATOM   1036  N   ASP    82      21.922  14.237  34.152  1.00 28.61           N  
ATOM   1037  CA  ASP    82      23.382  14.204  34.080  1.00 28.47           C  
ATOM   1039  CB  ASP    82      23.900  14.655  32.700  1.00 28.86           C  
ATOM   1042  CG  ASP    82      24.020  13.506  31.685  1.00 30.66           C  
ATOM   1043  OD1 ASP    82      23.613  12.367  32.024  1.00 33.60           O  
ATOM   1044  OD2 ASP    82      24.542  13.743  30.544  1.00 32.55           O  
ATOM   1045  C   ASP    82      23.987  15.088  35.148  1.00 28.01           C  
ATOM   1046  O   ASP    82      24.999  14.728  35.734  1.00 27.82           O  
ATOM   1048  N   GLN    83      23.379  16.253  35.385  1.00 27.76           N  
ATOM   1049  CA  GLN    83      23.868  17.178  36.416  1.00 27.64           C  
ATOM   1051  CB  GLN    83      23.170  18.538  36.279  1.00 27.69           C  
ATOM   1054  CG  GLN    83      23.871  19.468  35.291  1.00 28.50           C  
ATOM   1057  CD  GLN    83      23.481  20.925  35.456  1.00 27.64           C  
ATOM   1058  OE1 GLN    83      22.782  21.301  36.390  1.00 27.94           O  
ATOM   1059  NE2 GLN    83      23.942  21.750  34.551  1.00 27.26           N  
ATOM   1062  C   GLN    83      23.721  16.646  37.849  1.00 27.11           C  
ATOM   1063  O   GLN    83      24.612  16.790  38.666  1.00 26.25           O  
ATOM   1065  N   VAL    84      22.573  16.039  38.131  1.00 27.29           N  
ATOM   1066  CA  VAL    84      22.373  15.354  39.390  1.00 27.38           C  
ATOM   1068  CB  VAL    84      20.931  14.822  39.562  1.00 27.63           C  
ATOM   1070  CG1 VAL    84      20.775  14.175  40.919  1.00 25.95           C  
ATOM   1074  CG2 VAL    84      19.923  15.945  39.394  1.00 26.82           C  
ATOM   1078  C   VAL    84      23.395  14.241  39.566  1.00 27.17           C  
ATOM   1079  O   VAL    84      24.087  14.205  40.570  1.00 27.42           O  
ATOM   1081  N   LEU    85      23.541  13.356  38.595  1.00 27.06           N  
ATOM   1082  CA  LEU    85      24.643  12.379  38.680  1.00 27.18           C  
ATOM   1084  CB  LEU    85      24.735  11.528  37.415  1.00 26.93           C  
ATOM   1087  CG  LEU    85      23.618  10.515  37.247  1.00 26.49           C  
ATOM   1089  CD1 LEU    85      23.286  10.344  35.774  1.00 27.04           C  
ATOM   1093  CD2 LEU    85      24.014   9.242  37.875  1.00 26.00           C  
ATOM   1097  C   LEU    85      25.997  13.029  38.955  1.00 27.04           C  
ATOM   1098  O   LEU    85      26.807  12.451  39.661  1.00 27.51           O  
ATOM   1100  N   ASP    86      26.240  14.216  38.404  1.00 27.40           N  
ATOM   1101  CA  ASP    86      27.493  14.935  38.638  1.00 27.79           C  
ATOM   1103  CB  ASP    86      27.674  16.086  37.657  1.00 27.90           C  
ATOM   1106  CG  ASP    86      29.145  16.270  37.271  1.00 30.86           C  
ATOM   1107  OD1 ASP    86      29.648  15.494  36.390  1.00 32.41           O  
ATOM   1108  OD2 ASP    86      29.826  17.137  37.906  1.00 33.31           O  
ATOM   1109  C   ASP    86      27.612  15.473  40.060  1.00 27.69           C  
ATOM   1110  O   ASP    86      28.704  15.515  40.648  1.00 27.89           O  
ATOM   1112  N   TRP    87      26.479  15.887  40.606  1.00 27.68           N  
ATOM   1113  CA  TRP    87      26.393  16.362  41.971  1.00 27.52           C  
ATOM   1115  CB  TRP    87      24.996  16.944  42.217  1.00 28.11           C  
ATOM   1118  CG  TRP    87      24.854  17.634  43.516  1.00 27.84           C  
ATOM   1119  CD1 TRP    87      25.097  18.936  43.765  1.00 26.94           C  
ATOM   1121  NE1 TRP    87      24.843  19.218  45.082  1.00 27.80           N  
ATOM   1123  CE2 TRP    87      24.445  18.076  45.722  1.00 27.98           C  
ATOM   1124  CD2 TRP    87      24.432  17.048  44.756  1.00 28.61           C  
ATOM   1125  CE3 TRP    87      24.048  15.750  45.143  1.00 27.55           C  
ATOM   1127  CZ3 TRP    87      23.721  15.525  46.469  1.00 27.38           C  
ATOM   1129  CH2 TRP    87      23.747  16.579  47.415  1.00 27.96           C  
ATOM   1131  CZ2 TRP    87      24.101  17.857  47.060  1.00 27.24           C  
ATOM   1133  C   TRP    87      26.661  15.254  42.957  1.00 27.22           C  
ATOM   1134  O   TRP    87      27.279  15.469  43.985  1.00 26.82           O  
ATOM   1136  N   CYS    88      26.147  14.072  42.648  1.00 27.62           N  
ATOM   1137  CA  CYS    88      26.427  12.872  43.433  1.00 27.93           C  
ATOM   1139  CB  CYS    88      25.738  11.657  42.842  1.00 27.87           C  
ATOM   1142  SG  CYS    88      24.004  11.558  43.304  1.00 29.69           S  
ATOM   1144  C   CYS    88      27.893  12.579  43.502  1.00 27.85           C  
ATOM   1145  O   CYS    88      28.411  12.357  44.584  1.00 28.58           O  
ATOM   1147  N   ARG    89      28.569  12.568  42.360  1.00 27.85           N  
ATOM   1148  CA  ARG    89      30.000  12.313  42.366  1.00 28.33           C  
ATOM   1150  CB  ARG    89      30.613  12.676  41.043  1.00 28.62           C  
ATOM   1153  CG  ARG    89      30.413  11.652  39.984  1.00 29.96           C  
ATOM   1156  CD  ARG    89      30.720  12.311  38.629  1.00 31.97           C  
ATOM   1159  NE  ARG    89      30.164  11.544  37.504  1.00 33.93           N  
ATOM   1161  CZ  ARG    89      30.404  11.831  36.215  1.00 36.20           C  
ATOM   1162  NH1 ARG    89      31.159  12.902  35.886  1.00 37.64           N  
ATOM   1165  NH2 ARG    89      29.920  11.053  35.234  1.00 36.24           N  
ATOM   1168  C   ARG    89      30.730  13.111  43.408  1.00 28.11           C  
ATOM   1169  O   ARG    89      31.577  12.583  44.101  1.00 28.00           O  
ATOM   1171  N   GLN    90      30.383  14.386  43.506  1.00 28.42           N  
ATOM   1172  CA  GLN    90      31.132  15.339  44.301  1.00 28.75           C  
ATOM   1174  CB  GLN    90      30.990  16.703  43.661  1.00 29.03           C  
ATOM   1177  CG  GLN    90      31.457  16.706  42.217  1.00 31.17           C  
ATOM   1180  CD  GLN    90      31.094  17.981  41.521  1.00 33.04           C  
ATOM   1181  OE1 GLN    90      30.440  18.845  42.108  1.00 35.04           O  
ATOM   1182  NE2 GLN    90      31.498  18.113  40.261  1.00 34.45           N  
ATOM   1185  C   GLN    90      30.670  15.469  45.728  1.00 28.39           C  
ATOM   1186  O   GLN    90      31.383  16.039  46.538  1.00 28.51           O  
ATOM   1188  N   SER    91      29.453  15.014  46.010  1.00 28.22           N  
ATOM   1189  CA  SER    91      28.885  15.090  47.346  1.00 28.33           C  
ATOM   1191  CB  SER    91      27.379  15.315  47.267  1.00 28.48           C  
ATOM   1194  OG  SER    91      26.708  14.066  47.137  1.00 28.44           O  
ATOM   1196  C   SER    91      29.135  13.806  48.131  1.00 28.41           C  
ATOM   1197  O   SER    91      28.941  13.790  49.351  1.00 28.52           O  
ATOM   1199  N   GLY    92      29.541  12.740  47.419  1.00 28.34           N  
ATOM   1200  CA  GLY    92      29.820  11.437  48.010  1.00 28.07           C  
ATOM   1203  C   GLY    92      28.567  10.609  48.180  1.00 27.97           C  
ATOM   1204  O   GLY    92      28.632   9.480  48.609  1.00 28.33           O  
ATOM   1206  N   LYS    93      27.418  11.175  47.850  1.00 28.04           N  
ATOM   1207  CA  LYS    93      26.144  10.499  48.043  1.00 28.52           C  
ATOM   1209  CB  LYS    93      25.010  11.516  48.151  1.00 28.44           C  
ATOM   1212  CG  LYS    93      25.124  12.507  49.287  1.00 28.85           C  
ATOM   1215  CD  LYS    93      24.408  12.008  50.555  1.00 30.68           C  
ATOM   1218  CE  LYS    93      23.929  13.147  51.497  1.00 31.10           C  
ATOM   1221  NZ  LYS    93      22.573  12.817  52.143  1.00 31.15           N  
ATOM   1225  C   LYS    93      25.886   9.579  46.841  1.00 28.54           C  
ATOM   1226  O   LYS    93      26.366   9.859  45.736  1.00 28.29           O  
ATOM   1228  N   SER    94      25.122   8.501  47.058  1.00 28.28           N  
ATOM   1229  CA  SER    94      24.802   7.568  45.984  1.00 27.99           C  
ATOM   1231  CB  SER    94      24.546   6.167  46.522  1.00 27.89           C  
ATOM   1234  OG  SER    94      23.271   6.106  47.132  1.00 27.86           O  
ATOM   1236  C   SER    94      23.571   8.064  45.224  1.00 28.07           C  
ATOM   1237  O   SER    94      22.649   8.643  45.843  1.00 27.86           O  
ATOM   1239  N   PRO    95      23.548   7.840  43.893  1.00 27.49           N  
ATOM   1240  CA  PRO    95      22.436   8.176  42.998  1.00 27.79           C  
ATOM   1242  CB  PRO    95      22.818   7.481  41.703  1.00 27.72           C  
ATOM   1245  CG  PRO    95      24.264   7.455  41.751  1.00 28.05           C  
ATOM   1248  CD  PRO    95      24.646   7.219  43.154  1.00 27.05           C  
ATOM   1251  C   PRO    95      21.045   7.709  43.436  1.00 27.91           C  
ATOM   1252  O   PRO    95      20.106   8.499  43.371  1.00 28.45           O  
ATOM   1253  N   SER    96      20.917   6.457  43.869  1.00 27.75           N  
ATOM   1254  CA  SER    96      19.643   5.929  44.340  1.00 28.16           C  
ATOM   1256  CB  SER    96      19.727   4.416  44.567  1.00 28.01           C  
ATOM   1259  OG  SER    96      20.401   4.120  45.777  1.00 28.00           O  
ATOM   1261  C   SER    96      19.140   6.659  45.599  1.00 28.30           C  
ATOM   1262  O   SER    96      17.977   6.987  45.701  1.00 28.80           O  
ATOM   1264  N   GLU    97      20.029   6.959  46.524  1.00 28.77           N  
ATOM   1265  CA  GLU    97      19.701   7.734  47.728  1.00 29.19           C  
ATOM   1267  CB  GLU    97      20.960   7.760  48.608  1.00 29.43           C  
ATOM   1270  CG  GLU    97      20.840   8.453  49.966  1.00 31.88           C  
ATOM   1273  CD  GLU    97      22.211   8.495  50.747  1.00 34.19           C  
ATOM   1274  OE1 GLU    97      23.234   7.944  50.211  1.00 34.81           O  
ATOM   1275  OE2 GLU    97      22.250   9.095  51.874  1.00 32.68           O  
ATOM   1276  C   GLU    97      19.225   9.185  47.447  1.00 29.09           C  
ATOM   1277  O   GLU    97      18.528   9.788  48.293  1.00 29.59           O  
ATOM   1279  N   VAL    98      19.614   9.742  46.295  1.00 28.27           N  
ATOM   1280  CA  VAL    98      19.289  11.121  45.961  1.00 28.28           C  
ATOM   1282  CB  VAL    98      20.460  11.853  45.218  1.00 28.27           C  
ATOM   1284  CG1 VAL    98      20.109  13.282  44.899  1.00 25.94           C  
ATOM   1288  CG2 VAL    98      21.732  11.836  46.046  1.00 28.61           C  
ATOM   1292  C   VAL    98      18.069  11.175  45.066  1.00 28.91           C  
ATOM   1293  O   VAL    98      17.096  11.881  45.374  1.00 28.91           O  
ATOM   1295  N   PHE    99      18.133  10.470  43.930  1.00 29.30           N  
ATOM   1296  CA  PHE    99      17.022  10.466  42.968  1.00 29.02           C  
ATOM   1298  CB  PHE    99      17.314   9.595  41.740  1.00 29.08           C  
ATOM   1301  CG  PHE    99      18.191  10.271  40.744  1.00 30.28           C  
ATOM   1302  CD1 PHE    99      19.564  10.018  40.707  1.00 30.48           C  
ATOM   1304  CE1 PHE    99      20.391  10.672  39.812  1.00 29.96           C  
ATOM   1306  CZ  PHE    99      19.873  11.616  38.953  1.00 30.17           C  
ATOM   1308  CE2 PHE    99      18.508  11.904  38.982  1.00 31.27           C  
ATOM   1310  CD2 PHE    99      17.666  11.222  39.877  1.00 31.63           C  
ATOM   1312  C   PHE    99      15.737  10.011  43.618  1.00 28.89           C  
ATOM   1313  O   PHE    99      14.682  10.551  43.305  1.00 29.69           O  
ATOM   1315  N   GLU   100      15.802   9.025  44.514  1.00 28.16           N  
ATOM   1316  CA  GLU   100      14.578   8.558  45.168  1.00 27.97           C  
ATOM   1318  CB  GLU   100      14.825   7.247  45.899  1.00 27.44           C  
ATOM   1321  CG  GLU   100      15.086   6.145  44.939  1.00 28.81           C  
ATOM   1324  CD  GLU   100      15.433   4.827  45.602  1.00 31.25           C  
ATOM   1325  OE1 GLU   100      14.999   4.604  46.757  1.00 33.41           O  
ATOM   1326  OE2 GLU   100      16.147   4.005  44.961  1.00 32.63           O  
ATOM   1327  C   GLU   100      13.901   9.589  46.090  1.00 27.67           C  
ATOM   1328  O   GLU   100      12.803   9.337  46.580  1.00 27.67           O  
ATOM   1330  N   HIS   101      14.549  10.734  46.319  1.00 27.43           N  
ATOM   1331  CA  HIS   101      13.984  11.809  47.136  1.00 27.25           C  
ATOM   1333  CB  HIS   101      14.693  11.846  48.490  1.00 27.64           C  
ATOM   1336  CG  HIS   101      14.600  10.559  49.241  1.00 28.63           C  
ATOM   1337  ND1 HIS   101      15.589   9.592  49.190  1.00 29.98           N  
ATOM   1339  CE1 HIS   101      15.213   8.550  49.910  1.00 29.66           C  
ATOM   1341  NE2 HIS   101      14.023   8.807  50.425  1.00 29.55           N  
ATOM   1343  CD2 HIS   101      13.611  10.050  50.010  1.00 28.37           C  
ATOM   1345  C   HIS   101      14.093  13.162  46.463  1.00 26.91           C  
ATOM   1346  O   HIS   101      14.090  14.165  47.121  1.00 26.37           O  
ATOM   1348  N   THR   102      14.172  13.155  45.136  1.00 27.88           N  
ATOM   1349  CA  THR   102      14.323  14.343  44.296  1.00 28.28           C  
ATOM   1351  CB  THR   102      15.376  14.090  43.179  1.00 28.77           C  
ATOM   1353  OG1 THR   102      16.620  13.677  43.769  1.00 29.37           O  
ATOM   1355  CG2 THR   102      15.602  15.338  42.319  1.00 28.67           C  
ATOM   1359  C   THR   102      12.981  14.701  43.643  1.00 28.52           C  
ATOM   1360  O   THR   102      12.303  13.824  43.089  1.00 29.15           O  
ATOM   1362  N   VAL   103      12.571  15.975  43.723  1.00 28.29           N  
ATOM   1363  CA  VAL   103      11.375  16.424  43.007  1.00 27.89           C  
ATOM   1365  CB  VAL   103      10.499  17.411  43.792  1.00 27.37           C  
ATOM   1367  CG1 VAL   103       9.458  17.967  42.885  1.00 27.07           C  
ATOM   1371  CG2 VAL   103       9.842  16.749  44.935  1.00 26.32           C  
ATOM   1375  C   VAL   103      11.855  17.124  41.762  1.00 28.32           C  
ATOM   1376  O   VAL   103      12.766  17.953  41.840  1.00 27.99           O  
ATOM   1378  N   LEU   104      11.241  16.769  40.627  1.00 28.66           N  
ATOM   1379  CA  LEU   104      11.499  17.407  39.326  1.00 28.73           C  
ATOM   1381  CB  LEU   104      11.432  16.357  38.204  1.00 28.51           C  
ATOM   1384  CG  LEU   104      11.478  16.890  36.764  1.00 29.73           C  
ATOM   1386  CD1 LEU   104      12.826  17.591  36.418  1.00 30.68           C  
ATOM   1390  CD2 LEU   104      11.197  15.768  35.748  1.00 29.46           C  
ATOM   1394  C   LEU   104      10.469  18.508  39.084  1.00 28.35           C  
ATOM   1395  O   LEU   104       9.279  18.299  39.308  1.00 28.58           O  
ATOM   1397  N   TYR   105      10.935  19.672  38.635  1.00 28.26           N  
ATOM   1398  CA  TYR   105      10.055  20.816  38.292  1.00 28.44           C  
ATOM   1400  CB  TYR   105      10.335  22.040  39.206  1.00 28.13           C  
ATOM   1403  CG  TYR   105      10.205  21.756  40.702  1.00 27.64           C  
ATOM   1404  CD1 TYR   105      11.284  21.202  41.410  1.00 28.21           C  
ATOM   1406  CE1 TYR   105      11.188  20.907  42.749  1.00 27.85           C  
ATOM   1408  CZ  TYR   105      10.000  21.179  43.415  1.00 28.16           C  
ATOM   1409  OH  TYR   105       9.935  20.866  44.768  1.00 26.64           O  
ATOM   1411  CE2 TYR   105       8.925  21.757  42.726  1.00 25.52           C  
ATOM   1413  CD2 TYR   105       9.032  22.035  41.395  1.00 24.48           C  
ATOM   1415  C   TYR   105      10.264  21.171  36.797  1.00 28.60           C  
ATOM   1416  O   TYR   105      11.342  21.633  36.439  1.00 28.75           O  
ATOM   1418  N   VAL   106       9.255  20.945  35.942  1.00 28.20           N  
ATOM   1419  CA  VAL   106       9.399  21.109  34.476  1.00 28.13           C  
ATOM   1421  CB  VAL   106       9.437  19.736  33.731  1.00 27.97           C  
ATOM   1423  CG1 VAL   106      10.590  18.978  34.171  1.00 29.41           C  
ATOM   1427  CG2 VAL   106       8.201  18.935  34.004  1.00 26.97           C  
ATOM   1431  C   VAL   106       8.304  21.933  33.793  1.00 27.78           C  
ATOM   1432  O   VAL   106       7.135  21.879  34.152  1.00 27.98           O  
ATOM   1434  N   THR   107       8.698  22.640  32.750  1.00 27.47           N  
ATOM   1435  CA  THR   107       7.797  23.502  31.995  1.00 27.60           C  
ATOM   1437  CB  THR   107       8.624  24.430  31.114  1.00 27.08           C  
ATOM   1439  OG1 THR   107       9.242  25.406  31.949  1.00 26.99           O  
ATOM   1441  CG2 THR   107       7.752  25.104  30.113  1.00 28.88           C  
ATOM   1445  C   THR   107       6.738  22.762  31.142  1.00 27.29           C  
ATOM   1446  O   THR   107       5.602  23.217  31.046  1.00 27.48           O  
ATOM   1448  N   VAL   108       7.124  21.648  30.524  1.00 26.89           N  
ATOM   1449  CA  VAL   108       6.228  20.847  29.718  1.00 26.46           C  
ATOM   1451  CB  VAL   108       6.701  20.787  28.284  1.00 26.45           C  
ATOM   1453  CG1 VAL   108       5.756  19.953  27.480  1.00 25.92           C  
ATOM   1457  CG2 VAL   108       6.837  22.205  27.700  1.00 26.36           C  
ATOM   1461  C   VAL   108       6.186  19.431  30.231  1.00 26.51           C  
ATOM   1462  O   VAL   108       7.157  18.899  30.725  1.00 26.61           O  
ATOM   1464  N   GLU   109       5.033  18.814  30.117  1.00 27.18           N  
ATOM   1465  CA  GLU   109       4.876  17.390  30.411  1.00 27.29           C  
ATOM   1467  CB  GLU   109       3.488  16.904  29.932  1.00 27.24           C  
ATOM   1470  CG  GLU   109       3.138  15.447  30.308  1.00 28.49           C  
ATOM   1473  CD  GLU   109       1.889  14.937  29.589  1.00 29.27           C  
ATOM   1474  OE1 GLU   109       1.109  15.760  29.061  1.00 29.40           O  
ATOM   1475  OE2 GLU   109       1.691  13.706  29.528  1.00 30.07           O  
ATOM   1476  C   GLU   109       6.009  16.560  29.782  1.00 26.50           C  
ATOM   1477  O   GLU   109       6.244  16.634  28.607  1.00 25.85           O  
ATOM   1479  N   PRO   110       6.734  15.790  30.590  1.00 27.08           N  
ATOM   1480  CA  PRO   110       7.729  14.855  30.045  1.00 27.45           C  
ATOM   1482  CB  PRO   110       8.119  14.018  31.256  1.00 27.41           C  
ATOM   1485  CG  PRO   110       7.870  14.919  32.414  1.00 27.40           C  
ATOM   1488  CD  PRO   110       6.709  15.769  32.066  1.00 27.08           C  
ATOM   1491  C   PRO   110       7.213  13.943  28.942  1.00 27.32           C  
ATOM   1492  O   PRO   110       6.112  13.439  29.046  1.00 26.89           O  
ATOM   1493  N   CYS   111       8.019  13.764  27.895  1.00 27.48           N  
ATOM   1494  CA  CYS   111       7.673  12.895  26.779  1.00 27.20           C  
ATOM   1496  CB  CYS   111       8.596  13.159  25.591  1.00 27.18           C  
ATOM   1499  SG  CYS   111      10.319  12.549  25.762  1.00 26.81           S  
ATOM   1501  C   CYS   111       7.773  11.433  27.179  1.00 27.55           C  
ATOM   1502  O   CYS   111       8.200  11.098  28.282  1.00 27.24           O  
ATOM   1504  N   ILE   112       7.393  10.555  26.260  1.00 27.67           N  
ATOM   1505  CA  ILE   112       7.456   9.134  26.532  1.00 27.66           C  
ATOM   1507  CB  ILE   112       6.865   8.310  25.370  1.00 27.71           C  
ATOM   1509  CG1 ILE   112       5.338   8.440  25.369  1.00 28.05           C  
ATOM   1512  CD1 ILE   112       4.648   7.765  24.177  1.00 28.17           C  
ATOM   1516  CG2 ILE   112       7.261   6.828  25.471  1.00 27.28           C  
ATOM   1520  C   ILE   112       8.872   8.692  26.886  1.00 27.75           C  
ATOM   1521  O   ILE   112       9.050   7.898  27.810  1.00 27.52           O  
ATOM   1523  N   MET   113       9.878   9.206  26.168  1.00 28.00           N  
ATOM   1524  CA  MET   113      11.286   8.865  26.477  1.00 27.71           C  
ATOM   1526  CB  MET   113      12.224   9.558  25.518  1.00 27.36           C  
ATOM   1529  CG  MET   113      13.630   9.038  25.611  1.00 27.66           C  
ATOM   1532  SD  MET   113      14.781  10.217  24.914  1.00 29.59           S  
ATOM   1533  CE  MET   113      15.865  10.464  26.347  1.00 31.93           C  
ATOM   1537  C   MET   113      11.695   9.263  27.906  1.00 27.74           C  
ATOM   1538  O   MET   113      12.210   8.430  28.653  1.00 27.33           O  
ATOM   1540  N   CYS   114      11.461  10.527  28.255  1.00 27.33           N  
ATOM   1541  CA  CYS   114      11.773  11.050  29.574  1.00 27.96           C  
ATOM   1543  CB  CYS   114      11.535  12.562  29.593  1.00 28.16           C  
ATOM   1546  SG  CYS   114      12.745  13.454  28.634  1.00 29.88           S  
ATOM   1548  C   CYS   114      10.984  10.409  30.733  1.00 27.83           C  
ATOM   1549  O   CYS   114      11.560  10.008  31.741  1.00 27.85           O  
ATOM   1551  N   ALA   115       9.675  10.312  30.597  1.00 27.62           N  
ATOM   1552  CA  ALA   115       8.891   9.588  31.569  1.00 27.76           C  
ATOM   1554  CB  ALA   115       7.432   9.558  31.146  1.00 27.42           C  
ATOM   1558  C   ALA   115       9.442   8.163  31.819  1.00 28.27           C  
ATOM   1559  O   ALA   115       9.599   7.752  32.985  1.00 29.59           O  
ATOM   1561  N   ALA   116       9.771   7.412  30.769  1.00 28.12           N  
ATOM   1562  CA  ALA   116      10.385   6.078  30.963  1.00 28.33           C  
ATOM   1564  CB  ALA   116      10.653   5.371  29.619  1.00 27.77           C  
ATOM   1568  C   ALA   116      11.675   6.194  31.785  1.00 28.62           C  
ATOM   1569  O   ALA   116      11.941   5.377  32.671  1.00 29.32           O  
ATOM   1571  N   ALA   117      12.463   7.229  31.508  1.00 28.78           N  
ATOM   1572  CA  ALA   117      13.700   7.484  32.246  1.00 28.73           C  
ATOM   1574  CB  ALA   117      14.421   8.676  31.653  1.00 28.83           C  
ATOM   1578  C   ALA   117      13.441   7.743  33.724  1.00 28.85           C  
ATOM   1579  O   ALA   117      14.094   7.176  34.577  1.00 28.67           O  
ATOM   1581  N   LEU   118      12.477   8.620  34.005  1.00 29.20           N  
ATOM   1582  CA  LEU   118      12.155   9.023  35.360  1.00 28.43           C  
ATOM   1584  CB  LEU   118      11.127  10.154  35.347  1.00 27.97           C  
ATOM   1587  CG  LEU   118      11.692  11.452  34.772  1.00 27.63           C  
ATOM   1589  CD1 LEU   118      10.735  12.603  34.919  1.00 28.37           C  
ATOM   1593  CD2 LEU   118      12.963  11.797  35.439  1.00 28.09           C  
ATOM   1597  C   LEU   118      11.669   7.840  36.159  1.00 28.28           C  
ATOM   1598  O   LEU   118      12.014   7.730  37.331  1.00 28.30           O  
ATOM   1600  N   ARG   119      10.895   6.949  35.534  1.00 28.26           N  
ATOM   1601  CA  ARG   119      10.579   5.659  36.179  1.00 28.76           C  
ATOM   1603  CB  ARG   119       9.775   4.752  35.252  1.00 29.30           C  
ATOM   1606  CG  ARG   119       8.261   4.867  35.387  1.00 29.05           C  
ATOM   1609  CD  ARG   119       7.630   3.767  34.611  1.00 29.20           C  
ATOM   1612  NE  ARG   119       7.435   2.550  35.388  1.00 29.29           N  
ATOM   1614  CZ  ARG   119       6.316   2.241  36.052  1.00 30.71           C  
ATOM   1615  NH1 ARG   119       5.280   3.079  36.090  1.00 31.34           N  
ATOM   1618  NH2 ARG   119       6.229   1.086  36.713  1.00 31.28           N  
ATOM   1621  C   ARG   119      11.826   4.865  36.565  1.00 28.71           C  
ATOM   1622  O   ARG   119      11.942   4.355  37.683  1.00 28.42           O  
ATOM   1624  N   LEU   120      12.738   4.738  35.608  1.00 28.29           N  
ATOM   1625  CA  LEU   120      13.955   3.987  35.836  1.00 28.40           C  
ATOM   1627  CB  LEU   120      14.671   3.762  34.510  1.00 27.90           C  
ATOM   1630  CG  LEU   120      13.979   2.793  33.547  1.00 26.59           C  
ATOM   1632  CD1 LEU   120      14.630   2.885  32.201  1.00 25.10           C  
ATOM   1636  CD2 LEU   120      13.984   1.375  34.042  1.00 24.24           C  
ATOM   1640  C   LEU   120      14.896   4.605  36.898  1.00 28.81           C  
ATOM   1641  O   LEU   120      15.541   3.860  37.658  1.00 29.54           O  
ATOM   1643  N   MET   121      14.978   5.941  36.943  1.00 28.87           N  
ATOM   1644  CA  MET   121      15.712   6.673  37.985  1.00 28.40           C  
ATOM   1646  CB  MET   121      15.922   8.132  37.588  1.00 28.32           C  
ATOM   1649  CG  MET   121      16.793   8.350  36.362  1.00 29.39           C  
ATOM   1652  SD  MET   121      18.368   7.437  36.341  1.00 31.52           S  
ATOM   1653  CE  MET   121      19.455   8.674  37.112  1.00 32.17           C  
ATOM   1657  C   MET   121      14.968   6.697  39.316  1.00 28.60           C  
ATOM   1658  O   MET   121      15.578   6.990  40.327  1.00 28.98           O  
ATOM   1660  N   LYS   122      13.654   6.446  39.301  1.00 28.57           N  
ATOM   1661  CA  LYS   122      12.791   6.393  40.496  1.00 27.97           C  
ATOM   1663  CB  LYS   122      13.311   5.396  41.523  1.00 27.70           C  
ATOM   1666  CG  LYS   122      13.463   4.024  41.001  1.00 27.70           C  
ATOM   1669  CD  LYS   122      13.797   3.117  42.133  1.00 28.38           C  
ATOM   1672  CE  LYS   122      13.990   1.713  41.622  1.00 28.97           C  
ATOM   1675  NZ  LYS   122      14.226   0.736  42.706  1.00 29.76           N  
ATOM   1679  C   LYS   122      12.590   7.725  41.178  1.00 28.20           C  
ATOM   1680  O   LYS   122      12.469   7.773  42.412  1.00 28.06           O  
ATOM   1682  N   ILE   123      12.586   8.805  40.394  1.00 27.95           N  
ATOM   1683  CA  ILE   123      12.130  10.084  40.892  1.00 27.99           C  
ATOM   1685  CB  ILE   123      12.231  11.205  39.833  1.00 28.47           C  
ATOM   1687  CG1 ILE   123      13.668  11.737  39.725  1.00 30.17           C  
ATOM   1690  CD1 ILE   123      14.537  11.101  38.597  1.00 31.52           C  
ATOM   1694  CG2 ILE   123      11.368  12.380  40.218  1.00 27.61           C  
ATOM   1698  C   ILE   123      10.659   9.867  41.267  1.00 27.89           C  
ATOM   1699  O   ILE   123       9.901   9.331  40.452  1.00 27.80           O  
ATOM   1701  N   PRO   124      10.268  10.206  42.521  1.00 27.53           N  
ATOM   1702  CA  PRO   124       8.908  10.069  43.039  1.00 27.20           C  
ATOM   1704  CB  PRO   124       9.133  10.061  44.535  1.00 27.06           C  
ATOM   1707  CG  PRO   124      10.268  10.856  44.751  1.00 27.33           C  
ATOM   1710  CD  PRO   124      11.177  10.670  43.583  1.00 27.38           C  
ATOM   1713  C   PRO   124       7.871  11.158  42.702  1.00 27.45           C  
ATOM   1714  O   PRO   124       6.685  10.838  42.712  1.00 27.46           O  
ATOM   1715  N   LEU   125       8.290  12.403  42.420  1.00 27.23           N  
ATOM   1716  CA  LEU   125       7.342  13.475  42.135  1.00 27.35           C  
ATOM   1718  CB  LEU   125       7.072  14.273  43.410  1.00 27.50           C  
ATOM   1721  CG  LEU   125       6.170  15.505  43.456  1.00 26.55           C  
ATOM   1723  CD1 LEU   125       4.804  15.257  42.848  1.00 27.47           C  
ATOM   1727  CD2 LEU   125       6.038  15.903  44.891  1.00 25.10           C  
ATOM   1731  C   LEU   125       7.805  14.419  41.029  1.00 28.05           C  
ATOM   1732  O   LEU   125       8.891  14.992  41.124  1.00 28.35           O  
ATOM   1734  N   VAL   126       6.962  14.578  39.993  1.00 28.17           N  
ATOM   1735  CA  VAL   126       7.152  15.557  38.936  1.00 27.98           C  
ATOM   1737  CB  VAL   126       7.033  14.889  37.547  1.00 28.31           C  
ATOM   1739  CG1 VAL   126       7.189  15.937  36.449  1.00 28.62           C  
ATOM   1743  CG2 VAL   126       8.075  13.764  37.376  1.00 28.63           C  
ATOM   1747  C   VAL   126       6.066  16.632  39.064  1.00 27.89           C  
ATOM   1748  O   VAL   126       4.885  16.314  39.154  1.00 27.83           O  
ATOM   1750  N   VAL   127       6.461  17.897  39.084  1.00 27.59           N  
ATOM   1751  CA  VAL   127       5.498  18.987  39.043  1.00 27.75           C  
ATOM   1753  CB  VAL   127       5.719  20.057  40.161  1.00 28.05           C  
ATOM   1755  CG1 VAL   127       5.015  21.381  39.854  1.00 27.26           C  
ATOM   1759  CG2 VAL   127       5.246  19.535  41.514  1.00 28.36           C  
ATOM   1763  C   VAL   127       5.737  19.598  37.704  1.00 27.95           C  
ATOM   1764  O   VAL   127       6.864  19.972  37.389  1.00 27.12           O  
ATOM   1766  N   TYR   128       4.680  19.692  36.900  1.00 28.52           N  
ATOM   1767  CA  TYR   128       4.822  20.268  35.566  1.00 28.45           C  
ATOM   1769  CB  TYR   128       5.025  19.162  34.533  1.00 28.06           C  
ATOM   1772  CG  TYR   128       3.818  18.402  34.078  1.00 28.34           C  
ATOM   1773  CD1 TYR   128       3.626  17.059  34.437  1.00 29.46           C  
ATOM   1775  CE1 TYR   128       2.514  16.329  33.958  1.00 28.31           C  
ATOM   1777  CZ  TYR   128       1.612  16.958  33.113  1.00 29.12           C  
ATOM   1778  OH  TYR   128       0.500  16.310  32.604  1.00 28.84           O  
ATOM   1780  CE2 TYR   128       1.816  18.275  32.740  1.00 29.55           C  
ATOM   1782  CD2 TYR   128       2.914  18.975  33.204  1.00 28.51           C  
ATOM   1784  C   TYR   128       3.757  21.297  35.151  1.00 28.39           C  
ATOM   1785  O   TYR   128       2.754  21.529  35.860  1.00 28.91           O  
ATOM   1787  N   GLY   129       4.029  21.932  34.015  1.00 27.67           N  
ATOM   1788  CA  GLY   129       3.199  22.991  33.493  1.00 27.87           C  
ATOM   1791  C   GLY   129       2.120  22.551  32.535  1.00 27.68           C  
ATOM   1792  O   GLY   129       1.142  21.973  32.960  1.00 28.21           O  
ATOM   1794  N   CYS   130       2.275  22.855  31.252  1.00 27.34           N  
ATOM   1795  CA  CYS   130       1.279  22.499  30.266  1.00 27.89           C  
ATOM   1797  CB  CYS   130       1.342  23.480  29.107  1.00 27.89           C  
ATOM   1800  SG  CYS   130       2.914  23.319  28.162  1.00 30.29           S  
ATOM   1802  C   CYS   130       1.470  21.072  29.724  1.00 27.56           C  
ATOM   1803  O   CYS   130       2.489  20.438  29.937  1.00 26.76           O  
ATOM   1805  N   GLN   131       0.471  20.610  28.984  1.00 27.70           N  
ATOM   1806  CA  GLN   131       0.459  19.278  28.412  1.00 27.98           C  
ATOM   1808  CB  GLN   131      -0.950  18.922  27.932  1.00 28.47           C  
ATOM   1811  CG  GLN   131      -2.080  18.913  29.037  1.00 29.70           C  
ATOM   1814  CD  GLN   131      -1.959  17.735  30.027  1.00 31.77           C  
ATOM   1815  OE1 GLN   131      -1.739  16.574  29.619  1.00 33.82           O  
ATOM   1816  NE2 GLN   131      -2.093  18.027  31.327  1.00 31.60           N  
ATOM   1819  C   GLN   131       1.429  19.146  27.243  1.00 27.96           C  
ATOM   1820  O   GLN   131       1.803  20.137  26.635  1.00 27.61           O  
ATOM   1822  N   ASN   132       1.838  17.908  26.957  1.00 27.61           N  
ATOM   1823  CA  ASN   132       2.626  17.589  25.790  1.00 27.44           C  
ATOM   1825  CB  ASN   132       3.852  16.823  26.237  1.00 27.50           C  
ATOM   1828  CG  ASN   132       4.790  16.477  25.105  1.00 27.17           C  
ATOM   1829  OD1 ASN   132       4.451  16.645  23.947  1.00 28.04           O  
ATOM   1830  ND2 ASN   132       5.969  15.974  25.440  1.00 26.21           N  
ATOM   1833  C   ASN   132       1.780  16.782  24.793  1.00 27.56           C  
ATOM   1834  O   ASN   132       1.796  15.567  24.792  1.00 27.93           O  
ATOM   1836  N   GLU   133       1.042  17.475  23.940  1.00 27.82           N  
ATOM   1837  CA  GLU   133       0.081  16.823  23.046  1.00 28.46           C  
ATOM   1839  CB  GLU   133      -0.771  17.863  22.301  1.00 28.66           C  
ATOM   1842  CG  GLU   133      -2.060  18.259  23.041  1.00 30.06           C  
ATOM   1845  CD  GLU   133      -2.933  19.217  22.235  1.00 31.68           C  
ATOM   1846  OE1 GLU   133      -3.256  18.917  21.055  1.00 31.78           O  
ATOM   1847  OE2 GLU   133      -3.298  20.278  22.791  1.00 33.58           O  
ATOM   1848  C   GLU   133       0.692  15.860  22.029  1.00 28.35           C  
ATOM   1849  O   GLU   133       0.094  14.830  21.710  1.00 28.39           O  
ATOM   1851  N   ARG   134       1.869  16.202  21.523  1.00 28.25           N  
ATOM   1852  CA  ARG   134       2.561  15.377  20.550  1.00 28.21           C  
ATOM   1854  CB  ARG   134       3.683  16.166  19.899  1.00 28.39           C  
ATOM   1857  CG  ARG   134       3.264  17.431  19.221  1.00 28.78           C  
ATOM   1860  CD  ARG   134       4.465  18.125  18.644  1.00 29.15           C  
ATOM   1863  NE  ARG   134       4.091  19.255  17.801  1.00 29.84           N  
ATOM   1865  CZ  ARG   134       4.910  19.864  16.935  1.00 31.27           C  
ATOM   1866  NH1 ARG   134       6.177  19.461  16.778  1.00 31.15           N  
ATOM   1869  NH2 ARG   134       4.464  20.902  16.221  1.00 32.11           N  
ATOM   1872  C   ARG   134       3.178  14.108  21.162  1.00 28.31           C  
ATOM   1873  O   ARG   134       3.053  13.042  20.586  1.00 28.43           O  
ATOM   1875  N   PHE   135       3.865  14.216  22.302  1.00 28.31           N  
ATOM   1876  CA  PHE   135       4.589  13.063  22.841  1.00 28.53           C  
ATOM   1878  CB  PHE   135       6.034  13.163  22.343  1.00 28.53           C  
ATOM   1881  CG  PHE   135       6.732  11.841  22.165  1.00 28.29           C  
ATOM   1882  CD1 PHE   135       6.029  10.670  21.855  1.00 28.13           C  
ATOM   1884  CE1 PHE   135       6.692   9.435  21.694  1.00 28.35           C  
ATOM   1886  CZ  PHE   135       8.063   9.366  21.827  1.00 28.92           C  
ATOM   1888  CE2 PHE   135       8.788  10.545  22.126  1.00 30.44           C  
ATOM   1890  CD2 PHE   135       8.112  11.776  22.288  1.00 28.94           C  
ATOM   1892  C   PHE   135       4.521  12.863  24.376  1.00 28.82           C  
ATOM   1893  O   PHE   135       5.346  12.140  24.953  1.00 29.17           O  
ATOM   1895  N   GLY   136       3.510  13.446  25.019  1.00 28.58           N  
ATOM   1896  CA  GLY   136       3.332  13.292  26.455  1.00 29.12           C  
ATOM   1899  C   GLY   136       3.279  11.832  26.957  1.00 29.71           C  
ATOM   1900  O   GLY   136       2.548  10.985  26.410  1.00 29.56           O  
ATOM   1902  N   GLY   137       4.055  11.555  28.013  1.00 29.77           N  
ATOM   1903  CA  GLY   137       4.027  10.275  28.740  1.00 29.90           C  
ATOM   1906  C   GLY   137       3.441  10.285  30.168  1.00 29.93           C  
ATOM   1907  O   GLY   137       3.670   9.350  30.965  1.00 30.73           O  
ATOM   1909  N   CYS   138       2.667  11.308  30.498  1.00 29.42           N  
ATOM   1910  CA  CYS   138       2.001  11.353  31.793  1.00 29.62           C  
ATOM   1912  CB  CYS   138       2.460  12.576  32.587  1.00 29.79           C  
ATOM   1915  SG  CYS   138       4.218  12.576  32.898  1.00 30.23           S  
ATOM   1917  C   CYS   138       0.490  11.355  31.686  1.00 29.17           C  
ATOM   1918  O   CYS   138      -0.197  11.656  32.652  1.00 28.48           O  
ATOM   1920  N   GLY   139      -0.019  11.016  30.511  1.00 29.34           N  
ATOM   1921  CA  GLY   139      -1.452  11.056  30.270  1.00 29.45           C  
ATOM   1924  C   GLY   139      -1.880  11.464  28.872  1.00 29.50           C  
ATOM   1925  O   GLY   139      -2.898  10.977  28.401  1.00 30.03           O  
ATOM   1927  N   SER   140      -1.121  12.330  28.190  1.00 29.38           N  
ATOM   1928  CA  SER   140      -1.573  12.879  26.892  1.00 28.69           C  
ATOM   1930  CB  SER   140      -0.698  14.057  26.466  1.00 28.93           C  
ATOM   1933  OG  SER   140      -0.859  15.151  27.372  1.00 29.34           O  
ATOM   1935  C   SER   140      -1.596  11.834  25.803  1.00 28.12           C  
ATOM   1936  O   SER   140      -2.623  11.555  25.238  1.00 27.68           O  
ATOM   1938  N   VAL   141      -0.454  11.256  25.506  1.00 28.02           N  
ATOM   1939  CA  VAL   141      -0.395  10.196  24.522  1.00 27.98           C  
ATOM   1941  CB  VAL   141       0.827  10.374  23.645  1.00 27.84           C  
ATOM   1943  CG1 VAL   141       0.846   9.345  22.553  1.00 27.05           C  
ATOM   1947  CG2 VAL   141       0.852  11.775  23.089  1.00 27.21           C  
ATOM   1951  C   VAL   141      -0.345   8.820  25.204  1.00 28.40           C  
ATOM   1952  O   VAL   141      -0.958   7.871  24.753  1.00 28.56           O  
ATOM   1954  N   LEU   142       0.434   8.716  26.266  1.00 28.60           N  
ATOM   1955  CA  LEU   142       0.486   7.511  27.059  1.00 28.88           C  
ATOM   1957  CB  LEU   142       1.655   6.641  26.609  1.00 29.36           C  
ATOM   1960  CG  LEU   142       1.363   5.515  25.614  1.00 29.50           C  
ATOM   1962  CD1 LEU   142       2.672   5.036  24.980  1.00 29.36           C  
ATOM   1966  CD2 LEU   142       0.667   4.390  26.351  1.00 28.79           C  
ATOM   1970  C   LEU   142       0.688   7.927  28.500  1.00 29.16           C  
ATOM   1971  O   LEU   142       1.134   9.040  28.782  1.00 29.17           O  
ATOM   1973  N   ASN   143       0.385   7.034  29.430  1.00 29.52           N  
ATOM   1974  CA  ASN   143       0.660   7.355  30.830  1.00 29.66           C  
ATOM   1976  CB  ASN   143      -0.628   7.395  31.629  1.00 29.61           C  
ATOM   1979  CG  ASN   143      -0.449   8.019  33.008  1.00 30.12           C  
ATOM   1980  OD1 ASN   143       0.647   8.046  33.602  1.00 27.75           O  
ATOM   1981  ND2 ASN   143      -1.567   8.488  33.549  1.00 31.84           N  
ATOM   1984  C   ASN   143       1.656   6.390  31.451  1.00 29.47           C  
ATOM   1985  O   ASN   143       1.281   5.505  32.230  1.00 28.77           O  
ATOM   1987  N   ILE   144       2.927   6.598  31.096  1.00 29.28           N  
ATOM   1988  CA  ILE   144       4.015   5.785  31.617  1.00 29.57           C  
ATOM   1990  CB  ILE   144       5.319   6.097  30.858  1.00 30.11           C  
ATOM   1992  CG1 ILE   144       5.167   5.738  29.372  1.00 31.30           C  
ATOM   1995  CD1 ILE   144       4.789   4.257  29.149  1.00 30.50           C  
ATOM   1999  CG2 ILE   144       6.510   5.303  31.422  1.00 30.18           C  
ATOM   2003  C   ILE   144       4.215   6.059  33.113  1.00 29.39           C  
ATOM   2004  O   ILE   144       4.545   5.141  33.866  1.00 28.54           O  
ATOM   2006  N   ALA   145       4.002   7.321  33.525  1.00 29.02           N  
ATOM   2007  CA  ALA   145       4.144   7.720  34.926  1.00 28.89           C  
ATOM   2009  CB  ALA   145       3.712   9.214  35.134  1.00 28.28           C  
ATOM   2013  C   ALA   145       3.364   6.780  35.871  1.00 29.09           C  
ATOM   2014  O   ALA   145       3.871   6.429  36.949  1.00 30.20           O  
ATOM   2016  N   SER   146       2.152   6.351  35.482  1.00 28.63           N  
ATOM   2017  CA  SER   146       1.299   5.589  36.399  1.00 28.27           C  
ATOM   2019  CB  SER   146      -0.022   6.323  36.579  1.00 28.33           C  
ATOM   2022  OG  SER   146      -0.803   6.270  35.407  1.00 28.49           O  
ATOM   2024  C   SER   146       1.055   4.147  35.959  1.00 27.91           C  
ATOM   2025  O   SER   146       0.192   3.468  36.474  1.00 27.20           O  
ATOM   2027  N   ALA   147       1.844   3.685  35.009  1.00 28.29           N  
ATOM   2028  CA  ALA   147       1.650   2.368  34.418  1.00 28.30           C  
ATOM   2030  CB  ALA   147       2.500   2.220  33.141  1.00 28.16           C  
ATOM   2034  C   ALA   147       2.008   1.281  35.414  1.00 28.18           C  
ATOM   2035  O   ALA   147       3.001   1.382  36.137  1.00 27.83           O  
ATOM   2037  N   ASP   148       1.178   0.248  35.441  1.00 28.60           N  
ATOM   2038  CA  ASP   148       1.422  -0.958  36.235  1.00 29.01           C  
ATOM   2040  CB  ASP   148       0.116  -1.758  36.344  1.00 29.22           C  
ATOM   2043  CG  ASP   148       0.271  -3.024  37.194  1.00 30.33           C  
ATOM   2044  OD1 ASP   148       1.223  -3.009  38.017  1.00 32.80           O  
ATOM   2045  OD2 ASP   148      -0.548  -4.005  37.063  1.00 28.99           O  
ATOM   2046  C   ASP   148       2.529  -1.831  35.603  1.00 28.97           C  
ATOM   2047  O   ASP   148       2.258  -2.648  34.732  1.00 29.13           O  
ATOM   2049  N   LEU   149       3.769  -1.644  36.037  1.00 28.92           N  
ATOM   2050  CA  LEU   149       4.910  -2.289  35.410  1.00 28.99           C  
ATOM   2052  CB  LEU   149       5.672  -1.312  34.501  1.00 28.85           C  
ATOM   2055  CG  LEU   149       4.909  -0.925  33.221  1.00 29.26           C  
ATOM   2057  CD1 LEU   149       5.552   0.303  32.539  1.00 28.15           C  
ATOM   2061  CD2 LEU   149       4.777  -2.100  32.253  1.00 27.32           C  
ATOM   2065  C   LEU   149       5.774  -2.797  36.547  1.00 29.23           C  
ATOM   2066  O   LEU   149       6.621  -2.072  37.076  1.00 29.09           O  
ATOM   2068  N   PRO   150       5.560  -4.060  36.923  1.00 29.54           N  
ATOM   2069  CA  PRO   150       6.060  -4.553  38.210  1.00 29.67           C  
ATOM   2071  CB  PRO   150       5.659  -6.054  38.214  1.00 29.48           C  
ATOM   2074  CG  PRO   150       4.613  -6.214  37.167  1.00 29.39           C  
ATOM   2077  CD  PRO   150       4.844  -5.103  36.153  1.00 29.63           C  
ATOM   2080  C   PRO   150       7.581  -4.399  38.417  1.00 29.61           C  
ATOM   2081  O   PRO   150       8.018  -3.945  39.489  1.00 29.54           O  
ATOM   2082  N   ASN   151       8.376  -4.783  37.422  1.00 29.36           N  
ATOM   2083  CA  ASN   151       9.822  -4.955  37.659  1.00 29.29           C  
ATOM   2085  CB  ASN   151      10.222  -6.417  37.379  1.00 29.22           C  
ATOM   2088  CG  ASN   151       9.393  -7.403  38.184  1.00 29.70           C  
ATOM   2089  OD1 ASN   151       9.515  -7.467  39.415  1.00 31.50           O  
ATOM   2090  ND2 ASN   151       8.529  -8.160  37.506  1.00 29.02           N  
ATOM   2093  C   ASN   151      10.696  -3.953  36.893  1.00 29.09           C  
ATOM   2094  O   ASN   151      11.868  -4.212  36.608  1.00 28.75           O  
ATOM   2096  N   THR   152      10.114  -2.797  36.586  1.00 29.07           N  
ATOM   2097  CA  THR   152      10.816  -1.768  35.853  1.00 29.13           C  
ATOM   2099  CB  THR   152      10.365  -1.749  34.358  1.00 29.31           C  
ATOM   2101  OG1 THR   152       8.964  -1.486  34.277  1.00 28.92           O  
ATOM   2103  CG2 THR   152      10.672  -3.123  33.693  1.00 29.99           C  
ATOM   2107  C   THR   152      10.600  -0.410  36.487  1.00 28.94           C  
ATOM   2108  O   THR   152       9.581   0.221  36.237  1.00 29.39           O  
ATOM   2110  N   GLY   153      11.562   0.038  37.301  1.00 28.73           N  
ATOM   2111  CA  GLY   153      11.483   1.345  37.989  1.00 28.04           C  
ATOM   2114  C   GLY   153      10.359   1.408  39.007  1.00 27.67           C  
ATOM   2115  O   GLY   153       9.875   0.385  39.480  1.00 27.40           O  
ATOM   2117  N   ARG   154       9.926   2.618  39.332  1.00 27.56           N  
ATOM   2118  CA  ARG   154       8.747   2.822  40.177  1.00 27.59           C  
ATOM   2120  CB  ARG   154       9.132   3.433  41.525  1.00 27.45           C  
ATOM   2123  CG  ARG   154       9.477   2.437  42.549  1.00 27.94           C  
ATOM   2126  CD  ARG   154      10.289   3.050  43.692  1.00 29.70           C  
ATOM   2129  NE  ARG   154      11.140   2.009  44.299  1.00 31.13           N  
ATOM   2131  CZ  ARG   154      11.949   2.180  45.345  1.00 30.89           C  
ATOM   2132  NH1 ARG   154      12.044   3.355  45.964  1.00 31.54           N  
ATOM   2135  NH2 ARG   154      12.672   1.155  45.773  1.00 31.08           N  
ATOM   2138  C   ARG   154       7.802   3.767  39.492  1.00 27.48           C  
ATOM   2139  O   ARG   154       8.250   4.674  38.804  1.00 28.31           O  
ATOM   2141  N   PRO   155       6.494   3.619  39.730  1.00 27.20           N  
ATOM   2142  CA  PRO   155       5.580   4.628  39.183  1.00 27.00           C  
ATOM   2144  CB  PRO   155       4.213   4.019  39.450  1.00 27.10           C  
ATOM   2147  CG  PRO   155       4.437   3.158  40.638  1.00 26.63           C  
ATOM   2150  CD  PRO   155       5.785   2.594  40.507  1.00 26.55           C  
ATOM   2153  C   PRO   155       5.717   5.931  39.935  1.00 26.56           C  
ATOM   2154  O   PRO   155       6.093   5.929  41.091  1.00 26.56           O  
ATOM   2155  N   PHE   156       5.403   7.035  39.293  1.00 26.62           N  
ATOM   2156  CA  PHE   156       5.498   8.302  39.973  1.00 27.22           C  
ATOM   2158  CB  PHE   156       6.778   9.058  39.597  1.00 27.60           C  
ATOM   2161  CG  PHE   156       6.860   9.460  38.156  1.00 28.10           C  
ATOM   2162  CD1 PHE   156       6.445  10.730  37.746  1.00 28.61           C  
ATOM   2164  CE1 PHE   156       6.503  11.085  36.419  1.00 27.46           C  
ATOM   2166  CZ  PHE   156       7.012  10.192  35.490  1.00 27.56           C  
ATOM   2168  CE2 PHE   156       7.440   8.944  35.877  1.00 27.45           C  
ATOM   2170  CD2 PHE   156       7.367   8.578  37.206  1.00 27.25           C  
ATOM   2172  C   PHE   156       4.281   9.183  39.828  1.00 27.25           C  
ATOM   2173  O   PHE   156       3.396   8.940  39.036  1.00 27.35           O  
ATOM   2175  N   GLN   157       4.266  10.209  40.661  1.00 28.12           N  
ATOM   2176  CA  GLN   157       3.162  11.132  40.818  1.00 28.30           C  
ATOM   2178  CB  GLN   157       3.023  11.430  42.312  1.00 28.26           C  
ATOM   2181  CG  GLN   157       1.573  11.587  42.818  1.00 29.14           C  
ATOM   2184  CD  GLN   157       0.726  10.354  42.579  1.00 28.88           C  
ATOM   2185  OE1 GLN   157       1.229   9.216  42.576  1.00 28.76           O  
ATOM   2186  NE2 GLN   157      -0.573  10.565  42.387  1.00 28.49           N  
ATOM   2189  C   GLN   157       3.458  12.421  40.041  1.00 28.32           C  
ATOM   2190  O   GLN   157       4.630  12.798  39.874  1.00 28.21           O  
ATOM   2192  N   CYS   158       2.393  13.052  39.540  1.00 28.34           N  
ATOM   2193  CA  CYS   158       2.457  14.325  38.805  1.00 28.55           C  
ATOM   2195  CB  CYS   158       2.053  14.113  37.368  1.00 28.36           C  
ATOM   2198  SG  CYS   158       3.234  13.191  36.449  1.00 32.99           S  
ATOM   2200  C   CYS   158       1.518  15.370  39.380  1.00 28.03           C  
ATOM   2201  O   CYS   158       0.415  15.028  39.825  1.00 28.21           O  
ATOM   2203  N   ILE   159       1.945  16.633  39.348  1.00 27.55           N  
ATOM   2204  CA  ILE   159       1.083  17.776  39.671  1.00 27.15           C  
ATOM   2206  CB  ILE   159       1.560  18.532  40.932  1.00 27.19           C  
ATOM   2208  CG1 ILE   159       1.641  17.546  42.109  1.00 27.25           C  
ATOM   2211  CD1 ILE   159       1.732  18.195  43.500  1.00 27.36           C  
ATOM   2215  CG2 ILE   159       0.655  19.748  41.227  1.00 26.47           C  
ATOM   2219  C   ILE   159       1.151  18.672  38.468  1.00 27.06           C  
ATOM   2220  O   ILE   159       2.008  19.550  38.397  1.00 27.30           O  
ATOM   2222  N   PRO   160       0.298  18.414  37.472  1.00 27.10           N  
ATOM   2223  CA  PRO   160       0.305  19.229  36.281  1.00 27.19           C  
ATOM   2225  CB  PRO   160      -0.544  18.406  35.303  1.00 26.90           C  
ATOM   2228  CG  PRO   160      -1.433  17.695  36.094  1.00 26.70           C  
ATOM   2231  CD  PRO   160      -0.693  17.339  37.350  1.00 27.27           C  
ATOM   2234  C   PRO   160      -0.314  20.600  36.470  1.00 27.02           C  
ATOM   2235  O   PRO   160      -0.932  20.865  37.479  1.00 27.06           O  
ATOM   2236  N   GLY   161      -0.094  21.468  35.491  1.00 27.50           N  
ATOM   2237  CA  GLY   161      -0.924  22.640  35.290  1.00 27.79           C  
ATOM   2240  C   GLY   161      -0.387  23.921  35.877  1.00 27.97           C  
ATOM   2241  O   GLY   161      -0.988  24.972  35.702  1.00 28.30           O  
ATOM   2243  N   TYR   162       0.734  23.872  36.581  1.00 28.36           N  
ATOM   2244  CA  TYR   162       1.233  25.110  37.155  1.00 28.73           C  
ATOM   2246  CB  TYR   162       2.370  24.897  38.182  1.00 29.03           C  
ATOM   2249  CG  TYR   162       2.842  26.246  38.703  1.00 30.02           C  
ATOM   2250  CD1 TYR   162       2.168  26.905  39.728  1.00 30.55           C  
ATOM   2252  CE1 TYR   162       2.574  28.183  40.156  1.00 31.77           C  
ATOM   2254  CZ  TYR   162       3.668  28.808  39.529  1.00 32.70           C  
ATOM   2255  OH  TYR   162       4.146  30.073  39.894  1.00 31.50           O  
ATOM   2257  CE2 TYR   162       4.321  28.152  38.497  1.00 32.51           C  
ATOM   2259  CD2 TYR   162       3.893  26.901  38.083  1.00 31.20           C  
ATOM   2261  C   TYR   162       1.658  26.061  36.018  1.00 28.23           C  
ATOM   2262  O   TYR   162       2.606  25.766  35.303  1.00 27.90           O  
ATOM   2264  N   ARG   163       0.938  27.177  35.868  1.00 27.90           N  
ATOM   2265  CA  ARG   163       1.139  28.134  34.763  1.00 27.84           C  
ATOM   2267  CB  ARG   163       2.396  28.962  35.001  1.00 27.51           C  
ATOM   2270  CG  ARG   163       2.350  29.744  36.287  1.00 28.30           C  
ATOM   2273  CD  ARG   163       3.691  30.412  36.611  1.00 28.58           C  
ATOM   2276  NE  ARG   163       3.973  31.592  35.798  1.00 29.09           N  
ATOM   2278  CZ  ARG   163       5.109  32.290  35.861  1.00 29.67           C  
ATOM   2279  NH1 ARG   163       6.078  31.937  36.710  1.00 30.17           N  
ATOM   2282  NH2 ARG   163       5.285  33.355  35.082  1.00 29.92           N  
ATOM   2285  C   ARG   163       1.174  27.499  33.350  1.00 27.71           C  
ATOM   2286  O   ARG   163       1.954  27.913  32.497  1.00 27.28           O  
ATOM   2288  N   ALA   164       0.302  26.517  33.113  1.00 27.57           N  
ATOM   2289  CA  ALA   164       0.159  25.891  31.798  1.00 27.60           C  
ATOM   2291  CB  ALA   164      -1.012  24.920  31.791  1.00 27.29           C  
ATOM   2295  C   ALA   164      -0.012  26.895  30.656  1.00 27.60           C  
ATOM   2296  O   ALA   164       0.579  26.704  29.599  1.00 27.70           O  
ATOM   2298  N   GLU   165      -0.800  27.951  30.862  1.00 27.39           N  
ATOM   2299  CA  GLU   165      -1.129  28.868  29.776  1.00 27.48           C  
ATOM   2301  CB  GLU   165      -2.048  29.961  30.262  1.00 27.81           C  
ATOM   2304  CG  GLU   165      -3.485  29.532  30.421  1.00 28.47           C  
ATOM   2307  CD  GLU   165      -4.392  30.708  30.786  1.00 30.58           C  
ATOM   2308  OE1 GLU   165      -4.442  31.711  30.023  1.00 30.66           O  
ATOM   2309  OE2 GLU   165      -5.060  30.633  31.849  1.00 32.43           O  
ATOM   2310  C   GLU   165       0.095  29.506  29.147  1.00 27.46           C  
ATOM   2311  O   GLU   165       0.268  29.497  27.928  1.00 27.18           O  
ATOM   2313  N   GLU   166       0.952  30.060  29.986  1.00 27.59           N  
ATOM   2314  CA  GLU   166       2.217  30.598  29.507  1.00 27.66           C  
ATOM   2316  CB  GLU   166       2.961  31.263  30.642  1.00 27.89           C  
ATOM   2319  CG  GLU   166       2.239  32.502  31.138  1.00 28.65           C  
ATOM   2322  CD  GLU   166       2.848  33.086  32.398  1.00 29.34           C  
ATOM   2323  OE1 GLU   166       3.360  32.322  33.252  1.00 28.90           O  
ATOM   2324  OE2 GLU   166       2.794  34.329  32.526  1.00 30.57           O  
ATOM   2325  C   GLU   166       3.097  29.544  28.876  1.00 27.37           C  
ATOM   2326  O   GLU   166       3.672  29.780  27.827  1.00 27.66           O  
ATOM   2328  N   ALA   167       3.185  28.376  29.498  1.00 27.20           N  
ATOM   2329  CA  ALA   167       3.951  27.277  28.926  1.00 26.97           C  
ATOM   2331  CB  ALA   167       3.988  26.105  29.869  1.00 26.83           C  
ATOM   2335  C   ALA   167       3.441  26.861  27.541  1.00 26.95           C  
ATOM   2336  O   ALA   167       4.225  26.686  26.627  1.00 27.07           O  
ATOM   2338  N   VAL   168       2.146  26.697  27.351  1.00 27.13           N  
ATOM   2339  CA  VAL   168       1.671  26.376  25.996  1.00 27.57           C  
ATOM   2341  CB  VAL   168       0.208  25.937  25.964  1.00 27.39           C  
ATOM   2343  CG1 VAL   168       0.085  24.566  26.594  1.00 27.92           C  
ATOM   2347  CG2 VAL   168      -0.663  26.963  26.637  1.00 26.18           C  
ATOM   2351  C   VAL   168       1.852  27.548  25.023  1.00 28.01           C  
ATOM   2352  O   VAL   168       2.143  27.336  23.839  1.00 27.90           O  
ATOM   2354  N   GLU   169       1.711  28.781  25.515  1.00 28.22           N  
ATOM   2355  CA  GLU   169       1.960  29.937  24.661  1.00 28.31           C  
ATOM   2357  CB  GLU   169       1.661  31.238  25.379  1.00 28.19           C  
ATOM   2360  CG  GLU   169       0.934  32.227  24.473  1.00 29.54           C  
ATOM   2363  CD  GLU   169       0.943  33.661  25.021  1.00 31.96           C  
ATOM   2364  OE1 GLU   169       1.714  33.912  26.000  1.00 34.14           O  
ATOM   2365  OE2 GLU   169       0.198  34.544  24.472  1.00 32.15           O  
ATOM   2366  C   GLU   169       3.388  29.963  24.101  1.00 28.30           C  
ATOM   2367  O   GLU   169       3.597  30.326  22.943  1.00 28.98           O  
ATOM   2369  N   MET   170       4.367  29.589  24.914  1.00 28.08           N  
ATOM   2370  CA  MET   170       5.754  29.551  24.453  1.00 28.04           C  
ATOM   2372  CB  MET   170       6.726  29.335  25.622  1.00 27.87           C  
ATOM   2375  CG  MET   170       7.074  30.615  26.367  1.00 28.33           C  
ATOM   2378  SD  MET   170       8.249  30.471  27.752  1.00 28.55           S  
ATOM   2379  CE  MET   170       7.214  29.683  28.987  1.00 27.96           C  
ATOM   2383  C   MET   170       5.940  28.468  23.400  1.00 28.13           C  
ATOM   2384  O   MET   170       6.505  28.715  22.348  1.00 28.20           O  
ATOM   2386  N   LEU   171       5.473  27.261  23.700  1.00 28.42           N  
ATOM   2387  CA  LEU   171       5.558  26.143  22.769  1.00 28.42           C  
ATOM   2389  CB  LEU   171       4.834  24.913  23.331  1.00 28.74           C  
ATOM   2392  CG  LEU   171       5.614  23.807  24.025  1.00 28.64           C  
ATOM   2394  CD1 LEU   171       4.612  22.730  24.485  1.00 27.77           C  
ATOM   2398  CD2 LEU   171       6.693  23.239  23.103  1.00 28.05           C  
ATOM   2402  C   LEU   171       4.911  26.485  21.439  1.00 28.37           C  
ATOM   2403  O   LEU   171       5.433  26.122  20.377  1.00 28.57           O  
ATOM   2405  N   LYS   172       3.753  27.142  21.499  1.00 28.00           N  
ATOM   2406  CA  LYS   172       3.012  27.463  20.274  1.00 27.85           C  
ATOM   2408  CB  LYS   172       1.593  28.000  20.576  1.00 27.67           C  
ATOM   2411  CG  LYS   172       0.523  26.888  20.684  1.00 27.83           C  
ATOM   2414  CD  LYS   172      -0.851  27.407  21.176  1.00 28.79           C  
ATOM   2417  CE  LYS   172      -1.973  26.373  20.896  1.00 29.34           C  
ATOM   2420  NZ  LYS   172      -2.428  26.347  19.368  1.00 29.31           N  
ATOM   2424  C   LYS   172       3.815  28.432  19.425  1.00 27.32           C  
ATOM   2425  O   LYS   172       3.942  28.266  18.218  1.00 27.26           O  
ATOM   2427  N   THR   173       4.380  29.432  20.074  1.00 27.30           N  
ATOM   2428  CA  THR   173       5.135  30.429  19.362  1.00 27.36           C  
ATOM   2430  CB  THR   173       5.501  31.639  20.254  1.00 26.82           C  
ATOM   2432  OG1 THR   173       6.315  32.503  19.498  1.00 28.03           O  
ATOM   2434  CG2 THR   173       6.295  31.285  21.426  1.00 26.84           C  
ATOM   2438  C   THR   173       6.353  29.769  18.728  1.00 27.39           C  
ATOM   2439  O   THR   173       6.729  30.102  17.611  1.00 27.65           O  
ATOM   2441  N   PHE   174       6.925  28.799  19.429  1.00 27.67           N  
ATOM   2442  CA  PHE   174       8.075  28.052  18.934  1.00 27.96           C  
ATOM   2444  CB  PHE   174       8.691  27.157  20.029  1.00 28.11           C  
ATOM   2447  CG  PHE   174       9.701  26.141  19.491  1.00 27.94           C  
ATOM   2448  CD1 PHE   174      11.002  26.527  19.174  1.00 26.47           C  
ATOM   2450  CE1 PHE   174      11.911  25.605  18.678  1.00 26.06           C  
ATOM   2452  CZ  PHE   174      11.523  24.288  18.477  1.00 25.76           C  
ATOM   2454  CE2 PHE   174      10.242  23.892  18.780  1.00 26.66           C  
ATOM   2456  CD2 PHE   174       9.334  24.807  19.287  1.00 27.84           C  
ATOM   2458  C   PHE   174       7.766  27.179  17.721  1.00 28.18           C  
ATOM   2459  O   PHE   174       8.631  27.024  16.863  1.00 28.86           O  
ATOM   2461  N   TYR   175       6.575  26.582  17.646  1.00 28.31           N  
ATOM   2462  CA  TYR   175       6.244  25.756  16.479  1.00 28.37           C  
ATOM   2464  CB  TYR   175       5.120  24.775  16.797  1.00 28.20           C  
ATOM   2467  CG  TYR   175       5.549  23.642  17.687  1.00 29.03           C  
ATOM   2468  CD1 TYR   175       4.708  23.182  18.704  1.00 29.68           C  
ATOM   2470  CE1 TYR   175       5.092  22.132  19.551  1.00 30.13           C  
ATOM   2472  CZ  TYR   175       6.344  21.524  19.369  1.00 30.83           C  
ATOM   2473  OH  TYR   175       6.716  20.480  20.195  1.00 33.11           O  
ATOM   2475  CE2 TYR   175       7.205  21.961  18.362  1.00 29.36           C  
ATOM   2477  CD2 TYR   175       6.801  23.013  17.521  1.00 29.43           C  
ATOM   2479  C   TYR   175       5.922  26.556  15.211  1.00 28.44           C  
ATOM   2480  O   TYR   175       5.590  25.962  14.192  1.00 28.62           O  
ATOM   2482  N   LYS   176       6.052  27.880  15.254  1.00 28.50           N  
ATOM   2483  CA  LYS   176       6.067  28.676  14.029  1.00 29.01           C  
ATOM   2485  CB  LYS   176       5.261  29.955  14.213  1.00 28.81           C  
ATOM   2488  CG  LYS   176       3.855  29.628  14.728  1.00 29.06           C  
ATOM   2491  CD  LYS   176       3.017  30.883  15.126  1.00 28.97           C  
ATOM   2494  CE  LYS   176       1.805  30.431  16.053  1.00 28.62           C  
ATOM   2497  NZ  LYS   176       0.966  31.639  16.480  1.00 28.07           N  
ATOM   2501  C   LYS   176       7.516  28.924  13.596  1.00 29.73           C  
ATOM   2502  O   LYS   176       8.033  30.071  13.612  1.00 29.38           O  
ATOM   2504  N   GLN   177       8.151  27.782  13.243  1.00 30.84           N  
ATOM   2505  CA  GLN   177       9.491  27.720  12.613  1.00 31.22           C  
ATOM   2507  CB  GLN   177      10.615  28.236  13.553  1.00 31.62           C  
ATOM   2510  CG  GLN   177      12.100  28.010  13.035  1.00 32.08           C  
ATOM   2513  CD  GLN   177      12.575  29.029  11.958  1.00 32.52           C  
ATOM   2514  OE1 GLN   177      12.497  30.261  12.160  1.00 31.81           O  
ATOM   2515  NE2 GLN   177      13.111  28.498  10.831  1.00 31.77           N  
ATOM   2518  C   GLN   177       9.731  26.249  12.215  1.00 30.80           C  
ATOM   2519  O   GLN   177       9.033  25.353  12.722  1.00 29.50           O  
END
