
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  150 ( 1154),  selected  150 , name 1tiy_B
# Molecule2: number of CA atoms  162 ( 1272),  selected  162 , name T0461.pdb
# PARAMETERS: 1tiy_B.T0461.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_B      E      16           -
LGA    -       -      N      17           -
LGA    -       -      L      18           -
LGA    -       -      Y      19           -
LGA    -       -      F      20           -
LGA    -       -      Q      21           -
LGA    -       -      S      22           -
LGA    -       -      M      23           -
LGA    -       -      E      24           -
LGA    N     2_B      E      25          0.431
LGA    H     3_B      T      26          0.544
LGA    E     4_B      E      27          0.565
LGA    T     5_B      K      28          0.778
LGA    F     6_B      W      29          0.378
LGA    L     7_B      M      30          1.198
LGA    K     8_B      E      31          1.380
LGA    R     9_B      E      32          0.899
LGA    A    10_B      A      33          0.819
LGA    V    11_B      M      34          1.324
LGA    T    12_B      H      35          1.060
LGA    L    13_B      M      36          0.384
LGA    A    14_B      A      37          0.569
LGA    C    15_B      K      38          0.764
LGA    E    16_B      E      39          0.874
LGA    G    17_B      A      40          1.074
LGA    V    18_B      L      41          1.120
LGA    N    19_B      E      42          0.989
LGA    A    20_B      N      43          3.090
LGA    G    21_B      T      44          3.481
LGA    I    22_B      -       -           -
LGA    G    23_B      E      45          1.717
LGA    G    24_B      V      46          1.248
LGA    P    25_B      P      47          0.739
LGA    F    26_B      V      48          0.492
LGA    G    27_B      G      49          0.635
LGA    A    28_B      C      50          0.571
LGA    V    29_B      L      51          0.412
LGA    I    30_B      M      52          0.238
LGA    V    31_B      V      53          0.779
LGA    K    32_B      Y      54          1.333
LGA    D    33_B      N      55          1.814
LGA    G    34_B      N      56          1.784
LGA    A    35_B      E      57          2.079
LGA    I    36_B      V      58          1.271
LGA    I    37_B      V      59          1.432
LGA    A    38_B      G      60          1.362
LGA    E    39_B      K      61          0.672
LGA    G    40_B      G      62          0.602
LGA    Q    41_B      R      63          0.510
LGA    N    42_B      N      64          0.633
LGA    N    43_B      E      65          0.710
LGA    V    44_B      V      66          0.753
LGA    T    45_B      N      67          1.371
LGA    T    46_B      Q      68          0.991
LGA    S    47_B      T      69          0.504
LGA    N    48_B      K      70          1.942
LGA    D    49_B      N      71          1.485
LGA    P    50_B      A      72          1.128
LGA    T    51_B      T      73          0.966
LGA    A    52_B      R      74          0.226
LGA    H    53_B      H      75          0.250
LGA    A    54_B      A      76          0.535
LGA    E    55_B      E      77          0.924
LGA    V    56_B      M      78          1.396
LGA    T    57_B      V      79          1.125
LGA    A    58_B      A      80          0.615
LGA    I    59_B      I      81          1.100
LGA    R    60_B      D      82          1.401
LGA    K    61_B      Q      83          0.947
LGA    A    62_B      V      84          0.633
LGA    C    63_B      L      85          1.433
LGA    K    64_B      D      86          1.674
LGA    V    65_B      W      87          1.033
LGA    L    66_B      C      88          1.017
LGA    G    67_B      R      89          2.612
LGA    A    68_B      Q      90           -
LGA    -       -      S      91           -
LGA    -       -      G      92           -
LGA    -       -      K      93           -
LGA    -       -      S      94           -
LGA    Y    69_B      P      95          3.807
LGA    Q    70_B      S      96          3.084
LGA    -       -      E      97           -
LGA    -       -      V      98           -
LGA    L    71_B      F      99          0.949
LGA    D    72_B      E     100          1.195
LGA    D    73_B      H     101          1.604
LGA    C    74_B      T     102          1.075
LGA    I    75_B      V     103          0.971
LGA    L    76_B      L     104          0.475
LGA    Y    77_B      Y     105          0.366
LGA    T    78_B      V     106          0.618
LGA    S    79_B      T     107          0.702
LGA    C    80_B      V     108          1.131
LGA    E    81_B      E     109          0.729
LGA    P    82_B      P     110          0.406
LGA    C    83_B      C     111          0.399
LGA    P    84_B      I     112          0.703
LGA    X    85_B      M     113          0.625
LGA    C    86_B      C     114          0.448
LGA    L    87_B      A     115          0.397
LGA    G    88_B      A     116          0.819
LGA    A    89_B      A     117          0.878
LGA    I    90_B      L     118          0.393
LGA    Y    91_B      R     119          0.679
LGA    W    92_B      L     120          1.238
LGA    A    93_B      M     121          1.318
LGA    R    94_B      K     122          1.238
LGA    P    95_B      I     123          1.748
LGA    K    96_B      P     124          3.158
LGA    A    97_B      L     125          1.129
LGA    V    98_B      V     126          1.127
LGA    F    99_B      V     127          0.439
LGA    Y   100_B      Y     128          0.480
LGA    A   101_B      G     129          1.279
LGA    A   102_B      C     130          1.259
LGA    E   103_B      Q     131          1.684
LGA    H   104_B      N     132          2.113
LGA    T   105_B      E     133          4.009
LGA    D   106_B      -       -           -
LGA    A   107_B      -       -           -
LGA    A   108_B      -       -           -
LGA    E   109_B      -       -           -
LGA    A   110_B      -       -           -
LGA    G   111_B      -       -           -
LGA    F   112_B      -       -           -
LGA    D   113_B      R     134          1.356
LGA    D   114_B      F     135          1.120
LGA    S   115_B      G     136          5.429
LGA    F   116_B      -       -           -
LGA    I   117_B      -       -           -
LGA    Y   118_B      G     137          6.166
LGA    -       -      C     138           -
LGA    -       -      G     139           -
LGA    -       -      S     140           -
LGA    -       -      V     141           -
LGA    K   119_B      L     142          6.328
LGA    E   120_B      N     143           -
LGA    I   121_B      I     144           #
LGA    D   122_B      A     145           -
LGA    K   123_B      S     146           -
LGA    P   124_B      A     147           -
LGA    A   125_B      D     148           -
LGA    E   126_B      L     149           -
LGA    E   127_B      P     150           -
LGA    R   128_B      N     151           -
LGA    T   129_B      T     152           -
LGA    I   130_B      G     153           -
LGA    P   131_B      R     154           -
LGA    F   132_B      P     155           -
LGA    Y   133_B      F     156           -
LGA    Q   134_B      Q     157           -
LGA    V   135_B      C     158           -
LGA    T   136_B      I     159           -
LGA    L   137_B      P     160           -
LGA    T   138_B      G     161           -
LGA    E   139_B      Y     162           -
LGA    H   140_B      R     163           -
LGA    L   141_B      A     164           -
LGA    S   142_B      E     165           -
LGA    P   143_B      E     166           -
LGA    F   144_B      A     167           -
LGA    Q   145_B      V     168           -
LGA    A   146_B      E     169           -
LGA    W   147_B      M     170           -
LGA    R   148_B      L     171           -
LGA    N   149_B      K     172           -
LGA    F   150_B      T     173           -
LGA    -       -      F     174           -
LGA    -       -      Y     175           -
LGA    -       -      K     176           -
LGA    -       -      Q     177           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  150  162    5.0    107    1.66    23.36     62.191     6.091

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.410074 * X  +  -0.908759 * Y  +   0.077436 * Z  +   8.672074
  Y_new =   0.879248 * X  +   0.371331 * Y  +  -0.298391 * Z  + -47.842861
  Z_new =   0.242411 * X  +   0.190448 * Y  +   0.951297 * Z  + -47.193405 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.197586   -2.944006  [ DEG:    11.3209   -168.6792 ]
  Theta =  -0.244850   -2.896742  [ DEG:   -14.0289   -165.9711 ]
  Phi   =   1.134395   -2.007198  [ DEG:    64.9960   -115.0040 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1tiy_B                                        
REMARK     2: T0461.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1tiy_B.T0461.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  150  162   5.0  107   1.66   23.36  62.191
REMARK  ---------------------------------------------------------- 
MOLECULE 1tiy_B
HEADER    HYDROLASE                               02-JUN-04   1TIY              
TITLE     X-RAY STRUCTURE OF GUANINE DEAMINASE FROM BACILLUS SUBTILIS           
TITLE    2 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM TARGET SR160                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GUANINE DEAMINASE;                                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: GUANASE, GUANINE AMINASE, GUANINE AMINOHYDROLASE,           
COMPND   5 GAH, GDEASE;                                                         
COMPND   6 EC: 3.5.4.3;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: GUAD, GDE, BSU13170;                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    PROTEIN-ZN COMPLEX, STRUCTURAL GENOMICS, PSI, PROTEIN                 
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.KUZIN,S.VOROBIEV,W.EDSTROM,F.FOROUHAR,T.ACTON,R.SHASTRY,          
AUTHOR   2 L.-C.MA,Y.-W.CHIANG,G.MONTELIONE,L.TONG,J.F.HUNT,NORTHEAST           
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   3   25-JAN-05 1TIY    1       AUTHOR KEYWDS REMARK                     
REVDAT   2   20-JUL-04 1TIY    1       EXPDTA                                   
REVDAT   1   22-JUN-04 1TIY    0                                                
JRNL        AUTH   A.P.KUZIN,S.VOROBIEV,W.EDSTROM,F.FOROUHAR,T.ACTON,           
JRNL        AUTH 2 R.SHASTRY,L.-C.MA,Y.-W.CHIANG,G.MONTELIONE,L.TONG,           
JRNL        AUTH 3 J.F.HUNT                                                     
JRNL        TITL   X-RAY STRUCTURE OF GUANINE DEAMINASE FROM BACILLUS           
JRNL        TITL 2 SUBTILIS NORTHEAST STRUCTURAL GENOMICS CONSORTIUM            
JRNL        TITL 3 TARGET SR160                                                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1TIY A    1   156  UNP    O34598   GUAD_BACSU       1    156             
DBREF  1TIY B    1   156  UNP    O34598   GUAD_BACSU       1    156             
SEQRES   1 A  164  MSE ASN HIS GLU THR PHE LEU LYS ARG ALA VAL THR LEU          
SEQRES   2 A  164  ALA CYS GLU GLY VAL ASN ALA GLY ILE GLY GLY PRO PHE          
SEQRES   3 A  164  GLY ALA VAL ILE VAL LYS ASP GLY ALA ILE ILE ALA GLU          
SEQRES   4 A  164  GLY GLN ASN ASN VAL THR THR SER ASN ASP PRO THR ALA          
SEQRES   5 A  164  HIS ALA GLU VAL THR ALA ILE ARG LYS ALA CYS LYS VAL          
SEQRES   6 A  164  LEU GLY ALA TYR GLN LEU ASP ASP CYS ILE LEU TYR THR          
SEQRES   7 A  164  SER CYS GLU PRO CYS PRO MSE CYS LEU GLY ALA ILE TYR          
SEQRES   8 A  164  TRP ALA ARG PRO LYS ALA VAL PHE TYR ALA ALA GLU HIS          
SEQRES   9 A  164  THR ASP ALA ALA GLU ALA GLY PHE ASP ASP SER PHE ILE          
SEQRES  10 A  164  TYR LYS GLU ILE ASP LYS PRO ALA GLU GLU ARG THR ILE          
SEQRES  11 A  164  PRO PHE TYR GLN VAL THR LEU THR GLU HIS LEU SER PRO          
SEQRES  12 A  164  PHE GLN ALA TRP ARG ASN PHE ALA ASN LYS LYS GLU TYR          
SEQRES  13 A  164  LEU GLU HIS HIS HIS HIS HIS HIS                              
SEQRES   1 B  164  MSE ASN HIS GLU THR PHE LEU LYS ARG ALA VAL THR LEU          
SEQRES   2 B  164  ALA CYS GLU GLY VAL ASN ALA GLY ILE GLY GLY PRO PHE          
SEQRES   3 B  164  GLY ALA VAL ILE VAL LYS ASP GLY ALA ILE ILE ALA GLU          
SEQRES   4 B  164  GLY GLN ASN ASN VAL THR THR SER ASN ASP PRO THR ALA          
SEQRES   5 B  164  HIS ALA GLU VAL THR ALA ILE ARG LYS ALA CYS LYS VAL          
SEQRES   6 B  164  LEU GLY ALA TYR GLN LEU ASP ASP CYS ILE LEU TYR THR          
SEQRES   7 B  164  SER CYS GLU PRO CYS PRO MSE CYS LEU GLY ALA ILE TYR          
SEQRES   8 B  164  TRP ALA ARG PRO LYS ALA VAL PHE TYR ALA ALA GLU HIS          
SEQRES   9 B  164  THR ASP ALA ALA GLU ALA GLY PHE ASP ASP SER PHE ILE          
SEQRES  10 B  164  TYR LYS GLU ILE ASP LYS PRO ALA GLU GLU ARG THR ILE          
SEQRES  11 B  164  PRO PHE TYR GLN VAL THR LEU THR GLU HIS LEU SER PRO          
SEQRES  12 B  164  PHE GLN ALA TRP ARG ASN PHE ALA ASN LYS LYS GLU TYR          
SEQRES  13 B  164  LEU GLU HIS HIS HIS HIS HIS HIS                              
HET    MSE  A   1       8                                                       
HET    MSE  A  85       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  85       8                                                       
HET     ZN  A 200       1                                                       
HET     ZN  B 201       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      ZN ZINC ION                                                         
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3   ZN    2(ZN 2+)                                                     
FORMUL   5  HOH   *64(H2 O)                                                     
CRYST1   99.287   99.287   72.927  90.00  90.00  90.00 P 43 21 2    16          
HETATM 1216  N   MSE B   1      12.825  28.881  46.934  1.00 90.79           N  
HETATM 1217  CA  MSE B   1      12.735  27.940  48.087  1.00 90.59           C  
HETATM 1218  C   MSE B   1      11.297  27.456  48.284  1.00 86.14           C  
HETATM 1219  O   MSE B   1      10.935  26.960  49.350  1.00 86.04           O  
HETATM 1220  CB  MSE B   1      13.254  28.628  49.363  1.00 97.59           C  
HETATM 1221  CG  MSE B   1      12.611  29.994  49.683  1.00106.03           C  
HETATM 1222 SE   MSE B   1      13.351  30.936  51.260  1.00117.44          SE  
HETATM 1223  CE  MSE B   1      14.536  32.197  50.370  1.00113.40           C  
ATOM   1224  N   ASN B   2      10.490  27.586  47.235  1.00 80.66           N  
ATOM   1225  CA  ASN B   2       9.089  27.184  47.273  1.00 74.81           C  
ATOM   1226  C   ASN B   2       8.677  26.426  46.003  1.00 71.17           C  
ATOM   1227  O   ASN B   2       9.123  26.756  44.910  1.00 70.05           O  
ATOM   1228  CB  ASN B   2       8.227  28.431  47.446  1.00 74.43           C  
ATOM   1229  CG  ASN B   2       6.771  28.159  47.221  1.00 73.24           C  
ATOM   1230  OD1 ASN B   2       6.193  27.269  47.844  1.00 73.26           O  
ATOM   1231  ND2 ASN B   2       6.158  28.927  46.327  1.00 72.07           N  
ATOM   1232  N   HIS B   3       7.821  25.416  46.153  1.00 67.02           N  
ATOM   1233  CA  HIS B   3       7.376  24.621  45.006  1.00 63.52           C  
ATOM   1234  C   HIS B   3       7.099  25.468  43.779  1.00 61.28           C  
ATOM   1235  O   HIS B   3       7.557  25.157  42.683  1.00 59.18           O  
ATOM   1236  CB  HIS B   3       6.105  23.832  45.339  1.00 63.45           C  
ATOM   1237  CG  HIS B   3       6.348  22.605  46.164  1.00 63.44           C  
ATOM   1238  ND1 HIS B   3       5.330  21.754  46.540  1.00 62.45           N  
ATOM   1239  CD2 HIS B   3       7.480  22.096  46.694  1.00 62.67           C  
ATOM   1240  CE1 HIS B   3       5.831  20.772  47.270  1.00 62.05           C  
ATOM   1241  NE2 HIS B   3       7.133  20.955  47.380  1.00 61.78           N  
ATOM   1242  N   GLU B   4       6.340  26.540  43.978  1.00 59.99           N  
ATOM   1243  CA  GLU B   4       5.976  27.443  42.895  1.00 58.20           C  
ATOM   1244  C   GLU B   4       7.172  28.164  42.283  1.00 56.23           C  
ATOM   1245  O   GLU B   4       7.274  28.276  41.063  1.00 55.02           O  
ATOM   1246  CB  GLU B   4       4.945  28.465  43.388  1.00 59.47           C  
ATOM   1247  CG  GLU B   4       3.552  27.884  43.645  1.00 62.21           C  
ATOM   1248  CD  GLU B   4       3.520  26.849  44.771  1.00 63.79           C  
ATOM   1249  OE1 GLU B   4       3.821  27.212  45.929  1.00 64.30           O  
ATOM   1250  OE2 GLU B   4       3.192  25.670  44.499  1.00 64.70           O  
ATOM   1251  N   THR B   5       8.080  28.648  43.123  1.00 54.25           N  
ATOM   1252  CA  THR B   5       9.249  29.352  42.612  1.00 53.30           C  
ATOM   1253  C   THR B   5      10.183  28.428  41.821  1.00 51.05           C  
ATOM   1254  O   THR B   5      10.808  28.860  40.848  1.00 49.99           O  
ATOM   1255  CB  THR B   5      10.034  30.045  43.753  1.00 54.48           C  
ATOM   1256  OG1 THR B   5      10.555  29.061  44.653  1.00 57.12           O  
ATOM   1257  CG2 THR B   5       9.114  31.000  44.519  1.00 54.79           C  
ATOM   1258  N   PHE B   6      10.275  27.163  42.230  1.00 49.06           N  
ATOM   1259  CA  PHE B   6      11.122  26.196  41.528  1.00 46.60           C  
ATOM   1260  C   PHE B   6      10.536  25.894  40.159  1.00 43.91           C  
ATOM   1261  O   PHE B   6      11.252  25.817  39.164  1.00 43.84           O  
ATOM   1262  CB  PHE B   6      11.225  24.881  42.299  1.00 47.58           C  
ATOM   1263  CG  PHE B   6      12.031  24.969  43.560  1.00 47.86           C  
ATOM   1264  CD1 PHE B   6      13.277  25.589  43.569  1.00 48.97           C  
ATOM   1265  CD2 PHE B   6      11.569  24.378  44.733  1.00 48.36           C  
ATOM   1266  CE1 PHE B   6      14.056  25.619  44.731  1.00 48.79           C  
ATOM   1267  CE2 PHE B   6      12.337  24.399  45.898  1.00 48.01           C  
ATOM   1268  CZ  PHE B   6      13.584  25.020  45.896  1.00 48.54           C  
ATOM   1269  N   LEU B   7       9.226  25.700  40.119  1.00 41.35           N  
ATOM   1270  CA  LEU B   7       8.557  25.421  38.864  1.00 40.97           C  
ATOM   1271  C   LEU B   7       8.671  26.673  38.011  1.00 41.60           C  
ATOM   1272  O   LEU B   7       8.915  26.600  36.804  1.00 42.16           O  
ATOM   1273  CB  LEU B   7       7.086  25.082  39.107  1.00 39.51           C  
ATOM   1274  CG  LEU B   7       6.344  24.458  37.925  1.00 38.54           C  
ATOM   1275  CD1 LEU B   7       7.068  23.197  37.454  1.00 36.39           C  
ATOM   1276  CD2 LEU B   7       4.924  24.134  38.346  1.00 38.06           C  
ATOM   1277  N   LYS B   8       8.494  27.828  38.648  1.00 41.74           N  
ATOM   1278  CA  LYS B   8       8.601  29.093  37.945  1.00 41.07           C  
ATOM   1279  C   LYS B   8       9.977  29.219  37.327  1.00 39.30           C  
ATOM   1280  O   LYS B   8      10.122  29.701  36.210  1.00 40.05           O  
ATOM   1281  CB  LYS B   8       8.359  30.261  38.894  1.00 44.00           C  
ATOM   1282  CG  LYS B   8       6.934  30.788  38.863  1.00 48.00           C  
ATOM   1283  CD  LYS B   8       6.824  32.148  39.544  1.00 51.71           C  
ATOM   1284  CE  LYS B   8       7.847  33.140  38.976  1.00 54.43           C  
ATOM   1285  NZ  LYS B   8       7.822  33.219  37.481  1.00 55.80           N  
ATOM   1286  N   ARG B   9      10.988  28.774  38.060  1.00 37.96           N  
ATOM   1287  CA  ARG B   9      12.361  28.831  37.574  1.00 37.37           C  
ATOM   1288  C   ARG B   9      12.552  27.950  36.349  1.00 36.82           C  
ATOM   1289  O   ARG B   9      13.231  28.342  35.403  1.00 39.00           O  
ATOM   1290  CB  ARG B   9      13.323  28.402  38.680  1.00 37.16           C  
ATOM   1291  CG  ARG B   9      14.749  28.198  38.228  1.00 36.03           C  
ATOM   1292  CD  ARG B   9      15.324  29.407  37.526  1.00 35.57           C  
ATOM   1293  NE  ARG B   9      16.734  29.188  37.221  1.00 36.32           N  
ATOM   1294  CZ  ARG B   9      17.414  29.828  36.275  1.00 36.52           C  
ATOM   1295  NH1 ARG B   9      16.814  30.744  35.521  1.00 36.12           N  
ATOM   1296  NH2 ARG B   9      18.697  29.540  36.078  1.00 34.28           N  
ATOM   1297  N   ALA B  10      11.956  26.763  36.363  1.00 35.03           N  
ATOM   1298  CA  ALA B  10      12.067  25.859  35.230  1.00 34.94           C  
ATOM   1299  C   ALA B  10      11.478  26.540  33.997  1.00 35.93           C  
ATOM   1300  O   ALA B  10      12.020  26.432  32.896  1.00 34.59           O  
ATOM   1301  CB  ALA B  10      11.324  24.566  35.518  1.00 34.51           C  
ATOM   1302  N   VAL B  11      10.365  27.242  34.192  1.00 37.47           N  
ATOM   1303  CA  VAL B  11       9.692  27.941  33.103  1.00 39.48           C  
ATOM   1304  C   VAL B  11      10.535  29.103  32.591  1.00 40.46           C  
ATOM   1305  O   VAL B  11      10.537  29.400  31.394  1.00 40.43           O  
ATOM   1306  CB  VAL B  11       8.325  28.493  33.552  1.00 40.63           C  
ATOM   1307  CG1 VAL B  11       7.703  29.310  32.436  1.00 41.17           C  
ATOM   1308  CG2 VAL B  11       7.404  27.353  33.938  1.00 41.62           C  
ATOM   1309  N   THR B  12      11.240  29.757  33.511  1.00 40.79           N  
ATOM   1310  CA  THR B  12      12.104  30.883  33.177  1.00 41.07           C  
ATOM   1311  C   THR B  12      13.302  30.384  32.379  1.00 41.03           C  
ATOM   1312  O   THR B  12      13.857  31.109  31.549  1.00 40.56           O  
ATOM   1313  CB  THR B  12      12.606  31.588  34.443  1.00 41.52           C  
ATOM   1314  OG1 THR B  12      11.494  32.172  35.131  1.00 41.48           O  
ATOM   1315  CG2 THR B  12      13.609  32.671  34.085  1.00 40.36           C  
ATOM   1316  N   LEU B  13      13.703  29.148  32.650  1.00 40.13           N  
ATOM   1317  CA  LEU B  13      14.809  28.535  31.933  1.00 40.60           C  
ATOM   1318  C   LEU B  13      14.294  28.172  30.555  1.00 41.43           C  
ATOM   1319  O   LEU B  13      15.019  28.258  29.568  1.00 41.40           O  
ATOM   1320  CB  LEU B  13      15.264  27.262  32.634  1.00 40.37           C  
ATOM   1321  CG  LEU B  13      16.353  27.350  33.694  1.00 39.46           C  
ATOM   1322  CD1 LEU B  13      16.435  26.029  34.434  1.00 39.20           C  
ATOM   1323  CD2 LEU B  13      17.678  27.676  33.031  1.00 38.00           C  
ATOM   1324  N   ALA B  14      13.029  27.761  30.509  1.00 42.29           N  
ATOM   1325  CA  ALA B  14      12.375  27.364  29.270  1.00 43.93           C  
ATOM   1326  C   ALA B  14      12.388  28.498  28.262  1.00 45.37           C  
ATOM   1327  O   ALA B  14      12.577  28.275  27.065  1.00 44.70           O  
ATOM   1328  CB  ALA B  14      10.936  26.936  29.551  1.00 44.13           C  
ATOM   1329  N   CYS B  15      12.185  29.718  28.750  1.00 46.71           N  
ATOM   1330  CA  CYS B  15      12.178  30.887  27.879  1.00 47.78           C  
ATOM   1331  C   CYS B  15      13.590  31.225  27.448  1.00 48.40           C  
ATOM   1332  O   CYS B  15      13.871  31.333  26.255  1.00 48.45           O  
ATOM   1333  CB  CYS B  15      11.555  32.083  28.595  1.00 47.61           C  
ATOM   1334  SG  CYS B  15       9.806  31.845  28.918  1.00 46.60           S  
ATOM   1335  N   GLU B  16      14.475  31.395  28.422  1.00 48.74           N  
ATOM   1336  CA  GLU B  16      15.857  31.702  28.118  1.00 50.86           C  
ATOM   1337  C   GLU B  16      16.364  30.720  27.070  1.00 51.82           C  
ATOM   1338  O   GLU B  16      17.108  31.092  26.166  1.00 52.13           O  
ATOM   1339  CB  GLU B  16      16.692  31.617  29.390  1.00 51.28           C  
ATOM   1340  CG  GLU B  16      16.239  32.602  30.450  1.00 53.73           C  
ATOM   1341  CD  GLU B  16      17.023  32.486  31.740  1.00 55.11           C  
ATOM   1342  OE1 GLU B  16      16.783  33.308  32.656  1.00 54.87           O  
ATOM   1343  OE2 GLU B  16      17.879  31.576  31.836  1.00 55.56           O  
ATOM   1344  N   GLY B  17      15.939  29.466  27.190  1.00 53.36           N  
ATOM   1345  CA  GLY B  17      16.350  28.445  26.239  1.00 54.42           C  
ATOM   1346  C   GLY B  17      16.006  28.813  24.808  1.00 54.50           C  
ATOM   1347  O   GLY B  17      16.880  28.835  23.940  1.00 54.39           O  
ATOM   1348  N   VAL B  18      14.730  29.096  24.563  1.00 54.95           N  
ATOM   1349  CA  VAL B  18      14.269  29.485  23.236  1.00 55.77           C  
ATOM   1350  C   VAL B  18      15.068  30.695  22.770  1.00 55.78           C  
ATOM   1351  O   VAL B  18      15.732  30.656  21.733  1.00 55.40           O  
ATOM   1352  CB  VAL B  18      12.776  29.888  23.246  1.00 56.15           C  
ATOM   1353  CG1 VAL B  18      12.347  30.312  21.854  1.00 56.25           C  
ATOM   1354  CG2 VAL B  18      11.917  28.733  23.734  1.00 56.27           C  
ATOM   1355  N   ASN B  19      14.991  31.761  23.562  1.00 55.77           N  
ATOM   1356  CA  ASN B  19      15.664  33.027  23.286  1.00 56.20           C  
ATOM   1357  C   ASN B  19      17.127  32.915  22.909  1.00 56.18           C  
ATOM   1358  O   ASN B  19      17.528  33.363  21.839  1.00 56.65           O  
ATOM   1359  CB  ASN B  19      15.547  33.953  24.497  1.00 57.37           C  
ATOM   1360  CG  ASN B  19      14.114  34.325  24.811  1.00 58.17           C  
ATOM   1361  OD1 ASN B  19      13.835  34.927  25.850  1.00 59.13           O  
ATOM   1362  ND2 ASN B  19      13.196  33.971  23.914  1.00 57.40           N  
ATOM   1363  N   ALA B  20      17.928  32.331  23.795  1.00 56.33           N  
ATOM   1364  CA  ALA B  20      19.360  32.192  23.541  1.00 56.29           C  
ATOM   1365  C   ALA B  20      19.662  31.295  22.339  1.00 56.20           C  
ATOM   1366  O   ALA B  20      20.824  31.077  21.996  1.00 55.57           O  
ATOM   1367  CB  ALA B  20      20.060  31.658  24.784  1.00 55.84           C  
ATOM   1368  N   GLY B  21      18.609  30.788  21.703  1.00 56.23           N  
ATOM   1369  CA  GLY B  21      18.778  29.926  20.548  1.00 55.85           C  
ATOM   1370  C   GLY B  21      19.479  28.632  20.906  1.00 55.73           C  
ATOM   1371  O   GLY B  21      20.063  27.973  20.043  1.00 55.45           O  
ATOM   1372  N   ILE B  22      19.414  28.263  22.183  1.00 56.00           N  
ATOM   1373  CA  ILE B  22      20.058  27.044  22.658  1.00 54.80           C  
ATOM   1374  C   ILE B  22      19.167  25.815  22.516  1.00 52.80           C  
ATOM   1375  O   ILE B  22      19.618  24.703  22.770  1.00 53.32           O  
ATOM   1376  CB  ILE B  22      20.483  27.162  24.138  1.00 55.83           C  
ATOM   1377  CG1 ILE B  22      19.251  27.149  25.040  1.00 57.50           C  
ATOM   1378  CG2 ILE B  22      21.247  28.458  24.367  1.00 54.48           C  
ATOM   1379  CD1 ILE B  22      19.591  27.215  26.517  1.00 59.55           C  
ATOM   1380  N   GLY B  23      17.912  26.011  22.114  1.00 50.18           N  
ATOM   1381  CA  GLY B  23      17.023  24.876  21.943  1.00 47.02           C  
ATOM   1382  C   GLY B  23      15.536  25.162  22.060  1.00 45.38           C  
ATOM   1383  O   GLY B  23      15.106  26.316  22.066  1.00 45.11           O  
ATOM   1384  N   GLY B  24      14.755  24.088  22.158  1.00 43.25           N  
ATOM   1385  CA  GLY B  24      13.311  24.200  22.262  1.00 40.37           C  
ATOM   1386  C   GLY B  24      12.806  24.788  23.564  1.00 39.23           C  
ATOM   1387  O   GLY B  24      13.561  24.914  24.526  1.00 39.14           O  
ATOM   1388  N   PRO B  25      11.508  25.130  23.633  1.00 38.08           N  
ATOM   1389  CA  PRO B  25      10.857  25.718  24.808  1.00 36.81           C  
ATOM   1390  C   PRO B  25      10.644  24.778  25.994  1.00 36.15           C  
ATOM   1391  O   PRO B  25       9.507  24.525  26.383  1.00 36.36           O  
ATOM   1392  CB  PRO B  25       9.541  26.218  24.235  1.00 36.53           C  
ATOM   1393  CG  PRO B  25       9.198  25.135  23.265  1.00 36.14           C  
ATOM   1394  CD  PRO B  25      10.524  24.909  22.557  1.00 37.12           C  
ATOM   1395  N   PHE B  26      11.725  24.280  26.585  1.00 35.53           N  
ATOM   1396  CA  PHE B  26      11.593  23.366  27.717  1.00 33.87           C  
ATOM   1397  C   PHE B  26      12.696  23.487  28.761  1.00 32.26           C  
ATOM   1398  O   PHE B  26      13.880  23.442  28.434  1.00 33.23           O  
ATOM   1399  CB  PHE B  26      11.539  21.932  27.203  1.00 34.38           C  
ATOM   1400  CG  PHE B  26      10.367  21.656  26.314  1.00 36.00           C  
ATOM   1401  CD1 PHE B  26       9.101  21.486  26.854  1.00 37.17           C  
ATOM   1402  CD2 PHE B  26      10.528  21.560  24.937  1.00 36.52           C  
ATOM   1403  CE1 PHE B  26       8.012  21.213  26.036  1.00 38.64           C  
ATOM   1404  CE2 PHE B  26       9.445  21.290  24.109  1.00 36.50           C  
ATOM   1405  CZ  PHE B  26       8.187  21.117  24.657  1.00 38.04           C  
ATOM   1406  N   GLY B  27      12.292  23.624  30.020  1.00 30.20           N  
ATOM   1407  CA  GLY B  27      13.246  23.742  31.107  1.00 29.22           C  
ATOM   1408  C   GLY B  27      12.869  22.895  32.311  1.00 28.64           C  
ATOM   1409  O   GLY B  27      11.683  22.621  32.537  1.00 29.13           O  
ATOM   1410  N   ALA B  28      13.873  22.486  33.090  1.00 26.64           N  
ATOM   1411  CA  ALA B  28      13.631  21.659  34.270  1.00 24.98           C  
ATOM   1412  C   ALA B  28      14.694  21.807  35.349  1.00 24.44           C  
ATOM   1413  O   ALA B  28      15.865  22.064  35.065  1.00 23.01           O  
ATOM   1414  CB  ALA B  28      13.536  20.194  33.862  1.00 24.41           C  
ATOM   1415  N   VAL B  29      14.273  21.644  36.596  1.00 24.24           N  
ATOM   1416  CA  VAL B  29      15.202  21.709  37.707  1.00 26.43           C  
ATOM   1417  C   VAL B  29      14.939  20.587  38.695  1.00 27.32           C  
ATOM   1418  O   VAL B  29      13.824  20.076  38.821  1.00 26.48           O  
ATOM   1419  CB  VAL B  29      15.131  23.048  38.466  1.00 26.83           C  
ATOM   1420  CG1 VAL B  29      15.247  24.199  37.481  1.00 26.60           C  
ATOM   1421  CG2 VAL B  29      13.853  23.129  39.286  1.00 28.23           C  
ATOM   1422  N   ILE B  30      16.001  20.198  39.381  1.00 28.10           N  
ATOM   1423  CA  ILE B  30      15.930  19.158  40.376  1.00 29.18           C  
ATOM   1424  C   ILE B  30      16.435  19.811  41.639  1.00 30.96           C  
ATOM   1425  O   ILE B  30      17.470  20.477  41.620  1.00 29.78           O  
ATOM   1426  CB  ILE B  30      16.832  17.976  40.001  1.00 28.38           C  
ATOM   1427  CG1 ILE B  30      16.178  17.174  38.879  1.00 28.81           C  
ATOM   1428  CG2 ILE B  30      17.089  17.110  41.224  1.00 27.80           C  
ATOM   1429  CD1 ILE B  30      17.102  16.205  38.198  1.00 28.56           C  
ATOM   1430  N   VAL B  31      15.696  19.645  42.728  1.00 32.33           N  
ATOM   1431  CA  VAL B  31      16.098  20.237  43.985  1.00 35.57           C  
ATOM   1432  C   VAL B  31      16.234  19.172  45.062  1.00 38.38           C  
ATOM   1433  O   VAL B  31      15.514  18.176  45.070  1.00 38.54           O  
ATOM   1434  CB  VAL B  31      15.080  21.311  44.445  1.00 35.45           C  
ATOM   1435  CG1 VAL B  31      14.693  22.196  43.267  1.00 34.17           C  
ATOM   1436  CG2 VAL B  31      13.860  20.654  45.039  1.00 36.26           C  
ATOM   1437  N   LYS B  32      17.187  19.386  45.960  1.00 41.38           N  
ATOM   1438  CA  LYS B  32      17.427  18.477  47.066  1.00 43.18           C  
ATOM   1439  C   LYS B  32      17.589  19.366  48.286  1.00 45.10           C  
ATOM   1440  O   LYS B  32      18.346  20.343  48.251  1.00 46.02           O  
ATOM   1441  CB  LYS B  32      18.703  17.674  46.832  1.00 44.56           C  
ATOM   1442  CG  LYS B  32      18.953  16.576  47.860  1.00 45.19           C  
ATOM   1443  CD  LYS B  32      20.124  15.703  47.432  1.00 47.25           C  
ATOM   1444  CE  LYS B  32      20.235  14.414  48.256  1.00 48.26           C  
ATOM   1445  NZ  LYS B  32      20.764  14.613  49.636  1.00 47.45           N  
ATOM   1446  N   ASP B  33      16.867  19.038  49.355  1.00 45.80           N  
ATOM   1447  CA  ASP B  33      16.926  19.820  50.586  1.00 46.91           C  
ATOM   1448  C   ASP B  33      16.688  21.298  50.311  1.00 46.51           C  
ATOM   1449  O   ASP B  33      17.463  22.147  50.753  1.00 47.70           O  
ATOM   1450  CB  ASP B  33      18.290  19.669  51.265  1.00 49.40           C  
ATOM   1451  CG  ASP B  33      18.789  18.233  51.274  1.00 51.03           C  
ATOM   1452  OD1 ASP B  33      18.016  17.320  51.644  1.00 51.37           O  
ATOM   1453  OD2 ASP B  33      19.969  18.027  50.916  1.00 52.23           O  
ATOM   1454  N   GLY B  34      15.627  21.594  49.565  1.00 45.48           N  
ATOM   1455  CA  GLY B  34      15.282  22.973  49.256  1.00 44.49           C  
ATOM   1456  C   GLY B  34      16.191  23.732  48.307  1.00 44.21           C  
ATOM   1457  O   GLY B  34      15.912  24.885  47.967  1.00 43.97           O  
ATOM   1458  N   ALA B  35      17.278  23.106  47.869  1.00 43.49           N  
ATOM   1459  CA  ALA B  35      18.197  23.779  46.961  1.00 41.53           C  
ATOM   1460  C   ALA B  35      18.204  23.149  45.576  1.00 40.88           C  
ATOM   1461  O   ALA B  35      18.052  21.936  45.419  1.00 39.98           O  
ATOM   1462  CB  ALA B  35      19.604  23.776  47.548  1.00 40.98           C  
ATOM   1463  N   ILE B  36      18.375  23.997  44.571  1.00 39.46           N  
ATOM   1464  CA  ILE B  36      18.425  23.559  43.188  1.00 39.16           C  
ATOM   1465  C   ILE B  36      19.788  22.903  42.926  1.00 37.84           C  
ATOM   1466  O   ILE B  36      20.831  23.524  43.090  1.00 38.19           O  
ATOM   1467  CB  ILE B  36      18.174  24.768  42.255  1.00 40.41           C  
ATOM   1468  CG1 ILE B  36      18.787  24.520  40.878  1.00 39.33           C  
ATOM   1469  CG2 ILE B  36      18.676  26.045  42.917  1.00 42.55           C  
ATOM   1470  CD1 ILE B  36      18.047  23.501  40.073  1.00 41.68           C  
ATOM   1471  N   ILE B  37      19.760  21.635  42.522  1.00 36.58           N  
ATOM   1472  CA  ILE B  37      20.962  20.845  42.265  1.00 35.47           C  
ATOM   1473  C   ILE B  37      21.446  20.810  40.813  1.00 34.71           C  
ATOM   1474  O   ILE B  37      22.635  20.649  40.554  1.00 34.25           O  
ATOM   1475  CB  ILE B  37      20.744  19.385  42.730  1.00 36.30           C  
ATOM   1476  CG1 ILE B  37      20.415  19.369  44.215  1.00 38.45           C  
ATOM   1477  CG2 ILE B  37      21.976  18.543  42.463  1.00 37.83           C  
ATOM   1478  CD1 ILE B  37      21.492  19.978  45.083  1.00 40.14           C  
ATOM   1479  N   ALA B  38      20.530  20.929  39.864  1.00 33.66           N  
ATOM   1480  CA  ALA B  38      20.918  20.910  38.465  1.00 34.10           C  
ATOM   1481  C   ALA B  38      19.810  21.485  37.612  1.00 34.39           C  
ATOM   1482  O   ALA B  38      18.647  21.441  37.989  1.00 31.85           O  
ATOM   1483  CB  ALA B  38      21.229  19.489  38.024  1.00 34.33           C  
ATOM   1484  N   GLU B  39      20.182  22.033  36.459  1.00 36.96           N  
ATOM   1485  CA  GLU B  39      19.211  22.614  35.545  1.00 38.32           C  
ATOM   1486  C   GLU B  39      19.353  22.034  34.152  1.00 38.33           C  
ATOM   1487  O   GLU B  39      20.459  21.765  33.681  1.00 39.19           O  
ATOM   1488  CB  GLU B  39      19.365  24.133  35.476  1.00 39.83           C  
ATOM   1489  CG  GLU B  39      19.247  24.831  36.818  1.00 43.51           C  
ATOM   1490  CD  GLU B  39      19.034  26.328  36.681  1.00 46.23           C  
ATOM   1491  OE1 GLU B  39      19.715  26.970  35.843  1.00 48.89           O  
ATOM   1492  OE2 GLU B  39      18.190  26.872  37.423  1.00 47.54           O  
ATOM   1493  N   GLY B  40      18.221  21.845  33.489  1.00 37.94           N  
ATOM   1494  CA  GLY B  40      18.254  21.301  32.152  1.00 38.01           C  
ATOM   1495  C   GLY B  40      17.388  22.114  31.217  1.00 39.74           C  
ATOM   1496  O   GLY B  40      16.423  22.763  31.630  1.00 39.07           O  
ATOM   1497  N   GLN B  41      17.747  22.072  29.941  1.00 40.91           N  
ATOM   1498  CA  GLN B  41      17.021  22.770  28.896  1.00 41.58           C  
ATOM   1499  C   GLN B  41      17.114  21.915  27.642  1.00 41.36           C  
ATOM   1500  O   GLN B  41      18.035  21.105  27.507  1.00 40.83           O  
ATOM   1501  CB  GLN B  41      17.650  24.136  28.643  1.00 42.88           C  
ATOM   1502  CG  GLN B  41      17.523  25.108  29.802  1.00 45.20           C  
ATOM   1503  CD  GLN B  41      18.394  26.331  29.605  1.00 44.90           C  
ATOM   1504  OE1 GLN B  41      19.619  26.218  29.544  1.00 45.60           O  
ATOM   1505  NE2 GLN B  41      17.771  27.504  29.494  1.00 43.51           N  
ATOM   1506  N   ASN B  42      16.163  22.079  26.728  1.00 41.85           N  
ATOM   1507  CA  ASN B  42      16.178  21.301  25.494  1.00 43.15           C  
ATOM   1508  C   ASN B  42      17.282  21.834  24.579  1.00 43.46           C  
ATOM   1509  O   ASN B  42      17.224  22.968  24.105  1.00 43.16           O  
ATOM   1510  CB  ASN B  42      14.817  21.376  24.807  1.00 43.80           C  
ATOM   1511  CG  ASN B  42      14.699  20.410  23.648  1.00 45.84           C  
ATOM   1512  OD1 ASN B  42      15.370  20.563  22.625  1.00 46.80           O  
ATOM   1513  ND2 ASN B  42      13.846  19.399  23.805  1.00 46.36           N  
ATOM   1514  N   ASN B  43      18.289  21.001  24.344  1.00 43.39           N  
ATOM   1515  CA  ASN B  43      19.431  21.371  23.521  1.00 44.56           C  
ATOM   1516  C   ASN B  43      19.755  20.295  22.493  1.00 44.34           C  
ATOM   1517  O   ASN B  43      20.924  20.065  22.179  1.00 44.86           O  
ATOM   1518  CB  ASN B  43      20.658  21.587  24.416  1.00 45.91           C  
ATOM   1519  CG  ASN B  43      20.956  20.376  25.309  1.00 47.49           C  
ATOM   1520  OD1 ASN B  43      20.215  20.084  26.252  1.00 46.62           O  
ATOM   1521  ND2 ASN B  43      22.040  19.667  25.004  1.00 47.06           N  
ATOM   1522  N   VAL B  44      18.725  19.644  21.970  1.00 43.70           N  
ATOM   1523  CA  VAL B  44      18.916  18.573  21.001  1.00 44.05           C  
ATOM   1524  C   VAL B  44      19.689  18.980  19.747  1.00 44.81           C  
ATOM   1525  O   VAL B  44      20.612  18.281  19.317  1.00 43.56           O  
ATOM   1526  CB  VAL B  44      17.556  17.979  20.566  1.00 43.70           C  
ATOM   1527  CG1 VAL B  44      16.891  17.277  21.745  1.00 42.21           C  
ATOM   1528  CG2 VAL B  44      16.659  19.079  20.034  1.00 43.40           C  
ATOM   1529  N   THR B  45      19.311  20.113  19.165  1.00 45.17           N  
ATOM   1530  CA  THR B  45      19.947  20.602  17.946  1.00 44.91           C  
ATOM   1531  C   THR B  45      21.377  21.102  18.147  1.00 44.66           C  
ATOM   1532  O   THR B  45      22.275  20.810  17.357  1.00 43.98           O  
ATOM   1533  CB  THR B  45      19.104  21.730  17.322  1.00 45.28           C  
ATOM   1534  OG1 THR B  45      18.832  22.725  18.315  1.00 46.40           O  
ATOM   1535  CG2 THR B  45      17.786  21.179  16.793  1.00 46.33           C  
ATOM   1536  N   THR B  46      21.585  21.847  19.220  1.00 44.33           N  
ATOM   1537  CA  THR B  46      22.887  22.410  19.506  1.00 43.92           C  
ATOM   1538  C   THR B  46      23.937  21.430  20.061  1.00 43.68           C  
ATOM   1539  O   THR B  46      25.104  21.790  20.197  1.00 44.40           O  
ATOM   1540  CB  THR B  46      22.727  23.604  20.465  1.00 45.04           C  
ATOM   1541  OG1 THR B  46      24.013  24.155  20.768  1.00 46.23           O  
ATOM   1542  CG2 THR B  46      22.039  23.165  21.747  1.00 45.27           C  
ATOM   1543  N   SER B  47      23.543  20.198  20.372  1.00 42.17           N  
ATOM   1544  CA  SER B  47      24.506  19.231  20.897  1.00 40.14           C  
ATOM   1545  C   SER B  47      24.467  17.875  20.183  1.00 38.41           C  
ATOM   1546  O   SER B  47      25.122  16.919  20.616  1.00 38.36           O  
ATOM   1547  CB  SER B  47      24.286  19.034  22.400  1.00 40.12           C  
ATOM   1548  OG  SER B  47      23.012  18.473  22.657  1.00 42.13           O  
ATOM   1549  N   ASN B  48      23.711  17.804  19.087  1.00 36.60           N  
ATOM   1550  CA  ASN B  48      23.566  16.575  18.304  1.00 35.02           C  
ATOM   1551  C   ASN B  48      23.232  15.371  19.175  1.00 33.59           C  
ATOM   1552  O   ASN B  48      23.842  14.309  19.063  1.00 34.25           O  
ATOM   1553  CB  ASN B  48      24.838  16.291  17.511  1.00 36.53           C  
ATOM   1554  CG  ASN B  48      25.138  17.370  16.488  1.00 39.73           C  
ATOM   1555  OD1 ASN B  48      24.286  17.716  15.666  1.00 40.45           O  
ATOM   1556  ND2 ASN B  48      26.359  17.904  16.527  1.00 40.55           N  
ATOM   1557  N   ASP B  49      22.245  15.550  20.040  1.00 31.24           N  
ATOM   1558  CA  ASP B  49      21.811  14.502  20.944  1.00 29.06           C  
ATOM   1559  C   ASP B  49      20.287  14.552  20.991  1.00 27.86           C  
ATOM   1560  O   ASP B  49      19.701  15.425  21.625  1.00 27.53           O  
ATOM   1561  CB  ASP B  49      22.390  14.764  22.339  1.00 29.44           C  
ATOM   1562  CG  ASP B  49      22.008  13.695  23.351  1.00 29.41           C  
ATOM   1563  OD1 ASP B  49      21.056  12.925  23.089  1.00 29.94           O  
ATOM   1564  OD2 ASP B  49      22.656  13.631  24.418  1.00 26.73           O  
ATOM   1565  N   PRO B  50      19.619  13.620  20.307  1.00 26.34           N  
ATOM   1566  CA  PRO B  50      18.161  13.668  20.355  1.00 24.54           C  
ATOM   1567  C   PRO B  50      17.570  13.263  21.711  1.00 25.14           C  
ATOM   1568  O   PRO B  50      16.351  13.303  21.896  1.00 25.71           O  
ATOM   1569  CB  PRO B  50      17.751  12.734  19.219  1.00 23.18           C  
ATOM   1570  CG  PRO B  50      18.833  11.730  19.197  1.00 23.52           C  
ATOM   1571  CD  PRO B  50      20.085  12.564  19.391  1.00 26.64           C  
ATOM   1572  N   THR B  51      18.420  12.871  22.659  1.00 25.12           N  
ATOM   1573  CA  THR B  51      17.917  12.492  23.978  1.00 26.24           C  
ATOM   1574  C   THR B  51      18.127  13.662  24.914  1.00 25.82           C  
ATOM   1575  O   THR B  51      17.769  13.606  26.076  1.00 26.39           O  
ATOM   1576  CB  THR B  51      18.644  11.244  24.589  1.00 26.98           C  
ATOM   1577  OG1 THR B  51      19.919  11.628  25.121  1.00 30.91           O  
ATOM   1578  CG2 THR B  51      18.844  10.161  23.541  1.00 27.32           C  
ATOM   1579  N   ALA B  52      18.698  14.736  24.392  1.00 27.42           N  
ATOM   1580  CA  ALA B  52      18.977  15.902  25.210  1.00 28.25           C  
ATOM   1581  C   ALA B  52      17.772  16.788  25.533  1.00 29.04           C  
ATOM   1582  O   ALA B  52      17.767  17.975  25.208  1.00 30.41           O  
ATOM   1583  CB  ALA B  52      20.092  16.738  24.559  1.00 26.26           C  
ATOM   1584  N   HIS B  53      16.751  16.222  26.174  1.00 29.24           N  
ATOM   1585  CA  HIS B  53      15.595  17.024  26.570  1.00 28.64           C  
ATOM   1586  C   HIS B  53      15.917  17.639  27.921  1.00 28.77           C  
ATOM   1587  O   HIS B  53      16.812  17.170  28.631  1.00 29.30           O  
ATOM   1588  CB  HIS B  53      14.332  16.185  26.706  1.00 29.60           C  
ATOM   1589  CG  HIS B  53      13.657  15.886  25.405  1.00 34.16           C  
ATOM   1590  ND1 HIS B  53      13.939  14.763  24.658  1.00 37.17           N  
ATOM   1591  CD2 HIS B  53      12.698  16.557  24.726  1.00 36.37           C  
ATOM   1592  CE1 HIS B  53      13.180  14.753  23.577  1.00 36.75           C  
ATOM   1593  NE2 HIS B  53      12.416  15.829  23.593  1.00 36.76           N  
ATOM   1594  N   ALA B  54      15.177  18.679  28.280  1.00 28.49           N  
ATOM   1595  CA  ALA B  54      15.384  19.371  29.543  1.00 28.53           C  
ATOM   1596  C   ALA B  54      15.494  18.427  30.739  1.00 30.14           C  
ATOM   1597  O   ALA B  54      16.516  18.397  31.434  1.00 30.24           O  
ATOM   1598  CB  ALA B  54      14.259  20.359  29.765  1.00 26.46           C  
ATOM   1599  N   GLU B  55      14.431  17.666  30.971  1.00 31.39           N  
ATOM   1600  CA  GLU B  55      14.360  16.721  32.077  1.00 32.16           C  
ATOM   1601  C   GLU B  55      15.479  15.681  32.057  1.00 31.37           C  
ATOM   1602  O   GLU B  55      16.068  15.361  33.100  1.00 29.58           O  
ATOM   1603  CB  GLU B  55      12.992  16.033  32.059  1.00 34.45           C  
ATOM   1604  CG  GLU B  55      12.465  15.807  30.647  1.00 40.71           C  
ATOM   1605  CD  GLU B  55      11.139  16.511  30.400  1.00 43.63           C  
ATOM   1606  OE1 GLU B  55      10.662  16.515  29.239  1.00 46.22           O  
ATOM   1607  OE2 GLU B  55      10.566  17.044  31.376  1.00 44.21           O  
ATOM   1608  N   VAL B  56      15.763  15.154  30.871  1.00 30.18           N  
ATOM   1609  CA  VAL B  56      16.814  14.156  30.716  1.00 31.33           C  
ATOM   1610  C   VAL B  56      18.157  14.777  31.095  1.00 31.44           C  
ATOM   1611  O   VAL B  56      18.953  14.170  31.815  1.00 31.46           O  
ATOM   1612  CB  VAL B  56      16.897  13.638  29.248  1.00 31.87           C  
ATOM   1613  CG1 VAL B  56      18.156  12.792  29.055  1.00 30.61           C  
ATOM   1614  CG2 VAL B  56      15.659  12.822  28.909  1.00 31.87           C  
ATOM   1615  N   THR B  57      18.398  15.991  30.608  1.00 30.31           N  
ATOM   1616  CA  THR B  57      19.645  16.686  30.885  1.00 28.98           C  
ATOM   1617  C   THR B  57      19.783  17.004  32.366  1.00 27.54           C  
ATOM   1618  O   THR B  57      20.811  16.723  32.982  1.00 26.55           O  
ATOM   1619  CB  THR B  57      19.744  17.980  30.035  1.00 30.00           C  
ATOM   1620  OG1 THR B  57      20.041  17.627  28.675  1.00 30.13           O  
ATOM   1621  CG2 THR B  57      20.821  18.904  30.560  1.00 28.29           C  
ATOM   1622  N   ALA B  58      18.735  17.580  32.936  1.00 26.94           N  
ATOM   1623  CA  ALA B  58      18.733  17.921  34.347  1.00 25.83           C  
ATOM   1624  C   ALA B  58      19.082  16.734  35.251  1.00 28.61           C  
ATOM   1625  O   ALA B  58      19.803  16.894  36.248  1.00 30.93           O  
ATOM   1626  CB  ALA B  58      17.380  18.475  34.733  1.00 22.02           C  
ATOM   1627  N   ILE B  59      18.606  15.534  34.925  1.00 28.29           N  
ATOM   1628  CA  ILE B  59      18.907  14.422  35.813  1.00 28.14           C  
ATOM   1629  C   ILE B  59      20.297  13.841  35.606  1.00 27.89           C  
ATOM   1630  O   ILE B  59      20.876  13.285  36.534  1.00 28.63           O  
ATOM   1631  CB  ILE B  59      17.814  13.313  35.751  1.00 29.19           C  
ATOM   1632  CG1 ILE B  59      18.087  12.326  34.627  1.00 28.32           C  
ATOM   1633  CG2 ILE B  59      16.442  13.946  35.586  1.00 31.62           C  
ATOM   1634  CD1 ILE B  59      18.757  11.072  35.112  1.00 27.27           C  
ATOM   1635  N   ARG B  60      20.838  13.974  34.403  1.00 27.91           N  
ATOM   1636  CA  ARG B  60      22.184  13.481  34.152  1.00 29.13           C  
ATOM   1637  C   ARG B  60      23.143  14.338  34.977  1.00 30.14           C  
ATOM   1638  O   ARG B  60      24.036  13.820  35.636  1.00 31.68           O  
ATOM   1639  CB  ARG B  60      22.543  13.600  32.672  1.00 29.91           C  
ATOM   1640  CG  ARG B  60      21.834  12.622  31.764  1.00 33.28           C  
ATOM   1641  CD  ARG B  60      22.085  12.933  30.289  1.00 36.74           C  
ATOM   1642  NE  ARG B  60      23.061  12.048  29.646  1.00 41.78           N  
ATOM   1643  CZ  ARG B  60      24.390  12.159  29.738  1.00 44.95           C  
ATOM   1644  NH1 ARG B  60      25.167  11.291  29.101  1.00 45.10           N  
ATOM   1645  NH2 ARG B  60      24.954  13.131  30.451  1.00 46.30           N  
ATOM   1646  N   LYS B  61      22.951  15.653  34.944  1.00 30.21           N  
ATOM   1647  CA  LYS B  61      23.801  16.565  35.698  1.00 31.50           C  
ATOM   1648  C   LYS B  61      23.691  16.297  37.190  1.00 31.33           C  
ATOM   1649  O   LYS B  61      24.698  16.231  37.891  1.00 32.30           O  
ATOM   1650  CB  LYS B  61      23.409  18.023  35.438  1.00 33.46           C  
ATOM   1651  CG  LYS B  61      23.730  18.551  34.050  1.00 33.44           C  
ATOM   1652  CD  LYS B  61      23.438  20.050  33.968  1.00 34.95           C  
ATOM   1653  CE  LYS B  61      23.876  20.632  32.629  1.00 36.99           C  
ATOM   1654  NZ  LYS B  61      23.630  22.097  32.530  1.00 37.06           N  
ATOM   1655  N   ALA B  62      22.462  16.146  37.672  1.00 31.01           N  
ATOM   1656  CA  ALA B  62      22.219  15.890  39.090  1.00 30.42           C  
ATOM   1657  C   ALA B  62      22.906  14.626  39.558  1.00 30.16           C  
ATOM   1658  O   ALA B  62      23.606  14.623  40.574  1.00 30.52           O  
ATOM   1659  CB  ALA B  62      20.737  15.780  39.351  1.00 30.70           C  
ATOM   1660  N   CYS B  63      22.694  13.544  38.822  1.00 29.57           N  
ATOM   1661  CA  CYS B  63      23.304  12.280  39.181  1.00 30.83           C  
ATOM   1662  C   CYS B  63      24.814  12.441  39.250  1.00 31.03           C  
ATOM   1663  O   CYS B  63      25.465  11.886  40.128  1.00 31.94           O  
ATOM   1664  CB  CYS B  63      22.915  11.195  38.171  1.00 32.12           C  
ATOM   1665  SG  CYS B  63      21.172  10.680  38.304  1.00 36.16           S  
ATOM   1666  N   LYS B  64      25.375  13.215  38.329  1.00 31.09           N  
ATOM   1667  CA  LYS B  64      26.809  13.436  38.339  1.00 30.73           C  
ATOM   1668  C   LYS B  64      27.208  14.187  39.610  1.00 29.82           C  
ATOM   1669  O   LYS B  64      28.114  13.774  40.337  1.00 28.21           O  
ATOM   1670  CB  LYS B  64      27.230  14.206  37.081  1.00 32.98           C  
ATOM   1671  CG  LYS B  64      27.718  13.288  35.950  1.00 34.03           C  
ATOM   1672  CD  LYS B  64      28.101  14.058  34.677  1.00 38.20           C  
ATOM   1673  CE  LYS B  64      29.175  15.143  34.911  1.00 38.96           C  
ATOM   1674  NZ  LYS B  64      29.772  15.645  33.628  1.00 36.66           N  
ATOM   1675  N   VAL B  65      26.518  15.285  39.886  1.00 28.65           N  
ATOM   1676  CA  VAL B  65      26.820  16.047  41.085  1.00 29.23           C  
ATOM   1677  C   VAL B  65      26.820  15.137  42.311  1.00 29.76           C  
ATOM   1678  O   VAL B  65      27.766  15.135  43.101  1.00 28.89           O  
ATOM   1679  CB  VAL B  65      25.790  17.165  41.333  1.00 28.09           C  
ATOM   1680  CG1 VAL B  65      26.030  17.786  42.703  1.00 25.44           C  
ATOM   1681  CG2 VAL B  65      25.895  18.219  40.255  1.00 27.51           C  
ATOM   1682  N   LEU B  66      25.751  14.366  42.466  1.00 30.44           N  
ATOM   1683  CA  LEU B  66      25.620  13.466  43.608  1.00 31.02           C  
ATOM   1684  C   LEU B  66      26.436  12.171  43.510  1.00 29.85           C  
ATOM   1685  O   LEU B  66      26.448  11.374  44.443  1.00 29.24           O  
ATOM   1686  CB  LEU B  66      24.145  13.128  43.813  1.00 31.52           C  
ATOM   1687  CG  LEU B  66      23.254  14.354  44.007  1.00 33.07           C  
ATOM   1688  CD1 LEU B  66      21.804  13.925  44.122  1.00 32.42           C  
ATOM   1689  CD2 LEU B  66      23.691  15.113  45.253  1.00 34.12           C  
ATOM   1690  N   GLY B  67      27.118  11.965  42.389  1.00 29.57           N  
ATOM   1691  CA  GLY B  67      27.906  10.756  42.235  1.00 30.26           C  
ATOM   1692  C   GLY B  67      27.082   9.492  42.416  1.00 30.82           C  
ATOM   1693  O   GLY B  67      27.565   8.493  42.949  1.00 31.38           O  
ATOM   1694  N   ALA B  68      25.831   9.532  41.973  1.00 30.29           N  
ATOM   1695  CA  ALA B  68      24.942   8.388  42.087  1.00 30.55           C  
ATOM   1696  C   ALA B  68      24.186   8.172  40.777  1.00 32.50           C  
ATOM   1697  O   ALA B  68      24.275   8.989  39.864  1.00 32.44           O  
ATOM   1698  CB  ALA B  68      23.973   8.614  43.217  1.00 28.10           C  
ATOM   1699  N   TYR B  69      23.451   7.071  40.674  1.00 34.72           N  
ATOM   1700  CA  TYR B  69      22.690   6.791  39.462  1.00 37.78           C  
ATOM   1701  C   TYR B  69      21.216   6.658  39.811  1.00 38.02           C  
ATOM   1702  O   TYR B  69      20.416   6.145  39.036  1.00 37.64           O  
ATOM   1703  CB  TYR B  69      23.213   5.516  38.791  1.00 41.44           C  
ATOM   1704  CG  TYR B  69      23.147   4.281  39.656  1.00 46.53           C  
ATOM   1705  CD1 TYR B  69      21.944   3.616  39.862  1.00 47.57           C  
ATOM   1706  CD2 TYR B  69      24.289   3.787  40.284  1.00 49.06           C  
ATOM   1707  CE1 TYR B  69      21.873   2.491  40.672  1.00 49.92           C  
ATOM   1708  CE2 TYR B  69      24.228   2.656  41.099  1.00 50.47           C  
ATOM   1709  CZ  TYR B  69      23.016   2.017  41.287  1.00 51.32           C  
ATOM   1710  OH  TYR B  69      22.941   0.905  42.092  1.00 54.98           O  
ATOM   1711  N   GLN B  70      20.873   7.148  40.993  1.00 39.12           N  
ATOM   1712  CA  GLN B  70      19.510   7.113  41.495  1.00 41.49           C  
ATOM   1713  C   GLN B  70      19.295   8.469  42.166  1.00 42.03           C  
ATOM   1714  O   GLN B  70      20.172   8.947  42.873  1.00 42.78           O  
ATOM   1715  CB  GLN B  70      19.385   5.997  42.533  1.00 43.22           C  
ATOM   1716  CG  GLN B  70      18.078   5.226  42.520  1.00 48.58           C  
ATOM   1717  CD  GLN B  70      18.047   4.098  41.484  1.00 52.30           C  
ATOM   1718  OE1 GLN B  70      17.118   3.283  41.464  1.00 53.90           O  
ATOM   1719  NE2 GLN B  70      19.059   4.049  40.620  1.00 53.73           N  
ATOM   1720  N   LEU B  71      18.149   9.101  41.947  1.00 42.61           N  
ATOM   1721  CA  LEU B  71      17.883  10.394  42.577  1.00 44.09           C  
ATOM   1722  C   LEU B  71      16.763  10.212  43.581  1.00 46.37           C  
ATOM   1723  O   LEU B  71      15.920  11.088  43.743  1.00 45.63           O  
ATOM   1724  CB  LEU B  71      17.460  11.424  41.532  1.00 43.17           C  
ATOM   1725  CG  LEU B  71      18.456  11.653  40.394  1.00 43.38           C  
ATOM   1726  CD1 LEU B  71      17.845  12.573  39.353  1.00 42.69           C  
ATOM   1727  CD2 LEU B  71      19.743  12.238  40.947  1.00 42.33           C  
ATOM   1728  N   ASP B  72      16.778   9.061  44.250  1.00 50.56           N  
ATOM   1729  CA  ASP B  72      15.766   8.671  45.232  1.00 53.99           C  
ATOM   1730  C   ASP B  72      15.268   9.720  46.223  1.00 53.78           C  
ATOM   1731  O   ASP B  72      14.173   9.568  46.776  1.00 53.65           O  
ATOM   1732  CB  ASP B  72      16.234   7.422  45.996  1.00 57.16           C  
ATOM   1733  CG  ASP B  72      17.712   7.468  46.342  1.00 61.39           C  
ATOM   1734  OD1 ASP B  72      18.144   8.458  46.979  1.00 63.08           O  
ATOM   1735  OD2 ASP B  72      18.441   6.515  45.970  1.00 62.77           O  
ATOM   1736  N   ASP B  73      16.041  10.778  46.463  1.00 53.41           N  
ATOM   1737  CA  ASP B  73      15.568  11.803  47.388  1.00 52.76           C  
ATOM   1738  C   ASP B  73      15.586  13.225  46.821  1.00 50.87           C  
ATOM   1739  O   ASP B  73      15.936  14.175  47.524  1.00 50.97           O  
ATOM   1740  CB  ASP B  73      16.365  11.747  48.691  1.00 56.32           C  
ATOM   1741  CG  ASP B  73      15.649  12.454  49.843  1.00 59.93           C  
ATOM   1742  OD1 ASP B  73      15.656  13.706  49.880  1.00 60.76           O  
ATOM   1743  OD2 ASP B  73      15.061  11.756  50.702  1.00 61.97           O  
ATOM   1744  N   CYS B  74      15.178  13.372  45.560  1.00 47.60           N  
ATOM   1745  CA  CYS B  74      15.146  14.680  44.900  1.00 44.19           C  
ATOM   1746  C   CYS B  74      13.813  14.943  44.215  1.00 41.98           C  
ATOM   1747  O   CYS B  74      13.036  14.019  43.995  1.00 43.22           O  
ATOM   1748  CB  CYS B  74      16.249  14.767  43.848  1.00 44.16           C  
ATOM   1749  SG  CYS B  74      17.915  14.566  44.492  1.00 45.62           S  
ATOM   1750  N   ILE B  75      13.556  16.203  43.872  1.00 38.29           N  
ATOM   1751  CA  ILE B  75      12.320  16.554  43.191  1.00 35.41           C  
ATOM   1752  C   ILE B  75      12.606  17.174  41.833  1.00 33.47           C  
ATOM   1753  O   ILE B  75      13.545  17.954  41.678  1.00 33.61           O  
ATOM   1754  CB  ILE B  75      11.475  17.555  43.996  1.00 35.49           C  
ATOM   1755  CG1 ILE B  75      11.152  16.973  45.368  1.00 36.45           C  
ATOM   1756  CG2 ILE B  75      10.169  17.851  43.248  1.00 33.88           C  
ATOM   1757  CD1 ILE B  75      10.388  17.930  46.265  1.00 36.44           C  
ATOM   1758  N   LEU B  76      11.782  16.822  40.852  1.00 30.53           N  
ATOM   1759  CA  LEU B  76      11.934  17.346  39.506  1.00 26.67           C  
ATOM   1760  C   LEU B  76      10.820  18.315  39.207  1.00 26.00           C  
ATOM   1761  O   LEU B  76       9.653  17.974  39.337  1.00 25.22           O  
ATOM   1762  CB  LEU B  76      11.889  16.218  38.481  1.00 23.36           C  
ATOM   1763  CG  LEU B  76      11.864  16.665  37.019  1.00 22.13           C  
ATOM   1764  CD1 LEU B  76      13.206  17.260  36.633  1.00 19.99           C  
ATOM   1765  CD2 LEU B  76      11.543  15.484  36.136  1.00 20.15           C  
ATOM   1766  N   TYR B  77      11.184  19.533  38.833  1.00 27.34           N  
ATOM   1767  CA  TYR B  77      10.191  20.526  38.469  1.00 28.78           C  
ATOM   1768  C   TYR B  77      10.447  20.726  36.996  1.00 30.01           C  
ATOM   1769  O   TYR B  77      11.547  21.094  36.603  1.00 30.98           O  
ATOM   1770  CB  TYR B  77      10.409  21.837  39.212  1.00 29.87           C  
ATOM   1771  CG  TYR B  77      10.168  21.736  40.699  1.00 31.73           C  
ATOM   1772  CD1 TYR B  77      11.144  21.217  41.558  1.00 32.60           C  
ATOM   1773  CD2 TYR B  77       8.963  22.154  41.254  1.00 31.13           C  
ATOM   1774  CE1 TYR B  77      10.923  21.121  42.941  1.00 31.60           C  
ATOM   1775  CE2 TYR B  77       8.732  22.063  42.628  1.00 34.27           C  
ATOM   1776  CZ  TYR B  77       9.714  21.547  43.468  1.00 33.50           C  
ATOM   1777  OH  TYR B  77       9.467  21.469  44.821  1.00 34.18           O  
ATOM   1778  N   THR B  78       9.454  20.447  36.168  1.00 31.68           N  
ATOM   1779  CA  THR B  78       9.645  20.609  34.744  1.00 33.54           C  
ATOM   1780  C   THR B  78       8.579  21.533  34.161  1.00 34.87           C  
ATOM   1781  O   THR B  78       7.413  21.483  34.558  1.00 33.39           O  
ATOM   1782  CB  THR B  78       9.682  19.222  34.035  1.00 33.74           C  
ATOM   1783  OG1 THR B  78       9.908  19.412  32.636  1.00 37.07           O  
ATOM   1784  CG2 THR B  78       8.399  18.454  34.255  1.00 32.42           C  
ATOM   1785  N   SER B  79       9.010  22.393  33.236  1.00 36.73           N  
ATOM   1786  CA  SER B  79       8.149  23.386  32.592  1.00 37.98           C  
ATOM   1787  C   SER B  79       6.932  22.815  31.879  1.00 40.14           C  
ATOM   1788  O   SER B  79       5.954  23.524  31.652  1.00 41.39           O  
ATOM   1789  CB  SER B  79       8.954  24.192  31.578  1.00 37.03           C  
ATOM   1790  OG  SER B  79       9.293  23.380  30.465  1.00 36.62           O  
ATOM   1791  N   CYS B  80       6.997  21.541  31.512  1.00 41.40           N  
ATOM   1792  CA  CYS B  80       5.899  20.914  30.798  1.00 42.37           C  
ATOM   1793  C   CYS B  80       5.856  19.415  31.088  1.00 43.56           C  
ATOM   1794  O   CYS B  80       6.845  18.832  31.532  1.00 44.89           O  
ATOM   1795  CB  CYS B  80       6.075  21.167  29.294  1.00 42.45           C  
ATOM   1796  SG  CYS B  80       4.771  20.521  28.209  1.00 43.80           S  
ATOM   1797  N   GLU B  81       4.705  18.794  30.848  1.00 43.66           N  
ATOM   1798  CA  GLU B  81       4.560  17.364  31.068  1.00 43.79           C  
ATOM   1799  C   GLU B  81       5.681  16.647  30.298  1.00 42.44           C  
ATOM   1800  O   GLU B  81       5.979  16.988  29.160  1.00 41.30           O  
ATOM   1801  CB  GLU B  81       3.193  16.908  30.564  1.00 46.62           C  
ATOM   1802  CG  GLU B  81       2.396  16.053  31.547  1.00 49.13           C  
ATOM   1803  CD  GLU B  81       1.106  15.533  30.936  1.00 51.28           C  
ATOM   1804  OE1 GLU B  81       1.182  14.719  29.986  1.00 52.47           O  
ATOM   1805  OE2 GLU B  81       0.012  15.935  31.396  1.00 51.89           O  
ATOM   1806  N   PRO B  82       6.318  15.645  30.920  1.00 41.44           N  
ATOM   1807  CA  PRO B  82       7.405  14.898  30.286  1.00 41.11           C  
ATOM   1808  C   PRO B  82       7.084  13.999  29.099  1.00 40.12           C  
ATOM   1809  O   PRO B  82       6.042  13.360  29.028  1.00 40.33           O  
ATOM   1810  CB  PRO B  82       7.992  14.097  31.444  1.00 41.72           C  
ATOM   1811  CG  PRO B  82       7.737  14.977  32.610  1.00 42.65           C  
ATOM   1812  CD  PRO B  82       6.315  15.395  32.369  1.00 41.72           C  
ATOM   1813  N   CYS B  83       8.021  13.961  28.166  1.00 39.24           N  
ATOM   1814  CA  CYS B  83       7.921  13.135  26.980  1.00 37.13           C  
ATOM   1815  C   CYS B  83       7.937  11.698  27.514  1.00 35.71           C  
ATOM   1816  O   CYS B  83       8.305  11.474  28.665  1.00 36.52           O  
ATOM   1817  CB  CYS B  83       9.146  13.417  26.098  1.00 36.57           C  
ATOM   1818  SG  CYS B  83      10.725  12.586  26.529  1.00 42.51           S  
ATOM   1819  N   PRO B  84       7.516  10.709  26.711  1.00 34.66           N  
ATOM   1820  CA  PRO B  84       7.532   9.326  27.204  1.00 34.12           C  
ATOM   1821  C   PRO B  84       8.928   8.811  27.580  1.00 34.29           C  
ATOM   1822  O   PRO B  84       9.093   8.133  28.597  1.00 34.04           O  
ATOM   1823  CB  PRO B  84       6.912   8.545  26.050  1.00 34.21           C  
ATOM   1824  CG  PRO B  84       5.929   9.510  25.505  1.00 34.38           C  
ATOM   1825  CD  PRO B  84       6.732  10.800  25.469  1.00 34.07           C  
HETATM 1826  N   MSE B  85       9.934   9.129  26.771  1.00 35.16           N  
HETATM 1827  CA  MSE B  85      11.290   8.676  27.073  1.00 35.86           C  
HETATM 1828  C   MSE B  85      11.754   9.344  28.368  1.00 34.43           C  
HETATM 1829  O   MSE B  85      12.599   8.824  29.100  1.00 32.19           O  
HETATM 1830  CB  MSE B  85      12.250   9.019  25.928  1.00 37.80           C  
HETATM 1831  CG  MSE B  85      12.924  10.372  26.041  1.00 43.61           C  
HETATM 1832 SE   MSE B  85      14.537  10.568  24.929  1.00 52.19          SE  
HETATM 1833  CE  MSE B  85      15.656   9.241  25.762  1.00 49.51           C  
ATOM   1834  N   CYS B  86      11.171  10.501  28.644  1.00 32.84           N  
ATOM   1835  CA  CYS B  86      11.478  11.262  29.836  1.00 32.88           C  
ATOM   1836  C   CYS B  86      10.816  10.579  31.030  1.00 31.71           C  
ATOM   1837  O   CYS B  86      11.377  10.529  32.116  1.00 30.62           O  
ATOM   1838  CB  CYS B  86      10.959  12.678  29.651  1.00 35.31           C  
ATOM   1839  SG  CYS B  86      11.639  13.499  28.146  1.00 39.28           S  
ATOM   1840  N   LEU B  87       9.617  10.051  30.820  1.00 31.69           N  
ATOM   1841  CA  LEU B  87       8.918   9.337  31.875  1.00 29.72           C  
ATOM   1842  C   LEU B  87       9.753   8.097  32.188  1.00 29.40           C  
ATOM   1843  O   LEU B  87       9.938   7.743  33.348  1.00 30.26           O  
ATOM   1844  CB  LEU B  87       7.537   8.915  31.399  1.00 29.51           C  
ATOM   1845  CG  LEU B  87       6.500  10.020  31.263  1.00 30.71           C  
ATOM   1846  CD1 LEU B  87       5.277   9.494  30.489  1.00 31.80           C  
ATOM   1847  CD2 LEU B  87       6.116  10.498  32.651  1.00 28.47           C  
ATOM   1848  N   GLY B  88      10.257   7.439  31.149  1.00 27.30           N  
ATOM   1849  CA  GLY B  88      11.070   6.259  31.375  1.00 26.18           C  
ATOM   1850  C   GLY B  88      12.309   6.629  32.168  1.00 25.93           C  
ATOM   1851  O   GLY B  88      12.709   5.929  33.099  1.00 25.89           O  
ATOM   1852  N   ALA B  89      12.913   7.750  31.800  1.00 24.85           N  
ATOM   1853  CA  ALA B  89      14.114   8.228  32.461  1.00 25.19           C  
ATOM   1854  C   ALA B  89      13.811   8.560  33.910  1.00 25.85           C  
ATOM   1855  O   ALA B  89      14.655   8.387  34.793  1.00 27.75           O  
ATOM   1856  CB  ALA B  89      14.639   9.456  31.745  1.00 27.39           C  
ATOM   1857  N   ILE B  90      12.603   9.042  34.151  1.00 25.93           N  
ATOM   1858  CA  ILE B  90      12.176   9.393  35.491  1.00 24.89           C  
ATOM   1859  C   ILE B  90      11.987   8.134  36.313  1.00 27.33           C  
ATOM   1860  O   ILE B  90      12.395   8.068  37.473  1.00 27.76           O  
ATOM   1861  CB  ILE B  90      10.871  10.195  35.430  1.00 23.66           C  
ATOM   1862  CG1 ILE B  90      11.197  11.634  35.027  1.00 22.14           C  
ATOM   1863  CG2 ILE B  90      10.137  10.119  36.748  1.00 22.24           C  
ATOM   1864  CD1 ILE B  90      10.020  12.413  34.545  1.00 25.90           C  
ATOM   1865  N   TYR B  91      11.381   7.121  35.709  1.00 29.17           N  
ATOM   1866  CA  TYR B  91      11.168   5.883  36.432  1.00 31.20           C  
ATOM   1867  C   TYR B  91      12.458   5.131  36.713  1.00 32.31           C  
ATOM   1868  O   TYR B  91      12.495   4.280  37.596  1.00 33.67           O  
ATOM   1869  CB  TYR B  91      10.166   4.995  35.699  1.00 31.39           C  
ATOM   1870  CG  TYR B  91       8.756   5.367  36.066  1.00 33.96           C  
ATOM   1871  CD1 TYR B  91       8.185   6.550  35.590  1.00 33.10           C  
ATOM   1872  CD2 TYR B  91       8.026   4.598  36.980  1.00 34.25           C  
ATOM   1873  CE1 TYR B  91       6.926   6.968  36.018  1.00 35.20           C  
ATOM   1874  CE2 TYR B  91       6.759   5.006  37.419  1.00 35.68           C  
ATOM   1875  CZ  TYR B  91       6.213   6.192  36.937  1.00 37.29           C  
ATOM   1876  OH  TYR B  91       4.964   6.610  37.370  1.00 39.04           O  
ATOM   1877  N   TRP B  92      13.518   5.449  35.974  1.00 31.97           N  
ATOM   1878  CA  TRP B  92      14.810   4.808  36.193  1.00 30.87           C  
ATOM   1879  C   TRP B  92      15.608   5.679  37.167  1.00 30.17           C  
ATOM   1880  O   TRP B  92      16.375   5.175  37.979  1.00 29.11           O  
ATOM   1881  CB  TRP B  92      15.587   4.676  34.882  1.00 31.95           C  
ATOM   1882  CG  TRP B  92      15.010   3.727  33.848  1.00 32.98           C  
ATOM   1883  CD1 TRP B  92      14.813   3.997  32.524  1.00 32.47           C  
ATOM   1884  CD2 TRP B  92      14.674   2.340  34.019  1.00 33.58           C  
ATOM   1885  NE1 TRP B  92      14.388   2.874  31.861  1.00 33.35           N  
ATOM   1886  CE2 TRP B  92      14.292   1.840  32.754  1.00 33.63           C  
ATOM   1887  CE3 TRP B  92      14.663   1.472  35.119  1.00 35.59           C  
ATOM   1888  CZ2 TRP B  92      13.901   0.509  32.551  1.00 34.94           C  
ATOM   1889  CZ3 TRP B  92      14.272   0.139  34.916  1.00 36.83           C  
ATOM   1890  CH2 TRP B  92      13.897  -0.324  33.641  1.00 36.32           C  
ATOM   1891  N   ALA B  93      15.428   6.994  37.078  1.00 30.36           N  
ATOM   1892  CA  ALA B  93      16.127   7.924  37.967  1.00 30.90           C  
ATOM   1893  C   ALA B  93      15.511   7.836  39.358  1.00 31.42           C  
ATOM   1894  O   ALA B  93      16.191   7.998  40.366  1.00 30.16           O  
ATOM   1895  CB  ALA B  93      16.025   9.348  37.425  1.00 30.28           C  
ATOM   1896  N   ARG B  94      14.203   7.605  39.394  1.00 33.49           N  
ATOM   1897  CA  ARG B  94      13.465   7.421  40.639  1.00 35.36           C  
ATOM   1898  C   ARG B  94      13.443   8.557  41.677  1.00 34.43           C  
ATOM   1899  O   ARG B  94      13.836   8.358  42.823  1.00 35.36           O  
ATOM   1900  CB  ARG B  94      13.969   6.136  41.301  1.00 37.91           C  
ATOM   1901  CG  ARG B  94      12.880   5.253  41.865  1.00 44.91           C  
ATOM   1902  CD  ARG B  94      13.477   3.983  42.441  1.00 49.82           C  
ATOM   1903  NE  ARG B  94      14.300   3.286  41.450  1.00 55.62           N  
ATOM   1904  CZ  ARG B  94      13.836   2.761  40.314  1.00 58.11           C  
ATOM   1905  NH1 ARG B  94      14.668   2.147  39.475  1.00 56.24           N  
ATOM   1906  NH2 ARG B  94      12.538   2.844  40.018  1.00 58.81           N  
ATOM   1907  N   PRO B  95      12.970   9.756  41.294  1.00 33.12           N  
ATOM   1908  CA  PRO B  95      12.911  10.881  42.238  1.00 32.41           C  
ATOM   1909  C   PRO B  95      11.684  10.805  43.163  1.00 32.25           C  
ATOM   1910  O   PRO B  95      10.755  10.038  42.908  1.00 32.08           O  
ATOM   1911  CB  PRO B  95      12.849  12.088  41.316  1.00 30.66           C  
ATOM   1912  CG  PRO B  95      12.021  11.571  40.197  1.00 31.85           C  
ATOM   1913  CD  PRO B  95      12.608  10.198  39.937  1.00 31.82           C  
ATOM   1914  N   LYS B  96      11.695  11.597  44.235  1.00 32.75           N  
ATOM   1915  CA  LYS B  96      10.589  11.642  45.201  1.00 32.30           C  
ATOM   1916  C   LYS B  96       9.280  11.900  44.480  1.00 31.40           C  
ATOM   1917  O   LYS B  96       8.313  11.160  44.632  1.00 32.75           O  
ATOM   1918  CB  LYS B  96      10.739  12.801  46.180  1.00 33.61           C  
ATOM   1919  CG  LYS B  96      11.595  12.620  47.400  1.00 34.21           C  
ATOM   1920  CD  LYS B  96      11.481  13.928  48.196  1.00 34.71           C  
ATOM   1921  CE  LYS B  96      12.476  14.042  49.337  1.00 38.35           C  
ATOM   1922  NZ  LYS B  96      12.305  12.998  50.394  1.00 41.44           N  
ATOM   1923  N   ALA B  97       9.261  12.995  43.724  1.00 29.52           N  
ATOM   1924  CA  ALA B  97       8.081  13.413  42.987  1.00 29.40           C  
ATOM   1925  C   ALA B  97       8.449  14.302  41.802  1.00 29.54           C  
ATOM   1926  O   ALA B  97       9.628  14.574  41.552  1.00 29.44           O  
ATOM   1927  CB  ALA B  97       7.144  14.172  43.926  1.00 28.89           C  
ATOM   1928  N   VAL B  98       7.435  14.755  41.070  1.00 29.20           N  
ATOM   1929  CA  VAL B  98       7.665  15.638  39.936  1.00 29.65           C  
ATOM   1930  C   VAL B  98       6.502  16.611  39.726  1.00 31.97           C  
ATOM   1931  O   VAL B  98       5.331  16.230  39.780  1.00 31.14           O  
ATOM   1932  CB  VAL B  98       7.974  14.837  38.617  1.00 27.22           C  
ATOM   1933  CG1 VAL B  98       7.612  13.394  38.764  1.00 26.00           C  
ATOM   1934  CG2 VAL B  98       7.230  15.439  37.444  1.00 27.69           C  
ATOM   1935  N   PHE B  99       6.849  17.880  39.507  1.00 33.72           N  
ATOM   1936  CA  PHE B  99       5.862  18.933  39.283  1.00 35.21           C  
ATOM   1937  C   PHE B  99       5.965  19.452  37.856  1.00 37.05           C  
ATOM   1938  O   PHE B  99       7.030  19.386  37.244  1.00 37.83           O  
ATOM   1939  CB  PHE B  99       6.090  20.102  40.242  1.00 32.84           C  
ATOM   1940  CG  PHE B  99       5.948  19.742  41.693  1.00 32.71           C  
ATOM   1941  CD1 PHE B  99       6.875  18.910  42.315  1.00 32.80           C  
ATOM   1942  CD2 PHE B  99       4.880  20.229  42.442  1.00 31.43           C  
ATOM   1943  CE1 PHE B  99       6.738  18.566  43.665  1.00 31.70           C  
ATOM   1944  CE2 PHE B  99       4.735  19.890  43.786  1.00 30.23           C  
ATOM   1945  CZ  PHE B  99       5.664  19.060  44.397  1.00 29.87           C  
ATOM   1946  N   TYR B 100       4.860  19.966  37.325  1.00 38.70           N  
ATOM   1947  CA  TYR B 100       4.867  20.515  35.975  1.00 41.38           C  
ATOM   1948  C   TYR B 100       3.741  21.516  35.766  1.00 43.24           C  
ATOM   1949  O   TYR B 100       2.676  21.397  36.369  1.00 44.65           O  
ATOM   1950  CB  TYR B 100       4.774  19.396  34.938  1.00 40.71           C  
ATOM   1951  CG  TYR B 100       3.514  18.577  35.022  1.00 42.79           C  
ATOM   1952  CD1 TYR B 100       2.423  18.848  34.195  1.00 42.39           C  
ATOM   1953  CD2 TYR B 100       3.411  17.526  35.929  1.00 42.88           C  
ATOM   1954  CE1 TYR B 100       1.261  18.089  34.269  1.00 42.86           C  
ATOM   1955  CE2 TYR B 100       2.258  16.762  36.013  1.00 43.61           C  
ATOM   1956  CZ  TYR B 100       1.184  17.045  35.183  1.00 44.53           C  
ATOM   1957  OH  TYR B 100       0.046  16.271  35.274  1.00 44.37           O  
ATOM   1958  N   ALA B 101       3.991  22.511  34.922  1.00 44.87           N  
ATOM   1959  CA  ALA B 101       2.998  23.535  34.633  1.00 47.10           C  
ATOM   1960  C   ALA B 101       2.227  23.145  33.375  1.00 49.42           C  
ATOM   1961  O   ALA B 101       1.100  22.655  33.457  1.00 50.38           O  
ATOM   1962  CB  ALA B 101       3.679  24.881  34.440  1.00 45.72           C  
ATOM   1963  N   ALA B 102       2.840  23.352  32.215  1.00 50.52           N  
ATOM   1964  CA  ALA B 102       2.204  23.013  30.949  1.00 53.52           C  
ATOM   1965  C   ALA B 102       1.886  21.523  30.886  1.00 55.62           C  
ATOM   1966  O   ALA B 102       2.576  20.701  31.487  1.00 55.32           O  
ATOM   1967  CB  ALA B 102       3.106  23.404  29.790  1.00 53.54           C  
ATOM   1968  N   GLU B 103       0.837  21.181  30.147  1.00 58.65           N  
ATOM   1969  CA  GLU B 103       0.418  19.794  30.014  1.00 61.32           C  
ATOM   1970  C   GLU B 103       0.748  19.320  28.606  1.00 63.40           C  
ATOM   1971  O   GLU B 103       1.129  20.124  27.757  1.00 62.99           O  
ATOM   1972  CB  GLU B 103      -1.084  19.688  30.286  1.00 61.91           C  
ATOM   1973  CG  GLU B 103      -1.573  20.679  31.344  1.00 63.47           C  
ATOM   1974  CD  GLU B 103      -2.781  20.185  32.121  1.00 64.63           C  
ATOM   1975  OE1 GLU B 103      -2.619  19.254  32.943  1.00 65.01           O  
ATOM   1976  OE2 GLU B 103      -3.890  20.725  31.909  1.00 65.37           O  
ATOM   1977  N   HIS B 104       0.610  18.022  28.355  1.00 66.72           N  
ATOM   1978  CA  HIS B 104       0.923  17.473  27.035  1.00 70.01           C  
ATOM   1979  C   HIS B 104       0.078  18.114  25.928  1.00 71.80           C  
ATOM   1980  O   HIS B 104       0.413  18.015  24.743  1.00 72.38           O  
ATOM   1981  CB  HIS B 104       0.727  15.953  27.032  1.00 70.83           C  
ATOM   1982  CG  HIS B 104      -0.707  15.525  26.987  1.00 73.23           C  
ATOM   1983  ND1 HIS B 104      -1.488  15.645  25.860  1.00 74.07           N  
ATOM   1984  CD2 HIS B 104      -1.505  14.977  27.941  1.00 73.95           C  
ATOM   1985  CE1 HIS B 104      -2.703  15.191  26.114  1.00 74.34           C  
ATOM   1986  NE2 HIS B 104      -2.737  14.780  27.372  1.00 73.75           N  
ATOM   1987  N   THR B 105      -1.013  18.771  26.320  1.00 72.71           N  
ATOM   1988  CA  THR B 105      -1.895  19.432  25.363  1.00 73.08           C  
ATOM   1989  C   THR B 105      -1.301  20.764  24.905  1.00 73.92           C  
ATOM   1990  O   THR B 105      -1.232  21.044  23.705  1.00 74.39           O  
ATOM   1991  CB  THR B 105      -3.288  19.693  25.974  1.00 72.90           C  
ATOM   1992  OG1 THR B 105      -3.169  20.577  27.096  1.00 72.67           O  
ATOM   1993  CG2 THR B 105      -3.920  18.385  26.431  1.00 73.17           C  
ATOM   1994  N   ASP B 106      -0.869  21.578  25.864  1.00 73.93           N  
ATOM   1995  CA  ASP B 106      -0.286  22.882  25.563  1.00 74.25           C  
ATOM   1996  C   ASP B 106       0.890  22.777  24.589  1.00 74.45           C  
ATOM   1997  O   ASP B 106       1.002  23.570  23.653  1.00 74.64           O  
ATOM   1998  CB  ASP B 106       0.171  23.571  26.857  1.00 74.69           C  
ATOM   1999  CG  ASP B 106      -0.985  23.867  27.808  1.00 75.36           C  
ATOM   2000  OD1 ASP B 106      -1.980  24.479  27.365  1.00 75.83           O  
ATOM   2001  OD2 ASP B 106      -0.896  23.501  29.001  1.00 74.77           O  
ATOM   2002  N   ALA B 107       1.761  21.794  24.807  1.00 74.46           N  
ATOM   2003  CA  ALA B 107       2.930  21.598  23.951  1.00 74.73           C  
ATOM   2004  C   ALA B 107       2.551  21.104  22.561  1.00 75.04           C  
ATOM   2005  O   ALA B 107       3.226  21.415  21.577  1.00 74.42           O  
ATOM   2006  CB  ALA B 107       3.900  20.617  24.601  1.00 74.46           C  
ATOM   2007  N   ALA B 108       1.478  20.325  22.486  1.00 76.01           N  
ATOM   2008  CA  ALA B 108       1.007  19.793  21.210  1.00 76.22           C  
ATOM   2009  C   ALA B 108       0.539  20.932  20.312  1.00 76.38           C  
ATOM   2010  O   ALA B 108       0.628  20.842  19.088  1.00 76.68           O  
ATOM   2011  CB  ALA B 108      -0.128  18.808  21.443  1.00 76.04           C  
ATOM   2012  N   GLU B 109       0.042  22.005  20.925  1.00 76.41           N  
ATOM   2013  CA  GLU B 109      -0.435  23.166  20.176  1.00 76.02           C  
ATOM   2014  C   GLU B 109       0.702  24.141  19.883  1.00 74.79           C  
ATOM   2015  O   GLU B 109       0.498  25.354  19.851  1.00 74.94           O  
ATOM   2016  CB  GLU B 109      -1.533  23.890  20.959  1.00 76.98           C  
ATOM   2017  CG  GLU B 109      -2.681  22.993  21.388  1.00 78.79           C  
ATOM   2018  CD  GLU B 109      -3.898  23.781  21.826  1.00 80.07           C  
ATOM   2019  OE1 GLU B 109      -4.483  24.493  20.981  1.00 80.98           O  
ATOM   2020  OE2 GLU B 109      -4.274  23.688  23.015  1.00 81.14           O  
ATOM   2021  N   ALA B 110       1.898  23.600  19.672  1.00 73.13           N  
ATOM   2022  CA  ALA B 110       3.074  24.410  19.390  1.00 71.51           C  
ATOM   2023  C   ALA B 110       3.998  23.641  18.464  1.00 71.09           C  
ATOM   2024  O   ALA B 110       5.152  24.026  18.262  1.00 70.87           O  
ATOM   2025  CB  ALA B 110       3.794  24.746  20.679  1.00 71.63           C  
ATOM   2026  N   GLY B 111       3.483  22.552  17.904  1.00 70.49           N  
ATOM   2027  CA  GLY B 111       4.275  21.737  17.003  1.00 69.99           C  
ATOM   2028  C   GLY B 111       4.986  20.627  17.745  1.00 69.60           C  
ATOM   2029  O   GLY B 111       5.701  19.823  17.150  1.00 69.14           O  
ATOM   2030  N   PHE B 112       4.789  20.585  19.058  1.00 70.12           N  
ATOM   2031  CA  PHE B 112       5.416  19.565  19.890  1.00 70.60           C  
ATOM   2032  C   PHE B 112       4.377  18.598  20.457  1.00 70.20           C  
ATOM   2033  O   PHE B 112       3.808  18.823  21.531  1.00 70.01           O  
ATOM   2034  CB  PHE B 112       6.204  20.214  21.035  1.00 70.56           C  
ATOM   2035  CG  PHE B 112       7.299  21.138  20.576  1.00 70.58           C  
ATOM   2036  CD1 PHE B 112       7.047  22.492  20.365  1.00 69.96           C  
ATOM   2037  CD2 PHE B 112       8.591  20.656  20.365  1.00 71.41           C  
ATOM   2038  CE1 PHE B 112       8.065  23.354  19.953  1.00 69.96           C  
ATOM   2039  CE2 PHE B 112       9.618  21.510  19.952  1.00 70.56           C  
ATOM   2040  CZ  PHE B 112       9.352  22.860  19.748  1.00 70.35           C  
ATOM   2041  N   ASP B 113       4.142  17.520  19.718  1.00 69.57           N  
ATOM   2042  CA  ASP B 113       3.184  16.497  20.108  1.00 68.46           C  
ATOM   2043  C   ASP B 113       3.898  15.155  20.265  1.00 67.49           C  
ATOM   2044  O   ASP B 113       4.520  14.653  19.327  1.00 66.97           O  
ATOM   2045  CB  ASP B 113       2.093  16.381  19.048  1.00 69.03           C  
ATOM   2046  CG  ASP B 113       1.013  15.407  19.442  1.00 69.13           C  
ATOM   2047  OD1 ASP B 113       0.199  15.041  18.567  1.00 69.06           O  
ATOM   2048  OD2 ASP B 113       0.983  15.016  20.630  1.00 68.89           O  
ATOM   2049  N   ASP B 114       3.796  14.578  21.455  1.00 66.26           N  
ATOM   2050  CA  ASP B 114       4.450  13.312  21.758  1.00 65.28           C  
ATOM   2051  C   ASP B 114       3.485  12.143  21.810  1.00 63.26           C  
ATOM   2052  O   ASP B 114       3.895  10.982  21.889  1.00 63.47           O  
ATOM   2053  CB  ASP B 114       5.179  13.421  23.102  1.00 67.49           C  
ATOM   2054  CG  ASP B 114       4.307  14.032  24.202  1.00 69.10           C  
ATOM   2055  OD1 ASP B 114       3.218  13.484  24.486  1.00 69.47           O  
ATOM   2056  OD2 ASP B 114       4.717  15.062  24.782  1.00 70.31           O  
ATOM   2057  N   SER B 115       2.199  12.455  21.763  1.00 60.97           N  
ATOM   2058  CA  SER B 115       1.169  11.436  21.834  1.00 58.72           C  
ATOM   2059  C   SER B 115       1.375  10.286  20.854  1.00 56.55           C  
ATOM   2060  O   SER B 115       0.998   9.152  21.141  1.00 55.96           O  
ATOM   2061  CB  SER B 115      -0.201  12.075  21.614  1.00 59.84           C  
ATOM   2062  OG  SER B 115      -0.267  12.716  20.356  1.00 61.81           O  
ATOM   2063  N   PHE B 116       1.975  10.556  19.702  1.00 54.22           N  
ATOM   2064  CA  PHE B 116       2.174   9.470  18.758  1.00 52.20           C  
ATOM   2065  C   PHE B 116       3.124   8.443  19.352  1.00 50.01           C  
ATOM   2066  O   PHE B 116       3.018   7.254  19.070  1.00 49.83           O  
ATOM   2067  CB  PHE B 116       2.697   9.993  17.418  1.00 52.71           C  
ATOM   2068  CG  PHE B 116       4.116  10.470  17.452  1.00 54.22           C  
ATOM   2069  CD1 PHE B 116       5.099   9.799  16.723  1.00 53.84           C  
ATOM   2070  CD2 PHE B 116       4.474  11.617  18.166  1.00 55.10           C  
ATOM   2071  CE1 PHE B 116       6.418  10.259  16.700  1.00 54.51           C  
ATOM   2072  CE2 PHE B 116       5.796  12.088  18.151  1.00 54.81           C  
ATOM   2073  CZ  PHE B 116       6.766  11.408  17.413  1.00 54.71           C  
ATOM   2074  N   ILE B 117       4.040   8.908  20.195  1.00 47.31           N  
ATOM   2075  CA  ILE B 117       4.990   8.017  20.838  1.00 45.70           C  
ATOM   2076  C   ILE B 117       4.274   7.215  21.924  1.00 45.87           C  
ATOM   2077  O   ILE B 117       4.576   6.038  22.142  1.00 45.29           O  
ATOM   2078  CB  ILE B 117       6.167   8.806  21.445  1.00 44.37           C  
ATOM   2079  CG1 ILE B 117       6.832   9.647  20.354  1.00 42.44           C  
ATOM   2080  CG2 ILE B 117       7.193   7.856  22.019  1.00 40.25           C  
ATOM   2081  CD1 ILE B 117       7.977  10.484  20.846  1.00 41.72           C  
ATOM   2082  N   TYR B 118       3.323   7.848  22.608  1.00 45.81           N  
ATOM   2083  CA  TYR B 118       2.562   7.143  23.635  1.00 45.86           C  
ATOM   2084  C   TYR B 118       1.865   5.962  22.981  1.00 45.61           C  
ATOM   2085  O   TYR B 118       1.963   4.824  23.447  1.00 45.36           O  
ATOM   2086  CB  TYR B 118       1.497   8.044  24.240  1.00 46.71           C  
ATOM   2087  CG  TYR B 118       1.988   8.857  25.400  1.00 50.41           C  
ATOM   2088  CD1 TYR B 118       2.536  10.123  25.206  1.00 51.05           C  
ATOM   2089  CD2 TYR B 118       1.922   8.356  26.697  1.00 50.81           C  
ATOM   2090  CE1 TYR B 118       3.005  10.875  26.281  1.00 52.19           C  
ATOM   2091  CE2 TYR B 118       2.388   9.094  27.777  1.00 52.73           C  
ATOM   2092  CZ  TYR B 118       2.927  10.353  27.564  1.00 53.30           C  
ATOM   2093  OH  TYR B 118       3.383  11.090  28.630  1.00 55.50           O  
ATOM   2094  N   LYS B 119       1.159   6.257  21.894  1.00 44.83           N  
ATOM   2095  CA  LYS B 119       0.429   5.248  21.149  1.00 43.91           C  
ATOM   2096  C   LYS B 119       1.370   4.135  20.742  1.00 43.88           C  
ATOM   2097  O   LYS B 119       1.093   2.959  20.966  1.00 44.42           O  
ATOM   2098  CB  LYS B 119      -0.187   5.855  19.890  1.00 44.53           C  
ATOM   2099  CG  LYS B 119      -1.104   7.046  20.113  1.00 45.52           C  
ATOM   2100  CD  LYS B 119      -1.664   7.543  18.780  1.00 47.73           C  
ATOM   2101  CE  LYS B 119      -2.465   8.836  18.914  1.00 48.58           C  
ATOM   2102  NZ  LYS B 119      -3.780   8.657  19.597  1.00 51.04           N  
ATOM   2103  N   GLU B 120       2.490   4.518  20.141  1.00 43.62           N  
ATOM   2104  CA  GLU B 120       3.471   3.554  19.668  1.00 43.34           C  
ATOM   2105  C   GLU B 120       3.999   2.654  20.766  1.00 43.52           C  
ATOM   2106  O   GLU B 120       4.109   1.444  20.581  1.00 43.59           O  
ATOM   2107  CB  GLU B 120       4.631   4.282  18.994  1.00 43.76           C  
ATOM   2108  CG  GLU B 120       4.240   5.018  17.715  1.00 43.52           C  
ATOM   2109  CD  GLU B 120       3.629   4.098  16.677  1.00 43.95           C  
ATOM   2110  OE1 GLU B 120       4.258   3.067  16.351  1.00 43.26           O  
ATOM   2111  OE2 GLU B 120       2.521   4.412  16.184  1.00 45.00           O  
ATOM   2112  N   ILE B 121       4.327   3.249  21.907  1.00 43.77           N  
ATOM   2113  CA  ILE B 121       4.849   2.491  23.029  1.00 44.91           C  
ATOM   2114  C   ILE B 121       3.859   1.417  23.462  1.00 47.28           C  
ATOM   2115  O   ILE B 121       4.258   0.317  23.852  1.00 48.42           O  
ATOM   2116  CB  ILE B 121       5.174   3.429  24.219  1.00 43.88           C  
ATOM   2117  CG1 ILE B 121       6.336   4.341  23.838  1.00 42.48           C  
ATOM   2118  CG2 ILE B 121       5.524   2.617  25.464  1.00 41.56           C  
ATOM   2119  CD1 ILE B 121       6.740   5.303  24.923  1.00 41.56           C  
ATOM   2120  N   ASP B 122       2.569   1.730  23.384  1.00 49.28           N  
ATOM   2121  CA  ASP B 122       1.532   0.778  23.773  1.00 51.13           C  
ATOM   2122  C   ASP B 122       1.410  -0.376  22.765  1.00 51.89           C  
ATOM   2123  O   ASP B 122       1.361  -1.543  23.159  1.00 53.66           O  
ATOM   2124  CB  ASP B 122       0.184   1.491  23.913  1.00 52.02           C  
ATOM   2125  CG  ASP B 122      -0.800   0.719  24.787  1.00 53.07           C  
ATOM   2126  OD1 ASP B 122      -0.541   0.585  26.003  1.00 52.95           O  
ATOM   2127  OD2 ASP B 122      -1.826   0.245  24.255  1.00 53.42           O  
ATOM   2128  N   LYS B 123       1.367  -0.048  21.474  1.00 51.78           N  
ATOM   2129  CA  LYS B 123       1.254  -1.048  20.415  1.00 51.39           C  
ATOM   2130  C   LYS B 123       2.416  -2.028  20.479  1.00 51.32           C  
ATOM   2131  O   LYS B 123       3.526  -1.655  20.844  1.00 50.60           O  
ATOM   2132  CB  LYS B 123       1.287  -0.388  19.033  1.00 52.21           C  
ATOM   2133  CG  LYS B 123       0.284   0.723  18.804  1.00 53.20           C  
ATOM   2134  CD  LYS B 123       0.704   1.569  17.610  1.00 54.53           C  
ATOM   2135  CE  LYS B 123      -0.276   2.705  17.330  1.00 55.67           C  
ATOM   2136  NZ  LYS B 123      -1.501   2.233  16.616  1.00 56.75           N  
ATOM   2137  N   PRO B 124       2.175  -3.300  20.126  1.00 52.07           N  
ATOM   2138  CA  PRO B 124       3.274  -4.266  20.164  1.00 52.25           C  
ATOM   2139  C   PRO B 124       4.206  -3.945  19.000  1.00 52.63           C  
ATOM   2140  O   PRO B 124       3.799  -3.295  18.033  1.00 51.89           O  
ATOM   2141  CB  PRO B 124       2.564  -5.608  20.015  1.00 51.92           C  
ATOM   2142  CG  PRO B 124       1.412  -5.270  19.143  1.00 52.35           C  
ATOM   2143  CD  PRO B 124       0.921  -3.948  19.709  1.00 51.64           C  
ATOM   2144  N   ALA B 125       5.450  -4.396  19.107  1.00 54.22           N  
ATOM   2145  CA  ALA B 125       6.485  -4.141  18.110  1.00 55.88           C  
ATOM   2146  C   ALA B 125       6.066  -4.185  16.640  1.00 57.06           C  
ATOM   2147  O   ALA B 125       6.418  -3.295  15.868  1.00 57.29           O  
ATOM   2148  CB  ALA B 125       7.649  -5.096  18.343  1.00 56.66           C  
ATOM   2149  N   GLU B 126       5.311  -5.211  16.259  1.00 58.84           N  
ATOM   2150  CA  GLU B 126       4.873  -5.380  14.877  1.00 60.08           C  
ATOM   2151  C   GLU B 126       4.102  -4.217  14.277  1.00 60.77           C  
ATOM   2152  O   GLU B 126       4.337  -3.846  13.127  1.00 61.54           O  
ATOM   2153  CB  GLU B 126       3.999  -6.623  14.746  1.00 61.85           C  
ATOM   2154  CG  GLU B 126       4.587  -7.885  15.329  1.00 64.77           C  
ATOM   2155  CD  GLU B 126       3.740  -9.106  15.015  1.00 66.22           C  
ATOM   2156  OE1 GLU B 126       4.062 -10.202  15.525  1.00 67.53           O  
ATOM   2157  OE2 GLU B 126       2.752  -8.963  14.256  1.00 65.96           O  
ATOM   2158  N   GLU B 127       3.171  -3.659  15.048  1.00 60.70           N  
ATOM   2159  CA  GLU B 127       2.315  -2.563  14.586  1.00 60.03           C  
ATOM   2160  C   GLU B 127       2.946  -1.176  14.516  1.00 58.43           C  
ATOM   2161  O   GLU B 127       2.485  -0.313  13.761  1.00 58.47           O  
ATOM   2162  CB  GLU B 127       1.065  -2.491  15.468  1.00 62.65           C  
ATOM   2163  CG  GLU B 127       0.182  -3.730  15.407  1.00 66.23           C  
ATOM   2164  CD  GLU B 127      -0.926  -3.707  16.449  1.00 68.36           C  
ATOM   2165  OE1 GLU B 127      -1.691  -2.715  16.488  1.00 68.81           O  
ATOM   2166  OE2 GLU B 127      -1.030  -4.686  17.226  1.00 68.47           O  
ATOM   2167  N   ARG B 128       3.993  -0.962  15.307  1.00 56.14           N  
ATOM   2168  CA  ARG B 128       4.673   0.328  15.361  1.00 52.78           C  
ATOM   2169  C   ARG B 128       5.036   0.914  14.003  1.00 50.52           C  
ATOM   2170  O   ARG B 128       5.390   0.195  13.074  1.00 49.54           O  
ATOM   2171  CB  ARG B 128       5.930   0.206  16.223  1.00 52.69           C  
ATOM   2172  CG  ARG B 128       5.621   0.029  17.692  1.00 50.96           C  
ATOM   2173  CD  ARG B 128       6.809  -0.500  18.473  1.00 49.53           C  
ATOM   2174  NE  ARG B 128       6.508  -0.489  19.898  1.00 47.62           N  
ATOM   2175  CZ  ARG B 128       7.179  -1.175  20.814  1.00 47.56           C  
ATOM   2176  NH1 ARG B 128       6.820  -1.091  22.087  1.00 47.99           N  
ATOM   2177  NH2 ARG B 128       8.196  -1.951  20.459  1.00 47.09           N  
ATOM   2178  N   THR B 129       4.933   2.233  13.902  1.00 48.12           N  
ATOM   2179  CA  THR B 129       5.269   2.936  12.677  1.00 45.87           C  
ATOM   2180  C   THR B 129       6.676   2.532  12.266  1.00 44.21           C  
ATOM   2181  O   THR B 129       6.876   1.908  11.224  1.00 45.50           O  
ATOM   2182  CB  THR B 129       5.219   4.438  12.898  1.00 46.16           C  
ATOM   2183  OG1 THR B 129       3.874   4.809  13.215  1.00 47.38           O  
ATOM   2184  CG2 THR B 129       5.675   5.177  11.654  1.00 47.46           C  
ATOM   2185  N   ILE B 130       7.657   2.886  13.086  1.00 40.58           N  
ATOM   2186  CA  ILE B 130       9.030   2.512  12.792  1.00 36.85           C  
ATOM   2187  C   ILE B 130       9.106   0.975  12.780  1.00 34.95           C  
ATOM   2188  O   ILE B 130       8.612   0.311  13.692  1.00 34.58           O  
ATOM   2189  CB  ILE B 130      10.007   3.095  13.860  1.00 35.58           C  
ATOM   2190  CG1 ILE B 130      10.029   4.624  13.757  1.00 33.81           C  
ATOM   2191  CG2 ILE B 130      11.400   2.508  13.679  1.00 32.74           C  
ATOM   2192  CD1 ILE B 130      10.826   5.318  14.833  1.00 32.46           C  
ATOM   2193  N   PRO B 131       9.708   0.399  11.729  1.00 33.27           N  
ATOM   2194  CA  PRO B 131       9.888  -1.044  11.524  1.00 32.49           C  
ATOM   2195  C   PRO B 131      10.707  -1.721  12.628  1.00 33.16           C  
ATOM   2196  O   PRO B 131      11.804  -1.270  12.957  1.00 32.71           O  
ATOM   2197  CB  PRO B 131      10.626  -1.118  10.190  1.00 31.37           C  
ATOM   2198  CG  PRO B 131      10.219   0.113   9.491  1.00 31.87           C  
ATOM   2199  CD  PRO B 131      10.209   1.156  10.570  1.00 32.22           C  
ATOM   2200  N   PHE B 132      10.176  -2.813  13.171  1.00 34.35           N  
ATOM   2201  CA  PHE B 132      10.838  -3.588  14.223  1.00 35.63           C  
ATOM   2202  C   PHE B 132      10.871  -5.053  13.812  1.00 38.18           C  
ATOM   2203  O   PHE B 132       9.871  -5.593  13.340  1.00 39.50           O  
ATOM   2204  CB  PHE B 132      10.079  -3.473  15.547  1.00 33.64           C  
ATOM   2205  CG  PHE B 132      10.432  -2.257  16.359  1.00 33.37           C  
ATOM   2206  CD1 PHE B 132      10.155  -0.975  15.889  1.00 33.00           C  
ATOM   2207  CD2 PHE B 132      11.014  -2.394  17.616  1.00 32.03           C  
ATOM   2208  CE1 PHE B 132      10.456   0.156  16.663  1.00 32.83           C  
ATOM   2209  CE2 PHE B 132      11.317  -1.270  18.396  1.00 32.37           C  
ATOM   2210  CZ  PHE B 132      11.035   0.008  17.916  1.00 30.40           C  
ATOM   2211  N   TYR B 133      12.011  -5.702  14.002  1.00 40.15           N  
ATOM   2212  CA  TYR B 133      12.143  -7.101  13.634  1.00 42.16           C  
ATOM   2213  C   TYR B 133      12.748  -7.882  14.782  1.00 44.83           C  
ATOM   2214  O   TYR B 133      13.704  -7.429  15.415  1.00 44.74           O  
ATOM   2215  CB  TYR B 133      13.041  -7.238  12.414  1.00 41.43           C  
ATOM   2216  CG  TYR B 133      12.559  -6.471  11.207  1.00 41.48           C  
ATOM   2217  CD1 TYR B 133      11.680  -7.047  10.290  1.00 40.08           C  
ATOM   2218  CD2 TYR B 133      12.988  -5.164  10.977  1.00 41.64           C  
ATOM   2219  CE1 TYR B 133      11.244  -6.339   9.169  1.00 39.45           C  
ATOM   2220  CE2 TYR B 133      12.560  -4.444   9.859  1.00 40.59           C  
ATOM   2221  CZ  TYR B 133      11.688  -5.038   8.956  1.00 40.66           C  
ATOM   2222  OH  TYR B 133      11.283  -4.328   7.844  1.00 40.61           O  
ATOM   2223  N   GLN B 134      12.191  -9.059  15.044  1.00 47.44           N  
ATOM   2224  CA  GLN B 134      12.680  -9.906  16.121  1.00 49.99           C  
ATOM   2225  C   GLN B 134      13.320 -11.170  15.575  1.00 51.44           C  
ATOM   2226  O   GLN B 134      12.692 -12.222  15.511  1.00 52.86           O  
ATOM   2227  CB  GLN B 134      11.536 -10.271  17.076  1.00 50.43           C  
ATOM   2228  CG  GLN B 134      11.987 -10.963  18.361  1.00 51.89           C  
ATOM   2229  CD  GLN B 134      12.275 -12.448  18.186  1.00 53.59           C  
ATOM   2230  OE1 GLN B 134      13.213 -12.985  18.783  1.00 54.76           O  
ATOM   2231  NE2 GLN B 134      11.455 -13.123  17.384  1.00 53.99           N  
ATOM   2232  N   VAL B 135      14.572 -11.070  15.155  1.00 53.19           N  
ATOM   2233  CA  VAL B 135      15.259 -12.245  14.651  1.00 53.67           C  
ATOM   2234  C   VAL B 135      15.613 -13.065  15.878  1.00 55.18           C  
ATOM   2235  O   VAL B 135      15.946 -12.519  16.927  1.00 55.80           O  
ATOM   2236  CB  VAL B 135      16.531 -11.863  13.888  1.00 52.54           C  
ATOM   2237  CG1 VAL B 135      17.273 -13.115  13.455  1.00 51.70           C  
ATOM   2238  CG2 VAL B 135      16.168 -11.015  12.678  1.00 51.99           C  
ATOM   2239  N   THR B 136      15.530 -14.377  15.759  1.00 57.36           N  
ATOM   2240  CA  THR B 136      15.833 -15.234  16.891  1.00 60.12           C  
ATOM   2241  C   THR B 136      17.229 -15.863  16.775  1.00 61.18           C  
ATOM   2242  O   THR B 136      17.583 -16.423  15.734  1.00 61.18           O  
ATOM   2243  CB  THR B 136      14.747 -16.311  17.012  1.00 61.37           C  
ATOM   2244  OG1 THR B 136      15.130 -17.278  17.997  1.00 62.13           O  
ATOM   2245  CG2 THR B 136      14.515 -16.980  15.660  1.00 62.02           C  
ATOM   2246  N   LEU B 137      18.016 -15.750  17.847  1.00 62.28           N  
ATOM   2247  CA  LEU B 137      19.386 -16.279  17.892  1.00 64.15           C  
ATOM   2248  C   LEU B 137      19.548 -17.426  18.887  1.00 65.11           C  
ATOM   2249  O   LEU B 137      18.984 -17.398  19.983  1.00 65.08           O  
ATOM   2250  CB  LEU B 137      20.379 -15.172  18.268  1.00 65.65           C  
ATOM   2251  CG  LEU B 137      20.703 -14.042  17.284  1.00 67.15           C  
ATOM   2252  CD1 LEU B 137      19.429 -13.304  16.899  1.00 67.46           C  
ATOM   2253  CD2 LEU B 137      21.709 -13.076  17.922  1.00 67.72           C  
ATOM   2254  N   THR B 138      20.350 -18.418  18.508  1.00 66.30           N  
ATOM   2255  CA  THR B 138      20.589 -19.588  19.352  1.00 67.67           C  
ATOM   2256  C   THR B 138      21.452 -19.292  20.578  1.00 68.62           C  
ATOM   2257  O   THR B 138      21.976 -20.207  21.219  1.00 68.98           O  
ATOM   2258  CB  THR B 138      21.251 -20.720  18.544  1.00 67.49           C  
ATOM   2259  OG1 THR B 138      22.534 -20.290  18.066  1.00 68.02           O  
ATOM   2260  CG2 THR B 138      20.381 -21.093  17.356  1.00 67.67           C  
ATOM   2261  N   GLU B 139      21.605 -18.010  20.897  1.00 69.09           N  
ATOM   2262  CA  GLU B 139      22.395 -17.598  22.053  1.00 69.53           C  
ATOM   2263  C   GLU B 139      21.908 -16.245  22.549  1.00 68.58           C  
ATOM   2264  O   GLU B 139      22.655 -15.497  23.177  1.00 68.06           O  
ATOM   2265  CB  GLU B 139      23.887 -17.509  21.700  1.00 71.22           C  
ATOM   2266  CG  GLU B 139      24.254 -17.922  20.276  1.00 73.60           C  
ATOM   2267  CD  GLU B 139      23.830 -16.900  19.231  1.00 75.22           C  
ATOM   2268  OE1 GLU B 139      24.084 -17.137  18.027  1.00 75.26           O  
ATOM   2269  OE2 GLU B 139      23.249 -15.859  19.609  1.00 76.79           O  
ATOM   2270  N   HIS B 140      20.646 -15.944  22.272  1.00 67.89           N  
ATOM   2271  CA  HIS B 140      20.058 -14.678  22.673  1.00 67.62           C  
ATOM   2272  C   HIS B 140      19.818 -14.582  24.183  1.00 67.41           C  
ATOM   2273  O   HIS B 140      19.246 -13.605  24.670  1.00 67.98           O  
ATOM   2274  CB  HIS B 140      18.749 -14.455  21.903  1.00 68.11           C  
ATOM   2275  CG  HIS B 140      17.650 -15.400  22.277  1.00 68.73           C  
ATOM   2276  ND1 HIS B 140      17.815 -16.768  22.301  1.00 68.62           N  
ATOM   2277  CD2 HIS B 140      16.364 -15.171  22.640  1.00 69.14           C  
ATOM   2278  CE1 HIS B 140      16.681 -17.341  22.662  1.00 69.03           C  
ATOM   2279  NE2 HIS B 140      15.785 -16.393  22.875  1.00 69.04           N  
ATOM   2280  N   LEU B 141      20.277 -15.583  24.924  1.00 66.48           N  
ATOM   2281  CA  LEU B 141      20.101 -15.598  26.374  1.00 65.85           C  
ATOM   2282  C   LEU B 141      21.424 -15.517  27.121  1.00 64.96           C  
ATOM   2283  O   LEU B 141      21.455 -15.300  28.330  1.00 63.89           O  
ATOM   2284  CB  LEU B 141      19.343 -16.864  26.793  1.00 66.02           C  
ATOM   2285  CG  LEU B 141      17.815 -16.749  26.944  1.00 66.78           C  
ATOM   2286  CD1 LEU B 141      17.203 -15.989  25.770  1.00 66.59           C  
ATOM   2287  CD2 LEU B 141      17.216 -18.145  27.057  1.00 66.19           C  
ATOM   2288  N   SER B 142      22.517 -15.676  26.386  1.00 64.85           N  
ATOM   2289  CA  SER B 142      23.850 -15.636  26.966  1.00 64.99           C  
ATOM   2290  C   SER B 142      24.183 -14.395  27.795  1.00 65.96           C  
ATOM   2291  O   SER B 142      24.925 -14.490  28.775  1.00 66.49           O  
ATOM   2292  CB  SER B 142      24.895 -15.808  25.868  1.00 64.75           C  
ATOM   2293  OG  SER B 142      24.692 -14.874  24.824  1.00 66.03           O  
ATOM   2294  N   PRO B 143      23.667 -13.210  27.413  1.00 66.68           N  
ATOM   2295  CA  PRO B 143      23.996 -12.028  28.223  1.00 67.25           C  
ATOM   2296  C   PRO B 143      23.430 -12.114  29.643  1.00 68.04           C  
ATOM   2297  O   PRO B 143      24.093 -11.752  30.623  1.00 67.84           O  
ATOM   2298  CB  PRO B 143      23.412 -10.871  27.405  1.00 66.23           C  
ATOM   2299  CG  PRO B 143      22.294 -11.510  26.641  1.00 66.24           C  
ATOM   2300  CD  PRO B 143      22.887 -12.831  26.222  1.00 66.28           C  
ATOM   2301  N   PHE B 144      22.203 -12.611  29.744  1.00 68.56           N  
ATOM   2302  CA  PHE B 144      21.541 -12.772  31.027  1.00 68.58           C  
ATOM   2303  C   PHE B 144      22.264 -13.858  31.798  1.00 69.24           C  
ATOM   2304  O   PHE B 144      22.485 -13.732  33.002  1.00 69.50           O  
ATOM   2305  CB  PHE B 144      20.089 -13.161  30.796  1.00 68.32           C  
ATOM   2306  CG  PHE B 144      19.361 -12.207  29.907  1.00 67.77           C  
ATOM   2307  CD1 PHE B 144      19.051 -10.924  30.354  1.00 67.76           C  
ATOM   2308  CD2 PHE B 144      19.047 -12.557  28.599  1.00 68.00           C  
ATOM   2309  CE1 PHE B 144      18.441  -9.999  29.509  1.00 67.49           C  
ATOM   2310  CE2 PHE B 144      18.436 -11.641  27.741  1.00 67.82           C  
ATOM   2311  CZ  PHE B 144      18.134 -10.360  28.200  1.00 67.73           C  
ATOM   2312  N   GLN B 145      22.638 -14.927  31.094  1.00 69.98           N  
ATOM   2313  CA  GLN B 145      23.358 -16.042  31.706  1.00 70.23           C  
ATOM   2314  C   GLN B 145      24.617 -15.501  32.370  1.00 69.85           C  
ATOM   2315  O   GLN B 145      24.863 -15.750  33.550  1.00 69.78           O  
ATOM   2316  CB  GLN B 145      23.752 -17.084  30.649  1.00 70.88           C  
ATOM   2317  CG  GLN B 145      22.592 -17.648  29.822  1.00 72.14           C  
ATOM   2318  CD  GLN B 145      23.037 -18.752  28.865  1.00 73.41           C  
ATOM   2319  OE1 GLN B 145      22.262 -19.224  28.024  1.00 73.57           O  
ATOM   2320  NE2 GLN B 145      24.293 -19.170  28.994  1.00 73.57           N  
ATOM   2321  N   ALA B 146      25.406 -14.756  31.598  1.00 69.23           N  
ATOM   2322  CA  ALA B 146      26.642 -14.156  32.086  1.00 68.88           C  
ATOM   2323  C   ALA B 146      26.358 -13.242  33.272  1.00 69.09           C  
ATOM   2324  O   ALA B 146      27.227 -13.011  34.114  1.00 69.44           O  
ATOM   2325  CB  ALA B 146      27.313 -13.369  30.971  1.00 68.45           C  
ATOM   2326  N   TRP B 147      25.137 -12.720  33.332  1.00 69.15           N  
ATOM   2327  CA  TRP B 147      24.744 -11.838  34.421  1.00 69.80           C  
ATOM   2328  C   TRP B 147      24.448 -12.636  35.692  1.00 71.22           C  
ATOM   2329  O   TRP B 147      24.780 -12.202  36.800  1.00 71.16           O  
ATOM   2330  CB  TRP B 147      23.512 -11.027  34.025  1.00 67.71           C  
ATOM   2331  CG  TRP B 147      23.019 -10.113  35.107  1.00 66.39           C  
ATOM   2332  CD1 TRP B 147      21.842 -10.216  35.797  1.00 66.34           C  
ATOM   2333  CD2 TRP B 147      23.679  -8.945  35.617  1.00 65.29           C  
ATOM   2334  NE1 TRP B 147      21.727  -9.181  36.699  1.00 65.25           N  
ATOM   2335  CE2 TRP B 147      22.841  -8.385  36.608  1.00 64.86           C  
ATOM   2336  CE3 TRP B 147      24.897  -8.311  35.326  1.00 64.15           C  
ATOM   2337  CZ2 TRP B 147      23.182  -7.226  37.315  1.00 63.18           C  
ATOM   2338  CZ3 TRP B 147      25.236  -7.158  36.030  1.00 63.19           C  
ATOM   2339  CH2 TRP B 147      24.378  -6.627  37.010  1.00 62.92           C  
ATOM   2340  N   ARG B 148      23.832 -13.805  35.523  1.00 72.60           N  
ATOM   2341  CA  ARG B 148      23.481 -14.660  36.652  1.00 74.12           C  
ATOM   2342  C   ARG B 148      24.722 -15.063  37.445  1.00 75.07           C  
ATOM   2343  O   ARG B 148      24.624 -15.461  38.607  1.00 75.16           O  
ATOM   2344  CB  ARG B 148      22.750 -15.918  36.163  1.00 74.98           C  
ATOM   2345  CG  ARG B 148      22.000 -16.653  37.270  1.00 76.80           C  
ATOM   2346  CD  ARG B 148      21.443 -18.003  36.819  1.00 78.28           C  
ATOM   2347  NE  ARG B 148      20.789 -18.706  37.927  1.00 79.62           N  
ATOM   2348  CZ  ARG B 148      20.389 -19.977  37.890  1.00 79.76           C  
ATOM   2349  NH1 ARG B 148      20.570 -20.706  36.792  1.00 79.77           N  
ATOM   2350  NH2 ARG B 148      19.806 -20.519  38.954  1.00 78.35           N  
ATOM   2351  N   ASN B 149      25.889 -14.948  36.817  1.00 76.19           N  
ATOM   2352  CA  ASN B 149      27.147 -15.304  37.468  1.00 76.59           C  
ATOM   2353  C   ASN B 149      27.773 -14.103  38.169  1.00 76.76           C  
ATOM   2354  O   ASN B 149      27.892 -14.086  39.393  1.00 77.15           O  
ATOM   2355  CB  ASN B 149      28.144 -15.862  36.444  1.00 77.09           C  
ATOM   2356  CG  ASN B 149      27.568 -17.009  35.630  1.00 78.06           C  
ATOM   2357  OD1 ASN B 149      26.977 -17.941  36.176  1.00 78.17           O  
ATOM   2358  ND2 ASN B 149      27.747 -16.947  34.312  1.00 78.39           N  
ATOM   2359  N   PHE B 150      28.166 -13.107  37.379  1.00 76.60           N  
ATOM   2360  CA  PHE B 150      28.792 -11.891  37.890  1.00 76.84           C  
ATOM   2361  C   PHE B 150      28.292 -11.489  39.275  1.00 77.53           C  
ATOM   2362  O   PHE B 150      29.148 -11.239  40.155  1.00 77.81           O  
ATOM   2363  CB  PHE B 150      28.556 -10.735  36.917  1.00 76.78           C  
ATOM   2364  CG  PHE B 150      29.256  -9.461  37.306  1.00 76.34           C  
ATOM   2365  CD1 PHE B 150      30.637  -9.334  37.151  1.00 75.99           C  
ATOM   2366  CD2 PHE B 150      28.537  -8.389  37.838  1.00 76.06           C  
ATOM   2367  CE1 PHE B 150      31.294  -8.157  37.516  1.00 75.73           C  
ATOM   2368  CE2 PHE B 150      29.182  -7.205  38.209  1.00 76.17           C  
ATOM   2369  CZ  PHE B 150      30.566  -7.090  38.047  1.00 76.48           C  
TER    2370      PHE B 150                                                      
END
MOLECULE T0461.pdb
ATOM      1  N   GLU    16      19.319  11.894  58.181  1.00 47.03           N  
ATOM      2  CA  GLU    16      18.212  11.089  57.593  1.00 47.23           C  
ATOM      4  CB  GLU    16      18.010   9.793  58.377  1.00 47.32           C  
ATOM      7  CG  GLU    16      17.576   8.619  57.509  1.00 48.39           C  
ATOM     10  CD  GLU    16      17.064   7.416  58.327  1.00 50.46           C  
ATOM     11  OE1 GLU    16      16.178   6.689  57.811  1.00 51.91           O  
ATOM     12  OE2 GLU    16      17.526   7.196  59.479  1.00 50.93           O  
ATOM     13  C   GLU    16      16.896  11.864  57.561  1.00 47.09           C  
ATOM     14  O   GLU    16      15.891  11.376  57.001  1.00 48.08           O  
ATOM     18  N   ASN    17      16.888  13.066  58.143  1.00 46.06           N  
ATOM     19  CA  ASN    17      15.679  13.870  58.188  1.00 45.28           C  
ATOM     21  CB  ASN    17      15.631  14.676  59.487  1.00 45.17           C  
ATOM     24  CG  ASN    17      14.246  15.250  59.773  1.00 44.92           C  
ATOM     25  OD1 ASN    17      13.421  15.378  58.885  1.00 45.51           O  
ATOM     26  ND2 ASN    17      13.989  15.591  61.023  1.00 45.12           N  
ATOM     29  C   ASN    17      15.619  14.792  56.990  1.00 44.97           C  
ATOM     30  O   ASN    17      16.071  15.922  57.046  1.00 44.78           O  
ATOM     32  N   LEU    18      15.026  14.320  55.910  1.00 45.02           N  
ATOM     33  CA  LEU    18      14.988  15.101  54.659  1.00 45.41           C  
ATOM     35  CB  LEU    18      14.792  14.167  53.453  1.00 45.35           C  
ATOM     38  CG  LEU    18      15.875  13.083  53.322  1.00 45.26           C  
ATOM     40  CD1 LEU    18      15.492  12.097  52.210  1.00 45.69           C  
ATOM     44  CD2 LEU    18      17.267  13.703  53.084  1.00 42.76           C  
ATOM     48  C   LEU    18      13.920  16.202  54.656  1.00 45.40           C  
ATOM     49  O   LEU    18      12.854  16.047  55.244  1.00 46.03           O  
ATOM     51  N   TYR    19      14.208  17.291  53.954  1.00 45.10           N  
ATOM     52  CA  TYR    19      13.361  18.473  53.903  1.00 44.79           C  
ATOM     54  CB  TYR    19      14.284  19.669  53.829  1.00 45.04           C  
ATOM     57  CG  TYR    19      13.663  21.040  53.814  1.00 45.91           C  
ATOM     58  CD1 TYR    19      13.769  21.878  54.930  1.00 46.50           C  
ATOM     60  CE1 TYR    19      13.223  23.142  54.930  1.00 46.23           C  
ATOM     62  CZ  TYR    19      12.595  23.603  53.806  1.00 45.82           C  
ATOM     63  OH  TYR    19      12.078  24.858  53.838  1.00 47.34           O  
ATOM     65  CE2 TYR    19      12.478  22.813  52.668  1.00 46.79           C  
ATOM     67  CD2 TYR    19      13.017  21.538  52.672  1.00 46.25           C  
ATOM     69  C   TYR    19      12.486  18.434  52.655  1.00 45.02           C  
ATOM     70  O   TYR    19      12.973  18.134  51.545  1.00 44.56           O  
ATOM     72  N   PHE    20      11.200  18.768  52.836  1.00 45.35           N  
ATOM     73  CA  PHE    20      10.180  18.735  51.761  1.00 44.99           C  
ATOM     75  CB  PHE    20       8.875  18.070  52.229  1.00 44.60           C  
ATOM     78  CG  PHE    20       8.967  16.583  52.430  1.00 44.31           C  
ATOM     79  CD1 PHE    20       8.814  16.023  53.683  1.00 45.43           C  
ATOM     81  CE1 PHE    20       8.871  14.634  53.877  1.00 44.99           C  
ATOM     83  CZ  PHE    20       9.077  13.820  52.843  1.00 43.54           C  
ATOM     85  CE2 PHE    20       9.199  14.351  51.588  1.00 44.96           C  
ATOM     87  CD2 PHE    20       9.152  15.735  51.379  1.00 44.56           C  
ATOM     89  C   PHE    20       9.859  20.151  51.339  1.00 44.84           C  
ATOM     90  O   PHE    20       9.575  20.984  52.162  1.00 45.26           O  
ATOM     92  N   GLN    21       9.875  20.414  50.048  1.00 45.39           N  
ATOM     93  CA  GLN    21       9.553  21.743  49.542  1.00 45.85           C  
ATOM     95  CB  GLN    21       9.966  21.882  48.065  1.00 46.10           C  
ATOM     98  CG  GLN    21      11.462  21.638  47.776  1.00 45.85           C  
ATOM    101  CD  GLN    21      12.355  22.618  48.495  1.00 46.50           C  
ATOM    102  OE1 GLN    21      12.212  23.845  48.353  1.00 47.26           O  
ATOM    103  NE2 GLN    21      13.273  22.092  49.288  1.00 45.90           N  
ATOM    106  C   GLN    21       8.049  22.035  49.714  1.00 46.07           C  
ATOM    107  O   GLN    21       7.198  21.166  49.469  1.00 45.86           O  
ATOM    109  N   SER    22       7.741  23.259  50.150  1.00 45.86           N  
ATOM    110  CA  SER    22       6.375  23.680  50.384  1.00 45.60           C  
ATOM    112  CB  SER    22       6.366  24.830  51.367  1.00 45.59           C  
ATOM    115  OG  SER    22       6.782  26.037  50.750  1.00 46.30           O  
ATOM    117  C   SER    22       5.742  24.134  49.088  1.00 45.80           C  
ATOM    118  O   SER    22       6.407  24.114  48.046  1.00 45.84           O  
ATOM    120  N   MET    23       4.473  24.560  49.153  1.00 46.02           N  
ATOM    121  CA  MET    23       3.772  25.115  47.983  1.00 46.05           C  
ATOM    123  CB  MET    23       2.313  25.460  48.298  1.00 46.56           C  
ATOM    126  CG  MET    23       1.275  24.330  48.059  1.00 48.82           C  
ATOM    129  SD  MET    23       1.254  23.496  46.412  1.00 52.49           S  
ATOM    130  CE  MET    23      -0.396  22.776  46.537  1.00 50.38           C  
ATOM    134  C   MET    23       4.432  26.367  47.439  1.00 45.55           C  
ATOM    135  O   MET    23       4.601  26.477  46.236  1.00 45.57           O  
ATOM    137  N   GLU    24       4.773  27.312  48.309  1.00 45.12           N  
ATOM    138  CA  GLU    24       5.405  28.529  47.862  1.00 45.24           C  
ATOM    140  CB  GLU    24       5.574  29.505  49.001  1.00 45.00           C  
ATOM    143  CG  GLU    24       4.249  30.004  49.540  1.00 45.52           C  
ATOM    146  CD  GLU    24       4.420  31.305  50.323  1.00 47.26           C  
ATOM    147  OE1 GLU    24       5.446  31.973  50.070  1.00 48.66           O  
ATOM    148  OE2 GLU    24       3.543  31.676  51.171  1.00 46.60           O  
ATOM    149  C   GLU    24       6.756  28.195  47.248  1.00 45.58           C  
ATOM    150  O   GLU    24       7.118  28.700  46.165  1.00 45.97           O  
ATOM    152  N   GLU    25       7.499  27.321  47.916  1.00 45.42           N  
ATOM    153  CA  GLU    25       8.791  26.893  47.383  1.00 45.38           C  
ATOM    155  CB  GLU    25       9.527  26.016  48.395  1.00 45.48           C  
ATOM    158  CG  GLU    25       9.801  26.759  49.699  1.00 46.23           C  
ATOM    161  CD  GLU    25      10.373  25.873  50.810  1.00 47.64           C  
ATOM    162  OE1 GLU    25       9.890  24.719  51.016  1.00 46.52           O  
ATOM    163  OE2 GLU    25      11.298  26.364  51.498  1.00 48.29           O  
ATOM    164  C   GLU    25       8.695  26.205  46.022  1.00 44.72           C  
ATOM    165  O   GLU    25       9.574  26.385  45.200  1.00 44.67           O  
ATOM    167  N   THR    26       7.633  25.425  45.805  1.00 44.33           N  
ATOM    168  CA  THR    26       7.333  24.809  44.497  1.00 43.62           C  
ATOM    170  CB  THR    26       6.097  23.810  44.583  1.00 43.61           C  
ATOM    172  OG1 THR    26       6.387  22.773  45.511  1.00 42.09           O  
ATOM    174  CG2 THR    26       5.748  23.157  43.247  1.00 42.42           C  
ATOM    178  C   THR    26       7.092  25.942  43.492  1.00 43.04           C  
ATOM    179  O   THR    26       7.712  25.993  42.437  1.00 42.50           O  
ATOM    181  N   GLU    27       6.220  26.875  43.843  1.00 42.37           N  
ATOM    182  CA  GLU    27       5.971  28.002  42.978  1.00 42.31           C  
ATOM    184  CB  GLU    27       5.035  29.005  43.622  1.00 42.84           C  
ATOM    187  CG  GLU    27       3.580  28.566  43.707  1.00 44.60           C  
ATOM    190  CD  GLU    27       2.700  29.690  44.267  1.00 47.31           C  
ATOM    191  OE1 GLU    27       3.193  30.857  44.272  1.00 48.72           O  
ATOM    192  OE2 GLU    27       1.529  29.432  44.703  1.00 48.41           O  
ATOM    193  C   GLU    27       7.270  28.692  42.631  1.00 40.95           C  
ATOM    194  O   GLU    27       7.497  29.041  41.480  1.00 41.59           O  
ATOM    196  N   LYS    28       8.126  28.886  43.622  1.00 39.03           N  
ATOM    197  CA  LYS    28       9.440  29.455  43.359  1.00 37.62           C  
ATOM    199  CB  LYS    28      10.250  29.534  44.641  1.00 37.50           C  
ATOM    202  CG  LYS    28      11.590  30.230  44.447  1.00 38.41           C  
ATOM    205  CD  LYS    28      12.753  29.466  45.069  1.00 39.23           C  
ATOM    208  CE  LYS    28      12.679  29.456  46.565  1.00 38.91           C  
ATOM    211  NZ  LYS    28      13.578  28.418  47.073  1.00 40.24           N  
ATOM    215  C   LYS    28      10.246  28.672  42.302  1.00 35.90           C  
ATOM    216  O   LYS    28      10.746  29.267  41.371  1.00 36.93           O  
ATOM    218  N   TRP    29      10.371  27.357  42.443  1.00 33.27           N  
ATOM    219  CA  TRP    29      11.165  26.570  41.498  1.00 31.54           C  
ATOM    221  CB  TRP    29      11.338  25.115  41.957  1.00 30.99           C  
ATOM    224  CG  TRP    29      11.998  24.926  43.278  1.00 30.44           C  
ATOM    225  CD1 TRP    29      11.570  24.110  44.281  1.00 30.13           C  
ATOM    227  NE1 TRP    29      12.435  24.175  45.351  1.00 30.02           N  
ATOM    229  CE2 TRP    29      13.444  25.050  45.056  1.00 29.08           C  
ATOM    230  CD2 TRP    29      13.206  25.551  43.764  1.00 29.84           C  
ATOM    231  CE3 TRP    29      14.106  26.479  43.230  1.00 30.17           C  
ATOM    233  CZ3 TRP    29      15.182  26.878  43.993  1.00 29.10           C  
ATOM    235  CH2 TRP    29      15.381  26.365  45.270  1.00 28.82           C  
ATOM    237  CZ2 TRP    29      14.522  25.453  45.820  1.00 28.69           C  
ATOM    239  C   TRP    29      10.577  26.553  40.093  1.00 30.66           C  
ATOM    240  O   TRP    29      11.321  26.503  39.114  1.00 30.04           O  
ATOM    242  N   MET    30       9.250  26.560  39.994  1.00 29.83           N  
ATOM    243  CA  MET    30       8.583  26.606  38.693  1.00 29.32           C  
ATOM    245  CB  MET    30       7.080  26.363  38.827  1.00 29.13           C  
ATOM    248  CG  MET    30       6.695  24.908  39.105  1.00 28.73           C  
ATOM    251  SD  MET    30       7.113  23.702  37.840  1.00 25.62           S  
ATOM    252  CE  MET    30       6.050  24.188  36.496  1.00 25.40           C  
ATOM    256  C   MET    30       8.816  27.922  37.964  1.00 28.82           C  
ATOM    257  O   MET    30       8.940  27.927  36.765  1.00 28.66           O  
ATOM    259  N   GLU    31       8.873  29.027  38.689  1.00 28.72           N  
ATOM    260  CA  GLU    31       9.214  30.321  38.090  1.00 29.06           C  
ATOM    262  CB  GLU    31       9.174  31.465  39.137  1.00 29.45           C  
ATOM    265  CG  GLU    31       7.991  32.434  39.044  1.00 29.57           C  
ATOM    268  CD  GLU    31       7.831  33.294  40.339  1.00 33.21           C  
ATOM    269  OE1 GLU    31       7.467  34.564  40.270  1.00 32.31           O  
ATOM    270  OE2 GLU    31       8.075  32.684  41.452  1.00 35.33           O  
ATOM    271  C   GLU    31      10.604  30.262  37.479  1.00 28.87           C  
ATOM    272  O   GLU    31      10.827  30.752  36.382  1.00 28.74           O  
ATOM    274  N   GLU    32      11.544  29.670  38.205  1.00 28.87           N  
ATOM    275  CA  GLU    32      12.909  29.533  37.701  1.00 29.07           C  
ATOM    277  CB  GLU    32      13.876  29.003  38.777  1.00 29.29           C  
ATOM    280  CG  GLU    32      15.319  29.531  38.660  1.00 30.35           C  
ATOM    283  CD  GLU    32      16.038  29.670  40.034  1.00 32.92           C  
ATOM    284  OE1 GLU    32      16.446  28.584  40.580  1.00 33.02           O  
ATOM    285  OE2 GLU    32      16.223  30.868  40.532  1.00 32.31           O  
ATOM    286  C   GLU    32      12.932  28.636  36.474  1.00 29.00           C  
ATOM    287  O   GLU    32      13.630  28.954  35.536  1.00 29.87           O  
ATOM    289  N   ALA    33      12.176  27.534  36.469  1.00 28.65           N  
ATOM    290  CA  ALA    33      12.074  26.677  35.272  1.00 28.41           C  
ATOM    292  CB  ALA    33      11.272  25.376  35.580  1.00 28.13           C  
ATOM    296  C   ALA    33      11.467  27.433  34.073  1.00 27.98           C  
ATOM    297  O   ALA    33      11.779  27.140  32.919  1.00 27.17           O  
ATOM    299  N   MET    34      10.613  28.412  34.367  1.00 27.93           N  
ATOM    300  CA  MET    34       9.948  29.219  33.339  1.00 28.14           C  
ATOM    302  CB  MET    34       8.803  30.030  33.949  1.00 28.21           C  
ATOM    305  CG  MET    34       7.517  29.250  34.113  1.00 28.80           C  
ATOM    308  SD  MET    34       6.705  28.872  32.536  1.00 30.50           S  
ATOM    309  CE  MET    34       6.132  30.522  32.012  1.00 29.12           C  
ATOM    313  C   MET    34      10.916  30.175  32.664  1.00 28.10           C  
ATOM    314  O   MET    34      10.875  30.374  31.449  1.00 27.67           O  
ATOM    316  N   HIS    35      11.789  30.765  33.467  1.00 28.28           N  
ATOM    317  CA  HIS    35      12.821  31.630  32.951  1.00 28.33           C  
ATOM    319  CB  HIS    35      13.581  32.265  34.112  1.00 28.41           C  
ATOM    322  CG  HIS    35      12.858  33.425  34.730  1.00 29.93           C  
ATOM    323  ND1 HIS    35      11.876  34.132  34.062  1.00 31.57           N  
ATOM    325  CE1 HIS    35      11.437  35.118  34.832  1.00 31.30           C  
ATOM    327  NE2 HIS    35      12.092  35.071  35.978  1.00 31.32           N  
ATOM    329  CD2 HIS    35      12.985  34.021  35.943  1.00 31.00           C  
ATOM    331  C   HIS    35      13.742  30.839  32.027  1.00 28.17           C  
ATOM    332  O   HIS    35      14.065  31.289  30.934  1.00 27.82           O  
ATOM    334  N   MET    36      14.123  29.641  32.458  1.00 28.15           N  
ATOM    335  CA  MET    36      14.961  28.760  31.661  1.00 28.40           C  
ATOM    337  CB  MET    36      15.322  27.506  32.450  1.00 28.40           C  
ATOM    340  CG  MET    36      16.315  27.796  33.560  1.00 29.25           C  
ATOM    343  SD  MET    36      16.813  26.309  34.428  1.00 31.57           S  
ATOM    344  CE  MET    36      18.067  25.576  33.340  1.00 32.53           C  
ATOM    348  C   MET    36      14.308  28.388  30.336  1.00 28.59           C  
ATOM    349  O   MET    36      14.979  28.316  29.303  1.00 28.44           O  
ATOM    351  N   ALA    37      12.999  28.161  30.359  1.00 28.78           N  
ATOM    352  CA  ALA    37      12.272  27.908  29.139  1.00 28.45           C  
ATOM    354  CB  ALA    37      10.865  27.523  29.464  1.00 28.21           C  
ATOM    358  C   ALA    37      12.350  29.138  28.203  1.00 28.53           C  
ATOM    359  O   ALA    37      12.535  28.976  26.991  1.00 28.74           O  
ATOM    361  N   LYS    38      12.254  30.353  28.753  1.00 28.46           N  
ATOM    362  CA  LYS    38      12.479  31.585  27.952  1.00 28.77           C  
ATOM    364  CB  LYS    38      12.362  32.855  28.810  1.00 28.84           C  
ATOM    367  CG  LYS    38      11.173  33.763  28.490  1.00 29.78           C  
ATOM    370  CD  LYS    38      10.670  34.538  29.775  1.00 31.42           C  
ATOM    373  CE  LYS    38       9.790  33.635  30.740  1.00 31.00           C  
ATOM    376  NZ  LYS    38       9.628  34.146  32.144  1.00 30.04           N  
ATOM    380  C   LYS    38      13.844  31.602  27.254  1.00 28.67           C  
ATOM    381  O   LYS    38      13.935  31.826  26.059  1.00 28.60           O  
ATOM    383  N   GLU    39      14.903  31.388  28.029  1.00 28.92           N  
ATOM    384  CA  GLU    39      16.255  31.241  27.491  1.00 29.07           C  
ATOM    386  CB  GLU    39      17.256  30.896  28.615  1.00 29.32           C  
ATOM    389  CG  GLU    39      17.683  32.092  29.525  1.00 29.97           C  
ATOM    392  CD  GLU    39      18.618  31.675  30.698  1.00 30.95           C  
ATOM    393  OE1 GLU    39      18.395  30.602  31.336  1.00 31.36           O  
ATOM    394  OE2 GLU    39      19.579  32.435  30.976  1.00 30.64           O  
ATOM    395  C   GLU    39      16.323  30.161  26.391  1.00 29.31           C  
ATOM    396  O   GLU    39      16.994  30.352  25.385  1.00 29.93           O  
ATOM    398  N   ALA    40      15.655  29.025  26.568  1.00 29.26           N  
ATOM    399  CA  ALA    40      15.675  27.990  25.538  1.00 29.14           C  
ATOM    401  CB  ALA    40      14.954  26.733  26.023  1.00 29.09           C  
ATOM    405  C   ALA    40      15.052  28.523  24.233  1.00 29.31           C  
ATOM    406  O   ALA    40      15.647  28.416  23.135  1.00 29.24           O  
ATOM    408  N   LEU    41      13.866  29.115  24.357  1.00 29.40           N  
ATOM    409  CA  LEU    41      13.176  29.725  23.208  1.00 29.34           C  
ATOM    411  CB  LEU    41      12.006  30.573  23.716  1.00 29.30           C  
ATOM    414  CG  LEU    41      11.070  31.167  22.677  1.00 28.71           C  
ATOM    416  CD1 LEU    41      10.148  30.062  22.197  1.00 28.68           C  
ATOM    420  CD2 LEU    41      10.302  32.340  23.267  1.00 27.42           C  
ATOM    424  C   LEU    41      14.117  30.616  22.372  1.00 29.48           C  
ATOM    425  O   LEU    41      14.211  30.475  21.134  1.00 29.85           O  
ATOM    427  N   GLU    42      14.821  31.511  23.067  1.00 29.00           N  
ATOM    428  CA  GLU    42      15.649  32.517  22.438  1.00 28.74           C  
ATOM    430  CB  GLU    42      15.908  33.598  23.449  1.00 28.67           C  
ATOM    433  CG  GLU    42      14.645  34.363  23.746  1.00 29.55           C  
ATOM    436  CD  GLU    42      14.781  35.250  24.971  1.00 31.30           C  
ATOM    437  OE1 GLU    42      15.008  34.664  26.080  1.00 30.85           O  
ATOM    438  OE2 GLU    42      14.659  36.515  24.804  1.00 30.70           O  
ATOM    439  C   GLU    42      16.957  31.966  21.908  1.00 28.87           C  
ATOM    440  O   GLU    42      17.677  32.661  21.201  1.00 28.72           O  
ATOM    442  N   ASN    43      17.266  30.718  22.268  1.00 29.31           N  
ATOM    443  CA  ASN    43      18.369  29.949  21.660  1.00 29.26           C  
ATOM    445  CB  ASN    43      19.164  29.173  22.728  1.00 29.03           C  
ATOM    448  CG  ASN    43      19.818  30.083  23.766  1.00 29.03           C  
ATOM    449  OD1 ASN    43      20.204  31.217  23.469  1.00 28.55           O  
ATOM    450  ND2 ASN    43      19.954  29.576  24.993  1.00 28.89           N  
ATOM    453  C   ASN    43      17.872  28.958  20.602  1.00 29.20           C  
ATOM    454  O   ASN    43      18.569  27.989  20.314  1.00 29.62           O  
ATOM    456  N   THR    44      16.686  29.195  20.033  1.00 28.87           N  
ATOM    457  CA  THR    44      16.102  28.289  19.041  1.00 28.84           C  
ATOM    459  CB  THR    44      16.897  28.318  17.748  1.00 28.74           C  
ATOM    461  OG1 THR    44      17.471  29.619  17.586  1.00 29.50           O  
ATOM    463  CG2 THR    44      15.986  27.971  16.552  1.00 28.77           C  
ATOM    467  C   THR    44      16.009  26.828  19.506  1.00 28.90           C  
ATOM    468  O   THR    44      16.232  25.893  18.716  1.00 28.57           O  
ATOM    470  N   GLU    45      15.692  26.641  20.789  1.00 28.78           N  
ATOM    471  CA  GLU    45      15.473  25.302  21.339  1.00 28.92           C  
ATOM    473  CB  GLU    45      16.415  25.012  22.521  1.00 28.92           C  
ATOM    476  CG  GLU    45      17.931  25.000  22.196  1.00 29.45           C  
ATOM    479  CD  GLU    45      18.448  23.676  21.635  1.00 29.36           C  
ATOM    480  OE1 GLU    45      19.688  23.562  21.442  1.00 27.01           O  
ATOM    481  OE2 GLU    45      17.612  22.771  21.370  1.00 30.17           O  
ATOM    482  C   GLU    45      14.006  25.190  21.777  1.00 28.65           C  
ATOM    483  O   GLU    45      13.339  26.213  22.050  1.00 29.00           O  
ATOM    485  N   VAL    46      13.501  23.955  21.814  1.00 27.84           N  
ATOM    486  CA  VAL    46      12.162  23.715  22.317  1.00 27.20           C  
ATOM    488  CB  VAL    46      11.844  22.202  22.430  1.00 27.04           C  
ATOM    490  CG1 VAL    46      10.470  22.021  22.949  1.00 26.48           C  
ATOM    494  CG2 VAL    46      11.994  21.495  21.085  1.00 25.84           C  
ATOM    498  C   VAL    46      12.218  24.332  23.700  1.00 26.94           C  
ATOM    499  O   VAL    46      13.138  24.032  24.430  1.00 27.21           O  
ATOM    501  N   PRO    47      11.286  25.236  24.048  1.00 26.78           N  
ATOM    502  CA  PRO    47      11.296  25.903  25.373  1.00 26.70           C  
ATOM    504  CB  PRO    47      10.367  27.113  25.179  1.00 26.66           C  
ATOM    507  CG  PRO    47       9.422  26.670  24.121  1.00 27.05           C  
ATOM    510  CD  PRO    47      10.184  25.723  23.207  1.00 26.93           C  
ATOM    513  C   PRO    47      10.822  25.037  26.522  1.00 26.24           C  
ATOM    514  O   PRO    47       9.673  25.088  26.918  1.00 26.00           O  
ATOM    515  N   VAL    48      11.735  24.233  27.027  1.00 26.62           N  
ATOM    516  CA  VAL    48      11.513  23.417  28.200  1.00 27.16           C  
ATOM    518  CB  VAL    48      11.457  21.880  27.852  1.00 27.41           C  
ATOM    520  CG1 VAL    48      11.253  21.035  29.132  1.00 26.53           C  
ATOM    524  CG2 VAL    48      10.393  21.571  26.783  1.00 25.65           C  
ATOM    528  C   VAL    48      12.716  23.717  29.106  1.00 27.85           C  
ATOM    529  O   VAL    48      13.887  23.614  28.672  1.00 28.19           O  
ATOM    531  N   GLY    49      12.435  24.143  30.334  1.00 27.89           N  
ATOM    532  CA  GLY    49      13.460  24.283  31.361  1.00 27.79           C  
ATOM    535  C   GLY    49      13.077  23.403  32.544  1.00 27.95           C  
ATOM    536  O   GLY    49      11.895  23.182  32.778  1.00 28.14           O  
ATOM    538  N   CYS    50      14.052  22.876  33.284  1.00 27.93           N  
ATOM    539  CA  CYS    50      13.715  22.173  34.504  1.00 28.84           C  
ATOM    541  CB  CYS    50      13.297  20.749  34.174  1.00 28.84           C  
ATOM    544  SG  CYS    50      14.643  19.606  34.018  1.00 33.39           S  
ATOM    546  C   CYS    50      14.794  22.187  35.602  1.00 28.72           C  
ATOM    547  O   CYS    50      15.972  22.404  35.318  1.00 28.99           O  
ATOM    549  N   LEU    51      14.348  21.985  36.849  1.00 28.66           N  
ATOM    550  CA  LEU    51      15.194  21.936  38.050  1.00 28.44           C  
ATOM    552  CB  LEU    51      14.880  23.128  38.954  1.00 28.29           C  
ATOM    555  CG  LEU    51      15.232  24.521  38.431  1.00 28.29           C  
ATOM    557  CD1 LEU    51      14.136  25.489  38.675  1.00 29.32           C  
ATOM    561  CD2 LEU    51      16.480  25.050  39.095  1.00 30.45           C  
ATOM    565  C   LEU    51      14.956  20.617  38.827  1.00 28.35           C  
ATOM    566  O   LEU    51      13.876  20.048  38.798  1.00 28.95           O  
ATOM    568  N   MET    52      15.958  20.126  39.526  1.00 27.97           N  
ATOM    569  CA  MET    52      15.745  19.011  40.400  1.00 28.22           C  
ATOM    571  CB  MET    52      16.413  17.765  39.825  1.00 28.57           C  
ATOM    574  CG  MET    52      15.607  17.113  38.742  1.00 29.75           C  
ATOM    577  SD  MET    52      16.528  15.808  37.882  1.00 30.98           S  
ATOM    578  CE  MET    52      16.168  14.414  38.917  1.00 33.55           C  
ATOM    582  C   MET    52      16.255  19.354  41.807  1.00 28.12           C  
ATOM    583  O   MET    52      17.427  19.709  42.002  1.00 27.75           O  
ATOM    585  N   VAL    53      15.354  19.242  42.781  1.00 27.75           N  
ATOM    586  CA  VAL    53      15.642  19.628  44.149  1.00 27.86           C  
ATOM    588  CB  VAL    53      14.603  20.664  44.634  1.00 27.43           C  
ATOM    590  CG1 VAL    53      14.756  20.937  46.109  1.00 27.32           C  
ATOM    594  CG2 VAL    53      14.729  21.953  43.833  1.00 27.25           C  
ATOM    598  C   VAL    53      15.710  18.395  45.089  1.00 28.27           C  
ATOM    599  O   VAL    53      14.819  17.559  45.116  1.00 28.02           O  
ATOM    601  N   TYR    54      16.790  18.308  45.863  1.00 28.71           N  
ATOM    602  CA  TYR    54      16.978  17.239  46.855  1.00 28.55           C  
ATOM    604  CB  TYR    54      18.085  16.279  46.430  1.00 28.75           C  
ATOM    607  CG  TYR    54      18.551  15.359  47.499  1.00 27.40           C  
ATOM    608  CD1 TYR    54      17.820  14.230  47.830  1.00 28.08           C  
ATOM    610  CE1 TYR    54      18.244  13.355  48.820  1.00 28.43           C  
ATOM    612  CZ  TYR    54      19.430  13.620  49.480  1.00 29.94           C  
ATOM    613  OH  TYR    54      19.905  12.759  50.454  1.00 32.14           O  
ATOM    615  CE2 TYR    54      20.192  14.739  49.135  1.00 29.42           C  
ATOM    617  CD2 TYR    54      19.745  15.591  48.148  1.00 27.87           C  
ATOM    619  C   TYR    54      17.366  17.869  48.152  1.00 28.27           C  
ATOM    620  O   TYR    54      18.279  18.662  48.173  1.00 28.82           O  
ATOM    622  N   ASN    55      16.677  17.488  49.221  1.00 28.12           N  
ATOM    623  CA  ASN    55      16.918  18.006  50.563  1.00 28.03           C  
ATOM    625  CB  ASN    55      18.059  17.234  51.242  1.00 28.30           C  
ATOM    628  CG  ASN    55      18.050  17.374  52.753  1.00 28.25           C  
ATOM    629  OD1 ASN    55      17.015  17.664  53.345  1.00 27.11           O  
ATOM    630  ND2 ASN    55      19.190  17.134  53.381  1.00 25.68           N  
ATOM    633  C   ASN    55      17.189  19.501  50.573  1.00 27.90           C  
ATOM    634  O   ASN    55      18.159  19.980  51.170  1.00 27.64           O  
ATOM    636  N   ASN    56      16.320  20.224  49.887  1.00 27.79           N  
ATOM    637  CA  ASN    56      16.363  21.691  49.865  1.00 28.13           C  
ATOM    639  CB  ASN    56      16.324  22.254  51.279  1.00 28.01           C  
ATOM    642  CG  ASN    56      15.882  23.683  51.311  1.00 27.94           C  
ATOM    643  OD1 ASN    56      15.237  24.172  50.381  1.00 31.08           O  
ATOM    644  ND2 ASN    56      16.215  24.367  52.378  1.00 27.46           N  
ATOM    647  C   ASN    56      17.533  22.307  49.134  1.00 27.87           C  
ATOM    648  O   ASN    56      17.908  23.425  49.409  1.00 28.32           O  
ATOM    650  N   GLU    57      18.082  21.574  48.183  1.00 27.86           N  
ATOM    651  CA  GLU    57      19.217  22.024  47.409  1.00 27.68           C  
ATOM    653  CB  GLU    57      20.472  21.281  47.847  1.00 27.08           C  
ATOM    656  CG  GLU    57      21.672  21.541  46.962  1.00 28.55           C  
ATOM    659  CD  GLU    57      23.044  21.418  47.718  1.00 30.79           C  
ATOM    660  OE1 GLU    57      24.101  21.861  47.139  1.00 30.38           O  
ATOM    661  OE2 GLU    57      23.061  20.888  48.874  1.00 30.25           O  
ATOM    662  C   GLU    57      18.879  21.798  45.937  1.00 27.63           C  
ATOM    663  O   GLU    57      18.169  20.830  45.585  1.00 27.10           O  
ATOM    665  N   VAL    58      19.321  22.734  45.093  1.00 27.91           N  
ATOM    666  CA  VAL    58      19.139  22.617  43.654  1.00 27.84           C  
ATOM    668  CB  VAL    58      19.194  23.956  42.914  1.00 27.95           C  
ATOM    670  CG1 VAL    58      19.081  23.684  41.414  1.00 27.53           C  
ATOM    674  CG2 VAL    58      18.097  24.893  43.401  1.00 27.26           C  
ATOM    678  C   VAL    58      20.250  21.735  43.142  1.00 27.85           C  
ATOM    679  O   VAL    58      21.372  22.153  42.975  1.00 27.19           O  
ATOM    681  N   VAL    59      19.894  20.494  42.876  1.00 28.57           N  
ATOM    682  CA  VAL    59      20.856  19.448  42.563  1.00 28.61           C  
ATOM    684  CB  VAL    59      20.415  18.170  43.356  1.00 28.52           C  
ATOM    686  CG1 VAL    59      19.333  17.410  42.623  1.00 27.61           C  
ATOM    690  CG2 VAL    59      21.584  17.307  43.628  1.00 30.18           C  
ATOM    694  C   VAL    59      21.022  19.190  41.019  1.00 28.74           C  
ATOM    695  O   VAL    59      21.896  18.437  40.605  1.00 28.89           O  
ATOM    697  N   GLY    60      20.192  19.812  40.180  1.00 28.38           N  
ATOM    698  CA  GLY    60      20.330  19.712  38.737  1.00 28.23           C  
ATOM    701  C   GLY    60      19.404  20.682  38.007  1.00 28.41           C  
ATOM    702  O   GLY    60      18.276  20.866  38.404  1.00 28.63           O  
ATOM    704  N   LYS    61      19.916  21.324  36.960  1.00 28.65           N  
ATOM    705  CA  LYS    61      19.168  22.227  36.093  1.00 28.54           C  
ATOM    707  CB  LYS    61      19.780  23.640  36.140  1.00 28.95           C  
ATOM    710  CG  LYS    61      19.463  24.488  37.367  1.00 28.34           C  
ATOM    713  CD  LYS    61      20.179  25.840  37.225  1.00 29.50           C  
ATOM    716  CE  LYS    61      20.207  26.654  38.541  1.00 30.91           C  
ATOM    719  NZ  LYS    61      18.964  27.499  38.849  1.00 30.87           N  
ATOM    723  C   LYS    61      19.282  21.710  34.650  1.00 28.73           C  
ATOM    724  O   LYS    61      20.198  20.928  34.303  1.00 28.29           O  
ATOM    726  N   GLY    62      18.379  22.158  33.784  1.00 28.67           N  
ATOM    727  CA  GLY    62      18.523  21.784  32.389  1.00 28.85           C  
ATOM    730  C   GLY    62      17.522  22.399  31.467  1.00 28.68           C  
ATOM    731  O   GLY    62      16.377  22.533  31.822  1.00 29.05           O  
ATOM    733  N   ARG    63      17.983  22.761  30.279  1.00 28.89           N  
ATOM    734  CA  ARG    63      17.144  23.177  29.179  1.00 28.89           C  
ATOM    736  CB  ARG    63      17.613  24.542  28.668  1.00 29.02           C  
ATOM    739  CG  ARG    63      17.129  25.716  29.490  1.00 29.86           C  
ATOM    742  CD  ARG    63      18.067  26.929  29.395  1.00 30.14           C  
ATOM    745  NE  ARG    63      19.316  26.658  30.105  1.00 31.33           N  
ATOM    747  CZ  ARG    63      20.264  27.559  30.367  1.00 31.77           C  
ATOM    748  NH1 ARG    63      20.100  28.830  29.992  1.00 31.57           N  
ATOM    751  NH2 ARG    63      21.380  27.181  31.007  1.00 30.99           N  
ATOM    754  C   ARG    63      17.358  22.195  28.056  1.00 29.11           C  
ATOM    755  O   ARG    63      18.388  21.496  28.019  1.00 29.15           O  
ATOM    757  N   ASN    64      16.420  22.169  27.108  1.00 29.06           N  
ATOM    758  CA  ASN    64      16.671  21.481  25.849  1.00 28.97           C  
ATOM    760  CB  ASN    64      15.497  21.629  24.909  1.00 29.21           C  
ATOM    763  CG  ASN    64      14.555  20.442  24.966  1.00 30.76           C  
ATOM    764  OD1 ASN    64      14.095  20.021  26.061  1.00 31.58           O  
ATOM    765  ND2 ASN    64      14.238  19.899  23.783  1.00 30.37           N  
ATOM    768  C   ASN    64      17.914  22.003  25.151  1.00 28.78           C  
ATOM    769  O   ASN    64      18.100  23.209  25.044  1.00 28.39           O  
ATOM    771  N   GLU    65      18.741  21.063  24.683  1.00 28.83           N  
ATOM    772  CA  GLU    65      19.991  21.336  23.956  1.00 28.70           C  
ATOM    774  CB  GLU    65      21.208  20.948  24.811  1.00 28.43           C  
ATOM    777  CG  GLU    65      21.363  21.803  26.060  1.00 29.26           C  
ATOM    780  CD  GLU    65      22.567  21.420  26.935  1.00 31.11           C  
ATOM    781  OE1 GLU    65      23.208  20.350  26.722  1.00 32.83           O  
ATOM    782  OE2 GLU    65      22.862  22.193  27.874  1.00 32.15           O  
ATOM    783  C   GLU    65      20.053  20.599  22.593  1.00 28.61           C  
ATOM    784  O   GLU    65      21.143  20.477  22.010  1.00 28.58           O  
ATOM    786  N   VAL    66      18.896  20.169  22.062  1.00 27.88           N  
ATOM    787  CA  VAL    66      18.886  19.316  20.880  1.00 27.67           C  
ATOM    789  CB  VAL    66      17.459  18.841  20.468  1.00 27.53           C  
ATOM    791  CG1 VAL    66      17.529  18.039  19.197  1.00 26.83           C  
ATOM    795  CG2 VAL    66      16.898  17.936  21.521  1.00 26.62           C  
ATOM    799  C   VAL    66      19.638  19.911  19.702  1.00 27.74           C  
ATOM    800  O   VAL    66      20.368  19.174  19.054  1.00 27.05           O  
ATOM    802  N   ASN    67      19.485  21.227  19.463  1.00 28.26           N  
ATOM    803  CA  ASN    67      20.095  21.919  18.295  1.00 28.74           C  
ATOM    805  CB  ASN    67      19.369  23.234  17.954  1.00 29.15           C  
ATOM    808  CG  ASN    67      17.862  23.046  17.756  1.00 30.45           C  
ATOM    809  OD1 ASN    67      17.316  21.924  17.886  1.00 31.70           O  
ATOM    810  ND2 ASN    67      17.175  24.152  17.467  1.00 29.61           N  
ATOM    813  C   ASN    67      21.546  22.272  18.503  1.00 28.57           C  
ATOM    814  O   ASN    67      22.382  22.068  17.625  1.00 28.06           O  
ATOM    816  N   GLN    68      21.820  22.854  19.661  1.00 28.68           N  
ATOM    817  CA  GLN    68      23.187  23.164  20.074  1.00 29.07           C  
ATOM    819  CB  GLN    68      23.182  23.668  21.536  1.00 29.90           C  
ATOM    822  CG  GLN    68      22.524  25.095  21.719  1.00 32.43           C  
ATOM    825  CD  GLN    68      22.188  25.490  23.188  1.00 32.48           C  
ATOM    826  OE1 GLN    68      21.718  24.669  23.999  1.00 31.76           O  
ATOM    827  NE2 GLN    68      22.424  26.777  23.507  1.00 31.80           N  
ATOM    830  C   GLN    68      24.041  21.912  20.001  1.00 28.56           C  
ATOM    831  O   GLN    68      25.150  21.918  19.494  1.00 27.79           O  
ATOM    833  N   THR    69      23.495  20.836  20.554  1.00 28.62           N  
ATOM    834  CA  THR    69      24.199  19.575  20.692  1.00 28.33           C  
ATOM    836  CB  THR    69      23.715  18.855  21.942  1.00 27.93           C  
ATOM    838  OG1 THR    69      24.674  17.873  22.314  1.00 30.06           O  
ATOM    840  CG2 THR    69      22.403  18.168  21.682  1.00 28.03           C  
ATOM    844  C   THR    69      24.028  18.652  19.476  1.00 28.16           C  
ATOM    845  O   THR    69      24.864  17.762  19.267  1.00 28.11           O  
ATOM    847  N   LYS    70      22.972  18.895  18.683  1.00 27.74           N  
ATOM    848  CA  LYS    70      22.589  18.065  17.531  1.00 27.50           C  
ATOM    850  CB  LYS    70      23.563  18.266  16.384  1.00 27.34           C  
ATOM    853  CG  LYS    70      23.246  19.525  15.632  1.00 28.15           C  
ATOM    856  CD  LYS    70      24.390  19.949  14.775  1.00 29.05           C  
ATOM    859  CE  LYS    70      24.183  21.367  14.275  1.00 29.94           C  
ATOM    862  NZ  LYS    70      25.274  21.771  13.281  1.00 31.00           N  
ATOM    866  C   LYS    70      22.383  16.586  17.886  1.00 27.49           C  
ATOM    867  O   LYS    70      22.638  15.688  17.088  1.00 27.02           O  
ATOM    869  N   ASN    71      21.857  16.364  19.083  1.00 27.55           N  
ATOM    870  CA  ASN    71      21.554  15.046  19.586  1.00 27.78           C  
ATOM    872  CB  ASN    71      22.528  14.710  20.740  1.00 28.42           C  
ATOM    875  CG  ASN    71      22.027  13.539  21.665  1.00 28.76           C  
ATOM    876  OD1 ASN    71      20.966  12.957  21.460  1.00 27.98           O  
ATOM    877  ND2 ASN    71      22.818  13.221  22.698  1.00 28.49           N  
ATOM    880  C   ASN    71      20.093  15.093  20.051  1.00 27.58           C  
ATOM    881  O   ASN    71      19.764  15.768  21.038  1.00 27.17           O  
ATOM    883  N   ALA    72      19.246  14.340  19.348  1.00 27.15           N  
ATOM    884  CA  ALA    72      17.800  14.367  19.546  1.00 27.07           C  
ATOM    886  CB  ALA    72      17.127  13.525  18.488  1.00 26.68           C  
ATOM    890  C   ALA    72      17.315  13.950  20.941  1.00 27.13           C  
ATOM    891  O   ALA    72      16.182  14.226  21.301  1.00 26.86           O  
ATOM    893  N   THR    73      18.163  13.293  21.726  1.00 27.64           N  
ATOM    894  CA  THR    73      17.794  12.844  23.087  1.00 27.77           C  
ATOM    896  CB  THR    73      18.487  11.475  23.481  1.00 27.68           C  
ATOM    898  OG1 THR    73      19.896  11.661  23.586  1.00 28.68           O  
ATOM    900  CG2 THR    73      18.245  10.386  22.484  1.00 27.37           C  
ATOM    904  C   THR    73      18.077  13.870  24.222  1.00 27.70           C  
ATOM    905  O   THR    73      17.605  13.670  25.328  1.00 28.04           O  
ATOM    907  N   ARG    74      18.804  14.962  23.970  1.00 28.06           N  
ATOM    908  CA  ARG    74      19.126  15.931  25.042  1.00 28.19           C  
ATOM    910  CB  ARG    74      20.501  16.601  24.849  1.00 28.37           C  
ATOM    913  CG  ARG    74      21.630  15.661  25.334  1.00 29.65           C  
ATOM    916  CD  ARG    74      23.077  16.273  25.365  1.00 31.98           C  
ATOM    919  NE  ARG    74      23.948  15.483  24.442  1.00 33.67           N  
ATOM    921  CZ  ARG    74      25.287  15.545  24.348  1.00 32.37           C  
ATOM    922  NH1 ARG    74      26.000  16.370  25.135  1.00 33.11           N  
ATOM    925  NH2 ARG    74      25.913  14.770  23.451  1.00 30.11           N  
ATOM    928  C   ARG    74      18.008  16.914  25.334  1.00 27.96           C  
ATOM    929  O   ARG    74      18.098  18.113  25.095  1.00 27.54           O  
ATOM    931  N   HIS    75      16.947  16.332  25.881  1.00 28.13           N  
ATOM    932  CA  HIS    75      15.808  17.019  26.439  1.00 27.64           C  
ATOM    934  CB  HIS    75      14.667  16.007  26.623  1.00 27.64           C  
ATOM    937  CG  HIS    75      13.933  15.675  25.364  1.00 26.85           C  
ATOM    938  ND1 HIS    75      12.684  15.091  25.365  1.00 27.16           N  
ATOM    940  CE1 HIS    75      12.273  14.929  24.123  1.00 25.35           C  
ATOM    942  NE2 HIS    75      13.203  15.398  23.314  1.00 25.61           N  
ATOM    944  CD2 HIS    75      14.241  15.891  24.066  1.00 26.69           C  
ATOM    946  C   HIS    75      16.212  17.565  27.809  1.00 27.62           C  
ATOM    947  O   HIS    75      17.040  16.976  28.486  1.00 27.41           O  
ATOM    949  N   ALA    76      15.605  18.680  28.215  1.00 27.85           N  
ATOM    950  CA  ALA    76      15.914  19.361  29.477  1.00 27.68           C  
ATOM    952  CB  ALA    76      14.837  20.315  29.795  1.00 27.83           C  
ATOM    956  C   ALA    76      16.071  18.407  30.627  1.00 27.54           C  
ATOM    957  O   ALA    76      16.949  18.557  31.454  1.00 27.23           O  
ATOM    959  N   GLU    77      15.202  17.415  30.660  1.00 27.94           N  
ATOM    960  CA  GLU    77      15.174  16.423  31.759  1.00 28.19           C  
ATOM    962  CB  GLU    77      13.931  15.503  31.638  1.00 28.04           C  
ATOM    965  CG  GLU    77      12.535  16.240  31.554  1.00 28.70           C  
ATOM    968  CD  GLU    77      12.024  16.560  30.121  1.00 29.00           C  
ATOM    969  OE1 GLU    77      12.744  17.225  29.338  1.00 26.96           O  
ATOM    970  OE2 GLU    77      10.890  16.137  29.788  1.00 30.20           O  
ATOM    971  C   GLU    77      16.453  15.576  31.775  1.00 28.12           C  
ATOM    972  O   GLU    77      16.977  15.267  32.831  1.00 27.91           O  
ATOM    974  N   MET    78      16.945  15.218  30.590  1.00 28.34           N  
ATOM    975  CA  MET    78      18.162  14.405  30.454  1.00 28.57           C  
ATOM    977  CB  MET    78      18.256  13.796  29.033  1.00 28.60           C  
ATOM    980  CG  MET    78      17.083  12.903  28.658  1.00 29.43           C  
ATOM    983  SD  MET    78      17.088  11.230  29.438  1.00 32.79           S  
ATOM    984  CE  MET    78      18.680  10.560  28.910  1.00 33.89           C  
ATOM    988  C   MET    78      19.438  15.196  30.807  1.00 27.97           C  
ATOM    989  O   MET    78      20.374  14.636  31.382  1.00 27.32           O  
ATOM    991  N   VAL    79      19.449  16.485  30.467  1.00 27.87           N  
ATOM    992  CA  VAL    79      20.504  17.412  30.894  1.00 27.89           C  
ATOM    994  CB  VAL    79      20.252  18.842  30.335  1.00 27.64           C  
ATOM    996  CG1 VAL    79      21.200  19.821  30.957  1.00 26.57           C  
ATOM   1000  CG2 VAL    79      20.390  18.846  28.827  1.00 27.02           C  
ATOM   1004  C   VAL    79      20.582  17.472  32.428  1.00 28.20           C  
ATOM   1005  O   VAL    79      21.663  17.343  33.013  1.00 28.42           O  
ATOM   1007  N   ALA    80      19.422  17.663  33.060  1.00 28.46           N  
ATOM   1008  CA  ALA    80      19.292  17.726  34.514  1.00 28.47           C  
ATOM   1010  CB  ALA    80      17.846  18.000  34.891  1.00 28.80           C  
ATOM   1014  C   ALA    80      19.776  16.452  35.211  1.00 28.83           C  
ATOM   1015  O   ALA    80      20.513  16.536  36.211  1.00 28.83           O  
ATOM   1017  N   ILE    81      19.346  15.286  34.702  1.00 28.53           N  
ATOM   1018  CA  ILE    81      19.759  14.004  35.257  1.00 28.44           C  
ATOM   1020  CB  ILE    81      19.134  12.836  34.510  1.00 28.66           C  
ATOM   1022  CG1 ILE    81      17.624  12.783  34.805  1.00 28.89           C  
ATOM   1025  CD1 ILE    81      16.882  11.805  33.992  1.00 26.60           C  
ATOM   1029  CG2 ILE    81      19.789  11.514  34.943  1.00 28.72           C  
ATOM   1033  C   ILE    81      21.275  13.851  35.248  1.00 28.72           C  
ATOM   1034  O   ILE    81      21.854  13.413  36.239  1.00 29.25           O  
ATOM   1036  N   ASP    82      21.922  14.237  34.152  1.00 28.61           N  
ATOM   1037  CA  ASP    82      23.382  14.204  34.080  1.00 28.47           C  
ATOM   1039  CB  ASP    82      23.900  14.655  32.700  1.00 28.86           C  
ATOM   1042  CG  ASP    82      24.020  13.506  31.685  1.00 30.66           C  
ATOM   1043  OD1 ASP    82      23.613  12.367  32.024  1.00 33.60           O  
ATOM   1044  OD2 ASP    82      24.542  13.743  30.544  1.00 32.55           O  
ATOM   1045  C   ASP    82      23.987  15.088  35.148  1.00 28.01           C  
ATOM   1046  O   ASP    82      24.999  14.728  35.734  1.00 27.82           O  
ATOM   1048  N   GLN    83      23.379  16.253  35.385  1.00 27.76           N  
ATOM   1049  CA  GLN    83      23.868  17.178  36.416  1.00 27.64           C  
ATOM   1051  CB  GLN    83      23.170  18.538  36.279  1.00 27.69           C  
ATOM   1054  CG  GLN    83      23.871  19.468  35.291  1.00 28.50           C  
ATOM   1057  CD  GLN    83      23.481  20.925  35.456  1.00 27.64           C  
ATOM   1058  OE1 GLN    83      22.782  21.301  36.390  1.00 27.94           O  
ATOM   1059  NE2 GLN    83      23.942  21.750  34.551  1.00 27.26           N  
ATOM   1062  C   GLN    83      23.721  16.646  37.849  1.00 27.11           C  
ATOM   1063  O   GLN    83      24.612  16.790  38.666  1.00 26.25           O  
ATOM   1065  N   VAL    84      22.573  16.039  38.131  1.00 27.29           N  
ATOM   1066  CA  VAL    84      22.373  15.354  39.390  1.00 27.38           C  
ATOM   1068  CB  VAL    84      20.931  14.822  39.562  1.00 27.63           C  
ATOM   1070  CG1 VAL    84      20.775  14.175  40.919  1.00 25.95           C  
ATOM   1074  CG2 VAL    84      19.923  15.945  39.394  1.00 26.82           C  
ATOM   1078  C   VAL    84      23.395  14.241  39.566  1.00 27.17           C  
ATOM   1079  O   VAL    84      24.087  14.205  40.570  1.00 27.42           O  
ATOM   1081  N   LEU    85      23.541  13.356  38.595  1.00 27.06           N  
ATOM   1082  CA  LEU    85      24.643  12.379  38.680  1.00 27.18           C  
ATOM   1084  CB  LEU    85      24.735  11.528  37.415  1.00 26.93           C  
ATOM   1087  CG  LEU    85      23.618  10.515  37.247  1.00 26.49           C  
ATOM   1089  CD1 LEU    85      23.286  10.344  35.774  1.00 27.04           C  
ATOM   1093  CD2 LEU    85      24.014   9.242  37.875  1.00 26.00           C  
ATOM   1097  C   LEU    85      25.997  13.029  38.955  1.00 27.04           C  
ATOM   1098  O   LEU    85      26.807  12.451  39.661  1.00 27.51           O  
ATOM   1100  N   ASP    86      26.240  14.216  38.404  1.00 27.40           N  
ATOM   1101  CA  ASP    86      27.493  14.935  38.638  1.00 27.79           C  
ATOM   1103  CB  ASP    86      27.674  16.086  37.657  1.00 27.90           C  
ATOM   1106  CG  ASP    86      29.145  16.270  37.271  1.00 30.86           C  
ATOM   1107  OD1 ASP    86      29.648  15.494  36.390  1.00 32.41           O  
ATOM   1108  OD2 ASP    86      29.826  17.137  37.906  1.00 33.31           O  
ATOM   1109  C   ASP    86      27.612  15.473  40.060  1.00 27.69           C  
ATOM   1110  O   ASP    86      28.704  15.515  40.648  1.00 27.89           O  
ATOM   1112  N   TRP    87      26.479  15.887  40.606  1.00 27.68           N  
ATOM   1113  CA  TRP    87      26.393  16.362  41.971  1.00 27.52           C  
ATOM   1115  CB  TRP    87      24.996  16.944  42.217  1.00 28.11           C  
ATOM   1118  CG  TRP    87      24.854  17.634  43.516  1.00 27.84           C  
ATOM   1119  CD1 TRP    87      25.097  18.936  43.765  1.00 26.94           C  
ATOM   1121  NE1 TRP    87      24.843  19.218  45.082  1.00 27.80           N  
ATOM   1123  CE2 TRP    87      24.445  18.076  45.722  1.00 27.98           C  
ATOM   1124  CD2 TRP    87      24.432  17.048  44.756  1.00 28.61           C  
ATOM   1125  CE3 TRP    87      24.048  15.750  45.143  1.00 27.55           C  
ATOM   1127  CZ3 TRP    87      23.721  15.525  46.469  1.00 27.38           C  
ATOM   1129  CH2 TRP    87      23.747  16.579  47.415  1.00 27.96           C  
ATOM   1131  CZ2 TRP    87      24.101  17.857  47.060  1.00 27.24           C  
ATOM   1133  C   TRP    87      26.661  15.254  42.957  1.00 27.22           C  
ATOM   1134  O   TRP    87      27.279  15.469  43.985  1.00 26.82           O  
ATOM   1136  N   CYS    88      26.147  14.072  42.648  1.00 27.62           N  
ATOM   1137  CA  CYS    88      26.427  12.872  43.433  1.00 27.93           C  
ATOM   1139  CB  CYS    88      25.738  11.657  42.842  1.00 27.87           C  
ATOM   1142  SG  CYS    88      24.004  11.558  43.304  1.00 29.69           S  
ATOM   1144  C   CYS    88      27.893  12.579  43.502  1.00 27.85           C  
ATOM   1145  O   CYS    88      28.411  12.357  44.584  1.00 28.58           O  
ATOM   1147  N   ARG    89      28.569  12.568  42.360  1.00 27.85           N  
ATOM   1148  CA  ARG    89      30.000  12.313  42.366  1.00 28.33           C  
ATOM   1150  CB  ARG    89      30.613  12.676  41.043  1.00 28.62           C  
ATOM   1153  CG  ARG    89      30.413  11.652  39.984  1.00 29.96           C  
ATOM   1156  CD  ARG    89      30.720  12.311  38.629  1.00 31.97           C  
ATOM   1159  NE  ARG    89      30.164  11.544  37.504  1.00 33.93           N  
ATOM   1161  CZ  ARG    89      30.404  11.831  36.215  1.00 36.20           C  
ATOM   1162  NH1 ARG    89      31.159  12.902  35.886  1.00 37.64           N  
ATOM   1165  NH2 ARG    89      29.920  11.053  35.234  1.00 36.24           N  
ATOM   1168  C   ARG    89      30.730  13.111  43.408  1.00 28.11           C  
ATOM   1169  O   ARG    89      31.577  12.583  44.101  1.00 28.00           O  
ATOM   1171  N   GLN    90      30.383  14.386  43.506  1.00 28.42           N  
ATOM   1172  CA  GLN    90      31.132  15.339  44.301  1.00 28.75           C  
ATOM   1174  CB  GLN    90      30.990  16.703  43.661  1.00 29.03           C  
ATOM   1177  CG  GLN    90      31.457  16.706  42.217  1.00 31.17           C  
ATOM   1180  CD  GLN    90      31.094  17.981  41.521  1.00 33.04           C  
ATOM   1181  OE1 GLN    90      30.440  18.845  42.108  1.00 35.04           O  
ATOM   1182  NE2 GLN    90      31.498  18.113  40.261  1.00 34.45           N  
ATOM   1185  C   GLN    90      30.670  15.469  45.728  1.00 28.39           C  
ATOM   1186  O   GLN    90      31.383  16.039  46.538  1.00 28.51           O  
ATOM   1188  N   SER    91      29.453  15.014  46.010  1.00 28.22           N  
ATOM   1189  CA  SER    91      28.885  15.090  47.346  1.00 28.33           C  
ATOM   1191  CB  SER    91      27.379  15.315  47.267  1.00 28.48           C  
ATOM   1194  OG  SER    91      26.708  14.066  47.137  1.00 28.44           O  
ATOM   1196  C   SER    91      29.135  13.806  48.131  1.00 28.41           C  
ATOM   1197  O   SER    91      28.941  13.790  49.351  1.00 28.52           O  
ATOM   1199  N   GLY    92      29.541  12.740  47.419  1.00 28.34           N  
ATOM   1200  CA  GLY    92      29.820  11.437  48.010  1.00 28.07           C  
ATOM   1203  C   GLY    92      28.567  10.609  48.180  1.00 27.97           C  
ATOM   1204  O   GLY    92      28.632   9.480  48.609  1.00 28.33           O  
ATOM   1206  N   LYS    93      27.418  11.175  47.850  1.00 28.04           N  
ATOM   1207  CA  LYS    93      26.144  10.499  48.043  1.00 28.52           C  
ATOM   1209  CB  LYS    93      25.010  11.516  48.151  1.00 28.44           C  
ATOM   1212  CG  LYS    93      25.124  12.507  49.287  1.00 28.85           C  
ATOM   1215  CD  LYS    93      24.408  12.008  50.555  1.00 30.68           C  
ATOM   1218  CE  LYS    93      23.929  13.147  51.497  1.00 31.10           C  
ATOM   1221  NZ  LYS    93      22.573  12.817  52.143  1.00 31.15           N  
ATOM   1225  C   LYS    93      25.886   9.579  46.841  1.00 28.54           C  
ATOM   1226  O   LYS    93      26.366   9.859  45.736  1.00 28.29           O  
ATOM   1228  N   SER    94      25.122   8.501  47.058  1.00 28.28           N  
ATOM   1229  CA  SER    94      24.802   7.568  45.984  1.00 27.99           C  
ATOM   1231  CB  SER    94      24.546   6.167  46.522  1.00 27.89           C  
ATOM   1234  OG  SER    94      23.271   6.106  47.132  1.00 27.86           O  
ATOM   1236  C   SER    94      23.571   8.064  45.224  1.00 28.07           C  
ATOM   1237  O   SER    94      22.649   8.643  45.843  1.00 27.86           O  
ATOM   1239  N   PRO    95      23.548   7.840  43.893  1.00 27.49           N  
ATOM   1240  CA  PRO    95      22.436   8.176  42.998  1.00 27.79           C  
ATOM   1242  CB  PRO    95      22.818   7.481  41.703  1.00 27.72           C  
ATOM   1245  CG  PRO    95      24.264   7.455  41.751  1.00 28.05           C  
ATOM   1248  CD  PRO    95      24.646   7.219  43.154  1.00 27.05           C  
ATOM   1251  C   PRO    95      21.045   7.709  43.436  1.00 27.91           C  
ATOM   1252  O   PRO    95      20.106   8.499  43.371  1.00 28.45           O  
ATOM   1253  N   SER    96      20.917   6.457  43.869  1.00 27.75           N  
ATOM   1254  CA  SER    96      19.643   5.929  44.340  1.00 28.16           C  
ATOM   1256  CB  SER    96      19.727   4.416  44.567  1.00 28.01           C  
ATOM   1259  OG  SER    96      20.401   4.120  45.777  1.00 28.00           O  
ATOM   1261  C   SER    96      19.140   6.659  45.599  1.00 28.30           C  
ATOM   1262  O   SER    96      17.977   6.987  45.701  1.00 28.80           O  
ATOM   1264  N   GLU    97      20.029   6.959  46.524  1.00 28.77           N  
ATOM   1265  CA  GLU    97      19.701   7.734  47.728  1.00 29.19           C  
ATOM   1267  CB  GLU    97      20.960   7.760  48.608  1.00 29.43           C  
ATOM   1270  CG  GLU    97      20.840   8.453  49.966  1.00 31.88           C  
ATOM   1273  CD  GLU    97      22.211   8.495  50.747  1.00 34.19           C  
ATOM   1274  OE1 GLU    97      23.234   7.944  50.211  1.00 34.81           O  
ATOM   1275  OE2 GLU    97      22.250   9.095  51.874  1.00 32.68           O  
ATOM   1276  C   GLU    97      19.225   9.185  47.447  1.00 29.09           C  
ATOM   1277  O   GLU    97      18.528   9.788  48.293  1.00 29.59           O  
ATOM   1279  N   VAL    98      19.614   9.742  46.295  1.00 28.27           N  
ATOM   1280  CA  VAL    98      19.289  11.121  45.961  1.00 28.28           C  
ATOM   1282  CB  VAL    98      20.460  11.853  45.218  1.00 28.27           C  
ATOM   1284  CG1 VAL    98      20.109  13.282  44.899  1.00 25.94           C  
ATOM   1288  CG2 VAL    98      21.732  11.836  46.046  1.00 28.61           C  
ATOM   1292  C   VAL    98      18.069  11.175  45.066  1.00 28.91           C  
ATOM   1293  O   VAL    98      17.096  11.881  45.374  1.00 28.91           O  
ATOM   1295  N   PHE    99      18.133  10.470  43.930  1.00 29.30           N  
ATOM   1296  CA  PHE    99      17.022  10.466  42.968  1.00 29.02           C  
ATOM   1298  CB  PHE    99      17.314   9.595  41.740  1.00 29.08           C  
ATOM   1301  CG  PHE    99      18.191  10.271  40.744  1.00 30.28           C  
ATOM   1302  CD1 PHE    99      19.564  10.018  40.707  1.00 30.48           C  
ATOM   1304  CE1 PHE    99      20.391  10.672  39.812  1.00 29.96           C  
ATOM   1306  CZ  PHE    99      19.873  11.616  38.953  1.00 30.17           C  
ATOM   1308  CE2 PHE    99      18.508  11.904  38.982  1.00 31.27           C  
ATOM   1310  CD2 PHE    99      17.666  11.222  39.877  1.00 31.63           C  
ATOM   1312  C   PHE    99      15.737  10.011  43.618  1.00 28.89           C  
ATOM   1313  O   PHE    99      14.682  10.551  43.305  1.00 29.69           O  
ATOM   1315  N   GLU   100      15.802   9.025  44.514  1.00 28.16           N  
ATOM   1316  CA  GLU   100      14.578   8.558  45.168  1.00 27.97           C  
ATOM   1318  CB  GLU   100      14.825   7.247  45.899  1.00 27.44           C  
ATOM   1321  CG  GLU   100      15.086   6.145  44.939  1.00 28.81           C  
ATOM   1324  CD  GLU   100      15.433   4.827  45.602  1.00 31.25           C  
ATOM   1325  OE1 GLU   100      14.999   4.604  46.757  1.00 33.41           O  
ATOM   1326  OE2 GLU   100      16.147   4.005  44.961  1.00 32.63           O  
ATOM   1327  C   GLU   100      13.901   9.589  46.090  1.00 27.67           C  
ATOM   1328  O   GLU   100      12.803   9.337  46.580  1.00 27.67           O  
ATOM   1330  N   HIS   101      14.549  10.734  46.319  1.00 27.43           N  
ATOM   1331  CA  HIS   101      13.984  11.809  47.136  1.00 27.25           C  
ATOM   1333  CB  HIS   101      14.693  11.846  48.490  1.00 27.64           C  
ATOM   1336  CG  HIS   101      14.600  10.559  49.241  1.00 28.63           C  
ATOM   1337  ND1 HIS   101      15.589   9.592  49.190  1.00 29.98           N  
ATOM   1339  CE1 HIS   101      15.213   8.550  49.910  1.00 29.66           C  
ATOM   1341  NE2 HIS   101      14.023   8.807  50.425  1.00 29.55           N  
ATOM   1343  CD2 HIS   101      13.611  10.050  50.010  1.00 28.37           C  
ATOM   1345  C   HIS   101      14.093  13.162  46.463  1.00 26.91           C  
ATOM   1346  O   HIS   101      14.090  14.165  47.121  1.00 26.37           O  
ATOM   1348  N   THR   102      14.172  13.155  45.136  1.00 27.88           N  
ATOM   1349  CA  THR   102      14.323  14.343  44.296  1.00 28.28           C  
ATOM   1351  CB  THR   102      15.376  14.090  43.179  1.00 28.77           C  
ATOM   1353  OG1 THR   102      16.620  13.677  43.769  1.00 29.37           O  
ATOM   1355  CG2 THR   102      15.602  15.338  42.319  1.00 28.67           C  
ATOM   1359  C   THR   102      12.981  14.701  43.643  1.00 28.52           C  
ATOM   1360  O   THR   102      12.303  13.824  43.089  1.00 29.15           O  
ATOM   1362  N   VAL   103      12.571  15.975  43.723  1.00 28.29           N  
ATOM   1363  CA  VAL   103      11.375  16.424  43.007  1.00 27.89           C  
ATOM   1365  CB  VAL   103      10.499  17.411  43.792  1.00 27.37           C  
ATOM   1367  CG1 VAL   103       9.458  17.967  42.885  1.00 27.07           C  
ATOM   1371  CG2 VAL   103       9.842  16.749  44.935  1.00 26.32           C  
ATOM   1375  C   VAL   103      11.855  17.124  41.762  1.00 28.32           C  
ATOM   1376  O   VAL   103      12.766  17.953  41.840  1.00 27.99           O  
ATOM   1378  N   LEU   104      11.241  16.769  40.627  1.00 28.66           N  
ATOM   1379  CA  LEU   104      11.499  17.407  39.326  1.00 28.73           C  
ATOM   1381  CB  LEU   104      11.432  16.357  38.204  1.00 28.51           C  
ATOM   1384  CG  LEU   104      11.478  16.890  36.764  1.00 29.73           C  
ATOM   1386  CD1 LEU   104      12.826  17.591  36.418  1.00 30.68           C  
ATOM   1390  CD2 LEU   104      11.197  15.768  35.748  1.00 29.46           C  
ATOM   1394  C   LEU   104      10.469  18.508  39.084  1.00 28.35           C  
ATOM   1395  O   LEU   104       9.279  18.299  39.308  1.00 28.58           O  
ATOM   1397  N   TYR   105      10.935  19.672  38.635  1.00 28.26           N  
ATOM   1398  CA  TYR   105      10.055  20.816  38.292  1.00 28.44           C  
ATOM   1400  CB  TYR   105      10.335  22.040  39.206  1.00 28.13           C  
ATOM   1403  CG  TYR   105      10.205  21.756  40.702  1.00 27.64           C  
ATOM   1404  CD1 TYR   105      11.284  21.202  41.410  1.00 28.21           C  
ATOM   1406  CE1 TYR   105      11.188  20.907  42.749  1.00 27.85           C  
ATOM   1408  CZ  TYR   105      10.000  21.179  43.415  1.00 28.16           C  
ATOM   1409  OH  TYR   105       9.935  20.866  44.768  1.00 26.64           O  
ATOM   1411  CE2 TYR   105       8.925  21.757  42.726  1.00 25.52           C  
ATOM   1413  CD2 TYR   105       9.032  22.035  41.395  1.00 24.48           C  
ATOM   1415  C   TYR   105      10.264  21.171  36.797  1.00 28.60           C  
ATOM   1416  O   TYR   105      11.342  21.633  36.439  1.00 28.75           O  
ATOM   1418  N   VAL   106       9.255  20.945  35.942  1.00 28.20           N  
ATOM   1419  CA  VAL   106       9.399  21.109  34.476  1.00 28.13           C  
ATOM   1421  CB  VAL   106       9.437  19.736  33.731  1.00 27.97           C  
ATOM   1423  CG1 VAL   106      10.590  18.978  34.171  1.00 29.41           C  
ATOM   1427  CG2 VAL   106       8.201  18.935  34.004  1.00 26.97           C  
ATOM   1431  C   VAL   106       8.304  21.933  33.793  1.00 27.78           C  
ATOM   1432  O   VAL   106       7.135  21.879  34.152  1.00 27.98           O  
ATOM   1434  N   THR   107       8.698  22.640  32.750  1.00 27.47           N  
ATOM   1435  CA  THR   107       7.797  23.502  31.995  1.00 27.60           C  
ATOM   1437  CB  THR   107       8.624  24.430  31.114  1.00 27.08           C  
ATOM   1439  OG1 THR   107       9.242  25.406  31.949  1.00 26.99           O  
ATOM   1441  CG2 THR   107       7.752  25.104  30.113  1.00 28.88           C  
ATOM   1445  C   THR   107       6.738  22.762  31.142  1.00 27.29           C  
ATOM   1446  O   THR   107       5.602  23.217  31.046  1.00 27.48           O  
ATOM   1448  N   VAL   108       7.124  21.648  30.524  1.00 26.89           N  
ATOM   1449  CA  VAL   108       6.228  20.847  29.718  1.00 26.46           C  
ATOM   1451  CB  VAL   108       6.701  20.787  28.284  1.00 26.45           C  
ATOM   1453  CG1 VAL   108       5.756  19.953  27.480  1.00 25.92           C  
ATOM   1457  CG2 VAL   108       6.837  22.205  27.700  1.00 26.36           C  
ATOM   1461  C   VAL   108       6.186  19.431  30.231  1.00 26.51           C  
ATOM   1462  O   VAL   108       7.157  18.899  30.725  1.00 26.61           O  
ATOM   1464  N   GLU   109       5.033  18.814  30.117  1.00 27.18           N  
ATOM   1465  CA  GLU   109       4.876  17.390  30.411  1.00 27.29           C  
ATOM   1467  CB  GLU   109       3.488  16.904  29.932  1.00 27.24           C  
ATOM   1470  CG  GLU   109       3.138  15.447  30.308  1.00 28.49           C  
ATOM   1473  CD  GLU   109       1.889  14.937  29.589  1.00 29.27           C  
ATOM   1474  OE1 GLU   109       1.109  15.760  29.061  1.00 29.40           O  
ATOM   1475  OE2 GLU   109       1.691  13.706  29.528  1.00 30.07           O  
ATOM   1476  C   GLU   109       6.009  16.560  29.782  1.00 26.50           C  
ATOM   1477  O   GLU   109       6.244  16.634  28.607  1.00 25.85           O  
ATOM   1479  N   PRO   110       6.734  15.790  30.590  1.00 27.08           N  
ATOM   1480  CA  PRO   110       7.729  14.855  30.045  1.00 27.45           C  
ATOM   1482  CB  PRO   110       8.119  14.018  31.256  1.00 27.41           C  
ATOM   1485  CG  PRO   110       7.870  14.919  32.414  1.00 27.40           C  
ATOM   1488  CD  PRO   110       6.709  15.769  32.066  1.00 27.08           C  
ATOM   1491  C   PRO   110       7.213  13.943  28.942  1.00 27.32           C  
ATOM   1492  O   PRO   110       6.112  13.439  29.046  1.00 26.89           O  
ATOM   1493  N   CYS   111       8.019  13.764  27.895  1.00 27.48           N  
ATOM   1494  CA  CYS   111       7.673  12.895  26.779  1.00 27.20           C  
ATOM   1496  CB  CYS   111       8.596  13.159  25.591  1.00 27.18           C  
ATOM   1499  SG  CYS   111      10.319  12.549  25.762  1.00 26.81           S  
ATOM   1501  C   CYS   111       7.773  11.433  27.179  1.00 27.55           C  
ATOM   1502  O   CYS   111       8.200  11.098  28.282  1.00 27.24           O  
ATOM   1504  N   ILE   112       7.393  10.555  26.260  1.00 27.67           N  
ATOM   1505  CA  ILE   112       7.456   9.134  26.532  1.00 27.66           C  
ATOM   1507  CB  ILE   112       6.865   8.310  25.370  1.00 27.71           C  
ATOM   1509  CG1 ILE   112       5.338   8.440  25.369  1.00 28.05           C  
ATOM   1512  CD1 ILE   112       4.648   7.765  24.177  1.00 28.17           C  
ATOM   1516  CG2 ILE   112       7.261   6.828  25.471  1.00 27.28           C  
ATOM   1520  C   ILE   112       8.872   8.692  26.886  1.00 27.75           C  
ATOM   1521  O   ILE   112       9.050   7.898  27.810  1.00 27.52           O  
ATOM   1523  N   MET   113       9.878   9.206  26.168  1.00 28.00           N  
ATOM   1524  CA  MET   113      11.286   8.865  26.477  1.00 27.71           C  
ATOM   1526  CB  MET   113      12.224   9.558  25.518  1.00 27.36           C  
ATOM   1529  CG  MET   113      13.630   9.038  25.611  1.00 27.66           C  
ATOM   1532  SD  MET   113      14.781  10.217  24.914  1.00 29.59           S  
ATOM   1533  CE  MET   113      15.865  10.464  26.347  1.00 31.93           C  
ATOM   1537  C   MET   113      11.695   9.263  27.906  1.00 27.74           C  
ATOM   1538  O   MET   113      12.210   8.430  28.653  1.00 27.33           O  
ATOM   1540  N   CYS   114      11.461  10.527  28.255  1.00 27.33           N  
ATOM   1541  CA  CYS   114      11.773  11.050  29.574  1.00 27.96           C  
ATOM   1543  CB  CYS   114      11.535  12.562  29.593  1.00 28.16           C  
ATOM   1546  SG  CYS   114      12.745  13.454  28.634  1.00 29.88           S  
ATOM   1548  C   CYS   114      10.984  10.409  30.733  1.00 27.83           C  
ATOM   1549  O   CYS   114      11.560  10.008  31.741  1.00 27.85           O  
ATOM   1551  N   ALA   115       9.675  10.312  30.597  1.00 27.62           N  
ATOM   1552  CA  ALA   115       8.891   9.588  31.569  1.00 27.76           C  
ATOM   1554  CB  ALA   115       7.432   9.558  31.146  1.00 27.42           C  
ATOM   1558  C   ALA   115       9.442   8.163  31.819  1.00 28.27           C  
ATOM   1559  O   ALA   115       9.599   7.752  32.985  1.00 29.59           O  
ATOM   1561  N   ALA   116       9.771   7.412  30.769  1.00 28.12           N  
ATOM   1562  CA  ALA   116      10.385   6.078  30.963  1.00 28.33           C  
ATOM   1564  CB  ALA   116      10.653   5.371  29.619  1.00 27.77           C  
ATOM   1568  C   ALA   116      11.675   6.194  31.785  1.00 28.62           C  
ATOM   1569  O   ALA   116      11.941   5.377  32.671  1.00 29.32           O  
ATOM   1571  N   ALA   117      12.463   7.229  31.508  1.00 28.78           N  
ATOM   1572  CA  ALA   117      13.700   7.484  32.246  1.00 28.73           C  
ATOM   1574  CB  ALA   117      14.421   8.676  31.653  1.00 28.83           C  
ATOM   1578  C   ALA   117      13.441   7.743  33.724  1.00 28.85           C  
ATOM   1579  O   ALA   117      14.094   7.176  34.577  1.00 28.67           O  
ATOM   1581  N   LEU   118      12.477   8.620  34.005  1.00 29.20           N  
ATOM   1582  CA  LEU   118      12.155   9.023  35.360  1.00 28.43           C  
ATOM   1584  CB  LEU   118      11.127  10.154  35.347  1.00 27.97           C  
ATOM   1587  CG  LEU   118      11.692  11.452  34.772  1.00 27.63           C  
ATOM   1589  CD1 LEU   118      10.735  12.603  34.919  1.00 28.37           C  
ATOM   1593  CD2 LEU   118      12.963  11.797  35.439  1.00 28.09           C  
ATOM   1597  C   LEU   118      11.669   7.840  36.159  1.00 28.28           C  
ATOM   1598  O   LEU   118      12.014   7.730  37.331  1.00 28.30           O  
ATOM   1600  N   ARG   119      10.895   6.949  35.534  1.00 28.26           N  
ATOM   1601  CA  ARG   119      10.579   5.659  36.179  1.00 28.76           C  
ATOM   1603  CB  ARG   119       9.775   4.752  35.252  1.00 29.30           C  
ATOM   1606  CG  ARG   119       8.261   4.867  35.387  1.00 29.05           C  
ATOM   1609  CD  ARG   119       7.630   3.767  34.611  1.00 29.20           C  
ATOM   1612  NE  ARG   119       7.435   2.550  35.388  1.00 29.29           N  
ATOM   1614  CZ  ARG   119       6.316   2.241  36.052  1.00 30.71           C  
ATOM   1615  NH1 ARG   119       5.280   3.079  36.090  1.00 31.34           N  
ATOM   1618  NH2 ARG   119       6.229   1.086  36.713  1.00 31.28           N  
ATOM   1621  C   ARG   119      11.826   4.865  36.565  1.00 28.71           C  
ATOM   1622  O   ARG   119      11.942   4.355  37.683  1.00 28.42           O  
ATOM   1624  N   LEU   120      12.738   4.738  35.608  1.00 28.29           N  
ATOM   1625  CA  LEU   120      13.955   3.987  35.836  1.00 28.40           C  
ATOM   1627  CB  LEU   120      14.671   3.762  34.510  1.00 27.90           C  
ATOM   1630  CG  LEU   120      13.979   2.793  33.547  1.00 26.59           C  
ATOM   1632  CD1 LEU   120      14.630   2.885  32.201  1.00 25.10           C  
ATOM   1636  CD2 LEU   120      13.984   1.375  34.042  1.00 24.24           C  
ATOM   1640  C   LEU   120      14.896   4.605  36.898  1.00 28.81           C  
ATOM   1641  O   LEU   120      15.541   3.860  37.658  1.00 29.54           O  
ATOM   1643  N   MET   121      14.978   5.941  36.943  1.00 28.87           N  
ATOM   1644  CA  MET   121      15.712   6.673  37.985  1.00 28.40           C  
ATOM   1646  CB  MET   121      15.922   8.132  37.588  1.00 28.32           C  
ATOM   1649  CG  MET   121      16.793   8.350  36.362  1.00 29.39           C  
ATOM   1652  SD  MET   121      18.368   7.437  36.341  1.00 31.52           S  
ATOM   1653  CE  MET   121      19.455   8.674  37.112  1.00 32.17           C  
ATOM   1657  C   MET   121      14.968   6.697  39.316  1.00 28.60           C  
ATOM   1658  O   MET   121      15.578   6.990  40.327  1.00 28.98           O  
ATOM   1660  N   LYS   122      13.654   6.446  39.301  1.00 28.57           N  
ATOM   1661  CA  LYS   122      12.791   6.393  40.496  1.00 27.97           C  
ATOM   1663  CB  LYS   122      13.311   5.396  41.523  1.00 27.70           C  
ATOM   1666  CG  LYS   122      13.463   4.024  41.001  1.00 27.70           C  
ATOM   1669  CD  LYS   122      13.797   3.117  42.133  1.00 28.38           C  
ATOM   1672  CE  LYS   122      13.990   1.713  41.622  1.00 28.97           C  
ATOM   1675  NZ  LYS   122      14.226   0.736  42.706  1.00 29.76           N  
ATOM   1679  C   LYS   122      12.590   7.725  41.178  1.00 28.20           C  
ATOM   1680  O   LYS   122      12.469   7.773  42.412  1.00 28.06           O  
ATOM   1682  N   ILE   123      12.586   8.805  40.394  1.00 27.95           N  
ATOM   1683  CA  ILE   123      12.130  10.084  40.892  1.00 27.99           C  
ATOM   1685  CB  ILE   123      12.231  11.205  39.833  1.00 28.47           C  
ATOM   1687  CG1 ILE   123      13.668  11.737  39.725  1.00 30.17           C  
ATOM   1690  CD1 ILE   123      14.537  11.101  38.597  1.00 31.52           C  
ATOM   1694  CG2 ILE   123      11.368  12.380  40.218  1.00 27.61           C  
ATOM   1698  C   ILE   123      10.659   9.867  41.267  1.00 27.89           C  
ATOM   1699  O   ILE   123       9.901   9.331  40.452  1.00 27.80           O  
ATOM   1701  N   PRO   124      10.268  10.206  42.521  1.00 27.53           N  
ATOM   1702  CA  PRO   124       8.908  10.069  43.039  1.00 27.20           C  
ATOM   1704  CB  PRO   124       9.133  10.061  44.535  1.00 27.06           C  
ATOM   1707  CG  PRO   124      10.268  10.856  44.751  1.00 27.33           C  
ATOM   1710  CD  PRO   124      11.177  10.670  43.583  1.00 27.38           C  
ATOM   1713  C   PRO   124       7.871  11.158  42.702  1.00 27.45           C  
ATOM   1714  O   PRO   124       6.685  10.838  42.712  1.00 27.46           O  
ATOM   1715  N   LEU   125       8.290  12.403  42.420  1.00 27.23           N  
ATOM   1716  CA  LEU   125       7.342  13.475  42.135  1.00 27.35           C  
ATOM   1718  CB  LEU   125       7.072  14.273  43.410  1.00 27.50           C  
ATOM   1721  CG  LEU   125       6.170  15.505  43.456  1.00 26.55           C  
ATOM   1723  CD1 LEU   125       4.804  15.257  42.848  1.00 27.47           C  
ATOM   1727  CD2 LEU   125       6.038  15.903  44.891  1.00 25.10           C  
ATOM   1731  C   LEU   125       7.805  14.419  41.029  1.00 28.05           C  
ATOM   1732  O   LEU   125       8.891  14.992  41.124  1.00 28.35           O  
ATOM   1734  N   VAL   126       6.962  14.578  39.993  1.00 28.17           N  
ATOM   1735  CA  VAL   126       7.152  15.557  38.936  1.00 27.98           C  
ATOM   1737  CB  VAL   126       7.033  14.889  37.547  1.00 28.31           C  
ATOM   1739  CG1 VAL   126       7.189  15.937  36.449  1.00 28.62           C  
ATOM   1743  CG2 VAL   126       8.075  13.764  37.376  1.00 28.63           C  
ATOM   1747  C   VAL   126       6.066  16.632  39.064  1.00 27.89           C  
ATOM   1748  O   VAL   126       4.885  16.314  39.154  1.00 27.83           O  
ATOM   1750  N   VAL   127       6.461  17.897  39.084  1.00 27.59           N  
ATOM   1751  CA  VAL   127       5.498  18.987  39.043  1.00 27.75           C  
ATOM   1753  CB  VAL   127       5.719  20.057  40.161  1.00 28.05           C  
ATOM   1755  CG1 VAL   127       5.015  21.381  39.854  1.00 27.26           C  
ATOM   1759  CG2 VAL   127       5.246  19.535  41.514  1.00 28.36           C  
ATOM   1763  C   VAL   127       5.737  19.598  37.704  1.00 27.95           C  
ATOM   1764  O   VAL   127       6.864  19.972  37.389  1.00 27.12           O  
ATOM   1766  N   TYR   128       4.680  19.692  36.900  1.00 28.52           N  
ATOM   1767  CA  TYR   128       4.822  20.268  35.566  1.00 28.45           C  
ATOM   1769  CB  TYR   128       5.025  19.162  34.533  1.00 28.06           C  
ATOM   1772  CG  TYR   128       3.818  18.402  34.078  1.00 28.34           C  
ATOM   1773  CD1 TYR   128       3.626  17.059  34.437  1.00 29.46           C  
ATOM   1775  CE1 TYR   128       2.514  16.329  33.958  1.00 28.31           C  
ATOM   1777  CZ  TYR   128       1.612  16.958  33.113  1.00 29.12           C  
ATOM   1778  OH  TYR   128       0.500  16.310  32.604  1.00 28.84           O  
ATOM   1780  CE2 TYR   128       1.816  18.275  32.740  1.00 29.55           C  
ATOM   1782  CD2 TYR   128       2.914  18.975  33.204  1.00 28.51           C  
ATOM   1784  C   TYR   128       3.757  21.297  35.151  1.00 28.39           C  
ATOM   1785  O   TYR   128       2.754  21.529  35.860  1.00 28.91           O  
ATOM   1787  N   GLY   129       4.029  21.932  34.015  1.00 27.67           N  
ATOM   1788  CA  GLY   129       3.199  22.991  33.493  1.00 27.87           C  
ATOM   1791  C   GLY   129       2.120  22.551  32.535  1.00 27.68           C  
ATOM   1792  O   GLY   129       1.142  21.973  32.960  1.00 28.21           O  
ATOM   1794  N   CYS   130       2.275  22.855  31.252  1.00 27.34           N  
ATOM   1795  CA  CYS   130       1.279  22.499  30.266  1.00 27.89           C  
ATOM   1797  CB  CYS   130       1.342  23.480  29.107  1.00 27.89           C  
ATOM   1800  SG  CYS   130       2.914  23.319  28.162  1.00 30.29           S  
ATOM   1802  C   CYS   130       1.470  21.072  29.724  1.00 27.56           C  
ATOM   1803  O   CYS   130       2.489  20.438  29.937  1.00 26.76           O  
ATOM   1805  N   GLN   131       0.471  20.610  28.984  1.00 27.70           N  
ATOM   1806  CA  GLN   131       0.459  19.278  28.412  1.00 27.98           C  
ATOM   1808  CB  GLN   131      -0.950  18.922  27.932  1.00 28.47           C  
ATOM   1811  CG  GLN   131      -2.080  18.913  29.037  1.00 29.70           C  
ATOM   1814  CD  GLN   131      -1.959  17.735  30.027  1.00 31.77           C  
ATOM   1815  OE1 GLN   131      -1.739  16.574  29.619  1.00 33.82           O  
ATOM   1816  NE2 GLN   131      -2.093  18.027  31.327  1.00 31.60           N  
ATOM   1819  C   GLN   131       1.429  19.146  27.243  1.00 27.96           C  
ATOM   1820  O   GLN   131       1.803  20.137  26.635  1.00 27.61           O  
ATOM   1822  N   ASN   132       1.838  17.908  26.957  1.00 27.61           N  
ATOM   1823  CA  ASN   132       2.626  17.589  25.790  1.00 27.44           C  
ATOM   1825  CB  ASN   132       3.852  16.823  26.237  1.00 27.50           C  
ATOM   1828  CG  ASN   132       4.790  16.477  25.105  1.00 27.17           C  
ATOM   1829  OD1 ASN   132       4.451  16.645  23.947  1.00 28.04           O  
ATOM   1830  ND2 ASN   132       5.969  15.974  25.440  1.00 26.21           N  
ATOM   1833  C   ASN   132       1.780  16.782  24.793  1.00 27.56           C  
ATOM   1834  O   ASN   132       1.796  15.567  24.792  1.00 27.93           O  
ATOM   1836  N   GLU   133       1.042  17.475  23.940  1.00 27.82           N  
ATOM   1837  CA  GLU   133       0.081  16.823  23.046  1.00 28.46           C  
ATOM   1839  CB  GLU   133      -0.771  17.863  22.301  1.00 28.66           C  
ATOM   1842  CG  GLU   133      -2.060  18.259  23.041  1.00 30.06           C  
ATOM   1845  CD  GLU   133      -2.933  19.217  22.235  1.00 31.68           C  
ATOM   1846  OE1 GLU   133      -3.256  18.917  21.055  1.00 31.78           O  
ATOM   1847  OE2 GLU   133      -3.298  20.278  22.791  1.00 33.58           O  
ATOM   1848  C   GLU   133       0.692  15.860  22.029  1.00 28.35           C  
ATOM   1849  O   GLU   133       0.094  14.830  21.710  1.00 28.39           O  
ATOM   1851  N   ARG   134       1.869  16.202  21.523  1.00 28.25           N  
ATOM   1852  CA  ARG   134       2.561  15.377  20.550  1.00 28.21           C  
ATOM   1854  CB  ARG   134       3.683  16.166  19.899  1.00 28.39           C  
ATOM   1857  CG  ARG   134       3.264  17.431  19.221  1.00 28.78           C  
ATOM   1860  CD  ARG   134       4.465  18.125  18.644  1.00 29.15           C  
ATOM   1863  NE  ARG   134       4.091  19.255  17.801  1.00 29.84           N  
ATOM   1865  CZ  ARG   134       4.910  19.864  16.935  1.00 31.27           C  
ATOM   1866  NH1 ARG   134       6.177  19.461  16.778  1.00 31.15           N  
ATOM   1869  NH2 ARG   134       4.464  20.902  16.221  1.00 32.11           N  
ATOM   1872  C   ARG   134       3.178  14.108  21.162  1.00 28.31           C  
ATOM   1873  O   ARG   134       3.053  13.042  20.586  1.00 28.43           O  
ATOM   1875  N   PHE   135       3.865  14.216  22.302  1.00 28.31           N  
ATOM   1876  CA  PHE   135       4.589  13.063  22.841  1.00 28.53           C  
ATOM   1878  CB  PHE   135       6.034  13.163  22.343  1.00 28.53           C  
ATOM   1881  CG  PHE   135       6.732  11.841  22.165  1.00 28.29           C  
ATOM   1882  CD1 PHE   135       6.029  10.670  21.855  1.00 28.13           C  
ATOM   1884  CE1 PHE   135       6.692   9.435  21.694  1.00 28.35           C  
ATOM   1886  CZ  PHE   135       8.063   9.366  21.827  1.00 28.92           C  
ATOM   1888  CE2 PHE   135       8.788  10.545  22.126  1.00 30.44           C  
ATOM   1890  CD2 PHE   135       8.112  11.776  22.288  1.00 28.94           C  
ATOM   1892  C   PHE   135       4.521  12.863  24.376  1.00 28.82           C  
ATOM   1893  O   PHE   135       5.346  12.140  24.953  1.00 29.17           O  
ATOM   1895  N   GLY   136       3.510  13.446  25.019  1.00 28.58           N  
ATOM   1896  CA  GLY   136       3.332  13.292  26.455  1.00 29.12           C  
ATOM   1899  C   GLY   136       3.279  11.832  26.957  1.00 29.71           C  
ATOM   1900  O   GLY   136       2.548  10.985  26.410  1.00 29.56           O  
ATOM   1902  N   GLY   137       4.055  11.555  28.013  1.00 29.77           N  
ATOM   1903  CA  GLY   137       4.027  10.275  28.740  1.00 29.90           C  
ATOM   1906  C   GLY   137       3.441  10.285  30.168  1.00 29.93           C  
ATOM   1907  O   GLY   137       3.670   9.350  30.965  1.00 30.73           O  
ATOM   1909  N   CYS   138       2.667  11.308  30.498  1.00 29.42           N  
ATOM   1910  CA  CYS   138       2.001  11.353  31.793  1.00 29.62           C  
ATOM   1912  CB  CYS   138       2.460  12.576  32.587  1.00 29.79           C  
ATOM   1915  SG  CYS   138       4.218  12.576  32.898  1.00 30.23           S  
ATOM   1917  C   CYS   138       0.490  11.355  31.686  1.00 29.17           C  
ATOM   1918  O   CYS   138      -0.197  11.656  32.652  1.00 28.48           O  
ATOM   1920  N   GLY   139      -0.019  11.016  30.511  1.00 29.34           N  
ATOM   1921  CA  GLY   139      -1.452  11.056  30.270  1.00 29.45           C  
ATOM   1924  C   GLY   139      -1.880  11.464  28.872  1.00 29.50           C  
ATOM   1925  O   GLY   139      -2.898  10.977  28.401  1.00 30.03           O  
ATOM   1927  N   SER   140      -1.121  12.330  28.190  1.00 29.38           N  
ATOM   1928  CA  SER   140      -1.573  12.879  26.892  1.00 28.69           C  
ATOM   1930  CB  SER   140      -0.698  14.057  26.466  1.00 28.93           C  
ATOM   1933  OG  SER   140      -0.859  15.151  27.372  1.00 29.34           O  
ATOM   1935  C   SER   140      -1.596  11.834  25.803  1.00 28.12           C  
ATOM   1936  O   SER   140      -2.623  11.555  25.238  1.00 27.68           O  
ATOM   1938  N   VAL   141      -0.454  11.256  25.506  1.00 28.02           N  
ATOM   1939  CA  VAL   141      -0.395  10.196  24.522  1.00 27.98           C  
ATOM   1941  CB  VAL   141       0.827  10.374  23.645  1.00 27.84           C  
ATOM   1943  CG1 VAL   141       0.846   9.345  22.553  1.00 27.05           C  
ATOM   1947  CG2 VAL   141       0.852  11.775  23.089  1.00 27.21           C  
ATOM   1951  C   VAL   141      -0.345   8.820  25.204  1.00 28.40           C  
ATOM   1952  O   VAL   141      -0.958   7.871  24.753  1.00 28.56           O  
ATOM   1954  N   LEU   142       0.434   8.716  26.266  1.00 28.60           N  
ATOM   1955  CA  LEU   142       0.486   7.511  27.059  1.00 28.88           C  
ATOM   1957  CB  LEU   142       1.655   6.641  26.609  1.00 29.36           C  
ATOM   1960  CG  LEU   142       1.363   5.515  25.614  1.00 29.50           C  
ATOM   1962  CD1 LEU   142       2.672   5.036  24.980  1.00 29.36           C  
ATOM   1966  CD2 LEU   142       0.667   4.390  26.351  1.00 28.79           C  
ATOM   1970  C   LEU   142       0.688   7.927  28.500  1.00 29.16           C  
ATOM   1971  O   LEU   142       1.134   9.040  28.782  1.00 29.17           O  
ATOM   1973  N   ASN   143       0.385   7.034  29.430  1.00 29.52           N  
ATOM   1974  CA  ASN   143       0.660   7.355  30.830  1.00 29.66           C  
ATOM   1976  CB  ASN   143      -0.628   7.395  31.629  1.00 29.61           C  
ATOM   1979  CG  ASN   143      -0.449   8.019  33.008  1.00 30.12           C  
ATOM   1980  OD1 ASN   143       0.647   8.046  33.602  1.00 27.75           O  
ATOM   1981  ND2 ASN   143      -1.567   8.488  33.549  1.00 31.84           N  
ATOM   1984  C   ASN   143       1.656   6.390  31.451  1.00 29.47           C  
ATOM   1985  O   ASN   143       1.281   5.505  32.230  1.00 28.77           O  
ATOM   1987  N   ILE   144       2.927   6.598  31.096  1.00 29.28           N  
ATOM   1988  CA  ILE   144       4.015   5.785  31.617  1.00 29.57           C  
ATOM   1990  CB  ILE   144       5.319   6.097  30.858  1.00 30.11           C  
ATOM   1992  CG1 ILE   144       5.167   5.738  29.372  1.00 31.30           C  
ATOM   1995  CD1 ILE   144       4.789   4.257  29.149  1.00 30.50           C  
ATOM   1999  CG2 ILE   144       6.510   5.303  31.422  1.00 30.18           C  
ATOM   2003  C   ILE   144       4.215   6.059  33.113  1.00 29.39           C  
ATOM   2004  O   ILE   144       4.545   5.141  33.866  1.00 28.54           O  
ATOM   2006  N   ALA   145       4.002   7.321  33.525  1.00 29.02           N  
ATOM   2007  CA  ALA   145       4.144   7.720  34.926  1.00 28.89           C  
ATOM   2009  CB  ALA   145       3.712   9.214  35.134  1.00 28.28           C  
ATOM   2013  C   ALA   145       3.364   6.780  35.871  1.00 29.09           C  
ATOM   2014  O   ALA   145       3.871   6.429  36.949  1.00 30.20           O  
ATOM   2016  N   SER   146       2.152   6.351  35.482  1.00 28.63           N  
ATOM   2017  CA  SER   146       1.299   5.589  36.399  1.00 28.27           C  
ATOM   2019  CB  SER   146      -0.022   6.323  36.579  1.00 28.33           C  
ATOM   2022  OG  SER   146      -0.803   6.270  35.407  1.00 28.49           O  
ATOM   2024  C   SER   146       1.055   4.147  35.959  1.00 27.91           C  
ATOM   2025  O   SER   146       0.192   3.468  36.474  1.00 27.20           O  
ATOM   2027  N   ALA   147       1.844   3.685  35.009  1.00 28.29           N  
ATOM   2028  CA  ALA   147       1.650   2.368  34.418  1.00 28.30           C  
ATOM   2030  CB  ALA   147       2.500   2.220  33.141  1.00 28.16           C  
ATOM   2034  C   ALA   147       2.008   1.281  35.414  1.00 28.18           C  
ATOM   2035  O   ALA   147       3.001   1.382  36.137  1.00 27.83           O  
ATOM   2037  N   ASP   148       1.178   0.248  35.441  1.00 28.60           N  
ATOM   2038  CA  ASP   148       1.422  -0.958  36.235  1.00 29.01           C  
ATOM   2040  CB  ASP   148       0.116  -1.758  36.344  1.00 29.22           C  
ATOM   2043  CG  ASP   148       0.271  -3.024  37.194  1.00 30.33           C  
ATOM   2044  OD1 ASP   148       1.223  -3.009  38.017  1.00 32.80           O  
ATOM   2045  OD2 ASP   148      -0.548  -4.005  37.063  1.00 28.99           O  
ATOM   2046  C   ASP   148       2.529  -1.831  35.603  1.00 28.97           C  
ATOM   2047  O   ASP   148       2.258  -2.648  34.732  1.00 29.13           O  
ATOM   2049  N   LEU   149       3.769  -1.644  36.037  1.00 28.92           N  
ATOM   2050  CA  LEU   149       4.910  -2.289  35.410  1.00 28.99           C  
ATOM   2052  CB  LEU   149       5.672  -1.312  34.501  1.00 28.85           C  
ATOM   2055  CG  LEU   149       4.909  -0.925  33.221  1.00 29.26           C  
ATOM   2057  CD1 LEU   149       5.552   0.303  32.539  1.00 28.15           C  
ATOM   2061  CD2 LEU   149       4.777  -2.100  32.253  1.00 27.32           C  
ATOM   2065  C   LEU   149       5.774  -2.797  36.547  1.00 29.23           C  
ATOM   2066  O   LEU   149       6.621  -2.072  37.076  1.00 29.09           O  
ATOM   2068  N   PRO   150       5.560  -4.060  36.923  1.00 29.54           N  
ATOM   2069  CA  PRO   150       6.060  -4.553  38.210  1.00 29.67           C  
ATOM   2071  CB  PRO   150       5.659  -6.054  38.214  1.00 29.48           C  
ATOM   2074  CG  PRO   150       4.613  -6.214  37.167  1.00 29.39           C  
ATOM   2077  CD  PRO   150       4.844  -5.103  36.153  1.00 29.63           C  
ATOM   2080  C   PRO   150       7.581  -4.399  38.417  1.00 29.61           C  
ATOM   2081  O   PRO   150       8.018  -3.945  39.489  1.00 29.54           O  
ATOM   2082  N   ASN   151       8.376  -4.783  37.422  1.00 29.36           N  
ATOM   2083  CA  ASN   151       9.822  -4.955  37.659  1.00 29.29           C  
ATOM   2085  CB  ASN   151      10.222  -6.417  37.379  1.00 29.22           C  
ATOM   2088  CG  ASN   151       9.393  -7.403  38.184  1.00 29.70           C  
ATOM   2089  OD1 ASN   151       9.515  -7.467  39.415  1.00 31.50           O  
ATOM   2090  ND2 ASN   151       8.529  -8.160  37.506  1.00 29.02           N  
ATOM   2093  C   ASN   151      10.696  -3.953  36.893  1.00 29.09           C  
ATOM   2094  O   ASN   151      11.868  -4.212  36.608  1.00 28.75           O  
ATOM   2096  N   THR   152      10.114  -2.797  36.586  1.00 29.07           N  
ATOM   2097  CA  THR   152      10.816  -1.768  35.853  1.00 29.13           C  
ATOM   2099  CB  THR   152      10.365  -1.749  34.358  1.00 29.31           C  
ATOM   2101  OG1 THR   152       8.964  -1.486  34.277  1.00 28.92           O  
ATOM   2103  CG2 THR   152      10.672  -3.123  33.693  1.00 29.99           C  
ATOM   2107  C   THR   152      10.600  -0.410  36.487  1.00 28.94           C  
ATOM   2108  O   THR   152       9.581   0.221  36.237  1.00 29.39           O  
ATOM   2110  N   GLY   153      11.562   0.038  37.301  1.00 28.73           N  
ATOM   2111  CA  GLY   153      11.483   1.345  37.989  1.00 28.04           C  
ATOM   2114  C   GLY   153      10.359   1.408  39.007  1.00 27.67           C  
ATOM   2115  O   GLY   153       9.875   0.385  39.480  1.00 27.40           O  
ATOM   2117  N   ARG   154       9.926   2.618  39.332  1.00 27.56           N  
ATOM   2118  CA  ARG   154       8.747   2.822  40.177  1.00 27.59           C  
ATOM   2120  CB  ARG   154       9.132   3.433  41.525  1.00 27.45           C  
ATOM   2123  CG  ARG   154       9.477   2.437  42.549  1.00 27.94           C  
ATOM   2126  CD  ARG   154      10.289   3.050  43.692  1.00 29.70           C  
ATOM   2129  NE  ARG   154      11.140   2.009  44.299  1.00 31.13           N  
ATOM   2131  CZ  ARG   154      11.949   2.180  45.345  1.00 30.89           C  
ATOM   2132  NH1 ARG   154      12.044   3.355  45.964  1.00 31.54           N  
ATOM   2135  NH2 ARG   154      12.672   1.155  45.773  1.00 31.08           N  
ATOM   2138  C   ARG   154       7.802   3.767  39.492  1.00 27.48           C  
ATOM   2139  O   ARG   154       8.250   4.674  38.804  1.00 28.31           O  
ATOM   2141  N   PRO   155       6.494   3.619  39.730  1.00 27.20           N  
ATOM   2142  CA  PRO   155       5.580   4.628  39.183  1.00 27.00           C  
ATOM   2144  CB  PRO   155       4.213   4.019  39.450  1.00 27.10           C  
ATOM   2147  CG  PRO   155       4.437   3.158  40.638  1.00 26.63           C  
ATOM   2150  CD  PRO   155       5.785   2.594  40.507  1.00 26.55           C  
ATOM   2153  C   PRO   155       5.717   5.931  39.935  1.00 26.56           C  
ATOM   2154  O   PRO   155       6.093   5.929  41.091  1.00 26.56           O  
ATOM   2155  N   PHE   156       5.403   7.035  39.293  1.00 26.62           N  
ATOM   2156  CA  PHE   156       5.498   8.302  39.973  1.00 27.22           C  
ATOM   2158  CB  PHE   156       6.778   9.058  39.597  1.00 27.60           C  
ATOM   2161  CG  PHE   156       6.860   9.460  38.156  1.00 28.10           C  
ATOM   2162  CD1 PHE   156       6.445  10.730  37.746  1.00 28.61           C  
ATOM   2164  CE1 PHE   156       6.503  11.085  36.419  1.00 27.46           C  
ATOM   2166  CZ  PHE   156       7.012  10.192  35.490  1.00 27.56           C  
ATOM   2168  CE2 PHE   156       7.440   8.944  35.877  1.00 27.45           C  
ATOM   2170  CD2 PHE   156       7.367   8.578  37.206  1.00 27.25           C  
ATOM   2172  C   PHE   156       4.281   9.183  39.828  1.00 27.25           C  
ATOM   2173  O   PHE   156       3.396   8.940  39.036  1.00 27.35           O  
ATOM   2175  N   GLN   157       4.266  10.209  40.661  1.00 28.12           N  
ATOM   2176  CA  GLN   157       3.162  11.132  40.818  1.00 28.30           C  
ATOM   2178  CB  GLN   157       3.023  11.430  42.312  1.00 28.26           C  
ATOM   2181  CG  GLN   157       1.573  11.587  42.818  1.00 29.14           C  
ATOM   2184  CD  GLN   157       0.726  10.354  42.579  1.00 28.88           C  
ATOM   2185  OE1 GLN   157       1.229   9.216  42.576  1.00 28.76           O  
ATOM   2186  NE2 GLN   157      -0.573  10.565  42.387  1.00 28.49           N  
ATOM   2189  C   GLN   157       3.458  12.421  40.041  1.00 28.32           C  
ATOM   2190  O   GLN   157       4.630  12.798  39.874  1.00 28.21           O  
ATOM   2192  N   CYS   158       2.393  13.052  39.540  1.00 28.34           N  
ATOM   2193  CA  CYS   158       2.457  14.325  38.805  1.00 28.55           C  
ATOM   2195  CB  CYS   158       2.053  14.113  37.368  1.00 28.36           C  
ATOM   2198  SG  CYS   158       3.234  13.191  36.449  1.00 32.99           S  
ATOM   2200  C   CYS   158       1.518  15.370  39.380  1.00 28.03           C  
ATOM   2201  O   CYS   158       0.415  15.028  39.825  1.00 28.21           O  
ATOM   2203  N   ILE   159       1.945  16.633  39.348  1.00 27.55           N  
ATOM   2204  CA  ILE   159       1.083  17.776  39.671  1.00 27.15           C  
ATOM   2206  CB  ILE   159       1.560  18.532  40.932  1.00 27.19           C  
ATOM   2208  CG1 ILE   159       1.641  17.546  42.109  1.00 27.25           C  
ATOM   2211  CD1 ILE   159       1.732  18.195  43.500  1.00 27.36           C  
ATOM   2215  CG2 ILE   159       0.655  19.748  41.227  1.00 26.47           C  
ATOM   2219  C   ILE   159       1.151  18.672  38.468  1.00 27.06           C  
ATOM   2220  O   ILE   159       2.008  19.550  38.397  1.00 27.30           O  
ATOM   2222  N   PRO   160       0.298  18.414  37.472  1.00 27.10           N  
ATOM   2223  CA  PRO   160       0.305  19.229  36.281  1.00 27.19           C  
ATOM   2225  CB  PRO   160      -0.544  18.406  35.303  1.00 26.90           C  
ATOM   2228  CG  PRO   160      -1.433  17.695  36.094  1.00 26.70           C  
ATOM   2231  CD  PRO   160      -0.693  17.339  37.350  1.00 27.27           C  
ATOM   2234  C   PRO   160      -0.314  20.600  36.470  1.00 27.02           C  
ATOM   2235  O   PRO   160      -0.932  20.865  37.479  1.00 27.06           O  
ATOM   2236  N   GLY   161      -0.094  21.468  35.491  1.00 27.50           N  
ATOM   2237  CA  GLY   161      -0.924  22.640  35.290  1.00 27.79           C  
ATOM   2240  C   GLY   161      -0.387  23.921  35.877  1.00 27.97           C  
ATOM   2241  O   GLY   161      -0.988  24.972  35.702  1.00 28.30           O  
ATOM   2243  N   TYR   162       0.734  23.872  36.581  1.00 28.36           N  
ATOM   2244  CA  TYR   162       1.233  25.110  37.155  1.00 28.73           C  
ATOM   2246  CB  TYR   162       2.370  24.897  38.182  1.00 29.03           C  
ATOM   2249  CG  TYR   162       2.842  26.246  38.703  1.00 30.02           C  
ATOM   2250  CD1 TYR   162       2.168  26.905  39.728  1.00 30.55           C  
ATOM   2252  CE1 TYR   162       2.574  28.183  40.156  1.00 31.77           C  
ATOM   2254  CZ  TYR   162       3.668  28.808  39.529  1.00 32.70           C  
ATOM   2255  OH  TYR   162       4.146  30.073  39.894  1.00 31.50           O  
ATOM   2257  CE2 TYR   162       4.321  28.152  38.497  1.00 32.51           C  
ATOM   2259  CD2 TYR   162       3.893  26.901  38.083  1.00 31.20           C  
ATOM   2261  C   TYR   162       1.658  26.061  36.018  1.00 28.23           C  
ATOM   2262  O   TYR   162       2.606  25.766  35.303  1.00 27.90           O  
ATOM   2264  N   ARG   163       0.938  27.177  35.868  1.00 27.90           N  
ATOM   2265  CA  ARG   163       1.139  28.134  34.763  1.00 27.84           C  
ATOM   2267  CB  ARG   163       2.396  28.962  35.001  1.00 27.51           C  
ATOM   2270  CG  ARG   163       2.350  29.744  36.287  1.00 28.30           C  
ATOM   2273  CD  ARG   163       3.691  30.412  36.611  1.00 28.58           C  
ATOM   2276  NE  ARG   163       3.973  31.592  35.798  1.00 29.09           N  
ATOM   2278  CZ  ARG   163       5.109  32.290  35.861  1.00 29.67           C  
ATOM   2279  NH1 ARG   163       6.078  31.937  36.710  1.00 30.17           N  
ATOM   2282  NH2 ARG   163       5.285  33.355  35.082  1.00 29.92           N  
ATOM   2285  C   ARG   163       1.174  27.499  33.350  1.00 27.71           C  
ATOM   2286  O   ARG   163       1.954  27.913  32.497  1.00 27.28           O  
ATOM   2288  N   ALA   164       0.302  26.517  33.113  1.00 27.57           N  
ATOM   2289  CA  ALA   164       0.159  25.891  31.798  1.00 27.60           C  
ATOM   2291  CB  ALA   164      -1.012  24.920  31.791  1.00 27.29           C  
ATOM   2295  C   ALA   164      -0.012  26.895  30.656  1.00 27.60           C  
ATOM   2296  O   ALA   164       0.579  26.704  29.599  1.00 27.70           O  
ATOM   2298  N   GLU   165      -0.800  27.951  30.862  1.00 27.39           N  
ATOM   2299  CA  GLU   165      -1.129  28.868  29.776  1.00 27.48           C  
ATOM   2301  CB  GLU   165      -2.048  29.961  30.262  1.00 27.81           C  
ATOM   2304  CG  GLU   165      -3.485  29.532  30.421  1.00 28.47           C  
ATOM   2307  CD  GLU   165      -4.392  30.708  30.786  1.00 30.58           C  
ATOM   2308  OE1 GLU   165      -4.442  31.711  30.023  1.00 30.66           O  
ATOM   2309  OE2 GLU   165      -5.060  30.633  31.849  1.00 32.43           O  
ATOM   2310  C   GLU   165       0.095  29.506  29.147  1.00 27.46           C  
ATOM   2311  O   GLU   165       0.268  29.497  27.928  1.00 27.18           O  
ATOM   2313  N   GLU   166       0.952  30.060  29.986  1.00 27.59           N  
ATOM   2314  CA  GLU   166       2.217  30.598  29.507  1.00 27.66           C  
ATOM   2316  CB  GLU   166       2.961  31.263  30.642  1.00 27.89           C  
ATOM   2319  CG  GLU   166       2.239  32.502  31.138  1.00 28.65           C  
ATOM   2322  CD  GLU   166       2.848  33.086  32.398  1.00 29.34           C  
ATOM   2323  OE1 GLU   166       3.360  32.322  33.252  1.00 28.90           O  
ATOM   2324  OE2 GLU   166       2.794  34.329  32.526  1.00 30.57           O  
ATOM   2325  C   GLU   166       3.097  29.544  28.876  1.00 27.37           C  
ATOM   2326  O   GLU   166       3.672  29.780  27.827  1.00 27.66           O  
ATOM   2328  N   ALA   167       3.185  28.376  29.498  1.00 27.20           N  
ATOM   2329  CA  ALA   167       3.951  27.277  28.926  1.00 26.97           C  
ATOM   2331  CB  ALA   167       3.988  26.105  29.869  1.00 26.83           C  
ATOM   2335  C   ALA   167       3.441  26.861  27.541  1.00 26.95           C  
ATOM   2336  O   ALA   167       4.225  26.686  26.627  1.00 27.07           O  
ATOM   2338  N   VAL   168       2.146  26.697  27.351  1.00 27.13           N  
ATOM   2339  CA  VAL   168       1.671  26.376  25.996  1.00 27.57           C  
ATOM   2341  CB  VAL   168       0.208  25.937  25.964  1.00 27.39           C  
ATOM   2343  CG1 VAL   168       0.085  24.566  26.594  1.00 27.92           C  
ATOM   2347  CG2 VAL   168      -0.663  26.963  26.637  1.00 26.18           C  
ATOM   2351  C   VAL   168       1.852  27.548  25.023  1.00 28.01           C  
ATOM   2352  O   VAL   168       2.143  27.336  23.839  1.00 27.90           O  
ATOM   2354  N   GLU   169       1.711  28.781  25.515  1.00 28.22           N  
ATOM   2355  CA  GLU   169       1.960  29.937  24.661  1.00 28.31           C  
ATOM   2357  CB  GLU   169       1.661  31.238  25.379  1.00 28.19           C  
ATOM   2360  CG  GLU   169       0.934  32.227  24.473  1.00 29.54           C  
ATOM   2363  CD  GLU   169       0.943  33.661  25.021  1.00 31.96           C  
ATOM   2364  OE1 GLU   169       1.714  33.912  26.000  1.00 34.14           O  
ATOM   2365  OE2 GLU   169       0.198  34.544  24.472  1.00 32.15           O  
ATOM   2366  C   GLU   169       3.388  29.963  24.101  1.00 28.30           C  
ATOM   2367  O   GLU   169       3.597  30.326  22.943  1.00 28.98           O  
ATOM   2369  N   MET   170       4.367  29.589  24.914  1.00 28.08           N  
ATOM   2370  CA  MET   170       5.754  29.551  24.453  1.00 28.04           C  
ATOM   2372  CB  MET   170       6.726  29.335  25.622  1.00 27.87           C  
ATOM   2375  CG  MET   170       7.074  30.615  26.367  1.00 28.33           C  
ATOM   2378  SD  MET   170       8.249  30.471  27.752  1.00 28.55           S  
ATOM   2379  CE  MET   170       7.214  29.683  28.987  1.00 27.96           C  
ATOM   2383  C   MET   170       5.940  28.468  23.400  1.00 28.13           C  
ATOM   2384  O   MET   170       6.505  28.715  22.348  1.00 28.20           O  
ATOM   2386  N   LEU   171       5.473  27.261  23.700  1.00 28.42           N  
ATOM   2387  CA  LEU   171       5.558  26.143  22.769  1.00 28.42           C  
ATOM   2389  CB  LEU   171       4.834  24.913  23.331  1.00 28.74           C  
ATOM   2392  CG  LEU   171       5.614  23.807  24.025  1.00 28.64           C  
ATOM   2394  CD1 LEU   171       4.612  22.730  24.485  1.00 27.77           C  
ATOM   2398  CD2 LEU   171       6.693  23.239  23.103  1.00 28.05           C  
ATOM   2402  C   LEU   171       4.911  26.485  21.439  1.00 28.37           C  
ATOM   2403  O   LEU   171       5.433  26.122  20.377  1.00 28.57           O  
ATOM   2405  N   LYS   172       3.753  27.142  21.499  1.00 28.00           N  
ATOM   2406  CA  LYS   172       3.012  27.463  20.274  1.00 27.85           C  
ATOM   2408  CB  LYS   172       1.593  28.000  20.576  1.00 27.67           C  
ATOM   2411  CG  LYS   172       0.523  26.888  20.684  1.00 27.83           C  
ATOM   2414  CD  LYS   172      -0.851  27.407  21.176  1.00 28.79           C  
ATOM   2417  CE  LYS   172      -1.973  26.373  20.896  1.00 29.34           C  
ATOM   2420  NZ  LYS   172      -2.428  26.347  19.368  1.00 29.31           N  
ATOM   2424  C   LYS   172       3.815  28.432  19.425  1.00 27.32           C  
ATOM   2425  O   LYS   172       3.942  28.266  18.218  1.00 27.26           O  
ATOM   2427  N   THR   173       4.380  29.432  20.074  1.00 27.30           N  
ATOM   2428  CA  THR   173       5.135  30.429  19.362  1.00 27.36           C  
ATOM   2430  CB  THR   173       5.501  31.639  20.254  1.00 26.82           C  
ATOM   2432  OG1 THR   173       6.315  32.503  19.498  1.00 28.03           O  
ATOM   2434  CG2 THR   173       6.295  31.285  21.426  1.00 26.84           C  
ATOM   2438  C   THR   173       6.353  29.769  18.728  1.00 27.39           C  
ATOM   2439  O   THR   173       6.729  30.102  17.611  1.00 27.65           O  
ATOM   2441  N   PHE   174       6.925  28.799  19.429  1.00 27.67           N  
ATOM   2442  CA  PHE   174       8.075  28.052  18.934  1.00 27.96           C  
ATOM   2444  CB  PHE   174       8.691  27.157  20.029  1.00 28.11           C  
ATOM   2447  CG  PHE   174       9.701  26.141  19.491  1.00 27.94           C  
ATOM   2448  CD1 PHE   174      11.002  26.527  19.174  1.00 26.47           C  
ATOM   2450  CE1 PHE   174      11.911  25.605  18.678  1.00 26.06           C  
ATOM   2452  CZ  PHE   174      11.523  24.288  18.477  1.00 25.76           C  
ATOM   2454  CE2 PHE   174      10.242  23.892  18.780  1.00 26.66           C  
ATOM   2456  CD2 PHE   174       9.334  24.807  19.287  1.00 27.84           C  
ATOM   2458  C   PHE   174       7.766  27.179  17.721  1.00 28.18           C  
ATOM   2459  O   PHE   174       8.631  27.024  16.863  1.00 28.86           O  
ATOM   2461  N   TYR   175       6.575  26.582  17.646  1.00 28.31           N  
ATOM   2462  CA  TYR   175       6.244  25.756  16.479  1.00 28.37           C  
ATOM   2464  CB  TYR   175       5.120  24.775  16.797  1.00 28.20           C  
ATOM   2467  CG  TYR   175       5.549  23.642  17.687  1.00 29.03           C  
ATOM   2468  CD1 TYR   175       4.708  23.182  18.704  1.00 29.68           C  
ATOM   2470  CE1 TYR   175       5.092  22.132  19.551  1.00 30.13           C  
ATOM   2472  CZ  TYR   175       6.344  21.524  19.369  1.00 30.83           C  
ATOM   2473  OH  TYR   175       6.716  20.480  20.195  1.00 33.11           O  
ATOM   2475  CE2 TYR   175       7.205  21.961  18.362  1.00 29.36           C  
ATOM   2477  CD2 TYR   175       6.801  23.013  17.521  1.00 29.43           C  
ATOM   2479  C   TYR   175       5.922  26.556  15.211  1.00 28.44           C  
ATOM   2480  O   TYR   175       5.590  25.962  14.192  1.00 28.62           O  
ATOM   2482  N   LYS   176       6.052  27.880  15.254  1.00 28.50           N  
ATOM   2483  CA  LYS   176       6.067  28.676  14.029  1.00 29.01           C  
ATOM   2485  CB  LYS   176       5.261  29.955  14.213  1.00 28.81           C  
ATOM   2488  CG  LYS   176       3.855  29.628  14.728  1.00 29.06           C  
ATOM   2491  CD  LYS   176       3.017  30.883  15.126  1.00 28.97           C  
ATOM   2494  CE  LYS   176       1.805  30.431  16.053  1.00 28.62           C  
ATOM   2497  NZ  LYS   176       0.966  31.639  16.480  1.00 28.07           N  
ATOM   2501  C   LYS   176       7.516  28.924  13.596  1.00 29.73           C  
ATOM   2502  O   LYS   176       8.033  30.071  13.612  1.00 29.38           O  
ATOM   2504  N   GLN   177       8.151  27.782  13.243  1.00 30.84           N  
ATOM   2505  CA  GLN   177       9.491  27.720  12.613  1.00 31.22           C  
ATOM   2507  CB  GLN   177      10.615  28.236  13.553  1.00 31.62           C  
ATOM   2510  CG  GLN   177      12.100  28.010  13.035  1.00 32.08           C  
ATOM   2513  CD  GLN   177      12.575  29.029  11.958  1.00 32.52           C  
ATOM   2514  OE1 GLN   177      12.497  30.261  12.160  1.00 31.81           O  
ATOM   2515  NE2 GLN   177      13.111  28.498  10.831  1.00 31.77           N  
ATOM   2518  C   GLN   177       9.731  26.249  12.215  1.00 30.80           C  
ATOM   2519  O   GLN   177       9.033  25.353  12.722  1.00 29.50           O  
END
