
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  158 ( 1222),  selected  158 , name 1wkq_A
# Molecule2: number of CA atoms  162 ( 1272),  selected  162 , name T0461.pdb
# PARAMETERS: 1wkq_A.T0461.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H    -2_A      E      16           -
LGA    A    -1_A      N      17           -
LGA    -       -      L      18           -
LGA    -       -      Y      19           -
LGA    -       -      F      20           -
LGA    -       -      Q      21           -
LGA    M     1_A      S      22          5.660
LGA    N     2_A      M      23          3.310
LGA    -       -      E      24           -
LGA    -       -      E      25           -
LGA    H     3_A      T      26          1.428
LGA    E     4_A      E      27          1.693
LGA    T     5_A      K      28          1.425
LGA    F     6_A      W      29          1.046
LGA    L     7_A      M      30          1.407
LGA    K     8_A      E      31          1.566
LGA    R     9_A      E      32          1.176
LGA    A    10_A      A      33          1.069
LGA    V    11_A      M      34          1.430
LGA    T    12_A      H      35          1.173
LGA    L    13_A      M      36          0.669
LGA    A    14_A      A      37          0.799
LGA    C    15_A      K      38          0.924
LGA    E    16_A      E      39          1.139
LGA    G    17_A      A      40          1.692
LGA    V    18_A      L      41          1.662
LGA    N    19_A      E      42          1.312
LGA    A    20_A      N      43          3.514
LGA    G    21_A      -       -           -
LGA    I    22_A      T      44           #
LGA    G    23_A      E      45          1.958
LGA    G    24_A      V      46          1.351
LGA    P    25_A      P      47          0.660
LGA    F    26_A      V      48          0.329
LGA    G    27_A      G      49          0.716
LGA    A    28_A      C      50          0.755
LGA    V    29_A      L      51          0.498
LGA    I    30_A      M      52          0.414
LGA    V    31_A      V      53          0.208
LGA    K    32_A      Y      54          0.653
LGA    D    33_A      N      55          0.996
LGA    G    34_A      N      56          1.439
LGA    A    35_A      E      57          2.036
LGA    I    36_A      V      58          1.102
LGA    I    37_A      V      59          1.318
LGA    A    38_A      G      60          1.129
LGA    E    39_A      K      61          0.377
LGA    G    40_A      G      62          0.316
LGA    Q    41_A      R      63          0.116
LGA    N    42_A      N      64          0.435
LGA    N    43_A      E      65          0.531
LGA    V    44_A      V      66          0.473
LGA    T    45_A      N      67          0.993
LGA    T    46_A      Q      68          0.748
LGA    S    47_A      T      69          0.448
LGA    N    48_A      K      70          1.250
LGA    D    49_A      N      71          0.993
LGA    P    50_A      A      72          0.671
LGA    T    51_A      T      73          0.635
LGA    A    52_A      R      74          0.397
LGA    H    53_A      H      75          0.415
LGA    A    54_A      A      76          0.602
LGA    E    55_A      E      77          0.735
LGA    V    56_A      M      78          1.063
LGA    T    57_A      V      79          0.911
LGA    A    58_A      A      80          0.525
LGA    I    59_A      I      81          0.931
LGA    R    60_A      D      82          1.323
LGA    K    61_A      Q      83          1.090
LGA    A    62_A      V      84          0.673
LGA    C    63_A      L      85          1.065
LGA    K    64_A      D      86          1.488
LGA    V    65_A      W      87          1.130
LGA    L    66_A      C      88          0.796
LGA    G    67_A      R      89          2.475
LGA    A    68_A      Q      90           -
LGA    -       -      S      91           -
LGA    -       -      G      92           -
LGA    -       -      K      93           -
LGA    Y    69_A      S      94           #
LGA    Q    70_A      P      95          3.390
LGA    L    71_A      S      96          5.127
LGA    D    72_A      E      97          3.337
LGA    -       -      V      98           -
LGA    -       -      F      99           -
LGA    -       -      E     100           -
LGA    D    73_A      H     101          1.340
LGA    C    74_A      T     102          0.948
LGA    I    75_A      V     103          0.912
LGA    L    76_A      L     104          0.782
LGA    Y    77_A      Y     105          0.822
LGA    T    78_A      V     106          0.696
LGA    S    79_A      T     107          0.687
LGA    C    80_A      V     108          0.942
LGA    E    81_A      E     109          0.978
LGA    P    82_A      P     110          0.543
LGA    C    83_A      C     111          0.600
LGA    P    84_A      I     112          0.356
LGA    M    85_A      M     113          0.582
LGA    C    86_A      C     114          0.654
LGA    L    87_A      A     115          0.150
LGA    G    88_A      A     116          0.833
LGA    A    89_A      A     117          1.100
LGA    I    90_A      L     118          0.556
LGA    Y    91_A      R     119          0.947
LGA    W    92_A      L     120          1.421
LGA    A    93_A      M     121          1.251
LGA    R    94_A      K     122          1.358
LGA    P    95_A      I     123          1.773
LGA    K    96_A      P     124          2.266
LGA    A    97_A      L     125          1.095
LGA    V    98_A      V     126          0.933
LGA    F    99_A      V     127          0.783
LGA    Y   100_A      Y     128          0.539
LGA    A   101_A      G     129          1.112
LGA    A   102_A      C     130          1.119
LGA    E   103_A      Q     131          1.192
LGA    H   104_A      N     132          1.454
LGA    T   105_A      E     133          2.997
LGA    D   106_A      -       -           -
LGA    A   107_A      -       -           -
LGA    A   108_A      -       -           -
LGA    E   109_A      -       -           -
LGA    A   110_A      -       -           -
LGA    G   111_A      -       -           -
LGA    F   112_A      -       -           -
LGA    D   113_A      R     134          3.421
LGA    D   114_A      F     135          1.557
LGA    S   115_A      G     136          4.695
LGA    F   116_A      G     137           -
LGA    I   117_A      C     138           -
LGA    -       -      G     139           -
LGA    -       -      S     140           -
LGA    Y   118_A      V     141          3.352
LGA    K   119_A      L     142           #
LGA    E   120_A      N     143           -
LGA    I   121_A      I     144           #
LGA    D   122_A      A     145           -
LGA    K   123_A      S     146           -
LGA    P   124_A      A     147           -
LGA    A   125_A      D     148           -
LGA    E   126_A      L     149           -
LGA    E   127_A      P     150           -
LGA    R   128_A      N     151           -
LGA    T   129_A      T     152           -
LGA    I   130_A      -       -           -
LGA    P   131_A      -       -           -
LGA    F   132_A      -       -           -
LGA    Y   133_A      -       -           -
LGA    Q   134_A      -       -           -
LGA    V   135_A      -       -           -
LGA    T   136_A      -       -           -
LGA    L   137_A      -       -           -
LGA    T   138_A      -       -           -
LGA    E   139_A      -       -           -
LGA    H   140_A      -       -           -
LGA    L   141_A      -       -           -
LGA    S   142_A      -       -           -
LGA    P   143_A      -       -           -
LGA    F   144_A      -       -           -
LGA    Q   145_A      -       -           -
LGA    A   146_A      -       -           -
LGA    W   147_A      -       -           -
LGA    R   148_A      -       -           -
LGA    N   149_A      -       -           -
LGA    F   150_A      -       -           -
LGA    A   151_A      -       -           -
LGA    N   152_A      -       -           -
LGA    K   153_A      -       -           -
LGA    K   154_A      -       -           -
LGA    E   155_A      -       -           -
LGA    Y   156_A      G     153           #
LGA    -       -      R     154           -
LGA    -       -      P     155           -
LGA    -       -      F     156           -
LGA    -       -      Q     157           -
LGA    -       -      C     158           -
LGA    -       -      I     159           -
LGA    -       -      P     160           -
LGA    -       -      G     161           -
LGA    -       -      Y     162           -
LGA    -       -      R     163           -
LGA    -       -      A     164           -
LGA    -       -      E     165           -
LGA    -       -      E     166           -
LGA    -       -      A     167           -
LGA    -       -      V     168           -
LGA    -       -      E     169           -
LGA    -       -      M     170           -
LGA    -       -      L     171           -
LGA    -       -      K     172           -
LGA    -       -      T     173           -
LGA    -       -      F     174           -
LGA    -       -      Y     175           -
LGA    -       -      K     176           -
LGA    -       -      Q     177           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  158  162    5.0    105    1.60    24.76     61.088     6.169

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.726123 * X  +   0.033347 * Y  +   0.686755 * Z  +  29.242270
  Y_new =   0.175839 * X  +   0.974614 * Y  +   0.138595 * Z  +   3.795928
  Z_new =  -0.664700 * X  +   0.221396 * Y  +  -0.713553 * Z  + 168.897705 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.840739   -0.300854  [ DEG:   162.7623    -17.2376 ]
  Theta =   0.727092    2.414501  [ DEG:    41.6593    138.3407 ]
  Phi   =   2.904004   -0.237588  [ DEG:   166.3872    -13.6128 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wkq_A                                        
REMARK     2: T0461.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wkq_A.T0461.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  158  162   5.0  105   1.60   24.76  61.088
REMARK  ---------------------------------------------------------- 
MOLECULE 1wkq_A
HEADER    HYDROLASE                               01-JUN-04   1WKQ              
TITLE     CRYSTAL STRUCTURE OF BACILLUS SUBTILIS GUANINE DEAMINASE.             
TITLE    2 THE FIRST DOMAIN-SWAPPED STRUCTURE IN THE CYTIDINE                   
TITLE    3 DEAMINASE SUPERFAMILY                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GUANINE DEAMINASE;                                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: GUANASE, GUANINE AMINASE, GUANINE AMINOHYDROLASE,           
COMPND   5 GAH, GDEASE;                                                         
COMPND   6 EC: 3.5.4.3;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: GUANINE DEAMINASE;                                             
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 PLYSS;                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET6H                                     
KEYWDS    GUANINE DEAMINASE, DOMAIN SWAP, THE CYTIDINE DEAMINASE                
KEYWDS   2 SUPERFAMILY, SUBSTRATE SPECIFICITY, STRUCTURAL PLASTICITY            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.H.LIAW,Y.J.CHANG,C.T.LAI                                            
REVDAT   2   07-SEP-04 1WKQ    1       JRNL                                     
REVDAT   1   13-JUL-04 1WKQ    0                                                
JRNL        AUTH   S.H.LIAW,Y.J.CHANG,C.T.LAI,H.C.CHANG,G.G.CHANG               
JRNL        TITL   CRYSTAL STRUCTURE OF BACILLUS SUBTILIS GUANINE               
JRNL        TITL 2 DEAMINASE: THE FIRST DOMAIN-SWAPPED STRUCTURE IN             
JRNL        TITL 3 THE CYTIDINE DEAMINASE SUPERFAMILY                           
JRNL        REF    J.BIOL.CHEM.                  V. 279 35479 2004              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.17 ANGSTROMS.                                          
DBREF  1WKQ A    1   156  UNP    O34598   GUAD_BACSU       1    156             
DBREF  1WKQ B    1   156  UNP    O34598   GUAD_BACSU       1    156             
SEQRES   1 A  164  MET HIS HIS HIS HIS HIS HIS ALA MET ASN HIS GLU THR          
SEQRES   2 A  164  PHE LEU LYS ARG ALA VAL THR LEU ALA CYS GLU GLY VAL          
SEQRES   3 A  164  ASN ALA GLY ILE GLY GLY PRO PHE GLY ALA VAL ILE VAL          
SEQRES   4 A  164  LYS ASP GLY ALA ILE ILE ALA GLU GLY GLN ASN ASN VAL          
SEQRES   5 A  164  THR THR SER ASN ASP PRO THR ALA HIS ALA GLU VAL THR          
SEQRES   6 A  164  ALA ILE ARG LYS ALA CYS LYS VAL LEU GLY ALA TYR GLN          
SEQRES   7 A  164  LEU ASP ASP CYS ILE LEU TYR THR SER CYS GLU PRO CYS          
SEQRES   8 A  164  PRO MET CYS LEU GLY ALA ILE TYR TRP ALA ARG PRO LYS          
SEQRES   9 A  164  ALA VAL PHE TYR ALA ALA GLU HIS THR ASP ALA ALA GLU          
SEQRES  10 A  164  ALA GLY PHE ASP ASP SER PHE ILE TYR LYS GLU ILE ASP          
SEQRES  11 A  164  LYS PRO ALA GLU GLU ARG THR ILE PRO PHE TYR GLN VAL          
SEQRES  12 A  164  THR LEU THR GLU HIS LEU SER PRO PHE GLN ALA TRP ARG          
SEQRES  13 A  164  ASN PHE ALA ASN LYS LYS GLU TYR                              
SEQRES   1 B  164  MET HIS HIS HIS HIS HIS HIS ALA MET ASN HIS GLU THR          
SEQRES   2 B  164  PHE LEU LYS ARG ALA VAL THR LEU ALA CYS GLU GLY VAL          
SEQRES   3 B  164  ASN ALA GLY ILE GLY GLY PRO PHE GLY ALA VAL ILE VAL          
SEQRES   4 B  164  LYS ASP GLY ALA ILE ILE ALA GLU GLY GLN ASN ASN VAL          
SEQRES   5 B  164  THR THR SER ASN ASP PRO THR ALA HIS ALA GLU VAL THR          
SEQRES   6 B  164  ALA ILE ARG LYS ALA CYS LYS VAL LEU GLY ALA TYR GLN          
SEQRES   7 B  164  LEU ASP ASP CYS ILE LEU TYR THR SER CYS GLU PRO CYS          
SEQRES   8 B  164  PRO MET CYS LEU GLY ALA ILE TYR TRP ALA ARG PRO LYS          
SEQRES   9 B  164  ALA VAL PHE TYR ALA ALA GLU HIS THR ASP ALA ALA GLU          
SEQRES  10 B  164  ALA GLY PHE ASP ASP SER PHE ILE TYR LYS GLU ILE ASP          
SEQRES  11 B  164  LYS PRO ALA GLU GLU ARG THR ILE PRO PHE TYR GLN VAL          
SEQRES  12 B  164  THR LEU THR GLU HIS LEU SER PRO PHE GLN ALA TRP ARG          
SEQRES  13 B  164  ASN PHE ALA ASN LYS LYS GLU TYR                              
HET     ZN  A 201       1                                                       
HET     ZN  B 202       1                                                       
HET    IMD   1301       5                                                       
HET    IMD   1302       5                                                       
HETNAM      ZN ZINC ION                                                         
HETNAM     IMD IMIDAZOLE                                                        
FORMUL   3   ZN    2(ZN 2+)                                                     
FORMUL   5  IMD    2(C3 H5 N2 1+)                                               
FORMUL   7  HOH   *450(H2 O)                                                    
CRYST1   81.566   91.267   80.481  90.00  90.00  90.00 C 2 2 21     16          
ATOM      1  N   HIS A  -2      12.642  33.581  52.772  1.00 24.27           N  
ATOM      2  CA  HIS A  -2      11.719  33.346  51.636  1.00 22.83           C  
ATOM      3  C   HIS A  -2      11.276  31.888  51.603  1.00 21.43           C  
ATOM      4  O   HIS A  -2      12.067  31.000  51.288  1.00 24.30           O  
ATOM      5  CB  HIS A  -2      12.423  33.685  50.325  1.00 25.89           C  
ATOM      6  CG  HIS A  -2      11.537  34.374  49.342  1.00 24.56           C  
ATOM      7  ND1 HIS A  -2      11.567  35.740  49.148  1.00 25.90           N  
ATOM      8  CD2 HIS A  -2      10.522  33.905  48.583  1.00 26.01           C  
ATOM      9  CE1 HIS A  -2      10.599  36.082  48.319  1.00 21.56           C  
ATOM     10  NE2 HIS A  -2       9.947  34.987  47.962  1.00 22.19           N  
ATOM     11  N   ALA A  -1      10.020  31.644  51.943  1.00 19.33           N  
ATOM     12  CA  ALA A  -1       9.483  30.300  51.926  1.00 18.17           C  
ATOM     13  C   ALA A  -1       9.410  29.840  50.480  1.00 17.44           C  
ATOM     14  O   ALA A  -1       9.063  30.640  49.600  1.00 18.55           O  
ATOM     15  CB  ALA A  -1       8.118  30.321  52.502  1.00 21.19           C  
ATOM     16  N   MET A   1       9.735  28.577  50.216  1.00 14.11           N  
ATOM     17  CA  MET A   1       9.659  28.031  48.862  1.00 13.88           C  
ATOM     18  C   MET A   1       8.444  27.120  48.771  1.00 12.11           C  
ATOM     19  O   MET A   1       7.890  26.681  49.787  1.00 11.22           O  
ATOM     20  CB  MET A   1      10.920  27.201  48.529  1.00 15.05           C  
ATOM     21  CG  MET A   1      12.230  27.979  48.526  1.00 21.43           C  
ATOM     22  SD  MET A   1      12.296  29.273  47.281  1.00 29.46           S  
ATOM     23  CE  MET A   1      12.601  28.368  45.969  1.00 23.42           C  
ATOM     24  N   ASN A   2       7.982  26.895  47.553  1.00 10.86           N  
ATOM     25  CA  ASN A   2       6.907  25.956  47.334  1.00 10.61           C  
ATOM     26  C   ASN A   2       7.079  25.346  45.947  1.00  9.63           C  
ATOM     27  O   ASN A   2       8.021  25.701  45.227  1.00 10.87           O  
ATOM     28  CB  ASN A   2       5.515  26.591  47.553  1.00 13.08           C  
ATOM     29  CG  ASN A   2       5.157  27.702  46.585  1.00 18.97           C  
ATOM     30  OD1 ASN A   2       4.137  28.379  46.802  1.00 25.21           O  
ATOM     31  ND2 ASN A   2       5.930  27.904  45.540  1.00 14.26           N  
ATOM     32  N   HIS A   3       6.203  24.422  45.594  1.00 10.33           N  
ATOM     33  CA  HIS A   3       6.371  23.771  44.305  1.00  9.64           C  
ATOM     34  C   HIS A   3       6.288  24.752  43.152  1.00 10.19           C  
ATOM     35  O   HIS A   3       7.035  24.619  42.146  1.00 10.85           O  
ATOM     36  CB  HIS A   3       5.346  22.638  44.169  1.00 10.14           C  
ATOM     37  CG  HIS A   3       5.507  21.569  45.211  1.00  8.92           C  
ATOM     38  ND1 HIS A   3       6.711  20.966  45.466  1.00  9.72           N  
ATOM     39  CD2 HIS A   3       4.613  21.007  46.069  1.00 10.59           C  
ATOM     40  CE1 HIS A   3       6.567  20.076  46.435  1.00 10.79           C  
ATOM     41  NE2 HIS A   3       5.301  20.084  46.811  1.00 10.16           N  
ATOM     42  N   GLU A   4       5.408  25.730  43.258  1.00 10.90           N  
ATOM     43  CA  GLU A   4       5.248  26.689  42.191  1.00 10.70           C  
ATOM     44  C   GLU A   4       6.519  27.468  41.970  1.00  9.94           C  
ATOM     45  O   GLU A   4       6.814  27.853  40.826  1.00 12.12           O  
ATOM     46  CB  GLU A   4       4.125  27.667  42.516  1.00 14.09           C  
ATOM     47  CG  GLU A   4       2.762  27.058  42.539  1.00 20.14           C  
ATOM     48  CD  GLU A   4       1.747  28.008  43.112  1.00 26.32           C  
ATOM     49  OE1 GLU A   4       1.712  29.172  42.651  1.00 29.69           O  
ATOM     50  OE2 GLU A   4       1.001  27.583  44.030  1.00 30.49           O  
ATOM     51  N   THR A   5       7.282  27.766  43.020  1.00 10.50           N  
ATOM     52  CA  THR A   5       8.499  28.527  42.825  1.00 13.04           C  
ATOM     53  C   THR A   5       9.539  27.743  42.036  1.00 10.15           C  
ATOM     54  O   THR A   5      10.202  28.310  41.141  1.00 10.07           O  
ATOM     55  CB  THR A   5       9.036  29.052  44.158  1.00 17.16           C  
ATOM     56  OG1 THR A   5       8.028  29.911  44.732  1.00 22.98           O  
ATOM     57  CG2 THR A   5      10.310  29.872  43.954  1.00 17.83           C  
ATOM     58  N   PHE A   6       9.691  26.446  42.302  1.00  9.60           N  
ATOM     59  CA  PHE A   6      10.638  25.667  41.512  1.00  8.58           C  
ATOM     60  C   PHE A   6      10.144  25.508  40.090  1.00  7.79           C  
ATOM     61  O   PHE A   6      10.947  25.529  39.133  1.00  9.08           O  
ATOM     62  CB  PHE A   6      10.866  24.314  42.151  1.00  9.16           C  
ATOM     63  CG  PHE A   6      11.564  24.414  43.485  1.00  8.70           C  
ATOM     64  CD1 PHE A   6      12.839  24.972  43.576  1.00 10.54           C  
ATOM     65  CD2 PHE A   6      10.950  23.939  44.635  1.00 10.47           C  
ATOM     66  CE1 PHE A   6      13.495  25.036  44.815  1.00 11.90           C  
ATOM     67  CE2 PHE A   6      11.603  24.004  45.884  1.00 11.54           C  
ATOM     68  CZ  PHE A   6      12.867  24.546  45.967  1.00 12.39           C  
ATOM     69  N   LEU A   7       8.834  25.348  39.916  1.00  7.41           N  
ATOM     70  CA  LEU A   7       8.270  25.241  38.554  1.00  7.97           C  
ATOM     71  C   LEU A   7       8.463  26.549  37.798  1.00  8.87           C  
ATOM     72  O   LEU A   7       8.717  26.551  36.575  1.00  8.99           O  
ATOM     73  CB  LEU A   7       6.781  24.913  38.588  1.00 10.17           C  
ATOM     74  CG  LEU A   7       6.448  23.454  38.873  1.00 11.14           C  
ATOM     75  CD1 LEU A   7       4.974  23.315  39.033  1.00 13.62           C  
ATOM     76  CD2 LEU A   7       6.958  22.535  37.723  1.00 11.09           C  
ATOM     77  N   LYS A   8       8.323  27.689  38.474  1.00  8.66           N  
ATOM     78  CA  LYS A   8       8.545  28.944  37.761  1.00  9.76           C  
ATOM     79  C   LYS A   8       9.997  29.007  37.306  1.00  8.29           C  
ATOM     80  O   LYS A   8      10.280  29.560  36.231  1.00  9.51           O  
ATOM     81  CB  LYS A   8       8.238  30.117  38.673  1.00 12.19           C  
ATOM     82  CG  LYS A   8       6.770  30.321  38.925  1.00 19.82           C  
ATOM     83  CD  LYS A   8       6.595  31.450  39.915  1.00 22.25           C  
ATOM     84  CE  LYS A   8       5.136  31.703  40.170  1.00 24.90           C  
ATOM     85  NZ  LYS A   8       4.957  32.798  41.162  1.00 27.44           N  
ATOM     86  N   ARG A   9      10.936  28.502  38.096  1.00  7.61           N  
ATOM     87  CA  ARG A   9      12.327  28.513  37.646  1.00  8.13           C  
ATOM     88  C   ARG A   9      12.461  27.653  36.378  1.00  7.28           C  
ATOM     89  O   ARG A   9      13.185  28.015  35.448  1.00  7.74           O  
ATOM     90  CB  ARG A   9      13.263  28.018  38.750  1.00  8.92           C  
ATOM     91  CG  ARG A   9      14.721  27.913  38.324  1.00  7.99           C  
ATOM     92  CD  ARG A   9      15.314  29.275  37.856  1.00  8.71           C  
ATOM     93  NE  ARG A   9      16.689  29.054  37.434  1.00  9.21           N  
ATOM     94  CZ  ARG A   9      17.382  29.910  36.679  1.00  9.61           C  
ATOM     95  NH1 ARG A   9      16.824  31.050  36.300  1.00 10.13           N  
ATOM     96  NH2 ARG A   9      18.610  29.571  36.261  1.00  9.56           N  
ATOM     97  N   ALA A  10      11.775  26.519  36.343  1.00  6.65           N  
ATOM     98  CA  ALA A  10      11.804  25.649  35.160  1.00  6.68           C  
ATOM     99  C   ALA A  10      11.219  26.374  33.943  1.00  6.81           C  
ATOM    100  O   ALA A  10      11.765  26.255  32.832  1.00  6.68           O  
ATOM    101  CB  ALA A  10      11.040  24.350  35.424  1.00  7.13           C  
ATOM    102  N   VAL A  11      10.127  27.118  34.134  1.00  6.72           N  
ATOM    103  CA  VAL A  11       9.528  27.884  33.043  1.00  7.60           C  
ATOM    104  C   VAL A  11      10.490  28.990  32.583  1.00  6.89           C  
ATOM    105  O   VAL A  11      10.637  29.228  31.382  1.00  7.81           O  
ATOM    106  CB  VAL A  11       8.170  28.458  33.493  1.00  7.86           C  
ATOM    107  CG1 VAL A  11       7.672  29.493  32.482  1.00 10.96           C  
ATOM    108  CG2 VAL A  11       7.178  27.307  33.652  1.00 10.04           C  
ATOM    109  N   THR A  12      11.142  29.678  33.515  1.00  7.73           N  
ATOM    110  CA  THR A  12      12.133  30.700  33.145  1.00  8.44           C  
ATOM    111  C   THR A  12      13.255  30.059  32.330  1.00  7.90           C  
ATOM    112  O   THR A  12      13.679  30.616  31.302  1.00  8.16           O  
ATOM    113  CB  THR A  12      12.708  31.353  34.411  1.00  9.71           C  
ATOM    114  OG1 THR A  12      11.648  32.085  35.038  1.00 11.91           O  
ATOM    115  CG2 THR A  12      13.890  32.295  34.083  1.00  9.81           C  
ATOM    116  N   LEU A  13      13.732  28.894  32.760  1.00  8.01           N  
ATOM    117  CA  LEU A  13      14.802  28.223  32.025  1.00  7.40           C  
ATOM    118  C   LEU A  13      14.355  27.884  30.603  1.00  6.79           C  
ATOM    119  O   LEU A  13      15.142  27.970  29.652  1.00  6.57           O  
ATOM    120  CB  LEU A  13      15.214  26.940  32.762  1.00  8.42           C  
ATOM    121  CG  LEU A  13      16.151  27.143  33.978  1.00  7.69           C  
ATOM    122  CD1 LEU A  13      16.076  25.931  34.878  1.00  9.69           C  
ATOM    123  CD2 LEU A  13      17.592  27.430  33.517  1.00  9.58           C  
ATOM    124  N   ALA A  14      13.100  27.480  30.453  1.00  6.43           N  
ATOM    125  CA  ALA A  14      12.545  27.158  29.127  1.00  6.49           C  
ATOM    126  C   ALA A  14      12.539  28.410  28.232  1.00  6.14           C  
ATOM    127  O   ALA A  14      12.970  28.347  27.074  1.00  7.38           O  
ATOM    128  CB  ALA A  14      11.120  26.619  29.286  1.00  5.83           C  
ATOM    129  N   CYS A  15      12.062  29.532  28.750  1.00  6.57           N  
ATOM    130  CA  CYS A  15      12.051  30.766  27.963  1.00  6.99           C  
ATOM    131  C   CYS A  15      13.445  31.238  27.614  1.00  7.28           C  
ATOM    132  O   CYS A  15      13.724  31.629  26.470  1.00  7.78           O  
ATOM    133  CB  CYS A  15      11.335  31.886  28.735  1.00  8.13           C  
ATOM    134  SG  CYS A  15       9.568  31.666  28.972  1.00  9.27           S  
ATOM    135  N   GLU A  16      14.338  31.234  28.594  1.00  7.00           N  
ATOM    136  CA  GLU A  16      15.691  31.700  28.367  1.00  8.26           C  
ATOM    137  C   GLU A  16      16.497  30.757  27.504  1.00  6.82           C  
ATOM    138  O   GLU A  16      17.391  31.217  26.783  1.00  8.03           O  
ATOM    139  CB  GLU A  16      16.357  32.006  29.714  1.00  8.18           C  
ATOM    140  CG  GLU A  16      15.604  33.118  30.465  1.00  9.89           C  
ATOM    141  CD  GLU A  16      16.253  33.658  31.744  1.00 10.93           C  
ATOM    142  OE1 GLU A  16      15.697  34.669  32.282  1.00 12.17           O  
ATOM    143  OE2 GLU A  16      17.264  33.089  32.215  1.00 14.02           O  
ATOM    144  N   GLY A  17      16.185  29.457  27.535  1.00  7.25           N  
ATOM    145  CA  GLY A  17      16.841  28.485  26.659  1.00  6.22           C  
ATOM    146  C   GLY A  17      16.454  28.742  25.200  1.00  6.17           C  
ATOM    147  O   GLY A  17      17.296  28.665  24.300  1.00  7.73           O  
ATOM    148  N   VAL A  18      15.183  29.022  24.954  1.00  6.17           N  
ATOM    149  CA  VAL A  18      14.756  29.399  23.608  1.00  5.60           C  
ATOM    150  C   VAL A  18      15.485  30.674  23.183  1.00  6.43           C  
ATOM    151  O   VAL A  18      16.124  30.715  22.114  1.00  5.93           O  
ATOM    152  CB  VAL A  18      13.236  29.684  23.563  1.00  6.10           C  
ATOM    153  CG1 VAL A  18      12.852  30.366  22.247  1.00  6.77           C  
ATOM    154  CG2 VAL A  18      12.486  28.375  23.750  1.00  7.02           C  
ATOM    155  N   ASN A  19      15.425  31.718  24.018  1.00  6.24           N  
ATOM    156  CA  ASN A  19      15.954  33.025  23.609  1.00  7.48           C  
ATOM    157  C   ASN A  19      17.464  33.108  23.481  1.00  7.18           C  
ATOM    158  O   ASN A  19      17.977  33.956  22.718  1.00  8.20           O  
ATOM    159  CB  ASN A  19      15.394  34.114  24.536  1.00  8.32           C  
ATOM    160  CG  ASN A  19      13.909  34.354  24.329  1.00 10.34           C  
ATOM    161  OD1 ASN A  19      13.245  34.948  25.177  1.00 15.67           O  
ATOM    162  ND2 ASN A  19      13.371  33.905  23.217  1.00 10.86           N  
ATOM    163  N   ALA A  20      18.184  32.228  24.171  1.00  6.57           N  
ATOM    164  CA  ALA A  20      19.640  32.178  24.061  1.00  7.52           C  
ATOM    165  C   ALA A  20      20.058  31.195  22.958  1.00  6.98           C  
ATOM    166  O   ALA A  20      21.241  30.904  22.788  1.00  9.24           O  
ATOM    167  CB  ALA A  20      20.276  31.804  25.410  1.00  9.50           C  
ATOM    168  N   GLY A  21      19.105  30.648  22.219  1.00  7.21           N  
ATOM    169  CA  GLY A  21      19.440  29.735  21.139  1.00  8.35           C  
ATOM    170  C   GLY A  21      19.893  28.357  21.573  1.00 10.41           C  
ATOM    171  O   GLY A  21      20.393  27.612  20.730  1.00 14.25           O  
ATOM    172  N   ILE A  22      19.703  27.985  22.839  1.00  7.46           N  
ATOM    173  CA  ILE A  22      20.135  26.689  23.338  1.00  7.42           C  
ATOM    174  C   ILE A  22      19.266  25.549  22.773  1.00  6.05           C  
ATOM    175  O   ILE A  22      19.777  24.503  22.382  1.00  7.05           O  
ATOM    176  CB  ILE A  22      20.103  26.731  24.871  1.00  7.58           C  
ATOM    177  CG1 ILE A  22      21.173  27.720  25.379  1.00  8.87           C  
ATOM    178  CG2 ILE A  22      20.418  25.323  25.460  1.00  7.97           C  
ATOM    179  CD1 ILE A  22      21.085  28.013  26.857  1.00 11.08           C  
ATOM    180  N   GLY A  23      17.962  25.744  22.739  1.00  6.37           N  
ATOM    181  CA  GLY A  23      17.127  24.704  22.200  1.00  6.81           C  
ATOM    182  C   GLY A  23      15.660  25.044  22.337  1.00  5.36           C  
ATOM    183  O   GLY A  23      15.264  26.213  22.258  1.00  5.55           O  
ATOM    184  N   GLY A  24      14.847  24.016  22.575  1.00  5.49           N  
ATOM    185  CA  GLY A  24      13.407  24.136  22.628  1.00  6.17           C  
ATOM    186  C   GLY A  24      12.848  24.736  23.904  1.00  5.27           C  
ATOM    187  O   GLY A  24      13.544  24.923  24.906  1.00  5.92           O  
ATOM    188  N   PRO A  25      11.538  24.993  23.889  1.00  5.61           N  
ATOM    189  CA  PRO A  25      10.810  25.641  25.012  1.00  5.76           C  
ATOM    190  C   PRO A  25      10.508  24.783  26.198  1.00  5.94           C  
ATOM    191  O   PRO A  25       9.374  24.659  26.616  1.00  6.48           O  
ATOM    192  CB  PRO A  25       9.536  26.156  24.324  1.00  6.67           C  
ATOM    193  CG  PRO A  25       9.259  25.107  23.262  1.00  6.25           C  
ATOM    194  CD  PRO A  25      10.654  24.721  22.729  1.00  6.97           C  
ATOM    195  N   PHE A  26      11.564  24.229  26.777  1.00  6.20           N  
ATOM    196  CA  PHE A  26      11.434  23.292  27.906  1.00  5.51           C  
ATOM    197  C   PHE A  26      12.621  23.462  28.852  1.00  6.15           C  
ATOM    198  O   PHE A  26      13.787  23.556  28.428  1.00  6.12           O  
ATOM    199  CB  PHE A  26      11.404  21.840  27.374  1.00  6.82           C  
ATOM    200  CG  PHE A  26      10.323  21.599  26.389  1.00  5.80           C  
ATOM    201  CD1 PHE A  26      10.542  21.732  25.017  1.00  5.36           C  
ATOM    202  CD2 PHE A  26       9.039  21.272  26.822  1.00  6.86           C  
ATOM    203  CE1 PHE A  26       9.478  21.544  24.108  1.00  6.71           C  
ATOM    204  CE2 PHE A  26       7.966  21.083  25.912  1.00  7.89           C  
ATOM    205  CZ  PHE A  26       8.211  21.227  24.558  1.00  6.84           C  
ATOM    206  N   GLY A  27      12.307  23.465  30.145  1.00  6.50           N  
ATOM    207  CA  GLY A  27      13.311  23.601  31.201  1.00  6.15           C  
ATOM    208  C   GLY A  27      12.930  22.674  32.360  1.00  6.24           C  
ATOM    209  O   GLY A  27      11.753  22.286  32.507  1.00  6.84           O  
ATOM    210  N   ALA A  28      13.903  22.353  33.207  1.00  6.31           N  
ATOM    211  CA  ALA A  28      13.651  21.442  34.329  1.00  6.37           C  
ATOM    212  C   ALA A  28      14.667  21.691  35.420  1.00  6.96           C  
ATOM    213  O   ALA A  28      15.788  22.146  35.166  1.00  8.08           O  
ATOM    214  CB  ALA A  28      13.758  19.992  33.844  1.00  6.89           C  
ATOM    215  N   VAL A  29      14.265  21.414  36.651  1.00  7.25           N  
ATOM    216  CA  VAL A  29      15.210  21.536  37.754  1.00  7.99           C  
ATOM    217  C   VAL A  29      15.018  20.352  38.682  1.00  7.80           C  
ATOM    218  O   VAL A  29      13.922  19.817  38.799  1.00  8.37           O  
ATOM    219  CB  VAL A  29      15.077  22.839  38.590  1.00 11.47           C  
ATOM    220  CG1 VAL A  29      15.142  24.057  37.676  1.00 12.65           C  
ATOM    221  CG2 VAL A  29      13.842  22.871  39.348  1.00 11.93           C  
ATOM    222  N   ILE A  30      16.117  19.932  39.298  1.00  8.12           N  
ATOM    223  CA  ILE A  30      16.097  18.831  40.278  1.00  7.67           C  
ATOM    224  C   ILE A  30      16.447  19.400  41.638  1.00  7.50           C  
ATOM    225  O   ILE A  30      17.440  20.126  41.786  1.00  8.24           O  
ATOM    226  CB  ILE A  30      17.026  17.734  39.847  1.00  9.30           C  
ATOM    227  CG1 ILE A  30      16.397  17.103  38.578  1.00 14.62           C  
ATOM    228  CG2 ILE A  30      17.115  16.630  40.930  1.00  9.30           C  
ATOM    229  CD1 ILE A  30      17.243  16.092  37.874  1.00 15.21           C  
ATOM    230  N   VAL A  31      15.600  19.077  42.615  1.00  7.81           N  
ATOM    231  CA  VAL A  31      15.725  19.636  43.958  1.00  8.90           C  
ATOM    232  C   VAL A  31      15.967  18.517  44.951  1.00  8.73           C  
ATOM    233  O   VAL A  31      15.358  17.455  44.879  1.00  9.53           O  
ATOM    234  CB  VAL A  31      14.397  20.370  44.319  1.00  9.25           C  
ATOM    235  CG1 VAL A  31      14.328  20.727  45.793  1.00 10.31           C  
ATOM    236  CG2 VAL A  31      14.259  21.605  43.452  1.00  8.98           C  
ATOM    237  N   LYS A  32      16.877  18.779  45.883  1.00  9.74           N  
ATOM    238  CA  LYS A  32      17.201  17.845  46.953  1.00  9.88           C  
ATOM    239  C   LYS A  32      17.430  18.682  48.203  1.00 11.01           C  
ATOM    240  O   LYS A  32      18.087  19.682  48.165  1.00 12.45           O  
ATOM    241  CB  LYS A  32      18.468  17.062  46.625  1.00 11.67           C  
ATOM    242  CG  LYS A  32      18.777  16.000  47.698  1.00 12.99           C  
ATOM    243  CD  LYS A  32      19.988  15.157  47.341  1.00 17.00           C  
ATOM    244  CE  LYS A  32      20.265  14.126  48.446  1.00 21.76           C  
ATOM    245  NZ  LYS A  32      21.464  13.303  48.142  1.00 24.18           N  
ATOM    246  N   ASP A  33      16.866  18.254  49.322  1.00 13.36           N  
ATOM    247  CA  ASP A  33      17.032  18.995  50.580  1.00 14.95           C  
ATOM    248  C   ASP A  33      16.588  20.471  50.414  1.00 12.12           C  
ATOM    249  O   ASP A  33      17.180  21.374  51.015  1.00 14.27           O  
ATOM    250  CB  ASP A  33      18.500  18.944  51.077  1.00 17.99           C  
ATOM    251  CG  ASP A  33      19.031  17.507  51.328  1.00 21.27           C  
ATOM    252  OD1 ASP A  33      18.327  16.667  51.923  1.00 23.26           O  
ATOM    253  OD2 ASP A  33      20.192  17.224  50.936  1.00 27.23           O  
ATOM    254  N   GLY A  34      15.556  20.709  49.609  1.00 12.93           N  
ATOM    255  CA  GLY A  34      15.038  22.059  49.440  1.00 13.15           C  
ATOM    256  C   GLY A  34      15.833  23.022  48.593  1.00 12.23           C  
ATOM    257  O   GLY A  34      15.500  24.214  48.544  1.00 14.43           O  
ATOM    258  N   ALA A  35      16.850  22.509  47.924  1.00 12.63           N  
ATOM    259  CA  ALA A  35      17.690  23.328  47.069  1.00 13.19           C  
ATOM    260  C   ALA A  35      17.846  22.708  45.683  1.00 11.76           C  
ATOM    261  O   ALA A  35      17.850  21.478  45.514  1.00 11.39           O  
ATOM    262  CB  ALA A  35      19.048  23.466  47.694  1.00 16.36           C  
ATOM    263  N   ILE A  36      17.986  23.579  44.689  1.00 11.66           N  
ATOM    264  CA  ILE A  36      18.212  23.107  43.316  1.00 11.75           C  
ATOM    265  C   ILE A  36      19.625  22.553  43.230  1.00 11.59           C  
ATOM    266  O   ILE A  36      20.585  23.237  43.614  1.00 13.87           O  
ATOM    267  CB  ILE A  36      18.068  24.267  42.303  1.00 12.14           C  
ATOM    268  CG1 ILE A  36      16.605  24.684  42.269  1.00 12.86           C  
ATOM    269  CG2 ILE A  36      18.588  23.859  40.904  1.00 11.85           C  
ATOM    270  CD1 ILE A  36      16.286  25.910  41.421  1.00 13.09           C  
ATOM    271  N   ILE A  37      19.772  21.317  42.760  1.00  9.89           N  
ATOM    272  CA  ILE A  37      21.090  20.745  42.584  1.00 11.93           C  
ATOM    273  C   ILE A  37      21.476  20.617  41.111  1.00 10.55           C  
ATOM    274  O   ILE A  37      22.650  20.415  40.793  1.00 12.08           O  
ATOM    275  CB  ILE A  37      21.262  19.390  43.291  1.00 12.22           C  
ATOM    276  CG1 ILE A  37      20.325  18.330  42.708  1.00 11.06           C  
ATOM    277  CG2 ILE A  37      21.059  19.576  44.792  1.00 13.63           C  
ATOM    278  CD1 ILE A  37      20.667  16.866  43.110  1.00 14.61           C  
ATOM    279  N   ALA A  38      20.516  20.749  40.186  1.00  8.86           N  
ATOM    280  CA  ALA A  38      20.845  20.716  38.748  1.00  9.33           C  
ATOM    281  C   ALA A  38      19.703  21.338  37.977  1.00  8.63           C  
ATOM    282  O   ALA A  38      18.538  21.246  38.384  1.00  8.31           O  
ATOM    283  CB  ALA A  38      21.053  19.268  38.259  1.00 11.21           C  
ATOM    284  N   GLU A  39      20.053  21.952  36.856  1.00  8.20           N  
ATOM    285  CA  GLU A  39      19.088  22.567  35.950  1.00  8.75           C  
ATOM    286  C   GLU A  39      19.302  22.040  34.548  1.00  7.66           C  
ATOM    287  O   GLU A  39      20.452  21.760  34.170  1.00  9.80           O  
ATOM    288  CB  GLU A  39      19.262  24.093  35.950  1.00  8.12           C  
ATOM    289  CG  GLU A  39      18.997  24.689  37.327  1.00 11.25           C  
ATOM    290  CD  GLU A  39      18.894  26.194  37.369  1.00 11.15           C  
ATOM    291  OE1 GLU A  39      19.543  26.882  36.560  1.00 12.43           O  
ATOM    292  OE2 GLU A  39      18.141  26.699  38.220  1.00 11.62           O  
ATOM    293  N   GLY A  40      18.223  21.919  33.766  1.00  6.47           N  
ATOM    294  CA  GLY A  40      18.368  21.508  32.385  1.00  6.44           C  
ATOM    295  C   GLY A  40      17.480  22.336  31.481  1.00  5.87           C  
ATOM    296  O   GLY A  40      16.399  22.783  31.866  1.00  7.21           O  
ATOM    297  N   GLN A  41      17.984  22.593  30.275  1.00  6.18           N  
ATOM    298  CA  GLN A  41      17.233  23.241  29.216  1.00  6.26           C  
ATOM    299  C   GLN A  41      17.272  22.307  27.997  1.00  6.03           C  
ATOM    300  O   GLN A  41      18.279  21.636  27.778  1.00  6.78           O  
ATOM    301  CB  GLN A  41      17.852  24.584  28.830  1.00  6.42           C  
ATOM    302  CG  GLN A  41      17.682  25.610  29.962  1.00  7.14           C  
ATOM    303  CD  GLN A  41      18.635  26.754  29.817  1.00  7.45           C  
ATOM    304  OE1 GLN A  41      19.852  26.563  29.852  1.00  8.85           O  
ATOM    305  NE2 GLN A  41      18.113  27.951  29.657  1.00  6.47           N  
ATOM    306  N   ASN A  42      16.194  22.220  27.220  1.00  5.62           N  
ATOM    307  CA  ASN A  42      16.270  21.409  26.002  1.00  5.82           C  
ATOM    308  C   ASN A  42      17.444  21.947  25.147  1.00  6.87           C  
ATOM    309  O   ASN A  42      17.597  23.173  24.947  1.00  6.26           O  
ATOM    310  CB  ASN A  42      14.966  21.520  25.238  1.00  6.02           C  
ATOM    311  CG  ASN A  42      15.015  20.773  23.930  1.00  5.33           C  
ATOM    312  OD1 ASN A  42      15.647  21.210  22.984  1.00  5.86           O  
ATOM    313  ND2 ASN A  42      14.383  19.596  23.890  1.00  6.41           N  
ATOM    314  N   ASN A  43      18.305  21.038  24.680  1.00  6.14           N  
ATOM    315  CA  ASN A  43      19.474  21.442  23.900  1.00  5.02           C  
ATOM    316  C   ASN A  43      19.721  20.464  22.752  1.00  6.23           C  
ATOM    317  O   ASN A  43      20.851  20.271  22.315  1.00  6.65           O  
ATOM    318  CB  ASN A  43      20.738  21.610  24.793  1.00  6.53           C  
ATOM    319  CG  ASN A  43      21.103  20.362  25.583  1.00  6.25           C  
ATOM    320  OD1 ASN A  43      22.059  19.650  25.240  1.00  8.46           O  
ATOM    321  ND2 ASN A  43      20.376  20.090  26.638  1.00  7.46           N  
ATOM    322  N   VAL A  44      18.636  19.908  22.204  1.00  5.55           N  
ATOM    323  CA  VAL A  44      18.722  18.941  21.118  1.00  5.86           C  
ATOM    324  C   VAL A  44      19.518  19.420  19.912  1.00  6.29           C  
ATOM    325  O   VAL A  44      20.466  18.742  19.463  1.00  6.98           O  
ATOM    326  CB  VAL A  44      17.300  18.540  20.687  1.00  6.00           C  
ATOM    327  CG1 VAL A  44      17.323  17.759  19.373  1.00  6.28           C  
ATOM    328  CG2 VAL A  44      16.639  17.689  21.797  1.00  6.61           C  
ATOM    329  N   THR A  45      19.158  20.572  19.371  1.00  6.62           N  
ATOM    330  CA  THR A  45      19.776  20.995  18.125  1.00  8.11           C  
ATOM    331  C   THR A  45      21.141  21.616  18.270  1.00 10.14           C  
ATOM    332  O   THR A  45      21.912  21.610  17.296  1.00 14.43           O  
ATOM    333  CB  THR A  45      18.821  21.920  17.327  1.00  8.27           C  
ATOM    334  OG1 THR A  45      18.675  23.165  18.032  1.00  8.55           O  
ATOM    335  CG2 THR A  45      17.450  21.274  17.127  1.00  8.02           C  
ATOM    336  N   THR A  46      21.484  22.103  19.445  1.00  7.94           N  
ATOM    337  CA  THR A  46      22.830  22.656  19.656  1.00  8.94           C  
ATOM    338  C   THR A  46      23.820  21.570  20.100  1.00 10.06           C  
ATOM    339  O   THR A  46      25.031  21.740  19.929  1.00 13.32           O  
ATOM    340  CB  THR A  46      22.796  23.815  20.663  1.00 10.81           C  
ATOM    341  OG1 THR A  46      22.150  23.380  21.861  1.00 10.27           O  
ATOM    342  CG2 THR A  46      22.040  24.993  20.079  1.00 12.57           C  
ATOM    343  N   SER A  47      23.349  20.462  20.670  1.00  8.19           N  
ATOM    344  CA  SER A  47      24.232  19.383  21.095  1.00  8.04           C  
ATOM    345  C   SER A  47      24.201  18.206  20.120  1.00  7.68           C  
ATOM    346  O   SER A  47      24.882  17.208  20.331  1.00  9.03           O  
ATOM    347  CB  SER A  47      23.820  18.861  22.462  1.00  9.03           C  
ATOM    348  OG  SER A  47      23.960  19.864  23.452  0.50  5.43           O  
ATOM    350  N   ASN A  48      23.435  18.306  19.044  1.00  7.16           N  
ATOM    351  CA  ASN A  48      23.269  17.181  18.096  1.00  7.91           C  
ATOM    352  C   ASN A  48      22.886  15.904  18.863  1.00  7.04           C  
ATOM    353  O   ASN A  48      23.490  14.839  18.702  1.00  8.26           O  
ATOM    354  CB  ASN A  48      24.561  16.954  17.272  1.00  8.81           C  
ATOM    355  CG  ASN A  48      24.687  17.926  16.103  1.00 10.48           C  
ATOM    356  OD1 ASN A  48      25.815  18.245  15.677  1.00 16.43           O  
ATOM    357  ND2 ASN A  48      23.587  18.366  15.577  1.00  8.57           N  
ATOM    358  N   ASP A  49      21.864  16.036  19.690  1.00  7.08           N  
ATOM    359  CA  ASP A  49      21.463  14.928  20.567  1.00  6.31           C  
ATOM    360  C   ASP A  49      19.952  14.973  20.766  1.00  6.67           C  
ATOM    361  O   ASP A  49      19.436  15.765  21.578  1.00  6.04           O  
ATOM    362  CB  ASP A  49      22.183  15.072  21.915  1.00  7.13           C  
ATOM    363  CG  ASP A  49      21.816  13.980  22.900  1.00  6.92           C  
ATOM    364  OD1 ASP A  49      21.009  13.099  22.531  1.00  7.39           O  
ATOM    365  OD2 ASP A  49      22.314  14.011  24.074  1.00  8.95           O  
ATOM    366  N   PRO A  50      19.211  14.143  20.036  1.00  6.75           N  
ATOM    367  CA  PRO A  50      17.747  14.134  20.173  1.00  6.22           C  
ATOM    368  C   PRO A  50      17.251  13.672  21.529  1.00  5.99           C  
ATOM    369  O   PRO A  50      16.068  13.805  21.846  1.00  7.00           O  
ATOM    370  CB  PRO A  50      17.279  13.249  19.014  1.00  7.39           C  
ATOM    371  CG  PRO A  50      18.465  12.306  18.807  1.00  7.27           C  
ATOM    372  CD  PRO A  50      19.705  13.147  19.069  1.00  6.97           C  
ATOM    373  N   THR A  51      18.162  13.148  22.360  1.00  5.92           N  
ATOM    374  CA  THR A  51      17.756  12.763  23.715  1.00  5.87           C  
ATOM    375  C   THR A  51      17.939  13.880  24.705  1.00  5.83           C  
ATOM    376  O   THR A  51      17.524  13.739  25.882  1.00  6.60           O  
ATOM    377  CB  THR A  51      18.539  11.497  24.250  1.00  6.67           C  
ATOM    378  OG1 THR A  51      19.914  11.802  24.553  1.00  6.62           O  
ATOM    379  CG2 THR A  51      18.479  10.394  23.194  1.00  8.57           C  
ATOM    380  N   ALA A  52      18.515  15.012  24.276  1.00  6.54           N  
ATOM    381  CA  ALA A  52      18.808  16.115  25.194  1.00  7.24           C  
ATOM    382  C   ALA A  52      17.639  17.024  25.550  1.00  6.16           C  
ATOM    383  O   ALA A  52      17.691  18.272  25.408  1.00  6.65           O  
ATOM    384  CB  ALA A  52      19.993  16.935  24.676  1.00  7.07           C  
ATOM    385  N   HIS A  53      16.562  16.391  26.005  1.00  6.20           N  
ATOM    386  CA  HIS A  53      15.415  17.129  26.516  1.00  5.63           C  
ATOM    387  C   HIS A  53      15.818  17.753  27.852  1.00  6.01           C  
ATOM    388  O   HIS A  53      16.815  17.365  28.479  1.00  6.90           O  
ATOM    389  CB  HIS A  53      14.205  16.199  26.673  1.00  5.47           C  
ATOM    390  CG  HIS A  53      13.506  15.928  25.371  1.00  5.13           C  
ATOM    391  ND1 HIS A  53      12.196  15.493  25.314  1.00  5.53           N  
ATOM    392  CD2 HIS A  53      13.937  16.048  24.086  1.00  6.35           C  
ATOM    393  CE1 HIS A  53      11.852  15.372  24.040  1.00  6.02           C  
ATOM    394  NE2 HIS A  53      12.884  15.696  23.280  1.00  6.19           N  
ATOM    395  N   ALA A  54      15.026  18.740  28.274  1.00  6.05           N  
ATOM    396  CA  ALA A  54      15.319  19.410  29.549  1.00  6.12           C  
ATOM    397  C   ALA A  54      15.415  18.411  30.697  1.00  5.86           C  
ATOM    398  O   ALA A  54      16.362  18.468  31.506  1.00  6.79           O  
ATOM    399  CB  ALA A  54      14.262  20.447  29.849  1.00  5.76           C  
ATOM    400  N   GLU A  55      14.468  17.489  30.793  1.00  5.82           N  
ATOM    401  CA  GLU A  55      14.462  16.538  31.899  1.00  6.37           C  
ATOM    402  C   GLU A  55      15.646  15.611  31.870  1.00  6.17           C  
ATOM    403  O   GLU A  55      16.258  15.349  32.914  1.00  6.94           O  
ATOM    404  CB  GLU A  55      13.172  15.701  31.877  1.00  6.99           C  
ATOM    405  CG  GLU A  55      11.882  16.493  31.987  1.00  8.25           C  
ATOM    406  CD  GLU A  55      11.306  16.805  30.609  1.00  7.49           C  
ATOM    407  OE1 GLU A  55      11.917  17.545  29.807  1.00  9.70           O  
ATOM    408  OE2 GLU A  55      10.199  16.260  30.285  1.00 10.61           O  
ATOM    409  N   VAL A  56      15.960  15.067  30.686  1.00  6.10           N  
ATOM    410  CA  VAL A  56      17.126  14.186  30.551  1.00  6.77           C  
ATOM    411  C   VAL A  56      18.404  14.909  30.918  1.00  6.82           C  
ATOM    412  O   VAL A  56      19.264  14.358  31.641  1.00  7.53           O  
ATOM    413  CB  VAL A  56      17.205  13.652  29.106  1.00  6.31           C  
ATOM    414  CG1 VAL A  56      18.550  13.011  28.824  1.00  7.53           C  
ATOM    415  CG2 VAL A  56      16.060  12.659  28.877  1.00  7.27           C  
ATOM    416  N   THR A  57      18.565  16.133  30.431  1.00  6.08           N  
ATOM    417  CA  THR A  57      19.779  16.879  30.748  1.00  6.93           C  
ATOM    418  C   THR A  57      19.883  17.150  32.255  1.00  7.25           C  
ATOM    419  O   THR A  57      20.962  16.989  32.840  1.00  7.67           O  
ATOM    420  CB  THR A  57      19.795  18.192  29.942  1.00  7.49           C  
ATOM    421  OG1 THR A  57      19.832  17.845  28.537  1.00  9.58           O  
ATOM    422  CG2 THR A  57      21.024  19.050  30.256  1.00 10.31           C  
ATOM    423  N   ALA A  58      18.779  17.547  32.884  1.00  6.50           N  
ATOM    424  CA  ALA A  58      18.809  17.788  34.318  1.00  6.42           C  
ATOM    425  C   ALA A  58      19.126  16.496  35.084  1.00  7.15           C  
ATOM    426  O   ALA A  58      19.943  16.531  36.033  1.00  7.80           O  
ATOM    427  CB  ALA A  58      17.483  18.375  34.762  1.00  7.44           C  
ATOM    428  N   ILE A  59      18.553  15.370  34.682  1.00  6.89           N  
ATOM    429  CA  ILE A  59      18.837  14.100  35.343  1.00  6.62           C  
ATOM    430  C   ILE A  59      20.306  13.747  35.196  1.00  8.02           C  
ATOM    431  O   ILE A  59      20.957  13.363  36.195  1.00  7.95           O  
ATOM    432  CB  ILE A  59      17.939  13.002  34.713  1.00  7.22           C  
ATOM    433  CG1 ILE A  59      16.512  13.171  35.209  1.00  7.99           C  
ATOM    434  CG2 ILE A  59      18.457  11.614  35.060  1.00  8.38           C  
ATOM    435  CD1 ILE A  59      15.493  12.328  34.416  1.00  8.16           C  
ATOM    436  N   ARG A  60      20.856  13.870  33.994  1.00  7.70           N  
ATOM    437  CA  ARG A  60      22.266  13.558  33.785  1.00  7.48           C  
ATOM    438  C   ARG A  60      23.165  14.417  34.656  1.00  8.07           C  
ATOM    439  O   ARG A  60      24.124  13.937  35.279  1.00  9.71           O  
ATOM    440  CB  ARG A  60      22.640  13.744  32.302  1.00  7.82           C  
ATOM    441  CG  ARG A  60      22.052  12.675  31.384  1.00  8.96           C  
ATOM    442  CD  ARG A  60      22.224  13.075  29.898  1.00  9.84           C  
ATOM    443  NE  ARG A  60      21.701  12.067  29.001  1.00 13.69           N  
ATOM    444  CZ  ARG A  60      21.435  12.202  27.696  1.00 11.87           C  
ATOM    445  NH1 ARG A  60      21.601  13.392  26.963  1.00 12.13           N  
ATOM    446  NH2 ARG A  60      21.030  11.040  27.164  1.00 10.28           N  
ATOM    447  N   LYS A  61      22.865  15.707  34.710  1.00  7.57           N  
ATOM    448  CA  LYS A  61      23.684  16.609  35.504  1.00  8.55           C  
ATOM    449  C   LYS A  61      23.583  16.326  36.991  1.00  9.35           C  
ATOM    450  O   LYS A  61      24.595  16.377  37.705  1.00 10.42           O  
ATOM    451  CB  LYS A  61      23.289  18.058  35.197  1.00  8.64           C  
ATOM    452  CG  LYS A  61      23.724  18.575  33.839  1.00 12.96           C  
ATOM    453  CD  LYS A  61      23.096  19.959  33.735  1.00 17.88           C  
ATOM    454  CE  LYS A  61      23.645  20.839  32.694  1.00 19.53           C  
ATOM    455  NZ  LYS A  61      23.036  22.186  33.018  1.00 17.97           N  
ATOM    456  N   ALA A  62      22.376  16.046  37.470  1.00  8.15           N  
ATOM    457  CA  ALA A  62      22.192  15.759  38.884  1.00  8.48           C  
ATOM    458  C   ALA A  62      22.921  14.483  39.269  1.00 10.31           C  
ATOM    459  O   ALA A  62      23.519  14.411  40.368  1.00 10.16           O  
ATOM    460  CB  ALA A  62      20.705  15.646  39.219  1.00  9.10           C  
ATOM    461  N   CYS A  63      22.880  13.466  38.410  1.00  9.41           N  
ATOM    462  CA  CYS A  63      23.589  12.227  38.716  1.00  9.60           C  
ATOM    463  C   CYS A  63      25.094  12.502  38.782  1.00 11.59           C  
ATOM    464  O   CYS A  63      25.767  11.931  39.646  1.00 10.75           O  
ATOM    465  CB  CYS A  63      23.231  11.157  37.677  1.00 10.76           C  
ATOM    466  SG  CYS A  63      21.582  10.467  37.925  1.00  9.69           S  
ATOM    467  N   LYS A  64      25.638  13.352  37.922  1.00 10.58           N  
ATOM    468  CA  LYS A  64      27.067  13.664  37.991  1.00 13.50           C  
ATOM    469  C   LYS A  64      27.377  14.402  39.288  1.00 14.52           C  
ATOM    470  O   LYS A  64      28.413  14.123  39.930  1.00 15.83           O  
ATOM    471  CB  LYS A  64      27.491  14.480  36.774  1.00 14.13           C  
ATOM    472  CG  LYS A  64      27.533  13.597  35.532  1.00 18.71           C  
ATOM    473  CD  LYS A  64      28.563  12.453  35.653  1.00 22.83           C  
ATOM    474  CE  LYS A  64      28.647  11.672  34.332  1.00 24.69           C  
ATOM    475  NZ  LYS A  64      29.582  10.501  34.379  1.00 28.05           N  
ATOM    476  N   VAL A  65      26.512  15.323  39.693  1.00 13.63           N  
ATOM    477  CA  VAL A  65      26.723  16.061  40.933  1.00 15.19           C  
ATOM    478  C   VAL A  65      26.754  15.114  42.136  1.00 14.52           C  
ATOM    479  O   VAL A  65      27.602  15.243  43.022  1.00 16.20           O  
ATOM    480  CB  VAL A  65      25.590  17.107  41.138  1.00 14.56           C  
ATOM    481  CG1 VAL A  65      25.505  17.556  42.594  1.00 18.21           C  
ATOM    482  CG2 VAL A  65      25.839  18.287  40.236  1.00 17.30           C  
ATOM    483  N   LEU A  66      25.851  14.151  42.159  1.00 13.12           N  
ATOM    484  CA  LEU A  66      25.722  13.191  43.246  1.00 13.77           C  
ATOM    485  C   LEU A  66      26.675  12.013  43.149  1.00 13.49           C  
ATOM    486  O   LEU A  66      26.804  11.258  44.116  1.00 15.75           O  
ATOM    487  CB  LEU A  66      24.284  12.655  43.265  1.00 12.87           C  
ATOM    488  CG  LEU A  66      23.214  13.713  43.557  1.00 13.27           C  
ATOM    489  CD1 LEU A  66      21.838  13.147  43.340  1.00 18.13           C  
ATOM    490  CD2 LEU A  66      23.369  14.195  44.991  1.00 16.42           C  
ATOM    491  N   GLY A  67      27.346  11.854  42.011  1.00 13.24           N  
ATOM    492  CA  GLY A  67      28.214  10.694  41.803  1.00 13.35           C  
ATOM    493  C   GLY A  67      27.425   9.399  41.945  1.00 13.14           C  
ATOM    494  O   GLY A  67      27.882   8.433  42.582  1.00 14.90           O  
ATOM    495  N   ALA A  68      26.244   9.344  41.315  1.00 11.63           N  
ATOM    496  CA  ALA A  68      25.334   8.208  41.403  1.00 10.62           C  
ATOM    497  C   ALA A  68      24.563   8.017  40.108  1.00  9.57           C  
ATOM    498  O   ALA A  68      24.624   8.877  39.242  1.00 12.16           O  
ATOM    499  CB  ALA A  68      24.321   8.447  42.526  1.00 12.64           C  
ATOM    500  N   TYR A  69      23.836   6.912  40.004  1.00  9.73           N  
ATOM    501  CA  TYR A  69      22.986   6.707  38.826  1.00  9.57           C  
ATOM    502  C   TYR A  69      21.521   6.698  39.228  1.00  9.89           C  
ATOM    503  O   TYR A  69      20.654   6.346  38.432  1.00 10.64           O  
ATOM    504  CB  TYR A  69      23.376   5.430  38.051  1.00 10.26           C  
ATOM    505  CG  TYR A  69      23.434   4.162  38.875  1.00 10.81           C  
ATOM    506  CD1 TYR A  69      24.599   3.785  39.544  1.00 13.99           C  
ATOM    507  CD2 TYR A  69      22.314   3.334  38.955  1.00 11.67           C  
ATOM    508  CE1 TYR A  69      24.633   2.582  40.285  1.00 15.56           C  
ATOM    509  CE2 TYR A  69      22.339   2.165  39.684  1.00 14.64           C  
ATOM    510  CZ  TYR A  69      23.499   1.804  40.338  1.00 14.47           C  
ATOM    511  OH  TYR A  69      23.529   0.615  41.043  1.00 21.49           O  
ATOM    512  N   GLN A  70      21.243   7.108  40.471  1.00  9.32           N  
ATOM    513  CA  GLN A  70      19.872   7.220  40.996  1.00  9.64           C  
ATOM    514  C   GLN A  70      19.704   8.585  41.652  1.00  9.72           C  
ATOM    515  O   GLN A  70      20.691   9.184  42.113  1.00 11.58           O  
ATOM    516  CB  GLN A  70      19.579   6.147  42.046  1.00 10.32           C  
ATOM    517  CG  GLN A  70      19.659   4.734  41.508  1.00  9.48           C  
ATOM    518  CD  GLN A  70      18.475   4.357  40.647  1.00  8.82           C  
ATOM    519  OE1 GLN A  70      17.506   3.811  41.113  1.00 10.88           O  
ATOM    520  NE2 GLN A  70      18.568   4.648  39.348  1.00  9.69           N  
ATOM    521  N   LEU A  71      18.447   9.050  41.698  1.00  8.83           N  
ATOM    522  CA  LEU A  71      18.139  10.373  42.273  1.00  9.05           C  
ATOM    523  C   LEU A  71      17.368  10.257  43.559  1.00 11.21           C  
ATOM    524  O   LEU A  71      16.268  10.802  43.724  1.00 10.12           O  
ATOM    525  CB  LEU A  71      17.384  11.245  41.260  1.00  9.17           C  
ATOM    526  CG  LEU A  71      18.159  11.576  39.987  1.00 10.87           C  
ATOM    527  CD1 LEU A  71      17.239  12.403  39.055  1.00 13.95           C  
ATOM    528  CD2 LEU A  71      19.436  12.323  40.361  1.00 12.13           C  
ATOM    529  N   ASP A  72      18.015   9.555  44.497  1.00 15.60           N  
ATOM    530  CA  ASP A  72      17.469   9.340  45.837  1.00 15.09           C  
ATOM    531  C   ASP A  72      17.038  10.648  46.497  1.00 12.36           C  
ATOM    532  O   ASP A  72      17.786  11.612  46.597  1.00 15.09           O  
ATOM    533  CB  ASP A  72      18.490   8.669  46.770  1.00 18.01           C  
ATOM    534  CG  ASP A  72      18.848   7.256  46.348  1.00 21.25           C  
ATOM    535  OD1 ASP A  72      18.301   6.727  45.356  1.00 21.84           O  
ATOM    536  OD2 ASP A  72      19.703   6.668  47.041  1.00 25.49           O  
ATOM    537  N   ASP A  73      15.803  10.650  46.922  1.00 15.20           N  
ATOM    538  CA  ASP A  73      15.217  11.771  47.659  1.00 16.10           C  
ATOM    539  C   ASP A  73      15.185  13.083  46.900  1.00 15.52           C  
ATOM    540  O   ASP A  73      15.118  14.143  47.510  1.00 16.86           O  
ATOM    541  CB  ASP A  73      15.946  11.981  49.004  1.00 18.92           C  
ATOM    542  CG  ASP A  73      15.981  10.731  49.861  1.00 23.01           C  
ATOM    543  OD1 ASP A  73      14.926  10.094  50.072  1.00 25.05           O  
ATOM    544  OD2 ASP A  73      17.089  10.398  50.331  1.00 27.43           O  
ATOM    545  N   CYS A  74      15.242  13.018  45.576  1.00 10.21           N  
ATOM    546  CA  CYS A  74      15.144  14.221  44.754  1.00  9.46           C  
ATOM    547  C   CYS A  74      13.721  14.359  44.205  1.00  7.69           C  
ATOM    548  O   CYS A  74      12.991  13.392  44.093  1.00  8.79           O  
ATOM    549  CB  CYS A  74      16.097  14.130  43.548  1.00  8.86           C  
ATOM    550  SG  CYS A  74      17.831  14.183  43.953  1.00 10.03           S  
ATOM    551  N   ILE A  75      13.366  15.595  43.865  1.00  7.73           N  
ATOM    552  CA  ILE A  75      12.097  15.899  43.197  1.00  7.54           C  
ATOM    553  C   ILE A  75      12.468  16.599  41.882  1.00  7.95           C  
ATOM    554  O   ILE A  75      13.374  17.443  41.839  1.00  8.62           O  
ATOM    555  CB  ILE A  75      11.222  16.840  44.037  1.00  8.96           C  
ATOM    556  CG1 ILE A  75      10.845  16.147  45.354  1.00 10.74           C  
ATOM    557  CG2 ILE A  75       9.963  17.247  43.266  1.00  9.57           C  
ATOM    558  CD1 ILE A  75      10.041  17.048  46.302  1.00 13.32           C  
ATOM    559  N   LEU A  76      11.766  16.220  40.814  1.00  6.88           N  
ATOM    560  CA  LEU A  76      11.989  16.825  39.509  1.00  7.92           C  
ATOM    561  C   LEU A  76      10.832  17.773  39.176  1.00  7.19           C  
ATOM    562  O   LEU A  76       9.665  17.398  39.313  1.00  8.41           O  
ATOM    563  CB  LEU A  76      12.104  15.720  38.439  0.50  9.06           C  
ATOM    565  CG  LEU A  76      12.363  16.185  37.003  0.50 10.83           C  
ATOM    567  CD1 LEU A  76      13.247  15.141  36.286  0.50 16.33           C  
ATOM    569  CD2 LEU A  76      11.063  16.420  36.289  0.50 17.50           C  
ATOM    571  N   TYR A  77      11.185  18.986  38.759  1.00  7.19           N  
ATOM    572  CA  TYR A  77      10.217  20.013  38.350  1.00  7.22           C  
ATOM    573  C   TYR A  77      10.458  20.280  36.881  1.00  6.15           C  
ATOM    574  O   TYR A  77      11.583  20.546  36.479  1.00  7.81           O  
ATOM    575  CB  TYR A  77      10.443  21.293  39.133  1.00  8.12           C  
ATOM    576  CG  TYR A  77      10.130  21.162  40.608  1.00  7.73           C  
ATOM    577  CD1 TYR A  77       8.860  21.394  41.092  1.00  7.47           C  
ATOM    578  CD2 TYR A  77      11.104  20.759  41.497  1.00  8.33           C  
ATOM    579  CE1 TYR A  77       8.543  21.221  42.442  1.00  9.09           C  
ATOM    580  CE2 TYR A  77      10.823  20.595  42.852  1.00  9.25           C  
ATOM    581  CZ  TYR A  77       9.534  20.825  43.317  1.00  8.34           C  
ATOM    582  OH  TYR A  77       9.238  20.672  44.658  1.00  9.58           O  
ATOM    583  N   THR A  78       9.411  20.248  36.074  1.00  6.49           N  
ATOM    584  CA  THR A  78       9.568  20.450  34.624  1.00  8.15           C  
ATOM    585  C   THR A  78       8.508  21.388  34.072  1.00  6.75           C  
ATOM    586  O   THR A  78       7.348  21.372  34.476  1.00  7.25           O  
ATOM    587  CB  THR A  78       9.565  19.059  33.900  1.00  9.61           C  
ATOM    588  OG1 THR A  78       9.655  19.248  32.484  1.00 12.58           O  
ATOM    589  CG2 THR A  78       8.323  18.267  34.188  1.00 10.43           C  
ATOM    590  N   SER A  79       8.914  22.230  33.136  1.00  6.29           N  
ATOM    591  CA  SER A  79       8.003  23.219  32.586  1.00  6.72           C  
ATOM    592  C   SER A  79       6.844  22.601  31.847  1.00  6.73           C  
ATOM    593  O   SER A  79       5.784  23.237  31.761  1.00  7.51           O  
ATOM    594  CB  SER A  79       8.764  24.207  31.703  1.00  6.75           C  
ATOM    595  OG  SER A  79       9.359  23.550  30.593  1.00  7.22           O  
ATOM    596  N   CYS A  80       7.032  21.408  31.292  1.00  6.44           N  
ATOM    597  CA  CYS A  80       5.953  20.724  30.611  1.00  7.41           C  
ATOM    598  C   CYS A  80       5.954  19.254  31.028  1.00  6.24           C  
ATOM    599  O   CYS A  80       7.027  18.692  31.329  1.00  7.67           O  
ATOM    600  CB  CYS A  80       6.151  20.824  29.082  1.00  7.65           C  
ATOM    601  SG  CYS A  80       4.685  20.341  28.126  1.00  9.49           S  
ATOM    602  N   GLU A  81       4.776  18.642  31.031  1.00  6.97           N  
ATOM    603  CA  GLU A  81       4.618  17.225  31.340  1.00  7.27           C  
ATOM    604  C   GLU A  81       5.661  16.441  30.531  1.00  7.59           C  
ATOM    605  O   GLU A  81       5.816  16.640  29.333  1.00  8.65           O  
ATOM    606  CB  GLU A  81       3.226  16.807  30.878  1.00  9.21           C  
ATOM    607  CG  GLU A  81       2.863  15.377  31.252  1.00 10.39           C  
ATOM    608  CD  GLU A  81       1.529  14.947  30.707  1.00 12.99           C  
ATOM    609  OE1 GLU A  81       0.794  15.790  30.122  1.00 13.34           O  
ATOM    610  OE2 GLU A  81       1.194  13.734  30.894  1.00 14.92           O  
ATOM    611  N   PRO A  82       6.353  15.489  31.159  1.00  6.95           N  
ATOM    612  CA  PRO A  82       7.369  14.721  30.428  1.00  6.82           C  
ATOM    613  C   PRO A  82       6.784  13.946  29.250  1.00  6.92           C  
ATOM    614  O   PRO A  82       5.701  13.348  29.356  1.00  7.99           O  
ATOM    615  CB  PRO A  82       7.911  13.768  31.498  1.00  7.31           C  
ATOM    616  CG  PRO A  82       7.771  14.544  32.785  1.00  8.59           C  
ATOM    617  CD  PRO A  82       6.432  15.255  32.609  1.00  7.32           C  
ATOM    618  N   CYS A  83       7.514  13.959  28.134  1.00  6.44           N  
ATOM    619  CA  CYS A  83       7.167  13.146  26.980  1.00  6.76           C  
ATOM    620  C   CYS A  83       7.499  11.668  27.366  1.00  7.34           C  
ATOM    621  O   CYS A  83       8.013  11.394  28.423  1.00  6.57           O  
ATOM    622  CB  CYS A  83       8.003  13.617  25.783  1.00  7.00           C  
ATOM    623  SG  CYS A  83       9.740  13.058  25.828  1.00  6.36           S  
ATOM    624  N   PRO A  84       7.208  10.704  26.482  1.00  6.72           N  
ATOM    625  CA  PRO A  84       7.483   9.306  26.843  1.00  7.28           C  
ATOM    626  C   PRO A  84       8.956   9.017  27.127  1.00  7.03           C  
ATOM    627  O   PRO A  84       9.271   8.205  28.018  1.00  6.83           O  
ATOM    628  CB  PRO A  84       6.948   8.511  25.656  1.00  8.85           C  
ATOM    629  CG  PRO A  84       5.835   9.397  25.109  1.00  9.39           C  
ATOM    630  CD  PRO A  84       6.482  10.787  25.196  1.00  7.64           C  
ATOM    631  N   MET A  85       9.859   9.643  26.359  1.00  6.52           N  
ATOM    632  CA  MET A  85      11.265   9.431  26.610  1.00  6.20           C  
ATOM    633  C   MET A  85      11.640   9.881  28.020  1.00  6.59           C  
ATOM    634  O   MET A  85      12.330   9.167  28.748  1.00  6.82           O  
ATOM    635  CB  MET A  85      12.136  10.211  25.611  1.00  5.45           C  
ATOM    636  CG  MET A  85      13.640  10.108  25.896  1.00  5.75           C  
ATOM    637  SD  MET A  85      14.615  10.941  24.613  1.00  6.70           S  
ATOM    638  CE  MET A  85      14.221  12.664  24.970  1.00  6.81           C  
ATOM    639  N   CYS A  86      11.178  11.073  28.396  1.00  5.94           N  
ATOM    640  CA  CYS A  86      11.525  11.643  29.693  1.00  6.52           C  
ATOM    641  C   CYS A  86      10.806  10.935  30.849  1.00  6.29           C  
ATOM    642  O   CYS A  86      11.371  10.783  31.925  1.00  6.36           O  
ATOM    643  CB  CYS A  86      11.243  13.144  29.667  1.00  6.14           C  
ATOM    644  SG  CYS A  86      12.437  13.991  28.540  1.00  6.72           S  
ATOM    645  N   LEU A  87       9.557  10.505  30.627  1.00  6.12           N  
ATOM    646  CA  LEU A  87       8.855   9.715  31.640  1.00  5.68           C  
ATOM    647  C   LEU A  87       9.688   8.439  31.887  1.00  6.09           C  
ATOM    648  O   LEU A  87       9.927   8.049  33.046  1.00  6.65           O  
ATOM    649  CB  LEU A  87       7.436   9.367  31.185  1.00  6.11           C  
ATOM    650  CG  LEU A  87       6.652   8.437  32.147  1.00  7.88           C  
ATOM    651  CD1 LEU A  87       5.164   8.770  32.034  1.00  9.44           C  
ATOM    652  CD2 LEU A  87       6.921   6.939  31.885  1.00  8.27           C  
ATOM    653  N   GLY A  88      10.174   7.816  30.824  1.00  6.03           N  
ATOM    654  CA  GLY A  88      11.009   6.628  31.010  1.00  6.64           C  
ATOM    655  C   GLY A  88      12.291   6.965  31.767  1.00  5.88           C  
ATOM    656  O   GLY A  88      12.681   6.241  32.707  1.00  6.78           O  
ATOM    657  N   ALA A  89      12.960   8.056  31.382  1.00  6.37           N  
ATOM    658  CA  ALA A  89      14.174   8.462  32.076  1.00  6.17           C  
ATOM    659  C   ALA A  89      13.909   8.676  33.549  1.00  7.14           C  
ATOM    660  O   ALA A  89      14.728   8.295  34.383  1.00  6.94           O  
ATOM    661  CB  ALA A  89      14.751   9.713  31.470  1.00  7.47           C  
ATOM    662  N   ILE A  90      12.774   9.297  33.882  1.00  5.73           N  
ATOM    663  CA  ILE A  90      12.407   9.512  35.282  1.00  6.31           C  
ATOM    664  C   ILE A  90      12.296   8.162  36.024  1.00  6.53           C  
ATOM    665  O   ILE A  90      12.798   8.026  37.149  1.00  7.01           O  
ATOM    666  CB  ILE A  90      11.086  10.304  35.343  1.00  6.50           C  
ATOM    667  CG1 ILE A  90      11.379  11.766  35.003  1.00  7.64           C  
ATOM    668  CG2 ILE A  90      10.431  10.191  36.751  1.00  8.01           C  
ATOM    669  CD1 ILE A  90      10.173  12.555  34.511  1.00  7.74           C  
ATOM    670  N   TYR A  91      11.607   7.196  35.407  1.00  6.79           N  
ATOM    671  CA  TYR A  91      11.487   5.885  36.033  1.00  6.67           C  
ATOM    672  C   TYR A  91      12.799   5.145  36.140  1.00  6.81           C  
ATOM    673  O   TYR A  91      12.954   4.318  37.059  1.00  8.20           O  
ATOM    674  CB  TYR A  91      10.448   5.024  35.326  1.00  7.58           C  
ATOM    675  CG  TYR A  91       9.062   5.247  35.896  1.00  7.49           C  
ATOM    676  CD1 TYR A  91       8.612   4.466  36.944  1.00  9.21           C  
ATOM    677  CD2 TYR A  91       8.235   6.291  35.446  1.00  7.63           C  
ATOM    678  CE1 TYR A  91       7.384   4.703  37.559  1.00  8.89           C  
ATOM    679  CE2 TYR A  91       6.989   6.526  36.031  1.00  9.82           C  
ATOM    680  CZ  TYR A  91       6.594   5.719  37.081  1.00  8.87           C  
ATOM    681  OH  TYR A  91       5.374   5.920  37.670  1.00 10.66           O  
ATOM    682  N   TRP A  92      13.770   5.392  35.265  1.00  6.27           N  
ATOM    683  CA  TRP A  92      15.079   4.755  35.428  1.00  7.88           C  
ATOM    684  C   TRP A  92      15.936   5.481  36.472  1.00  6.97           C  
ATOM    685  O   TRP A  92      16.774   4.851  37.130  1.00  7.28           O  
ATOM    686  CB  TRP A  92      15.815   4.674  34.081  1.00  6.97           C  
ATOM    687  CG  TRP A  92      15.197   3.707  33.156  1.00  6.48           C  
ATOM    688  CD1 TRP A  92      14.562   3.987  31.978  1.00  6.73           C  
ATOM    689  CD2 TRP A  92      15.084   2.292  33.350  1.00  6.32           C  
ATOM    690  NE1 TRP A  92      14.060   2.830  31.424  1.00  8.31           N  
ATOM    691  CE2 TRP A  92      14.370   1.775  32.246  1.00  6.38           C  
ATOM    692  CE3 TRP A  92      15.528   1.407  34.351  1.00  8.23           C  
ATOM    693  CZ2 TRP A  92      14.085   0.416  32.108  1.00  7.80           C  
ATOM    694  CZ3 TRP A  92      15.251   0.037  34.203  1.00  8.75           C  
ATOM    695  CH2 TRP A  92      14.540  -0.431  33.096  1.00  8.18           C  
ATOM    696  N   ALA A  93      15.733   6.782  36.654  1.00  6.88           N  
ATOM    697  CA  ALA A  93      16.501   7.578  37.634  1.00  8.26           C  
ATOM    698  C   ALA A  93      15.948   7.490  39.042  1.00  6.98           C  
ATOM    699  O   ALA A  93      16.690   7.631  40.022  1.00  7.85           O  
ATOM    700  CB  ALA A  93      16.537   9.031  37.184  1.00  7.57           C  
ATOM    701  N   ARG A  94      14.656   7.276  39.140  1.00  7.25           N  
ATOM    702  CA  ARG A  94      13.949   7.095  40.396  1.00  7.72           C  
ATOM    703  C   ARG A  94      13.926   8.233  41.422  1.00  9.73           C  
ATOM    704  O   ARG A  94      14.312   8.054  42.588  1.00  9.65           O  
ATOM    705  CB  ARG A  94      14.342   5.772  41.053  1.00  8.60           C  
ATOM    706  CG  ARG A  94      14.181   4.582  40.094  1.00  9.13           C  
ATOM    707  CD  ARG A  94      14.227   3.223  40.778  1.00  8.74           C  
ATOM    708  NE  ARG A  94      14.072   2.163  39.774  1.00  9.78           N  
ATOM    709  CZ  ARG A  94      15.090   1.627  39.083  1.00  9.60           C  
ATOM    710  NH1 ARG A  94      16.356   1.997  39.263  1.00  9.34           N  
ATOM    711  NH2 ARG A  94      14.806   0.753  38.124  1.00 10.43           N  
ATOM    712  N   PRO A  95      13.571   9.445  41.000  1.00  8.71           N  
ATOM    713  CA  PRO A  95      13.445  10.526  41.995  1.00  8.41           C  
ATOM    714  C   PRO A  95      12.112  10.153  42.715  1.00  7.29           C  
ATOM    715  O   PRO A  95      11.399   9.216  42.348  1.00  8.65           O  
ATOM    716  CB  PRO A  95      13.228  11.759  41.126  1.00  8.43           C  
ATOM    717  CG  PRO A  95      12.488  11.213  39.899  1.00  9.00           C  
ATOM    718  CD  PRO A  95      13.194   9.870  39.638  1.00  8.46           C  
ATOM    719  N   LYS A  96      11.755  10.925  43.739  1.00  7.29           N  
ATOM    720  CA  LYS A  96      10.542  10.639  44.502  1.00  7.12           C  
ATOM    721  C   LYS A  96       9.248  11.088  43.850  1.00  7.55           C  
ATOM    722  O   LYS A  96       8.219  10.431  44.014  1.00  8.69           O  
ATOM    723  CB  LYS A  96      10.622  11.358  45.853  1.00 11.72           C  
ATOM    724  CG  LYS A  96      11.663  10.810  46.799  1.00 14.26           C  
ATOM    725  CD  LYS A  96      11.229   9.458  47.331  1.00 16.97           C  
ATOM    726  CE  LYS A  96      12.064   9.057  48.567  1.00 21.45           C  
ATOM    727  NZ  LYS A  96      11.398   8.026  49.406  1.00 22.86           N  
ATOM    728  N   ALA A  97       9.279  12.176  43.082  1.00  7.53           N  
ATOM    729  CA  ALA A  97       8.062  12.755  42.536  1.00  7.45           C  
ATOM    730  C   ALA A  97       8.421  13.709  41.422  1.00  6.44           C  
ATOM    731  O   ALA A  97       9.559  14.170  41.314  1.00  8.04           O  
ATOM    732  CB  ALA A  97       7.325  13.530  43.663  1.00  8.44           C  
ATOM    733  N   VAL A  98       7.413  13.998  40.593  1.00  6.24           N  
ATOM    734  CA  VAL A  98       7.553  14.918  39.485  1.00  6.93           C  
ATOM    735  C   VAL A  98       6.427  15.940  39.551  1.00  7.27           C  
ATOM    736  O   VAL A  98       5.276  15.574  39.784  1.00  8.42           O  
ATOM    737  CB  VAL A  98       7.429  14.159  38.132  1.00  7.38           C  
ATOM    738  CG1 VAL A  98       7.465  15.117  36.955  1.00  8.59           C  
ATOM    739  CG2 VAL A  98       8.500  13.114  38.018  1.00  8.61           C  
ATOM    740  N   PHE A  99       6.771  17.215  39.332  1.00  7.80           N  
ATOM    741  CA  PHE A  99       5.784  18.288  39.248  1.00  7.15           C  
ATOM    742  C   PHE A  99       5.957  18.924  37.873  1.00  6.17           C  
ATOM    743  O   PHE A  99       7.108  19.137  37.426  1.00  7.11           O  
ATOM    744  CB  PHE A  99       6.008  19.351  40.314  1.00  6.76           C  
ATOM    745  CG  PHE A  99       5.706  18.883  41.702  1.00  8.06           C  
ATOM    746  CD1 PHE A  99       6.637  18.116  42.423  1.00  7.98           C  
ATOM    747  CD2 PHE A  99       4.446  19.165  42.270  1.00  8.79           C  
ATOM    748  CE1 PHE A  99       6.309  17.626  43.697  1.00  8.25           C  
ATOM    749  CE2 PHE A  99       4.129  18.659  43.556  1.00  8.72           C  
ATOM    750  CZ  PHE A  99       5.057  17.902  44.250  1.00  8.58           C  
ATOM    751  N   TYR A 100       4.848  19.246  37.205  1.00  6.85           N  
ATOM    752  CA  TYR A 100       4.952  19.856  35.889  1.00  7.45           C  
ATOM    753  C   TYR A 100       3.878  20.916  35.747  1.00  7.31           C  
ATOM    754  O   TYR A 100       2.848  20.890  36.471  1.00  8.10           O  
ATOM    755  CB  TYR A 100       4.837  18.808  34.779  1.00  8.91           C  
ATOM    756  CG  TYR A 100       3.549  18.040  34.733  1.00  8.85           C  
ATOM    757  CD1 TYR A 100       3.355  16.874  35.499  1.00 10.18           C  
ATOM    758  CD2 TYR A 100       2.485  18.465  33.923  1.00 10.01           C  
ATOM    759  CE1 TYR A 100       2.149  16.169  35.443  1.00 11.55           C  
ATOM    760  CE2 TYR A 100       1.274  17.759  33.876  1.00 12.04           C  
ATOM    761  CZ  TYR A 100       1.130  16.618  34.637  1.00 13.46           C  
ATOM    762  OH  TYR A 100      -0.042  15.894  34.572  1.00 15.87           O  
ATOM    763  N   ALA A 101       4.106  21.854  34.827  1.00  7.50           N  
ATOM    764  CA  ALA A 101       3.159  22.956  34.604  1.00  7.85           C  
ATOM    765  C   ALA A 101       2.329  22.731  33.350  1.00  8.22           C  
ATOM    766  O   ALA A 101       1.171  22.298  33.455  1.00  9.81           O  
ATOM    767  CB  ALA A 101       3.928  24.287  34.572  1.00  8.79           C  
ATOM    768  N   ALA A 102       2.868  23.011  32.160  1.00  7.36           N  
ATOM    769  CA  ALA A 102       2.144  22.763  30.926  1.00  7.89           C  
ATOM    770  C   ALA A 102       1.981  21.254  30.716  1.00  7.76           C  
ATOM    771  O   ALA A 102       2.684  20.422  31.311  1.00  8.15           O  
ATOM    772  CB  ALA A 102       2.899  23.371  29.747  1.00  8.63           C  
ATOM    773  N   GLU A 103       1.041  20.909  29.837  1.00  9.56           N  
ATOM    774  CA  GLU A 103       0.687  19.520  29.556  1.00 11.02           C  
ATOM    775  C   GLU A 103       1.080  19.066  28.167  1.00 11.07           C  
ATOM    776  O   GLU A 103       1.390  19.889  27.298  1.00 10.72           O  
ATOM    777  CB  GLU A 103      -0.822  19.336  29.778  1.00 13.48           C  
ATOM    778  CG  GLU A 103      -1.160  19.517  31.250  1.00 18.71           C  
ATOM    779  CD  GLU A 103      -2.653  19.572  31.521  1.00 22.05           C  
ATOM    780  OE1 GLU A 103      -3.306  20.478  30.976  1.00 21.39           O  
ATOM    781  OE2 GLU A 103      -3.164  18.710  32.282  1.00 26.24           O  
ATOM    782  N   HIS A 104       1.058  17.756  27.933  1.00 11.36           N  
ATOM    783  CA  HIS A 104       1.496  17.250  26.641  1.00 12.45           C  
ATOM    784  C   HIS A 104       0.717  17.873  25.500  1.00 11.50           C  
ATOM    785  O   HIS A 104       1.274  18.118  24.427  1.00 13.27           O  
ATOM    786  CB  HIS A 104       1.479  15.701  26.615  1.00 15.13           C  
ATOM    787  CG  HIS A 104       0.119  15.089  26.598  1.00 20.07           C  
ATOM    788  ND1 HIS A 104      -0.558  14.812  25.428  1.00 22.18           N  
ATOM    789  CD2 HIS A 104      -0.681  14.666  27.606  1.00 21.11           C  
ATOM    790  CE1 HIS A 104      -1.719  14.245  25.715  1.00 24.07           C  
ATOM    791  NE2 HIS A 104      -1.818  14.145  27.030  1.00 23.50           N  
ATOM    792  N   THR A 105      -0.552  18.186  25.747  1.00 12.08           N  
ATOM    793  CA  THR A 105      -1.383  18.834  24.718  1.00 14.85           C  
ATOM    794  C   THR A 105      -0.846  20.222  24.334  1.00 12.32           C  
ATOM    795  O   THR A 105      -0.970  20.648  23.172  1.00 11.81           O  
ATOM    796  CB  THR A 105      -2.859  18.958  25.177  1.00 16.30           C  
ATOM    797  OG1 THR A 105      -2.921  19.527  26.487  1.00 20.21           O  
ATOM    798  CG2 THR A 105      -3.503  17.575  25.216  1.00 18.77           C  
ATOM    799  N   ASP A 106      -0.260  20.940  25.299  1.00 11.96           N  
ATOM    800  CA  ASP A 106       0.319  22.249  25.023  1.00 10.65           C  
ATOM    801  C   ASP A 106       1.546  22.074  24.127  1.00  9.05           C  
ATOM    802  O   ASP A 106       1.765  22.856  23.208  1.00 10.49           O  
ATOM    803  CB  ASP A 106       0.700  22.959  26.322  1.00 10.87           C  
ATOM    804  CG  ASP A 106      -0.496  23.248  27.194  1.00 12.56           C  
ATOM    805  OD1 ASP A 106      -1.527  23.739  26.628  1.00 12.59           O  
ATOM    806  OD2 ASP A 106      -0.418  22.995  28.420  1.00 12.36           O  
ATOM    807  N   ALA A 107       2.377  21.065  24.398  1.00  8.78           N  
ATOM    808  CA  ALA A 107       3.542  20.802  23.552  1.00  9.09           C  
ATOM    809  C   ALA A 107       3.060  20.422  22.138  1.00  8.81           C  
ATOM    810  O   ALA A 107       3.603  20.894  21.149  1.00  9.02           O  
ATOM    811  CB  ALA A 107       4.384  19.666  24.146  1.00  9.06           C  
ATOM    812  N   ALA A 108       2.012  19.597  22.057  1.00  9.65           N  
ATOM    813  CA  ALA A 108       1.504  19.207  20.741  1.00  9.71           C  
ATOM    814  C   ALA A 108       0.972  20.414  19.968  1.00 10.21           C  
ATOM    815  O   ALA A 108       1.253  20.565  18.775  1.00 10.76           O  
ATOM    816  CB  ALA A 108       0.429  18.171  20.893  1.00 10.61           C  
ATOM    817  N   GLU A 109       0.236  21.285  20.651  1.00 10.70           N  
ATOM    818  CA  GLU A 109      -0.304  22.471  19.976  1.00 11.44           C  
ATOM    819  C   GLU A 109       0.819  23.379  19.483  1.00 12.36           C  
ATOM    820  O   GLU A 109       0.672  24.078  18.449  1.00 14.43           O  
ATOM    821  CB  GLU A 109      -1.287  23.185  20.910  1.00 14.80           C  
ATOM    822  CG  GLU A 109      -2.583  22.349  21.076  1.00 21.47           C  
ATOM    823  CD  GLU A 109      -3.474  22.763  22.231  1.00 26.36           C  
ATOM    824  OE1 GLU A 109      -4.241  21.891  22.707  1.00 29.90           O  
ATOM    825  OE2 GLU A 109      -3.429  23.933  22.663  1.00 28.99           O  
ATOM    826  N   ALA A 110       1.973  23.340  20.154  1.00 10.97           N  
ATOM    827  CA  ALA A 110       3.093  24.134  19.706  1.00 10.00           C  
ATOM    828  C   ALA A 110       3.898  23.444  18.595  1.00 10.46           C  
ATOM    829  O   ALA A 110       4.914  23.971  18.167  1.00 12.66           O  
ATOM    830  CB  ALA A 110       3.999  24.496  20.879  1.00 12.42           C  
ATOM    831  N   GLY A 111       3.450  22.263  18.163  1.00  9.60           N  
ATOM    832  CA  GLY A 111       4.101  21.576  17.054  1.00 10.33           C  
ATOM    833  C   GLY A 111       5.034  20.425  17.388  1.00 11.80           C  
ATOM    834  O   GLY A 111       5.662  19.880  16.468  1.00 15.27           O  
ATOM    835  N   PHE A 112       5.095  20.025  18.656  1.00 10.32           N  
ATOM    836  CA  PHE A 112       5.992  18.938  19.074  1.00  7.60           C  
ATOM    837  C   PHE A 112       5.276  17.604  19.071  1.00  8.83           C  
ATOM    838  O   PHE A 112       4.037  17.500  19.213  1.00  9.81           O  
ATOM    839  CB  PHE A 112       6.597  19.287  20.429  1.00  9.20           C  
ATOM    840  CG  PHE A 112       7.466  20.505  20.376  1.00  9.13           C  
ATOM    841  CD1 PHE A 112       8.782  20.424  19.906  1.00 12.19           C  
ATOM    842  CD2 PHE A 112       6.960  21.740  20.754  1.00  8.79           C  
ATOM    843  CE1 PHE A 112       9.577  21.577  19.818  1.00 11.76           C  
ATOM    844  CE2 PHE A 112       7.768  22.888  20.657  1.00 12.32           C  
ATOM    845  CZ  PHE A 112       9.057  22.793  20.192  1.00 11.71           C  
ATOM    846  N   ASP A 113       6.069  16.542  18.954  1.00  7.71           N  
ATOM    847  CA  ASP A 113       5.537  15.184  18.873  1.00  7.61           C  
ATOM    848  C   ASP A 113       5.167  14.504  20.188  1.00  9.36           C  
ATOM    849  O   ASP A 113       4.840  13.317  20.174  1.00  9.19           O  
ATOM    850  CB  ASP A 113       6.529  14.263  18.134  1.00  9.20           C  
ATOM    851  CG  ASP A 113       6.493  14.410  16.633  1.00 10.30           C  
ATOM    852  OD1 ASP A 113       5.573  15.071  16.088  1.00 13.08           O  
ATOM    853  OD2 ASP A 113       7.404  13.841  15.992  1.00 10.19           O  
ATOM    854  N   ASP A 114       5.155  15.221  21.308  1.00  8.67           N  
ATOM    855  CA  ASP A 114       4.886  14.571  22.595  1.00  9.57           C  
ATOM    856  C   ASP A 114       3.649  13.689  22.629  1.00  9.05           C  
ATOM    857  O   ASP A 114       3.733  12.532  23.064  1.00 11.16           O  
ATOM    858  CB  ASP A 114       4.758  15.598  23.720  1.00 10.06           C  
ATOM    859  CG  ASP A 114       6.001  16.442  23.919  1.00  9.54           C  
ATOM    860  OD1 ASP A 114       6.580  16.903  22.897  1.00  9.86           O  
ATOM    861  OD2 ASP A 114       6.347  16.685  25.111  1.00 12.15           O  
ATOM    862  N   SER A 115       2.508  14.223  22.206  1.00 10.63           N  
ATOM    863  CA  SER A 115       1.272  13.443  22.239  1.00 11.52           C  
ATOM    864  C   SER A 115       1.298  12.298  21.253  1.00  9.76           C  
ATOM    865  O   SER A 115       0.803  11.190  21.519  1.00 12.09           O  
ATOM    866  CB  SER A 115       0.074  14.325  21.904  1.00 12.39           C  
ATOM    867  OG  SER A 115      -0.082  15.350  22.870  1.00 15.27           O  
ATOM    868  N   PHE A 116       1.846  12.559  20.088  1.00 10.51           N  
ATOM    869  CA  PHE A 116       1.953  11.549  19.075  1.00  9.92           C  
ATOM    870  C   PHE A 116       2.717  10.316  19.575  1.00  9.20           C  
ATOM    871  O   PHE A 116       2.284   9.175  19.339  1.00  9.77           O  
ATOM    872  CB  PHE A 116       2.643  12.168  17.866  1.00 10.77           C  
ATOM    873  CG  PHE A 116       3.035  11.187  16.816  1.00 11.69           C  
ATOM    874  CD1 PHE A 116       2.071  10.486  16.098  1.00 13.79           C  
ATOM    875  CD2 PHE A 116       4.374  10.990  16.511  1.00 12.84           C  
ATOM    876  CE1 PHE A 116       2.452   9.592  15.076  1.00 15.14           C  
ATOM    877  CE2 PHE A 116       4.742  10.102  15.493  1.00 13.94           C  
ATOM    878  CZ  PHE A 116       3.788   9.415  14.790  1.00 13.60           C  
ATOM    879  N   ILE A 117       3.836  10.530  20.280  1.00  9.15           N  
ATOM    880  CA  ILE A 117       4.625   9.399  20.731  1.00  9.72           C  
ATOM    881  C   ILE A 117       3.848   8.573  21.763  1.00  9.08           C  
ATOM    882  O   ILE A 117       3.931   7.345  21.750  1.00  9.08           O  
ATOM    883  CB  ILE A 117       6.027   9.883  21.244  1.00  8.63           C  
ATOM    884  CG1 ILE A 117       6.742  10.643  20.116  1.00  8.34           C  
ATOM    885  CG2 ILE A 117       6.858   8.686  21.668  1.00  9.97           C  
ATOM    886  CD1 ILE A 117       7.994  11.359  20.570  1.00 10.02           C  
ATOM    887  N   TYR A 118       3.108   9.231  22.652  1.00  9.98           N  
ATOM    888  CA  TYR A 118       2.318   8.457  23.599  1.00 11.36           C  
ATOM    889  C   TYR A 118       1.326   7.569  22.844  1.00 10.36           C  
ATOM    890  O   TYR A 118       1.129   6.401  23.195  1.00 12.45           O  
ATOM    891  CB  TYR A 118       1.564   9.389  24.558  1.00 10.89           C  
ATOM    892  CG  TYR A 118       2.366   9.829  25.775  1.00 11.96           C  
ATOM    893  CD1 TYR A 118       2.697   8.912  26.768  1.00 11.07           C  
ATOM    894  CD2 TYR A 118       2.781  11.152  25.927  1.00 11.32           C  
ATOM    895  CE1 TYR A 118       3.439   9.303  27.912  1.00 11.77           C  
ATOM    896  CE2 TYR A 118       3.531  11.551  27.060  1.00 12.42           C  
ATOM    897  CZ  TYR A 118       3.842  10.607  28.039  1.00 10.84           C  
ATOM    898  OH  TYR A 118       4.554  10.952  29.190  1.00 11.31           O  
ATOM    899  N   LYS A 119       0.721   8.107  21.784  1.00  9.40           N  
ATOM    900  CA  LYS A 119      -0.218   7.284  21.019  1.00 11.11           C  
ATOM    901  C   LYS A 119       0.477   6.122  20.312  1.00 11.39           C  
ATOM    902  O   LYS A 119      -0.071   5.015  20.197  1.00 11.53           O  
ATOM    903  CB  LYS A 119      -0.940   8.153  19.999  1.00 11.96           C  
ATOM    904  CG  LYS A 119      -1.830   9.193  20.633  1.00 19.05           C  
ATOM    905  CD  LYS A 119      -2.881   8.511  21.477  1.00 25.05           C  
ATOM    906  CE  LYS A 119      -3.641   7.506  20.632  1.00 27.82           C  
ATOM    907  NZ  LYS A 119      -4.167   8.169  19.382  1.00 30.42           N  
ATOM    908  N   GLU A 120       1.686   6.356  19.812  1.00 10.03           N  
ATOM    909  CA  GLU A 120       2.412   5.310  19.106  1.00 10.85           C  
ATOM    910  C   GLU A 120       2.736   4.099  19.979  1.00 10.89           C  
ATOM    911  O   GLU A 120       2.784   2.981  19.494  1.00 11.63           O  
ATOM    912  CB  GLU A 120       3.697   5.870  18.487  1.00 10.40           C  
ATOM    913  CG  GLU A 120       3.408   6.815  17.329  1.00 10.29           C  
ATOM    914  CD  GLU A 120       2.921   6.046  16.126  1.00 11.31           C  
ATOM    915  OE1 GLU A 120       3.768   5.384  15.461  1.00 11.45           O  
ATOM    916  OE2 GLU A 120       1.687   6.059  15.862  1.00 12.58           O  
ATOM    917  N   ILE A 121       2.933   4.329  21.265  1.00 12.50           N  
ATOM    918  CA  ILE A 121       3.217   3.197  22.156  1.00 13.64           C  
ATOM    919  C   ILE A 121       2.125   2.129  22.089  1.00 14.76           C  
ATOM    920  O   ILE A 121       2.404   0.910  22.113  1.00 14.89           O  
ATOM    921  CB  ILE A 121       3.363   3.685  23.599  1.00 13.37           C  
ATOM    922  CG1 ILE A 121       4.683   4.443  23.726  1.00 12.63           C  
ATOM    923  CG2 ILE A 121       3.299   2.493  24.583  1.00 15.79           C  
ATOM    924  CD1 ILE A 121       4.923   5.046  25.091  1.00 18.14           C  
ATOM    925  N   ASP A 122       0.880   2.577  21.942  1.00 15.46           N  
ATOM    926  CA  ASP A 122      -0.245   1.656  21.928  1.00 17.62           C  
ATOM    927  C   ASP A 122      -0.525   0.990  20.589  1.00 19.40           C  
ATOM    928  O   ASP A 122      -1.385   0.111  20.502  1.00 22.36           O  
ATOM    929  CB  ASP A 122      -1.519   2.357  22.421  1.00 18.45           C  
ATOM    930  CG  ASP A 122      -1.466   2.702  23.898  1.00 20.91           C  
ATOM    931  OD1 ASP A 122      -0.798   1.977  24.664  1.00 21.57           O  
ATOM    932  OD2 ASP A 122      -2.118   3.688  24.304  1.00 24.96           O  
ATOM    933  N   LYS A 123       0.165   1.397  19.542  1.00 18.22           N  
ATOM    934  CA  LYS A 123      -0.042   0.778  18.239  1.00 17.93           C  
ATOM    935  C   LYS A 123       0.766  -0.497  18.156  1.00 17.76           C  
ATOM    936  O   LYS A 123       1.828  -0.610  18.796  1.00 16.91           O  
ATOM    937  CB  LYS A 123       0.415   1.713  17.131  1.00 19.81           C  
ATOM    938  CG  LYS A 123      -0.480   2.912  16.947  1.00 23.88           C  
ATOM    939  CD  LYS A 123      -0.164   3.623  15.658  1.00 26.20           C  
ATOM    940  CE  LYS A 123      -1.339   4.480  15.239  1.00 29.40           C  
ATOM    941  NZ  LYS A 123      -1.964   5.198  16.381  1.00 29.83           N  
ATOM    942  N   PRO A 124       0.254  -1.508  17.432  1.00 16.27           N  
ATOM    943  CA  PRO A 124       0.986  -2.771  17.280  1.00 16.05           C  
ATOM    944  C   PRO A 124       2.346  -2.371  16.732  1.00 17.09           C  
ATOM    945  O   PRO A 124       2.440  -1.526  15.838  1.00 15.61           O  
ATOM    946  CB  PRO A 124       0.152  -3.533  16.250  1.00 17.93           C  
ATOM    947  CG  PRO A 124      -1.243  -3.063  16.562  1.00 19.75           C  
ATOM    948  CD  PRO A 124      -1.085  -1.582  16.820  1.00 18.72           C  
ATOM    949  N   ALA A 125       3.396  -3.001  17.240  1.00 16.97           N  
ATOM    950  CA  ALA A 125       4.756  -2.657  16.840  1.00 15.22           C  
ATOM    951  C   ALA A 125       5.029  -2.476  15.348  1.00 15.75           C  
ATOM    952  O   ALA A 125       5.630  -1.473  14.940  1.00 14.72           O  
ATOM    953  CB  ALA A 125       5.727  -3.683  17.423  1.00 18.02           C  
ATOM    954  N   GLU A 126       4.582  -3.409  14.515  1.00 15.44           N  
ATOM    955  CA  GLU A 126       4.853  -3.328  13.078  1.00 17.17           C  
ATOM    956  C   GLU A 126       4.045  -2.292  12.318  1.00 15.91           C  
ATOM    957  O   GLU A 126       4.372  -1.963  11.166  1.00 18.22           O  
ATOM    958  CB  GLU A 126       4.645  -4.696  12.421  1.00 20.28           C  
ATOM    959  CG  GLU A 126       5.520  -5.791  12.977  1.00 23.84           C  
ATOM    960  CD  GLU A 126       5.296  -7.115  12.262  1.00 29.60           C  
ATOM    961  OE1 GLU A 126       4.130  -7.585  12.228  1.00 32.14           O  
ATOM    962  OE2 GLU A 126       6.281  -7.680  11.740  1.00 30.87           O  
ATOM    963  N   GLU A 127       2.982  -1.814  12.960  1.00 14.42           N  
ATOM    964  CA  GLU A 127       2.116  -0.789  12.371  1.00 13.53           C  
ATOM    965  C   GLU A 127       2.478   0.634  12.763  1.00 12.50           C  
ATOM    966  O   GLU A 127       1.838   1.587  12.318  1.00 12.99           O  
ATOM    967  CB  GLU A 127       0.656  -1.043  12.769  1.00 14.46           C  
ATOM    968  CG  GLU A 127       0.118  -2.371  12.227  1.00 20.03           C  
ATOM    969  CD  GLU A 127      -1.211  -2.775  12.840  1.00 23.73           C  
ATOM    970  OE1 GLU A 127      -1.962  -1.896  13.306  1.00 25.88           O  
ATOM    971  OE2 GLU A 127      -1.505  -3.994  12.839  1.00 30.07           O  
ATOM    972  N   ARG A 128       3.491   0.786  13.614  1.00 11.82           N  
ATOM    973  CA  ARG A 128       3.889   2.117  14.057  1.00 11.57           C  
ATOM    974  C   ARG A 128       4.452   2.905  12.858  1.00 11.38           C  
ATOM    975  O   ARG A 128       4.960   2.335  11.879  1.00 11.60           O  
ATOM    976  CB  ARG A 128       4.946   1.971  15.168  1.00  9.38           C  
ATOM    977  CG  ARG A 128       4.366   1.606  16.486  1.00  9.20           C  
ATOM    978  CD  ARG A 128       5.472   1.334  17.494  1.00  9.83           C  
ATOM    979  NE  ARG A 128       4.919   0.982  18.805  1.00 11.07           N  
ATOM    980  CZ  ARG A 128       5.558   0.249  19.729  1.00 11.27           C  
ATOM    981  NH1 ARG A 128       6.779  -0.201  19.495  1.00 11.16           N  
ATOM    982  NH2 ARG A 128       4.942  -0.072  20.871  1.00 13.04           N  
ATOM    983  N   THR A 129       4.388   4.224  12.948  1.00 10.97           N  
ATOM    984  CA  THR A 129       4.934   5.088  11.892  1.00 11.28           C  
ATOM    985  C   THR A 129       6.423   4.807  11.692  1.00 11.58           C  
ATOM    986  O   THR A 129       6.945   4.899  10.570  1.00 11.30           O  
ATOM    987  CB  THR A 129       4.663   6.538  12.251  1.00 11.64           C  
ATOM    988  OG1 THR A 129       3.262   6.763  12.047  1.00 13.65           O  
ATOM    989  CG2 THR A 129       5.450   7.505  11.365  1.00 14.30           C  
ATOM    990  N   ILE A 130       7.136   4.538  12.784  1.00  9.75           N  
ATOM    991  CA  ILE A 130       8.527   4.070  12.679  1.00  9.65           C  
ATOM    992  C   ILE A 130       8.288   2.596  13.041  1.00 11.10           C  
ATOM    993  O   ILE A 130       8.109   2.259  14.222  1.00 10.89           O  
ATOM    994  CB  ILE A 130       9.457   4.703  13.708  1.00  9.12           C  
ATOM    995  CG1 ILE A 130       9.569   6.193  13.444  1.00 11.59           C  
ATOM    996  CG2 ILE A 130      10.832   4.006  13.634  1.00 10.53           C  
ATOM    997  CD1 ILE A 130      10.370   6.907  14.505  1.00 13.28           C  
ATOM    998  N   PRO A 131       8.251   1.702  12.045  1.00 11.33           N  
ATOM    999  CA  PRO A 131       7.998   0.292  12.377  1.00 11.33           C  
ATOM   1000  C   PRO A 131       9.048  -0.390  13.221  1.00 10.75           C  
ATOM   1001  O   PRO A 131      10.256  -0.146  13.034  1.00 11.02           O  
ATOM   1002  CB  PRO A 131       7.866  -0.364  11.010  1.00 13.09           C  
ATOM   1003  CG  PRO A 131       8.743   0.437  10.138  1.00 13.30           C  
ATOM   1004  CD  PRO A 131       8.553   1.882  10.628  1.00 10.85           C  
ATOM   1005  N   PHE A 132       8.569  -1.206  14.168  1.00 11.09           N  
ATOM   1006  CA  PHE A 132       9.422  -2.006  15.061  1.00 10.87           C  
ATOM   1007  C   PHE A 132       9.179  -3.477  14.692  1.00 11.29           C  
ATOM   1008  O   PHE A 132       8.063  -3.989  14.920  1.00 13.89           O  
ATOM   1009  CB  PHE A 132       9.052  -1.827  16.550  1.00 13.88           C  
ATOM   1010  CG  PHE A 132       9.528  -0.528  17.191  1.00 11.61           C  
ATOM   1011  CD1 PHE A 132       9.322   0.696  16.563  1.00 14.00           C  
ATOM   1012  CD2 PHE A 132      10.073  -0.530  18.481  1.00 13.83           C  
ATOM   1013  CE1 PHE A 132       9.654   1.896  17.232  1.00 12.39           C  
ATOM   1014  CE2 PHE A 132      10.394   0.664  19.140  1.00 13.86           C  
ATOM   1015  CZ  PHE A 132      10.181   1.863  18.512  1.00 13.04           C  
ATOM   1016  N   TYR A 133      10.205  -4.127  14.142  1.00  9.97           N  
ATOM   1017  CA  TYR A 133      10.135  -5.527  13.708  1.00 11.88           C  
ATOM   1018  C   TYR A 133      10.846  -6.469  14.654  1.00 12.21           C  
ATOM   1019  O   TYR A 133      12.047  -6.305  14.921  1.00 10.76           O  
ATOM   1020  CB  TYR A 133      10.796  -5.676  12.339  1.00 12.57           C  
ATOM   1021  CG  TYR A 133      10.154  -4.834  11.270  1.00 14.35           C  
ATOM   1022  CD1 TYR A 133       8.859  -5.113  10.831  1.00 17.29           C  
ATOM   1023  CD2 TYR A 133      10.841  -3.761  10.697  1.00 14.65           C  
ATOM   1024  CE1 TYR A 133       8.260  -4.345   9.836  1.00 17.87           C  
ATOM   1025  CE2 TYR A 133      10.245  -2.979   9.704  1.00 16.04           C  
ATOM   1026  CZ  TYR A 133       8.971  -3.286   9.287  1.00 15.66           C  
ATOM   1027  OH  TYR A 133       8.390  -2.532   8.284  1.00 18.26           O  
ATOM   1028  N   GLN A 134      10.118  -7.447  15.175  1.00 12.35           N  
ATOM   1029  CA  GLN A 134      10.735  -8.425  16.052  1.00 13.72           C  
ATOM   1030  C   GLN A 134      11.255  -9.568  15.189  1.00 13.94           C  
ATOM   1031  O   GLN A 134      10.552 -10.033  14.277  1.00 17.03           O  
ATOM   1032  CB  GLN A 134       9.707  -8.913  17.077  1.00 15.57           C  
ATOM   1033  CG  GLN A 134      10.269  -9.742  18.224  1.00 18.34           C  
ATOM   1034  CD  GLN A 134      10.213 -11.209  17.947  1.00 20.25           C  
ATOM   1035  OE1 GLN A 134       9.242 -11.694  17.363  1.00 20.64           O  
ATOM   1036  NE2 GLN A 134      11.245 -11.943  18.379  1.00 21.23           N  
ATOM   1037  N   VAL A 135      12.485  -9.999  15.441  1.00 14.17           N  
ATOM   1038  CA  VAL A 135      13.090 -11.091  14.685  1.00 15.53           C  
ATOM   1039  C   VAL A 135      13.554 -12.133  15.696  1.00 14.34           C  
ATOM   1040  O   VAL A 135      14.213 -11.812  16.696  1.00 14.10           O  
ATOM   1041  CB  VAL A 135      14.293 -10.590  13.903  1.00 15.06           C  
ATOM   1042  CG1 VAL A 135      15.029 -11.756  13.202  1.00 17.25           C  
ATOM   1043  CG2 VAL A 135      13.839  -9.557  12.875  1.00 17.92           C  
ATOM   1044  N   THR A 136      13.186 -13.389  15.448  1.00 15.54           N  
ATOM   1045  CA  THR A 136      13.580 -14.463  16.356  1.00 15.85           C  
ATOM   1046  C   THR A 136      15.015 -14.918  16.111  1.00 16.29           C  
ATOM   1047  O   THR A 136      15.383 -15.297  14.997  1.00 16.43           O  
ATOM   1048  CB  THR A 136      12.651 -15.675  16.202  1.00 19.85           C  
ATOM   1049  OG1 THR A 136      11.292 -15.259  16.402  1.00 23.58           O  
ATOM   1050  CG2 THR A 136      13.005 -16.743  17.236  1.00 22.34           C  
ATOM   1051  N   LEU A 137      15.830 -14.844  17.157  1.00 13.22           N  
ATOM   1052  CA  LEU A 137      17.214 -15.304  17.116  1.00 12.55           C  
ATOM   1053  C   LEU A 137      17.326 -16.317  18.227  1.00 11.55           C  
ATOM   1054  O   LEU A 137      16.888 -16.076  19.348  1.00 11.80           O  
ATOM   1055  CB  LEU A 137      18.217 -14.175  17.389  1.00 12.75           C  
ATOM   1056  CG  LEU A 137      18.456 -13.131  16.303  1.00 12.59           C  
ATOM   1057  CD1 LEU A 137      19.522 -12.149  16.810  1.00 13.04           C  
ATOM   1058  CD2 LEU A 137      18.912 -13.770  15.001  1.00 18.37           C  
ATOM   1059  N   THR A 138      17.928 -17.460  17.915  1.00 12.84           N  
ATOM   1060  CA  THR A 138      18.092 -18.505  18.917  1.00 13.83           C  
ATOM   1061  C   THR A 138      18.835 -18.006  20.155  1.00 12.94           C  
ATOM   1062  O   THR A 138      18.553 -18.463  21.277  1.00 14.37           O  
ATOM   1063  CB  THR A 138      18.854 -19.719  18.290  1.00 16.76           C  
ATOM   1064  OG1 THR A 138      18.182 -20.135  17.092  1.00 23.11           O  
ATOM   1065  CG2 THR A 138      18.906 -20.882  19.275  1.00 19.17           C  
ATOM   1066  N   GLU A 139      19.761 -17.071  19.964  1.00 10.65           N  
ATOM   1067  CA  GLU A 139      20.586 -16.568  21.062  1.00 10.17           C  
ATOM   1068  C   GLU A 139      19.985 -15.347  21.770  1.00  9.53           C  
ATOM   1069  O   GLU A 139      20.656 -14.704  22.563  1.00 10.67           O  
ATOM   1070  CB  GLU A 139      21.984 -16.182  20.545  1.00 11.63           C  
ATOM   1071  CG  GLU A 139      21.986 -15.000  19.566  1.00 12.20           C  
ATOM   1072  CD  GLU A 139      21.997 -15.410  18.105  1.00 10.43           C  
ATOM   1073  OE1 GLU A 139      21.231 -16.309  17.737  1.00 13.15           O  
ATOM   1074  OE2 GLU A 139      22.744 -14.792  17.337  1.00 11.09           O  
ATOM   1075  N   HIS A 140      18.706 -15.076  21.544  1.00  9.99           N  
ATOM   1076  CA  HIS A 140      18.137 -13.857  22.143  1.00 10.54           C  
ATOM   1077  C   HIS A 140      18.129 -13.761  23.643  1.00 10.84           C  
ATOM   1078  O   HIS A 140      18.040 -12.646  24.180  1.00  9.93           O  
ATOM   1079  CB  HIS A 140      16.735 -13.580  21.624  1.00 10.86           C  
ATOM   1080  CG  HIS A 140      15.680 -14.444  22.226  1.00 12.31           C  
ATOM   1081  ND1 HIS A 140      15.395 -15.702  21.751  1.00 11.99           N  
ATOM   1082  CD2 HIS A 140      14.805 -14.212  23.236  1.00 14.57           C  
ATOM   1083  CE1 HIS A 140      14.389 -16.211  22.440  1.00 15.63           C  
ATOM   1084  NE2 HIS A 140      14.007 -15.327  23.344  1.00 13.61           N  
ATOM   1085  N   LEU A 141      18.217 -14.891  24.347  1.00  9.85           N  
ATOM   1086  CA  LEU A 141      18.258 -14.828  25.788  1.00 10.32           C  
ATOM   1087  C   LEU A 141      19.676 -14.846  26.333  1.00  9.64           C  
ATOM   1088  O   LEU A 141      19.866 -14.691  27.549  1.00 11.71           O  
ATOM   1089  CB  LEU A 141      17.468 -15.992  26.413  1.00 14.44           C  
ATOM   1090  CG  LEU A 141      15.976 -15.949  26.096  1.00 15.17           C  
ATOM   1091  CD1 LEU A 141      15.317 -17.228  26.655  1.00 18.99           C  
ATOM   1092  CD2 LEU A 141      15.340 -14.693  26.729  1.00 17.48           C  
ATOM   1093  N   SER A 142      20.686 -15.018  25.475  1.00  8.99           N  
ATOM   1094  CA  SER A 142      22.057 -15.080  25.960  1.00  9.95           C  
ATOM   1095  C   SER A 142      22.488 -13.903  26.829  1.00  8.38           C  
ATOM   1096  O   SER A 142      23.171 -14.099  27.832  1.00  9.59           O  
ATOM   1097  CB  SER A 142      23.051 -15.219  24.804  1.00 10.59           C  
ATOM   1098  OG  SER A 142      22.919 -16.496  24.205  1.00 17.01           O  
ATOM   1099  N   PRO A 143      22.087 -12.657  26.475  1.00  8.21           N  
ATOM   1100  CA  PRO A 143      22.519 -11.537  27.334  1.00  7.77           C  
ATOM   1101  C   PRO A 143      21.996 -11.693  28.782  1.00  6.42           C  
ATOM   1102  O   PRO A 143      22.679 -11.358  29.737  1.00  8.09           O  
ATOM   1103  CB  PRO A 143      21.927 -10.289  26.632  1.00  7.89           C  
ATOM   1104  CG  PRO A 143      21.870 -10.692  25.168  1.00  8.08           C  
ATOM   1105  CD  PRO A 143      21.366 -12.169  25.278  1.00  9.19           C  
ATOM   1106  N   PHE A 144      20.735 -12.133  28.862  1.00  8.34           N  
ATOM   1107  CA  PHE A 144      20.104 -12.301  30.190  1.00  8.32           C  
ATOM   1108  C   PHE A 144      20.713 -13.449  30.955  1.00  9.48           C  
ATOM   1109  O   PHE A 144      20.822 -13.375  32.177  1.00  9.68           O  
ATOM   1110  CB  PHE A 144      18.603 -12.424  30.047  1.00  9.14           C  
ATOM   1111  CG  PHE A 144      18.013 -11.291  29.281  1.00  8.48           C  
ATOM   1112  CD1 PHE A 144      18.088  -9.991  29.773  1.00  9.90           C  
ATOM   1113  CD2 PHE A 144      17.443 -11.509  28.043  1.00 11.31           C  
ATOM   1114  CE1 PHE A 144      17.576  -8.906  28.995  1.00 10.57           C  
ATOM   1115  CE2 PHE A 144      16.952 -10.432  27.289  1.00 10.73           C  
ATOM   1116  CZ  PHE A 144      17.021  -9.154  27.776  1.00 10.69           C  
ATOM   1117  N   GLN A 145      21.148 -14.489  30.245  1.00 10.60           N  
ATOM   1118  CA  GLN A 145      21.854 -15.594  30.917  1.00 11.10           C  
ATOM   1119  C   GLN A 145      23.205 -15.064  31.412  1.00 10.62           C  
ATOM   1120  O   GLN A 145      23.626 -15.375  32.540  1.00 12.60           O  
ATOM   1121  CB  GLN A 145      22.025 -16.749  29.925  1.00 12.73           C  
ATOM   1122  CG  GLN A 145      20.661 -17.338  29.580  1.00 17.26           C  
ATOM   1123  CD  GLN A 145      20.629 -18.269  28.382  1.00 21.18           C  
ATOM   1124  OE1 GLN A 145      19.591 -18.880  28.106  1.00 27.15           O  
ATOM   1125  NE2 GLN A 145      21.742 -18.378  27.659  1.00 20.01           N  
ATOM   1126  N   ALA A 146      23.894 -14.273  30.597  1.00  9.91           N  
ATOM   1127  CA  ALA A 146      25.154 -13.669  31.045  1.00  9.96           C  
ATOM   1128  C   ALA A 146      24.917 -12.850  32.311  1.00  9.11           C  
ATOM   1129  O   ALA A 146      25.678 -12.900  33.261  1.00  9.83           O  
ATOM   1130  CB  ALA A 146      25.744 -12.757  29.932  1.00 10.61           C  
ATOM   1131  N   TRP A 147      23.877 -12.015  32.304  1.00  9.74           N  
ATOM   1132  CA  TRP A 147      23.570 -11.176  33.453  1.00  9.14           C  
ATOM   1133  C   TRP A 147      23.299 -11.998  34.710  1.00  9.69           C  
ATOM   1134  O   TRP A 147      23.850 -11.688  35.754  1.00 10.45           O  
ATOM   1135  CB  TRP A 147      22.371 -10.301  33.097  1.00  9.53           C  
ATOM   1136  CG  TRP A 147      21.965  -9.306  34.165  1.00  8.35           C  
ATOM   1137  CD1 TRP A 147      20.802  -9.331  34.869  1.00  9.64           C  
ATOM   1138  CD2 TRP A 147      22.652  -8.111  34.549  1.00  8.48           C  
ATOM   1139  NE1 TRP A 147      20.718  -8.211  35.657  1.00 10.55           N  
ATOM   1140  CE2 TRP A 147      21.832  -7.449  35.492  1.00  8.88           C  
ATOM   1141  CE3 TRP A 147      23.874  -7.532  34.196  1.00  9.74           C  
ATOM   1142  CZ2 TRP A 147      22.189  -6.228  36.082  1.00 10.39           C  
ATOM   1143  CZ3 TRP A 147      24.225  -6.312  34.782  1.00 11.22           C  
ATOM   1144  CH2 TRP A 147      23.380  -5.677  35.710  1.00 11.41           C  
ATOM   1145  N   ARG A 148      22.450 -13.011  34.596  1.00 10.55           N  
ATOM   1146  CA  ARG A 148      22.151 -13.848  35.772  1.00 14.91           C  
ATOM   1147  C   ARG A 148      23.423 -14.460  36.333  1.00 14.81           C  
ATOM   1148  O   ARG A 148      23.580 -14.556  37.559  1.00 16.82           O  
ATOM   1149  CB  ARG A 148      21.161 -14.934  35.386  1.00 16.08           C  
ATOM   1150  CG  ARG A 148      20.858 -15.944  36.479  1.00 23.25           C  
ATOM   1151  CD  ARG A 148      19.876 -16.982  35.952  1.00 27.07           C  
ATOM   1152  NE  ARG A 148      19.854 -18.195  36.769  1.00 31.47           N  
ATOM   1153  CZ  ARG A 148      19.069 -19.242  36.533  1.00 31.87           C  
ATOM   1154  NH1 ARG A 148      18.227 -19.234  35.499  1.00 33.20           N  
ATOM   1155  NH2 ARG A 148      19.131 -20.308  37.326  1.00 31.86           N  
ATOM   1156  N   ASN A 149      24.349 -14.839  35.462  1.00 13.34           N  
ATOM   1157  CA  ASN A 149      25.591 -15.451  35.911  1.00 14.04           C  
ATOM   1158  C   ASN A 149      26.734 -14.516  36.232  1.00 16.03           C  
ATOM   1159  O   ASN A 149      27.793 -14.984  36.619  1.00 16.58           O  
ATOM   1160  CB  ASN A 149      26.067 -16.466  34.884  1.00 17.15           C  
ATOM   1161  CG  ASN A 149      25.095 -17.616  34.728  1.00 19.25           C  
ATOM   1162  OD1 ASN A 149      24.485 -18.059  35.712  1.00 23.59           O  
ATOM   1163  ND2 ASN A 149      24.933 -18.103  33.507  1.00 22.52           N  
ATOM   1164  N   PHE A 150      26.539 -13.204  36.091  1.00 13.59           N  
ATOM   1165  CA  PHE A 150      27.615 -12.264  36.347  1.00 12.61           C  
ATOM   1166  C   PHE A 150      27.553 -11.871  37.825  1.00 13.80           C  
ATOM   1167  O   PHE A 150      26.727 -11.053  38.260  1.00 15.11           O  
ATOM   1168  CB  PHE A 150      27.487 -11.036  35.428  1.00 12.14           C  
ATOM   1169  CG  PHE A 150      28.707 -10.187  35.392  1.00 11.30           C  
ATOM   1170  CD1 PHE A 150      29.903 -10.666  34.860  1.00 12.73           C  
ATOM   1171  CD2 PHE A 150      28.692  -8.891  35.922  1.00 12.17           C  
ATOM   1172  CE1 PHE A 150      31.056  -9.876  34.857  1.00 12.77           C  
ATOM   1173  CE2 PHE A 150      29.839  -8.111  35.920  1.00 11.73           C  
ATOM   1174  CZ  PHE A 150      31.018  -8.602  35.389  1.00 13.20           C  
ATOM   1175  N   ALA A 151      28.459 -12.458  38.601  1.00 15.28           N  
ATOM   1176  CA  ALA A 151      28.477 -12.255  40.045  1.00 17.15           C  
ATOM   1177  C   ALA A 151      28.569 -10.823  40.505  1.00 17.44           C  
ATOM   1178  O   ALA A 151      27.868 -10.452  41.449  1.00 17.42           O  
ATOM   1179  CB  ALA A 151      29.628 -13.067  40.665  1.00 18.39           C  
ATOM   1180  N   ASN A 152      29.427 -10.037  39.860  1.00 15.75           N  
ATOM   1181  CA  ASN A 152      29.661  -8.644  40.233  1.00 17.79           C  
ATOM   1182  C   ASN A 152      28.728  -7.620  39.571  1.00 15.13           C  
ATOM   1183  O   ASN A 152      29.066  -6.441  39.488  1.00 17.29           O  
ATOM   1184  CB  ASN A 152      31.123  -8.262  39.941  1.00 22.07           C  
ATOM   1185  CG  ASN A 152      32.132  -9.047  40.794  1.00 26.84           C  
ATOM   1186  OD1 ASN A 152      32.369 -10.242  40.576  1.00 31.44           O  
ATOM   1187  ND2 ASN A 152      32.727  -8.369  41.769  1.00 30.95           N  
ATOM   1188  N   LYS A 153      27.560  -8.063  39.130  1.00 15.24           N  
ATOM   1189  CA  LYS A 153      26.633  -7.129  38.487  1.00 14.92           C  
ATOM   1190  C   LYS A 153      26.175  -6.033  39.427  1.00 15.50           C  
ATOM   1191  O   LYS A 153      26.153  -6.216  40.641  1.00 16.58           O  
ATOM   1192  CB  LYS A 153      25.410  -7.877  37.973  1.00 15.77           C  
ATOM   1193  CG  LYS A 153      24.517  -8.554  38.995  1.00 18.05           C  
ATOM   1194  CD  LYS A 153      23.312  -9.166  38.247  1.00 19.67           C  
ATOM   1195  CE  LYS A 153      22.848 -10.453  38.829  1.00 24.66           C  
ATOM   1196  NZ  LYS A 153      23.903 -11.456  38.627  1.00 20.65           N  
ATOM   1197  N   LYS A 154      25.845  -4.878  38.867  1.00 13.60           N  
ATOM   1198  CA  LYS A 154      25.316  -3.764  39.643  1.00 13.86           C  
ATOM   1199  C   LYS A 154      23.920  -3.540  39.055  1.00 11.92           C  
ATOM   1200  O   LYS A 154      23.763  -3.082  37.901  1.00 10.43           O  
ATOM   1201  CB  LYS A 154      26.179  -2.518  39.465  1.00 16.09           C  
ATOM   1202  CG  LYS A 154      27.562  -2.608  40.084  1.00 19.79           C  
ATOM   1203  CD  LYS A 154      28.247  -1.255  40.078  1.00 25.31           C  
ATOM   1204  CE  LYS A 154      29.676  -1.367  40.584  1.00 26.71           C  
ATOM   1205  NZ  LYS A 154      30.604  -0.591  39.695  1.00 30.06           N  
ATOM   1206  N   GLU A 155      22.898  -3.820  39.846  1.00 11.53           N  
ATOM   1207  CA  GLU A 155      21.533  -3.688  39.388  1.00 11.65           C  
ATOM   1208  C   GLU A 155      21.129  -2.233  39.212  1.00  9.82           C  
ATOM   1209  O   GLU A 155      21.676  -1.366  39.872  1.00 11.05           O  
ATOM   1210  CB  GLU A 155      20.597  -4.357  40.386  1.00 14.12           C  
ATOM   1211  CG  GLU A 155      20.726  -5.891  40.369  1.00 19.63           C  
ATOM   1212  CD  GLU A 155      20.067  -6.565  41.560  1.00 25.08           C  
ATOM   1213  OE1 GLU A 155      19.873  -7.800  41.505  1.00 29.24           O  
ATOM   1214  OE2 GLU A 155      19.759  -5.865  42.548  1.00 29.90           O  
ATOM   1215  N   TYR A 156      20.190  -2.003  38.297  1.00  8.82           N  
ATOM   1216  CA  TYR A 156      19.685  -0.659  38.024  1.00  8.67           C  
ATOM   1217  C   TYR A 156      18.287  -0.752  37.451  1.00  8.33           C  
ATOM   1218  O   TYR A 156      17.818  -1.864  37.124  1.00 10.88           O  
ATOM   1219  CB  TYR A 156      20.655   0.061  37.054  1.00  8.49           C  
ATOM   1220  CG  TYR A 156      20.734  -0.553  35.667  1.00  8.89           C  
ATOM   1221  CD1 TYR A 156      19.842  -0.153  34.664  1.00  8.67           C  
ATOM   1222  CD2 TYR A 156      21.610  -1.620  35.408  1.00  9.07           C  
ATOM   1223  CE1 TYR A 156      19.789  -0.811  33.428  1.00  8.97           C  
ATOM   1224  CE2 TYR A 156      21.584  -2.288  34.148  1.00  8.97           C  
ATOM   1225  CZ  TYR A 156      20.668  -1.884  33.187  1.00  8.12           C  
ATOM   1226  OH  TYR A 156      20.602  -2.572  32.003  1.00  8.23           O  
ATOM   1227  OXT TYR A 156      17.631   0.321  37.336  1.00 10.06           O  
TER    1228      TYR A 156                                                      
END
MOLECULE T0461.pdb
ATOM      1  N   GLU    16      19.319  11.894  58.181  1.00 47.03           N  
ATOM      2  CA  GLU    16      18.212  11.089  57.593  1.00 47.23           C  
ATOM      4  CB  GLU    16      18.010   9.793  58.377  1.00 47.32           C  
ATOM      7  CG  GLU    16      17.576   8.619  57.509  1.00 48.39           C  
ATOM     10  CD  GLU    16      17.064   7.416  58.327  1.00 50.46           C  
ATOM     11  OE1 GLU    16      16.178   6.689  57.811  1.00 51.91           O  
ATOM     12  OE2 GLU    16      17.526   7.196  59.479  1.00 50.93           O  
ATOM     13  C   GLU    16      16.896  11.864  57.561  1.00 47.09           C  
ATOM     14  O   GLU    16      15.891  11.376  57.001  1.00 48.08           O  
ATOM     18  N   ASN    17      16.888  13.066  58.143  1.00 46.06           N  
ATOM     19  CA  ASN    17      15.679  13.870  58.188  1.00 45.28           C  
ATOM     21  CB  ASN    17      15.631  14.676  59.487  1.00 45.17           C  
ATOM     24  CG  ASN    17      14.246  15.250  59.773  1.00 44.92           C  
ATOM     25  OD1 ASN    17      13.421  15.378  58.885  1.00 45.51           O  
ATOM     26  ND2 ASN    17      13.989  15.591  61.023  1.00 45.12           N  
ATOM     29  C   ASN    17      15.619  14.792  56.990  1.00 44.97           C  
ATOM     30  O   ASN    17      16.071  15.922  57.046  1.00 44.78           O  
ATOM     32  N   LEU    18      15.026  14.320  55.910  1.00 45.02           N  
ATOM     33  CA  LEU    18      14.988  15.101  54.659  1.00 45.41           C  
ATOM     35  CB  LEU    18      14.792  14.167  53.453  1.00 45.35           C  
ATOM     38  CG  LEU    18      15.875  13.083  53.322  1.00 45.26           C  
ATOM     40  CD1 LEU    18      15.492  12.097  52.210  1.00 45.69           C  
ATOM     44  CD2 LEU    18      17.267  13.703  53.084  1.00 42.76           C  
ATOM     48  C   LEU    18      13.920  16.202  54.656  1.00 45.40           C  
ATOM     49  O   LEU    18      12.854  16.047  55.244  1.00 46.03           O  
ATOM     51  N   TYR    19      14.208  17.291  53.954  1.00 45.10           N  
ATOM     52  CA  TYR    19      13.361  18.473  53.903  1.00 44.79           C  
ATOM     54  CB  TYR    19      14.284  19.669  53.829  1.00 45.04           C  
ATOM     57  CG  TYR    19      13.663  21.040  53.814  1.00 45.91           C  
ATOM     58  CD1 TYR    19      13.769  21.878  54.930  1.00 46.50           C  
ATOM     60  CE1 TYR    19      13.223  23.142  54.930  1.00 46.23           C  
ATOM     62  CZ  TYR    19      12.595  23.603  53.806  1.00 45.82           C  
ATOM     63  OH  TYR    19      12.078  24.858  53.838  1.00 47.34           O  
ATOM     65  CE2 TYR    19      12.478  22.813  52.668  1.00 46.79           C  
ATOM     67  CD2 TYR    19      13.017  21.538  52.672  1.00 46.25           C  
ATOM     69  C   TYR    19      12.486  18.434  52.655  1.00 45.02           C  
ATOM     70  O   TYR    19      12.973  18.134  51.545  1.00 44.56           O  
ATOM     72  N   PHE    20      11.200  18.768  52.836  1.00 45.35           N  
ATOM     73  CA  PHE    20      10.180  18.735  51.761  1.00 44.99           C  
ATOM     75  CB  PHE    20       8.875  18.070  52.229  1.00 44.60           C  
ATOM     78  CG  PHE    20       8.967  16.583  52.430  1.00 44.31           C  
ATOM     79  CD1 PHE    20       8.814  16.023  53.683  1.00 45.43           C  
ATOM     81  CE1 PHE    20       8.871  14.634  53.877  1.00 44.99           C  
ATOM     83  CZ  PHE    20       9.077  13.820  52.843  1.00 43.54           C  
ATOM     85  CE2 PHE    20       9.199  14.351  51.588  1.00 44.96           C  
ATOM     87  CD2 PHE    20       9.152  15.735  51.379  1.00 44.56           C  
ATOM     89  C   PHE    20       9.859  20.151  51.339  1.00 44.84           C  
ATOM     90  O   PHE    20       9.575  20.984  52.162  1.00 45.26           O  
ATOM     92  N   GLN    21       9.875  20.414  50.048  1.00 45.39           N  
ATOM     93  CA  GLN    21       9.553  21.743  49.542  1.00 45.85           C  
ATOM     95  CB  GLN    21       9.966  21.882  48.065  1.00 46.10           C  
ATOM     98  CG  GLN    21      11.462  21.638  47.776  1.00 45.85           C  
ATOM    101  CD  GLN    21      12.355  22.618  48.495  1.00 46.50           C  
ATOM    102  OE1 GLN    21      12.212  23.845  48.353  1.00 47.26           O  
ATOM    103  NE2 GLN    21      13.273  22.092  49.288  1.00 45.90           N  
ATOM    106  C   GLN    21       8.049  22.035  49.714  1.00 46.07           C  
ATOM    107  O   GLN    21       7.198  21.166  49.469  1.00 45.86           O  
ATOM    109  N   SER    22       7.741  23.259  50.150  1.00 45.86           N  
ATOM    110  CA  SER    22       6.375  23.680  50.384  1.00 45.60           C  
ATOM    112  CB  SER    22       6.366  24.830  51.367  1.00 45.59           C  
ATOM    115  OG  SER    22       6.782  26.037  50.750  1.00 46.30           O  
ATOM    117  C   SER    22       5.742  24.134  49.088  1.00 45.80           C  
ATOM    118  O   SER    22       6.407  24.114  48.046  1.00 45.84           O  
ATOM    120  N   MET    23       4.473  24.560  49.153  1.00 46.02           N  
ATOM    121  CA  MET    23       3.772  25.115  47.983  1.00 46.05           C  
ATOM    123  CB  MET    23       2.313  25.460  48.298  1.00 46.56           C  
ATOM    126  CG  MET    23       1.275  24.330  48.059  1.00 48.82           C  
ATOM    129  SD  MET    23       1.254  23.496  46.412  1.00 52.49           S  
ATOM    130  CE  MET    23      -0.396  22.776  46.537  1.00 50.38           C  
ATOM    134  C   MET    23       4.432  26.367  47.439  1.00 45.55           C  
ATOM    135  O   MET    23       4.601  26.477  46.236  1.00 45.57           O  
ATOM    137  N   GLU    24       4.773  27.312  48.309  1.00 45.12           N  
ATOM    138  CA  GLU    24       5.405  28.529  47.862  1.00 45.24           C  
ATOM    140  CB  GLU    24       5.574  29.505  49.001  1.00 45.00           C  
ATOM    143  CG  GLU    24       4.249  30.004  49.540  1.00 45.52           C  
ATOM    146  CD  GLU    24       4.420  31.305  50.323  1.00 47.26           C  
ATOM    147  OE1 GLU    24       5.446  31.973  50.070  1.00 48.66           O  
ATOM    148  OE2 GLU    24       3.543  31.676  51.171  1.00 46.60           O  
ATOM    149  C   GLU    24       6.756  28.195  47.248  1.00 45.58           C  
ATOM    150  O   GLU    24       7.118  28.700  46.165  1.00 45.97           O  
ATOM    152  N   GLU    25       7.499  27.321  47.916  1.00 45.42           N  
ATOM    153  CA  GLU    25       8.791  26.893  47.383  1.00 45.38           C  
ATOM    155  CB  GLU    25       9.527  26.016  48.395  1.00 45.48           C  
ATOM    158  CG  GLU    25       9.801  26.759  49.699  1.00 46.23           C  
ATOM    161  CD  GLU    25      10.373  25.873  50.810  1.00 47.64           C  
ATOM    162  OE1 GLU    25       9.890  24.719  51.016  1.00 46.52           O  
ATOM    163  OE2 GLU    25      11.298  26.364  51.498  1.00 48.29           O  
ATOM    164  C   GLU    25       8.695  26.205  46.022  1.00 44.72           C  
ATOM    165  O   GLU    25       9.574  26.385  45.200  1.00 44.67           O  
ATOM    167  N   THR    26       7.633  25.425  45.805  1.00 44.33           N  
ATOM    168  CA  THR    26       7.333  24.809  44.497  1.00 43.62           C  
ATOM    170  CB  THR    26       6.097  23.810  44.583  1.00 43.61           C  
ATOM    172  OG1 THR    26       6.387  22.773  45.511  1.00 42.09           O  
ATOM    174  CG2 THR    26       5.748  23.157  43.247  1.00 42.42           C  
ATOM    178  C   THR    26       7.092  25.942  43.492  1.00 43.04           C  
ATOM    179  O   THR    26       7.712  25.993  42.437  1.00 42.50           O  
ATOM    181  N   GLU    27       6.220  26.875  43.843  1.00 42.37           N  
ATOM    182  CA  GLU    27       5.971  28.002  42.978  1.00 42.31           C  
ATOM    184  CB  GLU    27       5.035  29.005  43.622  1.00 42.84           C  
ATOM    187  CG  GLU    27       3.580  28.566  43.707  1.00 44.60           C  
ATOM    190  CD  GLU    27       2.700  29.690  44.267  1.00 47.31           C  
ATOM    191  OE1 GLU    27       3.193  30.857  44.272  1.00 48.72           O  
ATOM    192  OE2 GLU    27       1.529  29.432  44.703  1.00 48.41           O  
ATOM    193  C   GLU    27       7.270  28.692  42.631  1.00 40.95           C  
ATOM    194  O   GLU    27       7.497  29.041  41.480  1.00 41.59           O  
ATOM    196  N   LYS    28       8.126  28.886  43.622  1.00 39.03           N  
ATOM    197  CA  LYS    28       9.440  29.455  43.359  1.00 37.62           C  
ATOM    199  CB  LYS    28      10.250  29.534  44.641  1.00 37.50           C  
ATOM    202  CG  LYS    28      11.590  30.230  44.447  1.00 38.41           C  
ATOM    205  CD  LYS    28      12.753  29.466  45.069  1.00 39.23           C  
ATOM    208  CE  LYS    28      12.679  29.456  46.565  1.00 38.91           C  
ATOM    211  NZ  LYS    28      13.578  28.418  47.073  1.00 40.24           N  
ATOM    215  C   LYS    28      10.246  28.672  42.302  1.00 35.90           C  
ATOM    216  O   LYS    28      10.746  29.267  41.371  1.00 36.93           O  
ATOM    218  N   TRP    29      10.371  27.357  42.443  1.00 33.27           N  
ATOM    219  CA  TRP    29      11.165  26.570  41.498  1.00 31.54           C  
ATOM    221  CB  TRP    29      11.338  25.115  41.957  1.00 30.99           C  
ATOM    224  CG  TRP    29      11.998  24.926  43.278  1.00 30.44           C  
ATOM    225  CD1 TRP    29      11.570  24.110  44.281  1.00 30.13           C  
ATOM    227  NE1 TRP    29      12.435  24.175  45.351  1.00 30.02           N  
ATOM    229  CE2 TRP    29      13.444  25.050  45.056  1.00 29.08           C  
ATOM    230  CD2 TRP    29      13.206  25.551  43.764  1.00 29.84           C  
ATOM    231  CE3 TRP    29      14.106  26.479  43.230  1.00 30.17           C  
ATOM    233  CZ3 TRP    29      15.182  26.878  43.993  1.00 29.10           C  
ATOM    235  CH2 TRP    29      15.381  26.365  45.270  1.00 28.82           C  
ATOM    237  CZ2 TRP    29      14.522  25.453  45.820  1.00 28.69           C  
ATOM    239  C   TRP    29      10.577  26.553  40.093  1.00 30.66           C  
ATOM    240  O   TRP    29      11.321  26.503  39.114  1.00 30.04           O  
ATOM    242  N   MET    30       9.250  26.560  39.994  1.00 29.83           N  
ATOM    243  CA  MET    30       8.583  26.606  38.693  1.00 29.32           C  
ATOM    245  CB  MET    30       7.080  26.363  38.827  1.00 29.13           C  
ATOM    248  CG  MET    30       6.695  24.908  39.105  1.00 28.73           C  
ATOM    251  SD  MET    30       7.113  23.702  37.840  1.00 25.62           S  
ATOM    252  CE  MET    30       6.050  24.188  36.496  1.00 25.40           C  
ATOM    256  C   MET    30       8.816  27.922  37.964  1.00 28.82           C  
ATOM    257  O   MET    30       8.940  27.927  36.765  1.00 28.66           O  
ATOM    259  N   GLU    31       8.873  29.027  38.689  1.00 28.72           N  
ATOM    260  CA  GLU    31       9.214  30.321  38.090  1.00 29.06           C  
ATOM    262  CB  GLU    31       9.174  31.465  39.137  1.00 29.45           C  
ATOM    265  CG  GLU    31       7.991  32.434  39.044  1.00 29.57           C  
ATOM    268  CD  GLU    31       7.831  33.294  40.339  1.00 33.21           C  
ATOM    269  OE1 GLU    31       7.467  34.564  40.270  1.00 32.31           O  
ATOM    270  OE2 GLU    31       8.075  32.684  41.452  1.00 35.33           O  
ATOM    271  C   GLU    31      10.604  30.262  37.479  1.00 28.87           C  
ATOM    272  O   GLU    31      10.827  30.752  36.382  1.00 28.74           O  
ATOM    274  N   GLU    32      11.544  29.670  38.205  1.00 28.87           N  
ATOM    275  CA  GLU    32      12.909  29.533  37.701  1.00 29.07           C  
ATOM    277  CB  GLU    32      13.876  29.003  38.777  1.00 29.29           C  
ATOM    280  CG  GLU    32      15.319  29.531  38.660  1.00 30.35           C  
ATOM    283  CD  GLU    32      16.038  29.670  40.034  1.00 32.92           C  
ATOM    284  OE1 GLU    32      16.446  28.584  40.580  1.00 33.02           O  
ATOM    285  OE2 GLU    32      16.223  30.868  40.532  1.00 32.31           O  
ATOM    286  C   GLU    32      12.932  28.636  36.474  1.00 29.00           C  
ATOM    287  O   GLU    32      13.630  28.954  35.536  1.00 29.87           O  
ATOM    289  N   ALA    33      12.176  27.534  36.469  1.00 28.65           N  
ATOM    290  CA  ALA    33      12.074  26.677  35.272  1.00 28.41           C  
ATOM    292  CB  ALA    33      11.272  25.376  35.580  1.00 28.13           C  
ATOM    296  C   ALA    33      11.467  27.433  34.073  1.00 27.98           C  
ATOM    297  O   ALA    33      11.779  27.140  32.919  1.00 27.17           O  
ATOM    299  N   MET    34      10.613  28.412  34.367  1.00 27.93           N  
ATOM    300  CA  MET    34       9.948  29.219  33.339  1.00 28.14           C  
ATOM    302  CB  MET    34       8.803  30.030  33.949  1.00 28.21           C  
ATOM    305  CG  MET    34       7.517  29.250  34.113  1.00 28.80           C  
ATOM    308  SD  MET    34       6.705  28.872  32.536  1.00 30.50           S  
ATOM    309  CE  MET    34       6.132  30.522  32.012  1.00 29.12           C  
ATOM    313  C   MET    34      10.916  30.175  32.664  1.00 28.10           C  
ATOM    314  O   MET    34      10.875  30.374  31.449  1.00 27.67           O  
ATOM    316  N   HIS    35      11.789  30.765  33.467  1.00 28.28           N  
ATOM    317  CA  HIS    35      12.821  31.630  32.951  1.00 28.33           C  
ATOM    319  CB  HIS    35      13.581  32.265  34.112  1.00 28.41           C  
ATOM    322  CG  HIS    35      12.858  33.425  34.730  1.00 29.93           C  
ATOM    323  ND1 HIS    35      11.876  34.132  34.062  1.00 31.57           N  
ATOM    325  CE1 HIS    35      11.437  35.118  34.832  1.00 31.30           C  
ATOM    327  NE2 HIS    35      12.092  35.071  35.978  1.00 31.32           N  
ATOM    329  CD2 HIS    35      12.985  34.021  35.943  1.00 31.00           C  
ATOM    331  C   HIS    35      13.742  30.839  32.027  1.00 28.17           C  
ATOM    332  O   HIS    35      14.065  31.289  30.934  1.00 27.82           O  
ATOM    334  N   MET    36      14.123  29.641  32.458  1.00 28.15           N  
ATOM    335  CA  MET    36      14.961  28.760  31.661  1.00 28.40           C  
ATOM    337  CB  MET    36      15.322  27.506  32.450  1.00 28.40           C  
ATOM    340  CG  MET    36      16.315  27.796  33.560  1.00 29.25           C  
ATOM    343  SD  MET    36      16.813  26.309  34.428  1.00 31.57           S  
ATOM    344  CE  MET    36      18.067  25.576  33.340  1.00 32.53           C  
ATOM    348  C   MET    36      14.308  28.388  30.336  1.00 28.59           C  
ATOM    349  O   MET    36      14.979  28.316  29.303  1.00 28.44           O  
ATOM    351  N   ALA    37      12.999  28.161  30.359  1.00 28.78           N  
ATOM    352  CA  ALA    37      12.272  27.908  29.139  1.00 28.45           C  
ATOM    354  CB  ALA    37      10.865  27.523  29.464  1.00 28.21           C  
ATOM    358  C   ALA    37      12.350  29.138  28.203  1.00 28.53           C  
ATOM    359  O   ALA    37      12.535  28.976  26.991  1.00 28.74           O  
ATOM    361  N   LYS    38      12.254  30.353  28.753  1.00 28.46           N  
ATOM    362  CA  LYS    38      12.479  31.585  27.952  1.00 28.77           C  
ATOM    364  CB  LYS    38      12.362  32.855  28.810  1.00 28.84           C  
ATOM    367  CG  LYS    38      11.173  33.763  28.490  1.00 29.78           C  
ATOM    370  CD  LYS    38      10.670  34.538  29.775  1.00 31.42           C  
ATOM    373  CE  LYS    38       9.790  33.635  30.740  1.00 31.00           C  
ATOM    376  NZ  LYS    38       9.628  34.146  32.144  1.00 30.04           N  
ATOM    380  C   LYS    38      13.844  31.602  27.254  1.00 28.67           C  
ATOM    381  O   LYS    38      13.935  31.826  26.059  1.00 28.60           O  
ATOM    383  N   GLU    39      14.903  31.388  28.029  1.00 28.92           N  
ATOM    384  CA  GLU    39      16.255  31.241  27.491  1.00 29.07           C  
ATOM    386  CB  GLU    39      17.256  30.896  28.615  1.00 29.32           C  
ATOM    389  CG  GLU    39      17.683  32.092  29.525  1.00 29.97           C  
ATOM    392  CD  GLU    39      18.618  31.675  30.698  1.00 30.95           C  
ATOM    393  OE1 GLU    39      18.395  30.602  31.336  1.00 31.36           O  
ATOM    394  OE2 GLU    39      19.579  32.435  30.976  1.00 30.64           O  
ATOM    395  C   GLU    39      16.323  30.161  26.391  1.00 29.31           C  
ATOM    396  O   GLU    39      16.994  30.352  25.385  1.00 29.93           O  
ATOM    398  N   ALA    40      15.655  29.025  26.568  1.00 29.26           N  
ATOM    399  CA  ALA    40      15.675  27.990  25.538  1.00 29.14           C  
ATOM    401  CB  ALA    40      14.954  26.733  26.023  1.00 29.09           C  
ATOM    405  C   ALA    40      15.052  28.523  24.233  1.00 29.31           C  
ATOM    406  O   ALA    40      15.647  28.416  23.135  1.00 29.24           O  
ATOM    408  N   LEU    41      13.866  29.115  24.357  1.00 29.40           N  
ATOM    409  CA  LEU    41      13.176  29.725  23.208  1.00 29.34           C  
ATOM    411  CB  LEU    41      12.006  30.573  23.716  1.00 29.30           C  
ATOM    414  CG  LEU    41      11.070  31.167  22.677  1.00 28.71           C  
ATOM    416  CD1 LEU    41      10.148  30.062  22.197  1.00 28.68           C  
ATOM    420  CD2 LEU    41      10.302  32.340  23.267  1.00 27.42           C  
ATOM    424  C   LEU    41      14.117  30.616  22.372  1.00 29.48           C  
ATOM    425  O   LEU    41      14.211  30.475  21.134  1.00 29.85           O  
ATOM    427  N   GLU    42      14.821  31.511  23.067  1.00 29.00           N  
ATOM    428  CA  GLU    42      15.649  32.517  22.438  1.00 28.74           C  
ATOM    430  CB  GLU    42      15.908  33.598  23.449  1.00 28.67           C  
ATOM    433  CG  GLU    42      14.645  34.363  23.746  1.00 29.55           C  
ATOM    436  CD  GLU    42      14.781  35.250  24.971  1.00 31.30           C  
ATOM    437  OE1 GLU    42      15.008  34.664  26.080  1.00 30.85           O  
ATOM    438  OE2 GLU    42      14.659  36.515  24.804  1.00 30.70           O  
ATOM    439  C   GLU    42      16.957  31.966  21.908  1.00 28.87           C  
ATOM    440  O   GLU    42      17.677  32.661  21.201  1.00 28.72           O  
ATOM    442  N   ASN    43      17.266  30.718  22.268  1.00 29.31           N  
ATOM    443  CA  ASN    43      18.369  29.949  21.660  1.00 29.26           C  
ATOM    445  CB  ASN    43      19.164  29.173  22.728  1.00 29.03           C  
ATOM    448  CG  ASN    43      19.818  30.083  23.766  1.00 29.03           C  
ATOM    449  OD1 ASN    43      20.204  31.217  23.469  1.00 28.55           O  
ATOM    450  ND2 ASN    43      19.954  29.576  24.993  1.00 28.89           N  
ATOM    453  C   ASN    43      17.872  28.958  20.602  1.00 29.20           C  
ATOM    454  O   ASN    43      18.569  27.989  20.314  1.00 29.62           O  
ATOM    456  N   THR    44      16.686  29.195  20.033  1.00 28.87           N  
ATOM    457  CA  THR    44      16.102  28.289  19.041  1.00 28.84           C  
ATOM    459  CB  THR    44      16.897  28.318  17.748  1.00 28.74           C  
ATOM    461  OG1 THR    44      17.471  29.619  17.586  1.00 29.50           O  
ATOM    463  CG2 THR    44      15.986  27.971  16.552  1.00 28.77           C  
ATOM    467  C   THR    44      16.009  26.828  19.506  1.00 28.90           C  
ATOM    468  O   THR    44      16.232  25.893  18.716  1.00 28.57           O  
ATOM    470  N   GLU    45      15.692  26.641  20.789  1.00 28.78           N  
ATOM    471  CA  GLU    45      15.473  25.302  21.339  1.00 28.92           C  
ATOM    473  CB  GLU    45      16.415  25.012  22.521  1.00 28.92           C  
ATOM    476  CG  GLU    45      17.931  25.000  22.196  1.00 29.45           C  
ATOM    479  CD  GLU    45      18.448  23.676  21.635  1.00 29.36           C  
ATOM    480  OE1 GLU    45      19.688  23.562  21.442  1.00 27.01           O  
ATOM    481  OE2 GLU    45      17.612  22.771  21.370  1.00 30.17           O  
ATOM    482  C   GLU    45      14.006  25.190  21.777  1.00 28.65           C  
ATOM    483  O   GLU    45      13.339  26.213  22.050  1.00 29.00           O  
ATOM    485  N   VAL    46      13.501  23.955  21.814  1.00 27.84           N  
ATOM    486  CA  VAL    46      12.162  23.715  22.317  1.00 27.20           C  
ATOM    488  CB  VAL    46      11.844  22.202  22.430  1.00 27.04           C  
ATOM    490  CG1 VAL    46      10.470  22.021  22.949  1.00 26.48           C  
ATOM    494  CG2 VAL    46      11.994  21.495  21.085  1.00 25.84           C  
ATOM    498  C   VAL    46      12.218  24.332  23.700  1.00 26.94           C  
ATOM    499  O   VAL    46      13.138  24.032  24.430  1.00 27.21           O  
ATOM    501  N   PRO    47      11.286  25.236  24.048  1.00 26.78           N  
ATOM    502  CA  PRO    47      11.296  25.903  25.373  1.00 26.70           C  
ATOM    504  CB  PRO    47      10.367  27.113  25.179  1.00 26.66           C  
ATOM    507  CG  PRO    47       9.422  26.670  24.121  1.00 27.05           C  
ATOM    510  CD  PRO    47      10.184  25.723  23.207  1.00 26.93           C  
ATOM    513  C   PRO    47      10.822  25.037  26.522  1.00 26.24           C  
ATOM    514  O   PRO    47       9.673  25.088  26.918  1.00 26.00           O  
ATOM    515  N   VAL    48      11.735  24.233  27.027  1.00 26.62           N  
ATOM    516  CA  VAL    48      11.513  23.417  28.200  1.00 27.16           C  
ATOM    518  CB  VAL    48      11.457  21.880  27.852  1.00 27.41           C  
ATOM    520  CG1 VAL    48      11.253  21.035  29.132  1.00 26.53           C  
ATOM    524  CG2 VAL    48      10.393  21.571  26.783  1.00 25.65           C  
ATOM    528  C   VAL    48      12.716  23.717  29.106  1.00 27.85           C  
ATOM    529  O   VAL    48      13.887  23.614  28.672  1.00 28.19           O  
ATOM    531  N   GLY    49      12.435  24.143  30.334  1.00 27.89           N  
ATOM    532  CA  GLY    49      13.460  24.283  31.361  1.00 27.79           C  
ATOM    535  C   GLY    49      13.077  23.403  32.544  1.00 27.95           C  
ATOM    536  O   GLY    49      11.895  23.182  32.778  1.00 28.14           O  
ATOM    538  N   CYS    50      14.052  22.876  33.284  1.00 27.93           N  
ATOM    539  CA  CYS    50      13.715  22.173  34.504  1.00 28.84           C  
ATOM    541  CB  CYS    50      13.297  20.749  34.174  1.00 28.84           C  
ATOM    544  SG  CYS    50      14.643  19.606  34.018  1.00 33.39           S  
ATOM    546  C   CYS    50      14.794  22.187  35.602  1.00 28.72           C  
ATOM    547  O   CYS    50      15.972  22.404  35.318  1.00 28.99           O  
ATOM    549  N   LEU    51      14.348  21.985  36.849  1.00 28.66           N  
ATOM    550  CA  LEU    51      15.194  21.936  38.050  1.00 28.44           C  
ATOM    552  CB  LEU    51      14.880  23.128  38.954  1.00 28.29           C  
ATOM    555  CG  LEU    51      15.232  24.521  38.431  1.00 28.29           C  
ATOM    557  CD1 LEU    51      14.136  25.489  38.675  1.00 29.32           C  
ATOM    561  CD2 LEU    51      16.480  25.050  39.095  1.00 30.45           C  
ATOM    565  C   LEU    51      14.956  20.617  38.827  1.00 28.35           C  
ATOM    566  O   LEU    51      13.876  20.048  38.798  1.00 28.95           O  
ATOM    568  N   MET    52      15.958  20.126  39.526  1.00 27.97           N  
ATOM    569  CA  MET    52      15.745  19.011  40.400  1.00 28.22           C  
ATOM    571  CB  MET    52      16.413  17.765  39.825  1.00 28.57           C  
ATOM    574  CG  MET    52      15.607  17.113  38.742  1.00 29.75           C  
ATOM    577  SD  MET    52      16.528  15.808  37.882  1.00 30.98           S  
ATOM    578  CE  MET    52      16.168  14.414  38.917  1.00 33.55           C  
ATOM    582  C   MET    52      16.255  19.354  41.807  1.00 28.12           C  
ATOM    583  O   MET    52      17.427  19.709  42.002  1.00 27.75           O  
ATOM    585  N   VAL    53      15.354  19.242  42.781  1.00 27.75           N  
ATOM    586  CA  VAL    53      15.642  19.628  44.149  1.00 27.86           C  
ATOM    588  CB  VAL    53      14.603  20.664  44.634  1.00 27.43           C  
ATOM    590  CG1 VAL    53      14.756  20.937  46.109  1.00 27.32           C  
ATOM    594  CG2 VAL    53      14.729  21.953  43.833  1.00 27.25           C  
ATOM    598  C   VAL    53      15.710  18.395  45.089  1.00 28.27           C  
ATOM    599  O   VAL    53      14.819  17.559  45.116  1.00 28.02           O  
ATOM    601  N   TYR    54      16.790  18.308  45.863  1.00 28.71           N  
ATOM    602  CA  TYR    54      16.978  17.239  46.855  1.00 28.55           C  
ATOM    604  CB  TYR    54      18.085  16.279  46.430  1.00 28.75           C  
ATOM    607  CG  TYR    54      18.551  15.359  47.499  1.00 27.40           C  
ATOM    608  CD1 TYR    54      17.820  14.230  47.830  1.00 28.08           C  
ATOM    610  CE1 TYR    54      18.244  13.355  48.820  1.00 28.43           C  
ATOM    612  CZ  TYR    54      19.430  13.620  49.480  1.00 29.94           C  
ATOM    613  OH  TYR    54      19.905  12.759  50.454  1.00 32.14           O  
ATOM    615  CE2 TYR    54      20.192  14.739  49.135  1.00 29.42           C  
ATOM    617  CD2 TYR    54      19.745  15.591  48.148  1.00 27.87           C  
ATOM    619  C   TYR    54      17.366  17.869  48.152  1.00 28.27           C  
ATOM    620  O   TYR    54      18.279  18.662  48.173  1.00 28.82           O  
ATOM    622  N   ASN    55      16.677  17.488  49.221  1.00 28.12           N  
ATOM    623  CA  ASN    55      16.918  18.006  50.563  1.00 28.03           C  
ATOM    625  CB  ASN    55      18.059  17.234  51.242  1.00 28.30           C  
ATOM    628  CG  ASN    55      18.050  17.374  52.753  1.00 28.25           C  
ATOM    629  OD1 ASN    55      17.015  17.664  53.345  1.00 27.11           O  
ATOM    630  ND2 ASN    55      19.190  17.134  53.381  1.00 25.68           N  
ATOM    633  C   ASN    55      17.189  19.501  50.573  1.00 27.90           C  
ATOM    634  O   ASN    55      18.159  19.980  51.170  1.00 27.64           O  
ATOM    636  N   ASN    56      16.320  20.224  49.887  1.00 27.79           N  
ATOM    637  CA  ASN    56      16.363  21.691  49.865  1.00 28.13           C  
ATOM    639  CB  ASN    56      16.324  22.254  51.279  1.00 28.01           C  
ATOM    642  CG  ASN    56      15.882  23.683  51.311  1.00 27.94           C  
ATOM    643  OD1 ASN    56      15.237  24.172  50.381  1.00 31.08           O  
ATOM    644  ND2 ASN    56      16.215  24.367  52.378  1.00 27.46           N  
ATOM    647  C   ASN    56      17.533  22.307  49.134  1.00 27.87           C  
ATOM    648  O   ASN    56      17.908  23.425  49.409  1.00 28.32           O  
ATOM    650  N   GLU    57      18.082  21.574  48.183  1.00 27.86           N  
ATOM    651  CA  GLU    57      19.217  22.024  47.409  1.00 27.68           C  
ATOM    653  CB  GLU    57      20.472  21.281  47.847  1.00 27.08           C  
ATOM    656  CG  GLU    57      21.672  21.541  46.962  1.00 28.55           C  
ATOM    659  CD  GLU    57      23.044  21.418  47.718  1.00 30.79           C  
ATOM    660  OE1 GLU    57      24.101  21.861  47.139  1.00 30.38           O  
ATOM    661  OE2 GLU    57      23.061  20.888  48.874  1.00 30.25           O  
ATOM    662  C   GLU    57      18.879  21.798  45.937  1.00 27.63           C  
ATOM    663  O   GLU    57      18.169  20.830  45.585  1.00 27.10           O  
ATOM    665  N   VAL    58      19.321  22.734  45.093  1.00 27.91           N  
ATOM    666  CA  VAL    58      19.139  22.617  43.654  1.00 27.84           C  
ATOM    668  CB  VAL    58      19.194  23.956  42.914  1.00 27.95           C  
ATOM    670  CG1 VAL    58      19.081  23.684  41.414  1.00 27.53           C  
ATOM    674  CG2 VAL    58      18.097  24.893  43.401  1.00 27.26           C  
ATOM    678  C   VAL    58      20.250  21.735  43.142  1.00 27.85           C  
ATOM    679  O   VAL    58      21.372  22.153  42.975  1.00 27.19           O  
ATOM    681  N   VAL    59      19.894  20.494  42.876  1.00 28.57           N  
ATOM    682  CA  VAL    59      20.856  19.448  42.563  1.00 28.61           C  
ATOM    684  CB  VAL    59      20.415  18.170  43.356  1.00 28.52           C  
ATOM    686  CG1 VAL    59      19.333  17.410  42.623  1.00 27.61           C  
ATOM    690  CG2 VAL    59      21.584  17.307  43.628  1.00 30.18           C  
ATOM    694  C   VAL    59      21.022  19.190  41.019  1.00 28.74           C  
ATOM    695  O   VAL    59      21.896  18.437  40.605  1.00 28.89           O  
ATOM    697  N   GLY    60      20.192  19.812  40.180  1.00 28.38           N  
ATOM    698  CA  GLY    60      20.330  19.712  38.737  1.00 28.23           C  
ATOM    701  C   GLY    60      19.404  20.682  38.007  1.00 28.41           C  
ATOM    702  O   GLY    60      18.276  20.866  38.404  1.00 28.63           O  
ATOM    704  N   LYS    61      19.916  21.324  36.960  1.00 28.65           N  
ATOM    705  CA  LYS    61      19.168  22.227  36.093  1.00 28.54           C  
ATOM    707  CB  LYS    61      19.780  23.640  36.140  1.00 28.95           C  
ATOM    710  CG  LYS    61      19.463  24.488  37.367  1.00 28.34           C  
ATOM    713  CD  LYS    61      20.179  25.840  37.225  1.00 29.50           C  
ATOM    716  CE  LYS    61      20.207  26.654  38.541  1.00 30.91           C  
ATOM    719  NZ  LYS    61      18.964  27.499  38.849  1.00 30.87           N  
ATOM    723  C   LYS    61      19.282  21.710  34.650  1.00 28.73           C  
ATOM    724  O   LYS    61      20.198  20.928  34.303  1.00 28.29           O  
ATOM    726  N   GLY    62      18.379  22.158  33.784  1.00 28.67           N  
ATOM    727  CA  GLY    62      18.523  21.784  32.389  1.00 28.85           C  
ATOM    730  C   GLY    62      17.522  22.399  31.467  1.00 28.68           C  
ATOM    731  O   GLY    62      16.377  22.533  31.822  1.00 29.05           O  
ATOM    733  N   ARG    63      17.983  22.761  30.279  1.00 28.89           N  
ATOM    734  CA  ARG    63      17.144  23.177  29.179  1.00 28.89           C  
ATOM    736  CB  ARG    63      17.613  24.542  28.668  1.00 29.02           C  
ATOM    739  CG  ARG    63      17.129  25.716  29.490  1.00 29.86           C  
ATOM    742  CD  ARG    63      18.067  26.929  29.395  1.00 30.14           C  
ATOM    745  NE  ARG    63      19.316  26.658  30.105  1.00 31.33           N  
ATOM    747  CZ  ARG    63      20.264  27.559  30.367  1.00 31.77           C  
ATOM    748  NH1 ARG    63      20.100  28.830  29.992  1.00 31.57           N  
ATOM    751  NH2 ARG    63      21.380  27.181  31.007  1.00 30.99           N  
ATOM    754  C   ARG    63      17.358  22.195  28.056  1.00 29.11           C  
ATOM    755  O   ARG    63      18.388  21.496  28.019  1.00 29.15           O  
ATOM    757  N   ASN    64      16.420  22.169  27.108  1.00 29.06           N  
ATOM    758  CA  ASN    64      16.671  21.481  25.849  1.00 28.97           C  
ATOM    760  CB  ASN    64      15.497  21.629  24.909  1.00 29.21           C  
ATOM    763  CG  ASN    64      14.555  20.442  24.966  1.00 30.76           C  
ATOM    764  OD1 ASN    64      14.095  20.021  26.061  1.00 31.58           O  
ATOM    765  ND2 ASN    64      14.238  19.899  23.783  1.00 30.37           N  
ATOM    768  C   ASN    64      17.914  22.003  25.151  1.00 28.78           C  
ATOM    769  O   ASN    64      18.100  23.209  25.044  1.00 28.39           O  
ATOM    771  N   GLU    65      18.741  21.063  24.683  1.00 28.83           N  
ATOM    772  CA  GLU    65      19.991  21.336  23.956  1.00 28.70           C  
ATOM    774  CB  GLU    65      21.208  20.948  24.811  1.00 28.43           C  
ATOM    777  CG  GLU    65      21.363  21.803  26.060  1.00 29.26           C  
ATOM    780  CD  GLU    65      22.567  21.420  26.935  1.00 31.11           C  
ATOM    781  OE1 GLU    65      23.208  20.350  26.722  1.00 32.83           O  
ATOM    782  OE2 GLU    65      22.862  22.193  27.874  1.00 32.15           O  
ATOM    783  C   GLU    65      20.053  20.599  22.593  1.00 28.61           C  
ATOM    784  O   GLU    65      21.143  20.477  22.010  1.00 28.58           O  
ATOM    786  N   VAL    66      18.896  20.169  22.062  1.00 27.88           N  
ATOM    787  CA  VAL    66      18.886  19.316  20.880  1.00 27.67           C  
ATOM    789  CB  VAL    66      17.459  18.841  20.468  1.00 27.53           C  
ATOM    791  CG1 VAL    66      17.529  18.039  19.197  1.00 26.83           C  
ATOM    795  CG2 VAL    66      16.898  17.936  21.521  1.00 26.62           C  
ATOM    799  C   VAL    66      19.638  19.911  19.702  1.00 27.74           C  
ATOM    800  O   VAL    66      20.368  19.174  19.054  1.00 27.05           O  
ATOM    802  N   ASN    67      19.485  21.227  19.463  1.00 28.26           N  
ATOM    803  CA  ASN    67      20.095  21.919  18.295  1.00 28.74           C  
ATOM    805  CB  ASN    67      19.369  23.234  17.954  1.00 29.15           C  
ATOM    808  CG  ASN    67      17.862  23.046  17.756  1.00 30.45           C  
ATOM    809  OD1 ASN    67      17.316  21.924  17.886  1.00 31.70           O  
ATOM    810  ND2 ASN    67      17.175  24.152  17.467  1.00 29.61           N  
ATOM    813  C   ASN    67      21.546  22.272  18.503  1.00 28.57           C  
ATOM    814  O   ASN    67      22.382  22.068  17.625  1.00 28.06           O  
ATOM    816  N   GLN    68      21.820  22.854  19.661  1.00 28.68           N  
ATOM    817  CA  GLN    68      23.187  23.164  20.074  1.00 29.07           C  
ATOM    819  CB  GLN    68      23.182  23.668  21.536  1.00 29.90           C  
ATOM    822  CG  GLN    68      22.524  25.095  21.719  1.00 32.43           C  
ATOM    825  CD  GLN    68      22.188  25.490  23.188  1.00 32.48           C  
ATOM    826  OE1 GLN    68      21.718  24.669  23.999  1.00 31.76           O  
ATOM    827  NE2 GLN    68      22.424  26.777  23.507  1.00 31.80           N  
ATOM    830  C   GLN    68      24.041  21.912  20.001  1.00 28.56           C  
ATOM    831  O   GLN    68      25.150  21.918  19.494  1.00 27.79           O  
ATOM    833  N   THR    69      23.495  20.836  20.554  1.00 28.62           N  
ATOM    834  CA  THR    69      24.199  19.575  20.692  1.00 28.33           C  
ATOM    836  CB  THR    69      23.715  18.855  21.942  1.00 27.93           C  
ATOM    838  OG1 THR    69      24.674  17.873  22.314  1.00 30.06           O  
ATOM    840  CG2 THR    69      22.403  18.168  21.682  1.00 28.03           C  
ATOM    844  C   THR    69      24.028  18.652  19.476  1.00 28.16           C  
ATOM    845  O   THR    69      24.864  17.762  19.267  1.00 28.11           O  
ATOM    847  N   LYS    70      22.972  18.895  18.683  1.00 27.74           N  
ATOM    848  CA  LYS    70      22.589  18.065  17.531  1.00 27.50           C  
ATOM    850  CB  LYS    70      23.563  18.266  16.384  1.00 27.34           C  
ATOM    853  CG  LYS    70      23.246  19.525  15.632  1.00 28.15           C  
ATOM    856  CD  LYS    70      24.390  19.949  14.775  1.00 29.05           C  
ATOM    859  CE  LYS    70      24.183  21.367  14.275  1.00 29.94           C  
ATOM    862  NZ  LYS    70      25.274  21.771  13.281  1.00 31.00           N  
ATOM    866  C   LYS    70      22.383  16.586  17.886  1.00 27.49           C  
ATOM    867  O   LYS    70      22.638  15.688  17.088  1.00 27.02           O  
ATOM    869  N   ASN    71      21.857  16.364  19.083  1.00 27.55           N  
ATOM    870  CA  ASN    71      21.554  15.046  19.586  1.00 27.78           C  
ATOM    872  CB  ASN    71      22.528  14.710  20.740  1.00 28.42           C  
ATOM    875  CG  ASN    71      22.027  13.539  21.665  1.00 28.76           C  
ATOM    876  OD1 ASN    71      20.966  12.957  21.460  1.00 27.98           O  
ATOM    877  ND2 ASN    71      22.818  13.221  22.698  1.00 28.49           N  
ATOM    880  C   ASN    71      20.093  15.093  20.051  1.00 27.58           C  
ATOM    881  O   ASN    71      19.764  15.768  21.038  1.00 27.17           O  
ATOM    883  N   ALA    72      19.246  14.340  19.348  1.00 27.15           N  
ATOM    884  CA  ALA    72      17.800  14.367  19.546  1.00 27.07           C  
ATOM    886  CB  ALA    72      17.127  13.525  18.488  1.00 26.68           C  
ATOM    890  C   ALA    72      17.315  13.950  20.941  1.00 27.13           C  
ATOM    891  O   ALA    72      16.182  14.226  21.301  1.00 26.86           O  
ATOM    893  N   THR    73      18.163  13.293  21.726  1.00 27.64           N  
ATOM    894  CA  THR    73      17.794  12.844  23.087  1.00 27.77           C  
ATOM    896  CB  THR    73      18.487  11.475  23.481  1.00 27.68           C  
ATOM    898  OG1 THR    73      19.896  11.661  23.586  1.00 28.68           O  
ATOM    900  CG2 THR    73      18.245  10.386  22.484  1.00 27.37           C  
ATOM    904  C   THR    73      18.077  13.870  24.222  1.00 27.70           C  
ATOM    905  O   THR    73      17.605  13.670  25.328  1.00 28.04           O  
ATOM    907  N   ARG    74      18.804  14.962  23.970  1.00 28.06           N  
ATOM    908  CA  ARG    74      19.126  15.931  25.042  1.00 28.19           C  
ATOM    910  CB  ARG    74      20.501  16.601  24.849  1.00 28.37           C  
ATOM    913  CG  ARG    74      21.630  15.661  25.334  1.00 29.65           C  
ATOM    916  CD  ARG    74      23.077  16.273  25.365  1.00 31.98           C  
ATOM    919  NE  ARG    74      23.948  15.483  24.442  1.00 33.67           N  
ATOM    921  CZ  ARG    74      25.287  15.545  24.348  1.00 32.37           C  
ATOM    922  NH1 ARG    74      26.000  16.370  25.135  1.00 33.11           N  
ATOM    925  NH2 ARG    74      25.913  14.770  23.451  1.00 30.11           N  
ATOM    928  C   ARG    74      18.008  16.914  25.334  1.00 27.96           C  
ATOM    929  O   ARG    74      18.098  18.113  25.095  1.00 27.54           O  
ATOM    931  N   HIS    75      16.947  16.332  25.881  1.00 28.13           N  
ATOM    932  CA  HIS    75      15.808  17.019  26.439  1.00 27.64           C  
ATOM    934  CB  HIS    75      14.667  16.007  26.623  1.00 27.64           C  
ATOM    937  CG  HIS    75      13.933  15.675  25.364  1.00 26.85           C  
ATOM    938  ND1 HIS    75      12.684  15.091  25.365  1.00 27.16           N  
ATOM    940  CE1 HIS    75      12.273  14.929  24.123  1.00 25.35           C  
ATOM    942  NE2 HIS    75      13.203  15.398  23.314  1.00 25.61           N  
ATOM    944  CD2 HIS    75      14.241  15.891  24.066  1.00 26.69           C  
ATOM    946  C   HIS    75      16.212  17.565  27.809  1.00 27.62           C  
ATOM    947  O   HIS    75      17.040  16.976  28.486  1.00 27.41           O  
ATOM    949  N   ALA    76      15.605  18.680  28.215  1.00 27.85           N  
ATOM    950  CA  ALA    76      15.914  19.361  29.477  1.00 27.68           C  
ATOM    952  CB  ALA    76      14.837  20.315  29.795  1.00 27.83           C  
ATOM    956  C   ALA    76      16.071  18.407  30.627  1.00 27.54           C  
ATOM    957  O   ALA    76      16.949  18.557  31.454  1.00 27.23           O  
ATOM    959  N   GLU    77      15.202  17.415  30.660  1.00 27.94           N  
ATOM    960  CA  GLU    77      15.174  16.423  31.759  1.00 28.19           C  
ATOM    962  CB  GLU    77      13.931  15.503  31.638  1.00 28.04           C  
ATOM    965  CG  GLU    77      12.535  16.240  31.554  1.00 28.70           C  
ATOM    968  CD  GLU    77      12.024  16.560  30.121  1.00 29.00           C  
ATOM    969  OE1 GLU    77      12.744  17.225  29.338  1.00 26.96           O  
ATOM    970  OE2 GLU    77      10.890  16.137  29.788  1.00 30.20           O  
ATOM    971  C   GLU    77      16.453  15.576  31.775  1.00 28.12           C  
ATOM    972  O   GLU    77      16.977  15.267  32.831  1.00 27.91           O  
ATOM    974  N   MET    78      16.945  15.218  30.590  1.00 28.34           N  
ATOM    975  CA  MET    78      18.162  14.405  30.454  1.00 28.57           C  
ATOM    977  CB  MET    78      18.256  13.796  29.033  1.00 28.60           C  
ATOM    980  CG  MET    78      17.083  12.903  28.658  1.00 29.43           C  
ATOM    983  SD  MET    78      17.088  11.230  29.438  1.00 32.79           S  
ATOM    984  CE  MET    78      18.680  10.560  28.910  1.00 33.89           C  
ATOM    988  C   MET    78      19.438  15.196  30.807  1.00 27.97           C  
ATOM    989  O   MET    78      20.374  14.636  31.382  1.00 27.32           O  
ATOM    991  N   VAL    79      19.449  16.485  30.467  1.00 27.87           N  
ATOM    992  CA  VAL    79      20.504  17.412  30.894  1.00 27.89           C  
ATOM    994  CB  VAL    79      20.252  18.842  30.335  1.00 27.64           C  
ATOM    996  CG1 VAL    79      21.200  19.821  30.957  1.00 26.57           C  
ATOM   1000  CG2 VAL    79      20.390  18.846  28.827  1.00 27.02           C  
ATOM   1004  C   VAL    79      20.582  17.472  32.428  1.00 28.20           C  
ATOM   1005  O   VAL    79      21.663  17.343  33.013  1.00 28.42           O  
ATOM   1007  N   ALA    80      19.422  17.663  33.060  1.00 28.46           N  
ATOM   1008  CA  ALA    80      19.292  17.726  34.514  1.00 28.47           C  
ATOM   1010  CB  ALA    80      17.846  18.000  34.891  1.00 28.80           C  
ATOM   1014  C   ALA    80      19.776  16.452  35.211  1.00 28.83           C  
ATOM   1015  O   ALA    80      20.513  16.536  36.211  1.00 28.83           O  
ATOM   1017  N   ILE    81      19.346  15.286  34.702  1.00 28.53           N  
ATOM   1018  CA  ILE    81      19.759  14.004  35.257  1.00 28.44           C  
ATOM   1020  CB  ILE    81      19.134  12.836  34.510  1.00 28.66           C  
ATOM   1022  CG1 ILE    81      17.624  12.783  34.805  1.00 28.89           C  
ATOM   1025  CD1 ILE    81      16.882  11.805  33.992  1.00 26.60           C  
ATOM   1029  CG2 ILE    81      19.789  11.514  34.943  1.00 28.72           C  
ATOM   1033  C   ILE    81      21.275  13.851  35.248  1.00 28.72           C  
ATOM   1034  O   ILE    81      21.854  13.413  36.239  1.00 29.25           O  
ATOM   1036  N   ASP    82      21.922  14.237  34.152  1.00 28.61           N  
ATOM   1037  CA  ASP    82      23.382  14.204  34.080  1.00 28.47           C  
ATOM   1039  CB  ASP    82      23.900  14.655  32.700  1.00 28.86           C  
ATOM   1042  CG  ASP    82      24.020  13.506  31.685  1.00 30.66           C  
ATOM   1043  OD1 ASP    82      23.613  12.367  32.024  1.00 33.60           O  
ATOM   1044  OD2 ASP    82      24.542  13.743  30.544  1.00 32.55           O  
ATOM   1045  C   ASP    82      23.987  15.088  35.148  1.00 28.01           C  
ATOM   1046  O   ASP    82      24.999  14.728  35.734  1.00 27.82           O  
ATOM   1048  N   GLN    83      23.379  16.253  35.385  1.00 27.76           N  
ATOM   1049  CA  GLN    83      23.868  17.178  36.416  1.00 27.64           C  
ATOM   1051  CB  GLN    83      23.170  18.538  36.279  1.00 27.69           C  
ATOM   1054  CG  GLN    83      23.871  19.468  35.291  1.00 28.50           C  
ATOM   1057  CD  GLN    83      23.481  20.925  35.456  1.00 27.64           C  
ATOM   1058  OE1 GLN    83      22.782  21.301  36.390  1.00 27.94           O  
ATOM   1059  NE2 GLN    83      23.942  21.750  34.551  1.00 27.26           N  
ATOM   1062  C   GLN    83      23.721  16.646  37.849  1.00 27.11           C  
ATOM   1063  O   GLN    83      24.612  16.790  38.666  1.00 26.25           O  
ATOM   1065  N   VAL    84      22.573  16.039  38.131  1.00 27.29           N  
ATOM   1066  CA  VAL    84      22.373  15.354  39.390  1.00 27.38           C  
ATOM   1068  CB  VAL    84      20.931  14.822  39.562  1.00 27.63           C  
ATOM   1070  CG1 VAL    84      20.775  14.175  40.919  1.00 25.95           C  
ATOM   1074  CG2 VAL    84      19.923  15.945  39.394  1.00 26.82           C  
ATOM   1078  C   VAL    84      23.395  14.241  39.566  1.00 27.17           C  
ATOM   1079  O   VAL    84      24.087  14.205  40.570  1.00 27.42           O  
ATOM   1081  N   LEU    85      23.541  13.356  38.595  1.00 27.06           N  
ATOM   1082  CA  LEU    85      24.643  12.379  38.680  1.00 27.18           C  
ATOM   1084  CB  LEU    85      24.735  11.528  37.415  1.00 26.93           C  
ATOM   1087  CG  LEU    85      23.618  10.515  37.247  1.00 26.49           C  
ATOM   1089  CD1 LEU    85      23.286  10.344  35.774  1.00 27.04           C  
ATOM   1093  CD2 LEU    85      24.014   9.242  37.875  1.00 26.00           C  
ATOM   1097  C   LEU    85      25.997  13.029  38.955  1.00 27.04           C  
ATOM   1098  O   LEU    85      26.807  12.451  39.661  1.00 27.51           O  
ATOM   1100  N   ASP    86      26.240  14.216  38.404  1.00 27.40           N  
ATOM   1101  CA  ASP    86      27.493  14.935  38.638  1.00 27.79           C  
ATOM   1103  CB  ASP    86      27.674  16.086  37.657  1.00 27.90           C  
ATOM   1106  CG  ASP    86      29.145  16.270  37.271  1.00 30.86           C  
ATOM   1107  OD1 ASP    86      29.648  15.494  36.390  1.00 32.41           O  
ATOM   1108  OD2 ASP    86      29.826  17.137  37.906  1.00 33.31           O  
ATOM   1109  C   ASP    86      27.612  15.473  40.060  1.00 27.69           C  
ATOM   1110  O   ASP    86      28.704  15.515  40.648  1.00 27.89           O  
ATOM   1112  N   TRP    87      26.479  15.887  40.606  1.00 27.68           N  
ATOM   1113  CA  TRP    87      26.393  16.362  41.971  1.00 27.52           C  
ATOM   1115  CB  TRP    87      24.996  16.944  42.217  1.00 28.11           C  
ATOM   1118  CG  TRP    87      24.854  17.634  43.516  1.00 27.84           C  
ATOM   1119  CD1 TRP    87      25.097  18.936  43.765  1.00 26.94           C  
ATOM   1121  NE1 TRP    87      24.843  19.218  45.082  1.00 27.80           N  
ATOM   1123  CE2 TRP    87      24.445  18.076  45.722  1.00 27.98           C  
ATOM   1124  CD2 TRP    87      24.432  17.048  44.756  1.00 28.61           C  
ATOM   1125  CE3 TRP    87      24.048  15.750  45.143  1.00 27.55           C  
ATOM   1127  CZ3 TRP    87      23.721  15.525  46.469  1.00 27.38           C  
ATOM   1129  CH2 TRP    87      23.747  16.579  47.415  1.00 27.96           C  
ATOM   1131  CZ2 TRP    87      24.101  17.857  47.060  1.00 27.24           C  
ATOM   1133  C   TRP    87      26.661  15.254  42.957  1.00 27.22           C  
ATOM   1134  O   TRP    87      27.279  15.469  43.985  1.00 26.82           O  
ATOM   1136  N   CYS    88      26.147  14.072  42.648  1.00 27.62           N  
ATOM   1137  CA  CYS    88      26.427  12.872  43.433  1.00 27.93           C  
ATOM   1139  CB  CYS    88      25.738  11.657  42.842  1.00 27.87           C  
ATOM   1142  SG  CYS    88      24.004  11.558  43.304  1.00 29.69           S  
ATOM   1144  C   CYS    88      27.893  12.579  43.502  1.00 27.85           C  
ATOM   1145  O   CYS    88      28.411  12.357  44.584  1.00 28.58           O  
ATOM   1147  N   ARG    89      28.569  12.568  42.360  1.00 27.85           N  
ATOM   1148  CA  ARG    89      30.000  12.313  42.366  1.00 28.33           C  
ATOM   1150  CB  ARG    89      30.613  12.676  41.043  1.00 28.62           C  
ATOM   1153  CG  ARG    89      30.413  11.652  39.984  1.00 29.96           C  
ATOM   1156  CD  ARG    89      30.720  12.311  38.629  1.00 31.97           C  
ATOM   1159  NE  ARG    89      30.164  11.544  37.504  1.00 33.93           N  
ATOM   1161  CZ  ARG    89      30.404  11.831  36.215  1.00 36.20           C  
ATOM   1162  NH1 ARG    89      31.159  12.902  35.886  1.00 37.64           N  
ATOM   1165  NH2 ARG    89      29.920  11.053  35.234  1.00 36.24           N  
ATOM   1168  C   ARG    89      30.730  13.111  43.408  1.00 28.11           C  
ATOM   1169  O   ARG    89      31.577  12.583  44.101  1.00 28.00           O  
ATOM   1171  N   GLN    90      30.383  14.386  43.506  1.00 28.42           N  
ATOM   1172  CA  GLN    90      31.132  15.339  44.301  1.00 28.75           C  
ATOM   1174  CB  GLN    90      30.990  16.703  43.661  1.00 29.03           C  
ATOM   1177  CG  GLN    90      31.457  16.706  42.217  1.00 31.17           C  
ATOM   1180  CD  GLN    90      31.094  17.981  41.521  1.00 33.04           C  
ATOM   1181  OE1 GLN    90      30.440  18.845  42.108  1.00 35.04           O  
ATOM   1182  NE2 GLN    90      31.498  18.113  40.261  1.00 34.45           N  
ATOM   1185  C   GLN    90      30.670  15.469  45.728  1.00 28.39           C  
ATOM   1186  O   GLN    90      31.383  16.039  46.538  1.00 28.51           O  
ATOM   1188  N   SER    91      29.453  15.014  46.010  1.00 28.22           N  
ATOM   1189  CA  SER    91      28.885  15.090  47.346  1.00 28.33           C  
ATOM   1191  CB  SER    91      27.379  15.315  47.267  1.00 28.48           C  
ATOM   1194  OG  SER    91      26.708  14.066  47.137  1.00 28.44           O  
ATOM   1196  C   SER    91      29.135  13.806  48.131  1.00 28.41           C  
ATOM   1197  O   SER    91      28.941  13.790  49.351  1.00 28.52           O  
ATOM   1199  N   GLY    92      29.541  12.740  47.419  1.00 28.34           N  
ATOM   1200  CA  GLY    92      29.820  11.437  48.010  1.00 28.07           C  
ATOM   1203  C   GLY    92      28.567  10.609  48.180  1.00 27.97           C  
ATOM   1204  O   GLY    92      28.632   9.480  48.609  1.00 28.33           O  
ATOM   1206  N   LYS    93      27.418  11.175  47.850  1.00 28.04           N  
ATOM   1207  CA  LYS    93      26.144  10.499  48.043  1.00 28.52           C  
ATOM   1209  CB  LYS    93      25.010  11.516  48.151  1.00 28.44           C  
ATOM   1212  CG  LYS    93      25.124  12.507  49.287  1.00 28.85           C  
ATOM   1215  CD  LYS    93      24.408  12.008  50.555  1.00 30.68           C  
ATOM   1218  CE  LYS    93      23.929  13.147  51.497  1.00 31.10           C  
ATOM   1221  NZ  LYS    93      22.573  12.817  52.143  1.00 31.15           N  
ATOM   1225  C   LYS    93      25.886   9.579  46.841  1.00 28.54           C  
ATOM   1226  O   LYS    93      26.366   9.859  45.736  1.00 28.29           O  
ATOM   1228  N   SER    94      25.122   8.501  47.058  1.00 28.28           N  
ATOM   1229  CA  SER    94      24.802   7.568  45.984  1.00 27.99           C  
ATOM   1231  CB  SER    94      24.546   6.167  46.522  1.00 27.89           C  
ATOM   1234  OG  SER    94      23.271   6.106  47.132  1.00 27.86           O  
ATOM   1236  C   SER    94      23.571   8.064  45.224  1.00 28.07           C  
ATOM   1237  O   SER    94      22.649   8.643  45.843  1.00 27.86           O  
ATOM   1239  N   PRO    95      23.548   7.840  43.893  1.00 27.49           N  
ATOM   1240  CA  PRO    95      22.436   8.176  42.998  1.00 27.79           C  
ATOM   1242  CB  PRO    95      22.818   7.481  41.703  1.00 27.72           C  
ATOM   1245  CG  PRO    95      24.264   7.455  41.751  1.00 28.05           C  
ATOM   1248  CD  PRO    95      24.646   7.219  43.154  1.00 27.05           C  
ATOM   1251  C   PRO    95      21.045   7.709  43.436  1.00 27.91           C  
ATOM   1252  O   PRO    95      20.106   8.499  43.371  1.00 28.45           O  
ATOM   1253  N   SER    96      20.917   6.457  43.869  1.00 27.75           N  
ATOM   1254  CA  SER    96      19.643   5.929  44.340  1.00 28.16           C  
ATOM   1256  CB  SER    96      19.727   4.416  44.567  1.00 28.01           C  
ATOM   1259  OG  SER    96      20.401   4.120  45.777  1.00 28.00           O  
ATOM   1261  C   SER    96      19.140   6.659  45.599  1.00 28.30           C  
ATOM   1262  O   SER    96      17.977   6.987  45.701  1.00 28.80           O  
ATOM   1264  N   GLU    97      20.029   6.959  46.524  1.00 28.77           N  
ATOM   1265  CA  GLU    97      19.701   7.734  47.728  1.00 29.19           C  
ATOM   1267  CB  GLU    97      20.960   7.760  48.608  1.00 29.43           C  
ATOM   1270  CG  GLU    97      20.840   8.453  49.966  1.00 31.88           C  
ATOM   1273  CD  GLU    97      22.211   8.495  50.747  1.00 34.19           C  
ATOM   1274  OE1 GLU    97      23.234   7.944  50.211  1.00 34.81           O  
ATOM   1275  OE2 GLU    97      22.250   9.095  51.874  1.00 32.68           O  
ATOM   1276  C   GLU    97      19.225   9.185  47.447  1.00 29.09           C  
ATOM   1277  O   GLU    97      18.528   9.788  48.293  1.00 29.59           O  
ATOM   1279  N   VAL    98      19.614   9.742  46.295  1.00 28.27           N  
ATOM   1280  CA  VAL    98      19.289  11.121  45.961  1.00 28.28           C  
ATOM   1282  CB  VAL    98      20.460  11.853  45.218  1.00 28.27           C  
ATOM   1284  CG1 VAL    98      20.109  13.282  44.899  1.00 25.94           C  
ATOM   1288  CG2 VAL    98      21.732  11.836  46.046  1.00 28.61           C  
ATOM   1292  C   VAL    98      18.069  11.175  45.066  1.00 28.91           C  
ATOM   1293  O   VAL    98      17.096  11.881  45.374  1.00 28.91           O  
ATOM   1295  N   PHE    99      18.133  10.470  43.930  1.00 29.30           N  
ATOM   1296  CA  PHE    99      17.022  10.466  42.968  1.00 29.02           C  
ATOM   1298  CB  PHE    99      17.314   9.595  41.740  1.00 29.08           C  
ATOM   1301  CG  PHE    99      18.191  10.271  40.744  1.00 30.28           C  
ATOM   1302  CD1 PHE    99      19.564  10.018  40.707  1.00 30.48           C  
ATOM   1304  CE1 PHE    99      20.391  10.672  39.812  1.00 29.96           C  
ATOM   1306  CZ  PHE    99      19.873  11.616  38.953  1.00 30.17           C  
ATOM   1308  CE2 PHE    99      18.508  11.904  38.982  1.00 31.27           C  
ATOM   1310  CD2 PHE    99      17.666  11.222  39.877  1.00 31.63           C  
ATOM   1312  C   PHE    99      15.737  10.011  43.618  1.00 28.89           C  
ATOM   1313  O   PHE    99      14.682  10.551  43.305  1.00 29.69           O  
ATOM   1315  N   GLU   100      15.802   9.025  44.514  1.00 28.16           N  
ATOM   1316  CA  GLU   100      14.578   8.558  45.168  1.00 27.97           C  
ATOM   1318  CB  GLU   100      14.825   7.247  45.899  1.00 27.44           C  
ATOM   1321  CG  GLU   100      15.086   6.145  44.939  1.00 28.81           C  
ATOM   1324  CD  GLU   100      15.433   4.827  45.602  1.00 31.25           C  
ATOM   1325  OE1 GLU   100      14.999   4.604  46.757  1.00 33.41           O  
ATOM   1326  OE2 GLU   100      16.147   4.005  44.961  1.00 32.63           O  
ATOM   1327  C   GLU   100      13.901   9.589  46.090  1.00 27.67           C  
ATOM   1328  O   GLU   100      12.803   9.337  46.580  1.00 27.67           O  
ATOM   1330  N   HIS   101      14.549  10.734  46.319  1.00 27.43           N  
ATOM   1331  CA  HIS   101      13.984  11.809  47.136  1.00 27.25           C  
ATOM   1333  CB  HIS   101      14.693  11.846  48.490  1.00 27.64           C  
ATOM   1336  CG  HIS   101      14.600  10.559  49.241  1.00 28.63           C  
ATOM   1337  ND1 HIS   101      15.589   9.592  49.190  1.00 29.98           N  
ATOM   1339  CE1 HIS   101      15.213   8.550  49.910  1.00 29.66           C  
ATOM   1341  NE2 HIS   101      14.023   8.807  50.425  1.00 29.55           N  
ATOM   1343  CD2 HIS   101      13.611  10.050  50.010  1.00 28.37           C  
ATOM   1345  C   HIS   101      14.093  13.162  46.463  1.00 26.91           C  
ATOM   1346  O   HIS   101      14.090  14.165  47.121  1.00 26.37           O  
ATOM   1348  N   THR   102      14.172  13.155  45.136  1.00 27.88           N  
ATOM   1349  CA  THR   102      14.323  14.343  44.296  1.00 28.28           C  
ATOM   1351  CB  THR   102      15.376  14.090  43.179  1.00 28.77           C  
ATOM   1353  OG1 THR   102      16.620  13.677  43.769  1.00 29.37           O  
ATOM   1355  CG2 THR   102      15.602  15.338  42.319  1.00 28.67           C  
ATOM   1359  C   THR   102      12.981  14.701  43.643  1.00 28.52           C  
ATOM   1360  O   THR   102      12.303  13.824  43.089  1.00 29.15           O  
ATOM   1362  N   VAL   103      12.571  15.975  43.723  1.00 28.29           N  
ATOM   1363  CA  VAL   103      11.375  16.424  43.007  1.00 27.89           C  
ATOM   1365  CB  VAL   103      10.499  17.411  43.792  1.00 27.37           C  
ATOM   1367  CG1 VAL   103       9.458  17.967  42.885  1.00 27.07           C  
ATOM   1371  CG2 VAL   103       9.842  16.749  44.935  1.00 26.32           C  
ATOM   1375  C   VAL   103      11.855  17.124  41.762  1.00 28.32           C  
ATOM   1376  O   VAL   103      12.766  17.953  41.840  1.00 27.99           O  
ATOM   1378  N   LEU   104      11.241  16.769  40.627  1.00 28.66           N  
ATOM   1379  CA  LEU   104      11.499  17.407  39.326  1.00 28.73           C  
ATOM   1381  CB  LEU   104      11.432  16.357  38.204  1.00 28.51           C  
ATOM   1384  CG  LEU   104      11.478  16.890  36.764  1.00 29.73           C  
ATOM   1386  CD1 LEU   104      12.826  17.591  36.418  1.00 30.68           C  
ATOM   1390  CD2 LEU   104      11.197  15.768  35.748  1.00 29.46           C  
ATOM   1394  C   LEU   104      10.469  18.508  39.084  1.00 28.35           C  
ATOM   1395  O   LEU   104       9.279  18.299  39.308  1.00 28.58           O  
ATOM   1397  N   TYR   105      10.935  19.672  38.635  1.00 28.26           N  
ATOM   1398  CA  TYR   105      10.055  20.816  38.292  1.00 28.44           C  
ATOM   1400  CB  TYR   105      10.335  22.040  39.206  1.00 28.13           C  
ATOM   1403  CG  TYR   105      10.205  21.756  40.702  1.00 27.64           C  
ATOM   1404  CD1 TYR   105      11.284  21.202  41.410  1.00 28.21           C  
ATOM   1406  CE1 TYR   105      11.188  20.907  42.749  1.00 27.85           C  
ATOM   1408  CZ  TYR   105      10.000  21.179  43.415  1.00 28.16           C  
ATOM   1409  OH  TYR   105       9.935  20.866  44.768  1.00 26.64           O  
ATOM   1411  CE2 TYR   105       8.925  21.757  42.726  1.00 25.52           C  
ATOM   1413  CD2 TYR   105       9.032  22.035  41.395  1.00 24.48           C  
ATOM   1415  C   TYR   105      10.264  21.171  36.797  1.00 28.60           C  
ATOM   1416  O   TYR   105      11.342  21.633  36.439  1.00 28.75           O  
ATOM   1418  N   VAL   106       9.255  20.945  35.942  1.00 28.20           N  
ATOM   1419  CA  VAL   106       9.399  21.109  34.476  1.00 28.13           C  
ATOM   1421  CB  VAL   106       9.437  19.736  33.731  1.00 27.97           C  
ATOM   1423  CG1 VAL   106      10.590  18.978  34.171  1.00 29.41           C  
ATOM   1427  CG2 VAL   106       8.201  18.935  34.004  1.00 26.97           C  
ATOM   1431  C   VAL   106       8.304  21.933  33.793  1.00 27.78           C  
ATOM   1432  O   VAL   106       7.135  21.879  34.152  1.00 27.98           O  
ATOM   1434  N   THR   107       8.698  22.640  32.750  1.00 27.47           N  
ATOM   1435  CA  THR   107       7.797  23.502  31.995  1.00 27.60           C  
ATOM   1437  CB  THR   107       8.624  24.430  31.114  1.00 27.08           C  
ATOM   1439  OG1 THR   107       9.242  25.406  31.949  1.00 26.99           O  
ATOM   1441  CG2 THR   107       7.752  25.104  30.113  1.00 28.88           C  
ATOM   1445  C   THR   107       6.738  22.762  31.142  1.00 27.29           C  
ATOM   1446  O   THR   107       5.602  23.217  31.046  1.00 27.48           O  
ATOM   1448  N   VAL   108       7.124  21.648  30.524  1.00 26.89           N  
ATOM   1449  CA  VAL   108       6.228  20.847  29.718  1.00 26.46           C  
ATOM   1451  CB  VAL   108       6.701  20.787  28.284  1.00 26.45           C  
ATOM   1453  CG1 VAL   108       5.756  19.953  27.480  1.00 25.92           C  
ATOM   1457  CG2 VAL   108       6.837  22.205  27.700  1.00 26.36           C  
ATOM   1461  C   VAL   108       6.186  19.431  30.231  1.00 26.51           C  
ATOM   1462  O   VAL   108       7.157  18.899  30.725  1.00 26.61           O  
ATOM   1464  N   GLU   109       5.033  18.814  30.117  1.00 27.18           N  
ATOM   1465  CA  GLU   109       4.876  17.390  30.411  1.00 27.29           C  
ATOM   1467  CB  GLU   109       3.488  16.904  29.932  1.00 27.24           C  
ATOM   1470  CG  GLU   109       3.138  15.447  30.308  1.00 28.49           C  
ATOM   1473  CD  GLU   109       1.889  14.937  29.589  1.00 29.27           C  
ATOM   1474  OE1 GLU   109       1.109  15.760  29.061  1.00 29.40           O  
ATOM   1475  OE2 GLU   109       1.691  13.706  29.528  1.00 30.07           O  
ATOM   1476  C   GLU   109       6.009  16.560  29.782  1.00 26.50           C  
ATOM   1477  O   GLU   109       6.244  16.634  28.607  1.00 25.85           O  
ATOM   1479  N   PRO   110       6.734  15.790  30.590  1.00 27.08           N  
ATOM   1480  CA  PRO   110       7.729  14.855  30.045  1.00 27.45           C  
ATOM   1482  CB  PRO   110       8.119  14.018  31.256  1.00 27.41           C  
ATOM   1485  CG  PRO   110       7.870  14.919  32.414  1.00 27.40           C  
ATOM   1488  CD  PRO   110       6.709  15.769  32.066  1.00 27.08           C  
ATOM   1491  C   PRO   110       7.213  13.943  28.942  1.00 27.32           C  
ATOM   1492  O   PRO   110       6.112  13.439  29.046  1.00 26.89           O  
ATOM   1493  N   CYS   111       8.019  13.764  27.895  1.00 27.48           N  
ATOM   1494  CA  CYS   111       7.673  12.895  26.779  1.00 27.20           C  
ATOM   1496  CB  CYS   111       8.596  13.159  25.591  1.00 27.18           C  
ATOM   1499  SG  CYS   111      10.319  12.549  25.762  1.00 26.81           S  
ATOM   1501  C   CYS   111       7.773  11.433  27.179  1.00 27.55           C  
ATOM   1502  O   CYS   111       8.200  11.098  28.282  1.00 27.24           O  
ATOM   1504  N   ILE   112       7.393  10.555  26.260  1.00 27.67           N  
ATOM   1505  CA  ILE   112       7.456   9.134  26.532  1.00 27.66           C  
ATOM   1507  CB  ILE   112       6.865   8.310  25.370  1.00 27.71           C  
ATOM   1509  CG1 ILE   112       5.338   8.440  25.369  1.00 28.05           C  
ATOM   1512  CD1 ILE   112       4.648   7.765  24.177  1.00 28.17           C  
ATOM   1516  CG2 ILE   112       7.261   6.828  25.471  1.00 27.28           C  
ATOM   1520  C   ILE   112       8.872   8.692  26.886  1.00 27.75           C  
ATOM   1521  O   ILE   112       9.050   7.898  27.810  1.00 27.52           O  
ATOM   1523  N   MET   113       9.878   9.206  26.168  1.00 28.00           N  
ATOM   1524  CA  MET   113      11.286   8.865  26.477  1.00 27.71           C  
ATOM   1526  CB  MET   113      12.224   9.558  25.518  1.00 27.36           C  
ATOM   1529  CG  MET   113      13.630   9.038  25.611  1.00 27.66           C  
ATOM   1532  SD  MET   113      14.781  10.217  24.914  1.00 29.59           S  
ATOM   1533  CE  MET   113      15.865  10.464  26.347  1.00 31.93           C  
ATOM   1537  C   MET   113      11.695   9.263  27.906  1.00 27.74           C  
ATOM   1538  O   MET   113      12.210   8.430  28.653  1.00 27.33           O  
ATOM   1540  N   CYS   114      11.461  10.527  28.255  1.00 27.33           N  
ATOM   1541  CA  CYS   114      11.773  11.050  29.574  1.00 27.96           C  
ATOM   1543  CB  CYS   114      11.535  12.562  29.593  1.00 28.16           C  
ATOM   1546  SG  CYS   114      12.745  13.454  28.634  1.00 29.88           S  
ATOM   1548  C   CYS   114      10.984  10.409  30.733  1.00 27.83           C  
ATOM   1549  O   CYS   114      11.560  10.008  31.741  1.00 27.85           O  
ATOM   1551  N   ALA   115       9.675  10.312  30.597  1.00 27.62           N  
ATOM   1552  CA  ALA   115       8.891   9.588  31.569  1.00 27.76           C  
ATOM   1554  CB  ALA   115       7.432   9.558  31.146  1.00 27.42           C  
ATOM   1558  C   ALA   115       9.442   8.163  31.819  1.00 28.27           C  
ATOM   1559  O   ALA   115       9.599   7.752  32.985  1.00 29.59           O  
ATOM   1561  N   ALA   116       9.771   7.412  30.769  1.00 28.12           N  
ATOM   1562  CA  ALA   116      10.385   6.078  30.963  1.00 28.33           C  
ATOM   1564  CB  ALA   116      10.653   5.371  29.619  1.00 27.77           C  
ATOM   1568  C   ALA   116      11.675   6.194  31.785  1.00 28.62           C  
ATOM   1569  O   ALA   116      11.941   5.377  32.671  1.00 29.32           O  
ATOM   1571  N   ALA   117      12.463   7.229  31.508  1.00 28.78           N  
ATOM   1572  CA  ALA   117      13.700   7.484  32.246  1.00 28.73           C  
ATOM   1574  CB  ALA   117      14.421   8.676  31.653  1.00 28.83           C  
ATOM   1578  C   ALA   117      13.441   7.743  33.724  1.00 28.85           C  
ATOM   1579  O   ALA   117      14.094   7.176  34.577  1.00 28.67           O  
ATOM   1581  N   LEU   118      12.477   8.620  34.005  1.00 29.20           N  
ATOM   1582  CA  LEU   118      12.155   9.023  35.360  1.00 28.43           C  
ATOM   1584  CB  LEU   118      11.127  10.154  35.347  1.00 27.97           C  
ATOM   1587  CG  LEU   118      11.692  11.452  34.772  1.00 27.63           C  
ATOM   1589  CD1 LEU   118      10.735  12.603  34.919  1.00 28.37           C  
ATOM   1593  CD2 LEU   118      12.963  11.797  35.439  1.00 28.09           C  
ATOM   1597  C   LEU   118      11.669   7.840  36.159  1.00 28.28           C  
ATOM   1598  O   LEU   118      12.014   7.730  37.331  1.00 28.30           O  
ATOM   1600  N   ARG   119      10.895   6.949  35.534  1.00 28.26           N  
ATOM   1601  CA  ARG   119      10.579   5.659  36.179  1.00 28.76           C  
ATOM   1603  CB  ARG   119       9.775   4.752  35.252  1.00 29.30           C  
ATOM   1606  CG  ARG   119       8.261   4.867  35.387  1.00 29.05           C  
ATOM   1609  CD  ARG   119       7.630   3.767  34.611  1.00 29.20           C  
ATOM   1612  NE  ARG   119       7.435   2.550  35.388  1.00 29.29           N  
ATOM   1614  CZ  ARG   119       6.316   2.241  36.052  1.00 30.71           C  
ATOM   1615  NH1 ARG   119       5.280   3.079  36.090  1.00 31.34           N  
ATOM   1618  NH2 ARG   119       6.229   1.086  36.713  1.00 31.28           N  
ATOM   1621  C   ARG   119      11.826   4.865  36.565  1.00 28.71           C  
ATOM   1622  O   ARG   119      11.942   4.355  37.683  1.00 28.42           O  
ATOM   1624  N   LEU   120      12.738   4.738  35.608  1.00 28.29           N  
ATOM   1625  CA  LEU   120      13.955   3.987  35.836  1.00 28.40           C  
ATOM   1627  CB  LEU   120      14.671   3.762  34.510  1.00 27.90           C  
ATOM   1630  CG  LEU   120      13.979   2.793  33.547  1.00 26.59           C  
ATOM   1632  CD1 LEU   120      14.630   2.885  32.201  1.00 25.10           C  
ATOM   1636  CD2 LEU   120      13.984   1.375  34.042  1.00 24.24           C  
ATOM   1640  C   LEU   120      14.896   4.605  36.898  1.00 28.81           C  
ATOM   1641  O   LEU   120      15.541   3.860  37.658  1.00 29.54           O  
ATOM   1643  N   MET   121      14.978   5.941  36.943  1.00 28.87           N  
ATOM   1644  CA  MET   121      15.712   6.673  37.985  1.00 28.40           C  
ATOM   1646  CB  MET   121      15.922   8.132  37.588  1.00 28.32           C  
ATOM   1649  CG  MET   121      16.793   8.350  36.362  1.00 29.39           C  
ATOM   1652  SD  MET   121      18.368   7.437  36.341  1.00 31.52           S  
ATOM   1653  CE  MET   121      19.455   8.674  37.112  1.00 32.17           C  
ATOM   1657  C   MET   121      14.968   6.697  39.316  1.00 28.60           C  
ATOM   1658  O   MET   121      15.578   6.990  40.327  1.00 28.98           O  
ATOM   1660  N   LYS   122      13.654   6.446  39.301  1.00 28.57           N  
ATOM   1661  CA  LYS   122      12.791   6.393  40.496  1.00 27.97           C  
ATOM   1663  CB  LYS   122      13.311   5.396  41.523  1.00 27.70           C  
ATOM   1666  CG  LYS   122      13.463   4.024  41.001  1.00 27.70           C  
ATOM   1669  CD  LYS   122      13.797   3.117  42.133  1.00 28.38           C  
ATOM   1672  CE  LYS   122      13.990   1.713  41.622  1.00 28.97           C  
ATOM   1675  NZ  LYS   122      14.226   0.736  42.706  1.00 29.76           N  
ATOM   1679  C   LYS   122      12.590   7.725  41.178  1.00 28.20           C  
ATOM   1680  O   LYS   122      12.469   7.773  42.412  1.00 28.06           O  
ATOM   1682  N   ILE   123      12.586   8.805  40.394  1.00 27.95           N  
ATOM   1683  CA  ILE   123      12.130  10.084  40.892  1.00 27.99           C  
ATOM   1685  CB  ILE   123      12.231  11.205  39.833  1.00 28.47           C  
ATOM   1687  CG1 ILE   123      13.668  11.737  39.725  1.00 30.17           C  
ATOM   1690  CD1 ILE   123      14.537  11.101  38.597  1.00 31.52           C  
ATOM   1694  CG2 ILE   123      11.368  12.380  40.218  1.00 27.61           C  
ATOM   1698  C   ILE   123      10.659   9.867  41.267  1.00 27.89           C  
ATOM   1699  O   ILE   123       9.901   9.331  40.452  1.00 27.80           O  
ATOM   1701  N   PRO   124      10.268  10.206  42.521  1.00 27.53           N  
ATOM   1702  CA  PRO   124       8.908  10.069  43.039  1.00 27.20           C  
ATOM   1704  CB  PRO   124       9.133  10.061  44.535  1.00 27.06           C  
ATOM   1707  CG  PRO   124      10.268  10.856  44.751  1.00 27.33           C  
ATOM   1710  CD  PRO   124      11.177  10.670  43.583  1.00 27.38           C  
ATOM   1713  C   PRO   124       7.871  11.158  42.702  1.00 27.45           C  
ATOM   1714  O   PRO   124       6.685  10.838  42.712  1.00 27.46           O  
ATOM   1715  N   LEU   125       8.290  12.403  42.420  1.00 27.23           N  
ATOM   1716  CA  LEU   125       7.342  13.475  42.135  1.00 27.35           C  
ATOM   1718  CB  LEU   125       7.072  14.273  43.410  1.00 27.50           C  
ATOM   1721  CG  LEU   125       6.170  15.505  43.456  1.00 26.55           C  
ATOM   1723  CD1 LEU   125       4.804  15.257  42.848  1.00 27.47           C  
ATOM   1727  CD2 LEU   125       6.038  15.903  44.891  1.00 25.10           C  
ATOM   1731  C   LEU   125       7.805  14.419  41.029  1.00 28.05           C  
ATOM   1732  O   LEU   125       8.891  14.992  41.124  1.00 28.35           O  
ATOM   1734  N   VAL   126       6.962  14.578  39.993  1.00 28.17           N  
ATOM   1735  CA  VAL   126       7.152  15.557  38.936  1.00 27.98           C  
ATOM   1737  CB  VAL   126       7.033  14.889  37.547  1.00 28.31           C  
ATOM   1739  CG1 VAL   126       7.189  15.937  36.449  1.00 28.62           C  
ATOM   1743  CG2 VAL   126       8.075  13.764  37.376  1.00 28.63           C  
ATOM   1747  C   VAL   126       6.066  16.632  39.064  1.00 27.89           C  
ATOM   1748  O   VAL   126       4.885  16.314  39.154  1.00 27.83           O  
ATOM   1750  N   VAL   127       6.461  17.897  39.084  1.00 27.59           N  
ATOM   1751  CA  VAL   127       5.498  18.987  39.043  1.00 27.75           C  
ATOM   1753  CB  VAL   127       5.719  20.057  40.161  1.00 28.05           C  
ATOM   1755  CG1 VAL   127       5.015  21.381  39.854  1.00 27.26           C  
ATOM   1759  CG2 VAL   127       5.246  19.535  41.514  1.00 28.36           C  
ATOM   1763  C   VAL   127       5.737  19.598  37.704  1.00 27.95           C  
ATOM   1764  O   VAL   127       6.864  19.972  37.389  1.00 27.12           O  
ATOM   1766  N   TYR   128       4.680  19.692  36.900  1.00 28.52           N  
ATOM   1767  CA  TYR   128       4.822  20.268  35.566  1.00 28.45           C  
ATOM   1769  CB  TYR   128       5.025  19.162  34.533  1.00 28.06           C  
ATOM   1772  CG  TYR   128       3.818  18.402  34.078  1.00 28.34           C  
ATOM   1773  CD1 TYR   128       3.626  17.059  34.437  1.00 29.46           C  
ATOM   1775  CE1 TYR   128       2.514  16.329  33.958  1.00 28.31           C  
ATOM   1777  CZ  TYR   128       1.612  16.958  33.113  1.00 29.12           C  
ATOM   1778  OH  TYR   128       0.500  16.310  32.604  1.00 28.84           O  
ATOM   1780  CE2 TYR   128       1.816  18.275  32.740  1.00 29.55           C  
ATOM   1782  CD2 TYR   128       2.914  18.975  33.204  1.00 28.51           C  
ATOM   1784  C   TYR   128       3.757  21.297  35.151  1.00 28.39           C  
ATOM   1785  O   TYR   128       2.754  21.529  35.860  1.00 28.91           O  
ATOM   1787  N   GLY   129       4.029  21.932  34.015  1.00 27.67           N  
ATOM   1788  CA  GLY   129       3.199  22.991  33.493  1.00 27.87           C  
ATOM   1791  C   GLY   129       2.120  22.551  32.535  1.00 27.68           C  
ATOM   1792  O   GLY   129       1.142  21.973  32.960  1.00 28.21           O  
ATOM   1794  N   CYS   130       2.275  22.855  31.252  1.00 27.34           N  
ATOM   1795  CA  CYS   130       1.279  22.499  30.266  1.00 27.89           C  
ATOM   1797  CB  CYS   130       1.342  23.480  29.107  1.00 27.89           C  
ATOM   1800  SG  CYS   130       2.914  23.319  28.162  1.00 30.29           S  
ATOM   1802  C   CYS   130       1.470  21.072  29.724  1.00 27.56           C  
ATOM   1803  O   CYS   130       2.489  20.438  29.937  1.00 26.76           O  
ATOM   1805  N   GLN   131       0.471  20.610  28.984  1.00 27.70           N  
ATOM   1806  CA  GLN   131       0.459  19.278  28.412  1.00 27.98           C  
ATOM   1808  CB  GLN   131      -0.950  18.922  27.932  1.00 28.47           C  
ATOM   1811  CG  GLN   131      -2.080  18.913  29.037  1.00 29.70           C  
ATOM   1814  CD  GLN   131      -1.959  17.735  30.027  1.00 31.77           C  
ATOM   1815  OE1 GLN   131      -1.739  16.574  29.619  1.00 33.82           O  
ATOM   1816  NE2 GLN   131      -2.093  18.027  31.327  1.00 31.60           N  
ATOM   1819  C   GLN   131       1.429  19.146  27.243  1.00 27.96           C  
ATOM   1820  O   GLN   131       1.803  20.137  26.635  1.00 27.61           O  
ATOM   1822  N   ASN   132       1.838  17.908  26.957  1.00 27.61           N  
ATOM   1823  CA  ASN   132       2.626  17.589  25.790  1.00 27.44           C  
ATOM   1825  CB  ASN   132       3.852  16.823  26.237  1.00 27.50           C  
ATOM   1828  CG  ASN   132       4.790  16.477  25.105  1.00 27.17           C  
ATOM   1829  OD1 ASN   132       4.451  16.645  23.947  1.00 28.04           O  
ATOM   1830  ND2 ASN   132       5.969  15.974  25.440  1.00 26.21           N  
ATOM   1833  C   ASN   132       1.780  16.782  24.793  1.00 27.56           C  
ATOM   1834  O   ASN   132       1.796  15.567  24.792  1.00 27.93           O  
ATOM   1836  N   GLU   133       1.042  17.475  23.940  1.00 27.82           N  
ATOM   1837  CA  GLU   133       0.081  16.823  23.046  1.00 28.46           C  
ATOM   1839  CB  GLU   133      -0.771  17.863  22.301  1.00 28.66           C  
ATOM   1842  CG  GLU   133      -2.060  18.259  23.041  1.00 30.06           C  
ATOM   1845  CD  GLU   133      -2.933  19.217  22.235  1.00 31.68           C  
ATOM   1846  OE1 GLU   133      -3.256  18.917  21.055  1.00 31.78           O  
ATOM   1847  OE2 GLU   133      -3.298  20.278  22.791  1.00 33.58           O  
ATOM   1848  C   GLU   133       0.692  15.860  22.029  1.00 28.35           C  
ATOM   1849  O   GLU   133       0.094  14.830  21.710  1.00 28.39           O  
ATOM   1851  N   ARG   134       1.869  16.202  21.523  1.00 28.25           N  
ATOM   1852  CA  ARG   134       2.561  15.377  20.550  1.00 28.21           C  
ATOM   1854  CB  ARG   134       3.683  16.166  19.899  1.00 28.39           C  
ATOM   1857  CG  ARG   134       3.264  17.431  19.221  1.00 28.78           C  
ATOM   1860  CD  ARG   134       4.465  18.125  18.644  1.00 29.15           C  
ATOM   1863  NE  ARG   134       4.091  19.255  17.801  1.00 29.84           N  
ATOM   1865  CZ  ARG   134       4.910  19.864  16.935  1.00 31.27           C  
ATOM   1866  NH1 ARG   134       6.177  19.461  16.778  1.00 31.15           N  
ATOM   1869  NH2 ARG   134       4.464  20.902  16.221  1.00 32.11           N  
ATOM   1872  C   ARG   134       3.178  14.108  21.162  1.00 28.31           C  
ATOM   1873  O   ARG   134       3.053  13.042  20.586  1.00 28.43           O  
ATOM   1875  N   PHE   135       3.865  14.216  22.302  1.00 28.31           N  
ATOM   1876  CA  PHE   135       4.589  13.063  22.841  1.00 28.53           C  
ATOM   1878  CB  PHE   135       6.034  13.163  22.343  1.00 28.53           C  
ATOM   1881  CG  PHE   135       6.732  11.841  22.165  1.00 28.29           C  
ATOM   1882  CD1 PHE   135       6.029  10.670  21.855  1.00 28.13           C  
ATOM   1884  CE1 PHE   135       6.692   9.435  21.694  1.00 28.35           C  
ATOM   1886  CZ  PHE   135       8.063   9.366  21.827  1.00 28.92           C  
ATOM   1888  CE2 PHE   135       8.788  10.545  22.126  1.00 30.44           C  
ATOM   1890  CD2 PHE   135       8.112  11.776  22.288  1.00 28.94           C  
ATOM   1892  C   PHE   135       4.521  12.863  24.376  1.00 28.82           C  
ATOM   1893  O   PHE   135       5.346  12.140  24.953  1.00 29.17           O  
ATOM   1895  N   GLY   136       3.510  13.446  25.019  1.00 28.58           N  
ATOM   1896  CA  GLY   136       3.332  13.292  26.455  1.00 29.12           C  
ATOM   1899  C   GLY   136       3.279  11.832  26.957  1.00 29.71           C  
ATOM   1900  O   GLY   136       2.548  10.985  26.410  1.00 29.56           O  
ATOM   1902  N   GLY   137       4.055  11.555  28.013  1.00 29.77           N  
ATOM   1903  CA  GLY   137       4.027  10.275  28.740  1.00 29.90           C  
ATOM   1906  C   GLY   137       3.441  10.285  30.168  1.00 29.93           C  
ATOM   1907  O   GLY   137       3.670   9.350  30.965  1.00 30.73           O  
ATOM   1909  N   CYS   138       2.667  11.308  30.498  1.00 29.42           N  
ATOM   1910  CA  CYS   138       2.001  11.353  31.793  1.00 29.62           C  
ATOM   1912  CB  CYS   138       2.460  12.576  32.587  1.00 29.79           C  
ATOM   1915  SG  CYS   138       4.218  12.576  32.898  1.00 30.23           S  
ATOM   1917  C   CYS   138       0.490  11.355  31.686  1.00 29.17           C  
ATOM   1918  O   CYS   138      -0.197  11.656  32.652  1.00 28.48           O  
ATOM   1920  N   GLY   139      -0.019  11.016  30.511  1.00 29.34           N  
ATOM   1921  CA  GLY   139      -1.452  11.056  30.270  1.00 29.45           C  
ATOM   1924  C   GLY   139      -1.880  11.464  28.872  1.00 29.50           C  
ATOM   1925  O   GLY   139      -2.898  10.977  28.401  1.00 30.03           O  
ATOM   1927  N   SER   140      -1.121  12.330  28.190  1.00 29.38           N  
ATOM   1928  CA  SER   140      -1.573  12.879  26.892  1.00 28.69           C  
ATOM   1930  CB  SER   140      -0.698  14.057  26.466  1.00 28.93           C  
ATOM   1933  OG  SER   140      -0.859  15.151  27.372  1.00 29.34           O  
ATOM   1935  C   SER   140      -1.596  11.834  25.803  1.00 28.12           C  
ATOM   1936  O   SER   140      -2.623  11.555  25.238  1.00 27.68           O  
ATOM   1938  N   VAL   141      -0.454  11.256  25.506  1.00 28.02           N  
ATOM   1939  CA  VAL   141      -0.395  10.196  24.522  1.00 27.98           C  
ATOM   1941  CB  VAL   141       0.827  10.374  23.645  1.00 27.84           C  
ATOM   1943  CG1 VAL   141       0.846   9.345  22.553  1.00 27.05           C  
ATOM   1947  CG2 VAL   141       0.852  11.775  23.089  1.00 27.21           C  
ATOM   1951  C   VAL   141      -0.345   8.820  25.204  1.00 28.40           C  
ATOM   1952  O   VAL   141      -0.958   7.871  24.753  1.00 28.56           O  
ATOM   1954  N   LEU   142       0.434   8.716  26.266  1.00 28.60           N  
ATOM   1955  CA  LEU   142       0.486   7.511  27.059  1.00 28.88           C  
ATOM   1957  CB  LEU   142       1.655   6.641  26.609  1.00 29.36           C  
ATOM   1960  CG  LEU   142       1.363   5.515  25.614  1.00 29.50           C  
ATOM   1962  CD1 LEU   142       2.672   5.036  24.980  1.00 29.36           C  
ATOM   1966  CD2 LEU   142       0.667   4.390  26.351  1.00 28.79           C  
ATOM   1970  C   LEU   142       0.688   7.927  28.500  1.00 29.16           C  
ATOM   1971  O   LEU   142       1.134   9.040  28.782  1.00 29.17           O  
ATOM   1973  N   ASN   143       0.385   7.034  29.430  1.00 29.52           N  
ATOM   1974  CA  ASN   143       0.660   7.355  30.830  1.00 29.66           C  
ATOM   1976  CB  ASN   143      -0.628   7.395  31.629  1.00 29.61           C  
ATOM   1979  CG  ASN   143      -0.449   8.019  33.008  1.00 30.12           C  
ATOM   1980  OD1 ASN   143       0.647   8.046  33.602  1.00 27.75           O  
ATOM   1981  ND2 ASN   143      -1.567   8.488  33.549  1.00 31.84           N  
ATOM   1984  C   ASN   143       1.656   6.390  31.451  1.00 29.47           C  
ATOM   1985  O   ASN   143       1.281   5.505  32.230  1.00 28.77           O  
ATOM   1987  N   ILE   144       2.927   6.598  31.096  1.00 29.28           N  
ATOM   1988  CA  ILE   144       4.015   5.785  31.617  1.00 29.57           C  
ATOM   1990  CB  ILE   144       5.319   6.097  30.858  1.00 30.11           C  
ATOM   1992  CG1 ILE   144       5.167   5.738  29.372  1.00 31.30           C  
ATOM   1995  CD1 ILE   144       4.789   4.257  29.149  1.00 30.50           C  
ATOM   1999  CG2 ILE   144       6.510   5.303  31.422  1.00 30.18           C  
ATOM   2003  C   ILE   144       4.215   6.059  33.113  1.00 29.39           C  
ATOM   2004  O   ILE   144       4.545   5.141  33.866  1.00 28.54           O  
ATOM   2006  N   ALA   145       4.002   7.321  33.525  1.00 29.02           N  
ATOM   2007  CA  ALA   145       4.144   7.720  34.926  1.00 28.89           C  
ATOM   2009  CB  ALA   145       3.712   9.214  35.134  1.00 28.28           C  
ATOM   2013  C   ALA   145       3.364   6.780  35.871  1.00 29.09           C  
ATOM   2014  O   ALA   145       3.871   6.429  36.949  1.00 30.20           O  
ATOM   2016  N   SER   146       2.152   6.351  35.482  1.00 28.63           N  
ATOM   2017  CA  SER   146       1.299   5.589  36.399  1.00 28.27           C  
ATOM   2019  CB  SER   146      -0.022   6.323  36.579  1.00 28.33           C  
ATOM   2022  OG  SER   146      -0.803   6.270  35.407  1.00 28.49           O  
ATOM   2024  C   SER   146       1.055   4.147  35.959  1.00 27.91           C  
ATOM   2025  O   SER   146       0.192   3.468  36.474  1.00 27.20           O  
ATOM   2027  N   ALA   147       1.844   3.685  35.009  1.00 28.29           N  
ATOM   2028  CA  ALA   147       1.650   2.368  34.418  1.00 28.30           C  
ATOM   2030  CB  ALA   147       2.500   2.220  33.141  1.00 28.16           C  
ATOM   2034  C   ALA   147       2.008   1.281  35.414  1.00 28.18           C  
ATOM   2035  O   ALA   147       3.001   1.382  36.137  1.00 27.83           O  
ATOM   2037  N   ASP   148       1.178   0.248  35.441  1.00 28.60           N  
ATOM   2038  CA  ASP   148       1.422  -0.958  36.235  1.00 29.01           C  
ATOM   2040  CB  ASP   148       0.116  -1.758  36.344  1.00 29.22           C  
ATOM   2043  CG  ASP   148       0.271  -3.024  37.194  1.00 30.33           C  
ATOM   2044  OD1 ASP   148       1.223  -3.009  38.017  1.00 32.80           O  
ATOM   2045  OD2 ASP   148      -0.548  -4.005  37.063  1.00 28.99           O  
ATOM   2046  C   ASP   148       2.529  -1.831  35.603  1.00 28.97           C  
ATOM   2047  O   ASP   148       2.258  -2.648  34.732  1.00 29.13           O  
ATOM   2049  N   LEU   149       3.769  -1.644  36.037  1.00 28.92           N  
ATOM   2050  CA  LEU   149       4.910  -2.289  35.410  1.00 28.99           C  
ATOM   2052  CB  LEU   149       5.672  -1.312  34.501  1.00 28.85           C  
ATOM   2055  CG  LEU   149       4.909  -0.925  33.221  1.00 29.26           C  
ATOM   2057  CD1 LEU   149       5.552   0.303  32.539  1.00 28.15           C  
ATOM   2061  CD2 LEU   149       4.777  -2.100  32.253  1.00 27.32           C  
ATOM   2065  C   LEU   149       5.774  -2.797  36.547  1.00 29.23           C  
ATOM   2066  O   LEU   149       6.621  -2.072  37.076  1.00 29.09           O  
ATOM   2068  N   PRO   150       5.560  -4.060  36.923  1.00 29.54           N  
ATOM   2069  CA  PRO   150       6.060  -4.553  38.210  1.00 29.67           C  
ATOM   2071  CB  PRO   150       5.659  -6.054  38.214  1.00 29.48           C  
ATOM   2074  CG  PRO   150       4.613  -6.214  37.167  1.00 29.39           C  
ATOM   2077  CD  PRO   150       4.844  -5.103  36.153  1.00 29.63           C  
ATOM   2080  C   PRO   150       7.581  -4.399  38.417  1.00 29.61           C  
ATOM   2081  O   PRO   150       8.018  -3.945  39.489  1.00 29.54           O  
ATOM   2082  N   ASN   151       8.376  -4.783  37.422  1.00 29.36           N  
ATOM   2083  CA  ASN   151       9.822  -4.955  37.659  1.00 29.29           C  
ATOM   2085  CB  ASN   151      10.222  -6.417  37.379  1.00 29.22           C  
ATOM   2088  CG  ASN   151       9.393  -7.403  38.184  1.00 29.70           C  
ATOM   2089  OD1 ASN   151       9.515  -7.467  39.415  1.00 31.50           O  
ATOM   2090  ND2 ASN   151       8.529  -8.160  37.506  1.00 29.02           N  
ATOM   2093  C   ASN   151      10.696  -3.953  36.893  1.00 29.09           C  
ATOM   2094  O   ASN   151      11.868  -4.212  36.608  1.00 28.75           O  
ATOM   2096  N   THR   152      10.114  -2.797  36.586  1.00 29.07           N  
ATOM   2097  CA  THR   152      10.816  -1.768  35.853  1.00 29.13           C  
ATOM   2099  CB  THR   152      10.365  -1.749  34.358  1.00 29.31           C  
ATOM   2101  OG1 THR   152       8.964  -1.486  34.277  1.00 28.92           O  
ATOM   2103  CG2 THR   152      10.672  -3.123  33.693  1.00 29.99           C  
ATOM   2107  C   THR   152      10.600  -0.410  36.487  1.00 28.94           C  
ATOM   2108  O   THR   152       9.581   0.221  36.237  1.00 29.39           O  
ATOM   2110  N   GLY   153      11.562   0.038  37.301  1.00 28.73           N  
ATOM   2111  CA  GLY   153      11.483   1.345  37.989  1.00 28.04           C  
ATOM   2114  C   GLY   153      10.359   1.408  39.007  1.00 27.67           C  
ATOM   2115  O   GLY   153       9.875   0.385  39.480  1.00 27.40           O  
ATOM   2117  N   ARG   154       9.926   2.618  39.332  1.00 27.56           N  
ATOM   2118  CA  ARG   154       8.747   2.822  40.177  1.00 27.59           C  
ATOM   2120  CB  ARG   154       9.132   3.433  41.525  1.00 27.45           C  
ATOM   2123  CG  ARG   154       9.477   2.437  42.549  1.00 27.94           C  
ATOM   2126  CD  ARG   154      10.289   3.050  43.692  1.00 29.70           C  
ATOM   2129  NE  ARG   154      11.140   2.009  44.299  1.00 31.13           N  
ATOM   2131  CZ  ARG   154      11.949   2.180  45.345  1.00 30.89           C  
ATOM   2132  NH1 ARG   154      12.044   3.355  45.964  1.00 31.54           N  
ATOM   2135  NH2 ARG   154      12.672   1.155  45.773  1.00 31.08           N  
ATOM   2138  C   ARG   154       7.802   3.767  39.492  1.00 27.48           C  
ATOM   2139  O   ARG   154       8.250   4.674  38.804  1.00 28.31           O  
ATOM   2141  N   PRO   155       6.494   3.619  39.730  1.00 27.20           N  
ATOM   2142  CA  PRO   155       5.580   4.628  39.183  1.00 27.00           C  
ATOM   2144  CB  PRO   155       4.213   4.019  39.450  1.00 27.10           C  
ATOM   2147  CG  PRO   155       4.437   3.158  40.638  1.00 26.63           C  
ATOM   2150  CD  PRO   155       5.785   2.594  40.507  1.00 26.55           C  
ATOM   2153  C   PRO   155       5.717   5.931  39.935  1.00 26.56           C  
ATOM   2154  O   PRO   155       6.093   5.929  41.091  1.00 26.56           O  
ATOM   2155  N   PHE   156       5.403   7.035  39.293  1.00 26.62           N  
ATOM   2156  CA  PHE   156       5.498   8.302  39.973  1.00 27.22           C  
ATOM   2158  CB  PHE   156       6.778   9.058  39.597  1.00 27.60           C  
ATOM   2161  CG  PHE   156       6.860   9.460  38.156  1.00 28.10           C  
ATOM   2162  CD1 PHE   156       6.445  10.730  37.746  1.00 28.61           C  
ATOM   2164  CE1 PHE   156       6.503  11.085  36.419  1.00 27.46           C  
ATOM   2166  CZ  PHE   156       7.012  10.192  35.490  1.00 27.56           C  
ATOM   2168  CE2 PHE   156       7.440   8.944  35.877  1.00 27.45           C  
ATOM   2170  CD2 PHE   156       7.367   8.578  37.206  1.00 27.25           C  
ATOM   2172  C   PHE   156       4.281   9.183  39.828  1.00 27.25           C  
ATOM   2173  O   PHE   156       3.396   8.940  39.036  1.00 27.35           O  
ATOM   2175  N   GLN   157       4.266  10.209  40.661  1.00 28.12           N  
ATOM   2176  CA  GLN   157       3.162  11.132  40.818  1.00 28.30           C  
ATOM   2178  CB  GLN   157       3.023  11.430  42.312  1.00 28.26           C  
ATOM   2181  CG  GLN   157       1.573  11.587  42.818  1.00 29.14           C  
ATOM   2184  CD  GLN   157       0.726  10.354  42.579  1.00 28.88           C  
ATOM   2185  OE1 GLN   157       1.229   9.216  42.576  1.00 28.76           O  
ATOM   2186  NE2 GLN   157      -0.573  10.565  42.387  1.00 28.49           N  
ATOM   2189  C   GLN   157       3.458  12.421  40.041  1.00 28.32           C  
ATOM   2190  O   GLN   157       4.630  12.798  39.874  1.00 28.21           O  
ATOM   2192  N   CYS   158       2.393  13.052  39.540  1.00 28.34           N  
ATOM   2193  CA  CYS   158       2.457  14.325  38.805  1.00 28.55           C  
ATOM   2195  CB  CYS   158       2.053  14.113  37.368  1.00 28.36           C  
ATOM   2198  SG  CYS   158       3.234  13.191  36.449  1.00 32.99           S  
ATOM   2200  C   CYS   158       1.518  15.370  39.380  1.00 28.03           C  
ATOM   2201  O   CYS   158       0.415  15.028  39.825  1.00 28.21           O  
ATOM   2203  N   ILE   159       1.945  16.633  39.348  1.00 27.55           N  
ATOM   2204  CA  ILE   159       1.083  17.776  39.671  1.00 27.15           C  
ATOM   2206  CB  ILE   159       1.560  18.532  40.932  1.00 27.19           C  
ATOM   2208  CG1 ILE   159       1.641  17.546  42.109  1.00 27.25           C  
ATOM   2211  CD1 ILE   159       1.732  18.195  43.500  1.00 27.36           C  
ATOM   2215  CG2 ILE   159       0.655  19.748  41.227  1.00 26.47           C  
ATOM   2219  C   ILE   159       1.151  18.672  38.468  1.00 27.06           C  
ATOM   2220  O   ILE   159       2.008  19.550  38.397  1.00 27.30           O  
ATOM   2222  N   PRO   160       0.298  18.414  37.472  1.00 27.10           N  
ATOM   2223  CA  PRO   160       0.305  19.229  36.281  1.00 27.19           C  
ATOM   2225  CB  PRO   160      -0.544  18.406  35.303  1.00 26.90           C  
ATOM   2228  CG  PRO   160      -1.433  17.695  36.094  1.00 26.70           C  
ATOM   2231  CD  PRO   160      -0.693  17.339  37.350  1.00 27.27           C  
ATOM   2234  C   PRO   160      -0.314  20.600  36.470  1.00 27.02           C  
ATOM   2235  O   PRO   160      -0.932  20.865  37.479  1.00 27.06           O  
ATOM   2236  N   GLY   161      -0.094  21.468  35.491  1.00 27.50           N  
ATOM   2237  CA  GLY   161      -0.924  22.640  35.290  1.00 27.79           C  
ATOM   2240  C   GLY   161      -0.387  23.921  35.877  1.00 27.97           C  
ATOM   2241  O   GLY   161      -0.988  24.972  35.702  1.00 28.30           O  
ATOM   2243  N   TYR   162       0.734  23.872  36.581  1.00 28.36           N  
ATOM   2244  CA  TYR   162       1.233  25.110  37.155  1.00 28.73           C  
ATOM   2246  CB  TYR   162       2.370  24.897  38.182  1.00 29.03           C  
ATOM   2249  CG  TYR   162       2.842  26.246  38.703  1.00 30.02           C  
ATOM   2250  CD1 TYR   162       2.168  26.905  39.728  1.00 30.55           C  
ATOM   2252  CE1 TYR   162       2.574  28.183  40.156  1.00 31.77           C  
ATOM   2254  CZ  TYR   162       3.668  28.808  39.529  1.00 32.70           C  
ATOM   2255  OH  TYR   162       4.146  30.073  39.894  1.00 31.50           O  
ATOM   2257  CE2 TYR   162       4.321  28.152  38.497  1.00 32.51           C  
ATOM   2259  CD2 TYR   162       3.893  26.901  38.083  1.00 31.20           C  
ATOM   2261  C   TYR   162       1.658  26.061  36.018  1.00 28.23           C  
ATOM   2262  O   TYR   162       2.606  25.766  35.303  1.00 27.90           O  
ATOM   2264  N   ARG   163       0.938  27.177  35.868  1.00 27.90           N  
ATOM   2265  CA  ARG   163       1.139  28.134  34.763  1.00 27.84           C  
ATOM   2267  CB  ARG   163       2.396  28.962  35.001  1.00 27.51           C  
ATOM   2270  CG  ARG   163       2.350  29.744  36.287  1.00 28.30           C  
ATOM   2273  CD  ARG   163       3.691  30.412  36.611  1.00 28.58           C  
ATOM   2276  NE  ARG   163       3.973  31.592  35.798  1.00 29.09           N  
ATOM   2278  CZ  ARG   163       5.109  32.290  35.861  1.00 29.67           C  
ATOM   2279  NH1 ARG   163       6.078  31.937  36.710  1.00 30.17           N  
ATOM   2282  NH2 ARG   163       5.285  33.355  35.082  1.00 29.92           N  
ATOM   2285  C   ARG   163       1.174  27.499  33.350  1.00 27.71           C  
ATOM   2286  O   ARG   163       1.954  27.913  32.497  1.00 27.28           O  
ATOM   2288  N   ALA   164       0.302  26.517  33.113  1.00 27.57           N  
ATOM   2289  CA  ALA   164       0.159  25.891  31.798  1.00 27.60           C  
ATOM   2291  CB  ALA   164      -1.012  24.920  31.791  1.00 27.29           C  
ATOM   2295  C   ALA   164      -0.012  26.895  30.656  1.00 27.60           C  
ATOM   2296  O   ALA   164       0.579  26.704  29.599  1.00 27.70           O  
ATOM   2298  N   GLU   165      -0.800  27.951  30.862  1.00 27.39           N  
ATOM   2299  CA  GLU   165      -1.129  28.868  29.776  1.00 27.48           C  
ATOM   2301  CB  GLU   165      -2.048  29.961  30.262  1.00 27.81           C  
ATOM   2304  CG  GLU   165      -3.485  29.532  30.421  1.00 28.47           C  
ATOM   2307  CD  GLU   165      -4.392  30.708  30.786  1.00 30.58           C  
ATOM   2308  OE1 GLU   165      -4.442  31.711  30.023  1.00 30.66           O  
ATOM   2309  OE2 GLU   165      -5.060  30.633  31.849  1.00 32.43           O  
ATOM   2310  C   GLU   165       0.095  29.506  29.147  1.00 27.46           C  
ATOM   2311  O   GLU   165       0.268  29.497  27.928  1.00 27.18           O  
ATOM   2313  N   GLU   166       0.952  30.060  29.986  1.00 27.59           N  
ATOM   2314  CA  GLU   166       2.217  30.598  29.507  1.00 27.66           C  
ATOM   2316  CB  GLU   166       2.961  31.263  30.642  1.00 27.89           C  
ATOM   2319  CG  GLU   166       2.239  32.502  31.138  1.00 28.65           C  
ATOM   2322  CD  GLU   166       2.848  33.086  32.398  1.00 29.34           C  
ATOM   2323  OE1 GLU   166       3.360  32.322  33.252  1.00 28.90           O  
ATOM   2324  OE2 GLU   166       2.794  34.329  32.526  1.00 30.57           O  
ATOM   2325  C   GLU   166       3.097  29.544  28.876  1.00 27.37           C  
ATOM   2326  O   GLU   166       3.672  29.780  27.827  1.00 27.66           O  
ATOM   2328  N   ALA   167       3.185  28.376  29.498  1.00 27.20           N  
ATOM   2329  CA  ALA   167       3.951  27.277  28.926  1.00 26.97           C  
ATOM   2331  CB  ALA   167       3.988  26.105  29.869  1.00 26.83           C  
ATOM   2335  C   ALA   167       3.441  26.861  27.541  1.00 26.95           C  
ATOM   2336  O   ALA   167       4.225  26.686  26.627  1.00 27.07           O  
ATOM   2338  N   VAL   168       2.146  26.697  27.351  1.00 27.13           N  
ATOM   2339  CA  VAL   168       1.671  26.376  25.996  1.00 27.57           C  
ATOM   2341  CB  VAL   168       0.208  25.937  25.964  1.00 27.39           C  
ATOM   2343  CG1 VAL   168       0.085  24.566  26.594  1.00 27.92           C  
ATOM   2347  CG2 VAL   168      -0.663  26.963  26.637  1.00 26.18           C  
ATOM   2351  C   VAL   168       1.852  27.548  25.023  1.00 28.01           C  
ATOM   2352  O   VAL   168       2.143  27.336  23.839  1.00 27.90           O  
ATOM   2354  N   GLU   169       1.711  28.781  25.515  1.00 28.22           N  
ATOM   2355  CA  GLU   169       1.960  29.937  24.661  1.00 28.31           C  
ATOM   2357  CB  GLU   169       1.661  31.238  25.379  1.00 28.19           C  
ATOM   2360  CG  GLU   169       0.934  32.227  24.473  1.00 29.54           C  
ATOM   2363  CD  GLU   169       0.943  33.661  25.021  1.00 31.96           C  
ATOM   2364  OE1 GLU   169       1.714  33.912  26.000  1.00 34.14           O  
ATOM   2365  OE2 GLU   169       0.198  34.544  24.472  1.00 32.15           O  
ATOM   2366  C   GLU   169       3.388  29.963  24.101  1.00 28.30           C  
ATOM   2367  O   GLU   169       3.597  30.326  22.943  1.00 28.98           O  
ATOM   2369  N   MET   170       4.367  29.589  24.914  1.00 28.08           N  
ATOM   2370  CA  MET   170       5.754  29.551  24.453  1.00 28.04           C  
ATOM   2372  CB  MET   170       6.726  29.335  25.622  1.00 27.87           C  
ATOM   2375  CG  MET   170       7.074  30.615  26.367  1.00 28.33           C  
ATOM   2378  SD  MET   170       8.249  30.471  27.752  1.00 28.55           S  
ATOM   2379  CE  MET   170       7.214  29.683  28.987  1.00 27.96           C  
ATOM   2383  C   MET   170       5.940  28.468  23.400  1.00 28.13           C  
ATOM   2384  O   MET   170       6.505  28.715  22.348  1.00 28.20           O  
ATOM   2386  N   LEU   171       5.473  27.261  23.700  1.00 28.42           N  
ATOM   2387  CA  LEU   171       5.558  26.143  22.769  1.00 28.42           C  
ATOM   2389  CB  LEU   171       4.834  24.913  23.331  1.00 28.74           C  
ATOM   2392  CG  LEU   171       5.614  23.807  24.025  1.00 28.64           C  
ATOM   2394  CD1 LEU   171       4.612  22.730  24.485  1.00 27.77           C  
ATOM   2398  CD2 LEU   171       6.693  23.239  23.103  1.00 28.05           C  
ATOM   2402  C   LEU   171       4.911  26.485  21.439  1.00 28.37           C  
ATOM   2403  O   LEU   171       5.433  26.122  20.377  1.00 28.57           O  
ATOM   2405  N   LYS   172       3.753  27.142  21.499  1.00 28.00           N  
ATOM   2406  CA  LYS   172       3.012  27.463  20.274  1.00 27.85           C  
ATOM   2408  CB  LYS   172       1.593  28.000  20.576  1.00 27.67           C  
ATOM   2411  CG  LYS   172       0.523  26.888  20.684  1.00 27.83           C  
ATOM   2414  CD  LYS   172      -0.851  27.407  21.176  1.00 28.79           C  
ATOM   2417  CE  LYS   172      -1.973  26.373  20.896  1.00 29.34           C  
ATOM   2420  NZ  LYS   172      -2.428  26.347  19.368  1.00 29.31           N  
ATOM   2424  C   LYS   172       3.815  28.432  19.425  1.00 27.32           C  
ATOM   2425  O   LYS   172       3.942  28.266  18.218  1.00 27.26           O  
ATOM   2427  N   THR   173       4.380  29.432  20.074  1.00 27.30           N  
ATOM   2428  CA  THR   173       5.135  30.429  19.362  1.00 27.36           C  
ATOM   2430  CB  THR   173       5.501  31.639  20.254  1.00 26.82           C  
ATOM   2432  OG1 THR   173       6.315  32.503  19.498  1.00 28.03           O  
ATOM   2434  CG2 THR   173       6.295  31.285  21.426  1.00 26.84           C  
ATOM   2438  C   THR   173       6.353  29.769  18.728  1.00 27.39           C  
ATOM   2439  O   THR   173       6.729  30.102  17.611  1.00 27.65           O  
ATOM   2441  N   PHE   174       6.925  28.799  19.429  1.00 27.67           N  
ATOM   2442  CA  PHE   174       8.075  28.052  18.934  1.00 27.96           C  
ATOM   2444  CB  PHE   174       8.691  27.157  20.029  1.00 28.11           C  
ATOM   2447  CG  PHE   174       9.701  26.141  19.491  1.00 27.94           C  
ATOM   2448  CD1 PHE   174      11.002  26.527  19.174  1.00 26.47           C  
ATOM   2450  CE1 PHE   174      11.911  25.605  18.678  1.00 26.06           C  
ATOM   2452  CZ  PHE   174      11.523  24.288  18.477  1.00 25.76           C  
ATOM   2454  CE2 PHE   174      10.242  23.892  18.780  1.00 26.66           C  
ATOM   2456  CD2 PHE   174       9.334  24.807  19.287  1.00 27.84           C  
ATOM   2458  C   PHE   174       7.766  27.179  17.721  1.00 28.18           C  
ATOM   2459  O   PHE   174       8.631  27.024  16.863  1.00 28.86           O  
ATOM   2461  N   TYR   175       6.575  26.582  17.646  1.00 28.31           N  
ATOM   2462  CA  TYR   175       6.244  25.756  16.479  1.00 28.37           C  
ATOM   2464  CB  TYR   175       5.120  24.775  16.797  1.00 28.20           C  
ATOM   2467  CG  TYR   175       5.549  23.642  17.687  1.00 29.03           C  
ATOM   2468  CD1 TYR   175       4.708  23.182  18.704  1.00 29.68           C  
ATOM   2470  CE1 TYR   175       5.092  22.132  19.551  1.00 30.13           C  
ATOM   2472  CZ  TYR   175       6.344  21.524  19.369  1.00 30.83           C  
ATOM   2473  OH  TYR   175       6.716  20.480  20.195  1.00 33.11           O  
ATOM   2475  CE2 TYR   175       7.205  21.961  18.362  1.00 29.36           C  
ATOM   2477  CD2 TYR   175       6.801  23.013  17.521  1.00 29.43           C  
ATOM   2479  C   TYR   175       5.922  26.556  15.211  1.00 28.44           C  
ATOM   2480  O   TYR   175       5.590  25.962  14.192  1.00 28.62           O  
ATOM   2482  N   LYS   176       6.052  27.880  15.254  1.00 28.50           N  
ATOM   2483  CA  LYS   176       6.067  28.676  14.029  1.00 29.01           C  
ATOM   2485  CB  LYS   176       5.261  29.955  14.213  1.00 28.81           C  
ATOM   2488  CG  LYS   176       3.855  29.628  14.728  1.00 29.06           C  
ATOM   2491  CD  LYS   176       3.017  30.883  15.126  1.00 28.97           C  
ATOM   2494  CE  LYS   176       1.805  30.431  16.053  1.00 28.62           C  
ATOM   2497  NZ  LYS   176       0.966  31.639  16.480  1.00 28.07           N  
ATOM   2501  C   LYS   176       7.516  28.924  13.596  1.00 29.73           C  
ATOM   2502  O   LYS   176       8.033  30.071  13.612  1.00 29.38           O  
ATOM   2504  N   GLN   177       8.151  27.782  13.243  1.00 30.84           N  
ATOM   2505  CA  GLN   177       9.491  27.720  12.613  1.00 31.22           C  
ATOM   2507  CB  GLN   177      10.615  28.236  13.553  1.00 31.62           C  
ATOM   2510  CG  GLN   177      12.100  28.010  13.035  1.00 32.08           C  
ATOM   2513  CD  GLN   177      12.575  29.029  11.958  1.00 32.52           C  
ATOM   2514  OE1 GLN   177      12.497  30.261  12.160  1.00 31.81           O  
ATOM   2515  NE2 GLN   177      13.111  28.498  10.831  1.00 31.77           N  
ATOM   2518  C   GLN   177       9.731  26.249  12.215  1.00 30.80           C  
ATOM   2519  O   GLN   177       9.033  25.353  12.722  1.00 29.50           O  
END
