
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  160 ( 1275),  selected  160 , name 1wwr_C
# Molecule2: number of CA atoms  162 ( 1272),  selected  162 , name T0461.pdb
# PARAMETERS: 1wwr_C.T0461.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    -9_C      E      16           -
LGA    G    -8_C      N      17           -
LGA    L    -7_C      L      18           -
LGA    V    -6_C      -       -           -
LGA    P    -5_C      -       -           -
LGA    R    -4_C      -       -           -
LGA    G    -3_C      -       -           -
LGA    S    -2_C      Y      19           #
LGA    -       -      F      20           -
LGA    H    -1_C      Q      21          3.500
LGA    M     1_C      S      22          5.329
LGA    -       -      M      23           -
LGA    -       -      E      24           -
LGA    G     2_C      E      25          2.494
LGA    K     3_C      T      26          2.051
LGA    E     4_C      E      27          1.859
LGA    Y     5_C      K      28          1.428
LGA    F     6_C      W      29          1.049
LGA    L     7_C      M      30          0.989
LGA    K     8_C      E      31          0.978
LGA    V     9_C      E      32          0.721
LGA    A    10_C      A      33          0.622
LGA    L    11_C      M      34          0.940
LGA    R    12_C      H      35          1.279
LGA    E    13_C      M      36          1.205
LGA    A    14_C      A      37          0.845
LGA    K    15_C      K      38          1.039
LGA    R    16_C      E      39          1.112
LGA    A    17_C      A      40          0.796
LGA    F    18_C      L      41          0.765
LGA    E    19_C      E      42          1.160
LGA    K    20_C      N      43          0.834
LGA    G    21_C      T      44          0.703
LGA    E    22_C      E      45          0.477
LGA    V    23_C      V      46          0.624
LGA    P    24_C      P      47          0.542
LGA    V    25_C      V      48          0.463
LGA    G    26_C      G      49          0.534
LGA    A    27_C      C      50          0.857
LGA    I    28_C      L      51          0.753
LGA    I    29_C      M      52          0.380
LGA    V    30_C      V      53          0.611
LGA    K    31_C      Y      54          0.905
LGA    E    32_C      N      55          2.166
LGA    G    33_C      N      56          2.437
LGA    E    34_C      E      57          1.706
LGA    I    35_C      V      58          1.185
LGA    I    36_C      V      59          0.908
LGA    S    37_C      G      60          1.099
LGA    K    38_C      K      61          0.785
LGA    A    39_C      G      62          0.732
LGA    H    40_C      R      63          0.199
LGA    N    41_C      N      64          0.344
LGA    S    42_C      E      65          0.320
LGA    V    43_C      V      66          0.253
LGA    E    44_C      N      67          0.291
LGA    E    45_C      Q      68          0.374
LGA    L    46_C      T      69          0.470
LGA    K    47_C      K      70          0.771
LGA    D    48_C      N      71          0.584
LGA    P    49_C      A      72          0.473
LGA    T    50_C      T      73          0.493
LGA    A    51_C      R      74          0.270
LGA    H    52_C      H      75          0.171
LGA    A    53_C      A      76          0.183
LGA    E    54_C      E      77          0.316
LGA    M    55_C      M      78          0.677
LGA    L    56_C      V      79          0.778
LGA    A    57_C      A      80          0.370
LGA    I    58_C      I      81          0.900
LGA    K    59_C      D      82          1.290
LGA    E    60_C      Q      83          0.814
LGA    A    61_C      V      84          0.557
LGA    C    62_C      L      85          1.582
LGA    R    63_C      D      86          1.656
LGA    R    64_C      W      87          0.430
LGA    L    65_C      C      88          1.735
LGA    N    66_C      R      89          3.121
LGA    -       -      Q      90           -
LGA    -       -      S      91           -
LGA    -       -      G      92           -
LGA    -       -      K      93           -
LGA    T    67_C      S      94          3.402
LGA    K    68_C      P      95          3.527
LGA    Y    69_C      S      96          2.816
LGA    -       -      E      97           -
LGA    -       -      V      98           -
LGA    L    70_C      F      99          0.828
LGA    E    71_C      E     100          1.411
LGA    G    72_C      H     101          0.246
LGA    C    73_C      T     102          0.243
LGA    E    74_C      V     103          0.737
LGA    L    75_C      L     104          0.549
LGA    Y    76_C      Y     105          0.649
LGA    V    77_C      V     106          0.584
LGA    T    78_C      T     107          0.205
LGA    L    79_C      V     108          0.169
LGA    E    80_C      E     109          0.269
LGA    P    81_C      P     110          0.357
LGA    C    82_C      C     111          0.378
LGA    I    83_C      I     112          0.499
LGA    M    84_C      M     113          0.437
LGA    C    85_C      C     114          0.297
LGA    S    86_C      A     115          0.293
LGA    Y    87_C      A     116          0.714
LGA    A    88_C      A     117          0.712
LGA    L    89_C      L     118          0.271
LGA    V    90_C      R     119          0.784
LGA    L    91_C      L     120          1.068
LGA    S    92_C      M     121          0.925
LGA    R    93_C      K     122          1.081
LGA    I    94_C      I     123          0.691
LGA    E    95_C      P     124          1.452
LGA    K    96_C      L     125          0.858
LGA    V    97_C      V     126          0.809
LGA    I    98_C      V     127          0.912
LGA    F    99_C      Y     128          0.714
LGA    S   100_C      G     129          0.548
LGA    A   101_C      C     130          0.644
LGA    L   102_C      Q     131          0.261
LGA    D   103_C      N     132          0.742
LGA    K   104_C      E     133          1.196
LGA    K   105_C      R     134          1.392
LGA    H   106_C      F     135          0.639
LGA    G   107_C      G     136          0.312
LGA    G   108_C      G     137          0.578
LGA    V   109_C      C     138          0.619
LGA    V   110_C      G     139          0.860
LGA    S   111_C      S     140          0.492
LGA    V   112_C      V     141          0.569
LGA    F   113_C      L     142          0.619
LGA    N   114_C      N     143          0.657
LGA    I   115_C      I     144          0.549
LGA    L   116_C      A     145          1.328
LGA    D   117_C      S     146          1.281
LGA    E   118_C      A     147          1.299
LGA    P   119_C      D     148          1.175
LGA    T   120_C      L     149          1.099
LGA    L   121_C      P     150          4.193
LGA    -       -      N     151           -
LGA    N   122_C      T     152          4.493
LGA    H   123_C      G     153          3.811
LGA    -       -      R     154           -
LGA    R   124_C      P     155          2.163
LGA    V   125_C      F     156          1.516
LGA    K   126_C      Q     157          1.533
LGA    W   127_C      C     158          1.443
LGA    E   128_C      I     159          1.496
LGA    Y   129_C      P     160          0.610
LGA    Y   130_C      G     161          3.006
LGA    P   131_C      Y     162          3.026
LGA    L   132_C      R     163          0.643
LGA    E   133_C      A     164          3.442
LGA    -       -      E     165           -
LGA    E   134_C      E     166          1.330
LGA    A   135_C      A     167          1.260
LGA    S   136_C      V     168          1.398
LGA    E   137_C      E     169          1.082
LGA    L   138_C      M     170          1.204
LGA    L   139_C      L     171          0.998
LGA    S   140_C      K     172          1.349
LGA    E   141_C      T     173          1.567
LGA    F   142_C      F     174          1.191
LGA    F   143_C      Y     175          1.622
LGA    K   144_C      K     176          2.906
LGA    K   145_C      -       -           -
LGA    L   146_C      Q     177          1.388
LGA    R   147_C      -       -           -
LGA    N   148_C      -       -           -
LGA    N   149_C      -       -           -
LGA    I   150_C      -       -           -
LGA    I   151_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  160  162    5.0    146    1.45    35.62     85.372     9.424

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.349385 * X  +   0.145026 * Y  +  -0.925688 * Z  +  40.661606
  Y_new =   0.878239 * X  +   0.293613 * Y  +   0.377476 * Z  + -18.716587
  Z_new =   0.326538 * X  +  -0.944859 * Y  +  -0.024783 * Z  +  60.330280 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.597020    1.544573  [ DEG:   -91.5025     88.4975 ]
  Theta =  -0.332639   -2.808954  [ DEG:   -19.0588   -160.9412 ]
  Phi   =   1.192167   -1.949426  [ DEG:    68.3061   -111.6939 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wwr_C                                        
REMARK     2: T0461.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wwr_C.T0461.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  160  162   5.0  146   1.45   35.62  85.372
REMARK  ---------------------------------------------------------- 
MOLECULE 1wwr_C
HEADER    HYDROLASE                               12-JAN-05   1WWR              
TITLE     CRYSTAL STRUCTURE OF TRNA ADENOSINE DEAMINASE TADA FROM               
TITLE    2 AQUIFEX AEOLICUS                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRNA ADENOSINE DEAMINASE TADA;                             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: HYPOTHETICAL PROTEIN AQ_903;                                
COMPND   5 EC: 3.5.4.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AQUIFEX AEOLICUS;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3) CODONPLUS;                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28                                     
KEYWDS    HOMODIMER, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   2 RSGI, STRUCTURAL GENOMICS                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.KURATANI,R.ISHII,Y.BESSHO,R.FUKUNAGA,T.SENGOKU,S.SEKINE,            
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   2   26-APR-05 1WWR    1       JRNL                                     
REVDAT   1   01-FEB-05 1WWR    0                                                
JRNL        AUTH   M.KURATANI,R.ISHII,Y.BESSHO,R.FUKUNAGA,T.SENGOKU,            
JRNL        AUTH 2 M.SHIROUZU,S.SEKINE,S.YOKOYAMA                               
JRNL        TITL   CRYSTAL STRUCTURE OF TRNA ADENOSINE DEAMINASE                
JRNL        TITL 2 (TADA) FROM AQUIFEX AEOLICUS                                 
JRNL        REF    J.BIOL.CHEM.                  V. 280 16002 2005              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1WWR A    1   151  UNP    O67050   TADA_AQUAE       1    151             
DBREF  1WWR B    1   151  UNP    O67050   TADA_AQUAE       1    151             
DBREF  1WWR C    1   151  UNP    O67050   TADA_AQUAE       1    151             
DBREF  1WWR D    1   151  UNP    O67050   TADA_AQUAE       1    151             
SEQRES   1 A  171  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  171  LEU VAL PRO ARG GLY SER HIS MET GLY LYS GLU TYR PHE          
SEQRES   3 A  171  LEU LYS VAL ALA LEU ARG GLU ALA LYS ARG ALA PHE GLU          
SEQRES   4 A  171  LYS GLY GLU VAL PRO VAL GLY ALA ILE ILE VAL LYS GLU          
SEQRES   5 A  171  GLY GLU ILE ILE SER LYS ALA HIS ASN SER VAL GLU GLU          
SEQRES   6 A  171  LEU LYS ASP PRO THR ALA HIS ALA GLU MET LEU ALA ILE          
SEQRES   7 A  171  LYS GLU ALA CYS ARG ARG LEU ASN THR LYS TYR LEU GLU          
SEQRES   8 A  171  GLY CYS GLU LEU TYR VAL THR LEU GLU PRO CYS ILE MET          
SEQRES   9 A  171  CYS SER TYR ALA LEU VAL LEU SER ARG ILE GLU LYS VAL          
SEQRES  10 A  171  ILE PHE SER ALA LEU ASP LYS LYS HIS GLY GLY VAL VAL          
SEQRES  11 A  171  SER VAL PHE ASN ILE LEU ASP GLU PRO THR LEU ASN HIS          
SEQRES  12 A  171  ARG VAL LYS TRP GLU TYR TYR PRO LEU GLU GLU ALA SER          
SEQRES  13 A  171  GLU LEU LEU SER GLU PHE PHE LYS LYS LEU ARG ASN ASN          
SEQRES  14 A  171  ILE ILE                                                      
SEQRES   1 B  171  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 B  171  LEU VAL PRO ARG GLY SER HIS MET GLY LYS GLU TYR PHE          
SEQRES   3 B  171  LEU LYS VAL ALA LEU ARG GLU ALA LYS ARG ALA PHE GLU          
SEQRES   4 B  171  LYS GLY GLU VAL PRO VAL GLY ALA ILE ILE VAL LYS GLU          
SEQRES   5 B  171  GLY GLU ILE ILE SER LYS ALA HIS ASN SER VAL GLU GLU          
SEQRES   6 B  171  LEU LYS ASP PRO THR ALA HIS ALA GLU MET LEU ALA ILE          
SEQRES   7 B  171  LYS GLU ALA CYS ARG ARG LEU ASN THR LYS TYR LEU GLU          
SEQRES   8 B  171  GLY CYS GLU LEU TYR VAL THR LEU GLU PRO CYS ILE MET          
SEQRES   9 B  171  CYS SER TYR ALA LEU VAL LEU SER ARG ILE GLU LYS VAL          
SEQRES  10 B  171  ILE PHE SER ALA LEU ASP LYS LYS HIS GLY GLY VAL VAL          
SEQRES  11 B  171  SER VAL PHE ASN ILE LEU ASP GLU PRO THR LEU ASN HIS          
SEQRES  12 B  171  ARG VAL LYS TRP GLU TYR TYR PRO LEU GLU GLU ALA SER          
SEQRES  13 B  171  GLU LEU LEU SER GLU PHE PHE LYS LYS LEU ARG ASN ASN          
SEQRES  14 B  171  ILE ILE                                                      
SEQRES   1 C  171  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 C  171  LEU VAL PRO ARG GLY SER HIS MET GLY LYS GLU TYR PHE          
SEQRES   3 C  171  LEU LYS VAL ALA LEU ARG GLU ALA LYS ARG ALA PHE GLU          
SEQRES   4 C  171  LYS GLY GLU VAL PRO VAL GLY ALA ILE ILE VAL LYS GLU          
SEQRES   5 C  171  GLY GLU ILE ILE SER LYS ALA HIS ASN SER VAL GLU GLU          
SEQRES   6 C  171  LEU LYS ASP PRO THR ALA HIS ALA GLU MET LEU ALA ILE          
SEQRES   7 C  171  LYS GLU ALA CYS ARG ARG LEU ASN THR LYS TYR LEU GLU          
SEQRES   8 C  171  GLY CYS GLU LEU TYR VAL THR LEU GLU PRO CYS ILE MET          
SEQRES   9 C  171  CYS SER TYR ALA LEU VAL LEU SER ARG ILE GLU LYS VAL          
SEQRES  10 C  171  ILE PHE SER ALA LEU ASP LYS LYS HIS GLY GLY VAL VAL          
SEQRES  11 C  171  SER VAL PHE ASN ILE LEU ASP GLU PRO THR LEU ASN HIS          
SEQRES  12 C  171  ARG VAL LYS TRP GLU TYR TYR PRO LEU GLU GLU ALA SER          
SEQRES  13 C  171  GLU LEU LEU SER GLU PHE PHE LYS LYS LEU ARG ASN ASN          
SEQRES  14 C  171  ILE ILE                                                      
SEQRES   1 D  171  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 D  171  LEU VAL PRO ARG GLY SER HIS MET GLY LYS GLU TYR PHE          
SEQRES   3 D  171  LEU LYS VAL ALA LEU ARG GLU ALA LYS ARG ALA PHE GLU          
SEQRES   4 D  171  LYS GLY GLU VAL PRO VAL GLY ALA ILE ILE VAL LYS GLU          
SEQRES   5 D  171  GLY GLU ILE ILE SER LYS ALA HIS ASN SER VAL GLU GLU          
SEQRES   6 D  171  LEU LYS ASP PRO THR ALA HIS ALA GLU MET LEU ALA ILE          
SEQRES   7 D  171  LYS GLU ALA CYS ARG ARG LEU ASN THR LYS TYR LEU GLU          
SEQRES   8 D  171  GLY CYS GLU LEU TYR VAL THR LEU GLU PRO CYS ILE MET          
SEQRES   9 D  171  CYS SER TYR ALA LEU VAL LEU SER ARG ILE GLU LYS VAL          
SEQRES  10 D  171  ILE PHE SER ALA LEU ASP LYS LYS HIS GLY GLY VAL VAL          
SEQRES  11 D  171  SER VAL PHE ASN ILE LEU ASP GLU PRO THR LEU ASN HIS          
SEQRES  12 D  171  ARG VAL LYS TRP GLU TYR TYR PRO LEU GLU GLU ALA SER          
SEQRES  13 D  171  GLU LEU LEU SER GLU PHE PHE LYS LYS LEU ARG ASN ASN          
SEQRES  14 D  171  ILE ILE                                                      
HET     ZN  A 201       1                                                       
HET     ZN  B 202       1                                                       
HET     ZN  C 203       1                                                       
HET     ZN  D 204       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   5   ZN    4(ZN 2+)                                                     
FORMUL   9  HOH   *520(H2 O)                                                    
CRYST1   43.176  151.953   54.133  90.00 113.42  90.00 P 1 21 1      8          
ATOM   2487  N   SER C  -9      18.653  18.616  67.863  1.00 49.08           N  
ATOM   2488  CA  SER C  -9      17.706  18.806  66.724  1.00 46.80           C  
ATOM   2489  C   SER C  -9      17.639  20.266  66.295  1.00 45.90           C  
ATOM   2490  O   SER C  -9      18.474  20.733  65.515  1.00 46.07           O  
ATOM   2491  CB  SER C  -9      16.302  18.330  67.112  1.00 48.63           C  
ATOM   2492  OG  SER C  -9      15.384  18.520  66.045  1.00 48.77           O  
ATOM   2493  N   GLY C  -8      16.640  20.976  66.820  1.00 41.21           N  
ATOM   2494  CA  GLY C  -8      16.449  22.375  66.493  1.00 35.32           C  
ATOM   2495  C   GLY C  -8      17.568  23.295  66.935  1.00 31.35           C  
ATOM   2496  O   GLY C  -8      17.330  24.339  67.538  1.00 28.20           O  
ATOM   2497  N   LEU C  -7      18.800  22.914  66.623  1.00 27.25           N  
ATOM   2498  CA  LEU C  -7      19.943  23.725  66.994  1.00 23.53           C  
ATOM   2499  C   LEU C  -7      20.256  24.731  65.889  1.00 21.88           C  
ATOM   2500  O   LEU C  -7      20.940  25.722  66.129  1.00 22.37           O  
ATOM   2501  CB  LEU C  -7      21.160  22.831  67.238  1.00 24.24           C  
ATOM   2502  CG  LEU C  -7      20.995  21.691  68.251  1.00 22.91           C  
ATOM   2503  CD1 LEU C  -7      22.318  20.949  68.362  1.00 21.93           C  
ATOM   2504  CD2 LEU C  -7      20.580  22.229  69.604  1.00 26.20           C  
ATOM   2505  N   VAL C  -6      19.724  24.492  64.691  1.00 19.83           N  
ATOM   2506  CA  VAL C  -6      19.997  25.374  63.562  1.00 20.28           C  
ATOM   2507  C   VAL C  -6      18.755  25.895  62.842  1.00 21.75           C  
ATOM   2508  O   VAL C  -6      17.667  25.322  62.962  1.00 21.81           O  
ATOM   2509  CB  VAL C  -6      20.884  24.651  62.526  1.00 21.55           C  
ATOM   2510  CG1 VAL C  -6      22.215  24.238  63.171  1.00 21.91           C  
ATOM   2511  CG2 VAL C  -6      20.148  23.433  61.995  1.00 22.76           C  
ATOM   2512  N   PRO C  -5      18.909  26.990  62.079  1.00 22.38           N  
ATOM   2513  CA  PRO C  -5      17.822  27.618  61.319  1.00 20.75           C  
ATOM   2514  C   PRO C  -5      17.260  26.667  60.276  1.00 24.74           C  
ATOM   2515  O   PRO C  -5      17.976  25.825  59.735  1.00 18.93           O  
ATOM   2516  CB  PRO C  -5      18.499  28.819  60.668  1.00 23.11           C  
ATOM   2517  CG  PRO C  -5      19.606  29.143  61.612  1.00 22.96           C  
ATOM   2518  CD  PRO C  -5      20.142  27.786  61.959  1.00 21.46           C  
ATOM   2519  N   ARG C  -4      15.977  26.817  59.991  1.00 21.14           N  
ATOM   2520  CA  ARG C  -4      15.305  25.975  59.021  1.00 23.61           C  
ATOM   2521  C   ARG C  -4      14.088  26.742  58.518  1.00 22.30           C  
ATOM   2522  O   ARG C  -4      13.579  27.622  59.209  1.00 19.92           O  
ATOM   2523  CB  ARG C  -4      14.865  24.676  59.695  1.00 25.41           C  
ATOM   2524  CG  ARG C  -4      14.176  23.682  58.784  1.00 32.68           C  
ATOM   2525  CD  ARG C  -4      13.807  22.422  59.564  1.00 36.50           C  
ATOM   2526  NE  ARG C  -4      12.956  21.535  58.784  1.00 37.75           N  
ATOM   2527  CZ  ARG C  -4      12.262  20.527  59.298  1.00 40.32           C  
ATOM   2528  NH1 ARG C  -4      12.320  20.275  60.600  1.00 39.30           N  
ATOM   2529  NH2 ARG C  -4      11.493  19.786  58.513  1.00 44.18           N  
ATOM   2530  N   GLY C  -3      13.635  26.406  57.314  1.00 21.08           N  
ATOM   2531  CA  GLY C  -3      12.477  27.072  56.748  1.00 20.23           C  
ATOM   2532  C   GLY C  -3      11.745  26.159  55.793  1.00 20.25           C  
ATOM   2533  O   GLY C  -3      12.291  25.131  55.361  1.00 17.91           O  
ATOM   2534  N   SER C  -2      10.504  26.518  55.476  1.00 15.61           N  
ATOM   2535  CA  SER C  -2       9.703  25.730  54.556  1.00 15.86           C  
ATOM   2536  C   SER C  -2      10.348  25.789  53.172  1.00 18.98           C  
ATOM   2537  O   SER C  -2      11.038  26.751  52.832  1.00 16.39           O  
ATOM   2538  CB  SER C  -2       8.263  26.274  54.495  1.00 15.59           C  
ATOM   2539  OG  SER C  -2       8.228  27.659  54.178  1.00 17.58           O  
ATOM   2540  N   HIS C  -1      10.137  24.746  52.380  1.00 19.67           N  
ATOM   2541  CA  HIS C  -1      10.684  24.703  51.029  1.00 21.65           C  
ATOM   2542  C   HIS C  -1       9.881  25.642  50.142  1.00 20.41           C  
ATOM   2543  O   HIS C  -1       8.695  25.872  50.399  1.00 19.44           O  
ATOM   2544  CB  HIS C  -1      10.587  23.285  50.477  1.00 21.97           C  
ATOM   2545  CG  HIS C  -1      11.347  22.272  51.275  1.00 23.66           C  
ATOM   2546  ND1 HIS C  -1      11.078  20.922  51.209  1.00 26.56           N  
ATOM   2547  CD2 HIS C  -1      12.378  22.409  52.144  1.00 24.84           C  
ATOM   2548  CE1 HIS C  -1      11.908  20.271  52.006  1.00 22.83           C  
ATOM   2549  NE2 HIS C  -1      12.707  21.149  52.583  1.00 25.86           N  
ATOM   2550  N   MET C   1      10.522  26.179  49.103  1.00 18.16           N  
ATOM   2551  CA  MET C   1       9.841  27.073  48.176  1.00 20.40           C  
ATOM   2552  C   MET C   1       8.681  26.288  47.581  1.00 19.42           C  
ATOM   2553  O   MET C   1       8.676  25.056  47.624  1.00 21.47           O  
ATOM   2554  CB  MET C   1      10.787  27.543  47.070  1.00 23.18           C  
ATOM   2555  CG  MET C   1      12.012  28.289  47.569  1.00 27.55           C  
ATOM   2556  SD  MET C   1      11.617  29.702  48.647  1.00 34.33           S  
ATOM   2557  CE  MET C   1      11.000  30.869  47.459  1.00 28.72           C  
ATOM   2558  N   GLY C   2       7.696  26.997  47.043  1.00 21.37           N  
ATOM   2559  CA  GLY C   2       6.532  26.328  46.490  1.00 20.39           C  
ATOM   2560  C   GLY C   2       6.672  25.836  45.066  1.00 17.48           C  
ATOM   2561  O   GLY C   2       7.631  26.167  44.379  1.00 16.01           O  
ATOM   2562  N   LYS C   3       5.705  25.037  44.630  1.00 17.73           N  
ATOM   2563  CA  LYS C   3       5.716  24.487  43.278  1.00 18.94           C  
ATOM   2564  C   LYS C   3       5.752  25.587  42.213  1.00 19.68           C  
ATOM   2565  O   LYS C   3       6.475  25.476  41.219  1.00 16.09           O  
ATOM   2566  CB  LYS C   3       4.492  23.591  43.066  1.00 18.46           C  
ATOM   2567  CG  LYS C   3       4.397  22.434  44.049  1.00 20.53           C  
ATOM   2568  CD  LYS C   3       3.060  21.717  43.924  1.00 22.16           C  
ATOM   2569  CE  LYS C   3       2.836  20.776  45.097  1.00 26.90           C  
ATOM   2570  NZ  LYS C   3       4.018  19.918  45.301  1.00 31.75           N  
ATOM   2571  N   GLU C   4       4.983  26.653  42.413  1.00 17.87           N  
ATOM   2572  CA  GLU C   4       4.978  27.727  41.431  1.00 18.75           C  
ATOM   2573  C   GLU C   4       6.367  28.357  41.337  1.00 18.22           C  
ATOM   2574  O   GLU C   4       6.856  28.645  40.238  1.00 16.12           O  
ATOM   2575  CB  GLU C   4       3.935  28.784  41.794  1.00 21.56           C  
ATOM   2576  CG  GLU C   4       3.832  29.902  40.780  1.00 29.16           C  
ATOM   2577  CD  GLU C   4       2.717  30.877  41.101  1.00 33.14           C  
ATOM   2578  OE1 GLU C   4       2.547  31.845  40.340  1.00 40.28           O  
ATOM   2579  OE2 GLU C   4       2.012  30.675  42.112  1.00 37.68           O  
ATOM   2580  N   TYR C   5       7.013  28.554  42.483  1.00 16.77           N  
ATOM   2581  CA  TYR C   5       8.356  29.128  42.488  1.00 17.63           C  
ATOM   2582  C   TYR C   5       9.345  28.253  41.694  1.00 18.18           C  
ATOM   2583  O   TYR C   5      10.097  28.755  40.861  1.00 17.24           O  
ATOM   2584  CB  TYR C   5       8.867  29.300  43.924  1.00 17.51           C  
ATOM   2585  CG  TYR C   5      10.307  29.761  43.993  1.00 20.55           C  
ATOM   2586  CD1 TYR C   5      11.361  28.844  43.933  1.00 22.55           C  
ATOM   2587  CD2 TYR C   5      10.619  31.117  44.079  1.00 24.89           C  
ATOM   2588  CE1 TYR C   5      12.693  29.272  43.954  1.00 24.31           C  
ATOM   2589  CE2 TYR C   5      11.944  31.552  44.100  1.00 27.42           C  
ATOM   2590  CZ  TYR C   5      12.974  30.626  44.035  1.00 27.19           C  
ATOM   2591  OH  TYR C   5      14.278  31.063  44.030  1.00 31.99           O  
ATOM   2592  N   PHE C   6       9.346  26.949  41.944  1.00 15.69           N  
ATOM   2593  CA  PHE C   6      10.278  26.082  41.224  1.00 16.51           C  
ATOM   2594  C   PHE C   6       9.936  25.977  39.736  1.00 15.48           C  
ATOM   2595  O   PHE C   6      10.836  25.865  38.892  1.00 15.53           O  
ATOM   2596  CB  PHE C   6      10.336  24.692  41.876  1.00 15.71           C  
ATOM   2597  CG  PHE C   6      11.106  24.666  43.182  1.00 15.75           C  
ATOM   2598  CD1 PHE C   6      12.359  25.258  43.273  1.00 15.24           C  
ATOM   2599  CD2 PHE C   6      10.589  24.029  44.308  1.00 16.95           C  
ATOM   2600  CE1 PHE C   6      13.092  25.220  44.459  1.00 16.94           C  
ATOM   2601  CE2 PHE C   6      11.316  23.985  45.501  1.00 16.41           C  
ATOM   2602  CZ  PHE C   6      12.569  24.582  45.570  1.00 16.32           C  
ATOM   2603  N   LEU C   7       8.648  26.036  39.408  1.00 12.89           N  
ATOM   2604  CA  LEU C   7       8.249  25.974  38.009  1.00 13.26           C  
ATOM   2605  C   LEU C   7       8.701  27.241  37.298  1.00 14.34           C  
ATOM   2606  O   LEU C   7       8.996  27.227  36.098  1.00 14.39           O  
ATOM   2607  CB  LEU C   7       6.723  25.786  37.882  1.00 14.42           C  
ATOM   2608  CG  LEU C   7       6.270  24.350  38.190  1.00 13.12           C  
ATOM   2609  CD1 LEU C   7       4.758  24.283  38.412  1.00 11.49           C  
ATOM   2610  CD2 LEU C   7       6.708  23.433  37.030  1.00 14.20           C  
ATOM   2611  N   LYS C   8       8.762  28.345  38.032  1.00 14.09           N  
ATOM   2612  CA  LYS C   8       9.199  29.600  37.430  1.00 18.58           C  
ATOM   2613  C   LYS C   8      10.711  29.593  37.190  1.00 16.65           C  
ATOM   2614  O   LYS C   8      11.185  30.206  36.245  1.00 19.57           O  
ATOM   2615  CB  LYS C   8       8.778  30.784  38.301  1.00 22.15           C  
ATOM   2616  CG  LYS C   8       7.286  31.096  38.164  1.00 27.21           C  
ATOM   2617  CD  LYS C   8       6.853  32.271  39.026  1.00 31.40           C  
ATOM   2618  CE  LYS C   8       5.354  32.490  38.896  1.00 35.74           C  
ATOM   2619  NZ  LYS C   8       4.957  32.611  37.466  1.00 39.72           N  
ATOM   2620  N   VAL C   9      11.465  28.904  38.045  1.00 15.83           N  
ATOM   2621  CA  VAL C   9      12.905  28.824  37.832  1.00 14.91           C  
ATOM   2622  C   VAL C   9      13.065  28.004  36.548  1.00 14.67           C  
ATOM   2623  O   VAL C   9      13.892  28.310  35.681  1.00 14.37           O  
ATOM   2624  CB  VAL C   9      13.626  28.097  38.994  1.00 15.21           C  
ATOM   2625  CG1 VAL C   9      15.120  28.021  38.710  1.00 15.62           C  
ATOM   2626  CG2 VAL C   9      13.389  28.839  40.306  1.00 18.46           C  
ATOM   2627  N   ALA C  10      12.262  26.957  36.431  1.00 13.34           N  
ATOM   2628  CA  ALA C  10      12.308  26.102  35.243  1.00 14.67           C  
ATOM   2629  C   ALA C  10      11.949  26.903  33.999  1.00 14.17           C  
ATOM   2630  O   ALA C  10      12.523  26.694  32.933  1.00 13.78           O  
ATOM   2631  CB  ALA C  10      11.351  24.917  35.403  1.00 12.68           C  
ATOM   2632  N   LEU C  11      10.991  27.822  34.124  1.00 14.51           N  
ATOM   2633  CA  LEU C  11      10.592  28.638  32.977  1.00 15.77           C  
ATOM   2634  C   LEU C  11      11.747  29.526  32.500  1.00 16.20           C  
ATOM   2635  O   LEU C  11      11.845  29.839  31.318  1.00 16.88           O  
ATOM   2636  CB  LEU C  11       9.381  29.511  33.333  1.00 17.08           C  
ATOM   2637  CG  LEU C  11       7.978  29.013  32.977  1.00 23.84           C  
ATOM   2638  CD1 LEU C  11       7.898  28.829  31.457  1.00 26.85           C  
ATOM   2639  CD2 LEU C  11       7.652  27.719  33.697  1.00 31.01           C  
ATOM   2640  N   ARG C  12      12.604  29.941  33.424  1.00 15.87           N  
ATOM   2641  CA  ARG C  12      13.756  30.765  33.067  1.00 18.87           C  
ATOM   2642  C   ARG C  12      14.680  29.961  32.161  1.00 17.99           C  
ATOM   2643  O   ARG C  12      15.237  30.494  31.194  1.00 16.60           O  
ATOM   2644  CB  ARG C  12      14.518  31.220  34.318  1.00 22.23           C  
ATOM   2645  CG  ARG C  12      13.792  32.283  35.145  1.00 30.08           C  
ATOM   2646  CD  ARG C  12      13.301  33.426  34.264  1.00 36.04           C  
ATOM   2647  NE  ARG C  12      14.391  34.049  33.510  1.00 45.87           N  
ATOM   2648  CZ  ARG C  12      14.213  34.882  32.490  1.00 46.83           C  
ATOM   2649  NH1 ARG C  12      12.985  35.195  32.098  1.00 47.77           N  
ATOM   2650  NH2 ARG C  12      15.263  35.402  31.862  1.00 47.31           N  
ATOM   2651  N   GLU C  13      14.850  28.678  32.483  1.00 20.04           N  
ATOM   2652  CA  GLU C  13      15.674  27.789  31.663  1.00 15.48           C  
ATOM   2653  C   GLU C  13      15.006  27.632  30.295  1.00 15.87           C  
ATOM   2654  O   GLU C  13      15.681  27.587  29.260  1.00 14.82           O  
ATOM   2655  CB  GLU C  13      15.803  26.408  32.316  1.00 17.19           C  
ATOM   2656  CG  GLU C  13      16.828  26.312  33.441  1.00 17.76           C  
ATOM   2657  CD  GLU C  13      18.246  26.525  32.935  1.00 23.46           C  
ATOM   2658  OE1 GLU C  13      18.657  25.823  31.987  1.00 21.51           O  
ATOM   2659  OE2 GLU C  13      18.947  27.399  33.484  1.00 25.21           O  
ATOM   2660  N   ALA C  14      13.674  27.554  30.287  1.00 14.34           N  
ATOM   2661  CA  ALA C  14      12.943  27.407  29.030  1.00 11.07           C  
ATOM   2662  C   ALA C  14      13.126  28.638  28.154  1.00 14.40           C  
ATOM   2663  O   ALA C  14      13.188  28.528  26.933  1.00 14.67           O  
ATOM   2664  CB  ALA C  14      11.452  27.175  29.288  1.00 10.73           C  
ATOM   2665  N   LYS C  15      13.173  29.814  28.771  1.00 15.61           N  
ATOM   2666  CA  LYS C  15      13.358  31.031  27.985  1.00 18.67           C  
ATOM   2667  C   LYS C  15      14.755  31.073  27.371  1.00 16.11           C  
ATOM   2668  O   LYS C  15      14.929  31.563  26.256  1.00 16.91           O  
ATOM   2669  CB  LYS C  15      13.107  32.281  28.838  1.00 20.01           C  
ATOM   2670  CG  LYS C  15      11.632  32.513  29.116  1.00 27.47           C  
ATOM   2671  CD  LYS C  15      11.392  33.826  29.842  1.00 32.89           C  
ATOM   2672  CE  LYS C  15       9.905  34.049  30.058  1.00 37.54           C  
ATOM   2673  NZ  LYS C  15       9.173  34.077  28.759  1.00 41.27           N  
ATOM   2674  N   ARG C  16      15.744  30.561  28.094  1.00 15.96           N  
ATOM   2675  CA  ARG C  16      17.100  30.523  27.574  1.00 15.59           C  
ATOM   2676  C   ARG C  16      17.085  29.628  26.346  1.00 16.14           C  
ATOM   2677  O   ARG C  16      17.653  29.957  25.306  1.00 16.02           O  
ATOM   2678  CB  ARG C  16      18.061  29.960  28.623  1.00 14.96           C  
ATOM   2679  CG  ARG C  16      19.454  29.653  28.097  1.00 14.87           C  
ATOM   2680  CD  ARG C  16      20.179  30.903  27.629  1.00 14.18           C  
ATOM   2681  NE  ARG C  16      21.578  30.607  27.338  1.00 15.80           N  
ATOM   2682  CZ  ARG C  16      22.446  31.499  26.879  1.00 16.32           C  
ATOM   2683  NH1 ARG C  16      22.057  32.755  26.655  1.00 18.24           N  
ATOM   2684  NH2 ARG C  16      23.695  31.135  26.632  1.00 12.83           N  
ATOM   2685  N   ALA C  17      16.412  28.489  26.460  1.00 16.70           N  
ATOM   2686  CA  ALA C  17      16.320  27.570  25.336  1.00 14.99           C  
ATOM   2687  C   ALA C  17      15.660  28.279  24.151  1.00 14.12           C  
ATOM   2688  O   ALA C  17      16.073  28.105  23.001  1.00 16.80           O  
ATOM   2689  CB  ALA C  17      15.502  26.323  25.732  1.00 12.77           C  
ATOM   2690  N   PHE C  18      14.629  29.065  24.436  1.00 14.52           N  
ATOM   2691  CA  PHE C  18      13.917  29.791  23.386  1.00 16.94           C  
ATOM   2692  C   PHE C  18      14.904  30.693  22.646  1.00 18.57           C  
ATOM   2693  O   PHE C  18      14.939  30.729  21.411  1.00 17.18           O  
ATOM   2694  CB  PHE C  18      12.806  30.654  23.997  1.00 17.78           C  
ATOM   2695  CG  PHE C  18      11.930  31.336  22.976  1.00 22.58           C  
ATOM   2696  CD1 PHE C  18      10.683  30.817  22.657  1.00 23.95           C  
ATOM   2697  CD2 PHE C  18      12.357  32.497  22.334  1.00 24.08           C  
ATOM   2698  CE1 PHE C  18       9.867  31.441  21.713  1.00 26.31           C  
ATOM   2699  CE2 PHE C  18      11.555  33.128  21.393  1.00 25.66           C  
ATOM   2700  CZ  PHE C  18      10.304  32.600  21.080  1.00 25.47           C  
ATOM   2701  N   GLU C  19      15.707  31.408  23.429  1.00 19.43           N  
ATOM   2702  CA  GLU C  19      16.694  32.341  22.910  1.00 23.62           C  
ATOM   2703  C   GLU C  19      17.797  31.651  22.117  1.00 23.19           C  
ATOM   2704  O   GLU C  19      18.355  32.228  21.183  1.00 22.84           O  
ATOM   2705  CB  GLU C  19      17.300  33.141  24.069  1.00 26.91           C  
ATOM   2706  CG  GLU C  19      16.266  33.927  24.872  1.00 34.53           C  
ATOM   2707  CD  GLU C  19      16.794  34.411  26.217  1.00 42.64           C  
ATOM   2708  OE1 GLU C  19      17.281  33.574  27.014  1.00 45.70           O  
ATOM   2709  OE2 GLU C  19      16.711  35.629  26.485  1.00 46.54           O  
ATOM   2710  N   LYS C  20      18.105  30.411  22.472  1.00 23.70           N  
ATOM   2711  CA  LYS C  20      19.152  29.680  21.765  1.00 23.69           C  
ATOM   2712  C   LYS C  20      18.629  28.907  20.561  1.00 23.16           C  
ATOM   2713  O   LYS C  20      19.356  28.104  19.975  1.00 23.77           O  
ATOM   2714  CB  LYS C  20      19.890  28.734  22.719  1.00 22.84           C  
ATOM   2715  CG  LYS C  20      20.733  29.456  23.765  1.00 30.37           C  
ATOM   2716  CD  LYS C  20      21.493  28.484  24.665  1.00 36.29           C  
ATOM   2717  CE  LYS C  20      22.620  27.762  23.928  1.00 38.55           C  
ATOM   2718  NZ  LYS C  20      23.719  28.688  23.543  1.00 42.72           N  
ATOM   2719  N   GLY C  21      17.369  29.153  20.197  1.00 20.77           N  
ATOM   2720  CA  GLY C  21      16.775  28.493  19.051  1.00 19.12           C  
ATOM   2721  C   GLY C  21      16.323  27.062  19.284  1.00 21.73           C  
ATOM   2722  O   GLY C  21      16.142  26.299  18.328  1.00 21.84           O  
ATOM   2723  N   GLU C  22      16.135  26.701  20.550  1.00 17.68           N  
ATOM   2724  CA  GLU C  22      15.707  25.349  20.926  1.00 17.73           C  
ATOM   2725  C   GLU C  22      14.220  25.310  21.264  1.00 18.77           C  
ATOM   2726  O   GLU C  22      13.594  26.349  21.477  1.00 19.64           O  
ATOM   2727  CB  GLU C  22      16.446  24.883  22.190  1.00 17.40           C  
ATOM   2728  CG  GLU C  22      17.970  25.055  22.208  1.00 16.91           C  
ATOM   2729  CD  GLU C  22      18.716  23.936  21.476  1.00 17.54           C  
ATOM   2730  OE1 GLU C  22      18.057  23.016  20.943  1.00 18.17           O  
ATOM   2731  OE2 GLU C  22      19.971  23.984  21.448  1.00 17.67           O  
ATOM   2732  N   VAL C  23      13.663  24.104  21.322  1.00 16.20           N  
ATOM   2733  CA  VAL C  23      12.276  23.936  21.744  1.00 17.40           C  
ATOM   2734  C   VAL C  23      12.370  24.489  23.175  1.00 16.77           C  
ATOM   2735  O   VAL C  23      13.256  24.095  23.951  1.00 18.75           O  
ATOM   2736  CB  VAL C  23      11.884  22.452  21.757  1.00 19.91           C  
ATOM   2737  CG1 VAL C  23      10.465  22.282  22.335  1.00 15.56           C  
ATOM   2738  CG2 VAL C  23      11.965  21.900  20.322  1.00 19.89           C  
ATOM   2739  N   PRO C  24      11.472  25.411  23.549  1.00 14.19           N  
ATOM   2740  CA  PRO C  24      11.530  26.001  24.894  1.00 15.31           C  
ATOM   2741  C   PRO C  24      11.017  25.219  26.097  1.00 15.13           C  
ATOM   2742  O   PRO C  24       9.918  25.464  26.590  1.00 14.97           O  
ATOM   2743  CB  PRO C  24      10.793  27.323  24.703  1.00 14.36           C  
ATOM   2744  CG  PRO C  24       9.706  26.929  23.742  1.00 17.38           C  
ATOM   2745  CD  PRO C  24      10.415  26.043  22.741  1.00 14.24           C  
ATOM   2746  N   VAL C  25      11.847  24.308  26.593  1.00 14.22           N  
ATOM   2747  CA  VAL C  25      11.508  23.495  27.743  1.00 14.75           C  
ATOM   2748  C   VAL C  25      12.660  23.568  28.729  1.00 13.22           C  
ATOM   2749  O   VAL C  25      13.821  23.457  28.351  1.00 13.28           O  
ATOM   2750  CB  VAL C  25      11.281  22.021  27.357  1.00 14.26           C  
ATOM   2751  CG1 VAL C  25      10.926  21.212  28.610  1.00 13.03           C  
ATOM   2752  CG2 VAL C  25      10.160  21.916  26.319  1.00 17.48           C  
ATOM   2753  N   GLY C  26      12.329  23.805  29.989  1.00 12.19           N  
ATOM   2754  CA  GLY C  26      13.345  23.890  31.018  1.00 12.95           C  
ATOM   2755  C   GLY C  26      12.982  22.914  32.113  1.00 12.22           C  
ATOM   2756  O   GLY C  26      11.807  22.575  32.265  1.00 12.04           O  
ATOM   2757  N   ALA C  27      13.968  22.467  32.878  1.00 12.33           N  
ATOM   2758  CA  ALA C  27      13.710  21.513  33.958  1.00 13.72           C  
ATOM   2759  C   ALA C  27      14.734  21.694  35.070  1.00 13.05           C  
ATOM   2760  O   ALA C  27      15.874  22.082  34.810  1.00 13.06           O  
ATOM   2761  CB  ALA C  27      13.795  20.075  33.418  1.00 11.49           C  
ATOM   2762  N   ILE C  28      14.325  21.428  36.309  1.00 12.31           N  
ATOM   2763  CA  ILE C  28      15.244  21.508  37.433  1.00 12.65           C  
ATOM   2764  C   ILE C  28      14.950  20.333  38.354  1.00 12.85           C  
ATOM   2765  O   ILE C  28      13.839  19.798  38.352  1.00 13.69           O  
ATOM   2766  CB  ILE C  28      15.108  22.827  38.245  1.00 12.53           C  
ATOM   2767  CG1 ILE C  28      13.791  22.826  39.039  1.00 15.77           C  
ATOM   2768  CG2 ILE C  28      15.161  24.038  37.292  1.00 14.54           C  
ATOM   2769  CD1 ILE C  28      13.668  23.965  40.041  1.00 13.11           C  
ATOM   2770  N   ILE C  29      15.953  19.921  39.121  1.00 11.70           N  
ATOM   2771  CA  ILE C  29      15.794  18.829  40.071  1.00 13.38           C  
ATOM   2772  C   ILE C  29      16.062  19.396  41.458  1.00 15.16           C  
ATOM   2773  O   ILE C  29      17.066  20.077  41.681  1.00 14.32           O  
ATOM   2774  CB  ILE C  29      16.753  17.666  39.763  1.00 12.79           C  
ATOM   2775  CG1 ILE C  29      16.347  17.032  38.430  1.00 15.95           C  
ATOM   2776  CG2 ILE C  29      16.705  16.640  40.903  1.00 14.05           C  
ATOM   2777  CD1 ILE C  29      17.048  15.726  38.113  1.00 18.92           C  
ATOM   2778  N   VAL C  30      15.137  19.128  42.370  1.00 13.03           N  
ATOM   2779  CA  VAL C  30      15.204  19.652  43.724  1.00 13.87           C  
ATOM   2780  C   VAL C  30      15.232  18.523  44.739  1.00 15.07           C  
ATOM   2781  O   VAL C  30      14.505  17.541  44.604  1.00 15.58           O  
ATOM   2782  CB  VAL C  30      13.964  20.551  43.993  1.00 13.28           C  
ATOM   2783  CG1 VAL C  30      13.928  20.993  45.461  1.00 15.58           C  
ATOM   2784  CG2 VAL C  30      13.989  21.747  43.056  1.00 16.21           C  
ATOM   2785  N   LYS C  31      16.091  18.657  45.744  1.00 14.00           N  
ATOM   2786  CA  LYS C  31      16.174  17.650  46.793  1.00 17.08           C  
ATOM   2787  C   LYS C  31      16.115  18.393  48.124  1.00 19.23           C  
ATOM   2788  O   LYS C  31      16.960  19.238  48.405  1.00 18.80           O  
ATOM   2789  CB  LYS C  31      17.476  16.847  46.702  1.00 16.91           C  
ATOM   2790  CG  LYS C  31      17.529  15.693  47.719  1.00 20.93           C  
ATOM   2791  CD  LYS C  31      18.794  14.858  47.599  1.00 21.20           C  
ATOM   2792  CE  LYS C  31      18.772  13.703  48.589  1.00 26.70           C  
ATOM   2793  NZ  LYS C  31      20.026  12.901  48.531  1.00 33.59           N  
ATOM   2794  N   GLU C  32      15.095  18.088  48.918  1.00 22.18           N  
ATOM   2795  CA  GLU C  32      14.908  18.734  50.212  1.00 24.77           C  
ATOM   2796  C   GLU C  32      14.977  20.260  50.080  1.00 22.93           C  
ATOM   2797  O   GLU C  32      15.701  20.938  50.821  1.00 23.17           O  
ATOM   2798  CB  GLU C  32      15.961  18.213  51.192  1.00 27.26           C  
ATOM   2799  CG  GLU C  32      15.748  16.739  51.560  1.00 35.35           C  
ATOM   2800  CD  GLU C  32      17.016  16.049  52.041  1.00 39.63           C  
ATOM   2801  OE1 GLU C  32      16.954  14.845  52.366  1.00 43.05           O  
ATOM   2802  OE2 GLU C  32      18.077  16.706  52.088  1.00 45.76           O  
ATOM   2803  N   GLY C  33      14.229  20.787  49.114  1.00 19.64           N  
ATOM   2804  CA  GLY C  33      14.189  22.224  48.901  1.00 19.39           C  
ATOM   2805  C   GLY C  33      15.371  22.868  48.198  1.00 18.20           C  
ATOM   2806  O   GLY C  33      15.306  24.046  47.851  1.00 18.19           O  
ATOM   2807  N   GLU C  34      16.450  22.117  47.991  1.00 17.90           N  
ATOM   2808  CA  GLU C  34      17.632  22.649  47.321  1.00 17.94           C  
ATOM   2809  C   GLU C  34      17.665  22.275  45.836  1.00 16.64           C  
ATOM   2810  O   GLU C  34      17.428  21.127  45.466  1.00 16.38           O  
ATOM   2811  CB  GLU C  34      18.905  22.137  47.999  1.00 21.05           C  
ATOM   2812  CG  GLU C  34      20.184  22.556  47.282  1.00 32.16           C  
ATOM   2813  CD  GLU C  34      21.454  22.156  48.026  1.00 38.22           C  
ATOM   2814  OE1 GLU C  34      21.658  20.946  48.271  1.00 41.29           O  
ATOM   2815  OE2 GLU C  34      22.250  23.058  48.364  1.00 42.66           O  
ATOM   2816  N   ILE C  35      17.943  23.255  44.986  1.00 15.66           N  
ATOM   2817  CA  ILE C  35      18.022  22.996  43.550  1.00 16.61           C  
ATOM   2818  C   ILE C  35      19.366  22.327  43.294  1.00 15.91           C  
ATOM   2819  O   ILE C  35      20.421  22.910  43.534  1.00 18.17           O  
ATOM   2820  CB  ILE C  35      17.906  24.305  42.742  1.00 18.51           C  
ATOM   2821  CG1 ILE C  35      16.507  24.899  42.939  1.00 16.56           C  
ATOM   2822  CG2 ILE C  35      18.194  24.048  41.266  1.00 17.23           C  
ATOM   2823  CD1 ILE C  35      16.313  26.240  42.257  1.00 16.16           C  
ATOM   2824  N   ILE C  36      19.310  21.086  42.828  1.00 15.04           N  
ATOM   2825  CA  ILE C  36      20.482  20.275  42.548  1.00 15.44           C  
ATOM   2826  C   ILE C  36      21.001  20.509  41.139  1.00 17.24           C  
ATOM   2827  O   ILE C  36      22.209  20.619  40.921  1.00 18.15           O  
ATOM   2828  CB  ILE C  36      20.140  18.767  42.721  1.00 17.55           C  
ATOM   2829  CG1 ILE C  36      19.665  18.514  44.144  1.00 18.28           C  
ATOM   2830  CG2 ILE C  36      21.358  17.889  42.417  1.00 17.68           C  
ATOM   2831  CD1 ILE C  36      20.617  19.049  45.194  1.00 20.41           C  
ATOM   2832  N   SER C  37      20.086  20.572  40.177  1.00 14.76           N  
ATOM   2833  CA  SER C  37      20.477  20.800  38.791  1.00 15.58           C  
ATOM   2834  C   SER C  37      19.417  21.584  38.024  1.00 13.55           C  
ATOM   2835  O   SER C  37      18.250  21.623  38.425  1.00 14.01           O  
ATOM   2836  CB  SER C  37      20.738  19.458  38.081  1.00 11.58           C  
ATOM   2837  OG  SER C  37      19.571  18.655  38.007  1.00 14.93           O  
ATOM   2838  N   LYS C  38      19.849  22.203  36.924  1.00 12.75           N  
ATOM   2839  CA  LYS C  38      18.995  22.991  36.038  1.00 13.11           C  
ATOM   2840  C   LYS C  38      19.444  22.739  34.600  1.00 16.74           C  
ATOM   2841  O   LYS C  38      20.640  22.641  34.332  1.00 15.43           O  
ATOM   2842  CB  LYS C  38      19.148  24.493  36.333  1.00 14.90           C  
ATOM   2843  CG  LYS C  38      18.612  24.938  37.685  1.00 21.29           C  
ATOM   2844  CD  LYS C  38      19.108  26.332  38.097  1.00 26.26           C  
ATOM   2845  CE  LYS C  38      18.787  27.416  37.088  1.00 30.38           C  
ATOM   2846  NZ  LYS C  38      18.984  28.801  37.659  1.00 25.37           N  
ATOM   2847  N   ALA C  39      18.496  22.636  33.674  1.00 15.41           N  
ATOM   2848  CA  ALA C  39      18.858  22.426  32.281  1.00 16.80           C  
ATOM   2849  C   ALA C  39      17.702  22.804  31.371  1.00 14.24           C  
ATOM   2850  O   ALA C  39      16.580  22.990  31.821  1.00 12.62           O  
ATOM   2851  CB  ALA C  39      19.261  20.955  32.042  1.00 17.17           C  
ATOM   2852  N   HIS C  40      17.998  22.942  30.087  1.00 12.71           N  
ATOM   2853  CA  HIS C  40      16.979  23.261  29.106  1.00 13.18           C  
ATOM   2854  C   HIS C  40      17.236  22.383  27.892  1.00 14.44           C  
ATOM   2855  O   HIS C  40      18.338  21.858  27.723  1.00 13.95           O  
ATOM   2856  CB  HIS C  40      17.041  24.740  28.727  1.00 15.21           C  
ATOM   2857  CG  HIS C  40      18.369  25.179  28.193  1.00 13.93           C  
ATOM   2858  ND1 HIS C  40      18.788  24.903  26.907  1.00 19.50           N  
ATOM   2859  CD2 HIS C  40      19.372  25.883  28.772  1.00 16.37           C  
ATOM   2860  CE1 HIS C  40      19.988  25.421  26.718  1.00 15.18           C  
ATOM   2861  NE2 HIS C  40      20.366  26.023  27.833  1.00 18.67           N  
ATOM   2862  N   ASN C  41      16.208  22.183  27.078  1.00 14.06           N  
ATOM   2863  CA  ASN C  41      16.348  21.368  25.879  1.00 15.17           C  
ATOM   2864  C   ASN C  41      17.551  21.902  25.100  1.00 14.37           C  
ATOM   2865  O   ASN C  41      17.634  23.096  24.822  1.00 14.64           O  
ATOM   2866  CB  ASN C  41      15.065  21.463  25.048  1.00 17.24           C  
ATOM   2867  CG  ASN C  41      15.058  20.520  23.873  1.00 20.12           C  
ATOM   2868  OD1 ASN C  41      14.112  19.744  23.685  1.00 27.65           O  
ATOM   2869  ND2 ASN C  41      16.106  20.578  23.066  1.00 20.48           N  
ATOM   2870  N   SER C  42      18.488  21.019  24.760  1.00 12.38           N  
ATOM   2871  CA  SER C  42      19.698  21.434  24.041  1.00 13.37           C  
ATOM   2872  C   SER C  42      19.975  20.575  22.804  1.00 14.93           C  
ATOM   2873  O   SER C  42      21.132  20.421  22.390  1.00 16.62           O  
ATOM   2874  CB  SER C  42      20.900  21.366  24.987  1.00 13.20           C  
ATOM   2875  OG  SER C  42      20.684  22.171  26.145  1.00 14.65           O  
ATOM   2876  N   VAL C  43      18.907  20.037  22.218  1.00 14.18           N  
ATOM   2877  CA  VAL C  43      19.009  19.169  21.046  1.00 14.18           C  
ATOM   2878  C   VAL C  43      19.798  19.794  19.891  1.00 17.34           C  
ATOM   2879  O   VAL C  43      20.708  19.163  19.339  1.00 15.54           O  
ATOM   2880  CB  VAL C  43      17.594  18.742  20.548  1.00 16.96           C  
ATOM   2881  CG1 VAL C  43      17.694  18.015  19.219  1.00 13.97           C  
ATOM   2882  CG2 VAL C  43      16.939  17.826  21.575  1.00 15.83           C  
ATOM   2883  N   GLU C  44      19.473  21.031  19.537  1.00 17.06           N  
ATOM   2884  CA  GLU C  44      20.181  21.678  18.433  1.00 20.67           C  
ATOM   2885  C   GLU C  44      21.635  21.997  18.771  1.00 20.71           C  
ATOM   2886  O   GLU C  44      22.529  21.737  17.976  1.00 20.86           O  
ATOM   2887  CB  GLU C  44      19.462  22.966  18.009  1.00 20.80           C  
ATOM   2888  CG  GLU C  44      18.033  22.775  17.520  1.00 24.47           C  
ATOM   2889  CD  GLU C  44      17.944  21.793  16.360  1.00 26.79           C  
ATOM   2890  OE1 GLU C  44      18.799  21.870  15.458  1.00 28.05           O  
ATOM   2891  OE2 GLU C  44      17.030  20.948  16.346  1.00 23.42           O  
ATOM   2892  N   GLU C  45      21.875  22.561  19.949  1.00 19.90           N  
ATOM   2893  CA  GLU C  45      23.232  22.922  20.355  1.00 21.34           C  
ATOM   2894  C   GLU C  45      24.169  21.726  20.353  1.00 21.09           C  
ATOM   2895  O   GLU C  45      25.287  21.790  19.838  1.00 21.41           O  
ATOM   2896  CB  GLU C  45      23.212  23.546  21.751  1.00 21.23           C  
ATOM   2897  CG  GLU C  45      24.576  23.657  22.432  1.00 30.91           C  
ATOM   2898  CD  GLU C  45      24.468  24.190  23.856  1.00 36.71           C  
ATOM   2899  OE1 GLU C  45      25.440  24.055  24.634  1.00 40.59           O  
ATOM   2900  OE2 GLU C  45      23.406  24.749  24.195  1.00 40.89           O  
ATOM   2901  N   LEU C  46      23.693  20.625  20.913  1.00 19.08           N  
ATOM   2902  CA  LEU C  46      24.491  19.423  21.027  1.00 17.99           C  
ATOM   2903  C   LEU C  46      24.368  18.446  19.867  1.00 17.72           C  
ATOM   2904  O   LEU C  46      25.107  17.453  19.830  1.00 17.73           O  
ATOM   2905  CB  LEU C  46      24.128  18.705  22.333  1.00 18.98           C  
ATOM   2906  CG  LEU C  46      24.246  19.566  23.600  1.00 20.35           C  
ATOM   2907  CD1 LEU C  46      23.748  18.785  24.806  1.00 20.00           C  
ATOM   2908  CD2 LEU C  46      25.704  19.979  23.797  1.00 22.02           C  
ATOM   2909  N   LYS C  47      23.474  18.722  18.914  1.00 17.32           N  
ATOM   2910  CA  LYS C  47      23.259  17.790  17.795  1.00 21.63           C  
ATOM   2911  C   LYS C  47      23.016  16.419  18.415  1.00 20.59           C  
ATOM   2912  O   LYS C  47      23.636  15.419  18.032  1.00 20.58           O  
ATOM   2913  CB  LYS C  47      24.497  17.709  16.899  1.00 26.10           C  
ATOM   2914  CG  LYS C  47      24.745  18.925  16.049  1.00 32.27           C  
ATOM   2915  CD  LYS C  47      23.714  19.039  14.942  1.00 36.09           C  
ATOM   2916  CE  LYS C  47      24.394  19.456  13.653  1.00 36.59           C  
ATOM   2917  NZ  LYS C  47      25.363  20.555  13.902  1.00 37.73           N  
ATOM   2918  N   ASP C  48      22.107  16.378  19.382  1.00 16.70           N  
ATOM   2919  CA  ASP C  48      21.801  15.146  20.106  1.00 16.98           C  
ATOM   2920  C   ASP C  48      20.302  15.104  20.362  1.00 17.80           C  
ATOM   2921  O   ASP C  48      19.784  15.823  21.217  1.00 17.14           O  
ATOM   2922  CB  ASP C  48      22.584  15.141  21.429  1.00 16.69           C  
ATOM   2923  CG  ASP C  48      22.270  13.944  22.319  1.00 14.72           C  
ATOM   2924  OD1 ASP C  48      22.934  13.819  23.363  1.00 19.10           O  
ATOM   2925  OD2 ASP C  48      21.374  13.142  22.001  1.00 16.17           O  
ATOM   2926  N   PRO C  49      19.586  14.249  19.621  1.00 17.72           N  
ATOM   2927  CA  PRO C  49      18.137  14.123  19.770  1.00 15.88           C  
ATOM   2928  C   PRO C  49      17.677  13.676  21.159  1.00 14.30           C  
ATOM   2929  O   PRO C  49      16.496  13.755  21.467  1.00 16.87           O  
ATOM   2930  CB  PRO C  49      17.767  13.129  18.669  1.00 16.93           C  
ATOM   2931  CG  PRO C  49      18.978  12.239  18.606  1.00 18.49           C  
ATOM   2932  CD  PRO C  49      20.113  13.240  18.680  1.00 15.80           C  
ATOM   2933  N   THR C  50      18.599  13.216  22.001  1.00 15.17           N  
ATOM   2934  CA  THR C  50      18.211  12.777  23.341  1.00 14.82           C  
ATOM   2935  C   THR C  50      18.473  13.847  24.400  1.00 15.96           C  
ATOM   2936  O   THR C  50      18.206  13.637  25.581  1.00 16.62           O  
ATOM   2937  CB  THR C  50      18.976  11.501  23.783  1.00 18.01           C  
ATOM   2938  OG1 THR C  50      20.361  11.810  23.996  1.00 19.06           O  
ATOM   2939  CG2 THR C  50      18.845  10.403  22.736  1.00 15.72           C  
ATOM   2940  N   ALA C  51      18.988  14.993  23.975  1.00 12.94           N  
ATOM   2941  CA  ALA C  51      19.323  16.062  24.911  1.00 14.58           C  
ATOM   2942  C   ALA C  51      18.143  16.921  25.344  1.00 14.88           C  
ATOM   2943  O   ALA C  51      18.178  18.144  25.233  1.00 14.37           O  
ATOM   2944  CB  ALA C  51      20.429  16.939  24.317  1.00 14.15           C  
ATOM   2945  N   HIS C  52      17.098  16.274  25.841  1.00 12.19           N  
ATOM   2946  CA  HIS C  52      15.939  16.995  26.332  1.00 12.50           C  
ATOM   2947  C   HIS C  52      16.286  17.524  27.721  1.00 12.56           C  
ATOM   2948  O   HIS C  52      17.164  16.982  28.406  1.00 12.13           O  
ATOM   2949  CB  HIS C  52      14.728  16.070  26.399  1.00 16.03           C  
ATOM   2950  CG  HIS C  52      14.126  15.768  25.057  1.00 20.95           C  
ATOM   2951  ND1 HIS C  52      12.913  15.131  24.912  1.00 24.80           N  
ATOM   2952  CD2 HIS C  52      14.577  16.000  23.802  1.00 22.13           C  
ATOM   2953  CE1 HIS C  52      12.642  14.980  23.627  1.00 21.20           C  
ATOM   2954  NE2 HIS C  52      13.636  15.500  22.931  1.00 21.07           N  
ATOM   2955  N   ALA C  53      15.599  18.581  28.137  1.00 12.25           N  
ATOM   2956  CA  ALA C  53      15.869  19.191  29.428  1.00 13.01           C  
ATOM   2957  C   ALA C  53      15.910  18.193  30.577  1.00 12.05           C  
ATOM   2958  O   ALA C  53      16.856  18.194  31.359  1.00 11.81           O  
ATOM   2959  CB  ALA C  53      14.841  20.290  29.731  1.00 10.64           C  
ATOM   2960  N   GLU C  54      14.899  17.336  30.682  1.00 12.19           N  
ATOM   2961  CA  GLU C  54      14.864  16.367  31.783  1.00 12.62           C  
ATOM   2962  C   GLU C  54      16.076  15.444  31.790  1.00 12.07           C  
ATOM   2963  O   GLU C  54      16.637  15.168  32.841  1.00 11.66           O  
ATOM   2964  CB  GLU C  54      13.598  15.507  31.716  1.00 14.29           C  
ATOM   2965  CG  GLU C  54      12.293  16.281  31.657  1.00 15.31           C  
ATOM   2966  CD  GLU C  54      11.859  16.601  30.240  1.00 18.41           C  
ATOM   2967  OE1 GLU C  54      10.749  16.173  29.870  1.00 23.64           O  
ATOM   2968  OE2 GLU C  54      12.608  17.278  29.495  1.00 16.40           O  
ATOM   2969  N   MET C  55      16.454  14.946  30.615  1.00  9.56           N  
ATOM   2970  CA  MET C  55      17.594  14.041  30.511  1.00 13.15           C  
ATOM   2971  C   MET C  55      18.870  14.713  31.016  1.00 12.85           C  
ATOM   2972  O   MET C  55      19.635  14.117  31.775  1.00 14.07           O  
ATOM   2973  CB  MET C  55      17.788  13.592  29.057  1.00 12.91           C  
ATOM   2974  CG  MET C  55      16.564  12.904  28.452  1.00 17.52           C  
ATOM   2975  SD  MET C  55      16.147  11.335  29.289  1.00 20.00           S  
ATOM   2976  CE  MET C  55      17.526  10.355  28.774  1.00 14.45           C  
ATOM   2977  N   LEU C  56      19.101  15.954  30.593  1.00 10.47           N  
ATOM   2978  CA  LEU C  56      20.285  16.677  31.024  1.00 13.93           C  
ATOM   2979  C   LEU C  56      20.256  16.944  32.523  1.00 13.33           C  
ATOM   2980  O   LEU C  56      21.279  16.809  33.187  1.00 14.57           O  
ATOM   2981  CB  LEU C  56      20.421  18.001  30.260  1.00 11.83           C  
ATOM   2982  CG  LEU C  56      20.630  17.862  28.749  1.00 16.27           C  
ATOM   2983  CD1 LEU C  56      20.595  19.252  28.081  1.00 16.74           C  
ATOM   2984  CD2 LEU C  56      21.951  17.153  28.491  1.00 19.46           C  
ATOM   2985  N   ALA C  57      19.089  17.327  33.048  1.00 13.20           N  
ATOM   2986  CA  ALA C  57      18.941  17.616  34.476  1.00 12.98           C  
ATOM   2987  C   ALA C  57      19.232  16.357  35.293  1.00 14.11           C  
ATOM   2988  O   ALA C  57      19.965  16.402  36.288  1.00 17.37           O  
ATOM   2989  CB  ALA C  57      17.512  18.141  34.775  1.00 14.25           C  
ATOM   2990  N   ILE C  58      18.673  15.232  34.862  1.00 13.54           N  
ATOM   2991  CA  ILE C  58      18.909  13.966  35.551  1.00 12.05           C  
ATOM   2992  C   ILE C  58      20.386  13.593  35.556  1.00 15.84           C  
ATOM   2993  O   ILE C  58      20.934  13.223  36.602  1.00 13.14           O  
ATOM   2994  CB  ILE C  58      18.102  12.833  34.909  1.00 14.70           C  
ATOM   2995  CG1 ILE C  58      16.616  13.032  35.221  1.00 15.38           C  
ATOM   2996  CG2 ILE C  58      18.603  11.475  35.411  1.00 13.49           C  
ATOM   2997  CD1 ILE C  58      15.711  12.002  34.593  1.00 15.18           C  
ATOM   2998  N   LYS C  59      21.039  13.687  34.399  1.00 15.30           N  
ATOM   2999  CA  LYS C  59      22.453  13.342  34.320  1.00 16.14           C  
ATOM   3000  C   LYS C  59      23.285  14.225  35.244  1.00 15.43           C  
ATOM   3001  O   LYS C  59      24.166  13.743  35.941  1.00 17.05           O  
ATOM   3002  CB  LYS C  59      22.965  13.465  32.879  1.00 19.75           C  
ATOM   3003  CG  LYS C  59      22.447  12.393  31.933  1.00 21.52           C  
ATOM   3004  CD  LYS C  59      22.811  12.721  30.485  1.00 26.53           C  
ATOM   3005  CE  LYS C  59      22.212  11.712  29.506  1.00 29.80           C  
ATOM   3006  NZ  LYS C  59      22.855  10.382  29.654  1.00 30.17           N  
ATOM   3007  N   GLU C  60      22.981  15.517  35.274  1.00 15.71           N  
ATOM   3008  CA  GLU C  60      23.720  16.432  36.125  1.00 17.72           C  
ATOM   3009  C   GLU C  60      23.453  16.169  37.603  1.00 15.46           C  
ATOM   3010  O   GLU C  60      24.383  16.194  38.414  1.00 16.98           O  
ATOM   3011  CB  GLU C  60      23.367  17.881  35.768  1.00 23.14           C  
ATOM   3012  CG  GLU C  60      24.132  18.938  36.551  1.00 26.57           C  
ATOM   3013  CD  GLU C  60      25.644  18.767  36.485  1.00 32.52           C  
ATOM   3014  OE1 GLU C  60      26.155  18.203  35.496  1.00 33.35           O  
ATOM   3015  OE2 GLU C  60      26.326  19.215  37.430  1.00 39.13           O  
ATOM   3016  N   ALA C  61      22.199  15.918  37.972  1.00 15.12           N  
ATOM   3017  CA  ALA C  61      21.902  15.651  39.380  1.00 14.28           C  
ATOM   3018  C   ALA C  61      22.607  14.369  39.839  1.00 17.70           C  
ATOM   3019  O   ALA C  61      23.144  14.305  40.952  1.00 17.76           O  
ATOM   3020  CB  ALA C  61      20.399  15.529  39.603  1.00 12.26           C  
ATOM   3021  N   CYS C  62      22.592  13.342  38.993  1.00 16.75           N  
ATOM   3022  CA  CYS C  62      23.240  12.083  39.348  1.00 17.74           C  
ATOM   3023  C   CYS C  62      24.733  12.300  39.608  1.00 19.42           C  
ATOM   3024  O   CYS C  62      25.303  11.724  40.551  1.00 20.88           O  
ATOM   3025  CB  CYS C  62      23.033  11.047  38.236  1.00 18.84           C  
ATOM   3026  SG  CYS C  62      21.394  10.278  38.210  1.00 18.24           S  
ATOM   3027  N   ARG C  63      25.348  13.145  38.786  1.00 18.66           N  
ATOM   3028  CA  ARG C  63      26.762  13.473  38.903  1.00 24.09           C  
ATOM   3029  C   ARG C  63      27.040  14.223  40.203  1.00 26.13           C  
ATOM   3030  O   ARG C  63      27.930  13.854  40.968  1.00 25.37           O  
ATOM   3031  CB  ARG C  63      27.193  14.343  37.718  1.00 24.75           C  
ATOM   3032  CG  ARG C  63      28.684  14.598  37.634  1.00 32.08           C  
ATOM   3033  CD  ARG C  63      29.029  15.492  36.459  1.00 36.74           C  
ATOM   3034  NE  ARG C  63      28.656  16.884  36.686  1.00 40.50           N  
ATOM   3035  CZ  ARG C  63      29.224  17.675  37.592  1.00 43.07           C  
ATOM   3036  NH1 ARG C  63      30.201  17.216  38.365  1.00 44.77           N  
ATOM   3037  NH2 ARG C  63      28.821  18.932  37.725  1.00 44.33           N  
ATOM   3038  N   ARG C  64      26.278  15.281  40.446  1.00 24.16           N  
ATOM   3039  CA  ARG C  64      26.461  16.082  41.651  1.00 26.53           C  
ATOM   3040  C   ARG C  64      26.192  15.318  42.942  1.00 27.00           C  
ATOM   3041  O   ARG C  64      26.797  15.611  43.969  1.00 29.00           O  
ATOM   3042  CB  ARG C  64      25.589  17.336  41.579  1.00 29.10           C  
ATOM   3043  CG  ARG C  64      26.082  18.292  40.510  1.00 32.99           C  
ATOM   3044  CD  ARG C  64      25.351  19.616  40.486  1.00 35.19           C  
ATOM   3045  NE  ARG C  64      26.038  20.528  39.577  1.00 39.88           N  
ATOM   3046  CZ  ARG C  64      25.520  21.652  39.091  1.00 45.49           C  
ATOM   3047  NH1 ARG C  64      24.290  22.024  39.418  1.00 47.42           N  
ATOM   3048  NH2 ARG C  64      26.242  22.408  38.276  1.00 47.35           N  
ATOM   3049  N   LEU C  65      25.293  14.340  42.879  1.00 26.92           N  
ATOM   3050  CA  LEU C  65      24.935  13.520  44.036  1.00 26.92           C  
ATOM   3051  C   LEU C  65      25.781  12.244  44.124  1.00 28.32           C  
ATOM   3052  O   LEU C  65      25.763  11.544  45.142  1.00 25.92           O  
ATOM   3053  CB  LEU C  65      23.454  13.135  43.967  1.00 28.54           C  
ATOM   3054  CG  LEU C  65      22.409  14.107  44.514  1.00 27.81           C  
ATOM   3055  CD1 LEU C  65      22.701  15.504  44.036  1.00 31.26           C  
ATOM   3056  CD2 LEU C  65      21.030  13.663  44.079  1.00 28.05           C  
ATOM   3057  N   ASN C  66      26.499  11.941  43.048  1.00 27.28           N  
ATOM   3058  CA  ASN C  66      27.363  10.762  42.982  1.00 26.81           C  
ATOM   3059  C   ASN C  66      26.559   9.471  43.161  1.00 27.90           C  
ATOM   3060  O   ASN C  66      27.013   8.516  43.805  1.00 24.69           O  
ATOM   3061  CB  ASN C  66      28.451  10.867  44.059  1.00 28.97           C  
ATOM   3062  CG  ASN C  66      29.611   9.912  43.816  1.00 33.62           C  
ATOM   3063  OD1 ASN C  66      30.133   9.825  42.705  1.00 33.97           O  
ATOM   3064  ND2 ASN C  66      30.028   9.204  44.861  1.00 36.34           N  
ATOM   3065  N   THR C  67      25.372   9.440  42.564  1.00 23.58           N  
ATOM   3066  CA  THR C  67      24.494   8.289  42.673  1.00 25.36           C  
ATOM   3067  C   THR C  67      23.719   8.097  41.376  1.00 26.31           C  
ATOM   3068  O   THR C  67      23.447   9.065  40.664  1.00 24.99           O  
ATOM   3069  CB  THR C  67      23.497   8.493  43.835  1.00 26.76           C  
ATOM   3070  OG1 THR C  67      22.549   7.421  43.856  1.00 32.48           O  
ATOM   3071  CG2 THR C  67      22.760   9.817  43.674  1.00 26.83           C  
ATOM   3072  N   LYS C  68      23.361   6.855  41.058  1.00 24.43           N  
ATOM   3073  CA  LYS C  68      22.608   6.617  39.838  1.00 25.76           C  
ATOM   3074  C   LYS C  68      21.116   6.771  40.092  1.00 25.87           C  
ATOM   3075  O   LYS C  68      20.336   6.906  39.154  1.00 25.43           O  
ATOM   3076  CB  LYS C  68      22.897   5.224  39.264  1.00 28.45           C  
ATOM   3077  CG  LYS C  68      22.388   4.068  40.090  1.00 30.47           C  
ATOM   3078  CD  LYS C  68      22.661   2.748  39.377  1.00 30.30           C  
ATOM   3079  CE  LYS C  68      22.472   1.572  40.311  1.00 32.08           C  
ATOM   3080  NZ  LYS C  68      22.639   0.270  39.613  1.00 31.21           N  
ATOM   3081  N   TYR C  69      20.722   6.757  41.364  1.00 24.20           N  
ATOM   3082  CA  TYR C  69      19.316   6.906  41.720  1.00 24.39           C  
ATOM   3083  C   TYR C  69      19.080   8.232  42.438  1.00 23.59           C  
ATOM   3084  O   TYR C  69      19.819   8.591  43.353  1.00 27.31           O  
ATOM   3085  CB  TYR C  69      18.866   5.742  42.594  1.00 24.11           C  
ATOM   3086  CG  TYR C  69      19.029   4.389  41.921  1.00 28.28           C  
ATOM   3087  CD1 TYR C  69      18.582   4.178  40.612  1.00 26.35           C  
ATOM   3088  CD2 TYR C  69      19.592   3.312  42.605  1.00 28.32           C  
ATOM   3089  CE1 TYR C  69      18.683   2.933  40.007  1.00 30.71           C  
ATOM   3090  CE2 TYR C  69      19.700   2.056  42.007  1.00 32.69           C  
ATOM   3091  CZ  TYR C  69      19.239   1.875  40.708  1.00 32.43           C  
ATOM   3092  OH  TYR C  69      19.306   0.629  40.125  1.00 35.18           O  
ATOM   3093  N   LEU C  70      18.044   8.949  42.020  1.00 17.82           N  
ATOM   3094  CA  LEU C  70      17.729  10.246  42.600  1.00 19.31           C  
ATOM   3095  C   LEU C  70      16.605  10.142  43.620  1.00 22.62           C  
ATOM   3096  O   LEU C  70      15.593  10.841  43.547  1.00 21.92           O  
ATOM   3097  CB  LEU C  70      17.375  11.234  41.474  1.00 18.43           C  
ATOM   3098  CG  LEU C  70      18.544  11.405  40.490  1.00 18.04           C  
ATOM   3099  CD1 LEU C  70      18.117  12.253  39.279  1.00 17.96           C  
ATOM   3100  CD2 LEU C  70      19.724  12.054  41.216  1.00 15.79           C  
ATOM   3101  N   GLU C  71      16.799   9.243  44.577  1.00 24.86           N  
ATOM   3102  CA  GLU C  71      15.824   9.027  45.636  1.00 25.17           C  
ATOM   3103  C   GLU C  71      15.580  10.347  46.350  1.00 22.57           C  
ATOM   3104  O   GLU C  71      16.506  11.126  46.574  1.00 23.66           O  
ATOM   3105  CB  GLU C  71      16.366   7.982  46.611  1.00 31.57           C  
ATOM   3106  CG  GLU C  71      16.809   6.707  45.915  1.00 38.97           C  
ATOM   3107  CD  GLU C  71      17.662   5.816  46.799  1.00 44.53           C  
ATOM   3108  OE1 GLU C  71      18.069   4.732  46.323  1.00 47.02           O  
ATOM   3109  OE2 GLU C  71      17.925   6.198  47.961  1.00 45.04           O  
ATOM   3110  N   GLY C  72      14.323  10.606  46.687  1.00 23.73           N  
ATOM   3111  CA  GLY C  72      13.984  11.836  47.381  1.00 23.94           C  
ATOM   3112  C   GLY C  72      14.004  13.093  46.533  1.00 22.88           C  
ATOM   3113  O   GLY C  72      13.741  14.175  47.042  1.00 25.28           O  
ATOM   3114  N   CYS C  73      14.302  12.957  45.244  1.00 19.07           N  
ATOM   3115  CA  CYS C  73      14.353  14.107  44.349  1.00 16.50           C  
ATOM   3116  C   CYS C  73      13.062  14.326  43.570  1.00 16.17           C  
ATOM   3117  O   CYS C  73      12.330  13.381  43.241  1.00 14.15           O  
ATOM   3118  CB  CYS C  73      15.502  13.954  43.346  1.00 17.59           C  
ATOM   3119  SG  CYS C  73      17.168  14.113  44.042  1.00 18.95           S  
ATOM   3120  N   GLU C  74      12.789  15.590  43.275  1.00 14.67           N  
ATOM   3121  CA  GLU C  74      11.614  15.944  42.501  1.00 15.02           C  
ATOM   3122  C   GLU C  74      12.081  16.677  41.272  1.00 14.71           C  
ATOM   3123  O   GLU C  74      13.050  17.438  41.335  1.00 13.89           O  
ATOM   3124  CB  GLU C  74      10.690  16.872  43.279  1.00 21.19           C  
ATOM   3125  CG  GLU C  74      10.129  16.287  44.542  1.00 27.64           C  
ATOM   3126  CD  GLU C  74       9.109  17.221  45.167  1.00 30.40           C  
ATOM   3127  OE1 GLU C  74       9.406  18.431  45.287  1.00 34.41           O  
ATOM   3128  OE2 GLU C  74       8.019  16.741  45.533  1.00 35.25           O  
ATOM   3129  N   LEU C  75      11.389  16.451  40.161  1.00 11.17           N  
ATOM   3130  CA  LEU C  75      11.729  17.125  38.914  1.00 12.35           C  
ATOM   3131  C   LEU C  75      10.622  18.091  38.505  1.00 11.64           C  
ATOM   3132  O   LEU C  75       9.466  17.701  38.386  1.00 12.64           O  
ATOM   3133  CB  LEU C  75      11.926  16.120  37.772  1.00 13.30           C  
ATOM   3134  CG  LEU C  75      12.001  16.814  36.393  1.00 18.80           C  
ATOM   3135  CD1 LEU C  75      13.392  17.347  36.206  1.00 25.96           C  
ATOM   3136  CD2 LEU C  75      11.638  15.859  35.269  1.00 23.46           C  
ATOM   3137  N   TYR C  76      10.982  19.354  38.304  1.00 11.84           N  
ATOM   3138  CA  TYR C  76      10.022  20.350  37.842  1.00 11.71           C  
ATOM   3139  C   TYR C  76      10.366  20.627  36.386  1.00 12.80           C  
ATOM   3140  O   TYR C  76      11.519  20.936  36.069  1.00 12.72           O  
ATOM   3141  CB  TYR C  76      10.137  21.646  38.637  1.00 10.88           C  
ATOM   3142  CG  TYR C  76       9.691  21.506  40.060  1.00 12.11           C  
ATOM   3143  CD1 TYR C  76      10.564  21.044  41.046  1.00 14.58           C  
ATOM   3144  CD2 TYR C  76       8.383  21.820  40.424  1.00 12.26           C  
ATOM   3145  CE1 TYR C  76      10.137  20.904  42.370  1.00 16.13           C  
ATOM   3146  CE2 TYR C  76       7.953  21.681  41.733  1.00 13.25           C  
ATOM   3147  CZ  TYR C  76       8.829  21.226  42.696  1.00 15.01           C  
ATOM   3148  OH  TYR C  76       8.397  21.097  43.990  1.00 17.06           O  
ATOM   3149  N   VAL C  77       9.381  20.519  35.502  1.00 12.87           N  
ATOM   3150  CA  VAL C  77       9.633  20.745  34.083  1.00 11.13           C  
ATOM   3151  C   VAL C  77       8.466  21.535  33.492  1.00 13.35           C  
ATOM   3152  O   VAL C  77       7.307  21.343  33.878  1.00 10.59           O  
ATOM   3153  CB  VAL C  77       9.860  19.387  33.358  1.00 13.10           C  
ATOM   3154  CG1 VAL C  77       8.624  18.518  33.458  1.00 15.19           C  
ATOM   3155  CG2 VAL C  77      10.265  19.624  31.909  1.00 13.60           C  
ATOM   3156  N   THR C  78       8.782  22.430  32.558  1.00 13.28           N  
ATOM   3157  CA  THR C  78       7.776  23.302  31.960  1.00 14.04           C  
ATOM   3158  C   THR C  78       6.820  22.645  30.992  1.00 16.00           C  
ATOM   3159  O   THR C  78       5.816  23.250  30.602  1.00 18.90           O  
ATOM   3160  CB  THR C  78       8.425  24.490  31.246  1.00 11.78           C  
ATOM   3161  OG1 THR C  78       9.249  24.011  30.176  1.00 11.84           O  
ATOM   3162  CG2 THR C  78       9.284  25.276  32.213  1.00 13.20           C  
ATOM   3163  N   LEU C  79       7.125  21.417  30.597  1.00 11.74           N  
ATOM   3164  CA  LEU C  79       6.266  20.686  29.682  1.00 12.80           C  
ATOM   3165  C   LEU C  79       6.209  19.218  30.107  1.00 15.72           C  
ATOM   3166  O   LEU C  79       7.187  18.674  30.625  1.00 15.45           O  
ATOM   3167  CB  LEU C  79       6.808  20.797  28.249  1.00 14.45           C  
ATOM   3168  CG  LEU C  79       5.979  20.111  27.162  1.00 18.32           C  
ATOM   3169  CD1 LEU C  79       4.562  20.712  27.123  1.00 18.44           C  
ATOM   3170  CD2 LEU C  79       6.676  20.278  25.823  1.00 15.84           C  
ATOM   3171  N   GLU C  80       5.048  18.600  29.909  1.00 14.76           N  
ATOM   3172  CA  GLU C  80       4.854  17.191  30.231  1.00 13.84           C  
ATOM   3173  C   GLU C  80       5.973  16.398  29.556  1.00 15.50           C  
ATOM   3174  O   GLU C  80       6.180  16.504  28.353  1.00 16.21           O  
ATOM   3175  CB  GLU C  80       3.492  16.737  29.684  1.00 14.68           C  
ATOM   3176  CG  GLU C  80       3.156  15.265  29.899  1.00 15.74           C  
ATOM   3177  CD  GLU C  80       1.931  14.836  29.115  1.00 19.19           C  
ATOM   3178  OE1 GLU C  80       1.593  13.631  29.160  1.00 21.47           O  
ATOM   3179  OE2 GLU C  80       1.304  15.696  28.453  1.00 16.87           O  
ATOM   3180  N   PRO C  81       6.706  15.583  30.322  1.00 16.00           N  
ATOM   3181  CA  PRO C  81       7.786  14.809  29.696  1.00 16.99           C  
ATOM   3182  C   PRO C  81       7.306  13.860  28.588  1.00 15.55           C  
ATOM   3183  O   PRO C  81       6.215  13.285  28.673  1.00 15.55           O  
ATOM   3184  CB  PRO C  81       8.416  14.069  30.884  1.00 16.91           C  
ATOM   3185  CG  PRO C  81       7.329  14.016  31.900  1.00 20.87           C  
ATOM   3186  CD  PRO C  81       6.667  15.364  31.775  1.00 16.05           C  
ATOM   3187  N   CYS C  82       8.121  13.713  27.545  1.00 17.22           N  
ATOM   3188  CA  CYS C  82       7.803  12.814  26.434  1.00 16.74           C  
ATOM   3189  C   CYS C  82       7.978  11.370  26.925  1.00 18.56           C  
ATOM   3190  O   CYS C  82       8.298  11.138  28.098  1.00 15.77           O  
ATOM   3191  CB  CYS C  82       8.751  13.067  25.251  1.00 16.17           C  
ATOM   3192  SG  CYS C  82      10.447  12.491  25.541  1.00 20.95           S  
ATOM   3193  N   ILE C  83       7.790  10.401  26.030  1.00 15.28           N  
ATOM   3194  CA  ILE C  83       7.916   8.991  26.402  1.00 17.34           C  
ATOM   3195  C   ILE C  83       9.312   8.630  26.904  1.00 16.99           C  
ATOM   3196  O   ILE C  83       9.455   7.963  27.926  1.00 14.71           O  
ATOM   3197  CB  ILE C  83       7.587   8.048  25.211  1.00 20.06           C  
ATOM   3198  CG1 ILE C  83       6.140   8.248  24.760  1.00 26.99           C  
ATOM   3199  CG2 ILE C  83       7.784   6.597  25.632  1.00 21.02           C  
ATOM   3200  CD1 ILE C  83       5.763   7.417  23.526  1.00 28.65           C  
ATOM   3201  N   MET C  84      10.334   9.054  26.168  1.00 12.67           N  
ATOM   3202  CA  MET C  84      11.707   8.773  26.549  1.00 13.25           C  
ATOM   3203  C   MET C  84      11.991   9.318  27.942  1.00 14.33           C  
ATOM   3204  O   MET C  84      12.495   8.615  28.825  1.00 12.29           O  
ATOM   3205  CB  MET C  84      12.677   9.414  25.547  1.00 10.93           C  
ATOM   3206  CG  MET C  84      14.121   9.345  26.005  1.00 15.76           C  
ATOM   3207  SD  MET C  84      15.252  10.168  24.857  1.00 16.50           S  
ATOM   3208  CE  MET C  84      14.950  11.885  25.280  1.00 15.75           C  
ATOM   3209  N   CYS C  85      11.666  10.593  28.126  1.00 14.16           N  
ATOM   3210  CA  CYS C  85      11.894  11.256  29.398  1.00 14.54           C  
ATOM   3211  C   CYS C  85      11.109  10.663  30.547  1.00 13.86           C  
ATOM   3212  O   CYS C  85      11.643  10.524  31.655  1.00 14.18           O  
ATOM   3213  CB  CYS C  85      11.604  12.749  29.253  1.00 16.14           C  
ATOM   3214  SG  CYS C  85      12.967  13.570  28.401  1.00 18.73           S  
ATOM   3215  N   SER C  86       9.853  10.304  30.294  1.00 13.20           N  
ATOM   3216  CA  SER C  86       9.035   9.723  31.352  1.00 14.23           C  
ATOM   3217  C   SER C  86       9.663   8.440  31.878  1.00 14.68           C  
ATOM   3218  O   SER C  86       9.687   8.215  33.081  1.00 12.67           O  
ATOM   3219  CB  SER C  86       7.612   9.436  30.854  1.00 12.77           C  
ATOM   3220  OG  SER C  86       6.939  10.640  30.508  1.00 14.94           O  
ATOM   3221  N   TYR C  87      10.208   7.609  30.992  1.00 14.57           N  
ATOM   3222  CA  TYR C  87      10.809   6.357  31.464  1.00 14.77           C  
ATOM   3223  C   TYR C  87      12.142   6.629  32.143  1.00 12.55           C  
ATOM   3224  O   TYR C  87      12.555   5.872  33.021  1.00 14.39           O  
ATOM   3225  CB  TYR C  87      10.981   5.342  30.316  1.00 13.17           C  
ATOM   3226  CG  TYR C  87      11.094   3.894  30.790  1.00 15.43           C  
ATOM   3227  CD1 TYR C  87      10.041   3.285  31.470  1.00 19.46           C  
ATOM   3228  CD2 TYR C  87      12.253   3.138  30.565  1.00 15.04           C  
ATOM   3229  CE1 TYR C  87      10.128   1.960  31.916  1.00 18.65           C  
ATOM   3230  CE2 TYR C  87      12.349   1.799  31.015  1.00 17.00           C  
ATOM   3231  CZ  TYR C  87      11.277   1.226  31.690  1.00 18.90           C  
ATOM   3232  OH  TYR C  87      11.335  -0.076  32.151  1.00 19.98           O  
ATOM   3233  N   ALA C  88      12.821   7.705  31.743  1.00 12.15           N  
ATOM   3234  CA  ALA C  88      14.081   8.071  32.379  1.00 11.98           C  
ATOM   3235  C   ALA C  88      13.790   8.382  33.846  1.00 11.77           C  
ATOM   3236  O   ALA C  88      14.603   8.128  34.719  1.00 11.46           O  
ATOM   3237  CB  ALA C  88      14.697   9.299  31.694  1.00 11.84           C  
ATOM   3238  N   LEU C  89      12.618   8.951  34.107  1.00 14.62           N  
ATOM   3239  CA  LEU C  89      12.202   9.267  35.468  1.00 16.25           C  
ATOM   3240  C   LEU C  89      12.117   7.966  36.280  1.00 14.39           C  
ATOM   3241  O   LEU C  89      12.596   7.893  37.406  1.00 15.62           O  
ATOM   3242  CB  LEU C  89      10.821   9.937  35.442  1.00 18.45           C  
ATOM   3243  CG  LEU C  89      10.643  11.462  35.507  1.00 26.55           C  
ATOM   3244  CD1 LEU C  89      11.714  12.200  34.733  1.00 24.55           C  
ATOM   3245  CD2 LEU C  89       9.247  11.792  34.986  1.00 18.26           C  
ATOM   3246  N   VAL C  90      11.508   6.946  35.689  1.00 17.05           N  
ATOM   3247  CA  VAL C  90      11.343   5.649  36.354  1.00 15.87           C  
ATOM   3248  C   VAL C  90      12.707   5.019  36.639  1.00 17.41           C  
ATOM   3249  O   VAL C  90      12.981   4.578  37.757  1.00 15.75           O  
ATOM   3250  CB  VAL C  90      10.496   4.684  35.482  1.00 18.44           C  
ATOM   3251  CG1 VAL C  90      10.348   3.337  36.185  1.00 21.70           C  
ATOM   3252  CG2 VAL C  90       9.121   5.283  35.226  1.00 18.09           C  
ATOM   3253  N   LEU C  91      13.569   5.009  35.625  1.00 15.55           N  
ATOM   3254  CA  LEU C  91      14.916   4.445  35.757  1.00 16.73           C  
ATOM   3255  C   LEU C  91      15.778   5.154  36.801  1.00 15.87           C  
ATOM   3256  O   LEU C  91      16.555   4.509  37.504  1.00 15.48           O  
ATOM   3257  CB  LEU C  91      15.620   4.462  34.385  1.00 14.38           C  
ATOM   3258  CG  LEU C  91      15.348   3.299  33.411  1.00 19.62           C  
ATOM   3259  CD1 LEU C  91      13.948   2.784  33.579  1.00 26.89           C  
ATOM   3260  CD2 LEU C  91      15.619   3.742  31.964  1.00 18.91           C  
ATOM   3261  N   SER C  92      15.641   6.477  36.907  1.00 13.17           N  
ATOM   3262  CA  SER C  92      16.433   7.240  37.867  1.00 14.87           C  
ATOM   3263  C   SER C  92      15.797   7.251  39.267  1.00 14.72           C  
ATOM   3264  O   SER C  92      16.396   7.732  40.233  1.00 16.16           O  
ATOM   3265  CB  SER C  92      16.639   8.680  37.366  1.00 16.44           C  
ATOM   3266  OG  SER C  92      15.403   9.385  37.318  1.00 17.36           O  
ATOM   3267  N   ARG C  93      14.591   6.704  39.358  1.00 13.83           N  
ATOM   3268  CA  ARG C  93      13.846   6.602  40.611  1.00 15.96           C  
ATOM   3269  C   ARG C  93      13.493   7.943  41.232  1.00 17.58           C  
ATOM   3270  O   ARG C  93      13.491   8.101  42.455  1.00 16.06           O  
ATOM   3271  CB  ARG C  93      14.622   5.739  41.606  1.00 21.33           C  
ATOM   3272  CG  ARG C  93      14.880   4.365  41.045  1.00 23.62           C  
ATOM   3273  CD  ARG C  93      15.534   3.425  42.021  1.00 30.34           C  
ATOM   3274  NE  ARG C  93      15.580   2.093  41.436  1.00 35.69           N  
ATOM   3275  CZ  ARG C  93      16.161   1.044  42.003  1.00 38.98           C  
ATOM   3276  NH1 ARG C  93      16.756   1.169  43.184  1.00 36.95           N  
ATOM   3277  NH2 ARG C  93      16.141  -0.133  41.389  1.00 41.64           N  
ATOM   3278  N   ILE C  94      13.210   8.918  40.379  1.00 15.41           N  
ATOM   3279  CA  ILE C  94      12.801  10.241  40.842  1.00 16.00           C  
ATOM   3280  C   ILE C  94      11.504  10.048  41.641  1.00 13.94           C  
ATOM   3281  O   ILE C  94      10.658   9.222  41.283  1.00 13.60           O  
ATOM   3282  CB  ILE C  94      12.575  11.165  39.629  1.00 20.96           C  
ATOM   3283  CG1 ILE C  94      13.926  11.756  39.211  1.00 22.92           C  
ATOM   3284  CG2 ILE C  94      11.549  12.252  39.950  1.00 20.42           C  
ATOM   3285  CD1 ILE C  94      14.025  12.079  37.749  1.00 31.18           C  
ATOM   3286  N   GLU C  95      11.344  10.796  42.725  1.00 13.20           N  
ATOM   3287  CA  GLU C  95      10.138  10.654  43.542  1.00 16.71           C  
ATOM   3288  C   GLU C  95       8.875  11.189  42.897  1.00 16.88           C  
ATOM   3289  O   GLU C  95       7.818  10.561  42.971  1.00 14.66           O  
ATOM   3290  CB  GLU C  95      10.321  11.338  44.900  1.00 21.51           C  
ATOM   3291  CG  GLU C  95      11.382  10.705  45.763  1.00 30.81           C  
ATOM   3292  CD  GLU C  95      11.280   9.188  45.799  1.00 35.48           C  
ATOM   3293  OE1 GLU C  95      10.174   8.658  46.058  1.00 36.57           O  
ATOM   3294  OE2 GLU C  95      12.315   8.528  45.565  1.00 39.36           O  
ATOM   3295  N   LYS C  96       8.983  12.345  42.253  1.00 15.25           N  
ATOM   3296  CA  LYS C  96       7.815  12.955  41.643  1.00 14.56           C  
ATOM   3297  C   LYS C  96       8.213  13.945  40.559  1.00 16.19           C  
ATOM   3298  O   LYS C  96       9.276  14.554  40.635  1.00 14.59           O  
ATOM   3299  CB  LYS C  96       7.018  13.696  42.724  1.00 15.85           C  
ATOM   3300  CG  LYS C  96       5.862  14.548  42.213  1.00 14.95           C  
ATOM   3301  CD  LYS C  96       5.122  15.224  43.390  1.00 20.47           C  
ATOM   3302  CE  LYS C  96       3.874  15.956  42.921  1.00 22.30           C  
ATOM   3303  NZ  LYS C  96       3.154  16.605  44.063  1.00 31.18           N  
ATOM   3304  N   VAL C  97       7.357  14.089  39.553  1.00 14.06           N  
ATOM   3305  CA  VAL C  97       7.599  15.051  38.491  1.00 11.50           C  
ATOM   3306  C   VAL C  97       6.409  16.014  38.494  1.00 10.47           C  
ATOM   3307  O   VAL C  97       5.265  15.591  38.629  1.00 13.01           O  
ATOM   3308  CB  VAL C  97       7.763  14.373  37.089  1.00 12.55           C  
ATOM   3309  CG1 VAL C  97       6.531  13.577  36.711  1.00 12.22           C  
ATOM   3310  CG2 VAL C  97       8.038  15.444  36.030  1.00 15.13           C  
ATOM   3311  N   ILE C  98       6.706  17.307  38.416  1.00  9.75           N  
ATOM   3312  CA  ILE C  98       5.694  18.367  38.403  1.00 11.72           C  
ATOM   3313  C   ILE C  98       5.885  19.108  37.083  1.00 11.51           C  
ATOM   3314  O   ILE C  98       6.992  19.569  36.791  1.00  7.63           O  
ATOM   3315  CB  ILE C  98       5.900  19.377  39.592  1.00 11.23           C  
ATOM   3316  CG1 ILE C  98       5.858  18.647  40.940  1.00 13.28           C  
ATOM   3317  CG2 ILE C  98       4.811  20.452  39.570  1.00 13.38           C  
ATOM   3318  CD1 ILE C  98       7.189  18.047  41.378  1.00 16.36           C  
ATOM   3319  N   PHE C  99       4.830  19.193  36.272  1.00 11.14           N  
ATOM   3320  CA  PHE C  99       4.930  19.871  34.982  1.00 12.08           C  
ATOM   3321  C   PHE C  99       3.819  20.915  34.826  1.00 13.03           C  
ATOM   3322  O   PHE C  99       2.685  20.713  35.279  1.00 13.69           O  
ATOM   3323  CB  PHE C  99       4.920  18.857  33.814  1.00 12.63           C  
ATOM   3324  CG  PHE C  99       3.842  17.803  33.911  1.00 14.55           C  
ATOM   3325  CD1 PHE C  99       2.649  17.939  33.214  1.00 12.91           C  
ATOM   3326  CD2 PHE C  99       4.034  16.674  34.693  1.00 12.92           C  
ATOM   3327  CE1 PHE C  99       1.660  16.961  33.293  1.00 13.22           C  
ATOM   3328  CE2 PHE C  99       3.052  15.687  34.785  1.00 14.38           C  
ATOM   3329  CZ  PHE C  99       1.864  15.830  34.085  1.00 15.47           C  
ATOM   3330  N   SER C 100       4.143  22.014  34.155  1.00 13.68           N  
ATOM   3331  CA  SER C 100       3.201  23.128  34.024  1.00 12.68           C  
ATOM   3332  C   SER C 100       2.392  23.272  32.739  1.00 13.78           C  
ATOM   3333  O   SER C 100       1.582  24.194  32.620  1.00 14.12           O  
ATOM   3334  CB  SER C 100       3.946  24.432  34.325  1.00 13.51           C  
ATOM   3335  OG  SER C 100       5.155  24.529  33.588  1.00 14.73           O  
ATOM   3336  N   ALA C 101       2.606  22.377  31.780  1.00 13.69           N  
ATOM   3337  CA  ALA C 101       1.866  22.410  30.517  1.00 14.08           C  
ATOM   3338  C   ALA C 101       1.776  20.988  29.988  1.00 16.67           C  
ATOM   3339  O   ALA C 101       2.619  20.145  30.326  1.00 16.01           O  
ATOM   3340  CB  ALA C 101       2.587  23.314  29.499  1.00 17.02           C  
ATOM   3341  N   LEU C 102       0.762  20.708  29.171  1.00 15.98           N  
ATOM   3342  CA  LEU C 102       0.607  19.374  28.604  1.00 17.99           C  
ATOM   3343  C   LEU C 102       1.150  19.342  27.186  1.00 20.88           C  
ATOM   3344  O   LEU C 102       1.183  20.367  26.491  1.00 19.26           O  
ATOM   3345  CB  LEU C 102      -0.868  18.944  28.577  1.00 20.47           C  
ATOM   3346  CG  LEU C 102      -1.631  18.885  29.912  1.00 21.86           C  
ATOM   3347  CD1 LEU C 102      -3.039  18.344  29.673  1.00 24.06           C  
ATOM   3348  CD2 LEU C 102      -0.879  17.996  30.891  1.00 23.28           C  
ATOM   3349  N   ASP C 103       1.605  18.165  26.775  1.00 20.13           N  
ATOM   3350  CA  ASP C 103       2.104  17.971  25.426  1.00 21.13           C  
ATOM   3351  C   ASP C 103       1.090  17.030  24.790  1.00 25.68           C  
ATOM   3352  O   ASP C 103       1.232  15.804  24.861  1.00 26.32           O  
ATOM   3353  CB  ASP C 103       3.486  17.319  25.424  1.00 20.58           C  
ATOM   3354  CG  ASP C 103       4.051  17.171  24.015  1.00 23.07           C  
ATOM   3355  OD1 ASP C 103       3.245  17.085  23.066  1.00 23.59           O  
ATOM   3356  OD2 ASP C 103       5.286  17.129  23.855  1.00 24.82           O  
ATOM   3357  N   LYS C 104       0.066  17.614  24.174  1.00 31.43           N  
ATOM   3358  CA  LYS C 104      -1.007  16.844  23.543  1.00 36.18           C  
ATOM   3359  C   LYS C 104      -0.556  15.944  22.399  1.00 37.99           C  
ATOM   3360  O   LYS C 104      -1.361  15.187  21.863  1.00 39.87           O  
ATOM   3361  CB  LYS C 104      -2.105  17.780  23.018  1.00 37.74           C  
ATOM   3362  CG  LYS C 104      -2.702  18.728  24.043  1.00 42.80           C  
ATOM   3363  CD  LYS C 104      -1.785  19.919  24.288  1.00 46.86           C  
ATOM   3364  CE  LYS C 104      -2.427  20.931  25.227  1.00 48.17           C  
ATOM   3365  NZ  LYS C 104      -1.616  22.181  25.349  1.00 49.76           N  
ATOM   3366  N   LYS C 105       0.718  16.020  22.024  1.00 38.94           N  
ATOM   3367  CA  LYS C 105       1.230  15.211  20.922  1.00 38.88           C  
ATOM   3368  C   LYS C 105       2.257  14.148  21.300  1.00 36.92           C  
ATOM   3369  O   LYS C 105       2.255  13.057  20.732  1.00 37.57           O  
ATOM   3370  CB  LYS C 105       1.810  16.129  19.839  1.00 42.42           C  
ATOM   3371  CG  LYS C 105       2.402  17.413  20.398  1.00 46.23           C  
ATOM   3372  CD  LYS C 105       2.854  18.376  19.312  1.00 48.09           C  
ATOM   3373  CE  LYS C 105       3.210  19.734  19.915  1.00 49.12           C  
ATOM   3374  NZ  LYS C 105       4.184  19.621  21.044  1.00 44.54           N  
ATOM   3375  N   HIS C 106       3.126  14.451  22.258  1.00 34.66           N  
ATOM   3376  CA  HIS C 106       4.155  13.498  22.662  1.00 32.48           C  
ATOM   3377  C   HIS C 106       4.139  13.168  24.154  1.00 27.92           C  
ATOM   3378  O   HIS C 106       4.958  12.382  24.615  1.00 28.13           O  
ATOM   3379  CB  HIS C 106       5.546  14.035  22.310  1.00 35.90           C  
ATOM   3380  CG  HIS C 106       5.641  14.636  20.943  1.00 40.27           C  
ATOM   3381  ND1 HIS C 106       5.393  13.918  19.792  1.00 42.34           N  
ATOM   3382  CD2 HIS C 106       5.974  15.887  20.543  1.00 41.93           C  
ATOM   3383  CE1 HIS C 106       5.571  14.701  18.742  1.00 44.15           C  
ATOM   3384  NE2 HIS C 106       5.923  15.900  19.170  1.00 42.88           N  
ATOM   3385  N   GLY C 107       3.216  13.763  24.902  1.00 28.10           N  
ATOM   3386  CA  GLY C 107       3.152  13.520  26.340  1.00 25.91           C  
ATOM   3387  C   GLY C 107       3.151  12.068  26.787  1.00 24.70           C  
ATOM   3388  O   GLY C 107       2.318  11.275  26.346  1.00 26.71           O  
ATOM   3389  N   GLY C 108       4.066  11.726  27.688  1.00 22.97           N  
ATOM   3390  CA  GLY C 108       4.156  10.364  28.184  1.00 20.53           C  
ATOM   3391  C   GLY C 108       3.672  10.171  29.609  1.00 20.66           C  
ATOM   3392  O   GLY C 108       3.956   9.140  30.225  1.00 20.90           O  
ATOM   3393  N   VAL C 109       2.966  11.157  30.154  1.00 18.05           N  
ATOM   3394  CA  VAL C 109       2.451  11.028  31.518  1.00 18.92           C  
ATOM   3395  C   VAL C 109       0.934  10.891  31.496  1.00 20.68           C  
ATOM   3396  O   VAL C 109       0.391   9.959  32.087  1.00 20.56           O  
ATOM   3397  CB  VAL C 109       2.845  12.226  32.406  1.00 16.00           C  
ATOM   3398  CG1 VAL C 109       2.205  12.082  33.777  1.00 19.28           C  
ATOM   3399  CG2 VAL C 109       4.374  12.273  32.574  1.00 15.49           C  
ATOM   3400  N   VAL C 110       0.251  11.808  30.808  1.00 22.68           N  
ATOM   3401  CA  VAL C 110      -1.208  11.750  30.716  1.00 24.67           C  
ATOM   3402  C   VAL C 110      -1.748  11.840  29.293  1.00 29.24           C  
ATOM   3403  O   VAL C 110      -2.908  11.501  29.049  1.00 28.84           O  
ATOM   3404  CB  VAL C 110      -1.894  12.879  31.531  1.00 25.46           C  
ATOM   3405  CG1 VAL C 110      -1.562  12.732  33.001  1.00 24.79           C  
ATOM   3406  CG2 VAL C 110      -1.477  14.254  30.999  1.00 22.71           C  
ATOM   3407  N   SER C 111      -0.915  12.291  28.359  1.00 30.73           N  
ATOM   3408  CA  SER C 111      -1.332  12.457  26.965  1.00 34.95           C  
ATOM   3409  C   SER C 111      -1.254  11.218  26.059  1.00 36.97           C  
ATOM   3410  O   SER C 111      -2.230  10.481  25.935  1.00 41.46           O  
ATOM   3411  CB  SER C 111      -0.550  13.623  26.350  1.00 32.75           C  
ATOM   3412  OG  SER C 111      -0.819  14.814  27.073  1.00 28.19           O  
ATOM   3413  N   VAL C 112      -0.112  10.986  25.418  1.00 40.74           N  
ATOM   3414  CA  VAL C 112       0.043   9.832  24.524  1.00 39.77           C  
ATOM   3415  C   VAL C 112      -0.040   8.496  25.262  1.00 39.05           C  
ATOM   3416  O   VAL C 112      -0.901   7.663  24.972  1.00 39.61           O  
ATOM   3417  CB  VAL C 112       1.389   9.888  23.773  1.00 41.19           C  
ATOM   3418  CG1 VAL C 112       1.488   8.733  22.776  1.00 40.95           C  
ATOM   3419  CG2 VAL C 112       1.521  11.219  23.060  1.00 41.42           C  
ATOM   3420  N   PHE C 113       0.877   8.291  26.198  1.00 36.07           N  
ATOM   3421  CA  PHE C 113       0.918   7.072  26.997  1.00 33.87           C  
ATOM   3422  C   PHE C 113       0.866   7.470  28.469  1.00 32.11           C  
ATOM   3423  O   PHE C 113       0.979   8.649  28.809  1.00 32.37           O  
ATOM   3424  CB  PHE C 113       2.230   6.308  26.752  1.00 35.93           C  
ATOM   3425  CG  PHE C 113       2.246   5.473  25.497  1.00 39.28           C  
ATOM   3426  CD1 PHE C 113       1.654   4.212  25.473  1.00 41.91           C  
ATOM   3427  CD2 PHE C 113       2.886   5.934  24.348  1.00 40.84           C  
ATOM   3428  CE1 PHE C 113       1.701   3.419  24.323  1.00 42.15           C  
ATOM   3429  CE2 PHE C 113       2.939   5.151  23.193  1.00 40.90           C  
ATOM   3430  CZ  PHE C 113       2.345   3.890  23.181  1.00 41.47           C  
ATOM   3431  N   ASN C 114       0.668   6.484  29.332  1.00 27.45           N  
ATOM   3432  CA  ASN C 114       0.680   6.700  30.774  1.00 25.83           C  
ATOM   3433  C   ASN C 114       1.878   5.872  31.201  1.00 23.68           C  
ATOM   3434  O   ASN C 114       1.734   4.827  31.821  1.00 23.04           O  
ATOM   3435  CB  ASN C 114      -0.572   6.140  31.454  1.00 28.59           C  
ATOM   3436  CG  ASN C 114      -1.823   6.885  31.070  1.00 31.60           C  
ATOM   3437  OD1 ASN C 114      -1.883   8.112  31.155  1.00 31.14           O  
ATOM   3438  ND2 ASN C 114      -2.844   6.143  30.655  1.00 34.06           N  
ATOM   3439  N   ILE C 115       3.067   6.338  30.848  1.00 20.61           N  
ATOM   3440  CA  ILE C 115       4.281   5.612  31.170  1.00 21.56           C  
ATOM   3441  C   ILE C 115       4.512   5.457  32.669  1.00 21.33           C  
ATOM   3442  O   ILE C 115       4.995   4.423  33.121  1.00 24.25           O  
ATOM   3443  CB  ILE C 115       5.509   6.307  30.517  1.00 19.95           C  
ATOM   3444  CG1 ILE C 115       5.330   6.327  28.995  1.00 21.97           C  
ATOM   3445  CG2 ILE C 115       6.804   5.586  30.895  1.00 19.39           C  
ATOM   3446  CD1 ILE C 115       5.144   4.936  28.375  1.00 22.65           C  
ATOM   3447  N   LEU C 116       4.158   6.471  33.446  1.00 19.40           N  
ATOM   3448  CA  LEU C 116       4.374   6.413  34.886  1.00 21.87           C  
ATOM   3449  C   LEU C 116       3.340   5.539  35.575  1.00 27.88           C  
ATOM   3450  O   LEU C 116       3.619   4.941  36.613  1.00 24.55           O  
ATOM   3451  CB  LEU C 116       4.348   7.826  35.480  1.00 21.10           C  
ATOM   3452  CG  LEU C 116       5.556   8.728  35.174  1.00 20.10           C  
ATOM   3453  CD1 LEU C 116       5.836   8.734  33.707  1.00 29.43           C  
ATOM   3454  CD2 LEU C 116       5.304  10.143  35.667  1.00 17.28           C  
ATOM   3455  N   ASP C 117       2.148   5.483  34.989  1.00 32.97           N  
ATOM   3456  CA  ASP C 117       1.048   4.688  35.524  1.00 42.12           C  
ATOM   3457  C   ASP C 117       1.074   3.306  34.882  1.00 44.58           C  
ATOM   3458  O   ASP C 117       0.097   2.874  34.274  1.00 49.59           O  
ATOM   3459  CB  ASP C 117      -0.288   5.376  35.228  1.00 41.07           C  
ATOM   3460  CG  ASP C 117      -0.370   6.771  35.826  1.00 46.52           C  
ATOM   3461  OD1 ASP C 117      -1.321   7.514  35.484  1.00 50.50           O  
ATOM   3462  OD2 ASP C 117       0.510   7.124  36.641  1.00 44.29           O  
ATOM   3463  N   GLU C 118       2.205   2.626  35.011  1.00 47.59           N  
ATOM   3464  CA  GLU C 118       2.374   1.291  34.456  1.00 49.84           C  
ATOM   3465  C   GLU C 118       2.766   0.324  35.574  1.00 51.94           C  
ATOM   3466  O   GLU C 118       3.929   0.272  35.980  1.00 49.74           O  
ATOM   3467  CB  GLU C 118       3.456   1.312  33.372  1.00 51.66           C  
ATOM   3468  CG  GLU C 118       3.961  -0.060  32.959  1.00 54.38           C  
ATOM   3469  CD  GLU C 118       2.886  -0.937  32.341  1.00 55.32           C  
ATOM   3470  OE1 GLU C 118       3.167  -2.135  32.123  1.00 55.87           O  
ATOM   3471  OE2 GLU C 118       1.769  -0.436  32.069  1.00 54.00           O  
ATOM   3472  N   PRO C 119       1.793  -0.457  36.081  1.00 54.82           N  
ATOM   3473  CA  PRO C 119       1.966  -1.442  37.158  1.00 55.90           C  
ATOM   3474  C   PRO C 119       3.143  -2.404  36.985  1.00 56.13           C  
ATOM   3475  O   PRO C 119       3.566  -3.051  37.942  1.00 56.94           O  
ATOM   3476  CB  PRO C 119       0.624  -2.170  37.173  1.00 57.40           C  
ATOM   3477  CG  PRO C 119      -0.334  -1.087  36.778  1.00 57.05           C  
ATOM   3478  CD  PRO C 119       0.391  -0.436  35.622  1.00 56.10           C  
ATOM   3479  N   THR C 120       3.666  -2.498  35.767  1.00 55.99           N  
ATOM   3480  CA  THR C 120       4.796  -3.379  35.485  1.00 56.74           C  
ATOM   3481  C   THR C 120       6.070  -2.835  36.127  1.00 55.92           C  
ATOM   3482  O   THR C 120       6.955  -3.593  36.530  1.00 55.43           O  
ATOM   3483  CB  THR C 120       5.036  -3.501  33.958  1.00 58.00           C  
ATOM   3484  OG1 THR C 120       3.891  -4.100  33.336  1.00 58.01           O  
ATOM   3485  CG2 THR C 120       6.274  -4.346  33.672  1.00 58.09           C  
ATOM   3486  N   LEU C 121       6.137  -1.511  36.226  1.00 56.81           N  
ATOM   3487  CA  LEU C 121       7.292  -0.810  36.778  1.00 56.48           C  
ATOM   3488  C   LEU C 121       7.514  -0.973  38.282  1.00 56.23           C  
ATOM   3489  O   LEU C 121       6.613  -0.762  39.094  1.00 55.44           O  
ATOM   3490  CB  LEU C 121       7.190   0.675  36.422  1.00 55.09           C  
ATOM   3491  CG  LEU C 121       6.779   0.921  34.966  1.00 55.82           C  
ATOM   3492  CD1 LEU C 121       6.750   2.411  34.683  1.00 55.43           C  
ATOM   3493  CD2 LEU C 121       7.743   0.210  34.028  1.00 56.33           C  
ATOM   3494  N   ASN C 122       8.742  -1.342  38.634  1.00 55.16           N  
ATOM   3495  CA  ASN C 122       9.147  -1.550  40.019  1.00 54.37           C  
ATOM   3496  C   ASN C 122       9.036  -0.298  40.892  1.00 53.32           C  
ATOM   3497  O   ASN C 122       8.586  -0.369  42.040  1.00 52.84           O  
ATOM   3498  CB  ASN C 122      10.583  -2.075  40.041  1.00 58.26           C  
ATOM   3499  CG  ASN C 122      11.421  -1.526  38.891  1.00 60.53           C  
ATOM   3500  OD1 ASN C 122      11.645  -0.319  38.785  1.00 61.05           O  
ATOM   3501  ND2 ASN C 122      11.879  -2.418  38.017  1.00 60.20           N  
ATOM   3502  N   HIS C 123       9.457   0.845  40.352  1.00 49.49           N  
ATOM   3503  CA  HIS C 123       9.397   2.109  41.086  1.00 45.60           C  
ATOM   3504  C   HIS C 123       8.220   2.944  40.604  1.00 41.96           C  
ATOM   3505  O   HIS C 123       7.983   3.062  39.400  1.00 45.84           O  
ATOM   3506  CB  HIS C 123      10.689   2.915  40.892  1.00 44.16           C  
ATOM   3507  CG  HIS C 123      10.702   4.223  41.626  1.00 41.06           C  
ATOM   3508  ND1 HIS C 123      10.752   4.305  43.002  1.00 37.86           N  
ATOM   3509  CD2 HIS C 123      10.648   5.499  41.175  1.00 38.96           C  
ATOM   3510  CE1 HIS C 123      10.727   5.576  43.365  1.00 36.96           C  
ATOM   3511  NE2 HIS C 123      10.664   6.320  42.276  1.00 33.60           N  
ATOM   3512  N   ARG C 124       7.485   3.527  41.544  1.00 37.47           N  
ATOM   3513  CA  ARG C 124       6.342   4.354  41.188  1.00 31.12           C  
ATOM   3514  C   ARG C 124       6.665   5.841  41.295  1.00 26.69           C  
ATOM   3515  O   ARG C 124       6.907   6.367  42.382  1.00 24.30           O  
ATOM   3516  CB  ARG C 124       5.145   4.004  42.076  1.00 35.99           C  
ATOM   3517  CG  ARG C 124       4.518   2.655  41.753  1.00 37.48           C  
ATOM   3518  CD  ARG C 124       3.814   2.674  40.393  1.00 44.24           C  
ATOM   3519  NE  ARG C 124       2.887   3.804  40.279  1.00 46.77           N  
ATOM   3520  CZ  ARG C 124       1.823   3.831  39.479  1.00 48.91           C  
ATOM   3521  NH1 ARG C 124       1.533   2.786  38.714  1.00 50.30           N  
ATOM   3522  NH2 ARG C 124       1.045   4.905  39.447  1.00 49.36           N  
ATOM   3523  N   VAL C 125       6.686   6.506  40.146  1.00 20.24           N  
ATOM   3524  CA  VAL C 125       6.964   7.931  40.083  1.00 16.34           C  
ATOM   3525  C   VAL C 125       5.640   8.692  40.215  1.00 15.15           C  
ATOM   3526  O   VAL C 125       4.734   8.503  39.416  1.00 17.40           O  
ATOM   3527  CB  VAL C 125       7.620   8.308  38.730  1.00 15.00           C  
ATOM   3528  CG1 VAL C 125       7.816   9.817  38.637  1.00 14.41           C  
ATOM   3529  CG2 VAL C 125       8.959   7.587  38.578  1.00 12.78           C  
ATOM   3530  N   LYS C 126       5.531   9.539  41.233  1.00 15.14           N  
ATOM   3531  CA  LYS C 126       4.325  10.338  41.423  1.00 17.17           C  
ATOM   3532  C   LYS C 126       4.360  11.474  40.403  1.00 16.91           C  
ATOM   3533  O   LYS C 126       5.425  11.848  39.917  1.00 13.85           O  
ATOM   3534  CB  LYS C 126       4.292  10.933  42.836  1.00 18.93           C  
ATOM   3535  CG  LYS C 126       4.227   9.905  43.956  1.00 23.10           C  
ATOM   3536  CD  LYS C 126       4.028  10.582  45.309  1.00 26.77           C  
ATOM   3537  CE  LYS C 126       3.875   9.559  46.433  1.00 30.78           C  
ATOM   3538  NZ  LYS C 126       5.137   8.814  46.715  1.00 35.82           N  
ATOM   3539  N   TRP C 127       3.200  12.011  40.050  1.00 16.56           N  
ATOM   3540  CA  TRP C 127       3.201  13.127  39.112  1.00 15.45           C  
ATOM   3541  C   TRP C 127       2.112  14.119  39.432  1.00 14.49           C  
ATOM   3542  O   TRP C 127       1.113  13.805  40.090  1.00 16.17           O  
ATOM   3543  CB  TRP C 127       3.069  12.665  37.651  1.00 15.27           C  
ATOM   3544  CG  TRP C 127       1.820  11.905  37.301  1.00 18.69           C  
ATOM   3545  CD1 TRP C 127       1.663  10.544  37.276  1.00 16.18           C  
ATOM   3546  CD2 TRP C 127       0.543  12.461  36.945  1.00 17.48           C  
ATOM   3547  NE1 TRP C 127       0.375  10.224  36.927  1.00 17.48           N  
ATOM   3548  CE2 TRP C 127      -0.336  11.379  36.721  1.00 17.62           C  
ATOM   3549  CE3 TRP C 127       0.059  13.770  36.796  1.00 18.79           C  
ATOM   3550  CZ2 TRP C 127      -1.672  11.560  36.360  1.00 19.60           C  
ATOM   3551  CZ3 TRP C 127      -1.271  13.954  36.436  1.00 21.42           C  
ATOM   3552  CH2 TRP C 127      -2.124  12.849  36.223  1.00 20.58           C  
ATOM   3553  N   GLU C 128       2.327  15.339  38.977  1.00 14.20           N  
ATOM   3554  CA  GLU C 128       1.357  16.386  39.191  1.00 14.34           C  
ATOM   3555  C   GLU C 128       1.398  17.393  38.065  1.00 15.55           C  
ATOM   3556  O   GLU C 128       2.471  17.875  37.695  1.00 14.55           O  
ATOM   3557  CB  GLU C 128       1.628  17.109  40.508  1.00 16.72           C  
ATOM   3558  CG  GLU C 128       0.742  18.331  40.691  1.00 14.32           C  
ATOM   3559  CD  GLU C 128       0.933  18.998  42.039  1.00 17.92           C  
ATOM   3560  OE1 GLU C 128       0.315  20.054  42.275  1.00 20.94           O  
ATOM   3561  OE2 GLU C 128       1.698  18.467  42.864  1.00 19.07           O  
ATOM   3562  N   TYR C 129       0.220  17.700  37.528  1.00 15.59           N  
ATOM   3563  CA  TYR C 129       0.078  18.700  36.482  1.00 13.01           C  
ATOM   3564  C   TYR C 129      -0.338  19.954  37.249  1.00 15.56           C  
ATOM   3565  O   TYR C 129      -1.425  20.005  37.830  1.00 14.88           O  
ATOM   3566  CB  TYR C 129      -1.011  18.291  35.480  1.00 13.85           C  
ATOM   3567  CG  TYR C 129      -1.414  19.384  34.506  1.00 15.89           C  
ATOM   3568  CD1 TYR C 129      -0.462  20.215  33.919  1.00 12.33           C  
ATOM   3569  CD2 TYR C 129      -2.754  19.561  34.143  1.00 17.54           C  
ATOM   3570  CE1 TYR C 129      -0.835  21.199  32.979  1.00 16.44           C  
ATOM   3571  CE2 TYR C 129      -3.134  20.535  33.212  1.00 16.96           C  
ATOM   3572  CZ  TYR C 129      -2.169  21.343  32.635  1.00 18.89           C  
ATOM   3573  OH  TYR C 129      -2.537  22.268  31.689  1.00 17.08           O  
ATOM   3574  N   TYR C 130       0.556  20.935  37.280  1.00 16.57           N  
ATOM   3575  CA  TYR C 130       0.342  22.196  37.980  1.00 16.70           C  
ATOM   3576  C   TYR C 130       0.380  23.220  36.852  1.00 16.58           C  
ATOM   3577  O   TYR C 130       1.413  23.820  36.578  1.00 15.70           O  
ATOM   3578  CB  TYR C 130       1.491  22.413  38.968  1.00 17.72           C  
ATOM   3579  CG  TYR C 130       1.312  23.575  39.916  1.00 17.33           C  
ATOM   3580  CD1 TYR C 130       1.453  24.896  39.480  1.00 19.81           C  
ATOM   3581  CD2 TYR C 130       0.985  23.356  41.248  1.00 20.69           C  
ATOM   3582  CE1 TYR C 130       1.272  25.966  40.358  1.00 21.56           C  
ATOM   3583  CE2 TYR C 130       0.801  24.410  42.126  1.00 20.76           C  
ATOM   3584  CZ  TYR C 130       0.942  25.711  41.681  1.00 21.59           C  
ATOM   3585  OH  TYR C 130       0.744  26.745  42.565  1.00 23.14           O  
ATOM   3586  N   PRO C 131      -0.766  23.436  36.184  1.00 16.62           N  
ATOM   3587  CA  PRO C 131      -0.833  24.380  35.068  1.00 16.06           C  
ATOM   3588  C   PRO C 131      -0.500  25.850  35.303  1.00 15.08           C  
ATOM   3589  O   PRO C 131      -0.966  26.469  36.256  1.00 15.93           O  
ATOM   3590  CB  PRO C 131      -2.251  24.171  34.519  1.00 15.24           C  
ATOM   3591  CG  PRO C 131      -3.030  23.755  35.708  1.00 18.20           C  
ATOM   3592  CD  PRO C 131      -2.090  22.853  36.475  1.00 18.05           C  
ATOM   3593  N   LEU C 132       0.342  26.373  34.414  1.00 16.07           N  
ATOM   3594  CA  LEU C 132       0.753  27.778  34.393  1.00 19.04           C  
ATOM   3595  C   LEU C 132       0.666  28.122  32.902  1.00 18.22           C  
ATOM   3596  O   LEU C 132       1.510  27.703  32.108  1.00 20.76           O  
ATOM   3597  CB  LEU C 132       2.188  27.955  34.911  1.00 18.57           C  
ATOM   3598  CG  LEU C 132       2.384  27.748  36.420  1.00 20.17           C  
ATOM   3599  CD1 LEU C 132       3.841  27.926  36.760  1.00 19.31           C  
ATOM   3600  CD2 LEU C 132       1.530  28.735  37.219  1.00 20.47           C  
ATOM   3601  N   GLU C 133      -0.374  28.857  32.517  1.00 18.51           N  
ATOM   3602  CA  GLU C 133      -0.577  29.183  31.111  1.00 18.54           C  
ATOM   3603  C   GLU C 133       0.645  29.786  30.444  1.00 19.59           C  
ATOM   3604  O   GLU C 133       0.855  29.575  29.253  1.00 18.92           O  
ATOM   3605  CB  GLU C 133      -1.782  30.114  30.928  1.00 19.60           C  
ATOM   3606  CG  GLU C 133      -2.127  30.397  29.461  1.00 20.31           C  
ATOM   3607  CD  GLU C 133      -2.535  29.156  28.663  1.00 18.44           C  
ATOM   3608  OE1 GLU C 133      -2.740  29.288  27.440  1.00 22.18           O  
ATOM   3609  OE2 GLU C 133      -2.657  28.054  29.242  1.00 17.04           O  
ATOM   3610  N   GLU C 134       1.451  30.527  31.202  1.00 17.20           N  
ATOM   3611  CA  GLU C 134       2.667  31.128  30.641  1.00 20.62           C  
ATOM   3612  C   GLU C 134       3.563  30.059  30.001  1.00 20.65           C  
ATOM   3613  O   GLU C 134       4.249  30.321  29.003  1.00 18.77           O  
ATOM   3614  CB  GLU C 134       3.437  31.877  31.733  1.00 24.46           C  
ATOM   3615  CG  GLU C 134       3.393  31.197  33.097  1.00 35.19           C  
ATOM   3616  CD  GLU C 134       4.066  32.007  34.200  1.00 38.95           C  
ATOM   3617  OE1 GLU C 134       3.688  31.818  35.379  1.00 42.40           O  
ATOM   3618  OE2 GLU C 134       4.973  32.819  33.901  1.00 40.58           O  
ATOM   3619  N   ALA C 135       3.553  28.851  30.564  1.00 18.33           N  
ATOM   3620  CA  ALA C 135       4.365  27.762  30.012  1.00 18.55           C  
ATOM   3621  C   ALA C 135       3.814  27.304  28.659  1.00 17.33           C  
ATOM   3622  O   ALA C 135       4.567  27.063  27.718  1.00 17.02           O  
ATOM   3623  CB  ALA C 135       4.405  26.581  30.987  1.00 18.73           C  
ATOM   3624  N   SER C 136       2.494  27.180  28.570  1.00 18.40           N  
ATOM   3625  CA  SER C 136       1.853  26.755  27.329  1.00 20.85           C  
ATOM   3626  C   SER C 136       2.069  27.804  26.251  1.00 19.39           C  
ATOM   3627  O   SER C 136       2.292  27.484  25.091  1.00 20.19           O  
ATOM   3628  CB  SER C 136       0.350  26.555  27.538  1.00 21.99           C  
ATOM   3629  OG  SER C 136       0.096  25.378  28.279  1.00 22.51           O  
ATOM   3630  N   GLU C 137       1.999  29.061  26.646  1.00 19.81           N  
ATOM   3631  CA  GLU C 137       2.186  30.145  25.698  1.00 23.27           C  
ATOM   3632  C   GLU C 137       3.607  30.192  25.147  1.00 24.76           C  
ATOM   3633  O   GLU C 137       3.805  30.433  23.959  1.00 24.72           O  
ATOM   3634  CB  GLU C 137       1.829  31.472  26.362  1.00 26.13           C  
ATOM   3635  CG  GLU C 137       0.409  31.463  26.908  1.00 31.60           C  
ATOM   3636  CD  GLU C 137      -0.090  32.828  27.300  1.00 37.32           C  
ATOM   3637  OE1 GLU C 137       0.551  33.479  28.152  1.00 41.69           O  
ATOM   3638  OE2 GLU C 137      -1.133  33.245  26.752  1.00 40.98           O  
ATOM   3639  N   LEU C 138       4.596  29.952  26.002  1.00 23.28           N  
ATOM   3640  CA  LEU C 138       5.984  29.987  25.551  1.00 22.79           C  
ATOM   3641  C   LEU C 138       6.164  29.003  24.396  1.00 21.97           C  
ATOM   3642  O   LEU C 138       6.767  29.333  23.368  1.00 22.01           O  
ATOM   3643  CB  LEU C 138       6.922  29.624  26.707  1.00 23.26           C  
ATOM   3644  CG  LEU C 138       8.329  30.224  26.739  1.00 26.49           C  
ATOM   3645  CD1 LEU C 138       9.176  29.459  27.753  1.00 20.27           C  
ATOM   3646  CD2 LEU C 138       8.971  30.146  25.379  1.00 31.27           C  
ATOM   3647  N   LEU C 139       5.626  27.798  24.557  1.00 19.52           N  
ATOM   3648  CA  LEU C 139       5.730  26.769  23.527  1.00 21.26           C  
ATOM   3649  C   LEU C 139       4.951  27.207  22.289  1.00 22.19           C  
ATOM   3650  O   LEU C 139       5.426  27.089  21.163  1.00 23.83           O  
ATOM   3651  CB  LEU C 139       5.179  25.440  24.058  1.00 20.53           C  
ATOM   3652  CG  LEU C 139       5.492  24.175  23.260  1.00 25.58           C  
ATOM   3653  CD1 LEU C 139       6.992  23.911  23.279  1.00 27.32           C  
ATOM   3654  CD2 LEU C 139       4.746  22.988  23.871  1.00 26.67           C  
ATOM   3655  N   SER C 140       3.754  27.733  22.507  1.00 25.09           N  
ATOM   3656  CA  SER C 140       2.919  28.194  21.404  1.00 27.94           C  
ATOM   3657  C   SER C 140       3.648  29.285  20.607  1.00 28.24           C  
ATOM   3658  O   SER C 140       3.641  29.284  19.377  1.00 27.74           O  
ATOM   3659  CB  SER C 140       1.586  28.724  21.953  1.00 30.55           C  
ATOM   3660  OG  SER C 140       0.693  29.052  20.904  1.00 39.12           O  
ATOM   3661  N   GLU C 141       4.278  30.216  21.313  1.00 27.37           N  
ATOM   3662  CA  GLU C 141       5.015  31.294  20.663  1.00 30.78           C  
ATOM   3663  C   GLU C 141       6.139  30.688  19.820  1.00 30.69           C  
ATOM   3664  O   GLU C 141       6.406  31.139  18.708  1.00 30.82           O  
ATOM   3665  CB  GLU C 141       5.602  32.238  21.716  1.00 31.71           C  
ATOM   3666  CG  GLU C 141       6.119  33.553  21.163  1.00 40.34           C  
ATOM   3667  CD  GLU C 141       6.870  34.368  22.201  1.00 42.81           C  
ATOM   3668  OE1 GLU C 141       6.489  34.304  23.391  1.00 46.01           O  
ATOM   3669  OE2 GLU C 141       7.833  35.079  21.829  1.00 43.59           O  
ATOM   3670  N   PHE C 142       6.791  29.658  20.354  1.00 29.84           N  
ATOM   3671  CA  PHE C 142       7.871  28.985  19.645  1.00 29.87           C  
ATOM   3672  C   PHE C 142       7.426  28.443  18.292  1.00 31.24           C  
ATOM   3673  O   PHE C 142       8.114  28.619  17.284  1.00 28.69           O  
ATOM   3674  CB  PHE C 142       8.422  27.838  20.494  1.00 27.37           C  
ATOM   3675  CG  PHE C 142       9.340  26.913  19.744  1.00 27.77           C  
ATOM   3676  CD1 PHE C 142       8.916  25.639  19.373  1.00 28.97           C  
ATOM   3677  CD2 PHE C 142      10.629  27.309  19.411  1.00 27.48           C  
ATOM   3678  CE1 PHE C 142       9.768  24.773  18.679  1.00 33.05           C  
ATOM   3679  CE2 PHE C 142      11.492  26.453  18.718  1.00 27.77           C  
ATOM   3680  CZ  PHE C 142      11.064  25.187  18.352  1.00 29.32           C  
ATOM   3681  N   PHE C 143       6.277  27.779  18.265  1.00 33.16           N  
ATOM   3682  CA  PHE C 143       5.780  27.214  17.015  1.00 39.07           C  
ATOM   3683  C   PHE C 143       5.329  28.275  16.014  1.00 42.28           C  
ATOM   3684  O   PHE C 143       5.438  28.079  14.804  1.00 43.93           O  
ATOM   3685  CB  PHE C 143       4.643  26.229  17.296  1.00 39.11           C  
ATOM   3686  CG  PHE C 143       5.082  25.014  18.064  1.00 42.79           C  
ATOM   3687  CD1 PHE C 143       6.107  24.206  17.580  1.00 43.61           C  
ATOM   3688  CD2 PHE C 143       4.499  24.697  19.283  1.00 43.58           C  
ATOM   3689  CE1 PHE C 143       6.548  23.101  18.306  1.00 45.45           C  
ATOM   3690  CE2 PHE C 143       4.933  23.594  20.014  1.00 44.40           C  
ATOM   3691  CZ  PHE C 143       5.960  22.796  19.525  1.00 44.47           C  
ATOM   3692  N   LYS C 144       4.831  29.400  16.507  1.00 47.11           N  
ATOM   3693  CA  LYS C 144       4.397  30.458  15.605  1.00 52.14           C  
ATOM   3694  C   LYS C 144       5.581  31.257  15.078  1.00 54.63           C  
ATOM   3695  O   LYS C 144       5.469  31.974  14.085  1.00 54.56           O  
ATOM   3696  CB  LYS C 144       3.386  31.371  16.299  1.00 52.71           C  
ATOM   3697  CG  LYS C 144       2.006  30.731  16.485  1.00 55.60           C  
ATOM   3698  CD  LYS C 144       1.376  30.303  15.146  1.00 57.35           C  
ATOM   3699  CE  LYS C 144       1.998  29.017  14.590  1.00 58.62           C  
ATOM   3700  NZ  LYS C 144       1.555  28.697  13.203  1.00 58.66           N  
ATOM   3701  N   LYS C 145       6.720  31.124  15.750  1.00 57.26           N  
ATOM   3702  CA  LYS C 145       7.936  31.804  15.338  1.00 59.93           C  
ATOM   3703  C   LYS C 145       8.469  31.008  14.156  1.00 61.95           C  
ATOM   3704  O   LYS C 145       8.930  31.571  13.165  1.00 61.29           O  
ATOM   3705  CB  LYS C 145       8.957  31.800  16.481  1.00 61.66           C  
ATOM   3706  CG  LYS C 145      10.307  32.419  16.139  1.00 64.07           C  
ATOM   3707  CD  LYS C 145      11.311  32.212  17.275  1.00 65.70           C  
ATOM   3708  CE  LYS C 145      12.707  32.704  16.897  1.00 66.78           C  
ATOM   3709  NZ  LYS C 145      13.706  32.471  17.983  1.00 65.99           N  
ATOM   3710  N   LEU C 146       8.388  29.686  14.272  1.00 64.42           N  
ATOM   3711  CA  LEU C 146       8.848  28.791  13.219  1.00 69.04           C  
ATOM   3712  C   LEU C 146       7.923  28.870  12.011  1.00 71.94           C  
ATOM   3713  O   LEU C 146       8.184  28.259  10.974  1.00 72.61           O  
ATOM   3714  CB  LEU C 146       8.904  27.351  13.729  1.00 68.75           C  
ATOM   3715  CG  LEU C 146       9.893  27.066  14.859  1.00 69.40           C  
ATOM   3716  CD1 LEU C 146       9.819  25.594  15.222  1.00 69.28           C  
ATOM   3717  CD2 LEU C 146      11.305  27.438  14.426  1.00 69.51           C  
ATOM   3718  N   ARG C 147       6.835  29.617  12.159  1.00 75.08           N  
ATOM   3719  CA  ARG C 147       5.880  29.795  11.076  1.00 77.55           C  
ATOM   3720  C   ARG C 147       6.490  30.735  10.048  1.00 79.13           C  
ATOM   3721  O   ARG C 147       6.640  30.388   8.876  1.00 79.81           O  
ATOM   3722  CB  ARG C 147       4.583  30.405  11.607  1.00 78.43           C  
ATOM   3723  CG  ARG C 147       3.630  30.871  10.515  1.00 79.59           C  
ATOM   3724  CD  ARG C 147       2.431  31.594  11.103  1.00 80.93           C  
ATOM   3725  NE  ARG C 147       1.482  32.023  10.077  1.00 82.02           N  
ATOM   3726  CZ  ARG C 147       0.807  31.195   9.284  1.00 82.65           C  
ATOM   3727  NH1 ARG C 147       0.971  29.883   9.392  1.00 83.30           N  
ATOM   3728  NH2 ARG C 147      -0.039  31.678   8.385  1.00 82.90           N  
ATOM   3729  N   ASN C 148       6.843  31.930  10.508  1.00 80.82           N  
ATOM   3730  CA  ASN C 148       7.432  32.950   9.654  1.00 82.76           C  
ATOM   3731  C   ASN C 148       8.878  32.614   9.313  1.00 84.20           C  
ATOM   3732  O   ASN C 148       9.437  33.134   8.347  1.00 85.17           O  
ATOM   3733  CB  ASN C 148       7.364  34.306  10.355  1.00 82.70           C  
ATOM   3734  CG  ASN C 148       5.983  34.606  10.903  1.00 82.06           C  
ATOM   3735  OD1 ASN C 148       5.486  33.906  11.786  1.00 81.60           O  
ATOM   3736  ND2 ASN C 148       5.351  35.649  10.378  1.00 82.13           N  
ATOM   3737  N   ASN C 149       9.481  31.743  10.115  1.00 85.82           N  
ATOM   3738  CA  ASN C 149      10.863  31.331   9.900  1.00 87.65           C  
ATOM   3739  C   ASN C 149      11.002  30.564   8.587  1.00 88.41           C  
ATOM   3740  O   ASN C 149      12.058  30.587   7.953  1.00 88.83           O  
ATOM   3741  CB  ASN C 149      11.337  30.459  11.069  1.00 88.00           C  
ATOM   3742  CG  ASN C 149      12.745  29.920  10.869  1.00 88.09           C  
ATOM   3743  OD1 ASN C 149      12.996  29.125   9.963  1.00 88.55           O  
ATOM   3744  ND2 ASN C 149      13.669  30.354  11.718  1.00 87.73           N  
ATOM   3745  N   ILE C 150       9.931  29.890   8.181  1.00 89.57           N  
ATOM   3746  CA  ILE C 150       9.946  29.113   6.949  1.00 90.17           C  
ATOM   3747  C   ILE C 150       9.696  29.978   5.720  1.00 90.39           C  
ATOM   3748  O   ILE C 150       8.589  30.480   5.510  1.00 89.86           O  
ATOM   3749  CB  ILE C 150       8.888  27.989   6.983  1.00 90.60           C  
ATOM   3750  CG1 ILE C 150       9.141  27.070   8.182  1.00 90.56           C  
ATOM   3751  CG2 ILE C 150       8.936  27.190   5.685  1.00 91.41           C  
ATOM   3752  CD1 ILE C 150      10.510  26.410   8.182  1.00 90.31           C  
ATOM   3753  N   ILE C 151      10.739  30.141   4.912  1.00 90.69           N  
ATOM   3754  CA  ILE C 151      10.664  30.934   3.693  1.00 90.64           C  
ATOM   3755  C   ILE C 151      11.068  30.086   2.488  1.00 90.50           C  
ATOM   3756  O   ILE C 151      12.002  30.483   1.761  1.00 90.29           O  
ATOM   3757  CB  ILE C 151      11.588  32.175   3.780  1.00 90.67           C  
ATOM   3758  CG1 ILE C 151      13.003  31.747   4.183  1.00 90.40           C  
ATOM   3759  CG2 ILE C 151      11.024  33.175   4.780  1.00 90.44           C  
ATOM   3760  CD1 ILE C 151      13.995  32.891   4.260  1.00 90.20           C  
ATOM   3761  OXT ILE C 151      10.435  29.028   2.287  1.00 89.97           O  
TER    3762      ILE C 151                                                      
END
MOLECULE T0461.pdb
ATOM      1  N   GLU    16      19.319  11.894  58.181  1.00 47.03           N  
ATOM      2  CA  GLU    16      18.212  11.089  57.593  1.00 47.23           C  
ATOM      4  CB  GLU    16      18.010   9.793  58.377  1.00 47.32           C  
ATOM      7  CG  GLU    16      17.576   8.619  57.509  1.00 48.39           C  
ATOM     10  CD  GLU    16      17.064   7.416  58.327  1.00 50.46           C  
ATOM     11  OE1 GLU    16      16.178   6.689  57.811  1.00 51.91           O  
ATOM     12  OE2 GLU    16      17.526   7.196  59.479  1.00 50.93           O  
ATOM     13  C   GLU    16      16.896  11.864  57.561  1.00 47.09           C  
ATOM     14  O   GLU    16      15.891  11.376  57.001  1.00 48.08           O  
ATOM     18  N   ASN    17      16.888  13.066  58.143  1.00 46.06           N  
ATOM     19  CA  ASN    17      15.679  13.870  58.188  1.00 45.28           C  
ATOM     21  CB  ASN    17      15.631  14.676  59.487  1.00 45.17           C  
ATOM     24  CG  ASN    17      14.246  15.250  59.773  1.00 44.92           C  
ATOM     25  OD1 ASN    17      13.421  15.378  58.885  1.00 45.51           O  
ATOM     26  ND2 ASN    17      13.989  15.591  61.023  1.00 45.12           N  
ATOM     29  C   ASN    17      15.619  14.792  56.990  1.00 44.97           C  
ATOM     30  O   ASN    17      16.071  15.922  57.046  1.00 44.78           O  
ATOM     32  N   LEU    18      15.026  14.320  55.910  1.00 45.02           N  
ATOM     33  CA  LEU    18      14.988  15.101  54.659  1.00 45.41           C  
ATOM     35  CB  LEU    18      14.792  14.167  53.453  1.00 45.35           C  
ATOM     38  CG  LEU    18      15.875  13.083  53.322  1.00 45.26           C  
ATOM     40  CD1 LEU    18      15.492  12.097  52.210  1.00 45.69           C  
ATOM     44  CD2 LEU    18      17.267  13.703  53.084  1.00 42.76           C  
ATOM     48  C   LEU    18      13.920  16.202  54.656  1.00 45.40           C  
ATOM     49  O   LEU    18      12.854  16.047  55.244  1.00 46.03           O  
ATOM     51  N   TYR    19      14.208  17.291  53.954  1.00 45.10           N  
ATOM     52  CA  TYR    19      13.361  18.473  53.903  1.00 44.79           C  
ATOM     54  CB  TYR    19      14.284  19.669  53.829  1.00 45.04           C  
ATOM     57  CG  TYR    19      13.663  21.040  53.814  1.00 45.91           C  
ATOM     58  CD1 TYR    19      13.769  21.878  54.930  1.00 46.50           C  
ATOM     60  CE1 TYR    19      13.223  23.142  54.930  1.00 46.23           C  
ATOM     62  CZ  TYR    19      12.595  23.603  53.806  1.00 45.82           C  
ATOM     63  OH  TYR    19      12.078  24.858  53.838  1.00 47.34           O  
ATOM     65  CE2 TYR    19      12.478  22.813  52.668  1.00 46.79           C  
ATOM     67  CD2 TYR    19      13.017  21.538  52.672  1.00 46.25           C  
ATOM     69  C   TYR    19      12.486  18.434  52.655  1.00 45.02           C  
ATOM     70  O   TYR    19      12.973  18.134  51.545  1.00 44.56           O  
ATOM     72  N   PHE    20      11.200  18.768  52.836  1.00 45.35           N  
ATOM     73  CA  PHE    20      10.180  18.735  51.761  1.00 44.99           C  
ATOM     75  CB  PHE    20       8.875  18.070  52.229  1.00 44.60           C  
ATOM     78  CG  PHE    20       8.967  16.583  52.430  1.00 44.31           C  
ATOM     79  CD1 PHE    20       8.814  16.023  53.683  1.00 45.43           C  
ATOM     81  CE1 PHE    20       8.871  14.634  53.877  1.00 44.99           C  
ATOM     83  CZ  PHE    20       9.077  13.820  52.843  1.00 43.54           C  
ATOM     85  CE2 PHE    20       9.199  14.351  51.588  1.00 44.96           C  
ATOM     87  CD2 PHE    20       9.152  15.735  51.379  1.00 44.56           C  
ATOM     89  C   PHE    20       9.859  20.151  51.339  1.00 44.84           C  
ATOM     90  O   PHE    20       9.575  20.984  52.162  1.00 45.26           O  
ATOM     92  N   GLN    21       9.875  20.414  50.048  1.00 45.39           N  
ATOM     93  CA  GLN    21       9.553  21.743  49.542  1.00 45.85           C  
ATOM     95  CB  GLN    21       9.966  21.882  48.065  1.00 46.10           C  
ATOM     98  CG  GLN    21      11.462  21.638  47.776  1.00 45.85           C  
ATOM    101  CD  GLN    21      12.355  22.618  48.495  1.00 46.50           C  
ATOM    102  OE1 GLN    21      12.212  23.845  48.353  1.00 47.26           O  
ATOM    103  NE2 GLN    21      13.273  22.092  49.288  1.00 45.90           N  
ATOM    106  C   GLN    21       8.049  22.035  49.714  1.00 46.07           C  
ATOM    107  O   GLN    21       7.198  21.166  49.469  1.00 45.86           O  
ATOM    109  N   SER    22       7.741  23.259  50.150  1.00 45.86           N  
ATOM    110  CA  SER    22       6.375  23.680  50.384  1.00 45.60           C  
ATOM    112  CB  SER    22       6.366  24.830  51.367  1.00 45.59           C  
ATOM    115  OG  SER    22       6.782  26.037  50.750  1.00 46.30           O  
ATOM    117  C   SER    22       5.742  24.134  49.088  1.00 45.80           C  
ATOM    118  O   SER    22       6.407  24.114  48.046  1.00 45.84           O  
ATOM    120  N   MET    23       4.473  24.560  49.153  1.00 46.02           N  
ATOM    121  CA  MET    23       3.772  25.115  47.983  1.00 46.05           C  
ATOM    123  CB  MET    23       2.313  25.460  48.298  1.00 46.56           C  
ATOM    126  CG  MET    23       1.275  24.330  48.059  1.00 48.82           C  
ATOM    129  SD  MET    23       1.254  23.496  46.412  1.00 52.49           S  
ATOM    130  CE  MET    23      -0.396  22.776  46.537  1.00 50.38           C  
ATOM    134  C   MET    23       4.432  26.367  47.439  1.00 45.55           C  
ATOM    135  O   MET    23       4.601  26.477  46.236  1.00 45.57           O  
ATOM    137  N   GLU    24       4.773  27.312  48.309  1.00 45.12           N  
ATOM    138  CA  GLU    24       5.405  28.529  47.862  1.00 45.24           C  
ATOM    140  CB  GLU    24       5.574  29.505  49.001  1.00 45.00           C  
ATOM    143  CG  GLU    24       4.249  30.004  49.540  1.00 45.52           C  
ATOM    146  CD  GLU    24       4.420  31.305  50.323  1.00 47.26           C  
ATOM    147  OE1 GLU    24       5.446  31.973  50.070  1.00 48.66           O  
ATOM    148  OE2 GLU    24       3.543  31.676  51.171  1.00 46.60           O  
ATOM    149  C   GLU    24       6.756  28.195  47.248  1.00 45.58           C  
ATOM    150  O   GLU    24       7.118  28.700  46.165  1.00 45.97           O  
ATOM    152  N   GLU    25       7.499  27.321  47.916  1.00 45.42           N  
ATOM    153  CA  GLU    25       8.791  26.893  47.383  1.00 45.38           C  
ATOM    155  CB  GLU    25       9.527  26.016  48.395  1.00 45.48           C  
ATOM    158  CG  GLU    25       9.801  26.759  49.699  1.00 46.23           C  
ATOM    161  CD  GLU    25      10.373  25.873  50.810  1.00 47.64           C  
ATOM    162  OE1 GLU    25       9.890  24.719  51.016  1.00 46.52           O  
ATOM    163  OE2 GLU    25      11.298  26.364  51.498  1.00 48.29           O  
ATOM    164  C   GLU    25       8.695  26.205  46.022  1.00 44.72           C  
ATOM    165  O   GLU    25       9.574  26.385  45.200  1.00 44.67           O  
ATOM    167  N   THR    26       7.633  25.425  45.805  1.00 44.33           N  
ATOM    168  CA  THR    26       7.333  24.809  44.497  1.00 43.62           C  
ATOM    170  CB  THR    26       6.097  23.810  44.583  1.00 43.61           C  
ATOM    172  OG1 THR    26       6.387  22.773  45.511  1.00 42.09           O  
ATOM    174  CG2 THR    26       5.748  23.157  43.247  1.00 42.42           C  
ATOM    178  C   THR    26       7.092  25.942  43.492  1.00 43.04           C  
ATOM    179  O   THR    26       7.712  25.993  42.437  1.00 42.50           O  
ATOM    181  N   GLU    27       6.220  26.875  43.843  1.00 42.37           N  
ATOM    182  CA  GLU    27       5.971  28.002  42.978  1.00 42.31           C  
ATOM    184  CB  GLU    27       5.035  29.005  43.622  1.00 42.84           C  
ATOM    187  CG  GLU    27       3.580  28.566  43.707  1.00 44.60           C  
ATOM    190  CD  GLU    27       2.700  29.690  44.267  1.00 47.31           C  
ATOM    191  OE1 GLU    27       3.193  30.857  44.272  1.00 48.72           O  
ATOM    192  OE2 GLU    27       1.529  29.432  44.703  1.00 48.41           O  
ATOM    193  C   GLU    27       7.270  28.692  42.631  1.00 40.95           C  
ATOM    194  O   GLU    27       7.497  29.041  41.480  1.00 41.59           O  
ATOM    196  N   LYS    28       8.126  28.886  43.622  1.00 39.03           N  
ATOM    197  CA  LYS    28       9.440  29.455  43.359  1.00 37.62           C  
ATOM    199  CB  LYS    28      10.250  29.534  44.641  1.00 37.50           C  
ATOM    202  CG  LYS    28      11.590  30.230  44.447  1.00 38.41           C  
ATOM    205  CD  LYS    28      12.753  29.466  45.069  1.00 39.23           C  
ATOM    208  CE  LYS    28      12.679  29.456  46.565  1.00 38.91           C  
ATOM    211  NZ  LYS    28      13.578  28.418  47.073  1.00 40.24           N  
ATOM    215  C   LYS    28      10.246  28.672  42.302  1.00 35.90           C  
ATOM    216  O   LYS    28      10.746  29.267  41.371  1.00 36.93           O  
ATOM    218  N   TRP    29      10.371  27.357  42.443  1.00 33.27           N  
ATOM    219  CA  TRP    29      11.165  26.570  41.498  1.00 31.54           C  
ATOM    221  CB  TRP    29      11.338  25.115  41.957  1.00 30.99           C  
ATOM    224  CG  TRP    29      11.998  24.926  43.278  1.00 30.44           C  
ATOM    225  CD1 TRP    29      11.570  24.110  44.281  1.00 30.13           C  
ATOM    227  NE1 TRP    29      12.435  24.175  45.351  1.00 30.02           N  
ATOM    229  CE2 TRP    29      13.444  25.050  45.056  1.00 29.08           C  
ATOM    230  CD2 TRP    29      13.206  25.551  43.764  1.00 29.84           C  
ATOM    231  CE3 TRP    29      14.106  26.479  43.230  1.00 30.17           C  
ATOM    233  CZ3 TRP    29      15.182  26.878  43.993  1.00 29.10           C  
ATOM    235  CH2 TRP    29      15.381  26.365  45.270  1.00 28.82           C  
ATOM    237  CZ2 TRP    29      14.522  25.453  45.820  1.00 28.69           C  
ATOM    239  C   TRP    29      10.577  26.553  40.093  1.00 30.66           C  
ATOM    240  O   TRP    29      11.321  26.503  39.114  1.00 30.04           O  
ATOM    242  N   MET    30       9.250  26.560  39.994  1.00 29.83           N  
ATOM    243  CA  MET    30       8.583  26.606  38.693  1.00 29.32           C  
ATOM    245  CB  MET    30       7.080  26.363  38.827  1.00 29.13           C  
ATOM    248  CG  MET    30       6.695  24.908  39.105  1.00 28.73           C  
ATOM    251  SD  MET    30       7.113  23.702  37.840  1.00 25.62           S  
ATOM    252  CE  MET    30       6.050  24.188  36.496  1.00 25.40           C  
ATOM    256  C   MET    30       8.816  27.922  37.964  1.00 28.82           C  
ATOM    257  O   MET    30       8.940  27.927  36.765  1.00 28.66           O  
ATOM    259  N   GLU    31       8.873  29.027  38.689  1.00 28.72           N  
ATOM    260  CA  GLU    31       9.214  30.321  38.090  1.00 29.06           C  
ATOM    262  CB  GLU    31       9.174  31.465  39.137  1.00 29.45           C  
ATOM    265  CG  GLU    31       7.991  32.434  39.044  1.00 29.57           C  
ATOM    268  CD  GLU    31       7.831  33.294  40.339  1.00 33.21           C  
ATOM    269  OE1 GLU    31       7.467  34.564  40.270  1.00 32.31           O  
ATOM    270  OE2 GLU    31       8.075  32.684  41.452  1.00 35.33           O  
ATOM    271  C   GLU    31      10.604  30.262  37.479  1.00 28.87           C  
ATOM    272  O   GLU    31      10.827  30.752  36.382  1.00 28.74           O  
ATOM    274  N   GLU    32      11.544  29.670  38.205  1.00 28.87           N  
ATOM    275  CA  GLU    32      12.909  29.533  37.701  1.00 29.07           C  
ATOM    277  CB  GLU    32      13.876  29.003  38.777  1.00 29.29           C  
ATOM    280  CG  GLU    32      15.319  29.531  38.660  1.00 30.35           C  
ATOM    283  CD  GLU    32      16.038  29.670  40.034  1.00 32.92           C  
ATOM    284  OE1 GLU    32      16.446  28.584  40.580  1.00 33.02           O  
ATOM    285  OE2 GLU    32      16.223  30.868  40.532  1.00 32.31           O  
ATOM    286  C   GLU    32      12.932  28.636  36.474  1.00 29.00           C  
ATOM    287  O   GLU    32      13.630  28.954  35.536  1.00 29.87           O  
ATOM    289  N   ALA    33      12.176  27.534  36.469  1.00 28.65           N  
ATOM    290  CA  ALA    33      12.074  26.677  35.272  1.00 28.41           C  
ATOM    292  CB  ALA    33      11.272  25.376  35.580  1.00 28.13           C  
ATOM    296  C   ALA    33      11.467  27.433  34.073  1.00 27.98           C  
ATOM    297  O   ALA    33      11.779  27.140  32.919  1.00 27.17           O  
ATOM    299  N   MET    34      10.613  28.412  34.367  1.00 27.93           N  
ATOM    300  CA  MET    34       9.948  29.219  33.339  1.00 28.14           C  
ATOM    302  CB  MET    34       8.803  30.030  33.949  1.00 28.21           C  
ATOM    305  CG  MET    34       7.517  29.250  34.113  1.00 28.80           C  
ATOM    308  SD  MET    34       6.705  28.872  32.536  1.00 30.50           S  
ATOM    309  CE  MET    34       6.132  30.522  32.012  1.00 29.12           C  
ATOM    313  C   MET    34      10.916  30.175  32.664  1.00 28.10           C  
ATOM    314  O   MET    34      10.875  30.374  31.449  1.00 27.67           O  
ATOM    316  N   HIS    35      11.789  30.765  33.467  1.00 28.28           N  
ATOM    317  CA  HIS    35      12.821  31.630  32.951  1.00 28.33           C  
ATOM    319  CB  HIS    35      13.581  32.265  34.112  1.00 28.41           C  
ATOM    322  CG  HIS    35      12.858  33.425  34.730  1.00 29.93           C  
ATOM    323  ND1 HIS    35      11.876  34.132  34.062  1.00 31.57           N  
ATOM    325  CE1 HIS    35      11.437  35.118  34.832  1.00 31.30           C  
ATOM    327  NE2 HIS    35      12.092  35.071  35.978  1.00 31.32           N  
ATOM    329  CD2 HIS    35      12.985  34.021  35.943  1.00 31.00           C  
ATOM    331  C   HIS    35      13.742  30.839  32.027  1.00 28.17           C  
ATOM    332  O   HIS    35      14.065  31.289  30.934  1.00 27.82           O  
ATOM    334  N   MET    36      14.123  29.641  32.458  1.00 28.15           N  
ATOM    335  CA  MET    36      14.961  28.760  31.661  1.00 28.40           C  
ATOM    337  CB  MET    36      15.322  27.506  32.450  1.00 28.40           C  
ATOM    340  CG  MET    36      16.315  27.796  33.560  1.00 29.25           C  
ATOM    343  SD  MET    36      16.813  26.309  34.428  1.00 31.57           S  
ATOM    344  CE  MET    36      18.067  25.576  33.340  1.00 32.53           C  
ATOM    348  C   MET    36      14.308  28.388  30.336  1.00 28.59           C  
ATOM    349  O   MET    36      14.979  28.316  29.303  1.00 28.44           O  
ATOM    351  N   ALA    37      12.999  28.161  30.359  1.00 28.78           N  
ATOM    352  CA  ALA    37      12.272  27.908  29.139  1.00 28.45           C  
ATOM    354  CB  ALA    37      10.865  27.523  29.464  1.00 28.21           C  
ATOM    358  C   ALA    37      12.350  29.138  28.203  1.00 28.53           C  
ATOM    359  O   ALA    37      12.535  28.976  26.991  1.00 28.74           O  
ATOM    361  N   LYS    38      12.254  30.353  28.753  1.00 28.46           N  
ATOM    362  CA  LYS    38      12.479  31.585  27.952  1.00 28.77           C  
ATOM    364  CB  LYS    38      12.362  32.855  28.810  1.00 28.84           C  
ATOM    367  CG  LYS    38      11.173  33.763  28.490  1.00 29.78           C  
ATOM    370  CD  LYS    38      10.670  34.538  29.775  1.00 31.42           C  
ATOM    373  CE  LYS    38       9.790  33.635  30.740  1.00 31.00           C  
ATOM    376  NZ  LYS    38       9.628  34.146  32.144  1.00 30.04           N  
ATOM    380  C   LYS    38      13.844  31.602  27.254  1.00 28.67           C  
ATOM    381  O   LYS    38      13.935  31.826  26.059  1.00 28.60           O  
ATOM    383  N   GLU    39      14.903  31.388  28.029  1.00 28.92           N  
ATOM    384  CA  GLU    39      16.255  31.241  27.491  1.00 29.07           C  
ATOM    386  CB  GLU    39      17.256  30.896  28.615  1.00 29.32           C  
ATOM    389  CG  GLU    39      17.683  32.092  29.525  1.00 29.97           C  
ATOM    392  CD  GLU    39      18.618  31.675  30.698  1.00 30.95           C  
ATOM    393  OE1 GLU    39      18.395  30.602  31.336  1.00 31.36           O  
ATOM    394  OE2 GLU    39      19.579  32.435  30.976  1.00 30.64           O  
ATOM    395  C   GLU    39      16.323  30.161  26.391  1.00 29.31           C  
ATOM    396  O   GLU    39      16.994  30.352  25.385  1.00 29.93           O  
ATOM    398  N   ALA    40      15.655  29.025  26.568  1.00 29.26           N  
ATOM    399  CA  ALA    40      15.675  27.990  25.538  1.00 29.14           C  
ATOM    401  CB  ALA    40      14.954  26.733  26.023  1.00 29.09           C  
ATOM    405  C   ALA    40      15.052  28.523  24.233  1.00 29.31           C  
ATOM    406  O   ALA    40      15.647  28.416  23.135  1.00 29.24           O  
ATOM    408  N   LEU    41      13.866  29.115  24.357  1.00 29.40           N  
ATOM    409  CA  LEU    41      13.176  29.725  23.208  1.00 29.34           C  
ATOM    411  CB  LEU    41      12.006  30.573  23.716  1.00 29.30           C  
ATOM    414  CG  LEU    41      11.070  31.167  22.677  1.00 28.71           C  
ATOM    416  CD1 LEU    41      10.148  30.062  22.197  1.00 28.68           C  
ATOM    420  CD2 LEU    41      10.302  32.340  23.267  1.00 27.42           C  
ATOM    424  C   LEU    41      14.117  30.616  22.372  1.00 29.48           C  
ATOM    425  O   LEU    41      14.211  30.475  21.134  1.00 29.85           O  
ATOM    427  N   GLU    42      14.821  31.511  23.067  1.00 29.00           N  
ATOM    428  CA  GLU    42      15.649  32.517  22.438  1.00 28.74           C  
ATOM    430  CB  GLU    42      15.908  33.598  23.449  1.00 28.67           C  
ATOM    433  CG  GLU    42      14.645  34.363  23.746  1.00 29.55           C  
ATOM    436  CD  GLU    42      14.781  35.250  24.971  1.00 31.30           C  
ATOM    437  OE1 GLU    42      15.008  34.664  26.080  1.00 30.85           O  
ATOM    438  OE2 GLU    42      14.659  36.515  24.804  1.00 30.70           O  
ATOM    439  C   GLU    42      16.957  31.966  21.908  1.00 28.87           C  
ATOM    440  O   GLU    42      17.677  32.661  21.201  1.00 28.72           O  
ATOM    442  N   ASN    43      17.266  30.718  22.268  1.00 29.31           N  
ATOM    443  CA  ASN    43      18.369  29.949  21.660  1.00 29.26           C  
ATOM    445  CB  ASN    43      19.164  29.173  22.728  1.00 29.03           C  
ATOM    448  CG  ASN    43      19.818  30.083  23.766  1.00 29.03           C  
ATOM    449  OD1 ASN    43      20.204  31.217  23.469  1.00 28.55           O  
ATOM    450  ND2 ASN    43      19.954  29.576  24.993  1.00 28.89           N  
ATOM    453  C   ASN    43      17.872  28.958  20.602  1.00 29.20           C  
ATOM    454  O   ASN    43      18.569  27.989  20.314  1.00 29.62           O  
ATOM    456  N   THR    44      16.686  29.195  20.033  1.00 28.87           N  
ATOM    457  CA  THR    44      16.102  28.289  19.041  1.00 28.84           C  
ATOM    459  CB  THR    44      16.897  28.318  17.748  1.00 28.74           C  
ATOM    461  OG1 THR    44      17.471  29.619  17.586  1.00 29.50           O  
ATOM    463  CG2 THR    44      15.986  27.971  16.552  1.00 28.77           C  
ATOM    467  C   THR    44      16.009  26.828  19.506  1.00 28.90           C  
ATOM    468  O   THR    44      16.232  25.893  18.716  1.00 28.57           O  
ATOM    470  N   GLU    45      15.692  26.641  20.789  1.00 28.78           N  
ATOM    471  CA  GLU    45      15.473  25.302  21.339  1.00 28.92           C  
ATOM    473  CB  GLU    45      16.415  25.012  22.521  1.00 28.92           C  
ATOM    476  CG  GLU    45      17.931  25.000  22.196  1.00 29.45           C  
ATOM    479  CD  GLU    45      18.448  23.676  21.635  1.00 29.36           C  
ATOM    480  OE1 GLU    45      19.688  23.562  21.442  1.00 27.01           O  
ATOM    481  OE2 GLU    45      17.612  22.771  21.370  1.00 30.17           O  
ATOM    482  C   GLU    45      14.006  25.190  21.777  1.00 28.65           C  
ATOM    483  O   GLU    45      13.339  26.213  22.050  1.00 29.00           O  
ATOM    485  N   VAL    46      13.501  23.955  21.814  1.00 27.84           N  
ATOM    486  CA  VAL    46      12.162  23.715  22.317  1.00 27.20           C  
ATOM    488  CB  VAL    46      11.844  22.202  22.430  1.00 27.04           C  
ATOM    490  CG1 VAL    46      10.470  22.021  22.949  1.00 26.48           C  
ATOM    494  CG2 VAL    46      11.994  21.495  21.085  1.00 25.84           C  
ATOM    498  C   VAL    46      12.218  24.332  23.700  1.00 26.94           C  
ATOM    499  O   VAL    46      13.138  24.032  24.430  1.00 27.21           O  
ATOM    501  N   PRO    47      11.286  25.236  24.048  1.00 26.78           N  
ATOM    502  CA  PRO    47      11.296  25.903  25.373  1.00 26.70           C  
ATOM    504  CB  PRO    47      10.367  27.113  25.179  1.00 26.66           C  
ATOM    507  CG  PRO    47       9.422  26.670  24.121  1.00 27.05           C  
ATOM    510  CD  PRO    47      10.184  25.723  23.207  1.00 26.93           C  
ATOM    513  C   PRO    47      10.822  25.037  26.522  1.00 26.24           C  
ATOM    514  O   PRO    47       9.673  25.088  26.918  1.00 26.00           O  
ATOM    515  N   VAL    48      11.735  24.233  27.027  1.00 26.62           N  
ATOM    516  CA  VAL    48      11.513  23.417  28.200  1.00 27.16           C  
ATOM    518  CB  VAL    48      11.457  21.880  27.852  1.00 27.41           C  
ATOM    520  CG1 VAL    48      11.253  21.035  29.132  1.00 26.53           C  
ATOM    524  CG2 VAL    48      10.393  21.571  26.783  1.00 25.65           C  
ATOM    528  C   VAL    48      12.716  23.717  29.106  1.00 27.85           C  
ATOM    529  O   VAL    48      13.887  23.614  28.672  1.00 28.19           O  
ATOM    531  N   GLY    49      12.435  24.143  30.334  1.00 27.89           N  
ATOM    532  CA  GLY    49      13.460  24.283  31.361  1.00 27.79           C  
ATOM    535  C   GLY    49      13.077  23.403  32.544  1.00 27.95           C  
ATOM    536  O   GLY    49      11.895  23.182  32.778  1.00 28.14           O  
ATOM    538  N   CYS    50      14.052  22.876  33.284  1.00 27.93           N  
ATOM    539  CA  CYS    50      13.715  22.173  34.504  1.00 28.84           C  
ATOM    541  CB  CYS    50      13.297  20.749  34.174  1.00 28.84           C  
ATOM    544  SG  CYS    50      14.643  19.606  34.018  1.00 33.39           S  
ATOM    546  C   CYS    50      14.794  22.187  35.602  1.00 28.72           C  
ATOM    547  O   CYS    50      15.972  22.404  35.318  1.00 28.99           O  
ATOM    549  N   LEU    51      14.348  21.985  36.849  1.00 28.66           N  
ATOM    550  CA  LEU    51      15.194  21.936  38.050  1.00 28.44           C  
ATOM    552  CB  LEU    51      14.880  23.128  38.954  1.00 28.29           C  
ATOM    555  CG  LEU    51      15.232  24.521  38.431  1.00 28.29           C  
ATOM    557  CD1 LEU    51      14.136  25.489  38.675  1.00 29.32           C  
ATOM    561  CD2 LEU    51      16.480  25.050  39.095  1.00 30.45           C  
ATOM    565  C   LEU    51      14.956  20.617  38.827  1.00 28.35           C  
ATOM    566  O   LEU    51      13.876  20.048  38.798  1.00 28.95           O  
ATOM    568  N   MET    52      15.958  20.126  39.526  1.00 27.97           N  
ATOM    569  CA  MET    52      15.745  19.011  40.400  1.00 28.22           C  
ATOM    571  CB  MET    52      16.413  17.765  39.825  1.00 28.57           C  
ATOM    574  CG  MET    52      15.607  17.113  38.742  1.00 29.75           C  
ATOM    577  SD  MET    52      16.528  15.808  37.882  1.00 30.98           S  
ATOM    578  CE  MET    52      16.168  14.414  38.917  1.00 33.55           C  
ATOM    582  C   MET    52      16.255  19.354  41.807  1.00 28.12           C  
ATOM    583  O   MET    52      17.427  19.709  42.002  1.00 27.75           O  
ATOM    585  N   VAL    53      15.354  19.242  42.781  1.00 27.75           N  
ATOM    586  CA  VAL    53      15.642  19.628  44.149  1.00 27.86           C  
ATOM    588  CB  VAL    53      14.603  20.664  44.634  1.00 27.43           C  
ATOM    590  CG1 VAL    53      14.756  20.937  46.109  1.00 27.32           C  
ATOM    594  CG2 VAL    53      14.729  21.953  43.833  1.00 27.25           C  
ATOM    598  C   VAL    53      15.710  18.395  45.089  1.00 28.27           C  
ATOM    599  O   VAL    53      14.819  17.559  45.116  1.00 28.02           O  
ATOM    601  N   TYR    54      16.790  18.308  45.863  1.00 28.71           N  
ATOM    602  CA  TYR    54      16.978  17.239  46.855  1.00 28.55           C  
ATOM    604  CB  TYR    54      18.085  16.279  46.430  1.00 28.75           C  
ATOM    607  CG  TYR    54      18.551  15.359  47.499  1.00 27.40           C  
ATOM    608  CD1 TYR    54      17.820  14.230  47.830  1.00 28.08           C  
ATOM    610  CE1 TYR    54      18.244  13.355  48.820  1.00 28.43           C  
ATOM    612  CZ  TYR    54      19.430  13.620  49.480  1.00 29.94           C  
ATOM    613  OH  TYR    54      19.905  12.759  50.454  1.00 32.14           O  
ATOM    615  CE2 TYR    54      20.192  14.739  49.135  1.00 29.42           C  
ATOM    617  CD2 TYR    54      19.745  15.591  48.148  1.00 27.87           C  
ATOM    619  C   TYR    54      17.366  17.869  48.152  1.00 28.27           C  
ATOM    620  O   TYR    54      18.279  18.662  48.173  1.00 28.82           O  
ATOM    622  N   ASN    55      16.677  17.488  49.221  1.00 28.12           N  
ATOM    623  CA  ASN    55      16.918  18.006  50.563  1.00 28.03           C  
ATOM    625  CB  ASN    55      18.059  17.234  51.242  1.00 28.30           C  
ATOM    628  CG  ASN    55      18.050  17.374  52.753  1.00 28.25           C  
ATOM    629  OD1 ASN    55      17.015  17.664  53.345  1.00 27.11           O  
ATOM    630  ND2 ASN    55      19.190  17.134  53.381  1.00 25.68           N  
ATOM    633  C   ASN    55      17.189  19.501  50.573  1.00 27.90           C  
ATOM    634  O   ASN    55      18.159  19.980  51.170  1.00 27.64           O  
ATOM    636  N   ASN    56      16.320  20.224  49.887  1.00 27.79           N  
ATOM    637  CA  ASN    56      16.363  21.691  49.865  1.00 28.13           C  
ATOM    639  CB  ASN    56      16.324  22.254  51.279  1.00 28.01           C  
ATOM    642  CG  ASN    56      15.882  23.683  51.311  1.00 27.94           C  
ATOM    643  OD1 ASN    56      15.237  24.172  50.381  1.00 31.08           O  
ATOM    644  ND2 ASN    56      16.215  24.367  52.378  1.00 27.46           N  
ATOM    647  C   ASN    56      17.533  22.307  49.134  1.00 27.87           C  
ATOM    648  O   ASN    56      17.908  23.425  49.409  1.00 28.32           O  
ATOM    650  N   GLU    57      18.082  21.574  48.183  1.00 27.86           N  
ATOM    651  CA  GLU    57      19.217  22.024  47.409  1.00 27.68           C  
ATOM    653  CB  GLU    57      20.472  21.281  47.847  1.00 27.08           C  
ATOM    656  CG  GLU    57      21.672  21.541  46.962  1.00 28.55           C  
ATOM    659  CD  GLU    57      23.044  21.418  47.718  1.00 30.79           C  
ATOM    660  OE1 GLU    57      24.101  21.861  47.139  1.00 30.38           O  
ATOM    661  OE2 GLU    57      23.061  20.888  48.874  1.00 30.25           O  
ATOM    662  C   GLU    57      18.879  21.798  45.937  1.00 27.63           C  
ATOM    663  O   GLU    57      18.169  20.830  45.585  1.00 27.10           O  
ATOM    665  N   VAL    58      19.321  22.734  45.093  1.00 27.91           N  
ATOM    666  CA  VAL    58      19.139  22.617  43.654  1.00 27.84           C  
ATOM    668  CB  VAL    58      19.194  23.956  42.914  1.00 27.95           C  
ATOM    670  CG1 VAL    58      19.081  23.684  41.414  1.00 27.53           C  
ATOM    674  CG2 VAL    58      18.097  24.893  43.401  1.00 27.26           C  
ATOM    678  C   VAL    58      20.250  21.735  43.142  1.00 27.85           C  
ATOM    679  O   VAL    58      21.372  22.153  42.975  1.00 27.19           O  
ATOM    681  N   VAL    59      19.894  20.494  42.876  1.00 28.57           N  
ATOM    682  CA  VAL    59      20.856  19.448  42.563  1.00 28.61           C  
ATOM    684  CB  VAL    59      20.415  18.170  43.356  1.00 28.52           C  
ATOM    686  CG1 VAL    59      19.333  17.410  42.623  1.00 27.61           C  
ATOM    690  CG2 VAL    59      21.584  17.307  43.628  1.00 30.18           C  
ATOM    694  C   VAL    59      21.022  19.190  41.019  1.00 28.74           C  
ATOM    695  O   VAL    59      21.896  18.437  40.605  1.00 28.89           O  
ATOM    697  N   GLY    60      20.192  19.812  40.180  1.00 28.38           N  
ATOM    698  CA  GLY    60      20.330  19.712  38.737  1.00 28.23           C  
ATOM    701  C   GLY    60      19.404  20.682  38.007  1.00 28.41           C  
ATOM    702  O   GLY    60      18.276  20.866  38.404  1.00 28.63           O  
ATOM    704  N   LYS    61      19.916  21.324  36.960  1.00 28.65           N  
ATOM    705  CA  LYS    61      19.168  22.227  36.093  1.00 28.54           C  
ATOM    707  CB  LYS    61      19.780  23.640  36.140  1.00 28.95           C  
ATOM    710  CG  LYS    61      19.463  24.488  37.367  1.00 28.34           C  
ATOM    713  CD  LYS    61      20.179  25.840  37.225  1.00 29.50           C  
ATOM    716  CE  LYS    61      20.207  26.654  38.541  1.00 30.91           C  
ATOM    719  NZ  LYS    61      18.964  27.499  38.849  1.00 30.87           N  
ATOM    723  C   LYS    61      19.282  21.710  34.650  1.00 28.73           C  
ATOM    724  O   LYS    61      20.198  20.928  34.303  1.00 28.29           O  
ATOM    726  N   GLY    62      18.379  22.158  33.784  1.00 28.67           N  
ATOM    727  CA  GLY    62      18.523  21.784  32.389  1.00 28.85           C  
ATOM    730  C   GLY    62      17.522  22.399  31.467  1.00 28.68           C  
ATOM    731  O   GLY    62      16.377  22.533  31.822  1.00 29.05           O  
ATOM    733  N   ARG    63      17.983  22.761  30.279  1.00 28.89           N  
ATOM    734  CA  ARG    63      17.144  23.177  29.179  1.00 28.89           C  
ATOM    736  CB  ARG    63      17.613  24.542  28.668  1.00 29.02           C  
ATOM    739  CG  ARG    63      17.129  25.716  29.490  1.00 29.86           C  
ATOM    742  CD  ARG    63      18.067  26.929  29.395  1.00 30.14           C  
ATOM    745  NE  ARG    63      19.316  26.658  30.105  1.00 31.33           N  
ATOM    747  CZ  ARG    63      20.264  27.559  30.367  1.00 31.77           C  
ATOM    748  NH1 ARG    63      20.100  28.830  29.992  1.00 31.57           N  
ATOM    751  NH2 ARG    63      21.380  27.181  31.007  1.00 30.99           N  
ATOM    754  C   ARG    63      17.358  22.195  28.056  1.00 29.11           C  
ATOM    755  O   ARG    63      18.388  21.496  28.019  1.00 29.15           O  
ATOM    757  N   ASN    64      16.420  22.169  27.108  1.00 29.06           N  
ATOM    758  CA  ASN    64      16.671  21.481  25.849  1.00 28.97           C  
ATOM    760  CB  ASN    64      15.497  21.629  24.909  1.00 29.21           C  
ATOM    763  CG  ASN    64      14.555  20.442  24.966  1.00 30.76           C  
ATOM    764  OD1 ASN    64      14.095  20.021  26.061  1.00 31.58           O  
ATOM    765  ND2 ASN    64      14.238  19.899  23.783  1.00 30.37           N  
ATOM    768  C   ASN    64      17.914  22.003  25.151  1.00 28.78           C  
ATOM    769  O   ASN    64      18.100  23.209  25.044  1.00 28.39           O  
ATOM    771  N   GLU    65      18.741  21.063  24.683  1.00 28.83           N  
ATOM    772  CA  GLU    65      19.991  21.336  23.956  1.00 28.70           C  
ATOM    774  CB  GLU    65      21.208  20.948  24.811  1.00 28.43           C  
ATOM    777  CG  GLU    65      21.363  21.803  26.060  1.00 29.26           C  
ATOM    780  CD  GLU    65      22.567  21.420  26.935  1.00 31.11           C  
ATOM    781  OE1 GLU    65      23.208  20.350  26.722  1.00 32.83           O  
ATOM    782  OE2 GLU    65      22.862  22.193  27.874  1.00 32.15           O  
ATOM    783  C   GLU    65      20.053  20.599  22.593  1.00 28.61           C  
ATOM    784  O   GLU    65      21.143  20.477  22.010  1.00 28.58           O  
ATOM    786  N   VAL    66      18.896  20.169  22.062  1.00 27.88           N  
ATOM    787  CA  VAL    66      18.886  19.316  20.880  1.00 27.67           C  
ATOM    789  CB  VAL    66      17.459  18.841  20.468  1.00 27.53           C  
ATOM    791  CG1 VAL    66      17.529  18.039  19.197  1.00 26.83           C  
ATOM    795  CG2 VAL    66      16.898  17.936  21.521  1.00 26.62           C  
ATOM    799  C   VAL    66      19.638  19.911  19.702  1.00 27.74           C  
ATOM    800  O   VAL    66      20.368  19.174  19.054  1.00 27.05           O  
ATOM    802  N   ASN    67      19.485  21.227  19.463  1.00 28.26           N  
ATOM    803  CA  ASN    67      20.095  21.919  18.295  1.00 28.74           C  
ATOM    805  CB  ASN    67      19.369  23.234  17.954  1.00 29.15           C  
ATOM    808  CG  ASN    67      17.862  23.046  17.756  1.00 30.45           C  
ATOM    809  OD1 ASN    67      17.316  21.924  17.886  1.00 31.70           O  
ATOM    810  ND2 ASN    67      17.175  24.152  17.467  1.00 29.61           N  
ATOM    813  C   ASN    67      21.546  22.272  18.503  1.00 28.57           C  
ATOM    814  O   ASN    67      22.382  22.068  17.625  1.00 28.06           O  
ATOM    816  N   GLN    68      21.820  22.854  19.661  1.00 28.68           N  
ATOM    817  CA  GLN    68      23.187  23.164  20.074  1.00 29.07           C  
ATOM    819  CB  GLN    68      23.182  23.668  21.536  1.00 29.90           C  
ATOM    822  CG  GLN    68      22.524  25.095  21.719  1.00 32.43           C  
ATOM    825  CD  GLN    68      22.188  25.490  23.188  1.00 32.48           C  
ATOM    826  OE1 GLN    68      21.718  24.669  23.999  1.00 31.76           O  
ATOM    827  NE2 GLN    68      22.424  26.777  23.507  1.00 31.80           N  
ATOM    830  C   GLN    68      24.041  21.912  20.001  1.00 28.56           C  
ATOM    831  O   GLN    68      25.150  21.918  19.494  1.00 27.79           O  
ATOM    833  N   THR    69      23.495  20.836  20.554  1.00 28.62           N  
ATOM    834  CA  THR    69      24.199  19.575  20.692  1.00 28.33           C  
ATOM    836  CB  THR    69      23.715  18.855  21.942  1.00 27.93           C  
ATOM    838  OG1 THR    69      24.674  17.873  22.314  1.00 30.06           O  
ATOM    840  CG2 THR    69      22.403  18.168  21.682  1.00 28.03           C  
ATOM    844  C   THR    69      24.028  18.652  19.476  1.00 28.16           C  
ATOM    845  O   THR    69      24.864  17.762  19.267  1.00 28.11           O  
ATOM    847  N   LYS    70      22.972  18.895  18.683  1.00 27.74           N  
ATOM    848  CA  LYS    70      22.589  18.065  17.531  1.00 27.50           C  
ATOM    850  CB  LYS    70      23.563  18.266  16.384  1.00 27.34           C  
ATOM    853  CG  LYS    70      23.246  19.525  15.632  1.00 28.15           C  
ATOM    856  CD  LYS    70      24.390  19.949  14.775  1.00 29.05           C  
ATOM    859  CE  LYS    70      24.183  21.367  14.275  1.00 29.94           C  
ATOM    862  NZ  LYS    70      25.274  21.771  13.281  1.00 31.00           N  
ATOM    866  C   LYS    70      22.383  16.586  17.886  1.00 27.49           C  
ATOM    867  O   LYS    70      22.638  15.688  17.088  1.00 27.02           O  
ATOM    869  N   ASN    71      21.857  16.364  19.083  1.00 27.55           N  
ATOM    870  CA  ASN    71      21.554  15.046  19.586  1.00 27.78           C  
ATOM    872  CB  ASN    71      22.528  14.710  20.740  1.00 28.42           C  
ATOM    875  CG  ASN    71      22.027  13.539  21.665  1.00 28.76           C  
ATOM    876  OD1 ASN    71      20.966  12.957  21.460  1.00 27.98           O  
ATOM    877  ND2 ASN    71      22.818  13.221  22.698  1.00 28.49           N  
ATOM    880  C   ASN    71      20.093  15.093  20.051  1.00 27.58           C  
ATOM    881  O   ASN    71      19.764  15.768  21.038  1.00 27.17           O  
ATOM    883  N   ALA    72      19.246  14.340  19.348  1.00 27.15           N  
ATOM    884  CA  ALA    72      17.800  14.367  19.546  1.00 27.07           C  
ATOM    886  CB  ALA    72      17.127  13.525  18.488  1.00 26.68           C  
ATOM    890  C   ALA    72      17.315  13.950  20.941  1.00 27.13           C  
ATOM    891  O   ALA    72      16.182  14.226  21.301  1.00 26.86           O  
ATOM    893  N   THR    73      18.163  13.293  21.726  1.00 27.64           N  
ATOM    894  CA  THR    73      17.794  12.844  23.087  1.00 27.77           C  
ATOM    896  CB  THR    73      18.487  11.475  23.481  1.00 27.68           C  
ATOM    898  OG1 THR    73      19.896  11.661  23.586  1.00 28.68           O  
ATOM    900  CG2 THR    73      18.245  10.386  22.484  1.00 27.37           C  
ATOM    904  C   THR    73      18.077  13.870  24.222  1.00 27.70           C  
ATOM    905  O   THR    73      17.605  13.670  25.328  1.00 28.04           O  
ATOM    907  N   ARG    74      18.804  14.962  23.970  1.00 28.06           N  
ATOM    908  CA  ARG    74      19.126  15.931  25.042  1.00 28.19           C  
ATOM    910  CB  ARG    74      20.501  16.601  24.849  1.00 28.37           C  
ATOM    913  CG  ARG    74      21.630  15.661  25.334  1.00 29.65           C  
ATOM    916  CD  ARG    74      23.077  16.273  25.365  1.00 31.98           C  
ATOM    919  NE  ARG    74      23.948  15.483  24.442  1.00 33.67           N  
ATOM    921  CZ  ARG    74      25.287  15.545  24.348  1.00 32.37           C  
ATOM    922  NH1 ARG    74      26.000  16.370  25.135  1.00 33.11           N  
ATOM    925  NH2 ARG    74      25.913  14.770  23.451  1.00 30.11           N  
ATOM    928  C   ARG    74      18.008  16.914  25.334  1.00 27.96           C  
ATOM    929  O   ARG    74      18.098  18.113  25.095  1.00 27.54           O  
ATOM    931  N   HIS    75      16.947  16.332  25.881  1.00 28.13           N  
ATOM    932  CA  HIS    75      15.808  17.019  26.439  1.00 27.64           C  
ATOM    934  CB  HIS    75      14.667  16.007  26.623  1.00 27.64           C  
ATOM    937  CG  HIS    75      13.933  15.675  25.364  1.00 26.85           C  
ATOM    938  ND1 HIS    75      12.684  15.091  25.365  1.00 27.16           N  
ATOM    940  CE1 HIS    75      12.273  14.929  24.123  1.00 25.35           C  
ATOM    942  NE2 HIS    75      13.203  15.398  23.314  1.00 25.61           N  
ATOM    944  CD2 HIS    75      14.241  15.891  24.066  1.00 26.69           C  
ATOM    946  C   HIS    75      16.212  17.565  27.809  1.00 27.62           C  
ATOM    947  O   HIS    75      17.040  16.976  28.486  1.00 27.41           O  
ATOM    949  N   ALA    76      15.605  18.680  28.215  1.00 27.85           N  
ATOM    950  CA  ALA    76      15.914  19.361  29.477  1.00 27.68           C  
ATOM    952  CB  ALA    76      14.837  20.315  29.795  1.00 27.83           C  
ATOM    956  C   ALA    76      16.071  18.407  30.627  1.00 27.54           C  
ATOM    957  O   ALA    76      16.949  18.557  31.454  1.00 27.23           O  
ATOM    959  N   GLU    77      15.202  17.415  30.660  1.00 27.94           N  
ATOM    960  CA  GLU    77      15.174  16.423  31.759  1.00 28.19           C  
ATOM    962  CB  GLU    77      13.931  15.503  31.638  1.00 28.04           C  
ATOM    965  CG  GLU    77      12.535  16.240  31.554  1.00 28.70           C  
ATOM    968  CD  GLU    77      12.024  16.560  30.121  1.00 29.00           C  
ATOM    969  OE1 GLU    77      12.744  17.225  29.338  1.00 26.96           O  
ATOM    970  OE2 GLU    77      10.890  16.137  29.788  1.00 30.20           O  
ATOM    971  C   GLU    77      16.453  15.576  31.775  1.00 28.12           C  
ATOM    972  O   GLU    77      16.977  15.267  32.831  1.00 27.91           O  
ATOM    974  N   MET    78      16.945  15.218  30.590  1.00 28.34           N  
ATOM    975  CA  MET    78      18.162  14.405  30.454  1.00 28.57           C  
ATOM    977  CB  MET    78      18.256  13.796  29.033  1.00 28.60           C  
ATOM    980  CG  MET    78      17.083  12.903  28.658  1.00 29.43           C  
ATOM    983  SD  MET    78      17.088  11.230  29.438  1.00 32.79           S  
ATOM    984  CE  MET    78      18.680  10.560  28.910  1.00 33.89           C  
ATOM    988  C   MET    78      19.438  15.196  30.807  1.00 27.97           C  
ATOM    989  O   MET    78      20.374  14.636  31.382  1.00 27.32           O  
ATOM    991  N   VAL    79      19.449  16.485  30.467  1.00 27.87           N  
ATOM    992  CA  VAL    79      20.504  17.412  30.894  1.00 27.89           C  
ATOM    994  CB  VAL    79      20.252  18.842  30.335  1.00 27.64           C  
ATOM    996  CG1 VAL    79      21.200  19.821  30.957  1.00 26.57           C  
ATOM   1000  CG2 VAL    79      20.390  18.846  28.827  1.00 27.02           C  
ATOM   1004  C   VAL    79      20.582  17.472  32.428  1.00 28.20           C  
ATOM   1005  O   VAL    79      21.663  17.343  33.013  1.00 28.42           O  
ATOM   1007  N   ALA    80      19.422  17.663  33.060  1.00 28.46           N  
ATOM   1008  CA  ALA    80      19.292  17.726  34.514  1.00 28.47           C  
ATOM   1010  CB  ALA    80      17.846  18.000  34.891  1.00 28.80           C  
ATOM   1014  C   ALA    80      19.776  16.452  35.211  1.00 28.83           C  
ATOM   1015  O   ALA    80      20.513  16.536  36.211  1.00 28.83           O  
ATOM   1017  N   ILE    81      19.346  15.286  34.702  1.00 28.53           N  
ATOM   1018  CA  ILE    81      19.759  14.004  35.257  1.00 28.44           C  
ATOM   1020  CB  ILE    81      19.134  12.836  34.510  1.00 28.66           C  
ATOM   1022  CG1 ILE    81      17.624  12.783  34.805  1.00 28.89           C  
ATOM   1025  CD1 ILE    81      16.882  11.805  33.992  1.00 26.60           C  
ATOM   1029  CG2 ILE    81      19.789  11.514  34.943  1.00 28.72           C  
ATOM   1033  C   ILE    81      21.275  13.851  35.248  1.00 28.72           C  
ATOM   1034  O   ILE    81      21.854  13.413  36.239  1.00 29.25           O  
ATOM   1036  N   ASP    82      21.922  14.237  34.152  1.00 28.61           N  
ATOM   1037  CA  ASP    82      23.382  14.204  34.080  1.00 28.47           C  
ATOM   1039  CB  ASP    82      23.900  14.655  32.700  1.00 28.86           C  
ATOM   1042  CG  ASP    82      24.020  13.506  31.685  1.00 30.66           C  
ATOM   1043  OD1 ASP    82      23.613  12.367  32.024  1.00 33.60           O  
ATOM   1044  OD2 ASP    82      24.542  13.743  30.544  1.00 32.55           O  
ATOM   1045  C   ASP    82      23.987  15.088  35.148  1.00 28.01           C  
ATOM   1046  O   ASP    82      24.999  14.728  35.734  1.00 27.82           O  
ATOM   1048  N   GLN    83      23.379  16.253  35.385  1.00 27.76           N  
ATOM   1049  CA  GLN    83      23.868  17.178  36.416  1.00 27.64           C  
ATOM   1051  CB  GLN    83      23.170  18.538  36.279  1.00 27.69           C  
ATOM   1054  CG  GLN    83      23.871  19.468  35.291  1.00 28.50           C  
ATOM   1057  CD  GLN    83      23.481  20.925  35.456  1.00 27.64           C  
ATOM   1058  OE1 GLN    83      22.782  21.301  36.390  1.00 27.94           O  
ATOM   1059  NE2 GLN    83      23.942  21.750  34.551  1.00 27.26           N  
ATOM   1062  C   GLN    83      23.721  16.646  37.849  1.00 27.11           C  
ATOM   1063  O   GLN    83      24.612  16.790  38.666  1.00 26.25           O  
ATOM   1065  N   VAL    84      22.573  16.039  38.131  1.00 27.29           N  
ATOM   1066  CA  VAL    84      22.373  15.354  39.390  1.00 27.38           C  
ATOM   1068  CB  VAL    84      20.931  14.822  39.562  1.00 27.63           C  
ATOM   1070  CG1 VAL    84      20.775  14.175  40.919  1.00 25.95           C  
ATOM   1074  CG2 VAL    84      19.923  15.945  39.394  1.00 26.82           C  
ATOM   1078  C   VAL    84      23.395  14.241  39.566  1.00 27.17           C  
ATOM   1079  O   VAL    84      24.087  14.205  40.570  1.00 27.42           O  
ATOM   1081  N   LEU    85      23.541  13.356  38.595  1.00 27.06           N  
ATOM   1082  CA  LEU    85      24.643  12.379  38.680  1.00 27.18           C  
ATOM   1084  CB  LEU    85      24.735  11.528  37.415  1.00 26.93           C  
ATOM   1087  CG  LEU    85      23.618  10.515  37.247  1.00 26.49           C  
ATOM   1089  CD1 LEU    85      23.286  10.344  35.774  1.00 27.04           C  
ATOM   1093  CD2 LEU    85      24.014   9.242  37.875  1.00 26.00           C  
ATOM   1097  C   LEU    85      25.997  13.029  38.955  1.00 27.04           C  
ATOM   1098  O   LEU    85      26.807  12.451  39.661  1.00 27.51           O  
ATOM   1100  N   ASP    86      26.240  14.216  38.404  1.00 27.40           N  
ATOM   1101  CA  ASP    86      27.493  14.935  38.638  1.00 27.79           C  
ATOM   1103  CB  ASP    86      27.674  16.086  37.657  1.00 27.90           C  
ATOM   1106  CG  ASP    86      29.145  16.270  37.271  1.00 30.86           C  
ATOM   1107  OD1 ASP    86      29.648  15.494  36.390  1.00 32.41           O  
ATOM   1108  OD2 ASP    86      29.826  17.137  37.906  1.00 33.31           O  
ATOM   1109  C   ASP    86      27.612  15.473  40.060  1.00 27.69           C  
ATOM   1110  O   ASP    86      28.704  15.515  40.648  1.00 27.89           O  
ATOM   1112  N   TRP    87      26.479  15.887  40.606  1.00 27.68           N  
ATOM   1113  CA  TRP    87      26.393  16.362  41.971  1.00 27.52           C  
ATOM   1115  CB  TRP    87      24.996  16.944  42.217  1.00 28.11           C  
ATOM   1118  CG  TRP    87      24.854  17.634  43.516  1.00 27.84           C  
ATOM   1119  CD1 TRP    87      25.097  18.936  43.765  1.00 26.94           C  
ATOM   1121  NE1 TRP    87      24.843  19.218  45.082  1.00 27.80           N  
ATOM   1123  CE2 TRP    87      24.445  18.076  45.722  1.00 27.98           C  
ATOM   1124  CD2 TRP    87      24.432  17.048  44.756  1.00 28.61           C  
ATOM   1125  CE3 TRP    87      24.048  15.750  45.143  1.00 27.55           C  
ATOM   1127  CZ3 TRP    87      23.721  15.525  46.469  1.00 27.38           C  
ATOM   1129  CH2 TRP    87      23.747  16.579  47.415  1.00 27.96           C  
ATOM   1131  CZ2 TRP    87      24.101  17.857  47.060  1.00 27.24           C  
ATOM   1133  C   TRP    87      26.661  15.254  42.957  1.00 27.22           C  
ATOM   1134  O   TRP    87      27.279  15.469  43.985  1.00 26.82           O  
ATOM   1136  N   CYS    88      26.147  14.072  42.648  1.00 27.62           N  
ATOM   1137  CA  CYS    88      26.427  12.872  43.433  1.00 27.93           C  
ATOM   1139  CB  CYS    88      25.738  11.657  42.842  1.00 27.87           C  
ATOM   1142  SG  CYS    88      24.004  11.558  43.304  1.00 29.69           S  
ATOM   1144  C   CYS    88      27.893  12.579  43.502  1.00 27.85           C  
ATOM   1145  O   CYS    88      28.411  12.357  44.584  1.00 28.58           O  
ATOM   1147  N   ARG    89      28.569  12.568  42.360  1.00 27.85           N  
ATOM   1148  CA  ARG    89      30.000  12.313  42.366  1.00 28.33           C  
ATOM   1150  CB  ARG    89      30.613  12.676  41.043  1.00 28.62           C  
ATOM   1153  CG  ARG    89      30.413  11.652  39.984  1.00 29.96           C  
ATOM   1156  CD  ARG    89      30.720  12.311  38.629  1.00 31.97           C  
ATOM   1159  NE  ARG    89      30.164  11.544  37.504  1.00 33.93           N  
ATOM   1161  CZ  ARG    89      30.404  11.831  36.215  1.00 36.20           C  
ATOM   1162  NH1 ARG    89      31.159  12.902  35.886  1.00 37.64           N  
ATOM   1165  NH2 ARG    89      29.920  11.053  35.234  1.00 36.24           N  
ATOM   1168  C   ARG    89      30.730  13.111  43.408  1.00 28.11           C  
ATOM   1169  O   ARG    89      31.577  12.583  44.101  1.00 28.00           O  
ATOM   1171  N   GLN    90      30.383  14.386  43.506  1.00 28.42           N  
ATOM   1172  CA  GLN    90      31.132  15.339  44.301  1.00 28.75           C  
ATOM   1174  CB  GLN    90      30.990  16.703  43.661  1.00 29.03           C  
ATOM   1177  CG  GLN    90      31.457  16.706  42.217  1.00 31.17           C  
ATOM   1180  CD  GLN    90      31.094  17.981  41.521  1.00 33.04           C  
ATOM   1181  OE1 GLN    90      30.440  18.845  42.108  1.00 35.04           O  
ATOM   1182  NE2 GLN    90      31.498  18.113  40.261  1.00 34.45           N  
ATOM   1185  C   GLN    90      30.670  15.469  45.728  1.00 28.39           C  
ATOM   1186  O   GLN    90      31.383  16.039  46.538  1.00 28.51           O  
ATOM   1188  N   SER    91      29.453  15.014  46.010  1.00 28.22           N  
ATOM   1189  CA  SER    91      28.885  15.090  47.346  1.00 28.33           C  
ATOM   1191  CB  SER    91      27.379  15.315  47.267  1.00 28.48           C  
ATOM   1194  OG  SER    91      26.708  14.066  47.137  1.00 28.44           O  
ATOM   1196  C   SER    91      29.135  13.806  48.131  1.00 28.41           C  
ATOM   1197  O   SER    91      28.941  13.790  49.351  1.00 28.52           O  
ATOM   1199  N   GLY    92      29.541  12.740  47.419  1.00 28.34           N  
ATOM   1200  CA  GLY    92      29.820  11.437  48.010  1.00 28.07           C  
ATOM   1203  C   GLY    92      28.567  10.609  48.180  1.00 27.97           C  
ATOM   1204  O   GLY    92      28.632   9.480  48.609  1.00 28.33           O  
ATOM   1206  N   LYS    93      27.418  11.175  47.850  1.00 28.04           N  
ATOM   1207  CA  LYS    93      26.144  10.499  48.043  1.00 28.52           C  
ATOM   1209  CB  LYS    93      25.010  11.516  48.151  1.00 28.44           C  
ATOM   1212  CG  LYS    93      25.124  12.507  49.287  1.00 28.85           C  
ATOM   1215  CD  LYS    93      24.408  12.008  50.555  1.00 30.68           C  
ATOM   1218  CE  LYS    93      23.929  13.147  51.497  1.00 31.10           C  
ATOM   1221  NZ  LYS    93      22.573  12.817  52.143  1.00 31.15           N  
ATOM   1225  C   LYS    93      25.886   9.579  46.841  1.00 28.54           C  
ATOM   1226  O   LYS    93      26.366   9.859  45.736  1.00 28.29           O  
ATOM   1228  N   SER    94      25.122   8.501  47.058  1.00 28.28           N  
ATOM   1229  CA  SER    94      24.802   7.568  45.984  1.00 27.99           C  
ATOM   1231  CB  SER    94      24.546   6.167  46.522  1.00 27.89           C  
ATOM   1234  OG  SER    94      23.271   6.106  47.132  1.00 27.86           O  
ATOM   1236  C   SER    94      23.571   8.064  45.224  1.00 28.07           C  
ATOM   1237  O   SER    94      22.649   8.643  45.843  1.00 27.86           O  
ATOM   1239  N   PRO    95      23.548   7.840  43.893  1.00 27.49           N  
ATOM   1240  CA  PRO    95      22.436   8.176  42.998  1.00 27.79           C  
ATOM   1242  CB  PRO    95      22.818   7.481  41.703  1.00 27.72           C  
ATOM   1245  CG  PRO    95      24.264   7.455  41.751  1.00 28.05           C  
ATOM   1248  CD  PRO    95      24.646   7.219  43.154  1.00 27.05           C  
ATOM   1251  C   PRO    95      21.045   7.709  43.436  1.00 27.91           C  
ATOM   1252  O   PRO    95      20.106   8.499  43.371  1.00 28.45           O  
ATOM   1253  N   SER    96      20.917   6.457  43.869  1.00 27.75           N  
ATOM   1254  CA  SER    96      19.643   5.929  44.340  1.00 28.16           C  
ATOM   1256  CB  SER    96      19.727   4.416  44.567  1.00 28.01           C  
ATOM   1259  OG  SER    96      20.401   4.120  45.777  1.00 28.00           O  
ATOM   1261  C   SER    96      19.140   6.659  45.599  1.00 28.30           C  
ATOM   1262  O   SER    96      17.977   6.987  45.701  1.00 28.80           O  
ATOM   1264  N   GLU    97      20.029   6.959  46.524  1.00 28.77           N  
ATOM   1265  CA  GLU    97      19.701   7.734  47.728  1.00 29.19           C  
ATOM   1267  CB  GLU    97      20.960   7.760  48.608  1.00 29.43           C  
ATOM   1270  CG  GLU    97      20.840   8.453  49.966  1.00 31.88           C  
ATOM   1273  CD  GLU    97      22.211   8.495  50.747  1.00 34.19           C  
ATOM   1274  OE1 GLU    97      23.234   7.944  50.211  1.00 34.81           O  
ATOM   1275  OE2 GLU    97      22.250   9.095  51.874  1.00 32.68           O  
ATOM   1276  C   GLU    97      19.225   9.185  47.447  1.00 29.09           C  
ATOM   1277  O   GLU    97      18.528   9.788  48.293  1.00 29.59           O  
ATOM   1279  N   VAL    98      19.614   9.742  46.295  1.00 28.27           N  
ATOM   1280  CA  VAL    98      19.289  11.121  45.961  1.00 28.28           C  
ATOM   1282  CB  VAL    98      20.460  11.853  45.218  1.00 28.27           C  
ATOM   1284  CG1 VAL    98      20.109  13.282  44.899  1.00 25.94           C  
ATOM   1288  CG2 VAL    98      21.732  11.836  46.046  1.00 28.61           C  
ATOM   1292  C   VAL    98      18.069  11.175  45.066  1.00 28.91           C  
ATOM   1293  O   VAL    98      17.096  11.881  45.374  1.00 28.91           O  
ATOM   1295  N   PHE    99      18.133  10.470  43.930  1.00 29.30           N  
ATOM   1296  CA  PHE    99      17.022  10.466  42.968  1.00 29.02           C  
ATOM   1298  CB  PHE    99      17.314   9.595  41.740  1.00 29.08           C  
ATOM   1301  CG  PHE    99      18.191  10.271  40.744  1.00 30.28           C  
ATOM   1302  CD1 PHE    99      19.564  10.018  40.707  1.00 30.48           C  
ATOM   1304  CE1 PHE    99      20.391  10.672  39.812  1.00 29.96           C  
ATOM   1306  CZ  PHE    99      19.873  11.616  38.953  1.00 30.17           C  
ATOM   1308  CE2 PHE    99      18.508  11.904  38.982  1.00 31.27           C  
ATOM   1310  CD2 PHE    99      17.666  11.222  39.877  1.00 31.63           C  
ATOM   1312  C   PHE    99      15.737  10.011  43.618  1.00 28.89           C  
ATOM   1313  O   PHE    99      14.682  10.551  43.305  1.00 29.69           O  
ATOM   1315  N   GLU   100      15.802   9.025  44.514  1.00 28.16           N  
ATOM   1316  CA  GLU   100      14.578   8.558  45.168  1.00 27.97           C  
ATOM   1318  CB  GLU   100      14.825   7.247  45.899  1.00 27.44           C  
ATOM   1321  CG  GLU   100      15.086   6.145  44.939  1.00 28.81           C  
ATOM   1324  CD  GLU   100      15.433   4.827  45.602  1.00 31.25           C  
ATOM   1325  OE1 GLU   100      14.999   4.604  46.757  1.00 33.41           O  
ATOM   1326  OE2 GLU   100      16.147   4.005  44.961  1.00 32.63           O  
ATOM   1327  C   GLU   100      13.901   9.589  46.090  1.00 27.67           C  
ATOM   1328  O   GLU   100      12.803   9.337  46.580  1.00 27.67           O  
ATOM   1330  N   HIS   101      14.549  10.734  46.319  1.00 27.43           N  
ATOM   1331  CA  HIS   101      13.984  11.809  47.136  1.00 27.25           C  
ATOM   1333  CB  HIS   101      14.693  11.846  48.490  1.00 27.64           C  
ATOM   1336  CG  HIS   101      14.600  10.559  49.241  1.00 28.63           C  
ATOM   1337  ND1 HIS   101      15.589   9.592  49.190  1.00 29.98           N  
ATOM   1339  CE1 HIS   101      15.213   8.550  49.910  1.00 29.66           C  
ATOM   1341  NE2 HIS   101      14.023   8.807  50.425  1.00 29.55           N  
ATOM   1343  CD2 HIS   101      13.611  10.050  50.010  1.00 28.37           C  
ATOM   1345  C   HIS   101      14.093  13.162  46.463  1.00 26.91           C  
ATOM   1346  O   HIS   101      14.090  14.165  47.121  1.00 26.37           O  
ATOM   1348  N   THR   102      14.172  13.155  45.136  1.00 27.88           N  
ATOM   1349  CA  THR   102      14.323  14.343  44.296  1.00 28.28           C  
ATOM   1351  CB  THR   102      15.376  14.090  43.179  1.00 28.77           C  
ATOM   1353  OG1 THR   102      16.620  13.677  43.769  1.00 29.37           O  
ATOM   1355  CG2 THR   102      15.602  15.338  42.319  1.00 28.67           C  
ATOM   1359  C   THR   102      12.981  14.701  43.643  1.00 28.52           C  
ATOM   1360  O   THR   102      12.303  13.824  43.089  1.00 29.15           O  
ATOM   1362  N   VAL   103      12.571  15.975  43.723  1.00 28.29           N  
ATOM   1363  CA  VAL   103      11.375  16.424  43.007  1.00 27.89           C  
ATOM   1365  CB  VAL   103      10.499  17.411  43.792  1.00 27.37           C  
ATOM   1367  CG1 VAL   103       9.458  17.967  42.885  1.00 27.07           C  
ATOM   1371  CG2 VAL   103       9.842  16.749  44.935  1.00 26.32           C  
ATOM   1375  C   VAL   103      11.855  17.124  41.762  1.00 28.32           C  
ATOM   1376  O   VAL   103      12.766  17.953  41.840  1.00 27.99           O  
ATOM   1378  N   LEU   104      11.241  16.769  40.627  1.00 28.66           N  
ATOM   1379  CA  LEU   104      11.499  17.407  39.326  1.00 28.73           C  
ATOM   1381  CB  LEU   104      11.432  16.357  38.204  1.00 28.51           C  
ATOM   1384  CG  LEU   104      11.478  16.890  36.764  1.00 29.73           C  
ATOM   1386  CD1 LEU   104      12.826  17.591  36.418  1.00 30.68           C  
ATOM   1390  CD2 LEU   104      11.197  15.768  35.748  1.00 29.46           C  
ATOM   1394  C   LEU   104      10.469  18.508  39.084  1.00 28.35           C  
ATOM   1395  O   LEU   104       9.279  18.299  39.308  1.00 28.58           O  
ATOM   1397  N   TYR   105      10.935  19.672  38.635  1.00 28.26           N  
ATOM   1398  CA  TYR   105      10.055  20.816  38.292  1.00 28.44           C  
ATOM   1400  CB  TYR   105      10.335  22.040  39.206  1.00 28.13           C  
ATOM   1403  CG  TYR   105      10.205  21.756  40.702  1.00 27.64           C  
ATOM   1404  CD1 TYR   105      11.284  21.202  41.410  1.00 28.21           C  
ATOM   1406  CE1 TYR   105      11.188  20.907  42.749  1.00 27.85           C  
ATOM   1408  CZ  TYR   105      10.000  21.179  43.415  1.00 28.16           C  
ATOM   1409  OH  TYR   105       9.935  20.866  44.768  1.00 26.64           O  
ATOM   1411  CE2 TYR   105       8.925  21.757  42.726  1.00 25.52           C  
ATOM   1413  CD2 TYR   105       9.032  22.035  41.395  1.00 24.48           C  
ATOM   1415  C   TYR   105      10.264  21.171  36.797  1.00 28.60           C  
ATOM   1416  O   TYR   105      11.342  21.633  36.439  1.00 28.75           O  
ATOM   1418  N   VAL   106       9.255  20.945  35.942  1.00 28.20           N  
ATOM   1419  CA  VAL   106       9.399  21.109  34.476  1.00 28.13           C  
ATOM   1421  CB  VAL   106       9.437  19.736  33.731  1.00 27.97           C  
ATOM   1423  CG1 VAL   106      10.590  18.978  34.171  1.00 29.41           C  
ATOM   1427  CG2 VAL   106       8.201  18.935  34.004  1.00 26.97           C  
ATOM   1431  C   VAL   106       8.304  21.933  33.793  1.00 27.78           C  
ATOM   1432  O   VAL   106       7.135  21.879  34.152  1.00 27.98           O  
ATOM   1434  N   THR   107       8.698  22.640  32.750  1.00 27.47           N  
ATOM   1435  CA  THR   107       7.797  23.502  31.995  1.00 27.60           C  
ATOM   1437  CB  THR   107       8.624  24.430  31.114  1.00 27.08           C  
ATOM   1439  OG1 THR   107       9.242  25.406  31.949  1.00 26.99           O  
ATOM   1441  CG2 THR   107       7.752  25.104  30.113  1.00 28.88           C  
ATOM   1445  C   THR   107       6.738  22.762  31.142  1.00 27.29           C  
ATOM   1446  O   THR   107       5.602  23.217  31.046  1.00 27.48           O  
ATOM   1448  N   VAL   108       7.124  21.648  30.524  1.00 26.89           N  
ATOM   1449  CA  VAL   108       6.228  20.847  29.718  1.00 26.46           C  
ATOM   1451  CB  VAL   108       6.701  20.787  28.284  1.00 26.45           C  
ATOM   1453  CG1 VAL   108       5.756  19.953  27.480  1.00 25.92           C  
ATOM   1457  CG2 VAL   108       6.837  22.205  27.700  1.00 26.36           C  
ATOM   1461  C   VAL   108       6.186  19.431  30.231  1.00 26.51           C  
ATOM   1462  O   VAL   108       7.157  18.899  30.725  1.00 26.61           O  
ATOM   1464  N   GLU   109       5.033  18.814  30.117  1.00 27.18           N  
ATOM   1465  CA  GLU   109       4.876  17.390  30.411  1.00 27.29           C  
ATOM   1467  CB  GLU   109       3.488  16.904  29.932  1.00 27.24           C  
ATOM   1470  CG  GLU   109       3.138  15.447  30.308  1.00 28.49           C  
ATOM   1473  CD  GLU   109       1.889  14.937  29.589  1.00 29.27           C  
ATOM   1474  OE1 GLU   109       1.109  15.760  29.061  1.00 29.40           O  
ATOM   1475  OE2 GLU   109       1.691  13.706  29.528  1.00 30.07           O  
ATOM   1476  C   GLU   109       6.009  16.560  29.782  1.00 26.50           C  
ATOM   1477  O   GLU   109       6.244  16.634  28.607  1.00 25.85           O  
ATOM   1479  N   PRO   110       6.734  15.790  30.590  1.00 27.08           N  
ATOM   1480  CA  PRO   110       7.729  14.855  30.045  1.00 27.45           C  
ATOM   1482  CB  PRO   110       8.119  14.018  31.256  1.00 27.41           C  
ATOM   1485  CG  PRO   110       7.870  14.919  32.414  1.00 27.40           C  
ATOM   1488  CD  PRO   110       6.709  15.769  32.066  1.00 27.08           C  
ATOM   1491  C   PRO   110       7.213  13.943  28.942  1.00 27.32           C  
ATOM   1492  O   PRO   110       6.112  13.439  29.046  1.00 26.89           O  
ATOM   1493  N   CYS   111       8.019  13.764  27.895  1.00 27.48           N  
ATOM   1494  CA  CYS   111       7.673  12.895  26.779  1.00 27.20           C  
ATOM   1496  CB  CYS   111       8.596  13.159  25.591  1.00 27.18           C  
ATOM   1499  SG  CYS   111      10.319  12.549  25.762  1.00 26.81           S  
ATOM   1501  C   CYS   111       7.773  11.433  27.179  1.00 27.55           C  
ATOM   1502  O   CYS   111       8.200  11.098  28.282  1.00 27.24           O  
ATOM   1504  N   ILE   112       7.393  10.555  26.260  1.00 27.67           N  
ATOM   1505  CA  ILE   112       7.456   9.134  26.532  1.00 27.66           C  
ATOM   1507  CB  ILE   112       6.865   8.310  25.370  1.00 27.71           C  
ATOM   1509  CG1 ILE   112       5.338   8.440  25.369  1.00 28.05           C  
ATOM   1512  CD1 ILE   112       4.648   7.765  24.177  1.00 28.17           C  
ATOM   1516  CG2 ILE   112       7.261   6.828  25.471  1.00 27.28           C  
ATOM   1520  C   ILE   112       8.872   8.692  26.886  1.00 27.75           C  
ATOM   1521  O   ILE   112       9.050   7.898  27.810  1.00 27.52           O  
ATOM   1523  N   MET   113       9.878   9.206  26.168  1.00 28.00           N  
ATOM   1524  CA  MET   113      11.286   8.865  26.477  1.00 27.71           C  
ATOM   1526  CB  MET   113      12.224   9.558  25.518  1.00 27.36           C  
ATOM   1529  CG  MET   113      13.630   9.038  25.611  1.00 27.66           C  
ATOM   1532  SD  MET   113      14.781  10.217  24.914  1.00 29.59           S  
ATOM   1533  CE  MET   113      15.865  10.464  26.347  1.00 31.93           C  
ATOM   1537  C   MET   113      11.695   9.263  27.906  1.00 27.74           C  
ATOM   1538  O   MET   113      12.210   8.430  28.653  1.00 27.33           O  
ATOM   1540  N   CYS   114      11.461  10.527  28.255  1.00 27.33           N  
ATOM   1541  CA  CYS   114      11.773  11.050  29.574  1.00 27.96           C  
ATOM   1543  CB  CYS   114      11.535  12.562  29.593  1.00 28.16           C  
ATOM   1546  SG  CYS   114      12.745  13.454  28.634  1.00 29.88           S  
ATOM   1548  C   CYS   114      10.984  10.409  30.733  1.00 27.83           C  
ATOM   1549  O   CYS   114      11.560  10.008  31.741  1.00 27.85           O  
ATOM   1551  N   ALA   115       9.675  10.312  30.597  1.00 27.62           N  
ATOM   1552  CA  ALA   115       8.891   9.588  31.569  1.00 27.76           C  
ATOM   1554  CB  ALA   115       7.432   9.558  31.146  1.00 27.42           C  
ATOM   1558  C   ALA   115       9.442   8.163  31.819  1.00 28.27           C  
ATOM   1559  O   ALA   115       9.599   7.752  32.985  1.00 29.59           O  
ATOM   1561  N   ALA   116       9.771   7.412  30.769  1.00 28.12           N  
ATOM   1562  CA  ALA   116      10.385   6.078  30.963  1.00 28.33           C  
ATOM   1564  CB  ALA   116      10.653   5.371  29.619  1.00 27.77           C  
ATOM   1568  C   ALA   116      11.675   6.194  31.785  1.00 28.62           C  
ATOM   1569  O   ALA   116      11.941   5.377  32.671  1.00 29.32           O  
ATOM   1571  N   ALA   117      12.463   7.229  31.508  1.00 28.78           N  
ATOM   1572  CA  ALA   117      13.700   7.484  32.246  1.00 28.73           C  
ATOM   1574  CB  ALA   117      14.421   8.676  31.653  1.00 28.83           C  
ATOM   1578  C   ALA   117      13.441   7.743  33.724  1.00 28.85           C  
ATOM   1579  O   ALA   117      14.094   7.176  34.577  1.00 28.67           O  
ATOM   1581  N   LEU   118      12.477   8.620  34.005  1.00 29.20           N  
ATOM   1582  CA  LEU   118      12.155   9.023  35.360  1.00 28.43           C  
ATOM   1584  CB  LEU   118      11.127  10.154  35.347  1.00 27.97           C  
ATOM   1587  CG  LEU   118      11.692  11.452  34.772  1.00 27.63           C  
ATOM   1589  CD1 LEU   118      10.735  12.603  34.919  1.00 28.37           C  
ATOM   1593  CD2 LEU   118      12.963  11.797  35.439  1.00 28.09           C  
ATOM   1597  C   LEU   118      11.669   7.840  36.159  1.00 28.28           C  
ATOM   1598  O   LEU   118      12.014   7.730  37.331  1.00 28.30           O  
ATOM   1600  N   ARG   119      10.895   6.949  35.534  1.00 28.26           N  
ATOM   1601  CA  ARG   119      10.579   5.659  36.179  1.00 28.76           C  
ATOM   1603  CB  ARG   119       9.775   4.752  35.252  1.00 29.30           C  
ATOM   1606  CG  ARG   119       8.261   4.867  35.387  1.00 29.05           C  
ATOM   1609  CD  ARG   119       7.630   3.767  34.611  1.00 29.20           C  
ATOM   1612  NE  ARG   119       7.435   2.550  35.388  1.00 29.29           N  
ATOM   1614  CZ  ARG   119       6.316   2.241  36.052  1.00 30.71           C  
ATOM   1615  NH1 ARG   119       5.280   3.079  36.090  1.00 31.34           N  
ATOM   1618  NH2 ARG   119       6.229   1.086  36.713  1.00 31.28           N  
ATOM   1621  C   ARG   119      11.826   4.865  36.565  1.00 28.71           C  
ATOM   1622  O   ARG   119      11.942   4.355  37.683  1.00 28.42           O  
ATOM   1624  N   LEU   120      12.738   4.738  35.608  1.00 28.29           N  
ATOM   1625  CA  LEU   120      13.955   3.987  35.836  1.00 28.40           C  
ATOM   1627  CB  LEU   120      14.671   3.762  34.510  1.00 27.90           C  
ATOM   1630  CG  LEU   120      13.979   2.793  33.547  1.00 26.59           C  
ATOM   1632  CD1 LEU   120      14.630   2.885  32.201  1.00 25.10           C  
ATOM   1636  CD2 LEU   120      13.984   1.375  34.042  1.00 24.24           C  
ATOM   1640  C   LEU   120      14.896   4.605  36.898  1.00 28.81           C  
ATOM   1641  O   LEU   120      15.541   3.860  37.658  1.00 29.54           O  
ATOM   1643  N   MET   121      14.978   5.941  36.943  1.00 28.87           N  
ATOM   1644  CA  MET   121      15.712   6.673  37.985  1.00 28.40           C  
ATOM   1646  CB  MET   121      15.922   8.132  37.588  1.00 28.32           C  
ATOM   1649  CG  MET   121      16.793   8.350  36.362  1.00 29.39           C  
ATOM   1652  SD  MET   121      18.368   7.437  36.341  1.00 31.52           S  
ATOM   1653  CE  MET   121      19.455   8.674  37.112  1.00 32.17           C  
ATOM   1657  C   MET   121      14.968   6.697  39.316  1.00 28.60           C  
ATOM   1658  O   MET   121      15.578   6.990  40.327  1.00 28.98           O  
ATOM   1660  N   LYS   122      13.654   6.446  39.301  1.00 28.57           N  
ATOM   1661  CA  LYS   122      12.791   6.393  40.496  1.00 27.97           C  
ATOM   1663  CB  LYS   122      13.311   5.396  41.523  1.00 27.70           C  
ATOM   1666  CG  LYS   122      13.463   4.024  41.001  1.00 27.70           C  
ATOM   1669  CD  LYS   122      13.797   3.117  42.133  1.00 28.38           C  
ATOM   1672  CE  LYS   122      13.990   1.713  41.622  1.00 28.97           C  
ATOM   1675  NZ  LYS   122      14.226   0.736  42.706  1.00 29.76           N  
ATOM   1679  C   LYS   122      12.590   7.725  41.178  1.00 28.20           C  
ATOM   1680  O   LYS   122      12.469   7.773  42.412  1.00 28.06           O  
ATOM   1682  N   ILE   123      12.586   8.805  40.394  1.00 27.95           N  
ATOM   1683  CA  ILE   123      12.130  10.084  40.892  1.00 27.99           C  
ATOM   1685  CB  ILE   123      12.231  11.205  39.833  1.00 28.47           C  
ATOM   1687  CG1 ILE   123      13.668  11.737  39.725  1.00 30.17           C  
ATOM   1690  CD1 ILE   123      14.537  11.101  38.597  1.00 31.52           C  
ATOM   1694  CG2 ILE   123      11.368  12.380  40.218  1.00 27.61           C  
ATOM   1698  C   ILE   123      10.659   9.867  41.267  1.00 27.89           C  
ATOM   1699  O   ILE   123       9.901   9.331  40.452  1.00 27.80           O  
ATOM   1701  N   PRO   124      10.268  10.206  42.521  1.00 27.53           N  
ATOM   1702  CA  PRO   124       8.908  10.069  43.039  1.00 27.20           C  
ATOM   1704  CB  PRO   124       9.133  10.061  44.535  1.00 27.06           C  
ATOM   1707  CG  PRO   124      10.268  10.856  44.751  1.00 27.33           C  
ATOM   1710  CD  PRO   124      11.177  10.670  43.583  1.00 27.38           C  
ATOM   1713  C   PRO   124       7.871  11.158  42.702  1.00 27.45           C  
ATOM   1714  O   PRO   124       6.685  10.838  42.712  1.00 27.46           O  
ATOM   1715  N   LEU   125       8.290  12.403  42.420  1.00 27.23           N  
ATOM   1716  CA  LEU   125       7.342  13.475  42.135  1.00 27.35           C  
ATOM   1718  CB  LEU   125       7.072  14.273  43.410  1.00 27.50           C  
ATOM   1721  CG  LEU   125       6.170  15.505  43.456  1.00 26.55           C  
ATOM   1723  CD1 LEU   125       4.804  15.257  42.848  1.00 27.47           C  
ATOM   1727  CD2 LEU   125       6.038  15.903  44.891  1.00 25.10           C  
ATOM   1731  C   LEU   125       7.805  14.419  41.029  1.00 28.05           C  
ATOM   1732  O   LEU   125       8.891  14.992  41.124  1.00 28.35           O  
ATOM   1734  N   VAL   126       6.962  14.578  39.993  1.00 28.17           N  
ATOM   1735  CA  VAL   126       7.152  15.557  38.936  1.00 27.98           C  
ATOM   1737  CB  VAL   126       7.033  14.889  37.547  1.00 28.31           C  
ATOM   1739  CG1 VAL   126       7.189  15.937  36.449  1.00 28.62           C  
ATOM   1743  CG2 VAL   126       8.075  13.764  37.376  1.00 28.63           C  
ATOM   1747  C   VAL   126       6.066  16.632  39.064  1.00 27.89           C  
ATOM   1748  O   VAL   126       4.885  16.314  39.154  1.00 27.83           O  
ATOM   1750  N   VAL   127       6.461  17.897  39.084  1.00 27.59           N  
ATOM   1751  CA  VAL   127       5.498  18.987  39.043  1.00 27.75           C  
ATOM   1753  CB  VAL   127       5.719  20.057  40.161  1.00 28.05           C  
ATOM   1755  CG1 VAL   127       5.015  21.381  39.854  1.00 27.26           C  
ATOM   1759  CG2 VAL   127       5.246  19.535  41.514  1.00 28.36           C  
ATOM   1763  C   VAL   127       5.737  19.598  37.704  1.00 27.95           C  
ATOM   1764  O   VAL   127       6.864  19.972  37.389  1.00 27.12           O  
ATOM   1766  N   TYR   128       4.680  19.692  36.900  1.00 28.52           N  
ATOM   1767  CA  TYR   128       4.822  20.268  35.566  1.00 28.45           C  
ATOM   1769  CB  TYR   128       5.025  19.162  34.533  1.00 28.06           C  
ATOM   1772  CG  TYR   128       3.818  18.402  34.078  1.00 28.34           C  
ATOM   1773  CD1 TYR   128       3.626  17.059  34.437  1.00 29.46           C  
ATOM   1775  CE1 TYR   128       2.514  16.329  33.958  1.00 28.31           C  
ATOM   1777  CZ  TYR   128       1.612  16.958  33.113  1.00 29.12           C  
ATOM   1778  OH  TYR   128       0.500  16.310  32.604  1.00 28.84           O  
ATOM   1780  CE2 TYR   128       1.816  18.275  32.740  1.00 29.55           C  
ATOM   1782  CD2 TYR   128       2.914  18.975  33.204  1.00 28.51           C  
ATOM   1784  C   TYR   128       3.757  21.297  35.151  1.00 28.39           C  
ATOM   1785  O   TYR   128       2.754  21.529  35.860  1.00 28.91           O  
ATOM   1787  N   GLY   129       4.029  21.932  34.015  1.00 27.67           N  
ATOM   1788  CA  GLY   129       3.199  22.991  33.493  1.00 27.87           C  
ATOM   1791  C   GLY   129       2.120  22.551  32.535  1.00 27.68           C  
ATOM   1792  O   GLY   129       1.142  21.973  32.960  1.00 28.21           O  
ATOM   1794  N   CYS   130       2.275  22.855  31.252  1.00 27.34           N  
ATOM   1795  CA  CYS   130       1.279  22.499  30.266  1.00 27.89           C  
ATOM   1797  CB  CYS   130       1.342  23.480  29.107  1.00 27.89           C  
ATOM   1800  SG  CYS   130       2.914  23.319  28.162  1.00 30.29           S  
ATOM   1802  C   CYS   130       1.470  21.072  29.724  1.00 27.56           C  
ATOM   1803  O   CYS   130       2.489  20.438  29.937  1.00 26.76           O  
ATOM   1805  N   GLN   131       0.471  20.610  28.984  1.00 27.70           N  
ATOM   1806  CA  GLN   131       0.459  19.278  28.412  1.00 27.98           C  
ATOM   1808  CB  GLN   131      -0.950  18.922  27.932  1.00 28.47           C  
ATOM   1811  CG  GLN   131      -2.080  18.913  29.037  1.00 29.70           C  
ATOM   1814  CD  GLN   131      -1.959  17.735  30.027  1.00 31.77           C  
ATOM   1815  OE1 GLN   131      -1.739  16.574  29.619  1.00 33.82           O  
ATOM   1816  NE2 GLN   131      -2.093  18.027  31.327  1.00 31.60           N  
ATOM   1819  C   GLN   131       1.429  19.146  27.243  1.00 27.96           C  
ATOM   1820  O   GLN   131       1.803  20.137  26.635  1.00 27.61           O  
ATOM   1822  N   ASN   132       1.838  17.908  26.957  1.00 27.61           N  
ATOM   1823  CA  ASN   132       2.626  17.589  25.790  1.00 27.44           C  
ATOM   1825  CB  ASN   132       3.852  16.823  26.237  1.00 27.50           C  
ATOM   1828  CG  ASN   132       4.790  16.477  25.105  1.00 27.17           C  
ATOM   1829  OD1 ASN   132       4.451  16.645  23.947  1.00 28.04           O  
ATOM   1830  ND2 ASN   132       5.969  15.974  25.440  1.00 26.21           N  
ATOM   1833  C   ASN   132       1.780  16.782  24.793  1.00 27.56           C  
ATOM   1834  O   ASN   132       1.796  15.567  24.792  1.00 27.93           O  
ATOM   1836  N   GLU   133       1.042  17.475  23.940  1.00 27.82           N  
ATOM   1837  CA  GLU   133       0.081  16.823  23.046  1.00 28.46           C  
ATOM   1839  CB  GLU   133      -0.771  17.863  22.301  1.00 28.66           C  
ATOM   1842  CG  GLU   133      -2.060  18.259  23.041  1.00 30.06           C  
ATOM   1845  CD  GLU   133      -2.933  19.217  22.235  1.00 31.68           C  
ATOM   1846  OE1 GLU   133      -3.256  18.917  21.055  1.00 31.78           O  
ATOM   1847  OE2 GLU   133      -3.298  20.278  22.791  1.00 33.58           O  
ATOM   1848  C   GLU   133       0.692  15.860  22.029  1.00 28.35           C  
ATOM   1849  O   GLU   133       0.094  14.830  21.710  1.00 28.39           O  
ATOM   1851  N   ARG   134       1.869  16.202  21.523  1.00 28.25           N  
ATOM   1852  CA  ARG   134       2.561  15.377  20.550  1.00 28.21           C  
ATOM   1854  CB  ARG   134       3.683  16.166  19.899  1.00 28.39           C  
ATOM   1857  CG  ARG   134       3.264  17.431  19.221  1.00 28.78           C  
ATOM   1860  CD  ARG   134       4.465  18.125  18.644  1.00 29.15           C  
ATOM   1863  NE  ARG   134       4.091  19.255  17.801  1.00 29.84           N  
ATOM   1865  CZ  ARG   134       4.910  19.864  16.935  1.00 31.27           C  
ATOM   1866  NH1 ARG   134       6.177  19.461  16.778  1.00 31.15           N  
ATOM   1869  NH2 ARG   134       4.464  20.902  16.221  1.00 32.11           N  
ATOM   1872  C   ARG   134       3.178  14.108  21.162  1.00 28.31           C  
ATOM   1873  O   ARG   134       3.053  13.042  20.586  1.00 28.43           O  
ATOM   1875  N   PHE   135       3.865  14.216  22.302  1.00 28.31           N  
ATOM   1876  CA  PHE   135       4.589  13.063  22.841  1.00 28.53           C  
ATOM   1878  CB  PHE   135       6.034  13.163  22.343  1.00 28.53           C  
ATOM   1881  CG  PHE   135       6.732  11.841  22.165  1.00 28.29           C  
ATOM   1882  CD1 PHE   135       6.029  10.670  21.855  1.00 28.13           C  
ATOM   1884  CE1 PHE   135       6.692   9.435  21.694  1.00 28.35           C  
ATOM   1886  CZ  PHE   135       8.063   9.366  21.827  1.00 28.92           C  
ATOM   1888  CE2 PHE   135       8.788  10.545  22.126  1.00 30.44           C  
ATOM   1890  CD2 PHE   135       8.112  11.776  22.288  1.00 28.94           C  
ATOM   1892  C   PHE   135       4.521  12.863  24.376  1.00 28.82           C  
ATOM   1893  O   PHE   135       5.346  12.140  24.953  1.00 29.17           O  
ATOM   1895  N   GLY   136       3.510  13.446  25.019  1.00 28.58           N  
ATOM   1896  CA  GLY   136       3.332  13.292  26.455  1.00 29.12           C  
ATOM   1899  C   GLY   136       3.279  11.832  26.957  1.00 29.71           C  
ATOM   1900  O   GLY   136       2.548  10.985  26.410  1.00 29.56           O  
ATOM   1902  N   GLY   137       4.055  11.555  28.013  1.00 29.77           N  
ATOM   1903  CA  GLY   137       4.027  10.275  28.740  1.00 29.90           C  
ATOM   1906  C   GLY   137       3.441  10.285  30.168  1.00 29.93           C  
ATOM   1907  O   GLY   137       3.670   9.350  30.965  1.00 30.73           O  
ATOM   1909  N   CYS   138       2.667  11.308  30.498  1.00 29.42           N  
ATOM   1910  CA  CYS   138       2.001  11.353  31.793  1.00 29.62           C  
ATOM   1912  CB  CYS   138       2.460  12.576  32.587  1.00 29.79           C  
ATOM   1915  SG  CYS   138       4.218  12.576  32.898  1.00 30.23           S  
ATOM   1917  C   CYS   138       0.490  11.355  31.686  1.00 29.17           C  
ATOM   1918  O   CYS   138      -0.197  11.656  32.652  1.00 28.48           O  
ATOM   1920  N   GLY   139      -0.019  11.016  30.511  1.00 29.34           N  
ATOM   1921  CA  GLY   139      -1.452  11.056  30.270  1.00 29.45           C  
ATOM   1924  C   GLY   139      -1.880  11.464  28.872  1.00 29.50           C  
ATOM   1925  O   GLY   139      -2.898  10.977  28.401  1.00 30.03           O  
ATOM   1927  N   SER   140      -1.121  12.330  28.190  1.00 29.38           N  
ATOM   1928  CA  SER   140      -1.573  12.879  26.892  1.00 28.69           C  
ATOM   1930  CB  SER   140      -0.698  14.057  26.466  1.00 28.93           C  
ATOM   1933  OG  SER   140      -0.859  15.151  27.372  1.00 29.34           O  
ATOM   1935  C   SER   140      -1.596  11.834  25.803  1.00 28.12           C  
ATOM   1936  O   SER   140      -2.623  11.555  25.238  1.00 27.68           O  
ATOM   1938  N   VAL   141      -0.454  11.256  25.506  1.00 28.02           N  
ATOM   1939  CA  VAL   141      -0.395  10.196  24.522  1.00 27.98           C  
ATOM   1941  CB  VAL   141       0.827  10.374  23.645  1.00 27.84           C  
ATOM   1943  CG1 VAL   141       0.846   9.345  22.553  1.00 27.05           C  
ATOM   1947  CG2 VAL   141       0.852  11.775  23.089  1.00 27.21           C  
ATOM   1951  C   VAL   141      -0.345   8.820  25.204  1.00 28.40           C  
ATOM   1952  O   VAL   141      -0.958   7.871  24.753  1.00 28.56           O  
ATOM   1954  N   LEU   142       0.434   8.716  26.266  1.00 28.60           N  
ATOM   1955  CA  LEU   142       0.486   7.511  27.059  1.00 28.88           C  
ATOM   1957  CB  LEU   142       1.655   6.641  26.609  1.00 29.36           C  
ATOM   1960  CG  LEU   142       1.363   5.515  25.614  1.00 29.50           C  
ATOM   1962  CD1 LEU   142       2.672   5.036  24.980  1.00 29.36           C  
ATOM   1966  CD2 LEU   142       0.667   4.390  26.351  1.00 28.79           C  
ATOM   1970  C   LEU   142       0.688   7.927  28.500  1.00 29.16           C  
ATOM   1971  O   LEU   142       1.134   9.040  28.782  1.00 29.17           O  
ATOM   1973  N   ASN   143       0.385   7.034  29.430  1.00 29.52           N  
ATOM   1974  CA  ASN   143       0.660   7.355  30.830  1.00 29.66           C  
ATOM   1976  CB  ASN   143      -0.628   7.395  31.629  1.00 29.61           C  
ATOM   1979  CG  ASN   143      -0.449   8.019  33.008  1.00 30.12           C  
ATOM   1980  OD1 ASN   143       0.647   8.046  33.602  1.00 27.75           O  
ATOM   1981  ND2 ASN   143      -1.567   8.488  33.549  1.00 31.84           N  
ATOM   1984  C   ASN   143       1.656   6.390  31.451  1.00 29.47           C  
ATOM   1985  O   ASN   143       1.281   5.505  32.230  1.00 28.77           O  
ATOM   1987  N   ILE   144       2.927   6.598  31.096  1.00 29.28           N  
ATOM   1988  CA  ILE   144       4.015   5.785  31.617  1.00 29.57           C  
ATOM   1990  CB  ILE   144       5.319   6.097  30.858  1.00 30.11           C  
ATOM   1992  CG1 ILE   144       5.167   5.738  29.372  1.00 31.30           C  
ATOM   1995  CD1 ILE   144       4.789   4.257  29.149  1.00 30.50           C  
ATOM   1999  CG2 ILE   144       6.510   5.303  31.422  1.00 30.18           C  
ATOM   2003  C   ILE   144       4.215   6.059  33.113  1.00 29.39           C  
ATOM   2004  O   ILE   144       4.545   5.141  33.866  1.00 28.54           O  
ATOM   2006  N   ALA   145       4.002   7.321  33.525  1.00 29.02           N  
ATOM   2007  CA  ALA   145       4.144   7.720  34.926  1.00 28.89           C  
ATOM   2009  CB  ALA   145       3.712   9.214  35.134  1.00 28.28           C  
ATOM   2013  C   ALA   145       3.364   6.780  35.871  1.00 29.09           C  
ATOM   2014  O   ALA   145       3.871   6.429  36.949  1.00 30.20           O  
ATOM   2016  N   SER   146       2.152   6.351  35.482  1.00 28.63           N  
ATOM   2017  CA  SER   146       1.299   5.589  36.399  1.00 28.27           C  
ATOM   2019  CB  SER   146      -0.022   6.323  36.579  1.00 28.33           C  
ATOM   2022  OG  SER   146      -0.803   6.270  35.407  1.00 28.49           O  
ATOM   2024  C   SER   146       1.055   4.147  35.959  1.00 27.91           C  
ATOM   2025  O   SER   146       0.192   3.468  36.474  1.00 27.20           O  
ATOM   2027  N   ALA   147       1.844   3.685  35.009  1.00 28.29           N  
ATOM   2028  CA  ALA   147       1.650   2.368  34.418  1.00 28.30           C  
ATOM   2030  CB  ALA   147       2.500   2.220  33.141  1.00 28.16           C  
ATOM   2034  C   ALA   147       2.008   1.281  35.414  1.00 28.18           C  
ATOM   2035  O   ALA   147       3.001   1.382  36.137  1.00 27.83           O  
ATOM   2037  N   ASP   148       1.178   0.248  35.441  1.00 28.60           N  
ATOM   2038  CA  ASP   148       1.422  -0.958  36.235  1.00 29.01           C  
ATOM   2040  CB  ASP   148       0.116  -1.758  36.344  1.00 29.22           C  
ATOM   2043  CG  ASP   148       0.271  -3.024  37.194  1.00 30.33           C  
ATOM   2044  OD1 ASP   148       1.223  -3.009  38.017  1.00 32.80           O  
ATOM   2045  OD2 ASP   148      -0.548  -4.005  37.063  1.00 28.99           O  
ATOM   2046  C   ASP   148       2.529  -1.831  35.603  1.00 28.97           C  
ATOM   2047  O   ASP   148       2.258  -2.648  34.732  1.00 29.13           O  
ATOM   2049  N   LEU   149       3.769  -1.644  36.037  1.00 28.92           N  
ATOM   2050  CA  LEU   149       4.910  -2.289  35.410  1.00 28.99           C  
ATOM   2052  CB  LEU   149       5.672  -1.312  34.501  1.00 28.85           C  
ATOM   2055  CG  LEU   149       4.909  -0.925  33.221  1.00 29.26           C  
ATOM   2057  CD1 LEU   149       5.552   0.303  32.539  1.00 28.15           C  
ATOM   2061  CD2 LEU   149       4.777  -2.100  32.253  1.00 27.32           C  
ATOM   2065  C   LEU   149       5.774  -2.797  36.547  1.00 29.23           C  
ATOM   2066  O   LEU   149       6.621  -2.072  37.076  1.00 29.09           O  
ATOM   2068  N   PRO   150       5.560  -4.060  36.923  1.00 29.54           N  
ATOM   2069  CA  PRO   150       6.060  -4.553  38.210  1.00 29.67           C  
ATOM   2071  CB  PRO   150       5.659  -6.054  38.214  1.00 29.48           C  
ATOM   2074  CG  PRO   150       4.613  -6.214  37.167  1.00 29.39           C  
ATOM   2077  CD  PRO   150       4.844  -5.103  36.153  1.00 29.63           C  
ATOM   2080  C   PRO   150       7.581  -4.399  38.417  1.00 29.61           C  
ATOM   2081  O   PRO   150       8.018  -3.945  39.489  1.00 29.54           O  
ATOM   2082  N   ASN   151       8.376  -4.783  37.422  1.00 29.36           N  
ATOM   2083  CA  ASN   151       9.822  -4.955  37.659  1.00 29.29           C  
ATOM   2085  CB  ASN   151      10.222  -6.417  37.379  1.00 29.22           C  
ATOM   2088  CG  ASN   151       9.393  -7.403  38.184  1.00 29.70           C  
ATOM   2089  OD1 ASN   151       9.515  -7.467  39.415  1.00 31.50           O  
ATOM   2090  ND2 ASN   151       8.529  -8.160  37.506  1.00 29.02           N  
ATOM   2093  C   ASN   151      10.696  -3.953  36.893  1.00 29.09           C  
ATOM   2094  O   ASN   151      11.868  -4.212  36.608  1.00 28.75           O  
ATOM   2096  N   THR   152      10.114  -2.797  36.586  1.00 29.07           N  
ATOM   2097  CA  THR   152      10.816  -1.768  35.853  1.00 29.13           C  
ATOM   2099  CB  THR   152      10.365  -1.749  34.358  1.00 29.31           C  
ATOM   2101  OG1 THR   152       8.964  -1.486  34.277  1.00 28.92           O  
ATOM   2103  CG2 THR   152      10.672  -3.123  33.693  1.00 29.99           C  
ATOM   2107  C   THR   152      10.600  -0.410  36.487  1.00 28.94           C  
ATOM   2108  O   THR   152       9.581   0.221  36.237  1.00 29.39           O  
ATOM   2110  N   GLY   153      11.562   0.038  37.301  1.00 28.73           N  
ATOM   2111  CA  GLY   153      11.483   1.345  37.989  1.00 28.04           C  
ATOM   2114  C   GLY   153      10.359   1.408  39.007  1.00 27.67           C  
ATOM   2115  O   GLY   153       9.875   0.385  39.480  1.00 27.40           O  
ATOM   2117  N   ARG   154       9.926   2.618  39.332  1.00 27.56           N  
ATOM   2118  CA  ARG   154       8.747   2.822  40.177  1.00 27.59           C  
ATOM   2120  CB  ARG   154       9.132   3.433  41.525  1.00 27.45           C  
ATOM   2123  CG  ARG   154       9.477   2.437  42.549  1.00 27.94           C  
ATOM   2126  CD  ARG   154      10.289   3.050  43.692  1.00 29.70           C  
ATOM   2129  NE  ARG   154      11.140   2.009  44.299  1.00 31.13           N  
ATOM   2131  CZ  ARG   154      11.949   2.180  45.345  1.00 30.89           C  
ATOM   2132  NH1 ARG   154      12.044   3.355  45.964  1.00 31.54           N  
ATOM   2135  NH2 ARG   154      12.672   1.155  45.773  1.00 31.08           N  
ATOM   2138  C   ARG   154       7.802   3.767  39.492  1.00 27.48           C  
ATOM   2139  O   ARG   154       8.250   4.674  38.804  1.00 28.31           O  
ATOM   2141  N   PRO   155       6.494   3.619  39.730  1.00 27.20           N  
ATOM   2142  CA  PRO   155       5.580   4.628  39.183  1.00 27.00           C  
ATOM   2144  CB  PRO   155       4.213   4.019  39.450  1.00 27.10           C  
ATOM   2147  CG  PRO   155       4.437   3.158  40.638  1.00 26.63           C  
ATOM   2150  CD  PRO   155       5.785   2.594  40.507  1.00 26.55           C  
ATOM   2153  C   PRO   155       5.717   5.931  39.935  1.00 26.56           C  
ATOM   2154  O   PRO   155       6.093   5.929  41.091  1.00 26.56           O  
ATOM   2155  N   PHE   156       5.403   7.035  39.293  1.00 26.62           N  
ATOM   2156  CA  PHE   156       5.498   8.302  39.973  1.00 27.22           C  
ATOM   2158  CB  PHE   156       6.778   9.058  39.597  1.00 27.60           C  
ATOM   2161  CG  PHE   156       6.860   9.460  38.156  1.00 28.10           C  
ATOM   2162  CD1 PHE   156       6.445  10.730  37.746  1.00 28.61           C  
ATOM   2164  CE1 PHE   156       6.503  11.085  36.419  1.00 27.46           C  
ATOM   2166  CZ  PHE   156       7.012  10.192  35.490  1.00 27.56           C  
ATOM   2168  CE2 PHE   156       7.440   8.944  35.877  1.00 27.45           C  
ATOM   2170  CD2 PHE   156       7.367   8.578  37.206  1.00 27.25           C  
ATOM   2172  C   PHE   156       4.281   9.183  39.828  1.00 27.25           C  
ATOM   2173  O   PHE   156       3.396   8.940  39.036  1.00 27.35           O  
ATOM   2175  N   GLN   157       4.266  10.209  40.661  1.00 28.12           N  
ATOM   2176  CA  GLN   157       3.162  11.132  40.818  1.00 28.30           C  
ATOM   2178  CB  GLN   157       3.023  11.430  42.312  1.00 28.26           C  
ATOM   2181  CG  GLN   157       1.573  11.587  42.818  1.00 29.14           C  
ATOM   2184  CD  GLN   157       0.726  10.354  42.579  1.00 28.88           C  
ATOM   2185  OE1 GLN   157       1.229   9.216  42.576  1.00 28.76           O  
ATOM   2186  NE2 GLN   157      -0.573  10.565  42.387  1.00 28.49           N  
ATOM   2189  C   GLN   157       3.458  12.421  40.041  1.00 28.32           C  
ATOM   2190  O   GLN   157       4.630  12.798  39.874  1.00 28.21           O  
ATOM   2192  N   CYS   158       2.393  13.052  39.540  1.00 28.34           N  
ATOM   2193  CA  CYS   158       2.457  14.325  38.805  1.00 28.55           C  
ATOM   2195  CB  CYS   158       2.053  14.113  37.368  1.00 28.36           C  
ATOM   2198  SG  CYS   158       3.234  13.191  36.449  1.00 32.99           S  
ATOM   2200  C   CYS   158       1.518  15.370  39.380  1.00 28.03           C  
ATOM   2201  O   CYS   158       0.415  15.028  39.825  1.00 28.21           O  
ATOM   2203  N   ILE   159       1.945  16.633  39.348  1.00 27.55           N  
ATOM   2204  CA  ILE   159       1.083  17.776  39.671  1.00 27.15           C  
ATOM   2206  CB  ILE   159       1.560  18.532  40.932  1.00 27.19           C  
ATOM   2208  CG1 ILE   159       1.641  17.546  42.109  1.00 27.25           C  
ATOM   2211  CD1 ILE   159       1.732  18.195  43.500  1.00 27.36           C  
ATOM   2215  CG2 ILE   159       0.655  19.748  41.227  1.00 26.47           C  
ATOM   2219  C   ILE   159       1.151  18.672  38.468  1.00 27.06           C  
ATOM   2220  O   ILE   159       2.008  19.550  38.397  1.00 27.30           O  
ATOM   2222  N   PRO   160       0.298  18.414  37.472  1.00 27.10           N  
ATOM   2223  CA  PRO   160       0.305  19.229  36.281  1.00 27.19           C  
ATOM   2225  CB  PRO   160      -0.544  18.406  35.303  1.00 26.90           C  
ATOM   2228  CG  PRO   160      -1.433  17.695  36.094  1.00 26.70           C  
ATOM   2231  CD  PRO   160      -0.693  17.339  37.350  1.00 27.27           C  
ATOM   2234  C   PRO   160      -0.314  20.600  36.470  1.00 27.02           C  
ATOM   2235  O   PRO   160      -0.932  20.865  37.479  1.00 27.06           O  
ATOM   2236  N   GLY   161      -0.094  21.468  35.491  1.00 27.50           N  
ATOM   2237  CA  GLY   161      -0.924  22.640  35.290  1.00 27.79           C  
ATOM   2240  C   GLY   161      -0.387  23.921  35.877  1.00 27.97           C  
ATOM   2241  O   GLY   161      -0.988  24.972  35.702  1.00 28.30           O  
ATOM   2243  N   TYR   162       0.734  23.872  36.581  1.00 28.36           N  
ATOM   2244  CA  TYR   162       1.233  25.110  37.155  1.00 28.73           C  
ATOM   2246  CB  TYR   162       2.370  24.897  38.182  1.00 29.03           C  
ATOM   2249  CG  TYR   162       2.842  26.246  38.703  1.00 30.02           C  
ATOM   2250  CD1 TYR   162       2.168  26.905  39.728  1.00 30.55           C  
ATOM   2252  CE1 TYR   162       2.574  28.183  40.156  1.00 31.77           C  
ATOM   2254  CZ  TYR   162       3.668  28.808  39.529  1.00 32.70           C  
ATOM   2255  OH  TYR   162       4.146  30.073  39.894  1.00 31.50           O  
ATOM   2257  CE2 TYR   162       4.321  28.152  38.497  1.00 32.51           C  
ATOM   2259  CD2 TYR   162       3.893  26.901  38.083  1.00 31.20           C  
ATOM   2261  C   TYR   162       1.658  26.061  36.018  1.00 28.23           C  
ATOM   2262  O   TYR   162       2.606  25.766  35.303  1.00 27.90           O  
ATOM   2264  N   ARG   163       0.938  27.177  35.868  1.00 27.90           N  
ATOM   2265  CA  ARG   163       1.139  28.134  34.763  1.00 27.84           C  
ATOM   2267  CB  ARG   163       2.396  28.962  35.001  1.00 27.51           C  
ATOM   2270  CG  ARG   163       2.350  29.744  36.287  1.00 28.30           C  
ATOM   2273  CD  ARG   163       3.691  30.412  36.611  1.00 28.58           C  
ATOM   2276  NE  ARG   163       3.973  31.592  35.798  1.00 29.09           N  
ATOM   2278  CZ  ARG   163       5.109  32.290  35.861  1.00 29.67           C  
ATOM   2279  NH1 ARG   163       6.078  31.937  36.710  1.00 30.17           N  
ATOM   2282  NH2 ARG   163       5.285  33.355  35.082  1.00 29.92           N  
ATOM   2285  C   ARG   163       1.174  27.499  33.350  1.00 27.71           C  
ATOM   2286  O   ARG   163       1.954  27.913  32.497  1.00 27.28           O  
ATOM   2288  N   ALA   164       0.302  26.517  33.113  1.00 27.57           N  
ATOM   2289  CA  ALA   164       0.159  25.891  31.798  1.00 27.60           C  
ATOM   2291  CB  ALA   164      -1.012  24.920  31.791  1.00 27.29           C  
ATOM   2295  C   ALA   164      -0.012  26.895  30.656  1.00 27.60           C  
ATOM   2296  O   ALA   164       0.579  26.704  29.599  1.00 27.70           O  
ATOM   2298  N   GLU   165      -0.800  27.951  30.862  1.00 27.39           N  
ATOM   2299  CA  GLU   165      -1.129  28.868  29.776  1.00 27.48           C  
ATOM   2301  CB  GLU   165      -2.048  29.961  30.262  1.00 27.81           C  
ATOM   2304  CG  GLU   165      -3.485  29.532  30.421  1.00 28.47           C  
ATOM   2307  CD  GLU   165      -4.392  30.708  30.786  1.00 30.58           C  
ATOM   2308  OE1 GLU   165      -4.442  31.711  30.023  1.00 30.66           O  
ATOM   2309  OE2 GLU   165      -5.060  30.633  31.849  1.00 32.43           O  
ATOM   2310  C   GLU   165       0.095  29.506  29.147  1.00 27.46           C  
ATOM   2311  O   GLU   165       0.268  29.497  27.928  1.00 27.18           O  
ATOM   2313  N   GLU   166       0.952  30.060  29.986  1.00 27.59           N  
ATOM   2314  CA  GLU   166       2.217  30.598  29.507  1.00 27.66           C  
ATOM   2316  CB  GLU   166       2.961  31.263  30.642  1.00 27.89           C  
ATOM   2319  CG  GLU   166       2.239  32.502  31.138  1.00 28.65           C  
ATOM   2322  CD  GLU   166       2.848  33.086  32.398  1.00 29.34           C  
ATOM   2323  OE1 GLU   166       3.360  32.322  33.252  1.00 28.90           O  
ATOM   2324  OE2 GLU   166       2.794  34.329  32.526  1.00 30.57           O  
ATOM   2325  C   GLU   166       3.097  29.544  28.876  1.00 27.37           C  
ATOM   2326  O   GLU   166       3.672  29.780  27.827  1.00 27.66           O  
ATOM   2328  N   ALA   167       3.185  28.376  29.498  1.00 27.20           N  
ATOM   2329  CA  ALA   167       3.951  27.277  28.926  1.00 26.97           C  
ATOM   2331  CB  ALA   167       3.988  26.105  29.869  1.00 26.83           C  
ATOM   2335  C   ALA   167       3.441  26.861  27.541  1.00 26.95           C  
ATOM   2336  O   ALA   167       4.225  26.686  26.627  1.00 27.07           O  
ATOM   2338  N   VAL   168       2.146  26.697  27.351  1.00 27.13           N  
ATOM   2339  CA  VAL   168       1.671  26.376  25.996  1.00 27.57           C  
ATOM   2341  CB  VAL   168       0.208  25.937  25.964  1.00 27.39           C  
ATOM   2343  CG1 VAL   168       0.085  24.566  26.594  1.00 27.92           C  
ATOM   2347  CG2 VAL   168      -0.663  26.963  26.637  1.00 26.18           C  
ATOM   2351  C   VAL   168       1.852  27.548  25.023  1.00 28.01           C  
ATOM   2352  O   VAL   168       2.143  27.336  23.839  1.00 27.90           O  
ATOM   2354  N   GLU   169       1.711  28.781  25.515  1.00 28.22           N  
ATOM   2355  CA  GLU   169       1.960  29.937  24.661  1.00 28.31           C  
ATOM   2357  CB  GLU   169       1.661  31.238  25.379  1.00 28.19           C  
ATOM   2360  CG  GLU   169       0.934  32.227  24.473  1.00 29.54           C  
ATOM   2363  CD  GLU   169       0.943  33.661  25.021  1.00 31.96           C  
ATOM   2364  OE1 GLU   169       1.714  33.912  26.000  1.00 34.14           O  
ATOM   2365  OE2 GLU   169       0.198  34.544  24.472  1.00 32.15           O  
ATOM   2366  C   GLU   169       3.388  29.963  24.101  1.00 28.30           C  
ATOM   2367  O   GLU   169       3.597  30.326  22.943  1.00 28.98           O  
ATOM   2369  N   MET   170       4.367  29.589  24.914  1.00 28.08           N  
ATOM   2370  CA  MET   170       5.754  29.551  24.453  1.00 28.04           C  
ATOM   2372  CB  MET   170       6.726  29.335  25.622  1.00 27.87           C  
ATOM   2375  CG  MET   170       7.074  30.615  26.367  1.00 28.33           C  
ATOM   2378  SD  MET   170       8.249  30.471  27.752  1.00 28.55           S  
ATOM   2379  CE  MET   170       7.214  29.683  28.987  1.00 27.96           C  
ATOM   2383  C   MET   170       5.940  28.468  23.400  1.00 28.13           C  
ATOM   2384  O   MET   170       6.505  28.715  22.348  1.00 28.20           O  
ATOM   2386  N   LEU   171       5.473  27.261  23.700  1.00 28.42           N  
ATOM   2387  CA  LEU   171       5.558  26.143  22.769  1.00 28.42           C  
ATOM   2389  CB  LEU   171       4.834  24.913  23.331  1.00 28.74           C  
ATOM   2392  CG  LEU   171       5.614  23.807  24.025  1.00 28.64           C  
ATOM   2394  CD1 LEU   171       4.612  22.730  24.485  1.00 27.77           C  
ATOM   2398  CD2 LEU   171       6.693  23.239  23.103  1.00 28.05           C  
ATOM   2402  C   LEU   171       4.911  26.485  21.439  1.00 28.37           C  
ATOM   2403  O   LEU   171       5.433  26.122  20.377  1.00 28.57           O  
ATOM   2405  N   LYS   172       3.753  27.142  21.499  1.00 28.00           N  
ATOM   2406  CA  LYS   172       3.012  27.463  20.274  1.00 27.85           C  
ATOM   2408  CB  LYS   172       1.593  28.000  20.576  1.00 27.67           C  
ATOM   2411  CG  LYS   172       0.523  26.888  20.684  1.00 27.83           C  
ATOM   2414  CD  LYS   172      -0.851  27.407  21.176  1.00 28.79           C  
ATOM   2417  CE  LYS   172      -1.973  26.373  20.896  1.00 29.34           C  
ATOM   2420  NZ  LYS   172      -2.428  26.347  19.368  1.00 29.31           N  
ATOM   2424  C   LYS   172       3.815  28.432  19.425  1.00 27.32           C  
ATOM   2425  O   LYS   172       3.942  28.266  18.218  1.00 27.26           O  
ATOM   2427  N   THR   173       4.380  29.432  20.074  1.00 27.30           N  
ATOM   2428  CA  THR   173       5.135  30.429  19.362  1.00 27.36           C  
ATOM   2430  CB  THR   173       5.501  31.639  20.254  1.00 26.82           C  
ATOM   2432  OG1 THR   173       6.315  32.503  19.498  1.00 28.03           O  
ATOM   2434  CG2 THR   173       6.295  31.285  21.426  1.00 26.84           C  
ATOM   2438  C   THR   173       6.353  29.769  18.728  1.00 27.39           C  
ATOM   2439  O   THR   173       6.729  30.102  17.611  1.00 27.65           O  
ATOM   2441  N   PHE   174       6.925  28.799  19.429  1.00 27.67           N  
ATOM   2442  CA  PHE   174       8.075  28.052  18.934  1.00 27.96           C  
ATOM   2444  CB  PHE   174       8.691  27.157  20.029  1.00 28.11           C  
ATOM   2447  CG  PHE   174       9.701  26.141  19.491  1.00 27.94           C  
ATOM   2448  CD1 PHE   174      11.002  26.527  19.174  1.00 26.47           C  
ATOM   2450  CE1 PHE   174      11.911  25.605  18.678  1.00 26.06           C  
ATOM   2452  CZ  PHE   174      11.523  24.288  18.477  1.00 25.76           C  
ATOM   2454  CE2 PHE   174      10.242  23.892  18.780  1.00 26.66           C  
ATOM   2456  CD2 PHE   174       9.334  24.807  19.287  1.00 27.84           C  
ATOM   2458  C   PHE   174       7.766  27.179  17.721  1.00 28.18           C  
ATOM   2459  O   PHE   174       8.631  27.024  16.863  1.00 28.86           O  
ATOM   2461  N   TYR   175       6.575  26.582  17.646  1.00 28.31           N  
ATOM   2462  CA  TYR   175       6.244  25.756  16.479  1.00 28.37           C  
ATOM   2464  CB  TYR   175       5.120  24.775  16.797  1.00 28.20           C  
ATOM   2467  CG  TYR   175       5.549  23.642  17.687  1.00 29.03           C  
ATOM   2468  CD1 TYR   175       4.708  23.182  18.704  1.00 29.68           C  
ATOM   2470  CE1 TYR   175       5.092  22.132  19.551  1.00 30.13           C  
ATOM   2472  CZ  TYR   175       6.344  21.524  19.369  1.00 30.83           C  
ATOM   2473  OH  TYR   175       6.716  20.480  20.195  1.00 33.11           O  
ATOM   2475  CE2 TYR   175       7.205  21.961  18.362  1.00 29.36           C  
ATOM   2477  CD2 TYR   175       6.801  23.013  17.521  1.00 29.43           C  
ATOM   2479  C   TYR   175       5.922  26.556  15.211  1.00 28.44           C  
ATOM   2480  O   TYR   175       5.590  25.962  14.192  1.00 28.62           O  
ATOM   2482  N   LYS   176       6.052  27.880  15.254  1.00 28.50           N  
ATOM   2483  CA  LYS   176       6.067  28.676  14.029  1.00 29.01           C  
ATOM   2485  CB  LYS   176       5.261  29.955  14.213  1.00 28.81           C  
ATOM   2488  CG  LYS   176       3.855  29.628  14.728  1.00 29.06           C  
ATOM   2491  CD  LYS   176       3.017  30.883  15.126  1.00 28.97           C  
ATOM   2494  CE  LYS   176       1.805  30.431  16.053  1.00 28.62           C  
ATOM   2497  NZ  LYS   176       0.966  31.639  16.480  1.00 28.07           N  
ATOM   2501  C   LYS   176       7.516  28.924  13.596  1.00 29.73           C  
ATOM   2502  O   LYS   176       8.033  30.071  13.612  1.00 29.38           O  
ATOM   2504  N   GLN   177       8.151  27.782  13.243  1.00 30.84           N  
ATOM   2505  CA  GLN   177       9.491  27.720  12.613  1.00 31.22           C  
ATOM   2507  CB  GLN   177      10.615  28.236  13.553  1.00 31.62           C  
ATOM   2510  CG  GLN   177      12.100  28.010  13.035  1.00 32.08           C  
ATOM   2513  CD  GLN   177      12.575  29.029  11.958  1.00 32.52           C  
ATOM   2514  OE1 GLN   177      12.497  30.261  12.160  1.00 31.81           O  
ATOM   2515  NE2 GLN   177      13.111  28.498  10.831  1.00 31.77           N  
ATOM   2518  C   GLN   177       9.731  26.249  12.215  1.00 30.80           C  
ATOM   2519  O   GLN   177       9.033  25.353  12.722  1.00 29.50           O  
END
