
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  147 ( 1152),  selected  147 , name 2hvw_A
# Molecule2: number of CA atoms  162 ( 1272),  selected  162 , name T0461.pdb
# PARAMETERS: 2hvw_A.T0461.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     3_A      E      16           -
LGA    R     4_A      N      17           -
LGA    L     5_A      L      18           -
LGA    -       -      Y      19           -
LGA    -       -      F      20           -
LGA    -       -      Q      21           -
LGA    -       -      S      22           -
LGA    S     6_A      M      23          3.614
LGA    W     7_A      E      24          3.549
LGA    -       -      E      25           -
LGA    Q     8_A      T      26          1.888
LGA    D     9_A      E      27          0.642
LGA    Y    10_A      K      28          0.841
LGA    F    11_A      W      29          1.241
LGA    M    12_A      M      30          0.916
LGA    A    13_A      E      31          0.748
LGA    N    14_A      E      32          1.410
LGA    A    15_A      A      33          1.011
LGA    E    16_A      M      34          0.803
LGA    L    17_A      H      35          1.575
LGA    I    18_A      M      36          2.082
LGA    S    19_A      A      37          1.887
LGA    K    20_A      K      38          2.745
LGA    R    21_A      E      39          2.541
LGA    S    22_A      A      40          1.340
LGA    -       -      L      41           -
LGA    -       -      E      42           -
LGA    T    23_A      N      43          3.228
LGA    C    24_A      T      44          3.819
LGA    N    25_A      E      45          4.395
LGA    R    26_A      -       -           -
LGA    A    27_A      V      46          3.028
LGA    Y    28_A      P      47          0.308
LGA    V    29_A      V      48          0.316
LGA    G    30_A      G      49          0.369
LGA    A    31_A      C      50          0.721
LGA    V    32_A      L      51          0.520
LGA    L    33_A      M      52          0.508
LGA    V    34_A      V      53          1.154
LGA    K    35_A      Y      54          1.326
LGA    N    36_A      N      55          2.826
LGA    N    37_A      N      56          3.350
LGA    R    38_A      E      57          2.391
LGA    I    39_A      V      58          1.376
LGA    I    40_A      V      59          0.740
LGA    A    41_A      G      60          0.635
LGA    T    42_A      K      61          0.495
LGA    G    43_A      G      62          0.154
LGA    Y    44_A      R      63          0.172
LGA    N    45_A      N      64          0.225
LGA    G    46_A      E      65          1.157
LGA    G    47_A      V      66          3.384
LGA    V    48_A      -       -           -
LGA    A    49_A      -       -           -
LGA    D    50_A      -       -           -
LGA    T    51_A      -       -           -
LGA    D    52_A      N      67          5.308
LGA    N    53_A      Q      68          2.592
LGA    C    54_A      T      69           -
LGA    D    55_A      K      70           -
LGA    D    56_A      N      71           -
LGA    V    57_A      -       -           -
LGA    G    58_A      -       -           -
LGA    H    59_A      -       -           -
LGA    E    60_A      -       -           -
LGA    M    61_A      -       -           -
LGA    E    62_A      -       -           -
LGA    D    63_A      -       -           -
LGA    G    64_A      -       -           -
LGA    H    65_A      -       -           -
LGA    C    66_A      -       -           -
LGA    I    67_A      A      72          2.679
LGA    R    68_A      -       -           -
LGA    T    69_A      T      73          5.709
LGA    V    70_A      R      74          0.878
LGA    H    71_A      H      75          0.387
LGA    A    72_A      A      76          0.437
LGA    E    73_A      E      77          0.514
LGA    M    74_A      M      78          0.528
LGA    N    75_A      V      79          0.456
LGA    A    76_A      A      80          0.252
LGA    L    77_A      I      81          0.181
LGA    I    78_A      D      82          1.103
LGA    Q    79_A      Q      83          1.284
LGA    C    80_A      V      84          2.260
LGA    A    81_A      L      85          2.829
LGA    K    82_A      -       -           -
LGA    E    83_A      D      86          1.749
LGA    G    84_A      W      87          4.773
LGA    I    85_A      C      88          1.807
LGA    S    86_A      R      89           #
LGA    -       -      Q      90           -
LGA    -       -      S      91           -
LGA    -       -      G      92           -
LGA    -       -      K      93           -
LGA    -       -      S      94           -
LGA    A    87_A      P      95          5.024
LGA    N    88_A      S      96          3.849
LGA    -       -      E      97           -
LGA    -       -      V      98           -
LGA    -       -      F      99           -
LGA    N    89_A      E     100          1.855
LGA    -       -      H     101           -
LGA    T    90_A      T     102          0.852
LGA    E    91_A      V     103          1.256
LGA    I    92_A      L     104          0.239
LGA    Y    93_A      Y     105          0.572
LGA    V    94_A      V     106          0.219
LGA    T    95_A      T     107          0.101
LGA    H    96_A      V     108          0.323
LGA    F    97_A      E     109          0.361
LGA    P    98_A      P     110          0.364
LGA    C    99_A      C     111          0.632
LGA    I   100_A      I     112          1.105
LGA    N   101_A      M     113          1.067
LGA    C   102_A      C     114          0.861
LGA    T   103_A      A     115          0.911
LGA    K   104_A      A     116          1.461
LGA    A   105_A      A     117          1.409
LGA    L   106_A      L     118          1.496
LGA    L   107_A      R     119          1.668
LGA    Q   108_A      L     120          1.232
LGA    A   109_A      M     121          1.313
LGA    G   110_A      K     122          2.131
LGA    V   111_A      I     123          0.669
LGA    K   112_A      P     124          0.542
LGA    K   113_A      L     125          0.683
LGA    I   114_A      V     126          0.750
LGA    T   115_A      V     127          0.749
LGA    Y   116_A      Y     128          0.556
LGA    N   117_A      G     129          0.318
LGA    T   118_A      C     130          1.048
LGA    A   119_A      Q     131          0.497
LGA    Y   120_A      N     132          1.364
LGA    R   121_A      E     133          2.410
LGA    -       -      R     134           -
LGA    -       -      F     135           -
LGA    I   122_A      G     136          2.067
LGA    H   123_A      G     137          3.575
LGA    -       -      C     138           -
LGA    -       -      G     139           -
LGA    -       -      S     140           -
LGA    P   124_A      V     141          3.572
LGA    F   125_A      L     142          3.199
LGA    A   126_A      -       -           -
LGA    I   127_A      N     143          1.171
LGA    E   128_A      I     144          3.573
LGA    L   129_A      A     145          4.228
LGA    M   130_A      S     146          3.052
LGA    T   131_A      A     147          3.711
LGA    Q   132_A      D     148          2.921
LGA    -       -      L     149           -
LGA    -       -      P     150           -
LGA    -       -      N     151           -
LGA    -       -      T     152           -
LGA    -       -      G     153           -
LGA    K   133_A      R     154          3.242
LGA    E   134_A      P     155          3.125
LGA    V   135_A      F     156          0.908
LGA    E   136_A      Q     157          0.667
LGA    Y   137_A      C     158          1.005
LGA    V   138_A      I     159          0.927
LGA    Q   139_A      P     160          0.977
LGA    H   140_A      G     161          3.530
LGA    D   141_A      Y     162          1.823
LGA    V   142_A      R     163          3.433
LGA    -       -      A     164           -
LGA    -       -      E     165           -
LGA    P   143_A      E     166           #
LGA    R   144_A      A     167           -
LGA    V   145_A      V     168           -
LGA    K   146_A      E     169           -
LGA    L   147_A      M     170           -
LGA    G   148_A      L     171           -
LGA    E   149_A      K     172           -
LGA    -       -      T     173           -
LGA    -       -      F     174           -
LGA    -       -      Y     175           -
LGA    -       -      K     176           -
LGA    -       -      Q     177           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  147  162    5.0    115    2.12    24.35     55.565     5.170

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.777687 * X  +  -0.593140 * Y  +   0.208297 * Z  +  18.448606
  Y_new =  -0.627963 * X  +   0.748456 * Y  +  -0.213250 * Z  +  24.951025
  Z_new =  -0.029414 * X  +  -0.296645 * Y  +  -0.954535 * Z  +  77.882957 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.840281    0.301312  [ DEG:  -162.7361     17.2639 ]
  Theta =   0.029418    3.112175  [ DEG:     1.6855    178.3145 ]
  Phi   =  -2.462310    0.679283  [ DEG:  -141.0800     38.9200 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hvw_A                                        
REMARK     2: T0461.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hvw_A.T0461.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  147  162   5.0  115   2.12   24.35  55.565
REMARK  ---------------------------------------------------------- 
MOLECULE 2hvw_A
HEADER    HYDROLASE                               31-JUL-06   2HVW              
TITLE     CRYSTAL STRUCTURE OF DCMP DEAMINASE FROM STREPTOCOCCUS                
TITLE    2 MUTANS                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DEOXYCYTIDYLATE DEAMINASE;                                 
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 EC: 3.5.4.12;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS MUTANS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: COMEB;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28A(+)                                 
KEYWDS    3-LAYER (ALPHA-BETA)-SANDWICH, PROTEIN-LIAND COMPLEX,                 
KEYWDS   2 HYDROLASE                                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.F.HOU,Z.Q.GAO,L.F.LI,Y.H.LIANG,X.D.SU,Y.H.DONG                      
REVDAT   2   11-MAR-08 2HVW    1       JRNL                                     
REVDAT   1   11-SEP-07 2HVW    0                                                
JRNL        AUTH   H.F.HOU,Y.H.LIANG,L.F.LI,X.D.SU,Y.H.DONG                     
JRNL        TITL   CRYSTAL STRUCTURES OF STREPTOCOCCUS MUTANS                   
JRNL        TITL 2 2'-DEOXYCYTIDYLATE DEAMINASE AND ITS COMPLEX WITH            
JRNL        TITL 3 SUBSTRATE ANALOG AND ALLOSTERIC REGULATOR                    
JRNL        TITL 4 DCTP.MG(2+)                                                  
JRNL        REF    J.MOL.BIOL.                                2008              
JRNL        REFN   ASTM JMOBAK  UK ESSN 1089-8638                               
REMARK   2 RESOLUTION. 1.67 ANGSTROMS.                                          
DBREF  2HVW A    1   150  UNP    Q8DSE5   Q8DSE5_STRMU     1    150             
DBREF  2HVW B    1   150  UNP    Q8DSE5   Q8DSE5_STRMU     1    150             
DBREF  2HVW C    1   150  UNP    Q8DSE5   Q8DSE5_STRMU     1    150             
SEQRES   1 A  184  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  184  LEU VAL PRO ARG GLY SER HIS MET ALA SER MET THR GLY          
SEQRES   3 A  184  GLY GLN GLN MET GLY ARG GLY SER MET THR ASN ARG LEU          
SEQRES   4 A  184  SER TRP GLN ASP TYR PHE MET ALA ASN ALA GLU LEU ILE          
SEQRES   5 A  184  SER LYS ARG SER THR CYS ASN ARG ALA TYR VAL GLY ALA          
SEQRES   6 A  184  VAL LEU VAL LYS ASN ASN ARG ILE ILE ALA THR GLY TYR          
SEQRES   7 A  184  ASN GLY GLY VAL ALA ASP THR ASP ASN CYS ASP ASP VAL          
SEQRES   8 A  184  GLY HIS GLU MET GLU ASP GLY HIS CYS ILE ARG THR VAL          
SEQRES   9 A  184  HIS ALA GLU MET ASN ALA LEU ILE GLN CYS ALA LYS GLU          
SEQRES  10 A  184  GLY ILE SER ALA ASN ASN THR GLU ILE TYR VAL THR HIS          
SEQRES  11 A  184  PHE PRO CYS ILE ASN CYS THR LYS ALA LEU LEU GLN ALA          
SEQRES  12 A  184  GLY VAL LYS LYS ILE THR TYR ASN THR ALA TYR ARG ILE          
SEQRES  13 A  184  HIS PRO PHE ALA ILE GLU LEU MET THR GLN LYS GLU VAL          
SEQRES  14 A  184  GLU TYR VAL GLN HIS ASP VAL PRO ARG VAL LYS LEU GLY          
SEQRES  15 A  184  GLU LYS                                                      
SEQRES   1 B  184  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 B  184  LEU VAL PRO ARG GLY SER HIS MET ALA SER MET THR GLY          
SEQRES   3 B  184  GLY GLN GLN MET GLY ARG GLY SER MET THR ASN ARG LEU          
SEQRES   4 B  184  SER TRP GLN ASP TYR PHE MET ALA ASN ALA GLU LEU ILE          
SEQRES   5 B  184  SER LYS ARG SER THR CYS ASN ARG ALA TYR VAL GLY ALA          
SEQRES   6 B  184  VAL LEU VAL LYS ASN ASN ARG ILE ILE ALA THR GLY TYR          
SEQRES   7 B  184  ASN GLY GLY VAL ALA ASP THR ASP ASN CYS ASP ASP VAL          
SEQRES   8 B  184  GLY HIS GLU MET GLU ASP GLY HIS CYS ILE ARG THR VAL          
SEQRES   9 B  184  HIS ALA GLU MET ASN ALA LEU ILE GLN CYS ALA LYS GLU          
SEQRES  10 B  184  GLY ILE SER ALA ASN ASN THR GLU ILE TYR VAL THR HIS          
SEQRES  11 B  184  PHE PRO CYS ILE ASN CYS THR LYS ALA LEU LEU GLN ALA          
SEQRES  12 B  184  GLY VAL LYS LYS ILE THR TYR ASN THR ALA TYR ARG ILE          
SEQRES  13 B  184  HIS PRO PHE ALA ILE GLU LEU MET THR GLN LYS GLU VAL          
SEQRES  14 B  184  GLU TYR VAL GLN HIS ASP VAL PRO ARG VAL LYS LEU GLY          
SEQRES  15 B  184  GLU LYS                                                      
SEQRES   1 C  184  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 C  184  LEU VAL PRO ARG GLY SER HIS MET ALA SER MET THR GLY          
SEQRES   3 C  184  GLY GLN GLN MET GLY ARG GLY SER MET THR ASN ARG LEU          
SEQRES   4 C  184  SER TRP GLN ASP TYR PHE MET ALA ASN ALA GLU LEU ILE          
SEQRES   5 C  184  SER LYS ARG SER THR CYS ASN ARG ALA TYR VAL GLY ALA          
SEQRES   6 C  184  VAL LEU VAL LYS ASN ASN ARG ILE ILE ALA THR GLY TYR          
SEQRES   7 C  184  ASN GLY GLY VAL ALA ASP THR ASP ASN CYS ASP ASP VAL          
SEQRES   8 C  184  GLY HIS GLU MET GLU ASP GLY HIS CYS ILE ARG THR VAL          
SEQRES   9 C  184  HIS ALA GLU MET ASN ALA LEU ILE GLN CYS ALA LYS GLU          
SEQRES  10 C  184  GLY ILE SER ALA ASN ASN THR GLU ILE TYR VAL THR HIS          
SEQRES  11 C  184  PHE PRO CYS ILE ASN CYS THR LYS ALA LEU LEU GLN ALA          
SEQRES  12 C  184  GLY VAL LYS LYS ILE THR TYR ASN THR ALA TYR ARG ILE          
SEQRES  13 C  184  HIS PRO PHE ALA ILE GLU LEU MET THR GLN LYS GLU VAL          
SEQRES  14 C  184  GLU TYR VAL GLN HIS ASP VAL PRO ARG VAL LYS LEU GLY          
SEQRES  15 C  184  GLU LYS                                                      
HET     ZN  A1001       1                                                       
HET     ZN  A1002       1                                                       
HET     MG  A1101       1                                                       
HET     ZN  B1003       1                                                       
HET     ZN  B1004       1                                                       
HET     MG  B1102       1                                                       
HET     ZN  C1005       1                                                       
HET     ZN  C1006       1                                                       
HET     MG  C1103       1                                                       
HET    DCP  A1201      28                                                       
HET    DDN  A1301      20                                                       
HET    DIO  A1401       6                                                       
HET    DCP  B1202      28                                                       
HET    DDN  B1302      20                                                       
HET    DIO  B1402       6                                                       
HET    DCP  C1203      28                                                       
HET    DDN  C1303      20                                                       
HET    DIO  C1403       6                                                       
HETNAM      ZN ZINC ION                                                         
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     DCP 2'-DEOXYCYTIDINE-5'-TRIPHOSPHATE                                 
HETNAM     DDN 3,4-DIHYDRO-2'-DEOXYURIDINE-5'-MONOPHOSPHATE                     
HETNAM     DIO 1,4-DIETHYLENE DIOXIDE                                           
HETSYN     DDN ((2R,3S,5R)-3-HYDROXY-5-(4-HYDROXY-2-OXO-3,4-                    
HETSYN   2 DDN  DIHYDROPYRIMIDIN-1(2H)-YL)-TETRAHYDROFURAN-2-YL)                
HETSYN   3 DDN  METHYL DIHYDROGEN PHOSPHATE                                     
FORMUL   4   ZN    6(ZN 2+)                                                     
FORMUL   6   MG    3(MG 2+)                                                     
FORMUL  13  DCP    3(C9 H16 N3 O13 P3)                                          
FORMUL  14  DDN    3(C9 H15 N2 O8 P)                                            
FORMUL  15  DIO    3(C4 H8 O2)                                                  
FORMUL  22  HOH   *784(H2 O)                                                    
CRYST1   95.498   99.657  141.388  90.00  90.00  90.00 C 2 2 21     24          
ATOM      1  N   ASN A   3       1.981  35.851  51.324  0.50 27.50           N  
ATOM      2  CA  ASN A   3       1.930  35.888  49.836  0.50 27.35           C  
ATOM      3  C   ASN A   3       3.278  35.524  49.218  0.50 26.83           C  
ATOM      4  O   ASN A   3       3.462  35.629  47.999  0.50 26.84           O  
ATOM      5  CB  ASN A   3       1.481  37.260  49.340  0.50 27.64           C  
ATOM      6  CG  ASN A   3       2.513  38.332  49.601  0.50 28.33           C  
ATOM      7  OD1 ASN A   3       2.603  38.863  50.708  0.50 29.83           O  
ATOM      8  ND2 ASN A   3       3.299  38.660  48.582  0.50 28.94           N  
ATOM      9  N   ARG A   4       4.214  35.117  50.076  0.50 26.22           N  
ATOM     10  CA  ARG A   4       5.491  34.543  49.653  1.00 25.37           C  
ATOM     11  C   ARG A   4       5.212  33.390  48.684  1.00 23.80           C  
ATOM     12  O   ARG A   4       4.210  32.686  48.831  1.00 24.52           O  
ATOM     13  CB  ARG A   4       6.244  34.006  50.879  1.00 25.80           C  
ATOM     14  CG  ARG A   4       7.740  33.808  50.705  1.00 25.87           C  
ATOM     15  CD  ARG A   4       8.497  33.709  52.064  1.00 25.40           C  
ATOM     16  NE  ARG A   4       7.922  32.712  52.961  1.00 24.41           N  
ATOM     17  CZ  ARG A   4       8.554  31.637  53.441  1.00 22.88           C  
ATOM     18  NH1 ARG A   4       7.900  30.813  54.242  1.00 21.76           N  
ATOM     19  NH2 ARG A   4       9.826  31.387  53.146  1.00 18.66           N  
ATOM     20  N   LEU A   5       6.101  33.178  47.713  1.00 22.12           N  
ATOM     21  CA  LEU A   5       5.958  32.023  46.821  1.00 20.18           C  
ATOM     22  C   LEU A   5       6.006  30.712  47.597  1.00 19.16           C  
ATOM     23  O   LEU A   5       6.960  30.455  48.351  1.00 18.40           O  
ATOM     24  CB  LEU A   5       7.041  32.006  45.736  1.00 19.92           C  
ATOM     25  CG  LEU A   5       7.049  33.140  44.699  1.00 19.86           C  
ATOM     26  CD1 LEU A   5       8.200  32.940  43.711  1.00 19.81           C  
ATOM     27  CD2 LEU A   5       5.715  33.228  43.966  1.00 20.33           C  
ATOM     28  N   SER A   6       4.979  29.886  47.397  1.00 18.16           N  
ATOM     29  CA  SER A   6       4.978  28.522  47.924  1.00 17.53           C  
ATOM     30  C   SER A   6       6.125  27.740  47.274  1.00 16.88           C  
ATOM     31  O   SER A   6       6.643  28.156  46.236  1.00 16.69           O  
ATOM     32  CB  SER A   6       3.660  27.828  47.587  1.00 18.22           C  
ATOM     33  OG  SER A   6       3.543  27.673  46.182  1.00 18.51           O  
ATOM     34  N   TRP A   7       6.490  26.600  47.857  1.00 16.46           N  
ATOM     35  CA  TRP A   7       7.525  25.749  47.252  1.00 15.84           C  
ATOM     36  C   TRP A   7       7.180  25.381  45.801  1.00 15.73           C  
ATOM     37  O   TRP A   7       8.025  25.481  44.905  1.00 14.81           O  
ATOM     38  CB  TRP A   7       7.754  24.489  48.078  1.00 15.98           C  
ATOM     39  CG  TRP A   7       8.517  24.730  49.348  1.00 15.67           C  
ATOM     40  CD1 TRP A   7       8.077  24.514  50.633  1.00 15.31           C  
ATOM     41  CD2 TRP A   7       9.859  25.229  49.461  1.00 14.64           C  
ATOM     42  NE1 TRP A   7       9.066  24.838  51.533  1.00 15.72           N  
ATOM     43  CE2 TRP A   7      10.171  25.277  50.844  1.00 15.67           C  
ATOM     44  CE3 TRP A   7      10.831  25.635  48.529  1.00 15.72           C  
ATOM     45  CZ2 TRP A   7      11.413  25.725  51.321  1.00 16.54           C  
ATOM     46  CZ3 TRP A   7      12.072  26.076  49.008  1.00 15.31           C  
ATOM     47  CH2 TRP A   7      12.349  26.109  50.391  1.00 15.57           C  
ATOM     48  N   GLN A   8       5.934  24.966  45.575  1.00 15.84           N  
ATOM     49  CA  GLN A   8       5.472  24.634  44.236  1.00 16.04           C  
ATOM     50  C   GLN A   8       5.647  25.795  43.266  1.00 15.92           C  
ATOM     51  O   GLN A   8       6.155  25.602  42.151  1.00 15.99           O  
ATOM     52  CB  GLN A   8       3.999  24.260  44.279  1.00 16.21           C  
ATOM     53  CG  GLN A   8       3.531  23.359  43.193  0.40 16.65           C  
ATOM     55  CD  GLN A   8       2.110  22.910  43.440  0.40 16.58           C  
ATOM     57  OE1 GLN A   8       1.314  23.637  44.047  0.40 16.99           O  
ATOM     59  NE2 GLN A   8       1.776  21.720  42.966  0.40 16.94           N  
ATOM     61  N   ASP A   9       5.223  26.993  43.677  1.00 15.25           N  
ATOM     62  CA  ASP A   9       5.373  28.179  42.827  1.00 15.10           C  
ATOM     63  C   ASP A   9       6.832  28.565  42.617  1.00 14.39           C  
ATOM     64  O   ASP A   9       7.233  28.921  41.514  1.00 14.64           O  
ATOM     65  CB  ASP A   9       4.608  29.372  43.409  1.00 15.57           C  
ATOM     66  CG  ASP A   9       3.141  29.373  43.025  1.00 17.91           C  
ATOM     67  OD1 ASP A   9       2.741  28.617  42.111  1.00 18.85           O  
ATOM     68  OD2 ASP A   9       2.378  30.160  43.635  1.00 21.35           O  
ATOM     69  N   TYR A  10       7.616  28.482  43.690  1.00 13.96           N  
ATOM     70  CA  TYR A  10       9.049  28.781  43.675  1.00 13.66           C  
ATOM     71  C   TYR A  10       9.784  27.934  42.635  1.00 13.66           C  
ATOM     72  O   TYR A  10      10.535  28.464  41.811  1.00 13.72           O  
ATOM     73  CB  TYR A  10       9.585  28.482  45.071  1.00 13.55           C  
ATOM     74  CG  TYR A  10      10.970  28.943  45.462  1.00 13.25           C  
ATOM     75  CD1 TYR A  10      11.288  30.306  45.605  1.00 13.88           C  
ATOM     76  CD2 TYR A  10      11.933  27.995  45.837  1.00 14.20           C  
ATOM     77  CE1 TYR A  10      12.560  30.700  46.064  1.00 14.82           C  
ATOM     78  CE2 TYR A  10      13.199  28.370  46.285  1.00 15.14           C  
ATOM     79  CZ  TYR A  10      13.511  29.719  46.401  1.00 13.96           C  
ATOM     80  OH  TYR A  10      14.756  30.075  46.864  1.00 12.96           O  
ATOM     81  N   PHE A  11       9.523  26.628  42.633  1.00 13.14           N  
ATOM     82  CA  PHE A  11      10.269  25.746  41.740  1.00 13.33           C  
ATOM     83  C   PHE A  11       9.722  25.762  40.321  1.00 14.00           C  
ATOM     84  O   PHE A  11      10.495  25.638  39.368  1.00 14.27           O  
ATOM     85  CB  PHE A  11      10.341  24.332  42.293  1.00 13.61           C  
ATOM     86  CG  PHE A  11      11.137  24.224  43.568  1.00 13.81           C  
ATOM     87  CD1 PHE A  11      12.428  24.747  43.647  1.00 13.87           C  
ATOM     88  CD2 PHE A  11      10.586  23.609  44.687  1.00 15.21           C  
ATOM     89  CE1 PHE A  11      13.174  24.650  44.838  1.00 15.00           C  
ATOM     90  CE2 PHE A  11      11.328  23.495  45.882  1.00 14.70           C  
ATOM     91  CZ  PHE A  11      12.617  24.020  45.948  1.00 14.39           C  
ATOM     92  N   MET A  12       8.404  25.939  40.168  1.00 14.00           N  
ATOM     93  CA  MET A  12       7.842  26.080  38.808  1.00 13.63           C  
ATOM     94  C   MET A  12       8.321  27.376  38.147  1.00 13.70           C  
ATOM     95  O   MET A  12       8.645  27.385  36.957  1.00 13.13           O  
ATOM     96  CB  MET A  12       6.313  26.016  38.790  1.00 13.89           C  
ATOM     97  CG  MET A  12       5.732  25.838  37.392  0.50 15.11           C  
ATOM     99  SD  MET A  12       6.499  24.501  36.430  0.50 16.71           S  
ATOM    101  CE  MET A  12       5.660  23.085  37.130  0.50 18.00           C  
ATOM    103  N   ALA A  13       8.363  28.463  38.924  1.00 13.55           N  
ATOM    104  CA  ALA A  13       8.969  29.716  38.455  1.00 13.31           C  
ATOM    105  C   ALA A  13      10.414  29.459  38.016  1.00 13.15           C  
ATOM    106  O   ALA A  13      10.840  29.896  36.932  1.00 13.37           O  
ATOM    107  CB  ALA A  13       8.915  30.795  39.542  1.00 13.71           C  
ATOM    108  N   ASN A  14      11.150  28.707  38.834  1.00 12.50           N  
ATOM    109  CA  ASN A  14      12.542  28.430  38.499  1.00 12.22           C  
ATOM    110  C   ASN A  14      12.653  27.656  37.181  1.00 12.48           C  
ATOM    111  O   ASN A  14      13.456  28.018  36.317  1.00 12.48           O  
ATOM    112  CB  ASN A  14      13.291  27.751  39.662  1.00 11.92           C  
ATOM    113  CG  ASN A  14      14.772  28.091  39.656  1.00 13.34           C  
ATOM    114  OD1 ASN A  14      15.488  27.704  38.739  1.00 13.18           O  
ATOM    115  ND2 ASN A  14      15.238  28.816  40.682  1.00 13.01           N  
ATOM    116  N   ALA A  15      11.807  26.636  37.009  1.00 12.99           N  
ATOM    117  CA  ALA A  15      11.820  25.837  35.774  1.00 13.02           C  
ATOM    118  C   ALA A  15      11.593  26.750  34.564  1.00 13.10           C  
ATOM    119  O   ALA A  15      12.297  26.644  33.552  1.00 13.37           O  
ATOM    120  CB  ALA A  15      10.771  24.730  35.827  1.00 13.20           C  
ATOM    121  N   GLU A  16      10.624  27.655  34.670  1.00 13.80           N  
ATOM    122  CA  GLU A  16      10.393  28.589  33.563  1.00 14.32           C  
ATOM    123  C   GLU A  16      11.588  29.498  33.296  1.00 14.01           C  
ATOM    124  O   GLU A  16      11.955  29.720  32.141  1.00 14.14           O  
ATOM    125  CB  GLU A  16       9.104  29.395  33.744  1.00 14.93           C  
ATOM    126  CG  GLU A  16       8.809  30.166  32.462  0.50 15.06           C  
ATOM    128  CD  GLU A  16       7.403  30.656  32.345  0.50 16.25           C  
ATOM    130  OE1 GLU A  16       6.497  29.820  32.162  0.50 16.65           O  
ATOM    132  OE2 GLU A  16       7.217  31.885  32.405  0.50 16.05           O  
ATOM    134  N   LEU A  17      12.211  30.013  34.351  1.00 13.09           N  
ATOM    135  CA  LEU A  17      13.406  30.829  34.175  1.00 13.22           C  
ATOM    136  C   LEU A  17      14.511  30.003  33.500  1.00 13.22           C  
ATOM    137  O   LEU A  17      15.163  30.454  32.555  1.00 13.15           O  
ATOM    138  CB  LEU A  17      13.874  31.370  35.524  1.00 13.50           C  
ATOM    139  CG  LEU A  17      15.147  32.210  35.463  1.00 13.33           C  
ATOM    140  CD1 LEU A  17      14.971  33.418  34.523  1.00 15.91           C  
ATOM    141  CD2 LEU A  17      15.542  32.633  36.863  1.00 13.61           C  
ATOM    142  N   ILE A  18      14.670  28.764  33.952  1.00 13.09           N  
ATOM    143  CA  ILE A  18      15.688  27.867  33.395  1.00 12.58           C  
ATOM    144  C   ILE A  18      15.474  27.647  31.889  1.00 12.99           C  
ATOM    145  O   ILE A  18      16.441  27.533  31.130  1.00 12.21           O  
ATOM    146  CB  ILE A  18      15.715  26.533  34.193  1.00 12.83           C  
ATOM    147  CG1 ILE A  18      16.290  26.768  35.597  1.00 12.54           C  
ATOM    148  CG2 ILE A  18      16.464  25.414  33.436  1.00 12.75           C  
ATOM    149  CD1 ILE A  18      17.789  27.091  35.650  1.00 13.00           C  
ATOM    150  N   SER A  19      14.206  27.617  31.470  1.00 13.28           N  
ATOM    151  CA  SER A  19      13.848  27.423  30.056  1.00 14.60           C  
ATOM    152  C   SER A  19      14.278  28.591  29.151  1.00 14.93           C  
ATOM    153  O   SER A  19      14.262  28.459  27.917  1.00 15.37           O  
ATOM    154  CB  SER A  19      12.339  27.210  29.908  1.00 14.58           C  
ATOM    155  OG  SER A  19      11.661  28.454  29.862  1.00 14.28           O  
ATOM    156  N   LYS A  20      14.639  29.729  29.747  1.00 15.62           N  
ATOM    157  CA  LYS A  20      14.953  30.940  28.952  1.00 16.71           C  
ATOM    158  C   LYS A  20      16.200  30.827  28.070  1.00 17.03           C  
ATOM    159  O   LYS A  20      16.388  31.635  27.152  1.00 19.16           O  
ATOM    160  CB  LYS A  20      15.039  32.185  29.838  1.00 16.82           C  
ATOM    161  CG  LYS A  20      13.726  32.554  30.505  1.00 19.03           C  
ATOM    162  CD  LYS A  20      12.683  33.001  29.508  1.00 22.94           C  
ATOM    163  CE  LYS A  20      11.374  33.294  30.229  1.00 25.84           C  
ATOM    164  NZ  LYS A  20      10.344  33.835  29.306  1.00 28.82           N  
ATOM    165  N   ARG A  21      17.034  29.818  28.317  1.00 16.00           N  
ATOM    166  CA  ARG A  21      18.181  29.583  27.449  1.00 15.42           C  
ATOM    167  C   ARG A  21      17.957  28.467  26.419  1.00 15.00           C  
ATOM    168  O   ARG A  21      18.874  28.120  25.690  1.00 15.33           O  
ATOM    169  CB  ARG A  21      19.459  29.357  28.269  1.00 15.47           C  
ATOM    170  CG  ARG A  21      20.136  30.672  28.660  1.00 15.19           C  
ATOM    171  CD  ARG A  21      21.477  30.453  29.365  1.00 15.31           C  
ATOM    172  NE  ARG A  21      22.484  29.826  28.505  1.00 15.36           N  
ATOM    173  CZ  ARG A  21      23.229  30.472  27.609  1.00 15.91           C  
ATOM    174  NH1 ARG A  21      23.101  31.788  27.431  1.00 16.37           N  
ATOM    175  NH2 ARG A  21      24.119  29.793  26.881  1.00 15.67           N  
ATOM    176  N   SER A  22      16.737  27.931  26.341  1.00 14.87           N  
ATOM    177  CA  SER A  22      16.419  26.891  25.353  1.00 14.67           C  
ATOM    178  C   SER A  22      16.781  27.358  23.944  1.00 14.91           C  
ATOM    179  O   SER A  22      16.521  28.510  23.591  1.00 14.87           O  
ATOM    180  CB  SER A  22      14.932  26.544  25.390  1.00 14.55           C  
ATOM    181  OG  SER A  22      14.561  25.785  24.247  1.00 15.89           O  
ATOM    182  N   THR A  23      17.342  26.450  23.151  1.00 14.74           N  
ATOM    183  CA  THR A  23      17.787  26.776  21.790  1.00 16.23           C  
ATOM    184  C   THR A  23      17.041  25.947  20.734  1.00 16.32           C  
ATOM    185  O   THR A  23      17.544  25.729  19.630  1.00 17.31           O  
ATOM    186  CB  THR A  23      19.323  26.601  21.611  1.00 16.11           C  
ATOM    187  OG1 THR A  23      19.686  25.234  21.842  1.00 15.57           O  
ATOM    188  CG2 THR A  23      20.102  27.530  22.543  1.00 16.25           C  
ATOM    189  N   CYS A  24      15.836  25.498  21.081  1.00 16.53           N  
ATOM    190  CA  CYS A  24      14.970  24.808  20.128  1.00 16.50           C  
ATOM    191  C   CYS A  24      13.554  25.367  20.249  1.00 17.50           C  
ATOM    192  O   CYS A  24      12.847  25.081  21.215  1.00 17.52           O  
ATOM    193  CB  CYS A  24      14.999  23.287  20.365  1.00 16.47           C  
ATOM    194  SG  CYS A  24      13.733  22.379  19.412  1.00 16.53           S  
ATOM    195  N   ASN A  25      13.141  26.160  19.259  1.00 18.30           N  
ATOM    196  CA  ASN A  25      11.900  26.932  19.367  1.00 18.90           C  
ATOM    197  C   ASN A  25      10.593  26.132  19.264  1.00 18.63           C  
ATOM    198  O   ASN A  25       9.500  26.705  19.362  1.00 19.09           O  
ATOM    199  CB  ASN A  25      11.904  28.103  18.371  1.00 19.60           C  
ATOM    200  CG  ASN A  25      11.915  27.642  16.924  1.00 20.67           C  
ATOM    201  OD1 ASN A  25      11.553  26.508  16.609  1.00 21.95           O  
ATOM    202  ND2 ASN A  25      12.320  28.541  16.027  1.00 24.19           N  
ATOM    203  N   ARG A  26      10.699  24.820  19.069  1.00 18.56           N  
ATOM    204  CA  ARG A  26       9.523  23.952  19.099  1.00 18.44           C  
ATOM    205  C   ARG A  26       8.885  23.942  20.493  1.00 18.35           C  
ATOM    206  O   ARG A  26       7.667  23.804  20.621  1.00 18.84           O  
ATOM    207  CB  ARG A  26       9.862  22.537  18.625  1.00 18.06           C  
ATOM    208  CG  ARG A  26      10.044  22.432  17.101  1.00 18.25           C  
ATOM    209  CD  ARG A  26      10.429  21.019  16.651  1.00 18.51           C  
ATOM    210  NE  ARG A  26       9.487  20.004  17.121  1.00 20.53           N  
ATOM    211  CZ  ARG A  26       8.289  19.785  16.578  1.00 19.64           C  
ATOM    212  NH1 ARG A  26       7.879  20.509  15.539  1.00 21.15           N  
ATOM    213  NH2 ARG A  26       7.492  18.853  17.076  1.00 19.56           N  
ATOM    214  N   ALA A  27       9.713  24.111  21.529  1.00 17.60           N  
ATOM    215  CA  ALA A  27       9.234  24.209  22.911  1.00 17.53           C  
ATOM    216  C   ALA A  27      10.416  24.646  23.758  1.00 17.28           C  
ATOM    217  O   ALA A  27      11.470  23.998  23.719  1.00 16.95           O  
ATOM    218  CB  ALA A  27       8.701  22.852  23.412  1.00 17.42           C  
ATOM    219  N   TYR A  28      10.257  25.752  24.485  1.00 17.14           N  
ATOM    220  CA  TYR A  28      11.307  26.210  25.394  1.00 17.19           C  
ATOM    221  C   TYR A  28      11.132  25.484  26.721  1.00 15.98           C  
ATOM    222  O   TYR A  28      10.274  25.840  27.523  1.00 15.58           O  
ATOM    223  CB  TYR A  28      11.258  27.719  25.614  1.00 18.83           C  
ATOM    224  CG  TYR A  28      11.332  28.545  24.349  1.00 20.96           C  
ATOM    225  CD1 TYR A  28      12.290  28.282  23.372  1.00 21.35           C  
ATOM    226  CD2 TYR A  28      10.464  29.622  24.159  1.00 23.91           C  
ATOM    227  CE1 TYR A  28      12.368  29.075  22.215  1.00 22.94           C  
ATOM    228  CE2 TYR A  28      10.528  30.407  23.012  1.00 24.48           C  
ATOM    229  CZ  TYR A  28      11.478  30.127  22.049  1.00 23.21           C  
ATOM    230  OH  TYR A  28      11.523  30.911  20.913  1.00 24.89           O  
ATOM    231  N   VAL A  29      11.945  24.454  26.935  1.00 15.06           N  
ATOM    232  CA  VAL A  29      11.757  23.586  28.091  1.00 14.06           C  
ATOM    233  C   VAL A  29      12.836  23.810  29.144  1.00 13.95           C  
ATOM    234  O   VAL A  29      14.033  23.922  28.825  1.00 13.76           O  
ATOM    235  CB  VAL A  29      11.721  22.087  27.709  1.00 13.41           C  
ATOM    236  CG1 VAL A  29      11.149  21.266  28.843  1.00 12.77           C  
ATOM    237  CG2 VAL A  29      10.857  21.847  26.436  1.00 14.44           C  
ATOM    238  N   GLY A  30      12.388  23.867  30.397  1.00 13.36           N  
ATOM    239  CA  GLY A  30      13.284  24.017  31.548  1.00 13.21           C  
ATOM    240  C   GLY A  30      12.896  23.013  32.623  1.00 12.96           C  
ATOM    241  O   GLY A  30      11.712  22.732  32.824  1.00 13.20           O  
ATOM    242  N   ALA A  31      13.899  22.474  33.319  1.00 12.53           N  
ATOM    243  CA  ALA A  31      13.685  21.468  34.357  1.00 12.16           C  
ATOM    244  C   ALA A  31      14.567  21.776  35.564  1.00 12.12           C  
ATOM    245  O   ALA A  31      15.722  22.183  35.417  1.00 11.87           O  
ATOM    246  CB  ALA A  31      13.996  20.066  33.830  1.00 12.98           C  
ATOM    247  N   VAL A  32      13.999  21.575  36.748  1.00 11.55           N  
ATOM    248  CA  VAL A  32      14.703  21.769  38.007  1.00 12.11           C  
ATOM    249  C   VAL A  32      14.514  20.511  38.848  1.00 12.25           C  
ATOM    250  O   VAL A  32      13.385  20.094  39.114  1.00 12.19           O  
ATOM    251  CB  VAL A  32      14.213  23.061  38.750  1.00 12.39           C  
ATOM    252  CG1 VAL A  32      14.821  23.178  40.130  0.50 11.49           C  
ATOM    254  CG2 VAL A  32      14.503  24.325  37.902  0.50 11.87           C  
ATOM    255  N   LEU A  33      15.629  19.896  39.233  1.00 12.04           N  
ATOM    256  CA  LEU A  33      15.597  18.682  40.041  1.00 12.74           C  
ATOM    257  C   LEU A  33      15.774  19.056  41.511  1.00 12.72           C  
ATOM    258  O   LEU A  33      16.700  19.781  41.854  1.00 11.67           O  
ATOM    259  CB  LEU A  33      16.683  17.722  39.553  1.00 12.64           C  
ATOM    260  CG  LEU A  33      16.621  16.282  40.054  1.00 13.76           C  
ATOM    261  CD1 LEU A  33      15.380  15.507  39.547  1.00 14.18           C  
ATOM    262  CD2 LEU A  33      17.911  15.545  39.695  1.00 14.51           C  
ATOM    263  N   VAL A  34      14.862  18.565  42.358  1.00 12.70           N  
ATOM    264  CA  VAL A  34      14.770  18.982  43.756  1.00 13.08           C  
ATOM    265  C   VAL A  34      14.839  17.784  44.711  1.00 13.30           C  
ATOM    266  O   VAL A  34      14.202  16.744  44.475  1.00 12.20           O  
ATOM    267  CB  VAL A  34      13.454  19.770  43.978  1.00 13.29           C  
ATOM    268  CG1 VAL A  34      13.220  20.088  45.452  1.00 14.01           C  
ATOM    269  CG2 VAL A  34      13.463  21.055  43.134  1.00 13.70           C  
ATOM    270  N   LYS A  35      15.621  17.933  45.779  1.00 13.33           N  
ATOM    271  CA  LYS A  35      15.690  16.926  46.838  1.00 15.17           C  
ATOM    272  C   LYS A  35      15.477  17.655  48.165  1.00 14.78           C  
ATOM    273  O   LYS A  35      16.217  18.602  48.493  1.00 13.50           O  
ATOM    274  CB  LYS A  35      17.042  16.196  46.813  1.00 14.89           C  
ATOM    275  CG  LYS A  35      17.083  14.940  47.715  1.00 17.75           C  
ATOM    276  CD  LYS A  35      18.456  14.219  47.690  1.00 19.27           C  
ATOM    277  CE  LYS A  35      18.630  13.309  46.458  0.50 20.78           C  
ATOM    278  NZ  LYS A  35      19.564  12.112  46.623  1.00 22.54           N  
ATOM    279  N   ASN A  36      14.436  17.256  48.900  1.00 14.93           N  
ATOM    280  CA  ASN A  36      14.120  17.910  50.178  1.00 15.82           C  
ATOM    281  C   ASN A  36      14.080  19.447  50.054  1.00 14.63           C  
ATOM    282  O   ASN A  36      14.658  20.182  50.876  1.00 14.91           O  
ATOM    283  CB  ASN A  36      15.133  17.451  51.242  1.00 16.25           C  
ATOM    284  CG  ASN A  36      15.113  15.937  51.456  0.50 16.90           C  
ATOM    286  OD1 ASN A  36      14.136  15.259  51.127  0.50 18.43           O  
ATOM    288  ND2 ASN A  36      16.199  15.406  51.993  0.50 18.82           N  
ATOM    290  N   ASN A  37      13.403  19.916  49.006  1.00 14.19           N  
ATOM    291  CA  ASN A  37      13.230  21.345  48.728  1.00 13.96           C  
ATOM    292  C   ASN A  37      14.534  22.111  48.488  1.00 12.96           C  
ATOM    293  O   ASN A  37      14.567  23.332  48.619  1.00 13.63           O  
ATOM    294  CB  ASN A  37      12.358  22.016  49.798  1.00 14.31           C  
ATOM    295  CG  ASN A  37      10.892  21.645  49.654  1.00 16.24           C  
ATOM    296  OD1 ASN A  37      10.419  21.301  48.557  1.00 17.42           O  
ATOM    297  ND2 ASN A  37      10.154  21.722  50.762  1.00 17.07           N  
ATOM    298  N   ARG A  38      15.587  21.376  48.119  1.00 12.38           N  
ATOM    299  CA  ARG A  38      16.837  21.987  47.629  1.00 12.27           C  
ATOM    300  C   ARG A  38      17.040  21.708  46.142  1.00 12.35           C  
ATOM    301  O   ARG A  38      16.780  20.594  45.673  1.00 12.48           O  
ATOM    302  CB  ARG A  38      18.062  21.448  48.392  1.00 12.68           C  
ATOM    303  CG  ARG A  38      17.970  21.471  49.919  1.00 12.42           C  
ATOM    304  CD  ARG A  38      17.557  22.841  50.468  1.00 12.73           C  
ATOM    305  NE  ARG A  38      18.472  23.951  50.142  1.00 13.17           N  
ATOM    306  CZ  ARG A  38      19.441  24.406  50.942  1.00 14.79           C  
ATOM    307  NH1 ARG A  38      19.681  23.823  52.112  1.00 15.83           N  
ATOM    308  NH2 ARG A  38      20.178  25.448  50.565  1.00 12.61           N  
ATOM    309  N   ILE A  39      17.511  22.707  45.399  1.00 11.53           N  
ATOM    310  CA  ILE A  39      17.807  22.493  43.976  1.00 12.27           C  
ATOM    311  C   ILE A  39      19.169  21.805  43.828  1.00 12.35           C  
ATOM    312  O   ILE A  39      20.180  22.303  44.336  1.00 12.60           O  
ATOM    313  CB  ILE A  39      17.800  23.828  43.179  1.00 12.04           C  
ATOM    314  CG1 ILE A  39      16.389  24.439  43.200  1.00 13.19           C  
ATOM    315  CG2 ILE A  39      18.298  23.597  41.756  1.00 11.52           C  
ATOM    316  CD1 ILE A  39      16.322  25.889  42.691  1.00 13.51           C  
ATOM    317  N   ILE A  40      19.196  20.667  43.133  1.00 11.97           N  
ATOM    318  CA  ILE A  40      20.463  19.927  42.966  1.00 12.30           C  
ATOM    319  C   ILE A  40      20.963  19.877  41.528  1.00 12.02           C  
ATOM    320  O   ILE A  40      22.138  19.562  41.274  1.00 12.24           O  
ATOM    321  CB  ILE A  40      20.396  18.486  43.528  1.00 12.19           C  
ATOM    322  CG1 ILE A  40      19.467  17.589  42.689  1.00 11.84           C  
ATOM    323  CG2 ILE A  40      20.025  18.501  45.036  1.00 13.73           C  
ATOM    324  CD1 ILE A  40      19.584  16.066  43.039  1.00 12.81           C  
ATOM    325  N   ALA A  41      20.063  20.174  40.593  1.00 11.91           N  
ATOM    326  CA  ALA A  41      20.408  20.176  39.164  1.00 11.44           C  
ATOM    327  C   ALA A  41      19.334  20.886  38.362  1.00 11.69           C  
ATOM    328  O   ALA A  41      18.188  20.990  38.806  1.00 11.41           O  
ATOM    329  CB  ALA A  41      20.585  18.750  38.640  1.00 11.79           C  
ATOM    330  N   THR A  42      19.717  21.383  37.190  1.00 11.64           N  
ATOM    331  CA  THR A  42      18.755  22.025  36.277  1.00 11.99           C  
ATOM    332  C   THR A  42      19.118  21.646  34.852  1.00 12.50           C  
ATOM    333  O   THR A  42      20.216  21.148  34.599  1.00 12.28           O  
ATOM    334  CB  THR A  42      18.761  23.582  36.379  1.00 12.11           C  
ATOM    335  OG1 THR A  42      19.971  24.126  35.814  1.00 12.19           O  
ATOM    336  CG2 THR A  42      18.615  24.064  37.827  1.00 10.19           C  
ATOM    337  N   GLY A  43      18.213  21.932  33.920  1.00 12.39           N  
ATOM    338  CA  GLY A  43      18.487  21.694  32.508  1.00 12.25           C  
ATOM    339  C   GLY A  43      17.499  22.393  31.598  1.00 12.75           C  
ATOM    340  O   GLY A  43      16.355  22.633  31.978  1.00 12.01           O  
ATOM    341  N   TYR A  44      17.980  22.770  30.414  1.00 12.37           N  
ATOM    342  CA  TYR A  44      17.098  23.220  29.339  1.00 12.87           C  
ATOM    343  C   TYR A  44      17.367  22.400  28.086  1.00 13.37           C  
ATOM    344  O   TYR A  44      18.368  21.698  28.012  1.00 13.26           O  
ATOM    345  CB  TYR A  44      17.280  24.717  29.053  1.00 13.23           C  
ATOM    346  CG  TYR A  44      18.676  25.174  28.666  1.00 13.18           C  
ATOM    347  CD1 TYR A  44      19.094  25.174  27.314  1.00 13.27           C  
ATOM    348  CD2 TYR A  44      19.551  25.707  29.625  1.00 13.58           C  
ATOM    349  CE1 TYR A  44      20.361  25.636  26.947  1.00 13.12           C  
ATOM    350  CE2 TYR A  44      20.823  26.176  29.261  1.00 15.40           C  
ATOM    351  CZ  TYR A  44      21.216  26.145  27.919  1.00 14.05           C  
ATOM    352  OH  TYR A  44      22.465  26.618  27.565  1.00 14.52           O  
ATOM    353  N   ASN A  45      16.461  22.466  27.107  1.00 13.31           N  
ATOM    354  CA  ASN A  45      16.662  21.704  25.882  1.00 13.37           C  
ATOM    355  C   ASN A  45      17.570  22.443  24.920  1.00 13.37           C  
ATOM    356  O   ASN A  45      17.375  23.634  24.646  1.00 13.83           O  
ATOM    357  CB  ASN A  45      15.334  21.279  25.207  1.00 13.01           C  
ATOM    358  CG  ASN A  45      14.408  22.467  24.857  1.00 13.93           C  
ATOM    359  OD1 ASN A  45      14.285  23.436  25.609  1.00 14.28           O  
ATOM    360  ND2 ASN A  45      13.720  22.360  23.712  1.00 13.67           N  
ATOM    361  N   GLY A  46      18.569  21.726  24.423  1.00 13.83           N  
ATOM    362  CA  GLY A  46      19.546  22.296  23.489  1.00 13.59           C  
ATOM    363  C   GLY A  46      20.371  21.162  22.914  1.00 13.55           C  
ATOM    364  O   GLY A  46      20.282  20.029  23.380  1.00 13.65           O  
ATOM    365  N   GLY A  47      21.200  21.467  21.918  1.00 13.34           N  
ATOM    366  CA  GLY A  47      22.047  20.438  21.322  1.00 13.50           C  
ATOM    367  C   GLY A  47      23.039  19.881  22.335  1.00 13.20           C  
ATOM    368  O   GLY A  47      23.241  20.453  23.419  1.00 13.30           O  
ATOM    369  N   VAL A  48      23.647  18.752  21.992  1.00 13.40           N  
ATOM    370  CA  VAL A  48      24.764  18.241  22.778  1.00 13.48           C  
ATOM    371  C   VAL A  48      25.787  19.383  22.957  1.00 13.85           C  
ATOM    372  O   VAL A  48      26.029  20.171  22.023  1.00 14.12           O  
ATOM    373  CB  VAL A  48      25.413  17.001  22.101  1.00 13.66           C  
ATOM    374  CG1 VAL A  48      26.706  16.613  22.805  1.00 13.34           C  
ATOM    375  CG2 VAL A  48      24.430  15.827  22.082  1.00 14.24           C  
ATOM    376  N   ALA A  49      26.358  19.499  24.154  1.00 13.89           N  
ATOM    377  CA  ALA A  49      27.322  20.573  24.428  1.00 14.59           C  
ATOM    378  C   ALA A  49      28.413  20.602  23.351  1.00 15.10           C  
ATOM    379  O   ALA A  49      28.925  19.550  22.957  1.00 15.16           O  
ATOM    380  CB  ALA A  49      27.951  20.393  25.810  1.00 14.43           C  
ATOM    381  N   ASP A  50      28.747  21.805  22.888  1.00 16.09           N  
ATOM    382  CA  ASP A  50      29.821  22.016  21.896  1.00 17.31           C  
ATOM    383  C   ASP A  50      29.417  21.556  20.490  1.00 18.01           C  
ATOM    384  O   ASP A  50      30.283  21.423  19.616  1.00 19.33           O  
ATOM    385  CB  ASP A  50      31.129  21.298  22.290  1.00 18.01           C  
ATOM    386  CG  ASP A  50      31.544  21.538  23.731  0.50 19.37           C  
ATOM    387  OD1 ASP A  50      31.974  22.665  24.038  0.50 20.48           O  
ATOM    388  OD2 ASP A  50      31.475  20.584  24.548  0.50 21.82           O  
ATOM    389  N   THR A  51      28.133  21.276  20.283  1.00 17.94           N  
ATOM    390  CA  THR A  51      27.610  20.955  18.944  1.00 18.51           C  
ATOM    391  C   THR A  51      26.553  22.001  18.536  1.00 19.11           C  
ATOM    392  O   THR A  51      26.234  22.910  19.304  1.00 20.46           O  
ATOM    393  CB  THR A  51      27.021  19.527  18.855  1.00 18.69           C  
ATOM    394  OG1 THR A  51      25.722  19.495  19.463  1.00 16.83           O  
ATOM    395  CG2 THR A  51      27.937  18.493  19.515  1.00 18.65           C  
ATOM    396  N   ASP A  52      25.999  21.866  17.337  1.00 19.36           N  
ATOM    397  CA  ASP A  52      25.095  22.883  16.796  1.00 19.08           C  
ATOM    398  C   ASP A  52      23.733  22.909  17.509  1.00 17.96           C  
ATOM    399  O   ASP A  52      23.231  21.871  17.951  1.00 17.81           O  
ATOM    400  CB  ASP A  52      24.884  22.645  15.301  1.00 19.44           C  
ATOM    401  CG  ASP A  52      26.150  22.869  14.470  1.00 22.04           C  
ATOM    402  OD1 ASP A  52      27.017  23.685  14.849  0.80 23.51           O  
ATOM    403  OD2 ASP A  52      26.240  22.238  13.395  0.50 23.75           O  
ATOM    404  N   ASN A  53      23.160  24.101  17.632  1.00 17.69           N  
ATOM    405  CA  ASN A  53      21.811  24.265  18.174  1.00 17.34           C  
ATOM    406  C   ASN A  53      20.783  24.580  17.088  1.00 17.62           C  
ATOM    407  O   ASN A  53      21.129  25.166  16.059  1.00 17.76           O  
ATOM    408  CB  ASN A  53      21.798  25.360  19.239  1.00 17.64           C  
ATOM    409  CG  ASN A  53      22.655  25.009  20.442  1.00 16.84           C  
ATOM    410  OD1 ASN A  53      22.654  23.866  20.896  1.00 16.93           O  
ATOM    411  ND2 ASN A  53      23.395  25.989  20.957  1.00 17.65           N  
ATOM    412  N   CYS A  54      19.518  24.220  17.331  1.00 17.28           N  
ATOM    413  CA  CYS A  54      18.460  24.449  16.335  1.00 17.75           C  
ATOM    414  C   CYS A  54      18.347  25.920  15.919  1.00 18.55           C  
ATOM    415  O   CYS A  54      18.092  26.221  14.746  1.00 18.88           O  
ATOM    416  CB  CYS A  54      17.112  23.934  16.845  1.00 17.42           C  
ATOM    417  SG  CYS A  54      17.212  22.227  17.438  1.00 18.15           S  
ATOM    418  N   ASP A  55      18.545  26.826  16.876  1.00 18.88           N  
ATOM    419  CA  ASP A  55      18.517  28.274  16.618  1.00 20.12           C  
ATOM    420  C   ASP A  55      19.418  28.646  15.443  1.00 20.55           C  
ATOM    421  O   ASP A  55      19.093  29.551  14.657  1.00 21.82           O  
ATOM    422  CB  ASP A  55      18.986  29.056  17.852  1.00 20.38           C  
ATOM    423  CG  ASP A  55      17.930  29.138  18.952  1.00 21.33           C  
ATOM    424  OD1 ASP A  55      16.764  28.744  18.728  1.00 20.97           O  
ATOM    425  OD2 ASP A  55      18.279  29.622  20.054  1.00 22.23           O  
ATOM    426  N   ASP A  56      20.538  27.940  15.322  1.00 20.58           N  
ATOM    427  CA  ASP A  56      21.559  28.270  14.325  1.00 21.26           C  
ATOM    428  C   ASP A  56      21.503  27.441  13.047  1.00 21.45           C  
ATOM    429  O   ASP A  56      21.786  27.954  11.959  1.00 21.99           O  
ATOM    430  CB  ASP A  56      22.948  28.180  14.952  1.00 21.76           C  
ATOM    431  CG  ASP A  56      23.113  29.130  16.121  1.00 23.40           C  
ATOM    432  OD1 ASP A  56      22.677  30.302  16.008  1.00 24.73           O  
ATOM    433  OD2 ASP A  56      23.664  28.700  17.158  1.00 24.85           O  
ATOM    434  N   VAL A  57      21.158  26.163  13.166  1.00 20.80           N  
ATOM    435  CA  VAL A  57      21.213  25.271  12.002  1.00 20.52           C  
ATOM    436  C   VAL A  57      19.875  24.618  11.644  1.00 20.37           C  
ATOM    437  O   VAL A  57      19.803  23.838  10.687  1.00 20.93           O  
ATOM    438  CB  VAL A  57      22.301  24.175  12.174  1.00 20.10           C  
ATOM    439  CG1 VAL A  57      23.690  24.798  12.342  1.00 21.18           C  
ATOM    440  CG2 VAL A  57      21.966  23.255  13.363  1.00 19.67           C  
ATOM    441  N   GLY A  58      18.824  24.942  12.398  1.00 19.47           N  
ATOM    442  CA  GLY A  58      17.518  24.329  12.204  1.00 19.44           C  
ATOM    443  C   GLY A  58      17.341  23.048  13.005  1.00 19.07           C  
ATOM    444  O   GLY A  58      18.315  22.465  13.518  1.00 19.01           O  
ATOM    445  N   HIS A  59      16.092  22.608  13.102  1.00 18.77           N  
ATOM    446  CA  HIS A  59      15.762  21.368  13.780  1.00 18.75           C  
ATOM    447  C   HIS A  59      16.257  20.169  12.986  1.00 19.08           C  
ATOM    448  O   HIS A  59      16.479  20.261  11.767  1.00 20.00           O  
ATOM    449  CB  HIS A  59      14.249  21.285  14.006  1.00 18.28           C  
ATOM    450  CG  HIS A  59      13.688  22.500  14.673  1.00 19.72           C  
ATOM    451  ND1 HIS A  59      13.973  22.821  15.983  1.00 17.46           N  
ATOM    452  CD2 HIS A  59      12.887  23.488  14.207  1.00 19.01           C  
ATOM    453  CE1 HIS A  59      13.364  23.950  16.300  1.00 18.80           C  
ATOM    454  NE2 HIS A  59      12.696  24.375  15.239  1.00 19.59           N  
ATOM    455  N   GLU A  60      16.462  19.050  13.677  1.00 18.78           N  
ATOM    456  CA  GLU A  60      16.701  17.782  13.012  1.00 18.83           C  
ATOM    457  C   GLU A  60      15.457  16.934  13.233  1.00 19.01           C  
ATOM    458  O   GLU A  60      15.305  16.315  14.281  1.00 18.51           O  
ATOM    459  CB  GLU A  60      17.956  17.091  13.564  1.00 18.45           C  
ATOM    460  CG  GLU A  60      18.280  15.757  12.884  1.00 20.10           C  
ATOM    461  CD  GLU A  60      18.733  15.910  11.432  0.60 20.97           C  
ATOM    462  OE1 GLU A  60      19.334  16.945  11.099  0.80 23.10           O  
ATOM    463  OE2 GLU A  60      18.497  14.987  10.626  0.60 21.75           O  
ATOM    464  N   MET A  61      14.548  16.934  12.256  1.00 19.32           N  
ATOM    465  CA  MET A  61      13.238  16.292  12.432  1.00 20.17           C  
ATOM    466  C   MET A  61      13.253  14.807  12.096  1.00 20.43           C  
ATOM    467  O   MET A  61      13.811  14.390  11.069  1.00 21.06           O  
ATOM    468  CB  MET A  61      12.147  17.004  11.611  1.00 20.45           C  
ATOM    469  CG  MET A  61      11.888  18.451  12.012  1.00 20.85           C  
ATOM    470  SD  MET A  61      11.516  18.664  13.779  1.00 22.22           S  
ATOM    471  CE  MET A  61       9.934  17.844  13.919  1.00 22.23           C  
ATOM    472  N   GLU A  62      12.647  14.008  12.965  1.00 20.31           N  
ATOM    473  CA  GLU A  62      12.471  12.585  12.695  1.00 20.45           C  
ATOM    474  C   GLU A  62      11.166  12.106  13.311  1.00 20.24           C  
ATOM    475  O   GLU A  62      10.955  12.229  14.513  1.00 20.01           O  
ATOM    476  CB  GLU A  62      13.658  11.781  13.225  1.00 20.32           C  
ATOM    477  CG  GLU A  62      13.520  10.278  13.108  1.00 21.22           C  
ATOM    478  CD  GLU A  62      14.857   9.583  13.305  1.00 22.39           C  
ATOM    479  OE1 GLU A  62      15.121   9.115  14.426  0.50 22.10           O  
ATOM    480  OE2 GLU A  62      15.637   9.534  12.336  0.50 22.33           O  
ATOM    481  N   ASP A  63      10.283  11.573  12.469  1.00 20.48           N  
ATOM    482  CA  ASP A  63       8.963  11.130  12.919  1.00 20.50           C  
ATOM    483  C   ASP A  63       8.194  12.188  13.756  1.00 20.18           C  
ATOM    484  O   ASP A  63       7.525  11.856  14.751  1.00 20.54           O  
ATOM    485  CB  ASP A  63       9.054   9.797  13.671  1.00 20.89           C  
ATOM    486  CG  ASP A  63       9.676   8.676  12.834  0.60 20.96           C  
ATOM    488  OD1 ASP A  63       9.333   8.547  11.640  0.60 21.66           O  
ATOM    490  OD2 ASP A  63      10.503   7.914  13.378  0.60 21.95           O  
ATOM    492  N   GLY A  64       8.294  13.449  13.348  1.00 19.54           N  
ATOM    493  CA  GLY A  64       7.508  14.524  13.952  1.00 19.47           C  
ATOM    494  C   GLY A  64       8.069  15.077  15.252  1.00 18.98           C  
ATOM    495  O   GLY A  64       7.392  15.838  15.942  1.00 19.05           O  
ATOM    496  N   HIS A  65       9.308  14.695  15.566  1.00 18.45           N  
ATOM    497  CA  HIS A  65      10.025  15.186  16.751  1.00 18.01           C  
ATOM    498  C   HIS A  65      11.380  15.760  16.348  1.00 17.44           C  
ATOM    499  O   HIS A  65      12.027  15.233  15.436  1.00 17.64           O  
ATOM    500  CB  HIS A  65      10.274  14.038  17.726  1.00 17.81           C  
ATOM    501  CG  HIS A  65       9.031  13.495  18.354  1.00 18.75           C  
ATOM    502  ND1 HIS A  65       8.392  14.126  19.402  1.00 18.68           N  
ATOM    503  CD2 HIS A  65       8.306  12.383  18.082  1.00 19.84           C  
ATOM    504  CE1 HIS A  65       7.322  13.429  19.743  1.00 20.49           C  
ATOM    505  NE2 HIS A  65       7.250  12.365  18.962  1.00 21.00           N  
ATOM    506  N   CYS A  66      11.816  16.822  17.027  1.00 17.05           N  
ATOM    507  CA  CYS A  66      13.178  17.307  16.828  1.00 16.34           C  
ATOM    508  C   CYS A  66      14.142  16.463  17.646  1.00 16.49           C  
ATOM    509  O   CYS A  66      14.082  16.470  18.880  1.00 16.21           O  
ATOM    510  CB  CYS A  66      13.334  18.789  17.184  1.00 16.59           C  
ATOM    511  SG  CYS A  66      15.039  19.330  17.003  1.00 16.59           S  
ATOM    512  N   ILE A  67      15.019  15.736  16.962  1.00 15.93           N  
ATOM    513  CA  ILE A  67      15.970  14.849  17.649  1.00 16.00           C  
ATOM    514  C   ILE A  67      17.335  15.502  17.938  1.00 15.57           C  
ATOM    515  O   ILE A  67      18.252  14.843  18.448  1.00 15.82           O  
ATOM    516  CB  ILE A  67      16.157  13.481  16.920  1.00 16.18           C  
ATOM    517  CG1 ILE A  67      16.804  13.672  15.538  1.00 17.06           C  
ATOM    518  CG2 ILE A  67      14.820  12.712  16.872  1.00 17.09           C  
ATOM    519  CD1 ILE A  67      17.257  12.360  14.878  1.00 16.82           C  
ATOM    520  N   ARG A  68      17.470  16.787  17.615  1.00 15.27           N  
ATOM    521  CA  ARG A  68      18.757  17.458  17.824  1.00 15.42           C  
ATOM    522  C   ARG A  68      19.090  17.597  19.303  1.00 14.71           C  
ATOM    523  O   ARG A  68      20.249  17.488  19.704  1.00 15.27           O  
ATOM    524  CB  ARG A  68      18.807  18.838  17.155  1.00 15.24           C  
ATOM    525  CG  ARG A  68      20.189  19.482  17.294  1.00 16.03           C  
ATOM    526  CD  ARG A  68      20.372  20.786  16.535  1.00 16.49           C  
ATOM    527  NE  ARG A  68      19.980  20.698  15.118  1.00 18.22           N  
ATOM    528  CZ  ARG A  68      20.713  20.139  14.158  1.00 18.44           C  
ATOM    529  NH1 ARG A  68      21.892  19.571  14.425  1.00 17.48           N  
ATOM    530  NH2 ARG A  68      20.251  20.141  12.904  1.00 19.73           N  
ATOM    531  N   THR A  69      18.065  17.836  20.114  1.00 14.12           N  
ATOM    532  CA  THR A  69      18.301  18.297  21.476  1.00 13.40           C  
ATOM    533  C   THR A  69      18.437  17.186  22.512  1.00 13.96           C  
ATOM    534  O   THR A  69      17.781  16.147  22.430  1.00 13.82           O  
ATOM    535  CB  THR A  69      17.150  19.196  21.933  1.00 13.49           C  
ATOM    536  OG1 THR A  69      15.916  18.483  21.767  1.00 13.45           O  
ATOM    537  CG2 THR A  69      17.123  20.494  21.105  1.00 13.27           C  
ATOM    538  N   VAL A  70      19.301  17.433  23.494  1.00 12.98           N  
ATOM    539  CA  VAL A  70      19.192  16.770  24.791  1.00 12.73           C  
ATOM    540  C   VAL A  70      18.064  17.503  25.522  1.00 12.32           C  
ATOM    541  O   VAL A  70      18.079  18.724  25.619  1.00 12.12           O  
ATOM    542  CB  VAL A  70      20.506  16.862  25.582  1.00 13.31           C  
ATOM    543  CG1 VAL A  70      20.355  16.187  26.958  1.00 13.45           C  
ATOM    544  CG2 VAL A  70      21.641  16.210  24.796  1.00 12.65           C  
ATOM    545  N   HIS A  71      17.071  16.750  25.987  1.00 12.33           N  
ATOM    546  CA  HIS A  71      15.898  17.348  26.621  1.00 12.21           C  
ATOM    547  C   HIS A  71      16.240  17.976  27.973  1.00 12.64           C  
ATOM    548  O   HIS A  71      17.261  17.630  28.580  1.00 12.72           O  
ATOM    549  CB  HIS A  71      14.800  16.297  26.776  1.00 12.36           C  
ATOM    550  CG  HIS A  71      14.216  15.846  25.470  1.00 12.90           C  
ATOM    551  ND1 HIS A  71      12.923  15.378  25.357  1.00 15.07           N  
ATOM    552  CD2 HIS A  71      14.745  15.805  24.219  1.00 14.91           C  
ATOM    553  CE1 HIS A  71      12.684  15.059  24.095  1.00 15.02           C  
ATOM    554  NE2 HIS A  71      13.774  15.304  23.385  1.00 14.53           N  
ATOM    555  N   ALA A  72      15.379  18.886  28.442  1.00 12.71           N  
ATOM    556  CA  ALA A  72      15.627  19.603  29.700  1.00 12.54           C  
ATOM    557  C   ALA A  72      15.802  18.622  30.856  1.00 12.80           C  
ATOM    558  O   ALA A  72      16.793  18.702  31.602  1.00 12.35           O  
ATOM    559  CB  ALA A  72      14.486  20.586  30.007  1.00 13.00           C  
ATOM    560  N   GLU A  73      14.842  17.705  30.998  1.00 11.97           N  
ATOM    561  CA  GLU A  73      14.872  16.699  32.071  1.00 12.18           C  
ATOM    562  C   GLU A  73      16.143  15.857  32.011  1.00 11.90           C  
ATOM    563  O   GLU A  73      16.774  15.581  33.039  1.00 12.12           O  
ATOM    564  CB  GLU A  73      13.648  15.777  32.004  1.00 12.05           C  
ATOM    565  CG  GLU A  73      12.308  16.479  31.953  1.00 13.00           C  
ATOM    566  CD  GLU A  73      11.839  16.707  30.532  1.00 14.01           C  
ATOM    567  OE1 GLU A  73      12.390  17.607  29.857  1.00 14.19           O  
ATOM    568  OE2 GLU A  73      10.913  15.982  30.109  1.00 14.75           O  
ATOM    569  N   MET A  74      16.515  15.457  30.797  1.00 11.73           N  
ATOM    570  CA  MET A  74      17.727  14.679  30.574  1.00 12.43           C  
ATOM    571  C   MET A  74      18.973  15.470  30.954  1.00 12.31           C  
ATOM    572  O   MET A  74      19.898  14.907  31.545  1.00 12.31           O  
ATOM    573  CB  MET A  74      17.797  14.231  29.125  1.00 12.99           C  
ATOM    574  CG  MET A  74      16.932  13.020  28.824  0.50 13.85           C  
ATOM    576  SD  MET A  74      17.268  11.571  29.869  0.50 16.91           S  
ATOM    578  CE  MET A  74      18.957  11.177  29.406  0.50 17.27           C  
ATOM    580  N   ASN A  75      18.985  16.764  30.632  1.00 11.87           N  
ATOM    581  CA  ASN A  75      20.118  17.618  31.021  1.00 12.26           C  
ATOM    582  C   ASN A  75      20.275  17.706  32.541  1.00 12.58           C  
ATOM    583  O   ASN A  75      21.399  17.731  33.051  1.00 12.63           O  
ATOM    584  CB  ASN A  75      20.039  18.999  30.351  1.00 12.07           C  
ATOM    585  CG  ASN A  75      20.761  19.031  29.008  1.00 11.76           C  
ATOM    586  OD1 ASN A  75      20.260  19.602  28.019  1.00 14.59           O  
ATOM    587  ND2 ASN A  75      21.935  18.403  28.957  1.00  9.01           N  
ATOM    588  N   ALA A  76      19.157  17.717  33.270  1.00 12.66           N  
ATOM    589  CA  ALA A  76      19.218  17.658  34.745  1.00 12.58           C  
ATOM    590  C   ALA A  76      19.803  16.332  35.242  1.00 12.44           C  
ATOM    591  O   ALA A  76      20.710  16.312  36.078  1.00 12.40           O  
ATOM    592  CB  ALA A  76      17.845  17.857  35.346  1.00 12.47           C  
ATOM    593  N   LEU A  77      19.278  15.224  34.723  1.00 11.76           N  
ATOM    594  CA  LEU A  77      19.769  13.904  35.107  1.00 12.47           C  
ATOM    595  C   LEU A  77      21.235  13.709  34.730  1.00 12.08           C  
ATOM    596  O   LEU A  77      22.010  13.148  35.496  1.00 13.02           O  
ATOM    597  CB  LEU A  77      18.933  12.791  34.470  1.00 12.66           C  
ATOM    598  CG  LEU A  77      17.499  12.665  34.966  1.00 13.32           C  
ATOM    599  CD1 LEU A  77      16.794  11.580  34.154  1.00 13.40           C  
ATOM    600  CD2 LEU A  77      17.498  12.335  36.466  1.00 14.73           C  
ATOM    601  N   ILE A  78      21.608  14.185  33.547  1.00 12.38           N  
ATOM    602  CA  ILE A  78      22.980  14.009  33.072  1.00 12.96           C  
ATOM    603  C   ILE A  78      23.944  14.884  33.865  1.00 12.95           C  
ATOM    604  O   ILE A  78      25.082  14.478  34.091  1.00 12.63           O  
ATOM    605  CB  ILE A  78      23.119  14.220  31.541  1.00 13.36           C  
ATOM    606  CG1 ILE A  78      22.343  13.134  30.773  1.00 13.67           C  
ATOM    607  CG2 ILE A  78      24.618  14.314  31.125  1.00 14.39           C  
ATOM    608  CD1 ILE A  78      22.121  13.477  29.314  0.60 13.91           C  
ATOM    610  N   GLN A  79      23.500  16.057  34.317  1.00 12.81           N  
ATOM    611  CA  GLN A  79      24.312  16.823  35.265  1.00 12.76           C  
ATOM    612  C   GLN A  79      24.683  15.936  36.458  1.00 13.19           C  
ATOM    613  O   GLN A  79      25.840  15.914  36.879  1.00 13.37           O  
ATOM    614  CB  GLN A  79      23.596  18.081  35.749  1.00 12.83           C  
ATOM    615  CG  GLN A  79      24.479  18.948  36.631  1.00 12.90           C  
ATOM    616  CD  GLN A  79      23.730  20.096  37.271  1.00 13.93           C  
ATOM    617  OE1 GLN A  79      22.715  20.580  36.745  1.00 12.63           O  
ATOM    618  NE2 GLN A  79      24.241  20.554  38.416  1.00 12.22           N  
ATOM    619  N   CYS A  80      23.691  15.213  36.987  1.00 12.81           N  
ATOM    620  CA  CYS A  80      23.918  14.310  38.113  1.00 13.18           C  
ATOM    621  C   CYS A  80      24.886  13.178  37.754  1.00 13.41           C  
ATOM    622  O   CYS A  80      25.813  12.887  38.515  1.00 13.55           O  
ATOM    623  CB  CYS A  80      22.598  13.737  38.626  1.00 13.49           C  
ATOM    624  SG  CYS A  80      21.488  14.976  39.330  1.00 14.18           S  
ATOM    625  N   ALA A  81      24.681  12.553  36.592  1.00 13.51           N  
ATOM    626  CA  ALA A  81      25.561  11.442  36.173  1.00 14.02           C  
ATOM    627  C   ALA A  81      26.986  11.931  35.922  1.00 14.39           C  
ATOM    628  O   ALA A  81      27.939  11.272  36.303  1.00 14.87           O  
ATOM    629  CB  ALA A  81      25.013  10.754  34.925  1.00 13.87           C  
ATOM    630  N   LYS A  82      27.124  13.092  35.291  1.00 14.75           N  
ATOM    631  CA  LYS A  82      28.452  13.613  34.950  1.00 16.51           C  
ATOM    632  C   LYS A  82      29.247  14.036  36.190  1.00 17.76           C  
ATOM    633  O   LYS A  82      30.442  13.724  36.288  1.00 19.09           O  
ATOM    634  CB  LYS A  82      28.337  14.774  33.952  1.00 15.97           C  
ATOM    635  CG  LYS A  82      29.675  15.280  33.457  1.00 16.07           C  
ATOM    636  CD  LYS A  82      29.495  16.361  32.393  1.00 17.16           C  
ATOM    637  CE  LYS A  82      30.834  16.951  32.012  1.00 19.12           C  
ATOM    638  NZ  LYS A  82      30.630  18.109  31.079  0.50 15.61           N  
ATOM    639  N   GLU A  83      28.581  14.727  37.120  1.00 18.43           N  
ATOM    640  CA  GLU A  83      29.192  15.249  38.364  1.00 19.90           C  
ATOM    641  C   GLU A  83      29.322  14.172  39.454  1.00 19.71           C  
ATOM    642  O   GLU A  83      30.227  14.239  40.294  1.00 20.52           O  
ATOM    643  CB  GLU A  83      28.366  16.430  38.948  1.00 19.72           C  
ATOM    644  CG  GLU A  83      28.385  17.748  38.181  0.50 21.29           C  
ATOM    646  CD  GLU A  83      27.347  18.800  38.666  0.50 21.20           C  
ATOM    648  OE1 GLU A  83      27.414  19.948  38.183  0.50 19.94           O  
ATOM    650  OE2 GLU A  83      26.458  18.500  39.508  0.50 23.05           O  
ATOM    652  N   GLY A  84      28.416  13.195  39.449  1.00 19.61           N  
ATOM    653  CA  GLY A  84      28.308  12.230  40.542  1.00 19.95           C  
ATOM    654  C   GLY A  84      27.473  12.796  41.684  1.00 20.20           C  
ATOM    655  O   GLY A  84      27.917  12.817  42.836  0.90 21.40           O  
ATOM    656  N   ILE A  85      26.272  13.271  41.359  1.00 19.55           N  
ATOM    657  CA  ILE A  85      25.307  13.777  42.341  1.00 19.64           C  
ATOM    658  C   ILE A  85      24.135  12.806  42.330  1.00 18.83           C  
ATOM    659  O   ILE A  85      23.665  12.443  41.256  1.00 18.58           O  
ATOM    660  CB  ILE A  85      24.808  15.189  41.946  1.00 19.83           C  
ATOM    661  CG1 ILE A  85      25.958  16.204  41.999  1.00 21.17           C  
ATOM    662  CG2 ILE A  85      23.615  15.663  42.824  1.00 22.05           C  
ATOM    663  CD1 ILE A  85      26.809  16.159  43.287  0.50 20.60           C  
ATOM    664  N   SER A  86      23.683  12.354  43.502  1.00 17.27           N  
ATOM    665  CA  SER A  86      22.605  11.353  43.532  1.00 16.39           C  
ATOM    666  C   SER A  86      21.229  11.952  43.238  1.00 15.91           C  
ATOM    667  O   SER A  86      20.772  12.862  43.942  1.00 15.97           O  
ATOM    668  CB  SER A  86      22.561  10.609  44.869  1.00 16.26           C  
ATOM    669  OG  SER A  86      21.416   9.764  44.927  1.00 16.26           O  
ATOM    670  N   ALA A  87      20.573  11.433  42.199  1.00 14.95           N  
ATOM    671  CA  ALA A  87      19.221  11.855  41.830  1.00 14.84           C  
ATOM    672  C   ALA A  87      18.124  10.988  42.472  1.00 14.61           C  
ATOM    673  O   ALA A  87      16.941  11.199  42.226  1.00 14.72           O  
ATOM    674  CB  ALA A  87      19.064  11.865  40.295  1.00 14.71           C  
ATOM    675  N   ASN A  88      18.516  10.012  43.288  1.00 14.35           N  
ATOM    676  CA  ASN A  88      17.538   9.123  43.914  1.00 14.18           C  
ATOM    677  C   ASN A  88      16.679   9.907  44.904  1.00 14.61           C  
ATOM    678  O   ASN A  88      17.188  10.818  45.562  1.00 13.99           O  
ATOM    679  CB  ASN A  88      18.234   7.962  44.630  1.00 15.21           C  
ATOM    680  CG  ASN A  88      17.298   6.801  44.916  1.00 15.39           C  
ATOM    681  OD1 ASN A  88      16.176   6.730  44.406  1.00 16.71           O  
ATOM    682  ND2 ASN A  88      17.768   5.872  45.740  1.00 18.43           N  
ATOM    683  N   ASN A  89      15.385   9.582  44.981  1.00 14.16           N  
ATOM    684  CA  ASN A  89      14.489  10.228  45.970  1.00 14.87           C  
ATOM    685  C   ASN A  89      14.354  11.742  45.786  1.00 14.69           C  
ATOM    686  O   ASN A  89      14.294  12.525  46.751  1.00 14.32           O  
ATOM    687  CB  ASN A  89      14.958   9.902  47.393  1.00 15.02           C  
ATOM    688  CG  ASN A  89      14.898   8.424  47.680  1.00 17.71           C  
ATOM    689  OD1 ASN A  89      13.858   7.789  47.483  1.00 19.93           O  
ATOM    690  ND2 ASN A  89      16.017   7.858  48.140  1.00 20.35           N  
ATOM    691  N   THR A  90      14.328  12.143  44.529  1.00 13.59           N  
ATOM    692  CA  THR A  90      14.102  13.530  44.166  1.00 13.35           C  
ATOM    693  C   THR A  90      12.685  13.703  43.602  1.00 13.25           C  
ATOM    694  O   THR A  90      11.943  12.725  43.415  1.00 13.26           O  
ATOM    695  CB  THR A  90      15.098  13.990  43.079  1.00 13.67           C  
ATOM    696  OG1 THR A  90      15.056  13.065  41.990  1.00 13.73           O  
ATOM    697  CG2 THR A  90      16.528  14.061  43.632  1.00 14.34           C  
ATOM    698  N   GLU A  91      12.313  14.958  43.365  1.00 12.57           N  
ATOM    699  CA  GLU A  91      11.183  15.285  42.514  1.00 13.37           C  
ATOM    700  C   GLU A  91      11.672  16.268  41.454  1.00 13.17           C  
ATOM    701  O   GLU A  91      12.733  16.896  41.602  1.00 12.61           O  
ATOM    702  CB  GLU A  91      10.035  15.902  43.333  1.00 12.92           C  
ATOM    703  CG  GLU A  91      10.366  17.265  43.928  1.00 13.46           C  
ATOM    704  CD  GLU A  91       9.233  17.846  44.748  1.00 16.31           C  
ATOM    705  OE1 GLU A  91       8.088  17.926  44.235  1.00 16.11           O  
ATOM    706  OE2 GLU A  91       9.496  18.210  45.914  1.00 19.48           O  
ATOM    707  N   ILE A  92      10.915  16.383  40.372  1.00 12.49           N  
ATOM    708  CA  ILE A  92      11.288  17.299  39.301  1.00 12.64           C  
ATOM    709  C   ILE A  92      10.146  18.258  38.998  1.00 12.99           C  
ATOM    710  O   ILE A  92       8.963  17.896  39.127  1.00 12.79           O  
ATOM    711  CB  ILE A  92      11.757  16.525  38.033  1.00 12.78           C  
ATOM    712  CG1 ILE A  92      12.506  17.462  37.060  1.00 13.68           C  
ATOM    713  CG2 ILE A  92      10.575  15.778  37.354  1.00 12.39           C  
ATOM    714  CD1 ILE A  92      13.310  16.736  35.996  1.00 13.06           C  
ATOM    715  N   TYR A  93      10.521  19.486  38.655  1.00 12.36           N  
ATOM    716  CA  TYR A  93       9.592  20.503  38.169  1.00 13.22           C  
ATOM    717  C   TYR A  93      10.030  20.820  36.751  1.00 12.99           C  
ATOM    718  O   TYR A  93      11.210  21.077  36.500  1.00 13.75           O  
ATOM    719  CB  TYR A  93       9.690  21.754  39.024  1.00 14.34           C  
ATOM    720  CG  TYR A  93       9.121  21.612  40.420  1.00 14.63           C  
ATOM    721  CD1 TYR A  93       7.842  22.076  40.709  1.00 16.42           C  
ATOM    722  CD2 TYR A  93       9.872  21.049  41.452  1.00 16.06           C  
ATOM    723  CE1 TYR A  93       7.309  21.964  41.991  1.00 17.88           C  
ATOM    724  CE2 TYR A  93       9.344  20.930  42.742  1.00 17.47           C  
ATOM    725  CZ  TYR A  93       8.066  21.399  42.996  1.00 17.99           C  
ATOM    726  OH  TYR A  93       7.539  21.299  44.266  1.00 19.35           O  
ATOM    727  N   VAL A  94       9.087  20.773  35.823  1.00 12.98           N  
ATOM    728  CA  VAL A  94       9.417  20.901  34.412  1.00 13.77           C  
ATOM    729  C   VAL A  94       8.339  21.743  33.727  1.00 13.88           C  
ATOM    730  O   VAL A  94       7.153  21.665  34.077  1.00 14.47           O  
ATOM    731  CB  VAL A  94       9.571  19.487  33.710  1.00 13.82           C  
ATOM    732  CG1 VAL A  94      10.186  19.617  32.300  0.50 12.30           C  
ATOM    734  CG2 VAL A  94      10.326  18.496  34.544  0.50 15.49           C  
ATOM    735  N   THR A  95       8.746  22.557  32.764  1.00 13.62           N  
ATOM    736  CA  THR A  95       7.793  23.438  32.073  1.00 14.25           C  
ATOM    737  C   THR A  95       6.808  22.634  31.211  1.00 14.42           C  
ATOM    738  O   THR A  95       5.666  23.048  31.000  1.00 15.38           O  
ATOM    739  CB  THR A  95       8.527  24.453  31.194  1.00 13.93           C  
ATOM    740  OG1 THR A  95       9.421  23.758  30.318  1.00 14.50           O  
ATOM    741  CG2 THR A  95       9.332  25.440  32.059  1.00 14.41           C  
ATOM    742  N   HIS A  96       7.263  21.491  30.707  1.00 14.48           N  
ATOM    743  CA  HIS A  96       6.489  20.664  29.772  1.00 14.79           C  
ATOM    744  C   HIS A  96       6.460  19.228  30.255  1.00 15.02           C  
ATOM    745  O   HIS A  96       7.480  18.712  30.733  1.00 14.93           O  
ATOM    746  CB  HIS A  96       7.124  20.710  28.368  1.00 14.83           C  
ATOM    747  CG  HIS A  96       7.067  22.058  27.713  1.00 16.39           C  
ATOM    748  ND1 HIS A  96       7.796  23.142  28.154  1.00 16.16           N  
ATOM    749  CD2 HIS A  96       6.370  22.488  26.633  1.00 16.79           C  
ATOM    750  CE1 HIS A  96       7.541  24.185  27.385  1.00 17.80           C  
ATOM    751  NE2 HIS A  96       6.680  23.814  26.453  1.00 17.64           N  
ATOM    752  N   PHE A  97       5.304  18.581  30.119  1.00 14.79           N  
ATOM    753  CA  PHE A  97       5.147  17.159  30.469  1.00 14.75           C  
ATOM    754  C   PHE A  97       6.223  16.296  29.791  1.00 14.55           C  
ATOM    755  O   PHE A  97       6.463  16.457  28.590  1.00 15.35           O  
ATOM    756  CB  PHE A  97       3.759  16.656  30.046  1.00 15.51           C  
ATOM    757  CG  PHE A  97       3.426  15.304  30.605  1.00 15.07           C  
ATOM    758  CD1 PHE A  97       2.710  15.187  31.802  1.00 17.23           C  
ATOM    759  CD2 PHE A  97       3.849  14.146  29.961  1.00 16.18           C  
ATOM    760  CE1 PHE A  97       2.408  13.936  32.336  1.00 16.51           C  
ATOM    761  CE2 PHE A  97       3.558  12.885  30.483  1.00 16.08           C  
ATOM    762  CZ  PHE A  97       2.834  12.772  31.674  1.00 16.93           C  
ATOM    763  N   PRO A  98       6.897  15.406  30.557  1.00 14.97           N  
ATOM    764  CA  PRO A  98       8.003  14.625  29.977  1.00 14.43           C  
ATOM    765  C   PRO A  98       7.594  13.635  28.884  1.00 14.09           C  
ATOM    766  O   PRO A  98       6.606  12.900  29.026  1.00 14.03           O  
ATOM    767  CB  PRO A  98       8.585  13.862  31.183  1.00 14.83           C  
ATOM    768  CG  PRO A  98       7.467  13.809  32.167  1.00 16.03           C  
ATOM    769  CD  PRO A  98       6.730  15.126  32.000  1.00 14.77           C  
ATOM    770  N   CYS A  99       8.377  13.623  27.809  1.00 13.90           N  
ATOM    771  CA  CYS A  99       8.246  12.631  26.746  1.00 13.66           C  
ATOM    772  C   CYS A  99       8.521  11.233  27.293  1.00 13.48           C  
ATOM    773  O   CYS A  99       8.982  11.079  28.435  1.00 12.55           O  
ATOM    774  CB  CYS A  99       9.239  12.957  25.621  1.00 13.88           C  
ATOM    775  SG  CYS A  99      10.972  12.535  26.013  1.00 13.73           S  
ATOM    776  N   ILE A 100       8.276  10.206  26.481  1.00 13.59           N  
ATOM    777  CA  ILE A 100       8.424   8.843  26.980  1.00 13.79           C  
ATOM    778  C   ILE A 100       9.890   8.537  27.372  1.00 13.70           C  
ATOM    779  O   ILE A 100      10.150   7.886  28.385  1.00 13.73           O  
ATOM    780  CB  ILE A 100       7.828   7.792  26.001  1.00 14.55           C  
ATOM    781  CG1 ILE A 100       7.877   6.392  26.629  1.00 14.78           C  
ATOM    782  CG2 ILE A 100       8.555   7.820  24.669  1.00 14.80           C  
ATOM    783  CD1 ILE A 100       7.145   6.274  27.980  1.00 17.42           C  
ATOM    784  N   ASN A 101      10.848   9.060  26.606  1.00 13.93           N  
ATOM    785  CA  ASN A 101      12.256   8.815  26.918  1.00 14.12           C  
ATOM    786  C   ASN A 101      12.675   9.440  28.242  1.00 13.75           C  
ATOM    787  O   ASN A 101      13.347   8.792  29.054  1.00 14.53           O  
ATOM    788  CB  ASN A 101      13.142   9.350  25.796  1.00 14.37           C  
ATOM    789  CG  ASN A 101      13.385   8.319  24.698  0.60 14.92           C  
ATOM    791  OD1 ASN A 101      13.497   7.114  24.954  0.60 17.48           O  
ATOM    793  ND2 ASN A 101      13.482   8.795  23.470  0.60 14.80           N  
ATOM    795  N   CYS A 102      12.271  10.691  28.449  1.00 13.58           N  
ATOM    796  CA  CYS A 102      12.553  11.388  29.710  1.00 12.93           C  
ATOM    797  C   CYS A 102      11.827  10.717  30.873  1.00 13.05           C  
ATOM    798  O   CYS A 102      12.405  10.532  31.940  1.00 12.68           O  
ATOM    799  CB  CYS A 102      12.172  12.865  29.607  1.00 13.36           C  
ATOM    800  SG  CYS A 102      13.369  13.817  28.621  1.00 13.09           S  
ATOM    801  N   THR A 103      10.575  10.319  30.640  1.00 12.73           N  
ATOM    802  CA  THR A 103       9.797   9.612  31.667  1.00 12.56           C  
ATOM    803  C   THR A 103      10.522   8.342  32.139  1.00 12.35           C  
ATOM    804  O   THR A 103      10.703   8.141  33.343  1.00 12.47           O  
ATOM    805  CB  THR A 103       8.379   9.289  31.153  1.00 12.64           C  
ATOM    806  OG1 THR A 103       7.672  10.519  30.940  1.00 12.79           O  
ATOM    807  CG2 THR A 103       7.627   8.431  32.166  1.00 14.32           C  
ATOM    808  N   LYS A 104      10.967   7.505  31.197  1.00 11.99           N  
ATOM    809  CA  LYS A 104      11.699   6.289  31.567  1.00 12.62           C  
ATOM    810  C   LYS A 104      12.945   6.626  32.390  1.00 12.59           C  
ATOM    811  O   LYS A 104      13.197   6.004  33.433  1.00 13.21           O  
ATOM    812  CB  LYS A 104      12.082   5.472  30.324  1.00 12.56           C  
ATOM    813  CG  LYS A 104      10.869   4.842  29.648  1.00 13.32           C  
ATOM    814  CD  LYS A 104      11.278   3.921  28.507  1.00 14.15           C  
ATOM    815  CE  LYS A 104      11.703   4.743  27.292  1.00 13.98           C  
ATOM    816  NZ  LYS A 104      12.000   3.889  26.097  1.00 12.62           N  
ATOM    817  N   ALA A 105      13.717   7.606  31.927  1.00 12.57           N  
ATOM    818  CA  ALA A 105      14.983   7.947  32.600  1.00 12.79           C  
ATOM    819  C   ALA A 105      14.719   8.475  34.009  1.00 12.36           C  
ATOM    820  O   ALA A 105      15.378   8.057  34.962  1.00 12.48           O  
ATOM    821  CB  ALA A 105      15.768   8.952  31.788  1.00 12.81           C  
ATOM    822  N   LEU A 106      13.734   9.365  34.136  1.00 12.99           N  
ATOM    823  CA  LEU A 106      13.352   9.917  35.450  1.00 12.29           C  
ATOM    824  C   LEU A 106      12.930   8.816  36.429  1.00 13.00           C  
ATOM    825  O   LEU A 106      13.419   8.752  37.566  1.00 12.78           O  
ATOM    826  CB  LEU A 106      12.226  10.948  35.301  1.00 12.29           C  
ATOM    827  CG  LEU A 106      12.656  12.239  34.579  1.00 11.47           C  
ATOM    828  CD1 LEU A 106      11.410  13.021  34.157  1.00 12.79           C  
ATOM    829  CD2 LEU A 106      13.595  13.126  35.437  1.00 12.92           C  
ATOM    830  N   LEU A 107      12.023   7.953  35.975  1.00 12.53           N  
ATOM    831  CA  LEU A 107      11.524   6.874  36.822  1.00 13.12           C  
ATOM    832  C   LEU A 107      12.678   5.963  37.225  1.00 12.79           C  
ATOM    833  O   LEU A 107      12.823   5.615  38.400  1.00 12.76           O  
ATOM    834  CB  LEU A 107      10.427   6.079  36.107  1.00 13.48           C  
ATOM    835  CG  LEU A 107       9.122   6.835  35.802  1.00 15.30           C  
ATOM    836  CD1 LEU A 107       8.157   5.891  35.092  1.00 16.28           C  
ATOM    837  CD2 LEU A 107       8.474   7.422  37.022  1.00 19.36           C  
ATOM    838  N   GLN A 108      13.523   5.616  36.254  1.00 12.94           N  
ATOM    839  CA  GLN A 108      14.661   4.728  36.522  1.00 13.15           C  
ATOM    840  C   GLN A 108      15.694   5.342  37.486  1.00 13.26           C  
ATOM    841  O   GLN A 108      16.374   4.618  38.229  1.00 13.94           O  
ATOM    842  CB  GLN A 108      15.344   4.308  35.205  1.00 12.88           C  
ATOM    843  CG  GLN A 108      16.164   3.021  35.319  1.00 13.81           C  
ATOM    844  CD  GLN A 108      15.319   1.740  35.305  1.00 13.35           C  
ATOM    845  OE1 GLN A 108      15.699   0.727  34.690  1.00 18.18           O  
ATOM    846  NE2 GLN A 108      14.203   1.761  36.011  1.00 11.78           N  
ATOM    847  N   ALA A 109      15.804   6.669  37.467  1.00 12.75           N  
ATOM    848  CA  ALA A 109      16.771   7.374  38.316  1.00 12.73           C  
ATOM    849  C   ALA A 109      16.311   7.518  39.767  1.00 13.42           C  
ATOM    850  O   ALA A 109      17.098   7.928  40.630  1.00 14.42           O  
ATOM    851  CB  ALA A 109      17.106   8.737  37.722  1.00 12.52           C  
ATOM    852  N   GLY A 110      15.047   7.190  40.029  1.00 13.58           N  
ATOM    853  CA  GLY A 110      14.483   7.345  41.375  1.00 13.37           C  
ATOM    854  C   GLY A 110      13.781   8.668  41.630  1.00 14.25           C  
ATOM    855  O   GLY A 110      13.606   9.068  42.788  1.00 14.70           O  
ATOM    856  N   VAL A 111      13.375   9.357  40.559  1.00 13.43           N  
ATOM    857  CA  VAL A 111      12.547  10.568  40.692  1.00 13.76           C  
ATOM    858  C   VAL A 111      11.142  10.093  41.074  1.00 14.67           C  
ATOM    859  O   VAL A 111      10.587   9.207  40.418  1.00 15.26           O  
ATOM    860  CB  VAL A 111      12.508  11.372  39.380  1.00 13.57           C  
ATOM    861  CG1 VAL A 111      11.509  12.548  39.479  1.00 14.52           C  
ATOM    862  CG2 VAL A 111      13.927  11.853  39.024  1.00 13.81           C  
ATOM    863  N   LYS A 112      10.595  10.676  42.143  1.00 14.37           N  
ATOM    864  CA  LYS A 112       9.389  10.167  42.810  1.00 14.47           C  
ATOM    865  C   LYS A 112       8.114  10.968  42.530  1.00 14.55           C  
ATOM    866  O   LYS A 112       7.002  10.513  42.834  1.00 14.25           O  
ATOM    867  CB  LYS A 112       9.632  10.131  44.326  1.00 15.03           C  
ATOM    868  CG  LYS A 112      10.844   9.303  44.741  1.00 16.45           C  
ATOM    869  CD  LYS A 112      10.625   7.818  44.468  1.00 19.40           C  
ATOM    870  CE  LYS A 112      11.901   7.026  44.748  1.00 19.55           C  
ATOM    871  NZ  LYS A 112      11.645   5.571  44.844  1.00 21.86           N  
ATOM    872  N   LYS A 113       8.278  12.158  41.967  1.00 13.44           N  
ATOM    873  CA  LYS A 113       7.153  13.032  41.651  1.00 13.81           C  
ATOM    874  C   LYS A 113       7.556  13.958  40.520  1.00 13.69           C  
ATOM    875  O   LYS A 113       8.704  14.409  40.454  1.00 12.44           O  
ATOM    876  CB  LYS A 113       6.765  13.858  42.882  1.00 13.89           C  
ATOM    877  CG  LYS A 113       5.546  14.767  42.704  1.00 15.01           C  
ATOM    878  CD  LYS A 113       5.255  15.530  43.986  1.00 16.11           C  
ATOM    879  CE  LYS A 113       3.919  16.242  43.892  1.00 20.09           C  
ATOM    880  NZ  LYS A 113       3.612  16.989  45.149  1.00 21.13           N  
ATOM    881  N   ILE A 114       6.595  14.232  39.642  1.00 13.68           N  
ATOM    882  CA  ILE A 114       6.801  15.077  38.479  1.00 14.59           C  
ATOM    883  C   ILE A 114       5.734  16.170  38.490  1.00 14.88           C  
ATOM    884  O   ILE A 114       4.532  15.866  38.514  1.00 15.15           O  
ATOM    885  CB  ILE A 114       6.722  14.234  37.169  1.00 14.81           C  
ATOM    886  CG1 ILE A 114       7.827  13.167  37.156  1.00 15.60           C  
ATOM    887  CG2 ILE A 114       6.784  15.145  35.929  1.00 15.81           C  
ATOM    888  CD1 ILE A 114       7.630  12.063  36.132  1.00 15.93           C  
ATOM    889  N   THR A 115       6.174  17.427  38.520  1.00 14.52           N  
ATOM    890  CA  THR A 115       5.268  18.577  38.460  1.00 14.83           C  
ATOM    891  C   THR A 115       5.549  19.339  37.163  1.00 15.30           C  
ATOM    892  O   THR A 115       6.690  19.693  36.889  1.00 14.03           O  
ATOM    893  CB  THR A 115       5.397  19.489  39.708  1.00 14.97           C  
ATOM    894  OG1 THR A 115       5.131  18.720  40.886  1.00 14.35           O  
ATOM    895  CG2 THR A 115       4.391  20.675  39.634  1.00 14.54           C  
ATOM    896  N   TYR A 116       4.509  19.572  36.359  1.00 15.50           N  
ATOM    897  CA  TYR A 116       4.688  20.171  35.035  1.00 16.08           C  
ATOM    898  C   TYR A 116       3.665  21.287  34.804  1.00 17.00           C  
ATOM    899  O   TYR A 116       2.601  21.301  35.429  1.00 17.08           O  
ATOM    900  CB  TYR A 116       4.545  19.102  33.945  1.00 16.67           C  
ATOM    901  CG  TYR A 116       3.124  18.582  33.832  1.00 16.40           C  
ATOM    902  CD1 TYR A 116       2.235  19.131  32.904  1.00 18.49           C  
ATOM    903  CD2 TYR A 116       2.659  17.564  34.675  1.00 16.91           C  
ATOM    904  CE1 TYR A 116       0.926  18.674  32.806  1.00 18.86           C  
ATOM    905  CE2 TYR A 116       1.335  17.098  34.589  1.00 17.51           C  
ATOM    906  CZ  TYR A 116       0.480  17.665  33.647  1.00 18.48           C  
ATOM    907  OH  TYR A 116      -0.829  17.213  33.548  1.00 19.80           O  
ATOM    908  N   ASN A 117       3.989  22.201  33.900  1.00 17.43           N  
ATOM    909  CA  ASN A 117       3.081  23.283  33.539  1.00 17.99           C  
ATOM    910  C   ASN A 117       2.245  22.933  32.310  1.00 18.08           C  
ATOM    911  O   ASN A 117       1.026  22.770  32.406  1.00 19.13           O  
ATOM    912  CB  ASN A 117       3.853  24.589  33.321  1.00 18.50           C  
ATOM    913  CG  ASN A 117       2.952  25.739  32.904  1.00 20.59           C  
ATOM    914  OD1 ASN A 117       1.846  25.880  33.405  1.00 24.92           O  
ATOM    915  ND2 ASN A 117       3.424  26.556  31.969  1.00 24.23           N  
ATOM    916  N   THR A 118       2.912  22.799  31.170  1.00 17.55           N  
ATOM    917  CA  THR A 118       2.247  22.598  29.878  1.00 17.92           C  
ATOM    918  C   THR A 118       2.005  21.114  29.605  1.00 17.82           C  
ATOM    919  O   THR A 118       2.928  20.294  29.705  1.00 17.32           O  
ATOM    920  CB  THR A 118       3.107  23.208  28.751  1.00 17.74           C  
ATOM    921  OG1 THR A 118       3.275  24.612  28.992  1.00 18.60           O  
ATOM    922  CG2 THR A 118       2.468  22.992  27.371  1.00 19.05           C  
ATOM    923  N   ALA A 119       0.762  20.778  29.244  1.00 17.89           N  
ATOM    924  CA  ALA A 119       0.393  19.406  28.888  1.00 17.84           C  
ATOM    925  C   ALA A 119       0.846  19.108  27.454  1.00 18.07           C  
ATOM    926  O   ALA A 119       0.027  18.998  26.529  1.00 18.09           O  
ATOM    927  CB  ALA A 119      -1.129  19.195  29.056  1.00 17.94           C  
ATOM    928  N   TYR A 120       2.167  19.013  27.284  1.00 17.40           N  
ATOM    929  CA  TYR A 120       2.796  18.931  25.969  1.00 17.26           C  
ATOM    930  C   TYR A 120       2.849  17.495  25.463  1.00 17.02           C  
ATOM    931  O   TYR A 120       3.535  16.663  26.049  1.00 16.70           O  
ATOM    932  CB  TYR A 120       4.229  19.499  26.028  1.00 17.26           C  
ATOM    933  CG  TYR A 120       4.891  19.589  24.669  1.00 17.42           C  
ATOM    934  CD1 TYR A 120       4.525  20.592  23.773  1.00 16.95           C  
ATOM    935  CD2 TYR A 120       5.869  18.668  24.272  1.00 17.35           C  
ATOM    936  CE1 TYR A 120       5.124  20.692  22.524  1.00 17.85           C  
ATOM    937  CE2 TYR A 120       6.476  18.760  23.018  1.00 17.25           C  
ATOM    938  CZ  TYR A 120       6.084  19.771  22.145  1.00 17.65           C  
ATOM    939  OH  TYR A 120       6.660  19.874  20.900  1.00 18.19           O  
ATOM    940  N   ARG A 121       2.134  17.219  24.368  1.00 16.37           N  
ATOM    941  CA  ARG A 121       2.234  15.937  23.671  1.00 16.42           C  
ATOM    942  C   ARG A 121       2.265  14.760  24.650  1.00 16.06           C  
ATOM    943  O   ARG A 121       3.183  13.934  24.620  1.00 15.98           O  
ATOM    944  CB  ARG A 121       3.478  15.918  22.768  1.00 16.52           C  
ATOM    945  CG  ARG A 121       3.548  17.097  21.793  1.00 17.50           C  
ATOM    946  CD  ARG A 121       4.645  16.897  20.765  1.00 19.12           C  
ATOM    947  NE  ARG A 121       4.263  15.910  19.754  1.00 19.87           N  
ATOM    948  CZ  ARG A 121       4.992  15.614  18.682  1.00 20.26           C  
ATOM    949  NH1 ARG A 121       6.166  16.207  18.482  1.00 19.06           N  
ATOM    950  NH2 ARG A 121       4.551  14.707  17.818  1.00 20.94           N  
ATOM    951  N   ILE A 122       1.283  14.697  25.547  1.00 15.73           N  
ATOM    952  CA  ILE A 122       1.304  13.671  26.584  1.00 16.34           C  
ATOM    953  C   ILE A 122       1.165  12.262  25.993  1.00 16.16           C  
ATOM    954  O   ILE A 122       0.143  11.926  25.367  1.00 16.39           O  
ATOM    955  CB  ILE A 122       0.248  13.935  27.691  1.00 15.91           C  
ATOM    956  CG1 ILE A 122       0.534  15.282  28.377  1.00 17.28           C  
ATOM    957  CG2 ILE A 122       0.227  12.763  28.690  1.00 18.07           C  
ATOM    958  CD1 ILE A 122      -0.341  15.577  29.603  1.00 17.34           C  
ATOM    959  N   HIS A 123       2.210  11.454  26.167  1.00 15.10           N  
ATOM    960  CA  HIS A 123       2.235  10.095  25.652  1.00 15.53           C  
ATOM    961  C   HIS A 123       1.458   9.154  26.584  1.00 15.54           C  
ATOM    962  O   HIS A 123       1.786   9.040  27.770  1.00 14.82           O  
ATOM    963  CB  HIS A 123       3.682   9.609  25.496  1.00 15.66           C  
ATOM    964  CG  HIS A 123       3.825   8.464  24.547  1.00 16.16           C  
ATOM    965  ND1 HIS A 123       3.172   7.263  24.726  1.00 15.50           N  
ATOM    966  CD2 HIS A 123       4.533   8.342  23.399  1.00 16.77           C  
ATOM    967  CE1 HIS A 123       3.477   6.445  23.735  1.00 17.83           C  
ATOM    968  NE2 HIS A 123       4.298   7.076  22.914  1.00 17.28           N  
ATOM    969  N   PRO A 124       0.417   8.471  26.057  1.00 15.67           N  
ATOM    970  CA  PRO A 124      -0.335   7.568  26.941  1.00 15.70           C  
ATOM    971  C   PRO A 124       0.515   6.476  27.604  1.00 14.87           C  
ATOM    972  O   PRO A 124       0.197   6.039  28.710  1.00 14.40           O  
ATOM    973  CB  PRO A 124      -1.420   6.959  26.027  1.00 15.97           C  
ATOM    974  CG  PRO A 124      -1.035   7.294  24.649  1.00 17.50           C  
ATOM    975  CD  PRO A 124      -0.113   8.490  24.682  1.00 16.34           C  
ATOM    976  N   PHE A 125       1.603   6.054  26.958  1.00 14.49           N  
ATOM    977  CA  PHE A 125       2.482   5.064  27.571  1.00 14.30           C  
ATOM    978  C   PHE A 125       3.312   5.659  28.727  1.00 14.09           C  
ATOM    979  O   PHE A 125       3.641   4.951  29.694  1.00 14.05           O  
ATOM    980  CB  PHE A 125       3.366   4.389  26.517  1.00 14.93           C  
ATOM    981  CG  PHE A 125       4.179   3.257  27.059  1.00 15.26           C  
ATOM    982  CD1 PHE A 125       3.561   2.167  27.678  1.00 16.32           C  
ATOM    983  CD2 PHE A 125       5.572   3.273  26.947  1.00 16.13           C  
ATOM    984  CE1 PHE A 125       4.310   1.115  28.193  1.00 18.49           C  
ATOM    985  CE2 PHE A 125       6.342   2.229  27.460  1.00 17.91           C  
ATOM    986  CZ  PHE A 125       5.717   1.144  28.086  1.00 18.19           C  
ATOM    987  N   ALA A 126       3.625   6.954  28.634  1.00 14.29           N  
ATOM    988  CA  ALA A 126       4.272   7.671  29.744  1.00 14.36           C  
ATOM    989  C   ALA A 126       3.357   7.650  30.959  1.00 14.50           C  
ATOM    990  O   ALA A 126       3.801   7.365  32.070  1.00 14.60           O  
ATOM    991  CB  ALA A 126       4.601   9.107  29.352  1.00 14.56           C  
ATOM    992  N   ILE A 127       2.069   7.921  30.736  1.00 14.09           N  
ATOM    993  CA  ILE A 127       1.074   7.842  31.812  1.00 14.43           C  
ATOM    994  C   ILE A 127       1.000   6.427  32.398  1.00 14.01           C  
ATOM    995  O   ILE A 127       1.001   6.255  33.622  1.00 14.16           O  
ATOM    996  CB  ILE A 127      -0.319   8.300  31.309  1.00 14.39           C  
ATOM    997  CG1 ILE A 127      -0.278   9.784  30.926  1.00 15.21           C  
ATOM    998  CG2 ILE A 127      -1.399   8.033  32.367  1.00 14.91           C  
ATOM    999  CD1 ILE A 127      -0.157  10.744  32.114  1.00 16.67           C  
ATOM   1000  N   GLU A 128       0.976   5.414  31.527  1.00 14.41           N  
ATOM   1001  CA  GLU A 128       0.928   4.022  31.972  1.00 14.94           C  
ATOM   1002  C   GLU A 128       2.105   3.695  32.899  1.00 15.31           C  
ATOM   1003  O   GLU A 128       1.921   3.098  33.956  1.00 15.00           O  
ATOM   1004  CB  GLU A 128       0.900   3.057  30.783  1.00 15.55           C  
ATOM   1005  CG  GLU A 128       0.767   1.595  31.203  1.00 17.18           C  
ATOM   1006  CD  GLU A 128       1.004   0.628  30.064  1.00 21.78           C  
ATOM   1007  OE1 GLU A 128       0.498   0.891  28.957  1.00 23.76           O  
ATOM   1008  OE2 GLU A 128       1.706  -0.378  30.278  0.50 22.36           O  
ATOM   1009  N   LEU A 129       3.304   4.113  32.505  1.00 14.91           N  
ATOM   1010  CA  LEU A 129       4.507   3.831  33.306  1.00 15.57           C  
ATOM   1011  C   LEU A 129       4.508   4.574  34.634  1.00 15.76           C  
ATOM   1012  O   LEU A 129       4.789   3.981  35.677  1.00 15.48           O  
ATOM   1013  CB  LEU A 129       5.765   4.189  32.516  1.00 16.00           C  
ATOM   1014  CG  LEU A 129       6.127   3.354  31.293  1.00 17.63           C  
ATOM   1015  CD1 LEU A 129       7.551   3.730  30.877  1.00 19.84           C  
ATOM   1016  CD2 LEU A 129       6.022   1.842  31.574  1.00 19.43           C  
ATOM   1017  N   MET A 130       4.186   5.870  34.611  1.00 15.51           N  
ATOM   1018  CA  MET A 130       4.118   6.630  35.861  1.00 16.29           C  
ATOM   1019  C   MET A 130       3.114   5.982  36.814  1.00 16.43           C  
ATOM   1020  O   MET A 130       3.372   5.852  38.006  1.00 16.70           O  
ATOM   1021  CB  MET A 130       3.744   8.078  35.611  1.00 15.98           C  
ATOM   1022  CG  MET A 130       4.765   8.828  34.771  1.00 17.22           C  
ATOM   1023  SD  MET A 130       4.184  10.502  34.525  1.00 17.98           S  
ATOM   1024  CE  MET A 130       5.365  11.135  33.316  1.00 17.78           C  
ATOM   1025  N   THR A 131       1.976   5.557  36.264  1.00 16.50           N  
ATOM   1026  CA  THR A 131       0.955   4.878  37.062  1.00 17.08           C  
ATOM   1027  C   THR A 131       1.473   3.584  37.702  1.00 17.30           C  
ATOM   1028  O   THR A 131       1.314   3.385  38.915  1.00 17.52           O  
ATOM   1029  CB  THR A 131      -0.323   4.638  36.217  1.00 17.21           C  
ATOM   1030  OG1 THR A 131      -0.819   5.904  35.760  1.00 16.95           O  
ATOM   1031  CG2 THR A 131      -1.404   3.913  37.029  1.00 17.54           C  
ATOM   1032  N   GLN A 132       2.107   2.724  36.902  1.00 17.78           N  
ATOM   1033  CA  GLN A 132       2.617   1.445  37.389  1.00 18.93           C  
ATOM   1034  C   GLN A 132       3.744   1.633  38.407  1.00 19.67           C  
ATOM   1035  O   GLN A 132       3.840   0.896  39.391  1.00 20.00           O  
ATOM   1036  CB  GLN A 132       3.076   0.543  36.237  1.00 19.09           C  
ATOM   1037  CG  GLN A 132       3.406  -0.872  36.715  1.00 20.44           C  
ATOM   1038  CD  GLN A 132       3.527  -1.897  35.604  1.00 23.73           C  
ATOM   1039  OE1 GLN A 132       4.150  -1.659  34.567  1.00 22.42           O  
ATOM   1040  NE2 GLN A 132       2.946  -3.065  35.834  1.00 26.67           N  
ATOM   1041  N   LYS A 133       4.575   2.643  38.168  1.00 20.13           N  
ATOM   1042  CA  LYS A 133       5.717   2.923  39.029  1.00 21.55           C  
ATOM   1043  C   LYS A 133       5.286   3.695  40.287  1.00 21.87           C  
ATOM   1044  O   LYS A 133       6.085   3.875  41.213  1.00 22.76           O  
ATOM   1045  CB  LYS A 133       6.773   3.688  38.211  1.00 21.23           C  
ATOM   1046  CG  LYS A 133       8.121   3.875  38.858  1.00 22.75           C  
ATOM   1047  CD  LYS A 133       8.813   2.560  39.085  1.00 20.71           C  
ATOM   1048  CE  LYS A 133      10.219   2.852  39.546  1.00 20.90           C  
ATOM   1049  NZ  LYS A 133      10.891   1.678  40.100  1.00 21.58           N  
ATOM   1050  N   GLU A 134       4.026   4.141  40.314  1.00 22.34           N  
ATOM   1051  CA  GLU A 134       3.428   4.894  41.433  1.00 23.00           C  
ATOM   1052  C   GLU A 134       4.048   6.288  41.668  1.00 23.15           C  
ATOM   1053  O   GLU A 134       4.274   6.710  42.803  1.00 23.91           O  
ATOM   1054  CB  GLU A 134       3.359   4.048  42.725  1.00 23.31           C  
ATOM   1055  CG  GLU A 134       2.154   3.106  42.726  0.80 24.90           C  
ATOM   1056  CD  GLU A 134       2.298   1.919  43.672  0.50 26.46           C  
ATOM   1057  OE1 GLU A 134       2.927   2.059  44.739  0.60 26.80           O  
ATOM   1058  OE2 GLU A 134       1.763   0.838  43.341  0.60 27.96           O  
ATOM   1059  N   VAL A 135       4.303   6.993  40.570  1.00 22.68           N  
ATOM   1060  CA  VAL A 135       4.858   8.345  40.616  1.00 22.48           C  
ATOM   1061  C   VAL A 135       3.764   9.354  40.281  1.00 22.62           C  
ATOM   1062  O   VAL A 135       3.116   9.240  39.228  1.00 22.04           O  
ATOM   1063  CB  VAL A 135       6.052   8.470  39.633  1.00 22.58           C  
ATOM   1064  CG1 VAL A 135       6.422   9.929  39.377  1.00 22.20           C  
ATOM   1065  CG2 VAL A 135       7.250   7.689  40.159  1.00 22.55           C  
ATOM   1066  N   GLU A 136       3.552  10.344  41.158  1.00 22.79           N  
ATOM   1067  CA  GLU A 136       2.546  11.374  40.905  1.00 23.12           C  
ATOM   1068  C   GLU A 136       3.017  12.354  39.833  1.00 22.75           C  
ATOM   1069  O   GLU A 136       4.211  12.687  39.767  1.00 22.67           O  
ATOM   1070  CB  GLU A 136       2.156  12.142  42.186  1.00 23.84           C  
ATOM   1071  CG  GLU A 136       0.653  12.299  42.362  0.80 24.28           C  
ATOM   1072  CD  GLU A 136       0.236  13.246  43.501  0.60 24.07           C  
ATOM   1073  OE1 GLU A 136       1.086  13.645  44.326  0.60 23.36           O  
ATOM   1074  OE2 GLU A 136      -0.967  13.586  43.568  0.60 24.51           O  
ATOM   1075  N   TYR A 137       2.076  12.784  38.997  1.00 22.13           N  
ATOM   1076  CA  TYR A 137       2.309  13.793  37.966  1.00 21.35           C  
ATOM   1077  C   TYR A 137       1.294  14.934  38.063  1.00 21.61           C  
ATOM   1078  O   TYR A 137       0.134  14.846  37.595  1.00 22.26           O  
ATOM   1079  CB  TYR A 137       2.334  13.182  36.557  1.00 21.79           C  
ATOM   1080  CG  TYR A 137       1.243  12.162  36.300  1.00 20.48           C  
ATOM   1081  CD1 TYR A 137       0.050  12.530  35.667  1.00 21.81           C  
ATOM   1082  CD2 TYR A 137       1.409  10.831  36.689  1.00 21.41           C  
ATOM   1083  CE1 TYR A 137      -0.958  11.587  35.432  1.00 20.04           C  
ATOM   1084  CE2 TYR A 137       0.410   9.879  36.458  1.00 20.29           C  
ATOM   1085  CZ  TYR A 137      -0.761  10.269  35.829  1.00 21.56           C  
ATOM   1086  OH  TYR A 137      -1.739   9.330  35.602  1.00 20.65           O  
ATOM   1087  N   VAL A 138       1.754  16.018  38.661  1.00 19.29           N  
ATOM   1088  CA  VAL A 138       0.888  17.117  39.049  1.00 18.21           C  
ATOM   1089  C   VAL A 138       1.048  18.279  38.070  1.00 18.58           C  
ATOM   1090  O   VAL A 138       2.172  18.694  37.768  1.00 17.98           O  
ATOM   1091  CB  VAL A 138       1.236  17.565  40.487  1.00 18.03           C  
ATOM   1092  CG1 VAL A 138       0.457  18.836  40.887  1.00 17.61           C  
ATOM   1093  CG2 VAL A 138       1.016  16.404  41.484  1.00 17.36           C  
ATOM   1094  N   GLN A 139      -0.072  18.789  37.554  1.00 17.96           N  
ATOM   1095  CA  GLN A 139      -0.040  20.009  36.757  1.00 18.13           C  
ATOM   1096  C   GLN A 139      -0.045  21.189  37.709  1.00 18.36           C  
ATOM   1097  O   GLN A 139      -0.829  21.224  38.670  1.00 18.27           O  
ATOM   1098  CB  GLN A 139      -1.216  20.087  35.774  1.00 18.30           C  
ATOM   1099  CG  GLN A 139      -1.085  21.179  34.700  1.00 18.88           C  
ATOM   1100  CD  GLN A 139      -1.394  22.581  35.203  1.00 19.58           C  
ATOM   1101  OE1 GLN A 139      -2.259  22.774  36.073  1.00 20.94           O  
ATOM   1102  NE2 GLN A 139      -0.683  23.574  34.666  1.00 19.71           N  
ATOM   1103  N   HIS A 140       0.855  22.134  37.454  1.00 18.55           N  
ATOM   1104  CA  HIS A 140       0.910  23.373  38.216  1.00 18.85           C  
ATOM   1105  C   HIS A 140       1.369  24.525  37.332  1.00 18.78           C  
ATOM   1106  O   HIS A 140       2.417  24.439  36.687  1.00 18.16           O  
ATOM   1107  CB  HIS A 140       1.818  23.249  39.436  1.00 19.36           C  
ATOM   1108  CG  HIS A 140       1.595  24.330  40.445  1.00 21.18           C  
ATOM   1109  ND1 HIS A 140       2.432  25.419  40.577  1.00 23.72           N  
ATOM   1110  CD2 HIS A 140       0.588  24.520  41.330  1.00 22.91           C  
ATOM   1111  CE1 HIS A 140       1.972  26.207  41.532  1.00 22.50           C  
ATOM   1112  NE2 HIS A 140       0.855  25.685  42.005  1.00 24.70           N  
ATOM   1113  N   ASP A 141       0.568  25.590  37.297  1.00 19.25           N  
ATOM   1114  CA  ASP A 141       0.888  26.780  36.508  1.00 19.73           C  
ATOM   1115  C   ASP A 141       2.131  27.486  37.028  1.00 19.69           C  
ATOM   1116  O   ASP A 141       2.363  27.545  38.244  1.00 19.71           O  
ATOM   1117  CB  ASP A 141      -0.262  27.791  36.556  1.00 20.27           C  
ATOM   1118  CG  ASP A 141      -1.499  27.333  35.809  1.00 21.54           C  
ATOM   1119  OD1 ASP A 141      -1.473  26.307  35.094  1.00 21.29           O  
ATOM   1120  OD2 ASP A 141      -2.527  28.042  35.942  1.00 26.09           O  
ATOM   1121  N   VAL A 142       2.917  28.037  36.106  1.00 19.61           N  
ATOM   1122  CA  VAL A 142       3.997  28.947  36.483  1.00 19.46           C  
ATOM   1123  C   VAL A 142       3.360  30.219  37.060  1.00 19.75           C  
ATOM   1124  O   VAL A 142       2.461  30.803  36.432  1.00 19.35           O  
ATOM   1125  CB  VAL A 142       4.924  29.282  35.280  1.00 19.58           C  
ATOM   1126  CG1 VAL A 142       5.980  30.321  35.669  1.00 20.03           C  
ATOM   1127  CG2 VAL A 142       5.569  28.013  34.715  1.00 20.18           C  
ATOM   1128  N   PRO A 143       3.804  30.650  38.255  1.00 19.93           N  
ATOM   1129  CA  PRO A 143       3.215  31.858  38.846  1.00 20.41           C  
ATOM   1130  C   PRO A 143       3.683  33.114  38.107  1.00 21.21           C  
ATOM   1131  O   PRO A 143       4.763  33.112  37.511  1.00 20.78           O  
ATOM   1132  CB  PRO A 143       3.770  31.844  40.270  1.00 20.45           C  
ATOM   1133  CG  PRO A 143       5.141  31.202  40.107  1.00 20.24           C  
ATOM   1134  CD  PRO A 143       4.874  30.087  39.109  1.00 20.08           C  
ATOM   1135  N   ARG A 144       2.880  34.177  38.146  1.00 21.73           N  
ATOM   1136  CA  ARG A 144       3.287  35.453  37.573  1.00 22.64           C  
ATOM   1137  C   ARG A 144       4.333  36.099  38.480  1.00 22.65           C  
ATOM   1138  O   ARG A 144       4.037  36.463  39.628  1.00 23.46           O  
ATOM   1139  CB  ARG A 144       2.074  36.378  37.369  1.00 23.02           C  
ATOM   1140  CG  ARG A 144       2.408  37.715  36.719  1.00 25.01           C  
ATOM   1141  CD  ARG A 144       2.991  37.536  35.322  1.00 29.05           C  
ATOM   1142  NE  ARG A 144       3.055  38.800  34.590  1.00 31.66           N  
ATOM   1143  CZ  ARG A 144       3.513  38.926  33.349  1.00 33.70           C  
ATOM   1144  NH1 ARG A 144       3.958  37.864  32.687  1.00 35.27           N  
ATOM   1145  NH2 ARG A 144       3.530  40.119  32.768  1.00 35.14           N  
ATOM   1146  N   VAL A 145       5.563  36.192  37.978  1.00 22.47           N  
ATOM   1147  CA  VAL A 145       6.686  36.744  38.743  1.00 22.38           C  
ATOM   1148  C   VAL A 145       7.484  37.706  37.875  1.00 22.67           C  
ATOM   1149  O   VAL A 145       7.859  37.367  36.752  1.00 22.69           O  
ATOM   1150  CB  VAL A 145       7.647  35.623  39.283  1.00 22.30           C  
ATOM   1151  CG1 VAL A 145       8.779  36.237  40.122  1.00 22.37           C  
ATOM   1152  CG2 VAL A 145       6.883  34.589  40.105  1.00 22.33           C  
ATOM   1153  N   LYS A 146       7.731  38.905  38.399  1.00 22.69           N  
ATOM   1154  CA  LYS A 146       8.524  39.912  37.697  1.00 23.03           C  
ATOM   1155  C   LYS A 146       9.864  40.078  38.403  1.00 22.87           C  
ATOM   1156  O   LYS A 146       9.922  40.358  39.608  1.00 24.06           O  
ATOM   1157  CB  LYS A 146       7.759  41.243  37.606  1.00 23.66           C  
ATOM   1158  CG  LYS A 146       6.529  41.150  36.694  0.80 24.31           C  
ATOM   1159  CD  LYS A 146       5.321  41.878  37.269  0.50 26.59           C  
ATOM   1160  CE  LYS A 146       5.277  43.332  36.851  0.50 27.03           C  
ATOM   1161  NZ  LYS A 146       4.157  44.057  37.524  0.50 28.20           N  
ATOM   1162  N   LEU A 147      10.940  39.862  37.654  1.00 22.01           N  
ATOM   1163  CA  LEU A 147      12.294  40.000  38.168  1.00 21.61           C  
ATOM   1164  C   LEU A 147      12.957  41.211  37.539  1.00 22.39           C  
ATOM   1165  O   LEU A 147      12.713  41.521  36.371  1.00 21.90           O  
ATOM   1166  CB  LEU A 147      13.123  38.740  37.854  1.00 20.62           C  
ATOM   1167  CG  LEU A 147      12.548  37.387  38.293  1.00 19.76           C  
ATOM   1168  CD1 LEU A 147      13.357  36.241  37.677  1.00 18.36           C  
ATOM   1169  CD2 LEU A 147      12.489  37.256  39.818  1.00 20.46           C  
ATOM   1170  N   GLY A 148      13.797  41.886  38.316  1.00 23.47           N  
ATOM   1171  CA  GLY A 148      14.619  42.974  37.792  1.00 25.27           C  
ATOM   1172  C   GLY A 148      13.920  44.318  37.857  1.00 26.65           C  
ATOM   1173  O   GLY A 148      12.745  44.397  38.238  1.00 26.98           O  
ATOM   1174  N   GLU A 149      14.662  45.356  37.465  1.00 27.59           N  
ATOM   1175  CA  GLU A 149      14.265  46.768  37.569  0.50 28.61           C  
ATOM   1176  C   GLU A 149      14.117  47.228  39.017  0.50 28.64           C  
ATOM   1177  O   GLU A 149      15.094  47.645  39.643  0.50 28.76           O  
ATOM   1178  CB  GLU A 149      12.999  47.061  36.766  1.00 29.05           C  
ATOM   1179  CG  GLU A 149      13.247  47.300  35.284  1.00 30.82           C  
ATOM   1180  CD  GLU A 149      12.088  48.029  34.615  0.50 32.01           C  
ATOM   1181  OE1 GLU A 149      10.934  47.567  34.745  0.50 32.62           O  
ATOM   1182  OE2 GLU A 149      12.332  49.065  33.961  0.50 32.76           O  
TER    1183      GLU A 149                                                      
END
MOLECULE T0461.pdb
ATOM      1  N   GLU    16      19.319  11.894  58.181  1.00 47.03           N  
ATOM      2  CA  GLU    16      18.212  11.089  57.593  1.00 47.23           C  
ATOM      4  CB  GLU    16      18.010   9.793  58.377  1.00 47.32           C  
ATOM      7  CG  GLU    16      17.576   8.619  57.509  1.00 48.39           C  
ATOM     10  CD  GLU    16      17.064   7.416  58.327  1.00 50.46           C  
ATOM     11  OE1 GLU    16      16.178   6.689  57.811  1.00 51.91           O  
ATOM     12  OE2 GLU    16      17.526   7.196  59.479  1.00 50.93           O  
ATOM     13  C   GLU    16      16.896  11.864  57.561  1.00 47.09           C  
ATOM     14  O   GLU    16      15.891  11.376  57.001  1.00 48.08           O  
ATOM     18  N   ASN    17      16.888  13.066  58.143  1.00 46.06           N  
ATOM     19  CA  ASN    17      15.679  13.870  58.188  1.00 45.28           C  
ATOM     21  CB  ASN    17      15.631  14.676  59.487  1.00 45.17           C  
ATOM     24  CG  ASN    17      14.246  15.250  59.773  1.00 44.92           C  
ATOM     25  OD1 ASN    17      13.421  15.378  58.885  1.00 45.51           O  
ATOM     26  ND2 ASN    17      13.989  15.591  61.023  1.00 45.12           N  
ATOM     29  C   ASN    17      15.619  14.792  56.990  1.00 44.97           C  
ATOM     30  O   ASN    17      16.071  15.922  57.046  1.00 44.78           O  
ATOM     32  N   LEU    18      15.026  14.320  55.910  1.00 45.02           N  
ATOM     33  CA  LEU    18      14.988  15.101  54.659  1.00 45.41           C  
ATOM     35  CB  LEU    18      14.792  14.167  53.453  1.00 45.35           C  
ATOM     38  CG  LEU    18      15.875  13.083  53.322  1.00 45.26           C  
ATOM     40  CD1 LEU    18      15.492  12.097  52.210  1.00 45.69           C  
ATOM     44  CD2 LEU    18      17.267  13.703  53.084  1.00 42.76           C  
ATOM     48  C   LEU    18      13.920  16.202  54.656  1.00 45.40           C  
ATOM     49  O   LEU    18      12.854  16.047  55.244  1.00 46.03           O  
ATOM     51  N   TYR    19      14.208  17.291  53.954  1.00 45.10           N  
ATOM     52  CA  TYR    19      13.361  18.473  53.903  1.00 44.79           C  
ATOM     54  CB  TYR    19      14.284  19.669  53.829  1.00 45.04           C  
ATOM     57  CG  TYR    19      13.663  21.040  53.814  1.00 45.91           C  
ATOM     58  CD1 TYR    19      13.769  21.878  54.930  1.00 46.50           C  
ATOM     60  CE1 TYR    19      13.223  23.142  54.930  1.00 46.23           C  
ATOM     62  CZ  TYR    19      12.595  23.603  53.806  1.00 45.82           C  
ATOM     63  OH  TYR    19      12.078  24.858  53.838  1.00 47.34           O  
ATOM     65  CE2 TYR    19      12.478  22.813  52.668  1.00 46.79           C  
ATOM     67  CD2 TYR    19      13.017  21.538  52.672  1.00 46.25           C  
ATOM     69  C   TYR    19      12.486  18.434  52.655  1.00 45.02           C  
ATOM     70  O   TYR    19      12.973  18.134  51.545  1.00 44.56           O  
ATOM     72  N   PHE    20      11.200  18.768  52.836  1.00 45.35           N  
ATOM     73  CA  PHE    20      10.180  18.735  51.761  1.00 44.99           C  
ATOM     75  CB  PHE    20       8.875  18.070  52.229  1.00 44.60           C  
ATOM     78  CG  PHE    20       8.967  16.583  52.430  1.00 44.31           C  
ATOM     79  CD1 PHE    20       8.814  16.023  53.683  1.00 45.43           C  
ATOM     81  CE1 PHE    20       8.871  14.634  53.877  1.00 44.99           C  
ATOM     83  CZ  PHE    20       9.077  13.820  52.843  1.00 43.54           C  
ATOM     85  CE2 PHE    20       9.199  14.351  51.588  1.00 44.96           C  
ATOM     87  CD2 PHE    20       9.152  15.735  51.379  1.00 44.56           C  
ATOM     89  C   PHE    20       9.859  20.151  51.339  1.00 44.84           C  
ATOM     90  O   PHE    20       9.575  20.984  52.162  1.00 45.26           O  
ATOM     92  N   GLN    21       9.875  20.414  50.048  1.00 45.39           N  
ATOM     93  CA  GLN    21       9.553  21.743  49.542  1.00 45.85           C  
ATOM     95  CB  GLN    21       9.966  21.882  48.065  1.00 46.10           C  
ATOM     98  CG  GLN    21      11.462  21.638  47.776  1.00 45.85           C  
ATOM    101  CD  GLN    21      12.355  22.618  48.495  1.00 46.50           C  
ATOM    102  OE1 GLN    21      12.212  23.845  48.353  1.00 47.26           O  
ATOM    103  NE2 GLN    21      13.273  22.092  49.288  1.00 45.90           N  
ATOM    106  C   GLN    21       8.049  22.035  49.714  1.00 46.07           C  
ATOM    107  O   GLN    21       7.198  21.166  49.469  1.00 45.86           O  
ATOM    109  N   SER    22       7.741  23.259  50.150  1.00 45.86           N  
ATOM    110  CA  SER    22       6.375  23.680  50.384  1.00 45.60           C  
ATOM    112  CB  SER    22       6.366  24.830  51.367  1.00 45.59           C  
ATOM    115  OG  SER    22       6.782  26.037  50.750  1.00 46.30           O  
ATOM    117  C   SER    22       5.742  24.134  49.088  1.00 45.80           C  
ATOM    118  O   SER    22       6.407  24.114  48.046  1.00 45.84           O  
ATOM    120  N   MET    23       4.473  24.560  49.153  1.00 46.02           N  
ATOM    121  CA  MET    23       3.772  25.115  47.983  1.00 46.05           C  
ATOM    123  CB  MET    23       2.313  25.460  48.298  1.00 46.56           C  
ATOM    126  CG  MET    23       1.275  24.330  48.059  1.00 48.82           C  
ATOM    129  SD  MET    23       1.254  23.496  46.412  1.00 52.49           S  
ATOM    130  CE  MET    23      -0.396  22.776  46.537  1.00 50.38           C  
ATOM    134  C   MET    23       4.432  26.367  47.439  1.00 45.55           C  
ATOM    135  O   MET    23       4.601  26.477  46.236  1.00 45.57           O  
ATOM    137  N   GLU    24       4.773  27.312  48.309  1.00 45.12           N  
ATOM    138  CA  GLU    24       5.405  28.529  47.862  1.00 45.24           C  
ATOM    140  CB  GLU    24       5.574  29.505  49.001  1.00 45.00           C  
ATOM    143  CG  GLU    24       4.249  30.004  49.540  1.00 45.52           C  
ATOM    146  CD  GLU    24       4.420  31.305  50.323  1.00 47.26           C  
ATOM    147  OE1 GLU    24       5.446  31.973  50.070  1.00 48.66           O  
ATOM    148  OE2 GLU    24       3.543  31.676  51.171  1.00 46.60           O  
ATOM    149  C   GLU    24       6.756  28.195  47.248  1.00 45.58           C  
ATOM    150  O   GLU    24       7.118  28.700  46.165  1.00 45.97           O  
ATOM    152  N   GLU    25       7.499  27.321  47.916  1.00 45.42           N  
ATOM    153  CA  GLU    25       8.791  26.893  47.383  1.00 45.38           C  
ATOM    155  CB  GLU    25       9.527  26.016  48.395  1.00 45.48           C  
ATOM    158  CG  GLU    25       9.801  26.759  49.699  1.00 46.23           C  
ATOM    161  CD  GLU    25      10.373  25.873  50.810  1.00 47.64           C  
ATOM    162  OE1 GLU    25       9.890  24.719  51.016  1.00 46.52           O  
ATOM    163  OE2 GLU    25      11.298  26.364  51.498  1.00 48.29           O  
ATOM    164  C   GLU    25       8.695  26.205  46.022  1.00 44.72           C  
ATOM    165  O   GLU    25       9.574  26.385  45.200  1.00 44.67           O  
ATOM    167  N   THR    26       7.633  25.425  45.805  1.00 44.33           N  
ATOM    168  CA  THR    26       7.333  24.809  44.497  1.00 43.62           C  
ATOM    170  CB  THR    26       6.097  23.810  44.583  1.00 43.61           C  
ATOM    172  OG1 THR    26       6.387  22.773  45.511  1.00 42.09           O  
ATOM    174  CG2 THR    26       5.748  23.157  43.247  1.00 42.42           C  
ATOM    178  C   THR    26       7.092  25.942  43.492  1.00 43.04           C  
ATOM    179  O   THR    26       7.712  25.993  42.437  1.00 42.50           O  
ATOM    181  N   GLU    27       6.220  26.875  43.843  1.00 42.37           N  
ATOM    182  CA  GLU    27       5.971  28.002  42.978  1.00 42.31           C  
ATOM    184  CB  GLU    27       5.035  29.005  43.622  1.00 42.84           C  
ATOM    187  CG  GLU    27       3.580  28.566  43.707  1.00 44.60           C  
ATOM    190  CD  GLU    27       2.700  29.690  44.267  1.00 47.31           C  
ATOM    191  OE1 GLU    27       3.193  30.857  44.272  1.00 48.72           O  
ATOM    192  OE2 GLU    27       1.529  29.432  44.703  1.00 48.41           O  
ATOM    193  C   GLU    27       7.270  28.692  42.631  1.00 40.95           C  
ATOM    194  O   GLU    27       7.497  29.041  41.480  1.00 41.59           O  
ATOM    196  N   LYS    28       8.126  28.886  43.622  1.00 39.03           N  
ATOM    197  CA  LYS    28       9.440  29.455  43.359  1.00 37.62           C  
ATOM    199  CB  LYS    28      10.250  29.534  44.641  1.00 37.50           C  
ATOM    202  CG  LYS    28      11.590  30.230  44.447  1.00 38.41           C  
ATOM    205  CD  LYS    28      12.753  29.466  45.069  1.00 39.23           C  
ATOM    208  CE  LYS    28      12.679  29.456  46.565  1.00 38.91           C  
ATOM    211  NZ  LYS    28      13.578  28.418  47.073  1.00 40.24           N  
ATOM    215  C   LYS    28      10.246  28.672  42.302  1.00 35.90           C  
ATOM    216  O   LYS    28      10.746  29.267  41.371  1.00 36.93           O  
ATOM    218  N   TRP    29      10.371  27.357  42.443  1.00 33.27           N  
ATOM    219  CA  TRP    29      11.165  26.570  41.498  1.00 31.54           C  
ATOM    221  CB  TRP    29      11.338  25.115  41.957  1.00 30.99           C  
ATOM    224  CG  TRP    29      11.998  24.926  43.278  1.00 30.44           C  
ATOM    225  CD1 TRP    29      11.570  24.110  44.281  1.00 30.13           C  
ATOM    227  NE1 TRP    29      12.435  24.175  45.351  1.00 30.02           N  
ATOM    229  CE2 TRP    29      13.444  25.050  45.056  1.00 29.08           C  
ATOM    230  CD2 TRP    29      13.206  25.551  43.764  1.00 29.84           C  
ATOM    231  CE3 TRP    29      14.106  26.479  43.230  1.00 30.17           C  
ATOM    233  CZ3 TRP    29      15.182  26.878  43.993  1.00 29.10           C  
ATOM    235  CH2 TRP    29      15.381  26.365  45.270  1.00 28.82           C  
ATOM    237  CZ2 TRP    29      14.522  25.453  45.820  1.00 28.69           C  
ATOM    239  C   TRP    29      10.577  26.553  40.093  1.00 30.66           C  
ATOM    240  O   TRP    29      11.321  26.503  39.114  1.00 30.04           O  
ATOM    242  N   MET    30       9.250  26.560  39.994  1.00 29.83           N  
ATOM    243  CA  MET    30       8.583  26.606  38.693  1.00 29.32           C  
ATOM    245  CB  MET    30       7.080  26.363  38.827  1.00 29.13           C  
ATOM    248  CG  MET    30       6.695  24.908  39.105  1.00 28.73           C  
ATOM    251  SD  MET    30       7.113  23.702  37.840  1.00 25.62           S  
ATOM    252  CE  MET    30       6.050  24.188  36.496  1.00 25.40           C  
ATOM    256  C   MET    30       8.816  27.922  37.964  1.00 28.82           C  
ATOM    257  O   MET    30       8.940  27.927  36.765  1.00 28.66           O  
ATOM    259  N   GLU    31       8.873  29.027  38.689  1.00 28.72           N  
ATOM    260  CA  GLU    31       9.214  30.321  38.090  1.00 29.06           C  
ATOM    262  CB  GLU    31       9.174  31.465  39.137  1.00 29.45           C  
ATOM    265  CG  GLU    31       7.991  32.434  39.044  1.00 29.57           C  
ATOM    268  CD  GLU    31       7.831  33.294  40.339  1.00 33.21           C  
ATOM    269  OE1 GLU    31       7.467  34.564  40.270  1.00 32.31           O  
ATOM    270  OE2 GLU    31       8.075  32.684  41.452  1.00 35.33           O  
ATOM    271  C   GLU    31      10.604  30.262  37.479  1.00 28.87           C  
ATOM    272  O   GLU    31      10.827  30.752  36.382  1.00 28.74           O  
ATOM    274  N   GLU    32      11.544  29.670  38.205  1.00 28.87           N  
ATOM    275  CA  GLU    32      12.909  29.533  37.701  1.00 29.07           C  
ATOM    277  CB  GLU    32      13.876  29.003  38.777  1.00 29.29           C  
ATOM    280  CG  GLU    32      15.319  29.531  38.660  1.00 30.35           C  
ATOM    283  CD  GLU    32      16.038  29.670  40.034  1.00 32.92           C  
ATOM    284  OE1 GLU    32      16.446  28.584  40.580  1.00 33.02           O  
ATOM    285  OE2 GLU    32      16.223  30.868  40.532  1.00 32.31           O  
ATOM    286  C   GLU    32      12.932  28.636  36.474  1.00 29.00           C  
ATOM    287  O   GLU    32      13.630  28.954  35.536  1.00 29.87           O  
ATOM    289  N   ALA    33      12.176  27.534  36.469  1.00 28.65           N  
ATOM    290  CA  ALA    33      12.074  26.677  35.272  1.00 28.41           C  
ATOM    292  CB  ALA    33      11.272  25.376  35.580  1.00 28.13           C  
ATOM    296  C   ALA    33      11.467  27.433  34.073  1.00 27.98           C  
ATOM    297  O   ALA    33      11.779  27.140  32.919  1.00 27.17           O  
ATOM    299  N   MET    34      10.613  28.412  34.367  1.00 27.93           N  
ATOM    300  CA  MET    34       9.948  29.219  33.339  1.00 28.14           C  
ATOM    302  CB  MET    34       8.803  30.030  33.949  1.00 28.21           C  
ATOM    305  CG  MET    34       7.517  29.250  34.113  1.00 28.80           C  
ATOM    308  SD  MET    34       6.705  28.872  32.536  1.00 30.50           S  
ATOM    309  CE  MET    34       6.132  30.522  32.012  1.00 29.12           C  
ATOM    313  C   MET    34      10.916  30.175  32.664  1.00 28.10           C  
ATOM    314  O   MET    34      10.875  30.374  31.449  1.00 27.67           O  
ATOM    316  N   HIS    35      11.789  30.765  33.467  1.00 28.28           N  
ATOM    317  CA  HIS    35      12.821  31.630  32.951  1.00 28.33           C  
ATOM    319  CB  HIS    35      13.581  32.265  34.112  1.00 28.41           C  
ATOM    322  CG  HIS    35      12.858  33.425  34.730  1.00 29.93           C  
ATOM    323  ND1 HIS    35      11.876  34.132  34.062  1.00 31.57           N  
ATOM    325  CE1 HIS    35      11.437  35.118  34.832  1.00 31.30           C  
ATOM    327  NE2 HIS    35      12.092  35.071  35.978  1.00 31.32           N  
ATOM    329  CD2 HIS    35      12.985  34.021  35.943  1.00 31.00           C  
ATOM    331  C   HIS    35      13.742  30.839  32.027  1.00 28.17           C  
ATOM    332  O   HIS    35      14.065  31.289  30.934  1.00 27.82           O  
ATOM    334  N   MET    36      14.123  29.641  32.458  1.00 28.15           N  
ATOM    335  CA  MET    36      14.961  28.760  31.661  1.00 28.40           C  
ATOM    337  CB  MET    36      15.322  27.506  32.450  1.00 28.40           C  
ATOM    340  CG  MET    36      16.315  27.796  33.560  1.00 29.25           C  
ATOM    343  SD  MET    36      16.813  26.309  34.428  1.00 31.57           S  
ATOM    344  CE  MET    36      18.067  25.576  33.340  1.00 32.53           C  
ATOM    348  C   MET    36      14.308  28.388  30.336  1.00 28.59           C  
ATOM    349  O   MET    36      14.979  28.316  29.303  1.00 28.44           O  
ATOM    351  N   ALA    37      12.999  28.161  30.359  1.00 28.78           N  
ATOM    352  CA  ALA    37      12.272  27.908  29.139  1.00 28.45           C  
ATOM    354  CB  ALA    37      10.865  27.523  29.464  1.00 28.21           C  
ATOM    358  C   ALA    37      12.350  29.138  28.203  1.00 28.53           C  
ATOM    359  O   ALA    37      12.535  28.976  26.991  1.00 28.74           O  
ATOM    361  N   LYS    38      12.254  30.353  28.753  1.00 28.46           N  
ATOM    362  CA  LYS    38      12.479  31.585  27.952  1.00 28.77           C  
ATOM    364  CB  LYS    38      12.362  32.855  28.810  1.00 28.84           C  
ATOM    367  CG  LYS    38      11.173  33.763  28.490  1.00 29.78           C  
ATOM    370  CD  LYS    38      10.670  34.538  29.775  1.00 31.42           C  
ATOM    373  CE  LYS    38       9.790  33.635  30.740  1.00 31.00           C  
ATOM    376  NZ  LYS    38       9.628  34.146  32.144  1.00 30.04           N  
ATOM    380  C   LYS    38      13.844  31.602  27.254  1.00 28.67           C  
ATOM    381  O   LYS    38      13.935  31.826  26.059  1.00 28.60           O  
ATOM    383  N   GLU    39      14.903  31.388  28.029  1.00 28.92           N  
ATOM    384  CA  GLU    39      16.255  31.241  27.491  1.00 29.07           C  
ATOM    386  CB  GLU    39      17.256  30.896  28.615  1.00 29.32           C  
ATOM    389  CG  GLU    39      17.683  32.092  29.525  1.00 29.97           C  
ATOM    392  CD  GLU    39      18.618  31.675  30.698  1.00 30.95           C  
ATOM    393  OE1 GLU    39      18.395  30.602  31.336  1.00 31.36           O  
ATOM    394  OE2 GLU    39      19.579  32.435  30.976  1.00 30.64           O  
ATOM    395  C   GLU    39      16.323  30.161  26.391  1.00 29.31           C  
ATOM    396  O   GLU    39      16.994  30.352  25.385  1.00 29.93           O  
ATOM    398  N   ALA    40      15.655  29.025  26.568  1.00 29.26           N  
ATOM    399  CA  ALA    40      15.675  27.990  25.538  1.00 29.14           C  
ATOM    401  CB  ALA    40      14.954  26.733  26.023  1.00 29.09           C  
ATOM    405  C   ALA    40      15.052  28.523  24.233  1.00 29.31           C  
ATOM    406  O   ALA    40      15.647  28.416  23.135  1.00 29.24           O  
ATOM    408  N   LEU    41      13.866  29.115  24.357  1.00 29.40           N  
ATOM    409  CA  LEU    41      13.176  29.725  23.208  1.00 29.34           C  
ATOM    411  CB  LEU    41      12.006  30.573  23.716  1.00 29.30           C  
ATOM    414  CG  LEU    41      11.070  31.167  22.677  1.00 28.71           C  
ATOM    416  CD1 LEU    41      10.148  30.062  22.197  1.00 28.68           C  
ATOM    420  CD2 LEU    41      10.302  32.340  23.267  1.00 27.42           C  
ATOM    424  C   LEU    41      14.117  30.616  22.372  1.00 29.48           C  
ATOM    425  O   LEU    41      14.211  30.475  21.134  1.00 29.85           O  
ATOM    427  N   GLU    42      14.821  31.511  23.067  1.00 29.00           N  
ATOM    428  CA  GLU    42      15.649  32.517  22.438  1.00 28.74           C  
ATOM    430  CB  GLU    42      15.908  33.598  23.449  1.00 28.67           C  
ATOM    433  CG  GLU    42      14.645  34.363  23.746  1.00 29.55           C  
ATOM    436  CD  GLU    42      14.781  35.250  24.971  1.00 31.30           C  
ATOM    437  OE1 GLU    42      15.008  34.664  26.080  1.00 30.85           O  
ATOM    438  OE2 GLU    42      14.659  36.515  24.804  1.00 30.70           O  
ATOM    439  C   GLU    42      16.957  31.966  21.908  1.00 28.87           C  
ATOM    440  O   GLU    42      17.677  32.661  21.201  1.00 28.72           O  
ATOM    442  N   ASN    43      17.266  30.718  22.268  1.00 29.31           N  
ATOM    443  CA  ASN    43      18.369  29.949  21.660  1.00 29.26           C  
ATOM    445  CB  ASN    43      19.164  29.173  22.728  1.00 29.03           C  
ATOM    448  CG  ASN    43      19.818  30.083  23.766  1.00 29.03           C  
ATOM    449  OD1 ASN    43      20.204  31.217  23.469  1.00 28.55           O  
ATOM    450  ND2 ASN    43      19.954  29.576  24.993  1.00 28.89           N  
ATOM    453  C   ASN    43      17.872  28.958  20.602  1.00 29.20           C  
ATOM    454  O   ASN    43      18.569  27.989  20.314  1.00 29.62           O  
ATOM    456  N   THR    44      16.686  29.195  20.033  1.00 28.87           N  
ATOM    457  CA  THR    44      16.102  28.289  19.041  1.00 28.84           C  
ATOM    459  CB  THR    44      16.897  28.318  17.748  1.00 28.74           C  
ATOM    461  OG1 THR    44      17.471  29.619  17.586  1.00 29.50           O  
ATOM    463  CG2 THR    44      15.986  27.971  16.552  1.00 28.77           C  
ATOM    467  C   THR    44      16.009  26.828  19.506  1.00 28.90           C  
ATOM    468  O   THR    44      16.232  25.893  18.716  1.00 28.57           O  
ATOM    470  N   GLU    45      15.692  26.641  20.789  1.00 28.78           N  
ATOM    471  CA  GLU    45      15.473  25.302  21.339  1.00 28.92           C  
ATOM    473  CB  GLU    45      16.415  25.012  22.521  1.00 28.92           C  
ATOM    476  CG  GLU    45      17.931  25.000  22.196  1.00 29.45           C  
ATOM    479  CD  GLU    45      18.448  23.676  21.635  1.00 29.36           C  
ATOM    480  OE1 GLU    45      19.688  23.562  21.442  1.00 27.01           O  
ATOM    481  OE2 GLU    45      17.612  22.771  21.370  1.00 30.17           O  
ATOM    482  C   GLU    45      14.006  25.190  21.777  1.00 28.65           C  
ATOM    483  O   GLU    45      13.339  26.213  22.050  1.00 29.00           O  
ATOM    485  N   VAL    46      13.501  23.955  21.814  1.00 27.84           N  
ATOM    486  CA  VAL    46      12.162  23.715  22.317  1.00 27.20           C  
ATOM    488  CB  VAL    46      11.844  22.202  22.430  1.00 27.04           C  
ATOM    490  CG1 VAL    46      10.470  22.021  22.949  1.00 26.48           C  
ATOM    494  CG2 VAL    46      11.994  21.495  21.085  1.00 25.84           C  
ATOM    498  C   VAL    46      12.218  24.332  23.700  1.00 26.94           C  
ATOM    499  O   VAL    46      13.138  24.032  24.430  1.00 27.21           O  
ATOM    501  N   PRO    47      11.286  25.236  24.048  1.00 26.78           N  
ATOM    502  CA  PRO    47      11.296  25.903  25.373  1.00 26.70           C  
ATOM    504  CB  PRO    47      10.367  27.113  25.179  1.00 26.66           C  
ATOM    507  CG  PRO    47       9.422  26.670  24.121  1.00 27.05           C  
ATOM    510  CD  PRO    47      10.184  25.723  23.207  1.00 26.93           C  
ATOM    513  C   PRO    47      10.822  25.037  26.522  1.00 26.24           C  
ATOM    514  O   PRO    47       9.673  25.088  26.918  1.00 26.00           O  
ATOM    515  N   VAL    48      11.735  24.233  27.027  1.00 26.62           N  
ATOM    516  CA  VAL    48      11.513  23.417  28.200  1.00 27.16           C  
ATOM    518  CB  VAL    48      11.457  21.880  27.852  1.00 27.41           C  
ATOM    520  CG1 VAL    48      11.253  21.035  29.132  1.00 26.53           C  
ATOM    524  CG2 VAL    48      10.393  21.571  26.783  1.00 25.65           C  
ATOM    528  C   VAL    48      12.716  23.717  29.106  1.00 27.85           C  
ATOM    529  O   VAL    48      13.887  23.614  28.672  1.00 28.19           O  
ATOM    531  N   GLY    49      12.435  24.143  30.334  1.00 27.89           N  
ATOM    532  CA  GLY    49      13.460  24.283  31.361  1.00 27.79           C  
ATOM    535  C   GLY    49      13.077  23.403  32.544  1.00 27.95           C  
ATOM    536  O   GLY    49      11.895  23.182  32.778  1.00 28.14           O  
ATOM    538  N   CYS    50      14.052  22.876  33.284  1.00 27.93           N  
ATOM    539  CA  CYS    50      13.715  22.173  34.504  1.00 28.84           C  
ATOM    541  CB  CYS    50      13.297  20.749  34.174  1.00 28.84           C  
ATOM    544  SG  CYS    50      14.643  19.606  34.018  1.00 33.39           S  
ATOM    546  C   CYS    50      14.794  22.187  35.602  1.00 28.72           C  
ATOM    547  O   CYS    50      15.972  22.404  35.318  1.00 28.99           O  
ATOM    549  N   LEU    51      14.348  21.985  36.849  1.00 28.66           N  
ATOM    550  CA  LEU    51      15.194  21.936  38.050  1.00 28.44           C  
ATOM    552  CB  LEU    51      14.880  23.128  38.954  1.00 28.29           C  
ATOM    555  CG  LEU    51      15.232  24.521  38.431  1.00 28.29           C  
ATOM    557  CD1 LEU    51      14.136  25.489  38.675  1.00 29.32           C  
ATOM    561  CD2 LEU    51      16.480  25.050  39.095  1.00 30.45           C  
ATOM    565  C   LEU    51      14.956  20.617  38.827  1.00 28.35           C  
ATOM    566  O   LEU    51      13.876  20.048  38.798  1.00 28.95           O  
ATOM    568  N   MET    52      15.958  20.126  39.526  1.00 27.97           N  
ATOM    569  CA  MET    52      15.745  19.011  40.400  1.00 28.22           C  
ATOM    571  CB  MET    52      16.413  17.765  39.825  1.00 28.57           C  
ATOM    574  CG  MET    52      15.607  17.113  38.742  1.00 29.75           C  
ATOM    577  SD  MET    52      16.528  15.808  37.882  1.00 30.98           S  
ATOM    578  CE  MET    52      16.168  14.414  38.917  1.00 33.55           C  
ATOM    582  C   MET    52      16.255  19.354  41.807  1.00 28.12           C  
ATOM    583  O   MET    52      17.427  19.709  42.002  1.00 27.75           O  
ATOM    585  N   VAL    53      15.354  19.242  42.781  1.00 27.75           N  
ATOM    586  CA  VAL    53      15.642  19.628  44.149  1.00 27.86           C  
ATOM    588  CB  VAL    53      14.603  20.664  44.634  1.00 27.43           C  
ATOM    590  CG1 VAL    53      14.756  20.937  46.109  1.00 27.32           C  
ATOM    594  CG2 VAL    53      14.729  21.953  43.833  1.00 27.25           C  
ATOM    598  C   VAL    53      15.710  18.395  45.089  1.00 28.27           C  
ATOM    599  O   VAL    53      14.819  17.559  45.116  1.00 28.02           O  
ATOM    601  N   TYR    54      16.790  18.308  45.863  1.00 28.71           N  
ATOM    602  CA  TYR    54      16.978  17.239  46.855  1.00 28.55           C  
ATOM    604  CB  TYR    54      18.085  16.279  46.430  1.00 28.75           C  
ATOM    607  CG  TYR    54      18.551  15.359  47.499  1.00 27.40           C  
ATOM    608  CD1 TYR    54      17.820  14.230  47.830  1.00 28.08           C  
ATOM    610  CE1 TYR    54      18.244  13.355  48.820  1.00 28.43           C  
ATOM    612  CZ  TYR    54      19.430  13.620  49.480  1.00 29.94           C  
ATOM    613  OH  TYR    54      19.905  12.759  50.454  1.00 32.14           O  
ATOM    615  CE2 TYR    54      20.192  14.739  49.135  1.00 29.42           C  
ATOM    617  CD2 TYR    54      19.745  15.591  48.148  1.00 27.87           C  
ATOM    619  C   TYR    54      17.366  17.869  48.152  1.00 28.27           C  
ATOM    620  O   TYR    54      18.279  18.662  48.173  1.00 28.82           O  
ATOM    622  N   ASN    55      16.677  17.488  49.221  1.00 28.12           N  
ATOM    623  CA  ASN    55      16.918  18.006  50.563  1.00 28.03           C  
ATOM    625  CB  ASN    55      18.059  17.234  51.242  1.00 28.30           C  
ATOM    628  CG  ASN    55      18.050  17.374  52.753  1.00 28.25           C  
ATOM    629  OD1 ASN    55      17.015  17.664  53.345  1.00 27.11           O  
ATOM    630  ND2 ASN    55      19.190  17.134  53.381  1.00 25.68           N  
ATOM    633  C   ASN    55      17.189  19.501  50.573  1.00 27.90           C  
ATOM    634  O   ASN    55      18.159  19.980  51.170  1.00 27.64           O  
ATOM    636  N   ASN    56      16.320  20.224  49.887  1.00 27.79           N  
ATOM    637  CA  ASN    56      16.363  21.691  49.865  1.00 28.13           C  
ATOM    639  CB  ASN    56      16.324  22.254  51.279  1.00 28.01           C  
ATOM    642  CG  ASN    56      15.882  23.683  51.311  1.00 27.94           C  
ATOM    643  OD1 ASN    56      15.237  24.172  50.381  1.00 31.08           O  
ATOM    644  ND2 ASN    56      16.215  24.367  52.378  1.00 27.46           N  
ATOM    647  C   ASN    56      17.533  22.307  49.134  1.00 27.87           C  
ATOM    648  O   ASN    56      17.908  23.425  49.409  1.00 28.32           O  
ATOM    650  N   GLU    57      18.082  21.574  48.183  1.00 27.86           N  
ATOM    651  CA  GLU    57      19.217  22.024  47.409  1.00 27.68           C  
ATOM    653  CB  GLU    57      20.472  21.281  47.847  1.00 27.08           C  
ATOM    656  CG  GLU    57      21.672  21.541  46.962  1.00 28.55           C  
ATOM    659  CD  GLU    57      23.044  21.418  47.718  1.00 30.79           C  
ATOM    660  OE1 GLU    57      24.101  21.861  47.139  1.00 30.38           O  
ATOM    661  OE2 GLU    57      23.061  20.888  48.874  1.00 30.25           O  
ATOM    662  C   GLU    57      18.879  21.798  45.937  1.00 27.63           C  
ATOM    663  O   GLU    57      18.169  20.830  45.585  1.00 27.10           O  
ATOM    665  N   VAL    58      19.321  22.734  45.093  1.00 27.91           N  
ATOM    666  CA  VAL    58      19.139  22.617  43.654  1.00 27.84           C  
ATOM    668  CB  VAL    58      19.194  23.956  42.914  1.00 27.95           C  
ATOM    670  CG1 VAL    58      19.081  23.684  41.414  1.00 27.53           C  
ATOM    674  CG2 VAL    58      18.097  24.893  43.401  1.00 27.26           C  
ATOM    678  C   VAL    58      20.250  21.735  43.142  1.00 27.85           C  
ATOM    679  O   VAL    58      21.372  22.153  42.975  1.00 27.19           O  
ATOM    681  N   VAL    59      19.894  20.494  42.876  1.00 28.57           N  
ATOM    682  CA  VAL    59      20.856  19.448  42.563  1.00 28.61           C  
ATOM    684  CB  VAL    59      20.415  18.170  43.356  1.00 28.52           C  
ATOM    686  CG1 VAL    59      19.333  17.410  42.623  1.00 27.61           C  
ATOM    690  CG2 VAL    59      21.584  17.307  43.628  1.00 30.18           C  
ATOM    694  C   VAL    59      21.022  19.190  41.019  1.00 28.74           C  
ATOM    695  O   VAL    59      21.896  18.437  40.605  1.00 28.89           O  
ATOM    697  N   GLY    60      20.192  19.812  40.180  1.00 28.38           N  
ATOM    698  CA  GLY    60      20.330  19.712  38.737  1.00 28.23           C  
ATOM    701  C   GLY    60      19.404  20.682  38.007  1.00 28.41           C  
ATOM    702  O   GLY    60      18.276  20.866  38.404  1.00 28.63           O  
ATOM    704  N   LYS    61      19.916  21.324  36.960  1.00 28.65           N  
ATOM    705  CA  LYS    61      19.168  22.227  36.093  1.00 28.54           C  
ATOM    707  CB  LYS    61      19.780  23.640  36.140  1.00 28.95           C  
ATOM    710  CG  LYS    61      19.463  24.488  37.367  1.00 28.34           C  
ATOM    713  CD  LYS    61      20.179  25.840  37.225  1.00 29.50           C  
ATOM    716  CE  LYS    61      20.207  26.654  38.541  1.00 30.91           C  
ATOM    719  NZ  LYS    61      18.964  27.499  38.849  1.00 30.87           N  
ATOM    723  C   LYS    61      19.282  21.710  34.650  1.00 28.73           C  
ATOM    724  O   LYS    61      20.198  20.928  34.303  1.00 28.29           O  
ATOM    726  N   GLY    62      18.379  22.158  33.784  1.00 28.67           N  
ATOM    727  CA  GLY    62      18.523  21.784  32.389  1.00 28.85           C  
ATOM    730  C   GLY    62      17.522  22.399  31.467  1.00 28.68           C  
ATOM    731  O   GLY    62      16.377  22.533  31.822  1.00 29.05           O  
ATOM    733  N   ARG    63      17.983  22.761  30.279  1.00 28.89           N  
ATOM    734  CA  ARG    63      17.144  23.177  29.179  1.00 28.89           C  
ATOM    736  CB  ARG    63      17.613  24.542  28.668  1.00 29.02           C  
ATOM    739  CG  ARG    63      17.129  25.716  29.490  1.00 29.86           C  
ATOM    742  CD  ARG    63      18.067  26.929  29.395  1.00 30.14           C  
ATOM    745  NE  ARG    63      19.316  26.658  30.105  1.00 31.33           N  
ATOM    747  CZ  ARG    63      20.264  27.559  30.367  1.00 31.77           C  
ATOM    748  NH1 ARG    63      20.100  28.830  29.992  1.00 31.57           N  
ATOM    751  NH2 ARG    63      21.380  27.181  31.007  1.00 30.99           N  
ATOM    754  C   ARG    63      17.358  22.195  28.056  1.00 29.11           C  
ATOM    755  O   ARG    63      18.388  21.496  28.019  1.00 29.15           O  
ATOM    757  N   ASN    64      16.420  22.169  27.108  1.00 29.06           N  
ATOM    758  CA  ASN    64      16.671  21.481  25.849  1.00 28.97           C  
ATOM    760  CB  ASN    64      15.497  21.629  24.909  1.00 29.21           C  
ATOM    763  CG  ASN    64      14.555  20.442  24.966  1.00 30.76           C  
ATOM    764  OD1 ASN    64      14.095  20.021  26.061  1.00 31.58           O  
ATOM    765  ND2 ASN    64      14.238  19.899  23.783  1.00 30.37           N  
ATOM    768  C   ASN    64      17.914  22.003  25.151  1.00 28.78           C  
ATOM    769  O   ASN    64      18.100  23.209  25.044  1.00 28.39           O  
ATOM    771  N   GLU    65      18.741  21.063  24.683  1.00 28.83           N  
ATOM    772  CA  GLU    65      19.991  21.336  23.956  1.00 28.70           C  
ATOM    774  CB  GLU    65      21.208  20.948  24.811  1.00 28.43           C  
ATOM    777  CG  GLU    65      21.363  21.803  26.060  1.00 29.26           C  
ATOM    780  CD  GLU    65      22.567  21.420  26.935  1.00 31.11           C  
ATOM    781  OE1 GLU    65      23.208  20.350  26.722  1.00 32.83           O  
ATOM    782  OE2 GLU    65      22.862  22.193  27.874  1.00 32.15           O  
ATOM    783  C   GLU    65      20.053  20.599  22.593  1.00 28.61           C  
ATOM    784  O   GLU    65      21.143  20.477  22.010  1.00 28.58           O  
ATOM    786  N   VAL    66      18.896  20.169  22.062  1.00 27.88           N  
ATOM    787  CA  VAL    66      18.886  19.316  20.880  1.00 27.67           C  
ATOM    789  CB  VAL    66      17.459  18.841  20.468  1.00 27.53           C  
ATOM    791  CG1 VAL    66      17.529  18.039  19.197  1.00 26.83           C  
ATOM    795  CG2 VAL    66      16.898  17.936  21.521  1.00 26.62           C  
ATOM    799  C   VAL    66      19.638  19.911  19.702  1.00 27.74           C  
ATOM    800  O   VAL    66      20.368  19.174  19.054  1.00 27.05           O  
ATOM    802  N   ASN    67      19.485  21.227  19.463  1.00 28.26           N  
ATOM    803  CA  ASN    67      20.095  21.919  18.295  1.00 28.74           C  
ATOM    805  CB  ASN    67      19.369  23.234  17.954  1.00 29.15           C  
ATOM    808  CG  ASN    67      17.862  23.046  17.756  1.00 30.45           C  
ATOM    809  OD1 ASN    67      17.316  21.924  17.886  1.00 31.70           O  
ATOM    810  ND2 ASN    67      17.175  24.152  17.467  1.00 29.61           N  
ATOM    813  C   ASN    67      21.546  22.272  18.503  1.00 28.57           C  
ATOM    814  O   ASN    67      22.382  22.068  17.625  1.00 28.06           O  
ATOM    816  N   GLN    68      21.820  22.854  19.661  1.00 28.68           N  
ATOM    817  CA  GLN    68      23.187  23.164  20.074  1.00 29.07           C  
ATOM    819  CB  GLN    68      23.182  23.668  21.536  1.00 29.90           C  
ATOM    822  CG  GLN    68      22.524  25.095  21.719  1.00 32.43           C  
ATOM    825  CD  GLN    68      22.188  25.490  23.188  1.00 32.48           C  
ATOM    826  OE1 GLN    68      21.718  24.669  23.999  1.00 31.76           O  
ATOM    827  NE2 GLN    68      22.424  26.777  23.507  1.00 31.80           N  
ATOM    830  C   GLN    68      24.041  21.912  20.001  1.00 28.56           C  
ATOM    831  O   GLN    68      25.150  21.918  19.494  1.00 27.79           O  
ATOM    833  N   THR    69      23.495  20.836  20.554  1.00 28.62           N  
ATOM    834  CA  THR    69      24.199  19.575  20.692  1.00 28.33           C  
ATOM    836  CB  THR    69      23.715  18.855  21.942  1.00 27.93           C  
ATOM    838  OG1 THR    69      24.674  17.873  22.314  1.00 30.06           O  
ATOM    840  CG2 THR    69      22.403  18.168  21.682  1.00 28.03           C  
ATOM    844  C   THR    69      24.028  18.652  19.476  1.00 28.16           C  
ATOM    845  O   THR    69      24.864  17.762  19.267  1.00 28.11           O  
ATOM    847  N   LYS    70      22.972  18.895  18.683  1.00 27.74           N  
ATOM    848  CA  LYS    70      22.589  18.065  17.531  1.00 27.50           C  
ATOM    850  CB  LYS    70      23.563  18.266  16.384  1.00 27.34           C  
ATOM    853  CG  LYS    70      23.246  19.525  15.632  1.00 28.15           C  
ATOM    856  CD  LYS    70      24.390  19.949  14.775  1.00 29.05           C  
ATOM    859  CE  LYS    70      24.183  21.367  14.275  1.00 29.94           C  
ATOM    862  NZ  LYS    70      25.274  21.771  13.281  1.00 31.00           N  
ATOM    866  C   LYS    70      22.383  16.586  17.886  1.00 27.49           C  
ATOM    867  O   LYS    70      22.638  15.688  17.088  1.00 27.02           O  
ATOM    869  N   ASN    71      21.857  16.364  19.083  1.00 27.55           N  
ATOM    870  CA  ASN    71      21.554  15.046  19.586  1.00 27.78           C  
ATOM    872  CB  ASN    71      22.528  14.710  20.740  1.00 28.42           C  
ATOM    875  CG  ASN    71      22.027  13.539  21.665  1.00 28.76           C  
ATOM    876  OD1 ASN    71      20.966  12.957  21.460  1.00 27.98           O  
ATOM    877  ND2 ASN    71      22.818  13.221  22.698  1.00 28.49           N  
ATOM    880  C   ASN    71      20.093  15.093  20.051  1.00 27.58           C  
ATOM    881  O   ASN    71      19.764  15.768  21.038  1.00 27.17           O  
ATOM    883  N   ALA    72      19.246  14.340  19.348  1.00 27.15           N  
ATOM    884  CA  ALA    72      17.800  14.367  19.546  1.00 27.07           C  
ATOM    886  CB  ALA    72      17.127  13.525  18.488  1.00 26.68           C  
ATOM    890  C   ALA    72      17.315  13.950  20.941  1.00 27.13           C  
ATOM    891  O   ALA    72      16.182  14.226  21.301  1.00 26.86           O  
ATOM    893  N   THR    73      18.163  13.293  21.726  1.00 27.64           N  
ATOM    894  CA  THR    73      17.794  12.844  23.087  1.00 27.77           C  
ATOM    896  CB  THR    73      18.487  11.475  23.481  1.00 27.68           C  
ATOM    898  OG1 THR    73      19.896  11.661  23.586  1.00 28.68           O  
ATOM    900  CG2 THR    73      18.245  10.386  22.484  1.00 27.37           C  
ATOM    904  C   THR    73      18.077  13.870  24.222  1.00 27.70           C  
ATOM    905  O   THR    73      17.605  13.670  25.328  1.00 28.04           O  
ATOM    907  N   ARG    74      18.804  14.962  23.970  1.00 28.06           N  
ATOM    908  CA  ARG    74      19.126  15.931  25.042  1.00 28.19           C  
ATOM    910  CB  ARG    74      20.501  16.601  24.849  1.00 28.37           C  
ATOM    913  CG  ARG    74      21.630  15.661  25.334  1.00 29.65           C  
ATOM    916  CD  ARG    74      23.077  16.273  25.365  1.00 31.98           C  
ATOM    919  NE  ARG    74      23.948  15.483  24.442  1.00 33.67           N  
ATOM    921  CZ  ARG    74      25.287  15.545  24.348  1.00 32.37           C  
ATOM    922  NH1 ARG    74      26.000  16.370  25.135  1.00 33.11           N  
ATOM    925  NH2 ARG    74      25.913  14.770  23.451  1.00 30.11           N  
ATOM    928  C   ARG    74      18.008  16.914  25.334  1.00 27.96           C  
ATOM    929  O   ARG    74      18.098  18.113  25.095  1.00 27.54           O  
ATOM    931  N   HIS    75      16.947  16.332  25.881  1.00 28.13           N  
ATOM    932  CA  HIS    75      15.808  17.019  26.439  1.00 27.64           C  
ATOM    934  CB  HIS    75      14.667  16.007  26.623  1.00 27.64           C  
ATOM    937  CG  HIS    75      13.933  15.675  25.364  1.00 26.85           C  
ATOM    938  ND1 HIS    75      12.684  15.091  25.365  1.00 27.16           N  
ATOM    940  CE1 HIS    75      12.273  14.929  24.123  1.00 25.35           C  
ATOM    942  NE2 HIS    75      13.203  15.398  23.314  1.00 25.61           N  
ATOM    944  CD2 HIS    75      14.241  15.891  24.066  1.00 26.69           C  
ATOM    946  C   HIS    75      16.212  17.565  27.809  1.00 27.62           C  
ATOM    947  O   HIS    75      17.040  16.976  28.486  1.00 27.41           O  
ATOM    949  N   ALA    76      15.605  18.680  28.215  1.00 27.85           N  
ATOM    950  CA  ALA    76      15.914  19.361  29.477  1.00 27.68           C  
ATOM    952  CB  ALA    76      14.837  20.315  29.795  1.00 27.83           C  
ATOM    956  C   ALA    76      16.071  18.407  30.627  1.00 27.54           C  
ATOM    957  O   ALA    76      16.949  18.557  31.454  1.00 27.23           O  
ATOM    959  N   GLU    77      15.202  17.415  30.660  1.00 27.94           N  
ATOM    960  CA  GLU    77      15.174  16.423  31.759  1.00 28.19           C  
ATOM    962  CB  GLU    77      13.931  15.503  31.638  1.00 28.04           C  
ATOM    965  CG  GLU    77      12.535  16.240  31.554  1.00 28.70           C  
ATOM    968  CD  GLU    77      12.024  16.560  30.121  1.00 29.00           C  
ATOM    969  OE1 GLU    77      12.744  17.225  29.338  1.00 26.96           O  
ATOM    970  OE2 GLU    77      10.890  16.137  29.788  1.00 30.20           O  
ATOM    971  C   GLU    77      16.453  15.576  31.775  1.00 28.12           C  
ATOM    972  O   GLU    77      16.977  15.267  32.831  1.00 27.91           O  
ATOM    974  N   MET    78      16.945  15.218  30.590  1.00 28.34           N  
ATOM    975  CA  MET    78      18.162  14.405  30.454  1.00 28.57           C  
ATOM    977  CB  MET    78      18.256  13.796  29.033  1.00 28.60           C  
ATOM    980  CG  MET    78      17.083  12.903  28.658  1.00 29.43           C  
ATOM    983  SD  MET    78      17.088  11.230  29.438  1.00 32.79           S  
ATOM    984  CE  MET    78      18.680  10.560  28.910  1.00 33.89           C  
ATOM    988  C   MET    78      19.438  15.196  30.807  1.00 27.97           C  
ATOM    989  O   MET    78      20.374  14.636  31.382  1.00 27.32           O  
ATOM    991  N   VAL    79      19.449  16.485  30.467  1.00 27.87           N  
ATOM    992  CA  VAL    79      20.504  17.412  30.894  1.00 27.89           C  
ATOM    994  CB  VAL    79      20.252  18.842  30.335  1.00 27.64           C  
ATOM    996  CG1 VAL    79      21.200  19.821  30.957  1.00 26.57           C  
ATOM   1000  CG2 VAL    79      20.390  18.846  28.827  1.00 27.02           C  
ATOM   1004  C   VAL    79      20.582  17.472  32.428  1.00 28.20           C  
ATOM   1005  O   VAL    79      21.663  17.343  33.013  1.00 28.42           O  
ATOM   1007  N   ALA    80      19.422  17.663  33.060  1.00 28.46           N  
ATOM   1008  CA  ALA    80      19.292  17.726  34.514  1.00 28.47           C  
ATOM   1010  CB  ALA    80      17.846  18.000  34.891  1.00 28.80           C  
ATOM   1014  C   ALA    80      19.776  16.452  35.211  1.00 28.83           C  
ATOM   1015  O   ALA    80      20.513  16.536  36.211  1.00 28.83           O  
ATOM   1017  N   ILE    81      19.346  15.286  34.702  1.00 28.53           N  
ATOM   1018  CA  ILE    81      19.759  14.004  35.257  1.00 28.44           C  
ATOM   1020  CB  ILE    81      19.134  12.836  34.510  1.00 28.66           C  
ATOM   1022  CG1 ILE    81      17.624  12.783  34.805  1.00 28.89           C  
ATOM   1025  CD1 ILE    81      16.882  11.805  33.992  1.00 26.60           C  
ATOM   1029  CG2 ILE    81      19.789  11.514  34.943  1.00 28.72           C  
ATOM   1033  C   ILE    81      21.275  13.851  35.248  1.00 28.72           C  
ATOM   1034  O   ILE    81      21.854  13.413  36.239  1.00 29.25           O  
ATOM   1036  N   ASP    82      21.922  14.237  34.152  1.00 28.61           N  
ATOM   1037  CA  ASP    82      23.382  14.204  34.080  1.00 28.47           C  
ATOM   1039  CB  ASP    82      23.900  14.655  32.700  1.00 28.86           C  
ATOM   1042  CG  ASP    82      24.020  13.506  31.685  1.00 30.66           C  
ATOM   1043  OD1 ASP    82      23.613  12.367  32.024  1.00 33.60           O  
ATOM   1044  OD2 ASP    82      24.542  13.743  30.544  1.00 32.55           O  
ATOM   1045  C   ASP    82      23.987  15.088  35.148  1.00 28.01           C  
ATOM   1046  O   ASP    82      24.999  14.728  35.734  1.00 27.82           O  
ATOM   1048  N   GLN    83      23.379  16.253  35.385  1.00 27.76           N  
ATOM   1049  CA  GLN    83      23.868  17.178  36.416  1.00 27.64           C  
ATOM   1051  CB  GLN    83      23.170  18.538  36.279  1.00 27.69           C  
ATOM   1054  CG  GLN    83      23.871  19.468  35.291  1.00 28.50           C  
ATOM   1057  CD  GLN    83      23.481  20.925  35.456  1.00 27.64           C  
ATOM   1058  OE1 GLN    83      22.782  21.301  36.390  1.00 27.94           O  
ATOM   1059  NE2 GLN    83      23.942  21.750  34.551  1.00 27.26           N  
ATOM   1062  C   GLN    83      23.721  16.646  37.849  1.00 27.11           C  
ATOM   1063  O   GLN    83      24.612  16.790  38.666  1.00 26.25           O  
ATOM   1065  N   VAL    84      22.573  16.039  38.131  1.00 27.29           N  
ATOM   1066  CA  VAL    84      22.373  15.354  39.390  1.00 27.38           C  
ATOM   1068  CB  VAL    84      20.931  14.822  39.562  1.00 27.63           C  
ATOM   1070  CG1 VAL    84      20.775  14.175  40.919  1.00 25.95           C  
ATOM   1074  CG2 VAL    84      19.923  15.945  39.394  1.00 26.82           C  
ATOM   1078  C   VAL    84      23.395  14.241  39.566  1.00 27.17           C  
ATOM   1079  O   VAL    84      24.087  14.205  40.570  1.00 27.42           O  
ATOM   1081  N   LEU    85      23.541  13.356  38.595  1.00 27.06           N  
ATOM   1082  CA  LEU    85      24.643  12.379  38.680  1.00 27.18           C  
ATOM   1084  CB  LEU    85      24.735  11.528  37.415  1.00 26.93           C  
ATOM   1087  CG  LEU    85      23.618  10.515  37.247  1.00 26.49           C  
ATOM   1089  CD1 LEU    85      23.286  10.344  35.774  1.00 27.04           C  
ATOM   1093  CD2 LEU    85      24.014   9.242  37.875  1.00 26.00           C  
ATOM   1097  C   LEU    85      25.997  13.029  38.955  1.00 27.04           C  
ATOM   1098  O   LEU    85      26.807  12.451  39.661  1.00 27.51           O  
ATOM   1100  N   ASP    86      26.240  14.216  38.404  1.00 27.40           N  
ATOM   1101  CA  ASP    86      27.493  14.935  38.638  1.00 27.79           C  
ATOM   1103  CB  ASP    86      27.674  16.086  37.657  1.00 27.90           C  
ATOM   1106  CG  ASP    86      29.145  16.270  37.271  1.00 30.86           C  
ATOM   1107  OD1 ASP    86      29.648  15.494  36.390  1.00 32.41           O  
ATOM   1108  OD2 ASP    86      29.826  17.137  37.906  1.00 33.31           O  
ATOM   1109  C   ASP    86      27.612  15.473  40.060  1.00 27.69           C  
ATOM   1110  O   ASP    86      28.704  15.515  40.648  1.00 27.89           O  
ATOM   1112  N   TRP    87      26.479  15.887  40.606  1.00 27.68           N  
ATOM   1113  CA  TRP    87      26.393  16.362  41.971  1.00 27.52           C  
ATOM   1115  CB  TRP    87      24.996  16.944  42.217  1.00 28.11           C  
ATOM   1118  CG  TRP    87      24.854  17.634  43.516  1.00 27.84           C  
ATOM   1119  CD1 TRP    87      25.097  18.936  43.765  1.00 26.94           C  
ATOM   1121  NE1 TRP    87      24.843  19.218  45.082  1.00 27.80           N  
ATOM   1123  CE2 TRP    87      24.445  18.076  45.722  1.00 27.98           C  
ATOM   1124  CD2 TRP    87      24.432  17.048  44.756  1.00 28.61           C  
ATOM   1125  CE3 TRP    87      24.048  15.750  45.143  1.00 27.55           C  
ATOM   1127  CZ3 TRP    87      23.721  15.525  46.469  1.00 27.38           C  
ATOM   1129  CH2 TRP    87      23.747  16.579  47.415  1.00 27.96           C  
ATOM   1131  CZ2 TRP    87      24.101  17.857  47.060  1.00 27.24           C  
ATOM   1133  C   TRP    87      26.661  15.254  42.957  1.00 27.22           C  
ATOM   1134  O   TRP    87      27.279  15.469  43.985  1.00 26.82           O  
ATOM   1136  N   CYS    88      26.147  14.072  42.648  1.00 27.62           N  
ATOM   1137  CA  CYS    88      26.427  12.872  43.433  1.00 27.93           C  
ATOM   1139  CB  CYS    88      25.738  11.657  42.842  1.00 27.87           C  
ATOM   1142  SG  CYS    88      24.004  11.558  43.304  1.00 29.69           S  
ATOM   1144  C   CYS    88      27.893  12.579  43.502  1.00 27.85           C  
ATOM   1145  O   CYS    88      28.411  12.357  44.584  1.00 28.58           O  
ATOM   1147  N   ARG    89      28.569  12.568  42.360  1.00 27.85           N  
ATOM   1148  CA  ARG    89      30.000  12.313  42.366  1.00 28.33           C  
ATOM   1150  CB  ARG    89      30.613  12.676  41.043  1.00 28.62           C  
ATOM   1153  CG  ARG    89      30.413  11.652  39.984  1.00 29.96           C  
ATOM   1156  CD  ARG    89      30.720  12.311  38.629  1.00 31.97           C  
ATOM   1159  NE  ARG    89      30.164  11.544  37.504  1.00 33.93           N  
ATOM   1161  CZ  ARG    89      30.404  11.831  36.215  1.00 36.20           C  
ATOM   1162  NH1 ARG    89      31.159  12.902  35.886  1.00 37.64           N  
ATOM   1165  NH2 ARG    89      29.920  11.053  35.234  1.00 36.24           N  
ATOM   1168  C   ARG    89      30.730  13.111  43.408  1.00 28.11           C  
ATOM   1169  O   ARG    89      31.577  12.583  44.101  1.00 28.00           O  
ATOM   1171  N   GLN    90      30.383  14.386  43.506  1.00 28.42           N  
ATOM   1172  CA  GLN    90      31.132  15.339  44.301  1.00 28.75           C  
ATOM   1174  CB  GLN    90      30.990  16.703  43.661  1.00 29.03           C  
ATOM   1177  CG  GLN    90      31.457  16.706  42.217  1.00 31.17           C  
ATOM   1180  CD  GLN    90      31.094  17.981  41.521  1.00 33.04           C  
ATOM   1181  OE1 GLN    90      30.440  18.845  42.108  1.00 35.04           O  
ATOM   1182  NE2 GLN    90      31.498  18.113  40.261  1.00 34.45           N  
ATOM   1185  C   GLN    90      30.670  15.469  45.728  1.00 28.39           C  
ATOM   1186  O   GLN    90      31.383  16.039  46.538  1.00 28.51           O  
ATOM   1188  N   SER    91      29.453  15.014  46.010  1.00 28.22           N  
ATOM   1189  CA  SER    91      28.885  15.090  47.346  1.00 28.33           C  
ATOM   1191  CB  SER    91      27.379  15.315  47.267  1.00 28.48           C  
ATOM   1194  OG  SER    91      26.708  14.066  47.137  1.00 28.44           O  
ATOM   1196  C   SER    91      29.135  13.806  48.131  1.00 28.41           C  
ATOM   1197  O   SER    91      28.941  13.790  49.351  1.00 28.52           O  
ATOM   1199  N   GLY    92      29.541  12.740  47.419  1.00 28.34           N  
ATOM   1200  CA  GLY    92      29.820  11.437  48.010  1.00 28.07           C  
ATOM   1203  C   GLY    92      28.567  10.609  48.180  1.00 27.97           C  
ATOM   1204  O   GLY    92      28.632   9.480  48.609  1.00 28.33           O  
ATOM   1206  N   LYS    93      27.418  11.175  47.850  1.00 28.04           N  
ATOM   1207  CA  LYS    93      26.144  10.499  48.043  1.00 28.52           C  
ATOM   1209  CB  LYS    93      25.010  11.516  48.151  1.00 28.44           C  
ATOM   1212  CG  LYS    93      25.124  12.507  49.287  1.00 28.85           C  
ATOM   1215  CD  LYS    93      24.408  12.008  50.555  1.00 30.68           C  
ATOM   1218  CE  LYS    93      23.929  13.147  51.497  1.00 31.10           C  
ATOM   1221  NZ  LYS    93      22.573  12.817  52.143  1.00 31.15           N  
ATOM   1225  C   LYS    93      25.886   9.579  46.841  1.00 28.54           C  
ATOM   1226  O   LYS    93      26.366   9.859  45.736  1.00 28.29           O  
ATOM   1228  N   SER    94      25.122   8.501  47.058  1.00 28.28           N  
ATOM   1229  CA  SER    94      24.802   7.568  45.984  1.00 27.99           C  
ATOM   1231  CB  SER    94      24.546   6.167  46.522  1.00 27.89           C  
ATOM   1234  OG  SER    94      23.271   6.106  47.132  1.00 27.86           O  
ATOM   1236  C   SER    94      23.571   8.064  45.224  1.00 28.07           C  
ATOM   1237  O   SER    94      22.649   8.643  45.843  1.00 27.86           O  
ATOM   1239  N   PRO    95      23.548   7.840  43.893  1.00 27.49           N  
ATOM   1240  CA  PRO    95      22.436   8.176  42.998  1.00 27.79           C  
ATOM   1242  CB  PRO    95      22.818   7.481  41.703  1.00 27.72           C  
ATOM   1245  CG  PRO    95      24.264   7.455  41.751  1.00 28.05           C  
ATOM   1248  CD  PRO    95      24.646   7.219  43.154  1.00 27.05           C  
ATOM   1251  C   PRO    95      21.045   7.709  43.436  1.00 27.91           C  
ATOM   1252  O   PRO    95      20.106   8.499  43.371  1.00 28.45           O  
ATOM   1253  N   SER    96      20.917   6.457  43.869  1.00 27.75           N  
ATOM   1254  CA  SER    96      19.643   5.929  44.340  1.00 28.16           C  
ATOM   1256  CB  SER    96      19.727   4.416  44.567  1.00 28.01           C  
ATOM   1259  OG  SER    96      20.401   4.120  45.777  1.00 28.00           O  
ATOM   1261  C   SER    96      19.140   6.659  45.599  1.00 28.30           C  
ATOM   1262  O   SER    96      17.977   6.987  45.701  1.00 28.80           O  
ATOM   1264  N   GLU    97      20.029   6.959  46.524  1.00 28.77           N  
ATOM   1265  CA  GLU    97      19.701   7.734  47.728  1.00 29.19           C  
ATOM   1267  CB  GLU    97      20.960   7.760  48.608  1.00 29.43           C  
ATOM   1270  CG  GLU    97      20.840   8.453  49.966  1.00 31.88           C  
ATOM   1273  CD  GLU    97      22.211   8.495  50.747  1.00 34.19           C  
ATOM   1274  OE1 GLU    97      23.234   7.944  50.211  1.00 34.81           O  
ATOM   1275  OE2 GLU    97      22.250   9.095  51.874  1.00 32.68           O  
ATOM   1276  C   GLU    97      19.225   9.185  47.447  1.00 29.09           C  
ATOM   1277  O   GLU    97      18.528   9.788  48.293  1.00 29.59           O  
ATOM   1279  N   VAL    98      19.614   9.742  46.295  1.00 28.27           N  
ATOM   1280  CA  VAL    98      19.289  11.121  45.961  1.00 28.28           C  
ATOM   1282  CB  VAL    98      20.460  11.853  45.218  1.00 28.27           C  
ATOM   1284  CG1 VAL    98      20.109  13.282  44.899  1.00 25.94           C  
ATOM   1288  CG2 VAL    98      21.732  11.836  46.046  1.00 28.61           C  
ATOM   1292  C   VAL    98      18.069  11.175  45.066  1.00 28.91           C  
ATOM   1293  O   VAL    98      17.096  11.881  45.374  1.00 28.91           O  
ATOM   1295  N   PHE    99      18.133  10.470  43.930  1.00 29.30           N  
ATOM   1296  CA  PHE    99      17.022  10.466  42.968  1.00 29.02           C  
ATOM   1298  CB  PHE    99      17.314   9.595  41.740  1.00 29.08           C  
ATOM   1301  CG  PHE    99      18.191  10.271  40.744  1.00 30.28           C  
ATOM   1302  CD1 PHE    99      19.564  10.018  40.707  1.00 30.48           C  
ATOM   1304  CE1 PHE    99      20.391  10.672  39.812  1.00 29.96           C  
ATOM   1306  CZ  PHE    99      19.873  11.616  38.953  1.00 30.17           C  
ATOM   1308  CE2 PHE    99      18.508  11.904  38.982  1.00 31.27           C  
ATOM   1310  CD2 PHE    99      17.666  11.222  39.877  1.00 31.63           C  
ATOM   1312  C   PHE    99      15.737  10.011  43.618  1.00 28.89           C  
ATOM   1313  O   PHE    99      14.682  10.551  43.305  1.00 29.69           O  
ATOM   1315  N   GLU   100      15.802   9.025  44.514  1.00 28.16           N  
ATOM   1316  CA  GLU   100      14.578   8.558  45.168  1.00 27.97           C  
ATOM   1318  CB  GLU   100      14.825   7.247  45.899  1.00 27.44           C  
ATOM   1321  CG  GLU   100      15.086   6.145  44.939  1.00 28.81           C  
ATOM   1324  CD  GLU   100      15.433   4.827  45.602  1.00 31.25           C  
ATOM   1325  OE1 GLU   100      14.999   4.604  46.757  1.00 33.41           O  
ATOM   1326  OE2 GLU   100      16.147   4.005  44.961  1.00 32.63           O  
ATOM   1327  C   GLU   100      13.901   9.589  46.090  1.00 27.67           C  
ATOM   1328  O   GLU   100      12.803   9.337  46.580  1.00 27.67           O  
ATOM   1330  N   HIS   101      14.549  10.734  46.319  1.00 27.43           N  
ATOM   1331  CA  HIS   101      13.984  11.809  47.136  1.00 27.25           C  
ATOM   1333  CB  HIS   101      14.693  11.846  48.490  1.00 27.64           C  
ATOM   1336  CG  HIS   101      14.600  10.559  49.241  1.00 28.63           C  
ATOM   1337  ND1 HIS   101      15.589   9.592  49.190  1.00 29.98           N  
ATOM   1339  CE1 HIS   101      15.213   8.550  49.910  1.00 29.66           C  
ATOM   1341  NE2 HIS   101      14.023   8.807  50.425  1.00 29.55           N  
ATOM   1343  CD2 HIS   101      13.611  10.050  50.010  1.00 28.37           C  
ATOM   1345  C   HIS   101      14.093  13.162  46.463  1.00 26.91           C  
ATOM   1346  O   HIS   101      14.090  14.165  47.121  1.00 26.37           O  
ATOM   1348  N   THR   102      14.172  13.155  45.136  1.00 27.88           N  
ATOM   1349  CA  THR   102      14.323  14.343  44.296  1.00 28.28           C  
ATOM   1351  CB  THR   102      15.376  14.090  43.179  1.00 28.77           C  
ATOM   1353  OG1 THR   102      16.620  13.677  43.769  1.00 29.37           O  
ATOM   1355  CG2 THR   102      15.602  15.338  42.319  1.00 28.67           C  
ATOM   1359  C   THR   102      12.981  14.701  43.643  1.00 28.52           C  
ATOM   1360  O   THR   102      12.303  13.824  43.089  1.00 29.15           O  
ATOM   1362  N   VAL   103      12.571  15.975  43.723  1.00 28.29           N  
ATOM   1363  CA  VAL   103      11.375  16.424  43.007  1.00 27.89           C  
ATOM   1365  CB  VAL   103      10.499  17.411  43.792  1.00 27.37           C  
ATOM   1367  CG1 VAL   103       9.458  17.967  42.885  1.00 27.07           C  
ATOM   1371  CG2 VAL   103       9.842  16.749  44.935  1.00 26.32           C  
ATOM   1375  C   VAL   103      11.855  17.124  41.762  1.00 28.32           C  
ATOM   1376  O   VAL   103      12.766  17.953  41.840  1.00 27.99           O  
ATOM   1378  N   LEU   104      11.241  16.769  40.627  1.00 28.66           N  
ATOM   1379  CA  LEU   104      11.499  17.407  39.326  1.00 28.73           C  
ATOM   1381  CB  LEU   104      11.432  16.357  38.204  1.00 28.51           C  
ATOM   1384  CG  LEU   104      11.478  16.890  36.764  1.00 29.73           C  
ATOM   1386  CD1 LEU   104      12.826  17.591  36.418  1.00 30.68           C  
ATOM   1390  CD2 LEU   104      11.197  15.768  35.748  1.00 29.46           C  
ATOM   1394  C   LEU   104      10.469  18.508  39.084  1.00 28.35           C  
ATOM   1395  O   LEU   104       9.279  18.299  39.308  1.00 28.58           O  
ATOM   1397  N   TYR   105      10.935  19.672  38.635  1.00 28.26           N  
ATOM   1398  CA  TYR   105      10.055  20.816  38.292  1.00 28.44           C  
ATOM   1400  CB  TYR   105      10.335  22.040  39.206  1.00 28.13           C  
ATOM   1403  CG  TYR   105      10.205  21.756  40.702  1.00 27.64           C  
ATOM   1404  CD1 TYR   105      11.284  21.202  41.410  1.00 28.21           C  
ATOM   1406  CE1 TYR   105      11.188  20.907  42.749  1.00 27.85           C  
ATOM   1408  CZ  TYR   105      10.000  21.179  43.415  1.00 28.16           C  
ATOM   1409  OH  TYR   105       9.935  20.866  44.768  1.00 26.64           O  
ATOM   1411  CE2 TYR   105       8.925  21.757  42.726  1.00 25.52           C  
ATOM   1413  CD2 TYR   105       9.032  22.035  41.395  1.00 24.48           C  
ATOM   1415  C   TYR   105      10.264  21.171  36.797  1.00 28.60           C  
ATOM   1416  O   TYR   105      11.342  21.633  36.439  1.00 28.75           O  
ATOM   1418  N   VAL   106       9.255  20.945  35.942  1.00 28.20           N  
ATOM   1419  CA  VAL   106       9.399  21.109  34.476  1.00 28.13           C  
ATOM   1421  CB  VAL   106       9.437  19.736  33.731  1.00 27.97           C  
ATOM   1423  CG1 VAL   106      10.590  18.978  34.171  1.00 29.41           C  
ATOM   1427  CG2 VAL   106       8.201  18.935  34.004  1.00 26.97           C  
ATOM   1431  C   VAL   106       8.304  21.933  33.793  1.00 27.78           C  
ATOM   1432  O   VAL   106       7.135  21.879  34.152  1.00 27.98           O  
ATOM   1434  N   THR   107       8.698  22.640  32.750  1.00 27.47           N  
ATOM   1435  CA  THR   107       7.797  23.502  31.995  1.00 27.60           C  
ATOM   1437  CB  THR   107       8.624  24.430  31.114  1.00 27.08           C  
ATOM   1439  OG1 THR   107       9.242  25.406  31.949  1.00 26.99           O  
ATOM   1441  CG2 THR   107       7.752  25.104  30.113  1.00 28.88           C  
ATOM   1445  C   THR   107       6.738  22.762  31.142  1.00 27.29           C  
ATOM   1446  O   THR   107       5.602  23.217  31.046  1.00 27.48           O  
ATOM   1448  N   VAL   108       7.124  21.648  30.524  1.00 26.89           N  
ATOM   1449  CA  VAL   108       6.228  20.847  29.718  1.00 26.46           C  
ATOM   1451  CB  VAL   108       6.701  20.787  28.284  1.00 26.45           C  
ATOM   1453  CG1 VAL   108       5.756  19.953  27.480  1.00 25.92           C  
ATOM   1457  CG2 VAL   108       6.837  22.205  27.700  1.00 26.36           C  
ATOM   1461  C   VAL   108       6.186  19.431  30.231  1.00 26.51           C  
ATOM   1462  O   VAL   108       7.157  18.899  30.725  1.00 26.61           O  
ATOM   1464  N   GLU   109       5.033  18.814  30.117  1.00 27.18           N  
ATOM   1465  CA  GLU   109       4.876  17.390  30.411  1.00 27.29           C  
ATOM   1467  CB  GLU   109       3.488  16.904  29.932  1.00 27.24           C  
ATOM   1470  CG  GLU   109       3.138  15.447  30.308  1.00 28.49           C  
ATOM   1473  CD  GLU   109       1.889  14.937  29.589  1.00 29.27           C  
ATOM   1474  OE1 GLU   109       1.109  15.760  29.061  1.00 29.40           O  
ATOM   1475  OE2 GLU   109       1.691  13.706  29.528  1.00 30.07           O  
ATOM   1476  C   GLU   109       6.009  16.560  29.782  1.00 26.50           C  
ATOM   1477  O   GLU   109       6.244  16.634  28.607  1.00 25.85           O  
ATOM   1479  N   PRO   110       6.734  15.790  30.590  1.00 27.08           N  
ATOM   1480  CA  PRO   110       7.729  14.855  30.045  1.00 27.45           C  
ATOM   1482  CB  PRO   110       8.119  14.018  31.256  1.00 27.41           C  
ATOM   1485  CG  PRO   110       7.870  14.919  32.414  1.00 27.40           C  
ATOM   1488  CD  PRO   110       6.709  15.769  32.066  1.00 27.08           C  
ATOM   1491  C   PRO   110       7.213  13.943  28.942  1.00 27.32           C  
ATOM   1492  O   PRO   110       6.112  13.439  29.046  1.00 26.89           O  
ATOM   1493  N   CYS   111       8.019  13.764  27.895  1.00 27.48           N  
ATOM   1494  CA  CYS   111       7.673  12.895  26.779  1.00 27.20           C  
ATOM   1496  CB  CYS   111       8.596  13.159  25.591  1.00 27.18           C  
ATOM   1499  SG  CYS   111      10.319  12.549  25.762  1.00 26.81           S  
ATOM   1501  C   CYS   111       7.773  11.433  27.179  1.00 27.55           C  
ATOM   1502  O   CYS   111       8.200  11.098  28.282  1.00 27.24           O  
ATOM   1504  N   ILE   112       7.393  10.555  26.260  1.00 27.67           N  
ATOM   1505  CA  ILE   112       7.456   9.134  26.532  1.00 27.66           C  
ATOM   1507  CB  ILE   112       6.865   8.310  25.370  1.00 27.71           C  
ATOM   1509  CG1 ILE   112       5.338   8.440  25.369  1.00 28.05           C  
ATOM   1512  CD1 ILE   112       4.648   7.765  24.177  1.00 28.17           C  
ATOM   1516  CG2 ILE   112       7.261   6.828  25.471  1.00 27.28           C  
ATOM   1520  C   ILE   112       8.872   8.692  26.886  1.00 27.75           C  
ATOM   1521  O   ILE   112       9.050   7.898  27.810  1.00 27.52           O  
ATOM   1523  N   MET   113       9.878   9.206  26.168  1.00 28.00           N  
ATOM   1524  CA  MET   113      11.286   8.865  26.477  1.00 27.71           C  
ATOM   1526  CB  MET   113      12.224   9.558  25.518  1.00 27.36           C  
ATOM   1529  CG  MET   113      13.630   9.038  25.611  1.00 27.66           C  
ATOM   1532  SD  MET   113      14.781  10.217  24.914  1.00 29.59           S  
ATOM   1533  CE  MET   113      15.865  10.464  26.347  1.00 31.93           C  
ATOM   1537  C   MET   113      11.695   9.263  27.906  1.00 27.74           C  
ATOM   1538  O   MET   113      12.210   8.430  28.653  1.00 27.33           O  
ATOM   1540  N   CYS   114      11.461  10.527  28.255  1.00 27.33           N  
ATOM   1541  CA  CYS   114      11.773  11.050  29.574  1.00 27.96           C  
ATOM   1543  CB  CYS   114      11.535  12.562  29.593  1.00 28.16           C  
ATOM   1546  SG  CYS   114      12.745  13.454  28.634  1.00 29.88           S  
ATOM   1548  C   CYS   114      10.984  10.409  30.733  1.00 27.83           C  
ATOM   1549  O   CYS   114      11.560  10.008  31.741  1.00 27.85           O  
ATOM   1551  N   ALA   115       9.675  10.312  30.597  1.00 27.62           N  
ATOM   1552  CA  ALA   115       8.891   9.588  31.569  1.00 27.76           C  
ATOM   1554  CB  ALA   115       7.432   9.558  31.146  1.00 27.42           C  
ATOM   1558  C   ALA   115       9.442   8.163  31.819  1.00 28.27           C  
ATOM   1559  O   ALA   115       9.599   7.752  32.985  1.00 29.59           O  
ATOM   1561  N   ALA   116       9.771   7.412  30.769  1.00 28.12           N  
ATOM   1562  CA  ALA   116      10.385   6.078  30.963  1.00 28.33           C  
ATOM   1564  CB  ALA   116      10.653   5.371  29.619  1.00 27.77           C  
ATOM   1568  C   ALA   116      11.675   6.194  31.785  1.00 28.62           C  
ATOM   1569  O   ALA   116      11.941   5.377  32.671  1.00 29.32           O  
ATOM   1571  N   ALA   117      12.463   7.229  31.508  1.00 28.78           N  
ATOM   1572  CA  ALA   117      13.700   7.484  32.246  1.00 28.73           C  
ATOM   1574  CB  ALA   117      14.421   8.676  31.653  1.00 28.83           C  
ATOM   1578  C   ALA   117      13.441   7.743  33.724  1.00 28.85           C  
ATOM   1579  O   ALA   117      14.094   7.176  34.577  1.00 28.67           O  
ATOM   1581  N   LEU   118      12.477   8.620  34.005  1.00 29.20           N  
ATOM   1582  CA  LEU   118      12.155   9.023  35.360  1.00 28.43           C  
ATOM   1584  CB  LEU   118      11.127  10.154  35.347  1.00 27.97           C  
ATOM   1587  CG  LEU   118      11.692  11.452  34.772  1.00 27.63           C  
ATOM   1589  CD1 LEU   118      10.735  12.603  34.919  1.00 28.37           C  
ATOM   1593  CD2 LEU   118      12.963  11.797  35.439  1.00 28.09           C  
ATOM   1597  C   LEU   118      11.669   7.840  36.159  1.00 28.28           C  
ATOM   1598  O   LEU   118      12.014   7.730  37.331  1.00 28.30           O  
ATOM   1600  N   ARG   119      10.895   6.949  35.534  1.00 28.26           N  
ATOM   1601  CA  ARG   119      10.579   5.659  36.179  1.00 28.76           C  
ATOM   1603  CB  ARG   119       9.775   4.752  35.252  1.00 29.30           C  
ATOM   1606  CG  ARG   119       8.261   4.867  35.387  1.00 29.05           C  
ATOM   1609  CD  ARG   119       7.630   3.767  34.611  1.00 29.20           C  
ATOM   1612  NE  ARG   119       7.435   2.550  35.388  1.00 29.29           N  
ATOM   1614  CZ  ARG   119       6.316   2.241  36.052  1.00 30.71           C  
ATOM   1615  NH1 ARG   119       5.280   3.079  36.090  1.00 31.34           N  
ATOM   1618  NH2 ARG   119       6.229   1.086  36.713  1.00 31.28           N  
ATOM   1621  C   ARG   119      11.826   4.865  36.565  1.00 28.71           C  
ATOM   1622  O   ARG   119      11.942   4.355  37.683  1.00 28.42           O  
ATOM   1624  N   LEU   120      12.738   4.738  35.608  1.00 28.29           N  
ATOM   1625  CA  LEU   120      13.955   3.987  35.836  1.00 28.40           C  
ATOM   1627  CB  LEU   120      14.671   3.762  34.510  1.00 27.90           C  
ATOM   1630  CG  LEU   120      13.979   2.793  33.547  1.00 26.59           C  
ATOM   1632  CD1 LEU   120      14.630   2.885  32.201  1.00 25.10           C  
ATOM   1636  CD2 LEU   120      13.984   1.375  34.042  1.00 24.24           C  
ATOM   1640  C   LEU   120      14.896   4.605  36.898  1.00 28.81           C  
ATOM   1641  O   LEU   120      15.541   3.860  37.658  1.00 29.54           O  
ATOM   1643  N   MET   121      14.978   5.941  36.943  1.00 28.87           N  
ATOM   1644  CA  MET   121      15.712   6.673  37.985  1.00 28.40           C  
ATOM   1646  CB  MET   121      15.922   8.132  37.588  1.00 28.32           C  
ATOM   1649  CG  MET   121      16.793   8.350  36.362  1.00 29.39           C  
ATOM   1652  SD  MET   121      18.368   7.437  36.341  1.00 31.52           S  
ATOM   1653  CE  MET   121      19.455   8.674  37.112  1.00 32.17           C  
ATOM   1657  C   MET   121      14.968   6.697  39.316  1.00 28.60           C  
ATOM   1658  O   MET   121      15.578   6.990  40.327  1.00 28.98           O  
ATOM   1660  N   LYS   122      13.654   6.446  39.301  1.00 28.57           N  
ATOM   1661  CA  LYS   122      12.791   6.393  40.496  1.00 27.97           C  
ATOM   1663  CB  LYS   122      13.311   5.396  41.523  1.00 27.70           C  
ATOM   1666  CG  LYS   122      13.463   4.024  41.001  1.00 27.70           C  
ATOM   1669  CD  LYS   122      13.797   3.117  42.133  1.00 28.38           C  
ATOM   1672  CE  LYS   122      13.990   1.713  41.622  1.00 28.97           C  
ATOM   1675  NZ  LYS   122      14.226   0.736  42.706  1.00 29.76           N  
ATOM   1679  C   LYS   122      12.590   7.725  41.178  1.00 28.20           C  
ATOM   1680  O   LYS   122      12.469   7.773  42.412  1.00 28.06           O  
ATOM   1682  N   ILE   123      12.586   8.805  40.394  1.00 27.95           N  
ATOM   1683  CA  ILE   123      12.130  10.084  40.892  1.00 27.99           C  
ATOM   1685  CB  ILE   123      12.231  11.205  39.833  1.00 28.47           C  
ATOM   1687  CG1 ILE   123      13.668  11.737  39.725  1.00 30.17           C  
ATOM   1690  CD1 ILE   123      14.537  11.101  38.597  1.00 31.52           C  
ATOM   1694  CG2 ILE   123      11.368  12.380  40.218  1.00 27.61           C  
ATOM   1698  C   ILE   123      10.659   9.867  41.267  1.00 27.89           C  
ATOM   1699  O   ILE   123       9.901   9.331  40.452  1.00 27.80           O  
ATOM   1701  N   PRO   124      10.268  10.206  42.521  1.00 27.53           N  
ATOM   1702  CA  PRO   124       8.908  10.069  43.039  1.00 27.20           C  
ATOM   1704  CB  PRO   124       9.133  10.061  44.535  1.00 27.06           C  
ATOM   1707  CG  PRO   124      10.268  10.856  44.751  1.00 27.33           C  
ATOM   1710  CD  PRO   124      11.177  10.670  43.583  1.00 27.38           C  
ATOM   1713  C   PRO   124       7.871  11.158  42.702  1.00 27.45           C  
ATOM   1714  O   PRO   124       6.685  10.838  42.712  1.00 27.46           O  
ATOM   1715  N   LEU   125       8.290  12.403  42.420  1.00 27.23           N  
ATOM   1716  CA  LEU   125       7.342  13.475  42.135  1.00 27.35           C  
ATOM   1718  CB  LEU   125       7.072  14.273  43.410  1.00 27.50           C  
ATOM   1721  CG  LEU   125       6.170  15.505  43.456  1.00 26.55           C  
ATOM   1723  CD1 LEU   125       4.804  15.257  42.848  1.00 27.47           C  
ATOM   1727  CD2 LEU   125       6.038  15.903  44.891  1.00 25.10           C  
ATOM   1731  C   LEU   125       7.805  14.419  41.029  1.00 28.05           C  
ATOM   1732  O   LEU   125       8.891  14.992  41.124  1.00 28.35           O  
ATOM   1734  N   VAL   126       6.962  14.578  39.993  1.00 28.17           N  
ATOM   1735  CA  VAL   126       7.152  15.557  38.936  1.00 27.98           C  
ATOM   1737  CB  VAL   126       7.033  14.889  37.547  1.00 28.31           C  
ATOM   1739  CG1 VAL   126       7.189  15.937  36.449  1.00 28.62           C  
ATOM   1743  CG2 VAL   126       8.075  13.764  37.376  1.00 28.63           C  
ATOM   1747  C   VAL   126       6.066  16.632  39.064  1.00 27.89           C  
ATOM   1748  O   VAL   126       4.885  16.314  39.154  1.00 27.83           O  
ATOM   1750  N   VAL   127       6.461  17.897  39.084  1.00 27.59           N  
ATOM   1751  CA  VAL   127       5.498  18.987  39.043  1.00 27.75           C  
ATOM   1753  CB  VAL   127       5.719  20.057  40.161  1.00 28.05           C  
ATOM   1755  CG1 VAL   127       5.015  21.381  39.854  1.00 27.26           C  
ATOM   1759  CG2 VAL   127       5.246  19.535  41.514  1.00 28.36           C  
ATOM   1763  C   VAL   127       5.737  19.598  37.704  1.00 27.95           C  
ATOM   1764  O   VAL   127       6.864  19.972  37.389  1.00 27.12           O  
ATOM   1766  N   TYR   128       4.680  19.692  36.900  1.00 28.52           N  
ATOM   1767  CA  TYR   128       4.822  20.268  35.566  1.00 28.45           C  
ATOM   1769  CB  TYR   128       5.025  19.162  34.533  1.00 28.06           C  
ATOM   1772  CG  TYR   128       3.818  18.402  34.078  1.00 28.34           C  
ATOM   1773  CD1 TYR   128       3.626  17.059  34.437  1.00 29.46           C  
ATOM   1775  CE1 TYR   128       2.514  16.329  33.958  1.00 28.31           C  
ATOM   1777  CZ  TYR   128       1.612  16.958  33.113  1.00 29.12           C  
ATOM   1778  OH  TYR   128       0.500  16.310  32.604  1.00 28.84           O  
ATOM   1780  CE2 TYR   128       1.816  18.275  32.740  1.00 29.55           C  
ATOM   1782  CD2 TYR   128       2.914  18.975  33.204  1.00 28.51           C  
ATOM   1784  C   TYR   128       3.757  21.297  35.151  1.00 28.39           C  
ATOM   1785  O   TYR   128       2.754  21.529  35.860  1.00 28.91           O  
ATOM   1787  N   GLY   129       4.029  21.932  34.015  1.00 27.67           N  
ATOM   1788  CA  GLY   129       3.199  22.991  33.493  1.00 27.87           C  
ATOM   1791  C   GLY   129       2.120  22.551  32.535  1.00 27.68           C  
ATOM   1792  O   GLY   129       1.142  21.973  32.960  1.00 28.21           O  
ATOM   1794  N   CYS   130       2.275  22.855  31.252  1.00 27.34           N  
ATOM   1795  CA  CYS   130       1.279  22.499  30.266  1.00 27.89           C  
ATOM   1797  CB  CYS   130       1.342  23.480  29.107  1.00 27.89           C  
ATOM   1800  SG  CYS   130       2.914  23.319  28.162  1.00 30.29           S  
ATOM   1802  C   CYS   130       1.470  21.072  29.724  1.00 27.56           C  
ATOM   1803  O   CYS   130       2.489  20.438  29.937  1.00 26.76           O  
ATOM   1805  N   GLN   131       0.471  20.610  28.984  1.00 27.70           N  
ATOM   1806  CA  GLN   131       0.459  19.278  28.412  1.00 27.98           C  
ATOM   1808  CB  GLN   131      -0.950  18.922  27.932  1.00 28.47           C  
ATOM   1811  CG  GLN   131      -2.080  18.913  29.037  1.00 29.70           C  
ATOM   1814  CD  GLN   131      -1.959  17.735  30.027  1.00 31.77           C  
ATOM   1815  OE1 GLN   131      -1.739  16.574  29.619  1.00 33.82           O  
ATOM   1816  NE2 GLN   131      -2.093  18.027  31.327  1.00 31.60           N  
ATOM   1819  C   GLN   131       1.429  19.146  27.243  1.00 27.96           C  
ATOM   1820  O   GLN   131       1.803  20.137  26.635  1.00 27.61           O  
ATOM   1822  N   ASN   132       1.838  17.908  26.957  1.00 27.61           N  
ATOM   1823  CA  ASN   132       2.626  17.589  25.790  1.00 27.44           C  
ATOM   1825  CB  ASN   132       3.852  16.823  26.237  1.00 27.50           C  
ATOM   1828  CG  ASN   132       4.790  16.477  25.105  1.00 27.17           C  
ATOM   1829  OD1 ASN   132       4.451  16.645  23.947  1.00 28.04           O  
ATOM   1830  ND2 ASN   132       5.969  15.974  25.440  1.00 26.21           N  
ATOM   1833  C   ASN   132       1.780  16.782  24.793  1.00 27.56           C  
ATOM   1834  O   ASN   132       1.796  15.567  24.792  1.00 27.93           O  
ATOM   1836  N   GLU   133       1.042  17.475  23.940  1.00 27.82           N  
ATOM   1837  CA  GLU   133       0.081  16.823  23.046  1.00 28.46           C  
ATOM   1839  CB  GLU   133      -0.771  17.863  22.301  1.00 28.66           C  
ATOM   1842  CG  GLU   133      -2.060  18.259  23.041  1.00 30.06           C  
ATOM   1845  CD  GLU   133      -2.933  19.217  22.235  1.00 31.68           C  
ATOM   1846  OE1 GLU   133      -3.256  18.917  21.055  1.00 31.78           O  
ATOM   1847  OE2 GLU   133      -3.298  20.278  22.791  1.00 33.58           O  
ATOM   1848  C   GLU   133       0.692  15.860  22.029  1.00 28.35           C  
ATOM   1849  O   GLU   133       0.094  14.830  21.710  1.00 28.39           O  
ATOM   1851  N   ARG   134       1.869  16.202  21.523  1.00 28.25           N  
ATOM   1852  CA  ARG   134       2.561  15.377  20.550  1.00 28.21           C  
ATOM   1854  CB  ARG   134       3.683  16.166  19.899  1.00 28.39           C  
ATOM   1857  CG  ARG   134       3.264  17.431  19.221  1.00 28.78           C  
ATOM   1860  CD  ARG   134       4.465  18.125  18.644  1.00 29.15           C  
ATOM   1863  NE  ARG   134       4.091  19.255  17.801  1.00 29.84           N  
ATOM   1865  CZ  ARG   134       4.910  19.864  16.935  1.00 31.27           C  
ATOM   1866  NH1 ARG   134       6.177  19.461  16.778  1.00 31.15           N  
ATOM   1869  NH2 ARG   134       4.464  20.902  16.221  1.00 32.11           N  
ATOM   1872  C   ARG   134       3.178  14.108  21.162  1.00 28.31           C  
ATOM   1873  O   ARG   134       3.053  13.042  20.586  1.00 28.43           O  
ATOM   1875  N   PHE   135       3.865  14.216  22.302  1.00 28.31           N  
ATOM   1876  CA  PHE   135       4.589  13.063  22.841  1.00 28.53           C  
ATOM   1878  CB  PHE   135       6.034  13.163  22.343  1.00 28.53           C  
ATOM   1881  CG  PHE   135       6.732  11.841  22.165  1.00 28.29           C  
ATOM   1882  CD1 PHE   135       6.029  10.670  21.855  1.00 28.13           C  
ATOM   1884  CE1 PHE   135       6.692   9.435  21.694  1.00 28.35           C  
ATOM   1886  CZ  PHE   135       8.063   9.366  21.827  1.00 28.92           C  
ATOM   1888  CE2 PHE   135       8.788  10.545  22.126  1.00 30.44           C  
ATOM   1890  CD2 PHE   135       8.112  11.776  22.288  1.00 28.94           C  
ATOM   1892  C   PHE   135       4.521  12.863  24.376  1.00 28.82           C  
ATOM   1893  O   PHE   135       5.346  12.140  24.953  1.00 29.17           O  
ATOM   1895  N   GLY   136       3.510  13.446  25.019  1.00 28.58           N  
ATOM   1896  CA  GLY   136       3.332  13.292  26.455  1.00 29.12           C  
ATOM   1899  C   GLY   136       3.279  11.832  26.957  1.00 29.71           C  
ATOM   1900  O   GLY   136       2.548  10.985  26.410  1.00 29.56           O  
ATOM   1902  N   GLY   137       4.055  11.555  28.013  1.00 29.77           N  
ATOM   1903  CA  GLY   137       4.027  10.275  28.740  1.00 29.90           C  
ATOM   1906  C   GLY   137       3.441  10.285  30.168  1.00 29.93           C  
ATOM   1907  O   GLY   137       3.670   9.350  30.965  1.00 30.73           O  
ATOM   1909  N   CYS   138       2.667  11.308  30.498  1.00 29.42           N  
ATOM   1910  CA  CYS   138       2.001  11.353  31.793  1.00 29.62           C  
ATOM   1912  CB  CYS   138       2.460  12.576  32.587  1.00 29.79           C  
ATOM   1915  SG  CYS   138       4.218  12.576  32.898  1.00 30.23           S  
ATOM   1917  C   CYS   138       0.490  11.355  31.686  1.00 29.17           C  
ATOM   1918  O   CYS   138      -0.197  11.656  32.652  1.00 28.48           O  
ATOM   1920  N   GLY   139      -0.019  11.016  30.511  1.00 29.34           N  
ATOM   1921  CA  GLY   139      -1.452  11.056  30.270  1.00 29.45           C  
ATOM   1924  C   GLY   139      -1.880  11.464  28.872  1.00 29.50           C  
ATOM   1925  O   GLY   139      -2.898  10.977  28.401  1.00 30.03           O  
ATOM   1927  N   SER   140      -1.121  12.330  28.190  1.00 29.38           N  
ATOM   1928  CA  SER   140      -1.573  12.879  26.892  1.00 28.69           C  
ATOM   1930  CB  SER   140      -0.698  14.057  26.466  1.00 28.93           C  
ATOM   1933  OG  SER   140      -0.859  15.151  27.372  1.00 29.34           O  
ATOM   1935  C   SER   140      -1.596  11.834  25.803  1.00 28.12           C  
ATOM   1936  O   SER   140      -2.623  11.555  25.238  1.00 27.68           O  
ATOM   1938  N   VAL   141      -0.454  11.256  25.506  1.00 28.02           N  
ATOM   1939  CA  VAL   141      -0.395  10.196  24.522  1.00 27.98           C  
ATOM   1941  CB  VAL   141       0.827  10.374  23.645  1.00 27.84           C  
ATOM   1943  CG1 VAL   141       0.846   9.345  22.553  1.00 27.05           C  
ATOM   1947  CG2 VAL   141       0.852  11.775  23.089  1.00 27.21           C  
ATOM   1951  C   VAL   141      -0.345   8.820  25.204  1.00 28.40           C  
ATOM   1952  O   VAL   141      -0.958   7.871  24.753  1.00 28.56           O  
ATOM   1954  N   LEU   142       0.434   8.716  26.266  1.00 28.60           N  
ATOM   1955  CA  LEU   142       0.486   7.511  27.059  1.00 28.88           C  
ATOM   1957  CB  LEU   142       1.655   6.641  26.609  1.00 29.36           C  
ATOM   1960  CG  LEU   142       1.363   5.515  25.614  1.00 29.50           C  
ATOM   1962  CD1 LEU   142       2.672   5.036  24.980  1.00 29.36           C  
ATOM   1966  CD2 LEU   142       0.667   4.390  26.351  1.00 28.79           C  
ATOM   1970  C   LEU   142       0.688   7.927  28.500  1.00 29.16           C  
ATOM   1971  O   LEU   142       1.134   9.040  28.782  1.00 29.17           O  
ATOM   1973  N   ASN   143       0.385   7.034  29.430  1.00 29.52           N  
ATOM   1974  CA  ASN   143       0.660   7.355  30.830  1.00 29.66           C  
ATOM   1976  CB  ASN   143      -0.628   7.395  31.629  1.00 29.61           C  
ATOM   1979  CG  ASN   143      -0.449   8.019  33.008  1.00 30.12           C  
ATOM   1980  OD1 ASN   143       0.647   8.046  33.602  1.00 27.75           O  
ATOM   1981  ND2 ASN   143      -1.567   8.488  33.549  1.00 31.84           N  
ATOM   1984  C   ASN   143       1.656   6.390  31.451  1.00 29.47           C  
ATOM   1985  O   ASN   143       1.281   5.505  32.230  1.00 28.77           O  
ATOM   1987  N   ILE   144       2.927   6.598  31.096  1.00 29.28           N  
ATOM   1988  CA  ILE   144       4.015   5.785  31.617  1.00 29.57           C  
ATOM   1990  CB  ILE   144       5.319   6.097  30.858  1.00 30.11           C  
ATOM   1992  CG1 ILE   144       5.167   5.738  29.372  1.00 31.30           C  
ATOM   1995  CD1 ILE   144       4.789   4.257  29.149  1.00 30.50           C  
ATOM   1999  CG2 ILE   144       6.510   5.303  31.422  1.00 30.18           C  
ATOM   2003  C   ILE   144       4.215   6.059  33.113  1.00 29.39           C  
ATOM   2004  O   ILE   144       4.545   5.141  33.866  1.00 28.54           O  
ATOM   2006  N   ALA   145       4.002   7.321  33.525  1.00 29.02           N  
ATOM   2007  CA  ALA   145       4.144   7.720  34.926  1.00 28.89           C  
ATOM   2009  CB  ALA   145       3.712   9.214  35.134  1.00 28.28           C  
ATOM   2013  C   ALA   145       3.364   6.780  35.871  1.00 29.09           C  
ATOM   2014  O   ALA   145       3.871   6.429  36.949  1.00 30.20           O  
ATOM   2016  N   SER   146       2.152   6.351  35.482  1.00 28.63           N  
ATOM   2017  CA  SER   146       1.299   5.589  36.399  1.00 28.27           C  
ATOM   2019  CB  SER   146      -0.022   6.323  36.579  1.00 28.33           C  
ATOM   2022  OG  SER   146      -0.803   6.270  35.407  1.00 28.49           O  
ATOM   2024  C   SER   146       1.055   4.147  35.959  1.00 27.91           C  
ATOM   2025  O   SER   146       0.192   3.468  36.474  1.00 27.20           O  
ATOM   2027  N   ALA   147       1.844   3.685  35.009  1.00 28.29           N  
ATOM   2028  CA  ALA   147       1.650   2.368  34.418  1.00 28.30           C  
ATOM   2030  CB  ALA   147       2.500   2.220  33.141  1.00 28.16           C  
ATOM   2034  C   ALA   147       2.008   1.281  35.414  1.00 28.18           C  
ATOM   2035  O   ALA   147       3.001   1.382  36.137  1.00 27.83           O  
ATOM   2037  N   ASP   148       1.178   0.248  35.441  1.00 28.60           N  
ATOM   2038  CA  ASP   148       1.422  -0.958  36.235  1.00 29.01           C  
ATOM   2040  CB  ASP   148       0.116  -1.758  36.344  1.00 29.22           C  
ATOM   2043  CG  ASP   148       0.271  -3.024  37.194  1.00 30.33           C  
ATOM   2044  OD1 ASP   148       1.223  -3.009  38.017  1.00 32.80           O  
ATOM   2045  OD2 ASP   148      -0.548  -4.005  37.063  1.00 28.99           O  
ATOM   2046  C   ASP   148       2.529  -1.831  35.603  1.00 28.97           C  
ATOM   2047  O   ASP   148       2.258  -2.648  34.732  1.00 29.13           O  
ATOM   2049  N   LEU   149       3.769  -1.644  36.037  1.00 28.92           N  
ATOM   2050  CA  LEU   149       4.910  -2.289  35.410  1.00 28.99           C  
ATOM   2052  CB  LEU   149       5.672  -1.312  34.501  1.00 28.85           C  
ATOM   2055  CG  LEU   149       4.909  -0.925  33.221  1.00 29.26           C  
ATOM   2057  CD1 LEU   149       5.552   0.303  32.539  1.00 28.15           C  
ATOM   2061  CD2 LEU   149       4.777  -2.100  32.253  1.00 27.32           C  
ATOM   2065  C   LEU   149       5.774  -2.797  36.547  1.00 29.23           C  
ATOM   2066  O   LEU   149       6.621  -2.072  37.076  1.00 29.09           O  
ATOM   2068  N   PRO   150       5.560  -4.060  36.923  1.00 29.54           N  
ATOM   2069  CA  PRO   150       6.060  -4.553  38.210  1.00 29.67           C  
ATOM   2071  CB  PRO   150       5.659  -6.054  38.214  1.00 29.48           C  
ATOM   2074  CG  PRO   150       4.613  -6.214  37.167  1.00 29.39           C  
ATOM   2077  CD  PRO   150       4.844  -5.103  36.153  1.00 29.63           C  
ATOM   2080  C   PRO   150       7.581  -4.399  38.417  1.00 29.61           C  
ATOM   2081  O   PRO   150       8.018  -3.945  39.489  1.00 29.54           O  
ATOM   2082  N   ASN   151       8.376  -4.783  37.422  1.00 29.36           N  
ATOM   2083  CA  ASN   151       9.822  -4.955  37.659  1.00 29.29           C  
ATOM   2085  CB  ASN   151      10.222  -6.417  37.379  1.00 29.22           C  
ATOM   2088  CG  ASN   151       9.393  -7.403  38.184  1.00 29.70           C  
ATOM   2089  OD1 ASN   151       9.515  -7.467  39.415  1.00 31.50           O  
ATOM   2090  ND2 ASN   151       8.529  -8.160  37.506  1.00 29.02           N  
ATOM   2093  C   ASN   151      10.696  -3.953  36.893  1.00 29.09           C  
ATOM   2094  O   ASN   151      11.868  -4.212  36.608  1.00 28.75           O  
ATOM   2096  N   THR   152      10.114  -2.797  36.586  1.00 29.07           N  
ATOM   2097  CA  THR   152      10.816  -1.768  35.853  1.00 29.13           C  
ATOM   2099  CB  THR   152      10.365  -1.749  34.358  1.00 29.31           C  
ATOM   2101  OG1 THR   152       8.964  -1.486  34.277  1.00 28.92           O  
ATOM   2103  CG2 THR   152      10.672  -3.123  33.693  1.00 29.99           C  
ATOM   2107  C   THR   152      10.600  -0.410  36.487  1.00 28.94           C  
ATOM   2108  O   THR   152       9.581   0.221  36.237  1.00 29.39           O  
ATOM   2110  N   GLY   153      11.562   0.038  37.301  1.00 28.73           N  
ATOM   2111  CA  GLY   153      11.483   1.345  37.989  1.00 28.04           C  
ATOM   2114  C   GLY   153      10.359   1.408  39.007  1.00 27.67           C  
ATOM   2115  O   GLY   153       9.875   0.385  39.480  1.00 27.40           O  
ATOM   2117  N   ARG   154       9.926   2.618  39.332  1.00 27.56           N  
ATOM   2118  CA  ARG   154       8.747   2.822  40.177  1.00 27.59           C  
ATOM   2120  CB  ARG   154       9.132   3.433  41.525  1.00 27.45           C  
ATOM   2123  CG  ARG   154       9.477   2.437  42.549  1.00 27.94           C  
ATOM   2126  CD  ARG   154      10.289   3.050  43.692  1.00 29.70           C  
ATOM   2129  NE  ARG   154      11.140   2.009  44.299  1.00 31.13           N  
ATOM   2131  CZ  ARG   154      11.949   2.180  45.345  1.00 30.89           C  
ATOM   2132  NH1 ARG   154      12.044   3.355  45.964  1.00 31.54           N  
ATOM   2135  NH2 ARG   154      12.672   1.155  45.773  1.00 31.08           N  
ATOM   2138  C   ARG   154       7.802   3.767  39.492  1.00 27.48           C  
ATOM   2139  O   ARG   154       8.250   4.674  38.804  1.00 28.31           O  
ATOM   2141  N   PRO   155       6.494   3.619  39.730  1.00 27.20           N  
ATOM   2142  CA  PRO   155       5.580   4.628  39.183  1.00 27.00           C  
ATOM   2144  CB  PRO   155       4.213   4.019  39.450  1.00 27.10           C  
ATOM   2147  CG  PRO   155       4.437   3.158  40.638  1.00 26.63           C  
ATOM   2150  CD  PRO   155       5.785   2.594  40.507  1.00 26.55           C  
ATOM   2153  C   PRO   155       5.717   5.931  39.935  1.00 26.56           C  
ATOM   2154  O   PRO   155       6.093   5.929  41.091  1.00 26.56           O  
ATOM   2155  N   PHE   156       5.403   7.035  39.293  1.00 26.62           N  
ATOM   2156  CA  PHE   156       5.498   8.302  39.973  1.00 27.22           C  
ATOM   2158  CB  PHE   156       6.778   9.058  39.597  1.00 27.60           C  
ATOM   2161  CG  PHE   156       6.860   9.460  38.156  1.00 28.10           C  
ATOM   2162  CD1 PHE   156       6.445  10.730  37.746  1.00 28.61           C  
ATOM   2164  CE1 PHE   156       6.503  11.085  36.419  1.00 27.46           C  
ATOM   2166  CZ  PHE   156       7.012  10.192  35.490  1.00 27.56           C  
ATOM   2168  CE2 PHE   156       7.440   8.944  35.877  1.00 27.45           C  
ATOM   2170  CD2 PHE   156       7.367   8.578  37.206  1.00 27.25           C  
ATOM   2172  C   PHE   156       4.281   9.183  39.828  1.00 27.25           C  
ATOM   2173  O   PHE   156       3.396   8.940  39.036  1.00 27.35           O  
ATOM   2175  N   GLN   157       4.266  10.209  40.661  1.00 28.12           N  
ATOM   2176  CA  GLN   157       3.162  11.132  40.818  1.00 28.30           C  
ATOM   2178  CB  GLN   157       3.023  11.430  42.312  1.00 28.26           C  
ATOM   2181  CG  GLN   157       1.573  11.587  42.818  1.00 29.14           C  
ATOM   2184  CD  GLN   157       0.726  10.354  42.579  1.00 28.88           C  
ATOM   2185  OE1 GLN   157       1.229   9.216  42.576  1.00 28.76           O  
ATOM   2186  NE2 GLN   157      -0.573  10.565  42.387  1.00 28.49           N  
ATOM   2189  C   GLN   157       3.458  12.421  40.041  1.00 28.32           C  
ATOM   2190  O   GLN   157       4.630  12.798  39.874  1.00 28.21           O  
ATOM   2192  N   CYS   158       2.393  13.052  39.540  1.00 28.34           N  
ATOM   2193  CA  CYS   158       2.457  14.325  38.805  1.00 28.55           C  
ATOM   2195  CB  CYS   158       2.053  14.113  37.368  1.00 28.36           C  
ATOM   2198  SG  CYS   158       3.234  13.191  36.449  1.00 32.99           S  
ATOM   2200  C   CYS   158       1.518  15.370  39.380  1.00 28.03           C  
ATOM   2201  O   CYS   158       0.415  15.028  39.825  1.00 28.21           O  
ATOM   2203  N   ILE   159       1.945  16.633  39.348  1.00 27.55           N  
ATOM   2204  CA  ILE   159       1.083  17.776  39.671  1.00 27.15           C  
ATOM   2206  CB  ILE   159       1.560  18.532  40.932  1.00 27.19           C  
ATOM   2208  CG1 ILE   159       1.641  17.546  42.109  1.00 27.25           C  
ATOM   2211  CD1 ILE   159       1.732  18.195  43.500  1.00 27.36           C  
ATOM   2215  CG2 ILE   159       0.655  19.748  41.227  1.00 26.47           C  
ATOM   2219  C   ILE   159       1.151  18.672  38.468  1.00 27.06           C  
ATOM   2220  O   ILE   159       2.008  19.550  38.397  1.00 27.30           O  
ATOM   2222  N   PRO   160       0.298  18.414  37.472  1.00 27.10           N  
ATOM   2223  CA  PRO   160       0.305  19.229  36.281  1.00 27.19           C  
ATOM   2225  CB  PRO   160      -0.544  18.406  35.303  1.00 26.90           C  
ATOM   2228  CG  PRO   160      -1.433  17.695  36.094  1.00 26.70           C  
ATOM   2231  CD  PRO   160      -0.693  17.339  37.350  1.00 27.27           C  
ATOM   2234  C   PRO   160      -0.314  20.600  36.470  1.00 27.02           C  
ATOM   2235  O   PRO   160      -0.932  20.865  37.479  1.00 27.06           O  
ATOM   2236  N   GLY   161      -0.094  21.468  35.491  1.00 27.50           N  
ATOM   2237  CA  GLY   161      -0.924  22.640  35.290  1.00 27.79           C  
ATOM   2240  C   GLY   161      -0.387  23.921  35.877  1.00 27.97           C  
ATOM   2241  O   GLY   161      -0.988  24.972  35.702  1.00 28.30           O  
ATOM   2243  N   TYR   162       0.734  23.872  36.581  1.00 28.36           N  
ATOM   2244  CA  TYR   162       1.233  25.110  37.155  1.00 28.73           C  
ATOM   2246  CB  TYR   162       2.370  24.897  38.182  1.00 29.03           C  
ATOM   2249  CG  TYR   162       2.842  26.246  38.703  1.00 30.02           C  
ATOM   2250  CD1 TYR   162       2.168  26.905  39.728  1.00 30.55           C  
ATOM   2252  CE1 TYR   162       2.574  28.183  40.156  1.00 31.77           C  
ATOM   2254  CZ  TYR   162       3.668  28.808  39.529  1.00 32.70           C  
ATOM   2255  OH  TYR   162       4.146  30.073  39.894  1.00 31.50           O  
ATOM   2257  CE2 TYR   162       4.321  28.152  38.497  1.00 32.51           C  
ATOM   2259  CD2 TYR   162       3.893  26.901  38.083  1.00 31.20           C  
ATOM   2261  C   TYR   162       1.658  26.061  36.018  1.00 28.23           C  
ATOM   2262  O   TYR   162       2.606  25.766  35.303  1.00 27.90           O  
ATOM   2264  N   ARG   163       0.938  27.177  35.868  1.00 27.90           N  
ATOM   2265  CA  ARG   163       1.139  28.134  34.763  1.00 27.84           C  
ATOM   2267  CB  ARG   163       2.396  28.962  35.001  1.00 27.51           C  
ATOM   2270  CG  ARG   163       2.350  29.744  36.287  1.00 28.30           C  
ATOM   2273  CD  ARG   163       3.691  30.412  36.611  1.00 28.58           C  
ATOM   2276  NE  ARG   163       3.973  31.592  35.798  1.00 29.09           N  
ATOM   2278  CZ  ARG   163       5.109  32.290  35.861  1.00 29.67           C  
ATOM   2279  NH1 ARG   163       6.078  31.937  36.710  1.00 30.17           N  
ATOM   2282  NH2 ARG   163       5.285  33.355  35.082  1.00 29.92           N  
ATOM   2285  C   ARG   163       1.174  27.499  33.350  1.00 27.71           C  
ATOM   2286  O   ARG   163       1.954  27.913  32.497  1.00 27.28           O  
ATOM   2288  N   ALA   164       0.302  26.517  33.113  1.00 27.57           N  
ATOM   2289  CA  ALA   164       0.159  25.891  31.798  1.00 27.60           C  
ATOM   2291  CB  ALA   164      -1.012  24.920  31.791  1.00 27.29           C  
ATOM   2295  C   ALA   164      -0.012  26.895  30.656  1.00 27.60           C  
ATOM   2296  O   ALA   164       0.579  26.704  29.599  1.00 27.70           O  
ATOM   2298  N   GLU   165      -0.800  27.951  30.862  1.00 27.39           N  
ATOM   2299  CA  GLU   165      -1.129  28.868  29.776  1.00 27.48           C  
ATOM   2301  CB  GLU   165      -2.048  29.961  30.262  1.00 27.81           C  
ATOM   2304  CG  GLU   165      -3.485  29.532  30.421  1.00 28.47           C  
ATOM   2307  CD  GLU   165      -4.392  30.708  30.786  1.00 30.58           C  
ATOM   2308  OE1 GLU   165      -4.442  31.711  30.023  1.00 30.66           O  
ATOM   2309  OE2 GLU   165      -5.060  30.633  31.849  1.00 32.43           O  
ATOM   2310  C   GLU   165       0.095  29.506  29.147  1.00 27.46           C  
ATOM   2311  O   GLU   165       0.268  29.497  27.928  1.00 27.18           O  
ATOM   2313  N   GLU   166       0.952  30.060  29.986  1.00 27.59           N  
ATOM   2314  CA  GLU   166       2.217  30.598  29.507  1.00 27.66           C  
ATOM   2316  CB  GLU   166       2.961  31.263  30.642  1.00 27.89           C  
ATOM   2319  CG  GLU   166       2.239  32.502  31.138  1.00 28.65           C  
ATOM   2322  CD  GLU   166       2.848  33.086  32.398  1.00 29.34           C  
ATOM   2323  OE1 GLU   166       3.360  32.322  33.252  1.00 28.90           O  
ATOM   2324  OE2 GLU   166       2.794  34.329  32.526  1.00 30.57           O  
ATOM   2325  C   GLU   166       3.097  29.544  28.876  1.00 27.37           C  
ATOM   2326  O   GLU   166       3.672  29.780  27.827  1.00 27.66           O  
ATOM   2328  N   ALA   167       3.185  28.376  29.498  1.00 27.20           N  
ATOM   2329  CA  ALA   167       3.951  27.277  28.926  1.00 26.97           C  
ATOM   2331  CB  ALA   167       3.988  26.105  29.869  1.00 26.83           C  
ATOM   2335  C   ALA   167       3.441  26.861  27.541  1.00 26.95           C  
ATOM   2336  O   ALA   167       4.225  26.686  26.627  1.00 27.07           O  
ATOM   2338  N   VAL   168       2.146  26.697  27.351  1.00 27.13           N  
ATOM   2339  CA  VAL   168       1.671  26.376  25.996  1.00 27.57           C  
ATOM   2341  CB  VAL   168       0.208  25.937  25.964  1.00 27.39           C  
ATOM   2343  CG1 VAL   168       0.085  24.566  26.594  1.00 27.92           C  
ATOM   2347  CG2 VAL   168      -0.663  26.963  26.637  1.00 26.18           C  
ATOM   2351  C   VAL   168       1.852  27.548  25.023  1.00 28.01           C  
ATOM   2352  O   VAL   168       2.143  27.336  23.839  1.00 27.90           O  
ATOM   2354  N   GLU   169       1.711  28.781  25.515  1.00 28.22           N  
ATOM   2355  CA  GLU   169       1.960  29.937  24.661  1.00 28.31           C  
ATOM   2357  CB  GLU   169       1.661  31.238  25.379  1.00 28.19           C  
ATOM   2360  CG  GLU   169       0.934  32.227  24.473  1.00 29.54           C  
ATOM   2363  CD  GLU   169       0.943  33.661  25.021  1.00 31.96           C  
ATOM   2364  OE1 GLU   169       1.714  33.912  26.000  1.00 34.14           O  
ATOM   2365  OE2 GLU   169       0.198  34.544  24.472  1.00 32.15           O  
ATOM   2366  C   GLU   169       3.388  29.963  24.101  1.00 28.30           C  
ATOM   2367  O   GLU   169       3.597  30.326  22.943  1.00 28.98           O  
ATOM   2369  N   MET   170       4.367  29.589  24.914  1.00 28.08           N  
ATOM   2370  CA  MET   170       5.754  29.551  24.453  1.00 28.04           C  
ATOM   2372  CB  MET   170       6.726  29.335  25.622  1.00 27.87           C  
ATOM   2375  CG  MET   170       7.074  30.615  26.367  1.00 28.33           C  
ATOM   2378  SD  MET   170       8.249  30.471  27.752  1.00 28.55           S  
ATOM   2379  CE  MET   170       7.214  29.683  28.987  1.00 27.96           C  
ATOM   2383  C   MET   170       5.940  28.468  23.400  1.00 28.13           C  
ATOM   2384  O   MET   170       6.505  28.715  22.348  1.00 28.20           O  
ATOM   2386  N   LEU   171       5.473  27.261  23.700  1.00 28.42           N  
ATOM   2387  CA  LEU   171       5.558  26.143  22.769  1.00 28.42           C  
ATOM   2389  CB  LEU   171       4.834  24.913  23.331  1.00 28.74           C  
ATOM   2392  CG  LEU   171       5.614  23.807  24.025  1.00 28.64           C  
ATOM   2394  CD1 LEU   171       4.612  22.730  24.485  1.00 27.77           C  
ATOM   2398  CD2 LEU   171       6.693  23.239  23.103  1.00 28.05           C  
ATOM   2402  C   LEU   171       4.911  26.485  21.439  1.00 28.37           C  
ATOM   2403  O   LEU   171       5.433  26.122  20.377  1.00 28.57           O  
ATOM   2405  N   LYS   172       3.753  27.142  21.499  1.00 28.00           N  
ATOM   2406  CA  LYS   172       3.012  27.463  20.274  1.00 27.85           C  
ATOM   2408  CB  LYS   172       1.593  28.000  20.576  1.00 27.67           C  
ATOM   2411  CG  LYS   172       0.523  26.888  20.684  1.00 27.83           C  
ATOM   2414  CD  LYS   172      -0.851  27.407  21.176  1.00 28.79           C  
ATOM   2417  CE  LYS   172      -1.973  26.373  20.896  1.00 29.34           C  
ATOM   2420  NZ  LYS   172      -2.428  26.347  19.368  1.00 29.31           N  
ATOM   2424  C   LYS   172       3.815  28.432  19.425  1.00 27.32           C  
ATOM   2425  O   LYS   172       3.942  28.266  18.218  1.00 27.26           O  
ATOM   2427  N   THR   173       4.380  29.432  20.074  1.00 27.30           N  
ATOM   2428  CA  THR   173       5.135  30.429  19.362  1.00 27.36           C  
ATOM   2430  CB  THR   173       5.501  31.639  20.254  1.00 26.82           C  
ATOM   2432  OG1 THR   173       6.315  32.503  19.498  1.00 28.03           O  
ATOM   2434  CG2 THR   173       6.295  31.285  21.426  1.00 26.84           C  
ATOM   2438  C   THR   173       6.353  29.769  18.728  1.00 27.39           C  
ATOM   2439  O   THR   173       6.729  30.102  17.611  1.00 27.65           O  
ATOM   2441  N   PHE   174       6.925  28.799  19.429  1.00 27.67           N  
ATOM   2442  CA  PHE   174       8.075  28.052  18.934  1.00 27.96           C  
ATOM   2444  CB  PHE   174       8.691  27.157  20.029  1.00 28.11           C  
ATOM   2447  CG  PHE   174       9.701  26.141  19.491  1.00 27.94           C  
ATOM   2448  CD1 PHE   174      11.002  26.527  19.174  1.00 26.47           C  
ATOM   2450  CE1 PHE   174      11.911  25.605  18.678  1.00 26.06           C  
ATOM   2452  CZ  PHE   174      11.523  24.288  18.477  1.00 25.76           C  
ATOM   2454  CE2 PHE   174      10.242  23.892  18.780  1.00 26.66           C  
ATOM   2456  CD2 PHE   174       9.334  24.807  19.287  1.00 27.84           C  
ATOM   2458  C   PHE   174       7.766  27.179  17.721  1.00 28.18           C  
ATOM   2459  O   PHE   174       8.631  27.024  16.863  1.00 28.86           O  
ATOM   2461  N   TYR   175       6.575  26.582  17.646  1.00 28.31           N  
ATOM   2462  CA  TYR   175       6.244  25.756  16.479  1.00 28.37           C  
ATOM   2464  CB  TYR   175       5.120  24.775  16.797  1.00 28.20           C  
ATOM   2467  CG  TYR   175       5.549  23.642  17.687  1.00 29.03           C  
ATOM   2468  CD1 TYR   175       4.708  23.182  18.704  1.00 29.68           C  
ATOM   2470  CE1 TYR   175       5.092  22.132  19.551  1.00 30.13           C  
ATOM   2472  CZ  TYR   175       6.344  21.524  19.369  1.00 30.83           C  
ATOM   2473  OH  TYR   175       6.716  20.480  20.195  1.00 33.11           O  
ATOM   2475  CE2 TYR   175       7.205  21.961  18.362  1.00 29.36           C  
ATOM   2477  CD2 TYR   175       6.801  23.013  17.521  1.00 29.43           C  
ATOM   2479  C   TYR   175       5.922  26.556  15.211  1.00 28.44           C  
ATOM   2480  O   TYR   175       5.590  25.962  14.192  1.00 28.62           O  
ATOM   2482  N   LYS   176       6.052  27.880  15.254  1.00 28.50           N  
ATOM   2483  CA  LYS   176       6.067  28.676  14.029  1.00 29.01           C  
ATOM   2485  CB  LYS   176       5.261  29.955  14.213  1.00 28.81           C  
ATOM   2488  CG  LYS   176       3.855  29.628  14.728  1.00 29.06           C  
ATOM   2491  CD  LYS   176       3.017  30.883  15.126  1.00 28.97           C  
ATOM   2494  CE  LYS   176       1.805  30.431  16.053  1.00 28.62           C  
ATOM   2497  NZ  LYS   176       0.966  31.639  16.480  1.00 28.07           N  
ATOM   2501  C   LYS   176       7.516  28.924  13.596  1.00 29.73           C  
ATOM   2502  O   LYS   176       8.033  30.071  13.612  1.00 29.38           O  
ATOM   2504  N   GLN   177       8.151  27.782  13.243  1.00 30.84           N  
ATOM   2505  CA  GLN   177       9.491  27.720  12.613  1.00 31.22           C  
ATOM   2507  CB  GLN   177      10.615  28.236  13.553  1.00 31.62           C  
ATOM   2510  CG  GLN   177      12.100  28.010  13.035  1.00 32.08           C  
ATOM   2513  CD  GLN   177      12.575  29.029  11.958  1.00 32.52           C  
ATOM   2514  OE1 GLN   177      12.497  30.261  12.160  1.00 31.81           O  
ATOM   2515  NE2 GLN   177      13.111  28.498  10.831  1.00 31.77           N  
ATOM   2518  C   GLN   177       9.731  26.249  12.215  1.00 30.80           C  
ATOM   2519  O   GLN   177       9.033  25.353  12.722  1.00 29.50           O  
END
