
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  168 ( 1326),  selected  168 , name 2nx8_A
# Molecule2: number of CA atoms  162 ( 1272),  selected  162 , name T0461.pdb
# PARAMETERS: 2nx8_A.T0461.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     6_A      E      16           -
LGA    F     7_A      N      17           -
LGA    L     8_A      L      18           -
LGA    M     9_A      Y      19           -
LGA    P    10_A      F      20          2.816
LGA    Y    11_A      Q      21          2.508
LGA    S    12_A      S      22          2.333
LGA    L    13_A      M      23          2.095
LGA    E    14_A      E      24          1.425
LGA    E    15_A      E      25          0.885
LGA    Q    16_A      T      26          0.840
LGA    T    17_A      E      27          1.046
LGA    Y    18_A      K      28          0.863
LGA    F    19_A      W      29          0.634
LGA    M    20_A      M      30          0.875
LGA    Q    21_A      E      31          1.121
LGA    E    22_A      E      32          1.132
LGA    A    23_A      A      33          0.972
LGA    L    24_A      M      34          1.191
LGA    K    25_A      H      35          1.718
LGA    E    26_A      M      36          1.634
LGA    S    27_A      A      37          0.943
LGA    E    28_A      K      38          1.702
LGA    K    29_A      E      39          2.097
LGA    S    30_A      A      40          1.336
LGA    L    31_A      L      41          0.743
LGA    Q    32_A      E      42          1.221
LGA    K    33_A      N      43          0.973
LGA    A    34_A      T      44          0.849
LGA    E    35_A      E      45          1.355
LGA    I    36_A      V      46          0.819
LGA    P    37_A      P      47          0.554
LGA    I    38_A      V      48          0.721
LGA    G    39_A      G      49          0.834
LGA    C    40_A      C      50          0.921
LGA    V    41_A      L      51          0.762
LGA    I    42_A      M      52          0.634
LGA    V    43_A      V      53          0.737
LGA    K    44_A      Y      54          0.772
LGA    D    45_A      N      55          1.463
LGA    G    46_A      N      56          2.128
LGA    E    47_A      E      57          1.945
LGA    I    48_A      V      58          1.360
LGA    I    49_A      V      59          0.786
LGA    G    50_A      G      60          0.449
LGA    R    51_A      K      61          0.528
LGA    G    52_A      G      62          0.583
LGA    H    53_A      R      63          0.675
LGA    N    54_A      N      64          0.761
LGA    A    55_A      E      65          1.043
LGA    R    56_A      V      66          0.435
LGA    E    57_A      N      67          0.843
LGA    E    58_A      Q      68          0.626
LGA    S    59_A      T      69          0.326
LGA    N    60_A      K      70          1.082
LGA    Q    61_A      N      71          1.202
LGA    A    62_A      A      72          1.537
LGA    I    63_A      T      73          0.934
LGA    M    64_A      R      74          0.459
LGA    H    65_A      H      75          0.320
LGA    A    66_A      A      76          0.438
LGA    E    67_A      E      77          0.414
LGA    M    68_A      M      78          0.408
LGA    M    69_A      V      79          0.376
LGA    A    70_A      A      80          0.628
LGA    I    71_A      I      81          0.799
LGA    N    72_A      D      82          0.727
LGA    E    73_A      Q      83          0.544
LGA    A    74_A      V      84          1.046
LGA    N    75_A      L      85          1.360
LGA    A    76_A      D      86          0.961
LGA    H    77_A      W      87          0.648
LGA    E    78_A      C      88          1.815
LGA    G    79_A      R      89          2.610
LGA    -       -      Q      90           -
LGA    -       -      S      91           -
LGA    -       -      G      92           -
LGA    -       -      K      93           -
LGA    N    80_A      S      94          3.912
LGA    W    81_A      P      95          3.537
LGA    R    82_A      S      96          2.521
LGA    -       -      E      97           -
LGA    -       -      V      98           -
LGA    L    83_A      F      99          0.817
LGA    L    84_A      E     100          1.471
LGA    D    85_A      H     101          0.678
LGA    T    86_A      T     102          0.613
LGA    T    87_A      V     103          0.135
LGA    L    88_A      L     104          0.246
LGA    F    89_A      Y     105          0.760
LGA    V    90_A      V     106          0.779
LGA    T    91_A      T     107          0.526
LGA    I    92_A      V     108          0.468
LGA    E    93_A      E     109          0.499
LGA    P    94_A      P     110          0.443
LGA    C    95_A      C     111          0.488
LGA    V    96_A      I     112          0.947
LGA    M    97_A      M     113          0.865
LGA    C    98_A      C     114          0.593
LGA    S    99_A      A     115          0.653
LGA    G   100_A      A     116          1.153
LGA    A   101_A      A     117          1.131
LGA    I   102_A      L     118          0.847
LGA    G   103_A      R     119          1.217
LGA    L   104_A      L     120          1.564
LGA    A   105_A      M     121          1.316
LGA    R   106_A      K     122          1.320
LGA    I   107_A      I     123          0.574
LGA    P   108_A      P     124          0.699
LGA    H   109_A      L     125          0.779
LGA    V   110_A      V     126          0.638
LGA    I   111_A      V     127          0.840
LGA    Y   112_A      Y     128          0.839
LGA    G   113_A      G     129          0.400
LGA    A   114_A      C     130          0.379
LGA    S   115_A      Q     131          0.787
LGA    N   116_A      N     132          0.655
LGA    Q   117_A      E     133          1.468
LGA    K   118_A      R     134          1.313
LGA    F   119_A      F     135          0.317
LGA    G   120_A      G     136          0.240
LGA    G   121_A      G     137          0.781
LGA    V   122_A      C     138          1.252
LGA    D   123_A      G     139          1.021
LGA    S   124_A      S     140          1.018
LGA    L   125_A      V     141          1.309
LGA    Y   126_A      L     142          1.326
LGA    Q   127_A      N     143          1.296
LGA    I   128_A      I     144          1.099
LGA    L   129_A      A     145          1.652
LGA    T   130_A      S     146          1.592
LGA    D   131_A      A     147          1.531
LGA    E   132_A      D     148          1.968
LGA    R   133_A      L     149          1.049
LGA    -       -      P     150           -
LGA    -       -      N     151           -
LGA    L   134_A      T     152          3.286
LGA    N   135_A      G     153          5.387
LGA    H   136_A      R     154          2.091
LGA    R   137_A      P     155          2.530
LGA    V   138_A      F     156          1.068
LGA    Q   139_A      Q     157          1.714
LGA    V   140_A      C     158          1.281
LGA    E   141_A      I     159          0.957
LGA    R   142_A      P     160          0.528
LGA    G   143_A      G     161          0.629
LGA    L   144_A      Y     162          1.009
LGA    L   145_A      R     163          1.388
LGA    A   146_A      A     164          0.990
LGA    A   147_A      E     165          1.440
LGA    D   148_A      E     166          1.773
LGA    C   149_A      A     167          1.266
LGA    A   150_A      V     168          1.302
LGA    N   151_A      E     169          1.842
LGA    I   152_A      M     170          1.677
LGA    M   153_A      L     171          1.482
LGA    Q   154_A      K     172          2.284
LGA    T   155_A      T     173          2.596
LGA    F   156_A      F     174          1.790
LGA    F   157_A      Y     175          2.701
LGA    R   158_A      K     176          3.810
LGA    Q   159_A      -       -           -
LGA    G   160_A      Q     177          2.252
LGA    R   161_A      -       -           -
LGA    E   162_A      -       -           -
LGA    R   163_A      -       -           -
LGA    K   164_A      -       -           -
LGA    K   165_A      -       -           -
LGA    I   166_A      -       -           -
LGA    A   167_A      -       -           -
LGA    K   168_A      -       -           -
LGA    H   169_A      -       -           -
LGA    L   170_A      -       -           -
LGA    I   171_A      -       -           -
LGA    K   172_A      -       -           -
LGA    E   173_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  168  162    5.0    150    1.43    33.33     87.413     9.783

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.924265 * X  +   0.362274 * Y  +   0.120380 * Z  +  -4.860586
  Y_new =  -0.286601 * X  +   0.866799 * Y  +  -0.408069 * Z  +  -0.947943
  Z_new =  -0.252178 * X  +   0.342663 * Y  +   0.904980 * Z  +  25.937149 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.361959   -2.779634  [ DEG:    20.7387   -159.2613 ]
  Theta =   0.254931    2.886662  [ DEG:    14.6064    165.3936 ]
  Phi   =  -0.300683    2.840909  [ DEG:   -17.2279    162.7721 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2nx8_A                                        
REMARK     2: T0461.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2nx8_A.T0461.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  168  162   5.0  150   1.43   33.33  87.413
REMARK  ---------------------------------------------------------- 
MOLECULE 2nx8_A
HEADER    HYDROLASE                               17-NOV-06   2NX8              
TITLE     THE CRYSTAL STRUCTURE OF THE TRNA-SPECIFIC ADENOSINE                  
TITLE    2 DEAMINASE FROM STREPTOCOCCUS PYOGENES                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRNA-SPECIFIC ADENOSINE DEAMINASE;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: HYPOTHETICAL PROTEIN M6_SPY0214;                            
COMPND   5 EC: 3.5.4.-;                                                         
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PYOGENES SEROTYPE M6;             
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: MGAS10394;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL 21 DE3;                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET 22B                                   
KEYWDS    TRNA, ADENOSINE, DEAMINASE, TAD, TAD, HYDROLASE                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.Y.HWANG,W.-H.LEE,Y.K.KIM                                            
REVDAT   1   21-AUG-07 2NX8    0                                                
JRNL        AUTH   W.-H.LEE,Y.K.KIM,K.H.NAM,A.PRIYADARSHI,E.H.LEE,              
JRNL        AUTH 2 E.E.KIM,Y.H.JEON,C.CHEONG,K.Y.HWANG                          
JRNL        TITL   CRYSTAL STRUCTURE OF THE TRNA-SPECIFIC ADENOSINE             
JRNL        TITL 2 DEAMINASE FROM STREPTOCOCCUS PYOGENES                        
JRNL        REF    PROTEINS                      V.  68  1016 2007              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2NX8 A    9   179  UNP    Q5XE14   Y214_STRP6       1    171             
SEQRES   1 A  179  MET GLU LEU GLY GLU SER PHE LEU MET PRO TYR SER LEU          
SEQRES   2 A  179  GLU GLU GLN THR TYR PHE MET GLN GLU ALA LEU LYS GLU          
SEQRES   3 A  179  SER GLU LYS SER LEU GLN LYS ALA GLU ILE PRO ILE GLY          
SEQRES   4 A  179  CYS VAL ILE VAL LYS ASP GLY GLU ILE ILE GLY ARG GLY          
SEQRES   5 A  179  HIS ASN ALA ARG GLU GLU SER ASN GLN ALA ILE MET HIS          
SEQRES   6 A  179  ALA GLU MET MET ALA ILE ASN GLU ALA ASN ALA HIS GLU          
SEQRES   7 A  179  GLY ASN TRP ARG LEU LEU ASP THR THR LEU PHE VAL THR          
SEQRES   8 A  179  ILE GLU PRO CYS VAL MET CYS SER GLY ALA ILE GLY LEU          
SEQRES   9 A  179  ALA ARG ILE PRO HIS VAL ILE TYR GLY ALA SER ASN GLN          
SEQRES  10 A  179  LYS PHE GLY GLY VAL ASP SER LEU TYR GLN ILE LEU THR          
SEQRES  11 A  179  ASP GLU ARG LEU ASN HIS ARG VAL GLN VAL GLU ARG GLY          
SEQRES  12 A  179  LEU LEU ALA ALA ASP CYS ALA ASN ILE MET GLN THR PHE          
SEQRES  13 A  179  PHE ARG GLN GLY ARG GLU ARG LYS LYS ILE ALA LYS HIS          
SEQRES  14 A  179  LEU ILE LYS GLU GLN SER ASP PRO PHE ASP                      
HET     ZN  A 999       1                                                       
HET    PO4  A2055       5                                                       
HETNAM      ZN ZINC ION                                                         
HETNAM     PO4 PHOSPHATE ION                                                    
FORMUL   2   ZN    ZN 2+                                                        
FORMUL   3  PO4    O4 P 3-                                                      
FORMUL   4  HOH   *138(H2 O)                                                    
CRYST1   80.091   80.091   81.104  90.00  90.00  90.00 P 42 21 2     8          
ATOM      1  N   SER A   6      -0.001   9.272  52.344  1.00 52.26           N  
ATOM      2  CA  SER A   6       0.232   8.804  50.945  1.00 51.84           C  
ATOM      3  C   SER A   6       0.771   9.942  50.078  1.00 50.31           C  
ATOM      4  O   SER A   6       1.948   9.958  49.720  1.00 50.45           O  
ATOM      5  CB  SER A   6      -1.074   8.276  50.347  1.00 53.67           C  
ATOM      6  OG  SER A   6      -0.875   7.814  49.022  1.00 55.18           O  
ATOM      7  N   PHE A   7      -0.097  10.894  49.748  1.00 47.96           N  
ATOM      8  CA  PHE A   7       0.288  12.038  48.926  1.00 45.94           C  
ATOM      9  C   PHE A   7       1.262  12.922  49.703  1.00 43.40           C  
ATOM     10  O   PHE A   7       0.933  13.412  50.777  1.00 43.41           O  
ATOM     11  CB  PHE A   7      -0.955  12.848  48.551  1.00 45.71           C  
ATOM     12  CG  PHE A   7      -0.694  13.928  47.547  1.00 45.81           C  
ATOM     13  CD1 PHE A   7      -0.667  13.639  46.188  1.00 45.98           C  
ATOM     14  CD2 PHE A   7      -0.466  15.237  47.959  1.00 45.07           C  
ATOM     15  CE1 PHE A   7      -0.418  14.637  45.251  1.00 46.18           C  
ATOM     16  CE2 PHE A   7      -0.214  16.241  47.031  1.00 46.01           C  
ATOM     17  CZ  PHE A   7      -0.190  15.940  45.675  1.00 45.50           C  
ATOM     18  N   LEU A   8       2.457  13.130  49.161  1.00 42.40           N  
ATOM     19  CA  LEU A   8       3.453  13.950  49.842  1.00 42.32           C  
ATOM     20  C   LEU A   8       3.458  15.408  49.393  1.00 41.43           C  
ATOM     21  O   LEU A   8       3.103  15.725  48.259  1.00 40.64           O  
ATOM     22  CB  LEU A   8       4.850  13.349  49.659  1.00 44.32           C  
ATOM     23  CG  LEU A   8       5.090  11.984  50.319  1.00 46.55           C  
ATOM     24  CD1 LEU A   8       6.509  11.515  50.021  1.00 45.54           C  
ATOM     25  CD2 LEU A   8       4.861  12.081  51.829  1.00 46.40           C  
ATOM     26  N   MET A   9       3.862  16.290  50.303  1.00 40.51           N  
ATOM     27  CA  MET A   9       3.921  17.722  50.032  1.00 38.47           C  
ATOM     28  C   MET A   9       5.165  18.325  50.672  1.00 35.96           C  
ATOM     29  O   MET A   9       5.085  19.049  51.661  1.00 36.20           O  
ATOM     30  CB  MET A   9       2.663  18.412  50.573  1.00 40.34           C  
ATOM     31  CG  MET A   9       1.360  17.859  49.988  1.00 43.58           C  
ATOM     32  SD  MET A   9      -0.131  18.661  50.634  1.00 49.36           S  
ATOM     33  CE  MET A   9      -1.225  18.623  49.202  1.00 49.34           C  
ATOM     34  N   PRO A  10       6.344  18.025  50.111  1.00 33.86           N  
ATOM     35  CA  PRO A  10       7.597  18.554  50.653  1.00 31.83           C  
ATOM     36  C   PRO A  10       7.737  20.066  50.484  1.00 30.91           C  
ATOM     37  O   PRO A  10       8.505  20.706  51.203  1.00 31.76           O  
ATOM     38  CB  PRO A  10       8.656  17.792  49.863  1.00 29.35           C  
ATOM     39  CG  PRO A  10       7.996  17.598  48.538  1.00 28.34           C  
ATOM     40  CD  PRO A  10       6.599  17.183  48.927  1.00 30.65           C  
ATOM     41  N   TYR A  11       6.986  20.637  49.545  1.00 29.46           N  
ATOM     42  CA  TYR A  11       7.081  22.069  49.279  1.00 26.89           C  
ATOM     43  C   TYR A  11       5.740  22.789  49.195  1.00 26.84           C  
ATOM     44  O   TYR A  11       4.748  22.237  48.726  1.00 26.06           O  
ATOM     45  CB  TYR A  11       7.847  22.289  47.976  1.00 26.59           C  
ATOM     46  CG  TYR A  11       9.175  21.571  47.938  1.00 26.16           C  
ATOM     47  CD1 TYR A  11      10.216  21.948  48.787  1.00 26.24           C  
ATOM     48  CD2 TYR A  11       9.372  20.476  47.097  1.00 25.74           C  
ATOM     49  CE1 TYR A  11      11.419  21.255  48.806  1.00 25.14           C  
ATOM     50  CE2 TYR A  11      10.578  19.765  47.105  1.00 25.68           C  
ATOM     51  CZ  TYR A  11      11.595  20.161  47.964  1.00 26.58           C  
ATOM     52  OH  TYR A  11      12.787  19.471  47.988  1.00 27.12           O  
ATOM     53  N   SER A  12       5.721  24.033  49.657  1.00 26.06           N  
ATOM     54  CA  SER A  12       4.507  24.835  49.597  1.00 27.29           C  
ATOM     55  C   SER A  12       4.266  25.198  48.132  1.00 27.53           C  
ATOM     56  O   SER A  12       5.107  24.929  47.266  1.00 27.15           O  
ATOM     57  CB  SER A  12       4.676  26.119  50.407  1.00 27.31           C  
ATOM     58  OG  SER A  12       5.734  26.903  49.880  1.00 25.24           O  
ATOM     59  N   LEU A  13       3.118  25.807  47.863  1.00 28.34           N  
ATOM     60  CA  LEU A  13       2.774  26.228  46.515  1.00 27.87           C  
ATOM     61  C   LEU A  13       3.730  27.339  46.061  1.00 27.63           C  
ATOM     62  O   LEU A  13       4.064  27.435  44.877  1.00 27.84           O  
ATOM     63  CB  LEU A  13       1.325  26.723  46.477  1.00 29.55           C  
ATOM     64  CG  LEU A  13       0.752  27.016  45.093  1.00 30.68           C  
ATOM     65  CD1 LEU A  13       0.797  25.747  44.257  1.00 31.82           C  
ATOM     66  CD2 LEU A  13      -0.673  27.521  45.218  1.00 30.40           C  
ATOM     67  N   GLU A  14       4.175  28.172  47.001  1.00 26.19           N  
ATOM     68  CA  GLU A  14       5.101  29.254  46.674  1.00 26.72           C  
ATOM     69  C   GLU A  14       6.466  28.681  46.310  1.00 26.70           C  
ATOM     70  O   GLU A  14       7.137  29.167  45.406  1.00 25.70           O  
ATOM     71  CB  GLU A  14       5.267  30.219  47.854  1.00 26.46           C  
ATOM     72  CG  GLU A  14       4.030  31.028  48.217  1.00 27.77           C  
ATOM     73  CD  GLU A  14       2.932  30.184  48.820  1.00 29.47           C  
ATOM     74  OE1 GLU A  14       3.238  29.268  49.621  1.00 30.10           O  
ATOM     75  OE2 GLU A  14       1.753  30.446  48.505  1.00 33.70           O  
ATOM     76  N   GLU A  15       6.888  27.664  47.048  1.00 26.80           N  
ATOM     77  CA  GLU A  15       8.163  27.031  46.774  1.00 26.39           C  
ATOM     78  C   GLU A  15       8.082  26.350  45.408  1.00 25.37           C  
ATOM     79  O   GLU A  15       8.997  26.473  44.591  1.00 24.72           O  
ATOM     80  CB  GLU A  15       8.484  26.021  47.874  1.00 28.82           C  
ATOM     81  CG  GLU A  15       8.573  26.679  49.247  1.00 30.98           C  
ATOM     82  CD  GLU A  15       8.891  25.708  50.366  1.00 29.65           C  
ATOM     83  OE1 GLU A  15       8.178  24.694  50.508  1.00 31.61           O  
ATOM     84  OE2 GLU A  15       9.851  25.971  51.115  1.00 28.96           O  
ATOM     85  N   GLN A  16       6.979  25.652  45.154  1.00 25.30           N  
ATOM     86  CA  GLN A  16       6.797  24.978  43.873  1.00 25.64           C  
ATOM     87  C   GLN A  16       6.816  26.001  42.743  1.00 25.35           C  
ATOM     88  O   GLN A  16       7.439  25.785  41.709  1.00 24.00           O  
ATOM     89  CB  GLN A  16       5.473  24.220  43.840  1.00 27.01           C  
ATOM     90  CG  GLN A  16       5.452  22.965  44.686  1.00 27.53           C  
ATOM     91  CD  GLN A  16       4.213  22.134  44.443  1.00 31.41           C  
ATOM     92  OE1 GLN A  16       3.899  21.227  45.214  1.00 35.09           O  
ATOM     93  NE2 GLN A  16       3.501  22.434  43.362  1.00 31.50           N  
ATOM     94  N   THR A  17       6.131  27.120  42.953  1.00 24.99           N  
ATOM     95  CA  THR A  17       6.080  28.170  41.951  1.00 22.43           C  
ATOM     96  C   THR A  17       7.486  28.680  41.663  1.00 22.87           C  
ATOM     97  O   THR A  17       7.845  28.904  40.508  1.00 24.98           O  
ATOM     98  CB  THR A  17       5.188  29.340  42.420  1.00 24.28           C  
ATOM     99  OG1 THR A  17       3.852  28.863  42.630  1.00 24.62           O  
ATOM    100  CG2 THR A  17       5.158  30.448  41.371  1.00 19.69           C  
ATOM    101  N   TYR A  18       8.285  28.858  42.710  1.00 21.05           N  
ATOM    102  CA  TYR A  18       9.653  29.331  42.532  1.00 21.83           C  
ATOM    103  C   TYR A  18      10.431  28.391  41.608  1.00 23.47           C  
ATOM    104  O   TYR A  18      11.092  28.832  40.666  1.00 23.06           O  
ATOM    105  CB  TYR A  18      10.383  29.417  43.877  1.00 20.22           C  
ATOM    106  CG  TYR A  18      11.872  29.661  43.722  1.00 21.87           C  
ATOM    107  CD1 TYR A  18      12.357  30.894  43.287  1.00 21.67           C  
ATOM    108  CD2 TYR A  18      12.788  28.627  43.913  1.00 23.20           C  
ATOM    109  CE1 TYR A  18      13.716  31.087  43.036  1.00 22.66           C  
ATOM    110  CE2 TYR A  18      14.147  28.810  43.660  1.00 21.68           C  
ATOM    111  CZ  TYR A  18      14.603  30.036  43.221  1.00 23.19           C  
ATOM    112  OH  TYR A  18      15.945  30.207  42.945  1.00 25.07           O  
ATOM    113  N   PHE A  19      10.344  27.093  41.892  1.00 23.93           N  
ATOM    114  CA  PHE A  19      11.048  26.076  41.118  1.00 22.63           C  
ATOM    115  C   PHE A  19      10.573  25.979  39.668  1.00 22.37           C  
ATOM    116  O   PHE A  19      11.383  25.814  38.764  1.00 24.07           O  
ATOM    117  CB  PHE A  19      10.931  24.717  41.815  1.00 19.15           C  
ATOM    118  CG  PHE A  19      11.598  24.662  43.166  1.00 17.93           C  
ATOM    119  CD1 PHE A  19      12.920  25.057  43.320  1.00 19.99           C  
ATOM    120  CD2 PHE A  19      10.916  24.168  44.273  1.00 19.61           C  
ATOM    121  CE1 PHE A  19      13.558  24.957  44.560  1.00 20.82           C  
ATOM    122  CE2 PHE A  19      11.541  24.062  45.515  1.00 20.20           C  
ATOM    123  CZ  PHE A  19      12.868  24.458  45.658  1.00 19.55           C  
ATOM    124  N   MET A  20       9.267  26.075  39.438  1.00 22.82           N  
ATOM    125  CA  MET A  20       8.762  26.018  38.070  1.00 22.06           C  
ATOM    126  C   MET A  20       9.208  27.271  37.308  1.00 23.58           C  
ATOM    127  O   MET A  20       9.503  27.211  36.111  1.00 22.94           O  
ATOM    128  CB  MET A  20       7.235  25.905  38.047  1.00 20.29           C  
ATOM    129  CG  MET A  20       6.675  25.643  36.655  1.00 21.07           C  
ATOM    130  SD  MET A  20       7.332  24.086  35.955  1.00 23.29           S  
ATOM    131  CE  MET A  20       6.153  22.921  36.571  1.00 20.41           C  
ATOM    132  N   GLN A  21       9.261  28.406  37.999  1.00 22.94           N  
ATOM    133  CA  GLN A  21       9.705  29.633  37.353  1.00 24.20           C  
ATOM    134  C   GLN A  21      11.182  29.483  37.003  1.00 22.98           C  
ATOM    135  O   GLN A  21      11.648  30.033  36.010  1.00 23.53           O  
ATOM    136  CB  GLN A  21       9.479  30.842  38.263  1.00 24.31           C  
ATOM    137  CG  GLN A  21       8.010  31.094  38.527  1.00 27.40           C  
ATOM    138  CD  GLN A  21       7.745  32.354  39.324  1.00 27.96           C  
ATOM    139  OE1 GLN A  21       8.474  32.684  40.261  1.00 29.32           O  
ATOM    140  NE2 GLN A  21       6.677  33.054  38.968  1.00 29.52           N  
ATOM    141  N   GLU A  22      11.914  28.739  37.826  1.00 22.78           N  
ATOM    142  CA  GLU A  22      13.325  28.492  37.548  1.00 24.38           C  
ATOM    143  C   GLU A  22      13.410  27.623  36.291  1.00 23.17           C  
ATOM    144  O   GLU A  22      14.321  27.781  35.485  1.00 25.17           O  
ATOM    145  CB  GLU A  22      14.007  27.772  38.719  1.00 24.17           C  
ATOM    146  CG  GLU A  22      14.411  28.674  39.881  1.00 26.86           C  
ATOM    147  CD  GLU A  22      15.341  29.810  39.464  1.00 30.93           C  
ATOM    148  OE1 GLU A  22      16.510  29.541  39.113  1.00 29.84           O  
ATOM    149  OE2 GLU A  22      14.895  30.980  39.486  1.00 31.46           O  
ATOM    150  N   ALA A  23      12.455  26.709  36.127  1.00 22.23           N  
ATOM    151  CA  ALA A  23      12.433  25.831  34.955  1.00 21.74           C  
ATOM    152  C   ALA A  23      12.032  26.647  33.729  1.00 23.12           C  
ATOM    153  O   ALA A  23      12.447  26.347  32.604  1.00 21.37           O  
ATOM    154  CB  ALA A  23      11.453  24.679  35.166  1.00 19.59           C  
ATOM    155  N   LEU A  24      11.219  27.681  33.947  1.00 22.09           N  
ATOM    156  CA  LEU A  24      10.800  28.545  32.850  1.00 21.38           C  
ATOM    157  C   LEU A  24      11.998  29.367  32.401  1.00 20.68           C  
ATOM    158  O   LEU A  24      12.138  29.682  31.218  1.00 21.49           O  
ATOM    159  CB  LEU A  24       9.647  29.453  33.283  1.00 21.23           C  
ATOM    160  CG  LEU A  24       8.263  28.810  33.127  1.00 21.40           C  
ATOM    161  CD1 LEU A  24       7.210  29.622  33.881  1.00 23.23           C  
ATOM    162  CD2 LEU A  24       7.914  28.722  31.643  1.00 19.48           C  
ATOM    163  N   LYS A  25      12.872  29.705  33.345  1.00 21.36           N  
ATOM    164  CA  LYS A  25      14.075  30.457  32.996  1.00 22.91           C  
ATOM    165  C   LYS A  25      14.977  29.554  32.147  1.00 24.81           C  
ATOM    166  O   LYS A  25      15.716  30.033  31.286  1.00 26.97           O  
ATOM    167  CB  LYS A  25      14.822  30.913  34.249  1.00 23.40           C  
ATOM    168  CG  LYS A  25      14.089  31.978  35.063  1.00 28.09           C  
ATOM    169  CD  LYS A  25      14.881  32.370  36.307  1.00 27.45           C  
ATOM    170  CE  LYS A  25      14.115  33.359  37.172  1.00 28.57           C  
ATOM    171  NZ  LYS A  25      14.882  33.682  38.413  1.00 30.41           N  
ATOM    172  N   GLU A  26      14.927  28.247  32.394  1.00 24.17           N  
ATOM    173  CA  GLU A  26      15.727  27.318  31.601  1.00 25.36           C  
ATOM    174  C   GLU A  26      15.097  27.276  30.220  1.00 25.85           C  
ATOM    175  O   GLU A  26      15.782  27.213  29.205  1.00 28.08           O  
ATOM    176  CB  GLU A  26      15.720  25.918  32.218  1.00 24.37           C  
ATOM    177  CG  GLU A  26      16.581  25.788  33.457  1.00 25.52           C  
ATOM    178  CD  GLU A  26      18.005  26.278  33.227  1.00 29.60           C  
ATOM    179  OE1 GLU A  26      18.641  25.857  32.237  1.00 33.94           O  
ATOM    180  OE2 GLU A  26      18.493  27.081  34.041  1.00 32.35           O  
ATOM    181  N   SER A  27      13.773  27.330  30.208  1.00 26.99           N  
ATOM    182  CA  SER A  27      12.984  27.307  28.991  1.00 28.53           C  
ATOM    183  C   SER A  27      13.346  28.494  28.098  1.00 30.11           C  
ATOM    184  O   SER A  27      13.367  28.379  26.869  1.00 29.75           O  
ATOM    185  CB  SER A  27      11.504  27.352  29.366  1.00 28.50           C  
ATOM    186  OG  SER A  27      10.702  26.748  28.375  1.00 34.77           O  
ATOM    187  N   GLU A  28      13.641  29.634  28.722  1.00 32.48           N  
ATOM    188  CA  GLU A  28      14.008  30.838  27.983  1.00 33.32           C  
ATOM    189  C   GLU A  28      15.344  30.663  27.262  1.00 33.48           C  
ATOM    190  O   GLU A  28      15.570  31.268  26.214  1.00 33.54           O  
ATOM    191  CB  GLU A  28      14.086  32.043  28.929  1.00 36.52           C  
ATOM    192  CG  GLU A  28      12.795  32.324  29.681  1.00 42.19           C  
ATOM    193  CD  GLU A  28      12.905  33.501  30.644  1.00 46.98           C  
ATOM    194  OE1 GLU A  28      13.874  33.546  31.440  1.00 47.71           O  
ATOM    195  OE2 GLU A  28      12.013  34.376  30.612  1.00 47.91           O  
ATOM    196  N   LYS A  29      16.230  29.845  27.826  1.00 33.93           N  
ATOM    197  CA  LYS A  29      17.534  29.603  27.207  1.00 33.81           C  
ATOM    198  C   LYS A  29      17.338  28.922  25.856  1.00 32.98           C  
ATOM    199  O   LYS A  29      17.972  29.290  24.874  1.00 31.49           O  
ATOM    200  CB  LYS A  29      18.412  28.717  28.098  1.00 34.66           C  
ATOM    201  CG  LYS A  29      18.683  29.260  29.497  1.00 35.85           C  
ATOM    202  CD  LYS A  29      19.723  28.397  30.209  1.00 36.02           C  
ATOM    203  CE  LYS A  29      19.734  28.617  31.714  1.00 37.50           C  
ATOM    204  NZ  LYS A  29      20.049  30.015  32.099  1.00 40.46           N  
ATOM    205  N   SER A  30      16.459  27.926  25.816  1.00 32.74           N  
ATOM    206  CA  SER A  30      16.177  27.211  24.576  1.00 33.29           C  
ATOM    207  C   SER A  30      15.551  28.156  23.547  1.00 34.10           C  
ATOM    208  O   SER A  30      15.949  28.168  22.378  1.00 35.00           O  
ATOM    209  CB  SER A  30      15.225  26.039  24.837  1.00 32.78           C  
ATOM    210  OG  SER A  30      15.806  25.095  25.718  1.00 33.23           O  
ATOM    211  N   LEU A  31      14.567  28.940  23.984  1.00 33.96           N  
ATOM    212  CA  LEU A  31      13.893  29.888  23.100  1.00 33.34           C  
ATOM    213  C   LEU A  31      14.912  30.785  22.406  1.00 33.43           C  
ATOM    214  O   LEU A  31      14.900  30.929  21.185  1.00 32.68           O  
ATOM    215  CB  LEU A  31      12.917  30.767  23.894  1.00 31.83           C  
ATOM    216  CG  LEU A  31      12.055  31.713  23.047  1.00 30.58           C  
ATOM    217  CD1 LEU A  31      11.112  30.886  22.196  1.00 28.30           C  
ATOM    218  CD2 LEU A  31      11.266  32.661  23.935  1.00 28.23           C  
ATOM    219  N   GLN A  32      15.791  31.382  23.202  1.00 35.17           N  
ATOM    220  CA  GLN A  32      16.819  32.279  22.696  1.00 38.55           C  
ATOM    221  C   GLN A  32      17.711  31.602  21.666  1.00 41.03           C  
ATOM    222  O   GLN A  32      18.272  32.267  20.792  1.00 40.96           O  
ATOM    223  CB  GLN A  32      17.663  32.802  23.862  1.00 40.34           C  
ATOM    224  CG  GLN A  32      16.882  33.697  24.820  1.00 45.98           C  
ATOM    225  CD  GLN A  32      17.571  33.886  26.166  1.00 50.18           C  
ATOM    226  OE1 GLN A  32      17.093  34.641  27.020  1.00 52.27           O  
ATOM    227  NE2 GLN A  32      18.695  33.197  26.366  1.00 51.51           N  
ATOM    228  N   LYS A  33      17.838  30.281  21.767  1.00 41.36           N  
ATOM    229  CA  LYS A  33      18.667  29.521  20.838  1.00 41.72           C  
ATOM    230  C   LYS A  33      17.834  28.875  19.741  1.00 40.66           C  
ATOM    231  O   LYS A  33      18.291  27.964  19.053  1.00 40.67           O  
ATOM    232  CB  LYS A  33      19.456  28.459  21.598  1.00 43.41           C  
ATOM    233  CG  LYS A  33      20.389  29.056  22.644  1.00 47.03           C  
ATOM    234  CD  LYS A  33      20.999  27.984  23.524  1.00 50.28           C  
ATOM    235  CE  LYS A  33      21.787  27.004  22.684  1.00 53.74           C  
ATOM    236  NZ  LYS A  33      22.827  27.706  21.874  1.00 55.91           N  
ATOM    237  N   ALA A  34      16.607  29.358  19.589  1.00 39.48           N  
ATOM    238  CA  ALA A  34      15.693  28.864  18.569  1.00 38.71           C  
ATOM    239  C   ALA A  34      15.364  27.379  18.700  1.00 37.80           C  
ATOM    240  O   ALA A  34      15.295  26.662  17.703  1.00 38.33           O  
ATOM    241  CB  ALA A  34      16.263  29.152  17.185  1.00 38.59           C  
ATOM    242  N   GLU A  35      15.155  26.923  19.930  1.00 37.46           N  
ATOM    243  CA  GLU A  35      14.811  25.526  20.178  1.00 34.71           C  
ATOM    244  C   GLU A  35      13.553  25.426  21.022  1.00 32.48           C  
ATOM    245  O   GLU A  35      13.167  26.394  21.678  1.00 30.63           O  
ATOM    246  CB  GLU A  35      15.976  24.814  20.860  1.00 35.14           C  
ATOM    247  CG  GLU A  35      17.219  24.788  19.977  1.00 37.32           C  
ATOM    248  CD  GLU A  35      18.135  23.629  20.278  1.00 34.99           C  
ATOM    249  OE1 GLU A  35      19.272  23.882  20.722  1.00 36.08           O  
ATOM    250  OE2 GLU A  35      17.712  22.470  20.068  1.00 34.07           O  
ATOM    251  N   ILE A  36      12.905  24.267  20.984  1.00 31.56           N  
ATOM    252  CA  ILE A  36      11.679  24.052  21.748  1.00 31.15           C  
ATOM    253  C   ILE A  36      11.933  24.572  23.160  1.00 29.33           C  
ATOM    254  O   ILE A  36      12.804  24.070  23.865  1.00 28.46           O  
ATOM    255  CB  ILE A  36      11.314  22.559  21.819  1.00 33.97           C  
ATOM    256  CG1 ILE A  36      11.395  21.925  20.427  1.00 36.06           C  
ATOM    257  CG2 ILE A  36       9.907  22.401  22.375  1.00 33.33           C  
ATOM    258  CD1 ILE A  36      10.207  22.214  19.531  1.00 39.81           C  
ATOM    259  N   PRO A  37      11.182  25.604  23.579  1.00 26.88           N  
ATOM    260  CA  PRO A  37      11.337  26.197  24.905  1.00 25.89           C  
ATOM    261  C   PRO A  37      10.749  25.381  26.058  1.00 25.79           C  
ATOM    262  O   PRO A  37       9.640  25.656  26.532  1.00 25.23           O  
ATOM    263  CB  PRO A  37      10.665  27.557  24.743  1.00 26.18           C  
ATOM    264  CG  PRO A  37       9.529  27.234  23.833  1.00 22.79           C  
ATOM    265  CD  PRO A  37      10.178  26.343  22.792  1.00 25.37           C  
ATOM    266  N   ILE A  38      11.504  24.376  26.493  1.00 23.21           N  
ATOM    267  CA  ILE A  38      11.114  23.520  27.609  1.00 22.09           C  
ATOM    268  C   ILE A  38      12.272  23.531  28.600  1.00 21.52           C  
ATOM    269  O   ILE A  38      13.428  23.376  28.212  1.00 22.62           O  
ATOM    270  CB  ILE A  38      10.839  22.064  27.151  1.00 23.10           C  
ATOM    271  CG1 ILE A  38       9.590  22.032  26.273  1.00 22.97           C  
ATOM    272  CG2 ILE A  38      10.656  21.149  28.362  1.00 20.49           C  
ATOM    273  CD1 ILE A  38       9.231  20.662  25.773  1.00 23.99           C  
ATOM    274  N   GLY A  39      11.959  23.737  29.877  1.00 20.20           N  
ATOM    275  CA  GLY A  39      12.993  23.774  30.893  1.00 18.17           C  
ATOM    276  C   GLY A  39      12.708  22.788  32.008  1.00 17.44           C  
ATOM    277  O   GLY A  39      11.573  22.329  32.169  1.00 17.30           O  
ATOM    278  N   CYS A  40      13.733  22.470  32.791  1.00 15.84           N  
ATOM    279  CA  CYS A  40      13.565  21.515  33.878  1.00 16.64           C  
ATOM    280  C   CYS A  40      14.505  21.763  35.041  1.00 18.13           C  
ATOM    281  O   CYS A  40      15.653  22.178  34.852  1.00 17.33           O  
ATOM    282  CB  CYS A  40      13.791  20.083  33.350  1.00 18.15           C  
ATOM    283  SG  CYS A  40      13.674  18.766  34.594  1.00 20.20           S  
ATOM    284  N   VAL A  41      14.009  21.544  36.253  1.00 16.75           N  
ATOM    285  CA  VAL A  41      14.875  21.657  37.416  1.00 18.83           C  
ATOM    286  C   VAL A  41      14.567  20.489  38.334  1.00 19.00           C  
ATOM    287  O   VAL A  41      13.407  20.068  38.469  1.00 19.43           O  
ATOM    288  CB  VAL A  41      14.720  22.994  38.201  1.00 19.78           C  
ATOM    289  CG1 VAL A  41      14.935  24.168  37.267  1.00 21.53           C  
ATOM    290  CG2 VAL A  41      13.386  23.055  38.892  1.00 20.01           C  
ATOM    291  N   ILE A  42      15.620  19.943  38.929  1.00 19.85           N  
ATOM    292  CA  ILE A  42      15.486  18.826  39.852  1.00 21.21           C  
ATOM    293  C   ILE A  42      15.877  19.333  41.233  1.00 19.84           C  
ATOM    294  O   ILE A  42      16.955  19.902  41.419  1.00 20.58           O  
ATOM    295  CB  ILE A  42      16.381  17.649  39.427  1.00 19.60           C  
ATOM    296  CG1 ILE A  42      15.853  17.063  38.115  1.00 20.52           C  
ATOM    297  CG2 ILE A  42      16.421  16.604  40.520  1.00 17.32           C  
ATOM    298  CD1 ILE A  42      16.658  15.887  37.587  1.00 22.36           C  
ATOM    299  N   VAL A  43      14.995  19.116  42.199  1.00 21.93           N  
ATOM    300  CA  VAL A  43      15.208  19.610  43.553  1.00 22.15           C  
ATOM    301  C   VAL A  43      15.402  18.537  44.614  1.00 24.51           C  
ATOM    302  O   VAL A  43      14.715  17.519  44.621  1.00 25.72           O  
ATOM    303  CB  VAL A  43      14.013  20.504  43.978  1.00 22.32           C  
ATOM    304  CG1 VAL A  43      14.200  21.008  45.405  1.00 23.07           C  
ATOM    305  CG2 VAL A  43      13.870  21.673  43.008  1.00 20.16           C  
ATOM    306  N   LYS A  44      16.352  18.786  45.511  1.00 26.77           N  
ATOM    307  CA  LYS A  44      16.627  17.884  46.618  1.00 27.70           C  
ATOM    308  C   LYS A  44      16.765  18.703  47.890  1.00 27.81           C  
ATOM    309  O   LYS A  44      17.583  19.620  47.960  1.00 27.81           O  
ATOM    310  CB  LYS A  44      17.911  17.085  46.392  1.00 27.97           C  
ATOM    311  CG  LYS A  44      18.184  16.123  47.535  1.00 32.51           C  
ATOM    312  CD  LYS A  44      19.209  15.067  47.180  1.00 35.52           C  
ATOM    313  CE  LYS A  44      19.281  14.015  48.279  1.00 36.67           C  
ATOM    314  NZ  LYS A  44      19.980  12.784  47.807  1.00 41.25           N  
ATOM    315  N   ASP A  45      15.968  18.358  48.892  1.00 29.01           N  
ATOM    316  CA  ASP A  45      15.981  19.059  50.171  1.00 32.79           C  
ATOM    317  C   ASP A  45      15.793  20.559  49.972  1.00 31.79           C  
ATOM    318  O   ASP A  45      16.503  21.360  50.575  1.00 31.64           O  
ATOM    319  CB  ASP A  45      17.299  18.816  50.917  1.00 35.73           C  
ATOM    320  CG  ASP A  45      17.545  17.349  51.213  1.00 40.10           C  
ATOM    321  OD1 ASP A  45      16.657  16.694  51.804  1.00 41.10           O  
ATOM    322  OD2 ASP A  45      18.637  16.855  50.857  1.00 41.52           O  
ATOM    323  N   GLY A  46      14.852  20.934  49.111  1.00 31.36           N  
ATOM    324  CA  GLY A  46      14.596  22.343  48.876  1.00 30.63           C  
ATOM    325  C   GLY A  46      15.654  23.071  48.073  1.00 30.17           C  
ATOM    326  O   GLY A  46      15.617  24.297  47.966  1.00 30.34           O  
ATOM    327  N   GLU A  47      16.602  22.331  47.512  1.00 29.32           N  
ATOM    328  CA  GLU A  47      17.652  22.939  46.705  1.00 30.09           C  
ATOM    329  C   GLU A  47      17.737  22.314  45.317  1.00 30.30           C  
ATOM    330  O   GLU A  47      17.683  21.089  45.161  1.00 29.21           O  
ATOM    331  CB  GLU A  47      19.014  22.807  47.392  1.00 32.84           C  
ATOM    332  CG  GLU A  47      19.134  23.573  48.698  1.00 39.20           C  
ATOM    333  CD  GLU A  47      20.535  23.517  49.283  1.00 43.32           C  
ATOM    334  OE1 GLU A  47      20.790  24.214  50.287  1.00 45.83           O  
ATOM    335  OE2 GLU A  47      21.383  22.773  48.739  1.00 47.46           O  
ATOM    336  N   ILE A  48      17.862  23.164  44.305  1.00 28.49           N  
ATOM    337  CA  ILE A  48      17.984  22.689  42.939  1.00 27.81           C  
ATOM    338  C   ILE A  48      19.371  22.057  42.784  1.00 26.82           C  
ATOM    339  O   ILE A  48      20.387  22.690  43.071  1.00 25.87           O  
ATOM    340  CB  ILE A  48      17.827  23.853  41.934  1.00 28.11           C  
ATOM    341  CG1 ILE A  48      16.381  24.369  41.970  1.00 26.71           C  
ATOM    342  CG2 ILE A  48      18.231  23.395  40.526  1.00 26.71           C  
ATOM    343  CD1 ILE A  48      16.117  25.556  41.037  1.00 27.45           C  
ATOM    344  N   ILE A  49      19.403  20.804  42.338  1.00 26.96           N  
ATOM    345  CA  ILE A  49      20.662  20.087  42.148  1.00 24.42           C  
ATOM    346  C   ILE A  49      20.914  19.787  40.675  1.00 24.34           C  
ATOM    347  O   ILE A  49      21.973  19.278  40.306  1.00 23.55           O  
ATOM    348  CB  ILE A  49      20.675  18.764  42.939  1.00 23.98           C  
ATOM    349  CG1 ILE A  49      19.457  17.917  42.566  1.00 24.84           C  
ATOM    350  CG2 ILE A  49      20.676  19.053  44.443  1.00 20.99           C  
ATOM    351  CD1 ILE A  49      19.520  16.484  43.092  1.00 23.23           C  
ATOM    352  N   GLY A  50      19.936  20.116  39.835  1.00 24.73           N  
ATOM    353  CA  GLY A  50      20.073  19.884  38.412  1.00 22.19           C  
ATOM    354  C   GLY A  50      19.178  20.784  37.586  1.00 23.27           C  
ATOM    355  O   GLY A  50      18.012  20.993  37.923  1.00 24.21           O  
ATOM    356  N   ARG A  51      19.727  21.316  36.499  1.00 23.19           N  
ATOM    357  CA  ARG A  51      18.984  22.195  35.600  1.00 23.27           C  
ATOM    358  C   ARG A  51      19.150  21.706  34.168  1.00 22.12           C  
ATOM    359  O   ARG A  51      20.178  21.141  33.813  1.00 22.44           O  
ATOM    360  CB  ARG A  51      19.516  23.628  35.674  1.00 23.45           C  
ATOM    361  CG  ARG A  51      19.324  24.323  37.000  1.00 23.66           C  
ATOM    362  CD  ARG A  51      20.011  25.678  36.990  1.00 22.79           C  
ATOM    363  NE  ARG A  51      20.025  26.270  38.320  1.00 30.02           N  
ATOM    364  CZ  ARG A  51      19.033  26.984  38.837  1.00 31.77           C  
ATOM    365  NH1 ARG A  51      17.934  27.211  38.134  1.00 32.73           N  
ATOM    366  NH2 ARG A  51      19.139  27.462  40.067  1.00 34.32           N  
ATOM    367  N   GLY A  52      18.137  21.936  33.346  1.00 22.70           N  
ATOM    368  CA  GLY A  52      18.218  21.530  31.962  1.00 23.65           C  
ATOM    369  C   GLY A  52      17.224  22.255  31.080  1.00 24.22           C  
ATOM    370  O   GLY A  52      16.219  22.787  31.555  1.00 25.40           O  
ATOM    371  N   HIS A  53      17.524  22.283  29.788  1.00 23.99           N  
ATOM    372  CA  HIS A  53      16.666  22.901  28.790  1.00 24.51           C  
ATOM    373  C   HIS A  53      16.913  22.138  27.493  1.00 23.76           C  
ATOM    374  O   HIS A  53      17.958  21.517  27.338  1.00 23.81           O  
ATOM    375  CB  HIS A  53      17.014  24.384  28.607  1.00 24.65           C  
ATOM    376  CG  HIS A  53      18.438  24.631  28.216  1.00 25.53           C  
ATOM    377  ND1 HIS A  53      19.474  24.631  29.127  1.00 28.51           N  
ATOM    378  CD2 HIS A  53      19.001  24.876  27.007  1.00 25.75           C  
ATOM    379  CE1 HIS A  53      20.613  24.864  28.497  1.00 27.63           C  
ATOM    380  NE2 HIS A  53      20.353  25.016  27.210  1.00 27.73           N  
ATOM    381  N   ASN A  54      15.955  22.158  26.575  1.00 24.47           N  
ATOM    382  CA  ASN A  54      16.133  21.457  25.311  1.00 27.23           C  
ATOM    383  C   ASN A  54      17.271  22.094  24.519  1.00 27.71           C  
ATOM    384  O   ASN A  54      17.314  23.320  24.360  1.00 28.75           O  
ATOM    385  CB  ASN A  54      14.846  21.487  24.482  1.00 28.54           C  
ATOM    386  CG  ASN A  54      13.826  20.458  24.940  1.00 30.78           C  
ATOM    387  OD1 ASN A  54      12.964  20.036  24.167  1.00 36.26           O  
ATOM    388  ND2 ASN A  54      13.914  20.056  26.197  1.00 32.93           N  
ATOM    389  N   ALA A  55      18.188  21.263  24.028  1.00 26.71           N  
ATOM    390  CA  ALA A  55      19.332  21.742  23.256  1.00 27.24           C  
ATOM    391  C   ALA A  55      19.771  20.735  22.197  1.00 28.79           C  
ATOM    392  O   ALA A  55      20.961  20.571  21.942  1.00 28.78           O  
ATOM    393  CB  ALA A  55      20.495  22.048  24.187  1.00 26.01           C  
ATOM    394  N   ARG A  56      18.796  20.074  21.586  1.00 30.45           N  
ATOM    395  CA  ARG A  56      19.028  19.078  20.546  1.00 33.92           C  
ATOM    396  C   ARG A  56      19.832  19.626  19.367  1.00 34.85           C  
ATOM    397  O   ARG A  56      20.835  19.035  18.959  1.00 34.44           O  
ATOM    398  CB  ARG A  56      17.684  18.560  20.032  1.00 37.84           C  
ATOM    399  CG  ARG A  56      17.781  17.525  18.930  1.00 41.55           C  
ATOM    400  CD  ARG A  56      16.460  17.395  18.179  1.00 46.49           C  
ATOM    401  NE  ARG A  56      16.188  18.557  17.332  1.00 49.47           N  
ATOM    402  CZ  ARG A  56      15.134  18.669  16.526  1.00 52.31           C  
ATOM    403  NH1 ARG A  56      14.969  19.765  15.789  1.00 52.92           N  
ATOM    404  NH2 ARG A  56      14.240  17.690  16.454  1.00 53.75           N  
ATOM    405  N   GLU A  57      19.387  20.752  18.815  1.00 34.44           N  
ATOM    406  CA  GLU A  57      20.065  21.352  17.672  1.00 35.38           C  
ATOM    407  C   GLU A  57      21.465  21.832  18.004  1.00 35.17           C  
ATOM    408  O   GLU A  57      22.404  21.597  17.247  1.00 35.04           O  
ATOM    409  CB  GLU A  57      19.253  22.518  17.112  1.00 39.47           C  
ATOM    410  CG  GLU A  57      17.993  22.115  16.360  1.00 43.49           C  
ATOM    411  CD  GLU A  57      18.278  21.180  15.199  1.00 46.26           C  
ATOM    412  OE1 GLU A  57      19.376  21.272  14.608  1.00 47.68           O  
ATOM    413  OE2 GLU A  57      17.394  20.359  14.865  1.00 48.00           O  
ATOM    414  N   GLU A  58      21.613  22.502  19.137  1.00 35.02           N  
ATOM    415  CA  GLU A  58      22.921  23.004  19.530  1.00 35.04           C  
ATOM    416  C   GLU A  58      23.915  21.886  19.838  1.00 33.07           C  
ATOM    417  O   GLU A  58      25.077  21.957  19.445  1.00 32.28           O  
ATOM    418  CB  GLU A  58      22.803  23.912  20.756  1.00 37.69           C  
ATOM    419  CG  GLU A  58      24.151  24.385  21.278  1.00 44.02           C  
ATOM    420  CD  GLU A  58      24.058  25.043  22.639  1.00 47.73           C  
ATOM    421  OE1 GLU A  58      23.528  24.407  23.577  1.00 50.61           O  
ATOM    422  OE2 GLU A  58      24.517  26.197  22.774  1.00 50.51           O  
ATOM    423  N   SER A  59      23.452  20.858  20.544  1.00 31.73           N  
ATOM    424  CA  SER A  59      24.321  19.754  20.936  1.00 31.04           C  
ATOM    425  C   SER A  59      24.427  18.649  19.899  1.00 30.90           C  
ATOM    426  O   SER A  59      25.324  17.811  19.977  1.00 32.62           O  
ATOM    427  CB  SER A  59      23.837  19.145  22.256  1.00 30.30           C  
ATOM    428  OG  SER A  59      22.611  18.448  22.084  1.00 29.10           O  
ATOM    429  N   ASN A  60      23.517  18.647  18.932  1.00 31.29           N  
ATOM    430  CA  ASN A  60      23.500  17.615  17.903  1.00 32.57           C  
ATOM    431  C   ASN A  60      23.229  16.258  18.552  1.00 32.30           C  
ATOM    432  O   ASN A  60      23.532  15.216  17.974  1.00 32.80           O  
ATOM    433  CB  ASN A  60      24.839  17.567  17.153  1.00 34.51           C  
ATOM    434  CG  ASN A  60      25.086  18.810  16.320  1.00 35.21           C  
ATOM    435  OD1 ASN A  60      24.234  19.218  15.534  1.00 31.83           O  
ATOM    436  ND2 ASN A  60      26.261  19.411  16.483  1.00 35.64           N  
ATOM    437  N   GLN A  61      22.656  16.291  19.755  1.00 30.56           N  
ATOM    438  CA  GLN A  61      22.315  15.089  20.516  1.00 27.84           C  
ATOM    439  C   GLN A  61      20.800  14.894  20.551  1.00 27.80           C  
ATOM    440  O   GLN A  61      20.061  15.760  21.023  1.00 26.11           O  
ATOM    441  CB  GLN A  61      22.847  15.198  21.948  1.00 27.98           C  
ATOM    442  CG  GLN A  61      24.325  14.850  22.112  1.00 29.42           C  
ATOM    443  CD  GLN A  61      24.835  15.110  23.525  1.00 30.43           C  
ATOM    444  OE1 GLN A  61      25.327  16.192  23.827  1.00 33.93           O  
ATOM    445  NE2 GLN A  61      24.705  14.118  24.396  1.00 32.34           N  
ATOM    446  N   ALA A  62      20.346  13.745  20.058  1.00 26.29           N  
ATOM    447  CA  ALA A  62      18.922  13.424  20.008  1.00 25.97           C  
ATOM    448  C   ALA A  62      18.244  13.271  21.368  1.00 26.60           C  
ATOM    449  O   ALA A  62      17.032  13.443  21.475  1.00 28.40           O  
ATOM    450  CB  ALA A  62      18.712  12.157  19.193  1.00 26.20           C  
ATOM    451  N   ILE A  63      19.015  12.948  22.402  1.00 24.93           N  
ATOM    452  CA  ILE A  63      18.453  12.752  23.743  1.00 24.99           C  
ATOM    453  C   ILE A  63      18.520  14.004  24.604  1.00 25.06           C  
ATOM    454  O   ILE A  63      18.093  13.978  25.760  1.00 24.41           O  
ATOM    455  CB  ILE A  63      19.216  11.668  24.527  1.00 25.22           C  
ATOM    456  CG1 ILE A  63      20.571  12.221  24.971  1.00 25.60           C  
ATOM    457  CG2 ILE A  63      19.420  10.426  23.658  1.00 26.54           C  
ATOM    458  CD1 ILE A  63      21.345  11.300  25.914  1.00 27.30           C  
ATOM    459  N   MET A  64      19.044  15.092  24.045  1.00 24.39           N  
ATOM    460  CA  MET A  64      19.220  16.317  24.811  1.00 26.05           C  
ATOM    461  C   MET A  64      17.981  17.151  25.112  1.00 25.14           C  
ATOM    462  O   MET A  64      17.903  18.335  24.751  1.00 23.77           O  
ATOM    463  CB  MET A  64      20.289  17.191  24.153  1.00 29.06           C  
ATOM    464  CG  MET A  64      20.929  18.187  25.107  1.00 32.64           C  
ATOM    465  SD  MET A  64      21.477  17.386  26.632  1.00 37.43           S  
ATOM    466  CE  MET A  64      22.713  16.265  25.995  1.00 38.54           C  
ATOM    467  N   HIS A  65      17.011  16.522  25.769  1.00 22.58           N  
ATOM    468  CA  HIS A  65      15.803  17.214  26.186  1.00 20.80           C  
ATOM    469  C   HIS A  65      16.120  17.790  27.552  1.00 20.35           C  
ATOM    470  O   HIS A  65      17.086  17.369  28.196  1.00 20.53           O  
ATOM    471  CB  HIS A  65      14.621  16.251  26.292  1.00 19.89           C  
ATOM    472  CG  HIS A  65      13.975  15.948  24.980  1.00 17.92           C  
ATOM    473  ND1 HIS A  65      12.790  15.255  24.878  1.00 18.75           N  
ATOM    474  CD2 HIS A  65      14.335  16.263  23.713  1.00 18.65           C  
ATOM    475  CE1 HIS A  65      12.445  15.157  23.606  1.00 20.23           C  
ATOM    476  NE2 HIS A  65      13.367  15.760  22.878  1.00 20.45           N  
ATOM    477  N   ALA A  66      15.311  18.750  27.997  1.00 20.58           N  
ATOM    478  CA  ALA A  66      15.519  19.394  29.289  1.00 19.52           C  
ATOM    479  C   ALA A  66      15.663  18.413  30.457  1.00 18.17           C  
ATOM    480  O   ALA A  66      16.591  18.531  31.253  1.00 18.67           O  
ATOM    481  CB  ALA A  66      14.369  20.380  29.574  1.00 18.46           C  
ATOM    482  N   GLU A  67      14.745  17.457  30.560  1.00 17.67           N  
ATOM    483  CA  GLU A  67      14.778  16.486  31.654  1.00 20.14           C  
ATOM    484  C   GLU A  67      16.056  15.656  31.697  1.00 20.70           C  
ATOM    485  O   GLU A  67      16.586  15.382  32.777  1.00 20.82           O  
ATOM    486  CB  GLU A  67      13.582  15.533  31.574  1.00 20.18           C  
ATOM    487  CG  GLU A  67      12.229  16.212  31.488  1.00 22.57           C  
ATOM    488  CD  GLU A  67      11.809  16.509  30.053  1.00 20.87           C  
ATOM    489  OE1 GLU A  67      10.697  16.092  29.673  1.00 23.31           O  
ATOM    490  OE2 GLU A  67      12.578  17.154  29.315  1.00 17.90           O  
ATOM    491  N   MET A  68      16.540  15.252  30.521  1.00 20.82           N  
ATOM    492  CA  MET A  68      17.757  14.443  30.413  1.00 21.52           C  
ATOM    493  C   MET A  68      18.968  15.235  30.888  1.00 21.86           C  
ATOM    494  O   MET A  68      19.831  14.709  31.595  1.00 22.99           O  
ATOM    495  CB  MET A  68      17.977  14.000  28.961  1.00 19.45           C  
ATOM    496  CG  MET A  68      16.821  13.193  28.384  1.00 18.71           C  
ATOM    497  SD  MET A  68      16.463  11.720  29.363  1.00 20.70           S  
ATOM    498  CE  MET A  68      17.570  10.515  28.566  1.00 18.65           C  
ATOM    499  N   MET A  69      19.026  16.504  30.496  1.00 23.76           N  
ATOM    500  CA  MET A  69      20.130  17.375  30.895  1.00 23.83           C  
ATOM    501  C   MET A  69      20.103  17.585  32.412  1.00 23.72           C  
ATOM    502  O   MET A  69      21.140  17.566  33.080  1.00 22.53           O  
ATOM    503  CB  MET A  69      20.010  18.726  30.183  1.00 23.73           C  
ATOM    504  CG  MET A  69      21.217  19.640  30.368  1.00 25.97           C  
ATOM    505  SD  MET A  69      20.939  21.277  29.661  1.00 28.25           S  
ATOM    506  CE  MET A  69      21.215  20.959  27.921  1.00 27.41           C  
ATOM    507  N   ALA A  70      18.903  17.778  32.954  1.00 23.05           N  
ATOM    508  CA  ALA A  70      18.738  17.995  34.393  1.00 21.45           C  
ATOM    509  C   ALA A  70      19.119  16.747  35.179  1.00 20.97           C  
ATOM    510  O   ALA A  70      19.757  16.829  36.231  1.00 20.21           O  
ATOM    511  CB  ALA A  70      17.303  18.374  34.696  1.00 20.05           C  
ATOM    512  N   ILE A  71      18.718  15.588  34.671  1.00 22.50           N  
ATOM    513  CA  ILE A  71      19.036  14.334  35.343  1.00 22.87           C  
ATOM    514  C   ILE A  71      20.542  14.113  35.387  1.00 24.01           C  
ATOM    515  O   ILE A  71      21.085  13.746  36.431  1.00 26.17           O  
ATOM    516  CB  ILE A  71      18.307  13.147  34.672  1.00 21.45           C  
ATOM    517  CG1 ILE A  71      16.809  13.269  34.970  1.00 21.61           C  
ATOM    518  CG2 ILE A  71      18.863  11.811  35.187  1.00 22.44           C  
ATOM    519  CD1 ILE A  71      15.939  12.186  34.381  1.00 20.53           C  
ATOM    520  N   ASN A  72      21.223  14.359  34.273  1.00 25.65           N  
ATOM    521  CA  ASN A  72      22.674  14.204  34.244  1.00 26.48           C  
ATOM    522  C   ASN A  72      23.305  15.128  35.276  1.00 27.26           C  
ATOM    523  O   ASN A  72      24.217  14.736  36.007  1.00 27.40           O  
ATOM    524  CB  ASN A  72      23.250  14.536  32.861  1.00 27.06           C  
ATOM    525  CG  ASN A  72      23.010  13.438  31.851  1.00 30.13           C  
ATOM    526  OD1 ASN A  72      22.875  12.270  32.214  1.00 32.62           O  
ATOM    527  ND2 ASN A  72      22.968  13.803  30.572  1.00 31.29           N  
ATOM    528  N   GLU A  73      22.815  16.359  35.341  1.00 26.68           N  
ATOM    529  CA  GLU A  73      23.358  17.318  36.290  1.00 27.19           C  
ATOM    530  C   GLU A  73      23.092  16.876  37.731  1.00 25.59           C  
ATOM    531  O   GLU A  73      23.979  16.934  38.581  1.00 25.08           O  
ATOM    532  CB  GLU A  73      22.763  18.699  36.022  1.00 30.04           C  
ATOM    533  CG  GLU A  73      23.604  19.840  36.545  1.00 38.23           C  
ATOM    534  CD  GLU A  73      23.091  21.194  36.091  1.00 40.42           C  
ATOM    535  OE1 GLU A  73      23.068  21.447  34.865  1.00 44.56           O  
ATOM    536  OE2 GLU A  73      22.711  22.003  36.958  1.00 42.09           O  
ATOM    537  N   ALA A  74      21.877  16.416  38.003  1.00 24.12           N  
ATOM    538  CA  ALA A  74      21.523  15.961  39.341  1.00 23.96           C  
ATOM    539  C   ALA A  74      22.356  14.742  39.748  1.00 24.89           C  
ATOM    540  O   ALA A  74      22.781  14.628  40.899  1.00 23.61           O  
ATOM    541  CB  ALA A  74      20.035  15.626  39.402  1.00 22.18           C  
ATOM    542  N   ASN A  75      22.584  13.823  38.810  1.00 26.00           N  
ATOM    543  CA  ASN A  75      23.383  12.639  39.119  1.00 25.72           C  
ATOM    544  C   ASN A  75      24.804  13.065  39.455  1.00 25.76           C  
ATOM    545  O   ASN A  75      25.400  12.574  40.410  1.00 29.09           O  
ATOM    546  CB  ASN A  75      23.427  11.661  37.939  1.00 23.90           C  
ATOM    547  CG  ASN A  75      22.117  10.936  37.724  1.00 24.26           C  
ATOM    548  OD1 ASN A  75      21.430  10.557  38.678  1.00 28.24           O  
ATOM    549  ND2 ASN A  75      21.774  10.715  36.469  1.00 20.35           N  
ATOM    550  N   ALA A  76      25.350  13.973  38.658  1.00 25.81           N  
ATOM    551  CA  ALA A  76      26.702  14.451  38.887  1.00 27.57           C  
ATOM    552  C   ALA A  76      26.788  15.090  40.274  1.00 30.02           C  
ATOM    553  O   ALA A  76      27.680  14.777  41.058  1.00 30.85           O  
ATOM    554  CB  ALA A  76      27.083  15.460  37.814  1.00 25.59           C  
ATOM    555  N   HIS A  77      25.846  15.978  40.578  1.00 31.69           N  
ATOM    556  CA  HIS A  77      25.824  16.654  41.869  1.00 32.14           C  
ATOM    557  C   HIS A  77      25.857  15.657  43.021  1.00 32.61           C  
ATOM    558  O   HIS A  77      26.657  15.787  43.946  1.00 34.70           O  
ATOM    559  CB  HIS A  77      24.567  17.522  41.987  1.00 33.57           C  
ATOM    560  CG  HIS A  77      24.487  18.297  43.265  1.00 33.89           C  
ATOM    561  ND1 HIS A  77      25.104  19.517  43.436  1.00 34.61           N  
ATOM    562  CD2 HIS A  77      23.886  18.011  44.444  1.00 34.34           C  
ATOM    563  CE1 HIS A  77      24.886  19.950  44.665  1.00 34.36           C  
ATOM    564  NE2 HIS A  77      24.151  19.054  45.298  1.00 35.33           N  
ATOM    565  N   GLU A  78      24.979  14.662  42.956  1.00 32.51           N  
ATOM    566  CA  GLU A  78      24.878  13.636  43.990  1.00 32.14           C  
ATOM    567  C   GLU A  78      25.917  12.528  43.846  1.00 31.90           C  
ATOM    568  O   GLU A  78      26.116  11.743  44.769  1.00 30.62           O  
ATOM    569  CB  GLU A  78      23.485  13.002  43.951  1.00 32.46           C  
ATOM    570  CG  GLU A  78      22.364  13.978  44.207  1.00 35.00           C  
ATOM    571  CD  GLU A  78      22.405  14.525  45.611  1.00 36.40           C  
ATOM    572  OE1 GLU A  78      22.093  13.764  46.554  1.00 36.63           O  
ATOM    573  OE2 GLU A  78      22.764  15.710  45.772  1.00 38.69           O  
ATOM    574  N   GLY A  79      26.570  12.465  42.690  1.00 32.06           N  
ATOM    575  CA  GLY A  79      27.551  11.417  42.461  1.00 32.78           C  
ATOM    576  C   GLY A  79      26.873  10.072  42.652  1.00 33.08           C  
ATOM    577  O   GLY A  79      27.424   9.162  43.266  1.00 33.62           O  
ATOM    578  N   ASN A  80      25.665   9.950  42.115  1.00 33.41           N  
ATOM    579  CA  ASN A  80      24.883   8.728  42.249  1.00 33.64           C  
ATOM    580  C   ASN A  80      23.787   8.733  41.187  1.00 33.38           C  
ATOM    581  O   ASN A  80      23.161   9.765  40.946  1.00 33.52           O  
ATOM    582  CB  ASN A  80      24.262   8.691  43.650  1.00 34.85           C  
ATOM    583  CG  ASN A  80      23.420   7.456  43.894  1.00 36.28           C  
ATOM    584  OD1 ASN A  80      23.270   6.607  43.017  1.00 39.10           O  
ATOM    585  ND2 ASN A  80      22.861   7.352  45.100  1.00 36.58           N  
ATOM    586  N   TRP A  81      23.555   7.589  40.550  1.00 31.64           N  
ATOM    587  CA  TRP A  81      22.522   7.515  39.524  1.00 31.42           C  
ATOM    588  C   TRP A  81      21.146   7.525  40.167  1.00 30.48           C  
ATOM    589  O   TRP A  81      20.148   7.769  39.499  1.00 31.64           O  
ATOM    590  CB  TRP A  81      22.676   6.248  38.660  1.00 29.75           C  
ATOM    591  CG  TRP A  81      22.453   4.962  39.399  1.00 31.69           C  
ATOM    592  CD1 TRP A  81      23.406   4.173  39.975  1.00 32.27           C  
ATOM    593  CD2 TRP A  81      21.191   4.340  39.683  1.00 31.73           C  
ATOM    594  NE1 TRP A  81      22.817   3.100  40.603  1.00 32.11           N  
ATOM    595  CE2 TRP A  81      21.460   3.179  40.441  1.00 32.56           C  
ATOM    596  CE3 TRP A  81      19.860   4.654  39.373  1.00 31.76           C  
ATOM    597  CZ2 TRP A  81      20.443   2.326  40.897  1.00 33.68           C  
ATOM    598  CZ3 TRP A  81      18.850   3.806  39.824  1.00 31.03           C  
ATOM    599  CH2 TRP A  81      19.148   2.657  40.579  1.00 33.64           C  
ATOM    600  N   ARG A  82      21.095   7.249  41.465  1.00 30.80           N  
ATOM    601  CA  ARG A  82      19.832   7.231  42.189  1.00 32.18           C  
ATOM    602  C   ARG A  82      19.491   8.650  42.627  1.00 31.59           C  
ATOM    603  O   ARG A  82      20.332   9.352  43.190  1.00 31.74           O  
ATOM    604  CB  ARG A  82      19.927   6.330  43.424  1.00 35.92           C  
ATOM    605  CG  ARG A  82      20.415   4.913  43.154  1.00 41.68           C  
ATOM    606  CD  ARG A  82      20.608   4.149  44.468  1.00 46.08           C  
ATOM    607  NE  ARG A  82      21.167   2.809  44.281  1.00 49.54           N  
ATOM    608  CZ  ARG A  82      22.391   2.560  43.817  1.00 52.10           C  
ATOM    609  NH1 ARG A  82      23.197   3.560  43.484  1.00 51.67           N  
ATOM    610  NH2 ARG A  82      22.814   1.306  43.695  1.00 53.32           N  
ATOM    611  N   LEU A  83      18.259   9.067  42.360  1.00 31.29           N  
ATOM    612  CA  LEU A  83      17.798  10.403  42.722  1.00 29.19           C  
ATOM    613  C   LEU A  83      16.571  10.295  43.623  1.00 29.32           C  
ATOM    614  O   LEU A  83      15.509  10.820  43.308  1.00 29.91           O  
ATOM    615  CB  LEU A  83      17.467  11.197  41.452  1.00 27.56           C  
ATOM    616  CG  LEU A  83      18.529  12.126  40.847  1.00 25.95           C  
ATOM    617  CD1 LEU A  83      19.924  11.674  41.190  1.00 27.15           C  
ATOM    618  CD2 LEU A  83      18.323  12.200  39.345  1.00 25.65           C  
ATOM    619  N   LEU A  84      16.731   9.605  44.747  1.00 28.99           N  
ATOM    620  CA  LEU A  84      15.647   9.414  45.706  1.00 29.10           C  
ATOM    621  C   LEU A  84      15.337  10.726  46.439  1.00 27.87           C  
ATOM    622  O   LEU A  84      16.186  11.611  46.514  1.00 26.07           O  
ATOM    623  CB  LEU A  84      16.051   8.333  46.713  1.00 30.27           C  
ATOM    624  CG  LEU A  84      16.400   6.964  46.112  1.00 31.50           C  
ATOM    625  CD1 LEU A  84      17.147   6.120  47.132  1.00 31.74           C  
ATOM    626  CD2 LEU A  84      15.119   6.262  45.665  1.00 33.05           C  
ATOM    627  N   ASP A  85      14.122  10.847  46.970  1.00 29.08           N  
ATOM    628  CA  ASP A  85      13.710  12.046  47.709  1.00 33.01           C  
ATOM    629  C   ASP A  85      13.939  13.318  46.910  1.00 34.29           C  
ATOM    630  O   ASP A  85      14.329  14.356  47.456  1.00 37.64           O  
ATOM    631  CB  ASP A  85      14.486  12.149  49.022  1.00 34.80           C  
ATOM    632  CG  ASP A  85      14.262  10.954  49.918  1.00 37.02           C  
ATOM    633  OD1 ASP A  85      13.088  10.577  50.115  1.00 38.74           O  
ATOM    634  OD2 ASP A  85      15.258  10.399  50.426  1.00 40.24           O  
ATOM    635  N   THR A  86      13.686  13.233  45.615  1.00 33.73           N  
ATOM    636  CA  THR A  86      13.882  14.355  44.721  1.00 31.35           C  
ATOM    637  C   THR A  86      12.569  14.745  44.053  1.00 28.19           C  
ATOM    638  O   THR A  86      11.652  13.938  43.957  1.00 28.77           O  
ATOM    639  CB  THR A  86      14.940  13.976  43.653  1.00 32.65           C  
ATOM    640  OG1 THR A  86      16.254  14.220  44.178  1.00 33.92           O  
ATOM    641  CG2 THR A  86      14.747  14.764  42.387  1.00 37.54           C  
ATOM    642  N   THR A  87      12.467  15.998  43.628  1.00 26.56           N  
ATOM    643  CA  THR A  87      11.275  16.460  42.925  1.00 24.44           C  
ATOM    644  C   THR A  87      11.728  17.092  41.620  1.00 22.36           C  
ATOM    645  O   THR A  87      12.622  17.948  41.605  1.00 20.29           O  
ATOM    646  CB  THR A  87      10.480  17.514  43.715  1.00 24.45           C  
ATOM    647  OG1 THR A  87      10.028  16.953  44.950  1.00 26.99           O  
ATOM    648  CG2 THR A  87       9.266  17.951  42.916  1.00 23.31           C  
ATOM    649  N   LEU A  88      11.119  16.658  40.525  1.00 20.51           N  
ATOM    650  CA  LEU A  88      11.463  17.188  39.219  1.00 20.84           C  
ATOM    651  C   LEU A  88      10.372  18.115  38.697  1.00 19.27           C  
ATOM    652  O   LEU A  88       9.192  17.738  38.646  1.00 20.40           O  
ATOM    653  CB  LEU A  88      11.693  16.036  38.227  1.00 19.78           C  
ATOM    654  CG  LEU A  88      12.037  16.377  36.769  1.00 20.49           C  
ATOM    655  CD1 LEU A  88      12.896  15.260  36.181  1.00 20.79           C  
ATOM    656  CD2 LEU A  88      10.770  16.559  35.949  1.00 18.66           C  
ATOM    657  N   PHE A  89      10.768  19.330  38.333  1.00 17.61           N  
ATOM    658  CA  PHE A  89       9.833  20.306  37.774  1.00 17.76           C  
ATOM    659  C   PHE A  89      10.184  20.489  36.298  1.00 16.62           C  
ATOM    660  O   PHE A  89      11.337  20.747  35.955  1.00 15.56           O  
ATOM    661  CB  PHE A  89       9.941  21.670  38.474  1.00 17.87           C  
ATOM    662  CG  PHE A  89       9.541  21.654  39.924  1.00 18.67           C  
ATOM    663  CD1 PHE A  89      10.393  21.133  40.892  1.00 19.26           C  
ATOM    664  CD2 PHE A  89       8.317  22.184  40.323  1.00 19.91           C  
ATOM    665  CE1 PHE A  89      10.036  21.139  42.235  1.00 19.18           C  
ATOM    666  CE2 PHE A  89       7.947  22.194  41.671  1.00 21.44           C  
ATOM    667  CZ  PHE A  89       8.813  21.669  42.627  1.00 22.83           C  
ATOM    668  N   VAL A  90       9.198  20.333  35.426  1.00 15.51           N  
ATOM    669  CA  VAL A  90       9.428  20.497  33.996  1.00 16.28           C  
ATOM    670  C   VAL A  90       8.237  21.249  33.404  1.00 18.22           C  
ATOM    671  O   VAL A  90       7.081  20.928  33.693  1.00 18.96           O  
ATOM    672  CB  VAL A  90       9.624  19.116  33.297  1.00 13.70           C  
ATOM    673  CG1 VAL A  90       8.386  18.255  33.472  1.00 11.57           C  
ATOM    674  CG2 VAL A  90       9.932  19.322  31.822  1.00 13.85           C  
ATOM    675  N   THR A  91       8.523  22.248  32.573  1.00 20.71           N  
ATOM    676  CA  THR A  91       7.475  23.085  31.984  1.00 20.70           C  
ATOM    677  C   THR A  91       6.438  22.358  31.139  1.00 22.74           C  
ATOM    678  O   THR A  91       5.285  22.782  31.071  1.00 23.08           O  
ATOM    679  CB  THR A  91       8.082  24.229  31.147  1.00 20.45           C  
ATOM    680  OG1 THR A  91       8.760  23.688  30.004  1.00 21.17           O  
ATOM    681  CG2 THR A  91       9.066  25.038  31.994  1.00 17.54           C  
ATOM    682  N   ILE A  92       6.843  21.271  30.489  1.00 22.98           N  
ATOM    683  CA  ILE A  92       5.923  20.496  29.662  1.00 24.25           C  
ATOM    684  C   ILE A  92       5.988  19.025  30.053  1.00 24.17           C  
ATOM    685  O   ILE A  92       7.051  18.528  30.427  1.00 24.31           O  
ATOM    686  CB  ILE A  92       6.271  20.616  28.153  1.00 25.69           C  
ATOM    687  CG1 ILE A  92       6.191  22.082  27.699  1.00 28.22           C  
ATOM    688  CG2 ILE A  92       5.328  19.747  27.335  1.00 25.15           C  
ATOM    689  CD1 ILE A  92       4.788  22.680  27.699  1.00 26.78           C  
ATOM    690  N   GLU A  93       4.847  18.342  29.974  1.00 22.48           N  
ATOM    691  CA  GLU A  93       4.756  16.921  30.294  1.00 23.57           C  
ATOM    692  C   GLU A  93       5.858  16.144  29.559  1.00 24.96           C  
ATOM    693  O   GLU A  93       5.963  16.223  28.335  1.00 25.27           O  
ATOM    694  CB  GLU A  93       3.383  16.386  29.868  1.00 24.60           C  
ATOM    695  CG  GLU A  93       3.273  14.867  29.875  1.00 26.00           C  
ATOM    696  CD  GLU A  93       1.993  14.370  29.233  1.00 26.93           C  
ATOM    697  OE1 GLU A  93       1.297  15.176  28.579  1.00 26.40           O  
ATOM    698  OE2 GLU A  93       1.686  13.168  29.368  1.00 29.01           O  
ATOM    699  N   PRO A  94       6.688  15.383  30.296  1.00 23.67           N  
ATOM    700  CA  PRO A  94       7.774  14.605  29.683  1.00 24.45           C  
ATOM    701  C   PRO A  94       7.337  13.620  28.599  1.00 24.80           C  
ATOM    702  O   PRO A  94       6.282  12.980  28.694  1.00 24.25           O  
ATOM    703  CB  PRO A  94       8.408  13.889  30.872  1.00 22.47           C  
ATOM    704  CG  PRO A  94       8.186  14.869  32.007  1.00 24.19           C  
ATOM    705  CD  PRO A  94       6.757  15.309  31.767  1.00 23.02           C  
ATOM    706  N   CYS A  95       8.165  13.501  27.567  1.00 24.18           N  
ATOM    707  CA  CYS A  95       7.893  12.579  26.478  1.00 23.80           C  
ATOM    708  C   CYS A  95       8.190  11.162  26.985  1.00 23.95           C  
ATOM    709  O   CYS A  95       8.509  10.959  28.161  1.00 23.51           O  
ATOM    710  CB  CYS A  95       8.788  12.904  25.280  1.00 23.61           C  
ATOM    711  SG  CYS A  95      10.528  12.399  25.506  1.00 23.44           S  
ATOM    712  N   VAL A  96       8.085  10.188  26.094  1.00 23.26           N  
ATOM    713  CA  VAL A  96       8.337   8.795  26.450  1.00 21.28           C  
ATOM    714  C   VAL A  96       9.774   8.549  26.918  1.00 20.79           C  
ATOM    715  O   VAL A  96      10.001   7.859  27.911  1.00 20.01           O  
ATOM    716  CB  VAL A  96       8.012   7.875  25.257  1.00 20.78           C  
ATOM    717  CG1 VAL A  96       8.530   6.462  25.514  1.00 23.46           C  
ATOM    718  CG2 VAL A  96       6.509   7.849  25.035  1.00 20.58           C  
ATOM    719  N   MET A  97      10.746   9.113  26.212  1.00 20.98           N  
ATOM    720  CA  MET A  97      12.141   8.925  26.596  1.00 21.73           C  
ATOM    721  C   MET A  97      12.440   9.473  27.992  1.00 22.09           C  
ATOM    722  O   MET A  97      13.033   8.792  28.831  1.00 23.36           O  
ATOM    723  CB  MET A  97      13.075   9.601  25.585  1.00 20.72           C  
ATOM    724  CG  MET A  97      14.536   9.523  25.991  1.00 18.33           C  
ATOM    725  SD  MET A  97      15.618  10.566  25.015  1.00 24.29           S  
ATOM    726  CE  MET A  97      14.949  12.245  25.478  1.00 19.23           C  
ATOM    727  N   CYS A  98      12.029  10.712  28.241  1.00 22.68           N  
ATOM    728  CA  CYS A  98      12.290  11.336  29.526  1.00 21.28           C  
ATOM    729  C   CYS A  98      11.536  10.658  30.661  1.00 20.39           C  
ATOM    730  O   CYS A  98      12.069  10.509  31.766  1.00 19.74           O  
ATOM    731  CB  CYS A  98      11.972  12.833  29.447  1.00 21.26           C  
ATOM    732  SG  CYS A  98      13.128  13.739  28.359  1.00 20.55           S  
ATOM    733  N   SER A  99      10.305  10.233  30.394  1.00 20.85           N  
ATOM    734  CA  SER A  99       9.522   9.539  31.410  1.00 21.96           C  
ATOM    735  C   SER A  99      10.285   8.280  31.818  1.00 22.82           C  
ATOM    736  O   SER A  99      10.449   7.989  33.007  1.00 23.47           O  
ATOM    737  CB  SER A  99       8.149   9.146  30.861  1.00 23.07           C  
ATOM    738  OG  SER A  99       7.359  10.284  30.583  1.00 23.48           O  
ATOM    739  N   GLY A 100      10.753   7.533  30.822  1.00 23.18           N  
ATOM    740  CA  GLY A 100      11.502   6.324  31.106  1.00 20.87           C  
ATOM    741  C   GLY A 100      12.734   6.639  31.932  1.00 20.63           C  
ATOM    742  O   GLY A 100      13.077   5.910  32.862  1.00 21.61           O  
ATOM    743  N   ALA A 101      13.405   7.735  31.588  1.00 21.28           N  
ATOM    744  CA  ALA A 101      14.608   8.156  32.295  1.00 21.08           C  
ATOM    745  C   ALA A 101      14.272   8.515  33.744  1.00 23.05           C  
ATOM    746  O   ALA A 101      14.991   8.146  34.667  1.00 22.37           O  
ATOM    747  CB  ALA A 101      15.231   9.353  31.587  1.00 21.30           C  
ATOM    748  N   ILE A 102      13.174   9.238  33.931  1.00 23.15           N  
ATOM    749  CA  ILE A 102      12.725   9.642  35.258  1.00 23.23           C  
ATOM    750  C   ILE A 102      12.488   8.399  36.131  1.00 24.83           C  
ATOM    751  O   ILE A 102      12.803   8.387  37.324  1.00 21.62           O  
ATOM    752  CB  ILE A 102      11.428  10.479  35.143  1.00 23.42           C  
ATOM    753  CG1 ILE A 102      11.752  11.817  34.462  1.00 22.36           C  
ATOM    754  CG2 ILE A 102      10.796  10.685  36.513  1.00 21.81           C  
ATOM    755  CD1 ILE A 102      10.532  12.662  34.123  1.00 22.91           C  
ATOM    756  N   GLY A 103      11.937   7.353  35.526  1.00 24.34           N  
ATOM    757  CA  GLY A 103      11.698   6.128  36.267  1.00 24.30           C  
ATOM    758  C   GLY A 103      13.004   5.446  36.651  1.00 24.07           C  
ATOM    759  O   GLY A 103      13.145   4.919  37.752  1.00 24.74           O  
ATOM    760  N   LEU A 104      13.967   5.459  35.738  1.00 23.63           N  
ATOM    761  CA  LEU A 104      15.262   4.832  35.988  1.00 23.58           C  
ATOM    762  C   LEU A 104      16.064   5.560  37.069  1.00 25.00           C  
ATOM    763  O   LEU A 104      16.886   4.947  37.759  1.00 23.31           O  
ATOM    764  CB  LEU A 104      16.071   4.784  34.689  1.00 25.32           C  
ATOM    765  CG  LEU A 104      15.566   3.831  33.600  1.00 24.28           C  
ATOM    766  CD1 LEU A 104      16.320   4.099  32.305  1.00 22.12           C  
ATOM    767  CD2 LEU A 104      15.749   2.384  34.050  1.00 23.77           C  
ATOM    768  N   ALA A 105      15.829   6.864  37.207  1.00 23.14           N  
ATOM    769  CA  ALA A 105      16.530   7.681  38.201  1.00 24.65           C  
ATOM    770  C   ALA A 105      15.902   7.535  39.583  1.00 24.84           C  
ATOM    771  O   ALA A 105      16.444   8.017  40.582  1.00 26.16           O  
ATOM    772  CB  ALA A 105      16.517   9.154  37.779  1.00 22.95           C  
ATOM    773  N   ARG A 106      14.755   6.871  39.624  1.00 23.10           N  
ATOM    774  CA  ARG A 106      14.033   6.649  40.863  1.00 25.97           C  
ATOM    775  C   ARG A 106      13.494   7.942  41.474  1.00 24.69           C  
ATOM    776  O   ARG A 106      13.331   8.040  42.688  1.00 23.81           O  
ATOM    777  CB  ARG A 106      14.918   5.901  41.870  1.00 27.53           C  
ATOM    778  CG  ARG A 106      15.312   4.504  41.392  1.00 32.26           C  
ATOM    779  CD  ARG A 106      14.066   3.704  41.038  1.00 39.18           C  
ATOM    780  NE  ARG A 106      14.246   2.877  39.842  1.00 45.63           N  
ATOM    781  CZ  ARG A 106      13.244   2.359  39.132  1.00 46.39           C  
ATOM    782  NH1 ARG A 106      11.984   2.582  39.496  1.00 45.51           N  
ATOM    783  NH2 ARG A 106      13.500   1.630  38.052  1.00 46.53           N  
ATOM    784  N   ILE A 107      13.216   8.927  40.622  1.00 24.11           N  
ATOM    785  CA  ILE A 107      12.661  10.198  41.079  1.00 22.38           C  
ATOM    786  C   ILE A 107      11.212   9.910  41.470  1.00 22.44           C  
ATOM    787  O   ILE A 107      10.399   9.514  40.637  1.00 24.01           O  
ATOM    788  CB  ILE A 107      12.710  11.253  39.959  1.00 21.59           C  
ATOM    789  CG1 ILE A 107      14.173  11.584  39.643  1.00 21.01           C  
ATOM    790  CG2 ILE A 107      11.927  12.493  40.377  1.00 17.61           C  
ATOM    791  CD1 ILE A 107      14.367  12.391  38.372  1.00 18.33           C  
ATOM    792  N   PRO A 108      10.871  10.119  42.747  1.00 23.71           N  
ATOM    793  CA  PRO A 108       9.531   9.878  43.292  1.00 23.56           C  
ATOM    794  C   PRO A 108       8.479  10.952  43.078  1.00 24.61           C  
ATOM    795  O   PRO A 108       7.285  10.701  43.269  1.00 25.71           O  
ATOM    796  CB  PRO A 108       9.815   9.688  44.775  1.00 22.58           C  
ATOM    797  CG  PRO A 108      10.877  10.734  45.012  1.00 20.31           C  
ATOM    798  CD  PRO A 108      11.789  10.593  43.804  1.00 23.23           C  
ATOM    799  N   HIS A 109       8.909  12.140  42.666  1.00 23.92           N  
ATOM    800  CA  HIS A 109       7.977  13.250  42.526  1.00 23.00           C  
ATOM    801  C   HIS A 109       8.216  14.095  41.272  1.00 21.20           C  
ATOM    802  O   HIS A 109       9.304  14.631  41.070  1.00 20.86           O  
ATOM    803  CB  HIS A 109       8.108  14.110  43.790  1.00 22.25           C  
ATOM    804  CG  HIS A 109       6.990  15.080  44.006  1.00 24.87           C  
ATOM    805  ND1 HIS A 109       7.049  16.068  44.966  1.00 23.67           N  
ATOM    806  CD2 HIS A 109       5.779  15.204  43.413  1.00 24.76           C  
ATOM    807  CE1 HIS A 109       5.923  16.757  44.956  1.00 23.72           C  
ATOM    808  NE2 HIS A 109       5.136  16.253  44.023  1.00 24.55           N  
ATOM    809  N   VAL A 110       7.192  14.213  40.435  1.00 20.44           N  
ATOM    810  CA  VAL A 110       7.307  15.006  39.216  1.00 23.73           C  
ATOM    811  C   VAL A 110       6.154  15.995  39.075  1.00 23.05           C  
ATOM    812  O   VAL A 110       4.986  15.641  39.231  1.00 24.01           O  
ATOM    813  CB  VAL A 110       7.337  14.116  37.950  1.00 25.59           C  
ATOM    814  CG1 VAL A 110       6.100  13.240  37.907  1.00 33.00           C  
ATOM    815  CG2 VAL A 110       7.378  14.986  36.703  1.00 27.77           C  
ATOM    816  N   ILE A 111       6.495  17.240  38.775  1.00 23.22           N  
ATOM    817  CA  ILE A 111       5.493  18.277  38.594  1.00 22.80           C  
ATOM    818  C   ILE A 111       5.723  18.954  37.248  1.00 21.99           C  
ATOM    819  O   ILE A 111       6.807  19.473  36.993  1.00 21.75           O  
ATOM    820  CB  ILE A 111       5.595  19.327  39.711  1.00 22.68           C  
ATOM    821  CG1 ILE A 111       5.537  18.624  41.072  1.00 21.51           C  
ATOM    822  CG2 ILE A 111       4.480  20.356  39.559  1.00 21.96           C  
ATOM    823  CD1 ILE A 111       5.767  19.514  42.262  1.00 21.33           C  
ATOM    824  N   TYR A 112       4.727  18.921  36.368  1.00 22.18           N  
ATOM    825  CA  TYR A 112       4.891  19.587  35.082  1.00 23.85           C  
ATOM    826  C   TYR A 112       3.801  20.625  34.860  1.00 24.23           C  
ATOM    827  O   TYR A 112       2.728  20.552  35.465  1.00 23.67           O  
ATOM    828  CB  TYR A 112       4.924  18.580  33.916  1.00 22.53           C  
ATOM    829  CG  TYR A 112       3.635  17.838  33.637  1.00 24.17           C  
ATOM    830  CD1 TYR A 112       3.432  16.547  34.121  1.00 24.11           C  
ATOM    831  CD2 TYR A 112       2.635  18.411  32.855  1.00 23.74           C  
ATOM    832  CE1 TYR A 112       2.269  15.842  33.828  1.00 25.13           C  
ATOM    833  CE2 TYR A 112       1.467  17.714  32.558  1.00 24.39           C  
ATOM    834  CZ  TYR A 112       1.293  16.430  33.045  1.00 26.41           C  
ATOM    835  OH  TYR A 112       0.145  15.729  32.742  1.00 29.55           O  
ATOM    836  N   GLY A 113       4.097  21.598  34.004  1.00 24.71           N  
ATOM    837  CA  GLY A 113       3.150  22.659  33.711  1.00 25.21           C  
ATOM    838  C   GLY A 113       2.060  22.267  32.735  1.00 26.40           C  
ATOM    839  O   GLY A 113       1.002  21.778  33.136  1.00 28.50           O  
ATOM    840  N   ALA A 114       2.314  22.481  31.450  1.00 26.97           N  
ATOM    841  CA  ALA A 114       1.338  22.156  30.414  1.00 28.92           C  
ATOM    842  C   ALA A 114       1.519  20.728  29.912  1.00 30.21           C  
ATOM    843  O   ALA A 114       2.631  20.200  29.903  1.00 30.14           O  
ATOM    844  CB  ALA A 114       1.471  23.138  29.255  1.00 28.31           C  
ATOM    845  N   SER A 115       0.425  20.106  29.486  1.00 31.15           N  
ATOM    846  CA  SER A 115       0.476  18.740  28.987  1.00 32.26           C  
ATOM    847  C   SER A 115       1.049  18.681  27.572  1.00 33.24           C  
ATOM    848  O   SER A 115       1.091  19.687  26.856  1.00 32.79           O  
ATOM    849  CB  SER A 115      -0.923  18.126  28.991  1.00 34.44           C  
ATOM    850  OG  SER A 115      -1.721  18.697  27.970  1.00 37.03           O  
ATOM    851  N   ASN A 116       1.496  17.494  27.181  1.00 33.26           N  
ATOM    852  CA  ASN A 116       2.059  17.268  25.855  1.00 33.74           C  
ATOM    853  C   ASN A 116       1.145  16.260  25.164  1.00 34.58           C  
ATOM    854  O   ASN A 116       1.338  15.052  25.263  1.00 33.91           O  
ATOM    855  CB  ASN A 116       3.475  16.707  25.983  1.00 34.05           C  
ATOM    856  CG  ASN A 116       4.247  16.752  24.677  1.00 34.32           C  
ATOM    857  OD1 ASN A 116       5.449  16.498  24.656  1.00 35.95           O  
ATOM    858  ND2 ASN A 116       3.565  17.069  23.586  1.00 32.10           N  
ATOM    859  N   GLN A 117       0.139  16.780  24.473  1.00 36.32           N  
ATOM    860  CA  GLN A 117      -0.848  15.957  23.783  1.00 38.99           C  
ATOM    861  C   GLN A 117      -0.302  15.146  22.605  1.00 39.32           C  
ATOM    862  O   GLN A 117      -0.895  14.143  22.213  1.00 38.51           O  
ATOM    863  CB  GLN A 117      -1.995  16.856  23.317  1.00 40.54           C  
ATOM    864  CG  GLN A 117      -2.605  17.657  24.453  1.00 46.97           C  
ATOM    865  CD  GLN A 117      -3.470  18.806  23.972  1.00 51.94           C  
ATOM    866  OE1 GLN A 117      -3.018  19.663  23.204  1.00 54.31           O  
ATOM    867  NE2 GLN A 117      -4.722  18.838  24.430  1.00 52.57           N  
ATOM    868  N   LYS A 118       0.828  15.568  22.050  1.00 39.89           N  
ATOM    869  CA  LYS A 118       1.410  14.863  20.917  1.00 41.26           C  
ATOM    870  C   LYS A 118       2.466  13.817  21.274  1.00 40.70           C  
ATOM    871  O   LYS A 118       2.535  12.766  20.635  1.00 40.39           O  
ATOM    872  CB  LYS A 118       2.004  15.866  19.921  1.00 43.21           C  
ATOM    873  CG  LYS A 118       0.965  16.670  19.162  1.00 47.32           C  
ATOM    874  CD  LYS A 118       1.617  17.616  18.168  1.00 50.69           C  
ATOM    875  CE  LYS A 118       0.569  18.380  17.367  1.00 51.81           C  
ATOM    876  NZ  LYS A 118       1.183  19.249  16.324  1.00 53.60           N  
ATOM    877  N   PHE A 119       3.289  14.095  22.284  1.00 39.20           N  
ATOM    878  CA  PHE A 119       4.338  13.155  22.671  1.00 38.08           C  
ATOM    879  C   PHE A 119       4.350  12.829  24.165  1.00 36.27           C  
ATOM    880  O   PHE A 119       5.247  12.134  24.638  1.00 36.25           O  
ATOM    881  CB  PHE A 119       5.717  13.709  22.277  1.00 41.17           C  
ATOM    882  CG  PHE A 119       5.765  14.318  20.897  1.00 43.89           C  
ATOM    883  CD1 PHE A 119       5.447  15.660  20.701  1.00 45.36           C  
ATOM    884  CD2 PHE A 119       6.111  13.547  19.791  1.00 44.90           C  
ATOM    885  CE1 PHE A 119       5.472  16.225  19.425  1.00 44.80           C  
ATOM    886  CE2 PHE A 119       6.139  14.102  18.510  1.00 45.05           C  
ATOM    887  CZ  PHE A 119       5.818  15.443  18.327  1.00 44.73           C  
ATOM    888  N   GLY A 120       3.357  13.323  24.899  1.00 33.59           N  
ATOM    889  CA  GLY A 120       3.290  13.088  26.336  1.00 32.23           C  
ATOM    890  C   GLY A 120       3.313  11.640  26.794  1.00 30.61           C  
ATOM    891  O   GLY A 120       2.458  10.845  26.404  1.00 30.79           O  
ATOM    892  N   GLY A 121       4.274  11.298  27.648  1.00 28.20           N  
ATOM    893  CA  GLY A 121       4.372   9.931  28.130  1.00 27.81           C  
ATOM    894  C   GLY A 121       3.962   9.723  29.577  1.00 28.07           C  
ATOM    895  O   GLY A 121       4.120   8.630  30.117  1.00 28.41           O  
ATOM    896  N   VAL A 122       3.430  10.760  30.213  1.00 27.82           N  
ATOM    897  CA  VAL A 122       3.018  10.647  31.607  1.00 27.69           C  
ATOM    898  C   VAL A 122       1.507  10.489  31.732  1.00 29.31           C  
ATOM    899  O   VAL A 122       1.020   9.705  32.553  1.00 29.04           O  
ATOM    900  CB  VAL A 122       3.470  11.882  32.428  1.00 27.80           C  
ATOM    901  CG1 VAL A 122       3.058  11.725  33.890  1.00 25.20           C  
ATOM    902  CG2 VAL A 122       4.977  12.050  32.320  1.00 25.22           C  
ATOM    903  N   ASP A 123       0.769  11.231  30.912  1.00 30.07           N  
ATOM    904  CA  ASP A 123      -0.687  11.171  30.936  1.00 32.44           C  
ATOM    905  C   ASP A 123      -1.290  11.121  29.543  1.00 32.50           C  
ATOM    906  O   ASP A 123      -2.237  10.382  29.300  1.00 34.10           O  
ATOM    907  CB  ASP A 123      -1.270  12.392  31.663  1.00 33.46           C  
ATOM    908  CG  ASP A 123      -0.919  12.426  33.134  1.00 36.36           C  
ATOM    909  OD1 ASP A 123      -1.259  11.465  33.853  1.00 38.13           O  
ATOM    910  OD2 ASP A 123      -0.307  13.419  33.577  1.00 39.34           O  
ATOM    911  N   SER A 124      -0.736  11.907  28.626  1.00 33.59           N  
ATOM    912  CA  SER A 124      -1.271  11.983  27.271  1.00 33.28           C  
ATOM    913  C   SER A 124      -1.289  10.691  26.466  1.00 34.65           C  
ATOM    914  O   SER A 124      -2.341  10.068  26.331  1.00 36.71           O  
ATOM    915  CB  SER A 124      -0.540  13.072  26.490  1.00 33.23           C  
ATOM    916  OG  SER A 124      -0.720  14.327  27.120  1.00 29.59           O  
ATOM    917  N   LEU A 125      -0.141  10.293  25.923  1.00 34.50           N  
ATOM    918  CA  LEU A 125      -0.074   9.074  25.116  1.00 34.66           C  
ATOM    919  C   LEU A 125       0.156   7.827  25.949  1.00 34.34           C  
ATOM    920  O   LEU A 125      -0.386   6.770  25.649  1.00 35.14           O  
ATOM    921  CB  LEU A 125       1.031   9.182  24.065  1.00 34.62           C  
ATOM    922  CG  LEU A 125       0.947  10.344  23.074  1.00 36.97           C  
ATOM    923  CD1 LEU A 125       2.038  10.178  22.038  1.00 36.22           C  
ATOM    924  CD2 LEU A 125      -0.417  10.382  22.398  1.00 37.06           C  
ATOM    925  N   TYR A 126       0.975   7.952  26.989  1.00 34.20           N  
ATOM    926  CA  TYR A 126       1.278   6.828  27.873  1.00 34.26           C  
ATOM    927  C   TYR A 126       1.225   7.286  29.326  1.00 34.17           C  
ATOM    928  O   TYR A 126       1.112   8.475  29.600  1.00 34.74           O  
ATOM    929  CB  TYR A 126       2.681   6.273  27.603  1.00 33.39           C  
ATOM    930  CG  TYR A 126       2.924   5.758  26.204  1.00 33.58           C  
ATOM    931  CD1 TYR A 126       3.136   6.635  25.140  1.00 34.87           C  
ATOM    932  CD2 TYR A 126       2.974   4.388  25.948  1.00 35.04           C  
ATOM    933  CE1 TYR A 126       3.396   6.159  23.859  1.00 35.16           C  
ATOM    934  CE2 TYR A 126       3.230   3.901  24.672  1.00 35.06           C  
ATOM    935  CZ  TYR A 126       3.442   4.791  23.635  1.00 35.58           C  
ATOM    936  OH  TYR A 126       3.712   4.310  22.378  1.00 36.79           O  
ATOM    937  N   GLN A 127       1.306   6.332  30.245  1.00 34.61           N  
ATOM    938  CA  GLN A 127       1.311   6.618  31.675  1.00 35.93           C  
ATOM    939  C   GLN A 127       2.489   5.855  32.269  1.00 33.87           C  
ATOM    940  O   GLN A 127       2.326   5.047  33.178  1.00 32.98           O  
ATOM    941  CB  GLN A 127       0.008   6.155  32.343  1.00 37.50           C  
ATOM    942  CG  GLN A 127      -1.232   6.934  31.944  1.00 41.98           C  
ATOM    943  CD  GLN A 127      -1.710   6.596  30.549  1.00 46.56           C  
ATOM    944  OE1 GLN A 127      -2.035   5.445  30.254  1.00 50.50           O  
ATOM    945  NE2 GLN A 127      -1.762   7.601  29.678  1.00 49.23           N  
ATOM    946  N   ILE A 128       3.679   6.134  31.746  1.00 32.67           N  
ATOM    947  CA  ILE A 128       4.908   5.471  32.175  1.00 32.52           C  
ATOM    948  C   ILE A 128       5.314   5.644  33.644  1.00 33.49           C  
ATOM    949  O   ILE A 128       5.782   4.701  34.271  1.00 34.49           O  
ATOM    950  CB  ILE A 128       6.096   5.915  31.281  1.00 30.38           C  
ATOM    951  CG1 ILE A 128       5.790   5.572  29.818  1.00 30.25           C  
ATOM    952  CG2 ILE A 128       7.378   5.227  31.720  1.00 28.21           C  
ATOM    953  CD1 ILE A 128       6.763   6.175  28.828  1.00 30.87           C  
ATOM    954  N   LEU A 129       5.136   6.839  34.195  1.00 33.31           N  
ATOM    955  CA  LEU A 129       5.530   7.102  35.577  1.00 31.40           C  
ATOM    956  C   LEU A 129       4.666   6.438  36.643  1.00 32.03           C  
ATOM    957  O   LEU A 129       5.036   6.412  37.813  1.00 30.20           O  
ATOM    958  CB  LEU A 129       5.577   8.613  35.827  1.00 30.82           C  
ATOM    959  CG  LEU A 129       6.517   9.424  34.926  1.00 29.92           C  
ATOM    960  CD1 LEU A 129       6.670  10.837  35.492  1.00 27.26           C  
ATOM    961  CD2 LEU A 129       7.875   8.744  34.839  1.00 26.25           C  
ATOM    962  N   THR A 130       3.519   5.902  36.246  1.00 34.35           N  
ATOM    963  CA  THR A 130       2.631   5.250  37.202  1.00 38.19           C  
ATOM    964  C   THR A 130       2.299   3.826  36.772  1.00 42.11           C  
ATOM    965  O   THR A 130       1.393   3.194  37.314  1.00 41.20           O  
ATOM    966  CB  THR A 130       1.322   6.042  37.367  1.00 37.41           C  
ATOM    967  OG1 THR A 130       0.684   6.177  36.093  1.00 37.72           O  
ATOM    968  CG2 THR A 130       1.608   7.428  37.938  1.00 36.76           C  
ATOM    969  N   ASP A 131       3.050   3.328  35.794  1.00 46.65           N  
ATOM    970  CA  ASP A 131       2.860   1.980  35.272  1.00 50.52           C  
ATOM    971  C   ASP A 131       3.345   0.949  36.281  1.00 52.24           C  
ATOM    972  O   ASP A 131       4.516   0.942  36.663  1.00 52.69           O  
ATOM    973  CB  ASP A 131       3.634   1.823  33.962  1.00 51.64           C  
ATOM    974  CG  ASP A 131       3.539   0.425  33.389  1.00 53.53           C  
ATOM    975  OD1 ASP A 131       3.834  -0.541  34.118  1.00 55.25           O  
ATOM    976  OD2 ASP A 131       3.178   0.288  32.206  1.00 54.65           O  
ATOM    977  N   GLU A 132       2.442   0.069  36.701  1.00 55.10           N  
ATOM    978  CA  GLU A 132       2.772  -0.973  37.668  1.00 56.79           C  
ATOM    979  C   GLU A 132       3.787  -1.985  37.136  1.00 56.44           C  
ATOM    980  O   GLU A 132       4.646  -2.454  37.883  1.00 55.73           O  
ATOM    981  CB  GLU A 132       1.498  -1.697  38.106  1.00 59.39           C  
ATOM    982  CG  GLU A 132       0.444  -0.770  38.695  1.00 63.49           C  
ATOM    983  CD  GLU A 132      -0.739  -1.514  39.284  1.00 65.66           C  
ATOM    984  OE1 GLU A 132      -1.682  -0.842  39.755  1.00 66.92           O  
ATOM    985  OE2 GLU A 132      -0.726  -2.767  39.280  1.00 67.00           O  
ATOM    986  N   ARG A 133       3.687  -2.322  35.852  1.00 56.27           N  
ATOM    987  CA  ARG A 133       4.611  -3.280  35.237  1.00 55.63           C  
ATOM    988  C   ARG A 133       6.049  -2.839  35.499  1.00 55.24           C  
ATOM    989  O   ARG A 133       6.911  -3.656  35.820  1.00 55.63           O  
ATOM    990  CB  ARG A 133       4.401  -3.351  33.726  1.00 56.00           C  
ATOM    991  CG  ARG A 133       2.967  -3.232  33.256  1.00 56.97           C  
ATOM    992  CD  ARG A 133       2.964  -2.859  31.786  1.00 57.69           C  
ATOM    993  NE  ARG A 133       1.722  -2.222  31.371  1.00 59.14           N  
ATOM    994  CZ  ARG A 133       1.558  -1.609  30.204  1.00 60.06           C  
ATOM    995  NH1 ARG A 133       2.561  -1.552  29.338  1.00 60.36           N  
ATOM    996  NH2 ARG A 133       0.392  -1.053  29.901  1.00 60.33           N  
ATOM    997  N   LEU A 134       6.302  -1.543  35.342  1.00 54.55           N  
ATOM    998  CA  LEU A 134       7.634  -0.997  35.568  1.00 54.13           C  
ATOM    999  C   LEU A 134       7.753  -0.613  37.035  1.00 54.37           C  
ATOM   1000  O   LEU A 134       8.803  -0.174  37.503  1.00 53.31           O  
ATOM   1001  CB  LEU A 134       7.867   0.223  34.667  1.00 53.73           C  
ATOM   1002  CG  LEU A 134       7.912  -0.061  33.159  1.00 52.42           C  
ATOM   1003  CD1 LEU A 134       8.181   1.213  32.384  1.00 51.54           C  
ATOM   1004  CD2 LEU A 134       9.001  -1.077  32.873  1.00 51.93           C  
ATOM   1005  N   ASN A 135       6.653  -0.800  37.751  1.00 56.04           N  
ATOM   1006  CA  ASN A 135       6.560  -0.495  39.172  1.00 56.77           C  
ATOM   1007  C   ASN A 135       6.917   0.946  39.520  1.00 55.17           C  
ATOM   1008  O   ASN A 135       7.208   1.254  40.675  1.00 55.40           O  
ATOM   1009  CB  ASN A 135       7.435  -1.447  39.995  1.00 58.49           C  
ATOM   1010  CG  ASN A 135       7.167  -1.330  41.490  1.00 60.00           C  
ATOM   1011  OD1 ASN A 135       6.026  -1.474  41.939  1.00 60.23           O  
ATOM   1012  ND2 ASN A 135       8.216  -1.063  42.267  1.00 60.01           N  
ATOM   1013  N   HIS A 136       6.910   1.831  38.530  1.00 52.39           N  
ATOM   1014  CA  HIS A 136       7.204   3.221  38.824  1.00 50.38           C  
ATOM   1015  C   HIS A 136       6.033   3.691  39.675  1.00 49.87           C  
ATOM   1016  O   HIS A 136       4.874   3.479  39.316  1.00 51.67           O  
ATOM   1017  CB  HIS A 136       7.286   4.056  37.544  1.00 48.23           C  
ATOM   1018  CG  HIS A 136       8.407   3.663  36.632  1.00 46.13           C  
ATOM   1019  ND1 HIS A 136       9.621   3.207  37.099  1.00 43.60           N  
ATOM   1020  CD2 HIS A 136       8.510   3.692  35.282  1.00 43.16           C  
ATOM   1021  CE1 HIS A 136      10.423   2.974  36.076  1.00 42.91           C  
ATOM   1022  NE2 HIS A 136       9.773   3.260  34.963  1.00 42.33           N  
ATOM   1023  N   ARG A 137       6.328   4.298  40.816  1.00 48.37           N  
ATOM   1024  CA  ARG A 137       5.267   4.775  41.689  1.00 46.67           C  
ATOM   1025  C   ARG A 137       5.495   6.251  41.969  1.00 42.69           C  
ATOM   1026  O   ARG A 137       5.583   6.682  43.116  1.00 41.13           O  
ATOM   1027  CB  ARG A 137       5.258   3.973  42.995  1.00 50.85           C  
ATOM   1028  CG  ARG A 137       3.944   4.062  43.756  1.00 56.80           C  
ATOM   1029  CD  ARG A 137       2.774   3.665  42.856  1.00 61.37           C  
ATOM   1030  NE  ARG A 137       1.492   3.711  43.552  1.00 65.30           N  
ATOM   1031  CZ  ARG A 137       1.134   2.873  44.521  1.00 67.49           C  
ATOM   1032  NH1 ARG A 137       1.963   1.913  44.915  1.00 67.63           N  
ATOM   1033  NH2 ARG A 137      -0.055   2.999  45.098  1.00 69.11           N  
ATOM   1034  N   VAL A 138       5.588   7.020  40.892  1.00 37.72           N  
ATOM   1035  CA  VAL A 138       5.826   8.452  40.979  1.00 33.92           C  
ATOM   1036  C   VAL A 138       4.558   9.239  41.290  1.00 31.06           C  
ATOM   1037  O   VAL A 138       3.493   8.951  40.755  1.00 30.80           O  
ATOM   1038  CB  VAL A 138       6.411   8.986  39.641  1.00 32.10           C  
ATOM   1039  CG1 VAL A 138       6.709  10.469  39.748  1.00 28.37           C  
ATOM   1040  CG2 VAL A 138       7.669   8.213  39.277  1.00 32.08           C  
ATOM   1041  N   GLN A 139       4.675  10.221  42.175  1.00 28.58           N  
ATOM   1042  CA  GLN A 139       3.541  11.078  42.489  1.00 27.63           C  
ATOM   1043  C   GLN A 139       3.622  12.189  41.441  1.00 27.18           C  
ATOM   1044  O   GLN A 139       4.592  12.949  41.407  1.00 26.56           O  
ATOM   1045  CB  GLN A 139       3.670  11.669  43.898  1.00 28.84           C  
ATOM   1046  CG  GLN A 139       2.617  12.730  44.206  1.00 27.87           C  
ATOM   1047  CD  GLN A 139       2.758  13.322  45.593  1.00 28.90           C  
ATOM   1048  OE1 GLN A 139       2.480  14.500  45.802  1.00 30.83           O  
ATOM   1049  NE2 GLN A 139       3.179  12.506  46.549  1.00 29.79           N  
ATOM   1050  N   VAL A 140       2.611  12.275  40.583  1.00 26.96           N  
ATOM   1051  CA  VAL A 140       2.596  13.270  39.518  1.00 28.04           C  
ATOM   1052  C   VAL A 140       1.622  14.418  39.776  1.00 29.14           C  
ATOM   1053  O   VAL A 140       0.472  14.197  40.145  1.00 29.19           O  
ATOM   1054  CB  VAL A 140       2.224  12.612  38.157  1.00 29.08           C  
ATOM   1055  CG1 VAL A 140       2.310  13.635  37.037  1.00 28.02           C  
ATOM   1056  CG2 VAL A 140       3.145  11.426  37.878  1.00 29.26           C  
ATOM   1057  N   GLU A 141       2.101  15.643  39.576  1.00 28.96           N  
ATOM   1058  CA  GLU A 141       1.290  16.845  39.750  1.00 30.50           C  
ATOM   1059  C   GLU A 141       1.422  17.650  38.457  1.00 30.49           C  
ATOM   1060  O   GLU A 141       2.502  17.727  37.877  1.00 28.79           O  
ATOM   1061  CB  GLU A 141       1.789  17.666  40.943  1.00 30.22           C  
ATOM   1062  CG  GLU A 141       1.843  16.876  42.244  1.00 35.23           C  
ATOM   1063  CD  GLU A 141       2.296  17.706  43.438  1.00 37.26           C  
ATOM   1064  OE1 GLU A 141       2.746  17.107  44.435  1.00 37.20           O  
ATOM   1065  OE2 GLU A 141       2.194  18.952  43.390  1.00 39.93           O  
ATOM   1066  N   ARG A 142       0.324  18.241  37.997  1.00 31.43           N  
ATOM   1067  CA  ARG A 142       0.364  19.007  36.756  1.00 31.50           C  
ATOM   1068  C   ARG A 142      -0.413  20.314  36.841  1.00 29.80           C  
ATOM   1069  O   ARG A 142      -1.226  20.501  37.740  1.00 31.09           O  
ATOM   1070  CB  ARG A 142      -0.190  18.150  35.620  1.00 32.71           C  
ATOM   1071  CG  ARG A 142      -1.659  17.847  35.760  1.00 36.35           C  
ATOM   1072  CD  ARG A 142      -1.989  16.449  35.286  1.00 41.59           C  
ATOM   1073  NE  ARG A 142      -1.439  15.429  36.177  1.00 44.74           N  
ATOM   1074  CZ  ARG A 142      -1.825  14.158  36.179  1.00 46.16           C  
ATOM   1075  NH1 ARG A 142      -2.764  13.753  35.336  1.00 50.46           N  
ATOM   1076  NH2 ARG A 142      -1.284  13.292  37.024  1.00 46.15           N  
ATOM   1077  N   GLY A 143      -0.151  21.219  35.907  1.00 28.95           N  
ATOM   1078  CA  GLY A 143      -0.856  22.484  35.895  1.00 28.34           C  
ATOM   1079  C   GLY A 143      -0.102  23.670  36.458  1.00 27.98           C  
ATOM   1080  O   GLY A 143      -0.513  24.812  36.262  1.00 31.46           O  
ATOM   1081  N   LEU A 144       0.999  23.418  37.152  1.00 27.63           N  
ATOM   1082  CA  LEU A 144       1.784  24.497  37.737  1.00 26.66           C  
ATOM   1083  C   LEU A 144       2.267  25.464  36.651  1.00 27.45           C  
ATOM   1084  O   LEU A 144       3.112  25.114  35.823  1.00 27.45           O  
ATOM   1085  CB  LEU A 144       2.987  23.923  38.486  1.00 28.14           C  
ATOM   1086  CG  LEU A 144       3.289  24.430  39.900  1.00 28.95           C  
ATOM   1087  CD1 LEU A 144       4.747  24.166  40.200  1.00 27.18           C  
ATOM   1088  CD2 LEU A 144       2.996  25.917  40.025  1.00 30.73           C  
ATOM   1089  N   LEU A 145       1.723  26.679  36.668  1.00 25.47           N  
ATOM   1090  CA  LEU A 145       2.072  27.720  35.704  1.00 23.19           C  
ATOM   1091  C   LEU A 145       1.884  27.268  34.261  1.00 22.60           C  
ATOM   1092  O   LEU A 145       2.637  27.675  33.383  1.00 23.46           O  
ATOM   1093  CB  LEU A 145       3.518  28.169  35.901  1.00 22.15           C  
ATOM   1094  CG  LEU A 145       3.940  28.635  37.293  1.00 24.04           C  
ATOM   1095  CD1 LEU A 145       5.353  29.181  37.227  1.00 23.05           C  
ATOM   1096  CD2 LEU A 145       2.974  29.710  37.801  1.00 23.97           C  
ATOM   1097  N   ALA A 146       0.868  26.443  34.021  1.00 23.71           N  
ATOM   1098  CA  ALA A 146       0.595  25.912  32.686  1.00 25.71           C  
ATOM   1099  C   ALA A 146       0.484  26.979  31.603  1.00 28.14           C  
ATOM   1100  O   ALA A 146       1.007  26.808  30.499  1.00 28.62           O  
ATOM   1101  CB  ALA A 146      -0.679  25.078  32.713  1.00 23.71           C  
ATOM   1102  N   ALA A 147      -0.202  28.075  31.923  1.00 29.34           N  
ATOM   1103  CA  ALA A 147      -0.395  29.169  30.977  1.00 28.83           C  
ATOM   1104  C   ALA A 147       0.930  29.713  30.450  1.00 28.68           C  
ATOM   1105  O   ALA A 147       1.081  29.939  29.245  1.00 28.34           O  
ATOM   1106  CB  ALA A 147      -1.195  30.293  31.637  1.00 29.87           C  
ATOM   1107  N   ASP A 148       1.884  29.923  31.352  1.00 27.15           N  
ATOM   1108  CA  ASP A 148       3.194  30.445  30.979  1.00 28.56           C  
ATOM   1109  C   ASP A 148       3.996  29.412  30.191  1.00 29.44           C  
ATOM   1110  O   ASP A 148       4.658  29.743  29.210  1.00 30.62           O  
ATOM   1111  CB  ASP A 148       3.969  30.854  32.232  1.00 31.14           C  
ATOM   1112  CG  ASP A 148       3.355  32.056  32.932  1.00 35.46           C  
ATOM   1113  OD1 ASP A 148       3.259  32.033  34.177  1.00 35.90           O  
ATOM   1114  OD2 ASP A 148       2.976  33.027  32.239  1.00 36.32           O  
ATOM   1115  N   CYS A 149       3.930  28.159  30.628  1.00 30.05           N  
ATOM   1116  CA  CYS A 149       4.646  27.077  29.965  1.00 29.48           C  
ATOM   1117  C   CYS A 149       4.141  26.908  28.540  1.00 30.77           C  
ATOM   1118  O   CYS A 149       4.919  26.648  27.625  1.00 32.63           O  
ATOM   1119  CB  CYS A 149       4.458  25.769  30.741  1.00 26.48           C  
ATOM   1120  SG  CYS A 149       5.143  25.793  32.418  1.00 25.59           S  
ATOM   1121  N   ALA A 150       2.831  27.062  28.355  1.00 31.41           N  
ATOM   1122  CA  ALA A 150       2.222  26.927  27.039  1.00 31.27           C  
ATOM   1123  C   ALA A 150       2.459  28.171  26.191  1.00 32.29           C  
ATOM   1124  O   ALA A 150       2.584  28.085  24.972  1.00 32.79           O  
ATOM   1125  CB  ALA A 150       0.723  26.670  27.185  1.00 30.32           C  
ATOM   1126  N   ASN A 151       2.532  29.323  26.851  1.00 33.48           N  
ATOM   1127  CA  ASN A 151       2.736  30.607  26.190  1.00 34.54           C  
ATOM   1128  C   ASN A 151       4.092  30.721  25.507  1.00 33.32           C  
ATOM   1129  O   ASN A 151       4.179  31.129  24.344  1.00 32.46           O  
ATOM   1130  CB  ASN A 151       2.591  31.742  27.210  1.00 38.08           C  
ATOM   1131  CG  ASN A 151       2.629  33.115  26.565  1.00 43.93           C  
ATOM   1132  OD1 ASN A 151       3.365  34.003  27.006  1.00 46.82           O  
ATOM   1133  ND2 ASN A 151       1.830  33.300  25.517  1.00 45.59           N  
ATOM   1134  N   ILE A 152       5.152  30.375  26.228  1.00 30.93           N  
ATOM   1135  CA  ILE A 152       6.490  30.455  25.659  1.00 30.19           C  
ATOM   1136  C   ILE A 152       6.620  29.490  24.482  1.00 30.19           C  
ATOM   1137  O   ILE A 152       7.403  29.722  23.560  1.00 29.15           O  
ATOM   1138  CB  ILE A 152       7.582  30.158  26.724  1.00 29.38           C  
ATOM   1139  CG1 ILE A 152       8.964  30.472  26.143  1.00 29.68           C  
ATOM   1140  CG2 ILE A 152       7.494  28.709  27.184  1.00 28.03           C  
ATOM   1141  CD1 ILE A 152      10.098  30.418  27.155  1.00 29.45           C  
ATOM   1142  N   MET A 153       5.831  28.420  24.503  1.00 30.68           N  
ATOM   1143  CA  MET A 153       5.851  27.440  23.423  1.00 32.10           C  
ATOM   1144  C   MET A 153       5.199  28.083  22.196  1.00 32.38           C  
ATOM   1145  O   MET A 153       5.679  27.938  21.075  1.00 31.66           O  
ATOM   1146  CB  MET A 153       5.067  26.187  23.823  1.00 34.73           C  
ATOM   1147  CG  MET A 153       5.433  24.932  23.033  1.00 40.04           C  
ATOM   1148  SD  MET A 153       7.017  24.193  23.540  1.00 42.61           S  
ATOM   1149  CE  MET A 153       6.460  22.898  24.545  1.00 42.05           C  
ATOM   1150  N   GLN A 154       4.094  28.787  22.418  1.00 31.84           N  
ATOM   1151  CA  GLN A 154       3.390  29.454  21.329  1.00 32.43           C  
ATOM   1152  C   GLN A 154       4.328  30.488  20.695  1.00 29.69           C  
ATOM   1153  O   GLN A 154       4.379  30.629  19.473  1.00 29.35           O  
ATOM   1154  CB  GLN A 154       2.116  30.128  21.857  1.00 35.28           C  
ATOM   1155  CG  GLN A 154       1.243  30.726  20.768  1.00 42.82           C  
ATOM   1156  CD  GLN A 154      -0.147  31.090  21.263  1.00 47.72           C  
ATOM   1157  OE1 GLN A 154      -0.906  30.223  21.711  1.00 51.10           O  
ATOM   1158  NE2 GLN A 154      -0.493  32.374  21.181  1.00 48.07           N  
ATOM   1159  N   THR A 155       5.077  31.199  21.531  1.00 26.14           N  
ATOM   1160  CA  THR A 155       6.027  32.191  21.047  1.00 25.47           C  
ATOM   1161  C   THR A 155       7.034  31.503  20.124  1.00 27.19           C  
ATOM   1162  O   THR A 155       7.361  32.006  19.050  1.00 27.99           O  
ATOM   1163  CB  THR A 155       6.779  32.850  22.223  1.00 26.11           C  
ATOM   1164  OG1 THR A 155       5.847  33.585  23.028  1.00 29.68           O  
ATOM   1165  CG2 THR A 155       7.856  33.799  21.718  1.00 25.01           C  
ATOM   1166  N   PHE A 156       7.526  30.348  20.552  1.00 26.90           N  
ATOM   1167  CA  PHE A 156       8.483  29.585  19.762  1.00 25.81           C  
ATOM   1168  C   PHE A 156       7.953  29.266  18.363  1.00 25.58           C  
ATOM   1169  O   PHE A 156       8.651  29.465  17.371  1.00 24.48           O  
ATOM   1170  CB  PHE A 156       8.828  28.274  20.472  1.00 25.44           C  
ATOM   1171  CG  PHE A 156       9.623  27.323  19.625  1.00 24.59           C  
ATOM   1172  CD1 PHE A 156      10.941  27.608  19.285  1.00 25.38           C  
ATOM   1173  CD2 PHE A 156       9.049  26.150  19.155  1.00 25.75           C  
ATOM   1174  CE1 PHE A 156      11.679  26.733  18.485  1.00 26.70           C  
ATOM   1175  CE2 PHE A 156       9.775  25.270  18.356  1.00 27.80           C  
ATOM   1176  CZ  PHE A 156      11.092  25.563  18.021  1.00 25.56           C  
ATOM   1177  N   PHE A 157       6.724  28.761  18.288  1.00 25.57           N  
ATOM   1178  CA  PHE A 157       6.130  28.403  17.004  1.00 27.74           C  
ATOM   1179  C   PHE A 157       5.913  29.587  16.077  1.00 27.95           C  
ATOM   1180  O   PHE A 157       6.079  29.460  14.859  1.00 28.24           O  
ATOM   1181  CB  PHE A 157       4.807  27.663  17.213  1.00 30.32           C  
ATOM   1182  CG  PHE A 157       4.961  26.352  17.919  1.00 33.16           C  
ATOM   1183  CD1 PHE A 157       5.845  25.395  17.440  1.00 35.32           C  
ATOM   1184  CD2 PHE A 157       4.238  26.079  19.073  1.00 35.20           C  
ATOM   1185  CE1 PHE A 157       6.011  24.181  18.106  1.00 36.93           C  
ATOM   1186  CE2 PHE A 157       4.397  24.870  19.743  1.00 36.54           C  
ATOM   1187  CZ  PHE A 157       5.284  23.922  19.259  1.00 35.55           C  
ATOM   1188  N   ARG A 158       5.538  30.729  16.646  1.00 28.14           N  
ATOM   1189  CA  ARG A 158       5.319  31.936  15.852  1.00 29.46           C  
ATOM   1190  C   ARG A 158       6.656  32.396  15.296  1.00 28.75           C  
ATOM   1191  O   ARG A 158       6.773  32.722  14.119  1.00 29.00           O  
ATOM   1192  CB  ARG A 158       4.732  33.060  16.710  1.00 32.15           C  
ATOM   1193  CG  ARG A 158       4.332  34.287  15.896  1.00 37.05           C  
ATOM   1194  CD  ARG A 158       4.223  35.529  16.764  1.00 40.21           C  
ATOM   1195  NE  ARG A 158       5.535  36.107  17.055  1.00 43.45           N  
ATOM   1196  CZ  ARG A 158       5.962  36.410  18.274  1.00 42.96           C  
ATOM   1197  NH1 ARG A 158       5.185  36.187  19.322  1.00 44.43           N  
ATOM   1198  NH2 ARG A 158       7.162  36.942  18.445  1.00 44.25           N  
ATOM   1199  N   GLN A 159       7.666  32.421  16.158  1.00 28.74           N  
ATOM   1200  CA  GLN A 159       8.997  32.832  15.746  1.00 28.20           C  
ATOM   1201  C   GLN A 159       9.528  31.872  14.686  1.00 29.19           C  
ATOM   1202  O   GLN A 159      10.237  32.279  13.766  1.00 28.12           O  
ATOM   1203  CB  GLN A 159       9.926  32.877  16.961  1.00 29.30           C  
ATOM   1204  CG  GLN A 159       9.600  34.026  17.921  1.00 30.19           C  
ATOM   1205  CD  GLN A 159      10.432  34.015  19.194  1.00 32.77           C  
ATOM   1206  OE1 GLN A 159      10.451  34.995  19.943  1.00 34.25           O  
ATOM   1207  NE2 GLN A 159      11.115  32.906  19.450  1.00 31.31           N  
ATOM   1208  N   GLY A 160       9.156  30.599  14.808  1.00 29.36           N  
ATOM   1209  CA  GLY A 160       9.591  29.600  13.849  1.00 29.69           C  
ATOM   1210  C   GLY A 160       9.022  29.883  12.473  1.00 31.71           C  
ATOM   1211  O   GLY A 160       9.713  29.740  11.458  1.00 30.71           O  
ATOM   1212  N   ARG A 161       7.755  30.282  12.425  1.00 31.38           N  
ATOM   1213  CA  ARG A 161       7.133  30.599  11.147  1.00 32.62           C  
ATOM   1214  C   ARG A 161       7.806  31.833  10.545  1.00 32.03           C  
ATOM   1215  O   ARG A 161       8.019  31.905   9.339  1.00 32.14           O  
ATOM   1216  CB  ARG A 161       5.639  30.868  11.317  1.00 32.90           C  
ATOM   1217  CG  ARG A 161       4.832  29.678  11.812  1.00 37.70           C  
ATOM   1218  CD  ARG A 161       3.359  29.852  11.467  1.00 40.53           C  
ATOM   1219  NE  ARG A 161       2.831  31.140  11.915  1.00 45.29           N  
ATOM   1220  CZ  ARG A 161       2.662  31.479  13.190  1.00 46.51           C  
ATOM   1221  NH1 ARG A 161       2.977  30.621  14.152  1.00 48.36           N  
ATOM   1222  NH2 ARG A 161       2.180  32.676  13.502  1.00 46.37           N  
ATOM   1223  N   GLU A 162       8.144  32.801  11.393  1.00 31.83           N  
ATOM   1224  CA  GLU A 162       8.787  34.024  10.926  1.00 31.71           C  
ATOM   1225  C   GLU A 162      10.173  33.740  10.363  1.00 32.12           C  
ATOM   1226  O   GLU A 162      10.559  34.310   9.342  1.00 31.23           O  
ATOM   1227  CB  GLU A 162       8.889  35.037  12.063  1.00 32.44           C  
ATOM   1228  CG  GLU A 162       7.557  35.356  12.703  1.00 34.17           C  
ATOM   1229  CD  GLU A 162       7.674  36.403  13.783  1.00 37.25           C  
ATOM   1230  OE1 GLU A 162       8.724  36.448  14.458  1.00 42.07           O  
ATOM   1231  OE2 GLU A 162       6.709  37.172  13.975  1.00 40.57           O  
ATOM   1232  N   ARG A 163      10.918  32.865  11.036  1.00 31.38           N  
ATOM   1233  CA  ARG A 163      12.259  32.499  10.590  1.00 33.09           C  
ATOM   1234  C   ARG A 163      12.164  31.753   9.260  1.00 34.15           C  
ATOM   1235  O   ARG A 163      12.994  31.930   8.374  1.00 32.31           O  
ATOM   1236  CB  ARG A 163      12.952  31.608  11.630  1.00 33.80           C  
ATOM   1237  CG  ARG A 163      13.190  32.275  12.982  1.00 35.04           C  
ATOM   1238  CD  ARG A 163      14.138  31.452  13.858  1.00 39.05           C  
ATOM   1239  NE  ARG A 163      13.560  30.183  14.298  1.00 41.02           N  
ATOM   1240  CZ  ARG A 163      12.920  30.004  15.452  1.00 44.52           C  
ATOM   1241  NH1 ARG A 163      12.770  31.019  16.295  1.00 45.41           N  
ATOM   1242  NH2 ARG A 163      12.433  28.809  15.768  1.00 44.68           N  
ATOM   1243  N   LYS A 164      11.136  30.920   9.136  1.00 34.78           N  
ATOM   1244  CA  LYS A 164      10.904  30.133   7.933  1.00 36.75           C  
ATOM   1245  C   LYS A 164      10.510  31.034   6.762  1.00 37.88           C  
ATOM   1246  O   LYS A 164      10.826  30.749   5.606  1.00 37.85           O  
ATOM   1247  CB  LYS A 164       9.796  29.111   8.205  1.00 39.84           C  
ATOM   1248  CG  LYS A 164       9.331  28.307   6.998  1.00 43.65           C  
ATOM   1249  CD  LYS A 164       8.076  27.515   7.346  1.00 45.46           C  
ATOM   1250  CE  LYS A 164       7.606  26.647   6.189  1.00 47.93           C  
ATOM   1251  NZ  LYS A 164       8.614  25.604   5.843  1.00 50.46           N  
ATOM   1252  N   LYS A 165       9.817  32.125   7.067  1.00 37.87           N  
ATOM   1253  CA  LYS A 165       9.377  33.060   6.045  1.00 37.59           C  
ATOM   1254  C   LYS A 165      10.568  33.854   5.515  1.00 37.52           C  
ATOM   1255  O   LYS A 165      10.668  34.118   4.317  1.00 36.43           O  
ATOM   1256  CB  LYS A 165       8.326  34.004   6.625  1.00 39.79           C  
ATOM   1257  CG  LYS A 165       7.457  34.690   5.591  1.00 44.46           C  
ATOM   1258  CD  LYS A 165       6.255  35.341   6.259  1.00 47.35           C  
ATOM   1259  CE  LYS A 165       5.262  35.860   5.236  1.00 50.76           C  
ATOM   1260  NZ  LYS A 165       4.028  36.396   5.892  1.00 53.18           N  
ATOM   1261  N   ILE A 166      11.471  34.233   6.413  1.00 36.41           N  
ATOM   1262  CA  ILE A 166      12.658  34.978   6.021  1.00 35.44           C  
ATOM   1263  C   ILE A 166      13.558  34.090   5.163  1.00 36.06           C  
ATOM   1264  O   ILE A 166      14.062  34.522   4.127  1.00 34.43           O  
ATOM   1265  CB  ILE A 166      13.454  35.463   7.255  1.00 35.69           C  
ATOM   1266  CG1 ILE A 166      12.630  36.486   8.039  1.00 34.90           C  
ATOM   1267  CG2 ILE A 166      14.771  36.083   6.815  1.00 35.99           C  
ATOM   1268  CD1 ILE A 166      13.311  36.997   9.292  1.00 34.90           C  
ATOM   1269  N   ALA A 167      13.743  32.847   5.595  1.00 36.21           N  
ATOM   1270  CA  ALA A 167      14.579  31.896   4.870  1.00 38.55           C  
ATOM   1271  C   ALA A 167      14.028  31.640   3.473  1.00 39.86           C  
ATOM   1272  O   ALA A 167      14.786  31.547   2.506  1.00 40.65           O  
ATOM   1273  CB  ALA A 167      14.678  30.581   5.641  1.00 36.82           C  
ATOM   1274  N   LYS A 168      12.707  31.522   3.368  1.00 40.67           N  
ATOM   1275  CA  LYS A 168      12.078  31.282   2.078  1.00 42.42           C  
ATOM   1276  C   LYS A 168      12.323  32.469   1.153  1.00 43.74           C  
ATOM   1277  O   LYS A 168      12.539  32.298  -0.048  1.00 42.85           O  
ATOM   1278  CB  LYS A 168      10.572  31.068   2.246  1.00 43.50           C  
ATOM   1279  CG  LYS A 168       9.841  30.879   0.926  1.00 46.33           C  
ATOM   1280  CD  LYS A 168       8.342  30.743   1.116  1.00 48.52           C  
ATOM   1281  CE  LYS A 168       7.643  30.547  -0.222  1.00 49.13           C  
ATOM   1282  NZ  LYS A 168       6.160  30.505  -0.073  1.00 50.25           N  
ATOM   1283  N   HIS A 169      12.289  33.669   1.724  1.00 44.78           N  
ATOM   1284  CA  HIS A 169      12.504  34.900   0.970  1.00 46.87           C  
ATOM   1285  C   HIS A 169      13.935  35.038   0.453  1.00 48.46           C  
ATOM   1286  O   HIS A 169      14.150  35.459  -0.681  1.00 48.87           O  
ATOM   1287  CB  HIS A 169      12.164  36.112   1.839  1.00 46.31           C  
ATOM   1288  CG  HIS A 169      12.652  37.413   1.280  1.00 47.05           C  
ATOM   1289  ND1 HIS A 169      12.082  38.013   0.178  1.00 47.66           N  
ATOM   1290  CD2 HIS A 169      13.672  38.220   1.662  1.00 46.51           C  
ATOM   1291  CE1 HIS A 169      12.730  39.132  -0.096  1.00 48.10           C  
ATOM   1292  NE2 HIS A 169      13.698  39.280   0.790  1.00 46.16           N  
ATOM   1293  N   LEU A 170      14.908  34.690   1.289  1.00 50.48           N  
ATOM   1294  CA  LEU A 170      16.315  34.797   0.916  1.00 52.92           C  
ATOM   1295  C   LEU A 170      16.727  33.760  -0.122  1.00 55.49           C  
ATOM   1296  O   LEU A 170      17.562  34.036  -0.983  1.00 55.18           O  
ATOM   1297  CB  LEU A 170      17.200  34.673   2.159  1.00 51.18           C  
ATOM   1298  CG  LEU A 170      17.015  35.768   3.213  1.00 50.98           C  
ATOM   1299  CD1 LEU A 170      17.914  35.495   4.404  1.00 49.64           C  
ATOM   1300  CD2 LEU A 170      17.332  37.128   2.608  1.00 50.21           C  
ATOM   1301  N   ILE A 171      16.145  32.567  -0.033  1.00 58.40           N  
ATOM   1302  CA  ILE A 171      16.445  31.498  -0.981  1.00 61.68           C  
ATOM   1303  C   ILE A 171      15.920  31.891  -2.361  1.00 64.10           C  
ATOM   1304  O   ILE A 171      16.613  31.749  -3.366  1.00 63.53           O  
ATOM   1305  CB  ILE A 171      15.780  30.165  -0.564  1.00 61.89           C  
ATOM   1306  CG1 ILE A 171      16.424  29.628   0.716  1.00 62.27           C  
ATOM   1307  CG2 ILE A 171      15.911  29.144  -1.680  1.00 62.87           C  
ATOM   1308  CD1 ILE A 171      17.881  29.234   0.555  1.00 63.05           C  
ATOM   1309  N   LYS A 172      14.686  32.384  -2.394  1.00 67.23           N  
ATOM   1310  CA  LYS A 172      14.055  32.803  -3.637  1.00 70.44           C  
ATOM   1311  C   LYS A 172      14.949  33.797  -4.369  1.00 72.32           C  
ATOM   1312  O   LYS A 172      15.594  33.455  -5.359  1.00 72.52           O  
ATOM   1313  CB  LYS A 172      12.698  33.448  -3.345  1.00 71.42           C  
ATOM   1314  CG  LYS A 172      11.939  33.900  -4.582  1.00 72.87           C  
ATOM   1315  CD  LYS A 172      10.683  34.673  -4.207  1.00 74.66           C  
ATOM   1316  CE  LYS A 172       9.718  33.817  -3.393  1.00 76.45           C  
ATOM   1317  NZ  LYS A 172       8.497  34.574  -2.989  1.00 77.46           N  
ATOM   1318  N   GLU A 173      14.985  35.030  -3.872  1.00 74.37           N  
ATOM   1319  CA  GLU A 173      15.800  36.075  -4.477  1.00 76.25           C  
ATOM   1320  C   GLU A 173      16.346  37.034  -3.422  1.00 76.17           C  
ATOM   1321  O   GLU A 173      15.624  37.893  -2.917  1.00 75.95           O  
ATOM   1322  CB  GLU A 173      14.978  36.854  -5.509  1.00 77.70           C  
ATOM   1323  CG  GLU A 173      14.404  35.990  -6.626  1.00 78.61           C  
ATOM   1324  CD  GLU A 173      13.713  36.804  -7.703  1.00 79.40           C  
ATOM   1325  OE1 GLU A 173      12.750  37.532  -7.378  1.00 79.00           O  
ATOM   1326  OE2 GLU A 173      14.135  36.715  -8.875  1.00 80.01           O  
TER    1327      GLU A 173                                                      
END
MOLECULE T0461.pdb
ATOM      1  N   GLU    16      19.319  11.894  58.181  1.00 47.03           N  
ATOM      2  CA  GLU    16      18.212  11.089  57.593  1.00 47.23           C  
ATOM      4  CB  GLU    16      18.010   9.793  58.377  1.00 47.32           C  
ATOM      7  CG  GLU    16      17.576   8.619  57.509  1.00 48.39           C  
ATOM     10  CD  GLU    16      17.064   7.416  58.327  1.00 50.46           C  
ATOM     11  OE1 GLU    16      16.178   6.689  57.811  1.00 51.91           O  
ATOM     12  OE2 GLU    16      17.526   7.196  59.479  1.00 50.93           O  
ATOM     13  C   GLU    16      16.896  11.864  57.561  1.00 47.09           C  
ATOM     14  O   GLU    16      15.891  11.376  57.001  1.00 48.08           O  
ATOM     18  N   ASN    17      16.888  13.066  58.143  1.00 46.06           N  
ATOM     19  CA  ASN    17      15.679  13.870  58.188  1.00 45.28           C  
ATOM     21  CB  ASN    17      15.631  14.676  59.487  1.00 45.17           C  
ATOM     24  CG  ASN    17      14.246  15.250  59.773  1.00 44.92           C  
ATOM     25  OD1 ASN    17      13.421  15.378  58.885  1.00 45.51           O  
ATOM     26  ND2 ASN    17      13.989  15.591  61.023  1.00 45.12           N  
ATOM     29  C   ASN    17      15.619  14.792  56.990  1.00 44.97           C  
ATOM     30  O   ASN    17      16.071  15.922  57.046  1.00 44.78           O  
ATOM     32  N   LEU    18      15.026  14.320  55.910  1.00 45.02           N  
ATOM     33  CA  LEU    18      14.988  15.101  54.659  1.00 45.41           C  
ATOM     35  CB  LEU    18      14.792  14.167  53.453  1.00 45.35           C  
ATOM     38  CG  LEU    18      15.875  13.083  53.322  1.00 45.26           C  
ATOM     40  CD1 LEU    18      15.492  12.097  52.210  1.00 45.69           C  
ATOM     44  CD2 LEU    18      17.267  13.703  53.084  1.00 42.76           C  
ATOM     48  C   LEU    18      13.920  16.202  54.656  1.00 45.40           C  
ATOM     49  O   LEU    18      12.854  16.047  55.244  1.00 46.03           O  
ATOM     51  N   TYR    19      14.208  17.291  53.954  1.00 45.10           N  
ATOM     52  CA  TYR    19      13.361  18.473  53.903  1.00 44.79           C  
ATOM     54  CB  TYR    19      14.284  19.669  53.829  1.00 45.04           C  
ATOM     57  CG  TYR    19      13.663  21.040  53.814  1.00 45.91           C  
ATOM     58  CD1 TYR    19      13.769  21.878  54.930  1.00 46.50           C  
ATOM     60  CE1 TYR    19      13.223  23.142  54.930  1.00 46.23           C  
ATOM     62  CZ  TYR    19      12.595  23.603  53.806  1.00 45.82           C  
ATOM     63  OH  TYR    19      12.078  24.858  53.838  1.00 47.34           O  
ATOM     65  CE2 TYR    19      12.478  22.813  52.668  1.00 46.79           C  
ATOM     67  CD2 TYR    19      13.017  21.538  52.672  1.00 46.25           C  
ATOM     69  C   TYR    19      12.486  18.434  52.655  1.00 45.02           C  
ATOM     70  O   TYR    19      12.973  18.134  51.545  1.00 44.56           O  
ATOM     72  N   PHE    20      11.200  18.768  52.836  1.00 45.35           N  
ATOM     73  CA  PHE    20      10.180  18.735  51.761  1.00 44.99           C  
ATOM     75  CB  PHE    20       8.875  18.070  52.229  1.00 44.60           C  
ATOM     78  CG  PHE    20       8.967  16.583  52.430  1.00 44.31           C  
ATOM     79  CD1 PHE    20       8.814  16.023  53.683  1.00 45.43           C  
ATOM     81  CE1 PHE    20       8.871  14.634  53.877  1.00 44.99           C  
ATOM     83  CZ  PHE    20       9.077  13.820  52.843  1.00 43.54           C  
ATOM     85  CE2 PHE    20       9.199  14.351  51.588  1.00 44.96           C  
ATOM     87  CD2 PHE    20       9.152  15.735  51.379  1.00 44.56           C  
ATOM     89  C   PHE    20       9.859  20.151  51.339  1.00 44.84           C  
ATOM     90  O   PHE    20       9.575  20.984  52.162  1.00 45.26           O  
ATOM     92  N   GLN    21       9.875  20.414  50.048  1.00 45.39           N  
ATOM     93  CA  GLN    21       9.553  21.743  49.542  1.00 45.85           C  
ATOM     95  CB  GLN    21       9.966  21.882  48.065  1.00 46.10           C  
ATOM     98  CG  GLN    21      11.462  21.638  47.776  1.00 45.85           C  
ATOM    101  CD  GLN    21      12.355  22.618  48.495  1.00 46.50           C  
ATOM    102  OE1 GLN    21      12.212  23.845  48.353  1.00 47.26           O  
ATOM    103  NE2 GLN    21      13.273  22.092  49.288  1.00 45.90           N  
ATOM    106  C   GLN    21       8.049  22.035  49.714  1.00 46.07           C  
ATOM    107  O   GLN    21       7.198  21.166  49.469  1.00 45.86           O  
ATOM    109  N   SER    22       7.741  23.259  50.150  1.00 45.86           N  
ATOM    110  CA  SER    22       6.375  23.680  50.384  1.00 45.60           C  
ATOM    112  CB  SER    22       6.366  24.830  51.367  1.00 45.59           C  
ATOM    115  OG  SER    22       6.782  26.037  50.750  1.00 46.30           O  
ATOM    117  C   SER    22       5.742  24.134  49.088  1.00 45.80           C  
ATOM    118  O   SER    22       6.407  24.114  48.046  1.00 45.84           O  
ATOM    120  N   MET    23       4.473  24.560  49.153  1.00 46.02           N  
ATOM    121  CA  MET    23       3.772  25.115  47.983  1.00 46.05           C  
ATOM    123  CB  MET    23       2.313  25.460  48.298  1.00 46.56           C  
ATOM    126  CG  MET    23       1.275  24.330  48.059  1.00 48.82           C  
ATOM    129  SD  MET    23       1.254  23.496  46.412  1.00 52.49           S  
ATOM    130  CE  MET    23      -0.396  22.776  46.537  1.00 50.38           C  
ATOM    134  C   MET    23       4.432  26.367  47.439  1.00 45.55           C  
ATOM    135  O   MET    23       4.601  26.477  46.236  1.00 45.57           O  
ATOM    137  N   GLU    24       4.773  27.312  48.309  1.00 45.12           N  
ATOM    138  CA  GLU    24       5.405  28.529  47.862  1.00 45.24           C  
ATOM    140  CB  GLU    24       5.574  29.505  49.001  1.00 45.00           C  
ATOM    143  CG  GLU    24       4.249  30.004  49.540  1.00 45.52           C  
ATOM    146  CD  GLU    24       4.420  31.305  50.323  1.00 47.26           C  
ATOM    147  OE1 GLU    24       5.446  31.973  50.070  1.00 48.66           O  
ATOM    148  OE2 GLU    24       3.543  31.676  51.171  1.00 46.60           O  
ATOM    149  C   GLU    24       6.756  28.195  47.248  1.00 45.58           C  
ATOM    150  O   GLU    24       7.118  28.700  46.165  1.00 45.97           O  
ATOM    152  N   GLU    25       7.499  27.321  47.916  1.00 45.42           N  
ATOM    153  CA  GLU    25       8.791  26.893  47.383  1.00 45.38           C  
ATOM    155  CB  GLU    25       9.527  26.016  48.395  1.00 45.48           C  
ATOM    158  CG  GLU    25       9.801  26.759  49.699  1.00 46.23           C  
ATOM    161  CD  GLU    25      10.373  25.873  50.810  1.00 47.64           C  
ATOM    162  OE1 GLU    25       9.890  24.719  51.016  1.00 46.52           O  
ATOM    163  OE2 GLU    25      11.298  26.364  51.498  1.00 48.29           O  
ATOM    164  C   GLU    25       8.695  26.205  46.022  1.00 44.72           C  
ATOM    165  O   GLU    25       9.574  26.385  45.200  1.00 44.67           O  
ATOM    167  N   THR    26       7.633  25.425  45.805  1.00 44.33           N  
ATOM    168  CA  THR    26       7.333  24.809  44.497  1.00 43.62           C  
ATOM    170  CB  THR    26       6.097  23.810  44.583  1.00 43.61           C  
ATOM    172  OG1 THR    26       6.387  22.773  45.511  1.00 42.09           O  
ATOM    174  CG2 THR    26       5.748  23.157  43.247  1.00 42.42           C  
ATOM    178  C   THR    26       7.092  25.942  43.492  1.00 43.04           C  
ATOM    179  O   THR    26       7.712  25.993  42.437  1.00 42.50           O  
ATOM    181  N   GLU    27       6.220  26.875  43.843  1.00 42.37           N  
ATOM    182  CA  GLU    27       5.971  28.002  42.978  1.00 42.31           C  
ATOM    184  CB  GLU    27       5.035  29.005  43.622  1.00 42.84           C  
ATOM    187  CG  GLU    27       3.580  28.566  43.707  1.00 44.60           C  
ATOM    190  CD  GLU    27       2.700  29.690  44.267  1.00 47.31           C  
ATOM    191  OE1 GLU    27       3.193  30.857  44.272  1.00 48.72           O  
ATOM    192  OE2 GLU    27       1.529  29.432  44.703  1.00 48.41           O  
ATOM    193  C   GLU    27       7.270  28.692  42.631  1.00 40.95           C  
ATOM    194  O   GLU    27       7.497  29.041  41.480  1.00 41.59           O  
ATOM    196  N   LYS    28       8.126  28.886  43.622  1.00 39.03           N  
ATOM    197  CA  LYS    28       9.440  29.455  43.359  1.00 37.62           C  
ATOM    199  CB  LYS    28      10.250  29.534  44.641  1.00 37.50           C  
ATOM    202  CG  LYS    28      11.590  30.230  44.447  1.00 38.41           C  
ATOM    205  CD  LYS    28      12.753  29.466  45.069  1.00 39.23           C  
ATOM    208  CE  LYS    28      12.679  29.456  46.565  1.00 38.91           C  
ATOM    211  NZ  LYS    28      13.578  28.418  47.073  1.00 40.24           N  
ATOM    215  C   LYS    28      10.246  28.672  42.302  1.00 35.90           C  
ATOM    216  O   LYS    28      10.746  29.267  41.371  1.00 36.93           O  
ATOM    218  N   TRP    29      10.371  27.357  42.443  1.00 33.27           N  
ATOM    219  CA  TRP    29      11.165  26.570  41.498  1.00 31.54           C  
ATOM    221  CB  TRP    29      11.338  25.115  41.957  1.00 30.99           C  
ATOM    224  CG  TRP    29      11.998  24.926  43.278  1.00 30.44           C  
ATOM    225  CD1 TRP    29      11.570  24.110  44.281  1.00 30.13           C  
ATOM    227  NE1 TRP    29      12.435  24.175  45.351  1.00 30.02           N  
ATOM    229  CE2 TRP    29      13.444  25.050  45.056  1.00 29.08           C  
ATOM    230  CD2 TRP    29      13.206  25.551  43.764  1.00 29.84           C  
ATOM    231  CE3 TRP    29      14.106  26.479  43.230  1.00 30.17           C  
ATOM    233  CZ3 TRP    29      15.182  26.878  43.993  1.00 29.10           C  
ATOM    235  CH2 TRP    29      15.381  26.365  45.270  1.00 28.82           C  
ATOM    237  CZ2 TRP    29      14.522  25.453  45.820  1.00 28.69           C  
ATOM    239  C   TRP    29      10.577  26.553  40.093  1.00 30.66           C  
ATOM    240  O   TRP    29      11.321  26.503  39.114  1.00 30.04           O  
ATOM    242  N   MET    30       9.250  26.560  39.994  1.00 29.83           N  
ATOM    243  CA  MET    30       8.583  26.606  38.693  1.00 29.32           C  
ATOM    245  CB  MET    30       7.080  26.363  38.827  1.00 29.13           C  
ATOM    248  CG  MET    30       6.695  24.908  39.105  1.00 28.73           C  
ATOM    251  SD  MET    30       7.113  23.702  37.840  1.00 25.62           S  
ATOM    252  CE  MET    30       6.050  24.188  36.496  1.00 25.40           C  
ATOM    256  C   MET    30       8.816  27.922  37.964  1.00 28.82           C  
ATOM    257  O   MET    30       8.940  27.927  36.765  1.00 28.66           O  
ATOM    259  N   GLU    31       8.873  29.027  38.689  1.00 28.72           N  
ATOM    260  CA  GLU    31       9.214  30.321  38.090  1.00 29.06           C  
ATOM    262  CB  GLU    31       9.174  31.465  39.137  1.00 29.45           C  
ATOM    265  CG  GLU    31       7.991  32.434  39.044  1.00 29.57           C  
ATOM    268  CD  GLU    31       7.831  33.294  40.339  1.00 33.21           C  
ATOM    269  OE1 GLU    31       7.467  34.564  40.270  1.00 32.31           O  
ATOM    270  OE2 GLU    31       8.075  32.684  41.452  1.00 35.33           O  
ATOM    271  C   GLU    31      10.604  30.262  37.479  1.00 28.87           C  
ATOM    272  O   GLU    31      10.827  30.752  36.382  1.00 28.74           O  
ATOM    274  N   GLU    32      11.544  29.670  38.205  1.00 28.87           N  
ATOM    275  CA  GLU    32      12.909  29.533  37.701  1.00 29.07           C  
ATOM    277  CB  GLU    32      13.876  29.003  38.777  1.00 29.29           C  
ATOM    280  CG  GLU    32      15.319  29.531  38.660  1.00 30.35           C  
ATOM    283  CD  GLU    32      16.038  29.670  40.034  1.00 32.92           C  
ATOM    284  OE1 GLU    32      16.446  28.584  40.580  1.00 33.02           O  
ATOM    285  OE2 GLU    32      16.223  30.868  40.532  1.00 32.31           O  
ATOM    286  C   GLU    32      12.932  28.636  36.474  1.00 29.00           C  
ATOM    287  O   GLU    32      13.630  28.954  35.536  1.00 29.87           O  
ATOM    289  N   ALA    33      12.176  27.534  36.469  1.00 28.65           N  
ATOM    290  CA  ALA    33      12.074  26.677  35.272  1.00 28.41           C  
ATOM    292  CB  ALA    33      11.272  25.376  35.580  1.00 28.13           C  
ATOM    296  C   ALA    33      11.467  27.433  34.073  1.00 27.98           C  
ATOM    297  O   ALA    33      11.779  27.140  32.919  1.00 27.17           O  
ATOM    299  N   MET    34      10.613  28.412  34.367  1.00 27.93           N  
ATOM    300  CA  MET    34       9.948  29.219  33.339  1.00 28.14           C  
ATOM    302  CB  MET    34       8.803  30.030  33.949  1.00 28.21           C  
ATOM    305  CG  MET    34       7.517  29.250  34.113  1.00 28.80           C  
ATOM    308  SD  MET    34       6.705  28.872  32.536  1.00 30.50           S  
ATOM    309  CE  MET    34       6.132  30.522  32.012  1.00 29.12           C  
ATOM    313  C   MET    34      10.916  30.175  32.664  1.00 28.10           C  
ATOM    314  O   MET    34      10.875  30.374  31.449  1.00 27.67           O  
ATOM    316  N   HIS    35      11.789  30.765  33.467  1.00 28.28           N  
ATOM    317  CA  HIS    35      12.821  31.630  32.951  1.00 28.33           C  
ATOM    319  CB  HIS    35      13.581  32.265  34.112  1.00 28.41           C  
ATOM    322  CG  HIS    35      12.858  33.425  34.730  1.00 29.93           C  
ATOM    323  ND1 HIS    35      11.876  34.132  34.062  1.00 31.57           N  
ATOM    325  CE1 HIS    35      11.437  35.118  34.832  1.00 31.30           C  
ATOM    327  NE2 HIS    35      12.092  35.071  35.978  1.00 31.32           N  
ATOM    329  CD2 HIS    35      12.985  34.021  35.943  1.00 31.00           C  
ATOM    331  C   HIS    35      13.742  30.839  32.027  1.00 28.17           C  
ATOM    332  O   HIS    35      14.065  31.289  30.934  1.00 27.82           O  
ATOM    334  N   MET    36      14.123  29.641  32.458  1.00 28.15           N  
ATOM    335  CA  MET    36      14.961  28.760  31.661  1.00 28.40           C  
ATOM    337  CB  MET    36      15.322  27.506  32.450  1.00 28.40           C  
ATOM    340  CG  MET    36      16.315  27.796  33.560  1.00 29.25           C  
ATOM    343  SD  MET    36      16.813  26.309  34.428  1.00 31.57           S  
ATOM    344  CE  MET    36      18.067  25.576  33.340  1.00 32.53           C  
ATOM    348  C   MET    36      14.308  28.388  30.336  1.00 28.59           C  
ATOM    349  O   MET    36      14.979  28.316  29.303  1.00 28.44           O  
ATOM    351  N   ALA    37      12.999  28.161  30.359  1.00 28.78           N  
ATOM    352  CA  ALA    37      12.272  27.908  29.139  1.00 28.45           C  
ATOM    354  CB  ALA    37      10.865  27.523  29.464  1.00 28.21           C  
ATOM    358  C   ALA    37      12.350  29.138  28.203  1.00 28.53           C  
ATOM    359  O   ALA    37      12.535  28.976  26.991  1.00 28.74           O  
ATOM    361  N   LYS    38      12.254  30.353  28.753  1.00 28.46           N  
ATOM    362  CA  LYS    38      12.479  31.585  27.952  1.00 28.77           C  
ATOM    364  CB  LYS    38      12.362  32.855  28.810  1.00 28.84           C  
ATOM    367  CG  LYS    38      11.173  33.763  28.490  1.00 29.78           C  
ATOM    370  CD  LYS    38      10.670  34.538  29.775  1.00 31.42           C  
ATOM    373  CE  LYS    38       9.790  33.635  30.740  1.00 31.00           C  
ATOM    376  NZ  LYS    38       9.628  34.146  32.144  1.00 30.04           N  
ATOM    380  C   LYS    38      13.844  31.602  27.254  1.00 28.67           C  
ATOM    381  O   LYS    38      13.935  31.826  26.059  1.00 28.60           O  
ATOM    383  N   GLU    39      14.903  31.388  28.029  1.00 28.92           N  
ATOM    384  CA  GLU    39      16.255  31.241  27.491  1.00 29.07           C  
ATOM    386  CB  GLU    39      17.256  30.896  28.615  1.00 29.32           C  
ATOM    389  CG  GLU    39      17.683  32.092  29.525  1.00 29.97           C  
ATOM    392  CD  GLU    39      18.618  31.675  30.698  1.00 30.95           C  
ATOM    393  OE1 GLU    39      18.395  30.602  31.336  1.00 31.36           O  
ATOM    394  OE2 GLU    39      19.579  32.435  30.976  1.00 30.64           O  
ATOM    395  C   GLU    39      16.323  30.161  26.391  1.00 29.31           C  
ATOM    396  O   GLU    39      16.994  30.352  25.385  1.00 29.93           O  
ATOM    398  N   ALA    40      15.655  29.025  26.568  1.00 29.26           N  
ATOM    399  CA  ALA    40      15.675  27.990  25.538  1.00 29.14           C  
ATOM    401  CB  ALA    40      14.954  26.733  26.023  1.00 29.09           C  
ATOM    405  C   ALA    40      15.052  28.523  24.233  1.00 29.31           C  
ATOM    406  O   ALA    40      15.647  28.416  23.135  1.00 29.24           O  
ATOM    408  N   LEU    41      13.866  29.115  24.357  1.00 29.40           N  
ATOM    409  CA  LEU    41      13.176  29.725  23.208  1.00 29.34           C  
ATOM    411  CB  LEU    41      12.006  30.573  23.716  1.00 29.30           C  
ATOM    414  CG  LEU    41      11.070  31.167  22.677  1.00 28.71           C  
ATOM    416  CD1 LEU    41      10.148  30.062  22.197  1.00 28.68           C  
ATOM    420  CD2 LEU    41      10.302  32.340  23.267  1.00 27.42           C  
ATOM    424  C   LEU    41      14.117  30.616  22.372  1.00 29.48           C  
ATOM    425  O   LEU    41      14.211  30.475  21.134  1.00 29.85           O  
ATOM    427  N   GLU    42      14.821  31.511  23.067  1.00 29.00           N  
ATOM    428  CA  GLU    42      15.649  32.517  22.438  1.00 28.74           C  
ATOM    430  CB  GLU    42      15.908  33.598  23.449  1.00 28.67           C  
ATOM    433  CG  GLU    42      14.645  34.363  23.746  1.00 29.55           C  
ATOM    436  CD  GLU    42      14.781  35.250  24.971  1.00 31.30           C  
ATOM    437  OE1 GLU    42      15.008  34.664  26.080  1.00 30.85           O  
ATOM    438  OE2 GLU    42      14.659  36.515  24.804  1.00 30.70           O  
ATOM    439  C   GLU    42      16.957  31.966  21.908  1.00 28.87           C  
ATOM    440  O   GLU    42      17.677  32.661  21.201  1.00 28.72           O  
ATOM    442  N   ASN    43      17.266  30.718  22.268  1.00 29.31           N  
ATOM    443  CA  ASN    43      18.369  29.949  21.660  1.00 29.26           C  
ATOM    445  CB  ASN    43      19.164  29.173  22.728  1.00 29.03           C  
ATOM    448  CG  ASN    43      19.818  30.083  23.766  1.00 29.03           C  
ATOM    449  OD1 ASN    43      20.204  31.217  23.469  1.00 28.55           O  
ATOM    450  ND2 ASN    43      19.954  29.576  24.993  1.00 28.89           N  
ATOM    453  C   ASN    43      17.872  28.958  20.602  1.00 29.20           C  
ATOM    454  O   ASN    43      18.569  27.989  20.314  1.00 29.62           O  
ATOM    456  N   THR    44      16.686  29.195  20.033  1.00 28.87           N  
ATOM    457  CA  THR    44      16.102  28.289  19.041  1.00 28.84           C  
ATOM    459  CB  THR    44      16.897  28.318  17.748  1.00 28.74           C  
ATOM    461  OG1 THR    44      17.471  29.619  17.586  1.00 29.50           O  
ATOM    463  CG2 THR    44      15.986  27.971  16.552  1.00 28.77           C  
ATOM    467  C   THR    44      16.009  26.828  19.506  1.00 28.90           C  
ATOM    468  O   THR    44      16.232  25.893  18.716  1.00 28.57           O  
ATOM    470  N   GLU    45      15.692  26.641  20.789  1.00 28.78           N  
ATOM    471  CA  GLU    45      15.473  25.302  21.339  1.00 28.92           C  
ATOM    473  CB  GLU    45      16.415  25.012  22.521  1.00 28.92           C  
ATOM    476  CG  GLU    45      17.931  25.000  22.196  1.00 29.45           C  
ATOM    479  CD  GLU    45      18.448  23.676  21.635  1.00 29.36           C  
ATOM    480  OE1 GLU    45      19.688  23.562  21.442  1.00 27.01           O  
ATOM    481  OE2 GLU    45      17.612  22.771  21.370  1.00 30.17           O  
ATOM    482  C   GLU    45      14.006  25.190  21.777  1.00 28.65           C  
ATOM    483  O   GLU    45      13.339  26.213  22.050  1.00 29.00           O  
ATOM    485  N   VAL    46      13.501  23.955  21.814  1.00 27.84           N  
ATOM    486  CA  VAL    46      12.162  23.715  22.317  1.00 27.20           C  
ATOM    488  CB  VAL    46      11.844  22.202  22.430  1.00 27.04           C  
ATOM    490  CG1 VAL    46      10.470  22.021  22.949  1.00 26.48           C  
ATOM    494  CG2 VAL    46      11.994  21.495  21.085  1.00 25.84           C  
ATOM    498  C   VAL    46      12.218  24.332  23.700  1.00 26.94           C  
ATOM    499  O   VAL    46      13.138  24.032  24.430  1.00 27.21           O  
ATOM    501  N   PRO    47      11.286  25.236  24.048  1.00 26.78           N  
ATOM    502  CA  PRO    47      11.296  25.903  25.373  1.00 26.70           C  
ATOM    504  CB  PRO    47      10.367  27.113  25.179  1.00 26.66           C  
ATOM    507  CG  PRO    47       9.422  26.670  24.121  1.00 27.05           C  
ATOM    510  CD  PRO    47      10.184  25.723  23.207  1.00 26.93           C  
ATOM    513  C   PRO    47      10.822  25.037  26.522  1.00 26.24           C  
ATOM    514  O   PRO    47       9.673  25.088  26.918  1.00 26.00           O  
ATOM    515  N   VAL    48      11.735  24.233  27.027  1.00 26.62           N  
ATOM    516  CA  VAL    48      11.513  23.417  28.200  1.00 27.16           C  
ATOM    518  CB  VAL    48      11.457  21.880  27.852  1.00 27.41           C  
ATOM    520  CG1 VAL    48      11.253  21.035  29.132  1.00 26.53           C  
ATOM    524  CG2 VAL    48      10.393  21.571  26.783  1.00 25.65           C  
ATOM    528  C   VAL    48      12.716  23.717  29.106  1.00 27.85           C  
ATOM    529  O   VAL    48      13.887  23.614  28.672  1.00 28.19           O  
ATOM    531  N   GLY    49      12.435  24.143  30.334  1.00 27.89           N  
ATOM    532  CA  GLY    49      13.460  24.283  31.361  1.00 27.79           C  
ATOM    535  C   GLY    49      13.077  23.403  32.544  1.00 27.95           C  
ATOM    536  O   GLY    49      11.895  23.182  32.778  1.00 28.14           O  
ATOM    538  N   CYS    50      14.052  22.876  33.284  1.00 27.93           N  
ATOM    539  CA  CYS    50      13.715  22.173  34.504  1.00 28.84           C  
ATOM    541  CB  CYS    50      13.297  20.749  34.174  1.00 28.84           C  
ATOM    544  SG  CYS    50      14.643  19.606  34.018  1.00 33.39           S  
ATOM    546  C   CYS    50      14.794  22.187  35.602  1.00 28.72           C  
ATOM    547  O   CYS    50      15.972  22.404  35.318  1.00 28.99           O  
ATOM    549  N   LEU    51      14.348  21.985  36.849  1.00 28.66           N  
ATOM    550  CA  LEU    51      15.194  21.936  38.050  1.00 28.44           C  
ATOM    552  CB  LEU    51      14.880  23.128  38.954  1.00 28.29           C  
ATOM    555  CG  LEU    51      15.232  24.521  38.431  1.00 28.29           C  
ATOM    557  CD1 LEU    51      14.136  25.489  38.675  1.00 29.32           C  
ATOM    561  CD2 LEU    51      16.480  25.050  39.095  1.00 30.45           C  
ATOM    565  C   LEU    51      14.956  20.617  38.827  1.00 28.35           C  
ATOM    566  O   LEU    51      13.876  20.048  38.798  1.00 28.95           O  
ATOM    568  N   MET    52      15.958  20.126  39.526  1.00 27.97           N  
ATOM    569  CA  MET    52      15.745  19.011  40.400  1.00 28.22           C  
ATOM    571  CB  MET    52      16.413  17.765  39.825  1.00 28.57           C  
ATOM    574  CG  MET    52      15.607  17.113  38.742  1.00 29.75           C  
ATOM    577  SD  MET    52      16.528  15.808  37.882  1.00 30.98           S  
ATOM    578  CE  MET    52      16.168  14.414  38.917  1.00 33.55           C  
ATOM    582  C   MET    52      16.255  19.354  41.807  1.00 28.12           C  
ATOM    583  O   MET    52      17.427  19.709  42.002  1.00 27.75           O  
ATOM    585  N   VAL    53      15.354  19.242  42.781  1.00 27.75           N  
ATOM    586  CA  VAL    53      15.642  19.628  44.149  1.00 27.86           C  
ATOM    588  CB  VAL    53      14.603  20.664  44.634  1.00 27.43           C  
ATOM    590  CG1 VAL    53      14.756  20.937  46.109  1.00 27.32           C  
ATOM    594  CG2 VAL    53      14.729  21.953  43.833  1.00 27.25           C  
ATOM    598  C   VAL    53      15.710  18.395  45.089  1.00 28.27           C  
ATOM    599  O   VAL    53      14.819  17.559  45.116  1.00 28.02           O  
ATOM    601  N   TYR    54      16.790  18.308  45.863  1.00 28.71           N  
ATOM    602  CA  TYR    54      16.978  17.239  46.855  1.00 28.55           C  
ATOM    604  CB  TYR    54      18.085  16.279  46.430  1.00 28.75           C  
ATOM    607  CG  TYR    54      18.551  15.359  47.499  1.00 27.40           C  
ATOM    608  CD1 TYR    54      17.820  14.230  47.830  1.00 28.08           C  
ATOM    610  CE1 TYR    54      18.244  13.355  48.820  1.00 28.43           C  
ATOM    612  CZ  TYR    54      19.430  13.620  49.480  1.00 29.94           C  
ATOM    613  OH  TYR    54      19.905  12.759  50.454  1.00 32.14           O  
ATOM    615  CE2 TYR    54      20.192  14.739  49.135  1.00 29.42           C  
ATOM    617  CD2 TYR    54      19.745  15.591  48.148  1.00 27.87           C  
ATOM    619  C   TYR    54      17.366  17.869  48.152  1.00 28.27           C  
ATOM    620  O   TYR    54      18.279  18.662  48.173  1.00 28.82           O  
ATOM    622  N   ASN    55      16.677  17.488  49.221  1.00 28.12           N  
ATOM    623  CA  ASN    55      16.918  18.006  50.563  1.00 28.03           C  
ATOM    625  CB  ASN    55      18.059  17.234  51.242  1.00 28.30           C  
ATOM    628  CG  ASN    55      18.050  17.374  52.753  1.00 28.25           C  
ATOM    629  OD1 ASN    55      17.015  17.664  53.345  1.00 27.11           O  
ATOM    630  ND2 ASN    55      19.190  17.134  53.381  1.00 25.68           N  
ATOM    633  C   ASN    55      17.189  19.501  50.573  1.00 27.90           C  
ATOM    634  O   ASN    55      18.159  19.980  51.170  1.00 27.64           O  
ATOM    636  N   ASN    56      16.320  20.224  49.887  1.00 27.79           N  
ATOM    637  CA  ASN    56      16.363  21.691  49.865  1.00 28.13           C  
ATOM    639  CB  ASN    56      16.324  22.254  51.279  1.00 28.01           C  
ATOM    642  CG  ASN    56      15.882  23.683  51.311  1.00 27.94           C  
ATOM    643  OD1 ASN    56      15.237  24.172  50.381  1.00 31.08           O  
ATOM    644  ND2 ASN    56      16.215  24.367  52.378  1.00 27.46           N  
ATOM    647  C   ASN    56      17.533  22.307  49.134  1.00 27.87           C  
ATOM    648  O   ASN    56      17.908  23.425  49.409  1.00 28.32           O  
ATOM    650  N   GLU    57      18.082  21.574  48.183  1.00 27.86           N  
ATOM    651  CA  GLU    57      19.217  22.024  47.409  1.00 27.68           C  
ATOM    653  CB  GLU    57      20.472  21.281  47.847  1.00 27.08           C  
ATOM    656  CG  GLU    57      21.672  21.541  46.962  1.00 28.55           C  
ATOM    659  CD  GLU    57      23.044  21.418  47.718  1.00 30.79           C  
ATOM    660  OE1 GLU    57      24.101  21.861  47.139  1.00 30.38           O  
ATOM    661  OE2 GLU    57      23.061  20.888  48.874  1.00 30.25           O  
ATOM    662  C   GLU    57      18.879  21.798  45.937  1.00 27.63           C  
ATOM    663  O   GLU    57      18.169  20.830  45.585  1.00 27.10           O  
ATOM    665  N   VAL    58      19.321  22.734  45.093  1.00 27.91           N  
ATOM    666  CA  VAL    58      19.139  22.617  43.654  1.00 27.84           C  
ATOM    668  CB  VAL    58      19.194  23.956  42.914  1.00 27.95           C  
ATOM    670  CG1 VAL    58      19.081  23.684  41.414  1.00 27.53           C  
ATOM    674  CG2 VAL    58      18.097  24.893  43.401  1.00 27.26           C  
ATOM    678  C   VAL    58      20.250  21.735  43.142  1.00 27.85           C  
ATOM    679  O   VAL    58      21.372  22.153  42.975  1.00 27.19           O  
ATOM    681  N   VAL    59      19.894  20.494  42.876  1.00 28.57           N  
ATOM    682  CA  VAL    59      20.856  19.448  42.563  1.00 28.61           C  
ATOM    684  CB  VAL    59      20.415  18.170  43.356  1.00 28.52           C  
ATOM    686  CG1 VAL    59      19.333  17.410  42.623  1.00 27.61           C  
ATOM    690  CG2 VAL    59      21.584  17.307  43.628  1.00 30.18           C  
ATOM    694  C   VAL    59      21.022  19.190  41.019  1.00 28.74           C  
ATOM    695  O   VAL    59      21.896  18.437  40.605  1.00 28.89           O  
ATOM    697  N   GLY    60      20.192  19.812  40.180  1.00 28.38           N  
ATOM    698  CA  GLY    60      20.330  19.712  38.737  1.00 28.23           C  
ATOM    701  C   GLY    60      19.404  20.682  38.007  1.00 28.41           C  
ATOM    702  O   GLY    60      18.276  20.866  38.404  1.00 28.63           O  
ATOM    704  N   LYS    61      19.916  21.324  36.960  1.00 28.65           N  
ATOM    705  CA  LYS    61      19.168  22.227  36.093  1.00 28.54           C  
ATOM    707  CB  LYS    61      19.780  23.640  36.140  1.00 28.95           C  
ATOM    710  CG  LYS    61      19.463  24.488  37.367  1.00 28.34           C  
ATOM    713  CD  LYS    61      20.179  25.840  37.225  1.00 29.50           C  
ATOM    716  CE  LYS    61      20.207  26.654  38.541  1.00 30.91           C  
ATOM    719  NZ  LYS    61      18.964  27.499  38.849  1.00 30.87           N  
ATOM    723  C   LYS    61      19.282  21.710  34.650  1.00 28.73           C  
ATOM    724  O   LYS    61      20.198  20.928  34.303  1.00 28.29           O  
ATOM    726  N   GLY    62      18.379  22.158  33.784  1.00 28.67           N  
ATOM    727  CA  GLY    62      18.523  21.784  32.389  1.00 28.85           C  
ATOM    730  C   GLY    62      17.522  22.399  31.467  1.00 28.68           C  
ATOM    731  O   GLY    62      16.377  22.533  31.822  1.00 29.05           O  
ATOM    733  N   ARG    63      17.983  22.761  30.279  1.00 28.89           N  
ATOM    734  CA  ARG    63      17.144  23.177  29.179  1.00 28.89           C  
ATOM    736  CB  ARG    63      17.613  24.542  28.668  1.00 29.02           C  
ATOM    739  CG  ARG    63      17.129  25.716  29.490  1.00 29.86           C  
ATOM    742  CD  ARG    63      18.067  26.929  29.395  1.00 30.14           C  
ATOM    745  NE  ARG    63      19.316  26.658  30.105  1.00 31.33           N  
ATOM    747  CZ  ARG    63      20.264  27.559  30.367  1.00 31.77           C  
ATOM    748  NH1 ARG    63      20.100  28.830  29.992  1.00 31.57           N  
ATOM    751  NH2 ARG    63      21.380  27.181  31.007  1.00 30.99           N  
ATOM    754  C   ARG    63      17.358  22.195  28.056  1.00 29.11           C  
ATOM    755  O   ARG    63      18.388  21.496  28.019  1.00 29.15           O  
ATOM    757  N   ASN    64      16.420  22.169  27.108  1.00 29.06           N  
ATOM    758  CA  ASN    64      16.671  21.481  25.849  1.00 28.97           C  
ATOM    760  CB  ASN    64      15.497  21.629  24.909  1.00 29.21           C  
ATOM    763  CG  ASN    64      14.555  20.442  24.966  1.00 30.76           C  
ATOM    764  OD1 ASN    64      14.095  20.021  26.061  1.00 31.58           O  
ATOM    765  ND2 ASN    64      14.238  19.899  23.783  1.00 30.37           N  
ATOM    768  C   ASN    64      17.914  22.003  25.151  1.00 28.78           C  
ATOM    769  O   ASN    64      18.100  23.209  25.044  1.00 28.39           O  
ATOM    771  N   GLU    65      18.741  21.063  24.683  1.00 28.83           N  
ATOM    772  CA  GLU    65      19.991  21.336  23.956  1.00 28.70           C  
ATOM    774  CB  GLU    65      21.208  20.948  24.811  1.00 28.43           C  
ATOM    777  CG  GLU    65      21.363  21.803  26.060  1.00 29.26           C  
ATOM    780  CD  GLU    65      22.567  21.420  26.935  1.00 31.11           C  
ATOM    781  OE1 GLU    65      23.208  20.350  26.722  1.00 32.83           O  
ATOM    782  OE2 GLU    65      22.862  22.193  27.874  1.00 32.15           O  
ATOM    783  C   GLU    65      20.053  20.599  22.593  1.00 28.61           C  
ATOM    784  O   GLU    65      21.143  20.477  22.010  1.00 28.58           O  
ATOM    786  N   VAL    66      18.896  20.169  22.062  1.00 27.88           N  
ATOM    787  CA  VAL    66      18.886  19.316  20.880  1.00 27.67           C  
ATOM    789  CB  VAL    66      17.459  18.841  20.468  1.00 27.53           C  
ATOM    791  CG1 VAL    66      17.529  18.039  19.197  1.00 26.83           C  
ATOM    795  CG2 VAL    66      16.898  17.936  21.521  1.00 26.62           C  
ATOM    799  C   VAL    66      19.638  19.911  19.702  1.00 27.74           C  
ATOM    800  O   VAL    66      20.368  19.174  19.054  1.00 27.05           O  
ATOM    802  N   ASN    67      19.485  21.227  19.463  1.00 28.26           N  
ATOM    803  CA  ASN    67      20.095  21.919  18.295  1.00 28.74           C  
ATOM    805  CB  ASN    67      19.369  23.234  17.954  1.00 29.15           C  
ATOM    808  CG  ASN    67      17.862  23.046  17.756  1.00 30.45           C  
ATOM    809  OD1 ASN    67      17.316  21.924  17.886  1.00 31.70           O  
ATOM    810  ND2 ASN    67      17.175  24.152  17.467  1.00 29.61           N  
ATOM    813  C   ASN    67      21.546  22.272  18.503  1.00 28.57           C  
ATOM    814  O   ASN    67      22.382  22.068  17.625  1.00 28.06           O  
ATOM    816  N   GLN    68      21.820  22.854  19.661  1.00 28.68           N  
ATOM    817  CA  GLN    68      23.187  23.164  20.074  1.00 29.07           C  
ATOM    819  CB  GLN    68      23.182  23.668  21.536  1.00 29.90           C  
ATOM    822  CG  GLN    68      22.524  25.095  21.719  1.00 32.43           C  
ATOM    825  CD  GLN    68      22.188  25.490  23.188  1.00 32.48           C  
ATOM    826  OE1 GLN    68      21.718  24.669  23.999  1.00 31.76           O  
ATOM    827  NE2 GLN    68      22.424  26.777  23.507  1.00 31.80           N  
ATOM    830  C   GLN    68      24.041  21.912  20.001  1.00 28.56           C  
ATOM    831  O   GLN    68      25.150  21.918  19.494  1.00 27.79           O  
ATOM    833  N   THR    69      23.495  20.836  20.554  1.00 28.62           N  
ATOM    834  CA  THR    69      24.199  19.575  20.692  1.00 28.33           C  
ATOM    836  CB  THR    69      23.715  18.855  21.942  1.00 27.93           C  
ATOM    838  OG1 THR    69      24.674  17.873  22.314  1.00 30.06           O  
ATOM    840  CG2 THR    69      22.403  18.168  21.682  1.00 28.03           C  
ATOM    844  C   THR    69      24.028  18.652  19.476  1.00 28.16           C  
ATOM    845  O   THR    69      24.864  17.762  19.267  1.00 28.11           O  
ATOM    847  N   LYS    70      22.972  18.895  18.683  1.00 27.74           N  
ATOM    848  CA  LYS    70      22.589  18.065  17.531  1.00 27.50           C  
ATOM    850  CB  LYS    70      23.563  18.266  16.384  1.00 27.34           C  
ATOM    853  CG  LYS    70      23.246  19.525  15.632  1.00 28.15           C  
ATOM    856  CD  LYS    70      24.390  19.949  14.775  1.00 29.05           C  
ATOM    859  CE  LYS    70      24.183  21.367  14.275  1.00 29.94           C  
ATOM    862  NZ  LYS    70      25.274  21.771  13.281  1.00 31.00           N  
ATOM    866  C   LYS    70      22.383  16.586  17.886  1.00 27.49           C  
ATOM    867  O   LYS    70      22.638  15.688  17.088  1.00 27.02           O  
ATOM    869  N   ASN    71      21.857  16.364  19.083  1.00 27.55           N  
ATOM    870  CA  ASN    71      21.554  15.046  19.586  1.00 27.78           C  
ATOM    872  CB  ASN    71      22.528  14.710  20.740  1.00 28.42           C  
ATOM    875  CG  ASN    71      22.027  13.539  21.665  1.00 28.76           C  
ATOM    876  OD1 ASN    71      20.966  12.957  21.460  1.00 27.98           O  
ATOM    877  ND2 ASN    71      22.818  13.221  22.698  1.00 28.49           N  
ATOM    880  C   ASN    71      20.093  15.093  20.051  1.00 27.58           C  
ATOM    881  O   ASN    71      19.764  15.768  21.038  1.00 27.17           O  
ATOM    883  N   ALA    72      19.246  14.340  19.348  1.00 27.15           N  
ATOM    884  CA  ALA    72      17.800  14.367  19.546  1.00 27.07           C  
ATOM    886  CB  ALA    72      17.127  13.525  18.488  1.00 26.68           C  
ATOM    890  C   ALA    72      17.315  13.950  20.941  1.00 27.13           C  
ATOM    891  O   ALA    72      16.182  14.226  21.301  1.00 26.86           O  
ATOM    893  N   THR    73      18.163  13.293  21.726  1.00 27.64           N  
ATOM    894  CA  THR    73      17.794  12.844  23.087  1.00 27.77           C  
ATOM    896  CB  THR    73      18.487  11.475  23.481  1.00 27.68           C  
ATOM    898  OG1 THR    73      19.896  11.661  23.586  1.00 28.68           O  
ATOM    900  CG2 THR    73      18.245  10.386  22.484  1.00 27.37           C  
ATOM    904  C   THR    73      18.077  13.870  24.222  1.00 27.70           C  
ATOM    905  O   THR    73      17.605  13.670  25.328  1.00 28.04           O  
ATOM    907  N   ARG    74      18.804  14.962  23.970  1.00 28.06           N  
ATOM    908  CA  ARG    74      19.126  15.931  25.042  1.00 28.19           C  
ATOM    910  CB  ARG    74      20.501  16.601  24.849  1.00 28.37           C  
ATOM    913  CG  ARG    74      21.630  15.661  25.334  1.00 29.65           C  
ATOM    916  CD  ARG    74      23.077  16.273  25.365  1.00 31.98           C  
ATOM    919  NE  ARG    74      23.948  15.483  24.442  1.00 33.67           N  
ATOM    921  CZ  ARG    74      25.287  15.545  24.348  1.00 32.37           C  
ATOM    922  NH1 ARG    74      26.000  16.370  25.135  1.00 33.11           N  
ATOM    925  NH2 ARG    74      25.913  14.770  23.451  1.00 30.11           N  
ATOM    928  C   ARG    74      18.008  16.914  25.334  1.00 27.96           C  
ATOM    929  O   ARG    74      18.098  18.113  25.095  1.00 27.54           O  
ATOM    931  N   HIS    75      16.947  16.332  25.881  1.00 28.13           N  
ATOM    932  CA  HIS    75      15.808  17.019  26.439  1.00 27.64           C  
ATOM    934  CB  HIS    75      14.667  16.007  26.623  1.00 27.64           C  
ATOM    937  CG  HIS    75      13.933  15.675  25.364  1.00 26.85           C  
ATOM    938  ND1 HIS    75      12.684  15.091  25.365  1.00 27.16           N  
ATOM    940  CE1 HIS    75      12.273  14.929  24.123  1.00 25.35           C  
ATOM    942  NE2 HIS    75      13.203  15.398  23.314  1.00 25.61           N  
ATOM    944  CD2 HIS    75      14.241  15.891  24.066  1.00 26.69           C  
ATOM    946  C   HIS    75      16.212  17.565  27.809  1.00 27.62           C  
ATOM    947  O   HIS    75      17.040  16.976  28.486  1.00 27.41           O  
ATOM    949  N   ALA    76      15.605  18.680  28.215  1.00 27.85           N  
ATOM    950  CA  ALA    76      15.914  19.361  29.477  1.00 27.68           C  
ATOM    952  CB  ALA    76      14.837  20.315  29.795  1.00 27.83           C  
ATOM    956  C   ALA    76      16.071  18.407  30.627  1.00 27.54           C  
ATOM    957  O   ALA    76      16.949  18.557  31.454  1.00 27.23           O  
ATOM    959  N   GLU    77      15.202  17.415  30.660  1.00 27.94           N  
ATOM    960  CA  GLU    77      15.174  16.423  31.759  1.00 28.19           C  
ATOM    962  CB  GLU    77      13.931  15.503  31.638  1.00 28.04           C  
ATOM    965  CG  GLU    77      12.535  16.240  31.554  1.00 28.70           C  
ATOM    968  CD  GLU    77      12.024  16.560  30.121  1.00 29.00           C  
ATOM    969  OE1 GLU    77      12.744  17.225  29.338  1.00 26.96           O  
ATOM    970  OE2 GLU    77      10.890  16.137  29.788  1.00 30.20           O  
ATOM    971  C   GLU    77      16.453  15.576  31.775  1.00 28.12           C  
ATOM    972  O   GLU    77      16.977  15.267  32.831  1.00 27.91           O  
ATOM    974  N   MET    78      16.945  15.218  30.590  1.00 28.34           N  
ATOM    975  CA  MET    78      18.162  14.405  30.454  1.00 28.57           C  
ATOM    977  CB  MET    78      18.256  13.796  29.033  1.00 28.60           C  
ATOM    980  CG  MET    78      17.083  12.903  28.658  1.00 29.43           C  
ATOM    983  SD  MET    78      17.088  11.230  29.438  1.00 32.79           S  
ATOM    984  CE  MET    78      18.680  10.560  28.910  1.00 33.89           C  
ATOM    988  C   MET    78      19.438  15.196  30.807  1.00 27.97           C  
ATOM    989  O   MET    78      20.374  14.636  31.382  1.00 27.32           O  
ATOM    991  N   VAL    79      19.449  16.485  30.467  1.00 27.87           N  
ATOM    992  CA  VAL    79      20.504  17.412  30.894  1.00 27.89           C  
ATOM    994  CB  VAL    79      20.252  18.842  30.335  1.00 27.64           C  
ATOM    996  CG1 VAL    79      21.200  19.821  30.957  1.00 26.57           C  
ATOM   1000  CG2 VAL    79      20.390  18.846  28.827  1.00 27.02           C  
ATOM   1004  C   VAL    79      20.582  17.472  32.428  1.00 28.20           C  
ATOM   1005  O   VAL    79      21.663  17.343  33.013  1.00 28.42           O  
ATOM   1007  N   ALA    80      19.422  17.663  33.060  1.00 28.46           N  
ATOM   1008  CA  ALA    80      19.292  17.726  34.514  1.00 28.47           C  
ATOM   1010  CB  ALA    80      17.846  18.000  34.891  1.00 28.80           C  
ATOM   1014  C   ALA    80      19.776  16.452  35.211  1.00 28.83           C  
ATOM   1015  O   ALA    80      20.513  16.536  36.211  1.00 28.83           O  
ATOM   1017  N   ILE    81      19.346  15.286  34.702  1.00 28.53           N  
ATOM   1018  CA  ILE    81      19.759  14.004  35.257  1.00 28.44           C  
ATOM   1020  CB  ILE    81      19.134  12.836  34.510  1.00 28.66           C  
ATOM   1022  CG1 ILE    81      17.624  12.783  34.805  1.00 28.89           C  
ATOM   1025  CD1 ILE    81      16.882  11.805  33.992  1.00 26.60           C  
ATOM   1029  CG2 ILE    81      19.789  11.514  34.943  1.00 28.72           C  
ATOM   1033  C   ILE    81      21.275  13.851  35.248  1.00 28.72           C  
ATOM   1034  O   ILE    81      21.854  13.413  36.239  1.00 29.25           O  
ATOM   1036  N   ASP    82      21.922  14.237  34.152  1.00 28.61           N  
ATOM   1037  CA  ASP    82      23.382  14.204  34.080  1.00 28.47           C  
ATOM   1039  CB  ASP    82      23.900  14.655  32.700  1.00 28.86           C  
ATOM   1042  CG  ASP    82      24.020  13.506  31.685  1.00 30.66           C  
ATOM   1043  OD1 ASP    82      23.613  12.367  32.024  1.00 33.60           O  
ATOM   1044  OD2 ASP    82      24.542  13.743  30.544  1.00 32.55           O  
ATOM   1045  C   ASP    82      23.987  15.088  35.148  1.00 28.01           C  
ATOM   1046  O   ASP    82      24.999  14.728  35.734  1.00 27.82           O  
ATOM   1048  N   GLN    83      23.379  16.253  35.385  1.00 27.76           N  
ATOM   1049  CA  GLN    83      23.868  17.178  36.416  1.00 27.64           C  
ATOM   1051  CB  GLN    83      23.170  18.538  36.279  1.00 27.69           C  
ATOM   1054  CG  GLN    83      23.871  19.468  35.291  1.00 28.50           C  
ATOM   1057  CD  GLN    83      23.481  20.925  35.456  1.00 27.64           C  
ATOM   1058  OE1 GLN    83      22.782  21.301  36.390  1.00 27.94           O  
ATOM   1059  NE2 GLN    83      23.942  21.750  34.551  1.00 27.26           N  
ATOM   1062  C   GLN    83      23.721  16.646  37.849  1.00 27.11           C  
ATOM   1063  O   GLN    83      24.612  16.790  38.666  1.00 26.25           O  
ATOM   1065  N   VAL    84      22.573  16.039  38.131  1.00 27.29           N  
ATOM   1066  CA  VAL    84      22.373  15.354  39.390  1.00 27.38           C  
ATOM   1068  CB  VAL    84      20.931  14.822  39.562  1.00 27.63           C  
ATOM   1070  CG1 VAL    84      20.775  14.175  40.919  1.00 25.95           C  
ATOM   1074  CG2 VAL    84      19.923  15.945  39.394  1.00 26.82           C  
ATOM   1078  C   VAL    84      23.395  14.241  39.566  1.00 27.17           C  
ATOM   1079  O   VAL    84      24.087  14.205  40.570  1.00 27.42           O  
ATOM   1081  N   LEU    85      23.541  13.356  38.595  1.00 27.06           N  
ATOM   1082  CA  LEU    85      24.643  12.379  38.680  1.00 27.18           C  
ATOM   1084  CB  LEU    85      24.735  11.528  37.415  1.00 26.93           C  
ATOM   1087  CG  LEU    85      23.618  10.515  37.247  1.00 26.49           C  
ATOM   1089  CD1 LEU    85      23.286  10.344  35.774  1.00 27.04           C  
ATOM   1093  CD2 LEU    85      24.014   9.242  37.875  1.00 26.00           C  
ATOM   1097  C   LEU    85      25.997  13.029  38.955  1.00 27.04           C  
ATOM   1098  O   LEU    85      26.807  12.451  39.661  1.00 27.51           O  
ATOM   1100  N   ASP    86      26.240  14.216  38.404  1.00 27.40           N  
ATOM   1101  CA  ASP    86      27.493  14.935  38.638  1.00 27.79           C  
ATOM   1103  CB  ASP    86      27.674  16.086  37.657  1.00 27.90           C  
ATOM   1106  CG  ASP    86      29.145  16.270  37.271  1.00 30.86           C  
ATOM   1107  OD1 ASP    86      29.648  15.494  36.390  1.00 32.41           O  
ATOM   1108  OD2 ASP    86      29.826  17.137  37.906  1.00 33.31           O  
ATOM   1109  C   ASP    86      27.612  15.473  40.060  1.00 27.69           C  
ATOM   1110  O   ASP    86      28.704  15.515  40.648  1.00 27.89           O  
ATOM   1112  N   TRP    87      26.479  15.887  40.606  1.00 27.68           N  
ATOM   1113  CA  TRP    87      26.393  16.362  41.971  1.00 27.52           C  
ATOM   1115  CB  TRP    87      24.996  16.944  42.217  1.00 28.11           C  
ATOM   1118  CG  TRP    87      24.854  17.634  43.516  1.00 27.84           C  
ATOM   1119  CD1 TRP    87      25.097  18.936  43.765  1.00 26.94           C  
ATOM   1121  NE1 TRP    87      24.843  19.218  45.082  1.00 27.80           N  
ATOM   1123  CE2 TRP    87      24.445  18.076  45.722  1.00 27.98           C  
ATOM   1124  CD2 TRP    87      24.432  17.048  44.756  1.00 28.61           C  
ATOM   1125  CE3 TRP    87      24.048  15.750  45.143  1.00 27.55           C  
ATOM   1127  CZ3 TRP    87      23.721  15.525  46.469  1.00 27.38           C  
ATOM   1129  CH2 TRP    87      23.747  16.579  47.415  1.00 27.96           C  
ATOM   1131  CZ2 TRP    87      24.101  17.857  47.060  1.00 27.24           C  
ATOM   1133  C   TRP    87      26.661  15.254  42.957  1.00 27.22           C  
ATOM   1134  O   TRP    87      27.279  15.469  43.985  1.00 26.82           O  
ATOM   1136  N   CYS    88      26.147  14.072  42.648  1.00 27.62           N  
ATOM   1137  CA  CYS    88      26.427  12.872  43.433  1.00 27.93           C  
ATOM   1139  CB  CYS    88      25.738  11.657  42.842  1.00 27.87           C  
ATOM   1142  SG  CYS    88      24.004  11.558  43.304  1.00 29.69           S  
ATOM   1144  C   CYS    88      27.893  12.579  43.502  1.00 27.85           C  
ATOM   1145  O   CYS    88      28.411  12.357  44.584  1.00 28.58           O  
ATOM   1147  N   ARG    89      28.569  12.568  42.360  1.00 27.85           N  
ATOM   1148  CA  ARG    89      30.000  12.313  42.366  1.00 28.33           C  
ATOM   1150  CB  ARG    89      30.613  12.676  41.043  1.00 28.62           C  
ATOM   1153  CG  ARG    89      30.413  11.652  39.984  1.00 29.96           C  
ATOM   1156  CD  ARG    89      30.720  12.311  38.629  1.00 31.97           C  
ATOM   1159  NE  ARG    89      30.164  11.544  37.504  1.00 33.93           N  
ATOM   1161  CZ  ARG    89      30.404  11.831  36.215  1.00 36.20           C  
ATOM   1162  NH1 ARG    89      31.159  12.902  35.886  1.00 37.64           N  
ATOM   1165  NH2 ARG    89      29.920  11.053  35.234  1.00 36.24           N  
ATOM   1168  C   ARG    89      30.730  13.111  43.408  1.00 28.11           C  
ATOM   1169  O   ARG    89      31.577  12.583  44.101  1.00 28.00           O  
ATOM   1171  N   GLN    90      30.383  14.386  43.506  1.00 28.42           N  
ATOM   1172  CA  GLN    90      31.132  15.339  44.301  1.00 28.75           C  
ATOM   1174  CB  GLN    90      30.990  16.703  43.661  1.00 29.03           C  
ATOM   1177  CG  GLN    90      31.457  16.706  42.217  1.00 31.17           C  
ATOM   1180  CD  GLN    90      31.094  17.981  41.521  1.00 33.04           C  
ATOM   1181  OE1 GLN    90      30.440  18.845  42.108  1.00 35.04           O  
ATOM   1182  NE2 GLN    90      31.498  18.113  40.261  1.00 34.45           N  
ATOM   1185  C   GLN    90      30.670  15.469  45.728  1.00 28.39           C  
ATOM   1186  O   GLN    90      31.383  16.039  46.538  1.00 28.51           O  
ATOM   1188  N   SER    91      29.453  15.014  46.010  1.00 28.22           N  
ATOM   1189  CA  SER    91      28.885  15.090  47.346  1.00 28.33           C  
ATOM   1191  CB  SER    91      27.379  15.315  47.267  1.00 28.48           C  
ATOM   1194  OG  SER    91      26.708  14.066  47.137  1.00 28.44           O  
ATOM   1196  C   SER    91      29.135  13.806  48.131  1.00 28.41           C  
ATOM   1197  O   SER    91      28.941  13.790  49.351  1.00 28.52           O  
ATOM   1199  N   GLY    92      29.541  12.740  47.419  1.00 28.34           N  
ATOM   1200  CA  GLY    92      29.820  11.437  48.010  1.00 28.07           C  
ATOM   1203  C   GLY    92      28.567  10.609  48.180  1.00 27.97           C  
ATOM   1204  O   GLY    92      28.632   9.480  48.609  1.00 28.33           O  
ATOM   1206  N   LYS    93      27.418  11.175  47.850  1.00 28.04           N  
ATOM   1207  CA  LYS    93      26.144  10.499  48.043  1.00 28.52           C  
ATOM   1209  CB  LYS    93      25.010  11.516  48.151  1.00 28.44           C  
ATOM   1212  CG  LYS    93      25.124  12.507  49.287  1.00 28.85           C  
ATOM   1215  CD  LYS    93      24.408  12.008  50.555  1.00 30.68           C  
ATOM   1218  CE  LYS    93      23.929  13.147  51.497  1.00 31.10           C  
ATOM   1221  NZ  LYS    93      22.573  12.817  52.143  1.00 31.15           N  
ATOM   1225  C   LYS    93      25.886   9.579  46.841  1.00 28.54           C  
ATOM   1226  O   LYS    93      26.366   9.859  45.736  1.00 28.29           O  
ATOM   1228  N   SER    94      25.122   8.501  47.058  1.00 28.28           N  
ATOM   1229  CA  SER    94      24.802   7.568  45.984  1.00 27.99           C  
ATOM   1231  CB  SER    94      24.546   6.167  46.522  1.00 27.89           C  
ATOM   1234  OG  SER    94      23.271   6.106  47.132  1.00 27.86           O  
ATOM   1236  C   SER    94      23.571   8.064  45.224  1.00 28.07           C  
ATOM   1237  O   SER    94      22.649   8.643  45.843  1.00 27.86           O  
ATOM   1239  N   PRO    95      23.548   7.840  43.893  1.00 27.49           N  
ATOM   1240  CA  PRO    95      22.436   8.176  42.998  1.00 27.79           C  
ATOM   1242  CB  PRO    95      22.818   7.481  41.703  1.00 27.72           C  
ATOM   1245  CG  PRO    95      24.264   7.455  41.751  1.00 28.05           C  
ATOM   1248  CD  PRO    95      24.646   7.219  43.154  1.00 27.05           C  
ATOM   1251  C   PRO    95      21.045   7.709  43.436  1.00 27.91           C  
ATOM   1252  O   PRO    95      20.106   8.499  43.371  1.00 28.45           O  
ATOM   1253  N   SER    96      20.917   6.457  43.869  1.00 27.75           N  
ATOM   1254  CA  SER    96      19.643   5.929  44.340  1.00 28.16           C  
ATOM   1256  CB  SER    96      19.727   4.416  44.567  1.00 28.01           C  
ATOM   1259  OG  SER    96      20.401   4.120  45.777  1.00 28.00           O  
ATOM   1261  C   SER    96      19.140   6.659  45.599  1.00 28.30           C  
ATOM   1262  O   SER    96      17.977   6.987  45.701  1.00 28.80           O  
ATOM   1264  N   GLU    97      20.029   6.959  46.524  1.00 28.77           N  
ATOM   1265  CA  GLU    97      19.701   7.734  47.728  1.00 29.19           C  
ATOM   1267  CB  GLU    97      20.960   7.760  48.608  1.00 29.43           C  
ATOM   1270  CG  GLU    97      20.840   8.453  49.966  1.00 31.88           C  
ATOM   1273  CD  GLU    97      22.211   8.495  50.747  1.00 34.19           C  
ATOM   1274  OE1 GLU    97      23.234   7.944  50.211  1.00 34.81           O  
ATOM   1275  OE2 GLU    97      22.250   9.095  51.874  1.00 32.68           O  
ATOM   1276  C   GLU    97      19.225   9.185  47.447  1.00 29.09           C  
ATOM   1277  O   GLU    97      18.528   9.788  48.293  1.00 29.59           O  
ATOM   1279  N   VAL    98      19.614   9.742  46.295  1.00 28.27           N  
ATOM   1280  CA  VAL    98      19.289  11.121  45.961  1.00 28.28           C  
ATOM   1282  CB  VAL    98      20.460  11.853  45.218  1.00 28.27           C  
ATOM   1284  CG1 VAL    98      20.109  13.282  44.899  1.00 25.94           C  
ATOM   1288  CG2 VAL    98      21.732  11.836  46.046  1.00 28.61           C  
ATOM   1292  C   VAL    98      18.069  11.175  45.066  1.00 28.91           C  
ATOM   1293  O   VAL    98      17.096  11.881  45.374  1.00 28.91           O  
ATOM   1295  N   PHE    99      18.133  10.470  43.930  1.00 29.30           N  
ATOM   1296  CA  PHE    99      17.022  10.466  42.968  1.00 29.02           C  
ATOM   1298  CB  PHE    99      17.314   9.595  41.740  1.00 29.08           C  
ATOM   1301  CG  PHE    99      18.191  10.271  40.744  1.00 30.28           C  
ATOM   1302  CD1 PHE    99      19.564  10.018  40.707  1.00 30.48           C  
ATOM   1304  CE1 PHE    99      20.391  10.672  39.812  1.00 29.96           C  
ATOM   1306  CZ  PHE    99      19.873  11.616  38.953  1.00 30.17           C  
ATOM   1308  CE2 PHE    99      18.508  11.904  38.982  1.00 31.27           C  
ATOM   1310  CD2 PHE    99      17.666  11.222  39.877  1.00 31.63           C  
ATOM   1312  C   PHE    99      15.737  10.011  43.618  1.00 28.89           C  
ATOM   1313  O   PHE    99      14.682  10.551  43.305  1.00 29.69           O  
ATOM   1315  N   GLU   100      15.802   9.025  44.514  1.00 28.16           N  
ATOM   1316  CA  GLU   100      14.578   8.558  45.168  1.00 27.97           C  
ATOM   1318  CB  GLU   100      14.825   7.247  45.899  1.00 27.44           C  
ATOM   1321  CG  GLU   100      15.086   6.145  44.939  1.00 28.81           C  
ATOM   1324  CD  GLU   100      15.433   4.827  45.602  1.00 31.25           C  
ATOM   1325  OE1 GLU   100      14.999   4.604  46.757  1.00 33.41           O  
ATOM   1326  OE2 GLU   100      16.147   4.005  44.961  1.00 32.63           O  
ATOM   1327  C   GLU   100      13.901   9.589  46.090  1.00 27.67           C  
ATOM   1328  O   GLU   100      12.803   9.337  46.580  1.00 27.67           O  
ATOM   1330  N   HIS   101      14.549  10.734  46.319  1.00 27.43           N  
ATOM   1331  CA  HIS   101      13.984  11.809  47.136  1.00 27.25           C  
ATOM   1333  CB  HIS   101      14.693  11.846  48.490  1.00 27.64           C  
ATOM   1336  CG  HIS   101      14.600  10.559  49.241  1.00 28.63           C  
ATOM   1337  ND1 HIS   101      15.589   9.592  49.190  1.00 29.98           N  
ATOM   1339  CE1 HIS   101      15.213   8.550  49.910  1.00 29.66           C  
ATOM   1341  NE2 HIS   101      14.023   8.807  50.425  1.00 29.55           N  
ATOM   1343  CD2 HIS   101      13.611  10.050  50.010  1.00 28.37           C  
ATOM   1345  C   HIS   101      14.093  13.162  46.463  1.00 26.91           C  
ATOM   1346  O   HIS   101      14.090  14.165  47.121  1.00 26.37           O  
ATOM   1348  N   THR   102      14.172  13.155  45.136  1.00 27.88           N  
ATOM   1349  CA  THR   102      14.323  14.343  44.296  1.00 28.28           C  
ATOM   1351  CB  THR   102      15.376  14.090  43.179  1.00 28.77           C  
ATOM   1353  OG1 THR   102      16.620  13.677  43.769  1.00 29.37           O  
ATOM   1355  CG2 THR   102      15.602  15.338  42.319  1.00 28.67           C  
ATOM   1359  C   THR   102      12.981  14.701  43.643  1.00 28.52           C  
ATOM   1360  O   THR   102      12.303  13.824  43.089  1.00 29.15           O  
ATOM   1362  N   VAL   103      12.571  15.975  43.723  1.00 28.29           N  
ATOM   1363  CA  VAL   103      11.375  16.424  43.007  1.00 27.89           C  
ATOM   1365  CB  VAL   103      10.499  17.411  43.792  1.00 27.37           C  
ATOM   1367  CG1 VAL   103       9.458  17.967  42.885  1.00 27.07           C  
ATOM   1371  CG2 VAL   103       9.842  16.749  44.935  1.00 26.32           C  
ATOM   1375  C   VAL   103      11.855  17.124  41.762  1.00 28.32           C  
ATOM   1376  O   VAL   103      12.766  17.953  41.840  1.00 27.99           O  
ATOM   1378  N   LEU   104      11.241  16.769  40.627  1.00 28.66           N  
ATOM   1379  CA  LEU   104      11.499  17.407  39.326  1.00 28.73           C  
ATOM   1381  CB  LEU   104      11.432  16.357  38.204  1.00 28.51           C  
ATOM   1384  CG  LEU   104      11.478  16.890  36.764  1.00 29.73           C  
ATOM   1386  CD1 LEU   104      12.826  17.591  36.418  1.00 30.68           C  
ATOM   1390  CD2 LEU   104      11.197  15.768  35.748  1.00 29.46           C  
ATOM   1394  C   LEU   104      10.469  18.508  39.084  1.00 28.35           C  
ATOM   1395  O   LEU   104       9.279  18.299  39.308  1.00 28.58           O  
ATOM   1397  N   TYR   105      10.935  19.672  38.635  1.00 28.26           N  
ATOM   1398  CA  TYR   105      10.055  20.816  38.292  1.00 28.44           C  
ATOM   1400  CB  TYR   105      10.335  22.040  39.206  1.00 28.13           C  
ATOM   1403  CG  TYR   105      10.205  21.756  40.702  1.00 27.64           C  
ATOM   1404  CD1 TYR   105      11.284  21.202  41.410  1.00 28.21           C  
ATOM   1406  CE1 TYR   105      11.188  20.907  42.749  1.00 27.85           C  
ATOM   1408  CZ  TYR   105      10.000  21.179  43.415  1.00 28.16           C  
ATOM   1409  OH  TYR   105       9.935  20.866  44.768  1.00 26.64           O  
ATOM   1411  CE2 TYR   105       8.925  21.757  42.726  1.00 25.52           C  
ATOM   1413  CD2 TYR   105       9.032  22.035  41.395  1.00 24.48           C  
ATOM   1415  C   TYR   105      10.264  21.171  36.797  1.00 28.60           C  
ATOM   1416  O   TYR   105      11.342  21.633  36.439  1.00 28.75           O  
ATOM   1418  N   VAL   106       9.255  20.945  35.942  1.00 28.20           N  
ATOM   1419  CA  VAL   106       9.399  21.109  34.476  1.00 28.13           C  
ATOM   1421  CB  VAL   106       9.437  19.736  33.731  1.00 27.97           C  
ATOM   1423  CG1 VAL   106      10.590  18.978  34.171  1.00 29.41           C  
ATOM   1427  CG2 VAL   106       8.201  18.935  34.004  1.00 26.97           C  
ATOM   1431  C   VAL   106       8.304  21.933  33.793  1.00 27.78           C  
ATOM   1432  O   VAL   106       7.135  21.879  34.152  1.00 27.98           O  
ATOM   1434  N   THR   107       8.698  22.640  32.750  1.00 27.47           N  
ATOM   1435  CA  THR   107       7.797  23.502  31.995  1.00 27.60           C  
ATOM   1437  CB  THR   107       8.624  24.430  31.114  1.00 27.08           C  
ATOM   1439  OG1 THR   107       9.242  25.406  31.949  1.00 26.99           O  
ATOM   1441  CG2 THR   107       7.752  25.104  30.113  1.00 28.88           C  
ATOM   1445  C   THR   107       6.738  22.762  31.142  1.00 27.29           C  
ATOM   1446  O   THR   107       5.602  23.217  31.046  1.00 27.48           O  
ATOM   1448  N   VAL   108       7.124  21.648  30.524  1.00 26.89           N  
ATOM   1449  CA  VAL   108       6.228  20.847  29.718  1.00 26.46           C  
ATOM   1451  CB  VAL   108       6.701  20.787  28.284  1.00 26.45           C  
ATOM   1453  CG1 VAL   108       5.756  19.953  27.480  1.00 25.92           C  
ATOM   1457  CG2 VAL   108       6.837  22.205  27.700  1.00 26.36           C  
ATOM   1461  C   VAL   108       6.186  19.431  30.231  1.00 26.51           C  
ATOM   1462  O   VAL   108       7.157  18.899  30.725  1.00 26.61           O  
ATOM   1464  N   GLU   109       5.033  18.814  30.117  1.00 27.18           N  
ATOM   1465  CA  GLU   109       4.876  17.390  30.411  1.00 27.29           C  
ATOM   1467  CB  GLU   109       3.488  16.904  29.932  1.00 27.24           C  
ATOM   1470  CG  GLU   109       3.138  15.447  30.308  1.00 28.49           C  
ATOM   1473  CD  GLU   109       1.889  14.937  29.589  1.00 29.27           C  
ATOM   1474  OE1 GLU   109       1.109  15.760  29.061  1.00 29.40           O  
ATOM   1475  OE2 GLU   109       1.691  13.706  29.528  1.00 30.07           O  
ATOM   1476  C   GLU   109       6.009  16.560  29.782  1.00 26.50           C  
ATOM   1477  O   GLU   109       6.244  16.634  28.607  1.00 25.85           O  
ATOM   1479  N   PRO   110       6.734  15.790  30.590  1.00 27.08           N  
ATOM   1480  CA  PRO   110       7.729  14.855  30.045  1.00 27.45           C  
ATOM   1482  CB  PRO   110       8.119  14.018  31.256  1.00 27.41           C  
ATOM   1485  CG  PRO   110       7.870  14.919  32.414  1.00 27.40           C  
ATOM   1488  CD  PRO   110       6.709  15.769  32.066  1.00 27.08           C  
ATOM   1491  C   PRO   110       7.213  13.943  28.942  1.00 27.32           C  
ATOM   1492  O   PRO   110       6.112  13.439  29.046  1.00 26.89           O  
ATOM   1493  N   CYS   111       8.019  13.764  27.895  1.00 27.48           N  
ATOM   1494  CA  CYS   111       7.673  12.895  26.779  1.00 27.20           C  
ATOM   1496  CB  CYS   111       8.596  13.159  25.591  1.00 27.18           C  
ATOM   1499  SG  CYS   111      10.319  12.549  25.762  1.00 26.81           S  
ATOM   1501  C   CYS   111       7.773  11.433  27.179  1.00 27.55           C  
ATOM   1502  O   CYS   111       8.200  11.098  28.282  1.00 27.24           O  
ATOM   1504  N   ILE   112       7.393  10.555  26.260  1.00 27.67           N  
ATOM   1505  CA  ILE   112       7.456   9.134  26.532  1.00 27.66           C  
ATOM   1507  CB  ILE   112       6.865   8.310  25.370  1.00 27.71           C  
ATOM   1509  CG1 ILE   112       5.338   8.440  25.369  1.00 28.05           C  
ATOM   1512  CD1 ILE   112       4.648   7.765  24.177  1.00 28.17           C  
ATOM   1516  CG2 ILE   112       7.261   6.828  25.471  1.00 27.28           C  
ATOM   1520  C   ILE   112       8.872   8.692  26.886  1.00 27.75           C  
ATOM   1521  O   ILE   112       9.050   7.898  27.810  1.00 27.52           O  
ATOM   1523  N   MET   113       9.878   9.206  26.168  1.00 28.00           N  
ATOM   1524  CA  MET   113      11.286   8.865  26.477  1.00 27.71           C  
ATOM   1526  CB  MET   113      12.224   9.558  25.518  1.00 27.36           C  
ATOM   1529  CG  MET   113      13.630   9.038  25.611  1.00 27.66           C  
ATOM   1532  SD  MET   113      14.781  10.217  24.914  1.00 29.59           S  
ATOM   1533  CE  MET   113      15.865  10.464  26.347  1.00 31.93           C  
ATOM   1537  C   MET   113      11.695   9.263  27.906  1.00 27.74           C  
ATOM   1538  O   MET   113      12.210   8.430  28.653  1.00 27.33           O  
ATOM   1540  N   CYS   114      11.461  10.527  28.255  1.00 27.33           N  
ATOM   1541  CA  CYS   114      11.773  11.050  29.574  1.00 27.96           C  
ATOM   1543  CB  CYS   114      11.535  12.562  29.593  1.00 28.16           C  
ATOM   1546  SG  CYS   114      12.745  13.454  28.634  1.00 29.88           S  
ATOM   1548  C   CYS   114      10.984  10.409  30.733  1.00 27.83           C  
ATOM   1549  O   CYS   114      11.560  10.008  31.741  1.00 27.85           O  
ATOM   1551  N   ALA   115       9.675  10.312  30.597  1.00 27.62           N  
ATOM   1552  CA  ALA   115       8.891   9.588  31.569  1.00 27.76           C  
ATOM   1554  CB  ALA   115       7.432   9.558  31.146  1.00 27.42           C  
ATOM   1558  C   ALA   115       9.442   8.163  31.819  1.00 28.27           C  
ATOM   1559  O   ALA   115       9.599   7.752  32.985  1.00 29.59           O  
ATOM   1561  N   ALA   116       9.771   7.412  30.769  1.00 28.12           N  
ATOM   1562  CA  ALA   116      10.385   6.078  30.963  1.00 28.33           C  
ATOM   1564  CB  ALA   116      10.653   5.371  29.619  1.00 27.77           C  
ATOM   1568  C   ALA   116      11.675   6.194  31.785  1.00 28.62           C  
ATOM   1569  O   ALA   116      11.941   5.377  32.671  1.00 29.32           O  
ATOM   1571  N   ALA   117      12.463   7.229  31.508  1.00 28.78           N  
ATOM   1572  CA  ALA   117      13.700   7.484  32.246  1.00 28.73           C  
ATOM   1574  CB  ALA   117      14.421   8.676  31.653  1.00 28.83           C  
ATOM   1578  C   ALA   117      13.441   7.743  33.724  1.00 28.85           C  
ATOM   1579  O   ALA   117      14.094   7.176  34.577  1.00 28.67           O  
ATOM   1581  N   LEU   118      12.477   8.620  34.005  1.00 29.20           N  
ATOM   1582  CA  LEU   118      12.155   9.023  35.360  1.00 28.43           C  
ATOM   1584  CB  LEU   118      11.127  10.154  35.347  1.00 27.97           C  
ATOM   1587  CG  LEU   118      11.692  11.452  34.772  1.00 27.63           C  
ATOM   1589  CD1 LEU   118      10.735  12.603  34.919  1.00 28.37           C  
ATOM   1593  CD2 LEU   118      12.963  11.797  35.439  1.00 28.09           C  
ATOM   1597  C   LEU   118      11.669   7.840  36.159  1.00 28.28           C  
ATOM   1598  O   LEU   118      12.014   7.730  37.331  1.00 28.30           O  
ATOM   1600  N   ARG   119      10.895   6.949  35.534  1.00 28.26           N  
ATOM   1601  CA  ARG   119      10.579   5.659  36.179  1.00 28.76           C  
ATOM   1603  CB  ARG   119       9.775   4.752  35.252  1.00 29.30           C  
ATOM   1606  CG  ARG   119       8.261   4.867  35.387  1.00 29.05           C  
ATOM   1609  CD  ARG   119       7.630   3.767  34.611  1.00 29.20           C  
ATOM   1612  NE  ARG   119       7.435   2.550  35.388  1.00 29.29           N  
ATOM   1614  CZ  ARG   119       6.316   2.241  36.052  1.00 30.71           C  
ATOM   1615  NH1 ARG   119       5.280   3.079  36.090  1.00 31.34           N  
ATOM   1618  NH2 ARG   119       6.229   1.086  36.713  1.00 31.28           N  
ATOM   1621  C   ARG   119      11.826   4.865  36.565  1.00 28.71           C  
ATOM   1622  O   ARG   119      11.942   4.355  37.683  1.00 28.42           O  
ATOM   1624  N   LEU   120      12.738   4.738  35.608  1.00 28.29           N  
ATOM   1625  CA  LEU   120      13.955   3.987  35.836  1.00 28.40           C  
ATOM   1627  CB  LEU   120      14.671   3.762  34.510  1.00 27.90           C  
ATOM   1630  CG  LEU   120      13.979   2.793  33.547  1.00 26.59           C  
ATOM   1632  CD1 LEU   120      14.630   2.885  32.201  1.00 25.10           C  
ATOM   1636  CD2 LEU   120      13.984   1.375  34.042  1.00 24.24           C  
ATOM   1640  C   LEU   120      14.896   4.605  36.898  1.00 28.81           C  
ATOM   1641  O   LEU   120      15.541   3.860  37.658  1.00 29.54           O  
ATOM   1643  N   MET   121      14.978   5.941  36.943  1.00 28.87           N  
ATOM   1644  CA  MET   121      15.712   6.673  37.985  1.00 28.40           C  
ATOM   1646  CB  MET   121      15.922   8.132  37.588  1.00 28.32           C  
ATOM   1649  CG  MET   121      16.793   8.350  36.362  1.00 29.39           C  
ATOM   1652  SD  MET   121      18.368   7.437  36.341  1.00 31.52           S  
ATOM   1653  CE  MET   121      19.455   8.674  37.112  1.00 32.17           C  
ATOM   1657  C   MET   121      14.968   6.697  39.316  1.00 28.60           C  
ATOM   1658  O   MET   121      15.578   6.990  40.327  1.00 28.98           O  
ATOM   1660  N   LYS   122      13.654   6.446  39.301  1.00 28.57           N  
ATOM   1661  CA  LYS   122      12.791   6.393  40.496  1.00 27.97           C  
ATOM   1663  CB  LYS   122      13.311   5.396  41.523  1.00 27.70           C  
ATOM   1666  CG  LYS   122      13.463   4.024  41.001  1.00 27.70           C  
ATOM   1669  CD  LYS   122      13.797   3.117  42.133  1.00 28.38           C  
ATOM   1672  CE  LYS   122      13.990   1.713  41.622  1.00 28.97           C  
ATOM   1675  NZ  LYS   122      14.226   0.736  42.706  1.00 29.76           N  
ATOM   1679  C   LYS   122      12.590   7.725  41.178  1.00 28.20           C  
ATOM   1680  O   LYS   122      12.469   7.773  42.412  1.00 28.06           O  
ATOM   1682  N   ILE   123      12.586   8.805  40.394  1.00 27.95           N  
ATOM   1683  CA  ILE   123      12.130  10.084  40.892  1.00 27.99           C  
ATOM   1685  CB  ILE   123      12.231  11.205  39.833  1.00 28.47           C  
ATOM   1687  CG1 ILE   123      13.668  11.737  39.725  1.00 30.17           C  
ATOM   1690  CD1 ILE   123      14.537  11.101  38.597  1.00 31.52           C  
ATOM   1694  CG2 ILE   123      11.368  12.380  40.218  1.00 27.61           C  
ATOM   1698  C   ILE   123      10.659   9.867  41.267  1.00 27.89           C  
ATOM   1699  O   ILE   123       9.901   9.331  40.452  1.00 27.80           O  
ATOM   1701  N   PRO   124      10.268  10.206  42.521  1.00 27.53           N  
ATOM   1702  CA  PRO   124       8.908  10.069  43.039  1.00 27.20           C  
ATOM   1704  CB  PRO   124       9.133  10.061  44.535  1.00 27.06           C  
ATOM   1707  CG  PRO   124      10.268  10.856  44.751  1.00 27.33           C  
ATOM   1710  CD  PRO   124      11.177  10.670  43.583  1.00 27.38           C  
ATOM   1713  C   PRO   124       7.871  11.158  42.702  1.00 27.45           C  
ATOM   1714  O   PRO   124       6.685  10.838  42.712  1.00 27.46           O  
ATOM   1715  N   LEU   125       8.290  12.403  42.420  1.00 27.23           N  
ATOM   1716  CA  LEU   125       7.342  13.475  42.135  1.00 27.35           C  
ATOM   1718  CB  LEU   125       7.072  14.273  43.410  1.00 27.50           C  
ATOM   1721  CG  LEU   125       6.170  15.505  43.456  1.00 26.55           C  
ATOM   1723  CD1 LEU   125       4.804  15.257  42.848  1.00 27.47           C  
ATOM   1727  CD2 LEU   125       6.038  15.903  44.891  1.00 25.10           C  
ATOM   1731  C   LEU   125       7.805  14.419  41.029  1.00 28.05           C  
ATOM   1732  O   LEU   125       8.891  14.992  41.124  1.00 28.35           O  
ATOM   1734  N   VAL   126       6.962  14.578  39.993  1.00 28.17           N  
ATOM   1735  CA  VAL   126       7.152  15.557  38.936  1.00 27.98           C  
ATOM   1737  CB  VAL   126       7.033  14.889  37.547  1.00 28.31           C  
ATOM   1739  CG1 VAL   126       7.189  15.937  36.449  1.00 28.62           C  
ATOM   1743  CG2 VAL   126       8.075  13.764  37.376  1.00 28.63           C  
ATOM   1747  C   VAL   126       6.066  16.632  39.064  1.00 27.89           C  
ATOM   1748  O   VAL   126       4.885  16.314  39.154  1.00 27.83           O  
ATOM   1750  N   VAL   127       6.461  17.897  39.084  1.00 27.59           N  
ATOM   1751  CA  VAL   127       5.498  18.987  39.043  1.00 27.75           C  
ATOM   1753  CB  VAL   127       5.719  20.057  40.161  1.00 28.05           C  
ATOM   1755  CG1 VAL   127       5.015  21.381  39.854  1.00 27.26           C  
ATOM   1759  CG2 VAL   127       5.246  19.535  41.514  1.00 28.36           C  
ATOM   1763  C   VAL   127       5.737  19.598  37.704  1.00 27.95           C  
ATOM   1764  O   VAL   127       6.864  19.972  37.389  1.00 27.12           O  
ATOM   1766  N   TYR   128       4.680  19.692  36.900  1.00 28.52           N  
ATOM   1767  CA  TYR   128       4.822  20.268  35.566  1.00 28.45           C  
ATOM   1769  CB  TYR   128       5.025  19.162  34.533  1.00 28.06           C  
ATOM   1772  CG  TYR   128       3.818  18.402  34.078  1.00 28.34           C  
ATOM   1773  CD1 TYR   128       3.626  17.059  34.437  1.00 29.46           C  
ATOM   1775  CE1 TYR   128       2.514  16.329  33.958  1.00 28.31           C  
ATOM   1777  CZ  TYR   128       1.612  16.958  33.113  1.00 29.12           C  
ATOM   1778  OH  TYR   128       0.500  16.310  32.604  1.00 28.84           O  
ATOM   1780  CE2 TYR   128       1.816  18.275  32.740  1.00 29.55           C  
ATOM   1782  CD2 TYR   128       2.914  18.975  33.204  1.00 28.51           C  
ATOM   1784  C   TYR   128       3.757  21.297  35.151  1.00 28.39           C  
ATOM   1785  O   TYR   128       2.754  21.529  35.860  1.00 28.91           O  
ATOM   1787  N   GLY   129       4.029  21.932  34.015  1.00 27.67           N  
ATOM   1788  CA  GLY   129       3.199  22.991  33.493  1.00 27.87           C  
ATOM   1791  C   GLY   129       2.120  22.551  32.535  1.00 27.68           C  
ATOM   1792  O   GLY   129       1.142  21.973  32.960  1.00 28.21           O  
ATOM   1794  N   CYS   130       2.275  22.855  31.252  1.00 27.34           N  
ATOM   1795  CA  CYS   130       1.279  22.499  30.266  1.00 27.89           C  
ATOM   1797  CB  CYS   130       1.342  23.480  29.107  1.00 27.89           C  
ATOM   1800  SG  CYS   130       2.914  23.319  28.162  1.00 30.29           S  
ATOM   1802  C   CYS   130       1.470  21.072  29.724  1.00 27.56           C  
ATOM   1803  O   CYS   130       2.489  20.438  29.937  1.00 26.76           O  
ATOM   1805  N   GLN   131       0.471  20.610  28.984  1.00 27.70           N  
ATOM   1806  CA  GLN   131       0.459  19.278  28.412  1.00 27.98           C  
ATOM   1808  CB  GLN   131      -0.950  18.922  27.932  1.00 28.47           C  
ATOM   1811  CG  GLN   131      -2.080  18.913  29.037  1.00 29.70           C  
ATOM   1814  CD  GLN   131      -1.959  17.735  30.027  1.00 31.77           C  
ATOM   1815  OE1 GLN   131      -1.739  16.574  29.619  1.00 33.82           O  
ATOM   1816  NE2 GLN   131      -2.093  18.027  31.327  1.00 31.60           N  
ATOM   1819  C   GLN   131       1.429  19.146  27.243  1.00 27.96           C  
ATOM   1820  O   GLN   131       1.803  20.137  26.635  1.00 27.61           O  
ATOM   1822  N   ASN   132       1.838  17.908  26.957  1.00 27.61           N  
ATOM   1823  CA  ASN   132       2.626  17.589  25.790  1.00 27.44           C  
ATOM   1825  CB  ASN   132       3.852  16.823  26.237  1.00 27.50           C  
ATOM   1828  CG  ASN   132       4.790  16.477  25.105  1.00 27.17           C  
ATOM   1829  OD1 ASN   132       4.451  16.645  23.947  1.00 28.04           O  
ATOM   1830  ND2 ASN   132       5.969  15.974  25.440  1.00 26.21           N  
ATOM   1833  C   ASN   132       1.780  16.782  24.793  1.00 27.56           C  
ATOM   1834  O   ASN   132       1.796  15.567  24.792  1.00 27.93           O  
ATOM   1836  N   GLU   133       1.042  17.475  23.940  1.00 27.82           N  
ATOM   1837  CA  GLU   133       0.081  16.823  23.046  1.00 28.46           C  
ATOM   1839  CB  GLU   133      -0.771  17.863  22.301  1.00 28.66           C  
ATOM   1842  CG  GLU   133      -2.060  18.259  23.041  1.00 30.06           C  
ATOM   1845  CD  GLU   133      -2.933  19.217  22.235  1.00 31.68           C  
ATOM   1846  OE1 GLU   133      -3.256  18.917  21.055  1.00 31.78           O  
ATOM   1847  OE2 GLU   133      -3.298  20.278  22.791  1.00 33.58           O  
ATOM   1848  C   GLU   133       0.692  15.860  22.029  1.00 28.35           C  
ATOM   1849  O   GLU   133       0.094  14.830  21.710  1.00 28.39           O  
ATOM   1851  N   ARG   134       1.869  16.202  21.523  1.00 28.25           N  
ATOM   1852  CA  ARG   134       2.561  15.377  20.550  1.00 28.21           C  
ATOM   1854  CB  ARG   134       3.683  16.166  19.899  1.00 28.39           C  
ATOM   1857  CG  ARG   134       3.264  17.431  19.221  1.00 28.78           C  
ATOM   1860  CD  ARG   134       4.465  18.125  18.644  1.00 29.15           C  
ATOM   1863  NE  ARG   134       4.091  19.255  17.801  1.00 29.84           N  
ATOM   1865  CZ  ARG   134       4.910  19.864  16.935  1.00 31.27           C  
ATOM   1866  NH1 ARG   134       6.177  19.461  16.778  1.00 31.15           N  
ATOM   1869  NH2 ARG   134       4.464  20.902  16.221  1.00 32.11           N  
ATOM   1872  C   ARG   134       3.178  14.108  21.162  1.00 28.31           C  
ATOM   1873  O   ARG   134       3.053  13.042  20.586  1.00 28.43           O  
ATOM   1875  N   PHE   135       3.865  14.216  22.302  1.00 28.31           N  
ATOM   1876  CA  PHE   135       4.589  13.063  22.841  1.00 28.53           C  
ATOM   1878  CB  PHE   135       6.034  13.163  22.343  1.00 28.53           C  
ATOM   1881  CG  PHE   135       6.732  11.841  22.165  1.00 28.29           C  
ATOM   1882  CD1 PHE   135       6.029  10.670  21.855  1.00 28.13           C  
ATOM   1884  CE1 PHE   135       6.692   9.435  21.694  1.00 28.35           C  
ATOM   1886  CZ  PHE   135       8.063   9.366  21.827  1.00 28.92           C  
ATOM   1888  CE2 PHE   135       8.788  10.545  22.126  1.00 30.44           C  
ATOM   1890  CD2 PHE   135       8.112  11.776  22.288  1.00 28.94           C  
ATOM   1892  C   PHE   135       4.521  12.863  24.376  1.00 28.82           C  
ATOM   1893  O   PHE   135       5.346  12.140  24.953  1.00 29.17           O  
ATOM   1895  N   GLY   136       3.510  13.446  25.019  1.00 28.58           N  
ATOM   1896  CA  GLY   136       3.332  13.292  26.455  1.00 29.12           C  
ATOM   1899  C   GLY   136       3.279  11.832  26.957  1.00 29.71           C  
ATOM   1900  O   GLY   136       2.548  10.985  26.410  1.00 29.56           O  
ATOM   1902  N   GLY   137       4.055  11.555  28.013  1.00 29.77           N  
ATOM   1903  CA  GLY   137       4.027  10.275  28.740  1.00 29.90           C  
ATOM   1906  C   GLY   137       3.441  10.285  30.168  1.00 29.93           C  
ATOM   1907  O   GLY   137       3.670   9.350  30.965  1.00 30.73           O  
ATOM   1909  N   CYS   138       2.667  11.308  30.498  1.00 29.42           N  
ATOM   1910  CA  CYS   138       2.001  11.353  31.793  1.00 29.62           C  
ATOM   1912  CB  CYS   138       2.460  12.576  32.587  1.00 29.79           C  
ATOM   1915  SG  CYS   138       4.218  12.576  32.898  1.00 30.23           S  
ATOM   1917  C   CYS   138       0.490  11.355  31.686  1.00 29.17           C  
ATOM   1918  O   CYS   138      -0.197  11.656  32.652  1.00 28.48           O  
ATOM   1920  N   GLY   139      -0.019  11.016  30.511  1.00 29.34           N  
ATOM   1921  CA  GLY   139      -1.452  11.056  30.270  1.00 29.45           C  
ATOM   1924  C   GLY   139      -1.880  11.464  28.872  1.00 29.50           C  
ATOM   1925  O   GLY   139      -2.898  10.977  28.401  1.00 30.03           O  
ATOM   1927  N   SER   140      -1.121  12.330  28.190  1.00 29.38           N  
ATOM   1928  CA  SER   140      -1.573  12.879  26.892  1.00 28.69           C  
ATOM   1930  CB  SER   140      -0.698  14.057  26.466  1.00 28.93           C  
ATOM   1933  OG  SER   140      -0.859  15.151  27.372  1.00 29.34           O  
ATOM   1935  C   SER   140      -1.596  11.834  25.803  1.00 28.12           C  
ATOM   1936  O   SER   140      -2.623  11.555  25.238  1.00 27.68           O  
ATOM   1938  N   VAL   141      -0.454  11.256  25.506  1.00 28.02           N  
ATOM   1939  CA  VAL   141      -0.395  10.196  24.522  1.00 27.98           C  
ATOM   1941  CB  VAL   141       0.827  10.374  23.645  1.00 27.84           C  
ATOM   1943  CG1 VAL   141       0.846   9.345  22.553  1.00 27.05           C  
ATOM   1947  CG2 VAL   141       0.852  11.775  23.089  1.00 27.21           C  
ATOM   1951  C   VAL   141      -0.345   8.820  25.204  1.00 28.40           C  
ATOM   1952  O   VAL   141      -0.958   7.871  24.753  1.00 28.56           O  
ATOM   1954  N   LEU   142       0.434   8.716  26.266  1.00 28.60           N  
ATOM   1955  CA  LEU   142       0.486   7.511  27.059  1.00 28.88           C  
ATOM   1957  CB  LEU   142       1.655   6.641  26.609  1.00 29.36           C  
ATOM   1960  CG  LEU   142       1.363   5.515  25.614  1.00 29.50           C  
ATOM   1962  CD1 LEU   142       2.672   5.036  24.980  1.00 29.36           C  
ATOM   1966  CD2 LEU   142       0.667   4.390  26.351  1.00 28.79           C  
ATOM   1970  C   LEU   142       0.688   7.927  28.500  1.00 29.16           C  
ATOM   1971  O   LEU   142       1.134   9.040  28.782  1.00 29.17           O  
ATOM   1973  N   ASN   143       0.385   7.034  29.430  1.00 29.52           N  
ATOM   1974  CA  ASN   143       0.660   7.355  30.830  1.00 29.66           C  
ATOM   1976  CB  ASN   143      -0.628   7.395  31.629  1.00 29.61           C  
ATOM   1979  CG  ASN   143      -0.449   8.019  33.008  1.00 30.12           C  
ATOM   1980  OD1 ASN   143       0.647   8.046  33.602  1.00 27.75           O  
ATOM   1981  ND2 ASN   143      -1.567   8.488  33.549  1.00 31.84           N  
ATOM   1984  C   ASN   143       1.656   6.390  31.451  1.00 29.47           C  
ATOM   1985  O   ASN   143       1.281   5.505  32.230  1.00 28.77           O  
ATOM   1987  N   ILE   144       2.927   6.598  31.096  1.00 29.28           N  
ATOM   1988  CA  ILE   144       4.015   5.785  31.617  1.00 29.57           C  
ATOM   1990  CB  ILE   144       5.319   6.097  30.858  1.00 30.11           C  
ATOM   1992  CG1 ILE   144       5.167   5.738  29.372  1.00 31.30           C  
ATOM   1995  CD1 ILE   144       4.789   4.257  29.149  1.00 30.50           C  
ATOM   1999  CG2 ILE   144       6.510   5.303  31.422  1.00 30.18           C  
ATOM   2003  C   ILE   144       4.215   6.059  33.113  1.00 29.39           C  
ATOM   2004  O   ILE   144       4.545   5.141  33.866  1.00 28.54           O  
ATOM   2006  N   ALA   145       4.002   7.321  33.525  1.00 29.02           N  
ATOM   2007  CA  ALA   145       4.144   7.720  34.926  1.00 28.89           C  
ATOM   2009  CB  ALA   145       3.712   9.214  35.134  1.00 28.28           C  
ATOM   2013  C   ALA   145       3.364   6.780  35.871  1.00 29.09           C  
ATOM   2014  O   ALA   145       3.871   6.429  36.949  1.00 30.20           O  
ATOM   2016  N   SER   146       2.152   6.351  35.482  1.00 28.63           N  
ATOM   2017  CA  SER   146       1.299   5.589  36.399  1.00 28.27           C  
ATOM   2019  CB  SER   146      -0.022   6.323  36.579  1.00 28.33           C  
ATOM   2022  OG  SER   146      -0.803   6.270  35.407  1.00 28.49           O  
ATOM   2024  C   SER   146       1.055   4.147  35.959  1.00 27.91           C  
ATOM   2025  O   SER   146       0.192   3.468  36.474  1.00 27.20           O  
ATOM   2027  N   ALA   147       1.844   3.685  35.009  1.00 28.29           N  
ATOM   2028  CA  ALA   147       1.650   2.368  34.418  1.00 28.30           C  
ATOM   2030  CB  ALA   147       2.500   2.220  33.141  1.00 28.16           C  
ATOM   2034  C   ALA   147       2.008   1.281  35.414  1.00 28.18           C  
ATOM   2035  O   ALA   147       3.001   1.382  36.137  1.00 27.83           O  
ATOM   2037  N   ASP   148       1.178   0.248  35.441  1.00 28.60           N  
ATOM   2038  CA  ASP   148       1.422  -0.958  36.235  1.00 29.01           C  
ATOM   2040  CB  ASP   148       0.116  -1.758  36.344  1.00 29.22           C  
ATOM   2043  CG  ASP   148       0.271  -3.024  37.194  1.00 30.33           C  
ATOM   2044  OD1 ASP   148       1.223  -3.009  38.017  1.00 32.80           O  
ATOM   2045  OD2 ASP   148      -0.548  -4.005  37.063  1.00 28.99           O  
ATOM   2046  C   ASP   148       2.529  -1.831  35.603  1.00 28.97           C  
ATOM   2047  O   ASP   148       2.258  -2.648  34.732  1.00 29.13           O  
ATOM   2049  N   LEU   149       3.769  -1.644  36.037  1.00 28.92           N  
ATOM   2050  CA  LEU   149       4.910  -2.289  35.410  1.00 28.99           C  
ATOM   2052  CB  LEU   149       5.672  -1.312  34.501  1.00 28.85           C  
ATOM   2055  CG  LEU   149       4.909  -0.925  33.221  1.00 29.26           C  
ATOM   2057  CD1 LEU   149       5.552   0.303  32.539  1.00 28.15           C  
ATOM   2061  CD2 LEU   149       4.777  -2.100  32.253  1.00 27.32           C  
ATOM   2065  C   LEU   149       5.774  -2.797  36.547  1.00 29.23           C  
ATOM   2066  O   LEU   149       6.621  -2.072  37.076  1.00 29.09           O  
ATOM   2068  N   PRO   150       5.560  -4.060  36.923  1.00 29.54           N  
ATOM   2069  CA  PRO   150       6.060  -4.553  38.210  1.00 29.67           C  
ATOM   2071  CB  PRO   150       5.659  -6.054  38.214  1.00 29.48           C  
ATOM   2074  CG  PRO   150       4.613  -6.214  37.167  1.00 29.39           C  
ATOM   2077  CD  PRO   150       4.844  -5.103  36.153  1.00 29.63           C  
ATOM   2080  C   PRO   150       7.581  -4.399  38.417  1.00 29.61           C  
ATOM   2081  O   PRO   150       8.018  -3.945  39.489  1.00 29.54           O  
ATOM   2082  N   ASN   151       8.376  -4.783  37.422  1.00 29.36           N  
ATOM   2083  CA  ASN   151       9.822  -4.955  37.659  1.00 29.29           C  
ATOM   2085  CB  ASN   151      10.222  -6.417  37.379  1.00 29.22           C  
ATOM   2088  CG  ASN   151       9.393  -7.403  38.184  1.00 29.70           C  
ATOM   2089  OD1 ASN   151       9.515  -7.467  39.415  1.00 31.50           O  
ATOM   2090  ND2 ASN   151       8.529  -8.160  37.506  1.00 29.02           N  
ATOM   2093  C   ASN   151      10.696  -3.953  36.893  1.00 29.09           C  
ATOM   2094  O   ASN   151      11.868  -4.212  36.608  1.00 28.75           O  
ATOM   2096  N   THR   152      10.114  -2.797  36.586  1.00 29.07           N  
ATOM   2097  CA  THR   152      10.816  -1.768  35.853  1.00 29.13           C  
ATOM   2099  CB  THR   152      10.365  -1.749  34.358  1.00 29.31           C  
ATOM   2101  OG1 THR   152       8.964  -1.486  34.277  1.00 28.92           O  
ATOM   2103  CG2 THR   152      10.672  -3.123  33.693  1.00 29.99           C  
ATOM   2107  C   THR   152      10.600  -0.410  36.487  1.00 28.94           C  
ATOM   2108  O   THR   152       9.581   0.221  36.237  1.00 29.39           O  
ATOM   2110  N   GLY   153      11.562   0.038  37.301  1.00 28.73           N  
ATOM   2111  CA  GLY   153      11.483   1.345  37.989  1.00 28.04           C  
ATOM   2114  C   GLY   153      10.359   1.408  39.007  1.00 27.67           C  
ATOM   2115  O   GLY   153       9.875   0.385  39.480  1.00 27.40           O  
ATOM   2117  N   ARG   154       9.926   2.618  39.332  1.00 27.56           N  
ATOM   2118  CA  ARG   154       8.747   2.822  40.177  1.00 27.59           C  
ATOM   2120  CB  ARG   154       9.132   3.433  41.525  1.00 27.45           C  
ATOM   2123  CG  ARG   154       9.477   2.437  42.549  1.00 27.94           C  
ATOM   2126  CD  ARG   154      10.289   3.050  43.692  1.00 29.70           C  
ATOM   2129  NE  ARG   154      11.140   2.009  44.299  1.00 31.13           N  
ATOM   2131  CZ  ARG   154      11.949   2.180  45.345  1.00 30.89           C  
ATOM   2132  NH1 ARG   154      12.044   3.355  45.964  1.00 31.54           N  
ATOM   2135  NH2 ARG   154      12.672   1.155  45.773  1.00 31.08           N  
ATOM   2138  C   ARG   154       7.802   3.767  39.492  1.00 27.48           C  
ATOM   2139  O   ARG   154       8.250   4.674  38.804  1.00 28.31           O  
ATOM   2141  N   PRO   155       6.494   3.619  39.730  1.00 27.20           N  
ATOM   2142  CA  PRO   155       5.580   4.628  39.183  1.00 27.00           C  
ATOM   2144  CB  PRO   155       4.213   4.019  39.450  1.00 27.10           C  
ATOM   2147  CG  PRO   155       4.437   3.158  40.638  1.00 26.63           C  
ATOM   2150  CD  PRO   155       5.785   2.594  40.507  1.00 26.55           C  
ATOM   2153  C   PRO   155       5.717   5.931  39.935  1.00 26.56           C  
ATOM   2154  O   PRO   155       6.093   5.929  41.091  1.00 26.56           O  
ATOM   2155  N   PHE   156       5.403   7.035  39.293  1.00 26.62           N  
ATOM   2156  CA  PHE   156       5.498   8.302  39.973  1.00 27.22           C  
ATOM   2158  CB  PHE   156       6.778   9.058  39.597  1.00 27.60           C  
ATOM   2161  CG  PHE   156       6.860   9.460  38.156  1.00 28.10           C  
ATOM   2162  CD1 PHE   156       6.445  10.730  37.746  1.00 28.61           C  
ATOM   2164  CE1 PHE   156       6.503  11.085  36.419  1.00 27.46           C  
ATOM   2166  CZ  PHE   156       7.012  10.192  35.490  1.00 27.56           C  
ATOM   2168  CE2 PHE   156       7.440   8.944  35.877  1.00 27.45           C  
ATOM   2170  CD2 PHE   156       7.367   8.578  37.206  1.00 27.25           C  
ATOM   2172  C   PHE   156       4.281   9.183  39.828  1.00 27.25           C  
ATOM   2173  O   PHE   156       3.396   8.940  39.036  1.00 27.35           O  
ATOM   2175  N   GLN   157       4.266  10.209  40.661  1.00 28.12           N  
ATOM   2176  CA  GLN   157       3.162  11.132  40.818  1.00 28.30           C  
ATOM   2178  CB  GLN   157       3.023  11.430  42.312  1.00 28.26           C  
ATOM   2181  CG  GLN   157       1.573  11.587  42.818  1.00 29.14           C  
ATOM   2184  CD  GLN   157       0.726  10.354  42.579  1.00 28.88           C  
ATOM   2185  OE1 GLN   157       1.229   9.216  42.576  1.00 28.76           O  
ATOM   2186  NE2 GLN   157      -0.573  10.565  42.387  1.00 28.49           N  
ATOM   2189  C   GLN   157       3.458  12.421  40.041  1.00 28.32           C  
ATOM   2190  O   GLN   157       4.630  12.798  39.874  1.00 28.21           O  
ATOM   2192  N   CYS   158       2.393  13.052  39.540  1.00 28.34           N  
ATOM   2193  CA  CYS   158       2.457  14.325  38.805  1.00 28.55           C  
ATOM   2195  CB  CYS   158       2.053  14.113  37.368  1.00 28.36           C  
ATOM   2198  SG  CYS   158       3.234  13.191  36.449  1.00 32.99           S  
ATOM   2200  C   CYS   158       1.518  15.370  39.380  1.00 28.03           C  
ATOM   2201  O   CYS   158       0.415  15.028  39.825  1.00 28.21           O  
ATOM   2203  N   ILE   159       1.945  16.633  39.348  1.00 27.55           N  
ATOM   2204  CA  ILE   159       1.083  17.776  39.671  1.00 27.15           C  
ATOM   2206  CB  ILE   159       1.560  18.532  40.932  1.00 27.19           C  
ATOM   2208  CG1 ILE   159       1.641  17.546  42.109  1.00 27.25           C  
ATOM   2211  CD1 ILE   159       1.732  18.195  43.500  1.00 27.36           C  
ATOM   2215  CG2 ILE   159       0.655  19.748  41.227  1.00 26.47           C  
ATOM   2219  C   ILE   159       1.151  18.672  38.468  1.00 27.06           C  
ATOM   2220  O   ILE   159       2.008  19.550  38.397  1.00 27.30           O  
ATOM   2222  N   PRO   160       0.298  18.414  37.472  1.00 27.10           N  
ATOM   2223  CA  PRO   160       0.305  19.229  36.281  1.00 27.19           C  
ATOM   2225  CB  PRO   160      -0.544  18.406  35.303  1.00 26.90           C  
ATOM   2228  CG  PRO   160      -1.433  17.695  36.094  1.00 26.70           C  
ATOM   2231  CD  PRO   160      -0.693  17.339  37.350  1.00 27.27           C  
ATOM   2234  C   PRO   160      -0.314  20.600  36.470  1.00 27.02           C  
ATOM   2235  O   PRO   160      -0.932  20.865  37.479  1.00 27.06           O  
ATOM   2236  N   GLY   161      -0.094  21.468  35.491  1.00 27.50           N  
ATOM   2237  CA  GLY   161      -0.924  22.640  35.290  1.00 27.79           C  
ATOM   2240  C   GLY   161      -0.387  23.921  35.877  1.00 27.97           C  
ATOM   2241  O   GLY   161      -0.988  24.972  35.702  1.00 28.30           O  
ATOM   2243  N   TYR   162       0.734  23.872  36.581  1.00 28.36           N  
ATOM   2244  CA  TYR   162       1.233  25.110  37.155  1.00 28.73           C  
ATOM   2246  CB  TYR   162       2.370  24.897  38.182  1.00 29.03           C  
ATOM   2249  CG  TYR   162       2.842  26.246  38.703  1.00 30.02           C  
ATOM   2250  CD1 TYR   162       2.168  26.905  39.728  1.00 30.55           C  
ATOM   2252  CE1 TYR   162       2.574  28.183  40.156  1.00 31.77           C  
ATOM   2254  CZ  TYR   162       3.668  28.808  39.529  1.00 32.70           C  
ATOM   2255  OH  TYR   162       4.146  30.073  39.894  1.00 31.50           O  
ATOM   2257  CE2 TYR   162       4.321  28.152  38.497  1.00 32.51           C  
ATOM   2259  CD2 TYR   162       3.893  26.901  38.083  1.00 31.20           C  
ATOM   2261  C   TYR   162       1.658  26.061  36.018  1.00 28.23           C  
ATOM   2262  O   TYR   162       2.606  25.766  35.303  1.00 27.90           O  
ATOM   2264  N   ARG   163       0.938  27.177  35.868  1.00 27.90           N  
ATOM   2265  CA  ARG   163       1.139  28.134  34.763  1.00 27.84           C  
ATOM   2267  CB  ARG   163       2.396  28.962  35.001  1.00 27.51           C  
ATOM   2270  CG  ARG   163       2.350  29.744  36.287  1.00 28.30           C  
ATOM   2273  CD  ARG   163       3.691  30.412  36.611  1.00 28.58           C  
ATOM   2276  NE  ARG   163       3.973  31.592  35.798  1.00 29.09           N  
ATOM   2278  CZ  ARG   163       5.109  32.290  35.861  1.00 29.67           C  
ATOM   2279  NH1 ARG   163       6.078  31.937  36.710  1.00 30.17           N  
ATOM   2282  NH2 ARG   163       5.285  33.355  35.082  1.00 29.92           N  
ATOM   2285  C   ARG   163       1.174  27.499  33.350  1.00 27.71           C  
ATOM   2286  O   ARG   163       1.954  27.913  32.497  1.00 27.28           O  
ATOM   2288  N   ALA   164       0.302  26.517  33.113  1.00 27.57           N  
ATOM   2289  CA  ALA   164       0.159  25.891  31.798  1.00 27.60           C  
ATOM   2291  CB  ALA   164      -1.012  24.920  31.791  1.00 27.29           C  
ATOM   2295  C   ALA   164      -0.012  26.895  30.656  1.00 27.60           C  
ATOM   2296  O   ALA   164       0.579  26.704  29.599  1.00 27.70           O  
ATOM   2298  N   GLU   165      -0.800  27.951  30.862  1.00 27.39           N  
ATOM   2299  CA  GLU   165      -1.129  28.868  29.776  1.00 27.48           C  
ATOM   2301  CB  GLU   165      -2.048  29.961  30.262  1.00 27.81           C  
ATOM   2304  CG  GLU   165      -3.485  29.532  30.421  1.00 28.47           C  
ATOM   2307  CD  GLU   165      -4.392  30.708  30.786  1.00 30.58           C  
ATOM   2308  OE1 GLU   165      -4.442  31.711  30.023  1.00 30.66           O  
ATOM   2309  OE2 GLU   165      -5.060  30.633  31.849  1.00 32.43           O  
ATOM   2310  C   GLU   165       0.095  29.506  29.147  1.00 27.46           C  
ATOM   2311  O   GLU   165       0.268  29.497  27.928  1.00 27.18           O  
ATOM   2313  N   GLU   166       0.952  30.060  29.986  1.00 27.59           N  
ATOM   2314  CA  GLU   166       2.217  30.598  29.507  1.00 27.66           C  
ATOM   2316  CB  GLU   166       2.961  31.263  30.642  1.00 27.89           C  
ATOM   2319  CG  GLU   166       2.239  32.502  31.138  1.00 28.65           C  
ATOM   2322  CD  GLU   166       2.848  33.086  32.398  1.00 29.34           C  
ATOM   2323  OE1 GLU   166       3.360  32.322  33.252  1.00 28.90           O  
ATOM   2324  OE2 GLU   166       2.794  34.329  32.526  1.00 30.57           O  
ATOM   2325  C   GLU   166       3.097  29.544  28.876  1.00 27.37           C  
ATOM   2326  O   GLU   166       3.672  29.780  27.827  1.00 27.66           O  
ATOM   2328  N   ALA   167       3.185  28.376  29.498  1.00 27.20           N  
ATOM   2329  CA  ALA   167       3.951  27.277  28.926  1.00 26.97           C  
ATOM   2331  CB  ALA   167       3.988  26.105  29.869  1.00 26.83           C  
ATOM   2335  C   ALA   167       3.441  26.861  27.541  1.00 26.95           C  
ATOM   2336  O   ALA   167       4.225  26.686  26.627  1.00 27.07           O  
ATOM   2338  N   VAL   168       2.146  26.697  27.351  1.00 27.13           N  
ATOM   2339  CA  VAL   168       1.671  26.376  25.996  1.00 27.57           C  
ATOM   2341  CB  VAL   168       0.208  25.937  25.964  1.00 27.39           C  
ATOM   2343  CG1 VAL   168       0.085  24.566  26.594  1.00 27.92           C  
ATOM   2347  CG2 VAL   168      -0.663  26.963  26.637  1.00 26.18           C  
ATOM   2351  C   VAL   168       1.852  27.548  25.023  1.00 28.01           C  
ATOM   2352  O   VAL   168       2.143  27.336  23.839  1.00 27.90           O  
ATOM   2354  N   GLU   169       1.711  28.781  25.515  1.00 28.22           N  
ATOM   2355  CA  GLU   169       1.960  29.937  24.661  1.00 28.31           C  
ATOM   2357  CB  GLU   169       1.661  31.238  25.379  1.00 28.19           C  
ATOM   2360  CG  GLU   169       0.934  32.227  24.473  1.00 29.54           C  
ATOM   2363  CD  GLU   169       0.943  33.661  25.021  1.00 31.96           C  
ATOM   2364  OE1 GLU   169       1.714  33.912  26.000  1.00 34.14           O  
ATOM   2365  OE2 GLU   169       0.198  34.544  24.472  1.00 32.15           O  
ATOM   2366  C   GLU   169       3.388  29.963  24.101  1.00 28.30           C  
ATOM   2367  O   GLU   169       3.597  30.326  22.943  1.00 28.98           O  
ATOM   2369  N   MET   170       4.367  29.589  24.914  1.00 28.08           N  
ATOM   2370  CA  MET   170       5.754  29.551  24.453  1.00 28.04           C  
ATOM   2372  CB  MET   170       6.726  29.335  25.622  1.00 27.87           C  
ATOM   2375  CG  MET   170       7.074  30.615  26.367  1.00 28.33           C  
ATOM   2378  SD  MET   170       8.249  30.471  27.752  1.00 28.55           S  
ATOM   2379  CE  MET   170       7.214  29.683  28.987  1.00 27.96           C  
ATOM   2383  C   MET   170       5.940  28.468  23.400  1.00 28.13           C  
ATOM   2384  O   MET   170       6.505  28.715  22.348  1.00 28.20           O  
ATOM   2386  N   LEU   171       5.473  27.261  23.700  1.00 28.42           N  
ATOM   2387  CA  LEU   171       5.558  26.143  22.769  1.00 28.42           C  
ATOM   2389  CB  LEU   171       4.834  24.913  23.331  1.00 28.74           C  
ATOM   2392  CG  LEU   171       5.614  23.807  24.025  1.00 28.64           C  
ATOM   2394  CD1 LEU   171       4.612  22.730  24.485  1.00 27.77           C  
ATOM   2398  CD2 LEU   171       6.693  23.239  23.103  1.00 28.05           C  
ATOM   2402  C   LEU   171       4.911  26.485  21.439  1.00 28.37           C  
ATOM   2403  O   LEU   171       5.433  26.122  20.377  1.00 28.57           O  
ATOM   2405  N   LYS   172       3.753  27.142  21.499  1.00 28.00           N  
ATOM   2406  CA  LYS   172       3.012  27.463  20.274  1.00 27.85           C  
ATOM   2408  CB  LYS   172       1.593  28.000  20.576  1.00 27.67           C  
ATOM   2411  CG  LYS   172       0.523  26.888  20.684  1.00 27.83           C  
ATOM   2414  CD  LYS   172      -0.851  27.407  21.176  1.00 28.79           C  
ATOM   2417  CE  LYS   172      -1.973  26.373  20.896  1.00 29.34           C  
ATOM   2420  NZ  LYS   172      -2.428  26.347  19.368  1.00 29.31           N  
ATOM   2424  C   LYS   172       3.815  28.432  19.425  1.00 27.32           C  
ATOM   2425  O   LYS   172       3.942  28.266  18.218  1.00 27.26           O  
ATOM   2427  N   THR   173       4.380  29.432  20.074  1.00 27.30           N  
ATOM   2428  CA  THR   173       5.135  30.429  19.362  1.00 27.36           C  
ATOM   2430  CB  THR   173       5.501  31.639  20.254  1.00 26.82           C  
ATOM   2432  OG1 THR   173       6.315  32.503  19.498  1.00 28.03           O  
ATOM   2434  CG2 THR   173       6.295  31.285  21.426  1.00 26.84           C  
ATOM   2438  C   THR   173       6.353  29.769  18.728  1.00 27.39           C  
ATOM   2439  O   THR   173       6.729  30.102  17.611  1.00 27.65           O  
ATOM   2441  N   PHE   174       6.925  28.799  19.429  1.00 27.67           N  
ATOM   2442  CA  PHE   174       8.075  28.052  18.934  1.00 27.96           C  
ATOM   2444  CB  PHE   174       8.691  27.157  20.029  1.00 28.11           C  
ATOM   2447  CG  PHE   174       9.701  26.141  19.491  1.00 27.94           C  
ATOM   2448  CD1 PHE   174      11.002  26.527  19.174  1.00 26.47           C  
ATOM   2450  CE1 PHE   174      11.911  25.605  18.678  1.00 26.06           C  
ATOM   2452  CZ  PHE   174      11.523  24.288  18.477  1.00 25.76           C  
ATOM   2454  CE2 PHE   174      10.242  23.892  18.780  1.00 26.66           C  
ATOM   2456  CD2 PHE   174       9.334  24.807  19.287  1.00 27.84           C  
ATOM   2458  C   PHE   174       7.766  27.179  17.721  1.00 28.18           C  
ATOM   2459  O   PHE   174       8.631  27.024  16.863  1.00 28.86           O  
ATOM   2461  N   TYR   175       6.575  26.582  17.646  1.00 28.31           N  
ATOM   2462  CA  TYR   175       6.244  25.756  16.479  1.00 28.37           C  
ATOM   2464  CB  TYR   175       5.120  24.775  16.797  1.00 28.20           C  
ATOM   2467  CG  TYR   175       5.549  23.642  17.687  1.00 29.03           C  
ATOM   2468  CD1 TYR   175       4.708  23.182  18.704  1.00 29.68           C  
ATOM   2470  CE1 TYR   175       5.092  22.132  19.551  1.00 30.13           C  
ATOM   2472  CZ  TYR   175       6.344  21.524  19.369  1.00 30.83           C  
ATOM   2473  OH  TYR   175       6.716  20.480  20.195  1.00 33.11           O  
ATOM   2475  CE2 TYR   175       7.205  21.961  18.362  1.00 29.36           C  
ATOM   2477  CD2 TYR   175       6.801  23.013  17.521  1.00 29.43           C  
ATOM   2479  C   TYR   175       5.922  26.556  15.211  1.00 28.44           C  
ATOM   2480  O   TYR   175       5.590  25.962  14.192  1.00 28.62           O  
ATOM   2482  N   LYS   176       6.052  27.880  15.254  1.00 28.50           N  
ATOM   2483  CA  LYS   176       6.067  28.676  14.029  1.00 29.01           C  
ATOM   2485  CB  LYS   176       5.261  29.955  14.213  1.00 28.81           C  
ATOM   2488  CG  LYS   176       3.855  29.628  14.728  1.00 29.06           C  
ATOM   2491  CD  LYS   176       3.017  30.883  15.126  1.00 28.97           C  
ATOM   2494  CE  LYS   176       1.805  30.431  16.053  1.00 28.62           C  
ATOM   2497  NZ  LYS   176       0.966  31.639  16.480  1.00 28.07           N  
ATOM   2501  C   LYS   176       7.516  28.924  13.596  1.00 29.73           C  
ATOM   2502  O   LYS   176       8.033  30.071  13.612  1.00 29.38           O  
ATOM   2504  N   GLN   177       8.151  27.782  13.243  1.00 30.84           N  
ATOM   2505  CA  GLN   177       9.491  27.720  12.613  1.00 31.22           C  
ATOM   2507  CB  GLN   177      10.615  28.236  13.553  1.00 31.62           C  
ATOM   2510  CG  GLN   177      12.100  28.010  13.035  1.00 32.08           C  
ATOM   2513  CD  GLN   177      12.575  29.029  11.958  1.00 32.52           C  
ATOM   2514  OE1 GLN   177      12.497  30.261  12.160  1.00 31.81           O  
ATOM   2515  NE2 GLN   177      13.111  28.498  10.831  1.00 31.77           N  
ATOM   2518  C   GLN   177       9.731  26.249  12.215  1.00 30.80           C  
ATOM   2519  O   GLN   177       9.033  25.353  12.722  1.00 29.50           O  
END
