
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   68 (  993),  selected   68 , name 1wi7_A
# Molecule2: number of CA atoms   67 ( 1113),  selected   67 , name T0462_77_143.pdb
# PARAMETERS: 1wi7_A.T0462_77_143.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E      77           -
LGA    S     2_A      L      78           -
LGA    S     3_A      P      79           -
LGA    G     4_A      L      80           -
LGA    S     5_A      I      81           -
LGA    S     6_A      L      82           -
LGA    G     7_A      A      83           -
LGA    -       -      D      84           -
LGA    R     8_A      D      85          2.844
LGA    R     9_A      G      86          3.508
LGA    -       -      T      87           -
LGA    C    10_A      Y      88          2.169
LGA    Q    11_A      E      89          1.736
LGA    V    12_A      I      90          1.201
LGA    A    13_A      T      91          1.660
LGA    F    14_A      K      92          2.293
LGA    S    15_A      L      93          5.322
LGA    -       -      N      94           -
LGA    -       -      G      95           -
LGA    -       -      G      96           -
LGA    -       -      R      97           -
LGA    -       -      R      98           -
LGA    -       -      F      99           -
LGA    Y    16_A      L     100          3.718
LGA    L    17_A      F     101          3.008
LGA    P    18_A      R     102          1.978
LGA    Q    19_A      M     103           -
LGA    N    20_A      K     104           -
LGA    D    21_A      N     105           -
LGA    D    22_A      -       -           -
LGA    E    23_A      -       -           -
LGA    L    24_A      L     106          2.829
LGA    E    25_A      G     107          2.654
LGA    L    26_A      I     108          1.381
LGA    K    27_A      E     109          1.467
LGA    V    28_A      S     110          1.863
LGA    G    29_A      G     111          0.786
LGA    D    30_A      K     112          1.012
LGA    I    31_A      K     113          1.615
LGA    I    32_A      I     114          1.084
LGA    E    33_A      Q     115          0.526
LGA    V    34_A      V     116          0.837
LGA    V    35_A      S     117          1.179
LGA    G    36_A      G     118          1.429
LGA    E    37_A      R     119          1.935
LGA    V    38_A      -       -           -
LGA    E    39_A      -       -           -
LGA    E    40_A      -       -           -
LGA    G    41_A      -       -           -
LGA    W    42_A      -       -           -
LGA    W    43_A      -       -           -
LGA    E    44_A      R     120          1.352
LGA    G    45_A      Y     121          1.023
LGA    V    46_A      Y     122          0.769
LGA    L    47_A      I     123          0.670
LGA    N    48_A      E     124          1.143
LGA    G    49_A      G     125          1.159
LGA    K    50_A      R     126          0.663
LGA    T    51_A      E     127          0.677
LGA    G    52_A      I     128          1.854
LGA    M    53_A      D     129          1.797
LGA    F    54_A      L     130          2.945
LGA    -       -      G     131           -
LGA    -       -      Y     132           -
LGA    -       -      G     133           -
LGA    P    55_A      E     134          3.418
LGA    S    56_A      A     135          2.907
LGA    N    57_A      T     136          2.548
LGA    -       -      K     137           -
LGA    F    58_A      I     138          1.702
LGA    I    59_A      W     139          1.560
LGA    K    60_A      V     140          2.208
LGA    E    61_A      R     141          4.045
LGA    L    62_A      R     142          1.164
LGA    S    63_A      V     143           #
LGA    G    64_A      -       -           -
LGA    P    65_A      -       -           -
LGA    S    66_A      -       -           -
LGA    S    67_A      -       -           -
LGA    G    68_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   68   67    5.0     44    2.16    13.64     54.746     1.943

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.227176 * X  +  -0.896019 * Y  +   0.381498 * Z  + -13.551828
  Y_new =   0.973773 * X  +   0.214063 * Y  +  -0.077099 * Z  +  -3.089091
  Z_new =  -0.012583 * X  +   0.389007 * Y  +   0.921149 * Z  +   1.441623 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.399587   -2.742005  [ DEG:    22.8947   -157.1053 ]
  Theta =   0.012583    3.129009  [ DEG:     0.7210    179.2790 ]
  Phi   =   1.341601   -1.799991  [ DEG:    76.8681   -103.1319 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wi7_A                                        
REMARK     2: T0462_77_143.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wi7_A.T0462_77_143.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   68   67   5.0   44   2.16   13.64  54.746
REMARK  ---------------------------------------------------------- 
MOLECULE 1wi7_A
HEADER    PROTEIN BINDING                         28-MAY-04   1WI7              
TITLE     SOLUTION STRUCTURE OF THE SH3 DOMAIN OF SH3-DOMAIN KINASE             
TITLE    2 BINDING PROTEIN 1                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SH3-DOMAIN KINASE BINDING PROTEIN 1;                       
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: SH3 DOMAIN;                                                
COMPND   5 SYNONYM: SH3 CONTAINING, EXPRESSED IN TUMORIGENIC                    
COMPND   6 ASTROCYTES, REGULATOR OF UBIQUITOUS KINASE, RUK;                     
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: RIKEN CDNA 5830464D22;                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P030128-04;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    BETA BARREL, SH3KBP1, RUK, STRUCTURAL GENOMICS, RIKEN                 
KEYWDS   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.INOUE,F.HAYASHI,S.YOKOYAMA,RIKEN STRUCTURAL                         
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   14-JUN-05 1WI7    0                                                
JRNL        AUTH   K.INOUE,F.HAYASHI,S.YOKOYAMA                                 
JRNL        TITL   SOLUTION STRUCTURE OF THE SH3 DOMAIN OF SH3-DOMAIN           
JRNL        TITL 2 KINASE BINDING PROTEIN 1                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WI7 A    8    62  UNP    Q8R550   SH3K1_MOUSE    101    155             
SEQRES   1 A   68  GLY SER SER GLY SER SER GLY ARG ARG CYS GLN VAL ALA          
SEQRES   2 A   68  PHE SER TYR LEU PRO GLN ASN ASP ASP GLU LEU GLU LEU          
SEQRES   3 A   68  LYS VAL GLY ASP ILE ILE GLU VAL VAL GLY GLU VAL GLU          
SEQRES   4 A   68  GLU GLY TRP TRP GLU GLY VAL LEU ASN GLY LYS THR GLY          
SEQRES   5 A   68  MET PHE PRO SER ASN PHE ILE LYS GLU LEU SER GLY PRO          
SEQRES   6 A   68  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1       4.627 -27.307  -7.369  1.00  0.00           N  
ATOM      2  CA  GLY A   1       4.251 -26.242  -6.456  1.00  0.00           C  
ATOM      3  C   GLY A   1       3.170 -25.350  -7.069  1.00  0.00           C  
ATOM      4  O   GLY A   1       3.457 -24.531  -7.941  1.00  0.00           O  
ATOM      5  HA2 GLY A   1       3.888 -26.670  -5.522  1.00  0.00           H  
ATOM      6  HA3 GLY A   1       5.128 -25.641  -6.212  1.00  0.00           H  
ATOM      7  H1  GLY A   1       5.255 -27.037  -8.099  1.00  0.00           H  
ATOM      8  N   SER A   2       1.949 -25.537  -6.588  1.00  0.00           N  
ATOM      9  CA  SER A   2       0.824 -24.760  -7.077  1.00  0.00           C  
ATOM     10  C   SER A   2      -0.175 -24.516  -5.946  1.00  0.00           C  
ATOM     11  O   SER A   2      -0.403 -25.394  -5.114  1.00  0.00           O  
ATOM     12  CB  SER A   2       0.137 -25.464  -8.250  1.00  0.00           C  
ATOM     13  OG  SER A   2      -0.287 -26.780  -7.908  1.00  0.00           O  
ATOM     14  H   SER A   2       1.725 -26.205  -5.878  1.00  0.00           H  
ATOM     15  HA  SER A   2       1.252 -23.817  -7.420  1.00  0.00           H  
ATOM     16  HB2 SER A   2      -0.725 -24.877  -8.570  1.00  0.00           H  
ATOM     17  HB3 SER A   2       0.823 -25.511  -9.096  1.00  0.00           H  
ATOM     18  HG  SER A   2       0.448 -27.263  -7.433  1.00  0.00           H  
ATOM     19  N   SER A   3      -0.745 -23.319  -5.950  1.00  0.00           N  
ATOM     20  CA  SER A   3      -1.715 -22.949  -4.933  1.00  0.00           C  
ATOM     21  C   SER A   3      -2.822 -22.094  -5.552  1.00  0.00           C  
ATOM     22  O   SER A   3      -2.668 -21.581  -6.660  1.00  0.00           O  
ATOM     23  CB  SER A   3      -1.045 -22.196  -3.782  1.00  0.00           C  
ATOM     24  OG  SER A   3      -1.009 -22.972  -2.586  1.00  0.00           O  
ATOM     25  H   SER A   3      -0.554 -22.611  -6.630  1.00  0.00           H  
ATOM     26  HA  SER A   3      -2.120 -23.891  -4.564  1.00  0.00           H  
ATOM     27  HB2 SER A   3      -0.030 -21.924  -4.068  1.00  0.00           H  
ATOM     28  HB3 SER A   3      -1.583 -21.267  -3.594  1.00  0.00           H  
ATOM     29  HG  SER A   3      -0.310 -23.682  -2.660  1.00  0.00           H  
ATOM     30  N   GLY A   4      -3.914 -21.968  -4.812  1.00  0.00           N  
ATOM     31  CA  GLY A   4      -5.046 -21.184  -5.276  1.00  0.00           C  
ATOM     32  C   GLY A   4      -5.332 -20.020  -4.326  1.00  0.00           C  
ATOM     33  O   GLY A   4      -5.874 -20.218  -3.240  1.00  0.00           O  
ATOM     34  H   GLY A   4      -4.030 -22.390  -3.913  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      -4.843 -20.802  -6.276  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      -5.927 -21.822  -5.351  1.00  0.00           H  
ATOM     37  N   SER A   5      -4.955 -18.830  -4.770  1.00  0.00           N  
ATOM     38  CA  SER A   5      -5.163 -17.633  -3.973  1.00  0.00           C  
ATOM     39  C   SER A   5      -6.394 -16.877  -4.477  1.00  0.00           C  
ATOM     40  O   SER A   5      -6.450 -16.478  -5.638  1.00  0.00           O  
ATOM     41  CB  SER A   5      -3.932 -16.726  -4.009  1.00  0.00           C  
ATOM     42  OG  SER A   5      -3.652 -16.259  -5.325  1.00  0.00           O  
ATOM     43  H   SER A   5      -4.513 -18.678  -5.654  1.00  0.00           H  
ATOM     44  HA  SER A   5      -5.323 -17.989  -2.954  1.00  0.00           H  
ATOM     45  HB2 SER A   5      -4.091 -15.873  -3.348  1.00  0.00           H  
ATOM     46  HB3 SER A   5      -3.070 -17.270  -3.625  1.00  0.00           H  
ATOM     47  HG  SER A   5      -2.739 -15.850  -5.356  1.00  0.00           H  
ATOM     48  N   SER A   6      -7.352 -16.705  -3.577  1.00  0.00           N  
ATOM     49  CA  SER A   6      -8.579 -16.004  -3.916  1.00  0.00           C  
ATOM     50  C   SER A   6      -9.415 -15.774  -2.654  1.00  0.00           C  
ATOM     51  O   SER A   6      -9.785 -16.726  -1.969  1.00  0.00           O  
ATOM     52  CB  SER A   6      -9.388 -16.783  -4.955  1.00  0.00           C  
ATOM     53  OG  SER A   6      -9.545 -16.050  -6.167  1.00  0.00           O  
ATOM     54  H   SER A   6      -7.299 -17.034  -2.634  1.00  0.00           H  
ATOM     55  HA  SER A   6      -8.260 -15.053  -4.341  1.00  0.00           H  
ATOM     56  HB2 SER A   6      -8.893 -17.731  -5.164  1.00  0.00           H  
ATOM     57  HB3 SER A   6     -10.371 -17.019  -4.546  1.00  0.00           H  
ATOM     58  HG  SER A   6     -10.415 -15.558  -6.161  1.00  0.00           H  
ATOM     59  N   GLY A   7      -9.689 -14.505  -2.388  1.00  0.00           N  
ATOM     60  CA  GLY A   7     -10.474 -14.139  -1.222  1.00  0.00           C  
ATOM     61  C   GLY A   7      -9.625 -13.368  -0.209  1.00  0.00           C  
ATOM     62  O   GLY A   7      -8.729 -13.934   0.415  1.00  0.00           O  
ATOM     63  H   GLY A   7      -9.384 -13.738  -2.951  1.00  0.00           H  
ATOM     64  HA2 GLY A   7     -11.323 -13.529  -1.529  1.00  0.00           H  
ATOM     65  HA3 GLY A   7     -10.879 -15.036  -0.754  1.00  0.00           H  
ATOM     66  N   ARG A   8      -9.936 -12.087  -0.078  1.00  0.00           N  
ATOM     67  CA  ARG A   8      -9.213 -11.232   0.848  1.00  0.00           C  
ATOM     68  C   ARG A   8     -10.191 -10.503   1.772  1.00  0.00           C  
ATOM     69  O   ARG A   8     -11.329 -10.233   1.388  1.00  0.00           O  
ATOM     70  CB  ARG A   8      -8.365 -10.201   0.100  1.00  0.00           C  
ATOM     71  CG  ARG A   8      -6.958 -10.741  -0.171  1.00  0.00           C  
ATOM     72  CD  ARG A   8      -5.893  -9.724   0.244  1.00  0.00           C  
ATOM     73  NE  ARG A   8      -4.674 -10.428   0.700  1.00  0.00           N  
ATOM     74  CZ  ARG A   8      -3.568  -9.809   1.137  1.00  0.00           C  
ATOM     75  NH1 ARG A   8      -3.522  -8.470   1.177  1.00  0.00           N  
ATOM     76  NH2 ARG A   8      -2.509 -10.529   1.531  1.00  0.00           N  
ATOM     77  H   ARG A   8     -10.666 -11.632  -0.590  1.00  0.00           H  
ATOM     78  HA  ARG A   8      -8.573 -11.910   1.412  1.00  0.00           H  
ATOM     79  HB2 ARG A   8      -8.847  -9.944  -0.844  1.00  0.00           H  
ATOM     80  HB3 ARG A   8      -8.301  -9.284   0.684  1.00  0.00           H  
ATOM     81  HG2 ARG A   8      -6.812 -11.672   0.377  1.00  0.00           H  
ATOM     82  HG3 ARG A   8      -6.853 -10.973  -1.231  1.00  0.00           H  
ATOM     83  HD2 ARG A   8      -5.653  -9.073  -0.597  1.00  0.00           H  
ATOM     84  HD3 ARG A   8      -6.276  -9.088   1.042  1.00  0.00           H  
ATOM     85  HE  ARG A   8      -4.675 -11.428   0.683  1.00  0.00           H  
ATOM     86 HH11 ARG A   8      -4.311  -7.933   0.883  1.00  0.00           H  
ATOM     87 HH12 ARG A   8      -2.696  -8.008   1.503  1.00  0.00           H  
ATOM     88 HH21 ARG A   8      -2.543 -11.528   1.501  1.00  0.00           H  
ATOM     89 HH22 ARG A   8      -1.684 -10.067   1.857  1.00  0.00           H  
ATOM     90  N   ARG A   9      -9.712 -10.204   2.971  1.00  0.00           N  
ATOM     91  CA  ARG A   9     -10.530  -9.511   3.952  1.00  0.00           C  
ATOM     92  C   ARG A   9      -9.813  -8.254   4.448  1.00  0.00           C  
ATOM     93  O   ARG A   9      -8.590  -8.246   4.585  1.00  0.00           O  
ATOM     94  CB  ARG A   9     -10.843 -10.417   5.145  1.00  0.00           C  
ATOM     95  CG  ARG A   9     -12.268 -10.967   5.057  1.00  0.00           C  
ATOM     96  CD  ARG A   9     -12.582 -11.872   6.250  1.00  0.00           C  
ATOM     97  NE  ARG A   9     -13.572 -12.900   5.858  1.00  0.00           N  
ATOM     98  CZ  ARG A   9     -13.732 -14.068   6.494  1.00  0.00           C  
ATOM     99  NH1 ARG A   9     -12.970 -14.365   7.555  1.00  0.00           N  
ATOM    100  NH2 ARG A   9     -14.657 -14.941   6.069  1.00  0.00           N  
ATOM    101  H   ARG A   9      -8.786 -10.427   3.274  1.00  0.00           H  
ATOM    102  HA  ARG A   9     -11.446  -9.256   3.420  1.00  0.00           H  
ATOM    103  HB2 ARG A   9     -10.132 -11.243   5.176  1.00  0.00           H  
ATOM    104  HB3 ARG A   9     -10.722  -9.857   6.072  1.00  0.00           H  
ATOM    105  HG2 ARG A   9     -12.979 -10.141   5.026  1.00  0.00           H  
ATOM    106  HG3 ARG A   9     -12.389 -11.526   4.130  1.00  0.00           H  
ATOM    107  HD2 ARG A   9     -11.668 -12.351   6.603  1.00  0.00           H  
ATOM    108  HD3 ARG A   9     -12.969 -11.277   7.076  1.00  0.00           H  
ATOM    109  HE  ARG A   9     -14.158 -12.710   5.070  1.00  0.00           H  
ATOM    110 HH11 ARG A   9     -12.280 -13.714   7.872  1.00  0.00           H  
ATOM    111 HH12 ARG A   9     -13.090 -15.237   8.029  1.00  0.00           H  
ATOM    112 HH21 ARG A   9     -15.226 -14.719   5.277  1.00  0.00           H  
ATOM    113 HH22 ARG A   9     -14.777 -15.813   6.543  1.00  0.00           H  
ATOM    114  N   CYS A  10     -10.604  -7.223   4.705  1.00  0.00           N  
ATOM    115  CA  CYS A  10     -10.059  -5.964   5.184  1.00  0.00           C  
ATOM    116  C   CYS A  10     -11.102  -5.302   6.088  1.00  0.00           C  
ATOM    117  O   CYS A  10     -12.303  -5.423   5.848  1.00  0.00           O  
ATOM    118  CB  CYS A  10      -9.646  -5.050   4.027  1.00  0.00           C  
ATOM    119  SG  CYS A  10      -8.849  -6.036   2.706  1.00  0.00           S  
ATOM    120  H   CYS A  10     -11.597  -7.238   4.591  1.00  0.00           H  
ATOM    121  HA  CYS A  10      -9.157  -6.206   5.745  1.00  0.00           H  
ATOM    122  HB2 CYS A  10     -10.520  -4.534   3.630  1.00  0.00           H  
ATOM    123  HB3 CYS A  10      -8.958  -4.285   4.386  1.00  0.00           H  
ATOM    124  HG  CYS A  10      -8.057  -5.062   2.266  1.00  0.00           H  
ATOM    125  N   GLN A  11     -10.605  -4.619   7.108  1.00  0.00           N  
ATOM    126  CA  GLN A  11     -11.478  -3.939   8.050  1.00  0.00           C  
ATOM    127  C   GLN A  11     -11.578  -2.453   7.701  1.00  0.00           C  
ATOM    128  O   GLN A  11     -10.569  -1.807   7.423  1.00  0.00           O  
ATOM    129  CB  GLN A  11     -10.993  -4.134   9.487  1.00  0.00           C  
ATOM    130  CG  GLN A  11     -12.144  -3.971  10.481  1.00  0.00           C  
ATOM    131  CD  GLN A  11     -11.846  -4.707  11.790  1.00  0.00           C  
ATOM    132  OE1 GLN A  11     -10.707  -4.858  12.201  1.00  0.00           O  
ATOM    133  NE2 GLN A  11     -12.930  -5.152  12.419  1.00  0.00           N  
ATOM    134  H   GLN A  11      -9.627  -4.527   7.296  1.00  0.00           H  
ATOM    135  HA  GLN A  11     -12.453  -4.413   7.934  1.00  0.00           H  
ATOM    136  HB2 GLN A  11     -10.551  -5.125   9.595  1.00  0.00           H  
ATOM    137  HB3 GLN A  11     -10.209  -3.410   9.712  1.00  0.00           H  
ATOM    138  HG2 GLN A  11     -12.307  -2.914  10.684  1.00  0.00           H  
ATOM    139  HG3 GLN A  11     -13.065  -4.359  10.044  1.00  0.00           H  
ATOM    140 HE21 GLN A  11     -13.836  -4.994  12.027  1.00  0.00           H  
ATOM    141 HE22 GLN A  11     -12.838  -5.646  13.284  1.00  0.00           H  
ATOM    142  N   VAL A  12     -12.806  -1.954   7.728  1.00  0.00           N  
ATOM    143  CA  VAL A  12     -13.051  -0.555   7.418  1.00  0.00           C  
ATOM    144  C   VAL A  12     -12.627   0.308   8.609  1.00  0.00           C  
ATOM    145  O   VAL A  12     -13.157   0.158   9.708  1.00  0.00           O  
ATOM    146  CB  VAL A  12     -14.517  -0.355   7.027  1.00  0.00           C  
ATOM    147  CG1 VAL A  12     -14.885   1.130   7.020  1.00  0.00           C  
ATOM    148  CG2 VAL A  12     -14.814  -1.000   5.672  1.00  0.00           C  
ATOM    149  H   VAL A  12     -13.621  -2.486   7.955  1.00  0.00           H  
ATOM    150  HA  VAL A  12     -12.434  -0.295   6.559  1.00  0.00           H  
ATOM    151  HB  VAL A  12     -15.134  -0.850   7.776  1.00  0.00           H  
ATOM    152 HG11 VAL A  12     -15.964   1.235   6.916  1.00  0.00           H  
ATOM    153 HG12 VAL A  12     -14.565   1.588   7.956  1.00  0.00           H  
ATOM    154 HG13 VAL A  12     -14.389   1.623   6.185  1.00  0.00           H  
ATOM    155 HG21 VAL A  12     -13.942  -1.561   5.336  1.00  0.00           H  
ATOM    156 HG22 VAL A  12     -15.665  -1.674   5.769  1.00  0.00           H  
ATOM    157 HG23 VAL A  12     -15.050  -0.224   4.944  1.00  0.00           H  
ATOM    158  N   ALA A  13     -11.677   1.193   8.348  1.00  0.00           N  
ATOM    159  CA  ALA A  13     -11.175   2.081   9.384  1.00  0.00           C  
ATOM    160  C   ALA A  13     -11.957   3.395   9.345  1.00  0.00           C  
ATOM    161  O   ALA A  13     -11.974   4.140  10.323  1.00  0.00           O  
ATOM    162  CB  ALA A  13      -9.672   2.291   9.194  1.00  0.00           C  
ATOM    163  H   ALA A  13     -11.251   1.309   7.451  1.00  0.00           H  
ATOM    164  HA  ALA A  13     -11.343   1.595  10.345  1.00  0.00           H  
ATOM    165  HB1 ALA A  13      -9.295   2.945   9.978  1.00  0.00           H  
ATOM    166  HB2 ALA A  13      -9.162   1.330   9.245  1.00  0.00           H  
ATOM    167  HB3 ALA A  13      -9.490   2.747   8.221  1.00  0.00           H  
ATOM    168  N   PHE A  14     -12.587   3.639   8.206  1.00  0.00           N  
ATOM    169  CA  PHE A  14     -13.369   4.851   8.027  1.00  0.00           C  
ATOM    170  C   PHE A  14     -14.692   4.550   7.319  1.00  0.00           C  
ATOM    171  O   PHE A  14     -14.705   3.930   6.257  1.00  0.00           O  
ATOM    172  CB  PHE A  14     -12.539   5.794   7.153  1.00  0.00           C  
ATOM    173  CG  PHE A  14     -11.087   5.944   7.607  1.00  0.00           C  
ATOM    174  CD1 PHE A  14     -10.195   4.943   7.377  1.00  0.00           C  
ATOM    175  CD2 PHE A  14     -10.685   7.080   8.238  1.00  0.00           C  
ATOM    176  CE1 PHE A  14      -8.846   5.082   7.797  1.00  0.00           C  
ATOM    177  CE2 PHE A  14      -9.335   7.220   8.658  1.00  0.00           C  
ATOM    178  CZ  PHE A  14      -8.445   6.219   8.429  1.00  0.00           C  
ATOM    179  H   PHE A  14     -12.569   3.027   7.414  1.00  0.00           H  
ATOM    180  HA  PHE A  14     -13.573   5.253   9.020  1.00  0.00           H  
ATOM    181  HB2 PHE A  14     -12.553   5.427   6.127  1.00  0.00           H  
ATOM    182  HB3 PHE A  14     -13.011   6.776   7.148  1.00  0.00           H  
ATOM    183  HD1 PHE A  14     -10.517   4.033   6.871  1.00  0.00           H  
ATOM    184  HD2 PHE A  14     -11.399   7.883   8.421  1.00  0.00           H  
ATOM    185  HE1 PHE A  14      -8.132   4.280   7.615  1.00  0.00           H  
ATOM    186  HE2 PHE A  14      -9.014   8.131   9.164  1.00  0.00           H  
ATOM    187  HZ  PHE A  14      -7.409   6.325   8.751  1.00  0.00           H  
ATOM    188  N   SER A  15     -15.773   5.003   7.936  1.00  0.00           N  
ATOM    189  CA  SER A  15     -17.098   4.791   7.378  1.00  0.00           C  
ATOM    190  C   SER A  15     -17.274   5.633   6.114  1.00  0.00           C  
ATOM    191  O   SER A  15     -16.851   6.788   6.068  1.00  0.00           O  
ATOM    192  CB  SER A  15     -18.186   5.131   8.399  1.00  0.00           C  
ATOM    193  OG  SER A  15     -17.985   4.456   9.638  1.00  0.00           O  
ATOM    194  H   SER A  15     -15.754   5.507   8.800  1.00  0.00           H  
ATOM    195  HA  SER A  15     -17.143   3.728   7.140  1.00  0.00           H  
ATOM    196  HB2 SER A  15     -18.199   6.207   8.570  1.00  0.00           H  
ATOM    197  HB3 SER A  15     -19.161   4.861   7.993  1.00  0.00           H  
ATOM    198  HG  SER A  15     -17.723   5.112  10.346  1.00  0.00           H  
ATOM    199  N   TYR A  16     -17.901   5.024   5.118  1.00  0.00           N  
ATOM    200  CA  TYR A  16     -18.139   5.704   3.856  1.00  0.00           C  
ATOM    201  C   TYR A  16     -19.583   5.507   3.391  1.00  0.00           C  
ATOM    202  O   TYR A  16     -20.055   4.376   3.278  1.00  0.00           O  
ATOM    203  CB  TYR A  16     -17.196   5.053   2.842  1.00  0.00           C  
ATOM    204  CG  TYR A  16     -17.433   5.498   1.398  1.00  0.00           C  
ATOM    205  CD1 TYR A  16     -18.373   4.851   0.621  1.00  0.00           C  
ATOM    206  CD2 TYR A  16     -16.707   6.547   0.870  1.00  0.00           C  
ATOM    207  CE1 TYR A  16     -18.596   5.270  -0.738  1.00  0.00           C  
ATOM    208  CE2 TYR A  16     -16.930   6.966  -0.489  1.00  0.00           C  
ATOM    209  CZ  TYR A  16     -17.864   6.306  -1.226  1.00  0.00           C  
ATOM    210  OH  TYR A  16     -18.073   6.702  -2.510  1.00  0.00           O  
ATOM    211  H   TYR A  16     -18.243   4.086   5.163  1.00  0.00           H  
ATOM    212  HA  TYR A  16     -17.956   6.768   4.007  1.00  0.00           H  
ATOM    213  HB2 TYR A  16     -16.167   5.284   3.118  1.00  0.00           H  
ATOM    214  HB3 TYR A  16     -17.308   3.971   2.901  1.00  0.00           H  
ATOM    215  HD1 TYR A  16     -18.947   4.023   1.037  1.00  0.00           H  
ATOM    216  HD2 TYR A  16     -15.965   7.059   1.484  1.00  0.00           H  
ATOM    217  HE1 TYR A  16     -19.334   4.767  -1.363  1.00  0.00           H  
ATOM    218  HE2 TYR A  16     -16.364   7.792  -0.918  1.00  0.00           H  
ATOM    219  HH  TYR A  16     -17.276   7.200  -2.850  1.00  0.00           H  
ATOM    220  N   LEU A  17     -20.246   6.625   3.134  1.00  0.00           N  
ATOM    221  CA  LEU A  17     -21.627   6.590   2.684  1.00  0.00           C  
ATOM    222  C   LEU A  17     -21.662   6.622   1.155  1.00  0.00           C  
ATOM    223  O   LEU A  17     -21.059   7.498   0.535  1.00  0.00           O  
ATOM    224  CB  LEU A  17     -22.435   7.712   3.341  1.00  0.00           C  
ATOM    225  CG  LEU A  17     -22.561   7.643   4.865  1.00  0.00           C  
ATOM    226  CD1 LEU A  17     -23.585   6.586   5.283  1.00  0.00           C  
ATOM    227  CD2 LEU A  17     -21.196   7.410   5.518  1.00  0.00           C  
ATOM    228  H   LEU A  17     -19.856   7.541   3.228  1.00  0.00           H  
ATOM    229  HA  LEU A  17     -22.057   5.646   3.019  1.00  0.00           H  
ATOM    230  HB2 LEU A  17     -21.976   8.664   3.076  1.00  0.00           H  
ATOM    231  HB3 LEU A  17     -23.437   7.710   2.912  1.00  0.00           H  
ATOM    232  HG  LEU A  17     -22.927   8.606   5.220  1.00  0.00           H  
ATOM    233 HD11 LEU A  17     -23.465   6.365   6.343  1.00  0.00           H  
ATOM    234 HD12 LEU A  17     -24.591   6.964   5.101  1.00  0.00           H  
ATOM    235 HD13 LEU A  17     -23.427   5.677   4.702  1.00  0.00           H  
ATOM    236 HD21 LEU A  17     -20.462   8.083   5.076  1.00  0.00           H  
ATOM    237 HD22 LEU A  17     -21.269   7.604   6.588  1.00  0.00           H  
ATOM    238 HD23 LEU A  17     -20.887   6.378   5.356  1.00  0.00           H  
ATOM    239  N   PRO A  18     -22.392   5.632   0.575  1.00  0.00           N  
ATOM    240  CA  PRO A  18     -22.513   5.539  -0.870  1.00  0.00           C  
ATOM    241  C   PRO A  18     -23.467   6.607  -1.410  1.00  0.00           C  
ATOM    242  O   PRO A  18     -24.663   6.578  -1.122  1.00  0.00           O  
ATOM    243  CB  PRO A  18     -22.996   4.122  -1.134  1.00  0.00           C  
ATOM    244  CG  PRO A  18     -23.571   3.625   0.183  1.00  0.00           C  
ATOM    245  CD  PRO A  18     -23.119   4.578   1.277  1.00  0.00           C  
ATOM    246  HA  PRO A  18     -21.630   5.716  -1.304  1.00  0.00           H  
ATOM    247  HB2 PRO A  18     -23.750   4.107  -1.920  1.00  0.00           H  
ATOM    248  HB3 PRO A  18     -22.176   3.486  -1.467  1.00  0.00           H  
ATOM    249  HG2 PRO A  18     -24.659   3.588   0.135  1.00  0.00           H  
ATOM    250  HG3 PRO A  18     -23.225   2.613   0.392  1.00  0.00           H  
ATOM    251  HD2 PRO A  18     -23.970   4.983   1.826  1.00  0.00           H  
ATOM    252  HD3 PRO A  18     -22.482   4.075   2.004  1.00  0.00           H  
ATOM    253  N   GLN A  19     -22.903   7.522  -2.184  1.00  0.00           N  
ATOM    254  CA  GLN A  19     -23.688   8.596  -2.766  1.00  0.00           C  
ATOM    255  C   GLN A  19     -24.440   8.095  -4.001  1.00  0.00           C  
ATOM    256  O   GLN A  19     -25.069   8.879  -4.710  1.00  0.00           O  
ATOM    257  CB  GLN A  19     -22.804   9.797  -3.113  1.00  0.00           C  
ATOM    258  CG  GLN A  19     -21.839  10.114  -1.969  1.00  0.00           C  
ATOM    259  CD  GLN A  19     -22.124  11.497  -1.379  1.00  0.00           C  
ATOM    260  OE1 GLN A  19     -21.474  12.480  -1.695  1.00  0.00           O  
ATOM    261  NE2 GLN A  19     -23.129  11.517  -0.509  1.00  0.00           N  
ATOM    262  H   GLN A  19     -21.930   7.537  -2.413  1.00  0.00           H  
ATOM    263  HA  GLN A  19     -24.399   8.888  -1.994  1.00  0.00           H  
ATOM    264  HB2 GLN A  19     -22.241   9.588  -4.022  1.00  0.00           H  
ATOM    265  HB3 GLN A  19     -23.429  10.666  -3.318  1.00  0.00           H  
ATOM    266  HG2 GLN A  19     -21.931   9.357  -1.190  1.00  0.00           H  
ATOM    267  HG3 GLN A  19     -20.812  10.075  -2.333  1.00  0.00           H  
ATOM    268 HE21 GLN A  19     -23.621  10.673  -0.294  1.00  0.00           H  
ATOM    269 HE22 GLN A  19     -23.391  12.376  -0.069  1.00  0.00           H  
ATOM    270  N   ASN A  20     -24.349   6.792  -4.221  1.00  0.00           N  
ATOM    271  CA  ASN A  20     -25.012   6.176  -5.358  1.00  0.00           C  
ATOM    272  C   ASN A  20     -25.604   4.831  -4.931  1.00  0.00           C  
ATOM    273  O   ASN A  20     -25.340   4.355  -3.828  1.00  0.00           O  
ATOM    274  CB  ASN A  20     -24.026   5.918  -6.498  1.00  0.00           C  
ATOM    275  CG  ASN A  20     -23.181   7.162  -6.784  1.00  0.00           C  
ATOM    276  OD1 ASN A  20     -23.451   7.932  -7.691  1.00  0.00           O  
ATOM    277  ND2 ASN A  20     -22.146   7.313  -5.963  1.00  0.00           N  
ATOM    278  H   ASN A  20     -23.835   6.161  -3.640  1.00  0.00           H  
ATOM    279  HA  ASN A  20     -25.777   6.890  -5.664  1.00  0.00           H  
ATOM    280  HB2 ASN A  20     -23.374   5.083  -6.239  1.00  0.00           H  
ATOM    281  HB3 ASN A  20     -24.570   5.630  -7.397  1.00  0.00           H  
ATOM    282 HD21 ASN A  20     -21.980   6.644  -5.238  1.00  0.00           H  
ATOM    283 HD22 ASN A  20     -21.533   8.097  -6.070  1.00  0.00           H  
ATOM    284  N   ASP A  21     -26.393   4.257  -5.827  1.00  0.00           N  
ATOM    285  CA  ASP A  21     -27.024   2.976  -5.557  1.00  0.00           C  
ATOM    286  C   ASP A  21     -26.187   1.858  -6.182  1.00  0.00           C  
ATOM    287  O   ASP A  21     -26.725   0.833  -6.597  1.00  0.00           O  
ATOM    288  CB  ASP A  21     -28.427   2.914  -6.166  1.00  0.00           C  
ATOM    289  CG  ASP A  21     -29.449   2.116  -5.354  1.00  0.00           C  
ATOM    290  OD1 ASP A  21     -29.034   1.544  -4.324  1.00  0.00           O  
ATOM    291  OD2 ASP A  21     -30.623   2.097  -5.783  1.00  0.00           O  
ATOM    292  H   ASP A  21     -26.602   4.651  -6.721  1.00  0.00           H  
ATOM    293  HA  ASP A  21     -27.072   2.904  -4.471  1.00  0.00           H  
ATOM    294  HB2 ASP A  21     -28.797   3.931  -6.291  1.00  0.00           H  
ATOM    295  HB3 ASP A  21     -28.354   2.476  -7.162  1.00  0.00           H  
ATOM    296  N   ASP A  22     -24.884   2.094  -6.230  1.00  0.00           N  
ATOM    297  CA  ASP A  22     -23.968   1.119  -6.796  1.00  0.00           C  
ATOM    298  C   ASP A  22     -22.642   1.169  -6.035  1.00  0.00           C  
ATOM    299  O   ASP A  22     -21.620   0.695  -6.528  1.00  0.00           O  
ATOM    300  CB  ASP A  22     -23.679   1.426  -8.267  1.00  0.00           C  
ATOM    301  CG  ASP A  22     -23.737   0.216  -9.202  1.00  0.00           C  
ATOM    302  OD1 ASP A  22     -24.790  -0.457  -9.196  1.00  0.00           O  
ATOM    303  OD2 ASP A  22     -22.726  -0.008  -9.903  1.00  0.00           O  
ATOM    304  H   ASP A  22     -24.455   2.930  -5.889  1.00  0.00           H  
ATOM    305  HA  ASP A  22     -24.472   0.158  -6.694  1.00  0.00           H  
ATOM    306  HB2 ASP A  22     -24.396   2.169  -8.615  1.00  0.00           H  
ATOM    307  HB3 ASP A  22     -22.690   1.877  -8.342  1.00  0.00           H  
ATOM    308  N   GLU A  23     -22.701   1.747  -4.844  1.00  0.00           N  
ATOM    309  CA  GLU A  23     -21.518   1.865  -4.009  1.00  0.00           C  
ATOM    310  C   GLU A  23     -21.702   1.075  -2.711  1.00  0.00           C  
ATOM    311  O   GLU A  23     -22.808   0.632  -2.402  1.00  0.00           O  
ATOM    312  CB  GLU A  23     -21.196   3.332  -3.717  1.00  0.00           C  
ATOM    313  CG  GLU A  23     -20.267   3.912  -4.785  1.00  0.00           C  
ATOM    314  CD  GLU A  23     -19.241   4.860  -4.162  1.00  0.00           C  
ATOM    315  OE1 GLU A  23     -18.372   4.350  -3.421  1.00  0.00           O  
ATOM    316  OE2 GLU A  23     -19.348   6.075  -4.440  1.00  0.00           O  
ATOM    317  H   GLU A  23     -23.536   2.130  -4.449  1.00  0.00           H  
ATOM    318  HA  GLU A  23     -20.707   1.431  -4.593  1.00  0.00           H  
ATOM    319  HB2 GLU A  23     -22.120   3.909  -3.680  1.00  0.00           H  
ATOM    320  HB3 GLU A  23     -20.728   3.417  -2.737  1.00  0.00           H  
ATOM    321  HG2 GLU A  23     -19.752   3.103  -5.304  1.00  0.00           H  
ATOM    322  HG3 GLU A  23     -20.854   4.446  -5.533  1.00  0.00           H  
ATOM    323  N   LEU A  24     -20.604   0.923  -1.987  1.00  0.00           N  
ATOM    324  CA  LEU A  24     -20.632   0.195  -0.729  1.00  0.00           C  
ATOM    325  C   LEU A  24     -20.621   1.190   0.432  1.00  0.00           C  
ATOM    326  O   LEU A  24     -20.091   2.293   0.304  1.00  0.00           O  
ATOM    327  CB  LEU A  24     -19.492  -0.825  -0.677  1.00  0.00           C  
ATOM    328  CG  LEU A  24     -19.786  -2.193  -1.296  1.00  0.00           C  
ATOM    329  CD1 LEU A  24     -18.697  -3.204  -0.933  1.00  0.00           C  
ATOM    330  CD2 LEU A  24     -21.180  -2.684  -0.902  1.00  0.00           C  
ATOM    331  H   LEU A  24     -19.709   1.286  -2.246  1.00  0.00           H  
ATOM    332  HA  LEU A  24     -21.566  -0.365  -0.697  1.00  0.00           H  
ATOM    333  HB2 LEU A  24     -18.626  -0.398  -1.181  1.00  0.00           H  
ATOM    334  HB3 LEU A  24     -19.212  -0.972   0.367  1.00  0.00           H  
ATOM    335  HG  LEU A  24     -19.777  -2.086  -2.380  1.00  0.00           H  
ATOM    336 HD11 LEU A  24     -18.966  -3.711  -0.006  1.00  0.00           H  
ATOM    337 HD12 LEU A  24     -18.601  -3.937  -1.733  1.00  0.00           H  
ATOM    338 HD13 LEU A  24     -17.748  -2.685  -0.800  1.00  0.00           H  
ATOM    339 HD21 LEU A  24     -21.424  -2.322   0.097  1.00  0.00           H  
ATOM    340 HD22 LEU A  24     -21.913  -2.306  -1.614  1.00  0.00           H  
ATOM    341 HD23 LEU A  24     -21.195  -3.774  -0.908  1.00  0.00           H  
ATOM    342  N   GLU A  25     -21.212   0.766   1.539  1.00  0.00           N  
ATOM    343  CA  GLU A  25     -21.278   1.606   2.722  1.00  0.00           C  
ATOM    344  C   GLU A  25     -20.280   1.120   3.775  1.00  0.00           C  
ATOM    345  O   GLU A  25     -20.550   0.158   4.492  1.00  0.00           O  
ATOM    346  CB  GLU A  25     -22.699   1.645   3.289  1.00  0.00           C  
ATOM    347  CG  GLU A  25     -22.763   2.512   4.548  1.00  0.00           C  
ATOM    348  CD  GLU A  25     -24.149   2.442   5.192  1.00  0.00           C  
ATOM    349  OE1 GLU A  25     -24.556   1.312   5.539  1.00  0.00           O  
ATOM    350  OE2 GLU A  25     -24.769   3.518   5.323  1.00  0.00           O  
ATOM    351  H   GLU A  25     -21.641  -0.132   1.634  1.00  0.00           H  
ATOM    352  HA  GLU A  25     -21.001   2.605   2.384  1.00  0.00           H  
ATOM    353  HB2 GLU A  25     -23.383   2.038   2.538  1.00  0.00           H  
ATOM    354  HB3 GLU A  25     -23.029   0.634   3.523  1.00  0.00           H  
ATOM    355  HG2 GLU A  25     -22.008   2.180   5.261  1.00  0.00           H  
ATOM    356  HG3 GLU A  25     -22.528   3.546   4.295  1.00  0.00           H  
ATOM    357  N   LEU A  26     -19.148   1.806   3.834  1.00  0.00           N  
ATOM    358  CA  LEU A  26     -18.109   1.455   4.786  1.00  0.00           C  
ATOM    359  C   LEU A  26     -18.515   1.941   6.179  1.00  0.00           C  
ATOM    360  O   LEU A  26     -19.051   3.038   6.326  1.00  0.00           O  
ATOM    361  CB  LEU A  26     -16.753   1.989   4.320  1.00  0.00           C  
ATOM    362  CG  LEU A  26     -16.410   1.755   2.848  1.00  0.00           C  
ATOM    363  CD1 LEU A  26     -15.162   2.543   2.444  1.00  0.00           C  
ATOM    364  CD2 LEU A  26     -16.265   0.261   2.551  1.00  0.00           C  
ATOM    365  H   LEU A  26     -18.937   2.587   3.246  1.00  0.00           H  
ATOM    366  HA  LEU A  26     -18.038   0.368   4.807  1.00  0.00           H  
ATOM    367  HB2 LEU A  26     -16.720   3.062   4.514  1.00  0.00           H  
ATOM    368  HB3 LEU A  26     -15.975   1.532   4.932  1.00  0.00           H  
ATOM    369  HG  LEU A  26     -17.236   2.126   2.241  1.00  0.00           H  
ATOM    370 HD11 LEU A  26     -15.443   3.568   2.201  1.00  0.00           H  
ATOM    371 HD12 LEU A  26     -14.451   2.546   3.270  1.00  0.00           H  
ATOM    372 HD13 LEU A  26     -14.703   2.076   1.572  1.00  0.00           H  
ATOM    373 HD21 LEU A  26     -15.268  -0.073   2.836  1.00  0.00           H  
ATOM    374 HD22 LEU A  26     -17.011  -0.296   3.118  1.00  0.00           H  
ATOM    375 HD23 LEU A  26     -16.415   0.087   1.484  1.00  0.00           H  
ATOM    376  N   LYS A  27     -18.246   1.099   7.167  1.00  0.00           N  
ATOM    377  CA  LYS A  27     -18.577   1.429   8.542  1.00  0.00           C  
ATOM    378  C   LYS A  27     -17.471   0.915   9.466  1.00  0.00           C  
ATOM    379  O   LYS A  27     -17.241  -0.291   9.553  1.00  0.00           O  
ATOM    380  CB  LYS A  27     -19.969   0.904   8.899  1.00  0.00           C  
ATOM    381  CG  LYS A  27     -21.015   2.017   8.807  1.00  0.00           C  
ATOM    382  CD  LYS A  27     -21.583   2.350  10.189  1.00  0.00           C  
ATOM    383  CE  LYS A  27     -23.010   1.820  10.337  1.00  0.00           C  
ATOM    384  NZ  LYS A  27     -23.980   2.938  10.350  1.00  0.00           N  
ATOM    385  H   LYS A  27     -17.810   0.208   7.039  1.00  0.00           H  
ATOM    386  HA  LYS A  27     -18.613   2.516   8.619  1.00  0.00           H  
ATOM    387  HB2 LYS A  27     -20.238   0.091   8.226  1.00  0.00           H  
ATOM    388  HB3 LYS A  27     -19.958   0.492   9.907  1.00  0.00           H  
ATOM    389  HG2 LYS A  27     -20.565   2.909   8.370  1.00  0.00           H  
ATOM    390  HG3 LYS A  27     -21.822   1.709   8.143  1.00  0.00           H  
ATOM    391  HD2 LYS A  27     -20.948   1.917  10.961  1.00  0.00           H  
ATOM    392  HD3 LYS A  27     -21.575   3.430  10.338  1.00  0.00           H  
ATOM    393  HE2 LYS A  27     -23.240   1.141   9.515  1.00  0.00           H  
ATOM    394  HE3 LYS A  27     -23.097   1.244  11.259  1.00  0.00           H  
ATOM    395  HZ1 LYS A  27     -23.604   3.712   9.840  1.00  0.00           H  
ATOM    396  HZ2 LYS A  27     -24.835   2.642   9.925  1.00  0.00           H  
ATOM    397  HZ3 LYS A  27     -24.156   3.215  11.295  1.00  0.00           H  
ATOM    398  N   VAL A  28     -16.814   1.855  10.130  1.00  0.00           N  
ATOM    399  CA  VAL A  28     -15.737   1.512  11.043  1.00  0.00           C  
ATOM    400  C   VAL A  28     -16.081   0.206  11.764  1.00  0.00           C  
ATOM    401  O   VAL A  28     -16.966   0.179  12.618  1.00  0.00           O  
ATOM    402  CB  VAL A  28     -15.476   2.673  12.005  1.00  0.00           C  
ATOM    403  CG1 VAL A  28     -14.410   2.302  13.037  1.00  0.00           C  
ATOM    404  CG2 VAL A  28     -15.084   3.940  11.241  1.00  0.00           C  
ATOM    405  H   VAL A  28     -17.007   2.832  10.052  1.00  0.00           H  
ATOM    406  HA  VAL A  28     -14.837   1.358  10.448  1.00  0.00           H  
ATOM    407  HB  VAL A  28     -16.403   2.880  12.540  1.00  0.00           H  
ATOM    408 HG11 VAL A  28     -13.430   2.301  12.561  1.00  0.00           H  
ATOM    409 HG12 VAL A  28     -14.420   3.030  13.848  1.00  0.00           H  
ATOM    410 HG13 VAL A  28     -14.620   1.310  13.436  1.00  0.00           H  
ATOM    411 HG21 VAL A  28     -14.196   4.378  11.697  1.00  0.00           H  
ATOM    412 HG22 VAL A  28     -14.871   3.685  10.202  1.00  0.00           H  
ATOM    413 HG23 VAL A  28     -15.903   4.656  11.280  1.00  0.00           H  
ATOM    414  N   GLY A  29     -15.364  -0.844  11.391  1.00  0.00           N  
ATOM    415  CA  GLY A  29     -15.583  -2.149  11.990  1.00  0.00           C  
ATOM    416  C   GLY A  29     -16.079  -3.155  10.948  1.00  0.00           C  
ATOM    417  O   GLY A  29     -16.014  -4.364  11.168  1.00  0.00           O  
ATOM    418  H   GLY A  29     -14.647  -0.813  10.695  1.00  0.00           H  
ATOM    419  HA2 GLY A  29     -14.654  -2.509  12.435  1.00  0.00           H  
ATOM    420  HA3 GLY A  29     -16.311  -2.067  12.796  1.00  0.00           H  
ATOM    421  N   ASP A  30     -16.562  -2.618   9.838  1.00  0.00           N  
ATOM    422  CA  ASP A  30     -17.068  -3.453   8.762  1.00  0.00           C  
ATOM    423  C   ASP A  30     -15.899  -4.163   8.079  1.00  0.00           C  
ATOM    424  O   ASP A  30     -14.796  -3.622   8.009  1.00  0.00           O  
ATOM    425  CB  ASP A  30     -17.793  -2.613   7.709  1.00  0.00           C  
ATOM    426  CG  ASP A  30     -19.150  -2.056   8.146  1.00  0.00           C  
ATOM    427  OD1 ASP A  30     -19.305  -1.834   9.366  1.00  0.00           O  
ATOM    428  OD2 ASP A  30     -20.000  -1.866   7.250  1.00  0.00           O  
ATOM    429  H   ASP A  30     -16.611  -1.633   9.668  1.00  0.00           H  
ATOM    430  HA  ASP A  30     -17.757  -4.149   9.240  1.00  0.00           H  
ATOM    431  HB2 ASP A  30     -17.150  -1.781   7.423  1.00  0.00           H  
ATOM    432  HB3 ASP A  30     -17.939  -3.223   6.817  1.00  0.00           H  
ATOM    433  N   ILE A  31     -16.178  -5.363   7.592  1.00  0.00           N  
ATOM    434  CA  ILE A  31     -15.162  -6.152   6.917  1.00  0.00           C  
ATOM    435  C   ILE A  31     -15.646  -6.500   5.507  1.00  0.00           C  
ATOM    436  O   ILE A  31     -16.636  -7.213   5.345  1.00  0.00           O  
ATOM    437  CB  ILE A  31     -14.787  -7.374   7.756  1.00  0.00           C  
ATOM    438  CG1 ILE A  31     -14.500  -6.976   9.206  1.00  0.00           C  
ATOM    439  CG2 ILE A  31     -13.616  -8.132   7.129  1.00  0.00           C  
ATOM    440  CD1 ILE A  31     -14.263  -8.211  10.077  1.00  0.00           C  
ATOM    441  H   ILE A  31     -17.077  -5.795   7.653  1.00  0.00           H  
ATOM    442  HA  ILE A  31     -14.270  -5.532   6.832  1.00  0.00           H  
ATOM    443  HB  ILE A  31     -15.639  -8.054   7.772  1.00  0.00           H  
ATOM    444 HG12 ILE A  31     -13.625  -6.327   9.242  1.00  0.00           H  
ATOM    445 HG13 ILE A  31     -15.338  -6.402   9.602  1.00  0.00           H  
ATOM    446 HG21 ILE A  31     -12.841  -8.290   7.879  1.00  0.00           H  
ATOM    447 HG22 ILE A  31     -13.964  -9.096   6.758  1.00  0.00           H  
ATOM    448 HG23 ILE A  31     -13.208  -7.551   6.302  1.00  0.00           H  
ATOM    449 HD11 ILE A  31     -15.214  -8.561  10.478  1.00  0.00           H  
ATOM    450 HD12 ILE A  31     -13.811  -8.999   9.475  1.00  0.00           H  
ATOM    451 HD13 ILE A  31     -13.595  -7.953  10.899  1.00  0.00           H  
ATOM    452  N   ILE A  32     -14.926  -5.981   4.524  1.00  0.00           N  
ATOM    453  CA  ILE A  32     -15.270  -6.228   3.134  1.00  0.00           C  
ATOM    454  C   ILE A  32     -14.327  -7.287   2.560  1.00  0.00           C  
ATOM    455  O   ILE A  32     -13.108  -7.138   2.623  1.00  0.00           O  
ATOM    456  CB  ILE A  32     -15.277  -4.918   2.343  1.00  0.00           C  
ATOM    457  CG1 ILE A  32     -16.546  -4.112   2.627  1.00  0.00           C  
ATOM    458  CG2 ILE A  32     -15.087  -5.180   0.847  1.00  0.00           C  
ATOM    459  CD1 ILE A  32     -16.226  -2.623   2.780  1.00  0.00           C  
ATOM    460  H   ILE A  32     -14.123  -5.403   4.664  1.00  0.00           H  
ATOM    461  HA  ILE A  32     -16.286  -6.622   3.113  1.00  0.00           H  
ATOM    462  HB  ILE A  32     -14.431  -4.315   2.674  1.00  0.00           H  
ATOM    463 HG12 ILE A  32     -17.260  -4.254   1.817  1.00  0.00           H  
ATOM    464 HG13 ILE A  32     -17.019  -4.482   3.537  1.00  0.00           H  
ATOM    465 HG21 ILE A  32     -15.578  -4.392   0.275  1.00  0.00           H  
ATOM    466 HG22 ILE A  32     -14.023  -5.190   0.612  1.00  0.00           H  
ATOM    467 HG23 ILE A  32     -15.527  -6.143   0.588  1.00  0.00           H  
ATOM    468 HD11 ILE A  32     -15.162  -2.460   2.612  1.00  0.00           H  
ATOM    469 HD12 ILE A  32     -16.802  -2.052   2.052  1.00  0.00           H  
ATOM    470 HD13 ILE A  32     -16.489  -2.297   3.787  1.00  0.00           H  
ATOM    471  N   GLU A  33     -14.927  -8.334   2.013  1.00  0.00           N  
ATOM    472  CA  GLU A  33     -14.156  -9.419   1.429  1.00  0.00           C  
ATOM    473  C   GLU A  33     -13.672  -9.031   0.030  1.00  0.00           C  
ATOM    474  O   GLU A  33     -14.334  -9.327  -0.964  1.00  0.00           O  
ATOM    475  CB  GLU A  33     -14.973 -10.712   1.388  1.00  0.00           C  
ATOM    476  CG  GLU A  33     -14.324 -11.797   2.249  1.00  0.00           C  
ATOM    477  CD  GLU A  33     -14.577 -13.187   1.662  1.00  0.00           C  
ATOM    478  OE1 GLU A  33     -15.768 -13.562   1.584  1.00  0.00           O  
ATOM    479  OE2 GLU A  33     -13.576 -13.843   1.305  1.00  0.00           O  
ATOM    480  H   GLU A  33     -15.920  -8.448   1.966  1.00  0.00           H  
ATOM    481  HA  GLU A  33     -13.302  -9.556   2.092  1.00  0.00           H  
ATOM    482  HB2 GLU A  33     -15.986 -10.518   1.743  1.00  0.00           H  
ATOM    483  HB3 GLU A  33     -15.058 -11.061   0.359  1.00  0.00           H  
ATOM    484  HG2 GLU A  33     -13.251 -11.618   2.319  1.00  0.00           H  
ATOM    485  HG3 GLU A  33     -14.722 -11.749   3.263  1.00  0.00           H  
ATOM    486  N   VAL A  34     -12.521  -8.376  -0.002  1.00  0.00           N  
ATOM    487  CA  VAL A  34     -11.940  -7.946  -1.263  1.00  0.00           C  
ATOM    488  C   VAL A  34     -12.008  -9.096  -2.269  1.00  0.00           C  
ATOM    489  O   VAL A  34     -11.327 -10.107  -2.108  1.00  0.00           O  
ATOM    490  CB  VAL A  34     -10.516  -7.434  -1.035  1.00  0.00           C  
ATOM    491  CG1 VAL A  34      -9.870  -7.008  -2.355  1.00  0.00           C  
ATOM    492  CG2 VAL A  34     -10.502  -6.286  -0.023  1.00  0.00           C  
ATOM    493  H   VAL A  34     -11.989  -8.140   0.811  1.00  0.00           H  
ATOM    494  HA  VAL A  34     -12.541  -7.117  -1.636  1.00  0.00           H  
ATOM    495  HB  VAL A  34      -9.928  -8.253  -0.622  1.00  0.00           H  
ATOM    496 HG11 VAL A  34     -10.647  -6.734  -3.068  1.00  0.00           H  
ATOM    497 HG12 VAL A  34      -9.218  -6.153  -2.180  1.00  0.00           H  
ATOM    498 HG13 VAL A  34      -9.284  -7.836  -2.755  1.00  0.00           H  
ATOM    499 HG21 VAL A  34      -9.532  -5.791  -0.049  1.00  0.00           H  
ATOM    500 HG22 VAL A  34     -11.284  -5.570  -0.274  1.00  0.00           H  
ATOM    501 HG23 VAL A  34     -10.681  -6.682   0.978  1.00  0.00           H  
ATOM    502  N   VAL A  35     -12.836  -8.903  -3.286  1.00  0.00           N  
ATOM    503  CA  VAL A  35     -13.001  -9.912  -4.319  1.00  0.00           C  
ATOM    504  C   VAL A  35     -12.077  -9.587  -5.494  1.00  0.00           C  
ATOM    505  O   VAL A  35     -11.550 -10.490  -6.141  1.00  0.00           O  
ATOM    506  CB  VAL A  35     -14.473 -10.009  -4.724  1.00  0.00           C  
ATOM    507  CG1 VAL A  35     -15.312 -10.620  -3.599  1.00  0.00           C  
ATOM    508  CG2 VAL A  35     -15.020  -8.641  -5.135  1.00  0.00           C  
ATOM    509  H   VAL A  35     -13.386  -8.078  -3.409  1.00  0.00           H  
ATOM    510  HA  VAL A  35     -12.704 -10.870  -3.892  1.00  0.00           H  
ATOM    511  HB  VAL A  35     -14.540 -10.670  -5.588  1.00  0.00           H  
ATOM    512 HG11 VAL A  35     -14.721 -10.656  -2.684  1.00  0.00           H  
ATOM    513 HG12 VAL A  35     -16.199 -10.009  -3.434  1.00  0.00           H  
ATOM    514 HG13 VAL A  35     -15.612 -11.630  -3.877  1.00  0.00           H  
ATOM    515 HG21 VAL A  35     -15.712  -8.761  -5.969  1.00  0.00           H  
ATOM    516 HG22 VAL A  35     -15.544  -8.190  -4.291  1.00  0.00           H  
ATOM    517 HG23 VAL A  35     -14.196  -7.995  -5.437  1.00  0.00           H  
ATOM    518  N   GLY A  36     -11.911  -8.295  -5.736  1.00  0.00           N  
ATOM    519  CA  GLY A  36     -11.060  -7.841  -6.822  1.00  0.00           C  
ATOM    520  C   GLY A  36     -10.638  -6.385  -6.616  1.00  0.00           C  
ATOM    521  O   GLY A  36     -10.504  -5.928  -5.481  1.00  0.00           O  
ATOM    522  H   GLY A  36     -12.344  -7.567  -5.204  1.00  0.00           H  
ATOM    523  HA2 GLY A  36     -10.176  -8.474  -6.886  1.00  0.00           H  
ATOM    524  HA3 GLY A  36     -11.591  -7.938  -7.770  1.00  0.00           H  
ATOM    525  N   GLU A  37     -10.440  -5.695  -7.730  1.00  0.00           N  
ATOM    526  CA  GLU A  37     -10.036  -4.300  -7.685  1.00  0.00           C  
ATOM    527  C   GLU A  37     -10.669  -3.527  -8.843  1.00  0.00           C  
ATOM    528  O   GLU A  37     -10.522  -3.908 -10.004  1.00  0.00           O  
ATOM    529  CB  GLU A  37      -8.512  -4.171  -7.708  1.00  0.00           C  
ATOM    530  CG  GLU A  37      -8.088  -2.720  -7.948  1.00  0.00           C  
ATOM    531  CD  GLU A  37      -7.509  -2.543  -9.353  1.00  0.00           C  
ATOM    532  OE1 GLU A  37      -6.290  -2.780  -9.497  1.00  0.00           O  
ATOM    533  OE2 GLU A  37      -8.298  -2.175 -10.249  1.00  0.00           O  
ATOM    534  H   GLU A  37     -10.551  -6.074  -8.649  1.00  0.00           H  
ATOM    535  HA  GLU A  37     -10.412  -3.920  -6.736  1.00  0.00           H  
ATOM    536  HB2 GLU A  37      -8.099  -4.522  -6.762  1.00  0.00           H  
ATOM    537  HB3 GLU A  37      -8.100  -4.808  -8.491  1.00  0.00           H  
ATOM    538  HG2 GLU A  37      -8.946  -2.061  -7.819  1.00  0.00           H  
ATOM    539  HG3 GLU A  37      -7.346  -2.426  -7.205  1.00  0.00           H  
ATOM    540  N   VAL A  38     -11.361  -2.453  -8.488  1.00  0.00           N  
ATOM    541  CA  VAL A  38     -12.016  -1.623  -9.484  1.00  0.00           C  
ATOM    542  C   VAL A  38     -10.964  -0.802 -10.231  1.00  0.00           C  
ATOM    543  O   VAL A  38     -10.643  -1.098 -11.382  1.00  0.00           O  
ATOM    544  CB  VAL A  38     -13.088  -0.757  -8.817  1.00  0.00           C  
ATOM    545  CG1 VAL A  38     -13.896   0.016  -9.863  1.00  0.00           C  
ATOM    546  CG2 VAL A  38     -14.006  -1.603  -7.933  1.00  0.00           C  
ATOM    547  H   VAL A  38     -11.475  -2.150  -7.543  1.00  0.00           H  
ATOM    548  HA  VAL A  38     -12.512  -2.288 -10.192  1.00  0.00           H  
ATOM    549  HB  VAL A  38     -12.583  -0.031  -8.180  1.00  0.00           H  
ATOM    550 HG11 VAL A  38     -14.938  -0.299  -9.823  1.00  0.00           H  
ATOM    551 HG12 VAL A  38     -13.830   1.084  -9.654  1.00  0.00           H  
ATOM    552 HG13 VAL A  38     -13.492  -0.186 -10.855  1.00  0.00           H  
ATOM    553 HG21 VAL A  38     -13.402  -2.256  -7.303  1.00  0.00           H  
ATOM    554 HG22 VAL A  38     -14.608  -0.948  -7.304  1.00  0.00           H  
ATOM    555 HG23 VAL A  38     -14.659  -2.207  -8.561  1.00  0.00           H  
ATOM    556  N   GLU A  39     -10.455   0.212  -9.547  1.00  0.00           N  
ATOM    557  CA  GLU A  39      -9.445   1.078 -10.132  1.00  0.00           C  
ATOM    558  C   GLU A  39      -8.465   1.552  -9.057  1.00  0.00           C  
ATOM    559  O   GLU A  39      -8.641   1.254  -7.877  1.00  0.00           O  
ATOM    560  CB  GLU A  39     -10.090   2.265 -10.849  1.00  0.00           C  
ATOM    561  CG  GLU A  39     -10.743   3.221  -9.850  1.00  0.00           C  
ATOM    562  CD  GLU A  39     -10.960   4.602 -10.471  1.00  0.00           C  
ATOM    563  OE1 GLU A  39     -11.813   4.688 -11.380  1.00  0.00           O  
ATOM    564  OE2 GLU A  39     -10.267   5.541 -10.023  1.00  0.00           O  
ATOM    565  H   GLU A  39     -10.722   0.445  -8.612  1.00  0.00           H  
ATOM    566  HA  GLU A  39      -8.922   0.460 -10.863  1.00  0.00           H  
ATOM    567  HB2 GLU A  39      -9.335   2.799 -11.428  1.00  0.00           H  
ATOM    568  HB3 GLU A  39     -10.838   1.906 -11.557  1.00  0.00           H  
ATOM    569  HG2 GLU A  39     -11.699   2.812  -9.522  1.00  0.00           H  
ATOM    570  HG3 GLU A  39     -10.115   3.311  -8.963  1.00  0.00           H  
ATOM    571  N   GLU A  40      -7.455   2.283  -9.504  1.00  0.00           N  
ATOM    572  CA  GLU A  40      -6.447   2.801  -8.595  1.00  0.00           C  
ATOM    573  C   GLU A  40      -7.111   3.550  -7.437  1.00  0.00           C  
ATOM    574  O   GLU A  40      -7.752   4.578  -7.645  1.00  0.00           O  
ATOM    575  CB  GLU A  40      -5.454   3.703  -9.333  1.00  0.00           C  
ATOM    576  CG  GLU A  40      -4.175   3.894  -8.517  1.00  0.00           C  
ATOM    577  CD  GLU A  40      -3.851   5.379  -8.344  1.00  0.00           C  
ATOM    578  OE1 GLU A  40      -3.148   5.912  -9.230  1.00  0.00           O  
ATOM    579  OE2 GLU A  40      -4.313   5.948  -7.332  1.00  0.00           O  
ATOM    580  H   GLU A  40      -7.319   2.521 -10.466  1.00  0.00           H  
ATOM    581  HA  GLU A  40      -5.920   1.925  -8.216  1.00  0.00           H  
ATOM    582  HB2 GLU A  40      -5.210   3.265 -10.301  1.00  0.00           H  
ATOM    583  HB3 GLU A  40      -5.914   4.671  -9.528  1.00  0.00           H  
ATOM    584  HG2 GLU A  40      -4.291   3.428  -7.538  1.00  0.00           H  
ATOM    585  HG3 GLU A  40      -3.345   3.392  -9.012  1.00  0.00           H  
ATOM    586  N   GLY A  41      -6.932   3.004  -6.243  1.00  0.00           N  
ATOM    587  CA  GLY A  41      -7.507   3.608  -5.052  1.00  0.00           C  
ATOM    588  C   GLY A  41      -8.925   3.089  -4.805  1.00  0.00           C  
ATOM    589  O   GLY A  41      -9.541   3.414  -3.790  1.00  0.00           O  
ATOM    590  H   GLY A  41      -6.410   2.168  -6.082  1.00  0.00           H  
ATOM    591  HA2 GLY A  41      -6.879   3.386  -4.189  1.00  0.00           H  
ATOM    592  HA3 GLY A  41      -7.526   4.692  -5.162  1.00  0.00           H  
ATOM    593  N   TRP A  42      -9.403   2.292  -5.748  1.00  0.00           N  
ATOM    594  CA  TRP A  42     -10.737   1.727  -5.646  1.00  0.00           C  
ATOM    595  C   TRP A  42     -10.617   0.206  -5.768  1.00  0.00           C  
ATOM    596  O   TRP A  42     -10.019  -0.298  -6.717  1.00  0.00           O  
ATOM    597  CB  TRP A  42     -11.675   2.338  -6.689  1.00  0.00           C  
ATOM    598  CG  TRP A  42     -12.027   3.803  -6.426  1.00  0.00           C  
ATOM    599  CD1 TRP A  42     -11.303   4.892  -6.722  1.00  0.00           C  
ATOM    600  CD2 TRP A  42     -13.228   4.299  -5.798  1.00  0.00           C  
ATOM    601  NE1 TRP A  42     -11.947   6.048  -6.332  1.00  0.00           N  
ATOM    602  CE2 TRP A  42     -13.155   5.677  -5.753  1.00  0.00           C  
ATOM    603  CE3 TRP A  42     -14.339   3.608  -5.286  1.00  0.00           C  
ATOM    604  CZ2 TRP A  42     -14.162   6.480  -5.204  1.00  0.00           C  
ATOM    605  CZ3 TRP A  42     -15.337   4.425  -4.741  1.00  0.00           C  
ATOM    606  CH2 TRP A  42     -15.278   5.812  -4.687  1.00  0.00           C  
ATOM    607  H   TRP A  42      -8.896   2.033  -6.571  1.00  0.00           H  
ATOM    608  HA  TRP A  42     -11.137   1.991  -4.667  1.00  0.00           H  
ATOM    609  HB2 TRP A  42     -11.210   2.257  -7.671  1.00  0.00           H  
ATOM    610  HB3 TRP A  42     -12.595   1.754  -6.723  1.00  0.00           H  
ATOM    611  HD1 TRP A  42     -10.329   4.867  -7.209  1.00  0.00           H  
ATOM    612  HE1 TRP A  42     -11.577   7.066  -6.457  1.00  0.00           H  
ATOM    613  HE3 TRP A  42     -14.421   2.520  -5.310  1.00  0.00           H  
ATOM    614  HZ2 TRP A  42     -14.080   7.567  -5.179  1.00  0.00           H  
ATOM    615  HZ3 TRP A  42     -16.220   3.939  -4.328  1.00  0.00           H  
ATOM    616  HH2 TRP A  42     -16.098   6.378  -4.244  1.00  0.00           H  
ATOM    617  N   TRP A  43     -11.194  -0.482  -4.794  1.00  0.00           N  
ATOM    618  CA  TRP A  43     -11.160  -1.935  -4.782  1.00  0.00           C  
ATOM    619  C   TRP A  43     -12.602  -2.443  -4.816  1.00  0.00           C  
ATOM    620  O   TRP A  43     -13.542  -1.663  -4.675  1.00  0.00           O  
ATOM    621  CB  TRP A  43     -10.372  -2.453  -3.576  1.00  0.00           C  
ATOM    622  CG  TRP A  43      -8.856  -2.296  -3.709  1.00  0.00           C  
ATOM    623  CD1 TRP A  43      -8.157  -1.918  -4.789  1.00  0.00           C  
ATOM    624  CD2 TRP A  43      -7.874  -2.530  -2.677  1.00  0.00           C  
ATOM    625  NE1 TRP A  43      -6.802  -1.891  -4.529  1.00  0.00           N  
ATOM    626  CE2 TRP A  43      -6.625  -2.275  -3.205  1.00  0.00           C  
ATOM    627  CE3 TRP A  43      -8.036  -2.942  -1.344  1.00  0.00           C  
ATOM    628  CZ2 TRP A  43      -5.441  -2.405  -2.468  1.00  0.00           C  
ATOM    629  CZ3 TRP A  43      -6.844  -3.067  -0.620  1.00  0.00           C  
ATOM    630  CH2 TRP A  43      -5.578  -2.815  -1.137  1.00  0.00           C  
ATOM    631  H   TRP A  43     -11.679  -0.064  -4.026  1.00  0.00           H  
ATOM    632  HA  TRP A  43     -10.627  -2.262  -5.674  1.00  0.00           H  
ATOM    633  HB2 TRP A  43     -10.705  -1.924  -2.683  1.00  0.00           H  
ATOM    634  HB3 TRP A  43     -10.607  -3.507  -3.428  1.00  0.00           H  
ATOM    635  HD1 TRP A  43      -8.603  -1.665  -5.750  1.00  0.00           H  
ATOM    636  HE1 TRP A  43      -6.016  -1.620  -5.232  1.00  0.00           H  
ATOM    637  HE3 TRP A  43      -9.012  -3.149  -0.904  1.00  0.00           H  
ATOM    638  HZ2 TRP A  43      -4.465  -2.198  -2.907  1.00  0.00           H  
ATOM    639  HZ3 TRP A  43      -6.913  -3.385   0.420  1.00  0.00           H  
ATOM    640  HH2 TRP A  43      -4.696  -2.935  -0.507  1.00  0.00           H  
ATOM    641  N   GLU A  44     -12.732  -3.748  -5.006  1.00  0.00           N  
ATOM    642  CA  GLU A  44     -14.044  -4.369  -5.062  1.00  0.00           C  
ATOM    643  C   GLU A  44     -14.138  -5.504  -4.039  1.00  0.00           C  
ATOM    644  O   GLU A  44     -13.278  -6.382  -4.002  1.00  0.00           O  
ATOM    645  CB  GLU A  44     -14.351  -4.875  -6.472  1.00  0.00           C  
ATOM    646  CG  GLU A  44     -15.855  -5.078  -6.666  1.00  0.00           C  
ATOM    647  CD  GLU A  44     -16.235  -4.982  -8.146  1.00  0.00           C  
ATOM    648  OE1 GLU A  44     -15.404  -5.413  -8.974  1.00  0.00           O  
ATOM    649  OE2 GLU A  44     -17.347  -4.479  -8.415  1.00  0.00           O  
ATOM    650  H   GLU A  44     -11.961  -4.376  -5.120  1.00  0.00           H  
ATOM    651  HA  GLU A  44     -14.750  -3.579  -4.804  1.00  0.00           H  
ATOM    652  HB2 GLU A  44     -13.979  -4.162  -7.208  1.00  0.00           H  
ATOM    653  HB3 GLU A  44     -13.829  -5.815  -6.648  1.00  0.00           H  
ATOM    654  HG2 GLU A  44     -16.149  -6.052  -6.275  1.00  0.00           H  
ATOM    655  HG3 GLU A  44     -16.403  -4.327  -6.098  1.00  0.00           H  
ATOM    656  N   GLY A  45     -15.189  -5.448  -3.235  1.00  0.00           N  
ATOM    657  CA  GLY A  45     -15.406  -6.460  -2.216  1.00  0.00           C  
ATOM    658  C   GLY A  45     -16.897  -6.619  -1.910  1.00  0.00           C  
ATOM    659  O   GLY A  45     -17.742  -6.083  -2.626  1.00  0.00           O  
ATOM    660  H   GLY A  45     -15.884  -4.730  -3.273  1.00  0.00           H  
ATOM    661  HA2 GLY A  45     -14.997  -7.413  -2.551  1.00  0.00           H  
ATOM    662  HA3 GLY A  45     -14.872  -6.186  -1.306  1.00  0.00           H  
ATOM    663  N   VAL A  46     -17.174  -7.357  -0.845  1.00  0.00           N  
ATOM    664  CA  VAL A  46     -18.548  -7.593  -0.434  1.00  0.00           C  
ATOM    665  C   VAL A  46     -18.744  -7.083   0.994  1.00  0.00           C  
ATOM    666  O   VAL A  46     -17.874  -7.260   1.846  1.00  0.00           O  
ATOM    667  CB  VAL A  46     -18.894  -9.074  -0.594  1.00  0.00           C  
ATOM    668  CG1 VAL A  46     -20.087  -9.456   0.285  1.00  0.00           C  
ATOM    669  CG2 VAL A  46     -19.161  -9.421  -2.060  1.00  0.00           C  
ATOM    670  H   VAL A  46     -16.481  -7.788  -0.268  1.00  0.00           H  
ATOM    671  HA  VAL A  46     -19.193  -7.022  -1.103  1.00  0.00           H  
ATOM    672  HB  VAL A  46     -18.035  -9.656  -0.263  1.00  0.00           H  
ATOM    673 HG11 VAL A  46     -20.751 -10.119  -0.270  1.00  0.00           H  
ATOM    674 HG12 VAL A  46     -19.731  -9.965   1.180  1.00  0.00           H  
ATOM    675 HG13 VAL A  46     -20.631  -8.555   0.571  1.00  0.00           H  
ATOM    676 HG21 VAL A  46     -18.961  -8.548  -2.682  1.00  0.00           H  
ATOM    677 HG22 VAL A  46     -18.508 -10.241  -2.364  1.00  0.00           H  
ATOM    678 HG23 VAL A  46     -20.202  -9.722  -2.179  1.00  0.00           H  
ATOM    679  N   LEU A  47     -19.892  -6.460   1.214  1.00  0.00           N  
ATOM    680  CA  LEU A  47     -20.213  -5.923   2.526  1.00  0.00           C  
ATOM    681  C   LEU A  47     -21.454  -6.632   3.073  1.00  0.00           C  
ATOM    682  O   LEU A  47     -22.576  -6.163   2.885  1.00  0.00           O  
ATOM    683  CB  LEU A  47     -20.354  -4.401   2.462  1.00  0.00           C  
ATOM    684  CG  LEU A  47     -20.759  -3.710   3.766  1.00  0.00           C  
ATOM    685  CD1 LEU A  47     -19.720  -3.954   4.862  1.00  0.00           C  
ATOM    686  CD2 LEU A  47     -21.013  -2.218   3.540  1.00  0.00           C  
ATOM    687  H   LEU A  47     -20.595  -6.319   0.517  1.00  0.00           H  
ATOM    688  HA  LEU A  47     -19.372  -6.142   3.183  1.00  0.00           H  
ATOM    689  HB2 LEU A  47     -19.404  -3.981   2.132  1.00  0.00           H  
ATOM    690  HB3 LEU A  47     -21.093  -4.156   1.699  1.00  0.00           H  
ATOM    691  HG  LEU A  47     -21.697  -4.147   4.108  1.00  0.00           H  
ATOM    692 HD11 LEU A  47     -18.789  -3.454   4.597  1.00  0.00           H  
ATOM    693 HD12 LEU A  47     -20.090  -3.558   5.808  1.00  0.00           H  
ATOM    694 HD13 LEU A  47     -19.542  -5.025   4.961  1.00  0.00           H  
ATOM    695 HD21 LEU A  47     -21.563  -1.809   4.387  1.00  0.00           H  
ATOM    696 HD22 LEU A  47     -20.060  -1.698   3.440  1.00  0.00           H  
ATOM    697 HD23 LEU A  47     -21.596  -2.082   2.629  1.00  0.00           H  
ATOM    698  N   ASN A  48     -21.210  -7.753   3.738  1.00  0.00           N  
ATOM    699  CA  ASN A  48     -22.294  -8.532   4.313  1.00  0.00           C  
ATOM    700  C   ASN A  48     -23.203  -9.039   3.192  1.00  0.00           C  
ATOM    701  O   ASN A  48     -24.424  -8.910   3.271  1.00  0.00           O  
ATOM    702  CB  ASN A  48     -23.142  -7.680   5.261  1.00  0.00           C  
ATOM    703  CG  ASN A  48     -22.656  -7.818   6.704  1.00  0.00           C  
ATOM    704  OD1 ASN A  48     -22.893  -8.809   7.374  1.00  0.00           O  
ATOM    705  ND2 ASN A  48     -21.966  -6.770   7.145  1.00  0.00           N  
ATOM    706  H   ASN A  48     -20.296  -8.127   3.886  1.00  0.00           H  
ATOM    707  HA  ASN A  48     -21.807  -9.343   4.854  1.00  0.00           H  
ATOM    708  HB2 ASN A  48     -23.095  -6.635   4.955  1.00  0.00           H  
ATOM    709  HB3 ASN A  48     -24.186  -7.985   5.193  1.00  0.00           H  
ATOM    710 HD21 ASN A  48     -21.807  -5.987   6.544  1.00  0.00           H  
ATOM    711 HD22 ASN A  48     -21.606  -6.765   8.078  1.00  0.00           H  
ATOM    712  N   GLY A  49     -22.573  -9.605   2.173  1.00  0.00           N  
ATOM    713  CA  GLY A  49     -23.309 -10.132   1.037  1.00  0.00           C  
ATOM    714  C   GLY A  49     -23.414  -9.092  -0.080  1.00  0.00           C  
ATOM    715  O   GLY A  49     -23.443  -9.442  -1.259  1.00  0.00           O  
ATOM    716  H   GLY A  49     -21.579  -9.705   2.116  1.00  0.00           H  
ATOM    717  HA2 GLY A  49     -22.813 -11.027   0.660  1.00  0.00           H  
ATOM    718  HA3 GLY A  49     -24.308 -10.432   1.354  1.00  0.00           H  
ATOM    719  N   LYS A  50     -23.466  -7.833   0.331  1.00  0.00           N  
ATOM    720  CA  LYS A  50     -23.567  -6.740  -0.621  1.00  0.00           C  
ATOM    721  C   LYS A  50     -22.279  -6.666  -1.443  1.00  0.00           C  
ATOM    722  O   LYS A  50     -21.348  -7.436  -1.217  1.00  0.00           O  
ATOM    723  CB  LYS A  50     -23.913  -5.434   0.099  1.00  0.00           C  
ATOM    724  CG  LYS A  50     -24.873  -4.586  -0.738  1.00  0.00           C  
ATOM    725  CD  LYS A  50     -26.184  -4.342   0.013  1.00  0.00           C  
ATOM    726  CE  LYS A  50     -26.876  -3.073  -0.490  1.00  0.00           C  
ATOM    727  NZ  LYS A  50     -28.001  -3.417  -1.387  1.00  0.00           N  
ATOM    728  H   LYS A  50     -23.442  -7.557   1.291  1.00  0.00           H  
ATOM    729  HA  LYS A  50     -24.394  -6.966  -1.293  1.00  0.00           H  
ATOM    730  HB2 LYS A  50     -24.365  -5.656   1.065  1.00  0.00           H  
ATOM    731  HB3 LYS A  50     -23.001  -4.871   0.296  1.00  0.00           H  
ATOM    732  HG2 LYS A  50     -24.405  -3.631  -0.979  1.00  0.00           H  
ATOM    733  HG3 LYS A  50     -25.078  -5.087  -1.682  1.00  0.00           H  
ATOM    734  HD2 LYS A  50     -26.846  -5.198  -0.118  1.00  0.00           H  
ATOM    735  HD3 LYS A  50     -25.985  -4.254   1.081  1.00  0.00           H  
ATOM    736  HE2 LYS A  50     -27.242  -2.492   0.356  1.00  0.00           H  
ATOM    737  HE3 LYS A  50     -26.159  -2.446  -1.020  1.00  0.00           H  
ATOM    738  HZ1 LYS A  50     -28.077  -4.411  -1.461  1.00  0.00           H  
ATOM    739  HZ2 LYS A  50     -28.851  -3.044  -1.015  1.00  0.00           H  
ATOM    740  HZ3 LYS A  50     -27.836  -3.028  -2.294  1.00  0.00           H  
ATOM    741  N   THR A  51     -22.268  -5.730  -2.382  1.00  0.00           N  
ATOM    742  CA  THR A  51     -21.110  -5.545  -3.240  1.00  0.00           C  
ATOM    743  C   THR A  51     -21.114  -4.141  -3.847  1.00  0.00           C  
ATOM    744  O   THR A  51     -22.174  -3.548  -4.043  1.00  0.00           O  
ATOM    745  CB  THR A  51     -21.115  -6.660  -4.288  1.00  0.00           C  
ATOM    746  OG1 THR A  51     -20.855  -7.843  -3.538  1.00  0.00           O  
ATOM    747  CG2 THR A  51     -19.931  -6.562  -5.252  1.00  0.00           C  
ATOM    748  H   THR A  51     -23.029  -5.106  -2.560  1.00  0.00           H  
ATOM    749  HA  THR A  51     -20.211  -5.626  -2.627  1.00  0.00           H  
ATOM    750  HB  THR A  51     -22.059  -6.678  -4.832  1.00  0.00           H  
ATOM    751  HG1 THR A  51     -21.090  -8.650  -4.080  1.00  0.00           H  
ATOM    752 HG21 THR A  51     -20.079  -7.256  -6.081  1.00  0.00           H  
ATOM    753 HG22 THR A  51     -19.860  -5.546  -5.639  1.00  0.00           H  
ATOM    754 HG23 THR A  51     -19.012  -6.817  -4.725  1.00  0.00           H  
ATOM    755  N   GLY A  52     -19.916  -3.648  -4.126  1.00  0.00           N  
ATOM    756  CA  GLY A  52     -19.769  -2.324  -4.708  1.00  0.00           C  
ATOM    757  C   GLY A  52     -18.313  -1.856  -4.641  1.00  0.00           C  
ATOM    758  O   GLY A  52     -17.498  -2.451  -3.939  1.00  0.00           O  
ATOM    759  H   GLY A  52     -19.059  -4.137  -3.965  1.00  0.00           H  
ATOM    760  HA2 GLY A  52     -20.103  -2.339  -5.745  1.00  0.00           H  
ATOM    761  HA3 GLY A  52     -20.406  -1.618  -4.177  1.00  0.00           H  
ATOM    762  N   MET A  53     -18.033  -0.794  -5.382  1.00  0.00           N  
ATOM    763  CA  MET A  53     -16.691  -0.239  -5.416  1.00  0.00           C  
ATOM    764  C   MET A  53     -16.456   0.701  -4.232  1.00  0.00           C  
ATOM    765  O   MET A  53     -17.279   1.570  -3.952  1.00  0.00           O  
ATOM    766  CB  MET A  53     -16.489   0.529  -6.725  1.00  0.00           C  
ATOM    767  CG  MET A  53     -17.633   1.516  -6.963  1.00  0.00           C  
ATOM    768  SD  MET A  53     -16.977   3.130  -7.351  1.00  0.00           S  
ATOM    769  CE  MET A  53     -16.252   2.795  -8.947  1.00  0.00           C  
ATOM    770  H   MET A  53     -18.703  -0.316  -5.950  1.00  0.00           H  
ATOM    771  HA  MET A  53     -16.018  -1.094  -5.350  1.00  0.00           H  
ATOM    772  HB2 MET A  53     -15.541   1.067  -6.692  1.00  0.00           H  
ATOM    773  HB3 MET A  53     -16.430  -0.173  -7.556  1.00  0.00           H  
ATOM    774  HG2 MET A  53     -18.263   1.165  -7.780  1.00  0.00           H  
ATOM    775  HG3 MET A  53     -18.265   1.575  -6.076  1.00  0.00           H  
ATOM    776  HE1 MET A  53     -16.882   3.219  -9.728  1.00  0.00           H  
ATOM    777  HE2 MET A  53     -15.260   3.243  -8.997  1.00  0.00           H  
ATOM    778  HE3 MET A  53     -16.171   1.718  -9.090  1.00  0.00           H  
ATOM    779  N   PHE A  54     -15.327   0.493  -3.568  1.00  0.00           N  
ATOM    780  CA  PHE A  54     -14.973   1.311  -2.420  1.00  0.00           C  
ATOM    781  C   PHE A  54     -13.489   1.683  -2.449  1.00  0.00           C  
ATOM    782  O   PHE A  54     -12.685   0.994  -3.074  1.00  0.00           O  
ATOM    783  CB  PHE A  54     -15.253   0.473  -1.171  1.00  0.00           C  
ATOM    784  CG  PHE A  54     -14.255  -0.667  -0.951  1.00  0.00           C  
ATOM    785  CD1 PHE A  54     -14.402  -1.840  -1.624  1.00  0.00           C  
ATOM    786  CD2 PHE A  54     -13.222  -0.507  -0.081  1.00  0.00           C  
ATOM    787  CE1 PHE A  54     -13.477  -2.897  -1.420  1.00  0.00           C  
ATOM    788  CE2 PHE A  54     -12.297  -1.565   0.123  1.00  0.00           C  
ATOM    789  CZ  PHE A  54     -12.444  -2.738  -0.550  1.00  0.00           C  
ATOM    790  H   PHE A  54     -14.663  -0.216  -3.804  1.00  0.00           H  
ATOM    791  HA  PHE A  54     -15.575   2.219  -2.471  1.00  0.00           H  
ATOM    792  HB2 PHE A  54     -15.241   1.124  -0.298  1.00  0.00           H  
ATOM    793  HB3 PHE A  54     -16.256   0.054  -1.244  1.00  0.00           H  
ATOM    794  HD1 PHE A  54     -15.230  -1.967  -2.322  1.00  0.00           H  
ATOM    795  HD2 PHE A  54     -13.105   0.431   0.459  1.00  0.00           H  
ATOM    796  HE1 PHE A  54     -13.594  -3.836  -1.960  1.00  0.00           H  
ATOM    797  HE2 PHE A  54     -11.469  -1.438   0.821  1.00  0.00           H  
ATOM    798  HZ  PHE A  54     -11.733  -3.549  -0.393  1.00  0.00           H  
ATOM    799  N   PRO A  55     -13.163   2.801  -1.746  1.00  0.00           N  
ATOM    800  CA  PRO A  55     -11.791   3.273  -1.685  1.00  0.00           C  
ATOM    801  C   PRO A  55     -10.952   2.399  -0.751  1.00  0.00           C  
ATOM    802  O   PRO A  55     -11.319   2.188   0.404  1.00  0.00           O  
ATOM    803  CB  PRO A  55     -11.892   4.716  -1.218  1.00  0.00           C  
ATOM    804  CG  PRO A  55     -13.269   4.856  -0.591  1.00  0.00           C  
ATOM    805  CD  PRO A  55     -14.090   3.641  -0.993  1.00  0.00           C  
ATOM    806  HA  PRO A  55     -11.360   3.204  -2.585  1.00  0.00           H  
ATOM    807  HB2 PRO A  55     -11.109   4.948  -0.495  1.00  0.00           H  
ATOM    808  HB3 PRO A  55     -11.770   5.406  -2.053  1.00  0.00           H  
ATOM    809  HG2 PRO A  55     -13.190   4.920   0.494  1.00  0.00           H  
ATOM    810  HG3 PRO A  55     -13.752   5.772  -0.930  1.00  0.00           H  
ATOM    811  HD2 PRO A  55     -14.479   3.119  -0.119  1.00  0.00           H  
ATOM    812  HD3 PRO A  55     -14.949   3.928  -1.601  1.00  0.00           H  
ATOM    813  N   SER A  56      -9.841   1.914  -1.286  1.00  0.00           N  
ATOM    814  CA  SER A  56      -8.946   1.068  -0.515  1.00  0.00           C  
ATOM    815  C   SER A  56      -7.964   1.931   0.279  1.00  0.00           C  
ATOM    816  O   SER A  56      -6.987   1.422   0.828  1.00  0.00           O  
ATOM    817  CB  SER A  56      -8.187   0.098  -1.422  1.00  0.00           C  
ATOM    818  OG  SER A  56      -7.187   0.759  -2.193  1.00  0.00           O  
ATOM    819  H   SER A  56      -9.550   2.090  -2.227  1.00  0.00           H  
ATOM    820  HA  SER A  56      -9.591   0.504   0.158  1.00  0.00           H  
ATOM    821  HB2 SER A  56      -7.721  -0.678  -0.815  1.00  0.00           H  
ATOM    822  HB3 SER A  56      -8.890  -0.400  -2.091  1.00  0.00           H  
ATOM    823  HG  SER A  56      -7.468   1.701  -2.381  1.00  0.00           H  
ATOM    824  N   ASN A  57      -8.256   3.222   0.315  1.00  0.00           N  
ATOM    825  CA  ASN A  57      -7.411   4.162   1.033  1.00  0.00           C  
ATOM    826  C   ASN A  57      -8.097   4.563   2.340  1.00  0.00           C  
ATOM    827  O   ASN A  57      -7.706   5.539   2.977  1.00  0.00           O  
ATOM    828  CB  ASN A  57      -7.178   5.432   0.212  1.00  0.00           C  
ATOM    829  CG  ASN A  57      -5.865   5.347  -0.568  1.00  0.00           C  
ATOM    830  OD1 ASN A  57      -5.300   4.284  -0.771  1.00  0.00           O  
ATOM    831  ND2 ASN A  57      -5.410   6.523  -0.991  1.00  0.00           N  
ATOM    832  H   ASN A  57      -9.053   3.629  -0.134  1.00  0.00           H  
ATOM    833  HA  ASN A  57      -6.473   3.632   1.200  1.00  0.00           H  
ATOM    834  HB2 ASN A  57      -8.007   5.579  -0.480  1.00  0.00           H  
ATOM    835  HB3 ASN A  57      -7.157   6.297   0.874  1.00  0.00           H  
ATOM    836 HD21 ASN A  57      -5.921   7.358  -0.791  1.00  0.00           H  
ATOM    837 HD22 ASN A  57      -4.557   6.572  -1.511  1.00  0.00           H  
ATOM    838  N   PHE A  58      -9.111   3.788   2.701  1.00  0.00           N  
ATOM    839  CA  PHE A  58      -9.855   4.051   3.921  1.00  0.00           C  
ATOM    840  C   PHE A  58     -10.146   2.753   4.677  1.00  0.00           C  
ATOM    841  O   PHE A  58     -11.184   2.625   5.322  1.00  0.00           O  
ATOM    842  CB  PHE A  58     -11.180   4.693   3.507  1.00  0.00           C  
ATOM    843  CG  PHE A  58     -11.094   6.202   3.270  1.00  0.00           C  
ATOM    844  CD1 PHE A  58     -10.908   7.045   4.322  1.00  0.00           C  
ATOM    845  CD2 PHE A  58     -11.203   6.701   2.010  1.00  0.00           C  
ATOM    846  CE1 PHE A  58     -10.828   8.446   4.103  1.00  0.00           C  
ATOM    847  CE2 PHE A  58     -11.123   8.102   1.791  1.00  0.00           C  
ATOM    848  CZ  PHE A  58     -10.937   8.945   2.842  1.00  0.00           C  
ATOM    849  H   PHE A  58      -9.423   2.996   2.178  1.00  0.00           H  
ATOM    850  HA  PHE A  58      -9.240   4.701   4.543  1.00  0.00           H  
ATOM    851  HB2 PHE A  58     -11.536   4.213   2.594  1.00  0.00           H  
ATOM    852  HB3 PHE A  58     -11.924   4.499   4.280  1.00  0.00           H  
ATOM    853  HD1 PHE A  58     -10.821   6.646   5.332  1.00  0.00           H  
ATOM    854  HD2 PHE A  58     -11.352   6.026   1.167  1.00  0.00           H  
ATOM    855  HE1 PHE A  58     -10.679   9.122   4.945  1.00  0.00           H  
ATOM    856  HE2 PHE A  58     -11.209   8.501   0.780  1.00  0.00           H  
ATOM    857  HZ  PHE A  58     -10.875  10.020   2.674  1.00  0.00           H  
ATOM    858  N   ILE A  59      -9.209   1.821   4.570  1.00  0.00           N  
ATOM    859  CA  ILE A  59      -9.351   0.537   5.236  1.00  0.00           C  
ATOM    860  C   ILE A  59      -7.990   0.097   5.779  1.00  0.00           C  
ATOM    861  O   ILE A  59      -7.025   0.859   5.741  1.00  0.00           O  
ATOM    862  CB  ILE A  59      -9.998  -0.483   4.297  1.00  0.00           C  
ATOM    863  CG1 ILE A  59      -9.317  -0.477   2.926  1.00  0.00           C  
ATOM    864  CG2 ILE A  59     -11.506  -0.250   4.189  1.00  0.00           C  
ATOM    865  CD1 ILE A  59      -8.109  -1.415   2.910  1.00  0.00           C  
ATOM    866  H   ILE A  59      -8.367   1.933   4.043  1.00  0.00           H  
ATOM    867  HA  ILE A  59     -10.030   0.679   6.076  1.00  0.00           H  
ATOM    868  HB  ILE A  59      -9.856  -1.476   4.723  1.00  0.00           H  
ATOM    869 HG12 ILE A  59     -10.030  -0.783   2.161  1.00  0.00           H  
ATOM    870 HG13 ILE A  59      -8.999   0.536   2.679  1.00  0.00           H  
ATOM    871 HG21 ILE A  59     -12.036  -1.158   4.478  1.00  0.00           H  
ATOM    872 HG22 ILE A  59     -11.795   0.566   4.851  1.00  0.00           H  
ATOM    873 HG23 ILE A  59     -11.761   0.009   3.161  1.00  0.00           H  
ATOM    874 HD11 ILE A  59      -7.711  -1.512   3.920  1.00  0.00           H  
ATOM    875 HD12 ILE A  59      -8.415  -2.395   2.544  1.00  0.00           H  
ATOM    876 HD13 ILE A  59      -7.340  -1.006   2.254  1.00  0.00           H  
ATOM    877  N   LYS A  60      -7.956  -1.132   6.274  1.00  0.00           N  
ATOM    878  CA  LYS A  60      -6.730  -1.683   6.825  1.00  0.00           C  
ATOM    879  C   LYS A  60      -6.723  -3.200   6.623  1.00  0.00           C  
ATOM    880  O   LYS A  60      -7.428  -3.926   7.322  1.00  0.00           O  
ATOM    881  CB  LYS A  60      -6.560  -1.256   8.284  1.00  0.00           C  
ATOM    882  CG  LYS A  60      -7.764  -1.684   9.125  1.00  0.00           C  
ATOM    883  CD  LYS A  60      -7.948  -0.759  10.330  1.00  0.00           C  
ATOM    884  CE  LYS A  60      -7.415  -1.411  11.608  1.00  0.00           C  
ATOM    885  NZ  LYS A  60      -5.940  -1.303  11.669  1.00  0.00           N  
ATOM    886  H   LYS A  60      -8.746  -1.745   6.301  1.00  0.00           H  
ATOM    887  HA  LYS A  60      -5.899  -1.256   6.265  1.00  0.00           H  
ATOM    888  HB2 LYS A  60      -5.651  -1.698   8.692  1.00  0.00           H  
ATOM    889  HB3 LYS A  60      -6.439  -0.175   8.339  1.00  0.00           H  
ATOM    890  HG2 LYS A  60      -8.665  -1.669   8.511  1.00  0.00           H  
ATOM    891  HG3 LYS A  60      -7.628  -2.710   9.467  1.00  0.00           H  
ATOM    892  HD2 LYS A  60      -7.427   0.182  10.154  1.00  0.00           H  
ATOM    893  HD3 LYS A  60      -9.004  -0.521  10.453  1.00  0.00           H  
ATOM    894  HE2 LYS A  60      -7.856  -0.930  12.481  1.00  0.00           H  
ATOM    895  HE3 LYS A  60      -7.709  -2.461  11.638  1.00  0.00           H  
ATOM    896  HZ1 LYS A  60      -5.680  -0.344  11.780  1.00  0.00           H  
ATOM    897  HZ2 LYS A  60      -5.598  -1.832  12.445  1.00  0.00           H  
ATOM    898  HZ3 LYS A  60      -5.544  -1.660  10.823  1.00  0.00           H  
ATOM    899  N   GLU A  61      -5.918  -3.633   5.664  1.00  0.00           N  
ATOM    900  CA  GLU A  61      -5.808  -5.050   5.362  1.00  0.00           C  
ATOM    901  C   GLU A  61      -5.540  -5.847   6.640  1.00  0.00           C  
ATOM    902  O   GLU A  61      -5.177  -5.276   7.667  1.00  0.00           O  
ATOM    903  CB  GLU A  61      -4.720  -5.305   4.318  1.00  0.00           C  
ATOM    904  CG  GLU A  61      -4.792  -4.277   3.187  1.00  0.00           C  
ATOM    905  CD  GLU A  61      -3.655  -3.260   3.298  1.00  0.00           C  
ATOM    906  OE1 GLU A  61      -2.521  -3.704   3.579  1.00  0.00           O  
ATOM    907  OE2 GLU A  61      -3.946  -2.061   3.100  1.00  0.00           O  
ATOM    908  H   GLU A  61      -5.347  -3.036   5.101  1.00  0.00           H  
ATOM    909  HA  GLU A  61      -6.775  -5.333   4.947  1.00  0.00           H  
ATOM    910  HB2 GLU A  61      -3.739  -5.262   4.791  1.00  0.00           H  
ATOM    911  HB3 GLU A  61      -4.832  -6.309   3.908  1.00  0.00           H  
ATOM    912  HG2 GLU A  61      -4.738  -4.786   2.224  1.00  0.00           H  
ATOM    913  HG3 GLU A  61      -5.751  -3.761   3.221  1.00  0.00           H  
ATOM    914  N   LEU A  62      -5.728  -7.154   6.536  1.00  0.00           N  
ATOM    915  CA  LEU A  62      -5.510  -8.035   7.671  1.00  0.00           C  
ATOM    916  C   LEU A  62      -4.877  -9.340   7.184  1.00  0.00           C  
ATOM    917  O   LEU A  62      -5.461 -10.050   6.366  1.00  0.00           O  
ATOM    918  CB  LEU A  62      -6.811  -8.235   8.450  1.00  0.00           C  
ATOM    919  CG  LEU A  62      -7.680  -6.990   8.637  1.00  0.00           C  
ATOM    920  CD1 LEU A  62      -9.161  -7.362   8.719  1.00  0.00           C  
ATOM    921  CD2 LEU A  62      -7.224  -6.181   9.854  1.00  0.00           C  
ATOM    922  H   LEU A  62      -6.023  -7.612   5.696  1.00  0.00           H  
ATOM    923  HA  LEU A  62      -4.807  -7.539   8.339  1.00  0.00           H  
ATOM    924  HB2 LEU A  62      -7.404  -8.995   7.940  1.00  0.00           H  
ATOM    925  HB3 LEU A  62      -6.564  -8.632   9.434  1.00  0.00           H  
ATOM    926  HG  LEU A  62      -7.556  -6.352   7.762  1.00  0.00           H  
ATOM    927 HD11 LEU A  62      -9.548  -7.099   9.703  1.00  0.00           H  
ATOM    928 HD12 LEU A  62      -9.715  -6.819   7.954  1.00  0.00           H  
ATOM    929 HD13 LEU A  62      -9.276  -8.434   8.558  1.00  0.00           H  
ATOM    930 HD21 LEU A  62      -8.096  -5.800  10.384  1.00  0.00           H  
ATOM    931 HD22 LEU A  62      -6.645  -6.821  10.520  1.00  0.00           H  
ATOM    932 HD23 LEU A  62      -6.606  -5.347   9.524  1.00  0.00           H  
ATOM    933  N   SER A  63      -3.693  -9.617   7.707  1.00  0.00           N  
ATOM    934  CA  SER A  63      -2.974 -10.825   7.336  1.00  0.00           C  
ATOM    935  C   SER A  63      -2.297 -11.430   8.568  1.00  0.00           C  
ATOM    936  O   SER A  63      -1.904 -10.708   9.482  1.00  0.00           O  
ATOM    937  CB  SER A  63      -1.938 -10.537   6.248  1.00  0.00           C  
ATOM    938  OG  SER A  63      -1.250 -11.717   5.841  1.00  0.00           O  
ATOM    939  H   SER A  63      -3.225  -9.035   8.372  1.00  0.00           H  
ATOM    940  HA  SER A  63      -3.733 -11.503   6.945  1.00  0.00           H  
ATOM    941  HB2 SER A  63      -2.434 -10.091   5.385  1.00  0.00           H  
ATOM    942  HB3 SER A  63      -1.219  -9.806   6.616  1.00  0.00           H  
ATOM    943  HG  SER A  63      -0.567 -11.967   6.527  1.00  0.00           H  
ATOM    944  N   GLY A  64      -2.180 -12.749   8.551  1.00  0.00           N  
ATOM    945  CA  GLY A  64      -1.557 -13.460   9.655  1.00  0.00           C  
ATOM    946  C   GLY A  64      -2.507 -13.559  10.849  1.00  0.00           C  
ATOM    947  O   GLY A  64      -3.680 -13.202  10.745  1.00  0.00           O  
ATOM    948  H   GLY A  64      -2.503 -13.330   7.802  1.00  0.00           H  
ATOM    949  HA2 GLY A  64      -1.268 -14.460   9.331  1.00  0.00           H  
ATOM    950  HA3 GLY A  64      -0.644 -12.945   9.954  1.00  0.00           H  
ATOM    951  N   PRO A  65      -1.953 -14.059  11.985  1.00  0.00           N  
ATOM    952  CA  PRO A  65      -2.738 -14.211  13.199  1.00  0.00           C  
ATOM    953  C   PRO A  65      -2.975 -12.857  13.870  1.00  0.00           C  
ATOM    954  O   PRO A  65      -2.531 -12.630  14.994  1.00  0.00           O  
ATOM    955  CB  PRO A  65      -1.941 -15.172  14.066  1.00  0.00           C  
ATOM    956  CG  PRO A  65      -0.525 -15.159  13.510  1.00  0.00           C  
ATOM    957  CD  PRO A  65      -0.567 -14.493  12.145  1.00  0.00           C  
ATOM    958  HA  PRO A  65      -3.645 -14.572  12.982  1.00  0.00           H  
ATOM    959  HB2 PRO A  65      -1.953 -14.858  15.109  1.00  0.00           H  
ATOM    960  HB3 PRO A  65      -2.366 -16.175  14.029  1.00  0.00           H  
ATOM    961  HG2 PRO A  65       0.142 -14.617  14.179  1.00  0.00           H  
ATOM    962  HG3 PRO A  65      -0.140 -16.175  13.428  1.00  0.00           H  
ATOM    963  HD2 PRO A  65       0.120 -13.649  12.095  1.00  0.00           H  
ATOM    964  HD3 PRO A  65      -0.276 -15.187  11.356  1.00  0.00           H  
ATOM    965  N   SER A  66      -3.675 -11.991  13.151  1.00  0.00           N  
ATOM    966  CA  SER A  66      -3.978 -10.665  13.664  1.00  0.00           C  
ATOM    967  C   SER A  66      -5.421 -10.616  14.170  1.00  0.00           C  
ATOM    968  O   SER A  66      -6.354 -10.469  13.382  1.00  0.00           O  
ATOM    969  CB  SER A  66      -3.755  -9.597  12.591  1.00  0.00           C  
ATOM    970  OG  SER A  66      -2.766  -8.648  12.980  1.00  0.00           O  
ATOM    971  H   SER A  66      -4.033 -12.183  12.237  1.00  0.00           H  
ATOM    972  HA  SER A  66      -3.279 -10.506  14.484  1.00  0.00           H  
ATOM    973  HB2 SER A  66      -3.452 -10.075  11.660  1.00  0.00           H  
ATOM    974  HB3 SER A  66      -4.695  -9.080  12.393  1.00  0.00           H  
ATOM    975  HG  SER A  66      -2.272  -8.320  12.176  1.00  0.00           H  
ATOM    976  N   SER A  67      -5.559 -10.743  15.481  1.00  0.00           N  
ATOM    977  CA  SER A  67      -6.872 -10.715  16.102  1.00  0.00           C  
ATOM    978  C   SER A  67      -6.903  -9.664  17.214  1.00  0.00           C  
ATOM    979  O   SER A  67      -5.864  -9.313  17.770  1.00  0.00           O  
ATOM    980  CB  SER A  67      -7.247 -12.090  16.660  1.00  0.00           C  
ATOM    981  OG  SER A  67      -7.713 -12.971  15.642  1.00  0.00           O  
ATOM    982  H   SER A  67      -4.794 -10.863  16.115  1.00  0.00           H  
ATOM    983  HA  SER A  67      -7.563 -10.448  15.304  1.00  0.00           H  
ATOM    984  HB2 SER A  67      -6.379 -12.531  17.152  1.00  0.00           H  
ATOM    985  HB3 SER A  67      -8.018 -11.974  17.421  1.00  0.00           H  
ATOM    986  HG  SER A  67      -6.990 -13.614  15.390  1.00  0.00           H  
ATOM    987  N   GLY A  68      -8.107  -9.192  17.504  1.00  0.00           N  
ATOM    988  CA  GLY A  68      -8.287  -8.189  18.539  1.00  0.00           C  
ATOM    989  C   GLY A  68      -8.251  -8.824  19.931  1.00  0.00           C  
ATOM    990  O   GLY A  68      -9.152  -9.576  20.297  1.00  0.00           O  
ATOM    991  H   GLY A  68      -8.947  -9.483  17.047  1.00  0.00           H  
ATOM    992  HA2 GLY A  68      -7.504  -7.435  18.459  1.00  0.00           H  
ATOM    993  HA3 GLY A  68      -9.238  -7.677  18.393  1.00  0.00           H  
TER     994      GLY A  68                                                      
END
MOLECULE T0462_77_143.pdb
ATOM   1204  N   GLU    77      -2.454  -0.642   9.985  1.00 11.51           N 
ATOM   1205  CA  GLU    77      -3.612  -0.786   9.094  1.00 13.44           C 
ATOM   1206  C   GLU    77      -3.312  -0.215   7.697  1.00  2.42           C 
ATOM   1207  O   GLU    77      -2.423   0.626   7.539  1.00 25.04           O 
ATOM   1208  CB  GLU    77      -4.862  -0.141   9.730  1.00 44.40           C 
ATOM   1209  CG  GLU    77      -4.619   1.193  10.448  1.00 34.41           C 
ATOM   1210  CD  GLU    77      -4.730   2.413   9.544  1.00 50.11           C 
ATOM   1211  OE1 GLU    77      -3.899   3.342   9.674  1.00 42.31           O 
ATOM   1212  OE2 GLU    77      -5.670   2.469   8.730  1.00 32.01           O 
ATOM   1213  H   GLU    77      -1.869   0.136   9.876  1.00 36.29           H 
ATOM   1214  HA  GLU    77      -3.795  -1.847   8.981  1.00 15.42           H 
ATOM   1215 3HB  GLU    77      -5.272  -0.837  10.449  1.00 36.29           H 
ATOM   1216 2HB  GLU    77      -5.600   0.023   8.957  1.00 36.29           H 
ATOM   1217 3HG  GLU    77      -3.628   1.173  10.883  1.00 36.29           H 
ATOM   1218 2HG  GLU    77      -5.349   1.296  11.240  1.00 36.29           H 
ATOM   1219  N   LEU    78      -4.045  -0.688   6.685  1.00 42.42           N 
ATOM   1220  CA  LEU    78      -3.726  -0.377   5.282  1.00 60.21           C 
ATOM   1221  C   LEU    78      -4.996  -0.222   4.419  1.00 62.54           C 
ATOM   1222  O   LEU    78      -6.044  -0.782   4.736  1.00  4.41           O 
ATOM   1223  CB  LEU    78      -2.814  -1.473   4.686  1.00 61.43           C 
ATOM   1224  CG  LEU    78      -3.447  -2.870   4.491  1.00 11.44           C 
ATOM   1225  CD1 LEU    78      -2.505  -3.774   3.701  1.00 12.40           C 
ATOM   1226  CD2 LEU    78      -3.799  -3.519   5.833  1.00 74.53           C 
ATOM   1227  H   LEU    78      -4.830  -1.244   6.884  1.00 36.29           H 
ATOM   1228  HA  LEU    78      -3.189   0.561   5.269  1.00 44.34           H 
ATOM   1229 3HB  LEU    78      -1.956  -1.581   5.336  1.00 36.29           H 
ATOM   1230 2HB  LEU    78      -2.465  -1.127   3.723  1.00 36.29           H 
ATOM   1231  HG  LEU    78      -4.358  -2.767   3.919  1.00 65.12           H 
ATOM   1232 1HD1 LEU    78      -2.985  -4.725   3.521  1.00 36.29           H 
ATOM   1233 2HD1 LEU    78      -1.595  -3.932   4.264  1.00 36.29           H 
ATOM   1234 3HD1 LEU    78      -2.265  -3.308   2.756  1.00 36.29           H 
ATOM   1235 1HD2 LEU    78      -4.537  -2.918   6.341  1.00 36.29           H 
ATOM   1236 2HD2 LEU    78      -2.912  -3.593   6.445  1.00 36.29           H 
ATOM   1237 3HD2 LEU    78      -4.200  -4.508   5.661  1.00 36.29           H 
ATOM   1238  N   PRO    79      -4.915   0.544   3.306  1.00 33.21           N 
ATOM   1239  CA  PRO    79      -6.069   0.774   2.413  1.00  3.41           C 
ATOM   1240  C   PRO    79      -6.473  -0.476   1.601  1.00 53.44           C 
ATOM   1241  O   PRO    79      -5.633  -1.315   1.265  1.00 30.11           O 
ATOM   1242  CB  PRO    79      -5.572   1.889   1.482  1.00 60.14           C 
ATOM   1243  CG  PRO    79      -4.091   1.726   1.458  1.00  3.44           C 
ATOM   1244  CD  PRO    79      -3.705   1.251   2.834  1.00 21.25           C 
ATOM   1245  HA  PRO    79      -6.926   1.127   2.970  1.00 32.11           H 
ATOM   1246 3HB  PRO    79      -5.852   2.854   1.884  1.00 36.29           H 
ATOM   1247 2HB  PRO    79      -6.001   1.766   0.497  1.00 36.29           H 
ATOM   1248 3HG  PRO    79      -3.618   2.673   1.241  1.00 36.29           H 
ATOM   1249 2HG  PRO    79      -3.814   0.990   0.716  1.00 36.29           H 
ATOM   1250 3HD  PRO    79      -3.475   2.091   3.474  1.00 36.29           H 
ATOM   1251 2HD  PRO    79      -2.861   0.577   2.779  1.00 36.29           H 
ATOM   1252  N   LEU    80      -7.765  -0.571   1.270  1.00 10.14           N 
ATOM   1253  CA  LEU    80      -8.322  -1.726   0.538  1.00 12.24           C 
ATOM   1254  C   LEU    80      -7.531  -2.084  -0.732  1.00 71.04           C 
ATOM   1255  O   LEU    80      -7.179  -3.245  -0.943  1.00 34.43           O 
ATOM   1256  CB  LEU    80      -9.787  -1.452   0.162  1.00 13.14           C 
ATOM   1257  CG  LEU    80     -10.808  -1.614   1.299  1.00 54.21           C 
ATOM   1258  CD1 LEU    80     -12.201  -1.194   0.838  1.00 12.24           C 
ATOM   1259  CD2 LEU    80     -10.824  -3.057   1.801  1.00 34.31           C 
ATOM   1260  H   LEU    80      -8.371   0.157   1.533  1.00 36.29           H 
ATOM   1261  HA  LEU    80      -8.296  -2.574   1.206  1.00 73.22           H 
ATOM   1262 3HB  LEU    80     -10.066  -2.124  -0.639  1.00 36.29           H 
ATOM   1263 2HB  LEU    80      -9.855  -0.438  -0.210  1.00 36.29           H 
ATOM   1264  HG  LEU    80     -10.523  -0.976   2.125  1.00 14.14           H 
ATOM   1265 1HD1 LEU    80     -12.900  -1.307   1.654  1.00 36.29           H 
ATOM   1266 2HD1 LEU    80     -12.514  -1.813   0.008  1.00 36.29           H 
ATOM   1267 3HD1 LEU    80     -12.181  -0.159   0.526  1.00 36.29           H 
ATOM   1268 1HD2 LEU    80     -11.535  -3.148   2.610  1.00 36.29           H 
ATOM   1269 2HD2 LEU    80      -9.841  -3.325   2.157  1.00 36.29           H 
ATOM   1270 3HD2 LEU    80     -11.109  -3.720   0.996  1.00 36.29           H 
ATOM   1271  N   ILE    81      -7.255  -1.088  -1.570  1.00 44.14           N 
ATOM   1272  CA  ILE    81      -6.604  -1.322  -2.871  1.00 50.44           C 
ATOM   1273  C   ILE    81      -5.189  -1.920  -2.721  1.00 33.22           C 
ATOM   1274  O   ILE    81      -4.653  -2.514  -3.657  1.00 43.13           O 
ATOM   1275  CB  ILE    81      -6.528  -0.010  -3.698  1.00 35.34           C 
ATOM   1276  CG1 ILE    81      -6.096  -0.294  -5.148  1.00 45.22           C 
ATOM   1277  CG2 ILE    81      -5.576   0.987  -3.044  1.00 11.34           C 
ATOM   1278  CD1 ILE    81      -7.036  -1.214  -5.900  1.00  2.11           C 
ATOM   1279  H   ILE    81      -7.502  -0.174  -1.317  1.00 36.29           H 
ATOM   1280  HA  ILE    81      -7.218  -2.025  -3.417  1.00  3.54           H 
ATOM   1281  HB  ILE    81      -7.513   0.435  -3.708  1.00 64.25           H 
ATOM   1282 3HG1 ILE    81      -5.116  -0.753  -5.144  1.00 36.29           H 
ATOM   1283 2HG1 ILE    81      -6.047   0.637  -5.692  1.00 36.29           H 
ATOM   1284 1HG2 ILE    81      -5.915   1.203  -2.040  1.00 36.29           H 
ATOM   1285 2HG2 ILE    81      -5.556   1.901  -3.620  1.00 36.29           H 
ATOM   1286 3HG2 ILE    81      -4.583   0.565  -3.003  1.00 36.29           H 
ATOM   1287 1HD1 ILE    81      -7.069  -2.176  -5.410  1.00 36.29           H 
ATOM   1288 2HD1 ILE    81      -6.681  -1.338  -6.912  1.00 36.29           H 
ATOM   1289 3HD1 ILE    81      -8.027  -0.784  -5.915  1.00 36.29           H 
ATOM   1290  N   LEU    82      -4.590  -1.765  -1.542  1.00 13.21           N 
ATOM   1291  CA  LEU    82      -3.229  -2.263  -1.295  1.00 75.44           C 
ATOM   1292  C   LEU    82      -3.235  -3.478  -0.352  1.00 14.20           C 
ATOM   1293  O   LEU    82      -2.176  -3.964   0.063  1.00 74.13           O 
ATOM   1294  CB  LEU    82      -2.366  -1.146  -0.695  1.00 53.44           C 
ATOM   1295  CG  LEU    82      -2.352   0.178  -1.474  1.00 23.25           C 
ATOM   1296  CD1 LEU    82      -1.386   1.167  -0.831  1.00 12.00           C 
ATOM   1297  CD2 LEU    82      -2.003  -0.053  -2.944  1.00 23.35           C 
ATOM   1298  H   LEU    82      -5.070  -1.312  -0.819  1.00 36.29           H 
ATOM   1299  HA  LEU    82      -2.804  -2.562  -2.243  1.00 41.41           H 
ATOM   1300 3HB  LEU    82      -1.349  -1.508  -0.628  1.00 36.29           H 
ATOM   1301 2HB  LEU    82      -2.723  -0.944   0.306  1.00 36.29           H 
ATOM   1302  HG  LEU    82      -3.341   0.615  -1.434  1.00 42.03           H 
ATOM   1303 1HD1 LEU    82      -1.403   2.098  -1.381  1.00 36.29           H 
ATOM   1304 2HD1 LEU    82      -0.385   0.760  -0.844  1.00 36.29           H 
ATOM   1305 3HD1 LEU    82      -1.686   1.348   0.191  1.00 36.29           H 
ATOM   1306 1HD2 LEU    82      -1.038  -0.530  -3.018  1.00 36.29           H 
ATOM   1307 2HD2 LEU    82      -1.974   0.897  -3.460  1.00 36.29           H 
ATOM   1308 3HD2 LEU    82      -2.754  -0.683  -3.398  1.00 36.29           H 
ATOM   1309  N   ALA    83      -4.428  -3.973  -0.032  1.00 32.45           N 
ATOM   1310  CA  ALA    83      -4.592  -5.071   0.925  1.00 15.43           C 
ATOM   1311  C   ALA    83      -4.014  -6.403   0.410  1.00 54.30           C 
ATOM   1312  O   ALA    83      -3.799  -6.591  -0.789  1.00 23.30           O 
ATOM   1313  CB  ALA    83      -6.067  -5.236   1.279  1.00 62.03           C 
ATOM   1314  H   ALA    83      -5.227  -3.589  -0.453  1.00 36.29           H 
ATOM   1315  HA  ALA    83      -4.066  -4.796   1.829  1.00  1.41           H 
ATOM   1316 1HB  ALA    83      -6.462  -4.293   1.627  1.00 36.29           H 
ATOM   1317 2HB  ALA    83      -6.170  -5.977   2.061  1.00 36.29           H 
ATOM   1318 3HB  ALA    83      -6.616  -5.558   0.406  1.00 36.29           H 
ATOM   1319  N   ASP    84      -3.760  -7.320   1.339  1.00 24.33           N 
ATOM   1320  CA  ASP    84      -3.272  -8.663   1.014  1.00 10.43           C 
ATOM   1321  C   ASP    84      -4.400  -9.512   0.385  1.00 31.22           C 
ATOM   1322  O   ASP    84      -4.529  -9.582  -0.842  1.00  1.44           O 
ATOM   1323  CB  ASP    84      -2.725  -9.313   2.296  1.00 12.14           C 
ATOM   1324  CG  ASP    84      -2.271 -10.747   2.104  1.00 72.45           C 
ATOM   1325  OD1 ASP    84      -3.012 -11.668   2.515  1.00 44.41           O 
ATOM   1326  OD2 ASP    84      -1.169 -10.955   1.558  1.00 25.23           O 
ATOM   1327  H   ASP    84      -3.901  -7.087   2.281  1.00 36.29           H 
ATOM   1328  HA  ASP    84      -2.469  -8.563   0.297  1.00 73.24           H 
ATOM   1329 3HB  ASP    84      -3.498  -9.296   3.051  1.00 36.29           H 
ATOM   1330 2HB  ASP    84      -1.883  -8.736   2.646  1.00 36.29           H 
ATOM   1331  N   ASP    85      -5.236 -10.120   1.232  1.00 43.24           N 
ATOM   1332  CA  ASP    85      -6.389 -10.904   0.774  1.00 10.24           C 
ATOM   1333  C   ASP    85      -7.229 -11.390   1.973  1.00  1.54           C 
ATOM   1334  O   ASP    85      -6.831 -11.223   3.127  1.00  0.32           O 
ATOM   1335  CB  ASP    85      -5.918 -12.100  -0.067  1.00 10.35           C 
ATOM   1336  CG  ASP    85      -7.046 -12.723  -0.867  1.00 21.21           C 
ATOM   1337  OD1 ASP    85      -7.689 -13.662  -0.366  1.00 45.32           O 
ATOM   1338  OD2 ASP    85      -7.309 -12.253  -1.993  1.00 50.25           O 
ATOM   1339  H   ASP    85      -5.066 -10.052   2.195  1.00 36.29           H 
ATOM   1340  HA  ASP    85      -7.004 -10.260   0.160  1.00  3.02           H 
ATOM   1341 3HB  ASP    85      -5.500 -12.853   0.587  1.00 36.29           H 
ATOM   1342 2HB  ASP    85      -5.153 -11.769  -0.756  1.00 36.29           H 
ATOM   1343  N   GLY    86      -8.394 -11.971   1.690  1.00 44.14           N 
ATOM   1344  CA  GLY    86      -9.235 -12.538   2.741  1.00 21.12           C 
ATOM   1345  C   GLY    86     -10.194 -11.536   3.378  1.00 41.53           C 
ATOM   1346  O   GLY    86     -10.603 -10.553   2.752  1.00 64.33           O 
ATOM   1347  H   GLY    86      -8.685 -12.028   0.756  1.00 36.29           H 
ATOM   1348 3HA  GLY    86      -8.598 -12.948   3.513  1.00 36.29           H 
ATOM   1349 2HA  GLY    86      -9.816 -13.343   2.314  1.00 36.29           H 
ATOM   1350  N   THR    87     -10.558 -11.795   4.635  1.00 35.13           N 
ATOM   1351  CA  THR    87     -11.509 -10.952   5.372  1.00 72.12           C 
ATOM   1352  C   THR    87     -10.799  -9.812   6.129  1.00 24.21           C 
ATOM   1353  O   THR    87      -9.826 -10.043   6.858  1.00 41.52           O 
ATOM   1354  CB  THR    87     -12.318 -11.785   6.400  1.00  0.32           C 
ATOM   1355  OG1 THR    87     -12.695 -13.054   5.838  1.00 42.15           O 
ATOM   1356  CG2 THR    87     -13.571 -11.036   6.845  1.00 42.41           C 
ATOM   1357  H   THR    87     -10.189 -12.586   5.077  1.00 36.29           H 
ATOM   1358  HA  THR    87     -12.203 -10.525   4.660  1.00 32.51           H 
ATOM   1359  HB  THR    87     -11.696 -11.961   7.268  1.00  2.24           H 
ATOM   1360  HG1 THR    87     -13.011 -12.935   4.931  1.00 64.23           H 
ATOM   1361 1HG2 THR    87     -14.114 -11.637   7.560  1.00 36.29           H 
ATOM   1362 2HG2 THR    87     -14.199 -10.838   5.989  1.00 36.29           H 
ATOM   1363 3HG2 THR    87     -13.288 -10.100   7.309  1.00 36.29           H 
ATOM   1364  N   TYR    88     -11.299  -8.585   5.964  1.00  4.25           N 
ATOM   1365  CA  TYR    88     -10.751  -7.403   6.652  1.00 21.51           C 
ATOM   1366  C   TYR    88     -11.807  -6.696   7.502  1.00 53.21           C 
ATOM   1367  O   TYR    88     -12.994  -6.942   7.359  1.00 53.41           O 
ATOM   1368  CB  TYR    88     -10.188  -6.406   5.634  1.00 52.03           C 
ATOM   1369  CG  TYR    88      -8.939  -6.890   4.940  1.00 31.22           C 
ATOM   1370  CD1 TYR    88      -9.013  -7.749   3.853  1.00 74.10           C 
ATOM   1371  CD2 TYR    88      -7.682  -6.496   5.382  1.00 54.22           C 
ATOM   1372  CE1 TYR    88      -7.874  -8.199   3.229  1.00 43.52           C 
ATOM   1373  CE2 TYR    88      -6.538  -6.941   4.759  1.00 42.24           C 
ATOM   1374  CZ  TYR    88      -6.642  -7.794   3.687  1.00 14.22           C 
ATOM   1375  OH  TYR    88      -5.509  -8.243   3.067  1.00 72.21           O 
ATOM   1376  H   TYR    88     -12.058  -8.465   5.355  1.00 36.29           H 
ATOM   1377  HA  TYR    88      -9.949  -7.733   7.299  1.00 13.41           H 
ATOM   1378 3HB  TYR    88      -9.950  -5.480   6.142  1.00 36.29           H 
ATOM   1379 2HB  TYR    88     -10.936  -6.210   4.877  1.00 36.29           H 
ATOM   1380  HD1 TYR    88      -9.983  -8.066   3.498  1.00 20.13           H 
ATOM   1381  HD2 TYR    88      -7.608  -5.825   6.225  1.00 62.02           H 
ATOM   1382  HE1 TYR    88      -7.950  -8.866   2.384  1.00 32.42           H 
ATOM   1383  HE2 TYR    88      -5.568  -6.625   5.117  1.00  4.31           H 
ATOM   1384  HH  TYR    88      -5.635  -8.200   2.112  1.00 71.22           H 
ATOM   1385  N   GLU    89     -11.354  -5.812   8.384  1.00 22.34           N 
ATOM   1386  CA  GLU    89     -12.251  -4.984   9.201  1.00 23.21           C 
ATOM   1387  C   GLU    89     -11.974  -3.490   8.965  1.00 54.21           C 
ATOM   1388  O   GLU    89     -10.836  -3.037   9.092  1.00 64.32           O 
ATOM   1389  CB  GLU    89     -12.069  -5.321  10.687  1.00 22.21           C 
ATOM   1390  CG  GLU    89     -12.930  -4.480  11.626  1.00 63.13           C 
ATOM   1391  CD  GLU    89     -12.663  -4.780  13.092  1.00 60.50           C 
ATOM   1392  OE1 GLU    89     -13.470  -5.499  13.719  1.00 25.53           O 
ATOM   1393  OE2 GLU    89     -11.647  -4.290  13.623  1.00 33.14           O 
ATOM   1394  H   GLU    89     -10.386  -5.716   8.500  1.00 36.29           H 
ATOM   1395  HA  GLU    89     -13.270  -5.201   8.910  1.00 11.21           H 
ATOM   1396 3HB  GLU    89     -11.032  -5.172  10.954  1.00 36.29           H 
ATOM   1397 2HB  GLU    89     -12.321  -6.362  10.840  1.00 36.29           H 
ATOM   1398 3HG  GLU    89     -13.972  -4.676  11.413  1.00 36.29           H 
ATOM   1399 2HG  GLU    89     -12.720  -3.435  11.445  1.00 36.29           H 
ATOM   1400  N   ILE    90     -13.009  -2.728   8.613  1.00 11.51           N 
ATOM   1401  CA  ILE    90     -12.846  -1.290   8.346  1.00 53.30           C 
ATOM   1402  C   ILE    90     -12.498  -0.498   9.622  1.00 34.11           C 
ATOM   1403  O   ILE    90     -13.180  -0.604  10.649  1.00 11.23           O 
ATOM   1404  CB  ILE    90     -14.111  -0.683   7.683  1.00 24.24           C 
ATOM   1405  CG1 ILE    90     -13.926   0.830   7.453  1.00 14.23           C 
ATOM   1406  CG2 ILE    90     -15.355  -0.960   8.528  1.00 25.01           C 
ATOM   1407  CD1 ILE    90     -15.115   1.501   6.804  1.00 35.11           C 
ATOM   1408  H   ILE    90     -13.898  -3.139   8.523  1.00 36.29           H 
ATOM   1409  HA  ILE    90     -12.026  -1.185   7.649  1.00 63.25           H 
ATOM   1410  HB  ILE    90     -14.249  -1.167   6.726  1.00 75.34           H 
ATOM   1411 3HG1 ILE    90     -13.066   0.990   6.816  1.00 36.29           H 
ATOM   1412 2HG1 ILE    90     -13.757   1.313   8.403  1.00 36.29           H 
ATOM   1413 1HG2 ILE    90     -15.247  -0.488   9.495  1.00 36.29           H 
ATOM   1414 2HG2 ILE    90     -15.472  -2.026   8.660  1.00 36.29           H 
ATOM   1415 3HG2 ILE    90     -16.228  -0.562   8.031  1.00 36.29           H 
ATOM   1416 1HD1 ILE    90     -15.985   1.378   7.431  1.00 36.29           H 
ATOM   1417 2HD1 ILE    90     -15.298   1.054   5.839  1.00 36.29           H 
ATOM   1418 3HD1 ILE    90     -14.910   2.554   6.679  1.00 36.29           H 
ATOM   1419  N   THR    91     -11.430   0.300   9.546  1.00 65.23           N 
ATOM   1420  CA  THR    91     -10.965   1.088  10.698  1.00 35.41           C 
ATOM   1421  C   THR    91     -11.241   2.593  10.535  1.00 43.23           C 
ATOM   1422  O   THR    91     -11.580   3.267  11.506  1.00 23.55           O 
ATOM   1423  CB  THR    91      -9.454   0.868  10.974  1.00 14.21           C 
ATOM   1424  OG1 THR    91      -9.022   1.680  12.077  1.00 73.21           O 
ATOM   1425  CG2 THR    91      -8.603   1.180   9.745  1.00 34.25           C 
ATOM   1426  H   THR    91     -10.940   0.357   8.697  1.00 36.29           H 
ATOM   1427  HA  THR    91     -11.507   0.740  11.569  1.00 61.54           H 
ATOM   1428  HB  THR    91      -9.305  -0.173  11.233  1.00 33.24           H 
ATOM   1429  HG1 THR    91      -9.720   1.708  12.747  1.00 14.23           H 
ATOM   1430 1HG2 THR    91      -8.722   2.219   9.474  1.00 36.29           H 
ATOM   1431 2HG2 THR    91      -8.916   0.555   8.920  1.00 36.29           H 
ATOM   1432 3HG2 THR    91      -7.564   0.984   9.968  1.00 36.29           H 
ATOM   1433  N   LYS    92     -11.100   3.122   9.313  1.00 42.31           N 
ATOM   1434  CA  LYS    92     -11.345   4.557   9.064  1.00 54.15           C 
ATOM   1435  C   LYS    92     -11.465   4.899   7.568  1.00 44.42           C 
ATOM   1436  O   LYS    92     -10.929   4.201   6.701  1.00 33.13           O 
ATOM   1437  CB  LYS    92     -10.233   5.419   9.682  1.00 65.22           C 
ATOM   1438  CG  LYS    92      -8.822   5.024   9.253  1.00 10.13           C 
ATOM   1439  CD  LYS    92      -7.794   6.078   9.659  1.00 64.52           C 
ATOM   1440  CE  LYS    92      -6.370   5.532   9.646  1.00  4.34           C 
ATOM   1441  NZ  LYS    92      -5.966   4.989   8.322  1.00 72.11           N 
ATOM   1442  H   LYS    92     -10.830   2.546   8.566  1.00 36.29           H 
ATOM   1443  HA  LYS    92     -12.281   4.811   9.543  1.00 11.11           H 
ATOM   1444 3HB  LYS    92     -10.293   5.338  10.759  1.00 36.29           H 
ATOM   1445 2HB  LYS    92     -10.396   6.451   9.402  1.00 36.29           H 
ATOM   1446 3HG  LYS    92      -8.801   4.907   8.176  1.00 36.29           H 
ATOM   1447 2HG  LYS    92      -8.565   4.084   9.720  1.00 36.29           H 
ATOM   1448 3HD  LYS    92      -8.024   6.427  10.656  1.00 36.29           H 
ATOM   1449 2HD  LYS    92      -7.852   6.907   8.967  1.00 36.29           H 
ATOM   1450 3HE  LYS    92      -6.301   4.743  10.378  1.00 36.29           H 
ATOM   1451 2HE  LYS    92      -5.692   6.326   9.915  1.00 36.29           H 
ATOM   1452 1HZ  LYS    92      -5.967   5.739   7.606  1.00 36.29           H 
ATOM   1453 2HZ  LYS    92      -6.620   4.235   8.030  1.00 36.29           H 
ATOM   1454 3HZ  LYS    92      -5.008   4.579   8.385  1.00 36.29           H 
ATOM   1455  N   LEU    93     -12.170   5.999   7.283  1.00 72.14           N 
ATOM   1456  CA  LEU    93     -12.288   6.540   5.919  1.00 12.31           C 
ATOM   1457  C   LEU    93     -11.469   7.838   5.779  1.00 10.13           C 
ATOM   1458  O   LEU    93     -11.050   8.430   6.777  1.00 42.13           O 
ATOM   1459  CB  LEU    93     -13.758   6.838   5.567  1.00  2.12           C 
ATOM   1460  CG  LEU    93     -14.729   5.640   5.568  1.00 63.13           C 
ATOM   1461  CD1 LEU    93     -14.168   4.482   4.754  1.00 23.14           C 
ATOM   1462  CD2 LEU    93     -15.068   5.202   6.993  1.00 50.42           C 
ATOM   1463  H   LEU    93     -12.626   6.467   8.016  1.00 36.29           H 
ATOM   1464  HA  LEU    93     -11.897   5.805   5.228  1.00 20.21           H 
ATOM   1465 3HB  LEU    93     -13.781   7.284   4.582  1.00 36.29           H 
ATOM   1466 2HB  LEU    93     -14.129   7.569   6.272  1.00 36.29           H 
ATOM   1467  HG  LEU    93     -15.652   5.949   5.093  1.00 22.03           H 
ATOM   1468 1HD1 LEU    93     -13.251   4.130   5.204  1.00 36.29           H 
ATOM   1469 2HD1 LEU    93     -13.968   4.815   3.745  1.00 36.29           H 
ATOM   1470 3HD1 LEU    93     -14.888   3.677   4.728  1.00 36.29           H 
ATOM   1471 1HD2 LEU    93     -15.746   4.363   6.959  1.00 36.29           H 
ATOM   1472 2HD2 LEU    93     -15.539   6.021   7.519  1.00 36.29           H 
ATOM   1473 3HD2 LEU    93     -14.165   4.913   7.510  1.00 36.29           H 
ATOM   1474  N   ASN    94     -11.246   8.277   4.540  1.00 74.35           N 
ATOM   1475  CA  ASN    94     -10.546   9.545   4.271  1.00 71.52           C 
ATOM   1476  C   ASN    94     -11.230  10.336   3.139  1.00 71.43           C 
ATOM   1477  O   ASN    94     -11.226   9.910   1.981  1.00 31.43           O 
ATOM   1478  CB  ASN    94      -9.078   9.279   3.908  1.00 32.31           C 
ATOM   1479  CG  ASN    94      -8.243   8.874   5.111  1.00 15.34           C 
ATOM   1480  OD1 ASN    94      -7.668   9.714   5.790  1.00  0.13           O 
ATOM   1481  ND2 ASN    94      -8.166   7.589   5.389  1.00 63.03           N 
ATOM   1482  H   ASN    94     -11.553   7.736   3.782  1.00 36.29           H 
ATOM   1483  HA  ASN    94     -10.579  10.141   5.175  1.00 70.10           H 
ATOM   1484 3HB  ASN    94      -8.649  10.176   3.483  1.00 36.29           H 
ATOM   1485 2HB  ASN    94      -9.031   8.485   3.177  1.00 36.29           H 
ATOM   1486 1HD2 ASN    94      -8.646   6.957   4.816  1.00 36.29           H 
ATOM   1487 2HD2 ASN    94      -7.625   7.321   6.157  1.00 36.29           H 
ATOM   1488  N   GLY    95     -11.820  11.485   3.478  1.00 54.24           N 
ATOM   1489  CA  GLY    95     -12.478  12.324   2.472  1.00 52.34           C 
ATOM   1490  C   GLY    95     -13.424  13.363   3.078  1.00 12.22           C 
ATOM   1491  O   GLY    95     -13.213  13.825   4.199  1.00 53.41           O 
ATOM   1492  H   GLY    95     -11.815  11.767   4.419  1.00 36.29           H 
ATOM   1493 3HA  GLY    95     -13.044  11.689   1.803  1.00 36.29           H 
ATOM   1494 2HA  GLY    95     -11.721  12.841   1.901  1.00 36.29           H 
ATOM   1495  N   GLY    96     -14.465  13.735   2.330  1.00 32.53           N 
ATOM   1496  CA  GLY    96     -15.456  14.691   2.826  1.00 24.42           C 
ATOM   1497  C   GLY    96     -16.753  14.021   3.281  1.00 74.23           C 
ATOM   1498  O   GLY    96     -16.880  12.797   3.213  1.00 22.41           O 
ATOM   1499  H   GLY    96     -14.565  13.355   1.434  1.00 36.29           H 
ATOM   1500 3HA  GLY    96     -15.685  15.392   2.035  1.00 36.29           H 
ATOM   1501 2HA  GLY    96     -15.036  15.236   3.660  1.00 36.29           H 
ATOM   1502  N   ARG    97     -17.730  14.818   3.722  1.00 73.32           N 
ATOM   1503  CA  ARG    97     -18.994  14.277   4.247  1.00  2.04           C 
ATOM   1504  C   ARG    97     -19.796  13.532   3.167  1.00  2.23           C 
ATOM   1505  O   ARG    97     -20.404  12.500   3.447  1.00 53.11           O 
ATOM   1506  CB  ARG    97     -19.858  15.386   4.873  1.00 45.22           C 
ATOM   1507  CG  ARG    97     -21.094  14.854   5.602  1.00  2.20           C 
ATOM   1508  CD  ARG    97     -21.859  15.957   6.332  1.00 61.12           C 
ATOM   1509  NE  ARG    97     -22.452  16.926   5.413  1.00 32.33           N 
ATOM   1510  CZ  ARG    97     -23.273  17.873   5.779  1.00 32.33           C 
ATOM   1511  NH1 ARG    97     -23.609  18.015   7.020  1.00  3.21           N 
ATOM   1512  NH2 ARG    97     -23.765  18.679   4.900  1.00 11.43           N 
ATOM   1513  H   ARG    97     -17.601  15.792   3.692  1.00 36.29           H 
ATOM   1514  HA  ARG    97     -18.737  13.568   5.022  1.00 11.03           H 
ATOM   1515 3HB  ARG    97     -20.185  16.059   4.092  1.00 36.29           H 
ATOM   1516 2HB  ARG    97     -19.256  15.939   5.582  1.00 36.29           H 
ATOM   1517 3HG  ARG    97     -20.782  14.109   6.321  1.00 36.29           H 
ATOM   1518 2HG  ARG    97     -21.754  14.397   4.878  1.00 36.29           H 
ATOM   1519 3HD  ARG    97     -21.177  16.472   6.995  1.00 36.29           H 
ATOM   1520 2HD  ARG    97     -22.648  15.503   6.916  1.00 36.29           H 
ATOM   1521  HE  ARG    97     -22.222  16.856   4.465  1.00 42.04           H 
ATOM   1522 1HH1 ARG    97     -23.243  17.397   7.712  1.00 36.29           H 
ATOM   1523 2HH1 ARG    97     -24.232  18.749   7.284  1.00 36.29           H 
ATOM   1524 1HH2 ARG    97     -23.519  18.578   3.938  1.00 36.29           H 
ATOM   1525 2HH2 ARG    97     -24.400  19.396   5.185  1.00 36.29           H 
ATOM   1526  N   ARG    98     -19.806  14.050   1.935  1.00 62.12           N 
ATOM   1527  CA  ARG    98     -20.482  13.349   0.830  1.00 55.01           C 
ATOM   1528  C   ARG    98     -19.751  12.044   0.482  1.00  3.21           C 
ATOM   1529  O   ARG    98     -20.380  11.035   0.162  1.00 61.24           O 
ATOM   1530  CB  ARG    98     -20.625  14.236  -0.421  1.00 33.50           C 
ATOM   1531  CG  ARG    98     -21.639  15.373  -0.262  1.00 43.41           C 
ATOM   1532  CD  ARG    98     -21.034  16.611   0.389  1.00 13.11           C 
ATOM   1533  NE  ARG    98     -20.195  17.358  -0.542  1.00 50.33           N 
ATOM   1534  CZ  ARG    98     -19.689  18.532  -0.290  1.00 64.24           C 
ATOM   1535  NH1 ARG    98     -19.838  19.083   0.871  1.00  3.54           N 
ATOM   1536  NH2 ARG    98     -19.019  19.154  -1.203  1.00 71.21           N 
ATOM   1537  H   ARG    98     -19.350  14.902   1.768  1.00 36.29           H 
ATOM   1538  HA  ARG    98     -21.473  13.091   1.181  1.00 32.24           H 
ATOM   1539 3HB  ARG    98     -20.939  13.618  -1.252  1.00 36.29           H 
ATOM   1540 2HB  ARG    98     -19.662  14.668  -0.655  1.00 36.29           H 
ATOM   1541 3HG  ARG    98     -22.461  15.023   0.349  1.00 36.29           H 
ATOM   1542 2HG  ARG    98     -22.012  15.645  -1.238  1.00 36.29           H 
ATOM   1543 3HD  ARG    98     -20.434  16.305   1.235  1.00 36.29           H 
ATOM   1544 2HD  ARG    98     -21.834  17.252   0.731  1.00 36.29           H 
ATOM   1545  HE  ARG    98     -20.026  16.961  -1.422  1.00 13.21           H 
ATOM   1546 1HH1 ARG    98     -20.345  18.610   1.587  1.00 36.29           H 
ATOM   1547 2HH1 ARG    98     -19.436  19.980   1.050  1.00 36.29           H 
ATOM   1548 1HH2 ARG    98     -18.895  18.737  -2.100  1.00 36.29           H 
ATOM   1549 2HH2 ARG    98     -18.633  20.053  -1.007  1.00 36.29           H 
ATOM   1550  N   PHE    99     -18.419  12.069   0.562  1.00  1.52           N 
ATOM   1551  CA  PHE    99     -17.618  10.848   0.421  1.00 14.23           C 
ATOM   1552  C   PHE    99     -18.048   9.806   1.468  1.00  3.12           C 
ATOM   1553  O   PHE    99     -18.276   8.636   1.148  1.00 43.23           O 
ATOM   1554  CB  PHE    99     -16.122  11.175   0.572  1.00 22.30           C 
ATOM   1555  CG  PHE    99     -15.220   9.964   0.535  1.00 62.53           C 
ATOM   1556  CD1 PHE    99     -14.787   9.438  -0.674  1.00 42.43           C 
ATOM   1557  CD2 PHE    99     -14.806   9.350   1.711  1.00 75.53           C 
ATOM   1558  CE1 PHE    99     -13.964   8.330  -0.711  1.00 72.43           C 
ATOM   1559  CE2 PHE    99     -13.982   8.242   1.679  1.00 20.21           C 
ATOM   1560  CZ  PHE    99     -13.562   7.731   0.467  1.00 72.42           C 
ATOM   1561  H   PHE    99     -17.965  12.923   0.714  1.00 36.29           H 
ATOM   1562  HA  PHE    99     -17.796  10.446  -0.568  1.00 12.34           H 
ATOM   1563 3HB  PHE    99     -15.966  11.678   1.516  1.00 36.29           H 
ATOM   1564 2HB  PHE    99     -15.823  11.835  -0.231  1.00 36.29           H 
ATOM   1565  HD1 PHE    99     -15.099   9.905  -1.597  1.00 15.13           H 
ATOM   1566  HD2 PHE    99     -15.135   9.749   2.661  1.00 32.43           H 
ATOM   1567  HE1 PHE    99     -13.636   7.931  -1.661  1.00  0.33           H 
ATOM   1568  HE2 PHE    99     -13.669   7.775   2.601  1.00 65.04           H 
ATOM   1569  HZ  PHE    99     -12.918   6.864   0.441  1.00 12.14           H 
ATOM   1570  N   LEU   100     -18.162  10.248   2.723  1.00 42.30           N 
ATOM   1571  CA  LEU   100     -18.650   9.387   3.806  1.00  4.13           C 
ATOM   1572  C   LEU   100     -20.083   8.916   3.529  1.00 51.22           C 
ATOM   1573  O   LEU   100     -20.413   7.754   3.746  1.00  4.33           O 
ATOM   1574  CB  LEU   100     -18.603  10.130   5.151  1.00 24.23           C 
ATOM   1575  CG  LEU   100     -17.214  10.620   5.591  1.00 21.10           C 
ATOM   1576  CD1 LEU   100     -17.297  11.336   6.937  1.00 11.20           C 
ATOM   1577  CD2 LEU   100     -16.222   9.459   5.656  1.00 32.53           C 
ATOM   1578  H   LEU   100     -17.907  11.174   2.928  1.00 36.29           H 
ATOM   1579  HA  LEU   100     -18.001   8.523   3.859  1.00  2.21           H 
ATOM   1580 3HB  LEU   100     -18.987   9.470   5.917  1.00 36.29           H 
ATOM   1581 2HB  LEU   100     -19.259  10.989   5.082  1.00 36.29           H 
ATOM   1582  HG  LEU   100     -16.846  11.330   4.864  1.00 45.44           H 
ATOM   1583 1HD1 LEU   100     -17.651  10.649   7.693  1.00 36.29           H 
ATOM   1584 2HD1 LEU   100     -17.979  12.171   6.861  1.00 36.29           H 
ATOM   1585 3HD1 LEU   100     -16.316  11.698   7.212  1.00 36.29           H 
ATOM   1586 1HD2 LEU   100     -15.255   9.828   5.969  1.00 36.29           H 
ATOM   1587 2HD2 LEU   100     -16.132   9.004   4.680  1.00 36.29           H 
ATOM   1588 3HD2 LEU   100     -16.572   8.721   6.364  1.00 36.29           H 
ATOM   1589  N   PHE   101     -20.920   9.825   3.030  1.00 25.05           N 
ATOM   1590  CA  PHE   101     -22.321   9.517   2.717  1.00 22.40           C 
ATOM   1591  C   PHE   101     -22.424   8.284   1.810  1.00 32.10           C 
ATOM   1592  O   PHE   101     -23.216   7.374   2.069  1.00 63.25           O 
ATOM   1593  CB  PHE   101     -22.979  10.728   2.043  1.00 62.32           C 
ATOM   1594  CG  PHE   101     -24.419  10.516   1.638  1.00 44.44           C 
ATOM   1595  CD1 PHE   101     -24.744  10.119   0.345  1.00 11.13           C 
ATOM   1596  CD2 PHE   101     -25.447  10.716   2.547  1.00  3.51           C 
ATOM   1597  CE1 PHE   101     -26.062   9.928  -0.027  1.00 71.41           C 
ATOM   1598  CE2 PHE   101     -26.766  10.527   2.179  1.00 53.41           C 
ATOM   1599  CZ  PHE   101     -27.075  10.131   0.891  1.00 10.35           C 
ATOM   1600  H   PHE   101     -20.586  10.731   2.866  1.00 36.29           H 
ATOM   1601  HA  PHE   101     -22.830   9.310   3.648  1.00 74.20           H 
ATOM   1602 3HB  PHE   101     -22.417  10.980   1.154  1.00 36.29           H 
ATOM   1603 2HB  PHE   101     -22.947  11.566   2.724  1.00 36.29           H 
ATOM   1604  HD1 PHE   101     -23.954   9.957  -0.374  1.00  1.30           H 
ATOM   1605  HD2 PHE   101     -25.212  11.026   3.556  1.00 41.52           H 
ATOM   1606  HE1 PHE   101     -26.301   9.619  -1.036  1.00 14.35           H 
ATOM   1607  HE2 PHE   101     -27.556  10.687   2.900  1.00 15.01           H 
ATOM   1608  HZ  PHE   101     -28.106   9.983   0.604  1.00 60.20           H 
ATOM   1609  N   ARG   102     -21.614   8.258   0.753  1.00 23.35           N 
ATOM   1610  CA  ARG   102     -21.536   7.094  -0.134  1.00 23.31           C 
ATOM   1611  C   ARG   102     -21.221   5.817   0.657  1.00 61.20           C 
ATOM   1612  O   ARG   102     -21.913   4.811   0.529  1.00  4.51           O 
ATOM   1613  CB  ARG   102     -20.459   7.310  -1.207  1.00 65.14           C 
ATOM   1614  CG  ARG   102     -20.798   8.403  -2.213  1.00 73.23           C 
ATOM   1615  CD  ARG   102     -22.003   8.029  -3.071  1.00  0.12           C 
ATOM   1616  NE  ARG   102     -22.336   9.077  -4.032  1.00 33.22           N 
ATOM   1617  CZ  ARG   102     -22.683   8.860  -5.272  1.00 43.40           C 
ATOM   1618  NH1 ARG   102     -22.703   7.655  -5.753  1.00  1.11           N 
ATOM   1619  NH2 ARG   102     -22.993   9.855  -6.034  1.00 44.44           N 
ATOM   1620  H   ARG   102     -21.055   9.043   0.563  1.00 36.29           H 
ATOM   1621  HA  ARG   102     -22.497   6.979  -0.618  1.00 14.34           H 
ATOM   1622 3HB  ARG   102     -20.315   6.384  -1.750  1.00 36.29           H 
ATOM   1623 2HB  ARG   102     -19.533   7.576  -0.719  1.00 36.29           H 
ATOM   1624 3HG  ARG   102     -19.945   8.563  -2.859  1.00 36.29           H 
ATOM   1625 2HG  ARG   102     -21.019   9.316  -1.679  1.00 36.29           H 
ATOM   1626 3HD  ARG   102     -22.854   7.865  -2.423  1.00 36.29           H 
ATOM   1627 2HD  ARG   102     -21.780   7.116  -3.605  1.00 36.29           H 
ATOM   1628  HE  ARG   102     -22.307  10.004  -3.716  1.00 40.12           H 
ATOM   1629 1HH1 ARG   102     -22.449   6.881  -5.177  1.00 36.29           H 
ATOM   1630 2HH1 ARG   102     -22.973   7.501  -6.702  1.00 36.29           H 
ATOM   1631 1HH2 ARG   102     -22.969  10.786  -5.671  1.00 36.29           H 
ATOM   1632 2HH2 ARG   102     -23.254   9.695  -6.984  1.00 36.29           H 
ATOM   1633  N   MET   103     -20.186   5.883   1.488  1.00 12.52           N 
ATOM   1634  CA  MET   103     -19.735   4.728   2.273  1.00 72.25           C 
ATOM   1635  C   MET   103     -20.818   4.229   3.246  1.00  2.14           C 
ATOM   1636  O   MET   103     -21.065   3.023   3.350  1.00 24.21           O 
ATOM   1637  CB  MET   103     -18.454   5.093   3.030  1.00 24.22           C 
ATOM   1638  CG  MET   103     -17.340   5.557   2.103  1.00 44.15           C 
ATOM   1639  SD  MET   103     -17.028   4.377   0.772  1.00 62.20           S 
ATOM   1640  CE  MET   103     -16.022   5.358  -0.338  1.00 74.41           C 
ATOM   1641  H   MET   103     -19.708   6.735   1.580  1.00 36.29           H 
ATOM   1642  HA  MET   103     -19.509   3.931   1.578  1.00  4.15           H 
ATOM   1643 3HB  MET   103     -18.106   4.228   3.575  1.00 36.29           H 
ATOM   1644 2HB  MET   103     -18.673   5.889   3.730  1.00 36.29           H 
ATOM   1645 3HG  MET   103     -16.432   5.681   2.679  1.00 36.29           H 
ATOM   1646 2HG  MET   103     -17.621   6.505   1.667  1.00 36.29           H 
ATOM   1647 1HE  MET   103     -15.753   4.765  -1.199  1.00 36.29           H 
ATOM   1648 2HE  MET   103     -15.127   5.675   0.174  1.00 36.29           H 
ATOM   1649 3HE  MET   103     -16.579   6.226  -0.659  1.00 36.29           H 
ATOM   1650  N   LYS   104     -21.477   5.159   3.936  1.00 52.44           N 
ATOM   1651  CA  LYS   104     -22.549   4.815   4.877  1.00 31.44           C 
ATOM   1652  C   LYS   104     -23.705   4.105   4.153  1.00 43.24           C 
ATOM   1653  O   LYS   104     -24.244   3.104   4.634  1.00 41.13           O 
ATOM   1654  CB  LYS   104     -23.070   6.081   5.579  1.00 61.35           C 
ATOM   1655  CG  LYS   104     -21.973   6.933   6.218  1.00 50.22           C 
ATOM   1656  CD  LYS   104     -22.539   8.142   6.969  1.00 61.35           C 
ATOM   1657  CE  LYS   104     -22.892   7.817   8.420  1.00 53.34           C 
ATOM   1658  NZ  LYS   104     -23.861   6.695   8.543  1.00 30.53           N 
ATOM   1659  H   LYS   104     -21.233   6.099   3.812  1.00 36.29           H 
ATOM   1660  HA  LYS   104     -22.137   4.144   5.619  1.00 41.12           H 
ATOM   1661 3HB  LYS   104     -23.764   5.787   6.354  1.00 36.29           H 
ATOM   1662 2HB  LYS   104     -23.593   6.691   4.855  1.00 36.29           H 
ATOM   1663 3HG  LYS   104     -21.309   7.283   5.442  1.00 36.29           H 
ATOM   1664 2HG  LYS   104     -21.415   6.319   6.912  1.00 36.29           H 
ATOM   1665 3HD  LYS   104     -23.431   8.483   6.461  1.00 36.29           H 
ATOM   1666 2HD  LYS   104     -21.802   8.934   6.964  1.00 36.29           H 
ATOM   1667 3HE  LYS   104     -23.319   8.698   8.877  1.00 36.29           H 
ATOM   1668 2HE  LYS   104     -21.987   7.549   8.944  1.00 36.29           H 
ATOM   1669 1HZ  LYS   104     -23.460   5.824   8.137  1.00 36.29           H 
ATOM   1670 2HZ  LYS   104     -24.742   6.924   8.043  1.00 36.29           H 
ATOM   1671 3HZ  LYS   104     -24.080   6.523   9.545  1.00 36.29           H 
ATOM   1672  N   ASN   105     -24.075   4.625   2.986  1.00 31.44           N 
ATOM   1673  CA  ASN   105     -25.150   4.039   2.179  1.00 20.54           C 
ATOM   1674  C   ASN   105     -24.684   2.767   1.446  1.00 62.14           C 
ATOM   1675  O   ASN   105     -25.498   1.920   1.088  1.00 23.42           O 
ATOM   1676  CB  ASN   105     -25.686   5.077   1.183  1.00 52.13           C 
ATOM   1677  CG  ASN   105     -26.582   6.111   1.848  1.00 71.04           C 
ATOM   1678  OD1 ASN   105     -27.800   5.955   1.901  1.00  2.24           O 
ATOM   1679  ND2 ASN   105     -25.995   7.167   2.371  1.00 13.41           N 
ATOM   1680  H   ASN   105     -23.611   5.424   2.654  1.00 36.29           H 
ATOM   1681  HA  ASN   105     -25.950   3.764   2.854  1.00 51.30           H 
ATOM   1682 3HB  ASN   105     -26.259   4.573   0.415  1.00 36.29           H 
ATOM   1683 2HB  ASN   105     -24.854   5.590   0.725  1.00 36.29           H 
ATOM   1684 1HD2 ASN   105     -25.024   7.236   2.304  1.00 36.29           H 
ATOM   1685 2HD2 ASN   105     -26.558   7.835   2.813  1.00 36.29           H 
ATOM   1686  N   LEU   106     -23.375   2.636   1.222  1.00 21.42           N 
ATOM   1687  CA  LEU   106     -22.816   1.444   0.563  1.00 42.00           C 
ATOM   1688  C   LEU   106     -22.699   0.252   1.528  1.00 44.44           C 
ATOM   1689  O   LEU   106     -22.835  -0.898   1.110  1.00 43.31           O 
ATOM   1690  CB  LEU   106     -21.445   1.755  -0.071  1.00 52.23           C 
ATOM   1691  CG  LEU   106     -21.443   1.918  -1.603  1.00 73.13           C 
ATOM   1692  CD1 LEU   106     -21.900   0.628  -2.282  1.00 25.24           C 
ATOM   1693  CD2 LEU   106     -22.324   3.088  -2.033  1.00  3.23           C 
ATOM   1694  H   LEU   106     -22.770   3.358   1.496  1.00 36.29           H 
ATOM   1695  HA  LEU   106     -23.502   1.167  -0.226  1.00 11.44           H 
ATOM   1696 3HB  LEU   106     -20.760   0.956   0.180  1.00 36.29           H 
ATOM   1697 2HB  LEU   106     -21.070   2.671   0.366  1.00 36.29           H 
ATOM   1698  HG  LEU   106     -20.432   2.124  -1.933  1.00 24.21           H 
ATOM   1699 1HD1 LEU   106     -21.863   0.753  -3.355  1.00 36.29           H 
ATOM   1700 2HD1 LEU   106     -22.914   0.401  -1.983  1.00 36.29           H 
ATOM   1701 3HD1 LEU   106     -21.250  -0.184  -1.992  1.00 36.29           H 
ATOM   1702 1HD2 LEU   106     -22.302   3.179  -3.108  1.00 36.29           H 
ATOM   1703 2HD2 LEU   106     -21.955   4.002  -1.588  1.00 36.29           H 
ATOM   1704 3HD2 LEU   106     -23.341   2.915  -1.706  1.00 36.29           H 
ATOM   1705  N   GLY   107     -22.443   0.524   2.808  1.00  4.41           N 
ATOM   1706  CA  GLY   107     -22.387  -0.549   3.803  1.00 75.00           C 
ATOM   1707  C   GLY   107     -21.149  -0.519   4.700  1.00 52.23           C 
ATOM   1708  O   GLY   107     -21.050  -1.299   5.650  1.00 74.33           O 
ATOM   1709  H   GLY   107     -22.303   1.456   3.083  1.00 36.29           H 
ATOM   1710 3HA  GLY   107     -22.415  -1.503   3.292  1.00 36.29           H 
ATOM   1711 2HA  GLY   107     -23.262  -0.474   4.431  1.00 36.29           H 
ATOM   1712  N   ILE   108     -20.204   0.376   4.419  1.00 20.43           N 
ATOM   1713  CA  ILE   108     -18.974   0.469   5.217  1.00 25.42           C 
ATOM   1714  C   ILE   108     -19.059   1.595   6.264  1.00 11.24           C 
ATOM   1715  O   ILE   108     -18.589   2.710   6.045  1.00  1.10           O 
ATOM   1716  CB  ILE   108     -17.688   0.643   4.345  1.00 45.21           C 
ATOM   1717  CG1 ILE   108     -17.897   1.640   3.187  1.00 21.42           C 
ATOM   1718  CG2 ILE   108     -17.203  -0.706   3.815  1.00 34.33           C 
ATOM   1719  CD1 ILE   108     -18.544   1.050   1.944  1.00  2.54           C 
ATOM   1720  H   ILE   108     -20.345   1.003   3.682  1.00 36.29           H 
ATOM   1721  HA  ILE   108     -18.876  -0.468   5.753  1.00 13.33           H 
ATOM   1722  HB  ILE   108     -16.911   1.029   4.991  1.00 72.34           H 
ATOM   1723 3HG1 ILE   108     -16.937   2.045   2.896  1.00 36.29           H 
ATOM   1724 2HG1 ILE   108     -18.527   2.450   3.527  1.00 36.29           H 
ATOM   1725 1HG2 ILE   108     -16.975  -1.359   4.646  1.00 36.29           H 
ATOM   1726 2HG2 ILE   108     -16.312  -0.561   3.220  1.00 36.29           H 
ATOM   1727 3HG2 ILE   108     -17.973  -1.156   3.206  1.00 36.29           H 
ATOM   1728 1HD1 ILE   108     -19.481   0.582   2.206  1.00 36.29           H 
ATOM   1729 2HD1 ILE   108     -17.883   0.316   1.509  1.00 36.29           H 
ATOM   1730 3HD1 ILE   108     -18.726   1.838   1.228  1.00 36.29           H 
ATOM   1731  N   GLU   109     -19.687   1.289   7.400  1.00 14.42           N 
ATOM   1732  CA  GLU   109     -19.801   2.238   8.518  1.00 50.05           C 
ATOM   1733  C   GLU   109     -18.596   2.127   9.468  1.00  1.42           C 
ATOM   1734  O   GLU   109     -17.716   2.992   9.483  1.00  4.22           O 
ATOM   1735  CB  GLU   109     -21.106   1.977   9.291  1.00  3.31           C 
ATOM   1736  CG  GLU   109     -22.377   2.245   8.484  1.00 43.33           C 
ATOM   1737  CD  GLU   109     -22.791   3.711   8.481  1.00  3.32           C 
ATOM   1738  OE1 GLU   109     -21.915   4.593   8.387  1.00 72.11           O 
ATOM   1739  OE2 GLU   109     -24.007   3.992   8.566  1.00  1.44           O 
ATOM   1740  H   GLU   109     -20.100   0.406   7.486  1.00 36.29           H 
ATOM   1741  HA  GLU   109     -19.831   3.239   8.107  1.00 55.04           H 
ATOM   1742 3HB  GLU   109     -21.124   2.609  10.170  1.00 36.29           H 
ATOM   1743 2HB  GLU   109     -21.119   0.946   9.605  1.00 36.29           H 
ATOM   1744 3HG  GLU   109     -23.181   1.659   8.909  1.00 36.29           H 
ATOM   1745 2HG  GLU   109     -22.213   1.933   7.463  1.00 36.29           H 
ATOM   1746  N   SER   110     -18.565   1.053  10.262  1.00 74.22           N 
ATOM   1747  CA  SER   110     -17.453   0.801  11.195  1.00  3.13           C 
ATOM   1748  C   SER   110     -17.450  -0.658  11.674  1.00  5.11           C 
ATOM   1749  O   SER   110     -18.506  -1.248  11.904  1.00 60.41           O 
ATOM   1750  CB  SER   110     -17.540   1.734  12.410  1.00 63.23           C 
ATOM   1751  OG  SER   110     -18.701   1.469  13.185  1.00 53.02           O 
ATOM   1752  H   SER   110     -19.312   0.418  10.232  1.00 36.29           H 
ATOM   1753  HA  SER   110     -16.529   0.997  10.666  1.00 72.12           H 
ATOM   1754 3HB  SER   110     -17.577   2.760  12.072  1.00 36.29           H 
ATOM   1755 2HB  SER   110     -16.669   1.595  13.035  1.00 36.29           H 
ATOM   1756  HG  SER   110     -18.448   1.331  14.105  1.00  0.43           H 
ATOM   1757  N   GLY   111     -16.258  -1.245  11.800  1.00  4.32           N 
ATOM   1758  CA  GLY   111     -16.133  -2.618  12.298  1.00 61.43           C 
ATOM   1759  C   GLY   111     -16.562  -3.693  11.296  1.00 32.32           C 
ATOM   1760  O   GLY   111     -16.359  -4.884  11.537  1.00 51.22           O 
ATOM   1761  H   GLY   111     -15.451  -0.741  11.562  1.00 36.29           H 
ATOM   1762 3HA  GLY   111     -16.736  -2.717  13.191  1.00 36.29           H 
ATOM   1763 2HA  GLY   111     -15.101  -2.790  12.563  1.00 36.29           H 
ATOM   1764  N   LYS   112     -17.154  -3.275  10.176  1.00  3.11           N 
ATOM   1765  CA  LYS   112     -17.630  -4.205   9.140  1.00 34.24           C 
ATOM   1766  C   LYS   112     -16.499  -5.083   8.579  1.00 41.42           C 
ATOM   1767  O   LYS   112     -15.406  -4.595   8.279  1.00  3.25           O 
ATOM   1768  CB  LYS   112     -18.284  -3.424   7.988  1.00 61.22           C 
ATOM   1769  CG  LYS   112     -19.630  -2.792   8.335  1.00 31.01           C 
ATOM   1770  CD  LYS   112     -20.692  -3.852   8.620  1.00 72.52           C 
ATOM   1771  CE  LYS   112     -22.077  -3.237   8.779  1.00 40.15           C 
ATOM   1772  NZ  LYS   112     -23.106  -4.266   9.079  1.00 34.21           N 
ATOM   1773  H   LYS   112     -17.277  -2.317  10.042  1.00 36.29           H 
ATOM   1774  HA  LYS   112     -18.374  -4.844   9.592  1.00 34.15           H 
ATOM   1775 3HB  LYS   112     -18.433  -4.096   7.154  1.00 36.29           H 
ATOM   1776 2HB  LYS   112     -17.612  -2.634   7.680  1.00 36.29           H 
ATOM   1777 3HG  LYS   112     -19.955  -2.184   7.501  1.00 36.29           H 
ATOM   1778 2HG  LYS   112     -19.509  -2.169   9.210  1.00 36.29           H 
ATOM   1779 3HD  LYS   112     -20.434  -4.374   9.532  1.00 36.29           H 
ATOM   1780 2HD  LYS   112     -20.717  -4.554   7.800  1.00 36.29           H 
ATOM   1781 3HE  LYS   112     -22.342  -2.732   7.860  1.00 36.29           H 
ATOM   1782 2HE  LYS   112     -22.051  -2.523   9.587  1.00 36.29           H 
ATOM   1783 1HZ  LYS   112     -22.943  -4.671  10.025  1.00 36.29           H 
ATOM   1784 2HZ  LYS   112     -23.065  -5.032   8.376  1.00 36.29           H 
ATOM   1785 3HZ  LYS   112     -24.052  -3.841   9.057  1.00 36.29           H 
ATOM   1786  N   LYS   113     -16.779  -6.379   8.432  1.00 22.32           N 
ATOM   1787  CA  LYS   113     -15.829  -7.313   7.820  1.00 63.22           C 
ATOM   1788  C   LYS   113     -15.988  -7.337   6.293  1.00 23.13           C 
ATOM   1789  O   LYS   113     -16.949  -7.896   5.759  1.00 61.52           O 
ATOM   1790  CB  LYS   113     -15.994  -8.726   8.407  1.00  2.21           C 
ATOM   1791  CG  LYS   113     -15.299  -8.923   9.757  1.00 33.44           C 
ATOM   1792  CD  LYS   113     -15.792  -7.940  10.821  1.00 54.34           C 
ATOM   1793  CE  LYS   113     -15.025  -8.083  12.130  1.00  4.32           C 
ATOM   1794  NZ  LYS   113     -15.512  -7.131  13.161  1.00 54.11           N 
ATOM   1795  H   LYS   113     -17.644  -6.720   8.747  1.00 36.29           H 
ATOM   1796  HA  LYS   113     -14.834  -6.959   8.052  1.00 65.00           H 
ATOM   1797 3HB  LYS   113     -15.582  -9.444   7.711  1.00 36.29           H 
ATOM   1798 2HB  LYS   113     -17.047  -8.932   8.535  1.00 36.29           H 
ATOM   1799 3HG  LYS   113     -14.234  -8.788   9.621  1.00 36.29           H 
ATOM   1800 2HG  LYS   113     -15.489  -9.930  10.101  1.00 36.29           H 
ATOM   1801 3HD  LYS   113     -16.841  -8.123  11.006  1.00 36.29           H 
ATOM   1802 2HD  LYS   113     -15.663  -6.932  10.453  1.00 36.29           H 
ATOM   1803 3HE  LYS   113     -13.977  -7.892  11.945  1.00 36.29           H 
ATOM   1804 2HE  LYS   113     -15.146  -9.090  12.499  1.00 36.29           H 
ATOM   1805 1HZ  LYS   113     -15.522  -6.165  12.778  1.00 36.29           H 
ATOM   1806 2HZ  LYS   113     -14.886  -7.154  13.991  1.00 36.29           H 
ATOM   1807 3HZ  LYS   113     -16.475  -7.385  13.461  1.00 36.29           H 
ATOM   1808  N   ILE   114     -15.030  -6.725   5.601  1.00 74.14           N 
ATOM   1809  CA  ILE   114     -15.084  -6.570   4.145  1.00  2.33           C 
ATOM   1810  C   ILE   114     -14.092  -7.515   3.433  1.00 44.51           C 
ATOM   1811  O   ILE   114     -12.929  -7.631   3.823  1.00 10.11           O 
ATOM   1812  CB  ILE   114     -14.806  -5.094   3.754  1.00 75.45           C 
ATOM   1813  CG1 ILE   114     -15.044  -4.862   2.251  1.00 52.12           C 
ATOM   1814  CG2 ILE   114     -13.387  -4.676   4.149  1.00 50.24           C 
ATOM   1815  CD1 ILE   114     -15.046  -3.397   1.856  1.00 54.51           C 
ATOM   1816  H   ILE   114     -14.261  -6.363   6.088  1.00 36.29           H 
ATOM   1817  HA  ILE   114     -16.087  -6.818   3.823  1.00 40.45           H 
ATOM   1818  HB  ILE   114     -15.493  -4.473   4.313  1.00  4.51           H 
ATOM   1819 3HG1 ILE   114     -16.002  -5.278   1.977  1.00 36.29           H 
ATOM   1820 2HG1 ILE   114     -14.268  -5.357   1.685  1.00 36.29           H 
ATOM   1821 1HG2 ILE   114     -13.260  -4.793   5.216  1.00 36.29           H 
ATOM   1822 2HG2 ILE   114     -13.224  -3.642   3.880  1.00 36.29           H 
ATOM   1823 3HG2 ILE   114     -12.670  -5.299   3.633  1.00 36.29           H 
ATOM   1824 1HD1 ILE   114     -14.090  -2.956   2.098  1.00 36.29           H 
ATOM   1825 2HD1 ILE   114     -15.828  -2.878   2.392  1.00 36.29           H 
ATOM   1826 3HD1 ILE   114     -15.222  -3.312   0.794  1.00 36.29           H 
ATOM   1827  N   GLN   115     -14.574  -8.211   2.405  1.00  1.25           N 
ATOM   1828  CA  GLN   115     -13.751  -9.165   1.648  1.00 51.53           C 
ATOM   1829  C   GLN   115     -13.154  -8.520   0.389  1.00 75.21           C 
ATOM   1830  O   GLN   115     -13.791  -7.684  -0.255  1.00 13.35           O 
ATOM   1831  CB  GLN   115     -14.577 -10.397   1.244  1.00 52.33           C 
ATOM   1832  CG  GLN   115     -15.051 -11.264   2.410  1.00 22.45           C 
ATOM   1833  CD  GLN   115     -16.130 -10.612   3.259  1.00 10.23           C 
ATOM   1834  OE1 GLN   115     -17.318 -10.739   2.985  1.00 63.13           O 
ATOM   1835  NE2 GLN   115     -15.733  -9.933   4.312  1.00 14.31           N 
ATOM   1836  H   GLN   115     -15.512  -8.084   2.150  1.00 36.29           H 
ATOM   1837  HA  GLN   115     -12.940  -9.484   2.291  1.00 73.32           H 
ATOM   1838 3HB  GLN   115     -13.976 -11.016   0.591  1.00 36.29           H 
ATOM   1839 2HB  GLN   115     -15.449 -10.065   0.699  1.00 36.29           H 
ATOM   1840 3HG  GLN   115     -14.202 -11.486   3.042  1.00 36.29           H 
ATOM   1841 2HG  GLN   115     -15.444 -12.189   2.013  1.00 36.29           H 
ATOM   1842 1HE2 GLN   115     -14.776  -9.884   4.493  1.00 36.29           H 
ATOM   1843 2HE2 GLN   115     -16.416  -9.501   4.866  1.00 36.29           H 
ATOM   1844  N   VAL   116     -11.934  -8.924   0.035  1.00  5.30           N 
ATOM   1845  CA  VAL   116     -11.244  -8.398  -1.153  1.00 24.20           C 
ATOM   1846  C   VAL   116     -11.268  -9.405  -2.321  1.00 21.53           C 
ATOM   1847  O   VAL   116     -10.779 -10.529  -2.193  1.00 13.22           O 
ATOM   1848  CB  VAL   116      -9.771  -8.041  -0.822  1.00 43.21           C 
ATOM   1849  CG1 VAL   116      -9.035  -7.525  -2.059  1.00 45.14           C 
ATOM   1850  CG2 VAL   116      -9.703  -7.018   0.312  1.00 43.24           C 
ATOM   1851  H   VAL   116     -11.477  -9.594   0.590  1.00 36.29           H 
ATOM   1852  HA  VAL   116     -11.751  -7.491  -1.463  1.00 33.34           H 
ATOM   1853  HB  VAL   116      -9.273  -8.943  -0.491  1.00 74.23           H 
ATOM   1854 1HG1 VAL   116      -9.523  -6.632  -2.425  1.00 36.29           H 
ATOM   1855 2HG1 VAL   116      -9.048  -8.282  -2.830  1.00 36.29           H 
ATOM   1856 3HG1 VAL   116      -8.013  -7.293  -1.801  1.00 36.29           H 
ATOM   1857 1HG2 VAL   116     -10.200  -7.414   1.186  1.00 36.29           H 
ATOM   1858 2HG2 VAL   116     -10.191  -6.104   0.005  1.00 36.29           H 
ATOM   1859 3HG2 VAL   116      -8.669  -6.809   0.551  1.00 36.29           H 
ATOM   1860  N   SER   117     -11.834  -8.991  -3.459  1.00 32.24           N 
ATOM   1861  CA  SER   117     -11.877  -9.838  -4.666  1.00 71.32           C 
ATOM   1862  C   SER   117     -11.781  -8.999  -5.949  1.00 31.01           C 
ATOM   1863  O   SER   117     -12.653  -8.179  -6.231  1.00 51.43           O 
ATOM   1864  CB  SER   117     -13.166 -10.671  -4.702  1.00 71.42           C 
ATOM   1865  OG  SER   117     -13.264 -11.424  -5.904  1.00 75.11           O 
ATOM   1866  H   SER   117     -12.243  -8.099  -3.491  1.00 36.29           H 
ATOM   1867  HA  SER   117     -11.028 -10.510  -4.630  1.00 41.04           H 
ATOM   1868 3HB  SER   117     -14.019 -10.012  -4.635  1.00 36.29           H 
ATOM   1869 2HB  SER   117     -13.173 -11.353  -3.867  1.00 36.29           H 
ATOM   1870  HG  SER   117     -14.120 -11.872  -5.932  1.00 73.31           H 
ATOM   1871  N   GLY   118     -10.717  -9.213  -6.719  1.00 33.21           N 
ATOM   1872  CA  GLY   118     -10.530  -8.493  -7.977  1.00 12.42           C 
ATOM   1873  C   GLY   118     -10.578  -6.971  -7.828  1.00 74.20           C 
ATOM   1874  O   GLY   118      -9.735  -6.377  -7.158  1.00 20.33           O 
ATOM   1875  H   GLY   118     -10.053  -9.876  -6.438  1.00 36.29           H 
ATOM   1876 3HA  GLY   118     -11.303  -8.800  -8.669  1.00 36.29           H 
ATOM   1877 2HA  GLY   118      -9.571  -8.769  -8.390  1.00 36.29           H 
ATOM   1878  N   ARG   119     -11.570  -6.342  -8.460  1.00 25.32           N 
ATOM   1879  CA  ARG   119     -11.739  -4.883  -8.395  1.00 34.22           C 
ATOM   1880  C   ARG   119     -13.046  -4.488  -7.683  1.00  2.21           C 
ATOM   1881  O   ARG   119     -13.582  -3.404  -7.913  1.00 13.21           O 
ATOM   1882  CB  ARG   119     -11.711  -4.285  -9.810  1.00 42.40           C 
ATOM   1883  CG  ARG   119     -10.351  -4.386 -10.497  1.00 71.15           C 
ATOM   1884  CD  ARG   119      -9.283  -3.580  -9.762  1.00 32.30           C 
ATOM   1885  NE  ARG   119      -7.979  -3.672 -10.415  1.00 24.14           N 
ATOM   1886  CZ  ARG   119      -6.876  -3.167  -9.934  1.00 45.15           C 
ATOM   1887  NH1 ARG   119      -6.883  -2.491  -8.831  1.00 23.21           N 
ATOM   1888  NH2 ARG   119      -5.766  -3.322 -10.573  1.00 61.32           N 
ATOM   1889  H   ARG   119     -12.206  -6.872  -8.987  1.00 36.29           H 
ATOM   1890  HA  ARG   119     -10.909  -4.478  -7.832  1.00 21.42           H 
ATOM   1891 3HB  ARG   119     -11.984  -3.241  -9.755  1.00 36.29           H 
ATOM   1892 2HB  ARG   119     -12.437  -4.803 -10.422  1.00 36.29           H 
ATOM   1893 3HG  ARG   119     -10.439  -4.013 -11.507  1.00 36.29           H 
ATOM   1894 2HG  ARG   119     -10.047  -5.424 -10.522  1.00 36.29           H 
ATOM   1895 3HD  ARG   119      -9.198  -3.958  -8.751  1.00 36.29           H 
ATOM   1896 2HD  ARG   119      -9.590  -2.545  -9.734  1.00 36.29           H 
ATOM   1897  HE  ARG   119      -7.934  -4.155 -11.265  1.00 73.21           H 
ATOM   1898 1HH1 ARG   119      -7.737  -2.351  -8.338  1.00 36.29           H 
ATOM   1899 2HH1 ARG   119      -6.030  -2.114  -8.478  1.00 36.29           H 
ATOM   1900 1HH2 ARG   119      -5.751  -3.827 -11.434  1.00 36.29           H 
ATOM   1901 2HH2 ARG   119      -4.922  -2.939 -10.202  1.00 36.29           H 
ATOM   1902  N   ARG   120     -13.549  -5.366  -6.814  1.00 13.33           N 
ATOM   1903  CA  ARG   120     -14.733  -5.051  -6.004  1.00 42.34           C 
ATOM   1904  C   ARG   120     -14.646  -5.711  -4.618  1.00  2.33           C 
ATOM   1905  O   ARG   120     -14.144  -6.826  -4.471  1.00 12.04           O 
ATOM   1906  CB  ARG   120     -16.037  -5.467  -6.719  1.00  1.04           C 
ATOM   1907  CG  ARG   120     -16.304  -6.973  -6.772  1.00 73.22           C 
ATOM   1908  CD  ARG   120     -15.361  -7.713  -7.714  1.00 13.13           C 
ATOM   1909  NE  ARG   120     -15.606  -9.153  -7.688  1.00 42.00           N 
ATOM   1910  CZ  ARG   120     -15.171  -9.996  -8.582  1.00  4.14           C 
ATOM   1911  NH1 ARG   120     -14.451  -9.599  -9.583  1.00 52.34           N 
ATOM   1912  NH2 ARG   120     -15.455 -11.249  -8.463  1.00 14.03           N 
ATOM   1913  H   ARG   120     -13.113  -6.240  -6.707  1.00 36.29           H 
ATOM   1914  HA  ARG   120     -14.746  -3.977  -5.863  1.00 23.42           H 
ATOM   1915 3HB  ARG   120     -16.001  -5.097  -7.736  1.00 36.29           H 
ATOM   1916 2HB  ARG   120     -16.870  -5.000  -6.213  1.00 36.29           H 
ATOM   1917 3HG  ARG   120     -17.322  -7.130  -7.106  1.00 36.29           H 
ATOM   1918 2HG  ARG   120     -16.190  -7.382  -5.779  1.00 36.29           H 
ATOM   1919 3HD  ARG   120     -14.340  -7.525  -7.412  1.00 36.29           H 
ATOM   1920 2HD  ARG   120     -15.514  -7.346  -8.720  1.00 36.29           H 
ATOM   1921  HE  ARG   120     -16.141  -9.504  -6.947  1.00 73.14           H 
ATOM   1922 1HH1 ARG   120     -14.218  -8.637  -9.681  1.00 36.29           H 
ATOM   1923 2HH1 ARG   120     -14.127 -10.264 -10.254  1.00 36.29           H 
ATOM   1924 1HH2 ARG   120     -15.997 -11.567  -7.686  1.00 36.29           H 
ATOM   1925 2HH2 ARG   120     -15.140 -11.897  -9.151  1.00 36.29           H 
ATOM   1926  N   TYR   121     -15.137  -5.016  -3.602  1.00 61.44           N 
ATOM   1927  CA  TYR   121     -15.057  -5.499  -2.222  1.00 32.34           C 
ATOM   1928  C   TYR   121     -16.448  -5.885  -1.695  1.00  1.31           C 
ATOM   1929  O   TYR   121     -17.450  -5.283  -2.075  1.00 44.54           O 
ATOM   1930  CB  TYR   121     -14.417  -4.424  -1.344  1.00 31.21           C 
ATOM   1931  CG  TYR   121     -13.079  -3.945  -1.877  1.00 42.15           C 
ATOM   1932  CD1 TYR   121     -12.994  -2.810  -2.676  1.00 22.22           C 
ATOM   1933  CD2 TYR   121     -11.906  -4.634  -1.594  1.00 22.31           C 
ATOM   1934  CE1 TYR   121     -11.781  -2.375  -3.174  1.00 31.53           C 
ATOM   1935  CE2 TYR   121     -10.689  -4.204  -2.089  1.00 43.00           C 
ATOM   1936  CZ  TYR   121     -10.632  -3.074  -2.881  1.00  2.42           C 
ATOM   1937  OH  TYR   121      -9.422  -2.638  -3.372  1.00 23.02           O 
ATOM   1938  H   TYR   121     -15.566  -4.155  -3.780  1.00 36.29           H 
ATOM   1939  HA  TYR   121     -14.427  -6.380  -2.211  1.00 55.21           H 
ATOM   1940 3HB  TYR   121     -14.258  -4.820  -0.351  1.00 36.29           H 
ATOM   1941 2HB  TYR   121     -15.080  -3.571  -1.285  1.00 36.29           H 
ATOM   1942  HD1 TYR   121     -13.895  -2.262  -2.907  1.00 60.30           H 
ATOM   1943  HD2 TYR   121     -11.951  -5.517  -0.975  1.00 15.43           H 
ATOM   1944  HE1 TYR   121     -11.738  -1.491  -3.792  1.00 70.53           H 
ATOM   1945  HE2 TYR   121      -9.787  -4.756  -1.858  1.00  2.23           H 
ATOM   1946  HH  TYR   121      -8.912  -3.391  -3.682  1.00 11.12           H 
ATOM   1947  N   TYR   122     -16.508  -6.891  -0.824  1.00 71.12           N 
ATOM   1948  CA  TYR   122     -17.792  -7.460  -0.385  1.00  4.51           C 
ATOM   1949  C   TYR   122     -18.089  -7.192   1.101  1.00 13.21           C 
ATOM   1950  O   TYR   122     -17.336  -7.607   1.982  1.00  0.03           O 
ATOM   1951  CB  TYR   122     -17.802  -8.974  -0.641  1.00 41.43           C 
ATOM   1952  CG  TYR   122     -17.747  -9.356  -2.112  1.00 23.53           C 
ATOM   1953  CD1 TYR   122     -16.604  -9.120  -2.870  1.00 42.45           C 
ATOM   1954  CD2 TYR   122     -18.835  -9.954  -2.740  1.00 52.10           C 
ATOM   1955  CE1 TYR   122     -16.549  -9.467  -4.203  1.00 23.30           C 
ATOM   1956  CE2 TYR   122     -18.784 -10.306  -4.077  1.00  0.13           C 
ATOM   1957  CZ  TYR   122     -17.638 -10.058  -4.803  1.00 42.13           C 
ATOM   1958  OH  TYR   122     -17.582 -10.400  -6.136  1.00 14.43           O 
ATOM   1959  H   TYR   122     -15.673  -7.263  -0.471  1.00 36.29           H 
ATOM   1960  HA  TYR   122     -18.576  -7.007  -0.979  1.00 54.24           H 
ATOM   1961 3HB  TYR   122     -18.702  -9.398  -0.219  1.00 36.29           H 
ATOM   1962 2HB  TYR   122     -16.943  -9.417  -0.153  1.00 36.29           H 
ATOM   1963  HD1 TYR   122     -15.750  -8.654  -2.400  1.00 52.42           H 
ATOM   1964  HD2 TYR   122     -19.731 -10.145  -2.169  1.00 51.21           H 
ATOM   1965  HE1 TYR   122     -15.651  -9.273  -4.773  1.00 34.31           H 
ATOM   1966  HE2 TYR   122     -19.640 -10.769  -4.546  1.00  1.05           H 
ATOM   1967  HH  TYR   122     -18.382 -10.089  -6.579  1.00 70.22           H 
ATOM   1968  N   ILE   123     -19.191  -6.496   1.363  1.00 61.04           N 
ATOM   1969  CA  ILE   123     -19.716  -6.327   2.724  1.00 61.25           C 
ATOM   1970  C   ILE   123     -20.884  -7.296   2.976  1.00 63.30           C 
ATOM   1971  O   ILE   123     -22.014  -7.048   2.550  1.00 15.23           O 
ATOM   1972  CB  ILE   123     -20.194  -4.867   2.978  1.00 74.12           C 
ATOM   1973  CG1 ILE   123     -18.997  -3.905   3.017  1.00 54.22           C 
ATOM   1974  CG2 ILE   123     -21.003  -4.765   4.277  1.00  1.41           C 
ATOM   1975  CD1 ILE   123     -18.094  -4.109   4.215  1.00 71.10           C 
ATOM   1976  H   ILE   123     -19.665  -6.070   0.620  1.00 36.29           H 
ATOM   1977  HA  ILE   123     -18.918  -6.552   3.422  1.00 35.31           H 
ATOM   1978  HB  ILE   123     -20.843  -4.582   2.160  1.00 71.41           H 
ATOM   1979 3HG1 ILE   123     -19.358  -2.886   3.042  1.00 36.29           H 
ATOM   1980 2HG1 ILE   123     -18.398  -4.045   2.128  1.00 36.29           H 
ATOM   1981 1HG2 ILE   123     -21.283  -3.735   4.449  1.00 36.29           H 
ATOM   1982 2HG2 ILE   123     -20.406  -5.118   5.105  1.00 36.29           H 
ATOM   1983 3HG2 ILE   123     -21.897  -5.370   4.197  1.00 36.29           H 
ATOM   1984 1HD1 ILE   123     -17.717  -5.122   4.218  1.00 36.29           H 
ATOM   1985 2HD1 ILE   123     -18.652  -3.930   5.122  1.00 36.29           H 
ATOM   1986 3HD1 ILE   123     -17.265  -3.418   4.162  1.00 36.29           H 
ATOM   1987  N   GLU   124     -20.594  -8.415   3.642  1.00 50.43           N 
ATOM   1988  CA  GLU   124     -21.624  -9.406   4.008  1.00 72.50           C 
ATOM   1989  C   GLU   124     -22.407  -9.922   2.781  1.00  0.51           C 
ATOM   1990  O   GLU   124     -23.582 -10.275   2.885  1.00  2.31           O 
ATOM   1991  CB  GLU   124     -22.587  -8.789   5.036  1.00  5.20           C 
ATOM   1992  CG  GLU   124     -21.883  -8.290   6.295  1.00 51.14           C 
ATOM   1993  CD  GLU   124     -22.824  -7.630   7.286  1.00 72.34           C 
ATOM   1994  OE1 GLU   124     -23.029  -6.398   7.200  1.00 62.23           O 
ATOM   1995  OE2 GLU   124     -23.355  -8.339   8.163  1.00  1.41           O 
ATOM   1996  H   GLU   124     -19.663  -8.580   3.904  1.00 36.29           H 
ATOM   1997  HA  GLU   124     -21.120 -10.243   4.466  1.00 14.23           H 
ATOM   1998 3HB  GLU   124     -23.315  -9.534   5.324  1.00 36.29           H 
ATOM   1999 2HB  GLU   124     -23.100  -7.953   4.578  1.00 36.29           H 
ATOM   2000 3HG  GLU   124     -21.125  -7.576   6.007  1.00 36.29           H 
ATOM   2001 2HG  GLU   124     -21.410  -9.132   6.782  1.00 36.29           H 
ATOM   2002  N   GLY   125     -21.740  -9.994   1.628  1.00 34.43           N 
ATOM   2003  CA  GLY   125     -22.396 -10.443   0.395  1.00 11.53           C 
ATOM   2004  C   GLY   125     -22.812  -9.294  -0.524  1.00 42.35           C 
ATOM   2005  O   GLY   125     -23.328  -9.521  -1.623  1.00 42.41           O 
ATOM   2006  H   GLY   125     -20.786  -9.770   1.615  1.00 36.29           H 
ATOM   2007 3HA  GLY   125     -23.275 -11.017   0.655  1.00 36.29           H 
ATOM   2008 2HA  GLY   125     -21.713 -11.083  -0.142  1.00 36.29           H 
ATOM   2009  N   ARG   126     -22.592  -8.063  -0.075  1.00 45.25           N 
ATOM   2010  CA  ARG   126     -22.955  -6.864  -0.843  1.00 31.22           C 
ATOM   2011  C   ARG   126     -21.713  -6.201  -1.471  1.00 73.32           C 
ATOM   2012  O   ARG   126     -20.830  -5.721  -0.762  1.00 30.15           O 
ATOM   2013  CB  ARG   126     -23.690  -5.882   0.082  1.00 13.45           C 
ATOM   2014  CG  ARG   126     -23.968  -4.510  -0.524  1.00  1.50           C 
ATOM   2015  CD  ARG   126     -24.833  -3.664   0.403  1.00 43.53           C 
ATOM   2016  NE  ARG   126     -24.871  -2.260   0.000  1.00 73.00           N 
ATOM   2017  CZ  ARG   126     -25.952  -1.533  -0.026  1.00 54.42           C 
ATOM   2018  NH1 ARG   126     -27.111  -2.060   0.202  1.00 32.24           N 
ATOM   2019  NH2 ARG   126     -25.872  -0.275  -0.293  1.00 23.22           N 
ATOM   2020  H   ARG   126     -22.182  -7.951   0.808  1.00 36.29           H 
ATOM   2021  HA  ARG   126     -23.626  -7.166  -1.634  1.00  5.14           H 
ATOM   2022 3HB  ARG   126     -23.094  -5.741   0.974  1.00 36.29           H 
ATOM   2023 2HB  ARG   126     -24.636  -6.320   0.364  1.00 36.29           H 
ATOM   2024 3HG  ARG   126     -24.482  -4.637  -1.467  1.00 36.29           H 
ATOM   2025 2HG  ARG   126     -23.029  -4.001  -0.689  1.00 36.29           H 
ATOM   2026 3HD  ARG   126     -24.433  -3.726   1.407  1.00 36.29           H 
ATOM   2027 2HD  ARG   126     -25.839  -4.059   0.396  1.00 36.29           H 
ATOM   2028  HE  ARG   126     -24.020  -1.834  -0.220  1.00 22.03           H 
ATOM   2029 1HH1 ARG   126     -27.187  -3.034   0.399  1.00 36.29           H 
ATOM   2030 2HH1 ARG   126     -27.931  -1.491   0.180  1.00 36.29           H 
ATOM   2031 1HH2 ARG   126     -24.990   0.139  -0.486  1.00 36.29           H 
ATOM   2032 2HH2 ARG   126     -26.697   0.289  -0.284  1.00 36.29           H 
ATOM   2033  N   GLU   127     -21.651  -6.181  -2.805  1.00  3.43           N 
ATOM   2034  CA  GLU   127     -20.499  -5.610  -3.526  1.00 23.43           C 
ATOM   2035  C   GLU   127     -20.452  -4.075  -3.422  1.00 73.44           C 
ATOM   2036  O   GLU   127     -21.470  -3.395  -3.578  1.00 75.52           O 
ATOM   2037  CB  GLU   127     -20.531  -6.031  -5.005  1.00 34.52           C 
ATOM   2038  CG  GLU   127     -20.492  -7.542  -5.217  1.00 23.15           C 
ATOM   2039  CD  GLU   127     -20.491  -7.936  -6.690  1.00 21.12           C 
ATOM   2040  OE1 GLU   127     -21.513  -7.698  -7.369  1.00 32.20           O 
ATOM   2041  OE2 GLU   127     -19.483  -8.500  -7.169  1.00 20.22           O 
ATOM   2042  H   GLU   127     -22.393  -6.564  -3.321  1.00 36.29           H 
ATOM   2043  HA  GLU   127     -19.601  -6.012  -3.075  1.00 63.25           H 
ATOM   2044 3HB  GLU   127     -19.680  -5.597  -5.510  1.00 36.29           H 
ATOM   2045 2HB  GLU   127     -21.437  -5.648  -5.457  1.00 36.29           H 
ATOM   2046 3HG  GLU   127     -21.360  -7.980  -4.743  1.00 36.29           H 
ATOM   2047 2HG  GLU   127     -19.598  -7.934  -4.749  1.00 36.29           H 
ATOM   2048  N   ILE   128     -19.256  -3.544  -3.166  1.00  2.14           N 
ATOM   2049  CA  ILE   128     -19.042  -2.099  -3.017  1.00 13.41           C 
ATOM   2050  C   ILE   128     -18.389  -1.498  -4.276  1.00 60.24           C 
ATOM   2051  O   ILE   128     -17.491  -2.103  -4.868  1.00 23.33           O 
ATOM   2052  CB  ILE   128     -18.137  -1.794  -1.793  1.00 44.41           C 
ATOM   2053  CG1 ILE   128     -18.641  -2.537  -0.542  1.00 63.42           C 
ATOM   2054  CG2 ILE   128     -18.069  -0.288  -1.534  1.00 71.34           C 
ATOM   2055  CD1 ILE   128     -20.042  -2.154  -0.116  1.00 51.12           C 
ATOM   2056  H   ILE   128     -18.488  -4.144  -3.072  1.00 36.29           H 
ATOM   2057  HA  ILE   128     -20.004  -1.626  -2.858  1.00  4.01           H 
ATOM   2058  HB  ILE   128     -17.136  -2.137  -2.021  1.00 64.42           H 
ATOM   2059 3HG1 ILE   128     -17.976  -2.331   0.284  1.00 36.29           H 
ATOM   2060 2HG1 ILE   128     -18.639  -3.601  -0.738  1.00 36.29           H 
ATOM   2061 1HG2 ILE   128     -17.653   0.207  -2.400  1.00 36.29           H 
ATOM   2062 2HG2 ILE   128     -17.442  -0.095  -0.675  1.00 36.29           H 
ATOM   2063 3HG2 ILE   128     -19.063   0.093  -1.346  1.00 36.29           H 
ATOM   2064 1HD1 ILE   128     -20.324  -2.735   0.748  1.00 36.29           H 
ATOM   2065 2HD1 ILE   128     -20.732  -2.351  -0.923  1.00 36.29           H 
ATOM   2066 3HD1 ILE   128     -20.069  -1.103   0.134  1.00 36.29           H 
ATOM   2067  N   ASP   129     -18.830  -0.303  -4.667  1.00 10.23           N 
ATOM   2068  CA  ASP   129     -18.320   0.368  -5.871  1.00 53.10           C 
ATOM   2069  C   ASP   129     -16.919   0.983  -5.656  1.00 64.35           C 
ATOM   2070  O   ASP   129     -16.748   2.206  -5.689  1.00  1.51           O 
ATOM   2071  CB  ASP   129     -19.308   1.456  -6.304  1.00  2.33           C 
ATOM   2072  CG  ASP   129     -20.702   0.910  -6.541  1.00 40.11           C 
ATOM   2073  OD1 ASP   129     -21.429   0.674  -5.552  1.00 24.23           O 
ATOM   2074  OD2 ASP   129     -21.082   0.722  -7.714  1.00 21.40           O 
ATOM   2075  H   ASP   129     -19.529   0.139  -4.141  1.00 36.29           H 
ATOM   2076  HA  ASP   129     -18.255  -0.371  -6.657  1.00 22.45           H 
ATOM   2077 3HB  ASP   129     -18.956   1.911  -7.219  1.00 36.29           H 
ATOM   2078 2HB  ASP   129     -19.364   2.210  -5.531  1.00 36.29           H 
ATOM   2079  N   LEU   130     -15.920   0.130  -5.439  1.00  3.51           N 
ATOM   2080  CA  LEU   130     -14.531   0.578  -5.238  1.00 61.03           C 
ATOM   2081  C   LEU   130     -13.562  -0.220  -6.127  1.00 74.21           C 
ATOM   2082  O   LEU   130     -13.376  -1.421  -5.928  1.00 53.25           O 
ATOM   2083  CB  LEU   130     -14.124   0.427  -3.761  1.00 74.02           C 
ATOM   2084  CG  LEU   130     -14.939   1.257  -2.750  1.00 72.05           C 
ATOM   2085  CD1 LEU   130     -14.503   0.942  -1.319  1.00 35.30           C 
ATOM   2086  CD2 LEU   130     -14.803   2.753  -3.038  1.00 43.21           C 
ATOM   2087  H   LEU   130     -16.116  -0.831  -5.421  1.00 36.29           H 
ATOM   2088  HA  LEU   130     -14.471   1.622  -5.514  1.00 44.34           H 
ATOM   2089 3HB  LEU   130     -13.083   0.710  -3.666  1.00 36.29           H 
ATOM   2090 2HB  LEU   130     -14.217  -0.616  -3.494  1.00 36.29           H 
ATOM   2091  HG  LEU   130     -15.985   0.994  -2.841  1.00 12.31           H 
ATOM   2092 1HD1 LEU   130     -15.095   1.524  -0.625  1.00 36.29           H 
ATOM   2093 2HD1 LEU   130     -13.459   1.188  -1.195  1.00 36.29           H 
ATOM   2094 3HD1 LEU   130     -14.649  -0.110  -1.119  1.00 36.29           H 
ATOM   2095 1HD2 LEU   130     -15.174   2.967  -4.030  1.00 36.29           H 
ATOM   2096 2HD2 LEU   130     -13.763   3.042  -2.973  1.00 36.29           H 
ATOM   2097 3HD2 LEU   130     -15.376   3.313  -2.312  1.00 36.29           H 
ATOM   2098  N   GLY   131     -12.948   0.452  -7.101  1.00 45.24           N 
ATOM   2099  CA  GLY   131     -12.041  -0.222  -8.029  1.00 14.03           C 
ATOM   2100  C   GLY   131     -10.564   0.103  -7.802  1.00 62.02           C 
ATOM   2101  O   GLY   131      -9.718  -0.795  -7.819  1.00  1.13           O 
ATOM   2102  H   GLY   131     -13.122   1.412  -7.203  1.00 36.29           H 
ATOM   2103 3HA  GLY   131     -12.304   0.069  -9.036  1.00 36.29           H 
ATOM   2104 2HA  GLY   131     -12.175  -1.291  -7.937  1.00 36.29           H 
ATOM   2105  N   TYR   132     -10.244   1.385  -7.598  1.00 45.14           N 
ATOM   2106  CA  TYR   132      -8.845   1.811  -7.437  1.00  1.23           C 
ATOM   2107  C   TYR   132      -8.724   3.175  -6.724  1.00 64.11           C 
ATOM   2108  O   TYR   132      -8.341   3.239  -5.553  1.00 23.12           O 
ATOM   2109  CB  TYR   132      -8.156   1.872  -8.812  1.00 71.04           C 
ATOM   2110  CG  TYR   132      -6.671   2.197  -8.754  1.00  1.22           C 
ATOM   2111  CD1 TYR   132      -6.208   3.502  -8.918  1.00 24.34           C 
ATOM   2112  CD2 TYR   132      -5.730   1.194  -8.540  1.00 40.31           C 
ATOM   2113  CE1 TYR   132      -4.858   3.792  -8.869  1.00  2.13           C 
ATOM   2114  CE2 TYR   132      -4.380   1.479  -8.489  1.00 42.44           C 
ATOM   2115  CZ  TYR   132      -3.948   2.778  -8.655  1.00  3.14           C 
ATOM   2116  OH  TYR   132      -2.601   3.065  -8.606  1.00 52.01           O 
ATOM   2117  H   TYR   132     -10.961   2.053  -7.549  1.00 36.29           H 
ATOM   2118  HA  TYR   132      -8.344   1.065  -6.834  1.00 63.41           H 
ATOM   2119 3HB  TYR   132      -8.641   2.630  -9.412  1.00 36.29           H 
ATOM   2120 2HB  TYR   132      -8.266   0.914  -9.303  1.00 36.29           H 
ATOM   2121  HD1 TYR   132      -6.922   4.295  -9.085  1.00 64.32           H 
ATOM   2122  HD2 TYR   132      -6.069   0.176  -8.409  1.00 13.42           H 
ATOM   2123  HE1 TYR   132      -4.519   4.810  -8.997  1.00 20.44           H 
ATOM   2124  HE2 TYR   132      -3.666   0.684  -8.323  1.00 11.35           H 
ATOM   2125  HH  TYR   132      -2.450   3.807  -8.015  1.00  3.43           H 
ATOM   2126  N   GLY   133      -9.071   4.255  -7.436  1.00 51.33           N 
ATOM   2127  CA  GLY   133      -8.870   5.614  -6.924  1.00 13.10           C 
ATOM   2128  C   GLY   133      -9.509   5.864  -5.560  1.00 40.20           C 
ATOM   2129  O   GLY   133      -8.873   6.404  -4.657  1.00 13.21           O 
ATOM   2130  H   GLY   133      -9.477   4.130  -8.322  1.00 36.29           H 
ATOM   2131 3HA  GLY   133      -9.290   6.313  -7.635  1.00 36.29           H 
ATOM   2132 2HA  GLY   133      -7.808   5.801  -6.848  1.00 36.29           H 
ATOM   2133  N   GLU   134     -10.769   5.477  -5.411  1.00 14.42           N 
ATOM   2134  CA  GLU   134     -11.477   5.632  -4.139  1.00 14.32           C 
ATOM   2135  C   GLU   134     -11.047   4.559  -3.127  1.00 52.13           C 
ATOM   2136  O   GLU   134     -11.004   4.806  -1.924  1.00 35.42           O 
ATOM   2137  CB  GLU   134     -12.994   5.561  -4.367  1.00 42.30           C 
ATOM   2138  CG  GLU   134     -13.506   6.514  -5.445  1.00 54.42           C 
ATOM   2139  CD  GLU   134     -13.287   7.985  -5.110  1.00 32.14           C 
ATOM   2140  OE1 GLU   134     -12.181   8.506  -5.365  1.00 10.42           O 
ATOM   2141  OE2 GLU   134     -14.229   8.633  -4.613  1.00  3.31           O 
ATOM   2142  H   GLU   134     -11.236   5.078  -6.174  1.00 36.29           H 
ATOM   2143  HA  GLU   134     -11.229   6.606  -3.738  1.00 11.20           H 
ATOM   2144 3HB  GLU   134     -13.499   5.797  -3.440  1.00 36.29           H 
ATOM   2145 2HB  GLU   134     -13.256   4.553  -4.656  1.00 36.29           H 
ATOM   2146 3HG  GLU   134     -14.565   6.343  -5.580  1.00 36.29           H 
ATOM   2147 2HG  GLU   134     -12.991   6.294  -6.371  1.00 36.29           H 
ATOM   2148  N   ALA   135     -10.703   3.373  -3.630  1.00 32.24           N 
ATOM   2149  CA  ALA   135     -10.360   2.223  -2.778  1.00 13.22           C 
ATOM   2150  C   ALA   135      -9.159   2.502  -1.854  1.00 64.43           C 
ATOM   2151  O   ALA   135      -9.058   1.931  -0.768  1.00 72.22           O 
ATOM   2152  CB  ALA   135     -10.092   0.994  -3.640  1.00  0.25           C 
ATOM   2153  H   ALA   135     -10.672   3.267  -4.603  1.00 36.29           H 
ATOM   2154  HA  ALA   135     -11.223   2.006  -2.160  1.00 21.24           H 
ATOM   2155 1HB  ALA   135      -9.200   1.152  -4.231  1.00 36.29           H 
ATOM   2156 2HB  ALA   135     -10.932   0.825  -4.300  1.00 36.29           H 
ATOM   2157 3HB  ALA   135      -9.956   0.128  -3.007  1.00 36.29           H 
ATOM   2158  N   THR   136      -8.253   3.382  -2.283  1.00  1.31           N 
ATOM   2159  CA  THR   136      -7.082   3.750  -1.460  1.00 43.53           C 
ATOM   2160  C   THR   136      -7.462   4.690  -0.303  1.00 35.52           C 
ATOM   2161  O   THR   136      -6.651   4.957   0.586  1.00  1.42           O 
ATOM   2162  CB  THR   136      -5.969   4.427  -2.303  1.00  2.12           C 
ATOM   2163  OG1 THR   136      -4.807   4.668  -1.493  1.00 12.44           O 
ATOM   2164  CG2 THR   136      -6.450   5.744  -2.903  1.00 50.10           C 
ATOM   2165  H   THR   136      -8.361   3.783  -3.175  1.00 36.29           H 
ATOM   2166  HA  THR   136      -6.676   2.838  -1.042  1.00 73.22           H 
ATOM   2167  HB  THR   136      -5.698   3.759  -3.110  1.00 11.11           H 
ATOM   2168  HG1 THR   136      -5.076   5.022  -0.638  1.00 72.40           H 
ATOM   2169 1HG2 THR   136      -7.315   5.565  -3.525  1.00 36.29           H 
ATOM   2170 2HG2 THR   136      -5.662   6.178  -3.501  1.00 36.29           H 
ATOM   2171 3HG2 THR   136      -6.715   6.429  -2.109  1.00 36.29           H 
ATOM   2172  N   LYS   137      -8.693   5.194  -0.325  1.00  0.45           N 
ATOM   2173  CA  LYS   137      -9.171   6.133   0.698  1.00 32.52           C 
ATOM   2174  C   LYS   137      -9.853   5.400   1.868  1.00  3.21           C 
ATOM   2175  O   LYS   137     -10.067   5.980   2.938  1.00  4.43           O 
ATOM   2176  CB  LYS   137     -10.137   7.139   0.054  1.00 72.22           C 
ATOM   2177  CG  LYS   137      -9.533   7.870  -1.145  1.00 73.34           C 
ATOM   2178  CD  LYS   137     -10.552   8.761  -1.852  1.00 23.35           C 
ATOM   2179  CE  LYS   137      -9.944   9.465  -3.064  1.00 30.11           C 
ATOM   2180  NZ  LYS   137     -10.926  10.344  -3.752  1.00 45.11           N 
ATOM   2181  H   LYS   137      -9.299   4.933  -1.050  1.00 36.29           H 
ATOM   2182  HA  LYS   137      -8.316   6.671   1.084  1.00 52.10           H 
ATOM   2183 3HB  LYS   137     -10.423   7.874   0.792  1.00 36.29           H 
ATOM   2184 2HB  LYS   137     -11.022   6.611  -0.278  1.00 36.29           H 
ATOM   2185 3HG  LYS   137      -9.162   7.136  -1.848  1.00 36.29           H 
ATOM   2186 2HG  LYS   137      -8.712   8.485  -0.804  1.00 36.29           H 
ATOM   2187 3HD  LYS   137     -10.909   9.506  -1.155  1.00 36.29           H 
ATOM   2188 2HD  LYS   137     -11.381   8.150  -2.182  1.00 36.29           H 
ATOM   2189 3HE  LYS   137      -9.595   8.717  -3.761  1.00 36.29           H 
ATOM   2190 2HE  LYS   137      -9.108  10.067  -2.736  1.00 36.29           H 
ATOM   2191 1HZ  LYS   137     -10.459  10.867  -4.522  1.00 36.29           H 
ATOM   2192 2HZ  LYS   137     -11.333  11.027  -3.081  1.00 36.29           H 
ATOM   2193 3HZ  LYS   137     -11.695   9.771  -4.159  1.00 36.29           H 
ATOM   2194  N   ILE   138     -10.192   4.126   1.658  1.00 60.30           N 
ATOM   2195  CA  ILE   138     -10.785   3.292   2.714  1.00 62.30           C 
ATOM   2196  C   ILE   138      -9.712   2.400   3.357  1.00 50.30           C 
ATOM   2197  O   ILE   138      -9.086   1.582   2.678  1.00 52.20           O 
ATOM   2198  CB  ILE   138     -11.935   2.386   2.180  1.00 71.20           C 
ATOM   2199  CG1 ILE   138     -13.093   3.223   1.601  1.00  0.22           C 
ATOM   2200  CG2 ILE   138     -12.456   1.467   3.290  1.00 55.43           C 
ATOM   2201  CD1 ILE   138     -12.779   3.906   0.287  1.00 51.44           C 
ATOM   2202  H   ILE   138     -10.031   3.732   0.775  1.00 36.29           H 
ATOM   2203  HA  ILE   138     -11.193   3.950   3.471  1.00 42.11           H 
ATOM   2204  HB  ILE   138     -11.530   1.759   1.397  1.00 72.45           H 
ATOM   2205 3HG1 ILE   138     -13.364   3.990   2.315  1.00 36.29           H 
ATOM   2206 2HG1 ILE   138     -13.947   2.581   1.438  1.00 36.29           H 
ATOM   2207 1HG2 ILE   138     -13.269   0.864   2.909  1.00 36.29           H 
ATOM   2208 2HG2 ILE   138     -12.808   2.063   4.118  1.00 36.29           H 
ATOM   2209 3HG2 ILE   138     -11.659   0.819   3.628  1.00 36.29           H 
ATOM   2210 1HD1 ILE   138     -12.508   3.166  -0.450  1.00 36.29           H 
ATOM   2211 2HD1 ILE   138     -11.957   4.594   0.425  1.00 36.29           H 
ATOM   2212 3HD1 ILE   138     -13.648   4.450  -0.053  1.00 36.29           H 
ATOM   2213  N   TRP   139      -9.507   2.557   4.663  1.00 34.04           N 
ATOM   2214  CA  TRP   139      -8.464   1.812   5.381  1.00 62.21           C 
ATOM   2215  C   TRP   139      -9.060   0.686   6.244  1.00 73.43           C 
ATOM   2216  O   TRP   139     -10.042   0.886   6.972  1.00 54.32           O 
ATOM   2217  CB  TRP   139      -7.639   2.774   6.242  1.00 72.31           C 
ATOM   2218  CG  TRP   139      -6.849   3.766   5.435  1.00 12.05           C 
ATOM   2219  CD1 TRP   139      -7.347   4.748   4.628  1.00 14.33           C 
ATOM   2220  CD2 TRP   139      -5.420   3.875   5.361  1.00 24.53           C 
ATOM   2221  NE1 TRP   139      -6.319   5.453   4.052  1.00 52.22           N 
ATOM   2222  CE2 TRP   139      -5.129   4.938   4.487  1.00 34.30           C 
ATOM   2223  CE3 TRP   139      -4.360   3.175   5.944  1.00 50.24           C 
ATOM   2224  CZ2 TRP   139      -3.822   5.321   4.189  1.00 25.22           C 
ATOM   2225  CZ3 TRP   139      -3.064   3.555   5.648  1.00 32.41           C 
ATOM   2226  CH2 TRP   139      -2.805   4.618   4.775  1.00 30.23           C 
ATOM   2227  H   TRP   139     -10.074   3.183   5.164  1.00 36.29           H 
ATOM   2228  HA  TRP   139      -7.812   1.366   4.641  1.00 33.35           H 
ATOM   2229 3HB  TRP   139      -6.944   2.207   6.846  1.00 36.29           H 
ATOM   2230 2HB  TRP   139      -8.303   3.327   6.891  1.00 36.29           H 
ATOM   2231  HD1 TRP   139      -8.399   4.928   4.470  1.00 44.54           H 
ATOM   2232  HE1 TRP   139      -6.424   6.204   3.431  1.00 35.00           H 
ATOM   2233  HE3 TRP   139      -4.540   2.349   6.620  1.00 21.20           H 
ATOM   2234  HZ2 TRP   139      -3.605   6.140   3.518  1.00 53.50           H 
ATOM   2235  HZ3 TRP   139      -2.234   3.026   6.092  1.00 34.22           H 
ATOM   2236  HH2 TRP   139      -1.777   4.881   4.571  1.00 14.23           H 
ATOM   2237  N   VAL   140      -8.449  -0.496   6.161  1.00  0.54           N 
ATOM   2238  CA  VAL   140      -8.938  -1.696   6.851  1.00 32.24           C 
ATOM   2239  C   VAL   140      -7.802  -2.448   7.571  1.00 64.04           C 
ATOM   2240  O   VAL   140      -6.622  -2.139   7.395  1.00 32.00           O 
ATOM   2241  CB  VAL   140      -9.619  -2.665   5.851  1.00 10.53           C 
ATOM   2242  CG1 VAL   140     -10.863  -2.025   5.239  1.00 65.31           C 
ATOM   2243  CG2 VAL   140      -8.634  -3.094   4.760  1.00 12.24           C 
ATOM   2244  H   VAL   140      -7.634  -0.566   5.620  1.00 36.29           H 
ATOM   2245  HA  VAL   140      -9.673  -1.391   7.585  1.00 32.01           H 
ATOM   2246  HB  VAL   140      -9.930  -3.549   6.392  1.00  4.45           H 
ATOM   2247 1HG1 VAL   140     -10.581  -1.133   4.698  1.00 36.29           H 
ATOM   2248 2HG1 VAL   140     -11.558  -1.767   6.022  1.00 36.29           H 
ATOM   2249 3HG1 VAL   140     -11.332  -2.722   4.560  1.00 36.29           H 
ATOM   2250 1HG2 VAL   140      -9.113  -3.802   4.097  1.00 36.29           H 
ATOM   2251 2HG2 VAL   140      -7.769  -3.557   5.215  1.00 36.29           H 
ATOM   2252 3HG2 VAL   140      -8.322  -2.229   4.194  1.00 36.29           H 
ATOM   2253  N   ARG   141      -8.170  -3.442   8.383  1.00 63.11           N 
ATOM   2254  CA  ARG   141      -7.185  -4.279   9.087  1.00 51.13           C 
ATOM   2255  C   ARG   141      -7.414  -5.772   8.793  1.00 12.45           C 
ATOM   2256  O   ARG   141      -8.551  -6.218   8.640  1.00 24.20           O 
ATOM   2257  CB  ARG   141      -7.246  -4.032  10.602  1.00  0.25           C 
ATOM   2258  CG  ARG   141      -7.161  -2.558  10.991  1.00  0.14           C 
ATOM   2259  CD  ARG   141      -6.786  -2.374  12.455  1.00 54.21           C 
ATOM   2260  NE  ARG   141      -5.429  -2.848  12.727  1.00 53.01           N 
ATOM   2261  CZ  ARG   141      -4.869  -2.849  13.904  1.00 10.01           C 
ATOM   2262  NH1 ARG   141      -5.511  -2.417  14.941  1.00 24.05           N 
ATOM   2263  NH2 ARG   141      -3.659  -3.286  14.042  1.00 32.42           N 
ATOM   2264  H   ARG   141      -9.125  -3.617   8.517  1.00 36.29           H 
ATOM   2265  HA  ARG   141      -6.202  -4.006   8.728  1.00 31.52           H 
ATOM   2266 3HB  ARG   141      -6.424  -4.555  11.071  1.00 36.29           H 
ATOM   2267 2HB  ARG   141      -8.176  -4.430  10.984  1.00 36.29           H 
ATOM   2268 3HG  ARG   141      -8.121  -2.093  10.813  1.00 36.29           H 
ATOM   2269 2HG  ARG   141      -6.411  -2.078  10.380  1.00 36.29           H 
ATOM   2270 3HD  ARG   141      -7.483  -2.930  13.066  1.00 36.29           H 
ATOM   2271 2HD  ARG   141      -6.849  -1.324  12.703  1.00 36.29           H 
ATOM   2272  HE  ARG   141      -4.909  -3.187  11.973  1.00 25.03           H 
ATOM   2273 1HH1 ARG   141      -6.443  -2.080  14.848  1.00 36.29           H 
ATOM   2274 2HH1 ARG   141      -5.073  -2.433  15.838  1.00 36.29           H 
ATOM   2275 1HH2 ARG   141      -3.157  -3.623  13.247  1.00 36.29           H 
ATOM   2276 2HH2 ARG   141      -3.229  -3.293  14.942  1.00 36.29           H 
ATOM   2277  N   ARG   142      -6.328  -6.540   8.717  1.00 31.12           N 
ATOM   2278  CA  ARG   142      -6.410  -7.976   8.407  1.00 50.41           C 
ATOM   2279  C   ARG   142      -6.858  -8.784   9.639  1.00 14.23           C 
ATOM   2280  O   ARG   142      -6.099  -8.953  10.593  1.00 51.22           O 
ATOM   2281  CB  ARG   142      -5.036  -8.463   7.909  1.00  3.44           C 
ATOM   2282  CG  ARG   142      -4.971  -9.932   7.482  1.00 71.22           C 
ATOM   2283  CD  ARG   142      -5.908 -10.249   6.313  1.00 43.30           C 
ATOM   2284  NE  ARG   142      -5.277 -11.114   5.314  1.00  4.21           N 
ATOM   2285  CZ  ARG   142      -5.064 -12.395   5.460  1.00 43.14           C 
ATOM   2286  NH1 ARG   142      -5.406 -12.998   6.554  1.00 73.50           N 
ATOM   2287  NH2 ARG   142      -4.502 -13.067   4.507  1.00 15.44           N 
ATOM   2288  H   ARG   142      -5.449  -6.137   8.876  1.00 36.29           H 
ATOM   2289  HA  ARG   142      -7.136  -8.106   7.617  1.00 11.02           H 
ATOM   2290 3HB  ARG   142      -4.314  -8.313   8.699  1.00 36.29           H 
ATOM   2291 2HB  ARG   142      -4.746  -7.861   7.062  1.00 36.29           H 
ATOM   2292 3HG  ARG   142      -5.242 -10.551   8.327  1.00 36.29           H 
ATOM   2293 2HG  ARG   142      -3.957 -10.159   7.187  1.00 36.29           H 
ATOM   2294 3HD  ARG   142      -6.198  -9.323   5.835  1.00 36.29           H 
ATOM   2295 2HD  ARG   142      -6.790 -10.742   6.697  1.00 36.29           H 
ATOM   2296  HE  ARG   142      -5.003 -10.702   4.473  1.00 13.45           H 
ATOM   2297 1HH1 ARG   142      -5.836 -12.489   7.285  1.00 36.29           H 
ATOM   2298 2HH1 ARG   142      -5.224 -13.976   6.661  1.00 36.29           H 
ATOM   2299 1HH2 ARG   142      -4.233 -12.602   3.661  1.00 36.29           H 
ATOM   2300 2HH2 ARG   142      -4.336 -14.043   4.613  1.00 36.29           H 
ATOM   2301  N   VAL   143      -8.093  -9.288   9.607  1.00 22.51           N 
ATOM   2302  CA  VAL   143      -8.649 -10.049  10.739  1.00 13.35           C 
ATOM   2303  C   VAL   143      -8.612 -11.568  10.496  1.00 21.13           C 
ATOM   2304  O   VAL   143      -8.180 -12.329  11.365  1.00 62.05           O 
ATOM   2305  CB  VAL   143     -10.104  -9.615  11.064  1.00 33.44           C 
ATOM   2306  CG1 VAL   143     -10.136  -8.189  11.600  1.00  3.53           C 
ATOM   2307  CG2 VAL   143     -11.010  -9.743   9.841  1.00 65.43           C 
ATOM   2308  H   VAL   143      -8.652  -9.131   8.816  1.00 36.29           H 
ATOM   2309  HA  VAL   143      -8.039  -9.831  11.608  1.00 35.11           H 
ATOM   2310  HB  VAL   143     -10.487 -10.271  11.836  1.00 21.23           H 
ATOM   2311 1HG1 VAL   143      -9.552  -8.129  12.505  1.00 36.29           H 
ATOM   2312 2HG1 VAL   143     -11.158  -7.908  11.812  1.00 36.29           H 
ATOM   2313 3HG1 VAL   143      -9.726  -7.516  10.859  1.00 36.29           H 
ATOM   2314 1HG2 VAL   143     -10.646  -9.098   9.053  1.00 36.29           H 
ATOM   2315 2HG2 VAL   143     -12.017  -9.455  10.104  1.00 36.29           H 
ATOM   2316 3HG2 VAL   143     -11.011 -10.768   9.497  1.00 36.29           H 
END
