
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   75 ( 1111),  selected   75 , name 2gcx_A
# Molecule2: number of CA atoms  142 ( 2309),  selected  142 , name T0462.pdb
# PARAMETERS: 2gcx_A.T0462.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      M       1           #
LGA    -       -      K       2           -
LGA    -       -      L       3           -
LGA    -       -      S       4           -
LGA    Q     2_A      R       5          3.882
LGA    F     3_A      L       6          2.369
LGA    T     4_A      V       7          2.640
LGA    P     5_A      P       8          1.677
LGA    D     6_A      G       9          1.870
LGA    S     7_A      V      10          1.447
LGA    A     8_A      P      11          1.524
LGA    W     9_A      A      12          1.553
LGA    K    10_A      R      13          2.003
LGA    I    11_A      I      14          2.537
LGA    T    12_A      K      15          3.447
LGA    G    13_A      R      16          4.272
LGA    F    14_A      L      17          1.905
LGA    S    15_A      E      18          1.224
LGA    R    16_A      -       -           -
LGA    D    17_A      -       -           -
LGA    I    18_A      V      19          1.357
LGA    S    19_A      S      20          3.511
LGA    P    20_A      G      21          1.731
LGA    A    21_A      E      22          1.845
LGA    Y    22_A      L      23          2.058
LGA    R    23_A      H      24          1.210
LGA    Q    24_A      E      25          1.557
LGA    K    25_A      K      26          2.235
LGA    L    26_A      L      27          2.922
LGA    L    27_A      V      28          2.878
LGA    S    28_A      G      29          2.842
LGA    L    29_A      M      30          4.446
LGA    G    30_A      G      31          4.893
LGA    M    31_A      F      32          3.973
LGA    L    32_A      V      33          1.545
LGA    P    33_A      P      34          1.290
LGA    G    34_A      G      35          2.102
LGA    S    35_A      E      36          1.047
LGA    S    36_A      E      37          0.219
LGA    F    37_A      I      38          1.341
LGA    H    38_A      E      39          1.154
LGA    V    39_A      I      40          0.642
LGA    V    40_A      V      41          1.405
LGA    R    41_A      Q      42          1.408
LGA    V    42_A      V      43          2.349
LGA    -       -      A      44           -
LGA    A    43_A      P      45          4.856
LGA    P    44_A      -       -           -
LGA    L    45_A      L      46          5.953
LGA    G    46_A      G      47          2.199
LGA    D    47_A      D      48          1.494
LGA    P    48_A      P      49          0.952
LGA    V    49_A      I      50          0.588
LGA    H    50_A      V      51          1.103
LGA    I    51_A      C      52          1.175
LGA    E    52_A      K      53          0.660
LGA    T    53_A      I      54          1.733
LGA    R    54_A      G      55          1.741
LGA    R    55_A      N      56          2.588
LGA    V    56_A      R      57          1.626
LGA    S    57_A      N      58          1.418
LGA    L    58_A      I      59          1.016
LGA    V    59_A      T      60          1.097
LGA    L    60_A      L      61          0.902
LGA    R    61_A      R      62          1.390
LGA    K    62_A      K      63          2.065
LGA    K    63_A      R      64          2.460
LGA    D    64_A      E      65          1.920
LGA    L    65_A      A      66          1.267
LGA    A    66_A      D      67          1.412
LGA    L    67_A      L      68          1.607
LGA    I    68_A      I      69          1.695
LGA    E    69_A      E      70          1.213
LGA    L    70_A      V      71          1.663
LGA    E    71_A      E      72          1.266
LGA    A    72_A      V      73          1.100
LGA    V    73_A      V      74          0.899
LGA    A    74_A      G      75          3.429
LGA    Q    75_A      E      77          4.436
LGA    -       -      L      78           -
LGA    -       -      P      79           -
LGA    -       -      L      80           -
LGA    -       -      I      81           -
LGA    -       -      L      82           -
LGA    -       -      A      83           -
LGA    -       -      D      84           -
LGA    -       -      D      85           -
LGA    -       -      G      86           -
LGA    -       -      T      87           -
LGA    -       -      Y      88           -
LGA    -       -      E      89           -
LGA    -       -      I      90           -
LGA    -       -      T      91           -
LGA    -       -      K      92           -
LGA    -       -      L      93           -
LGA    -       -      N      94           -
LGA    -       -      G      95           -
LGA    -       -      G      96           -
LGA    -       -      R      97           -
LGA    -       -      R      98           -
LGA    -       -      F      99           -
LGA    -       -      L     100           -
LGA    -       -      F     101           -
LGA    -       -      R     102           -
LGA    -       -      M     103           -
LGA    -       -      K     104           -
LGA    -       -      N     105           -
LGA    -       -      L     106           -
LGA    -       -      G     107           -
LGA    -       -      I     108           -
LGA    -       -      E     109           -
LGA    -       -      S     110           -
LGA    -       -      G     111           -
LGA    -       -      K     112           -
LGA    -       -      K     113           -
LGA    -       -      I     114           -
LGA    -       -      Q     115           -
LGA    -       -      V     116           -
LGA    -       -      S     117           -
LGA    -       -      G     118           -
LGA    -       -      R     119           -
LGA    -       -      R     120           -
LGA    -       -      Y     121           -
LGA    -       -      Y     122           -
LGA    -       -      I     123           -
LGA    -       -      E     124           -
LGA    -       -      G     125           -
LGA    -       -      R     126           -
LGA    -       -      E     127           -
LGA    -       -      I     128           -
LGA    -       -      D     129           -
LGA    -       -      L     130           -
LGA    -       -      G     131           -
LGA    -       -      Y     132           -
LGA    -       -      G     133           -
LGA    -       -      E     134           -
LGA    -       -      A     135           -
LGA    -       -      T     136           -
LGA    -       -      K     137           -
LGA    -       -      I     138           -
LGA    -       -      W     139           -
LGA    -       -      V     140           -
LGA    -       -      R     141           -
LGA    -       -      R     142           -
LGA    -       -      V     143           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   75  142    5.0     71    2.32    30.99     37.185     2.933

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.165454 * X  +  -0.939408 * Y  +   0.300229 * Z  +  10.130219
  Y_new =  -0.446563 * X  +   0.200066 * Y  +   0.872098 * Z  +   0.197338
  Z_new =  -0.879322 * X  +  -0.278364 * Y  +  -0.386403 * Z  +   0.438125 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.517308    0.624285  [ DEG:  -144.2311     35.7689 ]
  Theta =   1.074436    2.067157  [ DEG:    61.5606    118.4394 ]
  Phi   =  -1.215971    1.925622  [ DEG:   -69.6700    110.3300 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gcx_A                                        
REMARK     2: T0462.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gcx_A.T0462.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   75  142   5.0   71   2.32   30.99  37.185
REMARK  ---------------------------------------------------------- 
MOLECULE 2gcx_A
HEADER    TRANSPORT PROTEIN                       14-MAR-06   2GCX              
TITLE     SOLUTION STRUCTURE OF FERROUS IRON TRANSPORT PROTEIN A                
TITLE    2 (FEOA) OF KLEBSIELLA PNEUMONIAE                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FERROUS IRON TRANSPORT PROTEIN A;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: FEOA;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: KLEBSIELLA PNEUMONIAE;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-22B(+)                                
KEYWDS    KLEBSIELLA PNEUMONIAE, FEOA, FERROUS IRON TRANSPORT PROTEIN           
KEYWDS   2 A, NMR                                                               
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.-W.HUNG,C.-C.CHENG,T.-H.YU,S.-H.WANG,C.-F.CHANG,S.-F.TSAI,          
AUTHOR   2 T.-H.HUANG                                                           
REVDAT   1   20-MAR-07 2GCX    0                                                
JRNL        AUTH   K.-W.HUNG,C.-C.CHENG,T.-H.YU,S.-H.WANG,C.-F.CHANG,           
JRNL        AUTH 2 S.-F.TSAI,T.-H.HUANG                                         
JRNL        TITL   SOLUTION STRUCTURE OF FERROUS IRON TRANSPORT                 
JRNL        TITL 2 PROTEIN A (FEOA) OF KLEBSIELLA PNEUMONIAE                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
SEQRES   1 A   75  MET GLN PHE THR PRO ASP SER ALA TRP LYS ILE THR GLY          
SEQRES   2 A   75  PHE SER ARG ASP ILE SER PRO ALA TYR ARG GLN LYS LEU          
SEQRES   3 A   75  LEU SER LEU GLY MET LEU PRO GLY SER SER PHE HIS VAL          
SEQRES   4 A   75  VAL ARG VAL ALA PRO LEU GLY ASP PRO VAL HIS ILE GLU          
SEQRES   5 A   75  THR ARG ARG VAL SER LEU VAL LEU ARG LYS LYS ASP LEU          
SEQRES   6 A   75  ALA LEU ILE GLU LEU GLU ALA VAL ALA GLN                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      -3.833  -0.367  -0.914  1.00  3.33           N  
ATOM      2  CA  MET A   1      -3.346  -1.159  -2.073  1.00  2.78           C  
ATOM      3  C   MET A   1      -2.257  -0.404  -2.830  1.00  2.08           C  
ATOM      4  O   MET A   1      -1.228  -0.977  -3.189  1.00  2.36           O  
ATOM      5  CB  MET A   1      -4.507  -1.477  -3.018  1.00  2.93           C  
ATOM      6  CG  MET A   1      -4.098  -2.301  -4.229  1.00  3.53           C  
ATOM      7  SD  MET A   1      -3.489  -3.938  -3.781  1.00  4.37           S  
ATOM      8  CE  MET A   1      -3.059  -4.593  -5.392  1.00  5.17           C  
ATOM      9  H2  MET A   1      -3.039  -0.125  -0.287  1.00  3.82           H  
ATOM     10  HA  MET A   1      -2.930  -2.085  -1.700  1.00  3.41           H  
ATOM     11  HB2 MET A   1      -5.259  -2.028  -2.473  1.00  2.98           H  
ATOM     12  HG2 MET A   1      -4.954  -2.416  -4.876  1.00  3.81           H  
ATOM     13  HE1 MET A   1      -3.940  -4.619  -6.017  1.00  5.58           H  
ATOM     14  HE2 MET A   1      -2.311  -3.965  -5.848  1.00  5.32           H  
ATOM     15  HE3 MET A   1      -2.668  -5.595  -5.280  1.00  5.50           H  
ATOM     16  H1  MET A   1      -4.280   0.511  -1.244  1.00  3.63           H  
ATOM     17  H3  MET A   1      -4.531  -0.917  -0.374  1.00  3.53           H  
ATOM     18  N   GLN A   2      -2.491   0.882  -3.069  1.00  1.56           N  
ATOM     19  CA  GLN A   2      -1.532   1.710  -3.787  1.00  0.99           C  
ATOM     20  C   GLN A   2      -0.485   2.284  -2.836  1.00  0.83           C  
ATOM     21  O   GLN A   2      -0.669   2.282  -1.619  1.00  1.25           O  
ATOM     22  CB  GLN A   2      -2.254   2.847  -4.513  1.00  1.05           C  
ATOM     23  CG  GLN A   2      -3.369   2.368  -5.422  1.00  1.64           C  
ATOM     24  CD  GLN A   2      -4.201   3.510  -5.977  1.00  2.33           C  
ATOM     25  OE1 GLN A   2      -3.701   4.618  -6.176  1.00  2.91           O  
ATOM     26  NE2 GLN A   2      -5.476   3.243  -6.233  1.00  2.94           N  
ATOM     27  H   GLN A   2      -3.328   1.281  -2.756  1.00  1.91           H  
ATOM     28  HA  GLN A   2      -1.035   1.088  -4.516  1.00  1.23           H  
ATOM     29  HB2 GLN A   2      -2.675   3.518  -3.781  1.00  1.72           H  
ATOM     30  HG2 GLN A   2      -2.930   1.832  -6.246  1.00  2.05           H  
ATOM     31 HE21 GLN A   2      -5.805   2.337  -6.051  1.00  3.09           H  
ATOM     32 HE22 GLN A   2      -6.037   3.961  -6.594  1.00  3.52           H  
ATOM     33  N   PHE A   3       0.614   2.773  -3.402  1.00  0.64           N  
ATOM     34  CA  PHE A   3       1.692   3.351  -2.609  1.00  0.59           C  
ATOM     35  C   PHE A   3       1.785   4.857  -2.837  1.00  0.50           C  
ATOM     36  O   PHE A   3       2.165   5.307  -3.917  1.00  0.55           O  
ATOM     37  CB  PHE A   3       3.024   2.685  -2.960  1.00  0.80           C  
ATOM     38  CG  PHE A   3       3.049   1.208  -2.687  1.00  0.75           C  
ATOM     39  CD1 PHE A   3       2.660   0.302  -3.660  1.00  0.80           C  
ATOM     40  CD2 PHE A   3       3.464   0.724  -1.456  1.00  1.47           C  
ATOM     41  CE1 PHE A   3       2.684  -1.057  -3.411  1.00  1.39           C  
ATOM     42  CE2 PHE A   3       3.490  -0.633  -1.200  1.00  2.25           C  
ATOM     43  CZ  PHE A   3       3.097  -1.525  -2.180  1.00  2.18           C  
ATOM     44  H   PHE A   3       0.702   2.743  -4.379  1.00  0.92           H  
ATOM     45  HA  PHE A   3       1.471   3.169  -1.568  1.00  0.71           H  
ATOM     46  HB2 PHE A   3       3.226   2.833  -4.010  1.00  1.45           H  
ATOM     47  HD1 PHE A   3       2.335   0.668  -4.624  1.00  0.91           H  
ATOM     48  HD2 PHE A   3       3.768   1.421  -0.689  1.00  1.57           H  
ATOM     49  HE1 PHE A   3       2.379  -1.752  -4.179  1.00  1.42           H  
ATOM     50  HE2 PHE A   3       3.813  -0.998  -0.237  1.00  2.96           H  
ATOM     51  HZ  PHE A   3       3.117  -2.588  -1.984  1.00  2.81           H  
ATOM     52  N   THR A   4       1.434   5.628  -1.812  1.00  0.53           N  
ATOM     53  CA  THR A   4       1.478   7.082  -1.902  1.00  0.49           C  
ATOM     54  C   THR A   4       2.612   7.660  -1.060  1.00  0.45           C  
ATOM     55  O   THR A   4       2.989   7.086  -0.038  1.00  0.45           O  
ATOM     56  CB  THR A   4       0.149   7.715  -1.454  1.00  0.57           C  
ATOM     57  OG1 THR A   4      -0.235   7.191  -0.175  1.00  0.61           O  
ATOM     58  CG2 THR A   4      -0.947   7.444  -2.472  1.00  0.66           C  
ATOM     59  H   THR A   4       1.136   5.209  -0.979  1.00  0.66           H  
ATOM     60  HA  THR A   4       1.644   7.349  -2.937  1.00  0.50           H  
ATOM     61  HB  THR A   4       0.285   8.783  -1.369  1.00  0.57           H  
ATOM     62  HG1 THR A   4      -1.153   7.414   0.001  1.00  1.09           H  
ATOM     63 HG21 THR A   4      -1.874   7.883  -2.130  1.00  1.23           H  
ATOM     64 HG22 THR A   4      -1.075   6.380  -2.589  1.00  1.30           H  
ATOM     65 HG23 THR A   4      -0.672   7.881  -3.420  1.00  1.11           H  
ATOM     66  N   PRO A   5       3.169   8.809  -1.481  1.00  0.47           N  
ATOM     67  CA  PRO A   5       4.262   9.465  -0.761  1.00  0.51           C  
ATOM     68  C   PRO A   5       3.799  10.094   0.549  1.00  0.51           C  
ATOM     69  O   PRO A   5       3.472  11.279   0.601  1.00  0.65           O  
ATOM     70  CB  PRO A   5       4.730  10.546  -1.740  1.00  0.62           C  
ATOM     71  CG  PRO A   5       3.530  10.849  -2.569  1.00  0.58           C  
ATOM     72  CD  PRO A   5       2.776   9.555  -2.694  1.00  0.53           C  
ATOM     73  HA  PRO A   5       5.073   8.780  -0.564  1.00  0.60           H  
ATOM     74  HB2 PRO A   5       5.063  11.414  -1.190  1.00  0.77           H  
ATOM     75  HG2 PRO A   5       2.921  11.593  -2.076  1.00  0.73           H  
ATOM     76  HD2 PRO A   5       1.711   9.739  -2.704  1.00  0.56           H  
ATOM     77  N   ASP A   6       3.770   9.286   1.605  1.00  0.74           N  
ATOM     78  CA  ASP A   6       3.350   9.757   2.921  1.00  0.84           C  
ATOM     79  C   ASP A   6       3.355   8.617   3.933  1.00  0.71           C  
ATOM     80  O   ASP A   6       3.748   8.801   5.086  1.00  0.67           O  
ATOM     81  CB  ASP A   6       1.950  10.373   2.844  1.00  1.07           C  
ATOM     82  CG  ASP A   6       0.917   9.399   2.313  1.00  2.06           C  
ATOM     83  OD1 ASP A   6       0.734   9.339   1.079  1.00  2.69           O  
ATOM     84  OD2 ASP A   6       0.293   8.692   3.132  1.00  2.51           O  
ATOM     85  H   ASP A   6       4.037   8.350   1.497  1.00  0.97           H  
ATOM     86  HA  ASP A   6       4.050  10.513   3.242  1.00  0.95           H  
ATOM     87  HB2 ASP A   6       1.648  10.686   3.830  1.00  1.14           H  
ATOM     88  N   SER A   7       2.916   7.442   3.498  1.00  0.77           N  
ATOM     89  CA  SER A   7       2.870   6.274   4.369  1.00  0.72           C  
ATOM     90  C   SER A   7       4.218   5.559   4.395  1.00  0.54           C  
ATOM     91  O   SER A   7       5.072   5.792   3.539  1.00  0.67           O  
ATOM     92  CB  SER A   7       1.775   5.312   3.906  1.00  0.96           C  
ATOM     93  OG  SER A   7       1.726   4.161   4.731  1.00  1.89           O  
ATOM     94  H   SER A   7       2.614   7.359   2.569  1.00  0.90           H  
ATOM     95  HA  SER A   7       2.639   6.614   5.367  1.00  0.72           H  
ATOM     96  HB2 SER A   7       0.819   5.811   3.947  1.00  1.05           H  
ATOM     97  HG  SER A   7       1.945   3.384   4.210  1.00  2.32           H  
ATOM     98  N   ALA A   8       4.401   4.688   5.382  1.00  0.47           N  
ATOM     99  CA  ALA A   8       5.649   3.941   5.521  1.00  0.35           C  
ATOM    100  C   ALA A   8       5.484   2.498   5.054  1.00  0.31           C  
ATOM    101  O   ALA A   8       4.364   2.015   4.878  1.00  0.38           O  
ATOM    102  CB  ALA A   8       6.123   3.979   6.967  1.00  0.44           C  
ATOM    103  H   ALA A   8       3.682   4.542   6.031  1.00  0.66           H  
ATOM    104  HA  ALA A   8       6.395   4.424   4.909  1.00  0.35           H  
ATOM    105  HB1 ALA A   8       5.432   3.429   7.588  1.00  1.16           H  
ATOM    106  HB2 ALA A   8       7.103   3.528   7.034  1.00  1.04           H  
ATOM    107  HB3 ALA A   8       6.174   5.002   7.303  1.00  1.13           H  
ATOM    108  N   TRP A   9       6.607   1.815   4.853  1.00  0.30           N  
ATOM    109  CA  TRP A   9       6.593   0.425   4.406  1.00  0.30           C  
ATOM    110  C   TRP A   9       7.871  -0.294   4.828  1.00  0.32           C  
ATOM    111  O   TRP A   9       8.790   0.320   5.371  1.00  0.39           O  
ATOM    112  CB  TRP A   9       6.435   0.357   2.887  1.00  0.34           C  
ATOM    113  CG  TRP A   9       5.242   1.110   2.380  1.00  0.35           C  
ATOM    114  CD1 TRP A   9       5.186   2.437   2.063  1.00  0.40           C  
ATOM    115  CD2 TRP A   9       3.935   0.582   2.131  1.00  0.42           C  
ATOM    116  NE1 TRP A   9       3.924   2.764   1.632  1.00  0.41           N  
ATOM    117  CE2 TRP A   9       3.137   1.645   1.664  1.00  0.42           C  
ATOM    118  CE3 TRP A   9       3.358  -0.686   2.256  1.00  0.56           C  
ATOM    119  CZ2 TRP A   9       1.797   1.478   1.325  1.00  0.52           C  
ATOM    120  CZ3 TRP A   9       2.029  -0.851   1.917  1.00  0.69           C  
ATOM    121  CH2 TRP A   9       1.261   0.225   1.456  1.00  0.66           C  
ATOM    122  H   TRP A   9       7.468   2.256   5.009  1.00  0.34           H  
ATOM    123  HA  TRP A   9       5.748  -0.064   4.870  1.00  0.31           H  
ATOM    124  HB2 TRP A   9       7.314   0.775   2.422  1.00  0.36           H  
ATOM    125  HD1 TRP A   9       6.021   3.116   2.145  1.00  0.49           H  
ATOM    126  HE1 TRP A   9       3.635   3.658   1.348  1.00  0.47           H  
ATOM    127  HE3 TRP A   9       3.935  -1.528   2.610  1.00  0.60           H  
ATOM    128  HZ2 TRP A   9       1.191   2.296   0.967  1.00  0.54           H  
ATOM    129  HZ3 TRP A   9       1.567  -1.824   2.009  1.00  0.84           H  
ATOM    130  HH2 TRP A   9       0.226   0.051   1.204  1.00  0.77           H  
ATOM    131  N   LYS A  10       7.926  -1.599   4.575  1.00  0.34           N  
ATOM    132  CA  LYS A  10       9.094  -2.397   4.927  1.00  0.37           C  
ATOM    133  C   LYS A  10       9.598  -3.190   3.725  1.00  0.34           C  
ATOM    134  O   LYS A  10       8.814  -3.809   3.004  1.00  0.34           O  
ATOM    135  CB  LYS A  10       8.763  -3.346   6.080  1.00  0.43           C  
ATOM    136  CG  LYS A  10       8.366  -2.629   7.361  1.00  1.01           C  
ATOM    137  CD  LYS A  10       7.943  -3.609   8.442  1.00  1.03           C  
ATOM    138  CE  LYS A  10       7.600  -2.891   9.738  1.00  1.28           C  
ATOM    139  NZ  LYS A  10       7.129  -3.835  10.788  1.00  2.04           N  
ATOM    140  H   LYS A  10       7.163  -2.035   4.142  1.00  0.40           H  
ATOM    141  HA  LYS A  10       9.872  -1.719   5.245  1.00  0.42           H  
ATOM    142  HB2 LYS A  10       7.945  -3.985   5.781  1.00  0.74           H  
ATOM    143  HG2 LYS A  10       9.209  -2.056   7.715  1.00  1.60           H  
ATOM    144  HD2 LYS A  10       7.075  -4.153   8.103  1.00  1.63           H  
ATOM    145  HE2 LYS A  10       8.481  -2.379  10.095  1.00  1.73           H  
ATOM    146  HZ1 LYS A  10       6.258  -4.312  10.477  1.00  2.50           H  
ATOM    147  HZ2 LYS A  10       6.931  -3.319  11.670  1.00  2.52           H  
ATOM    148  HZ3 LYS A  10       7.856  -4.554  10.976  1.00  2.42           H  
ATOM    149  N   ILE A  11      10.912  -3.168   3.514  1.00  0.36           N  
ATOM    150  CA  ILE A  11      11.521  -3.879   2.398  1.00  0.36           C  
ATOM    151  C   ILE A  11      11.556  -5.382   2.651  1.00  0.32           C  
ATOM    152  O   ILE A  11      12.063  -5.840   3.677  1.00  0.38           O  
ATOM    153  CB  ILE A  11      12.954  -3.381   2.131  1.00  0.41           C  
ATOM    154  CG1 ILE A  11      12.951  -1.872   1.872  1.00  0.48           C  
ATOM    155  CG2 ILE A  11      13.568  -4.123   0.951  1.00  0.43           C  
ATOM    156  CD1 ILE A  11      14.323  -1.304   1.583  1.00  0.56           C  
ATOM    157  H   ILE A  11      11.484  -2.663   4.126  1.00  0.39           H  
ATOM    158  HA  ILE A  11      10.927  -3.687   1.517  1.00  0.38           H  
ATOM    159  HB  ILE A  11      13.553  -3.586   3.005  1.00  0.41           H  
ATOM    160 HG12 ILE A  11      12.320  -1.661   1.023  1.00  0.50           H  
ATOM    161 HG21 ILE A  11      14.570  -3.758   0.778  1.00  1.11           H  
ATOM    162 HG22 ILE A  11      13.602  -5.181   1.172  1.00  0.98           H  
ATOM    163 HG23 ILE A  11      12.966  -3.958   0.071  1.00  1.04           H  
ATOM    164 HD11 ILE A  11      14.741  -1.791   0.714  1.00  1.01           H  
ATOM    165 HD12 ILE A  11      14.240  -0.244   1.397  1.00  1.20           H  
ATOM    166 HD13 ILE A  11      14.969  -1.470   2.434  1.00  1.21           H  
ATOM    167  N   THR A  12      11.012  -6.142   1.705  1.00  0.28           N  
ATOM    168  CA  THR A  12      10.976  -7.594   1.808  1.00  0.27           C  
ATOM    169  C   THR A  12      11.270  -8.235   0.455  1.00  0.27           C  
ATOM    170  O   THR A  12      10.555  -9.130   0.005  1.00  0.30           O  
ATOM    171  CB  THR A  12       9.606  -8.083   2.319  1.00  0.30           C  
ATOM    172  OG1 THR A  12       9.213  -7.323   3.467  1.00  0.91           O  
ATOM    173  CG2 THR A  12       9.655  -9.561   2.682  1.00  0.97           C  
ATOM    174  H   THR A  12      10.625  -5.711   0.914  1.00  0.31           H  
ATOM    175  HA  THR A  12      11.734  -7.898   2.514  1.00  0.27           H  
ATOM    176  HB  THR A  12       8.876  -7.943   1.535  1.00  0.71           H  
ATOM    177  HG1 THR A  12       8.840  -6.484   3.184  1.00  1.25           H  
ATOM    178 HG21 THR A  12      10.435  -9.725   3.409  1.00  1.46           H  
ATOM    179 HG22 THR A  12       9.860 -10.143   1.796  1.00  1.48           H  
ATOM    180 HG23 THR A  12       8.706  -9.860   3.097  1.00  1.64           H  
ATOM    181  N   GLY A  13      12.329  -7.761  -0.193  1.00  0.29           N  
ATOM    182  CA  GLY A  13      12.707  -8.292  -1.491  1.00  0.33           C  
ATOM    183  C   GLY A  13      12.803  -9.804  -1.505  1.00  0.37           C  
ATOM    184  O   GLY A  13      13.855 -10.371  -1.203  1.00  0.45           O  
ATOM    185  H   GLY A  13      12.853  -7.041   0.212  1.00  0.31           H  
ATOM    186  HA2 GLY A  13      11.975  -7.983  -2.222  1.00  0.31           H  
ATOM    187  HA3 GLY A  13      13.667  -7.880  -1.767  1.00  0.39           H  
ATOM    188  N   PHE A  14      11.703 -10.461  -1.852  1.00  0.34           N  
ATOM    189  CA  PHE A  14      11.663 -11.918  -1.910  1.00  0.41           C  
ATOM    190  C   PHE A  14      10.719 -12.390  -3.012  1.00  0.39           C  
ATOM    191  O   PHE A  14       9.505 -12.460  -2.811  1.00  0.43           O  
ATOM    192  CB  PHE A  14      11.227 -12.495  -0.562  1.00  0.50           C  
ATOM    193  CG  PHE A  14      11.114 -13.991  -0.559  1.00  0.60           C  
ATOM    194  CD1 PHE A  14       9.924 -14.611  -0.902  1.00  0.69           C  
ATOM    195  CD2 PHE A  14      12.200 -14.780  -0.210  1.00  0.70           C  
ATOM    196  CE1 PHE A  14       9.819 -15.990  -0.901  1.00  0.79           C  
ATOM    197  CE2 PHE A  14      12.100 -16.157  -0.207  1.00  0.81           C  
ATOM    198  CZ  PHE A  14      10.908 -16.764  -0.551  1.00  0.81           C  
ATOM    199  H   PHE A  14      10.895  -9.955  -2.077  1.00  0.30           H  
ATOM    200  HA  PHE A  14      12.660 -12.267  -2.136  1.00  0.45           H  
ATOM    201  HB2 PHE A  14      11.947 -12.213   0.191  1.00  0.53           H  
ATOM    202  HD1 PHE A  14       9.071 -14.008  -1.176  1.00  0.75           H  
ATOM    203  HD2 PHE A  14      13.133 -14.307   0.059  1.00  0.77           H  
ATOM    204  HE1 PHE A  14       8.885 -16.461  -1.171  1.00  0.91           H  
ATOM    205  HE2 PHE A  14      12.954 -16.761   0.066  1.00  0.93           H  
ATOM    206  HZ  PHE A  14      10.828 -17.842  -0.549  1.00  0.90           H  
ATOM    207  N   SER A  15      11.279 -12.704  -4.175  1.00  0.40           N  
ATOM    208  CA  SER A  15      10.480 -13.168  -5.304  1.00  0.41           C  
ATOM    209  C   SER A  15      10.658 -14.667  -5.514  1.00  0.43           C  
ATOM    210  O   SER A  15      11.334 -15.339  -4.734  1.00  0.48           O  
ATOM    211  CB  SER A  15      10.873 -12.417  -6.577  1.00  0.39           C  
ATOM    212  OG  SER A  15      10.861 -11.016  -6.368  1.00  0.76           O  
ATOM    213  H   SER A  15      12.249 -12.623  -4.279  1.00  0.43           H  
ATOM    214  HA  SER A  15       9.442 -12.967  -5.082  1.00  0.45           H  
ATOM    215  HB2 SER A  15      11.866 -12.715  -6.874  1.00  0.73           H  
ATOM    216  HG  SER A  15      11.531 -10.782  -5.722  1.00  1.26           H  
ATOM    217  N   ARG A  16      10.043 -15.187  -6.571  1.00  0.57           N  
ATOM    218  CA  ARG A  16      10.135 -16.607  -6.887  1.00  0.61           C  
ATOM    219  C   ARG A  16      11.375 -16.903  -7.726  1.00  0.59           C  
ATOM    220  O   ARG A  16      11.850 -18.038  -7.766  1.00  0.63           O  
ATOM    221  CB  ARG A  16       8.883 -17.069  -7.636  1.00  0.69           C  
ATOM    222  CG  ARG A  16       7.593 -16.899  -6.847  1.00  1.14           C  
ATOM    223  CD  ARG A  16       7.203 -15.435  -6.719  1.00  1.37           C  
ATOM    224  NE  ARG A  16       5.819 -15.278  -6.277  1.00  2.19           N  
ATOM    225  CZ  ARG A  16       5.257 -14.101  -6.026  1.00  2.67           C  
ATOM    226  NH1 ARG A  16       5.960 -12.985  -6.163  1.00  2.41           N  
ATOM    227  NH2 ARG A  16       3.991 -14.039  -5.635  1.00  3.58           N  
ATOM    228  H   ARG A  16       9.517 -14.601  -7.154  1.00  0.72           H  
ATOM    229  HA  ARG A  16      10.206 -17.149  -5.957  1.00  0.65           H  
ATOM    230  HB2 ARG A  16       8.795 -16.501  -8.551  1.00  1.39           H  
ATOM    231  HG2 ARG A  16       6.800 -17.429  -7.355  1.00  1.69           H  
ATOM    232  HD2 ARG A  16       7.853 -14.962  -5.999  1.00  1.50           H  
ATOM    233  HE  ARG A  16       5.283 -16.090  -6.165  1.00  2.55           H  
ATOM    234 HH11 ARG A  16       6.914 -13.029  -6.457  1.00  1.97           H  
ATOM    235 HH12 ARG A  16       5.535 -12.101  -5.974  1.00  2.83           H  
ATOM    236 HH21 ARG A  16       3.459 -14.880  -5.529  1.00  3.94           H  
ATOM    237 HH22 ARG A  16       3.568 -13.153  -5.447  1.00  3.96           H  
ATOM    238  N   ASP A  17      11.896 -15.879  -8.396  1.00  0.58           N  
ATOM    239  CA  ASP A  17      13.078 -16.040  -9.237  1.00  0.63           C  
ATOM    240  C   ASP A  17      13.929 -14.773  -9.240  1.00  0.57           C  
ATOM    241  O   ASP A  17      14.636 -14.495 -10.207  1.00  0.62           O  
ATOM    242  CB  ASP A  17      12.661 -16.390 -10.666  1.00  0.77           C  
ATOM    243  CG  ASP A  17      11.758 -15.337 -11.281  1.00  1.61           C  
ATOM    244  OD1 ASP A  17      10.523 -15.453 -11.127  1.00  2.48           O  
ATOM    245  OD2 ASP A  17      12.285 -14.398 -11.913  1.00  1.86           O  
ATOM    246  H   ASP A  17      11.477 -14.997  -8.327  1.00  0.56           H  
ATOM    247  HA  ASP A  17      13.664 -16.853  -8.833  1.00  0.66           H  
ATOM    248  HB2 ASP A  17      13.544 -16.480 -11.279  1.00  1.47           H  
ATOM    249  N   ILE A  18      13.861 -14.012  -8.150  1.00  0.51           N  
ATOM    250  CA  ILE A  18      14.626 -12.772  -8.032  1.00  0.50           C  
ATOM    251  C   ILE A  18      16.074 -12.967  -8.473  1.00  0.50           C  
ATOM    252  O   ILE A  18      16.788 -13.814  -7.936  1.00  0.57           O  
ATOM    253  CB  ILE A  18      14.614 -12.239  -6.586  1.00  0.48           C  
ATOM    254  CG1 ILE A  18      15.382 -10.919  -6.500  1.00  0.52           C  
ATOM    255  CG2 ILE A  18      15.208 -13.267  -5.637  1.00  0.47           C  
ATOM    256  CD1 ILE A  18      15.326 -10.278  -5.131  1.00  0.56           C  
ATOM    257  H   ILE A  18      13.281 -14.286  -7.410  1.00  0.50           H  
ATOM    258  HA  ILE A  18      14.163 -12.033  -8.668  1.00  0.56           H  
ATOM    259  HB  ILE A  18      13.589 -12.070  -6.296  1.00  0.53           H  
ATOM    260 HG12 ILE A  18      16.419 -11.097  -6.742  1.00  0.51           H  
ATOM    261 HG21 ILE A  18      15.089 -12.931  -4.618  1.00  1.10           H  
ATOM    262 HG22 ILE A  18      14.701 -14.212  -5.766  1.00  1.06           H  
ATOM    263 HG23 ILE A  18      16.259 -13.392  -5.854  1.00  1.17           H  
ATOM    264 HD11 ILE A  18      14.299 -10.056  -4.879  1.00  1.15           H  
ATOM    265 HD12 ILE A  18      15.738 -10.957  -4.399  1.00  1.11           H  
ATOM    266 HD13 ILE A  18      15.900  -9.363  -5.137  1.00  1.13           H  
ATOM    267  N   SER A  19      16.499 -12.178  -9.454  1.00  0.57           N  
ATOM    268  CA  SER A  19      17.861 -12.263  -9.970  1.00  0.59           C  
ATOM    269  C   SER A  19      18.859 -11.684  -8.974  1.00  0.52           C  
ATOM    270  O   SER A  19      18.505 -10.848  -8.142  1.00  0.50           O  
ATOM    271  CB  SER A  19      17.968 -11.526 -11.305  1.00  0.70           C  
ATOM    272  OG  SER A  19      17.634 -10.155 -11.159  1.00  1.50           O  
ATOM    273  H   SER A  19      15.881 -11.521  -9.840  1.00  0.68           H  
ATOM    274  HA  SER A  19      18.091 -13.306 -10.127  1.00  0.59           H  
ATOM    275  HB2 SER A  19      18.980 -11.598 -11.675  1.00  1.12           H  
ATOM    276  HG  SER A  19      18.138  -9.633 -11.789  1.00  2.01           H  
ATOM    277  N   PRO A  20      20.129 -12.124  -9.046  1.00  0.54           N  
ATOM    278  CA  PRO A  20      21.181 -11.645  -8.145  1.00  0.51           C  
ATOM    279  C   PRO A  20      21.503 -10.174  -8.366  1.00  0.53           C  
ATOM    280  O   PRO A  20      21.939  -9.479  -7.450  1.00  0.51           O  
ATOM    281  CB  PRO A  20      22.388 -12.517  -8.503  1.00  0.55           C  
ATOM    282  CG  PRO A  20      22.126 -12.981  -9.893  1.00  0.61           C  
ATOM    283  CD  PRO A  20      20.635 -13.117 -10.011  1.00  0.61           C  
ATOM    284  HA  PRO A  20      20.915 -11.801  -7.109  1.00  0.49           H  
ATOM    285  HB2 PRO A  20      23.291 -11.926  -8.445  1.00  0.56           H  
ATOM    286  HG2 PRO A  20      22.493 -12.251 -10.600  1.00  0.64           H  
ATOM    287  HD2 PRO A  20      20.312 -12.879 -11.014  1.00  0.68           H  
ATOM    288  N   ALA A  21      21.286  -9.699  -9.588  1.00  0.58           N  
ATOM    289  CA  ALA A  21      21.550  -8.304  -9.919  1.00  0.64           C  
ATOM    290  C   ALA A  21      20.890  -7.371  -8.907  1.00  0.62           C  
ATOM    291  O   ALA A  21      21.502  -6.414  -8.438  1.00  0.65           O  
ATOM    292  CB  ALA A  21      21.062  -7.993 -11.326  1.00  0.71           C  
ATOM    293  H   ALA A  21      20.944 -10.301 -10.281  1.00  0.61           H  
ATOM    294  HA  ALA A  21      22.619  -8.151  -9.891  1.00  0.66           H  
ATOM    295  HB1 ALA A  21      21.575  -8.625 -12.033  1.00  1.32           H  
ATOM    296  HB2 ALA A  21      19.998  -8.176 -11.385  1.00  1.13           H  
ATOM    297  HB3 ALA A  21      21.263  -6.957 -11.556  1.00  1.30           H  
ATOM    298  N   TYR A  22      19.636  -7.662  -8.580  1.00  0.60           N  
ATOM    299  CA  TYR A  22      18.888  -6.857  -7.621  1.00  0.61           C  
ATOM    300  C   TYR A  22      19.157  -7.314  -6.190  1.00  0.54           C  
ATOM    301  O   TYR A  22      19.236  -6.496  -5.272  1.00  0.57           O  
ATOM    302  CB  TYR A  22      17.389  -6.933  -7.917  1.00  0.66           C  
ATOM    303  CG  TYR A  22      17.006  -6.367  -9.265  1.00  0.90           C  
ATOM    304  CD1 TYR A  22      16.877  -4.996  -9.451  1.00  0.99           C  
ATOM    305  CD2 TYR A  22      16.775  -7.203 -10.351  1.00  1.28           C  
ATOM    306  CE1 TYR A  22      16.525  -4.475 -10.681  1.00  1.34           C  
ATOM    307  CE2 TYR A  22      16.424  -6.687 -11.584  1.00  1.72           C  
ATOM    308  CZ  TYR A  22      16.301  -5.323 -11.744  1.00  1.72           C  
ATOM    309  OH  TYR A  22      15.950  -4.807 -12.970  1.00  2.17           O  
ATOM    310  H   TYR A  22      19.202  -8.437  -8.993  1.00  0.60           H  
ATOM    311  HA  TYR A  22      19.213  -5.833  -7.727  1.00  0.66           H  
ATOM    312  HB2 TYR A  22      17.078  -7.966  -7.892  1.00  0.78           H  
ATOM    313  HD1 TYR A  22      17.055  -4.334  -8.617  1.00  0.96           H  
ATOM    314  HD2 TYR A  22      16.873  -8.269 -10.223  1.00  1.30           H  
ATOM    315  HE1 TYR A  22      16.429  -3.406 -10.807  1.00  1.41           H  
ATOM    316  HE2 TYR A  22      16.248  -7.353 -12.418  1.00  2.11           H  
ATOM    317  HH  TYR A  22      16.491  -4.037 -13.160  1.00  2.53           H  
ATOM    318  N   ARG A  23      19.293  -8.623  -6.007  1.00  0.48           N  
ATOM    319  CA  ARG A  23      19.542  -9.187  -4.684  1.00  0.44           C  
ATOM    320  C   ARG A  23      20.951  -8.858  -4.196  1.00  0.45           C  
ATOM    321  O   ARG A  23      21.125  -8.193  -3.174  1.00  0.45           O  
ATOM    322  CB  ARG A  23      19.349 -10.705  -4.714  1.00  0.45           C  
ATOM    323  CG  ARG A  23      19.572 -11.373  -3.367  1.00  0.54           C  
ATOM    324  CD  ARG A  23      18.539 -10.923  -2.348  1.00  0.53           C  
ATOM    325  NE  ARG A  23      18.740 -11.557  -1.048  1.00  0.70           N  
ATOM    326  CZ  ARG A  23      17.791 -11.658  -0.124  1.00  1.08           C  
ATOM    327  NH1 ARG A  23      16.582 -11.162  -0.354  1.00  1.57           N  
ATOM    328  NH2 ARG A  23      18.049 -12.254   1.031  1.00  1.47           N  
ATOM    329  H   ARG A  23      19.224  -9.223  -6.778  1.00  0.51           H  
ATOM    330  HA  ARG A  23      18.828  -8.757  -3.998  1.00  0.44           H  
ATOM    331  HB2 ARG A  23      18.341 -10.920  -5.036  1.00  0.49           H  
ATOM    332  HG2 ARG A  23      19.497 -12.444  -3.491  1.00  0.91           H  
ATOM    333  HD2 ARG A  23      18.611  -9.852  -2.230  1.00  0.89           H  
ATOM    334  HE  ARG A  23      19.626 -11.929  -0.856  1.00  1.08           H  
ATOM    335 HH11 ARG A  23      16.384 -10.709  -1.225  1.00  1.70           H  
ATOM    336 HH12 ARG A  23      15.868 -11.241   0.342  1.00  2.02           H  
ATOM    337 HH21 ARG A  23      18.958 -12.630   1.208  1.00  1.70           H  
ATOM    338 HH22 ARG A  23      17.333 -12.330   1.726  1.00  1.78           H  
ATOM    339  N   GLN A  24      21.951  -9.325  -4.935  1.00  0.49           N  
ATOM    340  CA  GLN A  24      23.345  -9.090  -4.581  1.00  0.55           C  
ATOM    341  C   GLN A  24      23.655  -7.596  -4.483  1.00  0.58           C  
ATOM    342  O   GLN A  24      24.652  -7.203  -3.877  1.00  0.66           O  
ATOM    343  CB  GLN A  24      24.267  -9.744  -5.613  1.00  0.69           C  
ATOM    344  CG  GLN A  24      25.746  -9.609  -5.281  1.00  1.52           C  
ATOM    345  CD  GLN A  24      26.639 -10.213  -6.346  1.00  2.03           C  
ATOM    346  OE1 GLN A  24      26.258 -11.169  -7.022  1.00  2.61           O  
ATOM    347  NE2 GLN A  24      27.835  -9.659  -6.501  1.00  2.69           N  
ATOM    348  H   GLN A  24      21.745  -9.843  -5.744  1.00  0.51           H  
ATOM    349  HA  GLN A  24      23.522  -9.545  -3.618  1.00  0.55           H  
ATOM    350  HB2 GLN A  24      24.030 -10.795  -5.676  1.00  1.07           H  
ATOM    351  HG2 GLN A  24      25.986  -8.560  -5.183  1.00  2.31           H  
ATOM    352 HE21 GLN A  24      28.071  -8.900  -5.926  1.00  2.90           H  
ATOM    353 HE22 GLN A  24      28.433 -10.029  -7.182  1.00  3.29           H  
ATOM    354  N   LYS A  25      22.802  -6.771  -5.078  1.00  0.59           N  
ATOM    355  CA  LYS A  25      22.991  -5.329  -5.058  1.00  0.68           C  
ATOM    356  C   LYS A  25      22.630  -4.745  -3.694  1.00  0.61           C  
ATOM    357  O   LYS A  25      23.453  -4.098  -3.047  1.00  0.71           O  
ATOM    358  CB  LYS A  25      22.145  -4.680  -6.152  1.00  0.79           C  
ATOM    359  CG  LYS A  25      22.120  -3.166  -6.085  1.00  0.99           C  
ATOM    360  CD  LYS A  25      21.153  -2.580  -7.100  1.00  1.43           C  
ATOM    361  CE  LYS A  25      21.524  -2.979  -8.518  1.00  2.05           C  
ATOM    362  NZ  LYS A  25      22.878  -2.489  -8.899  1.00  2.59           N  
ATOM    363  H   LYS A  25      22.022  -7.136  -5.543  1.00  0.60           H  
ATOM    364  HA  LYS A  25      24.034  -5.130  -5.257  1.00  0.77           H  
ATOM    365  HB2 LYS A  25      22.537  -4.969  -7.116  1.00  1.21           H  
ATOM    366  HG2 LYS A  25      21.810  -2.872  -5.093  1.00  1.59           H  
ATOM    367  HD2 LYS A  25      20.158  -2.938  -6.884  1.00  1.99           H  
ATOM    368  HE2 LYS A  25      21.509  -4.056  -8.589  1.00  2.54           H  
ATOM    369  HZ1 LYS A  25      22.914  -1.451  -8.834  1.00  3.07           H  
ATOM    370  HZ2 LYS A  25      23.100  -2.772  -9.875  1.00  2.83           H  
ATOM    371  HZ3 LYS A  25      23.596  -2.891  -8.261  1.00  2.95           H  
ATOM    372  N   LEU A  26      21.394  -4.977  -3.264  1.00  0.55           N  
ATOM    373  CA  LEU A  26      20.924  -4.466  -1.980  1.00  0.57           C  
ATOM    374  C   LEU A  26      21.907  -4.805  -0.863  1.00  0.60           C  
ATOM    375  O   LEU A  26      22.039  -4.060   0.108  1.00  0.68           O  
ATOM    376  CB  LEU A  26      19.542  -5.037  -1.653  1.00  0.55           C  
ATOM    377  CG  LEU A  26      18.445  -4.684  -2.660  1.00  0.69           C  
ATOM    378  CD1 LEU A  26      17.109  -5.265  -2.220  1.00  1.30           C  
ATOM    379  CD2 LEU A  26      18.342  -3.176  -2.826  1.00  1.29           C  
ATOM    380  H   LEU A  26      20.783  -5.503  -3.822  1.00  0.57           H  
ATOM    381  HA  LEU A  26      20.848  -3.393  -2.062  1.00  0.69           H  
ATOM    382  HB2 LEU A  26      19.623  -6.113  -1.604  1.00  0.66           H  
ATOM    383  HG  LEU A  26      18.694  -5.111  -3.621  1.00  1.38           H  
ATOM    384 HD11 LEU A  26      16.342  -4.976  -2.923  1.00  1.69           H  
ATOM    385 HD12 LEU A  26      17.178  -6.342  -2.184  1.00  1.94           H  
ATOM    386 HD13 LEU A  26      16.858  -4.887  -1.240  1.00  1.82           H  
ATOM    387 HD21 LEU A  26      19.278  -2.790  -3.206  1.00  1.87           H  
ATOM    388 HD22 LEU A  26      17.549  -2.942  -3.521  1.00  1.79           H  
ATOM    389 HD23 LEU A  26      18.128  -2.722  -1.869  1.00  1.79           H  
ATOM    390  N   LEU A  27      22.597  -5.932  -1.008  1.00  0.59           N  
ATOM    391  CA  LEU A  27      23.568  -6.365  -0.013  1.00  0.71           C  
ATOM    392  C   LEU A  27      24.559  -5.249   0.306  1.00  0.82           C  
ATOM    393  O   LEU A  27      25.021  -5.121   1.439  1.00  0.95           O  
ATOM    394  CB  LEU A  27      24.320  -7.603  -0.507  1.00  0.75           C  
ATOM    395  CG  LEU A  27      23.442  -8.817  -0.813  1.00  0.71           C  
ATOM    396  CD1 LEU A  27      24.295  -9.995  -1.256  1.00  0.82           C  
ATOM    397  CD2 LEU A  27      22.604  -9.187   0.402  1.00  0.77           C  
ATOM    398  H   LEU A  27      22.446  -6.488  -1.799  1.00  0.56           H  
ATOM    399  HA  LEU A  27      23.027  -6.619   0.885  1.00  0.73           H  
ATOM    400  HB2 LEU A  27      24.855  -7.336  -1.408  1.00  0.74           H  
ATOM    401  HG  LEU A  27      22.768  -8.571  -1.622  1.00  0.62           H  
ATOM    402 HD11 LEU A  27      24.990 -10.252  -0.472  1.00  1.38           H  
ATOM    403 HD12 LEU A  27      23.659 -10.843  -1.465  1.00  1.21           H  
ATOM    404 HD13 LEU A  27      24.843  -9.728  -2.149  1.00  1.25           H  
ATOM    405 HD21 LEU A  27      21.992 -10.046   0.170  1.00  1.22           H  
ATOM    406 HD22 LEU A  27      23.258  -9.422   1.230  1.00  1.16           H  
ATOM    407 HD23 LEU A  27      21.971  -8.355   0.670  1.00  1.45           H  
ATOM    408  N   SER A  28      24.881  -4.445  -0.703  1.00  0.84           N  
ATOM    409  CA  SER A  28      25.821  -3.342  -0.531  1.00  0.98           C  
ATOM    410  C   SER A  28      25.288  -2.317   0.465  1.00  0.89           C  
ATOM    411  O   SER A  28      26.059  -1.643   1.149  1.00  0.99           O  
ATOM    412  CB  SER A  28      26.097  -2.665  -1.875  1.00  1.15           C  
ATOM    413  OG  SER A  28      24.905  -2.144  -2.439  1.00  1.64           O  
ATOM    414  H   SER A  28      24.478  -4.597  -1.583  1.00  0.80           H  
ATOM    415  HA  SER A  28      26.743  -3.750  -0.149  1.00  1.11           H  
ATOM    416  HB2 SER A  28      26.795  -1.855  -1.731  1.00  1.60           H  
ATOM    417  HG  SER A  28      24.876  -1.194  -2.303  1.00  2.09           H  
ATOM    418  N   LEU A  29      23.967  -2.202   0.543  1.00  0.78           N  
ATOM    419  CA  LEU A  29      23.336  -1.255   1.454  1.00  0.78           C  
ATOM    420  C   LEU A  29      23.133  -1.876   2.833  1.00  0.74           C  
ATOM    421  O   LEU A  29      23.043  -1.168   3.835  1.00  0.82           O  
ATOM    422  CB  LEU A  29      21.993  -0.791   0.888  1.00  0.86           C  
ATOM    423  CG  LEU A  29      22.071  -0.110  -0.480  1.00  1.06           C  
ATOM    424  CD1 LEU A  29      20.685   0.314  -0.940  1.00  1.64           C  
ATOM    425  CD2 LEU A  29      23.006   1.088  -0.425  1.00  1.42           C  
ATOM    426  H   LEU A  29      23.404  -2.767  -0.026  1.00  0.77           H  
ATOM    427  HA  LEU A  29      23.989  -0.402   1.551  1.00  0.85           H  
ATOM    428  HB2 LEU A  29      21.344  -1.650   0.804  1.00  0.86           H  
ATOM    429  HG  LEU A  29      22.462  -0.811  -1.202  1.00  1.79           H  
ATOM    430 HD11 LEU A  29      20.255   0.987  -0.213  1.00  2.13           H  
ATOM    431 HD12 LEU A  29      20.759   0.814  -1.895  1.00  2.08           H  
ATOM    432 HD13 LEU A  29      20.055  -0.558  -1.037  1.00  2.13           H  
ATOM    433 HD21 LEU A  29      23.989   0.763  -0.116  1.00  1.99           H  
ATOM    434 HD22 LEU A  29      23.069   1.541  -1.403  1.00  1.91           H  
ATOM    435 HD23 LEU A  29      22.627   1.810   0.282  1.00  1.87           H  
ATOM    436  N   GLY A  30      23.058  -3.204   2.874  1.00  0.68           N  
ATOM    437  CA  GLY A  30      22.869  -3.896   4.133  1.00  0.73           C  
ATOM    438  C   GLY A  30      21.409  -3.970   4.540  1.00  0.71           C  
ATOM    439  O   GLY A  30      21.095  -4.168   5.715  1.00  0.82           O  
ATOM    440  H   GLY A  30      23.128  -3.714   2.042  1.00  0.67           H  
ATOM    441  HA2 GLY A  30      23.255  -4.900   4.042  1.00  0.76           H  
ATOM    442  HA3 GLY A  30      23.418  -3.378   4.904  1.00  0.82           H  
ATOM    443  N   MET A  31      20.517  -3.809   3.570  1.00  0.63           N  
ATOM    444  CA  MET A  31      19.086  -3.858   3.833  1.00  0.66           C  
ATOM    445  C   MET A  31      18.501  -5.201   3.405  1.00  0.56           C  
ATOM    446  O   MET A  31      18.102  -5.378   2.254  1.00  0.54           O  
ATOM    447  CB  MET A  31      18.375  -2.717   3.102  1.00  0.74           C  
ATOM    448  CG  MET A  31      18.815  -1.337   3.563  1.00  0.94           C  
ATOM    449  SD  MET A  31      18.376  -1.006   5.281  1.00  1.95           S  
ATOM    450  CE  MET A  31      19.126   0.603   5.518  1.00  2.55           C  
ATOM    451  H   MET A  31      20.829  -3.653   2.653  1.00  0.62           H  
ATOM    452  HA  MET A  31      18.940  -3.738   4.896  1.00  0.75           H  
ATOM    453  HB2 MET A  31      18.576  -2.802   2.045  1.00  0.83           H  
ATOM    454  HG2 MET A  31      19.887  -1.262   3.459  1.00  1.20           H  
ATOM    455  HE1 MET A  31      20.200   0.495   5.581  1.00  2.97           H  
ATOM    456  HE2 MET A  31      18.875   1.244   4.686  1.00  2.93           H  
ATOM    457  HE3 MET A  31      18.755   1.042   6.434  1.00  2.92           H  
ATOM    458  N   LEU A  32      18.462  -6.145   4.340  1.00  0.56           N  
ATOM    459  CA  LEU A  32      17.927  -7.475   4.068  1.00  0.49           C  
ATOM    460  C   LEU A  32      16.422  -7.515   4.320  1.00  0.44           C  
ATOM    461  O   LEU A  32      15.879  -6.661   5.019  1.00  0.45           O  
ATOM    462  CB  LEU A  32      18.630  -8.516   4.942  1.00  0.52           C  
ATOM    463  CG  LEU A  32      20.089  -8.795   4.574  1.00  0.59           C  
ATOM    464  CD1 LEU A  32      20.926  -7.532   4.709  1.00  0.69           C  
ATOM    465  CD2 LEU A  32      20.654  -9.909   5.443  1.00  0.66           C  
ATOM    466  H   LEU A  32      18.803  -5.942   5.236  1.00  0.64           H  
ATOM    467  HA  LEU A  32      18.113  -7.703   3.029  1.00  0.50           H  
ATOM    468  HB2 LEU A  32      18.601  -8.174   5.966  1.00  0.56           H  
ATOM    469  HG  LEU A  32      20.138  -9.118   3.542  1.00  0.56           H  
ATOM    470 HD11 LEU A  32      20.785  -7.111   5.693  1.00  1.11           H  
ATOM    471 HD12 LEU A  32      21.968  -7.775   4.567  1.00  1.34           H  
ATOM    472 HD13 LEU A  32      20.620  -6.815   3.962  1.00  1.07           H  
ATOM    473 HD21 LEU A  32      20.066 -10.805   5.307  1.00  1.09           H  
ATOM    474 HD22 LEU A  32      21.677 -10.103   5.159  1.00  1.20           H  
ATOM    475 HD23 LEU A  32      20.617  -9.609   6.479  1.00  1.23           H  
ATOM    476  N   PRO A  33      15.726  -8.516   3.750  1.00  0.41           N  
ATOM    477  CA  PRO A  33      14.281  -8.663   3.916  1.00  0.40           C  
ATOM    478  C   PRO A  33      13.832  -8.409   5.351  1.00  0.38           C  
ATOM    479  O   PRO A  33      14.155  -9.172   6.260  1.00  0.51           O  
ATOM    480  CB  PRO A  33      14.043 -10.119   3.525  1.00  0.43           C  
ATOM    481  CG  PRO A  33      15.092 -10.402   2.506  1.00  0.45           C  
ATOM    482  CD  PRO A  33      16.293  -9.580   2.897  1.00  0.43           C  
ATOM    483  HA  PRO A  33      13.735  -8.014   3.246  1.00  0.41           H  
ATOM    484  HB2 PRO A  33      14.151 -10.752   4.393  1.00  0.44           H  
ATOM    485  HG2 PRO A  33      15.338 -11.453   2.515  1.00  0.48           H  
ATOM    486  HD2 PRO A  33      16.997 -10.183   3.451  1.00  0.44           H  
ATOM    487  N   GLY A  34      13.086  -7.325   5.543  1.00  0.34           N  
ATOM    488  CA  GLY A  34      12.607  -6.978   6.868  1.00  0.33           C  
ATOM    489  C   GLY A  34      13.101  -5.621   7.326  1.00  0.31           C  
ATOM    490  O   GLY A  34      13.283  -5.390   8.522  1.00  0.40           O  
ATOM    491  H   GLY A  34      12.859  -6.758   4.779  1.00  0.40           H  
ATOM    492  HA2 GLY A  34      11.526  -6.972   6.858  1.00  0.35           H  
ATOM    493  HA3 GLY A  34      12.944  -7.729   7.569  1.00  0.35           H  
ATOM    494  N   SER A  35      13.314  -4.717   6.375  1.00  0.28           N  
ATOM    495  CA  SER A  35      13.792  -3.374   6.689  1.00  0.28           C  
ATOM    496  C   SER A  35      12.650  -2.365   6.639  1.00  0.28           C  
ATOM    497  O   SER A  35      11.531  -2.702   6.259  1.00  0.37           O  
ATOM    498  CB  SER A  35      14.899  -2.962   5.718  1.00  0.31           C  
ATOM    499  OG  SER A  35      15.381  -1.663   6.016  1.00  0.62           O  
ATOM    500  H   SER A  35      13.142  -4.957   5.438  1.00  0.33           H  
ATOM    501  HA  SER A  35      14.193  -3.394   7.692  1.00  0.31           H  
ATOM    502  HB2 SER A  35      15.719  -3.661   5.792  1.00  0.56           H  
ATOM    503  HG  SER A  35      15.616  -1.214   5.200  1.00  1.01           H  
ATOM    504  N   SER A  36      12.944  -1.127   7.027  1.00  0.25           N  
ATOM    505  CA  SER A  36      11.942  -0.065   7.024  1.00  0.25           C  
ATOM    506  C   SER A  36      12.354   1.070   6.092  1.00  0.23           C  
ATOM    507  O   SER A  36      13.522   1.457   6.046  1.00  0.28           O  
ATOM    508  CB  SER A  36      11.738   0.474   8.442  1.00  0.30           C  
ATOM    509  OG  SER A  36      10.772   1.512   8.459  1.00  1.30           O  
ATOM    510  H   SER A  36      13.855  -0.923   7.323  1.00  0.30           H  
ATOM    511  HA  SER A  36      11.014  -0.486   6.671  1.00  0.27           H  
ATOM    512  HB2 SER A  36      11.397  -0.326   9.082  1.00  1.06           H  
ATOM    513  HG  SER A  36      11.168   2.321   8.126  1.00  1.75           H  
ATOM    514  N   PHE A  37      11.387   1.600   5.347  1.00  0.22           N  
ATOM    515  CA  PHE A  37      11.655   2.689   4.413  1.00  0.23           C  
ATOM    516  C   PHE A  37      10.405   3.536   4.187  1.00  0.23           C  
ATOM    517  O   PHE A  37       9.287   3.090   4.440  1.00  0.33           O  
ATOM    518  CB  PHE A  37      12.153   2.130   3.076  1.00  0.25           C  
ATOM    519  CG  PHE A  37      11.079   1.462   2.262  1.00  0.26           C  
ATOM    520  CD1 PHE A  37      10.638   0.189   2.583  1.00  0.32           C  
ATOM    521  CD2 PHE A  37      10.506   2.114   1.182  1.00  0.27           C  
ATOM    522  CE1 PHE A  37       9.647  -0.423   1.837  1.00  0.36           C  
ATOM    523  CE2 PHE A  37       9.515   1.507   0.434  1.00  0.30           C  
ATOM    524  CZ  PHE A  37       9.086   0.236   0.762  1.00  0.33           C  
ATOM    525  H   PHE A  37      10.476   1.250   5.427  1.00  0.25           H  
ATOM    526  HA  PHE A  37      12.426   3.312   4.844  1.00  0.25           H  
ATOM    527  HB2 PHE A  37      12.562   2.937   2.487  1.00  0.28           H  
ATOM    528  HD1 PHE A  37      11.075  -0.328   3.423  1.00  0.37           H  
ATOM    529  HD2 PHE A  37      10.841   3.108   0.924  1.00  0.32           H  
ATOM    530  HE1 PHE A  37       9.313  -1.418   2.095  1.00  0.44           H  
ATOM    531  HE2 PHE A  37       9.076   2.026  -0.405  1.00  0.34           H  
ATOM    532  HZ  PHE A  37       8.311  -0.240   0.180  1.00  0.37           H  
ATOM    533  N   HIS A  38      10.604   4.762   3.709  1.00  0.21           N  
ATOM    534  CA  HIS A  38       9.490   5.667   3.441  1.00  0.24           C  
ATOM    535  C   HIS A  38       9.373   5.956   1.949  1.00  0.24           C  
ATOM    536  O   HIS A  38      10.322   5.758   1.191  1.00  0.40           O  
ATOM    537  CB  HIS A  38       9.669   6.974   4.214  1.00  0.28           C  
ATOM    538  CG  HIS A  38       9.713   6.789   5.698  1.00  1.17           C  
ATOM    539  ND1 HIS A  38      10.887   6.638   6.404  1.00  2.13           N  
ATOM    540  CD2 HIS A  38       8.716   6.732   6.613  1.00  1.98           C  
ATOM    541  CE1 HIS A  38      10.611   6.495   7.688  1.00  2.94           C  
ATOM    542  NE2 HIS A  38       9.302   6.549   7.841  1.00  2.82           N  
ATOM    543  H   HIS A  38      11.520   5.063   3.533  1.00  0.24           H  
ATOM    544  HA  HIS A  38       8.585   5.182   3.775  1.00  0.27           H  
ATOM    545  HB2 HIS A  38      10.592   7.442   3.912  1.00  0.92           H  
ATOM    546  HD1 HIS A  38      11.789   6.635   6.020  1.00  2.50           H  
ATOM    547  HD2 HIS A  38       7.657   6.817   6.414  1.00  2.38           H  
ATOM    548  HE1 HIS A  38      11.335   6.359   8.479  1.00  3.83           H  
ATOM    549  HE2 HIS A  38       8.825   6.399   8.684  1.00  3.50           H  
ATOM    550  N   VAL A  39       8.200   6.424   1.533  1.00  0.27           N  
ATOM    551  CA  VAL A  39       7.954   6.737   0.131  1.00  0.27           C  
ATOM    552  C   VAL A  39       8.118   8.229  -0.139  1.00  0.28           C  
ATOM    553  O   VAL A  39       7.614   9.063   0.613  1.00  0.40           O  
ATOM    554  CB  VAL A  39       6.538   6.305  -0.297  1.00  0.39           C  
ATOM    555  CG1 VAL A  39       6.300   6.617  -1.767  1.00  1.28           C  
ATOM    556  CG2 VAL A  39       6.326   4.826  -0.016  1.00  0.88           C  
ATOM    557  H   VAL A  39       7.483   6.561   2.185  1.00  0.41           H  
ATOM    558  HA  VAL A  39       8.670   6.191  -0.468  1.00  0.27           H  
ATOM    559  HB  VAL A  39       5.822   6.865   0.287  1.00  1.11           H  
ATOM    560 HG11 VAL A  39       6.403   7.680  -1.931  1.00  1.84           H  
ATOM    561 HG12 VAL A  39       7.024   6.088  -2.370  1.00  1.81           H  
ATOM    562 HG13 VAL A  39       5.304   6.304  -2.044  1.00  1.88           H  
ATOM    563 HG21 VAL A  39       5.318   4.549  -0.287  1.00  1.59           H  
ATOM    564 HG22 VAL A  39       7.028   4.245  -0.598  1.00  1.56           H  
ATOM    565 HG23 VAL A  39       6.483   4.635   1.034  1.00  1.36           H  
ATOM    566  N   VAL A  40       8.824   8.557  -1.216  1.00  0.24           N  
ATOM    567  CA  VAL A  40       9.050   9.950  -1.584  1.00  0.34           C  
ATOM    568  C   VAL A  40       8.015  10.423  -2.602  1.00  0.37           C  
ATOM    569  O   VAL A  40       7.399  11.473  -2.433  1.00  0.54           O  
ATOM    570  CB  VAL A  40      10.461  10.155  -2.162  1.00  0.41           C  
ATOM    571  CG1 VAL A  40      10.685  11.613  -2.533  1.00  0.54           C  
ATOM    572  CG2 VAL A  40      11.517   9.681  -1.175  1.00  0.43           C  
ATOM    573  H   VAL A  40       9.206   7.848  -1.773  1.00  0.23           H  
ATOM    574  HA  VAL A  40       8.959  10.549  -0.688  1.00  0.41           H  
ATOM    575  HB  VAL A  40      10.549   9.562  -3.062  1.00  0.40           H  
ATOM    576 HG11 VAL A  40      11.696  11.744  -2.885  1.00  1.22           H  
ATOM    577 HG12 VAL A  40       9.992  11.898  -3.310  1.00  1.16           H  
ATOM    578 HG13 VAL A  40      10.525  12.235  -1.662  1.00  1.13           H  
ATOM    579 HG21 VAL A  40      11.481  10.294  -0.287  1.00  1.07           H  
ATOM    580 HG22 VAL A  40      11.324   8.652  -0.909  1.00  1.12           H  
ATOM    581 HG23 VAL A  40      12.494   9.758  -1.628  1.00  1.01           H  
ATOM    582  N   ARG A  41       7.831   9.638  -3.659  1.00  0.27           N  
ATOM    583  CA  ARG A  41       6.869   9.975  -4.703  1.00  0.31           C  
ATOM    584  C   ARG A  41       6.504   8.743  -5.523  1.00  0.31           C  
ATOM    585  O   ARG A  41       7.366   7.932  -5.862  1.00  0.40           O  
ATOM    586  CB  ARG A  41       7.443  11.058  -5.621  1.00  0.40           C  
ATOM    587  CG  ARG A  41       8.672  10.612  -6.393  1.00  0.47           C  
ATOM    588  CD  ARG A  41       9.113  11.665  -7.394  1.00  0.57           C  
ATOM    589  NE  ARG A  41       9.414  12.940  -6.752  1.00  1.37           N  
ATOM    590  CZ  ARG A  41       9.612  14.074  -7.416  1.00  1.62           C  
ATOM    591  NH1 ARG A  41       9.539  14.088  -8.740  1.00  0.94           N  
ATOM    592  NH2 ARG A  41       9.885  15.191  -6.758  1.00  2.80           N  
ATOM    593  H   ARG A  41       8.355   8.813  -3.739  1.00  0.26           H  
ATOM    594  HA  ARG A  41       5.980  10.355  -4.225  1.00  0.34           H  
ATOM    595  HB2 ARG A  41       6.683  11.349  -6.332  1.00  0.44           H  
ATOM    596  HG2 ARG A  41       9.478  10.433  -5.697  1.00  0.47           H  
ATOM    597  HD2 ARG A  41       9.998  11.313  -7.903  1.00  1.21           H  
ATOM    598  HE  ARG A  41       9.471  12.952  -5.772  1.00  2.08           H  
ATOM    599 HH11 ARG A  41       9.332  13.248  -9.240  1.00  0.93           H  
ATOM    600 HH12 ARG A  41       9.689  14.943  -9.240  1.00  1.14           H  
ATOM    601 HH21 ARG A  41       9.941  15.182  -5.760  1.00  3.53           H  
ATOM    602 HH22 ARG A  41      10.038  16.043  -7.261  1.00  3.00           H  
ATOM    603  N   VAL A  42       5.221   8.606  -5.843  1.00  0.33           N  
ATOM    604  CA  VAL A  42       4.749   7.465  -6.619  1.00  0.39           C  
ATOM    605  C   VAL A  42       3.590   7.855  -7.534  1.00  0.43           C  
ATOM    606  O   VAL A  42       2.904   8.850  -7.296  1.00  0.49           O  
ATOM    607  CB  VAL A  42       4.299   6.314  -5.701  1.00  0.52           C  
ATOM    608  CG1 VAL A  42       4.017   5.059  -6.512  1.00  0.97           C  
ATOM    609  CG2 VAL A  42       5.347   6.045  -4.633  1.00  1.20           C  
ATOM    610  H   VAL A  42       4.577   9.284  -5.549  1.00  0.38           H  
ATOM    611  HA  VAL A  42       5.570   7.111  -7.228  1.00  0.41           H  
ATOM    612  HB  VAL A  42       3.384   6.609  -5.209  1.00  1.31           H  
ATOM    613 HG11 VAL A  42       3.209   5.249  -7.202  1.00  1.59           H  
ATOM    614 HG12 VAL A  42       4.904   4.780  -7.061  1.00  1.47           H  
ATOM    615 HG13 VAL A  42       3.739   4.255  -5.846  1.00  1.66           H  
ATOM    616 HG21 VAL A  42       4.970   5.316  -3.932  1.00  1.73           H  
ATOM    617 HG22 VAL A  42       6.246   5.665  -5.099  1.00  1.79           H  
ATOM    618 HG23 VAL A  42       5.575   6.963  -4.111  1.00  1.76           H  
ATOM    619  N   ALA A  43       3.379   7.066  -8.584  1.00  0.47           N  
ATOM    620  CA  ALA A  43       2.303   7.320  -9.534  1.00  0.55           C  
ATOM    621  C   ALA A  43       1.379   6.110  -9.654  1.00  0.69           C  
ATOM    622  O   ALA A  43       1.822   4.969  -9.530  1.00  0.81           O  
ATOM    623  CB  ALA A  43       2.875   7.686 -10.895  1.00  0.55           C  
ATOM    624  H   ALA A  43       3.963   6.290  -8.720  1.00  0.49           H  
ATOM    625  HA  ALA A  43       1.731   8.162  -9.171  1.00  0.64           H  
ATOM    626  HB1 ALA A  43       3.546   8.524 -10.791  1.00  1.05           H  
ATOM    627  HB2 ALA A  43       3.416   6.841 -11.297  1.00  1.25           H  
ATOM    628  HB3 ALA A  43       2.070   7.949 -11.566  1.00  1.18           H  
ATOM    629  N   PRO A  44       0.078   6.347  -9.899  1.00  0.83           N  
ATOM    630  CA  PRO A  44      -0.911   5.271 -10.032  1.00  1.00           C  
ATOM    631  C   PRO A  44      -0.791   4.522 -11.356  1.00  0.98           C  
ATOM    632  O   PRO A  44      -1.260   3.392 -11.484  1.00  1.15           O  
ATOM    633  CB  PRO A  44      -2.245   6.015  -9.961  1.00  1.14           C  
ATOM    634  CG  PRO A  44      -1.941   7.377 -10.485  1.00  1.34           C  
ATOM    635  CD  PRO A  44      -0.532   7.682 -10.056  1.00  1.00           C  
ATOM    636  HA  PRO A  44      -0.844   4.568  -9.215  1.00  1.10           H  
ATOM    637  HB2 PRO A  44      -2.977   5.508 -10.572  1.00  1.18           H  
ATOM    638  HG2 PRO A  44      -2.013   7.379 -11.563  1.00  1.63           H  
ATOM    639  HD2 PRO A  44      -0.020   8.254 -10.816  1.00  1.00           H  
ATOM    640  N   LEU A  45      -0.161   5.157 -12.338  1.00  0.85           N  
ATOM    641  CA  LEU A  45       0.014   4.547 -13.653  1.00  0.90           C  
ATOM    642  C   LEU A  45       1.347   3.810 -13.743  1.00  0.91           C  
ATOM    643  O   LEU A  45       1.409   2.676 -14.219  1.00  1.23           O  
ATOM    644  CB  LEU A  45      -0.068   5.614 -14.745  1.00  0.90           C  
ATOM    645  CG  LEU A  45       0.092   5.093 -16.176  1.00  1.76           C  
ATOM    646  CD1 LEU A  45      -1.047   4.150 -16.531  1.00  2.51           C  
ATOM    647  CD2 LEU A  45       0.152   6.254 -17.158  1.00  2.25           C  
ATOM    648  H   LEU A  45       0.197   6.055 -12.177  1.00  0.79           H  
ATOM    649  HA  LEU A  45      -0.786   3.837 -13.795  1.00  1.00           H  
ATOM    650  HB2 LEU A  45      -1.026   6.106 -14.669  1.00  1.22           H  
ATOM    651  HG  LEU A  45       1.017   4.541 -16.249  1.00  2.42           H  
ATOM    652 HD11 LEU A  45      -0.908   3.781 -17.537  1.00  2.79           H  
ATOM    653 HD12 LEU A  45      -1.056   3.319 -15.841  1.00  3.06           H  
ATOM    654 HD13 LEU A  45      -1.986   4.677 -16.469  1.00  2.90           H  
ATOM    655 HD21 LEU A  45      -0.757   6.830 -17.091  1.00  2.49           H  
ATOM    656 HD22 LEU A  45       0.997   6.883 -16.919  1.00  2.73           H  
ATOM    657 HD23 LEU A  45       0.261   5.869 -18.162  1.00  2.66           H  
ATOM    658  N   GLY A  46       2.411   4.462 -13.287  1.00  0.72           N  
ATOM    659  CA  GLY A  46       3.728   3.852 -13.326  1.00  0.72           C  
ATOM    660  C   GLY A  46       4.835   4.881 -13.443  1.00  0.66           C  
ATOM    661  O   GLY A  46       5.108   5.388 -14.528  1.00  0.77           O  
ATOM    662  H   GLY A  46       2.301   5.365 -12.921  1.00  0.74           H  
ATOM    663  HA2 GLY A  46       3.874   3.280 -12.424  1.00  0.73           H  
ATOM    664  HA3 GLY A  46       3.778   3.187 -14.175  1.00  0.79           H  
ATOM    665  N   ASP A  47       5.474   5.187 -12.318  1.00  0.53           N  
ATOM    666  CA  ASP A  47       6.554   6.166 -12.295  1.00  0.49           C  
ATOM    667  C   ASP A  47       7.691   5.705 -11.388  1.00  0.46           C  
ATOM    668  O   ASP A  47       7.558   4.718 -10.667  1.00  0.46           O  
ATOM    669  CB  ASP A  47       6.021   7.524 -11.828  1.00  0.45           C  
ATOM    670  CG  ASP A  47       5.188   8.213 -12.891  1.00  0.78           C  
ATOM    671  OD1 ASP A  47       4.126   7.668 -13.258  1.00  0.94           O  
ATOM    672  OD2 ASP A  47       5.601   9.294 -13.360  1.00  1.07           O  
ATOM    673  H   ASP A  47       5.215   4.744 -11.484  1.00  0.49           H  
ATOM    674  HA  ASP A  47       6.933   6.264 -13.299  1.00  0.56           H  
ATOM    675  HB2 ASP A  47       5.403   7.378 -10.955  1.00  0.57           H  
ATOM    676  N   PRO A  48       8.831   6.418 -11.415  1.00  0.47           N  
ATOM    677  CA  PRO A  48       9.992   6.088 -10.599  1.00  0.47           C  
ATOM    678  C   PRO A  48       9.885   6.685  -9.202  1.00  0.37           C  
ATOM    679  O   PRO A  48       9.848   7.903  -9.035  1.00  0.38           O  
ATOM    680  CB  PRO A  48      11.168   6.721 -11.360  1.00  0.56           C  
ATOM    681  CG  PRO A  48      10.571   7.463 -12.521  1.00  0.61           C  
ATOM    682  CD  PRO A  48       9.097   7.584 -12.256  1.00  0.53           C  
ATOM    683  HA  PRO A  48      10.135   5.020 -10.527  1.00  0.50           H  
ATOM    684  HB2 PRO A  48      11.700   7.391 -10.702  1.00  0.55           H  
ATOM    685  HG2 PRO A  48      11.017   8.443 -12.594  1.00  0.65           H  
ATOM    686  HD2 PRO A  48       8.880   8.502 -11.727  1.00  0.51           H  
ATOM    687  N   VAL A  49       9.838   5.813  -8.203  1.00  0.32           N  
ATOM    688  CA  VAL A  49       9.725   6.242  -6.818  1.00  0.26           C  
ATOM    689  C   VAL A  49      11.048   6.056  -6.081  1.00  0.28           C  
ATOM    690  O   VAL A  49      11.886   5.247  -6.478  1.00  0.39           O  
ATOM    691  CB  VAL A  49       8.599   5.467  -6.094  1.00  0.27           C  
ATOM    692  CG1 VAL A  49       8.699   3.981  -6.397  1.00  0.35           C  
ATOM    693  CG2 VAL A  49       8.626   5.714  -4.588  1.00  0.31           C  
ATOM    694  H   VAL A  49       9.884   4.855  -8.404  1.00  0.37           H  
ATOM    695  HA  VAL A  49       9.468   7.292  -6.814  1.00  0.27           H  
ATOM    696  HB  VAL A  49       7.651   5.820  -6.474  1.00  0.28           H  
ATOM    697 HG11 VAL A  49       8.549   3.819  -7.457  1.00  1.15           H  
ATOM    698 HG12 VAL A  49       9.675   3.618  -6.112  1.00  1.00           H  
ATOM    699 HG13 VAL A  49       7.943   3.447  -5.842  1.00  1.09           H  
ATOM    700 HG21 VAL A  49       9.581   5.405  -4.191  1.00  1.10           H  
ATOM    701 HG22 VAL A  49       8.480   6.766  -4.392  1.00  1.01           H  
ATOM    702 HG23 VAL A  49       7.839   5.146  -4.114  1.00  1.09           H  
ATOM    703  N   HIS A  50      11.222   6.813  -5.004  1.00  0.29           N  
ATOM    704  CA  HIS A  50      12.437   6.740  -4.206  1.00  0.31           C  
ATOM    705  C   HIS A  50      12.114   6.359  -2.767  1.00  0.29           C  
ATOM    706  O   HIS A  50      11.164   6.874  -2.176  1.00  0.31           O  
ATOM    707  CB  HIS A  50      13.174   8.079  -4.243  1.00  0.34           C  
ATOM    708  CG  HIS A  50      13.458   8.570  -5.628  1.00  0.37           C  
ATOM    709  ND1 HIS A  50      14.716   8.556  -6.192  1.00  1.13           N  
ATOM    710  CD2 HIS A  50      12.633   9.096  -6.568  1.00  1.08           C  
ATOM    711  CE1 HIS A  50      14.656   9.050  -7.415  1.00  0.85           C  
ATOM    712  NE2 HIS A  50      13.404   9.385  -7.667  1.00  0.68           N  
ATOM    713  H   HIS A  50      10.513   7.437  -4.740  1.00  0.37           H  
ATOM    714  HA  HIS A  50      13.070   5.979  -4.635  1.00  0.34           H  
ATOM    715  HB2 HIS A  50      12.576   8.826  -3.742  1.00  0.34           H  
ATOM    716  HD1 HIS A  50      15.534   8.230  -5.759  1.00  1.97           H  
ATOM    717  HD2 HIS A  50      11.570   9.256  -6.469  1.00  2.03           H  
ATOM    718  HE1 HIS A  50      15.489   9.165  -8.093  1.00  1.44           H  
ATOM    719  HE2 HIS A  50      13.095   9.854  -8.471  1.00  1.13           H  
ATOM    720  N   ILE A  51      12.910   5.453  -2.209  1.00  0.32           N  
ATOM    721  CA  ILE A  51      12.708   5.001  -0.840  1.00  0.32           C  
ATOM    722  C   ILE A  51      13.699   5.663   0.109  1.00  0.32           C  
ATOM    723  O   ILE A  51      14.853   5.901  -0.247  1.00  0.31           O  
ATOM    724  CB  ILE A  51      12.849   3.471  -0.722  1.00  0.34           C  
ATOM    725  CG1 ILE A  51      14.251   3.025  -1.139  1.00  0.34           C  
ATOM    726  CG2 ILE A  51      11.797   2.776  -1.571  1.00  0.36           C  
ATOM    727  CD1 ILE A  51      14.464   1.532  -1.026  1.00  0.36           C  
ATOM    728  H   ILE A  51      13.651   5.078  -2.733  1.00  0.36           H  
ATOM    729  HA  ILE A  51      11.706   5.273  -0.542  1.00  0.34           H  
ATOM    730  HB  ILE A  51      12.684   3.195   0.308  1.00  0.35           H  
ATOM    731 HG12 ILE A  51      14.420   3.308  -2.168  1.00  0.36           H  
ATOM    732 HG21 ILE A  51      11.914   3.073  -2.604  1.00  1.07           H  
ATOM    733 HG22 ILE A  51      11.917   1.706  -1.489  1.00  1.00           H  
ATOM    734 HG23 ILE A  51      10.812   3.057  -1.228  1.00  1.12           H  
ATOM    735 HD11 ILE A  51      15.473   1.288  -1.323  1.00  1.09           H  
ATOM    736 HD12 ILE A  51      14.305   1.221  -0.004  1.00  1.00           H  
ATOM    737 HD13 ILE A  51      13.766   1.019  -1.672  1.00  1.07           H  
ATOM    738  N   GLU A  52      13.241   5.961   1.320  1.00  0.36           N  
ATOM    739  CA  GLU A  52      14.088   6.592   2.324  1.00  0.39           C  
ATOM    740  C   GLU A  52      14.472   5.594   3.410  1.00  0.42           C  
ATOM    741  O   GLU A  52      13.629   5.168   4.202  1.00  0.43           O  
ATOM    742  CB  GLU A  52      13.375   7.794   2.945  1.00  0.45           C  
ATOM    743  CG  GLU A  52      13.013   8.872   1.935  1.00  1.01           C  
ATOM    744  CD  GLU A  52      14.233   9.525   1.316  1.00  1.46           C  
ATOM    745  OE1 GLU A  52      14.818   8.928   0.388  1.00  2.13           O  
ATOM    746  OE2 GLU A  52      14.600  10.635   1.754  1.00  1.91           O  
ATOM    747  H   GLU A  52      12.310   5.752   1.544  1.00  0.40           H  
ATOM    748  HA  GLU A  52      14.987   6.932   1.831  1.00  0.36           H  
ATOM    749  HB2 GLU A  52      12.466   7.454   3.418  1.00  0.94           H  
ATOM    750  HG2 GLU A  52      12.421   8.429   1.148  1.00  1.62           H  
ATOM    751  N   THR A  53      15.746   5.223   3.437  1.00  0.52           N  
ATOM    752  CA  THR A  53      16.248   4.273   4.420  1.00  0.58           C  
ATOM    753  C   THR A  53      17.200   4.951   5.401  1.00  0.61           C  
ATOM    754  O   THR A  53      17.378   6.170   5.365  1.00  0.60           O  
ATOM    755  CB  THR A  53      16.971   3.097   3.739  1.00  0.59           C  
ATOM    756  OG1 THR A  53      18.091   3.579   2.988  1.00  0.55           O  
ATOM    757  CG2 THR A  53      16.023   2.346   2.814  1.00  0.64           C  
ATOM    758  H   THR A  53      16.366   5.597   2.777  1.00  0.58           H  
ATOM    759  HA  THR A  53      15.402   3.881   4.967  1.00  0.65           H  
ATOM    760  HB  THR A  53      17.321   2.416   4.500  1.00  0.66           H  
ATOM    761  HG1 THR A  53      18.461   2.862   2.467  1.00  1.07           H  
ATOM    762 HG21 THR A  53      16.545   1.521   2.355  1.00  1.28           H  
ATOM    763 HG22 THR A  53      15.664   3.016   2.047  1.00  1.25           H  
ATOM    764 HG23 THR A  53      15.186   1.970   3.383  1.00  1.07           H  
ATOM    765  N   ARG A  54      17.813   4.160   6.274  1.00  0.68           N  
ATOM    766  CA  ARG A  54      18.742   4.689   7.267  1.00  0.73           C  
ATOM    767  C   ARG A  54      19.819   5.553   6.620  1.00  0.67           C  
ATOM    768  O   ARG A  54      20.840   5.048   6.156  1.00  0.69           O  
ATOM    769  CB  ARG A  54      19.393   3.546   8.047  1.00  0.84           C  
ATOM    770  CG  ARG A  54      18.402   2.700   8.828  1.00  1.47           C  
ATOM    771  CD  ARG A  54      17.632   3.538   9.836  1.00  1.53           C  
ATOM    772  NE  ARG A  54      16.750   2.723  10.667  1.00  2.10           N  
ATOM    773  CZ  ARG A  54      15.988   3.219  11.635  1.00  2.32           C  
ATOM    774  NH1 ARG A  54      15.998   4.520  11.889  1.00  1.97           N  
ATOM    775  NH2 ARG A  54      15.213   2.414  12.351  1.00  3.04           N  
ATOM    776  H   ARG A  54      17.635   3.196   6.252  1.00  0.72           H  
ATOM    777  HA  ARG A  54      18.176   5.301   7.953  1.00  0.79           H  
ATOM    778  HB2 ARG A  54      19.913   2.904   7.351  1.00  1.09           H  
ATOM    779  HG2 ARG A  54      17.703   2.252   8.139  1.00  1.91           H  
ATOM    780  HD2 ARG A  54      18.338   4.050  10.473  1.00  1.59           H  
ATOM    781  HE  ARG A  54      16.728   1.759  10.494  1.00  2.46           H  
ATOM    782 HH11 ARG A  54      16.581   5.130  11.352  1.00  1.66           H  
ATOM    783 HH12 ARG A  54      15.421   4.893  12.615  1.00  2.17           H  
ATOM    784 HH21 ARG A  54      15.201   1.432  12.163  1.00  3.43           H  
ATOM    785 HH22 ARG A  54      14.640   2.791  13.080  1.00  3.23           H  
ATOM    786  N   ARG A  55      19.581   6.862   6.590  1.00  0.66           N  
ATOM    787  CA  ARG A  55      20.529   7.806   6.014  1.00  0.66           C  
ATOM    788  C   ARG A  55      20.920   7.415   4.590  1.00  0.62           C  
ATOM    789  O   ARG A  55      22.075   7.569   4.193  1.00  0.70           O  
ATOM    790  CB  ARG A  55      21.783   7.893   6.885  1.00  0.73           C  
ATOM    791  CG  ARG A  55      21.514   8.373   8.300  1.00  1.06           C  
ATOM    792  CD  ARG A  55      22.792   8.426   9.122  1.00  1.67           C  
ATOM    793  NE  ARG A  55      23.775   9.341   8.547  1.00  2.43           N  
ATOM    794  CZ  ARG A  55      25.053   9.372   8.913  1.00  3.17           C  
ATOM    795  NH1 ARG A  55      25.497   8.550   9.854  1.00  3.34           N  
ATOM    796  NH2 ARG A  55      25.887  10.227   8.338  1.00  4.11           N  
ATOM    797  H   ARG A  55      18.741   7.202   6.962  1.00  0.70           H  
ATOM    798  HA  ARG A  55      20.052   8.773   5.990  1.00  0.69           H  
ATOM    799  HB2 ARG A  55      22.235   6.912   6.941  1.00  0.99           H  
ATOM    800  HG2 ARG A  55      21.084   9.363   8.259  1.00  1.30           H  
ATOM    801  HD2 ARG A  55      22.551   8.751  10.122  1.00  2.09           H  
ATOM    802  HE  ARG A  55      23.467   9.960   7.853  1.00  2.75           H  
ATOM    803 HH11 ARG A  55      24.871   7.906  10.291  1.00  3.11           H  
ATOM    804 HH12 ARG A  55      26.458   8.577  10.127  1.00  3.99           H  
ATOM    805 HH21 ARG A  55      25.557  10.850   7.628  1.00  4.44           H  
ATOM    806 HH22 ARG A  55      26.849  10.250   8.613  1.00  4.67           H  
ATOM    807  N   VAL A  56      19.956   6.917   3.825  1.00  0.58           N  
ATOM    808  CA  VAL A  56      20.213   6.512   2.447  1.00  0.57           C  
ATOM    809  C   VAL A  56      18.936   6.555   1.615  1.00  0.49           C  
ATOM    810  O   VAL A  56      17.895   6.047   2.033  1.00  0.50           O  
ATOM    811  CB  VAL A  56      20.815   5.095   2.374  1.00  0.66           C  
ATOM    812  CG1 VAL A  56      21.080   4.697   0.932  1.00  1.02           C  
ATOM    813  CG2 VAL A  56      22.092   5.016   3.198  1.00  1.23           C  
ATOM    814  H   VAL A  56      19.052   6.822   4.191  1.00  0.60           H  
ATOM    815  HA  VAL A  56      20.927   7.206   2.025  1.00  0.64           H  
ATOM    816  HB  VAL A  56      20.101   4.401   2.790  1.00  1.22           H  
ATOM    817 HG11 VAL A  56      21.758   5.408   0.480  1.00  1.71           H  
ATOM    818 HG12 VAL A  56      21.522   3.712   0.904  1.00  1.42           H  
ATOM    819 HG13 VAL A  56      20.149   4.690   0.383  1.00  1.57           H  
ATOM    820 HG21 VAL A  56      22.524   4.031   3.097  1.00  1.63           H  
ATOM    821 HG22 VAL A  56      22.794   5.755   2.845  1.00  1.71           H  
ATOM    822 HG23 VAL A  56      21.863   5.200   4.236  1.00  1.87           H  
ATOM    823  N   SER A  57      19.023   7.167   0.437  1.00  0.48           N  
ATOM    824  CA  SER A  57      17.871   7.280  -0.450  1.00  0.43           C  
ATOM    825  C   SER A  57      18.063   6.445  -1.713  1.00  0.42           C  
ATOM    826  O   SER A  57      18.861   6.794  -2.583  1.00  0.46           O  
ATOM    827  CB  SER A  57      17.638   8.743  -0.828  1.00  0.51           C  
ATOM    828  OG  SER A  57      16.516   8.881  -1.682  1.00  0.64           O  
ATOM    829  H   SER A  57      19.880   7.550   0.158  1.00  0.55           H  
ATOM    830  HA  SER A  57      17.005   6.914   0.080  1.00  0.42           H  
ATOM    831  HB2 SER A  57      17.464   9.322   0.067  1.00  0.73           H  
ATOM    832  HG  SER A  57      16.782   9.321  -2.494  1.00  1.07           H  
ATOM    833  N   LEU A  58      17.327   5.344  -1.804  1.00  0.38           N  
ATOM    834  CA  LEU A  58      17.407   4.464  -2.965  1.00  0.40           C  
ATOM    835  C   LEU A  58      16.226   4.701  -3.898  1.00  0.37           C  
ATOM    836  O   LEU A  58      15.163   5.148  -3.466  1.00  0.38           O  
ATOM    837  CB  LEU A  58      17.438   2.998  -2.526  1.00  0.43           C  
ATOM    838  CG  LEU A  58      17.605   1.987  -3.662  1.00  0.96           C  
ATOM    839  CD1 LEU A  58      18.908   2.232  -4.405  1.00  1.50           C  
ATOM    840  CD2 LEU A  58      17.559   0.565  -3.121  1.00  1.54           C  
ATOM    841  H   LEU A  58      16.715   5.115  -1.073  1.00  0.38           H  
ATOM    842  HA  LEU A  58      18.322   4.694  -3.492  1.00  0.42           H  
ATOM    843  HB2 LEU A  58      18.256   2.869  -1.830  1.00  1.02           H  
ATOM    844  HG  LEU A  58      16.793   2.106  -4.363  1.00  1.80           H  
ATOM    845 HD11 LEU A  58      18.999   1.524  -5.216  1.00  1.96           H  
ATOM    846 HD12 LEU A  58      18.914   3.236  -4.799  1.00  2.01           H  
ATOM    847 HD13 LEU A  58      19.739   2.109  -3.726  1.00  2.03           H  
ATOM    848 HD21 LEU A  58      16.613   0.398  -2.629  1.00  2.10           H  
ATOM    849 HD22 LEU A  58      17.671  -0.133  -3.937  1.00  2.10           H  
ATOM    850 HD23 LEU A  58      18.363   0.422  -2.413  1.00  1.89           H  
ATOM    851  N   VAL A  59      16.416   4.403  -5.178  1.00  0.41           N  
ATOM    852  CA  VAL A  59      15.359   4.587  -6.165  1.00  0.40           C  
ATOM    853  C   VAL A  59      14.786   3.247  -6.616  1.00  0.40           C  
ATOM    854  O   VAL A  59      15.522   2.282  -6.822  1.00  0.47           O  
ATOM    855  CB  VAL A  59      15.870   5.357  -7.397  1.00  0.45           C  
ATOM    856  CG1 VAL A  59      16.950   4.560  -8.115  1.00  0.50           C  
ATOM    857  CG2 VAL A  59      14.719   5.680  -8.337  1.00  0.45           C  
ATOM    858  H   VAL A  59      17.285   4.054  -5.466  1.00  0.48           H  
ATOM    859  HA  VAL A  59      14.573   5.169  -5.705  1.00  0.40           H  
ATOM    860  HB  VAL A  59      16.305   6.286  -7.061  1.00  0.47           H  
ATOM    861 HG11 VAL A  59      16.546   3.609  -8.429  1.00  1.11           H  
ATOM    862 HG12 VAL A  59      17.288   5.112  -8.980  1.00  1.07           H  
ATOM    863 HG13 VAL A  59      17.780   4.395  -7.445  1.00  1.10           H  
ATOM    864 HG21 VAL A  59      14.245   4.764  -8.652  1.00  1.09           H  
ATOM    865 HG22 VAL A  59      14.000   6.300  -7.823  1.00  1.09           H  
ATOM    866 HG23 VAL A  59      15.097   6.206  -9.202  1.00  1.06           H  
ATOM    867  N   LEU A  60      13.466   3.197  -6.767  1.00  0.39           N  
ATOM    868  CA  LEU A  60      12.788   1.977  -7.195  1.00  0.40           C  
ATOM    869  C   LEU A  60      11.850   2.262  -8.364  1.00  0.38           C  
ATOM    870  O   LEU A  60      11.538   3.416  -8.659  1.00  0.48           O  
ATOM    871  CB  LEU A  60      12.008   1.365  -6.032  1.00  0.45           C  
ATOM    872  CG  LEU A  60      12.860   0.935  -4.836  1.00  0.61           C  
ATOM    873  CD1 LEU A  60      11.992   0.307  -3.757  1.00  0.77           C  
ATOM    874  CD2 LEU A  60      13.945  -0.036  -5.279  1.00  0.97           C  
ATOM    875  H   LEU A  60      12.933   3.998  -6.585  1.00  0.41           H  
ATOM    876  HA  LEU A  60      13.542   1.277  -7.520  1.00  0.47           H  
ATOM    877  HB2 LEU A  60      11.282   2.089  -5.689  1.00  0.60           H  
ATOM    878  HG  LEU A  60      13.341   1.804  -4.414  1.00  0.89           H  
ATOM    879 HD11 LEU A  60      11.480  -0.553  -4.161  1.00  1.22           H  
ATOM    880 HD12 LEU A  60      12.612   0.001  -2.928  1.00  1.35           H  
ATOM    881 HD13 LEU A  60      11.264   1.030  -3.415  1.00  1.37           H  
ATOM    882 HD21 LEU A  60      14.587   0.447  -6.001  1.00  1.42           H  
ATOM    883 HD22 LEU A  60      14.530  -0.337  -4.424  1.00  1.56           H  
ATOM    884 HD23 LEU A  60      13.489  -0.905  -5.728  1.00  1.46           H  
ATOM    885  N   ARG A  61      11.395   1.200  -9.023  1.00  0.51           N  
ATOM    886  CA  ARG A  61      10.498   1.335 -10.166  1.00  0.58           C  
ATOM    887  C   ARG A  61       9.221   0.527  -9.950  1.00  0.54           C  
ATOM    888  O   ARG A  61       9.268  -0.616  -9.498  1.00  0.59           O  
ATOM    889  CB  ARG A  61      11.201   0.874 -11.441  1.00  0.69           C  
ATOM    890  CG  ARG A  61      12.444   1.682 -11.775  1.00  1.34           C  
ATOM    891  CD  ARG A  61      13.147   1.147 -13.011  1.00  1.51           C  
ATOM    892  NE  ARG A  61      14.296   1.964 -13.388  1.00  2.06           N  
ATOM    893  CZ  ARG A  61      14.898   1.886 -14.569  1.00  2.47           C  
ATOM    894  NH1 ARG A  61      14.459   1.033 -15.485  1.00  2.45           N  
ATOM    895  NH2 ARG A  61      15.939   2.662 -14.840  1.00  3.32           N  
ATOM    896  H   ARG A  61      11.664   0.306  -8.733  1.00  0.67           H  
ATOM    897  HA  ARG A  61      10.239   2.378 -10.262  1.00  0.67           H  
ATOM    898  HB2 ARG A  61      11.492  -0.161 -11.326  1.00  0.91           H  
ATOM    899  HG2 ARG A  61      12.157   2.709 -11.955  1.00  1.91           H  
ATOM    900  HD2 ARG A  61      13.485   0.140 -12.809  1.00  1.87           H  
ATOM    901  HE  ARG A  61      14.637   2.601 -12.725  1.00  2.52           H  
ATOM    902 HH11 ARG A  61      13.674   0.448 -15.287  1.00  2.39           H  
ATOM    903 HH12 ARG A  61      14.914   0.976 -16.374  1.00  2.86           H  
ATOM    904 HH21 ARG A  61      16.274   3.307 -14.153  1.00  3.81           H  
ATOM    905 HH22 ARG A  61      16.391   2.603 -15.730  1.00  3.64           H  
ATOM    906  N   LYS A  62       8.082   1.129 -10.284  1.00  0.69           N  
ATOM    907  CA  LYS A  62       6.789   0.470 -10.124  1.00  0.74           C  
ATOM    908  C   LYS A  62       6.828  -0.962 -10.652  1.00  0.68           C  
ATOM    909  O   LYS A  62       6.104  -1.832 -10.169  1.00  0.76           O  
ATOM    910  CB  LYS A  62       5.696   1.261 -10.849  1.00  0.92           C  
ATOM    911  CG  LYS A  62       4.307   0.662 -10.703  1.00  1.88           C  
ATOM    912  CD  LYS A  62       3.584   1.205  -9.479  1.00  2.95           C  
ATOM    913  CE  LYS A  62       4.354   0.927  -8.198  1.00  3.60           C  
ATOM    914  NZ  LYS A  62       3.543   1.223  -6.986  1.00  4.70           N  
ATOM    915  H   LYS A  62       8.112   2.040 -10.643  1.00  0.86           H  
ATOM    916  HA  LYS A  62       6.562   0.443  -9.072  1.00  0.78           H  
ATOM    917  HB2 LYS A  62       5.675   2.267 -10.454  1.00  1.41           H  
ATOM    918  HG2 LYS A  62       3.729   0.900 -11.582  1.00  2.24           H  
ATOM    919  HD2 LYS A  62       3.462   2.272  -9.587  1.00  3.28           H  
ATOM    920  HE2 LYS A  62       4.641  -0.115  -8.183  1.00  3.61           H  
ATOM    921  HZ1 LYS A  62       4.090   1.011  -6.127  1.00  5.05           H  
ATOM    922  HZ2 LYS A  62       2.678   0.642  -6.983  1.00  5.09           H  
ATOM    923  HZ3 LYS A  62       3.271   2.226  -6.973  1.00  5.08           H  
ATOM    924  N   LYS A  63       7.680  -1.201 -11.646  1.00  0.64           N  
ATOM    925  CA  LYS A  63       7.814  -2.530 -12.229  1.00  0.71           C  
ATOM    926  C   LYS A  63       8.782  -3.373 -11.409  1.00  0.63           C  
ATOM    927  O   LYS A  63       8.639  -4.594 -11.320  1.00  0.73           O  
ATOM    928  CB  LYS A  63       8.294  -2.437 -13.679  1.00  0.88           C  
ATOM    929  CG  LYS A  63       9.558  -1.614 -13.853  1.00  0.88           C  
ATOM    930  CD  LYS A  63      10.050  -1.652 -15.293  1.00  1.10           C  
ATOM    931  CE  LYS A  63      11.195  -0.678 -15.515  1.00  1.67           C  
ATOM    932  NZ  LYS A  63      10.766   0.734 -15.328  1.00  2.28           N  
ATOM    933  H   LYS A  63       8.228  -0.469 -11.992  1.00  0.65           H  
ATOM    934  HA  LYS A  63       6.842  -3.000 -12.208  1.00  0.78           H  
ATOM    935  HB2 LYS A  63       8.486  -3.434 -14.046  1.00  0.98           H  
ATOM    936  HG2 LYS A  63       9.352  -0.591 -13.581  1.00  0.84           H  
ATOM    937  HD2 LYS A  63      10.390  -2.650 -15.519  1.00  1.57           H  
ATOM    938  HE2 LYS A  63      11.983  -0.902 -14.812  1.00  2.11           H  
ATOM    939  HZ1 LYS A  63       9.979   0.956 -15.969  1.00  2.66           H  
ATOM    940  HZ2 LYS A  63      11.556   1.379 -15.532  1.00  2.72           H  
ATOM    941  HZ3 LYS A  63      10.455   0.886 -14.346  1.00  2.64           H  
ATOM    942  N   ASP A  64       9.768  -2.714 -10.810  1.00  0.54           N  
ATOM    943  CA  ASP A  64      10.759  -3.396  -9.989  1.00  0.54           C  
ATOM    944  C   ASP A  64      10.126  -3.908  -8.698  1.00  0.46           C  
ATOM    945  O   ASP A  64      10.479  -4.979  -8.204  1.00  0.56           O  
ATOM    946  CB  ASP A  64      11.918  -2.452  -9.662  1.00  0.56           C  
ATOM    947  CG  ASP A  64      12.988  -3.115  -8.817  1.00  1.38           C  
ATOM    948  OD1 ASP A  64      13.910  -3.726  -9.397  1.00  1.49           O  
ATOM    949  OD2 ASP A  64      12.904  -3.023  -7.574  1.00  2.30           O  
ATOM    950  H   ASP A  64       9.831  -1.743 -10.925  1.00  0.56           H  
ATOM    951  HA  ASP A  64      11.137  -4.237 -10.550  1.00  0.64           H  
ATOM    952  HB2 ASP A  64      12.371  -2.117 -10.584  1.00  1.10           H  
ATOM    953  N   LEU A  65       9.184  -3.138  -8.161  1.00  0.39           N  
ATOM    954  CA  LEU A  65       8.498  -3.514  -6.929  1.00  0.41           C  
ATOM    955  C   LEU A  65       7.707  -4.807  -7.116  1.00  0.45           C  
ATOM    956  O   LEU A  65       7.423  -5.516  -6.149  1.00  0.52           O  
ATOM    957  CB  LEU A  65       7.561  -2.393  -6.471  1.00  0.51           C  
ATOM    958  CG  LEU A  65       8.249  -1.194  -5.815  1.00  0.49           C  
ATOM    959  CD1 LEU A  65       9.045  -0.404  -6.842  1.00  0.67           C  
ATOM    960  CD2 LEU A  65       7.224  -0.301  -5.130  1.00  0.70           C  
ATOM    961  H   LEU A  65       8.945  -2.295  -8.602  1.00  0.40           H  
ATOM    962  HA  LEU A  65       9.248  -3.675  -6.169  1.00  0.41           H  
ATOM    963  HB2 LEU A  65       7.010  -2.040  -7.331  1.00  0.54           H  
ATOM    964  HG  LEU A  65       8.937  -1.551  -5.062  1.00  0.71           H  
ATOM    965 HD11 LEU A  65       8.377  -0.028  -7.600  1.00  1.13           H  
ATOM    966 HD12 LEU A  65       9.536   0.425  -6.354  1.00  1.41           H  
ATOM    967 HD13 LEU A  65       9.785  -1.045  -7.295  1.00  1.19           H  
ATOM    968 HD21 LEU A  65       7.727   0.536  -4.670  1.00  1.32           H  
ATOM    969 HD22 LEU A  65       6.517   0.062  -5.860  1.00  1.30           H  
ATOM    970 HD23 LEU A  65       6.703  -0.867  -4.373  1.00  1.04           H  
ATOM    971  N   ALA A  66       7.353  -5.107  -8.360  1.00  0.46           N  
ATOM    972  CA  ALA A  66       6.591  -6.312  -8.672  1.00  0.52           C  
ATOM    973  C   ALA A  66       7.296  -7.562  -8.153  1.00  0.50           C  
ATOM    974  O   ALA A  66       6.648  -8.530  -7.754  1.00  0.66           O  
ATOM    975  CB  ALA A  66       6.365  -6.419 -10.173  1.00  0.60           C  
ATOM    976  H   ALA A  66       7.605  -4.501  -9.089  1.00  0.46           H  
ATOM    977  HA  ALA A  66       5.628  -6.230  -8.192  1.00  0.56           H  
ATOM    978  HB1 ALA A  66       7.314  -6.543 -10.673  1.00  1.20           H  
ATOM    979  HB2 ALA A  66       5.734  -7.271 -10.382  1.00  1.18           H  
ATOM    980  HB3 ALA A  66       5.883  -5.520 -10.529  1.00  1.16           H  
ATOM    981  N   LEU A  67       8.626  -7.537  -8.156  1.00  0.37           N  
ATOM    982  CA  LEU A  67       9.413  -8.673  -7.688  1.00  0.35           C  
ATOM    983  C   LEU A  67       9.568  -8.649  -6.171  1.00  0.31           C  
ATOM    984  O   LEU A  67       9.132  -9.568  -5.479  1.00  0.30           O  
ATOM    985  CB  LEU A  67      10.792  -8.676  -8.350  1.00  0.38           C  
ATOM    986  CG  LEU A  67      10.783  -8.751  -9.879  1.00  0.43           C  
ATOM    987  CD1 LEU A  67      12.202  -8.714 -10.423  1.00  0.48           C  
ATOM    988  CD2 LEU A  67      10.061 -10.008 -10.343  1.00  0.47           C  
ATOM    989  H   LEU A  67       9.088  -6.734  -8.479  1.00  0.37           H  
ATOM    990  HA  LEU A  67       8.890  -9.574  -7.969  1.00  0.37           H  
ATOM    991  HB2 LEU A  67      11.313  -7.775  -8.057  1.00  0.37           H  
ATOM    992  HG  LEU A  67      10.252  -7.895 -10.271  1.00  0.45           H  
ATOM    993 HD11 LEU A  67      12.756  -9.561 -10.043  1.00  1.15           H  
ATOM    994 HD12 LEU A  67      12.174  -8.759 -11.502  1.00  1.08           H  
ATOM    995 HD13 LEU A  67      12.685  -7.800 -10.112  1.00  1.15           H  
ATOM    996 HD21 LEU A  67       9.052 -10.007  -9.955  1.00  1.09           H  
ATOM    997 HD22 LEU A  67      10.034 -10.028 -11.422  1.00  1.10           H  
ATOM    998 HD23 LEU A  67      10.587 -10.878  -9.978  1.00  1.16           H  
ATOM    999  N   ILE A  68      10.188  -7.591  -5.659  1.00  0.31           N  
ATOM   1000  CA  ILE A  68      10.404  -7.455  -4.225  1.00  0.30           C  
ATOM   1001  C   ILE A  68       9.081  -7.315  -3.479  1.00  0.30           C  
ATOM   1002  O   ILE A  68       8.136  -6.706  -3.983  1.00  0.37           O  
ATOM   1003  CB  ILE A  68      11.295  -6.238  -3.907  1.00  0.34           C  
ATOM   1004  CG1 ILE A  68      10.632  -4.952  -4.398  1.00  0.38           C  
ATOM   1005  CG2 ILE A  68      12.668  -6.408  -4.538  1.00  0.38           C  
ATOM   1006  CD1 ILE A  68      11.474  -3.715  -4.171  1.00  0.43           C  
ATOM   1007  H   ILE A  68      10.507  -6.888  -6.261  1.00  0.34           H  
ATOM   1008  HA  ILE A  68      10.910  -8.346  -3.878  1.00  0.30           H  
ATOM   1009  HB  ILE A  68      11.421  -6.184  -2.836  1.00  0.34           H  
ATOM   1010 HG12 ILE A  68      10.444  -5.034  -5.458  1.00  0.40           H  
ATOM   1011 HG21 ILE A  68      12.565  -6.486  -5.609  1.00  1.00           H  
ATOM   1012 HG22 ILE A  68      13.282  -5.552  -4.296  1.00  1.00           H  
ATOM   1013 HG23 ILE A  68      13.133  -7.303  -4.154  1.00  1.07           H  
ATOM   1014 HD11 ILE A  68      10.926  -2.842  -4.493  1.00  1.08           H  
ATOM   1015 HD12 ILE A  68      11.705  -3.625  -3.120  1.00  1.12           H  
ATOM   1016 HD13 ILE A  68      12.391  -3.795  -4.735  1.00  1.12           H  
ATOM   1017  N   GLU A  69       9.020  -7.886  -2.282  1.00  0.29           N  
ATOM   1018  CA  GLU A  69       7.811  -7.830  -1.469  1.00  0.32           C  
ATOM   1019  C   GLU A  69       7.856  -6.645  -0.510  1.00  0.31           C  
ATOM   1020  O   GLU A  69       8.932  -6.177  -0.137  1.00  0.37           O  
ATOM   1021  CB  GLU A  69       7.640  -9.132  -0.684  1.00  0.34           C  
ATOM   1022  CG  GLU A  69       6.265  -9.291  -0.058  1.00  0.44           C  
ATOM   1023  CD  GLU A  69       6.086 -10.633   0.620  1.00  1.30           C  
ATOM   1024  OE1 GLU A  69       6.438 -10.748   1.814  1.00  2.29           O  
ATOM   1025  OE2 GLU A  69       5.595 -11.573  -0.041  1.00  1.26           O  
ATOM   1026  H   GLU A  69       9.808  -8.354  -1.934  1.00  0.30           H  
ATOM   1027  HA  GLU A  69       6.969  -7.708  -2.134  1.00  0.35           H  
ATOM   1028  HB2 GLU A  69       7.811  -9.964  -1.350  1.00  0.35           H  
ATOM   1029  HG2 GLU A  69       6.124  -8.512   0.675  1.00  1.00           H  
ATOM   1030  N   LEU A  70       6.683  -6.166  -0.111  1.00  0.32           N  
ATOM   1031  CA  LEU A  70       6.592  -5.033   0.803  1.00  0.33           C  
ATOM   1032  C   LEU A  70       5.625  -5.328   1.946  1.00  0.33           C  
ATOM   1033  O   LEU A  70       4.654  -6.065   1.778  1.00  0.45           O  
ATOM   1034  CB  LEU A  70       6.138  -3.779   0.053  1.00  0.38           C  
ATOM   1035  CG  LEU A  70       7.056  -3.338  -1.090  1.00  0.95           C  
ATOM   1036  CD1 LEU A  70       6.480  -2.118  -1.794  1.00  1.25           C  
ATOM   1037  CD2 LEU A  70       8.455  -3.042  -0.568  1.00  1.85           C  
ATOM   1038  H   LEU A  70       5.858  -6.584  -0.438  1.00  0.37           H  
ATOM   1039  HA  LEU A  70       7.576  -4.860   1.214  1.00  0.35           H  
ATOM   1040  HB2 LEU A  70       5.156  -3.965  -0.356  1.00  0.72           H  
ATOM   1041  HG  LEU A  70       7.130  -4.135  -1.814  1.00  1.72           H  
ATOM   1042 HD11 LEU A  70       5.510  -2.363  -2.202  1.00  1.77           H  
ATOM   1043 HD12 LEU A  70       6.379  -1.308  -1.087  1.00  1.79           H  
ATOM   1044 HD13 LEU A  70       7.141  -1.818  -2.593  1.00  1.66           H  
ATOM   1045 HD21 LEU A  70       8.854  -3.924  -0.088  1.00  2.39           H  
ATOM   1046 HD22 LEU A  70       9.093  -2.759  -1.391  1.00  2.36           H  
ATOM   1047 HD23 LEU A  70       8.409  -2.233   0.146  1.00  2.28           H  
ATOM   1048  N   GLU A  71       5.899  -4.745   3.108  1.00  0.35           N  
ATOM   1049  CA  GLU A  71       5.054  -4.938   4.279  1.00  0.38           C  
ATOM   1050  C   GLU A  71       4.778  -3.609   4.972  1.00  0.37           C  
ATOM   1051  O   GLU A  71       5.692  -2.965   5.486  1.00  0.52           O  
ATOM   1052  CB  GLU A  71       5.712  -5.911   5.260  1.00  0.47           C  
ATOM   1053  CG  GLU A  71       4.904  -6.133   6.527  1.00  0.54           C  
ATOM   1054  CD  GLU A  71       5.567  -7.108   7.483  1.00  1.31           C  
ATOM   1055  OE1 GLU A  71       6.367  -6.658   8.329  1.00  2.24           O  
ATOM   1056  OE2 GLU A  71       5.285  -8.321   7.384  1.00  1.26           O  
ATOM   1057  H   GLU A  71       6.691  -4.171   3.179  1.00  0.43           H  
ATOM   1058  HA  GLU A  71       4.118  -5.357   3.945  1.00  0.42           H  
ATOM   1059  HB2 GLU A  71       5.844  -6.865   4.770  1.00  0.53           H  
ATOM   1060  HG2 GLU A  71       4.782  -5.186   7.033  1.00  1.00           H  
ATOM   1061  N   ALA A  72       3.513  -3.201   4.978  1.00  0.45           N  
ATOM   1062  CA  ALA A  72       3.120  -1.947   5.607  1.00  0.52           C  
ATOM   1063  C   ALA A  72       3.416  -1.967   7.102  1.00  0.44           C  
ATOM   1064  O   ALA A  72       3.310  -3.006   7.755  1.00  0.53           O  
ATOM   1065  CB  ALA A  72       1.643  -1.674   5.363  1.00  0.76           C  
ATOM   1066  H   ALA A  72       2.829  -3.757   4.550  1.00  0.58           H  
ATOM   1067  HA  ALA A  72       3.689  -1.152   5.149  1.00  0.58           H  
ATOM   1068  HB1 ALA A  72       1.052  -2.456   5.816  1.00  1.26           H  
ATOM   1069  HB2 ALA A  72       1.377  -0.723   5.799  1.00  1.30           H  
ATOM   1070  HB3 ALA A  72       1.452  -1.649   4.300  1.00  1.34           H  
ATOM   1071  N   VAL A  73       3.789  -0.809   7.639  1.00  0.58           N  
ATOM   1072  CA  VAL A  73       4.098  -0.690   9.059  1.00  0.64           C  
ATOM   1073  C   VAL A  73       2.893  -1.053   9.917  1.00  0.83           C  
ATOM   1074  O   VAL A  73       1.834  -1.410   9.402  1.00  0.99           O  
ATOM   1075  CB  VAL A  73       4.558   0.734   9.415  1.00  0.78           C  
ATOM   1076  CG1 VAL A  73       5.864   1.065   8.708  1.00  1.01           C  
ATOM   1077  CG2 VAL A  73       3.483   1.749   9.060  1.00  1.16           C  
ATOM   1078  H   VAL A  73       3.859  -0.017   7.066  1.00  0.78           H  
ATOM   1079  HA  VAL A  73       4.905  -1.373   9.282  1.00  0.66           H  
ATOM   1080  HB  VAL A  73       4.730   0.780  10.480  1.00  0.90           H  
ATOM   1081 HG11 VAL A  73       5.722   0.999   7.640  1.00  1.40           H  
ATOM   1082 HG12 VAL A  73       6.172   2.066   8.971  1.00  1.45           H  
ATOM   1083 HG13 VAL A  73       6.626   0.363   9.012  1.00  1.65           H  
ATOM   1084 HG21 VAL A  73       2.568   1.502   9.580  1.00  1.42           H  
ATOM   1085 HG22 VAL A  73       3.808   2.737   9.353  1.00  1.62           H  
ATOM   1086 HG23 VAL A  73       3.306   1.729   7.995  1.00  1.76           H  
ATOM   1087  N   ALA A  74       3.060  -0.957  11.232  1.00  0.99           N  
ATOM   1088  CA  ALA A  74       1.987  -1.277  12.164  1.00  1.25           C  
ATOM   1089  C   ALA A  74       1.139  -0.049  12.473  1.00  1.66           C  
ATOM   1090  O   ALA A  74       1.534   0.808  13.263  1.00  2.28           O  
ATOM   1091  CB  ALA A  74       2.561  -1.861  13.447  1.00  1.57           C  
ATOM   1092  H   ALA A  74       3.928  -0.664  11.584  1.00  1.02           H  
ATOM   1093  HA  ALA A  74       1.362  -2.029  11.704  1.00  1.32           H  
ATOM   1094  HB1 ALA A  74       3.160  -2.727  13.211  1.00  2.22           H  
ATOM   1095  HB2 ALA A  74       3.174  -1.119  13.937  1.00  1.69           H  
ATOM   1096  HB3 ALA A  74       1.752  -2.149  14.103  1.00  1.93           H  
ATOM   1097  N   GLN A  75      -0.029   0.031  11.842  1.00  1.95           N  
ATOM   1098  CA  GLN A  75      -0.935   1.153  12.053  1.00  2.53           C  
ATOM   1099  C   GLN A  75      -1.322   1.269  13.524  1.00  2.88           C  
ATOM   1100  O   GLN A  75      -1.570   0.264  14.192  1.00  3.14           O  
ATOM   1101  CB  GLN A  75      -2.191   0.987  11.196  1.00  3.27           C  
ATOM   1102  CG  GLN A  75      -1.907   0.957   9.702  1.00  3.83           C  
ATOM   1103  CD  GLN A  75      -1.256   2.234   9.209  1.00  4.50           C  
ATOM   1104  OE1 GLN A  75      -1.936   3.179   8.808  1.00  4.86           O  
ATOM   1105  NE2 GLN A  75       0.072   2.270   9.237  1.00  5.13           N  
ATOM   1106  H   GLN A  75      -0.286  -0.681  11.220  1.00  2.15           H  
ATOM   1107  HA  GLN A  75      -0.422   2.055  11.755  1.00  2.76           H  
ATOM   1108  HB2 GLN A  75      -2.678   0.063  11.466  1.00  3.74           H  
ATOM   1109  HG2 GLN A  75      -1.247   0.131   9.491  1.00  4.02           H  
ATOM   1110 HE21 GLN A  75       0.550   1.482   9.569  1.00  5.14           H  
ATOM   1111 HE22 GLN A  75       0.519   3.084   8.924  1.00  5.77           H  
TER    1112      GLN A  75                                                      
END
MOLECULE T0462.pdb
ATOM      1  C   MET     1       3.518  -5.525  -1.015  1.00 72.54           C 
ATOM      2  O   MET     1       4.514  -5.922  -0.421  1.00 61.43           O 
ATOM      3  N   MET     1       1.797  -7.249  -0.416  1.00 62.03           N 
ATOM      4  CA  MET     1       2.106  -5.791  -0.468  1.00  1.42           C 
ATOM      5  CB  MET     1       1.945  -5.166   0.931  1.00  3.15           C 
ATOM      6  CG  MET     1       2.652  -3.826   1.103  1.00 20.23           C 
ATOM      7  SD  MET     1       2.005  -2.537   0.021  1.00  4.24           S 
ATOM      8  CE  MET     1       0.587  -1.980   0.962  1.00 12.22           C 
ATOM      9 1H   MET     1       2.447  -7.731   0.242  1.00 36.29           H 
ATOM     10 2H   MET     1       1.909  -7.674  -1.357  1.00 36.29           H 
ATOM     11 3H   MET     1       0.818  -7.396  -0.095  1.00 36.29           H 
ATOM     12  HA  MET     1       1.390  -5.330  -1.136  1.00  4.22           H 
ATOM     13 3HB  MET     1       2.337  -5.854   1.668  1.00 36.29           H 
ATOM     14 2HB  MET     1       0.892  -5.015   1.123  1.00 36.29           H 
ATOM     15 3HG  MET     1       3.702  -3.962   0.888  1.00 36.29           H 
ATOM     16 2HG  MET     1       2.538  -3.502   2.127  1.00 36.29           H 
ATOM     17 1HE  MET     1      -0.112  -2.794   1.079  1.00 36.29           H 
ATOM     18 2HE  MET     1       0.108  -1.165   0.439  1.00 36.29           H 
ATOM     19 3HE  MET     1       0.911  -1.640   1.935  1.00 36.29           H 
ATOM     20  N   LYS     2       3.591  -4.846  -2.158  1.00  4.01           N 
ATOM     21  CA  LYS     2       4.874  -4.436  -2.746  1.00 14.04           C 
ATOM     22  C   LYS     2       5.042  -2.911  -2.669  1.00 71.54           C 
ATOM     23  O   LYS     2       4.069  -2.166  -2.787  1.00  5.03           O 
ATOM     24  CB  LYS     2       4.982  -4.912  -4.207  1.00 41.30           C 
ATOM     25  CG  LYS     2       5.651  -6.277  -4.378  1.00 35.55           C 
ATOM     26  CD  LYS     2       4.888  -7.412  -3.703  1.00 24.21           C 
ATOM     27  CE  LYS     2       5.601  -8.746  -3.913  1.00 54.20           C 
ATOM     28  NZ  LYS     2       4.888  -9.880  -3.264  1.00 23.11           N 
ATOM     29  H   LYS     2       2.763  -4.602  -2.617  1.00 36.29           H 
ATOM     30  HA  LYS     2       5.666  -4.897  -2.168  1.00 52.45           H 
ATOM     31 3HB  LYS     2       5.556  -4.188  -4.770  1.00 36.29           H 
ATOM     32 2HB  LYS     2       3.989  -4.969  -4.631  1.00 36.29           H 
ATOM     33 3HG  LYS     2       6.647  -6.227  -3.957  1.00 36.29           H 
ATOM     34 2HG  LYS     2       5.724  -6.494  -5.433  1.00 36.29           H 
ATOM     35 3HD  LYS     2       3.895  -7.473  -4.126  1.00 36.29           H 
ATOM     36 2HD  LYS     2       4.822  -7.212  -2.644  1.00 36.29           H 
ATOM     37 3HE  LYS     2       6.597  -8.675  -3.499  1.00 36.29           H 
ATOM     38 2HE  LYS     2       5.669  -8.940  -4.973  1.00 36.29           H 
ATOM     39 1HZ  LYS     2       4.773  -9.696  -2.246  1.00 36.29           H 
ATOM     40 2HZ  LYS     2       5.434 -10.759  -3.385  1.00 36.29           H 
ATOM     41 3HZ  LYS     2       3.951 -10.007  -3.690  1.00 36.29           H 
ATOM     42  N   LEU     3       6.279  -2.445  -2.492  1.00 54.05           N 
ATOM     43  CA  LEU     3       6.551  -1.006  -2.322  1.00 12.34           C 
ATOM     44  C   LEU     3       6.221  -0.190  -3.591  1.00 75.43           C 
ATOM     45  O   LEU     3       6.193   1.039  -3.556  1.00 30.52           O 
ATOM     46  CB  LEU     3       8.016  -0.794  -1.890  1.00 44.12           C 
ATOM     47  CG  LEU     3       9.093  -1.161  -2.934  1.00 51.02           C 
ATOM     48  CD1 LEU     3       9.466   0.048  -3.795  1.00 31.15           C 
ATOM     49  CD2 LEU     3      10.332  -1.742  -2.258  1.00 12.10           C 
ATOM     50  H   LEU     3       7.028  -3.081  -2.468  1.00 36.29           H 
ATOM     51  HA  LEU     3       5.909  -0.654  -1.524  1.00 75.20           H 
ATOM     52 3HB  LEU     3       8.188  -1.389  -1.004  1.00 36.29           H 
ATOM     53 2HB  LEU     3       8.140   0.246  -1.624  1.00 36.29           H 
ATOM     54  HG  LEU     3       8.695  -1.919  -3.597  1.00 53.15           H 
ATOM     55 1HD1 LEU     3       9.859   0.832  -3.164  1.00 36.29           H 
ATOM     56 2HD1 LEU     3       8.590   0.408  -4.313  1.00 36.29           H 
ATOM     57 3HD1 LEU     3      10.216  -0.241  -4.517  1.00 36.29           H 
ATOM     58 1HD2 LEU     3      11.058  -2.020  -3.009  1.00 36.29           H 
ATOM     59 2HD2 LEU     3      10.056  -2.616  -1.686  1.00 36.29           H 
ATOM     60 3HD2 LEU     3      10.765  -1.004  -1.598  1.00 36.29           H 
ATOM     61  N   SER     4       5.945  -0.883  -4.701  1.00  4.23           N 
ATOM     62  CA  SER     4       5.589  -0.227  -5.974  1.00 32.21           C 
ATOM     63  C   SER     4       4.229   0.480  -5.900  1.00 20.35           C 
ATOM     64  O   SER     4       3.854   1.213  -6.814  1.00 13.44           O 
ATOM     65  CB  SER     4       5.543  -1.258  -7.115  1.00 23.31           C 
ATOM     66  OG  SER     4       4.601  -2.291  -6.849  1.00 33.45           O 
ATOM     67  H   SER     4       5.981  -1.860  -4.667  1.00 36.29           H 
ATOM     68  HA  SER     4       6.351   0.505  -6.197  1.00  2.13           H 
ATOM     69 3HB  SER     4       6.518  -1.702  -7.235  1.00 36.29           H 
ATOM     70 2HB  SER     4       5.263  -0.764  -8.033  1.00 36.29           H 
ATOM     71  HG  SER     4       4.753  -3.024  -7.464  1.00 23.50           H 
ATOM     72  N   ARG     5       3.493   0.245  -4.816  1.00 74.24           N 
ATOM     73  CA  ARG     5       2.136   0.783  -4.660  1.00 65.23           C 
ATOM     74  C   ARG     5       1.911   1.351  -3.250  1.00 50.53           C 
ATOM     75  O   ARG     5       0.779   1.617  -2.853  1.00  3.14           O 
ATOM     76  CB  ARG     5       1.136  -0.345  -4.937  1.00 32.44           C 
ATOM     77  CG  ARG     5       1.216  -1.485  -3.918  1.00 60.24           C 
ATOM     78  CD  ARG     5       0.735  -2.805  -4.499  1.00 44.11           C 
ATOM     79  NE  ARG     5       1.633  -3.289  -5.550  1.00 13.55           N 
ATOM     80  CZ  ARG     5       1.739  -4.539  -5.905  1.00 12.44           C 
ATOM     81  NH1 ARG     5       0.990  -5.444  -5.364  1.00 63.34           N 
ATOM     82  NH2 ARG     5       2.586  -4.888  -6.812  1.00 21.53           N 
ATOM     83  H   ARG     5       3.864  -0.317  -4.107  1.00 36.29           H 
ATOM     84  HA  ARG     5       1.992   1.572  -5.386  1.00 64.21           H 
ATOM     85 3HB  ARG     5       1.332  -0.751  -5.919  1.00 36.29           H 
ATOM     86 2HB  ARG     5       0.133   0.062  -4.919  1.00 36.29           H 
ATOM     87 3HG  ARG     5       0.606  -1.234  -3.062  1.00 36.29           H 
ATOM     88 2HG  ARG     5       2.244  -1.601  -3.602  1.00 36.29           H 
ATOM     89 3HD  ARG     5      -0.252  -2.667  -4.916  1.00 36.29           H 
ATOM     90 2HD  ARG     5       0.692  -3.538  -3.704  1.00 36.29           H 
ATOM     91  HE  ARG     5       2.201  -2.632  -5.999  1.00 75.30           H 
ATOM     92 1HH1 ARG     5       0.323  -5.193  -4.674  1.00 36.29           H 
ATOM     93 2HH1 ARG     5       1.098  -6.403  -5.639  1.00 36.29           H 
ATOM     94 1HH2 ARG     5       3.168  -4.207  -7.248  1.00 36.29           H 
ATOM     95 2HH2 ARG     5       2.657  -5.850  -7.075  1.00 36.29           H 
ATOM     96  N   LEU     6       2.994   1.542  -2.504  1.00 24.41           N 
ATOM     97  CA  LEU     6       2.903   1.977  -1.106  1.00 73.40           C 
ATOM     98  C   LEU     6       2.620   3.487  -1.005  1.00 51.45           C 
ATOM     99  O   LEU     6       3.285   4.299  -1.650  1.00 72.11           O 
ATOM    100  CB  LEU     6       4.204   1.628  -0.365  1.00 50.13           C 
ATOM    101  CG  LEU     6       4.178   1.842   1.158  1.00 51.54           C 
ATOM    102  CD1 LEU     6       3.193   0.885   1.826  1.00 34.05           C 
ATOM    103  CD2 LEU     6       5.578   1.679   1.747  1.00 44.04           C 
ATOM    104  H   LEU     6       3.878   1.408  -2.906  1.00 36.29           H 
ATOM    105  HA  LEU     6       2.084   1.437  -0.646  1.00 14.43           H 
ATOM    106 3HB  LEU     6       5.001   2.232  -0.778  1.00 36.29           H 
ATOM    107 2HB  LEU     6       4.434   0.589  -0.557  1.00 36.29           H 
ATOM    108  HG  LEU     6       3.846   2.847   1.364  1.00 12.14           H 
ATOM    109 1HD1 LEU     6       3.477  -0.136   1.615  1.00 36.29           H 
ATOM    110 2HD1 LEU     6       2.198   1.068   1.446  1.00 36.29           H 
ATOM    111 3HD1 LEU     6       3.202   1.047   2.895  1.00 36.29           H 
ATOM    112 1HD2 LEU     6       6.248   2.391   1.286  1.00 36.29           H 
ATOM    113 2HD2 LEU     6       5.935   0.676   1.561  1.00 36.29           H 
ATOM    114 3HD2 LEU     6       5.545   1.855   2.812  1.00 36.29           H 
ATOM    115  N   VAL     7       1.629   3.852  -0.188  1.00 44.11           N 
ATOM    116  CA  VAL     7       1.229   5.255  -0.013  1.00 52.30           C 
ATOM    117  C   VAL     7       2.399   6.130   0.495  1.00 41.41           C 
ATOM    118  O   VAL     7       2.938   5.888   1.576  1.00 15.11           O 
ATOM    119  CB  VAL     7       0.034   5.378   0.975  1.00 14.11           C 
ATOM    120  CG1 VAL     7      -0.397   6.838   1.141  1.00 51.14           C 
ATOM    121  CG2 VAL     7      -1.143   4.512   0.514  1.00 52.40           C 
ATOM    122  H   VAL     7       1.148   3.158   0.308  1.00 36.29           H 
ATOM    123  HA  VAL     7       0.906   5.628  -0.977  1.00 34.04           H 
ATOM    124  HB  VAL     7       0.357   5.016   1.940  1.00 41.14           H 
ATOM    125 1HG1 VAL     7       0.428   7.416   1.532  1.00 36.29           H 
ATOM    126 2HG1 VAL     7      -1.230   6.895   1.828  1.00 36.29           H 
ATOM    127 3HG1 VAL     7      -0.695   7.239   0.183  1.00 36.29           H 
ATOM    128 1HG2 VAL     7      -1.458   4.821  -0.472  1.00 36.29           H 
ATOM    129 2HG2 VAL     7      -1.969   4.620   1.205  1.00 36.29           H 
ATOM    130 3HG2 VAL     7      -0.837   3.475   0.483  1.00 36.29           H 
ATOM    131  N   PRO     8       2.802   7.162  -0.282  1.00 23.31           N 
ATOM    132  CA  PRO     8       3.902   8.073   0.102  1.00 61.14           C 
ATOM    133  C   PRO     8       3.752   8.648   1.526  1.00 24.12           C 
ATOM    134  O   PRO     8       2.852   9.448   1.798  1.00 15.04           O 
ATOM    135  CB  PRO     8       3.814   9.190  -0.945  1.00 34.35           C 
ATOM    136  CG  PRO     8       3.204   8.534  -2.139  1.00 22.30           C 
ATOM    137  CD  PRO     8       2.231   7.517  -1.600  1.00  0.40           C 
ATOM    138  HA  PRO     8       4.861   7.578   0.020  1.00 12.00           H 
ATOM    139 3HB  PRO     8       4.805   9.565  -1.163  1.00 36.29           H 
ATOM    140 2HB  PRO     8       3.192   9.995  -0.574  1.00 36.29           H 
ATOM    141 3HG  PRO     8       3.972   8.047  -2.723  1.00 36.29           H 
ATOM    142 2HG  PRO     8       2.688   9.271  -2.741  1.00 36.29           H 
ATOM    143 3HD  PRO     8       2.188   6.653  -2.248  1.00 36.29           H 
ATOM    144 2HD  PRO     8       1.247   7.955  -1.487  1.00 36.29           H 
ATOM    145  N   GLY     9       4.646   8.240   2.428  1.00 12.24           N 
ATOM    146  CA  GLY     9       4.576   8.671   3.823  1.00 71.12           C 
ATOM    147  C   GLY     9       4.364   7.512   4.795  1.00 14.14           C 
ATOM    148  O   GLY     9       4.726   7.604   5.970  1.00 53.41           O 
ATOM    149  H   GLY     9       5.370   7.646   2.142  1.00 36.29           H 
ATOM    150 3HA  GLY     9       3.761   9.374   3.939  1.00 36.29           H 
ATOM    151 2HA  GLY     9       5.501   9.170   4.077  1.00 36.29           H 
ATOM    152  N   VAL    10       3.778   6.423   4.305  1.00 64.52           N 
ATOM    153  CA  VAL    10       3.529   5.234   5.129  1.00 45.04           C 
ATOM    154  C   VAL    10       4.758   4.303   5.157  1.00 22.22           C 
ATOM    155  O   VAL    10       5.238   3.867   4.110  1.00 13.40           O 
ATOM    156  CB  VAL    10       2.297   4.444   4.613  1.00 32.21           C 
ATOM    157  CG1 VAL    10       2.049   3.193   5.455  1.00 62.22           C 
ATOM    158  CG2 VAL    10       1.055   5.336   4.592  1.00 12.32           C 
ATOM    159  H   VAL    10       3.505   6.412   3.362  1.00 36.29           H 
ATOM    160  HA  VAL    10       3.317   5.568   6.137  1.00 21.15           H 
ATOM    161  HB  VAL    10       2.500   4.129   3.598  1.00 63.25           H 
ATOM    162 1HG1 VAL    10       2.906   2.536   5.390  1.00 36.29           H 
ATOM    163 2HG1 VAL    10       1.175   2.678   5.086  1.00 36.29           H 
ATOM    164 3HG1 VAL    10       1.891   3.477   6.486  1.00 36.29           H 
ATOM    165 1HG2 VAL    10       1.226   6.180   3.939  1.00 36.29           H 
ATOM    166 2HG2 VAL    10       0.848   5.693   5.591  1.00 36.29           H 
ATOM    167 3HG2 VAL    10       0.208   4.769   4.231  1.00 36.29           H 
ATOM    168  N   PRO    11       5.292   3.994   6.358  1.00 14.03           N 
ATOM    169  CA  PRO    11       6.452   3.097   6.503  1.00  4.53           C 
ATOM    170  C   PRO    11       6.083   1.603   6.412  1.00 14.25           C 
ATOM    171  O   PRO    11       5.083   1.156   6.985  1.00  4.44           O 
ATOM    172  CB  PRO    11       6.970   3.443   7.903  1.00  4.12           C 
ATOM    173  CG  PRO    11       5.750   3.846   8.664  1.00 24.22           C 
ATOM    174  CD  PRO    11       4.824   4.503   7.666  1.00 63.44           C 
ATOM    175  HA  PRO    11       7.216   3.321   5.770  1.00 72.10           H 
ATOM    176 3HB  PRO    11       7.681   4.255   7.839  1.00 36.29           H 
ATOM    177 2HB  PRO    11       7.448   2.577   8.344  1.00 36.29           H 
ATOM    178 3HG  PRO    11       6.016   4.544   9.446  1.00 36.29           H 
ATOM    179 2HG  PRO    11       5.278   2.971   9.091  1.00 36.29           H 
ATOM    180 3HD  PRO    11       4.918   5.580   7.713  1.00 36.29           H 
ATOM    181 2HD  PRO    11       3.801   4.208   7.848  1.00 36.29           H 
ATOM    182  N   ALA    12       6.901   0.833   5.695  1.00 41.23           N 
ATOM    183  CA  ALA    12       6.690  -0.613   5.558  1.00 13.34           C 
ATOM    184  C   ALA    12       7.997  -1.397   5.764  1.00  4.20           C 
ATOM    185  O   ALA    12       9.063  -0.956   5.350  1.00 53.40           O 
ATOM    186  CB  ALA    12       6.088  -0.931   4.194  1.00 41.20           C 
ATOM    187  H   ALA    12       7.663   1.249   5.235  1.00 36.29           H 
ATOM    188  HA  ALA    12       5.982  -0.919   6.316  1.00 70.54           H 
ATOM    189 1HB  ALA    12       5.158  -0.392   4.074  1.00 36.29           H 
ATOM    190 2HB  ALA    12       5.896  -1.992   4.123  1.00 36.29           H 
ATOM    191 3HB  ALA    12       6.777  -0.637   3.414  1.00 36.29           H 
ATOM    192  N   ARG    13       7.913  -2.563   6.401  1.00 12.42           N 
ATOM    193  CA  ARG    13       9.106  -3.379   6.672  1.00 30.40           C 
ATOM    194  C   ARG    13       9.311  -4.451   5.585  1.00 42.44           C 
ATOM    195  O   ARG    13       8.356  -5.085   5.137  1.00 71.15           O 
ATOM    196  CB  ARG    13       8.995  -4.049   8.052  1.00 72.24           C 
ATOM    197  CG  ARG    13      10.269  -4.777   8.486  1.00 32.23           C 
ATOM    198  CD  ARG    13      10.105  -5.477   9.834  1.00 34.44           C 
ATOM    199  NE  ARG    13       9.133  -6.570   9.779  1.00  2.45           N 
ATOM    200  CZ  ARG    13       9.006  -7.486  10.701  1.00 54.22           C 
ATOM    201  NH1 ARG    13       9.728  -7.455  11.775  1.00 63.05           N 
ATOM    202  NH2 ARG    13       8.138  -8.429  10.548  1.00 72.55           N 
ATOM    203  H   ARG    13       7.037  -2.881   6.699  1.00 36.29           H 
ATOM    204  HA  ARG    13       9.964  -2.722   6.673  1.00 11.40           H 
ATOM    205 3HB  ARG    13       8.186  -4.765   8.031  1.00 36.29           H 
ATOM    206 2HB  ARG    13       8.770  -3.290   8.790  1.00 36.29           H 
ATOM    207 3HG  ARG    13      11.071  -4.056   8.562  1.00 36.29           H 
ATOM    208 2HG  ARG    13      10.522  -5.516   7.739  1.00 36.29           H 
ATOM    209 3HD  ARG    13       9.774  -4.752  10.565  1.00 36.29           H 
ATOM    210 2HD  ARG    13      11.064  -5.876  10.137  1.00 36.29           H 
ATOM    211  HE  ARG    13       8.548  -6.622   8.997  1.00 22.44           H 
ATOM    212 1HH1 ARG    13      10.393  -6.725  11.911  1.00 36.29           H 
ATOM    213 2HH1 ARG    13       9.621  -8.166  12.464  1.00 36.29           H 
ATOM    214 1HH2 ARG    13       7.567  -8.450   9.727  1.00 36.29           H 
ATOM    215 2HH2 ARG    13       8.039  -9.133  11.247  1.00 36.29           H 
ATOM    216  N   ILE    14      10.561  -4.637   5.169  1.00  2.55           N 
ATOM    217  CA  ILE    14      10.908  -5.622   4.137  1.00 71.42           C 
ATOM    218  C   ILE    14      10.714  -7.064   4.644  1.00 32.34           C 
ATOM    219  O   ILE    14      11.498  -7.544   5.470  1.00 73.21           O 
ATOM    220  CB  ILE    14      12.389  -5.463   3.688  1.00  2.42           C 
ATOM    221  CG1 ILE    14      12.711  -4.005   3.309  1.00  2.21           C 
ATOM    222  CG2 ILE    14      12.702  -6.398   2.519  1.00 12.31           C 
ATOM    223  CD1 ILE    14      11.972  -3.496   2.095  1.00 64.15           C 
ATOM    224  H   ILE    14      11.275  -4.094   5.564  1.00 36.29           H 
ATOM    225  HA  ILE    14      10.269  -5.456   3.280  1.00 32.01           H 
ATOM    226  HB  ILE    14      13.020  -5.753   4.517  1.00 63.30           H 
ATOM    227 3HG1 ILE    14      13.770  -3.920   3.110  1.00 36.29           H 
ATOM    228 2HG1 ILE    14      12.456  -3.363   4.137  1.00 36.29           H 
ATOM    229 1HG2 ILE    14      13.728  -6.259   2.211  1.00 36.29           H 
ATOM    230 2HG2 ILE    14      12.045  -6.174   1.692  1.00 36.29           H 
ATOM    231 3HG2 ILE    14      12.555  -7.422   2.829  1.00 36.29           H 
ATOM    232 1HD1 ILE    14      12.188  -4.129   1.247  1.00 36.29           H 
ATOM    233 2HD1 ILE    14      12.290  -2.487   1.880  1.00 36.29           H 
ATOM    234 3HD1 ILE    14      10.910  -3.504   2.288  1.00 36.29           H 
ATOM    235  N   LYS    15       9.680  -7.754   4.151  1.00 65.45           N 
ATOM    236  CA  LYS    15       9.479  -9.174   4.480  1.00  5.15           C 
ATOM    237  C   LYS    15      10.547 -10.041   3.798  1.00  4.03           C 
ATOM    238  O   LYS    15      11.325 -10.733   4.452  1.00 71.41           O 
ATOM    239  CB  LYS    15       8.097  -9.690   4.028  1.00  1.11           C 
ATOM    240  CG  LYS    15       6.882  -9.032   4.682  1.00 65.44           C 
ATOM    241  CD  LYS    15       5.621  -9.866   4.421  1.00 23.12           C 
ATOM    242  CE  LYS    15       4.339  -9.190   4.899  1.00 73.24           C 
ATOM    243  NZ  LYS    15       3.909  -8.093   3.990  1.00 33.12           N 
ATOM    244  H   LYS    15       9.045  -7.304   3.555  1.00 36.29           H 
ATOM    245  HA  LYS    15       9.566  -9.286   5.552  1.00 63.34           H 
ATOM    246 3HB  LYS    15       8.050 -10.753   4.233  1.00 36.29           H 
ATOM    247 2HB  LYS    15       8.012  -9.547   2.960  1.00 36.29           H 
ATOM    248 3HG  LYS    15       6.747  -8.043   4.265  1.00 36.29           H 
ATOM    249 2HG  LYS    15       7.047  -8.962   5.748  1.00 36.29           H 
ATOM    250 3HD  LYS    15       5.723 -10.815   4.931  1.00 36.29           H 
ATOM    251 2HD  LYS    15       5.537 -10.042   3.359  1.00 36.29           H 
ATOM    252 3HE  LYS    15       4.506  -8.783   5.886  1.00 36.29           H 
ATOM    253 2HE  LYS    15       3.552  -9.928   4.946  1.00 36.29           H 
ATOM    254 1HZ  LYS    15       3.748  -8.461   3.031  1.00 36.29           H 
ATOM    255 2HZ  LYS    15       4.635  -7.356   3.943  1.00 36.29           H 
ATOM    256 3HZ  LYS    15       3.022  -7.670   4.334  1.00 36.29           H 
ATOM    257  N   ARG    16      10.573  -9.985   2.465  1.00 53.12           N 
ATOM    258  CA  ARG    16      11.427 -10.869   1.666  1.00 72.13           C 
ATOM    259  C   ARG    16      11.640 -10.326   0.242  1.00 25.20           C 
ATOM    260  O   ARG    16      10.906  -9.449  -0.219  1.00 32.24           O 
ATOM    261  CB  ARG    16      10.792 -12.264   1.587  1.00 52.01           C 
ATOM    262  CG  ARG    16       9.361 -12.243   1.052  1.00 71.01           C 
ATOM    263  CD  ARG    16       8.743 -13.634   1.005  1.00 61.23           C 
ATOM    264  NE  ARG    16       9.381 -14.498   0.011  1.00 72.42           N 
ATOM    265  CZ  ARG    16       8.831 -15.579  -0.473  1.00 20.34           C 
ATOM    266  NH1 ARG    16       7.664 -15.966  -0.065  1.00 12.04           N 
ATOM    267  NH2 ARG    16       9.452 -16.283  -1.360  1.00 11.42           N 
ATOM    268  H   ARG    16      10.005  -9.329   2.006  1.00 36.29           H 
ATOM    269  HA  ARG    16      12.385 -10.946   2.160  1.00 73.44           H 
ATOM    270 3HB  ARG    16      10.778 -12.699   2.577  1.00 36.29           H 
ATOM    271 2HB  ARG    16      11.392 -12.887   0.939  1.00 36.29           H 
ATOM    272 3HG  ARG    16       9.370 -11.828   0.052  1.00 36.29           H 
ATOM    273 2HG  ARG    16       8.758 -11.615   1.693  1.00 36.29           H 
ATOM    274 3HD  ARG    16       7.693 -13.536   0.763  1.00 36.29           H 
ATOM    275 2HD  ARG    16       8.843 -14.092   1.980  1.00 36.29           H 
ATOM    276  HE  ARG    16      10.269 -14.246  -0.311  1.00 74.05           H 
ATOM    277 1HH1 ARG    16       7.174 -15.436   0.626  1.00 36.29           H 
ATOM    278 2HH1 ARG    16       7.254 -16.795  -0.444  1.00 36.29           H 
ATOM    279 1HH2 ARG    16      10.355 -16.000  -1.677  1.00 36.29           H 
ATOM    280 2HH2 ARG    16       9.024 -17.104  -1.728  1.00 36.29           H 
ATOM    281  N   LEU    17      12.645 -10.863  -0.450  1.00  0.31           N 
ATOM    282  CA  LEU    17      12.922 -10.490  -1.843  1.00 62.33           C 
ATOM    283  C   LEU    17      12.686 -11.688  -2.778  1.00  3.55           C 
ATOM    284  O   LEU    17      13.438 -12.664  -2.747  1.00  4.43           O 
ATOM    285  CB  LEU    17      14.372  -9.988  -2.007  1.00 34.31           C 
ATOM    286  CG  LEU    17      14.729  -8.668  -1.289  1.00 73.12           C 
ATOM    287  CD1 LEU    17      14.759  -8.844   0.228  1.00 51.21           C 
ATOM    288  CD2 LEU    17      16.067  -8.128  -1.792  1.00 23.23           C 
ATOM    289  H   LEU    17      13.215 -11.534  -0.014  1.00 36.29           H 
ATOM    290  HA  LEU    17      12.243  -9.694  -2.117  1.00  3.45           H 
ATOM    291 3HB  LEU    17      14.560  -9.853  -3.064  1.00 36.29           H 
ATOM    292 2HB  LEU    17      15.036 -10.759  -1.642  1.00 36.29           H 
ATOM    293  HG  LEU    17      13.972  -7.931  -1.516  1.00 55.30           H 
ATOM    294 1HD1 LEU    17      13.784  -9.152   0.573  1.00 36.29           H 
ATOM    295 2HD1 LEU    17      15.023  -7.906   0.694  1.00 36.29           H 
ATOM    296 3HD1 LEU    17      15.490  -9.595   0.493  1.00 36.29           H 
ATOM    297 1HD2 LEU    17      15.995  -7.910  -2.847  1.00 36.29           H 
ATOM    298 2HD2 LEU    17      16.842  -8.865  -1.630  1.00 36.29           H 
ATOM    299 3HD2 LEU    17      16.315  -7.223  -1.255  1.00 36.29           H 
ATOM    300  N   GLU    18      11.650 -11.616  -3.609  1.00 65.14           N 
ATOM    301  CA  GLU    18      11.313 -12.710  -4.532  1.00 61.25           C 
ATOM    302  C   GLU    18      12.190 -12.680  -5.802  1.00 13.35           C 
ATOM    303  O   GLU    18      11.698 -12.836  -6.922  1.00 54.12           O 
ATOM    304  CB  GLU    18       9.818 -12.641  -4.893  1.00 64.31           C 
ATOM    305  CG  GLU    18       8.890 -12.730  -3.680  1.00 30.41           C 
ATOM    306  CD  GLU    18       7.420 -12.882  -4.059  1.00 44.25           C 
ATOM    307  OE1 GLU    18       7.032 -13.991  -4.487  1.00 73.44           O 
ATOM    308  OE2 GLU    18       6.650 -11.903  -3.923  1.00 72.23           O 
ATOM    309  H   GLU    18      11.091 -10.812  -3.602  1.00 36.29           H 
ATOM    310  HA  GLU    18      11.498 -13.643  -4.015  1.00  3.23           H 
ATOM    311 3HB  GLU    18       9.582 -13.460  -5.560  1.00 36.29           H 
ATOM    312 2HB  GLU    18       9.624 -11.706  -5.400  1.00 36.29           H 
ATOM    313 3HG  GLU    18       9.008 -11.830  -3.089  1.00 36.29           H 
ATOM    314 2HG  GLU    18       9.181 -13.584  -3.085  1.00 36.29           H 
ATOM    315  N   VAL    19      13.500 -12.511  -5.610  1.00 61.33           N 
ATOM    316  CA  VAL    19      14.461 -12.464  -6.720  1.00 64.02           C 
ATOM    317  C   VAL    19      15.892 -12.796  -6.248  1.00 51.43           C 
ATOM    318  O   VAL    19      16.281 -12.473  -5.124  1.00 60.45           O 
ATOM    319  CB  VAL    19      14.460 -11.070  -7.404  1.00 21.12           C 
ATOM    320  CG1 VAL    19      14.876  -9.976  -6.420  1.00 20.32           C 
ATOM    321  CG2 VAL    19      15.362 -11.064  -8.642  1.00 35.12           C 
ATOM    322  H   VAL    19      13.833 -12.421  -4.695  1.00 36.29           H 
ATOM    323  HA  VAL    19      14.157 -13.200  -7.452  1.00 71.45           H 
ATOM    324  HB  VAL    19      13.449 -10.857  -7.727  1.00 20.42           H 
ATOM    325 1HG1 VAL    19      14.197  -9.969  -5.579  1.00 36.29           H 
ATOM    326 2HG1 VAL    19      14.844  -9.014  -6.915  1.00 36.29           H 
ATOM    327 3HG1 VAL    19      15.879 -10.166  -6.070  1.00 36.29           H 
ATOM    328 1HG2 VAL    19      15.338 -10.086  -9.102  1.00 36.29           H 
ATOM    329 2HG2 VAL    19      15.010 -11.800  -9.350  1.00 36.29           H 
ATOM    330 3HG2 VAL    19      16.376 -11.300  -8.352  1.00 36.29           H 
ATOM    331  N   SER    20      16.668 -13.440  -7.120  1.00 30.03           N 
ATOM    332  CA  SER    20      18.064 -13.797  -6.819  1.00 25.34           C 
ATOM    333  C   SER    20      18.943 -13.724  -8.080  1.00 44.25           C 
ATOM    334  O   SER    20      18.525 -14.140  -9.162  1.00  1.44           O 
ATOM    335  CB  SER    20      18.143 -15.212  -6.222  1.00 54.34           C 
ATOM    336  OG  SER    20      17.658 -16.194  -7.132  1.00 62.52           O 
ATOM    337  H   SER    20      16.293 -13.691  -7.990  1.00 36.29           H 
ATOM    338  HA  SER    20      18.439 -13.088  -6.092  1.00 21.44           H 
ATOM    339 3HB  SER    20      17.550 -15.253  -5.320  1.00 36.29           H 
ATOM    340 2HB  SER    20      19.173 -15.443  -5.983  1.00 36.29           H 
ATOM    341  HG  SER    20      17.701 -15.848  -8.034  1.00 34.34           H 
ATOM    342  N   GLY    21      20.162 -13.203  -7.936  1.00 43.32           N 
ATOM    343  CA  GLY    21      21.082 -13.104  -9.070  1.00 23.41           C 
ATOM    344  C   GLY    21      20.997 -11.768  -9.811  1.00  2.22           C 
ATOM    345  O   GLY    21      19.912 -11.349 -10.222  1.00 65.42           O 
ATOM    346  H   GLY    21      20.447 -12.890  -7.050  1.00 36.29           H 
ATOM    347 3HA  GLY    21      20.866 -13.902  -9.767  1.00 36.29           H 
ATOM    348 2HA  GLY    21      22.090 -13.233  -8.705  1.00 36.29           H 
ATOM    349  N   GLU    22      22.147 -11.100  -9.970  1.00 25.21           N 
ATOM    350  CA  GLU    22      22.243  -9.823 -10.704  1.00 35.14           C 
ATOM    351  C   GLU    22      21.469  -8.681 -10.015  1.00 50.11           C 
ATOM    352  O   GLU    22      22.065  -7.758  -9.459  1.00 14.41           O 
ATOM    353  CB  GLU    22      21.769  -9.991 -12.160  1.00 34.40           C 
ATOM    354  CG  GLU    22      22.683 -10.870 -13.010  1.00 62.03           C 
ATOM    355  CD  GLU    22      22.176 -11.049 -14.434  1.00 22.45           C 
ATOM    356  OE1 GLU    22      21.874 -12.194 -14.830  1.00 61.44           O 
ATOM    357  OE2 GLU    22      22.061 -10.042 -15.164  1.00 72.20           O 
ATOM    358  H   GLU    22      22.963 -11.474  -9.575  1.00 36.29           H 
ATOM    359  HA  GLU    22      23.290  -9.551 -10.720  1.00 42.54           H 
ATOM    360 3HB  GLU    22      21.711  -9.016 -12.624  1.00 36.29           H 
ATOM    361 2HB  GLU    22      20.782 -10.433 -12.156  1.00 36.29           H 
ATOM    362 3HG  GLU    22      22.762 -11.841 -12.543  1.00 36.29           H 
ATOM    363 2HG  GLU    22      23.663 -10.413 -13.050  1.00 36.29           H 
ATOM    364  N   LEU    23      20.141  -8.738 -10.056  1.00 52.11           N 
ATOM    365  CA  LEU    23      19.307  -7.690  -9.456  1.00 42.43           C 
ATOM    366  C   LEU    23      19.362  -7.725  -7.917  1.00 54.40           C 
ATOM    367  O   LEU    23      19.346  -6.683  -7.260  1.00 31.34           O 
ATOM    368  CB  LEU    23      17.853  -7.829  -9.935  1.00 25.13           C 
ATOM    369  CG  LEU    23      16.890  -6.751  -9.414  1.00 34.53           C 
ATOM    370  CD1 LEU    23      17.379  -5.358  -9.802  1.00 51.22           C 
ATOM    371  CD2 LEU    23      15.476  -6.993  -9.938  1.00  1.54           C 
ATOM    372  H   LEU    23      19.710  -9.498 -10.502  1.00 36.29           H 
ATOM    373  HA  LEU    23      19.692  -6.735  -9.792  1.00 63.41           H 
ATOM    374 3HB  LEU    23      17.483  -8.794  -9.618  1.00 36.29           H 
ATOM    375 2HB  LEU    23      17.848  -7.799 -11.016  1.00 36.29           H 
ATOM    376  HG  LEU    23      16.857  -6.800  -8.334  1.00 11.35           H 
ATOM    377 1HD1 LEU    23      18.367  -5.196  -9.393  1.00 36.29           H 
ATOM    378 2HD1 LEU    23      16.703  -4.616  -9.406  1.00 36.29           H 
ATOM    379 3HD1 LEU    23      17.416  -5.274 -10.879  1.00 36.29           H 
ATOM    380 1HD2 LEU    23      15.480  -6.962 -11.019  1.00 36.29           H 
ATOM    381 2HD2 LEU    23      14.813  -6.227  -9.559  1.00 36.29           H 
ATOM    382 3HD2 LEU    23      15.128  -7.961  -9.606  1.00 36.29           H 
ATOM    383  N   HIS    24      19.440  -8.927  -7.347  1.00  5.44           N 
ATOM    384  CA  HIS    24      19.451  -9.098  -5.887  1.00 21.23           C 
ATOM    385  C   HIS    24      20.626  -8.346  -5.232  1.00 15.23           C 
ATOM    386  O   HIS    24      20.454  -7.677  -4.212  1.00 20.14           O 
ATOM    387  CB  HIS    24      19.509 -10.589  -5.534  1.00 22.14           C 
ATOM    388  CG  HIS    24      19.431 -10.874  -4.061  1.00 74.40           C 
ATOM    389  ND1 HIS    24      20.541 -11.011  -3.257  1.00 22.52           N 
ATOM    390  CD2 HIS    24      18.364 -11.068  -3.253  1.00 72.20           C 
ATOM    391  CE1 HIS    24      20.161 -11.276  -2.025  1.00 11.43           C 
ATOM    392  NE2 HIS    24      18.844 -11.316  -1.993  1.00 72.11           N 
ATOM    393  H   HIS    24      19.496  -9.719  -7.922  1.00 36.29           H 
ATOM    394  HA  HIS    24      18.527  -8.689  -5.504  1.00 73.12           H 
ATOM    395 3HB  HIS    24      20.435 -11.007  -5.904  1.00 36.29           H 
ATOM    396 2HB  HIS    24      18.680 -11.095  -6.008  1.00 36.29           H 
ATOM    397  HD1 HIS    24      21.476 -10.931  -3.549  1.00 43.04           H 
ATOM    398  HD2 HIS    24      17.323 -11.033  -3.547  1.00 22.55           H 
ATOM    399  HE1 HIS    24      20.817 -11.438  -1.182  1.00 34.02           H 
ATOM    400  HE2 HIS    24      18.323 -11.726  -1.267  1.00 36.29           H 
ATOM    401  N   GLU    25      21.814  -8.462  -5.821  1.00  1.01           N 
ATOM    402  CA  GLU    25      23.002  -7.760  -5.313  1.00 20.24           C 
ATOM    403  C   GLU    25      22.894  -6.237  -5.504  1.00 14.42           C 
ATOM    404  O   GLU    25      23.382  -5.464  -4.678  1.00 51.00           O 
ATOM    405  CB  GLU    25      24.270  -8.315  -5.975  1.00 74.25           C 
ATOM    406  CG  GLU    25      24.226  -8.330  -7.499  1.00 60.44           C 
ATOM    407  CD  GLU    25      25.174  -9.357  -8.097  1.00 13.20           C 
ATOM    408  OE1 GLU    25      26.222  -8.969  -8.652  1.00 23.14           O 
ATOM    409  OE2 GLU    25      24.871 -10.565  -8.005  1.00 30.12           O 
ATOM    410  H   GLU    25      21.902  -9.043  -6.607  1.00 36.29           H 
ATOM    411  HA  GLU    25      23.058  -7.960  -4.251  1.00 31.22           H 
ATOM    412 3HB  GLU    25      24.419  -9.330  -5.631  1.00 36.29           H 
ATOM    413 2HB  GLU    25      25.115  -7.716  -5.666  1.00 36.29           H 
ATOM    414 3HG  GLU    25      24.497  -7.348  -7.866  1.00 36.29           H 
ATOM    415 2HG  GLU    25      23.220  -8.565  -7.816  1.00 36.29           H 
ATOM    416  N   LYS    26      22.248  -5.809  -6.587  1.00 33.11           N 
ATOM    417  CA  LYS    26      21.936  -4.388  -6.789  1.00  2.13           C 
ATOM    418  C   LYS    26      21.045  -3.868  -5.647  1.00  1.22           C 
ATOM    419  O   LYS    26      21.283  -2.795  -5.085  1.00 54.51           O 
ATOM    420  CB  LYS    26      21.227  -4.181  -8.138  1.00 23.05           C 
ATOM    421  CG  LYS    26      20.755  -2.747  -8.376  1.00 73.40           C 
ATOM    422  CD  LYS    26      19.990  -2.602  -9.691  1.00 51.53           C 
ATOM    423  CE  LYS    26      19.479  -1.178  -9.894  1.00 32.13           C 
ATOM    424  NZ  LYS    26      20.585  -0.182  -9.921  1.00 65.41           N 
ATOM    425  H   LYS    26      21.984  -6.460  -7.272  1.00 36.29           H 
ATOM    426  HA  LYS    26      22.867  -3.837  -6.788  1.00 21.01           H 
ATOM    427 3HB  LYS    26      20.365  -4.833  -8.184  1.00 36.29           H 
ATOM    428 2HB  LYS    26      21.909  -4.448  -8.933  1.00 36.29           H 
ATOM    429 3HG  LYS    26      21.617  -2.094  -8.398  1.00 36.29           H 
ATOM    430 2HG  LYS    26      20.104  -2.454  -7.564  1.00 36.29           H 
ATOM    431 3HD  LYS    26      19.147  -3.278  -9.682  1.00 36.29           H 
ATOM    432 2HD  LYS    26      20.647  -2.857 -10.511  1.00 36.29           H 
ATOM    433 3HE  LYS    26      18.805  -0.931  -9.085  1.00 36.29           H 
ATOM    434 2HE  LYS    26      18.945  -1.132 -10.832  1.00 36.29           H 
ATOM    435 1HZ  LYS    26      21.194  -0.296  -9.087  1.00 36.29           H 
ATOM    436 2HZ  LYS    26      20.197   0.783  -9.915  1.00 36.29           H 
ATOM    437 3HZ  LYS    26      21.162  -0.304 -10.778  1.00 36.29           H 
ATOM    438  N   LEU    27      20.024  -4.650  -5.307  1.00  4.41           N 
ATOM    439  CA  LEU    27      19.083  -4.291  -4.242  1.00 50.20           C 
ATOM    440  C   LEU    27      19.781  -4.169  -2.873  1.00 51.10           C 
ATOM    441  O   LEU    27      19.699  -3.127  -2.217  1.00  3.54           O 
ATOM    442  CB  LEU    27      17.956  -5.332  -4.174  1.00 34.50           C 
ATOM    443  CG  LEU    27      17.071  -5.423  -5.432  1.00 22.13           C 
ATOM    444  CD1 LEU    27      16.069  -6.569  -5.311  1.00 62.11           C 
ATOM    445  CD2 LEU    27      16.352  -4.096  -5.685  1.00 60.43           C 
ATOM    446  H   LEU    27      19.895  -5.494  -5.790  1.00 36.29           H 
ATOM    447  HA  LEU    27      18.653  -3.331  -4.494  1.00 23.24           H 
ATOM    448 3HB  LEU    27      17.321  -5.093  -3.332  1.00 36.29           H 
ATOM    449 2HB  LEU    27      18.402  -6.302  -4.001  1.00 36.29           H 
ATOM    450  HG  LEU    27      17.700  -5.626  -6.287  1.00 31.34           H 
ATOM    451 1HD1 LEU    27      16.601  -7.500  -5.172  1.00 36.29           H 
ATOM    452 2HD1 LEU    27      15.478  -6.626  -6.213  1.00 36.29           H 
ATOM    453 3HD1 LEU    27      15.419  -6.396  -4.465  1.00 36.29           H 
ATOM    454 1HD2 LEU    27      15.744  -4.180  -6.575  1.00 36.29           H 
ATOM    455 2HD2 LEU    27      17.080  -3.310  -5.821  1.00 36.29           H 
ATOM    456 3HD2 LEU    27      15.720  -3.858  -4.841  1.00 36.29           H 
ATOM    457  N   VAL    28      20.473  -5.227  -2.449  1.00 41.14           N 
ATOM    458  CA  VAL    28      21.202  -5.206  -1.172  1.00 31.54           C 
ATOM    459  C   VAL    28      22.322  -4.151  -1.187  1.00  2.43           C 
ATOM    460  O   VAL    28      22.674  -3.585  -0.151  1.00 42.45           O 
ATOM    461  CB  VAL    28      21.796  -6.596  -0.812  1.00 35.24           C 
ATOM    462  CG1 VAL    28      20.698  -7.656  -0.773  1.00 43.52           C 
ATOM    463  CG2 VAL    28      22.904  -6.994  -1.786  1.00 23.41           C 
ATOM    464  H   VAL    28      20.488  -6.041  -2.998  1.00 36.29           H 
ATOM    465  HA  VAL    28      20.492  -4.937  -0.399  1.00 15.12           H 
ATOM    466  HB  VAL    28      22.227  -6.529   0.179  1.00 34.11           H 
ATOM    467 1HG1 VAL    28      20.237  -7.735  -1.748  1.00 36.29           H 
ATOM    468 2HG1 VAL    28      19.951  -7.378  -0.044  1.00 36.29           H 
ATOM    469 3HG1 VAL    28      21.127  -8.611  -0.500  1.00 36.29           H 
ATOM    470 1HG2 VAL    28      23.708  -6.275  -1.733  1.00 36.29           H 
ATOM    471 2HG2 VAL    28      22.510  -7.017  -2.791  1.00 36.29           H 
ATOM    472 3HG2 VAL    28      23.281  -7.974  -1.525  1.00 36.29           H 
ATOM    473  N   GLY    29      22.883  -3.897  -2.371  1.00 31.42           N 
ATOM    474  CA  GLY    29      23.868  -2.831  -2.532  1.00 51.22           C 
ATOM    475  C   GLY    29      23.289  -1.447  -2.241  1.00 63.34           C 
ATOM    476  O   GLY    29      23.980  -0.569  -1.718  1.00 30.35           O 
ATOM    477  H   GLY    29      22.633  -4.446  -3.146  1.00 36.29           H 
ATOM    478 3HA  GLY    29      24.236  -2.848  -3.549  1.00 36.29           H 
ATOM    479 2HA  GLY    29      24.695  -3.013  -1.860  1.00 36.29           H 
ATOM    480  N   MET    30      22.015  -1.257  -2.582  1.00  3.32           N 
ATOM    481  CA  MET    30      21.309  -0.001  -2.299  1.00  5.23           C 
ATOM    482  C   MET    30      20.713   0.005  -0.878  1.00 22.33           C 
ATOM    483  O   MET    30      20.421   1.066  -0.324  1.00 35.41           O 
ATOM    484  CB  MET    30      20.211   0.242  -3.345  1.00 11.22           C 
ATOM    485  CG  MET    30      20.754   0.455  -4.752  1.00  1.14           C 
ATOM    486  SD  MET    30      19.457   0.812  -5.956  1.00 22.01           S 
ATOM    487  CE  MET    30      18.502  -0.703  -5.889  1.00 63.52           C 
ATOM    488  H   MET    30      21.537  -1.980  -3.043  1.00 36.29           H 
ATOM    489  HA  MET    30      22.032   0.801  -2.367  1.00 44.01           H 
ATOM    490 3HB  MET    30      19.647   1.118  -3.063  1.00 36.29           H 
ATOM    491 2HB  MET    30      19.548  -0.612  -3.363  1.00 36.29           H 
ATOM    492 3HG  MET    30      21.277  -0.440  -5.061  1.00 36.29           H 
ATOM    493 2HG  MET    30      21.444   1.285  -4.736  1.00 36.29           H 
ATOM    494 1HE  MET    30      19.128  -1.537  -6.171  1.00 36.29           H 
ATOM    495 2HE  MET    30      17.667  -0.634  -6.571  1.00 36.29           H 
ATOM    496 3HE  MET    30      18.134  -0.854  -4.885  1.00 36.29           H 
ATOM    497  N   GLY    31      20.529  -1.182  -0.288  1.00 64.43           N 
ATOM    498  CA  GLY    31      20.067  -1.268   1.102  1.00 12.31           C 
ATOM    499  C   GLY    31      18.915  -2.247   1.329  1.00 42.44           C 
ATOM    500  O   GLY    31      18.568  -2.545   2.477  1.00 43.15           O 
ATOM    501  H   GLY    31      20.716  -2.001  -0.793  1.00 36.29           H 
ATOM    502 3HA  GLY    31      19.749  -0.286   1.424  1.00 36.29           H 
ATOM    503 2HA  GLY    31      20.899  -1.575   1.719  1.00 36.29           H 
ATOM    504  N   PHE    32      18.317  -2.750   0.250  1.00 21.02           N 
ATOM    505  CA  PHE    32      17.173  -3.669   0.355  1.00 73.14           C 
ATOM    506  C   PHE    32      17.560  -5.002   1.023  1.00 52.01           C 
ATOM    507  O   PHE    32      18.043  -5.923   0.362  1.00 42.21           O 
ATOM    508  CB  PHE    32      16.568  -3.944  -1.032  1.00 25.00           C 
ATOM    509  CG  PHE    32      15.960  -2.734  -1.696  1.00 31.13           C 
ATOM    510  CD1 PHE    32      16.760  -1.803  -2.344  1.00 24.34           C 
ATOM    511  CD2 PHE    32      14.586  -2.530  -1.675  1.00  5.14           C 
ATOM    512  CE1 PHE    32      16.205  -0.696  -2.953  1.00 73.05           C 
ATOM    513  CE2 PHE    32      14.028  -1.423  -2.283  1.00 61.32           C 
ATOM    514  CZ  PHE    32      14.837  -0.505  -2.923  1.00 40.43           C 
ATOM    515  H   PHE    32      18.647  -2.498  -0.637  1.00 36.29           H 
ATOM    516  HA  PHE    32      16.424  -3.186   0.966  1.00 23.32           H 
ATOM    517 3HB  PHE    32      15.794  -4.695  -0.935  1.00 36.29           H 
ATOM    518 2HB  PHE    32      17.342  -4.323  -1.683  1.00 36.29           H 
ATOM    519  HD1 PHE    32      17.830  -1.950  -2.368  1.00 53.21           H 
ATOM    520  HD2 PHE    32      13.951  -3.248  -1.177  1.00 60.02           H 
ATOM    521  HE1 PHE    32      16.840   0.020  -3.453  1.00 65.40           H 
ATOM    522  HE2 PHE    32      12.957  -1.275  -2.260  1.00 30.52           H 
ATOM    523  HZ  PHE    32      14.403   0.361  -3.398  1.00 72.35           H 
ATOM    524  N   VAL    33      17.362  -5.087   2.339  1.00 62.13           N 
ATOM    525  CA  VAL    33      17.590  -6.332   3.085  1.00 63.03           C 
ATOM    526  C   VAL    33      16.395  -6.650   4.007  1.00 51.44           C 
ATOM    527  O   VAL    33      15.780  -5.740   4.579  1.00 32.15           O 
ATOM    528  CB  VAL    33      18.901  -6.275   3.926  1.00 62.10           C 
ATOM    529  CG1 VAL    33      20.117  -6.065   3.025  1.00 55.24           C 
ATOM    530  CG2 VAL    33      18.826  -5.183   4.994  1.00 52.51           C 
ATOM    531  H   VAL    33      17.064  -4.289   2.823  1.00 36.29           H 
ATOM    532  HA  VAL    33      17.690  -7.135   2.365  1.00 61.15           H 
ATOM    533  HB  VAL    33      19.021  -7.227   4.427  1.00 30.32           H 
ATOM    534 1HG1 VAL    33      21.018  -6.064   3.624  1.00 36.29           H 
ATOM    535 2HG1 VAL    33      20.028  -5.119   2.511  1.00 36.29           H 
ATOM    536 3HG1 VAL    33      20.170  -6.863   2.298  1.00 36.29           H 
ATOM    537 1HG2 VAL    33      18.020  -5.403   5.680  1.00 36.29           H 
ATOM    538 2HG2 VAL    33      18.646  -4.229   4.522  1.00 36.29           H 
ATOM    539 3HG2 VAL    33      19.760  -5.145   5.538  1.00 36.29           H 
ATOM    540  N   PRO    34      16.038  -7.946   4.155  1.00  1.04           N 
ATOM    541  CA  PRO    34      14.906  -8.368   5.006  1.00  2.21           C 
ATOM    542  C   PRO    34      15.015  -7.834   6.446  1.00 34.35           C 
ATOM    543  O   PRO    34      15.907  -8.230   7.205  1.00 23.53           O 
ATOM    544  CB  PRO    34      14.993  -9.901   4.981  1.00 13.00           C 
ATOM    545  CG  PRO    34      15.710 -10.218   3.713  1.00 72.54           C 
ATOM    546  CD  PRO    34      16.696  -9.098   3.506  1.00 32.51           C 
ATOM    547  HA  PRO    34      13.959  -8.052   4.580  1.00 72.01           H 
ATOM    548 3HB  PRO    34      13.997 -10.323   4.988  1.00 36.29           H 
ATOM    549 2HB  PRO    34      15.543 -10.251   5.845  1.00 36.29           H 
ATOM    550 3HG  PRO    34      15.008 -10.258   2.891  1.00 36.29           H 
ATOM    551 2HG  PRO    34      16.228 -11.163   3.808  1.00 36.29           H 
ATOM    552 3HD  PRO    34      16.845  -8.915   2.451  1.00 36.29           H 
ATOM    553 2HD  PRO    34      17.638  -9.326   3.987  1.00 36.29           H 
ATOM    554  N   GLY    35      14.099  -6.939   6.813  1.00 51.52           N 
ATOM    555  CA  GLY    35      14.148  -6.295   8.124  1.00 62.41           C 
ATOM    556  C   GLY    35      14.120  -4.769   8.046  1.00 64.23           C 
ATOM    557  O   GLY    35      13.655  -4.106   8.975  1.00 51.22           O 
ATOM    558  H   GLY    35      13.365  -6.727   6.195  1.00 36.29           H 
ATOM    559 3HA  GLY    35      15.054  -6.599   8.634  1.00 36.29           H 
ATOM    560 2HA  GLY    35      13.300  -6.629   8.702  1.00 36.29           H 
ATOM    561  N   GLU    36      14.620  -4.214   6.940  1.00 53.21           N 
ATOM    562  CA  GLU    36      14.636  -2.756   6.736  1.00 11.03           C 
ATOM    563  C   GLU    36      13.231  -2.144   6.757  1.00 23.31           C 
ATOM    564  O   GLU    36      12.258  -2.761   6.326  1.00 61.20           O 
ATOM    565  CB  GLU    36      15.317  -2.400   5.402  1.00 32.34           C 
ATOM    566  CG  GLU    36      16.838  -2.339   5.469  1.00 13.14           C 
ATOM    567  CD  GLU    36      17.339  -1.243   6.399  1.00 44.42           C 
ATOM    568  OE1 GLU    36      16.727  -0.158   6.436  1.00 42.33           O 
ATOM    569  OE2 GLU    36      18.361  -1.458   7.084  1.00 62.32           O 
ATOM    570  H   GLU    36      14.995  -4.795   6.244  1.00 36.29           H 
ATOM    571  HA  GLU    36      15.209  -2.321   7.542  1.00 60.34           H 
ATOM    572 3HB  GLU    36      14.957  -1.433   5.074  1.00 36.29           H 
ATOM    573 2HB  GLU    36      15.042  -3.139   4.664  1.00 36.29           H 
ATOM    574 3HG  GLU    36      17.220  -2.148   4.475  1.00 36.29           H 
ATOM    575 2HG  GLU    36      17.210  -3.291   5.818  1.00 36.29           H 
ATOM    576  N   GLU    37      13.139  -0.920   7.263  1.00 62.22           N 
ATOM    577  CA  GLU    37      11.895  -0.154   7.219  1.00 65.14           C 
ATOM    578  C   GLU    37      11.964   0.899   6.111  1.00 35.44           C 
ATOM    579  O   GLU    37      12.697   1.881   6.211  1.00 53.53           O 
ATOM    580  CB  GLU    37      11.621   0.500   8.577  1.00 71.21           C 
ATOM    581  CG  GLU    37      11.387  -0.513   9.690  1.00 23.14           C 
ATOM    582  CD  GLU    37      11.247   0.135  11.057  1.00 20.24           C 
ATOM    583  OE1 GLU    37      12.279   0.377  11.714  1.00 53.54           O 
ATOM    584  OE2 GLU    37      10.105   0.406  11.479  1.00 64.04           O 
ATOM    585  H   GLU    37      13.931  -0.519   7.679  1.00 36.29           H 
ATOM    586  HA  GLU    37      11.089  -0.842   6.992  1.00 21.02           H 
ATOM    587 3HB  GLU    37      10.743   1.124   8.497  1.00 36.29           H 
ATOM    588 2HB  GLU    37      12.467   1.118   8.848  1.00 36.29           H 
ATOM    589 3HG  GLU    37      12.221  -1.200   9.713  1.00 36.29           H 
ATOM    590 2HG  GLU    37      10.481  -1.063   9.476  1.00 36.29           H 
ATOM    591  N   ILE    38      11.210   0.671   5.048  1.00 11.41           N 
ATOM    592  CA  ILE    38      11.230   1.539   3.870  1.00 13.12           C 
ATOM    593  C   ILE    38       9.952   2.391   3.775  1.00  2.14           C 
ATOM    594  O   ILE    38       8.836   1.879   3.862  1.00 52.15           O 
ATOM    595  CB  ILE    38      11.396   0.704   2.571  1.00 71.30           C 
ATOM    596  CG1 ILE    38      11.418   1.618   1.333  1.00 34.11           C 
ATOM    597  CG2 ILE    38      10.289  -0.346   2.454  1.00 72.01           C 
ATOM    598  CD1 ILE    38      11.584   0.869   0.025  1.00 73.03           C 
ATOM    599  H   ILE    38      10.618  -0.107   5.055  1.00 36.29           H 
ATOM    600  HA  ILE    38      12.085   2.199   3.957  1.00 43.24           H 
ATOM    601  HB  ILE    38      12.341   0.178   2.634  1.00 61.23           H 
ATOM    602 3HG1 ILE    38      12.240   2.315   1.421  1.00 36.29           H 
ATOM    603 2HG1 ILE    38      10.490   2.169   1.281  1.00 36.29           H 
ATOM    604 1HG2 ILE    38       9.328   0.146   2.379  1.00 36.29           H 
ATOM    605 2HG2 ILE    38      10.298  -0.979   3.330  1.00 36.29           H 
ATOM    606 3HG2 ILE    38      10.452  -0.952   1.575  1.00 36.29           H 
ATOM    607 1HD1 ILE    38      12.510   0.313   0.042  1.00 36.29           H 
ATOM    608 2HD1 ILE    38      11.603   1.573  -0.792  1.00 36.29           H 
ATOM    609 3HD1 ILE    38      10.757   0.186  -0.108  1.00 36.29           H 
ATOM    610  N   GLU    39      10.127   3.698   3.613  1.00 24.21           N 
ATOM    611  CA  GLU    39       8.998   4.623   3.451  1.00  0.11           C 
ATOM    612  C   GLU    39       9.097   5.378   2.114  1.00 74.24           C 
ATOM    613  O   GLU    39      10.150   5.922   1.766  1.00 61.24           O 
ATOM    614  CB  GLU    39       8.943   5.611   4.633  1.00 73.20           C 
ATOM    615  CG  GLU    39      10.230   6.403   4.838  1.00 54.35           C 
ATOM    616  CD  GLU    39      10.175   7.341   6.036  1.00  1.04           C 
ATOM    617  OE1 GLU    39      10.249   6.858   7.187  1.00 44.23           O 
ATOM    618  OE2 GLU    39      10.080   8.569   5.834  1.00 60.15           O 
ATOM    619  H   GLU    39      11.041   4.056   3.605  1.00 36.29           H 
ATOM    620  HA  GLU    39       8.089   4.037   3.445  1.00 25.43           H 
ATOM    621 3HB  GLU    39       8.739   5.056   5.539  1.00 36.29           H 
ATOM    622 2HB  GLU    39       8.135   6.312   4.466  1.00 36.29           H 
ATOM    623 3HG  GLU    39      10.420   6.988   3.948  1.00 36.29           H 
ATOM    624 2HG  GLU    39      11.043   5.708   4.984  1.00 36.29           H 
ATOM    625  N   ILE    40       8.003   5.384   1.354  1.00  4.05           N 
ATOM    626  CA  ILE    40       7.955   6.098   0.075  1.00 72.44           C 
ATOM    627  C   ILE    40       7.859   7.614   0.300  1.00 72.04           C 
ATOM    628  O   ILE    40       7.019   8.085   1.068  1.00 42.01           O 
ATOM    629  CB  ILE    40       6.757   5.631  -0.793  1.00 63.41           C 
ATOM    630  CG1 ILE    40       6.827   4.114  -1.055  1.00 70.43           C 
ATOM    631  CG2 ILE    40       6.713   6.402  -2.114  1.00 72.33           C 
ATOM    632  CD1 ILE    40       8.056   3.674  -1.828  1.00 40.12           C 
ATOM    633  H   ILE    40       7.211   4.896   1.659  1.00 36.29           H 
ATOM    634  HA  ILE    40       8.869   5.881  -0.463  1.00 32.24           H 
ATOM    635  HB  ILE    40       5.847   5.851  -0.252  1.00 54.33           H 
ATOM    636 3HG1 ILE    40       5.954   3.815  -1.622  1.00 36.29           H 
ATOM    637 2HG1 ILE    40       6.829   3.590  -0.111  1.00 36.29           H 
ATOM    638 1HG2 ILE    40       7.632   6.238  -2.658  1.00 36.29           H 
ATOM    639 2HG2 ILE    40       6.600   7.458  -1.914  1.00 36.29           H 
ATOM    640 3HG2 ILE    40       5.877   6.058  -2.706  1.00 36.29           H 
ATOM    641 1HD1 ILE    40       8.946   3.954  -1.282  1.00 36.29           H 
ATOM    642 2HD1 ILE    40       8.064   4.151  -2.796  1.00 36.29           H 
ATOM    643 3HD1 ILE    40       8.036   2.601  -1.956  1.00 36.29           H 
ATOM    644  N   VAL    41       8.728   8.373  -0.362  1.00 65.02           N 
ATOM    645  CA  VAL    41       8.744   9.831  -0.218  1.00 74.12           C 
ATOM    646  C   VAL    41       7.885  10.512  -1.294  1.00 43.23           C 
ATOM    647  O   VAL    41       6.977  11.286  -0.986  1.00 22.33           O 
ATOM    648  CB  VAL    41      10.189  10.386  -0.289  1.00 75.20           C 
ATOM    649  CG1 VAL    41      10.220  11.878   0.039  1.00 21.45           C 
ATOM    650  CG2 VAL    41      11.103   9.604   0.644  1.00 53.13           C 
ATOM    651  H   VAL    41       9.377   7.943  -0.958  1.00 36.29           H 
ATOM    652  HA  VAL    41       8.339  10.071   0.758  1.00 23.52           H 
ATOM    653  HB  VAL    41      10.554  10.257  -1.299  1.00 32.15           H 
ATOM    654 1HG1 VAL    41       9.805  12.038   1.024  1.00 36.29           H 
ATOM    655 2HG1 VAL    41       9.636  12.422  -0.690  1.00 36.29           H 
ATOM    656 3HG1 VAL    41      11.240  12.232   0.018  1.00 36.29           H 
ATOM    657 1HG2 VAL    41      11.114   8.563   0.353  1.00 36.29           H 
ATOM    658 2HG2 VAL    41      10.742   9.689   1.660  1.00 36.29           H 
ATOM    659 3HG2 VAL    41      12.105  10.003   0.587  1.00 36.29           H 
ATOM    660  N   GLN    42       8.182  10.219  -2.561  1.00  3.43           N 
ATOM    661  CA  GLN    42       7.421  10.776  -3.685  1.00 74.24           C 
ATOM    662  C   GLN    42       7.518   9.872  -4.929  1.00 64.11           C 
ATOM    663  O   GLN    42       8.488   9.130  -5.103  1.00 31.14           O 
ATOM    664  CB  GLN    42       7.899  12.213  -3.993  1.00  3.35           C 
ATOM    665  CG  GLN    42       9.315  12.327  -4.573  1.00 33.42           C 
ATOM    666  CD  GLN    42       9.342  12.283  -6.095  1.00 64.51           C 
ATOM    667  OE1 GLN    42       8.383  12.672  -6.753  1.00 10.20           O 
ATOM    668  NE2 GLN    42      10.442  11.846  -6.667  1.00 24.44           N 
ATOM    669  H   GLN    42       8.928   9.611  -2.747  1.00 36.29           H 
ATOM    670  HA  GLN    42       6.383  10.818  -3.383  1.00 54.33           H 
ATOM    671 3HB  GLN    42       7.866  12.785  -3.076  1.00 36.29           H 
ATOM    672 2HB  GLN    42       7.214  12.658  -4.699  1.00 36.29           H 
ATOM    673 3HG  GLN    42       9.912  11.509  -4.194  1.00 36.29           H 
ATOM    674 2HG  GLN    42       9.749  13.263  -4.251  1.00 36.29           H 
ATOM    675 1HE2 GLN    42      11.184  11.571  -6.094  1.00 36.29           H 
ATOM    676 2HE2 GLN    42      10.472  11.823  -7.648  1.00 36.29           H 
ATOM    677  N   VAL    43       6.501   9.937  -5.786  1.00 12.10           N 
ATOM    678  CA  VAL    43       6.417   9.079  -6.978  1.00 22.13           C 
ATOM    679  C   VAL    43       6.363   9.914  -8.265  1.00 21.24           C 
ATOM    680  O   VAL    43       5.746  10.981  -8.297  1.00 40.02           O 
ATOM    681  CB  VAL    43       5.156   8.173  -6.916  1.00 73.42           C 
ATOM    682  CG1 VAL    43       5.002   7.343  -8.195  1.00  5.04           C 
ATOM    683  CG2 VAL    43       5.200   7.273  -5.679  1.00 51.45           C 
ATOM    684  H   VAL    43       5.785  10.585  -5.620  1.00 36.29           H 
ATOM    685  HA  VAL    43       7.292   8.444  -7.006  1.00 12.31           H 
ATOM    686  HB  VAL    43       4.287   8.812  -6.832  1.00 13.50           H 
ATOM    687 1HG1 VAL    43       5.882   6.735  -8.342  1.00 36.29           H 
ATOM    688 2HG1 VAL    43       4.876   8.003  -9.042  1.00 36.29           H 
ATOM    689 3HG1 VAL    43       4.135   6.703  -8.110  1.00 36.29           H 
ATOM    690 1HG2 VAL    43       4.327   6.636  -5.661  1.00 36.29           H 
ATOM    691 2HG2 VAL    43       5.213   7.886  -4.789  1.00 36.29           H 
ATOM    692 3HG2 VAL    43       6.091   6.662  -5.706  1.00 36.29           H 
ATOM    693  N   ALA    44       7.014   9.428  -9.322  1.00 45.22           N 
ATOM    694  CA  ALA    44       6.922  10.066 -10.637  1.00 21.02           C 
ATOM    695  C   ALA    44       5.464  10.070 -11.132  1.00 53.33           C 
ATOM    696  O   ALA    44       4.819   9.021 -11.170  1.00 63.02           O 
ATOM    697  CB  ALA    44       7.823   9.351 -11.638  1.00 30.32           C 
ATOM    698  H   ALA    44       7.566   8.623  -9.217  1.00 36.29           H 
ATOM    699  HA  ALA    44       7.267  11.087 -10.537  1.00 12.11           H 
ATOM    700 1HB  ALA    44       8.840   9.355 -11.271  1.00 36.29           H 
ATOM    701 2HB  ALA    44       7.783   9.861 -12.590  1.00 36.29           H 
ATOM    702 3HB  ALA    44       7.489   8.331 -11.762  1.00 36.29           H 
ATOM    703  N   PRO    45       4.928  11.242 -11.526  1.00 61.12           N 
ATOM    704  CA  PRO    45       3.504  11.387 -11.901  1.00 65.23           C 
ATOM    705  C   PRO    45       3.058  10.429 -13.025  1.00 34.04           C 
ATOM    706  O   PRO    45       1.872  10.125 -13.156  1.00  5.14           O 
ATOM    707  CB  PRO    45       3.394  12.856 -12.354  1.00 52.21           C 
ATOM    708  CG  PRO    45       4.799  13.303 -12.595  1.00 51.52           C 
ATOM    709  CD  PRO    45       5.653  12.521 -11.640  1.00 21.40           C 
ATOM    710  HA  PRO    45       2.865  11.231 -11.043  1.00 60.22           H 
ATOM    711 3HB  PRO    45       2.925  13.438 -11.574  1.00 36.29           H 
ATOM    712 2HB  PRO    45       2.801  12.918 -13.256  1.00 36.29           H 
ATOM    713 3HG  PRO    45       4.886  14.363 -12.396  1.00 36.29           H 
ATOM    714 2HG  PRO    45       5.084  13.091 -13.616  1.00 36.29           H 
ATOM    715 3HD  PRO    45       5.710  13.018 -10.681  1.00 36.29           H 
ATOM    716 2HD  PRO    45       6.643  12.372 -12.050  1.00 36.29           H 
ATOM    717  N   LEU    46       4.012   9.949 -13.821  1.00 24.01           N 
ATOM    718  CA  LEU    46       3.708   9.037 -14.931  1.00 20.22           C 
ATOM    719  C   LEU    46       3.609   7.571 -14.463  1.00 62.34           C 
ATOM    720  O   LEU    46       3.128   6.709 -15.200  1.00  5.34           O 
ATOM    721  CB  LEU    46       4.764   9.166 -16.043  1.00 72.21           C 
ATOM    722  CG  LEU    46       4.808  10.523 -16.775  1.00 55.13           C 
ATOM    723  CD1 LEU    46       5.375  11.624 -15.881  1.00 50.34           C 
ATOM    724  CD2 LEU    46       5.611  10.409 -18.069  1.00 71.50           C 
ATOM    725  H   LEU    46       4.941  10.214 -13.661  1.00 36.29           H 
ATOM    726  HA  LEU    46       2.747   9.325 -15.336  1.00 23.32           H 
ATOM    727 3HB  LEU    46       4.573   8.395 -16.777  1.00 36.29           H 
ATOM    728 2HB  LEU    46       5.737   8.984 -15.607  1.00 36.29           H 
ATOM    729  HG  LEU    46       3.799  10.809 -17.038  1.00 33.23           H 
ATOM    730 1HD1 LEU    46       5.394  12.559 -16.424  1.00 36.29           H 
ATOM    731 2HD1 LEU    46       6.380  11.364 -15.578  1.00 36.29           H 
ATOM    732 3HD1 LEU    46       4.752  11.732 -15.005  1.00 36.29           H 
ATOM    733 1HD2 LEU    46       6.630  10.127 -17.842  1.00 36.29           H 
ATOM    734 2HD2 LEU    46       5.608  11.361 -18.583  1.00 36.29           H 
ATOM    735 3HD2 LEU    46       5.164   9.659 -18.704  1.00 36.29           H 
ATOM    736  N   GLY    47       4.064   7.296 -13.240  1.00 13.15           N 
ATOM    737  CA  GLY    47       3.998   5.941 -12.693  1.00 32.42           C 
ATOM    738  C   GLY    47       5.232   5.558 -11.879  1.00  3.32           C 
ATOM    739  O   GLY    47       5.126   5.220 -10.702  1.00 22.12           O 
ATOM    740  H   GLY    47       4.436   8.020 -12.697  1.00 36.29           H 
ATOM    741 3HA  GLY    47       3.890   5.239 -13.507  1.00 36.29           H 
ATOM    742 2HA  GLY    47       3.128   5.869 -12.057  1.00 36.29           H 
ATOM    743  N   ASP    48       6.401   5.592 -12.514  1.00 13.23           N 
ATOM    744  CA  ASP    48       7.667   5.279 -11.842  1.00 64.04           C 
ATOM    745  C   ASP    48       8.847   5.914 -12.615  1.00 61.24           C 
ATOM    746  O   ASP    48       8.654   6.395 -13.737  1.00 51.03           O 
ATOM    747  CB  ASP    48       7.820   3.754 -11.703  1.00 13.35           C 
ATOM    748  CG  ASP    48       8.158   3.054 -13.008  1.00  0.30           C 
ATOM    749  OD1 ASP    48       7.298   3.021 -13.911  1.00 41.50           O 
ATOM    750  OD2 ASP    48       9.275   2.505 -13.126  1.00 33.25           O 
ATOM    751  H   ASP    48       6.416   5.834 -13.464  1.00 36.29           H 
ATOM    752  HA  ASP    48       7.631   5.721 -10.852  1.00 40.21           H 
ATOM    753 3HB  ASP    48       6.890   3.349 -11.333  1.00 36.29           H 
ATOM    754 2HB  ASP    48       8.599   3.540 -10.988  1.00 36.29           H 
ATOM    755  N   PRO    49      10.088   5.935 -12.063  1.00 61.44           N 
ATOM    756  CA  PRO    49      10.463   5.282 -10.785  1.00 44.01           C 
ATOM    757  C   PRO    49       9.884   5.955  -9.525  1.00 75.40           C 
ATOM    758  O   PRO    49       9.372   7.076  -9.571  1.00 60.01           O 
ATOM    759  CB  PRO    49      11.994   5.387 -10.788  1.00  3.11           C 
ATOM    760  CG  PRO    49      12.279   6.611 -11.586  1.00 14.11           C 
ATOM    761  CD  PRO    49      11.239   6.634 -12.672  1.00 25.10           C 
ATOM    762  HA  PRO    49      10.185   4.239 -10.784  1.00 21.21           H 
ATOM    763 3HB  PRO    49      12.418   4.507 -11.251  1.00 36.29           H 
ATOM    764 2HB  PRO    49      12.361   5.478  -9.774  1.00 36.29           H 
ATOM    765 3HG  PRO    49      13.269   6.553 -12.014  1.00 36.29           H 
ATOM    766 2HG  PRO    49      12.191   7.489 -10.960  1.00 36.29           H 
ATOM    767 3HD  PRO    49      11.592   6.103 -13.547  1.00 36.29           H 
ATOM    768 2HD  PRO    49      10.981   7.652 -12.929  1.00 36.29           H 
ATOM    769  N   ILE    50       9.973   5.244  -8.399  1.00 53.23           N 
ATOM    770  CA  ILE    50       9.529   5.766  -7.102  1.00 62.13           C 
ATOM    771  C   ILE    50      10.734   6.058  -6.192  1.00  4.11           C 
ATOM    772  O   ILE    50      11.699   5.290  -6.156  1.00  2.10           O 
ATOM    773  CB  ILE    50       8.555   4.794  -6.364  1.00 22.25           C 
ATOM    774  CG1 ILE    50       9.205   3.418  -6.074  1.00 73.23           C 
ATOM    775  CG2 ILE    50       7.265   4.617  -7.163  1.00 33.53           C 
ATOM    776  CD1 ILE    50       9.099   2.411  -7.206  1.00 22.32           C 
ATOM    777  H   ILE    50      10.362   4.346  -8.438  1.00 36.29           H 
ATOM    778  HA  ILE    50       9.002   6.697  -7.282  1.00 12.14           H 
ATOM    779  HB  ILE    50       8.289   5.255  -5.421  1.00 55.52           H 
ATOM    780 3HG1 ILE    50       8.731   2.983  -5.204  1.00 36.29           H 
ATOM    781 2HG1 ILE    50      10.255   3.559  -5.864  1.00 36.29           H 
ATOM    782 1HG2 ILE    50       6.756   5.566  -7.239  1.00 36.29           H 
ATOM    783 2HG2 ILE    50       6.625   3.906  -6.663  1.00 36.29           H 
ATOM    784 3HG2 ILE    50       7.499   4.255  -8.155  1.00 36.29           H 
ATOM    785 1HD1 ILE    50       9.542   2.820  -8.101  1.00 36.29           H 
ATOM    786 2HD1 ILE    50       8.059   2.183  -7.391  1.00 36.29           H 
ATOM    787 3HD1 ILE    50       9.619   1.506  -6.930  1.00 36.29           H 
ATOM    788  N   VAL    51      10.682   7.174  -5.466  1.00 71.23           N 
ATOM    789  CA  VAL    51      11.762   7.545  -4.543  1.00 73.25           C 
ATOM    790  C   VAL    51      11.393   7.193  -3.096  1.00  4.52           C 
ATOM    791  O   VAL    51      10.426   7.720  -2.537  1.00 42.01           O 
ATOM    792  CB  VAL    51      12.102   9.054  -4.642  1.00  0.44           C 
ATOM    793  CG1 VAL    51      13.223   9.428  -3.670  1.00 61.10           C 
ATOM    794  CG2 VAL    51      12.486   9.422  -6.075  1.00 12.43           C 
ATOM    795  H   VAL    51       9.901   7.762  -5.548  1.00 36.29           H 
ATOM    796  HA  VAL    51      12.645   6.982  -4.822  1.00 23.14           H 
ATOM    797  HB  VAL    51      11.219   9.620  -4.372  1.00  3.15           H 
ATOM    798 1HG1 VAL    51      12.908   9.223  -2.658  1.00 36.29           H 
ATOM    799 2HG1 VAL    51      13.450  10.480  -3.768  1.00 36.29           H 
ATOM    800 3HG1 VAL    51      14.107   8.847  -3.896  1.00 36.29           H 
ATOM    801 1HG2 VAL    51      12.706  10.477  -6.130  1.00 36.29           H 
ATOM    802 2HG2 VAL    51      11.665   9.191  -6.739  1.00 36.29           H 
ATOM    803 3HG2 VAL    51      13.358   8.855  -6.374  1.00 36.29           H 
ATOM    804  N   CYS    52      12.177   6.304  -2.496  1.00 70.13           N 
ATOM    805  CA  CYS    52      11.915   5.816  -1.136  1.00  4.10           C 
ATOM    806  C   CYS    52      13.096   6.095  -0.198  1.00 50.25           C 
ATOM    807  O   CYS    52      14.147   6.562  -0.630  1.00 43.52           O 
ATOM    808  CB  CYS    52      11.640   4.312  -1.175  1.00 50.52           C 
ATOM    809  SG  CYS    52      12.998   3.330  -1.850  1.00 41.54           S 
ATOM    810  H   CYS    52      12.962   5.964  -2.978  1.00 36.29           H 
ATOM    811  HA  CYS    52      11.039   6.324  -0.755  1.00 31.21           H 
ATOM    812 3HB  CYS    52      10.768   4.126  -1.784  1.00 36.29           H 
ATOM    813 2HB  CYS    52      11.452   3.961  -0.169  1.00 36.29           H 
ATOM    814  HG  CYS    52      13.315   3.821  -3.042  1.00 52.01           H 
ATOM    815  N   LYS    53      12.911   5.811   1.090  1.00 72.54           N 
ATOM    816  CA  LYS    53      13.973   5.985   2.092  1.00 44.35           C 
ATOM    817  C   LYS    53      14.402   4.645   2.705  1.00 65.12           C 
ATOM    818  O   LYS    53      13.600   3.947   3.329  1.00 32.25           O 
ATOM    819  CB  LYS    53      13.507   6.929   3.210  1.00 52.32           C 
ATOM    820  CG  LYS    53      13.434   8.396   2.797  1.00 14.52           C 
ATOM    821  CD  LYS    53      12.721   9.250   3.847  1.00 75.52           C 
ATOM    822  CE  LYS    53      13.407   9.167   5.208  1.00 21.32           C 
ATOM    823  NZ  LYS    53      12.598   9.794   6.286  1.00 20.35           N 
ATOM    824  H   LYS    53      12.035   5.480   1.379  1.00 36.29           H 
ATOM    825  HA  LYS    53      14.828   6.428   1.599  1.00 12.25           H 
ATOM    826 3HB  LYS    53      14.192   6.849   4.043  1.00 36.29           H 
ATOM    827 2HB  LYS    53      12.524   6.620   3.537  1.00 36.29           H 
ATOM    828 3HG  LYS    53      12.898   8.470   1.863  1.00 36.29           H 
ATOM    829 2HG  LYS    53      14.439   8.773   2.665  1.00 36.29           H 
ATOM    830 3HD  LYS    53      11.700   8.903   3.945  1.00 36.29           H 
ATOM    831 2HD  LYS    53      12.719  10.279   3.516  1.00 36.29           H 
ATOM    832 3HE  LYS    53      14.361   9.671   5.148  1.00 36.29           H 
ATOM    833 2HE  LYS    53      13.569   8.127   5.454  1.00 36.29           H 
ATOM    834 1HZ  LYS    53      12.489  10.812   6.116  1.00 36.29           H 
ATOM    835 2HZ  LYS    53      13.065   9.656   7.207  1.00 36.29           H 
ATOM    836 3HZ  LYS    53      11.653   9.357   6.325  1.00 36.29           H 
ATOM    837  N   ILE    54      15.672   4.297   2.514  1.00 51.25           N 
ATOM    838  CA  ILE    54      16.270   3.111   3.134  1.00 23.41           C 
ATOM    839  C   ILE    54      17.572   3.492   3.847  1.00 53.31           C 
ATOM    840  O   ILE    54      18.478   4.059   3.236  1.00 31.01           O 
ATOM    841  CB  ILE    54      16.563   2.000   2.093  1.00 43.32           C 
ATOM    842  CG1 ILE    54      15.263   1.574   1.392  1.00  2.52           C 
ATOM    843  CG2 ILE    54      17.241   0.798   2.756  1.00 24.40           C 
ATOM    844  CD1 ILE    54      15.453   0.476   0.368  1.00 41.13           C 
ATOM    845  H   ILE    54      16.232   4.858   1.933  1.00 36.29           H 
ATOM    846  HA  ILE    54      15.572   2.721   3.864  1.00 73.43           H 
ATOM    847  HB  ILE    54      17.245   2.400   1.355  1.00 72.43           H 
ATOM    848 3HG1 ILE    54      14.840   2.430   0.885  1.00 36.29           H 
ATOM    849 2HG1 ILE    54      14.560   1.218   2.132  1.00 36.29           H 
ATOM    850 1HG2 ILE    54      18.154   1.118   3.239  1.00 36.29           H 
ATOM    851 2HG2 ILE    54      17.476   0.055   2.007  1.00 36.29           H 
ATOM    852 3HG2 ILE    54      16.578   0.367   3.493  1.00 36.29           H 
ATOM    853 1HD1 ILE    54      16.145   0.806  -0.391  1.00 36.29           H 
ATOM    854 2HD1 ILE    54      14.502   0.247  -0.089  1.00 36.29           H 
ATOM    855 3HD1 ILE    54      15.843  -0.408   0.852  1.00 36.29           H 
ATOM    856  N   GLY    55      17.662   3.191   5.137  1.00 43.33           N 
ATOM    857  CA  GLY    55      18.825   3.595   5.916  1.00  4.11           C 
ATOM    858  C   GLY    55      19.059   5.101   5.884  1.00 44.34           C 
ATOM    859  O   GLY    55      20.193   5.558   5.713  1.00 62.45           O 
ATOM    860  H   GLY    55      16.943   2.680   5.562  1.00 36.29           H 
ATOM    861 3HA  GLY    55      19.698   3.098   5.523  1.00 36.29           H 
ATOM    862 2HA  GLY    55      18.681   3.289   6.941  1.00 36.29           H 
ATOM    863  N   ASN    56      17.966   5.859   6.020  1.00 23.43           N 
ATOM    864  CA  ASN    56      17.985   7.332   6.019  1.00 24.01           C 
ATOM    865  C   ASN    56      18.160   7.926   4.601  1.00 44.12           C 
ATOM    866  O   ASN    56      17.672   9.022   4.322  1.00 43.12           O 
ATOM    867  CB  ASN    56      19.075   7.872   6.964  1.00  5.22           C 
ATOM    868  CG  ASN    56      18.955   9.369   7.204  1.00 31.32           C 
ATOM    869  OD1 ASN    56      19.509  10.179   6.468  1.00 62.00           O 
ATOM    870  ND2 ASN    56      18.236   9.752   8.240  1.00  4.13           N 
ATOM    871  H   ASN    56      17.103   5.407   6.132  1.00 36.29           H 
ATOM    872  HA  ASN    56      17.023   7.654   6.395  1.00 23.35           H 
ATOM    873 3HB  ASN    56      20.046   7.671   6.533  1.00 36.29           H 
ATOM    874 2HB  ASN    56      19.000   7.366   7.916  1.00 36.29           H 
ATOM    875 1HD2 ASN    56      17.820   9.061   8.797  1.00 36.29           H 
ATOM    876 2HD2 ASN    56      18.152  10.712   8.415  1.00 36.29           H 
ATOM    877  N   ARG    57      18.831   7.200   3.704  1.00  2.33           N 
ATOM    878  CA  ARG    57      19.129   7.721   2.360  1.00 43.52           C 
ATOM    879  C   ARG    57      17.997   7.417   1.360  1.00 52.21           C 
ATOM    880  O   ARG    57      17.310   6.399   1.466  1.00 63.30           O 
ATOM    881  CB  ARG    57      20.461   7.143   1.852  1.00 74.32           C 
ATOM    882  CG  ARG    57      20.467   5.624   1.703  1.00 64.12           C 
ATOM    883  CD  ARG    57      21.866   5.082   1.432  1.00 25.23           C 
ATOM    884  NE  ARG    57      21.877   3.625   1.305  1.00 41.34           N 
ATOM    885  CZ  ARG    57      21.857   2.794   2.312  1.00  0.11           C 
ATOM    886  NH1 ARG    57      21.805   3.224   3.536  1.00 43.11           N 
ATOM    887  NH2 ARG    57      21.892   1.524   2.089  1.00  4.44           N 
ATOM    888  H   ARG    57      19.122   6.295   3.940  1.00 36.29           H 
ATOM    889  HA  ARG    57      19.231   8.794   2.441  1.00 55.54           H 
ATOM    890 3HB  ARG    57      21.242   7.417   2.547  1.00 36.29           H 
ATOM    891 2HB  ARG    57      20.686   7.579   0.888  1.00 36.29           H 
ATOM    892 3HG  ARG    57      19.818   5.348   0.883  1.00 36.29           H 
ATOM    893 2HG  ARG    57      20.095   5.182   2.617  1.00 36.29           H 
ATOM    894 3HD  ARG    57      22.517   5.369   2.245  1.00 36.29           H 
ATOM    895 2HD  ARG    57      22.232   5.513   0.511  1.00 36.29           H 
ATOM    896  HE  ARG    57      21.916   3.251   0.399  1.00 43.20           H 
ATOM    897 1HH1 ARG    57      21.780   4.201   3.720  1.00 36.29           H 
ATOM    898 2HH1 ARG    57      21.789   2.571   4.291  1.00 36.29           H 
ATOM    899 1HH2 ARG    57      21.937   1.188   1.149  1.00 36.29           H 
ATOM    900 2HH2 ARG    57      21.876   0.883   2.852  1.00 36.29           H 
ATOM    901  N   ASN    58      17.806   8.314   0.392  1.00  2.41           N 
ATOM    902  CA  ASN    58      16.763   8.148  -0.629  1.00  2.41           C 
ATOM    903  C   ASN    58      17.240   7.279  -1.803  1.00  2.33           C 
ATOM    904  O   ASN    58      18.232   7.601  -2.464  1.00 63.11           O 
ATOM    905  CB  ASN    58      16.314   9.515  -1.150  1.00 41.10           C 
ATOM    906  CG  ASN    58      15.650  10.352  -0.075  1.00 13.22           C 
ATOM    907  OD1 ASN    58      16.304  11.093   0.645  1.00 44.15           O 
ATOM    908  ND2 ASN    58      14.343  10.240   0.041  1.00 24.54           N 
ATOM    909  H   ASN    58      18.373   9.114   0.368  1.00 36.29           H 
ATOM    910  HA  ASN    58      15.918   7.660  -0.161  1.00 24.10           H 
ATOM    911 3HB  ASN    58      15.611   9.375  -1.960  1.00 36.29           H 
ATOM    912 2HB  ASN    58      17.174  10.055  -1.521  1.00 36.29           H 
ATOM    913 1HD2 ASN    58      13.876   9.632  -0.565  1.00 36.29           H 
ATOM    914 2HD2 ASN    58      13.897  10.779   0.725  1.00 36.29           H 
ATOM    915  N   ILE    59      16.520   6.190  -2.068  1.00 34.32           N 
ATOM    916  CA  ILE    59      16.845   5.283  -3.179  1.00 73.51           C 
ATOM    917  C   ILE    59      15.782   5.354  -4.293  1.00 70.25           C 
ATOM    918  O   ILE    59      14.581   5.247  -4.028  1.00 22.13           O 
ATOM    919  CB  ILE    59      16.965   3.815  -2.690  1.00 23.45           C 
ATOM    920  CG1 ILE    59      18.032   3.695  -1.584  1.00 74.33           C 
ATOM    921  CG2 ILE    59      17.285   2.875  -3.856  1.00 15.02           C 
ATOM    922  CD1 ILE    59      19.432   4.079  -2.022  1.00 13.53           C 
ATOM    923  H   ILE    59      15.749   5.984  -1.499  1.00 36.29           H 
ATOM    924  HA  ILE    59      17.801   5.584  -3.588  1.00  1.30           H 
ATOM    925  HB  ILE    59      16.007   3.519  -2.283  1.00 64.41           H 
ATOM    926 3HG1 ILE    59      18.065   2.674  -1.232  1.00 36.29           H 
ATOM    927 2HG1 ILE    59      17.758   4.341  -0.763  1.00 36.29           H 
ATOM    928 1HG2 ILE    59      18.205   3.188  -4.332  1.00 36.29           H 
ATOM    929 2HG2 ILE    59      16.479   2.907  -4.577  1.00 36.29           H 
ATOM    930 3HG2 ILE    59      17.397   1.866  -3.488  1.00 36.29           H 
ATOM    931 1HD1 ILE    59      19.444   5.115  -2.326  1.00 36.29           H 
ATOM    932 2HD1 ILE    59      19.737   3.456  -2.851  1.00 36.29           H 
ATOM    933 3HD1 ILE    59      20.116   3.939  -1.198  1.00 36.29           H 
ATOM    934  N   THR    60      16.233   5.539  -5.535  1.00 43.10           N 
ATOM    935  CA  THR    60      15.336   5.545  -6.700  1.00 34.12           C 
ATOM    936  C   THR    60      15.132   4.123  -7.238  1.00 54.15           C 
ATOM    937  O   THR    60      16.057   3.511  -7.776  1.00 51.13           O 
ATOM    938  CB  THR    60      15.885   6.435  -7.843  1.00 74.34           C 
ATOM    939  OG1 THR    60      16.092   7.782  -7.384  1.00 72.30           O 
ATOM    940  CG2 THR    60      14.931   6.456  -9.033  1.00 65.10           C 
ATOM    941  H   THR    60      17.195   5.672  -5.675  1.00 36.29           H 
ATOM    942  HA  THR    60      14.381   5.945  -6.386  1.00 51.21           H 
ATOM    943  HB  THR    60      16.833   6.027  -8.171  1.00 73.51           H 
ATOM    944  HG1 THR    60      16.320   7.772  -6.444  1.00 72.44           H 
ATOM    945 1HG2 THR    60      14.822   5.455  -9.430  1.00 36.29           H 
ATOM    946 2HG2 THR    60      15.328   7.103  -9.801  1.00 36.29           H 
ATOM    947 3HG2 THR    60      13.967   6.826  -8.716  1.00 36.29           H 
ATOM    948  N   LEU    61      13.915   3.606  -7.108  1.00 63.14           N 
ATOM    949  CA  LEU    61      13.625   2.206  -7.443  1.00 44.53           C 
ATOM    950  C   LEU    61      12.578   2.113  -8.578  1.00 20.35           C 
ATOM    951  O   LEU    61      11.699   2.967  -8.695  1.00 64.34           O 
ATOM    952  CB  LEU    61      13.140   1.497  -6.161  1.00 44.33           C 
ATOM    953  CG  LEU    61      13.415  -0.016  -6.057  1.00 34.51           C 
ATOM    954  CD1 LEU    61      12.478  -0.813  -6.944  1.00 22.52           C 
ATOM    955  CD2 LEU    61      14.871  -0.328  -6.396  1.00 62.10           C 
ATOM    956  H   LEU    61      13.189   4.176  -6.775  1.00 36.29           H 
ATOM    957  HA  LEU    61      14.543   1.742  -7.778  1.00 54.23           H 
ATOM    958 3HB  LEU    61      12.072   1.651  -6.075  1.00 36.29           H 
ATOM    959 2HB  LEU    61      13.614   1.977  -5.314  1.00 36.29           H 
ATOM    960  HG  LEU    61      13.241  -0.331  -5.035  1.00 61.22           H 
ATOM    961 1HD1 LEU    61      12.664  -0.570  -7.980  1.00 36.29           H 
ATOM    962 2HD1 LEU    61      11.454  -0.571  -6.697  1.00 36.29           H 
ATOM    963 3HD1 LEU    61      12.644  -1.869  -6.787  1.00 36.29           H 
ATOM    964 1HD2 LEU    61      15.048  -1.387  -6.287  1.00 36.29           H 
ATOM    965 2HD2 LEU    61      15.523   0.215  -5.725  1.00 36.29           H 
ATOM    966 3HD2 LEU    61      15.078  -0.032  -7.415  1.00 36.29           H 
ATOM    967  N   ARG    62      12.687   1.084  -9.426  1.00  5.25           N 
ATOM    968  CA  ARG    62      11.758   0.904 -10.564  1.00  0.12           C 
ATOM    969  C   ARG    62      10.657  -0.116 -10.205  1.00 14.25           C 
ATOM    970  O   ARG    62      10.910  -1.052  -9.452  1.00 12.44           O 
ATOM    971  CB  ARG    62      12.532   0.418 -11.809  1.00 14.05           C 
ATOM    972  CG  ARG    62      13.974   0.922 -11.884  1.00  0.13           C 
ATOM    973  CD  ARG    62      14.068   2.445 -11.941  1.00 64.11           C 
ATOM    974  NE  ARG    62      15.370   2.916 -11.472  1.00 64.20           N 
ATOM    975  CZ  ARG    62      15.885   4.079 -11.755  1.00 11.14           C 
ATOM    976  NH1 ARG    62      15.305   4.866 -12.604  1.00 64.40           N 
ATOM    977  NH2 ARG    62      17.003   4.441 -11.208  1.00  5.21           N 
ATOM    978  H   ARG    62      13.403   0.422  -9.283  1.00 36.29           H 
ATOM    979  HA  ARG    62      11.298   1.859 -10.781  1.00 55.31           H 
ATOM    980 3HB  ARG    62      12.012   0.753 -12.697  1.00 36.29           H 
ATOM    981 2HB  ARG    62      12.555  -0.664 -11.808  1.00 36.29           H 
ATOM    982 3HG  ARG    62      14.442   0.507 -12.768  1.00 36.29           H 
ATOM    983 2HG  ARG    62      14.505   0.577 -11.007  1.00 36.29           H 
ATOM    984 3HD  ARG    62      13.295   2.869 -11.315  1.00 36.29           H 
ATOM    985 2HD  ARG    62      13.922   2.767 -12.962  1.00 36.29           H 
ATOM    986  HE  ARG    62      15.872   2.323 -10.873  1.00 11.33           H 
ATOM    987 1HH1 ARG    62      14.461   4.583 -13.052  1.00 36.29           H 
ATOM    988 2HH1 ARG    62      15.709   5.756 -12.810  1.00 36.29           H 
ATOM    989 1HH2 ARG    62      17.467   3.827 -10.572  1.00 36.29           H 
ATOM    990 2HH2 ARG    62      17.398   5.335 -11.418  1.00 36.29           H 
ATOM    991  N   LYS    63       9.444   0.040 -10.757  1.00 50.11           N 
ATOM    992  CA  LYS    63       8.329  -0.874 -10.418  1.00 15.24           C 
ATOM    993  C   LYS    63       8.701  -2.345 -10.655  1.00  2.52           C 
ATOM    994  O   LYS    63       8.415  -3.199  -9.816  1.00  5.44           O 
ATOM    995  CB  LYS    63       7.044  -0.544 -11.199  1.00 12.43           C 
ATOM    996  CG  LYS    63       6.342   0.734 -10.740  1.00 21.11           C 
ATOM    997  CD  LYS    63       4.849   0.729 -11.083  1.00 33.00           C 
ATOM    998  CE  LYS    63       4.593   0.579 -12.581  1.00 42.00           C 
ATOM    999  NZ  LYS    63       4.997   1.787 -13.349  1.00 30.20           N 
ATOM   1000  H   LYS    63       9.297   0.764 -11.402  1.00 36.29           H 
ATOM   1001  HA  LYS    63       8.127  -0.747  -9.363  1.00 14.34           H 
ATOM   1002 3HB  LYS    63       6.350  -1.367 -11.091  1.00 36.29           H 
ATOM   1003 2HB  LYS    63       7.292  -0.435 -12.246  1.00 36.29           H 
ATOM   1004 3HG  LYS    63       6.808   1.576 -11.224  1.00 36.29           H 
ATOM   1005 2HG  LYS    63       6.450   0.831  -9.669  1.00 36.29           H 
ATOM   1006 3HD  LYS    63       4.413   1.658 -10.746  1.00 36.29           H 
ATOM   1007 2HD  LYS    63       4.377  -0.094 -10.567  1.00 36.29           H 
ATOM   1008 3HE  LYS    63       3.537   0.405 -12.736  1.00 36.29           H 
ATOM   1009 2HE  LYS    63       5.150  -0.269 -12.949  1.00 36.29           H 
ATOM   1010 1HZ  LYS    63       5.989   2.028 -13.153  1.00 36.29           H 
ATOM   1011 2HZ  LYS    63       4.396   2.594 -13.092  1.00 36.29           H 
ATOM   1012 3HZ  LYS    63       4.895   1.610 -14.369  1.00 36.29           H 
ATOM   1013  N   ARG    64       9.357  -2.628 -11.783  1.00  1.34           N 
ATOM   1014  CA  ARG    64       9.785  -3.998 -12.110  1.00 73.25           C 
ATOM   1015  C   ARG    64      10.526  -4.656 -10.924  1.00 60.40           C 
ATOM   1016  O   ARG    64      10.294  -5.819 -10.597  1.00 45.22           O 
ATOM   1017  CB  ARG    64      10.710  -3.987 -13.337  1.00  4.23           C 
ATOM   1018  CG  ARG    64      12.009  -3.221 -13.102  1.00 64.14           C 
ATOM   1019  CD  ARG    64      13.114  -3.634 -14.063  1.00 24.41           C 
ATOM   1020  NE  ARG    64      14.441  -3.279 -13.558  1.00 43.52           N 
ATOM   1021  CZ  ARG    64      15.548  -3.868 -13.929  1.00 14.12           C 
ATOM   1022  NH1 ARG    64      15.524  -4.827 -14.799  1.00 23.40           N 
ATOM   1023  NH2 ARG    64      16.678  -3.515 -13.404  1.00 63.42           N 
ATOM   1024  H   ARG    64       9.545  -1.903 -12.419  1.00 36.29           H 
ATOM   1025  HA  ARG    64       8.901  -4.578 -12.339  1.00  4.42           H 
ATOM   1026 3HB  ARG    64      10.189  -3.529 -14.167  1.00 36.29           H 
ATOM   1027 2HB  ARG    64      10.956  -5.008 -13.598  1.00 36.29           H 
ATOM   1028 3HG  ARG    64      12.337  -3.408 -12.093  1.00 36.29           H 
ATOM   1029 2HG  ARG    64      11.819  -2.164 -13.222  1.00 36.29           H 
ATOM   1030 3HD  ARG    64      12.954  -3.136 -15.010  1.00 36.29           H 
ATOM   1031 2HD  ARG    64      13.069  -4.704 -14.209  1.00 36.29           H 
ATOM   1032  HE  ARG    64      14.499  -2.571 -12.887  1.00 41.34           H 
ATOM   1033 1HH1 ARG    64      14.658  -5.123 -15.190  1.00 36.29           H 
ATOM   1034 2HH1 ARG    64      16.374  -5.269 -15.073  1.00 36.29           H 
ATOM   1035 1HH2 ARG    64      16.702  -2.795 -12.705  1.00 36.29           H 
ATOM   1036 2HH2 ARG    64      17.520  -3.961 -13.693  1.00 36.29           H 
ATOM   1037  N   GLU    65      11.404  -3.880 -10.285  1.00 61.05           N 
ATOM   1038  CA  GLU    65      12.196  -4.349  -9.145  1.00 55.32           C 
ATOM   1039  C   GLU    65      11.343  -4.329  -7.870  1.00  3.51           C 
ATOM   1040  O   GLU    65      11.424  -5.222  -7.029  1.00 44.33           O 
ATOM   1041  CB  GLU    65      13.432  -3.442  -8.974  1.00  1.13           C 
ATOM   1042  CG  GLU    65      14.341  -3.388 -10.209  1.00 41.14           C 
ATOM   1043  CD  GLU    65      15.236  -2.153 -10.271  1.00 41.31           C 
ATOM   1044  OE1 GLU    65      16.203  -2.161 -11.068  1.00  4.52           O 
ATOM   1045  OE2 GLU    65      14.960  -1.162  -9.560  1.00 15.04           O 
ATOM   1046  H   GLU    65      11.512  -2.954 -10.578  1.00 36.29           H 
ATOM   1047  HA  GLU    65      12.518  -5.362  -9.343  1.00  5.33           H 
ATOM   1048 3HB  GLU    65      14.017  -3.802  -8.139  1.00 36.29           H 
ATOM   1049 2HB  GLU    65      13.096  -2.438  -8.757  1.00 36.29           H 
ATOM   1050 3HG  GLU    65      13.725  -3.403 -11.093  1.00 36.29           H 
ATOM   1051 2HG  GLU    65      14.972  -4.264 -10.208  1.00 36.29           H 
ATOM   1052  N   ALA    66      10.501  -3.306  -7.759  1.00 74.01           N 
ATOM   1053  CA  ALA    66       9.648  -3.105  -6.586  1.00 54.13           C 
ATOM   1054  C   ALA    66       8.618  -4.233  -6.402  1.00 62.01           C 
ATOM   1055  O   ALA    66       8.259  -4.570  -5.274  1.00 65.11           O 
ATOM   1056  CB  ALA    66       8.948  -1.759  -6.691  1.00 33.23           C 
ATOM   1057  H   ALA    66      10.452  -2.660  -8.493  1.00 36.29           H 
ATOM   1058  HA  ALA    66      10.289  -3.077  -5.714  1.00  4.22           H 
ATOM   1059 1HB  ALA    66       8.336  -1.741  -7.582  1.00 36.29           H 
ATOM   1060 2HB  ALA    66       9.685  -0.971  -6.747  1.00 36.29           H 
ATOM   1061 3HB  ALA    66       8.324  -1.606  -5.823  1.00 36.29           H 
ATOM   1062  N   ASP    67       8.148  -4.812  -7.509  1.00 12.11           N 
ATOM   1063  CA  ASP    67       7.185  -5.920  -7.452  1.00  0.15           C 
ATOM   1064  C   ASP    67       7.825  -7.206  -6.901  1.00  3.24           C 
ATOM   1065  O   ASP    67       7.137  -8.193  -6.647  1.00 33.51           O 
ATOM   1066  CB  ASP    67       6.581  -6.186  -8.836  1.00  4.12           C 
ATOM   1067  CG  ASP    67       5.732  -5.032  -9.343  1.00 11.24           C 
ATOM   1068  OD1 ASP    67       5.988  -4.550 -10.467  1.00 73.02           O 
ATOM   1069  OD2 ASP    67       4.789  -4.615  -8.630  1.00 34.24           O 
ATOM   1070  H   ASP    67       8.452  -4.485  -8.384  1.00 36.29           H 
ATOM   1071  HA  ASP    67       6.391  -5.623  -6.780  1.00 33.35           H 
ATOM   1072 3HB  ASP    67       5.960  -7.071  -8.786  1.00 36.29           H 
ATOM   1073 2HB  ASP    67       7.382  -6.358  -9.541  1.00 36.29           H 
ATOM   1074  N   LEU    68       9.144  -7.192  -6.731  1.00 24.35           N 
ATOM   1075  CA  LEU    68       9.874  -8.339  -6.185  1.00 61.32           C 
ATOM   1076  C   LEU    68      10.061  -8.228  -4.664  1.00  1.11           C 
ATOM   1077  O   LEU    68      10.298  -9.226  -3.985  1.00 74.44           O 
ATOM   1078  CB  LEU    68      11.237  -8.455  -6.881  1.00 72.30           C 
ATOM   1079  CG  LEU    68      11.162  -8.742  -8.387  1.00 74.11           C 
ATOM   1080  CD1 LEU    68      12.512  -8.513  -9.052  1.00 61.03           C 
ATOM   1081  CD2 LEU    68      10.673 -10.168  -8.626  1.00 22.12           C 
ATOM   1082  H   LEU    68       9.645  -6.389  -6.989  1.00 36.29           H 
ATOM   1083  HA  LEU    68       9.299  -9.232  -6.397  1.00 54.21           H 
ATOM   1084 3HB  LEU    68      11.796  -9.254  -6.412  1.00 36.29           H 
ATOM   1085 2HB  LEU    68      11.774  -7.529  -6.733  1.00 36.29           H 
ATOM   1086  HG  LEU    68      10.451  -8.066  -8.840  1.00 51.12           H 
ATOM   1087 1HD1 LEU    68      12.827  -7.491  -8.889  1.00 36.29           H 
ATOM   1088 2HD1 LEU    68      12.427  -8.695 -10.113  1.00 36.29           H 
ATOM   1089 3HD1 LEU    68      13.245  -9.185  -8.630  1.00 36.29           H 
ATOM   1090 1HD2 LEU    68       9.688 -10.288  -8.197  1.00 36.29           H 
ATOM   1091 2HD2 LEU    68      11.353 -10.868  -8.161  1.00 36.29           H 
ATOM   1092 3HD2 LEU    68      10.627 -10.361  -9.687  1.00 36.29           H 
ATOM   1093  N   ILE    69       9.953  -7.016  -4.126  1.00 32.41           N 
ATOM   1094  CA  ILE    69      10.132  -6.802  -2.685  1.00 63.31           C 
ATOM   1095  C   ILE    69       8.779  -6.750  -1.955  1.00 63.13           C 
ATOM   1096  O   ILE    69       8.015  -5.790  -2.086  1.00 64.30           O 
ATOM   1097  CB  ILE    69      10.945  -5.510  -2.371  1.00 24.51           C 
ATOM   1098  CG1 ILE    69      12.412  -5.639  -2.835  1.00 14.50           C 
ATOM   1099  CG2 ILE    69      10.899  -5.195  -0.876  1.00 21.25           C 
ATOM   1100  CD1 ILE    69      12.599  -5.655  -4.336  1.00  2.34           C 
ATOM   1101  H   ILE    69       9.739  -6.251  -4.703  1.00 36.29           H 
ATOM   1102  HA  ILE    69      10.693  -7.646  -2.300  1.00 72.51           H 
ATOM   1103  HB  ILE    69      10.482  -4.687  -2.898  1.00 43.31           H 
ATOM   1104 3HG1 ILE    69      12.827  -6.556  -2.440  1.00 36.29           H 
ATOM   1105 2HG1 ILE    69      12.979  -4.804  -2.449  1.00 36.29           H 
ATOM   1106 1HG2 ILE    69      11.498  -4.318  -0.674  1.00 36.29           H 
ATOM   1107 2HG2 ILE    69      11.290  -6.033  -0.317  1.00 36.29           H 
ATOM   1108 3HG2 ILE    69       9.878  -5.008  -0.578  1.00 36.29           H 
ATOM   1109 1HD1 ILE    69      12.101  -6.517  -4.753  1.00 36.29           H 
ATOM   1110 2HD1 ILE    69      13.653  -5.703  -4.566  1.00 36.29           H 
ATOM   1111 3HD1 ILE    69      12.179  -4.756  -4.762  1.00 36.29           H 
ATOM   1112  N   GLU    70       8.493  -7.803  -1.192  1.00 51.00           N 
ATOM   1113  CA  GLU    70       7.270  -7.889  -0.385  1.00 21.43           C 
ATOM   1114  C   GLU    70       7.465  -7.194   0.973  1.00  1.31           C 
ATOM   1115  O   GLU    70       8.252  -7.642   1.806  1.00  1.33           O 
ATOM   1116  CB  GLU    70       6.887  -9.371  -0.196  1.00 12.20           C 
ATOM   1117  CG  GLU    70       5.743  -9.638   0.787  1.00 34.43           C 
ATOM   1118  CD  GLU    70       4.419  -8.995   0.395  1.00 23.32           C 
ATOM   1119  OE1 GLU    70       3.749  -8.420   1.280  1.00 75.23           O 
ATOM   1120  OE2 GLU    70       4.032  -9.066  -0.790  1.00 11.32           O 
ATOM   1121  H   GLU    70       9.129  -8.550  -1.169  1.00 36.29           H 
ATOM   1122  HA  GLU    70       6.479  -7.388  -0.924  1.00 40.21           H 
ATOM   1123 3HB  GLU    70       7.760  -9.908   0.153  1.00 36.29           H 
ATOM   1124 2HB  GLU    70       6.597  -9.775  -1.156  1.00 36.29           H 
ATOM   1125 3HG  GLU    70       6.035  -9.264   1.760  1.00 36.29           H 
ATOM   1126 2HG  GLU    70       5.591 -10.705   0.853  1.00 36.29           H 
ATOM   1127  N   VAL    71       6.751  -6.087   1.181  1.00 21.13           N 
ATOM   1128  CA  VAL    71       6.847  -5.305   2.424  1.00  4.42           C 
ATOM   1129  C   VAL    71       5.549  -5.384   3.248  1.00 51.21           C 
ATOM   1130  O   VAL    71       4.533  -5.888   2.774  1.00 71.21           O 
ATOM   1131  CB  VAL    71       7.179  -3.817   2.132  1.00 72.43           C 
ATOM   1132  CG1 VAL    71       8.526  -3.696   1.429  1.00 43.24           C 
ATOM   1133  CG2 VAL    71       6.079  -3.153   1.303  1.00 63.42           C 
ATOM   1134  H   VAL    71       6.138  -5.787   0.480  1.00 36.29           H 
ATOM   1135  HA  VAL    71       7.655  -5.719   3.016  1.00 44.22           H 
ATOM   1136  HB  VAL    71       7.249  -3.296   3.078  1.00 15.34           H 
ATOM   1137 1HG1 VAL    71       8.475  -4.172   0.461  1.00 36.29           H 
ATOM   1138 2HG1 VAL    71       9.287  -4.178   2.027  1.00 36.29           H 
ATOM   1139 3HG1 VAL    71       8.776  -2.652   1.304  1.00 36.29           H 
ATOM   1140 1HG2 VAL    71       5.952  -3.688   0.372  1.00 36.29           H 
ATOM   1141 2HG2 VAL    71       6.351  -2.128   1.094  1.00 36.29           H 
ATOM   1142 3HG2 VAL    71       5.151  -3.169   1.855  1.00 36.29           H 
ATOM   1143  N   GLU    72       5.591  -4.909   4.494  1.00 13.21           N 
ATOM   1144  CA  GLU    72       4.400  -4.901   5.363  1.00 65.30           C 
ATOM   1145  C   GLU    72       4.184  -3.529   6.021  1.00 61.31           C 
ATOM   1146  O   GLU    72       5.122  -2.926   6.542  1.00 33.12           O 
ATOM   1147  CB  GLU    72       4.518  -5.986   6.443  1.00 42.04           C 
ATOM   1148  CG  GLU    72       5.703  -5.806   7.386  1.00 60.42           C 
ATOM   1149  CD  GLU    72       5.798  -6.915   8.420  1.00 64.32           C 
ATOM   1150  OE1 GLU    72       4.933  -6.973   9.319  1.00 14.44           O 
ATOM   1151  OE2 GLU    72       6.733  -7.738   8.334  1.00 13.42           O 
ATOM   1152  H   GLU    72       6.440  -4.563   4.844  1.00 36.29           H 
ATOM   1153  HA  GLU    72       3.541  -5.122   4.744  1.00 12.44           H 
ATOM   1154 3HB  GLU    72       4.616  -6.946   5.957  1.00 36.29           H 
ATOM   1155 2HB  GLU    72       3.613  -5.988   7.036  1.00 36.29           H 
ATOM   1156 3HG  GLU    72       5.599  -4.860   7.901  1.00 36.29           H 
ATOM   1157 2HG  GLU    72       6.613  -5.795   6.800  1.00 36.29           H 
ATOM   1158  N   VAL    73       2.943  -3.048   6.001  1.00 73.32           N 
ATOM   1159  CA  VAL    73       2.608  -1.733   6.556  1.00 54.30           C 
ATOM   1160  C   VAL    73       2.806  -1.678   8.083  1.00  2.11           C 
ATOM   1161  O   VAL    73       2.025  -2.247   8.849  1.00 23.41           O 
ATOM   1162  CB  VAL    73       1.148  -1.340   6.212  1.00 71.11           C 
ATOM   1163  CG1 VAL    73       0.792   0.029   6.795  1.00 61.40           C 
ATOM   1164  CG2 VAL    73       0.931  -1.360   4.699  1.00  2.40           C 
ATOM   1165  H   VAL    73       2.230  -3.593   5.602  1.00 36.29           H 
ATOM   1166  HA  VAL    73       3.266  -1.006   6.097  1.00 74.10           H 
ATOM   1167  HB  VAL    73       0.488  -2.074   6.654  1.00 30.21           H 
ATOM   1168 1HG1 VAL    73       1.472   0.775   6.409  1.00 36.29           H 
ATOM   1169 2HG1 VAL    73       0.870  -0.005   7.873  1.00 36.29           H 
ATOM   1170 3HG1 VAL    73      -0.221   0.288   6.517  1.00 36.29           H 
ATOM   1171 1HG2 VAL    73      -0.095  -1.102   4.478  1.00 36.29           H 
ATOM   1172 2HG2 VAL    73       1.143  -2.348   4.317  1.00 36.29           H 
ATOM   1173 3HG2 VAL    73       1.590  -0.644   4.228  1.00 36.29           H 
ATOM   1174  N   VAL    74       3.851  -0.968   8.515  1.00 21.41           N 
ATOM   1175  CA  VAL    74       4.168  -0.824   9.945  1.00 24.21           C 
ATOM   1176  C   VAL    74       3.105   0.028  10.673  1.00 65.34           C 
ATOM   1177  O   VAL    74       3.011   0.016  11.901  1.00 40.43           O 
ATOM   1178  CB  VAL    74       5.574  -0.184  10.142  1.00 31.32           C 
ATOM   1179  CG1 VAL    74       5.956  -0.116  11.621  1.00  5.25           C 
ATOM   1180  CG2 VAL    74       6.631  -0.953   9.348  1.00 53.13           C 
ATOM   1181  H   VAL    74       4.428  -0.528   7.853  1.00 36.29           H 
ATOM   1182  HA  VAL    74       4.180  -1.813  10.383  1.00 43.12           H 
ATOM   1183  HB  VAL    74       5.538   0.828   9.759  1.00 60.52           H 
ATOM   1184 1HG1 VAL    74       6.930   0.343  11.724  1.00 36.29           H 
ATOM   1185 2HG1 VAL    74       5.985  -1.114  12.034  1.00 36.29           H 
ATOM   1186 3HG1 VAL    74       5.225   0.471  12.157  1.00 36.29           H 
ATOM   1187 1HG2 VAL    74       6.384  -0.926   8.296  1.00 36.29           H 
ATOM   1188 2HG2 VAL    74       6.661  -1.979   9.684  1.00 36.29           H 
ATOM   1189 3HG2 VAL    74       7.601  -0.498   9.500  1.00 36.29           H 
ATOM   1190  N   GLY    75       2.291   0.748   9.899  1.00 11.31           N 
ATOM   1191  CA  GLY    75       1.258   1.614  10.471  1.00  1.42           C 
ATOM   1192  C   GLY    75       0.117   0.864  11.170  1.00 43.00           C 
ATOM   1193  O   GLY    75      -0.753   1.489  11.780  1.00 32.03           O 
ATOM   1194  H   GLY    75       2.396   0.700   8.927  1.00 36.29           H 
ATOM   1195 3HA  GLY    75       0.837   2.213   9.676  1.00 36.29           H 
ATOM   1196 2HA  GLY    75       1.724   2.277  11.187  1.00 36.29           H 
ATOM   1204  N   GLU    77      -2.454  -0.642   9.985  1.00 11.51           N 
ATOM   1205  CA  GLU    77      -3.612  -0.786   9.094  1.00 13.44           C 
ATOM   1206  C   GLU    77      -3.312  -0.215   7.697  1.00  2.42           C 
ATOM   1207  O   GLU    77      -2.423   0.626   7.539  1.00 25.04           O 
ATOM   1208  CB  GLU    77      -4.862  -0.141   9.730  1.00 44.40           C 
ATOM   1209  CG  GLU    77      -4.619   1.193  10.448  1.00 34.41           C 
ATOM   1210  CD  GLU    77      -4.730   2.413   9.544  1.00 50.11           C 
ATOM   1211  OE1 GLU    77      -3.899   3.342   9.674  1.00 42.31           O 
ATOM   1212  OE2 GLU    77      -5.670   2.469   8.730  1.00 32.01           O 
ATOM   1213  H   GLU    77      -1.869   0.136   9.876  1.00 36.29           H 
ATOM   1214  HA  GLU    77      -3.795  -1.847   8.981  1.00 15.42           H 
ATOM   1215 3HB  GLU    77      -5.272  -0.837  10.449  1.00 36.29           H 
ATOM   1216 2HB  GLU    77      -5.600   0.023   8.957  1.00 36.29           H 
ATOM   1217 3HG  GLU    77      -3.628   1.173  10.883  1.00 36.29           H 
ATOM   1218 2HG  GLU    77      -5.349   1.296  11.240  1.00 36.29           H 
ATOM   1219  N   LEU    78      -4.045  -0.688   6.685  1.00 42.42           N 
ATOM   1220  CA  LEU    78      -3.726  -0.377   5.282  1.00 60.21           C 
ATOM   1221  C   LEU    78      -4.996  -0.222   4.419  1.00 62.54           C 
ATOM   1222  O   LEU    78      -6.044  -0.782   4.736  1.00  4.41           O 
ATOM   1223  CB  LEU    78      -2.814  -1.473   4.686  1.00 61.43           C 
ATOM   1224  CG  LEU    78      -3.447  -2.870   4.491  1.00 11.44           C 
ATOM   1225  CD1 LEU    78      -2.505  -3.774   3.701  1.00 12.40           C 
ATOM   1226  CD2 LEU    78      -3.799  -3.519   5.833  1.00 74.53           C 
ATOM   1227  H   LEU    78      -4.830  -1.244   6.884  1.00 36.29           H 
ATOM   1228  HA  LEU    78      -3.189   0.561   5.269  1.00 44.34           H 
ATOM   1229 3HB  LEU    78      -1.956  -1.581   5.336  1.00 36.29           H 
ATOM   1230 2HB  LEU    78      -2.465  -1.127   3.723  1.00 36.29           H 
ATOM   1231  HG  LEU    78      -4.358  -2.767   3.919  1.00 65.12           H 
ATOM   1232 1HD1 LEU    78      -2.985  -4.725   3.521  1.00 36.29           H 
ATOM   1233 2HD1 LEU    78      -1.595  -3.932   4.264  1.00 36.29           H 
ATOM   1234 3HD1 LEU    78      -2.265  -3.308   2.756  1.00 36.29           H 
ATOM   1235 1HD2 LEU    78      -4.537  -2.918   6.341  1.00 36.29           H 
ATOM   1236 2HD2 LEU    78      -2.912  -3.593   6.445  1.00 36.29           H 
ATOM   1237 3HD2 LEU    78      -4.200  -4.508   5.661  1.00 36.29           H 
ATOM   1238  N   PRO    79      -4.915   0.544   3.306  1.00 33.21           N 
ATOM   1239  CA  PRO    79      -6.069   0.774   2.413  1.00  3.41           C 
ATOM   1240  C   PRO    79      -6.473  -0.476   1.601  1.00 53.44           C 
ATOM   1241  O   PRO    79      -5.633  -1.315   1.265  1.00 30.11           O 
ATOM   1242  CB  PRO    79      -5.572   1.889   1.482  1.00 60.14           C 
ATOM   1243  CG  PRO    79      -4.091   1.726   1.458  1.00  3.44           C 
ATOM   1244  CD  PRO    79      -3.705   1.251   2.834  1.00 21.25           C 
ATOM   1245  HA  PRO    79      -6.926   1.127   2.970  1.00 32.11           H 
ATOM   1246 3HB  PRO    79      -5.852   2.854   1.884  1.00 36.29           H 
ATOM   1247 2HB  PRO    79      -6.001   1.766   0.497  1.00 36.29           H 
ATOM   1248 3HG  PRO    79      -3.618   2.673   1.241  1.00 36.29           H 
ATOM   1249 2HG  PRO    79      -3.814   0.990   0.716  1.00 36.29           H 
ATOM   1250 3HD  PRO    79      -3.475   2.091   3.474  1.00 36.29           H 
ATOM   1251 2HD  PRO    79      -2.861   0.577   2.779  1.00 36.29           H 
ATOM   1252  N   LEU    80      -7.765  -0.571   1.270  1.00 10.14           N 
ATOM   1253  CA  LEU    80      -8.322  -1.726   0.538  1.00 12.24           C 
ATOM   1254  C   LEU    80      -7.531  -2.084  -0.732  1.00 71.04           C 
ATOM   1255  O   LEU    80      -7.179  -3.245  -0.943  1.00 34.43           O 
ATOM   1256  CB  LEU    80      -9.787  -1.452   0.162  1.00 13.14           C 
ATOM   1257  CG  LEU    80     -10.808  -1.614   1.299  1.00 54.21           C 
ATOM   1258  CD1 LEU    80     -12.201  -1.194   0.838  1.00 12.24           C 
ATOM   1259  CD2 LEU    80     -10.824  -3.057   1.801  1.00 34.31           C 
ATOM   1260  H   LEU    80      -8.371   0.157   1.533  1.00 36.29           H 
ATOM   1261  HA  LEU    80      -8.296  -2.574   1.206  1.00 73.22           H 
ATOM   1262 3HB  LEU    80     -10.066  -2.124  -0.639  1.00 36.29           H 
ATOM   1263 2HB  LEU    80      -9.855  -0.438  -0.210  1.00 36.29           H 
ATOM   1264  HG  LEU    80     -10.523  -0.976   2.125  1.00 14.14           H 
ATOM   1265 1HD1 LEU    80     -12.900  -1.307   1.654  1.00 36.29           H 
ATOM   1266 2HD1 LEU    80     -12.514  -1.813   0.008  1.00 36.29           H 
ATOM   1267 3HD1 LEU    80     -12.181  -0.159   0.526  1.00 36.29           H 
ATOM   1268 1HD2 LEU    80     -11.535  -3.148   2.610  1.00 36.29           H 
ATOM   1269 2HD2 LEU    80      -9.841  -3.325   2.157  1.00 36.29           H 
ATOM   1270 3HD2 LEU    80     -11.109  -3.720   0.996  1.00 36.29           H 
ATOM   1271  N   ILE    81      -7.255  -1.088  -1.570  1.00 44.14           N 
ATOM   1272  CA  ILE    81      -6.604  -1.322  -2.871  1.00 50.44           C 
ATOM   1273  C   ILE    81      -5.189  -1.920  -2.721  1.00 33.22           C 
ATOM   1274  O   ILE    81      -4.653  -2.514  -3.657  1.00 43.13           O 
ATOM   1275  CB  ILE    81      -6.528  -0.010  -3.698  1.00 35.34           C 
ATOM   1276  CG1 ILE    81      -6.096  -0.294  -5.148  1.00 45.22           C 
ATOM   1277  CG2 ILE    81      -5.576   0.987  -3.044  1.00 11.34           C 
ATOM   1278  CD1 ILE    81      -7.036  -1.214  -5.900  1.00  2.11           C 
ATOM   1279  H   ILE    81      -7.502  -0.174  -1.317  1.00 36.29           H 
ATOM   1280  HA  ILE    81      -7.218  -2.025  -3.417  1.00  3.54           H 
ATOM   1281  HB  ILE    81      -7.513   0.435  -3.708  1.00 64.25           H 
ATOM   1282 3HG1 ILE    81      -5.116  -0.753  -5.144  1.00 36.29           H 
ATOM   1283 2HG1 ILE    81      -6.047   0.637  -5.692  1.00 36.29           H 
ATOM   1284 1HG2 ILE    81      -5.915   1.203  -2.040  1.00 36.29           H 
ATOM   1285 2HG2 ILE    81      -5.556   1.901  -3.620  1.00 36.29           H 
ATOM   1286 3HG2 ILE    81      -4.583   0.565  -3.003  1.00 36.29           H 
ATOM   1287 1HD1 ILE    81      -7.069  -2.176  -5.410  1.00 36.29           H 
ATOM   1288 2HD1 ILE    81      -6.681  -1.338  -6.912  1.00 36.29           H 
ATOM   1289 3HD1 ILE    81      -8.027  -0.784  -5.915  1.00 36.29           H 
ATOM   1290  N   LEU    82      -4.590  -1.765  -1.542  1.00 13.21           N 
ATOM   1291  CA  LEU    82      -3.229  -2.263  -1.295  1.00 75.44           C 
ATOM   1292  C   LEU    82      -3.235  -3.478  -0.352  1.00 14.20           C 
ATOM   1293  O   LEU    82      -2.176  -3.964   0.063  1.00 74.13           O 
ATOM   1294  CB  LEU    82      -2.366  -1.146  -0.695  1.00 53.44           C 
ATOM   1295  CG  LEU    82      -2.352   0.178  -1.474  1.00 23.25           C 
ATOM   1296  CD1 LEU    82      -1.386   1.167  -0.831  1.00 12.00           C 
ATOM   1297  CD2 LEU    82      -2.003  -0.053  -2.944  1.00 23.35           C 
ATOM   1298  H   LEU    82      -5.070  -1.312  -0.819  1.00 36.29           H 
ATOM   1299  HA  LEU    82      -2.804  -2.562  -2.243  1.00 41.41           H 
ATOM   1300 3HB  LEU    82      -1.349  -1.508  -0.628  1.00 36.29           H 
ATOM   1301 2HB  LEU    82      -2.723  -0.944   0.306  1.00 36.29           H 
ATOM   1302  HG  LEU    82      -3.341   0.615  -1.434  1.00 42.03           H 
ATOM   1303 1HD1 LEU    82      -1.403   2.098  -1.381  1.00 36.29           H 
ATOM   1304 2HD1 LEU    82      -0.385   0.760  -0.844  1.00 36.29           H 
ATOM   1305 3HD1 LEU    82      -1.686   1.348   0.191  1.00 36.29           H 
ATOM   1306 1HD2 LEU    82      -1.038  -0.530  -3.018  1.00 36.29           H 
ATOM   1307 2HD2 LEU    82      -1.974   0.897  -3.460  1.00 36.29           H 
ATOM   1308 3HD2 LEU    82      -2.754  -0.683  -3.398  1.00 36.29           H 
ATOM   1309  N   ALA    83      -4.428  -3.973  -0.032  1.00 32.45           N 
ATOM   1310  CA  ALA    83      -4.592  -5.071   0.925  1.00 15.43           C 
ATOM   1311  C   ALA    83      -4.014  -6.403   0.410  1.00 54.30           C 
ATOM   1312  O   ALA    83      -3.799  -6.591  -0.789  1.00 23.30           O 
ATOM   1313  CB  ALA    83      -6.067  -5.236   1.279  1.00 62.03           C 
ATOM   1314  H   ALA    83      -5.227  -3.589  -0.453  1.00 36.29           H 
ATOM   1315  HA  ALA    83      -4.066  -4.796   1.829  1.00  1.41           H 
ATOM   1316 1HB  ALA    83      -6.462  -4.293   1.627  1.00 36.29           H 
ATOM   1317 2HB  ALA    83      -6.170  -5.977   2.061  1.00 36.29           H 
ATOM   1318 3HB  ALA    83      -6.616  -5.558   0.406  1.00 36.29           H 
ATOM   1319  N   ASP    84      -3.760  -7.320   1.339  1.00 24.33           N 
ATOM   1320  CA  ASP    84      -3.272  -8.663   1.014  1.00 10.43           C 
ATOM   1321  C   ASP    84      -4.400  -9.512   0.385  1.00 31.22           C 
ATOM   1322  O   ASP    84      -4.529  -9.582  -0.842  1.00  1.44           O 
ATOM   1323  CB  ASP    84      -2.725  -9.313   2.296  1.00 12.14           C 
ATOM   1324  CG  ASP    84      -2.271 -10.747   2.104  1.00 72.45           C 
ATOM   1325  OD1 ASP    84      -3.012 -11.668   2.515  1.00 44.41           O 
ATOM   1326  OD2 ASP    84      -1.169 -10.955   1.558  1.00 25.23           O 
ATOM   1327  H   ASP    84      -3.901  -7.087   2.281  1.00 36.29           H 
ATOM   1328  HA  ASP    84      -2.469  -8.563   0.297  1.00 73.24           H 
ATOM   1329 3HB  ASP    84      -3.498  -9.296   3.051  1.00 36.29           H 
ATOM   1330 2HB  ASP    84      -1.883  -8.736   2.646  1.00 36.29           H 
ATOM   1331  N   ASP    85      -5.236 -10.120   1.232  1.00 43.24           N 
ATOM   1332  CA  ASP    85      -6.389 -10.904   0.774  1.00 10.24           C 
ATOM   1333  C   ASP    85      -7.229 -11.390   1.973  1.00  1.54           C 
ATOM   1334  O   ASP    85      -6.831 -11.223   3.127  1.00  0.32           O 
ATOM   1335  CB  ASP    85      -5.918 -12.100  -0.067  1.00 10.35           C 
ATOM   1336  CG  ASP    85      -7.046 -12.723  -0.867  1.00 21.21           C 
ATOM   1337  OD1 ASP    85      -7.689 -13.662  -0.366  1.00 45.32           O 
ATOM   1338  OD2 ASP    85      -7.309 -12.253  -1.993  1.00 50.25           O 
ATOM   1339  H   ASP    85      -5.066 -10.052   2.195  1.00 36.29           H 
ATOM   1340  HA  ASP    85      -7.004 -10.260   0.160  1.00  3.02           H 
ATOM   1341 3HB  ASP    85      -5.500 -12.853   0.587  1.00 36.29           H 
ATOM   1342 2HB  ASP    85      -5.153 -11.769  -0.756  1.00 36.29           H 
ATOM   1343  N   GLY    86      -8.394 -11.971   1.690  1.00 44.14           N 
ATOM   1344  CA  GLY    86      -9.235 -12.538   2.741  1.00 21.12           C 
ATOM   1345  C   GLY    86     -10.194 -11.536   3.378  1.00 41.53           C 
ATOM   1346  O   GLY    86     -10.603 -10.553   2.752  1.00 64.33           O 
ATOM   1347  H   GLY    86      -8.685 -12.028   0.756  1.00 36.29           H 
ATOM   1348 3HA  GLY    86      -8.598 -12.948   3.513  1.00 36.29           H 
ATOM   1349 2HA  GLY    86      -9.816 -13.343   2.314  1.00 36.29           H 
ATOM   1350  N   THR    87     -10.558 -11.795   4.635  1.00 35.13           N 
ATOM   1351  CA  THR    87     -11.509 -10.952   5.372  1.00 72.12           C 
ATOM   1352  C   THR    87     -10.799  -9.812   6.129  1.00 24.21           C 
ATOM   1353  O   THR    87      -9.826 -10.043   6.858  1.00 41.52           O 
ATOM   1354  CB  THR    87     -12.318 -11.785   6.400  1.00  0.32           C 
ATOM   1355  OG1 THR    87     -12.695 -13.054   5.838  1.00 42.15           O 
ATOM   1356  CG2 THR    87     -13.571 -11.036   6.845  1.00 42.41           C 
ATOM   1357  H   THR    87     -10.189 -12.586   5.077  1.00 36.29           H 
ATOM   1358  HA  THR    87     -12.203 -10.525   4.660  1.00 32.51           H 
ATOM   1359  HB  THR    87     -11.696 -11.961   7.268  1.00  2.24           H 
ATOM   1360  HG1 THR    87     -13.011 -12.935   4.931  1.00 64.23           H 
ATOM   1361 1HG2 THR    87     -14.114 -11.637   7.560  1.00 36.29           H 
ATOM   1362 2HG2 THR    87     -14.199 -10.838   5.989  1.00 36.29           H 
ATOM   1363 3HG2 THR    87     -13.288 -10.100   7.309  1.00 36.29           H 
ATOM   1364  N   TYR    88     -11.299  -8.585   5.964  1.00  4.25           N 
ATOM   1365  CA  TYR    88     -10.751  -7.403   6.652  1.00 21.51           C 
ATOM   1366  C   TYR    88     -11.807  -6.696   7.502  1.00 53.21           C 
ATOM   1367  O   TYR    88     -12.994  -6.942   7.359  1.00 53.41           O 
ATOM   1368  CB  TYR    88     -10.188  -6.406   5.634  1.00 52.03           C 
ATOM   1369  CG  TYR    88      -8.939  -6.890   4.940  1.00 31.22           C 
ATOM   1370  CD1 TYR    88      -9.013  -7.749   3.853  1.00 74.10           C 
ATOM   1371  CD2 TYR    88      -7.682  -6.496   5.382  1.00 54.22           C 
ATOM   1372  CE1 TYR    88      -7.874  -8.199   3.229  1.00 43.52           C 
ATOM   1373  CE2 TYR    88      -6.538  -6.941   4.759  1.00 42.24           C 
ATOM   1374  CZ  TYR    88      -6.642  -7.794   3.687  1.00 14.22           C 
ATOM   1375  OH  TYR    88      -5.509  -8.243   3.067  1.00 72.21           O 
ATOM   1376  H   TYR    88     -12.058  -8.465   5.355  1.00 36.29           H 
ATOM   1377  HA  TYR    88      -9.949  -7.733   7.299  1.00 13.41           H 
ATOM   1378 3HB  TYR    88      -9.950  -5.480   6.142  1.00 36.29           H 
ATOM   1379 2HB  TYR    88     -10.936  -6.210   4.877  1.00 36.29           H 
ATOM   1380  HD1 TYR    88      -9.983  -8.066   3.498  1.00 20.13           H 
ATOM   1381  HD2 TYR    88      -7.608  -5.825   6.225  1.00 62.02           H 
ATOM   1382  HE1 TYR    88      -7.950  -8.866   2.384  1.00 32.42           H 
ATOM   1383  HE2 TYR    88      -5.568  -6.625   5.117  1.00  4.31           H 
ATOM   1384  HH  TYR    88      -5.635  -8.200   2.112  1.00 71.22           H 
ATOM   1385  N   GLU    89     -11.354  -5.812   8.384  1.00 22.34           N 
ATOM   1386  CA  GLU    89     -12.251  -4.984   9.201  1.00 23.21           C 
ATOM   1387  C   GLU    89     -11.974  -3.490   8.965  1.00 54.21           C 
ATOM   1388  O   GLU    89     -10.836  -3.037   9.092  1.00 64.32           O 
ATOM   1389  CB  GLU    89     -12.069  -5.321  10.687  1.00 22.21           C 
ATOM   1390  CG  GLU    89     -12.930  -4.480  11.626  1.00 63.13           C 
ATOM   1391  CD  GLU    89     -12.663  -4.780  13.092  1.00 60.50           C 
ATOM   1392  OE1 GLU    89     -13.470  -5.499  13.719  1.00 25.53           O 
ATOM   1393  OE2 GLU    89     -11.647  -4.290  13.623  1.00 33.14           O 
ATOM   1394  H   GLU    89     -10.386  -5.716   8.500  1.00 36.29           H 
ATOM   1395  HA  GLU    89     -13.270  -5.201   8.910  1.00 11.21           H 
ATOM   1396 3HB  GLU    89     -11.032  -5.172  10.954  1.00 36.29           H 
ATOM   1397 2HB  GLU    89     -12.321  -6.362  10.840  1.00 36.29           H 
ATOM   1398 3HG  GLU    89     -13.972  -4.676  11.413  1.00 36.29           H 
ATOM   1399 2HG  GLU    89     -12.720  -3.435  11.445  1.00 36.29           H 
ATOM   1400  N   ILE    90     -13.009  -2.728   8.613  1.00 11.51           N 
ATOM   1401  CA  ILE    90     -12.846  -1.290   8.346  1.00 53.30           C 
ATOM   1402  C   ILE    90     -12.498  -0.498   9.622  1.00 34.11           C 
ATOM   1403  O   ILE    90     -13.180  -0.604  10.649  1.00 11.23           O 
ATOM   1404  CB  ILE    90     -14.111  -0.683   7.683  1.00 24.24           C 
ATOM   1405  CG1 ILE    90     -13.926   0.830   7.453  1.00 14.23           C 
ATOM   1406  CG2 ILE    90     -15.355  -0.960   8.528  1.00 25.01           C 
ATOM   1407  CD1 ILE    90     -15.115   1.501   6.804  1.00 35.11           C 
ATOM   1408  H   ILE    90     -13.898  -3.139   8.523  1.00 36.29           H 
ATOM   1409  HA  ILE    90     -12.026  -1.185   7.649  1.00 63.25           H 
ATOM   1410  HB  ILE    90     -14.249  -1.167   6.726  1.00 75.34           H 
ATOM   1411 3HG1 ILE    90     -13.066   0.990   6.816  1.00 36.29           H 
ATOM   1412 2HG1 ILE    90     -13.757   1.313   8.403  1.00 36.29           H 
ATOM   1413 1HG2 ILE    90     -15.247  -0.488   9.495  1.00 36.29           H 
ATOM   1414 2HG2 ILE    90     -15.472  -2.026   8.660  1.00 36.29           H 
ATOM   1415 3HG2 ILE    90     -16.228  -0.562   8.031  1.00 36.29           H 
ATOM   1416 1HD1 ILE    90     -15.985   1.378   7.431  1.00 36.29           H 
ATOM   1417 2HD1 ILE    90     -15.298   1.054   5.839  1.00 36.29           H 
ATOM   1418 3HD1 ILE    90     -14.910   2.554   6.679  1.00 36.29           H 
ATOM   1419  N   THR    91     -11.430   0.300   9.546  1.00 65.23           N 
ATOM   1420  CA  THR    91     -10.965   1.088  10.698  1.00 35.41           C 
ATOM   1421  C   THR    91     -11.241   2.593  10.535  1.00 43.23           C 
ATOM   1422  O   THR    91     -11.580   3.267  11.506  1.00 23.55           O 
ATOM   1423  CB  THR    91      -9.454   0.868  10.974  1.00 14.21           C 
ATOM   1424  OG1 THR    91      -9.022   1.680  12.077  1.00 73.21           O 
ATOM   1425  CG2 THR    91      -8.603   1.180   9.745  1.00 34.25           C 
ATOM   1426  H   THR    91     -10.940   0.357   8.697  1.00 36.29           H 
ATOM   1427  HA  THR    91     -11.507   0.740  11.569  1.00 61.54           H 
ATOM   1428  HB  THR    91      -9.305  -0.173  11.233  1.00 33.24           H 
ATOM   1429  HG1 THR    91      -9.720   1.708  12.747  1.00 14.23           H 
ATOM   1430 1HG2 THR    91      -8.722   2.219   9.474  1.00 36.29           H 
ATOM   1431 2HG2 THR    91      -8.916   0.555   8.920  1.00 36.29           H 
ATOM   1432 3HG2 THR    91      -7.564   0.984   9.968  1.00 36.29           H 
ATOM   1433  N   LYS    92     -11.100   3.122   9.313  1.00 42.31           N 
ATOM   1434  CA  LYS    92     -11.345   4.557   9.064  1.00 54.15           C 
ATOM   1435  C   LYS    92     -11.465   4.899   7.568  1.00 44.42           C 
ATOM   1436  O   LYS    92     -10.929   4.201   6.701  1.00 33.13           O 
ATOM   1437  CB  LYS    92     -10.233   5.419   9.682  1.00 65.22           C 
ATOM   1438  CG  LYS    92      -8.822   5.024   9.253  1.00 10.13           C 
ATOM   1439  CD  LYS    92      -7.794   6.078   9.659  1.00 64.52           C 
ATOM   1440  CE  LYS    92      -6.370   5.532   9.646  1.00  4.34           C 
ATOM   1441  NZ  LYS    92      -5.966   4.989   8.322  1.00 72.11           N 
ATOM   1442  H   LYS    92     -10.830   2.546   8.566  1.00 36.29           H 
ATOM   1443  HA  LYS    92     -12.281   4.811   9.543  1.00 11.11           H 
ATOM   1444 3HB  LYS    92     -10.293   5.338  10.759  1.00 36.29           H 
ATOM   1445 2HB  LYS    92     -10.396   6.451   9.402  1.00 36.29           H 
ATOM   1446 3HG  LYS    92      -8.801   4.907   8.176  1.00 36.29           H 
ATOM   1447 2HG  LYS    92      -8.565   4.084   9.720  1.00 36.29           H 
ATOM   1448 3HD  LYS    92      -8.024   6.427  10.656  1.00 36.29           H 
ATOM   1449 2HD  LYS    92      -7.852   6.907   8.967  1.00 36.29           H 
ATOM   1450 3HE  LYS    92      -6.301   4.743  10.378  1.00 36.29           H 
ATOM   1451 2HE  LYS    92      -5.692   6.326   9.915  1.00 36.29           H 
ATOM   1452 1HZ  LYS    92      -5.967   5.739   7.606  1.00 36.29           H 
ATOM   1453 2HZ  LYS    92      -6.620   4.235   8.030  1.00 36.29           H 
ATOM   1454 3HZ  LYS    92      -5.008   4.579   8.385  1.00 36.29           H 
ATOM   1455  N   LEU    93     -12.170   5.999   7.283  1.00 72.14           N 
ATOM   1456  CA  LEU    93     -12.288   6.540   5.919  1.00 12.31           C 
ATOM   1457  C   LEU    93     -11.469   7.838   5.779  1.00 10.13           C 
ATOM   1458  O   LEU    93     -11.050   8.430   6.777  1.00 42.13           O 
ATOM   1459  CB  LEU    93     -13.758   6.838   5.567  1.00  2.12           C 
ATOM   1460  CG  LEU    93     -14.729   5.640   5.568  1.00 63.13           C 
ATOM   1461  CD1 LEU    93     -14.168   4.482   4.754  1.00 23.14           C 
ATOM   1462  CD2 LEU    93     -15.068   5.202   6.993  1.00 50.42           C 
ATOM   1463  H   LEU    93     -12.626   6.467   8.016  1.00 36.29           H 
ATOM   1464  HA  LEU    93     -11.897   5.805   5.228  1.00 20.21           H 
ATOM   1465 3HB  LEU    93     -13.781   7.284   4.582  1.00 36.29           H 
ATOM   1466 2HB  LEU    93     -14.129   7.569   6.272  1.00 36.29           H 
ATOM   1467  HG  LEU    93     -15.652   5.949   5.093  1.00 22.03           H 
ATOM   1468 1HD1 LEU    93     -13.251   4.130   5.204  1.00 36.29           H 
ATOM   1469 2HD1 LEU    93     -13.968   4.815   3.745  1.00 36.29           H 
ATOM   1470 3HD1 LEU    93     -14.888   3.677   4.728  1.00 36.29           H 
ATOM   1471 1HD2 LEU    93     -15.746   4.363   6.959  1.00 36.29           H 
ATOM   1472 2HD2 LEU    93     -15.539   6.021   7.519  1.00 36.29           H 
ATOM   1473 3HD2 LEU    93     -14.165   4.913   7.510  1.00 36.29           H 
ATOM   1474  N   ASN    94     -11.246   8.277   4.540  1.00 74.35           N 
ATOM   1475  CA  ASN    94     -10.546   9.545   4.271  1.00 71.52           C 
ATOM   1476  C   ASN    94     -11.230  10.336   3.139  1.00 71.43           C 
ATOM   1477  O   ASN    94     -11.226   9.910   1.981  1.00 31.43           O 
ATOM   1478  CB  ASN    94      -9.078   9.279   3.908  1.00 32.31           C 
ATOM   1479  CG  ASN    94      -8.243   8.874   5.111  1.00 15.34           C 
ATOM   1480  OD1 ASN    94      -7.668   9.714   5.790  1.00  0.13           O 
ATOM   1481  ND2 ASN    94      -8.166   7.589   5.389  1.00 63.03           N 
ATOM   1482  H   ASN    94     -11.553   7.736   3.782  1.00 36.29           H 
ATOM   1483  HA  ASN    94     -10.579  10.141   5.175  1.00 70.10           H 
ATOM   1484 3HB  ASN    94      -8.649  10.176   3.483  1.00 36.29           H 
ATOM   1485 2HB  ASN    94      -9.031   8.485   3.177  1.00 36.29           H 
ATOM   1486 1HD2 ASN    94      -8.646   6.957   4.816  1.00 36.29           H 
ATOM   1487 2HD2 ASN    94      -7.625   7.321   6.157  1.00 36.29           H 
ATOM   1488  N   GLY    95     -11.820  11.485   3.478  1.00 54.24           N 
ATOM   1489  CA  GLY    95     -12.478  12.324   2.472  1.00 52.34           C 
ATOM   1490  C   GLY    95     -13.424  13.363   3.078  1.00 12.22           C 
ATOM   1491  O   GLY    95     -13.213  13.825   4.199  1.00 53.41           O 
ATOM   1492  H   GLY    95     -11.815  11.767   4.419  1.00 36.29           H 
ATOM   1493 3HA  GLY    95     -13.044  11.689   1.803  1.00 36.29           H 
ATOM   1494 2HA  GLY    95     -11.721  12.841   1.901  1.00 36.29           H 
ATOM   1495  N   GLY    96     -14.465  13.735   2.330  1.00 32.53           N 
ATOM   1496  CA  GLY    96     -15.456  14.691   2.826  1.00 24.42           C 
ATOM   1497  C   GLY    96     -16.753  14.021   3.281  1.00 74.23           C 
ATOM   1498  O   GLY    96     -16.880  12.797   3.213  1.00 22.41           O 
ATOM   1499  H   GLY    96     -14.565  13.355   1.434  1.00 36.29           H 
ATOM   1500 3HA  GLY    96     -15.685  15.392   2.035  1.00 36.29           H 
ATOM   1501 2HA  GLY    96     -15.036  15.236   3.660  1.00 36.29           H 
ATOM   1502  N   ARG    97     -17.730  14.818   3.722  1.00 73.32           N 
ATOM   1503  CA  ARG    97     -18.994  14.277   4.247  1.00  2.04           C 
ATOM   1504  C   ARG    97     -19.796  13.532   3.167  1.00  2.23           C 
ATOM   1505  O   ARG    97     -20.404  12.500   3.447  1.00 53.11           O 
ATOM   1506  CB  ARG    97     -19.858  15.386   4.873  1.00 45.22           C 
ATOM   1507  CG  ARG    97     -21.094  14.854   5.602  1.00  2.20           C 
ATOM   1508  CD  ARG    97     -21.859  15.957   6.332  1.00 61.12           C 
ATOM   1509  NE  ARG    97     -22.452  16.926   5.413  1.00 32.33           N 
ATOM   1510  CZ  ARG    97     -23.273  17.873   5.779  1.00 32.33           C 
ATOM   1511  NH1 ARG    97     -23.609  18.015   7.020  1.00  3.21           N 
ATOM   1512  NH2 ARG    97     -23.765  18.679   4.900  1.00 11.43           N 
ATOM   1513  H   ARG    97     -17.601  15.792   3.692  1.00 36.29           H 
ATOM   1514  HA  ARG    97     -18.737  13.568   5.022  1.00 11.03           H 
ATOM   1515 3HB  ARG    97     -20.185  16.059   4.092  1.00 36.29           H 
ATOM   1516 2HB  ARG    97     -19.256  15.939   5.582  1.00 36.29           H 
ATOM   1517 3HG  ARG    97     -20.782  14.109   6.321  1.00 36.29           H 
ATOM   1518 2HG  ARG    97     -21.754  14.397   4.878  1.00 36.29           H 
ATOM   1519 3HD  ARG    97     -21.177  16.472   6.995  1.00 36.29           H 
ATOM   1520 2HD  ARG    97     -22.648  15.503   6.916  1.00 36.29           H 
ATOM   1521  HE  ARG    97     -22.222  16.856   4.465  1.00 42.04           H 
ATOM   1522 1HH1 ARG    97     -23.243  17.397   7.712  1.00 36.29           H 
ATOM   1523 2HH1 ARG    97     -24.232  18.749   7.284  1.00 36.29           H 
ATOM   1524 1HH2 ARG    97     -23.519  18.578   3.938  1.00 36.29           H 
ATOM   1525 2HH2 ARG    97     -24.400  19.396   5.185  1.00 36.29           H 
ATOM   1526  N   ARG    98     -19.806  14.050   1.935  1.00 62.12           N 
ATOM   1527  CA  ARG    98     -20.482  13.349   0.830  1.00 55.01           C 
ATOM   1528  C   ARG    98     -19.751  12.044   0.482  1.00  3.21           C 
ATOM   1529  O   ARG    98     -20.380  11.035   0.162  1.00 61.24           O 
ATOM   1530  CB  ARG    98     -20.625  14.236  -0.421  1.00 33.50           C 
ATOM   1531  CG  ARG    98     -21.639  15.373  -0.262  1.00 43.41           C 
ATOM   1532  CD  ARG    98     -21.034  16.611   0.389  1.00 13.11           C 
ATOM   1533  NE  ARG    98     -20.195  17.358  -0.542  1.00 50.33           N 
ATOM   1534  CZ  ARG    98     -19.689  18.532  -0.290  1.00 64.24           C 
ATOM   1535  NH1 ARG    98     -19.838  19.083   0.871  1.00  3.54           N 
ATOM   1536  NH2 ARG    98     -19.019  19.154  -1.203  1.00 71.21           N 
ATOM   1537  H   ARG    98     -19.350  14.902   1.768  1.00 36.29           H 
ATOM   1538  HA  ARG    98     -21.473  13.091   1.181  1.00 32.24           H 
ATOM   1539 3HB  ARG    98     -20.939  13.618  -1.252  1.00 36.29           H 
ATOM   1540 2HB  ARG    98     -19.662  14.668  -0.655  1.00 36.29           H 
ATOM   1541 3HG  ARG    98     -22.461  15.023   0.349  1.00 36.29           H 
ATOM   1542 2HG  ARG    98     -22.012  15.645  -1.238  1.00 36.29           H 
ATOM   1543 3HD  ARG    98     -20.434  16.305   1.235  1.00 36.29           H 
ATOM   1544 2HD  ARG    98     -21.834  17.252   0.731  1.00 36.29           H 
ATOM   1545  HE  ARG    98     -20.026  16.961  -1.422  1.00 13.21           H 
ATOM   1546 1HH1 ARG    98     -20.345  18.610   1.587  1.00 36.29           H 
ATOM   1547 2HH1 ARG    98     -19.436  19.980   1.050  1.00 36.29           H 
ATOM   1548 1HH2 ARG    98     -18.895  18.737  -2.100  1.00 36.29           H 
ATOM   1549 2HH2 ARG    98     -18.633  20.053  -1.007  1.00 36.29           H 
ATOM   1550  N   PHE    99     -18.419  12.069   0.562  1.00  1.52           N 
ATOM   1551  CA  PHE    99     -17.618  10.848   0.421  1.00 14.23           C 
ATOM   1552  C   PHE    99     -18.048   9.806   1.468  1.00  3.12           C 
ATOM   1553  O   PHE    99     -18.276   8.636   1.148  1.00 43.23           O 
ATOM   1554  CB  PHE    99     -16.122  11.175   0.572  1.00 22.30           C 
ATOM   1555  CG  PHE    99     -15.220   9.964   0.535  1.00 62.53           C 
ATOM   1556  CD1 PHE    99     -14.787   9.438  -0.674  1.00 42.43           C 
ATOM   1557  CD2 PHE    99     -14.806   9.350   1.711  1.00 75.53           C 
ATOM   1558  CE1 PHE    99     -13.964   8.330  -0.711  1.00 72.43           C 
ATOM   1559  CE2 PHE    99     -13.982   8.242   1.679  1.00 20.21           C 
ATOM   1560  CZ  PHE    99     -13.562   7.731   0.467  1.00 72.42           C 
ATOM   1561  H   PHE    99     -17.965  12.923   0.714  1.00 36.29           H 
ATOM   1562  HA  PHE    99     -17.796  10.446  -0.568  1.00 12.34           H 
ATOM   1563 3HB  PHE    99     -15.966  11.678   1.516  1.00 36.29           H 
ATOM   1564 2HB  PHE    99     -15.823  11.835  -0.231  1.00 36.29           H 
ATOM   1565  HD1 PHE    99     -15.099   9.905  -1.597  1.00 15.13           H 
ATOM   1566  HD2 PHE    99     -15.135   9.749   2.661  1.00 32.43           H 
ATOM   1567  HE1 PHE    99     -13.636   7.931  -1.661  1.00  0.33           H 
ATOM   1568  HE2 PHE    99     -13.669   7.775   2.601  1.00 65.04           H 
ATOM   1569  HZ  PHE    99     -12.918   6.864   0.441  1.00 12.14           H 
ATOM   1570  N   LEU   100     -18.162  10.248   2.723  1.00 42.30           N 
ATOM   1571  CA  LEU   100     -18.650   9.387   3.806  1.00  4.13           C 
ATOM   1572  C   LEU   100     -20.083   8.916   3.529  1.00 51.22           C 
ATOM   1573  O   LEU   100     -20.413   7.754   3.746  1.00  4.33           O 
ATOM   1574  CB  LEU   100     -18.603  10.130   5.151  1.00 24.23           C 
ATOM   1575  CG  LEU   100     -17.214  10.620   5.591  1.00 21.10           C 
ATOM   1576  CD1 LEU   100     -17.297  11.336   6.937  1.00 11.20           C 
ATOM   1577  CD2 LEU   100     -16.222   9.459   5.656  1.00 32.53           C 
ATOM   1578  H   LEU   100     -17.907  11.174   2.928  1.00 36.29           H 
ATOM   1579  HA  LEU   100     -18.001   8.523   3.859  1.00  2.21           H 
ATOM   1580 3HB  LEU   100     -18.987   9.470   5.917  1.00 36.29           H 
ATOM   1581 2HB  LEU   100     -19.259  10.989   5.082  1.00 36.29           H 
ATOM   1582  HG  LEU   100     -16.846  11.330   4.864  1.00 45.44           H 
ATOM   1583 1HD1 LEU   100     -17.651  10.649   7.693  1.00 36.29           H 
ATOM   1584 2HD1 LEU   100     -17.979  12.171   6.861  1.00 36.29           H 
ATOM   1585 3HD1 LEU   100     -16.316  11.698   7.212  1.00 36.29           H 
ATOM   1586 1HD2 LEU   100     -15.255   9.828   5.969  1.00 36.29           H 
ATOM   1587 2HD2 LEU   100     -16.132   9.004   4.680  1.00 36.29           H 
ATOM   1588 3HD2 LEU   100     -16.572   8.721   6.364  1.00 36.29           H 
ATOM   1589  N   PHE   101     -20.920   9.825   3.030  1.00 25.05           N 
ATOM   1590  CA  PHE   101     -22.321   9.517   2.717  1.00 22.40           C 
ATOM   1591  C   PHE   101     -22.424   8.284   1.810  1.00 32.10           C 
ATOM   1592  O   PHE   101     -23.216   7.374   2.069  1.00 63.25           O 
ATOM   1593  CB  PHE   101     -22.979  10.728   2.043  1.00 62.32           C 
ATOM   1594  CG  PHE   101     -24.419  10.516   1.638  1.00 44.44           C 
ATOM   1595  CD1 PHE   101     -24.744  10.119   0.345  1.00 11.13           C 
ATOM   1596  CD2 PHE   101     -25.447  10.716   2.547  1.00  3.51           C 
ATOM   1597  CE1 PHE   101     -26.062   9.928  -0.027  1.00 71.41           C 
ATOM   1598  CE2 PHE   101     -26.766  10.527   2.179  1.00 53.41           C 
ATOM   1599  CZ  PHE   101     -27.075  10.131   0.891  1.00 10.35           C 
ATOM   1600  H   PHE   101     -20.586  10.731   2.866  1.00 36.29           H 
ATOM   1601  HA  PHE   101     -22.830   9.310   3.648  1.00 74.20           H 
ATOM   1602 3HB  PHE   101     -22.417  10.980   1.154  1.00 36.29           H 
ATOM   1603 2HB  PHE   101     -22.947  11.566   2.724  1.00 36.29           H 
ATOM   1604  HD1 PHE   101     -23.954   9.957  -0.374  1.00  1.30           H 
ATOM   1605  HD2 PHE   101     -25.212  11.026   3.556  1.00 41.52           H 
ATOM   1606  HE1 PHE   101     -26.301   9.619  -1.036  1.00 14.35           H 
ATOM   1607  HE2 PHE   101     -27.556  10.687   2.900  1.00 15.01           H 
ATOM   1608  HZ  PHE   101     -28.106   9.983   0.604  1.00 60.20           H 
ATOM   1609  N   ARG   102     -21.614   8.258   0.753  1.00 23.35           N 
ATOM   1610  CA  ARG   102     -21.536   7.094  -0.134  1.00 23.31           C 
ATOM   1611  C   ARG   102     -21.221   5.817   0.657  1.00 61.20           C 
ATOM   1612  O   ARG   102     -21.913   4.811   0.529  1.00  4.51           O 
ATOM   1613  CB  ARG   102     -20.459   7.310  -1.207  1.00 65.14           C 
ATOM   1614  CG  ARG   102     -20.798   8.403  -2.213  1.00 73.23           C 
ATOM   1615  CD  ARG   102     -22.003   8.029  -3.071  1.00  0.12           C 
ATOM   1616  NE  ARG   102     -22.336   9.077  -4.032  1.00 33.22           N 
ATOM   1617  CZ  ARG   102     -22.683   8.860  -5.272  1.00 43.40           C 
ATOM   1618  NH1 ARG   102     -22.703   7.655  -5.753  1.00  1.11           N 
ATOM   1619  NH2 ARG   102     -22.993   9.855  -6.034  1.00 44.44           N 
ATOM   1620  H   ARG   102     -21.055   9.043   0.563  1.00 36.29           H 
ATOM   1621  HA  ARG   102     -22.497   6.979  -0.618  1.00 14.34           H 
ATOM   1622 3HB  ARG   102     -20.315   6.384  -1.750  1.00 36.29           H 
ATOM   1623 2HB  ARG   102     -19.533   7.576  -0.719  1.00 36.29           H 
ATOM   1624 3HG  ARG   102     -19.945   8.563  -2.859  1.00 36.29           H 
ATOM   1625 2HG  ARG   102     -21.019   9.316  -1.679  1.00 36.29           H 
ATOM   1626 3HD  ARG   102     -22.854   7.865  -2.423  1.00 36.29           H 
ATOM   1627 2HD  ARG   102     -21.780   7.116  -3.605  1.00 36.29           H 
ATOM   1628  HE  ARG   102     -22.307  10.004  -3.716  1.00 40.12           H 
ATOM   1629 1HH1 ARG   102     -22.449   6.881  -5.177  1.00 36.29           H 
ATOM   1630 2HH1 ARG   102     -22.973   7.501  -6.702  1.00 36.29           H 
ATOM   1631 1HH2 ARG   102     -22.969  10.786  -5.671  1.00 36.29           H 
ATOM   1632 2HH2 ARG   102     -23.254   9.695  -6.984  1.00 36.29           H 
ATOM   1633  N   MET   103     -20.186   5.883   1.488  1.00 12.52           N 
ATOM   1634  CA  MET   103     -19.735   4.728   2.273  1.00 72.25           C 
ATOM   1635  C   MET   103     -20.818   4.229   3.246  1.00  2.14           C 
ATOM   1636  O   MET   103     -21.065   3.023   3.350  1.00 24.21           O 
ATOM   1637  CB  MET   103     -18.454   5.093   3.030  1.00 24.22           C 
ATOM   1638  CG  MET   103     -17.340   5.557   2.103  1.00 44.15           C 
ATOM   1639  SD  MET   103     -17.028   4.377   0.772  1.00 62.20           S 
ATOM   1640  CE  MET   103     -16.022   5.358  -0.338  1.00 74.41           C 
ATOM   1641  H   MET   103     -19.708   6.735   1.580  1.00 36.29           H 
ATOM   1642  HA  MET   103     -19.509   3.931   1.578  1.00  4.15           H 
ATOM   1643 3HB  MET   103     -18.106   4.228   3.575  1.00 36.29           H 
ATOM   1644 2HB  MET   103     -18.673   5.889   3.730  1.00 36.29           H 
ATOM   1645 3HG  MET   103     -16.432   5.681   2.679  1.00 36.29           H 
ATOM   1646 2HG  MET   103     -17.621   6.505   1.667  1.00 36.29           H 
ATOM   1647 1HE  MET   103     -15.753   4.765  -1.199  1.00 36.29           H 
ATOM   1648 2HE  MET   103     -15.127   5.675   0.174  1.00 36.29           H 
ATOM   1649 3HE  MET   103     -16.579   6.226  -0.659  1.00 36.29           H 
ATOM   1650  N   LYS   104     -21.477   5.159   3.936  1.00 52.44           N 
ATOM   1651  CA  LYS   104     -22.549   4.815   4.877  1.00 31.44           C 
ATOM   1652  C   LYS   104     -23.705   4.105   4.153  1.00 43.24           C 
ATOM   1653  O   LYS   104     -24.244   3.104   4.634  1.00 41.13           O 
ATOM   1654  CB  LYS   104     -23.070   6.081   5.579  1.00 61.35           C 
ATOM   1655  CG  LYS   104     -21.973   6.933   6.218  1.00 50.22           C 
ATOM   1656  CD  LYS   104     -22.539   8.142   6.969  1.00 61.35           C 
ATOM   1657  CE  LYS   104     -22.892   7.817   8.420  1.00 53.34           C 
ATOM   1658  NZ  LYS   104     -23.861   6.695   8.543  1.00 30.53           N 
ATOM   1659  H   LYS   104     -21.233   6.099   3.812  1.00 36.29           H 
ATOM   1660  HA  LYS   104     -22.137   4.144   5.619  1.00 41.12           H 
ATOM   1661 3HB  LYS   104     -23.764   5.787   6.354  1.00 36.29           H 
ATOM   1662 2HB  LYS   104     -23.593   6.691   4.855  1.00 36.29           H 
ATOM   1663 3HG  LYS   104     -21.309   7.283   5.442  1.00 36.29           H 
ATOM   1664 2HG  LYS   104     -21.415   6.319   6.912  1.00 36.29           H 
ATOM   1665 3HD  LYS   104     -23.431   8.483   6.461  1.00 36.29           H 
ATOM   1666 2HD  LYS   104     -21.802   8.934   6.964  1.00 36.29           H 
ATOM   1667 3HE  LYS   104     -23.319   8.698   8.877  1.00 36.29           H 
ATOM   1668 2HE  LYS   104     -21.987   7.549   8.944  1.00 36.29           H 
ATOM   1669 1HZ  LYS   104     -23.460   5.824   8.137  1.00 36.29           H 
ATOM   1670 2HZ  LYS   104     -24.742   6.924   8.043  1.00 36.29           H 
ATOM   1671 3HZ  LYS   104     -24.080   6.523   9.545  1.00 36.29           H 
ATOM   1672  N   ASN   105     -24.075   4.625   2.986  1.00 31.44           N 
ATOM   1673  CA  ASN   105     -25.150   4.039   2.179  1.00 20.54           C 
ATOM   1674  C   ASN   105     -24.684   2.767   1.446  1.00 62.14           C 
ATOM   1675  O   ASN   105     -25.498   1.920   1.088  1.00 23.42           O 
ATOM   1676  CB  ASN   105     -25.686   5.077   1.183  1.00 52.13           C 
ATOM   1677  CG  ASN   105     -26.582   6.111   1.848  1.00 71.04           C 
ATOM   1678  OD1 ASN   105     -27.800   5.955   1.901  1.00  2.24           O 
ATOM   1679  ND2 ASN   105     -25.995   7.167   2.371  1.00 13.41           N 
ATOM   1680  H   ASN   105     -23.611   5.424   2.654  1.00 36.29           H 
ATOM   1681  HA  ASN   105     -25.950   3.764   2.854  1.00 51.30           H 
ATOM   1682 3HB  ASN   105     -26.259   4.573   0.415  1.00 36.29           H 
ATOM   1683 2HB  ASN   105     -24.854   5.590   0.725  1.00 36.29           H 
ATOM   1684 1HD2 ASN   105     -25.024   7.236   2.304  1.00 36.29           H 
ATOM   1685 2HD2 ASN   105     -26.558   7.835   2.813  1.00 36.29           H 
ATOM   1686  N   LEU   106     -23.375   2.636   1.222  1.00 21.42           N 
ATOM   1687  CA  LEU   106     -22.816   1.444   0.563  1.00 42.00           C 
ATOM   1688  C   LEU   106     -22.699   0.252   1.528  1.00 44.44           C 
ATOM   1689  O   LEU   106     -22.835  -0.898   1.110  1.00 43.31           O 
ATOM   1690  CB  LEU   106     -21.445   1.755  -0.071  1.00 52.23           C 
ATOM   1691  CG  LEU   106     -21.443   1.918  -1.603  1.00 73.13           C 
ATOM   1692  CD1 LEU   106     -21.900   0.628  -2.282  1.00 25.24           C 
ATOM   1693  CD2 LEU   106     -22.324   3.088  -2.033  1.00  3.23           C 
ATOM   1694  H   LEU   106     -22.770   3.358   1.496  1.00 36.29           H 
ATOM   1695  HA  LEU   106     -23.502   1.167  -0.226  1.00 11.44           H 
ATOM   1696 3HB  LEU   106     -20.760   0.956   0.180  1.00 36.29           H 
ATOM   1697 2HB  LEU   106     -21.070   2.671   0.366  1.00 36.29           H 
ATOM   1698  HG  LEU   106     -20.432   2.124  -1.933  1.00 24.21           H 
ATOM   1699 1HD1 LEU   106     -21.863   0.753  -3.355  1.00 36.29           H 
ATOM   1700 2HD1 LEU   106     -22.914   0.401  -1.983  1.00 36.29           H 
ATOM   1701 3HD1 LEU   106     -21.250  -0.184  -1.992  1.00 36.29           H 
ATOM   1702 1HD2 LEU   106     -22.302   3.179  -3.108  1.00 36.29           H 
ATOM   1703 2HD2 LEU   106     -21.955   4.002  -1.588  1.00 36.29           H 
ATOM   1704 3HD2 LEU   106     -23.341   2.915  -1.706  1.00 36.29           H 
ATOM   1705  N   GLY   107     -22.443   0.524   2.808  1.00  4.41           N 
ATOM   1706  CA  GLY   107     -22.387  -0.549   3.803  1.00 75.00           C 
ATOM   1707  C   GLY   107     -21.149  -0.519   4.700  1.00 52.23           C 
ATOM   1708  O   GLY   107     -21.050  -1.299   5.650  1.00 74.33           O 
ATOM   1709  H   GLY   107     -22.303   1.456   3.083  1.00 36.29           H 
ATOM   1710 3HA  GLY   107     -22.415  -1.503   3.292  1.00 36.29           H 
ATOM   1711 2HA  GLY   107     -23.262  -0.474   4.431  1.00 36.29           H 
ATOM   1712  N   ILE   108     -20.204   0.376   4.419  1.00 20.43           N 
ATOM   1713  CA  ILE   108     -18.974   0.469   5.217  1.00 25.42           C 
ATOM   1714  C   ILE   108     -19.059   1.595   6.264  1.00 11.24           C 
ATOM   1715  O   ILE   108     -18.589   2.710   6.045  1.00  1.10           O 
ATOM   1716  CB  ILE   108     -17.688   0.643   4.345  1.00 45.21           C 
ATOM   1717  CG1 ILE   108     -17.897   1.640   3.187  1.00 21.42           C 
ATOM   1718  CG2 ILE   108     -17.203  -0.706   3.815  1.00 34.33           C 
ATOM   1719  CD1 ILE   108     -18.544   1.050   1.944  1.00  2.54           C 
ATOM   1720  H   ILE   108     -20.345   1.003   3.682  1.00 36.29           H 
ATOM   1721  HA  ILE   108     -18.876  -0.468   5.753  1.00 13.33           H 
ATOM   1722  HB  ILE   108     -16.911   1.029   4.991  1.00 72.34           H 
ATOM   1723 3HG1 ILE   108     -16.937   2.045   2.896  1.00 36.29           H 
ATOM   1724 2HG1 ILE   108     -18.527   2.450   3.527  1.00 36.29           H 
ATOM   1725 1HG2 ILE   108     -16.975  -1.359   4.646  1.00 36.29           H 
ATOM   1726 2HG2 ILE   108     -16.312  -0.561   3.220  1.00 36.29           H 
ATOM   1727 3HG2 ILE   108     -17.973  -1.156   3.206  1.00 36.29           H 
ATOM   1728 1HD1 ILE   108     -19.481   0.582   2.206  1.00 36.29           H 
ATOM   1729 2HD1 ILE   108     -17.883   0.316   1.509  1.00 36.29           H 
ATOM   1730 3HD1 ILE   108     -18.726   1.838   1.228  1.00 36.29           H 
ATOM   1731  N   GLU   109     -19.687   1.289   7.400  1.00 14.42           N 
ATOM   1732  CA  GLU   109     -19.801   2.238   8.518  1.00 50.05           C 
ATOM   1733  C   GLU   109     -18.596   2.127   9.468  1.00  1.42           C 
ATOM   1734  O   GLU   109     -17.716   2.992   9.483  1.00  4.22           O 
ATOM   1735  CB  GLU   109     -21.106   1.977   9.291  1.00  3.31           C 
ATOM   1736  CG  GLU   109     -22.377   2.245   8.484  1.00 43.33           C 
ATOM   1737  CD  GLU   109     -22.791   3.711   8.481  1.00  3.32           C 
ATOM   1738  OE1 GLU   109     -21.915   4.593   8.387  1.00 72.11           O 
ATOM   1739  OE2 GLU   109     -24.007   3.992   8.566  1.00  1.44           O 
ATOM   1740  H   GLU   109     -20.100   0.406   7.486  1.00 36.29           H 
ATOM   1741  HA  GLU   109     -19.831   3.239   8.107  1.00 55.04           H 
ATOM   1742 3HB  GLU   109     -21.124   2.609  10.170  1.00 36.29           H 
ATOM   1743 2HB  GLU   109     -21.119   0.946   9.605  1.00 36.29           H 
ATOM   1744 3HG  GLU   109     -23.181   1.659   8.909  1.00 36.29           H 
ATOM   1745 2HG  GLU   109     -22.213   1.933   7.463  1.00 36.29           H 
ATOM   1746  N   SER   110     -18.565   1.053  10.262  1.00 74.22           N 
ATOM   1747  CA  SER   110     -17.453   0.801  11.195  1.00  3.13           C 
ATOM   1748  C   SER   110     -17.450  -0.658  11.674  1.00  5.11           C 
ATOM   1749  O   SER   110     -18.506  -1.248  11.904  1.00 60.41           O 
ATOM   1750  CB  SER   110     -17.540   1.734  12.410  1.00 63.23           C 
ATOM   1751  OG  SER   110     -18.701   1.469  13.185  1.00 53.02           O 
ATOM   1752  H   SER   110     -19.312   0.418  10.232  1.00 36.29           H 
ATOM   1753  HA  SER   110     -16.529   0.997  10.666  1.00 72.12           H 
ATOM   1754 3HB  SER   110     -17.577   2.760  12.072  1.00 36.29           H 
ATOM   1755 2HB  SER   110     -16.669   1.595  13.035  1.00 36.29           H 
ATOM   1756  HG  SER   110     -18.448   1.331  14.105  1.00  0.43           H 
ATOM   1757  N   GLY   111     -16.258  -1.245  11.800  1.00  4.32           N 
ATOM   1758  CA  GLY   111     -16.133  -2.618  12.298  1.00 61.43           C 
ATOM   1759  C   GLY   111     -16.562  -3.693  11.296  1.00 32.32           C 
ATOM   1760  O   GLY   111     -16.359  -4.884  11.537  1.00 51.22           O 
ATOM   1761  H   GLY   111     -15.451  -0.741  11.562  1.00 36.29           H 
ATOM   1762 3HA  GLY   111     -16.736  -2.717  13.191  1.00 36.29           H 
ATOM   1763 2HA  GLY   111     -15.101  -2.790  12.563  1.00 36.29           H 
ATOM   1764  N   LYS   112     -17.154  -3.275  10.176  1.00  3.11           N 
ATOM   1765  CA  LYS   112     -17.630  -4.205   9.140  1.00 34.24           C 
ATOM   1766  C   LYS   112     -16.499  -5.083   8.579  1.00 41.42           C 
ATOM   1767  O   LYS   112     -15.406  -4.595   8.279  1.00  3.25           O 
ATOM   1768  CB  LYS   112     -18.284  -3.424   7.988  1.00 61.22           C 
ATOM   1769  CG  LYS   112     -19.630  -2.792   8.335  1.00 31.01           C 
ATOM   1770  CD  LYS   112     -20.692  -3.852   8.620  1.00 72.52           C 
ATOM   1771  CE  LYS   112     -22.077  -3.237   8.779  1.00 40.15           C 
ATOM   1772  NZ  LYS   112     -23.106  -4.266   9.079  1.00 34.21           N 
ATOM   1773  H   LYS   112     -17.277  -2.317  10.042  1.00 36.29           H 
ATOM   1774  HA  LYS   112     -18.374  -4.844   9.592  1.00 34.15           H 
ATOM   1775 3HB  LYS   112     -18.433  -4.096   7.154  1.00 36.29           H 
ATOM   1776 2HB  LYS   112     -17.612  -2.634   7.680  1.00 36.29           H 
ATOM   1777 3HG  LYS   112     -19.955  -2.184   7.501  1.00 36.29           H 
ATOM   1778 2HG  LYS   112     -19.509  -2.169   9.210  1.00 36.29           H 
ATOM   1779 3HD  LYS   112     -20.434  -4.374   9.532  1.00 36.29           H 
ATOM   1780 2HD  LYS   112     -20.717  -4.554   7.800  1.00 36.29           H 
ATOM   1781 3HE  LYS   112     -22.342  -2.732   7.860  1.00 36.29           H 
ATOM   1782 2HE  LYS   112     -22.051  -2.523   9.587  1.00 36.29           H 
ATOM   1783 1HZ  LYS   112     -22.943  -4.671  10.025  1.00 36.29           H 
ATOM   1784 2HZ  LYS   112     -23.065  -5.032   8.376  1.00 36.29           H 
ATOM   1785 3HZ  LYS   112     -24.052  -3.841   9.057  1.00 36.29           H 
ATOM   1786  N   LYS   113     -16.779  -6.379   8.432  1.00 22.32           N 
ATOM   1787  CA  LYS   113     -15.829  -7.313   7.820  1.00 63.22           C 
ATOM   1788  C   LYS   113     -15.988  -7.337   6.293  1.00 23.13           C 
ATOM   1789  O   LYS   113     -16.949  -7.896   5.759  1.00 61.52           O 
ATOM   1790  CB  LYS   113     -15.994  -8.726   8.407  1.00  2.21           C 
ATOM   1791  CG  LYS   113     -15.299  -8.923   9.757  1.00 33.44           C 
ATOM   1792  CD  LYS   113     -15.792  -7.940  10.821  1.00 54.34           C 
ATOM   1793  CE  LYS   113     -15.025  -8.083  12.130  1.00  4.32           C 
ATOM   1794  NZ  LYS   113     -15.512  -7.131  13.161  1.00 54.11           N 
ATOM   1795  H   LYS   113     -17.644  -6.720   8.747  1.00 36.29           H 
ATOM   1796  HA  LYS   113     -14.834  -6.959   8.052  1.00 65.00           H 
ATOM   1797 3HB  LYS   113     -15.582  -9.444   7.711  1.00 36.29           H 
ATOM   1798 2HB  LYS   113     -17.047  -8.932   8.535  1.00 36.29           H 
ATOM   1799 3HG  LYS   113     -14.234  -8.788   9.621  1.00 36.29           H 
ATOM   1800 2HG  LYS   113     -15.489  -9.930  10.101  1.00 36.29           H 
ATOM   1801 3HD  LYS   113     -16.841  -8.123  11.006  1.00 36.29           H 
ATOM   1802 2HD  LYS   113     -15.663  -6.932  10.453  1.00 36.29           H 
ATOM   1803 3HE  LYS   113     -13.977  -7.892  11.945  1.00 36.29           H 
ATOM   1804 2HE  LYS   113     -15.146  -9.090  12.499  1.00 36.29           H 
ATOM   1805 1HZ  LYS   113     -15.522  -6.165  12.778  1.00 36.29           H 
ATOM   1806 2HZ  LYS   113     -14.886  -7.154  13.991  1.00 36.29           H 
ATOM   1807 3HZ  LYS   113     -16.475  -7.385  13.461  1.00 36.29           H 
ATOM   1808  N   ILE   114     -15.030  -6.725   5.601  1.00 74.14           N 
ATOM   1809  CA  ILE   114     -15.084  -6.570   4.145  1.00  2.33           C 
ATOM   1810  C   ILE   114     -14.092  -7.515   3.433  1.00 44.51           C 
ATOM   1811  O   ILE   114     -12.929  -7.631   3.823  1.00 10.11           O 
ATOM   1812  CB  ILE   114     -14.806  -5.094   3.754  1.00 75.45           C 
ATOM   1813  CG1 ILE   114     -15.044  -4.862   2.251  1.00 52.12           C 
ATOM   1814  CG2 ILE   114     -13.387  -4.676   4.149  1.00 50.24           C 
ATOM   1815  CD1 ILE   114     -15.046  -3.397   1.856  1.00 54.51           C 
ATOM   1816  H   ILE   114     -14.261  -6.363   6.088  1.00 36.29           H 
ATOM   1817  HA  ILE   114     -16.087  -6.818   3.823  1.00 40.45           H 
ATOM   1818  HB  ILE   114     -15.493  -4.473   4.313  1.00  4.51           H 
ATOM   1819 3HG1 ILE   114     -16.002  -5.278   1.977  1.00 36.29           H 
ATOM   1820 2HG1 ILE   114     -14.268  -5.357   1.685  1.00 36.29           H 
ATOM   1821 1HG2 ILE   114     -13.260  -4.793   5.216  1.00 36.29           H 
ATOM   1822 2HG2 ILE   114     -13.224  -3.642   3.880  1.00 36.29           H 
ATOM   1823 3HG2 ILE   114     -12.670  -5.299   3.633  1.00 36.29           H 
ATOM   1824 1HD1 ILE   114     -14.090  -2.956   2.098  1.00 36.29           H 
ATOM   1825 2HD1 ILE   114     -15.828  -2.878   2.392  1.00 36.29           H 
ATOM   1826 3HD1 ILE   114     -15.222  -3.312   0.794  1.00 36.29           H 
ATOM   1827  N   GLN   115     -14.574  -8.211   2.405  1.00  1.25           N 
ATOM   1828  CA  GLN   115     -13.751  -9.165   1.648  1.00 51.53           C 
ATOM   1829  C   GLN   115     -13.154  -8.520   0.389  1.00 75.21           C 
ATOM   1830  O   GLN   115     -13.791  -7.684  -0.255  1.00 13.35           O 
ATOM   1831  CB  GLN   115     -14.577 -10.397   1.244  1.00 52.33           C 
ATOM   1832  CG  GLN   115     -15.051 -11.264   2.410  1.00 22.45           C 
ATOM   1833  CD  GLN   115     -16.130 -10.612   3.259  1.00 10.23           C 
ATOM   1834  OE1 GLN   115     -17.318 -10.739   2.985  1.00 63.13           O 
ATOM   1835  NE2 GLN   115     -15.733  -9.933   4.312  1.00 14.31           N 
ATOM   1836  H   GLN   115     -15.512  -8.084   2.150  1.00 36.29           H 
ATOM   1837  HA  GLN   115     -12.940  -9.484   2.291  1.00 73.32           H 
ATOM   1838 3HB  GLN   115     -13.976 -11.016   0.591  1.00 36.29           H 
ATOM   1839 2HB  GLN   115     -15.449 -10.065   0.699  1.00 36.29           H 
ATOM   1840 3HG  GLN   115     -14.202 -11.486   3.042  1.00 36.29           H 
ATOM   1841 2HG  GLN   115     -15.444 -12.189   2.013  1.00 36.29           H 
ATOM   1842 1HE2 GLN   115     -14.776  -9.884   4.493  1.00 36.29           H 
ATOM   1843 2HE2 GLN   115     -16.416  -9.501   4.866  1.00 36.29           H 
ATOM   1844  N   VAL   116     -11.934  -8.924   0.035  1.00  5.30           N 
ATOM   1845  CA  VAL   116     -11.244  -8.398  -1.153  1.00 24.20           C 
ATOM   1846  C   VAL   116     -11.268  -9.405  -2.321  1.00 21.53           C 
ATOM   1847  O   VAL   116     -10.779 -10.529  -2.193  1.00 13.22           O 
ATOM   1848  CB  VAL   116      -9.771  -8.041  -0.822  1.00 43.21           C 
ATOM   1849  CG1 VAL   116      -9.035  -7.525  -2.059  1.00 45.14           C 
ATOM   1850  CG2 VAL   116      -9.703  -7.018   0.312  1.00 43.24           C 
ATOM   1851  H   VAL   116     -11.477  -9.594   0.590  1.00 36.29           H 
ATOM   1852  HA  VAL   116     -11.751  -7.491  -1.463  1.00 33.34           H 
ATOM   1853  HB  VAL   116      -9.273  -8.943  -0.491  1.00 74.23           H 
ATOM   1854 1HG1 VAL   116      -9.523  -6.632  -2.425  1.00 36.29           H 
ATOM   1855 2HG1 VAL   116      -9.048  -8.282  -2.830  1.00 36.29           H 
ATOM   1856 3HG1 VAL   116      -8.013  -7.293  -1.801  1.00 36.29           H 
ATOM   1857 1HG2 VAL   116     -10.200  -7.414   1.186  1.00 36.29           H 
ATOM   1858 2HG2 VAL   116     -10.191  -6.104   0.005  1.00 36.29           H 
ATOM   1859 3HG2 VAL   116      -8.669  -6.809   0.551  1.00 36.29           H 
ATOM   1860  N   SER   117     -11.834  -8.991  -3.459  1.00 32.24           N 
ATOM   1861  CA  SER   117     -11.877  -9.838  -4.666  1.00 71.32           C 
ATOM   1862  C   SER   117     -11.781  -8.999  -5.949  1.00 31.01           C 
ATOM   1863  O   SER   117     -12.653  -8.179  -6.231  1.00 51.43           O 
ATOM   1864  CB  SER   117     -13.166 -10.671  -4.702  1.00 71.42           C 
ATOM   1865  OG  SER   117     -13.264 -11.424  -5.904  1.00 75.11           O 
ATOM   1866  H   SER   117     -12.243  -8.099  -3.491  1.00 36.29           H 
ATOM   1867  HA  SER   117     -11.028 -10.510  -4.630  1.00 41.04           H 
ATOM   1868 3HB  SER   117     -14.019 -10.012  -4.635  1.00 36.29           H 
ATOM   1869 2HB  SER   117     -13.173 -11.353  -3.867  1.00 36.29           H 
ATOM   1870  HG  SER   117     -14.120 -11.872  -5.932  1.00 73.31           H 
ATOM   1871  N   GLY   118     -10.717  -9.213  -6.719  1.00 33.21           N 
ATOM   1872  CA  GLY   118     -10.530  -8.493  -7.977  1.00 12.42           C 
ATOM   1873  C   GLY   118     -10.578  -6.971  -7.828  1.00 74.20           C 
ATOM   1874  O   GLY   118      -9.735  -6.377  -7.158  1.00 20.33           O 
ATOM   1875  H   GLY   118     -10.053  -9.876  -6.438  1.00 36.29           H 
ATOM   1876 3HA  GLY   118     -11.303  -8.800  -8.669  1.00 36.29           H 
ATOM   1877 2HA  GLY   118      -9.571  -8.769  -8.390  1.00 36.29           H 
ATOM   1878  N   ARG   119     -11.570  -6.342  -8.460  1.00 25.32           N 
ATOM   1879  CA  ARG   119     -11.739  -4.883  -8.395  1.00 34.22           C 
ATOM   1880  C   ARG   119     -13.046  -4.488  -7.683  1.00  2.21           C 
ATOM   1881  O   ARG   119     -13.582  -3.404  -7.913  1.00 13.21           O 
ATOM   1882  CB  ARG   119     -11.711  -4.285  -9.810  1.00 42.40           C 
ATOM   1883  CG  ARG   119     -10.351  -4.386 -10.497  1.00 71.15           C 
ATOM   1884  CD  ARG   119      -9.283  -3.580  -9.762  1.00 32.30           C 
ATOM   1885  NE  ARG   119      -7.979  -3.672 -10.415  1.00 24.14           N 
ATOM   1886  CZ  ARG   119      -6.876  -3.167  -9.934  1.00 45.15           C 
ATOM   1887  NH1 ARG   119      -6.883  -2.491  -8.831  1.00 23.21           N 
ATOM   1888  NH2 ARG   119      -5.766  -3.322 -10.573  1.00 61.32           N 
ATOM   1889  H   ARG   119     -12.206  -6.872  -8.987  1.00 36.29           H 
ATOM   1890  HA  ARG   119     -10.909  -4.478  -7.832  1.00 21.42           H 
ATOM   1891 3HB  ARG   119     -11.984  -3.241  -9.755  1.00 36.29           H 
ATOM   1892 2HB  ARG   119     -12.437  -4.803 -10.422  1.00 36.29           H 
ATOM   1893 3HG  ARG   119     -10.439  -4.013 -11.507  1.00 36.29           H 
ATOM   1894 2HG  ARG   119     -10.047  -5.424 -10.522  1.00 36.29           H 
ATOM   1895 3HD  ARG   119      -9.198  -3.958  -8.751  1.00 36.29           H 
ATOM   1896 2HD  ARG   119      -9.590  -2.545  -9.734  1.00 36.29           H 
ATOM   1897  HE  ARG   119      -7.934  -4.155 -11.265  1.00 73.21           H 
ATOM   1898 1HH1 ARG   119      -7.737  -2.351  -8.338  1.00 36.29           H 
ATOM   1899 2HH1 ARG   119      -6.030  -2.114  -8.478  1.00 36.29           H 
ATOM   1900 1HH2 ARG   119      -5.751  -3.827 -11.434  1.00 36.29           H 
ATOM   1901 2HH2 ARG   119      -4.922  -2.939 -10.202  1.00 36.29           H 
ATOM   1902  N   ARG   120     -13.549  -5.366  -6.814  1.00 13.33           N 
ATOM   1903  CA  ARG   120     -14.733  -5.051  -6.004  1.00 42.34           C 
ATOM   1904  C   ARG   120     -14.646  -5.711  -4.618  1.00  2.33           C 
ATOM   1905  O   ARG   120     -14.144  -6.826  -4.471  1.00 12.04           O 
ATOM   1906  CB  ARG   120     -16.037  -5.467  -6.719  1.00  1.04           C 
ATOM   1907  CG  ARG   120     -16.304  -6.973  -6.772  1.00 73.22           C 
ATOM   1908  CD  ARG   120     -15.361  -7.713  -7.714  1.00 13.13           C 
ATOM   1909  NE  ARG   120     -15.606  -9.153  -7.688  1.00 42.00           N 
ATOM   1910  CZ  ARG   120     -15.171  -9.996  -8.582  1.00  4.14           C 
ATOM   1911  NH1 ARG   120     -14.451  -9.599  -9.583  1.00 52.34           N 
ATOM   1912  NH2 ARG   120     -15.455 -11.249  -8.463  1.00 14.03           N 
ATOM   1913  H   ARG   120     -13.113  -6.240  -6.707  1.00 36.29           H 
ATOM   1914  HA  ARG   120     -14.746  -3.977  -5.863  1.00 23.42           H 
ATOM   1915 3HB  ARG   120     -16.001  -5.097  -7.736  1.00 36.29           H 
ATOM   1916 2HB  ARG   120     -16.870  -5.000  -6.213  1.00 36.29           H 
ATOM   1917 3HG  ARG   120     -17.322  -7.130  -7.106  1.00 36.29           H 
ATOM   1918 2HG  ARG   120     -16.190  -7.382  -5.779  1.00 36.29           H 
ATOM   1919 3HD  ARG   120     -14.340  -7.525  -7.412  1.00 36.29           H 
ATOM   1920 2HD  ARG   120     -15.514  -7.346  -8.720  1.00 36.29           H 
ATOM   1921  HE  ARG   120     -16.141  -9.504  -6.947  1.00 73.14           H 
ATOM   1922 1HH1 ARG   120     -14.218  -8.637  -9.681  1.00 36.29           H 
ATOM   1923 2HH1 ARG   120     -14.127 -10.264 -10.254  1.00 36.29           H 
ATOM   1924 1HH2 ARG   120     -15.997 -11.567  -7.686  1.00 36.29           H 
ATOM   1925 2HH2 ARG   120     -15.140 -11.897  -9.151  1.00 36.29           H 
ATOM   1926  N   TYR   121     -15.137  -5.016  -3.602  1.00 61.44           N 
ATOM   1927  CA  TYR   121     -15.057  -5.499  -2.222  1.00 32.34           C 
ATOM   1928  C   TYR   121     -16.448  -5.885  -1.695  1.00  1.31           C 
ATOM   1929  O   TYR   121     -17.450  -5.283  -2.075  1.00 44.54           O 
ATOM   1930  CB  TYR   121     -14.417  -4.424  -1.344  1.00 31.21           C 
ATOM   1931  CG  TYR   121     -13.079  -3.945  -1.877  1.00 42.15           C 
ATOM   1932  CD1 TYR   121     -12.994  -2.810  -2.676  1.00 22.22           C 
ATOM   1933  CD2 TYR   121     -11.906  -4.634  -1.594  1.00 22.31           C 
ATOM   1934  CE1 TYR   121     -11.781  -2.375  -3.174  1.00 31.53           C 
ATOM   1935  CE2 TYR   121     -10.689  -4.204  -2.089  1.00 43.00           C 
ATOM   1936  CZ  TYR   121     -10.632  -3.074  -2.881  1.00  2.42           C 
ATOM   1937  OH  TYR   121      -9.422  -2.638  -3.372  1.00 23.02           O 
ATOM   1938  H   TYR   121     -15.566  -4.155  -3.780  1.00 36.29           H 
ATOM   1939  HA  TYR   121     -14.427  -6.380  -2.211  1.00 55.21           H 
ATOM   1940 3HB  TYR   121     -14.258  -4.820  -0.351  1.00 36.29           H 
ATOM   1941 2HB  TYR   121     -15.080  -3.571  -1.285  1.00 36.29           H 
ATOM   1942  HD1 TYR   121     -13.895  -2.262  -2.907  1.00 60.30           H 
ATOM   1943  HD2 TYR   121     -11.951  -5.517  -0.975  1.00 15.43           H 
ATOM   1944  HE1 TYR   121     -11.738  -1.491  -3.792  1.00 70.53           H 
ATOM   1945  HE2 TYR   121      -9.787  -4.756  -1.858  1.00  2.23           H 
ATOM   1946  HH  TYR   121      -8.912  -3.391  -3.682  1.00 11.12           H 
ATOM   1947  N   TYR   122     -16.508  -6.891  -0.824  1.00 71.12           N 
ATOM   1948  CA  TYR   122     -17.792  -7.460  -0.385  1.00  4.51           C 
ATOM   1949  C   TYR   122     -18.089  -7.192   1.101  1.00 13.21           C 
ATOM   1950  O   TYR   122     -17.336  -7.607   1.982  1.00  0.03           O 
ATOM   1951  CB  TYR   122     -17.802  -8.974  -0.641  1.00 41.43           C 
ATOM   1952  CG  TYR   122     -17.747  -9.356  -2.112  1.00 23.53           C 
ATOM   1953  CD1 TYR   122     -16.604  -9.120  -2.870  1.00 42.45           C 
ATOM   1954  CD2 TYR   122     -18.835  -9.954  -2.740  1.00 52.10           C 
ATOM   1955  CE1 TYR   122     -16.549  -9.467  -4.203  1.00 23.30           C 
ATOM   1956  CE2 TYR   122     -18.784 -10.306  -4.077  1.00  0.13           C 
ATOM   1957  CZ  TYR   122     -17.638 -10.058  -4.803  1.00 42.13           C 
ATOM   1958  OH  TYR   122     -17.582 -10.400  -6.136  1.00 14.43           O 
ATOM   1959  H   TYR   122     -15.673  -7.263  -0.471  1.00 36.29           H 
ATOM   1960  HA  TYR   122     -18.576  -7.007  -0.979  1.00 54.24           H 
ATOM   1961 3HB  TYR   122     -18.702  -9.398  -0.219  1.00 36.29           H 
ATOM   1962 2HB  TYR   122     -16.943  -9.417  -0.153  1.00 36.29           H 
ATOM   1963  HD1 TYR   122     -15.750  -8.654  -2.400  1.00 52.42           H 
ATOM   1964  HD2 TYR   122     -19.731 -10.145  -2.169  1.00 51.21           H 
ATOM   1965  HE1 TYR   122     -15.651  -9.273  -4.773  1.00 34.31           H 
ATOM   1966  HE2 TYR   122     -19.640 -10.769  -4.546  1.00  1.05           H 
ATOM   1967  HH  TYR   122     -18.382 -10.089  -6.579  1.00 70.22           H 
ATOM   1968  N   ILE   123     -19.191  -6.496   1.363  1.00 61.04           N 
ATOM   1969  CA  ILE   123     -19.716  -6.327   2.724  1.00 61.25           C 
ATOM   1970  C   ILE   123     -20.884  -7.296   2.976  1.00 63.30           C 
ATOM   1971  O   ILE   123     -22.014  -7.048   2.550  1.00 15.23           O 
ATOM   1972  CB  ILE   123     -20.194  -4.867   2.978  1.00 74.12           C 
ATOM   1973  CG1 ILE   123     -18.997  -3.905   3.017  1.00 54.22           C 
ATOM   1974  CG2 ILE   123     -21.003  -4.765   4.277  1.00  1.41           C 
ATOM   1975  CD1 ILE   123     -18.094  -4.109   4.215  1.00 71.10           C 
ATOM   1976  H   ILE   123     -19.665  -6.070   0.620  1.00 36.29           H 
ATOM   1977  HA  ILE   123     -18.918  -6.552   3.422  1.00 35.31           H 
ATOM   1978  HB  ILE   123     -20.843  -4.582   2.160  1.00 71.41           H 
ATOM   1979 3HG1 ILE   123     -19.358  -2.886   3.042  1.00 36.29           H 
ATOM   1980 2HG1 ILE   123     -18.398  -4.045   2.128  1.00 36.29           H 
ATOM   1981 1HG2 ILE   123     -21.283  -3.735   4.449  1.00 36.29           H 
ATOM   1982 2HG2 ILE   123     -20.406  -5.118   5.105  1.00 36.29           H 
ATOM   1983 3HG2 ILE   123     -21.897  -5.370   4.197  1.00 36.29           H 
ATOM   1984 1HD1 ILE   123     -17.717  -5.122   4.218  1.00 36.29           H 
ATOM   1985 2HD1 ILE   123     -18.652  -3.930   5.122  1.00 36.29           H 
ATOM   1986 3HD1 ILE   123     -17.265  -3.418   4.162  1.00 36.29           H 
ATOM   1987  N   GLU   124     -20.594  -8.415   3.642  1.00 50.43           N 
ATOM   1988  CA  GLU   124     -21.624  -9.406   4.008  1.00 72.50           C 
ATOM   1989  C   GLU   124     -22.407  -9.922   2.781  1.00  0.51           C 
ATOM   1990  O   GLU   124     -23.582 -10.275   2.885  1.00  2.31           O 
ATOM   1991  CB  GLU   124     -22.587  -8.789   5.036  1.00  5.20           C 
ATOM   1992  CG  GLU   124     -21.883  -8.290   6.295  1.00 51.14           C 
ATOM   1993  CD  GLU   124     -22.824  -7.630   7.286  1.00 72.34           C 
ATOM   1994  OE1 GLU   124     -23.029  -6.398   7.200  1.00 62.23           O 
ATOM   1995  OE2 GLU   124     -23.355  -8.339   8.163  1.00  1.41           O 
ATOM   1996  H   GLU   124     -19.663  -8.580   3.904  1.00 36.29           H 
ATOM   1997  HA  GLU   124     -21.120 -10.243   4.466  1.00 14.23           H 
ATOM   1998 3HB  GLU   124     -23.315  -9.534   5.324  1.00 36.29           H 
ATOM   1999 2HB  GLU   124     -23.100  -7.953   4.578  1.00 36.29           H 
ATOM   2000 3HG  GLU   124     -21.125  -7.576   6.007  1.00 36.29           H 
ATOM   2001 2HG  GLU   124     -21.410  -9.132   6.782  1.00 36.29           H 
ATOM   2002  N   GLY   125     -21.740  -9.994   1.628  1.00 34.43           N 
ATOM   2003  CA  GLY   125     -22.396 -10.443   0.395  1.00 11.53           C 
ATOM   2004  C   GLY   125     -22.812  -9.294  -0.524  1.00 42.35           C 
ATOM   2005  O   GLY   125     -23.328  -9.521  -1.623  1.00 42.41           O 
ATOM   2006  H   GLY   125     -20.786  -9.770   1.615  1.00 36.29           H 
ATOM   2007 3HA  GLY   125     -23.275 -11.017   0.655  1.00 36.29           H 
ATOM   2008 2HA  GLY   125     -21.713 -11.083  -0.142  1.00 36.29           H 
ATOM   2009  N   ARG   126     -22.592  -8.063  -0.075  1.00 45.25           N 
ATOM   2010  CA  ARG   126     -22.955  -6.864  -0.843  1.00 31.22           C 
ATOM   2011  C   ARG   126     -21.713  -6.201  -1.471  1.00 73.32           C 
ATOM   2012  O   ARG   126     -20.830  -5.721  -0.762  1.00 30.15           O 
ATOM   2013  CB  ARG   126     -23.690  -5.882   0.082  1.00 13.45           C 
ATOM   2014  CG  ARG   126     -23.968  -4.510  -0.524  1.00  1.50           C 
ATOM   2015  CD  ARG   126     -24.833  -3.664   0.403  1.00 43.53           C 
ATOM   2016  NE  ARG   126     -24.871  -2.260   0.000  1.00 73.00           N 
ATOM   2017  CZ  ARG   126     -25.952  -1.533  -0.026  1.00 54.42           C 
ATOM   2018  NH1 ARG   126     -27.111  -2.060   0.202  1.00 32.24           N 
ATOM   2019  NH2 ARG   126     -25.872  -0.275  -0.293  1.00 23.22           N 
ATOM   2020  H   ARG   126     -22.182  -7.951   0.808  1.00 36.29           H 
ATOM   2021  HA  ARG   126     -23.626  -7.166  -1.634  1.00  5.14           H 
ATOM   2022 3HB  ARG   126     -23.094  -5.741   0.974  1.00 36.29           H 
ATOM   2023 2HB  ARG   126     -24.636  -6.320   0.364  1.00 36.29           H 
ATOM   2024 3HG  ARG   126     -24.482  -4.637  -1.467  1.00 36.29           H 
ATOM   2025 2HG  ARG   126     -23.029  -4.001  -0.689  1.00 36.29           H 
ATOM   2026 3HD  ARG   126     -24.433  -3.726   1.407  1.00 36.29           H 
ATOM   2027 2HD  ARG   126     -25.839  -4.059   0.396  1.00 36.29           H 
ATOM   2028  HE  ARG   126     -24.020  -1.834  -0.220  1.00 22.03           H 
ATOM   2029 1HH1 ARG   126     -27.187  -3.034   0.399  1.00 36.29           H 
ATOM   2030 2HH1 ARG   126     -27.931  -1.491   0.180  1.00 36.29           H 
ATOM   2031 1HH2 ARG   126     -24.990   0.139  -0.486  1.00 36.29           H 
ATOM   2032 2HH2 ARG   126     -26.697   0.289  -0.284  1.00 36.29           H 
ATOM   2033  N   GLU   127     -21.651  -6.181  -2.805  1.00  3.43           N 
ATOM   2034  CA  GLU   127     -20.499  -5.610  -3.526  1.00 23.43           C 
ATOM   2035  C   GLU   127     -20.452  -4.075  -3.422  1.00 73.44           C 
ATOM   2036  O   GLU   127     -21.470  -3.395  -3.578  1.00 75.52           O 
ATOM   2037  CB  GLU   127     -20.531  -6.031  -5.005  1.00 34.52           C 
ATOM   2038  CG  GLU   127     -20.492  -7.542  -5.217  1.00 23.15           C 
ATOM   2039  CD  GLU   127     -20.491  -7.936  -6.690  1.00 21.12           C 
ATOM   2040  OE1 GLU   127     -21.513  -7.698  -7.369  1.00 32.20           O 
ATOM   2041  OE2 GLU   127     -19.483  -8.500  -7.169  1.00 20.22           O 
ATOM   2042  H   GLU   127     -22.393  -6.564  -3.321  1.00 36.29           H 
ATOM   2043  HA  GLU   127     -19.601  -6.012  -3.075  1.00 63.25           H 
ATOM   2044 3HB  GLU   127     -19.680  -5.597  -5.510  1.00 36.29           H 
ATOM   2045 2HB  GLU   127     -21.437  -5.648  -5.457  1.00 36.29           H 
ATOM   2046 3HG  GLU   127     -21.360  -7.980  -4.743  1.00 36.29           H 
ATOM   2047 2HG  GLU   127     -19.598  -7.934  -4.749  1.00 36.29           H 
ATOM   2048  N   ILE   128     -19.256  -3.544  -3.166  1.00  2.14           N 
ATOM   2049  CA  ILE   128     -19.042  -2.099  -3.017  1.00 13.41           C 
ATOM   2050  C   ILE   128     -18.389  -1.498  -4.276  1.00 60.24           C 
ATOM   2051  O   ILE   128     -17.491  -2.103  -4.868  1.00 23.33           O 
ATOM   2052  CB  ILE   128     -18.137  -1.794  -1.793  1.00 44.41           C 
ATOM   2053  CG1 ILE   128     -18.641  -2.537  -0.542  1.00 63.42           C 
ATOM   2054  CG2 ILE   128     -18.069  -0.288  -1.534  1.00 71.34           C 
ATOM   2055  CD1 ILE   128     -20.042  -2.154  -0.116  1.00 51.12           C 
ATOM   2056  H   ILE   128     -18.488  -4.144  -3.072  1.00 36.29           H 
ATOM   2057  HA  ILE   128     -20.004  -1.626  -2.858  1.00  4.01           H 
ATOM   2058  HB  ILE   128     -17.136  -2.137  -2.021  1.00 64.42           H 
ATOM   2059 3HG1 ILE   128     -17.976  -2.331   0.284  1.00 36.29           H 
ATOM   2060 2HG1 ILE   128     -18.639  -3.601  -0.738  1.00 36.29           H 
ATOM   2061 1HG2 ILE   128     -17.653   0.207  -2.400  1.00 36.29           H 
ATOM   2062 2HG2 ILE   128     -17.442  -0.095  -0.675  1.00 36.29           H 
ATOM   2063 3HG2 ILE   128     -19.063   0.093  -1.346  1.00 36.29           H 
ATOM   2064 1HD1 ILE   128     -20.324  -2.735   0.748  1.00 36.29           H 
ATOM   2065 2HD1 ILE   128     -20.732  -2.351  -0.923  1.00 36.29           H 
ATOM   2066 3HD1 ILE   128     -20.069  -1.103   0.134  1.00 36.29           H 
ATOM   2067  N   ASP   129     -18.830  -0.303  -4.667  1.00 10.23           N 
ATOM   2068  CA  ASP   129     -18.320   0.368  -5.871  1.00 53.10           C 
ATOM   2069  C   ASP   129     -16.919   0.983  -5.656  1.00 64.35           C 
ATOM   2070  O   ASP   129     -16.748   2.206  -5.689  1.00  1.51           O 
ATOM   2071  CB  ASP   129     -19.308   1.456  -6.304  1.00  2.33           C 
ATOM   2072  CG  ASP   129     -20.702   0.910  -6.541  1.00 40.11           C 
ATOM   2073  OD1 ASP   129     -21.429   0.674  -5.552  1.00 24.23           O 
ATOM   2074  OD2 ASP   129     -21.082   0.722  -7.714  1.00 21.40           O 
ATOM   2075  H   ASP   129     -19.529   0.139  -4.141  1.00 36.29           H 
ATOM   2076  HA  ASP   129     -18.255  -0.371  -6.657  1.00 22.45           H 
ATOM   2077 3HB  ASP   129     -18.956   1.911  -7.219  1.00 36.29           H 
ATOM   2078 2HB  ASP   129     -19.364   2.210  -5.531  1.00 36.29           H 
ATOM   2079  N   LEU   130     -15.920   0.130  -5.439  1.00  3.51           N 
ATOM   2080  CA  LEU   130     -14.531   0.578  -5.238  1.00 61.03           C 
ATOM   2081  C   LEU   130     -13.562  -0.220  -6.127  1.00 74.21           C 
ATOM   2082  O   LEU   130     -13.376  -1.421  -5.928  1.00 53.25           O 
ATOM   2083  CB  LEU   130     -14.124   0.427  -3.761  1.00 74.02           C 
ATOM   2084  CG  LEU   130     -14.939   1.257  -2.750  1.00 72.05           C 
ATOM   2085  CD1 LEU   130     -14.503   0.942  -1.319  1.00 35.30           C 
ATOM   2086  CD2 LEU   130     -14.803   2.753  -3.038  1.00 43.21           C 
ATOM   2087  H   LEU   130     -16.116  -0.831  -5.421  1.00 36.29           H 
ATOM   2088  HA  LEU   130     -14.471   1.622  -5.514  1.00 44.34           H 
ATOM   2089 3HB  LEU   130     -13.083   0.710  -3.666  1.00 36.29           H 
ATOM   2090 2HB  LEU   130     -14.217  -0.616  -3.494  1.00 36.29           H 
ATOM   2091  HG  LEU   130     -15.985   0.994  -2.841  1.00 12.31           H 
ATOM   2092 1HD1 LEU   130     -15.095   1.524  -0.625  1.00 36.29           H 
ATOM   2093 2HD1 LEU   130     -13.459   1.188  -1.195  1.00 36.29           H 
ATOM   2094 3HD1 LEU   130     -14.649  -0.110  -1.119  1.00 36.29           H 
ATOM   2095 1HD2 LEU   130     -15.174   2.967  -4.030  1.00 36.29           H 
ATOM   2096 2HD2 LEU   130     -13.763   3.042  -2.973  1.00 36.29           H 
ATOM   2097 3HD2 LEU   130     -15.376   3.313  -2.312  1.00 36.29           H 
ATOM   2098  N   GLY   131     -12.948   0.452  -7.101  1.00 45.24           N 
ATOM   2099  CA  GLY   131     -12.041  -0.222  -8.029  1.00 14.03           C 
ATOM   2100  C   GLY   131     -10.564   0.103  -7.802  1.00 62.02           C 
ATOM   2101  O   GLY   131      -9.718  -0.795  -7.819  1.00  1.13           O 
ATOM   2102  H   GLY   131     -13.122   1.412  -7.203  1.00 36.29           H 
ATOM   2103 3HA  GLY   131     -12.304   0.069  -9.036  1.00 36.29           H 
ATOM   2104 2HA  GLY   131     -12.175  -1.291  -7.937  1.00 36.29           H 
ATOM   2105  N   TYR   132     -10.244   1.385  -7.598  1.00 45.14           N 
ATOM   2106  CA  TYR   132      -8.845   1.811  -7.437  1.00  1.23           C 
ATOM   2107  C   TYR   132      -8.724   3.175  -6.724  1.00 64.11           C 
ATOM   2108  O   TYR   132      -8.341   3.239  -5.553  1.00 23.12           O 
ATOM   2109  CB  TYR   132      -8.156   1.872  -8.812  1.00 71.04           C 
ATOM   2110  CG  TYR   132      -6.671   2.197  -8.754  1.00  1.22           C 
ATOM   2111  CD1 TYR   132      -6.208   3.502  -8.918  1.00 24.34           C 
ATOM   2112  CD2 TYR   132      -5.730   1.194  -8.540  1.00 40.31           C 
ATOM   2113  CE1 TYR   132      -4.858   3.792  -8.869  1.00  2.13           C 
ATOM   2114  CE2 TYR   132      -4.380   1.479  -8.489  1.00 42.44           C 
ATOM   2115  CZ  TYR   132      -3.948   2.778  -8.655  1.00  3.14           C 
ATOM   2116  OH  TYR   132      -2.601   3.065  -8.606  1.00 52.01           O 
ATOM   2117  H   TYR   132     -10.961   2.053  -7.549  1.00 36.29           H 
ATOM   2118  HA  TYR   132      -8.344   1.065  -6.834  1.00 63.41           H 
ATOM   2119 3HB  TYR   132      -8.641   2.630  -9.412  1.00 36.29           H 
ATOM   2120 2HB  TYR   132      -8.266   0.914  -9.303  1.00 36.29           H 
ATOM   2121  HD1 TYR   132      -6.922   4.295  -9.085  1.00 64.32           H 
ATOM   2122  HD2 TYR   132      -6.069   0.176  -8.409  1.00 13.42           H 
ATOM   2123  HE1 TYR   132      -4.519   4.810  -8.997  1.00 20.44           H 
ATOM   2124  HE2 TYR   132      -3.666   0.684  -8.323  1.00 11.35           H 
ATOM   2125  HH  TYR   132      -2.450   3.807  -8.015  1.00  3.43           H 
ATOM   2126  N   GLY   133      -9.071   4.255  -7.436  1.00 51.33           N 
ATOM   2127  CA  GLY   133      -8.870   5.614  -6.924  1.00 13.10           C 
ATOM   2128  C   GLY   133      -9.509   5.864  -5.560  1.00 40.20           C 
ATOM   2129  O   GLY   133      -8.873   6.404  -4.657  1.00 13.21           O 
ATOM   2130  H   GLY   133      -9.477   4.130  -8.322  1.00 36.29           H 
ATOM   2131 3HA  GLY   133      -9.290   6.313  -7.635  1.00 36.29           H 
ATOM   2132 2HA  GLY   133      -7.808   5.801  -6.848  1.00 36.29           H 
ATOM   2133  N   GLU   134     -10.769   5.477  -5.411  1.00 14.42           N 
ATOM   2134  CA  GLU   134     -11.477   5.632  -4.139  1.00 14.32           C 
ATOM   2135  C   GLU   134     -11.047   4.559  -3.127  1.00 52.13           C 
ATOM   2136  O   GLU   134     -11.004   4.806  -1.924  1.00 35.42           O 
ATOM   2137  CB  GLU   134     -12.994   5.561  -4.367  1.00 42.30           C 
ATOM   2138  CG  GLU   134     -13.506   6.514  -5.445  1.00 54.42           C 
ATOM   2139  CD  GLU   134     -13.287   7.985  -5.110  1.00 32.14           C 
ATOM   2140  OE1 GLU   134     -12.181   8.506  -5.365  1.00 10.42           O 
ATOM   2141  OE2 GLU   134     -14.229   8.633  -4.613  1.00  3.31           O 
ATOM   2142  H   GLU   134     -11.236   5.078  -6.174  1.00 36.29           H 
ATOM   2143  HA  GLU   134     -11.229   6.606  -3.738  1.00 11.20           H 
ATOM   2144 3HB  GLU   134     -13.499   5.797  -3.440  1.00 36.29           H 
ATOM   2145 2HB  GLU   134     -13.256   4.553  -4.656  1.00 36.29           H 
ATOM   2146 3HG  GLU   134     -14.565   6.343  -5.580  1.00 36.29           H 
ATOM   2147 2HG  GLU   134     -12.991   6.294  -6.371  1.00 36.29           H 
ATOM   2148  N   ALA   135     -10.703   3.373  -3.630  1.00 32.24           N 
ATOM   2149  CA  ALA   135     -10.360   2.223  -2.778  1.00 13.22           C 
ATOM   2150  C   ALA   135      -9.159   2.502  -1.854  1.00 64.43           C 
ATOM   2151  O   ALA   135      -9.058   1.931  -0.768  1.00 72.22           O 
ATOM   2152  CB  ALA   135     -10.092   0.994  -3.640  1.00  0.25           C 
ATOM   2153  H   ALA   135     -10.672   3.267  -4.603  1.00 36.29           H 
ATOM   2154  HA  ALA   135     -11.223   2.006  -2.160  1.00 21.24           H 
ATOM   2155 1HB  ALA   135      -9.200   1.152  -4.231  1.00 36.29           H 
ATOM   2156 2HB  ALA   135     -10.932   0.825  -4.300  1.00 36.29           H 
ATOM   2157 3HB  ALA   135      -9.956   0.128  -3.007  1.00 36.29           H 
ATOM   2158  N   THR   136      -8.253   3.382  -2.283  1.00  1.31           N 
ATOM   2159  CA  THR   136      -7.082   3.750  -1.460  1.00 43.53           C 
ATOM   2160  C   THR   136      -7.462   4.690  -0.303  1.00 35.52           C 
ATOM   2161  O   THR   136      -6.651   4.957   0.586  1.00  1.42           O 
ATOM   2162  CB  THR   136      -5.969   4.427  -2.303  1.00  2.12           C 
ATOM   2163  OG1 THR   136      -4.807   4.668  -1.493  1.00 12.44           O 
ATOM   2164  CG2 THR   136      -6.450   5.744  -2.903  1.00 50.10           C 
ATOM   2165  H   THR   136      -8.361   3.783  -3.175  1.00 36.29           H 
ATOM   2166  HA  THR   136      -6.676   2.838  -1.042  1.00 73.22           H 
ATOM   2167  HB  THR   136      -5.698   3.759  -3.110  1.00 11.11           H 
ATOM   2168  HG1 THR   136      -5.076   5.022  -0.638  1.00 72.40           H 
ATOM   2169 1HG2 THR   136      -7.315   5.565  -3.525  1.00 36.29           H 
ATOM   2170 2HG2 THR   136      -5.662   6.178  -3.501  1.00 36.29           H 
ATOM   2171 3HG2 THR   136      -6.715   6.429  -2.109  1.00 36.29           H 
ATOM   2172  N   LYS   137      -8.693   5.194  -0.325  1.00  0.45           N 
ATOM   2173  CA  LYS   137      -9.171   6.133   0.698  1.00 32.52           C 
ATOM   2174  C   LYS   137      -9.853   5.400   1.868  1.00  3.21           C 
ATOM   2175  O   LYS   137     -10.067   5.980   2.938  1.00  4.43           O 
ATOM   2176  CB  LYS   137     -10.137   7.139   0.054  1.00 72.22           C 
ATOM   2177  CG  LYS   137      -9.533   7.870  -1.145  1.00 73.34           C 
ATOM   2178  CD  LYS   137     -10.552   8.761  -1.852  1.00 23.35           C 
ATOM   2179  CE  LYS   137      -9.944   9.465  -3.064  1.00 30.11           C 
ATOM   2180  NZ  LYS   137     -10.926  10.344  -3.752  1.00 45.11           N 
ATOM   2181  H   LYS   137      -9.299   4.933  -1.050  1.00 36.29           H 
ATOM   2182  HA  LYS   137      -8.316   6.671   1.084  1.00 52.10           H 
ATOM   2183 3HB  LYS   137     -10.423   7.874   0.792  1.00 36.29           H 
ATOM   2184 2HB  LYS   137     -11.022   6.611  -0.278  1.00 36.29           H 
ATOM   2185 3HG  LYS   137      -9.162   7.136  -1.848  1.00 36.29           H 
ATOM   2186 2HG  LYS   137      -8.712   8.485  -0.804  1.00 36.29           H 
ATOM   2187 3HD  LYS   137     -10.909   9.506  -1.155  1.00 36.29           H 
ATOM   2188 2HD  LYS   137     -11.381   8.150  -2.182  1.00 36.29           H 
ATOM   2189 3HE  LYS   137      -9.595   8.717  -3.761  1.00 36.29           H 
ATOM   2190 2HE  LYS   137      -9.108  10.067  -2.736  1.00 36.29           H 
ATOM   2191 1HZ  LYS   137     -10.459  10.867  -4.522  1.00 36.29           H 
ATOM   2192 2HZ  LYS   137     -11.333  11.027  -3.081  1.00 36.29           H 
ATOM   2193 3HZ  LYS   137     -11.695   9.771  -4.159  1.00 36.29           H 
ATOM   2194  N   ILE   138     -10.192   4.126   1.658  1.00 60.30           N 
ATOM   2195  CA  ILE   138     -10.785   3.292   2.714  1.00 62.30           C 
ATOM   2196  C   ILE   138      -9.712   2.400   3.357  1.00 50.30           C 
ATOM   2197  O   ILE   138      -9.086   1.582   2.678  1.00 52.20           O 
ATOM   2198  CB  ILE   138     -11.935   2.386   2.180  1.00 71.20           C 
ATOM   2199  CG1 ILE   138     -13.093   3.223   1.601  1.00  0.22           C 
ATOM   2200  CG2 ILE   138     -12.456   1.467   3.290  1.00 55.43           C 
ATOM   2201  CD1 ILE   138     -12.779   3.906   0.287  1.00 51.44           C 
ATOM   2202  H   ILE   138     -10.031   3.732   0.775  1.00 36.29           H 
ATOM   2203  HA  ILE   138     -11.193   3.950   3.471  1.00 42.11           H 
ATOM   2204  HB  ILE   138     -11.530   1.759   1.397  1.00 72.45           H 
ATOM   2205 3HG1 ILE   138     -13.364   3.990   2.315  1.00 36.29           H 
ATOM   2206 2HG1 ILE   138     -13.947   2.581   1.438  1.00 36.29           H 
ATOM   2207 1HG2 ILE   138     -13.269   0.864   2.909  1.00 36.29           H 
ATOM   2208 2HG2 ILE   138     -12.808   2.063   4.118  1.00 36.29           H 
ATOM   2209 3HG2 ILE   138     -11.659   0.819   3.628  1.00 36.29           H 
ATOM   2210 1HD1 ILE   138     -12.508   3.166  -0.450  1.00 36.29           H 
ATOM   2211 2HD1 ILE   138     -11.957   4.594   0.425  1.00 36.29           H 
ATOM   2212 3HD1 ILE   138     -13.648   4.450  -0.053  1.00 36.29           H 
ATOM   2213  N   TRP   139      -9.507   2.557   4.663  1.00 34.04           N 
ATOM   2214  CA  TRP   139      -8.464   1.812   5.381  1.00 62.21           C 
ATOM   2215  C   TRP   139      -9.060   0.686   6.244  1.00 73.43           C 
ATOM   2216  O   TRP   139     -10.042   0.886   6.972  1.00 54.32           O 
ATOM   2217  CB  TRP   139      -7.639   2.774   6.242  1.00 72.31           C 
ATOM   2218  CG  TRP   139      -6.849   3.766   5.435  1.00 12.05           C 
ATOM   2219  CD1 TRP   139      -7.347   4.748   4.628  1.00 14.33           C 
ATOM   2220  CD2 TRP   139      -5.420   3.875   5.361  1.00 24.53           C 
ATOM   2221  NE1 TRP   139      -6.319   5.453   4.052  1.00 52.22           N 
ATOM   2222  CE2 TRP   139      -5.129   4.938   4.487  1.00 34.30           C 
ATOM   2223  CE3 TRP   139      -4.360   3.175   5.944  1.00 50.24           C 
ATOM   2224  CZ2 TRP   139      -3.822   5.321   4.189  1.00 25.22           C 
ATOM   2225  CZ3 TRP   139      -3.064   3.555   5.648  1.00 32.41           C 
ATOM   2226  CH2 TRP   139      -2.805   4.618   4.775  1.00 30.23           C 
ATOM   2227  H   TRP   139     -10.074   3.183   5.164  1.00 36.29           H 
ATOM   2228  HA  TRP   139      -7.812   1.366   4.641  1.00 33.35           H 
ATOM   2229 3HB  TRP   139      -6.944   2.207   6.846  1.00 36.29           H 
ATOM   2230 2HB  TRP   139      -8.303   3.327   6.891  1.00 36.29           H 
ATOM   2231  HD1 TRP   139      -8.399   4.928   4.470  1.00 44.54           H 
ATOM   2232  HE1 TRP   139      -6.424   6.204   3.431  1.00 35.00           H 
ATOM   2233  HE3 TRP   139      -4.540   2.349   6.620  1.00 21.20           H 
ATOM   2234  HZ2 TRP   139      -3.605   6.140   3.518  1.00 53.50           H 
ATOM   2235  HZ3 TRP   139      -2.234   3.026   6.092  1.00 34.22           H 
ATOM   2236  HH2 TRP   139      -1.777   4.881   4.571  1.00 14.23           H 
ATOM   2237  N   VAL   140      -8.449  -0.496   6.161  1.00  0.54           N 
ATOM   2238  CA  VAL   140      -8.938  -1.696   6.851  1.00 32.24           C 
ATOM   2239  C   VAL   140      -7.802  -2.448   7.571  1.00 64.04           C 
ATOM   2240  O   VAL   140      -6.622  -2.139   7.395  1.00 32.00           O 
ATOM   2241  CB  VAL   140      -9.619  -2.665   5.851  1.00 10.53           C 
ATOM   2242  CG1 VAL   140     -10.863  -2.025   5.239  1.00 65.31           C 
ATOM   2243  CG2 VAL   140      -8.634  -3.094   4.760  1.00 12.24           C 
ATOM   2244  H   VAL   140      -7.634  -0.566   5.620  1.00 36.29           H 
ATOM   2245  HA  VAL   140      -9.673  -1.391   7.585  1.00 32.01           H 
ATOM   2246  HB  VAL   140      -9.930  -3.549   6.392  1.00  4.45           H 
ATOM   2247 1HG1 VAL   140     -10.581  -1.133   4.698  1.00 36.29           H 
ATOM   2248 2HG1 VAL   140     -11.558  -1.767   6.022  1.00 36.29           H 
ATOM   2249 3HG1 VAL   140     -11.332  -2.722   4.560  1.00 36.29           H 
ATOM   2250 1HG2 VAL   140      -9.113  -3.802   4.097  1.00 36.29           H 
ATOM   2251 2HG2 VAL   140      -7.769  -3.557   5.215  1.00 36.29           H 
ATOM   2252 3HG2 VAL   140      -8.322  -2.229   4.194  1.00 36.29           H 
ATOM   2253  N   ARG   141      -8.170  -3.442   8.383  1.00 63.11           N 
ATOM   2254  CA  ARG   141      -7.185  -4.279   9.087  1.00 51.13           C 
ATOM   2255  C   ARG   141      -7.414  -5.772   8.793  1.00 12.45           C 
ATOM   2256  O   ARG   141      -8.551  -6.218   8.640  1.00 24.20           O 
ATOM   2257  CB  ARG   141      -7.246  -4.032  10.602  1.00  0.25           C 
ATOM   2258  CG  ARG   141      -7.161  -2.558  10.991  1.00  0.14           C 
ATOM   2259  CD  ARG   141      -6.786  -2.374  12.455  1.00 54.21           C 
ATOM   2260  NE  ARG   141      -5.429  -2.848  12.727  1.00 53.01           N 
ATOM   2261  CZ  ARG   141      -4.869  -2.849  13.904  1.00 10.01           C 
ATOM   2262  NH1 ARG   141      -5.511  -2.417  14.941  1.00 24.05           N 
ATOM   2263  NH2 ARG   141      -3.659  -3.286  14.042  1.00 32.42           N 
ATOM   2264  H   ARG   141      -9.125  -3.617   8.517  1.00 36.29           H 
ATOM   2265  HA  ARG   141      -6.202  -4.006   8.728  1.00 31.52           H 
ATOM   2266 3HB  ARG   141      -6.424  -4.555  11.071  1.00 36.29           H 
ATOM   2267 2HB  ARG   141      -8.176  -4.430  10.984  1.00 36.29           H 
ATOM   2268 3HG  ARG   141      -8.121  -2.093  10.813  1.00 36.29           H 
ATOM   2269 2HG  ARG   141      -6.411  -2.078  10.380  1.00 36.29           H 
ATOM   2270 3HD  ARG   141      -7.483  -2.930  13.066  1.00 36.29           H 
ATOM   2271 2HD  ARG   141      -6.849  -1.324  12.703  1.00 36.29           H 
ATOM   2272  HE  ARG   141      -4.909  -3.187  11.973  1.00 25.03           H 
ATOM   2273 1HH1 ARG   141      -6.443  -2.080  14.848  1.00 36.29           H 
ATOM   2274 2HH1 ARG   141      -5.073  -2.433  15.838  1.00 36.29           H 
ATOM   2275 1HH2 ARG   141      -3.157  -3.623  13.247  1.00 36.29           H 
ATOM   2276 2HH2 ARG   141      -3.229  -3.293  14.942  1.00 36.29           H 
ATOM   2277  N   ARG   142      -6.328  -6.540   8.717  1.00 31.12           N 
ATOM   2278  CA  ARG   142      -6.410  -7.976   8.407  1.00 50.41           C 
ATOM   2279  C   ARG   142      -6.858  -8.784   9.639  1.00 14.23           C 
ATOM   2280  O   ARG   142      -6.099  -8.953  10.593  1.00 51.22           O 
ATOM   2281  CB  ARG   142      -5.036  -8.463   7.909  1.00  3.44           C 
ATOM   2282  CG  ARG   142      -4.971  -9.932   7.482  1.00 71.22           C 
ATOM   2283  CD  ARG   142      -5.908 -10.249   6.313  1.00 43.30           C 
ATOM   2284  NE  ARG   142      -5.277 -11.114   5.314  1.00  4.21           N 
ATOM   2285  CZ  ARG   142      -5.064 -12.395   5.460  1.00 43.14           C 
ATOM   2286  NH1 ARG   142      -5.406 -12.998   6.554  1.00 73.50           N 
ATOM   2287  NH2 ARG   142      -4.502 -13.067   4.507  1.00 15.44           N 
ATOM   2288  H   ARG   142      -5.449  -6.137   8.876  1.00 36.29           H 
ATOM   2289  HA  ARG   142      -7.136  -8.106   7.617  1.00 11.02           H 
ATOM   2290 3HB  ARG   142      -4.314  -8.313   8.699  1.00 36.29           H 
ATOM   2291 2HB  ARG   142      -4.746  -7.861   7.062  1.00 36.29           H 
ATOM   2292 3HG  ARG   142      -5.242 -10.551   8.327  1.00 36.29           H 
ATOM   2293 2HG  ARG   142      -3.957 -10.159   7.187  1.00 36.29           H 
ATOM   2294 3HD  ARG   142      -6.198  -9.323   5.835  1.00 36.29           H 
ATOM   2295 2HD  ARG   142      -6.790 -10.742   6.697  1.00 36.29           H 
ATOM   2296  HE  ARG   142      -5.003 -10.702   4.473  1.00 13.45           H 
ATOM   2297 1HH1 ARG   142      -5.836 -12.489   7.285  1.00 36.29           H 
ATOM   2298 2HH1 ARG   142      -5.224 -13.976   6.661  1.00 36.29           H 
ATOM   2299 1HH2 ARG   142      -4.233 -12.602   3.661  1.00 36.29           H 
ATOM   2300 2HH2 ARG   142      -4.336 -14.043   4.613  1.00 36.29           H 
ATOM   2301  N   VAL   143      -8.093  -9.288   9.607  1.00 22.51           N 
ATOM   2302  CA  VAL   143      -8.649 -10.049  10.739  1.00 13.35           C 
ATOM   2303  C   VAL   143      -8.612 -11.568  10.496  1.00 21.13           C 
ATOM   2304  O   VAL   143      -8.180 -12.329  11.365  1.00 62.05           O 
ATOM   2305  CB  VAL   143     -10.104  -9.615  11.064  1.00 33.44           C 
ATOM   2306  CG1 VAL   143     -10.136  -8.189  11.600  1.00  3.53           C 
ATOM   2307  CG2 VAL   143     -11.010  -9.743   9.841  1.00 65.43           C 
ATOM   2308  H   VAL   143      -8.652  -9.131   8.816  1.00 36.29           H 
ATOM   2309  HA  VAL   143      -8.039  -9.831  11.608  1.00 35.11           H 
ATOM   2310  HB  VAL   143     -10.487 -10.271  11.836  1.00 21.23           H 
ATOM   2311 1HG1 VAL   143      -9.552  -8.129  12.505  1.00 36.29           H 
ATOM   2312 2HG1 VAL   143     -11.158  -7.908  11.812  1.00 36.29           H 
ATOM   2313 3HG1 VAL   143      -9.726  -7.516  10.859  1.00 36.29           H 
ATOM   2314 1HG2 VAL   143     -10.646  -9.098   9.053  1.00 36.29           H 
ATOM   2315 2HG2 VAL   143     -12.017  -9.455  10.104  1.00 36.29           H 
ATOM   2316 3HG2 VAL   143     -11.011 -10.768   9.497  1.00 36.29           H 
END
