
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 (  784),  selected  110 , name 1ue6_A
# Molecule2: number of CA atoms   75 ( 1234),  selected   75 , name T0466.pdb
# PARAMETERS: 1ue6_A.T0466.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_A      -       -           -
LGA    G     3_A      -       -           -
LGA    D     4_A      -       -           -
LGA    T     5_A      -       -           -
LGA    T     6_A      -       -           -
LGA    I     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    I     9_A      -       -           -
LGA    V    10_A      -       -           -
LGA    G    11_A      L      19          0.987
LGA    N    12_A      K      20          0.854
LGA    L    13_A      F      21          1.774
LGA    T    14_A      S      22          2.042
LGA    A    15_A      A      23          2.182
LGA    D    16_A      -       -           -
LGA    P    17_A      L      24          2.058
LGA    E    18_A      R      25          4.524
LGA    L    19_A      R      26          5.296
LGA    R    20_A      E      27          1.742
LGA    F    21_A      V      28          4.381
LGA    T    22_A      R      29          0.961
LGA    P    23_A      I      30          2.971
LGA    S    24_A      Q      31          3.886
LGA    -       -      N      32           -
LGA    -       -      E      33           -
LGA    -       -      D      34           -
LGA    -       -      G      35           -
LGA    -       -      S      36           -
LGA    -       -      V      37           -
LGA    -       -      S      38           -
LGA    -       -      D      39           -
LGA    G    25_A      E      40          2.644
LGA    A    26_A      I      41          2.535
LGA    A    27_A      K      42          4.144
LGA    V    28_A      E      43          2.474
LGA    A    29_A      R      44          1.752
LGA    N    30_A      T      45          1.440
LGA    F    31_A      Y      46          1.229
LGA    T    32_A      D      47          2.287
LGA    V    33_A      L      48          1.857
LGA    A    34_A      K      49          0.901
LGA    S    35_A      S      50          1.029
LGA    T    36_A      K      51          1.018
LGA    P    37_A      G      52          4.642
LGA    R    38_A      -       -           -
LGA    I    39_A      -       -           -
LGA    Y    40_A      -       -           -
LGA    D    41_A      -       -           -
LGA    R    42_A      -       -           -
LGA    Q    43_A      -       -           -
LGA    W    47_A      -       -           -
LGA    K    48_A      -       -           -
LGA    D    49_A      -       -           -
LGA    G    50_A      -       -           -
LGA    E    51_A      Q      53          4.198
LGA    A    52_A      G      54          2.688
LGA    L    53_A      R      55          3.123
LGA    F    54_A      M      56          2.194
LGA    L    55_A      I      57          1.403
LGA    R    56_A      Q      58          0.944
LGA    C    57_A      V      59          0.808
LGA    N    58_A      S      60          0.583
LGA    I    59_A      I      61          1.108
LGA    W    60_A      P      62          1.397
LGA    R    61_A      A      63          1.637
LGA    E    62_A      S      64          3.079
LGA    A    63_A      V      65          1.857
LGA    A    64_A      P      66          4.060
LGA    E    65_A      L      67          2.538
LGA    N    66_A      -       -           -
LGA    V    67_A      K      68          2.024
LGA    A    68_A      -       -           -
LGA    E    69_A      -       -           -
LGA    S    70_A      E      69          2.411
LGA    L    71_A      F      70          1.843
LGA    T    72_A      D      71          3.345
LGA    R    73_A      Y      72          2.721
LGA    G    74_A      N      73          1.639
LGA    A    75_A      A      74          1.593
LGA    R    76_A      R      75          1.203
LGA    V    77_A      V      76          0.851
LGA    I    78_A      E      77          0.317
LGA    V    79_A      L      78          1.451
LGA    S    80_A      I      79          3.118
LGA    G    81_A      N      80          2.945
LGA    R    82_A      P      81          3.969
LGA    L    83_A      I      82          3.121
LGA    K    84_A      -       -           -
LGA    Q    85_A      -       -           -
LGA    R    86_A      -       -           -
LGA    S    87_A      -       -           -
LGA    T    97_A      -       -           -
LGA    V    98_A      -       -           -
LGA    I    99_A      W      98          3.629
LGA    E   100_A      Y      99          1.098
LGA    V   101_A      I     100          0.878
LGA    E   102_A      K     101          0.712
LGA    V   103_A      A     102          0.843
LGA    D   104_A      D     103          0.710
LGA    E   105_A      D     104          1.997
LGA    I   106_A      I     105          1.211
LGA    G   107_A      V     106          0.479
LGA    P   108_A      L     107          1.734
LGA    S   109_A      T     108          2.034
LGA    L   110_A      -       -           -
LGA    R   111_A      -       -           -
LGA    Y   112_A      -       -           -
LGA    A   113_A      -       -           -
LGA    T   114_A      -       -           -
LGA    A   115_A      -       -           -
LGA    K   116_A      -       -           -
LGA    V   117_A      -       -           -
LGA    N   118_A      -       -           -
LGA    K   119_A      -       -           -
LGA    A   120_A      -       -           -
LGA    S   121_A      -       -           -
LGA    R   122_A      -       -           -
LGA    S   123_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110   75    5.0     67    2.41    11.94     63.088     2.666

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.293310 * X  +   0.955941 * Y  +  -0.012077 * Z  + -12.093063
  Y_new =  -0.803741 * X  +   0.253411 * Y  +   0.538315 * Z  + -36.388699
  Z_new =   0.517658 * X  +  -0.148186 * Y  +   0.842657 * Z  + -99.219582 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.174076    2.967517  [ DEG:    -9.9738    170.0262 ]
  Theta =  -0.544111   -2.597481  [ DEG:   -31.1753   -148.8247 ]
  Phi   =  -1.220883    1.920710  [ DEG:   -69.9514    110.0486 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ue6_A                                        
REMARK     2: T0466.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ue6_A.T0466.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110   75   5.0   67   2.41   11.94  63.088
REMARK  ---------------------------------------------------------- 
MOLECULE 1ue6_A
HEADER    DNA BINDING PROTEIN                     09-MAY-03   1UE6              
TITLE     CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA-BINDING                  
TITLE    2 PROTEIN FROM MYCOBACTERIUM TUBERCULOSIS                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: SINGLE-STRANDED DNA-BINDING PROTEIN;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET11D                                    
KEYWDS    OLIGONUCLEOTIDE BINDING FOLD, DNA-BINDING PROTEIN,                    
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, TB           
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, TBSGC                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,K.SEKAR,            
AUTHOR   2 U.VARSHNEY,M.VIJAYAN,TB STRUCTURAL GENOMICS CONSORTIUM               
AUTHOR   3 (TBSGC)                                                              
REVDAT   2   01-FEB-05 1UE6    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   10-FEB-04 1UE6    0                                                
JRNL        AUTH   K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,           
JRNL        AUTH 2 K.SEKAR,U.VARSHNEY,M.VIJAYAN                                 
JRNL        TITL   STRUCTURE OF MYCOBACTERIUM TUBERCULOSIS                      
JRNL        TITL 2 SINGLE-STRANDED DNA-BINDING PROTEIN. VARIABILITY             
JRNL        TITL 3 IN QUATERNARY STRUCTURE AND ITS IMPLICATIONS                 
JRNL        REF    J.MOL.BIOL.                   V. 331   385 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  1UE6 A    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 B    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 C    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 D    1   164  UNP    P0A610   SSB_MYCTU        1    164             
SEQRES   1 A  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 A  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 A  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 A  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 A  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 A  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 A  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 A  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 A  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 A  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 A  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 A  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 A  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 B  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 B  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 B  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 B  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 B  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 B  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 B  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 B  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 B  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 B  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 B  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 B  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 B  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 C  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 C  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 C  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 C  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 C  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 C  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 C  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 C  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 C  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 C  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 C  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 C  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 C  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 D  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 D  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 D  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 D  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 D  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 D  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 D  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 D  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 D  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 D  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 D  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 D  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 D  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
FORMUL   5  HOH   *229(H2 O)                                                    
CRYST1   60.363  117.620  175.228  90.00  90.00  90.00 I 21 21 21   32          
ATOM      1  N   ALA A   2       6.684 -10.793 -21.961  1.00 82.07           N  
ATOM      2  CA  ALA A   2       6.379  -9.410 -22.430  1.00 91.73           C  
ATOM      3  C   ALA A   2       5.037  -8.910 -21.877  1.00 93.19           C  
ATOM      4  O   ALA A   2       5.000  -8.211 -20.864  1.00100.67           O  
ATOM      5  CB  ALA A   2       6.370  -9.368 -23.962  1.00 81.23           C  
ATOM      6  N   GLY A   3       3.950  -9.279 -22.551  1.00 91.00           N  
ATOM      7  CA  GLY A   3       2.605  -8.876 -22.156  1.00 89.35           C  
ATOM      8  C   GLY A   3       2.389  -8.383 -20.737  1.00 83.94           C  
ATOM      9  O   GLY A   3       2.716  -9.076 -19.781  1.00 79.59           O  
ATOM     10  N   ASP A   4       1.805  -7.196 -20.599  1.00 83.53           N  
ATOM     11  CA  ASP A   4       1.569  -6.602 -19.282  1.00 83.34           C  
ATOM     12  C   ASP A   4       0.230  -6.992 -18.634  1.00 79.08           C  
ATOM     13  O   ASP A   4      -0.471  -7.898 -19.106  1.00 64.68           O  
ATOM     14  CB  ASP A   4       1.665  -5.073 -19.381  1.00 94.52           C  
ATOM     15  CG  ASP A   4       2.173  -4.434 -18.102  1.00102.00           C  
ATOM     16  OD1 ASP A   4       1.501  -4.555 -17.057  1.00106.75           O  
ATOM     17  OD2 ASP A   4       3.254  -3.809 -18.144  1.00108.81           O  
ATOM     18  N   THR A   5      -0.105  -6.293 -17.547  1.00 68.62           N  
ATOM     19  CA  THR A   5      -1.336  -6.524 -16.794  1.00 61.97           C  
ATOM     20  C   THR A   5      -1.678  -5.370 -15.842  1.00 50.81           C  
ATOM     21  O   THR A   5      -1.126  -5.284 -14.747  1.00 46.93           O  
ATOM     22  CB  THR A   5      -1.242  -7.831 -15.977  1.00 51.36           C  
ATOM     23  OG1 THR A   5      -2.188  -7.793 -14.908  1.00 58.24           O  
ATOM     24  CG2 THR A   5       0.146  -8.005 -15.400  1.00 73.72           C  
ATOM     25  N   THR A   6      -2.600  -4.503 -16.265  1.00 50.18           N  
ATOM     26  CA  THR A   6      -3.046  -3.348 -15.475  1.00 42.11           C  
ATOM     27  C   THR A   6      -4.445  -3.627 -14.899  1.00 40.87           C  
ATOM     28  O   THR A   6      -5.205  -4.415 -15.463  1.00 34.98           O  
ATOM     29  CB  THR A   6      -3.124  -2.069 -16.344  1.00 49.05           C  
ATOM     30  OG1 THR A   6      -2.031  -2.047 -17.266  1.00 67.37           O  
ATOM     31  CG2 THR A   6      -3.037  -0.827 -15.474  1.00 56.35           C  
ATOM     32  N   ILE A   7      -4.797  -2.958 -13.801  1.00 30.32           N  
ATOM     33  CA  ILE A   7      -6.082  -3.190 -13.152  1.00 11.16           C  
ATOM     34  C   ILE A   7      -6.657  -1.979 -12.402  1.00 23.45           C  
ATOM     35  O   ILE A   7      -5.921  -1.171 -11.838  1.00 19.69           O  
ATOM     36  CB  ILE A   7      -5.928  -4.326 -12.136  1.00 28.99           C  
ATOM     37  CG1 ILE A   7      -7.277  -4.737 -11.569  1.00 27.44           C  
ATOM     38  CG2 ILE A   7      -5.031  -3.860 -10.992  1.00 16.42           C  
ATOM     39  CD1 ILE A   7      -7.176  -5.765 -10.489  1.00 29.70           C  
ATOM     40  N   THR A   8      -7.981  -1.855 -12.390  1.00 26.13           N  
ATOM     41  CA  THR A   8      -8.624  -0.773 -11.653  1.00 28.78           C  
ATOM     42  C   THR A   8      -9.556  -1.423 -10.643  1.00 26.87           C  
ATOM     43  O   THR A   8     -10.357  -2.274 -11.005  1.00 32.14           O  
ATOM     44  CB  THR A   8      -9.430   0.167 -12.568  1.00 25.90           C  
ATOM     45  OG1 THR A   8      -8.561   0.746 -13.546  1.00 44.08           O  
ATOM     46  CG2 THR A   8     -10.036   1.293 -11.754  1.00 19.85           C  
ATOM     47  N   ILE A   9      -9.424  -1.032  -9.376  1.00 36.64           N  
ATOM     48  CA  ILE A   9     -10.228  -1.569  -8.273  1.00 32.26           C  
ATOM     49  C   ILE A   9     -10.962  -0.472  -7.522  1.00 29.00           C  
ATOM     50  O   ILE A   9     -10.433   0.615  -7.311  1.00 35.83           O  
ATOM     51  CB  ILE A   9      -9.378  -2.221  -7.148  1.00 30.42           C  
ATOM     52  CG1 ILE A   9      -8.384  -3.206  -7.698  1.00 23.58           C  
ATOM     53  CG2 ILE A   9     -10.279  -2.943  -6.153  1.00 27.90           C  
ATOM     54  CD1 ILE A   9      -7.357  -3.541  -6.645  1.00 36.35           C  
ATOM     55  N   VAL A  10     -12.170  -0.797  -7.091  1.00 27.75           N  
ATOM     56  CA  VAL A  10     -12.985   0.083  -6.284  1.00 25.36           C  
ATOM     57  C   VAL A  10     -13.439  -0.820  -5.133  1.00 35.13           C  
ATOM     58  O   VAL A  10     -14.002  -1.898  -5.361  1.00 22.76           O  
ATOM     59  CB  VAL A  10     -14.195   0.622  -7.065  1.00 28.69           C  
ATOM     60  CG1 VAL A  10     -15.249   1.151  -6.088  1.00 17.78           C  
ATOM     61  CG2 VAL A  10     -13.743   1.749  -7.995  1.00 22.76           C  
ATOM     62  N   GLY A  11     -13.151  -0.391  -3.906  1.00 24.12           N  
ATOM     63  CA  GLY A  11     -13.505  -1.173  -2.734  1.00 25.64           C  
ATOM     64  C   GLY A  11     -13.225  -0.421  -1.441  1.00 32.84           C  
ATOM     65  O   GLY A  11     -13.099   0.804  -1.436  1.00 26.78           O  
ATOM     66  N   ASN A  12     -13.132  -1.139  -0.331  1.00 27.42           N  
ATOM     67  CA  ASN A  12     -12.867  -0.486   0.938  1.00 30.28           C  
ATOM     68  C   ASN A  12     -11.578  -0.997   1.580  1.00 34.57           C  
ATOM     69  O   ASN A  12     -11.147  -2.121   1.316  1.00 40.31           O  
ATOM     70  CB  ASN A  12     -14.079  -0.656   1.848  1.00 31.80           C  
ATOM     71  CG  ASN A  12     -15.318   0.011   1.271  1.00 31.78           C  
ATOM     72  OD1 ASN A  12     -15.769   1.042   1.758  1.00 48.82           O  
ATOM     73  ND2 ASN A  12     -15.859  -0.568   0.214  1.00 37.05           N  
ATOM     74  N   LEU A  13     -10.958  -0.160   2.409  1.00 33.45           N  
ATOM     75  CA  LEU A  13      -9.682  -0.499   3.041  1.00 40.94           C  
ATOM     76  C   LEU A  13      -9.546  -1.541   4.156  1.00 35.57           C  
ATOM     77  O   LEU A  13      -8.456  -2.068   4.352  1.00 58.33           O  
ATOM     78  CB  LEU A  13      -8.986   0.784   3.490  1.00 23.51           C  
ATOM     79  CG  LEU A  13      -8.328   1.548   2.338  1.00 41.30           C  
ATOM     80  CD1 LEU A  13      -7.536   2.724   2.888  1.00 38.78           C  
ATOM     81  CD2 LEU A  13      -7.408   0.609   1.563  1.00 24.81           C  
ATOM     82  N   THR A  14     -10.604  -1.842   4.889  1.00 26.51           N  
ATOM     83  CA  THR A  14     -10.511  -2.844   5.963  1.00 46.94           C  
ATOM     84  C   THR A  14      -9.595  -2.480   7.138  1.00 46.14           C  
ATOM     85  O   THR A  14      -9.574  -3.183   8.141  1.00 55.64           O  
ATOM     86  CB  THR A  14     -10.039  -4.245   5.445  1.00 41.83           C  
ATOM     87  OG1 THR A  14      -8.624  -4.235   5.226  1.00 46.01           O  
ATOM     88  CG2 THR A  14     -10.746  -4.614   4.158  1.00 43.86           C  
ATOM     89  N   ALA A  15      -8.837  -1.398   7.022  1.00 56.56           N  
ATOM     90  CA  ALA A  15      -7.940  -0.977   8.098  1.00 48.73           C  
ATOM     91  C   ALA A  15      -7.211   0.289   7.692  1.00 49.79           C  
ATOM     92  O   ALA A  15      -7.297   0.711   6.543  1.00 58.54           O  
ATOM     93  CB  ALA A  15      -6.931  -2.077   8.398  1.00 31.32           C  
ATOM     94  N   ASP A  16      -6.504   0.908   8.632  1.00 54.20           N  
ATOM     95  CA  ASP A  16      -5.752   2.113   8.310  1.00 43.56           C  
ATOM     96  C   ASP A  16      -4.514   1.637   7.569  1.00 44.60           C  
ATOM     97  O   ASP A  16      -3.984   0.557   7.856  1.00 36.43           O  
ATOM     98  CB  ASP A  16      -5.320   2.866   9.574  1.00 47.71           C  
ATOM     99  CG  ASP A  16      -6.491   3.288  10.446  1.00 56.98           C  
ATOM    100  OD1 ASP A  16      -7.588   3.543   9.904  1.00 64.25           O  
ATOM    101  OD2 ASP A  16      -6.302   3.383  11.681  1.00 62.59           O  
ATOM    102  N   PRO A  17      -4.041   2.420   6.588  1.00 51.24           N  
ATOM    103  CA  PRO A  17      -2.846   1.999   5.849  1.00 53.69           C  
ATOM    104  C   PRO A  17      -1.695   1.653   6.790  1.00 49.22           C  
ATOM    105  O   PRO A  17      -1.869   1.631   8.000  1.00 42.15           O  
ATOM    106  CB  PRO A  17      -2.559   3.205   4.959  1.00 56.34           C  
ATOM    107  CG  PRO A  17      -3.952   3.678   4.627  1.00 43.22           C  
ATOM    108  CD  PRO A  17      -4.641   3.624   5.984  1.00 44.04           C  
ATOM    109  N   GLU A  18      -0.521   1.376   6.237  1.00 58.98           N  
ATOM    110  CA  GLU A  18       0.631   1.025   7.057  1.00 58.00           C  
ATOM    111  C   GLU A  18       1.933   1.505   6.433  1.00 66.47           C  
ATOM    112  O   GLU A  18       2.261   1.135   5.300  1.00 60.70           O  
ATOM    113  CB  GLU A  18       0.704  -0.490   7.253  1.00 53.21           C  
ATOM    114  CG  GLU A  18      -0.489  -1.102   7.953  1.00 74.60           C  
ATOM    115  CD  GLU A  18      -0.603  -0.691   9.407  1.00 91.90           C  
ATOM    116  OE1 GLU A  18      -1.541  -1.168  10.084  1.00 96.27           O  
ATOM    117  OE2 GLU A  18       0.239   0.106   9.876  1.00 96.51           O  
ATOM    118  N   LEU A  19       2.674   2.323   7.178  1.00 69.66           N  
ATOM    119  CA  LEU A  19       3.951   2.842   6.708  1.00 70.11           C  
ATOM    120  C   LEU A  19       5.081   1.880   7.037  1.00 75.63           C  
ATOM    121  O   LEU A  19       5.532   1.794   8.178  1.00 81.02           O  
ATOM    122  CB  LEU A  19       4.242   4.199   7.334  1.00 58.18           C  
ATOM    123  CG  LEU A  19       3.370   5.349   6.850  1.00 67.90           C  
ATOM    124  CD1 LEU A  19       3.791   6.650   7.532  1.00 70.31           C  
ATOM    125  CD2 LEU A  19       3.513   5.467   5.341  1.00 71.17           C  
ATOM    126  N   ARG A  20       5.518   1.147   6.023  1.00 83.97           N  
ATOM    127  CA  ARG A  20       6.599   0.185   6.165  1.00 85.68           C  
ATOM    128  C   ARG A  20       7.797   0.796   5.457  1.00 87.61           C  
ATOM    129  O   ARG A  20       7.895   0.722   4.232  1.00 96.24           O  
ATOM    130  CB  ARG A  20       6.219  -1.141   5.487  1.00 81.69           C  
ATOM    131  CG  ARG A  20       7.245  -2.263   5.634  1.00 74.88           C  
ATOM    132  CD  ARG A  20       7.400  -3.060   4.329  1.00 97.67           C  
ATOM    133  NE  ARG A  20       6.228  -3.866   3.981  1.00105.33           N  
ATOM    134  CZ  ARG A  20       6.066  -5.148   4.311  1.00109.14           C  
ATOM    135  NH1 ARG A  20       7.005  -5.786   4.998  1.00109.12           N  
ATOM    136  NH2 ARG A  20       4.963  -5.793   3.955  1.00101.91           N  
ATOM    137  N   PHE A  21       8.692   1.425   6.213  1.00 85.22           N  
ATOM    138  CA  PHE A  21       9.880   2.020   5.605  1.00 81.33           C  
ATOM    139  C   PHE A  21      10.850   0.906   5.263  1.00 77.84           C  
ATOM    140  O   PHE A  21      11.135   0.039   6.092  1.00 73.50           O  
ATOM    141  CB  PHE A  21      10.542   3.025   6.552  1.00 74.87           C  
ATOM    142  CG  PHE A  21       9.675   4.209   6.872  1.00 63.03           C  
ATOM    143  CD1 PHE A  21       8.901   4.230   8.027  1.00 52.79           C  
ATOM    144  CD2 PHE A  21       9.587   5.277   5.983  1.00 54.04           C  
ATOM    145  CE1 PHE A  21       8.049   5.297   8.291  1.00 66.35           C  
ATOM    146  CE2 PHE A  21       8.741   6.349   6.234  1.00 55.69           C  
ATOM    147  CZ  PHE A  21       7.967   6.358   7.391  1.00 71.20           C  
ATOM    148  N   THR A  22      11.335   0.920   4.028  1.00 67.78           N  
ATOM    149  CA  THR A  22      12.257  -0.104   3.579  1.00 75.69           C  
ATOM    150  C   THR A  22      13.606   0.076   4.252  1.00 80.40           C  
ATOM    151  O   THR A  22      13.873   1.117   4.858  1.00 84.73           O  
ATOM    152  CB  THR A  22      12.457  -0.044   2.056  1.00 79.04           C  
ATOM    153  OG1 THR A  22      13.107   1.183   1.705  1.00 78.87           O  
ATOM    154  CG2 THR A  22      11.116  -0.126   1.342  1.00 79.68           C  
ATOM    155  N   PRO A  23      14.467  -0.951   4.179  1.00 78.84           N  
ATOM    156  CA  PRO A  23      15.798  -0.879   4.788  1.00 81.70           C  
ATOM    157  C   PRO A  23      16.639   0.171   4.071  1.00 82.23           C  
ATOM    158  O   PRO A  23      17.537   0.774   4.661  1.00 87.46           O  
ATOM    159  CB  PRO A  23      16.337  -2.290   4.593  1.00 83.32           C  
ATOM    160  CG  PRO A  23      15.100  -3.121   4.672  1.00 85.13           C  
ATOM    161  CD  PRO A  23      14.148  -2.338   3.803  1.00 78.22           C  
ATOM    162  N   SER A  24      16.334   0.386   2.794  1.00 80.41           N  
ATOM    163  CA  SER A  24      17.045   1.370   1.986  1.00 74.22           C  
ATOM    164  C   SER A  24      16.669   2.792   2.403  1.00 68.45           C  
ATOM    165  O   SER A  24      17.454   3.718   2.233  1.00 57.93           O  
ATOM    166  CB  SER A  24      16.727   1.167   0.501  1.00 73.17           C  
ATOM    167  OG  SER A  24      15.343   1.327   0.239  1.00 68.66           O  
ATOM    168  N   GLY A  25      15.465   2.956   2.943  1.00 79.76           N  
ATOM    169  CA  GLY A  25      15.008   4.267   3.378  1.00 80.72           C  
ATOM    170  C   GLY A  25      13.764   4.761   2.657  1.00 80.30           C  
ATOM    171  O   GLY A  25      13.327   5.893   2.876  1.00 84.67           O  
ATOM    172  N   ALA A  26      13.191   3.908   1.808  1.00 78.35           N  
ATOM    173  CA  ALA A  26      12.001   4.270   1.053  1.00 72.61           C  
ATOM    174  C   ALA A  26      10.667   3.983   1.729  1.00 68.53           C  
ATOM    175  O   ALA A  26      10.476   2.936   2.357  1.00 61.20           O  
ATOM    176  N   ALA A  27       9.731   4.920   1.592  1.00 59.35           N  
ATOM    177  CA  ALA A  27       8.411   4.765   2.192  1.00 48.88           C  
ATOM    178  C   ALA A  27       7.559   3.778   1.400  1.00 47.66           C  
ATOM    179  O   ALA A  27       7.644   3.707   0.172  1.00 34.49           O  
ATOM    180  CB  ALA A  27       7.706   6.115   2.271  1.00 26.13           C  
ATOM    181  N   VAL A  28       6.741   3.016   2.116  1.00 45.76           N  
ATOM    182  CA  VAL A  28       5.857   2.037   1.501  1.00 46.46           C  
ATOM    183  C   VAL A  28       4.621   1.920   2.367  1.00 45.05           C  
ATOM    184  O   VAL A  28       4.718   1.659   3.566  1.00 42.50           O  
ATOM    185  CB  VAL A  28       6.503   0.640   1.426  1.00 55.27           C  
ATOM    186  CG1 VAL A  28       5.634  -0.281   0.583  1.00 53.42           C  
ATOM    187  CG2 VAL A  28       7.908   0.733   0.859  1.00 50.69           C  
ATOM    188  N   ALA A  29       3.455   2.115   1.770  1.00 50.48           N  
ATOM    189  CA  ALA A  29       2.222   2.010   2.533  1.00 44.61           C  
ATOM    190  C   ALA A  29       1.506   0.731   2.131  1.00 47.69           C  
ATOM    191  O   ALA A  29       1.415   0.404   0.950  1.00 50.61           O  
ATOM    192  CB  ALA A  29       1.349   3.226   2.283  1.00 36.60           C  
ATOM    193  N   ASN A  30       1.011   0.000   3.122  1.00 48.96           N  
ATOM    194  CA  ASN A  30       0.317  -1.254   2.862  1.00 49.90           C  
ATOM    195  C   ASN A  30      -1.116  -1.230   3.359  1.00 50.53           C  
ATOM    196  O   ASN A  30      -1.412  -0.706   4.429  1.00 58.43           O  
ATOM    197  CB  ASN A  30       1.080  -2.400   3.517  1.00 57.71           C  
ATOM    198  CG  ASN A  30       2.501  -2.496   3.016  1.00 60.14           C  
ATOM    199  OD1 ASN A  30       2.738  -2.898   1.879  1.00 65.70           O  
ATOM    200  ND2 ASN A  30       3.457  -2.107   3.854  1.00 56.92           N  
ATOM    201  N   PHE A  31      -2.007  -1.805   2.566  1.00 39.68           N  
ATOM    202  CA  PHE A  31      -3.416  -1.852   2.913  1.00 29.02           C  
ATOM    203  C   PHE A  31      -4.032  -2.925   2.032  1.00 31.92           C  
ATOM    204  O   PHE A  31      -3.385  -3.415   1.109  1.00 33.25           O  
ATOM    205  CB  PHE A  31      -4.074  -0.487   2.638  1.00 32.50           C  
ATOM    206  CG  PHE A  31      -3.672   0.131   1.312  1.00 33.73           C  
ATOM    207  CD1 PHE A  31      -2.451   0.792   1.174  1.00 49.67           C  
ATOM    208  CD2 PHE A  31      -4.495   0.024   0.196  1.00 34.06           C  
ATOM    209  CE1 PHE A  31      -2.058   1.334  -0.052  1.00 42.80           C  
ATOM    210  CE2 PHE A  31      -4.112   0.559  -1.032  1.00 34.28           C  
ATOM    211  CZ  PHE A  31      -2.894   1.216  -1.156  1.00 51.02           C  
ATOM    212  N   THR A  32      -5.269  -3.309   2.319  1.00 24.84           N  
ATOM    213  CA  THR A  32      -5.919  -4.303   1.486  1.00 39.65           C  
ATOM    214  C   THR A  32      -7.332  -3.844   1.138  1.00 42.53           C  
ATOM    215  O   THR A  32      -8.151  -3.532   2.015  1.00 26.16           O  
ATOM    216  CB  THR A  32      -5.954  -5.708   2.154  1.00 36.36           C  
ATOM    217  OG1 THR A  32      -6.964  -5.746   3.167  1.00 49.66           O  
ATOM    218  CG2 THR A  32      -4.599  -6.023   2.767  1.00 25.26           C  
ATOM    219  N   VAL A  33      -7.603  -3.789  -0.161  1.00 28.26           N  
ATOM    220  CA  VAL A  33      -8.894  -3.352  -0.625  1.00 22.37           C  
ATOM    221  C   VAL A  33      -9.881  -4.489  -0.657  1.00 29.52           C  
ATOM    222  O   VAL A  33      -9.658  -5.494  -1.326  1.00 38.06           O  
ATOM    223  CB  VAL A  33      -8.794  -2.720  -2.021  1.00 27.46           C  
ATOM    224  CG1 VAL A  33     -10.194  -2.342  -2.516  1.00 23.38           C  
ATOM    225  CG2 VAL A  33      -7.886  -1.474  -1.961  1.00  9.95           C  
ATOM    226  N   ALA A  34     -10.964  -4.328   0.092  1.00 22.32           N  
ATOM    227  CA  ALA A  34     -12.016  -5.325   0.135  1.00 23.88           C  
ATOM    228  C   ALA A  34     -13.073  -4.926  -0.898  1.00 33.61           C  
ATOM    229  O   ALA A  34     -13.620  -3.826  -0.873  1.00 26.53           O  
ATOM    230  CB  ALA A  34     -12.614  -5.391   1.526  1.00 31.02           C  
ATOM    231  N   SER A  35     -13.351  -5.832  -1.821  1.00 45.18           N  
ATOM    232  CA  SER A  35     -14.309  -5.550  -2.868  1.00 36.10           C  
ATOM    233  C   SER A  35     -15.253  -6.713  -3.122  1.00 38.47           C  
ATOM    234  O   SER A  35     -14.831  -7.814  -3.452  1.00 43.80           O  
ATOM    235  CB  SER A  35     -13.554  -5.206  -4.151  1.00 42.45           C  
ATOM    236  OG  SER A  35     -14.431  -5.113  -5.250  1.00 38.42           O  
ATOM    237  N   THR A  36     -16.538  -6.464  -2.946  1.00 36.36           N  
ATOM    238  CA  THR A  36     -17.538  -7.480  -3.202  1.00 50.07           C  
ATOM    239  C   THR A  36     -18.428  -6.900  -4.295  1.00 48.07           C  
ATOM    240  O   THR A  36     -19.206  -5.975  -4.068  1.00 51.72           O  
ATOM    241  CB  THR A  36     -18.356  -7.803  -1.951  1.00 42.28           C  
ATOM    242  OG1 THR A  36     -19.674  -8.200  -2.347  1.00 52.42           O  
ATOM    243  CG2 THR A  36     -18.413  -6.602  -1.018  1.00 58.22           C  
ATOM    244  N   PRO A  37     -18.318  -7.451  -5.506  1.00 43.25           N  
ATOM    245  CA  PRO A  37     -19.057  -7.040  -6.697  1.00 46.37           C  
ATOM    246  C   PRO A  37     -20.552  -7.321  -6.675  1.00 52.02           C  
ATOM    247  O   PRO A  37     -21.028  -8.178  -5.935  1.00 40.17           O  
ATOM    248  CB  PRO A  37     -18.357  -7.819  -7.791  1.00 31.21           C  
ATOM    249  CG  PRO A  37     -18.154  -9.144  -7.095  1.00 26.29           C  
ATOM    250  CD  PRO A  37     -17.622  -8.730  -5.750  1.00 42.83           C  
ATOM    251  N   ARG A  38     -21.283  -6.589  -7.503  1.00 58.40           N  
ATOM    252  CA  ARG A  38     -22.718  -6.779  -7.614  1.00 65.50           C  
ATOM    253  C   ARG A  38     -22.908  -7.694  -8.821  1.00 73.61           C  
ATOM    254  O   ARG A  38     -22.257  -7.516  -9.850  1.00 78.36           O  
ATOM    255  CB  ARG A  38     -23.414  -5.444  -7.830  1.00 54.00           C  
ATOM    256  N   ILE A  39     -23.781  -8.684  -8.686  1.00 81.48           N  
ATOM    257  CA  ILE A  39     -24.032  -9.622  -9.770  1.00 81.67           C  
ATOM    258  C   ILE A  39     -25.519  -9.733 -10.072  1.00 90.39           C  
ATOM    259  O   ILE A  39     -26.237 -10.475  -9.406  1.00 94.22           O  
ATOM    260  CB  ILE A  39     -23.497 -11.021  -9.417  1.00 77.44           C  
ATOM    261  CG1 ILE A  39     -21.976 -10.978  -9.275  1.00 72.25           C  
ATOM    262  CG2 ILE A  39     -23.904 -12.018 -10.487  1.00 82.72           C  
ATOM    263  CD1 ILE A  39     -21.359 -12.313  -8.895  1.00 73.34           C  
ATOM    264  N   TYR A  40     -25.978  -8.992 -11.077  1.00103.34           N  
ATOM    265  CA  TYR A  40     -27.384  -9.032 -11.462  1.00109.80           C  
ATOM    266  C   TYR A  40     -27.704 -10.384 -12.083  1.00111.37           C  
ATOM    267  O   TYR A  40     -27.531 -10.595 -13.282  1.00105.10           O  
ATOM    268  CB  TYR A  40     -27.709  -7.899 -12.439  1.00110.70           C  
ATOM    269  CG  TYR A  40     -27.929  -6.559 -11.766  1.00114.33           C  
ATOM    270  CD1 TYR A  40     -27.128  -5.459 -12.072  1.00112.51           C  
ATOM    271  CD2 TYR A  40     -28.952  -6.391 -10.830  1.00112.89           C  
ATOM    272  CE1 TYR A  40     -27.345  -4.218 -11.466  1.00122.12           C  
ATOM    273  CE2 TYR A  40     -29.176  -5.158 -10.220  1.00118.98           C  
ATOM    274  CZ  TYR A  40     -28.371  -4.076 -10.541  1.00127.11           C  
ATOM    275  OH  TYR A  40     -28.603  -2.852  -9.947  1.00131.86           O  
ATOM    276  N   ASP A  41     -28.171 -11.293 -11.232  1.00119.23           N  
ATOM    277  CA  ASP A  41     -28.522 -12.652 -11.622  1.00123.22           C  
ATOM    278  C   ASP A  41     -29.711 -13.150 -10.795  1.00125.67           C  
ATOM    279  O   ASP A  41     -30.020 -12.592  -9.739  1.00122.41           O  
ATOM    280  CB  ASP A  41     -27.317 -13.572 -11.395  1.00122.58           C  
ATOM    281  CG  ASP A  41     -27.655 -15.039 -11.575  1.00124.99           C  
ATOM    282  OD1 ASP A  41     -27.871 -15.462 -12.731  1.00129.95           O  
ATOM    283  OD2 ASP A  41     -27.711 -15.768 -10.560  1.00114.33           O  
ATOM    284  N   ARG A  42     -30.377 -14.191 -11.294  1.00128.19           N  
ATOM    285  CA  ARG A  42     -31.520 -14.812 -10.623  1.00128.44           C  
ATOM    286  C   ARG A  42     -32.732 -13.911 -10.347  1.00126.39           C  
ATOM    287  O   ARG A  42     -33.672 -13.870 -11.144  1.00116.87           O  
ATOM    288  CB  ARG A  42     -31.054 -15.470  -9.322  1.00127.59           C  
ATOM    289  N   GLN A  43     -32.713 -13.205  -9.216  1.00127.20           N  
ATOM    290  CA  GLN A  43     -33.821 -12.328  -8.828  1.00129.18           C  
ATOM    291  C   GLN A  43     -33.885 -11.023  -9.622  1.00130.82           C  
ATOM    292  O   GLN A  43     -34.855 -10.849 -10.393  1.00131.60           O  
ATOM    293  CB  GLN A  43     -33.733 -12.019  -7.334  1.00127.31           C  
ATOM    294  N   TRP A  47     -28.065 -15.170  -4.688  1.00105.21           N  
ATOM    295  CA  TRP A  47     -27.573 -13.849  -4.193  1.00105.18           C  
ATOM    296  C   TRP A  47     -27.322 -12.896  -5.364  1.00 98.50           C  
ATOM    297  O   TRP A  47     -26.708 -13.274  -6.361  1.00 91.42           O  
ATOM    298  CB  TRP A  47     -26.294 -14.042  -3.380  1.00105.88           C  
ATOM    299  N   LYS A  48     -27.798 -11.658  -5.230  1.00 93.37           N  
ATOM    300  CA  LYS A  48     -27.649 -10.650  -6.275  1.00 81.95           C  
ATOM    301  C   LYS A  48     -26.509  -9.676  -6.039  1.00 82.73           C  
ATOM    302  O   LYS A  48     -26.296  -8.785  -6.855  1.00 94.09           O  
ATOM    303  CB  LYS A  48     -28.948  -9.873  -6.440  1.00 75.52           C  
ATOM    304  N   ASP A  49     -25.789  -9.830  -4.933  1.00 85.37           N  
ATOM    305  CA  ASP A  49     -24.673  -8.935  -4.621  1.00 88.47           C  
ATOM    306  C   ASP A  49     -23.645  -9.587  -3.702  1.00 82.54           C  
ATOM    307  O   ASP A  49     -23.528  -9.183  -2.544  1.00 74.39           O  
ATOM    308  CB  ASP A  49     -25.166  -7.649  -3.927  1.00100.41           C  
ATOM    309  CG  ASP A  49     -25.921  -6.708  -4.861  1.00106.61           C  
ATOM    310  OD1 ASP A  49     -27.099  -6.987  -5.176  1.00112.74           O  
ATOM    311  OD2 ASP A  49     -25.332  -5.683  -5.272  1.00 97.33           O  
ATOM    312  N   GLY A  50     -22.890 -10.568  -4.197  1.00 68.99           N  
ATOM    313  CA  GLY A  50     -21.909 -11.198  -3.326  1.00 64.70           C  
ATOM    314  C   GLY A  50     -20.678 -11.848  -3.936  1.00 62.69           C  
ATOM    315  O   GLY A  50     -20.582 -11.990  -5.156  1.00 61.23           O  
ATOM    316  N   GLU A  51     -19.750 -12.239  -3.051  1.00 62.82           N  
ATOM    317  CA  GLU A  51     -18.468 -12.910  -3.356  1.00 56.02           C  
ATOM    318  C   GLU A  51     -17.262 -11.998  -3.108  1.00 54.73           C  
ATOM    319  O   GLU A  51     -16.436 -11.783  -3.994  1.00 65.05           O  
ATOM    320  CB  GLU A  51     -18.452 -13.425  -4.790  1.00 38.36           C  
ATOM    321  N   ALA A  52     -17.162 -11.492  -1.883  1.00 44.49           N  
ATOM    322  CA  ALA A  52     -16.102 -10.572  -1.469  1.00 49.29           C  
ATOM    323  C   ALA A  52     -14.655 -11.019  -1.648  1.00 33.30           C  
ATOM    324  O   ALA A  52     -14.244 -12.057  -1.147  1.00 52.95           O  
ATOM    325  CB  ALA A  52     -16.326 -10.163  -0.017  1.00 42.48           C  
ATOM    326  N   LEU A  53     -13.873 -10.207  -2.341  1.00 34.09           N  
ATOM    327  CA  LEU A  53     -12.471 -10.525  -2.549  1.00 48.09           C  
ATOM    328  C   LEU A  53     -11.633  -9.463  -1.854  1.00 41.07           C  
ATOM    329  O   LEU A  53     -12.024  -8.298  -1.813  1.00 47.45           O  
ATOM    330  CB  LEU A  53     -12.145 -10.571  -4.050  1.00 63.97           C  
ATOM    331  CG  LEU A  53     -11.404  -9.424  -4.747  1.00 67.48           C  
ATOM    332  CD1 LEU A  53     -11.119  -9.826  -6.179  1.00 72.64           C  
ATOM    333  CD2 LEU A  53     -12.221  -8.152  -4.712  1.00 78.59           C  
ATOM    334  N   PHE A  54     -10.496  -9.874  -1.295  1.00 39.36           N  
ATOM    335  CA  PHE A  54      -9.587  -8.961  -0.602  1.00 32.30           C  
ATOM    336  C   PHE A  54      -8.248  -8.876  -1.312  1.00 31.31           C  
ATOM    337  O   PHE A  54      -7.519  -9.860  -1.382  1.00 33.88           O  
ATOM    338  CB  PHE A  54      -9.373  -9.429   0.828  1.00 29.95           C  
ATOM    339  CG  PHE A  54     -10.640  -9.556   1.603  1.00 36.58           C  
ATOM    340  CD1 PHE A  54     -11.402 -10.712   1.525  1.00 39.81           C  
ATOM    341  CD2 PHE A  54     -11.104  -8.493   2.375  1.00 31.95           C  
ATOM    342  CE1 PHE A  54     -12.616 -10.809   2.204  1.00 40.53           C  
ATOM    343  CE2 PHE A  54     -12.312  -8.578   3.055  1.00 26.92           C  
ATOM    344  CZ  PHE A  54     -13.069  -9.735   2.970  1.00 44.40           C  
ATOM    345  N   LEU A  55      -7.933  -7.691  -1.832  1.00 36.41           N  
ATOM    346  CA  LEU A  55      -6.683  -7.455  -2.557  1.00 39.49           C  
ATOM    347  C   LEU A  55      -5.683  -6.642  -1.745  1.00 33.08           C  
ATOM    348  O   LEU A  55      -5.975  -5.520  -1.350  1.00 37.49           O  
ATOM    349  CB  LEU A  55      -6.975  -6.729  -3.872  1.00 36.63           C  
ATOM    350  CG  LEU A  55      -7.783  -7.523  -4.899  1.00 47.61           C  
ATOM    351  CD1 LEU A  55      -8.500  -6.574  -5.838  1.00 47.88           C  
ATOM    352  CD2 LEU A  55      -6.860  -8.453  -5.659  1.00 41.33           C  
ATOM    353  N   ARG A  56      -4.506  -7.221  -1.514  1.00 39.28           N  
ATOM    354  CA  ARG A  56      -3.434  -6.581  -0.747  1.00 33.91           C  
ATOM    355  C   ARG A  56      -2.694  -5.679  -1.710  1.00 23.83           C  
ATOM    356  O   ARG A  56      -2.241  -6.148  -2.754  1.00 28.88           O  
ATOM    357  CB  ARG A  56      -2.451  -7.636  -0.213  1.00 43.30           C  
ATOM    358  CG  ARG A  56      -3.081  -8.944   0.252  1.00 56.14           C  
ATOM    359  CD  ARG A  56      -3.848  -8.773   1.548  1.00 77.24           C  
ATOM    360  NE  ARG A  56      -4.660  -9.941   1.885  1.00 85.11           N  
ATOM    361  CZ  ARG A  56      -5.408 -10.034   2.982  1.00 89.31           C  
ATOM    362  NH1 ARG A  56      -5.445  -9.030   3.853  1.00 76.24           N  
ATOM    363  NH2 ARG A  56      -6.128 -11.126   3.205  1.00 91.31           N  
ATOM    364  N   CYS A  57      -2.553  -4.404  -1.357  1.00 27.11           N  
ATOM    365  CA  CYS A  57      -1.866  -3.428  -2.214  1.00 36.84           C  
ATOM    366  C   CYS A  57      -0.631  -2.794  -1.560  1.00 34.19           C  
ATOM    367  O   CYS A  57      -0.529  -2.726  -0.334  1.00 42.71           O  
ATOM    368  CB  CYS A  57      -2.829  -2.302  -2.595  1.00 38.64           C  
ATOM    369  SG  CYS A  57      -4.522  -2.801  -2.903  1.00 37.73           S  
ATOM    370  N   ASN A  58       0.292  -2.313  -2.386  1.00 37.96           N  
ATOM    371  CA  ASN A  58       1.509  -1.673  -1.895  1.00 41.44           C  
ATOM    372  C   ASN A  58       1.758  -0.370  -2.635  1.00 43.40           C  
ATOM    373  O   ASN A  58       2.110  -0.396  -3.807  1.00 57.26           O  
ATOM    374  CB  ASN A  58       2.729  -2.566  -2.121  1.00 38.49           C  
ATOM    375  CG  ASN A  58       2.437  -4.030  -1.882  1.00 57.12           C  
ATOM    376  OD1 ASN A  58       1.933  -4.411  -0.822  1.00 60.52           O  
ATOM    377  ND2 ASN A  58       2.758  -4.868  -2.869  1.00 45.59           N  
ATOM    378  N   ILE A  59       1.573   0.768  -1.977  1.00 45.28           N  
ATOM    379  CA  ILE A  59       1.857   2.024  -2.651  1.00 44.67           C  
ATOM    380  C   ILE A  59       3.219   2.509  -2.171  1.00 50.78           C  
ATOM    381  O   ILE A  59       3.555   2.391  -0.993  1.00 54.36           O  
ATOM    382  CB  ILE A  59       0.779   3.083  -2.394  1.00 50.39           C  
ATOM    383  CG1 ILE A  59       1.078   4.320  -3.247  1.00 41.66           C  
ATOM    384  CG2 ILE A  59       0.703   3.409  -0.922  1.00 55.20           C  
ATOM    385  CD1 ILE A  59      -0.073   5.285  -3.352  1.00 44.54           C  
ATOM    386  N   TRP A  60       4.006   3.038  -3.100  1.00 59.63           N  
ATOM    387  CA  TRP A  60       5.357   3.493  -2.807  1.00 61.22           C  
ATOM    388  C   TRP A  60       5.584   5.000  -2.884  1.00 65.65           C  
ATOM    389  O   TRP A  60       4.675   5.764  -3.202  1.00 69.00           O  
ATOM    390  CB  TRP A  60       6.321   2.787  -3.764  1.00 64.36           C  
ATOM    391  CG  TRP A  60       7.111   1.683  -3.139  1.00 71.34           C  
ATOM    392  CD1 TRP A  60       8.252   1.807  -2.403  1.00 65.14           C  
ATOM    393  CD2 TRP A  60       6.819   0.280  -3.189  1.00 72.91           C  
ATOM    394  NE1 TRP A  60       8.692   0.573  -1.994  1.00 69.45           N  
ATOM    395  CE2 TRP A  60       7.833  -0.377  -2.461  1.00 77.21           C  
ATOM    396  CE3 TRP A  60       5.801  -0.472  -3.782  1.00 89.04           C  
ATOM    397  CZ2 TRP A  60       7.855  -1.768  -2.306  1.00 86.93           C  
ATOM    398  CZ3 TRP A  60       5.826  -1.859  -3.625  1.00105.13           C  
ATOM    399  CH2 TRP A  60       6.849  -2.489  -2.893  1.00 98.45           C  
ATOM    400  N   ARG A  61       6.817   5.409  -2.585  1.00 76.18           N  
ATOM    401  CA  ARG A  61       7.235   6.810  -2.629  1.00 75.51           C  
ATOM    402  C   ARG A  61       6.415   7.788  -1.773  1.00 79.75           C  
ATOM    403  O   ARG A  61       5.841   7.421  -0.745  1.00 75.59           O  
ATOM    404  CB  ARG A  61       7.252   7.302  -4.085  1.00 79.23           C  
ATOM    405  CG  ARG A  61       8.622   7.279  -4.783  1.00 81.73           C  
ATOM    406  CD  ARG A  61       9.046   5.905  -5.295  1.00 84.56           C  
ATOM    407  NE  ARG A  61      10.125   5.315  -4.500  1.00 92.59           N  
ATOM    408  CZ  ARG A  61      10.843   4.257  -4.874  1.00 94.50           C  
ATOM    409  NH1 ARG A  61      10.605   3.666  -6.037  1.00104.94           N  
ATOM    410  NH2 ARG A  61      11.797   3.779  -4.083  1.00 78.90           N  
ATOM    411  N   GLU A  62       6.383   9.042  -2.219  1.00 75.94           N  
ATOM    412  CA  GLU A  62       5.670  10.121  -1.541  1.00 75.31           C  
ATOM    413  C   GLU A  62       4.230   9.760  -1.161  1.00 71.30           C  
ATOM    414  O   GLU A  62       3.804   9.984  -0.027  1.00 69.40           O  
ATOM    415  CB  GLU A  62       5.677  11.356  -2.444  1.00 88.79           C  
ATOM    416  CG  GLU A  62       5.257  12.659  -1.783  1.00104.37           C  
ATOM    417  CD  GLU A  62       5.311  13.834  -2.752  1.00116.01           C  
ATOM    418  OE1 GLU A  62       6.371  14.041  -3.381  1.00121.19           O  
ATOM    419  OE2 GLU A  62       4.296  14.552  -2.882  1.00118.44           O  
ATOM    420  N   ALA A  63       3.491   9.199  -2.118  1.00 64.18           N  
ATOM    421  CA  ALA A  63       2.097   8.808  -1.917  1.00 47.72           C  
ATOM    422  C   ALA A  63       1.891   7.809  -0.783  1.00 54.98           C  
ATOM    423  O   ALA A  63       0.769   7.653  -0.286  1.00 48.84           O  
ATOM    424  CB  ALA A  63       1.533   8.242  -3.202  1.00 40.15           C  
ATOM    425  N   ALA A  64       2.964   7.123  -0.386  1.00 49.27           N  
ATOM    426  CA  ALA A  64       2.866   6.165   0.699  1.00 45.51           C  
ATOM    427  C   ALA A  64       2.469   6.907   1.960  1.00 58.45           C  
ATOM    428  O   ALA A  64       1.702   6.402   2.780  1.00 62.25           O  
ATOM    429  N   GLU A  65       2.977   8.129   2.100  1.00 57.95           N  
ATOM    430  CA  GLU A  65       2.690   8.951   3.270  1.00 56.22           C  
ATOM    431  C   GLU A  65       1.377   9.738   3.151  1.00 56.66           C  
ATOM    432  O   GLU A  65       0.661   9.910   4.140  1.00 49.85           O  
ATOM    433  CB  GLU A  65       3.870   9.889   3.526  1.00 46.15           C  
ATOM    434  CG  GLU A  65       5.208   9.155   3.474  1.00 64.69           C  
ATOM    435  CD  GLU A  65       6.393  10.001   3.911  1.00 70.60           C  
ATOM    436  OE1 GLU A  65       6.459  11.194   3.538  1.00 81.07           O  
ATOM    437  OE2 GLU A  65       7.273   9.460   4.612  1.00 78.18           O  
ATOM    438  N   ASN A  66       1.060  10.209   1.947  1.00 51.15           N  
ATOM    439  CA  ASN A  66      -0.182  10.946   1.723  1.00 49.51           C  
ATOM    440  C   ASN A  66      -1.365  10.011   1.963  1.00 59.77           C  
ATOM    441  O   ASN A  66      -2.429  10.427   2.427  1.00 62.67           O  
ATOM    442  CB  ASN A  66      -0.250  11.452   0.286  1.00 49.59           C  
ATOM    443  CG  ASN A  66       0.937  12.300  -0.088  1.00 49.17           C  
ATOM    444  OD1 ASN A  66       1.174  13.350   0.504  1.00 56.97           O  
ATOM    445  ND2 ASN A  66       1.695  11.849  -1.078  1.00 36.77           N  
ATOM    446  N   VAL A  67      -1.162   8.743   1.621  1.00 60.83           N  
ATOM    447  CA  VAL A  67      -2.180   7.718   1.781  1.00 41.47           C  
ATOM    448  C   VAL A  67      -2.342   7.398   3.246  1.00 44.98           C  
ATOM    449  O   VAL A  67      -3.463   7.354   3.758  1.00 52.14           O  
ATOM    450  CB  VAL A  67      -1.786   6.448   1.004  1.00 36.97           C  
ATOM    451  CG1 VAL A  67      -2.515   5.225   1.543  1.00 20.05           C  
ATOM    452  CG2 VAL A  67      -2.114   6.651  -0.454  1.00 39.43           C  
ATOM    453  N   ALA A  68      -1.217   7.180   3.920  1.00 30.33           N  
ATOM    454  CA  ALA A  68      -1.244   6.865   5.340  1.00 36.06           C  
ATOM    455  C   ALA A  68      -1.844   8.024   6.138  1.00 32.04           C  
ATOM    456  O   ALA A  68      -2.403   7.831   7.221  1.00 41.14           O  
ATOM    457  CB  ALA A  68       0.159   6.558   5.831  1.00 37.84           C  
ATOM    458  N   GLU A  69      -1.727   9.229   5.596  1.00 32.17           N  
ATOM    459  CA  GLU A  69      -2.264  10.408   6.254  1.00 44.38           C  
ATOM    460  C   GLU A  69      -3.737  10.650   5.934  1.00 49.91           C  
ATOM    461  O   GLU A  69      -4.533  10.927   6.832  1.00 62.72           O  
ATOM    462  CB  GLU A  69      -1.461  11.654   5.868  1.00 35.03           C  
ATOM    463  CG  GLU A  69      -2.172  12.958   6.249  1.00 43.15           C  
ATOM    464  CD  GLU A  69      -1.362  14.214   5.942  1.00 64.91           C  
ATOM    465  OE1 GLU A  69      -1.921  15.321   6.110  1.00 55.12           O  
ATOM    466  OE2 GLU A  69      -0.177  14.103   5.541  1.00 60.31           O  
ATOM    467  N   SER A  70      -4.093  10.529   4.659  1.00 48.71           N  
ATOM    468  CA  SER A  70      -5.457  10.779   4.201  1.00 44.65           C  
ATOM    469  C   SER A  70      -6.495   9.686   4.418  1.00 44.32           C  
ATOM    470  O   SER A  70      -7.586   9.966   4.911  1.00 49.01           O  
ATOM    471  CB  SER A  70      -5.447  11.134   2.710  1.00 42.74           C  
ATOM    472  OG  SER A  70      -4.535  12.178   2.429  1.00 43.42           O  
ATOM    473  N   LEU A  71      -6.170   8.450   4.050  1.00 40.09           N  
ATOM    474  CA  LEU A  71      -7.127   7.345   4.161  1.00 48.73           C  
ATOM    475  C   LEU A  71      -7.159   6.587   5.490  1.00 50.20           C  
ATOM    476  O   LEU A  71      -6.163   6.536   6.215  1.00 55.35           O  
ATOM    477  CB  LEU A  71      -6.880   6.342   3.023  1.00 36.72           C  
ATOM    478  CG  LEU A  71      -6.718   6.922   1.612  1.00 45.10           C  
ATOM    479  CD1 LEU A  71      -6.389   5.803   0.636  1.00 45.54           C  
ATOM    480  CD2 LEU A  71      -7.986   7.645   1.193  1.00 39.30           C  
ATOM    481  N   THR A  72      -8.309   5.991   5.798  1.00 35.29           N  
ATOM    482  CA  THR A  72      -8.462   5.203   7.021  1.00 39.32           C  
ATOM    483  C   THR A  72      -9.413   4.016   6.831  1.00 38.95           C  
ATOM    484  O   THR A  72     -10.191   3.979   5.881  1.00 39.83           O  
ATOM    485  CB  THR A  72      -9.005   6.055   8.186  1.00 41.65           C  
ATOM    486  OG1 THR A  72     -10.378   6.393   7.943  1.00 54.10           O  
ATOM    487  CG2 THR A  72      -8.195   7.327   8.337  1.00 50.28           C  
ATOM    488  N   ARG A  73      -9.351   3.055   7.747  1.00 32.78           N  
ATOM    489  CA  ARG A  73     -10.214   1.874   7.703  1.00 40.97           C  
ATOM    490  C   ARG A  73     -11.662   2.195   7.284  1.00 42.52           C  
ATOM    491  O   ARG A  73     -12.251   3.161   7.755  1.00 38.50           O  
ATOM    492  CB  ARG A  73     -10.218   1.201   9.077  1.00 48.03           C  
ATOM    493  CG  ARG A  73     -11.057  -0.060   9.172  1.00 39.19           C  
ATOM    494  CD  ARG A  73     -12.011   0.025  10.349  1.00 51.84           C  
ATOM    495  NE  ARG A  73     -12.698  -1.239  10.608  1.00 67.13           N  
ATOM    496  CZ  ARG A  73     -12.139  -2.296  11.193  1.00 63.86           C  
ATOM    497  NH1 ARG A  73     -12.849  -3.403  11.380  1.00 60.02           N  
ATOM    498  NH2 ARG A  73     -10.875  -2.246  11.598  1.00 52.85           N  
ATOM    499  N   GLY A  74     -12.220   1.374   6.393  1.00 47.39           N  
ATOM    500  CA  GLY A  74     -13.584   1.573   5.927  1.00 33.46           C  
ATOM    501  C   GLY A  74     -13.740   2.495   4.724  1.00 38.45           C  
ATOM    502  O   GLY A  74     -14.846   2.659   4.207  1.00 44.10           O  
ATOM    503  N   ALA A  75     -12.631   3.079   4.277  1.00 26.71           N  
ATOM    504  CA  ALA A  75     -12.602   4.018   3.156  1.00 33.46           C  
ATOM    505  C   ALA A  75     -12.823   3.420   1.781  1.00 32.03           C  
ATOM    506  O   ALA A  75     -12.238   2.397   1.448  1.00 44.24           O  
ATOM    507  CB  ALA A  75     -11.275   4.766   3.153  1.00 25.28           C  
ATOM    508  N   ARG A  76     -13.654   4.079   0.980  1.00 29.39           N  
ATOM    509  CA  ARG A  76     -13.916   3.623  -0.375  1.00 40.79           C  
ATOM    510  C   ARG A  76     -12.892   4.272  -1.294  1.00 45.30           C  
ATOM    511  O   ARG A  76     -12.921   5.488  -1.522  1.00 42.91           O  
ATOM    512  CB  ARG A  76     -15.331   3.996  -0.834  1.00 18.54           C  
ATOM    513  CG  ARG A  76     -15.487   3.898  -2.350  1.00 31.55           C  
ATOM    514  CD  ARG A  76     -16.931   3.923  -2.821  1.00 29.23           C  
ATOM    515  NE  ARG A  76     -17.540   2.601  -2.752  1.00 45.13           N  
ATOM    516  CZ  ARG A  76     -18.168   2.014  -3.766  1.00 39.55           C  
ATOM    517  NH1 ARG A  76     -18.267   2.629  -4.929  1.00 46.81           N  
ATOM    518  NH2 ARG A  76     -18.708   0.811  -3.614  1.00 62.75           N  
ATOM    519  N   VAL A  77     -11.994   3.455  -1.834  1.00 33.96           N  
ATOM    520  CA  VAL A  77     -10.952   3.968  -2.699  1.00 22.13           C  
ATOM    521  C   VAL A  77     -11.048   3.464  -4.125  1.00 18.55           C  
ATOM    522  O   VAL A  77     -11.681   2.450  -4.392  1.00 29.45           O  
ATOM    523  CB  VAL A  77      -9.560   3.584  -2.143  1.00 31.86           C  
ATOM    524  CG1 VAL A  77      -9.314   4.259  -0.796  1.00 19.67           C  
ATOM    525  CG2 VAL A  77      -9.476   2.077  -1.990  1.00 12.99           C  
ATOM    526  N   ILE A  78     -10.424   4.203  -5.036  1.00 23.20           N  
ATOM    527  CA  ILE A  78     -10.340   3.841  -6.450  1.00 24.65           C  
ATOM    528  C   ILE A  78      -8.837   3.601  -6.649  1.00 22.18           C  
ATOM    529  O   ILE A  78      -8.017   4.502  -6.487  1.00 29.49           O  
ATOM    530  CB  ILE A  78     -10.789   4.992  -7.362  1.00 30.56           C  
ATOM    531  CG1 ILE A  78     -12.112   5.546  -6.866  1.00 38.20           C  
ATOM    532  CG2 ILE A  78     -10.963   4.492  -8.808  1.00 26.71           C  
ATOM    533  CD1 ILE A  78     -12.568   6.770  -7.628  1.00 62.26           C  
ATOM    534  N   VAL A  79      -8.476   2.379  -6.990  1.00 24.83           N  
ATOM    535  CA  VAL A  79      -7.077   2.031  -7.157  1.00 23.03           C  
ATOM    536  C   VAL A  79      -6.750   1.689  -8.601  1.00 31.22           C  
ATOM    537  O   VAL A  79      -7.515   1.016  -9.288  1.00 30.70           O  
ATOM    538  CB  VAL A  79      -6.733   0.819  -6.264  1.00 29.06           C  
ATOM    539  CG1 VAL A  79      -5.271   0.483  -6.359  1.00 22.97           C  
ATOM    540  CG2 VAL A  79      -7.130   1.117  -4.828  1.00 28.83           C  
ATOM    541  N   SER A  80      -5.613   2.179  -9.070  1.00 26.52           N  
ATOM    542  CA  SER A  80      -5.178   1.877 -10.421  1.00 23.79           C  
ATOM    543  C   SER A  80      -3.794   1.277 -10.273  1.00 23.82           C  
ATOM    544  O   SER A  80      -2.985   1.760  -9.483  1.00 29.72           O  
ATOM    545  CB  SER A  80      -5.107   3.142 -11.263  1.00 24.39           C  
ATOM    546  OG  SER A  80      -4.609   2.839 -12.551  1.00 51.76           O  
ATOM    547  N   GLY A  81      -3.506   0.216 -11.006  1.00 19.60           N  
ATOM    548  CA  GLY A  81      -2.185  -0.355 -10.867  1.00 33.51           C  
ATOM    549  C   GLY A  81      -1.924  -1.571 -11.708  1.00 34.67           C  
ATOM    550  O   GLY A  81      -2.481  -1.722 -12.795  1.00 43.25           O  
ATOM    551  N   ARG A  82      -1.065  -2.440 -11.194  1.00 29.05           N  
ATOM    552  CA  ARG A  82      -0.705  -3.664 -11.887  1.00 33.36           C  
ATOM    553  C   ARG A  82      -0.530  -4.781 -10.857  1.00 26.87           C  
ATOM    554  O   ARG A  82      -0.246  -4.515  -9.696  1.00 29.05           O  
ATOM    555  CB  ARG A  82       0.597  -3.432 -12.656  1.00 20.80           C  
ATOM    556  CG  ARG A  82       1.826  -3.320 -11.768  1.00 47.87           C  
ATOM    557  CD  ARG A  82       3.001  -2.632 -12.467  1.00 51.62           C  
ATOM    558  NE  ARG A  82       3.214  -3.138 -13.819  1.00 78.91           N  
ATOM    559  CZ  ARG A  82       3.435  -4.412 -14.122  1.00 86.67           C  
ATOM    560  NH1 ARG A  82       3.481  -5.332 -13.167  1.00102.28           N  
ATOM    561  NH2 ARG A  82       3.593  -4.770 -15.389  1.00 92.08           N  
ATOM    562  N   LEU A  83      -0.727  -6.024 -11.277  1.00 36.16           N  
ATOM    563  CA  LEU A  83      -0.563  -7.168 -10.386  1.00 29.13           C  
ATOM    564  C   LEU A  83       0.889  -7.638 -10.493  1.00 33.21           C  
ATOM    565  O   LEU A  83       1.402  -7.843 -11.592  1.00 31.55           O  
ATOM    566  CB  LEU A  83      -1.497  -8.315 -10.800  1.00 32.33           C  
ATOM    567  CG  LEU A  83      -3.008  -8.072 -10.832  1.00 41.07           C  
ATOM    568  CD1 LEU A  83      -3.746  -9.308 -11.390  1.00 19.98           C  
ATOM    569  CD2 LEU A  83      -3.477  -7.728  -9.421  1.00 29.99           C  
ATOM    570  N   LYS A  84       1.553  -7.785  -9.353  1.00 39.59           N  
ATOM    571  CA  LYS A  84       2.935  -8.243  -9.319  1.00 35.17           C  
ATOM    572  C   LYS A  84       2.912  -9.530  -8.510  1.00 41.22           C  
ATOM    573  O   LYS A  84       2.144  -9.649  -7.560  1.00 33.89           O  
ATOM    574  CB  LYS A  84       3.827  -7.201  -8.648  1.00 44.95           C  
ATOM    575  CG  LYS A  84       5.307  -7.486  -8.793  1.00 65.09           C  
ATOM    576  CD  LYS A  84       6.145  -6.294  -8.362  1.00 74.76           C  
ATOM    577  CE  LYS A  84       7.624  -6.547  -8.633  1.00 87.60           C  
ATOM    578  NZ  LYS A  84       8.470  -5.360  -8.314  1.00 83.12           N  
ATOM    579  N   GLN A  85       3.739 -10.497  -8.883  1.00 53.83           N  
ATOM    580  CA  GLN A  85       3.741 -11.775  -8.185  1.00 70.51           C  
ATOM    581  C   GLN A  85       4.809 -11.897  -7.110  1.00 75.75           C  
ATOM    582  O   GLN A  85       4.897 -12.917  -6.426  1.00 75.82           O  
ATOM    583  CB  GLN A  85       3.872 -12.911  -9.199  1.00 77.67           C  
ATOM    584  CG  GLN A  85       3.539 -14.283  -8.646  1.00 87.57           C  
ATOM    585  CD  GLN A  85       3.102 -15.241  -9.733  1.00100.12           C  
ATOM    586  OE1 GLN A  85       3.774 -15.387 -10.754  1.00105.02           O  
ATOM    587  NE2 GLN A  85       1.968 -15.900  -9.521  1.00107.67           N  
ATOM    588  N   ARG A  86       5.613 -10.853  -6.957  1.00 82.96           N  
ATOM    589  CA  ARG A  86       6.656 -10.845  -5.941  1.00 90.91           C  
ATOM    590  C   ARG A  86       6.020 -10.980  -4.553  1.00 91.74           C  
ATOM    591  O   ARG A  86       5.131 -11.808  -4.345  1.00 89.16           O  
ATOM    592  CB  ARG A  86       7.462  -9.547  -6.031  1.00 92.53           C  
ATOM    593  N   SER A  87       6.484 -10.157  -3.614  1.00 90.60           N  
ATOM    594  CA  SER A  87       5.990 -10.144  -2.239  1.00 95.37           C  
ATOM    595  C   SER A  87       7.057  -9.557  -1.321  1.00104.82           C  
ATOM    596  O   SER A  87       6.799  -8.494  -0.712  1.00110.04           O  
ATOM    597  CB  SER A  87       5.643 -11.550  -1.780  1.00 88.82           C  
ATOM    598  N   THR A  97       1.685 -18.830  -2.877  1.00116.00           N  
ATOM    599  CA  THR A  97       0.719 -17.677  -2.658  1.00111.62           C  
ATOM    600  C   THR A  97       1.359 -16.352  -2.898  1.00106.52           C  
ATOM    601  O   THR A  97       2.512 -16.326  -3.285  1.00107.94           O  
ATOM    602  CB  THR A  97       0.185 -17.752  -1.248  1.00113.70           C  
ATOM    603  N   VAL A  98       0.627 -15.246  -2.684  1.00 97.13           N  
ATOM    604  CA  VAL A  98       0.979 -13.790  -2.876  1.00 85.68           C  
ATOM    605  C   VAL A  98       0.977 -13.051  -4.227  1.00 77.26           C  
ATOM    606  O   VAL A  98       2.011 -13.015  -4.928  1.00 70.93           O  
ATOM    607  CB  VAL A  98       2.358 -13.335  -2.172  1.00 89.24           C  
ATOM    608  CG1 VAL A  98       2.694 -11.870  -2.591  1.00107.65           C  
ATOM    609  CG2 VAL A  98       2.236 -13.359  -0.662  1.00100.53           C  
ATOM    610  N   ILE A  99      -0.168 -12.548  -4.700  1.00 72.06           N  
ATOM    611  CA  ILE A  99      -0.142 -11.730  -5.903  1.00 53.11           C  
ATOM    612  C   ILE A  99      -0.660 -10.452  -5.267  1.00 49.53           C  
ATOM    613  O   ILE A  99      -1.650 -10.496  -4.532  1.00 42.88           O  
ATOM    614  CB  ILE A  99      -1.100 -12.168  -7.042  1.00 48.57           C  
ATOM    615  CG1 ILE A  99      -0.447 -13.271  -7.860  1.00 36.77           C  
ATOM    616  CG2 ILE A  99      -1.428 -10.968  -7.941  1.00 48.90           C  
ATOM    617  CD1 ILE A  99      -1.227 -13.660  -9.083  1.00 36.27           C  
ATOM    618  N   GLU A 100       0.013  -9.325  -5.467  1.00 35.24           N  
ATOM    619  CA  GLU A 100      -0.431  -8.081  -4.839  1.00 45.79           C  
ATOM    620  C   GLU A 100      -0.624  -7.013  -5.899  1.00 48.42           C  
ATOM    621  O   GLU A 100      -0.274  -7.214  -7.068  1.00 43.62           O  
ATOM    622  CB  GLU A 100       0.608  -7.622  -3.810  1.00 53.20           C  
ATOM    623  CG  GLU A 100       0.938  -8.691  -2.766  1.00 69.27           C  
ATOM    624  CD  GLU A 100       2.135  -8.340  -1.895  1.00 69.89           C  
ATOM    625  OE1 GLU A 100       3.257  -8.199  -2.440  1.00 56.72           O  
ATOM    626  OE2 GLU A 100       1.950  -8.212  -0.665  1.00 68.34           O  
ATOM    627  N   VAL A 101      -1.198  -5.885  -5.497  1.00 41.87           N  
ATOM    628  CA  VAL A 101      -1.415  -4.801  -6.430  1.00 31.20           C  
ATOM    629  C   VAL A 101      -0.367  -3.733  -6.224  1.00 35.72           C  
ATOM    630  O   VAL A 101      -0.243  -3.167  -5.136  1.00 33.08           O  
ATOM    631  CB  VAL A 101      -2.801  -4.163  -6.264  1.00 38.39           C  
ATOM    632  CG1 VAL A 101      -3.016  -3.122  -7.356  1.00 20.27           C  
ATOM    633  CG2 VAL A 101      -3.873  -5.234  -6.318  1.00 30.50           C  
ATOM    634  N   GLU A 102       0.404  -3.485  -7.276  1.00 40.17           N  
ATOM    635  CA  GLU A 102       1.441  -2.467  -7.248  1.00 39.10           C  
ATOM    636  C   GLU A 102       0.679  -1.210  -7.627  1.00 33.46           C  
ATOM    637  O   GLU A 102       0.527  -0.906  -8.808  1.00 45.14           O  
ATOM    638  CB  GLU A 102       2.508  -2.787  -8.297  1.00 59.73           C  
ATOM    639  CG  GLU A 102       3.877  -2.152  -8.063  1.00 80.67           C  
ATOM    640  CD  GLU A 102       4.680  -2.844  -6.970  1.00 96.02           C  
ATOM    641  OE1 GLU A 102       5.894  -2.563  -6.873  1.00109.87           O  
ATOM    642  OE2 GLU A 102       4.112  -3.658  -6.207  1.00 92.25           O  
ATOM    643  N   VAL A 103       0.176  -0.499  -6.624  1.00 27.51           N  
ATOM    644  CA  VAL A 103      -0.602   0.705  -6.859  1.00 22.32           C  
ATOM    645  C   VAL A 103       0.176   1.800  -7.565  1.00 31.01           C  
ATOM    646  O   VAL A 103       1.288   2.120  -7.167  1.00 42.00           O  
ATOM    647  CB  VAL A 103      -1.126   1.295  -5.549  1.00 31.74           C  
ATOM    648  CG1 VAL A 103      -2.095   2.428  -5.851  1.00 32.83           C  
ATOM    649  CG2 VAL A 103      -1.784   0.222  -4.719  1.00 23.95           C  
ATOM    650  N   ASP A 104      -0.421   2.377  -8.608  1.00 37.78           N  
ATOM    651  CA  ASP A 104       0.199   3.460  -9.365  1.00 33.66           C  
ATOM    652  C   ASP A 104      -0.500   4.770  -9.004  1.00 46.46           C  
ATOM    653  O   ASP A 104       0.130   5.824  -8.944  1.00 59.04           O  
ATOM    654  CB  ASP A 104       0.078   3.195 -10.864  1.00 36.57           C  
ATOM    655  CG  ASP A 104       0.742   1.884 -11.282  1.00 64.88           C  
ATOM    656  OD1 ASP A 104       0.356   1.319 -12.329  1.00 66.97           O  
ATOM    657  OD2 ASP A 104       1.656   1.416 -10.568  1.00 69.56           O  
ATOM    658  N   GLU A 105      -1.805   4.689  -8.755  1.00 43.02           N  
ATOM    659  CA  GLU A 105      -2.621   5.847  -8.381  1.00 35.55           C  
ATOM    660  C   GLU A 105      -3.733   5.384  -7.452  1.00 32.85           C  
ATOM    661  O   GLU A 105      -4.348   4.350  -7.692  1.00 38.98           O  
ATOM    662  CB  GLU A 105      -3.280   6.479  -9.610  1.00 43.24           C  
ATOM    663  CG  GLU A 105      -2.359   7.189 -10.590  1.00 53.46           C  
ATOM    664  CD  GLU A 105      -2.004   8.591 -10.151  1.00 52.46           C  
ATOM    665  OE1 GLU A 105      -2.866   9.260  -9.538  1.00 46.42           O  
ATOM    666  OE2 GLU A 105      -0.870   9.029 -10.435  1.00 44.92           O  
ATOM    667  N   ILE A 106      -3.993   6.138  -6.393  1.00 34.93           N  
ATOM    668  CA  ILE A 106      -5.069   5.784  -5.473  1.00 31.56           C  
ATOM    669  C   ILE A 106      -5.806   7.053  -5.074  1.00 35.44           C  
ATOM    670  O   ILE A 106      -5.203   8.115  -4.967  1.00 48.99           O  
ATOM    671  CB  ILE A 106      -4.542   5.063  -4.194  1.00 33.97           C  
ATOM    672  CG1 ILE A 106      -5.721   4.774  -3.251  1.00 29.29           C  
ATOM    673  CG2 ILE A 106      -3.476   5.909  -3.502  1.00 29.54           C  
ATOM    674  CD1 ILE A 106      -5.427   3.778  -2.162  1.00 30.88           C  
ATOM    675  N   GLY A 107      -7.112   6.952  -4.864  1.00 39.65           N  
ATOM    676  CA  GLY A 107      -7.863   8.134  -4.489  1.00 31.54           C  
ATOM    677  C   GLY A 107      -9.175   7.816  -3.815  1.00 34.79           C  
ATOM    678  O   GLY A 107      -9.848   6.861  -4.196  1.00 35.07           O  
ATOM    679  N   PRO A 108      -9.562   8.602  -2.796  1.00 39.64           N  
ATOM    680  CA  PRO A 108     -10.814   8.407  -2.054  1.00 35.81           C  
ATOM    681  C   PRO A 108     -11.986   8.616  -3.006  1.00 27.66           C  
ATOM    682  O   PRO A 108     -12.139   9.690  -3.569  1.00 28.60           O  
ATOM    683  CB  PRO A 108     -10.756   9.493  -0.980  1.00 28.12           C  
ATOM    684  CG  PRO A 108      -9.297   9.797  -0.858  1.00 36.78           C  
ATOM    685  CD  PRO A 108      -8.812   9.749  -2.265  1.00 33.29           C  
ATOM    686  N   SER A 109     -12.805   7.593  -3.198  1.00 31.57           N  
ATOM    687  CA  SER A 109     -13.930   7.728  -4.107  1.00 27.86           C  
ATOM    688  C   SER A 109     -14.891   8.796  -3.633  1.00 27.78           C  
ATOM    689  O   SER A 109     -15.277   8.817  -2.463  1.00 37.30           O  
ATOM    690  CB  SER A 109     -14.673   6.405  -4.238  1.00 15.88           C  
ATOM    691  OG  SER A 109     -15.847   6.585  -5.019  1.00 42.73           O  
ATOM    692  N   LEU A 110     -15.273   9.683  -4.546  1.00 27.88           N  
ATOM    693  CA  LEU A 110     -16.209  10.762  -4.232  1.00 38.01           C  
ATOM    694  C   LEU A 110     -17.667  10.320  -4.271  1.00 41.14           C  
ATOM    695  O   LEU A 110     -18.577  11.144  -4.335  1.00 45.10           O  
ATOM    696  CB  LEU A 110     -16.015  11.955  -5.175  1.00 25.22           C  
ATOM    697  CG  LEU A 110     -14.930  12.919  -4.706  1.00 39.05           C  
ATOM    698  CD1 LEU A 110     -14.987  14.214  -5.524  1.00 24.00           C  
ATOM    699  CD2 LEU A 110     -15.138  13.202  -3.218  1.00 28.12           C  
ATOM    700  N   ARG A 111     -17.887   9.015  -4.278  1.00 39.26           N  
ATOM    701  CA  ARG A 111     -19.242   8.503  -4.249  1.00 46.68           C  
ATOM    702  C   ARG A 111     -19.480   8.319  -2.759  1.00 62.03           C  
ATOM    703  O   ARG A 111     -18.566   7.907  -2.027  1.00 69.99           O  
ATOM    704  CB  ARG A 111     -19.333   7.149  -4.946  1.00 35.52           C  
ATOM    705  CG  ARG A 111     -20.715   6.548  -4.869  1.00 42.91           C  
ATOM    706  CD  ARG A 111     -20.783   5.100  -5.369  1.00 54.24           C  
ATOM    707  NE  ARG A 111     -20.550   4.947  -6.803  1.00 43.93           N  
ATOM    708  CZ  ARG A 111     -21.018   3.935  -7.527  1.00 45.77           C  
ATOM    709  NH1 ARG A 111     -21.753   2.991  -6.955  1.00 50.90           N  
ATOM    710  NH2 ARG A 111     -20.756   3.866  -8.826  1.00 51.94           N  
ATOM    711  N   TYR A 112     -20.682   8.640  -2.298  1.00 56.34           N  
ATOM    712  CA  TYR A 112     -21.007   8.480  -0.880  1.00 54.87           C  
ATOM    713  C   TYR A 112     -20.189   9.368   0.062  1.00 50.45           C  
ATOM    714  O   TYR A 112     -20.418   9.354   1.267  1.00 57.17           O  
ATOM    715  CB  TYR A 112     -20.806   7.023  -0.455  1.00 39.33           C  
ATOM    716  CG  TYR A 112     -21.495   6.007  -1.333  1.00 44.80           C  
ATOM    717  CD1 TYR A 112     -20.972   4.723  -1.466  1.00 33.08           C  
ATOM    718  CD2 TYR A 112     -22.659   6.326  -2.043  1.00 42.32           C  
ATOM    719  CE1 TYR A 112     -21.574   3.781  -2.287  1.00 48.91           C  
ATOM    720  CE2 TYR A 112     -23.276   5.388  -2.873  1.00 45.60           C  
ATOM    721  CZ  TYR A 112     -22.724   4.114  -2.990  1.00 56.93           C  
ATOM    722  OH  TYR A 112     -23.290   3.177  -3.832  1.00 58.80           O  
ATOM    723  N   ALA A 113     -19.241  10.137  -0.461  1.00 47.85           N  
ATOM    724  CA  ALA A 113     -18.433  10.986   0.409  1.00 47.00           C  
ATOM    725  C   ALA A 113     -17.884  12.228  -0.276  1.00 50.35           C  
ATOM    726  O   ALA A 113     -18.025  12.400  -1.485  1.00 55.19           O  
ATOM    727  CB  ALA A 113     -17.289  10.174   0.985  1.00 25.93           C  
ATOM    728  N   THR A 114     -17.269  13.102   0.515  1.00 49.20           N  
ATOM    729  CA  THR A 114     -16.658  14.320  -0.010  1.00 45.36           C  
ATOM    730  C   THR A 114     -15.244  14.394   0.540  1.00 45.58           C  
ATOM    731  O   THR A 114     -14.858  13.584   1.383  1.00 42.81           O  
ATOM    732  CB  THR A 114     -17.436  15.597   0.400  1.00 52.95           C  
ATOM    733  OG1 THR A 114     -17.661  15.606   1.817  1.00 52.72           O  
ATOM    734  CG2 THR A 114     -18.763  15.662  -0.328  1.00 39.75           C  
ATOM    735  N   ALA A 115     -14.467  15.357   0.066  1.00 38.47           N  
ATOM    736  CA  ALA A 115     -13.097  15.469   0.535  1.00 52.10           C  
ATOM    737  C   ALA A 115     -12.506  16.842   0.286  1.00 66.04           C  
ATOM    738  O   ALA A 115     -12.918  17.549  -0.637  1.00 68.61           O  
ATOM    739  CB  ALA A 115     -12.239  14.416  -0.141  1.00 52.26           C  
ATOM    740  N   LYS A 116     -11.536  17.213   1.117  1.00 63.12           N  
ATOM    741  CA  LYS A 116     -10.866  18.491   0.968  1.00 67.25           C  
ATOM    742  C   LYS A 116      -9.431  18.201   0.570  1.00 65.78           C  
ATOM    743  O   LYS A 116      -8.661  17.642   1.353  1.00 69.50           O  
ATOM    744  CB  LYS A 116     -10.936  19.280   2.274  1.00 78.48           C  
ATOM    745  CG  LYS A 116     -12.366  19.602   2.678  1.00 94.88           C  
ATOM    746  CD  LYS A 116     -13.133  20.211   1.503  1.00103.01           C  
ATOM    747  CE  LYS A 116     -14.623  20.323   1.792  1.00109.42           C  
ATOM    748  NZ  LYS A 116     -15.362  20.881   0.624  1.00112.43           N  
ATOM    749  N   VAL A 117      -9.095  18.576  -0.662  1.00 64.07           N  
ATOM    750  CA  VAL A 117      -7.773  18.353  -1.238  1.00 52.93           C  
ATOM    751  C   VAL A 117      -6.730  19.405  -0.880  1.00 60.30           C  
ATOM    752  O   VAL A 117      -7.037  20.590  -0.792  1.00 68.03           O  
ATOM    753  CB  VAL A 117      -7.873  18.278  -2.776  1.00 48.55           C  
ATOM    754  CG1 VAL A 117      -6.499  18.076  -3.386  1.00 27.57           C  
ATOM    755  CG2 VAL A 117      -8.817  17.153  -3.174  1.00 36.54           C  
ATOM    756  N   ASN A 118      -5.494  18.954  -0.674  1.00 69.28           N  
ATOM    757  CA  ASN A 118      -4.378  19.839  -0.360  1.00 74.06           C  
ATOM    758  C   ASN A 118      -3.579  20.044  -1.647  1.00 80.30           C  
ATOM    759  O   ASN A 118      -4.171  20.215  -2.714  1.00 82.33           O  
ATOM    760  CB  ASN A 118      -3.503  19.222   0.717  1.00 84.19           C  
ATOM    761  N   LYS A 119      -2.248  20.019  -1.568  1.00 81.04           N  
ATOM    762  CA  LYS A 119      -1.439  20.214  -2.770  1.00 79.94           C  
ATOM    763  C   LYS A 119       0.048  19.989  -2.589  1.00 80.72           C  
ATOM    764  O   LYS A 119       0.499  19.407  -1.603  1.00 78.15           O  
ATOM    765  CB  LYS A 119      -1.668  21.629  -3.312  1.00 78.43           C  
ATOM    766  N   ALA A 120       0.786  20.465  -3.577  1.00 91.67           N  
ATOM    767  CA  ALA A 120       2.215  20.406  -3.594  1.00101.28           C  
ATOM    768  C   ALA A 120       2.984  21.683  -3.425  1.00108.82           C  
ATOM    769  O   ALA A 120       3.408  22.267  -4.452  1.00104.22           O  
ATOM    770  CB  ALA A 120       2.701  19.624  -4.890  1.00 95.85           C  
ATOM    771  N   SER A 121       3.160  22.182  -2.190  1.00119.05           N  
ATOM    772  CA  SER A 121       4.086  23.299  -2.055  1.00130.10           C  
ATOM    773  C   SER A 121       3.996  24.266  -0.913  1.00140.21           C  
ATOM    774  O   SER A 121       3.888  25.445  -1.244  1.00148.86           O  
ATOM    775  N   ARG A 122       4.120  23.832   0.364  1.00143.84           N  
ATOM    776  CA  ARG A 122       3.955  24.701   1.557  1.00141.61           C  
ATOM    777  C   ARG A 122       3.776  23.852   2.856  1.00141.49           C  
ATOM    778  O   ARG A 122       3.819  22.614   2.826  1.00148.47           O  
ATOM    779  CB  ARG A 122       2.708  25.552   1.371  1.00141.94           C  
ATOM    780  N   SER A 123       3.485  24.537   3.967  1.00137.49           N  
ATOM    781  CA  SER A 123       3.272  23.919   5.281  1.00130.71           C  
ATOM    782  C   SER A 123       4.188  22.717   5.485  1.00125.27           C  
ATOM    783  O   SER A 123       3.676  21.627   5.803  1.00123.16           O  
ATOM    784  CB  SER A 123       1.785  23.517   5.457  1.00123.67           C  
TER     785      SER A 123                                                      
END
MOLECULE T0466.pdb
ATOM    281  N   LEU    19     -13.966  -0.653  -3.614  1.00 72.33           N 
ATOM    282  CA  LEU    19     -12.695  -0.631  -2.891  1.00 64.15           C 
ATOM    283  C   LEU    19     -12.829   0.243  -1.646  1.00 23.21           C 
ATOM    284  O   LEU    19     -12.938   1.465  -1.741  1.00 12.11           O 
ATOM    285  CB  LEU    19     -11.563  -0.105  -3.789  1.00 13.41           C 
ATOM    286  CG  LEU    19     -11.234  -0.974  -5.016  1.00 70.21           C 
ATOM    287  CD1 LEU    19     -10.125  -0.332  -5.850  1.00 43.44           C 
ATOM    288  CD2 LEU    19     -10.838  -2.387  -4.583  1.00 45.32           C 
ATOM    289  H   LEU    19     -14.169   0.069  -4.245  1.00 38.03           H 
ATOM    290  HA  LEU    19     -12.462  -1.643  -2.586  1.00 55.11           H 
ATOM    291 1HB  LEU    19     -10.669  -0.016  -3.189  1.00 45.32           H 
ATOM    292 2HB  LEU    19     -11.840   0.881  -4.136  1.00  2.50           H 
ATOM    293  HG  LEU    19     -12.112  -1.049  -5.641  1.00 41.50           H 
ATOM    294 1HD1 LEU    19     -10.444   0.645  -6.180  1.00 43.04           H 
ATOM    295 2HD1 LEU    19      -9.917  -0.951  -6.711  1.00 44.24           H 
ATOM    296 3HD1 LEU    19      -9.230  -0.236  -5.251  1.00 60.31           H 
ATOM    297 1HD2 LEU    19     -11.659  -2.843  -4.052  1.00 71.13           H 
ATOM    298 2HD2 LEU    19      -9.973  -2.341  -3.937  1.00 40.24           H 
ATOM    299 3HD2 LEU    19     -10.602  -2.978  -5.457  1.00 72.51           H 
ATOM    300  N   LYS    20     -12.840  -0.387  -0.479  1.00 73.43           N 
ATOM    301  CA  LYS    20     -13.053   0.332   0.778  1.00 62.04           C 
ATOM    302  C   LYS    20     -11.909   0.088   1.772  1.00 13.12           C 
ATOM    303  O   LYS    20     -11.455  -1.045   1.961  1.00 65.12           O 
ATOM    304  CB  LYS    20     -14.419  -0.052   1.370  1.00 73.41           C 
ATOM    305  CG  LYS    20     -15.591   0.446   0.520  1.00 44.14           C 
ATOM    306  CD  LYS    20     -16.956   0.146   1.139  1.00 11.00           C 
ATOM    307  CE  LYS    20     -17.277  -1.344   1.148  1.00  5.44           C 
ATOM    308  NZ  LYS    20     -18.661  -1.611   1.627  1.00 32.10           N 
ATOM    309  H   LYS    20     -12.705  -1.359  -0.461  1.00 38.03           H 
ATOM    310  HA  LYS    20     -13.069   1.391   0.545  1.00 11.12           H 
ATOM    311 1HB  LYS    20     -14.509   0.376   2.356  1.00 40.45           H 
ATOM    312 2HB  LYS    20     -14.479  -1.129   1.447  1.00 15.41           H 
ATOM    313 1HG  LYS    20     -15.537  -0.025  -0.454  1.00 12.12           H 
ATOM    314 2HG  LYS    20     -15.497   1.516   0.400  1.00 50.51           H 
ATOM    315 1HD  LYS    20     -17.716   0.663   0.569  1.00 30.51           H 
ATOM    316 2HD  LYS    20     -16.966   0.509   2.157  1.00 21.12           H 
ATOM    317 1HE  LYS    20     -16.577  -1.846   1.800  1.00 71.53           H 
ATOM    318 2HE  LYS    20     -17.175  -1.732   0.144  1.00 22.23           H 
ATOM    319 1HZ  LYS    20     -19.358  -1.233   0.948  1.00  4.11           H 
ATOM    320 2HZ  LYS    20     -18.816  -1.157   2.547  1.00 21.32           H 
ATOM    321 3HZ  LYS    20     -18.816  -2.632   1.732  1.00 52.21           H 
ATOM    322  N   PHE    21     -11.449   1.175   2.393  1.00 62.24           N 
ATOM    323  CA  PHE    21     -10.276   1.156   3.277  1.00 61.32           C 
ATOM    324  C   PHE    21     -10.481   0.285   4.531  1.00 12.31           C 
ATOM    325  O   PHE    21     -11.577   0.211   5.088  1.00 52.04           O 
ATOM    326  CB  PHE    21      -9.929   2.598   3.688  1.00 11.21           C 
ATOM    327  CG  PHE    21      -8.648   2.729   4.474  1.00  1.24           C 
ATOM    328  CD1 PHE    21      -7.419   2.684   3.831  1.00 42.11           C 
ATOM    329  CD2 PHE    21      -8.673   2.907   5.851  1.00 65.13           C 
ATOM    330  CE1 PHE    21      -6.242   2.812   4.543  1.00 44.33           C 
ATOM    331  CE2 PHE    21      -7.499   3.034   6.568  1.00 52.11           C 
ATOM    332  CZ  PHE    21      -6.282   2.987   5.914  1.00 73.53           C 
ATOM    333  H   PHE    21     -11.911   2.030   2.240  1.00 38.03           H 
ATOM    334  HA  PHE    21      -9.449   0.752   2.712  1.00 25.10           H 
ATOM    335 1HB  PHE    21     -10.732   2.995   4.294  1.00 34.51           H 
ATOM    336 2HB  PHE    21      -9.832   3.200   2.798  1.00 43.41           H 
ATOM    337  HD1 PHE    21      -7.387   2.548   2.760  1.00 14.33           H 
ATOM    338  HD2 PHE    21      -9.623   2.942   6.363  1.00 63.21           H 
ATOM    339  HE1 PHE    21      -5.294   2.773   4.030  1.00 51.24           H 
ATOM    340  HE2 PHE    21      -7.533   3.171   7.639  1.00  4.43           H 
ATOM    341  HZ  PHE    21      -5.364   3.087   6.474  1.00  4.10           H 
ATOM    342  N   SER    22      -9.411  -0.380   4.965  1.00 74.33           N 
ATOM    343  CA  SER    22      -9.423  -1.137   6.227  1.00 11.20           C 
ATOM    344  C   SER    22      -8.311  -0.665   7.171  1.00 14.10           C 
ATOM    345  O   SER    22      -8.586  -0.177   8.268  1.00 71.35           O 
ATOM    346  CB  SER    22      -9.277  -2.644   5.969  1.00  4.33           C 
ATOM    347  OG  SER    22     -10.410  -3.167   5.290  1.00 62.25           O 
ATOM    348  H   SER    22      -8.597  -0.380   4.417  1.00 38.03           H 
ATOM    349  HA  SER    22     -10.377  -0.961   6.709  1.00  1.01           H 
ATOM    350 1HB  SER    22      -9.168  -3.160   6.913  1.00 32.42           H 
ATOM    351 2HB  SER    22      -8.401  -2.821   5.363  1.00 13.22           H 
ATOM    352  HG  SER    22     -10.313  -4.126   5.207  1.00 10.03           H 
ATOM    353  N   ALA    23      -7.057  -0.820   6.746  1.00 13.40           N 
ATOM    354  CA  ALA    23      -5.906  -0.400   7.557  1.00 50.24           C 
ATOM    355  C   ALA    23      -4.646  -0.196   6.702  1.00 35.25           C 
ATOM    356  O   ALA    23      -4.667  -0.374   5.483  1.00 23.23           O 
ATOM    357  CB  ALA    23      -5.635  -1.429   8.651  1.00 33.12           C 
ATOM    358  H   ALA    23      -6.897  -1.225   5.867  1.00 38.03           H 
ATOM    359  HA  ALA    23      -6.160   0.539   8.034  1.00 70.41           H 
ATOM    360 1HB  ALA    23      -6.529  -1.578   9.239  1.00 50.23           H 
ATOM    361 2HB  ALA    23      -4.840  -1.075   9.291  1.00 75.13           H 
ATOM    362 3HB  ALA    23      -5.343  -2.365   8.199  1.00 74.43           H 
ATOM    363  N   LEU    24      -3.554   0.192   7.352  1.00 20.11           N 
ATOM    364  CA  LEU    24      -2.234   0.235   6.715  1.00 23.54           C 
ATOM    365  C   LEU    24      -1.416  -0.989   7.149  1.00 42.12           C 
ATOM    366  O   LEU    24      -0.880  -1.030   8.262  1.00 52.13           O 
ATOM    367  CB  LEU    24      -1.500   1.530   7.091  1.00  1.14           C 
ATOM    368  CG  LEU    24      -0.085   1.686   6.503  1.00 11.45           C 
ATOM    369  CD1 LEU    24      -0.125   1.785   4.978  1.00 32.44           C 
ATOM    370  CD2 LEU    24       0.613   2.900   7.108  1.00 63.32           C 
ATOM    371  H   LEU    24      -3.633   0.460   8.292  1.00 38.03           H 
ATOM    372  HA  LEU    24      -2.373   0.204   5.642  1.00 44.33           H 
ATOM    373 1HB  LEU    24      -1.425   1.574   8.169  1.00 41.40           H 
ATOM    374 2HB  LEU    24      -2.102   2.367   6.760  1.00  1.24           H 
ATOM    375  HG  LEU    24       0.495   0.812   6.757  1.00 72.14           H 
ATOM    376 1HD1 LEU    24      -0.719   2.638   4.685  1.00 64.44           H 
ATOM    377 2HD1 LEU    24      -0.561   0.885   4.567  1.00 65.13           H 
ATOM    378 3HD1 LEU    24       0.881   1.901   4.597  1.00  0.11           H 
ATOM    379 1HD2 LEU    24       0.064   3.797   6.860  1.00 44.42           H 
ATOM    380 2HD2 LEU    24       1.616   2.971   6.713  1.00 12.43           H 
ATOM    381 3HD2 LEU    24       0.659   2.790   8.182  1.00 73.44           H 
ATOM    382  N   ARG    25      -1.339  -1.990   6.279  1.00 42.05           N 
ATOM    383  CA  ARG    25      -0.709  -3.273   6.622  1.00 54.11           C 
ATOM    384  C   ARG    25       0.755  -3.104   7.055  1.00 43.24           C 
ATOM    385  O   ARG    25       1.128  -3.474   8.169  1.00  4.35           O 
ATOM    386  CB  ARG    25      -0.807  -4.243   5.433  1.00  3.12           C 
ATOM    387  CG  ARG    25      -0.213  -5.631   5.689  1.00 25.31           C 
ATOM    388  CD  ARG    25      -0.729  -6.258   6.985  1.00 11.22           C 
ATOM    389  NE  ARG    25      -2.158  -6.034   7.187  1.00 60.15           N 
ATOM    390  CZ  ARG    25      -2.832  -6.474   8.213  1.00 44.21           C 
ATOM    391  NH1 ARG    25      -2.299  -7.304   9.052  1.00 71.12           N 
ATOM    392  NH2 ARG    25      -4.058  -6.104   8.373  1.00  0.55           N 
ATOM    393  H   ARG    25      -1.713  -1.868   5.381  1.00 38.03           H 
ATOM    394  HA  ARG    25      -1.263  -3.691   7.453  1.00 35.01           H 
ATOM    395 1HB  ARG    25      -0.288  -3.806   4.589  1.00 54.14           H 
ATOM    396 2HB  ARG    25      -1.849  -4.366   5.170  1.00 72.51           H 
ATOM    397 1HG  ARG    25       0.864  -5.545   5.746  1.00  3.04           H 
ATOM    398 2HG  ARG    25      -0.474  -6.277   4.864  1.00 41.22           H 
ATOM    399 1HD  ARG    25      -0.185  -5.832   7.817  1.00 21.10           H 
ATOM    400 2HD  ARG    25      -0.548  -7.323   6.949  1.00 11.03           H 
ATOM    401  HE  ARG    25      -2.630  -5.469   6.537  1.00 73.15           H 
ATOM    402 1HH1 ARG    25      -1.360  -7.613   8.922  1.00 24.42           H 
ATOM    403 2HH1 ARG    25      -2.827  -7.625   9.834  1.00 14.31           H 
ATOM    404 1HH2 ARG    25      -4.475  -5.474   7.715  1.00 34.00           H 
ATOM    405 2HH2 ARG    25      -4.584  -6.431   9.156  1.00 31.21           H 
ATOM    406  N   ARG    26       1.576  -2.543   6.175  1.00 23.43           N 
ATOM    407  CA  ARG    26       2.999  -2.362   6.465  1.00 71.24           C 
ATOM    408  C   ARG    26       3.679  -1.465   5.428  1.00 73.33           C 
ATOM    409  O   ARG    26       3.462  -1.613   4.229  1.00 52.22           O 
ATOM    410  CB  ARG    26       3.706  -3.726   6.513  1.00 73.01           C 
ATOM    411  CG  ARG    26       5.213  -3.633   6.727  1.00 21.14           C 
ATOM    412  CD  ARG    26       5.863  -5.009   6.824  1.00 54.54           C 
ATOM    413  NE  ARG    26       7.309  -4.920   7.019  1.00 44.44           N 
ATOM    414  CZ  ARG    26       8.148  -5.886   6.760  1.00 30.43           C 
ATOM    415  NH1 ARG    26       7.717  -7.051   6.387  1.00 33.33           N 
ATOM    416  NH2 ARG    26       9.417  -5.692   6.913  1.00 74.11           N 
ATOM    417  H   ARG    26       1.220  -2.240   5.313  1.00 38.03           H 
ATOM    418  HA  ARG    26       3.080  -1.891   7.434  1.00 50.00           H 
ATOM    419 1HB  ARG    26       3.527  -4.245   5.580  1.00 42.12           H 
ATOM    420 2HB  ARG    26       3.284  -4.306   7.321  1.00 74.05           H 
ATOM    421 1HG  ARG    26       5.402  -3.091   7.640  1.00 52.20           H 
ATOM    422 2HG  ARG    26       5.652  -3.100   5.895  1.00 33.44           H 
ATOM    423 1HD  ARG    26       5.663  -5.557   5.912  1.00 33.04           H 
ATOM    424 2HD  ARG    26       5.433  -5.538   7.662  1.00 14.10           H 
ATOM    425  HE  ARG    26       7.668  -4.072   7.357  1.00 70.33           H 
ATOM    426 1HH1 ARG    26       6.736  -7.213   6.302  1.00 34.54           H 
ATOM    427 2HH1 ARG    26       8.362  -7.783   6.187  1.00 40.30           H 
ATOM    428 1HH2 ARG    26       9.747  -4.806   7.233  1.00 14.51           H 
ATOM    429 2HH2 ARG    26      10.063  -6.421   6.706  1.00 20.25           H 
ATOM    430  N   GLU    27       4.495  -0.530   5.899  1.00 70.42           N 
ATOM    431  CA  GLU    27       5.300   0.310   5.011  1.00 55.44           C 
ATOM    432  C   GLU    27       6.732  -0.237   4.926  1.00 34.15           C 
ATOM    433  O   GLU    27       7.556   0.013   5.809  1.00 11.52           O 
ATOM    434  CB  GLU    27       5.310   1.762   5.519  1.00 52.40           C 
ATOM    435  CG  GLU    27       3.916   2.368   5.648  1.00 52.02           C 
ATOM    436  CD  GLU    27       3.926   3.773   6.233  1.00 15.32           C 
ATOM    437  OE1 GLU    27       3.647   4.734   5.490  1.00 13.11           O 
ATOM    438  OE2 GLU    27       4.206   3.918   7.444  1.00 43.23           O 
ATOM    439  H   GLU    27       4.558  -0.398   6.869  1.00 38.03           H 
ATOM    440  HA  GLU    27       4.856   0.283   4.025  1.00  0.23           H 
ATOM    441 1HB  GLU    27       5.883   2.371   4.833  1.00 41.01           H 
ATOM    442 2HB  GLU    27       5.782   1.789   6.492  1.00 51.23           H 
ATOM    443 1HG  GLU    27       3.321   1.733   6.291  1.00 23.10           H 
ATOM    444 2HG  GLU    27       3.463   2.405   4.668  1.00 51.04           H 
ATOM    445  N   VAL    28       7.018  -0.998   3.867  1.00 44.22           N 
ATOM    446  CA  VAL    28       8.340  -1.609   3.693  1.00 51.31           C 
ATOM    447  C   VAL    28       9.398  -0.539   3.390  1.00 41.00           C 
ATOM    448  O   VAL    28       9.167   0.368   2.587  1.00  3.43           O 
ATOM    449  CB  VAL    28       8.338  -2.692   2.581  1.00 12.33           C 
ATOM    450  CG1 VAL    28       7.398  -3.838   2.949  1.00  4.31           C 
ATOM    451  CG2 VAL    28       7.956  -2.091   1.229  1.00 50.52           C 
ATOM    452  H   VAL    28       6.332  -1.134   3.182  1.00 38.03           H 
ATOM    453  HA  VAL    28       8.601  -2.091   4.629  1.00  4.04           H 
ATOM    454  HB  VAL    28       9.340  -3.094   2.499  1.00 53.41           H 
ATOM    455 1HG1 VAL    28       7.700  -4.263   3.896  1.00 34.25           H 
ATOM    456 2HG1 VAL    28       7.439  -4.600   2.185  1.00  2.32           H 
ATOM    457 3HG1 VAL    28       6.386  -3.465   3.031  1.00  0.32           H 
ATOM    458 1HG2 VAL    28       7.963  -2.865   0.474  1.00 12.01           H 
ATOM    459 2HG2 VAL    28       8.668  -1.323   0.960  1.00 34.13           H 
ATOM    460 3HG2 VAL    28       6.969  -1.657   1.293  1.00 45.13           H 
ATOM    461  N   ARG    29      10.552  -0.644   4.038  1.00 65.11           N 
ATOM    462  CA  ARG    29      11.562   0.415   3.991  1.00 44.03           C 
ATOM    463  C   ARG    29      12.873  -0.043   3.332  1.00 33.34           C 
ATOM    464  O   ARG    29      13.078  -1.227   3.063  1.00 41.20           O 
ATOM    465  CB  ARG    29      11.813   0.933   5.413  1.00 23.24           C 
ATOM    466  CG  ARG    29      10.540   1.442   6.091  1.00  1.20           C 
ATOM    467  CD  ARG    29      10.816   2.069   7.450  1.00 73.53           C 
ATOM    468  NE  ARG    29       9.590   2.569   8.073  1.00 32.04           N 
ATOM    469  CZ  ARG    29       9.551   3.535   8.950  1.00 31.52           C 
ATOM    470  NH1 ARG    29      10.645   4.102   9.349  1.00 40.11           N 
ATOM    471  NH2 ARG    29       8.415   3.926   9.429  1.00 74.23           N 
ATOM    472  H   ARG    29      10.735  -1.454   4.560  1.00 38.03           H 
ATOM    473  HA  ARG    29      11.158   1.225   3.398  1.00 13.21           H 
ATOM    474 1HB  ARG    29      12.524   1.746   5.370  1.00  4.31           H 
ATOM    475 2HB  ARG    29      12.226   0.134   6.013  1.00 71.55           H 
ATOM    476 1HG  ARG    29       9.859   0.611   6.220  1.00 32.33           H 
ATOM    477 2HG  ARG    29      10.081   2.186   5.455  1.00 75.45           H 
ATOM    478 1HD  ARG    29      11.504   2.892   7.319  1.00 43.11           H 
ATOM    479 2HD  ARG    29      11.260   1.326   8.096  1.00 73.10           H 
ATOM    480  HE  ARG    29       8.747   2.154   7.804  1.00 22.33           H 
ATOM    481 1HH1 ARG    29      11.519   3.800   8.989  1.00 73.13           H 
ATOM    482 2HH1 ARG    29      10.610   4.839  10.023  1.00 72.01           H 
ATOM    483 1HH2 ARG    29       7.571   3.486   9.133  1.00 33.41           H 
ATOM    484 2HH2 ARG    29       8.382   4.678  10.088  1.00 63.31           H 
ATOM    485  N   ILE    30      13.754   0.920   3.076  1.00 73.14           N 
ATOM    486  CA  ILE    30      15.016   0.666   2.373  1.00 64.23           C 
ATOM    487  C   ILE    30      16.035  -0.037   3.286  1.00 62.23           C 
ATOM    488  O   ILE    30      16.502   0.538   4.267  1.00 43.02           O 
ATOM    489  CB  ILE    30      15.623   1.994   1.851  1.00 24.30           C 
ATOM    490  CG1 ILE    30      14.569   2.779   1.050  1.00 41.01           C 
ATOM    491  CG2 ILE    30      16.856   1.717   0.989  1.00 23.11           C 
ATOM    492  CD1 ILE    30      14.999   4.179   0.662  1.00 31.33           C 
ATOM    493  H   ILE    30      13.552   1.832   3.373  1.00 38.03           H 
ATOM    494  HA  ILE    30      14.804   0.030   1.522  1.00 75.34           H 
ATOM    495  HB  ILE    30      15.933   2.586   2.703  1.00 24.42           H 
ATOM    496 1HG1 ILE    30      13.668   2.864   1.640  1.00 12.24           H 
ATOM    497 2HG1 ILE    30      14.342   2.244   0.139  1.00  3.52           H 
ATOM    498 1HG2 ILE    30      17.590   1.178   1.570  1.00 42.52           H 
ATOM    499 2HG2 ILE    30      17.281   2.652   0.653  1.00 61.30           H 
ATOM    500 3HG2 ILE    30      16.570   1.124   0.131  1.00 23.31           H 
ATOM    501 1HD1 ILE    30      14.219   4.645   0.078  1.00 63.31           H 
ATOM    502 2HD1 ILE    30      15.907   4.132   0.079  1.00  4.53           H 
ATOM    503 3HD1 ILE    30      15.174   4.762   1.557  1.00 52.23           H 
ATOM    504  N   GLN    31      16.374  -1.282   2.962  1.00  4.21           N 
ATOM    505  CA  GLN    31      17.310  -2.070   3.775  1.00 60.32           C 
ATOM    506  C   GLN    31      18.776  -1.760   3.426  1.00  2.41           C 
ATOM    507  O   GLN    31      19.151  -1.711   2.254  1.00  4.24           O 
ATOM    508  CB  GLN    31      17.027  -3.568   3.587  1.00 11.31           C 
ATOM    509  CG  GLN    31      17.959  -4.483   4.374  1.00 62.12           C 
ATOM    510  CD  GLN    31      17.587  -5.950   4.248  1.00 62.13           C 
ATOM    511  OE1 GLN    31      17.037  -6.384   3.238  1.00 34.24           O 
ATOM    512  NE2 GLN    31      17.878  -6.724   5.271  1.00 63.40           N 
ATOM    513  H   GLN    31      15.981  -1.687   2.161  1.00 38.03           H 
ATOM    514  HA  GLN    31      17.142  -1.816   4.813  1.00 42.34           H 
ATOM    515 1HB  GLN    31      17.124  -3.810   2.537  1.00 15.40           H 
ATOM    516 2HB  GLN    31      16.011  -3.770   3.898  1.00 23.14           H 
ATOM    517 1HG  GLN    31      17.917  -4.204   5.419  1.00 44.43           H 
ATOM    518 2HG  GLN    31      18.967  -4.352   4.010  1.00 70.45           H 
ATOM    519 1HE2 GLN    31      18.308  -6.318   6.052  1.00 10.34           H 
ATOM    520 2HE2 GLN    31      17.658  -7.674   5.205  1.00  1.20           H 
ATOM    521  N   ASN    32      19.605  -1.561   4.454  1.00 61.43           N 
ATOM    522  CA  ASN    32      21.033  -1.276   4.258  1.00 53.10           C 
ATOM    523  C   ASN    32      21.819  -2.572   3.993  1.00  4.14           C 
ATOM    524  O   ASN    32      21.450  -3.640   4.486  1.00  3.33           O 
ATOM    525  CB  ASN    32      21.611  -0.557   5.487  1.00 10.53           C 
ATOM    526  CG  ASN    32      20.880   0.737   5.808  1.00 33.41           C 
ATOM    527  OD1 ASN    32      21.215   1.804   5.303  1.00 33.32           O 
ATOM    528  ND2 ASN    32      19.882   0.657   6.666  1.00  1.53           N 
ATOM    529  H   ASN    32      19.253  -1.621   5.366  1.00 38.03           H 
ATOM    530  HA  ASN    32      21.129  -0.628   3.397  1.00 45.03           H 
ATOM    531 1HB  ASN    32      22.652  -0.326   5.308  1.00 51.23           H 
ATOM    532 2HB  ASN    32      21.538  -1.209   6.345  1.00 43.12           H 
ATOM    533 1HD2 ASN    32      19.666  -0.219   7.043  1.00 25.43           H 
ATOM    534 2HD2 ASN    32      19.405   1.480   6.892  1.00 32.52           H 
ATOM    535  N   GLU    33      22.909  -2.470   3.229  1.00  3.20           N 
ATOM    536  CA  GLU    33      23.714  -3.647   2.860  1.00 64.42           C 
ATOM    537  C   GLU    33      24.241  -4.392   4.094  1.00 63.13           C 
ATOM    538  O   GLU    33      24.360  -5.619   4.089  1.00 60.23           O 
ATOM    539  CB  GLU    33      24.897  -3.235   1.971  1.00 10.22           C 
ATOM    540  CG  GLU    33      24.491  -2.625   0.632  1.00 51.42           C 
ATOM    541  CD  GLU    33      25.688  -2.323  -0.259  1.00 23.33           C 
ATOM    542  OE1 GLU    33      26.138  -3.232  -0.986  1.00 65.51           O 
ATOM    543  OE2 GLU    33      26.192  -1.179  -0.227  1.00 52.55           O 
ATOM    544  H   GLU    33      23.186  -1.585   2.907  1.00 38.03           H 
ATOM    545  HA  GLU    33      23.077  -4.315   2.299  1.00 62.32           H 
ATOM    546 1HB  GLU    33      25.503  -4.109   1.773  1.00 13.11           H 
ATOM    547 2HB  GLU    33      25.496  -2.509   2.503  1.00 41.44           H 
ATOM    548 1HG  GLU    33      23.954  -1.704   0.816  1.00 41.14           H 
ATOM    549 2HG  GLU    33      23.841  -3.319   0.118  1.00 25.22           H 
ATOM    550  N   ASP    34      24.560  -3.641   5.144  1.00 11.03           N 
ATOM    551  CA  ASP    34      25.068  -4.211   6.395  1.00 51.43           C 
ATOM    552  C   ASP    34      24.071  -5.199   7.024  1.00 74.11           C 
ATOM    553  O   ASP    34      24.464  -6.123   7.737  1.00 72.41           O 
ATOM    554  CB  ASP    34      25.376  -3.080   7.380  1.00 43.21           C 
ATOM    555  CG  ASP    34      26.375  -2.088   6.817  1.00 72.13           C 
ATOM    556  OD1 ASP    34      25.997  -1.307   5.919  1.00 53.52           O 
ATOM    557  OD2 ASP    34      27.534  -2.068   7.277  1.00 72.11           O 
ATOM    558  H   ASP    34      24.460  -2.668   5.074  1.00 38.03           H 
ATOM    559  HA  ASP    34      25.984  -4.738   6.171  1.00 24.22           H 
ATOM    560 1HB  ASP    34      25.780  -3.499   8.291  1.00  5.34           H 
ATOM    561 2HB  ASP    34      24.461  -2.551   7.609  1.00 40.13           H 
ATOM    562  N   GLY    35      22.782  -5.000   6.754  1.00 12.34           N 
ATOM    563  CA  GLY    35      21.759  -5.885   7.299  1.00 53.01           C 
ATOM    564  C   GLY    35      20.526  -5.138   7.794  1.00 32.30           C 
ATOM    565  O   GLY    35      19.412  -5.393   7.334  1.00 42.24           O 
ATOM    566  H   GLY    35      22.524  -4.257   6.172  1.00 38.03           H 
ATOM    567 1HA  GLY    35      22.179  -6.444   8.125  1.00 45.53           H 
ATOM    568 2HA  GLY    35      21.460  -6.581   6.529  1.00  5.14           H 
ATOM    569  N   SER    36      20.727  -4.208   8.729  1.00 53.54           N 
ATOM    570  CA  SER    36      19.615  -3.444   9.326  1.00 64.41           C 
ATOM    571  C   SER    36      18.875  -2.583   8.291  1.00  1.02           C 
ATOM    572  O   SER    36      19.461  -2.101   7.318  1.00 72.14           O 
ATOM    573  CB  SER    36      20.117  -2.547  10.467  1.00 61.32           C 
ATOM    574  OG  SER    36      20.658  -3.310  11.536  1.00 44.14           O 
ATOM    575  H   SER    36      21.646  -4.033   9.034  1.00 38.03           H 
ATOM    576  HA  SER    36      18.917  -4.161   9.735  1.00 20.12           H 
ATOM    577 1HB  SER    36      19.292  -1.959  10.844  1.00 51.04           H 
ATOM    578 2HB  SER    36      20.885  -1.885  10.092  1.00 61.34           H 
ATOM    579  HG  SER    36      20.516  -2.838  12.366  1.00 33.21           H 
ATOM    580  N   VAL    37      17.586  -2.374   8.524  1.00 50.21           N 
ATOM    581  CA  VAL    37      16.742  -1.593   7.619  1.00  2.34           C 
ATOM    582  C   VAL    37      16.727  -0.107   8.015  1.00 72.32           C 
ATOM    583  O   VAL    37      16.829   0.234   9.194  1.00 40.44           O 
ATOM    584  CB  VAL    37      15.295  -2.148   7.609  1.00 20.54           C 
ATOM    585  CG1 VAL    37      14.430  -1.426   6.577  1.00 15.04           C 
ATOM    586  CG2 VAL    37      15.310  -3.654   7.353  1.00 41.23           C 
ATOM    587  H   VAL    37      17.182  -2.761   9.332  1.00 38.03           H 
ATOM    588  HA  VAL    37      17.146  -1.685   6.620  1.00 53.44           H 
ATOM    589  HB  VAL    37      14.860  -1.979   8.585  1.00  1.44           H 
ATOM    590 1HG1 VAL    37      14.385  -0.374   6.815  1.00 13.03           H 
ATOM    591 2HG1 VAL    37      13.431  -1.840   6.589  1.00 23.23           H 
ATOM    592 3HG1 VAL    37      14.858  -1.554   5.592  1.00 70.02           H 
ATOM    593 1HG2 VAL    37      15.749  -3.853   6.387  1.00 63.40           H 
ATOM    594 2HG2 VAL    37      14.299  -4.035   7.374  1.00 64.24           H 
ATOM    595 3HG2 VAL    37      15.894  -4.144   8.120  1.00 20.31           H 
ATOM    596  N   SER    38      16.607   0.767   7.021  1.00 51.31           N 
ATOM    597  CA  SER    38      16.623   2.221   7.250  1.00 72.25           C 
ATOM    598  C   SER    38      15.259   2.748   7.710  1.00 65.43           C 
ATOM    599  O   SER    38      14.267   2.016   7.760  1.00 33.54           O 
ATOM    600  CB  SER    38      17.039   2.959   5.968  1.00 62.33           C 
ATOM    601  OG  SER    38      17.008   4.368   6.146  1.00 64.51           O 
ATOM    602  H   SER    38      16.493   0.432   6.107  1.00 38.03           H 
ATOM    603  HA  SER    38      17.352   2.427   8.021  1.00 72.52           H 
ATOM    604 1HB  SER    38      16.360   2.698   5.168  1.00 62.11           H 
ATOM    605 2HB  SER    38      18.044   2.665   5.695  1.00 34.12           H 
ATOM    606  HG  SER    38      17.881   4.736   5.950  1.00  0.41           H 
ATOM    607  N   ASP    39      15.225   4.032   8.045  1.00 55.54           N 
ATOM    608  CA  ASP    39      13.990   4.710   8.437  1.00 15.11           C 
ATOM    609  C   ASP    39      13.254   5.282   7.210  1.00 72.13           C 
ATOM    610  O   ASP    39      12.102   5.710   7.305  1.00 31.44           O 
ATOM    611  CB  ASP    39      14.307   5.817   9.450  1.00 25.44           C 
ATOM    612  CG  ASP    39      15.365   6.788   8.949  1.00 25.22           C 
ATOM    613  OD1 ASP    39      16.535   6.372   8.788  1.00  1.12           O 
ATOM    614  OD2 ASP    39      15.039   7.970   8.723  1.00 64.33           O 
ATOM    615  H   ASP    39      16.062   4.546   8.027  1.00 38.03           H 
ATOM    616  HA  ASP    39      13.349   3.980   8.911  1.00  2.51           H 
ATOM    617 1HB  ASP    39      14.666   5.365  10.364  1.00 13.25           H 
ATOM    618 2HB  ASP    39      13.404   6.371   9.665  1.00 54.23           H 
ATOM    619  N   GLU    40      13.927   5.272   6.057  1.00  4.12           N 
ATOM    620  CA  GLU    40      13.331   5.738   4.797  1.00 62.14           C 
ATOM    621  C   GLU    40      12.461   4.657   4.142  1.00 71.23           C 
ATOM    622  O   GLU    40      12.790   3.470   4.172  1.00 50.15           O 
ATOM    623  CB  GLU    40      14.426   6.199   3.827  1.00 42.32           C 
ATOM    624  CG  GLU    40      15.109   7.495   4.249  1.00 12.15           C 
ATOM    625  CD  GLU    40      14.145   8.672   4.311  1.00 54.34           C 
ATOM    626  OE1 GLU    40      13.903   9.306   3.263  1.00 55.13           O 
ATOM    627  OE2 GLU    40      13.616   8.962   5.405  1.00 14.55           O 
ATOM    628  H   GLU    40      14.854   4.947   6.053  1.00 38.03           H 
ATOM    629  HA  GLU    40      12.698   6.586   5.031  1.00  1.34           H 
ATOM    630 1HB  GLU    40      13.990   6.348   2.848  1.00  3.34           H 
ATOM    631 2HB  GLU    40      15.180   5.425   3.761  1.00 65.01           H 
ATOM    632 1HG  GLU    40      15.891   7.722   3.539  1.00 60.31           H 
ATOM    633 2HG  GLU    40      15.544   7.352   5.227  1.00 11.34           H 
ATOM    634  N   ILE    41      11.370   5.088   3.518  1.00 53.25           N 
ATOM    635  CA  ILE    41      10.355   4.172   2.978  1.00 24.45           C 
ATOM    636  C   ILE    41      10.710   3.673   1.562  1.00 13.22           C 
ATOM    637  O   ILE    41      11.418   4.344   0.812  1.00 52.43           O 
ATOM    638  CB  ILE    41       8.964   4.863   2.925  1.00 31.23           C 
ATOM    639  CG1 ILE    41       8.601   5.481   4.288  1.00  1.23           C 
ATOM    640  CG2 ILE    41       7.879   3.872   2.489  1.00  0.44           C 
ATOM    641  CD1 ILE    41       8.314   4.464   5.372  1.00 34.44           C 
ATOM    642  H   ILE    41      11.247   6.057   3.405  1.00 38.03           H 
ATOM    643  HA  ILE    41      10.283   3.321   3.643  1.00  3.11           H 
ATOM    644  HB  ILE    41       9.011   5.651   2.185  1.00 23.44           H 
ATOM    645 1HG1 ILE    41       7.720   6.097   4.171  1.00 11.52           H 
ATOM    646 2HG1 ILE    41       9.420   6.100   4.626  1.00 65.22           H 
ATOM    647 1HG2 ILE    41       7.852   3.042   3.181  1.00 73.41           H 
ATOM    648 2HG2 ILE    41       8.101   3.506   1.497  1.00 60.22           H 
ATOM    649 3HG2 ILE    41       6.919   4.368   2.481  1.00 71.22           H 
ATOM    650 1HD1 ILE    41       9.166   3.808   5.490  1.00 53.12           H 
ATOM    651 2HD1 ILE    41       7.445   3.883   5.097  1.00 64.35           H 
ATOM    652 3HD1 ILE    41       8.124   4.976   6.303  1.00 11.23           H 
ATOM    653  N   LYS    42      10.209   2.488   1.209  1.00 13.55           N 
ATOM    654  CA  LYS    42      10.345   1.945  -0.149  1.00 24.51           C 
ATOM    655  C   LYS    42       8.960   1.853  -0.825  1.00 22.30           C 
ATOM    656  O   LYS    42       8.732   2.441  -1.884  1.00 24.53           O 
ATOM    657  CB  LYS    42      11.014   0.562  -0.102  1.00 24.33           C 
ATOM    658  CG  LYS    42      11.343  -0.016  -1.475  1.00 62.14           C 
ATOM    659  CD  LYS    42      12.324   0.870  -2.240  1.00 33.01           C 
ATOM    660  CE  LYS    42      12.662   0.300  -3.609  1.00 60.32           C 
ATOM    661  NZ  LYS    42      13.573   1.196  -4.369  1.00 72.54           N 
ATOM    662  H   LYS    42       9.731   1.962   1.883  1.00 38.03           H 
ATOM    663  HA  LYS    42      10.969   2.622  -0.721  1.00 72.43           H 
ATOM    664 1HB  LYS    42      10.352  -0.128   0.406  1.00 62.41           H 
ATOM    665 2HB  LYS    42      11.934   0.638   0.462  1.00 11.51           H 
ATOM    666 1HG  LYS    42      10.429  -0.103  -2.046  1.00 31.10           H 
ATOM    667 2HG  LYS    42      11.782  -0.996  -1.348  1.00 43.35           H 
ATOM    668 1HD  LYS    42      13.235   0.962  -1.663  1.00 70.42           H 
ATOM    669 2HD  LYS    42      11.883   1.848  -2.371  1.00 43.50           H 
ATOM    670 1HE  LYS    42      11.747   0.169  -4.170  1.00 25.12           H 
ATOM    671 2HE  LYS    42      13.145  -0.659  -3.478  1.00  0.15           H 
ATOM    672 1HZ  LYS    42      14.465   1.328  -3.851  1.00 32.04           H 
ATOM    673 2HZ  LYS    42      13.130   2.126  -4.508  1.00 31.13           H 
ATOM    674 3HZ  LYS    42      13.786   0.786  -5.299  1.00 43.43           H 
ATOM    675  N   GLU    43       8.043   1.109  -0.197  1.00 64.02           N 
ATOM    676  CA  GLU    43       6.634   1.039  -0.625  1.00 41.54           C 
ATOM    677  C   GLU    43       5.694   1.002   0.592  1.00 53.40           C 
ATOM    678  O   GLU    43       6.114   0.671   1.703  1.00 51.32           O 
ATOM    679  CB  GLU    43       6.377  -0.200  -1.501  1.00 32.35           C 
ATOM    680  CG  GLU    43       7.136  -0.198  -2.820  1.00 35.30           C 
ATOM    681  CD  GLU    43       6.641  -1.263  -3.794  1.00 33.11           C 
ATOM    682  OE1 GLU    43       7.330  -2.290  -3.965  1.00 42.54           O 
ATOM    683  OE2 GLU    43       5.554  -1.083  -4.391  1.00 72.45           O 
ATOM    684  H   GLU    43       8.319   0.584   0.576  1.00 38.03           H 
ATOM    685  HA  GLU    43       6.417   1.927  -1.203  1.00 15.30           H 
ATOM    686 1HB  GLU    43       5.318  -0.256  -1.721  1.00 54.03           H 
ATOM    687 2HB  GLU    43       6.663  -1.084  -0.948  1.00 72.25           H 
ATOM    688 1HG  GLU    43       8.184  -0.372  -2.616  1.00 30.51           H 
ATOM    689 2HG  GLU    43       7.023   0.773  -3.276  1.00 71.51           H 
ATOM    690  N   ARG    44       4.422   1.338   0.381  1.00 35.34           N 
ATOM    691  CA  ARG    44       3.419   1.317   1.457  1.00 73.22           C 
ATOM    692  C   ARG    44       2.285   0.326   1.132  1.00 31.44           C 
ATOM    693  O   ARG    44       1.563   0.500   0.150  1.00 74.32           O 
ATOM    694  CB  ARG    44       2.831   2.721   1.672  1.00 75.45           C 
ATOM    695  CG  ARG    44       3.879   3.821   1.843  1.00 55.22           C 
ATOM    696  CD  ARG    44       3.234   5.163   2.173  1.00 42.23           C 
ATOM    697  NE  ARG    44       4.183   6.277   2.093  1.00 60.31           N 
ATOM    698  CZ  ARG    44       4.378   7.152   3.048  1.00 64.32           C 
ATOM    699  NH1 ARG    44       3.842   6.986   4.211  1.00  3.41           N 
ATOM    700  NH2 ARG    44       5.145   8.174   2.847  1.00 25.25           N 
ATOM    701  H   ARG    44       4.147   1.604  -0.522  1.00 38.03           H 
ATOM    702  HA  ARG    44       3.910   1.000   2.366  1.00 32.01           H 
ATOM    703 1HB  ARG    44       2.212   2.703   2.558  1.00 61.32           H 
ATOM    704 2HB  ARG    44       2.212   2.975   0.822  1.00 44.33           H 
ATOM    705 1HG  ARG    44       4.441   3.916   0.924  1.00 11.35           H 
ATOM    706 2HG  ARG    44       4.546   3.548   2.648  1.00 53.45           H 
ATOM    707 1HD  ARG    44       2.829   5.114   3.174  1.00 53.14           H 
ATOM    708 2HD  ARG    44       2.431   5.342   1.472  1.00 12.03           H 
ATOM    709  HE  ARG    44       4.665   6.396   1.256  1.00 54.34           H 
ATOM    710 1HH1 ARG    44       3.278   6.181   4.391  1.00 41.03           H 
ATOM    711 2HH1 ARG    44       4.000   7.656   4.936  1.00 63.20           H 
ATOM    712 1HH2 ARG    44       5.588   8.301   1.964  1.00 33.45           H 
ATOM    713 2HH2 ARG    44       5.289   8.839   3.579  1.00 12.11           H 
ATOM    714  N   THR    45       2.131  -0.705   1.962  1.00  2.33           N 
ATOM    715  CA  THR    45       1.095  -1.733   1.748  1.00 51.21           C 
ATOM    716  C   THR    45      -0.178  -1.446   2.568  1.00 53.41           C 
ATOM    717  O   THR    45      -0.132  -1.365   3.800  1.00 11.32           O 
ATOM    718  CB  THR    45       1.618  -3.144   2.123  1.00 23.32           C 
ATOM    719  OG1 THR    45       2.821  -3.437   1.391  1.00 54.35           O 
ATOM    720  CG2 THR    45       0.570  -4.219   1.835  1.00 35.04           C 
ATOM    721  H   THR    45       2.728  -0.783   2.735  1.00 38.03           H 
ATOM    722  HA  THR    45       0.841  -1.737   0.696  1.00 73.20           H 
ATOM    723  HB  THR    45       1.844  -3.155   3.182  1.00 61.14           H 
ATOM    724  HG1 THR    45       2.946  -2.779   0.697  1.00 53.41           H 
ATOM    725 1HG2 THR    45       0.295  -4.184   0.790  1.00 41.03           H 
ATOM    726 2HG2 THR    45      -0.306  -4.043   2.441  1.00 15.34           H 
ATOM    727 3HG2 THR    45       0.978  -5.192   2.067  1.00 54.51           H 
ATOM    728  N   TYR    46      -1.311  -1.306   1.878  1.00 63.40           N 
ATOM    729  CA  TYR    46      -2.603  -1.018   2.522  1.00 72.32           C 
ATOM    730  C   TYR    46      -3.548  -2.233   2.489  1.00  1.04           C 
ATOM    731  O   TYR    46      -3.463  -3.086   1.601  1.00 65.01           O 
ATOM    732  CB  TYR    46      -3.298   0.155   1.816  1.00 33.02           C 
ATOM    733  CG  TYR    46      -2.516   1.455   1.830  1.00  4.10           C 
ATOM    734  CD1 TYR    46      -2.855   2.484   2.700  1.00 12.21           C 
ATOM    735  CD2 TYR    46      -1.453   1.658   0.960  1.00 21.03           C 
ATOM    736  CE1 TYR    46      -2.159   3.678   2.701  1.00 10.35           C 
ATOM    737  CE2 TYR    46      -0.750   2.843   0.957  1.00 52.54           C 
ATOM    738  CZ  TYR    46      -1.106   3.853   1.827  1.00 10.33           C 
ATOM    739  OH  TYR    46      -0.407   5.041   1.821  1.00  1.03           O 
ATOM    740  H   TYR    46      -1.282  -1.396   0.904  1.00 38.03           H 
ATOM    741  HA  TYR    46      -2.415  -0.746   3.554  1.00 75.12           H 
ATOM    742 1HB  TYR    46      -4.251   0.339   2.295  1.00 43.31           H 
ATOM    743 2HB  TYR    46      -3.471  -0.110   0.785  1.00  4.15           H 
ATOM    744  HD1 TYR    46      -3.675   2.338   3.388  1.00 54.12           H 
ATOM    745  HD2 TYR    46      -1.174   0.867   0.278  1.00 51.41           H 
ATOM    746  HE1 TYR    46      -2.439   4.465   3.385  1.00 41.21           H 
ATOM    747  HE2 TYR    46       0.076   2.978   0.272  1.00 62.02           H 
ATOM    748  HH  TYR    46      -0.182   5.274   0.916  1.00 21.43           H 
ATOM    749  N   ASP    47      -4.462  -2.282   3.457  1.00 31.32           N 
ATOM    750  CA  ASP    47      -5.517  -3.300   3.502  1.00 25.41           C 
ATOM    751  C   ASP    47      -6.825  -2.755   2.903  1.00 60.53           C 
ATOM    752  O   ASP    47      -7.443  -1.849   3.471  1.00 74.55           O 
ATOM    753  CB  ASP    47      -5.774  -3.726   4.954  1.00 32.23           C 
ATOM    754  CG  ASP    47      -4.574  -4.384   5.604  1.00 12.14           C 
ATOM    755  OD1 ASP    47      -4.023  -5.341   5.025  1.00 62.03           O 
ATOM    756  OD2 ASP    47      -4.175  -3.950   6.701  1.00 32.00           O 
ATOM    757  H   ASP    47      -4.426  -1.613   4.169  1.00 38.03           H 
ATOM    758  HA  ASP    47      -5.190  -4.160   2.930  1.00 74.10           H 
ATOM    759 1HB  ASP    47      -6.598  -4.426   4.975  1.00  4.43           H 
ATOM    760 2HB  ASP    47      -6.040  -2.851   5.533  1.00 73.22           H 
ATOM    761  N   LEU    48      -7.242  -3.297   1.759  1.00 63.31           N 
ATOM    762  CA  LEU    48      -8.516  -2.901   1.136  1.00 15.53           C 
ATOM    763  C   LEU    48      -9.430  -4.118   0.918  1.00 15.41           C 
ATOM    764  O   LEU    48      -8.972  -5.181   0.492  1.00 61.30           O 
ATOM    765  CB  LEU    48      -8.266  -2.205  -0.215  1.00 55.31           C 
ATOM    766  CG  LEU    48      -7.406  -0.929  -0.171  1.00 71.53           C 
ATOM    767  CD1 LEU    48      -7.264  -0.321  -1.566  1.00 41.21           C 
ATOM    768  CD2 LEU    48      -7.992   0.096   0.794  1.00 60.44           C 
ATOM    769  H   LEU    48      -6.681  -3.975   1.318  1.00 38.03           H 
ATOM    770  HA  LEU    48      -9.011  -2.207   1.802  1.00 51.14           H 
ATOM    771 1HB  LEU    48      -9.225  -1.951  -0.647  1.00 54.13           H 
ATOM    772 2HB  LEU    48      -7.778  -2.915  -0.870  1.00  3.21           H 
ATOM    773  HG  LEU    48      -6.416  -1.187   0.178  1.00 70.10           H 
ATOM    774 1HD1 LEU    48      -8.239  -0.045  -1.942  1.00  2.34           H 
ATOM    775 2HD1 LEU    48      -6.813  -1.043  -2.231  1.00 23.03           H 
ATOM    776 3HD1 LEU    48      -6.638   0.557  -1.513  1.00 65.21           H 
ATOM    777 1HD2 LEU    48      -8.034  -0.325   1.788  1.00 40.34           H 
ATOM    778 2HD2 LEU    48      -8.990   0.368   0.476  1.00 42.23           H 
ATOM    779 3HD2 LEU    48      -7.368   0.979   0.805  1.00  5.44           H 
ATOM    780  N   LYS    49     -10.724  -3.965   1.212  1.00 45.14           N 
ATOM    781  CA  LYS    49     -11.701  -5.024   0.924  1.00 60.20           C 
ATOM    782  C   LYS    49     -12.439  -4.729  -0.389  1.00 45.21           C 
ATOM    783  O   LYS    49     -12.771  -3.578  -0.681  1.00 44.14           O 
ATOM    784  CB  LYS    49     -12.718  -5.194   2.071  1.00 72.24           C 
ATOM    785  CG  LYS    49     -13.657  -4.002   2.281  1.00 52.03           C 
ATOM    786  CD  LYS    49     -13.239  -3.123   3.457  1.00  0.15           C 
ATOM    787  CE  LYS    49     -13.415  -3.841   4.792  1.00 40.23           C 
ATOM    788  NZ  LYS    49     -13.027  -2.978   5.936  1.00 22.05           N 
ATOM    789  H   LYS    49     -11.029  -3.123   1.615  1.00 38.03           H 
ATOM    790  HA  LYS    49     -11.154  -5.950   0.805  1.00  4.43           H 
ATOM    791 1HB  LYS    49     -12.173  -5.366   2.990  1.00 70.24           H 
ATOM    792 2HB  LYS    49     -13.324  -6.065   1.864  1.00  1.45           H 
ATOM    793 1HG  LYS    49     -14.656  -4.376   2.463  1.00 50.34           H 
ATOM    794 2HG  LYS    49     -13.662  -3.400   1.386  1.00 51.42           H 
ATOM    795 1HD  LYS    49     -13.846  -2.228   3.456  1.00 45.23           H 
ATOM    796 2HD  LYS    49     -12.199  -2.849   3.340  1.00 75.20           H 
ATOM    797 1HE  LYS    49     -12.796  -4.728   4.798  1.00  3.20           H 
ATOM    798 2HE  LYS    49     -14.451  -4.124   4.905  1.00 40.24           H 
ATOM    799 1HZ  LYS    49     -12.022  -2.724   5.863  1.00 73.11           H 
ATOM    800 2HZ  LYS    49     -13.184  -3.480   6.836  1.00 24.12           H 
ATOM    801 3HZ  LYS    49     -13.597  -2.107   5.936  1.00 11.23           H 
ATOM    802  N   SER    50     -12.682  -5.772  -1.180  1.00 73.12           N 
ATOM    803  CA  SER    50     -13.362  -5.624  -2.472  1.00 55.40           C 
ATOM    804  C   SER    50     -14.506  -6.635  -2.624  1.00  4.21           C 
ATOM    805  O   SER    50     -14.462  -7.735  -2.070  1.00 24.42           O 
ATOM    806  CB  SER    50     -12.362  -5.795  -3.624  1.00  3.55           C 
ATOM    807  OG  SER    50     -11.766  -7.084  -3.604  1.00 20.51           O 
ATOM    808  H   SER    50     -12.396  -6.665  -0.893  1.00 38.03           H 
ATOM    809  HA  SER    50     -13.777  -4.626  -2.519  1.00 41.42           H 
ATOM    810 1HB  SER    50     -11.584  -5.052  -3.531  1.00  3.22           H 
ATOM    811 2HB  SER    50     -12.872  -5.663  -4.567  1.00 20.24           H 
ATOM    812  HG  SER    50     -10.889  -7.030  -3.214  1.00 13.21           H 
ATOM    813  N   LYS    51     -15.541  -6.248  -3.366  1.00 54.32           N 
ATOM    814  CA  LYS    51     -16.681  -7.133  -3.628  1.00  1.12           C 
ATOM    815  C   LYS    51     -16.364  -8.142  -4.744  1.00 34.41           C 
ATOM    816  O   LYS    51     -16.046  -7.757  -5.871  1.00  1.12           O 
ATOM    817  CB  LYS    51     -17.921  -6.312  -4.013  1.00 64.33           C 
ATOM    818  CG  LYS    51     -18.490  -5.466  -2.878  1.00 72.11           C 
ATOM    819  CD  LYS    51     -18.936  -6.328  -1.697  1.00 41.12           C 
ATOM    820  CE  LYS    51     -19.703  -5.518  -0.655  1.00 62.12           C 
ATOM    821  NZ  LYS    51     -20.944  -4.916  -1.218  1.00 60.35           N 
ATOM    822  H   LYS    51     -15.537  -5.348  -3.748  1.00 38.03           H 
ATOM    823  HA  LYS    51     -16.892  -7.678  -2.718  1.00 70.32           H 
ATOM    824 1HB  LYS    51     -18.695  -6.988  -4.348  1.00 22.25           H 
ATOM    825 2HB  LYS    51     -17.662  -5.651  -4.829  1.00 60.44           H 
ATOM    826 1HG  LYS    51     -19.339  -4.909  -3.248  1.00 55.11           H 
ATOM    827 2HG  LYS    51     -17.730  -4.776  -2.539  1.00 22.35           H 
ATOM    828 1HD  LYS    51     -18.062  -6.763  -1.230  1.00 72.31           H 
ATOM    829 2HD  LYS    51     -19.578  -7.116  -2.064  1.00 35.21           H 
ATOM    830 1HE  LYS    51     -19.064  -4.728  -0.286  1.00  4.21           H 
ATOM    831 2HE  LYS    51     -19.971  -6.170   0.162  1.00 32.54           H 
ATOM    832 1HZ  LYS    51     -20.705  -4.244  -1.977  1.00 52.15           H 
ATOM    833 2HZ  LYS    51     -21.465  -4.408  -0.474  1.00 35.32           H 
ATOM    834 3HZ  LYS    51     -21.561  -5.656  -1.608  1.00 55.44           H 
ATOM    835  N   GLY    52     -16.464  -9.431  -4.428  1.00 34.23           N 
ATOM    836  CA  GLY    52     -16.205 -10.473  -5.419  1.00  2.21           C 
ATOM    837  C   GLY    52     -15.995 -11.851  -4.797  1.00 23.21           C 
ATOM    838  O   GLY    52     -16.958 -12.542  -4.457  1.00 52.40           O 
ATOM    839  H   GLY    52     -16.714  -9.679  -3.513  1.00 38.03           H 
ATOM    840 1HA  GLY    52     -15.322 -10.208  -5.982  1.00 64.35           H 
ATOM    841 2HA  GLY    52     -17.046 -10.523  -6.095  1.00 61.13           H 
ATOM    842  N   GLN    53     -14.735 -12.243  -4.632  1.00 43.02           N 
ATOM    843  CA  GLN    53     -14.388 -13.566  -4.093  1.00 50.23           C 
ATOM    844  C   GLN    53     -14.193 -13.535  -2.566  1.00 54.42           C 
ATOM    845  O   GLN    53     -13.922 -14.567  -1.947  1.00  0.02           O 
ATOM    846  CB  GLN    53     -13.117 -14.090  -4.779  1.00  1.44           C 
ATOM    847  CG  GLN    53     -13.237 -14.208  -6.297  1.00  3.50           C 
ATOM    848  CD  GLN    53     -14.342 -15.159  -6.732  1.00  3.52           C 
ATOM    849  OE1 GLN    53     -15.487 -14.762  -6.924  1.00 34.45           O 
ATOM    850  NE2 GLN    53     -14.010 -16.423  -6.889  1.00 52.20           N 
ATOM    851  H   GLN    53     -14.014 -11.629  -4.887  1.00 38.03           H 
ATOM    852  HA  GLN    53     -15.204 -14.237  -4.321  1.00 51.12           H 
ATOM    853 1HB  GLN    53     -12.882 -15.067  -4.382  1.00 55.22           H 
ATOM    854 2HB  GLN    53     -12.300 -13.417  -4.559  1.00  4.31           H 
ATOM    855 1HG  GLN    53     -12.297 -14.566  -6.692  1.00 24.50           H 
ATOM    856 2HG  GLN    53     -13.445 -13.229  -6.707  1.00 43.21           H 
ATOM    857 1HE2 GLN    53     -13.083 -16.684  -6.720  1.00 64.02           H 
ATOM    858 2HE2 GLN    53     -14.708 -17.048  -7.171  1.00 22.54           H 
ATOM    859  N   GLY    54     -14.331 -12.351  -1.966  1.00 41.33           N 
ATOM    860  CA  GLY    54     -14.203 -12.217  -0.513  1.00 14.14           C 
ATOM    861  C   GLY    54     -12.756 -12.235  -0.023  1.00 21.44           C 
ATOM    862  O   GLY    54     -12.461 -12.750   1.059  1.00 50.42           O 
ATOM    863  H   GLY    54     -14.528 -11.561  -2.511  1.00 38.03           H 
ATOM    864 1HA  GLY    54     -14.742 -13.026  -0.039  1.00 55.31           H 
ATOM    865 2HA  GLY    54     -14.654 -11.283  -0.212  1.00 22.41           H 
ATOM    866  N   ARG    55     -11.850 -11.667  -0.813  1.00 32.52           N 
ATOM    867  CA  ARG    55     -10.428 -11.619  -0.454  1.00 23.45           C 
ATOM    868  C   ARG    55      -9.956 -10.192  -0.130  1.00 43.42           C 
ATOM    869  O   ARG    55     -10.187  -9.258  -0.898  1.00 31.52           O 
ATOM    870  CB  ARG    55      -9.573 -12.210  -1.588  1.00 13.52           C 
ATOM    871  CG  ARG    55      -9.421 -13.730  -1.529  1.00 73.50           C 
ATOM    872  CD  ARG    55      -8.607 -14.163  -0.311  1.00  0.04           C 
ATOM    873  NE  ARG    55      -8.364 -15.604  -0.283  1.00 34.53           N 
ATOM    874  CZ  ARG    55      -7.361 -16.163   0.344  1.00 41.42           C 
ATOM    875  NH1 ARG    55      -6.504 -15.446   0.992  1.00 32.23           N 
ATOM    876  NH2 ARG    55      -7.222 -17.445   0.325  1.00  3.32           N 
ATOM    877  H   ARG    55     -12.140 -11.270  -1.661  1.00 38.03           H 
ATOM    878  HA  ARG    55     -10.293 -12.229   0.430  1.00  4.20           H 
ATOM    879 1HB  ARG    55      -8.584 -11.771  -1.548  1.00 62.35           H 
ATOM    880 2HB  ARG    55     -10.026 -11.953  -2.534  1.00 33.23           H 
ATOM    881 1HG  ARG    55      -8.917 -14.066  -2.424  1.00  1.41           H 
ATOM    882 2HG  ARG    55     -10.401 -14.183  -1.476  1.00 44.10           H 
ATOM    883 1HD  ARG    55      -9.144 -13.881   0.584  1.00 72.10           H 
ATOM    884 2HD  ARG    55      -7.655 -13.650  -0.332  1.00 63.33           H 
ATOM    885  HE  ARG    55      -8.996 -16.181  -0.756  1.00 12.01           H 
ATOM    886 1HH1 ARG    55      -6.602 -14.455   1.023  1.00 52.24           H 
ATOM    887 2HH1 ARG    55      -5.738 -15.887   1.461  1.00 20.33           H 
ATOM    888 1HH2 ARG    55      -7.882 -18.007  -0.169  1.00 60.20           H 
ATOM    889 2HH2 ARG    55      -6.459 -17.868   0.804  1.00 51.33           H 
ATOM    890  N   MET    56      -9.301 -10.035   1.020  1.00 44.22           N 
ATOM    891  CA  MET    56      -8.649  -8.768   1.371  1.00 42.10           C 
ATOM    892  C   MET    56      -7.379  -8.578   0.524  1.00 21.21           C 
ATOM    893  O   MET    56      -6.450  -9.382   0.592  1.00 62.50           O 
ATOM    894  CB  MET    56      -8.321  -8.727   2.875  1.00  5.31           C 
ATOM    895  CG  MET    56      -7.436  -9.873   3.359  1.00 21.35           C 
ATOM    896  SD  MET    56      -7.092  -9.790   5.133  1.00 63.43           S 
ATOM    897  CE  MET    56      -8.743  -9.946   5.817  1.00 72.51           C 
ATOM    898  H   MET    56      -9.257 -10.786   1.648  1.00 38.03           H 
ATOM    899  HA  MET    56      -9.342  -7.968   1.143  1.00 13.40           H 
ATOM    900 1HB  MET    56      -9.247  -8.759   3.431  1.00 42.31           H 
ATOM    901 2HB  MET    56      -7.816  -7.797   3.097  1.00 33.11           H 
ATOM    902 1HG  MET    56      -6.499  -9.838   2.824  1.00 20.23           H 
ATOM    903 2HG  MET    56      -7.934 -10.810   3.146  1.00 33.22           H 
ATOM    904 1HE  MET    56      -9.365  -9.140   5.452  1.00 54.42           H 
ATOM    905 2HE  MET    56      -8.693  -9.898   6.896  1.00 70.41           H 
ATOM    906 3HE  MET    56      -9.169 -10.892   5.518  1.00 21.44           H 
ATOM    907  N   ILE    57      -7.343  -7.519  -0.275  1.00 44.11           N 
ATOM    908  CA  ILE    57      -6.249  -7.320  -1.230  1.00  1.30           C 
ATOM    909  C   ILE    57      -5.142  -6.424  -0.656  1.00 62.51           C 
ATOM    910  O   ILE    57      -5.417  -5.421   0.010  1.00 61.12           O 
ATOM    911  CB  ILE    57      -6.767  -6.715  -2.562  1.00 34.42           C 
ATOM    912  CG1 ILE    57      -7.395  -5.326  -2.336  1.00 41.25           C 
ATOM    913  CG2 ILE    57      -7.776  -7.662  -3.216  1.00 71.41           C 
ATOM    914  CD1 ILE    57      -7.899  -4.667  -3.606  1.00 60.11           C 
ATOM    915  H   ILE    57      -8.059  -6.850  -0.219  1.00 38.03           H 
ATOM    916  HA  ILE    57      -5.822  -8.291  -1.451  1.00  1.23           H 
ATOM    917  HB  ILE    57      -5.925  -6.616  -3.233  1.00 62.55           H 
ATOM    918 1HG1 ILE    57      -6.653  -4.671  -1.898  1.00 53.21           H 
ATOM    919 2HG1 ILE    57      -8.230  -5.416  -1.658  1.00 43.10           H 
ATOM    920 1HG2 ILE    57      -8.603  -7.834  -2.541  1.00  4.15           H 
ATOM    921 2HG2 ILE    57      -7.296  -8.603  -3.441  1.00 61.11           H 
ATOM    922 3HG2 ILE    57      -8.146  -7.222  -4.132  1.00 22.41           H 
ATOM    923 1HD1 ILE    57      -8.330  -3.707  -3.366  1.00 64.34           H 
ATOM    924 2HD1 ILE    57      -8.651  -5.294  -4.065  1.00 32.33           H 
ATOM    925 3HD1 ILE    57      -7.076  -4.531  -4.292  1.00  1.20           H 
ATOM    926  N   GLN    58      -3.888  -6.804  -0.904  1.00 75.55           N 
ATOM    927  CA  GLN    58      -2.741  -6.021  -0.436  1.00 32.25           C 
ATOM    928  C   GLN    58      -2.276  -5.031  -1.512  1.00 23.44           C 
ATOM    929  O   GLN    58      -1.633  -5.417  -2.485  1.00 52.52           O 
ATOM    930  CB  GLN    58      -1.591  -6.967  -0.058  1.00 34.13           C 
ATOM    931  CG  GLN    58      -1.957  -7.971   1.032  1.00 64.23           C 
ATOM    932  CD  GLN    58      -2.190  -7.316   2.386  1.00 74.11           C 
ATOM    933  OE1 GLN    58      -1.273  -7.190   3.189  1.00 51.23           O 
ATOM    934  NE2 GLN    58      -3.409  -6.889   2.648  1.00 43.25           N 
ATOM    935  H   GLN    58      -3.727  -7.636  -1.410  1.00 38.03           H 
ATOM    936  HA  GLN    58      -3.044  -5.469   0.443  1.00  0.12           H 
ATOM    937 1HB  GLN    58      -0.754  -6.377   0.291  1.00 54.15           H 
ATOM    938 2HB  GLN    58      -1.288  -7.516  -0.939  1.00 73.12           H 
ATOM    939 1HG  GLN    58      -1.152  -8.688   1.130  1.00 24.40           H 
ATOM    940 2HG  GLN    58      -2.859  -8.489   0.739  1.00 52.32           H 
ATOM    941 1HE2 GLN    58      -4.102  -7.014   1.972  1.00  1.33           H 
ATOM    942 2HE2 GLN    58      -3.564  -6.449   3.513  1.00 22.43           H 
ATOM    943  N   VAL    59      -2.591  -3.753  -1.326  1.00  4.45           N 
ATOM    944  CA  VAL    59      -2.241  -2.718  -2.309  1.00 30.25           C 
ATOM    945  C   VAL    59      -0.965  -1.968  -1.905  1.00 20.54           C 
ATOM    946  O   VAL    59      -0.931  -1.287  -0.884  1.00 23.02           O 
ATOM    947  CB  VAL    59      -3.397  -1.702  -2.495  1.00 73.23           C 
ATOM    948  CG1 VAL    59      -3.020  -0.613  -3.503  1.00 53.41           C 
ATOM    949  CG2 VAL    59      -4.672  -2.424  -2.926  1.00 53.45           C 
ATOM    950  H   VAL    59      -3.072  -3.496  -0.509  1.00 38.03           H 
ATOM    951  HA  VAL    59      -2.069  -3.207  -3.259  1.00 21.45           H 
ATOM    952  HB  VAL    59      -3.585  -1.225  -1.541  1.00 43.44           H 
ATOM    953 1HG1 VAL    59      -2.152  -0.076  -3.149  1.00 23.35           H 
ATOM    954 2HG1 VAL    59      -3.844   0.075  -3.617  1.00  3.51           H 
ATOM    955 3HG1 VAL    59      -2.797  -1.067  -4.459  1.00 34.40           H 
ATOM    956 1HG2 VAL    59      -4.507  -2.916  -3.874  1.00 22.54           H 
ATOM    957 2HG2 VAL    59      -5.477  -1.709  -3.027  1.00 14.30           H 
ATOM    958 3HG2 VAL    59      -4.939  -3.160  -2.180  1.00 54.44           H 
ATOM    959  N   SER    60       0.079  -2.093  -2.720  1.00 30.53           N 
ATOM    960  CA  SER    60       1.375  -1.464  -2.423  1.00 10.42           C 
ATOM    961  C   SER    60       1.687  -0.321  -3.397  1.00 43.11           C 
ATOM    962  O   SER    60       1.704  -0.514  -4.613  1.00 35.23           O 
ATOM    963  CB  SER    60       2.503  -2.504  -2.475  1.00 30.45           C 
ATOM    964  OG  SER    60       3.745  -1.930  -2.103  1.00  4.40           O 
ATOM    965  H   SER    60      -0.022  -2.617  -3.545  1.00 38.03           H 
ATOM    966  HA  SER    60       1.325  -1.059  -1.422  1.00 23.51           H 
ATOM    967 1HB  SER    60       2.586  -2.896  -3.479  1.00 14.11           H 
ATOM    968 2HB  SER    60       2.277  -3.310  -1.794  1.00 23.24           H 
ATOM    969  HG  SER    60       4.258  -1.728  -2.897  1.00 23.32           H 
ATOM    970  N   ILE    61       1.935   0.868  -2.852  1.00 70.05           N 
ATOM    971  CA  ILE    61       2.318   2.037  -3.659  1.00 42.11           C 
ATOM    972  C   ILE    61       3.747   2.494  -3.321  1.00 11.12           C 
ATOM    973  O   ILE    61       4.185   2.377  -2.175  1.00 31.32           O 
ATOM    974  CB  ILE    61       1.331   3.218  -3.451  1.00 34.21           C 
ATOM    975  CG1 ILE    61       1.280   3.630  -1.971  1.00 45.51           C 
ATOM    976  CG2 ILE    61      -0.062   2.849  -3.965  1.00 32.31           C 
ATOM    977  CD1 ILE    61       0.366   4.804  -1.691  1.00 14.01           C 
ATOM    978  H   ILE    61       1.861   0.965  -1.878  1.00 38.03           H 
ATOM    979  HA  ILE    61       2.284   1.750  -4.703  1.00 63.33           H 
ATOM    980  HB  ILE    61       1.685   4.057  -4.037  1.00 24.11           H 
ATOM    981 1HG1 ILE    61       2.275   3.900  -1.643  1.00 72.01           H 
ATOM    982 2HG1 ILE    61       0.929   2.795  -1.382  1.00 54.50           H 
ATOM    983 1HG2 ILE    61      -0.003   2.597  -5.015  1.00 33.12           H 
ATOM    984 2HG2 ILE    61      -0.730   3.690  -3.837  1.00 73.22           H 
ATOM    985 3HG2 ILE    61      -0.441   2.000  -3.412  1.00 24.14           H 
ATOM    986 1HD1 ILE    61       0.394   5.039  -0.638  1.00 44.21           H 
ATOM    987 2HD1 ILE    61      -0.645   4.552  -1.975  1.00 54.24           H 
ATOM    988 3HD1 ILE    61       0.695   5.661  -2.258  1.00 21.04           H 
ATOM    989  N   PRO    62       4.500   3.027  -4.305  1.00 60.24           N 
ATOM    990  CA  PRO    62       5.904   3.440  -4.091  1.00 61.14           C 
ATOM    991  C   PRO    62       6.064   4.597  -3.077  1.00 70.05           C 
ATOM    992  O   PRO    62       5.137   5.376  -2.849  1.00  4.04           O 
ATOM    993  CB  PRO    62       6.364   3.878  -5.490  1.00 34.11           C 
ATOM    994  CG  PRO    62       5.106   4.211  -6.224  1.00 50.44           C 
ATOM    995  CD  PRO    62       4.057   3.273  -5.693  1.00 52.14           C 
ATOM    996  HA  PRO    62       6.507   2.602  -3.763  1.00 73.21           H 
ATOM    997 1HB  PRO    62       6.897   3.067  -5.969  1.00 72.22           H 
ATOM    998 2HB  PRO    62       7.015   4.738  -5.408  1.00 24.01           H 
ATOM    999 1HG  PRO    62       5.245   4.060  -7.286  1.00 41.45           H 
ATOM   1000 2HG  PRO    62       4.826   5.237  -6.026  1.00  2.11           H 
ATOM   1001 1HD  PRO    62       4.046   2.353  -6.262  1.00 41.22           H 
ATOM   1002 2HD  PRO    62       3.082   3.743  -5.713  1.00 24.45           H 
ATOM   1003  N   ALA    63       7.263   4.709  -2.494  1.00 32.02           N 
ATOM   1004  CA  ALA    63       7.557   5.715  -1.456  1.00 31.42           C 
ATOM   1005  C   ALA    63       7.290   7.152  -1.925  1.00 34.23           C 
ATOM   1006  O   ALA    63       6.892   8.005  -1.130  1.00 61.24           O 
ATOM   1007  CB  ALA    63       9.002   5.582  -0.990  1.00 12.05           C 
ATOM   1008  H   ALA    63       7.977   4.092  -2.764  1.00 38.03           H 
ATOM   1009  HA  ALA    63       6.918   5.507  -0.610  1.00 62.32           H 
ATOM   1010 1HB  ALA    63       9.670   5.853  -1.795  1.00 73.22           H 
ATOM   1011 2HB  ALA    63       9.191   4.560  -0.696  1.00 62.43           H 
ATOM   1012 3HB  ALA    63       9.174   6.236  -0.146  1.00 60.03           H 
ATOM   1013  N   SER    64       7.511   7.418  -3.214  1.00 23.11           N 
ATOM   1014  CA  SER    64       7.278   8.758  -3.785  1.00 33.24           C 
ATOM   1015  C   SER    64       5.822   9.213  -3.593  1.00 22.01           C 
ATOM   1016  O   SER    64       5.518  10.404  -3.678  1.00 45.23           O 
ATOM   1017  CB  SER    64       7.629   8.780  -5.280  1.00 40.12           C 
ATOM   1018  OG  SER    64       8.998   8.460  -5.499  1.00  5.30           O 
ATOM   1019  H   SER    64       7.850   6.702  -3.793  1.00 38.03           H 
ATOM   1020  HA  SER    64       7.925   9.452  -3.266  1.00 13.23           H 
ATOM   1021 1HB  SER    64       7.436   9.766  -5.680  1.00 24.42           H 
ATOM   1022 2HB  SER    64       7.019   8.056  -5.802  1.00 43.44           H 
ATOM   1023  HG  SER    64       9.067   7.551  -5.814  1.00 63.04           H 
ATOM   1024  N   VAL    65       4.930   8.260  -3.342  1.00 51.35           N 
ATOM   1025  CA  VAL    65       3.521   8.561  -3.082  1.00 50.10           C 
ATOM   1026  C   VAL    65       3.270   8.748  -1.573  1.00 32.23           C 
ATOM   1027  O   VAL    65       3.622   7.883  -0.765  1.00 31.33           O 
ATOM   1028  CB  VAL    65       2.603   7.434  -3.622  1.00 73.21           C 
ATOM   1029  CG1 VAL    65       1.129   7.794  -3.438  1.00 34.34           C 
ATOM   1030  CG2 VAL    65       2.915   7.147  -5.089  1.00 65.22           C 
ATOM   1031  H   VAL    65       5.225   7.325  -3.324  1.00 38.03           H 
ATOM   1032  HA  VAL    65       3.274   9.477  -3.601  1.00 22.10           H 
ATOM   1033  HB  VAL    65       2.800   6.533  -3.055  1.00 22.53           H 
ATOM   1034 1HG1 VAL    65       0.511   6.986  -3.807  1.00 25.14           H 
ATOM   1035 2HG1 VAL    65       0.906   8.696  -3.990  1.00 60.15           H 
ATOM   1036 3HG1 VAL    65       0.921   7.953  -2.390  1.00 73.22           H 
ATOM   1037 1HG2 VAL    65       2.298   6.330  -5.436  1.00 14.42           H 
ATOM   1038 2HG2 VAL    65       3.958   6.877  -5.190  1.00 41.42           H 
ATOM   1039 3HG2 VAL    65       2.712   8.027  -5.680  1.00 51.52           H 
ATOM   1040  N   PRO    66       2.673   9.888  -1.165  1.00 71.42           N 
ATOM   1041  CA  PRO    66       2.403  10.174   0.257  1.00  2.20           C 
ATOM   1042  C   PRO    66       1.300   9.276   0.858  1.00 35.40           C 
ATOM   1043  O   PRO    66       0.512   8.663   0.135  1.00 53.31           O 
ATOM   1044  CB  PRO    66       1.957  11.644   0.239  1.00 13.22           C 
ATOM   1045  CG  PRO    66       1.394  11.848  -1.128  1.00  4.54           C 
ATOM   1046  CD  PRO    66       2.218  10.985  -2.046  1.00 33.50           C 
ATOM   1047  HA  PRO    66       3.302  10.077   0.850  1.00 54.05           H 
ATOM   1048 1HB  PRO    66       2.811  12.287   0.413  1.00 55.23           H 
ATOM   1049 2HB  PRO    66       1.214  11.813   1.006  1.00 72.23           H 
ATOM   1050 1HG  PRO    66       1.477  12.887  -1.412  1.00 31.01           H 
ATOM   1051 2HG  PRO    66       0.358  11.537  -1.147  1.00  1.31           H 
ATOM   1052 1HD  PRO    66       3.058  11.540  -2.436  1.00 25.05           H 
ATOM   1053 2HD  PRO    66       1.610  10.605  -2.857  1.00 23.01           H 
ATOM   1054  N   LEU    67       1.255   9.210   2.186  1.00  3.11           N 
ATOM   1055  CA  LEU    67       0.232   8.438   2.902  1.00  2.22           C 
ATOM   1056  C   LEU    67      -1.144   9.128   2.822  1.00 75.53           C 
ATOM   1057  O   LEU    67      -1.235  10.357   2.860  1.00 63.14           O 
ATOM   1058  CB  LEU    67       0.650   8.278   4.373  1.00 51.50           C 
ATOM   1059  CG  LEU    67      -0.292   7.434   5.252  1.00 44.43           C 
ATOM   1060  CD1 LEU    67      -0.317   5.983   4.792  1.00 64.51           C 
ATOM   1061  CD2 LEU    67       0.112   7.520   6.719  1.00 10.50           C 
ATOM   1062  H   LEU    67       1.934   9.689   2.706  1.00 38.03           H 
ATOM   1063  HA  LEU    67       0.165   7.460   2.445  1.00 42.43           H 
ATOM   1064 1HB  LEU    67       0.724   9.264   4.808  1.00  4.33           H 
ATOM   1065 2HB  LEU    67       1.633   7.825   4.393  1.00 54.22           H 
ATOM   1066  HG  LEU    67      -1.298   7.822   5.163  1.00 25.04           H 
ATOM   1067 1HD1 LEU    67      -0.692   5.932   3.781  1.00 10.35           H 
ATOM   1068 2HD1 LEU    67      -0.961   5.411   5.444  1.00 11.35           H 
ATOM   1069 3HD1 LEU    67       0.685   5.573   4.826  1.00 33.14           H 
ATOM   1070 1HD2 LEU    67       0.091   8.552   7.038  1.00 21.15           H 
ATOM   1071 2HD2 LEU    67       1.110   7.123   6.846  1.00 35.14           H 
ATOM   1072 3HD2 LEU    67      -0.583   6.947   7.316  1.00 52.14           H 
ATOM   1073  N   LYS    68      -2.210   8.337   2.693  1.00 31.51           N 
ATOM   1074  CA  LYS    68      -3.575   8.882   2.671  1.00 60.21           C 
ATOM   1075  C   LYS    68      -4.355   8.495   3.935  1.00 13.05           C 
ATOM   1076  O   LYS    68      -4.773   7.349   4.102  1.00 40.51           O 
ATOM   1077  CB  LYS    68      -4.351   8.423   1.427  1.00 33.02           C 
ATOM   1078  CG  LYS    68      -3.828   8.986   0.103  1.00 64.12           C 
ATOM   1079  CD  LYS    68      -2.595   8.241  -0.399  1.00 43.32           C 
ATOM   1080  CE  LYS    68      -1.973   8.926  -1.613  1.00 74.33           C 
ATOM   1081  NZ  LYS    68      -2.942   9.105  -2.726  1.00 20.52           N 
ATOM   1082  H   LYS    68      -2.080   7.370   2.618  1.00 38.03           H 
ATOM   1083  HA  LYS    68      -3.495   9.962   2.643  1.00 14.13           H 
ATOM   1084 1HB  LYS    68      -5.384   8.727   1.539  1.00 74.01           H 
ATOM   1085 2HB  LYS    68      -4.311   7.343   1.376  1.00 31.14           H 
ATOM   1086 1HG  LYS    68      -3.574  10.029   0.245  1.00 32.42           H 
ATOM   1087 2HG  LYS    68      -4.607   8.907  -0.642  1.00 10.02           H 
ATOM   1088 1HD  LYS    68      -2.881   7.235  -0.672  1.00 23.05           H 
ATOM   1089 2HD  LYS    68      -1.862   8.204   0.394  1.00 10.42           H 
ATOM   1090 1HE  LYS    68      -1.145   8.328  -1.963  1.00 45.51           H 
ATOM   1091 2HE  LYS    68      -1.613   9.895  -1.313  1.00 34.11           H 
ATOM   1092 1HZ  LYS    68      -2.446   9.421  -3.586  1.00 32.10           H 
ATOM   1093 2HZ  LYS    68      -3.652   9.821  -2.476  1.00 63.14           H 
ATOM   1094 3HZ  LYS    68      -3.430   8.212  -2.932  1.00 13.33           H 
ATOM   1095  N   GLU    69      -4.551   9.471   4.812  1.00 64.53           N 
ATOM   1096  CA  GLU    69      -5.273   9.267   6.070  1.00 44.03           C 
ATOM   1097  C   GLU    69      -6.793   9.153   5.839  1.00 14.02           C 
ATOM   1098  O   GLU    69      -7.542  10.098   6.107  1.00 52.20           O 
ATOM   1099  CB  GLU    69      -4.977  10.443   7.011  1.00 43.31           C 
ATOM   1100  CG  GLU    69      -3.504  10.599   7.389  1.00 64.21           C 
ATOM   1101  CD  GLU    69      -3.088   9.730   8.570  1.00  2.14           C 
ATOM   1102  OE1 GLU    69      -3.059  10.248   9.710  1.00 74.04           O 
ATOM   1103  OE2 GLU    69      -2.785   8.537   8.370  1.00 74.11           O 
ATOM   1104  H   GLU    69      -4.198  10.362   4.611  1.00 38.03           H 
ATOM   1105  HA  GLU    69      -4.915   8.353   6.524  1.00 10.04           H 
ATOM   1106 1HB  GLU    69      -5.552  10.315   7.918  1.00 33.54           H 
ATOM   1107 2HB  GLU    69      -5.297  11.353   6.523  1.00 34.53           H 
ATOM   1108 1HG  GLU    69      -3.322  11.634   7.642  1.00 41.43           H 
ATOM   1109 2HG  GLU    69      -2.895  10.333   6.536  1.00 72.31           H 
ATOM   1110  N   PHE    70      -7.242   8.012   5.320  1.00 65.54           N 
ATOM   1111  CA  PHE    70      -8.675   7.790   5.057  1.00 10.24           C 
ATOM   1112  C   PHE    70      -9.368   7.065   6.220  1.00 31.44           C 
ATOM   1113  O   PHE    70      -8.730   6.336   6.984  1.00 13.33           O 
ATOM   1114  CB  PHE    70      -8.874   6.984   3.764  1.00 52.51           C 
ATOM   1115  CG  PHE    70      -8.493   7.725   2.503  1.00 32.13           C 
ATOM   1116  CD1 PHE    70      -8.788   9.073   2.360  1.00 51.32           C 
ATOM   1117  CD2 PHE    70      -7.857   7.070   1.456  1.00 24.41           C 
ATOM   1118  CE1 PHE    70      -8.456   9.751   1.204  1.00 22.15           C 
ATOM   1119  CE2 PHE    70      -7.522   7.747   0.298  1.00 54.44           C 
ATOM   1120  CZ  PHE    70      -7.820   9.089   0.173  1.00 63.43           C 
ATOM   1121  H   PHE    70      -6.599   7.303   5.106  1.00 38.03           H 
ATOM   1122  HA  PHE    70      -9.140   8.760   4.935  1.00 61.21           H 
ATOM   1123 1HB  PHE    70      -9.915   6.703   3.681  1.00 24.12           H 
ATOM   1124 2HB  PHE    70      -8.274   6.088   3.814  1.00  0.02           H 
ATOM   1125  HD1 PHE    70      -9.283   9.597   3.165  1.00 11.42           H 
ATOM   1126  HD2 PHE    70      -7.624   6.018   1.551  1.00 14.53           H 
ATOM   1127  HE1 PHE    70      -8.696  10.800   1.106  1.00 71.10           H 
ATOM   1128  HE2 PHE    70      -7.024   7.226  -0.508  1.00  1.14           H 
ATOM   1129  HZ  PHE    70      -7.562   9.619  -0.732  1.00 25.51           H 
ATOM   1130  N   ASP    71     -10.680   7.271   6.348  1.00 63.45           N 
ATOM   1131  CA  ASP    71     -11.475   6.607   7.389  1.00 22.44           C 
ATOM   1132  C   ASP    71     -11.839   5.165   6.993  1.00 43.34           C 
ATOM   1133  O   ASP    71     -11.631   4.748   5.851  1.00  5.53           O 
ATOM   1134  CB  ASP    71     -12.743   7.423   7.683  1.00 60.43           C 
ATOM   1135  CG  ASP    71     -13.539   7.750   6.428  1.00  5.44           C 
ATOM   1136  OD1 ASP    71     -13.103   8.641   5.662  1.00 24.11           O 
ATOM   1137  OD2 ASP    71     -14.605   7.139   6.212  1.00 44.40           O 
ATOM   1138  H   ASP    71     -11.130   7.882   5.728  1.00 38.03           H 
ATOM   1139  HA  ASP    71     -10.872   6.571   8.287  1.00 23.25           H 
ATOM   1140 1HB  ASP    71     -12.462   8.352   8.160  1.00 31.40           H 
ATOM   1141 2HB  ASP    71     -13.377   6.862   8.356  1.00 50.14           H 
ATOM   1142  N   TYR    72     -12.387   4.409   7.939  1.00 54.40           N 
ATOM   1143  CA  TYR    72     -12.694   2.995   7.708  1.00 21.44           C 
ATOM   1144  C   TYR    72     -13.829   2.819   6.679  1.00 41.34           C 
ATOM   1145  O   TYR    72     -14.887   3.438   6.789  1.00 11.10           O 
ATOM   1146  CB  TYR    72     -13.053   2.301   9.032  1.00  1.03           C 
ATOM   1147  CG  TYR    72     -13.052   0.784   8.942  1.00  3.21           C 
ATOM   1148  CD1 TYR    72     -14.237   0.069   8.842  1.00 22.44           C 
ATOM   1149  CD2 TYR    72     -11.857   0.071   8.942  1.00 34.13           C 
ATOM   1150  CE1 TYR    72     -14.233  -1.309   8.741  1.00 14.34           C 
ATOM   1151  CE2 TYR    72     -11.847  -1.307   8.847  1.00 13.42           C 
ATOM   1152  CZ  TYR    72     -13.037  -1.991   8.745  1.00 60.12           C 
ATOM   1153  OH  TYR    72     -13.032  -3.364   8.625  1.00 62.34           O 
ATOM   1154  H   TYR    72     -12.592   4.810   8.812  1.00 38.03           H 
ATOM   1155  HA  TYR    72     -11.800   2.532   7.311  1.00 60.11           H 
ATOM   1156 1HB  TYR    72     -14.039   2.619   9.345  1.00 54.01           H 
ATOM   1157 2HB  TYR    72     -12.334   2.586   9.787  1.00 34.31           H 
ATOM   1158  HD1 TYR    72     -15.176   0.605   8.839  1.00  5.23           H 
ATOM   1159  HD2 TYR    72     -10.923   0.609   9.024  1.00 52.15           H 
ATOM   1160  HE1 TYR    72     -15.168  -1.846   8.664  1.00  3.33           H 
ATOM   1161  HE2 TYR    72     -10.907  -1.842   8.850  1.00 62.23           H 
ATOM   1162  HH  TYR    72     -12.488  -3.751   9.328  1.00 23.03           H 
ATOM   1163  N   ASN    73     -13.582   1.962   5.685  1.00 13.32           N 
ATOM   1164  CA  ASN    73     -14.537   1.676   4.597  1.00  4.03           C 
ATOM   1165  C   ASN    73     -14.728   2.865   3.634  1.00 14.10           C 
ATOM   1166  O   ASN    73     -15.697   2.903   2.874  1.00  3.25           O 
ATOM   1167  CB  ASN    73     -15.894   1.214   5.147  1.00 41.54           C 
ATOM   1168  CG  ASN    73     -15.807  -0.117   5.875  1.00 64.11           C 
ATOM   1169  OD1 ASN    73     -14.941  -0.947   5.599  1.00  1.31           O 
ATOM   1170  ND2 ASN    73     -16.713  -0.339   6.806  1.00 23.20           N 
ATOM   1171  H   ASN    73     -12.724   1.494   5.682  1.00 38.03           H 
ATOM   1172  HA  ASN    73     -14.112   0.863   4.025  1.00 54.20           H 
ATOM   1173 1HB  ASN    73     -16.593   1.108   4.330  1.00 33.52           H 
ATOM   1174 2HB  ASN    73     -16.266   1.956   5.838  1.00 42.32           H 
ATOM   1175 1HD2 ASN    73     -17.383   0.356   6.974  1.00  1.51           H 
ATOM   1176 2HD2 ASN    73     -16.683  -1.191   7.284  1.00 64.11           H 
ATOM   1177  N   ALA    74     -13.795   3.815   3.642  1.00  3.42           N 
ATOM   1178  CA  ALA    74     -13.822   4.925   2.681  1.00 54.43           C 
ATOM   1179  C   ALA    74     -13.658   4.409   1.238  1.00 73.01           C 
ATOM   1180  O   ALA    74     -12.775   3.594   0.963  1.00 73.12           O 
ATOM   1181  CB  ALA    74     -12.731   5.939   3.015  1.00 22.14           C 
ATOM   1182  H   ALA    74     -13.082   3.780   4.313  1.00 38.03           H 
ATOM   1183  HA  ALA    74     -14.780   5.420   2.772  1.00 45.41           H 
ATOM   1184 1HB  ALA    74     -12.802   6.783   2.342  1.00 41.33           H 
ATOM   1185 2HB  ALA    74     -11.761   5.474   2.907  1.00 32.44           H 
ATOM   1186 3HB  ALA    74     -12.854   6.280   4.032  1.00 34.34           H 
ATOM   1187  N   ARG    75     -14.512   4.882   0.326  1.00 13.04           N 
ATOM   1188  CA  ARG    75     -14.486   4.421  -1.072  1.00 13.00           C 
ATOM   1189  C   ARG    75     -13.323   5.045  -1.861  1.00 24.42           C 
ATOM   1190  O   ARG    75     -13.255   6.266  -2.036  1.00 42.21           O 
ATOM   1191  CB  ARG    75     -15.804   4.750  -1.784  1.00 65.32           C 
ATOM   1192  CG  ARG    75     -17.039   4.090  -1.176  1.00 21.11           C 
ATOM   1193  CD  ARG    75     -18.289   4.422  -1.989  1.00 12.53           C 
ATOM   1194  NE  ARG    75     -18.418   5.863  -2.198  1.00 40.25           N 
ATOM   1195  CZ  ARG    75     -18.634   6.429  -3.356  1.00 23.40           C 
ATOM   1196  NH1 ARG    75     -18.852   5.721  -4.415  1.00 63.33           N 
ATOM   1197  NH2 ARG    75     -18.643   7.715  -3.447  1.00 23.23           N 
ATOM   1198  H   ARG    75     -15.168   5.556   0.596  1.00 38.03           H 
ATOM   1199  HA  ARG    75     -14.359   3.346  -1.061  1.00 40.51           H 
ATOM   1200 1HB  ARG    75     -15.727   4.433  -2.815  1.00 41.21           H 
ATOM   1201 2HB  ARG    75     -15.952   5.821  -1.761  1.00 74.01           H 
ATOM   1202 1HG  ARG    75     -17.169   4.448  -0.165  1.00 64.41           H 
ATOM   1203 2HG  ARG    75     -16.900   3.017  -1.167  1.00 34.31           H 
ATOM   1204 1HD  ARG    75     -19.158   4.064  -1.454  1.00 24.01           H 
ATOM   1205 2HD  ARG    75     -18.226   3.924  -2.947  1.00 62.41           H 
ATOM   1206  HE  ARG    75     -18.306   6.440  -1.419  1.00 35.10           H 
ATOM   1207 1HH1 ARG    75     -18.861   4.723  -4.359  1.00 31.31           H 
ATOM   1208 2HH1 ARG    75     -19.016   6.173  -5.288  1.00 14.15           H 
ATOM   1209 1HH2 ARG    75     -18.486   8.277  -2.638  1.00 12.33           H 
ATOM   1210 2HH2 ARG    75     -18.793   8.147  -4.335  1.00 44.00           H 
ATOM   1211  N   VAL    76     -12.430   4.194  -2.352  1.00 23.23           N 
ATOM   1212  CA  VAL    76     -11.267   4.629  -3.132  1.00 71.52           C 
ATOM   1213  C   VAL    76     -11.213   3.929  -4.502  1.00 34.20           C 
ATOM   1214  O   VAL    76     -11.861   2.904  -4.715  1.00  0.23           O 
ATOM   1215  CB  VAL    76      -9.945   4.344  -2.365  1.00 62.45           C 
ATOM   1216  CG1 VAL    76      -9.910   5.100  -1.036  1.00 24.15           C 
ATOM   1217  CG2 VAL    76      -9.759   2.844  -2.137  1.00 25.22           C 
ATOM   1218  H   VAL    76     -12.555   3.234  -2.188  1.00 38.03           H 
ATOM   1219  HA  VAL    76     -11.343   5.698  -3.291  1.00 41.24           H 
ATOM   1220  HB  VAL    76      -9.120   4.698  -2.970  1.00 15.10           H 
ATOM   1221 1HG1 VAL    76      -9.933   6.164  -1.225  1.00 20.51           H 
ATOM   1222 2HG1 VAL    76      -9.004   4.851  -0.502  1.00 64.32           H 
ATOM   1223 3HG1 VAL    76     -10.767   4.821  -0.440  1.00 45.43           H 
ATOM   1224 1HG2 VAL    76      -9.726   2.334  -3.089  1.00 32.52           H 
ATOM   1225 2HG2 VAL    76     -10.583   2.460  -1.552  1.00 51.41           H 
ATOM   1226 3HG2 VAL    76      -8.832   2.671  -1.607  1.00 53.41           H 
ATOM   1227  N   GLU    77     -10.453   4.501  -5.432  1.00 32.14           N 
ATOM   1228  CA  GLU    77     -10.163   3.849  -6.713  1.00 22.31           C 
ATOM   1229  C   GLU    77      -8.687   4.055  -7.095  1.00 72.21           C 
ATOM   1230  O   GLU    77      -8.079   5.078  -6.765  1.00 44.33           O 
ATOM   1231  CB  GLU    77     -11.103   4.349  -7.827  1.00 13.43           C 
ATOM   1232  CG  GLU    77     -11.015   5.843  -8.125  1.00 43.32           C 
ATOM   1233  CD  GLU    77     -11.925   6.257  -9.279  1.00 25.33           C 
ATOM   1234  OE1 GLU    77     -11.507   6.124 -10.449  1.00 24.54           O 
ATOM   1235  OE2 GLU    77     -13.062   6.712  -9.023  1.00 41.11           O 
ATOM   1236  H   GLU    77     -10.080   5.390  -5.259  1.00 38.03           H 
ATOM   1237  HA  GLU    77     -10.326   2.787  -6.576  1.00  5.11           H 
ATOM   1238 1HB  GLU    77     -12.122   4.122  -7.542  1.00  2.14           H 
ATOM   1239 2HB  GLU    77     -10.873   3.812  -8.737  1.00 14.51           H 
ATOM   1240 1HG  GLU    77      -9.994   6.087  -8.384  1.00 52.12           H 
ATOM   1241 2HG  GLU    77     -11.301   6.394  -7.240  1.00 50.11           H 
ATOM   1242  N   LEU    78      -8.109   3.065  -7.772  1.00 40.24           N 
ATOM   1243  CA  LEU    78      -6.675   3.073  -8.084  1.00 22.12           C 
ATOM   1244  C   LEU    78      -6.398   3.578  -9.507  1.00 42.24           C 
ATOM   1245  O   LEU    78      -7.094   3.215 -10.453  1.00 12.11           O 
ATOM   1246  CB  LEU    78      -6.097   1.662  -7.906  1.00 52.00           C 
ATOM   1247  CG  LEU    78      -6.233   1.076  -6.491  1.00 43.42           C 
ATOM   1248  CD1 LEU    78      -5.671  -0.344  -6.429  1.00 60.04           C 
ATOM   1249  CD2 LEU    78      -5.536   1.975  -5.472  1.00  3.22           C 
ATOM   1250  H   LEU    78      -8.659   2.316  -8.078  1.00 38.03           H 
ATOM   1251  HA  LEU    78      -6.188   3.737  -7.380  1.00  1.01           H 
ATOM   1252 1HB  LEU    78      -5.046   1.687  -8.161  1.00 42.52           H 
ATOM   1253 2HB  LEU    78      -6.601   1.001  -8.598  1.00 31.43           H 
ATOM   1254  HG  LEU    78      -7.281   1.027  -6.231  1.00 74.22           H 
ATOM   1255 1HD1 LEU    78      -4.619  -0.329  -6.676  1.00 55.42           H 
ATOM   1256 2HD1 LEU    78      -6.198  -0.970  -7.135  1.00 30.02           H 
ATOM   1257 3HD1 LEU    78      -5.801  -0.739  -5.432  1.00  2.23           H 
ATOM   1258 1HD2 LEU    78      -5.991   2.954  -5.487  1.00 32.14           H 
ATOM   1259 2HD2 LEU    78      -4.488   2.062  -5.724  1.00 33.34           H 
ATOM   1260 3HD2 LEU    78      -5.635   1.547  -4.486  1.00 72.01           H 
ATOM   1261  N   ILE    79      -5.368   4.417  -9.643  1.00 25.14           N 
ATOM   1262  CA  ILE    79      -4.958   4.942 -10.951  1.00 43.41           C 
ATOM   1263  C   ILE    79      -4.476   3.812 -11.886  1.00 73.05           C 
ATOM   1264  O   ILE    79      -5.153   3.457 -12.851  1.00 44.23           O 
ATOM   1265  CB  ILE    79      -3.839   6.008 -10.796  1.00 40.13           C 
ATOM   1266  CG1 ILE    79      -4.319   7.170  -9.905  1.00 12.55           C 
ATOM   1267  CG2 ILE    79      -3.382   6.525 -12.164  1.00 51.40           C 
ATOM   1268  CD1 ILE    79      -5.550   7.886 -10.433  1.00 75.21           C 
ATOM   1269  H   ILE    79      -4.882   4.704  -8.839  1.00 38.03           H 
ATOM   1270  HA  ILE    79      -5.819   5.420 -11.399  1.00 31.23           H 
ATOM   1271  HB  ILE    79      -2.991   5.531 -10.320  1.00 74.45           H 
ATOM   1272 1HG1 ILE    79      -3.526   7.899  -9.815  1.00 62.13           H 
ATOM   1273 2HG1 ILE    79      -4.560   6.787  -8.925  1.00 31.02           H 
ATOM   1274 1HG2 ILE    79      -2.995   5.703 -12.748  1.00 24.34           H 
ATOM   1275 2HG2 ILE    79      -2.605   7.264 -12.030  1.00 62.44           H 
ATOM   1276 3HG2 ILE    79      -4.218   6.971 -12.684  1.00 73.32           H 
ATOM   1277 1HD1 ILE    79      -5.834   8.667  -9.742  1.00 22.12           H 
ATOM   1278 2HD1 ILE    79      -6.362   7.181 -10.532  1.00 60.43           H 
ATOM   1279 3HD1 ILE    79      -5.329   8.321 -11.396  1.00 42.11           H 
ATOM   1280  N   ASN    80      -3.303   3.246 -11.589  1.00 21.31           N 
ATOM   1281  CA  ASN    80      -2.762   2.115 -12.362  1.00 64.23           C 
ATOM   1282  C   ASN    80      -2.489   0.894 -11.459  1.00  3.43           C 
ATOM   1283  O   ASN    80      -1.371   0.707 -10.976  1.00  4.41           O 
ATOM   1284  CB  ASN    80      -1.473   2.533 -13.090  1.00 22.30           C 
ATOM   1285  CG  ASN    80      -1.718   3.570 -14.171  1.00 21.15           C 
ATOM   1286  OD1 ASN    80      -2.761   3.576 -14.819  1.00 11.25           O 
ATOM   1287  ND2 ASN    80      -0.764   4.458 -14.373  1.00 35.24           N 
ATOM   1288  H   ASN    80      -2.786   3.599 -10.840  1.00 38.03           H 
ATOM   1289  HA  ASN    80      -3.502   1.834 -13.101  1.00 55.40           H 
ATOM   1290 1HB  ASN    80      -1.030   1.663 -13.553  1.00 70.33           H 
ATOM   1291 2HB  ASN    80      -0.777   2.945 -12.371  1.00 14.50           H 
ATOM   1292 1HD2 ASN    80       0.047   4.406 -13.823  1.00 11.45           H 
ATOM   1293 2HD2 ASN    80      -0.906   5.136 -15.063  1.00 65.41           H 
ATOM   1294  N   PRO    81      -3.527   0.078 -11.171  1.00 53.23           N 
ATOM   1295  CA  PRO    81      -3.382  -1.154 -10.376  1.00 53.25           C 
ATOM   1296  C   PRO    81      -2.892  -2.365 -11.198  1.00  1.13           C 
ATOM   1297  O   PRO    81      -3.416  -2.652 -12.278  1.00 73.44           O 
ATOM   1298  CB  PRO    81      -4.806  -1.391  -9.869  1.00 32.31           C 
ATOM   1299  CG  PRO    81      -5.685  -0.856 -10.954  1.00 61.55           C 
ATOM   1300  CD  PRO    81      -4.929   0.291 -11.593  1.00 34.01           C 
ATOM   1301  HA  PRO    81      -2.722  -1.003  -9.534  1.00  3.11           H 
ATOM   1302 1HB  PRO    81      -4.956  -0.857  -8.940  1.00 71.34           H 
ATOM   1303 2HB  PRO    81      -4.970  -2.450  -9.707  1.00 21.21           H 
ATOM   1304 1HG  PRO    81      -6.617  -0.503 -10.533  1.00 30.11           H 
ATOM   1305 2HG  PRO    81      -5.877  -1.629 -11.686  1.00 60.32           H 
ATOM   1306 1HD  PRO    81      -5.301   1.239 -11.228  1.00 22.54           H 
ATOM   1307 2HD  PRO    81      -5.015   0.247 -12.670  1.00 33.01           H 
ATOM   1308  N   ILE    82      -1.890  -3.078 -10.681  1.00 43.24           N 
ATOM   1309  CA  ILE    82      -1.396  -4.309 -11.319  1.00 41.02           C 
ATOM   1310  C   ILE    82      -1.141  -5.420 -10.281  1.00 32.45           C 
ATOM   1311  O   ILE    82      -0.425  -5.216  -9.301  1.00 34.22           O 
ATOM   1312  CB  ILE    82      -0.092  -4.064 -12.136  1.00 64.33           C 
ATOM   1313  CG1 ILE    82       1.019  -3.474 -11.247  1.00 43.23           C 
ATOM   1314  CG2 ILE    82      -0.370  -3.152 -13.332  1.00 21.32           C 
ATOM   1315  CD1 ILE    82       2.336  -3.259 -11.969  1.00 73.13           C 
ATOM   1316  H   ILE    82      -1.461  -2.768  -9.856  1.00 38.03           H 
ATOM   1317  HA  ILE    82      -2.161  -4.654 -12.007  1.00 32.21           H 
ATOM   1318  HB  ILE    82       0.240  -5.019 -12.523  1.00 22.44           H 
ATOM   1319 1HG1 ILE    82       1.203  -4.142 -10.416  1.00 71.41           H 
ATOM   1320 2HG1 ILE    82       0.698  -2.517 -10.865  1.00 34.35           H 
ATOM   1321 1HG2 ILE    82      -1.116  -3.607 -13.969  1.00 62.44           H 
ATOM   1322 2HG2 ILE    82       0.540  -3.004 -13.894  1.00 40.34           H 
ATOM   1323 3HG2 ILE    82      -0.735  -2.197 -12.980  1.00 32.53           H 
ATOM   1324 1HD1 ILE    82       2.189  -2.570 -12.787  1.00 55.44           H 
ATOM   1325 2HD1 ILE    82       2.694  -4.203 -12.352  1.00 30.45           H 
ATOM   1326 3HD1 ILE    82       3.062  -2.852 -11.281  1.00 74.40           H 
ATOM   1522  N   TRP    98      -3.272 -12.238  -1.997  1.00 52.11           N 
ATOM   1523  CA  TRP    98      -2.596 -11.809  -3.231  1.00 31.31           C 
ATOM   1524  C   TRP    98      -2.266 -10.302  -3.225  1.00 41.53           C 
ATOM   1525  O   TRP    98      -2.963  -9.494  -2.596  1.00 63.02           O 
ATOM   1526  CB  TRP    98      -3.422 -12.203  -4.470  1.00 24.41           C 
ATOM   1527  CG  TRP    98      -4.794 -11.582  -4.565  1.00  1.04           C 
ATOM   1528  CD1 TRP    98      -5.825 -11.680  -3.668  1.00 63.52           C 
ATOM   1529  CD2 TRP    98      -5.293 -10.800  -5.659  1.00 20.14           C 
ATOM   1530  NE1 TRP    98      -6.918 -10.987  -4.131  1.00 12.34           N 
ATOM   1531  CE2 TRP    98      -6.617 -10.441  -5.350  1.00 20.23           C 
ATOM   1532  CE3 TRP    98      -4.740 -10.358  -6.866  1.00 55.14           C 
ATOM   1533  CZ2 TRP    98      -7.397  -9.666  -6.204  1.00 50.04           C 
ATOM   1534  CZ3 TRP    98      -5.518  -9.593  -7.715  1.00 42.13           C 
ATOM   1535  CH2 TRP    98      -6.833  -9.253  -7.378  1.00  4.41           C 
ATOM   1536  H   TRP    98      -4.237 -12.123  -1.915  1.00 38.03           H 
ATOM   1537  HA  TRP    98      -1.656 -12.345  -3.273  1.00 23.20           H 
ATOM   1538 1HB  TRP    98      -3.547 -13.279  -4.472  1.00 44.21           H 
ATOM   1539 2HB  TRP    98      -2.874 -11.920  -5.355  1.00 10.30           H 
ATOM   1540  HD1 TRP    98      -5.773 -12.219  -2.734  1.00 74.05           H 
ATOM   1541  HE1 TRP    98      -7.776 -10.901  -3.668  1.00 53.32           H 
ATOM   1542  HE3 TRP    98      -3.725 -10.612  -7.143  1.00 44.14           H 
ATOM   1543  HZ2 TRP    98      -8.413  -9.395  -5.962  1.00 50.34           H 
ATOM   1544  HZ3 TRP    98      -5.110  -9.244  -8.652  1.00 40.34           H 
ATOM   1545  HH2 TRP    98      -7.404  -8.651  -8.071  1.00 41.45           H 
ATOM   1546  N   TYR    99      -1.190  -9.935  -3.933  1.00  2.54           N 
ATOM   1547  CA  TYR    99      -0.641  -8.572  -3.880  1.00 42.23           C 
ATOM   1548  C   TYR    99      -0.921  -7.778  -5.170  1.00 64.31           C 
ATOM   1549  O   TYR    99      -0.794  -8.292  -6.289  1.00 13.43           O 
ATOM   1550  CB  TYR    99       0.877  -8.622  -3.635  1.00 13.40           C 
ATOM   1551  CG  TYR    99       1.301  -9.557  -2.514  1.00 20.04           C 
ATOM   1552  CD1 TYR    99       1.410 -10.928  -2.732  1.00 14.32           C 
ATOM   1553  CD2 TYR    99       1.602  -9.074  -1.245  1.00  2.34           C 
ATOM   1554  CE1 TYR    99       1.805 -11.784  -1.725  1.00 51.01           C 
ATOM   1555  CE2 TYR    99       1.997  -9.928  -0.230  1.00 31.23           C 
ATOM   1556  CZ  TYR    99       2.096 -11.282  -0.476  1.00 65.03           C 
ATOM   1557  OH  TYR    99       2.502 -12.137   0.524  1.00 51.23           O 
ATOM   1558  H   TYR    99      -0.754 -10.594  -4.512  1.00 38.03           H 
ATOM   1559  HA  TYR    99      -1.107  -8.059  -3.049  1.00 12.12           H 
ATOM   1560 1HB  TYR    99       1.226  -7.627  -3.389  1.00 30.30           H 
ATOM   1561 2HB  TYR    99       1.370  -8.950  -4.540  1.00 63.42           H 
ATOM   1562  HD1 TYR    99       1.179 -11.323  -3.711  1.00 74.51           H 
ATOM   1563  HD2 TYR    99       1.524  -8.015  -1.055  1.00 23.33           H 
ATOM   1564  HE1 TYR    99       1.883 -12.845  -1.917  1.00 44.10           H 
ATOM   1565  HE2 TYR    99       2.224  -9.532   0.750  1.00 54.41           H 
ATOM   1566  HH  TYR    99       3.099 -12.804   0.150  1.00  2.41           H 
ATOM   1567  N   ILE   100      -1.292  -6.512  -4.996  1.00 53.54           N 
ATOM   1568  CA  ILE   100      -1.574  -5.603  -6.109  1.00  0.02           C 
ATOM   1569  C   ILE   100      -0.750  -4.310  -5.978  1.00 22.31           C 
ATOM   1570  O   ILE   100      -0.997  -3.486  -5.094  1.00 40.45           O 
ATOM   1571  CB  ILE   100      -3.082  -5.232  -6.161  1.00 71.22           C 
ATOM   1572  CG1 ILE   100      -3.957  -6.497  -6.166  1.00 71.54           C 
ATOM   1573  CG2 ILE   100      -3.388  -4.363  -7.382  1.00 33.23           C 
ATOM   1574  CD1 ILE   100      -5.445  -6.209  -6.151  1.00 33.02           C 
ATOM   1575  H   ILE   100      -1.375  -6.173  -4.083  1.00 38.03           H 
ATOM   1576  HA  ILE   100      -1.310  -6.101  -7.033  1.00 30.45           H 
ATOM   1577  HB  ILE   100      -3.313  -4.654  -5.278  1.00 12.22           H 
ATOM   1578 1HG1 ILE   100      -3.726  -7.091  -5.293  1.00  2.23           H 
ATOM   1579 2HG1 ILE   100      -3.744  -7.075  -7.053  1.00  3.54           H 
ATOM   1580 1HG2 ILE   100      -2.835  -3.436  -7.313  1.00 21.42           H 
ATOM   1581 2HG2 ILE   100      -4.448  -4.148  -7.416  1.00 60.35           H 
ATOM   1582 3HG2 ILE   100      -3.101  -4.886  -8.282  1.00  4.45           H 
ATOM   1583 1HD1 ILE   100      -5.719  -5.676  -7.050  1.00 42.11           H 
ATOM   1584 2HD1 ILE   100      -5.685  -5.606  -5.288  1.00 21.24           H 
ATOM   1585 3HD1 ILE   100      -5.989  -7.139  -6.101  1.00 24.33           H 
ATOM   1586  N   LYS   101       0.239  -4.139  -6.846  1.00 12.11           N 
ATOM   1587  CA  LYS   101       1.051  -2.918  -6.859  1.00 73.54           C 
ATOM   1588  C   LYS   101       0.338  -1.805  -7.648  1.00 12.02           C 
ATOM   1589  O   LYS   101      -0.107  -2.019  -8.774  1.00 32.32           O 
ATOM   1590  CB  LYS   101       2.437  -3.212  -7.457  1.00 61.50           C 
ATOM   1591  CG  LYS   101       3.256  -4.207  -6.631  1.00 73.44           C 
ATOM   1592  CD  LYS   101       4.543  -4.635  -7.339  1.00 21.22           C 
ATOM   1593  CE  LYS   101       5.499  -3.466  -7.569  1.00 64.11           C 
ATOM   1594  NZ  LYS   101       6.079  -2.944  -6.301  1.00  2.01           N 
ATOM   1595  H   LYS   101       0.427  -4.847  -7.500  1.00 38.03           H 
ATOM   1596  HA  LYS   101       1.176  -2.591  -5.832  1.00 41.33           H 
ATOM   1597 1HB  LYS   101       2.993  -2.288  -7.524  1.00  0.35           H 
ATOM   1598 2HB  LYS   101       2.308  -3.617  -8.452  1.00 23.23           H 
ATOM   1599 1HG  LYS   101       2.651  -5.085  -6.447  1.00 73.44           H 
ATOM   1600 2HG  LYS   101       3.514  -3.748  -5.688  1.00 72.03           H 
ATOM   1601 1HD  LYS   101       4.287  -5.072  -8.295  1.00 35.31           H 
ATOM   1602 2HD  LYS   101       5.043  -5.377  -6.732  1.00  5.24           H 
ATOM   1603 1HE  LYS   101       4.961  -2.669  -8.062  1.00 34.32           H 
ATOM   1604 2HE  LYS   101       6.305  -3.800  -8.205  1.00  3.21           H 
ATOM   1605 1HZ  LYS   101       6.652  -2.098  -6.493  1.00 63.31           H 
ATOM   1606 2HZ  LYS   101       6.690  -3.660  -5.858  1.00 45.02           H 
ATOM   1607 3HZ  LYS   101       5.325  -2.687  -5.631  1.00 31.44           H 
ATOM   1608  N   ALA   102       0.218  -0.624  -7.053  1.00 61.52           N 
ATOM   1609  CA  ALA   102      -0.539   0.473  -7.668  1.00  3.33           C 
ATOM   1610  C   ALA   102       0.318   1.727  -7.878  1.00  3.40           C 
ATOM   1611  O   ALA   102       1.429   1.836  -7.360  1.00 52.31           O 
ATOM   1612  CB  ALA   102      -1.755   0.806  -6.812  1.00 54.03           C 
ATOM   1613  H   ALA   102       0.648  -0.480  -6.183  1.00 38.03           H 
ATOM   1614  HA  ALA   102      -0.896   0.134  -8.632  1.00 11.12           H 
ATOM   1615 1HB  ALA   102      -1.429   1.159  -5.846  1.00 23.00           H 
ATOM   1616 2HB  ALA   102      -2.359  -0.081  -6.686  1.00 45.04           H 
ATOM   1617 3HB  ALA   102      -2.341   1.574  -7.296  1.00 54.13           H 
ATOM   1618  N   ASP   103      -0.212   2.666  -8.659  1.00 12.21           N 
ATOM   1619  CA  ASP   103       0.462   3.940  -8.912  1.00 64.42           C 
ATOM   1620  C   ASP   103       0.124   4.976  -7.823  1.00  0.21           C 
ATOM   1621  O   ASP   103       1.004   5.451  -7.108  1.00 15.41           O 
ATOM   1622  CB  ASP   103       0.057   4.465 -10.293  1.00 32.04           C 
ATOM   1623  CG  ASP   103       0.787   5.739 -10.671  1.00 53.14           C 
ATOM   1624  OD1 ASP   103       2.033   5.764 -10.573  1.00 54.02           O 
ATOM   1625  OD2 ASP   103       0.125   6.712 -11.077  1.00 11.52           O 
ATOM   1626  H   ASP   103      -1.070   2.491  -9.088  1.00 38.03           H 
ATOM   1627  HA  ASP   103       1.528   3.761  -8.905  1.00 11.53           H 
ATOM   1628 1HB  ASP   103      -1.007   4.660 -10.297  1.00 12.14           H 
ATOM   1629 2HB  ASP   103       0.280   3.712 -11.035  1.00 63.35           H 
ATOM   1630  N   ASP   104      -1.160   5.322  -7.715  1.00  3.13           N 
ATOM   1631  CA  ASP   104      -1.636   6.256  -6.692  1.00 71.02           C 
ATOM   1632  C   ASP   104      -3.047   5.875  -6.206  1.00  0.20           C 
ATOM   1633  O   ASP   104      -3.814   5.222  -6.921  1.00 51.02           O 
ATOM   1634  CB  ASP   104      -1.622   7.694  -7.233  1.00 11.24           C 
ATOM   1635  CG  ASP   104      -2.112   8.710  -6.210  1.00 23.30           C 
ATOM   1636  OD1 ASP   104      -1.689   8.633  -5.036  1.00 20.20           O 
ATOM   1637  OD2 ASP   104      -2.921   9.591  -6.571  1.00 12.23           O 
ATOM   1638  H   ASP   104      -1.803   4.945  -8.342  1.00 38.03           H 
ATOM   1639  HA  ASP   104      -0.958   6.195  -5.850  1.00 40.13           H 
ATOM   1640 1HB  ASP   104      -2.256   7.748  -8.108  1.00  4.52           H 
ATOM   1641 2HB  ASP   104      -0.611   7.954  -7.513  1.00 61.23           H 
ATOM   1642  N   ILE   105      -3.368   6.288  -4.980  1.00 32.15           N 
ATOM   1643  CA  ILE   105      -4.660   5.981  -4.350  1.00 41.35           C 
ATOM   1644  C   ILE   105      -5.524   7.247  -4.182  1.00 60.42           C 
ATOM   1645  O   ILE   105      -5.167   8.155  -3.429  1.00 60.12           O 
ATOM   1646  CB  ILE   105      -4.451   5.330  -2.955  1.00 43.41           C 
ATOM   1647  CG1 ILE   105      -3.690   3.997  -3.087  1.00 33.31           C 
ATOM   1648  CG2 ILE   105      -5.791   5.128  -2.243  1.00 10.35           C 
ATOM   1649  CD1 ILE   105      -3.415   3.310  -1.764  1.00  1.21           C 
ATOM   1650  H   ILE   105      -2.714   6.824  -4.485  1.00 38.03           H 
ATOM   1651  HA  ILE   105      -5.187   5.276  -4.981  1.00 62.24           H 
ATOM   1652  HB  ILE   105      -3.861   6.010  -2.356  1.00  0.50           H 
ATOM   1653 1HG1 ILE   105      -2.738   4.178  -3.568  1.00 32.53           H 
ATOM   1654 2HG1 ILE   105      -4.268   3.317  -3.694  1.00 13.25           H 
ATOM   1655 1HG2 ILE   105      -5.623   4.655  -1.286  1.00 22.05           H 
ATOM   1656 2HG2 ILE   105      -6.433   4.501  -2.845  1.00 64.15           H 
ATOM   1657 3HG2 ILE   105      -6.266   6.087  -2.088  1.00 74.44           H 
ATOM   1658 1HD1 ILE   105      -2.895   2.379  -1.944  1.00 25.33           H 
ATOM   1659 2HD1 ILE   105      -4.348   3.107  -1.259  1.00  0.54           H 
ATOM   1660 3HD1 ILE   105      -2.801   3.949  -1.145  1.00 11.23           H 
ATOM   1661  N   VAL   106      -6.659   7.297  -4.877  1.00 63.30           N 
ATOM   1662  CA  VAL   106      -7.599   8.426  -4.762  1.00 43.31           C 
ATOM   1663  C   VAL   106      -8.998   7.940  -4.353  1.00 22.13           C 
ATOM   1664  O   VAL   106      -9.250   6.741  -4.298  1.00 30.54           O 
ATOM   1665  CB  VAL   106      -7.700   9.217  -6.090  1.00  3.43           C 
ATOM   1666  CG1 VAL   106      -6.349   9.820  -6.469  1.00 65.25           C 
ATOM   1667  CG2 VAL   106      -8.233   8.327  -7.214  1.00 21.03           C 
ATOM   1668  H   VAL   106      -6.881   6.554  -5.483  1.00 38.03           H 
ATOM   1669  HA  VAL   106      -7.227   9.094  -3.995  1.00 32.31           H 
ATOM   1670  HB  VAL   106      -8.399  10.031  -5.945  1.00 14.53           H 
ATOM   1671 1HG1 VAL   106      -6.017  10.484  -5.683  1.00 65.21           H 
ATOM   1672 2HG1 VAL   106      -6.447  10.378  -7.391  1.00 22.24           H 
ATOM   1673 3HG1 VAL   106      -5.624   9.030  -6.603  1.00 61.32           H 
ATOM   1674 1HG2 VAL   106      -8.307   8.902  -8.125  1.00 33.22           H 
ATOM   1675 2HG2 VAL   106      -9.210   7.955  -6.946  1.00 22.33           H 
ATOM   1676 3HG2 VAL   106      -7.561   7.494  -7.367  1.00 33.51           H 
ATOM   1677  N   LEU   107      -9.903   8.871  -4.059  1.00  1.10           N 
ATOM   1678  CA  LEU   107     -11.288   8.516  -3.719  1.00  0.05           C 
ATOM   1679  C   LEU   107     -12.126   8.303  -4.988  1.00 30.30           C 
ATOM   1680  O   LEU   107     -11.865   8.920  -6.022  1.00 73.23           O 
ATOM   1681  CB  LEU   107     -11.928   9.606  -2.845  1.00 33.52           C 
ATOM   1682  CG  LEU   107     -11.286   9.800  -1.461  1.00 45.43           C 
ATOM   1683  CD1 LEU   107     -11.943  10.961  -0.718  1.00 74.32           C 
ATOM   1684  CD2 LEU   107     -11.378   8.519  -0.637  1.00  4.43           C 
ATOM   1685  H   LEU   107      -9.643   9.816  -4.076  1.00 38.03           H 
ATOM   1686  HA  LEU   107     -11.266   7.589  -3.161  1.00 54.51           H 
ATOM   1687 1HB  LEU   107     -12.971   9.360  -2.703  1.00 42.11           H 
ATOM   1688 2HB  LEU   107     -11.867  10.544  -3.380  1.00 43.34           H 
ATOM   1689  HG  LEU   107     -10.241  10.039  -1.591  1.00 13.41           H 
ATOM   1690 1HD1 LEU   107     -12.996  10.756  -0.584  1.00 14.53           H 
ATOM   1691 2HD1 LEU   107     -11.825  11.868  -1.292  1.00 54.44           H 
ATOM   1692 3HD1 LEU   107     -11.475  11.083   0.247  1.00 11.42           H 
ATOM   1693 1HD2 LEU   107     -12.417   8.256  -0.484  1.00 62.53           H 
ATOM   1694 2HD2 LEU   107     -10.902   8.672   0.320  1.00 11.32           H 
ATOM   1695 3HD2 LEU   107     -10.878   7.718  -1.160  1.00 25.04           H 
ATOM   1696  N   THR   108     -13.129   7.431  -4.899  1.00 51.23           N 
ATOM   1697  CA  THR   108     -13.996   7.125  -6.048  1.00  5.21           C 
ATOM   1698  C   THR   108     -14.769   8.370  -6.513  1.00 43.13           C 
ATOM   1699  O   THR   108     -15.734   8.790  -5.870  1.00 43.21           O 
ATOM   1700  CB  THR   108     -15.012   6.001  -5.716  1.00 21.32           C 
ATOM   1701  OG1 THR   108     -14.351   4.906  -5.062  1.00 45.23           O 
ATOM   1702  CG2 THR   108     -15.699   5.489  -6.981  1.00 75.40           C 
ATOM   1703  H   THR   108     -13.288   6.971  -4.047  1.00 38.03           H 
ATOM   1704  HA  THR   108     -13.365   6.783  -6.856  1.00 53.41           H 
ATOM   1705  HB  THR   108     -15.767   6.402  -5.055  1.00 41.42           H 
ATOM   1706  HG1 THR   108     -13.718   4.503  -5.665  1.00 55.30           H 
ATOM   1707 1HG2 THR   108     -16.392   4.702  -6.722  1.00 31.42           H 
ATOM   1708 2HG2 THR   108     -14.955   5.103  -7.665  1.00 33.42           H 
ATOM   1709 3HG2 THR   108     -16.235   6.300  -7.454  1.00 52.32           H 
END
