
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  206 ( 1672),  selected  206 , name 2cwa_A
# Molecule2: number of CA atoms   75 ( 1234),  selected   75 , name T0466.pdb
# PARAMETERS: 2cwa_A.T0466.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    L     5_A      -       -           -
LGA    N     6_A      -       -           -
LGA    R     7_A      -       -           -
LGA    V     8_A      -       -           -
LGA    F     9_A      -       -           -
LGA    L    10_A      -       -           -
LGA    I    11_A      -       -           -
LGA    G    12_A      L      19          0.389
LGA    A    13_A      K      20          0.497
LGA    L    14_A      F      21          1.530
LGA    A    15_A      S      22          2.650
LGA    T    16_A      A      23          2.700
LGA    R    17_A      L      24          3.820
LGA    P    18_A      R      25          4.209
LGA    D    19_A      R      26          2.735
LGA    X    20_A      E      27          2.481
LGA    R    21_A      V      28          3.804
LGA    Y    22_A      R      29          2.011
LGA    T    23_A      I      30          1.883
LGA    P    24_A      Q      31          3.170
LGA    A    25_A      N      32          5.886
LGA    -       -      E      33           -
LGA    -       -      D      34           -
LGA    -       -      G      35           -
LGA    -       -      S      36           -
LGA    -       -      V      37           -
LGA    -       -      S      38           -
LGA    -       -      D      39           -
LGA    G    26_A      E      40          2.738
LGA    L    27_A      I      41          3.475
LGA    A    28_A      K      42          3.120
LGA    I    29_A      E      43          1.826
LGA    L    30_A      R      44          0.843
LGA    D    31_A      T      45          0.490
LGA    L    32_A      Y      46          1.098
LGA    T    33_A      D      47          2.052
LGA    L    34_A      L      48          1.672
LGA    A    35_A      K      49          1.031
LGA    G    36_A      S      50          1.977
LGA    Q    37_A      K      51          1.427
LGA    D    38_A      -       -           -
LGA    L    39_A      -       -           -
LGA    L    40_A      -       -           -
LGA    R    48_A      -       -           -
LGA    E    49_A      -       -           -
LGA    V    50_A      G      52          2.892
LGA    S    51_A      Q      53          3.904
LGA    -       -      G      54           -
LGA    W    52_A      R      55          3.618
LGA    Y    53_A      M      56          2.146
LGA    H    54_A      I      57          1.370
LGA    R    55_A      Q      58          1.082
LGA    V    56_A      V      59          1.148
LGA    R    57_A      S      60          0.669
LGA    L    58_A      I      61          0.746
LGA    L    59_A      P      62          1.128
LGA    G    60_A      A      63          1.600
LGA    R    61_A      S      64          1.149
LGA    Q    62_A      V      65          1.171
LGA    A    63_A      -       -           -
LGA    E    64_A      -       -           -
LGA    X    65_A      P      66          0.940
LGA    W    66_A      L      67          1.381
LGA    G    67_A      -       -           -
LGA    D    68_A      K      68           #
LGA    L    69_A      E      69          1.593
LGA    L    70_A      F      70          3.176
LGA    D    71_A      D      71          4.143
LGA    Q    72_A      Y      72          3.123
LGA    G    73_A      N      73          1.952
LGA    Q    74_A      A      74          2.258
LGA    L    75_A      R      75          1.954
LGA    V    76_A      V      76          1.456
LGA    F    77_A      E      77          1.095
LGA    V    78_A      L      78          1.218
LGA    E    79_A      I      79          2.520
LGA    G    80_A      N      80          2.785
LGA    R    81_A      P      81          4.157
LGA    L    82_A      I      82          3.108
LGA    E    83_A      -       -           -
LGA    Y    84_A      -       -           -
LGA    R    85_A      -       -           -
LGA    Q    86_A      -       -           -
LGA    S    95_A      -       -           -
LGA    E    96_A      -       -           -
LGA    L    97_A      W      98           #
LGA    Q    98_A      Y      99          3.410
LGA    I    99_A      I     100          1.407
LGA    R   100_A      K     101          0.752
LGA    A   101_A      A     102          0.644
LGA    D   102_A      D     103          0.895
LGA    F   103_A      D     104          1.169
LGA    L   104_A      I     105          0.872
LGA    D   105_A      V     106          0.808
LGA    P   106_A      L     107          3.006
LGA    L   107_A      T     108          4.152
LGA    D   108_A      -       -           -
LGA    D   109_A      -       -           -
LGA    R   110_A      -       -           -
LGA    G   111_A      -       -           -
LGA    K   112_A      -       -           -
LGA    E   113_A      -       -           -
LGA    R   114_A      -       -           -
LGA    A   115_A      -       -           -
LGA    E   116_A      -       -           -
LGA    D   117_A      -       -           -
LGA    S   118_A      -       -           -
LGA    R   119_A      -       -           -
LGA    G   120_A      -       -           -
LGA    Q   121_A      -       -           -
LGA    P   122_A      -       -           -
LGA    R   123_A      -       -           -
LGA    L   124_A      -       -           -
LGA    R   125_A      -       -           -
LGA    A   126_A      -       -           -
LGA    A   127_A      -       -           -
LGA    L   128_A      -       -           -
LGA    N   129_A      -       -           -
LGA    Q   130_A      -       -           -
LGA    V   131_A      -       -           -
LGA    F   132_A      -       -           -
LGA    L   133_A      -       -           -
LGA    X   134_A      -       -           -
LGA    G   135_A      -       -           -
LGA    N   136_A      -       -           -
LGA    L   137_A      -       -           -
LGA    T   138_A      -       -           -
LGA    R   139_A      -       -           -
LGA    D   140_A      -       -           -
LGA    P   141_A      -       -           -
LGA    E   142_A      -       -           -
LGA    L   143_A      -       -           -
LGA    R   144_A      -       -           -
LGA    Y   145_A      -       -           -
LGA    T   146_A      -       -           -
LGA    P   147_A      -       -           -
LGA    Q   148_A      -       -           -
LGA    G   149_A      -       -           -
LGA    T   150_A      -       -           -
LGA    A   151_A      -       -           -
LGA    V   152_A      -       -           -
LGA    A   153_A      -       -           -
LGA    R   154_A      -       -           -
LGA    L   155_A      -       -           -
LGA    G   156_A      -       -           -
LGA    L   157_A      -       -           -
LGA    A   158_A      -       -           -
LGA    V   159_A      -       -           -
LGA    N   160_A      -       -           -
LGA    E   161_A      -       -           -
LGA    R   162_A      -       -           -
LGA    E   168_A      -       -           -
LGA    R   169_A      -       -           -
LGA    T   170_A      -       -           -
LGA    H   171_A      -       -           -
LGA    F   172_A      -       -           -
LGA    V   173_A      -       -           -
LGA    E   174_A      -       -           -
LGA    V   175_A      -       -           -
LGA    Q   176_A      -       -           -
LGA    A   177_A      -       -           -
LGA    W   178_A      -       -           -
LGA    R   179_A      -       -           -
LGA    D   180_A      -       -           -
LGA    L   181_A      -       -           -
LGA    A   182_A      -       -           -
LGA    E   183_A      -       -           -
LGA    W   184_A      -       -           -
LGA    A   185_A      -       -           -
LGA    A   186_A      -       -           -
LGA    E   187_A      -       -           -
LGA    L   188_A      -       -           -
LGA    R   189_A      -       -           -
LGA    K   190_A      -       -           -
LGA    G   191_A      -       -           -
LGA    D   192_A      -       -           -
LGA    G   193_A      -       -           -
LGA    L   194_A      -       -           -
LGA    F   195_A      -       -           -
LGA    V   196_A      -       -           -
LGA    I   197_A      -       -           -
LGA    G   198_A      -       -           -
LGA    R   199_A      -       -           -
LGA    L   200_A      -       -           -
LGA    V   201_A      -       -           -
LGA    N   202_A      -       -           -
LGA    D   203_A      -       -           -
LGA    S   204_A      -       -           -
LGA    W   205_A      -       -           -
LGA    T   206_A      -       -           -
LGA    S   207_A      -       -           -
LGA    S   208_A      -       -           -
LGA    S   209_A      -       -           -
LGA    G   210_A      -       -           -
LGA    E   211_A      -       -           -
LGA    R   212_A      -       -           -
LGA    R   213_A      -       -           -
LGA    F   214_A      -       -           -
LGA    Q   215_A      -       -           -
LGA    T   216_A      -       -           -
LGA    R   217_A      -       -           -
LGA    V   218_A      -       -           -
LGA    E   219_A      -       -           -
LGA    A   220_A      -       -           -
LGA    L   221_A      -       -           -
LGA    R   222_A      -       -           -
LGA    L   223_A      -       -           -
LGA    E   224_A      -       -           -
LGA    R   225_A      -       -           -
LGA    P   226_A      -       -           -
LGA    T   227_A      -       -           -
LGA    R   228_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  206   75    5.0     65    2.41    10.77     60.976     2.591

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.640988 * X  +  -0.727579 * Y  +  -0.244468 * Z  +  13.823352
  Y_new =   0.612428 * X  +   0.292817 * Y  +   0.734295 * Z  + -30.496141
  Z_new =  -0.462673 * X  +  -0.620393 * Y  +   0.633282 * Z  +   9.362060 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.775117    2.366475  [ DEG:   -44.4110    135.5890 ]
  Theta =   0.481008    2.660585  [ DEG:    27.5597    152.4403 ]
  Phi   =   0.762617   -2.378975  [ DEG:    43.6947   -136.3053 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cwa_A                                        
REMARK     2: T0466.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cwa_A.T0466.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  206   75   5.0   65   2.41   10.77  60.976
REMARK  ---------------------------------------------------------- 
MOLECULE 2cwa_A
HEADER    DNA BINDING PROTEIN                     17-JUN-05   2CWA              
TITLE     CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA BINDING                  
TITLE    2 PROTEIN FROM THERMUS THERMOPHILUS HB8                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: SSB, HELIX-DESTABILIZING PROTEIN, SINGLE-STRANDED           
COMPND   5 DNA BINDING PROTEIN;                                                 
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: B834(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    SSB, SINGLE-STRANDED DNA BINDING PROTEIN, THERMUS                     
KEYWDS   2 THERMOPHILUS HB8, STRUCTURAL GENOMICS, RIKEN STRUCTURAL              
KEYWDS   3 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.SATOH,S.YOKOYAMA,S.KURAMITSU,RIKEN STRUCTURAL                       
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   17-DEC-05 2CWA    0                                                
JRNL        AUTH   S.SATOH,S.YOKOYAMA,S.KURAMITSU                               
JRNL        TITL   CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA                 
JRNL        TITL 2 BINDING PROTEIN FROM THERMUS THERMOPHILUS HB8                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.96 ANGSTROMS.                                          
DBREF  2CWA A    1   263  UNP    Q5SLP9   SSB_THET8        1    263             
SEQRES   1 A  263  MSE ALA ARG GLY LEU ASN ARG VAL PHE LEU ILE GLY ALA          
SEQRES   2 A  263  LEU ALA THR ARG PRO ASP MSE ARG TYR THR PRO ALA GLY          
SEQRES   3 A  263  LEU ALA ILE LEU ASP LEU THR LEU ALA GLY GLN ASP LEU          
SEQRES   4 A  263  LEU LEU SER ASP ASN GLY GLY GLU ARG GLU VAL SER TRP          
SEQRES   5 A  263  TYR HIS ARG VAL ARG LEU LEU GLY ARG GLN ALA GLU MSE          
SEQRES   6 A  263  TRP GLY ASP LEU LEU ASP GLN GLY GLN LEU VAL PHE VAL          
SEQRES   7 A  263  GLU GLY ARG LEU GLU TYR ARG GLN TRP GLU ARG GLU GLY          
SEQRES   8 A  263  GLU ARG ARG SER GLU LEU GLN ILE ARG ALA ASP PHE LEU          
SEQRES   9 A  263  ASP PRO LEU ASP ASP ARG GLY LYS GLU ARG ALA GLU ASP          
SEQRES  10 A  263  SER ARG GLY GLN PRO ARG LEU ARG ALA ALA LEU ASN GLN          
SEQRES  11 A  263  VAL PHE LEU MSE GLY ASN LEU THR ARG ASP PRO GLU LEU          
SEQRES  12 A  263  ARG TYR THR PRO GLN GLY THR ALA VAL ALA ARG LEU GLY          
SEQRES  13 A  263  LEU ALA VAL ASN GLU ARG ARG GLN GLY ALA GLU GLU ARG          
SEQRES  14 A  263  THR HIS PHE VAL GLU VAL GLN ALA TRP ARG ASP LEU ALA          
SEQRES  15 A  263  GLU TRP ALA ALA GLU LEU ARG LYS GLY ASP GLY LEU PHE          
SEQRES  16 A  263  VAL ILE GLY ARG LEU VAL ASN ASP SER TRP THR SER SER          
SEQRES  17 A  263  SER GLY GLU ARG ARG PHE GLN THR ARG VAL GLU ALA LEU          
SEQRES  18 A  263  ARG LEU GLU ARG PRO THR ARG GLY PRO ALA GLN ALA GLY          
SEQRES  19 A  263  GLY SER ARG SER ARG GLU VAL GLN THR GLY GLY VAL ASP          
SEQRES  20 A  263  ILE ASP GLU GLY LEU GLU ASP PHE PRO PRO GLU GLU GLU          
SEQRES  21 A  263  LEU PRO PHE                                                  
HET    MSE  A  20       8                                                       
HET    MSE  A  65       8                                                       
HET    MSE  A 134       8                                                       
HET    NO3    501       4                                                       
HET    NO3    502       4                                                       
HET    NO3    503       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     NO3 NITRATE ION                                                      
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2  NO3    3(N O3 1-)                                                   
FORMUL   5  HOH   *144(H2 O)                                                    
CRYST1   91.560   91.560  132.580  90.00  90.00 120.00 P 65 2 2     12          
ATOM      1  N   ARG A   3       1.438  -7.749 -28.089  1.00 32.45           N  
ATOM      2  CA  ARG A   3       1.746  -6.440 -27.441  1.00 31.55           C  
ATOM      3  C   ARG A   3       1.351  -6.470 -25.964  1.00 32.05           C  
ATOM      4  O   ARG A   3       0.256  -6.904 -25.618  1.00 32.15           O  
ATOM      5  CB  ARG A   3       0.987  -5.321 -28.148  1.00 35.75           C  
ATOM      6  CG  ARG A   3       1.202  -3.969 -27.528  1.00 37.92           C  
ATOM      7  CD  ARG A   3       0.007  -3.070 -27.758  1.00 42.14           C  
ATOM      8  NE  ARG A   3       0.001  -2.031 -26.743  1.00 47.32           N  
ATOM      9  CZ  ARG A   3      -1.079  -1.391 -26.322  1.00 45.47           C  
ATOM     10  NH1 ARG A   3      -0.952  -0.466 -25.387  1.00 48.67           N  
ATOM     11  NH2 ARG A   3      -2.272  -1.670 -26.828  1.00 43.81           N  
ATOM     12  N   GLY A   4       2.237  -5.987 -25.100  1.00 29.59           N  
ATOM     13  CA  GLY A   4       1.957  -5.997 -23.676  1.00 30.96           C  
ATOM     14  C   GLY A   4       1.005  -4.938 -23.153  1.00 29.94           C  
ATOM     15  O   GLY A   4       1.119  -3.759 -23.478  1.00 32.18           O  
ATOM     16  N   LEU A   5       0.048  -5.374 -22.340  1.00 25.93           N  
ATOM     17  CA  LEU A   5      -0.924  -4.485 -21.714  1.00 22.84           C  
ATOM     18  C   LEU A   5      -1.110  -5.049 -20.304  1.00 22.97           C  
ATOM     19  O   LEU A   5      -1.282  -6.254 -20.140  1.00 21.71           O  
ATOM     20  CB  LEU A   5      -2.250  -4.506 -22.477  1.00 21.42           C  
ATOM     21  CG  LEU A   5      -3.379  -3.646 -21.898  1.00 21.07           C  
ATOM     22  CD1 LEU A   5      -2.960  -2.182 -21.815  1.00 24.52           C  
ATOM     23  CD2 LEU A   5      -4.615  -3.801 -22.786  1.00 21.22           C  
ATOM     24  N   ASN A   6      -1.090  -4.182 -19.299  1.00 22.45           N  
ATOM     25  CA  ASN A   6      -1.192  -4.625 -17.906  1.00 24.33           C  
ATOM     26  C   ASN A   6      -1.684  -3.453 -17.063  1.00 24.29           C  
ATOM     27  O   ASN A   6      -0.888  -2.711 -16.498  1.00 25.91           O  
ATOM     28  CB  ASN A   6       0.210  -5.098 -17.468  1.00 24.32           C  
ATOM     29  CG  ASN A   6       0.282  -5.562 -16.013  1.00 26.60           C  
ATOM     30  OD1 ASN A   6      -0.720  -5.643 -15.299  1.00 21.08           O  
ATOM     31  ND2 ASN A   6       1.497  -5.877 -15.574  1.00 25.02           N  
ATOM     32  N   ARG A   7      -3.003  -3.274 -16.989  1.00 20.27           N  
ATOM     33  CA  ARG A   7      -3.562  -2.165 -16.226  1.00 19.23           C  
ATOM     34  C   ARG A   7      -4.640  -2.630 -15.251  1.00 22.80           C  
ATOM     35  O   ARG A   7      -5.573  -3.334 -15.635  1.00 22.81           O  
ATOM     36  CB  ARG A   7      -4.132  -1.105 -17.181  1.00 20.82           C  
ATOM     37  CG  ARG A   7      -3.081  -0.536 -18.156  1.00 20.82           C  
ATOM     38  CD  ARG A   7      -3.637   0.598 -19.020  1.00 23.24           C  
ATOM     39  NE  ARG A   7      -2.613   1.161 -19.904  1.00 26.53           N  
ATOM     40  CZ  ARG A   7      -1.577   1.886 -19.486  1.00 30.67           C  
ATOM     41  NH1 ARG A   7      -1.419   2.148 -18.191  1.00 24.34           N  
ATOM     42  NH2 ARG A   7      -0.701   2.357 -20.362  1.00 31.14           N  
ATOM     43  N   VAL A   8      -4.494  -2.222 -13.993  1.00 20.81           N  
ATOM     44  CA  VAL A   8      -5.424  -2.594 -12.929  1.00 22.62           C  
ATOM     45  C   VAL A   8      -6.182  -1.394 -12.390  1.00 20.35           C  
ATOM     46  O   VAL A   8      -5.585  -0.353 -12.099  1.00 19.97           O  
ATOM     47  CB  VAL A   8      -4.674  -3.256 -11.743  1.00 21.51           C  
ATOM     48  CG1 VAL A   8      -5.634  -3.457 -10.560  1.00 22.75           C  
ATOM     49  CG2 VAL A   8      -4.068  -4.580 -12.186  1.00 19.52           C  
ATOM     50  N   PHE A   9      -7.502  -1.541 -12.262  1.00 16.52           N  
ATOM     51  CA  PHE A   9      -8.346  -0.474 -11.741  1.00 14.42           C  
ATOM     52  C   PHE A   9      -9.191  -1.036 -10.602  1.00 19.10           C  
ATOM     53  O   PHE A   9     -10.026  -1.923 -10.812  1.00 20.13           O  
ATOM     54  CB  PHE A   9      -9.268   0.070 -12.834  1.00 20.09           C  
ATOM     55  CG  PHE A   9      -8.536   0.682 -13.995  1.00 21.46           C  
ATOM     56  CD1 PHE A   9      -7.978   1.957 -13.891  1.00 25.79           C  
ATOM     57  CD2 PHE A   9      -8.393  -0.014 -15.185  1.00 22.11           C  
ATOM     58  CE1 PHE A   9      -7.284   2.525 -14.977  1.00 23.37           C  
ATOM     59  CE2 PHE A   9      -7.705   0.543 -16.272  1.00 22.59           C  
ATOM     60  CZ  PHE A   9      -7.152   1.813 -16.162  1.00 18.39           C  
ATOM     61  N   LEU A  10      -8.978  -0.511  -9.405  1.00 18.44           N  
ATOM     62  CA  LEU A  10      -9.706  -0.976  -8.234  1.00 19.50           C  
ATOM     63  C   LEU A  10     -10.276   0.152  -7.409  1.00 19.15           C  
ATOM     64  O   LEU A  10      -9.646   1.202  -7.228  1.00 18.77           O  
ATOM     65  CB  LEU A  10      -8.783  -1.806  -7.326  1.00 17.98           C  
ATOM     66  CG  LEU A  10      -8.243  -3.133  -7.852  1.00 19.40           C  
ATOM     67  CD1 LEU A  10      -7.042  -3.564  -7.004  1.00 20.39           C  
ATOM     68  CD2 LEU A  10      -9.356  -4.189  -7.807  1.00 22.44           C  
ATOM     69  N   ILE A  11     -11.491  -0.071  -6.919  1.00 18.51           N  
ATOM     70  CA  ILE A  11     -12.150   0.864  -6.029  1.00 19.91           C  
ATOM     71  C   ILE A  11     -12.768  -0.003  -4.935  1.00 22.00           C  
ATOM     72  O   ILE A  11     -13.573  -0.902  -5.217  1.00 21.26           O  
ATOM     73  CB  ILE A  11     -13.277   1.676  -6.702  1.00 20.32           C  
ATOM     74  CG1 ILE A  11     -12.705   2.606  -7.781  1.00 19.34           C  
ATOM     75  CG2 ILE A  11     -13.979   2.518  -5.639  1.00 19.43           C  
ATOM     76  CD1 ILE A  11     -13.766   3.490  -8.448  1.00 17.58           C  
ATOM     77  N   GLY A  12     -12.368   0.254  -3.697  1.00 22.47           N  
ATOM     78  CA  GLY A  12     -12.879  -0.508  -2.571  1.00 24.36           C  
ATOM     79  C   GLY A  12     -12.609   0.225  -1.276  1.00 22.58           C  
ATOM     80  O   GLY A  12     -12.095   1.343  -1.283  1.00 22.03           O  
ATOM     81  N   ALA A  13     -12.961  -0.401  -0.161  1.00 21.40           N  
ATOM     82  CA  ALA A  13     -12.746   0.199   1.146  1.00 22.10           C  
ATOM     83  C   ALA A  13     -11.507  -0.427   1.769  1.00 20.46           C  
ATOM     84  O   ALA A  13     -11.200  -1.580   1.510  1.00 21.60           O  
ATOM     85  CB  ALA A  13     -13.965  -0.050   2.040  1.00 23.54           C  
ATOM     86  N   LEU A  14     -10.782   0.337   2.577  1.00 21.62           N  
ATOM     87  CA  LEU A  14      -9.602  -0.217   3.228  1.00 22.52           C  
ATOM     88  C   LEU A  14     -10.103  -1.141   4.332  1.00 21.14           C  
ATOM     89  O   LEU A  14     -10.763  -0.687   5.268  1.00 23.43           O  
ATOM     90  CB  LEU A  14      -8.746   0.893   3.829  1.00 19.52           C  
ATOM     91  CG  LEU A  14      -8.133   1.853   2.805  1.00 20.90           C  
ATOM     92  CD1 LEU A  14      -7.227   2.833   3.521  1.00 22.97           C  
ATOM     93  CD2 LEU A  14      -7.363   1.060   1.762  1.00 21.24           C  
ATOM     94  N   ALA A  15      -9.804  -2.428   4.203  1.00 22.94           N  
ATOM     95  CA  ALA A  15     -10.239  -3.429   5.176  1.00 27.32           C  
ATOM     96  C   ALA A  15      -9.665  -3.181   6.567  1.00 31.61           C  
ATOM     97  O   ALA A  15     -10.313  -3.468   7.581  1.00 28.09           O  
ATOM     98  CB  ALA A  15      -9.853  -4.815   4.692  1.00 26.91           C  
ATOM     99  N   THR A  16      -8.447  -2.648   6.604  1.00 30.88           N  
ATOM    100  CA  THR A  16      -7.758  -2.342   7.853  1.00 33.40           C  
ATOM    101  C   THR A  16      -6.874  -1.121   7.640  1.00 35.51           C  
ATOM    102  O   THR A  16      -6.631  -0.711   6.503  1.00 31.49           O  
ATOM    103  CB  THR A  16      -6.838  -3.492   8.290  1.00 34.25           C  
ATOM    104  OG1 THR A  16      -5.875  -3.745   7.259  1.00 33.41           O  
ATOM    105  CG2 THR A  16      -7.640  -4.755   8.554  1.00 34.80           C  
ATOM    106  N   ARG A  17      -6.398  -0.539   8.734  1.00 35.88           N  
ATOM    107  CA  ARG A  17      -5.514   0.612   8.636  1.00 40.12           C  
ATOM    108  C   ARG A  17      -4.259   0.101   7.921  1.00 38.17           C  
ATOM    109  O   ARG A  17      -3.729  -0.955   8.262  1.00 38.65           O  
ATOM    110  CB  ARG A  17      -5.173   1.139  10.034  1.00 43.18           C  
ATOM    111  CG  ARG A  17      -4.531   2.518  10.034  1.00 49.02           C  
ATOM    112  CD  ARG A  17      -4.434   3.086  11.445  1.00 54.01           C  
ATOM    113  NE  ARG A  17      -3.859   4.429  11.448  1.00 60.76           N  
ATOM    114  CZ  ARG A  17      -4.412   5.480  10.851  1.00 63.55           C  
ATOM    115  NH1 ARG A  17      -5.561   5.346  10.204  1.00 64.87           N  
ATOM    116  NH2 ARG A  17      -3.813   6.664  10.891  1.00 66.44           N  
ATOM    117  N   PRO A  18      -3.778   0.841   6.911  1.00 35.96           N  
ATOM    118  CA  PRO A  18      -2.588   0.462   6.137  1.00 35.72           C  
ATOM    119  C   PRO A  18      -1.282   0.358   6.925  1.00 37.20           C  
ATOM    120  O   PRO A  18      -1.088   1.052   7.924  1.00 36.40           O  
ATOM    121  CB  PRO A  18      -2.536   1.533   5.051  1.00 35.41           C  
ATOM    122  CG  PRO A  18      -3.074   2.732   5.754  1.00 36.95           C  
ATOM    123  CD  PRO A  18      -4.269   2.163   6.495  1.00 35.80           C  
ATOM    124  N   ASP A  19      -0.391  -0.512   6.457  1.00 39.60           N  
ATOM    125  CA  ASP A  19       0.900  -0.729   7.104  1.00 40.59           C  
ATOM    126  C   ASP A  19       2.036  -0.056   6.327  1.00 38.13           C  
ATOM    127  O   ASP A  19       2.386  -0.490   5.228  1.00 39.37           O  
ATOM    128  CB  ASP A  19       1.174  -2.233   7.222  1.00 42.58           C  
ATOM    129  CG  ASP A  19       0.067  -2.973   7.962  1.00 48.69           C  
ATOM    130  OD1 ASP A  19      -0.220  -2.612   9.125  1.00 47.09           O  
ATOM    131  OD2 ASP A  19      -0.515  -3.913   7.377  1.00 49.98           O  
HETATM  132  N   MSE A  20       2.605   0.999   6.903  1.00 35.45           N  
HETATM  133  CA  MSE A  20       3.696   1.736   6.255  1.00 38.13           C  
HETATM  134  C   MSE A  20       5.067   1.395   6.832  1.00 37.26           C  
HETATM  135  O   MSE A  20       5.234   1.285   8.048  1.00 34.95           O  
HETATM  136  CB  MSE A  20       3.470   3.245   6.389  1.00 38.89           C  
HETATM  137  CG  MSE A  20       4.638   4.111   5.910  1.00 41.50           C  
HETATM  138 SE   MSE A  20       4.736   4.362   3.978  1.00 46.71          SE  
HETATM  139  CE  MSE A  20       3.960   6.110   3.900  1.00 36.71           C  
ATOM    140  N   ARG A  21       6.046   1.234   5.949  1.00 35.39           N  
ATOM    141  CA  ARG A  21       7.410   0.935   6.364  1.00 36.51           C  
ATOM    142  C   ARG A  21       8.395   1.491   5.349  1.00 35.21           C  
ATOM    143  O   ARG A  21       8.004   1.895   4.252  1.00 31.72           O  
ATOM    144  CB  ARG A  21       7.616  -0.572   6.526  1.00 36.44           C  
ATOM    145  CG  ARG A  21       7.047  -1.414   5.411  1.00 42.89           C  
ATOM    146  CD  ARG A  21       7.248  -2.890   5.707  1.00 43.63           C  
ATOM    147  NE  ARG A  21       8.587  -3.332   5.342  1.00 48.05           N  
ATOM    148  CZ  ARG A  21       8.882  -3.931   4.194  1.00 49.12           C  
ATOM    149  NH1 ARG A  21       7.925  -4.165   3.306  1.00 51.79           N  
ATOM    150  NH2 ARG A  21      10.132  -4.286   3.929  1.00 49.61           N  
ATOM    151  N   TYR A  22       9.668   1.505   5.731  1.00 32.15           N  
ATOM    152  CA  TYR A  22      10.747   2.018   4.891  1.00 28.39           C  
ATOM    153  C   TYR A  22      11.899   1.032   4.823  1.00 29.56           C  
ATOM    154  O   TYR A  22      12.239   0.409   5.827  1.00 30.99           O  
ATOM    155  CB  TYR A  22      11.282   3.322   5.478  1.00 26.59           C  
ATOM    156  CG  TYR A  22      10.404   4.526   5.271  1.00 26.10           C  
ATOM    157  CD1 TYR A  22      10.567   5.339   4.152  1.00 27.43           C  
ATOM    158  CD2 TYR A  22       9.419   4.867   6.198  1.00 25.83           C  
ATOM    159  CE1 TYR A  22       9.779   6.462   3.961  1.00 26.90           C  
ATOM    160  CE2 TYR A  22       8.620   5.990   6.015  1.00 26.59           C  
ATOM    161  CZ  TYR A  22       8.810   6.784   4.892  1.00 25.14           C  
ATOM    162  OH  TYR A  22       8.034   7.898   4.699  1.00 30.52           O  
ATOM    163  N   THR A  23      12.499   0.891   3.644  1.00 27.40           N  
ATOM    164  CA  THR A  23      13.651   0.012   3.493  1.00 26.29           C  
ATOM    165  C   THR A  23      14.815   0.782   4.123  1.00 24.78           C  
ATOM    166  O   THR A  23      14.686   1.969   4.438  1.00 22.45           O  
ATOM    167  CB  THR A  23      13.982  -0.256   2.009  1.00 27.89           C  
ATOM    168  OG1 THR A  23      14.383   0.969   1.384  1.00 24.33           O  
ATOM    169  CG2 THR A  23      12.764  -0.827   1.277  1.00 30.10           C  
ATOM    170  N   PRO A  24      15.957   0.117   4.341  1.00 25.89           N  
ATOM    171  CA  PRO A  24      17.065   0.867   4.943  1.00 26.71           C  
ATOM    172  C   PRO A  24      17.496   2.035   4.055  1.00 24.20           C  
ATOM    173  O   PRO A  24      17.943   3.069   4.550  1.00 27.53           O  
ATOM    174  CB  PRO A  24      18.151  -0.195   5.096  1.00 25.86           C  
ATOM    175  CG  PRO A  24      17.348  -1.435   5.378  1.00 26.40           C  
ATOM    176  CD  PRO A  24      16.243  -1.328   4.337  1.00 26.60           C  
ATOM    177  N   ALA A  25      17.340   1.869   2.745  1.00 27.37           N  
ATOM    178  CA  ALA A  25      17.712   2.908   1.787  1.00 27.72           C  
ATOM    179  C   ALA A  25      16.669   4.031   1.670  1.00 26.73           C  
ATOM    180  O   ALA A  25      16.794   4.919   0.821  1.00 23.96           O  
ATOM    181  CB  ALA A  25      17.973   2.286   0.421  1.00 29.22           C  
ATOM    182  N   GLY A  26      15.640   3.988   2.513  1.00 23.78           N  
ATOM    183  CA  GLY A  26      14.637   5.044   2.493  1.00 23.33           C  
ATOM    184  C   GLY A  26      13.478   4.945   1.512  1.00 24.61           C  
ATOM    185  O   GLY A  26      12.812   5.947   1.246  1.00 23.51           O  
ATOM    186  N   LEU A  27      13.233   3.759   0.966  1.00 25.10           N  
ATOM    187  CA  LEU A  27      12.116   3.588   0.039  1.00 25.09           C  
ATOM    188  C   LEU A  27      10.856   3.295   0.846  1.00 26.87           C  
ATOM    189  O   LEU A  27      10.798   2.307   1.587  1.00 25.84           O  
ATOM    190  CB  LEU A  27      12.375   2.430  -0.925  1.00 23.71           C  
ATOM    191  CG  LEU A  27      11.236   2.134  -1.916  1.00 23.90           C  
ATOM    192  CD1 LEU A  27      11.046   3.305  -2.879  1.00 26.39           C  
ATOM    193  CD2 LEU A  27      11.559   0.870  -2.683  1.00 28.31           C  
ATOM    194  N   ALA A  28       9.859   4.162   0.701  1.00 24.53           N  
ATOM    195  CA  ALA A  28       8.593   4.009   1.401  1.00 24.77           C  
ATOM    196  C   ALA A  28       7.784   2.878   0.783  1.00 27.03           C  
ATOM    197  O   ALA A  28       7.669   2.771  -0.443  1.00 24.61           O  
ATOM    198  CB  ALA A  28       7.801   5.311   1.344  1.00 26.18           C  
ATOM    199  N   ILE A  29       7.234   2.023   1.640  1.00 25.29           N  
ATOM    200  CA  ILE A  29       6.424   0.903   1.183  1.00 25.80           C  
ATOM    201  C   ILE A  29       5.115   0.945   1.958  1.00 28.91           C  
ATOM    202  O   ILE A  29       5.111   0.851   3.186  1.00 24.59           O  
ATOM    203  CB  ILE A  29       7.120  -0.450   1.440  1.00 27.76           C  
ATOM    204  CG1 ILE A  29       8.464  -0.489   0.710  1.00 26.28           C  
ATOM    205  CG2 ILE A  29       6.225  -1.601   0.969  1.00 26.43           C  
ATOM    206  CD1 ILE A  29       9.266  -1.751   0.957  1.00 28.26           C  
ATOM    207  N   LEU A  30       4.009   1.119   1.242  1.00 26.72           N  
ATOM    208  CA  LEU A  30       2.705   1.171   1.880  1.00 26.75           C  
ATOM    209  C   LEU A  30       1.841   0.032   1.371  1.00 28.92           C  
ATOM    210  O   LEU A  30       1.418   0.031   0.212  1.00 27.96           O  
ATOM    211  CB  LEU A  30       2.017   2.506   1.597  1.00 27.76           C  
ATOM    212  CG  LEU A  30       0.663   2.727   2.286  1.00 28.83           C  
ATOM    213  CD1 LEU A  30       0.811   2.559   3.789  1.00 30.81           C  
ATOM    214  CD2 LEU A  30       0.144   4.114   1.961  1.00 29.55           C  
ATOM    215  N   ASP A  31       1.600  -0.952   2.230  1.00 28.27           N  
ATOM    216  CA  ASP A  31       0.768  -2.082   1.854  1.00 28.13           C  
ATOM    217  C   ASP A  31      -0.641  -1.821   2.356  1.00 29.07           C  
ATOM    218  O   ASP A  31      -0.845  -1.479   3.524  1.00 25.05           O  
ATOM    219  CB  ASP A  31       1.312  -3.384   2.445  1.00 33.30           C  
ATOM    220  CG  ASP A  31       2.568  -3.860   1.742  1.00 35.96           C  
ATOM    221  OD1 ASP A  31       2.614  -3.783   0.493  1.00 34.31           O  
ATOM    222  OD2 ASP A  31       3.504  -4.323   2.430  1.00 37.33           O  
ATOM    223  N   LEU A  32      -1.608  -1.961   1.456  1.00 27.43           N  
ATOM    224  CA  LEU A  32      -3.005  -1.731   1.791  1.00 28.97           C  
ATOM    225  C   LEU A  32      -3.830  -2.945   1.389  1.00 26.51           C  
ATOM    226  O   LEU A  32      -3.431  -3.720   0.524  1.00 28.41           O  
ATOM    227  CB  LEU A  32      -3.540  -0.497   1.046  1.00 29.84           C  
ATOM    228  CG  LEU A  32      -2.802   0.838   1.188  1.00 32.35           C  
ATOM    229  CD1 LEU A  32      -1.559   0.829   0.317  1.00 38.67           C  
ATOM    230  CD2 LEU A  32      -3.710   1.973   0.763  1.00 35.43           C  
ATOM    231  N   THR A  33      -4.978  -3.113   2.029  1.00 26.20           N  
ATOM    232  CA  THR A  33      -5.859  -4.217   1.698  1.00 24.03           C  
ATOM    233  C   THR A  33      -7.171  -3.573   1.288  1.00 24.41           C  
ATOM    234  O   THR A  33      -7.815  -2.902   2.094  1.00 21.97           O  
ATOM    235  CB  THR A  33      -6.101  -5.147   2.912  1.00 27.40           C  
ATOM    236  OG1 THR A  33      -4.852  -5.693   3.352  1.00 27.10           O  
ATOM    237  CG2 THR A  33      -7.026  -6.296   2.527  1.00 27.70           C  
ATOM    238  N   LEU A  34      -7.537  -3.741   0.020  1.00 24.43           N  
ATOM    239  CA  LEU A  34      -8.783  -3.180  -0.491  1.00 24.55           C  
ATOM    240  C   LEU A  34      -9.815  -4.282  -0.510  1.00 21.34           C  
ATOM    241  O   LEU A  34      -9.525  -5.406  -0.914  1.00 23.33           O  
ATOM    242  CB  LEU A  34      -8.608  -2.621  -1.911  1.00 22.89           C  
ATOM    243  CG  LEU A  34      -8.078  -1.187  -2.018  1.00 27.91           C  
ATOM    244  CD1 LEU A  34      -6.669  -1.124  -1.440  1.00 28.26           C  
ATOM    245  CD2 LEU A  34      -8.086  -0.741  -3.485  1.00 26.23           C  
ATOM    246  N   ALA A  35     -11.018  -3.950  -0.072  1.00 23.07           N  
ATOM    247  CA  ALA A  35     -12.093  -4.924  -0.024  1.00 22.31           C  
ATOM    248  C   ALA A  35     -13.331  -4.385  -0.722  1.00 18.70           C  
ATOM    249  O   ALA A  35     -13.703  -3.221  -0.549  1.00 17.92           O  
ATOM    250  CB  ALA A  35     -12.417  -5.268   1.431  1.00 22.35           C  
ATOM    251  N   GLY A  36     -13.966  -5.249  -1.502  1.00 21.84           N  
ATOM    252  CA  GLY A  36     -15.165  -4.856  -2.211  1.00 21.42           C  
ATOM    253  C   GLY A  36     -15.994  -6.067  -2.574  1.00 24.20           C  
ATOM    254  O   GLY A  36     -15.563  -7.212  -2.426  1.00 25.16           O  
ATOM    255  N   GLN A  37     -17.207  -5.816  -3.039  1.00 26.63           N  
ATOM    256  CA  GLN A  37     -18.077  -6.906  -3.437  1.00 28.52           C  
ATOM    257  C   GLN A  37     -19.007  -6.402  -4.516  1.00 27.09           C  
ATOM    258  O   GLN A  37     -19.174  -5.193  -4.694  1.00 26.80           O  
ATOM    259  CB  GLN A  37     -18.889  -7.419  -2.244  1.00 30.80           C  
ATOM    260  CG  GLN A  37     -19.854  -6.408  -1.662  1.00 30.01           C  
ATOM    261  CD  GLN A  37     -20.682  -6.997  -0.532  1.00 38.40           C  
ATOM    262  OE1 GLN A  37     -20.141  -7.477   0.463  1.00 34.34           O  
ATOM    263  NE2 GLN A  37     -22.002  -6.962  -0.685  1.00 38.24           N  
ATOM    264  N   ASP A  38     -19.608  -7.331  -5.244  1.00 28.71           N  
ATOM    265  CA  ASP A  38     -20.523  -6.951  -6.303  1.00 31.94           C  
ATOM    266  C   ASP A  38     -21.435  -8.126  -6.602  1.00 31.97           C  
ATOM    267  O   ASP A  38     -21.224  -9.234  -6.105  1.00 28.51           O  
ATOM    268  CB  ASP A  38     -19.740  -6.571  -7.564  1.00 32.89           C  
ATOM    269  CG  ASP A  38     -20.512  -5.625  -8.471  1.00 35.62           C  
ATOM    270  OD1 ASP A  38     -21.653  -5.256  -8.121  1.00 37.06           O  
ATOM    271  OD2 ASP A  38     -19.974  -5.245  -9.533  1.00 36.65           O  
ATOM    272  N   LEU A  39     -22.460  -7.871  -7.405  1.00 32.68           N  
ATOM    273  CA  LEU A  39     -23.392  -8.915  -7.799  1.00 36.26           C  
ATOM    274  C   LEU A  39     -23.303  -8.989  -9.319  1.00 36.88           C  
ATOM    275  O   LEU A  39     -23.649  -8.035 -10.014  1.00 38.50           O  
ATOM    276  CB  LEU A  39     -24.814  -8.555  -7.365  1.00 39.17           C  
ATOM    277  CG  LEU A  39     -25.800  -9.715  -7.187  1.00 41.72           C  
ATOM    278  CD1 LEU A  39     -27.158  -9.166  -6.775  1.00 43.24           C  
ATOM    279  CD2 LEU A  39     -25.916 -10.514  -8.473  1.00 46.12           C  
ATOM    280  N   LEU A  40     -22.820 -10.113  -9.830  1.00 37.90           N  
ATOM    281  CA  LEU A  40     -22.675 -10.295 -11.267  1.00 40.67           C  
ATOM    282  C   LEU A  40     -23.933 -10.927 -11.852  1.00 41.86           C  
ATOM    283  O   LEU A  40     -24.609 -11.704 -11.179  1.00 44.34           O  
ATOM    284  CB  LEU A  40     -21.470 -11.191 -11.556  1.00 40.60           C  
ATOM    285  CG  LEU A  40     -20.211 -10.865 -10.751  1.00 43.12           C  
ATOM    286  CD1 LEU A  40     -19.071 -11.770 -11.198  1.00 41.98           C  
ATOM    287  CD2 LEU A  40     -19.847  -9.400 -10.938  1.00 42.39           C  
ATOM    288  N   ARG A  48     -24.994 -13.849  -9.089  1.00 49.56           N  
ATOM    289  CA  ARG A  48     -23.742 -14.361  -8.537  1.00 47.96           C  
ATOM    290  C   ARG A  48     -23.053 -13.281  -7.706  1.00 47.36           C  
ATOM    291  O   ARG A  48     -22.535 -12.305  -8.251  1.00 45.24           O  
ATOM    292  CB  ARG A  48     -22.820 -14.809  -9.673  1.00 50.38           C  
ATOM    293  CG  ARG A  48     -21.475 -15.356  -9.223  1.00 51.50           C  
ATOM    294  CD  ARG A  48     -20.550 -15.570 -10.414  1.00 54.07           C  
ATOM    295  NE  ARG A  48     -19.202 -15.940  -9.993  1.00 57.21           N  
ATOM    296  CZ  ARG A  48     -18.144 -15.963 -10.799  1.00 58.54           C  
ATOM    297  NH1 ARG A  48     -18.271 -15.635 -12.078  1.00 56.90           N  
ATOM    298  NH2 ARG A  48     -16.956 -16.309 -10.321  1.00 59.95           N  
ATOM    299  N   GLU A  49     -23.051 -13.452  -6.388  1.00 45.54           N  
ATOM    300  CA  GLU A  49     -22.418 -12.478  -5.507  1.00 45.88           C  
ATOM    301  C   GLU A  49     -20.945 -12.802  -5.302  1.00 43.84           C  
ATOM    302  O   GLU A  49     -20.583 -13.913  -4.903  1.00 42.90           O  
ATOM    303  CB  GLU A  49     -23.150 -12.419  -4.160  1.00 51.40           C  
ATOM    304  CG  GLU A  49     -23.439 -13.772  -3.534  1.00 56.82           C  
ATOM    305  CD  GLU A  49     -24.367 -13.668  -2.335  1.00 59.16           C  
ATOM    306  OE1 GLU A  49     -25.476 -13.108  -2.489  1.00 58.70           O  
ATOM    307  OE2 GLU A  49     -23.992 -14.147  -1.241  1.00 58.77           O  
ATOM    308  N   VAL A  50     -20.092 -11.827  -5.594  1.00 39.64           N  
ATOM    309  CA  VAL A  50     -18.655 -12.009  -5.451  1.00 33.84           C  
ATOM    310  C   VAL A  50     -18.091 -10.980  -4.487  1.00 31.40           C  
ATOM    311  O   VAL A  50     -18.602  -9.869  -4.379  1.00 29.49           O  
ATOM    312  CB  VAL A  50     -17.939 -11.874  -6.809  1.00 33.86           C  
ATOM    313  CG1 VAL A  50     -18.387 -12.978  -7.745  1.00 35.46           C  
ATOM    314  CG2 VAL A  50     -18.233 -10.516  -7.416  1.00 34.35           C  
ATOM    315  N   SER A  51     -17.046 -11.367  -3.771  1.00 29.54           N  
ATOM    316  CA  SER A  51     -16.401 -10.474  -2.820  1.00 31.01           C  
ATOM    317  C   SER A  51     -14.899 -10.689  -2.942  1.00 28.95           C  
ATOM    318  O   SER A  51     -14.456 -11.745  -3.396  1.00 30.69           O  
ATOM    319  CB  SER A  51     -16.863 -10.788  -1.394  1.00 31.38           C  
ATOM    320  OG  SER A  51     -16.511 -12.113  -1.034  1.00 36.65           O  
ATOM    321  N   TRP A  52     -14.121  -9.691  -2.545  1.00 28.42           N  
ATOM    322  CA  TRP A  52     -12.674  -9.802  -2.633  1.00 27.39           C  
ATOM    323  C   TRP A  52     -11.918  -8.907  -1.664  1.00 27.01           C  
ATOM    324  O   TRP A  52     -12.410  -7.863  -1.236  1.00 28.53           O  
ATOM    325  CB  TRP A  52     -12.205  -9.504  -4.064  1.00 27.59           C  
ATOM    326  CG  TRP A  52     -12.788  -8.247  -4.658  1.00 26.29           C  
ATOM    327  CD1 TRP A  52     -13.861  -8.160  -5.501  1.00 27.35           C  
ATOM    328  CD2 TRP A  52     -12.328  -6.903  -4.455  1.00 24.21           C  
ATOM    329  NE1 TRP A  52     -14.097  -6.848  -5.838  1.00 24.11           N  
ATOM    330  CE2 TRP A  52     -13.170  -6.055  -5.212  1.00 26.09           C  
ATOM    331  CE3 TRP A  52     -11.285  -6.332  -3.708  1.00 26.12           C  
ATOM    332  CZ2 TRP A  52     -13.002  -4.665  -5.245  1.00 22.58           C  
ATOM    333  CZ3 TRP A  52     -11.118  -4.950  -3.741  1.00 22.38           C  
ATOM    334  CH2 TRP A  52     -11.977  -4.132  -4.507  1.00 24.07           C  
ATOM    335  N   TYR A  53     -10.716  -9.358  -1.318  1.00 26.28           N  
ATOM    336  CA  TYR A  53      -9.800  -8.651  -0.436  1.00 26.43           C  
ATOM    337  C   TYR A  53      -8.496  -8.693  -1.213  1.00 27.51           C  
ATOM    338  O   TYR A  53      -7.922  -9.762  -1.400  1.00 30.35           O  
ATOM    339  CB  TYR A  53      -9.632  -9.404   0.882  1.00 31.06           C  
ATOM    340  CG  TYR A  53     -10.866  -9.373   1.749  1.00 32.13           C  
ATOM    341  CD1 TYR A  53     -11.057  -8.359   2.683  1.00 32.70           C  
ATOM    342  CD2 TYR A  53     -11.852 -10.351   1.622  1.00 36.20           C  
ATOM    343  CE1 TYR A  53     -12.201  -8.317   3.476  1.00 37.86           C  
ATOM    344  CE2 TYR A  53     -13.002 -10.319   2.408  1.00 38.46           C  
ATOM    345  CZ  TYR A  53     -13.168  -9.299   3.331  1.00 39.63           C  
ATOM    346  OH  TYR A  53     -14.306  -9.256   4.102  1.00 42.61           O  
ATOM    347  N   HIS A  54      -8.039  -7.544  -1.690  1.00 26.33           N  
ATOM    348  CA  HIS A  54      -6.809  -7.520  -2.464  1.00 26.08           C  
ATOM    349  C   HIS A  54      -5.729  -6.689  -1.802  1.00 24.18           C  
ATOM    350  O   HIS A  54      -5.962  -5.547  -1.417  1.00 26.06           O  
ATOM    351  CB  HIS A  54      -7.082  -6.987  -3.876  1.00 26.74           C  
ATOM    352  CG  HIS A  54      -7.742  -7.980  -4.779  1.00 24.99           C  
ATOM    353  ND1 HIS A  54      -7.190  -9.210  -5.063  1.00 27.14           N  
ATOM    354  CD2 HIS A  54      -8.904  -7.921  -5.473  1.00 26.72           C  
ATOM    355  CE1 HIS A  54      -7.983  -9.867  -5.892  1.00 29.16           C  
ATOM    356  NE2 HIS A  54      -9.031  -9.107  -6.156  1.00 26.57           N  
ATOM    357  N   ARG A  55      -4.548  -7.279  -1.661  1.00 26.97           N  
ATOM    358  CA  ARG A  55      -3.429  -6.565  -1.069  1.00 28.27           C  
ATOM    359  C   ARG A  55      -2.764  -5.773  -2.188  1.00 25.61           C  
ATOM    360  O   ARG A  55      -2.445  -6.319  -3.243  1.00 27.15           O  
ATOM    361  CB  ARG A  55      -2.431  -7.543  -0.449  1.00 33.56           C  
ATOM    362  CG  ARG A  55      -2.978  -8.275   0.776  1.00 46.51           C  
ATOM    363  CD  ARG A  55      -1.874  -8.996   1.543  1.00 54.42           C  
ATOM    364  NE  ARG A  55      -1.395 -10.197   0.859  1.00 60.79           N  
ATOM    365  CZ  ARG A  55      -2.091 -11.326   0.747  1.00 63.99           C  
ATOM    366  NH1 ARG A  55      -3.308 -11.421   1.273  1.00 64.60           N  
ATOM    367  NH2 ARG A  55      -1.566 -12.368   0.114  1.00 64.59           N  
ATOM    368  N   VAL A  56      -2.572  -4.483  -1.957  1.00 24.43           N  
ATOM    369  CA  VAL A  56      -1.949  -3.624  -2.952  1.00 25.82           C  
ATOM    370  C   VAL A  56      -0.746  -2.940  -2.326  1.00 23.24           C  
ATOM    371  O   VAL A  56      -0.772  -2.591  -1.150  1.00 24.94           O  
ATOM    372  CB  VAL A  56      -2.929  -2.544  -3.443  1.00 23.29           C  
ATOM    373  CG1 VAL A  56      -2.268  -1.689  -4.482  1.00 31.76           C  
ATOM    374  CG2 VAL A  56      -4.181  -3.196  -4.022  1.00 27.23           C  
ATOM    375  N   ARG A  57       0.303  -2.740  -3.117  1.00 24.84           N  
ATOM    376  CA  ARG A  57       1.505  -2.093  -2.610  1.00 23.74           C  
ATOM    377  C   ARG A  57       1.859  -0.797  -3.323  1.00 21.73           C  
ATOM    378  O   ARG A  57       2.065  -0.779  -4.539  1.00 23.38           O  
ATOM    379  CB  ARG A  57       2.694  -3.047  -2.698  1.00 24.52           C  
ATOM    380  CG  ARG A  57       4.035  -2.387  -2.399  1.00 27.15           C  
ATOM    381  CD  ARG A  57       5.128  -3.432  -2.218  1.00 30.96           C  
ATOM    382  NE  ARG A  57       4.934  -4.197  -0.992  1.00 32.16           N  
ATOM    383  CZ  ARG A  57       5.748  -5.162  -0.574  1.00 38.87           C  
ATOM    384  NH1 ARG A  57       6.820  -5.488  -1.288  1.00 39.25           N  
ATOM    385  NH2 ARG A  57       5.492  -5.796   0.563  1.00 38.14           N  
ATOM    386  N   LEU A  58       1.918   0.280  -2.551  1.00 22.75           N  
ATOM    387  CA  LEU A  58       2.298   1.596  -3.058  1.00 24.73           C  
ATOM    388  C   LEU A  58       3.762   1.790  -2.671  1.00 27.26           C  
ATOM    389  O   LEU A  58       4.186   1.305  -1.621  1.00 24.73           O  
ATOM    390  CB  LEU A  58       1.469   2.691  -2.396  1.00 26.86           C  
ATOM    391  CG  LEU A  58       0.172   3.159  -3.049  1.00 27.72           C  
ATOM    392  CD1 LEU A  58      -0.473   4.219  -2.165  1.00 26.98           C  
ATOM    393  CD2 LEU A  58       0.466   3.731  -4.428  1.00 28.12           C  
ATOM    394  N   LEU A  59       4.529   2.488  -3.506  1.00 26.57           N  
ATOM    395  CA  LEU A  59       5.943   2.733  -3.213  1.00 25.43           C  
ATOM    396  C   LEU A  59       6.319   4.206  -3.352  1.00 29.46           C  
ATOM    397  O   LEU A  59       5.554   5.018  -3.876  1.00 26.85           O  
ATOM    398  CB  LEU A  59       6.846   1.929  -4.157  1.00 25.66           C  
ATOM    399  CG  LEU A  59       6.796   0.404  -4.215  1.00 29.59           C  
ATOM    400  CD1 LEU A  59       7.795  -0.086  -5.261  1.00 32.12           C  
ATOM    401  CD2 LEU A  59       7.121  -0.182  -2.848  1.00 27.65           C  
ATOM    402  N   GLY A  60       7.512   4.537  -2.863  1.00 28.94           N  
ATOM    403  CA  GLY A  60       8.037   5.889  -2.972  1.00 27.42           C  
ATOM    404  C   GLY A  60       7.162   7.070  -2.620  1.00 27.18           C  
ATOM    405  O   GLY A  60       6.457   7.064  -1.611  1.00 24.72           O  
ATOM    406  N   ARG A  61       7.213   8.098  -3.461  1.00 26.15           N  
ATOM    407  CA  ARG A  61       6.453   9.315  -3.210  1.00 29.74           C  
ATOM    408  C   ARG A  61       4.942   9.119  -3.150  1.00 28.30           C  
ATOM    409  O   ARG A  61       4.265   9.807  -2.389  1.00 27.63           O  
ATOM    410  CB  ARG A  61       6.808  10.391  -4.247  1.00 35.42           C  
ATOM    411  CG  ARG A  61       6.548  10.001  -5.684  1.00 42.40           C  
ATOM    412  CD  ARG A  61       6.809  11.173  -6.631  1.00 48.18           C  
ATOM    413  NE  ARG A  61       6.486  10.830  -8.016  1.00 52.06           N  
ATOM    414  CZ  ARG A  61       5.268  10.514  -8.444  1.00 49.30           C  
ATOM    415  NH1 ARG A  61       4.246  10.498  -7.600  1.00 52.27           N  
ATOM    416  NH2 ARG A  61       5.072  10.199  -9.716  1.00 51.88           N  
ATOM    417  N   GLN A  62       4.408   8.190  -3.937  1.00 29.43           N  
ATOM    418  CA  GLN A  62       2.964   7.958  -3.918  1.00 33.21           C  
ATOM    419  C   GLN A  62       2.553   7.279  -2.620  1.00 33.38           C  
ATOM    420  O   GLN A  62       1.398   7.374  -2.201  1.00 35.31           O  
ATOM    421  CB  GLN A  62       2.530   7.117  -5.121  1.00 34.11           C  
ATOM    422  CG  GLN A  62       2.522   7.903  -6.423  1.00 39.97           C  
ATOM    423  CD  GLN A  62       1.525   9.052  -6.400  1.00 40.11           C  
ATOM    424  OE1 GLN A  62       1.773  10.116  -6.970  1.00 46.75           O  
ATOM    425  NE2 GLN A  62       0.387   8.837  -5.749  1.00 41.01           N  
ATOM    426  N   ALA A  63       3.505   6.602  -1.985  1.00 29.48           N  
ATOM    427  CA  ALA A  63       3.254   5.926  -0.714  1.00 30.05           C  
ATOM    428  C   ALA A  63       3.356   6.929   0.436  1.00 29.82           C  
ATOM    429  O   ALA A  63       2.484   6.990   1.300  1.00 31.83           O  
ATOM    430  CB  ALA A  63       4.266   4.792  -0.513  1.00 28.33           C  
ATOM    431  N   GLU A  64       4.428   7.718   0.438  1.00 30.16           N  
ATOM    432  CA  GLU A  64       4.652   8.717   1.481  1.00 29.27           C  
ATOM    433  C   GLU A  64       3.534   9.740   1.513  1.00 28.92           C  
ATOM    434  O   GLU A  64       3.214  10.304   2.556  1.00 28.24           O  
ATOM    435  CB  GLU A  64       5.977   9.446   1.243  1.00 32.97           C  
ATOM    436  CG  GLU A  64       7.207   8.595   1.473  1.00 37.45           C  
ATOM    437  CD  GLU A  64       8.491   9.369   1.246  1.00 42.73           C  
ATOM    438  OE1 GLU A  64       8.602  10.496   1.770  1.00 42.91           O  
ATOM    439  OE2 GLU A  64       9.389   8.846   0.551  1.00 46.08           O  
HETATM  440  N   MSE A  65       2.955   9.990   0.349  1.00 26.99           N  
HETATM  441  CA  MSE A  65       1.876  10.952   0.226  1.00 31.52           C  
HETATM  442  C   MSE A  65       0.678  10.598   1.111  1.00 31.10           C  
HETATM  443  O   MSE A  65       0.034  11.481   1.675  1.00 29.63           O  
HETATM  444  CB  MSE A  65       1.442  11.014  -1.240  1.00 32.95           C  
HETATM  445  CG  MSE A  65       0.338  11.991  -1.551  1.00 40.81           C  
HETATM  446 SE   MSE A  65      -0.112  11.793  -3.417  1.00 43.26          SE  
HETATM  447  CE  MSE A  65       1.479  12.582  -4.186  1.00 41.94           C  
ATOM    448  N   TRP A  66       0.393   9.305   1.235  1.00 33.22           N  
ATOM    449  CA  TRP A  66      -0.751   8.838   2.018  1.00 35.82           C  
ATOM    450  C   TRP A  66      -0.415   8.269   3.387  1.00 41.24           C  
ATOM    451  O   TRP A  66      -1.269   7.670   4.042  1.00 41.84           O  
ATOM    452  CB  TRP A  66      -1.522   7.800   1.207  1.00 34.53           C  
ATOM    453  CG  TRP A  66      -1.976   8.369  -0.084  1.00 31.87           C  
ATOM    454  CD1 TRP A  66      -1.582   7.994  -1.332  1.00 30.16           C  
ATOM    455  CD2 TRP A  66      -2.845   9.491  -0.252  1.00 32.45           C  
ATOM    456  NE1 TRP A  66      -2.148   8.823  -2.273  1.00 31.30           N  
ATOM    457  CE2 TRP A  66      -2.928   9.751  -1.635  1.00 31.72           C  
ATOM    458  CE3 TRP A  66      -3.560  10.308   0.635  1.00 32.32           C  
ATOM    459  CZ2 TRP A  66      -3.698  10.795  -2.155  1.00 29.81           C  
ATOM    460  CZ3 TRP A  66      -4.324  11.347   0.117  1.00 30.68           C  
ATOM    461  CH2 TRP A  66      -4.385  11.579  -1.266  1.00 30.52           C  
ATOM    462  N   GLY A  67       0.825   8.465   3.818  1.00 44.36           N  
ATOM    463  CA  GLY A  67       1.233   7.960   5.113  1.00 47.13           C  
ATOM    464  C   GLY A  67       0.531   8.695   6.232  1.00 47.51           C  
ATOM    465  O   GLY A  67       0.541   9.924   6.273  1.00 47.75           O  
ATOM    466  N   ASP A  68      -0.090   7.939   7.132  1.00 48.34           N  
ATOM    467  CA  ASP A  68      -0.796   8.509   8.275  1.00 49.59           C  
ATOM    468  C   ASP A  68      -2.023   9.333   7.889  1.00 47.74           C  
ATOM    469  O   ASP A  68      -2.444  10.207   8.645  1.00 49.66           O  
ATOM    470  CB  ASP A  68       0.159   9.378   9.102  1.00 55.18           C  
ATOM    471  CG  ASP A  68       1.425   8.639   9.499  1.00 60.56           C  
ATOM    472  OD1 ASP A  68       1.326   7.632  10.237  1.00 61.86           O  
ATOM    473  OD2 ASP A  68       2.521   9.067   9.070  1.00 62.20           O  
ATOM    474  N   LEU A  69      -2.591   9.061   6.716  1.00 43.16           N  
ATOM    475  CA  LEU A  69      -3.778   9.784   6.263  1.00 42.70           C  
ATOM    476  C   LEU A  69      -4.961   8.865   5.970  1.00 40.25           C  
ATOM    477  O   LEU A  69      -6.104   9.319   5.914  1.00 40.16           O  
ATOM    478  CB  LEU A  69      -3.483  10.595   4.997  1.00 40.37           C  
ATOM    479  CG  LEU A  69      -2.822  11.967   5.122  1.00 44.54           C  
ATOM    480  CD1 LEU A  69      -1.388  11.809   5.577  1.00 45.23           C  
ATOM    481  CD2 LEU A  69      -2.871  12.672   3.775  1.00 41.60           C  
ATOM    482  N   LEU A  70      -4.688   7.581   5.778  1.00 36.12           N  
ATOM    483  CA  LEU A  70      -5.746   6.630   5.459  1.00 34.37           C  
ATOM    484  C   LEU A  70      -6.095   5.706   6.624  1.00 36.12           C  
ATOM    485  O   LEU A  70      -5.209   5.156   7.281  1.00 35.86           O  
ATOM    486  CB  LEU A  70      -5.330   5.794   4.249  1.00 32.26           C  
ATOM    487  CG  LEU A  70      -4.805   6.567   3.033  1.00 34.74           C  
ATOM    488  CD1 LEU A  70      -4.405   5.573   1.955  1.00 31.67           C  
ATOM    489  CD2 LEU A  70      -5.857   7.539   2.513  1.00 31.15           C  
ATOM    490  N   ASP A  71      -7.390   5.529   6.866  1.00 35.22           N  
ATOM    491  CA  ASP A  71      -7.855   4.671   7.951  1.00 36.24           C  
ATOM    492  C   ASP A  71      -8.787   3.585   7.422  1.00 34.11           C  
ATOM    493  O   ASP A  71      -9.244   3.645   6.278  1.00 29.74           O  
ATOM    494  CB  ASP A  71      -8.602   5.501   8.998  1.00 41.56           C  
ATOM    495  CG  ASP A  71      -8.438   4.950  10.408  1.00 48.10           C  
ATOM    496  OD1 ASP A  71      -8.410   3.709  10.578  1.00 47.26           O  
ATOM    497  OD2 ASP A  71      -8.345   5.766  11.353  1.00 52.01           O  
ATOM    498  N   GLN A  72      -9.060   2.590   8.259  1.00 29.33           N  
ATOM    499  CA  GLN A  72      -9.957   1.502   7.891  1.00 26.83           C  
ATOM    500  C   GLN A  72     -11.285   2.114   7.444  1.00 24.37           C  
ATOM    501  O   GLN A  72     -11.733   3.110   8.008  1.00 24.67           O  
ATOM    502  CB  GLN A  72     -10.188   0.592   9.107  1.00 27.31           C  
ATOM    503  CG  GLN A  72     -11.148  -0.567   8.880  1.00 25.09           C  
ATOM    504  CD  GLN A  72     -11.352  -1.396  10.143  1.00 26.26           C  
ATOM    505  OE1 GLN A  72     -11.764  -0.873  11.173  1.00 25.53           O  
ATOM    506  NE2 GLN A  72     -11.052  -2.687  10.067  1.00 26.79           N  
ATOM    507  N   GLY A  73     -11.900   1.533   6.419  1.00 25.61           N  
ATOM    508  CA  GLY A  73     -13.175   2.046   5.945  1.00 28.03           C  
ATOM    509  C   GLY A  73     -13.094   3.035   4.792  1.00 30.40           C  
ATOM    510  O   GLY A  73     -14.023   3.140   3.989  1.00 27.27           O  
ATOM    511  N   GLN A  74     -11.985   3.763   4.709  1.00 27.45           N  
ATOM    512  CA  GLN A  74     -11.789   4.749   3.647  1.00 26.39           C  
ATOM    513  C   GLN A  74     -11.964   4.139   2.258  1.00 21.91           C  
ATOM    514  O   GLN A  74     -11.431   3.077   1.969  1.00 21.91           O  
ATOM    515  CB  GLN A  74     -10.385   5.349   3.752  1.00 26.87           C  
ATOM    516  CG  GLN A  74     -10.023   6.313   2.624  1.00 29.79           C  
ATOM    517  CD  GLN A  74     -10.719   7.654   2.742  1.00 33.85           C  
ATOM    518  OE1 GLN A  74     -10.515   8.389   3.709  1.00 35.46           O  
ATOM    519  NE2 GLN A  74     -11.548   7.985   1.753  1.00 30.09           N  
ATOM    520  N   LEU A  75     -12.713   4.809   1.392  1.00 23.79           N  
ATOM    521  CA  LEU A  75     -12.883   4.298   0.038  1.00 19.40           C  
ATOM    522  C   LEU A  75     -11.743   4.888  -0.782  1.00 19.22           C  
ATOM    523  O   LEU A  75     -11.447   6.070  -0.657  1.00 20.69           O  
ATOM    524  CB  LEU A  75     -14.225   4.732  -0.553  1.00 22.20           C  
ATOM    525  CG  LEU A  75     -15.465   4.291   0.233  1.00 23.42           C  
ATOM    526  CD1 LEU A  75     -16.709   4.531  -0.617  1.00 23.77           C  
ATOM    527  CD2 LEU A  75     -15.347   2.816   0.593  1.00 20.28           C  
ATOM    528  N   VAL A  76     -11.102   4.064  -1.603  1.00 20.46           N  
ATOM    529  CA  VAL A  76      -9.996   4.540  -2.426  1.00 23.35           C  
ATOM    530  C   VAL A  76     -10.049   3.979  -3.836  1.00 21.85           C  
ATOM    531  O   VAL A  76     -10.628   2.915  -4.079  1.00 20.01           O  
ATOM    532  CB  VAL A  76      -8.618   4.136  -1.832  1.00 21.96           C  
ATOM    533  CG1 VAL A  76      -8.454   4.717  -0.440  1.00 20.32           C  
ATOM    534  CG2 VAL A  76      -8.496   2.628  -1.790  1.00 21.21           C  
ATOM    535  N   PHE A  77      -9.442   4.716  -4.760  1.00 19.83           N  
ATOM    536  CA  PHE A  77      -9.339   4.299  -6.149  1.00 18.56           C  
ATOM    537  C   PHE A  77      -7.858   4.060  -6.409  1.00 19.92           C  
ATOM    538  O   PHE A  77      -7.038   4.954  -6.213  1.00 21.16           O  
ATOM    539  CB  PHE A  77      -9.843   5.393  -7.098  1.00 15.65           C  
ATOM    540  CG  PHE A  77      -9.360   5.228  -8.518  1.00 18.06           C  
ATOM    541  CD1 PHE A  77      -9.574   4.041  -9.207  1.00 20.61           C  
ATOM    542  CD2 PHE A  77      -8.670   6.262  -9.159  1.00 22.65           C  
ATOM    543  CE1 PHE A  77      -9.109   3.875 -10.518  1.00 24.32           C  
ATOM    544  CE2 PHE A  77      -8.199   6.108 -10.466  1.00 23.42           C  
ATOM    545  CZ  PHE A  77      -8.418   4.914 -11.148  1.00 23.08           C  
ATOM    546  N   VAL A  78      -7.527   2.855  -6.852  1.00 21.02           N  
ATOM    547  CA  VAL A  78      -6.151   2.510  -7.139  1.00 23.29           C  
ATOM    548  C   VAL A  78      -5.957   2.183  -8.607  1.00 24.06           C  
ATOM    549  O   VAL A  78      -6.757   1.451  -9.202  1.00 20.01           O  
ATOM    550  CB  VAL A  78      -5.698   1.295  -6.298  1.00 23.26           C  
ATOM    551  CG1 VAL A  78      -4.454   0.670  -6.895  1.00 24.95           C  
ATOM    552  CG2 VAL A  78      -5.420   1.736  -4.876  1.00 21.95           C  
ATOM    553  N   GLU A  79      -4.904   2.755  -9.187  1.00 19.22           N  
ATOM    554  CA  GLU A  79      -4.550   2.484 -10.572  1.00 18.64           C  
ATOM    555  C   GLU A  79      -3.186   1.816 -10.490  1.00 19.32           C  
ATOM    556  O   GLU A  79      -2.230   2.390  -9.949  1.00 19.97           O  
ATOM    557  CB  GLU A  79      -4.446   3.774 -11.403  1.00 18.23           C  
ATOM    558  CG  GLU A  79      -3.962   3.474 -12.832  1.00 20.69           C  
ATOM    559  CD  GLU A  79      -3.941   4.690 -13.753  1.00 23.56           C  
ATOM    560  OE1 GLU A  79      -4.074   5.823 -13.259  1.00 21.80           O  
ATOM    561  OE2 GLU A  79      -3.781   4.502 -14.976  1.00 24.12           O  
ATOM    562  N   GLY A  80      -3.083   0.606 -11.021  1.00 21.43           N  
ATOM    563  CA  GLY A  80      -1.815  -0.083 -10.939  1.00 20.74           C  
ATOM    564  C   GLY A  80      -1.587  -1.110 -12.018  1.00 21.45           C  
ATOM    565  O   GLY A  80      -2.066  -0.982 -13.147  1.00 21.98           O  
ATOM    566  N   ARG A  81      -0.857  -2.150 -11.651  1.00 18.79           N  
ATOM    567  CA  ARG A  81      -0.516  -3.203 -12.582  1.00 21.46           C  
ATOM    568  C   ARG A  81      -0.085  -4.434 -11.812  1.00 20.68           C  
ATOM    569  O   ARG A  81       0.222  -4.355 -10.621  1.00 22.23           O  
ATOM    570  CB  ARG A  81       0.625  -2.727 -13.476  1.00 27.57           C  
ATOM    571  CG  ARG A  81       1.768  -2.131 -12.687  1.00 32.18           C  
ATOM    572  CD  ARG A  81       2.648  -1.222 -13.546  1.00 31.79           C  
ATOM    573  NE  ARG A  81       3.551  -0.450 -12.701  1.00 33.37           N  
ATOM    574  CZ  ARG A  81       4.514  -0.984 -11.956  1.00 37.78           C  
ATOM    575  NH1 ARG A  81       5.284  -0.203 -11.210  1.00 36.32           N  
ATOM    576  NH2 ARG A  81       4.718  -2.298 -11.965  1.00 36.93           N  
ATOM    577  N   LEU A  82      -0.064  -5.567 -12.501  1.00 20.27           N  
ATOM    578  CA  LEU A  82       0.339  -6.822 -11.894  1.00 24.08           C  
ATOM    579  C   LEU A  82       1.842  -6.992 -12.064  1.00 26.51           C  
ATOM    580  O   LEU A  82       2.402  -6.630 -13.098  1.00 24.62           O  
ATOM    581  CB  LEU A  82      -0.403  -7.977 -12.557  1.00 24.00           C  
ATOM    582  CG  LEU A  82      -1.932  -7.848 -12.501  1.00 19.83           C  
ATOM    583  CD1 LEU A  82      -2.559  -9.038 -13.197  1.00 20.77           C  
ATOM    584  CD2 LEU A  82      -2.396  -7.779 -11.059  1.00 25.97           C  
ATOM    585  N   GLU A  83       2.487  -7.548 -11.049  1.00 25.04           N  
ATOM    586  CA  GLU A  83       3.926  -7.743 -11.082  1.00 27.97           C  
ATOM    587  C   GLU A  83       4.258  -9.162 -10.625  1.00 26.85           C  
ATOM    588  O   GLU A  83       3.971  -9.551  -9.493  1.00 25.31           O  
ATOM    589  CB  GLU A  83       4.580  -6.691 -10.185  1.00 31.50           C  
ATOM    590  CG  GLU A  83       6.086  -6.605 -10.269  1.00 42.16           C  
ATOM    591  CD  GLU A  83       6.598  -5.325  -9.640  1.00 43.95           C  
ATOM    592  OE1 GLU A  83       6.393  -4.244 -10.234  1.00 48.03           O  
ATOM    593  OE2 GLU A  83       7.190  -5.397  -8.544  1.00 49.08           O  
ATOM    594  N   TYR A  84       4.863  -9.924 -11.526  1.00 25.22           N  
ATOM    595  CA  TYR A  84       5.218 -11.313 -11.274  1.00 31.56           C  
ATOM    596  C   TYR A  84       6.643 -11.515 -10.758  1.00 36.45           C  
ATOM    597  O   TYR A  84       7.560 -10.801 -11.151  1.00 34.18           O  
ATOM    598  CB  TYR A  84       5.040 -12.103 -12.562  1.00 29.91           C  
ATOM    599  CG  TYR A  84       5.379 -13.564 -12.448  1.00 34.63           C  
ATOM    600  CD1 TYR A  84       4.473 -14.469 -11.898  1.00 36.21           C  
ATOM    601  CD2 TYR A  84       6.607 -14.045 -12.890  1.00 35.40           C  
ATOM    602  CE1 TYR A  84       4.781 -15.820 -11.795  1.00 36.87           C  
ATOM    603  CE2 TYR A  84       6.925 -15.390 -12.791  1.00 39.62           C  
ATOM    604  CZ  TYR A  84       6.006 -16.272 -12.242  1.00 39.30           C  
ATOM    605  OH  TYR A  84       6.315 -17.607 -12.146  1.00 42.22           O  
ATOM    606  N   ARG A  85       6.808 -12.510  -9.890  1.00 41.59           N  
ATOM    607  CA  ARG A  85       8.105 -12.860  -9.314  1.00 47.28           C  
ATOM    608  C   ARG A  85       8.129 -14.343  -8.939  1.00 49.46           C  
ATOM    609  O   ARG A  85       7.164 -14.861  -8.376  1.00 48.96           O  
ATOM    610  CB  ARG A  85       8.390 -12.015  -8.066  1.00 49.90           C  
ATOM    611  CG  ARG A  85       9.444 -12.624  -7.138  1.00 56.49           C  
ATOM    612  CD  ARG A  85       9.805 -11.706  -5.971  1.00 59.36           C  
ATOM    613  NE  ARG A  85      10.623 -10.574  -6.401  1.00 64.10           N  
ATOM    614  CZ  ARG A  85      11.172  -9.683  -5.578  1.00 66.16           C  
ATOM    615  NH1 ARG A  85      10.994  -9.784  -4.264  1.00 67.05           N  
ATOM    616  NH2 ARG A  85      11.903  -8.690  -6.068  1.00 64.52           N  
ATOM    617  N   GLN A  86       9.230 -15.020  -9.256  1.00 52.36           N  
ATOM    618  CA  GLN A  86       9.379 -16.437  -8.933  1.00 54.86           C  
ATOM    619  C   GLN A  86      10.254 -16.618  -7.700  1.00 56.55           C  
ATOM    620  O   GLN A  86      11.479 -16.623  -7.800  1.00 56.68           O  
ATOM    621  CB  GLN A  86      10.007 -17.199 -10.100  1.00 57.03           C  
ATOM    622  CG  GLN A  86       9.129 -17.287 -11.326  1.00 59.72           C  
ATOM    623  CD  GLN A  86       9.703 -18.196 -12.392  1.00 61.37           C  
ATOM    624  OE1 GLN A  86       9.115 -18.363 -13.462  1.00 62.74           O  
ATOM    625  NE2 GLN A  86      10.856 -18.792 -12.107  1.00 63.49           N  
ATOM    626  N   SER A  95       5.994 -19.062  -7.022  1.00 48.87           N  
ATOM    627  CA  SER A  95       5.884 -17.753  -7.660  1.00 48.78           C  
ATOM    628  C   SER A  95       4.873 -16.881  -6.923  1.00 47.45           C  
ATOM    629  O   SER A  95       4.180 -17.346  -6.017  1.00 48.37           O  
ATOM    630  CB  SER A  95       5.447 -17.912  -9.115  1.00 49.95           C  
ATOM    631  OG  SER A  95       4.115 -18.395  -9.182  1.00 51.35           O  
ATOM    632  N   GLU A  96       4.784 -15.618  -7.328  1.00 45.35           N  
ATOM    633  CA  GLU A  96       3.865 -14.679  -6.705  1.00 42.68           C  
ATOM    634  C   GLU A  96       3.473 -13.567  -7.678  1.00 40.04           C  
ATOM    635  O   GLU A  96       4.320 -13.024  -8.383  1.00 37.61           O  
ATOM    636  CB  GLU A  96       4.518 -14.068  -5.462  1.00 46.07           C  
ATOM    637  CG  GLU A  96       3.606 -13.163  -4.653  1.00 52.49           C  
ATOM    638  CD  GLU A  96       4.298 -12.586  -3.430  1.00 57.30           C  
ATOM    639  OE1 GLU A  96       4.798 -13.376  -2.600  1.00 56.60           O  
ATOM    640  OE2 GLU A  96       4.340 -11.342  -3.299  1.00 58.60           O  
ATOM    641  N   LEU A  97       2.185 -13.246  -7.720  1.00 34.97           N  
ATOM    642  CA  LEU A  97       1.692 -12.185  -8.589  1.00 33.50           C  
ATOM    643  C   LEU A  97       1.111 -11.133  -7.661  1.00 33.59           C  
ATOM    644  O   LEU A  97       0.035 -11.327  -7.093  1.00 34.84           O  
ATOM    645  CB  LEU A  97       0.609 -12.718  -9.540  1.00 32.41           C  
ATOM    646  CG  LEU A  97       0.114 -11.773 -10.641  1.00 32.78           C  
ATOM    647  CD1 LEU A  97       1.229 -11.534 -11.655  1.00 31.14           C  
ATOM    648  CD2 LEU A  97      -1.100 -12.385 -11.337  1.00 30.54           C  
ATOM    649  N   GLN A  98       1.829 -10.027  -7.493  1.00 28.81           N  
ATOM    650  CA  GLN A  98       1.374  -8.969  -6.602  1.00 29.40           C  
ATOM    651  C   GLN A  98       0.730  -7.824  -7.360  1.00 25.55           C  
ATOM    652  O   GLN A  98       0.956  -7.645  -8.554  1.00 27.30           O  
ATOM    653  CB  GLN A  98       2.542  -8.423  -5.763  1.00 34.39           C  
ATOM    654  CG  GLN A  98       3.342  -7.315  -6.445  1.00 38.93           C  
ATOM    655  CD  GLN A  98       4.443  -6.733  -5.564  1.00 44.85           C  
ATOM    656  OE1 GLN A  98       4.226  -6.431  -4.388  1.00 42.29           O  
ATOM    657  NE2 GLN A  98       5.629  -6.559  -6.138  1.00 46.59           N  
ATOM    658  N   ILE A  99      -0.075  -7.052  -6.644  1.00 23.27           N  
ATOM    659  CA  ILE A  99      -0.756  -5.906  -7.213  1.00 24.93           C  
ATOM    660  C   ILE A  99      -0.016  -4.648  -6.791  1.00 23.02           C  
ATOM    661  O   ILE A  99      -0.033  -4.251  -5.624  1.00 22.74           O  
ATOM    662  CB  ILE A  99      -2.212  -5.814  -6.716  1.00 22.88           C  
ATOM    663  CG1 ILE A  99      -2.969  -7.084  -7.101  1.00 23.44           C  
ATOM    664  CG2 ILE A  99      -2.889  -4.582  -7.307  1.00 25.38           C  
ATOM    665  CD1 ILE A  99      -4.310  -7.214  -6.402  1.00 28.84           C  
ATOM    666  N   ARG A 100       0.638  -4.024  -7.759  1.00 23.64           N  
ATOM    667  CA  ARG A 100       1.393  -2.808  -7.520  1.00 24.23           C  
ATOM    668  C   ARG A 100       0.531  -1.591  -7.823  1.00 24.80           C  
ATOM    669  O   ARG A 100       0.047  -1.435  -8.944  1.00 26.43           O  
ATOM    670  CB  ARG A 100       2.629  -2.800  -8.418  1.00 29.27           C  
ATOM    671  CG  ARG A 100       3.382  -1.485  -8.468  1.00 39.19           C  
ATOM    672  CD  ARG A 100       4.204  -1.239  -7.209  1.00 44.62           C  
ATOM    673  NE  ARG A 100       5.216  -0.213  -7.438  1.00 51.69           N  
ATOM    674  CZ  ARG A 100       4.945   1.051  -7.736  1.00 55.09           C  
ATOM    675  NH1 ARG A 100       3.686   1.453  -7.839  1.00 60.77           N  
ATOM    676  NH2 ARG A 100       5.928   1.914  -7.947  1.00 58.77           N  
ATOM    677  N   ALA A 101       0.326  -0.738  -6.826  1.00 22.35           N  
ATOM    678  CA  ALA A 101      -0.457   0.472  -7.029  1.00 24.53           C  
ATOM    679  C   ALA A 101       0.476   1.592  -7.470  1.00 27.61           C  
ATOM    680  O   ALA A 101       1.429   1.907  -6.768  1.00 26.36           O  
ATOM    681  CB  ALA A 101      -1.149   0.869  -5.748  1.00 25.07           C  
ATOM    682  N   ASP A 102       0.218   2.187  -8.630  1.00 25.85           N  
ATOM    683  CA  ASP A 102       1.056   3.291  -9.077  1.00 28.02           C  
ATOM    684  C   ASP A 102       0.522   4.576  -8.461  1.00 27.78           C  
ATOM    685  O   ASP A 102       1.286   5.475  -8.107  1.00 27.86           O  
ATOM    686  CB  ASP A 102       1.056   3.407 -10.608  1.00 26.77           C  
ATOM    687  CG  ASP A 102       1.949   2.373 -11.269  1.00 30.75           C  
ATOM    688  OD1 ASP A 102       3.014   2.063 -10.694  1.00 29.78           O  
ATOM    689  OD2 ASP A 102       1.602   1.873 -12.362  1.00 30.20           O  
ATOM    690  N   PHE A 103      -0.798   4.637  -8.311  1.00 21.99           N  
ATOM    691  CA  PHE A 103      -1.470   5.803  -7.757  1.00 21.33           C  
ATOM    692  C   PHE A 103      -2.642   5.395  -6.869  1.00 21.15           C  
ATOM    693  O   PHE A 103      -3.282   4.377  -7.108  1.00 21.81           O  
ATOM    694  CB  PHE A 103      -2.049   6.660  -8.884  1.00 25.77           C  
ATOM    695  CG  PHE A 103      -1.022   7.236  -9.812  1.00 24.32           C  
ATOM    696  CD1 PHE A 103      -0.314   8.376  -9.460  1.00 25.03           C  
ATOM    697  CD2 PHE A 103      -0.787   6.652 -11.054  1.00 25.68           C  
ATOM    698  CE1 PHE A 103       0.616   8.936 -10.337  1.00 28.24           C  
ATOM    699  CE2 PHE A 103       0.138   7.201 -11.937  1.00 29.03           C  
ATOM    700  CZ  PHE A 103       0.838   8.346 -11.575  1.00 28.26           C  
ATOM    701  N   LEU A 104      -2.919   6.203  -5.856  1.00 19.50           N  
ATOM    702  CA  LEU A 104      -4.058   5.976  -4.981  1.00 24.59           C  
ATOM    703  C   LEU A 104      -4.715   7.327  -4.790  1.00 25.01           C  
ATOM    704  O   LEU A 104      -4.034   8.346  -4.656  1.00 24.45           O  
ATOM    705  CB  LEU A 104      -3.644   5.408  -3.618  1.00 23.55           C  
ATOM    706  CG  LEU A 104      -4.830   5.242  -2.649  1.00 26.77           C  
ATOM    707  CD1 LEU A 104      -4.569   4.086  -1.696  1.00 26.11           C  
ATOM    708  CD2 LEU A 104      -5.075   6.536  -1.886  1.00 25.80           C  
ATOM    709  N   ASP A 105      -6.042   7.333  -4.808  1.00 22.39           N  
ATOM    710  CA  ASP A 105      -6.814   8.546  -4.614  1.00 23.98           C  
ATOM    711  C   ASP A 105      -7.969   8.250  -3.673  1.00 23.96           C  
ATOM    712  O   ASP A 105      -8.761   7.348  -3.931  1.00 23.49           O  
ATOM    713  CB  ASP A 105      -7.383   9.036  -5.945  1.00 26.33           C  
ATOM    714  CG  ASP A 105      -6.331   9.659  -6.831  1.00 30.12           C  
ATOM    715  OD1 ASP A 105      -5.932  10.808  -6.550  1.00 28.76           O  
ATOM    716  OD2 ASP A 105      -5.906   8.997  -7.798  1.00 31.20           O  
ATOM    717  N   PRO A 106      -8.067   8.987  -2.557  1.00 25.69           N  
ATOM    718  CA  PRO A 106      -9.163   8.767  -1.608  1.00 26.50           C  
ATOM    719  C   PRO A 106     -10.447   9.250  -2.280  1.00 28.09           C  
ATOM    720  O   PRO A 106     -10.409  10.161  -3.113  1.00 25.35           O  
ATOM    721  CB  PRO A 106      -8.770   9.629  -0.411  1.00 26.98           C  
ATOM    722  CG  PRO A 106      -7.964  10.736  -1.044  1.00 31.47           C  
ATOM    723  CD  PRO A 106      -7.122   9.995  -2.048  1.00 28.76           C  
ATOM    724  N   LEU A 107     -11.571   8.633  -1.931  1.00 25.28           N  
ATOM    725  CA  LEU A 107     -12.854   8.997  -2.523  1.00 27.05           C  
ATOM    726  C   LEU A 107     -13.915   9.307  -1.469  1.00 26.37           C  
ATOM    727  O   LEU A 107     -13.904   8.737  -0.376  1.00 27.36           O  
ATOM    728  CB  LEU A 107     -13.361   7.859  -3.416  1.00 24.41           C  
ATOM    729  CG  LEU A 107     -12.438   7.311  -4.509  1.00 26.66           C  
ATOM    730  CD1 LEU A 107     -13.098   6.106  -5.183  1.00 24.84           C  
ATOM    731  CD2 LEU A 107     -12.139   8.401  -5.530  1.00 21.99           C  
ATOM    732  N   ASP A 108     -14.819  10.219  -1.817  1.00 24.60           N  
ATOM    733  CA  ASP A 108     -15.937  10.622  -0.963  1.00 27.04           C  
ATOM    734  C   ASP A 108     -16.840   9.389  -0.862  1.00 26.53           C  
ATOM    735  O   ASP A 108     -17.008   8.672  -1.850  1.00 22.98           O  
ATOM    736  CB  ASP A 108     -16.702  11.757  -1.649  1.00 29.56           C  
ATOM    737  CG  ASP A 108     -17.789  12.364  -0.773  1.00 32.77           C  
ATOM    738  OD1 ASP A 108     -18.239  11.712   0.192  1.00 35.22           O  
ATOM    739  OD2 ASP A 108     -18.203  13.504  -1.069  1.00 36.02           O  
ATOM    740  N   ASP A 109     -17.417   9.116   0.308  1.00 26.47           N  
ATOM    741  CA  ASP A 109     -18.283   7.944   0.399  1.00 26.45           C  
ATOM    742  C   ASP A 109     -19.766   8.301   0.355  1.00 26.46           C  
ATOM    743  O   ASP A 109     -20.615   7.454   0.618  1.00 26.82           O  
ATOM    744  CB  ASP A 109     -17.974   7.103   1.654  1.00 28.93           C  
ATOM    745  CG  ASP A 109     -18.283   7.826   2.953  1.00 29.92           C  
ATOM    746  OD1 ASP A 109     -18.979   8.860   2.928  1.00 28.26           O  
ATOM    747  OD2 ASP A 109     -17.831   7.343   4.012  1.00 31.08           O  
ATOM    748  N   ARG A 110     -20.074   9.551   0.015  1.00 27.30           N  
ATOM    749  CA  ARG A 110     -21.470   9.989  -0.078  1.00 27.44           C  
ATOM    750  C   ARG A 110     -22.225   9.097  -1.053  1.00 27.21           C  
ATOM    751  O   ARG A 110     -21.810   8.920  -2.196  1.00 26.65           O  
ATOM    752  CB  ARG A 110     -21.561  11.442  -0.558  1.00 26.85           C  
ATOM    753  CG  ARG A 110     -22.998  11.910  -0.856  1.00 29.19           C  
ATOM    754  CD  ARG A 110     -23.054  13.396  -1.199  1.00 29.68           C  
ATOM    755  NE  ARG A 110     -22.379  13.720  -2.454  1.00 28.68           N  
ATOM    756  CZ  ARG A 110     -22.909  13.558  -3.665  1.00 29.79           C  
ATOM    757  NH1 ARG A 110     -24.135  13.070  -3.798  1.00 29.01           N  
ATOM    758  NH2 ARG A 110     -22.214  13.892  -4.744  1.00 24.27           N  
ATOM    759  N   GLY A 111     -23.332   8.528  -0.590  1.00 28.51           N  
ATOM    760  CA  GLY A 111     -24.136   7.664  -1.435  1.00 29.60           C  
ATOM    761  C   GLY A 111     -23.612   6.249  -1.592  1.00 32.13           C  
ATOM    762  O   GLY A 111     -24.216   5.445  -2.302  1.00 33.09           O  
ATOM    763  N   LYS A 112     -22.497   5.935  -0.939  1.00 29.38           N  
ATOM    764  CA  LYS A 112     -21.905   4.601  -1.026  1.00 31.38           C  
ATOM    765  C   LYS A 112     -22.210   3.758   0.205  1.00 29.79           C  
ATOM    766  O   LYS A 112     -22.361   4.285   1.302  1.00 30.77           O  
ATOM    767  CB  LYS A 112     -20.385   4.705  -1.200  1.00 34.42           C  
ATOM    768  CG  LYS A 112     -19.914   4.862  -2.642  1.00 38.87           C  
ATOM    769  CD  LYS A 112     -20.545   6.056  -3.332  1.00 40.25           C  
ATOM    770  CE  LYS A 112     -20.080   6.152  -4.776  1.00 41.31           C  
ATOM    771  NZ  LYS A 112     -20.624   7.350  -5.470  1.00 41.65           N  
ATOM    772  N   GLU A 113     -22.279   2.443   0.022  1.00 30.86           N  
ATOM    773  CA  GLU A 113     -22.568   1.538   1.127  1.00 33.34           C  
ATOM    774  C   GLU A 113     -21.502   0.476   1.342  1.00 31.88           C  
ATOM    775  O   GLU A 113     -20.958  -0.087   0.391  1.00 31.13           O  
ATOM    776  CB  GLU A 113     -23.913   0.838   0.913  1.00 35.32           C  
ATOM    777  CG  GLU A 113     -25.112   1.760   0.951  1.00 42.40           C  
ATOM    778  CD  GLU A 113     -26.412   0.994   1.094  1.00 47.93           C  
ATOM    779  OE1 GLU A 113     -26.690   0.124   0.239  1.00 46.78           O  
ATOM    780  OE2 GLU A 113     -27.154   1.262   2.066  1.00 52.26           O  
ATOM    781  N   ARG A 114     -21.222   0.193   2.606  1.00 29.83           N  
ATOM    782  CA  ARG A 114     -20.230  -0.809   2.951  1.00 28.79           C  
ATOM    783  C   ARG A 114     -20.894  -2.000   3.627  1.00 33.97           C  
ATOM    784  O   ARG A 114     -21.894  -1.848   4.327  1.00 31.10           O  
ATOM    785  CB  ARG A 114     -19.195  -0.220   3.909  1.00 27.88           C  
ATOM    786  CG  ARG A 114     -18.454   1.012   3.397  1.00 25.79           C  
ATOM    787  CD  ARG A 114     -17.491   1.506   4.468  1.00 27.32           C  
ATOM    788  NE  ARG A 114     -16.741   2.711   4.109  1.00 24.76           N  
ATOM    789  CZ  ARG A 114     -17.251   3.939   4.040  1.00 27.51           C  
ATOM    790  NH1 ARG A 114     -18.541   4.161   4.293  1.00 22.87           N  
ATOM    791  NH2 ARG A 114     -16.456   4.963   3.758  1.00 24.98           N  
ATOM    792  N   ALA A 115     -20.341  -3.182   3.396  1.00 33.40           N  
ATOM    793  CA  ALA A 115     -20.825  -4.397   4.030  1.00 38.81           C  
ATOM    794  C   ALA A 115     -19.751  -4.682   5.079  1.00 41.23           C  
ATOM    795  O   ALA A 115     -18.650  -4.130   5.001  1.00 41.48           O  
ATOM    796  CB  ALA A 115     -20.898  -5.529   3.022  1.00 37.22           C  
ATOM    797  N   GLU A 116     -20.059  -5.516   6.067  1.00 42.63           N  
ATOM    798  CA  GLU A 116     -19.080  -5.832   7.104  1.00 44.09           C  
ATOM    799  C   GLU A 116     -18.898  -7.339   7.217  1.00 43.89           C  
ATOM    800  O   GLU A 116     -19.872  -8.071   7.385  1.00 43.42           O  
ATOM    801  CB  GLU A 116     -19.539  -5.263   8.449  1.00 48.56           C  
ATOM    802  CG  GLU A 116     -18.550  -5.466   9.583  1.00 53.58           C  
ATOM    803  CD  GLU A 116     -19.043  -4.891  10.899  1.00 57.20           C  
ATOM    804  OE1 GLU A 116     -19.398  -3.694  10.926  1.00 59.27           O  
ATOM    805  OE2 GLU A 116     -19.074  -5.633  11.906  1.00 58.74           O  
ATOM    806  N   ASP A 117     -17.655  -7.804   7.119  1.00 41.61           N  
ATOM    807  CA  ASP A 117     -17.391  -9.235   7.214  1.00 42.89           C  
ATOM    808  C   ASP A 117     -17.382  -9.715   8.663  1.00 42.45           C  
ATOM    809  O   ASP A 117     -17.489  -8.917   9.599  1.00 38.78           O  
ATOM    810  CB  ASP A 117     -16.060  -9.605   6.538  1.00 41.87           C  
ATOM    811  CG  ASP A 117     -14.866  -8.884   7.143  1.00 43.05           C  
ATOM    812  OD1 ASP A 117     -14.894  -8.575   8.350  1.00 39.24           O  
ATOM    813  OD2 ASP A 117     -13.885  -8.640   6.407  1.00 45.70           O  
ATOM    814  N   SER A 118     -17.246 -11.025   8.833  1.00 45.23           N  
ATOM    815  CA  SER A 118     -17.234 -11.654  10.151  1.00 47.53           C  
ATOM    816  C   SER A 118     -16.170 -11.098  11.090  1.00 48.84           C  
ATOM    817  O   SER A 118     -16.277 -11.252  12.312  1.00 48.29           O  
ATOM    818  CB  SER A 118     -17.029 -13.162  10.001  1.00 49.26           C  
ATOM    819  OG  SER A 118     -15.769 -13.444   9.420  1.00 53.15           O  
ATOM    820  N   ARG A 119     -15.149 -10.455  10.526  1.00 47.09           N  
ATOM    821  CA  ARG A 119     -14.065  -9.894  11.328  1.00 45.80           C  
ATOM    822  C   ARG A 119     -14.242  -8.405  11.600  1.00 43.93           C  
ATOM    823  O   ARG A 119     -13.344  -7.752  12.131  1.00 41.97           O  
ATOM    824  CB  ARG A 119     -12.719 -10.127  10.638  1.00 50.86           C  
ATOM    825  CG  ARG A 119     -12.350 -11.593  10.473  1.00 57.02           C  
ATOM    826  CD  ARG A 119     -10.955 -11.754   9.885  1.00 61.61           C  
ATOM    827  NE  ARG A 119     -10.849 -11.185   8.543  1.00 67.56           N  
ATOM    828  CZ  ARG A 119     -11.560 -11.594   7.496  1.00 70.13           C  
ATOM    829  NH1 ARG A 119     -12.436 -12.582   7.629  1.00 71.77           N  
ATOM    830  NH2 ARG A 119     -11.396 -11.017   6.312  1.00 71.27           N  
ATOM    831  N   GLY A 120     -15.403  -7.870  11.239  1.00 41.08           N  
ATOM    832  CA  GLY A 120     -15.656  -6.458  11.460  1.00 39.88           C  
ATOM    833  C   GLY A 120     -14.981  -5.553  10.441  1.00 39.02           C  
ATOM    834  O   GLY A 120     -14.905  -4.342  10.643  1.00 40.98           O  
ATOM    835  N   GLN A 121     -14.494  -6.129   9.345  1.00 36.26           N  
ATOM    836  CA  GLN A 121     -13.829  -5.345   8.309  1.00 33.36           C  
ATOM    837  C   GLN A 121     -14.811  -4.911   7.226  1.00 32.09           C  
ATOM    838  O   GLN A 121     -15.650  -5.695   6.784  1.00 33.20           O  
ATOM    839  CB  GLN A 121     -12.704  -6.154   7.666  1.00 34.80           C  
ATOM    840  CG  GLN A 121     -11.679  -6.689   8.641  1.00 38.81           C  
ATOM    841  CD  GLN A 121     -10.629  -7.537   7.955  1.00 40.26           C  
ATOM    842  OE1 GLN A 121     -10.951  -8.442   7.185  1.00 43.38           O  
ATOM    843  NE2 GLN A 121      -9.368  -7.254   8.236  1.00 42.03           N  
ATOM    844  N   PRO A 122     -14.711  -3.652   6.777  1.00 31.69           N  
ATOM    845  CA  PRO A 122     -15.608  -3.141   5.737  1.00 30.31           C  
ATOM    846  C   PRO A 122     -15.254  -3.574   4.316  1.00 31.48           C  
ATOM    847  O   PRO A 122     -14.083  -3.750   3.978  1.00 33.07           O  
ATOM    848  CB  PRO A 122     -15.509  -1.630   5.919  1.00 29.04           C  
ATOM    849  CG  PRO A 122     -14.087  -1.443   6.326  1.00 27.93           C  
ATOM    850  CD  PRO A 122     -13.893  -2.564   7.343  1.00 31.18           C  
ATOM    851  N   ARG A 123     -16.290  -3.761   3.502  1.00 32.33           N  
ATOM    852  CA  ARG A 123     -16.149  -4.123   2.092  1.00 32.49           C  
ATOM    853  C   ARG A 123     -17.100  -3.205   1.331  1.00 31.72           C  
ATOM    854  O   ARG A 123     -18.265  -3.055   1.715  1.00 29.82           O  
ATOM    855  CB  ARG A 123     -16.559  -5.578   1.835  1.00 36.53           C  
ATOM    856  CG  ARG A 123     -15.669  -6.622   2.474  1.00 43.55           C  
ATOM    857  CD  ARG A 123     -15.940  -7.995   1.880  1.00 45.97           C  
ATOM    858  NE  ARG A 123     -17.363  -8.327   1.881  1.00 50.54           N  
ATOM    859  CZ  ARG A 123     -17.840  -9.565   1.797  1.00 54.00           C  
ATOM    860  NH1 ARG A 123     -17.006 -10.594   1.707  1.00 55.30           N  
ATOM    861  NH2 ARG A 123     -19.149  -9.778   1.807  1.00 55.07           N  
ATOM    862  N   LEU A 124     -16.610  -2.588   0.261  1.00 26.65           N  
ATOM    863  CA  LEU A 124     -17.446  -1.691  -0.534  1.00 25.62           C  
ATOM    864  C   LEU A 124     -18.396  -2.473  -1.441  1.00 22.32           C  
ATOM    865  O   LEU A 124     -17.971  -3.352  -2.195  1.00 23.10           O  
ATOM    866  CB  LEU A 124     -16.574  -0.764  -1.401  1.00 21.57           C  
ATOM    867  CG  LEU A 124     -17.313   0.219  -2.326  1.00 23.17           C  
ATOM    868  CD1 LEU A 124     -18.120   1.226  -1.501  1.00 19.09           C  
ATOM    869  CD2 LEU A 124     -16.301   0.956  -3.204  1.00 21.69           C  
ATOM    870  N   ARG A 125     -19.685  -2.148  -1.367  1.00 24.71           N  
ATOM    871  CA  ARG A 125     -20.674  -2.802  -2.215  1.00 24.65           C  
ATOM    872  C   ARG A 125     -20.608  -2.111  -3.578  1.00 22.44           C  
ATOM    873  O   ARG A 125     -20.342  -0.915  -3.648  1.00 23.23           O  
ATOM    874  CB  ARG A 125     -22.073  -2.655  -1.615  1.00 30.15           C  
ATOM    875  CG  ARG A 125     -22.168  -3.162  -0.180  1.00 34.96           C  
ATOM    876  CD  ARG A 125     -23.599  -3.154   0.331  1.00 46.03           C  
ATOM    877  NE  ARG A 125     -24.415  -4.160  -0.340  1.00 54.51           N  
ATOM    878  CZ  ARG A 125     -25.696  -4.384  -0.069  1.00 60.84           C  
ATOM    879  NH1 ARG A 125     -26.312  -3.670   0.868  1.00 62.92           N  
ATOM    880  NH2 ARG A 125     -26.362  -5.322  -0.731  1.00 62.21           N  
ATOM    881  N   ALA A 126     -20.839  -2.864  -4.651  1.00 25.67           N  
ATOM    882  CA  ALA A 126     -20.785  -2.315  -6.012  1.00 25.86           C  
ATOM    883  C   ALA A 126     -19.403  -1.704  -6.278  1.00 26.74           C  
ATOM    884  O   ALA A 126     -19.283  -0.630  -6.880  1.00 28.29           O  
ATOM    885  CB  ALA A 126     -21.878  -1.253  -6.203  1.00 24.54           C  
ATOM    886  N   ALA A 127     -18.364  -2.406  -5.835  1.00 23.50           N  
ATOM    887  CA  ALA A 127     -16.984  -1.951  -5.999  1.00 23.77           C  
ATOM    888  C   ALA A 127     -16.488  -2.080  -7.441  1.00 23.83           C  
ATOM    889  O   ALA A 127     -17.189  -2.591  -8.315  1.00 21.53           O  
ATOM    890  CB  ALA A 127     -16.062  -2.757  -5.064  1.00 18.14           C  
ATOM    891  N   LEU A 128     -15.271  -1.603  -7.684  1.00 21.57           N  
ATOM    892  CA  LEU A 128     -14.671  -1.706  -9.009  1.00 20.63           C  
ATOM    893  C   LEU A 128     -13.491  -2.660  -8.917  1.00 22.30           C  
ATOM    894  O   LEU A 128     -12.645  -2.528  -8.029  1.00 18.56           O  
ATOM    895  CB  LEU A 128     -14.185  -0.337  -9.511  1.00 19.75           C  
ATOM    896  CG  LEU A 128     -13.401  -0.407 -10.831  1.00 21.55           C  
ATOM    897  CD1 LEU A 128     -14.301  -0.940 -11.940  1.00 22.24           C  
ATOM    898  CD2 LEU A 128     -12.863   0.975 -11.200  1.00 20.80           C  
ATOM    899  N   ASN A 129     -13.453  -3.624  -9.830  1.00 21.01           N  
ATOM    900  CA  ASN A 129     -12.392  -4.621  -9.895  1.00 21.90           C  
ATOM    901  C   ASN A 129     -12.264  -4.968 -11.363  1.00 23.44           C  
ATOM    902  O   ASN A 129     -12.928  -5.878 -11.861  1.00 20.58           O  
ATOM    903  CB  ASN A 129     -12.774  -5.867  -9.079  1.00 22.50           C  
ATOM    904  CG  ASN A 129     -11.691  -6.935  -9.088  1.00 26.02           C  
ATOM    905  OD1 ASN A 129     -10.705  -6.842  -9.823  1.00 25.47           O  
ATOM    906  ND2 ASN A 129     -11.880  -7.971  -8.274  1.00 26.25           N  
ATOM    907  N   GLN A 130     -11.404  -4.235 -12.065  1.00 22.33           N  
ATOM    908  CA  GLN A 130     -11.235  -4.457 -13.491  1.00 20.29           C  
ATOM    909  C   GLN A 130      -9.769  -4.441 -13.906  1.00 19.52           C  
ATOM    910  O   GLN A 130      -9.025  -3.553 -13.513  1.00 22.96           O  
ATOM    911  CB  GLN A 130     -11.993  -3.367 -14.254  1.00 22.78           C  
ATOM    912  CG  GLN A 130     -12.050  -3.568 -15.757  1.00 26.29           C  
ATOM    913  CD  GLN A 130     -12.918  -2.527 -16.451  1.00 29.95           C  
ATOM    914  OE1 GLN A 130     -13.250  -2.667 -17.625  1.00 40.28           O  
ATOM    915  NE2 GLN A 130     -13.280  -1.478 -15.729  1.00 34.57           N  
ATOM    916  N   VAL A 131      -9.367  -5.421 -14.704  1.00 20.04           N  
ATOM    917  CA  VAL A 131      -7.988  -5.492 -15.184  1.00 22.51           C  
ATOM    918  C   VAL A 131      -7.960  -5.718 -16.690  1.00 23.41           C  
ATOM    919  O   VAL A 131      -8.778  -6.466 -17.234  1.00 22.63           O  
ATOM    920  CB  VAL A 131      -7.201  -6.641 -14.493  1.00 23.15           C  
ATOM    921  CG1 VAL A 131      -7.836  -7.979 -14.819  1.00 21.94           C  
ATOM    922  CG2 VAL A 131      -5.743  -6.629 -14.954  1.00 23.58           C  
ATOM    923  N   PHE A 132      -7.025  -5.049 -17.360  1.00 19.43           N  
ATOM    924  CA  PHE A 132      -6.840  -5.180 -18.800  1.00 20.60           C  
ATOM    925  C   PHE A 132      -5.492  -5.855 -19.004  1.00 20.97           C  
ATOM    926  O   PHE A 132      -4.473  -5.363 -18.513  1.00 22.09           O  
ATOM    927  CB  PHE A 132      -6.792  -3.802 -19.468  1.00 20.26           C  
ATOM    928  CG  PHE A 132      -8.103  -3.092 -19.497  1.00 22.94           C  
ATOM    929  CD1 PHE A 132      -8.914  -3.154 -20.623  1.00 24.38           C  
ATOM    930  CD2 PHE A 132      -8.526  -2.345 -18.407  1.00 22.75           C  
ATOM    931  CE1 PHE A 132     -10.130  -2.473 -20.660  1.00 23.57           C  
ATOM    932  CE2 PHE A 132      -9.741  -1.663 -18.437  1.00 27.69           C  
ATOM    933  CZ  PHE A 132     -10.540  -1.729 -19.568  1.00 25.54           C  
ATOM    934  N   LEU A 133      -5.473  -6.959 -19.736  1.00 19.52           N  
ATOM    935  CA  LEU A 133      -4.229  -7.670 -19.987  1.00 21.34           C  
ATOM    936  C   LEU A 133      -4.132  -8.129 -21.429  1.00 22.47           C  
ATOM    937  O   LEU A 133      -5.141  -8.419 -22.070  1.00 22.44           O  
ATOM    938  CB  LEU A 133      -4.121  -8.915 -19.092  1.00 22.47           C  
ATOM    939  CG  LEU A 133      -4.010  -8.766 -17.574  1.00 23.97           C  
ATOM    940  CD1 LEU A 133      -4.130 -10.147 -16.930  1.00 25.63           C  
ATOM    941  CD2 LEU A 133      -2.679  -8.122 -17.211  1.00 26.40           C  
HETATM  942  N   MSE A 134      -2.907  -8.191 -21.939  1.00 20.55           N  
HETATM  943  CA  MSE A 134      -2.676  -8.685 -23.284  1.00 19.99           C  
HETATM  944  C   MSE A 134      -1.287  -9.293 -23.326  1.00 22.87           C  
HETATM  945  O   MSE A 134      -0.328  -8.711 -22.814  1.00 22.04           O  
HETATM  946  CB  MSE A 134      -2.804  -7.572 -24.332  1.00 21.10           C  
HETATM  947  CG  MSE A 134      -2.622  -8.072 -25.765  1.00 22.83           C  
HETATM  948 SE   MSE A 134      -3.467  -6.877 -27.102  1.00 32.11          SE  
HETATM  949  CE  MSE A 134      -3.044  -5.220 -26.271  1.00 22.65           C  
ATOM    950  N   GLY A 135      -1.201 -10.474 -23.926  1.00 21.99           N  
ATOM    951  CA  GLY A 135       0.054 -11.187 -24.030  1.00 22.58           C  
ATOM    952  C   GLY A 135      -0.160 -12.402 -24.906  1.00 22.41           C  
ATOM    953  O   GLY A 135      -1.016 -12.386 -25.799  1.00 25.19           O  
ATOM    954  N   ASN A 136       0.614 -13.455 -24.668  1.00 22.79           N  
ATOM    955  CA  ASN A 136       0.493 -14.683 -25.442  1.00 24.18           C  
ATOM    956  C   ASN A 136       0.343 -15.880 -24.505  1.00 25.70           C  
ATOM    957  O   ASN A 136       0.849 -15.866 -23.387  1.00 24.11           O  
ATOM    958  CB  ASN A 136       1.730 -14.877 -26.321  1.00 29.28           C  
ATOM    959  CG  ASN A 136       1.853 -13.812 -27.398  1.00 28.46           C  
ATOM    960  OD1 ASN A 136       1.466 -14.024 -28.547  1.00 35.32           O  
ATOM    961  ND2 ASN A 136       2.378 -12.656 -27.023  1.00 29.26           N  
ATOM    962  N   LEU A 137      -0.354 -16.911 -24.971  1.00 24.22           N  
ATOM    963  CA  LEU A 137      -0.558 -18.116 -24.175  1.00 26.66           C  
ATOM    964  C   LEU A 137       0.737 -18.903 -24.047  1.00 27.27           C  
ATOM    965  O   LEU A 137       1.458 -19.111 -25.028  1.00 25.05           O  
ATOM    966  CB  LEU A 137      -1.632 -19.008 -24.811  1.00 25.98           C  
ATOM    967  CG  LEU A 137      -3.060 -18.460 -24.846  1.00 29.33           C  
ATOM    968  CD1 LEU A 137      -3.994 -19.510 -25.462  1.00 30.69           C  
ATOM    969  CD2 LEU A 137      -3.512 -18.115 -23.431  1.00 30.30           C  
ATOM    970  N   THR A 138       1.022 -19.337 -22.825  1.00 29.43           N  
ATOM    971  CA  THR A 138       2.222 -20.106 -22.537  1.00 28.99           C  
ATOM    972  C   THR A 138       1.980 -21.593 -22.747  1.00 30.47           C  
ATOM    973  O   THR A 138       2.924 -22.389 -22.729  1.00 26.98           O  
ATOM    974  CB  THR A 138       2.669 -19.894 -21.089  1.00 30.56           C  
ATOM    975  OG1 THR A 138       1.598 -20.252 -20.206  1.00 26.64           O  
ATOM    976  CG2 THR A 138       3.041 -18.434 -20.857  1.00 32.01           C  
ATOM    977  N   ARG A 139       0.715 -21.963 -22.944  1.00 26.83           N  
ATOM    978  CA  ARG A 139       0.338 -23.361 -23.153  1.00 27.61           C  
ATOM    979  C   ARG A 139      -1.080 -23.436 -23.725  1.00 28.81           C  
ATOM    980  O   ARG A 139      -1.790 -22.430 -23.763  1.00 28.03           O  
ATOM    981  CB  ARG A 139       0.407 -24.124 -21.821  1.00 29.28           C  
ATOM    982  CG  ARG A 139      -0.524 -23.582 -20.736  1.00 30.19           C  
ATOM    983  CD  ARG A 139      -0.412 -24.379 -19.428  1.00 31.47           C  
ATOM    984  NE  ARG A 139      -1.487 -24.043 -18.491  1.00 32.17           N  
ATOM    985  CZ  ARG A 139      -1.423 -23.087 -17.565  1.00 32.33           C  
ATOM    986  NH1 ARG A 139      -0.327 -22.353 -17.426  1.00 29.34           N  
ATOM    987  NH2 ARG A 139      -2.469 -22.858 -16.779  1.00 32.20           N  
ATOM    988  N   ASP A 140      -1.490 -24.616 -24.184  1.00 30.15           N  
ATOM    989  CA  ASP A 140      -2.839 -24.771 -24.721  1.00 31.81           C  
ATOM    990  C   ASP A 140      -3.838 -24.633 -23.583  1.00 31.42           C  
ATOM    991  O   ASP A 140      -3.517 -24.925 -22.431  1.00 31.37           O  
ATOM    992  CB  ASP A 140      -3.024 -26.138 -25.375  1.00 33.44           C  
ATOM    993  CG  ASP A 140      -2.155 -26.321 -26.597  1.00 37.41           C  
ATOM    994  OD1 ASP A 140      -1.961 -25.334 -27.339  1.00 36.61           O  
ATOM    995  OD2 ASP A 140      -1.682 -27.454 -26.821  1.00 40.35           O  
ATOM    996  N   PRO A 141      -5.060 -24.176 -23.889  1.00 29.83           N  
ATOM    997  CA  PRO A 141      -6.088 -24.014 -22.857  1.00 30.49           C  
ATOM    998  C   PRO A 141      -6.412 -25.364 -22.219  1.00 32.31           C  
ATOM    999  O   PRO A 141      -6.263 -26.408 -22.849  1.00 32.74           O  
ATOM   1000  CB  PRO A 141      -7.286 -23.466 -23.636  1.00 31.43           C  
ATOM   1001  CG  PRO A 141      -6.660 -22.793 -24.820  1.00 32.04           C  
ATOM   1002  CD  PRO A 141      -5.572 -23.760 -25.204  1.00 31.78           C  
ATOM   1003  N   GLU A 142      -6.851 -25.332 -20.968  1.00 32.41           N  
ATOM   1004  CA  GLU A 142      -7.223 -26.543 -20.251  1.00 35.52           C  
ATOM   1005  C   GLU A 142      -8.693 -26.345 -19.907  1.00 33.44           C  
ATOM   1006  O   GLU A 142      -9.055 -25.384 -19.228  1.00 33.31           O  
ATOM   1007  CB  GLU A 142      -6.366 -26.682 -18.993  1.00 37.27           C  
ATOM   1008  CG  GLU A 142      -4.876 -26.598 -19.310  1.00 45.84           C  
ATOM   1009  CD  GLU A 142      -3.993 -26.448 -18.085  1.00 50.14           C  
ATOM   1010  OE1 GLU A 142      -4.360 -25.679 -17.164  1.00 50.48           O  
ATOM   1011  OE2 GLU A 142      -2.915 -27.086 -18.056  1.00 51.27           O  
ATOM   1012  N   LEU A 143      -9.538 -27.248 -20.391  1.00 32.32           N  
ATOM   1013  CA  LEU A 143     -10.974 -27.144 -20.163  1.00 32.54           C  
ATOM   1014  C   LEU A 143     -11.540 -28.314 -19.354  1.00 29.71           C  
ATOM   1015  O   LEU A 143     -11.139 -29.459 -19.540  1.00 29.24           O  
ATOM   1016  CB  LEU A 143     -11.686 -27.064 -21.524  1.00 35.79           C  
ATOM   1017  CG  LEU A 143     -13.166 -26.687 -21.626  1.00 41.57           C  
ATOM   1018  CD1 LEU A 143     -13.353 -25.223 -21.269  1.00 39.22           C  
ATOM   1019  CD2 LEU A 143     -13.654 -26.937 -23.053  1.00 44.17           C  
ATOM   1020  N   ARG A 144     -12.459 -28.009 -18.445  1.00 27.65           N  
ATOM   1021  CA  ARG A 144     -13.119 -29.033 -17.641  1.00 28.83           C  
ATOM   1022  C   ARG A 144     -14.580 -28.635 -17.519  1.00 29.17           C  
ATOM   1023  O   ARG A 144     -14.944 -27.491 -17.804  1.00 27.71           O  
ATOM   1024  CB  ARG A 144     -12.494 -29.144 -16.244  1.00 25.59           C  
ATOM   1025  CG  ARG A 144     -12.776 -27.973 -15.321  1.00 25.39           C  
ATOM   1026  CD  ARG A 144     -12.157 -28.213 -13.952  1.00 28.63           C  
ATOM   1027  NE  ARG A 144     -12.759 -29.362 -13.282  1.00 25.62           N  
ATOM   1028  CZ  ARG A 144     -13.829 -29.306 -12.496  1.00 25.98           C  
ATOM   1029  NH1 ARG A 144     -14.433 -28.153 -12.260  1.00 22.85           N  
ATOM   1030  NH2 ARG A 144     -14.299 -30.416 -11.939  1.00 31.44           N  
ATOM   1031  N   TYR A 145     -15.416 -29.574 -17.092  1.00 27.78           N  
ATOM   1032  CA  TYR A 145     -16.836 -29.308 -16.936  1.00 26.79           C  
ATOM   1033  C   TYR A 145     -17.296 -29.655 -15.528  1.00 26.00           C  
ATOM   1034  O   TYR A 145     -16.897 -30.680 -14.970  1.00 24.63           O  
ATOM   1035  CB  TYR A 145     -17.629 -30.122 -17.967  1.00 33.11           C  
ATOM   1036  CG  TYR A 145     -17.515 -29.576 -19.374  1.00 36.53           C  
ATOM   1037  CD1 TYR A 145     -18.406 -28.607 -19.835  1.00 36.10           C  
ATOM   1038  CD2 TYR A 145     -16.490 -29.990 -20.226  1.00 37.71           C  
ATOM   1039  CE1 TYR A 145     -18.283 -28.060 -21.109  1.00 40.53           C  
ATOM   1040  CE2 TYR A 145     -16.352 -29.446 -21.506  1.00 40.86           C  
ATOM   1041  CZ  TYR A 145     -17.254 -28.480 -21.938  1.00 42.14           C  
ATOM   1042  OH  TYR A 145     -17.126 -27.924 -23.192  1.00 44.42           O  
ATOM   1043  N   THR A 146     -18.111 -28.783 -14.951  1.00 23.91           N  
ATOM   1044  CA  THR A 146     -18.639 -29.009 -13.612  1.00 29.50           C  
ATOM   1045  C   THR A 146     -19.684 -30.118 -13.706  1.00 32.10           C  
ATOM   1046  O   THR A 146     -20.112 -30.484 -14.805  1.00 29.79           O  
ATOM   1047  CB  THR A 146     -19.333 -27.753 -13.063  1.00 31.98           C  
ATOM   1048  OG1 THR A 146     -20.546 -27.522 -13.792  1.00 33.03           O  
ATOM   1049  CG2 THR A 146     -18.419 -26.530 -13.199  1.00 33.47           C  
ATOM   1050  N   PRO A 147     -20.100 -30.677 -12.558  1.00 36.88           N  
ATOM   1051  CA  PRO A 147     -21.104 -31.745 -12.573  1.00 39.74           C  
ATOM   1052  C   PRO A 147     -22.350 -31.309 -13.340  1.00 41.50           C  
ATOM   1053  O   PRO A 147     -22.979 -32.111 -14.026  1.00 43.48           O  
ATOM   1054  CB  PRO A 147     -21.381 -31.969 -11.090  1.00 39.02           C  
ATOM   1055  CG  PRO A 147     -20.046 -31.721 -10.475  1.00 40.99           C  
ATOM   1056  CD  PRO A 147     -19.588 -30.462 -11.191  1.00 37.57           C  
ATOM   1057  N   GLN A 148     -22.687 -30.028 -13.224  1.00 43.85           N  
ATOM   1058  CA  GLN A 148     -23.851 -29.474 -13.904  1.00 45.69           C  
ATOM   1059  C   GLN A 148     -23.619 -29.215 -15.394  1.00 45.07           C  
ATOM   1060  O   GLN A 148     -24.511 -28.724 -16.087  1.00 47.38           O  
ATOM   1061  CB  GLN A 148     -24.284 -28.177 -13.218  1.00 49.53           C  
ATOM   1062  CG  GLN A 148     -24.842 -28.379 -11.821  1.00 54.57           C  
ATOM   1063  CD  GLN A 148     -25.229 -27.073 -11.156  1.00 57.41           C  
ATOM   1064  OE1 GLN A 148     -25.984 -26.275 -11.715  1.00 61.04           O  
ATOM   1065  NE2 GLN A 148     -24.717 -26.848  -9.951  1.00 58.85           N  
ATOM   1066  N   GLY A 149     -22.426 -29.534 -15.880  1.00 42.40           N  
ATOM   1067  CA  GLY A 149     -22.123 -29.344 -17.291  1.00 39.36           C  
ATOM   1068  C   GLY A 149     -21.587 -27.977 -17.694  1.00 37.52           C  
ATOM   1069  O   GLY A 149     -21.500 -27.673 -18.884  1.00 35.83           O  
ATOM   1070  N   THR A 150     -21.225 -27.150 -16.721  1.00 36.04           N  
ATOM   1071  CA  THR A 150     -20.696 -25.821 -17.022  1.00 35.25           C  
ATOM   1072  C   THR A 150     -19.234 -25.899 -17.460  1.00 34.69           C  
ATOM   1073  O   THR A 150     -18.416 -26.558 -16.812  1.00 30.75           O  
ATOM   1074  CB  THR A 150     -20.777 -24.902 -15.800  1.00 37.99           C  
ATOM   1075  OG1 THR A 150     -22.130 -24.851 -15.331  1.00 42.01           O  
ATOM   1076  CG2 THR A 150     -20.320 -23.494 -16.165  1.00 36.91           C  
ATOM   1077  N   ALA A 151     -18.906 -25.231 -18.564  1.00 30.50           N  
ATOM   1078  CA  ALA A 151     -17.533 -25.231 -19.063  1.00 28.62           C  
ATOM   1079  C   ALA A 151     -16.661 -24.261 -18.266  1.00 24.72           C  
ATOM   1080  O   ALA A 151     -17.110 -23.185 -17.856  1.00 23.75           O  
ATOM   1081  CB  ALA A 151     -17.508 -24.853 -20.541  1.00 25.75           C  
ATOM   1082  N   VAL A 152     -15.413 -24.651 -18.038  1.00 25.81           N  
ATOM   1083  CA  VAL A 152     -14.477 -23.803 -17.304  1.00 24.31           C  
ATOM   1084  C   VAL A 152     -13.125 -23.965 -17.963  1.00 25.26           C  
ATOM   1085  O   VAL A 152     -12.615 -25.078 -18.081  1.00 26.79           O  
ATOM   1086  CB  VAL A 152     -14.346 -24.211 -15.820  1.00 26.00           C  
ATOM   1087  CG1 VAL A 152     -13.634 -23.107 -15.048  1.00 24.97           C  
ATOM   1088  CG2 VAL A 152     -15.706 -24.482 -15.227  1.00 29.95           C  
ATOM   1089  N   ALA A 153     -12.555 -22.849 -18.403  1.00 24.92           N  
ATOM   1090  CA  ALA A 153     -11.264 -22.863 -19.074  1.00 22.47           C  
ATOM   1091  C   ALA A 153     -10.204 -22.200 -18.220  1.00 21.92           C  
ATOM   1092  O   ALA A 153     -10.470 -21.212 -17.539  1.00 21.88           O  
ATOM   1093  CB  ALA A 153     -11.367 -22.132 -20.420  1.00 23.52           C  
ATOM   1094  N   ARG A 154      -9.004 -22.763 -18.248  1.00 22.89           N  
ATOM   1095  CA  ARG A 154      -7.891 -22.199 -17.511  1.00 27.14           C  
ATOM   1096  C   ARG A 154      -6.775 -21.980 -18.521  1.00 23.54           C  
ATOM   1097  O   ARG A 154      -6.402 -22.890 -19.260  1.00 23.54           O  
ATOM   1098  CB  ARG A 154      -7.469 -23.133 -16.378  1.00 25.64           C  
ATOM   1099  CG  ARG A 154      -8.489 -23.138 -15.247  1.00 27.82           C  
ATOM   1100  CD  ARG A 154      -8.095 -24.072 -14.108  1.00 30.11           C  
ATOM   1101  NE  ARG A 154      -9.194 -24.246 -13.164  1.00 34.63           N  
ATOM   1102  CZ  ARG A 154      -9.658 -23.297 -12.362  1.00 36.00           C  
ATOM   1103  NH1 ARG A 154      -9.110 -22.090 -12.380  1.00 44.26           N  
ATOM   1104  NH2 ARG A 154     -10.683 -23.547 -11.556  1.00 27.45           N  
ATOM   1105  N   LEU A 155      -6.280 -20.748 -18.561  1.00 26.79           N  
ATOM   1106  CA  LEU A 155      -5.236 -20.344 -19.500  1.00 27.36           C  
ATOM   1107  C   LEU A 155      -4.012 -19.786 -18.778  1.00 25.15           C  
ATOM   1108  O   LEU A 155      -4.127 -19.238 -17.684  1.00 24.83           O  
ATOM   1109  CB  LEU A 155      -5.784 -19.251 -20.425  1.00 27.94           C  
ATOM   1110  CG  LEU A 155      -7.127 -19.471 -21.131  1.00 31.73           C  
ATOM   1111  CD1 LEU A 155      -7.720 -18.129 -21.541  1.00 34.51           C  
ATOM   1112  CD2 LEU A 155      -6.937 -20.365 -22.334  1.00 32.18           C  
ATOM   1113  N   GLY A 156      -2.846 -19.925 -19.408  1.00 24.57           N  
ATOM   1114  CA  GLY A 156      -1.611 -19.392 -18.851  1.00 23.98           C  
ATOM   1115  C   GLY A 156      -1.195 -18.256 -19.777  1.00 22.73           C  
ATOM   1116  O   GLY A 156      -0.989 -18.484 -20.970  1.00 24.07           O  
ATOM   1117  N   LEU A 157      -1.070 -17.045 -19.238  1.00 25.02           N  
ATOM   1118  CA  LEU A 157      -0.726 -15.869 -20.039  1.00 25.31           C  
ATOM   1119  C   LEU A 157       0.611 -15.225 -19.692  1.00 26.02           C  
ATOM   1120  O   LEU A 157       0.921 -15.009 -18.521  1.00 25.24           O  
ATOM   1121  CB  LEU A 157      -1.820 -14.806 -19.892  1.00 24.48           C  
ATOM   1122  CG  LEU A 157      -1.669 -13.555 -20.766  1.00 25.20           C  
ATOM   1123  CD1 LEU A 157      -1.957 -13.920 -22.218  1.00 25.59           C  
ATOM   1124  CD2 LEU A 157      -2.618 -12.467 -20.292  1.00 24.40           C  
ATOM   1125  N   ALA A 158       1.388 -14.899 -20.722  1.00 25.38           N  
ATOM   1126  CA  ALA A 158       2.679 -14.243 -20.536  1.00 24.28           C  
ATOM   1127  C   ALA A 158       2.560 -12.823 -21.068  1.00 24.08           C  
ATOM   1128  O   ALA A 158       2.312 -12.617 -22.263  1.00 25.42           O  
ATOM   1129  CB  ALA A 158       3.775 -14.998 -21.287  1.00 25.03           C  
ATOM   1130  N   VAL A 159       2.721 -11.849 -20.178  1.00 22.28           N  
ATOM   1131  CA  VAL A 159       2.629 -10.444 -20.546  1.00 27.19           C  
ATOM   1132  C   VAL A 159       3.995  -9.781 -20.489  1.00 30.07           C  
ATOM   1133  O   VAL A 159       4.621  -9.738 -19.433  1.00 30.29           O  
ATOM   1134  CB  VAL A 159       1.696  -9.662 -19.601  1.00 23.92           C  
ATOM   1135  CG1 VAL A 159       1.703  -8.182 -19.983  1.00 23.93           C  
ATOM   1136  CG2 VAL A 159       0.275 -10.226 -19.673  1.00 26.22           C  
ATOM   1137  N   ASN A 160       4.453  -9.260 -21.622  1.00 33.70           N  
ATOM   1138  CA  ASN A 160       5.751  -8.594 -21.666  1.00 37.97           C  
ATOM   1139  C   ASN A 160       5.597  -7.106 -21.385  1.00 40.60           C  
ATOM   1140  O   ASN A 160       4.568  -6.512 -21.702  1.00 41.22           O  
ATOM   1141  CB  ASN A 160       6.400  -8.786 -23.036  1.00 41.34           C  
ATOM   1142  CG  ASN A 160       6.647 -10.246 -23.362  1.00 45.57           C  
ATOM   1143  OD1 ASN A 160       7.292 -10.968 -22.595  1.00 42.53           O  
ATOM   1144  ND2 ASN A 160       6.138 -10.691 -24.510  1.00 47.39           N  
ATOM   1145  N   GLU A 161       6.615  -6.509 -20.771  1.00 42.48           N  
ATOM   1146  CA  GLU A 161       6.592  -5.079 -20.485  1.00 46.02           C  
ATOM   1147  C   GLU A 161       7.975  -4.490 -20.724  1.00 47.69           C  
ATOM   1148  O   GLU A 161       8.985  -5.056 -20.303  1.00 43.83           O  
ATOM   1149  CB  GLU A 161       6.160  -4.802 -19.042  1.00 48.02           C  
ATOM   1150  CG  GLU A 161       7.226  -5.057 -17.993  1.00 50.58           C  
ATOM   1151  CD  GLU A 161       7.038  -4.186 -16.764  1.00 52.65           C  
ATOM   1152  OE1 GLU A 161       7.057  -2.946 -16.909  1.00 55.03           O  
ATOM   1153  OE2 GLU A 161       6.870  -4.733 -15.656  1.00 51.49           O  
ATOM   1154  N   ARG A 162       8.010  -3.354 -21.411  1.00 52.03           N  
ATOM   1155  CA  ARG A 162       9.261  -2.673 -21.724  1.00 55.08           C  
ATOM   1156  C   ARG A 162       9.743  -1.870 -20.519  1.00 54.52           C  
ATOM   1157  O   ARG A 162       8.999  -1.062 -19.964  1.00 53.76           O  
ATOM   1158  CB  ARG A 162       9.058  -1.737 -22.919  1.00 59.16           C  
ATOM   1159  CG  ARG A 162       8.598  -2.435 -24.191  1.00 63.15           C  
ATOM   1160  CD  ARG A 162       8.259  -1.424 -25.278  1.00 67.94           C  
ATOM   1161  NE  ARG A 162       7.919  -2.064 -26.547  1.00 70.61           N  
ATOM   1162  CZ  ARG A 162       8.786  -2.726 -27.307  1.00 72.26           C  
ATOM   1163  NH1 ARG A 162      10.054  -2.837 -26.932  1.00 73.52           N  
ATOM   1164  NH2 ARG A 162       8.386  -3.279 -28.445  1.00 71.75           N  
ATOM   1165  N   GLU A 168      13.507  -5.398 -19.961  1.00 52.87           N  
ATOM   1166  CA  GLU A 168      12.254  -6.031 -20.366  1.00 53.36           C  
ATOM   1167  C   GLU A 168      12.011  -7.318 -19.582  1.00 51.04           C  
ATOM   1168  O   GLU A 168      12.868  -8.201 -19.538  1.00 51.27           O  
ATOM   1169  CB  GLU A 168      12.276  -6.343 -21.864  1.00 55.23           C  
ATOM   1170  CG  GLU A 168      11.039  -7.081 -22.353  1.00 60.78           C  
ATOM   1171  CD  GLU A 168      11.017  -7.254 -23.860  1.00 65.75           C  
ATOM   1172  OE1 GLU A 168      11.019  -6.228 -24.576  1.00 67.02           O  
ATOM   1173  OE2 GLU A 168      10.997  -8.413 -24.328  1.00 67.41           O  
ATOM   1174  N   ARG A 169      10.837  -7.419 -18.967  1.00 47.86           N  
ATOM   1175  CA  ARG A 169      10.495  -8.602 -18.186  1.00 42.90           C  
ATOM   1176  C   ARG A 169       9.126  -9.163 -18.565  1.00 41.36           C  
ATOM   1177  O   ARG A 169       8.318  -8.491 -19.210  1.00 37.40           O  
ATOM   1178  CB  ARG A 169      10.528  -8.270 -16.694  1.00 45.34           C  
ATOM   1179  CG  ARG A 169       9.614  -7.134 -16.294  1.00 47.43           C  
ATOM   1180  CD  ARG A 169       9.691  -6.867 -14.799  1.00 51.17           C  
ATOM   1181  NE  ARG A 169       8.810  -5.771 -14.406  1.00 53.12           N  
ATOM   1182  CZ  ARG A 169       8.643  -5.351 -13.156  1.00 55.62           C  
ATOM   1183  NH1 ARG A 169       9.300  -5.935 -12.162  1.00 54.71           N  
ATOM   1184  NH2 ARG A 169       7.815  -4.346 -12.900  1.00 56.75           N  
ATOM   1185  N   THR A 170       8.874 -10.401 -18.154  1.00 36.20           N  
ATOM   1186  CA  THR A 170       7.615 -11.069 -18.455  1.00 34.55           C  
ATOM   1187  C   THR A 170       6.839 -11.383 -17.180  1.00 34.60           C  
ATOM   1188  O   THR A 170       7.400 -11.889 -16.206  1.00 29.56           O  
ATOM   1189  CB  THR A 170       7.869 -12.383 -19.215  1.00 35.79           C  
ATOM   1190  OG1 THR A 170       8.647 -12.110 -20.387  1.00 36.27           O  
ATOM   1191  CG2 THR A 170       6.547 -13.040 -19.621  1.00 33.95           C  
ATOM   1192  N   HIS A 171       5.549 -11.065 -17.192  1.00 29.31           N  
ATOM   1193  CA  HIS A 171       4.677 -11.330 -16.056  1.00 29.44           C  
ATOM   1194  C   HIS A 171       3.744 -12.469 -16.456  1.00 30.56           C  
ATOM   1195  O   HIS A 171       3.050 -12.387 -17.471  1.00 32.20           O  
ATOM   1196  CB  HIS A 171       3.865 -10.084 -15.717  1.00 27.97           C  
ATOM   1197  CG  HIS A 171       4.705  -8.894 -15.383  1.00 31.43           C  
ATOM   1198  ND1 HIS A 171       5.499  -8.835 -14.257  1.00 29.97           N  
ATOM   1199  CD2 HIS A 171       4.890  -7.723 -16.036  1.00 31.32           C  
ATOM   1200  CE1 HIS A 171       6.137  -7.678 -14.231  1.00 33.70           C  
ATOM   1201  NE2 HIS A 171       5.785  -6.985 -15.301  1.00 34.66           N  
ATOM   1202  N   PHE A 172       3.744 -13.539 -15.669  1.00 27.37           N  
ATOM   1203  CA  PHE A 172       2.895 -14.690 -15.955  1.00 27.41           C  
ATOM   1204  C   PHE A 172       1.615 -14.580 -15.143  1.00 24.94           C  
ATOM   1205  O   PHE A 172       1.652 -14.309 -13.943  1.00 23.10           O  
ATOM   1206  CB  PHE A 172       3.645 -15.977 -15.623  1.00 30.38           C  
ATOM   1207  CG  PHE A 172       4.857 -16.201 -16.483  1.00 32.78           C  
ATOM   1208  CD1 PHE A 172       4.724 -16.667 -17.784  1.00 33.59           C  
ATOM   1209  CD2 PHE A 172       6.130 -15.918 -16.000  1.00 37.66           C  
ATOM   1210  CE1 PHE A 172       5.845 -16.850 -18.598  1.00 34.38           C  
ATOM   1211  CE2 PHE A 172       7.257 -16.095 -16.804  1.00 35.71           C  
ATOM   1212  CZ  PHE A 172       7.112 -16.561 -18.106  1.00 37.98           C  
ATOM   1213  N   VAL A 173       0.482 -14.786 -15.809  1.00 26.23           N  
ATOM   1214  CA  VAL A 173      -0.818 -14.674 -15.161  1.00 22.65           C  
ATOM   1215  C   VAL A 173      -1.733 -15.847 -15.516  1.00 23.97           C  
ATOM   1216  O   VAL A 173      -1.813 -16.262 -16.681  1.00 20.98           O  
ATOM   1217  CB  VAL A 173      -1.532 -13.360 -15.588  1.00 22.06           C  
ATOM   1218  CG1 VAL A 173      -2.817 -13.165 -14.790  1.00 19.19           C  
ATOM   1219  CG2 VAL A 173      -0.608 -12.179 -15.393  1.00 22.94           C  
ATOM   1220  N   GLU A 174      -2.397 -16.390 -14.500  1.00 21.32           N  
ATOM   1221  CA  GLU A 174      -3.341 -17.488 -14.697  1.00 24.30           C  
ATOM   1222  C   GLU A 174      -4.696 -16.849 -14.985  1.00 19.72           C  
ATOM   1223  O   GLU A 174      -5.161 -16.000 -14.227  1.00 21.89           O  
ATOM   1224  CB  GLU A 174      -3.431 -18.356 -13.436  1.00 23.19           C  
ATOM   1225  CG  GLU A 174      -2.191 -19.217 -13.177  1.00 28.86           C  
ATOM   1226  CD  GLU A 174      -1.963 -20.259 -14.263  1.00 32.98           C  
ATOM   1227  OE1 GLU A 174      -2.882 -21.051 -14.546  1.00 34.86           O  
ATOM   1228  OE2 GLU A 174      -0.856 -20.297 -14.835  1.00 40.84           O  
ATOM   1229  N   VAL A 175      -5.325 -17.246 -16.086  1.00 23.61           N  
ATOM   1230  CA  VAL A 175      -6.617 -16.676 -16.448  1.00 22.10           C  
ATOM   1231  C   VAL A 175      -7.676 -17.768 -16.540  1.00 20.23           C  
ATOM   1232  O   VAL A 175      -7.486 -18.770 -17.221  1.00 22.89           O  
ATOM   1233  CB  VAL A 175      -6.534 -15.936 -17.800  1.00 21.19           C  
ATOM   1234  CG1 VAL A 175      -7.853 -15.245 -18.098  1.00 19.96           C  
ATOM   1235  CG2 VAL A 175      -5.392 -14.921 -17.760  1.00 20.64           C  
ATOM   1236  N   GLN A 176      -8.792 -17.550 -15.851  1.00 22.67           N  
ATOM   1237  CA  GLN A 176      -9.895 -18.510 -15.822  1.00 23.38           C  
ATOM   1238  C   GLN A 176     -11.131 -17.921 -16.493  1.00 19.44           C  
ATOM   1239  O   GLN A 176     -11.453 -16.750 -16.300  1.00 21.74           O  
ATOM   1240  CB  GLN A 176     -10.213 -18.882 -14.369  1.00 21.04           C  
ATOM   1241  CG  GLN A 176     -11.472 -19.729 -14.176  1.00 22.67           C  
ATOM   1242  CD  GLN A 176     -11.737 -20.031 -12.705  1.00 29.14           C  
ATOM   1243  OE1 GLN A 176     -11.129 -19.430 -11.818  1.00 29.43           O  
ATOM   1244  NE2 GLN A 176     -12.657 -20.955 -12.441  1.00 25.45           N  
ATOM   1245  N   ALA A 177     -11.819 -18.736 -17.286  1.00 20.06           N  
ATOM   1246  CA  ALA A 177     -13.021 -18.275 -17.982  1.00 24.19           C  
ATOM   1247  C   ALA A 177     -14.148 -19.279 -17.788  1.00 23.35           C  
ATOM   1248  O   ALA A 177     -13.896 -20.476 -17.632  1.00 22.64           O  
ATOM   1249  CB  ALA A 177     -12.736 -18.097 -19.462  1.00 17.85           C  
ATOM   1250  N   TRP A 178     -15.383 -18.783 -17.812  1.00 22.46           N  
ATOM   1251  CA  TRP A 178     -16.560 -19.630 -17.622  1.00 26.91           C  
ATOM   1252  C   TRP A 178     -17.534 -19.655 -18.800  1.00 25.61           C  
ATOM   1253  O   TRP A 178     -17.561 -18.741 -19.622  1.00 23.68           O  
ATOM   1254  CB  TRP A 178     -17.337 -19.183 -16.381  1.00 27.65           C  
ATOM   1255  CG  TRP A 178     -16.630 -19.412 -15.084  1.00 34.60           C  
ATOM   1256  CD1 TRP A 178     -15.707 -18.599 -14.492  1.00 34.80           C  
ATOM   1257  CD2 TRP A 178     -16.798 -20.535 -14.209  1.00 35.05           C  
ATOM   1258  NE1 TRP A 178     -15.292 -19.144 -13.298  1.00 36.60           N  
ATOM   1259  CE2 TRP A 178     -15.944 -20.333 -13.101  1.00 35.24           C  
ATOM   1260  CE3 TRP A 178     -17.586 -21.692 -14.254  1.00 33.95           C  
ATOM   1261  CZ2 TRP A 178     -15.855 -21.250 -12.042  1.00 36.52           C  
ATOM   1262  CZ3 TRP A 178     -17.499 -22.604 -13.200  1.00 36.91           C  
ATOM   1263  CH2 TRP A 178     -16.638 -22.374 -12.110  1.00 34.02           C  
ATOM   1264  N   ARG A 179     -18.324 -20.722 -18.861  1.00 26.96           N  
ATOM   1265  CA  ARG A 179     -19.353 -20.911 -19.880  1.00 29.24           C  
ATOM   1266  C   ARG A 179     -18.952 -20.674 -21.333  1.00 26.67           C  
ATOM   1267  O   ARG A 179     -17.981 -21.251 -21.818  1.00 24.78           O  
ATOM   1268  CB  ARG A 179     -20.561 -20.045 -19.521  1.00 32.41           C  
ATOM   1269  CG  ARG A 179     -21.073 -20.334 -18.127  1.00 36.72           C  
ATOM   1270  CD  ARG A 179     -22.187 -19.406 -17.706  1.00 45.03           C  
ATOM   1271  NE  ARG A 179     -22.441 -19.538 -16.276  1.00 51.91           N  
ATOM   1272  CZ  ARG A 179     -21.555 -19.230 -15.333  1.00 55.66           C  
ATOM   1273  NH1 ARG A 179     -20.359 -18.767 -15.669  1.00 57.83           N  
ATOM   1274  NH2 ARG A 179     -21.859 -19.395 -14.053  1.00 58.24           N  
ATOM   1275  N   ASP A 180     -19.714 -19.838 -22.033  1.00 28.44           N  
ATOM   1276  CA  ASP A 180     -19.429 -19.568 -23.442  1.00 29.75           C  
ATOM   1277  C   ASP A 180     -18.012 -19.055 -23.644  1.00 25.86           C  
ATOM   1278  O   ASP A 180     -17.324 -19.450 -24.588  1.00 26.94           O  
ATOM   1279  CB  ASP A 180     -20.420 -18.550 -24.014  1.00 32.77           C  
ATOM   1280  CG  ASP A 180     -21.854 -19.043 -23.971  1.00 38.95           C  
ATOM   1281  OD1 ASP A 180     -22.072 -20.270 -24.080  1.00 38.02           O  
ATOM   1282  OD2 ASP A 180     -22.761 -18.198 -23.841  1.00 40.86           O  
ATOM   1283  N   LEU A 181     -17.584 -18.172 -22.748  1.00 26.30           N  
ATOM   1284  CA  LEU A 181     -16.248 -17.591 -22.814  1.00 24.90           C  
ATOM   1285  C   LEU A 181     -15.217 -18.710 -22.726  1.00 25.59           C  
ATOM   1286  O   LEU A 181     -14.184 -18.681 -23.400  1.00 25.80           O  
ATOM   1287  CB  LEU A 181     -16.074 -16.601 -21.662  1.00 26.76           C  
ATOM   1288  CG  LEU A 181     -15.030 -15.493 -21.788  1.00 30.08           C  
ATOM   1289  CD1 LEU A 181     -15.215 -14.763 -23.118  1.00 29.30           C  
ATOM   1290  CD2 LEU A 181     -15.184 -14.520 -20.612  1.00 26.66           C  
ATOM   1291  N   ALA A 182     -15.507 -19.717 -21.906  1.00 25.75           N  
ATOM   1292  CA  ALA A 182     -14.590 -20.837 -21.751  1.00 23.92           C  
ATOM   1293  C   ALA A 182     -14.579 -21.674 -23.018  1.00 24.40           C  
ATOM   1294  O   ALA A 182     -13.526 -22.125 -23.469  1.00 25.94           O  
ATOM   1295  CB  ALA A 182     -14.995 -21.698 -20.541  1.00 23.07           C  
ATOM   1296  N   GLU A 183     -15.748 -21.882 -23.610  1.00 24.72           N  
ATOM   1297  CA  GLU A 183     -15.801 -22.681 -24.822  1.00 25.88           C  
ATOM   1298  C   GLU A 183     -15.121 -21.953 -25.983  1.00 22.86           C  
ATOM   1299  O   GLU A 183     -14.497 -22.578 -26.836  1.00 25.06           O  
ATOM   1300  CB  GLU A 183     -17.253 -23.048 -25.134  1.00 30.13           C  
ATOM   1301  CG  GLU A 183     -17.858 -23.883 -23.997  1.00 36.92           C  
ATOM   1302  CD  GLU A 183     -19.256 -24.392 -24.280  1.00 42.80           C  
ATOM   1303  OE1 GLU A 183     -20.132 -23.569 -24.616  1.00 45.22           O  
ATOM   1304  OE2 GLU A 183     -19.476 -25.618 -24.147  1.00 44.54           O  
ATOM   1305  N   TRP A 184     -15.221 -20.631 -25.995  1.00 22.76           N  
ATOM   1306  CA  TRP A 184     -14.571 -19.842 -27.045  1.00 24.79           C  
ATOM   1307  C   TRP A 184     -13.057 -19.995 -26.899  1.00 22.95           C  
ATOM   1308  O   TRP A 184     -12.340 -20.160 -27.885  1.00 22.95           O  
ATOM   1309  CB  TRP A 184     -14.949 -18.363 -26.906  1.00 24.96           C  
ATOM   1310  CG  TRP A 184     -14.265 -17.452 -27.893  1.00 27.95           C  
ATOM   1311  CD1 TRP A 184     -14.718 -17.096 -29.134  1.00 31.53           C  
ATOM   1312  CD2 TRP A 184     -12.998 -16.799 -27.725  1.00 28.45           C  
ATOM   1313  NE1 TRP A 184     -13.808 -16.259 -29.750  1.00 31.98           N  
ATOM   1314  CE2 TRP A 184     -12.746 -16.062 -28.908  1.00 30.83           C  
ATOM   1315  CE3 TRP A 184     -12.051 -16.765 -26.690  1.00 29.31           C  
ATOM   1316  CZ2 TRP A 184     -11.583 -15.300 -29.083  1.00 31.96           C  
ATOM   1317  CZ3 TRP A 184     -10.896 -16.006 -26.865  1.00 32.44           C  
ATOM   1318  CH2 TRP A 184     -10.673 -15.284 -28.054  1.00 30.05           C  
ATOM   1319  N   ALA A 185     -12.586 -19.964 -25.655  1.00 24.08           N  
ATOM   1320  CA  ALA A 185     -11.154 -20.075 -25.356  1.00 25.10           C  
ATOM   1321  C   ALA A 185     -10.535 -21.437 -25.648  1.00 26.96           C  
ATOM   1322  O   ALA A 185      -9.330 -21.536 -25.902  1.00 26.09           O  
ATOM   1323  CB  ALA A 185     -10.901 -19.700 -23.893  1.00 26.77           C  
ATOM   1324  N   ALA A 186     -11.353 -22.485 -25.618  1.00 27.35           N  
ATOM   1325  CA  ALA A 186     -10.867 -23.839 -25.863  1.00 28.24           C  
ATOM   1326  C   ALA A 186     -10.227 -24.013 -27.235  1.00 31.04           C  
ATOM   1327  O   ALA A 186      -9.400 -24.905 -27.430  1.00 31.08           O  
ATOM   1328  CB  ALA A 186     -12.008 -24.844 -25.691  1.00 28.11           C  
ATOM   1329  N   GLU A 187     -10.606 -23.170 -28.189  1.00 31.79           N  
ATOM   1330  CA  GLU A 187     -10.035 -23.272 -29.528  1.00 32.37           C  
ATOM   1331  C   GLU A 187      -8.668 -22.603 -29.621  1.00 31.66           C  
ATOM   1332  O   GLU A 187      -7.944 -22.780 -30.603  1.00 32.60           O  
ATOM   1333  CB  GLU A 187     -10.986 -22.661 -30.559  1.00 36.82           C  
ATOM   1334  CG  GLU A 187     -12.285 -23.437 -30.711  1.00 45.64           C  
ATOM   1335  CD  GLU A 187     -13.150 -22.915 -31.841  1.00 50.00           C  
ATOM   1336  OE1 GLU A 187     -12.654 -22.837 -32.985  1.00 48.86           O  
ATOM   1337  OE2 GLU A 187     -14.328 -22.587 -31.583  1.00 56.14           O  
ATOM   1338  N   LEU A 188      -8.307 -21.838 -28.598  1.00 29.98           N  
ATOM   1339  CA  LEU A 188      -7.009 -21.174 -28.601  1.00 30.90           C  
ATOM   1340  C   LEU A 188      -5.914 -22.218 -28.463  1.00 31.48           C  
ATOM   1341  O   LEU A 188      -6.174 -23.358 -28.080  1.00 31.77           O  
ATOM   1342  CB  LEU A 188      -6.913 -20.174 -27.451  1.00 29.78           C  
ATOM   1343  CG  LEU A 188      -7.947 -19.048 -27.480  1.00 30.21           C  
ATOM   1344  CD1 LEU A 188      -7.795 -18.182 -26.245  1.00 32.60           C  
ATOM   1345  CD2 LEU A 188      -7.765 -18.228 -28.748  1.00 34.46           C  
ATOM   1346  N   ARG A 189      -4.689 -21.823 -28.786  1.00 30.46           N  
ATOM   1347  CA  ARG A 189      -3.547 -22.717 -28.695  1.00 30.06           C  
ATOM   1348  C   ARG A 189      -2.317 -21.965 -28.195  1.00 30.96           C  
ATOM   1349  O   ARG A 189      -2.229 -20.739 -28.326  1.00 30.72           O  
ATOM   1350  CB  ARG A 189      -3.265 -23.344 -30.062  1.00 32.74           C  
ATOM   1351  CG  ARG A 189      -4.315 -24.358 -30.513  1.00 35.44           C  
ATOM   1352  CD  ARG A 189      -4.281 -25.601 -29.637  1.00 38.93           C  
ATOM   1353  NE  ARG A 189      -5.191 -26.644 -30.109  1.00 40.48           N  
ATOM   1354  CZ  ARG A 189      -6.509 -26.642 -29.924  1.00 40.56           C  
ATOM   1355  NH1 ARG A 189      -7.095 -25.648 -29.269  1.00 38.41           N  
ATOM   1356  NH2 ARG A 189      -7.244 -27.640 -30.402  1.00 40.90           N  
ATOM   1357  N   LYS A 190      -1.376 -22.702 -27.611  1.00 30.75           N  
ATOM   1358  CA  LYS A 190      -0.145 -22.111 -27.098  1.00 31.78           C  
ATOM   1359  C   LYS A 190       0.477 -21.177 -28.138  1.00 30.49           C  
ATOM   1360  O   LYS A 190       0.606 -21.539 -29.310  1.00 31.86           O  
ATOM   1361  CB  LYS A 190       0.855 -23.213 -26.739  1.00 32.04           C  
ATOM   1362  CG  LYS A 190       2.216 -22.702 -26.296  1.00 31.26           C  
ATOM   1363  CD  LYS A 190       3.180 -23.857 -26.088  1.00 34.49           C  
ATOM   1364  CE  LYS A 190       4.543 -23.369 -25.634  1.00 38.43           C  
ATOM   1365  NZ  LYS A 190       5.467 -24.517 -25.413  1.00 43.23           N  
ATOM   1366  N   GLY A 191       0.854 -19.977 -27.708  1.00 30.43           N  
ATOM   1367  CA  GLY A 191       1.458 -19.023 -28.620  1.00 30.47           C  
ATOM   1368  C   GLY A 191       0.488 -17.959 -29.105  1.00 31.94           C  
ATOM   1369  O   GLY A 191       0.903 -16.868 -29.492  1.00 30.58           O  
ATOM   1370  N   ASP A 192      -0.804 -18.275 -29.100  1.00 30.04           N  
ATOM   1371  CA  ASP A 192      -1.818 -17.317 -29.540  1.00 29.77           C  
ATOM   1372  C   ASP A 192      -1.788 -16.060 -28.693  1.00 27.96           C  
ATOM   1373  O   ASP A 192      -1.463 -16.104 -27.507  1.00 29.23           O  
ATOM   1374  CB  ASP A 192      -3.229 -17.912 -29.441  1.00 29.76           C  
ATOM   1375  CG  ASP A 192      -3.548 -18.873 -30.564  1.00 33.69           C  
ATOM   1376  OD1 ASP A 192      -2.747 -18.975 -31.515  1.00 34.15           O  
ATOM   1377  OD2 ASP A 192      -4.616 -19.522 -30.494  1.00 34.24           O  
ATOM   1378  N   GLY A 193      -2.135 -14.935 -29.307  1.00 26.36           N  
ATOM   1379  CA  GLY A 193      -2.184 -13.698 -28.565  1.00 21.97           C  
ATOM   1380  C   GLY A 193      -3.497 -13.732 -27.802  1.00 24.00           C  
ATOM   1381  O   GLY A 193      -4.436 -14.421 -28.213  1.00 27.04           O  
ATOM   1382  N   LEU A 194      -3.571 -13.016 -26.690  1.00 22.06           N  
ATOM   1383  CA  LEU A 194      -4.804 -12.978 -25.908  1.00 24.67           C  
ATOM   1384  C   LEU A 194      -4.983 -11.634 -25.226  1.00 24.07           C  
ATOM   1385  O   LEU A 194      -4.074 -11.142 -24.554  1.00 22.46           O  
ATOM   1386  CB  LEU A 194      -4.818 -14.087 -24.842  1.00 23.20           C  
ATOM   1387  CG  LEU A 194      -6.109 -14.138 -24.007  1.00 28.58           C  
ATOM   1388  CD1 LEU A 194      -7.261 -14.567 -24.913  1.00 27.42           C  
ATOM   1389  CD2 LEU A 194      -5.968 -15.106 -22.835  1.00 25.72           C  
ATOM   1390  N   PHE A 195      -6.159 -11.043 -25.427  1.00 22.06           N  
ATOM   1391  CA  PHE A 195      -6.528  -9.773 -24.821  1.00 20.62           C  
ATOM   1392  C   PHE A 195      -7.595 -10.136 -23.787  1.00 24.03           C  
ATOM   1393  O   PHE A 195      -8.557 -10.854 -24.098  1.00 23.37           O  
ATOM   1394  CB  PHE A 195      -7.125  -8.820 -25.867  1.00 19.65           C  
ATOM   1395  CG  PHE A 195      -7.813  -7.619 -25.274  1.00 22.68           C  
ATOM   1396  CD1 PHE A 195      -7.084  -6.518 -24.846  1.00 22.78           C  
ATOM   1397  CD2 PHE A 195      -9.201  -7.604 -25.121  1.00 25.49           C  
ATOM   1398  CE1 PHE A 195      -7.719  -5.415 -24.273  1.00 26.54           C  
ATOM   1399  CE2 PHE A 195      -9.848  -6.508 -24.549  1.00 23.74           C  
ATOM   1400  CZ  PHE A 195      -9.109  -5.410 -24.122  1.00 27.36           C  
ATOM   1401  N   VAL A 196      -7.427  -9.645 -22.566  1.00 22.94           N  
ATOM   1402  CA  VAL A 196      -8.366  -9.948 -21.497  1.00 22.65           C  
ATOM   1403  C   VAL A 196      -8.829  -8.756 -20.695  1.00 22.67           C  
ATOM   1404  O   VAL A 196      -8.045  -7.859 -20.381  1.00 25.14           O  
ATOM   1405  CB  VAL A 196      -7.745 -10.936 -20.464  1.00 25.30           C  
ATOM   1406  CG1 VAL A 196      -8.761 -11.261 -19.367  1.00 22.72           C  
ATOM   1407  CG2 VAL A 196      -7.271 -12.192 -21.152  1.00 23.00           C  
ATOM   1408  N   ILE A 197     -10.122  -8.737 -20.390  1.00 19.18           N  
ATOM   1409  CA  ILE A 197     -10.683  -7.725 -19.509  1.00 18.17           C  
ATOM   1410  C   ILE A 197     -11.263  -8.643 -18.440  1.00 20.88           C  
ATOM   1411  O   ILE A 197     -12.099  -9.503 -18.736  1.00 18.54           O  
ATOM   1412  CB  ILE A 197     -11.829  -6.914 -20.123  1.00 19.23           C  
ATOM   1413  CG1 ILE A 197     -11.331  -6.104 -21.331  1.00 22.91           C  
ATOM   1414  CG2 ILE A 197     -12.389  -5.969 -19.071  1.00 15.98           C  
ATOM   1415  CD1 ILE A 197     -12.408  -5.216 -21.951  1.00 25.33           C  
ATOM   1416  N   GLY A 198     -10.803  -8.499 -17.210  1.00 21.94           N  
ATOM   1417  CA  GLY A 198     -11.312  -9.374 -16.176  1.00 23.71           C  
ATOM   1418  C   GLY A 198     -11.360  -8.751 -14.808  1.00 21.00           C  
ATOM   1419  O   GLY A 198     -11.249  -7.538 -14.653  1.00 23.17           O  
ATOM   1420  N   ARG A 199     -11.542  -9.604 -13.808  1.00 20.46           N  
ATOM   1421  CA  ARG A 199     -11.595  -9.167 -12.431  1.00 18.34           C  
ATOM   1422  C   ARG A 199     -10.524  -9.949 -11.690  1.00 18.74           C  
ATOM   1423  O   ARG A 199     -10.281 -11.117 -11.991  1.00 20.66           O  
ATOM   1424  CB  ARG A 199     -12.983  -9.441 -11.844  1.00 24.70           C  
ATOM   1425  CG  ARG A 199     -13.537 -10.825 -12.164  1.00 31.02           C  
ATOM   1426  CD  ARG A 199     -15.022 -10.915 -11.810  1.00 35.87           C  
ATOM   1427  NE  ARG A 199     -15.230 -10.878 -10.371  1.00 43.88           N  
ATOM   1428  CZ  ARG A 199     -15.082 -11.928  -9.570  1.00 43.83           C  
ATOM   1429  NH1 ARG A 199     -14.732 -13.106 -10.071  1.00 45.49           N  
ATOM   1430  NH2 ARG A 199     -15.266 -11.796  -8.263  1.00 47.45           N  
ATOM   1431  N   LEU A 200      -9.857  -9.296 -10.748  1.00 18.56           N  
ATOM   1432  CA  LEU A 200      -8.818  -9.969  -9.983  1.00 18.46           C  
ATOM   1433  C   LEU A 200      -9.461 -10.836  -8.910  1.00 17.85           C  
ATOM   1434  O   LEU A 200     -10.368 -10.393  -8.213  1.00 18.97           O  
ATOM   1435  CB  LEU A 200      -7.906  -8.944  -9.314  1.00 18.98           C  
ATOM   1436  CG  LEU A 200      -7.078  -8.100 -10.288  1.00 20.73           C  
ATOM   1437  CD1 LEU A 200      -6.335  -7.009  -9.524  1.00 23.37           C  
ATOM   1438  CD2 LEU A 200      -6.108  -9.003 -11.023  1.00 22.66           C  
ATOM   1439  N   VAL A 201      -8.987 -12.068  -8.787  1.00 18.27           N  
ATOM   1440  CA  VAL A 201      -9.499 -12.976  -7.770  1.00 22.99           C  
ATOM   1441  C   VAL A 201      -8.310 -13.646  -7.105  1.00 24.44           C  
ATOM   1442  O   VAL A 201      -7.195 -13.611  -7.630  1.00 23.61           O  
ATOM   1443  CB  VAL A 201     -10.404 -14.075  -8.378  1.00 18.68           C  
ATOM   1444  CG1 VAL A 201     -11.535 -13.433  -9.174  1.00 25.63           C  
ATOM   1445  CG2 VAL A 201      -9.588 -15.007  -9.247  1.00 23.45           C  
ATOM   1446  N   ASN A 202      -8.538 -14.245  -5.942  1.00 24.44           N  
ATOM   1447  CA  ASN A 202      -7.453 -14.929  -5.264  1.00 27.90           C  
ATOM   1448  C   ASN A 202      -7.912 -16.185  -4.537  1.00 28.91           C  
ATOM   1449  O   ASN A 202      -9.085 -16.322  -4.171  1.00 28.52           O  
ATOM   1450  CB  ASN A 202      -6.745 -13.979  -4.294  1.00 31.42           C  
ATOM   1451  CG  ASN A 202      -7.699 -13.292  -3.351  1.00 35.40           C  
ATOM   1452  OD1 ASN A 202      -8.526 -13.938  -2.709  1.00 37.93           O  
ATOM   1453  ND2 ASN A 202      -7.586 -11.972  -3.254  1.00 32.34           N  
ATOM   1454  N   ASP A 203      -6.983 -17.118  -4.365  1.00 27.25           N  
ATOM   1455  CA  ASP A 203      -7.274 -18.361  -3.666  1.00 29.31           C  
ATOM   1456  C   ASP A 203      -6.431 -18.328  -2.398  1.00 31.08           C  
ATOM   1457  O   ASP A 203      -5.328 -17.775  -2.396  1.00 30.11           O  
ATOM   1458  CB  ASP A 203      -6.876 -19.574  -4.512  1.00 26.34           C  
ATOM   1459  CG  ASP A 203      -7.305 -19.451  -5.966  1.00 27.32           C  
ATOM   1460  OD1 ASP A 203      -8.481 -19.119  -6.220  1.00 22.95           O  
ATOM   1461  OD2 ASP A 203      -6.462 -19.696  -6.857  1.00 26.22           O  
ATOM   1462  N   SER A 204      -6.955 -18.896  -1.318  1.00 31.98           N  
ATOM   1463  CA  SER A 204      -6.230 -18.937  -0.056  1.00 33.22           C  
ATOM   1464  C   SER A 204      -6.570 -20.228   0.673  1.00 34.55           C  
ATOM   1465  O   SER A 204      -7.735 -20.627   0.746  1.00 30.10           O  
ATOM   1466  CB  SER A 204      -6.583 -17.726   0.810  1.00 34.65           C  
ATOM   1467  OG  SER A 204      -7.975 -17.645   1.037  1.00 42.30           O  
ATOM   1468  N   TRP A 205      -5.541 -20.883   1.200  1.00 34.14           N  
ATOM   1469  CA  TRP A 205      -5.721 -22.142   1.906  1.00 37.09           C  
ATOM   1470  C   TRP A 205      -4.503 -22.421   2.777  1.00 39.65           C  
ATOM   1471  O   TRP A 205      -3.557 -21.634   2.799  1.00 39.10           O  
ATOM   1472  CB  TRP A 205      -5.902 -23.275   0.894  1.00 33.14           C  
ATOM   1473  CG  TRP A 205      -4.667 -23.587   0.084  1.00 33.34           C  
ATOM   1474  CD1 TRP A 205      -3.859 -24.682   0.216  1.00 33.65           C  
ATOM   1475  CD2 TRP A 205      -4.118 -22.815  -0.997  1.00 33.70           C  
ATOM   1476  NE1 TRP A 205      -2.848 -24.644  -0.717  1.00 34.22           N  
ATOM   1477  CE2 TRP A 205      -2.982 -23.510  -1.474  1.00 33.93           C  
ATOM   1478  CE3 TRP A 205      -4.475 -21.605  -1.609  1.00 34.11           C  
ATOM   1479  CZ2 TRP A 205      -2.198 -23.037  -2.537  1.00 33.25           C  
ATOM   1480  CZ3 TRP A 205      -3.695 -21.132  -2.668  1.00 35.00           C  
ATOM   1481  CH2 TRP A 205      -2.570 -21.850  -3.119  1.00 32.10           C  
ATOM   1482  N   THR A 206      -4.535 -23.543   3.490  1.00 41.30           N  
ATOM   1483  CA  THR A 206      -3.426 -23.939   4.353  1.00 43.08           C  
ATOM   1484  C   THR A 206      -2.836 -25.241   3.833  1.00 45.12           C  
ATOM   1485  O   THR A 206      -3.540 -26.241   3.709  1.00 45.40           O  
ATOM   1486  CB  THR A 206      -3.888 -24.154   5.807  1.00 43.75           C  
ATOM   1487  OG1 THR A 206      -4.320 -22.906   6.364  1.00 43.58           O  
ATOM   1488  CG2 THR A 206      -2.747 -24.714   6.651  1.00 43.97           C  
ATOM   1489  N   SER A 207      -1.544 -25.220   3.524  1.00 48.87           N  
ATOM   1490  CA  SER A 207      -0.853 -26.397   3.011  1.00 53.58           C  
ATOM   1491  C   SER A 207      -0.932 -27.555   4.000  1.00 56.34           C  
ATOM   1492  O   SER A 207      -1.413 -27.391   5.122  1.00 55.59           O  
ATOM   1493  CB  SER A 207       0.612 -26.055   2.728  1.00 54.81           C  
ATOM   1494  OG  SER A 207       1.308 -27.161   2.182  1.00 60.71           O  
ATOM   1495  N   SER A 208      -0.461 -28.726   3.573  1.00 59.45           N  
ATOM   1496  CA  SER A 208      -0.469 -29.919   4.416  1.00 63.35           C  
ATOM   1497  C   SER A 208      -0.064 -29.543   5.834  1.00 64.85           C  
ATOM   1498  O   SER A 208      -0.719 -29.929   6.803  1.00 65.90           O  
ATOM   1499  CB  SER A 208       0.503 -30.962   3.863  1.00 64.46           C  
ATOM   1500  OG  SER A 208       0.148 -31.335   2.543  1.00 66.95           O  
ATOM   1501  N   SER A 209       1.018 -28.780   5.946  1.00 66.69           N  
ATOM   1502  CA  SER A 209       1.503 -28.328   7.241  1.00 68.57           C  
ATOM   1503  C   SER A 209       0.656 -27.136   7.686  1.00 69.02           C  
ATOM   1504  O   SER A 209      -0.567 -27.142   7.533  1.00 70.04           O  
ATOM   1505  CB  SER A 209       2.973 -27.918   7.136  1.00 68.41           C  
ATOM   1506  OG  SER A 209       3.155 -26.935   6.133  1.00 70.92           O  
ATOM   1507  N   GLY A 210       1.305 -26.121   8.242  1.00 68.60           N  
ATOM   1508  CA  GLY A 210       0.581 -24.942   8.679  1.00 67.30           C  
ATOM   1509  C   GLY A 210       0.719 -23.856   7.632  1.00 65.94           C  
ATOM   1510  O   GLY A 210       0.126 -22.783   7.744  1.00 66.77           O  
ATOM   1511  N   GLU A 211       1.512 -24.157   6.609  1.00 64.83           N  
ATOM   1512  CA  GLU A 211       1.779 -23.242   5.504  1.00 63.94           C  
ATOM   1513  C   GLU A 211       0.531 -22.544   4.972  1.00 62.07           C  
ATOM   1514  O   GLU A 211      -0.279 -23.149   4.271  1.00 61.26           O  
ATOM   1515  CB  GLU A 211       2.460 -24.006   4.364  1.00 66.28           C  
ATOM   1516  CG  GLU A 211       2.597 -23.230   3.060  1.00 68.68           C  
ATOM   1517  CD  GLU A 211       3.670 -22.166   3.119  1.00 69.89           C  
ATOM   1518  OE1 GLU A 211       4.853 -22.529   3.275  1.00 72.34           O  
ATOM   1519  OE2 GLU A 211       3.332 -20.968   3.006  1.00 71.54           O  
ATOM   1520  N   ARG A 212       0.383 -21.269   5.313  1.00 60.15           N  
ATOM   1521  CA  ARG A 212      -0.753 -20.485   4.843  1.00 59.04           C  
ATOM   1522  C   ARG A 212      -0.429 -20.064   3.415  1.00 57.08           C  
ATOM   1523  O   ARG A 212       0.552 -19.357   3.177  1.00 57.04           O  
ATOM   1524  CB  ARG A 212      -0.945 -19.247   5.721  1.00 61.15           C  
ATOM   1525  CG  ARG A 212      -1.342 -19.555   7.155  1.00 66.30           C  
ATOM   1526  CD  ARG A 212      -1.207 -18.324   8.042  1.00 70.38           C  
ATOM   1527  NE  ARG A 212      -2.019 -17.202   7.575  1.00 74.85           N  
ATOM   1528  CZ  ARG A 212      -3.349 -17.196   7.545  1.00 75.93           C  
ATOM   1529  NH1 ARG A 212      -4.030 -18.258   7.958  1.00 75.66           N  
ATOM   1530  NH2 ARG A 212      -3.998 -16.128   7.102  1.00 75.79           N  
ATOM   1531  N   ARG A 213      -1.244 -20.509   2.465  1.00 53.09           N  
ATOM   1532  CA  ARG A 213      -1.023 -20.184   1.063  1.00 49.49           C  
ATOM   1533  C   ARG A 213      -2.017 -19.165   0.511  1.00 47.93           C  
ATOM   1534  O   ARG A 213      -3.151 -19.055   0.984  1.00 45.59           O  
ATOM   1535  CB  ARG A 213      -1.064 -21.458   0.221  1.00 49.79           C  
ATOM   1536  CG  ARG A 213       0.102 -22.402   0.461  1.00 48.58           C  
ATOM   1537  CD  ARG A 213       1.420 -21.747   0.081  1.00 49.50           C  
ATOM   1538  NE  ARG A 213       1.457 -21.361  -1.328  1.00 49.67           N  
ATOM   1539  CZ  ARG A 213       1.536 -22.218  -2.342  1.00 48.96           C  
ATOM   1540  NH1 ARG A 213       1.589 -23.523  -2.112  1.00 49.53           N  
ATOM   1541  NH2 ARG A 213       1.560 -21.767  -3.590  1.00 50.93           N  
ATOM   1542  N   PHE A 214      -1.577 -18.428  -0.504  1.00 45.58           N  
ATOM   1543  CA  PHE A 214      -2.394 -17.398  -1.132  1.00 42.68           C  
ATOM   1544  C   PHE A 214      -1.862 -17.145  -2.541  1.00 41.19           C  
ATOM   1545  O   PHE A 214      -0.649 -17.151  -2.755  1.00 39.99           O  
ATOM   1546  CB  PHE A 214      -2.301 -16.113  -0.309  1.00 45.89           C  
ATOM   1547  CG  PHE A 214      -3.228 -15.024  -0.761  1.00 48.82           C  
ATOM   1548  CD1 PHE A 214      -4.437 -14.808  -0.106  1.00 50.45           C  
ATOM   1549  CD2 PHE A 214      -2.882 -14.191  -1.823  1.00 51.08           C  
ATOM   1550  CE1 PHE A 214      -5.289 -13.776  -0.498  1.00 49.07           C  
ATOM   1551  CE2 PHE A 214      -3.727 -13.156  -2.226  1.00 51.42           C  
ATOM   1552  CZ  PHE A 214      -4.934 -12.949  -1.559  1.00 51.03           C  
ATOM   1553  N   GLN A 215      -2.764 -16.939  -3.500  1.00 36.20           N  
ATOM   1554  CA  GLN A 215      -2.371 -16.665  -4.881  1.00 31.96           C  
ATOM   1555  C   GLN A 215      -3.377 -15.771  -5.591  1.00 31.82           C  
ATOM   1556  O   GLN A 215      -4.570 -15.793  -5.287  1.00 30.11           O  
ATOM   1557  CB  GLN A 215      -2.187 -17.965  -5.672  1.00 33.59           C  
ATOM   1558  CG  GLN A 215      -3.297 -18.985  -5.519  1.00 33.82           C  
ATOM   1559  CD  GLN A 215      -3.004 -20.264  -6.281  1.00 32.39           C  
ATOM   1560  OE1 GLN A 215      -1.865 -20.726  -6.324  1.00 30.23           O  
ATOM   1561  NE2 GLN A 215      -4.036 -20.852  -6.877  1.00 29.47           N  
ATOM   1562  N   THR A 216      -2.890 -14.980  -6.541  1.00 28.15           N  
ATOM   1563  CA  THR A 216      -3.757 -14.071  -7.278  1.00 25.88           C  
ATOM   1564  C   THR A 216      -3.859 -14.484  -8.731  1.00 24.39           C  
ATOM   1565  O   THR A 216      -2.872 -14.884  -9.352  1.00 25.31           O  
ATOM   1566  CB  THR A 216      -3.237 -12.620  -7.195  1.00 28.02           C  
ATOM   1567  OG1 THR A 216      -3.251 -12.193  -5.828  1.00 25.38           O  
ATOM   1568  CG2 THR A 216      -4.116 -11.679  -8.031  1.00 26.01           C  
ATOM   1569  N   ARG A 217      -5.069 -14.389  -9.269  1.00 22.64           N  
ATOM   1570  CA  ARG A 217      -5.328 -14.758 -10.652  1.00 20.53           C  
ATOM   1571  C   ARG A 217      -6.361 -13.794 -11.217  1.00 17.15           C  
ATOM   1572  O   ARG A 217      -6.775 -12.847 -10.545  1.00 17.68           O  
ATOM   1573  CB  ARG A 217      -5.880 -16.189 -10.737  1.00 23.87           C  
ATOM   1574  CG  ARG A 217      -4.960 -17.271 -10.181  1.00 25.17           C  
ATOM   1575  CD  ARG A 217      -5.619 -18.654 -10.263  1.00 20.96           C  
ATOM   1576  NE  ARG A 217      -6.812 -18.725  -9.415  1.00 23.26           N  
ATOM   1577  CZ  ARG A 217      -8.065 -18.622  -9.849  1.00 26.91           C  
ATOM   1578  NH1 ARG A 217      -8.319 -18.442 -11.142  1.00 22.08           N  
ATOM   1579  NH2 ARG A 217      -9.069 -18.698  -8.983  1.00 24.83           N  
ATOM   1580  N   VAL A 218      -6.782 -14.053 -12.447  1.00 20.21           N  
ATOM   1581  CA  VAL A 218      -7.771 -13.214 -13.112  1.00 20.97           C  
ATOM   1582  C   VAL A 218      -8.916 -14.041 -13.678  1.00 19.11           C  
ATOM   1583  O   VAL A 218      -8.697 -15.097 -14.265  1.00 24.39           O  
ATOM   1584  CB  VAL A 218      -7.147 -12.423 -14.294  1.00 23.43           C  
ATOM   1585  CG1 VAL A 218      -8.237 -11.586 -14.993  1.00 22.39           C  
ATOM   1586  CG2 VAL A 218      -6.021 -11.526 -13.793  1.00 19.96           C  
ATOM   1587  N   GLU A 219     -10.136 -13.557 -13.476  1.00 21.18           N  
ATOM   1588  CA  GLU A 219     -11.320 -14.216 -14.012  1.00 23.81           C  
ATOM   1589  C   GLU A 219     -11.752 -13.308 -15.161  1.00 18.03           C  
ATOM   1590  O   GLU A 219     -12.061 -12.143 -14.952  1.00 20.49           O  
ATOM   1591  CB  GLU A 219     -12.430 -14.299 -12.961  1.00 23.89           C  
ATOM   1592  CG  GLU A 219     -13.760 -14.790 -13.513  1.00 35.37           C  
ATOM   1593  CD  GLU A 219     -14.791 -15.007 -12.424  1.00 37.04           C  
ATOM   1594  OE1 GLU A 219     -14.606 -15.939 -11.613  1.00 44.87           O  
ATOM   1595  OE2 GLU A 219     -15.777 -14.242 -12.374  1.00 43.50           O  
ATOM   1596  N   ALA A 220     -11.743 -13.860 -16.365  1.00 21.77           N  
ATOM   1597  CA  ALA A 220     -12.091 -13.128 -17.573  1.00 24.86           C  
ATOM   1598  C   ALA A 220     -13.562 -12.742 -17.682  1.00 25.81           C  
ATOM   1599  O   ALA A 220     -14.453 -13.484 -17.265  1.00 25.97           O  
ATOM   1600  CB  ALA A 220     -11.676 -13.946 -18.794  1.00 22.64           C  
ATOM   1601  N   LEU A 221     -13.794 -11.558 -18.238  1.00 25.49           N  
ATOM   1602  CA  LEU A 221     -15.134 -11.033 -18.468  1.00 25.44           C  
ATOM   1603  C   LEU A 221     -15.285 -10.902 -19.983  1.00 26.78           C  
ATOM   1604  O   LEU A 221     -16.380 -11.042 -20.529  1.00 23.48           O  
ATOM   1605  CB  LEU A 221     -15.292  -9.664 -17.809  1.00 28.68           C  
ATOM   1606  CG  LEU A 221     -15.309  -9.646 -16.278  1.00 34.97           C  
ATOM   1607  CD1 LEU A 221     -15.232  -8.208 -15.775  1.00 33.13           C  
ATOM   1608  CD2 LEU A 221     -16.572 -10.334 -15.775  1.00 34.70           C  
ATOM   1609  N   ARG A 222     -14.169 -10.632 -20.653  1.00 23.83           N  
ATOM   1610  CA  ARG A 222     -14.140 -10.506 -22.113  1.00 22.41           C  
ATOM   1611  C   ARG A 222     -12.802 -11.028 -22.600  1.00 21.97           C  
ATOM   1612  O   ARG A 222     -11.779 -10.807 -21.954  1.00 22.48           O  
ATOM   1613  CB  ARG A 222     -14.284  -9.041 -22.563  1.00 21.78           C  
ATOM   1614  CG  ARG A 222     -14.368  -8.885 -24.101  1.00 21.78           C  
ATOM   1615  CD  ARG A 222     -14.355  -7.419 -24.556  1.00 22.79           C  
ATOM   1616  NE  ARG A 222     -14.651  -7.303 -25.985  1.00 21.36           N  
ATOM   1617  CZ  ARG A 222     -15.793  -6.818 -26.476  1.00 23.59           C  
ATOM   1618  NH1 ARG A 222     -16.744  -6.393 -25.659  1.00 21.63           N  
ATOM   1619  NH2 ARG A 222     -15.997  -6.782 -27.788  1.00 24.17           N  
ATOM   1620  N   LEU A 223     -12.811 -11.723 -23.735  1.00 20.96           N  
ATOM   1621  CA  LEU A 223     -11.587 -12.259 -24.314  1.00 23.34           C  
ATOM   1622  C   LEU A 223     -11.563 -11.964 -25.806  1.00 26.12           C  
ATOM   1623  O   LEU A 223     -12.598 -12.002 -26.481  1.00 25.75           O  
ATOM   1624  CB  LEU A 223     -11.499 -13.776 -24.109  1.00 23.65           C  
ATOM   1625  CG  LEU A 223     -11.418 -14.323 -22.683  1.00 23.59           C  
ATOM   1626  CD1 LEU A 223     -11.498 -15.845 -22.727  1.00 25.83           C  
ATOM   1627  CD2 LEU A 223     -10.111 -13.873 -22.023  1.00 25.14           C  
ATOM   1628  N   GLU A 224     -10.378 -11.662 -26.318  1.00 22.77           N  
ATOM   1629  CA  GLU A 224     -10.214 -11.381 -27.735  1.00 23.83           C  
ATOM   1630  C   GLU A 224      -8.876 -11.971 -28.139  1.00 25.17           C  
ATOM   1631  O   GLU A 224      -8.009 -12.207 -27.291  1.00 24.31           O  
ATOM   1632  CB  GLU A 224     -10.212  -9.870 -27.995  1.00 20.60           C  
ATOM   1633  CG  GLU A 224     -11.441  -9.129 -27.490  1.00 22.45           C  
ATOM   1634  CD  GLU A 224     -12.665  -9.339 -28.367  1.00 23.34           C  
ATOM   1635  OE1 GLU A 224     -12.572 -10.069 -29.378  1.00 26.20           O  
ATOM   1636  OE2 GLU A 224     -13.721  -8.763 -28.041  1.00 26.90           O  
ATOM   1637  N   ARG A 225      -8.711 -12.233 -29.426  1.00 22.91           N  
ATOM   1638  CA  ARG A 225      -7.456 -12.775 -29.903  1.00 24.67           C  
ATOM   1639  C   ARG A 225      -6.772 -11.768 -30.826  1.00 26.75           C  
ATOM   1640  O   ARG A 225      -7.132 -11.641 -31.994  1.00 26.10           O  
ATOM   1641  CB  ARG A 225      -7.681 -14.083 -30.653  1.00 25.88           C  
ATOM   1642  CG  ARG A 225      -6.393 -14.737 -31.115  1.00 31.09           C  
ATOM   1643  CD  ARG A 225      -6.628 -15.587 -32.356  1.00 37.09           C  
ATOM   1644  NE  ARG A 225      -5.371 -15.899 -33.024  1.00 42.20           N  
ATOM   1645  CZ  ARG A 225      -5.267 -16.211 -34.309  1.00 43.44           C  
ATOM   1646  NH1 ARG A 225      -6.349 -16.254 -35.075  1.00 42.54           N  
ATOM   1647  NH2 ARG A 225      -4.078 -16.472 -34.828  1.00 46.42           N  
ATOM   1648  N   PRO A 226      -5.791 -11.018 -30.302  1.00 28.23           N  
ATOM   1649  CA  PRO A 226      -5.097 -10.046 -31.152  1.00 27.51           C  
ATOM   1650  C   PRO A 226      -4.262 -10.804 -32.180  1.00 29.07           C  
ATOM   1651  O   PRO A 226      -3.663 -11.835 -31.865  1.00 28.81           O  
ATOM   1652  CB  PRO A 226      -4.249  -9.256 -30.152  1.00 28.94           C  
ATOM   1653  CG  PRO A 226      -3.955 -10.268 -29.091  1.00 27.80           C  
ATOM   1654  CD  PRO A 226      -5.283 -10.972 -28.919  1.00 25.28           C  
ATOM   1655  N   THR A 227      -4.243 -10.312 -33.413  1.00 29.31           N  
ATOM   1656  CA  THR A 227      -3.494 -10.969 -34.480  1.00 33.58           C  
ATOM   1657  C   THR A 227      -2.366 -10.085 -35.001  1.00 38.19           C  
ATOM   1658  O   THR A 227      -2.073 -10.066 -36.200  1.00 39.87           O  
ATOM   1659  CB  THR A 227      -4.431 -11.343 -35.642  1.00 31.52           C  
ATOM   1660  OG1 THR A 227      -5.092 -10.165 -36.126  1.00 31.12           O  
ATOM   1661  CG2 THR A 227      -5.483 -12.337 -35.164  1.00 34.32           C  
ATOM   1662  N   ARG A 228      -1.733  -9.362 -34.083  1.00 41.23           N  
ATOM   1663  CA  ARG A 228      -0.636  -8.455 -34.402  1.00 46.50           C  
ATOM   1664  C   ARG A 228       0.476  -9.183 -35.161  1.00 48.76           C  
ATOM   1665  O   ARG A 228       0.706 -10.379 -34.881  1.00 50.17           O  
ATOM   1666  CB  ARG A 228      -0.078  -7.863 -33.102  1.00 47.40           C  
ATOM   1667  CG  ARG A 228       0.767  -6.604 -33.250  1.00 50.42           C  
ATOM   1668  CD  ARG A 228       1.311  -6.181 -31.887  1.00 52.47           C  
ATOM   1669  NE  ARG A 228       2.005  -4.893 -31.901  1.00 55.97           N  
ATOM   1670  CZ  ARG A 228       1.404  -3.715 -32.041  1.00 58.38           C  
ATOM   1671  NH1 ARG A 228       2.120  -2.597 -32.038  1.00 57.00           N  
ATOM   1672  NH2 ARG A 228       0.086  -3.649 -32.184  1.00 57.76           N  
TER    1673      ARG A 228                                                      
END
MOLECULE T0466.pdb
ATOM    281  N   LEU    19     -13.966  -0.653  -3.614  1.00 72.33           N 
ATOM    282  CA  LEU    19     -12.695  -0.631  -2.891  1.00 64.15           C 
ATOM    283  C   LEU    19     -12.829   0.243  -1.646  1.00 23.21           C 
ATOM    284  O   LEU    19     -12.938   1.465  -1.741  1.00 12.11           O 
ATOM    285  CB  LEU    19     -11.563  -0.105  -3.789  1.00 13.41           C 
ATOM    286  CG  LEU    19     -11.234  -0.974  -5.016  1.00 70.21           C 
ATOM    287  CD1 LEU    19     -10.125  -0.332  -5.850  1.00 43.44           C 
ATOM    288  CD2 LEU    19     -10.838  -2.387  -4.583  1.00 45.32           C 
ATOM    289  H   LEU    19     -14.169   0.069  -4.245  1.00 38.03           H 
ATOM    290  HA  LEU    19     -12.462  -1.643  -2.586  1.00 55.11           H 
ATOM    291 1HB  LEU    19     -10.669  -0.016  -3.189  1.00 45.32           H 
ATOM    292 2HB  LEU    19     -11.840   0.881  -4.136  1.00  2.50           H 
ATOM    293  HG  LEU    19     -12.112  -1.049  -5.641  1.00 41.50           H 
ATOM    294 1HD1 LEU    19     -10.444   0.645  -6.180  1.00 43.04           H 
ATOM    295 2HD1 LEU    19      -9.917  -0.951  -6.711  1.00 44.24           H 
ATOM    296 3HD1 LEU    19      -9.230  -0.236  -5.251  1.00 60.31           H 
ATOM    297 1HD2 LEU    19     -11.659  -2.843  -4.052  1.00 71.13           H 
ATOM    298 2HD2 LEU    19      -9.973  -2.341  -3.937  1.00 40.24           H 
ATOM    299 3HD2 LEU    19     -10.602  -2.978  -5.457  1.00 72.51           H 
ATOM    300  N   LYS    20     -12.840  -0.387  -0.479  1.00 73.43           N 
ATOM    301  CA  LYS    20     -13.053   0.332   0.778  1.00 62.04           C 
ATOM    302  C   LYS    20     -11.909   0.088   1.772  1.00 13.12           C 
ATOM    303  O   LYS    20     -11.455  -1.045   1.961  1.00 65.12           O 
ATOM    304  CB  LYS    20     -14.419  -0.052   1.370  1.00 73.41           C 
ATOM    305  CG  LYS    20     -15.591   0.446   0.520  1.00 44.14           C 
ATOM    306  CD  LYS    20     -16.956   0.146   1.139  1.00 11.00           C 
ATOM    307  CE  LYS    20     -17.277  -1.344   1.148  1.00  5.44           C 
ATOM    308  NZ  LYS    20     -18.661  -1.611   1.627  1.00 32.10           N 
ATOM    309  H   LYS    20     -12.705  -1.359  -0.461  1.00 38.03           H 
ATOM    310  HA  LYS    20     -13.069   1.391   0.545  1.00 11.12           H 
ATOM    311 1HB  LYS    20     -14.509   0.376   2.356  1.00 40.45           H 
ATOM    312 2HB  LYS    20     -14.479  -1.129   1.447  1.00 15.41           H 
ATOM    313 1HG  LYS    20     -15.537  -0.025  -0.454  1.00 12.12           H 
ATOM    314 2HG  LYS    20     -15.497   1.516   0.400  1.00 50.51           H 
ATOM    315 1HD  LYS    20     -17.716   0.663   0.569  1.00 30.51           H 
ATOM    316 2HD  LYS    20     -16.966   0.509   2.157  1.00 21.12           H 
ATOM    317 1HE  LYS    20     -16.577  -1.846   1.800  1.00 71.53           H 
ATOM    318 2HE  LYS    20     -17.175  -1.732   0.144  1.00 22.23           H 
ATOM    319 1HZ  LYS    20     -19.358  -1.233   0.948  1.00  4.11           H 
ATOM    320 2HZ  LYS    20     -18.816  -1.157   2.547  1.00 21.32           H 
ATOM    321 3HZ  LYS    20     -18.816  -2.632   1.732  1.00 52.21           H 
ATOM    322  N   PHE    21     -11.449   1.175   2.393  1.00 62.24           N 
ATOM    323  CA  PHE    21     -10.276   1.156   3.277  1.00 61.32           C 
ATOM    324  C   PHE    21     -10.481   0.285   4.531  1.00 12.31           C 
ATOM    325  O   PHE    21     -11.577   0.211   5.088  1.00 52.04           O 
ATOM    326  CB  PHE    21      -9.929   2.598   3.688  1.00 11.21           C 
ATOM    327  CG  PHE    21      -8.648   2.729   4.474  1.00  1.24           C 
ATOM    328  CD1 PHE    21      -7.419   2.684   3.831  1.00 42.11           C 
ATOM    329  CD2 PHE    21      -8.673   2.907   5.851  1.00 65.13           C 
ATOM    330  CE1 PHE    21      -6.242   2.812   4.543  1.00 44.33           C 
ATOM    331  CE2 PHE    21      -7.499   3.034   6.568  1.00 52.11           C 
ATOM    332  CZ  PHE    21      -6.282   2.987   5.914  1.00 73.53           C 
ATOM    333  H   PHE    21     -11.911   2.030   2.240  1.00 38.03           H 
ATOM    334  HA  PHE    21      -9.449   0.752   2.712  1.00 25.10           H 
ATOM    335 1HB  PHE    21     -10.732   2.995   4.294  1.00 34.51           H 
ATOM    336 2HB  PHE    21      -9.832   3.200   2.798  1.00 43.41           H 
ATOM    337  HD1 PHE    21      -7.387   2.548   2.760  1.00 14.33           H 
ATOM    338  HD2 PHE    21      -9.623   2.942   6.363  1.00 63.21           H 
ATOM    339  HE1 PHE    21      -5.294   2.773   4.030  1.00 51.24           H 
ATOM    340  HE2 PHE    21      -7.533   3.171   7.639  1.00  4.43           H 
ATOM    341  HZ  PHE    21      -5.364   3.087   6.474  1.00  4.10           H 
ATOM    342  N   SER    22      -9.411  -0.380   4.965  1.00 74.33           N 
ATOM    343  CA  SER    22      -9.423  -1.137   6.227  1.00 11.20           C 
ATOM    344  C   SER    22      -8.311  -0.665   7.171  1.00 14.10           C 
ATOM    345  O   SER    22      -8.586  -0.177   8.268  1.00 71.35           O 
ATOM    346  CB  SER    22      -9.277  -2.644   5.969  1.00  4.33           C 
ATOM    347  OG  SER    22     -10.410  -3.167   5.290  1.00 62.25           O 
ATOM    348  H   SER    22      -8.597  -0.380   4.417  1.00 38.03           H 
ATOM    349  HA  SER    22     -10.377  -0.961   6.709  1.00  1.01           H 
ATOM    350 1HB  SER    22      -9.168  -3.160   6.913  1.00 32.42           H 
ATOM    351 2HB  SER    22      -8.401  -2.821   5.363  1.00 13.22           H 
ATOM    352  HG  SER    22     -10.313  -4.126   5.207  1.00 10.03           H 
ATOM    353  N   ALA    23      -7.057  -0.820   6.746  1.00 13.40           N 
ATOM    354  CA  ALA    23      -5.906  -0.400   7.557  1.00 50.24           C 
ATOM    355  C   ALA    23      -4.646  -0.196   6.702  1.00 35.25           C 
ATOM    356  O   ALA    23      -4.667  -0.374   5.483  1.00 23.23           O 
ATOM    357  CB  ALA    23      -5.635  -1.429   8.651  1.00 33.12           C 
ATOM    358  H   ALA    23      -6.897  -1.225   5.867  1.00 38.03           H 
ATOM    359  HA  ALA    23      -6.160   0.539   8.034  1.00 70.41           H 
ATOM    360 1HB  ALA    23      -6.529  -1.578   9.239  1.00 50.23           H 
ATOM    361 2HB  ALA    23      -4.840  -1.075   9.291  1.00 75.13           H 
ATOM    362 3HB  ALA    23      -5.343  -2.365   8.199  1.00 74.43           H 
ATOM    363  N   LEU    24      -3.554   0.192   7.352  1.00 20.11           N 
ATOM    364  CA  LEU    24      -2.234   0.235   6.715  1.00 23.54           C 
ATOM    365  C   LEU    24      -1.416  -0.989   7.149  1.00 42.12           C 
ATOM    366  O   LEU    24      -0.880  -1.030   8.262  1.00 52.13           O 
ATOM    367  CB  LEU    24      -1.500   1.530   7.091  1.00  1.14           C 
ATOM    368  CG  LEU    24      -0.085   1.686   6.503  1.00 11.45           C 
ATOM    369  CD1 LEU    24      -0.125   1.785   4.978  1.00 32.44           C 
ATOM    370  CD2 LEU    24       0.613   2.900   7.108  1.00 63.32           C 
ATOM    371  H   LEU    24      -3.633   0.460   8.292  1.00 38.03           H 
ATOM    372  HA  LEU    24      -2.373   0.204   5.642  1.00 44.33           H 
ATOM    373 1HB  LEU    24      -1.425   1.574   8.169  1.00 41.40           H 
ATOM    374 2HB  LEU    24      -2.102   2.367   6.760  1.00  1.24           H 
ATOM    375  HG  LEU    24       0.495   0.812   6.757  1.00 72.14           H 
ATOM    376 1HD1 LEU    24      -0.719   2.638   4.685  1.00 64.44           H 
ATOM    377 2HD1 LEU    24      -0.561   0.885   4.567  1.00 65.13           H 
ATOM    378 3HD1 LEU    24       0.881   1.901   4.597  1.00  0.11           H 
ATOM    379 1HD2 LEU    24       0.064   3.797   6.860  1.00 44.42           H 
ATOM    380 2HD2 LEU    24       1.616   2.971   6.713  1.00 12.43           H 
ATOM    381 3HD2 LEU    24       0.659   2.790   8.182  1.00 73.44           H 
ATOM    382  N   ARG    25      -1.339  -1.990   6.279  1.00 42.05           N 
ATOM    383  CA  ARG    25      -0.709  -3.273   6.622  1.00 54.11           C 
ATOM    384  C   ARG    25       0.755  -3.104   7.055  1.00 43.24           C 
ATOM    385  O   ARG    25       1.128  -3.474   8.169  1.00  4.35           O 
ATOM    386  CB  ARG    25      -0.807  -4.243   5.433  1.00  3.12           C 
ATOM    387  CG  ARG    25      -0.213  -5.631   5.689  1.00 25.31           C 
ATOM    388  CD  ARG    25      -0.729  -6.258   6.985  1.00 11.22           C 
ATOM    389  NE  ARG    25      -2.158  -6.034   7.187  1.00 60.15           N 
ATOM    390  CZ  ARG    25      -2.832  -6.474   8.213  1.00 44.21           C 
ATOM    391  NH1 ARG    25      -2.299  -7.304   9.052  1.00 71.12           N 
ATOM    392  NH2 ARG    25      -4.058  -6.104   8.373  1.00  0.55           N 
ATOM    393  H   ARG    25      -1.713  -1.868   5.381  1.00 38.03           H 
ATOM    394  HA  ARG    25      -1.263  -3.691   7.453  1.00 35.01           H 
ATOM    395 1HB  ARG    25      -0.288  -3.806   4.589  1.00 54.14           H 
ATOM    396 2HB  ARG    25      -1.849  -4.366   5.170  1.00 72.51           H 
ATOM    397 1HG  ARG    25       0.864  -5.545   5.746  1.00  3.04           H 
ATOM    398 2HG  ARG    25      -0.474  -6.277   4.864  1.00 41.22           H 
ATOM    399 1HD  ARG    25      -0.185  -5.832   7.817  1.00 21.10           H 
ATOM    400 2HD  ARG    25      -0.548  -7.323   6.949  1.00 11.03           H 
ATOM    401  HE  ARG    25      -2.630  -5.469   6.537  1.00 73.15           H 
ATOM    402 1HH1 ARG    25      -1.360  -7.613   8.922  1.00 24.42           H 
ATOM    403 2HH1 ARG    25      -2.827  -7.625   9.834  1.00 14.31           H 
ATOM    404 1HH2 ARG    25      -4.475  -5.474   7.715  1.00 34.00           H 
ATOM    405 2HH2 ARG    25      -4.584  -6.431   9.156  1.00 31.21           H 
ATOM    406  N   ARG    26       1.576  -2.543   6.175  1.00 23.43           N 
ATOM    407  CA  ARG    26       2.999  -2.362   6.465  1.00 71.24           C 
ATOM    408  C   ARG    26       3.679  -1.465   5.428  1.00 73.33           C 
ATOM    409  O   ARG    26       3.462  -1.613   4.229  1.00 52.22           O 
ATOM    410  CB  ARG    26       3.706  -3.726   6.513  1.00 73.01           C 
ATOM    411  CG  ARG    26       5.213  -3.633   6.727  1.00 21.14           C 
ATOM    412  CD  ARG    26       5.863  -5.009   6.824  1.00 54.54           C 
ATOM    413  NE  ARG    26       7.309  -4.920   7.019  1.00 44.44           N 
ATOM    414  CZ  ARG    26       8.148  -5.886   6.760  1.00 30.43           C 
ATOM    415  NH1 ARG    26       7.717  -7.051   6.387  1.00 33.33           N 
ATOM    416  NH2 ARG    26       9.417  -5.692   6.913  1.00 74.11           N 
ATOM    417  H   ARG    26       1.220  -2.240   5.313  1.00 38.03           H 
ATOM    418  HA  ARG    26       3.080  -1.891   7.434  1.00 50.00           H 
ATOM    419 1HB  ARG    26       3.527  -4.245   5.580  1.00 42.12           H 
ATOM    420 2HB  ARG    26       3.284  -4.306   7.321  1.00 74.05           H 
ATOM    421 1HG  ARG    26       5.402  -3.091   7.640  1.00 52.20           H 
ATOM    422 2HG  ARG    26       5.652  -3.100   5.895  1.00 33.44           H 
ATOM    423 1HD  ARG    26       5.663  -5.557   5.912  1.00 33.04           H 
ATOM    424 2HD  ARG    26       5.433  -5.538   7.662  1.00 14.10           H 
ATOM    425  HE  ARG    26       7.668  -4.072   7.357  1.00 70.33           H 
ATOM    426 1HH1 ARG    26       6.736  -7.213   6.302  1.00 34.54           H 
ATOM    427 2HH1 ARG    26       8.362  -7.783   6.187  1.00 40.30           H 
ATOM    428 1HH2 ARG    26       9.747  -4.806   7.233  1.00 14.51           H 
ATOM    429 2HH2 ARG    26      10.063  -6.421   6.706  1.00 20.25           H 
ATOM    430  N   GLU    27       4.495  -0.530   5.899  1.00 70.42           N 
ATOM    431  CA  GLU    27       5.300   0.310   5.011  1.00 55.44           C 
ATOM    432  C   GLU    27       6.732  -0.237   4.926  1.00 34.15           C 
ATOM    433  O   GLU    27       7.556   0.013   5.809  1.00 11.52           O 
ATOM    434  CB  GLU    27       5.310   1.762   5.519  1.00 52.40           C 
ATOM    435  CG  GLU    27       3.916   2.368   5.648  1.00 52.02           C 
ATOM    436  CD  GLU    27       3.926   3.773   6.233  1.00 15.32           C 
ATOM    437  OE1 GLU    27       3.647   4.734   5.490  1.00 13.11           O 
ATOM    438  OE2 GLU    27       4.206   3.918   7.444  1.00 43.23           O 
ATOM    439  H   GLU    27       4.558  -0.398   6.869  1.00 38.03           H 
ATOM    440  HA  GLU    27       4.856   0.283   4.025  1.00  0.23           H 
ATOM    441 1HB  GLU    27       5.883   2.371   4.833  1.00 41.01           H 
ATOM    442 2HB  GLU    27       5.782   1.789   6.492  1.00 51.23           H 
ATOM    443 1HG  GLU    27       3.321   1.733   6.291  1.00 23.10           H 
ATOM    444 2HG  GLU    27       3.463   2.405   4.668  1.00 51.04           H 
ATOM    445  N   VAL    28       7.018  -0.998   3.867  1.00 44.22           N 
ATOM    446  CA  VAL    28       8.340  -1.609   3.693  1.00 51.31           C 
ATOM    447  C   VAL    28       9.398  -0.539   3.390  1.00 41.00           C 
ATOM    448  O   VAL    28       9.167   0.368   2.587  1.00  3.43           O 
ATOM    449  CB  VAL    28       8.338  -2.692   2.581  1.00 12.33           C 
ATOM    450  CG1 VAL    28       7.398  -3.838   2.949  1.00  4.31           C 
ATOM    451  CG2 VAL    28       7.956  -2.091   1.229  1.00 50.52           C 
ATOM    452  H   VAL    28       6.332  -1.134   3.182  1.00 38.03           H 
ATOM    453  HA  VAL    28       8.601  -2.091   4.629  1.00  4.04           H 
ATOM    454  HB  VAL    28       9.340  -3.094   2.499  1.00 53.41           H 
ATOM    455 1HG1 VAL    28       7.700  -4.263   3.896  1.00 34.25           H 
ATOM    456 2HG1 VAL    28       7.439  -4.600   2.185  1.00  2.32           H 
ATOM    457 3HG1 VAL    28       6.386  -3.465   3.031  1.00  0.32           H 
ATOM    458 1HG2 VAL    28       7.963  -2.865   0.474  1.00 12.01           H 
ATOM    459 2HG2 VAL    28       8.668  -1.323   0.960  1.00 34.13           H 
ATOM    460 3HG2 VAL    28       6.969  -1.657   1.293  1.00 45.13           H 
ATOM    461  N   ARG    29      10.552  -0.644   4.038  1.00 65.11           N 
ATOM    462  CA  ARG    29      11.562   0.415   3.991  1.00 44.03           C 
ATOM    463  C   ARG    29      12.873  -0.043   3.332  1.00 33.34           C 
ATOM    464  O   ARG    29      13.078  -1.227   3.063  1.00 41.20           O 
ATOM    465  CB  ARG    29      11.813   0.933   5.413  1.00 23.24           C 
ATOM    466  CG  ARG    29      10.540   1.442   6.091  1.00  1.20           C 
ATOM    467  CD  ARG    29      10.816   2.069   7.450  1.00 73.53           C 
ATOM    468  NE  ARG    29       9.590   2.569   8.073  1.00 32.04           N 
ATOM    469  CZ  ARG    29       9.551   3.535   8.950  1.00 31.52           C 
ATOM    470  NH1 ARG    29      10.645   4.102   9.349  1.00 40.11           N 
ATOM    471  NH2 ARG    29       8.415   3.926   9.429  1.00 74.23           N 
ATOM    472  H   ARG    29      10.735  -1.454   4.560  1.00 38.03           H 
ATOM    473  HA  ARG    29      11.158   1.225   3.398  1.00 13.21           H 
ATOM    474 1HB  ARG    29      12.524   1.746   5.370  1.00  4.31           H 
ATOM    475 2HB  ARG    29      12.226   0.134   6.013  1.00 71.55           H 
ATOM    476 1HG  ARG    29       9.859   0.611   6.220  1.00 32.33           H 
ATOM    477 2HG  ARG    29      10.081   2.186   5.455  1.00 75.45           H 
ATOM    478 1HD  ARG    29      11.504   2.892   7.319  1.00 43.11           H 
ATOM    479 2HD  ARG    29      11.260   1.326   8.096  1.00 73.10           H 
ATOM    480  HE  ARG    29       8.747   2.154   7.804  1.00 22.33           H 
ATOM    481 1HH1 ARG    29      11.519   3.800   8.989  1.00 73.13           H 
ATOM    482 2HH1 ARG    29      10.610   4.839  10.023  1.00 72.01           H 
ATOM    483 1HH2 ARG    29       7.571   3.486   9.133  1.00 33.41           H 
ATOM    484 2HH2 ARG    29       8.382   4.678  10.088  1.00 63.31           H 
ATOM    485  N   ILE    30      13.754   0.920   3.076  1.00 73.14           N 
ATOM    486  CA  ILE    30      15.016   0.666   2.373  1.00 64.23           C 
ATOM    487  C   ILE    30      16.035  -0.037   3.286  1.00 62.23           C 
ATOM    488  O   ILE    30      16.502   0.538   4.267  1.00 43.02           O 
ATOM    489  CB  ILE    30      15.623   1.994   1.851  1.00 24.30           C 
ATOM    490  CG1 ILE    30      14.569   2.779   1.050  1.00 41.01           C 
ATOM    491  CG2 ILE    30      16.856   1.717   0.989  1.00 23.11           C 
ATOM    492  CD1 ILE    30      14.999   4.179   0.662  1.00 31.33           C 
ATOM    493  H   ILE    30      13.552   1.832   3.373  1.00 38.03           H 
ATOM    494  HA  ILE    30      14.804   0.030   1.522  1.00 75.34           H 
ATOM    495  HB  ILE    30      15.933   2.586   2.703  1.00 24.42           H 
ATOM    496 1HG1 ILE    30      13.668   2.864   1.640  1.00 12.24           H 
ATOM    497 2HG1 ILE    30      14.342   2.244   0.139  1.00  3.52           H 
ATOM    498 1HG2 ILE    30      17.590   1.178   1.570  1.00 42.52           H 
ATOM    499 2HG2 ILE    30      17.281   2.652   0.653  1.00 61.30           H 
ATOM    500 3HG2 ILE    30      16.570   1.124   0.131  1.00 23.31           H 
ATOM    501 1HD1 ILE    30      14.219   4.645   0.078  1.00 63.31           H 
ATOM    502 2HD1 ILE    30      15.907   4.132   0.079  1.00  4.53           H 
ATOM    503 3HD1 ILE    30      15.174   4.762   1.557  1.00 52.23           H 
ATOM    504  N   GLN    31      16.374  -1.282   2.962  1.00  4.21           N 
ATOM    505  CA  GLN    31      17.310  -2.070   3.775  1.00 60.32           C 
ATOM    506  C   GLN    31      18.776  -1.760   3.426  1.00  2.41           C 
ATOM    507  O   GLN    31      19.151  -1.711   2.254  1.00  4.24           O 
ATOM    508  CB  GLN    31      17.027  -3.568   3.587  1.00 11.31           C 
ATOM    509  CG  GLN    31      17.959  -4.483   4.374  1.00 62.12           C 
ATOM    510  CD  GLN    31      17.587  -5.950   4.248  1.00 62.13           C 
ATOM    511  OE1 GLN    31      17.037  -6.384   3.238  1.00 34.24           O 
ATOM    512  NE2 GLN    31      17.878  -6.724   5.271  1.00 63.40           N 
ATOM    513  H   GLN    31      15.981  -1.687   2.161  1.00 38.03           H 
ATOM    514  HA  GLN    31      17.142  -1.816   4.813  1.00 42.34           H 
ATOM    515 1HB  GLN    31      17.124  -3.810   2.537  1.00 15.40           H 
ATOM    516 2HB  GLN    31      16.011  -3.770   3.898  1.00 23.14           H 
ATOM    517 1HG  GLN    31      17.917  -4.204   5.419  1.00 44.43           H 
ATOM    518 2HG  GLN    31      18.967  -4.352   4.010  1.00 70.45           H 
ATOM    519 1HE2 GLN    31      18.308  -6.318   6.052  1.00 10.34           H 
ATOM    520 2HE2 GLN    31      17.658  -7.674   5.205  1.00  1.20           H 
ATOM    521  N   ASN    32      19.605  -1.561   4.454  1.00 61.43           N 
ATOM    522  CA  ASN    32      21.033  -1.276   4.258  1.00 53.10           C 
ATOM    523  C   ASN    32      21.819  -2.572   3.993  1.00  4.14           C 
ATOM    524  O   ASN    32      21.450  -3.640   4.486  1.00  3.33           O 
ATOM    525  CB  ASN    32      21.611  -0.557   5.487  1.00 10.53           C 
ATOM    526  CG  ASN    32      20.880   0.737   5.808  1.00 33.41           C 
ATOM    527  OD1 ASN    32      21.215   1.804   5.303  1.00 33.32           O 
ATOM    528  ND2 ASN    32      19.882   0.657   6.666  1.00  1.53           N 
ATOM    529  H   ASN    32      19.253  -1.621   5.366  1.00 38.03           H 
ATOM    530  HA  ASN    32      21.129  -0.628   3.397  1.00 45.03           H 
ATOM    531 1HB  ASN    32      22.652  -0.326   5.308  1.00 51.23           H 
ATOM    532 2HB  ASN    32      21.538  -1.209   6.345  1.00 43.12           H 
ATOM    533 1HD2 ASN    32      19.666  -0.219   7.043  1.00 25.43           H 
ATOM    534 2HD2 ASN    32      19.405   1.480   6.892  1.00 32.52           H 
ATOM    535  N   GLU    33      22.909  -2.470   3.229  1.00  3.20           N 
ATOM    536  CA  GLU    33      23.714  -3.647   2.860  1.00 64.42           C 
ATOM    537  C   GLU    33      24.241  -4.392   4.094  1.00 63.13           C 
ATOM    538  O   GLU    33      24.360  -5.619   4.089  1.00 60.23           O 
ATOM    539  CB  GLU    33      24.897  -3.235   1.971  1.00 10.22           C 
ATOM    540  CG  GLU    33      24.491  -2.625   0.632  1.00 51.42           C 
ATOM    541  CD  GLU    33      25.688  -2.323  -0.259  1.00 23.33           C 
ATOM    542  OE1 GLU    33      26.138  -3.232  -0.986  1.00 65.51           O 
ATOM    543  OE2 GLU    33      26.192  -1.179  -0.227  1.00 52.55           O 
ATOM    544  H   GLU    33      23.186  -1.585   2.907  1.00 38.03           H 
ATOM    545  HA  GLU    33      23.077  -4.315   2.299  1.00 62.32           H 
ATOM    546 1HB  GLU    33      25.503  -4.109   1.773  1.00 13.11           H 
ATOM    547 2HB  GLU    33      25.496  -2.509   2.503  1.00 41.44           H 
ATOM    548 1HG  GLU    33      23.954  -1.704   0.816  1.00 41.14           H 
ATOM    549 2HG  GLU    33      23.841  -3.319   0.118  1.00 25.22           H 
ATOM    550  N   ASP    34      24.560  -3.641   5.144  1.00 11.03           N 
ATOM    551  CA  ASP    34      25.068  -4.211   6.395  1.00 51.43           C 
ATOM    552  C   ASP    34      24.071  -5.199   7.024  1.00 74.11           C 
ATOM    553  O   ASP    34      24.464  -6.123   7.737  1.00 72.41           O 
ATOM    554  CB  ASP    34      25.376  -3.080   7.380  1.00 43.21           C 
ATOM    555  CG  ASP    34      26.375  -2.088   6.817  1.00 72.13           C 
ATOM    556  OD1 ASP    34      25.997  -1.307   5.919  1.00 53.52           O 
ATOM    557  OD2 ASP    34      27.534  -2.068   7.277  1.00 72.11           O 
ATOM    558  H   ASP    34      24.460  -2.668   5.074  1.00 38.03           H 
ATOM    559  HA  ASP    34      25.984  -4.738   6.171  1.00 24.22           H 
ATOM    560 1HB  ASP    34      25.780  -3.499   8.291  1.00  5.34           H 
ATOM    561 2HB  ASP    34      24.461  -2.551   7.609  1.00 40.13           H 
ATOM    562  N   GLY    35      22.782  -5.000   6.754  1.00 12.34           N 
ATOM    563  CA  GLY    35      21.759  -5.885   7.299  1.00 53.01           C 
ATOM    564  C   GLY    35      20.526  -5.138   7.794  1.00 32.30           C 
ATOM    565  O   GLY    35      19.412  -5.393   7.334  1.00 42.24           O 
ATOM    566  H   GLY    35      22.524  -4.257   6.172  1.00 38.03           H 
ATOM    567 1HA  GLY    35      22.179  -6.444   8.125  1.00 45.53           H 
ATOM    568 2HA  GLY    35      21.460  -6.581   6.529  1.00  5.14           H 
ATOM    569  N   SER    36      20.727  -4.208   8.729  1.00 53.54           N 
ATOM    570  CA  SER    36      19.615  -3.444   9.326  1.00 64.41           C 
ATOM    571  C   SER    36      18.875  -2.583   8.291  1.00  1.02           C 
ATOM    572  O   SER    36      19.461  -2.101   7.318  1.00 72.14           O 
ATOM    573  CB  SER    36      20.117  -2.547  10.467  1.00 61.32           C 
ATOM    574  OG  SER    36      20.658  -3.310  11.536  1.00 44.14           O 
ATOM    575  H   SER    36      21.646  -4.033   9.034  1.00 38.03           H 
ATOM    576  HA  SER    36      18.917  -4.161   9.735  1.00 20.12           H 
ATOM    577 1HB  SER    36      19.292  -1.959  10.844  1.00 51.04           H 
ATOM    578 2HB  SER    36      20.885  -1.885  10.092  1.00 61.34           H 
ATOM    579  HG  SER    36      20.516  -2.838  12.366  1.00 33.21           H 
ATOM    580  N   VAL    37      17.586  -2.374   8.524  1.00 50.21           N 
ATOM    581  CA  VAL    37      16.742  -1.593   7.619  1.00  2.34           C 
ATOM    582  C   VAL    37      16.727  -0.107   8.015  1.00 72.32           C 
ATOM    583  O   VAL    37      16.829   0.234   9.194  1.00 40.44           O 
ATOM    584  CB  VAL    37      15.295  -2.148   7.609  1.00 20.54           C 
ATOM    585  CG1 VAL    37      14.430  -1.426   6.577  1.00 15.04           C 
ATOM    586  CG2 VAL    37      15.310  -3.654   7.353  1.00 41.23           C 
ATOM    587  H   VAL    37      17.182  -2.761   9.332  1.00 38.03           H 
ATOM    588  HA  VAL    37      17.146  -1.685   6.620  1.00 53.44           H 
ATOM    589  HB  VAL    37      14.860  -1.979   8.585  1.00  1.44           H 
ATOM    590 1HG1 VAL    37      14.385  -0.374   6.815  1.00 13.03           H 
ATOM    591 2HG1 VAL    37      13.431  -1.840   6.589  1.00 23.23           H 
ATOM    592 3HG1 VAL    37      14.858  -1.554   5.592  1.00 70.02           H 
ATOM    593 1HG2 VAL    37      15.749  -3.853   6.387  1.00 63.40           H 
ATOM    594 2HG2 VAL    37      14.299  -4.035   7.374  1.00 64.24           H 
ATOM    595 3HG2 VAL    37      15.894  -4.144   8.120  1.00 20.31           H 
ATOM    596  N   SER    38      16.607   0.767   7.021  1.00 51.31           N 
ATOM    597  CA  SER    38      16.623   2.221   7.250  1.00 72.25           C 
ATOM    598  C   SER    38      15.259   2.748   7.710  1.00 65.43           C 
ATOM    599  O   SER    38      14.267   2.016   7.760  1.00 33.54           O 
ATOM    600  CB  SER    38      17.039   2.959   5.968  1.00 62.33           C 
ATOM    601  OG  SER    38      17.008   4.368   6.146  1.00 64.51           O 
ATOM    602  H   SER    38      16.493   0.432   6.107  1.00 38.03           H 
ATOM    603  HA  SER    38      17.352   2.427   8.021  1.00 72.52           H 
ATOM    604 1HB  SER    38      16.360   2.698   5.168  1.00 62.11           H 
ATOM    605 2HB  SER    38      18.044   2.665   5.695  1.00 34.12           H 
ATOM    606  HG  SER    38      17.881   4.736   5.950  1.00  0.41           H 
ATOM    607  N   ASP    39      15.225   4.032   8.045  1.00 55.54           N 
ATOM    608  CA  ASP    39      13.990   4.710   8.437  1.00 15.11           C 
ATOM    609  C   ASP    39      13.254   5.282   7.210  1.00 72.13           C 
ATOM    610  O   ASP    39      12.102   5.710   7.305  1.00 31.44           O 
ATOM    611  CB  ASP    39      14.307   5.817   9.450  1.00 25.44           C 
ATOM    612  CG  ASP    39      15.365   6.788   8.949  1.00 25.22           C 
ATOM    613  OD1 ASP    39      16.535   6.372   8.788  1.00  1.12           O 
ATOM    614  OD2 ASP    39      15.039   7.970   8.723  1.00 64.33           O 
ATOM    615  H   ASP    39      16.062   4.546   8.027  1.00 38.03           H 
ATOM    616  HA  ASP    39      13.349   3.980   8.911  1.00  2.51           H 
ATOM    617 1HB  ASP    39      14.666   5.365  10.364  1.00 13.25           H 
ATOM    618 2HB  ASP    39      13.404   6.371   9.665  1.00 54.23           H 
ATOM    619  N   GLU    40      13.927   5.272   6.057  1.00  4.12           N 
ATOM    620  CA  GLU    40      13.331   5.738   4.797  1.00 62.14           C 
ATOM    621  C   GLU    40      12.461   4.657   4.142  1.00 71.23           C 
ATOM    622  O   GLU    40      12.790   3.470   4.172  1.00 50.15           O 
ATOM    623  CB  GLU    40      14.426   6.199   3.827  1.00 42.32           C 
ATOM    624  CG  GLU    40      15.109   7.495   4.249  1.00 12.15           C 
ATOM    625  CD  GLU    40      14.145   8.672   4.311  1.00 54.34           C 
ATOM    626  OE1 GLU    40      13.903   9.306   3.263  1.00 55.13           O 
ATOM    627  OE2 GLU    40      13.616   8.962   5.405  1.00 14.55           O 
ATOM    628  H   GLU    40      14.854   4.947   6.053  1.00 38.03           H 
ATOM    629  HA  GLU    40      12.698   6.586   5.031  1.00  1.34           H 
ATOM    630 1HB  GLU    40      13.990   6.348   2.848  1.00  3.34           H 
ATOM    631 2HB  GLU    40      15.180   5.425   3.761  1.00 65.01           H 
ATOM    632 1HG  GLU    40      15.891   7.722   3.539  1.00 60.31           H 
ATOM    633 2HG  GLU    40      15.544   7.352   5.227  1.00 11.34           H 
ATOM    634  N   ILE    41      11.370   5.088   3.518  1.00 53.25           N 
ATOM    635  CA  ILE    41      10.355   4.172   2.978  1.00 24.45           C 
ATOM    636  C   ILE    41      10.710   3.673   1.562  1.00 13.22           C 
ATOM    637  O   ILE    41      11.418   4.344   0.812  1.00 52.43           O 
ATOM    638  CB  ILE    41       8.964   4.863   2.925  1.00 31.23           C 
ATOM    639  CG1 ILE    41       8.601   5.481   4.288  1.00  1.23           C 
ATOM    640  CG2 ILE    41       7.879   3.872   2.489  1.00  0.44           C 
ATOM    641  CD1 ILE    41       8.314   4.464   5.372  1.00 34.44           C 
ATOM    642  H   ILE    41      11.247   6.057   3.405  1.00 38.03           H 
ATOM    643  HA  ILE    41      10.283   3.321   3.643  1.00  3.11           H 
ATOM    644  HB  ILE    41       9.011   5.651   2.185  1.00 23.44           H 
ATOM    645 1HG1 ILE    41       7.720   6.097   4.171  1.00 11.52           H 
ATOM    646 2HG1 ILE    41       9.420   6.100   4.626  1.00 65.22           H 
ATOM    647 1HG2 ILE    41       7.852   3.042   3.181  1.00 73.41           H 
ATOM    648 2HG2 ILE    41       8.101   3.506   1.497  1.00 60.22           H 
ATOM    649 3HG2 ILE    41       6.919   4.368   2.481  1.00 71.22           H 
ATOM    650 1HD1 ILE    41       9.166   3.808   5.490  1.00 53.12           H 
ATOM    651 2HD1 ILE    41       7.445   3.883   5.097  1.00 64.35           H 
ATOM    652 3HD1 ILE    41       8.124   4.976   6.303  1.00 11.23           H 
ATOM    653  N   LYS    42      10.209   2.488   1.209  1.00 13.55           N 
ATOM    654  CA  LYS    42      10.345   1.945  -0.149  1.00 24.51           C 
ATOM    655  C   LYS    42       8.960   1.853  -0.825  1.00 22.30           C 
ATOM    656  O   LYS    42       8.732   2.441  -1.884  1.00 24.53           O 
ATOM    657  CB  LYS    42      11.014   0.562  -0.102  1.00 24.33           C 
ATOM    658  CG  LYS    42      11.343  -0.016  -1.475  1.00 62.14           C 
ATOM    659  CD  LYS    42      12.324   0.870  -2.240  1.00 33.01           C 
ATOM    660  CE  LYS    42      12.662   0.300  -3.609  1.00 60.32           C 
ATOM    661  NZ  LYS    42      13.573   1.196  -4.369  1.00 72.54           N 
ATOM    662  H   LYS    42       9.731   1.962   1.883  1.00 38.03           H 
ATOM    663  HA  LYS    42      10.969   2.622  -0.721  1.00 72.43           H 
ATOM    664 1HB  LYS    42      10.352  -0.128   0.406  1.00 62.41           H 
ATOM    665 2HB  LYS    42      11.934   0.638   0.462  1.00 11.51           H 
ATOM    666 1HG  LYS    42      10.429  -0.103  -2.046  1.00 31.10           H 
ATOM    667 2HG  LYS    42      11.782  -0.996  -1.348  1.00 43.35           H 
ATOM    668 1HD  LYS    42      13.235   0.962  -1.663  1.00 70.42           H 
ATOM    669 2HD  LYS    42      11.883   1.848  -2.371  1.00 43.50           H 
ATOM    670 1HE  LYS    42      11.747   0.169  -4.170  1.00 25.12           H 
ATOM    671 2HE  LYS    42      13.145  -0.659  -3.478  1.00  0.15           H 
ATOM    672 1HZ  LYS    42      14.465   1.328  -3.851  1.00 32.04           H 
ATOM    673 2HZ  LYS    42      13.130   2.126  -4.508  1.00 31.13           H 
ATOM    674 3HZ  LYS    42      13.786   0.786  -5.299  1.00 43.43           H 
ATOM    675  N   GLU    43       8.043   1.109  -0.197  1.00 64.02           N 
ATOM    676  CA  GLU    43       6.634   1.039  -0.625  1.00 41.54           C 
ATOM    677  C   GLU    43       5.694   1.002   0.592  1.00 53.40           C 
ATOM    678  O   GLU    43       6.114   0.671   1.703  1.00 51.32           O 
ATOM    679  CB  GLU    43       6.377  -0.200  -1.501  1.00 32.35           C 
ATOM    680  CG  GLU    43       7.136  -0.198  -2.820  1.00 35.30           C 
ATOM    681  CD  GLU    43       6.641  -1.263  -3.794  1.00 33.11           C 
ATOM    682  OE1 GLU    43       7.330  -2.290  -3.965  1.00 42.54           O 
ATOM    683  OE2 GLU    43       5.554  -1.083  -4.391  1.00 72.45           O 
ATOM    684  H   GLU    43       8.319   0.584   0.576  1.00 38.03           H 
ATOM    685  HA  GLU    43       6.417   1.927  -1.203  1.00 15.30           H 
ATOM    686 1HB  GLU    43       5.318  -0.256  -1.721  1.00 54.03           H 
ATOM    687 2HB  GLU    43       6.663  -1.084  -0.948  1.00 72.25           H 
ATOM    688 1HG  GLU    43       8.184  -0.372  -2.616  1.00 30.51           H 
ATOM    689 2HG  GLU    43       7.023   0.773  -3.276  1.00 71.51           H 
ATOM    690  N   ARG    44       4.422   1.338   0.381  1.00 35.34           N 
ATOM    691  CA  ARG    44       3.419   1.317   1.457  1.00 73.22           C 
ATOM    692  C   ARG    44       2.285   0.326   1.132  1.00 31.44           C 
ATOM    693  O   ARG    44       1.563   0.500   0.150  1.00 74.32           O 
ATOM    694  CB  ARG    44       2.831   2.721   1.672  1.00 75.45           C 
ATOM    695  CG  ARG    44       3.879   3.821   1.843  1.00 55.22           C 
ATOM    696  CD  ARG    44       3.234   5.163   2.173  1.00 42.23           C 
ATOM    697  NE  ARG    44       4.183   6.277   2.093  1.00 60.31           N 
ATOM    698  CZ  ARG    44       4.378   7.152   3.048  1.00 64.32           C 
ATOM    699  NH1 ARG    44       3.842   6.986   4.211  1.00  3.41           N 
ATOM    700  NH2 ARG    44       5.145   8.174   2.847  1.00 25.25           N 
ATOM    701  H   ARG    44       4.147   1.604  -0.522  1.00 38.03           H 
ATOM    702  HA  ARG    44       3.910   1.000   2.366  1.00 32.01           H 
ATOM    703 1HB  ARG    44       2.212   2.703   2.558  1.00 61.32           H 
ATOM    704 2HB  ARG    44       2.212   2.975   0.822  1.00 44.33           H 
ATOM    705 1HG  ARG    44       4.441   3.916   0.924  1.00 11.35           H 
ATOM    706 2HG  ARG    44       4.546   3.548   2.648  1.00 53.45           H 
ATOM    707 1HD  ARG    44       2.829   5.114   3.174  1.00 53.14           H 
ATOM    708 2HD  ARG    44       2.431   5.342   1.472  1.00 12.03           H 
ATOM    709  HE  ARG    44       4.665   6.396   1.256  1.00 54.34           H 
ATOM    710 1HH1 ARG    44       3.278   6.181   4.391  1.00 41.03           H 
ATOM    711 2HH1 ARG    44       4.000   7.656   4.936  1.00 63.20           H 
ATOM    712 1HH2 ARG    44       5.588   8.301   1.964  1.00 33.45           H 
ATOM    713 2HH2 ARG    44       5.289   8.839   3.579  1.00 12.11           H 
ATOM    714  N   THR    45       2.131  -0.705   1.962  1.00  2.33           N 
ATOM    715  CA  THR    45       1.095  -1.733   1.748  1.00 51.21           C 
ATOM    716  C   THR    45      -0.178  -1.446   2.568  1.00 53.41           C 
ATOM    717  O   THR    45      -0.132  -1.365   3.800  1.00 11.32           O 
ATOM    718  CB  THR    45       1.618  -3.144   2.123  1.00 23.32           C 
ATOM    719  OG1 THR    45       2.821  -3.437   1.391  1.00 54.35           O 
ATOM    720  CG2 THR    45       0.570  -4.219   1.835  1.00 35.04           C 
ATOM    721  H   THR    45       2.728  -0.783   2.735  1.00 38.03           H 
ATOM    722  HA  THR    45       0.841  -1.737   0.696  1.00 73.20           H 
ATOM    723  HB  THR    45       1.844  -3.155   3.182  1.00 61.14           H 
ATOM    724  HG1 THR    45       2.946  -2.779   0.697  1.00 53.41           H 
ATOM    725 1HG2 THR    45       0.295  -4.184   0.790  1.00 41.03           H 
ATOM    726 2HG2 THR    45      -0.306  -4.043   2.441  1.00 15.34           H 
ATOM    727 3HG2 THR    45       0.978  -5.192   2.067  1.00 54.51           H 
ATOM    728  N   TYR    46      -1.311  -1.306   1.878  1.00 63.40           N 
ATOM    729  CA  TYR    46      -2.603  -1.018   2.522  1.00 72.32           C 
ATOM    730  C   TYR    46      -3.548  -2.233   2.489  1.00  1.04           C 
ATOM    731  O   TYR    46      -3.463  -3.086   1.601  1.00 65.01           O 
ATOM    732  CB  TYR    46      -3.298   0.155   1.816  1.00 33.02           C 
ATOM    733  CG  TYR    46      -2.516   1.455   1.830  1.00  4.10           C 
ATOM    734  CD1 TYR    46      -2.855   2.484   2.700  1.00 12.21           C 
ATOM    735  CD2 TYR    46      -1.453   1.658   0.960  1.00 21.03           C 
ATOM    736  CE1 TYR    46      -2.159   3.678   2.701  1.00 10.35           C 
ATOM    737  CE2 TYR    46      -0.750   2.843   0.957  1.00 52.54           C 
ATOM    738  CZ  TYR    46      -1.106   3.853   1.827  1.00 10.33           C 
ATOM    739  OH  TYR    46      -0.407   5.041   1.821  1.00  1.03           O 
ATOM    740  H   TYR    46      -1.282  -1.396   0.904  1.00 38.03           H 
ATOM    741  HA  TYR    46      -2.415  -0.746   3.554  1.00 75.12           H 
ATOM    742 1HB  TYR    46      -4.251   0.339   2.295  1.00 43.31           H 
ATOM    743 2HB  TYR    46      -3.471  -0.110   0.785  1.00  4.15           H 
ATOM    744  HD1 TYR    46      -3.675   2.338   3.388  1.00 54.12           H 
ATOM    745  HD2 TYR    46      -1.174   0.867   0.278  1.00 51.41           H 
ATOM    746  HE1 TYR    46      -2.439   4.465   3.385  1.00 41.21           H 
ATOM    747  HE2 TYR    46       0.076   2.978   0.272  1.00 62.02           H 
ATOM    748  HH  TYR    46      -0.182   5.274   0.916  1.00 21.43           H 
ATOM    749  N   ASP    47      -4.462  -2.282   3.457  1.00 31.32           N 
ATOM    750  CA  ASP    47      -5.517  -3.300   3.502  1.00 25.41           C 
ATOM    751  C   ASP    47      -6.825  -2.755   2.903  1.00 60.53           C 
ATOM    752  O   ASP    47      -7.443  -1.849   3.471  1.00 74.55           O 
ATOM    753  CB  ASP    47      -5.774  -3.726   4.954  1.00 32.23           C 
ATOM    754  CG  ASP    47      -4.574  -4.384   5.604  1.00 12.14           C 
ATOM    755  OD1 ASP    47      -4.023  -5.341   5.025  1.00 62.03           O 
ATOM    756  OD2 ASP    47      -4.175  -3.950   6.701  1.00 32.00           O 
ATOM    757  H   ASP    47      -4.426  -1.613   4.169  1.00 38.03           H 
ATOM    758  HA  ASP    47      -5.190  -4.160   2.930  1.00 74.10           H 
ATOM    759 1HB  ASP    47      -6.598  -4.426   4.975  1.00  4.43           H 
ATOM    760 2HB  ASP    47      -6.040  -2.851   5.533  1.00 73.22           H 
ATOM    761  N   LEU    48      -7.242  -3.297   1.759  1.00 63.31           N 
ATOM    762  CA  LEU    48      -8.516  -2.901   1.136  1.00 15.53           C 
ATOM    763  C   LEU    48      -9.430  -4.118   0.918  1.00 15.41           C 
ATOM    764  O   LEU    48      -8.972  -5.181   0.492  1.00 61.30           O 
ATOM    765  CB  LEU    48      -8.266  -2.205  -0.215  1.00 55.31           C 
ATOM    766  CG  LEU    48      -7.406  -0.929  -0.171  1.00 71.53           C 
ATOM    767  CD1 LEU    48      -7.264  -0.321  -1.566  1.00 41.21           C 
ATOM    768  CD2 LEU    48      -7.992   0.096   0.794  1.00 60.44           C 
ATOM    769  H   LEU    48      -6.681  -3.975   1.318  1.00 38.03           H 
ATOM    770  HA  LEU    48      -9.011  -2.207   1.802  1.00 51.14           H 
ATOM    771 1HB  LEU    48      -9.225  -1.951  -0.647  1.00 54.13           H 
ATOM    772 2HB  LEU    48      -7.778  -2.915  -0.870  1.00  3.21           H 
ATOM    773  HG  LEU    48      -6.416  -1.187   0.178  1.00 70.10           H 
ATOM    774 1HD1 LEU    48      -8.239  -0.045  -1.942  1.00  2.34           H 
ATOM    775 2HD1 LEU    48      -6.813  -1.043  -2.231  1.00 23.03           H 
ATOM    776 3HD1 LEU    48      -6.638   0.557  -1.513  1.00 65.21           H 
ATOM    777 1HD2 LEU    48      -8.034  -0.325   1.788  1.00 40.34           H 
ATOM    778 2HD2 LEU    48      -8.990   0.368   0.476  1.00 42.23           H 
ATOM    779 3HD2 LEU    48      -7.368   0.979   0.805  1.00  5.44           H 
ATOM    780  N   LYS    49     -10.724  -3.965   1.212  1.00 45.14           N 
ATOM    781  CA  LYS    49     -11.701  -5.024   0.924  1.00 60.20           C 
ATOM    782  C   LYS    49     -12.439  -4.729  -0.389  1.00 45.21           C 
ATOM    783  O   LYS    49     -12.771  -3.578  -0.681  1.00 44.14           O 
ATOM    784  CB  LYS    49     -12.718  -5.194   2.071  1.00 72.24           C 
ATOM    785  CG  LYS    49     -13.657  -4.002   2.281  1.00 52.03           C 
ATOM    786  CD  LYS    49     -13.239  -3.123   3.457  1.00  0.15           C 
ATOM    787  CE  LYS    49     -13.415  -3.841   4.792  1.00 40.23           C 
ATOM    788  NZ  LYS    49     -13.027  -2.978   5.936  1.00 22.05           N 
ATOM    789  H   LYS    49     -11.029  -3.123   1.615  1.00 38.03           H 
ATOM    790  HA  LYS    49     -11.154  -5.950   0.805  1.00  4.43           H 
ATOM    791 1HB  LYS    49     -12.173  -5.366   2.990  1.00 70.24           H 
ATOM    792 2HB  LYS    49     -13.324  -6.065   1.864  1.00  1.45           H 
ATOM    793 1HG  LYS    49     -14.656  -4.376   2.463  1.00 50.34           H 
ATOM    794 2HG  LYS    49     -13.662  -3.400   1.386  1.00 51.42           H 
ATOM    795 1HD  LYS    49     -13.846  -2.228   3.456  1.00 45.23           H 
ATOM    796 2HD  LYS    49     -12.199  -2.849   3.340  1.00 75.20           H 
ATOM    797 1HE  LYS    49     -12.796  -4.728   4.798  1.00  3.20           H 
ATOM    798 2HE  LYS    49     -14.451  -4.124   4.905  1.00 40.24           H 
ATOM    799 1HZ  LYS    49     -12.022  -2.724   5.863  1.00 73.11           H 
ATOM    800 2HZ  LYS    49     -13.184  -3.480   6.836  1.00 24.12           H 
ATOM    801 3HZ  LYS    49     -13.597  -2.107   5.936  1.00 11.23           H 
ATOM    802  N   SER    50     -12.682  -5.772  -1.180  1.00 73.12           N 
ATOM    803  CA  SER    50     -13.362  -5.624  -2.472  1.00 55.40           C 
ATOM    804  C   SER    50     -14.506  -6.635  -2.624  1.00  4.21           C 
ATOM    805  O   SER    50     -14.462  -7.735  -2.070  1.00 24.42           O 
ATOM    806  CB  SER    50     -12.362  -5.795  -3.624  1.00  3.55           C 
ATOM    807  OG  SER    50     -11.766  -7.084  -3.604  1.00 20.51           O 
ATOM    808  H   SER    50     -12.396  -6.665  -0.893  1.00 38.03           H 
ATOM    809  HA  SER    50     -13.777  -4.626  -2.519  1.00 41.42           H 
ATOM    810 1HB  SER    50     -11.584  -5.052  -3.531  1.00  3.22           H 
ATOM    811 2HB  SER    50     -12.872  -5.663  -4.567  1.00 20.24           H 
ATOM    812  HG  SER    50     -10.889  -7.030  -3.214  1.00 13.21           H 
ATOM    813  N   LYS    51     -15.541  -6.248  -3.366  1.00 54.32           N 
ATOM    814  CA  LYS    51     -16.681  -7.133  -3.628  1.00  1.12           C 
ATOM    815  C   LYS    51     -16.364  -8.142  -4.744  1.00 34.41           C 
ATOM    816  O   LYS    51     -16.046  -7.757  -5.871  1.00  1.12           O 
ATOM    817  CB  LYS    51     -17.921  -6.312  -4.013  1.00 64.33           C 
ATOM    818  CG  LYS    51     -18.490  -5.466  -2.878  1.00 72.11           C 
ATOM    819  CD  LYS    51     -18.936  -6.328  -1.697  1.00 41.12           C 
ATOM    820  CE  LYS    51     -19.703  -5.518  -0.655  1.00 62.12           C 
ATOM    821  NZ  LYS    51     -20.944  -4.916  -1.218  1.00 60.35           N 
ATOM    822  H   LYS    51     -15.537  -5.348  -3.748  1.00 38.03           H 
ATOM    823  HA  LYS    51     -16.892  -7.678  -2.718  1.00 70.32           H 
ATOM    824 1HB  LYS    51     -18.695  -6.988  -4.348  1.00 22.25           H 
ATOM    825 2HB  LYS    51     -17.662  -5.651  -4.829  1.00 60.44           H 
ATOM    826 1HG  LYS    51     -19.339  -4.909  -3.248  1.00 55.11           H 
ATOM    827 2HG  LYS    51     -17.730  -4.776  -2.539  1.00 22.35           H 
ATOM    828 1HD  LYS    51     -18.062  -6.763  -1.230  1.00 72.31           H 
ATOM    829 2HD  LYS    51     -19.578  -7.116  -2.064  1.00 35.21           H 
ATOM    830 1HE  LYS    51     -19.064  -4.728  -0.286  1.00  4.21           H 
ATOM    831 2HE  LYS    51     -19.971  -6.170   0.162  1.00 32.54           H 
ATOM    832 1HZ  LYS    51     -20.705  -4.244  -1.977  1.00 52.15           H 
ATOM    833 2HZ  LYS    51     -21.465  -4.408  -0.474  1.00 35.32           H 
ATOM    834 3HZ  LYS    51     -21.561  -5.656  -1.608  1.00 55.44           H 
ATOM    835  N   GLY    52     -16.464  -9.431  -4.428  1.00 34.23           N 
ATOM    836  CA  GLY    52     -16.205 -10.473  -5.419  1.00  2.21           C 
ATOM    837  C   GLY    52     -15.995 -11.851  -4.797  1.00 23.21           C 
ATOM    838  O   GLY    52     -16.958 -12.542  -4.457  1.00 52.40           O 
ATOM    839  H   GLY    52     -16.714  -9.679  -3.513  1.00 38.03           H 
ATOM    840 1HA  GLY    52     -15.322 -10.208  -5.982  1.00 64.35           H 
ATOM    841 2HA  GLY    52     -17.046 -10.523  -6.095  1.00 61.13           H 
ATOM    842  N   GLN    53     -14.735 -12.243  -4.632  1.00 43.02           N 
ATOM    843  CA  GLN    53     -14.388 -13.566  -4.093  1.00 50.23           C 
ATOM    844  C   GLN    53     -14.193 -13.535  -2.566  1.00 54.42           C 
ATOM    845  O   GLN    53     -13.922 -14.567  -1.947  1.00  0.02           O 
ATOM    846  CB  GLN    53     -13.117 -14.090  -4.779  1.00  1.44           C 
ATOM    847  CG  GLN    53     -13.237 -14.208  -6.297  1.00  3.50           C 
ATOM    848  CD  GLN    53     -14.342 -15.159  -6.732  1.00  3.52           C 
ATOM    849  OE1 GLN    53     -15.487 -14.762  -6.924  1.00 34.45           O 
ATOM    850  NE2 GLN    53     -14.010 -16.423  -6.889  1.00 52.20           N 
ATOM    851  H   GLN    53     -14.014 -11.629  -4.887  1.00 38.03           H 
ATOM    852  HA  GLN    53     -15.204 -14.237  -4.321  1.00 51.12           H 
ATOM    853 1HB  GLN    53     -12.882 -15.067  -4.382  1.00 55.22           H 
ATOM    854 2HB  GLN    53     -12.300 -13.417  -4.559  1.00  4.31           H 
ATOM    855 1HG  GLN    53     -12.297 -14.566  -6.692  1.00 24.50           H 
ATOM    856 2HG  GLN    53     -13.445 -13.229  -6.707  1.00 43.21           H 
ATOM    857 1HE2 GLN    53     -13.083 -16.684  -6.720  1.00 64.02           H 
ATOM    858 2HE2 GLN    53     -14.708 -17.048  -7.171  1.00 22.54           H 
ATOM    859  N   GLY    54     -14.331 -12.351  -1.966  1.00 41.33           N 
ATOM    860  CA  GLY    54     -14.203 -12.217  -0.513  1.00 14.14           C 
ATOM    861  C   GLY    54     -12.756 -12.235  -0.023  1.00 21.44           C 
ATOM    862  O   GLY    54     -12.461 -12.750   1.059  1.00 50.42           O 
ATOM    863  H   GLY    54     -14.528 -11.561  -2.511  1.00 38.03           H 
ATOM    864 1HA  GLY    54     -14.742 -13.026  -0.039  1.00 55.31           H 
ATOM    865 2HA  GLY    54     -14.654 -11.283  -0.212  1.00 22.41           H 
ATOM    866  N   ARG    55     -11.850 -11.667  -0.813  1.00 32.52           N 
ATOM    867  CA  ARG    55     -10.428 -11.619  -0.454  1.00 23.45           C 
ATOM    868  C   ARG    55      -9.956 -10.192  -0.130  1.00 43.42           C 
ATOM    869  O   ARG    55     -10.187  -9.258  -0.898  1.00 31.52           O 
ATOM    870  CB  ARG    55      -9.573 -12.210  -1.588  1.00 13.52           C 
ATOM    871  CG  ARG    55      -9.421 -13.730  -1.529  1.00 73.50           C 
ATOM    872  CD  ARG    55      -8.607 -14.163  -0.311  1.00  0.04           C 
ATOM    873  NE  ARG    55      -8.364 -15.604  -0.283  1.00 34.53           N 
ATOM    874  CZ  ARG    55      -7.361 -16.163   0.344  1.00 41.42           C 
ATOM    875  NH1 ARG    55      -6.504 -15.446   0.992  1.00 32.23           N 
ATOM    876  NH2 ARG    55      -7.222 -17.445   0.325  1.00  3.32           N 
ATOM    877  H   ARG    55     -12.140 -11.270  -1.661  1.00 38.03           H 
ATOM    878  HA  ARG    55     -10.293 -12.229   0.430  1.00  4.20           H 
ATOM    879 1HB  ARG    55      -8.584 -11.771  -1.548  1.00 62.35           H 
ATOM    880 2HB  ARG    55     -10.026 -11.953  -2.534  1.00 33.23           H 
ATOM    881 1HG  ARG    55      -8.917 -14.066  -2.424  1.00  1.41           H 
ATOM    882 2HG  ARG    55     -10.401 -14.183  -1.476  1.00 44.10           H 
ATOM    883 1HD  ARG    55      -9.144 -13.881   0.584  1.00 72.10           H 
ATOM    884 2HD  ARG    55      -7.655 -13.650  -0.332  1.00 63.33           H 
ATOM    885  HE  ARG    55      -8.996 -16.181  -0.756  1.00 12.01           H 
ATOM    886 1HH1 ARG    55      -6.602 -14.455   1.023  1.00 52.24           H 
ATOM    887 2HH1 ARG    55      -5.738 -15.887   1.461  1.00 20.33           H 
ATOM    888 1HH2 ARG    55      -7.882 -18.007  -0.169  1.00 60.20           H 
ATOM    889 2HH2 ARG    55      -6.459 -17.868   0.804  1.00 51.33           H 
ATOM    890  N   MET    56      -9.301 -10.035   1.020  1.00 44.22           N 
ATOM    891  CA  MET    56      -8.649  -8.768   1.371  1.00 42.10           C 
ATOM    892  C   MET    56      -7.379  -8.578   0.524  1.00 21.21           C 
ATOM    893  O   MET    56      -6.450  -9.382   0.592  1.00 62.50           O 
ATOM    894  CB  MET    56      -8.321  -8.727   2.875  1.00  5.31           C 
ATOM    895  CG  MET    56      -7.436  -9.873   3.359  1.00 21.35           C 
ATOM    896  SD  MET    56      -7.092  -9.790   5.133  1.00 63.43           S 
ATOM    897  CE  MET    56      -8.743  -9.946   5.817  1.00 72.51           C 
ATOM    898  H   MET    56      -9.257 -10.786   1.648  1.00 38.03           H 
ATOM    899  HA  MET    56      -9.342  -7.968   1.143  1.00 13.40           H 
ATOM    900 1HB  MET    56      -9.247  -8.759   3.431  1.00 42.31           H 
ATOM    901 2HB  MET    56      -7.816  -7.797   3.097  1.00 33.11           H 
ATOM    902 1HG  MET    56      -6.499  -9.838   2.824  1.00 20.23           H 
ATOM    903 2HG  MET    56      -7.934 -10.810   3.146  1.00 33.22           H 
ATOM    904 1HE  MET    56      -9.365  -9.140   5.452  1.00 54.42           H 
ATOM    905 2HE  MET    56      -8.693  -9.898   6.896  1.00 70.41           H 
ATOM    906 3HE  MET    56      -9.169 -10.892   5.518  1.00 21.44           H 
ATOM    907  N   ILE    57      -7.343  -7.519  -0.275  1.00 44.11           N 
ATOM    908  CA  ILE    57      -6.249  -7.320  -1.230  1.00  1.30           C 
ATOM    909  C   ILE    57      -5.142  -6.424  -0.656  1.00 62.51           C 
ATOM    910  O   ILE    57      -5.417  -5.421   0.010  1.00 61.12           O 
ATOM    911  CB  ILE    57      -6.767  -6.715  -2.562  1.00 34.42           C 
ATOM    912  CG1 ILE    57      -7.395  -5.326  -2.336  1.00 41.25           C 
ATOM    913  CG2 ILE    57      -7.776  -7.662  -3.216  1.00 71.41           C 
ATOM    914  CD1 ILE    57      -7.899  -4.667  -3.606  1.00 60.11           C 
ATOM    915  H   ILE    57      -8.059  -6.850  -0.219  1.00 38.03           H 
ATOM    916  HA  ILE    57      -5.822  -8.291  -1.451  1.00  1.23           H 
ATOM    917  HB  ILE    57      -5.925  -6.616  -3.233  1.00 62.55           H 
ATOM    918 1HG1 ILE    57      -6.653  -4.671  -1.898  1.00 53.21           H 
ATOM    919 2HG1 ILE    57      -8.230  -5.416  -1.658  1.00 43.10           H 
ATOM    920 1HG2 ILE    57      -8.603  -7.834  -2.541  1.00  4.15           H 
ATOM    921 2HG2 ILE    57      -7.296  -8.603  -3.441  1.00 61.11           H 
ATOM    922 3HG2 ILE    57      -8.146  -7.222  -4.132  1.00 22.41           H 
ATOM    923 1HD1 ILE    57      -8.330  -3.707  -3.366  1.00 64.34           H 
ATOM    924 2HD1 ILE    57      -8.651  -5.294  -4.065  1.00 32.33           H 
ATOM    925 3HD1 ILE    57      -7.076  -4.531  -4.292  1.00  1.20           H 
ATOM    926  N   GLN    58      -3.888  -6.804  -0.904  1.00 75.55           N 
ATOM    927  CA  GLN    58      -2.741  -6.021  -0.436  1.00 32.25           C 
ATOM    928  C   GLN    58      -2.276  -5.031  -1.512  1.00 23.44           C 
ATOM    929  O   GLN    58      -1.633  -5.417  -2.485  1.00 52.52           O 
ATOM    930  CB  GLN    58      -1.591  -6.967  -0.058  1.00 34.13           C 
ATOM    931  CG  GLN    58      -1.957  -7.971   1.032  1.00 64.23           C 
ATOM    932  CD  GLN    58      -2.190  -7.316   2.386  1.00 74.11           C 
ATOM    933  OE1 GLN    58      -1.273  -7.190   3.189  1.00 51.23           O 
ATOM    934  NE2 GLN    58      -3.409  -6.889   2.648  1.00 43.25           N 
ATOM    935  H   GLN    58      -3.727  -7.636  -1.410  1.00 38.03           H 
ATOM    936  HA  GLN    58      -3.044  -5.469   0.443  1.00  0.12           H 
ATOM    937 1HB  GLN    58      -0.754  -6.377   0.291  1.00 54.15           H 
ATOM    938 2HB  GLN    58      -1.288  -7.516  -0.939  1.00 73.12           H 
ATOM    939 1HG  GLN    58      -1.152  -8.688   1.130  1.00 24.40           H 
ATOM    940 2HG  GLN    58      -2.859  -8.489   0.739  1.00 52.32           H 
ATOM    941 1HE2 GLN    58      -4.102  -7.014   1.972  1.00  1.33           H 
ATOM    942 2HE2 GLN    58      -3.564  -6.449   3.513  1.00 22.43           H 
ATOM    943  N   VAL    59      -2.591  -3.753  -1.326  1.00  4.45           N 
ATOM    944  CA  VAL    59      -2.241  -2.718  -2.309  1.00 30.25           C 
ATOM    945  C   VAL    59      -0.965  -1.968  -1.905  1.00 20.54           C 
ATOM    946  O   VAL    59      -0.931  -1.287  -0.884  1.00 23.02           O 
ATOM    947  CB  VAL    59      -3.397  -1.702  -2.495  1.00 73.23           C 
ATOM    948  CG1 VAL    59      -3.020  -0.613  -3.503  1.00 53.41           C 
ATOM    949  CG2 VAL    59      -4.672  -2.424  -2.926  1.00 53.45           C 
ATOM    950  H   VAL    59      -3.072  -3.496  -0.509  1.00 38.03           H 
ATOM    951  HA  VAL    59      -2.069  -3.207  -3.259  1.00 21.45           H 
ATOM    952  HB  VAL    59      -3.585  -1.225  -1.541  1.00 43.44           H 
ATOM    953 1HG1 VAL    59      -2.152  -0.076  -3.149  1.00 23.35           H 
ATOM    954 2HG1 VAL    59      -3.844   0.075  -3.617  1.00  3.51           H 
ATOM    955 3HG1 VAL    59      -2.797  -1.067  -4.459  1.00 34.40           H 
ATOM    956 1HG2 VAL    59      -4.507  -2.916  -3.874  1.00 22.54           H 
ATOM    957 2HG2 VAL    59      -5.477  -1.709  -3.027  1.00 14.30           H 
ATOM    958 3HG2 VAL    59      -4.939  -3.160  -2.180  1.00 54.44           H 
ATOM    959  N   SER    60       0.079  -2.093  -2.720  1.00 30.53           N 
ATOM    960  CA  SER    60       1.375  -1.464  -2.423  1.00 10.42           C 
ATOM    961  C   SER    60       1.687  -0.321  -3.397  1.00 43.11           C 
ATOM    962  O   SER    60       1.704  -0.514  -4.613  1.00 35.23           O 
ATOM    963  CB  SER    60       2.503  -2.504  -2.475  1.00 30.45           C 
ATOM    964  OG  SER    60       3.745  -1.930  -2.103  1.00  4.40           O 
ATOM    965  H   SER    60      -0.022  -2.617  -3.545  1.00 38.03           H 
ATOM    966  HA  SER    60       1.325  -1.059  -1.422  1.00 23.51           H 
ATOM    967 1HB  SER    60       2.586  -2.896  -3.479  1.00 14.11           H 
ATOM    968 2HB  SER    60       2.277  -3.310  -1.794  1.00 23.24           H 
ATOM    969  HG  SER    60       4.258  -1.728  -2.897  1.00 23.32           H 
ATOM    970  N   ILE    61       1.935   0.868  -2.852  1.00 70.05           N 
ATOM    971  CA  ILE    61       2.318   2.037  -3.659  1.00 42.11           C 
ATOM    972  C   ILE    61       3.747   2.494  -3.321  1.00 11.12           C 
ATOM    973  O   ILE    61       4.185   2.377  -2.175  1.00 31.32           O 
ATOM    974  CB  ILE    61       1.331   3.218  -3.451  1.00 34.21           C 
ATOM    975  CG1 ILE    61       1.280   3.630  -1.971  1.00 45.51           C 
ATOM    976  CG2 ILE    61      -0.062   2.849  -3.965  1.00 32.31           C 
ATOM    977  CD1 ILE    61       0.366   4.804  -1.691  1.00 14.01           C 
ATOM    978  H   ILE    61       1.861   0.965  -1.878  1.00 38.03           H 
ATOM    979  HA  ILE    61       2.284   1.750  -4.703  1.00 63.33           H 
ATOM    980  HB  ILE    61       1.685   4.057  -4.037  1.00 24.11           H 
ATOM    981 1HG1 ILE    61       2.275   3.900  -1.643  1.00 72.01           H 
ATOM    982 2HG1 ILE    61       0.929   2.795  -1.382  1.00 54.50           H 
ATOM    983 1HG2 ILE    61      -0.003   2.597  -5.015  1.00 33.12           H 
ATOM    984 2HG2 ILE    61      -0.730   3.690  -3.837  1.00 73.22           H 
ATOM    985 3HG2 ILE    61      -0.441   2.000  -3.412  1.00 24.14           H 
ATOM    986 1HD1 ILE    61       0.394   5.039  -0.638  1.00 44.21           H 
ATOM    987 2HD1 ILE    61      -0.645   4.552  -1.975  1.00 54.24           H 
ATOM    988 3HD1 ILE    61       0.695   5.661  -2.258  1.00 21.04           H 
ATOM    989  N   PRO    62       4.500   3.027  -4.305  1.00 60.24           N 
ATOM    990  CA  PRO    62       5.904   3.440  -4.091  1.00 61.14           C 
ATOM    991  C   PRO    62       6.064   4.597  -3.077  1.00 70.05           C 
ATOM    992  O   PRO    62       5.137   5.376  -2.849  1.00  4.04           O 
ATOM    993  CB  PRO    62       6.364   3.878  -5.490  1.00 34.11           C 
ATOM    994  CG  PRO    62       5.106   4.211  -6.224  1.00 50.44           C 
ATOM    995  CD  PRO    62       4.057   3.273  -5.693  1.00 52.14           C 
ATOM    996  HA  PRO    62       6.507   2.602  -3.763  1.00 73.21           H 
ATOM    997 1HB  PRO    62       6.897   3.067  -5.969  1.00 72.22           H 
ATOM    998 2HB  PRO    62       7.015   4.738  -5.408  1.00 24.01           H 
ATOM    999 1HG  PRO    62       5.245   4.060  -7.286  1.00 41.45           H 
ATOM   1000 2HG  PRO    62       4.826   5.237  -6.026  1.00  2.11           H 
ATOM   1001 1HD  PRO    62       4.046   2.353  -6.262  1.00 41.22           H 
ATOM   1002 2HD  PRO    62       3.082   3.743  -5.713  1.00 24.45           H 
ATOM   1003  N   ALA    63       7.263   4.709  -2.494  1.00 32.02           N 
ATOM   1004  CA  ALA    63       7.557   5.715  -1.456  1.00 31.42           C 
ATOM   1005  C   ALA    63       7.290   7.152  -1.925  1.00 34.23           C 
ATOM   1006  O   ALA    63       6.892   8.005  -1.130  1.00 61.24           O 
ATOM   1007  CB  ALA    63       9.002   5.582  -0.990  1.00 12.05           C 
ATOM   1008  H   ALA    63       7.977   4.092  -2.764  1.00 38.03           H 
ATOM   1009  HA  ALA    63       6.918   5.507  -0.610  1.00 62.32           H 
ATOM   1010 1HB  ALA    63       9.670   5.853  -1.795  1.00 73.22           H 
ATOM   1011 2HB  ALA    63       9.191   4.560  -0.696  1.00 62.43           H 
ATOM   1012 3HB  ALA    63       9.174   6.236  -0.146  1.00 60.03           H 
ATOM   1013  N   SER    64       7.511   7.418  -3.214  1.00 23.11           N 
ATOM   1014  CA  SER    64       7.278   8.758  -3.785  1.00 33.24           C 
ATOM   1015  C   SER    64       5.822   9.213  -3.593  1.00 22.01           C 
ATOM   1016  O   SER    64       5.518  10.404  -3.678  1.00 45.23           O 
ATOM   1017  CB  SER    64       7.629   8.780  -5.280  1.00 40.12           C 
ATOM   1018  OG  SER    64       8.998   8.460  -5.499  1.00  5.30           O 
ATOM   1019  H   SER    64       7.850   6.702  -3.793  1.00 38.03           H 
ATOM   1020  HA  SER    64       7.925   9.452  -3.266  1.00 13.23           H 
ATOM   1021 1HB  SER    64       7.436   9.766  -5.680  1.00 24.42           H 
ATOM   1022 2HB  SER    64       7.019   8.056  -5.802  1.00 43.44           H 
ATOM   1023  HG  SER    64       9.067   7.551  -5.814  1.00 63.04           H 
ATOM   1024  N   VAL    65       4.930   8.260  -3.342  1.00 51.35           N 
ATOM   1025  CA  VAL    65       3.521   8.561  -3.082  1.00 50.10           C 
ATOM   1026  C   VAL    65       3.270   8.748  -1.573  1.00 32.23           C 
ATOM   1027  O   VAL    65       3.622   7.883  -0.765  1.00 31.33           O 
ATOM   1028  CB  VAL    65       2.603   7.434  -3.622  1.00 73.21           C 
ATOM   1029  CG1 VAL    65       1.129   7.794  -3.438  1.00 34.34           C 
ATOM   1030  CG2 VAL    65       2.915   7.147  -5.089  1.00 65.22           C 
ATOM   1031  H   VAL    65       5.225   7.325  -3.324  1.00 38.03           H 
ATOM   1032  HA  VAL    65       3.274   9.477  -3.601  1.00 22.10           H 
ATOM   1033  HB  VAL    65       2.800   6.533  -3.055  1.00 22.53           H 
ATOM   1034 1HG1 VAL    65       0.511   6.986  -3.807  1.00 25.14           H 
ATOM   1035 2HG1 VAL    65       0.906   8.696  -3.990  1.00 60.15           H 
ATOM   1036 3HG1 VAL    65       0.921   7.953  -2.390  1.00 73.22           H 
ATOM   1037 1HG2 VAL    65       2.298   6.330  -5.436  1.00 14.42           H 
ATOM   1038 2HG2 VAL    65       3.958   6.877  -5.190  1.00 41.42           H 
ATOM   1039 3HG2 VAL    65       2.712   8.027  -5.680  1.00 51.52           H 
ATOM   1040  N   PRO    66       2.673   9.888  -1.165  1.00 71.42           N 
ATOM   1041  CA  PRO    66       2.403  10.174   0.257  1.00  2.20           C 
ATOM   1042  C   PRO    66       1.300   9.276   0.858  1.00 35.40           C 
ATOM   1043  O   PRO    66       0.512   8.663   0.135  1.00 53.31           O 
ATOM   1044  CB  PRO    66       1.957  11.644   0.239  1.00 13.22           C 
ATOM   1045  CG  PRO    66       1.394  11.848  -1.128  1.00  4.54           C 
ATOM   1046  CD  PRO    66       2.218  10.985  -2.046  1.00 33.50           C 
ATOM   1047  HA  PRO    66       3.302  10.077   0.850  1.00 54.05           H 
ATOM   1048 1HB  PRO    66       2.811  12.287   0.413  1.00 55.23           H 
ATOM   1049 2HB  PRO    66       1.214  11.813   1.006  1.00 72.23           H 
ATOM   1050 1HG  PRO    66       1.477  12.887  -1.412  1.00 31.01           H 
ATOM   1051 2HG  PRO    66       0.358  11.537  -1.147  1.00  1.31           H 
ATOM   1052 1HD  PRO    66       3.058  11.540  -2.436  1.00 25.05           H 
ATOM   1053 2HD  PRO    66       1.610  10.605  -2.857  1.00 23.01           H 
ATOM   1054  N   LEU    67       1.255   9.210   2.186  1.00  3.11           N 
ATOM   1055  CA  LEU    67       0.232   8.438   2.902  1.00  2.22           C 
ATOM   1056  C   LEU    67      -1.144   9.128   2.822  1.00 75.53           C 
ATOM   1057  O   LEU    67      -1.235  10.357   2.860  1.00 63.14           O 
ATOM   1058  CB  LEU    67       0.650   8.278   4.373  1.00 51.50           C 
ATOM   1059  CG  LEU    67      -0.292   7.434   5.252  1.00 44.43           C 
ATOM   1060  CD1 LEU    67      -0.317   5.983   4.792  1.00 64.51           C 
ATOM   1061  CD2 LEU    67       0.112   7.520   6.719  1.00 10.50           C 
ATOM   1062  H   LEU    67       1.934   9.689   2.706  1.00 38.03           H 
ATOM   1063  HA  LEU    67       0.165   7.460   2.445  1.00 42.43           H 
ATOM   1064 1HB  LEU    67       0.724   9.264   4.808  1.00  4.33           H 
ATOM   1065 2HB  LEU    67       1.633   7.825   4.393  1.00 54.22           H 
ATOM   1066  HG  LEU    67      -1.298   7.822   5.163  1.00 25.04           H 
ATOM   1067 1HD1 LEU    67      -0.692   5.932   3.781  1.00 10.35           H 
ATOM   1068 2HD1 LEU    67      -0.961   5.411   5.444  1.00 11.35           H 
ATOM   1069 3HD1 LEU    67       0.685   5.573   4.826  1.00 33.14           H 
ATOM   1070 1HD2 LEU    67       0.091   8.552   7.038  1.00 21.15           H 
ATOM   1071 2HD2 LEU    67       1.110   7.123   6.846  1.00 35.14           H 
ATOM   1072 3HD2 LEU    67      -0.583   6.947   7.316  1.00 52.14           H 
ATOM   1073  N   LYS    68      -2.210   8.337   2.693  1.00 31.51           N 
ATOM   1074  CA  LYS    68      -3.575   8.882   2.671  1.00 60.21           C 
ATOM   1075  C   LYS    68      -4.355   8.495   3.935  1.00 13.05           C 
ATOM   1076  O   LYS    68      -4.773   7.349   4.102  1.00 40.51           O 
ATOM   1077  CB  LYS    68      -4.351   8.423   1.427  1.00 33.02           C 
ATOM   1078  CG  LYS    68      -3.828   8.986   0.103  1.00 64.12           C 
ATOM   1079  CD  LYS    68      -2.595   8.241  -0.399  1.00 43.32           C 
ATOM   1080  CE  LYS    68      -1.973   8.926  -1.613  1.00 74.33           C 
ATOM   1081  NZ  LYS    68      -2.942   9.105  -2.726  1.00 20.52           N 
ATOM   1082  H   LYS    68      -2.080   7.370   2.618  1.00 38.03           H 
ATOM   1083  HA  LYS    68      -3.495   9.962   2.643  1.00 14.13           H 
ATOM   1084 1HB  LYS    68      -5.384   8.727   1.539  1.00 74.01           H 
ATOM   1085 2HB  LYS    68      -4.311   7.343   1.376  1.00 31.14           H 
ATOM   1086 1HG  LYS    68      -3.574  10.029   0.245  1.00 32.42           H 
ATOM   1087 2HG  LYS    68      -4.607   8.907  -0.642  1.00 10.02           H 
ATOM   1088 1HD  LYS    68      -2.881   7.235  -0.672  1.00 23.05           H 
ATOM   1089 2HD  LYS    68      -1.862   8.204   0.394  1.00 10.42           H 
ATOM   1090 1HE  LYS    68      -1.145   8.328  -1.963  1.00 45.51           H 
ATOM   1091 2HE  LYS    68      -1.613   9.895  -1.313  1.00 34.11           H 
ATOM   1092 1HZ  LYS    68      -2.446   9.421  -3.586  1.00 32.10           H 
ATOM   1093 2HZ  LYS    68      -3.652   9.821  -2.476  1.00 63.14           H 
ATOM   1094 3HZ  LYS    68      -3.430   8.212  -2.932  1.00 13.33           H 
ATOM   1095  N   GLU    69      -4.551   9.471   4.812  1.00 64.53           N 
ATOM   1096  CA  GLU    69      -5.273   9.267   6.070  1.00 44.03           C 
ATOM   1097  C   GLU    69      -6.793   9.153   5.839  1.00 14.02           C 
ATOM   1098  O   GLU    69      -7.542  10.098   6.107  1.00 52.20           O 
ATOM   1099  CB  GLU    69      -4.977  10.443   7.011  1.00 43.31           C 
ATOM   1100  CG  GLU    69      -3.504  10.599   7.389  1.00 64.21           C 
ATOM   1101  CD  GLU    69      -3.088   9.730   8.570  1.00  2.14           C 
ATOM   1102  OE1 GLU    69      -3.059  10.248   9.710  1.00 74.04           O 
ATOM   1103  OE2 GLU    69      -2.785   8.537   8.370  1.00 74.11           O 
ATOM   1104  H   GLU    69      -4.198  10.362   4.611  1.00 38.03           H 
ATOM   1105  HA  GLU    69      -4.915   8.353   6.524  1.00 10.04           H 
ATOM   1106 1HB  GLU    69      -5.552  10.315   7.918  1.00 33.54           H 
ATOM   1107 2HB  GLU    69      -5.297  11.353   6.523  1.00 34.53           H 
ATOM   1108 1HG  GLU    69      -3.322  11.634   7.642  1.00 41.43           H 
ATOM   1109 2HG  GLU    69      -2.895  10.333   6.536  1.00 72.31           H 
ATOM   1110  N   PHE    70      -7.242   8.012   5.320  1.00 65.54           N 
ATOM   1111  CA  PHE    70      -8.675   7.790   5.057  1.00 10.24           C 
ATOM   1112  C   PHE    70      -9.368   7.065   6.220  1.00 31.44           C 
ATOM   1113  O   PHE    70      -8.730   6.336   6.984  1.00 13.33           O 
ATOM   1114  CB  PHE    70      -8.874   6.984   3.764  1.00 52.51           C 
ATOM   1115  CG  PHE    70      -8.493   7.725   2.503  1.00 32.13           C 
ATOM   1116  CD1 PHE    70      -8.788   9.073   2.360  1.00 51.32           C 
ATOM   1117  CD2 PHE    70      -7.857   7.070   1.456  1.00 24.41           C 
ATOM   1118  CE1 PHE    70      -8.456   9.751   1.204  1.00 22.15           C 
ATOM   1119  CE2 PHE    70      -7.522   7.747   0.298  1.00 54.44           C 
ATOM   1120  CZ  PHE    70      -7.820   9.089   0.173  1.00 63.43           C 
ATOM   1121  H   PHE    70      -6.599   7.303   5.106  1.00 38.03           H 
ATOM   1122  HA  PHE    70      -9.140   8.760   4.935  1.00 61.21           H 
ATOM   1123 1HB  PHE    70      -9.915   6.703   3.681  1.00 24.12           H 
ATOM   1124 2HB  PHE    70      -8.274   6.088   3.814  1.00  0.02           H 
ATOM   1125  HD1 PHE    70      -9.283   9.597   3.165  1.00 11.42           H 
ATOM   1126  HD2 PHE    70      -7.624   6.018   1.551  1.00 14.53           H 
ATOM   1127  HE1 PHE    70      -8.696  10.800   1.106  1.00 71.10           H 
ATOM   1128  HE2 PHE    70      -7.024   7.226  -0.508  1.00  1.14           H 
ATOM   1129  HZ  PHE    70      -7.562   9.619  -0.732  1.00 25.51           H 
ATOM   1130  N   ASP    71     -10.680   7.271   6.348  1.00 63.45           N 
ATOM   1131  CA  ASP    71     -11.475   6.607   7.389  1.00 22.44           C 
ATOM   1132  C   ASP    71     -11.839   5.165   6.993  1.00 43.34           C 
ATOM   1133  O   ASP    71     -11.631   4.748   5.851  1.00  5.53           O 
ATOM   1134  CB  ASP    71     -12.743   7.423   7.683  1.00 60.43           C 
ATOM   1135  CG  ASP    71     -13.539   7.750   6.428  1.00  5.44           C 
ATOM   1136  OD1 ASP    71     -13.103   8.641   5.662  1.00 24.11           O 
ATOM   1137  OD2 ASP    71     -14.605   7.139   6.212  1.00 44.40           O 
ATOM   1138  H   ASP    71     -11.130   7.882   5.728  1.00 38.03           H 
ATOM   1139  HA  ASP    71     -10.872   6.571   8.287  1.00 23.25           H 
ATOM   1140 1HB  ASP    71     -12.462   8.352   8.160  1.00 31.40           H 
ATOM   1141 2HB  ASP    71     -13.377   6.862   8.356  1.00 50.14           H 
ATOM   1142  N   TYR    72     -12.387   4.409   7.939  1.00 54.40           N 
ATOM   1143  CA  TYR    72     -12.694   2.995   7.708  1.00 21.44           C 
ATOM   1144  C   TYR    72     -13.829   2.819   6.679  1.00 41.34           C 
ATOM   1145  O   TYR    72     -14.887   3.438   6.789  1.00 11.10           O 
ATOM   1146  CB  TYR    72     -13.053   2.301   9.032  1.00  1.03           C 
ATOM   1147  CG  TYR    72     -13.052   0.784   8.942  1.00  3.21           C 
ATOM   1148  CD1 TYR    72     -14.237   0.069   8.842  1.00 22.44           C 
ATOM   1149  CD2 TYR    72     -11.857   0.071   8.942  1.00 34.13           C 
ATOM   1150  CE1 TYR    72     -14.233  -1.309   8.741  1.00 14.34           C 
ATOM   1151  CE2 TYR    72     -11.847  -1.307   8.847  1.00 13.42           C 
ATOM   1152  CZ  TYR    72     -13.037  -1.991   8.745  1.00 60.12           C 
ATOM   1153  OH  TYR    72     -13.032  -3.364   8.625  1.00 62.34           O 
ATOM   1154  H   TYR    72     -12.592   4.810   8.812  1.00 38.03           H 
ATOM   1155  HA  TYR    72     -11.800   2.532   7.311  1.00 60.11           H 
ATOM   1156 1HB  TYR    72     -14.039   2.619   9.345  1.00 54.01           H 
ATOM   1157 2HB  TYR    72     -12.334   2.586   9.787  1.00 34.31           H 
ATOM   1158  HD1 TYR    72     -15.176   0.605   8.839  1.00  5.23           H 
ATOM   1159  HD2 TYR    72     -10.923   0.609   9.024  1.00 52.15           H 
ATOM   1160  HE1 TYR    72     -15.168  -1.846   8.664  1.00  3.33           H 
ATOM   1161  HE2 TYR    72     -10.907  -1.842   8.850  1.00 62.23           H 
ATOM   1162  HH  TYR    72     -12.488  -3.751   9.328  1.00 23.03           H 
ATOM   1163  N   ASN    73     -13.582   1.962   5.685  1.00 13.32           N 
ATOM   1164  CA  ASN    73     -14.537   1.676   4.597  1.00  4.03           C 
ATOM   1165  C   ASN    73     -14.728   2.865   3.634  1.00 14.10           C 
ATOM   1166  O   ASN    73     -15.697   2.903   2.874  1.00  3.25           O 
ATOM   1167  CB  ASN    73     -15.894   1.214   5.147  1.00 41.54           C 
ATOM   1168  CG  ASN    73     -15.807  -0.117   5.875  1.00 64.11           C 
ATOM   1169  OD1 ASN    73     -14.941  -0.947   5.599  1.00  1.31           O 
ATOM   1170  ND2 ASN    73     -16.713  -0.339   6.806  1.00 23.20           N 
ATOM   1171  H   ASN    73     -12.724   1.494   5.682  1.00 38.03           H 
ATOM   1172  HA  ASN    73     -14.112   0.863   4.025  1.00 54.20           H 
ATOM   1173 1HB  ASN    73     -16.593   1.108   4.330  1.00 33.52           H 
ATOM   1174 2HB  ASN    73     -16.266   1.956   5.838  1.00 42.32           H 
ATOM   1175 1HD2 ASN    73     -17.383   0.356   6.974  1.00  1.51           H 
ATOM   1176 2HD2 ASN    73     -16.683  -1.191   7.284  1.00 64.11           H 
ATOM   1177  N   ALA    74     -13.795   3.815   3.642  1.00  3.42           N 
ATOM   1178  CA  ALA    74     -13.822   4.925   2.681  1.00 54.43           C 
ATOM   1179  C   ALA    74     -13.658   4.409   1.238  1.00 73.01           C 
ATOM   1180  O   ALA    74     -12.775   3.594   0.963  1.00 73.12           O 
ATOM   1181  CB  ALA    74     -12.731   5.939   3.015  1.00 22.14           C 
ATOM   1182  H   ALA    74     -13.082   3.780   4.313  1.00 38.03           H 
ATOM   1183  HA  ALA    74     -14.780   5.420   2.772  1.00 45.41           H 
ATOM   1184 1HB  ALA    74     -12.802   6.783   2.342  1.00 41.33           H 
ATOM   1185 2HB  ALA    74     -11.761   5.474   2.907  1.00 32.44           H 
ATOM   1186 3HB  ALA    74     -12.854   6.280   4.032  1.00 34.34           H 
ATOM   1187  N   ARG    75     -14.512   4.882   0.326  1.00 13.04           N 
ATOM   1188  CA  ARG    75     -14.486   4.421  -1.072  1.00 13.00           C 
ATOM   1189  C   ARG    75     -13.323   5.045  -1.861  1.00 24.42           C 
ATOM   1190  O   ARG    75     -13.255   6.266  -2.036  1.00 42.21           O 
ATOM   1191  CB  ARG    75     -15.804   4.750  -1.784  1.00 65.32           C 
ATOM   1192  CG  ARG    75     -17.039   4.090  -1.176  1.00 21.11           C 
ATOM   1193  CD  ARG    75     -18.289   4.422  -1.989  1.00 12.53           C 
ATOM   1194  NE  ARG    75     -18.418   5.863  -2.198  1.00 40.25           N 
ATOM   1195  CZ  ARG    75     -18.634   6.429  -3.356  1.00 23.40           C 
ATOM   1196  NH1 ARG    75     -18.852   5.721  -4.415  1.00 63.33           N 
ATOM   1197  NH2 ARG    75     -18.643   7.715  -3.447  1.00 23.23           N 
ATOM   1198  H   ARG    75     -15.168   5.556   0.596  1.00 38.03           H 
ATOM   1199  HA  ARG    75     -14.359   3.346  -1.061  1.00 40.51           H 
ATOM   1200 1HB  ARG    75     -15.727   4.433  -2.815  1.00 41.21           H 
ATOM   1201 2HB  ARG    75     -15.952   5.821  -1.761  1.00 74.01           H 
ATOM   1202 1HG  ARG    75     -17.169   4.448  -0.165  1.00 64.41           H 
ATOM   1203 2HG  ARG    75     -16.900   3.017  -1.167  1.00 34.31           H 
ATOM   1204 1HD  ARG    75     -19.158   4.064  -1.454  1.00 24.01           H 
ATOM   1205 2HD  ARG    75     -18.226   3.924  -2.947  1.00 62.41           H 
ATOM   1206  HE  ARG    75     -18.306   6.440  -1.419  1.00 35.10           H 
ATOM   1207 1HH1 ARG    75     -18.861   4.723  -4.359  1.00 31.31           H 
ATOM   1208 2HH1 ARG    75     -19.016   6.173  -5.288  1.00 14.15           H 
ATOM   1209 1HH2 ARG    75     -18.486   8.277  -2.638  1.00 12.33           H 
ATOM   1210 2HH2 ARG    75     -18.793   8.147  -4.335  1.00 44.00           H 
ATOM   1211  N   VAL    76     -12.430   4.194  -2.352  1.00 23.23           N 
ATOM   1212  CA  VAL    76     -11.267   4.629  -3.132  1.00 71.52           C 
ATOM   1213  C   VAL    76     -11.213   3.929  -4.502  1.00 34.20           C 
ATOM   1214  O   VAL    76     -11.861   2.904  -4.715  1.00  0.23           O 
ATOM   1215  CB  VAL    76      -9.945   4.344  -2.365  1.00 62.45           C 
ATOM   1216  CG1 VAL    76      -9.910   5.100  -1.036  1.00 24.15           C 
ATOM   1217  CG2 VAL    76      -9.759   2.844  -2.137  1.00 25.22           C 
ATOM   1218  H   VAL    76     -12.555   3.234  -2.188  1.00 38.03           H 
ATOM   1219  HA  VAL    76     -11.343   5.698  -3.291  1.00 41.24           H 
ATOM   1220  HB  VAL    76      -9.120   4.698  -2.970  1.00 15.10           H 
ATOM   1221 1HG1 VAL    76      -9.933   6.164  -1.225  1.00 20.51           H 
ATOM   1222 2HG1 VAL    76      -9.004   4.851  -0.502  1.00 64.32           H 
ATOM   1223 3HG1 VAL    76     -10.767   4.821  -0.440  1.00 45.43           H 
ATOM   1224 1HG2 VAL    76      -9.726   2.334  -3.089  1.00 32.52           H 
ATOM   1225 2HG2 VAL    76     -10.583   2.460  -1.552  1.00 51.41           H 
ATOM   1226 3HG2 VAL    76      -8.832   2.671  -1.607  1.00 53.41           H 
ATOM   1227  N   GLU    77     -10.453   4.501  -5.432  1.00 32.14           N 
ATOM   1228  CA  GLU    77     -10.163   3.849  -6.713  1.00 22.31           C 
ATOM   1229  C   GLU    77      -8.687   4.055  -7.095  1.00 72.21           C 
ATOM   1230  O   GLU    77      -8.079   5.078  -6.765  1.00 44.33           O 
ATOM   1231  CB  GLU    77     -11.103   4.349  -7.827  1.00 13.43           C 
ATOM   1232  CG  GLU    77     -11.015   5.843  -8.125  1.00 43.32           C 
ATOM   1233  CD  GLU    77     -11.925   6.257  -9.279  1.00 25.33           C 
ATOM   1234  OE1 GLU    77     -11.507   6.124 -10.449  1.00 24.54           O 
ATOM   1235  OE2 GLU    77     -13.062   6.712  -9.023  1.00 41.11           O 
ATOM   1236  H   GLU    77     -10.080   5.390  -5.259  1.00 38.03           H 
ATOM   1237  HA  GLU    77     -10.326   2.787  -6.576  1.00  5.11           H 
ATOM   1238 1HB  GLU    77     -12.122   4.122  -7.542  1.00  2.14           H 
ATOM   1239 2HB  GLU    77     -10.873   3.812  -8.737  1.00 14.51           H 
ATOM   1240 1HG  GLU    77      -9.994   6.087  -8.384  1.00 52.12           H 
ATOM   1241 2HG  GLU    77     -11.301   6.394  -7.240  1.00 50.11           H 
ATOM   1242  N   LEU    78      -8.109   3.065  -7.772  1.00 40.24           N 
ATOM   1243  CA  LEU    78      -6.675   3.073  -8.084  1.00 22.12           C 
ATOM   1244  C   LEU    78      -6.398   3.578  -9.507  1.00 42.24           C 
ATOM   1245  O   LEU    78      -7.094   3.215 -10.453  1.00 12.11           O 
ATOM   1246  CB  LEU    78      -6.097   1.662  -7.906  1.00 52.00           C 
ATOM   1247  CG  LEU    78      -6.233   1.076  -6.491  1.00 43.42           C 
ATOM   1248  CD1 LEU    78      -5.671  -0.344  -6.429  1.00 60.04           C 
ATOM   1249  CD2 LEU    78      -5.536   1.975  -5.472  1.00  3.22           C 
ATOM   1250  H   LEU    78      -8.659   2.316  -8.078  1.00 38.03           H 
ATOM   1251  HA  LEU    78      -6.188   3.737  -7.380  1.00  1.01           H 
ATOM   1252 1HB  LEU    78      -5.046   1.687  -8.161  1.00 42.52           H 
ATOM   1253 2HB  LEU    78      -6.601   1.001  -8.598  1.00 31.43           H 
ATOM   1254  HG  LEU    78      -7.281   1.027  -6.231  1.00 74.22           H 
ATOM   1255 1HD1 LEU    78      -4.619  -0.329  -6.676  1.00 55.42           H 
ATOM   1256 2HD1 LEU    78      -6.198  -0.970  -7.135  1.00 30.02           H 
ATOM   1257 3HD1 LEU    78      -5.801  -0.739  -5.432  1.00  2.23           H 
ATOM   1258 1HD2 LEU    78      -5.991   2.954  -5.487  1.00 32.14           H 
ATOM   1259 2HD2 LEU    78      -4.488   2.062  -5.724  1.00 33.34           H 
ATOM   1260 3HD2 LEU    78      -5.635   1.547  -4.486  1.00 72.01           H 
ATOM   1261  N   ILE    79      -5.368   4.417  -9.643  1.00 25.14           N 
ATOM   1262  CA  ILE    79      -4.958   4.942 -10.951  1.00 43.41           C 
ATOM   1263  C   ILE    79      -4.476   3.812 -11.886  1.00 73.05           C 
ATOM   1264  O   ILE    79      -5.153   3.457 -12.851  1.00 44.23           O 
ATOM   1265  CB  ILE    79      -3.839   6.008 -10.796  1.00 40.13           C 
ATOM   1266  CG1 ILE    79      -4.319   7.170  -9.905  1.00 12.55           C 
ATOM   1267  CG2 ILE    79      -3.382   6.525 -12.164  1.00 51.40           C 
ATOM   1268  CD1 ILE    79      -5.550   7.886 -10.433  1.00 75.21           C 
ATOM   1269  H   ILE    79      -4.882   4.704  -8.839  1.00 38.03           H 
ATOM   1270  HA  ILE    79      -5.819   5.420 -11.399  1.00 31.23           H 
ATOM   1271  HB  ILE    79      -2.991   5.531 -10.320  1.00 74.45           H 
ATOM   1272 1HG1 ILE    79      -3.526   7.899  -9.815  1.00 62.13           H 
ATOM   1273 2HG1 ILE    79      -4.560   6.787  -8.925  1.00 31.02           H 
ATOM   1274 1HG2 ILE    79      -2.995   5.703 -12.748  1.00 24.34           H 
ATOM   1275 2HG2 ILE    79      -2.605   7.264 -12.030  1.00 62.44           H 
ATOM   1276 3HG2 ILE    79      -4.218   6.971 -12.684  1.00 73.32           H 
ATOM   1277 1HD1 ILE    79      -5.834   8.667  -9.742  1.00 22.12           H 
ATOM   1278 2HD1 ILE    79      -6.362   7.181 -10.532  1.00 60.43           H 
ATOM   1279 3HD1 ILE    79      -5.329   8.321 -11.396  1.00 42.11           H 
ATOM   1280  N   ASN    80      -3.303   3.246 -11.589  1.00 21.31           N 
ATOM   1281  CA  ASN    80      -2.762   2.115 -12.362  1.00 64.23           C 
ATOM   1282  C   ASN    80      -2.489   0.894 -11.459  1.00  3.43           C 
ATOM   1283  O   ASN    80      -1.371   0.707 -10.976  1.00  4.41           O 
ATOM   1284  CB  ASN    80      -1.473   2.533 -13.090  1.00 22.30           C 
ATOM   1285  CG  ASN    80      -1.718   3.570 -14.171  1.00 21.15           C 
ATOM   1286  OD1 ASN    80      -2.761   3.576 -14.819  1.00 11.25           O 
ATOM   1287  ND2 ASN    80      -0.764   4.458 -14.373  1.00 35.24           N 
ATOM   1288  H   ASN    80      -2.786   3.599 -10.840  1.00 38.03           H 
ATOM   1289  HA  ASN    80      -3.502   1.834 -13.101  1.00 55.40           H 
ATOM   1290 1HB  ASN    80      -1.030   1.663 -13.553  1.00 70.33           H 
ATOM   1291 2HB  ASN    80      -0.777   2.945 -12.371  1.00 14.50           H 
ATOM   1292 1HD2 ASN    80       0.047   4.406 -13.823  1.00 11.45           H 
ATOM   1293 2HD2 ASN    80      -0.906   5.136 -15.063  1.00 65.41           H 
ATOM   1294  N   PRO    81      -3.527   0.078 -11.171  1.00 53.23           N 
ATOM   1295  CA  PRO    81      -3.382  -1.154 -10.376  1.00 53.25           C 
ATOM   1296  C   PRO    81      -2.892  -2.365 -11.198  1.00  1.13           C 
ATOM   1297  O   PRO    81      -3.416  -2.652 -12.278  1.00 73.44           O 
ATOM   1298  CB  PRO    81      -4.806  -1.391  -9.869  1.00 32.31           C 
ATOM   1299  CG  PRO    81      -5.685  -0.856 -10.954  1.00 61.55           C 
ATOM   1300  CD  PRO    81      -4.929   0.291 -11.593  1.00 34.01           C 
ATOM   1301  HA  PRO    81      -2.722  -1.003  -9.534  1.00  3.11           H 
ATOM   1302 1HB  PRO    81      -4.956  -0.857  -8.940  1.00 71.34           H 
ATOM   1303 2HB  PRO    81      -4.970  -2.450  -9.707  1.00 21.21           H 
ATOM   1304 1HG  PRO    81      -6.617  -0.503 -10.533  1.00 30.11           H 
ATOM   1305 2HG  PRO    81      -5.877  -1.629 -11.686  1.00 60.32           H 
ATOM   1306 1HD  PRO    81      -5.301   1.239 -11.228  1.00 22.54           H 
ATOM   1307 2HD  PRO    81      -5.015   0.247 -12.670  1.00 33.01           H 
ATOM   1308  N   ILE    82      -1.890  -3.078 -10.681  1.00 43.24           N 
ATOM   1309  CA  ILE    82      -1.396  -4.309 -11.319  1.00 41.02           C 
ATOM   1310  C   ILE    82      -1.141  -5.420 -10.281  1.00 32.45           C 
ATOM   1311  O   ILE    82      -0.425  -5.216  -9.301  1.00 34.22           O 
ATOM   1312  CB  ILE    82      -0.092  -4.064 -12.136  1.00 64.33           C 
ATOM   1313  CG1 ILE    82       1.019  -3.474 -11.247  1.00 43.23           C 
ATOM   1314  CG2 ILE    82      -0.370  -3.152 -13.332  1.00 21.32           C 
ATOM   1315  CD1 ILE    82       2.336  -3.259 -11.969  1.00 73.13           C 
ATOM   1316  H   ILE    82      -1.461  -2.768  -9.856  1.00 38.03           H 
ATOM   1317  HA  ILE    82      -2.161  -4.654 -12.007  1.00 32.21           H 
ATOM   1318  HB  ILE    82       0.240  -5.019 -12.523  1.00 22.44           H 
ATOM   1319 1HG1 ILE    82       1.203  -4.142 -10.416  1.00 71.41           H 
ATOM   1320 2HG1 ILE    82       0.698  -2.517 -10.865  1.00 34.35           H 
ATOM   1321 1HG2 ILE    82      -1.116  -3.607 -13.969  1.00 62.44           H 
ATOM   1322 2HG2 ILE    82       0.540  -3.004 -13.894  1.00 40.34           H 
ATOM   1323 3HG2 ILE    82      -0.735  -2.197 -12.980  1.00 32.53           H 
ATOM   1324 1HD1 ILE    82       2.189  -2.570 -12.787  1.00 55.44           H 
ATOM   1325 2HD1 ILE    82       2.694  -4.203 -12.352  1.00 30.45           H 
ATOM   1326 3HD1 ILE    82       3.062  -2.852 -11.281  1.00 74.40           H 
ATOM   1522  N   TRP    98      -3.272 -12.238  -1.997  1.00 52.11           N 
ATOM   1523  CA  TRP    98      -2.596 -11.809  -3.231  1.00 31.31           C 
ATOM   1524  C   TRP    98      -2.266 -10.302  -3.225  1.00 41.53           C 
ATOM   1525  O   TRP    98      -2.963  -9.494  -2.596  1.00 63.02           O 
ATOM   1526  CB  TRP    98      -3.422 -12.203  -4.470  1.00 24.41           C 
ATOM   1527  CG  TRP    98      -4.794 -11.582  -4.565  1.00  1.04           C 
ATOM   1528  CD1 TRP    98      -5.825 -11.680  -3.668  1.00 63.52           C 
ATOM   1529  CD2 TRP    98      -5.293 -10.800  -5.659  1.00 20.14           C 
ATOM   1530  NE1 TRP    98      -6.918 -10.987  -4.131  1.00 12.34           N 
ATOM   1531  CE2 TRP    98      -6.617 -10.441  -5.350  1.00 20.23           C 
ATOM   1532  CE3 TRP    98      -4.740 -10.358  -6.866  1.00 55.14           C 
ATOM   1533  CZ2 TRP    98      -7.397  -9.666  -6.204  1.00 50.04           C 
ATOM   1534  CZ3 TRP    98      -5.518  -9.593  -7.715  1.00 42.13           C 
ATOM   1535  CH2 TRP    98      -6.833  -9.253  -7.378  1.00  4.41           C 
ATOM   1536  H   TRP    98      -4.237 -12.123  -1.915  1.00 38.03           H 
ATOM   1537  HA  TRP    98      -1.656 -12.345  -3.273  1.00 23.20           H 
ATOM   1538 1HB  TRP    98      -3.547 -13.279  -4.472  1.00 44.21           H 
ATOM   1539 2HB  TRP    98      -2.874 -11.920  -5.355  1.00 10.30           H 
ATOM   1540  HD1 TRP    98      -5.773 -12.219  -2.734  1.00 74.05           H 
ATOM   1541  HE1 TRP    98      -7.776 -10.901  -3.668  1.00 53.32           H 
ATOM   1542  HE3 TRP    98      -3.725 -10.612  -7.143  1.00 44.14           H 
ATOM   1543  HZ2 TRP    98      -8.413  -9.395  -5.962  1.00 50.34           H 
ATOM   1544  HZ3 TRP    98      -5.110  -9.244  -8.652  1.00 40.34           H 
ATOM   1545  HH2 TRP    98      -7.404  -8.651  -8.071  1.00 41.45           H 
ATOM   1546  N   TYR    99      -1.190  -9.935  -3.933  1.00  2.54           N 
ATOM   1547  CA  TYR    99      -0.641  -8.572  -3.880  1.00 42.23           C 
ATOM   1548  C   TYR    99      -0.921  -7.778  -5.170  1.00 64.31           C 
ATOM   1549  O   TYR    99      -0.794  -8.292  -6.289  1.00 13.43           O 
ATOM   1550  CB  TYR    99       0.877  -8.622  -3.635  1.00 13.40           C 
ATOM   1551  CG  TYR    99       1.301  -9.557  -2.514  1.00 20.04           C 
ATOM   1552  CD1 TYR    99       1.410 -10.928  -2.732  1.00 14.32           C 
ATOM   1553  CD2 TYR    99       1.602  -9.074  -1.245  1.00  2.34           C 
ATOM   1554  CE1 TYR    99       1.805 -11.784  -1.725  1.00 51.01           C 
ATOM   1555  CE2 TYR    99       1.997  -9.928  -0.230  1.00 31.23           C 
ATOM   1556  CZ  TYR    99       2.096 -11.282  -0.476  1.00 65.03           C 
ATOM   1557  OH  TYR    99       2.502 -12.137   0.524  1.00 51.23           O 
ATOM   1558  H   TYR    99      -0.754 -10.594  -4.512  1.00 38.03           H 
ATOM   1559  HA  TYR    99      -1.107  -8.059  -3.049  1.00 12.12           H 
ATOM   1560 1HB  TYR    99       1.226  -7.627  -3.389  1.00 30.30           H 
ATOM   1561 2HB  TYR    99       1.370  -8.950  -4.540  1.00 63.42           H 
ATOM   1562  HD1 TYR    99       1.179 -11.323  -3.711  1.00 74.51           H 
ATOM   1563  HD2 TYR    99       1.524  -8.015  -1.055  1.00 23.33           H 
ATOM   1564  HE1 TYR    99       1.883 -12.845  -1.917  1.00 44.10           H 
ATOM   1565  HE2 TYR    99       2.224  -9.532   0.750  1.00 54.41           H 
ATOM   1566  HH  TYR    99       3.099 -12.804   0.150  1.00  2.41           H 
ATOM   1567  N   ILE   100      -1.292  -6.512  -4.996  1.00 53.54           N 
ATOM   1568  CA  ILE   100      -1.574  -5.603  -6.109  1.00  0.02           C 
ATOM   1569  C   ILE   100      -0.750  -4.310  -5.978  1.00 22.31           C 
ATOM   1570  O   ILE   100      -0.997  -3.486  -5.094  1.00 40.45           O 
ATOM   1571  CB  ILE   100      -3.082  -5.232  -6.161  1.00 71.22           C 
ATOM   1572  CG1 ILE   100      -3.957  -6.497  -6.166  1.00 71.54           C 
ATOM   1573  CG2 ILE   100      -3.388  -4.363  -7.382  1.00 33.23           C 
ATOM   1574  CD1 ILE   100      -5.445  -6.209  -6.151  1.00 33.02           C 
ATOM   1575  H   ILE   100      -1.375  -6.173  -4.083  1.00 38.03           H 
ATOM   1576  HA  ILE   100      -1.310  -6.101  -7.033  1.00 30.45           H 
ATOM   1577  HB  ILE   100      -3.313  -4.654  -5.278  1.00 12.22           H 
ATOM   1578 1HG1 ILE   100      -3.726  -7.091  -5.293  1.00  2.23           H 
ATOM   1579 2HG1 ILE   100      -3.744  -7.075  -7.053  1.00  3.54           H 
ATOM   1580 1HG2 ILE   100      -2.835  -3.436  -7.313  1.00 21.42           H 
ATOM   1581 2HG2 ILE   100      -4.448  -4.148  -7.416  1.00 60.35           H 
ATOM   1582 3HG2 ILE   100      -3.101  -4.886  -8.282  1.00  4.45           H 
ATOM   1583 1HD1 ILE   100      -5.719  -5.676  -7.050  1.00 42.11           H 
ATOM   1584 2HD1 ILE   100      -5.685  -5.606  -5.288  1.00 21.24           H 
ATOM   1585 3HD1 ILE   100      -5.989  -7.139  -6.101  1.00 24.33           H 
ATOM   1586  N   LYS   101       0.239  -4.139  -6.846  1.00 12.11           N 
ATOM   1587  CA  LYS   101       1.051  -2.918  -6.859  1.00 73.54           C 
ATOM   1588  C   LYS   101       0.338  -1.805  -7.648  1.00 12.02           C 
ATOM   1589  O   LYS   101      -0.107  -2.019  -8.774  1.00 32.32           O 
ATOM   1590  CB  LYS   101       2.437  -3.212  -7.457  1.00 61.50           C 
ATOM   1591  CG  LYS   101       3.256  -4.207  -6.631  1.00 73.44           C 
ATOM   1592  CD  LYS   101       4.543  -4.635  -7.339  1.00 21.22           C 
ATOM   1593  CE  LYS   101       5.499  -3.466  -7.569  1.00 64.11           C 
ATOM   1594  NZ  LYS   101       6.079  -2.944  -6.301  1.00  2.01           N 
ATOM   1595  H   LYS   101       0.427  -4.847  -7.500  1.00 38.03           H 
ATOM   1596  HA  LYS   101       1.176  -2.591  -5.832  1.00 41.33           H 
ATOM   1597 1HB  LYS   101       2.993  -2.288  -7.524  1.00  0.35           H 
ATOM   1598 2HB  LYS   101       2.308  -3.617  -8.452  1.00 23.23           H 
ATOM   1599 1HG  LYS   101       2.651  -5.085  -6.447  1.00 73.44           H 
ATOM   1600 2HG  LYS   101       3.514  -3.748  -5.688  1.00 72.03           H 
ATOM   1601 1HD  LYS   101       4.287  -5.072  -8.295  1.00 35.31           H 
ATOM   1602 2HD  LYS   101       5.043  -5.377  -6.732  1.00  5.24           H 
ATOM   1603 1HE  LYS   101       4.961  -2.669  -8.062  1.00 34.32           H 
ATOM   1604 2HE  LYS   101       6.305  -3.800  -8.205  1.00  3.21           H 
ATOM   1605 1HZ  LYS   101       6.652  -2.098  -6.493  1.00 63.31           H 
ATOM   1606 2HZ  LYS   101       6.690  -3.660  -5.858  1.00 45.02           H 
ATOM   1607 3HZ  LYS   101       5.325  -2.687  -5.631  1.00 31.44           H 
ATOM   1608  N   ALA   102       0.218  -0.624  -7.053  1.00 61.52           N 
ATOM   1609  CA  ALA   102      -0.539   0.473  -7.668  1.00  3.33           C 
ATOM   1610  C   ALA   102       0.318   1.727  -7.878  1.00  3.40           C 
ATOM   1611  O   ALA   102       1.429   1.836  -7.360  1.00 52.31           O 
ATOM   1612  CB  ALA   102      -1.755   0.806  -6.812  1.00 54.03           C 
ATOM   1613  H   ALA   102       0.648  -0.480  -6.183  1.00 38.03           H 
ATOM   1614  HA  ALA   102      -0.896   0.134  -8.632  1.00 11.12           H 
ATOM   1615 1HB  ALA   102      -1.429   1.159  -5.846  1.00 23.00           H 
ATOM   1616 2HB  ALA   102      -2.359  -0.081  -6.686  1.00 45.04           H 
ATOM   1617 3HB  ALA   102      -2.341   1.574  -7.296  1.00 54.13           H 
ATOM   1618  N   ASP   103      -0.212   2.666  -8.659  1.00 12.21           N 
ATOM   1619  CA  ASP   103       0.462   3.940  -8.912  1.00 64.42           C 
ATOM   1620  C   ASP   103       0.124   4.976  -7.823  1.00  0.21           C 
ATOM   1621  O   ASP   103       1.004   5.451  -7.108  1.00 15.41           O 
ATOM   1622  CB  ASP   103       0.057   4.465 -10.293  1.00 32.04           C 
ATOM   1623  CG  ASP   103       0.787   5.739 -10.671  1.00 53.14           C 
ATOM   1624  OD1 ASP   103       2.033   5.764 -10.573  1.00 54.02           O 
ATOM   1625  OD2 ASP   103       0.125   6.712 -11.077  1.00 11.52           O 
ATOM   1626  H   ASP   103      -1.070   2.491  -9.088  1.00 38.03           H 
ATOM   1627  HA  ASP   103       1.528   3.761  -8.905  1.00 11.53           H 
ATOM   1628 1HB  ASP   103      -1.007   4.660 -10.297  1.00 12.14           H 
ATOM   1629 2HB  ASP   103       0.280   3.712 -11.035  1.00 63.35           H 
ATOM   1630  N   ASP   104      -1.160   5.322  -7.715  1.00  3.13           N 
ATOM   1631  CA  ASP   104      -1.636   6.256  -6.692  1.00 71.02           C 
ATOM   1632  C   ASP   104      -3.047   5.875  -6.206  1.00  0.20           C 
ATOM   1633  O   ASP   104      -3.814   5.222  -6.921  1.00 51.02           O 
ATOM   1634  CB  ASP   104      -1.622   7.694  -7.233  1.00 11.24           C 
ATOM   1635  CG  ASP   104      -2.112   8.710  -6.210  1.00 23.30           C 
ATOM   1636  OD1 ASP   104      -1.689   8.633  -5.036  1.00 20.20           O 
ATOM   1637  OD2 ASP   104      -2.921   9.591  -6.571  1.00 12.23           O 
ATOM   1638  H   ASP   104      -1.803   4.945  -8.342  1.00 38.03           H 
ATOM   1639  HA  ASP   104      -0.958   6.195  -5.850  1.00 40.13           H 
ATOM   1640 1HB  ASP   104      -2.256   7.748  -8.108  1.00  4.52           H 
ATOM   1641 2HB  ASP   104      -0.611   7.954  -7.513  1.00 61.23           H 
ATOM   1642  N   ILE   105      -3.368   6.288  -4.980  1.00 32.15           N 
ATOM   1643  CA  ILE   105      -4.660   5.981  -4.350  1.00 41.35           C 
ATOM   1644  C   ILE   105      -5.524   7.247  -4.182  1.00 60.42           C 
ATOM   1645  O   ILE   105      -5.167   8.155  -3.429  1.00 60.12           O 
ATOM   1646  CB  ILE   105      -4.451   5.330  -2.955  1.00 43.41           C 
ATOM   1647  CG1 ILE   105      -3.690   3.997  -3.087  1.00 33.31           C 
ATOM   1648  CG2 ILE   105      -5.791   5.128  -2.243  1.00 10.35           C 
ATOM   1649  CD1 ILE   105      -3.415   3.310  -1.764  1.00  1.21           C 
ATOM   1650  H   ILE   105      -2.714   6.824  -4.485  1.00 38.03           H 
ATOM   1651  HA  ILE   105      -5.187   5.276  -4.981  1.00 62.24           H 
ATOM   1652  HB  ILE   105      -3.861   6.010  -2.356  1.00  0.50           H 
ATOM   1653 1HG1 ILE   105      -2.738   4.178  -3.568  1.00 32.53           H 
ATOM   1654 2HG1 ILE   105      -4.268   3.317  -3.694  1.00 13.25           H 
ATOM   1655 1HG2 ILE   105      -5.623   4.655  -1.286  1.00 22.05           H 
ATOM   1656 2HG2 ILE   105      -6.433   4.501  -2.845  1.00 64.15           H 
ATOM   1657 3HG2 ILE   105      -6.266   6.087  -2.088  1.00 74.44           H 
ATOM   1658 1HD1 ILE   105      -2.895   2.379  -1.944  1.00 25.33           H 
ATOM   1659 2HD1 ILE   105      -4.348   3.107  -1.259  1.00  0.54           H 
ATOM   1660 3HD1 ILE   105      -2.801   3.949  -1.145  1.00 11.23           H 
ATOM   1661  N   VAL   106      -6.659   7.297  -4.877  1.00 63.30           N 
ATOM   1662  CA  VAL   106      -7.599   8.426  -4.762  1.00 43.31           C 
ATOM   1663  C   VAL   106      -8.998   7.940  -4.353  1.00 22.13           C 
ATOM   1664  O   VAL   106      -9.250   6.741  -4.298  1.00 30.54           O 
ATOM   1665  CB  VAL   106      -7.700   9.217  -6.090  1.00  3.43           C 
ATOM   1666  CG1 VAL   106      -6.349   9.820  -6.469  1.00 65.25           C 
ATOM   1667  CG2 VAL   106      -8.233   8.327  -7.214  1.00 21.03           C 
ATOM   1668  H   VAL   106      -6.881   6.554  -5.483  1.00 38.03           H 
ATOM   1669  HA  VAL   106      -7.227   9.094  -3.995  1.00 32.31           H 
ATOM   1670  HB  VAL   106      -8.399  10.031  -5.945  1.00 14.53           H 
ATOM   1671 1HG1 VAL   106      -6.017  10.484  -5.683  1.00 65.21           H 
ATOM   1672 2HG1 VAL   106      -6.447  10.378  -7.391  1.00 22.24           H 
ATOM   1673 3HG1 VAL   106      -5.624   9.030  -6.603  1.00 61.32           H 
ATOM   1674 1HG2 VAL   106      -8.307   8.902  -8.125  1.00 33.22           H 
ATOM   1675 2HG2 VAL   106      -9.210   7.955  -6.946  1.00 22.33           H 
ATOM   1676 3HG2 VAL   106      -7.561   7.494  -7.367  1.00 33.51           H 
ATOM   1677  N   LEU   107      -9.903   8.871  -4.059  1.00  1.10           N 
ATOM   1678  CA  LEU   107     -11.288   8.516  -3.719  1.00  0.05           C 
ATOM   1679  C   LEU   107     -12.126   8.303  -4.988  1.00 30.30           C 
ATOM   1680  O   LEU   107     -11.865   8.920  -6.022  1.00 73.23           O 
ATOM   1681  CB  LEU   107     -11.928   9.606  -2.845  1.00 33.52           C 
ATOM   1682  CG  LEU   107     -11.286   9.800  -1.461  1.00 45.43           C 
ATOM   1683  CD1 LEU   107     -11.943  10.961  -0.718  1.00 74.32           C 
ATOM   1684  CD2 LEU   107     -11.378   8.519  -0.637  1.00  4.43           C 
ATOM   1685  H   LEU   107      -9.643   9.816  -4.076  1.00 38.03           H 
ATOM   1686  HA  LEU   107     -11.266   7.589  -3.161  1.00 54.51           H 
ATOM   1687 1HB  LEU   107     -12.971   9.360  -2.703  1.00 42.11           H 
ATOM   1688 2HB  LEU   107     -11.867  10.544  -3.380  1.00 43.34           H 
ATOM   1689  HG  LEU   107     -10.241  10.039  -1.591  1.00 13.41           H 
ATOM   1690 1HD1 LEU   107     -12.996  10.756  -0.584  1.00 14.53           H 
ATOM   1691 2HD1 LEU   107     -11.825  11.868  -1.292  1.00 54.44           H 
ATOM   1692 3HD1 LEU   107     -11.475  11.083   0.247  1.00 11.42           H 
ATOM   1693 1HD2 LEU   107     -12.417   8.256  -0.484  1.00 62.53           H 
ATOM   1694 2HD2 LEU   107     -10.902   8.672   0.320  1.00 11.32           H 
ATOM   1695 3HD2 LEU   107     -10.878   7.718  -1.160  1.00 25.04           H 
ATOM   1696  N   THR   108     -13.129   7.431  -4.899  1.00 51.23           N 
ATOM   1697  CA  THR   108     -13.996   7.125  -6.048  1.00  5.21           C 
ATOM   1698  C   THR   108     -14.769   8.370  -6.513  1.00 43.13           C 
ATOM   1699  O   THR   108     -15.734   8.790  -5.870  1.00 43.21           O 
ATOM   1700  CB  THR   108     -15.012   6.001  -5.716  1.00 21.32           C 
ATOM   1701  OG1 THR   108     -14.351   4.906  -5.062  1.00 45.23           O 
ATOM   1702  CG2 THR   108     -15.699   5.489  -6.981  1.00 75.40           C 
ATOM   1703  H   THR   108     -13.288   6.971  -4.047  1.00 38.03           H 
ATOM   1704  HA  THR   108     -13.365   6.783  -6.856  1.00 53.41           H 
ATOM   1705  HB  THR   108     -15.767   6.402  -5.055  1.00 41.42           H 
ATOM   1706  HG1 THR   108     -13.718   4.503  -5.665  1.00 55.30           H 
ATOM   1707 1HG2 THR   108     -16.392   4.702  -6.722  1.00 31.42           H 
ATOM   1708 2HG2 THR   108     -14.955   5.103  -7.665  1.00 33.42           H 
ATOM   1709 3HG2 THR   108     -16.235   6.300  -7.454  1.00 52.32           H 
END
