
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  109 ( 1557),  selected  109 , name 2d96_A
# Molecule2: number of CA atoms   63 (  926),  selected   63 , name T0469.pdb
# PARAMETERS: 2d96_A.T0469.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      Q       3           -
LGA    S     2_A      K       4           -
LGA    S     3_A      F       5           -
LGA    G     4_A      T       6           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    P     8_A      -       -           -
LGA    G     9_A      -       -           -
LGA    L    10_A      -       -           -
LGA    S    11_A      -       -           -
LGA    L    12_A      K       7           #
LGA    G    13_A      -       -           -
LGA    D    14_A      -       -           -
LGA    T    15_A      -       -           -
LGA    A    16_A      D       8          2.519
LGA    L    17_A      M       9          3.090
LGA    Q    18_A      -       -           -
LGA    N    19_A      -       -           -
LGA    L    20_A      T      10          3.854
LGA    E    21_A      F      11          3.364
LGA    Q    22_A      A      12          4.210
LGA    L    23_A      Q      13          2.597
LGA    L    24_A      A      14          1.398
LGA    D    25_A      L      15          3.650
LGA    G    26_A      Q      16          2.337
LGA    P    27_A      -       -           -
LGA    E    28_A      -       -           -
LGA    A    29_A      T      17          1.964
LGA    Q    30_A      H      18          3.029
LGA    G    31_A      P      19          3.541
LGA    S    32_A      G      20          4.654
LGA    W    33_A      V      21          3.830
LGA    A    34_A      A      22          1.975
LGA    E    35_A      G      23          1.575
LGA    L    36_A      V      24          2.467
LGA    A    37_A      L      25          1.199
LGA    E    38_A      R      26          3.564
LGA    R    39_A      S      27          4.700
LGA    L    40_A      -       -           -
LGA    G    41_A      -       -           -
LGA    L    42_A      Y      28          2.679
LGA    R    43_A      N      29          2.972
LGA    S    44_A      -       -           -
LGA    L    45_A      L      30          4.651
LGA    V    46_A      G      31          1.225
LGA    D    47_A      -       -           -
LGA    T    48_A      C      32          3.041
LGA    Y    49_A      I      33          2.369
LGA    R    50_A      G      34          1.571
LGA    Q    51_A      C      35          1.312
LGA    T    52_A      M      36          3.364
LGA    T    53_A      G      37          3.429
LGA    S    54_A      A      38          3.693
LGA    P    55_A      Q      39          3.021
LGA    S    56_A      N      40          5.152
LGA    G    57_A      E      41          1.612
LGA    S    58_A      S      42           #
LGA    L    59_A      L      43          5.400
LGA    L    60_A      E      44          3.630
LGA    R    61_A      Q      45          1.205
LGA    S    62_A      G      46          2.641
LGA    Y    63_A      A      47          1.189
LGA    E    64_A      N      48          2.535
LGA    -       -      A      49           -
LGA    L    65_A      H      50          4.663
LGA    A    66_A      G      51          1.260
LGA    G    67_A      L      52          3.501
LGA    G    68_A      N      53          1.016
LGA    D    69_A      V      54          3.798
LGA    L    70_A      E      55          2.195
LGA    A    71_A      -       -           -
LGA    G    72_A      D      56          0.785
LGA    L    73_A      I      57          1.900
LGA    L    74_A      L      58          2.282
LGA    E    75_A      R      59          1.474
LGA    A    76_A      D      60          1.168
LGA    L    77_A      L      61          0.916
LGA    S    78_A      N      62          2.271
LGA    D    79_A      A      63          2.583
LGA    M    80_A      L      64          2.064
LGA    G    81_A      A      65          2.224
LGA    L    82_A      -       -           -
LGA    E    83_A      -       -           -
LGA    E    84_A      -       -           -
LGA    G    85_A      -       -           -
LGA    V    86_A      -       -           -
LGA    R    87_A      -       -           -
LGA    L    88_A      -       -           -
LGA    L    89_A      -       -           -
LGA    R    90_A      -       -           -
LGA    G    91_A      -       -           -
LGA    P    92_A      -       -           -
LGA    E    93_A      -       -           -
LGA    T    94_A      -       -           -
LGA    R    95_A      -       -           -
LGA    D    96_A      -       -           -
LGA    K    97_A      -       -           -
LGA    L    98_A      -       -           -
LGA    P    99_A      -       -           -
LGA    S   100_A      -       -           -
LGA    T   101_A      -       -           -
LGA    E   102_A      -       -           -
LGA    V   103_A      -       -           -
LGA    S   104_A      -       -           -
LGA    G   105_A      -       -           -
LGA    P   106_A      -       -           -
LGA    S   107_A      -       -           -
LGA    S   108_A      -       -           -
LGA    G   109_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  109   63    5.0     56    2.93     8.93     52.000     1.849

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.833934 * X  +   0.550427 * Y  +   0.039805 * Z  +  -1.273339
  Y_new =   0.478570 * X  +   0.757212 * Y  +  -0.444523 * Z  +  -1.231742
  Z_new =  -0.274818 * X  +  -0.351654 * Y  +  -0.894882 * Z  +  -4.057874 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.767169    0.374423  [ DEG:  -158.5471     21.4529 ]
  Theta =   0.278401    2.863192  [ DEG:    15.9512    164.0488 ]
  Phi   =   2.620608   -0.520985  [ DEG:   150.1498    -29.8502 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2d96_A                                        
REMARK     2: T0469.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2d96_A.T0469.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  109   63   5.0   56   2.93    8.93  52.000
REMARK  ---------------------------------------------------------- 
MOLECULE 2d96_A
HEADER    TRANSCRIPTION                           08-DEC-05   2D96              
TITLE     SOLUTION STRUCTURE OF THE DEATH DOMAIN OF NUCLEAR FACTOR NF-          
TITLE    2 KAPPA-B P100                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NUCLEAR FACTOR NF-KAPPA-B P100 SUBUNIT;                    
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: DEATH DOMAIN;                                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: NFKB2;                                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050404-15;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    SIX HELIX BUNDLE, PROCESSING, PROTEASOME, SIGNAL                      
KEYWDS   2 TRANSDUCTION, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT          
KEYWDS   3 ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                 
KEYWDS   4 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    T.NAGASHIMA,F.HAYASHI,S.YOKOYAMA,RIKEN STRUCTURAL                     
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   08-DEC-06 2D96    0                                                
JRNL        AUTH   T.NAGASHIMA,F.HAYASHI,S.YOKOYAMA                             
JRNL        TITL   SOLUTION STRUCTURE OF THE DEATH DOMAIN OF NUCLEAR            
JRNL        TITL 2 FACTOR NF-KAPPA-B P100                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2D96 A    8   103  UNP    Q00653   NFKB2_HUMAN    766    861             
SEQRES   1 A  109  GLY SER SER GLY SER SER GLY PRO GLY LEU SER LEU GLY          
SEQRES   2 A  109  ASP THR ALA LEU GLN ASN LEU GLU GLN LEU LEU ASP GLY          
SEQRES   3 A  109  PRO GLU ALA GLN GLY SER TRP ALA GLU LEU ALA GLU ARG          
SEQRES   4 A  109  LEU GLY LEU ARG SER LEU VAL ASP THR TYR ARG GLN THR          
SEQRES   5 A  109  THR SER PRO SER GLY SER LEU LEU ARG SER TYR GLU LEU          
SEQRES   6 A  109  ALA GLY GLY ASP LEU ALA GLY LEU LEU GLU ALA LEU SER          
SEQRES   7 A  109  ASP MET GLY LEU GLU GLU GLY VAL ARG LEU LEU ARG GLY          
SEQRES   8 A  109  PRO GLU THR ARG ASP LYS LEU PRO SER THR GLU VAL SER          
SEQRES   9 A  109  GLY PRO SER SER GLY                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1     -20.861  -3.234   5.145  1.00  0.00           N  
ATOM      2  CA  GLY A   1     -19.951  -3.306   6.273  1.00  0.00           C  
ATOM      3  C   GLY A   1     -19.231  -1.995   6.522  1.00  0.00           C  
ATOM      4  O   GLY A   1     -18.607  -1.441   5.617  1.00  0.00           O  
ATOM      5  HA2 GLY A   1     -20.511  -3.571   7.157  1.00  0.00           H  
ATOM      6  HA3 GLY A   1     -19.217  -4.076   6.080  1.00  0.00           H  
ATOM      7  H1  GLY A   1     -21.221  -4.058   4.755  1.00  0.00           H  
ATOM      8  N   SER A   2     -19.320  -1.497   7.751  1.00  0.00           N  
ATOM      9  CA  SER A   2     -18.677  -0.240   8.114  1.00  0.00           C  
ATOM     10  C   SER A   2     -17.606  -0.465   9.178  1.00  0.00           C  
ATOM     11  O   SER A   2     -17.491   0.304  10.132  1.00  0.00           O  
ATOM     12  CB  SER A   2     -19.715   0.760   8.625  1.00  0.00           C  
ATOM     13  OG  SER A   2     -20.704   1.015   7.642  1.00  0.00           O  
ATOM     14  H   SER A   2     -19.833  -1.986   8.428  1.00  0.00           H  
ATOM     15  HA  SER A   2     -18.209   0.161   7.228  1.00  0.00           H  
ATOM     16  HB2 SER A   2     -20.196   0.359   9.504  1.00  0.00           H  
ATOM     17  HB3 SER A   2     -19.225   1.689   8.875  1.00  0.00           H  
ATOM     18  HG  SER A   2     -20.449   1.781   7.122  1.00  0.00           H  
ATOM     19  N   SER A   3     -16.824  -1.526   9.005  1.00  0.00           N  
ATOM     20  CA  SER A   3     -15.763  -1.857   9.951  1.00  0.00           C  
ATOM     21  C   SER A   3     -14.609  -2.564   9.248  1.00  0.00           C  
ATOM     22  O   SER A   3     -14.777  -3.126   8.167  1.00  0.00           O  
ATOM     23  CB  SER A   3     -16.311  -2.741  11.073  1.00  0.00           C  
ATOM     24  OG  SER A   3     -15.347  -2.919  12.097  1.00  0.00           O  
ATOM     25  H   SER A   3     -16.964  -2.101   8.224  1.00  0.00           H  
ATOM     26  HA  SER A   3     -15.400  -0.933  10.377  1.00  0.00           H  
ATOM     27  HB2 SER A   3     -17.188  -2.278  11.498  1.00  0.00           H  
ATOM     28  HB3 SER A   3     -16.574  -3.708  10.670  1.00  0.00           H  
ATOM     29  HG  SER A   3     -14.745  -3.624  11.851  1.00  0.00           H  
ATOM     30  N   GLY A   4     -13.435  -2.530   9.871  1.00  0.00           N  
ATOM     31  CA  GLY A   4     -12.269  -3.170   9.291  1.00  0.00           C  
ATOM     32  C   GLY A   4     -11.363  -3.783  10.340  1.00  0.00           C  
ATOM     33  O   GLY A   4     -10.962  -4.942  10.222  1.00  0.00           O  
ATOM     34  H   GLY A   4     -13.361  -2.065  10.731  1.00  0.00           H  
ATOM     35  HA2 GLY A   4     -12.596  -3.944   8.614  1.00  0.00           H  
ATOM     36  HA3 GLY A   4     -11.707  -2.433   8.734  1.00  0.00           H  
ATOM     37  N   SER A   5     -11.039  -3.006  11.369  1.00  0.00           N  
ATOM     38  CA  SER A   5     -10.171  -3.479  12.440  1.00  0.00           C  
ATOM     39  C   SER A   5     -10.821  -4.634  13.197  1.00  0.00           C  
ATOM     40  O   SER A   5     -10.220  -5.693  13.371  1.00  0.00           O  
ATOM     41  CB  SER A   5      -9.849  -2.338  13.406  1.00  0.00           C  
ATOM     42  OG  SER A   5      -9.087  -2.801  14.507  1.00  0.00           O  
ATOM     43  H   SER A   5     -11.391  -2.093  11.406  1.00  0.00           H  
ATOM     44  HA  SER A   5      -9.253  -3.830  11.993  1.00  0.00           H  
ATOM     45  HB2 SER A   5      -9.285  -1.579  12.887  1.00  0.00           H  
ATOM     46  HB3 SER A   5     -10.771  -1.912  13.775  1.00  0.00           H  
ATOM     47  HG  SER A   5      -9.398  -2.380  15.312  1.00  0.00           H  
ATOM     48  N   SER A   6     -12.054  -4.419  13.646  1.00  0.00           N  
ATOM     49  CA  SER A   6     -12.787  -5.438  14.388  1.00  0.00           C  
ATOM     50  C   SER A   6     -12.655  -6.801  13.714  1.00  0.00           C  
ATOM     51  O   SER A   6     -12.218  -7.772  14.331  1.00  0.00           O  
ATOM     52  CB  SER A   6     -14.263  -5.054  14.502  1.00  0.00           C  
ATOM     53  OG  SER A   6     -14.982  -6.014  15.259  1.00  0.00           O  
ATOM     54  H   SER A   6     -12.480  -3.552  13.475  1.00  0.00           H  
ATOM     55  HA  SER A   6     -12.360  -5.497  15.378  1.00  0.00           H  
ATOM     56  HB2 SER A   6     -14.346  -4.094  14.989  1.00  0.00           H  
ATOM     57  HB3 SER A   6     -14.694  -4.995  13.514  1.00  0.00           H  
ATOM     58  HG  SER A   6     -15.089  -5.696  16.158  1.00  0.00           H  
ATOM     59  N   GLY A   7     -13.035  -6.864  12.441  1.00  0.00           N  
ATOM     60  CA  GLY A   7     -12.953  -8.111  11.703  1.00  0.00           C  
ATOM     61  C   GLY A   7     -11.556  -8.386  11.184  1.00  0.00           C  
ATOM     62  O   GLY A   7     -10.808  -7.472  10.836  1.00  0.00           O  
ATOM     63  H   GLY A   7     -13.375  -6.057  12.000  1.00  0.00           H  
ATOM     64  HA2 GLY A   7     -13.251  -8.921  12.352  1.00  0.00           H  
ATOM     65  HA3 GLY A   7     -13.633  -8.065  10.864  1.00  0.00           H  
ATOM     66  N   PRO A   8     -11.183  -9.674  11.130  1.00  0.00           N  
ATOM     67  CA  PRO A   8      -9.863 -10.097  10.653  1.00  0.00           C  
ATOM     68  C   PRO A   8      -9.693  -9.882   9.153  1.00  0.00           C  
ATOM     69  O   PRO A   8      -8.604 -10.059   8.610  1.00  0.00           O  
ATOM     70  CB  PRO A   8      -9.827 -11.589  10.987  1.00  0.00           C  
ATOM     71  CG  PRO A   8     -11.257 -12.006  11.020  1.00  0.00           C  
ATOM     72  CD  PRO A   8     -12.023 -10.815  11.530  1.00  0.00           C  
ATOM     73  HA  PRO A   8      -9.069  -9.588  11.180  1.00  0.00           H  
ATOM     74  HB2 PRO A   8      -9.279 -12.120  10.221  1.00  0.00           H  
ATOM     75  HB3 PRO A   8      -9.351 -11.736  11.945  1.00  0.00           H  
ATOM     76  HG2 PRO A   8     -11.587 -12.266  10.026  1.00  0.00           H  
ATOM     77  HG3 PRO A   8     -11.380 -12.844  11.690  1.00  0.00           H  
ATOM     78  HD2 PRO A   8     -12.994 -10.763  11.061  1.00  0.00           H  
ATOM     79  HD3 PRO A   8     -12.122 -10.863  12.604  1.00  0.00           H  
ATOM     80  N   GLY A   9     -10.779  -9.498   8.487  1.00  0.00           N  
ATOM     81  CA  GLY A   9     -10.728  -9.266   7.056  1.00  0.00           C  
ATOM     82  C   GLY A   9     -10.978  -7.815   6.695  1.00  0.00           C  
ATOM     83  O   GLY A   9     -11.570  -7.067   7.473  1.00  0.00           O  
ATOM     84  H   GLY A   9     -11.621  -9.373   8.973  1.00  0.00           H  
ATOM     85  HA2 GLY A   9      -9.753  -9.554   6.690  1.00  0.00           H  
ATOM     86  HA3 GLY A   9     -11.477  -9.878   6.576  1.00  0.00           H  
ATOM     87  N   LEU A  10     -10.525  -7.416   5.512  1.00  0.00           N  
ATOM     88  CA  LEU A  10     -10.701  -6.043   5.049  1.00  0.00           C  
ATOM     89  C   LEU A  10     -12.030  -5.882   4.317  1.00  0.00           C  
ATOM     90  O   LEU A  10     -12.438  -6.755   3.552  1.00  0.00           O  
ATOM     91  CB  LEU A  10      -9.547  -5.641   4.129  1.00  0.00           C  
ATOM     92  CG  LEU A  10      -8.258  -5.200   4.824  1.00  0.00           C  
ATOM     93  CD1 LEU A  10      -7.170  -4.918   3.800  1.00  0.00           C  
ATOM     94  CD2 LEU A  10      -8.510  -3.975   5.689  1.00  0.00           C  
ATOM     95  H   LEU A  10     -10.061  -8.057   4.934  1.00  0.00           H  
ATOM     96  HA  LEU A  10     -10.701  -5.399   5.916  1.00  0.00           H  
ATOM     97  HB2 LEU A  10      -9.312  -6.489   3.504  1.00  0.00           H  
ATOM     98  HB3 LEU A  10      -9.887  -4.823   3.511  1.00  0.00           H  
ATOM     99  HG  LEU A  10      -7.912  -5.999   5.466  1.00  0.00           H  
ATOM    100 HD11 LEU A  10      -6.745  -3.944   3.985  1.00  0.00           H  
ATOM    101 HD12 LEU A  10      -7.595  -4.942   2.807  1.00  0.00           H  
ATOM    102 HD13 LEU A  10      -6.398  -5.670   3.878  1.00  0.00           H  
ATOM    103 HD21 LEU A  10      -9.061  -4.265   6.572  1.00  0.00           H  
ATOM    104 HD22 LEU A  10      -9.085  -3.251   5.129  1.00  0.00           H  
ATOM    105 HD23 LEU A  10      -7.567  -3.538   5.979  1.00  0.00           H  
ATOM    106  N   SER A  11     -12.698  -4.758   4.555  1.00  0.00           N  
ATOM    107  CA  SER A  11     -13.982  -4.483   3.920  1.00  0.00           C  
ATOM    108  C   SER A  11     -13.783  -3.910   2.521  1.00  0.00           C  
ATOM    109  O   SER A  11     -14.332  -2.859   2.183  1.00  0.00           O  
ATOM    110  CB  SER A  11     -14.798  -3.508   4.772  1.00  0.00           C  
ATOM    111  OG  SER A  11     -15.276  -4.137   5.949  1.00  0.00           O  
ATOM    112  H   SER A  11     -12.321  -4.100   5.176  1.00  0.00           H  
ATOM    113  HA  SER A  11     -14.520  -5.415   3.841  1.00  0.00           H  
ATOM    114  HB2 SER A  11     -14.177  -2.671   5.052  1.00  0.00           H  
ATOM    115  HB3 SER A  11     -15.643  -3.155   4.199  1.00  0.00           H  
ATOM    116  HG  SER A  11     -15.731  -3.491   6.494  1.00  0.00           H  
ATOM    117  N   LEU A  12     -12.994  -4.605   1.709  1.00  0.00           N  
ATOM    118  CA  LEU A  12     -12.721  -4.167   0.345  1.00  0.00           C  
ATOM    119  C   LEU A  12     -13.306  -5.145  -0.668  1.00  0.00           C  
ATOM    120  O   LEU A  12     -13.889  -6.163  -0.299  1.00  0.00           O  
ATOM    121  CB  LEU A  12     -11.213  -4.027   0.126  1.00  0.00           C  
ATOM    122  CG  LEU A  12     -10.514  -2.939   0.939  1.00  0.00           C  
ATOM    123  CD1 LEU A  12      -9.004  -3.060   0.807  1.00  0.00           C  
ATOM    124  CD2 LEU A  12     -10.981  -1.559   0.497  1.00  0.00           C  
ATOM    125  H   LEU A  12     -12.584  -5.434   2.035  1.00  0.00           H  
ATOM    126  HA  LEU A  12     -13.187  -3.202   0.208  1.00  0.00           H  
ATOM    127  HB2 LEU A  12     -10.755  -4.972   0.374  1.00  0.00           H  
ATOM    128  HB3 LEU A  12     -11.051  -3.815  -0.922  1.00  0.00           H  
ATOM    129  HG  LEU A  12     -10.768  -3.059   1.983  1.00  0.00           H  
ATOM    130 HD11 LEU A  12      -8.757  -3.425  -0.178  1.00  0.00           H  
ATOM    131 HD12 LEU A  12      -8.632  -3.749   1.552  1.00  0.00           H  
ATOM    132 HD13 LEU A  12      -8.551  -2.090   0.956  1.00  0.00           H  
ATOM    133 HD21 LEU A  12     -12.061  -1.528   0.497  1.00  0.00           H  
ATOM    134 HD22 LEU A  12     -10.616  -1.358  -0.501  1.00  0.00           H  
ATOM    135 HD23 LEU A  12     -10.599  -0.814   1.179  1.00  0.00           H  
ATOM    136  N   GLY A  13     -13.144  -4.829  -1.950  1.00  0.00           N  
ATOM    137  CA  GLY A  13     -13.660  -5.691  -2.997  1.00  0.00           C  
ATOM    138  C   GLY A  13     -12.585  -6.118  -3.978  1.00  0.00           C  
ATOM    139  O   GLY A  13     -11.662  -5.357  -4.268  1.00  0.00           O  
ATOM    140  H   GLY A  13     -12.670  -4.004  -2.185  1.00  0.00           H  
ATOM    141  HA2 GLY A  13     -14.089  -6.572  -2.544  1.00  0.00           H  
ATOM    142  HA3 GLY A  13     -14.432  -5.161  -3.535  1.00  0.00           H  
ATOM    143  N   ASP A  14     -12.704  -7.338  -4.489  1.00  0.00           N  
ATOM    144  CA  ASP A  14     -11.736  -7.866  -5.443  1.00  0.00           C  
ATOM    145  C   ASP A  14     -11.265  -6.774  -6.399  1.00  0.00           C  
ATOM    146  O   ASP A  14     -10.064  -6.565  -6.577  1.00  0.00           O  
ATOM    147  CB  ASP A  14     -12.345  -9.024  -6.233  1.00  0.00           C  
ATOM    148  CG  ASP A  14     -12.481 -10.285  -5.402  1.00  0.00           C  
ATOM    149  OD1 ASP A  14     -12.487 -10.176  -4.158  1.00  0.00           O  
ATOM    150  OD2 ASP A  14     -12.582 -11.379  -5.995  1.00  0.00           O  
ATOM    151  H   ASP A  14     -13.463  -7.897  -4.219  1.00  0.00           H  
ATOM    152  HA  ASP A  14     -10.886  -8.230  -4.886  1.00  0.00           H  
ATOM    153  HB2 ASP A  14     -13.328  -8.737  -6.581  1.00  0.00           H  
ATOM    154  HB3 ASP A  14     -11.716  -9.242  -7.084  1.00  0.00           H  
ATOM    155  N   THR A  15     -12.218  -6.080  -7.013  1.00  0.00           N  
ATOM    156  CA  THR A  15     -11.901  -5.011  -7.952  1.00  0.00           C  
ATOM    157  C   THR A  15     -11.149  -3.878  -7.262  1.00  0.00           C  
ATOM    158  O   THR A  15     -10.241  -3.281  -7.839  1.00  0.00           O  
ATOM    159  CB  THR A  15     -13.173  -4.443  -8.607  1.00  0.00           C  
ATOM    160  OG1 THR A  15     -13.950  -5.506  -9.171  1.00  0.00           O  
ATOM    161  CG2 THR A  15     -12.821  -3.436  -9.691  1.00  0.00           C  
ATOM    162  H   THR A  15     -13.156  -6.293  -6.829  1.00  0.00           H  
ATOM    163  HA  THR A  15     -11.275  -5.426  -8.729  1.00  0.00           H  
ATOM    164  HB  THR A  15     -13.759  -3.944  -7.849  1.00  0.00           H  
ATOM    165  HG1 THR A  15     -14.840  -5.478  -8.812  1.00  0.00           H  
ATOM    166 HG21 THR A  15     -13.082  -3.841 -10.658  1.00  0.00           H  
ATOM    167 HG22 THR A  15     -11.761  -3.231  -9.662  1.00  0.00           H  
ATOM    168 HG23 THR A  15     -13.369  -2.521  -9.524  1.00  0.00           H  
ATOM    169  N   ALA A  16     -11.533  -3.588  -6.024  1.00  0.00           N  
ATOM    170  CA  ALA A  16     -10.894  -2.527  -5.255  1.00  0.00           C  
ATOM    171  C   ALA A  16      -9.381  -2.714  -5.215  1.00  0.00           C  
ATOM    172  O   ALA A  16      -8.624  -1.813  -5.579  1.00  0.00           O  
ATOM    173  CB  ALA A  16     -11.460  -2.485  -3.843  1.00  0.00           C  
ATOM    174  H   ALA A  16     -12.264  -4.098  -5.617  1.00  0.00           H  
ATOM    175  HA  ALA A  16     -11.117  -1.585  -5.735  1.00  0.00           H  
ATOM    176  HB1 ALA A  16     -12.532  -2.607  -3.882  1.00  0.00           H  
ATOM    177  HB2 ALA A  16     -11.027  -3.281  -3.258  1.00  0.00           H  
ATOM    178  HB3 ALA A  16     -11.222  -1.534  -3.389  1.00  0.00           H  
ATOM    179  N   LEU A  17      -8.946  -3.888  -4.771  1.00  0.00           N  
ATOM    180  CA  LEU A  17      -7.522  -4.193  -4.683  1.00  0.00           C  
ATOM    181  C   LEU A  17      -6.852  -4.061  -6.047  1.00  0.00           C  
ATOM    182  O   LEU A  17      -5.783  -3.465  -6.168  1.00  0.00           O  
ATOM    183  CB  LEU A  17      -7.316  -5.607  -4.136  1.00  0.00           C  
ATOM    184  CG  LEU A  17      -7.208  -5.729  -2.616  1.00  0.00           C  
ATOM    185  CD1 LEU A  17      -8.588  -5.862  -1.990  1.00  0.00           C  
ATOM    186  CD2 LEU A  17      -6.332  -6.913  -2.236  1.00  0.00           C  
ATOM    187  H   LEU A  17      -9.597  -4.567  -4.496  1.00  0.00           H  
ATOM    188  HA  LEU A  17      -7.073  -3.484  -4.004  1.00  0.00           H  
ATOM    189  HB2 LEU A  17      -8.152  -6.211  -4.456  1.00  0.00           H  
ATOM    190  HB3 LEU A  17      -6.406  -5.998  -4.566  1.00  0.00           H  
ATOM    191  HG  LEU A  17      -6.750  -4.832  -2.220  1.00  0.00           H  
ATOM    192 HD11 LEU A  17      -9.204  -5.029  -2.294  1.00  0.00           H  
ATOM    193 HD12 LEU A  17      -8.497  -5.871  -0.915  1.00  0.00           H  
ATOM    194 HD13 LEU A  17      -9.044  -6.786  -2.319  1.00  0.00           H  
ATOM    195 HD21 LEU A  17      -5.964  -7.390  -3.133  1.00  0.00           H  
ATOM    196 HD22 LEU A  17      -6.912  -7.623  -1.664  1.00  0.00           H  
ATOM    197 HD23 LEU A  17      -5.497  -6.569  -1.644  1.00  0.00           H  
ATOM    198  N   GLN A  18      -7.489  -4.621  -7.070  1.00  0.00           N  
ATOM    199  CA  GLN A  18      -6.954  -4.564  -8.426  1.00  0.00           C  
ATOM    200  C   GLN A  18      -6.623  -3.129  -8.820  1.00  0.00           C  
ATOM    201  O   GLN A  18      -5.611  -2.872  -9.471  1.00  0.00           O  
ATOM    202  CB  GLN A  18      -7.956  -5.159  -9.418  1.00  0.00           C  
ATOM    203  CG  GLN A  18      -8.051  -6.674  -9.350  1.00  0.00           C  
ATOM    204  CD  GLN A  18      -6.843  -7.363  -9.954  1.00  0.00           C  
ATOM    205  OE1 GLN A  18      -5.704  -7.090  -9.574  1.00  0.00           O  
ATOM    206  NE2 GLN A  18      -7.086  -8.262 -10.900  1.00  0.00           N  
ATOM    207  H   GLN A  18      -8.337  -5.082  -6.910  1.00  0.00           H  
ATOM    208  HA  GLN A  18      -6.047  -5.149  -8.449  1.00  0.00           H  
ATOM    209  HB2 GLN A  18      -8.933  -4.748  -9.214  1.00  0.00           H  
ATOM    210  HB3 GLN A  18      -7.660  -4.884 -10.418  1.00  0.00           H  
ATOM    211  HG2 GLN A  18      -8.134  -6.972  -8.315  1.00  0.00           H  
ATOM    212  HG3 GLN A  18      -8.934  -6.991  -9.885  1.00  0.00           H  
ATOM    213 HE21 GLN A  18      -8.019  -8.427 -11.153  1.00  0.00           H  
ATOM    214 HE22 GLN A  18      -6.324  -8.722 -11.309  1.00  0.00           H  
ATOM    215  N   ASN A  19      -7.482  -2.197  -8.421  1.00  0.00           N  
ATOM    216  CA  ASN A  19      -7.280  -0.787  -8.733  1.00  0.00           C  
ATOM    217  C   ASN A  19      -6.192  -0.183  -7.849  1.00  0.00           C  
ATOM    218  O   ASN A  19      -5.250   0.439  -8.342  1.00  0.00           O  
ATOM    219  CB  ASN A  19      -8.587  -0.011  -8.554  1.00  0.00           C  
ATOM    220  CG  ASN A  19      -9.496  -0.124  -9.762  1.00  0.00           C  
ATOM    221  OD1 ASN A  19      -9.246   0.486 -10.802  1.00  0.00           O  
ATOM    222  ND2 ASN A  19     -10.560  -0.907  -9.629  1.00  0.00           N  
ATOM    223  H   ASN A  19      -8.270  -2.462  -7.904  1.00  0.00           H  
ATOM    224  HA  ASN A  19      -6.968  -0.717  -9.765  1.00  0.00           H  
ATOM    225  HB2 ASN A  19      -9.113  -0.398  -7.694  1.00  0.00           H  
ATOM    226  HB3 ASN A  19      -8.360   1.032  -8.393  1.00  0.00           H  
ATOM    227 HD21 ASN A  19     -10.696  -1.363  -8.772  1.00  0.00           H  
ATOM    228 HD22 ASN A  19     -11.165  -0.999 -10.395  1.00  0.00           H  
ATOM    229  N   LEU A  20      -6.328  -0.373  -6.542  1.00  0.00           N  
ATOM    230  CA  LEU A  20      -5.357   0.152  -5.588  1.00  0.00           C  
ATOM    231  C   LEU A  20      -3.948  -0.321  -5.930  1.00  0.00           C  
ATOM    232  O   LEU A  20      -2.977   0.418  -5.766  1.00  0.00           O  
ATOM    233  CB  LEU A  20      -5.722  -0.282  -4.167  1.00  0.00           C  
ATOM    234  CG  LEU A  20      -5.313   0.674  -3.047  1.00  0.00           C  
ATOM    235  CD1 LEU A  20      -3.798   0.774  -2.956  1.00  0.00           C  
ATOM    236  CD2 LEU A  20      -5.928   2.048  -3.268  1.00  0.00           C  
ATOM    237  H   LEU A  20      -7.099  -0.876  -6.209  1.00  0.00           H  
ATOM    238  HA  LEU A  20      -5.385   1.229  -5.644  1.00  0.00           H  
ATOM    239  HB2 LEU A  20      -6.793  -0.404  -4.123  1.00  0.00           H  
ATOM    240  HB3 LEU A  20      -5.246  -1.235  -3.981  1.00  0.00           H  
ATOM    241  HG  LEU A  20      -5.678   0.291  -2.104  1.00  0.00           H  
ATOM    242 HD11 LEU A  20      -3.460   1.627  -3.525  1.00  0.00           H  
ATOM    243 HD12 LEU A  20      -3.353  -0.125  -3.357  1.00  0.00           H  
ATOM    244 HD13 LEU A  20      -3.506   0.891  -1.923  1.00  0.00           H  
ATOM    245 HD21 LEU A  20      -6.983   1.941  -3.473  1.00  0.00           H  
ATOM    246 HD22 LEU A  20      -5.445   2.528  -4.107  1.00  0.00           H  
ATOM    247 HD23 LEU A  20      -5.792   2.650  -2.382  1.00  0.00           H  
ATOM    248  N   GLU A  21      -3.843  -1.556  -6.410  1.00  0.00           N  
ATOM    249  CA  GLU A  21      -2.552  -2.126  -6.777  1.00  0.00           C  
ATOM    250  C   GLU A  21      -1.926  -1.355  -7.935  1.00  0.00           C  
ATOM    251  O   GLU A  21      -0.823  -0.824  -7.815  1.00  0.00           O  
ATOM    252  CB  GLU A  21      -2.710  -3.600  -7.157  1.00  0.00           C  
ATOM    253  CG  GLU A  21      -3.148  -4.484  -6.002  1.00  0.00           C  
ATOM    254  CD  GLU A  21      -3.927  -5.701  -6.460  1.00  0.00           C  
ATOM    255  OE1 GLU A  21      -4.051  -5.899  -7.687  1.00  0.00           O  
ATOM    256  OE2 GLU A  21      -4.413  -6.455  -5.592  1.00  0.00           O  
ATOM    257  H   GLU A  21      -4.653  -2.097  -6.519  1.00  0.00           H  
ATOM    258  HA  GLU A  21      -1.902  -2.054  -5.918  1.00  0.00           H  
ATOM    259  HB2 GLU A  21      -3.447  -3.679  -7.944  1.00  0.00           H  
ATOM    260  HB3 GLU A  21      -1.763  -3.967  -7.525  1.00  0.00           H  
ATOM    261  HG2 GLU A  21      -2.270  -4.817  -5.468  1.00  0.00           H  
ATOM    262  HG3 GLU A  21      -3.772  -3.903  -5.338  1.00  0.00           H  
ATOM    263  N   GLN A  22      -2.640  -1.298  -9.055  1.00  0.00           N  
ATOM    264  CA  GLN A  22      -2.153  -0.594 -10.235  1.00  0.00           C  
ATOM    265  C   GLN A  22      -1.902   0.878  -9.925  1.00  0.00           C  
ATOM    266  O   GLN A  22      -0.869   1.436 -10.300  1.00  0.00           O  
ATOM    267  CB  GLN A  22      -3.159  -0.720 -11.381  1.00  0.00           C  
ATOM    268  CG  GLN A  22      -4.199   0.388 -11.405  1.00  0.00           C  
ATOM    269  CD  GLN A  22      -5.151   0.270 -12.578  1.00  0.00           C  
ATOM    270  OE1 GLN A  22      -5.629  -0.818 -12.897  1.00  0.00           O  
ATOM    271  NE2 GLN A  22      -5.434   1.394 -13.226  1.00  0.00           N  
ATOM    272  H   GLN A  22      -3.512  -1.743  -9.089  1.00  0.00           H  
ATOM    273  HA  GLN A  22      -1.222  -1.050 -10.533  1.00  0.00           H  
ATOM    274  HB2 GLN A  22      -2.623  -0.702 -12.318  1.00  0.00           H  
ATOM    275  HB3 GLN A  22      -3.674  -1.665 -11.289  1.00  0.00           H  
ATOM    276  HG2 GLN A  22      -4.771   0.347 -10.490  1.00  0.00           H  
ATOM    277  HG3 GLN A  22      -3.690   1.339 -11.467  1.00  0.00           H  
ATOM    278 HE21 GLN A  22      -5.016   2.224 -12.915  1.00  0.00           H  
ATOM    279 HE22 GLN A  22      -6.046   1.346 -13.989  1.00  0.00           H  
ATOM    280  N   LEU A  23      -2.852   1.504  -9.238  1.00  0.00           N  
ATOM    281  CA  LEU A  23      -2.733   2.912  -8.877  1.00  0.00           C  
ATOM    282  C   LEU A  23      -1.363   3.207  -8.276  1.00  0.00           C  
ATOM    283  O   LEU A  23      -0.672   4.134  -8.702  1.00  0.00           O  
ATOM    284  CB  LEU A  23      -3.831   3.299  -7.884  1.00  0.00           C  
ATOM    285  CG  LEU A  23      -5.214   3.559  -8.481  1.00  0.00           C  
ATOM    286  CD1 LEU A  23      -6.286   3.464  -7.407  1.00  0.00           C  
ATOM    287  CD2 LEU A  23      -5.255   4.921  -9.159  1.00  0.00           C  
ATOM    288  H   LEU A  23      -3.651   1.008  -8.967  1.00  0.00           H  
ATOM    289  HA  LEU A  23      -2.852   3.496  -9.777  1.00  0.00           H  
ATOM    290  HB2 LEU A  23      -3.927   2.497  -7.168  1.00  0.00           H  
ATOM    291  HB3 LEU A  23      -3.515   4.198  -7.375  1.00  0.00           H  
ATOM    292  HG  LEU A  23      -5.425   2.807  -9.229  1.00  0.00           H  
ATOM    293 HD11 LEU A  23      -5.823   3.274  -6.451  1.00  0.00           H  
ATOM    294 HD12 LEU A  23      -6.964   2.657  -7.645  1.00  0.00           H  
ATOM    295 HD13 LEU A  23      -6.836   4.393  -7.363  1.00  0.00           H  
ATOM    296 HD21 LEU A  23      -4.341   5.075  -9.712  1.00  0.00           H  
ATOM    297 HD22 LEU A  23      -5.356   5.693  -8.409  1.00  0.00           H  
ATOM    298 HD23 LEU A  23      -6.096   4.963  -9.834  1.00  0.00           H  
ATOM    299  N   LEU A  24      -0.973   2.411  -7.286  1.00  0.00           N  
ATOM    300  CA  LEU A  24       0.317   2.586  -6.628  1.00  0.00           C  
ATOM    301  C   LEU A  24       1.463   2.356  -7.607  1.00  0.00           C  
ATOM    302  O   LEU A  24       2.524   2.970  -7.493  1.00  0.00           O  
ATOM    303  CB  LEU A  24       0.441   1.625  -5.444  1.00  0.00           C  
ATOM    304  CG  LEU A  24      -0.243   2.062  -4.149  1.00  0.00           C  
ATOM    305  CD1 LEU A  24      -0.472   0.868  -3.236  1.00  0.00           C  
ATOM    306  CD2 LEU A  24       0.584   3.126  -3.441  1.00  0.00           C  
ATOM    307  H   LEU A  24      -1.566   1.691  -6.990  1.00  0.00           H  
ATOM    308  HA  LEU A  24       0.369   3.601  -6.264  1.00  0.00           H  
ATOM    309  HB2 LEU A  24       0.015   0.678  -5.740  1.00  0.00           H  
ATOM    310  HB3 LEU A  24       1.494   1.494  -5.235  1.00  0.00           H  
ATOM    311  HG  LEU A  24      -1.208   2.490  -4.386  1.00  0.00           H  
ATOM    312 HD11 LEU A  24      -1.053   0.123  -3.758  1.00  0.00           H  
ATOM    313 HD12 LEU A  24      -1.005   1.186  -2.353  1.00  0.00           H  
ATOM    314 HD13 LEU A  24       0.480   0.447  -2.949  1.00  0.00           H  
ATOM    315 HD21 LEU A  24       0.741   2.834  -2.414  1.00  0.00           H  
ATOM    316 HD22 LEU A  24       0.057   4.069  -3.471  1.00  0.00           H  
ATOM    317 HD23 LEU A  24       1.537   3.230  -3.938  1.00  0.00           H  
ATOM    318  N   ASP A  25       1.242   1.469  -8.570  1.00  0.00           N  
ATOM    319  CA  ASP A  25       2.256   1.160  -9.573  1.00  0.00           C  
ATOM    320  C   ASP A  25       2.043   1.990 -10.834  1.00  0.00           C  
ATOM    321  O   ASP A  25       1.121   1.737 -11.609  1.00  0.00           O  
ATOM    322  CB  ASP A  25       2.225  -0.330  -9.917  1.00  0.00           C  
ATOM    323  CG  ASP A  25       3.142  -1.148  -9.028  1.00  0.00           C  
ATOM    324  OD1 ASP A  25       3.212  -0.853  -7.817  1.00  0.00           O  
ATOM    325  OD2 ASP A  25       3.786  -2.085  -9.544  1.00  0.00           O  
ATOM    326  H   ASP A  25       0.376   1.011  -8.610  1.00  0.00           H  
ATOM    327  HA  ASP A  25       3.221   1.404  -9.155  1.00  0.00           H  
ATOM    328  HB2 ASP A  25       1.217  -0.700  -9.801  1.00  0.00           H  
ATOM    329  HB3 ASP A  25       2.537  -0.462 -10.943  1.00  0.00           H  
ATOM    330  N   GLY A  26       2.903   2.984 -11.035  1.00  0.00           N  
ATOM    331  CA  GLY A  26       2.791   3.838 -12.203  1.00  0.00           C  
ATOM    332  C   GLY A  26       3.626   5.097 -12.083  1.00  0.00           C  
ATOM    333  O   GLY A  26       3.879   5.598 -10.987  1.00  0.00           O  
ATOM    334  H   GLY A  26       3.618   3.140 -10.383  1.00  0.00           H  
ATOM    335  HA2 GLY A  26       3.116   3.285 -13.071  1.00  0.00           H  
ATOM    336  HA3 GLY A  26       1.756   4.118 -12.333  1.00  0.00           H  
ATOM    337  N   PRO A  27       4.071   5.630 -13.231  1.00  0.00           N  
ATOM    338  CA  PRO A  27       4.889   6.845 -13.276  1.00  0.00           C  
ATOM    339  C   PRO A  27       4.099   8.090 -12.890  1.00  0.00           C  
ATOM    340  O   PRO A  27       4.664   9.065 -12.394  1.00  0.00           O  
ATOM    341  CB  PRO A  27       5.329   6.922 -14.741  1.00  0.00           C  
ATOM    342  CG  PRO A  27       4.277   6.181 -15.491  1.00  0.00           C  
ATOM    343  CD  PRO A  27       3.807   5.086 -14.574  1.00  0.00           C  
ATOM    344  HA  PRO A  27       5.759   6.761 -12.641  1.00  0.00           H  
ATOM    345  HB2 PRO A  27       5.381   7.956 -15.049  1.00  0.00           H  
ATOM    346  HB3 PRO A  27       6.296   6.457 -14.854  1.00  0.00           H  
ATOM    347  HG2 PRO A  27       3.461   6.845 -15.732  1.00  0.00           H  
ATOM    348  HG3 PRO A  27       4.699   5.759 -16.392  1.00  0.00           H  
ATOM    349  HD2 PRO A  27       2.752   4.902 -14.715  1.00  0.00           H  
ATOM    350  HD3 PRO A  27       4.376   4.183 -14.742  1.00  0.00           H  
ATOM    351  N   GLU A  28       2.790   8.052 -13.123  1.00  0.00           N  
ATOM    352  CA  GLU A  28       1.924   9.179 -12.799  1.00  0.00           C  
ATOM    353  C   GLU A  28       1.546   9.168 -11.321  1.00  0.00           C  
ATOM    354  O   GLU A  28       1.223  10.206 -10.745  1.00  0.00           O  
ATOM    355  CB  GLU A  28       0.660   9.143 -13.661  1.00  0.00           C  
ATOM    356  CG  GLU A  28       0.083  10.518 -13.951  1.00  0.00           C  
ATOM    357  CD  GLU A  28      -0.711  11.075 -12.784  1.00  0.00           C  
ATOM    358  OE1 GLU A  28      -1.748  10.475 -12.432  1.00  0.00           O  
ATOM    359  OE2 GLU A  28      -0.295  12.110 -12.224  1.00  0.00           O  
ATOM    360  H   GLU A  28       2.400   7.246 -13.521  1.00  0.00           H  
ATOM    361  HA  GLU A  28       2.469  10.087 -13.012  1.00  0.00           H  
ATOM    362  HB2 GLU A  28       0.894   8.668 -14.603  1.00  0.00           H  
ATOM    363  HB3 GLU A  28      -0.091   8.559 -13.151  1.00  0.00           H  
ATOM    364  HG2 GLU A  28       0.892  11.196 -14.171  1.00  0.00           H  
ATOM    365  HG3 GLU A  28      -0.570  10.447 -14.809  1.00  0.00           H  
ATOM    366  N   ALA A  29       1.589   7.986 -10.714  1.00  0.00           N  
ATOM    367  CA  ALA A  29       1.252   7.839  -9.304  1.00  0.00           C  
ATOM    368  C   ALA A  29       1.974   8.880  -8.456  1.00  0.00           C  
ATOM    369  O   ALA A  29       3.156   8.730  -8.146  1.00  0.00           O  
ATOM    370  CB  ALA A  29       1.593   6.436  -8.823  1.00  0.00           C  
ATOM    371  H   ALA A  29       1.854   7.196 -11.227  1.00  0.00           H  
ATOM    372  HA  ALA A  29       0.187   7.980  -9.199  1.00  0.00           H  
ATOM    373  HB1 ALA A  29       2.497   6.100  -9.310  1.00  0.00           H  
ATOM    374  HB2 ALA A  29       1.742   6.448  -7.754  1.00  0.00           H  
ATOM    375  HB3 ALA A  29       0.782   5.766  -9.068  1.00  0.00           H  
ATOM    376  N   GLN A  30       1.256   9.935  -8.084  1.00  0.00           N  
ATOM    377  CA  GLN A  30       1.831  11.003  -7.273  1.00  0.00           C  
ATOM    378  C   GLN A  30       2.658  10.430  -6.127  1.00  0.00           C  
ATOM    379  O   GLN A  30       3.547  11.094  -5.597  1.00  0.00           O  
ATOM    380  CB  GLN A  30       0.724  11.903  -6.719  1.00  0.00           C  
ATOM    381  CG  GLN A  30      -0.329  11.150  -5.921  1.00  0.00           C  
ATOM    382  CD  GLN A  30      -1.666  11.865  -5.902  1.00  0.00           C  
ATOM    383  OE1 GLN A  30      -1.737  13.067  -5.647  1.00  0.00           O  
ATOM    384  NE2 GLN A  30      -2.736  11.126  -6.172  1.00  0.00           N  
ATOM    385  H   GLN A  30       0.320   9.998  -8.363  1.00  0.00           H  
ATOM    386  HA  GLN A  30       2.476  11.591  -7.907  1.00  0.00           H  
ATOM    387  HB2 GLN A  30       1.170  12.646  -6.076  1.00  0.00           H  
ATOM    388  HB3 GLN A  30       0.234  12.398  -7.543  1.00  0.00           H  
ATOM    389  HG2 GLN A  30      -0.467  10.174  -6.361  1.00  0.00           H  
ATOM    390  HG3 GLN A  30       0.019  11.041  -4.905  1.00  0.00           H  
ATOM    391 HE21 GLN A  30      -2.603  10.173  -6.364  1.00  0.00           H  
ATOM    392 HE22 GLN A  30      -3.613  11.561  -6.164  1.00  0.00           H  
ATOM    393  N   GLY A  31       2.358   9.190  -5.749  1.00  0.00           N  
ATOM    394  CA  GLY A  31       3.084   8.549  -4.667  1.00  0.00           C  
ATOM    395  C   GLY A  31       3.625   7.188  -5.059  1.00  0.00           C  
ATOM    396  O   GLY A  31       4.115   7.005  -6.173  1.00  0.00           O  
ATOM    397  H   GLY A  31       1.639   8.708  -6.208  1.00  0.00           H  
ATOM    398  HA2 GLY A  31       3.907   9.183  -4.375  1.00  0.00           H  
ATOM    399  HA3 GLY A  31       2.418   8.430  -3.825  1.00  0.00           H  
ATOM    400  N   SER A  32       3.538   6.232  -4.141  1.00  0.00           N  
ATOM    401  CA  SER A  32       4.028   4.882  -4.394  1.00  0.00           C  
ATOM    402  C   SER A  32       3.695   3.955  -3.229  1.00  0.00           C  
ATOM    403  O   SER A  32       3.255   4.405  -2.171  1.00  0.00           O  
ATOM    404  CB  SER A  32       5.540   4.902  -4.628  1.00  0.00           C  
ATOM    405  OG  SER A  32       5.961   3.752  -5.341  1.00  0.00           O  
ATOM    406  H   SER A  32       3.137   6.440  -3.271  1.00  0.00           H  
ATOM    407  HA  SER A  32       3.540   4.514  -5.283  1.00  0.00           H  
ATOM    408  HB2 SER A  32       5.803   5.780  -5.198  1.00  0.00           H  
ATOM    409  HB3 SER A  32       6.050   4.926  -3.675  1.00  0.00           H  
ATOM    410  HG  SER A  32       5.260   3.466  -5.931  1.00  0.00           H  
ATOM    411  N   TRP A  33       3.906   2.660  -3.432  1.00  0.00           N  
ATOM    412  CA  TRP A  33       3.628   1.669  -2.400  1.00  0.00           C  
ATOM    413  C   TRP A  33       4.851   1.444  -1.518  1.00  0.00           C  
ATOM    414  O   TRP A  33       4.731   1.294  -0.302  1.00  0.00           O  
ATOM    415  CB  TRP A  33       3.193   0.348  -3.036  1.00  0.00           C  
ATOM    416  CG  TRP A  33       4.283  -0.323  -3.815  1.00  0.00           C  
ATOM    417  CD1 TRP A  33       4.452  -0.307  -5.170  1.00  0.00           C  
ATOM    418  CD2 TRP A  33       5.354  -1.112  -3.285  1.00  0.00           C  
ATOM    419  NE1 TRP A  33       5.563  -1.038  -5.515  1.00  0.00           N  
ATOM    420  CE2 TRP A  33       6.135  -1.542  -4.377  1.00  0.00           C  
ATOM    421  CE3 TRP A  33       5.731  -1.496  -1.996  1.00  0.00           C  
ATOM    422  CZ2 TRP A  33       7.267  -2.335  -4.215  1.00  0.00           C  
ATOM    423  CZ3 TRP A  33       6.855  -2.285  -1.837  1.00  0.00           C  
ATOM    424  CH2 TRP A  33       7.613  -2.697  -2.940  1.00  0.00           C  
ATOM    425  H   TRP A  33       4.258   2.363  -4.298  1.00  0.00           H  
ATOM    426  HA  TRP A  33       2.822   2.046  -1.788  1.00  0.00           H  
ATOM    427  HB2 TRP A  33       2.872  -0.330  -2.260  1.00  0.00           H  
ATOM    428  HB3 TRP A  33       2.369   0.535  -3.709  1.00  0.00           H  
ATOM    429  HD1 TRP A  33       3.799   0.208  -5.857  1.00  0.00           H  
ATOM    430  HE1 TRP A  33       5.894  -1.174  -6.427  1.00  0.00           H  
ATOM    431  HE3 TRP A  33       5.161  -1.189  -1.132  1.00  0.00           H  
ATOM    432  HZ2 TRP A  33       7.863  -2.660  -5.056  1.00  0.00           H  
ATOM    433  HZ3 TRP A  33       7.161  -2.591  -0.847  1.00  0.00           H  
ATOM    434  HH2 TRP A  33       8.482  -3.311  -2.770  1.00  0.00           H  
ATOM    435  N   ALA A  34       6.027   1.422  -2.137  1.00  0.00           N  
ATOM    436  CA  ALA A  34       7.271   1.218  -1.407  1.00  0.00           C  
ATOM    437  C   ALA A  34       7.336   2.109  -0.171  1.00  0.00           C  
ATOM    438  O   ALA A  34       7.603   1.637   0.933  1.00  0.00           O  
ATOM    439  CB  ALA A  34       8.465   1.482  -2.313  1.00  0.00           C  
ATOM    440  H   ALA A  34       6.057   1.548  -3.108  1.00  0.00           H  
ATOM    441  HA  ALA A  34       7.310   0.185  -1.095  1.00  0.00           H  
ATOM    442  HB1 ALA A  34       9.203   2.059  -1.776  1.00  0.00           H  
ATOM    443  HB2 ALA A  34       8.897   0.542  -2.622  1.00  0.00           H  
ATOM    444  HB3 ALA A  34       8.140   2.033  -3.184  1.00  0.00           H  
ATOM    445  N   GLU A  35       7.091   3.402  -0.367  1.00  0.00           N  
ATOM    446  CA  GLU A  35       7.123   4.359   0.732  1.00  0.00           C  
ATOM    447  C   GLU A  35       5.926   4.165   1.659  1.00  0.00           C  
ATOM    448  O   GLU A  35       6.062   4.191   2.883  1.00  0.00           O  
ATOM    449  CB  GLU A  35       7.137   5.790   0.192  1.00  0.00           C  
ATOM    450  CG  GLU A  35       6.955   6.849   1.267  1.00  0.00           C  
ATOM    451  CD  GLU A  35       8.263   7.242   1.926  1.00  0.00           C  
ATOM    452  OE1 GLU A  35       8.911   6.361   2.529  1.00  0.00           O  
ATOM    453  OE2 GLU A  35       8.637   8.430   1.840  1.00  0.00           O  
ATOM    454  H   GLU A  35       6.885   3.719  -1.271  1.00  0.00           H  
ATOM    455  HA  GLU A  35       8.029   4.188   1.295  1.00  0.00           H  
ATOM    456  HB2 GLU A  35       8.081   5.967  -0.303  1.00  0.00           H  
ATOM    457  HB3 GLU A  35       6.338   5.897  -0.527  1.00  0.00           H  
ATOM    458  HG2 GLU A  35       6.517   7.728   0.818  1.00  0.00           H  
ATOM    459  HG3 GLU A  35       6.288   6.463   2.025  1.00  0.00           H  
ATOM    460  N   LEU A  36       4.754   3.970   1.066  1.00  0.00           N  
ATOM    461  CA  LEU A  36       3.531   3.772   1.837  1.00  0.00           C  
ATOM    462  C   LEU A  36       3.736   2.720   2.922  1.00  0.00           C  
ATOM    463  O   LEU A  36       3.482   2.972   4.100  1.00  0.00           O  
ATOM    464  CB  LEU A  36       2.385   3.352   0.914  1.00  0.00           C  
ATOM    465  CG  LEU A  36       1.197   2.663   1.588  1.00  0.00           C  
ATOM    466  CD1 LEU A  36       0.519   3.607   2.568  1.00  0.00           C  
ATOM    467  CD2 LEU A  36       0.205   2.170   0.546  1.00  0.00           C  
ATOM    468  H   LEU A  36       4.708   3.959   0.088  1.00  0.00           H  
ATOM    469  HA  LEU A  36       3.278   4.711   2.306  1.00  0.00           H  
ATOM    470  HB2 LEU A  36       2.016   4.237   0.420  1.00  0.00           H  
ATOM    471  HB3 LEU A  36       2.788   2.671   0.177  1.00  0.00           H  
ATOM    472  HG  LEU A  36       1.554   1.807   2.144  1.00  0.00           H  
ATOM    473 HD11 LEU A  36       0.909   3.438   3.560  1.00  0.00           H  
ATOM    474 HD12 LEU A  36      -0.546   3.427   2.564  1.00  0.00           H  
ATOM    475 HD13 LEU A  36       0.712   4.630   2.275  1.00  0.00           H  
ATOM    476 HD21 LEU A  36      -0.663   1.761   1.041  1.00  0.00           H  
ATOM    477 HD22 LEU A  36       0.668   1.404  -0.059  1.00  0.00           H  
ATOM    478 HD23 LEU A  36      -0.095   2.994  -0.084  1.00  0.00           H  
ATOM    479  N   ALA A  37       4.198   1.541   2.518  1.00  0.00           N  
ATOM    480  CA  ALA A  37       4.441   0.453   3.456  1.00  0.00           C  
ATOM    481  C   ALA A  37       5.230   0.939   4.668  1.00  0.00           C  
ATOM    482  O   ALA A  37       4.898   0.613   5.808  1.00  0.00           O  
ATOM    483  CB  ALA A  37       5.179  -0.685   2.766  1.00  0.00           C  
ATOM    484  H   ALA A  37       4.380   1.401   1.566  1.00  0.00           H  
ATOM    485  HA  ALA A  37       3.483   0.079   3.791  1.00  0.00           H  
ATOM    486  HB1 ALA A  37       4.963  -1.613   3.275  1.00  0.00           H  
ATOM    487  HB2 ALA A  37       4.854  -0.753   1.738  1.00  0.00           H  
ATOM    488  HB3 ALA A  37       6.241  -0.496   2.797  1.00  0.00           H  
ATOM    489  N   GLU A  38       6.277   1.719   4.413  1.00  0.00           N  
ATOM    490  CA  GLU A  38       7.114   2.248   5.483  1.00  0.00           C  
ATOM    491  C   GLU A  38       6.278   3.040   6.486  1.00  0.00           C  
ATOM    492  O   GLU A  38       6.459   2.913   7.697  1.00  0.00           O  
ATOM    493  CB  GLU A  38       8.216   3.138   4.907  1.00  0.00           C  
ATOM    494  CG  GLU A  38       9.176   2.399   3.989  1.00  0.00           C  
ATOM    495  CD  GLU A  38      10.570   2.995   4.002  1.00  0.00           C  
ATOM    496  OE1 GLU A  38      11.165   3.090   5.096  1.00  0.00           O  
ATOM    497  OE2 GLU A  38      11.067   3.366   2.918  1.00  0.00           O  
ATOM    498  H   GLU A  38       6.490   1.944   3.483  1.00  0.00           H  
ATOM    499  HA  GLU A  38       7.567   1.411   5.993  1.00  0.00           H  
ATOM    500  HB2 GLU A  38       7.759   3.940   4.346  1.00  0.00           H  
ATOM    501  HB3 GLU A  38       8.784   3.560   5.723  1.00  0.00           H  
ATOM    502  HG2 GLU A  38       9.238   1.370   4.307  1.00  0.00           H  
ATOM    503  HG3 GLU A  38       8.792   2.440   2.980  1.00  0.00           H  
ATOM    504  N   ARG A  39       5.364   3.856   5.972  1.00  0.00           N  
ATOM    505  CA  ARG A  39       4.502   4.670   6.821  1.00  0.00           C  
ATOM    506  C   ARG A  39       3.661   3.791   7.742  1.00  0.00           C  
ATOM    507  O   ARG A  39       3.403   4.147   8.893  1.00  0.00           O  
ATOM    508  CB  ARG A  39       3.590   5.549   5.964  1.00  0.00           C  
ATOM    509  CG  ARG A  39       4.335   6.619   5.183  1.00  0.00           C  
ATOM    510  CD  ARG A  39       3.445   7.817   4.889  1.00  0.00           C  
ATOM    511  NE  ARG A  39       4.217   9.044   4.720  1.00  0.00           N  
ATOM    512  CZ  ARG A  39       4.828   9.672   5.718  1.00  0.00           C  
ATOM    513  NH1 ARG A  39       4.758   9.189   6.951  1.00  0.00           N  
ATOM    514  NH2 ARG A  39       5.512  10.784   5.484  1.00  0.00           N  
ATOM    515  H   ARG A  39       5.267   3.913   4.998  1.00  0.00           H  
ATOM    516  HA  ARG A  39       5.134   5.303   7.425  1.00  0.00           H  
ATOM    517  HB2 ARG A  39       3.062   4.923   5.260  1.00  0.00           H  
ATOM    518  HB3 ARG A  39       2.874   6.037   6.607  1.00  0.00           H  
ATOM    519  HG2 ARG A  39       5.185   6.949   5.762  1.00  0.00           H  
ATOM    520  HG3 ARG A  39       4.676   6.197   4.249  1.00  0.00           H  
ATOM    521  HD2 ARG A  39       2.891   7.623   3.983  1.00  0.00           H  
ATOM    522  HD3 ARG A  39       2.756   7.945   5.711  1.00  0.00           H  
ATOM    523  HE  ARG A  39       4.281   9.419   3.817  1.00  0.00           H  
ATOM    524 HH11 ARG A  39       4.244   8.350   7.129  1.00  0.00           H  
ATOM    525 HH12 ARG A  39       5.220   9.663   7.701  1.00  0.00           H  
ATOM    526 HH21 ARG A  39       5.567  11.152   4.556  1.00  0.00           H  
ATOM    527 HH22 ARG A  39       5.971  11.257   6.236  1.00  0.00           H  
ATOM    528  N   LEU A  40       3.235   2.643   7.229  1.00  0.00           N  
ATOM    529  CA  LEU A  40       2.421   1.712   8.004  1.00  0.00           C  
ATOM    530  C   LEU A  40       3.276   0.955   9.016  1.00  0.00           C  
ATOM    531  O   LEU A  40       2.789   0.536  10.066  1.00  0.00           O  
ATOM    532  CB  LEU A  40       1.715   0.725   7.076  1.00  0.00           C  
ATOM    533  CG  LEU A  40       0.931   1.338   5.914  1.00  0.00           C  
ATOM    534  CD1 LEU A  40       0.691   0.303   4.826  1.00  0.00           C  
ATOM    535  CD2 LEU A  40      -0.388   1.915   6.405  1.00  0.00           C  
ATOM    536  H   LEU A  40       3.472   2.413   6.306  1.00  0.00           H  
ATOM    537  HA  LEU A  40       1.679   2.287   8.539  1.00  0.00           H  
ATOM    538  HB2 LEU A  40       2.463   0.068   6.660  1.00  0.00           H  
ATOM    539  HB3 LEU A  40       1.023   0.147   7.673  1.00  0.00           H  
ATOM    540  HG  LEU A  40       1.510   2.144   5.484  1.00  0.00           H  
ATOM    541 HD11 LEU A  40       1.609  -0.230   4.627  1.00  0.00           H  
ATOM    542 HD12 LEU A  40       0.359   0.798   3.925  1.00  0.00           H  
ATOM    543 HD13 LEU A  40      -0.066  -0.393   5.154  1.00  0.00           H  
ATOM    544 HD21 LEU A  40      -0.453   1.800   7.477  1.00  0.00           H  
ATOM    545 HD22 LEU A  40      -1.207   1.389   5.937  1.00  0.00           H  
ATOM    546 HD23 LEU A  40      -0.440   2.963   6.151  1.00  0.00           H  
ATOM    547  N   GLY A  41       4.555   0.783   8.693  1.00  0.00           N  
ATOM    548  CA  GLY A  41       5.457   0.077   9.583  1.00  0.00           C  
ATOM    549  C   GLY A  41       5.902  -1.257   9.020  1.00  0.00           C  
ATOM    550  O   GLY A  41       6.634  -2.002   9.672  1.00  0.00           O  
ATOM    551  H   GLY A  41       4.887   1.138   7.842  1.00  0.00           H  
ATOM    552  HA2 GLY A  41       6.327   0.693   9.757  1.00  0.00           H  
ATOM    553  HA3 GLY A  41       4.955  -0.092  10.524  1.00  0.00           H  
ATOM    554  N   LEU A  42       5.461  -1.560   7.804  1.00  0.00           N  
ATOM    555  CA  LEU A  42       5.819  -2.816   7.152  1.00  0.00           C  
ATOM    556  C   LEU A  42       7.025  -2.632   6.238  1.00  0.00           C  
ATOM    557  O   LEU A  42       7.105  -3.235   5.168  1.00  0.00           O  
ATOM    558  CB  LEU A  42       4.633  -3.351   6.348  1.00  0.00           C  
ATOM    559  CG  LEU A  42       3.257  -3.200   6.999  1.00  0.00           C  
ATOM    560  CD1 LEU A  42       2.168  -3.150   5.940  1.00  0.00           C  
ATOM    561  CD2 LEU A  42       3.001  -4.339   7.976  1.00  0.00           C  
ATOM    562  H   LEU A  42       4.881  -0.927   7.333  1.00  0.00           H  
ATOM    563  HA  LEU A  42       6.071  -3.529   7.923  1.00  0.00           H  
ATOM    564  HB2 LEU A  42       4.609  -2.828   5.404  1.00  0.00           H  
ATOM    565  HB3 LEU A  42       4.802  -4.403   6.170  1.00  0.00           H  
ATOM    566  HG  LEU A  42       3.227  -2.272   7.552  1.00  0.00           H  
ATOM    567 HD11 LEU A  42       2.614  -3.223   4.960  1.00  0.00           H  
ATOM    568 HD12 LEU A  42       1.629  -2.217   6.021  1.00  0.00           H  
ATOM    569 HD13 LEU A  42       1.483  -3.973   6.087  1.00  0.00           H  
ATOM    570 HD21 LEU A  42       2.797  -5.246   7.425  1.00  0.00           H  
ATOM    571 HD22 LEU A  42       2.153  -4.097   8.597  1.00  0.00           H  
ATOM    572 HD23 LEU A  42       3.874  -4.484   8.596  1.00  0.00           H  
ATOM    573  N   ARG A  43       7.964  -1.794   6.668  1.00  0.00           N  
ATOM    574  CA  ARG A  43       9.167  -1.530   5.889  1.00  0.00           C  
ATOM    575  C   ARG A  43      10.051  -2.773   5.817  1.00  0.00           C  
ATOM    576  O   ARG A  43      10.671  -3.047   4.789  1.00  0.00           O  
ATOM    577  CB  ARG A  43       9.952  -0.368   6.500  1.00  0.00           C  
ATOM    578  CG  ARG A  43      10.417  -0.629   7.923  1.00  0.00           C  
ATOM    579  CD  ARG A  43      10.718   0.669   8.657  1.00  0.00           C  
ATOM    580  NE  ARG A  43      10.905   0.456  10.090  1.00  0.00           N  
ATOM    581  CZ  ARG A  43      11.302   1.407  10.928  1.00  0.00           C  
ATOM    582  NH1 ARG A  43      11.554   2.629  10.479  1.00  0.00           N  
ATOM    583  NH2 ARG A  43      11.449   1.136  12.219  1.00  0.00           N  
ATOM    584  H   ARG A  43       7.844  -1.342   7.529  1.00  0.00           H  
ATOM    585  HA  ARG A  43       8.863  -1.261   4.888  1.00  0.00           H  
ATOM    586  HB2 ARG A  43      10.822  -0.176   5.890  1.00  0.00           H  
ATOM    587  HB3 ARG A  43       9.324   0.510   6.505  1.00  0.00           H  
ATOM    588  HG2 ARG A  43       9.641  -1.158   8.455  1.00  0.00           H  
ATOM    589  HG3 ARG A  43      11.312  -1.232   7.895  1.00  0.00           H  
ATOM    590  HD2 ARG A  43      11.619   1.099   8.247  1.00  0.00           H  
ATOM    591  HD3 ARG A  43       9.894   1.350   8.508  1.00  0.00           H  
ATOM    592  HE  ARG A  43      10.724  -0.439  10.444  1.00  0.00           H  
ATOM    593 HH11 ARG A  43      11.443   2.836   9.507  1.00  0.00           H  
ATOM    594 HH12 ARG A  43      11.853   3.343  11.113  1.00  0.00           H  
ATOM    595 HH21 ARG A  43      11.261   0.216  12.561  1.00  0.00           H  
ATOM    596 HH22 ARG A  43      11.748   1.852  12.849  1.00  0.00           H  
ATOM    597  N   SER A  44      10.104  -3.519   6.915  1.00  0.00           N  
ATOM    598  CA  SER A  44      10.915  -4.729   6.978  1.00  0.00           C  
ATOM    599  C   SER A  44      10.368  -5.799   6.038  1.00  0.00           C  
ATOM    600  O   SER A  44      10.977  -6.854   5.857  1.00  0.00           O  
ATOM    601  CB  SER A  44      10.958  -5.265   8.410  1.00  0.00           C  
ATOM    602  OG  SER A  44      12.076  -6.116   8.603  1.00  0.00           O  
ATOM    603  H   SER A  44       9.587  -3.247   7.703  1.00  0.00           H  
ATOM    604  HA  SER A  44      11.917  -4.473   6.669  1.00  0.00           H  
ATOM    605  HB2 SER A  44      11.027  -4.438   9.100  1.00  0.00           H  
ATOM    606  HB3 SER A  44      10.056  -5.826   8.609  1.00  0.00           H  
ATOM    607  HG  SER A  44      12.600  -5.792   9.339  1.00  0.00           H  
ATOM    608  N   LEU A  45       9.214  -5.520   5.441  1.00  0.00           N  
ATOM    609  CA  LEU A  45       8.583  -6.458   4.519  1.00  0.00           C  
ATOM    610  C   LEU A  45       8.661  -5.947   3.085  1.00  0.00           C  
ATOM    611  O   LEU A  45       8.458  -6.701   2.133  1.00  0.00           O  
ATOM    612  CB  LEU A  45       7.123  -6.685   4.914  1.00  0.00           C  
ATOM    613  CG  LEU A  45       6.886  -7.274   6.305  1.00  0.00           C  
ATOM    614  CD1 LEU A  45       5.434  -7.095   6.721  1.00  0.00           C  
ATOM    615  CD2 LEU A  45       7.276  -8.744   6.336  1.00  0.00           C  
ATOM    616  H   LEU A  45       8.776  -4.663   5.625  1.00  0.00           H  
ATOM    617  HA  LEU A  45       9.115  -7.395   4.585  1.00  0.00           H  
ATOM    618  HB2 LEU A  45       6.615  -5.735   4.866  1.00  0.00           H  
ATOM    619  HB3 LEU A  45       6.688  -7.361   4.191  1.00  0.00           H  
ATOM    620  HG  LEU A  45       7.504  -6.748   7.020  1.00  0.00           H  
ATOM    621 HD11 LEU A  45       4.848  -6.799   5.864  1.00  0.00           H  
ATOM    622 HD12 LEU A  45       5.368  -6.333   7.482  1.00  0.00           H  
ATOM    623 HD13 LEU A  45       5.054  -8.028   7.112  1.00  0.00           H  
ATOM    624 HD21 LEU A  45       6.654  -9.266   7.049  1.00  0.00           H  
ATOM    625 HD22 LEU A  45       8.312  -8.836   6.628  1.00  0.00           H  
ATOM    626 HD23 LEU A  45       7.137  -9.174   5.356  1.00  0.00           H  
ATOM    627  N   VAL A  46       8.958  -4.659   2.936  1.00  0.00           N  
ATOM    628  CA  VAL A  46       9.067  -4.047   1.617  1.00  0.00           C  
ATOM    629  C   VAL A  46       9.949  -4.882   0.695  1.00  0.00           C  
ATOM    630  O   VAL A  46       9.710  -4.955  -0.511  1.00  0.00           O  
ATOM    631  CB  VAL A  46       9.641  -2.620   1.706  1.00  0.00           C  
ATOM    632  CG1 VAL A  46      10.084  -2.136   0.334  1.00  0.00           C  
ATOM    633  CG2 VAL A  46       8.617  -1.672   2.311  1.00  0.00           C  
ATOM    634  H   VAL A  46       9.109  -4.109   3.732  1.00  0.00           H  
ATOM    635  HA  VAL A  46       8.075  -3.988   1.193  1.00  0.00           H  
ATOM    636  HB  VAL A  46      10.506  -2.642   2.352  1.00  0.00           H  
ATOM    637 HG11 VAL A  46      10.880  -2.768  -0.031  1.00  0.00           H  
ATOM    638 HG12 VAL A  46       9.248  -2.178  -0.350  1.00  0.00           H  
ATOM    639 HG13 VAL A  46      10.438  -1.119   0.409  1.00  0.00           H  
ATOM    640 HG21 VAL A  46       9.111  -0.767   2.632  1.00  0.00           H  
ATOM    641 HG22 VAL A  46       7.868  -1.430   1.570  1.00  0.00           H  
ATOM    642 HG23 VAL A  46       8.144  -2.144   3.158  1.00  0.00           H  
ATOM    643  N   ASP A  47      10.969  -5.509   1.270  1.00  0.00           N  
ATOM    644  CA  ASP A  47      11.887  -6.340   0.500  1.00  0.00           C  
ATOM    645  C   ASP A  47      11.229  -7.661   0.112  1.00  0.00           C  
ATOM    646  O   ASP A  47      11.225  -8.046  -1.058  1.00  0.00           O  
ATOM    647  CB  ASP A  47      13.162  -6.608   1.302  1.00  0.00           C  
ATOM    648  CG  ASP A  47      12.910  -6.636   2.797  1.00  0.00           C  
ATOM    649  OD1 ASP A  47      12.935  -5.557   3.423  1.00  0.00           O  
ATOM    650  OD2 ASP A  47      12.688  -7.739   3.340  1.00  0.00           O  
ATOM    651  H   ASP A  47      11.108  -5.411   2.235  1.00  0.00           H  
ATOM    652  HA  ASP A  47      12.145  -5.803  -0.400  1.00  0.00           H  
ATOM    653  HB2 ASP A  47      13.572  -7.562   1.006  1.00  0.00           H  
ATOM    654  HB3 ASP A  47      13.882  -5.830   1.091  1.00  0.00           H  
ATOM    655  N   THR A  48      10.674  -8.354   1.102  1.00  0.00           N  
ATOM    656  CA  THR A  48      10.016  -9.632   0.865  1.00  0.00           C  
ATOM    657  C   THR A  48       8.918  -9.499  -0.183  1.00  0.00           C  
ATOM    658  O   THR A  48       8.566 -10.469  -0.855  1.00  0.00           O  
ATOM    659  CB  THR A  48       9.408 -10.199   2.162  1.00  0.00           C  
ATOM    660  OG1 THR A  48      10.367 -10.134   3.223  1.00  0.00           O  
ATOM    661  CG2 THR A  48       8.958 -11.638   1.964  1.00  0.00           C  
ATOM    662  H   THR A  48      10.711  -7.995   2.014  1.00  0.00           H  
ATOM    663  HA  THR A  48      10.759 -10.329   0.507  1.00  0.00           H  
ATOM    664  HB  THR A  48       8.546  -9.602   2.429  1.00  0.00           H  
ATOM    665  HG1 THR A  48      10.292  -9.288   3.671  1.00  0.00           H  
ATOM    666 HG21 THR A  48       9.636 -12.137   1.288  1.00  0.00           H  
ATOM    667 HG22 THR A  48       7.961 -11.652   1.550  1.00  0.00           H  
ATOM    668 HG23 THR A  48       8.959 -12.149   2.915  1.00  0.00           H  
ATOM    669  N   TYR A  49       8.379  -8.293  -0.318  1.00  0.00           N  
ATOM    670  CA  TYR A  49       7.317  -8.033  -1.283  1.00  0.00           C  
ATOM    671  C   TYR A  49       7.890  -7.847  -2.685  1.00  0.00           C  
ATOM    672  O   TYR A  49       7.576  -8.606  -3.602  1.00  0.00           O  
ATOM    673  CB  TYR A  49       6.521  -6.791  -0.877  1.00  0.00           C  
ATOM    674  CG  TYR A  49       5.771  -6.953   0.426  1.00  0.00           C  
ATOM    675  CD1 TYR A  49       5.113  -8.138   0.728  1.00  0.00           C  
ATOM    676  CD2 TYR A  49       5.722  -5.919   1.354  1.00  0.00           C  
ATOM    677  CE1 TYR A  49       4.427  -8.289   1.917  1.00  0.00           C  
ATOM    678  CE2 TYR A  49       5.039  -6.063   2.546  1.00  0.00           C  
ATOM    679  CZ  TYR A  49       4.393  -7.250   2.823  1.00  0.00           C  
ATOM    680  OH  TYR A  49       3.710  -7.395   4.009  1.00  0.00           O  
ATOM    681  H   TYR A  49       8.700  -7.559   0.247  1.00  0.00           H  
ATOM    682  HA  TYR A  49       6.657  -8.887  -1.287  1.00  0.00           H  
ATOM    683  HB2 TYR A  49       7.198  -5.958  -0.769  1.00  0.00           H  
ATOM    684  HB3 TYR A  49       5.801  -6.566  -1.649  1.00  0.00           H  
ATOM    685  HD1 TYR A  49       5.141  -8.951   0.017  1.00  0.00           H  
ATOM    686  HD2 TYR A  49       6.229  -4.991   1.134  1.00  0.00           H  
ATOM    687  HE1 TYR A  49       3.920  -9.219   2.135  1.00  0.00           H  
ATOM    688  HE2 TYR A  49       5.011  -5.249   3.255  1.00  0.00           H  
ATOM    689  HH  TYR A  49       3.055  -6.697   4.089  1.00  0.00           H  
ATOM    690  N   ARG A  50       8.734  -6.831  -2.843  1.00  0.00           N  
ATOM    691  CA  ARG A  50       9.351  -6.545  -4.132  1.00  0.00           C  
ATOM    692  C   ARG A  50       9.906  -7.817  -4.765  1.00  0.00           C  
ATOM    693  O   ARG A  50      10.072  -7.895  -5.982  1.00  0.00           O  
ATOM    694  CB  ARG A  50      10.470  -5.515  -3.967  1.00  0.00           C  
ATOM    695  CG  ARG A  50      11.745  -6.090  -3.373  1.00  0.00           C  
ATOM    696  CD  ARG A  50      12.950  -5.216  -3.683  1.00  0.00           C  
ATOM    697  NE  ARG A  50      13.573  -5.575  -4.955  1.00  0.00           N  
ATOM    698  CZ  ARG A  50      14.671  -4.994  -5.423  1.00  0.00           C  
ATOM    699  NH1 ARG A  50      15.266  -4.033  -4.730  1.00  0.00           N  
ATOM    700  NH2 ARG A  50      15.179  -5.376  -6.589  1.00  0.00           N  
ATOM    701  H   ARG A  50       8.945  -6.262  -2.075  1.00  0.00           H  
ATOM    702  HA  ARG A  50       8.591  -6.136  -4.780  1.00  0.00           H  
ATOM    703  HB2 ARG A  50      10.708  -5.099  -4.936  1.00  0.00           H  
ATOM    704  HB3 ARG A  50      10.122  -4.724  -3.320  1.00  0.00           H  
ATOM    705  HG2 ARG A  50      11.632  -6.160  -2.301  1.00  0.00           H  
ATOM    706  HG3 ARG A  50      11.910  -7.076  -3.784  1.00  0.00           H  
ATOM    707  HD2 ARG A  50      12.628  -4.186  -3.730  1.00  0.00           H  
ATOM    708  HD3 ARG A  50      13.675  -5.331  -2.892  1.00  0.00           H  
ATOM    709  HE  ARG A  50      13.151  -6.283  -5.483  1.00  0.00           H  
ATOM    710 HH11 ARG A  50      14.886  -3.744  -3.851  1.00  0.00           H  
ATOM    711 HH12 ARG A  50      16.093  -3.598  -5.086  1.00  0.00           H  
ATOM    712 HH21 ARG A  50      14.734  -6.100  -7.115  1.00  0.00           H  
ATOM    713 HH22 ARG A  50      16.006  -4.938  -6.942  1.00  0.00           H  
ATOM    714  N   GLN A  51      10.190  -8.812  -3.930  1.00  0.00           N  
ATOM    715  CA  GLN A  51      10.727 -10.081  -4.408  1.00  0.00           C  
ATOM    716  C   GLN A  51       9.751 -10.759  -5.365  1.00  0.00           C  
ATOM    717  O   GLN A  51      10.149 -11.289  -6.402  1.00  0.00           O  
ATOM    718  CB  GLN A  51      11.032 -11.006  -3.230  1.00  0.00           C  
ATOM    719  CG  GLN A  51      12.336 -10.679  -2.521  1.00  0.00           C  
ATOM    720  CD  GLN A  51      13.553 -10.933  -3.390  1.00  0.00           C  
ATOM    721  OE1 GLN A  51      13.439 -11.448  -4.502  1.00  0.00           O  
ATOM    722  NE2 GLN A  51      14.727 -10.572  -2.886  1.00  0.00           N  
ATOM    723  H   GLN A  51      10.036  -8.690  -2.970  1.00  0.00           H  
ATOM    724  HA  GLN A  51      11.645  -9.873  -4.938  1.00  0.00           H  
ATOM    725  HB2 GLN A  51      10.229 -10.932  -2.512  1.00  0.00           H  
ATOM    726  HB3 GLN A  51      11.089 -12.022  -3.591  1.00  0.00           H  
ATOM    727  HG2 GLN A  51      12.327  -9.637  -2.239  1.00  0.00           H  
ATOM    728  HG3 GLN A  51      12.412 -11.291  -1.634  1.00  0.00           H  
ATOM    729 HE21 GLN A  51      14.742 -10.168  -1.992  1.00  0.00           H  
ATOM    730 HE22 GLN A  51      15.529 -10.725  -3.426  1.00  0.00           H  
ATOM    731  N   THR A  52       8.471 -10.739  -5.007  1.00  0.00           N  
ATOM    732  CA  THR A  52       7.438 -11.354  -5.831  1.00  0.00           C  
ATOM    733  C   THR A  52       7.172 -10.528  -7.084  1.00  0.00           C  
ATOM    734  O   THR A  52       7.813  -9.502  -7.314  1.00  0.00           O  
ATOM    735  CB  THR A  52       6.120 -11.520  -5.050  1.00  0.00           C  
ATOM    736  OG1 THR A  52       5.442 -10.262  -4.961  1.00  0.00           O  
ATOM    737  CG2 THR A  52       6.385 -12.061  -3.653  1.00  0.00           C  
ATOM    738  H   THR A  52       8.216 -10.302  -4.168  1.00  0.00           H  
ATOM    739  HA  THR A  52       7.785 -12.334  -6.124  1.00  0.00           H  
ATOM    740  HB  THR A  52       5.493 -12.223  -5.580  1.00  0.00           H  
ATOM    741  HG1 THR A  52       5.868  -9.715  -4.297  1.00  0.00           H  
ATOM    742 HG21 THR A  52       7.449 -12.157  -3.500  1.00  0.00           H  
ATOM    743 HG22 THR A  52       5.915 -13.026  -3.546  1.00  0.00           H  
ATOM    744 HG23 THR A  52       5.977 -11.379  -2.921  1.00  0.00           H  
ATOM    745  N   THR A  53       6.220 -10.981  -7.895  1.00  0.00           N  
ATOM    746  CA  THR A  53       5.869 -10.284  -9.126  1.00  0.00           C  
ATOM    747  C   THR A  53       4.722  -9.306  -8.896  1.00  0.00           C  
ATOM    748  O   THR A  53       4.680  -8.233  -9.497  1.00  0.00           O  
ATOM    749  CB  THR A  53       5.470 -11.273 -10.237  1.00  0.00           C  
ATOM    750  OG1 THR A  53       4.944 -10.561 -11.362  1.00  0.00           O  
ATOM    751  CG2 THR A  53       4.436 -12.267  -9.731  1.00  0.00           C  
ATOM    752  H   THR A  53       5.744 -11.804  -7.658  1.00  0.00           H  
ATOM    753  HA  THR A  53       6.738  -9.735  -9.458  1.00  0.00           H  
ATOM    754  HB  THR A  53       6.351 -11.818 -10.547  1.00  0.00           H  
ATOM    755  HG1 THR A  53       4.362 -11.138 -11.864  1.00  0.00           H  
ATOM    756 HG21 THR A  53       4.081 -12.869 -10.556  1.00  0.00           H  
ATOM    757 HG22 THR A  53       3.607 -11.732  -9.293  1.00  0.00           H  
ATOM    758 HG23 THR A  53       4.886 -12.907  -8.987  1.00  0.00           H  
ATOM    759  N   SER A  54       3.794  -9.685  -8.022  1.00  0.00           N  
ATOM    760  CA  SER A  54       2.645  -8.841  -7.716  1.00  0.00           C  
ATOM    761  C   SER A  54       2.623  -8.470  -6.236  1.00  0.00           C  
ATOM    762  O   SER A  54       1.791  -8.946  -5.464  1.00  0.00           O  
ATOM    763  CB  SER A  54       1.346  -9.556  -8.094  1.00  0.00           C  
ATOM    764  OG  SER A  54       1.199  -9.638  -9.501  1.00  0.00           O  
ATOM    765  H   SER A  54       3.884 -10.552  -7.577  1.00  0.00           H  
ATOM    766  HA  SER A  54       2.732  -7.937  -8.301  1.00  0.00           H  
ATOM    767  HB2 SER A  54       1.357 -10.555  -7.686  1.00  0.00           H  
ATOM    768  HB3 SER A  54       0.507  -9.010  -7.687  1.00  0.00           H  
ATOM    769  HG  SER A  54       2.065  -9.695  -9.911  1.00  0.00           H  
ATOM    770  N   PRO A  55       3.559  -7.599  -5.833  1.00  0.00           N  
ATOM    771  CA  PRO A  55       3.669  -7.142  -4.443  1.00  0.00           C  
ATOM    772  C   PRO A  55       2.511  -6.237  -4.037  1.00  0.00           C  
ATOM    773  O   PRO A  55       2.091  -6.232  -2.880  1.00  0.00           O  
ATOM    774  CB  PRO A  55       4.987  -6.364  -4.429  1.00  0.00           C  
ATOM    775  CG  PRO A  55       5.176  -5.913  -5.836  1.00  0.00           C  
ATOM    776  CD  PRO A  55       4.582  -6.991  -6.700  1.00  0.00           C  
ATOM    777  HA  PRO A  55       3.732  -7.974  -3.757  1.00  0.00           H  
ATOM    778  HB2 PRO A  55       4.905  -5.525  -3.752  1.00  0.00           H  
ATOM    779  HB3 PRO A  55       5.789  -7.014  -4.111  1.00  0.00           H  
ATOM    780  HG2 PRO A  55       4.660  -4.979  -5.995  1.00  0.00           H  
ATOM    781  HG3 PRO A  55       6.229  -5.801  -6.047  1.00  0.00           H  
ATOM    782  HD2 PRO A  55       4.134  -6.562  -7.584  1.00  0.00           H  
ATOM    783  HD3 PRO A  55       5.336  -7.715  -6.971  1.00  0.00           H  
ATOM    784  N   SER A  56       2.000  -5.472  -4.996  1.00  0.00           N  
ATOM    785  CA  SER A  56       0.892  -4.559  -4.737  1.00  0.00           C  
ATOM    786  C   SER A  56      -0.186  -5.239  -3.897  1.00  0.00           C  
ATOM    787  O   SER A  56      -0.484  -4.807  -2.784  1.00  0.00           O  
ATOM    788  CB  SER A  56       0.291  -4.065  -6.054  1.00  0.00           C  
ATOM    789  OG  SER A  56       1.112  -3.076  -6.649  1.00  0.00           O  
ATOM    790  H   SER A  56       2.379  -5.520  -5.899  1.00  0.00           H  
ATOM    791  HA  SER A  56       1.281  -3.714  -4.188  1.00  0.00           H  
ATOM    792  HB2 SER A  56       0.197  -4.896  -6.737  1.00  0.00           H  
ATOM    793  HB3 SER A  56      -0.684  -3.642  -5.865  1.00  0.00           H  
ATOM    794  HG  SER A  56       1.889  -3.492  -7.032  1.00  0.00           H  
ATOM    795  N   GLY A  57      -0.765  -6.305  -4.438  1.00  0.00           N  
ATOM    796  CA  GLY A  57      -1.803  -7.028  -3.727  1.00  0.00           C  
ATOM    797  C   GLY A  57      -1.294  -7.664  -2.449  1.00  0.00           C  
ATOM    798  O   GLY A  57      -1.927  -7.556  -1.398  1.00  0.00           O  
ATOM    799  H   GLY A  57      -0.486  -6.604  -5.329  1.00  0.00           H  
ATOM    800  HA2 GLY A  57      -2.601  -6.342  -3.481  1.00  0.00           H  
ATOM    801  HA3 GLY A  57      -2.194  -7.802  -4.371  1.00  0.00           H  
ATOM    802  N   SER A  58      -0.148  -8.332  -2.538  1.00  0.00           N  
ATOM    803  CA  SER A  58       0.443  -8.995  -1.381  1.00  0.00           C  
ATOM    804  C   SER A  58       0.809  -7.980  -0.303  1.00  0.00           C  
ATOM    805  O   SER A  58       1.123  -8.346   0.831  1.00  0.00           O  
ATOM    806  CB  SER A  58       1.685  -9.784  -1.798  1.00  0.00           C  
ATOM    807  OG  SER A  58       1.328 -11.001  -2.430  1.00  0.00           O  
ATOM    808  H   SER A  58       0.308  -8.384  -3.404  1.00  0.00           H  
ATOM    809  HA  SER A  58      -0.290  -9.679  -0.980  1.00  0.00           H  
ATOM    810  HB2 SER A  58       2.269  -9.193  -2.487  1.00  0.00           H  
ATOM    811  HB3 SER A  58       2.278 -10.006  -0.923  1.00  0.00           H  
ATOM    812  HG  SER A  58       1.642 -11.739  -1.904  1.00  0.00           H  
ATOM    813  N   LEU A  59       0.767  -6.701  -0.664  1.00  0.00           N  
ATOM    814  CA  LEU A  59       1.095  -5.631   0.272  1.00  0.00           C  
ATOM    815  C   LEU A  59      -0.120  -5.252   1.113  1.00  0.00           C  
ATOM    816  O   LEU A  59      -0.025  -5.114   2.333  1.00  0.00           O  
ATOM    817  CB  LEU A  59       1.609  -4.405  -0.485  1.00  0.00           C  
ATOM    818  CG  LEU A  59       1.992  -3.198   0.373  1.00  0.00           C  
ATOM    819  CD1 LEU A  59       3.224  -3.510   1.209  1.00  0.00           C  
ATOM    820  CD2 LEU A  59       2.234  -1.978  -0.502  1.00  0.00           C  
ATOM    821  H   LEU A  59       0.510  -6.471  -1.580  1.00  0.00           H  
ATOM    822  HA  LEU A  59       1.873  -5.991   0.928  1.00  0.00           H  
ATOM    823  HB2 LEU A  59       2.481  -4.704  -1.044  1.00  0.00           H  
ATOM    824  HB3 LEU A  59       0.833  -4.092  -1.170  1.00  0.00           H  
ATOM    825  HG  LEU A  59       1.179  -2.972   1.048  1.00  0.00           H  
ATOM    826 HD11 LEU A  59       3.190  -4.539   1.531  1.00  0.00           H  
ATOM    827 HD12 LEU A  59       3.243  -2.863   2.075  1.00  0.00           H  
ATOM    828 HD13 LEU A  59       4.112  -3.345   0.617  1.00  0.00           H  
ATOM    829 HD21 LEU A  59       1.388  -1.833  -1.159  1.00  0.00           H  
ATOM    830 HD22 LEU A  59       3.126  -2.128  -1.092  1.00  0.00           H  
ATOM    831 HD23 LEU A  59       2.357  -1.106   0.123  1.00  0.00           H  
ATOM    832  N   LEU A  60      -1.261  -5.087   0.453  1.00  0.00           N  
ATOM    833  CA  LEU A  60      -2.497  -4.727   1.140  1.00  0.00           C  
ATOM    834  C   LEU A  60      -2.989  -5.876   2.013  1.00  0.00           C  
ATOM    835  O   LEU A  60      -3.091  -5.741   3.233  1.00  0.00           O  
ATOM    836  CB  LEU A  60      -3.576  -4.345   0.124  1.00  0.00           C  
ATOM    837  CG  LEU A  60      -3.311  -3.079  -0.692  1.00  0.00           C  
ATOM    838  CD1 LEU A  60      -4.097  -3.109  -1.994  1.00  0.00           C  
ATOM    839  CD2 LEU A  60      -3.663  -1.840   0.118  1.00  0.00           C  
ATOM    840  H   LEU A  60      -1.275  -5.212  -0.519  1.00  0.00           H  
ATOM    841  HA  LEU A  60      -2.289  -3.875   1.769  1.00  0.00           H  
ATOM    842  HB2 LEU A  60      -3.684  -5.166  -0.567  1.00  0.00           H  
ATOM    843  HB3 LEU A  60      -4.502  -4.204   0.663  1.00  0.00           H  
ATOM    844  HG  LEU A  60      -2.259  -3.030  -0.939  1.00  0.00           H  
ATOM    845 HD11 LEU A  60      -5.147  -3.230  -1.777  1.00  0.00           H  
ATOM    846 HD12 LEU A  60      -3.756  -3.934  -2.601  1.00  0.00           H  
ATOM    847 HD13 LEU A  60      -3.943  -2.182  -2.528  1.00  0.00           H  
ATOM    848 HD21 LEU A  60      -2.816  -1.554   0.725  1.00  0.00           H  
ATOM    849 HD22 LEU A  60      -4.507  -2.055   0.756  1.00  0.00           H  
ATOM    850 HD23 LEU A  60      -3.914  -1.031  -0.553  1.00  0.00           H  
ATOM    851  N   ARG A  61      -3.293  -7.005   1.382  1.00  0.00           N  
ATOM    852  CA  ARG A  61      -3.773  -8.178   2.102  1.00  0.00           C  
ATOM    853  C   ARG A  61      -2.926  -8.438   3.345  1.00  0.00           C  
ATOM    854  O   ARG A  61      -3.396  -9.032   4.314  1.00  0.00           O  
ATOM    855  CB  ARG A  61      -3.752  -9.407   1.191  1.00  0.00           C  
ATOM    856  CG  ARG A  61      -2.351  -9.860   0.813  1.00  0.00           C  
ATOM    857  CD  ARG A  61      -2.316 -11.344   0.483  1.00  0.00           C  
ATOM    858  NE  ARG A  61      -2.048 -12.161   1.663  1.00  0.00           N  
ATOM    859  CZ  ARG A  61      -0.832 -12.359   2.160  1.00  0.00           C  
ATOM    860  NH1 ARG A  61       0.222 -11.801   1.581  1.00  0.00           N  
ATOM    861  NH2 ARG A  61      -0.669 -13.115   3.238  1.00  0.00           N  
ATOM    862  H   ARG A  61      -3.191  -7.051   0.408  1.00  0.00           H  
ATOM    863  HA  ARG A  61      -4.791  -7.986   2.408  1.00  0.00           H  
ATOM    864  HB2 ARG A  61      -4.246 -10.223   1.695  1.00  0.00           H  
ATOM    865  HB3 ARG A  61      -4.289  -9.176   0.283  1.00  0.00           H  
ATOM    866  HG2 ARG A  61      -2.023  -9.303  -0.052  1.00  0.00           H  
ATOM    867  HG3 ARG A  61      -1.685  -9.668   1.641  1.00  0.00           H  
ATOM    868  HD2 ARG A  61      -3.271 -11.630   0.068  1.00  0.00           H  
ATOM    869  HD3 ARG A  61      -1.541 -11.519  -0.248  1.00  0.00           H  
ATOM    870  HE  ARG A  61      -2.814 -12.583   2.107  1.00  0.00           H  
ATOM    871 HH11 ARG A  61       0.103 -11.230   0.770  1.00  0.00           H  
ATOM    872 HH12 ARG A  61       1.137 -11.950   1.958  1.00  0.00           H  
ATOM    873 HH21 ARG A  61      -1.461 -13.538   3.676  1.00  0.00           H  
ATOM    874 HH22 ARG A  61       0.246 -13.264   3.610  1.00  0.00           H  
ATOM    875  N   SER A  62      -1.676  -7.989   3.307  1.00  0.00           N  
ATOM    876  CA  SER A  62      -0.762  -8.176   4.428  1.00  0.00           C  
ATOM    877  C   SER A  62      -0.881  -7.029   5.424  1.00  0.00           C  
ATOM    878  O   SER A  62      -0.636  -7.199   6.618  1.00  0.00           O  
ATOM    879  CB  SER A  62       0.679  -8.283   3.926  1.00  0.00           C  
ATOM    880  OG  SER A  62       0.866  -9.460   3.159  1.00  0.00           O  
ATOM    881  H   SER A  62      -1.360  -7.523   2.505  1.00  0.00           H  
ATOM    882  HA  SER A  62      -1.031  -9.098   4.923  1.00  0.00           H  
ATOM    883  HB2 SER A  62       0.908  -7.427   3.311  1.00  0.00           H  
ATOM    884  HB3 SER A  62       1.351  -8.309   4.772  1.00  0.00           H  
ATOM    885  HG  SER A  62       0.528 -10.216   3.644  1.00  0.00           H  
ATOM    886  N   TYR A  63      -1.260  -5.856   4.925  1.00  0.00           N  
ATOM    887  CA  TYR A  63      -1.410  -4.677   5.769  1.00  0.00           C  
ATOM    888  C   TYR A  63      -2.433  -4.926   6.873  1.00  0.00           C  
ATOM    889  O   TYR A  63      -2.332  -4.365   7.965  1.00  0.00           O  
ATOM    890  CB  TYR A  63      -1.832  -3.472   4.928  1.00  0.00           C  
ATOM    891  CG  TYR A  63      -2.377  -2.324   5.747  1.00  0.00           C  
ATOM    892  CD1 TYR A  63      -1.559  -1.618   6.620  1.00  0.00           C  
ATOM    893  CD2 TYR A  63      -3.709  -1.945   5.647  1.00  0.00           C  
ATOM    894  CE1 TYR A  63      -2.053  -0.568   7.370  1.00  0.00           C  
ATOM    895  CE2 TYR A  63      -4.212  -0.896   6.394  1.00  0.00           C  
ATOM    896  CZ  TYR A  63      -3.379  -0.211   7.254  1.00  0.00           C  
ATOM    897  OH  TYR A  63      -3.876   0.834   7.998  1.00  0.00           O  
ATOM    898  H   TYR A  63      -1.441  -5.782   3.965  1.00  0.00           H  
ATOM    899  HA  TYR A  63      -0.451  -4.471   6.222  1.00  0.00           H  
ATOM    900  HB2 TYR A  63      -0.978  -3.109   4.377  1.00  0.00           H  
ATOM    901  HB3 TYR A  63      -2.600  -3.778   4.233  1.00  0.00           H  
ATOM    902  HD1 TYR A  63      -0.520  -1.900   6.710  1.00  0.00           H  
ATOM    903  HD2 TYR A  63      -4.359  -2.484   4.973  1.00  0.00           H  
ATOM    904  HE1 TYR A  63      -1.401  -0.031   8.045  1.00  0.00           H  
ATOM    905  HE2 TYR A  63      -5.252  -0.616   6.302  1.00  0.00           H  
ATOM    906  HH  TYR A  63      -4.835   0.832   7.952  1.00  0.00           H  
ATOM    907  N   GLU A  64      -3.417  -5.769   6.580  1.00  0.00           N  
ATOM    908  CA  GLU A  64      -4.461  -6.091   7.547  1.00  0.00           C  
ATOM    909  C   GLU A  64      -3.985  -7.164   8.522  1.00  0.00           C  
ATOM    910  O   GLU A  64      -4.332  -7.143   9.705  1.00  0.00           O  
ATOM    911  CB  GLU A  64      -5.726  -6.564   6.829  1.00  0.00           C  
ATOM    912  CG  GLU A  64      -5.574  -7.921   6.161  1.00  0.00           C  
ATOM    913  CD  GLU A  64      -6.908  -8.545   5.800  1.00  0.00           C  
ATOM    914  OE1 GLU A  64      -7.459  -8.197   4.736  1.00  0.00           O  
ATOM    915  OE2 GLU A  64      -7.401  -9.384   6.585  1.00  0.00           O  
ATOM    916  H   GLU A  64      -3.444  -6.183   5.693  1.00  0.00           H  
ATOM    917  HA  GLU A  64      -4.686  -5.193   8.102  1.00  0.00           H  
ATOM    918  HB2 GLU A  64      -6.530  -6.627   7.546  1.00  0.00           H  
ATOM    919  HB3 GLU A  64      -5.986  -5.841   6.071  1.00  0.00           H  
ATOM    920  HG2 GLU A  64      -4.995  -7.800   5.257  1.00  0.00           H  
ATOM    921  HG3 GLU A  64      -5.053  -8.584   6.835  1.00  0.00           H  
ATOM    922  N   LEU A  65      -3.188  -8.100   8.021  1.00  0.00           N  
ATOM    923  CA  LEU A  65      -2.664  -9.183   8.847  1.00  0.00           C  
ATOM    924  C   LEU A  65      -1.979  -8.633  10.093  1.00  0.00           C  
ATOM    925  O   LEU A  65      -2.103  -9.196  11.181  1.00  0.00           O  
ATOM    926  CB  LEU A  65      -1.679 -10.033   8.042  1.00  0.00           C  
ATOM    927  CG  LEU A  65      -2.258 -10.767   6.832  1.00  0.00           C  
ATOM    928  CD1 LEU A  65      -1.186 -11.602   6.150  1.00  0.00           C  
ATOM    929  CD2 LEU A  65      -3.432 -11.641   7.250  1.00  0.00           C  
ATOM    930  H   LEU A  65      -2.946  -8.064   7.072  1.00  0.00           H  
ATOM    931  HA  LEU A  65      -3.496  -9.800   9.150  1.00  0.00           H  
ATOM    932  HB2 LEU A  65      -0.893  -9.384   7.689  1.00  0.00           H  
ATOM    933  HB3 LEU A  65      -1.260 -10.773   8.709  1.00  0.00           H  
ATOM    934  HG  LEU A  65      -2.618 -10.040   6.117  1.00  0.00           H  
ATOM    935 HD11 LEU A  65      -1.443 -11.740   5.111  1.00  0.00           H  
ATOM    936 HD12 LEU A  65      -1.116 -12.564   6.635  1.00  0.00           H  
ATOM    937 HD13 LEU A  65      -0.235 -11.095   6.222  1.00  0.00           H  
ATOM    938 HD21 LEU A  65      -4.184 -11.029   7.725  1.00  0.00           H  
ATOM    939 HD22 LEU A  65      -3.090 -12.394   7.943  1.00  0.00           H  
ATOM    940 HD23 LEU A  65      -3.854 -12.117   6.377  1.00  0.00           H  
ATOM    941  N   ALA A  66      -1.255  -7.531   9.928  1.00  0.00           N  
ATOM    942  CA  ALA A  66      -0.554  -6.903  11.041  1.00  0.00           C  
ATOM    943  C   ALA A  66      -1.537  -6.306  12.043  1.00  0.00           C  
ATOM    944  O   ALA A  66      -1.254  -6.236  13.238  1.00  0.00           O  
ATOM    945  CB  ALA A  66       0.396  -5.831  10.528  1.00  0.00           C  
ATOM    946  H   ALA A  66      -1.194  -7.129   9.036  1.00  0.00           H  
ATOM    947  HA  ALA A  66       0.033  -7.662  11.536  1.00  0.00           H  
ATOM    948  HB1 ALA A  66       0.914  -6.198   9.654  1.00  0.00           H  
ATOM    949  HB2 ALA A  66      -0.165  -4.946  10.269  1.00  0.00           H  
ATOM    950  HB3 ALA A  66       1.115  -5.590  11.297  1.00  0.00           H  
ATOM    951  N   GLY A  67      -2.693  -5.876  11.546  1.00  0.00           N  
ATOM    952  CA  GLY A  67      -3.699  -5.289  12.411  1.00  0.00           C  
ATOM    953  C   GLY A  67      -4.074  -3.881  11.995  1.00  0.00           C  
ATOM    954  O   GLY A  67      -4.481  -3.068  12.823  1.00  0.00           O  
ATOM    955  H   GLY A  67      -2.864  -5.957  10.584  1.00  0.00           H  
ATOM    956  HA2 GLY A  67      -4.583  -5.908  12.388  1.00  0.00           H  
ATOM    957  HA3 GLY A  67      -3.318  -5.263  13.422  1.00  0.00           H  
ATOM    958  N   GLY A  68      -3.935  -3.590  10.704  1.00  0.00           N  
ATOM    959  CA  GLY A  68      -4.265  -2.270  10.201  1.00  0.00           C  
ATOM    960  C   GLY A  68      -5.649  -2.212   9.588  1.00  0.00           C  
ATOM    961  O   GLY A  68      -6.179  -3.227   9.136  1.00  0.00           O  
ATOM    962  H   GLY A  68      -3.606  -4.279  10.089  1.00  0.00           H  
ATOM    963  HA2 GLY A  68      -4.213  -1.563  11.016  1.00  0.00           H  
ATOM    964  HA3 GLY A  68      -3.539  -1.992   9.451  1.00  0.00           H  
ATOM    965  N   ASP A  69      -6.238  -1.021   9.573  1.00  0.00           N  
ATOM    966  CA  ASP A  69      -7.570  -0.835   9.011  1.00  0.00           C  
ATOM    967  C   ASP A  69      -7.553   0.221   7.910  1.00  0.00           C  
ATOM    968  O   ASP A  69      -6.642   1.047   7.841  1.00  0.00           O  
ATOM    969  CB  ASP A  69      -8.557  -0.430  10.107  1.00  0.00           C  
ATOM    970  CG  ASP A  69      -7.991   0.627  11.035  1.00  0.00           C  
ATOM    971  OD1 ASP A  69      -7.591   1.700  10.539  1.00  0.00           O  
ATOM    972  OD2 ASP A  69      -7.949   0.379  12.258  1.00  0.00           O  
ATOM    973  H   ASP A  69      -5.765  -0.249   9.948  1.00  0.00           H  
ATOM    974  HA  ASP A  69      -7.886  -1.775   8.584  1.00  0.00           H  
ATOM    975  HB2 ASP A  69      -9.454  -0.037   9.648  1.00  0.00           H  
ATOM    976  HB3 ASP A  69      -8.811  -1.300  10.693  1.00  0.00           H  
ATOM    977  N   LEU A  70      -8.565   0.189   7.050  1.00  0.00           N  
ATOM    978  CA  LEU A  70      -8.666   1.142   5.951  1.00  0.00           C  
ATOM    979  C   LEU A  70      -8.208   2.529   6.389  1.00  0.00           C  
ATOM    980  O   LEU A  70      -7.350   3.141   5.754  1.00  0.00           O  
ATOM    981  CB  LEU A  70     -10.105   1.207   5.436  1.00  0.00           C  
ATOM    982  CG  LEU A  70     -10.280   1.674   3.990  1.00  0.00           C  
ATOM    983  CD1 LEU A  70      -9.502   0.776   3.042  1.00  0.00           C  
ATOM    984  CD2 LEU A  70     -11.754   1.699   3.613  1.00  0.00           C  
ATOM    985  H   LEU A  70      -9.262  -0.492   7.155  1.00  0.00           H  
ATOM    986  HA  LEU A  70      -8.022   0.800   5.154  1.00  0.00           H  
ATOM    987  HB2 LEU A  70     -10.530   0.219   5.518  1.00  0.00           H  
ATOM    988  HB3 LEU A  70     -10.653   1.886   6.073  1.00  0.00           H  
ATOM    989  HG  LEU A  70      -9.891   2.678   3.893  1.00  0.00           H  
ATOM    990 HD11 LEU A  70      -8.452   1.016   3.100  1.00  0.00           H  
ATOM    991 HD12 LEU A  70      -9.852   0.930   2.031  1.00  0.00           H  
ATOM    992 HD13 LEU A  70      -9.651  -0.257   3.320  1.00  0.00           H  
ATOM    993 HD21 LEU A  70     -12.274   2.408   4.243  1.00  0.00           H  
ATOM    994 HD22 LEU A  70     -12.178   0.716   3.752  1.00  0.00           H  
ATOM    995 HD23 LEU A  70     -11.857   1.994   2.580  1.00  0.00           H  
ATOM    996  N   ALA A  71      -8.786   3.020   7.482  1.00  0.00           N  
ATOM    997  CA  ALA A  71      -8.434   4.332   8.008  1.00  0.00           C  
ATOM    998  C   ALA A  71      -6.923   4.539   8.005  1.00  0.00           C  
ATOM    999  O   ALA A  71      -6.403   5.381   7.274  1.00  0.00           O  
ATOM   1000  CB  ALA A  71      -8.988   4.503   9.415  1.00  0.00           C  
ATOM   1001  H   ALA A  71      -9.462   2.485   7.945  1.00  0.00           H  
ATOM   1002  HA  ALA A  71      -8.890   5.079   7.375  1.00  0.00           H  
ATOM   1003  HB1 ALA A  71      -9.277   5.534   9.565  1.00  0.00           H  
ATOM   1004  HB2 ALA A  71      -9.851   3.865   9.541  1.00  0.00           H  
ATOM   1005  HB3 ALA A  71      -8.230   4.232  10.135  1.00  0.00           H  
ATOM   1006  N   GLY A  72      -6.222   3.764   8.827  1.00  0.00           N  
ATOM   1007  CA  GLY A  72      -4.777   3.877   8.904  1.00  0.00           C  
ATOM   1008  C   GLY A  72      -4.139   4.073   7.543  1.00  0.00           C  
ATOM   1009  O   GLY A  72      -3.284   4.942   7.369  1.00  0.00           O  
ATOM   1010  H   GLY A  72      -6.690   3.110   9.387  1.00  0.00           H  
ATOM   1011  HA2 GLY A  72      -4.526   4.719   9.532  1.00  0.00           H  
ATOM   1012  HA3 GLY A  72      -4.380   2.978   9.349  1.00  0.00           H  
ATOM   1013  N   LEU A  73      -4.552   3.261   6.576  1.00  0.00           N  
ATOM   1014  CA  LEU A  73      -4.013   3.347   5.224  1.00  0.00           C  
ATOM   1015  C   LEU A  73      -4.330   4.700   4.594  1.00  0.00           C  
ATOM   1016  O   LEU A  73      -3.461   5.343   4.005  1.00  0.00           O  
ATOM   1017  CB  LEU A  73      -4.580   2.222   4.354  1.00  0.00           C  
ATOM   1018  CG  LEU A  73      -3.829   1.934   3.055  1.00  0.00           C  
ATOM   1019  CD1 LEU A  73      -2.419   1.444   3.351  1.00  0.00           C  
ATOM   1020  CD2 LEU A  73      -4.585   0.913   2.216  1.00  0.00           C  
ATOM   1021  H   LEU A  73      -5.235   2.588   6.775  1.00  0.00           H  
ATOM   1022  HA  LEU A  73      -2.940   3.236   5.286  1.00  0.00           H  
ATOM   1023  HB2 LEU A  73      -4.581   1.319   4.944  1.00  0.00           H  
ATOM   1024  HB3 LEU A  73      -5.596   2.484   4.099  1.00  0.00           H  
ATOM   1025  HG  LEU A  73      -3.750   2.847   2.481  1.00  0.00           H  
ATOM   1026 HD11 LEU A  73      -1.984   1.036   2.451  1.00  0.00           H  
ATOM   1027 HD12 LEU A  73      -2.456   0.679   4.111  1.00  0.00           H  
ATOM   1028 HD13 LEU A  73      -1.817   2.270   3.700  1.00  0.00           H  
ATOM   1029 HD21 LEU A  73      -5.293   0.389   2.841  1.00  0.00           H  
ATOM   1030 HD22 LEU A  73      -3.886   0.207   1.793  1.00  0.00           H  
ATOM   1031 HD23 LEU A  73      -5.111   1.420   1.421  1.00  0.00           H  
ATOM   1032  N   LEU A  74      -5.581   5.127   4.726  1.00  0.00           N  
ATOM   1033  CA  LEU A  74      -6.015   6.406   4.174  1.00  0.00           C  
ATOM   1034  C   LEU A  74      -5.143   7.546   4.690  1.00  0.00           C  
ATOM   1035  O   LEU A  74      -4.906   8.527   3.986  1.00  0.00           O  
ATOM   1036  CB  LEU A  74      -7.479   6.667   4.527  1.00  0.00           C  
ATOM   1037  CG  LEU A  74      -8.498   5.692   3.936  1.00  0.00           C  
ATOM   1038  CD1 LEU A  74      -9.811   5.763   4.699  1.00  0.00           C  
ATOM   1039  CD2 LEU A  74      -8.720   5.984   2.459  1.00  0.00           C  
ATOM   1040  H   LEU A  74      -6.230   4.571   5.206  1.00  0.00           H  
ATOM   1041  HA  LEU A  74      -5.917   6.352   3.099  1.00  0.00           H  
ATOM   1042  HB2 LEU A  74      -7.571   6.629   5.603  1.00  0.00           H  
ATOM   1043  HB3 LEU A  74      -7.731   7.660   4.182  1.00  0.00           H  
ATOM   1044  HG  LEU A  74      -8.116   4.684   4.025  1.00  0.00           H  
ATOM   1045 HD11 LEU A  74      -9.615   6.000   5.734  1.00  0.00           H  
ATOM   1046 HD12 LEU A  74     -10.316   4.811   4.636  1.00  0.00           H  
ATOM   1047 HD13 LEU A  74     -10.437   6.530   4.267  1.00  0.00           H  
ATOM   1048 HD21 LEU A  74      -9.714   6.383   2.317  1.00  0.00           H  
ATOM   1049 HD22 LEU A  74      -8.615   5.070   1.892  1.00  0.00           H  
ATOM   1050 HD23 LEU A  74      -7.991   6.705   2.121  1.00  0.00           H  
ATOM   1051  N   GLU A  75      -4.668   7.409   5.923  1.00  0.00           N  
ATOM   1052  CA  GLU A  75      -3.822   8.427   6.533  1.00  0.00           C  
ATOM   1053  C   GLU A  75      -2.479   8.520   5.815  1.00  0.00           C  
ATOM   1054  O   GLU A  75      -1.969   9.612   5.569  1.00  0.00           O  
ATOM   1055  CB  GLU A  75      -3.600   8.117   8.016  1.00  0.00           C  
ATOM   1056  CG  GLU A  75      -2.278   8.640   8.556  1.00  0.00           C  
ATOM   1057  CD  GLU A  75      -2.271   8.756  10.068  1.00  0.00           C  
ATOM   1058  OE1 GLU A  75      -3.357   8.956  10.652  1.00  0.00           O  
ATOM   1059  OE2 GLU A  75      -1.182   8.645  10.666  1.00  0.00           O  
ATOM   1060  H   GLU A  75      -4.892   6.604   6.436  1.00  0.00           H  
ATOM   1061  HA  GLU A  75      -4.329   9.376   6.446  1.00  0.00           H  
ATOM   1062  HB2 GLU A  75      -4.400   8.561   8.588  1.00  0.00           H  
ATOM   1063  HB3 GLU A  75      -3.622   7.046   8.154  1.00  0.00           H  
ATOM   1064  HG2 GLU A  75      -1.491   7.965   8.258  1.00  0.00           H  
ATOM   1065  HG3 GLU A  75      -2.093   9.617   8.134  1.00  0.00           H  
ATOM   1066  N   ALA A  76      -1.911   7.366   5.483  1.00  0.00           N  
ATOM   1067  CA  ALA A  76      -0.628   7.315   4.792  1.00  0.00           C  
ATOM   1068  C   ALA A  76      -0.751   7.849   3.368  1.00  0.00           C  
ATOM   1069  O   ALA A  76       0.008   8.726   2.956  1.00  0.00           O  
ATOM   1070  CB  ALA A  76      -0.090   5.893   4.780  1.00  0.00           C  
ATOM   1071  H   ALA A  76      -2.366   6.527   5.707  1.00  0.00           H  
ATOM   1072  HA  ALA A  76       0.070   7.933   5.338  1.00  0.00           H  
ATOM   1073  HB1 ALA A  76       0.627   5.786   3.979  1.00  0.00           H  
ATOM   1074  HB2 ALA A  76       0.390   5.681   5.725  1.00  0.00           H  
ATOM   1075  HB3 ALA A  76      -0.906   5.201   4.627  1.00  0.00           H  
ATOM   1076  N   LEU A  77      -1.709   7.313   2.622  1.00  0.00           N  
ATOM   1077  CA  LEU A  77      -1.931   7.734   1.243  1.00  0.00           C  
ATOM   1078  C   LEU A  77      -2.039   9.253   1.148  1.00  0.00           C  
ATOM   1079  O   LEU A  77      -1.417   9.877   0.288  1.00  0.00           O  
ATOM   1080  CB  LEU A  77      -3.201   7.087   0.688  1.00  0.00           C  
ATOM   1081  CG  LEU A  77      -3.171   5.565   0.545  1.00  0.00           C  
ATOM   1082  CD1 LEU A  77      -4.562   5.028   0.245  1.00  0.00           C  
ATOM   1083  CD2 LEU A  77      -2.191   5.151  -0.544  1.00  0.00           C  
ATOM   1084  H   LEU A  77      -2.283   6.617   3.005  1.00  0.00           H  
ATOM   1085  HA  LEU A  77      -1.085   7.408   0.657  1.00  0.00           H  
ATOM   1086  HB2 LEU A  77      -4.016   7.340   1.348  1.00  0.00           H  
ATOM   1087  HB3 LEU A  77      -3.386   7.509  -0.289  1.00  0.00           H  
ATOM   1088  HG  LEU A  77      -2.839   5.129   1.477  1.00  0.00           H  
ATOM   1089 HD11 LEU A  77      -5.245   5.349   1.016  1.00  0.00           H  
ATOM   1090 HD12 LEU A  77      -4.533   3.950   0.215  1.00  0.00           H  
ATOM   1091 HD13 LEU A  77      -4.894   5.406  -0.711  1.00  0.00           H  
ATOM   1092 HD21 LEU A  77      -1.205   5.515  -0.297  1.00  0.00           H  
ATOM   1093 HD22 LEU A  77      -2.504   5.572  -1.488  1.00  0.00           H  
ATOM   1094 HD23 LEU A  77      -2.169   4.074  -0.619  1.00  0.00           H  
ATOM   1095  N   SER A  78      -2.829   9.843   2.040  1.00  0.00           N  
ATOM   1096  CA  SER A  78      -3.018  11.288   2.057  1.00  0.00           C  
ATOM   1097  C   SER A  78      -1.694  12.007   2.294  1.00  0.00           C  
ATOM   1098  O   SER A  78      -1.292  12.866   1.509  1.00  0.00           O  
ATOM   1099  CB  SER A  78      -4.026  11.679   3.140  1.00  0.00           C  
ATOM   1100  OG  SER A  78      -4.361  13.053   3.053  1.00  0.00           O  
ATOM   1101  H   SER A  78      -3.297   9.291   2.702  1.00  0.00           H  
ATOM   1102  HA  SER A  78      -3.407  11.582   1.094  1.00  0.00           H  
ATOM   1103  HB2 SER A  78      -4.924  11.092   3.022  1.00  0.00           H  
ATOM   1104  HB3 SER A  78      -3.596  11.487   4.113  1.00  0.00           H  
ATOM   1105  HG  SER A  78      -5.097  13.165   2.445  1.00  0.00           H  
ATOM   1106  N   ASP A  79      -1.021  11.650   3.382  1.00  0.00           N  
ATOM   1107  CA  ASP A  79       0.259  12.260   3.724  1.00  0.00           C  
ATOM   1108  C   ASP A  79       1.239  12.153   2.560  1.00  0.00           C  
ATOM   1109  O   ASP A  79       2.066  13.041   2.350  1.00  0.00           O  
ATOM   1110  CB  ASP A  79       0.850  11.593   4.967  1.00  0.00           C  
ATOM   1111  CG  ASP A  79       1.733  12.533   5.765  1.00  0.00           C  
ATOM   1112  OD1 ASP A  79       1.510  13.760   5.692  1.00  0.00           O  
ATOM   1113  OD2 ASP A  79       2.647  12.042   6.460  1.00  0.00           O  
ATOM   1114  H   ASP A  79      -1.394  10.960   3.970  1.00  0.00           H  
ATOM   1115  HA  ASP A  79       0.083  13.304   3.936  1.00  0.00           H  
ATOM   1116  HB2 ASP A  79       0.045  11.258   5.605  1.00  0.00           H  
ATOM   1117  HB3 ASP A  79       1.442  10.742   4.664  1.00  0.00           H  
ATOM   1118  N   MET A  80       1.141  11.063   1.808  1.00  0.00           N  
ATOM   1119  CA  MET A  80       2.019  10.841   0.665  1.00  0.00           C  
ATOM   1120  C   MET A  80       1.552  11.645  -0.544  1.00  0.00           C  
ATOM   1121  O   MET A  80       2.339  11.958  -1.436  1.00  0.00           O  
ATOM   1122  CB  MET A  80       2.069   9.354   0.313  1.00  0.00           C  
ATOM   1123  CG  MET A  80       2.847   8.517   1.317  1.00  0.00           C  
ATOM   1124  SD  MET A  80       3.125   6.829   0.748  1.00  0.00           S  
ATOM   1125  CE  MET A  80       3.692   7.125  -0.924  1.00  0.00           C  
ATOM   1126  H   MET A  80       0.462  10.390   2.026  1.00  0.00           H  
ATOM   1127  HA  MET A  80       3.010  11.170   0.940  1.00  0.00           H  
ATOM   1128  HB2 MET A  80       1.060   8.972   0.267  1.00  0.00           H  
ATOM   1129  HB3 MET A  80       2.534   9.239  -0.654  1.00  0.00           H  
ATOM   1130  HG2 MET A  80       3.804   8.985   1.491  1.00  0.00           H  
ATOM   1131  HG3 MET A  80       2.292   8.485   2.243  1.00  0.00           H  
ATOM   1132  HE1 MET A  80       2.840   7.257  -1.576  1.00  0.00           H  
ATOM   1133  HE2 MET A  80       4.303   8.016  -0.945  1.00  0.00           H  
ATOM   1134  HE3 MET A  80       4.275   6.279  -1.261  1.00  0.00           H  
ATOM   1135  N   GLY A  81       0.264  11.978  -0.567  1.00  0.00           N  
ATOM   1136  CA  GLY A  81      -0.285  12.742  -1.671  1.00  0.00           C  
ATOM   1137  C   GLY A  81      -1.315  11.960  -2.462  1.00  0.00           C  
ATOM   1138  O   GLY A  81      -2.172  12.543  -3.126  1.00  0.00           O  
ATOM   1139  H   GLY A  81      -0.317  11.700   0.172  1.00  0.00           H  
ATOM   1140  HA2 GLY A  81      -0.748  13.635  -1.281  1.00  0.00           H  
ATOM   1141  HA3 GLY A  81       0.519  13.026  -2.333  1.00  0.00           H  
ATOM   1142  N   LEU A  82      -1.232  10.636  -2.391  1.00  0.00           N  
ATOM   1143  CA  LEU A  82      -2.163   9.771  -3.109  1.00  0.00           C  
ATOM   1144  C   LEU A  82      -3.601  10.047  -2.680  1.00  0.00           C  
ATOM   1145  O   LEU A  82      -4.100   9.447  -1.729  1.00  0.00           O  
ATOM   1146  CB  LEU A  82      -1.819   8.302  -2.863  1.00  0.00           C  
ATOM   1147  CG  LEU A  82      -0.378   7.891  -3.169  1.00  0.00           C  
ATOM   1148  CD1 LEU A  82       0.032   6.702  -2.312  1.00  0.00           C  
ATOM   1149  CD2 LEU A  82      -0.220   7.565  -4.647  1.00  0.00           C  
ATOM   1150  H   LEU A  82      -0.528  10.229  -1.846  1.00  0.00           H  
ATOM   1151  HA  LEU A  82      -2.068   9.984  -4.163  1.00  0.00           H  
ATOM   1152  HB2 LEU A  82      -2.009   8.087  -1.823  1.00  0.00           H  
ATOM   1153  HB3 LEU A  82      -2.473   7.702  -3.479  1.00  0.00           H  
ATOM   1154  HG  LEU A  82       0.283   8.714  -2.934  1.00  0.00           H  
ATOM   1155 HD11 LEU A  82      -0.617   5.866  -2.524  1.00  0.00           H  
ATOM   1156 HD12 LEU A  82      -0.049   6.967  -1.268  1.00  0.00           H  
ATOM   1157 HD13 LEU A  82       1.053   6.432  -2.537  1.00  0.00           H  
ATOM   1158 HD21 LEU A  82      -0.563   8.401  -5.239  1.00  0.00           H  
ATOM   1159 HD22 LEU A  82      -0.805   6.689  -4.887  1.00  0.00           H  
ATOM   1160 HD23 LEU A  82       0.822   7.374  -4.864  1.00  0.00           H  
ATOM   1161  N   GLU A  83      -4.261  10.957  -3.389  1.00  0.00           N  
ATOM   1162  CA  GLU A  83      -5.642  11.310  -3.081  1.00  0.00           C  
ATOM   1163  C   GLU A  83      -6.612  10.313  -3.711  1.00  0.00           C  
ATOM   1164  O   GLU A  83      -7.554   9.857  -3.064  1.00  0.00           O  
ATOM   1165  CB  GLU A  83      -5.954  12.723  -3.579  1.00  0.00           C  
ATOM   1166  CG  GLU A  83      -5.358  13.819  -2.711  1.00  0.00           C  
ATOM   1167  CD  GLU A  83      -5.773  15.207  -3.157  1.00  0.00           C  
ATOM   1168  OE1 GLU A  83      -6.860  15.338  -3.757  1.00  0.00           O  
ATOM   1169  OE2 GLU A  83      -5.011  16.164  -2.904  1.00  0.00           O  
ATOM   1170  H   GLU A  83      -3.809  11.402  -4.136  1.00  0.00           H  
ATOM   1171  HA  GLU A  83      -5.761  11.282  -2.010  1.00  0.00           H  
ATOM   1172  HB2 GLU A  83      -5.564  12.833  -4.580  1.00  0.00           H  
ATOM   1173  HB3 GLU A  83      -7.025  12.855  -3.603  1.00  0.00           H  
ATOM   1174  HG2 GLU A  83      -5.685  13.671  -1.693  1.00  0.00           H  
ATOM   1175  HG3 GLU A  83      -4.281  13.750  -2.755  1.00  0.00           H  
ATOM   1176  N   GLU A  84      -6.371   9.980  -4.975  1.00  0.00           N  
ATOM   1177  CA  GLU A  84      -7.224   9.039  -5.691  1.00  0.00           C  
ATOM   1178  C   GLU A  84      -7.459   7.779  -4.863  1.00  0.00           C  
ATOM   1179  O   GLU A  84      -8.573   7.520  -4.409  1.00  0.00           O  
ATOM   1180  CB  GLU A  84      -6.595   8.668  -7.036  1.00  0.00           C  
ATOM   1181  CG  GLU A  84      -7.611   8.276  -8.096  1.00  0.00           C  
ATOM   1182  CD  GLU A  84      -8.235   9.478  -8.779  1.00  0.00           C  
ATOM   1183  OE1 GLU A  84      -8.329  10.544  -8.136  1.00  0.00           O  
ATOM   1184  OE2 GLU A  84      -8.629   9.351  -9.957  1.00  0.00           O  
ATOM   1185  H   GLU A  84      -5.604  10.377  -5.437  1.00  0.00           H  
ATOM   1186  HA  GLU A  84      -8.173   9.519  -5.869  1.00  0.00           H  
ATOM   1187  HB2 GLU A  84      -6.031   9.514  -7.401  1.00  0.00           H  
ATOM   1188  HB3 GLU A  84      -5.922   7.837  -6.887  1.00  0.00           H  
ATOM   1189  HG2 GLU A  84      -7.117   7.673  -8.843  1.00  0.00           H  
ATOM   1190  HG3 GLU A  84      -8.395   7.699  -7.628  1.00  0.00           H  
ATOM   1191  N   GLY A  85      -6.400   6.997  -4.671  1.00  0.00           N  
ATOM   1192  CA  GLY A  85      -6.511   5.774  -3.899  1.00  0.00           C  
ATOM   1193  C   GLY A  85      -7.421   5.927  -2.696  1.00  0.00           C  
ATOM   1194  O   GLY A  85      -8.207   5.032  -2.384  1.00  0.00           O  
ATOM   1195  H   GLY A  85      -5.537   7.254  -5.058  1.00  0.00           H  
ATOM   1196  HA2 GLY A  85      -6.901   4.994  -4.535  1.00  0.00           H  
ATOM   1197  HA3 GLY A  85      -5.527   5.487  -3.556  1.00  0.00           H  
ATOM   1198  N   VAL A  86      -7.316   7.066  -2.019  1.00  0.00           N  
ATOM   1199  CA  VAL A  86      -8.136   7.334  -0.843  1.00  0.00           C  
ATOM   1200  C   VAL A  86      -9.617   7.363  -1.200  1.00  0.00           C  
ATOM   1201  O   VAL A  86     -10.385   6.500  -0.776  1.00  0.00           O  
ATOM   1202  CB  VAL A  86      -7.752   8.673  -0.184  1.00  0.00           C  
ATOM   1203  CG1 VAL A  86      -8.624   8.939   1.034  1.00  0.00           C  
ATOM   1204  CG2 VAL A  86      -6.278   8.677   0.194  1.00  0.00           C  
ATOM   1205  H   VAL A  86      -6.672   7.742  -2.316  1.00  0.00           H  
ATOM   1206  HA  VAL A  86      -7.963   6.544  -0.127  1.00  0.00           H  
ATOM   1207  HB  VAL A  86      -7.920   9.464  -0.900  1.00  0.00           H  
ATOM   1208 HG11 VAL A  86      -8.070   8.705   1.930  1.00  0.00           H  
ATOM   1209 HG12 VAL A  86      -8.914   9.979   1.048  1.00  0.00           H  
ATOM   1210 HG13 VAL A  86      -9.508   8.319   0.985  1.00  0.00           H  
ATOM   1211 HG21 VAL A  86      -5.824   7.748  -0.118  1.00  0.00           H  
ATOM   1212 HG22 VAL A  86      -5.783   9.502  -0.297  1.00  0.00           H  
ATOM   1213 HG23 VAL A  86      -6.182   8.784   1.264  1.00  0.00           H  
ATOM   1214  N   ARG A  87     -10.011   8.361  -1.984  1.00  0.00           N  
ATOM   1215  CA  ARG A  87     -11.402   8.503  -2.400  1.00  0.00           C  
ATOM   1216  C   ARG A  87     -11.938   7.190  -2.963  1.00  0.00           C  
ATOM   1217  O   ARG A  87     -13.101   6.841  -2.754  1.00  0.00           O  
ATOM   1218  CB  ARG A  87     -11.533   9.611  -3.446  1.00  0.00           C  
ATOM   1219  CG  ARG A  87     -11.243  11.000  -2.902  1.00  0.00           C  
ATOM   1220  CD  ARG A  87     -11.145  12.027  -4.019  1.00  0.00           C  
ATOM   1221  NE  ARG A  87     -10.664  13.318  -3.536  1.00  0.00           N  
ATOM   1222  CZ  ARG A  87     -11.434  14.203  -2.912  1.00  0.00           C  
ATOM   1223  NH1 ARG A  87     -12.715  13.937  -2.697  1.00  0.00           N  
ATOM   1224  NH2 ARG A  87     -10.922  15.357  -2.501  1.00  0.00           N  
ATOM   1225  H   ARG A  87      -9.352   9.018  -2.290  1.00  0.00           H  
ATOM   1226  HA  ARG A  87     -11.983   8.771  -1.530  1.00  0.00           H  
ATOM   1227  HB2 ARG A  87     -10.843   9.413  -4.252  1.00  0.00           H  
ATOM   1228  HB3 ARG A  87     -12.541   9.604  -3.836  1.00  0.00           H  
ATOM   1229  HG2 ARG A  87     -12.040  11.289  -2.232  1.00  0.00           H  
ATOM   1230  HG3 ARG A  87     -10.308  10.977  -2.363  1.00  0.00           H  
ATOM   1231  HD2 ARG A  87     -10.464  11.658  -4.770  1.00  0.00           H  
ATOM   1232  HD3 ARG A  87     -12.125  12.158  -4.456  1.00  0.00           H  
ATOM   1233  HE  ARG A  87      -9.720  13.535  -3.684  1.00  0.00           H  
ATOM   1234 HH11 ARG A  87     -13.102  13.069  -3.005  1.00  0.00           H  
ATOM   1235 HH12 ARG A  87     -13.291  14.605  -2.227  1.00  0.00           H  
ATOM   1236 HH21 ARG A  87      -9.957  15.561  -2.661  1.00  0.00           H  
ATOM   1237 HH22 ARG A  87     -11.503  16.022  -2.033  1.00  0.00           H  
ATOM   1238  N   LEU A  88     -11.084   6.468  -3.679  1.00  0.00           N  
ATOM   1239  CA  LEU A  88     -11.471   5.193  -4.274  1.00  0.00           C  
ATOM   1240  C   LEU A  88     -11.871   4.189  -3.198  1.00  0.00           C  
ATOM   1241  O   LEU A  88     -12.995   3.684  -3.193  1.00  0.00           O  
ATOM   1242  CB  LEU A  88     -10.322   4.629  -5.112  1.00  0.00           C  
ATOM   1243  CG  LEU A  88     -10.703   3.575  -6.151  1.00  0.00           C  
ATOM   1244  CD1 LEU A  88      -9.520   3.261  -7.053  1.00  0.00           C  
ATOM   1245  CD2 LEU A  88     -11.206   2.310  -5.469  1.00  0.00           C  
ATOM   1246  H   LEU A  88     -10.171   6.798  -3.811  1.00  0.00           H  
ATOM   1247  HA  LEU A  88     -12.320   5.371  -4.917  1.00  0.00           H  
ATOM   1248  HB2 LEU A  88      -9.856   5.452  -5.631  1.00  0.00           H  
ATOM   1249  HB3 LEU A  88      -9.608   4.183  -4.433  1.00  0.00           H  
ATOM   1250  HG  LEU A  88     -11.501   3.960  -6.770  1.00  0.00           H  
ATOM   1251 HD11 LEU A  88      -9.662   2.294  -7.511  1.00  0.00           H  
ATOM   1252 HD12 LEU A  88      -8.613   3.252  -6.466  1.00  0.00           H  
ATOM   1253 HD13 LEU A  88      -9.442   4.016  -7.821  1.00  0.00           H  
ATOM   1254 HD21 LEU A  88     -10.499   2.006  -4.711  1.00  0.00           H  
ATOM   1255 HD22 LEU A  88     -11.310   1.523  -6.201  1.00  0.00           H  
ATOM   1256 HD23 LEU A  88     -12.164   2.505  -5.011  1.00  0.00           H  
ATOM   1257  N   LEU A  89     -10.947   3.906  -2.287  1.00  0.00           N  
ATOM   1258  CA  LEU A  89     -11.205   2.963  -1.203  1.00  0.00           C  
ATOM   1259  C   LEU A  89     -12.473   3.341  -0.444  1.00  0.00           C  
ATOM   1260  O   LEU A  89     -13.231   2.472  -0.013  1.00  0.00           O  
ATOM   1261  CB  LEU A  89     -10.014   2.922  -0.243  1.00  0.00           C  
ATOM   1262  CG  LEU A  89      -8.690   2.442  -0.837  1.00  0.00           C  
ATOM   1263  CD1 LEU A  89      -7.532   2.804   0.081  1.00  0.00           C  
ATOM   1264  CD2 LEU A  89      -8.729   0.941  -1.084  1.00  0.00           C  
ATOM   1265  H   LEU A  89     -10.070   4.339  -2.344  1.00  0.00           H  
ATOM   1266  HA  LEU A  89     -11.339   1.985  -1.640  1.00  0.00           H  
ATOM   1267  HB2 LEU A  89      -9.863   3.921   0.138  1.00  0.00           H  
ATOM   1268  HB3 LEU A  89     -10.272   2.262   0.573  1.00  0.00           H  
ATOM   1269  HG  LEU A  89      -8.528   2.935  -1.786  1.00  0.00           H  
ATOM   1270 HD11 LEU A  89      -7.840   3.586   0.758  1.00  0.00           H  
ATOM   1271 HD12 LEU A  89      -6.697   3.146  -0.511  1.00  0.00           H  
ATOM   1272 HD13 LEU A  89      -7.237   1.932   0.648  1.00  0.00           H  
ATOM   1273 HD21 LEU A  89      -7.853   0.483  -0.652  1.00  0.00           H  
ATOM   1274 HD22 LEU A  89      -8.746   0.753  -2.148  1.00  0.00           H  
ATOM   1275 HD23 LEU A  89      -9.615   0.524  -0.630  1.00  0.00           H  
ATOM   1276  N   ARG A  90     -12.698   4.640  -0.287  1.00  0.00           N  
ATOM   1277  CA  ARG A  90     -13.874   5.133   0.420  1.00  0.00           C  
ATOM   1278  C   ARG A  90     -15.148   4.804  -0.353  1.00  0.00           C  
ATOM   1279  O   ARG A  90     -16.172   4.459   0.237  1.00  0.00           O  
ATOM   1280  CB  ARG A  90     -13.771   6.644   0.635  1.00  0.00           C  
ATOM   1281  CG  ARG A  90     -12.777   7.039   1.714  1.00  0.00           C  
ATOM   1282  CD  ARG A  90     -13.017   8.460   2.200  1.00  0.00           C  
ATOM   1283  NE  ARG A  90     -13.982   8.508   3.295  1.00  0.00           N  
ATOM   1284  CZ  ARG A  90     -14.127   9.553   4.101  1.00  0.00           C  
ATOM   1285  NH1 ARG A  90     -13.372  10.630   3.938  1.00  0.00           N  
ATOM   1286  NH2 ARG A  90     -15.029   9.521   5.075  1.00  0.00           N  
ATOM   1287  H   ARG A  90     -12.056   5.285  -0.653  1.00  0.00           H  
ATOM   1288  HA  ARG A  90     -13.914   4.643   1.381  1.00  0.00           H  
ATOM   1289  HB2 ARG A  90     -13.467   7.108  -0.292  1.00  0.00           H  
ATOM   1290  HB3 ARG A  90     -14.743   7.022   0.916  1.00  0.00           H  
ATOM   1291  HG2 ARG A  90     -12.878   6.362   2.550  1.00  0.00           H  
ATOM   1292  HG3 ARG A  90     -11.777   6.969   1.312  1.00  0.00           H  
ATOM   1293  HD2 ARG A  90     -12.079   8.872   2.542  1.00  0.00           H  
ATOM   1294  HD3 ARG A  90     -13.390   9.048   1.376  1.00  0.00           H  
ATOM   1295  HE  ARG A  90     -14.551   7.722   3.433  1.00  0.00           H  
ATOM   1296 HH11 ARG A  90     -12.693  10.657   3.205  1.00  0.00           H  
ATOM   1297 HH12 ARG A  90     -13.483  11.417   4.546  1.00  0.00           H  
ATOM   1298 HH21 ARG A  90     -15.599   8.710   5.202  1.00  0.00           H  
ATOM   1299 HH22 ARG A  90     -15.136  10.308   5.683  1.00  0.00           H  
ATOM   1300  N   GLY A  91     -15.078   4.913  -1.676  1.00  0.00           N  
ATOM   1301  CA  GLY A  91     -16.232   4.624  -2.506  1.00  0.00           C  
ATOM   1302  C   GLY A  91     -17.176   5.806  -2.619  1.00  0.00           C  
ATOM   1303  O   GLY A  91     -17.338   6.589  -1.683  1.00  0.00           O  
ATOM   1304  H   GLY A  91     -14.235   5.192  -2.091  1.00  0.00           H  
ATOM   1305  HA2 GLY A  91     -15.892   4.353  -3.495  1.00  0.00           H  
ATOM   1306  HA3 GLY A  91     -16.769   3.790  -2.080  1.00  0.00           H  
ATOM   1307  N   PRO A  92     -17.815   5.948  -3.790  1.00  0.00           N  
ATOM   1308  CA  PRO A  92     -18.757   7.041  -4.049  1.00  0.00           C  
ATOM   1309  C   PRO A  92     -20.047   6.897  -3.249  1.00  0.00           C  
ATOM   1310  O   PRO A  92     -20.328   5.836  -2.695  1.00  0.00           O  
ATOM   1311  CB  PRO A  92     -19.040   6.916  -5.549  1.00  0.00           C  
ATOM   1312  CG  PRO A  92     -18.780   5.484  -5.865  1.00  0.00           C  
ATOM   1313  CD  PRO A  92     -17.669   5.052  -4.949  1.00  0.00           C  
ATOM   1314  HA  PRO A  92     -18.313   8.004  -3.844  1.00  0.00           H  
ATOM   1315  HB2 PRO A  92     -20.068   7.185  -5.747  1.00  0.00           H  
ATOM   1316  HB3 PRO A  92     -18.379   7.568  -6.099  1.00  0.00           H  
ATOM   1317  HG2 PRO A  92     -19.669   4.899  -5.679  1.00  0.00           H  
ATOM   1318  HG3 PRO A  92     -18.475   5.386  -6.897  1.00  0.00           H  
ATOM   1319  HD2 PRO A  92     -17.798   4.020  -4.658  1.00  0.00           H  
ATOM   1320  HD3 PRO A  92     -16.710   5.194  -5.426  1.00  0.00           H  
ATOM   1321  N   GLU A  93     -20.828   7.971  -3.197  1.00  0.00           N  
ATOM   1322  CA  GLU A  93     -22.089   7.963  -2.463  1.00  0.00           C  
ATOM   1323  C   GLU A  93     -23.122   7.088  -3.168  1.00  0.00           C  
ATOM   1324  O   GLU A  93     -22.860   6.536  -4.237  1.00  0.00           O  
ATOM   1325  CB  GLU A  93     -22.627   9.387  -2.314  1.00  0.00           C  
ATOM   1326  CG  GLU A  93     -21.849  10.230  -1.317  1.00  0.00           C  
ATOM   1327  CD  GLU A  93     -22.001   9.736   0.109  1.00  0.00           C  
ATOM   1328  OE1 GLU A  93     -23.121   9.327   0.479  1.00  0.00           O  
ATOM   1329  OE2 GLU A  93     -20.998   9.757   0.852  1.00  0.00           O  
ATOM   1330  H   GLU A  93     -20.550   8.788  -3.659  1.00  0.00           H  
ATOM   1331  HA  GLU A  93     -21.899   7.555  -1.482  1.00  0.00           H  
ATOM   1332  HB2 GLU A  93     -22.588   9.876  -3.276  1.00  0.00           H  
ATOM   1333  HB3 GLU A  93     -23.655   9.338  -1.987  1.00  0.00           H  
ATOM   1334  HG2 GLU A  93     -20.803  10.204  -1.582  1.00  0.00           H  
ATOM   1335  HG3 GLU A  93     -22.207  11.248  -1.369  1.00  0.00           H  
ATOM   1336  N   THR A  94     -24.298   6.966  -2.561  1.00  0.00           N  
ATOM   1337  CA  THR A  94     -25.371   6.159  -3.128  1.00  0.00           C  
ATOM   1338  C   THR A  94     -26.669   6.953  -3.216  1.00  0.00           C  
ATOM   1339  O   THR A  94     -27.222   7.369  -2.199  1.00  0.00           O  
ATOM   1340  CB  THR A  94     -25.615   4.886  -2.295  1.00  0.00           C  
ATOM   1341  OG1 THR A  94     -26.043   5.239  -0.975  1.00  0.00           O  
ATOM   1342  CG2 THR A  94     -24.354   4.040  -2.215  1.00  0.00           C  
ATOM   1343  H   THR A  94     -24.447   7.431  -1.711  1.00  0.00           H  
ATOM   1344  HA  THR A  94     -25.074   5.861  -4.123  1.00  0.00           H  
ATOM   1345  HB  THR A  94     -26.391   4.304  -2.774  1.00  0.00           H  
ATOM   1346  HG1 THR A  94     -26.621   6.005  -1.020  1.00  0.00           H  
ATOM   1347 HG21 THR A  94     -24.138   3.811  -1.182  1.00  0.00           H  
ATOM   1348 HG22 THR A  94     -23.526   4.587  -2.643  1.00  0.00           H  
ATOM   1349 HG23 THR A  94     -24.501   3.123  -2.764  1.00  0.00           H  
ATOM   1350  N   ARG A  95     -27.151   7.157  -4.438  1.00  0.00           N  
ATOM   1351  CA  ARG A  95     -28.385   7.902  -4.658  1.00  0.00           C  
ATOM   1352  C   ARG A  95     -29.534   6.959  -5.003  1.00  0.00           C  
ATOM   1353  O   ARG A  95     -29.458   6.200  -5.969  1.00  0.00           O  
ATOM   1354  CB  ARG A  95     -28.195   8.924  -5.780  1.00  0.00           C  
ATOM   1355  CG  ARG A  95     -29.374   9.867  -5.950  1.00  0.00           C  
ATOM   1356  CD  ARG A  95     -29.356  10.543  -7.312  1.00  0.00           C  
ATOM   1357  NE  ARG A  95     -28.163  11.366  -7.498  1.00  0.00           N  
ATOM   1358  CZ  ARG A  95     -27.935  12.491  -6.831  1.00  0.00           C  
ATOM   1359  NH1 ARG A  95     -28.814  12.926  -5.937  1.00  0.00           N  
ATOM   1360  NH2 ARG A  95     -26.827  13.185  -7.056  1.00  0.00           N  
ATOM   1361  H   ARG A  95     -26.664   6.799  -5.209  1.00  0.00           H  
ATOM   1362  HA  ARG A  95     -28.625   8.424  -3.745  1.00  0.00           H  
ATOM   1363  HB2 ARG A  95     -27.317   9.516  -5.567  1.00  0.00           H  
ATOM   1364  HB3 ARG A  95     -28.047   8.396  -6.710  1.00  0.00           H  
ATOM   1365  HG2 ARG A  95     -30.291   9.304  -5.853  1.00  0.00           H  
ATOM   1366  HG3 ARG A  95     -29.332  10.624  -5.181  1.00  0.00           H  
ATOM   1367  HD2 ARG A  95     -29.378   9.781  -8.078  1.00  0.00           H  
ATOM   1368  HD3 ARG A  95     -30.231  11.169  -7.400  1.00  0.00           H  
ATOM   1369  HE  ARG A  95     -27.501  11.063  -8.154  1.00  0.00           H  
ATOM   1370 HH11 ARG A  95     -29.649  12.404  -5.765  1.00  0.00           H  
ATOM   1371 HH12 ARG A  95     -28.640  13.773  -5.435  1.00  0.00           H  
ATOM   1372 HH21 ARG A  95     -26.163  12.861  -7.728  1.00  0.00           H  
ATOM   1373 HH22 ARG A  95     -26.657  14.031  -6.552  1.00  0.00           H  
ATOM   1374  N   ASP A  96     -30.596   7.013  -4.208  1.00  0.00           N  
ATOM   1375  CA  ASP A  96     -31.761   6.165  -4.428  1.00  0.00           C  
ATOM   1376  C   ASP A  96     -32.336   6.384  -5.824  1.00  0.00           C  
ATOM   1377  O   ASP A  96     -32.081   7.408  -6.459  1.00  0.00           O  
ATOM   1378  CB  ASP A  96     -32.832   6.447  -3.373  1.00  0.00           C  
ATOM   1379  CG  ASP A  96     -33.773   5.275  -3.176  1.00  0.00           C  
ATOM   1380  OD1 ASP A  96     -33.443   4.378  -2.373  1.00  0.00           O  
ATOM   1381  OD2 ASP A  96     -34.840   5.255  -3.826  1.00  0.00           O  
ATOM   1382  H   ASP A  96     -30.596   7.639  -3.453  1.00  0.00           H  
ATOM   1383  HA  ASP A  96     -31.444   5.137  -4.341  1.00  0.00           H  
ATOM   1384  HB2 ASP A  96     -32.350   6.659  -2.429  1.00  0.00           H  
ATOM   1385  HB3 ASP A  96     -33.411   7.305  -3.678  1.00  0.00           H  
ATOM   1386  N   LYS A  97     -33.112   5.415  -6.298  1.00  0.00           N  
ATOM   1387  CA  LYS A  97     -33.723   5.501  -7.619  1.00  0.00           C  
ATOM   1388  C   LYS A  97     -35.031   4.717  -7.665  1.00  0.00           C  
ATOM   1389  O   LYS A  97     -35.364   3.989  -6.728  1.00  0.00           O  
ATOM   1390  CB  LYS A  97     -32.761   4.971  -8.684  1.00  0.00           C  
ATOM   1391  CG  LYS A  97     -32.085   3.667  -8.299  1.00  0.00           C  
ATOM   1392  CD  LYS A  97     -30.858   3.909  -7.436  1.00  0.00           C  
ATOM   1393  CE  LYS A  97     -30.054   2.632  -7.240  1.00  0.00           C  
ATOM   1394  NZ  LYS A  97     -30.725   1.694  -6.299  1.00  0.00           N  
ATOM   1395  H   LYS A  97     -33.279   4.623  -5.745  1.00  0.00           H  
ATOM   1396  HA  LYS A  97     -33.934   6.540  -7.820  1.00  0.00           H  
ATOM   1397  HB2 LYS A  97     -33.310   4.811  -9.601  1.00  0.00           H  
ATOM   1398  HB3 LYS A  97     -31.994   5.712  -8.860  1.00  0.00           H  
ATOM   1399  HG2 LYS A  97     -32.785   3.059  -7.747  1.00  0.00           H  
ATOM   1400  HG3 LYS A  97     -31.785   3.148  -9.199  1.00  0.00           H  
ATOM   1401  HD2 LYS A  97     -30.230   4.645  -7.916  1.00  0.00           H  
ATOM   1402  HD3 LYS A  97     -31.175   4.277  -6.470  1.00  0.00           H  
ATOM   1403  HE2 LYS A  97     -29.935   2.148  -8.196  1.00  0.00           H  
ATOM   1404  HE3 LYS A  97     -29.083   2.892  -6.844  1.00  0.00           H  
ATOM   1405  HZ1 LYS A  97     -31.057   0.851  -6.812  1.00  0.00           H  
ATOM   1406  HZ2 LYS A  97     -31.544   2.157  -5.854  1.00  0.00           H  
ATOM   1407  HZ3 LYS A  97     -30.062   1.395  -5.556  1.00  0.00           H  
ATOM   1408  N   LEU A  98     -35.768   4.869  -8.760  1.00  0.00           N  
ATOM   1409  CA  LEU A  98     -37.040   4.174  -8.928  1.00  0.00           C  
ATOM   1410  C   LEU A  98     -36.883   2.969  -9.852  1.00  0.00           C  
ATOM   1411  O   LEU A  98     -36.096   2.981 -10.799  1.00  0.00           O  
ATOM   1412  CB  LEU A  98     -38.095   5.128  -9.489  1.00  0.00           C  
ATOM   1413  CG  LEU A  98     -38.367   6.387  -8.666  1.00  0.00           C  
ATOM   1414  CD1 LEU A  98     -39.083   7.432  -9.509  1.00  0.00           C  
ATOM   1415  CD2 LEU A  98     -39.183   6.048  -7.427  1.00  0.00           C  
ATOM   1416  H   LEU A  98     -35.451   5.462  -9.472  1.00  0.00           H  
ATOM   1417  HA  LEU A  98     -37.359   3.827  -7.957  1.00  0.00           H  
ATOM   1418  HB2 LEU A  98     -37.771   5.439 -10.471  1.00  0.00           H  
ATOM   1419  HB3 LEU A  98     -39.022   4.580  -9.576  1.00  0.00           H  
ATOM   1420  HG  LEU A  98     -37.426   6.809  -8.343  1.00  0.00           H  
ATOM   1421 HD11 LEU A  98     -38.380   7.889 -10.188  1.00  0.00           H  
ATOM   1422 HD12 LEU A  98     -39.504   8.188  -8.863  1.00  0.00           H  
ATOM   1423 HD13 LEU A  98     -39.873   6.959 -10.073  1.00  0.00           H  
ATOM   1424 HD21 LEU A  98     -38.796   5.145  -6.978  1.00  0.00           H  
ATOM   1425 HD22 LEU A  98     -40.215   5.896  -7.707  1.00  0.00           H  
ATOM   1426 HD23 LEU A  98     -39.117   6.860  -6.719  1.00  0.00           H  
ATOM   1427  N   PRO A  99     -37.653   1.906  -9.575  1.00  0.00           N  
ATOM   1428  CA  PRO A  99     -37.619   0.676 -10.371  1.00  0.00           C  
ATOM   1429  C   PRO A  99     -38.218   0.868 -11.761  1.00  0.00           C  
ATOM   1430  O   PRO A  99     -38.076   0.011 -12.632  1.00  0.00           O  
ATOM   1431  CB  PRO A  99     -38.471  -0.298  -9.553  1.00  0.00           C  
ATOM   1432  CG  PRO A  99     -39.388   0.570  -8.764  1.00  0.00           C  
ATOM   1433  CD  PRO A  99     -38.614   1.825  -8.463  1.00  0.00           C  
ATOM   1434  HA  PRO A  99     -36.615   0.290 -10.462  1.00  0.00           H  
ATOM   1435  HB2 PRO A  99     -39.019  -0.949 -10.221  1.00  0.00           H  
ATOM   1436  HB3 PRO A  99     -37.834  -0.886  -8.910  1.00  0.00           H  
ATOM   1437  HG2 PRO A  99     -40.266   0.803  -9.347  1.00  0.00           H  
ATOM   1438  HG3 PRO A  99     -39.666   0.073  -7.846  1.00  0.00           H  
ATOM   1439  HD2 PRO A  99     -39.271   2.682  -8.456  1.00  0.00           H  
ATOM   1440  HD3 PRO A  99     -38.101   1.733  -7.516  1.00  0.00           H  
ATOM   1441  N   SER A 100     -38.885   2.000 -11.961  1.00  0.00           N  
ATOM   1442  CA  SER A 100     -39.507   2.304 -13.245  1.00  0.00           C  
ATOM   1443  C   SER A 100     -40.557   1.256 -13.602  1.00  0.00           C  
ATOM   1444  O   SER A 100     -40.735   0.910 -14.770  1.00  0.00           O  
ATOM   1445  CB  SER A 100     -38.446   2.375 -14.345  1.00  0.00           C  
ATOM   1446  OG  SER A 100     -37.763   3.616 -14.316  1.00  0.00           O  
ATOM   1447  H   SER A 100     -38.962   2.646 -11.227  1.00  0.00           H  
ATOM   1448  HA  SER A 100     -39.990   3.266 -13.160  1.00  0.00           H  
ATOM   1449  HB2 SER A 100     -37.730   1.580 -14.203  1.00  0.00           H  
ATOM   1450  HB3 SER A 100     -38.923   2.262 -15.308  1.00  0.00           H  
ATOM   1451  HG  SER A 100     -37.692   3.921 -13.409  1.00  0.00           H  
ATOM   1452  N   THR A 101     -41.249   0.752 -12.584  1.00  0.00           N  
ATOM   1453  CA  THR A 101     -42.281  -0.258 -12.788  1.00  0.00           C  
ATOM   1454  C   THR A 101     -43.654   0.384 -12.952  1.00  0.00           C  
ATOM   1455  O   THR A 101     -43.988   1.342 -12.255  1.00  0.00           O  
ATOM   1456  CB  THR A 101     -42.329  -1.255 -11.616  1.00  0.00           C  
ATOM   1457  OG1 THR A 101     -43.285  -2.286 -11.890  1.00  0.00           O  
ATOM   1458  CG2 THR A 101     -42.695  -0.549 -10.319  1.00  0.00           C  
ATOM   1459  H   THR A 101     -41.061   1.067 -11.676  1.00  0.00           H  
ATOM   1460  HA  THR A 101     -42.040  -0.803 -13.688  1.00  0.00           H  
ATOM   1461  HB  THR A 101     -41.352  -1.702 -11.503  1.00  0.00           H  
ATOM   1462  HG1 THR A 101     -44.106  -1.890 -12.190  1.00  0.00           H  
ATOM   1463 HG21 THR A 101     -42.156  -1.000  -9.499  1.00  0.00           H  
ATOM   1464 HG22 THR A 101     -43.757  -0.641 -10.146  1.00  0.00           H  
ATOM   1465 HG23 THR A 101     -42.431   0.495 -10.391  1.00  0.00           H  
ATOM   1466  N   GLU A 102     -44.445  -0.149 -13.877  1.00  0.00           N  
ATOM   1467  CA  GLU A 102     -45.783   0.373 -14.131  1.00  0.00           C  
ATOM   1468  C   GLU A 102     -46.769  -0.123 -13.078  1.00  0.00           C  
ATOM   1469  O   GLU A 102     -47.334  -1.209 -13.204  1.00  0.00           O  
ATOM   1470  CB  GLU A 102     -46.259  -0.038 -15.526  1.00  0.00           C  
ATOM   1471  CG  GLU A 102     -47.709   0.318 -15.804  1.00  0.00           C  
ATOM   1472  CD  GLU A 102     -48.314  -0.521 -16.913  1.00  0.00           C  
ATOM   1473  OE1 GLU A 102     -47.906  -0.344 -18.080  1.00  0.00           O  
ATOM   1474  OE2 GLU A 102     -49.195  -1.353 -16.614  1.00  0.00           O  
ATOM   1475  H   GLU A 102     -44.122  -0.911 -14.401  1.00  0.00           H  
ATOM   1476  HA  GLU A 102     -45.732   1.450 -14.081  1.00  0.00           H  
ATOM   1477  HB2 GLU A 102     -45.641   0.453 -16.264  1.00  0.00           H  
ATOM   1478  HB3 GLU A 102     -46.147  -1.107 -15.630  1.00  0.00           H  
ATOM   1479  HG2 GLU A 102     -48.284   0.164 -14.903  1.00  0.00           H  
ATOM   1480  HG3 GLU A 102     -47.762   1.359 -16.090  1.00  0.00           H  
ATOM   1481  N   VAL A 103     -46.971   0.681 -12.039  1.00  0.00           N  
ATOM   1482  CA  VAL A 103     -47.890   0.326 -10.964  1.00  0.00           C  
ATOM   1483  C   VAL A 103     -49.226  -0.155 -11.519  1.00  0.00           C  
ATOM   1484  O   VAL A 103     -49.658   0.280 -12.586  1.00  0.00           O  
ATOM   1485  CB  VAL A 103     -48.137   1.517 -10.020  1.00  0.00           C  
ATOM   1486  CG1 VAL A 103     -46.836   1.963  -9.370  1.00  0.00           C  
ATOM   1487  CG2 VAL A 103     -48.787   2.668 -10.774  1.00  0.00           C  
ATOM   1488  H   VAL A 103     -46.491   1.535 -11.995  1.00  0.00           H  
ATOM   1489  HA  VAL A 103     -47.441  -0.473 -10.392  1.00  0.00           H  
ATOM   1490  HB  VAL A 103     -48.812   1.199  -9.239  1.00  0.00           H  
ATOM   1491 HG11 VAL A 103     -47.049   2.688  -8.597  1.00  0.00           H  
ATOM   1492 HG12 VAL A 103     -46.338   1.107  -8.936  1.00  0.00           H  
ATOM   1493 HG13 VAL A 103     -46.196   2.411 -10.116  1.00  0.00           H  
ATOM   1494 HG21 VAL A 103     -48.977   2.368 -11.793  1.00  0.00           H  
ATOM   1495 HG22 VAL A 103     -49.720   2.930 -10.296  1.00  0.00           H  
ATOM   1496 HG23 VAL A 103     -48.128   3.522 -10.766  1.00  0.00           H  
ATOM   1497  N   SER A 104     -49.876  -1.053 -10.786  1.00  0.00           N  
ATOM   1498  CA  SER A 104     -51.163  -1.596 -11.207  1.00  0.00           C  
ATOM   1499  C   SER A 104     -52.222  -0.499 -11.265  1.00  0.00           C  
ATOM   1500  O   SER A 104     -52.137   0.500 -10.552  1.00  0.00           O  
ATOM   1501  CB  SER A 104     -51.611  -2.703 -10.251  1.00  0.00           C  
ATOM   1502  OG  SER A 104     -52.432  -3.648 -10.914  1.00  0.00           O  
ATOM   1503  H   SER A 104     -49.479  -1.360  -9.944  1.00  0.00           H  
ATOM   1504  HA  SER A 104     -51.040  -2.013 -12.195  1.00  0.00           H  
ATOM   1505  HB2 SER A 104     -50.741  -3.210  -9.861  1.00  0.00           H  
ATOM   1506  HB3 SER A 104     -52.170  -2.267  -9.436  1.00  0.00           H  
ATOM   1507  HG  SER A 104     -51.881  -4.315 -11.330  1.00  0.00           H  
ATOM   1508  N   GLY A 105     -53.221  -0.694 -12.120  1.00  0.00           N  
ATOM   1509  CA  GLY A 105     -54.283   0.286 -12.256  1.00  0.00           C  
ATOM   1510  C   GLY A 105     -55.494  -0.049 -11.408  1.00  0.00           C  
ATOM   1511  O   GLY A 105     -55.407  -0.798 -10.434  1.00  0.00           O  
ATOM   1512  H   GLY A 105     -53.237  -1.509 -12.663  1.00  0.00           H  
ATOM   1513  HA2 GLY A 105     -53.906   1.253 -11.960  1.00  0.00           H  
ATOM   1514  HA3 GLY A 105     -54.585   0.330 -13.293  1.00  0.00           H  
ATOM   1515  N   PRO A 106     -56.654   0.513 -11.778  1.00  0.00           N  
ATOM   1516  CA  PRO A 106     -57.909   0.284 -11.056  1.00  0.00           C  
ATOM   1517  C   PRO A 106     -58.429  -1.138 -11.234  1.00  0.00           C  
ATOM   1518  O   PRO A 106     -57.854  -1.931 -11.979  1.00  0.00           O  
ATOM   1519  CB  PRO A 106     -58.872   1.288 -11.693  1.00  0.00           C  
ATOM   1520  CG  PRO A 106     -58.324   1.526 -13.058  1.00  0.00           C  
ATOM   1521  CD  PRO A 106     -56.829   1.414 -12.929  1.00  0.00           C  
ATOM   1522  HA  PRO A 106     -57.806   0.500 -10.003  1.00  0.00           H  
ATOM   1523  HB2 PRO A 106     -59.865   0.863 -11.734  1.00  0.00           H  
ATOM   1524  HB3 PRO A 106     -58.888   2.197 -11.111  1.00  0.00           H  
ATOM   1525  HG2 PRO A 106     -58.699   0.779 -13.740  1.00  0.00           H  
ATOM   1526  HG3 PRO A 106     -58.596   2.515 -13.396  1.00  0.00           H  
ATOM   1527  HD2 PRO A 106     -56.405   0.984 -13.824  1.00  0.00           H  
ATOM   1528  HD3 PRO A 106     -56.394   2.382 -12.730  1.00  0.00           H  
ATOM   1529  N   SER A 107     -59.520  -1.455 -10.543  1.00  0.00           N  
ATOM   1530  CA  SER A 107     -60.116  -2.784 -10.622  1.00  0.00           C  
ATOM   1531  C   SER A 107     -61.115  -2.864 -11.772  1.00  0.00           C  
ATOM   1532  O   SER A 107     -61.459  -1.851 -12.382  1.00  0.00           O  
ATOM   1533  CB  SER A 107     -60.809  -3.134  -9.303  1.00  0.00           C  
ATOM   1534  OG  SER A 107     -61.797  -2.173  -8.976  1.00  0.00           O  
ATOM   1535  H   SER A 107     -59.933  -0.779  -9.965  1.00  0.00           H  
ATOM   1536  HA  SER A 107     -59.321  -3.493 -10.801  1.00  0.00           H  
ATOM   1537  HB2 SER A 107     -61.280  -4.101  -9.394  1.00  0.00           H  
ATOM   1538  HB3 SER A 107     -60.075  -3.164  -8.512  1.00  0.00           H  
ATOM   1539  HG  SER A 107     -62.660  -2.592  -8.963  1.00  0.00           H  
ATOM   1540  N   SER A 108     -61.578  -4.076 -12.063  1.00  0.00           N  
ATOM   1541  CA  SER A 108     -62.535  -4.290 -13.141  1.00  0.00           C  
ATOM   1542  C   SER A 108     -61.863  -4.135 -14.502  1.00  0.00           C  
ATOM   1543  O   SER A 108     -62.428  -3.545 -15.423  1.00  0.00           O  
ATOM   1544  CB  SER A 108     -63.701  -3.306 -13.021  1.00  0.00           C  
ATOM   1545  OG  SER A 108     -64.886  -3.849 -13.575  1.00  0.00           O  
ATOM   1546  H   SER A 108     -61.267  -4.844 -11.540  1.00  0.00           H  
ATOM   1547  HA  SER A 108     -62.914  -5.297 -13.052  1.00  0.00           H  
ATOM   1548  HB2 SER A 108     -63.875  -3.084 -11.979  1.00  0.00           H  
ATOM   1549  HB3 SER A 108     -63.455  -2.395 -13.548  1.00  0.00           H  
ATOM   1550  HG  SER A 108     -65.297  -4.439 -12.938  1.00  0.00           H  
ATOM   1551  N   GLY A 109     -60.652  -4.672 -14.622  1.00  0.00           N  
ATOM   1552  CA  GLY A 109     -59.922  -4.583 -15.872  1.00  0.00           C  
ATOM   1553  C   GLY A 109     -58.746  -3.631 -15.792  1.00  0.00           C  
ATOM   1554  O   GLY A 109     -58.428  -3.117 -14.719  1.00  0.00           O  
ATOM   1555  H   GLY A 109     -60.252  -5.131 -13.854  1.00  0.00           H  
ATOM   1556  HA2 GLY A 109     -59.559  -5.566 -16.135  1.00  0.00           H  
ATOM   1557  HA3 GLY A 109     -60.595  -4.241 -16.646  1.00  0.00           H  
TER    1558      GLY A 109                                                      
END
MOLECULE T0469.pdb
ATOM     34  N   GLN     3     -11.627   8.047  -2.168  1.00 30.01           N 
ATOM     35  CA  GLN     3     -10.194   8.122  -1.859  1.00 44.33           C 
ATOM     36  C   GLN     3      -9.345   7.641  -3.041  1.00  1.05           C 
ATOM     37  O   GLN     3      -9.602   6.580  -3.610  1.00 22.43           O 
ATOM     38  CB  GLN     3      -9.859   7.292  -0.611  1.00 15.35           C 
ATOM     39  CG  GLN     3     -10.597   7.739   0.646  1.00 20.34           C 
ATOM     40  CD  GLN     3     -10.090   7.063   1.912  1.00 71.03           C 
ATOM     41  OE1 GLN     3     -10.146   7.632   2.994  1.00 40.53           O 
ATOM     42  NE2 GLN     3      -9.579   5.849   1.794  1.00 34.32           N 
ATOM     43  H   GLN     3     -12.030   7.173  -2.365  1.00 38.87           H 
ATOM     44  HA  GLN     3      -9.952   9.158  -1.661  1.00  1.11           H 
ATOM     45 3HB  GLN     3      -8.796   7.360  -0.423  1.00 38.87           H 
ATOM     46 2HB  GLN     3     -10.114   6.259  -0.802  1.00 38.87           H 
ATOM     47 3HG  GLN     3     -11.648   7.509   0.531  1.00 38.87           H 
ATOM     48 2HG  GLN     3     -10.477   8.807   0.757  1.00 38.87           H 
ATOM     49 1HE2 GLN     3      -9.546   5.443   0.906  1.00 38.87           H 
ATOM     50 2HE2 GLN     3      -9.262   5.406   2.608  1.00 38.87           H 
ATOM     51  N   LYS     4      -8.332   8.429  -3.406  1.00 22.44           N 
ATOM     52  CA  LYS     4      -7.409   8.050  -4.485  1.00 75.21           C 
ATOM     53  C   LYS     4      -6.629   6.774  -4.137  1.00 11.23           C 
ATOM     54  O   LYS     4      -6.107   6.090  -5.023  1.00 54.32           O 
ATOM     55  CB  LYS     4      -6.437   9.199  -4.787  1.00 13.44           C 
ATOM     56  CG  LYS     4      -7.117  10.443  -5.351  1.00 21.02           C 
ATOM     57  CD  LYS     4      -6.106  11.504  -5.782  1.00 42.12           C 
ATOM     58  CE  LYS     4      -5.137  10.973  -6.836  1.00 71.40           C 
ATOM     59  NZ  LYS     4      -5.843  10.455  -8.039  1.00 62.12           N 
ATOM     60  H   LYS     4      -8.205   9.286  -2.948  1.00 38.87           H 
ATOM     61  HA  LYS     4      -8.002   7.858  -5.369  1.00 34.11           H 
ATOM     62 3HB  LYS     4      -5.705   8.856  -5.506  1.00 38.87           H 
ATOM     63 2HB  LYS     4      -5.928   9.474  -3.874  1.00 38.87           H 
ATOM     64 3HG  LYS     4      -7.762  10.863  -4.589  1.00 38.87           H 
ATOM     65 2HG  LYS     4      -7.712  10.160  -6.207  1.00 38.87           H 
ATOM     66 3HD  LYS     4      -5.543  11.825  -4.915  1.00 38.87           H 
ATOM     67 2HD  LYS     4      -6.640  12.347  -6.195  1.00 38.87           H 
ATOM     68 3HE  LYS     4      -4.552  10.173  -6.401  1.00 38.87           H 
ATOM     69 2HE  LYS     4      -4.480  11.772  -7.139  1.00 38.87           H 
ATOM     70 1HZ  LYS     4      -6.407   9.616  -7.794  1.00 38.87           H 
ATOM     71 2HZ  LYS     4      -5.154  10.192  -8.772  1.00 38.87           H 
ATOM     72 3HZ  LYS     4      -6.476  11.184  -8.427  1.00 38.87           H 
ATOM     73  N   PHE     5      -6.530   6.483  -2.839  1.00 50.12           N 
ATOM     74  CA  PHE     5      -5.961   5.220  -2.356  1.00 63.21           C 
ATOM     75  C   PHE     5      -7.007   4.431  -1.553  1.00  2.41           C 
ATOM     76  O   PHE     5      -7.454   4.866  -0.486  1.00  4.53           O 
ATOM     77  CB  PHE     5      -4.720   5.485  -1.493  1.00 42.04           C 
ATOM     78  CG  PHE     5      -3.603   6.170  -2.243  1.00 45.35           C 
ATOM     79  CD1 PHE     5      -3.462   7.551  -2.205  1.00  2.03           C 
ATOM     80  CD2 PHE     5      -2.699   5.431  -2.992  1.00 13.44           C 
ATOM     81  CE1 PHE     5      -2.444   8.178  -2.899  1.00 20.41           C 
ATOM     82  CE2 PHE     5      -1.680   6.054  -3.687  1.00 24.04           C 
ATOM     83  CZ  PHE     5      -1.551   7.427  -3.638  1.00 15.13           C 
ATOM     84  H   PHE     5      -6.837   7.141  -2.183  1.00 38.87           H 
ATOM     85  HA  PHE     5      -5.671   4.634  -3.217  1.00 20.31           H 
ATOM     86 3HB  PHE     5      -4.342   4.545  -1.116  1.00 38.87           H 
ATOM     87 2HB  PHE     5      -4.998   6.115  -0.658  1.00 38.87           H 
ATOM     88  HD1 PHE     5      -4.158   8.140  -1.624  1.00 55.23           H 
ATOM     89  HD2 PHE     5      -2.795   4.354  -3.031  1.00 60.12           H 
ATOM     90  HE1 PHE     5      -2.346   9.253  -2.861  1.00 54.03           H 
ATOM     91  HE2 PHE     5      -0.982   5.466  -4.265  1.00 44.45           H 
ATOM     92  HZ  PHE     5      -0.755   7.915  -4.182  1.00 41.14           H 
ATOM     93  N   THR     6      -7.403   3.276  -2.079  1.00 42.34           N 
ATOM     94  CA  THR     6      -8.414   2.428  -1.430  1.00 54.13           C 
ATOM     95  C   THR     6      -7.872   1.028  -1.124  1.00 21.43           C 
ATOM     96  O   THR     6      -6.877   0.596  -1.693  1.00 52.30           O 
ATOM     97  CB  THR     6      -9.687   2.286  -2.300  1.00 24.45           C 
ATOM     98  OG1 THR     6     -10.596   1.350  -1.693  1.00 74.03           O 
ATOM     99  CG2 THR     6      -9.342   1.821  -3.711  1.00 72.10           C 
ATOM    100  H   THR     6      -7.004   2.980  -2.926  1.00 38.87           H 
ATOM    101  HA  THR     6      -8.697   2.899  -0.497  1.00 22.22           H 
ATOM    102  HB  THR     6     -10.170   3.251  -2.364  1.00 75.32           H 
ATOM    103  HG1 THR     6     -11.497   1.538  -1.990  1.00  5.54           H 
ATOM    104 1HG2 THR     6      -8.875   0.849  -3.667  1.00 38.87           H 
ATOM    105 2HG2 THR     6      -8.661   2.526  -4.168  1.00 38.87           H 
ATOM    106 3HG2 THR     6     -10.244   1.760  -4.304  1.00 38.87           H 
ATOM    107  N   LYS     7      -8.550   0.316  -0.232  1.00 40.34           N 
ATOM    108  CA  LYS     7      -8.153  -1.048   0.138  1.00 44.32           C 
ATOM    109  C   LYS     7      -8.366  -2.029  -1.025  1.00 74.01           C 
ATOM    110  O   LYS     7      -7.759  -3.102  -1.067  1.00 64.01           O 
ATOM    111  CB  LYS     7      -8.956  -1.507   1.361  1.00 34.42           C 
ATOM    112  CG  LYS     7     -10.470  -1.494   1.154  1.00 41.34           C 
ATOM    113  CD  LYS     7     -11.213  -1.943   2.409  1.00  3.35           C 
ATOM    114  CE  LYS     7     -10.922  -1.033   3.598  1.00 25.21           C 
ATOM    115  NZ  LYS     7     -11.454  -1.588   4.872  1.00 70.34           N 
ATOM    116  H   LYS     7      -9.347   0.711   0.182  1.00 38.87           H 
ATOM    117  HA  LYS     7      -7.103  -1.031   0.393  1.00  2.20           H 
ATOM    118 3HB  LYS     7      -8.724  -0.856   2.192  1.00 38.87           H 
ATOM    119 2HB  LYS     7      -8.658  -2.515   1.615  1.00 38.87           H 
ATOM    120 3HG  LYS     7     -10.718  -2.164   0.342  1.00 38.87           H 
ATOM    121 2HG  LYS     7     -10.782  -0.491   0.900  1.00 38.87           H 
ATOM    122 3HD  LYS     7     -10.907  -2.951   2.655  1.00 38.87           H 
ATOM    123 2HD  LYS     7     -12.276  -1.930   2.211  1.00 38.87           H 
ATOM    124 3HE  LYS     7     -11.374  -0.068   3.420  1.00 38.87           H 
ATOM    125 2HE  LYS     7      -9.853  -0.916   3.694  1.00 38.87           H 
ATOM    126 1HZ  LYS     7     -12.485  -1.697   4.812  1.00 38.87           H 
ATOM    127 2HZ  LYS     7     -11.229  -0.946   5.660  1.00 38.87           H 
ATOM    128 3HZ  LYS     7     -11.028  -2.517   5.062  1.00 38.87           H 
ATOM    129  N   ASP     8      -9.229  -1.640  -1.962  1.00 23.15           N 
ATOM    130  CA  ASP     8      -9.599  -2.495  -3.095  1.00 40.32           C 
ATOM    131  C   ASP     8      -8.509  -2.519  -4.188  1.00 21.33           C 
ATOM    132  O   ASP     8      -8.319  -3.531  -4.864  1.00 43.43           O 
ATOM    133  CB  ASP     8     -10.930  -2.001  -3.681  1.00 25.40           C 
ATOM    134  CG  ASP     8     -11.526  -2.968  -4.688  1.00 12.34           C 
ATOM    135  OD1 ASP     8     -12.169  -3.949  -4.264  1.00 72.21           O 
ATOM    136  OD2 ASP     8     -11.372  -2.746  -5.906  1.00 45.15           O 
ATOM    137  H   ASP     8      -9.637  -0.751  -1.888  1.00 38.87           H 
ATOM    138  HA  ASP     8      -9.737  -3.500  -2.719  1.00  4.03           H 
ATOM    139 3HB  ASP     8     -10.768  -1.050  -4.170  1.00 38.87           H 
ATOM    140 2HB  ASP     8     -11.639  -1.867  -2.878  1.00 38.87           H 
ATOM    141  N   MET     9      -7.786  -1.406  -4.347  1.00 22.22           N 
ATOM    142  CA  MET     9      -6.770  -1.285  -5.407  1.00 21.14           C 
ATOM    143  C   MET     9      -5.493  -2.072  -5.060  1.00 74.21           C 
ATOM    144  O   MET     9      -5.230  -2.370  -3.894  1.00 20.44           O 
ATOM    145  CB  MET     9      -6.430   0.193  -5.658  1.00 15.42           C 
ATOM    146  CG  MET     9      -5.739   0.873  -4.485  1.00 52.44           C 
ATOM    147  SD  MET     9      -5.650   2.667  -4.666  1.00 14.13           S 
ATOM    148  CE  MET     9      -4.684   2.823  -6.167  1.00 12.05           C 
ATOM    149  H   MET     9      -7.929  -0.658  -3.733  1.00 38.87           H 
ATOM    150  HA  MET     9      -7.192  -1.701  -6.312  1.00 53.05           H 
ATOM    151 3HB  MET     9      -7.343   0.732  -5.871  1.00 38.87           H 
ATOM    152 2HB  MET     9      -5.778   0.261  -6.519  1.00 38.87           H 
ATOM    153 3HG  MET     9      -4.734   0.483  -4.400  1.00 38.87           H 
ATOM    154 2HG  MET     9      -6.286   0.645  -3.585  1.00 38.87           H 
ATOM    155 1HE  MET     9      -4.579   3.868  -6.416  1.00 38.87           H 
ATOM    156 2HE  MET     9      -5.185   2.308  -6.974  1.00 38.87           H 
ATOM    157 3HE  MET     9      -3.707   2.389  -6.013  1.00 38.87           H 
ATOM    158  N   THR    10      -4.699  -2.398  -6.079  1.00 41.40           N 
ATOM    159  CA  THR    10      -3.476  -3.198  -5.894  1.00 42.12           C 
ATOM    160  C   THR    10      -2.262  -2.333  -5.524  1.00 34.11           C 
ATOM    161  O   THR    10      -2.241  -1.123  -5.777  1.00 60.51           O 
ATOM    162  CB  THR    10      -3.126  -3.993  -7.171  1.00  4.44           C 
ATOM    163  OG1 THR    10      -2.801  -3.085  -8.235  1.00 24.12           O 
ATOM    164  CG2 THR    10      -4.283  -4.893  -7.600  1.00 42.43           C 
ATOM    165  H   THR    10      -4.938  -2.101  -6.981  1.00 38.87           H 
ATOM    166  HA  THR    10      -3.656  -3.905  -5.095  1.00 52.02           H 
ATOM    167  HB  THR    10      -2.263  -4.615  -6.966  1.00 32.44           H 
ATOM    168  HG1 THR    10      -2.704  -3.581  -9.059  1.00 21.12           H 
ATOM    169 1HG2 THR    10      -5.146  -4.286  -7.834  1.00 38.87           H 
ATOM    170 2HG2 THR    10      -4.530  -5.573  -6.797  1.00 38.87           H 
ATOM    171 3HG2 THR    10      -3.995  -5.460  -8.474  1.00 38.87           H 
ATOM    172  N   PHE    11      -1.244  -2.964  -4.935  1.00 75.24           N 
ATOM    173  CA  PHE    11       0.007  -2.274  -4.599  1.00  0.34           C 
ATOM    174  C   PHE    11       0.663  -1.656  -5.845  1.00 12.02           C 
ATOM    175  O   PHE    11       1.131  -0.516  -5.810  1.00 75.13           O 
ATOM    176  CB  PHE    11       0.990  -3.241  -3.921  1.00 53.52           C 
ATOM    177  CG  PHE    11       0.574  -3.675  -2.535  1.00  4.04           C 
ATOM    178  CD1 PHE    11       0.923  -2.917  -1.426  1.00 20.14           C 
ATOM    179  CD2 PHE    11      -0.156  -4.837  -2.340  1.00 72.14           C 
ATOM    180  CE1 PHE    11       0.553  -3.310  -0.154  1.00 60.41           C 
ATOM    181  CE2 PHE    11      -0.529  -5.235  -1.070  1.00 23.33           C 
ATOM    182  CZ  PHE    11      -0.174  -4.469   0.024  1.00 62.13           C 
ATOM    183  H   PHE    11      -1.338  -3.919  -4.714  1.00 38.87           H 
ATOM    184  HA  PHE    11      -0.235  -1.479  -3.905  1.00 35.22           H 
ATOM    185 3HB  PHE    11       1.957  -2.763  -3.843  1.00 38.87           H 
ATOM    186 2HB  PHE    11       1.085  -4.128  -4.529  1.00 38.87           H 
ATOM    187  HD1 PHE    11       1.490  -2.008  -1.562  1.00 20.15           H 
ATOM    188  HD2 PHE    11      -0.434  -5.437  -3.193  1.00 24.11           H 
ATOM    189  HE1 PHE    11       0.832  -2.711   0.701  1.00 60.41           H 
ATOM    190  HE2 PHE    11      -1.098  -6.142  -0.933  1.00  2.33           H 
ATOM    191  HZ  PHE    11      -0.465  -4.779   1.019  1.00 40.11           H 
ATOM    192  N   ALA    12       0.680  -2.410  -6.947  1.00 70.34           N 
ATOM    193  CA  ALA    12       1.281  -1.939  -8.205  1.00 33.55           C 
ATOM    194  C   ALA    12       0.640  -0.629  -8.686  1.00 13.22           C 
ATOM    195  O   ALA    12       1.330   0.279  -9.156  1.00 52.42           O 
ATOM    196  CB  ALA    12       1.163  -3.010  -9.286  1.00 54.15           C 
ATOM    197  H   ALA    12       0.275  -3.304  -6.919  1.00 38.87           H 
ATOM    198  HA  ALA    12       2.335  -1.765  -8.022  1.00 64.43           H 
ATOM    199 1HB  ALA    12       1.660  -2.672 -10.185  1.00 38.87           H 
ATOM    200 2HB  ALA    12       0.120  -3.193  -9.500  1.00 38.87           H 
ATOM    201 3HB  ALA    12       1.625  -3.924  -8.943  1.00 38.87           H 
ATOM    202  N   GLN    13      -0.683  -0.532  -8.568  1.00 73.00           N 
ATOM    203  CA  GLN    13      -1.398   0.686  -8.958  1.00 55.15           C 
ATOM    204  C   GLN    13      -1.078   1.850  -8.005  1.00 63.15           C 
ATOM    205  O   GLN    13      -0.847   2.976  -8.447  1.00  3.14           O 
ATOM    206  CB  GLN    13      -2.910   0.428  -9.010  1.00  4.02           C 
ATOM    207  CG  GLN    13      -3.316  -0.584 -10.078  1.00 34.02           C 
ATOM    208  CD  GLN    13      -4.820  -0.787 -10.183  1.00 70.24           C 
ATOM    209  OE1 GLN    13      -5.295  -1.868 -10.517  1.00 23.12           O 
ATOM    210  NE2 GLN    13      -5.584   0.254  -9.915  1.00 41.33           N 
ATOM    211  H   GLN    13      -1.191  -1.297  -8.216  1.00 38.87           H 
ATOM    212  HA  GLN    13      -1.059   0.957  -9.951  1.00 11.24           H 
ATOM    213 3HB  GLN    13      -3.419   1.360  -9.214  1.00 38.87           H 
ATOM    214 2HB  GLN    13      -3.234   0.056  -8.047  1.00 38.87           H 
ATOM    215 3HG  GLN    13      -2.857  -1.535  -9.842  1.00 38.87           H 
ATOM    216 2HG  GLN    13      -2.951  -0.242 -11.035  1.00 38.87           H 
ATOM    217 1HE2 GLN    13      -5.153   1.095  -9.665  1.00 38.87           H 
ATOM    218 2HE2 GLN    13      -6.553   0.137  -9.979  1.00 38.87           H 
ATOM    219  N   ALA    14      -1.047   1.571  -6.700  1.00  1.31           N 
ATOM    220  CA  ALA    14      -0.723   2.593  -5.694  1.00  5.31           C 
ATOM    221  C   ALA    14       0.665   3.211  -5.941  1.00  2.11           C 
ATOM    222  O   ALA    14       0.819   4.437  -5.971  1.00  2.23           O 
ATOM    223  CB  ALA    14      -0.802   2.000  -4.293  1.00 72.04           C 
ATOM    224  H   ALA    14      -1.251   0.656  -6.402  1.00 38.87           H 
ATOM    225  HA  ALA    14      -1.467   3.374  -5.768  1.00 23.12           H 
ATOM    226 1HB  ALA    14      -0.639   2.778  -3.561  1.00 38.87           H 
ATOM    227 2HB  ALA    14      -0.045   1.237  -4.179  1.00 38.87           H 
ATOM    228 3HB  ALA    14      -1.778   1.562  -4.142  1.00 38.87           H 
ATOM    229  N   LEU    15       1.666   2.352  -6.140  1.00 53.00           N 
ATOM    230  CA  LEU    15       3.043   2.799  -6.408  1.00 61.24           C 
ATOM    231  C   LEU    15       3.117   3.723  -7.636  1.00 71.12           C 
ATOM    232  O   LEU    15       3.826   4.728  -7.628  1.00  1.44           O 
ATOM    233  CB  LEU    15       3.962   1.585  -6.618  1.00 53.10           C 
ATOM    234  CG  LEU    15       4.110   0.651  -5.403  1.00 11.51           C 
ATOM    235  CD1 LEU    15       5.003  -0.542  -5.739  1.00 11.14           C 
ATOM    236  CD2 LEU    15       4.658   1.412  -4.198  1.00 15.41           C 
ATOM    237  H   LEU    15       1.477   1.389  -6.101  1.00 38.87           H 
ATOM    238  HA  LEU    15       3.386   3.347  -5.542  1.00 72.23           H 
ATOM    239 3HB  LEU    15       4.947   1.945  -6.885  1.00 38.87           H 
ATOM    240 2HB  LEU    15       3.575   1.007  -7.446  1.00 38.87           H 
ATOM    241  HG  LEU    15       3.135   0.266  -5.138  1.00  1.04           H 
ATOM    242 1HD1 LEU    15       4.546  -1.124  -6.528  1.00 38.87           H 
ATOM    243 2HD1 LEU    15       5.125  -1.162  -4.862  1.00 38.87           H 
ATOM    244 3HD1 LEU    15       5.969  -0.190  -6.068  1.00 38.87           H 
ATOM    245 1HD2 LEU    15       4.760   0.736  -3.361  1.00 38.87           H 
ATOM    246 2HD2 LEU    15       3.978   2.208  -3.933  1.00 38.87           H 
ATOM    247 3HD2 LEU    15       5.625   1.830  -4.441  1.00 38.87           H 
ATOM    248  N   GLN    16       2.375   3.378  -8.690  1.00  1.31           N 
ATOM    249  CA  GLN    16       2.369   4.172  -9.929  1.00 61.42           C 
ATOM    250  C   GLN    16       1.474   5.419  -9.814  1.00 74.42           C 
ATOM    251  O   GLN    16       1.464   6.269 -10.704  1.00 23.42           O 
ATOM    252  CB  GLN    16       1.923   3.300 -11.111  1.00  0.13           C 
ATOM    253  CG  GLN    16       2.841   2.107 -11.372  1.00 55.04           C 
ATOM    254  CD  GLN    16       4.251   2.515 -11.770  1.00 54.54           C 
ATOM    255  OE1 GLN    16       4.561   2.667 -12.949  1.00  2.11           O 
ATOM    256  NE2 GLN    16       5.118   2.697 -10.795  1.00 32.00           N 
ATOM    257  H   GLN    16       1.819   2.571  -8.637  1.00 38.87           H 
ATOM    258  HA  GLN    16       3.384   4.500 -10.108  1.00 53.34           H 
ATOM    259 3HB  GLN    16       1.893   3.906 -12.005  1.00 38.87           H 
ATOM    260 2HB  GLN    16       0.931   2.921 -10.910  1.00 38.87           H 
ATOM    261 3HG  GLN    16       2.417   1.511 -12.167  1.00 38.87           H 
ATOM    262 2HG  GLN    16       2.897   1.512 -10.473  1.00 38.87           H 
ATOM    263 1HE2 GLN    16       4.817   2.564  -9.876  1.00 38.87           H 
ATOM    264 2HE2 GLN    16       6.032   2.966 -11.034  1.00 38.87           H 
ATOM    265  N   THR    17       0.717   5.518  -8.720  1.00 10.44           N 
ATOM    266  CA  THR    17      -0.111   6.706  -8.458  1.00  2.23           C 
ATOM    267  C   THR    17       0.702   7.796  -7.733  1.00 63.00           C 
ATOM    268  O   THR    17       0.578   8.983  -8.031  1.00 23.51           O 
ATOM    269  CB  THR    17      -1.369   6.349  -7.620  1.00 70.42           C 
ATOM    270  OG1 THR    17      -2.182   5.395  -8.327  1.00 42.52           O 
ATOM    271  CG2 THR    17      -2.207   7.586  -7.315  1.00 72.44           C 
ATOM    272  H   THR    17       0.712   4.779  -8.077  1.00 38.87           H 
ATOM    273  HA  THR    17      -0.441   7.098  -9.412  1.00 24.45           H 
ATOM    274  HB  THR    17      -1.047   5.908  -6.685  1.00 42.02           H 
ATOM    275  HG1 THR    17      -1.640   4.636  -8.579  1.00 52.45           H 
ATOM    276 1HG2 THR    17      -3.079   7.300  -6.745  1.00 38.87           H 
ATOM    277 2HG2 THR    17      -2.517   8.051  -8.239  1.00 38.87           H 
ATOM    278 3HG2 THR    17      -1.617   8.288  -6.742  1.00 38.87           H 
ATOM    279  N   HIS    18       1.525   7.382  -6.767  1.00 50.52           N 
ATOM    280  CA  HIS    18       2.451   8.292  -6.072  1.00 51.53           C 
ATOM    281  C   HIS    18       3.724   7.545  -5.632  1.00 31.25           C 
ATOM    282  O   HIS    18       3.657   6.646  -4.799  1.00 60.41           O 
ATOM    283  CB  HIS    18       1.783   8.934  -4.842  1.00 53.14           C 
ATOM    284  CG  HIS    18       0.845  10.060  -5.164  1.00  0.11           C 
ATOM    285  ND1 HIS    18      -0.476   9.869  -5.500  1.00 44.23           N 
ATOM    286  CD2 HIS    18       1.042  11.401  -5.190  1.00 65.24           C 
ATOM    287  CE1 HIS    18      -1.049  11.033  -5.720  1.00 14.31           C 
ATOM    288  NE2 HIS    18      -0.154  11.980  -5.538  1.00 73.21           N 
ATOM    289  H   HIS    18       1.515   6.433  -6.510  1.00 38.87           H 
ATOM    290  HA  HIS    18       2.729   9.074  -6.767  1.00 42.31           H 
ATOM    291 3HB  HIS    18       2.550   9.321  -4.186  1.00 38.87           H 
ATOM    292 2HB  HIS    18       1.221   8.179  -4.313  1.00 38.87           H 
ATOM    293  HD1 HIS    18      -0.923   9.006  -5.581  1.00  0.44           H 
ATOM    294  HD2 HIS    18       1.966  11.919  -4.974  1.00 42.41           H 
ATOM    295  HE1 HIS    18      -2.081  11.186  -5.997  1.00 43.22           H 
ATOM    296  HE2 HIS    18      -0.266  12.914  -5.823  1.00 38.87           H 
ATOM    297  N   PRO    19       4.902   7.911  -6.176  1.00 44.11           N 
ATOM    298  CA  PRO    19       6.182   7.268  -5.806  1.00 61.45           C 
ATOM    299  C   PRO    19       6.439   7.262  -4.282  1.00  3.03           C 
ATOM    300  O   PRO    19       7.054   6.334  -3.750  1.00 32.42           O 
ATOM    301  CB  PRO    19       7.228   8.125  -6.530  1.00 61.40           C 
ATOM    302  CG  PRO    19       6.492   8.706  -7.691  1.00 64.24           C 
ATOM    303  CD  PRO    19       5.090   8.959  -7.201  1.00 13.23           C 
ATOM    304  HA  PRO    19       6.228   6.252  -6.176  1.00 73.34           H 
ATOM    305 3HB  PRO    19       8.051   7.503  -6.854  1.00 38.87           H 
ATOM    306 2HB  PRO    19       7.593   8.898  -5.866  1.00 38.87           H 
ATOM    307 3HG  PRO    19       6.482   8.000  -8.510  1.00 38.87           H 
ATOM    308 2HG  PRO    19       6.957   9.632  -7.999  1.00 38.87           H 
ATOM    309 3HD  PRO    19       4.379   8.843  -8.008  1.00 38.87           H 
ATOM    310 2HD  PRO    19       5.010   9.944  -6.764  1.00 38.87           H 
ATOM    311  N   GLY    20       5.956   8.297  -3.587  1.00 21.51           N 
ATOM    312  CA  GLY    20       6.109   8.377  -2.132  1.00 71.35           C 
ATOM    313  C   GLY    20       5.455   7.215  -1.384  1.00  4.24           C 
ATOM    314  O   GLY    20       5.810   6.920  -0.237  1.00 31.31           O 
ATOM    315  H   GLY    20       5.499   9.021  -4.066  1.00 38.87           H 
ATOM    316 3HA  GLY    20       5.665   9.301  -1.789  1.00 38.87           H 
ATOM    317 2HA  GLY    20       7.164   8.392  -1.895  1.00 38.87           H 
ATOM    318  N   VAL    21       4.496   6.555  -2.036  1.00 12.22           N 
ATOM    319  CA  VAL    21       3.830   5.378  -1.467  1.00  3.14           C 
ATOM    320  C   VAL    21       4.841   4.265  -1.148  1.00 25.24           C 
ATOM    321  O   VAL    21       4.709   3.566  -0.145  1.00 20.22           O 
ATOM    322  CB  VAL    21       2.737   4.831  -2.428  1.00 21.02           C 
ATOM    323  CG1 VAL    21       2.127   3.532  -1.901  1.00 22.41           C 
ATOM    324  CG2 VAL    21       1.649   5.880  -2.649  1.00 64.42           C 
ATOM    325  H   VAL    21       4.228   6.868  -2.926  1.00 38.87           H 
ATOM    326  HA  VAL    21       3.348   5.682  -0.547  1.00 32.31           H 
ATOM    327  HB  VAL    21       3.201   4.620  -3.384  1.00 72.31           H 
ATOM    328 1HG1 VAL    21       2.904   2.789  -1.790  1.00 38.87           H 
ATOM    329 2HG1 VAL    21       1.385   3.171  -2.599  1.00 38.87           H 
ATOM    330 3HG1 VAL    21       1.663   3.714  -0.943  1.00 38.87           H 
ATOM    331 1HG2 VAL    21       0.920   5.504  -3.352  1.00 38.87           H 
ATOM    332 2HG2 VAL    21       2.095   6.783  -3.044  1.00 38.87           H 
ATOM    333 3HG2 VAL    21       1.164   6.101  -1.710  1.00 38.87           H 
ATOM    334  N   ALA    22       5.865   4.125  -1.991  1.00  3.15           N 
ATOM    335  CA  ALA    22       6.918   3.126  -1.775  1.00 70.13           C 
ATOM    336  C   ALA    22       7.591   3.312  -0.404  1.00 44.44           C 
ATOM    337  O   ALA    22       7.781   2.349   0.340  1.00 33.33           O 
ATOM    338  CB  ALA    22       7.957   3.198  -2.890  1.00 74.52           C 
ATOM    339  H   ALA    22       5.917   4.712  -2.776  1.00 38.87           H 
ATOM    340  HA  ALA    22       6.457   2.146  -1.807  1.00 11.14           H 
ATOM    341 1HB  ALA    22       7.476   3.039  -3.845  1.00 38.87           H 
ATOM    342 2HB  ALA    22       8.708   2.436  -2.736  1.00 38.87           H 
ATOM    343 3HB  ALA    22       8.428   4.171  -2.885  1.00 38.87           H 
ATOM    344  N   GLY    23       7.933   4.558  -0.075  1.00 40.23           N 
ATOM    345  CA  GLY    23       8.535   4.858   1.222  1.00 63.24           C 
ATOM    346  C   GLY    23       7.622   4.506   2.392  1.00 72.20           C 
ATOM    347  O   GLY    23       8.058   3.897   3.373  1.00 14.24           O 
ATOM    348  H   GLY    23       7.774   5.282  -0.716  1.00 38.87           H 
ATOM    349 3HA  GLY    23       8.760   5.914   1.264  1.00 38.87           H 
ATOM    350 2HA  GLY    23       9.458   4.302   1.314  1.00 38.87           H 
ATOM    351  N   VAL    24       6.350   4.883   2.280  1.00 11.32           N 
ATOM    352  CA  VAL    24       5.350   4.561   3.304  1.00  4.13           C 
ATOM    353  C   VAL    24       5.216   3.040   3.488  1.00 52.01           C 
ATOM    354  O   VAL    24       5.308   2.528   4.605  1.00 65.42           O 
ATOM    355  CB  VAL    24       3.964   5.165   2.949  1.00 15.43           C 
ATOM    356  CG1 VAL    24       2.918   4.832   4.017  1.00 62.13           C 
ATOM    357  CG2 VAL    24       4.073   6.677   2.755  1.00 55.22           C 
ATOM    358  H   VAL    24       6.076   5.392   1.487  1.00 38.87           H 
ATOM    359  HA  VAL    24       5.681   4.996   4.238  1.00 44.24           H 
ATOM    360  HB  VAL    24       3.636   4.731   2.013  1.00 63.23           H 
ATOM    361 1HG1 VAL    24       2.821   3.758   4.105  1.00 38.87           H 
ATOM    362 2HG1 VAL    24       1.964   5.256   3.732  1.00 38.87           H 
ATOM    363 3HG1 VAL    24       3.225   5.244   4.968  1.00 38.87           H 
ATOM    364 1HG2 VAL    24       3.105   7.082   2.499  1.00 38.87           H 
ATOM    365 2HG2 VAL    24       4.772   6.889   1.958  1.00 38.87           H 
ATOM    366 3HG2 VAL    24       4.425   7.135   3.669  1.00 38.87           H 
ATOM    367  N   LEU    25       5.024   2.319   2.383  1.00 21.21           N 
ATOM    368  CA  LEU    25       4.890   0.859   2.421  1.00 24.54           C 
ATOM    369  C   LEU    25       6.124   0.189   3.054  1.00 52.53           C 
ATOM    370  O   LEU    25       5.991  -0.631   3.961  1.00  0.34           O 
ATOM    371  CB  LEU    25       4.646   0.301   1.009  1.00 23.11           C 
ATOM    372  CG  LEU    25       3.344   0.768   0.333  1.00 14.31           C 
ATOM    373  CD1 LEU    25       3.195   0.130  -1.046  1.00 41.41           C 
ATOM    374  CD2 LEU    25       2.129   0.460   1.211  1.00 73.14           C 
ATOM    375  H   LEU    25       4.969   2.780   1.519  1.00 38.87           H 
ATOM    376  HA  LEU    25       4.029   0.631   3.035  1.00 24.42           H 
ATOM    377 3HB  LEU    25       4.625  -0.779   1.069  1.00 38.87           H 
ATOM    378 2HB  LEU    25       5.478   0.590   0.381  1.00 38.87           H 
ATOM    379  HG  LEU    25       3.389   1.839   0.194  1.00 22.14           H 
ATOM    380 1HD1 LEU    25       3.158  -0.945  -0.949  1.00 38.87           H 
ATOM    381 2HD1 LEU    25       4.040   0.405  -1.662  1.00 38.87           H 
ATOM    382 3HD1 LEU    25       2.284   0.480  -1.512  1.00 38.87           H 
ATOM    383 1HD2 LEU    25       1.231   0.811   0.723  1.00 38.87           H 
ATOM    384 2HD2 LEU    25       2.236   0.962   2.163  1.00 38.87           H 
ATOM    385 3HD2 LEU    25       2.059  -0.605   1.374  1.00 38.87           H 
ATOM    386  N   ARG    26       7.321   0.551   2.592  1.00 43.22           N 
ATOM    387  CA  ARG    26       8.560  -0.020   3.145  1.00 41.55           C 
ATOM    388  C   ARG    26       8.698   0.292   4.646  1.00 10.22           C 
ATOM    389  O   ARG    26       9.154  -0.547   5.426  1.00 44.14           O 
ATOM    390  CB  ARG    26       9.791   0.483   2.372  1.00  1.12           C 
ATOM    391  CG  ARG    26       9.792   0.088   0.895  1.00  0.12           C 
ATOM    392  CD  ARG    26      11.120   0.413   0.213  1.00 14.24           C 
ATOM    393  NE  ARG    26      12.212  -0.415   0.721  1.00  2.21           N 
ATOM    394  CZ  ARG    26      13.444  -0.363   0.284  1.00 72.04           C 
ATOM    395  NH1 ARG    26      13.782   0.443  -0.671  1.00 25.00           N 
ATOM    396  NH2 ARG    26      14.337  -1.136   0.804  1.00 23.25           N 
ATOM    397  H   ARG    26       7.375   1.216   1.870  1.00 38.87           H 
ATOM    398  HA  ARG    26       8.497  -1.094   3.028  1.00 20.25           H 
ATOM    399 3HB  ARG    26      10.682   0.077   2.833  1.00 38.87           H 
ATOM    400 2HB  ARG    26       9.825   1.562   2.434  1.00 38.87           H 
ATOM    401 3HG  ARG    26       8.999   0.622   0.391  1.00 38.87           H 
ATOM    402 2HG  ARG    26       9.613  -0.975   0.818  1.00 38.87           H 
ATOM    403 3HD  ARG    26      11.356   1.454   0.388  1.00 38.87           H 
ATOM    404 2HD  ARG    26      11.015   0.242  -0.848  1.00 38.87           H 
ATOM    405  HE  ARG    26      12.007  -1.048   1.436  1.00 75.23           H 
ATOM    406 1HH1 ARG    26      13.104   1.036  -1.087  1.00 38.87           H 
ATOM    407 2HH1 ARG    26      14.729   0.464  -0.989  1.00 38.87           H 
ATOM    408 1HH2 ARG    26      14.081  -1.766   1.535  1.00 38.87           H 
ATOM    409 2HH2 ARG    26      15.281  -1.099   0.479  1.00 38.87           H 
ATOM    410  N   SER    27       8.287   1.495   5.048  1.00 41.25           N 
ATOM    411  CA  SER    27       8.268   1.880   6.470  1.00 31.14           C 
ATOM    412  C   SER    27       7.256   1.030   7.257  1.00 64.51           C 
ATOM    413  O   SER    27       7.441   0.755   8.444  1.00  3.25           O 
ATOM    414  CB  SER    27       7.918   3.370   6.624  1.00 40.22           C 
ATOM    415  OG  SER    27       7.865   3.759   7.991  1.00 31.31           O 
ATOM    416  H   SER    27       7.994   2.146   4.373  1.00 38.87           H 
ATOM    417  HA  SER    27       9.255   1.708   6.873  1.00 70.30           H 
ATOM    418 3HB  SER    27       6.952   3.559   6.174  1.00 38.87           H 
ATOM    419 2HB  SER    27       8.666   3.968   6.125  1.00 38.87           H 
ATOM    420  HG  SER    27       8.739   3.656   8.392  1.00 30.31           H 
ATOM    421  N   TYR    28       6.184   0.617   6.583  1.00 45.01           N 
ATOM    422  CA  TYR    28       5.142  -0.224   7.194  1.00 74.51           C 
ATOM    423  C   TYR    28       5.395  -1.724   6.958  1.00 14.23           C 
ATOM    424  O   TYR    28       4.470  -2.529   7.046  1.00 61.03           O 
ATOM    425  CB  TYR    28       3.757   0.166   6.641  1.00 74.03           C 
ATOM    426  CG  TYR    28       3.189   1.441   7.242  1.00 11.24           C 
ATOM    427  CD1 TYR    28       3.911   2.627   7.217  1.00 10.44           C 
ATOM    428  CD2 TYR    28       1.933   1.452   7.841  1.00 20.03           C 
ATOM    429  CE1 TYR    28       3.401   3.784   7.767  1.00 34.33           C 
ATOM    430  CE2 TYR    28       1.416   2.610   8.391  1.00  2.12           C 
ATOM    431  CZ  TYR    28       2.154   3.774   8.356  1.00 71.44           C 
ATOM    432  OH  TYR    28       1.646   4.929   8.911  1.00 63.15           O 
ATOM    433  H   TYR    28       6.081   0.892   5.647  1.00 38.87           H 
ATOM    434  HA  TYR    28       5.152  -0.041   8.260  1.00 10.33           H 
ATOM    435 3HB  TYR    28       3.058  -0.636   6.840  1.00 38.87           H 
ATOM    436 2HB  TYR    28       3.829   0.309   5.572  1.00 38.87           H 
ATOM    437  HD1 TYR    28       4.889   2.637   6.754  1.00 12.04           H 
ATOM    438  HD2 TYR    28       1.354   0.539   7.870  1.00 44.32           H 
ATOM    439  HE1 TYR    28       3.982   4.695   7.734  1.00 31.13           H 
ATOM    440  HE2 TYR    28       0.437   2.597   8.852  1.00  5.42           H 
ATOM    441  HH  TYR    28       1.231   4.715   9.759  1.00 22.42           H 
ATOM    442  N   ASN    29       6.644  -2.094   6.655  1.00 64.12           N 
ATOM    443  CA  ASN    29       7.027  -3.510   6.467  1.00  3.31           C 
ATOM    444  C   ASN    29       6.394  -4.116   5.189  1.00 13.52           C 
ATOM    445  O   ASN    29       6.542  -5.306   4.904  1.00 14.04           O 
ATOM    446  CB  ASN    29       6.643  -4.328   7.718  1.00 42.21           C 
ATOM    447  CG  ASN    29       7.083  -5.781   7.648  1.00 55.45           C 
ATOM    448  OD1 ASN    29       6.340  -6.648   7.204  1.00  2.11           O 
ATOM    449  ND2 ASN    29       8.292  -6.057   8.086  1.00 52.35           N 
ATOM    450  H   ASN    29       7.330  -1.400   6.555  1.00 38.87           H 
ATOM    451  HA  ASN    29       8.102  -3.537   6.355  1.00 41.34           H 
ATOM    452 3HB  ASN    29       5.569  -4.304   7.836  1.00 38.87           H 
ATOM    453 2HB  ASN    29       7.100  -3.880   8.587  1.00 38.87           H 
ATOM    454 1HD2 ASN    29       8.839  -5.324   8.432  1.00 38.87           H 
ATOM    455 2HD2 ASN    29       8.592  -6.988   8.043  1.00 38.87           H 
ATOM    456  N   LEU    30       5.707  -3.287   4.409  1.00 42.54           N 
ATOM    457  CA  LEU    30       5.067  -3.732   3.164  1.00 61.32           C 
ATOM    458  C   LEU    30       6.007  -3.584   1.953  1.00 62.13           C 
ATOM    459  O   LEU    30       5.570  -3.662   0.807  1.00  2.11           O 
ATOM    460  CB  LEU    30       3.776  -2.933   2.923  1.00 24.14           C 
ATOM    461  CG  LEU    30       2.688  -3.094   3.998  1.00 61.14           C 
ATOM    462  CD1 LEU    30       1.493  -2.193   3.696  1.00 70.13           C 
ATOM    463  CD2 LEU    30       2.251  -4.551   4.108  1.00 20.11           C 
ATOM    464  H   LEU    30       5.621  -2.348   4.676  1.00 38.87           H 
ATOM    465  HA  LEU    30       4.812  -4.777   3.276  1.00 51.02           H 
ATOM    466 3HB  LEU    30       3.359  -3.238   1.973  1.00 38.87           H 
ATOM    467 2HB  LEU    30       4.037  -1.885   2.860  1.00 38.87           H 
ATOM    468  HG  LEU    30       3.092  -2.795   4.956  1.00 61.31           H 
ATOM    469 1HD1 LEU    30       0.737  -2.329   4.455  1.00 38.87           H 
ATOM    470 2HD1 LEU    30       1.080  -2.449   2.730  1.00 38.87           H 
ATOM    471 3HD1 LEU    30       1.812  -1.161   3.688  1.00 38.87           H 
ATOM    472 1HD2 LEU    30       3.098  -5.161   4.389  1.00 38.87           H 
ATOM    473 2HD2 LEU    30       1.867  -4.888   3.155  1.00 38.87           H 
ATOM    474 3HD2 LEU    30       1.479  -4.642   4.859  1.00 38.87           H 
ATOM    475  N   GLY    31       7.298  -3.384   2.208  1.00  4.45           N 
ATOM    476  CA  GLY    31       8.267  -3.263   1.121  1.00 25.11           C 
ATOM    477  C   GLY    31       8.489  -4.576   0.377  1.00 51.33           C 
ATOM    478  O   GLY    31       8.813  -4.585  -0.811  1.00 73.35           O 
ATOM    479  H   GLY    31       7.599  -3.325   3.139  1.00 38.87           H 
ATOM    480 3HA  GLY    31       9.210  -2.932   1.534  1.00 38.87           H 
ATOM    481 2HA  GLY    31       7.918  -2.520   0.419  1.00 38.87           H 
ATOM    482  N   CYS    32       8.287  -5.688   1.081  1.00 72.02           N 
ATOM    483  CA  CYS    32       8.477  -7.034   0.510  1.00 52.11           C 
ATOM    484  C   CYS    32       7.477  -7.351  -0.620  1.00 14.33           C 
ATOM    485  O   CYS    32       7.585  -8.391  -1.272  1.00 35.15           O 
ATOM    486  CB  CYS    32       8.352  -8.092   1.616  1.00 20.22           C 
ATOM    487  SG  CYS    32       9.502  -7.864   2.995  1.00 30.33           S 
ATOM    488  H   CYS    32       8.028  -5.606   2.026  1.00 38.87           H 
ATOM    489  HA  CYS    32       9.479  -7.080   0.105  1.00 13.22           H 
ATOM    490 3HB  CYS    32       8.538  -9.069   1.194  1.00 38.87           H 
ATOM    491 2HB  CYS    32       7.351  -8.064   2.020  1.00 38.87           H 
ATOM    492  HG  CYS    32       9.160  -8.712   3.958  1.00  3.32           H 
ATOM    493  N   ILE    33       6.510  -6.455  -0.857  1.00 11.23           N 
ATOM    494  CA  ILE    33       5.483  -6.663  -1.894  1.00 42.40           C 
ATOM    495  C   ILE    33       6.089  -6.954  -3.277  1.00  4.14           C 
ATOM    496  O   ILE    33       5.490  -7.666  -4.089  1.00 21.25           O 
ATOM    497  CB  ILE    33       4.536  -5.443  -2.016  1.00 34.23           C 
ATOM    498  CG1 ILE    33       5.346  -4.154  -2.264  1.00 44.15           C 
ATOM    499  CG2 ILE    33       3.659  -5.319  -0.769  1.00 34.32           C 
ATOM    500  CD1 ILE    33       4.493  -2.917  -2.453  1.00 44.31           C 
ATOM    501  H   ILE    33       6.486  -5.633  -0.322  1.00 38.87           H 
ATOM    502  HA  ILE    33       4.888  -7.517  -1.596  1.00 43.20           H 
ATOM    503  HB  ILE    33       3.880  -5.612  -2.861  1.00 31.14           H 
ATOM    504 3HG1 ILE    33       5.948  -4.279  -3.155  1.00 38.87           H 
ATOM    505 2HG1 ILE    33       5.998  -3.977  -1.422  1.00 38.87           H 
ATOM    506 1HG2 ILE    33       4.284  -5.174   0.101  1.00 38.87           H 
ATOM    507 2HG2 ILE    33       3.076  -6.220  -0.646  1.00 38.87           H 
ATOM    508 3HG2 ILE    33       2.992  -4.474  -0.877  1.00 38.87           H 
ATOM    509 1HD1 ILE    33       3.902  -2.745  -1.565  1.00 38.87           H 
ATOM    510 2HD1 ILE    33       3.838  -3.055  -3.301  1.00 38.87           H 
ATOM    511 3HD1 ILE    33       5.133  -2.064  -2.630  1.00 38.87           H 
ATOM    512  N   GLY    34       7.265  -6.394  -3.547  1.00 63.23           N 
ATOM    513  CA  GLY    34       7.939  -6.647  -4.814  1.00 72.44           C 
ATOM    514  C   GLY    34       8.489  -8.069  -4.918  1.00 55.21           C 
ATOM    515  O   GLY    34       8.434  -8.691  -5.979  1.00  4.52           O 
ATOM    516  H   GLY    34       7.679  -5.800  -2.881  1.00 38.87           H 
ATOM    517 3HA  GLY    34       8.759  -5.952  -4.918  1.00 38.87           H 
ATOM    518 2HA  GLY    34       7.240  -6.483  -5.620  1.00 38.87           H 
ATOM    519  N   CYS    35       9.005  -8.589  -3.808  1.00  2.01           N 
ATOM    520  CA  CYS    35       9.587  -9.938  -3.775  1.00 52.44           C 
ATOM    521  C   CYS    35       8.500 -11.026  -3.747  1.00 23.13           C 
ATOM    522  O   CYS    35       8.498 -11.938  -4.576  1.00 35.54           O 
ATOM    523  CB  CYS    35      10.504 -10.083  -2.555  1.00 45.14           C 
ATOM    524  SG  CYS    35      11.322 -11.690  -2.418  1.00 44.42           S 
ATOM    525  H   CYS    35       8.999  -8.054  -2.987  1.00 38.87           H 
ATOM    526  HA  CYS    35      10.180 -10.065  -4.672  1.00 14.22           H 
ATOM    527 3HB  CYS    35       9.921  -9.933  -1.657  1.00 38.87           H 
ATOM    528 2HB  CYS    35      11.275  -9.330  -2.605  1.00 38.87           H 
ATOM    529  HG  CYS    35      10.648 -12.559  -3.160  1.00 22.02           H 
ATOM    530  N   MET    36       7.564 -10.914  -2.801  1.00 55.31           N 
ATOM    531  CA  MET    36       6.475 -11.897  -2.654  1.00 70.22           C 
ATOM    532  C   MET    36       5.467 -11.836  -3.823  1.00 43.33           C 
ATOM    533  O   MET    36       4.520 -12.621  -3.879  1.00 61.33           O 
ATOM    534  CB  MET    36       5.745 -11.684  -1.316  1.00 63.22           C 
ATOM    535  CG  MET    36       5.045 -10.335  -1.197  1.00 54.23           C 
ATOM    536  SD  MET    36       4.314 -10.059   0.433  1.00 50.02           S 
ATOM    537  CE  MET    36       3.132 -11.405   0.521  1.00  5.25           C 
ATOM    538  H   MET    36       7.613 -10.160  -2.173  1.00 38.87           H 
ATOM    539  HA  MET    36       6.925 -12.880  -2.647  1.00 60.22           H 
ATOM    540 3HB  MET    36       6.463 -11.762  -0.512  1.00 38.87           H 
ATOM    541 2HB  MET    36       5.005 -12.461  -1.195  1.00 38.87           H 
ATOM    542 3HG  MET    36       4.261 -10.285  -1.939  1.00 38.87           H 
ATOM    543 2HG  MET    36       5.764  -9.553  -1.386  1.00 38.87           H 
ATOM    544 1HE  MET    36       2.410 -11.304  -0.276  1.00 38.87           H 
ATOM    545 2HE  MET    36       2.623 -11.376   1.473  1.00 38.87           H 
ATOM    546 3HE  MET    36       3.651 -12.347   0.418  1.00 38.87           H 
ATOM    547  N   GLY    37       5.675 -10.901  -4.753  1.00 33.50           N 
ATOM    548  CA  GLY    37       4.788 -10.772  -5.909  1.00 30.42           C 
ATOM    549  C   GLY    37       3.416 -10.192  -5.565  1.00  5.13           C 
ATOM    550  O   GLY    37       2.431 -10.448  -6.257  1.00 43.15           O 
ATOM    551  H   GLY    37       6.445 -10.303  -4.665  1.00 38.87           H 
ATOM    552 3HA  GLY    37       4.652 -11.749  -6.353  1.00 38.87           H 
ATOM    553 2HA  GLY    37       5.261 -10.127  -6.635  1.00 38.87           H 
ATOM    554  N   ALA    38       3.358  -9.380  -4.511  1.00 21.33           N 
ATOM    555  CA  ALA    38       2.093  -8.779  -4.065  1.00 60.21           C 
ATOM    556  C   ALA    38       1.722  -7.537  -4.893  1.00 53.12           C 
ATOM    557  O   ALA    38       0.788  -6.812  -4.559  1.00 43.01           O 
ATOM    558  CB  ALA    38       2.174  -8.425  -2.585  1.00 32.44           C 
ATOM    559  H   ALA    38       4.182  -9.176  -4.022  1.00 38.87           H 
ATOM    560  HA  ALA    38       1.314  -9.519  -4.187  1.00 30.24           H 
ATOM    561 1HB  ALA    38       1.215  -8.054  -2.249  1.00 38.87           H 
ATOM    562 2HB  ALA    38       2.927  -7.665  -2.435  1.00 38.87           H 
ATOM    563 3HB  ALA    38       2.435  -9.306  -2.017  1.00 38.87           H 
ATOM    564  N   GLN    39       2.454  -7.300  -5.983  1.00 51.54           N 
ATOM    565  CA  GLN    39       2.170  -6.172  -6.880  1.00 52.21           C 
ATOM    566  C   GLN    39       0.734  -6.247  -7.425  1.00 44.13           C 
ATOM    567  O   GLN    39       0.021  -5.245  -7.482  1.00 62.22           O 
ATOM    568  CB  GLN    39       3.172  -6.155  -8.048  1.00 11.11           C 
ATOM    569  CG  GLN    39       4.633  -6.038  -7.616  1.00 12.04           C 
ATOM    570  CD  GLN    39       4.929  -4.760  -6.846  1.00  1.14           C 
ATOM    571  OE1 GLN    39       5.269  -3.732  -7.422  1.00  1.24           O 
ATOM    572  NE2 GLN    39       4.808  -4.815  -5.535  1.00 63.04           N 
ATOM    573  H   GLN    39       3.202  -7.898  -6.190  1.00 38.87           H 
ATOM    574  HA  GLN    39       2.278  -5.259  -6.310  1.00  0.22           H 
ATOM    575 3HB  GLN    39       2.944  -5.319  -8.692  1.00 38.87           H 
ATOM    576 2HB  GLN    39       3.062  -7.071  -8.611  1.00 38.87           H 
ATOM    577 3HG  GLN    39       5.260  -6.061  -8.499  1.00 38.87           H 
ATOM    578 2HG  GLN    39       4.876  -6.882  -6.988  1.00 38.87           H 
ATOM    579 1HE2 GLN    39       4.541  -5.665  -5.130  1.00 38.87           H 
ATOM    580 2HE2 GLN    39       4.990  -4.002  -5.025  1.00 38.87           H 
ATOM    581  N   ASN    40       0.312  -7.455  -7.794  1.00 54.11           N 
ATOM    582  CA  ASN    40      -1.031  -7.687  -8.351  1.00 74.13           C 
ATOM    583  C   ASN    40      -2.066  -7.944  -7.243  1.00 65.32           C 
ATOM    584  O   ASN    40      -3.183  -8.388  -7.511  1.00 44.31           O 
ATOM    585  CB  ASN    40      -0.988  -8.888  -9.306  1.00 10.04           C 
ATOM    586  CG  ASN    40       0.065  -8.732 -10.388  1.00 23.32           C 
ATOM    587  OD1 ASN    40       0.360  -7.628 -10.832  1.00 44.11           O 
ATOM    588  ND2 ASN    40       0.653  -9.832 -10.809  1.00 53.43           N 
ATOM    589  H   ASN    40       0.917  -8.217  -7.689  1.00 38.87           H 
ATOM    590  HA  ASN    40      -1.324  -6.805  -8.904  1.00 74.51           H 
ATOM    591 3HB  ASN    40      -1.953  -8.997  -9.783  1.00 38.87           H 
ATOM    592 2HB  ASN    40      -0.768  -9.784  -8.741  1.00 38.87           H 
ATOM    593 1HD2 ASN    40       0.382 -10.685 -10.410  1.00 38.87           H 
ATOM    594 2HD2 ASN    40       1.346  -9.750 -11.497  1.00 38.87           H 
ATOM    595  N   GLU    41      -1.689  -7.659  -6.000  1.00 31.21           N 
ATOM    596  CA  GLU    41      -2.548  -7.924  -4.840  1.00 53.43           C 
ATOM    597  C   GLU    41      -3.092  -6.616  -4.235  1.00 12.33           C 
ATOM    598  O   GLU    41      -2.418  -5.583  -4.261  1.00 43.41           O 
ATOM    599  CB  GLU    41      -1.748  -8.714  -3.796  1.00 42.53           C 
ATOM    600  CG  GLU    41      -2.547  -9.119  -2.567  1.00 52.30           C 
ATOM    601  CD  GLU    41      -1.776 -10.052  -1.644  1.00 31.01           C 
ATOM    602  OE1 GLU    41      -1.786 -11.279  -1.891  1.00 53.45           O 
ATOM    603  OE2 GLU    41      -1.162  -9.572  -0.672  1.00 62.01           O 
ATOM    604  H   GLU    41      -0.811  -7.253  -5.852  1.00 38.87           H 
ATOM    605  HA  GLU    41      -3.383  -8.527  -5.172  1.00 51.41           H 
ATOM    606 3HB  GLU    41      -0.912  -8.110  -3.470  1.00 38.87           H 
ATOM    607 2HB  GLU    41      -1.366  -9.613  -4.260  1.00 38.87           H 
ATOM    608 3HG  GLU    41      -3.451  -9.617  -2.890  1.00 38.87           H 
ATOM    609 2HG  GLU    41      -2.810  -8.226  -2.017  1.00 38.87           H 
ATOM    610  N   SER    42      -4.319  -6.661  -3.706  1.00 41.03           N 
ATOM    611  CA  SER    42      -4.961  -5.470  -3.118  1.00  3.23           C 
ATOM    612  C   SER    42      -4.293  -5.049  -1.800  1.00 11.01           C 
ATOM    613  O   SER    42      -3.789  -5.888  -1.050  1.00 32.42           O 
ATOM    614  CB  SER    42      -6.458  -5.722  -2.873  1.00 14.55           C 
ATOM    615  OG  SER    42      -7.145  -6.007  -4.084  1.00 70.13           O 
ATOM    616  H   SER    42      -4.807  -7.510  -3.713  1.00 38.87           H 
ATOM    617  HA  SER    42      -4.859  -4.661  -3.828  1.00 32.13           H 
ATOM    618 3HB  SER    42      -6.900  -4.843  -2.425  1.00 38.87           H 
ATOM    619 2HB  SER    42      -6.576  -6.561  -2.204  1.00 38.87           H 
ATOM    620  HG  SER    42      -7.870  -5.378  -4.197  1.00 72.35           H 
ATOM    621  N   LEU    43      -4.334  -3.745  -1.511  1.00 34.52           N 
ATOM    622  CA  LEU    43      -3.680  -3.178  -0.320  1.00 51.01           C 
ATOM    623  C   LEU    43      -4.101  -3.890   0.980  1.00 74.01           C 
ATOM    624  O   LEU    43      -3.260  -4.209   1.824  1.00 54.43           O 
ATOM    625  CB  LEU    43      -3.980  -1.673  -0.207  1.00 41.31           C 
ATOM    626  CG  LEU    43      -3.465  -0.804  -1.370  1.00 64.44           C 
ATOM    627  CD1 LEU    43      -3.791   0.670  -1.132  1.00 51.40           C 
ATOM    628  CD2 LEU    43      -1.961  -0.997  -1.560  1.00 34.20           C 
ATOM    629  H   LEU    43      -4.808  -3.142  -2.124  1.00 38.87           H 
ATOM    630  HA  LEU    43      -2.614  -3.305  -0.446  1.00 12.32           H 
ATOM    631 3HB  LEU    43      -3.535  -1.307   0.707  1.00 38.87           H 
ATOM    632 2HB  LEU    43      -5.052  -1.546  -0.137  1.00 38.87           H 
ATOM    633  HG  LEU    43      -3.958  -1.109  -2.283  1.00 73.25           H 
ATOM    634 1HD1 LEU    43      -3.449   1.257  -1.973  1.00 38.87           H 
ATOM    635 2HD1 LEU    43      -3.297   1.009  -0.233  1.00 38.87           H 
ATOM    636 3HD1 LEU    43      -4.859   0.790  -1.020  1.00 38.87           H 
ATOM    637 1HD2 LEU    43      -1.442  -0.711  -0.656  1.00 38.87           H 
ATOM    638 2HD2 LEU    43      -1.617  -0.382  -2.380  1.00 38.87           H 
ATOM    639 3HD2 LEU    43      -1.755  -2.035  -1.781  1.00 38.87           H 
ATOM    640  N   GLU    44      -5.401  -4.143   1.137  1.00 63.43           N 
ATOM    641  CA  GLU    44      -5.916  -4.782   2.357  1.00 53.33           C 
ATOM    642  C   GLU    44      -5.391  -6.221   2.516  1.00 13.40           C 
ATOM    643  O   GLU    44      -5.106  -6.668   3.631  1.00 42.44           O 
ATOM    644  CB  GLU    44      -7.454  -4.769   2.367  1.00  1.52           C 
ATOM    645  CG  GLU    44      -8.063  -5.312   3.657  1.00 44.00           C 
ATOM    646  CD  GLU    44      -9.574  -5.141   3.724  1.00 71.34           C 
ATOM    647  OE1 GLU    44     -10.303  -5.980   3.152  1.00 73.53           O 
ATOM    648  OE2 GLU    44     -10.040  -4.172   4.363  1.00 70.00           O 
ATOM    649  H   GLU    44      -6.026  -3.892   0.422  1.00 38.87           H 
ATOM    650  HA  GLU    44      -5.565  -4.200   3.198  1.00 63.33           H 
ATOM    651 3HB  GLU    44      -7.817  -5.367   1.541  1.00 38.87           H 
ATOM    652 2HB  GLU    44      -7.792  -3.751   2.237  1.00 38.87           H 
ATOM    653 3HG  GLU    44      -7.618  -4.791   4.494  1.00 38.87           H 
ATOM    654 2HG  GLU    44      -7.832  -6.366   3.735  1.00 38.87           H 
ATOM    655  N   GLN    45      -5.236  -6.928   1.397  1.00 42.12           N 
ATOM    656  CA  GLN    45      -4.756  -8.316   1.419  1.00 51.24           C 
ATOM    657  C   GLN    45      -3.315  -8.398   1.954  1.00 43.02           C 
ATOM    658  O   GLN    45      -3.017  -9.191   2.854  1.00 75.43           O 
ATOM    659  CB  GLN    45      -4.839  -8.928   0.013  1.00 52.21           C 
ATOM    660  CG  GLN    45      -6.252  -8.961  -0.564  1.00 72.12           C 
ATOM    661  CD  GLN    45      -6.314  -9.557  -1.964  1.00 24.00           C 
ATOM    662  OE1 GLN    45      -5.518 -10.415  -2.330  1.00  4.23           O 
ATOM    663  NE2 GLN    45      -7.260  -9.104  -2.762  1.00 52.32           N 
ATOM    664  H   GLN    45      -5.437  -6.506   0.536  1.00 38.87           H 
ATOM    665  HA  GLN    45      -5.400  -8.876   2.083  1.00 63.43           H 
ATOM    666 3HB  GLN    45      -4.464  -9.941   0.049  1.00 38.87           H 
ATOM    667 2HB  GLN    45      -4.216  -8.349  -0.655  1.00 38.87           H 
ATOM    668 3HG  GLN    45      -6.632  -7.950  -0.601  1.00 38.87           H 
ATOM    669 2HG  GLN    45      -6.878  -9.554   0.087  1.00 38.87           H 
ATOM    670 1HE2 GLN    45      -7.869  -8.417  -2.416  1.00 38.87           H 
ATOM    671 2HE2 GLN    45      -7.316  -9.472  -3.668  1.00 38.87           H 
ATOM    672  N   GLY    46      -2.431  -7.567   1.405  1.00 51.42           N 
ATOM    673  CA  GLY    46      -1.055  -7.505   1.890  1.00 71.41           C 
ATOM    674  C   GLY    46      -0.952  -6.979   3.320  1.00 35.30           C 
ATOM    675  O   GLY    46      -0.099  -7.418   4.097  1.00 44.35           O 
ATOM    676  H   GLY    46      -2.709  -7.001   0.652  1.00 38.87           H 
ATOM    677 3HA  GLY    46      -0.490  -6.853   1.241  1.00 38.87           H 
ATOM    678 2HA  GLY    46      -0.623  -8.497   1.848  1.00 38.87           H 
ATOM    679  N   ALA    47      -1.834  -6.040   3.669  1.00 64.50           N 
ATOM    680  CA  ALA    47      -1.882  -5.471   5.021  1.00 62.21           C 
ATOM    681  C   ALA    47      -2.108  -6.558   6.085  1.00 72.41           C 
ATOM    682  O   ALA    47      -1.281  -6.746   6.978  1.00 22.11           O 
ATOM    683  CB  ALA    47      -2.973  -4.409   5.107  1.00 24.11           C 
ATOM    684  H   ALA    47      -2.470  -5.715   2.996  1.00 38.87           H 
ATOM    685  HA  ALA    47      -0.932  -4.992   5.209  1.00 75.31           H 
ATOM    686 1HB  ALA    47      -2.966  -3.960   6.089  1.00 38.87           H 
ATOM    687 2HB  ALA    47      -3.936  -4.865   4.926  1.00 38.87           H 
ATOM    688 3HB  ALA    47      -2.793  -3.648   4.362  1.00 38.87           H 
ATOM    689  N   ASN    48      -3.223  -7.284   5.978  1.00 11.12           N 
ATOM    690  CA  ASN    48      -3.529  -8.366   6.926  1.00 44.43           C 
ATOM    691  C   ASN    48      -2.442  -9.455   6.910  1.00 63.01           C 
ATOM    692  O   ASN    48      -2.128 -10.047   7.946  1.00 33.10           O 
ATOM    693  CB  ASN    48      -4.901  -8.985   6.634  1.00 40.54           C 
ATOM    694  CG  ASN    48      -6.043  -8.023   6.917  1.00  0.33           C 
ATOM    695  OD1 ASN    48      -6.509  -7.907   8.047  1.00  3.44           O 
ATOM    696  ND2 ASN    48      -6.513  -7.337   5.897  1.00  3.10           N 
ATOM    697  H   ASN    48      -3.852  -7.088   5.249  1.00 38.87           H 
ATOM    698  HA  ASN    48      -3.552  -7.928   7.915  1.00 72.44           H 
ATOM    699 3HB  ASN    48      -5.034  -9.862   7.252  1.00 38.87           H 
ATOM    700 2HB  ASN    48      -4.944  -9.273   5.593  1.00 38.87           H 
ATOM    701 1HD2 ASN    48      -6.108  -7.476   5.017  1.00 38.87           H 
ATOM    702 2HD2 ASN    48      -7.252  -6.717   6.063  1.00 38.87           H 
ATOM    703  N   ALA    49      -1.859  -9.707   5.738  1.00 74.10           N 
ATOM    704  CA  ALA    49      -0.749 -10.662   5.611  1.00 51.45           C 
ATOM    705  C   ALA    49       0.451 -10.257   6.484  1.00  2.25           C 
ATOM    706  O   ALA    49       1.184 -11.109   6.990  1.00  2.32           O 
ATOM    707  CB  ALA    49      -0.318 -10.776   4.156  1.00 75.30           C 
ATOM    708  H   ALA    49      -2.189  -9.249   4.934  1.00 38.87           H 
ATOM    709  HA  ALA    49      -1.106 -11.631   5.933  1.00  3.45           H 
ATOM    710 1HB  ALA    49       0.044  -9.818   3.811  1.00 38.87           H 
ATOM    711 2HB  ALA    49      -1.159 -11.080   3.553  1.00 38.87           H 
ATOM    712 3HB  ALA    49       0.472 -11.510   4.067  1.00 38.87           H 
ATOM    713  N   HIS    50       0.650  -8.949   6.647  1.00 62.00           N 
ATOM    714  CA  HIS    50       1.732  -8.419   7.490  1.00 30.31           C 
ATOM    715  C   HIS    50       1.202  -7.970   8.871  1.00 11.52           C 
ATOM    716  O   HIS    50       1.909  -7.317   9.639  1.00 44.31           O 
ATOM    717  CB  HIS    50       2.432  -7.249   6.776  1.00 53.20           C 
ATOM    718  CG  HIS    50       3.182  -7.652   5.534  1.00  5.11           C 
ATOM    719  ND1 HIS    50       4.471  -7.246   5.264  1.00 60.44           N 
ATOM    720  CD2 HIS    50       2.810  -8.413   4.474  1.00 44.03           C 
ATOM    721  CE1 HIS    50       4.856  -7.736   4.104  1.00 51.25           C 
ATOM    722  NE2 HIS    50       3.871  -8.450   3.600  1.00 61.50           N 
ATOM    723  H   HIS    50       0.054  -8.319   6.184  1.00 38.87           H 
ATOM    724  HA  HIS    50       2.452  -9.211   7.644  1.00 34.54           H 
ATOM    725 3HB  HIS    50       3.135  -6.791   7.455  1.00 38.87           H 
ATOM    726 2HB  HIS    50       1.690  -6.517   6.491  1.00 38.87           H 
ATOM    727  HD1 HIS    50       5.034  -6.692   5.849  1.00 14.34           H 
ATOM    728  HD2 HIS    50       1.856  -8.904   4.344  1.00 22.02           H 
ATOM    729  HE1 HIS    50       5.820  -7.580   3.644  1.00 42.23           H 
ATOM    730  HE2 HIS    50       3.990  -9.127   2.899  1.00 38.87           H 
ATOM    731  N   GLY    51      -0.047  -8.331   9.173  1.00 23.15           N 
ATOM    732  CA  GLY    51      -0.641  -8.026  10.476  1.00  4.03           C 
ATOM    733  C   GLY    51      -0.895  -6.539  10.717  1.00 61.15           C 
ATOM    734  O   GLY    51      -0.739  -6.047  11.838  1.00  1.41           O 
ATOM    735  H   GLY    51      -0.572  -8.820   8.506  1.00 38.87           H 
ATOM    736 3HA  GLY    51       0.016  -8.395  11.251  1.00 38.87           H 
ATOM    737 2HA  GLY    51      -1.584  -8.547  10.551  1.00 38.87           H 
ATOM    738  N   LEU    52      -1.296  -5.823   9.673  1.00 13.43           N 
ATOM    739  CA  LEU    52      -1.580  -4.387   9.774  1.00  3.32           C 
ATOM    740  C   LEU    52      -3.032  -4.077   9.386  1.00 73.02           C 
ATOM    741  O   LEU    52      -3.703  -4.885   8.738  1.00 24.11           O 
ATOM    742  CB  LEU    52      -0.627  -3.596   8.865  1.00 41.45           C 
ATOM    743  CG  LEU    52       0.869  -3.748   9.180  1.00 21.44           C 
ATOM    744  CD1 LEU    52       1.706  -2.969   8.174  1.00 72.31           C 
ATOM    745  CD2 LEU    52       1.171  -3.285  10.604  1.00 11.11           C 
ATOM    746  H   LEU    52      -1.403  -6.270   8.808  1.00 38.87           H 
ATOM    747  HA  LEU    52      -1.421  -4.081  10.799  1.00 62.12           H 
ATOM    748 3HB  LEU    52      -0.881  -2.548   8.941  1.00 38.87           H 
ATOM    749 2HB  LEU    52      -0.794  -3.913   7.843  1.00 38.87           H 
ATOM    750  HG  LEU    52       1.145  -4.792   9.104  1.00 52.43           H 
ATOM    751 1HD1 LEU    52       2.753  -3.074   8.417  1.00 38.87           H 
ATOM    752 2HD1 LEU    52       1.432  -1.924   8.209  1.00 38.87           H 
ATOM    753 3HD1 LEU    52       1.528  -3.353   7.181  1.00 38.87           H 
ATOM    754 1HD2 LEU    52       0.603  -3.879  11.306  1.00 38.87           H 
ATOM    755 2HD2 LEU    52       0.896  -2.245  10.709  1.00 38.87           H 
ATOM    756 3HD2 LEU    52       2.226  -3.400  10.805  1.00 38.87           H 
ATOM    757  N   ASN    53      -3.520  -2.908   9.789  1.00 21.20           N 
ATOM    758  CA  ASN    53      -4.858  -2.458   9.399  1.00  1.31           C 
ATOM    759  C   ASN    53      -4.763  -1.489   8.213  1.00 60.51           C 
ATOM    760  O   ASN    53      -4.085  -0.462   8.286  1.00  3.35           O 
ATOM    761  CB  ASN    53      -5.568  -1.786  10.582  1.00 54.22           C 
ATOM    762  CG  ASN    53      -7.045  -1.541  10.321  1.00 44.44           C 
ATOM    763  OD1 ASN    53      -7.477  -1.407   9.182  1.00 23.30           O 
ATOM    764  ND2 ASN    53      -7.831  -1.471  11.375  1.00 13.44           N 
ATOM    765  H   ASN    53      -2.970  -2.333  10.363  1.00 38.87           H 
ATOM    766  HA  ASN    53      -5.427  -3.328   9.094  1.00 43.34           H 
ATOM    767 3HB  ASN    53      -5.097  -0.835  10.786  1.00 38.87           H 
ATOM    768 2HB  ASN    53      -5.478  -2.419  11.453  1.00 38.87           H 
ATOM    769 1HD2 ASN    53      -7.428  -1.581  12.261  1.00 38.87           H 
ATOM    770 2HD2 ASN    53      -8.786  -1.310  11.229  1.00 38.87           H 
ATOM    771  N   VAL    54      -5.458  -1.815   7.129  1.00 55.22           N 
ATOM    772  CA  VAL    54      -5.397  -1.020   5.902  1.00 12.33           C 
ATOM    773  C   VAL    54      -5.886   0.424   6.127  1.00 10.12           C 
ATOM    774  O   VAL    54      -5.478   1.339   5.414  1.00 44.44           O 
ATOM    775  CB  VAL    54      -6.224  -1.680   4.770  1.00 72.23           C 
ATOM    776  CG1 VAL    54      -7.711  -1.685   5.113  1.00 54.15           C 
ATOM    777  CG2 VAL    54      -5.961  -0.992   3.429  1.00  1.54           C 
ATOM    778  H   VAL    54      -6.029  -2.612   7.152  1.00 38.87           H 
ATOM    779  HA  VAL    54      -4.364  -0.989   5.586  1.00  4.41           H 
ATOM    780  HB  VAL    54      -5.905  -2.711   4.682  1.00 52.32           H 
ATOM    781 1HG1 VAL    54      -7.868  -2.238   6.028  1.00 38.87           H 
ATOM    782 2HG1 VAL    54      -8.264  -2.152   4.313  1.00 38.87           H 
ATOM    783 3HG1 VAL    54      -8.057  -0.668   5.244  1.00 38.87           H 
ATOM    784 1HG2 VAL    54      -6.270   0.043   3.486  1.00 38.87           H 
ATOM    785 2HG2 VAL    54      -6.522  -1.491   2.653  1.00 38.87           H 
ATOM    786 3HG2 VAL    54      -4.907  -1.041   3.199  1.00 38.87           H 
ATOM    787  N   GLU    55      -6.747   0.622   7.129  1.00  2.41           N 
ATOM    788  CA  GLU    55      -7.280   1.956   7.445  1.00 32.13           C 
ATOM    789  C   GLU    55      -6.154   2.971   7.712  1.00 43.44           C 
ATOM    790  O   GLU    55      -6.118   4.051   7.113  1.00 64.42           O 
ATOM    791  CB  GLU    55      -8.210   1.886   8.667  1.00 23.34           C 
ATOM    792  CG  GLU    55      -9.406   0.955   8.494  1.00 73.43           C 
ATOM    793  CD  GLU    55     -10.260   1.294   7.284  1.00 64.30           C 
ATOM    794  OE1 GLU    55     -10.823   2.411   7.240  1.00 63.25           O 
ATOM    795  OE2 GLU    55     -10.388   0.439   6.382  1.00 33.35           O 
ATOM    796  H   GLU    55      -7.036  -0.145   7.667  1.00 38.87           H 
ATOM    797  HA  GLU    55      -7.852   2.289   6.592  1.00 24.50           H 
ATOM    798 3HB  GLU    55      -8.583   2.879   8.879  1.00 38.87           H 
ATOM    799 2HB  GLU    55      -7.640   1.541   9.518  1.00 38.87           H 
ATOM    800 3HG  GLU    55     -10.022   1.021   9.380  1.00 38.87           H 
ATOM    801 2HG  GLU    55      -9.043  -0.058   8.390  1.00 38.87           H 
ATOM    802  N   ASP    56      -5.234   2.611   8.608  1.00 25.43           N 
ATOM    803  CA  ASP    56      -4.102   3.480   8.956  1.00 72.02           C 
ATOM    804  C   ASP    56      -3.191   3.719   7.738  1.00 71.12           C 
ATOM    805  O   ASP    56      -2.635   4.806   7.561  1.00 55.40           O 
ATOM    806  CB  ASP    56      -3.302   2.860  10.109  1.00 72.35           C 
ATOM    807  CG  ASP    56      -2.157   3.750  10.562  1.00 62.42           C 
ATOM    808  OD1 ASP    56      -2.426   4.820  11.139  1.00 53.10           O 
ATOM    809  OD2 ASP    56      -0.983   3.388  10.344  1.00 42.03           O 
ATOM    810  H   ASP    56      -5.316   1.741   9.049  1.00 38.87           H 
ATOM    811  HA  ASP    56      -4.504   4.430   9.280  1.00 33.13           H 
ATOM    812 3HB  ASP    56      -2.897   1.909   9.792  1.00 38.87           H 
ATOM    813 2HB  ASP    56      -3.962   2.699  10.952  1.00 38.87           H 
ATOM    814  N   ILE    57      -3.056   2.695   6.898  1.00 72.32           N 
ATOM    815  CA  ILE    57      -2.252   2.794   5.676  1.00 42.34           C 
ATOM    816  C   ILE    57      -2.869   3.807   4.693  1.00 13.41           C 
ATOM    817  O   ILE    57      -2.199   4.735   4.233  1.00 50.14           O 
ATOM    818  CB  ILE    57      -2.119   1.411   4.984  1.00 52.34           C 
ATOM    819  CG1 ILE    57      -1.555   0.377   5.975  1.00 62.34           C 
ATOM    820  CG2 ILE    57      -1.232   1.514   3.742  1.00 75.10           C 
ATOM    821  CD1 ILE    57      -1.460  -1.026   5.412  1.00 62.13           C 
ATOM    822  H   ILE    57      -3.512   1.851   7.104  1.00 38.87           H 
ATOM    823  HA  ILE    57      -1.264   3.133   5.955  1.00 63.13           H 
ATOM    824  HB  ILE    57      -3.104   1.094   4.666  1.00 55.12           H 
ATOM    825 3HG1 ILE    57      -2.194   0.339   6.847  1.00 38.87           H 
ATOM    826 2HG1 ILE    57      -0.563   0.677   6.276  1.00 38.87           H 
ATOM    827 1HG2 ILE    57      -1.150   0.545   3.270  1.00 38.87           H 
ATOM    828 2HG2 ILE    57      -0.249   1.859   4.028  1.00 38.87           H 
ATOM    829 3HG2 ILE    57      -1.668   2.216   3.046  1.00 38.87           H 
ATOM    830 1HD1 ILE    57      -2.443  -1.365   5.120  1.00 38.87           H 
ATOM    831 2HD1 ILE    57      -1.060  -1.689   6.165  1.00 38.87           H 
ATOM    832 3HD1 ILE    57      -0.809  -1.027   4.549  1.00 38.87           H 
ATOM    833  N   LEU    58      -4.158   3.631   4.396  1.00 30.44           N 
ATOM    834  CA  LEU    58      -4.887   4.540   3.500  1.00 61.54           C 
ATOM    835  C   LEU    58      -4.835   5.985   4.017  1.00 50.43           C 
ATOM    836  O   LEU    58      -4.753   6.934   3.236  1.00 73.43           O 
ATOM    837  CB  LEU    58      -6.350   4.097   3.356  1.00 50.24           C 
ATOM    838  CG  LEU    58      -6.562   2.680   2.795  1.00 43.33           C 
ATOM    839  CD1 LEU    58      -8.053   2.367   2.669  1.00 52.13           C 
ATOM    840  CD2 LEU    58      -5.852   2.516   1.452  1.00 33.40           C 
ATOM    841  H   LEU    58      -4.634   2.872   4.792  1.00 38.87           H 
ATOM    842  HA  LEU    58      -4.409   4.500   2.531  1.00  0.51           H 
ATOM    843 3HB  LEU    58      -6.852   4.797   2.703  1.00 38.87           H 
ATOM    844 2HB  LEU    58      -6.815   4.147   4.333  1.00 38.87           H 
ATOM    845  HG  LEU    58      -6.136   1.963   3.485  1.00 62.02           H 
ATOM    846 1HD1 LEU    58      -8.180   1.373   2.264  1.00 38.87           H 
ATOM    847 2HD1 LEU    58      -8.521   3.084   2.010  1.00 38.87           H 
ATOM    848 3HD1 LEU    58      -8.517   2.418   3.643  1.00 38.87           H 
ATOM    849 1HD2 LEU    58      -4.791   2.677   1.581  1.00 38.87           H 
ATOM    850 2HD2 LEU    58      -6.240   3.237   0.745  1.00 38.87           H 
ATOM    851 3HD2 LEU    58      -6.018   1.518   1.074  1.00 38.87           H 
ATOM    852  N   ARG    59      -4.891   6.136   5.338  1.00 11.23           N 
ATOM    853  CA  ARG    59      -4.777   7.449   5.982  1.00 25.24           C 
ATOM    854  C   ARG    59      -3.526   8.207   5.502  1.00 55.33           C 
ATOM    855  O   ARG    59      -3.619   9.327   4.989  1.00 65.22           O 
ATOM    856  CB  ARG    59      -4.711   7.274   7.509  1.00 64.02           C 
ATOM    857  CG  ARG    59      -4.328   8.546   8.269  1.00  0.44           C 
ATOM    858  CD  ARG    59      -3.902   8.249   9.706  1.00 74.21           C 
ATOM    859  NE  ARG    59      -2.835   7.248   9.764  1.00 51.41           N 
ATOM    860  CZ  ARG    59      -1.595   7.454   9.400  1.00 60.32           C 
ATOM    861  NH1 ARG    59      -1.207   8.617   8.977  1.00 71.44           N 
ATOM    862  NH2 ARG    59      -0.741   6.487   9.470  1.00 34.04           N 
ATOM    863  H   ARG    59      -5.019   5.340   5.900  1.00 38.87           H 
ATOM    864  HA  ARG    59      -5.657   8.023   5.730  1.00  4.43           H 
ATOM    865 3HB  ARG    59      -3.981   6.510   7.738  1.00 38.87           H 
ATOM    866 2HB  ARG    59      -5.680   6.947   7.864  1.00 38.87           H 
ATOM    867 3HG  ARG    59      -5.178   9.215   8.286  1.00 38.87           H 
ATOM    868 2HG  ARG    59      -3.507   9.026   7.757  1.00 38.87           H 
ATOM    869 3HD  ARG    59      -4.757   7.880  10.254  1.00 38.87           H 
ATOM    870 2HD  ARG    59      -3.551   9.163  10.163  1.00 38.87           H 
ATOM    871  HE  ARG    59      -3.072   6.359  10.101  1.00 63.33           H 
ATOM    872 1HH1 ARG    59      -1.852   9.375   8.934  1.00 38.87           H 
ATOM    873 2HH1 ARG    59      -0.259   8.751   8.688  1.00 38.87           H 
ATOM    874 1HH2 ARG    59      -1.033   5.593   9.808  1.00 38.87           H 
ATOM    875 2HH2 ARG    59       0.203   6.632   9.187  1.00 38.87           H 
ATOM    876  N   ASP    60      -2.359   7.585   5.668  1.00 53.22           N 
ATOM    877  CA  ASP    60      -1.088   8.234   5.346  1.00 63.13           C 
ATOM    878  C   ASP    60      -0.873   8.340   3.822  1.00 62.14           C 
ATOM    879  O   ASP    60      -0.331   9.332   3.328  1.00 44.05           O 
ATOM    880  CB  ASP    60       0.069   7.476   6.015  1.00 73.14           C 
ATOM    881  CG  ASP    60       1.209   8.400   6.410  1.00 25.13           C 
ATOM    882  OD1 ASP    60       2.176   8.534   5.637  1.00 61.03           O 
ATOM    883  OD2 ASP    60       1.129   9.006   7.505  1.00  0.21           O 
ATOM    884  H   ASP    60      -2.351   6.665   6.016  1.00 38.87           H 
ATOM    885  HA  ASP    60      -1.126   9.237   5.754  1.00 42.44           H 
ATOM    886 3HB  ASP    60       0.449   6.729   5.332  1.00 38.87           H 
ATOM    887 2HB  ASP    60      -0.298   6.987   6.906  1.00 38.87           H 
ATOM    888  N   LEU    61      -1.312   7.317   3.082  1.00 24.25           N 
ATOM    889  CA  LEU    61      -1.205   7.317   1.614  1.00 43.24           C 
ATOM    890  C   LEU    61      -2.027   8.455   0.985  1.00 51.04           C 
ATOM    891  O   LEU    61      -1.540   9.188   0.124  1.00 71.55           O 
ATOM    892  CB  LEU    61      -1.663   5.971   1.031  1.00  4.30           C 
ATOM    893  CG  LEU    61      -0.806   4.752   1.412  1.00 73.10           C 
ATOM    894  CD1 LEU    61      -1.315   3.497   0.704  1.00 71.04           C 
ATOM    895  CD2 LEU    61       0.664   5.004   1.086  1.00  0.30           C 
ATOM    896  H   LEU    61      -1.707   6.538   3.534  1.00 38.87           H 
ATOM    897  HA  LEU    61      -0.165   7.468   1.363  1.00 44.53           H 
ATOM    898 3HB  LEU    61      -1.665   6.054  -0.047  1.00 38.87           H 
ATOM    899 2HB  LEU    61      -2.678   5.788   1.358  1.00 38.87           H 
ATOM    900  HG  LEU    61      -0.888   4.584   2.477  1.00 74.01           H 
ATOM    901 1HD1 LEU    61      -2.333   3.298   1.008  1.00 38.87           H 
ATOM    902 2HD1 LEU    61      -0.691   2.654   0.970  1.00 38.87           H 
ATOM    903 3HD1 LEU    61      -1.281   3.646  -0.365  1.00 38.87           H 
ATOM    904 1HD2 LEU    61       0.764   5.260   0.041  1.00 38.87           H 
ATOM    905 2HD2 LEU    61       1.238   4.114   1.295  1.00 38.87           H 
ATOM    906 3HD2 LEU    61       1.033   5.819   1.694  1.00 38.87           H 
ATOM    907  N   ASN    62      -3.279   8.592   1.413  1.00 14.32           N 
ATOM    908  CA  ASN    62      -4.150   9.674   0.930  1.00 43.21           C 
ATOM    909  C   ASN    62      -3.579  11.055   1.291  1.00 40.41           C 
ATOM    910  O   ASN    62      -3.788  12.036   0.574  1.00 53.15           O 
ATOM    911  CB  ASN    62      -5.567   9.510   1.496  1.00 22.11           C 
ATOM    912  CG  ASN    62      -6.316   8.353   0.854  1.00 42.31           C 
ATOM    913  OD1 ASN    62      -6.193   8.102  -0.339  1.00 21.13           O 
ATOM    914  ND2 ASN    62      -7.086   7.629   1.641  1.00 42.20           N 
ATOM    915  H   ASN    62      -3.629   7.949   2.068  1.00 38.87           H 
ATOM    916  HA  ASN    62      -4.196   9.596  -0.147  1.00 21.13           H 
ATOM    917 3HB  ASN    62      -6.127  10.417   1.319  1.00 38.87           H 
ATOM    918 2HB  ASN    62      -5.507   9.332   2.560  1.00 38.87           H 
ATOM    919 1HD2 ASN    62      -7.139   7.870   2.586  1.00 38.87           H 
ATOM    920 2HD2 ASN    62      -7.568   6.874   1.242  1.00 38.87           H 
ATOM    921  N   ALA    63      -2.843  11.119   2.398  1.00 23.15           N 
ATOM    922  CA  ALA    63      -2.149  12.349   2.795  1.00 10.24           C 
ATOM    923  C   ALA    63      -1.080  12.743   1.759  1.00 72.40           C 
ATOM    924  O   ALA    63      -0.778  13.926   1.582  1.00 54.04           O 
ATOM    925  CB  ALA    63      -1.530  12.177   4.177  1.00 62.15           C 
ATOM    926  H   ALA    63      -2.767  10.323   2.966  1.00 38.87           H 
ATOM    927  HA  ALA    63      -2.886  13.139   2.853  1.00 22.24           H 
ATOM    928 1HB  ALA    63      -1.071  13.106   4.485  1.00 38.87           H 
ATOM    929 2HB  ALA    63      -0.780  11.400   4.143  1.00 38.87           H 
ATOM    930 3HB  ALA    63      -2.298  11.904   4.887  1.00 38.87           H 
ATOM    931  N   LEU    64      -0.514  11.739   1.077  1.00  2.21           N 
ATOM    932  CA  LEU    64       0.438  11.977  -0.019  1.00 60.51           C 
ATOM    933  C   LEU    64      -0.259  12.629  -1.224  1.00 22.12           C 
ATOM    934  O   LEU    64       0.378  13.298  -2.035  1.00 61.31           O 
ATOM    935  CB  LEU    64       1.087  10.657  -0.470  1.00 34.34           C 
ATOM    936  CG  LEU    64       1.870   9.892   0.607  1.00  0.14           C 
ATOM    937  CD1 LEU    64       2.339   8.543   0.064  1.00 70.33           C 
ATOM    938  CD2 LEU    64       3.054  10.720   1.105  1.00 23.33           C 
ATOM    939  H   LEU    64      -0.742  10.813   1.318  1.00 38.87           H 
ATOM    940  HA  LEU    64       1.209  12.644   0.344  1.00  5.14           H 
ATOM    941 3HB  LEU    64       1.765  10.874  -1.285  1.00 38.87           H 
ATOM    942 2HB  LEU    64       0.306  10.010  -0.845  1.00 38.87           H 
ATOM    943  HG  LEU    64       1.219   9.702   1.448  1.00 74.32           H 
ATOM    944 1HD1 LEU    64       2.894   8.019   0.829  1.00 38.87           H 
ATOM    945 2HD1 LEU    64       2.973   8.697  -0.798  1.00 38.87           H 
ATOM    946 3HD1 LEU    64       1.480   7.952  -0.224  1.00 38.87           H 
ATOM    947 1HD2 LEU    64       3.595  10.163   1.857  1.00 38.87           H 
ATOM    948 2HD2 LEU    64       2.694  11.643   1.535  1.00 38.87           H 
ATOM    949 3HD2 LEU    64       3.715  10.943   0.278  1.00 38.87           H 
ATOM    950  N   ALA    65      -1.567  12.402  -1.347  1.00  0.42           N 
ATOM    951  CA  ALA    65      -2.361  12.995  -2.428  1.00 64.02           C 
ATOM    952  C   ALA    65      -2.726  14.456  -2.120  1.00  4.00           C 
ATOM    953  O   ALA    65      -2.710  15.315  -3.006  1.00 25.43           O 
ATOM    954  CB  ALA    65      -3.621  12.168  -2.671  1.00 45.01           C 
ATOM    955  H   ALA    65      -2.010  11.816  -0.697  1.00 38.87           H 
ATOM    956  HA  ALA    65      -1.765  12.969  -3.331  1.00  3.23           H 
ATOM    957 1HB  ALA    65      -3.345  11.142  -2.874  1.00 38.87           H 
ATOM    958 2HB  ALA    65      -4.161  12.568  -3.518  1.00 38.87           H 
ATOM    959 3HB  ALA    65      -4.251  12.202  -1.794  1.00 38.87           H 
END
