
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   79 (  601),  selected   79 , name 2fi0_A
# Molecule2: number of CA atoms   63 (  926),  selected   63 , name T0469.pdb
# PARAMETERS: 2fi0_A.T0469.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    M     5_A      -       -           -
LGA    D     6_A      -       -           -
LGA    N     7_A      -       -           -
LGA    I     8_A      Q       3          5.240
LGA    I     9_A      K       4          3.310
LGA    -       -      F       5           -
LGA    D    10_A      T       6          3.046
LGA    V    11_A      K       7          2.419
LGA    S    12_A      D       8          1.020
LGA    I    13_A      M       9          2.102
LGA    P    14_A      T      10          1.816
LGA    V    15_A      F      11          0.663
LGA    A    16_A      A      12          1.100
LGA    E    17_A      Q      13          1.825
LGA    V    18_A      A      14          1.551
LGA    V    19_A      L      15          0.852
LGA    D    20_A      Q      16          2.062
LGA    K    21_A      T      17          2.724
LGA    H    22_A      H      18          2.023
LGA    P    23_A      P      19          1.862
LGA    E    24_A      G      20          2.218
LGA    V    25_A      V      21          1.340
LGA    L    26_A      A      22          0.757
LGA    E    27_A      G      23          0.723
LGA    I    28_A      V      24          1.061
LGA    L    29_A      L      25          1.299
LGA    V    30_A      R      26          1.137
LGA    E    31_A      S      27          1.378
LGA    L    32_A      Y      28          1.868
LGA    G    33_A      N      29          2.647
LGA    F    34_A      L      30          0.652
LGA    K    35_A      G      31          1.802
LGA    P    36_A      C      32          1.487
LGA    L    37_A      I      33          3.332
LGA    A    38_A      -       -           -
LGA    N    39_A      -       -           -
LGA    P    40_A      -       -           -
LGA    L    41_A      -       -           -
LGA    M    42_A      -       -           -
LGA    R    43_A      G      34          1.845
LGA    N    44_A      C      35           #
LGA    T    45_A      M      36          5.855
LGA    V    46_A      G      37          1.382
LGA    G    47_A      A      38          2.301
LGA    R    48_A      Q      39          2.835
LGA    K    49_A      N      40          3.374
LGA    V    50_A      E      41          1.696
LGA    S    51_A      S      42          1.112
LGA    L    52_A      L      43          0.606
LGA    K    53_A      E      44          0.960
LGA    Q    54_A      Q      45          0.597
LGA    G    55_A      G      46          0.805
LGA    S    56_A      A      47          0.817
LGA    K    57_A      N      48          0.744
LGA    L    58_A      A      49          0.494
LGA    A    59_A      H      50          0.809
LGA    G    60_A      G      51          0.731
LGA    T    61_A      L      52          0.937
LGA    P    62_A      N      53          1.297
LGA    M    63_A      V      54          2.102
LGA    D    64_A      E      55          2.448
LGA    K    65_A      D      56          1.614
LGA    I    66_A      I      57          1.045
LGA    V    67_A      L      58          2.487
LGA    R    68_A      R      59          2.409
LGA    T    69_A      D      60          1.888
LGA    L    70_A      L      61          2.155
LGA    E    71_A      N      62          3.555
LGA    A    72_A      A      63          3.629
LGA    N    73_A      L      64          3.416
LGA    G    74_A      -       -           -
LGA    Y    75_A      A      65          3.059
LGA    E    76_A      -       -           -
LGA    V    77_A      -       -           -
LGA    I    78_A      -       -           -
LGA    G    79_A      -       -           -
LGA    L    80_A      -       -           -
LGA    D    81_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   79   63    5.0     61    2.17    22.95     79.542     2.684

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.067482 * X  +   0.731980 * Y  +   0.677976 * Z  + -25.153154
  Y_new =  -0.691877 * X  +  -0.455264 * Y  +   0.560394 * Z  +  21.289087
  Z_new =   0.718855 * X  +  -0.506892 * Y  +   0.475718 * Z  + -29.783703 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.817114    2.324479  [ DEG:   -46.8172    133.1828 ]
  Theta =  -0.802154   -2.339438  [ DEG:   -45.9600   -134.0399 ]
  Phi   =  -1.473569    1.668023  [ DEG:   -84.4293     95.5707 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fi0_A                                        
REMARK     2: T0469.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fi0_A.T0469.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   79   63   5.0   61   2.17   22.95  79.542
REMARK  ---------------------------------------------------------- 
MOLECULE 2fi0_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   27-DEC-05   2FI0              
TITLE     THE CRYSTAL STRUCTURE OF THE CONSERVED DOMAIN PROTEIN FROM            
TITLE    2 STREPTOCOCCUS PNEUMONIAE TIGR4                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CONSERVED DOMAIN PROTEIN;                                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PNEUMONIAE;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: TIGR4;                                                       
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PDM68                                     
KEYWDS    STRUCTURAL GENOMICS,STREPTOCOCCUS PNEUMONIAE, PSI, PROTEIN            
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,H.LI,J.ABDULLAH,F.COLLART,M.CYMBOROWSKI,W.MINOR,              
AUTHOR   2 A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   1   07-FEB-06 2FI0    0                                                
JRNL        AUTH   R.ZHANG,H.LI,J.ABDULLAH,F.COLLART,M.CYMBOROWSKI,             
JRNL        AUTH 2 W.MINOR,A.JOACHIMIAK                                         
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE CONSERVED DOMAIN                
JRNL        TITL 2 PROTEIN FROM STREPTOCOCCUS PNEUMONIAE TIGR4                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2FI0 A    1    81  GB     14972036 AAK74717         1     81             
SEQRES   1 A   81  MET GLU VAL VAL MET ASP ASN ILE ILE ASP VAL SER ILE          
SEQRES   2 A   81  PRO VAL ALA GLU VAL VAL ASP LYS HIS PRO GLU VAL LEU          
SEQRES   3 A   81  GLU ILE LEU VAL GLU LEU GLY PHE LYS PRO LEU ALA ASN          
SEQRES   4 A   81  PRO LEU MET ARG ASN THR VAL GLY ARG LYS VAL SER LEU          
SEQRES   5 A   81  LYS GLN GLY SER LYS LEU ALA GLY THR PRO MET ASP LYS          
SEQRES   6 A   81  ILE VAL ARG THR LEU GLU ALA ASN GLY TYR GLU VAL ILE          
SEQRES   7 A   81  GLY LEU ASP                                                  
FORMUL   2  HOH   *57(H2 O)                                                     
CRYST1   92.420   92.420   41.343  90.00  90.00 120.00 H 3           9          
ATOM      1  N   VAL A   3     -11.965  20.445  -5.154  1.00 59.19           N  
ATOM      2  CA  VAL A   3     -12.310  19.024  -5.473  1.00 59.23           C  
ATOM      3  C   VAL A   3     -11.067  18.131  -5.543  1.00 59.14           C  
ATOM      4  O   VAL A   3      -9.971  18.591  -5.879  1.00 59.27           O  
ATOM      5  CB  VAL A   3     -13.094  18.898  -6.810  1.00 59.36           C  
ATOM      6  CG1 VAL A   3     -14.239  19.903  -6.858  1.00 59.53           C  
ATOM      7  CG2 VAL A   3     -12.173  19.068  -8.024  1.00 59.70           C  
ATOM      8  N   VAL A   4     -11.244  16.850  -5.239  1.00 58.90           N  
ATOM      9  CA  VAL A   4     -10.138  15.907  -5.315  1.00 58.71           C  
ATOM     10  C   VAL A   4     -10.010  15.370  -6.739  1.00 58.46           C  
ATOM     11  O   VAL A   4     -10.993  14.973  -7.374  1.00 58.38           O  
ATOM     12  CB  VAL A   4     -10.274  14.775  -4.301  1.00 58.61           C  
ATOM     13  CG1 VAL A   4      -9.066  13.855  -4.377  1.00 58.76           C  
ATOM     14  CG2 VAL A   4     -10.428  15.359  -2.903  1.00 58.61           C  
ATOM     15  N   MET A   5      -8.780  15.391  -7.228  1.00 58.05           N  
ATOM     16  CA  MET A   5      -8.489  15.120  -8.626  1.00 57.82           C  
ATOM     17  C   MET A   5      -7.248  14.241  -8.770  1.00 57.53           C  
ATOM     18  O   MET A   5      -7.203  13.335  -9.598  1.00 57.44           O  
ATOM     19  CB  MET A   5      -8.260  16.448  -9.341  1.00 57.91           C  
ATOM     20  CG  MET A   5      -8.395  16.385 -10.855  1.00 57.98           C  
ATOM     21  SD  MET A   5     -10.043  15.979 -11.454  1.00 55.46           S  
ATOM     22  CE  MET A   5     -11.117  16.951 -10.399  1.00 54.72           C  
ATOM     23  N   ASP A   6      -6.245  14.530  -7.950  1.00 57.06           N  
ATOM     24  CA  ASP A   6      -4.976  13.845  -7.995  1.00 56.44           C  
ATOM     25  C   ASP A   6      -4.778  13.118  -6.666  1.00 55.10           C  
ATOM     26  O   ASP A   6      -5.505  13.358  -5.689  1.00 55.33           O  
ATOM     27  CB  ASP A   6      -3.854  14.876  -8.234  1.00 57.53           C  
ATOM     28  CG  ASP A   6      -4.107  15.750  -9.458  1.00 61.29           C  
ATOM     29  OD1 ASP A   6      -4.730  15.250 -10.426  1.00 67.59           O  
ATOM     30  OD2 ASP A   6      -3.677  16.935  -9.476  1.00 66.09           O  
ATOM     31  N   ASN A   7      -3.801  12.227  -6.640  1.00 52.87           N  
ATOM     32  CA  ASN A   7      -3.389  11.559  -5.405  1.00 51.51           C  
ATOM     33  C   ASN A   7      -4.483  10.678  -4.774  1.00 49.65           C  
ATOM     34  O   ASN A   7      -4.621  10.610  -3.570  1.00 48.93           O  
ATOM     35  CB  ASN A   7      -2.809  12.588  -4.410  1.00 51.76           C  
ATOM     36  CG  ASN A   7      -1.552  13.287  -4.953  1.00 52.98           C  
ATOM     37  OD1 ASN A   7      -0.532  12.646  -5.219  1.00 52.77           O  
ATOM     38  ND2 ASN A   7      -1.644  14.604  -5.155  1.00 55.32           N  
ATOM     39  N   ILE A   8      -5.222   9.970  -5.622  1.00 47.57           N  
ATOM     40  CA  ILE A   8      -6.257   9.039  -5.193  1.00 46.42           C  
ATOM     41  C   ILE A   8      -5.634   7.641  -5.168  1.00 45.49           C  
ATOM     42  O   ILE A   8      -5.001   7.228  -6.140  1.00 44.57           O  
ATOM     43  CB  ILE A   8      -7.474   9.087  -6.154  1.00 45.73           C  
ATOM     44  CG1 ILE A   8      -8.140  10.466  -6.095  1.00 45.11           C  
ATOM     45  CG2 ILE A   8      -8.478   7.987  -5.840  1.00 45.62           C  
ATOM     46  CD1 ILE A   8      -9.015  10.745  -7.292  1.00 45.35           C  
ATOM     47  N   ILE A   9      -5.806   6.937  -4.053  1.00 44.25           N  
ATOM     48  CA  ILE A   9      -5.275   5.595  -3.874  1.00 44.49           C  
ATOM     49  C   ILE A   9      -6.421   4.629  -3.616  1.00 43.58           C  
ATOM     50  O   ILE A   9      -7.223   4.825  -2.719  1.00 42.16           O  
ATOM     51  CB  ILE A   9      -4.227   5.538  -2.744  1.00 44.03           C  
ATOM     52  CG1 ILE A   9      -2.986   6.312  -3.187  1.00 46.19           C  
ATOM     53  CG2 ILE A   9      -3.878   4.065  -2.394  1.00 44.42           C  
ATOM     54  CD1 ILE A   9      -1.928   6.492  -2.120  1.00 47.06           C  
ATOM     55  N   ASP A  10      -6.489   3.597  -4.443  1.00 43.67           N  
ATOM     56  CA  ASP A  10      -7.501   2.568  -4.333  1.00 43.88           C  
ATOM     57  C   ASP A  10      -6.860   1.385  -3.593  1.00 44.10           C  
ATOM     58  O   ASP A  10      -5.871   0.814  -4.054  1.00 44.04           O  
ATOM     59  CB  ASP A  10      -7.970   2.178  -5.740  1.00 43.53           C  
ATOM     60  CG  ASP A  10      -9.214   1.309  -5.729  1.00 43.79           C  
ATOM     61  OD1 ASP A  10      -9.435   0.585  -4.738  1.00 41.41           O  
ATOM     62  OD2 ASP A  10      -9.970   1.346  -6.727  1.00 43.97           O  
ATOM     63  N   VAL A  11      -7.412   1.037  -2.432  1.00 44.00           N  
ATOM     64  CA  VAL A  11      -6.835  -0.029  -1.616  1.00 44.15           C  
ATOM     65  C   VAL A  11      -7.320  -1.402  -2.087  1.00 44.09           C  
ATOM     66  O   VAL A  11      -6.930  -2.416  -1.523  1.00 43.26           O  
ATOM     67  CB  VAL A  11      -7.116   0.168  -0.084  1.00 44.10           C  
ATOM     68  CG1 VAL A  11      -6.447   1.433   0.430  1.00 44.36           C  
ATOM     69  CG2 VAL A  11      -8.615   0.190   0.231  1.00 43.81           C  
ATOM     70  N   SER A  12      -8.171  -1.427  -3.114  1.00 44.43           N  
ATOM     71  CA  SER A  12      -8.740  -2.672  -3.615  1.00 45.08           C  
ATOM     72  C   SER A  12      -8.090  -3.209  -4.879  1.00 45.27           C  
ATOM     73  O   SER A  12      -8.505  -4.244  -5.360  1.00 46.46           O  
ATOM     74  CB  SER A  12     -10.246  -2.525  -3.848  1.00 45.06           C  
ATOM     75  OG  SER A  12     -10.522  -1.799  -5.033  1.00 45.99           O  
ATOM     76  N   ILE A  13      -7.080  -2.524  -5.408  1.00 45.57           N  
ATOM     77  CA  ILE A  13      -6.372  -2.961  -6.612  1.00 45.58           C  
ATOM     78  C   ILE A  13      -4.955  -3.432  -6.222  1.00 46.02           C  
ATOM     79  O   ILE A  13      -4.485  -3.118  -5.130  1.00 46.15           O  
ATOM     80  CB  ILE A  13      -6.311  -1.827  -7.693  1.00 45.64           C  
ATOM     81  CG1 ILE A  13      -5.469  -0.635  -7.220  1.00 45.77           C  
ATOM     82  CG2 ILE A  13      -7.724  -1.366  -8.079  1.00 45.14           C  
ATOM     83  CD1 ILE A  13      -5.185   0.362  -8.299  1.00 45.51           C  
ATOM     84  N   PRO A  14      -4.277  -4.194  -7.104  1.00 46.26           N  
ATOM     85  CA  PRO A  14      -2.933  -4.689  -6.778  1.00 46.49           C  
ATOM     86  C   PRO A  14      -1.940  -3.598  -6.379  1.00 46.48           C  
ATOM     87  O   PRO A  14      -1.920  -2.538  -6.980  1.00 46.49           O  
ATOM     88  CB  PRO A  14      -2.486  -5.388  -8.076  1.00 46.54           C  
ATOM     89  CG  PRO A  14      -3.752  -5.787  -8.736  1.00 46.42           C  
ATOM     90  CD  PRO A  14      -4.731  -4.679  -8.420  1.00 46.17           C  
ATOM     91  N   VAL A  15      -1.121  -3.867  -5.368  1.00 46.87           N  
ATOM     92  CA  VAL A  15      -0.203  -2.854  -4.842  1.00 47.71           C  
ATOM     93  C   VAL A  15       0.749  -2.308  -5.925  1.00 47.55           C  
ATOM     94  O   VAL A  15       1.083  -1.116  -5.926  1.00 46.93           O  
ATOM     95  CB  VAL A  15       0.602  -3.372  -3.624  1.00 48.05           C  
ATOM     96  CG1 VAL A  15       1.599  -2.326  -3.161  1.00 50.01           C  
ATOM     97  CG2 VAL A  15      -0.325  -3.673  -2.492  1.00 50.05           C  
ATOM     98  N   ALA A  16       1.158  -3.168  -6.849  1.00 47.51           N  
ATOM     99  CA  ALA A  16       1.999  -2.742  -7.980  1.00 47.97           C  
ATOM    100  C   ALA A  16       1.347  -1.638  -8.841  1.00 48.05           C  
ATOM    101  O   ALA A  16       2.030  -0.711  -9.289  1.00 47.74           O  
ATOM    102  CB  ALA A  16       2.357  -3.934  -8.848  1.00 48.02           C  
ATOM    103  N   GLU A  17       0.041  -1.750  -9.080  1.00 47.87           N  
ATOM    104  CA  GLU A  17      -0.683  -0.737  -9.849  1.00 48.06           C  
ATOM    105  C   GLU A  17      -0.719   0.606  -9.113  1.00 47.41           C  
ATOM    106  O   GLU A  17      -0.629   1.676  -9.724  1.00 47.07           O  
ATOM    107  CB  GLU A  17      -2.115  -1.185 -10.126  1.00 48.31           C  
ATOM    108  CG  GLU A  17      -2.231  -2.323 -11.098  1.00 49.55           C  
ATOM    109  CD  GLU A  17      -3.676  -2.687 -11.418  1.00 50.17           C  
ATOM    110  OE1 GLU A  17      -4.556  -1.792 -11.348  1.00 53.46           O  
ATOM    111  OE2 GLU A  17      -3.924  -3.873 -11.755  1.00 52.57           O  
ATOM    112  N   VAL A  18      -0.867   0.539  -7.800  1.00 46.61           N  
ATOM    113  CA  VAL A  18      -0.811   1.731  -6.980  1.00 46.66           C  
ATOM    114  C   VAL A  18       0.560   2.405  -7.154  1.00 46.27           C  
ATOM    115  O   VAL A  18       0.632   3.591  -7.417  1.00 45.10           O  
ATOM    116  CB  VAL A  18      -1.092   1.434  -5.490  1.00 45.88           C  
ATOM    117  CG1 VAL A  18      -0.910   2.677  -4.668  1.00 46.04           C  
ATOM    118  CG2 VAL A  18      -2.498   0.888  -5.305  1.00 46.59           C  
ATOM    119  N   VAL A  19       1.634   1.629  -7.030  1.00 46.61           N  
ATOM    120  CA  VAL A  19       2.985   2.187  -6.998  1.00 46.82           C  
ATOM    121  C   VAL A  19       3.403   2.719  -8.375  1.00 47.07           C  
ATOM    122  O   VAL A  19       4.072   3.743  -8.458  1.00 46.44           O  
ATOM    123  CB  VAL A  19       4.005   1.165  -6.436  1.00 46.58           C  
ATOM    124  CG1 VAL A  19       5.456   1.669  -6.588  1.00 46.77           C  
ATOM    125  CG2 VAL A  19       3.704   0.875  -4.989  1.00 46.55           C  
ATOM    126  N   ASP A  20       2.988   2.025  -9.434  1.00 47.58           N  
ATOM    127  CA  ASP A  20       3.185   2.490 -10.799  1.00 48.32           C  
ATOM    128  C   ASP A  20       2.559   3.861 -11.030  1.00 48.48           C  
ATOM    129  O   ASP A  20       3.162   4.725 -11.657  1.00 47.49           O  
ATOM    130  CB  ASP A  20       2.595   1.486 -11.806  1.00 49.01           C  
ATOM    131  CG  ASP A  20       3.429   0.215 -11.932  1.00 50.50           C  
ATOM    132  OD1 ASP A  20       4.624   0.212 -11.545  1.00 52.97           O  
ATOM    133  OD2 ASP A  20       2.882  -0.788 -12.432  1.00 53.15           O  
ATOM    134  N   LYS A  21       1.347   4.060 -10.514  1.00 48.55           N  
ATOM    135  CA  LYS A  21       0.670   5.337 -10.680  1.00 48.52           C  
ATOM    136  C   LYS A  21       1.254   6.400  -9.748  1.00 48.02           C  
ATOM    137  O   LYS A  21       1.363   7.564 -10.133  1.00 47.50           O  
ATOM    138  CB  LYS A  21      -0.827   5.171 -10.446  1.00 48.88           C  
ATOM    139  CG  LYS A  21      -1.623   6.440 -10.656  1.00 49.66           C  
ATOM    140  CD  LYS A  21      -3.124   6.144 -10.753  1.00 50.26           C  
ATOM    141  CE  LYS A  21      -3.813   7.089 -11.745  1.00 51.82           C  
ATOM    142  NZ  LYS A  21      -4.896   6.353 -12.458  1.00 54.45           N  
ATOM    143  N   HIS A  22       1.647   5.996  -8.541  1.00 47.44           N  
ATOM    144  CA  HIS A  22       2.173   6.920  -7.533  1.00 47.54           C  
ATOM    145  C   HIS A  22       3.543   6.475  -6.996  1.00 47.27           C  
ATOM    146  O   HIS A  22       3.613   5.958  -5.874  1.00 46.73           O  
ATOM    147  CB  HIS A  22       1.199   7.008  -6.352  1.00 47.64           C  
ATOM    148  CG  HIS A  22      -0.191   7.416  -6.729  1.00 48.13           C  
ATOM    149  ND1 HIS A  22      -1.233   6.517  -6.794  1.00 49.25           N  
ATOM    150  CD2 HIS A  22      -0.717   8.625  -7.046  1.00 49.18           C  
ATOM    151  CE1 HIS A  22      -2.340   7.153  -7.134  1.00 48.16           C  
ATOM    152  NE2 HIS A  22      -2.056   8.434  -7.285  1.00 49.58           N  
ATOM    153  N   PRO A  23       4.633   6.669  -7.778  1.00 47.14           N  
ATOM    154  CA  PRO A  23       5.963   6.211  -7.323  1.00 47.24           C  
ATOM    155  C   PRO A  23       6.360   6.742  -5.938  1.00 47.09           C  
ATOM    156  O   PRO A  23       6.981   6.030  -5.158  1.00 46.32           O  
ATOM    157  CB  PRO A  23       6.926   6.720  -8.412  1.00 47.49           C  
ATOM    158  CG  PRO A  23       6.081   7.003  -9.614  1.00 47.55           C  
ATOM    159  CD  PRO A  23       4.670   7.269  -9.123  1.00 47.22           C  
ATOM    160  N   GLU A  24       5.960   7.972  -5.636  1.00 47.49           N  
ATOM    161  CA  GLU A  24       6.231   8.618  -4.333  1.00 47.80           C  
ATOM    162  C   GLU A  24       5.581   7.922  -3.130  1.00 47.55           C  
ATOM    163  O   GLU A  24       6.004   8.133  -1.988  1.00 48.05           O  
ATOM    164  CB  GLU A  24       5.754  10.082  -4.314  1.00 48.61           C  
ATOM    165  CG  GLU A  24       5.368  10.699  -5.672  1.00 52.09           C  
ATOM    166  CD  GLU A  24       3.994  10.219  -6.195  1.00 54.59           C  
ATOM    167  OE1 GLU A  24       3.910   9.979  -7.434  1.00 55.39           O  
ATOM    168  OE2 GLU A  24       3.022  10.092  -5.384  1.00 54.48           O  
ATOM    169  N   VAL A  25       4.538   7.130  -3.359  1.00 46.95           N  
ATOM    170  CA  VAL A  25       3.857   6.465  -2.250  1.00 46.44           C  
ATOM    171  C   VAL A  25       4.641   5.255  -1.723  1.00 46.16           C  
ATOM    172  O   VAL A  25       4.382   4.806  -0.614  1.00 45.06           O  
ATOM    173  CB  VAL A  25       2.405   6.061  -2.619  1.00 46.33           C  
ATOM    174  CG1 VAL A  25       2.365   4.729  -3.344  1.00 47.39           C  
ATOM    175  CG2 VAL A  25       1.514   6.022  -1.360  1.00 46.52           C  
ATOM    176  N   LEU A  26       5.608   4.746  -2.496  1.00 46.01           N  
ATOM    177  CA  LEU A  26       6.379   3.564  -2.076  1.00 46.37           C  
ATOM    178  C   LEU A  26       7.092   3.778  -0.731  1.00 46.53           C  
ATOM    179  O   LEU A  26       7.058   2.912   0.138  1.00 46.52           O  
ATOM    180  CB  LEU A  26       7.389   3.152  -3.158  1.00 46.36           C  
ATOM    181  CG  LEU A  26       8.219   1.889  -2.893  1.00 46.21           C  
ATOM    182  CD1 LEU A  26       7.315   0.687  -2.635  1.00 46.69           C  
ATOM    183  CD2 LEU A  26       9.168   1.616  -4.049  1.00 46.06           C  
ATOM    184  N   GLU A  27       7.705   4.945  -0.562  1.00 47.09           N  
ATOM    185  CA  GLU A  27       8.398   5.315   0.679  1.00 47.38           C  
ATOM    186  C   GLU A  27       7.475   5.254   1.910  1.00 47.51           C  
ATOM    187  O   GLU A  27       7.921   4.965   3.031  1.00 47.59           O  
ATOM    188  CB  GLU A  27       8.960   6.731   0.534  1.00 47.43           C  
ATOM    189  CG  GLU A  27       9.696   7.264   1.760  1.00 48.31           C  
ATOM    190  CD  GLU A  27      10.166   8.706   1.591  1.00 49.27           C  
ATOM    191  OE1 GLU A  27       9.400   9.528   1.032  1.00 52.98           O  
ATOM    192  OE2 GLU A  27      11.297   9.013   2.031  1.00 51.91           O  
ATOM    193  N   ILE A  28       6.192   5.534   1.690  1.00 47.31           N  
ATOM    194  CA  ILE A  28       5.204   5.452   2.747  1.00 47.26           C  
ATOM    195  C   ILE A  28       4.843   4.001   3.023  1.00 46.80           C  
ATOM    196  O   ILE A  28       4.827   3.580   4.172  1.00 46.68           O  
ATOM    197  CB  ILE A  28       3.933   6.252   2.393  1.00 47.25           C  
ATOM    198  CG1 ILE A  28       4.277   7.742   2.262  1.00 47.38           C  
ATOM    199  CG2 ILE A  28       2.875   6.033   3.464  1.00 47.35           C  
ATOM    200  CD1 ILE A  28       3.244   8.553   1.524  1.00 47.97           C  
ATOM    201  N   LEU A  29       4.559   3.247   1.964  1.00 46.66           N  
ATOM    202  CA  LEU A  29       4.124   1.855   2.089  1.00 46.75           C  
ATOM    203  C   LEU A  29       5.150   0.946   2.782  1.00 46.60           C  
ATOM    204  O   LEU A  29       4.755   0.044   3.522  1.00 45.85           O  
ATOM    205  CB  LEU A  29       3.762   1.275   0.713  1.00 46.52           C  
ATOM    206  CG  LEU A  29       2.591   1.956  -0.018  1.00 47.41           C  
ATOM    207  CD1 LEU A  29       2.280   1.200  -1.324  1.00 48.59           C  
ATOM    208  CD2 LEU A  29       1.348   2.057   0.846  1.00 48.44           C  
ATOM    209  N   VAL A  30       6.449   1.182   2.562  1.00 46.72           N  
ATOM    210  CA  VAL A  30       7.482   0.343   3.182  1.00 47.13           C  
ATOM    211  C   VAL A  30       7.554   0.539   4.692  1.00 47.25           C  
ATOM    212  O   VAL A  30       8.064  -0.325   5.413  1.00 47.01           O  
ATOM    213  CB  VAL A  30       8.913   0.539   2.552  1.00 47.35           C  
ATOM    214  CG1 VAL A  30       8.883   0.286   1.044  1.00 46.46           C  
ATOM    215  CG2 VAL A  30       9.499   1.921   2.886  1.00 47.78           C  
ATOM    216  N   GLU A  31       7.044   1.674   5.165  1.00 47.75           N  
ATOM    217  CA  GLU A  31       6.896   1.922   6.596  1.00 48.27           C  
ATOM    218  C   GLU A  31       5.567   1.382   7.148  1.00 48.46           C  
ATOM    219  O   GLU A  31       5.317   1.503   8.340  1.00 48.73           O  
ATOM    220  CB  GLU A  31       7.016   3.423   6.888  1.00 48.56           C  
ATOM    221  CG  GLU A  31       8.380   4.022   6.547  1.00 50.03           C  
ATOM    222  CD  GLU A  31       9.516   3.425   7.379  1.00 52.28           C  
ATOM    223  OE1 GLU A  31      10.642   3.252   6.849  1.00 54.44           O  
ATOM    224  OE2 GLU A  31       9.284   3.117   8.569  1.00 54.33           O  
ATOM    225  N   LEU A  32       4.732   0.786   6.294  1.00 48.51           N  
ATOM    226  CA  LEU A  32       3.412   0.278   6.700  1.00 48.64           C  
ATOM    227  C   LEU A  32       3.261  -1.242   6.495  1.00 48.80           C  
ATOM    228  O   LEU A  32       2.142  -1.761   6.407  1.00 49.11           O  
ATOM    229  CB  LEU A  32       2.314   1.006   5.931  1.00 48.49           C  
ATOM    230  CG  LEU A  32       2.118   2.499   6.229  1.00 48.55           C  
ATOM    231  CD1 LEU A  32       1.238   3.096   5.170  1.00 49.39           C  
ATOM    232  CD2 LEU A  32       1.528   2.717   7.600  1.00 47.49           C  
ATOM    233  N   GLY A  33       4.383  -1.944   6.423  1.00 48.82           N  
ATOM    234  CA  GLY A  33       4.387  -3.410   6.313  1.00 48.92           C  
ATOM    235  C   GLY A  33       4.596  -3.947   4.908  1.00 48.60           C  
ATOM    236  O   GLY A  33       4.422  -5.136   4.667  1.00 48.42           O  
ATOM    237  N   PHE A  34       4.954  -3.075   3.975  1.00 48.66           N  
ATOM    238  CA  PHE A  34       5.118  -3.465   2.571  1.00 49.11           C  
ATOM    239  C   PHE A  34       6.568  -3.328   2.133  1.00 49.09           C  
ATOM    240  O   PHE A  34       6.853  -3.147   0.946  1.00 49.41           O  
ATOM    241  CB  PHE A  34       4.196  -2.632   1.669  1.00 48.95           C  
ATOM    242  CG  PHE A  34       2.744  -2.883   1.915  1.00 49.17           C  
ATOM    243  CD1 PHE A  34       2.086  -3.901   1.245  1.00 48.46           C  
ATOM    244  CD2 PHE A  34       2.030  -2.113   2.832  1.00 49.01           C  
ATOM    245  CE1 PHE A  34       0.741  -4.147   1.478  1.00 48.67           C  
ATOM    246  CE2 PHE A  34       0.690  -2.362   3.068  1.00 49.45           C  
ATOM    247  CZ  PHE A  34       0.047  -3.385   2.389  1.00 48.97           C  
ATOM    248  N   LYS A  35       7.489  -3.460   3.082  1.00 49.36           N  
ATOM    249  CA  LYS A  35       8.884  -3.123   2.808  1.00 49.64           C  
ATOM    250  C   LYS A  35       9.611  -4.119   1.891  1.00 49.52           C  
ATOM    251  O   LYS A  35      10.550  -3.719   1.192  1.00 49.18           O  
ATOM    252  CB  LYS A  35       9.651  -2.819   4.109  1.00 50.07           C  
ATOM    253  CG  LYS A  35      10.397  -3.955   4.785  1.00 51.18           C  
ATOM    254  CD  LYS A  35      11.906  -3.739   4.703  1.00 52.96           C  
ATOM    255  CE  LYS A  35      12.357  -2.516   5.521  1.00 53.48           C  
ATOM    256  NZ  LYS A  35      13.860  -2.449   5.616  1.00 53.48           N  
ATOM    257  N   PRO A  36       9.176  -5.404   1.867  1.00 49.65           N  
ATOM    258  CA  PRO A  36       9.718  -6.276   0.819  1.00 49.79           C  
ATOM    259  C   PRO A  36       9.384  -5.783  -0.591  1.00 49.83           C  
ATOM    260  O   PRO A  36      10.062  -6.134  -1.541  1.00 50.27           O  
ATOM    261  CB  PRO A  36       9.037  -7.629   1.088  1.00 49.91           C  
ATOM    262  CG  PRO A  36       8.581  -7.563   2.495  1.00 49.75           C  
ATOM    263  CD  PRO A  36       8.247  -6.139   2.746  1.00 49.35           C  
ATOM    264  N   LEU A  37       8.357  -4.963  -0.734  1.00 49.74           N  
ATOM    265  CA  LEU A  37       7.996  -4.480  -2.059  1.00 49.94           C  
ATOM    266  C   LEU A  37       8.807  -3.247  -2.477  1.00 49.47           C  
ATOM    267  O   LEU A  37       8.530  -2.675  -3.516  1.00 49.45           O  
ATOM    268  CB  LEU A  37       6.487  -4.202  -2.141  1.00 50.28           C  
ATOM    269  CG  LEU A  37       5.550  -5.311  -1.620  1.00 51.03           C  
ATOM    270  CD1 LEU A  37       4.180  -5.205  -2.274  1.00 51.11           C  
ATOM    271  CD2 LEU A  37       6.098  -6.699  -1.850  1.00 51.68           C  
ATOM    272  N   ALA A  38       9.789  -2.835  -1.671  1.00 48.98           N  
ATOM    273  CA  ALA A  38      10.727  -1.775  -2.072  1.00 48.83           C  
ATOM    274  C   ALA A  38      11.474  -2.202  -3.327  1.00 48.60           C  
ATOM    275  O   ALA A  38      11.689  -1.399  -4.238  1.00 49.27           O  
ATOM    276  CB  ALA A  38      11.736  -1.472  -0.955  1.00 48.91           C  
ATOM    277  N   ASN A  39      11.884  -3.470  -3.349  1.00 47.98           N  
ATOM    278  CA  ASN A  39      12.548  -4.059  -4.501  1.00 47.36           C  
ATOM    279  C   ASN A  39      11.537  -4.324  -5.630  1.00 46.66           C  
ATOM    280  O   ASN A  39      10.513  -4.984  -5.402  1.00 46.43           O  
ATOM    281  CB  ASN A  39      13.261  -5.355  -4.089  1.00 47.47           C  
ATOM    282  CG  ASN A  39      14.135  -5.917  -5.192  1.00 48.44           C  
ATOM    283  OD1 ASN A  39      13.646  -6.598  -6.093  1.00 50.91           O  
ATOM    284  ND2 ASN A  39      15.442  -5.644  -5.122  1.00 49.42           N  
ATOM    285  N   PRO A  40      11.815  -3.799  -6.847  1.00 45.89           N  
ATOM    286  CA  PRO A  40      10.928  -3.962  -7.999  1.00 45.51           C  
ATOM    287  C   PRO A  40      10.563  -5.401  -8.329  1.00 45.00           C  
ATOM    288  O   PRO A  40       9.418  -5.666  -8.670  1.00 44.66           O  
ATOM    289  CB  PRO A  40      11.728  -3.351  -9.149  1.00 45.31           C  
ATOM    290  CG  PRO A  40      12.662  -2.426  -8.521  1.00 45.63           C  
ATOM    291  CD  PRO A  40      12.995  -2.978  -7.187  1.00 45.79           C  
ATOM    292  N   LEU A  41      11.533  -6.314  -8.258  1.00 44.89           N  
ATOM    293  CA  LEU A  41      11.283  -7.717  -8.567  1.00 44.99           C  
ATOM    294  C   LEU A  41      10.212  -8.286  -7.626  1.00 44.79           C  
ATOM    295  O   LEU A  41       9.270  -8.926  -8.090  1.00 43.98           O  
ATOM    296  CB  LEU A  41      12.581  -8.539  -8.507  1.00 44.73           C  
ATOM    297  CG  LEU A  41      12.476 -10.045  -8.767  1.00 44.83           C  
ATOM    298  CD1 LEU A  41      11.849 -10.339 -10.126  1.00 45.10           C  
ATOM    299  CD2 LEU A  41      13.841 -10.681  -8.665  1.00 45.04           C  
ATOM    300  N   MET A  42      10.345  -8.019  -6.324  1.00 45.19           N  
ATOM    301  CA  MET A  42       9.347  -8.467  -5.337  1.00 45.75           C  
ATOM    302  C   MET A  42       8.005  -7.778  -5.558  1.00 46.32           C  
ATOM    303  O   MET A  42       6.964  -8.428  -5.593  1.00 46.38           O  
ATOM    304  CB  MET A  42       9.789  -8.183  -3.893  1.00 45.83           C  
ATOM    305  CG  MET A  42      10.936  -9.018  -3.309  1.00 45.61           C  
ATOM    306  SD  MET A  42      10.849 -10.831  -3.412  1.00 45.99           S  
ATOM    307  CE  MET A  42       9.101 -11.014  -3.050  1.00 45.15           C  
ATOM    308  N   ARG A  43       8.031  -6.455  -5.695  1.00 46.92           N  
ATOM    309  CA  ARG A  43       6.807  -5.694  -5.917  1.00 47.41           C  
ATOM    310  C   ARG A  43       6.075  -6.119  -7.193  1.00 47.89           C  
ATOM    311  O   ARG A  43       4.844  -6.105  -7.236  1.00 48.19           O  
ATOM    312  CB  ARG A  43       7.102  -4.197  -5.972  1.00 47.53           C  
ATOM    313  CG  ARG A  43       5.860  -3.333  -6.142  1.00 47.35           C  
ATOM    314  CD  ARG A  43       6.177  -1.842  -6.021  1.00 47.82           C  
ATOM    315  NE  ARG A  43       6.963  -1.322  -7.141  1.00 46.74           N  
ATOM    316  CZ  ARG A  43       8.271  -1.079  -7.117  1.00 47.18           C  
ATOM    317  NH1 ARG A  43       8.998  -1.286  -6.026  1.00 47.80           N  
ATOM    318  NH2 ARG A  43       8.865  -0.605  -8.203  1.00 47.98           N  
ATOM    319  N   ASN A  44       6.812  -6.493  -8.231  1.00 47.83           N  
ATOM    320  CA  ASN A  44       6.168  -6.906  -9.475  1.00 48.43           C  
ATOM    321  C   ASN A  44       5.885  -8.411  -9.556  1.00 48.88           C  
ATOM    322  O   ASN A  44       5.476  -8.910 -10.610  1.00 48.85           O  
ATOM    323  CB  ASN A  44       6.962  -6.398 -10.673  1.00 48.32           C  
ATOM    324  CG  ASN A  44       6.949  -4.873 -10.774  1.00 48.91           C  
ATOM    325  OD1 ASN A  44       7.949  -4.259 -11.144  1.00 51.21           O  
ATOM    326  ND2 ASN A  44       5.810  -4.260 -10.456  1.00 46.89           N  
ATOM    327  N   THR A  45       6.097  -9.116  -8.441  1.00 49.34           N  
ATOM    328  CA  THR A  45       5.674 -10.512  -8.286  1.00 49.96           C  
ATOM    329  C   THR A  45       4.543 -10.587  -7.243  1.00 50.42           C  
ATOM    330  O   THR A  45       3.361 -10.645  -7.609  1.00 50.23           O  
ATOM    331  CB  THR A  45       6.858 -11.450  -7.914  1.00 49.92           C  
ATOM    332  OG1 THR A  45       7.543 -10.951  -6.756  1.00 50.02           O  
ATOM    333  CG2 THR A  45       7.843 -11.570  -9.073  1.00 49.82           C  
ATOM    334  N   VAL A  46       4.893 -10.548  -5.955  1.00 51.03           N  
ATOM    335  CA  VAL A  46       3.870 -10.580  -4.894  1.00 51.20           C  
ATOM    336  C   VAL A  46       2.899  -9.393  -4.980  1.00 51.20           C  
ATOM    337  O   VAL A  46       1.695  -9.569  -4.771  1.00 51.20           O  
ATOM    338  CB  VAL A  46       4.473 -10.694  -3.446  1.00 51.59           C  
ATOM    339  CG1 VAL A  46       5.472  -9.589  -3.149  1.00 52.26           C  
ATOM    340  CG2 VAL A  46       3.363 -10.663  -2.385  1.00 51.87           C  
ATOM    341  N   GLY A  47       3.421  -8.209  -5.302  1.00 51.10           N  
ATOM    342  CA  GLY A  47       2.622  -6.977  -5.393  1.00 51.18           C  
ATOM    343  C   GLY A  47       1.613  -6.928  -6.535  1.00 51.14           C  
ATOM    344  O   GLY A  47       0.709  -6.086  -6.530  1.00 51.36           O  
ATOM    345  N   ARG A  48       1.743  -7.823  -7.516  1.00 51.17           N  
ATOM    346  CA  ARG A  48       0.717  -7.933  -8.560  1.00 51.17           C  
ATOM    347  C   ARG A  48      -0.459  -8.851  -8.124  1.00 50.62           C  
ATOM    348  O   ARG A  48      -1.536  -8.835  -8.722  1.00 50.05           O  
ATOM    349  CB  ARG A  48       1.332  -8.327  -9.924  1.00 51.48           C  
ATOM    350  CG  ARG A  48       1.438  -7.136 -10.922  1.00 53.73           C  
ATOM    351  CD  ARG A  48       2.853  -6.773 -11.400  1.00 56.77           C  
ATOM    352  NE  ARG A  48       3.154  -7.378 -12.710  1.00 58.25           N  
ATOM    353  CZ  ARG A  48       4.044  -6.934 -13.611  1.00 57.94           C  
ATOM    354  NH1 ARG A  48       4.798  -5.856 -13.400  1.00 58.08           N  
ATOM    355  NH2 ARG A  48       4.183  -7.591 -14.753  1.00 58.74           N  
ATOM    356  N   LYS A  49      -0.253  -9.617  -7.057  1.00 50.35           N  
ATOM    357  CA  LYS A  49      -1.275 -10.516  -6.529  1.00 50.15           C  
ATOM    358  C   LYS A  49      -2.025  -9.937  -5.327  1.00 49.83           C  
ATOM    359  O   LYS A  49      -3.144 -10.370  -5.019  1.00 50.31           O  
ATOM    360  CB  LYS A  49      -0.629 -11.827  -6.092  1.00 50.20           C  
ATOM    361  CG  LYS A  49       0.050 -12.601  -7.193  1.00 50.54           C  
ATOM    362  CD  LYS A  49       0.979 -13.658  -6.589  1.00 50.94           C  
ATOM    363  CE  LYS A  49       1.365 -14.723  -7.595  1.00 51.31           C  
ATOM    364  NZ  LYS A  49       2.416 -15.651  -7.058  1.00 51.86           N  
ATOM    365  N   VAL A  50      -1.410  -8.992  -4.623  1.00 48.95           N  
ATOM    366  CA  VAL A  50      -1.973  -8.526  -3.362  1.00 48.56           C  
ATOM    367  C   VAL A  50      -2.333  -7.038  -3.444  1.00 47.64           C  
ATOM    368  O   VAL A  50      -1.566  -6.235  -3.964  1.00 46.75           O  
ATOM    369  CB  VAL A  50      -1.012  -8.861  -2.162  1.00 48.91           C  
ATOM    370  CG1 VAL A  50       0.125  -7.859  -2.024  1.00 49.60           C  
ATOM    371  CG2 VAL A  50      -1.772  -8.930  -0.880  1.00 49.37           C  
ATOM    372  N   SER A  51      -3.520  -6.687  -2.959  1.00 46.86           N  
ATOM    373  CA  SER A  51      -3.908  -5.287  -2.811  1.00 46.66           C  
ATOM    374  C   SER A  51      -3.462  -4.759  -1.455  1.00 46.65           C  
ATOM    375  O   SER A  51      -2.954  -5.519  -0.621  1.00 46.47           O  
ATOM    376  CB  SER A  51      -5.423  -5.141  -2.958  1.00 46.17           C  
ATOM    377  OG  SER A  51      -6.104  -5.810  -1.924  1.00 44.04           O  
ATOM    378  N   LEU A  52      -3.644  -3.462  -1.223  1.00 46.50           N  
ATOM    379  CA  LEU A  52      -3.356  -2.891   0.105  1.00 47.02           C  
ATOM    380  C   LEU A  52      -4.265  -3.478   1.168  1.00 46.80           C  
ATOM    381  O   LEU A  52      -3.855  -3.684   2.308  1.00 46.69           O  
ATOM    382  CB  LEU A  52      -3.486  -1.365   0.109  1.00 47.16           C  
ATOM    383  CG  LEU A  52      -2.375  -0.632  -0.657  1.00 48.00           C  
ATOM    384  CD1 LEU A  52      -2.637   0.852  -0.644  1.00 48.77           C  
ATOM    385  CD2 LEU A  52      -1.021  -0.922  -0.046  1.00 48.69           C  
ATOM    386  N   LYS A  53      -5.505  -3.740   0.790  1.00 46.74           N  
ATOM    387  CA  LYS A  53      -6.463  -4.335   1.707  1.00 47.43           C  
ATOM    388  C   LYS A  53      -6.037  -5.764   2.082  1.00 46.99           C  
ATOM    389  O   LYS A  53      -5.998  -6.103   3.252  1.00 46.04           O  
ATOM    390  CB  LYS A  53      -7.839  -4.325   1.066  1.00 47.43           C  
ATOM    391  CG  LYS A  53      -8.954  -4.602   2.012  1.00 48.80           C  
ATOM    392  CD  LYS A  53     -10.296  -4.679   1.282  1.00 48.88           C  
ATOM    393  CE  LYS A  53     -10.665  -3.378   0.621  1.00 47.62           C  
ATOM    394  NZ  LYS A  53     -12.093  -3.397   0.225  1.00 47.90           N  
ATOM    395  N   GLN A  54      -5.708  -6.579   1.081  1.00 47.37           N  
ATOM    396  CA  GLN A  54      -5.213  -7.950   1.304  1.00 47.92           C  
ATOM    397  C   GLN A  54      -3.864  -7.944   2.034  1.00 47.82           C  
ATOM    398  O   GLN A  54      -3.670  -8.637   3.034  1.00 47.48           O  
ATOM    399  CB  GLN A  54      -5.086  -8.691  -0.030  1.00 48.12           C  
ATOM    400  CG  GLN A  54      -6.425  -9.010  -0.705  1.00 48.71           C  
ATOM    401  CD  GLN A  54      -6.315  -9.252  -2.213  1.00 48.62           C  
ATOM    402  OE1 GLN A  54      -5.415  -8.751  -2.884  1.00 49.52           O  
ATOM    403  NE2 GLN A  54      -7.259 -10.006  -2.749  1.00 50.38           N  
ATOM    404  N   GLY A  55      -2.944  -7.136   1.534  1.00 48.22           N  
ATOM    405  CA  GLY A  55      -1.628  -6.989   2.120  1.00 49.09           C  
ATOM    406  C   GLY A  55      -1.610  -6.564   3.576  1.00 49.79           C  
ATOM    407  O   GLY A  55      -0.777  -7.043   4.343  1.00 50.07           O  
ATOM    408  N   SER A  56      -2.514  -5.670   3.963  1.00 50.30           N  
ATOM    409  CA  SER A  56      -2.579  -5.193   5.344  1.00 50.96           C  
ATOM    410  C   SER A  56      -2.943  -6.313   6.326  1.00 51.46           C  
ATOM    411  O   SER A  56      -2.432  -6.371   7.455  1.00 51.45           O  
ATOM    412  CB  SER A  56      -3.584  -4.034   5.467  1.00 51.58           C  
ATOM    413  OG  SER A  56      -4.934  -4.479   5.400  1.00 52.92           O  
ATOM    414  N   LYS A  57      -3.838  -7.192   5.892  1.00 51.63           N  
ATOM    415  CA  LYS A  57      -4.228  -8.351   6.671  1.00 51.90           C  
ATOM    416  C   LYS A  57      -3.055  -9.327   6.818  1.00 51.49           C  
ATOM    417  O   LYS A  57      -2.806  -9.841   7.901  1.00 51.47           O  
ATOM    418  CB  LYS A  57      -5.441  -9.027   6.028  1.00 52.42           C  
ATOM    419  CG  LYS A  57      -6.615  -8.063   5.900  1.00 53.97           C  
ATOM    420  CD  LYS A  57      -7.906  -8.691   5.379  1.00 54.45           C  
ATOM    421  CE  LYS A  57      -8.934  -7.584   5.052  1.00 56.36           C  
ATOM    422  NZ  LYS A  57     -10.234  -8.114   4.515  1.00 57.99           N  
ATOM    423  N   LEU A  58      -2.317  -9.544   5.734  1.00 51.18           N  
ATOM    424  CA  LEU A  58      -1.124 -10.386   5.777  1.00 51.17           C  
ATOM    425  C   LEU A  58      -0.001  -9.765   6.614  1.00 50.98           C  
ATOM    426  O   LEU A  58       0.661 -10.469   7.373  1.00 51.30           O  
ATOM    427  CB  LEU A  58      -0.615 -10.687   4.364  1.00 50.83           C  
ATOM    428  CG  LEU A  58      -1.594 -11.392   3.422  1.00 51.13           C  
ATOM    429  CD1 LEU A  58      -0.995 -11.488   2.031  1.00 50.80           C  
ATOM    430  CD2 LEU A  58      -1.979 -12.762   3.943  1.00 51.95           C  
ATOM    431  N   ALA A  59       0.212  -8.459   6.490  1.00 50.77           N  
ATOM    432  CA  ALA A  59       1.299  -7.791   7.221  1.00 50.80           C  
ATOM    433  C   ALA A  59       0.949  -7.483   8.676  1.00 50.76           C  
ATOM    434  O   ALA A  59       1.819  -7.083   9.454  1.00 50.95           O  
ATOM    435  CB  ALA A  59       1.723  -6.520   6.516  1.00 51.01           C  
ATOM    436  N   GLY A  60      -0.318  -7.667   9.040  1.00 50.41           N  
ATOM    437  CA  GLY A  60      -0.797  -7.320  10.369  1.00 50.21           C  
ATOM    438  C   GLY A  60      -0.782  -5.829  10.658  1.00 50.00           C  
ATOM    439  O   GLY A  60      -0.602  -5.439  11.812  1.00 50.08           O  
ATOM    440  N   THR A  61      -0.950  -5.008   9.614  1.00 49.60           N  
ATOM    441  CA  THR A  61      -1.135  -3.563   9.761  1.00 49.35           C  
ATOM    442  C   THR A  61      -2.636  -3.241   9.670  1.00 48.84           C  
ATOM    443  O   THR A  61      -3.268  -3.530   8.649  1.00 48.79           O  
ATOM    444  CB  THR A  61      -0.399  -2.751   8.656  1.00 49.28           C  
ATOM    445  OG1 THR A  61       0.978  -3.138   8.595  1.00 50.36           O  
ATOM    446  CG2 THR A  61      -0.483  -1.247   8.943  1.00 49.58           C  
ATOM    447  N   PRO A  62      -3.213  -2.646  10.726  1.00 48.34           N  
ATOM    448  CA  PRO A  62      -4.633  -2.280  10.663  1.00 48.08           C  
ATOM    449  C   PRO A  62      -4.919  -1.304   9.527  1.00 47.22           C  
ATOM    450  O   PRO A  62      -4.129  -0.397   9.283  1.00 45.96           O  
ATOM    451  CB  PRO A  62      -4.899  -1.621  12.023  1.00 47.96           C  
ATOM    452  CG  PRO A  62      -3.801  -2.057  12.893  1.00 48.48           C  
ATOM    453  CD  PRO A  62      -2.609  -2.270  12.012  1.00 48.49           C  
ATOM    454  N   MET A  63      -6.026  -1.507   8.822  1.00 47.68           N  
ATOM    455  CA  MET A  63      -6.381  -0.617   7.715  1.00 47.96           C  
ATOM    456  C   MET A  63      -6.493   0.835   8.160  1.00 47.76           C  
ATOM    457  O   MET A  63      -6.074   1.724   7.437  1.00 47.95           O  
ATOM    458  CB  MET A  63      -7.689  -1.051   7.029  1.00 48.34           C  
ATOM    459  CG  MET A  63      -8.016  -0.263   5.721  1.00 49.78           C  
ATOM    460  SD  MET A  63      -6.619  -0.007   4.542  1.00 54.17           S  
ATOM    461  CE  MET A  63      -5.842  -1.589   4.640  1.00 51.09           C  
ATOM    462  N   ASP A  64      -7.052   1.081   9.338  1.00 47.24           N  
ATOM    463  CA  ASP A  64      -7.148   2.457   9.838  1.00 47.29           C  
ATOM    464  C   ASP A  64      -5.783   3.158   9.886  1.00 46.20           C  
ATOM    465  O   ASP A  64      -5.684   4.336   9.591  1.00 45.56           O  
ATOM    466  CB  ASP A  64      -7.820   2.497  11.215  1.00 48.04           C  
ATOM    467  CG  ASP A  64      -9.271   1.989  11.182  1.00 52.49           C  
ATOM    468  OD1 ASP A  64      -9.894   1.826  12.268  1.00 57.48           O  
ATOM    469  OD2 ASP A  64      -9.790   1.743  10.065  1.00 58.64           O  
ATOM    470  N   LYS A  65      -4.738   2.427  10.255  1.00 45.27           N  
ATOM    471  CA  LYS A  65      -3.380   2.962  10.303  1.00 44.99           C  
ATOM    472  C   LYS A  65      -2.922   3.363   8.894  1.00 44.35           C  
ATOM    473  O   LYS A  65      -2.351   4.429   8.709  1.00 43.61           O  
ATOM    474  CB  LYS A  65      -2.440   1.915  10.925  1.00 45.56           C  
ATOM    475  CG  LYS A  65      -0.939   2.182  10.810  1.00 46.29           C  
ATOM    476  CD  LYS A  65      -0.384   2.907  12.015  1.00 47.36           C  
ATOM    477  CE  LYS A  65       1.131   3.021  11.937  1.00 47.29           C  
ATOM    478  NZ  LYS A  65       1.597   4.159  12.778  1.00 48.10           N  
ATOM    479  N   ILE A  66      -3.198   2.509   7.911  1.00 43.70           N  
ATOM    480  CA  ILE A  66      -2.862   2.784   6.524  1.00 43.91           C  
ATOM    481  C   ILE A  66      -3.623   3.967   5.973  1.00 43.15           C  
ATOM    482  O   ILE A  66      -3.028   4.818   5.325  1.00 42.64           O  
ATOM    483  CB  ILE A  66      -3.110   1.543   5.625  1.00 44.59           C  
ATOM    484  CG1 ILE A  66      -2.067   0.468   5.952  1.00 44.22           C  
ATOM    485  CG2 ILE A  66      -3.061   1.928   4.129  1.00 44.09           C  
ATOM    486  CD1 ILE A  66      -2.480  -0.914   5.620  1.00 44.78           C  
ATOM    487  N   VAL A  67      -4.932   4.025   6.236  1.00 42.41           N  
ATOM    488  CA  VAL A  67      -5.758   5.130   5.754  1.00 42.01           C  
ATOM    489  C   VAL A  67      -5.318   6.463   6.369  1.00 41.10           C  
ATOM    490  O   VAL A  67      -5.129   7.435   5.653  1.00 40.54           O  
ATOM    491  CB  VAL A  67      -7.264   4.867   5.961  1.00 42.16           C  
ATOM    492  CG1 VAL A  67      -8.098   6.090   5.560  1.00 42.60           C  
ATOM    493  CG2 VAL A  67      -7.693   3.662   5.124  1.00 42.69           C  
ATOM    494  N   ARG A  68      -5.098   6.484   7.677  1.00 40.42           N  
ATOM    495  CA  ARG A  68      -4.619   7.696   8.373  1.00 40.07           C  
ATOM    496  C   ARG A  68      -3.297   8.195   7.793  1.00 39.90           C  
ATOM    497  O   ARG A  68      -3.109   9.381   7.550  1.00 39.61           O  
ATOM    498  CB  ARG A  68      -4.359   7.402   9.845  1.00 39.27           C  
ATOM    499  CG  ARG A  68      -5.570   7.321  10.716  1.00 39.90           C  
ATOM    500  CD  ARG A  68      -5.152   7.017  12.167  1.00 37.83           C  
ATOM    501  NE  ARG A  68      -5.809   8.023  12.951  1.00 42.24           N  
ATOM    502  CZ  ARG A  68      -5.240   8.939  13.708  1.00 38.90           C  
ATOM    503  NH1 ARG A  68      -3.946   8.977  13.970  1.00 38.37           N  
ATOM    504  NH2 ARG A  68      -6.034   9.785  14.281  1.00 42.52           N  
ATOM    505  N   THR A  69      -2.373   7.264   7.622  1.00 39.76           N  
ATOM    506  CA  THR A  69      -1.035   7.590   7.120  1.00 40.22           C  
ATOM    507  C   THR A  69      -1.104   8.157   5.704  1.00 39.85           C  
ATOM    508  O   THR A  69      -0.487   9.183   5.403  1.00 39.83           O  
ATOM    509  CB  THR A  69      -0.119   6.354   7.155  1.00 39.77           C  
ATOM    510  OG1 THR A  69      -0.107   5.808   8.478  1.00 39.95           O  
ATOM    511  CG2 THR A  69       1.304   6.726   6.756  1.00 40.11           C  
ATOM    512  N   LEU A  70      -1.882   7.506   4.849  1.00 39.78           N  
ATOM    513  CA  LEU A  70      -2.041   7.975   3.488  1.00 40.44           C  
ATOM    514  C   LEU A  70      -2.685   9.349   3.427  1.00 40.40           C  
ATOM    515  O   LEU A  70      -2.194  10.225   2.718  1.00 40.39           O  
ATOM    516  CB  LEU A  70      -2.818   6.954   2.646  1.00 40.62           C  
ATOM    517  CG  LEU A  70      -2.068   5.659   2.296  1.00 41.62           C  
ATOM    518  CD1 LEU A  70      -3.024   4.656   1.619  1.00 42.31           C  
ATOM    519  CD2 LEU A  70      -0.858   5.935   1.407  1.00 41.10           C  
ATOM    520  N   GLU A  71      -3.769   9.556   4.180  1.00 41.26           N  
ATOM    521  CA  GLU A  71      -4.391  10.883   4.264  1.00 41.42           C  
ATOM    522  C   GLU A  71      -3.430  11.950   4.797  1.00 40.82           C  
ATOM    523  O   GLU A  71      -3.383  13.035   4.261  1.00 40.62           O  
ATOM    524  CB  GLU A  71      -5.665  10.835   5.092  1.00 41.74           C  
ATOM    525  CG  GLU A  71      -6.754   9.986   4.454  1.00 43.58           C  
ATOM    526  CD  GLU A  71      -8.071  10.038   5.211  1.00 44.61           C  
ATOM    527  OE1 GLU A  71      -8.076  10.207   6.452  1.00 48.78           O  
ATOM    528  OE2 GLU A  71      -9.121   9.889   4.555  1.00 50.65           O  
ATOM    529  N   ALA A  72      -2.652  11.624   5.825  1.00 40.97           N  
ATOM    530  CA  ALA A  72      -1.644  12.544   6.383  1.00 41.43           C  
ATOM    531  C   ALA A  72      -0.532  12.931   5.404  1.00 41.56           C  
ATOM    532  O   ALA A  72       0.152  13.907   5.623  1.00 41.77           O  
ATOM    533  CB  ALA A  72      -1.008  11.936   7.622  1.00 41.28           C  
ATOM    534  N   ASN A  73      -0.319  12.137   4.362  1.00 42.08           N  
ATOM    535  CA  ASN A  73       0.692  12.434   3.357  1.00 42.51           C  
ATOM    536  C   ASN A  73       0.090  12.943   2.034  1.00 42.93           C  
ATOM    537  O   ASN A  73       0.767  12.993   1.011  1.00 43.59           O  
ATOM    538  CB  ASN A  73       1.566  11.204   3.141  1.00 42.20           C  
ATOM    539  CG  ASN A  73       2.509  10.947   4.306  1.00 42.32           C  
ATOM    540  OD1 ASN A  73       3.567  11.583   4.418  1.00 41.88           O  
ATOM    541  ND2 ASN A  73       2.133  10.011   5.187  1.00 40.49           N  
ATOM    542  N   GLY A  74      -1.182  13.315   2.055  1.00 43.37           N  
ATOM    543  CA  GLY A  74      -1.801  14.017   0.929  1.00 43.96           C  
ATOM    544  C   GLY A  74      -2.730  13.209   0.034  1.00 44.50           C  
ATOM    545  O   GLY A  74      -3.260  13.737  -0.952  1.00 45.15           O  
ATOM    546  N   TYR A  75      -2.962  11.950   0.371  1.00 44.33           N  
ATOM    547  CA  TYR A  75      -3.750  11.081  -0.487  1.00 44.56           C  
ATOM    548  C   TYR A  75      -5.201  10.993  -0.045  1.00 44.66           C  
ATOM    549  O   TYR A  75      -5.515  11.129   1.124  1.00 45.04           O  
ATOM    550  CB  TYR A  75      -3.120   9.694  -0.561  1.00 44.57           C  
ATOM    551  CG  TYR A  75      -1.729   9.716  -1.149  1.00 44.78           C  
ATOM    552  CD1 TYR A  75      -1.538   9.639  -2.528  1.00 44.49           C  
ATOM    553  CD2 TYR A  75      -0.612   9.825  -0.336  1.00 44.73           C  
ATOM    554  CE1 TYR A  75      -0.268   9.668  -3.075  1.00 45.58           C  
ATOM    555  CE2 TYR A  75       0.659   9.868  -0.869  1.00 45.76           C  
ATOM    556  CZ  TYR A  75       0.830   9.789  -2.241  1.00 45.32           C  
ATOM    557  OH  TYR A  75       2.090   9.807  -2.779  1.00 46.10           O  
ATOM    558  N   GLU A  76      -6.071  10.761  -1.017  1.00 45.17           N  
ATOM    559  CA  GLU A  76      -7.449  10.408  -0.790  1.00 45.72           C  
ATOM    560  C   GLU A  76      -7.625   8.930  -1.068  1.00 45.40           C  
ATOM    561  O   GLU A  76      -7.243   8.454  -2.122  1.00 44.67           O  
ATOM    562  CB  GLU A  76      -8.337  11.223  -1.729  1.00 47.00           C  
ATOM    563  CG  GLU A  76      -9.693  11.521  -1.157  1.00 51.28           C  
ATOM    564  CD  GLU A  76      -9.613  12.475   0.038  1.00 54.90           C  
ATOM    565  OE1 GLU A  76      -9.062  13.595  -0.116  1.00 57.87           O  
ATOM    566  OE2 GLU A  76     -10.085  12.081   1.120  1.00 56.92           O  
ATOM    567  N   VAL A  77      -8.237   8.208  -0.127  1.00 45.22           N  
ATOM    568  CA  VAL A  77      -8.319   6.773  -0.206  1.00 45.00           C  
ATOM    569  C   VAL A  77      -9.696   6.308  -0.666  1.00 44.77           C  
ATOM    570  O   VAL A  77     -10.701   6.795  -0.191  1.00 44.43           O  
ATOM    571  CB  VAL A  77      -7.985   6.162   1.147  1.00 45.41           C  
ATOM    572  CG1 VAL A  77      -8.091   4.647   1.088  1.00 46.06           C  
ATOM    573  CG2 VAL A  77      -6.581   6.598   1.578  1.00 46.27           C  
ATOM    574  N   ILE A  78      -9.734   5.348  -1.585  1.00 44.46           N  
ATOM    575  CA  ILE A  78     -10.996   4.764  -2.032  1.00 44.57           C  
ATOM    576  C   ILE A  78     -10.884   3.251  -1.997  1.00 44.52           C  
ATOM    577  O   ILE A  78      -9.815   2.725  -1.733  1.00 44.18           O  
ATOM    578  CB  ILE A  78     -11.412   5.269  -3.450  1.00 44.08           C  
ATOM    579  CG1 ILE A  78     -10.425   4.816  -4.534  1.00 43.61           C  
ATOM    580  CG2 ILE A  78     -11.530   6.803  -3.460  1.00 43.56           C  
ATOM    581  CD1 ILE A  78     -10.890   5.158  -5.940  1.00 43.66           C  
ATOM    582  N   GLY A  79     -11.992   2.565  -2.253  1.00 45.06           N  
ATOM    583  CA  GLY A  79     -12.017   1.111  -2.322  1.00 46.36           C  
ATOM    584  C   GLY A  79     -12.058   0.378  -0.988  1.00 46.82           C  
ATOM    585  O   GLY A  79     -11.802  -0.825  -0.939  1.00 46.69           O  
ATOM    586  N   LEU A  80     -12.352   1.106   0.084  1.00 48.11           N  
ATOM    587  CA  LEU A  80     -12.549   0.538   1.427  1.00 49.70           C  
ATOM    588  C   LEU A  80     -13.783  -0.357   1.503  1.00 50.63           C  
ATOM    589  O   LEU A  80     -14.709  -0.193   0.711  1.00 50.64           O  
ATOM    590  CB  LEU A  80     -12.740   1.684   2.435  1.00 50.18           C  
ATOM    591  CG  LEU A  80     -11.588   2.312   3.242  1.00 51.19           C  
ATOM    592  CD1 LEU A  80     -10.266   1.673   3.017  1.00 52.49           C  
ATOM    593  CD2 LEU A  80     -11.492   3.796   3.000  1.00 51.13           C  
ATOM    594  N   ASP A  81     -13.814  -1.280   2.473  1.00 51.91           N  
ATOM    595  CA  ASP A  81     -15.032  -2.069   2.761  1.00 52.58           C  
ATOM    596  C   ASP A  81     -16.124  -1.181   3.380  1.00 53.48           C  
ATOM    597  O   ASP A  81     -15.847  -0.067   3.853  1.00 54.36           O  
ATOM    598  CB  ASP A  81     -14.750  -3.236   3.731  1.00 53.31           C  
ATOM    599  CG  ASP A  81     -13.917  -4.350   3.106  1.00 54.95           C  
ATOM    600  OD1 ASP A  81     -13.717  -4.352   1.871  1.00 58.15           O  
ATOM    601  OD2 ASP A  81     -13.452  -5.241   3.857  1.00 58.76           O  
TER     602      ASP A  81                                                      
END
MOLECULE T0469.pdb
ATOM     34  N   GLN     3     -11.627   8.047  -2.168  1.00 30.01           N 
ATOM     35  CA  GLN     3     -10.194   8.122  -1.859  1.00 44.33           C 
ATOM     36  C   GLN     3      -9.345   7.641  -3.041  1.00  1.05           C 
ATOM     37  O   GLN     3      -9.602   6.580  -3.610  1.00 22.43           O 
ATOM     38  CB  GLN     3      -9.859   7.292  -0.611  1.00 15.35           C 
ATOM     39  CG  GLN     3     -10.597   7.739   0.646  1.00 20.34           C 
ATOM     40  CD  GLN     3     -10.090   7.063   1.912  1.00 71.03           C 
ATOM     41  OE1 GLN     3     -10.146   7.632   2.994  1.00 40.53           O 
ATOM     42  NE2 GLN     3      -9.579   5.849   1.794  1.00 34.32           N 
ATOM     43  H   GLN     3     -12.030   7.173  -2.365  1.00 38.87           H 
ATOM     44  HA  GLN     3      -9.952   9.158  -1.661  1.00  1.11           H 
ATOM     45 3HB  GLN     3      -8.796   7.360  -0.423  1.00 38.87           H 
ATOM     46 2HB  GLN     3     -10.114   6.259  -0.802  1.00 38.87           H 
ATOM     47 3HG  GLN     3     -11.648   7.509   0.531  1.00 38.87           H 
ATOM     48 2HG  GLN     3     -10.477   8.807   0.757  1.00 38.87           H 
ATOM     49 1HE2 GLN     3      -9.546   5.443   0.906  1.00 38.87           H 
ATOM     50 2HE2 GLN     3      -9.262   5.406   2.608  1.00 38.87           H 
ATOM     51  N   LYS     4      -8.332   8.429  -3.406  1.00 22.44           N 
ATOM     52  CA  LYS     4      -7.409   8.050  -4.485  1.00 75.21           C 
ATOM     53  C   LYS     4      -6.629   6.774  -4.137  1.00 11.23           C 
ATOM     54  O   LYS     4      -6.107   6.090  -5.023  1.00 54.32           O 
ATOM     55  CB  LYS     4      -6.437   9.199  -4.787  1.00 13.44           C 
ATOM     56  CG  LYS     4      -7.117  10.443  -5.351  1.00 21.02           C 
ATOM     57  CD  LYS     4      -6.106  11.504  -5.782  1.00 42.12           C 
ATOM     58  CE  LYS     4      -5.137  10.973  -6.836  1.00 71.40           C 
ATOM     59  NZ  LYS     4      -5.843  10.455  -8.039  1.00 62.12           N 
ATOM     60  H   LYS     4      -8.205   9.286  -2.948  1.00 38.87           H 
ATOM     61  HA  LYS     4      -8.002   7.858  -5.369  1.00 34.11           H 
ATOM     62 3HB  LYS     4      -5.705   8.856  -5.506  1.00 38.87           H 
ATOM     63 2HB  LYS     4      -5.928   9.474  -3.874  1.00 38.87           H 
ATOM     64 3HG  LYS     4      -7.762  10.863  -4.589  1.00 38.87           H 
ATOM     65 2HG  LYS     4      -7.712  10.160  -6.207  1.00 38.87           H 
ATOM     66 3HD  LYS     4      -5.543  11.825  -4.915  1.00 38.87           H 
ATOM     67 2HD  LYS     4      -6.640  12.347  -6.195  1.00 38.87           H 
ATOM     68 3HE  LYS     4      -4.552  10.173  -6.401  1.00 38.87           H 
ATOM     69 2HE  LYS     4      -4.480  11.772  -7.139  1.00 38.87           H 
ATOM     70 1HZ  LYS     4      -6.407   9.616  -7.794  1.00 38.87           H 
ATOM     71 2HZ  LYS     4      -5.154  10.192  -8.772  1.00 38.87           H 
ATOM     72 3HZ  LYS     4      -6.476  11.184  -8.427  1.00 38.87           H 
ATOM     73  N   PHE     5      -6.530   6.483  -2.839  1.00 50.12           N 
ATOM     74  CA  PHE     5      -5.961   5.220  -2.356  1.00 63.21           C 
ATOM     75  C   PHE     5      -7.007   4.431  -1.553  1.00  2.41           C 
ATOM     76  O   PHE     5      -7.454   4.866  -0.486  1.00  4.53           O 
ATOM     77  CB  PHE     5      -4.720   5.485  -1.493  1.00 42.04           C 
ATOM     78  CG  PHE     5      -3.603   6.170  -2.243  1.00 45.35           C 
ATOM     79  CD1 PHE     5      -3.462   7.551  -2.205  1.00  2.03           C 
ATOM     80  CD2 PHE     5      -2.699   5.431  -2.992  1.00 13.44           C 
ATOM     81  CE1 PHE     5      -2.444   8.178  -2.899  1.00 20.41           C 
ATOM     82  CE2 PHE     5      -1.680   6.054  -3.687  1.00 24.04           C 
ATOM     83  CZ  PHE     5      -1.551   7.427  -3.638  1.00 15.13           C 
ATOM     84  H   PHE     5      -6.837   7.141  -2.183  1.00 38.87           H 
ATOM     85  HA  PHE     5      -5.671   4.634  -3.217  1.00 20.31           H 
ATOM     86 3HB  PHE     5      -4.342   4.545  -1.116  1.00 38.87           H 
ATOM     87 2HB  PHE     5      -4.998   6.115  -0.658  1.00 38.87           H 
ATOM     88  HD1 PHE     5      -4.158   8.140  -1.624  1.00 55.23           H 
ATOM     89  HD2 PHE     5      -2.795   4.354  -3.031  1.00 60.12           H 
ATOM     90  HE1 PHE     5      -2.346   9.253  -2.861  1.00 54.03           H 
ATOM     91  HE2 PHE     5      -0.982   5.466  -4.265  1.00 44.45           H 
ATOM     92  HZ  PHE     5      -0.755   7.915  -4.182  1.00 41.14           H 
ATOM     93  N   THR     6      -7.403   3.276  -2.079  1.00 42.34           N 
ATOM     94  CA  THR     6      -8.414   2.428  -1.430  1.00 54.13           C 
ATOM     95  C   THR     6      -7.872   1.028  -1.124  1.00 21.43           C 
ATOM     96  O   THR     6      -6.877   0.596  -1.693  1.00 52.30           O 
ATOM     97  CB  THR     6      -9.687   2.286  -2.300  1.00 24.45           C 
ATOM     98  OG1 THR     6     -10.596   1.350  -1.693  1.00 74.03           O 
ATOM     99  CG2 THR     6      -9.342   1.821  -3.711  1.00 72.10           C 
ATOM    100  H   THR     6      -7.004   2.980  -2.926  1.00 38.87           H 
ATOM    101  HA  THR     6      -8.697   2.899  -0.497  1.00 22.22           H 
ATOM    102  HB  THR     6     -10.170   3.251  -2.364  1.00 75.32           H 
ATOM    103  HG1 THR     6     -11.497   1.538  -1.990  1.00  5.54           H 
ATOM    104 1HG2 THR     6      -8.875   0.849  -3.667  1.00 38.87           H 
ATOM    105 2HG2 THR     6      -8.661   2.526  -4.168  1.00 38.87           H 
ATOM    106 3HG2 THR     6     -10.244   1.760  -4.304  1.00 38.87           H 
ATOM    107  N   LYS     7      -8.550   0.316  -0.232  1.00 40.34           N 
ATOM    108  CA  LYS     7      -8.153  -1.048   0.138  1.00 44.32           C 
ATOM    109  C   LYS     7      -8.366  -2.029  -1.025  1.00 74.01           C 
ATOM    110  O   LYS     7      -7.759  -3.102  -1.067  1.00 64.01           O 
ATOM    111  CB  LYS     7      -8.956  -1.507   1.361  1.00 34.42           C 
ATOM    112  CG  LYS     7     -10.470  -1.494   1.154  1.00 41.34           C 
ATOM    113  CD  LYS     7     -11.213  -1.943   2.409  1.00  3.35           C 
ATOM    114  CE  LYS     7     -10.922  -1.033   3.598  1.00 25.21           C 
ATOM    115  NZ  LYS     7     -11.454  -1.588   4.872  1.00 70.34           N 
ATOM    116  H   LYS     7      -9.347   0.711   0.182  1.00 38.87           H 
ATOM    117  HA  LYS     7      -7.103  -1.031   0.393  1.00  2.20           H 
ATOM    118 3HB  LYS     7      -8.724  -0.856   2.192  1.00 38.87           H 
ATOM    119 2HB  LYS     7      -8.658  -2.515   1.615  1.00 38.87           H 
ATOM    120 3HG  LYS     7     -10.718  -2.164   0.342  1.00 38.87           H 
ATOM    121 2HG  LYS     7     -10.782  -0.491   0.900  1.00 38.87           H 
ATOM    122 3HD  LYS     7     -10.907  -2.951   2.655  1.00 38.87           H 
ATOM    123 2HD  LYS     7     -12.276  -1.930   2.211  1.00 38.87           H 
ATOM    124 3HE  LYS     7     -11.374  -0.068   3.420  1.00 38.87           H 
ATOM    125 2HE  LYS     7      -9.853  -0.916   3.694  1.00 38.87           H 
ATOM    126 1HZ  LYS     7     -12.485  -1.697   4.812  1.00 38.87           H 
ATOM    127 2HZ  LYS     7     -11.229  -0.946   5.660  1.00 38.87           H 
ATOM    128 3HZ  LYS     7     -11.028  -2.517   5.062  1.00 38.87           H 
ATOM    129  N   ASP     8      -9.229  -1.640  -1.962  1.00 23.15           N 
ATOM    130  CA  ASP     8      -9.599  -2.495  -3.095  1.00 40.32           C 
ATOM    131  C   ASP     8      -8.509  -2.519  -4.188  1.00 21.33           C 
ATOM    132  O   ASP     8      -8.319  -3.531  -4.864  1.00 43.43           O 
ATOM    133  CB  ASP     8     -10.930  -2.001  -3.681  1.00 25.40           C 
ATOM    134  CG  ASP     8     -11.526  -2.968  -4.688  1.00 12.34           C 
ATOM    135  OD1 ASP     8     -12.169  -3.949  -4.264  1.00 72.21           O 
ATOM    136  OD2 ASP     8     -11.372  -2.746  -5.906  1.00 45.15           O 
ATOM    137  H   ASP     8      -9.637  -0.751  -1.888  1.00 38.87           H 
ATOM    138  HA  ASP     8      -9.737  -3.500  -2.719  1.00  4.03           H 
ATOM    139 3HB  ASP     8     -10.768  -1.050  -4.170  1.00 38.87           H 
ATOM    140 2HB  ASP     8     -11.639  -1.867  -2.878  1.00 38.87           H 
ATOM    141  N   MET     9      -7.786  -1.406  -4.347  1.00 22.22           N 
ATOM    142  CA  MET     9      -6.770  -1.285  -5.407  1.00 21.14           C 
ATOM    143  C   MET     9      -5.493  -2.072  -5.060  1.00 74.21           C 
ATOM    144  O   MET     9      -5.230  -2.370  -3.894  1.00 20.44           O 
ATOM    145  CB  MET     9      -6.430   0.193  -5.658  1.00 15.42           C 
ATOM    146  CG  MET     9      -5.739   0.873  -4.485  1.00 52.44           C 
ATOM    147  SD  MET     9      -5.650   2.667  -4.666  1.00 14.13           S 
ATOM    148  CE  MET     9      -4.684   2.823  -6.167  1.00 12.05           C 
ATOM    149  H   MET     9      -7.929  -0.658  -3.733  1.00 38.87           H 
ATOM    150  HA  MET     9      -7.192  -1.701  -6.312  1.00 53.05           H 
ATOM    151 3HB  MET     9      -7.343   0.732  -5.871  1.00 38.87           H 
ATOM    152 2HB  MET     9      -5.778   0.261  -6.519  1.00 38.87           H 
ATOM    153 3HG  MET     9      -4.734   0.483  -4.400  1.00 38.87           H 
ATOM    154 2HG  MET     9      -6.286   0.645  -3.585  1.00 38.87           H 
ATOM    155 1HE  MET     9      -4.579   3.868  -6.416  1.00 38.87           H 
ATOM    156 2HE  MET     9      -5.185   2.308  -6.974  1.00 38.87           H 
ATOM    157 3HE  MET     9      -3.707   2.389  -6.013  1.00 38.87           H 
ATOM    158  N   THR    10      -4.699  -2.398  -6.079  1.00 41.40           N 
ATOM    159  CA  THR    10      -3.476  -3.198  -5.894  1.00 42.12           C 
ATOM    160  C   THR    10      -2.262  -2.333  -5.524  1.00 34.11           C 
ATOM    161  O   THR    10      -2.241  -1.123  -5.777  1.00 60.51           O 
ATOM    162  CB  THR    10      -3.126  -3.993  -7.171  1.00  4.44           C 
ATOM    163  OG1 THR    10      -2.801  -3.085  -8.235  1.00 24.12           O 
ATOM    164  CG2 THR    10      -4.283  -4.893  -7.600  1.00 42.43           C 
ATOM    165  H   THR    10      -4.938  -2.101  -6.981  1.00 38.87           H 
ATOM    166  HA  THR    10      -3.656  -3.905  -5.095  1.00 52.02           H 
ATOM    167  HB  THR    10      -2.263  -4.615  -6.966  1.00 32.44           H 
ATOM    168  HG1 THR    10      -2.704  -3.581  -9.059  1.00 21.12           H 
ATOM    169 1HG2 THR    10      -5.146  -4.286  -7.834  1.00 38.87           H 
ATOM    170 2HG2 THR    10      -4.530  -5.573  -6.797  1.00 38.87           H 
ATOM    171 3HG2 THR    10      -3.995  -5.460  -8.474  1.00 38.87           H 
ATOM    172  N   PHE    11      -1.244  -2.964  -4.935  1.00 75.24           N 
ATOM    173  CA  PHE    11       0.007  -2.274  -4.599  1.00  0.34           C 
ATOM    174  C   PHE    11       0.663  -1.656  -5.845  1.00 12.02           C 
ATOM    175  O   PHE    11       1.131  -0.516  -5.810  1.00 75.13           O 
ATOM    176  CB  PHE    11       0.990  -3.241  -3.921  1.00 53.52           C 
ATOM    177  CG  PHE    11       0.574  -3.675  -2.535  1.00  4.04           C 
ATOM    178  CD1 PHE    11       0.923  -2.917  -1.426  1.00 20.14           C 
ATOM    179  CD2 PHE    11      -0.156  -4.837  -2.340  1.00 72.14           C 
ATOM    180  CE1 PHE    11       0.553  -3.310  -0.154  1.00 60.41           C 
ATOM    181  CE2 PHE    11      -0.529  -5.235  -1.070  1.00 23.33           C 
ATOM    182  CZ  PHE    11      -0.174  -4.469   0.024  1.00 62.13           C 
ATOM    183  H   PHE    11      -1.338  -3.919  -4.714  1.00 38.87           H 
ATOM    184  HA  PHE    11      -0.235  -1.479  -3.905  1.00 35.22           H 
ATOM    185 3HB  PHE    11       1.957  -2.763  -3.843  1.00 38.87           H 
ATOM    186 2HB  PHE    11       1.085  -4.128  -4.529  1.00 38.87           H 
ATOM    187  HD1 PHE    11       1.490  -2.008  -1.562  1.00 20.15           H 
ATOM    188  HD2 PHE    11      -0.434  -5.437  -3.193  1.00 24.11           H 
ATOM    189  HE1 PHE    11       0.832  -2.711   0.701  1.00 60.41           H 
ATOM    190  HE2 PHE    11      -1.098  -6.142  -0.933  1.00  2.33           H 
ATOM    191  HZ  PHE    11      -0.465  -4.779   1.019  1.00 40.11           H 
ATOM    192  N   ALA    12       0.680  -2.410  -6.947  1.00 70.34           N 
ATOM    193  CA  ALA    12       1.281  -1.939  -8.205  1.00 33.55           C 
ATOM    194  C   ALA    12       0.640  -0.629  -8.686  1.00 13.22           C 
ATOM    195  O   ALA    12       1.330   0.279  -9.156  1.00 52.42           O 
ATOM    196  CB  ALA    12       1.163  -3.010  -9.286  1.00 54.15           C 
ATOM    197  H   ALA    12       0.275  -3.304  -6.919  1.00 38.87           H 
ATOM    198  HA  ALA    12       2.335  -1.765  -8.022  1.00 64.43           H 
ATOM    199 1HB  ALA    12       1.660  -2.672 -10.185  1.00 38.87           H 
ATOM    200 2HB  ALA    12       0.120  -3.193  -9.500  1.00 38.87           H 
ATOM    201 3HB  ALA    12       1.625  -3.924  -8.943  1.00 38.87           H 
ATOM    202  N   GLN    13      -0.683  -0.532  -8.568  1.00 73.00           N 
ATOM    203  CA  GLN    13      -1.398   0.686  -8.958  1.00 55.15           C 
ATOM    204  C   GLN    13      -1.078   1.850  -8.005  1.00 63.15           C 
ATOM    205  O   GLN    13      -0.847   2.976  -8.447  1.00  3.14           O 
ATOM    206  CB  GLN    13      -2.910   0.428  -9.010  1.00  4.02           C 
ATOM    207  CG  GLN    13      -3.316  -0.584 -10.078  1.00 34.02           C 
ATOM    208  CD  GLN    13      -4.820  -0.787 -10.183  1.00 70.24           C 
ATOM    209  OE1 GLN    13      -5.295  -1.868 -10.517  1.00 23.12           O 
ATOM    210  NE2 GLN    13      -5.584   0.254  -9.915  1.00 41.33           N 
ATOM    211  H   GLN    13      -1.191  -1.297  -8.216  1.00 38.87           H 
ATOM    212  HA  GLN    13      -1.059   0.957  -9.951  1.00 11.24           H 
ATOM    213 3HB  GLN    13      -3.419   1.360  -9.214  1.00 38.87           H 
ATOM    214 2HB  GLN    13      -3.234   0.056  -8.047  1.00 38.87           H 
ATOM    215 3HG  GLN    13      -2.857  -1.535  -9.842  1.00 38.87           H 
ATOM    216 2HG  GLN    13      -2.951  -0.242 -11.035  1.00 38.87           H 
ATOM    217 1HE2 GLN    13      -5.153   1.095  -9.665  1.00 38.87           H 
ATOM    218 2HE2 GLN    13      -6.553   0.137  -9.979  1.00 38.87           H 
ATOM    219  N   ALA    14      -1.047   1.571  -6.700  1.00  1.31           N 
ATOM    220  CA  ALA    14      -0.723   2.593  -5.694  1.00  5.31           C 
ATOM    221  C   ALA    14       0.665   3.211  -5.941  1.00  2.11           C 
ATOM    222  O   ALA    14       0.819   4.437  -5.971  1.00  2.23           O 
ATOM    223  CB  ALA    14      -0.802   2.000  -4.293  1.00 72.04           C 
ATOM    224  H   ALA    14      -1.251   0.656  -6.402  1.00 38.87           H 
ATOM    225  HA  ALA    14      -1.467   3.374  -5.768  1.00 23.12           H 
ATOM    226 1HB  ALA    14      -0.639   2.778  -3.561  1.00 38.87           H 
ATOM    227 2HB  ALA    14      -0.045   1.237  -4.179  1.00 38.87           H 
ATOM    228 3HB  ALA    14      -1.778   1.562  -4.142  1.00 38.87           H 
ATOM    229  N   LEU    15       1.666   2.352  -6.140  1.00 53.00           N 
ATOM    230  CA  LEU    15       3.043   2.799  -6.408  1.00 61.24           C 
ATOM    231  C   LEU    15       3.117   3.723  -7.636  1.00 71.12           C 
ATOM    232  O   LEU    15       3.826   4.728  -7.628  1.00  1.44           O 
ATOM    233  CB  LEU    15       3.962   1.585  -6.618  1.00 53.10           C 
ATOM    234  CG  LEU    15       4.110   0.651  -5.403  1.00 11.51           C 
ATOM    235  CD1 LEU    15       5.003  -0.542  -5.739  1.00 11.14           C 
ATOM    236  CD2 LEU    15       4.658   1.412  -4.198  1.00 15.41           C 
ATOM    237  H   LEU    15       1.477   1.389  -6.101  1.00 38.87           H 
ATOM    238  HA  LEU    15       3.386   3.347  -5.542  1.00 72.23           H 
ATOM    239 3HB  LEU    15       4.947   1.945  -6.885  1.00 38.87           H 
ATOM    240 2HB  LEU    15       3.575   1.007  -7.446  1.00 38.87           H 
ATOM    241  HG  LEU    15       3.135   0.266  -5.138  1.00  1.04           H 
ATOM    242 1HD1 LEU    15       4.546  -1.124  -6.528  1.00 38.87           H 
ATOM    243 2HD1 LEU    15       5.125  -1.162  -4.862  1.00 38.87           H 
ATOM    244 3HD1 LEU    15       5.969  -0.190  -6.068  1.00 38.87           H 
ATOM    245 1HD2 LEU    15       4.760   0.736  -3.361  1.00 38.87           H 
ATOM    246 2HD2 LEU    15       3.978   2.208  -3.933  1.00 38.87           H 
ATOM    247 3HD2 LEU    15       5.625   1.830  -4.441  1.00 38.87           H 
ATOM    248  N   GLN    16       2.375   3.378  -8.690  1.00  1.31           N 
ATOM    249  CA  GLN    16       2.369   4.172  -9.929  1.00 61.42           C 
ATOM    250  C   GLN    16       1.474   5.419  -9.814  1.00 74.42           C 
ATOM    251  O   GLN    16       1.464   6.269 -10.704  1.00 23.42           O 
ATOM    252  CB  GLN    16       1.923   3.300 -11.111  1.00  0.13           C 
ATOM    253  CG  GLN    16       2.841   2.107 -11.372  1.00 55.04           C 
ATOM    254  CD  GLN    16       4.251   2.515 -11.770  1.00 54.54           C 
ATOM    255  OE1 GLN    16       4.561   2.667 -12.949  1.00  2.11           O 
ATOM    256  NE2 GLN    16       5.118   2.697 -10.795  1.00 32.00           N 
ATOM    257  H   GLN    16       1.819   2.571  -8.637  1.00 38.87           H 
ATOM    258  HA  GLN    16       3.384   4.500 -10.108  1.00 53.34           H 
ATOM    259 3HB  GLN    16       1.893   3.906 -12.005  1.00 38.87           H 
ATOM    260 2HB  GLN    16       0.931   2.921 -10.910  1.00 38.87           H 
ATOM    261 3HG  GLN    16       2.417   1.511 -12.167  1.00 38.87           H 
ATOM    262 2HG  GLN    16       2.897   1.512 -10.473  1.00 38.87           H 
ATOM    263 1HE2 GLN    16       4.817   2.564  -9.876  1.00 38.87           H 
ATOM    264 2HE2 GLN    16       6.032   2.966 -11.034  1.00 38.87           H 
ATOM    265  N   THR    17       0.717   5.518  -8.720  1.00 10.44           N 
ATOM    266  CA  THR    17      -0.111   6.706  -8.458  1.00  2.23           C 
ATOM    267  C   THR    17       0.702   7.796  -7.733  1.00 63.00           C 
ATOM    268  O   THR    17       0.578   8.983  -8.031  1.00 23.51           O 
ATOM    269  CB  THR    17      -1.369   6.349  -7.620  1.00 70.42           C 
ATOM    270  OG1 THR    17      -2.182   5.395  -8.327  1.00 42.52           O 
ATOM    271  CG2 THR    17      -2.207   7.586  -7.315  1.00 72.44           C 
ATOM    272  H   THR    17       0.712   4.779  -8.077  1.00 38.87           H 
ATOM    273  HA  THR    17      -0.441   7.098  -9.412  1.00 24.45           H 
ATOM    274  HB  THR    17      -1.047   5.908  -6.685  1.00 42.02           H 
ATOM    275  HG1 THR    17      -1.640   4.636  -8.579  1.00 52.45           H 
ATOM    276 1HG2 THR    17      -3.079   7.300  -6.745  1.00 38.87           H 
ATOM    277 2HG2 THR    17      -2.517   8.051  -8.239  1.00 38.87           H 
ATOM    278 3HG2 THR    17      -1.617   8.288  -6.742  1.00 38.87           H 
ATOM    279  N   HIS    18       1.525   7.382  -6.767  1.00 50.52           N 
ATOM    280  CA  HIS    18       2.451   8.292  -6.072  1.00 51.53           C 
ATOM    281  C   HIS    18       3.724   7.545  -5.632  1.00 31.25           C 
ATOM    282  O   HIS    18       3.657   6.646  -4.799  1.00 60.41           O 
ATOM    283  CB  HIS    18       1.783   8.934  -4.842  1.00 53.14           C 
ATOM    284  CG  HIS    18       0.845  10.060  -5.164  1.00  0.11           C 
ATOM    285  ND1 HIS    18      -0.476   9.869  -5.500  1.00 44.23           N 
ATOM    286  CD2 HIS    18       1.042  11.401  -5.190  1.00 65.24           C 
ATOM    287  CE1 HIS    18      -1.049  11.033  -5.720  1.00 14.31           C 
ATOM    288  NE2 HIS    18      -0.154  11.980  -5.538  1.00 73.21           N 
ATOM    289  H   HIS    18       1.515   6.433  -6.510  1.00 38.87           H 
ATOM    290  HA  HIS    18       2.729   9.074  -6.767  1.00 42.31           H 
ATOM    291 3HB  HIS    18       2.550   9.321  -4.186  1.00 38.87           H 
ATOM    292 2HB  HIS    18       1.221   8.179  -4.313  1.00 38.87           H 
ATOM    293  HD1 HIS    18      -0.923   9.006  -5.581  1.00  0.44           H 
ATOM    294  HD2 HIS    18       1.966  11.919  -4.974  1.00 42.41           H 
ATOM    295  HE1 HIS    18      -2.081  11.186  -5.997  1.00 43.22           H 
ATOM    296  HE2 HIS    18      -0.266  12.914  -5.823  1.00 38.87           H 
ATOM    297  N   PRO    19       4.902   7.911  -6.176  1.00 44.11           N 
ATOM    298  CA  PRO    19       6.182   7.268  -5.806  1.00 61.45           C 
ATOM    299  C   PRO    19       6.439   7.262  -4.282  1.00  3.03           C 
ATOM    300  O   PRO    19       7.054   6.334  -3.750  1.00 32.42           O 
ATOM    301  CB  PRO    19       7.228   8.125  -6.530  1.00 61.40           C 
ATOM    302  CG  PRO    19       6.492   8.706  -7.691  1.00 64.24           C 
ATOM    303  CD  PRO    19       5.090   8.959  -7.201  1.00 13.23           C 
ATOM    304  HA  PRO    19       6.228   6.252  -6.176  1.00 73.34           H 
ATOM    305 3HB  PRO    19       8.051   7.503  -6.854  1.00 38.87           H 
ATOM    306 2HB  PRO    19       7.593   8.898  -5.866  1.00 38.87           H 
ATOM    307 3HG  PRO    19       6.482   8.000  -8.510  1.00 38.87           H 
ATOM    308 2HG  PRO    19       6.957   9.632  -7.999  1.00 38.87           H 
ATOM    309 3HD  PRO    19       4.379   8.843  -8.008  1.00 38.87           H 
ATOM    310 2HD  PRO    19       5.010   9.944  -6.764  1.00 38.87           H 
ATOM    311  N   GLY    20       5.956   8.297  -3.587  1.00 21.51           N 
ATOM    312  CA  GLY    20       6.109   8.377  -2.132  1.00 71.35           C 
ATOM    313  C   GLY    20       5.455   7.215  -1.384  1.00  4.24           C 
ATOM    314  O   GLY    20       5.810   6.920  -0.237  1.00 31.31           O 
ATOM    315  H   GLY    20       5.499   9.021  -4.066  1.00 38.87           H 
ATOM    316 3HA  GLY    20       5.665   9.301  -1.789  1.00 38.87           H 
ATOM    317 2HA  GLY    20       7.164   8.392  -1.895  1.00 38.87           H 
ATOM    318  N   VAL    21       4.496   6.555  -2.036  1.00 12.22           N 
ATOM    319  CA  VAL    21       3.830   5.378  -1.467  1.00  3.14           C 
ATOM    320  C   VAL    21       4.841   4.265  -1.148  1.00 25.24           C 
ATOM    321  O   VAL    21       4.709   3.566  -0.145  1.00 20.22           O 
ATOM    322  CB  VAL    21       2.737   4.831  -2.428  1.00 21.02           C 
ATOM    323  CG1 VAL    21       2.127   3.532  -1.901  1.00 22.41           C 
ATOM    324  CG2 VAL    21       1.649   5.880  -2.649  1.00 64.42           C 
ATOM    325  H   VAL    21       4.228   6.868  -2.926  1.00 38.87           H 
ATOM    326  HA  VAL    21       3.348   5.682  -0.547  1.00 32.31           H 
ATOM    327  HB  VAL    21       3.201   4.620  -3.384  1.00 72.31           H 
ATOM    328 1HG1 VAL    21       2.904   2.789  -1.790  1.00 38.87           H 
ATOM    329 2HG1 VAL    21       1.385   3.171  -2.599  1.00 38.87           H 
ATOM    330 3HG1 VAL    21       1.663   3.714  -0.943  1.00 38.87           H 
ATOM    331 1HG2 VAL    21       0.920   5.504  -3.352  1.00 38.87           H 
ATOM    332 2HG2 VAL    21       2.095   6.783  -3.044  1.00 38.87           H 
ATOM    333 3HG2 VAL    21       1.164   6.101  -1.710  1.00 38.87           H 
ATOM    334  N   ALA    22       5.865   4.125  -1.991  1.00  3.15           N 
ATOM    335  CA  ALA    22       6.918   3.126  -1.775  1.00 70.13           C 
ATOM    336  C   ALA    22       7.591   3.312  -0.404  1.00 44.44           C 
ATOM    337  O   ALA    22       7.781   2.349   0.340  1.00 33.33           O 
ATOM    338  CB  ALA    22       7.957   3.198  -2.890  1.00 74.52           C 
ATOM    339  H   ALA    22       5.917   4.712  -2.776  1.00 38.87           H 
ATOM    340  HA  ALA    22       6.457   2.146  -1.807  1.00 11.14           H 
ATOM    341 1HB  ALA    22       7.476   3.039  -3.845  1.00 38.87           H 
ATOM    342 2HB  ALA    22       8.708   2.436  -2.736  1.00 38.87           H 
ATOM    343 3HB  ALA    22       8.428   4.171  -2.885  1.00 38.87           H 
ATOM    344  N   GLY    23       7.933   4.558  -0.075  1.00 40.23           N 
ATOM    345  CA  GLY    23       8.535   4.858   1.222  1.00 63.24           C 
ATOM    346  C   GLY    23       7.622   4.506   2.392  1.00 72.20           C 
ATOM    347  O   GLY    23       8.058   3.897   3.373  1.00 14.24           O 
ATOM    348  H   GLY    23       7.774   5.282  -0.716  1.00 38.87           H 
ATOM    349 3HA  GLY    23       8.760   5.914   1.264  1.00 38.87           H 
ATOM    350 2HA  GLY    23       9.458   4.302   1.314  1.00 38.87           H 
ATOM    351  N   VAL    24       6.350   4.883   2.280  1.00 11.32           N 
ATOM    352  CA  VAL    24       5.350   4.561   3.304  1.00  4.13           C 
ATOM    353  C   VAL    24       5.216   3.040   3.488  1.00 52.01           C 
ATOM    354  O   VAL    24       5.308   2.528   4.605  1.00 65.42           O 
ATOM    355  CB  VAL    24       3.964   5.165   2.949  1.00 15.43           C 
ATOM    356  CG1 VAL    24       2.918   4.832   4.017  1.00 62.13           C 
ATOM    357  CG2 VAL    24       4.073   6.677   2.755  1.00 55.22           C 
ATOM    358  H   VAL    24       6.076   5.392   1.487  1.00 38.87           H 
ATOM    359  HA  VAL    24       5.681   4.996   4.238  1.00 44.24           H 
ATOM    360  HB  VAL    24       3.636   4.731   2.013  1.00 63.23           H 
ATOM    361 1HG1 VAL    24       2.821   3.758   4.105  1.00 38.87           H 
ATOM    362 2HG1 VAL    24       1.964   5.256   3.732  1.00 38.87           H 
ATOM    363 3HG1 VAL    24       3.225   5.244   4.968  1.00 38.87           H 
ATOM    364 1HG2 VAL    24       3.105   7.082   2.499  1.00 38.87           H 
ATOM    365 2HG2 VAL    24       4.772   6.889   1.958  1.00 38.87           H 
ATOM    366 3HG2 VAL    24       4.425   7.135   3.669  1.00 38.87           H 
ATOM    367  N   LEU    25       5.024   2.319   2.383  1.00 21.21           N 
ATOM    368  CA  LEU    25       4.890   0.859   2.421  1.00 24.54           C 
ATOM    369  C   LEU    25       6.124   0.189   3.054  1.00 52.53           C 
ATOM    370  O   LEU    25       5.991  -0.631   3.961  1.00  0.34           O 
ATOM    371  CB  LEU    25       4.646   0.301   1.009  1.00 23.11           C 
ATOM    372  CG  LEU    25       3.344   0.768   0.333  1.00 14.31           C 
ATOM    373  CD1 LEU    25       3.195   0.130  -1.046  1.00 41.41           C 
ATOM    374  CD2 LEU    25       2.129   0.460   1.211  1.00 73.14           C 
ATOM    375  H   LEU    25       4.969   2.780   1.519  1.00 38.87           H 
ATOM    376  HA  LEU    25       4.029   0.631   3.035  1.00 24.42           H 
ATOM    377 3HB  LEU    25       4.625  -0.779   1.069  1.00 38.87           H 
ATOM    378 2HB  LEU    25       5.478   0.590   0.381  1.00 38.87           H 
ATOM    379  HG  LEU    25       3.389   1.839   0.194  1.00 22.14           H 
ATOM    380 1HD1 LEU    25       3.158  -0.945  -0.949  1.00 38.87           H 
ATOM    381 2HD1 LEU    25       4.040   0.405  -1.662  1.00 38.87           H 
ATOM    382 3HD1 LEU    25       2.284   0.480  -1.512  1.00 38.87           H 
ATOM    383 1HD2 LEU    25       1.231   0.811   0.723  1.00 38.87           H 
ATOM    384 2HD2 LEU    25       2.236   0.962   2.163  1.00 38.87           H 
ATOM    385 3HD2 LEU    25       2.059  -0.605   1.374  1.00 38.87           H 
ATOM    386  N   ARG    26       7.321   0.551   2.592  1.00 43.22           N 
ATOM    387  CA  ARG    26       8.560  -0.020   3.145  1.00 41.55           C 
ATOM    388  C   ARG    26       8.698   0.292   4.646  1.00 10.22           C 
ATOM    389  O   ARG    26       9.154  -0.547   5.426  1.00 44.14           O 
ATOM    390  CB  ARG    26       9.791   0.483   2.372  1.00  1.12           C 
ATOM    391  CG  ARG    26       9.792   0.088   0.895  1.00  0.12           C 
ATOM    392  CD  ARG    26      11.120   0.413   0.213  1.00 14.24           C 
ATOM    393  NE  ARG    26      12.212  -0.415   0.721  1.00  2.21           N 
ATOM    394  CZ  ARG    26      13.444  -0.363   0.284  1.00 72.04           C 
ATOM    395  NH1 ARG    26      13.782   0.443  -0.671  1.00 25.00           N 
ATOM    396  NH2 ARG    26      14.337  -1.136   0.804  1.00 23.25           N 
ATOM    397  H   ARG    26       7.375   1.216   1.870  1.00 38.87           H 
ATOM    398  HA  ARG    26       8.497  -1.094   3.028  1.00 20.25           H 
ATOM    399 3HB  ARG    26      10.682   0.077   2.833  1.00 38.87           H 
ATOM    400 2HB  ARG    26       9.825   1.562   2.434  1.00 38.87           H 
ATOM    401 3HG  ARG    26       8.999   0.622   0.391  1.00 38.87           H 
ATOM    402 2HG  ARG    26       9.613  -0.975   0.818  1.00 38.87           H 
ATOM    403 3HD  ARG    26      11.356   1.454   0.388  1.00 38.87           H 
ATOM    404 2HD  ARG    26      11.015   0.242  -0.848  1.00 38.87           H 
ATOM    405  HE  ARG    26      12.007  -1.048   1.436  1.00 75.23           H 
ATOM    406 1HH1 ARG    26      13.104   1.036  -1.087  1.00 38.87           H 
ATOM    407 2HH1 ARG    26      14.729   0.464  -0.989  1.00 38.87           H 
ATOM    408 1HH2 ARG    26      14.081  -1.766   1.535  1.00 38.87           H 
ATOM    409 2HH2 ARG    26      15.281  -1.099   0.479  1.00 38.87           H 
ATOM    410  N   SER    27       8.287   1.495   5.048  1.00 41.25           N 
ATOM    411  CA  SER    27       8.268   1.880   6.470  1.00 31.14           C 
ATOM    412  C   SER    27       7.256   1.030   7.257  1.00 64.51           C 
ATOM    413  O   SER    27       7.441   0.755   8.444  1.00  3.25           O 
ATOM    414  CB  SER    27       7.918   3.370   6.624  1.00 40.22           C 
ATOM    415  OG  SER    27       7.865   3.759   7.991  1.00 31.31           O 
ATOM    416  H   SER    27       7.994   2.146   4.373  1.00 38.87           H 
ATOM    417  HA  SER    27       9.255   1.708   6.873  1.00 70.30           H 
ATOM    418 3HB  SER    27       6.952   3.559   6.174  1.00 38.87           H 
ATOM    419 2HB  SER    27       8.666   3.968   6.125  1.00 38.87           H 
ATOM    420  HG  SER    27       8.739   3.656   8.392  1.00 30.31           H 
ATOM    421  N   TYR    28       6.184   0.617   6.583  1.00 45.01           N 
ATOM    422  CA  TYR    28       5.142  -0.224   7.194  1.00 74.51           C 
ATOM    423  C   TYR    28       5.395  -1.724   6.958  1.00 14.23           C 
ATOM    424  O   TYR    28       4.470  -2.529   7.046  1.00 61.03           O 
ATOM    425  CB  TYR    28       3.757   0.166   6.641  1.00 74.03           C 
ATOM    426  CG  TYR    28       3.189   1.441   7.242  1.00 11.24           C 
ATOM    427  CD1 TYR    28       3.911   2.627   7.217  1.00 10.44           C 
ATOM    428  CD2 TYR    28       1.933   1.452   7.841  1.00 20.03           C 
ATOM    429  CE1 TYR    28       3.401   3.784   7.767  1.00 34.33           C 
ATOM    430  CE2 TYR    28       1.416   2.610   8.391  1.00  2.12           C 
ATOM    431  CZ  TYR    28       2.154   3.774   8.356  1.00 71.44           C 
ATOM    432  OH  TYR    28       1.646   4.929   8.911  1.00 63.15           O 
ATOM    433  H   TYR    28       6.081   0.892   5.647  1.00 38.87           H 
ATOM    434  HA  TYR    28       5.152  -0.041   8.260  1.00 10.33           H 
ATOM    435 3HB  TYR    28       3.058  -0.636   6.840  1.00 38.87           H 
ATOM    436 2HB  TYR    28       3.829   0.309   5.572  1.00 38.87           H 
ATOM    437  HD1 TYR    28       4.889   2.637   6.754  1.00 12.04           H 
ATOM    438  HD2 TYR    28       1.354   0.539   7.870  1.00 44.32           H 
ATOM    439  HE1 TYR    28       3.982   4.695   7.734  1.00 31.13           H 
ATOM    440  HE2 TYR    28       0.437   2.597   8.852  1.00  5.42           H 
ATOM    441  HH  TYR    28       1.231   4.715   9.759  1.00 22.42           H 
ATOM    442  N   ASN    29       6.644  -2.094   6.655  1.00 64.12           N 
ATOM    443  CA  ASN    29       7.027  -3.510   6.467  1.00  3.31           C 
ATOM    444  C   ASN    29       6.394  -4.116   5.189  1.00 13.52           C 
ATOM    445  O   ASN    29       6.542  -5.306   4.904  1.00 14.04           O 
ATOM    446  CB  ASN    29       6.643  -4.328   7.718  1.00 42.21           C 
ATOM    447  CG  ASN    29       7.083  -5.781   7.648  1.00 55.45           C 
ATOM    448  OD1 ASN    29       6.340  -6.648   7.204  1.00  2.11           O 
ATOM    449  ND2 ASN    29       8.292  -6.057   8.086  1.00 52.35           N 
ATOM    450  H   ASN    29       7.330  -1.400   6.555  1.00 38.87           H 
ATOM    451  HA  ASN    29       8.102  -3.537   6.355  1.00 41.34           H 
ATOM    452 3HB  ASN    29       5.569  -4.304   7.836  1.00 38.87           H 
ATOM    453 2HB  ASN    29       7.100  -3.880   8.587  1.00 38.87           H 
ATOM    454 1HD2 ASN    29       8.839  -5.324   8.432  1.00 38.87           H 
ATOM    455 2HD2 ASN    29       8.592  -6.988   8.043  1.00 38.87           H 
ATOM    456  N   LEU    30       5.707  -3.287   4.409  1.00 42.54           N 
ATOM    457  CA  LEU    30       5.067  -3.732   3.164  1.00 61.32           C 
ATOM    458  C   LEU    30       6.007  -3.584   1.953  1.00 62.13           C 
ATOM    459  O   LEU    30       5.570  -3.662   0.807  1.00  2.11           O 
ATOM    460  CB  LEU    30       3.776  -2.933   2.923  1.00 24.14           C 
ATOM    461  CG  LEU    30       2.688  -3.094   3.998  1.00 61.14           C 
ATOM    462  CD1 LEU    30       1.493  -2.193   3.696  1.00 70.13           C 
ATOM    463  CD2 LEU    30       2.251  -4.551   4.108  1.00 20.11           C 
ATOM    464  H   LEU    30       5.621  -2.348   4.676  1.00 38.87           H 
ATOM    465  HA  LEU    30       4.812  -4.777   3.276  1.00 51.02           H 
ATOM    466 3HB  LEU    30       3.359  -3.238   1.973  1.00 38.87           H 
ATOM    467 2HB  LEU    30       4.037  -1.885   2.860  1.00 38.87           H 
ATOM    468  HG  LEU    30       3.092  -2.795   4.956  1.00 61.31           H 
ATOM    469 1HD1 LEU    30       0.737  -2.329   4.455  1.00 38.87           H 
ATOM    470 2HD1 LEU    30       1.080  -2.449   2.730  1.00 38.87           H 
ATOM    471 3HD1 LEU    30       1.812  -1.161   3.688  1.00 38.87           H 
ATOM    472 1HD2 LEU    30       3.098  -5.161   4.389  1.00 38.87           H 
ATOM    473 2HD2 LEU    30       1.867  -4.888   3.155  1.00 38.87           H 
ATOM    474 3HD2 LEU    30       1.479  -4.642   4.859  1.00 38.87           H 
ATOM    475  N   GLY    31       7.298  -3.384   2.208  1.00  4.45           N 
ATOM    476  CA  GLY    31       8.267  -3.263   1.121  1.00 25.11           C 
ATOM    477  C   GLY    31       8.489  -4.576   0.377  1.00 51.33           C 
ATOM    478  O   GLY    31       8.813  -4.585  -0.811  1.00 73.35           O 
ATOM    479  H   GLY    31       7.599  -3.325   3.139  1.00 38.87           H 
ATOM    480 3HA  GLY    31       9.210  -2.932   1.534  1.00 38.87           H 
ATOM    481 2HA  GLY    31       7.918  -2.520   0.419  1.00 38.87           H 
ATOM    482  N   CYS    32       8.287  -5.688   1.081  1.00 72.02           N 
ATOM    483  CA  CYS    32       8.477  -7.034   0.510  1.00 52.11           C 
ATOM    484  C   CYS    32       7.477  -7.351  -0.620  1.00 14.33           C 
ATOM    485  O   CYS    32       7.585  -8.391  -1.272  1.00 35.15           O 
ATOM    486  CB  CYS    32       8.352  -8.092   1.616  1.00 20.22           C 
ATOM    487  SG  CYS    32       9.502  -7.864   2.995  1.00 30.33           S 
ATOM    488  H   CYS    32       8.028  -5.606   2.026  1.00 38.87           H 
ATOM    489  HA  CYS    32       9.479  -7.080   0.105  1.00 13.22           H 
ATOM    490 3HB  CYS    32       8.538  -9.069   1.194  1.00 38.87           H 
ATOM    491 2HB  CYS    32       7.351  -8.064   2.020  1.00 38.87           H 
ATOM    492  HG  CYS    32       9.160  -8.712   3.958  1.00  3.32           H 
ATOM    493  N   ILE    33       6.510  -6.455  -0.857  1.00 11.23           N 
ATOM    494  CA  ILE    33       5.483  -6.663  -1.894  1.00 42.40           C 
ATOM    495  C   ILE    33       6.089  -6.954  -3.277  1.00  4.14           C 
ATOM    496  O   ILE    33       5.490  -7.666  -4.089  1.00 21.25           O 
ATOM    497  CB  ILE    33       4.536  -5.443  -2.016  1.00 34.23           C 
ATOM    498  CG1 ILE    33       5.346  -4.154  -2.264  1.00 44.15           C 
ATOM    499  CG2 ILE    33       3.659  -5.319  -0.769  1.00 34.32           C 
ATOM    500  CD1 ILE    33       4.493  -2.917  -2.453  1.00 44.31           C 
ATOM    501  H   ILE    33       6.486  -5.633  -0.322  1.00 38.87           H 
ATOM    502  HA  ILE    33       4.888  -7.517  -1.596  1.00 43.20           H 
ATOM    503  HB  ILE    33       3.880  -5.612  -2.861  1.00 31.14           H 
ATOM    504 3HG1 ILE    33       5.948  -4.279  -3.155  1.00 38.87           H 
ATOM    505 2HG1 ILE    33       5.998  -3.977  -1.422  1.00 38.87           H 
ATOM    506 1HG2 ILE    33       4.284  -5.174   0.101  1.00 38.87           H 
ATOM    507 2HG2 ILE    33       3.076  -6.220  -0.646  1.00 38.87           H 
ATOM    508 3HG2 ILE    33       2.992  -4.474  -0.877  1.00 38.87           H 
ATOM    509 1HD1 ILE    33       3.902  -2.745  -1.565  1.00 38.87           H 
ATOM    510 2HD1 ILE    33       3.838  -3.055  -3.301  1.00 38.87           H 
ATOM    511 3HD1 ILE    33       5.133  -2.064  -2.630  1.00 38.87           H 
ATOM    512  N   GLY    34       7.265  -6.394  -3.547  1.00 63.23           N 
ATOM    513  CA  GLY    34       7.939  -6.647  -4.814  1.00 72.44           C 
ATOM    514  C   GLY    34       8.489  -8.069  -4.918  1.00 55.21           C 
ATOM    515  O   GLY    34       8.434  -8.691  -5.979  1.00  4.52           O 
ATOM    516  H   GLY    34       7.679  -5.800  -2.881  1.00 38.87           H 
ATOM    517 3HA  GLY    34       8.759  -5.952  -4.918  1.00 38.87           H 
ATOM    518 2HA  GLY    34       7.240  -6.483  -5.620  1.00 38.87           H 
ATOM    519  N   CYS    35       9.005  -8.589  -3.808  1.00  2.01           N 
ATOM    520  CA  CYS    35       9.587  -9.938  -3.775  1.00 52.44           C 
ATOM    521  C   CYS    35       8.500 -11.026  -3.747  1.00 23.13           C 
ATOM    522  O   CYS    35       8.498 -11.938  -4.576  1.00 35.54           O 
ATOM    523  CB  CYS    35      10.504 -10.083  -2.555  1.00 45.14           C 
ATOM    524  SG  CYS    35      11.322 -11.690  -2.418  1.00 44.42           S 
ATOM    525  H   CYS    35       8.999  -8.054  -2.987  1.00 38.87           H 
ATOM    526  HA  CYS    35      10.180 -10.065  -4.672  1.00 14.22           H 
ATOM    527 3HB  CYS    35       9.921  -9.933  -1.657  1.00 38.87           H 
ATOM    528 2HB  CYS    35      11.275  -9.330  -2.605  1.00 38.87           H 
ATOM    529  HG  CYS    35      10.648 -12.559  -3.160  1.00 22.02           H 
ATOM    530  N   MET    36       7.564 -10.914  -2.801  1.00 55.31           N 
ATOM    531  CA  MET    36       6.475 -11.897  -2.654  1.00 70.22           C 
ATOM    532  C   MET    36       5.467 -11.836  -3.823  1.00 43.33           C 
ATOM    533  O   MET    36       4.520 -12.621  -3.879  1.00 61.33           O 
ATOM    534  CB  MET    36       5.745 -11.684  -1.316  1.00 63.22           C 
ATOM    535  CG  MET    36       5.045 -10.335  -1.197  1.00 54.23           C 
ATOM    536  SD  MET    36       4.314 -10.059   0.433  1.00 50.02           S 
ATOM    537  CE  MET    36       3.132 -11.405   0.521  1.00  5.25           C 
ATOM    538  H   MET    36       7.613 -10.160  -2.173  1.00 38.87           H 
ATOM    539  HA  MET    36       6.925 -12.880  -2.647  1.00 60.22           H 
ATOM    540 3HB  MET    36       6.463 -11.762  -0.512  1.00 38.87           H 
ATOM    541 2HB  MET    36       5.005 -12.461  -1.195  1.00 38.87           H 
ATOM    542 3HG  MET    36       4.261 -10.285  -1.939  1.00 38.87           H 
ATOM    543 2HG  MET    36       5.764  -9.553  -1.386  1.00 38.87           H 
ATOM    544 1HE  MET    36       2.410 -11.304  -0.276  1.00 38.87           H 
ATOM    545 2HE  MET    36       2.623 -11.376   1.473  1.00 38.87           H 
ATOM    546 3HE  MET    36       3.651 -12.347   0.418  1.00 38.87           H 
ATOM    547  N   GLY    37       5.675 -10.901  -4.753  1.00 33.50           N 
ATOM    548  CA  GLY    37       4.788 -10.772  -5.909  1.00 30.42           C 
ATOM    549  C   GLY    37       3.416 -10.192  -5.565  1.00  5.13           C 
ATOM    550  O   GLY    37       2.431 -10.448  -6.257  1.00 43.15           O 
ATOM    551  H   GLY    37       6.445 -10.303  -4.665  1.00 38.87           H 
ATOM    552 3HA  GLY    37       4.652 -11.749  -6.353  1.00 38.87           H 
ATOM    553 2HA  GLY    37       5.261 -10.127  -6.635  1.00 38.87           H 
ATOM    554  N   ALA    38       3.358  -9.380  -4.511  1.00 21.33           N 
ATOM    555  CA  ALA    38       2.093  -8.779  -4.065  1.00 60.21           C 
ATOM    556  C   ALA    38       1.722  -7.537  -4.893  1.00 53.12           C 
ATOM    557  O   ALA    38       0.788  -6.812  -4.559  1.00 43.01           O 
ATOM    558  CB  ALA    38       2.174  -8.425  -2.585  1.00 32.44           C 
ATOM    559  H   ALA    38       4.182  -9.176  -4.022  1.00 38.87           H 
ATOM    560  HA  ALA    38       1.314  -9.519  -4.187  1.00 30.24           H 
ATOM    561 1HB  ALA    38       1.215  -8.054  -2.249  1.00 38.87           H 
ATOM    562 2HB  ALA    38       2.927  -7.665  -2.435  1.00 38.87           H 
ATOM    563 3HB  ALA    38       2.435  -9.306  -2.017  1.00 38.87           H 
ATOM    564  N   GLN    39       2.454  -7.300  -5.983  1.00 51.54           N 
ATOM    565  CA  GLN    39       2.170  -6.172  -6.880  1.00 52.21           C 
ATOM    566  C   GLN    39       0.734  -6.247  -7.425  1.00 44.13           C 
ATOM    567  O   GLN    39       0.021  -5.245  -7.482  1.00 62.22           O 
ATOM    568  CB  GLN    39       3.172  -6.155  -8.048  1.00 11.11           C 
ATOM    569  CG  GLN    39       4.633  -6.038  -7.616  1.00 12.04           C 
ATOM    570  CD  GLN    39       4.929  -4.760  -6.846  1.00  1.14           C 
ATOM    571  OE1 GLN    39       5.269  -3.732  -7.422  1.00  1.24           O 
ATOM    572  NE2 GLN    39       4.808  -4.815  -5.535  1.00 63.04           N 
ATOM    573  H   GLN    39       3.202  -7.898  -6.190  1.00 38.87           H 
ATOM    574  HA  GLN    39       2.278  -5.259  -6.310  1.00  0.22           H 
ATOM    575 3HB  GLN    39       2.944  -5.319  -8.692  1.00 38.87           H 
ATOM    576 2HB  GLN    39       3.062  -7.071  -8.611  1.00 38.87           H 
ATOM    577 3HG  GLN    39       5.260  -6.061  -8.499  1.00 38.87           H 
ATOM    578 2HG  GLN    39       4.876  -6.882  -6.988  1.00 38.87           H 
ATOM    579 1HE2 GLN    39       4.541  -5.665  -5.130  1.00 38.87           H 
ATOM    580 2HE2 GLN    39       4.990  -4.002  -5.025  1.00 38.87           H 
ATOM    581  N   ASN    40       0.312  -7.455  -7.794  1.00 54.11           N 
ATOM    582  CA  ASN    40      -1.031  -7.687  -8.351  1.00 74.13           C 
ATOM    583  C   ASN    40      -2.066  -7.944  -7.243  1.00 65.32           C 
ATOM    584  O   ASN    40      -3.183  -8.388  -7.511  1.00 44.31           O 
ATOM    585  CB  ASN    40      -0.988  -8.888  -9.306  1.00 10.04           C 
ATOM    586  CG  ASN    40       0.065  -8.732 -10.388  1.00 23.32           C 
ATOM    587  OD1 ASN    40       0.360  -7.628 -10.832  1.00 44.11           O 
ATOM    588  ND2 ASN    40       0.653  -9.832 -10.809  1.00 53.43           N 
ATOM    589  H   ASN    40       0.917  -8.217  -7.689  1.00 38.87           H 
ATOM    590  HA  ASN    40      -1.324  -6.805  -8.904  1.00 74.51           H 
ATOM    591 3HB  ASN    40      -1.953  -8.997  -9.783  1.00 38.87           H 
ATOM    592 2HB  ASN    40      -0.768  -9.784  -8.741  1.00 38.87           H 
ATOM    593 1HD2 ASN    40       0.382 -10.685 -10.410  1.00 38.87           H 
ATOM    594 2HD2 ASN    40       1.346  -9.750 -11.497  1.00 38.87           H 
ATOM    595  N   GLU    41      -1.689  -7.659  -6.000  1.00 31.21           N 
ATOM    596  CA  GLU    41      -2.548  -7.924  -4.840  1.00 53.43           C 
ATOM    597  C   GLU    41      -3.092  -6.616  -4.235  1.00 12.33           C 
ATOM    598  O   GLU    41      -2.418  -5.583  -4.261  1.00 43.41           O 
ATOM    599  CB  GLU    41      -1.748  -8.714  -3.796  1.00 42.53           C 
ATOM    600  CG  GLU    41      -2.547  -9.119  -2.567  1.00 52.30           C 
ATOM    601  CD  GLU    41      -1.776 -10.052  -1.644  1.00 31.01           C 
ATOM    602  OE1 GLU    41      -1.786 -11.279  -1.891  1.00 53.45           O 
ATOM    603  OE2 GLU    41      -1.162  -9.572  -0.672  1.00 62.01           O 
ATOM    604  H   GLU    41      -0.811  -7.253  -5.852  1.00 38.87           H 
ATOM    605  HA  GLU    41      -3.383  -8.527  -5.172  1.00 51.41           H 
ATOM    606 3HB  GLU    41      -0.912  -8.110  -3.470  1.00 38.87           H 
ATOM    607 2HB  GLU    41      -1.366  -9.613  -4.260  1.00 38.87           H 
ATOM    608 3HG  GLU    41      -3.451  -9.617  -2.890  1.00 38.87           H 
ATOM    609 2HG  GLU    41      -2.810  -8.226  -2.017  1.00 38.87           H 
ATOM    610  N   SER    42      -4.319  -6.661  -3.706  1.00 41.03           N 
ATOM    611  CA  SER    42      -4.961  -5.470  -3.118  1.00  3.23           C 
ATOM    612  C   SER    42      -4.293  -5.049  -1.800  1.00 11.01           C 
ATOM    613  O   SER    42      -3.789  -5.888  -1.050  1.00 32.42           O 
ATOM    614  CB  SER    42      -6.458  -5.722  -2.873  1.00 14.55           C 
ATOM    615  OG  SER    42      -7.145  -6.007  -4.084  1.00 70.13           O 
ATOM    616  H   SER    42      -4.807  -7.510  -3.713  1.00 38.87           H 
ATOM    617  HA  SER    42      -4.859  -4.661  -3.828  1.00 32.13           H 
ATOM    618 3HB  SER    42      -6.900  -4.843  -2.425  1.00 38.87           H 
ATOM    619 2HB  SER    42      -6.576  -6.561  -2.204  1.00 38.87           H 
ATOM    620  HG  SER    42      -7.870  -5.378  -4.197  1.00 72.35           H 
ATOM    621  N   LEU    43      -4.334  -3.745  -1.511  1.00 34.52           N 
ATOM    622  CA  LEU    43      -3.680  -3.178  -0.320  1.00 51.01           C 
ATOM    623  C   LEU    43      -4.101  -3.890   0.980  1.00 74.01           C 
ATOM    624  O   LEU    43      -3.260  -4.209   1.824  1.00 54.43           O 
ATOM    625  CB  LEU    43      -3.980  -1.673  -0.207  1.00 41.31           C 
ATOM    626  CG  LEU    43      -3.465  -0.804  -1.370  1.00 64.44           C 
ATOM    627  CD1 LEU    43      -3.791   0.670  -1.132  1.00 51.40           C 
ATOM    628  CD2 LEU    43      -1.961  -0.997  -1.560  1.00 34.20           C 
ATOM    629  H   LEU    43      -4.808  -3.142  -2.124  1.00 38.87           H 
ATOM    630  HA  LEU    43      -2.614  -3.305  -0.446  1.00 12.32           H 
ATOM    631 3HB  LEU    43      -3.535  -1.307   0.707  1.00 38.87           H 
ATOM    632 2HB  LEU    43      -5.052  -1.546  -0.137  1.00 38.87           H 
ATOM    633  HG  LEU    43      -3.958  -1.109  -2.283  1.00 73.25           H 
ATOM    634 1HD1 LEU    43      -3.449   1.257  -1.973  1.00 38.87           H 
ATOM    635 2HD1 LEU    43      -3.297   1.009  -0.233  1.00 38.87           H 
ATOM    636 3HD1 LEU    43      -4.859   0.790  -1.020  1.00 38.87           H 
ATOM    637 1HD2 LEU    43      -1.442  -0.711  -0.656  1.00 38.87           H 
ATOM    638 2HD2 LEU    43      -1.617  -0.382  -2.380  1.00 38.87           H 
ATOM    639 3HD2 LEU    43      -1.755  -2.035  -1.781  1.00 38.87           H 
ATOM    640  N   GLU    44      -5.401  -4.143   1.137  1.00 63.43           N 
ATOM    641  CA  GLU    44      -5.916  -4.782   2.357  1.00 53.33           C 
ATOM    642  C   GLU    44      -5.391  -6.221   2.516  1.00 13.40           C 
ATOM    643  O   GLU    44      -5.106  -6.668   3.631  1.00 42.44           O 
ATOM    644  CB  GLU    44      -7.454  -4.769   2.367  1.00  1.52           C 
ATOM    645  CG  GLU    44      -8.063  -5.312   3.657  1.00 44.00           C 
ATOM    646  CD  GLU    44      -9.574  -5.141   3.724  1.00 71.34           C 
ATOM    647  OE1 GLU    44     -10.303  -5.980   3.152  1.00 73.53           O 
ATOM    648  OE2 GLU    44     -10.040  -4.172   4.363  1.00 70.00           O 
ATOM    649  H   GLU    44      -6.026  -3.892   0.422  1.00 38.87           H 
ATOM    650  HA  GLU    44      -5.565  -4.200   3.198  1.00 63.33           H 
ATOM    651 3HB  GLU    44      -7.817  -5.367   1.541  1.00 38.87           H 
ATOM    652 2HB  GLU    44      -7.792  -3.751   2.237  1.00 38.87           H 
ATOM    653 3HG  GLU    44      -7.618  -4.791   4.494  1.00 38.87           H 
ATOM    654 2HG  GLU    44      -7.832  -6.366   3.735  1.00 38.87           H 
ATOM    655  N   GLN    45      -5.236  -6.928   1.397  1.00 42.12           N 
ATOM    656  CA  GLN    45      -4.756  -8.316   1.419  1.00 51.24           C 
ATOM    657  C   GLN    45      -3.315  -8.398   1.954  1.00 43.02           C 
ATOM    658  O   GLN    45      -3.017  -9.191   2.854  1.00 75.43           O 
ATOM    659  CB  GLN    45      -4.839  -8.928   0.013  1.00 52.21           C 
ATOM    660  CG  GLN    45      -6.252  -8.961  -0.564  1.00 72.12           C 
ATOM    661  CD  GLN    45      -6.314  -9.557  -1.964  1.00 24.00           C 
ATOM    662  OE1 GLN    45      -5.518 -10.415  -2.330  1.00  4.23           O 
ATOM    663  NE2 GLN    45      -7.260  -9.104  -2.762  1.00 52.32           N 
ATOM    664  H   GLN    45      -5.437  -6.506   0.536  1.00 38.87           H 
ATOM    665  HA  GLN    45      -5.400  -8.876   2.083  1.00 63.43           H 
ATOM    666 3HB  GLN    45      -4.464  -9.941   0.049  1.00 38.87           H 
ATOM    667 2HB  GLN    45      -4.216  -8.349  -0.655  1.00 38.87           H 
ATOM    668 3HG  GLN    45      -6.632  -7.950  -0.601  1.00 38.87           H 
ATOM    669 2HG  GLN    45      -6.878  -9.554   0.087  1.00 38.87           H 
ATOM    670 1HE2 GLN    45      -7.869  -8.417  -2.416  1.00 38.87           H 
ATOM    671 2HE2 GLN    45      -7.316  -9.472  -3.668  1.00 38.87           H 
ATOM    672  N   GLY    46      -2.431  -7.567   1.405  1.00 51.42           N 
ATOM    673  CA  GLY    46      -1.055  -7.505   1.890  1.00 71.41           C 
ATOM    674  C   GLY    46      -0.952  -6.979   3.320  1.00 35.30           C 
ATOM    675  O   GLY    46      -0.099  -7.418   4.097  1.00 44.35           O 
ATOM    676  H   GLY    46      -2.709  -7.001   0.652  1.00 38.87           H 
ATOM    677 3HA  GLY    46      -0.490  -6.853   1.241  1.00 38.87           H 
ATOM    678 2HA  GLY    46      -0.623  -8.497   1.848  1.00 38.87           H 
ATOM    679  N   ALA    47      -1.834  -6.040   3.669  1.00 64.50           N 
ATOM    680  CA  ALA    47      -1.882  -5.471   5.021  1.00 62.21           C 
ATOM    681  C   ALA    47      -2.108  -6.558   6.085  1.00 72.41           C 
ATOM    682  O   ALA    47      -1.281  -6.746   6.978  1.00 22.11           O 
ATOM    683  CB  ALA    47      -2.973  -4.409   5.107  1.00 24.11           C 
ATOM    684  H   ALA    47      -2.470  -5.715   2.996  1.00 38.87           H 
ATOM    685  HA  ALA    47      -0.932  -4.992   5.209  1.00 75.31           H 
ATOM    686 1HB  ALA    47      -2.966  -3.960   6.089  1.00 38.87           H 
ATOM    687 2HB  ALA    47      -3.936  -4.865   4.926  1.00 38.87           H 
ATOM    688 3HB  ALA    47      -2.793  -3.648   4.362  1.00 38.87           H 
ATOM    689  N   ASN    48      -3.223  -7.284   5.978  1.00 11.12           N 
ATOM    690  CA  ASN    48      -3.529  -8.366   6.926  1.00 44.43           C 
ATOM    691  C   ASN    48      -2.442  -9.455   6.910  1.00 63.01           C 
ATOM    692  O   ASN    48      -2.128 -10.047   7.946  1.00 33.10           O 
ATOM    693  CB  ASN    48      -4.901  -8.985   6.634  1.00 40.54           C 
ATOM    694  CG  ASN    48      -6.043  -8.023   6.917  1.00  0.33           C 
ATOM    695  OD1 ASN    48      -6.509  -7.907   8.047  1.00  3.44           O 
ATOM    696  ND2 ASN    48      -6.513  -7.337   5.897  1.00  3.10           N 
ATOM    697  H   ASN    48      -3.852  -7.088   5.249  1.00 38.87           H 
ATOM    698  HA  ASN    48      -3.552  -7.928   7.915  1.00 72.44           H 
ATOM    699 3HB  ASN    48      -5.034  -9.862   7.252  1.00 38.87           H 
ATOM    700 2HB  ASN    48      -4.944  -9.273   5.593  1.00 38.87           H 
ATOM    701 1HD2 ASN    48      -6.108  -7.476   5.017  1.00 38.87           H 
ATOM    702 2HD2 ASN    48      -7.252  -6.717   6.063  1.00 38.87           H 
ATOM    703  N   ALA    49      -1.859  -9.707   5.738  1.00 74.10           N 
ATOM    704  CA  ALA    49      -0.749 -10.662   5.611  1.00 51.45           C 
ATOM    705  C   ALA    49       0.451 -10.257   6.484  1.00  2.25           C 
ATOM    706  O   ALA    49       1.184 -11.109   6.990  1.00  2.32           O 
ATOM    707  CB  ALA    49      -0.318 -10.776   4.156  1.00 75.30           C 
ATOM    708  H   ALA    49      -2.189  -9.249   4.934  1.00 38.87           H 
ATOM    709  HA  ALA    49      -1.106 -11.631   5.933  1.00  3.45           H 
ATOM    710 1HB  ALA    49       0.044  -9.818   3.811  1.00 38.87           H 
ATOM    711 2HB  ALA    49      -1.159 -11.080   3.553  1.00 38.87           H 
ATOM    712 3HB  ALA    49       0.472 -11.510   4.067  1.00 38.87           H 
ATOM    713  N   HIS    50       0.650  -8.949   6.647  1.00 62.00           N 
ATOM    714  CA  HIS    50       1.732  -8.419   7.490  1.00 30.31           C 
ATOM    715  C   HIS    50       1.202  -7.970   8.871  1.00 11.52           C 
ATOM    716  O   HIS    50       1.909  -7.317   9.639  1.00 44.31           O 
ATOM    717  CB  HIS    50       2.432  -7.249   6.776  1.00 53.20           C 
ATOM    718  CG  HIS    50       3.182  -7.652   5.534  1.00  5.11           C 
ATOM    719  ND1 HIS    50       4.471  -7.246   5.264  1.00 60.44           N 
ATOM    720  CD2 HIS    50       2.810  -8.413   4.474  1.00 44.03           C 
ATOM    721  CE1 HIS    50       4.856  -7.736   4.104  1.00 51.25           C 
ATOM    722  NE2 HIS    50       3.871  -8.450   3.600  1.00 61.50           N 
ATOM    723  H   HIS    50       0.054  -8.319   6.184  1.00 38.87           H 
ATOM    724  HA  HIS    50       2.452  -9.211   7.644  1.00 34.54           H 
ATOM    725 3HB  HIS    50       3.135  -6.791   7.455  1.00 38.87           H 
ATOM    726 2HB  HIS    50       1.690  -6.517   6.491  1.00 38.87           H 
ATOM    727  HD1 HIS    50       5.034  -6.692   5.849  1.00 14.34           H 
ATOM    728  HD2 HIS    50       1.856  -8.904   4.344  1.00 22.02           H 
ATOM    729  HE1 HIS    50       5.820  -7.580   3.644  1.00 42.23           H 
ATOM    730  HE2 HIS    50       3.990  -9.127   2.899  1.00 38.87           H 
ATOM    731  N   GLY    51      -0.047  -8.331   9.173  1.00 23.15           N 
ATOM    732  CA  GLY    51      -0.641  -8.026  10.476  1.00  4.03           C 
ATOM    733  C   GLY    51      -0.895  -6.539  10.717  1.00 61.15           C 
ATOM    734  O   GLY    51      -0.739  -6.047  11.838  1.00  1.41           O 
ATOM    735  H   GLY    51      -0.572  -8.820   8.506  1.00 38.87           H 
ATOM    736 3HA  GLY    51       0.016  -8.395  11.251  1.00 38.87           H 
ATOM    737 2HA  GLY    51      -1.584  -8.547  10.551  1.00 38.87           H 
ATOM    738  N   LEU    52      -1.296  -5.823   9.673  1.00 13.43           N 
ATOM    739  CA  LEU    52      -1.580  -4.387   9.774  1.00  3.32           C 
ATOM    740  C   LEU    52      -3.032  -4.077   9.386  1.00 73.02           C 
ATOM    741  O   LEU    52      -3.703  -4.885   8.738  1.00 24.11           O 
ATOM    742  CB  LEU    52      -0.627  -3.596   8.865  1.00 41.45           C 
ATOM    743  CG  LEU    52       0.869  -3.748   9.180  1.00 21.44           C 
ATOM    744  CD1 LEU    52       1.706  -2.969   8.174  1.00 72.31           C 
ATOM    745  CD2 LEU    52       1.171  -3.285  10.604  1.00 11.11           C 
ATOM    746  H   LEU    52      -1.403  -6.270   8.808  1.00 38.87           H 
ATOM    747  HA  LEU    52      -1.421  -4.081  10.799  1.00 62.12           H 
ATOM    748 3HB  LEU    52      -0.881  -2.548   8.941  1.00 38.87           H 
ATOM    749 2HB  LEU    52      -0.794  -3.913   7.843  1.00 38.87           H 
ATOM    750  HG  LEU    52       1.145  -4.792   9.104  1.00 52.43           H 
ATOM    751 1HD1 LEU    52       2.753  -3.074   8.417  1.00 38.87           H 
ATOM    752 2HD1 LEU    52       1.432  -1.924   8.209  1.00 38.87           H 
ATOM    753 3HD1 LEU    52       1.528  -3.353   7.181  1.00 38.87           H 
ATOM    754 1HD2 LEU    52       0.603  -3.879  11.306  1.00 38.87           H 
ATOM    755 2HD2 LEU    52       0.896  -2.245  10.709  1.00 38.87           H 
ATOM    756 3HD2 LEU    52       2.226  -3.400  10.805  1.00 38.87           H 
ATOM    757  N   ASN    53      -3.520  -2.908   9.789  1.00 21.20           N 
ATOM    758  CA  ASN    53      -4.858  -2.458   9.399  1.00  1.31           C 
ATOM    759  C   ASN    53      -4.763  -1.489   8.213  1.00 60.51           C 
ATOM    760  O   ASN    53      -4.085  -0.462   8.286  1.00  3.35           O 
ATOM    761  CB  ASN    53      -5.568  -1.786  10.582  1.00 54.22           C 
ATOM    762  CG  ASN    53      -7.045  -1.541  10.321  1.00 44.44           C 
ATOM    763  OD1 ASN    53      -7.477  -1.407   9.182  1.00 23.30           O 
ATOM    764  ND2 ASN    53      -7.831  -1.471  11.375  1.00 13.44           N 
ATOM    765  H   ASN    53      -2.970  -2.333  10.363  1.00 38.87           H 
ATOM    766  HA  ASN    53      -5.427  -3.328   9.094  1.00 43.34           H 
ATOM    767 3HB  ASN    53      -5.097  -0.835  10.786  1.00 38.87           H 
ATOM    768 2HB  ASN    53      -5.478  -2.419  11.453  1.00 38.87           H 
ATOM    769 1HD2 ASN    53      -7.428  -1.581  12.261  1.00 38.87           H 
ATOM    770 2HD2 ASN    53      -8.786  -1.310  11.229  1.00 38.87           H 
ATOM    771  N   VAL    54      -5.458  -1.815   7.129  1.00 55.22           N 
ATOM    772  CA  VAL    54      -5.397  -1.020   5.902  1.00 12.33           C 
ATOM    773  C   VAL    54      -5.886   0.424   6.127  1.00 10.12           C 
ATOM    774  O   VAL    54      -5.478   1.339   5.414  1.00 44.44           O 
ATOM    775  CB  VAL    54      -6.224  -1.680   4.770  1.00 72.23           C 
ATOM    776  CG1 VAL    54      -7.711  -1.685   5.113  1.00 54.15           C 
ATOM    777  CG2 VAL    54      -5.961  -0.992   3.429  1.00  1.54           C 
ATOM    778  H   VAL    54      -6.029  -2.612   7.152  1.00 38.87           H 
ATOM    779  HA  VAL    54      -4.364  -0.989   5.586  1.00  4.41           H 
ATOM    780  HB  VAL    54      -5.905  -2.711   4.682  1.00 52.32           H 
ATOM    781 1HG1 VAL    54      -7.868  -2.238   6.028  1.00 38.87           H 
ATOM    782 2HG1 VAL    54      -8.264  -2.152   4.313  1.00 38.87           H 
ATOM    783 3HG1 VAL    54      -8.057  -0.668   5.244  1.00 38.87           H 
ATOM    784 1HG2 VAL    54      -6.270   0.043   3.486  1.00 38.87           H 
ATOM    785 2HG2 VAL    54      -6.522  -1.491   2.653  1.00 38.87           H 
ATOM    786 3HG2 VAL    54      -4.907  -1.041   3.199  1.00 38.87           H 
ATOM    787  N   GLU    55      -6.747   0.622   7.129  1.00  2.41           N 
ATOM    788  CA  GLU    55      -7.280   1.956   7.445  1.00 32.13           C 
ATOM    789  C   GLU    55      -6.154   2.971   7.712  1.00 43.44           C 
ATOM    790  O   GLU    55      -6.118   4.051   7.113  1.00 64.42           O 
ATOM    791  CB  GLU    55      -8.210   1.886   8.667  1.00 23.34           C 
ATOM    792  CG  GLU    55      -9.406   0.955   8.494  1.00 73.43           C 
ATOM    793  CD  GLU    55     -10.260   1.294   7.284  1.00 64.30           C 
ATOM    794  OE1 GLU    55     -10.823   2.411   7.240  1.00 63.25           O 
ATOM    795  OE2 GLU    55     -10.388   0.439   6.382  1.00 33.35           O 
ATOM    796  H   GLU    55      -7.036  -0.145   7.667  1.00 38.87           H 
ATOM    797  HA  GLU    55      -7.852   2.289   6.592  1.00 24.50           H 
ATOM    798 3HB  GLU    55      -8.583   2.879   8.879  1.00 38.87           H 
ATOM    799 2HB  GLU    55      -7.640   1.541   9.518  1.00 38.87           H 
ATOM    800 3HG  GLU    55     -10.022   1.021   9.380  1.00 38.87           H 
ATOM    801 2HG  GLU    55      -9.043  -0.058   8.390  1.00 38.87           H 
ATOM    802  N   ASP    56      -5.234   2.611   8.608  1.00 25.43           N 
ATOM    803  CA  ASP    56      -4.102   3.480   8.956  1.00 72.02           C 
ATOM    804  C   ASP    56      -3.191   3.719   7.738  1.00 71.12           C 
ATOM    805  O   ASP    56      -2.635   4.806   7.561  1.00 55.40           O 
ATOM    806  CB  ASP    56      -3.302   2.860  10.109  1.00 72.35           C 
ATOM    807  CG  ASP    56      -2.157   3.750  10.562  1.00 62.42           C 
ATOM    808  OD1 ASP    56      -2.426   4.820  11.139  1.00 53.10           O 
ATOM    809  OD2 ASP    56      -0.983   3.388  10.344  1.00 42.03           O 
ATOM    810  H   ASP    56      -5.316   1.741   9.049  1.00 38.87           H 
ATOM    811  HA  ASP    56      -4.504   4.430   9.280  1.00 33.13           H 
ATOM    812 3HB  ASP    56      -2.897   1.909   9.792  1.00 38.87           H 
ATOM    813 2HB  ASP    56      -3.962   2.699  10.952  1.00 38.87           H 
ATOM    814  N   ILE    57      -3.056   2.695   6.898  1.00 72.32           N 
ATOM    815  CA  ILE    57      -2.252   2.794   5.676  1.00 42.34           C 
ATOM    816  C   ILE    57      -2.869   3.807   4.693  1.00 13.41           C 
ATOM    817  O   ILE    57      -2.199   4.735   4.233  1.00 50.14           O 
ATOM    818  CB  ILE    57      -2.119   1.411   4.984  1.00 52.34           C 
ATOM    819  CG1 ILE    57      -1.555   0.377   5.975  1.00 62.34           C 
ATOM    820  CG2 ILE    57      -1.232   1.514   3.742  1.00 75.10           C 
ATOM    821  CD1 ILE    57      -1.460  -1.026   5.412  1.00 62.13           C 
ATOM    822  H   ILE    57      -3.512   1.851   7.104  1.00 38.87           H 
ATOM    823  HA  ILE    57      -1.264   3.133   5.955  1.00 63.13           H 
ATOM    824  HB  ILE    57      -3.104   1.094   4.666  1.00 55.12           H 
ATOM    825 3HG1 ILE    57      -2.194   0.339   6.847  1.00 38.87           H 
ATOM    826 2HG1 ILE    57      -0.563   0.677   6.276  1.00 38.87           H 
ATOM    827 1HG2 ILE    57      -1.150   0.545   3.270  1.00 38.87           H 
ATOM    828 2HG2 ILE    57      -0.249   1.859   4.028  1.00 38.87           H 
ATOM    829 3HG2 ILE    57      -1.668   2.216   3.046  1.00 38.87           H 
ATOM    830 1HD1 ILE    57      -2.443  -1.365   5.120  1.00 38.87           H 
ATOM    831 2HD1 ILE    57      -1.060  -1.689   6.165  1.00 38.87           H 
ATOM    832 3HD1 ILE    57      -0.809  -1.027   4.549  1.00 38.87           H 
ATOM    833  N   LEU    58      -4.158   3.631   4.396  1.00 30.44           N 
ATOM    834  CA  LEU    58      -4.887   4.540   3.500  1.00 61.54           C 
ATOM    835  C   LEU    58      -4.835   5.985   4.017  1.00 50.43           C 
ATOM    836  O   LEU    58      -4.753   6.934   3.236  1.00 73.43           O 
ATOM    837  CB  LEU    58      -6.350   4.097   3.356  1.00 50.24           C 
ATOM    838  CG  LEU    58      -6.562   2.680   2.795  1.00 43.33           C 
ATOM    839  CD1 LEU    58      -8.053   2.367   2.669  1.00 52.13           C 
ATOM    840  CD2 LEU    58      -5.852   2.516   1.452  1.00 33.40           C 
ATOM    841  H   LEU    58      -4.634   2.872   4.792  1.00 38.87           H 
ATOM    842  HA  LEU    58      -4.409   4.500   2.531  1.00  0.51           H 
ATOM    843 3HB  LEU    58      -6.852   4.797   2.703  1.00 38.87           H 
ATOM    844 2HB  LEU    58      -6.815   4.147   4.333  1.00 38.87           H 
ATOM    845  HG  LEU    58      -6.136   1.963   3.485  1.00 62.02           H 
ATOM    846 1HD1 LEU    58      -8.180   1.373   2.264  1.00 38.87           H 
ATOM    847 2HD1 LEU    58      -8.521   3.084   2.010  1.00 38.87           H 
ATOM    848 3HD1 LEU    58      -8.517   2.418   3.643  1.00 38.87           H 
ATOM    849 1HD2 LEU    58      -4.791   2.677   1.581  1.00 38.87           H 
ATOM    850 2HD2 LEU    58      -6.240   3.237   0.745  1.00 38.87           H 
ATOM    851 3HD2 LEU    58      -6.018   1.518   1.074  1.00 38.87           H 
ATOM    852  N   ARG    59      -4.891   6.136   5.338  1.00 11.23           N 
ATOM    853  CA  ARG    59      -4.777   7.449   5.982  1.00 25.24           C 
ATOM    854  C   ARG    59      -3.526   8.207   5.502  1.00 55.33           C 
ATOM    855  O   ARG    59      -3.619   9.327   4.989  1.00 65.22           O 
ATOM    856  CB  ARG    59      -4.711   7.274   7.509  1.00 64.02           C 
ATOM    857  CG  ARG    59      -4.328   8.546   8.269  1.00  0.44           C 
ATOM    858  CD  ARG    59      -3.902   8.249   9.706  1.00 74.21           C 
ATOM    859  NE  ARG    59      -2.835   7.248   9.764  1.00 51.41           N 
ATOM    860  CZ  ARG    59      -1.595   7.454   9.400  1.00 60.32           C 
ATOM    861  NH1 ARG    59      -1.207   8.617   8.977  1.00 71.44           N 
ATOM    862  NH2 ARG    59      -0.741   6.487   9.470  1.00 34.04           N 
ATOM    863  H   ARG    59      -5.019   5.340   5.900  1.00 38.87           H 
ATOM    864  HA  ARG    59      -5.657   8.023   5.730  1.00  4.43           H 
ATOM    865 3HB  ARG    59      -3.981   6.510   7.738  1.00 38.87           H 
ATOM    866 2HB  ARG    59      -5.680   6.947   7.864  1.00 38.87           H 
ATOM    867 3HG  ARG    59      -5.178   9.215   8.286  1.00 38.87           H 
ATOM    868 2HG  ARG    59      -3.507   9.026   7.757  1.00 38.87           H 
ATOM    869 3HD  ARG    59      -4.757   7.880  10.254  1.00 38.87           H 
ATOM    870 2HD  ARG    59      -3.551   9.163  10.163  1.00 38.87           H 
ATOM    871  HE  ARG    59      -3.072   6.359  10.101  1.00 63.33           H 
ATOM    872 1HH1 ARG    59      -1.852   9.375   8.934  1.00 38.87           H 
ATOM    873 2HH1 ARG    59      -0.259   8.751   8.688  1.00 38.87           H 
ATOM    874 1HH2 ARG    59      -1.033   5.593   9.808  1.00 38.87           H 
ATOM    875 2HH2 ARG    59       0.203   6.632   9.187  1.00 38.87           H 
ATOM    876  N   ASP    60      -2.359   7.585   5.668  1.00 53.22           N 
ATOM    877  CA  ASP    60      -1.088   8.234   5.346  1.00 63.13           C 
ATOM    878  C   ASP    60      -0.873   8.340   3.822  1.00 62.14           C 
ATOM    879  O   ASP    60      -0.331   9.332   3.328  1.00 44.05           O 
ATOM    880  CB  ASP    60       0.069   7.476   6.015  1.00 73.14           C 
ATOM    881  CG  ASP    60       1.209   8.400   6.410  1.00 25.13           C 
ATOM    882  OD1 ASP    60       2.176   8.534   5.637  1.00 61.03           O 
ATOM    883  OD2 ASP    60       1.129   9.006   7.505  1.00  0.21           O 
ATOM    884  H   ASP    60      -2.351   6.665   6.016  1.00 38.87           H 
ATOM    885  HA  ASP    60      -1.126   9.237   5.754  1.00 42.44           H 
ATOM    886 3HB  ASP    60       0.449   6.729   5.332  1.00 38.87           H 
ATOM    887 2HB  ASP    60      -0.298   6.987   6.906  1.00 38.87           H 
ATOM    888  N   LEU    61      -1.312   7.317   3.082  1.00 24.25           N 
ATOM    889  CA  LEU    61      -1.205   7.317   1.614  1.00 43.24           C 
ATOM    890  C   LEU    61      -2.027   8.455   0.985  1.00 51.04           C 
ATOM    891  O   LEU    61      -1.540   9.188   0.124  1.00 71.55           O 
ATOM    892  CB  LEU    61      -1.663   5.971   1.031  1.00  4.30           C 
ATOM    893  CG  LEU    61      -0.806   4.752   1.412  1.00 73.10           C 
ATOM    894  CD1 LEU    61      -1.315   3.497   0.704  1.00 71.04           C 
ATOM    895  CD2 LEU    61       0.664   5.004   1.086  1.00  0.30           C 
ATOM    896  H   LEU    61      -1.707   6.538   3.534  1.00 38.87           H 
ATOM    897  HA  LEU    61      -0.165   7.468   1.363  1.00 44.53           H 
ATOM    898 3HB  LEU    61      -1.665   6.054  -0.047  1.00 38.87           H 
ATOM    899 2HB  LEU    61      -2.678   5.788   1.358  1.00 38.87           H 
ATOM    900  HG  LEU    61      -0.888   4.584   2.477  1.00 74.01           H 
ATOM    901 1HD1 LEU    61      -2.333   3.298   1.008  1.00 38.87           H 
ATOM    902 2HD1 LEU    61      -0.691   2.654   0.970  1.00 38.87           H 
ATOM    903 3HD1 LEU    61      -1.281   3.646  -0.365  1.00 38.87           H 
ATOM    904 1HD2 LEU    61       0.764   5.260   0.041  1.00 38.87           H 
ATOM    905 2HD2 LEU    61       1.238   4.114   1.295  1.00 38.87           H 
ATOM    906 3HD2 LEU    61       1.033   5.819   1.694  1.00 38.87           H 
ATOM    907  N   ASN    62      -3.279   8.592   1.413  1.00 14.32           N 
ATOM    908  CA  ASN    62      -4.150   9.674   0.930  1.00 43.21           C 
ATOM    909  C   ASN    62      -3.579  11.055   1.291  1.00 40.41           C 
ATOM    910  O   ASN    62      -3.788  12.036   0.574  1.00 53.15           O 
ATOM    911  CB  ASN    62      -5.567   9.510   1.496  1.00 22.11           C 
ATOM    912  CG  ASN    62      -6.316   8.353   0.854  1.00 42.31           C 
ATOM    913  OD1 ASN    62      -6.193   8.102  -0.339  1.00 21.13           O 
ATOM    914  ND2 ASN    62      -7.086   7.629   1.641  1.00 42.20           N 
ATOM    915  H   ASN    62      -3.629   7.949   2.068  1.00 38.87           H 
ATOM    916  HA  ASN    62      -4.196   9.596  -0.147  1.00 21.13           H 
ATOM    917 3HB  ASN    62      -6.127  10.417   1.319  1.00 38.87           H 
ATOM    918 2HB  ASN    62      -5.507   9.332   2.560  1.00 38.87           H 
ATOM    919 1HD2 ASN    62      -7.139   7.870   2.586  1.00 38.87           H 
ATOM    920 2HD2 ASN    62      -7.568   6.874   1.242  1.00 38.87           H 
ATOM    921  N   ALA    63      -2.843  11.119   2.398  1.00 23.15           N 
ATOM    922  CA  ALA    63      -2.149  12.349   2.795  1.00 10.24           C 
ATOM    923  C   ALA    63      -1.080  12.743   1.759  1.00 72.40           C 
ATOM    924  O   ALA    63      -0.778  13.926   1.582  1.00 54.04           O 
ATOM    925  CB  ALA    63      -1.530  12.177   4.177  1.00 62.15           C 
ATOM    926  H   ALA    63      -2.767  10.323   2.966  1.00 38.87           H 
ATOM    927  HA  ALA    63      -2.886  13.139   2.853  1.00 22.24           H 
ATOM    928 1HB  ALA    63      -1.071  13.106   4.485  1.00 38.87           H 
ATOM    929 2HB  ALA    63      -0.780  11.400   4.143  1.00 38.87           H 
ATOM    930 3HB  ALA    63      -2.298  11.904   4.887  1.00 38.87           H 
ATOM    931  N   LEU    64      -0.514  11.739   1.077  1.00  2.21           N 
ATOM    932  CA  LEU    64       0.438  11.977  -0.019  1.00 60.51           C 
ATOM    933  C   LEU    64      -0.259  12.629  -1.224  1.00 22.12           C 
ATOM    934  O   LEU    64       0.378  13.298  -2.035  1.00 61.31           O 
ATOM    935  CB  LEU    64       1.087  10.657  -0.470  1.00 34.34           C 
ATOM    936  CG  LEU    64       1.870   9.892   0.607  1.00  0.14           C 
ATOM    937  CD1 LEU    64       2.339   8.543   0.064  1.00 70.33           C 
ATOM    938  CD2 LEU    64       3.054  10.720   1.105  1.00 23.33           C 
ATOM    939  H   LEU    64      -0.742  10.813   1.318  1.00 38.87           H 
ATOM    940  HA  LEU    64       1.209  12.644   0.344  1.00  5.14           H 
ATOM    941 3HB  LEU    64       1.765  10.874  -1.285  1.00 38.87           H 
ATOM    942 2HB  LEU    64       0.306  10.010  -0.845  1.00 38.87           H 
ATOM    943  HG  LEU    64       1.219   9.702   1.448  1.00 74.32           H 
ATOM    944 1HD1 LEU    64       2.894   8.019   0.829  1.00 38.87           H 
ATOM    945 2HD1 LEU    64       2.973   8.697  -0.798  1.00 38.87           H 
ATOM    946 3HD1 LEU    64       1.480   7.952  -0.224  1.00 38.87           H 
ATOM    947 1HD2 LEU    64       3.595  10.163   1.857  1.00 38.87           H 
ATOM    948 2HD2 LEU    64       2.694  11.643   1.535  1.00 38.87           H 
ATOM    949 3HD2 LEU    64       3.715  10.943   0.278  1.00 38.87           H 
ATOM    950  N   ALA    65      -1.567  12.402  -1.347  1.00  0.42           N 
ATOM    951  CA  ALA    65      -2.361  12.995  -2.428  1.00 64.02           C 
ATOM    952  C   ALA    65      -2.726  14.456  -2.120  1.00  4.00           C 
ATOM    953  O   ALA    65      -2.710  15.315  -3.006  1.00 25.43           O 
ATOM    954  CB  ALA    65      -3.621  12.168  -2.671  1.00 45.01           C 
ATOM    955  H   ALA    65      -2.010  11.816  -0.697  1.00 38.87           H 
ATOM    956  HA  ALA    65      -1.765  12.969  -3.331  1.00  3.23           H 
ATOM    957 1HB  ALA    65      -3.345  11.142  -2.874  1.00 38.87           H 
ATOM    958 2HB  ALA    65      -4.161  12.568  -3.518  1.00 38.87           H 
ATOM    959 3HB  ALA    65      -4.251  12.202  -1.794  1.00 38.87           H 
END
