
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  207 ( 1574),  selected  207 , name 2hdo_A
# Molecule2: number of CA atoms   63 (  926),  selected   63 , name T0469.pdb
# PARAMETERS: 2hdo_A.T0469.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      Q       3           -
LGA    T     2_A      K       4           -
LGA    Y     3_A      F       5           -
LGA    Q     4_A      T       6           -
LGA    A     5_A      K       7           -
LGA    L     6_A      D       8           -
LGA    X     7_A      M       9           -
LGA    F     8_A      T      10           -
LGA    D     9_A      F      11           -
LGA    I    10_A      A      12           -
LGA    D    11_A      Q      13           #
LGA    G    12_A      A      14           #
LGA    T    13_A      -       -           -
LGA    L    14_A      -       -           -
LGA    T    15_A      -       -           -
LGA    N    16_A      -       -           -
LGA    S    17_A      -       -           -
LGA    Q    18_A      -       -           -
LGA    P    19_A      -       -           -
LGA    A    20_A      -       -           -
LGA    Y    21_A      L      15          0.892
LGA    T    22_A      Q      16           #
LGA    -       -      T      17           -
LGA    -       -      H      18           -
LGA    T    23_A      P      19          3.770
LGA    V    24_A      G      20          3.922
LGA    X    25_A      V      21          3.908
LGA    R    26_A      A      22          2.538
LGA    E    27_A      G      23          1.063
LGA    V    28_A      V      24          1.203
LGA    L    29_A      L      25          2.279
LGA    A    30_A      R      26          3.481
LGA    T    31_A      S      27          3.190
LGA    Y    32_A      Y      28          2.517
LGA    G    33_A      N      29          4.644
LGA    K    34_A      L      30          5.200
LGA    P    35_A      G      31          3.306
LGA    F    36_A      C      32          3.436
LGA    S    37_A      I      33          5.385
LGA    P    38_A      G      34          2.745
LGA    A    39_A      C      35          2.557
LGA    Q    40_A      M      36          3.881
LGA    A    41_A      -       -           -
LGA    Q    42_A      -       -           -
LGA    K    43_A      G      37          2.639
LGA    T    44_A      A      38          2.442
LGA    F    45_A      Q      39          2.974
LGA    P    46_A      N      40          2.791
LGA    X    47_A      E      41          2.438
LGA    A    48_A      S      42          2.675
LGA    A    49_A      L      43          2.325
LGA    E    50_A      E      44          1.567
LGA    Q    51_A      Q      45          1.137
LGA    A    52_A      G      46          2.371
LGA    X    53_A      A      47          1.416
LGA    T    54_A      N      48          2.048
LGA    E    55_A      A      49          2.931
LGA    L    56_A      -       -           -
LGA    G    57_A      H      50          0.149
LGA    I    58_A      G      51          3.625
LGA    A    59_A      L      52          2.341
LGA    A    60_A      N      53          3.507
LGA    S    61_A      -       -           -
LGA    E    62_A      -       -           -
LGA    F    63_A      V      54          2.112
LGA    D    64_A      E      55          0.734
LGA    H    65_A      D      56          1.070
LGA    F    66_A      I      57          0.576
LGA    Q    67_A      L      58          1.148
LGA    A    68_A      R      59          1.556
LGA    Q    69_A      D      60          1.420
LGA    Y    70_A      L      61          1.829
LGA    E    71_A      N      62          2.279
LGA    D    72_A      A      63          2.419
LGA    V    73_A      L      64          2.398
LGA    X    74_A      -       -           -
LGA    A    75_A      A      65          2.517
LGA    S    76_A      -       -           -
LGA    H    77_A      -       -           -
LGA    Y    78_A      -       -           -
LGA    D    79_A      -       -           -
LGA    Q    80_A      -       -           -
LGA    I    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    L    83_A      -       -           -
LGA    Y    84_A      -       -           -
LGA    P    85_A      -       -           -
LGA    G    86_A      -       -           -
LGA    I    87_A      -       -           -
LGA    T    88_A      -       -           -
LGA    S    89_A      -       -           -
LGA    L    90_A      -       -           -
LGA    F    91_A      -       -           -
LGA    E    92_A      -       -           -
LGA    Q    93_A      -       -           -
LGA    L    94_A      -       -           -
LGA    P    95_A      -       -           -
LGA    S    96_A      -       -           -
LGA    E    97_A      -       -           -
LGA    L    98_A      -       -           -
LGA    R    99_A      -       -           -
LGA    L   100_A      -       -           -
LGA    G   101_A      -       -           -
LGA    I   102_A      -       -           -
LGA    V   103_A      -       -           -
LGA    T   104_A      -       -           -
LGA    S   105_A      -       -           -
LGA    Q   106_A      -       -           -
LGA    R   107_A      -       -           -
LGA    R   108_A      -       -           -
LGA    N   109_A      -       -           -
LGA    E   110_A      -       -           -
LGA    L   111_A      -       -           -
LGA    E   112_A      -       -           -
LGA    S   113_A      -       -           -
LGA    G   114_A      -       -           -
LGA    X   115_A      -       -           -
LGA    R   116_A      -       -           -
LGA    S   117_A      -       -           -
LGA    Y   118_A      -       -           -
LGA    P   119_A      -       -           -
LGA    F   120_A      -       -           -
LGA    X   121_A      -       -           -
LGA    X   122_A      -       -           -
LGA    R   123_A      -       -           -
LGA    X   124_A      -       -           -
LGA    A   125_A      -       -           -
LGA    V   126_A      -       -           -
LGA    T   127_A      -       -           -
LGA    I   128_A      -       -           -
LGA    S   129_A      -       -           -
LGA    A   130_A      -       -           -
LGA    D   131_A      -       -           -
LGA    D   132_A      -       -           -
LGA    T   133_A      -       -           -
LGA    P   134_A      -       -           -
LGA    K   135_A      -       -           -
LGA    R   136_A      -       -           -
LGA    K   137_A      -       -           -
LGA    P   138_A      -       -           -
LGA    D   139_A      -       -           -
LGA    P   140_A      -       -           -
LGA    L   141_A      -       -           -
LGA    P   142_A      -       -           -
LGA    L   143_A      -       -           -
LGA    L   144_A      -       -           -
LGA    T   145_A      -       -           -
LGA    A   146_A      -       -           -
LGA    L   147_A      -       -           -
LGA    E   148_A      -       -           -
LGA    K   149_A      -       -           -
LGA    V   150_A      -       -           -
LGA    N   151_A      -       -           -
LGA    V   152_A      -       -           -
LGA    A   153_A      -       -           -
LGA    P   154_A      -       -           -
LGA    Q   155_A      -       -           -
LGA    N   156_A      -       -           -
LGA    A   157_A      -       -           -
LGA    L   158_A      -       -           -
LGA    F   159_A      -       -           -
LGA    I   160_A      -       -           -
LGA    G   161_A      -       -           -
LGA    D   162_A      -       -           -
LGA    S   163_A      -       -           -
LGA    V   164_A      -       -           -
LGA    S   165_A      -       -           -
LGA    D   166_A      -       -           -
LGA    E   167_A      -       -           -
LGA    Q   168_A      -       -           -
LGA    T   169_A      -       -           -
LGA    A   170_A      -       -           -
LGA    Q   171_A      -       -           -
LGA    A   172_A      -       -           -
LGA    A   173_A      -       -           -
LGA    N   174_A      -       -           -
LGA    V   175_A      -       -           -
LGA    D   176_A      -       -           -
LGA    F   177_A      -       -           -
LGA    G   178_A      -       -           -
LGA    L   179_A      -       -           -
LGA    A   180_A      -       -           -
LGA    V   181_A      -       -           -
LGA    W   182_A      -       -           -
LGA    G   183_A      -       -           -
LGA    X   184_A      -       -           -
LGA    D   185_A      -       -           -
LGA    P   186_A      -       -           -
LGA    N   187_A      -       -           -
LGA    A   188_A      -       -           -
LGA    D   189_A      -       -           -
LGA    H   190_A      -       -           -
LGA    Q   191_A      -       -           -
LGA    K   192_A      -       -           -
LGA    V   193_A      -       -           -
LGA    A   194_A      -       -           -
LGA    H   195_A      -       -           -
LGA    R   196_A      -       -           -
LGA    F   197_A      -       -           -
LGA    Q   198_A      -       -           -
LGA    K   199_A      -       -           -
LGA    P   200_A      -       -           -
LGA    L   201_A      -       -           -
LGA    D   202_A      -       -           -
LGA    I   203_A      -       -           -
LGA    L   204_A      -       -           -
LGA    E   205_A      -       -           -
LGA    L   206_A      -       -           -
LGA    F   207_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  207   63    5.0     48    2.74    12.50     53.518     1.691

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.098894 * X  +   0.051246 * Y  +  -0.993778 * Z  +   9.917632
  Y_new =   0.639956 * X  +  -0.768035 * Y  +   0.024079 * Z  +  -0.041381
  Z_new =  -0.762022 * X  +  -0.638355 * Y  +  -0.108749 * Z  +  22.478767 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.739535    1.402058  [ DEG:   -99.6680     80.3320 ]
  Theta =   0.866429    2.275163  [ DEG:    49.6427    130.3573 ]
  Phi   =   1.417477   -1.724116  [ DEG:    81.2154    -98.7846 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hdo_A                                        
REMARK     2: T0469.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hdo_A.T0469.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  207   63   5.0   48   2.74   12.50  53.518
REMARK  ---------------------------------------------------------- 
MOLECULE 2hdo_A
HEADER    HYDROLASE                               20-JUN-06   2HDO              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE PHOSPHOGLYCOLATE PHOSPHATASE            
TITLE    2 (NP_784602.1) FROM LACTOBACILLUS PLANTARUM AT 1.50 A                 
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHOGLYCOLATE PHOSPHATASE;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 3.1.3.18;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: LACTOBACILLUS PLANTARUM;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_784602.1, GPH1;                                             
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_784602.1, PUTATIVE PHOSPHOGLYCOLATE PHOSPHATASE,                   
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   15-AUG-06 2HDO    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE PHOSPHOGLYCOLATE               
JRNL        TITL 2 PHOSPHATASE (NP_784602.1) FROM LACTOBACILLUS                 
JRNL        TITL 3 PLANTARUM AT 1.50 A RESOLUTION                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2HDO A    1   208  UNP    Q88YA8   Q88YA8_LACPL     1    208             
SEQRES   1 A  209  GLY MSE THR TYR GLN ALA LEU MSE PHE ASP ILE ASP GLY          
SEQRES   2 A  209  THR LEU THR ASN SER GLN PRO ALA TYR THR THR VAL MSE          
SEQRES   3 A  209  ARG GLU VAL LEU ALA THR TYR GLY LYS PRO PHE SER PRO          
SEQRES   4 A  209  ALA GLN ALA GLN LYS THR PHE PRO MSE ALA ALA GLU GLN          
SEQRES   5 A  209  ALA MSE THR GLU LEU GLY ILE ALA ALA SER GLU PHE ASP          
SEQRES   6 A  209  HIS PHE GLN ALA GLN TYR GLU ASP VAL MSE ALA SER HIS          
SEQRES   7 A  209  TYR ASP GLN ILE GLU LEU TYR PRO GLY ILE THR SER LEU          
SEQRES   8 A  209  PHE GLU GLN LEU PRO SER GLU LEU ARG LEU GLY ILE VAL          
SEQRES   9 A  209  THR SER GLN ARG ARG ASN GLU LEU GLU SER GLY MSE ARG          
SEQRES  10 A  209  SER TYR PRO PHE MSE MSE ARG MSE ALA VAL THR ILE SER          
SEQRES  11 A  209  ALA ASP ASP THR PRO LYS ARG LYS PRO ASP PRO LEU PRO          
SEQRES  12 A  209  LEU LEU THR ALA LEU GLU LYS VAL ASN VAL ALA PRO GLN          
SEQRES  13 A  209  ASN ALA LEU PHE ILE GLY ASP SER VAL SER ASP GLU GLN          
SEQRES  14 A  209  THR ALA GLN ALA ALA ASN VAL ASP PHE GLY LEU ALA VAL          
SEQRES  15 A  209  TRP GLY MSE ASP PRO ASN ALA ASP HIS GLN LYS VAL ALA          
SEQRES  16 A  209  HIS ARG PHE GLN LYS PRO LEU ASP ILE LEU GLU LEU PHE          
SEQRES  17 A  209  LYS                                                          
HET    MSE  A   1       5                                                       
HET    MSE  A   7       8                                                       
HET    MSE  A  25       8                                                       
HET    MSE  A  47       8                                                       
HET    MSE  A  53       8                                                       
HET    MSE  A  74       8                                                       
HET    MSE  A 115       8                                                       
HET    MSE  A 121       8                                                       
HET    MSE  A 122      16                                                       
HET    MSE  A 124       8                                                       
HET    MSE  A 184       8                                                       
HET    PO4      1       5                                                       
HET    PO4      2       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     PO4 PHOSPHATE ION                                                    
FORMUL   1  MSE    11(C5 H11 N O2 SE)                                           
FORMUL   2  PO4    2(O4 P 3-)                                                   
FORMUL   4  HOH   *212(H2 O)                                                    
CRYST1   86.890   86.890   47.190  90.00  90.00 120.00 P 61          6          
HETATM    1  N   MSE A   1     -23.772 -10.002 -33.177  1.00 28.49           N  
HETATM    2  CA  MSE A   1     -24.138  -9.058 -32.070  1.00 29.67           C  
HETATM    3  C   MSE A   1     -22.963  -8.848 -31.117  1.00 30.18           C  
HETATM    4  O   MSE A   1     -22.322  -9.815 -30.700  1.00 34.08           O  
HETATM    5  CB  MSE A   1     -25.353  -9.574 -31.286  1.00 30.86           C  
ATOM      6  N   THR A   2     -22.702  -7.592 -30.753  1.00 30.55           N  
ATOM      7  CA  THR A   2     -21.602  -7.254 -29.828  1.00 28.03           C  
ATOM      8  C   THR A   2     -22.107  -6.432 -28.614  1.00 27.17           C  
ATOM      9  O   THR A   2     -23.301  -6.331 -28.366  1.00 31.01           O  
ATOM     10  CB  THR A   2     -20.478  -6.531 -30.588  1.00 30.45           C  
ATOM     11  OG1 THR A   2     -19.288  -6.442 -29.775  1.00 29.86           O  
ATOM     12  CG2 THR A   2     -20.939  -5.126 -31.054  1.00 32.10           C  
ATOM     13  N   TYR A   3     -21.198  -5.830 -27.872  1.00 20.79           N  
ATOM     14  CA  TYR A   3     -21.546  -5.228 -26.585  1.00 16.69           C  
ATOM     15  C   TYR A   3     -22.131  -3.812 -26.713  1.00 15.18           C  
ATOM     16  O   TYR A   3     -21.777  -3.062 -27.630  1.00 15.79           O  
ATOM     17  CB  TYR A   3     -20.301  -5.186 -25.722  1.00 15.85           C  
ATOM     18  CG  TYR A   3     -19.725  -6.563 -25.458  1.00 11.90           C  
ATOM     19  CD1 TYR A   3     -20.314  -7.399 -24.516  1.00 14.90           C  
ATOM     20  CD2 TYR A   3     -18.621  -7.040 -26.161  1.00 14.79           C  
ATOM     21  CE1 TYR A   3     -19.795  -8.664 -24.257  1.00 15.78           C  
ATOM     22  CE2 TYR A   3     -18.127  -8.313 -25.933  1.00 15.33           C  
ATOM     23  CZ  TYR A   3     -18.718  -9.128 -24.996  1.00 12.72           C  
ATOM     24  OH  TYR A   3     -18.210 -10.379 -24.719  1.00 15.99           O  
ATOM     25  N   GLN A   4     -23.015  -3.471 -25.762  1.00 12.52           N  
ATOM     26  CA  GLN A   4     -23.562  -2.125 -25.615  1.00 13.51           C  
ATOM     27  C   GLN A   4     -22.745  -1.242 -24.664  1.00 13.28           C  
ATOM     28  O   GLN A   4     -22.830  -0.011 -24.734  1.00 12.96           O  
ATOM     29  CB  GLN A   4     -24.969  -2.162 -25.090  1.00 14.06           C  
ATOM     30  CG  GLN A   4     -25.955  -2.721 -26.069  1.00 17.17           C  
ATOM     31  CD  GLN A   4     -27.311  -3.022 -25.432  1.00 26.94           C  
ATOM     32  OE1 GLN A   4     -27.718  -2.349 -24.489  1.00 32.04           O  
ATOM     33  NE2 GLN A   4     -28.006  -4.040 -25.945  1.00 31.16           N  
ATOM     34  N   ALA A   5     -21.993  -1.875 -23.764  1.00 14.39           N  
ATOM     35  CA  ALA A   5     -21.190  -1.144 -22.814  1.00 12.63           C  
ATOM     36  C   ALA A   5     -19.847  -1.803 -22.611  1.00 12.82           C  
ATOM     37  O   ALA A   5     -19.736  -3.043 -22.615  1.00 12.29           O  
ATOM     38  CB  ALA A   5     -21.914  -1.014 -21.458  1.00 14.33           C  
ATOM     39  N   LEU A   6     -18.849  -0.953 -22.399  1.00 11.25           N  
ATOM     40  CA  LEU A   6     -17.515  -1.353 -21.988  1.00 10.73           C  
ATOM     41  C   LEU A   6     -17.179  -0.640 -20.706  1.00 13.22           C  
ATOM     42  O   LEU A   6     -17.227   0.580 -20.661  1.00 13.84           O  
ATOM     43  CB  LEU A   6     -16.473  -0.989 -23.023  1.00 12.11           C  
ATOM     44  CG  LEU A   6     -16.603  -1.562 -24.405  1.00 15.35           C  
ATOM     45  CD1 LEU A   6     -15.368  -1.113 -25.217  1.00 16.39           C  
ATOM     46  CD2 LEU A   6     -16.751  -3.047 -24.429  1.00 16.59           C  
HETATM   47  N   MSE A   7     -16.904  -1.419 -19.659  1.00 12.18           N  
HETATM   48  CA  MSE A   7     -16.422  -0.870 -18.391  1.00 10.36           C  
HETATM   49  C   MSE A   7     -14.981  -1.215 -18.228  1.00 11.83           C  
HETATM   50  O   MSE A   7     -14.583  -2.313 -18.578  1.00 14.30           O  
HETATM   51  CB  MSE A   7     -17.215  -1.451 -17.224  1.00 13.46           C  
HETATM   52  CG  MSE A   7     -18.674  -1.203 -17.343  1.00 14.14           C  
HETATM   53 SE   MSE A   7     -19.139   0.670 -16.982  0.75 24.52          SE  
HETATM   54  CE  MSE A   7     -20.160   1.127 -18.668  1.00 14.19           C  
ATOM     55  N   PHE A   8     -14.201  -0.287 -17.702  1.00 12.23           N  
ATOM     56  CA  PHE A   8     -12.776  -0.435 -17.582  1.00 10.18           C  
ATOM     57  C   PHE A   8     -12.343  -0.264 -16.122  1.00 13.00           C  
ATOM     58  O   PHE A   8     -12.814   0.619 -15.436  1.00 12.17           O  
ATOM     59  CB  PHE A   8     -12.011   0.648 -18.369  1.00 12.75           C  
ATOM     60  CG  PHE A   8     -12.213   0.594 -19.857  1.00 14.91           C  
ATOM     61  CD1 PHE A   8     -13.322   1.206 -20.411  1.00 15.69           C  
ATOM     62  CD2 PHE A   8     -11.314  -0.059 -20.694  1.00 17.31           C  
ATOM     63  CE1 PHE A   8     -13.557   1.155 -21.769  1.00 16.92           C  
ATOM     64  CE2 PHE A   8     -11.536  -0.081 -22.073  1.00 16.29           C  
ATOM     65  CZ  PHE A   8     -12.667   0.504 -22.598  1.00 13.41           C  
ATOM     66  N   ASP A   9     -11.425  -1.112 -15.693  1.00 14.02           N  
ATOM     67  CA  ASP A   9     -10.550  -0.803 -14.524  1.00 16.88           C  
ATOM     68  C   ASP A   9      -9.485   0.216 -14.919  1.00 17.09           C  
ATOM     69  O   ASP A   9      -9.230   0.401 -16.099  1.00 17.40           O  
ATOM     70  CB  ASP A   9      -9.849  -2.086 -14.074  1.00 20.77           C  
ATOM     71  CG  ASP A   9      -9.481  -2.066 -12.629  1.00 30.08           C  
ATOM     72  OD1 ASP A   9      -9.764  -1.061 -11.927  1.00 28.52           O  
ATOM     73  OD2 ASP A   9      -8.877  -3.065 -12.202  1.00 31.54           O  
ATOM     74  N   ILE A  10      -8.840   0.883 -13.955  1.00 16.60           N  
ATOM     75  CA  ILE A  10      -7.839   1.870 -14.286  1.00 15.07           C  
ATOM     76  C   ILE A  10      -6.439   1.275 -14.174  1.00 15.04           C  
ATOM     77  O   ILE A  10      -5.705   1.173 -15.156  1.00 15.95           O  
ATOM     78  CB  ILE A  10      -7.957   3.128 -13.401  1.00 15.21           C  
ATOM     79  CG1 ILE A  10      -9.294   3.810 -13.676  1.00 15.88           C  
ATOM     80  CG2 ILE A  10      -6.824   4.091 -13.722  1.00 17.44           C  
ATOM     81  CD1 ILE A  10      -9.714   4.852 -12.648  1.00 20.12           C  
ATOM     82  N   ASP A  11      -6.092   0.853 -12.977  1.00 13.51           N  
ATOM     83  CA  ASP A  11      -4.701   0.478 -12.696  1.00 16.74           C  
ATOM     84  C   ASP A  11      -4.324  -0.813 -13.373  1.00 17.79           C  
ATOM     85  O   ASP A  11      -4.978  -1.828 -13.157  1.00 19.02           O  
ATOM     86  CB  ASP A  11      -4.483   0.361 -11.185  1.00 17.27           C  
ATOM     87  CG  ASP A  11      -4.661   1.669 -10.469  1.00 25.05           C  
ATOM     88  OD1 ASP A  11      -3.787   2.564 -10.648  1.00 21.68           O  
ATOM     89  OD2 ASP A  11      -5.672   1.800  -9.712  1.00 24.63           O  
ATOM     90  N   GLY A  12      -3.258  -0.800 -14.179  1.00 15.50           N  
ATOM     91  CA  GLY A  12      -2.870  -1.998 -14.932  1.00 16.91           C  
ATOM     92  C   GLY A  12      -3.641  -2.265 -16.201  1.00 15.61           C  
ATOM     93  O   GLY A  12      -3.437  -3.287 -16.867  1.00 17.68           O  
ATOM     94  N   THR A  13      -4.536  -1.345 -16.558  1.00 13.88           N  
ATOM     95  CA  THR A  13      -5.396  -1.500 -17.734  1.00 13.70           C  
ATOM     96  C   THR A  13      -5.314  -0.221 -18.577  1.00 13.22           C  
ATOM     97  O   THR A  13      -4.832  -0.241 -19.693  1.00 14.80           O  
ATOM     98  CB  THR A  13      -6.870  -1.769 -17.343  1.00 16.49           C  
ATOM     99  OG1 THR A  13      -6.930  -3.010 -16.615  1.00 20.86           O  
ATOM    100  CG2 THR A  13      -7.761  -1.903 -18.584  1.00 14.52           C  
ATOM    101  N   LEU A  14      -5.752   0.904 -18.033  1.00 12.47           N  
ATOM    102  CA  LEU A  14      -5.630   2.205 -18.687  1.00 12.30           C  
ATOM    103  C   LEU A  14      -4.287   2.829 -18.364  1.00 11.71           C  
ATOM    104  O   LEU A  14      -3.625   3.385 -19.250  1.00 13.14           O  
ATOM    105  CB  LEU A  14      -6.766   3.142 -18.246  1.00 12.48           C  
ATOM    106  CG  LEU A  14      -8.188   2.667 -18.538  1.00 15.52           C  
ATOM    107  CD1 LEU A  14      -9.141   3.754 -18.059  1.00 17.51           C  
ATOM    108  CD2 LEU A  14      -8.389   2.365 -20.019  1.00 18.04           C  
ATOM    109  N   THR A  15      -3.920   2.787 -17.089  1.00 12.78           N  
ATOM    110  CA  THR A  15      -2.674   3.376 -16.639  1.00 12.93           C  
ATOM    111  C   THR A  15      -1.656   2.355 -16.235  1.00 13.57           C  
ATOM    112  O   THR A  15      -1.976   1.302 -15.628  1.00 13.25           O  
ATOM    113  CB  THR A  15      -2.837   4.326 -15.453  1.00 16.38           C  
ATOM    114  OG1 THR A  15      -3.482   3.644 -14.370  1.00 16.03           O  
ATOM    115  CG2 THR A  15      -3.637   5.572 -15.873  1.00 17.79           C  
ATOM    116  N   ASN A  16      -0.426   2.710 -16.561  1.00 13.39           N  
ATOM    117  CA  ASN A  16       0.742   1.945 -16.170  1.00 13.46           C  
ATOM    118  C   ASN A  16       1.220   2.447 -14.817  1.00 13.92           C  
ATOM    119  O   ASN A  16       2.236   3.131 -14.722  1.00 14.65           O  
ATOM    120  CB  ASN A  16       1.875   1.980 -17.214  1.00 15.07           C  
ATOM    121  CG  ASN A  16       3.000   1.037 -16.877  1.00 20.36           C  
ATOM    122  OD1 ASN A  16       2.898   0.172 -16.010  1.00 17.58           O  
ATOM    123  ND2 ASN A  16       4.110   1.225 -17.556  1.00 25.67           N  
ATOM    124  N   SER A  17       0.466   2.072 -13.795  1.00 13.23           N  
ATOM    125  CA  SER A  17       0.664   2.612 -12.439  1.00 13.05           C  
ATOM    126  C   SER A  17       1.527   1.788 -11.465  1.00 11.99           C  
ATOM    127  O   SER A  17       1.789   2.258 -10.362  1.00 12.24           O  
ATOM    128  CB  SER A  17      -0.722   2.924 -11.841  1.00 14.00           C  
ATOM    129  OG  SER A  17      -1.587   1.792 -11.796  1.00 17.25           O  
ATOM    130  N   GLN A  18       1.965   0.597 -11.844  1.00 12.00           N  
ATOM    131  CA  GLN A  18       2.717  -0.234 -10.947  1.00 13.51           C  
ATOM    132  C   GLN A  18       3.994   0.450 -10.512  1.00 12.56           C  
ATOM    133  O   GLN A  18       4.387   0.321  -9.350  1.00 13.91           O  
ATOM    134  CB  GLN A  18       3.059  -1.594 -11.554  1.00 13.54           C  
ATOM    135  CG  GLN A  18       3.617  -2.553 -10.530  1.00 19.04           C  
ATOM    136  CD  GLN A  18       3.685  -3.971 -11.028  1.00 22.89           C  
ATOM    137  OE1 GLN A  18       2.826  -4.416 -11.788  1.00 24.98           O  
ATOM    138  NE2 GLN A  18       4.723  -4.690 -10.612  1.00 27.49           N  
ATOM    139  N   PRO A  19       4.717   1.110 -11.424  1.00 13.27           N  
ATOM    140  CA  PRO A  19       5.910   1.810 -10.909  1.00 14.59           C  
ATOM    141  C   PRO A  19       5.637   2.819  -9.779  1.00 13.55           C  
ATOM    142  O   PRO A  19       6.315   2.787  -8.749  1.00 13.76           O  
ATOM    143  CB  PRO A  19       6.476   2.480 -12.145  1.00 16.62           C  
ATOM    144  CG  PRO A  19       6.049   1.596 -13.274  1.00 15.66           C  
ATOM    145  CD  PRO A  19       4.634   1.172 -12.889  1.00 13.96           C  
ATOM    146  N   ALA A  20       4.665   3.705  -9.964  1.00 14.46           N  
ATOM    147  CA  ALA A  20       4.293   4.689  -8.912  1.00 12.51           C  
ATOM    148  C   ALA A  20       3.804   3.984  -7.647  1.00 14.64           C  
ATOM    149  O   ALA A  20       4.215   4.333  -6.532  1.00 16.00           O  
ATOM    150  CB  ALA A  20       3.268   5.687  -9.413  1.00 13.44           C  
ATOM    151  N   TYR A  21       2.980   2.945  -7.821  1.00 13.93           N  
ATOM    152  CA  TYR A  21       2.523   2.132  -6.694  1.00 14.59           C  
ATOM    153  C   TYR A  21       3.684   1.611  -5.875  1.00 14.16           C  
ATOM    154  O   TYR A  21       3.648   1.612  -4.638  1.00 15.26           O  
ATOM    155  CB  TYR A  21       1.708   0.955  -7.233  1.00 13.04           C  
ATOM    156  CG  TYR A  21       1.408  -0.138  -6.224  1.00 16.38           C  
ATOM    157  CD1 TYR A  21       0.298  -0.048  -5.408  1.00 13.71           C  
ATOM    158  CD2 TYR A  21       2.212  -1.279  -6.124  1.00 16.72           C  
ATOM    159  CE1 TYR A  21      -0.000  -1.031  -4.506  1.00 15.14           C  
ATOM    160  CE2 TYR A  21       1.935  -2.278  -5.194  1.00 14.46           C  
ATOM    161  CZ  TYR A  21       0.826  -2.146  -4.400  1.00 13.62           C  
ATOM    162  OH  TYR A  21       0.522  -3.119  -3.494  1.00 15.60           O  
ATOM    163  N   THR A  22       4.688   1.131  -6.582  1.00 10.25           N  
ATOM    164  CA  THR A  22       5.838   0.546  -5.936  1.00 14.05           C  
ATOM    165  C   THR A  22       6.522   1.576  -5.044  1.00 11.05           C  
ATOM    166  O   THR A  22       6.819   1.307  -3.895  1.00 13.65           O  
ATOM    167  CB  THR A  22       6.809  -0.097  -6.948  1.00 14.96           C  
ATOM    168  OG1 THR A  22       6.110  -1.134  -7.662  1.00 15.05           O  
ATOM    169  CG2 THR A  22       8.027  -0.669  -6.198  1.00 13.36           C  
ATOM    170  N   THR A  23       6.802   2.750  -5.607  1.00 13.12           N  
ATOM    171  CA  THR A  23       7.469   3.845  -4.889  1.00 14.25           C  
ATOM    172  C   THR A  23       6.642   4.252  -3.647  1.00 10.43           C  
ATOM    173  O   THR A  23       7.141   4.416  -2.561  1.00 15.14           O  
ATOM    174  CB  THR A  23       7.615   5.057  -5.848  1.00 16.25           C  
ATOM    175  OG1 THR A  23       8.478   4.698  -6.941  1.00 20.27           O  
ATOM    176  CG2 THR A  23       8.178   6.296  -5.167  1.00 19.82           C  
ATOM    177  N   VAL A  24       5.345   4.364  -3.824  1.00 11.55           N  
ATOM    178  CA  VAL A  24       4.483   4.867  -2.777  1.00 12.75           C  
ATOM    179  C   VAL A  24       4.391   3.815  -1.680  1.00 13.40           C  
ATOM    180  O   VAL A  24       4.556   4.118  -0.515  1.00 12.23           O  
ATOM    181  CB  VAL A  24       3.088   5.194  -3.313  1.00 15.52           C  
ATOM    182  CG1 VAL A  24       2.145   5.497  -2.135  1.00 16.83           C  
ATOM    183  CG2 VAL A  24       3.135   6.364  -4.327  1.00 14.75           C  
HETATM  184  N   MSE A  25       4.106   2.573  -2.062  1.00 12.64           N  
HETATM  185  CA  MSE A  25       4.030   1.498  -1.040  1.00 14.38           C  
HETATM  186  C   MSE A  25       5.309   1.353  -0.219  1.00 12.71           C  
HETATM  187  O   MSE A  25       5.282   1.114   1.011  1.00 12.92           O  
HETATM  188  CB  MSE A  25       3.706   0.169  -1.699  1.00 13.11           C  
HETATM  189  CG  MSE A  25       2.348   0.085  -2.241  1.00 17.36           C  
HETATM  190 SE   MSE A  25       0.988  -0.057  -0.835  0.75 23.64          SE  
HETATM  191  CE  MSE A  25       1.320  -1.932  -0.203  1.00 13.33           C  
ATOM    192  N   ARG A  26       6.438   1.477  -0.881  1.00 11.98           N  
ATOM    193  CA  ARG A  26       7.736   1.319  -0.191  1.00 11.56           C  
ATOM    194  C   ARG A  26       7.846   2.411   0.864  1.00 12.82           C  
ATOM    195  O   ARG A  26       8.336   2.185   1.989  1.00 17.67           O  
ATOM    196  CB  ARG A  26       8.897   1.360  -1.190  1.00 12.62           C  
ATOM    197  CG  ARG A  26      10.247   1.104  -0.538  1.00 14.16           C  
ATOM    198  CD  ARG A  26      11.364   0.953  -1.574  1.00 15.65           C  
ATOM    199  NE  ARG A  26      11.194  -0.285  -2.345  1.00 21.66           N  
ATOM    200  CZ  ARG A  26      11.065  -0.365  -3.674  1.00 19.99           C  
ATOM    201  NH1 ARG A  26      11.140   0.703  -4.452  1.00 18.49           N  
ATOM    202  NH2 ARG A  26      10.893  -1.550  -4.240  1.00 22.20           N  
ATOM    203  N   GLU A  27       7.413   3.612   0.498  1.00 13.36           N  
ATOM    204  CA  GLU A  27       7.489   4.759   1.386  1.00 14.61           C  
ATOM    205  C   GLU A  27       6.563   4.575   2.607  1.00 13.89           C  
ATOM    206  O   GLU A  27       6.982   4.766   3.730  1.00 15.42           O  
ATOM    207  CB  GLU A  27       7.191   6.030   0.568  1.00 13.51           C  
ATOM    208  CG  GLU A  27       7.333   7.316   1.330  1.00 15.43           C  
ATOM    209  CD  GLU A  27       7.032   8.529   0.455  1.00 19.84           C  
ATOM    210  OE1 GLU A  27       7.145   8.393  -0.805  1.00 24.40           O  
ATOM    211  OE2 GLU A  27       6.632   9.590   1.002  1.00 20.13           O  
ATOM    212  N   VAL A  28       5.316   4.174   2.376  1.00 11.90           N  
ATOM    213  CA  VAL A  28       4.401   3.844   3.483  1.00 11.31           C  
ATOM    214  C   VAL A  28       4.938   2.718   4.349  1.00 14.27           C  
ATOM    215  O   VAL A  28       4.932   2.796   5.577  1.00 13.09           O  
ATOM    216  CB  VAL A  28       2.949   3.552   2.989  1.00 14.86           C  
ATOM    217  CG1 VAL A  28       2.022   3.259   4.169  1.00 16.74           C  
ATOM    218  CG2 VAL A  28       2.458   4.731   2.185  1.00 17.54           C  
ATOM    219  N   LEU A  29       5.392   1.646   3.711  1.00 11.63           N  
ATOM    220  CA  LEU A  29       5.847   0.483   4.455  1.00 14.67           C  
ATOM    221  C   LEU A  29       7.012   0.774   5.369  1.00 13.96           C  
ATOM    222  O   LEU A  29       7.142   0.168   6.421  1.00 13.55           O  
ATOM    223  CB  LEU A  29       6.178  -0.676   3.492  1.00 12.92           C  
ATOM    224  CG  LEU A  29       4.914  -1.374   3.022  1.00 12.69           C  
ATOM    225  CD1 LEU A  29       5.155  -2.044   1.710  1.00 14.24           C  
ATOM    226  CD2 LEU A  29       4.450  -2.381   4.028  1.00 13.67           C  
ATOM    227  N   ALA A  30       7.860   1.723   5.000  1.00 14.31           N  
ATOM    228  CA  ALA A  30       8.966   2.120   5.860  1.00 15.49           C  
ATOM    229  C   ALA A  30       8.475   2.589   7.245  1.00 15.27           C  
ATOM    230  O   ALA A  30       9.135   2.341   8.242  1.00 16.72           O  
ATOM    231  CB  ALA A  30       9.775   3.206   5.171  1.00 18.56           C  
ATOM    232  N   THR A  31       7.292   3.206   7.317  1.00 14.78           N  
ATOM    233  CA  THR A  31       6.748   3.691   8.612  1.00 13.91           C  
ATOM    234  C   THR A  31       6.162   2.554   9.496  1.00 13.31           C  
ATOM    235  O   THR A  31       5.744   2.792  10.639  1.00 14.23           O  
ATOM    236  CB  THR A  31       5.660   4.760   8.420  1.00 12.03           C  
ATOM    237  OG1 THR A  31       4.470   4.181   7.899  1.00 14.75           O  
ATOM    238  CG2 THR A  31       6.129   5.875   7.464  1.00 12.80           C  
ATOM    239  N   TYR A  32       6.114   1.349   8.940  1.00 13.18           N  
ATOM    240  CA  TYR A  32       5.706   0.111   9.625  1.00 15.20           C  
ATOM    241  C   TYR A  32       6.910  -0.813   9.747  1.00 15.61           C  
ATOM    242  O   TYR A  32       6.758  -1.983  10.063  1.00 18.83           O  
ATOM    243  CB  TYR A  32       4.568  -0.570   8.842  1.00 14.00           C  
ATOM    244  CG  TYR A  32       3.322   0.255   8.879  1.00 17.65           C  
ATOM    245  CD1 TYR A  32       3.089   1.239   7.939  1.00 16.67           C  
ATOM    246  CD2 TYR A  32       2.396   0.104   9.894  1.00 17.12           C  
ATOM    247  CE1 TYR A  32       1.960   2.041   8.021  1.00 16.44           C  
ATOM    248  CE2 TYR A  32       1.260   0.885   9.957  1.00 18.15           C  
ATOM    249  CZ  TYR A  32       1.046   1.858   9.023  1.00 17.35           C  
ATOM    250  OH  TYR A  32      -0.081   2.634   9.128  1.00 18.21           O  
ATOM    251  N   GLY A  33       8.104  -0.300   9.476  1.00 16.52           N  
ATOM    252  CA  GLY A  33       9.330  -1.040   9.655  1.00 18.79           C  
ATOM    253  C   GLY A  33       9.518  -2.181   8.692  1.00 20.26           C  
ATOM    254  O   GLY A  33      10.147  -3.173   9.031  1.00 24.50           O  
ATOM    255  N   LYS A  34       8.984  -2.033   7.479  1.00 17.08           N  
ATOM    256  CA  LYS A  34       9.008  -3.114   6.499  1.00 18.13           C  
ATOM    257  C   LYS A  34       9.608  -2.637   5.185  1.00 17.99           C  
ATOM    258  O   LYS A  34       9.363  -1.521   4.775  1.00 17.14           O  
ATOM    259  CB  LYS A  34       7.605  -3.632   6.266  1.00 17.20           C  
ATOM    260  CG  LYS A  34       7.018  -4.365   7.461  1.00 20.52           C  
ATOM    261  CD  LYS A  34       5.591  -4.873   7.177  1.00 21.43           C  
ATOM    262  CE  LYS A  34       4.983  -5.638   8.346  1.00 22.02           C  
ATOM    263  NZ  LYS A  34       5.617  -6.951   8.536  1.00 30.76           N  
ATOM    264  N   PRO A  35      10.393  -3.501   4.519  1.00 19.04           N  
ATOM    265  CA  PRO A  35      10.860  -3.211   3.172  1.00 20.18           C  
ATOM    266  C   PRO A  35       9.756  -3.569   2.181  1.00 20.47           C  
ATOM    267  O   PRO A  35       8.701  -4.010   2.588  1.00 20.11           O  
ATOM    268  CB  PRO A  35      12.052  -4.146   3.006  1.00 21.17           C  
ATOM    269  CG  PRO A  35      11.718  -5.318   3.835  1.00 21.20           C  
ATOM    270  CD  PRO A  35      10.874  -4.815   4.987  1.00 21.43           C  
ATOM    271  N   PHE A  36      10.016  -3.374   0.899  1.00 17.28           N  
ATOM    272  CA  PHE A  36       9.075  -3.717  -0.154  1.00 16.97           C  
ATOM    273  C   PHE A  36       9.890  -4.118  -1.371  1.00 21.57           C  
ATOM    274  O   PHE A  36      10.405  -3.259  -2.077  1.00 19.01           O  
ATOM    275  CB  PHE A  36       8.195  -2.520  -0.477  1.00 15.60           C  
ATOM    276  CG  PHE A  36       6.965  -2.847  -1.243  1.00 11.81           C  
ATOM    277  CD1 PHE A  36       6.136  -3.893  -0.855  1.00 14.02           C  
ATOM    278  CD2 PHE A  36       6.600  -2.093  -2.343  1.00 13.19           C  
ATOM    279  CE1 PHE A  36       4.948  -4.135  -1.546  1.00 11.35           C  
ATOM    280  CE2 PHE A  36       5.426  -2.349  -3.032  1.00 13.91           C  
ATOM    281  CZ  PHE A  36       4.607  -3.377  -2.629  1.00 15.57           C  
ATOM    282  N   SER A  37      10.031  -5.426  -1.581  1.00 22.19           N  
ATOM    283  CA  SER A  37      10.754  -5.944  -2.723  1.00 21.07           C  
ATOM    284  C   SER A  37       9.942  -5.821  -4.016  1.00 22.05           C  
ATOM    285  O   SER A  37       8.704  -5.718  -4.003  1.00 23.73           O  
ATOM    286  CB  SER A  37      11.095  -7.421  -2.487  1.00 22.47           C  
ATOM    287  OG  SER A  37       9.911  -8.225  -2.461  1.00 21.47           O  
ATOM    288  N   PRO A  38      10.634  -5.833  -5.151  1.00 22.55           N  
ATOM    289  CA  PRO A  38      10.015  -5.936  -6.464  1.00 21.91           C  
ATOM    290  C   PRO A  38       9.024  -7.101  -6.590  1.00 21.40           C  
ATOM    291  O   PRO A  38       7.919  -6.914  -7.129  1.00 19.45           O  
ATOM    292  CB  PRO A  38      11.209  -6.154  -7.388  1.00 22.37           C  
ATOM    293  CG  PRO A  38      12.344  -5.596  -6.667  1.00 23.95           C  
ATOM    294  CD  PRO A  38      12.102  -5.719  -5.237  1.00 23.42           C  
ATOM    295  N   ALA A  39       9.401  -8.270  -6.083  1.00 22.88           N  
ATOM    296  CA  ALA A  39       8.500  -9.428  -6.033  1.00 20.95           C  
ATOM    297  C   ALA A  39       7.222  -9.106  -5.281  1.00 20.48           C  
ATOM    298  O   ALA A  39       6.124  -9.448  -5.738  1.00 18.87           O  
ATOM    299  CB  ALA A  39       9.204 -10.624  -5.376  1.00 23.21           C  
ATOM    300  N   GLN A  40       7.362  -8.448  -4.138  1.00 18.40           N  
ATOM    301  CA  GLN A  40       6.204  -8.085  -3.330  1.00 15.76           C  
ATOM    302  C   GLN A  40       5.325  -7.054  -4.024  1.00 16.52           C  
ATOM    303  O   GLN A  40       4.112  -7.112  -3.928  1.00 16.76           O  
ATOM    304  CB  GLN A  40       6.598  -7.572  -1.952  1.00 17.65           C  
ATOM    305  CG  GLN A  40       6.819  -8.710  -0.920  1.00 23.21           C  
ATOM    306  CD  GLN A  40       5.523  -9.468  -0.565  1.00 29.54           C  
ATOM    307  OE1 GLN A  40       4.476  -8.869  -0.412  1.00 35.12           O  
ATOM    308  NE2 GLN A  40       5.613 -10.791  -0.425  1.00 34.22           N  
ATOM    309  N   ALA A  41       5.942  -6.132  -4.743  1.00 17.99           N  
ATOM    310  CA  ALA A  41       5.219  -5.130  -5.522  1.00 16.22           C  
ATOM    311  C   ALA A  41       4.409  -5.778  -6.641  1.00 17.18           C  
ATOM    312  O   ALA A  41       3.214  -5.476  -6.814  1.00 18.03           O  
ATOM    313  CB  ALA A  41       6.216  -4.073  -6.062  1.00 15.65           C  
ATOM    314  N   GLN A  42       5.036  -6.719  -7.352  1.00 17.50           N  
ATOM    315  CA  GLN A  42       4.342  -7.461  -8.411  1.00 20.28           C  
ATOM    316  C   GLN A  42       3.170  -8.271  -7.868  1.00 18.26           C  
ATOM    317  O   GLN A  42       2.084  -8.299  -8.467  1.00 18.04           O  
ATOM    318  CB  GLN A  42       5.329  -8.380  -9.160  1.00 20.55           C  
ATOM    319  CG  GLN A  42       4.689  -9.416 -10.108  1.00 29.93           C  
ATOM    320  CD  GLN A  42       5.588  -9.781 -11.301  1.00 28.91           C  
ATOM    321  N   LYS A  43       3.388  -8.927  -6.744  1.00 18.03           N  
ATOM    322  CA  LYS A  43       2.362  -9.755  -6.109  1.00 17.68           C  
ATOM    323  C   LYS A  43       1.181  -8.939  -5.625  1.00 16.90           C  
ATOM    324  O   LYS A  43       0.019  -9.332  -5.839  1.00 16.40           O  
ATOM    325  CB  LYS A  43       2.969 -10.512  -4.933  1.00 17.44           C  
ATOM    326  CG  LYS A  43       2.011 -11.286  -4.100  1.00 25.96           C  
ATOM    327  CD  LYS A  43       2.741 -12.234  -3.122  1.00 22.58           C  
ATOM    328  N   THR A  44       1.445  -7.803  -4.970  1.00 14.25           N  
ATOM    329  CA  THR A  44       0.370  -7.062  -4.283  1.00 12.79           C  
ATOM    330  C   THR A  44      -0.353  -6.034  -5.159  1.00 13.52           C  
ATOM    331  O   THR A  44      -1.496  -5.660  -4.864  1.00 13.85           O  
ATOM    332  CB  THR A  44       0.855  -6.377  -2.984  1.00 14.65           C  
ATOM    333  OG1 THR A  44       1.890  -5.441  -3.303  1.00 12.94           O  
ATOM    334  CG2 THR A  44       1.405  -7.413  -2.033  1.00 12.42           C  
ATOM    335  N   PHE A  45       0.257  -5.607  -6.250  1.00 14.48           N  
ATOM    336  CA  PHE A  45      -0.329  -4.571  -7.076  1.00 13.48           C  
ATOM    337  C   PHE A  45      -1.774  -4.821  -7.500  1.00 13.42           C  
ATOM    338  O   PHE A  45      -2.596  -3.934  -7.408  1.00 16.43           O  
ATOM    339  CB  PHE A  45       0.538  -4.302  -8.318  1.00 13.19           C  
ATOM    340  CG  PHE A  45      -0.098  -3.344  -9.322  1.00 13.46           C  
ATOM    341  CD1 PHE A  45      -0.180  -2.018  -9.046  1.00 15.57           C  
ATOM    342  CD2 PHE A  45      -0.519  -3.785 -10.574  1.00 14.36           C  
ATOM    343  CE1 PHE A  45      -0.715  -1.109  -9.973  1.00 16.45           C  
ATOM    344  CE2 PHE A  45      -1.055  -2.912 -11.467  1.00 14.47           C  
ATOM    345  CZ  PHE A  45      -1.142  -1.567 -11.179  1.00 11.58           C  
ATOM    346  N   PRO A  46      -2.082  -6.029  -8.014  1.00 14.57           N  
ATOM    347  CA  PRO A  46      -3.451  -6.301  -8.466  1.00 15.06           C  
ATOM    348  C   PRO A  46      -4.471  -6.642  -7.354  1.00 17.52           C  
ATOM    349  O   PRO A  46      -5.671  -6.865  -7.639  1.00 17.97           O  
ATOM    350  CB  PRO A  46      -3.266  -7.521  -9.359  1.00 17.77           C  
ATOM    351  CG  PRO A  46      -2.112  -8.210  -8.820  1.00 15.88           C  
ATOM    352  CD  PRO A  46      -1.186  -7.155  -8.277  1.00 15.92           C  
HETATM  353  N   MSE A  47      -4.008  -6.721  -6.112  1.00 17.31           N  
HETATM  354  CA  MSE A  47      -4.848  -7.130  -4.999  1.00 16.49           C  
HETATM  355  C   MSE A  47      -5.721  -5.976  -4.472  1.00 18.40           C  
HETATM  356  O   MSE A  47      -5.324  -4.804  -4.514  1.00 18.09           O  
HETATM  357  CB  MSE A  47      -3.980  -7.630  -3.845  1.00 14.85           C  
HETATM  358  CG  MSE A  47      -3.197  -8.866  -4.153  1.00 14.45           C  
HETATM  359 SE   MSE A  47      -2.216  -9.459  -2.553  0.75 25.66          SE  
HETATM  360  CE  MSE A  47      -1.594 -11.180  -3.153  1.00 21.50           C  
ATOM    361  N   ALA A  48      -6.884  -6.301  -3.924  1.00 19.91           N  
ATOM    362  CA  ALA A  48      -7.633  -5.343  -3.099  1.00 18.60           C  
ATOM    363  C   ALA A  48      -6.738  -4.936  -1.940  1.00 16.89           C  
ATOM    364  O   ALA A  48      -5.993  -5.752  -1.456  1.00 18.10           O  
ATOM    365  CB  ALA A  48      -8.911  -5.988  -2.558  1.00 22.14           C  
ATOM    366  N   ALA A  49      -6.880  -3.717  -1.466  1.00 17.95           N  
ATOM    367  CA  ALA A  49      -6.003  -3.214  -0.418  1.00 18.05           C  
ATOM    368  C   ALA A  49      -6.022  -4.076   0.834  1.00 18.90           C  
ATOM    369  O   ALA A  49      -4.985  -4.284   1.460  1.00 19.89           O  
ATOM    370  CB  ALA A  49      -6.377  -1.783  -0.066  1.00 20.83           C  
ATOM    371  N   GLU A  50      -7.202  -4.544   1.205  1.00 19.11           N  
ATOM    372  CA  GLU A  50      -7.364  -5.379   2.416  1.00 20.97           C  
ATOM    373  C   GLU A  50      -6.528  -6.679   2.268  1.00 19.21           C  
ATOM    374  O   GLU A  50      -5.866  -7.111   3.207  1.00 17.69           O  
ATOM    375  CB  GLU A  50      -8.866  -5.631   2.677  1.00 24.55           C  
ATOM    376  CG  GLU A  50      -9.270  -6.207   4.060  1.00 28.74           C  
ATOM    377  CD  GLU A  50      -9.441  -5.148   5.161  1.00 26.34           C  
ATOM    378  N   GLN A  51      -6.528  -7.287   1.082  1.00 17.51           N  
ATOM    379  CA  GLN A  51      -5.714  -8.470   0.827  1.00 15.72           C  
ATOM    380  C   GLN A  51      -4.214  -8.173   0.854  1.00 12.99           C  
ATOM    381  O   GLN A  51      -3.404  -8.892   1.448  1.00 15.04           O  
ATOM    382  CB  GLN A  51      -6.068  -9.132  -0.526  1.00 16.15           C  
ATOM    383  CG  GLN A  51      -5.435 -10.513  -0.613  1.00 18.55           C  
ATOM    384  CD  GLN A  51      -5.502 -11.148  -1.984  1.00 22.13           C  
ATOM    385  OE1 GLN A  51      -6.099 -10.594  -2.925  1.00 26.97           O  
ATOM    386  NE2 GLN A  51      -4.879 -12.317  -2.110  1.00 23.36           N  
ATOM    387  N   ALA A  52      -3.833  -7.097   0.181  1.00 12.31           N  
ATOM    388  CA  ALA A  52      -2.434  -6.722   0.128  1.00 12.83           C  
ATOM    389  C   ALA A  52      -1.885  -6.405   1.517  1.00 11.84           C  
ATOM    390  O   ALA A  52      -0.789  -6.808   1.856  1.00 13.10           O  
ATOM    391  CB  ALA A  52      -2.277  -5.505  -0.754  1.00 14.60           C  
HETATM  392  N   MSE A  53      -2.615  -5.640   2.309  1.00 14.16           N  
HETATM  393  CA  MSE A  53      -2.085  -5.281   3.632  1.00 12.73           C  
HETATM  394  C   MSE A  53      -2.025  -6.519   4.502  1.00 12.21           C  
HETATM  395  O   MSE A  53      -1.161  -6.655   5.343  1.00 12.38           O  
HETATM  396  CB  MSE A  53      -2.936  -4.202   4.289  1.00 13.16           C  
HETATM  397  CG  MSE A  53      -2.882  -2.908   3.533  1.00 14.41           C  
HETATM  398 SE   MSE A  53      -3.854  -1.489   4.459  0.75 22.53          SE  
HETATM  399  CE  MSE A  53      -5.623  -2.052   4.039  1.00 18.23           C  
ATOM    400  N   THR A  54      -2.939  -7.457   4.293  1.00 12.69           N  
ATOM    401  CA  THR A  54      -2.886  -8.719   5.014  1.00 10.78           C  
ATOM    402  C   THR A  54      -1.624  -9.501   4.578  1.00 13.23           C  
ATOM    403  O   THR A  54      -0.860  -9.986   5.401  1.00 13.50           O  
ATOM    404  CB  THR A  54      -4.179  -9.543   4.857  1.00 12.05           C  
ATOM    405  OG1 THR A  54      -5.294  -8.768   5.331  1.00 14.05           O  
ATOM    406  CG2 THR A  54      -4.071 -10.839   5.614  1.00 16.96           C  
ATOM    407  N   GLU A  55      -1.402  -9.588   3.273  1.00 12.12           N  
ATOM    408  CA  GLU A  55      -0.294 -10.341   2.733  1.00 11.31           C  
ATOM    409  C   GLU A  55       1.025  -9.794   3.243  1.00 12.30           C  
ATOM    410  O   GLU A  55       1.941 -10.564   3.488  1.00 15.44           O  
ATOM    411  CB  GLU A  55      -0.338 -10.308   1.197  1.00 12.51           C  
ATOM    412  CG  GLU A  55       0.522 -11.347   0.544  1.00 18.84           C  
ATOM    413  CD  GLU A  55       1.943 -10.889   0.411  1.00 21.92           C  
ATOM    414  OE1 GLU A  55       2.139  -9.651   0.432  1.00 21.21           O  
ATOM    415  OE2 GLU A  55       2.856 -11.743   0.351  1.00 24.42           O  
ATOM    416  N   LEU A  56       1.089  -8.469   3.399  1.00 12.44           N  
ATOM    417  CA  LEU A  56       2.304  -7.800   3.859  1.00 13.87           C  
ATOM    418  C   LEU A  56       2.504  -7.826   5.381  1.00 15.21           C  
ATOM    419  O   LEU A  56       3.523  -7.333   5.881  1.00 18.34           O  
ATOM    420  CB  LEU A  56       2.269  -6.341   3.406  1.00 14.78           C  
ATOM    421  CG  LEU A  56       2.455  -6.163   1.901  1.00 18.12           C  
ATOM    422  CD1 LEU A  56       2.007  -4.787   1.374  1.00 12.89           C  
ATOM    423  CD2 LEU A  56       3.933  -6.452   1.538  1.00 18.03           C  
ATOM    424  N   GLY A  57       1.541  -8.361   6.114  1.00 14.12           N  
ATOM    425  CA  GLY A  57       1.678  -8.541   7.556  1.00 13.83           C  
ATOM    426  C   GLY A  57       1.459  -7.282   8.371  1.00 13.47           C  
ATOM    427  O   GLY A  57       1.894  -7.200   9.510  1.00 16.22           O  
ATOM    428  N   ILE A  58       0.751  -6.320   7.805  1.00 12.85           N  
ATOM    429  CA  ILE A  58       0.360  -5.129   8.541  1.00 14.52           C  
ATOM    430  C   ILE A  58      -0.610  -5.489   9.665  1.00 15.64           C  
ATOM    431  O   ILE A  58      -1.562  -6.260   9.459  1.00 16.03           O  
ATOM    432  CB  ILE A  58      -0.322  -4.072   7.621  1.00 14.95           C  
ATOM    433  CG1 ILE A  58       0.588  -3.670   6.459  1.00 16.63           C  
ATOM    434  CG2 ILE A  58      -0.725  -2.830   8.416  1.00 17.60           C  
ATOM    435  CD1 ILE A  58       1.941  -3.160   6.897  1.00 20.30           C  
ATOM    436  N   ALA A  59      -0.367  -4.946  10.861  1.00 15.04           N  
ATOM    437  CA  ALA A  59      -1.296  -5.135  11.974  1.00 16.54           C  
ATOM    438  C   ALA A  59      -2.717  -4.766  11.533  1.00 13.74           C  
ATOM    439  O   ALA A  59      -2.931  -3.700  10.953  1.00 17.47           O  
ATOM    440  CB  ALA A  59      -0.878  -4.273  13.132  1.00 18.30           C  
ATOM    441  N   ALA A  60      -3.697  -5.629  11.792  1.00 15.74           N  
ATOM    442  CA  ALA A  60      -5.039  -5.428  11.254  1.00 17.11           C  
ATOM    443  C   ALA A  60      -5.694  -4.108  11.754  1.00 20.52           C  
ATOM    444  O   ALA A  60      -6.504  -3.492  11.059  1.00 20.43           O  
ATOM    445  CB  ALA A  60      -5.926  -6.635  11.624  1.00 20.01           C  
ATOM    446  N   SER A  61      -5.335  -3.696  12.963  1.00 20.01           N  
ATOM    447  CA  SER A  61      -5.809  -2.444  13.552  1.00 20.70           C  
ATOM    448  C   SER A  61      -5.272  -1.181  12.864  1.00 22.55           C  
ATOM    449  O   SER A  61      -5.776  -0.084  13.102  1.00 21.21           O  
ATOM    450  CB  SER A  61      -5.418  -2.417  15.036  1.00 18.37           C  
ATOM    451  OG  SER A  61      -3.993  -2.475  15.192  1.00 21.34           O  
ATOM    452  N   GLU A  62      -4.252  -1.335  12.026  1.00 20.08           N  
ATOM    453  CA  GLU A  62      -3.588  -0.201  11.377  1.00 18.15           C  
ATOM    454  C   GLU A  62      -3.986   0.012   9.915  1.00 17.38           C  
ATOM    455  O   GLU A  62      -3.476   0.923   9.258  1.00 16.51           O  
ATOM    456  CB  GLU A  62      -2.078  -0.393  11.484  1.00 17.17           C  
ATOM    457  CG  GLU A  62      -1.518  -0.480  12.894  1.00 21.05           C  
ATOM    458  CD  GLU A  62      -0.026  -0.855  12.924  1.00 23.34           C  
ATOM    459  N   PHE A  63      -4.899  -0.813   9.398  1.00 17.53           N  
ATOM    460  CA  PHE A  63      -5.279  -0.788   7.998  1.00 15.32           C  
ATOM    461  C   PHE A  63      -5.801   0.577   7.549  1.00 14.36           C  
ATOM    462  O   PHE A  63      -5.416   1.070   6.486  1.00 16.20           O  
ATOM    463  CB  PHE A  63      -6.307  -1.913   7.690  1.00 17.68           C  
ATOM    464  CG  PHE A  63      -5.707  -3.305   7.527  1.00 14.42           C  
ATOM    465  CD1 PHE A  63      -4.436  -3.642   7.996  1.00 17.06           C  
ATOM    466  CD2 PHE A  63      -6.456  -4.289   6.904  1.00 17.80           C  
ATOM    467  CE1 PHE A  63      -3.938  -4.920   7.840  1.00 17.98           C  
ATOM    468  CE2 PHE A  63      -5.968  -5.560   6.740  1.00 17.08           C  
ATOM    469  CZ  PHE A  63      -4.701  -5.880   7.206  1.00 16.64           C  
ATOM    470  N   ASP A  64      -6.656   1.211   8.353  1.00 14.74           N  
ATOM    471  CA  ASP A  64      -7.241   2.493   7.943  1.00 17.20           C  
ATOM    472  C   ASP A  64      -6.165   3.575   7.842  1.00 17.35           C  
ATOM    473  O   ASP A  64      -6.161   4.369   6.899  1.00 17.82           O  
ATOM    474  CB  ASP A  64      -8.348   2.947   8.879  1.00 22.02           C  
ATOM    475  CG  ASP A  64      -9.587   2.038   8.824  1.00 29.94           C  
ATOM    476  OD1 ASP A  64      -9.785   1.288   7.830  1.00 33.49           O  
ATOM    477  OD2 ASP A  64     -10.374   2.093   9.798  1.00 40.15           O  
ATOM    478  N   HIS A  65      -5.234   3.568   8.787  1.00 16.96           N  
ATOM    479  CA  HIS A  65      -4.135   4.532   8.761  1.00 17.63           C  
ATOM    480  C   HIS A  65      -3.224   4.322   7.572  1.00 16.24           C  
ATOM    481  O   HIS A  65      -2.929   5.270   6.844  1.00 15.40           O  
ATOM    482  CB  HIS A  65      -3.293   4.504  10.025  1.00 17.99           C  
ATOM    483  CG  HIS A  65      -2.419   5.716  10.162  1.00 25.00           C  
ATOM    484  ND1 HIS A  65      -1.220   5.713  10.848  1.00 29.96           N  
ATOM    485  CD2 HIS A  65      -2.547   6.964   9.638  1.00 29.11           C  
ATOM    486  CE1 HIS A  65      -0.668   6.915  10.774  1.00 26.85           C  
ATOM    487  NE2 HIS A  65      -1.448   7.688  10.038  1.00 21.17           N  
ATOM    488  N   PHE A  66      -2.811   3.077   7.365  1.00 13.98           N  
ATOM    489  CA  PHE A  66      -2.009   2.703   6.190  1.00 13.84           C  
ATOM    490  C   PHE A  66      -2.638   3.218   4.895  1.00 13.49           C  
ATOM    491  O   PHE A  66      -1.969   3.818   4.065  1.00 14.84           O  
ATOM    492  CB  PHE A  66      -1.870   1.151   6.139  1.00 16.08           C  
ATOM    493  CG  PHE A  66      -0.888   0.658   5.111  1.00 15.72           C  
ATOM    494  CD1 PHE A  66      -1.205   0.666   3.758  1.00 17.68           C  
ATOM    495  CD2 PHE A  66       0.344   0.201   5.496  1.00 15.82           C  
ATOM    496  CE1 PHE A  66      -0.295   0.239   2.817  1.00 17.39           C  
ATOM    497  CE2 PHE A  66       1.234  -0.239   4.572  1.00 15.46           C  
ATOM    498  CZ  PHE A  66       0.941  -0.207   3.230  1.00 16.42           C  
ATOM    499  N   GLN A  67      -3.937   3.005   4.719  1.00 15.19           N  
ATOM    500  CA  GLN A  67      -4.582   3.433   3.480  0.50 14.97           C  
ATOM    502  C   GLN A  67      -4.613   4.957   3.344  1.00 14.92           C  
ATOM    503  O   GLN A  67      -4.471   5.470   2.238  1.00 17.91           O  
ATOM    504  CB  GLN A  67      -5.996   2.844   3.320  0.50 17.54           C  
ATOM    506  CG  GLN A  67      -6.008   1.380   2.894  0.50 21.11           C  
ATOM    508  CD  GLN A  67      -5.354   1.153   1.547  0.50 21.33           C  
ATOM    510  OE1 GLN A  67      -4.384   0.395   1.426  0.50 23.48           O  
ATOM    512  NE2 GLN A  67      -5.870   1.817   0.529  0.50 23.22           N  
ATOM    514  N   ALA A  68      -4.759   5.671   4.458  1.00 17.24           N  
ATOM    515  CA  ALA A  68      -4.721   7.129   4.461  1.00 14.71           C  
ATOM    516  C   ALA A  68      -3.333   7.638   4.047  1.00 15.71           C  
ATOM    517  O   ALA A  68      -3.202   8.547   3.247  1.00 17.17           O  
ATOM    518  CB  ALA A  68      -5.097   7.642   5.839  1.00 15.19           C  
ATOM    519  N   GLN A  69      -2.299   7.041   4.612  1.00 15.02           N  
ATOM    520  CA  GLN A  69      -0.940   7.377   4.224  1.00 13.24           C  
ATOM    521  C   GLN A  69      -0.720   7.150   2.740  1.00 14.37           C  
ATOM    522  O   GLN A  69      -0.146   7.999   2.052  1.00 15.56           O  
ATOM    523  CB  GLN A  69       0.058   6.565   5.009  1.00 12.01           C  
ATOM    524  CG  GLN A  69       0.076   6.928   6.448  1.00 13.68           C  
ATOM    525  CD  GLN A  69       0.921   5.994   7.234  1.00 13.97           C  
ATOM    526  OE1 GLN A  69       0.408   5.032   7.794  1.00 20.51           O  
ATOM    527  NE2 GLN A  69       2.232   6.183   7.179  1.00 10.81           N  
ATOM    528  N   TYR A  70      -1.202   6.016   2.249  1.00 13.80           N  
ATOM    529  CA  TYR A  70      -1.004   5.653   0.882  1.00 13.31           C  
ATOM    530  C   TYR A  70      -1.640   6.680   0.008  1.00 13.72           C  
ATOM    531  O   TYR A  70      -1.028   7.126  -0.965  1.00 13.92           O  
ATOM    532  CB  TYR A  70      -1.590   4.276   0.550  1.00 13.70           C  
ATOM    533  CG  TYR A  70      -1.569   3.938  -0.917  1.00 14.88           C  
ATOM    534  CD1 TYR A  70      -0.468   3.319  -1.494  1.00 18.13           C  
ATOM    535  CD2 TYR A  70      -2.649   4.228  -1.732  1.00 17.52           C  
ATOM    536  CE1 TYR A  70      -0.429   3.026  -2.866  1.00 18.05           C  
ATOM    537  CE2 TYR A  70      -2.632   3.926  -3.118  1.00 21.02           C  
ATOM    538  CZ  TYR A  70      -1.518   3.303  -3.666  1.00 21.11           C  
ATOM    539  OH  TYR A  70      -1.489   2.969  -5.017  1.00 21.81           O  
ATOM    540  N   GLU A  71      -2.883   7.057   0.325  1.00 15.14           N  
ATOM    541  CA  GLU A  71      -3.571   8.026  -0.534  1.00 17.68           C  
ATOM    542  C   GLU A  71      -2.883   9.392  -0.520  1.00 16.73           C  
ATOM    543  O   GLU A  71      -2.785  10.079  -1.542  1.00 17.77           O  
ATOM    544  CB  GLU A  71      -5.035   8.140  -0.129  1.00 17.08           C  
ATOM    545  CG  GLU A  71      -5.787   6.837  -0.217  1.00 26.82           C  
ATOM    546  N   ASP A  72      -2.393   9.771   0.651  1.00 17.24           N  
ATOM    547  CA  ASP A  72      -1.696  11.048   0.807  1.00 17.57           C  
ATOM    548  C   ASP A  72      -0.425  11.144  -0.019  1.00 16.14           C  
ATOM    549  O   ASP A  72      -0.198  12.145  -0.692  1.00 20.96           O  
ATOM    550  CB  ASP A  72      -1.388  11.280   2.280  1.00 21.29           C  
ATOM    551  CG  ASP A  72      -2.661  11.432   3.131  1.00 31.56           C  
ATOM    552  OD1 ASP A  72      -3.769  11.578   2.550  1.00 41.97           O  
ATOM    553  OD2 ASP A  72      -2.546  11.407   4.381  1.00 43.14           O  
ATOM    554  N   VAL A  73       0.374  10.082  -0.018  1.00 13.71           N  
ATOM    555  CA  VAL A  73       1.622  10.033  -0.774  1.00 15.04           C  
ATOM    556  C   VAL A  73       1.372   9.894  -2.265  1.00 13.33           C  
ATOM    557  O   VAL A  73       2.016  10.549  -3.090  1.00 16.42           O  
ATOM    558  CB  VAL A  73       2.525   8.877  -0.280  1.00 16.17           C  
ATOM    559  CG1 VAL A  73       3.766   8.794  -1.148  1.00 16.29           C  
ATOM    560  CG2 VAL A  73       2.913   9.100   1.158  1.00 17.11           C  
HETATM  561  N   MSE A  74       0.425   9.038  -2.612  1.00 14.05           N  
HETATM  562  CA  MSE A  74       0.099   8.807  -4.012  1.00 15.89           C  
HETATM  563  C   MSE A  74      -0.333  10.096  -4.710  1.00 13.94           C  
HETATM  564  O   MSE A  74      -0.039  10.289  -5.879  1.00 16.08           O  
HETATM  565  CB  MSE A  74      -0.994   7.735  -4.122  1.00 12.69           C  
HETATM  566  CG  MSE A  74      -1.467   7.482  -5.561  1.00 14.36           C  
HETATM  567 SE   MSE A  74       0.051   7.077  -6.833  0.75 27.79          SE  
HETATM  568  CE  MSE A  74       0.110   5.104  -6.601  1.00 22.55           C  
ATOM    569  N   ALA A  75      -0.970  11.014  -3.989  1.00 15.19           N  
ATOM    570  CA  ALA A  75      -1.446  12.235  -4.646  1.00 17.31           C  
ATOM    571  C   ALA A  75      -0.278  13.146  -5.108  1.00 15.73           C  
ATOM    572  O   ALA A  75      -0.473  14.065  -5.928  1.00 15.27           O  
ATOM    573  CB  ALA A  75      -2.416  12.975  -3.761  1.00 16.02           C  
ATOM    574  N   SER A  76       0.944  12.849  -4.676  1.00 16.52           N  
ATOM    575  CA  SER A  76       2.150  13.493  -5.230  1.00 14.73           C  
ATOM    576  C   SER A  76       2.842  12.783  -6.389  1.00 17.80           C  
ATOM    577  O   SER A  76       3.899  13.238  -6.834  1.00 17.71           O  
ATOM    578  CB  SER A  76       3.164  13.676  -4.118  1.00 19.39           C  
ATOM    579  OG  SER A  76       2.697  14.713  -3.306  1.00 20.89           O  
ATOM    580  N   HIS A  77       2.275  11.683  -6.866  1.00 13.30           N  
ATOM    581  CA  HIS A  77       2.951  10.810  -7.842  1.00 13.84           C  
ATOM    582  C   HIS A  77       2.203  10.587  -9.140  1.00 15.64           C  
ATOM    583  O   HIS A  77       2.595   9.748  -9.930  1.00 16.70           O  
ATOM    584  CB  HIS A  77       3.314   9.476  -7.189  1.00 14.01           C  
ATOM    585  CG  HIS A  77       4.436   9.609  -6.211  1.00 12.40           C  
ATOM    586  ND1 HIS A  77       5.758   9.472  -6.576  1.00 26.84           N  
ATOM    587  CD2 HIS A  77       4.437   9.952  -4.902  1.00 15.95           C  
ATOM    588  CE1 HIS A  77       6.524   9.687  -5.518  1.00 25.23           C  
ATOM    589  NE2 HIS A  77       5.747   9.989  -4.490  1.00 17.45           N  
ATOM    590  N   TYR A  78       1.144  11.333  -9.393  1.00 16.20           N  
ATOM    591  CA  TYR A  78       0.415  11.149 -10.639  1.00 17.29           C  
ATOM    592  C   TYR A  78       1.275  11.385 -11.872  1.00 20.17           C  
ATOM    593  O   TYR A  78       1.030  10.757 -12.923  1.00 21.86           O  
ATOM    594  CB  TYR A  78      -0.804  12.047 -10.674  1.00 19.90           C  
ATOM    595  CG  TYR A  78      -1.764  11.794  -9.544  1.00 18.64           C  
ATOM    596  CD1 TYR A  78      -2.214  10.521  -9.273  1.00 16.20           C  
ATOM    597  CD2 TYR A  78      -2.232  12.831  -8.759  1.00 24.16           C  
ATOM    598  CE1 TYR A  78      -3.091  10.275  -8.258  1.00 18.30           C  
ATOM    599  CE2 TYR A  78      -3.117  12.592  -7.749  1.00 21.90           C  
ATOM    600  CZ  TYR A  78      -3.540  11.314  -7.506  1.00 19.47           C  
ATOM    601  OH  TYR A  78      -4.413  11.080  -6.500  1.00 24.33           O  
ATOM    602  N   ASP A  79       2.280  12.251 -11.781  1.00 21.15           N  
ATOM    603  CA  ASP A  79       3.179  12.478 -12.932  1.00 21.86           C  
ATOM    604  C   ASP A  79       4.114  11.288 -13.235  1.00 24.36           C  
ATOM    605  O   ASP A  79       4.787  11.276 -14.275  1.00 29.35           O  
ATOM    606  CB  ASP A  79       3.998  13.770 -12.756  1.00 23.43           C  
ATOM    607  N   GLN A  80       4.192  10.327 -12.319  1.00 20.74           N  
ATOM    608  CA  GLN A  80       4.932   9.083 -12.501  1.00 22.30           C  
ATOM    609  C   GLN A  80       4.038   8.030 -13.158  1.00 18.79           C  
ATOM    610  O   GLN A  80       4.465   6.895 -13.343  1.00 19.32           O  
ATOM    611  CB  GLN A  80       5.416   8.607 -11.118  1.00 23.09           C  
ATOM    612  CG  GLN A  80       6.336   7.347 -10.994  1.00 28.53           C  
ATOM    613  CD  GLN A  80       6.860   7.113  -9.509  1.00 28.80           C  
ATOM    614  OE1 GLN A  80       6.497   7.847  -8.577  1.00 37.45           O  
ATOM    615  NE2 GLN A  80       7.708   6.094  -9.325  1.00 28.93           N  
ATOM    616  N   ILE A  81       2.790   8.383 -13.462  1.00 16.73           N  
ATOM    617  CA  ILE A  81       1.829   7.446 -14.054  1.00 13.51           C  
ATOM    618  C   ILE A  81       1.468   7.941 -15.426  1.00 14.28           C  
ATOM    619  O   ILE A  81       1.034   9.060 -15.596  1.00 17.55           O  
ATOM    620  CB  ILE A  81       0.588   7.334 -13.193  1.00 13.22           C  
ATOM    621  CG1 ILE A  81       0.969   6.788 -11.812  1.00 18.49           C  
ATOM    622  CG2 ILE A  81      -0.402   6.428 -13.839  1.00 14.44           C  
ATOM    623  CD1 ILE A  81      -0.146   6.802 -10.801  1.00 20.93           C  
ATOM    624  N   GLU A  82       1.687   7.101 -16.422  1.00 18.14           N  
ATOM    625  CA  GLU A  82       1.322   7.441 -17.783  1.00 18.41           C  
ATOM    626  C   GLU A  82       0.294   6.416 -18.244  1.00 16.54           C  
ATOM    627  O   GLU A  82       0.232   5.281 -17.719  1.00 15.79           O  
ATOM    628  CB  GLU A  82       2.570   7.448 -18.668  1.00 20.46           C  
ATOM    629  CG  GLU A  82       3.603   8.547 -18.321  1.00 24.25           C  
ATOM    630  CD  GLU A  82       3.554   9.751 -19.250  1.00 27.45           C  
ATOM    631  N   LEU A  83      -0.516   6.801 -19.224  1.00 15.31           N  
ATOM    632  CA  LEU A  83      -1.348   5.813 -19.928  1.00 15.88           C  
ATOM    633  C   LEU A  83      -0.474   4.812 -20.676  1.00 15.84           C  
ATOM    634  O   LEU A  83       0.602   5.134 -21.165  1.00 17.41           O  
ATOM    635  CB  LEU A  83      -2.298   6.465 -20.932  1.00 15.17           C  
ATOM    636  CG  LEU A  83      -3.244   7.524 -20.364  1.00 17.22           C  
ATOM    637  CD1 LEU A  83      -3.954   8.208 -21.515  1.00 19.57           C  
ATOM    638  CD2 LEU A  83      -4.210   6.938 -19.386  1.00 16.32           C  
ATOM    639  N   TYR A  84      -0.949   3.586 -20.801  1.00 14.78           N  
ATOM    640  CA  TYR A  84      -0.338   2.650 -21.758  1.00 14.52           C  
ATOM    641  C   TYR A  84      -0.461   3.202 -23.172  1.00 15.07           C  
ATOM    642  O   TYR A  84      -1.459   3.828 -23.507  1.00 13.91           O  
ATOM    643  CB  TYR A  84      -1.059   1.310 -21.682  1.00 14.45           C  
ATOM    644  CG  TYR A  84      -0.649   0.463 -20.494  1.00 13.92           C  
ATOM    645  CD1 TYR A  84       0.601  -0.186 -20.454  1.00 14.46           C  
ATOM    646  CD2 TYR A  84      -1.484   0.310 -19.396  1.00 14.17           C  
ATOM    647  CE1 TYR A  84       0.965  -1.005 -19.368  1.00 13.76           C  
ATOM    648  CE2 TYR A  84      -1.118  -0.473 -18.310  1.00 12.97           C  
ATOM    649  CZ  TYR A  84       0.102  -1.122 -18.292  1.00 14.59           C  
ATOM    650  OH  TYR A  84       0.479  -1.909 -17.214  1.00 16.74           O  
ATOM    651  N   PRO A  85       0.544   2.947 -24.026  1.00 15.96           N  
ATOM    652  CA  PRO A  85       0.394   3.365 -25.420  1.00 14.59           C  
ATOM    653  C   PRO A  85      -0.780   2.652 -26.086  1.00 14.62           C  
ATOM    654  O   PRO A  85      -1.031   1.471 -25.793  1.00 17.47           O  
ATOM    655  CB  PRO A  85       1.724   2.972 -26.055  1.00 15.28           C  
ATOM    656  CG  PRO A  85       2.528   2.281 -25.035  1.00 17.66           C  
ATOM    657  CD  PRO A  85       1.797   2.224 -23.757  1.00 15.19           C  
ATOM    658  N   GLY A  86      -1.495   3.388 -26.929  1.00 12.64           N  
ATOM    659  CA  GLY A  86      -2.644   2.894 -27.668  1.00 14.06           C  
ATOM    660  C   GLY A  86      -3.962   3.246 -27.004  1.00 12.85           C  
ATOM    661  O   GLY A  86      -5.009   3.204 -27.638  1.00 14.20           O  
ATOM    662  N   ILE A  87      -3.936   3.590 -25.706  1.00 12.26           N  
ATOM    663  CA  ILE A  87      -5.178   3.899 -25.001  1.00 12.64           C  
ATOM    664  C   ILE A  87      -5.844   5.156 -25.541  1.00 12.97           C  
ATOM    665  O   ILE A  87      -7.052   5.163 -25.784  1.00 15.77           O  
ATOM    666  CB  ILE A  87      -4.904   4.022 -23.474  1.00 13.32           C  
ATOM    667  CG1 ILE A  87      -4.527   2.662 -22.888  1.00 16.18           C  
ATOM    668  CG2 ILE A  87      -6.106   4.617 -22.712  1.00 16.86           C  
ATOM    669  CD1 ILE A  87      -5.597   1.635 -22.890  1.00 20.08           C  
ATOM    670  N   THR A  88      -5.080   6.217 -25.788  1.00 13.88           N  
ATOM    671  CA  THR A  88      -5.656   7.454 -26.328  1.00 14.39           C  
ATOM    672  C   THR A  88      -6.300   7.221 -27.722  1.00 15.10           C  
ATOM    673  O   THR A  88      -7.400   7.729 -28.001  1.00 16.55           O  
ATOM    674  CB  THR A  88      -4.593   8.601 -26.406  1.00 14.97           C  
ATOM    675  OG1 THR A  88      -3.451   8.147 -27.141  1.00 23.75           O  
ATOM    676  CG2 THR A  88      -4.156   9.035 -25.022  1.00 15.00           C  
ATOM    677  N   SER A  89      -5.618   6.426 -28.560  1.00 17.24           N  
ATOM    678  CA  SER A  89      -6.107   6.075 -29.891  1.00 19.14           C  
ATOM    679  C   SER A  89      -7.345   5.219 -29.813  1.00 18.08           C  
ATOM    680  O   SER A  89      -8.245   5.296 -30.642  1.00 19.13           O  
ATOM    681  CB  SER A  89      -5.053   5.292 -30.651  1.00 22.72           C  
ATOM    682  OG  SER A  89      -3.864   6.033 -30.783  1.00 25.26           O  
ATOM    683  N   LEU A  90      -7.374   4.346 -28.820  1.00 14.84           N  
ATOM    684  CA  LEU A  90      -8.514   3.481 -28.630  1.00 14.39           C  
ATOM    685  C   LEU A  90      -9.765   4.305 -28.402  1.00 13.17           C  
ATOM    686  O   LEU A  90     -10.794   4.060 -29.002  1.00 15.04           O  
ATOM    687  CB  LEU A  90      -8.287   2.527 -27.476  1.00 15.70           C  
ATOM    688  CG  LEU A  90      -9.496   1.708 -27.007  1.00 14.44           C  
ATOM    689  CD1 LEU A  90      -9.884   0.707 -28.070  1.00 16.89           C  
ATOM    690  CD2 LEU A  90      -9.204   1.059 -25.662  1.00 15.61           C  
ATOM    691  N   PHE A  91      -9.687   5.263 -27.493  1.00 14.90           N  
ATOM    692  CA  PHE A  91     -10.845   6.058 -27.140  1.00 15.64           C  
ATOM    693  C   PHE A  91     -11.295   7.025 -28.278  1.00 16.76           C  
ATOM    694  O   PHE A  91     -12.481   7.351 -28.384  1.00 22.15           O  
ATOM    695  CB  PHE A  91     -10.610   6.736 -25.773  1.00 15.72           C  
ATOM    696  CG  PHE A  91     -10.771   5.797 -24.618  1.00 13.63           C  
ATOM    697  CD1 PHE A  91     -12.025   5.378 -24.265  1.00 13.28           C  
ATOM    698  CD2 PHE A  91      -9.694   5.331 -23.900  1.00 24.84           C  
ATOM    699  CE1 PHE A  91     -12.227   4.485 -23.249  1.00 16.37           C  
ATOM    700  CE2 PHE A  91      -9.875   4.433 -22.839  1.00 18.61           C  
ATOM    701  CZ  PHE A  91     -11.128   4.003 -22.508  1.00 15.04           C  
ATOM    702  N   GLU A  92     -10.375   7.348 -29.185  1.00 18.23           N  
ATOM    703  CA  GLU A  92     -10.735   8.080 -30.418  1.00 16.93           C  
ATOM    704  C   GLU A  92     -11.532   7.222 -31.389  1.00 20.06           C  
ATOM    705  O   GLU A  92     -12.291   7.759 -32.203  1.00 23.83           O  
ATOM    706  CB  GLU A  92      -9.497   8.582 -31.169  1.00 18.18           C  
ATOM    707  CG  GLU A  92      -8.432   9.305 -30.357  1.00 24.03           C  
ATOM    708  CD  GLU A  92      -8.792  10.711 -30.015  1.00 36.82           C  
ATOM    709  OE1 GLU A  92      -9.983  11.059 -30.158  1.00 37.92           O  
ATOM    710  OE2 GLU A  92      -7.879  11.472 -29.609  1.00 28.49           O  
ATOM    711  N   GLN A  93     -11.339   5.910 -31.363  1.00 15.65           N  
ATOM    712  CA  GLN A  93     -11.905   5.034 -32.389  1.00 15.89           C  
ATOM    713  C   GLN A  93     -13.130   4.232 -31.911  1.00 14.82           C  
ATOM    714  O   GLN A  93     -13.904   3.753 -32.734  1.00 17.55           O  
ATOM    715  CB  GLN A  93     -10.843   4.047 -32.872  1.00 17.72           C  
ATOM    716  CG  GLN A  93      -9.591   4.639 -33.541  1.00 18.69           C  
ATOM    717  CD  GLN A  93      -9.882   5.447 -34.775  1.00 24.24           C  
ATOM    718  OE1 GLN A  93     -10.754   5.097 -35.583  1.00 27.69           O  
ATOM    719  NE2 GLN A  93      -9.146   6.545 -34.941  1.00 28.66           N  
ATOM    720  N   LEU A  94     -13.307   4.055 -30.600  1.00 14.95           N  
ATOM    721  CA  LEU A  94     -14.457   3.259 -30.115  1.00 17.41           C  
ATOM    722  C   LEU A  94     -15.781   3.889 -30.618  1.00 17.24           C  
ATOM    723  O   LEU A  94     -15.897   5.119 -30.614  1.00 19.74           O  
ATOM    724  CB  LEU A  94     -14.440   3.174 -28.601  1.00 17.08           C  
ATOM    725  CG  LEU A  94     -13.453   2.138 -27.999  1.00 16.09           C  
ATOM    726  CD1 LEU A  94     -13.266   2.332 -26.504  1.00 15.93           C  
ATOM    727  CD2 LEU A  94     -13.929   0.713 -28.235  1.00 17.61           C  
ATOM    728  N   PRO A  95     -16.761   3.080 -31.091  1.00 16.07           N  
ATOM    729  CA  PRO A  95     -18.024   3.630 -31.568  1.00 16.51           C  
ATOM    730  C   PRO A  95     -18.696   4.502 -30.512  1.00 15.02           C  
ATOM    731  O   PRO A  95     -18.754   4.129 -29.328  1.00 16.19           O  
ATOM    732  CB  PRO A  95     -18.912   2.396 -31.816  1.00 18.61           C  
ATOM    733  CG  PRO A  95     -18.013   1.246 -31.803  1.00 17.65           C  
ATOM    734  CD  PRO A  95     -16.718   1.606 -31.172  1.00 16.04           C  
ATOM    735  N   SER A  96     -19.240   5.627 -30.970  1.00 13.06           N  
ATOM    736  CA  SER A  96     -19.889   6.588 -30.095  1.00 15.52           C  
ATOM    737  C   SER A  96     -21.190   6.051 -29.489  1.00 14.16           C  
ATOM    738  O   SER A  96     -21.665   6.545 -28.464  1.00 16.12           O  
ATOM    739  CB  SER A  96     -20.186   7.856 -30.886  1.00 17.47           C  
ATOM    740  OG  SER A  96     -21.034   7.516 -31.986  1.00 24.96           O  
ATOM    741  N   GLU A  97     -21.757   5.038 -30.126  1.00 15.33           N  
ATOM    742  CA  GLU A  97     -22.933   4.354 -29.601  1.00 15.37           C  
ATOM    743  C   GLU A  97     -22.676   3.601 -28.271  1.00 15.00           C  
ATOM    744  O   GLU A  97     -23.614   3.369 -27.515  1.00 18.45           O  
ATOM    745  CB  GLU A  97     -23.469   3.378 -30.647  1.00 19.00           C  
ATOM    746  CG  GLU A  97     -23.932   4.065 -31.960  1.00 22.10           C  
ATOM    747  CD  GLU A  97     -22.798   4.359 -32.991  1.00 35.43           C  
ATOM    748  OE1 GLU A  97     -21.592   4.067 -32.736  1.00 27.08           O  
ATOM    749  OE2 GLU A  97     -23.138   4.898 -34.076  1.00 45.03           O  
ATOM    750  N   LEU A  98     -21.429   3.239 -27.976  1.00 12.30           N  
ATOM    751  CA  LEU A  98     -21.125   2.545 -26.729  1.00 11.96           C  
ATOM    752  C   LEU A  98     -21.369   3.395 -25.497  1.00 12.36           C  
ATOM    753  O   LEU A  98     -21.178   4.614 -25.505  1.00 14.94           O  
ATOM    754  CB  LEU A  98     -19.677   2.109 -26.692  1.00 13.59           C  
ATOM    755  CG  LEU A  98     -19.346   0.948 -27.571  1.00 15.15           C  
ATOM    756  CD1 LEU A  98     -17.853   0.795 -27.680  1.00 18.52           C  
ATOM    757  CD2 LEU A  98     -20.022  -0.343 -27.020  1.00 19.13           C  
ATOM    758  N   ARG A  99     -21.810   2.754 -24.425  1.00 10.43           N  
ATOM    759  CA  ARG A  99     -21.722   3.358 -23.110  1.00 11.28           C  
ATOM    760  C   ARG A  99     -20.411   2.951 -22.484  1.00 12.06           C  
ATOM    761  O   ARG A  99     -20.148   1.759 -22.295  1.00 15.25           O  
ATOM    762  CB  ARG A  99     -22.902   3.002 -22.183  1.00 13.64           C  
ATOM    763  CG  ARG A  99     -24.265   2.985 -22.796  1.00 16.18           C  
ATOM    764  CD  ARG A  99     -24.735   4.211 -23.530  1.00 17.63           C  
ATOM    765  NE  ARG A  99     -24.494   5.494 -22.872  1.00 22.97           N  
ATOM    766  CZ  ARG A  99     -25.273   6.089 -21.963  1.00 24.27           C  
ATOM    767  NH1 ARG A  99     -26.374   5.503 -21.489  1.00 29.72           N  
ATOM    768  NH2 ARG A  99     -24.924   7.293 -21.513  1.00 19.69           N  
ATOM    769  N   LEU A 100     -19.563   3.931 -22.206  1.00 10.05           N  
ATOM    770  CA  LEU A 100     -18.250   3.662 -21.656  1.00 10.35           C  
ATOM    771  C   LEU A 100     -18.256   4.064 -20.173  1.00 12.02           C  
ATOM    772  O   LEU A 100     -18.895   5.051 -19.771  1.00 13.26           O  
ATOM    773  CB  LEU A 100     -17.150   4.458 -22.389  1.00 11.49           C  
ATOM    774  CG  LEU A 100     -17.010   4.246 -23.904  1.00 13.66           C  
ATOM    775  CD1 LEU A 100     -15.862   5.062 -24.408  1.00 15.92           C  
ATOM    776  CD2 LEU A 100     -16.810   2.783 -24.246  1.00 14.65           C  
ATOM    777  N   GLY A 101     -17.560   3.301 -19.350  1.00 10.52           N  
ATOM    778  CA  GLY A 101     -17.367   3.719 -17.983  1.00 11.90           C  
ATOM    779  C   GLY A 101     -16.155   3.089 -17.299  1.00 11.61           C  
ATOM    780  O   GLY A 101     -15.419   2.248 -17.861  1.00 11.44           O  
ATOM    781  N   ILE A 102     -16.015   3.489 -16.051  1.00 11.97           N  
ATOM    782  CA  ILE A 102     -14.938   3.086 -15.191  1.00 14.97           C  
ATOM    783  C   ILE A 102     -15.515   2.482 -13.897  1.00 13.00           C  
ATOM    784  O   ILE A 102     -16.449   3.006 -13.302  1.00 13.81           O  
ATOM    785  CB  ILE A 102     -14.036   4.290 -14.868  1.00 17.05           C  
ATOM    786  CG1 ILE A 102     -13.201   4.608 -16.114  1.00 20.58           C  
ATOM    787  CG2 ILE A 102     -13.118   3.974 -13.647  1.00 17.79           C  
ATOM    788  CD1 ILE A 102     -12.278   5.738 -15.958  1.00 30.22           C  
ATOM    789  N   VAL A 103     -14.946   1.368 -13.470  1.00 12.79           N  
ATOM    790  CA  VAL A 103     -15.269   0.757 -12.183  1.00 12.84           C  
ATOM    791  C   VAL A 103     -13.953   0.447 -11.495  1.00 14.26           C  
ATOM    792  O   VAL A 103     -13.211  -0.460 -11.896  1.00 17.08           O  
ATOM    793  CB  VAL A 103     -16.088  -0.580 -12.358  1.00 13.17           C  
ATOM    794  CG1 VAL A 103     -16.407  -1.190 -11.001  1.00 14.20           C  
ATOM    795  CG2 VAL A 103     -17.292  -0.356 -13.200  1.00 14.34           C  
ATOM    796  N   THR A 104     -13.648   1.222 -10.469  1.00 13.51           N  
ATOM    797  CA  THR A 104     -12.307   1.204  -9.875  1.00 12.07           C  
ATOM    798  C   THR A 104     -12.422   1.124  -8.350  1.00 14.37           C  
ATOM    799  O   THR A 104     -13.364   1.610  -7.759  1.00 13.67           O  
ATOM    800  CB  THR A 104     -11.478   2.465 -10.281  1.00 13.90           C  
ATOM    801  OG1 THR A 104     -10.144   2.421  -9.708  1.00 15.08           O  
ATOM    802  CG2 THR A 104     -12.151   3.762  -9.842  1.00 16.20           C  
ATOM    803  N   SER A 105     -11.386   0.558  -7.743  1.00 15.30           N  
ATOM    804  CA  SER A 105     -11.263   0.531  -6.299  0.50 15.74           C  
ATOM    806  C   SER A 105     -10.613   1.808  -5.777  1.00 14.65           C  
ATOM    807  O   SER A 105     -10.517   1.999  -4.561  1.00 18.25           O  
ATOM    808  CB  SER A 105     -10.475  -0.708  -5.869  0.50 17.37           C  
ATOM    810  OG  SER A 105      -9.144  -0.669  -6.356  0.50 24.21           O  
ATOM    812  N   GLN A 106     -10.144   2.681  -6.674  1.00 15.55           N  
ATOM    813  CA  GLN A 106      -9.623   3.986  -6.238  1.00 15.77           C  
ATOM    814  C   GLN A 106     -10.705   4.805  -5.534  1.00 15.47           C  
ATOM    815  O   GLN A 106     -11.844   4.710  -5.899  1.00 16.72           O  
ATOM    816  CB  GLN A 106      -9.146   4.783  -7.433  1.00 14.25           C  
ATOM    817  CG  GLN A 106      -7.920   4.198  -8.090  1.00 17.11           C  
ATOM    818  CD  GLN A 106      -7.356   5.067  -9.178  1.00 22.52           C  
ATOM    819  OE1 GLN A 106      -7.736   6.223  -9.313  1.00 19.92           O  
ATOM    820  NE2 GLN A 106      -6.430   4.521  -9.974  1.00 21.97           N  
ATOM    821  N   ARG A 107     -10.331   5.576  -4.504  1.00 17.40           N  
ATOM    822  CA  ARG A 107     -11.266   6.506  -3.869  1.00 17.51           C  
ATOM    823  C   ARG A 107     -11.573   7.642  -4.836  1.00 15.52           C  
ATOM    824  O   ARG A 107     -10.813   7.921  -5.748  1.00 15.92           O  
ATOM    825  CB  ARG A 107     -10.672   7.074  -2.564  1.00 17.18           C  
ATOM    826  CG  ARG A 107     -10.548   6.029  -1.414  1.00 25.97           C  
ATOM    827  CD  ARG A 107     -11.819   5.906  -0.578  1.00 32.34           C  
ATOM    828  NE  ARG A 107     -11.947   6.963   0.425  1.00 39.47           N  
ATOM    829  N   ARG A 108     -12.726   8.273  -4.667  1.00 15.86           N  
ATOM    830  CA  ARG A 108     -13.144   9.313  -5.584  1.00 15.23           C  
ATOM    831  C   ARG A 108     -12.105  10.444  -5.683  1.00 16.58           C  
ATOM    832  O   ARG A 108     -11.805  10.930  -6.770  1.00 15.93           O  
ATOM    833  CB  ARG A 108     -14.508   9.858  -5.146  1.00 15.30           C  
ATOM    834  CG  ARG A 108     -14.960  11.109  -5.867  1.00 18.65           C  
ATOM    835  CD  ARG A 108     -15.120  10.880  -7.359  1.00 17.87           C  
ATOM    836  NE  ARG A 108     -16.153   9.876  -7.666  1.00 20.94           N  
ATOM    837  CZ  ARG A 108     -16.381   9.432  -8.887  1.00 19.42           C  
ATOM    838  NH1 ARG A 108     -15.665   9.910  -9.889  1.00 19.47           N  
ATOM    839  NH2 ARG A 108     -17.294   8.487  -9.095  1.00 18.00           N  
ATOM    840  N   ASN A 109     -11.587  10.876  -4.541  1.00 16.76           N  
ATOM    841  CA  ASN A 109     -10.618  11.951  -4.529  1.00 18.49           C  
ATOM    842  C   ASN A 109      -9.409  11.600  -5.384  1.00 14.87           C  
ATOM    843  O   ASN A 109      -8.950  12.429  -6.132  1.00 17.54           O  
ATOM    844  CB  ASN A 109     -10.225  12.374  -3.087  1.00 19.28           C  
ATOM    845  CG  ASN A 109     -11.335  13.222  -2.374  1.00 21.64           C  
ATOM    846  OD1 ASN A 109     -12.268  13.702  -3.002  1.00 22.74           O  
ATOM    847  ND2 ASN A 109     -11.208  13.391  -1.056  1.00 24.80           N  
ATOM    848  N   GLU A 110      -8.916  10.376  -5.275  1.00 16.82           N  
ATOM    849  CA  GLU A 110      -7.796   9.913  -6.060  1.00 17.41           C  
ATOM    850  C   GLU A 110      -8.141   9.807  -7.526  1.00 16.86           C  
ATOM    851  O   GLU A 110      -7.323  10.141  -8.403  1.00 17.70           O  
ATOM    852  CB  GLU A 110      -7.277   8.561  -5.550  1.00 18.56           C  
ATOM    853  CG  GLU A 110      -6.206   7.927  -6.417  1.00 22.61           C  
ATOM    854  CD  GLU A 110      -5.740   6.537  -5.944  1.00 24.35           C  
ATOM    855  OE1 GLU A 110      -6.295   6.002  -4.936  1.00 38.24           O  
ATOM    856  OE2 GLU A 110      -4.797   6.014  -6.597  1.00 34.73           O  
ATOM    857  N   LEU A 111      -9.347   9.313  -7.819  1.00 17.14           N  
ATOM    858  CA  LEU A 111      -9.780   9.192  -9.191  1.00 19.64           C  
ATOM    859  C   LEU A 111      -9.825  10.562  -9.852  1.00 19.54           C  
ATOM    860  O   LEU A 111      -9.316  10.764 -10.947  1.00 18.86           O  
ATOM    861  CB  LEU A 111     -11.146   8.498  -9.241  1.00 16.87           C  
ATOM    862  CG  LEU A 111     -11.887   8.286 -10.572  1.00 23.99           C  
ATOM    863  CD1 LEU A 111     -11.037   7.548 -11.552  1.00 27.56           C  
ATOM    864  CD2 LEU A 111     -13.178   7.511 -10.337  1.00 23.16           C  
ATOM    865  N   GLU A 112     -10.411  11.524  -9.164  1.00 18.23           N  
ATOM    866  CA  GLU A 112     -10.504  12.874  -9.680  1.00 17.86           C  
ATOM    867  C   GLU A 112      -9.150  13.548  -9.893  1.00 18.86           C  
ATOM    868  O   GLU A 112      -8.864  14.044 -10.981  1.00 19.85           O  
ATOM    869  CB  GLU A 112     -11.349  13.713  -8.742  1.00 21.06           C  
ATOM    870  CG  GLU A 112     -12.796  13.304  -8.730  1.00 24.49           C  
ATOM    871  CD  GLU A 112     -13.444  13.353 -10.108  1.00 33.68           C  
ATOM    872  OE1 GLU A 112     -13.144  14.294 -10.888  1.00 32.14           O  
ATOM    873  OE2 GLU A 112     -14.265  12.447 -10.401  1.00 31.19           O  
ATOM    874  N   SER A 113      -8.324  13.571  -8.856  0.50 19.09           N  
ATOM    876  CA  SER A 113      -7.009  14.173  -8.966  0.50 17.75           C  
ATOM    878  C   SER A 113      -6.166  13.502 -10.061  0.50 16.74           C  
ATOM    880  O   SER A 113      -5.551  14.189 -10.865  0.50 17.12           O  
ATOM    882  CB  SER A 113      -6.294  14.129  -7.618  0.50 19.65           C  
ATOM    884  OG  SER A 113      -6.993  14.922  -6.676  0.50 25.50           O  
ATOM    886  N   GLY A 114      -6.188  12.175 -10.112  1.00 16.63           N  
ATOM    887  CA  GLY A 114      -5.316  11.425 -11.011  1.00 15.54           C  
ATOM    888  C   GLY A 114      -5.771  11.397 -12.445  1.00 17.29           C  
ATOM    889  O   GLY A 114      -4.921  11.331 -13.343  1.00 19.58           O  
HETATM  890  N   MSE A 115      -7.092  11.450 -12.666  1.00 15.97           N  
HETATM  891  CA  MSE A 115      -7.643  11.191 -14.000  1.00 16.03           C  
HETATM  892  C   MSE A 115      -8.360  12.321 -14.689  1.00 20.56           C  
HETATM  893  O   MSE A 115      -8.474  12.335 -15.921  1.00 19.06           O  
HETATM  894  CB  MSE A 115      -8.644  10.028 -13.975  1.00 16.68           C  
HETATM  895  CG  MSE A 115      -8.120   8.721 -13.431  1.00 18.39           C  
HETATM  896 SE   MSE A 115      -6.517   8.009 -14.383  0.75 29.51          SE  
HETATM  897  CE  MSE A 115      -7.363   7.583 -16.092  1.00 21.21           C  
ATOM    898  N   ARG A 116      -8.891  13.254 -13.916  1.00 23.30           N  
ATOM    899  CA  ARG A 116      -9.923  14.115 -14.465  1.00 26.74           C  
ATOM    900  C   ARG A 116      -9.413  14.924 -15.677  1.00 28.68           C  
ATOM    901  O   ARG A 116     -10.204  15.273 -16.569  1.00 31.61           O  
ATOM    902  CB  ARG A 116     -10.521  15.009 -13.365  1.00 24.66           C  
ATOM    903  CG  ARG A 116     -11.739  15.822 -13.809  1.00 30.05           C  
ATOM    904  CD  ARG A 116     -12.808  14.971 -14.540  1.00 39.08           C  
ATOM    905  NE  ARG A 116     -13.324  13.844 -13.751  1.00 43.62           N  
ATOM    906  CZ  ARG A 116     -14.201  12.941 -14.204  1.00 46.63           C  
ATOM    907  NH1 ARG A 116     -14.654  12.997 -15.450  1.00 51.56           N  
ATOM    908  NH2 ARG A 116     -14.614  11.955 -13.412  1.00 45.86           N  
ATOM    909  N   SER A 117      -8.108  15.168 -15.729  1.00 28.45           N  
ATOM    910  CA  SER A 117      -7.490  15.920 -16.807  1.00 30.09           C  
ATOM    911  C   SER A 117      -7.383  15.200 -18.163  1.00 30.00           C  
ATOM    912  O   SER A 117      -7.271  15.878 -19.193  1.00 30.87           O  
ATOM    913  CB  SER A 117      -6.090  16.336 -16.379  1.00 32.34           C  
ATOM    914  OG  SER A 117      -5.296  15.190 -16.158  1.00 42.56           O  
ATOM    915  N   TYR A 118      -7.398  13.862 -18.184  1.00 24.62           N  
ATOM    916  CA  TYR A 118      -7.355  13.123 -19.449  1.00 21.86           C  
ATOM    917  C   TYR A 118      -8.616  13.370 -20.263  1.00 19.81           C  
ATOM    918  O   TYR A 118      -9.734  13.137 -19.788  1.00 18.36           O  
ATOM    919  CB  TYR A 118      -7.233  11.616 -19.242  1.00 22.58           C  
ATOM    920  CG  TYR A 118      -5.895  11.188 -18.697  1.00 18.71           C  
ATOM    921  CD1 TYR A 118      -4.748  11.348 -19.446  1.00 19.04           C  
ATOM    922  CD2 TYR A 118      -5.781  10.620 -17.422  1.00 21.06           C  
ATOM    923  CE1 TYR A 118      -3.525  10.990 -18.945  1.00 22.99           C  
ATOM    924  CE2 TYR A 118      -4.522  10.247 -16.919  1.00 20.71           C  
ATOM    925  CZ  TYR A 118      -3.424  10.444 -17.690  1.00 21.34           C  
ATOM    926  OH  TYR A 118      -2.191  10.082 -17.227  1.00 23.03           O  
ATOM    927  N   PRO A 119      -8.444  13.859 -21.494  1.00 19.69           N  
ATOM    928  CA  PRO A 119      -9.621  14.154 -22.315  1.00 19.66           C  
ATOM    929  C   PRO A 119     -10.570  12.965 -22.506  1.00 18.82           C  
ATOM    930  O   PRO A 119     -11.781  13.166 -22.624  1.00 17.29           O  
ATOM    931  CB  PRO A 119      -9.024  14.610 -23.660  1.00 20.86           C  
ATOM    932  CG  PRO A 119      -7.602  15.007 -23.357  1.00 21.65           C  
ATOM    933  CD  PRO A 119      -7.178  14.236 -22.156  1.00 22.52           C  
ATOM    934  N   PHE A 120     -10.050  11.741 -22.538  1.00 16.90           N  
ATOM    935  CA  PHE A 120     -10.946  10.592 -22.764  1.00 18.74           C  
ATOM    936  C   PHE A 120     -11.940  10.439 -21.632  1.00 18.76           C  
ATOM    937  O   PHE A 120     -12.996   9.873 -21.819  1.00 16.02           O  
ATOM    938  CB  PHE A 120     -10.193   9.268 -23.033  1.00 21.13           C  
ATOM    939  CG  PHE A 120      -9.603   8.630 -21.805  1.00 19.45           C  
ATOM    940  CD1 PHE A 120     -10.390   7.833 -20.970  1.00 20.14           C  
ATOM    941  CD2 PHE A 120      -8.280   8.812 -21.487  1.00 25.85           C  
ATOM    942  CE1 PHE A 120      -9.858   7.256 -19.843  1.00 27.81           C  
ATOM    943  CE2 PHE A 120      -7.748   8.233 -20.377  1.00 25.38           C  
ATOM    944  CZ  PHE A 120      -8.540   7.452 -19.542  1.00 25.70           C  
HETATM  945  N   MSE A 121     -11.639  10.987 -20.449  1.00 15.87           N  
HETATM  946  CA  MSE A 121     -12.638  10.937 -19.390  1.00 17.27           C  
HETATM  947  C   MSE A 121     -13.976  11.634 -19.717  1.00 16.03           C  
HETATM  948  O   MSE A 121     -15.017  11.282 -19.124  1.00 16.84           O  
HETATM  949  CB  MSE A 121     -12.046  11.480 -18.081  1.00 20.49           C  
HETATM  950  CG  MSE A 121     -10.860  10.696 -17.607  1.00 15.56           C  
HETATM  951 SE   MSE A 121     -11.390   8.945 -16.884  0.75 31.59          SE  
HETATM  952  CE  MSE A 121     -12.283   9.584 -15.260  1.00 23.76           C  
HETATM  953  N   MSE A 122     -13.969  12.596 -20.643  0.50 14.06           N  
HETATM  955  CA  MSE A 122     -15.200  13.223 -21.120  0.50 15.23           C  
HETATM  957  C   MSE A 122     -16.125  12.256 -21.858  0.50 13.83           C  
HETATM  959  O   MSE A 122     -17.294  12.579 -22.081  0.50 15.38           O  
HETATM  961  CB  MSE A 122     -14.886  14.403 -22.039  0.50 14.99           C  
HETATM  963  CG  MSE A 122     -14.113  15.525 -21.358  0.50 16.09           C  
HETATM  965 SE   MSE A 122     -15.161  17.167 -21.101  0.40 24.85          SE  
HETATM  967  CE  MSE A 122     -15.376  17.629 -22.986  0.50 12.71           C  
ATOM    969  N   ARG A 123     -15.607  11.090 -22.248  1.00 14.23           N  
ATOM    970  CA  ARG A 123     -16.421  10.065 -22.933  1.00 13.71           C  
ATOM    971  C   ARG A 123     -17.054   9.057 -21.980  1.00 13.37           C  
ATOM    972  O   ARG A 123     -17.800   8.169 -22.403  1.00 15.16           O  
ATOM    973  CB  ARG A 123     -15.592   9.284 -23.936  1.00 13.98           C  
ATOM    974  CG  ARG A 123     -14.955  10.139 -24.994  1.00 20.59           C  
ATOM    975  CD  ARG A 123     -14.386   9.281 -26.115  1.00 25.62           C  
ATOM    976  NE  ARG A 123     -13.468  10.090 -26.924  1.00 34.41           N  
ATOM    977  CZ  ARG A 123     -13.818  10.793 -28.006  1.00 32.00           C  
ATOM    978  NH1 ARG A 123     -15.069  10.785 -28.480  1.00 41.50           N  
ATOM    979  NH2 ARG A 123     -12.891  11.501 -28.639  1.00 30.97           N  
HETATM  980  N   MSE A 124     -16.707   9.151 -20.706  1.00 13.29           N  
HETATM  981  CA  MSE A 124     -17.210   8.228 -19.715  1.00 14.83           C  
HETATM  982  C   MSE A 124     -18.625   8.575 -19.299  1.00 15.00           C  
HETATM  983  O   MSE A 124     -18.906   9.679 -18.852  1.00 17.97           O  
HETATM  984  CB  MSE A 124     -16.275   8.133 -18.488  1.00 15.43           C  
HETATM  985  CG  MSE A 124     -14.833   7.766 -18.752  1.00 18.54           C  
HETATM  986 SE   MSE A 124     -14.714   5.952 -19.419  0.75 24.91          SE  
HETATM  987  CE  MSE A 124     -12.844   5.663 -19.767  1.00 29.05           C  
ATOM    988  N   ALA A 125     -19.505   7.598 -19.436  1.00 15.57           N  
ATOM    989  CA  ALA A 125     -20.909   7.740 -19.088  1.00 13.87           C  
ATOM    990  C   ALA A 125     -21.154   7.562 -17.593  1.00 15.15           C  
ATOM    991  O   ALA A 125     -22.154   8.035 -17.063  1.00 18.41           O  
ATOM    992  CB  ALA A 125     -21.740   6.717 -19.872  1.00 15.89           C  
ATOM    993  N   VAL A 126     -20.256   6.840 -16.934  1.00 12.82           N  
ATOM    994  CA  VAL A 126     -20.351   6.544 -15.500  1.00 12.86           C  
ATOM    995  C   VAL A 126     -18.944   6.267 -14.988  1.00 11.89           C  
ATOM    996  O   VAL A 126     -18.125   5.739 -15.719  1.00 13.48           O  
ATOM    997  CB  VAL A 126     -21.264   5.293 -15.230  1.00 14.01           C  
ATOM    998  CG1 VAL A 126     -20.682   4.029 -15.831  1.00 12.94           C  
ATOM    999  CG2 VAL A 126     -21.516   5.113 -13.748  1.00 18.37           C  
ATOM   1000  N   THR A 127     -18.668   6.722 -13.767  1.00 13.06           N  
ATOM   1001  CA  THR A 127     -17.481   6.293 -13.028  1.00 13.97           C  
ATOM   1002  C   THR A 127     -17.955   5.875 -11.632  1.00 12.56           C  
ATOM   1003  O   THR A 127     -18.706   6.588 -10.968  1.00 14.92           O  
ATOM   1004  CB  THR A 127     -16.369   7.359 -12.931  1.00 15.44           C  
ATOM   1005  OG1 THR A 127     -16.834   8.493 -12.207  1.00 16.66           O  
ATOM   1006  CG2 THR A 127     -15.905   7.817 -14.324  1.00 17.29           C  
ATOM   1007  N   ILE A 128     -17.569   4.658 -11.247  1.00 11.33           N  
ATOM   1008  CA  ILE A 128     -17.809   4.130  -9.924  1.00 11.82           C  
ATOM   1009  C   ILE A 128     -16.482   3.963  -9.240  1.00 13.55           C  
ATOM   1010  O   ILE A 128     -15.617   3.215  -9.722  1.00 14.04           O  
ATOM   1011  CB  ILE A 128     -18.491   2.742 -10.036  1.00 13.42           C  
ATOM   1012  CG1 ILE A 128     -19.879   2.889 -10.653  1.00 13.22           C  
ATOM   1013  CG2 ILE A 128     -18.664   2.102  -8.691  1.00 15.90           C  
ATOM   1014  CD1 ILE A 128     -20.869   3.790  -9.900  1.00 18.97           C  
ATOM   1015  N   SER A 129     -16.335   4.660  -8.116  1.00 13.46           N  
ATOM   1016  CA  SER A 129     -15.149   4.589  -7.281  1.00 13.74           C  
ATOM   1017  C   SER A 129     -15.517   3.840  -6.017  1.00 14.94           C  
ATOM   1018  O   SER A 129     -16.682   3.472  -5.792  1.00 13.26           O  
ATOM   1019  CB  SER A 129     -14.655   5.994  -6.880  1.00 16.95           C  
ATOM   1020  OG  SER A 129     -15.491   6.611  -5.870  1.00 16.63           O  
ATOM   1021  N   ALA A 130     -14.530   3.651  -5.163  1.00 14.02           N  
ATOM   1022  CA  ALA A 130     -14.729   2.975  -3.884  1.00 16.93           C  
ATOM   1023  C   ALA A 130     -15.800   3.665  -3.068  1.00 20.68           C  
ATOM   1024  O   ALA A 130     -16.535   3.017  -2.308  1.00 23.17           O  
ATOM   1025  CB  ALA A 130     -13.422   2.947  -3.115  1.00 20.65           C  
ATOM   1026  N   ASP A 131     -15.920   4.976  -3.253  1.00 20.48           N  
ATOM   1027  CA  ASP A 131     -16.847   5.800  -2.476  1.00 21.47           C  
ATOM   1028  C   ASP A 131     -18.310   5.714  -2.910  1.00 20.78           C  
ATOM   1029  O   ASP A 131     -19.177   6.304  -2.270  1.00 23.04           O  
ATOM   1030  CB  ASP A 131     -16.360   7.269  -2.496  1.00 21.56           C  
ATOM   1031  CG  ASP A 131     -15.019   7.439  -1.754  1.00 30.10           C  
ATOM   1032  OD1 ASP A 131     -15.007   7.249  -0.517  1.00 33.82           O  
ATOM   1033  OD2 ASP A 131     -13.969   7.695  -2.378  1.00 27.63           O  
ATOM   1034  N   ASP A 132     -18.604   4.992  -3.983  1.00 18.36           N  
ATOM   1035  CA  ASP A 132     -19.919   5.079  -4.583  1.00 17.70           C  
ATOM   1036  C   ASP A 132     -20.839   3.897  -4.286  1.00 22.46           C  
ATOM   1037  O   ASP A 132     -22.004   3.911  -4.663  1.00 23.23           O  
ATOM   1038  CB  ASP A 132     -19.785   5.258  -6.091  1.00 17.00           C  
ATOM   1039  CG  ASP A 132     -19.146   6.570  -6.444  1.00 20.41           C  
ATOM   1040  OD1 ASP A 132     -19.626   7.611  -5.918  1.00 26.16           O  
ATOM   1041  OD2 ASP A 132     -18.148   6.562  -7.184  1.00 18.93           O  
ATOM   1042  N   THR A 133     -20.308   2.850  -3.669  1.00 23.21           N  
ATOM   1043  CA  THR A 133     -21.146   1.741  -3.196  1.00 22.16           C  
ATOM   1044  C   THR A 133     -20.540   1.255  -1.881  1.00 23.82           C  
ATOM   1045  O   THR A 133     -19.348   1.459  -1.629  1.00 19.86           O  
ATOM   1046  CB  THR A 133     -21.166   0.543  -4.185  1.00 25.62           C  
ATOM   1047  OG1 THR A 133     -19.939  -0.191  -4.062  1.00 24.54           O  
ATOM   1048  CG2 THR A 133     -21.345   1.003  -5.615  1.00 21.10           C  
ATOM   1049  N   PRO A 134     -21.342   0.583  -1.048  1.00 23.22           N  
ATOM   1050  CA  PRO A 134     -20.812   0.060   0.204  1.00 24.06           C  
ATOM   1051  C   PRO A 134     -20.007  -1.242   0.102  1.00 23.28           C  
ATOM   1052  O   PRO A 134     -19.560  -1.755   1.126  1.00 25.95           O  
ATOM   1053  CB  PRO A 134     -22.081  -0.157   1.028  1.00 21.83           C  
ATOM   1054  CG  PRO A 134     -23.083  -0.515   0.043  1.00 29.73           C  
ATOM   1055  CD  PRO A 134     -22.773   0.299  -1.185  1.00 24.58           C  
ATOM   1056  N   LYS A 135     -19.791  -1.763  -1.106  1.00 22.71           N  
ATOM   1057  CA  LYS A 135     -19.044  -2.995  -1.271  1.00 22.39           C  
ATOM   1058  C   LYS A 135     -17.899  -2.737  -2.228  1.00 22.09           C  
ATOM   1059  O   LYS A 135     -17.894  -1.753  -2.958  1.00 25.64           O  
ATOM   1060  CB  LYS A 135     -19.931  -4.097  -1.849  1.00 23.90           C  
ATOM   1061  CG  LYS A 135     -21.264  -4.316  -1.136  1.00 28.04           C  
ATOM   1062  CD  LYS A 135     -21.164  -5.296   0.007  1.00 32.10           C  
ATOM   1063  N   ARG A 136     -16.919  -3.610  -2.195  1.00 20.69           N  
ATOM   1064  CA  ARG A 136     -15.712  -3.436  -2.994  1.00 20.24           C  
ATOM   1065  C   ARG A 136     -15.544  -4.677  -3.843  1.00 17.88           C  
ATOM   1066  O   ARG A 136     -15.989  -5.762  -3.454  1.00 16.78           O  
ATOM   1067  CB  ARG A 136     -14.504  -3.255  -2.096  1.00 24.43           C  
ATOM   1068  CG  ARG A 136     -14.478  -1.942  -1.310  1.00 29.25           C  
ATOM   1069  CD  ARG A 136     -14.390  -0.695  -2.240  1.00 30.14           C  
ATOM   1070  N   LYS A 137     -14.921  -4.503  -5.006  1.00 17.25           N  
ATOM   1071  CA  LYS A 137     -14.490  -5.645  -5.800  1.00 16.93           C  
ATOM   1072  C   LYS A 137     -13.729  -6.605  -4.877  1.00 17.97           C  
ATOM   1073  O   LYS A 137     -12.937  -6.161  -4.065  1.00 16.90           O  
ATOM   1074  CB  LYS A 137     -13.585  -5.176  -6.958  1.00 14.89           C  
ATOM   1075  CG  LYS A 137     -14.301  -4.257  -7.945  1.00 17.55           C  
ATOM   1076  CD  LYS A 137     -13.497  -4.003  -9.234  1.00 18.66           C  
ATOM   1077  CE  LYS A 137     -12.510  -2.885  -9.091  1.00 18.20           C  
ATOM   1078  NZ  LYS A 137     -11.699  -2.574 -10.328  1.00 23.61           N  
ATOM   1079  N   PRO A 138     -13.885  -7.929  -5.046  1.00 17.02           N  
ATOM   1080  CA  PRO A 138     -14.592  -8.675  -6.070  1.00 16.21           C  
ATOM   1081  C   PRO A 138     -16.072  -8.886  -5.854  1.00 15.52           C  
ATOM   1082  O   PRO A 138     -16.688  -9.646  -6.584  1.00 16.50           O  
ATOM   1083  CB  PRO A 138     -13.858 -10.019  -6.088  1.00 16.56           C  
ATOM   1084  CG  PRO A 138     -13.439 -10.206  -4.669  1.00 17.00           C  
ATOM   1085  CD  PRO A 138     -13.135  -8.827  -4.150  1.00 15.98           C  
ATOM   1086  N   ASP A 139     -16.669  -8.179  -4.908  1.00 14.22           N  
ATOM   1087  CA  ASP A 139     -18.138  -8.167  -4.860  1.00 15.73           C  
ATOM   1088  C   ASP A 139     -18.665  -7.576  -6.198  1.00 15.37           C  
ATOM   1089  O   ASP A 139     -18.034  -6.643  -6.759  1.00 15.66           O  
ATOM   1090  CB  ASP A 139     -18.649  -7.335  -3.688  1.00 18.87           C  
ATOM   1091  CG  ASP A 139     -20.124  -7.537  -3.431  1.00 20.61           C  
ATOM   1092  OD1 ASP A 139     -20.996  -6.950  -4.118  1.00 20.45           O  
ATOM   1093  OD2 ASP A 139     -20.428  -8.355  -2.538  1.00 21.89           O  
ATOM   1094  N   PRO A 140     -19.756  -8.137  -6.740  1.00 15.33           N  
ATOM   1095  CA  PRO A 140     -20.272  -7.633  -8.021  1.00 14.75           C  
ATOM   1096  C   PRO A 140     -20.971  -6.264  -7.983  1.00 16.46           C  
ATOM   1097  O   PRO A 140     -21.156  -5.644  -9.030  1.00 15.42           O  
ATOM   1098  CB  PRO A 140     -21.265  -8.711  -8.442  1.00 17.71           C  
ATOM   1099  CG  PRO A 140     -21.706  -9.348  -7.144  1.00 15.89           C  
ATOM   1100  CD  PRO A 140     -20.503  -9.331  -6.282  1.00 15.07           C  
ATOM   1101  N   LEU A 141     -21.353  -5.790  -6.803  1.00 14.52           N  
ATOM   1102  CA  LEU A 141     -22.170  -4.579  -6.674  1.00 14.91           C  
ATOM   1103  C   LEU A 141     -21.594  -3.354  -7.420  1.00 15.31           C  
ATOM   1104  O   LEU A 141     -22.347  -2.665  -8.097  1.00 15.95           O  
ATOM   1105  CB  LEU A 141     -22.348  -4.223  -5.219  1.00 15.95           C  
ATOM   1106  CG  LEU A 141     -23.257  -3.014  -4.970  1.00 17.18           C  
ATOM   1107  CD1 LEU A 141     -24.597  -3.305  -5.575  1.00 15.42           C  
ATOM   1108  CD2 LEU A 141     -23.335  -2.707  -3.491  1.00 15.72           C  
ATOM   1109  N   PRO A 142     -20.276  -3.074  -7.292  1.00 15.53           N  
ATOM   1110  CA  PRO A 142     -19.806  -1.887  -8.017  1.00 15.91           C  
ATOM   1111  C   PRO A 142     -20.004  -1.989  -9.558  1.00 15.57           C  
ATOM   1112  O   PRO A 142     -20.372  -1.004 -10.186  1.00 15.07           O  
ATOM   1113  CB  PRO A 142     -18.313  -1.829  -7.663  1.00 16.50           C  
ATOM   1114  CG  PRO A 142     -18.153  -2.696  -6.420  1.00 19.05           C  
ATOM   1115  CD  PRO A 142     -19.190  -3.740  -6.535  1.00 15.82           C  
ATOM   1116  N   LEU A 143     -19.746  -3.162 -10.148  1.00 15.10           N  
ATOM   1117  CA  LEU A 143     -19.972  -3.355 -11.583  1.00 11.99           C  
ATOM   1118  C   LEU A 143     -21.454  -3.282 -11.963  1.00 12.07           C  
ATOM   1119  O   LEU A 143     -21.830  -2.635 -12.931  1.00 13.75           O  
ATOM   1120  CB  LEU A 143     -19.357  -4.680 -12.041  1.00 13.46           C  
ATOM   1121  CG  LEU A 143     -19.496  -5.066 -13.494  1.00 12.38           C  
ATOM   1122  CD1 LEU A 143     -19.116  -3.908 -14.403  1.00 14.63           C  
ATOM   1123  CD2 LEU A 143     -18.662  -6.297 -13.806  1.00 15.32           C  
ATOM   1124  N   LEU A 144     -22.294  -3.915 -11.164  1.00 13.33           N  
ATOM   1125  CA  LEU A 144     -23.701  -3.916 -11.448  1.00 12.66           C  
ATOM   1126  C   LEU A 144     -24.264  -2.494 -11.258  1.00 13.21           C  
ATOM   1127  O   LEU A 144     -25.165  -2.100 -11.966  1.00 11.44           O  
ATOM   1128  CB  LEU A 144     -24.409  -4.918 -10.545  1.00 12.93           C  
ATOM   1129  CG  LEU A 144     -24.133  -6.360 -10.932  1.00 16.34           C  
ATOM   1130  CD1 LEU A 144     -24.728  -7.312  -9.892  1.00 20.98           C  
ATOM   1131  CD2 LEU A 144     -24.678  -6.681 -12.310  1.00 18.09           C  
ATOM   1132  N   THR A 145     -23.719  -1.719 -10.329  1.00 13.12           N  
ATOM   1133  CA  THR A 145     -24.187  -0.357 -10.130  1.00 12.79           C  
ATOM   1134  C   THR A 145     -23.882   0.487 -11.354  1.00 13.54           C  
ATOM   1135  O   THR A 145     -24.723   1.221 -11.847  1.00 14.07           O  
ATOM   1136  CB  THR A 145     -23.589   0.221  -8.840  1.00 15.64           C  
ATOM   1137  OG1 THR A 145     -24.043  -0.581  -7.734  1.00 15.08           O  
ATOM   1138  CG2 THR A 145     -24.020   1.650  -8.628  1.00 18.22           C  
ATOM   1139  N   ALA A 146     -22.689   0.323 -11.899  1.00 11.04           N  
ATOM   1140  CA  ALA A 146     -22.283   1.070 -13.084  1.00 11.91           C  
ATOM   1141  C   ALA A 146     -23.203   0.754 -14.233  1.00 13.31           C  
ATOM   1142  O   ALA A 146     -23.704   1.644 -14.922  1.00 12.16           O  
ATOM   1143  CB  ALA A 146     -20.802   0.740 -13.457  1.00 12.78           C  
ATOM   1144  N   LEU A 147     -23.482  -0.529 -14.429  1.00 12.79           N  
ATOM   1145  CA  LEU A 147     -24.328  -0.908 -15.547  1.00 10.20           C  
ATOM   1146  C   LEU A 147     -25.794  -0.439 -15.406  1.00 13.54           C  
ATOM   1147  O   LEU A 147     -26.404  -0.009 -16.364  1.00 12.84           O  
ATOM   1148  CB  LEU A 147     -24.282  -2.415 -15.786  1.00 12.24           C  
ATOM   1149  CG  LEU A 147     -22.937  -2.969 -16.196  1.00 13.17           C  
ATOM   1150  CD1 LEU A 147     -22.988  -4.461 -16.222  1.00 13.99           C  
ATOM   1151  CD2 LEU A 147     -22.511  -2.341 -17.545  1.00 17.45           C  
ATOM   1152  N   GLU A 148     -26.304  -0.417 -14.187  1.00 13.40           N  
ATOM   1153  CA  GLU A 148     -27.629   0.118 -13.943  1.00 15.71           C  
ATOM   1154  C   GLU A 148     -27.698   1.614 -14.310  1.00 14.29           C  
ATOM   1155  O   GLU A 148     -28.675   2.064 -14.880  1.00 17.15           O  
ATOM   1156  CB  GLU A 148     -28.017  -0.065 -12.478  1.00 18.00           C  
ATOM   1157  CG  GLU A 148     -29.491   0.038 -12.238  1.00 27.10           C  
ATOM   1158  N   LYS A 149     -26.639   2.352 -13.993  1.00 12.55           N  
ATOM   1159  CA  LYS A 149     -26.576   3.797 -14.261  1.00 13.30           C  
ATOM   1160  C   LYS A 149     -26.554   4.137 -15.760  1.00 14.64           C  
ATOM   1161  O   LYS A 149     -27.003   5.209 -16.134  1.00 17.34           O  
ATOM   1162  CB  LYS A 149     -25.389   4.466 -13.528  1.00 13.39           C  
ATOM   1163  CG  LYS A 149     -25.573   4.593 -12.041  1.00 16.84           C  
ATOM   1164  CD  LYS A 149     -24.323   5.139 -11.368  1.00 20.08           C  
ATOM   1165  N   VAL A 150     -26.024   3.247 -16.602  1.00 16.69           N  
ATOM   1166  CA  VAL A 150     -26.045   3.443 -18.067  1.00 15.00           C  
ATOM   1167  C   VAL A 150     -27.136   2.609 -18.756  1.00 15.94           C  
ATOM   1168  O   VAL A 150     -27.203   2.589 -19.986  1.00 18.62           O  
ATOM   1169  CB  VAL A 150     -24.672   3.224 -18.695  1.00 17.37           C  
ATOM   1170  CG1 VAL A 150     -23.682   4.213 -18.102  1.00 18.13           C  
ATOM   1171  CG2 VAL A 150     -24.192   1.796 -18.517  1.00 17.43           C  
ATOM   1172  N   ASN A 151     -28.042   2.013 -17.968  1.00 15.48           N  
ATOM   1173  CA  ASN A 151     -29.144   1.223 -18.491  0.70 17.29           C  
ATOM   1175  C   ASN A 151     -28.698   0.169 -19.498  1.00 17.56           C  
ATOM   1176  O   ASN A 151     -29.223   0.099 -20.609  1.00 19.32           O  
ATOM   1177  CB  ASN A 151     -30.189   2.136 -19.140  0.70 16.45           C  
ATOM   1179  CG  ASN A 151     -30.778   3.132 -18.166  0.70 25.25           C  
ATOM   1181  OD1 ASN A 151     -30.666   4.340 -18.373  0.70 42.49           O  
ATOM   1183  ND2 ASN A 151     -31.399   2.640 -17.099  0.70 24.92           N  
ATOM   1185  N   VAL A 152     -27.724  -0.641 -19.108  1.00 14.07           N  
ATOM   1186  CA  VAL A 152     -27.264  -1.746 -19.921  1.00 13.32           C  
ATOM   1187  C   VAL A 152     -27.270  -2.988 -19.064  1.00 14.68           C  
ATOM   1188  O   VAL A 152     -26.803  -2.993 -17.943  1.00 14.13           O  
ATOM   1189  CB  VAL A 152     -25.850  -1.493 -20.531  1.00 12.59           C  
ATOM   1190  CG1 VAL A 152     -25.352  -2.754 -21.235  1.00 16.66           C  
ATOM   1191  CG2 VAL A 152     -25.929  -0.317 -21.471  1.00 14.11           C  
ATOM   1192  N   ALA A 153     -27.858  -4.045 -19.598  1.00 15.79           N  
ATOM   1193  CA  ALA A 153     -27.940  -5.318 -18.911  1.00 14.25           C  
ATOM   1194  C   ALA A 153     -26.573  -6.026 -18.872  1.00 11.46           C  
ATOM   1195  O   ALA A 153     -25.763  -5.887 -19.807  1.00 12.97           O  
ATOM   1196  CB  ALA A 153     -28.941  -6.175 -19.628  1.00 12.82           C  
ATOM   1197  N   PRO A 154     -26.334  -6.838 -17.827  1.00 11.26           N  
ATOM   1198  CA  PRO A 154     -25.055  -7.551 -17.673  1.00 14.69           C  
ATOM   1199  C   PRO A 154     -24.657  -8.339 -18.914  1.00 14.05           C  
ATOM   1200  O   PRO A 154     -23.497  -8.343 -19.267  1.00 14.87           O  
ATOM   1201  CB  PRO A 154     -25.309  -8.476 -16.471  1.00 16.98           C  
ATOM   1202  CG  PRO A 154     -26.392  -7.811 -15.723  1.00 16.26           C  
ATOM   1203  CD  PRO A 154     -27.250  -7.122 -16.710  1.00 14.55           C  
ATOM   1204  N   GLN A 155     -25.619  -8.963 -19.578  1.00 14.69           N  
ATOM   1205  CA  GLN A 155     -25.313  -9.777 -20.772  1.00 14.28           C  
ATOM   1206  C   GLN A 155     -24.762  -8.956 -21.924  1.00 13.37           C  
ATOM   1207  O   GLN A 155     -24.136  -9.517 -22.840  1.00 16.02           O  
ATOM   1208  CB  GLN A 155     -26.580 -10.545 -21.255  1.00 14.29           C  
ATOM   1209  CG  GLN A 155     -27.802  -9.725 -21.610  1.00 13.46           C  
ATOM   1210  CD  GLN A 155     -28.731  -9.543 -20.445  1.00 14.48           C  
ATOM   1211  OE1 GLN A 155     -28.302  -9.629 -19.292  1.00 19.12           O  
ATOM   1212  NE2 GLN A 155     -29.997  -9.302 -20.718  1.00 22.28           N  
ATOM   1213  N   ASN A 156     -24.989  -7.640 -21.888  1.00 12.92           N  
ATOM   1214  CA  ASN A 156     -24.586  -6.767 -22.981  1.00 12.96           C  
ATOM   1215  C   ASN A 156     -23.396  -5.864 -22.666  1.00 11.39           C  
ATOM   1216  O   ASN A 156     -23.149  -4.890 -23.356  1.00 12.88           O  
ATOM   1217  CB  ASN A 156     -25.770  -5.927 -23.374  1.00 12.27           C  
ATOM   1218  CG  ASN A 156     -26.910  -6.760 -23.912  1.00 16.89           C  
ATOM   1219  OD1 ASN A 156     -26.682  -7.681 -24.691  1.00 24.86           O  
ATOM   1220  ND2 ASN A 156     -28.120  -6.466 -23.483  1.00 18.23           N  
ATOM   1221  N   ALA A 157     -22.652  -6.240 -21.626  1.00 12.95           N  
ATOM   1222  CA  ALA A 157     -21.535  -5.512 -21.139  1.00 13.42           C  
ATOM   1223  C   ALA A 157     -20.243  -6.354 -21.151  1.00 12.56           C  
ATOM   1224  O   ALA A 157     -20.276  -7.611 -21.058  1.00 13.26           O  
ATOM   1225  CB  ALA A 157     -21.853  -5.033 -19.777  1.00 14.67           C  
ATOM   1226  N   LEU A 158     -19.106  -5.669 -21.269  1.00 10.10           N  
ATOM   1227  CA  LEU A 158     -17.783  -6.294 -21.146  1.00 10.13           C  
ATOM   1228  C   LEU A 158     -16.992  -5.473 -20.132  1.00 12.17           C  
ATOM   1229  O   LEU A 158     -16.877  -4.232 -20.276  1.00 12.37           O  
ATOM   1230  CB  LEU A 158     -17.065  -6.307 -22.478  1.00 10.31           C  
ATOM   1231  CG  LEU A 158     -15.728  -7.028 -22.556  1.00 10.70           C  
ATOM   1232  CD1 LEU A 158     -15.819  -8.485 -22.321  1.00 14.35           C  
ATOM   1233  CD2 LEU A 158     -15.117  -6.731 -23.874  1.00 14.00           C  
ATOM   1234  N   PHE A 159     -16.447  -6.147 -19.127  1.00 13.22           N  
ATOM   1235  CA  PHE A 159     -15.544  -5.521 -18.145  1.00 11.89           C  
ATOM   1236  C   PHE A 159     -14.117  -5.863 -18.554  1.00 13.04           C  
ATOM   1237  O   PHE A 159     -13.739  -7.031 -18.623  1.00 12.38           O  
ATOM   1238  CB  PHE A 159     -15.899  -6.040 -16.753  1.00 12.85           C  
ATOM   1239  CG  PHE A 159     -15.188  -5.380 -15.618  1.00 13.31           C  
ATOM   1240  CD1 PHE A 159     -14.814  -4.028 -15.633  1.00 13.96           C  
ATOM   1241  CD2 PHE A 159     -14.944  -6.110 -14.432  1.00 14.30           C  
ATOM   1242  CE1 PHE A 159     -14.148  -3.453 -14.566  1.00 15.80           C  
ATOM   1243  CE2 PHE A 159     -14.321  -5.495 -13.355  1.00 16.11           C  
ATOM   1244  CZ  PHE A 159     -13.910  -4.168 -13.441  1.00 13.54           C  
ATOM   1245  N   ILE A 160     -13.328  -4.822 -18.775  1.00 12.36           N  
ATOM   1246  CA  ILE A 160     -11.962  -4.943 -19.226  1.00 12.34           C  
ATOM   1247  C   ILE A 160     -11.022  -4.574 -18.103  1.00 15.06           C  
ATOM   1248  O   ILE A 160     -11.085  -3.470 -17.546  1.00 14.06           O  
ATOM   1249  CB  ILE A 160     -11.690  -4.067 -20.465  1.00 11.84           C  
ATOM   1250  CG1 ILE A 160     -12.672  -4.483 -21.569  1.00 16.16           C  
ATOM   1251  CG2 ILE A 160     -10.229  -4.157 -20.914  1.00 15.51           C  
ATOM   1252  CD1 ILE A 160     -12.649  -3.623 -22.777  1.00 15.43           C  
ATOM   1253  N   GLY A 161     -10.181  -5.525 -17.733  1.00 13.64           N  
ATOM   1254  CA  GLY A 161      -9.202  -5.298 -16.688  1.00 13.00           C  
ATOM   1255  C   GLY A 161      -8.100  -6.350 -16.671  1.00 13.32           C  
ATOM   1256  O   GLY A 161      -7.991  -7.159 -17.598  1.00 12.79           O  
ATOM   1257  N   ASP A 162      -7.288  -6.352 -15.620  1.00 15.22           N  
ATOM   1258  CA  ASP A 162      -6.145  -7.294 -15.582  1.00 14.95           C  
ATOM   1259  C   ASP A 162      -5.841  -7.766 -14.165  1.00 14.16           C  
ATOM   1260  O   ASP A 162      -4.698  -7.730 -13.700  1.00 16.84           O  
ATOM   1261  CB  ASP A 162      -4.896  -6.704 -16.243  1.00 14.63           C  
ATOM   1262  CG  ASP A 162      -3.814  -7.738 -16.472  1.00 18.96           C  
ATOM   1263  OD1 ASP A 162      -4.113  -8.880 -16.895  1.00 19.33           O  
ATOM   1264  OD2 ASP A 162      -2.643  -7.387 -16.259  1.00 19.08           O  
ATOM   1265  N   SER A 163      -6.877  -8.146 -13.437  1.00 14.12           N  
ATOM   1266  CA  SER A 163      -6.685  -8.748 -12.112  1.00 12.26           C  
ATOM   1267  C   SER A 163      -7.685  -9.861 -11.879  1.00 13.52           C  
ATOM   1268  O   SER A 163      -8.758  -9.851 -12.447  1.00 14.04           O  
ATOM   1269  CB  SER A 163      -6.830  -7.700 -10.995  1.00 13.03           C  
ATOM   1270  OG  SER A 163      -8.167  -7.264 -10.936  1.00 18.81           O  
ATOM   1271  N   VAL A 164      -7.325 -10.788 -10.993  1.00 14.56           N  
ATOM   1272  CA  VAL A 164      -8.249 -11.824 -10.566  1.00 13.76           C  
ATOM   1273  C   VAL A 164      -9.479 -11.223  -9.871  1.00 13.27           C  
ATOM   1274  O   VAL A 164     -10.602 -11.663 -10.079  1.00 15.03           O  
ATOM   1275  CB  VAL A 164      -7.531 -12.788  -9.617  1.00 16.34           C  
ATOM   1276  CG1 VAL A 164      -8.502 -13.717  -8.937  1.00 19.45           C  
ATOM   1277  CG2 VAL A 164      -6.441 -13.611 -10.375  1.00 16.09           C  
ATOM   1278  N   SER A 165      -9.281 -10.178  -9.085  1.00 13.99           N  
ATOM   1279  CA  SER A 165     -10.374  -9.499  -8.416  0.70 13.78           C  
ATOM   1281  C   SER A 165     -11.377  -8.981  -9.454  1.00 13.71           C  
ATOM   1282  O   SER A 165     -12.583  -9.165  -9.314  1.00 15.71           O  
ATOM   1283  CB  SER A 165      -9.834  -8.385  -7.494  0.70 14.00           C  
ATOM   1285  OG  SER A 165     -10.856  -7.604  -6.902  0.70 21.44           O  
ATOM   1287  N   ASP A 166     -10.868  -8.393 -10.539  1.00 13.80           N  
ATOM   1288  CA  ASP A 166     -11.765  -7.904 -11.597  1.00 13.01           C  
ATOM   1289  C   ASP A 166     -12.526  -9.066 -12.268  1.00 11.56           C  
ATOM   1290  O   ASP A 166     -13.712  -8.976 -12.596  1.00 13.01           O  
ATOM   1291  CB  ASP A 166     -10.991  -7.153 -12.675  1.00 13.10           C  
ATOM   1292  CG  ASP A 166     -10.452  -5.795 -12.211  1.00 20.19           C  
ATOM   1293  OD1 ASP A 166     -10.943  -5.250 -11.196  1.00 18.57           O  
ATOM   1294  OD2 ASP A 166      -9.544  -5.270 -12.916  1.00 22.04           O  
ATOM   1295  N   GLU A 167     -11.788 -10.162 -12.514  1.00 11.64           N  
ATOM   1296  CA  GLU A 167     -12.352 -11.353 -13.103  1.00 12.51           C  
ATOM   1297  C   GLU A 167     -13.442 -11.925 -12.231  1.00 13.55           C  
ATOM   1298  O   GLU A 167     -14.508 -12.265 -12.741  1.00 13.92           O  
ATOM   1299  CB  GLU A 167     -11.274 -12.397 -13.353  1.00 15.33           C  
ATOM   1300  CG  GLU A 167     -10.404 -12.038 -14.497  1.00 13.33           C  
ATOM   1301  CD  GLU A 167      -9.180 -12.887 -14.648  1.00 19.18           C  
ATOM   1302  OE1 GLU A 167      -8.795 -13.533 -13.655  1.00 16.94           O  
ATOM   1303  OE2 GLU A 167      -8.638 -12.921 -15.785  1.00 15.88           O  
ATOM   1304  N   GLN A 168     -13.201 -12.005 -10.934  1.00 13.13           N  
ATOM   1305  CA  GLN A 168     -14.213 -12.509 -10.022  1.00 12.93           C  
ATOM   1306  C   GLN A 168     -15.428 -11.595  -9.894  1.00 12.67           C  
ATOM   1307  O   GLN A 168     -16.549 -12.071  -9.751  1.00 14.37           O  
ATOM   1308  CB  GLN A 168     -13.586 -12.796  -8.658  1.00 12.97           C  
ATOM   1309  CG  GLN A 168     -12.629 -13.984  -8.680  1.00 13.85           C  
ATOM   1310  CD  GLN A 168     -11.879 -14.182  -7.351  1.00 14.70           C  
ATOM   1311  OE1 GLN A 168     -11.962 -13.333  -6.436  1.00 15.57           O  
ATOM   1312  NE2 GLN A 168     -11.136 -15.301  -7.241  1.00 17.10           N  
ATOM   1313  N   THR A 169     -15.190 -10.280  -9.936  1.00 12.41           N  
ATOM   1314  CA  THR A 169     -16.282  -9.292  -9.962  1.00 12.91           C  
ATOM   1315  C   THR A 169     -17.201  -9.571 -11.140  1.00 12.60           C  
ATOM   1316  O   THR A 169     -18.448  -9.624 -11.017  1.00 12.70           O  
ATOM   1317  CB  THR A 169     -15.718  -7.873 -10.114  1.00 12.56           C  
ATOM   1318  OG1 THR A 169     -14.823  -7.591  -9.039  1.00 16.12           O  
ATOM   1319  CG2 THR A 169     -16.843  -6.805 -10.116  1.00 15.10           C  
ATOM   1320  N   ALA A 170     -16.600  -9.725 -12.310  1.00 13.08           N  
ATOM   1321  CA  ALA A 170     -17.351  -9.952 -13.544  1.00 13.95           C  
ATOM   1322  C   ALA A 170     -18.159 -11.270 -13.510  1.00 12.60           C  
ATOM   1323  O   ALA A 170     -19.347 -11.333 -13.876  1.00 15.31           O  
ATOM   1324  CB  ALA A 170     -16.380  -9.936 -14.725  1.00 12.20           C  
ATOM   1325  N   GLN A 171     -17.478 -12.330 -13.069  1.00 14.34           N  
ATOM   1326  CA  GLN A 171     -18.130 -13.654 -12.957  1.00 15.12           C  
ATOM   1327  C   GLN A 171     -19.336 -13.552 -12.043  1.00 14.46           C  
ATOM   1328  O   GLN A 171     -20.418 -14.038 -12.381  1.00 15.13           O  
ATOM   1329  CB  GLN A 171     -17.163 -14.704 -12.403  1.00 14.69           C  
ATOM   1330  CG  GLN A 171     -16.110 -15.196 -13.391  1.00 29.11           C  
ATOM   1331  N   ALA A 172     -19.154 -12.899 -10.895  1.00 13.42           N  
ATOM   1332  CA  ALA A 172     -20.205 -12.771  -9.913  1.00 13.21           C  
ATOM   1333  C   ALA A 172     -21.393 -11.955 -10.470  1.00 15.00           C  
ATOM   1334  O   ALA A 172     -22.549 -12.207 -10.178  1.00 16.07           O  
ATOM   1335  CB  ALA A 172     -19.672 -12.163  -8.634  1.00 13.95           C  
ATOM   1336  N   ALA A 173     -21.057 -10.967 -11.294  1.00 13.07           N  
ATOM   1337  CA  ALA A 173     -22.045 -10.112 -11.937  1.00 14.36           C  
ATOM   1338  C   ALA A 173     -22.709 -10.708 -13.179  1.00 14.68           C  
ATOM   1339  O   ALA A 173     -23.663 -10.105 -13.711  1.00 14.00           O  
ATOM   1340  CB  ALA A 173     -21.386  -8.816 -12.297  1.00 13.64           C  
ATOM   1341  N   ASN A 174     -22.236 -11.875 -13.652  1.00 13.09           N  
ATOM   1342  CA  ASN A 174     -22.683 -12.450 -14.932  1.00 13.22           C  
ATOM   1343  C   ASN A 174     -22.395 -11.501 -16.124  1.00 14.97           C  
ATOM   1344  O   ASN A 174     -23.215 -11.315 -17.033  1.00 16.04           O  
ATOM   1345  CB  ASN A 174     -24.158 -12.872 -14.885  1.00 14.10           C  
ATOM   1346  CG  ASN A 174     -24.400 -14.064 -13.977  1.00 22.15           C  
ATOM   1347  OD1 ASN A 174     -23.568 -14.964 -13.896  1.00 22.89           O  
ATOM   1348  ND2 ASN A 174     -25.524 -14.067 -13.277  1.00 29.30           N  
ATOM   1349  N   VAL A 175     -21.217 -10.903 -16.060  1.00 10.95           N  
ATOM   1350  CA  VAL A 175     -20.716  -9.987 -17.092  1.00 10.98           C  
ATOM   1351  C   VAL A 175     -19.452 -10.616 -17.693  1.00 10.67           C  
ATOM   1352  O   VAL A 175     -18.575 -11.056 -16.966  1.00 14.43           O  
ATOM   1353  CB  VAL A 175     -20.384  -8.613 -16.486  1.00 12.91           C  
ATOM   1354  CG1 VAL A 175     -19.692  -7.688 -17.503  1.00 12.62           C  
ATOM   1355  CG2 VAL A 175     -21.617  -7.937 -15.928  1.00 13.61           C  
ATOM   1356  N   ASP A 176     -19.381 -10.604 -19.023  1.00 11.81           N  
ATOM   1357  CA  ASP A 176     -18.210 -11.071 -19.732  1.00 11.90           C  
ATOM   1358  C   ASP A 176     -16.972 -10.279 -19.321  1.00 11.40           C  
ATOM   1359  O   ASP A 176     -17.065  -9.056 -19.050  1.00 11.56           O  
ATOM   1360  CB  ASP A 176     -18.387 -10.939 -21.249  1.00 12.38           C  
ATOM   1361  CG  ASP A 176     -19.283 -11.967 -21.841  1.00 18.83           C  
ATOM   1362  OD1 ASP A 176     -19.729 -12.905 -21.108  1.00 23.98           O  
ATOM   1363  OD2 ASP A 176     -19.566 -11.833 -23.068  1.00 19.26           O  
ATOM   1364  N   PHE A 177     -15.811 -10.933 -19.302  1.00 12.64           N  
ATOM   1365  CA  PHE A 177     -14.554 -10.294 -18.995  1.00 13.49           C  
ATOM   1366  C   PHE A 177     -13.621 -10.270 -20.183  1.00 12.67           C  
ATOM   1367  O   PHE A 177     -13.500 -11.265 -20.906  1.00 14.35           O  
ATOM   1368  CB  PHE A 177     -13.844 -11.000 -17.840  1.00 14.53           C  
ATOM   1369  CG  PHE A 177     -12.715 -10.225 -17.258  1.00 12.52           C  
ATOM   1370  CD1 PHE A 177     -12.989  -9.194 -16.379  1.00 13.61           C  
ATOM   1371  CD2 PHE A 177     -11.402 -10.482 -17.578  1.00 16.05           C  
ATOM   1372  CE1 PHE A 177     -11.986  -8.461 -15.845  1.00 15.00           C  
ATOM   1373  CE2 PHE A 177     -10.385  -9.748 -17.013  1.00 16.98           C  
ATOM   1374  CZ  PHE A 177     -10.676  -8.733 -16.152  1.00 13.91           C  
ATOM   1375  N   GLY A 178     -12.990  -9.116 -20.386  1.00 12.98           N  
ATOM   1376  CA  GLY A 178     -11.976  -8.899 -21.405  1.00 12.70           C  
ATOM   1377  C   GLY A 178     -10.636  -8.622 -20.718  1.00 11.06           C  
ATOM   1378  O   GLY A 178     -10.473  -7.618 -20.010  1.00 13.30           O  
ATOM   1379  N   LEU A 179      -9.682  -9.503 -20.947  1.00 11.76           N  
ATOM   1380  CA  LEU A 179      -8.415  -9.452 -20.304  1.00 11.97           C  
ATOM   1381  C   LEU A 179      -7.544  -8.470 -21.060  1.00 10.40           C  
ATOM   1382  O   LEU A 179      -7.308  -8.622 -22.270  1.00 12.07           O  
ATOM   1383  CB  LEU A 179      -7.788 -10.847 -20.307  1.00 12.98           C  
ATOM   1384  CG  LEU A 179      -6.437 -10.894 -19.590  1.00 13.52           C  
ATOM   1385  CD1 LEU A 179      -6.584 -10.728 -18.119  1.00 15.77           C  
ATOM   1386  CD2 LEU A 179      -5.721 -12.195 -19.897  1.00 17.21           C  
ATOM   1387  N   ALA A 180      -7.031  -7.485 -20.328  1.00 13.29           N  
ATOM   1388  CA  ALA A 180      -5.985  -6.570 -20.826  1.00 12.38           C  
ATOM   1389  C   ALA A 180      -4.611  -7.212 -20.600  1.00 13.46           C  
ATOM   1390  O   ALA A 180      -3.971  -6.996 -19.587  1.00 13.45           O  
ATOM   1391  CB  ALA A 180      -6.083  -5.248 -20.125  1.00 10.56           C  
ATOM   1392  N   VAL A 181      -4.181  -7.994 -21.579  1.00 12.62           N  
ATOM   1393  CA  VAL A 181      -2.988  -8.810 -21.457  1.00 14.69           C  
ATOM   1394  C   VAL A 181      -1.770  -7.935 -21.226  1.00 14.77           C  
ATOM   1395  O   VAL A 181      -0.818  -8.339 -20.539  1.00 16.32           O  
ATOM   1396  CB  VAL A 181      -2.836  -9.693 -22.715  1.00 15.77           C  
ATOM   1397  CG1 VAL A 181      -1.477 -10.400 -22.752  1.00 19.96           C  
ATOM   1398  CG2 VAL A 181      -3.988 -10.703 -22.769  1.00 17.20           C  
ATOM   1399  N   TRP A 182      -1.814  -6.721 -21.765  1.00 13.81           N  
ATOM   1400  CA  TRP A 182      -0.689  -5.801 -21.661  1.00 13.28           C  
ATOM   1401  C   TRP A 182      -0.348  -5.334 -20.250  1.00 13.79           C  
ATOM   1402  O   TRP A 182       0.744  -4.818 -20.022  1.00 18.52           O  
ATOM   1403  CB  TRP A 182      -0.897  -4.579 -22.553  1.00 14.18           C  
ATOM   1404  CG  TRP A 182      -2.053  -3.718 -22.172  1.00 10.78           C  
ATOM   1405  CD1 TRP A 182      -2.046  -2.710 -21.242  1.00 13.07           C  
ATOM   1406  CD2 TRP A 182      -3.374  -3.777 -22.670  1.00 13.24           C  
ATOM   1407  NE1 TRP A 182      -3.273  -2.159 -21.125  1.00 13.26           N  
ATOM   1408  CE2 TRP A 182      -4.126  -2.793 -21.988  1.00 13.15           C  
ATOM   1409  CE3 TRP A 182      -4.017  -4.577 -23.624  1.00 12.08           C  
ATOM   1410  CZ2 TRP A 182      -5.478  -2.561 -22.273  1.00 10.41           C  
ATOM   1411  CZ3 TRP A 182      -5.346  -4.370 -23.865  1.00 13.26           C  
ATOM   1412  CH2 TRP A 182      -6.058  -3.373 -23.192  1.00 13.70           C  
ATOM   1413  N   GLY A 183      -1.272  -5.497 -19.314  1.00 14.43           N  
ATOM   1414  CA  GLY A 183      -1.005  -5.243 -17.892  1.00 15.85           C  
ATOM   1415  C   GLY A 183      -0.040  -6.265 -17.282  1.00 15.73           C  
ATOM   1416  O   GLY A 183       0.473  -6.045 -16.209  1.00 16.10           O  
HETATM 1417  N   MSE A 184       0.151  -7.389 -17.957  1.00 14.26           N  
HETATM 1418  CA  MSE A 184       1.081  -8.440 -17.542  1.00 16.01           C  
HETATM 1419  C   MSE A 184       0.890  -9.071 -16.177  1.00 18.50           C  
HETATM 1420  O   MSE A 184       1.868  -9.598 -15.612  1.00 22.23           O  
HETATM 1421  CB  MSE A 184       2.548  -7.953 -17.653  1.00 18.69           C  
HETATM 1422  CG  MSE A 184       2.885  -7.354 -19.009  1.00 27.16           C  
HETATM 1423 SE   MSE A 184       2.980  -8.777 -20.303  0.75 52.39          SE  
HETATM 1424  CE  MSE A 184       4.753  -9.566 -19.713  1.00 53.38           C  
ATOM   1425  N   ASP A 185      -0.335  -9.104 -15.666  1.00 16.47           N  
ATOM   1426  CA  ASP A 185      -0.552  -9.808 -14.401  1.00 17.55           C  
ATOM   1427  C   ASP A 185      -0.459 -11.317 -14.563  1.00 17.01           C  
ATOM   1428  O   ASP A 185      -1.204 -11.895 -15.332  1.00 17.77           O  
ATOM   1429  CB  ASP A 185      -1.904  -9.482 -13.796  1.00 15.51           C  
ATOM   1430  CG  ASP A 185      -2.063 -10.106 -12.425  1.00 20.96           C  
ATOM   1431  OD1 ASP A 185      -1.343  -9.661 -11.528  1.00 22.06           O  
ATOM   1432  OD2 ASP A 185      -2.806 -11.089 -12.250  1.00 24.97           O  
ATOM   1433  N   PRO A 186       0.434 -11.964 -13.791  1.00 16.50           N  
ATOM   1434  CA  PRO A 186       0.528 -13.397 -14.027  1.00 15.85           C  
ATOM   1435  C   PRO A 186      -0.719 -14.221 -13.682  1.00 17.94           C  
ATOM   1436  O   PRO A 186      -1.108 -15.083 -14.477  1.00 23.09           O  
ATOM   1437  CB  PRO A 186       1.778 -13.821 -13.244  1.00 18.79           C  
ATOM   1438  CG  PRO A 186       2.334 -12.576 -12.571  1.00 18.90           C  
ATOM   1439  CD  PRO A 186       1.350 -11.468 -12.755  1.00 19.88           C  
ATOM   1440  N   ASN A 187      -1.394 -13.917 -12.588  1.00 15.72           N  
ATOM   1441  CA  ASN A 187      -2.554 -14.737 -12.191  1.00 15.43           C  
ATOM   1442  C   ASN A 187      -3.812 -14.570 -13.038  1.00 16.12           C  
ATOM   1443  O   ASN A 187      -4.485 -15.541 -13.396  1.00 15.81           O  
ATOM   1444  CB  ASN A 187      -2.874 -14.499 -10.728  1.00 17.16           C  
ATOM   1445  CG  ASN A 187      -1.763 -14.991  -9.817  1.00 19.62           C  
ATOM   1446  OD1 ASN A 187      -1.279 -14.274  -8.958  1.00 36.74           O  
ATOM   1447  ND2 ASN A 187      -1.374 -16.212 -10.005  1.00 19.67           N  
ATOM   1448  N   ALA A 188      -4.110 -13.326 -13.368  1.00 16.41           N  
ATOM   1449  CA  ALA A 188      -5.262 -12.987 -14.218  1.00 15.32           C  
ATOM   1450  C   ALA A 188      -5.217 -13.710 -15.566  1.00 14.63           C  
ATOM   1451  O   ALA A 188      -6.261 -14.087 -16.110  1.00 18.09           O  
ATOM   1452  CB  ALA A 188      -5.295 -11.528 -14.438  1.00 17.18           C  
ATOM   1453  N   ASP A 189      -4.012 -13.899 -16.093  1.00 16.01           N  
ATOM   1454  CA  ASP A 189      -3.783 -14.559 -17.367  1.00 17.15           C  
ATOM   1455  C   ASP A 189      -4.240 -16.015 -17.476  1.00 15.92           C  
ATOM   1456  O   ASP A 189      -4.509 -16.489 -18.578  1.00 16.08           O  
ATOM   1457  CB  ASP A 189      -2.281 -14.480 -17.658  1.00 20.42           C  
ATOM   1458  CG  ASP A 189      -1.933 -14.706 -19.139  1.00 29.89           C  
ATOM   1459  OD1 ASP A 189      -2.602 -14.106 -20.016  1.00 35.42           O  
ATOM   1460  OD2 ASP A 189      -0.945 -15.443 -19.409  1.00 26.86           O  
ATOM   1461  N   HIS A 190      -4.396 -16.701 -16.355  1.00 17.08           N  
ATOM   1462  CA  HIS A 190      -4.680 -18.139 -16.371  1.00 17.93           C  
ATOM   1463  C   HIS A 190      -6.145 -18.435 -16.298  1.00 17.50           C  
ATOM   1464  O   HIS A 190      -6.520 -19.584 -16.405  1.00 21.59           O  
ATOM   1465  CB  HIS A 190      -4.035 -18.809 -15.162  1.00 18.00           C  
ATOM   1466  CG  HIS A 190      -2.553 -18.765 -15.196  1.00 14.70           C  
ATOM   1467  ND1 HIS A 190      -1.831 -19.411 -16.176  1.00 23.71           N  
ATOM   1468  CD2 HIS A 190      -1.645 -18.208 -14.362  1.00 20.31           C  
ATOM   1469  CE1 HIS A 190      -0.541 -19.228 -15.961  1.00 32.07           C  
ATOM   1470  NE2 HIS A 190      -0.401 -18.483 -14.880  1.00 20.31           N  
ATOM   1471  N   GLN A 191      -6.979 -17.432 -16.044  1.00 19.73           N  
ATOM   1472  CA  GLN A 191      -8.394 -17.656 -15.935  1.00 20.49           C  
ATOM   1473  C   GLN A 191      -9.037 -17.734 -17.327  1.00 19.08           C  
ATOM   1474  O   GLN A 191      -8.597 -17.057 -18.262  1.00 21.29           O  
ATOM   1475  CB  GLN A 191      -9.031 -16.495 -15.165  1.00 21.47           C  
ATOM   1476  N   LYS A 192     -10.105 -18.514 -17.461  1.00 18.75           N  
ATOM   1477  CA  LYS A 192     -10.892 -18.541 -18.682  1.00 20.63           C  
ATOM   1478  C   LYS A 192     -11.704 -17.255 -18.746  1.00 20.32           C  
ATOM   1479  O   LYS A 192     -12.393 -16.929 -17.795  1.00 19.64           O  
ATOM   1480  CB  LYS A 192     -11.828 -19.742 -18.712  1.00 21.45           C  
ATOM   1481  CG  LYS A 192     -12.567 -19.941 -20.044  1.00 30.13           C  
ATOM   1482  N   VAL A 193     -11.615 -16.533 -19.855  1.00 17.23           N  
ATOM   1483  CA  VAL A 193     -12.313 -15.231 -20.019  1.00 16.72           C  
ATOM   1484  C   VAL A 193     -12.949 -15.184 -21.401  1.00 15.78           C  
ATOM   1485  O   VAL A 193     -12.647 -16.007 -22.269  1.00 17.38           O  
ATOM   1486  CB  VAL A 193     -11.307 -14.049 -19.860  1.00 17.70           C  
ATOM   1487  CG1 VAL A 193     -10.686 -14.021 -18.466  1.00 20.19           C  
ATOM   1488  CG2 VAL A 193     -10.205 -14.136 -20.892  1.00 17.41           C  
ATOM   1489  N   ALA A 194     -13.842 -14.233 -21.613  1.00 15.51           N  
ATOM   1490  CA  ALA A 194     -14.571 -14.091 -22.871  1.00 14.89           C  
ATOM   1491  C   ALA A 194     -13.701 -13.615 -24.030  1.00 15.97           C  
ATOM   1492  O   ALA A 194     -13.885 -14.069 -25.168  1.00 16.97           O  
ATOM   1493  CB  ALA A 194     -15.745 -13.149 -22.694  1.00 17.35           C  
ATOM   1494  N   HIS A 195     -12.774 -12.697 -23.735  1.00 13.54           N  
ATOM   1495  CA  HIS A 195     -11.904 -12.108 -24.728  1.00 10.62           C  
ATOM   1496  C   HIS A 195     -10.566 -11.813 -24.081  1.00 11.86           C  
ATOM   1497  O   HIS A 195     -10.467 -11.446 -22.913  1.00 14.59           O  
ATOM   1498  CB  HIS A 195     -12.496 -10.812 -25.290  1.00 12.45           C  
ATOM   1499  CG  HIS A 195     -13.816 -11.007 -25.979  1.00 15.32           C  
ATOM   1500  ND1 HIS A 195     -13.924 -11.594 -27.223  1.00 19.69           N  
ATOM   1501  CD2 HIS A 195     -15.080 -10.727 -25.585  1.00 16.38           C  
ATOM   1502  CE1 HIS A 195     -15.202 -11.664 -27.566  1.00 21.22           C  
ATOM   1503  NE2 HIS A 195     -15.926 -11.148 -26.590  1.00 17.78           N  
ATOM   1504  N   ARG A 196      -9.535 -11.956 -24.891  1.00 14.06           N  
ATOM   1505  CA  ARG A 196      -8.198 -11.631 -24.492  0.50 14.09           C  
ATOM   1507  C   ARG A 196      -7.653 -10.620 -25.496  1.00 14.70           C  
ATOM   1508  O   ARG A 196      -7.708 -10.812 -26.718  1.00 16.73           O  
ATOM   1509  CB  ARG A 196      -7.338 -12.886 -24.408  0.50 14.13           C  
ATOM   1511  CG  ARG A 196      -7.867 -13.925 -23.434  0.50 13.34           C  
ATOM   1513  CD  ARG A 196      -6.952 -15.174 -23.327  0.50 16.76           C  
ATOM   1515  NE  ARG A 196      -5.542 -14.827 -23.453  0.50 15.69           N  
ATOM   1517  CZ  ARG A 196      -4.642 -14.766 -22.466  0.50 14.81           C  
ATOM   1519  NH1 ARG A 196      -4.923 -15.085 -21.201  0.50 13.61           N  
ATOM   1521  NH2 ARG A 196      -3.409 -14.405 -22.782  0.50 18.33           N  
ATOM   1523  N   PHE A 197      -7.153  -9.519 -24.968  1.00 13.49           N  
ATOM   1524  CA  PHE A 197      -6.643  -8.425 -25.798  1.00 13.31           C  
ATOM   1525  C   PHE A 197      -5.160  -8.235 -25.564  1.00 13.62           C  
ATOM   1526  O   PHE A 197      -4.765  -7.826 -24.499  1.00 12.52           O  
ATOM   1527  CB  PHE A 197      -7.366  -7.133 -25.480  1.00 12.52           C  
ATOM   1528  CG  PHE A 197      -8.853  -7.222 -25.570  1.00 13.01           C  
ATOM   1529  CD1 PHE A 197      -9.443  -7.510 -26.781  1.00 13.08           C  
ATOM   1530  CD2 PHE A 197      -9.671  -7.006 -24.461  1.00 12.02           C  
ATOM   1531  CE1 PHE A 197     -10.825  -7.613 -26.883  1.00 13.17           C  
ATOM   1532  CE2 PHE A 197     -11.039  -7.076 -24.577  1.00 13.75           C  
ATOM   1533  CZ  PHE A 197     -11.615  -7.370 -25.774  1.00 16.15           C  
ATOM   1534  N   GLN A 198      -4.357  -8.552 -26.572  1.00 14.59           N  
ATOM   1535  CA  GLN A 198      -2.905  -8.477 -26.496  1.00 15.54           C  
ATOM   1536  C   GLN A 198      -2.462  -7.032 -26.356  1.00 14.99           C  
ATOM   1537  O   GLN A 198      -1.537  -6.745 -25.639  1.00 19.77           O  
ATOM   1538  CB  GLN A 198      -2.235  -9.106 -27.732  1.00 15.01           C  
ATOM   1539  CG  GLN A 198      -2.294 -10.624 -27.751  1.00 22.21           C  
ATOM   1540  CD  GLN A 198      -1.565 -11.286 -26.566  1.00 28.49           C  
ATOM   1541  OE1 GLN A 198      -0.419 -10.931 -26.226  1.00 37.77           O  
ATOM   1542  NE2 GLN A 198      -2.229 -12.261 -25.940  1.00 36.66           N  
ATOM   1543  N   LYS A 199      -3.119  -6.138 -27.084  1.00 15.70           N  
ATOM   1544  CA  LYS A 199      -2.848  -4.713 -26.987  1.00 18.08           C  
ATOM   1545  C   LYS A 199      -4.149  -3.927 -27.102  1.00 16.15           C  
ATOM   1546  O   LYS A 199      -5.156  -4.458 -27.575  1.00 13.96           O  
ATOM   1547  CB  LYS A 199      -1.871  -4.270 -28.060  1.00 22.18           C  
ATOM   1548  CG  LYS A 199      -2.343  -4.576 -29.431  1.00 23.34           C  
ATOM   1549  N   PRO A 200      -4.134  -2.678 -26.637  1.00 15.71           N  
ATOM   1550  CA  PRO A 200      -5.396  -1.924 -26.540  1.00 16.31           C  
ATOM   1551  C   PRO A 200      -6.235  -1.822 -27.794  1.00 15.66           C  
ATOM   1552  O   PRO A 200      -7.467  -1.961 -27.729  1.00 15.36           O  
ATOM   1553  CB  PRO A 200      -4.955  -0.560 -26.069  1.00 16.86           C  
ATOM   1554  CG  PRO A 200      -3.694  -0.829 -25.304  1.00 14.49           C  
ATOM   1555  CD  PRO A 200      -3.007  -1.939 -26.044  1.00 15.01           C  
ATOM   1556  N   LEU A 201      -5.592  -1.606 -28.935  1.00 15.19           N  
ATOM   1557  CA  LEU A 201      -6.331  -1.463 -30.186  1.00 14.64           C  
ATOM   1558  C   LEU A 201      -7.072  -2.743 -30.653  1.00 14.74           C  
ATOM   1559  O   LEU A 201      -8.003  -2.693 -31.464  1.00 16.14           O  
ATOM   1560  CB  LEU A 201      -5.432  -0.874 -31.280  1.00 14.89           C  
ATOM   1561  CG  LEU A 201      -5.030   0.570 -30.952  1.00 14.42           C  
ATOM   1562  CD1 LEU A 201      -3.916   1.046 -31.880  1.00 21.44           C  
ATOM   1563  CD2 LEU A 201      -6.251   1.498 -31.032  1.00 21.90           C  
ATOM   1564  N   ASP A 202      -6.700  -3.881 -30.086  1.00 14.68           N  
ATOM   1565  CA  ASP A 202      -7.385  -5.132 -30.377  1.00 14.81           C  
ATOM   1566  C   ASP A 202      -8.837  -5.132 -29.916  1.00 14.28           C  
ATOM   1567  O   ASP A 202      -9.635  -5.899 -30.425  1.00 16.02           O  
ATOM   1568  CB  ASP A 202      -6.678  -6.309 -29.717  1.00 16.28           C  
ATOM   1569  CG  ASP A 202      -5.258  -6.530 -30.242  1.00 22.55           C  
ATOM   1570  OD1 ASP A 202      -4.917  -6.047 -31.354  1.00 27.64           O  
ATOM   1571  OD2 ASP A 202      -4.502  -7.230 -29.540  1.00 23.92           O  
ATOM   1572  N   ILE A 203      -9.155  -4.296 -28.931  1.00 14.48           N  
ATOM   1573  CA  ILE A 203     -10.550  -4.108 -28.496  1.00 13.12           C  
ATOM   1574  C   ILE A 203     -11.428  -3.671 -29.684  1.00 13.95           C  
ATOM   1575  O   ILE A 203     -12.575  -4.085 -29.777  1.00 13.51           O  
ATOM   1576  CB  ILE A 203     -10.634  -3.107 -27.326  1.00 13.09           C  
ATOM   1577  CG1 ILE A 203      -9.840  -3.683 -26.146  1.00 14.44           C  
ATOM   1578  CG2 ILE A 203     -12.108  -2.818 -26.970  1.00 14.92           C  
ATOM   1579  CD1 ILE A 203      -9.611  -2.754 -24.916  1.00 14.66           C  
ATOM   1580  N   LEU A 204     -10.875  -2.895 -30.624  1.00 13.64           N  
ATOM   1581  CA  LEU A 204     -11.662  -2.463 -31.774  1.00 12.92           C  
ATOM   1582  C   LEU A 204     -12.145  -3.610 -32.624  1.00 14.17           C  
ATOM   1583  O   LEU A 204     -13.124  -3.443 -33.370  1.00 16.16           O  
ATOM   1584  CB  LEU A 204     -10.900  -1.459 -32.648  1.00 12.42           C  
ATOM   1585  CG  LEU A 204     -10.418  -0.197 -31.931  1.00 17.57           C  
ATOM   1586  CD1 LEU A 204      -9.568   0.654 -32.878  1.00 16.82           C  
ATOM   1587  CD2 LEU A 204     -11.614   0.571 -31.413  1.00 16.57           C  
ATOM   1588  N   GLU A 205     -11.475  -4.754 -32.564  1.00 15.47           N  
ATOM   1589  CA  GLU A 205     -11.891  -5.918 -33.349  1.00 18.69           C  
ATOM   1590  C   GLU A 205     -13.298  -6.403 -32.949  1.00 20.14           C  
ATOM   1591  O   GLU A 205     -13.957  -7.050 -33.751  1.00 20.36           O  
ATOM   1592  CB  GLU A 205     -10.898  -7.077 -33.215  1.00 20.65           C  
ATOM   1593  CG  GLU A 205      -9.467  -6.801 -33.759  1.00 24.22           C  
ATOM   1594  CD  GLU A 205      -8.381  -7.726 -33.144  1.00 23.78           C  
ATOM   1595  N   LEU A 206     -13.765  -6.093 -31.739  1.00 18.47           N  
ATOM   1596  CA  LEU A 206     -15.147  -6.406 -31.353  1.00 19.57           C  
ATOM   1597  C   LEU A 206     -16.186  -5.619 -32.123  1.00 20.09           C  
ATOM   1598  O   LEU A 206     -17.365  -5.947 -32.034  1.00 23.11           O  
ATOM   1599  CB  LEU A 206     -15.412  -6.100 -29.877  1.00 19.91           C  
ATOM   1600  CG  LEU A 206     -14.555  -6.690 -28.745  1.00 20.81           C  
ATOM   1601  CD1 LEU A 206     -14.804  -5.914 -27.452  1.00 23.69           C  
ATOM   1602  CD2 LEU A 206     -14.881  -8.117 -28.574  1.00 25.13           C  
ATOM   1603  N   PHE A 207     -15.785  -4.547 -32.794  1.00 21.23           N  
ATOM   1604  CA  PHE A 207     -16.729  -3.609 -33.440  1.00 22.97           C  
ATOM   1605  C   PHE A 207     -16.420  -3.425 -34.924  1.00 27.09           C  
ATOM   1606  O   PHE A 207     -16.215  -4.410 -35.626  1.00 29.40           O  
ATOM   1607  CB  PHE A 207     -16.698  -2.268 -32.717  1.00 20.56           C  
ATOM   1608  CG  PHE A 207     -16.904  -2.392 -31.225  1.00 20.17           C  
ATOM   1609  CD1 PHE A 207     -18.170  -2.600 -30.705  1.00 17.59           C  
ATOM   1610  CD2 PHE A 207     -15.834  -2.339 -30.346  1.00 18.40           C  
ATOM   1611  CE1 PHE A 207     -18.368  -2.749 -29.340  1.00 18.24           C  
ATOM   1612  CE2 PHE A 207     -16.034  -2.492 -28.980  1.00 19.23           C  
ATOM   1613  CZ  PHE A 207     -17.295  -2.708 -28.479  1.00 22.54           C  
TER    1614      PHE A 207                                                      
END
MOLECULE T0469.pdb
ATOM     34  N   GLN     3     -11.627   8.047  -2.168  1.00 30.01           N 
ATOM     35  CA  GLN     3     -10.194   8.122  -1.859  1.00 44.33           C 
ATOM     36  C   GLN     3      -9.345   7.641  -3.041  1.00  1.05           C 
ATOM     37  O   GLN     3      -9.602   6.580  -3.610  1.00 22.43           O 
ATOM     38  CB  GLN     3      -9.859   7.292  -0.611  1.00 15.35           C 
ATOM     39  CG  GLN     3     -10.597   7.739   0.646  1.00 20.34           C 
ATOM     40  CD  GLN     3     -10.090   7.063   1.912  1.00 71.03           C 
ATOM     41  OE1 GLN     3     -10.146   7.632   2.994  1.00 40.53           O 
ATOM     42  NE2 GLN     3      -9.579   5.849   1.794  1.00 34.32           N 
ATOM     43  H   GLN     3     -12.030   7.173  -2.365  1.00 38.87           H 
ATOM     44  HA  GLN     3      -9.952   9.158  -1.661  1.00  1.11           H 
ATOM     45 3HB  GLN     3      -8.796   7.360  -0.423  1.00 38.87           H 
ATOM     46 2HB  GLN     3     -10.114   6.259  -0.802  1.00 38.87           H 
ATOM     47 3HG  GLN     3     -11.648   7.509   0.531  1.00 38.87           H 
ATOM     48 2HG  GLN     3     -10.477   8.807   0.757  1.00 38.87           H 
ATOM     49 1HE2 GLN     3      -9.546   5.443   0.906  1.00 38.87           H 
ATOM     50 2HE2 GLN     3      -9.262   5.406   2.608  1.00 38.87           H 
ATOM     51  N   LYS     4      -8.332   8.429  -3.406  1.00 22.44           N 
ATOM     52  CA  LYS     4      -7.409   8.050  -4.485  1.00 75.21           C 
ATOM     53  C   LYS     4      -6.629   6.774  -4.137  1.00 11.23           C 
ATOM     54  O   LYS     4      -6.107   6.090  -5.023  1.00 54.32           O 
ATOM     55  CB  LYS     4      -6.437   9.199  -4.787  1.00 13.44           C 
ATOM     56  CG  LYS     4      -7.117  10.443  -5.351  1.00 21.02           C 
ATOM     57  CD  LYS     4      -6.106  11.504  -5.782  1.00 42.12           C 
ATOM     58  CE  LYS     4      -5.137  10.973  -6.836  1.00 71.40           C 
ATOM     59  NZ  LYS     4      -5.843  10.455  -8.039  1.00 62.12           N 
ATOM     60  H   LYS     4      -8.205   9.286  -2.948  1.00 38.87           H 
ATOM     61  HA  LYS     4      -8.002   7.858  -5.369  1.00 34.11           H 
ATOM     62 3HB  LYS     4      -5.705   8.856  -5.506  1.00 38.87           H 
ATOM     63 2HB  LYS     4      -5.928   9.474  -3.874  1.00 38.87           H 
ATOM     64 3HG  LYS     4      -7.762  10.863  -4.589  1.00 38.87           H 
ATOM     65 2HG  LYS     4      -7.712  10.160  -6.207  1.00 38.87           H 
ATOM     66 3HD  LYS     4      -5.543  11.825  -4.915  1.00 38.87           H 
ATOM     67 2HD  LYS     4      -6.640  12.347  -6.195  1.00 38.87           H 
ATOM     68 3HE  LYS     4      -4.552  10.173  -6.401  1.00 38.87           H 
ATOM     69 2HE  LYS     4      -4.480  11.772  -7.139  1.00 38.87           H 
ATOM     70 1HZ  LYS     4      -6.407   9.616  -7.794  1.00 38.87           H 
ATOM     71 2HZ  LYS     4      -5.154  10.192  -8.772  1.00 38.87           H 
ATOM     72 3HZ  LYS     4      -6.476  11.184  -8.427  1.00 38.87           H 
ATOM     73  N   PHE     5      -6.530   6.483  -2.839  1.00 50.12           N 
ATOM     74  CA  PHE     5      -5.961   5.220  -2.356  1.00 63.21           C 
ATOM     75  C   PHE     5      -7.007   4.431  -1.553  1.00  2.41           C 
ATOM     76  O   PHE     5      -7.454   4.866  -0.486  1.00  4.53           O 
ATOM     77  CB  PHE     5      -4.720   5.485  -1.493  1.00 42.04           C 
ATOM     78  CG  PHE     5      -3.603   6.170  -2.243  1.00 45.35           C 
ATOM     79  CD1 PHE     5      -3.462   7.551  -2.205  1.00  2.03           C 
ATOM     80  CD2 PHE     5      -2.699   5.431  -2.992  1.00 13.44           C 
ATOM     81  CE1 PHE     5      -2.444   8.178  -2.899  1.00 20.41           C 
ATOM     82  CE2 PHE     5      -1.680   6.054  -3.687  1.00 24.04           C 
ATOM     83  CZ  PHE     5      -1.551   7.427  -3.638  1.00 15.13           C 
ATOM     84  H   PHE     5      -6.837   7.141  -2.183  1.00 38.87           H 
ATOM     85  HA  PHE     5      -5.671   4.634  -3.217  1.00 20.31           H 
ATOM     86 3HB  PHE     5      -4.342   4.545  -1.116  1.00 38.87           H 
ATOM     87 2HB  PHE     5      -4.998   6.115  -0.658  1.00 38.87           H 
ATOM     88  HD1 PHE     5      -4.158   8.140  -1.624  1.00 55.23           H 
ATOM     89  HD2 PHE     5      -2.795   4.354  -3.031  1.00 60.12           H 
ATOM     90  HE1 PHE     5      -2.346   9.253  -2.861  1.00 54.03           H 
ATOM     91  HE2 PHE     5      -0.982   5.466  -4.265  1.00 44.45           H 
ATOM     92  HZ  PHE     5      -0.755   7.915  -4.182  1.00 41.14           H 
ATOM     93  N   THR     6      -7.403   3.276  -2.079  1.00 42.34           N 
ATOM     94  CA  THR     6      -8.414   2.428  -1.430  1.00 54.13           C 
ATOM     95  C   THR     6      -7.872   1.028  -1.124  1.00 21.43           C 
ATOM     96  O   THR     6      -6.877   0.596  -1.693  1.00 52.30           O 
ATOM     97  CB  THR     6      -9.687   2.286  -2.300  1.00 24.45           C 
ATOM     98  OG1 THR     6     -10.596   1.350  -1.693  1.00 74.03           O 
ATOM     99  CG2 THR     6      -9.342   1.821  -3.711  1.00 72.10           C 
ATOM    100  H   THR     6      -7.004   2.980  -2.926  1.00 38.87           H 
ATOM    101  HA  THR     6      -8.697   2.899  -0.497  1.00 22.22           H 
ATOM    102  HB  THR     6     -10.170   3.251  -2.364  1.00 75.32           H 
ATOM    103  HG1 THR     6     -11.497   1.538  -1.990  1.00  5.54           H 
ATOM    104 1HG2 THR     6      -8.875   0.849  -3.667  1.00 38.87           H 
ATOM    105 2HG2 THR     6      -8.661   2.526  -4.168  1.00 38.87           H 
ATOM    106 3HG2 THR     6     -10.244   1.760  -4.304  1.00 38.87           H 
ATOM    107  N   LYS     7      -8.550   0.316  -0.232  1.00 40.34           N 
ATOM    108  CA  LYS     7      -8.153  -1.048   0.138  1.00 44.32           C 
ATOM    109  C   LYS     7      -8.366  -2.029  -1.025  1.00 74.01           C 
ATOM    110  O   LYS     7      -7.759  -3.102  -1.067  1.00 64.01           O 
ATOM    111  CB  LYS     7      -8.956  -1.507   1.361  1.00 34.42           C 
ATOM    112  CG  LYS     7     -10.470  -1.494   1.154  1.00 41.34           C 
ATOM    113  CD  LYS     7     -11.213  -1.943   2.409  1.00  3.35           C 
ATOM    114  CE  LYS     7     -10.922  -1.033   3.598  1.00 25.21           C 
ATOM    115  NZ  LYS     7     -11.454  -1.588   4.872  1.00 70.34           N 
ATOM    116  H   LYS     7      -9.347   0.711   0.182  1.00 38.87           H 
ATOM    117  HA  LYS     7      -7.103  -1.031   0.393  1.00  2.20           H 
ATOM    118 3HB  LYS     7      -8.724  -0.856   2.192  1.00 38.87           H 
ATOM    119 2HB  LYS     7      -8.658  -2.515   1.615  1.00 38.87           H 
ATOM    120 3HG  LYS     7     -10.718  -2.164   0.342  1.00 38.87           H 
ATOM    121 2HG  LYS     7     -10.782  -0.491   0.900  1.00 38.87           H 
ATOM    122 3HD  LYS     7     -10.907  -2.951   2.655  1.00 38.87           H 
ATOM    123 2HD  LYS     7     -12.276  -1.930   2.211  1.00 38.87           H 
ATOM    124 3HE  LYS     7     -11.374  -0.068   3.420  1.00 38.87           H 
ATOM    125 2HE  LYS     7      -9.853  -0.916   3.694  1.00 38.87           H 
ATOM    126 1HZ  LYS     7     -12.485  -1.697   4.812  1.00 38.87           H 
ATOM    127 2HZ  LYS     7     -11.229  -0.946   5.660  1.00 38.87           H 
ATOM    128 3HZ  LYS     7     -11.028  -2.517   5.062  1.00 38.87           H 
ATOM    129  N   ASP     8      -9.229  -1.640  -1.962  1.00 23.15           N 
ATOM    130  CA  ASP     8      -9.599  -2.495  -3.095  1.00 40.32           C 
ATOM    131  C   ASP     8      -8.509  -2.519  -4.188  1.00 21.33           C 
ATOM    132  O   ASP     8      -8.319  -3.531  -4.864  1.00 43.43           O 
ATOM    133  CB  ASP     8     -10.930  -2.001  -3.681  1.00 25.40           C 
ATOM    134  CG  ASP     8     -11.526  -2.968  -4.688  1.00 12.34           C 
ATOM    135  OD1 ASP     8     -12.169  -3.949  -4.264  1.00 72.21           O 
ATOM    136  OD2 ASP     8     -11.372  -2.746  -5.906  1.00 45.15           O 
ATOM    137  H   ASP     8      -9.637  -0.751  -1.888  1.00 38.87           H 
ATOM    138  HA  ASP     8      -9.737  -3.500  -2.719  1.00  4.03           H 
ATOM    139 3HB  ASP     8     -10.768  -1.050  -4.170  1.00 38.87           H 
ATOM    140 2HB  ASP     8     -11.639  -1.867  -2.878  1.00 38.87           H 
ATOM    141  N   MET     9      -7.786  -1.406  -4.347  1.00 22.22           N 
ATOM    142  CA  MET     9      -6.770  -1.285  -5.407  1.00 21.14           C 
ATOM    143  C   MET     9      -5.493  -2.072  -5.060  1.00 74.21           C 
ATOM    144  O   MET     9      -5.230  -2.370  -3.894  1.00 20.44           O 
ATOM    145  CB  MET     9      -6.430   0.193  -5.658  1.00 15.42           C 
ATOM    146  CG  MET     9      -5.739   0.873  -4.485  1.00 52.44           C 
ATOM    147  SD  MET     9      -5.650   2.667  -4.666  1.00 14.13           S 
ATOM    148  CE  MET     9      -4.684   2.823  -6.167  1.00 12.05           C 
ATOM    149  H   MET     9      -7.929  -0.658  -3.733  1.00 38.87           H 
ATOM    150  HA  MET     9      -7.192  -1.701  -6.312  1.00 53.05           H 
ATOM    151 3HB  MET     9      -7.343   0.732  -5.871  1.00 38.87           H 
ATOM    152 2HB  MET     9      -5.778   0.261  -6.519  1.00 38.87           H 
ATOM    153 3HG  MET     9      -4.734   0.483  -4.400  1.00 38.87           H 
ATOM    154 2HG  MET     9      -6.286   0.645  -3.585  1.00 38.87           H 
ATOM    155 1HE  MET     9      -4.579   3.868  -6.416  1.00 38.87           H 
ATOM    156 2HE  MET     9      -5.185   2.308  -6.974  1.00 38.87           H 
ATOM    157 3HE  MET     9      -3.707   2.389  -6.013  1.00 38.87           H 
ATOM    158  N   THR    10      -4.699  -2.398  -6.079  1.00 41.40           N 
ATOM    159  CA  THR    10      -3.476  -3.198  -5.894  1.00 42.12           C 
ATOM    160  C   THR    10      -2.262  -2.333  -5.524  1.00 34.11           C 
ATOM    161  O   THR    10      -2.241  -1.123  -5.777  1.00 60.51           O 
ATOM    162  CB  THR    10      -3.126  -3.993  -7.171  1.00  4.44           C 
ATOM    163  OG1 THR    10      -2.801  -3.085  -8.235  1.00 24.12           O 
ATOM    164  CG2 THR    10      -4.283  -4.893  -7.600  1.00 42.43           C 
ATOM    165  H   THR    10      -4.938  -2.101  -6.981  1.00 38.87           H 
ATOM    166  HA  THR    10      -3.656  -3.905  -5.095  1.00 52.02           H 
ATOM    167  HB  THR    10      -2.263  -4.615  -6.966  1.00 32.44           H 
ATOM    168  HG1 THR    10      -2.704  -3.581  -9.059  1.00 21.12           H 
ATOM    169 1HG2 THR    10      -5.146  -4.286  -7.834  1.00 38.87           H 
ATOM    170 2HG2 THR    10      -4.530  -5.573  -6.797  1.00 38.87           H 
ATOM    171 3HG2 THR    10      -3.995  -5.460  -8.474  1.00 38.87           H 
ATOM    172  N   PHE    11      -1.244  -2.964  -4.935  1.00 75.24           N 
ATOM    173  CA  PHE    11       0.007  -2.274  -4.599  1.00  0.34           C 
ATOM    174  C   PHE    11       0.663  -1.656  -5.845  1.00 12.02           C 
ATOM    175  O   PHE    11       1.131  -0.516  -5.810  1.00 75.13           O 
ATOM    176  CB  PHE    11       0.990  -3.241  -3.921  1.00 53.52           C 
ATOM    177  CG  PHE    11       0.574  -3.675  -2.535  1.00  4.04           C 
ATOM    178  CD1 PHE    11       0.923  -2.917  -1.426  1.00 20.14           C 
ATOM    179  CD2 PHE    11      -0.156  -4.837  -2.340  1.00 72.14           C 
ATOM    180  CE1 PHE    11       0.553  -3.310  -0.154  1.00 60.41           C 
ATOM    181  CE2 PHE    11      -0.529  -5.235  -1.070  1.00 23.33           C 
ATOM    182  CZ  PHE    11      -0.174  -4.469   0.024  1.00 62.13           C 
ATOM    183  H   PHE    11      -1.338  -3.919  -4.714  1.00 38.87           H 
ATOM    184  HA  PHE    11      -0.235  -1.479  -3.905  1.00 35.22           H 
ATOM    185 3HB  PHE    11       1.957  -2.763  -3.843  1.00 38.87           H 
ATOM    186 2HB  PHE    11       1.085  -4.128  -4.529  1.00 38.87           H 
ATOM    187  HD1 PHE    11       1.490  -2.008  -1.562  1.00 20.15           H 
ATOM    188  HD2 PHE    11      -0.434  -5.437  -3.193  1.00 24.11           H 
ATOM    189  HE1 PHE    11       0.832  -2.711   0.701  1.00 60.41           H 
ATOM    190  HE2 PHE    11      -1.098  -6.142  -0.933  1.00  2.33           H 
ATOM    191  HZ  PHE    11      -0.465  -4.779   1.019  1.00 40.11           H 
ATOM    192  N   ALA    12       0.680  -2.410  -6.947  1.00 70.34           N 
ATOM    193  CA  ALA    12       1.281  -1.939  -8.205  1.00 33.55           C 
ATOM    194  C   ALA    12       0.640  -0.629  -8.686  1.00 13.22           C 
ATOM    195  O   ALA    12       1.330   0.279  -9.156  1.00 52.42           O 
ATOM    196  CB  ALA    12       1.163  -3.010  -9.286  1.00 54.15           C 
ATOM    197  H   ALA    12       0.275  -3.304  -6.919  1.00 38.87           H 
ATOM    198  HA  ALA    12       2.335  -1.765  -8.022  1.00 64.43           H 
ATOM    199 1HB  ALA    12       1.660  -2.672 -10.185  1.00 38.87           H 
ATOM    200 2HB  ALA    12       0.120  -3.193  -9.500  1.00 38.87           H 
ATOM    201 3HB  ALA    12       1.625  -3.924  -8.943  1.00 38.87           H 
ATOM    202  N   GLN    13      -0.683  -0.532  -8.568  1.00 73.00           N 
ATOM    203  CA  GLN    13      -1.398   0.686  -8.958  1.00 55.15           C 
ATOM    204  C   GLN    13      -1.078   1.850  -8.005  1.00 63.15           C 
ATOM    205  O   GLN    13      -0.847   2.976  -8.447  1.00  3.14           O 
ATOM    206  CB  GLN    13      -2.910   0.428  -9.010  1.00  4.02           C 
ATOM    207  CG  GLN    13      -3.316  -0.584 -10.078  1.00 34.02           C 
ATOM    208  CD  GLN    13      -4.820  -0.787 -10.183  1.00 70.24           C 
ATOM    209  OE1 GLN    13      -5.295  -1.868 -10.517  1.00 23.12           O 
ATOM    210  NE2 GLN    13      -5.584   0.254  -9.915  1.00 41.33           N 
ATOM    211  H   GLN    13      -1.191  -1.297  -8.216  1.00 38.87           H 
ATOM    212  HA  GLN    13      -1.059   0.957  -9.951  1.00 11.24           H 
ATOM    213 3HB  GLN    13      -3.419   1.360  -9.214  1.00 38.87           H 
ATOM    214 2HB  GLN    13      -3.234   0.056  -8.047  1.00 38.87           H 
ATOM    215 3HG  GLN    13      -2.857  -1.535  -9.842  1.00 38.87           H 
ATOM    216 2HG  GLN    13      -2.951  -0.242 -11.035  1.00 38.87           H 
ATOM    217 1HE2 GLN    13      -5.153   1.095  -9.665  1.00 38.87           H 
ATOM    218 2HE2 GLN    13      -6.553   0.137  -9.979  1.00 38.87           H 
ATOM    219  N   ALA    14      -1.047   1.571  -6.700  1.00  1.31           N 
ATOM    220  CA  ALA    14      -0.723   2.593  -5.694  1.00  5.31           C 
ATOM    221  C   ALA    14       0.665   3.211  -5.941  1.00  2.11           C 
ATOM    222  O   ALA    14       0.819   4.437  -5.971  1.00  2.23           O 
ATOM    223  CB  ALA    14      -0.802   2.000  -4.293  1.00 72.04           C 
ATOM    224  H   ALA    14      -1.251   0.656  -6.402  1.00 38.87           H 
ATOM    225  HA  ALA    14      -1.467   3.374  -5.768  1.00 23.12           H 
ATOM    226 1HB  ALA    14      -0.639   2.778  -3.561  1.00 38.87           H 
ATOM    227 2HB  ALA    14      -0.045   1.237  -4.179  1.00 38.87           H 
ATOM    228 3HB  ALA    14      -1.778   1.562  -4.142  1.00 38.87           H 
ATOM    229  N   LEU    15       1.666   2.352  -6.140  1.00 53.00           N 
ATOM    230  CA  LEU    15       3.043   2.799  -6.408  1.00 61.24           C 
ATOM    231  C   LEU    15       3.117   3.723  -7.636  1.00 71.12           C 
ATOM    232  O   LEU    15       3.826   4.728  -7.628  1.00  1.44           O 
ATOM    233  CB  LEU    15       3.962   1.585  -6.618  1.00 53.10           C 
ATOM    234  CG  LEU    15       4.110   0.651  -5.403  1.00 11.51           C 
ATOM    235  CD1 LEU    15       5.003  -0.542  -5.739  1.00 11.14           C 
ATOM    236  CD2 LEU    15       4.658   1.412  -4.198  1.00 15.41           C 
ATOM    237  H   LEU    15       1.477   1.389  -6.101  1.00 38.87           H 
ATOM    238  HA  LEU    15       3.386   3.347  -5.542  1.00 72.23           H 
ATOM    239 3HB  LEU    15       4.947   1.945  -6.885  1.00 38.87           H 
ATOM    240 2HB  LEU    15       3.575   1.007  -7.446  1.00 38.87           H 
ATOM    241  HG  LEU    15       3.135   0.266  -5.138  1.00  1.04           H 
ATOM    242 1HD1 LEU    15       4.546  -1.124  -6.528  1.00 38.87           H 
ATOM    243 2HD1 LEU    15       5.125  -1.162  -4.862  1.00 38.87           H 
ATOM    244 3HD1 LEU    15       5.969  -0.190  -6.068  1.00 38.87           H 
ATOM    245 1HD2 LEU    15       4.760   0.736  -3.361  1.00 38.87           H 
ATOM    246 2HD2 LEU    15       3.978   2.208  -3.933  1.00 38.87           H 
ATOM    247 3HD2 LEU    15       5.625   1.830  -4.441  1.00 38.87           H 
ATOM    248  N   GLN    16       2.375   3.378  -8.690  1.00  1.31           N 
ATOM    249  CA  GLN    16       2.369   4.172  -9.929  1.00 61.42           C 
ATOM    250  C   GLN    16       1.474   5.419  -9.814  1.00 74.42           C 
ATOM    251  O   GLN    16       1.464   6.269 -10.704  1.00 23.42           O 
ATOM    252  CB  GLN    16       1.923   3.300 -11.111  1.00  0.13           C 
ATOM    253  CG  GLN    16       2.841   2.107 -11.372  1.00 55.04           C 
ATOM    254  CD  GLN    16       4.251   2.515 -11.770  1.00 54.54           C 
ATOM    255  OE1 GLN    16       4.561   2.667 -12.949  1.00  2.11           O 
ATOM    256  NE2 GLN    16       5.118   2.697 -10.795  1.00 32.00           N 
ATOM    257  H   GLN    16       1.819   2.571  -8.637  1.00 38.87           H 
ATOM    258  HA  GLN    16       3.384   4.500 -10.108  1.00 53.34           H 
ATOM    259 3HB  GLN    16       1.893   3.906 -12.005  1.00 38.87           H 
ATOM    260 2HB  GLN    16       0.931   2.921 -10.910  1.00 38.87           H 
ATOM    261 3HG  GLN    16       2.417   1.511 -12.167  1.00 38.87           H 
ATOM    262 2HG  GLN    16       2.897   1.512 -10.473  1.00 38.87           H 
ATOM    263 1HE2 GLN    16       4.817   2.564  -9.876  1.00 38.87           H 
ATOM    264 2HE2 GLN    16       6.032   2.966 -11.034  1.00 38.87           H 
ATOM    265  N   THR    17       0.717   5.518  -8.720  1.00 10.44           N 
ATOM    266  CA  THR    17      -0.111   6.706  -8.458  1.00  2.23           C 
ATOM    267  C   THR    17       0.702   7.796  -7.733  1.00 63.00           C 
ATOM    268  O   THR    17       0.578   8.983  -8.031  1.00 23.51           O 
ATOM    269  CB  THR    17      -1.369   6.349  -7.620  1.00 70.42           C 
ATOM    270  OG1 THR    17      -2.182   5.395  -8.327  1.00 42.52           O 
ATOM    271  CG2 THR    17      -2.207   7.586  -7.315  1.00 72.44           C 
ATOM    272  H   THR    17       0.712   4.779  -8.077  1.00 38.87           H 
ATOM    273  HA  THR    17      -0.441   7.098  -9.412  1.00 24.45           H 
ATOM    274  HB  THR    17      -1.047   5.908  -6.685  1.00 42.02           H 
ATOM    275  HG1 THR    17      -1.640   4.636  -8.579  1.00 52.45           H 
ATOM    276 1HG2 THR    17      -3.079   7.300  -6.745  1.00 38.87           H 
ATOM    277 2HG2 THR    17      -2.517   8.051  -8.239  1.00 38.87           H 
ATOM    278 3HG2 THR    17      -1.617   8.288  -6.742  1.00 38.87           H 
ATOM    279  N   HIS    18       1.525   7.382  -6.767  1.00 50.52           N 
ATOM    280  CA  HIS    18       2.451   8.292  -6.072  1.00 51.53           C 
ATOM    281  C   HIS    18       3.724   7.545  -5.632  1.00 31.25           C 
ATOM    282  O   HIS    18       3.657   6.646  -4.799  1.00 60.41           O 
ATOM    283  CB  HIS    18       1.783   8.934  -4.842  1.00 53.14           C 
ATOM    284  CG  HIS    18       0.845  10.060  -5.164  1.00  0.11           C 
ATOM    285  ND1 HIS    18      -0.476   9.869  -5.500  1.00 44.23           N 
ATOM    286  CD2 HIS    18       1.042  11.401  -5.190  1.00 65.24           C 
ATOM    287  CE1 HIS    18      -1.049  11.033  -5.720  1.00 14.31           C 
ATOM    288  NE2 HIS    18      -0.154  11.980  -5.538  1.00 73.21           N 
ATOM    289  H   HIS    18       1.515   6.433  -6.510  1.00 38.87           H 
ATOM    290  HA  HIS    18       2.729   9.074  -6.767  1.00 42.31           H 
ATOM    291 3HB  HIS    18       2.550   9.321  -4.186  1.00 38.87           H 
ATOM    292 2HB  HIS    18       1.221   8.179  -4.313  1.00 38.87           H 
ATOM    293  HD1 HIS    18      -0.923   9.006  -5.581  1.00  0.44           H 
ATOM    294  HD2 HIS    18       1.966  11.919  -4.974  1.00 42.41           H 
ATOM    295  HE1 HIS    18      -2.081  11.186  -5.997  1.00 43.22           H 
ATOM    296  HE2 HIS    18      -0.266  12.914  -5.823  1.00 38.87           H 
ATOM    297  N   PRO    19       4.902   7.911  -6.176  1.00 44.11           N 
ATOM    298  CA  PRO    19       6.182   7.268  -5.806  1.00 61.45           C 
ATOM    299  C   PRO    19       6.439   7.262  -4.282  1.00  3.03           C 
ATOM    300  O   PRO    19       7.054   6.334  -3.750  1.00 32.42           O 
ATOM    301  CB  PRO    19       7.228   8.125  -6.530  1.00 61.40           C 
ATOM    302  CG  PRO    19       6.492   8.706  -7.691  1.00 64.24           C 
ATOM    303  CD  PRO    19       5.090   8.959  -7.201  1.00 13.23           C 
ATOM    304  HA  PRO    19       6.228   6.252  -6.176  1.00 73.34           H 
ATOM    305 3HB  PRO    19       8.051   7.503  -6.854  1.00 38.87           H 
ATOM    306 2HB  PRO    19       7.593   8.898  -5.866  1.00 38.87           H 
ATOM    307 3HG  PRO    19       6.482   8.000  -8.510  1.00 38.87           H 
ATOM    308 2HG  PRO    19       6.957   9.632  -7.999  1.00 38.87           H 
ATOM    309 3HD  PRO    19       4.379   8.843  -8.008  1.00 38.87           H 
ATOM    310 2HD  PRO    19       5.010   9.944  -6.764  1.00 38.87           H 
ATOM    311  N   GLY    20       5.956   8.297  -3.587  1.00 21.51           N 
ATOM    312  CA  GLY    20       6.109   8.377  -2.132  1.00 71.35           C 
ATOM    313  C   GLY    20       5.455   7.215  -1.384  1.00  4.24           C 
ATOM    314  O   GLY    20       5.810   6.920  -0.237  1.00 31.31           O 
ATOM    315  H   GLY    20       5.499   9.021  -4.066  1.00 38.87           H 
ATOM    316 3HA  GLY    20       5.665   9.301  -1.789  1.00 38.87           H 
ATOM    317 2HA  GLY    20       7.164   8.392  -1.895  1.00 38.87           H 
ATOM    318  N   VAL    21       4.496   6.555  -2.036  1.00 12.22           N 
ATOM    319  CA  VAL    21       3.830   5.378  -1.467  1.00  3.14           C 
ATOM    320  C   VAL    21       4.841   4.265  -1.148  1.00 25.24           C 
ATOM    321  O   VAL    21       4.709   3.566  -0.145  1.00 20.22           O 
ATOM    322  CB  VAL    21       2.737   4.831  -2.428  1.00 21.02           C 
ATOM    323  CG1 VAL    21       2.127   3.532  -1.901  1.00 22.41           C 
ATOM    324  CG2 VAL    21       1.649   5.880  -2.649  1.00 64.42           C 
ATOM    325  H   VAL    21       4.228   6.868  -2.926  1.00 38.87           H 
ATOM    326  HA  VAL    21       3.348   5.682  -0.547  1.00 32.31           H 
ATOM    327  HB  VAL    21       3.201   4.620  -3.384  1.00 72.31           H 
ATOM    328 1HG1 VAL    21       2.904   2.789  -1.790  1.00 38.87           H 
ATOM    329 2HG1 VAL    21       1.385   3.171  -2.599  1.00 38.87           H 
ATOM    330 3HG1 VAL    21       1.663   3.714  -0.943  1.00 38.87           H 
ATOM    331 1HG2 VAL    21       0.920   5.504  -3.352  1.00 38.87           H 
ATOM    332 2HG2 VAL    21       2.095   6.783  -3.044  1.00 38.87           H 
ATOM    333 3HG2 VAL    21       1.164   6.101  -1.710  1.00 38.87           H 
ATOM    334  N   ALA    22       5.865   4.125  -1.991  1.00  3.15           N 
ATOM    335  CA  ALA    22       6.918   3.126  -1.775  1.00 70.13           C 
ATOM    336  C   ALA    22       7.591   3.312  -0.404  1.00 44.44           C 
ATOM    337  O   ALA    22       7.781   2.349   0.340  1.00 33.33           O 
ATOM    338  CB  ALA    22       7.957   3.198  -2.890  1.00 74.52           C 
ATOM    339  H   ALA    22       5.917   4.712  -2.776  1.00 38.87           H 
ATOM    340  HA  ALA    22       6.457   2.146  -1.807  1.00 11.14           H 
ATOM    341 1HB  ALA    22       7.476   3.039  -3.845  1.00 38.87           H 
ATOM    342 2HB  ALA    22       8.708   2.436  -2.736  1.00 38.87           H 
ATOM    343 3HB  ALA    22       8.428   4.171  -2.885  1.00 38.87           H 
ATOM    344  N   GLY    23       7.933   4.558  -0.075  1.00 40.23           N 
ATOM    345  CA  GLY    23       8.535   4.858   1.222  1.00 63.24           C 
ATOM    346  C   GLY    23       7.622   4.506   2.392  1.00 72.20           C 
ATOM    347  O   GLY    23       8.058   3.897   3.373  1.00 14.24           O 
ATOM    348  H   GLY    23       7.774   5.282  -0.716  1.00 38.87           H 
ATOM    349 3HA  GLY    23       8.760   5.914   1.264  1.00 38.87           H 
ATOM    350 2HA  GLY    23       9.458   4.302   1.314  1.00 38.87           H 
ATOM    351  N   VAL    24       6.350   4.883   2.280  1.00 11.32           N 
ATOM    352  CA  VAL    24       5.350   4.561   3.304  1.00  4.13           C 
ATOM    353  C   VAL    24       5.216   3.040   3.488  1.00 52.01           C 
ATOM    354  O   VAL    24       5.308   2.528   4.605  1.00 65.42           O 
ATOM    355  CB  VAL    24       3.964   5.165   2.949  1.00 15.43           C 
ATOM    356  CG1 VAL    24       2.918   4.832   4.017  1.00 62.13           C 
ATOM    357  CG2 VAL    24       4.073   6.677   2.755  1.00 55.22           C 
ATOM    358  H   VAL    24       6.076   5.392   1.487  1.00 38.87           H 
ATOM    359  HA  VAL    24       5.681   4.996   4.238  1.00 44.24           H 
ATOM    360  HB  VAL    24       3.636   4.731   2.013  1.00 63.23           H 
ATOM    361 1HG1 VAL    24       2.821   3.758   4.105  1.00 38.87           H 
ATOM    362 2HG1 VAL    24       1.964   5.256   3.732  1.00 38.87           H 
ATOM    363 3HG1 VAL    24       3.225   5.244   4.968  1.00 38.87           H 
ATOM    364 1HG2 VAL    24       3.105   7.082   2.499  1.00 38.87           H 
ATOM    365 2HG2 VAL    24       4.772   6.889   1.958  1.00 38.87           H 
ATOM    366 3HG2 VAL    24       4.425   7.135   3.669  1.00 38.87           H 
ATOM    367  N   LEU    25       5.024   2.319   2.383  1.00 21.21           N 
ATOM    368  CA  LEU    25       4.890   0.859   2.421  1.00 24.54           C 
ATOM    369  C   LEU    25       6.124   0.189   3.054  1.00 52.53           C 
ATOM    370  O   LEU    25       5.991  -0.631   3.961  1.00  0.34           O 
ATOM    371  CB  LEU    25       4.646   0.301   1.009  1.00 23.11           C 
ATOM    372  CG  LEU    25       3.344   0.768   0.333  1.00 14.31           C 
ATOM    373  CD1 LEU    25       3.195   0.130  -1.046  1.00 41.41           C 
ATOM    374  CD2 LEU    25       2.129   0.460   1.211  1.00 73.14           C 
ATOM    375  H   LEU    25       4.969   2.780   1.519  1.00 38.87           H 
ATOM    376  HA  LEU    25       4.029   0.631   3.035  1.00 24.42           H 
ATOM    377 3HB  LEU    25       4.625  -0.779   1.069  1.00 38.87           H 
ATOM    378 2HB  LEU    25       5.478   0.590   0.381  1.00 38.87           H 
ATOM    379  HG  LEU    25       3.389   1.839   0.194  1.00 22.14           H 
ATOM    380 1HD1 LEU    25       3.158  -0.945  -0.949  1.00 38.87           H 
ATOM    381 2HD1 LEU    25       4.040   0.405  -1.662  1.00 38.87           H 
ATOM    382 3HD1 LEU    25       2.284   0.480  -1.512  1.00 38.87           H 
ATOM    383 1HD2 LEU    25       1.231   0.811   0.723  1.00 38.87           H 
ATOM    384 2HD2 LEU    25       2.236   0.962   2.163  1.00 38.87           H 
ATOM    385 3HD2 LEU    25       2.059  -0.605   1.374  1.00 38.87           H 
ATOM    386  N   ARG    26       7.321   0.551   2.592  1.00 43.22           N 
ATOM    387  CA  ARG    26       8.560  -0.020   3.145  1.00 41.55           C 
ATOM    388  C   ARG    26       8.698   0.292   4.646  1.00 10.22           C 
ATOM    389  O   ARG    26       9.154  -0.547   5.426  1.00 44.14           O 
ATOM    390  CB  ARG    26       9.791   0.483   2.372  1.00  1.12           C 
ATOM    391  CG  ARG    26       9.792   0.088   0.895  1.00  0.12           C 
ATOM    392  CD  ARG    26      11.120   0.413   0.213  1.00 14.24           C 
ATOM    393  NE  ARG    26      12.212  -0.415   0.721  1.00  2.21           N 
ATOM    394  CZ  ARG    26      13.444  -0.363   0.284  1.00 72.04           C 
ATOM    395  NH1 ARG    26      13.782   0.443  -0.671  1.00 25.00           N 
ATOM    396  NH2 ARG    26      14.337  -1.136   0.804  1.00 23.25           N 
ATOM    397  H   ARG    26       7.375   1.216   1.870  1.00 38.87           H 
ATOM    398  HA  ARG    26       8.497  -1.094   3.028  1.00 20.25           H 
ATOM    399 3HB  ARG    26      10.682   0.077   2.833  1.00 38.87           H 
ATOM    400 2HB  ARG    26       9.825   1.562   2.434  1.00 38.87           H 
ATOM    401 3HG  ARG    26       8.999   0.622   0.391  1.00 38.87           H 
ATOM    402 2HG  ARG    26       9.613  -0.975   0.818  1.00 38.87           H 
ATOM    403 3HD  ARG    26      11.356   1.454   0.388  1.00 38.87           H 
ATOM    404 2HD  ARG    26      11.015   0.242  -0.848  1.00 38.87           H 
ATOM    405  HE  ARG    26      12.007  -1.048   1.436  1.00 75.23           H 
ATOM    406 1HH1 ARG    26      13.104   1.036  -1.087  1.00 38.87           H 
ATOM    407 2HH1 ARG    26      14.729   0.464  -0.989  1.00 38.87           H 
ATOM    408 1HH2 ARG    26      14.081  -1.766   1.535  1.00 38.87           H 
ATOM    409 2HH2 ARG    26      15.281  -1.099   0.479  1.00 38.87           H 
ATOM    410  N   SER    27       8.287   1.495   5.048  1.00 41.25           N 
ATOM    411  CA  SER    27       8.268   1.880   6.470  1.00 31.14           C 
ATOM    412  C   SER    27       7.256   1.030   7.257  1.00 64.51           C 
ATOM    413  O   SER    27       7.441   0.755   8.444  1.00  3.25           O 
ATOM    414  CB  SER    27       7.918   3.370   6.624  1.00 40.22           C 
ATOM    415  OG  SER    27       7.865   3.759   7.991  1.00 31.31           O 
ATOM    416  H   SER    27       7.994   2.146   4.373  1.00 38.87           H 
ATOM    417  HA  SER    27       9.255   1.708   6.873  1.00 70.30           H 
ATOM    418 3HB  SER    27       6.952   3.559   6.174  1.00 38.87           H 
ATOM    419 2HB  SER    27       8.666   3.968   6.125  1.00 38.87           H 
ATOM    420  HG  SER    27       8.739   3.656   8.392  1.00 30.31           H 
ATOM    421  N   TYR    28       6.184   0.617   6.583  1.00 45.01           N 
ATOM    422  CA  TYR    28       5.142  -0.224   7.194  1.00 74.51           C 
ATOM    423  C   TYR    28       5.395  -1.724   6.958  1.00 14.23           C 
ATOM    424  O   TYR    28       4.470  -2.529   7.046  1.00 61.03           O 
ATOM    425  CB  TYR    28       3.757   0.166   6.641  1.00 74.03           C 
ATOM    426  CG  TYR    28       3.189   1.441   7.242  1.00 11.24           C 
ATOM    427  CD1 TYR    28       3.911   2.627   7.217  1.00 10.44           C 
ATOM    428  CD2 TYR    28       1.933   1.452   7.841  1.00 20.03           C 
ATOM    429  CE1 TYR    28       3.401   3.784   7.767  1.00 34.33           C 
ATOM    430  CE2 TYR    28       1.416   2.610   8.391  1.00  2.12           C 
ATOM    431  CZ  TYR    28       2.154   3.774   8.356  1.00 71.44           C 
ATOM    432  OH  TYR    28       1.646   4.929   8.911  1.00 63.15           O 
ATOM    433  H   TYR    28       6.081   0.892   5.647  1.00 38.87           H 
ATOM    434  HA  TYR    28       5.152  -0.041   8.260  1.00 10.33           H 
ATOM    435 3HB  TYR    28       3.058  -0.636   6.840  1.00 38.87           H 
ATOM    436 2HB  TYR    28       3.829   0.309   5.572  1.00 38.87           H 
ATOM    437  HD1 TYR    28       4.889   2.637   6.754  1.00 12.04           H 
ATOM    438  HD2 TYR    28       1.354   0.539   7.870  1.00 44.32           H 
ATOM    439  HE1 TYR    28       3.982   4.695   7.734  1.00 31.13           H 
ATOM    440  HE2 TYR    28       0.437   2.597   8.852  1.00  5.42           H 
ATOM    441  HH  TYR    28       1.231   4.715   9.759  1.00 22.42           H 
ATOM    442  N   ASN    29       6.644  -2.094   6.655  1.00 64.12           N 
ATOM    443  CA  ASN    29       7.027  -3.510   6.467  1.00  3.31           C 
ATOM    444  C   ASN    29       6.394  -4.116   5.189  1.00 13.52           C 
ATOM    445  O   ASN    29       6.542  -5.306   4.904  1.00 14.04           O 
ATOM    446  CB  ASN    29       6.643  -4.328   7.718  1.00 42.21           C 
ATOM    447  CG  ASN    29       7.083  -5.781   7.648  1.00 55.45           C 
ATOM    448  OD1 ASN    29       6.340  -6.648   7.204  1.00  2.11           O 
ATOM    449  ND2 ASN    29       8.292  -6.057   8.086  1.00 52.35           N 
ATOM    450  H   ASN    29       7.330  -1.400   6.555  1.00 38.87           H 
ATOM    451  HA  ASN    29       8.102  -3.537   6.355  1.00 41.34           H 
ATOM    452 3HB  ASN    29       5.569  -4.304   7.836  1.00 38.87           H 
ATOM    453 2HB  ASN    29       7.100  -3.880   8.587  1.00 38.87           H 
ATOM    454 1HD2 ASN    29       8.839  -5.324   8.432  1.00 38.87           H 
ATOM    455 2HD2 ASN    29       8.592  -6.988   8.043  1.00 38.87           H 
ATOM    456  N   LEU    30       5.707  -3.287   4.409  1.00 42.54           N 
ATOM    457  CA  LEU    30       5.067  -3.732   3.164  1.00 61.32           C 
ATOM    458  C   LEU    30       6.007  -3.584   1.953  1.00 62.13           C 
ATOM    459  O   LEU    30       5.570  -3.662   0.807  1.00  2.11           O 
ATOM    460  CB  LEU    30       3.776  -2.933   2.923  1.00 24.14           C 
ATOM    461  CG  LEU    30       2.688  -3.094   3.998  1.00 61.14           C 
ATOM    462  CD1 LEU    30       1.493  -2.193   3.696  1.00 70.13           C 
ATOM    463  CD2 LEU    30       2.251  -4.551   4.108  1.00 20.11           C 
ATOM    464  H   LEU    30       5.621  -2.348   4.676  1.00 38.87           H 
ATOM    465  HA  LEU    30       4.812  -4.777   3.276  1.00 51.02           H 
ATOM    466 3HB  LEU    30       3.359  -3.238   1.973  1.00 38.87           H 
ATOM    467 2HB  LEU    30       4.037  -1.885   2.860  1.00 38.87           H 
ATOM    468  HG  LEU    30       3.092  -2.795   4.956  1.00 61.31           H 
ATOM    469 1HD1 LEU    30       0.737  -2.329   4.455  1.00 38.87           H 
ATOM    470 2HD1 LEU    30       1.080  -2.449   2.730  1.00 38.87           H 
ATOM    471 3HD1 LEU    30       1.812  -1.161   3.688  1.00 38.87           H 
ATOM    472 1HD2 LEU    30       3.098  -5.161   4.389  1.00 38.87           H 
ATOM    473 2HD2 LEU    30       1.867  -4.888   3.155  1.00 38.87           H 
ATOM    474 3HD2 LEU    30       1.479  -4.642   4.859  1.00 38.87           H 
ATOM    475  N   GLY    31       7.298  -3.384   2.208  1.00  4.45           N 
ATOM    476  CA  GLY    31       8.267  -3.263   1.121  1.00 25.11           C 
ATOM    477  C   GLY    31       8.489  -4.576   0.377  1.00 51.33           C 
ATOM    478  O   GLY    31       8.813  -4.585  -0.811  1.00 73.35           O 
ATOM    479  H   GLY    31       7.599  -3.325   3.139  1.00 38.87           H 
ATOM    480 3HA  GLY    31       9.210  -2.932   1.534  1.00 38.87           H 
ATOM    481 2HA  GLY    31       7.918  -2.520   0.419  1.00 38.87           H 
ATOM    482  N   CYS    32       8.287  -5.688   1.081  1.00 72.02           N 
ATOM    483  CA  CYS    32       8.477  -7.034   0.510  1.00 52.11           C 
ATOM    484  C   CYS    32       7.477  -7.351  -0.620  1.00 14.33           C 
ATOM    485  O   CYS    32       7.585  -8.391  -1.272  1.00 35.15           O 
ATOM    486  CB  CYS    32       8.352  -8.092   1.616  1.00 20.22           C 
ATOM    487  SG  CYS    32       9.502  -7.864   2.995  1.00 30.33           S 
ATOM    488  H   CYS    32       8.028  -5.606   2.026  1.00 38.87           H 
ATOM    489  HA  CYS    32       9.479  -7.080   0.105  1.00 13.22           H 
ATOM    490 3HB  CYS    32       8.538  -9.069   1.194  1.00 38.87           H 
ATOM    491 2HB  CYS    32       7.351  -8.064   2.020  1.00 38.87           H 
ATOM    492  HG  CYS    32       9.160  -8.712   3.958  1.00  3.32           H 
ATOM    493  N   ILE    33       6.510  -6.455  -0.857  1.00 11.23           N 
ATOM    494  CA  ILE    33       5.483  -6.663  -1.894  1.00 42.40           C 
ATOM    495  C   ILE    33       6.089  -6.954  -3.277  1.00  4.14           C 
ATOM    496  O   ILE    33       5.490  -7.666  -4.089  1.00 21.25           O 
ATOM    497  CB  ILE    33       4.536  -5.443  -2.016  1.00 34.23           C 
ATOM    498  CG1 ILE    33       5.346  -4.154  -2.264  1.00 44.15           C 
ATOM    499  CG2 ILE    33       3.659  -5.319  -0.769  1.00 34.32           C 
ATOM    500  CD1 ILE    33       4.493  -2.917  -2.453  1.00 44.31           C 
ATOM    501  H   ILE    33       6.486  -5.633  -0.322  1.00 38.87           H 
ATOM    502  HA  ILE    33       4.888  -7.517  -1.596  1.00 43.20           H 
ATOM    503  HB  ILE    33       3.880  -5.612  -2.861  1.00 31.14           H 
ATOM    504 3HG1 ILE    33       5.948  -4.279  -3.155  1.00 38.87           H 
ATOM    505 2HG1 ILE    33       5.998  -3.977  -1.422  1.00 38.87           H 
ATOM    506 1HG2 ILE    33       4.284  -5.174   0.101  1.00 38.87           H 
ATOM    507 2HG2 ILE    33       3.076  -6.220  -0.646  1.00 38.87           H 
ATOM    508 3HG2 ILE    33       2.992  -4.474  -0.877  1.00 38.87           H 
ATOM    509 1HD1 ILE    33       3.902  -2.745  -1.565  1.00 38.87           H 
ATOM    510 2HD1 ILE    33       3.838  -3.055  -3.301  1.00 38.87           H 
ATOM    511 3HD1 ILE    33       5.133  -2.064  -2.630  1.00 38.87           H 
ATOM    512  N   GLY    34       7.265  -6.394  -3.547  1.00 63.23           N 
ATOM    513  CA  GLY    34       7.939  -6.647  -4.814  1.00 72.44           C 
ATOM    514  C   GLY    34       8.489  -8.069  -4.918  1.00 55.21           C 
ATOM    515  O   GLY    34       8.434  -8.691  -5.979  1.00  4.52           O 
ATOM    516  H   GLY    34       7.679  -5.800  -2.881  1.00 38.87           H 
ATOM    517 3HA  GLY    34       8.759  -5.952  -4.918  1.00 38.87           H 
ATOM    518 2HA  GLY    34       7.240  -6.483  -5.620  1.00 38.87           H 
ATOM    519  N   CYS    35       9.005  -8.589  -3.808  1.00  2.01           N 
ATOM    520  CA  CYS    35       9.587  -9.938  -3.775  1.00 52.44           C 
ATOM    521  C   CYS    35       8.500 -11.026  -3.747  1.00 23.13           C 
ATOM    522  O   CYS    35       8.498 -11.938  -4.576  1.00 35.54           O 
ATOM    523  CB  CYS    35      10.504 -10.083  -2.555  1.00 45.14           C 
ATOM    524  SG  CYS    35      11.322 -11.690  -2.418  1.00 44.42           S 
ATOM    525  H   CYS    35       8.999  -8.054  -2.987  1.00 38.87           H 
ATOM    526  HA  CYS    35      10.180 -10.065  -4.672  1.00 14.22           H 
ATOM    527 3HB  CYS    35       9.921  -9.933  -1.657  1.00 38.87           H 
ATOM    528 2HB  CYS    35      11.275  -9.330  -2.605  1.00 38.87           H 
ATOM    529  HG  CYS    35      10.648 -12.559  -3.160  1.00 22.02           H 
ATOM    530  N   MET    36       7.564 -10.914  -2.801  1.00 55.31           N 
ATOM    531  CA  MET    36       6.475 -11.897  -2.654  1.00 70.22           C 
ATOM    532  C   MET    36       5.467 -11.836  -3.823  1.00 43.33           C 
ATOM    533  O   MET    36       4.520 -12.621  -3.879  1.00 61.33           O 
ATOM    534  CB  MET    36       5.745 -11.684  -1.316  1.00 63.22           C 
ATOM    535  CG  MET    36       5.045 -10.335  -1.197  1.00 54.23           C 
ATOM    536  SD  MET    36       4.314 -10.059   0.433  1.00 50.02           S 
ATOM    537  CE  MET    36       3.132 -11.405   0.521  1.00  5.25           C 
ATOM    538  H   MET    36       7.613 -10.160  -2.173  1.00 38.87           H 
ATOM    539  HA  MET    36       6.925 -12.880  -2.647  1.00 60.22           H 
ATOM    540 3HB  MET    36       6.463 -11.762  -0.512  1.00 38.87           H 
ATOM    541 2HB  MET    36       5.005 -12.461  -1.195  1.00 38.87           H 
ATOM    542 3HG  MET    36       4.261 -10.285  -1.939  1.00 38.87           H 
ATOM    543 2HG  MET    36       5.764  -9.553  -1.386  1.00 38.87           H 
ATOM    544 1HE  MET    36       2.410 -11.304  -0.276  1.00 38.87           H 
ATOM    545 2HE  MET    36       2.623 -11.376   1.473  1.00 38.87           H 
ATOM    546 3HE  MET    36       3.651 -12.347   0.418  1.00 38.87           H 
ATOM    547  N   GLY    37       5.675 -10.901  -4.753  1.00 33.50           N 
ATOM    548  CA  GLY    37       4.788 -10.772  -5.909  1.00 30.42           C 
ATOM    549  C   GLY    37       3.416 -10.192  -5.565  1.00  5.13           C 
ATOM    550  O   GLY    37       2.431 -10.448  -6.257  1.00 43.15           O 
ATOM    551  H   GLY    37       6.445 -10.303  -4.665  1.00 38.87           H 
ATOM    552 3HA  GLY    37       4.652 -11.749  -6.353  1.00 38.87           H 
ATOM    553 2HA  GLY    37       5.261 -10.127  -6.635  1.00 38.87           H 
ATOM    554  N   ALA    38       3.358  -9.380  -4.511  1.00 21.33           N 
ATOM    555  CA  ALA    38       2.093  -8.779  -4.065  1.00 60.21           C 
ATOM    556  C   ALA    38       1.722  -7.537  -4.893  1.00 53.12           C 
ATOM    557  O   ALA    38       0.788  -6.812  -4.559  1.00 43.01           O 
ATOM    558  CB  ALA    38       2.174  -8.425  -2.585  1.00 32.44           C 
ATOM    559  H   ALA    38       4.182  -9.176  -4.022  1.00 38.87           H 
ATOM    560  HA  ALA    38       1.314  -9.519  -4.187  1.00 30.24           H 
ATOM    561 1HB  ALA    38       1.215  -8.054  -2.249  1.00 38.87           H 
ATOM    562 2HB  ALA    38       2.927  -7.665  -2.435  1.00 38.87           H 
ATOM    563 3HB  ALA    38       2.435  -9.306  -2.017  1.00 38.87           H 
ATOM    564  N   GLN    39       2.454  -7.300  -5.983  1.00 51.54           N 
ATOM    565  CA  GLN    39       2.170  -6.172  -6.880  1.00 52.21           C 
ATOM    566  C   GLN    39       0.734  -6.247  -7.425  1.00 44.13           C 
ATOM    567  O   GLN    39       0.021  -5.245  -7.482  1.00 62.22           O 
ATOM    568  CB  GLN    39       3.172  -6.155  -8.048  1.00 11.11           C 
ATOM    569  CG  GLN    39       4.633  -6.038  -7.616  1.00 12.04           C 
ATOM    570  CD  GLN    39       4.929  -4.760  -6.846  1.00  1.14           C 
ATOM    571  OE1 GLN    39       5.269  -3.732  -7.422  1.00  1.24           O 
ATOM    572  NE2 GLN    39       4.808  -4.815  -5.535  1.00 63.04           N 
ATOM    573  H   GLN    39       3.202  -7.898  -6.190  1.00 38.87           H 
ATOM    574  HA  GLN    39       2.278  -5.259  -6.310  1.00  0.22           H 
ATOM    575 3HB  GLN    39       2.944  -5.319  -8.692  1.00 38.87           H 
ATOM    576 2HB  GLN    39       3.062  -7.071  -8.611  1.00 38.87           H 
ATOM    577 3HG  GLN    39       5.260  -6.061  -8.499  1.00 38.87           H 
ATOM    578 2HG  GLN    39       4.876  -6.882  -6.988  1.00 38.87           H 
ATOM    579 1HE2 GLN    39       4.541  -5.665  -5.130  1.00 38.87           H 
ATOM    580 2HE2 GLN    39       4.990  -4.002  -5.025  1.00 38.87           H 
ATOM    581  N   ASN    40       0.312  -7.455  -7.794  1.00 54.11           N 
ATOM    582  CA  ASN    40      -1.031  -7.687  -8.351  1.00 74.13           C 
ATOM    583  C   ASN    40      -2.066  -7.944  -7.243  1.00 65.32           C 
ATOM    584  O   ASN    40      -3.183  -8.388  -7.511  1.00 44.31           O 
ATOM    585  CB  ASN    40      -0.988  -8.888  -9.306  1.00 10.04           C 
ATOM    586  CG  ASN    40       0.065  -8.732 -10.388  1.00 23.32           C 
ATOM    587  OD1 ASN    40       0.360  -7.628 -10.832  1.00 44.11           O 
ATOM    588  ND2 ASN    40       0.653  -9.832 -10.809  1.00 53.43           N 
ATOM    589  H   ASN    40       0.917  -8.217  -7.689  1.00 38.87           H 
ATOM    590  HA  ASN    40      -1.324  -6.805  -8.904  1.00 74.51           H 
ATOM    591 3HB  ASN    40      -1.953  -8.997  -9.783  1.00 38.87           H 
ATOM    592 2HB  ASN    40      -0.768  -9.784  -8.741  1.00 38.87           H 
ATOM    593 1HD2 ASN    40       0.382 -10.685 -10.410  1.00 38.87           H 
ATOM    594 2HD2 ASN    40       1.346  -9.750 -11.497  1.00 38.87           H 
ATOM    595  N   GLU    41      -1.689  -7.659  -6.000  1.00 31.21           N 
ATOM    596  CA  GLU    41      -2.548  -7.924  -4.840  1.00 53.43           C 
ATOM    597  C   GLU    41      -3.092  -6.616  -4.235  1.00 12.33           C 
ATOM    598  O   GLU    41      -2.418  -5.583  -4.261  1.00 43.41           O 
ATOM    599  CB  GLU    41      -1.748  -8.714  -3.796  1.00 42.53           C 
ATOM    600  CG  GLU    41      -2.547  -9.119  -2.567  1.00 52.30           C 
ATOM    601  CD  GLU    41      -1.776 -10.052  -1.644  1.00 31.01           C 
ATOM    602  OE1 GLU    41      -1.786 -11.279  -1.891  1.00 53.45           O 
ATOM    603  OE2 GLU    41      -1.162  -9.572  -0.672  1.00 62.01           O 
ATOM    604  H   GLU    41      -0.811  -7.253  -5.852  1.00 38.87           H 
ATOM    605  HA  GLU    41      -3.383  -8.527  -5.172  1.00 51.41           H 
ATOM    606 3HB  GLU    41      -0.912  -8.110  -3.470  1.00 38.87           H 
ATOM    607 2HB  GLU    41      -1.366  -9.613  -4.260  1.00 38.87           H 
ATOM    608 3HG  GLU    41      -3.451  -9.617  -2.890  1.00 38.87           H 
ATOM    609 2HG  GLU    41      -2.810  -8.226  -2.017  1.00 38.87           H 
ATOM    610  N   SER    42      -4.319  -6.661  -3.706  1.00 41.03           N 
ATOM    611  CA  SER    42      -4.961  -5.470  -3.118  1.00  3.23           C 
ATOM    612  C   SER    42      -4.293  -5.049  -1.800  1.00 11.01           C 
ATOM    613  O   SER    42      -3.789  -5.888  -1.050  1.00 32.42           O 
ATOM    614  CB  SER    42      -6.458  -5.722  -2.873  1.00 14.55           C 
ATOM    615  OG  SER    42      -7.145  -6.007  -4.084  1.00 70.13           O 
ATOM    616  H   SER    42      -4.807  -7.510  -3.713  1.00 38.87           H 
ATOM    617  HA  SER    42      -4.859  -4.661  -3.828  1.00 32.13           H 
ATOM    618 3HB  SER    42      -6.900  -4.843  -2.425  1.00 38.87           H 
ATOM    619 2HB  SER    42      -6.576  -6.561  -2.204  1.00 38.87           H 
ATOM    620  HG  SER    42      -7.870  -5.378  -4.197  1.00 72.35           H 
ATOM    621  N   LEU    43      -4.334  -3.745  -1.511  1.00 34.52           N 
ATOM    622  CA  LEU    43      -3.680  -3.178  -0.320  1.00 51.01           C 
ATOM    623  C   LEU    43      -4.101  -3.890   0.980  1.00 74.01           C 
ATOM    624  O   LEU    43      -3.260  -4.209   1.824  1.00 54.43           O 
ATOM    625  CB  LEU    43      -3.980  -1.673  -0.207  1.00 41.31           C 
ATOM    626  CG  LEU    43      -3.465  -0.804  -1.370  1.00 64.44           C 
ATOM    627  CD1 LEU    43      -3.791   0.670  -1.132  1.00 51.40           C 
ATOM    628  CD2 LEU    43      -1.961  -0.997  -1.560  1.00 34.20           C 
ATOM    629  H   LEU    43      -4.808  -3.142  -2.124  1.00 38.87           H 
ATOM    630  HA  LEU    43      -2.614  -3.305  -0.446  1.00 12.32           H 
ATOM    631 3HB  LEU    43      -3.535  -1.307   0.707  1.00 38.87           H 
ATOM    632 2HB  LEU    43      -5.052  -1.546  -0.137  1.00 38.87           H 
ATOM    633  HG  LEU    43      -3.958  -1.109  -2.283  1.00 73.25           H 
ATOM    634 1HD1 LEU    43      -3.449   1.257  -1.973  1.00 38.87           H 
ATOM    635 2HD1 LEU    43      -3.297   1.009  -0.233  1.00 38.87           H 
ATOM    636 3HD1 LEU    43      -4.859   0.790  -1.020  1.00 38.87           H 
ATOM    637 1HD2 LEU    43      -1.442  -0.711  -0.656  1.00 38.87           H 
ATOM    638 2HD2 LEU    43      -1.617  -0.382  -2.380  1.00 38.87           H 
ATOM    639 3HD2 LEU    43      -1.755  -2.035  -1.781  1.00 38.87           H 
ATOM    640  N   GLU    44      -5.401  -4.143   1.137  1.00 63.43           N 
ATOM    641  CA  GLU    44      -5.916  -4.782   2.357  1.00 53.33           C 
ATOM    642  C   GLU    44      -5.391  -6.221   2.516  1.00 13.40           C 
ATOM    643  O   GLU    44      -5.106  -6.668   3.631  1.00 42.44           O 
ATOM    644  CB  GLU    44      -7.454  -4.769   2.367  1.00  1.52           C 
ATOM    645  CG  GLU    44      -8.063  -5.312   3.657  1.00 44.00           C 
ATOM    646  CD  GLU    44      -9.574  -5.141   3.724  1.00 71.34           C 
ATOM    647  OE1 GLU    44     -10.303  -5.980   3.152  1.00 73.53           O 
ATOM    648  OE2 GLU    44     -10.040  -4.172   4.363  1.00 70.00           O 
ATOM    649  H   GLU    44      -6.026  -3.892   0.422  1.00 38.87           H 
ATOM    650  HA  GLU    44      -5.565  -4.200   3.198  1.00 63.33           H 
ATOM    651 3HB  GLU    44      -7.817  -5.367   1.541  1.00 38.87           H 
ATOM    652 2HB  GLU    44      -7.792  -3.751   2.237  1.00 38.87           H 
ATOM    653 3HG  GLU    44      -7.618  -4.791   4.494  1.00 38.87           H 
ATOM    654 2HG  GLU    44      -7.832  -6.366   3.735  1.00 38.87           H 
ATOM    655  N   GLN    45      -5.236  -6.928   1.397  1.00 42.12           N 
ATOM    656  CA  GLN    45      -4.756  -8.316   1.419  1.00 51.24           C 
ATOM    657  C   GLN    45      -3.315  -8.398   1.954  1.00 43.02           C 
ATOM    658  O   GLN    45      -3.017  -9.191   2.854  1.00 75.43           O 
ATOM    659  CB  GLN    45      -4.839  -8.928   0.013  1.00 52.21           C 
ATOM    660  CG  GLN    45      -6.252  -8.961  -0.564  1.00 72.12           C 
ATOM    661  CD  GLN    45      -6.314  -9.557  -1.964  1.00 24.00           C 
ATOM    662  OE1 GLN    45      -5.518 -10.415  -2.330  1.00  4.23           O 
ATOM    663  NE2 GLN    45      -7.260  -9.104  -2.762  1.00 52.32           N 
ATOM    664  H   GLN    45      -5.437  -6.506   0.536  1.00 38.87           H 
ATOM    665  HA  GLN    45      -5.400  -8.876   2.083  1.00 63.43           H 
ATOM    666 3HB  GLN    45      -4.464  -9.941   0.049  1.00 38.87           H 
ATOM    667 2HB  GLN    45      -4.216  -8.349  -0.655  1.00 38.87           H 
ATOM    668 3HG  GLN    45      -6.632  -7.950  -0.601  1.00 38.87           H 
ATOM    669 2HG  GLN    45      -6.878  -9.554   0.087  1.00 38.87           H 
ATOM    670 1HE2 GLN    45      -7.869  -8.417  -2.416  1.00 38.87           H 
ATOM    671 2HE2 GLN    45      -7.316  -9.472  -3.668  1.00 38.87           H 
ATOM    672  N   GLY    46      -2.431  -7.567   1.405  1.00 51.42           N 
ATOM    673  CA  GLY    46      -1.055  -7.505   1.890  1.00 71.41           C 
ATOM    674  C   GLY    46      -0.952  -6.979   3.320  1.00 35.30           C 
ATOM    675  O   GLY    46      -0.099  -7.418   4.097  1.00 44.35           O 
ATOM    676  H   GLY    46      -2.709  -7.001   0.652  1.00 38.87           H 
ATOM    677 3HA  GLY    46      -0.490  -6.853   1.241  1.00 38.87           H 
ATOM    678 2HA  GLY    46      -0.623  -8.497   1.848  1.00 38.87           H 
ATOM    679  N   ALA    47      -1.834  -6.040   3.669  1.00 64.50           N 
ATOM    680  CA  ALA    47      -1.882  -5.471   5.021  1.00 62.21           C 
ATOM    681  C   ALA    47      -2.108  -6.558   6.085  1.00 72.41           C 
ATOM    682  O   ALA    47      -1.281  -6.746   6.978  1.00 22.11           O 
ATOM    683  CB  ALA    47      -2.973  -4.409   5.107  1.00 24.11           C 
ATOM    684  H   ALA    47      -2.470  -5.715   2.996  1.00 38.87           H 
ATOM    685  HA  ALA    47      -0.932  -4.992   5.209  1.00 75.31           H 
ATOM    686 1HB  ALA    47      -2.966  -3.960   6.089  1.00 38.87           H 
ATOM    687 2HB  ALA    47      -3.936  -4.865   4.926  1.00 38.87           H 
ATOM    688 3HB  ALA    47      -2.793  -3.648   4.362  1.00 38.87           H 
ATOM    689  N   ASN    48      -3.223  -7.284   5.978  1.00 11.12           N 
ATOM    690  CA  ASN    48      -3.529  -8.366   6.926  1.00 44.43           C 
ATOM    691  C   ASN    48      -2.442  -9.455   6.910  1.00 63.01           C 
ATOM    692  O   ASN    48      -2.128 -10.047   7.946  1.00 33.10           O 
ATOM    693  CB  ASN    48      -4.901  -8.985   6.634  1.00 40.54           C 
ATOM    694  CG  ASN    48      -6.043  -8.023   6.917  1.00  0.33           C 
ATOM    695  OD1 ASN    48      -6.509  -7.907   8.047  1.00  3.44           O 
ATOM    696  ND2 ASN    48      -6.513  -7.337   5.897  1.00  3.10           N 
ATOM    697  H   ASN    48      -3.852  -7.088   5.249  1.00 38.87           H 
ATOM    698  HA  ASN    48      -3.552  -7.928   7.915  1.00 72.44           H 
ATOM    699 3HB  ASN    48      -5.034  -9.862   7.252  1.00 38.87           H 
ATOM    700 2HB  ASN    48      -4.944  -9.273   5.593  1.00 38.87           H 
ATOM    701 1HD2 ASN    48      -6.108  -7.476   5.017  1.00 38.87           H 
ATOM    702 2HD2 ASN    48      -7.252  -6.717   6.063  1.00 38.87           H 
ATOM    703  N   ALA    49      -1.859  -9.707   5.738  1.00 74.10           N 
ATOM    704  CA  ALA    49      -0.749 -10.662   5.611  1.00 51.45           C 
ATOM    705  C   ALA    49       0.451 -10.257   6.484  1.00  2.25           C 
ATOM    706  O   ALA    49       1.184 -11.109   6.990  1.00  2.32           O 
ATOM    707  CB  ALA    49      -0.318 -10.776   4.156  1.00 75.30           C 
ATOM    708  H   ALA    49      -2.189  -9.249   4.934  1.00 38.87           H 
ATOM    709  HA  ALA    49      -1.106 -11.631   5.933  1.00  3.45           H 
ATOM    710 1HB  ALA    49       0.044  -9.818   3.811  1.00 38.87           H 
ATOM    711 2HB  ALA    49      -1.159 -11.080   3.553  1.00 38.87           H 
ATOM    712 3HB  ALA    49       0.472 -11.510   4.067  1.00 38.87           H 
ATOM    713  N   HIS    50       0.650  -8.949   6.647  1.00 62.00           N 
ATOM    714  CA  HIS    50       1.732  -8.419   7.490  1.00 30.31           C 
ATOM    715  C   HIS    50       1.202  -7.970   8.871  1.00 11.52           C 
ATOM    716  O   HIS    50       1.909  -7.317   9.639  1.00 44.31           O 
ATOM    717  CB  HIS    50       2.432  -7.249   6.776  1.00 53.20           C 
ATOM    718  CG  HIS    50       3.182  -7.652   5.534  1.00  5.11           C 
ATOM    719  ND1 HIS    50       4.471  -7.246   5.264  1.00 60.44           N 
ATOM    720  CD2 HIS    50       2.810  -8.413   4.474  1.00 44.03           C 
ATOM    721  CE1 HIS    50       4.856  -7.736   4.104  1.00 51.25           C 
ATOM    722  NE2 HIS    50       3.871  -8.450   3.600  1.00 61.50           N 
ATOM    723  H   HIS    50       0.054  -8.319   6.184  1.00 38.87           H 
ATOM    724  HA  HIS    50       2.452  -9.211   7.644  1.00 34.54           H 
ATOM    725 3HB  HIS    50       3.135  -6.791   7.455  1.00 38.87           H 
ATOM    726 2HB  HIS    50       1.690  -6.517   6.491  1.00 38.87           H 
ATOM    727  HD1 HIS    50       5.034  -6.692   5.849  1.00 14.34           H 
ATOM    728  HD2 HIS    50       1.856  -8.904   4.344  1.00 22.02           H 
ATOM    729  HE1 HIS    50       5.820  -7.580   3.644  1.00 42.23           H 
ATOM    730  HE2 HIS    50       3.990  -9.127   2.899  1.00 38.87           H 
ATOM    731  N   GLY    51      -0.047  -8.331   9.173  1.00 23.15           N 
ATOM    732  CA  GLY    51      -0.641  -8.026  10.476  1.00  4.03           C 
ATOM    733  C   GLY    51      -0.895  -6.539  10.717  1.00 61.15           C 
ATOM    734  O   GLY    51      -0.739  -6.047  11.838  1.00  1.41           O 
ATOM    735  H   GLY    51      -0.572  -8.820   8.506  1.00 38.87           H 
ATOM    736 3HA  GLY    51       0.016  -8.395  11.251  1.00 38.87           H 
ATOM    737 2HA  GLY    51      -1.584  -8.547  10.551  1.00 38.87           H 
ATOM    738  N   LEU    52      -1.296  -5.823   9.673  1.00 13.43           N 
ATOM    739  CA  LEU    52      -1.580  -4.387   9.774  1.00  3.32           C 
ATOM    740  C   LEU    52      -3.032  -4.077   9.386  1.00 73.02           C 
ATOM    741  O   LEU    52      -3.703  -4.885   8.738  1.00 24.11           O 
ATOM    742  CB  LEU    52      -0.627  -3.596   8.865  1.00 41.45           C 
ATOM    743  CG  LEU    52       0.869  -3.748   9.180  1.00 21.44           C 
ATOM    744  CD1 LEU    52       1.706  -2.969   8.174  1.00 72.31           C 
ATOM    745  CD2 LEU    52       1.171  -3.285  10.604  1.00 11.11           C 
ATOM    746  H   LEU    52      -1.403  -6.270   8.808  1.00 38.87           H 
ATOM    747  HA  LEU    52      -1.421  -4.081  10.799  1.00 62.12           H 
ATOM    748 3HB  LEU    52      -0.881  -2.548   8.941  1.00 38.87           H 
ATOM    749 2HB  LEU    52      -0.794  -3.913   7.843  1.00 38.87           H 
ATOM    750  HG  LEU    52       1.145  -4.792   9.104  1.00 52.43           H 
ATOM    751 1HD1 LEU    52       2.753  -3.074   8.417  1.00 38.87           H 
ATOM    752 2HD1 LEU    52       1.432  -1.924   8.209  1.00 38.87           H 
ATOM    753 3HD1 LEU    52       1.528  -3.353   7.181  1.00 38.87           H 
ATOM    754 1HD2 LEU    52       0.603  -3.879  11.306  1.00 38.87           H 
ATOM    755 2HD2 LEU    52       0.896  -2.245  10.709  1.00 38.87           H 
ATOM    756 3HD2 LEU    52       2.226  -3.400  10.805  1.00 38.87           H 
ATOM    757  N   ASN    53      -3.520  -2.908   9.789  1.00 21.20           N 
ATOM    758  CA  ASN    53      -4.858  -2.458   9.399  1.00  1.31           C 
ATOM    759  C   ASN    53      -4.763  -1.489   8.213  1.00 60.51           C 
ATOM    760  O   ASN    53      -4.085  -0.462   8.286  1.00  3.35           O 
ATOM    761  CB  ASN    53      -5.568  -1.786  10.582  1.00 54.22           C 
ATOM    762  CG  ASN    53      -7.045  -1.541  10.321  1.00 44.44           C 
ATOM    763  OD1 ASN    53      -7.477  -1.407   9.182  1.00 23.30           O 
ATOM    764  ND2 ASN    53      -7.831  -1.471  11.375  1.00 13.44           N 
ATOM    765  H   ASN    53      -2.970  -2.333  10.363  1.00 38.87           H 
ATOM    766  HA  ASN    53      -5.427  -3.328   9.094  1.00 43.34           H 
ATOM    767 3HB  ASN    53      -5.097  -0.835  10.786  1.00 38.87           H 
ATOM    768 2HB  ASN    53      -5.478  -2.419  11.453  1.00 38.87           H 
ATOM    769 1HD2 ASN    53      -7.428  -1.581  12.261  1.00 38.87           H 
ATOM    770 2HD2 ASN    53      -8.786  -1.310  11.229  1.00 38.87           H 
ATOM    771  N   VAL    54      -5.458  -1.815   7.129  1.00 55.22           N 
ATOM    772  CA  VAL    54      -5.397  -1.020   5.902  1.00 12.33           C 
ATOM    773  C   VAL    54      -5.886   0.424   6.127  1.00 10.12           C 
ATOM    774  O   VAL    54      -5.478   1.339   5.414  1.00 44.44           O 
ATOM    775  CB  VAL    54      -6.224  -1.680   4.770  1.00 72.23           C 
ATOM    776  CG1 VAL    54      -7.711  -1.685   5.113  1.00 54.15           C 
ATOM    777  CG2 VAL    54      -5.961  -0.992   3.429  1.00  1.54           C 
ATOM    778  H   VAL    54      -6.029  -2.612   7.152  1.00 38.87           H 
ATOM    779  HA  VAL    54      -4.364  -0.989   5.586  1.00  4.41           H 
ATOM    780  HB  VAL    54      -5.905  -2.711   4.682  1.00 52.32           H 
ATOM    781 1HG1 VAL    54      -7.868  -2.238   6.028  1.00 38.87           H 
ATOM    782 2HG1 VAL    54      -8.264  -2.152   4.313  1.00 38.87           H 
ATOM    783 3HG1 VAL    54      -8.057  -0.668   5.244  1.00 38.87           H 
ATOM    784 1HG2 VAL    54      -6.270   0.043   3.486  1.00 38.87           H 
ATOM    785 2HG2 VAL    54      -6.522  -1.491   2.653  1.00 38.87           H 
ATOM    786 3HG2 VAL    54      -4.907  -1.041   3.199  1.00 38.87           H 
ATOM    787  N   GLU    55      -6.747   0.622   7.129  1.00  2.41           N 
ATOM    788  CA  GLU    55      -7.280   1.956   7.445  1.00 32.13           C 
ATOM    789  C   GLU    55      -6.154   2.971   7.712  1.00 43.44           C 
ATOM    790  O   GLU    55      -6.118   4.051   7.113  1.00 64.42           O 
ATOM    791  CB  GLU    55      -8.210   1.886   8.667  1.00 23.34           C 
ATOM    792  CG  GLU    55      -9.406   0.955   8.494  1.00 73.43           C 
ATOM    793  CD  GLU    55     -10.260   1.294   7.284  1.00 64.30           C 
ATOM    794  OE1 GLU    55     -10.823   2.411   7.240  1.00 63.25           O 
ATOM    795  OE2 GLU    55     -10.388   0.439   6.382  1.00 33.35           O 
ATOM    796  H   GLU    55      -7.036  -0.145   7.667  1.00 38.87           H 
ATOM    797  HA  GLU    55      -7.852   2.289   6.592  1.00 24.50           H 
ATOM    798 3HB  GLU    55      -8.583   2.879   8.879  1.00 38.87           H 
ATOM    799 2HB  GLU    55      -7.640   1.541   9.518  1.00 38.87           H 
ATOM    800 3HG  GLU    55     -10.022   1.021   9.380  1.00 38.87           H 
ATOM    801 2HG  GLU    55      -9.043  -0.058   8.390  1.00 38.87           H 
ATOM    802  N   ASP    56      -5.234   2.611   8.608  1.00 25.43           N 
ATOM    803  CA  ASP    56      -4.102   3.480   8.956  1.00 72.02           C 
ATOM    804  C   ASP    56      -3.191   3.719   7.738  1.00 71.12           C 
ATOM    805  O   ASP    56      -2.635   4.806   7.561  1.00 55.40           O 
ATOM    806  CB  ASP    56      -3.302   2.860  10.109  1.00 72.35           C 
ATOM    807  CG  ASP    56      -2.157   3.750  10.562  1.00 62.42           C 
ATOM    808  OD1 ASP    56      -2.426   4.820  11.139  1.00 53.10           O 
ATOM    809  OD2 ASP    56      -0.983   3.388  10.344  1.00 42.03           O 
ATOM    810  H   ASP    56      -5.316   1.741   9.049  1.00 38.87           H 
ATOM    811  HA  ASP    56      -4.504   4.430   9.280  1.00 33.13           H 
ATOM    812 3HB  ASP    56      -2.897   1.909   9.792  1.00 38.87           H 
ATOM    813 2HB  ASP    56      -3.962   2.699  10.952  1.00 38.87           H 
ATOM    814  N   ILE    57      -3.056   2.695   6.898  1.00 72.32           N 
ATOM    815  CA  ILE    57      -2.252   2.794   5.676  1.00 42.34           C 
ATOM    816  C   ILE    57      -2.869   3.807   4.693  1.00 13.41           C 
ATOM    817  O   ILE    57      -2.199   4.735   4.233  1.00 50.14           O 
ATOM    818  CB  ILE    57      -2.119   1.411   4.984  1.00 52.34           C 
ATOM    819  CG1 ILE    57      -1.555   0.377   5.975  1.00 62.34           C 
ATOM    820  CG2 ILE    57      -1.232   1.514   3.742  1.00 75.10           C 
ATOM    821  CD1 ILE    57      -1.460  -1.026   5.412  1.00 62.13           C 
ATOM    822  H   ILE    57      -3.512   1.851   7.104  1.00 38.87           H 
ATOM    823  HA  ILE    57      -1.264   3.133   5.955  1.00 63.13           H 
ATOM    824  HB  ILE    57      -3.104   1.094   4.666  1.00 55.12           H 
ATOM    825 3HG1 ILE    57      -2.194   0.339   6.847  1.00 38.87           H 
ATOM    826 2HG1 ILE    57      -0.563   0.677   6.276  1.00 38.87           H 
ATOM    827 1HG2 ILE    57      -1.150   0.545   3.270  1.00 38.87           H 
ATOM    828 2HG2 ILE    57      -0.249   1.859   4.028  1.00 38.87           H 
ATOM    829 3HG2 ILE    57      -1.668   2.216   3.046  1.00 38.87           H 
ATOM    830 1HD1 ILE    57      -2.443  -1.365   5.120  1.00 38.87           H 
ATOM    831 2HD1 ILE    57      -1.060  -1.689   6.165  1.00 38.87           H 
ATOM    832 3HD1 ILE    57      -0.809  -1.027   4.549  1.00 38.87           H 
ATOM    833  N   LEU    58      -4.158   3.631   4.396  1.00 30.44           N 
ATOM    834  CA  LEU    58      -4.887   4.540   3.500  1.00 61.54           C 
ATOM    835  C   LEU    58      -4.835   5.985   4.017  1.00 50.43           C 
ATOM    836  O   LEU    58      -4.753   6.934   3.236  1.00 73.43           O 
ATOM    837  CB  LEU    58      -6.350   4.097   3.356  1.00 50.24           C 
ATOM    838  CG  LEU    58      -6.562   2.680   2.795  1.00 43.33           C 
ATOM    839  CD1 LEU    58      -8.053   2.367   2.669  1.00 52.13           C 
ATOM    840  CD2 LEU    58      -5.852   2.516   1.452  1.00 33.40           C 
ATOM    841  H   LEU    58      -4.634   2.872   4.792  1.00 38.87           H 
ATOM    842  HA  LEU    58      -4.409   4.500   2.531  1.00  0.51           H 
ATOM    843 3HB  LEU    58      -6.852   4.797   2.703  1.00 38.87           H 
ATOM    844 2HB  LEU    58      -6.815   4.147   4.333  1.00 38.87           H 
ATOM    845  HG  LEU    58      -6.136   1.963   3.485  1.00 62.02           H 
ATOM    846 1HD1 LEU    58      -8.180   1.373   2.264  1.00 38.87           H 
ATOM    847 2HD1 LEU    58      -8.521   3.084   2.010  1.00 38.87           H 
ATOM    848 3HD1 LEU    58      -8.517   2.418   3.643  1.00 38.87           H 
ATOM    849 1HD2 LEU    58      -4.791   2.677   1.581  1.00 38.87           H 
ATOM    850 2HD2 LEU    58      -6.240   3.237   0.745  1.00 38.87           H 
ATOM    851 3HD2 LEU    58      -6.018   1.518   1.074  1.00 38.87           H 
ATOM    852  N   ARG    59      -4.891   6.136   5.338  1.00 11.23           N 
ATOM    853  CA  ARG    59      -4.777   7.449   5.982  1.00 25.24           C 
ATOM    854  C   ARG    59      -3.526   8.207   5.502  1.00 55.33           C 
ATOM    855  O   ARG    59      -3.619   9.327   4.989  1.00 65.22           O 
ATOM    856  CB  ARG    59      -4.711   7.274   7.509  1.00 64.02           C 
ATOM    857  CG  ARG    59      -4.328   8.546   8.269  1.00  0.44           C 
ATOM    858  CD  ARG    59      -3.902   8.249   9.706  1.00 74.21           C 
ATOM    859  NE  ARG    59      -2.835   7.248   9.764  1.00 51.41           N 
ATOM    860  CZ  ARG    59      -1.595   7.454   9.400  1.00 60.32           C 
ATOM    861  NH1 ARG    59      -1.207   8.617   8.977  1.00 71.44           N 
ATOM    862  NH2 ARG    59      -0.741   6.487   9.470  1.00 34.04           N 
ATOM    863  H   ARG    59      -5.019   5.340   5.900  1.00 38.87           H 
ATOM    864  HA  ARG    59      -5.657   8.023   5.730  1.00  4.43           H 
ATOM    865 3HB  ARG    59      -3.981   6.510   7.738  1.00 38.87           H 
ATOM    866 2HB  ARG    59      -5.680   6.947   7.864  1.00 38.87           H 
ATOM    867 3HG  ARG    59      -5.178   9.215   8.286  1.00 38.87           H 
ATOM    868 2HG  ARG    59      -3.507   9.026   7.757  1.00 38.87           H 
ATOM    869 3HD  ARG    59      -4.757   7.880  10.254  1.00 38.87           H 
ATOM    870 2HD  ARG    59      -3.551   9.163  10.163  1.00 38.87           H 
ATOM    871  HE  ARG    59      -3.072   6.359  10.101  1.00 63.33           H 
ATOM    872 1HH1 ARG    59      -1.852   9.375   8.934  1.00 38.87           H 
ATOM    873 2HH1 ARG    59      -0.259   8.751   8.688  1.00 38.87           H 
ATOM    874 1HH2 ARG    59      -1.033   5.593   9.808  1.00 38.87           H 
ATOM    875 2HH2 ARG    59       0.203   6.632   9.187  1.00 38.87           H 
ATOM    876  N   ASP    60      -2.359   7.585   5.668  1.00 53.22           N 
ATOM    877  CA  ASP    60      -1.088   8.234   5.346  1.00 63.13           C 
ATOM    878  C   ASP    60      -0.873   8.340   3.822  1.00 62.14           C 
ATOM    879  O   ASP    60      -0.331   9.332   3.328  1.00 44.05           O 
ATOM    880  CB  ASP    60       0.069   7.476   6.015  1.00 73.14           C 
ATOM    881  CG  ASP    60       1.209   8.400   6.410  1.00 25.13           C 
ATOM    882  OD1 ASP    60       2.176   8.534   5.637  1.00 61.03           O 
ATOM    883  OD2 ASP    60       1.129   9.006   7.505  1.00  0.21           O 
ATOM    884  H   ASP    60      -2.351   6.665   6.016  1.00 38.87           H 
ATOM    885  HA  ASP    60      -1.126   9.237   5.754  1.00 42.44           H 
ATOM    886 3HB  ASP    60       0.449   6.729   5.332  1.00 38.87           H 
ATOM    887 2HB  ASP    60      -0.298   6.987   6.906  1.00 38.87           H 
ATOM    888  N   LEU    61      -1.312   7.317   3.082  1.00 24.25           N 
ATOM    889  CA  LEU    61      -1.205   7.317   1.614  1.00 43.24           C 
ATOM    890  C   LEU    61      -2.027   8.455   0.985  1.00 51.04           C 
ATOM    891  O   LEU    61      -1.540   9.188   0.124  1.00 71.55           O 
ATOM    892  CB  LEU    61      -1.663   5.971   1.031  1.00  4.30           C 
ATOM    893  CG  LEU    61      -0.806   4.752   1.412  1.00 73.10           C 
ATOM    894  CD1 LEU    61      -1.315   3.497   0.704  1.00 71.04           C 
ATOM    895  CD2 LEU    61       0.664   5.004   1.086  1.00  0.30           C 
ATOM    896  H   LEU    61      -1.707   6.538   3.534  1.00 38.87           H 
ATOM    897  HA  LEU    61      -0.165   7.468   1.363  1.00 44.53           H 
ATOM    898 3HB  LEU    61      -1.665   6.054  -0.047  1.00 38.87           H 
ATOM    899 2HB  LEU    61      -2.678   5.788   1.358  1.00 38.87           H 
ATOM    900  HG  LEU    61      -0.888   4.584   2.477  1.00 74.01           H 
ATOM    901 1HD1 LEU    61      -2.333   3.298   1.008  1.00 38.87           H 
ATOM    902 2HD1 LEU    61      -0.691   2.654   0.970  1.00 38.87           H 
ATOM    903 3HD1 LEU    61      -1.281   3.646  -0.365  1.00 38.87           H 
ATOM    904 1HD2 LEU    61       0.764   5.260   0.041  1.00 38.87           H 
ATOM    905 2HD2 LEU    61       1.238   4.114   1.295  1.00 38.87           H 
ATOM    906 3HD2 LEU    61       1.033   5.819   1.694  1.00 38.87           H 
ATOM    907  N   ASN    62      -3.279   8.592   1.413  1.00 14.32           N 
ATOM    908  CA  ASN    62      -4.150   9.674   0.930  1.00 43.21           C 
ATOM    909  C   ASN    62      -3.579  11.055   1.291  1.00 40.41           C 
ATOM    910  O   ASN    62      -3.788  12.036   0.574  1.00 53.15           O 
ATOM    911  CB  ASN    62      -5.567   9.510   1.496  1.00 22.11           C 
ATOM    912  CG  ASN    62      -6.316   8.353   0.854  1.00 42.31           C 
ATOM    913  OD1 ASN    62      -6.193   8.102  -0.339  1.00 21.13           O 
ATOM    914  ND2 ASN    62      -7.086   7.629   1.641  1.00 42.20           N 
ATOM    915  H   ASN    62      -3.629   7.949   2.068  1.00 38.87           H 
ATOM    916  HA  ASN    62      -4.196   9.596  -0.147  1.00 21.13           H 
ATOM    917 3HB  ASN    62      -6.127  10.417   1.319  1.00 38.87           H 
ATOM    918 2HB  ASN    62      -5.507   9.332   2.560  1.00 38.87           H 
ATOM    919 1HD2 ASN    62      -7.139   7.870   2.586  1.00 38.87           H 
ATOM    920 2HD2 ASN    62      -7.568   6.874   1.242  1.00 38.87           H 
ATOM    921  N   ALA    63      -2.843  11.119   2.398  1.00 23.15           N 
ATOM    922  CA  ALA    63      -2.149  12.349   2.795  1.00 10.24           C 
ATOM    923  C   ALA    63      -1.080  12.743   1.759  1.00 72.40           C 
ATOM    924  O   ALA    63      -0.778  13.926   1.582  1.00 54.04           O 
ATOM    925  CB  ALA    63      -1.530  12.177   4.177  1.00 62.15           C 
ATOM    926  H   ALA    63      -2.767  10.323   2.966  1.00 38.87           H 
ATOM    927  HA  ALA    63      -2.886  13.139   2.853  1.00 22.24           H 
ATOM    928 1HB  ALA    63      -1.071  13.106   4.485  1.00 38.87           H 
ATOM    929 2HB  ALA    63      -0.780  11.400   4.143  1.00 38.87           H 
ATOM    930 3HB  ALA    63      -2.298  11.904   4.887  1.00 38.87           H 
ATOM    931  N   LEU    64      -0.514  11.739   1.077  1.00  2.21           N 
ATOM    932  CA  LEU    64       0.438  11.977  -0.019  1.00 60.51           C 
ATOM    933  C   LEU    64      -0.259  12.629  -1.224  1.00 22.12           C 
ATOM    934  O   LEU    64       0.378  13.298  -2.035  1.00 61.31           O 
ATOM    935  CB  LEU    64       1.087  10.657  -0.470  1.00 34.34           C 
ATOM    936  CG  LEU    64       1.870   9.892   0.607  1.00  0.14           C 
ATOM    937  CD1 LEU    64       2.339   8.543   0.064  1.00 70.33           C 
ATOM    938  CD2 LEU    64       3.054  10.720   1.105  1.00 23.33           C 
ATOM    939  H   LEU    64      -0.742  10.813   1.318  1.00 38.87           H 
ATOM    940  HA  LEU    64       1.209  12.644   0.344  1.00  5.14           H 
ATOM    941 3HB  LEU    64       1.765  10.874  -1.285  1.00 38.87           H 
ATOM    942 2HB  LEU    64       0.306  10.010  -0.845  1.00 38.87           H 
ATOM    943  HG  LEU    64       1.219   9.702   1.448  1.00 74.32           H 
ATOM    944 1HD1 LEU    64       2.894   8.019   0.829  1.00 38.87           H 
ATOM    945 2HD1 LEU    64       2.973   8.697  -0.798  1.00 38.87           H 
ATOM    946 3HD1 LEU    64       1.480   7.952  -0.224  1.00 38.87           H 
ATOM    947 1HD2 LEU    64       3.595  10.163   1.857  1.00 38.87           H 
ATOM    948 2HD2 LEU    64       2.694  11.643   1.535  1.00 38.87           H 
ATOM    949 3HD2 LEU    64       3.715  10.943   0.278  1.00 38.87           H 
ATOM    950  N   ALA    65      -1.567  12.402  -1.347  1.00  0.42           N 
ATOM    951  CA  ALA    65      -2.361  12.995  -2.428  1.00 64.02           C 
ATOM    952  C   ALA    65      -2.726  14.456  -2.120  1.00  4.00           C 
ATOM    953  O   ALA    65      -2.710  15.315  -3.006  1.00 25.43           O 
ATOM    954  CB  ALA    65      -3.621  12.168  -2.671  1.00 45.01           C 
ATOM    955  H   ALA    65      -2.010  11.816  -0.697  1.00 38.87           H 
ATOM    956  HA  ALA    65      -1.765  12.969  -3.331  1.00  3.23           H 
ATOM    957 1HB  ALA    65      -3.345  11.142  -2.874  1.00 38.87           H 
ATOM    958 2HB  ALA    65      -4.161  12.568  -3.518  1.00 38.87           H 
ATOM    959 3HB  ALA    65      -4.251  12.202  -1.794  1.00 38.87           H 
END
