
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  161 ( 1231),  selected  161 , name 1xx7_D
# Molecule2: number of CA atoms   97 (  787),  selected   97 , name T0470_2_100.pdb
# PARAMETERS: 1xx7_D.T0470_2_100.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      T       2           -
LGA    -       -      K       3           -
LGA    -       -      Q       4           -
LGA    -       -      E       5           -
LGA    S     1_D      K       6           #
LGA    I     2_D      I       7           -
LGA    D     3_D      E       8           -
LGA    L     4_D      K       9           #
LGA    I     5_D      T      10           #
LGA    -       -      I      11           -
LGA    L     6_D      T      12           #
LGA    L     7_D      F      13          4.532
LGA    A     8_D      V      14          3.275
LGA    G     9_D      K      15          3.540
LGA    K    10_D      H      16          2.419
LGA    L    11_D      I      17          3.986
LGA    K    12_D      L      18          4.533
LGA    R    13_D      E      19          2.735
LGA    I    14_D      K      20           #
LGA    -       -      D      21           -
LGA    -       -      A      22           -
LGA    P    15_D      S      23          3.097
LGA    R    16_D      G      24           -
LGA    M    17_D      -       -           -
LGA    G    18_D      -       -           -
LGA    W    19_D      -       -           -
LGA    L    20_D      -       -           -
LGA    I    21_D      -       -           -
LGA    K    22_D      -       -           -
LGA    G    23_D      -       -           -
LGA    V    24_D      -       -           -
LGA    P    25_D      -       -           -
LGA    N    26_D      -       -           -
LGA    P    27_D      -       -           -
LGA    E    28_D      H      25          3.249
LGA    S    29_D      D      26          2.068
LGA    V    30_D      -       -           -
LGA    A    31_D      W      27          2.242
LGA    D    32_D      Y      28          2.050
LGA    H    33_D      H      29          1.875
LGA    S    34_D      I      30          1.398
LGA    Y    35_D      R      31          1.008
LGA    R    36_D      R      32          1.113
LGA    V    37_D      V      33          1.319
LGA    A    38_D      H      34          0.572
LGA    F    39_D      K      35          1.026
LGA    I    40_D      M      36          1.256
LGA    T    41_D      A      37          0.485
LGA    L    42_D      I      38          1.154
LGA    L    43_D      S      39          2.010
LGA    L    44_D      L      40          1.775
LGA    A    45_D      S      41          1.611
LGA    E    46_D      E      42          2.802
LGA    E    47_D      Q      43          3.475
LGA    L    48_D      -       -           -
LGA    K    49_D      E      44          2.849
LGA    K    50_D      -       -           -
LGA    K    51_D      -       -           -
LGA    G    52_D      -       -           -
LGA    V    53_D      -       -           -
LGA    E    54_D      G      45          4.140
LGA    I    55_D      G      46          1.627
LGA    D    56_D      N      47          1.809
LGA    V    57_D      R      48          2.432
LGA    E    58_D      F      49          2.911
LGA    K    59_D      I      50          2.074
LGA    A    60_D      I      51          0.886
LGA    L    61_D      E      52          1.500
LGA    K    62_D      M      53          2.118
LGA    I    63_D      A      54          1.508
LGA    A    64_D      A      55          1.668
LGA    I    65_D      L      56          2.296
LGA    I    66_D      L      57          2.828
LGA    H    67_D      H      58          2.717
LGA    D    68_D      D      59          2.712
LGA    L    69_D      V      60          3.600
LGA    G    70_D      A      61          4.212
LGA    E    71_D      -       -           -
LGA    A    72_D      -       -           -
LGA    I    73_D      -       -           -
LGA    I    74_D      -       -           -
LGA    T    75_D      -       -           -
LGA    D    76_D      D      62          5.561
LGA    L    77_D      L      65          1.823
LGA    P    78_D      N      66           -
LGA    L    79_D      E      67           -
LGA    S    80_D      -       -           -
LGA    A    81_D      -       -           -
LGA    Q    82_D      -       -           -
LGA    K    83_D      -       -           -
LGA    Y    84_D      -       -           -
LGA    L    85_D      S      68          4.361
LGA    N    86_D      E      69          1.714
LGA    K    87_D      -       -           -
LGA    E    88_D      -       -           -
LGA    E    89_D      E      70          1.127
LGA    A    90_D      A      71          1.022
LGA    E    91_D      G      72          1.100
LGA    A    92_D      M      73          0.544
LGA    K    93_D      K      74          1.440
LGA    A    94_D      K      75          1.466
LGA    L    95_D      V      76          1.782
LGA    K    96_D      S      77          2.178
LGA    D    97_D      D      78          2.810
LGA    V    98_D      W      79          2.921
LGA    L    99_D      L      80          2.668
LGA    P   100_D      E      81          3.040
LGA    E   101_D      E      82           -
LGA    -       -      L      83           -
LGA    -       -      H      84           -
LGA    Y   102_D      V      85           #
LGA    -       -      E      86           -
LGA    -       -      E      87           -
LGA    -       -      E      88           -
LGA    -       -      E      89           -
LGA    T   103_D      S      90          4.505
LGA    E   104_D      K      91          1.742
LGA    -       -      H      92           -
LGA    L   105_D      V      93          0.621
LGA    F   106_D      L      94          1.335
LGA    E   107_D      H      95          1.145
LGA    E   108_D      I      96          2.646
LGA    Y   109_D      I      97          2.968
LGA    S   110_D      A      98          1.543
LGA    K   111_D      N      99          3.123
LGA    A   112_D      -       -           -
LGA    L   113_D      -       -           -
LGA    T   114_D      -       -           -
LGA    L   115_D      -       -           -
LGA    E   116_D      -       -           -
LGA    G   117_D      -       -           -
LGA    Q   118_D      -       -           -
LGA    L   119_D      -       -           -
LGA    V   120_D      -       -           -
LGA    K   121_D      M     100          4.906
LGA    I   122_D      -       -           -
LGA    A   123_D      -       -           -
LGA    D   124_D      -       -           -
LGA    K   125_D      -       -           -
LGA    L   126_D      -       -           -
LGA    D   127_D      -       -           -
LGA    M   128_D      -       -           -
LGA    I   129_D      -       -           -
LGA    I   130_D      -       -           -
LGA    Q   131_D      -       -           -
LGA    A   132_D      -       -           -
LGA    Y   133_D      -       -           -
LGA    E   134_D      -       -           -
LGA    Y   135_D      -       -           -
LGA    E   136_D      -       -           -
LGA    L   137_D      -       -           -
LGA    S   138_D      -       -           -
LGA    G   139_D      -       -           -
LGA    A   140_D      -       -           -
LGA    K   141_D      -       -           -
LGA    N   142_D      -       -           -
LGA    L   143_D      -       -           -
LGA    S   144_D      -       -           -
LGA    E   145_D      -       -           -
LGA    F   146_D      -       -           -
LGA    E   157_D      -       -           -
LGA    I   158_D      -       -           -
LGA    S   159_D      -       -           -
LGA    R   160_D      -       -           -
LGA    Y   161_D      -       -           -
LGA    L   162_D      -       -           -
LGA    R   163_D      -       -           -
LGA    E   164_D      -       -           -
LGA    I   165_D      -       -           -
LGA    I   166_D      -       -           -
LGA    E   167_D      -       -           -
LGA    E   168_D      -       -           -
LGA    V   169_D      -       -           -
LGA    R   170_D      -       -           -
LGA    R   171_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  161   97    5.0     71    2.59    21.13     50.716     2.641

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.072403 * X  +   0.460182 * Y  +   0.884867 * Z  +   0.032948
  Y_new =   0.263038 * X  +   0.846976 * Y  +  -0.461999 * Z  +   4.023532
  Z_new =  -0.962065 * X  +   0.266204 * Y  +  -0.059722 * Z  + 155.187210 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.791490   -1.350103  [ DEG:   102.6448    -77.3552 ]
  Theta =   1.294472    1.847120  [ DEG:    74.1678    105.8322 ]
  Phi   =   1.302193   -1.839399  [ DEG:    74.6102   -105.3898 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1xx7_D                                        
REMARK     2: T0470_2_100.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1xx7_D.T0470_2_100.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  161   97   5.0   71   2.59   21.13  50.716
REMARK  ---------------------------------------------------------- 
MOLECULE 1xx7_D
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   04-NOV-04   1XX7              
TITLE     CONSERVED HYPOTHETICAL PROTEIN FROM PYROCOCCUS FURIOSUS PFU-          
TITLE    2 403030-001                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: OXETANOCIN-LIKE PROTEIN;                                   
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS FURIOSUS;                            
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    PSI, SECSG, PROTEIN STRUCTURE INITIATIVE, SOUTHEAST                   
KEYWDS   2 COLLABORATORY FOR STRUCTURAL GENOMICS, PYROCOCCUS FURIOSUS,          
KEYWDS   3 CONSERVED HYPOTHETICAL PROTEIN, HYPERTHERMOPHILE                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    L.CHEN,W.TEMPEL,J.HABEL,W.ZHOU,D.NGUYEN,S.-H.CHANG,D.LEE,L.-          
AUTHOR   2 L.C.KELLEY,B.D.DILLARD,Z.-J.LIU,S.BRIDGER,J.C.ENEH,                  
AUTHOR   3 R.C.HOPKINS,F.E.JENNEY JR,H.-S.LEE,T.LI,F.L.POOLE II,C.SHAH,         
AUTHOR   4 F.J.SUGAR,M.W.W.ADAMS,W.B.ARENDALL III,J.S.RICHARDSON,               
AUTHOR   5 D.C.RICHARDSON,J.P.ROSE,B.-C.WANG,SOUTHEAST COLLABORATORY            
AUTHOR   6 FOR STRUCTURAL GENOMICS (SECSG)                                      
REVDAT   2   01-FEB-05 1XX7    1       AUTHOR                                   
REVDAT   1   28-DEC-04 1XX7    0                                                
JRNL        AUTH   L.CHEN,W.TEMPEL,J.HABEL,W.ZHOU,D.NGUYEN,S.-H.CHANG,          
JRNL        AUTH 2 D.LEE,L.-L.C.KELLEY,B.D.DILLARD,Z.-J.LIU,S.BRIDGER,          
JRNL        AUTH 3 J.C.ENEH,R.C.HOPKINS,F.E.JENNEY JR,H.-S.LEE,T.LI,            
JRNL        AUTH 4 F.L.POOLE II,C.SHAH,F.J.SUGAR,M.W.W.ADAMS,                   
JRNL        AUTH 5 W.B.ARENDALL III,J.S.RICHARDSON,D.C.RICHARDSON,              
JRNL        AUTH 6 J.P.ROSE,B.-C.WANG,                                          
JRNL        AUTH 7 SOUTHEAST COLLABORATORY FOR STRUCTURAL GENOMICS              
JRNL        TITL   CONSERVED HYPOTHETICAL PROTEIN FROM PYROCOCCUS               
JRNL        TITL 2 FURIOSUS PFU-403030-001                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.26 ANGSTROMS.                                          
DBREF  1XX7 A    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 B    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 C    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 D    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 E    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 F    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
SEQRES   1 A  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 A  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 A  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 A  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 A  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 A  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 A  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 A  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 A  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 A  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 A  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 A  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 A  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 A  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 A  184  ASP HIS                                                      
SEQRES   1 B  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 B  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 B  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 B  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 B  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 B  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 B  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 B  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 B  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 B  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 B  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 B  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 B  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 B  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 B  184  ASP HIS                                                      
SEQRES   1 C  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 C  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 C  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 C  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 C  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 C  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 C  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 C  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 C  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 C  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 C  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 C  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 C  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 C  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 C  184  ASP HIS                                                      
SEQRES   1 D  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 D  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 D  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 D  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 D  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 D  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 D  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 D  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 D  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 D  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 D  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 D  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 D  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 D  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 D  184  ASP HIS                                                      
SEQRES   1 E  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 E  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 E  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 E  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 E  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 E  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 E  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 E  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 E  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 E  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 E  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 E  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 E  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 E  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 E  184  ASP HIS                                                      
SEQRES   1 F  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 F  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 F  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 F  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 F  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 F  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 F  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 F  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 F  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 F  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 F  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 F  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 F  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 F  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 F  184  ASP HIS                                                      
HET     NI  A 201       1                                                       
HET     NI  B 201       1                                                       
HET     NI  C 201       1                                                       
HET     NI  D 201       1                                                       
HET     NI  E 201       1                                                       
HET     NI  F 201       1                                                       
HET    UNX   2001       1                                                       
HET    UNX   2002       1                                                       
HET    UNX   2003       1                                                       
HET    UNX   2004       1                                                       
HET    UNX   2005       1                                                       
HET    UNX   2006       1                                                       
HET    UNX   2007       1                                                       
HET    UNX   2008       1                                                       
HET    UNX   2009       1                                                       
HET    UNX   2010       1                                                       
HET    UNX   2011       1                                                       
HET    UNX   2012       1                                                       
HET    UNX   2013       1                                                       
HET    UNX   2014       1                                                       
HET    UNX   2015       1                                                       
HET    UNX   2016       1                                                       
HET    UNX   2017       1                                                       
HET    UNX   2018       1                                                       
HET    UNX   2019       1                                                       
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     UNX UNKNOWN ATOM OR ION                                              
FORMUL   7   NI    6(NI 2+)                                                     
FORMUL  13  UNX    19(X1)                                                       
FORMUL  32  HOH   *69(H2 O)                                                     
CRYST1   98.073  111.335  125.984  90.00  90.00  90.00 P 21 21 21   24          
ATOM   3941  N   SER D   1      60.890  36.702  90.033  1.00 43.16           N  
ATOM   3942  CA  SER D   1      61.691  37.940  90.249  1.00 41.20           C  
ATOM   3943  C   SER D   1      60.933  38.985  91.080  1.00 38.59           C  
ATOM   3944  O   SER D   1      59.760  39.350  90.788  1.00 28.44           O  
ATOM   3945  CB  SER D   1      62.153  38.566  88.925  1.00 45.33           C  
ATOM   3946  OG  SER D   1      63.234  39.469  89.133  1.00 50.20           O  
ATOM   3947  N   ILE D   2      61.630  39.462  92.110  1.00 35.02           N  
ATOM   3948  CA  ILE D   2      61.159  40.527  92.957  1.00 37.00           C  
ATOM   3949  C   ILE D   2      61.071  41.854  92.175  1.00 30.96           C  
ATOM   3950  O   ILE D   2      60.210  42.650  92.453  1.00 30.95           O  
ATOM   3951  CB  ILE D   2      62.013  40.652  94.273  1.00 41.62           C  
ATOM   3952  CG1 ILE D   2      61.879  39.378  95.094  1.00 45.97           C  
ATOM   3953  CG2 ILE D   2      61.484  41.765  95.189  1.00 41.41           C  
ATOM   3954  N   ASP D   3      61.915  42.062  91.177  1.00 28.22           N  
ATOM   3955  CA  ASP D   3      61.842  43.293  90.384  1.00 30.81           C  
ATOM   3956  C   ASP D   3      60.486  43.435  89.683  1.00 28.70           C  
ATOM   3957  O   ASP D   3      59.898  44.518  89.700  1.00 27.03           O  
ATOM   3958  CB  ASP D   3      62.989  43.407  89.363  1.00 34.40           C  
ATOM   3959  CG  ASP D   3      64.343  43.767  90.023  1.00 40.90           C  
ATOM   3960  OD1 ASP D   3      64.365  44.344  91.154  1.00 41.51           O  
ATOM   3961  OD2 ASP D   3      65.392  43.467  89.404  1.00 46.29           O  
ATOM   3962  N   LEU D   4      59.997  42.337  89.103  1.00 25.20           N  
ATOM   3963  CA  LEU D   4      58.721  42.316  88.420  1.00 23.58           C  
ATOM   3964  C   LEU D   4      57.580  42.582  89.423  1.00 23.17           C  
ATOM   3965  O   LEU D   4      56.625  43.256  89.116  1.00 19.05           O  
ATOM   3966  CB  LEU D   4      58.519  40.958  87.704  1.00 24.21           C  
ATOM   3967  CG  LEU D   4      59.405  40.772  86.483  1.00 27.35           C  
ATOM   3968  CD1 LEU D   4      59.478  39.295  85.996  1.00 26.12           C  
ATOM   3969  CD2 LEU D   4      58.912  41.675  85.385  1.00 29.36           C  
ATOM   3970  N   ILE D   5      57.705  42.024  90.620  1.00 20.59           N  
ATOM   3971  CA  ILE D   5      56.707  42.165  91.636  1.00 21.08           C  
ATOM   3972  C   ILE D   5      56.715  43.591  92.144  1.00 21.00           C  
ATOM   3973  O   ILE D   5      55.675  44.158  92.356  1.00 20.06           O  
ATOM   3974  CB  ILE D   5      56.924  41.166  92.791  1.00 21.33           C  
ATOM   3975  CG1 ILE D   5      56.709  39.731  92.284  1.00 23.74           C  
ATOM   3976  CG2 ILE D   5      55.948  41.459  93.957  1.00 20.06           C  
ATOM   3977  CD1 ILE D   5      57.037  38.625  93.301  1.00 23.81           C  
ATOM   3978  N   LEU D   6      57.899  44.159  92.357  1.00 23.08           N  
ATOM   3979  CA  LEU D   6      57.993  45.581  92.619  1.00 28.38           C  
ATOM   3980  C   LEU D   6      57.378  46.438  91.491  1.00 26.00           C  
ATOM   3981  O   LEU D   6      56.599  47.372  91.775  1.00 23.22           O  
ATOM   3982  CB  LEU D   6      59.426  45.985  92.886  1.00 29.35           C  
ATOM   3983  CG  LEU D   6      59.955  45.390  94.194  1.00 33.88           C  
ATOM   3984  CD1 LEU D   6      61.464  45.626  94.261  1.00 35.87           C  
ATOM   3985  CD2 LEU D   6      59.259  45.952  95.448  1.00 33.91           C  
ATOM   3986  N   LEU D   7      57.695  46.092  90.241  1.00 23.62           N  
ATOM   3987  CA  LEU D   7      57.167  46.789  89.083  1.00 26.10           C  
ATOM   3988  C   LEU D   7      55.620  46.810  89.108  1.00 22.10           C  
ATOM   3989  O   LEU D   7      55.010  47.851  88.978  1.00 21.68           O  
ATOM   3990  CB  LEU D   7      57.712  46.157  87.800  1.00 28.59           C  
ATOM   3991  CG  LEU D   7      57.210  46.702  86.462  1.00 33.76           C  
ATOM   3992  CD1 LEU D   7      57.401  48.231  86.390  1.00 38.01           C  
ATOM   3993  CD2 LEU D   7      57.936  46.070  85.303  1.00 33.61           C  
ATOM   3994  N   ALA D   8      55.015  45.647  89.291  1.00 20.45           N  
ATOM   3995  CA  ALA D   8      53.563  45.515  89.418  1.00 22.17           C  
ATOM   3996  C   ALA D   8      52.963  46.292  90.618  1.00 21.76           C  
ATOM   3997  O   ALA D   8      51.842  46.776  90.531  1.00 20.77           O  
ATOM   3998  CB  ALA D   8      53.145  44.026  89.454  1.00 20.08           C  
ATOM   3999  N   GLY D   9      53.715  46.427  91.700  1.00 16.70           N  
ATOM   4000  CA  GLY D   9      53.296  47.252  92.842  1.00 17.86           C  
ATOM   4001  C   GLY D   9      53.052  48.741  92.556  1.00 19.05           C  
ATOM   4002  O   GLY D   9      52.201  49.387  93.186  1.00 19.07           O  
ATOM   4003  N   LYS D  10      53.805  49.272  91.616  1.00 19.81           N  
ATOM   4004  CA  LYS D  10      53.600  50.619  91.118  1.00 21.14           C  
ATOM   4005  C   LYS D  10      52.209  50.854  90.599  1.00 19.56           C  
ATOM   4006  O   LYS D  10      51.786  51.986  90.548  1.00 18.42           O  
ATOM   4007  CB  LYS D  10      54.540  50.908  89.974  1.00 17.88           C  
ATOM   4008  CG  LYS D  10      56.008  50.991  90.364  1.00 23.05           C  
ATOM   4009  CD  LYS D  10      56.791  51.426  89.138  1.00 21.51           C  
ATOM   4010  CE  LYS D  10      58.173  50.874  89.088  1.00 29.97           C  
ATOM   4011  NZ  LYS D  10      59.234  51.760  89.529  1.00 22.43           N  
ATOM   4012  N   LEU D  11      51.530  49.794  90.163  1.00 19.41           N  
ATOM   4013  CA  LEU D  11      50.155  49.911  89.763  1.00 20.86           C  
ATOM   4014  C   LEU D  11      49.224  50.260  90.946  1.00 20.20           C  
ATOM   4015  O   LEU D  11      48.153  50.850  90.736  1.00 16.99           O  
ATOM   4016  CB  LEU D  11      49.711  48.652  89.019  1.00 20.58           C  
ATOM   4017  CG  LEU D  11      50.347  48.373  87.632  1.00 18.81           C  
ATOM   4018  CD1 LEU D  11      49.574  47.232  86.892  1.00 22.50           C  
ATOM   4019  CD2 LEU D  11      50.435  49.624  86.731  1.00 21.15           C  
ATOM   4020  N   LYS D  12      49.636  49.917  92.178  1.00 15.08           N  
ATOM   4021  CA  LYS D  12      48.823  50.228  93.335  1.00 16.69           C  
ATOM   4022  C   LYS D  12      48.827  51.767  93.581  1.00 19.74           C  
ATOM   4023  O   LYS D  12      47.944  52.280  94.237  1.00 24.79           O  
ATOM   4024  CB  LYS D  12      49.269  49.458  94.589  1.00 14.63           C  
ATOM   4025  CG  LYS D  12      49.490  47.932  94.401  1.00 13.66           C  
ATOM   4026  CD  LYS D  12      49.827  47.327  95.750  1.00 12.56           C  
ATOM   4027  CE  LYS D  12      49.994  45.825  95.785  1.00 11.75           C  
ATOM   4028  NZ  LYS D  12      50.056  45.372  97.220  1.00 10.10           N  
ATOM   4029  N   ARG D  13      49.792  52.474  92.998  1.00 17.44           N  
ATOM   4030  CA  ARG D  13      50.019  53.895  93.256  1.00 20.40           C  
ATOM   4031  C   ARG D  13      49.749  54.775  92.040  1.00 19.30           C  
ATOM   4032  O   ARG D  13      49.492  55.942  92.191  1.00 24.55           O  
ATOM   4033  CB  ARG D  13      51.486  54.102  93.703  1.00 21.95           C  
ATOM   4034  CG  ARG D  13      51.767  53.471  95.053  1.00 24.66           C  
ATOM   4035  CD  ARG D  13      53.138  53.824  95.578  1.00 26.69           C  
ATOM   4036  NE  ARG D  13      54.206  53.348  94.710  1.00 26.26           N  
ATOM   4037  CZ  ARG D  13      54.612  52.078  94.657  1.00 30.58           C  
ATOM   4038  NH1 ARG D  13      54.012  51.120  95.365  1.00 31.38           N  
ATOM   4039  NH2 ARG D  13      55.605  51.741  93.851  1.00 36.17           N  
ATOM   4040  N   ILE D  14      49.822  54.201  90.848  1.00 18.42           N  
ATOM   4041  CA  ILE D  14      49.615  54.934  89.610  1.00 21.59           C  
ATOM   4042  C   ILE D  14      48.113  55.150  89.400  1.00 19.86           C  
ATOM   4043  O   ILE D  14      47.332  54.185  89.317  1.00 21.05           O  
ATOM   4044  CB  ILE D  14      50.310  54.204  88.413  1.00 22.91           C  
ATOM   4045  CG1 ILE D  14      51.837  54.411  88.556  1.00 22.45           C  
ATOM   4046  CG2 ILE D  14      49.849  54.750  87.102  1.00 26.38           C  
ATOM   4047  CD1 ILE D  14      52.642  53.509  87.714  1.00 20.12           C  
ATOM   4048  N   PRO D  15      47.702  56.424  89.335  1.00 20.83           N  
ATOM   4049  CA  PRO D  15      46.312  56.686  89.210  1.00 18.39           C  
ATOM   4050  C   PRO D  15      45.786  56.544  87.768  1.00 18.40           C  
ATOM   4051  O   PRO D  15      46.514  56.756  86.767  1.00 19.87           O  
ATOM   4052  CB  PRO D  15      46.182  58.131  89.739  1.00 19.29           C  
ATOM   4053  CG  PRO D  15      47.453  58.764  89.431  1.00 20.21           C  
ATOM   4054  CD  PRO D  15      48.498  57.679  89.374  1.00 21.77           C  
ATOM   4055  N   ARG D  16      44.519  56.150  87.706  1.00 19.23           N  
ATOM   4056  CA  ARG D  16      43.730  56.269  86.521  1.00 19.51           C  
ATOM   4057  C   ARG D  16      43.432  57.744  86.282  1.00 19.41           C  
ATOM   4058  O   ARG D  16      42.545  58.338  86.919  1.00 16.26           O  
ATOM   4059  CB  ARG D  16      42.483  55.428  86.648  1.00 16.18           C  
ATOM   4060  CG  ARG D  16      42.820  53.934  86.864  1.00 19.10           C  
ATOM   4061  CD  ARG D  16      42.815  53.164  85.536  1.00 20.92           C  
ATOM   4062  NE  ARG D  16      41.444  53.132  85.026  1.00 23.45           N  
ATOM   4063  CZ  ARG D  16      41.066  52.894  83.772  1.00 23.22           C  
ATOM   4064  NH1 ARG D  16      39.772  52.918  83.478  1.00 21.00           N  
ATOM   4065  NH2 ARG D  16      41.953  52.655  82.816  1.00 23.76           N  
ATOM   4066  N   MET D  17      44.201  58.301  85.334  1.00 22.92           N  
ATOM   4067  CA  MET D  17      44.316  59.747  85.081  1.00 25.45           C  
ATOM   4068  C   MET D  17      43.109  60.390  84.467  1.00 20.06           C  
ATOM   4069  O   MET D  17      42.871  61.552  84.717  1.00 20.01           O  
ATOM   4070  CB  MET D  17      45.541  60.042  84.196  1.00 28.29           C  
ATOM   4071  CG  MET D  17      46.852  59.984  84.975  1.00 37.08           C  
ATOM   4072  SD  MET D  17      47.142  61.372  86.151  1.00 40.20           S  
ATOM   4073  CE  MET D  17      46.522  62.699  85.210  1.00 35.70           C  
ATOM   4074  N   GLY D  18      42.355  59.669  83.652  1.00 18.47           N  
ATOM   4075  CA  GLY D  18      41.101  60.206  83.152  1.00 20.91           C  
ATOM   4076  C   GLY D  18      40.251  60.825  84.282  1.00 20.77           C  
ATOM   4077  O   GLY D  18      39.856  61.970  84.206  1.00 23.62           O  
ATOM   4078  N   TRP D  19      40.012  60.054  85.336  1.00 16.39           N  
ATOM   4079  CA  TRP D  19      39.173  60.477  86.439  1.00 17.90           C  
ATOM   4080  C   TRP D  19      39.786  61.664  87.161  1.00 19.38           C  
ATOM   4081  O   TRP D  19      39.096  62.687  87.448  1.00 18.67           O  
ATOM   4082  CB  TRP D  19      38.984  59.357  87.464  1.00 16.96           C  
ATOM   4083  CG  TRP D  19      38.625  58.011  86.964  1.00 16.61           C  
ATOM   4084  CD1 TRP D  19      39.313  56.835  87.213  1.00 18.77           C  
ATOM   4085  CD2 TRP D  19      37.455  57.634  86.191  1.00 21.10           C  
ATOM   4086  NE1 TRP D  19      38.646  55.771  86.638  1.00 19.16           N  
ATOM   4087  CE2 TRP D  19      37.516  56.232  85.998  1.00 15.37           C  
ATOM   4088  CE3 TRP D  19      36.364  58.359  85.629  1.00 19.23           C  
ATOM   4089  CZ2 TRP D  19      36.548  55.539  85.282  1.00 17.59           C  
ATOM   4090  CZ3 TRP D  19      35.417  57.663  84.907  1.00 17.59           C  
ATOM   4091  CH2 TRP D  19      35.505  56.266  84.747  1.00 18.42           C  
ATOM   4092  N   LEU D  20      41.090  61.538  87.434  1.00 18.72           N  
ATOM   4093  CA  LEU D  20      41.869  62.574  88.137  1.00 21.58           C  
ATOM   4094  C   LEU D  20      41.740  63.943  87.443  1.00 20.58           C  
ATOM   4095  O   LEU D  20      41.539  64.983  88.072  1.00 23.92           O  
ATOM   4096  CB  LEU D  20      43.343  62.103  88.238  1.00 23.94           C  
ATOM   4097  CG  LEU D  20      44.316  62.794  89.169  1.00 27.79           C  
ATOM   4098  CD1 LEU D  20      45.510  61.892  89.482  1.00 29.81           C  
ATOM   4099  CD2 LEU D  20      44.754  64.046  88.552  1.00 30.70           C  
ATOM   4100  N   ILE D  21      41.808  63.919  86.138  1.00 22.74           N  
ATOM   4101  CA  ILE D  21      41.755  65.121  85.362  1.00 30.00           C  
ATOM   4102  C   ILE D  21      40.331  65.718  85.357  1.00 30.58           C  
ATOM   4103  O   ILE D  21      40.187  66.945  85.301  1.00 27.46           O  
ATOM   4104  CB  ILE D  21      42.357  64.885  83.938  1.00 33.51           C  
ATOM   4105  CG1 ILE D  21      43.890  64.832  84.075  1.00 35.19           C  
ATOM   4106  CG2 ILE D  21      41.936  65.986  82.952  1.00 37.10           C  
ATOM   4107  CD1 ILE D  21      44.624  64.630  82.837  1.00 37.61           C  
ATOM   4108  N   LYS D  22      39.311  64.855  85.459  1.00 24.68           N  
ATOM   4109  CA  LYS D  22      37.939  65.307  85.567  1.00 23.41           C  
ATOM   4110  C   LYS D  22      37.606  65.946  86.936  1.00 24.30           C  
ATOM   4111  O   LYS D  22      36.635  66.653  87.031  1.00 27.33           O  
ATOM   4112  CB  LYS D  22      36.978  64.200  85.216  1.00 23.56           C  
ATOM   4113  CG  LYS D  22      37.009  63.832  83.731  1.00 26.23           C  
ATOM   4114  CD  LYS D  22      36.488  64.986  82.864  1.00 30.93           C  
ATOM   4115  CE  LYS D  22      36.198  64.571  81.429  1.00 34.24           C  
ATOM   4116  NZ  LYS D  22      34.904  65.203  81.028  1.00 39.05           N  
ATOM   4117  N   GLY D  23      38.449  65.720  87.950  1.00 22.10           N  
ATOM   4118  CA  GLY D  23      38.307  66.281  89.288  1.00 16.11           C  
ATOM   4119  C   GLY D  23      37.758  65.289  90.313  1.00 15.38           C  
ATOM   4120  O   GLY D  23      37.400  65.660  91.423  1.00 22.26           O  
ATOM   4121  N   VAL D  24      37.620  64.037  89.924  1.00 14.49           N  
ATOM   4122  CA  VAL D  24      37.319  62.965  90.889  1.00 17.72           C  
ATOM   4123  C   VAL D  24      38.386  62.943  91.972  1.00 14.76           C  
ATOM   4124  O   VAL D  24      39.548  62.813  91.648  1.00 21.81           O  
ATOM   4125  CB  VAL D  24      37.287  61.598  90.196  1.00 17.40           C  
ATOM   4126  CG1 VAL D  24      37.038  60.500  91.220  1.00 17.19           C  
ATOM   4127  CG2 VAL D  24      36.248  61.599  89.134  1.00 18.78           C  
ATOM   4128  N   PRO D  25      38.005  63.131  93.251  1.00 22.62           N  
ATOM   4129  CA  PRO D  25      39.046  63.426  94.277  1.00 27.30           C  
ATOM   4130  C   PRO D  25      39.986  62.297  94.773  1.00 30.35           C  
ATOM   4131  O   PRO D  25      41.172  62.587  95.096  1.00 33.24           O  
ATOM   4132  CB  PRO D  25      38.212  64.017  95.461  1.00 27.81           C  
ATOM   4133  CG  PRO D  25      36.852  63.419  95.298  1.00 22.56           C  
ATOM   4134  CD  PRO D  25      36.627  63.247  93.809  1.00 18.37           C  
ATOM   4135  N   ASN D  26      39.488  61.064  94.873  1.00 27.49           N  
ATOM   4136  CA  ASN D  26      40.358  59.921  95.231  1.00 29.14           C  
ATOM   4137  C   ASN D  26      40.269  58.827  94.135  1.00 24.12           C  
ATOM   4138  O   ASN D  26      39.696  57.784  94.359  1.00 18.62           O  
ATOM   4139  CB  ASN D  26      39.967  59.299  96.592  1.00 29.06           C  
ATOM   4140  N   PRO D  27      40.824  59.091  92.954  1.00 19.45           N  
ATOM   4141  CA  PRO D  27      40.608  58.205  91.815  1.00 20.26           C  
ATOM   4142  C   PRO D  27      41.233  56.813  92.046  1.00 20.78           C  
ATOM   4143  O   PRO D  27      42.309  56.714  92.632  1.00 16.94           O  
ATOM   4144  CB  PRO D  27      41.314  58.940  90.671  1.00 22.04           C  
ATOM   4145  CG  PRO D  27      42.362  59.732  91.310  1.00 22.91           C  
ATOM   4146  CD  PRO D  27      41.767  60.178  92.642  1.00 22.64           C  
ATOM   4147  N   GLU D  28      40.529  55.756  91.651  1.00 19.15           N  
ATOM   4148  CA  GLU D  28      41.119  54.412  91.597  1.00 17.40           C  
ATOM   4149  C   GLU D  28      42.528  54.386  90.974  1.00 15.91           C  
ATOM   4150  O   GLU D  28      42.892  55.203  90.099  1.00 16.31           O  
ATOM   4151  CB  GLU D  28      40.235  53.455  90.812  1.00 14.61           C  
ATOM   4152  CG  GLU D  28      40.009  53.882  89.366  1.00 17.39           C  
ATOM   4153  CD  GLU D  28      39.568  52.745  88.480  1.00 15.86           C  
ATOM   4154  OE1 GLU D  28      39.391  51.638  89.004  1.00 17.33           O  
ATOM   4155  OE2 GLU D  28      39.413  52.943  87.258  1.00 16.67           O  
ATOM   4156  N   SER D  29      43.313  53.438  91.456  1.00 20.14           N  
ATOM   4157  CA  SER D  29      44.616  53.128  90.875  1.00 19.51           C  
ATOM   4158  C   SER D  29      44.454  52.210  89.657  1.00 19.17           C  
ATOM   4159  O   SER D  29      43.391  51.612  89.439  1.00 12.34           O  
ATOM   4160  CB  SER D  29      45.486  52.472  91.943  1.00 18.55           C  
ATOM   4161  OG  SER D  29      45.018  51.160  92.243  1.00 16.62           O  
ATOM   4162  N   VAL D  30      45.505  52.111  88.855  1.00 16.34           N  
ATOM   4163  CA  VAL D  30      45.532  51.133  87.758  1.00 15.83           C  
ATOM   4164  C   VAL D  30      45.370  49.677  88.230  1.00 13.86           C  
ATOM   4165  O   VAL D  30      44.699  48.925  87.565  1.00 18.57           O  
ATOM   4166  CB  VAL D  30      46.824  51.250  86.907  1.00 16.87           C  
ATOM   4167  CG1 VAL D  30      46.871  50.172  85.819  1.00 16.16           C  
ATOM   4168  CG2 VAL D  30      46.917  52.635  86.271  1.00 18.27           C  
ATOM   4169  N   ALA D  31      46.012  49.288  89.342  1.00 14.50           N  
ATOM   4170  CA  ALA D  31      45.742  48.001  90.014  1.00 18.36           C  
ATOM   4171  C   ALA D  31      44.270  47.772  90.347  1.00 20.21           C  
ATOM   4172  O   ALA D  31      43.725  46.687  90.083  1.00 17.79           O  
ATOM   4173  CB  ALA D  31      46.597  47.845  91.304  1.00 19.23           C  
ATOM   4174  N   ASP D  32      43.620  48.778  90.926  1.00 20.78           N  
ATOM   4175  CA  ASP D  32      42.177  48.668  91.287  1.00 18.54           C  
ATOM   4176  C   ASP D  32      41.362  48.302  90.055  1.00 14.84           C  
ATOM   4177  O   ASP D  32      40.471  47.427  90.059  1.00 14.88           O  
ATOM   4178  CB  ASP D  32      41.620  50.006  91.787  1.00 17.85           C  
ATOM   4179  CG  ASP D  32      41.972  50.311  93.218  1.00 18.91           C  
ATOM   4180  OD1 ASP D  32      42.046  49.390  94.072  1.00 17.63           O  
ATOM   4181  OD2 ASP D  32      42.176  51.528  93.486  1.00 16.16           O  
ATOM   4182  N   HIS D  33      41.614  49.090  89.032  1.00 16.28           N  
ATOM   4183  CA  HIS D  33      41.027  48.922  87.763  1.00 16.99           C  
ATOM   4184  C   HIS D  33      41.319  47.512  87.183  1.00 18.92           C  
ATOM   4185  O   HIS D  33      40.390  46.799  86.854  1.00 14.65           O  
ATOM   4186  CB  HIS D  33      41.497  50.020  86.837  1.00 18.89           C  
ATOM   4187  CG  HIS D  33      41.326  49.682  85.397  1.00 18.54           C  
ATOM   4188  ND1 HIS D  33      40.097  49.594  84.809  1.00 19.91           N  
ATOM   4189  CD2 HIS D  33      42.224  49.356  84.447  1.00 17.23           C  
ATOM   4190  CE1 HIS D  33      40.237  49.239  83.549  1.00 16.20           C  
ATOM   4191  NE2 HIS D  33      41.515  49.089  83.306  1.00 15.27           N  
ATOM   4192  N   SER D  34      42.593  47.122  87.119  1.00 17.57           N  
ATOM   4193  CA  SER D  34      42.960  45.817  86.625  1.00 17.67           C  
ATOM   4194  C   SER D  34      42.392  44.665  87.421  1.00 19.39           C  
ATOM   4195  O   SER D  34      42.046  43.654  86.819  1.00 16.61           O  
ATOM   4196  CB  SER D  34      44.494  45.663  86.528  1.00 19.03           C  
ATOM   4197  OG  SER D  34      45.054  46.568  85.624  1.00 22.22           O  
ATOM   4198  N   TYR D  35      42.311  44.788  88.764  1.00 19.06           N  
ATOM   4199  CA  TYR D  35      41.619  43.808  89.550  1.00 14.21           C  
ATOM   4200  C   TYR D  35      40.183  43.552  89.008  1.00 19.16           C  
ATOM   4201  O   TYR D  35      39.772  42.379  88.795  1.00 16.70           O  
ATOM   4202  CB  TYR D  35      41.563  44.112  91.065  1.00 18.13           C  
ATOM   4203  CG  TYR D  35      40.613  43.099  91.731  1.00 16.32           C  
ATOM   4204  CD1 TYR D  35      41.068  41.823  92.034  1.00 16.03           C  
ATOM   4205  CD2 TYR D  35      39.243  43.385  91.928  1.00 15.66           C  
ATOM   4206  CE1 TYR D  35      40.240  40.871  92.548  1.00 19.34           C  
ATOM   4207  CE2 TYR D  35      38.394  42.437  92.421  1.00 15.88           C  
ATOM   4208  CZ  TYR D  35      38.898  41.157  92.758  1.00 20.27           C  
ATOM   4209  OH  TYR D  35      38.068  40.139  93.268  1.00 20.90           O  
ATOM   4210  N   ARG D  36      39.403  44.617  88.806  1.00 19.03           N  
ATOM   4211  CA  ARG D  36      38.015  44.395  88.404  1.00 19.91           C  
ATOM   4212  C   ARG D  36      37.878  43.943  86.940  1.00 19.78           C  
ATOM   4213  O   ARG D  36      36.962  43.192  86.628  1.00 16.81           O  
ATOM   4214  CB  ARG D  36      37.079  45.557  88.721  1.00 21.19           C  
ATOM   4215  CG  ARG D  36      35.590  45.081  88.768  1.00 22.58           C  
ATOM   4216  CD  ARG D  36      34.592  46.074  89.325  1.00 17.17           C  
ATOM   4217  NE  ARG D  36      34.445  47.290  88.545  1.00 18.22           N  
ATOM   4218  CZ  ARG D  36      33.630  48.284  88.886  1.00 16.03           C  
ATOM   4219  NH1 ARG D  36      32.840  48.170  89.946  1.00 20.73           N  
ATOM   4220  NH2 ARG D  36      33.595  49.380  88.170  1.00 16.41           N  
ATOM   4221  N   VAL D  37      38.809  44.349  86.068  1.00 20.16           N  
ATOM   4222  CA  VAL D  37      38.852  43.818  84.707  1.00 17.32           C  
ATOM   4223  C   VAL D  37      39.091  42.284  84.773  1.00 17.11           C  
ATOM   4224  O   VAL D  37      38.428  41.560  84.092  1.00 17.13           O  
ATOM   4225  CB  VAL D  37      39.904  44.520  83.827  1.00 19.20           C  
ATOM   4226  CG1 VAL D  37      39.946  43.889  82.452  1.00 21.81           C  
ATOM   4227  CG2 VAL D  37      39.621  45.976  83.699  1.00 19.59           C  
ATOM   4228  N   ALA D  38      40.033  41.816  85.604  1.00 17.39           N  
ATOM   4229  CA  ALA D  38      40.247  40.392  85.802  1.00 21.41           C  
ATOM   4230  C   ALA D  38      38.967  39.688  86.283  1.00 23.78           C  
ATOM   4231  O   ALA D  38      38.611  38.606  85.774  1.00 17.26           O  
ATOM   4232  CB  ALA D  38      41.395  40.124  86.772  1.00 23.48           C  
ATOM   4233  N   PHE D  39      38.273  40.303  87.250  1.00 22.91           N  
ATOM   4234  CA  PHE D  39      37.020  39.730  87.766  1.00 21.44           C  
ATOM   4235  C   PHE D  39      35.885  39.683  86.725  1.00 22.73           C  
ATOM   4236  O   PHE D  39      35.130  38.704  86.656  1.00 18.30           O  
ATOM   4237  CB  PHE D  39      36.568  40.496  89.028  1.00 24.45           C  
ATOM   4238  CG  PHE D  39      35.213  40.118  89.513  1.00 23.80           C  
ATOM   4239  CD1 PHE D  39      35.048  39.019  90.345  1.00 28.92           C  
ATOM   4240  CD2 PHE D  39      34.095  40.839  89.122  1.00 28.12           C  
ATOM   4241  CE1 PHE D  39      33.793  38.634  90.777  1.00 28.83           C  
ATOM   4242  CE2 PHE D  39      32.816  40.471  89.560  1.00 28.91           C  
ATOM   4243  CZ  PHE D  39      32.672  39.363  90.392  1.00 27.99           C  
ATOM   4244  N   ILE D  40      35.723  40.779  85.982  1.00 22.04           N  
ATOM   4245  CA  ILE D  40      34.754  40.849  84.932  1.00 21.53           C  
ATOM   4246  C   ILE D  40      35.080  39.848  83.816  1.00 22.25           C  
ATOM   4247  O   ILE D  40      34.201  39.181  83.315  1.00 23.43           O  
ATOM   4248  CB  ILE D  40      34.675  42.247  84.358  1.00 21.82           C  
ATOM   4249  CG1 ILE D  40      34.041  43.184  85.383  1.00 22.28           C  
ATOM   4250  CG2 ILE D  40      33.817  42.258  83.084  1.00 21.34           C  
ATOM   4251  CD1 ILE D  40      34.151  44.622  85.018  1.00 22.46           C  
ATOM   4252  N   THR D  41      36.343  39.769  83.439  1.00 22.96           N  
ATOM   4253  CA  THR D  41      36.808  38.772  82.459  1.00 27.26           C  
ATOM   4254  C   THR D  41      36.416  37.309  82.862  1.00 28.34           C  
ATOM   4255  O   THR D  41      35.894  36.552  82.052  1.00 24.47           O  
ATOM   4256  CB  THR D  41      38.323  38.896  82.241  1.00 23.89           C  
ATOM   4257  OG1 THR D  41      38.612  40.189  81.713  1.00 22.38           O  
ATOM   4258  CG2 THR D  41      38.826  37.834  81.282  1.00 24.43           C  
ATOM   4259  N   LEU D  42      36.640  36.955  84.121  1.00 27.02           N  
ATOM   4260  CA  LEU D  42      36.226  35.679  84.643  1.00 29.76           C  
ATOM   4261  C   LEU D  42      34.710  35.432  84.506  1.00 32.91           C  
ATOM   4262  O   LEU D  42      34.284  34.360  84.053  1.00 32.17           O  
ATOM   4263  CB  LEU D  42      36.606  35.594  86.111  1.00 31.82           C  
ATOM   4264  CG  LEU D  42      36.220  34.322  86.862  1.00 35.51           C  
ATOM   4265  CD1 LEU D  42      36.940  33.098  86.265  1.00 38.28           C  
ATOM   4266  CD2 LEU D  42      36.565  34.478  88.313  1.00 37.52           C  
ATOM   4267  N   LEU D  43      33.925  36.409  84.942  1.00 27.59           N  
ATOM   4268  CA  LEU D  43      32.480  36.296  84.996  1.00 31.12           C  
ATOM   4269  C   LEU D  43      31.907  36.110  83.591  1.00 31.40           C  
ATOM   4270  O   LEU D  43      31.043  35.253  83.381  1.00 26.30           O  
ATOM   4271  CB  LEU D  43      31.894  37.560  85.652  1.00 34.06           C  
ATOM   4272  CG  LEU D  43      30.768  37.427  86.650  1.00 40.51           C  
ATOM   4273  CD1 LEU D  43      31.124  36.425  87.773  1.00 43.21           C  
ATOM   4274  CD2 LEU D  43      30.418  38.825  87.228  1.00 39.78           C  
ATOM   4275  N   LEU D  44      32.412  36.920  82.647  1.00 28.48           N  
ATOM   4276  CA  LEU D  44      32.010  36.886  81.260  1.00 28.53           C  
ATOM   4277  C   LEU D  44      32.461  35.610  80.520  1.00 28.27           C  
ATOM   4278  O   LEU D  44      31.690  35.055  79.734  1.00 26.09           O  
ATOM   4279  CB  LEU D  44      32.521  38.113  80.505  1.00 30.62           C  
ATOM   4280  CG  LEU D  44      32.012  39.517  80.896  1.00 33.52           C  
ATOM   4281  CD1 LEU D  44      32.566  40.579  79.953  1.00 33.86           C  
ATOM   4282  CD2 LEU D  44      30.514  39.580  80.941  1.00 34.65           C  
ATOM   4283  N   ALA D  45      33.689  35.165  80.754  1.00 26.90           N  
ATOM   4284  CA  ALA D  45      34.172  33.876  80.227  1.00 28.36           C  
ATOM   4285  C   ALA D  45      33.242  32.727  80.645  1.00 30.99           C  
ATOM   4286  O   ALA D  45      32.876  31.907  79.831  1.00 31.87           O  
ATOM   4287  CB  ALA D  45      35.617  33.596  80.650  1.00 24.08           C  
ATOM   4288  N   GLU D  46      32.801  32.717  81.890  1.00 36.28           N  
ATOM   4289  CA  GLU D  46      31.855  31.706  82.344  1.00 42.18           C  
ATOM   4290  C   GLU D  46      30.448  31.817  81.699  1.00 40.37           C  
ATOM   4291  O   GLU D  46      29.742  30.815  81.533  1.00 38.97           O  
ATOM   4292  CB  GLU D  46      31.780  31.718  83.876  1.00 47.50           C  
ATOM   4293  CG  GLU D  46      33.145  31.311  84.527  1.00 53.80           C  
ATOM   4294  CD  GLU D  46      33.678  29.950  84.018  1.00 56.66           C  
ATOM   4295  OE1 GLU D  46      32.926  28.940  84.132  1.00 57.44           O  
ATOM   4296  OE2 GLU D  46      34.831  29.898  83.500  1.00 57.01           O  
ATOM   4297  N   GLU D  47      30.059  33.023  81.331  1.00 38.62           N  
ATOM   4298  CA  GLU D  47      28.836  33.225  80.566  1.00 40.18           C  
ATOM   4299  C   GLU D  47      29.019  32.712  79.127  1.00 38.11           C  
ATOM   4300  O   GLU D  47      28.121  32.082  78.587  1.00 36.07           O  
ATOM   4301  CB  GLU D  47      28.408  34.709  80.620  1.00 45.78           C  
ATOM   4302  CG  GLU D  47      27.145  35.063  79.856  1.00 51.90           C  
ATOM   4303  CD  GLU D  47      25.920  34.164  80.193  1.00 57.31           C  
ATOM   4304  OE1 GLU D  47      25.697  33.836  81.393  1.00 58.15           O  
ATOM   4305  OE2 GLU D  47      25.181  33.805  79.234  1.00 59.90           O  
ATOM   4306  N   LEU D  48      30.183  32.954  78.519  1.00 36.44           N  
ATOM   4307  CA  LEU D  48      30.466  32.415  77.197  1.00 38.91           C  
ATOM   4308  C   LEU D  48      30.415  30.883  77.204  1.00 41.66           C  
ATOM   4309  O   LEU D  48      29.787  30.273  76.316  1.00 40.17           O  
ATOM   4310  CB  LEU D  48      31.826  32.862  76.671  1.00 37.25           C  
ATOM   4311  CG  LEU D  48      32.003  34.346  76.360  1.00 40.66           C  
ATOM   4312  CD1 LEU D  48      33.402  34.580  75.829  1.00 42.97           C  
ATOM   4313  CD2 LEU D  48      30.967  34.894  75.398  1.00 40.61           C  
ATOM   4314  N   LYS D  49      31.082  30.286  78.197  1.00 43.33           N  
ATOM   4315  CA  LYS D  49      31.035  28.833  78.465  1.00 46.86           C  
ATOM   4316  C   LYS D  49      29.581  28.273  78.564  1.00 45.86           C  
ATOM   4317  O   LYS D  49      29.262  27.291  77.906  1.00 45.17           O  
ATOM   4318  CB  LYS D  49      31.834  28.522  79.747  1.00 51.02           C  
ATOM   4319  CG  LYS D  49      32.141  27.042  79.995  1.00 55.86           C  
ATOM   4320  CD  LYS D  49      31.789  26.588  81.443  1.00 57.36           C  
ATOM   4321  N   LYS D  50      28.722  28.909  79.367  1.00 44.21           N  
ATOM   4322  CA  LYS D  50      27.279  28.566  79.456  1.00 46.39           C  
ATOM   4323  C   LYS D  50      26.550  28.510  78.091  1.00 44.77           C  
ATOM   4324  O   LYS D  50      25.590  27.742  77.910  1.00 43.27           O  
ATOM   4325  CB  LYS D  50      26.516  29.579  80.346  1.00 47.30           C  
ATOM   4326  CG  LYS D  50      26.455  29.236  81.833  1.00 50.30           C  
ATOM   4327  N   LYS D  51      26.986  29.369  77.177  1.00 40.26           N  
ATOM   4328  CA  LYS D  51      26.467  29.429  75.825  1.00 37.91           C  
ATOM   4329  C   LYS D  51      27.183  28.455  74.880  1.00 32.46           C  
ATOM   4330  O   LYS D  51      26.853  28.400  73.728  1.00 33.91           O  
ATOM   4331  CB  LYS D  51      26.603  30.867  75.279  1.00 37.51           C  
ATOM   4332  CG  LYS D  51      25.681  31.860  75.952  1.00 35.72           C  
ATOM   4333  CD  LYS D  51      25.663  33.183  75.219  1.00 36.90           C  
ATOM   4334  CE  LYS D  51      24.477  34.074  75.679  1.00 37.18           C  
ATOM   4335  N   GLY D  52      28.171  27.707  75.357  1.00 33.40           N  
ATOM   4336  CA  GLY D  52      28.946  26.804  74.502  1.00 33.46           C  
ATOM   4337  C   GLY D  52      29.924  27.472  73.541  1.00 35.91           C  
ATOM   4338  O   GLY D  52      30.265  26.900  72.517  1.00 37.57           O  
ATOM   4339  N   VAL D  53      30.376  28.686  73.863  1.00 34.82           N  
ATOM   4340  CA  VAL D  53      31.373  29.409  73.056  1.00 31.45           C  
ATOM   4341  C   VAL D  53      32.770  28.963  73.524  1.00 36.63           C  
ATOM   4342  O   VAL D  53      33.058  28.937  74.735  1.00 36.54           O  
ATOM   4343  CB  VAL D  53      31.206  30.966  73.231  1.00 33.16           C  
ATOM   4344  CG1 VAL D  53      32.202  31.749  72.427  1.00 33.04           C  
ATOM   4345  CG2 VAL D  53      29.811  31.404  72.863  1.00 33.18           C  
ATOM   4346  N   GLU D  54      33.639  28.616  72.579  1.00 39.06           N  
ATOM   4347  CA  GLU D  54      34.970  28.175  72.924  1.00 42.68           C  
ATOM   4348  C   GLU D  54      35.749  29.392  73.361  1.00 42.35           C  
ATOM   4349  O   GLU D  54      35.669  30.441  72.739  1.00 44.91           O  
ATOM   4350  CB  GLU D  54      35.681  27.498  71.730  1.00 46.04           C  
ATOM   4351  N   ILE D  55      36.482  29.260  74.449  1.00 39.68           N  
ATOM   4352  CA  ILE D  55      37.303  30.346  74.932  1.00 38.37           C  
ATOM   4353  C   ILE D  55      38.315  29.748  75.866  1.00 34.26           C  
ATOM   4354  O   ILE D  55      37.960  28.948  76.718  1.00 30.76           O  
ATOM   4355  CB  ILE D  55      36.439  31.453  75.648  1.00 41.98           C  
ATOM   4356  CG1 ILE D  55      37.331  32.576  76.172  1.00 44.37           C  
ATOM   4357  CG2 ILE D  55      35.570  30.866  76.766  1.00 41.87           C  
ATOM   4358  CD1 ILE D  55      36.723  33.911  76.084  1.00 47.08           C  
ATOM   4359  N   ASP D  56      39.576  30.108  75.678  1.00 30.10           N  
ATOM   4360  CA  ASP D  56      40.621  29.705  76.591  1.00 31.50           C  
ATOM   4361  C   ASP D  56      40.550  30.649  77.801  1.00 31.03           C  
ATOM   4362  O   ASP D  56      40.994  31.817  77.701  1.00 27.46           O  
ATOM   4363  CB  ASP D  56      41.953  29.831  75.868  1.00 32.60           C  
ATOM   4364  CG  ASP D  56      43.101  29.265  76.643  1.00 31.99           C  
ATOM   4365  OD1 ASP D  56      43.004  29.055  77.887  1.00 30.45           O  
ATOM   4366  OD2 ASP D  56      44.130  29.047  75.974  1.00 35.48           O  
ATOM   4367  N   VAL D  57      39.951  30.156  78.901  1.00 28.73           N  
ATOM   4368  CA  VAL D  57      39.735  30.954  80.112  1.00 30.02           C  
ATOM   4369  C   VAL D  57      41.043  31.352  80.740  1.00 28.78           C  
ATOM   4370  O   VAL D  57      41.230  32.515  81.034  1.00 25.45           O  
ATOM   4371  CB  VAL D  57      38.817  30.274  81.172  1.00 30.63           C  
ATOM   4372  CG1 VAL D  57      38.689  31.167  82.436  1.00 29.43           C  
ATOM   4373  CG2 VAL D  57      37.435  30.034  80.610  1.00 30.96           C  
ATOM   4374  N   GLU D  58      41.961  30.399  80.885  1.00 28.06           N  
ATOM   4375  CA  GLU D  58      43.329  30.673  81.348  1.00 29.59           C  
ATOM   4376  C   GLU D  58      44.031  31.796  80.607  1.00 26.63           C  
ATOM   4377  O   GLU D  58      44.676  32.647  81.229  1.00 24.86           O  
ATOM   4378  CB  GLU D  58      44.203  29.427  81.243  1.00 31.88           C  
ATOM   4379  CG  GLU D  58      45.634  29.614  81.777  1.00 32.86           C  
ATOM   4380  CD  GLU D  58      46.473  28.336  81.687  1.00 34.57           C  
ATOM   4381  OE1 GLU D  58      45.878  27.253  81.692  1.00 40.17           O  
ATOM   4382  OE2 GLU D  58      47.719  28.421  81.611  1.00 31.40           O  
ATOM   4383  N   LYS D  59      43.953  31.782  79.288  1.00 25.30           N  
ATOM   4384  CA  LYS D  59      44.583  32.818  78.517  1.00 26.92           C  
ATOM   4385  C   LYS D  59      43.957  34.211  78.764  1.00 23.50           C  
ATOM   4386  O   LYS D  59      44.672  35.198  78.884  1.00 23.37           O  
ATOM   4387  CB  LYS D  59      44.529  32.542  77.039  1.00 27.58           C  
ATOM   4388  CG  LYS D  59      45.512  33.446  76.290  1.00 31.71           C  
ATOM   4389  CD  LYS D  59      45.118  33.682  74.881  1.00 34.45           C  
ATOM   4390  CE  LYS D  59      45.255  32.512  74.021  1.00 31.20           C  
ATOM   4391  NZ  LYS D  59      45.231  32.936  72.588  1.00 27.97           N  
ATOM   4392  N   ALA D  60      42.642  34.268  78.763  1.00 19.77           N  
ATOM   4393  CA  ALA D  60      41.911  35.494  79.007  1.00 23.06           C  
ATOM   4394  C   ALA D  60      42.291  36.145  80.371  1.00 22.31           C  
ATOM   4395  O   ALA D  60      42.391  37.375  80.489  1.00 21.27           O  
ATOM   4396  CB  ALA D  60      40.456  35.218  78.960  1.00 21.36           C  
ATOM   4397  N   LEU D  61      42.462  35.313  81.382  1.00 20.72           N  
ATOM   4398  CA  LEU D  61      42.797  35.774  82.729  1.00 22.57           C  
ATOM   4399  C   LEU D  61      44.255  36.300  82.775  1.00 26.07           C  
ATOM   4400  O   LEU D  61      44.547  37.330  83.414  1.00 19.78           O  
ATOM   4401  CB  LEU D  61      42.573  34.643  83.757  1.00 21.80           C  
ATOM   4402  CG  LEU D  61      41.146  34.114  83.959  1.00 21.50           C  
ATOM   4403  CD1 LEU D  61      41.088  32.947  84.984  1.00 23.39           C  
ATOM   4404  CD2 LEU D  61      40.179  35.211  84.394  1.00 24.00           C  
ATOM   4405  N   LYS D  62      45.146  35.626  82.053  1.00 22.21           N  
ATOM   4406  CA  LYS D  62      46.502  36.075  81.932  1.00 23.21           C  
ATOM   4407  C   LYS D  62      46.577  37.443  81.244  1.00 24.41           C  
ATOM   4408  O   LYS D  62      47.278  38.334  81.698  1.00 23.17           O  
ATOM   4409  CB  LYS D  62      47.336  35.055  81.162  1.00 27.13           C  
ATOM   4410  CG  LYS D  62      47.701  33.781  81.950  1.00 30.64           C  
ATOM   4411  CD  LYS D  62      48.766  32.968  81.133  1.00 31.26           C  
ATOM   4412  CE  LYS D  62      49.008  31.555  81.627  1.00 32.50           C  
ATOM   4413  NZ  LYS D  62      50.038  30.871  80.710  1.00 34.15           N  
ATOM   4414  N   ILE D  63      45.856  37.596  80.143  1.00 19.68           N  
ATOM   4415  CA  ILE D  63      45.808  38.841  79.436  1.00 21.89           C  
ATOM   4416  C   ILE D  63      45.247  39.946  80.347  1.00 23.80           C  
ATOM   4417  O   ILE D  63      45.768  41.057  80.338  1.00 20.85           O  
ATOM   4418  CB  ILE D  63      44.917  38.748  78.146  1.00 24.16           C  
ATOM   4419  CG1 ILE D  63      45.521  37.797  77.102  1.00 24.41           C  
ATOM   4420  CG2 ILE D  63      44.724  40.120  77.502  1.00 24.07           C  
ATOM   4421  CD1 ILE D  63      44.513  37.399  76.002  1.00 25.04           C  
ATOM   4422  N   ALA D  64      44.175  39.646  81.098  1.00 24.12           N  
ATOM   4423  CA  ALA D  64      43.574  40.640  81.991  1.00 22.58           C  
ATOM   4424  C   ALA D  64      44.623  41.105  83.015  1.00 22.07           C  
ATOM   4425  O   ALA D  64      44.825  42.282  83.160  1.00 22.34           O  
ATOM   4426  CB  ALA D  64      42.362  40.097  82.681  1.00 20.76           C  
ATOM   4427  N   ILE D  65      45.337  40.169  83.646  1.00 22.10           N  
ATOM   4428  CA  ILE D  65      46.392  40.530  84.610  1.00 24.93           C  
ATOM   4429  C   ILE D  65      47.459  41.487  84.007  1.00 24.05           C  
ATOM   4430  O   ILE D  65      47.876  42.468  84.650  1.00 26.25           O  
ATOM   4431  CB  ILE D  65      46.989  39.254  85.285  1.00 23.38           C  
ATOM   4432  CG1 ILE D  65      45.901  38.571  86.102  1.00 21.98           C  
ATOM   4433  CG2 ILE D  65      48.157  39.581  86.218  1.00 23.42           C  
ATOM   4434  CD1 ILE D  65      46.168  37.101  86.432  1.00 25.10           C  
ATOM   4435  N   ILE D  66      47.824  41.265  82.741  1.00 23.43           N  
ATOM   4436  CA  ILE D  66      48.988  41.940  82.182  1.00 21.95           C  
ATOM   4437  C   ILE D  66      48.614  43.088  81.312  1.00 20.58           C  
ATOM   4438  O   ILE D  66      49.490  43.853  80.889  1.00 21.29           O  
ATOM   4439  CB  ILE D  66      50.017  40.930  81.417  1.00 24.33           C  
ATOM   4440  CG1 ILE D  66      49.408  40.270  80.171  1.00 21.30           C  
ATOM   4441  CG2 ILE D  66      50.530  39.821  82.365  1.00 20.38           C  
ATOM   4442  CD1 ILE D  66      49.086  41.202  79.051  1.00 22.09           C  
ATOM   4443  N   HIS D  67      47.327  43.246  81.021  1.00 19.78           N  
ATOM   4444  CA  HIS D  67      46.978  44.148  79.936  1.00 23.28           C  
ATOM   4445  C   HIS D  67      47.321  45.639  80.200  1.00 27.15           C  
ATOM   4446  O   HIS D  67      47.439  46.389  79.242  1.00 25.56           O  
ATOM   4447  CB  HIS D  67      45.518  44.021  79.526  1.00 19.90           C  
ATOM   4448  CG  HIS D  67      44.597  44.807  80.399  1.00 24.44           C  
ATOM   4449  ND1 HIS D  67      44.282  44.407  81.678  1.00 22.70           N  
ATOM   4450  CD2 HIS D  67      43.987  46.004  80.209  1.00 17.41           C  
ATOM   4451  CE1 HIS D  67      43.499  45.315  82.233  1.00 27.48           C  
ATOM   4452  NE2 HIS D  67      43.296  46.287  81.361  1.00 24.01           N  
ATOM   4453  N   ASP D  68      47.469  46.063  81.463  1.00 24.91           N  
ATOM   4454  CA  ASP D  68      47.851  47.464  81.752  1.00 23.91           C  
ATOM   4455  C   ASP D  68      49.174  47.506  82.472  1.00 21.52           C  
ATOM   4456  O   ASP D  68      49.560  48.541  82.983  1.00 25.55           O  
ATOM   4457  CB  ASP D  68      46.758  48.194  82.605  1.00 26.83           C  
ATOM   4458  CG  ASP D  68      45.633  48.813  81.758  1.00 28.83           C  
ATOM   4459  OD1 ASP D  68      45.756  48.871  80.514  1.00 31.86           O  
ATOM   4460  OD2 ASP D  68      44.617  49.278  82.347  1.00 29.68           O  
ATOM   4461  N   LEU D  69      49.897  46.396  82.510  1.00 20.79           N  
ATOM   4462  CA  LEU D  69      51.188  46.352  83.201  1.00 24.47           C  
ATOM   4463  C   LEU D  69      52.269  47.291  82.640  1.00 25.69           C  
ATOM   4464  O   LEU D  69      53.109  47.794  83.398  1.00 26.26           O  
ATOM   4465  CB  LEU D  69      51.709  44.929  83.193  1.00 30.70           C  
ATOM   4466  CG  LEU D  69      52.823  44.583  84.169  1.00 34.85           C  
ATOM   4467  CD1 LEU D  69      52.556  45.091  85.627  1.00 34.60           C  
ATOM   4468  CD2 LEU D  69      52.951  43.091  84.140  1.00 37.59           C  
ATOM   4469  N   GLY D  70      52.264  47.513  81.318  1.00 25.48           N  
ATOM   4470  CA  GLY D  70      53.103  48.531  80.697  1.00 23.60           C  
ATOM   4471  C   GLY D  70      52.945  49.918  81.336  1.00 24.74           C  
ATOM   4472  O   GLY D  70      53.863  50.731  81.306  1.00 26.61           O  
ATOM   4473  N   GLU D  71      51.780  50.185  81.913  1.00 24.72           N  
ATOM   4474  CA  GLU D  71      51.516  51.452  82.595  1.00 23.64           C  
ATOM   4475  C   GLU D  71      52.297  51.632  83.899  1.00 21.66           C  
ATOM   4476  O   GLU D  71      52.445  52.765  84.400  1.00 18.83           O  
ATOM   4477  CB  GLU D  71      50.022  51.634  82.814  1.00 22.11           C  
ATOM   4478  CG  GLU D  71      49.316  51.745  81.496  1.00 25.36           C  
ATOM   4479  CD  GLU D  71      47.850  51.968  81.605  1.00 28.92           C  
ATOM   4480  OE1 GLU D  71      47.334  52.031  82.748  1.00 31.82           O  
ATOM   4481  OE2 GLU D  71      47.224  52.068  80.531  1.00 26.59           O  
ATOM   4482  N   ALA D  72      52.861  50.547  84.420  1.00 20.70           N  
ATOM   4483  CA  ALA D  72      53.760  50.661  85.556  1.00 21.14           C  
ATOM   4484  C   ALA D  72      55.004  51.440  85.186  1.00 18.19           C  
ATOM   4485  O   ALA D  72      55.627  52.041  86.063  1.00 18.37           O  
ATOM   4486  CB  ALA D  72      54.114  49.296  86.137  1.00 21.95           C  
ATOM   4487  N   ILE D  73      55.336  51.452  83.892  1.00 18.42           N  
ATOM   4488  CA  ILE D  73      56.478  52.208  83.332  1.00 20.57           C  
ATOM   4489  C   ILE D  73      56.077  53.492  82.587  1.00 20.94           C  
ATOM   4490  O   ILE D  73      56.745  54.537  82.693  1.00 19.48           O  
ATOM   4491  CB  ILE D  73      57.311  51.297  82.346  1.00 23.34           C  
ATOM   4492  CG1 ILE D  73      58.023  50.211  83.161  1.00 27.62           C  
ATOM   4493  CG2 ILE D  73      58.332  52.141  81.526  1.00 20.69           C  
ATOM   4494  CD1 ILE D  73      57.861  48.875  82.617  1.00 33.33           C  
ATOM   4495  N   ILE D  74      55.016  53.387  81.808  1.00 20.46           N  
ATOM   4496  CA  ILE D  74      54.539  54.470  80.955  1.00 22.95           C  
ATOM   4497  C   ILE D  74      53.585  55.437  81.722  1.00 23.98           C  
ATOM   4498  O   ILE D  74      53.452  56.604  81.337  1.00 24.48           O  
ATOM   4499  CB  ILE D  74      53.806  53.845  79.710  1.00 26.00           C  
ATOM   4500  CG1 ILE D  74      54.798  53.046  78.849  1.00 27.55           C  
ATOM   4501  CG2 ILE D  74      53.060  54.901  78.881  1.00 25.65           C  
ATOM   4502  CD1 ILE D  74      55.940  53.879  78.306  1.00 26.36           C  
ATOM   4503  N   THR D  75      52.999  54.931  82.825  1.00 27.43           N  
ATOM   4504  CA  THR D  75      51.826  55.517  83.568  1.00 25.68           C  
ATOM   4505  C   THR D  75      50.573  55.372  82.685  1.00 26.29           C  
ATOM   4506  O   THR D  75      50.668  54.869  81.585  1.00 23.21           O  
ATOM   4507  CB  THR D  75      52.011  57.019  84.042  1.00 22.86           C  
ATOM   4508  OG1 THR D  75      51.919  57.876  82.927  1.00 13.53           O  
ATOM   4509  CG2 THR D  75      53.343  57.254  84.695  1.00 25.06           C  
ATOM   4510  N   ASP D  76      49.406  55.788  83.206  1.00 24.73           N  
ATOM   4511  CA  ASP D  76      48.130  55.702  82.494  1.00 26.84           C  
ATOM   4512  C   ASP D  76      47.872  57.029  81.748  1.00 27.63           C  
ATOM   4513  O   ASP D  76      47.372  58.005  82.310  1.00 27.53           O  
ATOM   4514  CB  ASP D  76      46.965  55.372  83.472  1.00 26.52           C  
ATOM   4515  CG  ASP D  76      45.602  55.316  82.777  1.00 27.67           C  
ATOM   4516  OD1 ASP D  76      45.549  54.998  81.583  1.00 29.36           O  
ATOM   4517  OD2 ASP D  76      44.576  55.605  83.414  1.00 32.07           O  
ATOM   4518  N   LEU D  77      48.217  57.052  80.481  1.00 27.47           N  
ATOM   4519  CA  LEU D  77      48.097  58.274  79.696  1.00 29.25           C  
ATOM   4520  C   LEU D  77      46.631  58.576  79.350  1.00 27.16           C  
ATOM   4521  O   LEU D  77      45.934  57.745  78.738  1.00 24.36           O  
ATOM   4522  CB  LEU D  77      48.908  58.188  78.430  1.00 31.22           C  
ATOM   4523  CG  LEU D  77      50.392  57.973  78.609  1.00 32.52           C  
ATOM   4524  CD1 LEU D  77      50.995  57.714  77.245  1.00 34.34           C  
ATOM   4525  CD2 LEU D  77      51.055  59.188  79.271  1.00 33.12           C  
ATOM   4526  N   PRO D  78      46.168  59.773  79.737  1.00 25.52           N  
ATOM   4527  CA  PRO D  78      44.788  60.152  79.438  1.00 26.54           C  
ATOM   4528  C   PRO D  78      44.618  60.430  77.921  1.00 27.82           C  
ATOM   4529  O   PRO D  78      45.618  60.484  77.145  1.00 23.56           O  
ATOM   4530  CB  PRO D  78      44.576  61.417  80.310  1.00 24.87           C  
ATOM   4531  CG  PRO D  78      46.012  62.018  80.438  1.00 23.73           C  
ATOM   4532  CD  PRO D  78      46.942  60.864  80.399  1.00 22.87           C  
ATOM   4533  N   LEU D  79      43.365  60.561  77.494  1.00 30.27           N  
ATOM   4534  CA  LEU D  79      43.044  60.840  76.085  1.00 32.02           C  
ATOM   4535  C   LEU D  79      43.754  62.085  75.541  1.00 28.46           C  
ATOM   4536  O   LEU D  79      44.318  62.072  74.435  1.00 27.95           O  
ATOM   4537  CB  LEU D  79      41.529  60.967  75.915  1.00 32.40           C  
ATOM   4538  CG  LEU D  79      40.806  59.624  75.985  1.00 37.54           C  
ATOM   4539  CD1 LEU D  79      39.272  59.845  75.969  1.00 39.93           C  
ATOM   4540  CD2 LEU D  79      41.237  58.679  74.846  1.00 38.11           C  
ATOM   4541  N   SER D  80      43.740  63.154  76.335  1.00 27.55           N  
ATOM   4542  CA  SER D  80      44.353  64.415  75.944  1.00 25.43           C  
ATOM   4543  C   SER D  80      45.808  64.180  75.489  1.00 27.11           C  
ATOM   4544  O   SER D  80      46.279  64.808  74.537  1.00 26.96           O  
ATOM   4545  CB  SER D  80      44.337  65.395  77.125  1.00 22.44           C  
ATOM   4546  OG  SER D  80      45.197  64.923  78.176  1.00 21.56           O  
ATOM   4547  N   ALA D  81      46.512  63.305  76.221  1.00 26.38           N  
ATOM   4548  CA  ALA D  81      47.907  62.986  75.936  1.00 26.75           C  
ATOM   4549  C   ALA D  81      48.057  62.116  74.690  1.00 25.57           C  
ATOM   4550  O   ALA D  81      49.061  62.211  74.001  1.00 22.87           O  
ATOM   4551  CB  ALA D  81      48.552  62.286  77.136  1.00 26.07           C  
ATOM   4552  N   GLN D  82      47.069  61.263  74.424  1.00 26.31           N  
ATOM   4553  CA  GLN D  82      47.141  60.307  73.306  1.00 30.29           C  
ATOM   4554  C   GLN D  82      46.994  60.972  71.937  1.00 33.77           C  
ATOM   4555  O   GLN D  82      47.246  60.337  70.935  1.00 34.64           O  
ATOM   4556  CB  GLN D  82      46.085  59.222  73.439  1.00 26.88           C  
ATOM   4557  CG  GLN D  82      46.208  58.426  74.717  1.00 29.01           C  
ATOM   4558  CD  GLN D  82      45.047  57.502  74.900  1.00 31.49           C  
ATOM   4559  OE1 GLN D  82      44.634  56.866  73.949  1.00 33.55           O  
ATOM   4560  NE2 GLN D  82      44.527  57.397  76.125  1.00 31.67           N  
ATOM   4561  N   LYS D  83      46.592  62.245  71.904  1.00 34.71           N  
ATOM   4562  CA  LYS D  83      46.643  63.038  70.679  1.00 37.35           C  
ATOM   4563  C   LYS D  83      48.101  63.328  70.252  1.00 37.04           C  
ATOM   4564  O   LYS D  83      48.368  63.590  69.071  1.00 40.08           O  
ATOM   4565  CB  LYS D  83      45.865  64.355  70.860  1.00 38.83           C  
ATOM   4566  N   TYR D  84      49.035  63.266  71.207  1.00 30.40           N  
ATOM   4567  CA  TYR D  84      50.440  63.561  70.952  1.00 32.09           C  
ATOM   4568  C   TYR D  84      51.386  62.359  71.104  1.00 35.46           C  
ATOM   4569  O   TYR D  84      52.544  62.422  70.688  1.00 38.52           O  
ATOM   4570  CB  TYR D  84      50.891  64.706  71.873  1.00 30.25           C  
ATOM   4571  CG  TYR D  84      50.011  65.921  71.662  1.00 29.59           C  
ATOM   4572  CD1 TYR D  84      50.179  66.744  70.552  1.00 31.14           C  
ATOM   4573  CD2 TYR D  84      48.943  66.188  72.518  1.00 31.55           C  
ATOM   4574  CE1 TYR D  84      49.325  67.846  70.334  1.00 32.76           C  
ATOM   4575  CE2 TYR D  84      48.091  67.280  72.313  1.00 31.27           C  
ATOM   4576  CZ  TYR D  84      48.292  68.102  71.240  1.00 29.52           C  
ATOM   4577  OH  TYR D  84      47.450  69.150  71.064  1.00 31.58           O  
ATOM   4578  N   LEU D  85      50.913  61.290  71.732  1.00 35.16           N  
ATOM   4579  CA  LEU D  85      51.785  60.196  72.137  1.00 36.60           C  
ATOM   4580  C   LEU D  85      51.081  58.895  71.849  1.00 37.12           C  
ATOM   4581  O   LEU D  85      49.873  58.772  72.097  1.00 36.95           O  
ATOM   4582  CB  LEU D  85      52.113  60.281  73.637  1.00 37.14           C  
ATOM   4583  CG  LEU D  85      53.004  61.450  74.100  1.00 37.63           C  
ATOM   4584  CD1 LEU D  85      52.940  61.631  75.598  1.00 34.49           C  
ATOM   4585  CD2 LEU D  85      54.448  61.258  73.644  1.00 38.19           C  
ATOM   4586  N   ASN D  86      51.829  57.923  71.335  1.00 38.85           N  
ATOM   4587  CA  ASN D  86      51.251  56.611  70.997  1.00 37.90           C  
ATOM   4588  C   ASN D  86      51.376  55.687  72.204  1.00 35.10           C  
ATOM   4589  O   ASN D  86      52.446  55.112  72.471  1.00 32.47           O  
ATOM   4590  CB  ASN D  86      51.922  56.025  69.755  1.00 38.34           C  
ATOM   4591  CG  ASN D  86      51.128  54.867  69.151  1.00 43.23           C  
ATOM   4592  OD1 ASN D  86      50.610  53.986  69.866  1.00 40.50           O  
ATOM   4593  ND2 ASN D  86      51.029  54.864  67.823  1.00 45.12           N  
ATOM   4594  N   LYS D  87      50.265  55.578  72.933  1.00 34.28           N  
ATOM   4595  CA  LYS D  87      50.188  54.870  74.229  1.00 33.70           C  
ATOM   4596  C   LYS D  87      50.394  53.329  74.134  1.00 29.27           C  
ATOM   4597  O   LYS D  87      51.184  52.771  74.863  1.00 28.96           O  
ATOM   4598  CB  LYS D  87      48.815  55.189  74.851  1.00 35.52           C  
ATOM   4599  CG  LYS D  87      48.465  54.517  76.194  1.00 35.46           C  
ATOM   4600  CD  LYS D  87      47.056  54.944  76.620  1.00 35.72           C  
ATOM   4601  CE  LYS D  87      46.426  54.032  77.701  1.00 35.78           C  
ATOM   4602  NZ  LYS D  87      45.713  54.843  78.748  1.00 25.56           N  
ATOM   4603  N   GLU D  88      49.656  52.665  73.250  1.00 30.67           N  
ATOM   4604  CA  GLU D  88      49.773  51.213  73.060  1.00 32.91           C  
ATOM   4605  C   GLU D  88      51.195  50.821  72.609  1.00 32.05           C  
ATOM   4606  O   GLU D  88      51.786  49.896  73.142  1.00 34.69           O  
ATOM   4607  CB  GLU D  88      48.710  50.704  72.059  1.00 31.07           C  
ATOM   4608  N   GLU D  89      51.736  51.562  71.654  1.00 35.41           N  
ATOM   4609  CA  GLU D  89      53.095  51.350  71.133  1.00 39.16           C  
ATOM   4610  C   GLU D  89      54.145  51.483  72.247  1.00 36.47           C  
ATOM   4611  O   GLU D  89      55.023  50.617  72.409  1.00 31.17           O  
ATOM   4612  CB  GLU D  89      53.340  52.346  69.993  1.00 43.10           C  
ATOM   4613  CG  GLU D  89      54.724  52.363  69.346  1.00 49.54           C  
ATOM   4614  CD  GLU D  89      54.798  53.393  68.194  1.00 52.03           C  
ATOM   4615  OE1 GLU D  89      54.039  53.227  67.204  1.00 58.73           O  
ATOM   4616  OE2 GLU D  89      55.600  54.361  68.277  1.00 56.61           O  
ATOM   4617  N   ALA D  90      54.037  52.545  73.043  1.00 33.36           N  
ATOM   4618  CA  ALA D  90      54.903  52.686  74.239  1.00 29.21           C  
ATOM   4619  C   ALA D  90      54.709  51.564  75.262  1.00 25.16           C  
ATOM   4620  O   ALA D  90      55.680  51.056  75.804  1.00 25.77           O  
ATOM   4621  CB  ALA D  90      54.664  54.042  74.889  1.00 29.90           C  
ATOM   4622  N   GLU D  91      53.458  51.172  75.535  1.00 27.70           N  
ATOM   4623  CA  GLU D  91      53.181  50.095  76.529  1.00 27.24           C  
ATOM   4624  C   GLU D  91      53.745  48.769  76.043  1.00 27.27           C  
ATOM   4625  O   GLU D  91      54.292  48.002  76.841  1.00 25.80           O  
ATOM   4626  CB  GLU D  91      51.682  49.936  76.838  1.00 25.74           C  
ATOM   4627  CG  GLU D  91      51.136  50.954  77.811  1.00 29.03           C  
ATOM   4628  CD  GLU D  91      49.668  50.721  78.171  1.00 29.44           C  
ATOM   4629  OE1 GLU D  91      49.271  49.570  78.500  1.00 29.58           O  
ATOM   4630  OE2 GLU D  91      48.916  51.716  78.162  1.00 33.96           O  
ATOM   4631  N   ALA D  92      53.598  48.507  74.739  1.00 28.06           N  
ATOM   4632  CA  ALA D  92      54.108  47.253  74.114  1.00 31.40           C  
ATOM   4633  C   ALA D  92      55.630  47.110  74.202  1.00 27.79           C  
ATOM   4634  O   ALA D  92      56.146  46.045  74.542  1.00 29.90           O  
ATOM   4635  CB  ALA D  92      53.635  47.144  72.647  1.00 29.98           C  
ATOM   4636  N   LYS D  93      56.345  48.184  73.931  1.00 30.49           N  
ATOM   4637  CA  LYS D  93      57.808  48.205  74.106  1.00 32.63           C  
ATOM   4638  C   LYS D  93      58.214  48.004  75.573  1.00 31.17           C  
ATOM   4639  O   LYS D  93      59.080  47.190  75.905  1.00 28.43           O  
ATOM   4640  CB  LYS D  93      58.365  49.525  73.605  1.00 34.38           C  
ATOM   4641  CG  LYS D  93      58.165  49.766  72.119  1.00 36.86           C  
ATOM   4642  N   ALA D  94      57.579  48.754  76.462  1.00 31.40           N  
ATOM   4643  CA  ALA D  94      57.922  48.664  77.890  1.00 26.54           C  
ATOM   4644  C   ALA D  94      57.716  47.229  78.361  1.00 30.06           C  
ATOM   4645  O   ALA D  94      58.565  46.659  79.071  1.00 29.90           O  
ATOM   4646  CB  ALA D  94      57.079  49.614  78.699  1.00 25.12           C  
ATOM   4647  N   LEU D  95      56.574  46.653  77.974  1.00 31.82           N  
ATOM   4648  CA  LEU D  95      56.236  45.289  78.355  1.00 33.99           C  
ATOM   4649  C   LEU D  95      57.237  44.278  77.804  1.00 31.24           C  
ATOM   4650  O   LEU D  95      57.651  43.364  78.513  1.00 33.71           O  
ATOM   4651  CB  LEU D  95      54.818  44.926  77.912  1.00 34.62           C  
ATOM   4652  CG  LEU D  95      54.265  43.710  78.641  1.00 39.73           C  
ATOM   4653  CD1 LEU D  95      53.960  44.064  80.103  1.00 39.56           C  
ATOM   4654  CD2 LEU D  95      53.019  43.196  77.941  1.00 41.02           C  
ATOM   4655  N   LYS D  96      57.633  44.463  76.557  1.00 32.41           N  
ATOM   4656  CA  LYS D  96      58.575  43.564  75.896  1.00 36.19           C  
ATOM   4657  C   LYS D  96      59.894  43.497  76.668  1.00 38.28           C  
ATOM   4658  O   LYS D  96      60.463  42.406  76.850  1.00 40.47           O  
ATOM   4659  CB  LYS D  96      58.830  44.021  74.456  1.00 37.07           C  
ATOM   4660  CG  LYS D  96      59.752  43.075  73.643  1.00 38.66           C  
ATOM   4661  CD  LYS D  96      59.781  43.459  72.155  1.00 39.42           C  
ATOM   4662  N   ASP D  97      60.358  44.661  77.136  1.00 40.33           N  
ATOM   4663  CA  ASP D  97      61.600  44.779  77.922  1.00 37.87           C  
ATOM   4664  C   ASP D  97      61.537  44.101  79.294  1.00 38.22           C  
ATOM   4665  O   ASP D  97      62.570  43.749  79.859  1.00 37.06           O  
ATOM   4666  CB  ASP D  97      61.967  46.252  78.111  1.00 40.02           C  
ATOM   4667  CG  ASP D  97      62.531  46.875  76.853  1.00 43.90           C  
ATOM   4668  OD1 ASP D  97      62.927  46.083  75.950  1.00 44.12           O  
ATOM   4669  OD2 ASP D  97      62.590  48.142  76.760  1.00 41.29           O  
ATOM   4670  N   VAL D  98      60.346  43.906  79.852  1.00 34.78           N  
ATOM   4671  CA  VAL D  98      60.284  43.221  81.149  1.00 30.68           C  
ATOM   4672  C   VAL D  98      59.634  41.849  81.099  1.00 28.61           C  
ATOM   4673  O   VAL D  98      59.991  40.971  81.869  1.00 23.74           O  
ATOM   4674  CB  VAL D  98      59.621  44.097  82.217  1.00 29.55           C  
ATOM   4675  CG1 VAL D  98      60.530  45.296  82.499  1.00 31.16           C  
ATOM   4676  CG2 VAL D  98      58.216  44.534  81.802  1.00 29.36           C  
ATOM   4677  N   LEU D  99      58.655  41.686  80.223  1.00 25.00           N  
ATOM   4678  CA  LEU D  99      57.944  40.434  80.096  1.00 29.38           C  
ATOM   4679  C   LEU D  99      57.789  40.106  78.606  1.00 28.98           C  
ATOM   4680  O   LEU D  99      56.714  40.210  78.062  1.00 25.60           O  
ATOM   4681  CB  LEU D  99      56.587  40.543  80.773  1.00 33.59           C  
ATOM   4682  CG  LEU D  99      56.616  40.634  82.297  1.00 38.67           C  
ATOM   4683  CD1 LEU D  99      55.252  41.002  82.822  1.00 42.42           C  
ATOM   4684  CD2 LEU D  99      57.066  39.290  82.914  1.00 39.86           C  
ATOM   4685  N   PRO D 100      58.899  39.720  77.952  1.00 32.98           N  
ATOM   4686  CA  PRO D 100      58.887  39.424  76.511  1.00 31.56           C  
ATOM   4687  C   PRO D 100      57.989  38.254  76.169  1.00 30.91           C  
ATOM   4688  O   PRO D 100      57.458  38.199  75.070  1.00 29.19           O  
ATOM   4689  CB  PRO D 100      60.373  39.136  76.196  1.00 29.27           C  
ATOM   4690  CG  PRO D 100      61.000  38.798  77.499  1.00 32.40           C  
ATOM   4691  CD  PRO D 100      60.241  39.534  78.554  1.00 33.08           C  
ATOM   4692  N   GLU D 101      57.808  37.342  77.129  1.00 33.24           N  
ATOM   4693  CA  GLU D 101      56.913  36.217  76.973  1.00 36.87           C  
ATOM   4694  C   GLU D 101      55.420  36.561  76.862  1.00 36.06           C  
ATOM   4695  O   GLU D 101      54.654  35.690  76.471  1.00 40.49           O  
ATOM   4696  CB  GLU D 101      57.093  35.222  78.135  1.00 41.97           C  
ATOM   4697  CG  GLU D 101      56.609  35.765  79.529  1.00 44.70           C  
ATOM   4698  CD  GLU D 101      57.772  36.170  80.482  1.00 46.38           C  
ATOM   4699  OE1 GLU D 101      58.623  37.047  80.130  1.00 34.29           O  
ATOM   4700  OE2 GLU D 101      57.795  35.592  81.602  1.00 49.49           O  
ATOM   4701  N   TYR D 102      55.003  37.778  77.236  1.00 33.13           N  
ATOM   4702  CA  TYR D 102      53.578  38.153  77.235  1.00 33.15           C  
ATOM   4703  C   TYR D 102      53.270  39.138  76.083  1.00 31.69           C  
ATOM   4704  O   TYR D 102      52.172  39.685  75.967  1.00 27.33           O  
ATOM   4705  CB  TYR D 102      53.155  38.721  78.624  1.00 37.99           C  
ATOM   4706  CG  TYR D 102      53.235  37.691  79.751  1.00 37.99           C  
ATOM   4707  CD1 TYR D 102      52.600  36.478  79.645  1.00 41.98           C  
ATOM   4708  CD2 TYR D 102      53.967  37.932  80.902  1.00 41.32           C  
ATOM   4709  CE1 TYR D 102      52.695  35.516  80.653  1.00 42.51           C  
ATOM   4710  CE2 TYR D 102      54.059  36.982  81.917  1.00 41.09           C  
ATOM   4711  CZ  TYR D 102      53.421  35.775  81.783  1.00 40.82           C  
ATOM   4712  OH  TYR D 102      53.493  34.811  82.775  1.00 39.83           O  
ATOM   4713  N   THR D 103      54.266  39.349  75.238  1.00 29.22           N  
ATOM   4714  CA  THR D 103      54.151  40.230  74.084  1.00 29.63           C  
ATOM   4715  C   THR D 103      52.970  39.883  73.173  1.00 28.32           C  
ATOM   4716  O   THR D 103      52.272  40.785  72.688  1.00 23.96           O  
ATOM   4717  CB  THR D 103      55.464  40.203  73.266  1.00 29.91           C  
ATOM   4718  OG1 THR D 103      56.407  41.055  73.912  1.00 35.82           O  
ATOM   4719  CG2 THR D 103      55.245  40.721  71.856  1.00 36.86           C  
ATOM   4720  N   GLU D 104      52.755  38.591  72.924  1.00 26.86           N  
ATOM   4721  CA  GLU D 104      51.700  38.210  72.002  1.00 31.22           C  
ATOM   4722  C   GLU D 104      50.334  38.326  72.691  1.00 27.27           C  
ATOM   4723  O   GLU D 104      49.392  38.796  72.081  1.00 26.64           O  
ATOM   4724  CB  GLU D 104      51.913  36.818  71.335  1.00 26.85           C  
ATOM   4725  CG  GLU D 104      50.811  36.549  70.229  1.00 28.89           C  
ATOM   4726  CD  GLU D 104      51.015  35.234  69.395  1.00 31.56           C  
ATOM   4727  OE1 GLU D 104      52.119  34.629  69.445  1.00 27.33           O  
ATOM   4728  OE2 GLU D 104      50.045  34.810  68.710  1.00 29.52           O  
ATOM   4729  N   LEU D 105      50.245  37.915  73.952  1.00 30.88           N  
ATOM   4730  CA  LEU D 105      49.044  38.179  74.785  1.00 30.44           C  
ATOM   4731  C   LEU D 105      48.637  39.660  74.787  1.00 28.46           C  
ATOM   4732  O   LEU D 105      47.471  40.001  74.541  1.00 26.64           O  
ATOM   4733  CB  LEU D 105      49.268  37.708  76.214  1.00 31.77           C  
ATOM   4734  CG  LEU D 105      49.467  36.199  76.497  1.00 35.36           C  
ATOM   4735  CD1 LEU D 105      49.287  35.916  77.993  1.00 34.14           C  
ATOM   4736  CD2 LEU D 105      48.542  35.301  75.718  1.00 36.91           C  
ATOM   4737  N   PHE D 106      49.594  40.553  75.039  1.00 30.05           N  
ATOM   4738  CA  PHE D 106      49.295  41.988  74.975  1.00 27.15           C  
ATOM   4739  C   PHE D 106      48.734  42.376  73.594  1.00 29.24           C  
ATOM   4740  O   PHE D 106      47.774  43.166  73.483  1.00 25.63           O  
ATOM   4741  CB  PHE D 106      50.502  42.864  75.318  1.00 24.32           C  
ATOM   4742  CG  PHE D 106      50.160  44.322  75.340  1.00 28.15           C  
ATOM   4743  CD1 PHE D 106      49.272  44.826  76.309  1.00 23.06           C  
ATOM   4744  CD2 PHE D 106      50.634  45.188  74.355  1.00 26.31           C  
ATOM   4745  CE1 PHE D 106      48.893  46.190  76.319  1.00 26.18           C  
ATOM   4746  CE2 PHE D 106      50.266  46.565  74.368  1.00 31.74           C  
ATOM   4747  CZ  PHE D 106      49.379  47.059  75.367  1.00 26.79           C  
ATOM   4748  N   GLU D 107      49.316  41.799  72.543  1.00 29.13           N  
ATOM   4749  CA  GLU D 107      48.917  42.117  71.163  1.00 30.22           C  
ATOM   4750  C   GLU D 107      47.489  41.621  70.899  1.00 24.41           C  
ATOM   4751  O   GLU D 107      46.698  42.324  70.295  1.00 28.20           O  
ATOM   4752  CB  GLU D 107      49.934  41.512  70.162  1.00 33.62           C  
ATOM   4753  CG  GLU D 107      50.012  42.198  68.810  1.00 36.02           C  
ATOM   4754  N   GLU D 108      47.164  40.407  71.357  1.00 25.05           N  
ATOM   4755  CA  GLU D 108      45.804  39.886  71.266  1.00 27.88           C  
ATOM   4756  C   GLU D 108      44.781  40.911  71.879  1.00 30.22           C  
ATOM   4757  O   GLU D 108      43.726  41.166  71.315  1.00 30.96           O  
ATOM   4758  CB  GLU D 108      45.707  38.555  72.008  1.00 26.57           C  
ATOM   4759  CG  GLU D 108      46.363  37.375  71.299  1.00 27.39           C  
ATOM   4760  CD  GLU D 108      45.997  36.018  71.922  1.00 27.87           C  
ATOM   4761  OE1 GLU D 108      44.863  35.850  72.476  1.00 26.51           O  
ATOM   4762  OE2 GLU D 108      46.838  35.102  71.837  1.00 31.57           O  
ATOM   4763  N   TYR D 109      45.149  41.499  73.025  1.00 30.08           N  
ATOM   4764  CA  TYR D 109      44.345  42.517  73.709  1.00 27.71           C  
ATOM   4765  C   TYR D 109      44.282  43.799  72.934  1.00 24.80           C  
ATOM   4766  O   TYR D 109      43.200  44.289  72.610  1.00 21.57           O  
ATOM   4767  CB  TYR D 109      44.915  42.821  75.110  1.00 31.07           C  
ATOM   4768  CG  TYR D 109      44.345  44.053  75.720  1.00 31.61           C  
ATOM   4769  CD1 TYR D 109      43.028  44.075  76.149  1.00 29.35           C  
ATOM   4770  CD2 TYR D 109      45.102  45.213  75.849  1.00 31.66           C  
ATOM   4771  CE1 TYR D 109      42.480  45.210  76.702  1.00 31.33           C  
ATOM   4772  CE2 TYR D 109      44.532  46.381  76.407  1.00 31.41           C  
ATOM   4773  CZ  TYR D 109      43.232  46.360  76.818  1.00 31.12           C  
ATOM   4774  OH  TYR D 109      42.640  47.474  77.372  1.00 35.72           O  
ATOM   4775  N   SER D 110      45.441  44.357  72.648  1.00 25.59           N  
ATOM   4776  CA  SER D 110      45.510  45.727  72.187  1.00 28.38           C  
ATOM   4777  C   SER D 110      44.953  45.872  70.777  1.00 30.28           C  
ATOM   4778  O   SER D 110      44.462  46.936  70.418  1.00 28.19           O  
ATOM   4779  CB  SER D 110      46.952  46.239  72.255  1.00 28.17           C  
ATOM   4780  OG  SER D 110      47.698  45.758  71.164  1.00 38.26           O  
ATOM   4781  N   LYS D 111      45.044  44.815  69.966  1.00 29.66           N  
ATOM   4782  CA  LYS D 111      44.469  44.858  68.628  1.00 28.21           C  
ATOM   4783  C   LYS D 111      43.253  43.961  68.503  1.00 26.74           C  
ATOM   4784  O   LYS D 111      42.796  43.754  67.406  1.00 33.16           O  
ATOM   4785  CB  LYS D 111      45.520  44.517  67.564  1.00 31.71           C  
ATOM   4786  CG  LYS D 111      46.821  45.326  67.648  1.00 31.17           C  
ATOM   4787  CD  LYS D 111      47.410  45.565  66.318  1.00 34.50           C  
ATOM   4788  CE  LYS D 111      48.916  45.859  66.330  1.00 37.89           C  
ATOM   4789  NZ  LYS D 111      49.345  46.997  67.132  1.00 37.09           N  
ATOM   4790  N   ALA D 112      42.725  43.460  69.629  1.00 25.48           N  
ATOM   4791  CA  ALA D 112      41.474  42.695  69.697  1.00 27.29           C  
ATOM   4792  C   ALA D 112      41.441  41.556  68.661  1.00 29.49           C  
ATOM   4793  O   ALA D 112      40.458  41.394  67.928  1.00 27.18           O  
ATOM   4794  CB  ALA D 112      40.231  43.622  69.534  1.00 26.47           C  
ATOM   4795  N   LEU D 113      42.525  40.773  68.625  1.00 29.40           N  
ATOM   4796  CA  LEU D 113      42.753  39.832  67.520  1.00 29.86           C  
ATOM   4797  C   LEU D 113      42.213  38.437  67.751  1.00 25.21           C  
ATOM   4798  O   LEU D 113      42.115  37.705  66.817  1.00 26.83           O  
ATOM   4799  CB  LEU D 113      44.238  39.789  67.150  1.00 27.70           C  
ATOM   4800  CG  LEU D 113      44.670  41.107  66.517  1.00 29.93           C  
ATOM   4801  CD1 LEU D 113      46.162  41.121  66.264  1.00 32.92           C  
ATOM   4802  CD2 LEU D 113      43.894  41.396  65.215  1.00 31.94           C  
ATOM   4803  N   THR D 114      41.870  38.102  68.991  1.00 25.63           N  
ATOM   4804  CA  THR D 114      41.329  36.803  69.362  1.00 23.11           C  
ATOM   4805  C   THR D 114      40.106  37.020  70.253  1.00 25.25           C  
ATOM   4806  O   THR D 114      39.886  38.133  70.719  1.00 23.22           O  
ATOM   4807  CB  THR D 114      42.347  35.977  70.178  1.00 25.75           C  
ATOM   4808  OG1 THR D 114      42.678  36.685  71.403  1.00 27.20           O  
ATOM   4809  CG2 THR D 114      43.606  35.686  69.348  1.00 21.14           C  
ATOM   4810  N   LEU D 115      39.339  35.958  70.510  1.00 21.87           N  
ATOM   4811  CA  LEU D 115      38.164  36.050  71.365  1.00 24.58           C  
ATOM   4812  C   LEU D 115      38.541  36.423  72.791  1.00 26.25           C  
ATOM   4813  O   LEU D 115      37.769  37.106  73.467  1.00 26.83           O  
ATOM   4814  CB  LEU D 115      37.371  34.729  71.397  1.00 26.38           C  
ATOM   4815  N   GLU D 116      39.716  35.950  73.222  1.00 24.98           N  
ATOM   4816  CA  GLU D 116      40.262  36.197  74.557  1.00 23.24           C  
ATOM   4817  C   GLU D 116      40.669  37.644  74.693  1.00 24.98           C  
ATOM   4818  O   GLU D 116      40.387  38.262  75.710  1.00 26.35           O  
ATOM   4819  CB  GLU D 116      41.464  35.305  74.833  1.00 20.26           C  
ATOM   4820  CG  GLU D 116      41.086  33.837  75.027  1.00 24.69           C  
ATOM   4821  CD  GLU D 116      40.748  33.044  73.721  1.00 24.22           C  
ATOM   4822  OE1 GLU D 116      41.223  33.344  72.621  1.00 22.79           O  
ATOM   4823  OE2 GLU D 116      40.007  32.081  73.833  1.00 30.60           O  
ATOM   4824  N   GLY D 117      41.333  38.179  73.672  1.00 26.01           N  
ATOM   4825  CA  GLY D 117      41.703  39.594  73.644  1.00 26.21           C  
ATOM   4826  C   GLY D 117      40.474  40.502  73.653  1.00 26.96           C  
ATOM   4827  O   GLY D 117      40.420  41.520  74.366  1.00 20.51           O  
ATOM   4828  N   GLN D 118      39.482  40.124  72.854  1.00 23.70           N  
ATOM   4829  CA  GLN D 118      38.230  40.842  72.775  1.00 21.02           C  
ATOM   4830  C   GLN D 118      37.474  40.873  74.098  1.00 21.71           C  
ATOM   4831  O   GLN D 118      36.922  41.883  74.465  1.00 26.53           O  
ATOM   4832  CB  GLN D 118      37.335  40.246  71.677  1.00 22.00           C  
ATOM   4833  CG  GLN D 118      37.829  40.578  70.310  1.00 24.57           C  
ATOM   4834  CD  GLN D 118      37.042  39.904  69.186  1.00 32.67           C  
ATOM   4835  OE1 GLN D 118      36.074  39.178  69.416  1.00 34.16           O  
ATOM   4836  NE2 GLN D 118      37.459  40.168  67.948  1.00 42.11           N  
ATOM   4837  N   LEU D 119      37.417  39.732  74.763  1.00 23.59           N  
ATOM   4838  CA  LEU D 119      36.779  39.602  76.043  1.00 25.76           C  
ATOM   4839  C   LEU D 119      37.360  40.603  77.076  1.00 26.85           C  
ATOM   4840  O   LEU D 119      36.621  41.242  77.789  1.00 20.66           O  
ATOM   4841  CB  LEU D 119      36.966  38.162  76.580  1.00 25.03           C  
ATOM   4842  CG  LEU D 119      36.219  37.910  77.912  1.00 24.64           C  
ATOM   4843  CD1 LEU D 119      34.768  38.157  77.704  1.00 29.64           C  
ATOM   4844  CD2 LEU D 119      36.408  36.539  78.438  1.00 25.52           C  
ATOM   4845  N   VAL D 120      38.690  40.667  77.157  1.00 25.18           N  
ATOM   4846  CA  VAL D 120      39.373  41.592  78.049  1.00 23.50           C  
ATOM   4847  C   VAL D 120      39.163  43.069  77.657  1.00 22.45           C  
ATOM   4848  O   VAL D 120      39.039  43.921  78.526  1.00 19.75           O  
ATOM   4849  CB  VAL D 120      40.875  41.241  78.149  1.00 19.12           C  
ATOM   4850  CG1 VAL D 120      41.623  42.210  79.062  1.00 19.93           C  
ATOM   4851  CG2 VAL D 120      41.016  39.846  78.712  1.00 17.80           C  
ATOM   4852  N   LYS D 121      39.142  43.366  76.363  1.00 21.59           N  
ATOM   4853  CA  LYS D 121      38.780  44.721  75.886  1.00 25.04           C  
ATOM   4854  C   LYS D 121      37.377  45.163  76.343  1.00 26.26           C  
ATOM   4855  O   LYS D 121      37.144  46.311  76.756  1.00 21.74           O  
ATOM   4856  CB  LYS D 121      38.896  44.789  74.344  1.00 28.51           C  
ATOM   4857  CG  LYS D 121      39.407  46.129  73.813  1.00 31.26           C  
ATOM   4858  N   ILE D 122      36.439  44.236  76.230  1.00 26.63           N  
ATOM   4859  CA  ILE D 122      35.090  44.392  76.746  1.00 30.28           C  
ATOM   4860  C   ILE D 122      35.021  44.606  78.275  1.00 26.31           C  
ATOM   4861  O   ILE D 122      34.337  45.519  78.743  1.00 26.50           O  
ATOM   4862  CB  ILE D 122      34.271  43.132  76.370  1.00 30.11           C  
ATOM   4863  CG1 ILE D 122      33.955  43.237  74.900  1.00 40.15           C  
ATOM   4864  CG2 ILE D 122      33.018  43.048  77.122  1.00 34.79           C  
ATOM   4865  CD1 ILE D 122      33.404  42.042  74.329  1.00 43.33           C  
ATOM   4866  N   ALA D 123      35.661  43.706  79.026  1.00 19.33           N  
ATOM   4867  CA  ALA D 123      35.753  43.810  80.478  1.00 22.54           C  
ATOM   4868  C   ALA D 123      36.403  45.153  80.897  1.00 22.83           C  
ATOM   4869  O   ALA D 123      35.968  45.834  81.850  1.00 21.97           O  
ATOM   4870  CB  ALA D 123      36.554  42.632  81.027  1.00 19.56           C  
ATOM   4871  N   ASP D 124      37.441  45.523  80.165  1.00 20.80           N  
ATOM   4872  CA  ASP D 124      38.110  46.798  80.348  1.00 25.03           C  
ATOM   4873  C   ASP D 124      37.196  48.070  80.201  1.00 23.09           C  
ATOM   4874  O   ASP D 124      37.184  48.983  81.094  1.00 14.30           O  
ATOM   4875  CB  ASP D 124      39.263  46.859  79.386  1.00 27.46           C  
ATOM   4876  CG  ASP D 124      40.209  47.896  79.731  1.00 29.10           C  
ATOM   4877  OD1 ASP D 124      40.866  47.738  80.750  1.00 34.58           O  
ATOM   4878  OD2 ASP D 124      40.285  48.882  79.002  1.00 32.36           O  
ATOM   4879  N   LYS D 125      36.439  48.110  79.100  1.00 20.70           N  
ATOM   4880  CA  LYS D 125      35.431  49.124  78.871  1.00 24.44           C  
ATOM   4881  C   LYS D 125      34.313  49.071  79.908  1.00 22.32           C  
ATOM   4882  O   LYS D 125      33.874  50.111  80.365  1.00 23.68           O  
ATOM   4883  CB  LYS D 125      34.827  49.030  77.439  1.00 27.28           C  
ATOM   4884  CG  LYS D 125      35.826  49.477  76.349  1.00 32.14           C  
ATOM   4885  CD  LYS D 125      35.493  48.899  74.957  1.00 34.72           C  
ATOM   4886  N   LEU D 126      33.833  47.871  80.240  1.00 21.60           N  
ATOM   4887  CA  LEU D 126      32.732  47.733  81.193  1.00 24.20           C  
ATOM   4888  C   LEU D 126      33.150  48.247  82.606  1.00 24.29           C  
ATOM   4889  O   LEU D 126      32.371  48.893  83.290  1.00 20.86           O  
ATOM   4890  CB  LEU D 126      32.247  46.284  81.252  1.00 24.88           C  
ATOM   4891  CG  LEU D 126      31.392  45.790  80.070  1.00 28.16           C  
ATOM   4892  CD1 LEU D 126      31.016  44.336  80.314  1.00 26.62           C  
ATOM   4893  CD2 LEU D 126      30.140  46.666  79.874  1.00 27.33           C  
ATOM   4894  N   ASP D 127      34.380  47.955  83.020  1.00 20.83           N  
ATOM   4895  CA  ASP D 127      34.881  48.484  84.276  1.00 23.66           C  
ATOM   4896  C   ASP D 127      34.842  50.023  84.280  1.00 23.56           C  
ATOM   4897  O   ASP D 127      34.409  50.617  85.238  1.00 21.02           O  
ATOM   4898  CB  ASP D 127      36.290  47.973  84.597  1.00 18.57           C  
ATOM   4899  CG  ASP D 127      36.896  48.665  85.810  1.00 21.23           C  
ATOM   4900  OD1 ASP D 127      36.473  48.332  86.936  1.00 19.65           O  
ATOM   4901  OD2 ASP D 127      37.788  49.541  85.630  1.00 18.16           O  
ATOM   4902  N   MET D 128      35.315  50.644  83.207  1.00 27.10           N  
ATOM   4903  CA  MET D 128      35.366  52.098  83.120  1.00 28.34           C  
ATOM   4904  C   MET D 128      33.969  52.730  83.070  1.00 23.80           C  
ATOM   4905  O   MET D 128      33.730  53.738  83.711  1.00 17.82           O  
ATOM   4906  CB  MET D 128      36.203  52.545  81.903  1.00 29.56           C  
ATOM   4907  CG  MET D 128      36.087  54.032  81.583  1.00 33.33           C  
ATOM   4908  SD  MET D 128      37.075  54.508  80.178  1.00 39.65           S  
ATOM   4909  CE  MET D 128      35.906  54.152  78.859  1.00 40.59           C  
ATOM   4910  N   ILE D 129      33.069  52.175  82.267  1.00 22.21           N  
ATOM   4911  CA  ILE D 129      31.684  52.649  82.228  1.00 22.05           C  
ATOM   4912  C   ILE D 129      30.986  52.513  83.593  1.00 18.82           C  
ATOM   4913  O   ILE D 129      30.298  53.424  84.074  1.00 19.62           O  
ATOM   4914  CB  ILE D 129      30.815  51.912  81.148  1.00 22.81           C  
ATOM   4915  CG1 ILE D 129      31.382  52.124  79.732  1.00 24.46           C  
ATOM   4916  CG2 ILE D 129      29.385  52.452  81.179  1.00 21.60           C  
ATOM   4917  CD1 ILE D 129      30.987  51.020  78.678  1.00 24.98           C  
ATOM   4918  N   ILE D 130      31.125  51.365  84.207  1.00 17.99           N  
ATOM   4919  CA  ILE D 130      30.509  51.159  85.470  1.00 18.65           C  
ATOM   4920  C   ILE D 130      31.169  52.045  86.539  1.00 19.69           C  
ATOM   4921  O   ILE D 130      30.485  52.554  87.399  1.00 16.45           O  
ATOM   4922  CB  ILE D 130      30.524  49.689  85.862  1.00 21.76           C  
ATOM   4923  CG1 ILE D 130      29.628  48.902  84.893  1.00 22.76           C  
ATOM   4924  CG2 ILE D 130      30.027  49.487  87.310  1.00 20.48           C  
ATOM   4925  CD1 ILE D 130      29.812  47.387  84.991  1.00 21.36           C  
ATOM   4926  N   GLN D 131      32.480  52.240  86.461  1.00 19.23           N  
ATOM   4927  CA  GLN D 131      33.168  53.105  87.399  1.00 17.63           C  
ATOM   4928  C   GLN D 131      32.697  54.540  87.254  1.00 16.02           C  
ATOM   4929  O   GLN D 131      32.560  55.242  88.261  1.00 13.97           O  
ATOM   4930  CB  GLN D 131      34.696  52.999  87.256  1.00 15.51           C  
ATOM   4931  CG  GLN D 131      35.491  53.706  88.358  1.00 15.81           C  
ATOM   4932  CD  GLN D 131      35.181  53.181  89.729  1.00 17.47           C  
ATOM   4933  OE1 GLN D 131      35.417  51.996  90.010  1.00 19.22           O  
ATOM   4934  NE2 GLN D 131      34.605  54.057  90.607  1.00 12.42           N  
ATOM   4935  N   ALA D 132      32.399  54.973  86.038  1.00 16.18           N  
ATOM   4936  CA  ALA D 132      31.912  56.370  85.807  1.00 20.55           C  
ATOM   4937  C   ALA D 132      30.548  56.564  86.446  1.00 21.16           C  
ATOM   4938  O   ALA D 132      30.290  57.602  87.059  1.00 22.17           O  
ATOM   4939  CB  ALA D 132      31.831  56.705  84.307  1.00 22.29           C  
ATOM   4940  N   TYR D 133      29.693  55.555  86.324  1.00 23.63           N  
ATOM   4941  CA  TYR D 133      28.407  55.526  87.037  1.00 25.11           C  
ATOM   4942  C   TYR D 133      28.645  55.615  88.566  1.00 21.89           C  
ATOM   4943  O   TYR D 133      27.957  56.332  89.262  1.00 20.41           O  
ATOM   4944  CB  TYR D 133      27.554  54.261  86.615  1.00 26.18           C  
ATOM   4945  CG  TYR D 133      26.492  53.824  87.632  1.00 28.01           C  
ATOM   4946  CD1 TYR D 133      25.214  54.420  87.671  1.00 27.97           C  
ATOM   4947  CD2 TYR D 133      26.771  52.809  88.542  1.00 26.41           C  
ATOM   4948  CE1 TYR D 133      24.247  54.010  88.610  1.00 27.38           C  
ATOM   4949  CE2 TYR D 133      25.855  52.404  89.477  1.00 26.27           C  
ATOM   4950  CZ  TYR D 133      24.579  52.992  89.523  1.00 31.37           C  
ATOM   4951  OH  TYR D 133      23.693  52.533  90.512  1.00 29.41           O  
ATOM   4952  N   GLU D 134      29.631  54.892  89.083  1.00 22.42           N  
ATOM   4953  CA  GLU D 134      29.919  54.923  90.524  1.00 20.20           C  
ATOM   4954  C   GLU D 134      30.421  56.304  91.018  1.00 20.25           C  
ATOM   4955  O   GLU D 134      29.997  56.804  92.054  1.00 20.51           O  
ATOM   4956  CB  GLU D 134      30.906  53.832  90.875  1.00 22.57           C  
ATOM   4957  CG  GLU D 134      30.280  52.453  90.739  1.00 24.16           C  
ATOM   4958  CD  GLU D 134      31.274  51.343  90.971  1.00 25.72           C  
ATOM   4959  OE1 GLU D 134      31.551  51.032  92.151  1.00 30.70           O  
ATOM   4960  OE2 GLU D 134      31.795  50.790  89.986  1.00 23.39           O  
ATOM   4961  N   TYR D 135      31.281  56.934  90.241  1.00 20.95           N  
ATOM   4962  CA  TYR D 135      31.770  58.255  90.578  1.00 19.11           C  
ATOM   4963  C   TYR D 135      30.676  59.318  90.424  1.00 20.82           C  
ATOM   4964  O   TYR D 135      30.654  60.250  91.186  1.00 21.60           O  
ATOM   4965  CB  TYR D 135      32.993  58.581  89.760  1.00 15.25           C  
ATOM   4966  CG  TYR D 135      34.270  57.883  90.214  1.00 18.20           C  
ATOM   4967  CD1 TYR D 135      34.556  57.633  91.577  1.00 14.48           C  
ATOM   4968  CD2 TYR D 135      35.228  57.479  89.265  1.00 17.72           C  
ATOM   4969  CE1 TYR D 135      35.749  56.947  91.957  1.00 13.37           C  
ATOM   4970  CE2 TYR D 135      36.414  56.880  89.649  1.00 13.13           C  
ATOM   4971  CZ  TYR D 135      36.674  56.615  90.979  1.00 11.95           C  
ATOM   4972  OH  TYR D 135      37.870  55.968  91.256  1.00 15.37           O  
ATOM   4973  N   GLU D 136      29.736  59.149  89.484  1.00 22.97           N  
ATOM   4974  CA  GLU D 136      28.539  60.009  89.454  1.00 23.86           C  
ATOM   4975  C   GLU D 136      27.701  59.913  90.747  1.00 21.77           C  
ATOM   4976  O   GLU D 136      27.245  60.904  91.252  1.00 23.39           O  
ATOM   4977  CB  GLU D 136      27.672  59.710  88.244  1.00 24.55           C  
ATOM   4978  CG  GLU D 136      28.298  60.165  86.961  1.00 30.65           C  
ATOM   4979  CD  GLU D 136      27.587  59.673  85.680  1.00 33.97           C  
ATOM   4980  OE1 GLU D 136      26.647  58.840  85.772  1.00 39.07           O  
ATOM   4981  OE2 GLU D 136      27.983  60.132  84.576  1.00 38.13           O  
ATOM   4982  N   LEU D 137      27.543  58.720  91.294  1.00 20.74           N  
ATOM   4983  CA  LEU D 137      26.843  58.546  92.561  1.00 24.82           C  
ATOM   4984  C   LEU D 137      27.491  59.301  93.750  1.00 26.39           C  
ATOM   4985  O   LEU D 137      26.798  59.716  94.672  1.00 24.80           O  
ATOM   4986  CB  LEU D 137      26.740  57.059  92.904  1.00 24.49           C  
ATOM   4987  CG  LEU D 137      25.781  56.213  92.046  1.00 26.74           C  
ATOM   4988  CD1 LEU D 137      25.825  54.798  92.518  1.00 26.69           C  
ATOM   4989  CD2 LEU D 137      24.364  56.728  92.136  1.00 28.03           C  
ATOM   4990  N   SER D 138      28.811  59.456  93.704  1.00 25.90           N  
ATOM   4991  CA  SER D 138      29.571  60.177  94.708  1.00 24.24           C  
ATOM   4992  C   SER D 138      29.836  61.628  94.362  1.00 20.93           C  
ATOM   4993  O   SER D 138      30.496  62.266  95.103  1.00 22.84           O  
ATOM   4994  CB  SER D 138      30.931  59.465  94.965  1.00 24.56           C  
ATOM   4995  OG  SER D 138      30.675  58.182  95.539  1.00 24.25           O  
ATOM   4996  N   GLY D 139      29.334  62.145  93.242  1.00 24.60           N  
ATOM   4997  CA  GLY D 139      29.372  63.577  92.988  1.00 21.56           C  
ATOM   4998  C   GLY D 139      29.763  64.068  91.607  1.00 21.89           C  
ATOM   4999  O   GLY D 139      29.466  65.217  91.249  1.00 24.01           O  
ATOM   5000  N   ALA D 140      30.411  63.241  90.801  1.00 19.53           N  
ATOM   5001  CA  ALA D 140      30.940  63.748  89.534  1.00 20.79           C  
ATOM   5002  C   ALA D 140      29.788  64.063  88.589  1.00 24.11           C  
ATOM   5003  O   ALA D 140      28.889  63.243  88.423  1.00 27.40           O  
ATOM   5004  CB  ALA D 140      31.902  62.739  88.915  1.00 18.02           C  
ATOM   5005  N   LYS D 141      29.806  65.247  87.978  1.00 24.10           N  
ATOM   5006  CA  LYS D 141      28.764  65.646  87.037  1.00 26.12           C  
ATOM   5007  C   LYS D 141      29.317  65.760  85.611  1.00 25.54           C  
ATOM   5008  O   LYS D 141      28.618  66.081  84.719  1.00 26.67           O  
ATOM   5009  CB  LYS D 141      28.100  66.969  87.493  1.00 30.11           C  
ATOM   5010  CG  LYS D 141      27.043  66.770  88.571  1.00 34.07           C  
ATOM   5011  CD  LYS D 141      27.328  67.571  89.866  1.00 40.41           C  
ATOM   5012  N   ASN D 142      30.586  65.460  85.409  1.00 26.23           N  
ATOM   5013  CA  ASN D 142      31.230  65.726  84.145  1.00 26.14           C  
ATOM   5014  C   ASN D 142      31.815  64.424  83.502  1.00 25.49           C  
ATOM   5015  O   ASN D 142      32.846  64.477  82.835  1.00 25.55           O  
ATOM   5016  CB  ASN D 142      32.319  66.794  84.387  1.00 25.66           C  
ATOM   5017  CG  ASN D 142      33.346  66.334  85.419  1.00 25.26           C  
ATOM   5018  OD1 ASN D 142      33.103  65.364  86.132  1.00 23.71           O  
ATOM   5019  ND2 ASN D 142      34.480  67.035  85.509  1.00 21.33           N  
ATOM   5020  N   LEU D 143      31.159  63.269  83.728  1.00 28.56           N  
ATOM   5021  CA  LEU D 143      31.686  61.963  83.253  1.00 30.40           C  
ATOM   5022  C   LEU D 143      30.854  61.297  82.148  1.00 32.30           C  
ATOM   5023  O   LEU D 143      31.015  60.092  81.889  1.00 30.66           O  
ATOM   5024  CB  LEU D 143      31.842  60.958  84.425  1.00 27.89           C  
ATOM   5025  CG  LEU D 143      32.639  61.370  85.663  1.00 26.62           C  
ATOM   5026  CD1 LEU D 143      32.692  60.249  86.655  1.00 26.92           C  
ATOM   5027  CD2 LEU D 143      34.074  61.854  85.351  1.00 27.07           C  
ATOM   5028  N   SER D 144      29.970  62.052  81.510  1.00 39.08           N  
ATOM   5029  CA  SER D 144      29.022  61.464  80.525  1.00 45.96           C  
ATOM   5030  C   SER D 144      29.739  60.870  79.314  1.00 45.07           C  
ATOM   5031  O   SER D 144      29.337  59.830  78.809  1.00 41.18           O  
ATOM   5032  CB  SER D 144      27.999  62.495  80.050  1.00 47.14           C  
ATOM   5033  OG  SER D 144      28.670  63.494  79.283  1.00 51.03           O  
ATOM   5034  N   GLU D 145      30.818  61.510  78.881  1.00 48.16           N  
ATOM   5035  CA  GLU D 145      31.627  60.971  77.782  1.00 54.02           C  
ATOM   5036  C   GLU D 145      32.173  59.540  78.043  1.00 54.29           C  
ATOM   5037  O   GLU D 145      32.421  58.800  77.090  1.00 54.07           O  
ATOM   5038  CB  GLU D 145      32.794  61.899  77.477  1.00 55.33           C  
ATOM   5039  CG  GLU D 145      33.902  61.788  78.492  1.00 58.58           C  
ATOM   5040  CD  GLU D 145      34.781  62.999  78.529  1.00 62.23           C  
ATOM   5041  OE1 GLU D 145      36.022  62.814  78.521  1.00 61.71           O  
ATOM   5042  OE2 GLU D 145      34.231  64.141  78.561  1.00 65.39           O  
ATOM   5043  N   PHE D 146      32.389  59.178  79.311  1.00 51.75           N  
ATOM   5044  CA  PHE D 146      32.760  57.811  79.655  1.00 50.45           C  
ATOM   5045  C   PHE D 146      31.517  56.941  79.594  1.00 51.01           C  
ATOM   5046  O   PHE D 146      31.633  55.747  79.348  1.00 53.63           O  
ATOM   5047  CB  PHE D 146      33.382  57.705  81.052  1.00 49.12           C  
ATOM   5048  CG  PHE D 146      34.639  58.459  81.203  1.00 48.31           C  
ATOM   5049  CD1 PHE D 146      35.817  57.964  80.700  1.00 50.95           C  
ATOM   5050  CD2 PHE D 146      34.656  59.679  81.850  1.00 48.43           C  
ATOM   5051  CE1 PHE D 146      37.012  58.692  80.834  1.00 52.03           C  
ATOM   5052  CE2 PHE D 146      35.825  60.392  81.992  1.00 47.29           C  
ATOM   5053  CZ  PHE D 146      36.999  59.905  81.482  1.00 50.17           C  
ATOM   5054  N   GLU D 157      32.105  42.623  68.457  1.00 43.55           N  
ATOM   5055  CA  GLU D 157      31.917  41.338  67.781  1.00 44.90           C  
ATOM   5056  C   GLU D 157      31.514  40.210  68.738  1.00 45.18           C  
ATOM   5057  O   GLU D 157      30.590  39.437  68.452  1.00 43.56           O  
ATOM   5058  CB  GLU D 157      33.185  40.929  67.037  1.00 45.17           C  
ATOM   5059  CG  GLU D 157      33.071  39.565  66.308  1.00 48.07           C  
ATOM   5060  N   ILE D 158      32.230  40.107  69.866  1.00 42.91           N  
ATOM   5061  CA  ILE D 158      31.984  39.054  70.883  1.00 39.92           C  
ATOM   5062  C   ILE D 158      30.796  39.492  71.734  1.00 35.83           C  
ATOM   5063  O   ILE D 158      30.276  38.742  72.544  1.00 39.24           O  
ATOM   5064  CB  ILE D 158      33.245  38.841  71.720  1.00 43.57           C  
ATOM   5065  CG1 ILE D 158      33.150  37.648  72.648  1.00 46.81           C  
ATOM   5066  CG2 ILE D 158      33.528  40.048  72.525  1.00 42.03           C  
ATOM   5067  CD1 ILE D 158      34.456  37.428  73.419  1.00 49.29           C  
ATOM   5068  N   SER D 159      30.393  40.735  71.521  1.00 35.01           N  
ATOM   5069  CA  SER D 159      29.249  41.330  72.128  1.00 36.12           C  
ATOM   5070  C   SER D 159      27.950  40.642  71.704  1.00 36.88           C  
ATOM   5071  O   SER D 159      26.953  40.719  72.427  1.00 36.44           O  
ATOM   5072  CB  SER D 159      29.215  42.816  71.727  1.00 41.11           C  
ATOM   5073  OG  SER D 159      29.519  42.989  70.328  1.00 43.39           O  
ATOM   5074  N   ARG D 160      27.938  39.967  70.543  1.00 36.79           N  
ATOM   5075  CA  ARG D 160      26.778  39.122  70.180  1.00 35.18           C  
ATOM   5076  C   ARG D 160      26.459  38.080  71.238  1.00 34.09           C  
ATOM   5077  O   ARG D 160      25.310  37.658  71.358  1.00 32.46           O  
ATOM   5078  CB  ARG D 160      26.947  38.445  68.800  1.00 37.24           C  
ATOM   5079  CG  ARG D 160      28.053  37.424  68.655  1.00 36.25           C  
ATOM   5080  CD  ARG D 160      28.228  37.038  67.170  1.00 40.13           C  
ATOM   5081  NE  ARG D 160      28.648  35.645  67.039  1.00 44.06           N  
ATOM   5082  CZ  ARG D 160      28.426  34.822  66.000  1.00 45.63           C  
ATOM   5083  NH1 ARG D 160      27.764  35.202  64.912  1.00 46.05           N  
ATOM   5084  NH2 ARG D 160      28.887  33.573  66.058  1.00 45.01           N  
ATOM   5085  N   TYR D 161      27.474  37.651  71.997  1.00 35.12           N  
ATOM   5086  CA  TYR D 161      27.264  36.691  73.102  1.00 34.64           C  
ATOM   5087  C   TYR D 161      26.991  37.308  74.461  1.00 33.68           C  
ATOM   5088  O   TYR D 161      26.788  36.562  75.438  1.00 33.15           O  
ATOM   5089  CB  TYR D 161      28.468  35.769  73.281  1.00 35.53           C  
ATOM   5090  CG  TYR D 161      29.023  35.166  72.025  1.00 33.68           C  
ATOM   5091  CD1 TYR D 161      28.285  34.271  71.258  1.00 34.71           C  
ATOM   5092  CD2 TYR D 161      30.305  35.468  71.629  1.00 32.48           C  
ATOM   5093  CE1 TYR D 161      28.855  33.695  70.089  1.00 35.46           C  
ATOM   5094  CE2 TYR D 161      30.866  34.923  70.492  1.00 34.22           C  
ATOM   5095  CZ  TYR D 161      30.152  34.040  69.732  1.00 34.24           C  
ATOM   5096  OH  TYR D 161      30.766  33.534  68.619  1.00 35.56           O  
ATOM   5097  N   LEU D 162      26.981  38.639  74.540  1.00 34.67           N  
ATOM   5098  CA  LEU D 162      26.967  39.319  75.827  1.00 35.65           C  
ATOM   5099  C   LEU D 162      25.907  40.396  75.879  1.00 39.51           C  
ATOM   5100  O   LEU D 162      26.078  41.383  76.584  1.00 37.56           O  
ATOM   5101  CB  LEU D 162      28.359  39.916  76.132  1.00 35.96           C  
ATOM   5102  CG  LEU D 162      29.595  38.988  76.171  1.00 33.65           C  
ATOM   5103  CD1 LEU D 162      30.845  39.844  76.211  1.00 35.16           C  
ATOM   5104  CD2 LEU D 162      29.572  38.030  77.350  1.00 32.77           C  
ATOM   5105  N   ARG D 163      24.788  40.173  75.175  1.00 40.20           N  
ATOM   5106  CA  ARG D 163      23.689  41.141  75.084  1.00 40.99           C  
ATOM   5107  C   ARG D 163      23.012  41.417  76.425  1.00 39.17           C  
ATOM   5108  O   ARG D 163      22.615  42.541  76.711  1.00 41.27           O  
ATOM   5109  CB  ARG D 163      22.613  40.646  74.089  1.00 43.28           C  
ATOM   5110  CG  ARG D 163      23.073  40.461  72.636  1.00 46.20           C  
ATOM   5111  CD  ARG D 163      23.404  41.787  71.958  1.00 48.13           C  
ATOM   5112  NE  ARG D 163      23.968  41.577  70.622  1.00 46.60           N  
ATOM   5113  CZ  ARG D 163      24.837  42.386  70.024  1.00 49.60           C  
ATOM   5114  NH1 ARG D 163      25.275  43.504  70.624  1.00 53.29           N  
ATOM   5115  NH2 ARG D 163      25.284  42.073  68.816  1.00 49.38           N  
ATOM   5116  N   GLU D 164      22.855  40.373  77.219  1.00 40.31           N  
ATOM   5117  CA  GLU D 164      22.267  40.460  78.556  1.00 43.84           C  
ATOM   5118  C   GLU D 164      22.999  41.490  79.478  1.00 44.45           C  
ATOM   5119  O   GLU D 164      22.381  42.433  79.970  1.00 41.89           O  
ATOM   5120  CB  GLU D 164      22.263  39.063  79.210  1.00 47.45           C  
ATOM   5121  CG  GLU D 164      21.373  37.971  78.485  1.00 51.79           C  
ATOM   5122  CD  GLU D 164      22.094  37.113  77.383  1.00 53.68           C  
ATOM   5123  OE1 GLU D 164      23.239  37.433  76.934  1.00 49.51           O  
ATOM   5124  OE2 GLU D 164      21.472  36.099  76.956  1.00 55.44           O  
ATOM   5125  N   ILE D 165      24.312  41.306  79.676  1.00 43.95           N  
ATOM   5126  CA  ILE D 165      25.113  42.183  80.535  1.00 42.67           C  
ATOM   5127  C   ILE D 165      25.250  43.578  79.924  1.00 44.17           C  
ATOM   5128  O   ILE D 165      25.228  44.571  80.633  1.00 42.56           O  
ATOM   5129  CB  ILE D 165      26.547  41.547  80.880  1.00 44.03           C  
ATOM   5130  CG1 ILE D 165      27.229  42.285  82.075  1.00 43.22           C  
ATOM   5131  CG2 ILE D 165      27.488  41.509  79.626  1.00 41.17           C  
ATOM   5132  N   ILE D 166      25.363  43.666  78.609  1.00 46.16           N  
ATOM   5133  CA  ILE D 166      25.448  44.973  77.973  1.00 48.94           C  
ATOM   5134  C   ILE D 166      24.189  45.821  78.273  1.00 50.47           C  
ATOM   5135  O   ILE D 166      24.314  47.009  78.554  1.00 50.47           O  
ATOM   5136  CB  ILE D 166      25.719  44.862  76.466  1.00 50.85           C  
ATOM   5137  CG1 ILE D 166      27.111  44.273  76.229  1.00 50.78           C  
ATOM   5138  CG2 ILE D 166      25.638  46.248  75.792  1.00 52.37           C  
ATOM   5139  CD1 ILE D 166      27.359  43.792  74.783  1.00 50.55           C  
ATOM   5140  N   GLU D 167      22.995  45.208  78.258  1.00 50.26           N  
ATOM   5141  CA  GLU D 167      21.749  45.943  78.576  1.00 50.05           C  
ATOM   5142  C   GLU D 167      21.513  46.181  80.092  1.00 47.64           C  
ATOM   5143  O   GLU D 167      20.928  47.188  80.467  1.00 50.29           O  
ATOM   5144  CB  GLU D 167      20.518  45.272  77.934  1.00 49.72           C  
ATOM   5145  N   GLU D 168      21.945  45.258  80.947  1.00 46.61           N  
ATOM   5146  CA  GLU D 168      21.969  45.492  82.384  1.00 47.48           C  
ATOM   5147  C   GLU D 168      22.736  46.781  82.730  1.00 51.75           C  
ATOM   5148  O   GLU D 168      22.322  47.564  83.628  1.00 54.87           O  
ATOM   5149  CB  GLU D 168      22.621  44.332  83.111  1.00 48.56           C  
ATOM   5150  CG  GLU D 168      21.682  43.235  83.529  1.00 52.23           C  
ATOM   5151  CD  GLU D 168      22.381  42.191  84.400  1.00 56.64           C  
ATOM   5152  OE1 GLU D 168      23.162  42.601  85.284  1.00 59.39           O  
ATOM   5153  OE2 GLU D 168      22.153  40.968  84.217  1.00 59.86           O  
ATOM   5154  N   VAL D 169      23.852  46.990  82.026  1.00 51.07           N  
ATOM   5155  CA  VAL D 169      24.666  48.188  82.180  1.00 50.93           C  
ATOM   5156  C   VAL D 169      23.903  49.414  81.651  1.00 53.24           C  
ATOM   5157  O   VAL D 169      23.777  50.404  82.368  1.00 53.80           O  
ATOM   5158  CB  VAL D 169      26.076  48.015  81.510  1.00 49.00           C  
ATOM   5159  CG1 VAL D 169      26.870  49.342  81.455  1.00 47.13           C  
ATOM   5160  CG2 VAL D 169      26.891  46.913  82.261  1.00 48.28           C  
ATOM   5161  N   ARG D 170      23.376  49.341  80.434  1.00 55.32           N  
ATOM   5162  CA  ARG D 170      22.568  50.437  79.871  1.00 60.76           C  
ATOM   5163  C   ARG D 170      21.450  50.920  80.834  1.00 62.96           C  
ATOM   5164  O   ARG D 170      21.325  52.110  81.112  1.00 66.53           O  
ATOM   5165  CB  ARG D 170      21.949  50.018  78.527  1.00 61.05           C  
ATOM   5166  N   ARG D 171      20.650  49.992  81.341  1.00 63.83           N  
ATOM   5167  CA  ARG D 171      19.614  50.324  82.306  1.00 64.10           C  
ATOM   5168  C   ARG D 171      20.174  51.225  83.421  1.00 64.66           C  
ATOM   5169  O   ARG D 171      20.674  50.745  84.439  1.00 65.91           O  
ATOM   5170  CB  ARG D 171      18.990  49.040  82.904  1.00 65.16           C  
ATOM   5171  CG  ARG D 171      18.019  48.275  81.964  1.00 63.69           C  
TER    5172      ARG D 171                                                      
END
MOLECULE T0470_2_100.pdb
ATOM      1  N   THR     2      54.420  27.522  88.035  1.00 67.73           N  
ATOM      2  CA  THR     2      53.108  27.380  87.344  1.00 69.65           C  
ATOM      3  C   THR     2      52.525  28.722  86.889  1.00 69.97           C  
ATOM      4  O   THR     2      52.981  29.793  87.306  1.00 70.58           O  
ATOM      5  CB  THR     2      52.070  26.669  88.248  1.00 70.47           C  
ATOM      6  OG1 THR     2      50.847  26.474  87.525  1.00 71.89           O  
ATOM      7  CG2 THR     2      51.777  27.494  89.491  1.00 72.01           C  
ATOM      8  N   LYS     3      51.513  28.656  86.023  1.00 69.74           N  
ATOM      9  CA  LYS     3      50.861  29.849  85.484  1.00 69.53           C  
ATOM     10  C   LYS     3      50.268  30.737  86.573  1.00 70.20           C  
ATOM     11  O   LYS     3      50.510  31.945  86.591  1.00 69.16           O  
ATOM     12  CB  LYS     3      49.782  29.428  84.482  1.00 67.78           C  
ATOM     13  CG  LYS     3      50.303  29.361  83.052  1.00 68.14           C  
ATOM     14  CD  LYS     3      49.618  28.289  82.210  1.00 68.04           C  
ATOM     15  CE  LYS     3      49.960  28.461  80.732  1.00 67.69           C  
ATOM     16  NZ  LYS     3      51.397  28.805  80.520  1.00 68.33           N  
ATOM     17  N   GLN     4      49.505  30.130  87.481  1.00 70.53           N  
ATOM     18  CA  GLN     4      48.886  30.864  88.569  1.00 70.32           C  
ATOM     19  C   GLN     4      49.929  31.629  89.343  1.00 70.52           C  
ATOM     20  O   GLN     4      49.650  32.691  89.886  1.00 70.49           O  
ATOM     21  CB  GLN     4      48.149  29.918  89.517  1.00 70.74           C  
ATOM     22  CG  GLN     4      47.408  30.606  90.679  1.00 69.51           C  
ATOM     23  CD  GLN     4      46.205  31.420  90.223  1.00 68.71           C  
ATOM     24  OE1 GLN     4      45.399  30.969  89.405  1.00 68.36           O  
ATOM     25  NE2 GLN     4      46.064  32.617  90.776  1.00 68.07           N  
ATOM     26  N   GLU     5      51.137  31.100  89.418  1.00 72.17           N  
ATOM     27  CA  GLU     5      52.161  31.829  90.151  1.00 74.75           C  
ATOM     28  C   GLU     5      52.585  33.043  89.329  1.00 74.42           C  
ATOM     29  O   GLU     5      53.116  34.009  89.867  1.00 74.73           O  
ATOM     30  CB  GLU     5      53.366  30.926  90.458  1.00 76.64           C  
ATOM     31  CG  GLU     5      53.047  29.773  91.424  1.00 78.98           C  
ATOM     32  CD  GLU     5      54.280  28.980  91.856  1.00 79.51           C  
ATOM     33  OE1 GLU     5      55.222  29.593  92.417  1.00 79.22           O  
ATOM     34  OE2 GLU     5      54.298  27.744  91.649  1.00 79.24           O  
ATOM     35  N   LYS     6      52.328  32.993  88.026  1.00 73.80           N  
ATOM     36  CA  LYS     6      52.683  34.095  87.143  1.00 73.49           C  
ATOM     37  C   LYS     6      51.562  35.126  87.171  1.00 72.47           C  
ATOM     38  O   LYS     6      51.789  36.313  87.420  1.00 71.47           O  
ATOM     39  CB  LYS     6      52.922  33.561  85.727  1.00 75.15           C  
ATOM     40  CG  LYS     6      53.997  32.466  85.693  1.00 76.88           C  
ATOM     41  CD  LYS     6      54.449  32.067  84.283  1.00 76.71           C  
ATOM     42  CE  LYS     6      55.567  31.015  84.358  1.00 75.99           C  
ATOM     43  NZ  LYS     6      56.007  30.494  83.030  1.00 75.46           N  
ATOM     44  N   ILE     7      50.344  34.662  86.925  1.00 72.48           N  
ATOM     45  CA  ILE     7      49.190  35.538  86.961  1.00 72.23           C  
ATOM     46  C   ILE     7      49.228  36.208  88.335  1.00 72.32           C  
ATOM     47  O   ILE     7      48.704  37.300  88.502  1.00 73.73           O  
ATOM     48  CB  ILE     7      47.868  34.730  86.768  1.00 70.53           C  
ATOM     49  CG1 ILE     7      46.677  35.665  86.607  1.00 71.42           C  
ATOM     50  CG2 ILE     7      47.591  33.867  87.974  1.00 69.54           C  
ATOM     51  CD1 ILE     7      45.974  36.012  87.908  1.00 69.78           C  
ATOM     52  N   GLU     8      49.867  35.568  89.314  1.00 73.67           N  
ATOM     53  CA  GLU     8      49.958  36.157  90.650  1.00 74.45           C  
ATOM     54  C   GLU     8      51.022  37.243  90.738  1.00 74.03           C  
ATOM     55  O   GLU     8      50.756  38.341  91.224  1.00 75.27           O  
ATOM     56  CB  GLU     8      50.273  35.100  91.719  1.00 73.53           C  
ATOM     57  CG  GLU     8      49.055  34.457  92.367  1.00 75.26           C  
ATOM     58  CD  GLU     8      49.396  33.705  93.653  1.00 76.05           C  
ATOM     59  OE1 GLU     8      48.502  33.009  94.197  1.00 73.33           O  
ATOM     60  OE2 GLU     8      50.553  33.824  94.123  1.00 76.36           O  
ATOM     61  N   LYS     9      52.229  36.936  90.275  1.00 73.00           N  
ATOM     62  CA  LYS     9      53.322  37.894  90.358  1.00 72.14           C  
ATOM     63  C   LYS     9      53.089  39.085  89.445  1.00 72.09           C  
ATOM     64  O   LYS     9      53.622  40.178  89.668  1.00 70.96           O  
ATOM     65  CB  LYS     9      54.642  37.225  90.000  1.00 72.09           C  
ATOM     66  CG  LYS     9      55.819  37.867  90.700  1.00 72.17           C  
ATOM     67  CD  LYS     9      55.863  37.465  92.169  1.00 70.32           C  
ATOM     68  CE  LYS     9      56.739  38.411  92.991  1.00 69.14           C  
ATOM     69  NZ  LYS     9      56.059  39.713  93.280  1.00 66.21           N  
ATOM     70  N   THR    10      52.286  38.858  88.411  1.00 72.36           N  
ATOM     71  CA  THR    10      51.944  39.896  87.451  1.00 71.97           C  
ATOM     72  C   THR    10      50.982  40.874  88.183  1.00 71.19           C  
ATOM     73  O   THR    10      51.018  42.083  87.945  1.00 70.11           O  
ATOM     74  CB  THR    10      51.312  39.235  86.168  1.00 71.23           C  
ATOM     75  OG1 THR    10      51.643  40.001  85.000  1.00 69.88           O  
ATOM     76  CG2 THR    10      49.812  39.128  86.308  1.00 71.51           C  
ATOM     77  N   ILE    11      50.161  40.336  89.093  1.00 70.44           N  
ATOM     78  CA  ILE    11      49.219  41.124  89.904  1.00 69.72           C  
ATOM     79  C   ILE    11      50.035  42.057  90.766  1.00 71.16           C  
ATOM     80  O   ILE    11      49.551  43.080  91.257  1.00 71.13           O  
ATOM     81  CB  ILE    11      48.388  40.242  90.871  1.00 68.77           C  
ATOM     82  CG1 ILE    11      47.388  39.417  90.081  1.00 67.51           C  
ATOM     83  CG2 ILE    11      47.668  41.108  91.920  1.00 66.60           C  
ATOM     84  CD1 ILE    11      46.560  38.495  90.938  1.00 66.89           C  
ATOM     85  N   THR    12      51.283  41.681  90.970  1.00 72.51           N  
ATOM     86  CA  THR    12      52.155  42.500  91.759  1.00 73.91           C  
ATOM     87  C   THR    12      52.815  43.476  90.813  1.00 74.94           C  
ATOM     88  O   THR    12      53.055  44.622  91.173  1.00 75.82           O  
ATOM     89  CB  THR    12      53.201  41.642  92.473  1.00 75.30           C  
ATOM     90  OG1 THR    12      52.538  40.717  93.350  1.00 75.75           O  
ATOM     91  CG2 THR    12      54.145  42.526  93.284  1.00 76.45           C  
ATOM     92  N   PHE    13      53.071  43.034  89.586  1.00 75.86           N  
ATOM     93  CA  PHE    13      53.711  43.899  88.592  1.00 77.87           C  
ATOM     94  C   PHE    13      52.903  45.169  88.303  1.00 79.87           C  
ATOM     95  O   PHE    13      53.467  46.265  88.185  1.00 80.16           O  
ATOM     96  CB  PHE    13      53.940  43.127  87.291  1.00 76.60           C  
ATOM     97  CG  PHE    13      54.523  43.959  86.180  1.00 75.56           C  
ATOM     98  CD1 PHE    13      53.743  44.325  85.086  1.00 75.53           C  
ATOM     99  CD2 PHE    13      55.856  44.359  86.216  1.00 74.71           C  
ATOM    100  CE1 PHE    13      54.279  45.077  84.036  1.00 73.94           C  
ATOM    101  CE2 PHE    13      56.403  45.111  85.172  1.00 73.82           C  
ATOM    102  CZ  PHE    13      55.608  45.468  84.079  1.00 73.79           C  
ATOM    103  N   VAL    14      51.587  45.018  88.190  1.00 80.78           N  
ATOM    104  CA  VAL    14      50.717  46.147  87.927  1.00 81.21           C  
ATOM    105  C   VAL    14      50.497  46.914  89.220  1.00 83.76           C  
ATOM    106  O   VAL    14      50.582  48.134  89.241  1.00 85.04           O  
ATOM    107  CB  VAL    14      49.372  45.672  87.361  1.00 79.40           C  
ATOM    108  CG1 VAL    14      48.451  46.851  87.134  1.00 78.11           C  
ATOM    109  CG2 VAL    14      49.604  44.926  86.069  1.00 78.07           C  
ATOM    110  N   LYS    15      50.238  46.195  90.305  1.00 86.53           N  
ATOM    111  CA  LYS    15      50.010  46.838  91.594  1.00 89.42           C  
ATOM    112  C   LYS    15      51.136  47.797  91.974  1.00 92.04           C  
ATOM    113  O   LYS    15      50.909  48.804  92.650  1.00 91.87           O  
ATOM    114  CB  LYS    15      49.840  45.780  92.686  1.00 88.26           C  
ATOM    115  CG  LYS    15      48.424  45.229  92.793  1.00 87.49           C  
ATOM    116  CD  LYS    15      47.453  46.298  93.274  1.00 87.53           C  
ATOM    117  CE  LYS    15      46.640  45.797  94.462  1.00 87.66           C  
ATOM    118  NZ  LYS    15      45.830  46.861  95.134  1.00 86.79           N  
ATOM    119  N   HIS    16      52.344  47.486  91.518  1.00 95.20           N  
ATOM    120  CA  HIS    16      53.515  48.301  91.808  1.00 98.70           C  
ATOM    121  C   HIS    16      53.665  49.487  90.861  1.00 99.11           C  
ATOM    122  O   HIS    16      53.684  50.642  91.292  1.00 99.40           O  
ATOM    123  CB  HIS    16      54.783  47.437  91.756  1.00101.86           C  
ATOM    124  CG  HIS    16      55.481  47.306  93.076  1.00105.49           C  
ATOM    125  ND1 HIS    16      54.917  46.664  94.161  1.00106.97           N  
ATOM    126  CD2 HIS    16      56.685  47.762  93.496  1.00106.64           C  
ATOM    127  CE1 HIS    16      55.743  46.731  95.190  1.00107.92           C  
ATOM    128  NE2 HIS    16      56.824  47.394  94.814  1.00107.88           N  
ATOM    129  N   ILE    17      53.778  49.202  89.569  1.00 99.51           N  
ATOM    130  CA  ILE    17      53.945  50.257  88.577  1.00100.14           C  
ATOM    131  C   ILE    17      52.919  51.375  88.778  1.00100.65           C  
ATOM    132  O   ILE    17      53.162  52.521  88.400  1.00101.20           O  
ATOM    133  CB  ILE    17      53.827  49.695  87.139  1.00 99.75           C  
ATOM    134  CG1 ILE    17      54.322  50.731  86.138  1.00 99.34           C  
ATOM    135  CG2 ILE    17      52.386  49.319  86.835  1.00 99.68           C  
ATOM    136  CD1 ILE    17      55.770  51.105  86.326  1.00 99.26           C  
ATOM    137  N   LEU    18      51.780  51.040  89.380  1.00101.00           N  
ATOM    138  CA  LEU    18      50.732  52.024  89.637  1.00100.89           C  
ATOM    139  C   LEU    18      51.122  52.918  90.806  1.00101.50           C  
ATOM    140  O   LEU    18      50.451  53.906  91.094  1.00102.48           O  
ATOM    141  CB  LEU    18      49.396  51.330  89.947  1.00 99.29           C  
ATOM    142  CG  LEU    18      48.439  50.949  88.809  1.00 97.40           C  
ATOM    143  CD1 LEU    18      47.333  50.051  89.330  1.00 96.41           C  
ATOM    144  CD2 LEU    18      47.845  52.200  88.206  1.00 96.79           C  
ATOM    145  N   GLU    19      52.203  52.573  91.489  1.00101.98           N  
ATOM    146  CA  GLU    19      52.628  53.378  92.618  1.00103.29           C  
ATOM    147  C   GLU    19      53.678  54.398  92.190  1.00104.06           C  
ATOM    148  O   GLU    19      53.668  55.543  92.653  1.00104.54           O  
ATOM    149  CB  GLU    19      53.181  52.488  93.722  1.00103.20           C  
ATOM    150  CG  GLU    19      53.522  53.232  94.990  1.00103.43           C  
ATOM    151  CD  GLU    19      54.278  52.362  95.961  1.00104.06           C  
ATOM    152  OE1 GLU    19      55.462  52.057  95.693  1.00103.95           O  
ATOM    153  OE2 GLU    19      53.684  51.973  96.987  1.00104.64           O  
ATOM    154  N   LYS    20      54.579  53.988  91.300  1.00104.46           N  
ATOM    155  CA  LYS    20      55.623  54.888  90.812  1.00104.68           C  
ATOM    156  C   LYS    20      55.049  56.070  90.029  1.00104.66           C  
ATOM    157  O   LYS    20      55.796  56.822  89.401  1.00104.93           O  
ATOM    158  CB  LYS    20      56.616  54.142  89.910  1.00104.64           C  
ATOM    159  CG  LYS    20      57.659  53.292  90.629  1.00105.42           C  
ATOM    160  CD  LYS    20      57.151  51.896  90.962  1.00105.46           C  
ATOM    161  CE  LYS    20      58.321  50.946  91.197  1.00105.42           C  
ATOM    162  NZ  LYS    20      57.901  49.517  91.263  1.00104.88           N  
ATOM    163  N   ASP    21      53.731  56.236  90.059  1.00104.17           N  
ATOM    164  CA  ASP    21      53.103  57.338  89.337  1.00104.08           C  
ATOM    165  C   ASP    21      51.638  57.467  89.721  1.00102.94           C  
ATOM    166  O   ASP    21      51.298  57.504  90.908  1.00102.07           O  
ATOM    167  CB  ASP    21      53.222  57.118  87.817  1.00105.75           C  
ATOM    168  CG  ASP    21      52.880  58.371  87.003  1.00107.30           C  
ATOM    169  OD1 ASP    21      52.908  58.292  85.751  1.00108.74           O  
ATOM    170  OD2 ASP    21      52.592  59.431  87.609  1.00106.97           O  
ATOM    171  N   ALA    22      50.789  57.527  88.695  1.00101.55           N  
ATOM    172  CA  ALA    22      49.342  57.663  88.831  1.00 99.78           C  
ATOM    173  C   ALA    22      48.850  57.483  90.258  1.00 98.72           C  
ATOM    174  O   ALA    22      48.964  58.387  91.095  1.00 97.73           O  
ATOM    175  CB  ALA    22      48.637  56.669  87.906  1.00 98.99           C  
ATOM    176  N   SER    23      48.305  56.304  90.526  1.00 97.73           N  
ATOM    177  CA  SER    23      47.781  55.983  91.844  1.00 96.67           C  
ATOM    178  C   SER    23      47.405  54.521  91.962  1.00 93.94           C  
ATOM    179  O   SER    23      46.808  53.941  91.052  1.00 93.15           O  
ATOM    180  CB  SER    23      46.544  56.831  92.150  1.00 98.93           C  
ATOM    181  OG  SER    23      45.855  56.317  93.279  1.00101.01           O  
ATOM    182  N   GLY    24      47.747  53.934  93.100  1.00 91.17           N  
ATOM    183  CA  GLY    24      47.416  52.547  93.324  1.00 88.31           C  
ATOM    184  C   GLY    24      45.926  52.425  93.538  1.00 85.81           C  
ATOM    185  O   GLY    24      45.453  51.472  94.161  1.00 85.71           O  
ATOM    186  N   HIS    25      45.175  53.395  93.032  1.00 83.24           N  
ATOM    187  CA  HIS    25      43.738  53.342  93.195  1.00 81.98           C  
ATOM    188  C   HIS    25      43.058  52.852  91.917  1.00 80.44           C  
ATOM    189  O   HIS    25      41.926  52.355  91.961  1.00 79.67           O  
ATOM    190  CB  HIS    25      43.201  54.706  93.633  1.00 83.23           C  
ATOM    191  CG  HIS    25      41.775  54.670  94.088  1.00 84.88           C  
ATOM    192  ND1 HIS    25      41.314  53.769  95.025  1.00 85.42           N  
ATOM    193  CD2 HIS    25      40.702  55.406  93.714  1.00 84.94           C  
ATOM    194  CE1 HIS    25      40.018  53.948  95.204  1.00 85.70           C  
ATOM    195  NE2 HIS    25      39.622  54.935  94.420  1.00 85.98           N  
ATOM    196  N   ASP    26      43.757  52.958  90.784  1.00 79.12           N  
ATOM    197  CA  ASP    26      43.212  52.475  89.503  1.00 77.77           C  
ATOM    198  C   ASP    26      43.214  50.945  89.471  1.00 76.08           C  
ATOM    199  O   ASP    26      42.777  50.341  88.491  1.00 75.82           O  
ATOM    200  CB  ASP    26      44.034  52.977  88.307  1.00 77.40           C  
ATOM    201  CG  ASP    26      43.863  54.456  88.058  1.00 77.10           C  
ATOM    202  OD1 ASP    26      42.700  54.928  87.991  1.00 76.65           O  
ATOM    203  OD2 ASP    26      44.898  55.146  87.912  1.00 75.69           O  
ATOM    204  N   TRP    27      43.728  50.333  90.537  1.00 73.47           N  
ATOM    205  CA  TRP    27      43.779  48.888  90.635  1.00 70.85           C  
ATOM    206  C   TRP    27      42.388  48.305  90.787  1.00 68.98           C  
ATOM    207  O   TRP    27      42.028  47.349  90.096  1.00 70.15           O  
ATOM    208  CB  TRP    27      44.649  48.432  91.817  1.00 71.69           C  
ATOM    209  CG  TRP    27      44.241  47.064  92.346  1.00 73.38           C  
ATOM    210  CD1 TRP    27      43.473  46.804  93.458  1.00 74.39           C  
ATOM    211  CD2 TRP    27      44.455  45.796  91.714  1.00 73.53           C  
ATOM    212  NE1 TRP    27      43.191  45.462  93.549  1.00 73.85           N  
ATOM    213  CE2 TRP    27      43.783  44.819  92.494  1.00 74.77           C  
ATOM    214  CE3 TRP    27      45.143  45.388  90.567  1.00 72.74           C  
ATOM    215  CZ2 TRP    27      43.781  43.459  92.155  1.00 75.30           C  
ATOM    216  CZ3 TRP    27      45.139  44.037  90.231  1.00 74.15           C  
ATOM    217  CH2 TRP    27      44.463  43.089  91.024  1.00 74.79           C  
ATOM    218  N   TYR    28      41.596  48.873  91.687  1.00 65.51           N  
ATOM    219  CA  TYR    28      40.252  48.347  91.912  1.00 62.28           C  
ATOM    220  C   TYR    28      39.476  48.235  90.598  1.00 58.54           C  
ATOM    221  O   TYR    28      38.558  47.439  90.498  1.00 56.72           O  
ATOM    222  CB  TYR    28      39.515  49.208  92.951  1.00 64.73           C  
ATOM    223  CG  TYR    28      40.224  49.245  94.303  1.00 67.03           C  
ATOM    224  CD1 TYR    28      41.480  49.853  94.444  1.00 68.58           C  
ATOM    225  CD2 TYR    28      39.659  48.637  95.433  1.00 67.35           C  
ATOM    226  CE1 TYR    28      42.156  49.849  95.674  1.00 69.21           C  
ATOM    227  CE2 TYR    28      40.326  48.632  96.666  1.00 67.81           C  
ATOM    228  CZ  TYR    28      41.570  49.238  96.774  1.00 68.84           C  
ATOM    229  OH  TYR    28      42.228  49.226  97.980  1.00 70.91           O  
ATOM    230  N   HIS    29      39.866  49.016  89.593  1.00 55.40           N  
ATOM    231  CA  HIS    29      39.227  48.949  88.287  1.00 53.42           C  
ATOM    232  C   HIS    29      39.777  47.765  87.513  1.00 51.44           C  
ATOM    233  O   HIS    29      39.034  47.009  86.902  1.00 49.77           O  
ATOM    234  CB  HIS    29      39.485  50.221  87.475  1.00 55.32           C  
ATOM    235  CG  HIS    29      39.470  50.003  85.984  1.00 56.65           C  
ATOM    236  ND1 HIS    29      38.372  49.514  85.306  1.00 57.67           N  
ATOM    237  CD2 HIS    29      40.417  50.231  85.041  1.00 56.45           C  
ATOM    238  CE1 HIS    29      38.640  49.456  84.010  1.00 56.41           C  
ATOM    239  NE2 HIS    29      39.874  49.886  83.823  1.00 56.73           N  
ATOM    240  N   ILE    30      41.101  47.649  87.518  1.00 51.15           N  
ATOM    241  CA  ILE    30      41.801  46.572  86.828  1.00 51.20           C  
ATOM    242  C   ILE    30      41.229  45.238  87.300  1.00 53.62           C  
ATOM    243  O   ILE    30      40.860  44.378  86.488  1.00 53.68           O  
ATOM    244  CB  ILE    30      43.324  46.517  87.154  1.00 48.66           C  
ATOM    245  CG1 ILE    30      43.969  47.897  87.045  1.00 44.66           C  
ATOM    246  CG2 ILE    30      43.995  45.513  86.211  1.00 48.04           C  
ATOM    247  CD1 ILE    30      44.237  48.358  85.653  1.00 43.24           C  
ATOM    248  N   ARG    31      41.175  45.061  88.622  1.00 54.08           N  
ATOM    249  CA  ARG    31      40.676  43.817  89.194  1.00 54.15           C  
ATOM    250  C   ARG    31      39.234  43.543  88.788  1.00 52.06           C  
ATOM    251  O   ARG    31      38.924  42.494  88.229  1.00 51.50           O  
ATOM    252  CB  ARG    31      40.805  43.823  90.725  1.00 56.17           C  
ATOM    253  CG  ARG    31      40.390  42.491  91.340  1.00 60.09           C  
ATOM    254  CD  ARG    31      40.510  42.471  92.856  1.00 63.32           C  
ATOM    255  NE  ARG    31      39.691  43.495  93.505  1.00 65.45           N  
ATOM    256  CZ  ARG    31      39.502  43.561  94.823  1.00 66.81           C  
ATOM    257  NH1 ARG    31      40.069  42.659  95.621  1.00 66.56           N  
ATOM    258  NH2 ARG    31      38.759  44.528  95.351  1.00 65.71           N  
ATOM    259  N   ARG    32      38.358  44.492  89.071  1.00 51.28           N  
ATOM    260  CA  ARG    32      36.951  44.360  88.729  1.00 50.62           C  
ATOM    261  C   ARG    32      36.765  43.820  87.312  1.00 51.83           C  
ATOM    262  O   ARG    32      35.852  43.041  87.057  1.00 51.50           O  
ATOM    263  CB  ARG    32      36.276  45.712  88.846  1.00 48.27           C  
ATOM    264  CG  ARG    32      35.011  45.680  89.608  1.00 46.09           C  
ATOM    265  CD  ARG    32      34.328  47.014  89.485  1.00 47.69           C  
ATOM    266  NE  ARG    32      35.049  48.077  90.169  1.00 47.67           N  
ATOM    267  CZ  ARG    32      35.808  48.993  89.578  1.00 47.94           C  
ATOM    268  NH1 ARG    32      36.414  49.916  90.319  1.00 47.18           N  
ATOM    269  NH2 ARG    32      35.957  48.996  88.259  1.00 49.59           N  
ATOM    270  N   VAL    33      37.632  44.239  86.394  1.00 53.39           N  
ATOM    271  CA  VAL    33      37.567  43.781  85.003  1.00 54.19           C  
ATOM    272  C   VAL    33      38.111  42.351  84.934  1.00 55.41           C  
ATOM    273  O   VAL    33      37.501  41.474  84.322  1.00 54.30           O  
ATOM    274  CB  VAL    33      38.413  44.687  84.050  1.00 53.90           C  
ATOM    275  CG1 VAL    33      38.346  44.162  82.624  1.00 51.59           C  
ATOM    276  CG2 VAL    33      37.901  46.114  84.100  1.00 53.88           C  
ATOM    277  N   HIS    34      39.264  42.135  85.572  1.00 56.32           N  
ATOM    278  CA  HIS    34      39.923  40.826  85.620  1.00 55.84           C  
ATOM    279  C   HIS    34      38.996  39.755  86.217  1.00 56.94           C  
ATOM    280  O   HIS    34      38.687  38.754  85.561  1.00 56.34           O  
ATOM    281  CB  HIS    34      41.224  40.912  86.439  1.00 54.06           C  
ATOM    282  CG  HIS    34      41.802  39.575  86.794  1.00 52.65           C  
ATOM    283  ND1 HIS    34      41.877  38.535  85.894  1.00 50.77           N  
ATOM    284  CD2 HIS    34      42.330  39.108  87.952  1.00 52.11           C  
ATOM    285  CE1 HIS    34      42.424  37.485  86.480  1.00 50.16           C  
ATOM    286  NE2 HIS    34      42.708  37.805  87.728  1.00 50.45           N  
ATOM    287  N   LYS    35      38.549  39.958  87.455  1.00 56.59           N  
ATOM    288  CA  LYS    35      37.659  38.985  88.065  1.00 55.98           C  
ATOM    289  C   LYS    35      36.457  38.761  87.151  1.00 56.88           C  
ATOM    290  O   LYS    35      35.891  37.674  87.089  1.00 56.33           O  
ATOM    291  CB  LYS    35      37.201  39.472  89.439  1.00 53.59           C  
ATOM    292  CG  LYS    35      38.334  39.690  90.416  1.00 50.94           C  
ATOM    293  CD  LYS    35      37.800  40.159  91.759  1.00 50.35           C  
ATOM    294  CE  LYS    35      37.179  39.030  92.574  1.00 48.14           C  
ATOM    295  NZ  LYS    35      38.181  38.374  93.467  1.00 47.39           N  
ATOM    296  N   MET    36      36.091  39.803  86.424  1.00 59.10           N  
ATOM    297  CA  MET    36      34.960  39.753  85.511  1.00 62.62           C  
ATOM    298  C   MET    36      35.278  38.960  84.233  1.00 61.88           C  
ATOM    299  O   MET    36      34.404  38.286  83.671  1.00 62.26           O  
ATOM    300  CB  MET    36      34.539  41.187  85.171  1.00 67.04           C  
ATOM    301  CG  MET    36      33.169  41.333  84.535  1.00 72.36           C  
ATOM    302  SD  MET    36      32.234  42.926  85.147  1.00 81.64          SE  
ATOM    303  CE  MET    36      33.734  44.163  85.380  1.00 77.97           C  
ATOM    304  N   ALA    37      36.527  39.046  83.780  1.00 60.52           N  
ATOM    305  CA  ALA    37      36.968  38.332  82.585  1.00 58.25           C  
ATOM    306  C   ALA    37      37.003  36.852  82.909  1.00 56.97           C  
ATOM    307  O   ALA    37      36.825  36.009  82.026  1.00 55.56           O  
ATOM    308  CB  ALA    37      38.343  38.805  82.164  1.00 59.39           C  
ATOM    309  N   ILE    38      37.249  36.540  84.179  1.00 55.28           N  
ATOM    310  CA  ILE    38      37.252  35.153  84.601  1.00 54.56           C  
ATOM    311  C   ILE    38      35.823  34.652  84.444  1.00 55.34           C  
ATOM    312  O   ILE    38      35.507  33.926  83.510  1.00 55.56           O  
ATOM    313  CB  ILE    38      37.623  34.976  86.078  1.00 53.58           C  
ATOM    314  CG1 ILE    38      39.065  35.405  86.320  1.00 52.95           C  
ATOM    315  CG2 ILE    38      37.404  33.521  86.479  1.00 52.78           C  
ATOM    316  CD1 ILE    38      40.072  34.576  85.600  1.00 52.24           C  
ATOM    317  N   SER    39      34.959  35.068  85.359  1.00 55.32           N  
ATOM    318  CA  SER    39      33.573  34.645  85.344  1.00 56.07           C  
ATOM    319  C   SER    39      32.968  34.566  83.957  1.00 56.48           C  
ATOM    320  O   SER    39      32.089  33.741  83.699  1.00 55.65           O  
ATOM    321  CB  SER    39      32.749  35.572  86.226  1.00 56.50           C  
ATOM    322  OG  SER    39      33.229  35.508  87.550  1.00 59.84           O  
ATOM    323  N   LEU    40      33.451  35.419  83.064  1.00 57.31           N  
ATOM    324  CA  LEU    40      32.960  35.450  81.693  1.00 59.67           C  
ATOM    325  C   LEU    40      33.495  34.249  80.879  1.00 61.86           C  
ATOM    326  O   LEU    40      32.736  33.576  80.169  1.00 61.73           O  
ATOM    327  CB  LEU    40      33.367  36.778  81.046  1.00 59.16           C  
ATOM    328  CG  LEU    40      32.337  37.625  80.294  1.00 58.09           C  
ATOM    329  CD1 LEU    40      31.103  37.876  81.142  1.00 57.41           C  
ATOM    330  CD2 LEU    40      32.994  38.935  79.902  1.00 55.70           C  
ATOM    331  N   SER    41      34.795  33.970  80.996  1.00 63.41           N  
ATOM    332  CA  SER    41      35.410  32.847  80.270  1.00 63.60           C  
ATOM    333  C   SER    41      34.805  31.530  80.710  1.00 63.06           C  
ATOM    334  O   SER    41      34.439  30.702  79.880  1.00 61.82           O  
ATOM    335  CB  SER    41      36.937  32.800  80.500  1.00 64.79           C  
ATOM    336  OG  SER    41      37.285  32.046  81.658  1.00 63.73           O  
ATOM    337  N   GLU    42      34.717  31.354  82.026  1.00 62.63           N  
ATOM    338  CA  GLU    42      34.164  30.141  82.606  1.00 61.99           C  
ATOM    339  C   GLU    42      32.690  30.023  82.279  1.00 60.99           C  
ATOM    340  O   GLU    42      31.904  29.451  83.022  1.00 60.52           O  
ATOM    341  CB  GLU    42      34.377  30.105  84.125  1.00 62.67           C  
ATOM    342  CG  GLU    42      33.401  30.918  84.953  1.00 62.19           C  
ATOM    343  CD  GLU    42      33.918  31.142  86.361  1.00 62.74           C  
ATOM    344  OE1 GLU    42      33.116  31.508  87.246  1.00 62.64           O  
ATOM    345  OE2 GLU    42      35.140  30.973  86.577  1.00 62.23           O  
ATOM    346  N   GLN    43      32.310  30.580  81.150  1.00 59.93           N  
ATOM    347  CA  GLN    43      30.945  30.468  80.745  1.00 58.67           C  
ATOM    348  C   GLN    43      30.904  30.640  79.257  1.00 58.36           C  
ATOM    349  O   GLN    43      29.860  30.480  78.632  1.00 58.42           O  
ATOM    350  CB  GLN    43      30.096  31.522  81.412  1.00 59.96           C  
ATOM    351  CG  GLN    43      28.648  31.260  81.180  1.00 61.85           C  
ATOM    352  CD  GLN    43      27.815  31.788  82.291  1.00 62.80           C  
ATOM    353  OE1 GLN    43      26.603  31.585  82.327  1.00 64.57           O  
ATOM    354  NE2 GLN    43      28.457  32.478  83.223  1.00 62.58           N  
ATOM    355  N   GLU    44      32.062  30.948  78.687  1.00 56.60           N  
ATOM    356  CA  GLU    44      32.157  31.156  77.257  1.00 54.77           C  
ATOM    357  C   GLU    44      33.349  30.476  76.611  1.00 54.02           C  
ATOM    358  O   GLU    44      33.458  30.456  75.389  1.00 51.36           O  
ATOM    359  CB  GLU    44      32.226  32.645  76.963  1.00 56.28           C  
ATOM    360  CG  GLU    44      30.946  33.396  77.190  1.00 55.44           C  
ATOM    361  CD  GLU    44      29.845  32.942  76.270  1.00 58.05           C  
ATOM    362  OE1 GLU    44      30.150  32.492  75.138  1.00 57.77           O  
ATOM    363  OE2 GLU    44      28.665  33.049  76.675  1.00 59.93           O  
ATOM    364  N   GLY    45      34.248  29.937  77.428  1.00 54.00           N  
ATOM    365  CA  GLY    45      35.418  29.268  76.892  1.00 53.58           C  
ATOM    366  C   GLY    45      36.656  30.149  76.854  1.00 53.71           C  
ATOM    367  O   GLY    45      36.869  30.965  77.753  1.00 56.62           O  
ATOM    368  N   GLY    46      37.474  29.975  75.815  1.00 52.13           N  
ATOM    369  CA  GLY    46      38.703  30.742  75.660  1.00 49.24           C  
ATOM    370  C   GLY    46      39.796  30.423  76.673  1.00 48.72           C  
ATOM    371  O   GLY    46      39.519  29.985  77.795  1.00 47.46           O  
ATOM    372  N   ASN    47      41.047  30.672  76.289  1.00 48.16           N  
ATOM    373  CA  ASN    47      42.190  30.399  77.163  1.00 49.52           C  
ATOM    374  C   ASN    47      42.307  31.299  78.387  1.00 50.80           C  
ATOM    375  O   ASN    47      42.789  32.425  78.279  1.00 52.11           O  
ATOM    376  CB  ASN    47      43.494  30.520  76.391  1.00 49.39           C  
ATOM    377  CG  ASN    47      44.687  30.074  77.215  1.00 49.42           C  
ATOM    378  OD1 ASN    47      44.642  30.082  78.450  1.00 45.46           O  
ATOM    379  ND2 ASN    47      45.766  29.682  76.534  1.00 48.99           N  
ATOM    380  N   ARG    48      41.914  30.796  79.553  1.00 51.76           N  
ATOM    381  CA  ARG    48      41.987  31.582  80.780  1.00 51.84           C  
ATOM    382  C   ARG    48      43.284  32.372  80.928  1.00 51.82           C  
ATOM    383  O   ARG    48      43.280  33.595  80.782  1.00 51.81           O  
ATOM    384  CB  ARG    48      41.780  30.683  81.992  1.00 53.07           C  
ATOM    385  CG  ARG    48      40.309  30.400  82.278  1.00 57.10           C  
ATOM    386  CD  ARG    48      39.735  31.481  83.181  1.00 59.98           C  
ATOM    387  NE  ARG    48      40.602  31.683  84.348  1.00 61.76           N  
ATOM    388  CZ  ARG    48      40.326  31.286  85.589  1.00 60.86           C  
ATOM    389  NH1 ARG    48      39.184  30.661  85.857  1.00 59.67           N  
ATOM    390  NH2 ARG    48      41.210  31.501  86.559  1.00 59.79           N  
ATOM    391  N   PHE    49      44.394  31.697  81.203  1.00 51.76           N  
ATOM    392  CA  PHE    49      45.666  32.408  81.356  1.00 51.74           C  
ATOM    393  C   PHE    49      45.840  33.601  80.425  1.00 51.33           C  
ATOM    394  O   PHE    49      46.225  34.681  80.862  1.00 52.80           O  
ATOM    395  CB  PHE    49      46.830  31.481  81.111  1.00 51.48           C  
ATOM    396  CG  PHE    49      48.155  32.118  81.341  1.00 52.07           C  
ATOM    397  CD1 PHE    49      49.094  32.186  80.318  1.00 52.10           C  
ATOM    398  CD2 PHE    49      48.514  32.550  82.618  1.00 52.69           C  
ATOM    399  CE1 PHE    49      50.389  32.664  80.565  1.00 53.59           C  
ATOM    400  CE2 PHE    49      49.806  33.028  82.877  1.00 53.77           C  
ATOM    401  CZ  PHE    49      50.751  33.084  81.847  1.00 52.32           C  
ATOM    402  N   ILE    50      45.588  33.406  79.137  1.00 50.70           N  
ATOM    403  CA  ILE    50      45.739  34.514  78.214  1.00 50.46           C  
ATOM    404  C   ILE    50      44.749  35.584  78.623  1.00 49.83           C  
ATOM    405  O   ILE    50      45.142  36.714  78.886  1.00 51.30           O  
ATOM    406  CB  ILE    50      45.510  34.097  76.725  1.00 49.38           C  
ATOM    407  CG1 ILE    50      46.774  33.430  76.170  1.00 48.19           C  
ATOM    408  CG2 ILE    50      45.234  35.319  75.874  1.00 48.93           C  
ATOM    409  CD1 ILE    50      46.609  32.873  74.783  1.00 47.73           C  
ATOM    410  N   ILE    51      43.472  35.227  78.705  1.00 49.94           N  
ATOM    411  CA  ILE    51      42.448  36.195  79.082  1.00 50.81           C  
ATOM    412  C   ILE    51      42.883  36.992  80.317  1.00 53.81           C  
ATOM    413  O   ILE    51      42.873  38.229  80.291  1.00 55.26           O  
ATOM    414  CB  ILE    51      41.099  35.505  79.356  1.00 46.63           C  
ATOM    415  CG1 ILE    51      40.559  34.913  78.061  1.00 45.05           C  
ATOM    416  CG2 ILE    51      40.102  36.504  79.899  1.00 45.01           C  
ATOM    417  CD1 ILE    51      39.285  34.109  78.227  1.00 44.42           C  
ATOM    418  N   GLU    52      43.285  36.292  81.381  1.00 55.37           N  
ATOM    419  CA  GLU    52      43.718  36.952  82.608  1.00 57.49           C  
ATOM    420  C   GLU    52      44.933  37.841  82.408  1.00 58.45           C  
ATOM    421  O   GLU    52      44.906  39.026  82.735  1.00 59.10           O  
ATOM    422  CB  GLU    52      44.043  35.928  83.683  1.00 56.94           C  
ATOM    423  CG  GLU    52      42.875  35.139  84.137  1.00 58.84           C  
ATOM    424  CD  GLU    52      43.189  34.348  85.379  1.00 62.43           C  
ATOM    425  OE1 GLU    52      43.505  34.968  86.416  1.00 63.83           O  
ATOM    426  OE2 GLU    52      43.125  33.102  85.326  1.00 66.05           O  
ATOM    427  N   MET    53      46.008  37.267  81.887  1.00 60.12           N  
ATOM    428  CA  MET    53      47.213  38.051  81.661  1.00 63.39           C  
ATOM    429  C   MET    53      46.903  39.291  80.832  1.00 62.71           C  
ATOM    430  O   MET    53      47.500  40.356  81.037  1.00 62.91           O  
ATOM    431  CB  MET    53      48.274  37.225  80.941  1.00 67.12           C  
ATOM    432  CG  MET    53      48.942  36.210  81.823  1.00 73.08           C  
ATOM    433  SD  MET    53      49.749  37.059  83.358  1.00 83.60          SE  
ATOM    434  CE  MET    53      51.366  37.718  82.523  1.00 78.14           C  
ATOM    435  N   ALA    54      45.966  39.159  79.898  1.00 59.46           N  
ATOM    436  CA  ALA    54      45.625  40.288  79.052  1.00 57.21           C  
ATOM    437  C   ALA    54      44.861  41.346  79.830  1.00 55.89           C  
ATOM    438  O   ALA    54      45.317  42.490  79.935  1.00 57.33           O  
ATOM    439  CB  ALA    54      44.826  39.827  77.849  1.00 55.59           C  
ATOM    440  N   ALA    55      43.717  40.971  80.393  1.00 53.22           N  
ATOM    441  CA  ALA    55      42.894  41.910  81.150  1.00 50.69           C  
ATOM    442  C   ALA    55      43.701  42.646  82.206  1.00 50.15           C  
ATOM    443  O   ALA    55      43.427  43.796  82.508  1.00 48.41           O  
ATOM    444  CB  ALA    55      41.761  41.166  81.808  1.00 50.25           C  
ATOM    445  N   LEU    56      44.704  41.966  82.750  1.00 51.07           N  
ATOM    446  CA  LEU    56      45.559  42.507  83.792  1.00 51.70           C  
ATOM    447  C   LEU    56      46.627  43.484  83.326  1.00 54.01           C  
ATOM    448  O   LEU    56      47.231  44.160  84.155  1.00 54.43           O  
ATOM    449  CB  LEU    56      46.251  41.361  84.522  1.00 51.37           C  
ATOM    450  CG  LEU    56      45.783  40.934  85.917  1.00 51.81           C  
ATOM    451  CD1 LEU    56      45.348  39.469  85.913  1.00 51.25           C  
ATOM    452  CD2 LEU    56      46.937  41.137  86.898  1.00 50.58           C  
ATOM    453  N   LEU    57      46.873  43.574  82.020  1.00 55.71           N  
ATOM    454  CA  LEU    57      47.917  44.475  81.533  1.00 56.87           C  
ATOM    455  C   LEU    57      47.495  45.454  80.427  1.00 58.78           C  
ATOM    456  O   LEU    57      48.340  46.209  79.916  1.00 59.98           O  
ATOM    457  CB  LEU    57      49.135  43.645  81.079  1.00 56.76           C  
ATOM    458  CG  LEU    57      49.916  42.822  82.129  1.00 55.77           C  
ATOM    459  CD1 LEU    57      50.878  41.866  81.443  1.00 53.44           C  
ATOM    460  CD2 LEU    57      50.678  43.748  83.061  1.00 54.51           C  
ATOM    461  N   HIS    58      46.205  45.453  80.068  1.00 58.11           N  
ATOM    462  CA  HIS    58      45.678  46.352  79.023  1.00 57.60           C  
ATOM    463  C   HIS    58      45.853  47.808  79.420  1.00 56.70           C  
ATOM    464  O   HIS    58      46.028  48.694  78.582  1.00 55.98           O  
ATOM    465  CB  HIS    58      44.177  46.059  78.735  1.00 59.89           C  
ATOM    466  CG  HIS    58      43.226  46.445  79.840  1.00 64.46           C  
ATOM    467  ND1 HIS    58      43.357  46.003  81.143  1.00 66.22           N  
ATOM    468  CD2 HIS    58      42.085  47.181  79.815  1.00 66.37           C  
ATOM    469  CE1 HIS    58      42.343  46.447  81.868  1.00 65.24           C  
ATOM    470  NE2 HIS    58      41.556  47.163  81.086  1.00 66.11           N  
ATOM    471  N   ASP    59      45.824  48.028  80.724  1.00 55.66           N  
ATOM    472  CA  ASP    59      45.957  49.347  81.281  1.00 55.23           C  
ATOM    473  C   ASP    59      47.392  49.828  81.412  1.00 56.41           C  
ATOM    474  O   ASP    59      47.644  51.029  81.398  1.00 57.70           O  
ATOM    475  CB  ASP    59      45.263  49.386  82.638  1.00 54.64           C  
ATOM    476  CG  ASP    59      43.826  49.855  82.541  1.00 53.95           C  
ATOM    477  OD1 ASP    59      43.117  49.453  81.599  1.00 53.61           O  
ATOM    478  OD2 ASP    59      43.402  50.629  83.418  1.00 53.25           O  
ATOM    479  N   VAL    60      48.336  48.903  81.526  1.00 56.48           N  
ATOM    480  CA  VAL    60      49.734  49.276  81.686  1.00 55.99           C  
ATOM    481  C   VAL    60      50.368  49.796  80.405  1.00 57.45           C  
ATOM    482  O   VAL    60      51.435  50.415  80.427  1.00 57.80           O  
ATOM    483  CB  VAL    60      50.530  48.096  82.236  1.00 55.60           C  
ATOM    484  CG1 VAL    60      51.999  48.445  82.352  1.00 55.22           C  
ATOM    485  CG2 VAL    60      49.980  47.742  83.597  1.00 56.62           C  
ATOM    486  N   ALA    61      49.703  49.568  79.284  1.00 58.50           N  
ATOM    487  CA  ALA    61      50.227  50.055  78.023  1.00 60.65           C  
ATOM    488  C   ALA    61      49.501  51.351  77.644  1.00 63.43           C  
ATOM    489  O   ALA    61      50.048  52.195  76.934  1.00 63.87           O  
ATOM    490  CB  ALA    61      50.049  49.001  76.944  1.00 59.87           C  
ATOM    491  N   ASP    62      48.270  51.510  78.128  1.00 66.34           N  
ATOM    492  CA  ASP    62      47.468  52.711  77.854  1.00 66.96           C  
ATOM    493  C   ASP    62      48.321  53.975  77.892  1.00 65.64           C  
ATOM    494  O   ASP    62      48.732  54.471  76.852  1.00 64.05           O  
ATOM    495  CB  ASP    62      46.328  52.818  78.883  1.00 69.44           C  
ATOM    496  CG  ASP    62      45.606  54.165  78.846  1.00 72.14           C  
ATOM    497  OD1 ASP    62      44.950  54.481  77.817  1.00 70.22           O  
ATOM    498  OD2 ASP    62      45.688  54.904  79.865  1.00 73.11           O  
ATOM    499  N   LEU    65      48.350  56.770  79.950  1.00 63.26           N  
ATOM    500  CA  LEU    65      49.183  57.483  80.928  1.00 63.60           C  
ATOM    501  C   LEU    65      50.395  56.636  81.329  1.00 65.48           C  
ATOM    502  O   LEU    65      51.016  56.862  82.375  1.00 67.00           O  
ATOM    503  CB  LEU    65      48.374  57.837  82.200  1.00 61.25           C  
ATOM    504  CG  LEU    65      47.636  56.735  82.996  1.00 58.55           C  
ATOM    505  CD1 LEU    65      47.408  57.162  84.456  1.00 54.02           C  
ATOM    506  CD2 LEU    65      46.304  56.421  82.303  1.00 55.80           C  
ATOM    507  N   ASN    66      50.733  55.656  80.497  1.00 64.41           N  
ATOM    508  CA  ASN    66      51.866  54.777  80.800  1.00 65.42           C  
ATOM    509  C   ASN    66      53.182  55.458  80.452  1.00 65.25           C  
ATOM    510  O   ASN    66      54.152  55.400  81.217  1.00 66.11           O  
ATOM    511  CB  ASN    66      51.759  53.455  80.011  1.00 66.78           C  
ATOM    512  CG  ASN    66      52.116  53.618  78.521  1.00 67.01           C  
ATOM    513  OD1 ASN    66      51.412  54.308  77.774  1.00 67.34           O  
ATOM    514  ND2 ASN    66      53.216  52.990  78.096  1.00 64.00           N  
ATOM    515  N   GLU    67      53.196  56.073  79.272  1.00 64.42           N  
ATOM    516  CA  GLU    67      54.359  56.768  78.752  1.00 66.26           C  
ATOM    517  C   GLU    67      54.011  57.617  77.522  1.00 69.19           C  
ATOM    518  O   GLU    67      53.540  58.753  77.657  1.00 72.69           O  
ATOM    519  CB  GLU    67      55.446  55.770  78.375  1.00 67.01           C  
ATOM    520  CG  GLU    67      56.740  56.445  77.950  1.00 66.48           C  
ATOM    521  CD  GLU    67      57.832  56.281  78.992  1.00 65.04           C  
ATOM    522  OE1 GLU    67      57.622  56.701  80.158  1.00 65.65           O  
ATOM    523  OE2 GLU    67      58.910  55.746  78.640  1.00 64.94           O  
ATOM    524  N   SER    68      54.220  57.072  76.323  1.00 67.68           N  
ATOM    525  CA  SER    68      53.951  57.825  75.088  1.00 67.54           C  
ATOM    526  C   SER    68      53.652  56.898  73.899  1.00 71.84           C  
ATOM    527  O   SER    68      54.564  56.280  73.338  1.00 73.27           O  
ATOM    528  CB  SER    68      55.164  58.707  74.784  1.00 66.29           C  
ATOM    529  OG  SER    68      56.203  58.457  75.730  1.00 58.59           O  
ATOM    530  N   GLU    69      52.375  56.814  73.519  1.00 74.66           N  
ATOM    531  CA  GLU    69      51.937  55.948  72.421  1.00 77.50           C  
ATOM    532  C   GLU    69      52.318  54.458  72.665  1.00 80.84           C  
ATOM    533  O   GLU    69      52.253  53.969  73.795  1.00 79.23           O  
ATOM    534  CB  GLU    69      52.530  56.451  71.087  1.00 78.22           C  
ATOM    535  N   GLU    70      52.715  53.756  71.601  1.00 82.88           N  
ATOM    536  CA  GLU    70      53.096  52.344  71.665  1.00 83.86           C  
ATOM    537  C   GLU    70      54.446  52.143  72.368  1.00 84.49           C  
ATOM    538  O   GLU    70      55.265  51.314  71.962  1.00 82.91           O  
ATOM    539  CB  GLU    70      53.143  51.777  70.239  1.00 86.54           C  
ATOM    540  CG  GLU    70      53.149  50.249  70.127  1.00 91.10           C  
ATOM    541  CD  GLU    70      54.465  49.698  69.604  1.00 93.39           C  
ATOM    542  OE1 GLU    70      54.783  49.948  68.415  1.00 94.80           O  
ATOM    543  OE2 GLU    70      55.179  49.023  70.387  1.00 94.11           O  
ATOM    544  N   ALA    71      54.677  52.916  73.422  1.00 84.48           N  
ATOM    545  CA  ALA    71      55.915  52.811  74.174  1.00 85.35           C  
ATOM    546  C   ALA    71      55.727  51.797  75.298  1.00 87.00           C  
ATOM    547  O   ALA    71      56.696  51.242  75.827  1.00 86.42           O  
ATOM    548  CB  ALA    71      56.284  54.162  74.742  1.00 85.43           C  
ATOM    549  N   GLY    72      54.464  51.558  75.646  1.00 88.72           N  
ATOM    550  CA  GLY    72      54.136  50.614  76.701  1.00 90.58           C  
ATOM    551  C   GLY    72      54.090  49.183  76.206  1.00 91.40           C  
ATOM    552  O   GLY    72      54.205  48.240  76.985  1.00 91.79           O  
ATOM    553  N   MET    73      53.912  49.023  74.902  1.00 92.03           N  
ATOM    554  CA  MET    73      53.868  47.703  74.303  1.00 93.01           C  
ATOM    555  C   MET    73      55.137  46.949  74.672  1.00 91.55           C  
ATOM    556  O   MET    73      55.083  45.833  75.187  1.00 91.24           O  
ATOM    557  CB  MET    73      53.774  47.827  72.790  1.00 97.28           C  
ATOM    558  CG  MET    73      52.728  46.929  72.165  1.00102.19           C  
ATOM    559  SD  MET    73      50.960  47.206  72.919  1.00109.67          SE  
ATOM    560  CE  MET    73      50.901  49.159  72.946  1.00105.49           C  
ATOM    561  N   LYS    74      56.283  47.561  74.397  1.00 89.74           N  
ATOM    562  CA  LYS    74      57.549  46.929  74.721  1.00 88.01           C  
ATOM    563  C   LYS    74      57.703  46.900  76.228  1.00 87.41           C  
ATOM    564  O   LYS    74      58.559  46.197  76.755  1.00 88.23           O  
ATOM    565  CB  LYS    74      58.727  47.684  74.098  1.00 87.71           C  
ATOM    566  CG  LYS    74      60.100  47.062  74.395  1.00 86.29           C  
ATOM    567  CD  LYS    74      60.689  47.527  75.725  1.00 84.77           C  
ATOM    568  CE  LYS    74      62.018  46.846  76.007  1.00 85.01           C  
ATOM    569  NZ  LYS    74      62.982  46.979  74.879  1.00 83.18           N  
ATOM    570  N   LYS    75      56.881  47.671  76.928  1.00 85.82           N  
ATOM    571  CA  LYS    75      56.950  47.683  78.383  1.00 84.29           C  
ATOM    572  C   LYS    75      56.334  46.385  78.901  1.00 84.13           C  
ATOM    573  O   LYS    75      56.806  45.804  79.884  1.00 84.52           O  
ATOM    574  CB  LYS    75      56.204  48.901  78.934  1.00 83.86           C  
ATOM    575  CG  LYS    75      55.928  48.865  80.430  1.00 82.95           C  
ATOM    576  CD  LYS    75      55.774  50.284  81.001  1.00 84.90           C  
ATOM    577  CE  LYS    75      54.739  51.138  80.243  1.00 85.04           C  
ATOM    578  NZ  LYS    75      54.903  52.621  80.465  1.00 83.14           N  
ATOM    579  N   VAL    76      55.281  45.940  78.215  1.00 82.84           N  
ATOM    580  CA  VAL    76      54.563  44.703  78.540  1.00 80.09           C  
ATOM    581  C   VAL    76      55.294  43.546  77.868  1.00 80.15           C  
ATOM    582  O   VAL    76      55.431  42.451  78.423  1.00 78.85           O  
ATOM    583  CB  VAL    76      53.117  44.772  78.012  1.00 79.09           C  
ATOM    584  CG1 VAL    76      52.404  43.439  78.209  1.00 76.50           C  
ATOM    585  CG2 VAL    76      52.378  45.890  78.723  1.00 78.24           C  
ATOM    586  N   SER    77      55.766  43.823  76.661  1.00 80.38           N  
ATOM    587  CA  SER    77      56.513  42.862  75.873  1.00 81.49           C  
ATOM    588  C   SER    77      57.659  42.250  76.676  1.00 82.91           C  
ATOM    589  O   SER    77      57.655  41.050  76.962  1.00 83.81           O  
ATOM    590  CB  SER    77      57.058  43.547  74.619  1.00 80.41           C  
ATOM    591  OG  SER    77      58.246  42.925  74.183  1.00 79.27           O  
ATOM    592  N   ASP    78      58.634  43.079  77.043  1.00 84.30           N  
ATOM    593  CA  ASP    78      59.801  42.623  77.809  1.00 84.85           C  
ATOM    594  C   ASP    78      59.458  42.063  79.190  1.00 83.83           C  
ATOM    595  O   ASP    78      60.314  41.480  79.857  1.00 84.23           O  
ATOM    596  CB  ASP    78      60.859  43.756  77.933  1.00 85.87           C  
ATOM    597  CG  ASP    78      60.339  45.007  78.661  1.00 86.65           C  
ATOM    598  OD1 ASP    78      61.067  46.029  78.662  1.00 85.97           O  
ATOM    599  OD2 ASP    78      59.222  44.977  79.236  1.00 88.00           O  
ATOM    600  N   TRP    79      58.209  42.238  79.617  1.00 82.60           N  
ATOM    601  CA  TRP    79      57.786  41.726  80.919  1.00 81.42           C  
ATOM    602  C   TRP    79      57.365  40.270  80.794  1.00 81.65           C  
ATOM    603  O   TRP    79      57.804  39.413  81.565  1.00 81.76           O  
ATOM    604  CB  TRP    79      56.614  42.533  81.494  1.00 78.42           C  
ATOM    605  CG  TRP    79      55.969  41.841  82.677  1.00 75.56           C  
ATOM    606  CD1 TRP    79      54.757  41.201  82.696  1.00 74.82           C  
ATOM    607  CD2 TRP    79      56.530  41.668  83.987  1.00 74.54           C  
ATOM    608  NE1 TRP    79      54.531  40.640  83.935  1.00 73.22           N  
ATOM    609  CE2 TRP    79      55.604  40.908  84.744  1.00 73.62           C  
ATOM    610  CE3 TRP    79      57.729  42.075  84.595  1.00 73.64           C  
ATOM    611  CZ2 TRP    79      55.840  40.551  86.076  1.00 73.23           C  
ATOM    612  CZ3 TRP    79      57.961  41.716  85.926  1.00 72.07           C  
ATOM    613  CH2 TRP    79      57.021  40.961  86.645  1.00 72.33           C  
ATOM    614  N   LEU    80      56.502  39.997  79.822  1.00 81.35           N  
ATOM    615  CA  LEU    80      56.031  38.642  79.600  1.00 81.36           C  
ATOM    616  C   LEU    80      57.241  37.718  79.416  1.00 82.75           C  
ATOM    617  O   LEU    80      57.155  36.504  79.627  1.00 83.71           O  
ATOM    618  CB  LEU    80      55.126  38.608  78.372  1.00 78.55           C  
ATOM    619  CG  LEU    80      53.850  39.439  78.489  1.00 76.59           C  
ATOM    620  CD1 LEU    80      53.063  39.292  77.219  1.00 75.59           C  
ATOM    621  CD2 LEU    80      53.016  38.984  79.672  1.00 75.73           C  
ATOM    622  N   GLU    81      58.368  38.314  79.035  1.00 83.30           N  
ATOM    623  CA  GLU    81      59.611  37.592  78.827  1.00 83.18           C  
ATOM    624  C   GLU    81      60.227  37.194  80.150  1.00 83.96           C  
ATOM    625  O   GLU    81      60.591  36.040  80.354  1.00 83.28           O  
ATOM    626  CB  GLU    81      60.582  38.471  78.056  1.00 82.96           C  
ATOM    627  CG  GLU    81      60.260  38.530  76.601  1.00 83.91           C  
ATOM    628  CD  GLU    81      60.479  37.192  75.946  1.00 85.26           C  
ATOM    629  OE1 GLU    81      59.857  36.937  74.897  1.00 86.78           O  
ATOM    630  OE2 GLU    81      61.287  36.395  76.476  1.00 85.66           O  
ATOM    631  N   GLU    82      60.347  38.163  81.047  1.00 86.15           N  
ATOM    632  CA  GLU    82      60.911  37.912  82.360  1.00 89.31           C  
ATOM    633  C   GLU    82      60.109  36.816  83.058  1.00 91.08           C  
ATOM    634  O   GLU    82      60.662  36.018  83.811  1.00 90.62           O  
ATOM    635  CB  GLU    82      60.902  39.204  83.184  1.00 90.62           C  
ATOM    636  CG  GLU    82      61.229  39.021  84.663  1.00 92.96           C  
ATOM    637  CD  GLU    82      61.320  40.345  85.414  1.00 94.03           C  
ATOM    638  OE1 GLU    82      61.342  40.322  86.664  1.00 93.95           O  
ATOM    639  OE2 GLU    82      61.380  41.404  84.751  1.00 94.64           O  
ATOM    640  N   LEU    83      58.806  36.778  82.793  1.00 93.88           N  
ATOM    641  CA  LEU    83      57.914  35.771  83.373  1.00 96.03           C  
ATOM    642  C   LEU    83      57.913  34.522  82.495  1.00 97.28           C  
ATOM    643  O   LEU    83      57.220  33.550  82.785  1.00 97.42           O  
ATOM    644  CB  LEU    83      56.483  36.321  83.482  1.00 96.66           C  
ATOM    645  CG  LEU    83      55.888  36.711  84.846  1.00 97.05           C  
ATOM    646  CD1 LEU    83      55.599  35.465  85.651  1.00 97.35           C  
ATOM    647  CD2 LEU    83      56.836  37.626  85.602  1.00 98.25           C  
ATOM    648  N   HIS    84      58.693  34.565  81.420  1.00 99.41           N  
ATOM    649  CA  HIS    84      58.795  33.446  80.497  1.00101.32           C  
ATOM    650  C   HIS    84      57.437  32.991  80.006  1.00101.97           C  
ATOM    651  O   HIS    84      56.693  32.320  80.717  1.00102.24           O  
ATOM    652  CB  HIS    84      59.510  32.281  81.171  1.00103.74           C  
ATOM    653  CG  HIS    84      60.999  32.337  81.057  1.00106.67           C  
ATOM    654  ND1 HIS    84      61.839  32.019  82.103  1.00107.68           N  
ATOM    655  CD2 HIS    84      61.802  32.627  80.004  1.00107.80           C  
ATOM    656  CE1 HIS    84      63.094  32.107  81.701  1.00108.75           C  
ATOM    657  NE2 HIS    84      63.099  32.474  80.430  1.00109.14           N  
ATOM    658  N   VAL    85      57.117  33.366  78.778  1.00102.41           N  
ATOM    659  CA  VAL    85      55.851  32.991  78.173  1.00103.08           C  
ATOM    660  C   VAL    85      56.083  32.747  76.687  1.00103.80           C  
ATOM    661  O   VAL    85      56.294  33.689  75.927  1.00103.96           O  
ATOM    662  CB  VAL    85      54.799  34.106  78.368  1.00102.69           C  
ATOM    663  CG1 VAL    85      53.555  33.804  77.552  1.00102.21           C  
ATOM    664  CG2 VAL    85      54.442  34.222  79.837  1.00102.22           C  
ATOM    665  N   GLU    86      56.064  31.478  76.288  1.00104.39           N  
ATOM    666  CA  GLU    86      56.275  31.101  74.893  1.00105.44           C  
ATOM    667  C   GLU    86      55.646  32.116  73.959  1.00105.44           C  
ATOM    668  O   GLU    86      54.465  32.437  74.093  1.00106.40           O  
ATOM    669  CB  GLU    86      55.662  29.728  74.605  1.00106.95           C  
ATOM    670  CG  GLU    86      56.591  28.535  74.806  1.00107.43           C  
ATOM    671  CD  GLU    86      55.898  27.201  74.536  1.00107.73           C  
ATOM    672  OE1 GLU    86      55.252  27.052  73.474  1.00107.83           O  
ATOM    673  OE2 GLU    86      56.008  26.295  75.387  1.00108.14           O  
ATOM    674  N   GLU    87      56.432  32.616  73.011  1.00104.19           N  
ATOM    675  CA  GLU    87      55.925  33.590  72.056  1.00103.36           C  
ATOM    676  C   GLU    87      54.598  33.093  71.496  1.00102.82           C  
ATOM    677  O   GLU    87      53.759  33.882  71.068  1.00102.80           O  
ATOM    678  CB  GLU    87      56.909  33.780  70.904  1.00103.37           C  
ATOM    679  CG  GLU    87      56.454  34.829  69.898  1.00103.61           C  
ATOM    680  CD  GLU    87      57.228  34.789  68.595  1.00103.62           C  
ATOM    681  OE1 GLU    87      57.014  35.697  67.760  1.00103.68           O  
ATOM    682  OE2 GLU    87      58.038  33.853  68.403  1.00102.59           O  
ATOM    683  N   GLU    88      54.421  31.775  71.503  1.00101.96           N  
ATOM    684  CA  GLU    88      53.207  31.159  70.989  1.00101.12           C  
ATOM    685  C   GLU    88      51.974  31.695  71.713  1.00100.67           C  
ATOM    686  O   GLU    88      50.877  31.753  71.145  1.00101.54           O  
ATOM    687  CB  GLU    88      53.293  29.638  71.136  1.00100.80           C  
ATOM    688  CG  GLU    88      52.205  28.874  70.398  1.00 99.08           C  
ATOM    689  CD  GLU    88      52.751  27.672  69.648  1.00 98.05           C  
ATOM    690  OE1 GLU    88      53.387  26.802  70.285  1.00 97.31           O  
ATOM    691  OE2 GLU    88      52.535  27.597  68.421  1.00 96.89           O  
ATOM    692  N   GLU    89      52.159  32.094  72.967  1.00 98.71           N  
ATOM    693  CA  GLU    89      51.064  32.636  73.761  1.00 97.39           C  
ATOM    694  C   GLU    89      51.198  34.140  73.932  1.00 95.84           C  
ATOM    695  O   GLU    89      50.231  34.885  73.783  1.00 95.67           O  
ATOM    696  CB  GLU    89      51.022  31.957  75.130  1.00 97.85           C  
ATOM    697  CG  GLU    89      50.325  30.613  75.103  1.00 99.04           C  
ATOM    698  CD  GLU    89      50.149  29.999  76.478  1.00100.11           C  
ATOM    699  OE1 GLU    89      49.444  28.970  76.573  1.00101.59           O  
ATOM    700  OE2 GLU    89      50.717  30.529  77.461  1.00100.07           O  
ATOM    701  N   SER    90      52.414  34.570  74.244  1.00 93.98           N  
ATOM    702  CA  SER    90      52.719  35.974  74.447  1.00 91.31           C  
ATOM    703  C   SER    90      52.270  36.802  73.254  1.00 89.60           C  
ATOM    704  O   SER    90      51.670  37.861  73.401  1.00 88.42           O  
ATOM    705  CB  SER    90      54.220  36.138  74.659  1.00 90.94           C  
ATOM    706  OG  SER    90      54.531  37.471  74.991  1.00 92.54           O  
ATOM    707  N   LYS    91      52.567  36.305  72.066  1.00 88.76           N  
ATOM    708  CA  LYS    91      52.185  36.999  70.847  1.00 89.03           C  
ATOM    709  C   LYS    91      50.673  37.271  70.849  1.00 87.86           C  
ATOM    710  O   LYS    91      50.205  38.220  70.212  1.00 88.17           O  
ATOM    711  CB  LYS    91      52.576  36.150  69.624  1.00 89.63           C  
ATOM    712  CG  LYS    91      52.492  36.854  68.265  1.00 90.92           C  
ATOM    713  CD  LYS    91      53.587  37.910  68.079  1.00 90.23           C  
ATOM    714  CE  LYS    91      53.658  38.338  66.628  1.00 88.60           C  
ATOM    715  NZ  LYS    91      53.807  37.130  65.764  1.00 86.94           N  
ATOM    716  N   HIS    92      49.919  36.448  71.578  1.00 85.83           N  
ATOM    717  CA  HIS    92      48.453  36.571  71.658  1.00 83.02           C  
ATOM    718  C   HIS    92      48.032  37.435  72.824  1.00 81.96           C  
ATOM    719  O   HIS    92      47.025  38.143  72.755  1.00 81.68           O  
ATOM    720  CB  HIS    92      47.817  35.191  71.840  1.00 81.86           C  
ATOM    721  CG  HIS    92      46.321  35.184  71.732  1.00 80.25           C  
ATOM    722  ND1 HIS    92      45.557  34.099  72.113  1.00 79.61           N  
ATOM    723  CD2 HIS    92      45.458  36.100  71.239  1.00 79.93           C  
ATOM    724  CE1 HIS    92      44.286  34.351  71.857  1.00 78.84           C  
ATOM    725  NE2 HIS    92      44.196  35.555  71.325  1.00 80.02           N  
ATOM    726  N   VAL    93      48.798  37.349  73.905  1.00 81.14           N  
ATOM    727  CA  VAL    93      48.507  38.123  75.093  1.00 79.89           C  
ATOM    728  C   VAL    93      48.728  39.585  74.777  1.00 79.26           C  
ATOM    729  O   VAL    93      47.782  40.359  74.726  1.00 79.67           O  
ATOM    730  CB  VAL    93      49.407  37.712  76.278  1.00 79.74           C  
ATOM    731  CG1 VAL    93      49.230  38.699  77.421  1.00 79.38           C  
ATOM    732  CG2 VAL    93      49.063  36.298  76.742  1.00 77.99           C  
ATOM    733  N   LEU    94      49.971  39.969  74.528  1.00 78.44           N  
ATOM    734  CA  LEU    94      50.219  41.369  74.237  1.00 77.24           C  
ATOM    735  C   LEU    94      49.584  41.790  72.924  1.00 76.74           C  
ATOM    736  O   LEU    94      49.775  42.910  72.465  1.00 77.69           O  
ATOM    737  CB  LEU    94      51.716  41.678  74.217  1.00 75.64           C  
ATOM    738  CG  LEU    94      52.472  41.454  72.923  1.00 73.82           C  
ATOM    739  CD1 LEU    94      53.249  42.716  72.621  1.00 73.77           C  
ATOM    740  CD2 LEU    94      53.382  40.244  73.032  1.00 73.03           C  
ATOM    741  N   HIS    95      48.822  40.898  72.315  1.00 76.14           N  
ATOM    742  CA  HIS    95      48.185  41.242  71.060  1.00 75.94           C  
ATOM    743  C   HIS    95      46.935  42.046  71.368  1.00 76.07           C  
ATOM    744  O   HIS    95      46.907  43.256  71.146  1.00 76.24           O  
ATOM    745  CB  HIS    95      47.840  39.973  70.290  1.00 76.81           C  
ATOM    746  CG  HIS    95      47.133  40.217  68.994  1.00 77.40           C  
ATOM    747  ND1 HIS    95      47.681  40.955  67.967  1.00 77.15           N  
ATOM    748  CD2 HIS    95      45.931  39.783  68.545  1.00 78.36           C  
ATOM    749  CE1 HIS    95      46.849  40.963  66.940  1.00 76.73           C  
ATOM    750  NE2 HIS    95      45.780  40.259  67.266  1.00 77.49           N  
ATOM    751  N   ILE    96      45.913  41.385  71.906  1.00 76.13           N  
ATOM    752  CA  ILE    96      44.657  42.062  72.239  1.00 75.31           C  
ATOM    753  C   ILE    96      44.873  43.315  73.095  1.00 74.93           C  
ATOM    754  O   ILE    96      44.071  44.258  73.064  1.00 73.06           O  
ATOM    755  CB  ILE    96      43.658  41.069  72.918  1.00 75.29           C  
ATOM    756  CG1 ILE    96      44.343  40.261  74.013  1.00 74.28           C  
ATOM    757  CG2 ILE    96      43.108  40.102  71.872  1.00 75.72           C  
ATOM    758  CD1 ILE    96      43.480  39.134  74.559  1.00 72.10           C  
ATOM    759  N   ILE    97      45.986  43.319  73.827  1.00 75.18           N  
ATOM    760  CA  ILE    97      46.389  44.434  74.688  1.00 74.43           C  
ATOM    761  C   ILE    97      46.576  45.668  73.806  1.00 75.89           C  
ATOM    762  O   ILE    97      46.797  46.778  74.298  1.00 75.02           O  
ATOM    763  CB  ILE    97      47.732  44.127  75.385  1.00 72.70           C  
ATOM    764  CG1 ILE    97      47.703  44.579  76.831  1.00 70.67           C  
ATOM    765  CG2 ILE    97      48.869  44.845  74.674  1.00 73.04           C  
ATOM    766  CD1 ILE    97      48.921  44.134  77.596  1.00 68.87           C  
ATOM    767  N   ALA    98      46.514  45.457  72.496  1.00 77.45           N  
ATOM    768  CA  ALA    98      46.651  46.552  71.556  1.00 78.57           C  
ATOM    769  C   ALA    98      45.261  47.081  71.291  1.00 79.91           C  
ATOM    770  O   ALA    98      45.035  48.283  71.347  1.00 79.61           O  
ATOM    771  CB  ALA    98      47.285  46.072  70.272  1.00 77.97           C  
ATOM    772  N   ASN    99      44.325  46.173  71.027  1.00 82.07           N  
ATOM    773  CA  ASN    99      42.948  46.565  70.756  1.00 84.96           C  
ATOM    774  C   ASN    99      42.176  46.845  72.037  1.00 87.38           C  
ATOM    775  O   ASN    99      40.989  46.530  72.143  1.00 88.24           O  
ATOM    776  CB  ASN    99      42.228  45.489  69.935  1.00 84.22           C  
ATOM    777  CG  ASN    99      42.836  45.307  68.549  1.00 83.98           C  
ATOM    778  OD1 ASN    99      44.021  44.983  68.415  1.00 83.25           O  
ATOM    779  ND2 ASN    99      42.025  45.513  67.511  1.00 81.06           N  
ATOM    780  N   MET   100      42.862  47.446  73.004  1.00 90.07           N  
ATOM    781  CA  MET   100      42.257  47.791  74.289  1.00 92.39           C  
ATOM    782  C   MET   100      42.343  49.301  74.530  1.00 92.50           C  
ATOM    783  O   MET   100      42.370  49.760  75.676  1.00 92.32           O  
ATOM    784  CB  MET   100      42.967  47.035  75.423  1.00 94.34           C  
ATOM    785  CG  MET   100      42.676  45.532  75.458  1.00 96.06           C  
ATOM    786  SD  MET   100      40.983  45.046  76.295  1.00 99.14          SE  
ATOM    787  CE  MET   100      39.749  45.527  74.858  1.00 97.67           C  
END
