
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  174 ( 1343),  selected  174 , name 2pq7_A
# Molecule2: number of CA atoms   97 (  787),  selected   97 , name T0470_2_100.pdb
# PARAMETERS: 2pq7_A.T0470_2_100.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      -       -           -
LGA    N     2_A      -       -           -
LGA    L     3_A      -       -           -
LGA    T     4_A      -       -           -
LGA    E     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    X     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    R     9_A      -       -           -
LGA    I    10_A      T       2           #
LGA    P    11_A      K       3          1.648
LGA    -       -      Q       4           -
LGA    -       -      E       5           -
LGA    H    12_A      K       6          0.950
LGA    L    13_A      I       7          2.039
LGA    R    14_A      E       8          2.216
LGA    E    15_A      K       9          1.423
LGA    I    16_A      T      10          0.617
LGA    L    17_A      I      11          0.913
LGA    N    18_A      T      12          0.937
LGA    I    19_A      F      13          1.104
LGA    V    20_A      V      14          0.390
LGA    R    21_A      K      15          0.935
LGA    E    22_A      H      16          0.994
LGA    A    23_A      I      17          0.910
LGA    F    24_A      L      18          0.612
LGA    K    25_A      E      19          0.791
LGA    -       -      K      20           -
LGA    D    26_A      D      21          4.241
LGA    Y    27_A      A      22          1.332
LGA    D    28_A      S      23          3.248
LGA    D    29_A      G      24           -
LGA    P    30_A      -       -           -
LGA    A    31_A      -       -           -
LGA    H    32_A      -       -           -
LGA    D    33_A      H      25          4.542
LGA    I    34_A      D      26          2.431
LGA    S    35_A      W      27          2.799
LGA    -       -      Y      28           -
LGA    H    36_A      H      29          1.375
LGA    T    37_A      I      30          0.945
LGA    F    38_A      R      31          1.028
LGA    R    39_A      R      32          1.212
LGA    V    40_A      V      33          1.353
LGA    X    41_A      H      34          0.703
LGA    E    42_A      K      35          1.348
LGA    N    43_A      M      36          1.612
LGA    A    44_A      A      37          1.069
LGA    S    45_A      I      38          0.891
LGA    E    46_A      S      39          1.504
LGA    I    47_A      L      40          1.629
LGA    A    48_A      S      41          1.628
LGA    S    49_A      E      42          1.562
LGA    R    50_A      Q      43          1.073
LGA    E    51_A      E      44          0.959
LGA    K    52_A      G      45          1.214
LGA    C    53_A      G      46          0.805
LGA    D    54_A      N      47          0.451
LGA    L    55_A      R      48          0.535
LGA    Q    56_A      F      49          0.197
LGA    K    57_A      I      50          0.237
LGA    A    58_A      I      51          0.514
LGA    I    59_A      E      52          0.440
LGA    I    60_A      M      53          0.412
LGA    A    61_A      A      54          0.482
LGA    A    62_A      A      55          0.816
LGA    L    63_A      L      56          0.793
LGA    L    64_A      L      57          0.785
LGA    H    65_A      H      58          0.796
LGA    D    66_A      D      59          0.603
LGA    I    67_A      V      60          1.204
LGA    K    68_A      A      61          3.484
LGA    R    69_A      D      62          4.171
LGA    P    70_A      L      65          3.773
LGA    H    71_A      N      66          2.298
LGA    E    72_A      E      67          3.723
LGA    A    73_A      -       -           -
LGA    L    74_A      -       -           -
LGA    T    75_A      -       -           -
LGA    G    76_A      -       -           -
LGA    V    77_A      S      68          1.273
LGA    D    78_A      E      69          2.483
LGA    H    79_A      -       -           -
LGA    A    80_A      -       -           -
LGA    E    81_A      E      70          2.695
LGA    S    82_A      A      71          3.243
LGA    G    83_A      G      72          3.542
LGA    A    84_A      M      73          2.829
LGA    E    85_A      K      74          2.231
LGA    Y    86_A      K      75          2.168
LGA    A    87_A      V      76          2.356
LGA    S    88_A      S      77          1.895
LGA    G    89_A      D      78          1.200
LGA    L    90_A      W      79          1.134
LGA    L    91_A      L      80          1.021
LGA    P    92_A      E      81          2.300
LGA    T    93_A      E      82          2.306
LGA    X    94_A      L      83          1.675
LGA    G    95_A      H      84          2.239
LGA    F    96_A      V      85          1.074
LGA    D    97_A      E      86          0.574
LGA    I    98_A      E      87          0.882
LGA    S    99_A      E      88          1.495
LGA    F   100_A      E      89          0.467
LGA    V   101_A      S      90          0.439
LGA    A   102_A      K      91          0.448
LGA    E   103_A      H      92          0.432
LGA    V   104_A      V      93          0.722
LGA    S   105_A      L      94          0.996
LGA    K   106_A      H      95          1.114
LGA    A   107_A      I      96          0.618
LGA    I   108_A      I      97          0.504
LGA    R   109_A      A      98          1.037
LGA    S   110_A      N      99          1.361
LGA    H   111_A      M     100          1.222
LGA    R   112_A      -       -           -
LGA    T   118_A      -       -           -
LGA    P   119_A      -       -           -
LGA    T   120_A      -       -           -
LGA    S   121_A      -       -           -
LGA    L   122_A      -       -           -
LGA    T   123_A      -       -           -
LGA    G   124_A      -       -           -
LGA    K   125_A      -       -           -
LGA    I   126_A      -       -           -
LGA    L   127_A      -       -           -
LGA    Q   128_A      -       -           -
LGA    D   129_A      -       -           -
LGA    A   130_A      -       -           -
LGA    D   131_A      -       -           -
LGA    R   132_A      -       -           -
LGA    L   133_A      -       -           -
LGA    D   134_A      -       -           -
LGA    A   135_A      -       -           -
LGA    I   136_A      -       -           -
LGA    G   137_A      -       -           -
LGA    A   138_A      -       -           -
LGA    V   139_A      -       -           -
LGA    A   140_A      -       -           -
LGA    I   141_A      -       -           -
LGA    A   142_A      -       -           -
LGA    R   143_A      -       -           -
LGA    V   144_A      -       -           -
LGA    F   145_A      -       -           -
LGA    S   146_A      -       -           -
LGA    Y   147_A      -       -           -
LGA    P   186_A      -       -           -
LGA    E   187_A      -       -           -
LGA    T   188_A      -       -           -
LGA    F   189_A      -       -           -
LGA    W   190_A      -       -           -
LGA    T   191_A      -       -           -
LGA    E   192_A      -       -           -
LGA    T   193_A      -       -           -
LGA    A   194_A      -       -           -
LGA    R   195_A      -       -           -
LGA    K   196_A      -       -           -
LGA    X   197_A      -       -           -
LGA    A   198_A      -       -           -
LGA    E   199_A      -       -           -
LGA    D   200_A      -       -           -
LGA    R   201_A      -       -           -
LGA    Y   202_A      -       -           -
LGA    S   203_A      -       -           -
LGA    F   204_A      -       -           -
LGA    V   205_A      -       -           -
LGA    V   206_A      -       -           -
LGA    E   207_A      -       -           -
LGA    F   208_A      -       -           -
LGA    V   209_A      -       -           -
LGA    Q   210_A      -       -           -
LGA    R   211_A      -       -           -
LGA    F   212_A      -       -           -
LGA    L   213_A      -       -           -
LGA    A   214_A      -       -           -
LGA    E   215_A      -       -           -
LGA    W   216_A      -       -           -
LGA    G   217_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  174   97    5.0     91    1.77    21.98     86.254     4.878

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.774340 * X  +  -0.632676 * Y  +   0.010913 * Z  +  94.079506
  Y_new =   0.599455 * X  +  -0.738984 * Y  +  -0.307501 * Z  +  40.458527
  Z_new =   0.202613 * X  +  -0.231568 * Y  +   0.951485 * Z  +  68.280319 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.238734    2.902858  [ DEG:   -13.6785    166.3215 ]
  Theta =  -0.204025   -2.937567  [ DEG:   -11.6898   -168.3102 ]
  Phi   =   2.482814   -0.658779  [ DEG:   142.2548    -37.7452 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pq7_A                                        
REMARK     2: T0470_2_100.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pq7_A.T0470_2_100.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  174   97   5.0   91   1.77   21.98  86.254
REMARK  ---------------------------------------------------------- 
MOLECULE 2pq7_A
HEADER    HYDROLASE                               01-MAY-07   2PQ7              
TITLE     CRYSTAL STRUCTURE OF PREDICTED HD SUPERFAMILY HYDROLASE               
TITLE    2 (104161995) FROM UNCULTURED THERMOTOGALES BACTERIUM AT               
TITLE    3 1.45 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PREDICTED HD SUPERFAMILY HYDROLASE;                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: UNCULTURED THERMOTOGALES BACTERIUM;             
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: 104161995, MES0020;                                            
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    104161995, HD DOMAIN, PREDICTED HD SUPERFAMILY HYDROLASE,             
KEYWDS   2 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   3 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI-2                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   15-MAY-07 2PQ7    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PREDICTED HD SUPERFAMILY                
JRNL        TITL 2 HYDROLASE (104161995) FROM UNCULTURED                        
JRNL        TITL 3 THERMOTOGALES BACTERIUM AT 1.45 A RESOLUTION                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.45 ANGSTROMS.                                          
DBREF  2PQ7 A    1   219  UNP    Q1EM40   Q1EM40_9BACT     1    219             
SEQRES   1 A  220  GLY MSE ASN LEU THR GLU LEU MSE GLU ARG ILE PRO HIS          
SEQRES   2 A  220  LEU ARG GLU ILE LEU ASN ILE VAL ARG GLU ALA PHE LYS          
SEQRES   3 A  220  ASP TYR ASP ASP PRO ALA HIS ASP ILE SER HIS THR PHE          
SEQRES   4 A  220  ARG VAL MSE GLU ASN ALA SER GLU ILE ALA SER ARG GLU          
SEQRES   5 A  220  LYS CYS ASP LEU GLN LYS ALA ILE ILE ALA ALA LEU LEU          
SEQRES   6 A  220  HIS ASP ILE LYS ARG PRO HIS GLU ALA LEU THR GLY VAL          
SEQRES   7 A  220  ASP HIS ALA GLU SER GLY ALA GLU TYR ALA SER GLY LEU          
SEQRES   8 A  220  LEU PRO THR MSE GLY PHE ASP ILE SER PHE VAL ALA GLU          
SEQRES   9 A  220  VAL SER LYS ALA ILE ARG SER HIS ARG TYR SER GLY GLY          
SEQRES  10 A  220  LEU THR PRO THR SER LEU THR GLY LYS ILE LEU GLN ASP          
SEQRES  11 A  220  ALA ASP ARG LEU ASP ALA ILE GLY ALA VAL ALA ILE ALA          
SEQRES  12 A  220  ARG VAL PHE SER TYR SER GLY LYS THR GLY THR PRO LEU          
SEQRES  13 A  220  HIS SER LEU GLN PHE SER PRO ARG SER SER TYR SER GLY          
SEQRES  14 A  220  ASN SER ARG SER SER ILE ASN HIS PHE HIS GLU LYS ILE          
SEQRES  15 A  220  LEU LYS ILE ARG PRO GLU THR PHE TRP THR GLU THR ALA          
SEQRES  16 A  220  ARG LYS MSE ALA GLU ASP ARG TYR SER PHE VAL VAL GLU          
SEQRES  17 A  220  PHE VAL GLN ARG PHE LEU ALA GLU TRP GLY GLN ILE              
HET    MSE  A   1      16                                                       
HET    MSE  A   7      16                                                       
HET    MSE  A  41      16                                                       
HET    MSE  A  94       8                                                       
HET    MSE  A 197      16                                                       
HET     FE      1       1                                                       
HET     FE      2       1                                                       
HET     CL      3       1                                                       
HET    PO4      4       5                                                       
HET    PO4      5       5                                                       
HET    MPD      6       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      FE FE (III) ION                                                     
HETNAM      CL CHLORIDE ION                                                     
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM     MPD (4S)-2-METHYL-2,4-PENTANEDIOL                                    
FORMUL   1  MSE    5(C5 H11 N O2 SE)                                            
FORMUL   2   FE    2(FE 3+)                                                     
FORMUL   4   CL    CL 1-                                                        
FORMUL   5  PO4    2(O4 P 3-)                                                   
FORMUL   7  MPD    C6 H14 O2                                                    
FORMUL   8  HOH   *148(H2 O)                                                    
CRYST1  138.518   40.662   37.789  90.00  95.32  90.00 C 1 2 1       4          
HETATM    1  N   MSE A   1      35.953  33.450  90.897  0.50 33.95           N  
HETATM    3  CA  MSE A   1      37.242  33.066  91.550  0.50 31.87           C  
HETATM    5  C   MSE A   1      37.881  34.181  92.333  0.50 33.90           C  
HETATM    7  O   MSE A   1      37.844  35.333  91.905  0.50 35.43           O  
HETATM    9  CB  MSE A   1      38.277  32.601  90.520  0.50 32.93           C  
HETATM   11  CG  MSE A   1      38.356  31.109  90.306  0.50 29.30           C  
HETATM   13 SE   MSE A   1      39.922  30.713  89.221  0.37 24.68          SE  
HETATM   15  CE  MSE A   1      39.016  31.365  87.441  0.50 21.18           C  
ATOM     17  N   ASN A   2      38.473  33.822  93.477  1.00 32.36           N  
ATOM     18  CA  ASN A   2      39.231  34.739  94.290  1.00 34.03           C  
ATOM     19  C   ASN A   2      40.659  34.683  93.772  1.00 33.12           C  
ATOM     20  O   ASN A   2      40.970  33.855  92.903  1.00 31.25           O  
ATOM     21  CB  ASN A   2      39.141  34.387  95.798  1.00 35.45           C  
ATOM     22  CG  ASN A   2      39.686  32.993  96.146  1.00 37.03           C  
ATOM     23  OD1 ASN A   2      40.660  32.526  95.585  1.00 31.39           O  
ATOM     24  ND2 ASN A   2      39.053  32.342  97.121  1.00 36.40           N  
ATOM     25  N   LEU A   3      41.531  35.541  94.294  1.00 32.38           N  
ATOM     26  CA  LEU A   3      42.917  35.592  93.840  1.00 33.47           C  
ATOM     27  C   LEU A   3      43.714  34.329  94.126  1.00 29.92           C  
ATOM     28  O   LEU A   3      44.609  33.965  93.356  1.00 28.81           O  
ATOM     29  CB  LEU A   3      43.660  36.819  94.408  1.00 34.30           C  
ATOM     30  CG  LEU A   3      43.457  38.141  93.653  1.00 41.27           C  
ATOM     31  N   THR A   4      43.436  33.686  95.265  1.00 27.93           N  
ATOM     32  CA  THR A   4      44.133  32.455  95.612  1.00 26.87           C  
ATOM     33  C   THR A   4      43.858  31.419  94.540  1.00 21.32           C  
ATOM     34  O   THR A   4      44.751  30.716  94.109  1.00 24.24           O  
ATOM     35  CB  THR A   4      43.653  31.945  96.993  1.00 27.60           C  
ATOM     36  OG1 THR A   4      44.134  32.854  97.986  1.00 30.14           O  
ATOM     37  CG2 THR A   4      44.154  30.555  97.299  1.00 27.18           C  
ATOM     38  N   GLU A   5      42.599  31.347  94.132  1.00 22.48           N  
ATOM     39  CA  GLU A   5      42.182  30.432  93.115  1.00 23.09           C  
ATOM     40  C   GLU A   5      42.824  30.767  91.766  1.00 24.18           C  
ATOM     41  O   GLU A   5      43.278  29.867  91.059  1.00 21.56           O  
ATOM     42  CB  GLU A   5      40.683  30.435  93.036  1.00 25.89           C  
ATOM     43  CG  GLU A   5      40.104  29.673  94.244  1.00 27.02           C  
ATOM     44  CD  GLU A   5      38.612  29.815  94.362  1.00 33.44           C  
ATOM     45  OE1 GLU A   5      38.064  30.840  93.901  1.00 30.08           O  
ATOM     46  OE2 GLU A   5      37.979  28.889  94.925  1.00 32.48           O  
ATOM     47  N   LEU A   6      42.871  32.054  91.432  1.00 26.13           N  
ATOM     48  CA  LEU A   6      43.560  32.468  90.189  1.00 25.37           C  
ATOM     49  C   LEU A   6      45.049  32.117  90.245  1.00 23.72           C  
ATOM     50  O   LEU A   6      45.624  31.655  89.256  1.00 21.41           O  
ATOM     51  CB  LEU A   6      43.317  33.965  89.893  1.00 27.74           C  
ATOM     52  CG  LEU A   6      41.897  34.347  89.466  1.00 27.97           C  
ATOM     53  CD1 LEU A   6      41.760  35.832  89.410  1.00 32.33           C  
ATOM     54  CD2 LEU A   6      41.510  33.730  88.112  1.00 29.41           C  
HETATM   55  N   MSE A   7      45.663  32.290  91.417  0.50 22.27           N  
HETATM   57  CA  MSE A   7      47.079  31.981  91.584  0.50 23.27           C  
HETATM   59  C   MSE A   7      47.379  30.476  91.491  0.50 24.05           C  
HETATM   61  O   MSE A   7      48.500  30.081  91.165  0.50 24.08           O  
HETATM   63  CB  MSE A   7      47.641  32.645  92.851  0.50 25.87           C  
HETATM   65  CG  MSE A   7      47.799  34.164  92.667  0.50 20.60           C  
HETATM   67 SE   MSE A   7      48.487  35.265  94.161  0.37 30.67          SE  
HETATM   69  CE  MSE A   7      49.774  33.997  94.923  0.50 24.97           C  
ATOM     71  N   GLU A   8      46.379  29.645  91.782  1.00 23.87           N  
ATOM     72  CA  GLU A   8      46.481  28.210  91.590  1.00 27.29           C  
ATOM     73  C   GLU A   8      46.458  27.812  90.118  1.00 25.64           C  
ATOM     74  O   GLU A   8      46.975  26.733  89.749  1.00 27.16           O  
ATOM     75  CB  GLU A   8      45.312  27.503  92.294  1.00 28.61           C  
ATOM     76  CG  GLU A   8      45.430  27.483  93.792  1.00 31.66           C  
ATOM     77  CD  GLU A   8      44.144  26.992  94.474  1.00 33.51           C  
ATOM     78  OE1 GLU A   8      43.095  26.810  93.788  1.00 31.56           O  
ATOM     79  OE2 GLU A   8      44.191  26.793  95.704  1.00 45.55           O  
ATOM     80  N   ARG A   9      45.798  28.627  89.282  1.00 25.74           N  
ATOM     81  CA  ARG A   9      45.654  28.345  87.845  1.00 24.30           C  
ATOM     82  C   ARG A   9      46.560  29.083  86.911  1.00 25.78           C  
ATOM     83  O   ARG A   9      46.807  28.628  85.805  1.00 27.43           O  
ATOM     84  CB  ARG A   9      44.232  28.652  87.390  1.00 27.93           C  
ATOM     85  CG  ARG A   9      43.238  27.609  87.810  1.00 27.65           C  
ATOM     86  CD  ARG A   9      41.814  27.927  87.493  1.00 24.50           C  
ATOM     87  NE  ARG A   9      41.396  27.662  86.116  1.00 21.34           N  
ATOM     88  CZ  ARG A   9      40.136  27.567  85.733  1.00 26.95           C  
ATOM     89  NH1 ARG A   9      39.147  27.704  86.606  1.00 32.80           N  
ATOM     90  NH2 ARG A   9      39.857  27.363  84.446  1.00 35.91           N  
ATOM     91  N   ILE A  10      47.074  30.230  87.331  1.00 22.37           N  
ATOM     92  CA  ILE A  10      47.824  31.093  86.393  1.00 22.66           C  
ATOM     93  C   ILE A  10      49.252  31.298  86.817  1.00 23.30           C  
ATOM     94  O   ILE A  10      49.491  31.911  87.860  1.00 20.08           O  
ATOM     95  CB  ILE A  10      47.078  32.437  86.268  1.00 21.92           C  
ATOM     96  CG1 ILE A  10      45.645  32.174  85.844  1.00 27.16           C  
ATOM     97  CG2 ILE A  10      47.830  33.359  85.283  1.00 24.54           C  
ATOM     98  CD1 ILE A  10      44.779  33.284  86.024  1.00 31.12           C  
ATOM     99  N   PRO A  11      50.231  30.824  85.998  1.00 22.04           N  
ATOM    100  CA  PRO A  11      51.611  31.023  86.364  1.00 23.69           C  
ATOM    101  C   PRO A  11      51.978  32.462  86.535  1.00 22.41           C  
ATOM    102  O   PRO A  11      51.527  33.321  85.765  1.00 21.58           O  
ATOM    103  CB  PRO A  11      52.395  30.477  85.162  1.00 28.65           C  
ATOM    104  CG  PRO A  11      51.501  29.608  84.496  1.00 23.50           C  
ATOM    105  CD  PRO A  11      50.133  30.092  84.714  1.00 24.87           C  
ATOM    106  N   HIS A  12      52.800  32.712  87.526  1.00 21.48           N  
ATOM    107  CA  HIS A  12      53.379  34.015  87.786  1.00 21.94           C  
ATOM    108  C   HIS A  12      52.400  35.093  88.103  1.00 18.95           C  
ATOM    109  O   HIS A  12      52.771  36.261  88.104  1.00 21.52           O  
ATOM    110  CB  HIS A  12      54.269  34.451  86.619  1.00 21.31           C  
ATOM    111  CG  HIS A  12      55.374  33.501  86.347  1.00 27.15           C  
ATOM    112  ND1 HIS A  12      56.514  33.466  87.114  1.00 28.25           N  
ATOM    113  CD2 HIS A  12      55.476  32.487  85.458  1.00 24.73           C  
ATOM    114  CE1 HIS A  12      57.298  32.503  86.664  1.00 34.08           C  
ATOM    115  NE2 HIS A  12      56.697  31.902  85.654  1.00 23.19           N  
ATOM    116  N   LEU A  13      51.190  34.721  88.488  1.00 20.13           N  
ATOM    117  CA  LEU A  13      50.186  35.722  88.730  1.00 18.02           C  
ATOM    118  C   LEU A  13      50.548  36.698  89.834  1.00 18.16           C  
ATOM    119  O   LEU A  13      50.307  37.881  89.729  1.00 18.85           O  
ATOM    120  CB  LEU A  13      48.824  35.086  88.986  1.00 18.45           C  
ATOM    121  CG  LEU A  13      47.669  36.083  89.112  1.00 24.88           C  
ATOM    122  CD1 LEU A  13      47.536  36.868  87.859  1.00 29.02           C  
ATOM    123  CD2 LEU A  13      46.359  35.380  89.399  1.00 26.39           C  
ATOM    124  N   ARG A  14      51.070  36.176  90.944  1.00 18.68           N  
ATOM    125  CA  ARG A  14      51.440  37.023  92.050  1.00 20.11           C  
ATOM    126  C   ARG A  14      52.445  38.101  91.648  1.00 16.13           C  
ATOM    127  O   ARG A  14      52.284  39.273  92.052  1.00 19.15           O  
ATOM    128  CB  ARG A  14      52.061  36.139  93.169  1.00 23.35           C  
ATOM    129  CG  ARG A  14      52.413  36.890  94.446  1.00 27.56           C  
ATOM    130  CD  ARG A  14      52.894  35.949  95.584  1.00 31.13           C  
ATOM    131  N   GLU A  15      53.479  37.686  90.916  1.00 19.75           N  
ATOM    132  CA  GLU A  15      54.539  38.625  90.462  1.00 17.35           C  
ATOM    133  C   GLU A  15      53.964  39.677  89.485  1.00 17.89           C  
ATOM    134  O   GLU A  15      54.203  40.886  89.654  1.00 18.55           O  
ATOM    135  CB  GLU A  15      55.723  37.907  89.848  1.00 21.02           C  
ATOM    136  N   ILE A  16      53.109  39.217  88.595  1.00 18.07           N  
ATOM    137  CA  ILE A  16      52.458  40.163  87.663  1.00 16.99           C  
ATOM    138  C   ILE A  16      51.598  41.150  88.417  1.00 18.55           C  
ATOM    139  O   ILE A  16      51.671  42.336  88.173  1.00 16.82           O  
ATOM    140  CB  ILE A  16      51.672  39.429  86.588  1.00 17.15           C  
ATOM    141  CG1 ILE A  16      52.625  38.592  85.747  1.00 16.17           C  
ATOM    142  CG2 ILE A  16      50.940  40.465  85.696  1.00 20.18           C  
ATOM    143  CD1 ILE A  16      51.919  37.617  84.804  1.00 19.50           C  
ATOM    144  N   LEU A  17      50.775  40.680  89.367  0.50 16.71           N  
ATOM    146  CA  LEU A  17      49.962  41.580  90.177  0.50 15.99           C  
ATOM    148  C   LEU A  17      50.888  42.561  90.881  0.50 16.53           C  
ATOM    150  O   LEU A  17      50.638  43.761  90.937  0.50 16.76           O  
ATOM    152  CB  LEU A  17      49.148  40.825  91.256  0.50 16.50           C  
ATOM    154  CG  LEU A  17      47.946  39.988  90.815  0.50 15.79           C  
ATOM    156  CD1 LEU A  17      47.597  38.960  91.874  0.50 19.35           C  
ATOM    158  CD2 LEU A  17      46.746  40.836  90.511  0.50 18.81           C  
ATOM    160  N   ASN A  18      51.970  42.044  91.431  0.50 15.71           N  
ATOM    162  CA  ASN A  18      52.902  42.906  92.151  0.50 15.59           C  
ATOM    164  C   ASN A  18      53.402  44.083  91.266  0.50 14.35           C  
ATOM    166  O   ASN A  18      53.370  45.240  91.661  0.50 15.98           O  
ATOM    168  CB  ASN A  18      54.067  42.080  92.744  0.50 16.00           C  
ATOM    170  CG  ASN A  18      54.922  42.894  93.689  0.50 18.67           C  
ATOM    172  OD1 ASN A  18      56.150  42.944  93.548  0.50 23.11           O  
ATOM    174  ND2 ASN A  18      54.283  43.518  94.673  0.50 23.35           N  
ATOM    176  N   ILE A  19      53.818  43.732  90.053  1.00 15.96           N  
ATOM    177  CA  ILE A  19      54.362  44.675  89.031  1.00 14.95           C  
ATOM    178  C   ILE A  19      53.293  45.721  88.667  1.00 17.01           C  
ATOM    179  O   ILE A  19      53.577  46.915  88.630  1.00 16.51           O  
ATOM    180  CB  ILE A  19      54.903  43.910  87.830  1.00 15.45           C  
ATOM    181  CG1 ILE A  19      56.213  43.184  88.164  1.00 15.32           C  
ATOM    182  CG2 ILE A  19      55.136  44.845  86.641  1.00 17.50           C  
ATOM    183  CD1 ILE A  19      56.588  42.110  87.151  1.00 17.65           C  
ATOM    184  N   VAL A  20      52.053  45.276  88.497  1.00 16.26           N  
ATOM    185  CA  VAL A  20      50.966  46.168  88.226  1.00 17.81           C  
ATOM    186  C   VAL A  20      50.751  47.139  89.382  1.00 17.37           C  
ATOM    187  O   VAL A  20      50.649  48.338  89.205  1.00 16.67           O  
ATOM    188  CB  VAL A  20      49.667  45.396  87.824  1.00 18.94           C  
ATOM    189  CG1 VAL A  20      48.529  46.348  87.729  1.00 21.56           C  
ATOM    190  CG2 VAL A  20      49.875  44.595  86.523  1.00 21.14           C  
ATOM    191  N   ARG A  21      50.757  46.639  90.617  1.00 16.48           N  
ATOM    192  CA  ARG A  21      50.612  47.532  91.765  1.00 18.26           C  
ATOM    193  C   ARG A  21      51.708  48.604  91.795  1.00 17.32           C  
ATOM    194  O   ARG A  21      51.438  49.777  92.045  1.00 18.68           O  
ATOM    195  CB  ARG A  21      50.618  46.720  93.076  1.00 20.91           C  
ATOM    196  CG  ARG A  21      49.364  45.867  93.215  1.00 26.55           C  
ATOM    197  CD  ARG A  21      49.336  45.001  94.489  1.00 31.64           C  
ATOM    198  NE  ARG A  21      49.281  45.818  95.691  1.00 46.28           N  
ATOM    199  N   GLU A  22      52.930  48.170  91.552  1.00 16.56           N  
ATOM    200  CA  GLU A  22      54.080  49.060  91.505  1.00 18.05           C  
ATOM    201  C   GLU A  22      53.938  50.098  90.385  1.00 18.21           C  
ATOM    202  O   GLU A  22      54.257  51.269  90.582  1.00 17.94           O  
ATOM    203  CB  GLU A  22      55.357  48.244  91.348  1.00 15.33           C  
ATOM    204  CG  GLU A  22      55.721  47.478  92.616  1.00 18.26           C  
ATOM    205  CD  GLU A  22      56.736  46.377  92.434  1.00 25.83           C  
ATOM    206  OE1 GLU A  22      57.049  45.927  91.303  1.00 24.97           O  
ATOM    207  OE2 GLU A  22      57.222  45.931  93.508  1.00 25.20           O  
ATOM    208  N   ALA A  23      53.458  49.672  89.215  1.00 14.59           N  
ATOM    209  CA  ALA A  23      53.262  50.633  88.108  1.00 15.76           C  
ATOM    210  C   ALA A  23      52.299  51.743  88.432  1.00 15.27           C  
ATOM    211  O   ALA A  23      52.417  52.886  87.944  1.00 16.98           O  
ATOM    212  CB  ALA A  23      52.792  49.879  86.866  1.00 15.77           C  
ATOM    213  N   PHE A  24      51.265  51.392  89.197  1.00 15.80           N  
ATOM    214  CA  PHE A  24      50.206  52.326  89.558  1.00 16.93           C  
ATOM    215  C   PHE A  24      50.445  53.123  90.842  1.00 19.08           C  
ATOM    216  O   PHE A  24      49.631  53.973  91.184  1.00 21.30           O  
ATOM    217  CB  PHE A  24      48.836  51.627  89.637  1.00 16.87           C  
ATOM    218  CG  PHE A  24      48.207  51.392  88.300  1.00 16.17           C  
ATOM    219  CD1 PHE A  24      48.469  50.245  87.569  1.00 18.52           C  
ATOM    220  CD2 PHE A  24      47.369  52.345  87.775  1.00 19.87           C  
ATOM    221  CE1 PHE A  24      47.849  50.018  86.329  1.00 16.42           C  
ATOM    222  CE2 PHE A  24      46.790  52.182  86.507  1.00 17.67           C  
ATOM    223  CZ  PHE A  24      47.056  51.007  85.776  1.00 17.76           C  
ATOM    224  N   LYS A  25      51.556  52.867  91.517  1.00 21.39           N  
ATOM    225  CA  LYS A  25      51.869  53.510  92.796  1.00 26.98           C  
ATOM    226  C   LYS A  25      51.863  54.994  92.536  1.00 29.69           C  
ATOM    227  O   LYS A  25      52.559  55.448  91.647  1.00 30.15           O  
ATOM    228  CB  LYS A  25      53.233  53.022  93.287  1.00 29.57           C  
ATOM    229  CG  LYS A  25      53.620  53.531  94.659  1.00 39.68           C  
ATOM    230  CD  LYS A  25      54.692  52.638  95.310  1.00 47.05           C  
ATOM    231  N   ASP A  26      51.056  55.749  93.261  1.00 32.61           N  
ATOM    232  CA  ASP A  26      50.980  57.215  93.007  1.00 37.29           C  
ATOM    233  C   ASP A  26      50.342  57.677  91.664  1.00 38.32           C  
ATOM    234  O   ASP A  26      50.642  58.762  91.165  1.00 43.00           O  
ATOM    235  CB  ASP A  26      52.365  57.881  93.168  1.00 38.13           C  
ATOM    236  N   TYR A  27      49.509  56.843  91.060  1.00 34.39           N  
ATOM    237  CA  TYR A  27      48.701  57.259  89.927  1.00 30.49           C  
ATOM    238  C   TYR A  27      47.275  57.058  90.444  1.00 34.00           C  
ATOM    239  O   TYR A  27      46.772  55.929  90.494  1.00 37.55           O  
ATOM    240  CB  TYR A  27      48.946  56.395  88.704  1.00 29.16           C  
ATOM    241  CG  TYR A  27      48.076  56.789  87.539  1.00 21.32           C  
ATOM    242  CD1 TYR A  27      48.194  58.022  86.947  1.00 28.41           C  
ATOM    243  CD2 TYR A  27      47.135  55.912  87.023  1.00 26.12           C  
ATOM    244  CE1 TYR A  27      47.404  58.378  85.872  1.00 25.37           C  
ATOM    245  CE2 TYR A  27      46.362  56.253  85.934  1.00 25.19           C  
ATOM    246  CZ  TYR A  27      46.501  57.481  85.365  1.00 28.48           C  
ATOM    247  OH  TYR A  27      45.724  57.819  84.310  1.00 28.04           O  
ATOM    248  N   ASP A  28      46.632  58.153  90.831  1.00 36.91           N  
ATOM    249  CA  ASP A  28      45.322  58.077  91.504  1.00 39.03           C  
ATOM    250  C   ASP A  28      44.130  58.627  90.731  1.00 41.30           C  
ATOM    251  O   ASP A  28      43.081  58.878  91.346  1.00 44.11           O  
ATOM    252  CB  ASP A  28      45.401  58.805  92.867  1.00 39.29           C  
ATOM    253  N   ASP A  29      44.272  58.840  89.425  1.00 40.18           N  
ATOM    254  CA  ASP A  29      43.158  59.313  88.624  1.00 40.53           C  
ATOM    255  C   ASP A  29      42.034  58.283  88.783  1.00 41.92           C  
ATOM    256  O   ASP A  29      42.187  57.133  88.365  1.00 38.83           O  
ATOM    257  CB  ASP A  29      43.570  59.468  87.162  1.00 39.54           C  
ATOM    258  CG  ASP A  29      42.471  60.027  86.300  1.00 39.88           C  
ATOM    259  OD1 ASP A  29      41.277  59.882  86.639  1.00 48.90           O  
ATOM    260  OD2 ASP A  29      42.800  60.593  85.244  1.00 39.44           O  
ATOM    261  N   PRO A  30      40.886  58.700  89.377  1.00 43.65           N  
ATOM    262  CA  PRO A  30      39.787  57.766  89.645  1.00 44.22           C  
ATOM    263  C   PRO A  30      39.185  57.149  88.390  1.00 43.18           C  
ATOM    264  O   PRO A  30      38.533  56.105  88.475  1.00 44.20           O  
ATOM    265  CB  PRO A  30      38.752  58.643  90.358  1.00 45.11           C  
ATOM    266  CG  PRO A  30      39.035  60.010  89.870  1.00 45.92           C  
ATOM    267  CD  PRO A  30      40.525  60.068  89.797  1.00 45.68           C  
ATOM    268  N   ALA A  31      39.400  57.799  87.251  1.00 40.34           N  
ATOM    269  CA  ALA A  31      38.939  57.282  85.981  1.00 38.86           C  
ATOM    270  C   ALA A  31      39.859  56.166  85.422  1.00 38.55           C  
ATOM    271  O   ALA A  31      39.467  55.415  84.514  1.00 39.76           O  
ATOM    272  CB  ALA A  31      38.855  58.429  84.983  1.00 40.02           C  
ATOM    273  N   HIS A  32      41.074  56.043  85.955  1.00 34.02           N  
ATOM    274  CA  HIS A  32      42.037  55.121  85.384  1.00 30.76           C  
ATOM    275  C   HIS A  32      42.931  54.446  86.400  1.00 29.89           C  
ATOM    276  O   HIS A  32      43.984  53.949  86.019  1.00 28.37           O  
ATOM    277  CB  HIS A  32      42.959  55.896  84.440  1.00 29.98           C  
ATOM    278  CG  HIS A  32      42.244  56.647  83.378  1.00 33.20           C  
ATOM    279  ND1 HIS A  32      41.688  56.024  82.283  1.00 35.32           N  
ATOM    280  CD2 HIS A  32      42.001  57.969  83.226  1.00 34.74           C  
ATOM    281  CE1 HIS A  32      41.124  56.930  81.504  1.00 37.69           C  
ATOM    282  NE2 HIS A  32      41.295  58.119  82.057  1.00 39.34           N  
ATOM    283  N   ASP A  33      42.538  54.426  87.667  1.00 28.29           N  
ATOM    284  CA  ASP A  33      43.403  53.883  88.698  1.00 26.79           C  
ATOM    285  C   ASP A  33      43.452  52.363  88.680  1.00 23.97           C  
ATOM    286  O   ASP A  33      42.752  51.702  87.911  1.00 25.87           O  
ATOM    287  CB  ASP A  33      43.021  54.445  90.076  1.00 29.26           C  
ATOM    288  CG  ASP A  33      41.651  53.990  90.551  1.00 33.05           C  
ATOM    289  OD1 ASP A  33      41.101  52.994  90.044  1.00 38.11           O  
ATOM    290  OD2 ASP A  33      41.114  54.667  91.439  1.00 42.28           O  
ATOM    291  N   ILE A  34      44.264  51.804  89.557  1.00 22.40           N  
ATOM    292  CA  ILE A  34      44.449  50.385  89.598  1.00 18.13           C  
ATOM    293  C   ILE A  34      43.189  49.559  89.833  1.00 19.08           C  
ATOM    294  O   ILE A  34      43.072  48.420  89.350  1.00 19.05           O  
ATOM    295  CB  ILE A  34      45.526  49.986  90.615  1.00 20.55           C  
ATOM    296  CG1 ILE A  34      45.991  48.571  90.337  1.00 23.24           C  
ATOM    297  CG2 ILE A  34      45.041  50.194  92.031  1.00 22.69           C  
ATOM    298  CD1 ILE A  34      47.139  48.147  91.128  1.00 26.52           C  
ATOM    299  N   SER A  35      42.214  50.126  90.529  1.00 20.36           N  
ATOM    300  CA  SER A  35      41.021  49.328  90.817  1.00 18.93           C  
ATOM    301  C   SER A  35      40.284  48.991  89.518  1.00 17.33           C  
ATOM    302  O   SER A  35      39.672  47.936  89.444  1.00 17.65           O  
ATOM    303  CB  SER A  35      40.121  50.033  91.837  1.00 20.52           C  
ATOM    304  OG  SER A  35      39.563  51.189  91.310  1.00 23.09           O  
ATOM    305  N   HIS A  36      40.334  49.880  88.526  1.00 17.40           N  
ATOM    306  CA  HIS A  36      39.805  49.565  87.202  1.00 17.55           C  
ATOM    307  C   HIS A  36      40.423  48.243  86.654  1.00 16.26           C  
ATOM    308  O   HIS A  36      39.721  47.322  86.216  1.00 15.98           O  
ATOM    309  CB  HIS A  36      39.994  50.714  86.234  1.00 16.38           C  
ATOM    310  CG  HIS A  36      39.865  50.325  84.803  1.00 16.86           C  
ATOM    311  ND1 HIS A  36      38.649  50.071  84.193  1.00 17.89           N  
ATOM    312  CD2 HIS A  36      40.819  50.063  83.875  1.00 19.19           C  
ATOM    313  CE1 HIS A  36      38.864  49.758  82.925  1.00 18.82           C  
ATOM    314  NE2 HIS A  36      40.172  49.746  82.707  1.00 18.24           N  
ATOM    315  N   THR A  37      41.741  48.141  86.697  1.00 15.19           N  
ATOM    316  CA  THR A  37      42.424  46.932  86.216  1.00 13.64           C  
ATOM    317  C   THR A  37      41.945  45.681  86.925  1.00 14.20           C  
ATOM    318  O   THR A  37      41.680  44.653  86.319  1.00 14.95           O  
ATOM    319  CB  THR A  37      43.959  47.099  86.340  1.00 13.65           C  
ATOM    320  OG1 THR A  37      44.372  48.033  85.324  1.00 15.93           O  
ATOM    321  CG2 THR A  37      44.617  45.857  86.084  1.00 13.42           C  
ATOM    322  N   PHE A  38      41.767  45.775  88.240  1.00 16.26           N  
ATOM    323  CA  PHE A  38      41.289  44.603  88.942  1.00 17.39           C  
ATOM    324  C   PHE A  38      39.857  44.258  88.559  1.00 14.97           C  
ATOM    325  O   PHE A  38      39.541  43.094  88.385  1.00 18.78           O  
ATOM    326  CB  PHE A  38      41.391  44.807  90.444  1.00 19.45           C  
ATOM    327  CG  PHE A  38      42.790  45.016  90.926  1.00 27.73           C  
ATOM    328  CD1 PHE A  38      43.839  44.290  90.388  1.00 32.65           C  
ATOM    329  CD2 PHE A  38      43.054  45.919  91.938  1.00 33.43           C  
ATOM    330  CE1 PHE A  38      45.137  44.476  90.829  1.00 35.54           C  
ATOM    331  CE2 PHE A  38      44.347  46.094  92.408  1.00 34.89           C  
ATOM    332  CZ  PHE A  38      45.394  45.363  91.847  1.00 35.27           C  
ATOM    333  N   ARG A  39      39.009  45.262  88.350  1.00 16.05           N  
ATOM    334  CA  ARG A  39      37.627  44.973  87.932  1.00 16.84           C  
ATOM    335  C   ARG A  39      37.594  44.365  86.524  1.00 15.76           C  
ATOM    336  O   ARG A  39      36.781  43.495  86.217  1.00 15.74           O  
ATOM    337  CB  ARG A  39      36.771  46.234  88.036  1.00 16.15           C  
ATOM    338  CG  ARG A  39      36.600  46.682  89.500  1.00 19.50           C  
ATOM    339  CD  ARG A  39      35.549  47.722  89.642  1.00 19.48           C  
ATOM    340  NE  ARG A  39      35.804  48.891  88.817  1.00 19.29           N  
ATOM    341  CZ  ARG A  39      36.530  49.964  89.169  1.00 17.83           C  
ATOM    342  NH1 ARG A  39      37.074  50.096  90.356  1.00 23.42           N  
ATOM    343  NH2 ARG A  39      36.719  50.907  88.290  1.00 18.78           N  
ATOM    344  N   VAL A  40      38.469  44.867  85.647  1.00 14.57           N  
ATOM    345  CA  VAL A  40      38.572  44.316  84.272  1.00 16.68           C  
ATOM    346  C   VAL A  40      39.032  42.856  84.330  1.00 14.76           C  
ATOM    347  O   VAL A  40      38.525  41.983  83.617  1.00 14.01           O  
ATOM    348  CB  VAL A  40      39.465  45.198  83.376  1.00 16.34           C  
ATOM    349  CG1 VAL A  40      39.659  44.531  81.964  1.00 15.26           C  
ATOM    350  CG2 VAL A  40      38.811  46.538  83.186  1.00 15.39           C  
HETATM  351  N   MSE A  41      40.002  42.554  85.175  0.50 16.83           N  
HETATM  353  CA  MSE A  41      40.411  41.195  85.274  0.50 19.17           C  
HETATM  355  C   MSE A  41      39.281  40.298  85.828  0.50 17.16           C  
HETATM  357  O   MSE A  41      39.111  39.178  85.358  0.50 18.68           O  
HETATM  359  CB  MSE A  41      41.701  41.081  86.031  0.50 22.27           C  
HETATM  361  CG  MSE A  41      42.146  39.664  86.082  0.50 23.37           C  
HETATM  363 SE   MSE A  41      41.517  38.903  87.711  0.37 40.64          SE  
HETATM  365  CE  MSE A  41      42.721  39.619  88.546  0.50  2.00           C  
ATOM    367  N   GLU A  42      38.492  40.800  86.774  1.00 16.94           N  
ATOM    368  CA  GLU A  42      37.338  40.025  87.270  1.00 19.88           C  
ATOM    369  C   GLU A  42      36.361  39.766  86.133  1.00 17.43           C  
ATOM    370  O   GLU A  42      35.877  38.631  85.979  1.00 20.58           O  
ATOM    371  CB  GLU A  42      36.634  40.755  88.423  1.00 23.27           C  
ATOM    372  CG  GLU A  42      37.493  40.843  89.669  1.00 35.69           C  
ATOM    373  CD  GLU A  42      37.814  39.483  90.281  1.00 47.38           C  
ATOM    374  OE1 GLU A  42      37.045  38.521  90.039  1.00 53.85           O  
ATOM    375  OE2 GLU A  42      38.826  39.391  91.018  1.00 46.64           O  
ATOM    376  N   ASN A  43      36.071  40.777  85.318  1.00 17.12           N  
ATOM    377  CA  ASN A  43      35.178  40.619  84.169  1.00 15.08           C  
ATOM    378  C   ASN A  43      35.756  39.622  83.169  1.00 17.48           C  
ATOM    379  O   ASN A  43      35.056  38.757  82.644  1.00 16.59           O  
ATOM    380  CB  ASN A  43      34.988  41.927  83.461  1.00 15.92           C  
ATOM    381  CG  ASN A  43      34.310  42.978  84.292  1.00 21.16           C  
ATOM    382  OD1 ASN A  43      33.643  42.675  85.285  1.00 19.82           O  
ATOM    383  ND2 ASN A  43      34.455  44.216  83.878  1.00 16.90           N  
ATOM    384  N   ALA A  44      37.057  39.721  82.906  1.00 16.05           N  
ATOM    385  CA  ALA A  44      37.704  38.796  81.964  1.00 14.97           C  
ATOM    386  C   ALA A  44      37.667  37.360  82.452  1.00 15.11           C  
ATOM    387  O   ALA A  44      37.517  36.435  81.636  1.00 14.67           O  
ATOM    388  CB  ALA A  44      39.152  39.209  81.713  1.00 14.55           C  
ATOM    389  N   SER A  45      37.786  37.183  83.770  1.00 17.90           N  
ATOM    390  CA  SER A  45      37.753  35.859  84.387  1.00 20.89           C  
ATOM    391  C   SER A  45      36.374  35.208  84.154  1.00 19.73           C  
ATOM    392  O   SER A  45      36.270  34.039  83.751  1.00 20.73           O  
ATOM    393  CB  SER A  45      38.001  35.988  85.881  1.00 22.24           C  
ATOM    394  OG  SER A  45      37.959  34.732  86.487  1.00 28.26           O  
ATOM    395  N   GLU A  46      35.330  35.982  84.385  0.50 19.98           N  
ATOM    397  CA  GLU A  46      33.951  35.508  84.171  0.50 20.96           C  
ATOM    399  C   GLU A  46      33.730  35.137  82.695  0.50 20.56           C  
ATOM    401  O   GLU A  46      33.284  34.012  82.327  0.50 15.41           O  
ATOM    403  CB  GLU A  46      32.958  36.609  84.552  0.50 20.23           C  
ATOM    405  CG  GLU A  46      33.112  37.235  85.941  0.50 23.22           C  
ATOM    407  N   ILE A  47      34.119  36.061  81.824  1.00 17.80           N  
ATOM    408  CA  ILE A  47      33.865  35.893  80.413  1.00 15.52           C  
ATOM    409  C   ILE A  47      34.619  34.653  79.870  1.00 16.29           C  
ATOM    410  O   ILE A  47      34.020  33.770  79.220  1.00 17.66           O  
ATOM    411  CB  ILE A  47      34.248  37.145  79.636  1.00 15.62           C  
ATOM    412  CG1 ILE A  47      33.324  38.307  80.028  1.00 15.52           C  
ATOM    413  CG2 ILE A  47      34.192  36.883  78.139  1.00 18.72           C  
ATOM    414  CD1 ILE A  47      33.874  39.652  79.593  1.00 18.60           C  
ATOM    415  N   ALA A  48      35.931  34.586  80.104  1.00 17.75           N  
ATOM    416  CA  ALA A  48      36.746  33.481  79.590  1.00 18.18           C  
ATOM    417  C   ALA A  48      36.276  32.110  80.120  1.00 21.61           C  
ATOM    418  O   ALA A  48      36.204  31.120  79.384  1.00 21.38           O  
ATOM    419  CB  ALA A  48      38.207  33.729  79.910  1.00 17.38           C  
ATOM    420  N   SER A  49      35.939  32.061  81.390  1.00 19.35           N  
ATOM    421  CA  SER A  49      35.405  30.837  81.962  1.00 22.59           C  
ATOM    422  C   SER A  49      34.119  30.414  81.277  1.00 20.50           C  
ATOM    423  O   SER A  49      33.968  29.282  80.818  1.00 22.69           O  
ATOM    424  CB  SER A  49      35.141  31.037  83.445  1.00 22.57           C  
ATOM    425  OG  SER A  49      36.348  31.111  84.133  1.00 33.73           O  
ATOM    426  N   ARG A  50      33.180  31.318  81.154  1.00 18.11           N  
ATOM    427  CA  ARG A  50      31.890  30.942  80.560  1.00 21.35           C  
ATOM    428  C   ARG A  50      31.951  30.694  79.045  1.00 21.56           C  
ATOM    429  O   ARG A  50      31.195  29.897  78.511  1.00 23.11           O  
ATOM    430  CB  ARG A  50      30.834  31.987  80.878  1.00 20.53           C  
ATOM    431  CG  ARG A  50      30.494  31.981  82.354  1.00 24.95           C  
ATOM    432  CD  ARG A  50      29.484  33.019  82.736  1.00 31.15           C  
ATOM    433  NE  ARG A  50      29.278  33.024  84.187  1.00 38.97           N  
ATOM    434  N   GLU A  51      32.867  31.359  78.360  1.00 19.21           N  
ATOM    435  CA  GLU A  51      33.054  31.184  76.917  1.00 19.45           C  
ATOM    436  C   GLU A  51      33.932  29.978  76.572  1.00 21.99           C  
ATOM    437  O   GLU A  51      34.110  29.650  75.413  1.00 21.26           O  
ATOM    438  CB  GLU A  51      33.702  32.454  76.358  1.00 20.02           C  
ATOM    439  CG  GLU A  51      32.796  33.663  76.453  1.00 20.60           C  
ATOM    440  CD  GLU A  51      31.639  33.656  75.490  1.00 19.22           C  
ATOM    441  OE1 GLU A  51      31.772  33.202  74.347  1.00 22.76           O  
ATOM    442  OE2 GLU A  51      30.554  34.194  75.826  1.00 17.43           O  
ATOM    443  N   LYS A  52      34.498  29.343  77.587  1.00 22.05           N  
ATOM    444  CA  LYS A  52      35.351  28.169  77.404  1.00 25.80           C  
ATOM    445  C   LYS A  52      36.589  28.577  76.579  1.00 25.16           C  
ATOM    446  O   LYS A  52      37.057  27.839  75.713  1.00 26.03           O  
ATOM    447  CB  LYS A  52      34.581  26.994  76.749  1.00 27.63           C  
ATOM    448  CG  LYS A  52      33.172  26.720  77.304  1.00 33.18           C  
ATOM    449  CD  LYS A  52      33.200  26.172  78.714  1.00 39.89           C  
ATOM    450  CE  LYS A  52      31.800  25.666  79.118  1.00 45.17           C  
ATOM    451  NZ  LYS A  52      31.824  24.975  80.451  1.00 48.72           N  
ATOM    452  N   CYS A  53      37.117  29.767  76.861  1.00 21.99           N  
ATOM    453  CA  CYS A  53      38.298  30.301  76.199  1.00 22.17           C  
ATOM    454  C   CYS A  53      39.498  30.208  77.126  1.00 22.17           C  
ATOM    455  O   CYS A  53      39.386  29.671  78.232  1.00 22.88           O  
ATOM    456  CB  CYS A  53      38.010  31.738  75.717  1.00 18.23           C  
ATOM    457  SG  CYS A  53      36.853  31.746  74.307  1.00 28.41           S  
ATOM    458  N   ASP A  54      40.653  30.680  76.684  1.00 20.80           N  
ATOM    459  CA  ASP A  54      41.891  30.600  77.434  1.00 18.70           C  
ATOM    460  C   ASP A  54      41.932  31.626  78.578  1.00 17.75           C  
ATOM    461  O   ASP A  54      42.196  32.811  78.385  1.00 17.32           O  
ATOM    462  CB  ASP A  54      43.040  30.801  76.447  1.00 20.07           C  
ATOM    463  CG  ASP A  54      44.390  30.476  77.025  1.00 24.21           C  
ATOM    464  OD1 ASP A  54      44.649  30.749  78.188  1.00 24.53           O  
ATOM    465  OD2 ASP A  54      45.222  29.972  76.242  1.00 29.22           O  
ATOM    466  N   LEU A  55      41.731  31.149  79.802  1.00 17.03           N  
ATOM    467  CA  LEU A  55      41.710  31.995  80.978  1.00 16.58           C  
ATOM    468  C   LEU A  55      43.052  32.680  81.254  1.00 14.88           C  
ATOM    469  O   LEU A  55      43.087  33.836  81.669  1.00 17.73           O  
ATOM    470  CB  LEU A  55      41.346  31.124  82.219  1.00 17.81           C  
ATOM    471  CG  LEU A  55      41.191  31.822  83.548  1.00 22.89           C  
ATOM    472  CD1 LEU A  55      39.980  32.769  83.487  1.00 28.71           C  
ATOM    473  CD2 LEU A  55      41.028  30.789  84.691  1.00 22.95           C  
ATOM    474  N   GLN A  56      44.156  31.939  81.073  1.00 13.27           N  
ATOM    475  CA  GLN A  56      45.478  32.465  81.339  1.00 16.75           C  
ATOM    476  C   GLN A  56      45.735  33.722  80.479  1.00 11.91           C  
ATOM    477  O   GLN A  56      46.189  34.732  80.996  1.00 14.86           O  
ATOM    478  CB  GLN A  56      46.572  31.415  81.125  1.00 17.51           C  
ATOM    479  CG  GLN A  56      46.437  30.209  82.078  1.00 20.66           C  
ATOM    480  CD  GLN A  56      47.623  29.282  82.054  1.00 27.35           C  
ATOM    481  OE1 GLN A  56      48.602  29.506  81.343  1.00 30.69           O  
ATOM    482  NE2 GLN A  56      47.561  28.232  82.884  1.00 27.22           N  
ATOM    483  N   LYS A  57      45.485  33.580  79.182  1.00 14.04           N  
ATOM    484  CA  LYS A  57      45.655  34.729  78.268  1.00 12.36           C  
ATOM    485  C   LYS A  57      44.750  35.918  78.655  1.00  9.99           C  
ATOM    486  O   LYS A  57      45.225  37.010  78.716  1.00 12.60           O  
ATOM    487  CB  LYS A  57      45.378  34.311  76.815  1.00 12.26           C  
ATOM    488  CG  LYS A  57      46.443  33.441  76.152  1.00 16.84           C  
ATOM    489  CD  LYS A  57      46.024  32.942  74.734  1.00 15.55           C  
ATOM    490  CE  LYS A  57      47.071  32.043  74.109  1.00 23.23           C  
ATOM    491  NZ  LYS A  57      46.594  31.413  72.861  1.00 31.08           N  
ATOM    492  N   ALA A  58      43.491  35.636  78.961  1.00 12.39           N  
ATOM    493  CA  ALA A  58      42.516  36.658  79.294  1.00 14.11           C  
ATOM    494  C   ALA A  58      42.868  37.434  80.549  1.00 12.10           C  
ATOM    495  O   ALA A  58      42.857  38.646  80.573  1.00 14.84           O  
ATOM    496  CB  ALA A  58      41.161  36.025  79.367  1.00 14.00           C  
ATOM    497  N   ILE A  59      43.243  36.698  81.603  0.50 13.36           N  
ATOM    499  CA  ILE A  59      43.619  37.300  82.858  0.50 13.76           C  
ATOM    501  C   ILE A  59      44.863  38.166  82.762  0.50 13.05           C  
ATOM    503  O   ILE A  59      44.884  39.285  83.274  0.50 12.78           O  
ATOM    505  CB  ILE A  59      43.886  36.194  83.914  0.50 13.80           C  
ATOM    507  CG1 ILE A  59      42.564  35.548  84.292  0.50 14.70           C  
ATOM    509  CG2 ILE A  59      44.601  36.717  85.144  0.50 10.53           C  
ATOM    511  CD1 ILE A  59      41.528  36.515  84.941  0.50 13.30           C  
ATOM    513  N   ILE A  60      45.895  37.598  82.139  1.00 14.02           N  
ATOM    514  CA  ILE A  60      47.165  38.298  81.987  1.00 10.45           C  
ATOM    515  C   ILE A  60      46.982  39.542  81.107  1.00 10.07           C  
ATOM    516  O   ILE A  60      47.478  40.611  81.459  1.00 12.80           O  
ATOM    517  CB  ILE A  60      48.293  37.359  81.556  1.00 12.31           C  
ATOM    518  CG1 ILE A  60      48.586  36.375  82.740  1.00 15.75           C  
ATOM    519  CG2 ILE A  60      49.536  38.116  81.186  1.00 13.73           C  
ATOM    520  CD1 ILE A  60      49.558  35.310  82.385  1.00 19.54           C  
ATOM    521  N   ALA A  61      46.215  39.386  80.037  1.00 12.51           N  
ATOM    522  CA  ALA A  61      45.998  40.550  79.208  1.00 12.27           C  
ATOM    523  C   ALA A  61      45.244  41.659  79.980  1.00 12.11           C  
ATOM    524  O   ALA A  61      45.568  42.828  79.895  1.00 12.91           O  
ATOM    525  CB  ALA A  61      45.214  40.128  78.074  1.00 10.81           C  
ATOM    526  N   ALA A  62      44.221  41.284  80.742  1.00 11.40           N  
ATOM    527  CA  ALA A  62      43.508  42.242  81.573  1.00 11.30           C  
ATOM    528  C   ALA A  62      44.406  42.919  82.597  1.00 14.76           C  
ATOM    529  O   ALA A  62      44.320  44.114  82.809  1.00 15.30           O  
ATOM    530  CB  ALA A  62      42.367  41.556  82.285  1.00 15.86           C  
ATOM    531  N   LEU A  63      45.239  42.127  83.271  1.00 14.23           N  
ATOM    532  CA  LEU A  63      46.154  42.719  84.271  1.00 14.19           C  
ATOM    533  C   LEU A  63      47.125  43.722  83.665  1.00 14.51           C  
ATOM    534  O   LEU A  63      47.436  44.751  84.252  1.00 14.05           O  
ATOM    535  CB  LEU A  63      46.903  41.625  85.033  1.00 16.55           C  
ATOM    536  CG  LEU A  63      46.215  41.102  86.268  1.00 27.30           C  
ATOM    537  CD1 LEU A  63      47.137  40.055  86.841  1.00 29.84           C  
ATOM    538  CD2 LEU A  63      46.023  42.302  87.258  1.00 25.93           C  
ATOM    539  N   LEU A  64      47.621  43.397  82.469  1.00 13.93           N  
ATOM    540  CA  LEU A  64      48.611  44.249  81.821  1.00 12.35           C  
ATOM    541  C   LEU A  64      48.066  45.334  80.894  1.00 12.22           C  
ATOM    542  O   LEU A  64      48.809  46.241  80.529  1.00 14.17           O  
ATOM    543  CB  LEU A  64      49.580  43.402  81.013  1.00 12.96           C  
ATOM    544  CG  LEU A  64      50.474  42.518  81.869  1.00 12.65           C  
ATOM    545  CD1 LEU A  64      51.280  41.589  80.962  1.00 18.76           C  
ATOM    546  CD2 LEU A  64      51.351  43.305  82.789  1.00 16.43           C  
ATOM    547  N   HIS A  65      46.773  45.306  80.619  1.00 11.59           N  
ATOM    548  CA  HIS A  65      46.294  46.135  79.479  1.00 11.20           C  
ATOM    549  C   HIS A  65      46.484  47.636  79.671  1.00 12.13           C  
ATOM    550  O   HIS A  65      46.766  48.321  78.728  1.00 13.73           O  
ATOM    551  CB  HIS A  65      44.861  45.812  79.090  1.00 13.21           C  
ATOM    552  CG  HIS A  65      43.822  46.507  79.904  1.00 14.51           C  
ATOM    553  ND1 HIS A  65      43.544  46.180  81.205  1.00 12.48           N  
ATOM    554  CD2 HIS A  65      42.975  47.513  79.577  1.00 13.89           C  
ATOM    555  CE1 HIS A  65      42.586  46.975  81.661  1.00 12.00           C  
ATOM    556  NE2 HIS A  65      42.224  47.803  80.684  1.00 13.76           N  
ATOM    557  N   ASP A  66      46.341  48.121  80.897  1.00 12.02           N  
ATOM    558  CA  ASP A  66      46.526  49.533  81.206  1.00 11.80           C  
ATOM    559  C   ASP A  66      47.794  49.811  82.046  1.00 12.65           C  
ATOM    560  O   ASP A  66      47.874  50.885  82.674  1.00 13.01           O  
ATOM    561  CB  ASP A  66      45.299  50.041  81.934  1.00 12.57           C  
ATOM    562  CG  ASP A  66      44.123  50.315  80.996  1.00 16.69           C  
ATOM    563  OD1 ASP A  66      44.255  50.508  79.753  1.00 13.67           O  
ATOM    564  OD2 ASP A  66      42.977  50.399  81.528  1.00 15.36           O  
ATOM    565  N   ILE A  67      48.778  48.892  82.009  1.00 14.10           N  
ATOM    566  CA  ILE A  67      49.954  49.053  82.849  1.00 15.93           C  
ATOM    567  C   ILE A  67      50.776  50.278  82.450  1.00 13.35           C  
ATOM    568  O   ILE A  67      51.447  50.862  83.291  1.00 12.42           O  
ATOM    569  CB  ILE A  67      50.792  47.778  82.935  1.00 14.89           C  
ATOM    570  CG1 ILE A  67      51.652  47.795  84.231  1.00 14.92           C  
ATOM    571  CG2 ILE A  67      51.658  47.555  81.677  1.00 15.08           C  
ATOM    572  CD1 ILE A  67      52.531  46.600  84.409  1.00 19.45           C  
ATOM    573  N   LYS A  68      50.594  50.761  81.205  1.00 13.56           N  
ATOM    574  CA  LYS A  68      51.302  51.931  80.755  1.00 13.04           C  
ATOM    575  C   LYS A  68      50.408  53.173  80.776  1.00 12.79           C  
ATOM    576  O   LYS A  68      50.777  54.234  80.221  1.00 13.20           O  
ATOM    577  CB  LYS A  68      51.969  51.691  79.411  1.00 13.66           C  
ATOM    578  CG  LYS A  68      53.152  50.778  79.466  1.00 12.42           C  
ATOM    579  CD  LYS A  68      54.372  51.499  80.027  1.00 16.75           C  
ATOM    580  CE  LYS A  68      55.517  50.510  80.108  1.00 23.21           C  
ATOM    581  NZ  LYS A  68      56.765  51.192  80.506  1.00 22.68           N  
ATOM    582  N   ARG A  69      49.277  53.089  81.444  1.00 13.33           N  
ATOM    583  CA  ARG A  69      48.424  54.285  81.596  1.00 13.90           C  
ATOM    584  C   ARG A  69      49.131  55.400  82.372  1.00 14.08           C  
ATOM    585  O   ARG A  69      49.086  56.558  81.980  1.00 15.20           O  
ATOM    586  CB  ARG A  69      47.073  53.973  82.254  1.00 15.71           C  
ATOM    587  CG  ARG A  69      45.951  53.816  81.325  1.00 27.43           C  
ATOM    588  CD  ARG A  69      45.490  55.156  80.846  1.00 27.95           C  
ATOM    589  NE  ARG A  69      44.336  55.043  79.974  1.00 32.46           N  
ATOM    590  CZ  ARG A  69      43.797  56.061  79.318  1.00 33.04           C  
ATOM    591  NH1 ARG A  69      44.313  57.272  79.426  1.00 34.21           N  
ATOM    592  NH2 ARG A  69      42.745  55.854  78.533  1.00 34.54           N  
ATOM    593  N   PRO A  70      49.739  55.053  83.496  1.00 14.65           N  
ATOM    594  CA  PRO A  70      50.462  56.106  84.199  1.00 13.24           C  
ATOM    595  C   PRO A  70      51.558  56.725  83.325  1.00 14.69           C  
ATOM    596  O   PRO A  70      51.718  57.944  83.297  1.00 16.53           O  
ATOM    597  CB  PRO A  70      51.059  55.345  85.403  1.00 13.07           C  
ATOM    598  CG  PRO A  70      50.085  54.243  85.650  1.00 16.62           C  
ATOM    599  CD  PRO A  70      49.680  53.799  84.275  1.00 15.63           C  
ATOM    600  N   HIS A  71      52.250  55.892  82.532  1.00 13.13           N  
ATOM    601  CA  HIS A  71      53.270  56.383  81.656  1.00 13.08           C  
ATOM    602  C   HIS A  71      52.683  57.313  80.585  1.00 14.55           C  
ATOM    603  O   HIS A  71      53.317  58.330  80.278  1.00 15.45           O  
ATOM    604  CB  HIS A  71      54.032  55.208  81.063  1.00 16.11           C  
ATOM    605  CG  HIS A  71      55.063  55.603  80.057  1.00 18.30           C  
ATOM    606  ND1 HIS A  71      56.323  56.031  80.421  1.00 26.10           N  
ATOM    607  CD2 HIS A  71      55.022  55.630  78.707  1.00 16.21           C  
ATOM    608  CE1 HIS A  71      57.014  56.308  79.326  1.00 25.76           C  
ATOM    609  NE2 HIS A  71      56.248  56.078  78.277  1.00 21.24           N  
ATOM    610  N   GLU A  72      51.487  57.003  80.092  1.00 13.32           N  
ATOM    611  CA  GLU A  72      50.821  57.875  79.097  1.00 14.20           C  
ATOM    612  C   GLU A  72      50.486  59.238  79.732  1.00 16.37           C  
ATOM    613  O   GLU A  72      50.635  60.259  79.083  1.00 16.88           O  
ATOM    614  CB  GLU A  72      49.537  57.236  78.561  1.00 13.53           C  
ATOM    615  CG  GLU A  72      48.842  58.121  77.546  1.00 15.42           C  
ATOM    616  CD  GLU A  72      47.645  57.502  76.879  1.00 21.04           C  
ATOM    617  OE1 GLU A  72      47.601  56.298  76.692  1.00 21.18           O  
ATOM    618  OE2 GLU A  72      46.743  58.259  76.489  1.00 33.52           O  
ATOM    619  N   ALA A  73      50.037  59.220  80.971  1.00 16.40           N  
ATOM    620  CA  ALA A  73      49.733  60.454  81.675  1.00 19.19           C  
ATOM    621  C   ALA A  73      50.965  61.350  81.763  1.00 20.89           C  
ATOM    622  O   ALA A  73      50.828  62.582  81.719  1.00 25.31           O  
ATOM    623  CB  ALA A  73      49.175  60.146  83.060  1.00 18.43           C  
ATOM    624  N   LEU A  74      52.153  60.762  81.901  1.00 18.19           N  
ATOM    625  CA  LEU A  74      53.379  61.557  81.978  1.00 18.25           C  
ATOM    626  C   LEU A  74      53.942  61.996  80.623  1.00 22.14           C  
ATOM    627  O   LEU A  74      54.534  63.087  80.503  1.00 21.97           O  
ATOM    628  CB  LEU A  74      54.454  60.779  82.722  1.00 17.95           C  
ATOM    629  CG  LEU A  74      54.112  60.393  84.163  1.00 20.85           C  
ATOM    630  CD1 LEU A  74      55.274  59.628  84.748  1.00 21.58           C  
ATOM    631  CD2 LEU A  74      53.803  61.559  85.018  1.00 24.11           C  
ATOM    632  N   THR A  75      53.783  61.156  79.596  1.00 19.08           N  
ATOM    633  CA  THR A  75      54.467  61.363  78.321  1.00 18.98           C  
ATOM    634  C   THR A  75      53.645  61.615  77.062  1.00 18.16           C  
ATOM    635  O   THR A  75      54.175  62.094  76.051  1.00 21.95           O  
ATOM    636  CB  THR A  75      55.354  60.127  78.002  1.00 19.77           C  
ATOM    637  OG1 THR A  75      54.493  59.006  77.778  1.00 18.74           O  
ATOM    638  CG2 THR A  75      56.323  59.797  79.135  1.00 23.18           C  
ATOM    639  N   GLY A  76      52.389  61.220  77.088  1.00 16.36           N  
ATOM    640  CA  GLY A  76      51.537  61.281  75.937  1.00 17.05           C  
ATOM    641  C   GLY A  76      51.711  60.089  75.008  1.00 17.36           C  
ATOM    642  O   GLY A  76      51.075  60.054  73.983  1.00 17.62           O  
ATOM    643  N   VAL A  77      52.551  59.123  75.384  1.00 17.08           N  
ATOM    644  CA  VAL A  77      52.796  57.922  74.563  1.00 17.16           C  
ATOM    645  C   VAL A  77      51.598  57.008  74.752  1.00 18.03           C  
ATOM    646  O   VAL A  77      51.198  56.711  75.888  1.00 14.66           O  
ATOM    647  CB  VAL A  77      54.090  57.221  74.965  1.00 20.31           C  
ATOM    648  CG1 VAL A  77      54.248  55.938  74.196  1.00 22.50           C  
ATOM    649  CG2 VAL A  77      55.296  58.149  74.708  1.00 23.73           C  
ATOM    650  N   ASP A  78      51.018  56.537  73.640  1.00 18.29           N  
ATOM    651  CA  ASP A  78      49.821  55.699  73.695  1.00 17.63           C  
ATOM    652  C   ASP A  78      50.029  54.422  74.556  1.00 15.74           C  
ATOM    653  O   ASP A  78      50.906  53.620  74.248  1.00 15.18           O  
ATOM    654  CB  ASP A  78      49.425  55.266  72.294  1.00 21.37           C  
ATOM    655  CG  ASP A  78      48.357  54.166  72.279  1.00 25.11           C  
ATOM    656  OD1 ASP A  78      47.365  54.179  73.018  1.00 30.31           O  
ATOM    657  OD2 ASP A  78      48.515  53.242  71.471  1.00 46.36           O  
ATOM    658  N   HIS A  79      49.203  54.264  75.567  1.00 15.29           N  
ATOM    659  CA  HIS A  79      49.351  53.168  76.518  1.00 14.67           C  
ATOM    660  C   HIS A  79      49.090  51.775  75.899  1.00 14.54           C  
ATOM    661  O   HIS A  79      49.644  50.750  76.369  1.00 13.80           O  
ATOM    662  CB  HIS A  79      48.514  53.360  77.764  1.00 14.34           C  
ATOM    663  CG  HIS A  79      47.042  53.120  77.607  1.00 15.62           C  
ATOM    664  ND1 HIS A  79      46.181  54.045  77.040  1.00 19.62           N  
ATOM    665  CD2 HIS A  79      46.276  52.066  77.972  1.00 16.49           C  
ATOM    666  CE1 HIS A  79      44.951  53.557  77.045  1.00 18.21           C  
ATOM    667  NE2 HIS A  79      44.976  52.365  77.636  1.00 16.89           N  
ATOM    668  N   ALA A  80      48.260  51.707  74.867  1.00 17.07           N  
ATOM    669  CA  ALA A  80      47.995  50.415  74.224  1.00 14.87           C  
ATOM    670  C   ALA A  80      49.262  49.917  73.511  1.00 15.72           C  
ATOM    671  O   ALA A  80      49.653  48.740  73.603  1.00 15.30           O  
ATOM    672  CB  ALA A  80      46.811  50.562  73.258  1.00 15.91           C  
ATOM    673  N   GLU A  81      49.954  50.815  72.790  0.50 15.18           N  
ATOM    675  CA  GLU A  81      51.210  50.466  72.090  0.50 13.96           C  
ATOM    677  C   GLU A  81      52.353  50.125  73.067  0.50 13.29           C  
ATOM    679  O   GLU A  81      53.130  49.149  72.879  0.50 10.93           O  
ATOM    681  CB  GLU A  81      51.713  51.621  71.181  0.50 16.90           C  
ATOM    683  CG  GLU A  81      50.809  51.946  70.004  0.50 16.17           C  
ATOM    685  N   SER A  82      52.532  50.981  74.063  0.25 11.84           N  
ATOM    688  CA  SER A  82      53.579  50.737  75.045  0.25 12.31           C  
ATOM    691  C   SER A  82      53.239  49.536  75.913  0.25 13.58           C  
ATOM    694  O   SER A  82      54.140  48.766  76.252  0.25 13.28           O  
ATOM    697  CB  SER A  82      53.826  51.976  75.896  0.25 12.57           C  
ATOM    700  OG  SER A  82      52.620  52.413  76.488  0.25  8.34           O  
ATOM    703  N   GLY A  83      51.973  49.372  76.289  1.00 13.06           N  
ATOM    704  CA  GLY A  83      51.593  48.175  77.062  1.00 12.05           C  
ATOM    705  C   GLY A  83      51.843  46.904  76.282  1.00 15.73           C  
ATOM    706  O   GLY A  83      52.310  45.925  76.825  1.00 13.06           O  
ATOM    707  N   ALA A  84      51.570  46.891  75.005  1.00 13.08           N  
ATOM    708  CA  ALA A  84      51.855  45.719  74.165  1.00 11.04           C  
ATOM    709  C   ALA A  84      53.322  45.444  74.076  1.00 14.22           C  
ATOM    710  O   ALA A  84      53.746  44.299  74.184  1.00 12.55           O  
ATOM    711  CB  ALA A  84      51.260  45.971  72.782  1.00 11.09           C  
ATOM    712  N   GLU A  85      54.149  46.478  73.896  1.00 14.19           N  
ATOM    713  CA  GLU A  85      55.594  46.301  73.848  1.00 13.32           C  
ATOM    714  C   GLU A  85      56.133  45.777  75.209  1.00 11.70           C  
ATOM    715  O   GLU A  85      56.985  44.916  75.258  1.00 14.15           O  
ATOM    716  CB  GLU A  85      56.244  47.646  73.458  1.00 14.52           C  
ATOM    717  CG  GLU A  85      57.763  47.627  73.470  1.00 18.45           C  
ATOM    718  CD  GLU A  85      58.391  48.987  73.134  1.00 24.28           C  
ATOM    719  OE1 GLU A  85      57.946  49.623  72.142  1.00 24.58           O  
ATOM    720  OE2 GLU A  85      59.379  49.353  73.818  1.00 36.37           O  
ATOM    721  N   TYR A  86      55.583  46.318  76.268  1.00 12.07           N  
ATOM    722  CA  TYR A  86      55.977  45.905  77.615  1.00 12.69           C  
ATOM    723  C   TYR A  86      55.649  44.437  77.805  1.00 14.70           C  
ATOM    724  O   TYR A  86      56.490  43.658  78.301  1.00 13.24           O  
ATOM    725  CB  TYR A  86      55.295  46.762  78.691  1.00 13.38           C  
ATOM    726  CG  TYR A  86      55.694  46.304  80.058  1.00 13.45           C  
ATOM    727  CD1 TYR A  86      56.920  46.620  80.561  1.00 16.65           C  
ATOM    728  CD2 TYR A  86      54.835  45.552  80.839  1.00 14.04           C  
ATOM    729  CE1 TYR A  86      57.325  46.157  81.815  1.00 16.24           C  
ATOM    730  CE2 TYR A  86      55.238  45.046  82.094  1.00 16.76           C  
ATOM    731  CZ  TYR A  86      56.455  45.377  82.564  1.00 19.05           C  
ATOM    732  OH  TYR A  86      56.829  44.878  83.814  1.00 19.09           O  
ATOM    733  N   ALA A  87      54.443  44.009  77.478  1.00 11.87           N  
ATOM    734  CA  ALA A  87      54.083  42.590  77.615  1.00 12.75           C  
ATOM    735  C   ALA A  87      54.985  41.681  76.822  1.00 15.16           C  
ATOM    736  O   ALA A  87      55.368  40.609  77.252  1.00 14.11           O  
ATOM    737  CB  ALA A  87      52.634  42.408  77.231  1.00 14.24           C  
ATOM    738  N   SER A  88      55.365  42.103  75.625  0.50 12.47           N  
ATOM    740  CA  SER A  88      56.302  41.315  74.799  0.50 13.07           C  
ATOM    742  C   SER A  88      57.692  41.174  75.378  0.50 14.12           C  
ATOM    744  O   SER A  88      58.431  40.273  75.002  0.50 15.97           O  
ATOM    746  CB  SER A  88      56.430  41.938  73.406  0.50 14.39           C  
ATOM    748  OG  SER A  88      55.220  41.838  72.726  0.50 12.35           O  
ATOM    750  N   GLY A  89      58.087  42.116  76.207  1.00 13.46           N  
ATOM    751  CA  GLY A  89      59.345  42.010  76.884  1.00 16.56           C  
ATOM    752  C   GLY A  89      59.273  41.220  78.173  1.00 16.90           C  
ATOM    753  O   GLY A  89      60.107  40.392  78.441  1.00 17.91           O  
ATOM    754  N   LEU A  90      58.229  41.462  78.953  1.00 15.52           N  
ATOM    755  CA  LEU A  90      58.101  40.845  80.278  1.00 16.58           C  
ATOM    756  C   LEU A  90      57.788  39.353  80.194  1.00 17.01           C  
ATOM    757  O   LEU A  90      58.426  38.540  80.845  1.00 15.99           O  
ATOM    758  CB  LEU A  90      56.980  41.515  81.076  1.00 16.62           C  
ATOM    759  CG  LEU A  90      56.599  40.806  82.397  1.00 14.46           C  
ATOM    760  CD1 LEU A  90      57.742  41.037  83.376  1.00 18.14           C  
ATOM    761  CD2 LEU A  90      55.331  41.360  82.944  1.00 17.19           C  
ATOM    762  N   LEU A  91      56.773  38.980  79.447  1.00 13.35           N  
ATOM    763  CA  LEU A  91      56.233  37.653  79.447  1.00 13.89           C  
ATOM    764  C   LEU A  91      57.188  36.507  79.064  1.00 15.73           C  
ATOM    765  O   LEU A  91      57.146  35.429  79.686  1.00 17.04           O  
ATOM    766  CB  LEU A  91      54.907  37.567  78.694  1.00 14.94           C  
ATOM    767  CG  LEU A  91      53.768  38.373  79.364  1.00 15.28           C  
ATOM    768  CD1 LEU A  91      52.507  38.315  78.500  1.00 15.33           C  
ATOM    769  CD2 LEU A  91      53.497  37.916  80.859  1.00 16.33           C  
ATOM    770  N   PRO A  92      58.063  36.705  78.067  1.00 15.29           N  
ATOM    771  CA  PRO A  92      59.048  35.622  77.781  1.00 17.56           C  
ATOM    772  C   PRO A  92      59.960  35.286  78.969  1.00 17.79           C  
ATOM    773  O   PRO A  92      60.367  34.136  79.101  1.00 21.27           O  
ATOM    774  CB  PRO A  92      59.865  36.187  76.615  1.00 18.25           C  
ATOM    775  CG  PRO A  92      58.893  37.141  75.930  1.00 15.68           C  
ATOM    776  CD  PRO A  92      58.149  37.792  77.061  1.00 16.87           C  
ATOM    777  N   THR A  93      60.244  36.282  79.801  1.00 19.24           N  
ATOM    778  CA  THR A  93      61.085  36.061  80.995  1.00 20.55           C  
ATOM    779  C   THR A  93      60.412  35.228  82.060  1.00 22.78           C  
ATOM    780  O   THR A  93      61.068  34.786  83.014  1.00 25.20           O  
ATOM    781  CB  THR A  93      61.569  37.388  81.665  1.00 20.83           C  
ATOM    782  OG1 THR A  93      60.504  37.976  82.412  1.00 23.95           O  
ATOM    783  CG2 THR A  93      62.146  38.383  80.653  1.00 24.96           C  
HETATM  784  N   MSE A  94      59.106  35.028  81.942  1.00 21.30           N  
HETATM  785  CA  MSE A  94      58.302  34.229  82.848  1.00 20.38           C  
HETATM  786  C   MSE A  94      57.948  32.859  82.248  1.00 21.06           C  
HETATM  787  O   MSE A  94      57.077  32.150  82.749  1.00 23.59           O  
HETATM  788  CB  MSE A  94      57.043  35.039  83.234  1.00 19.10           C  
HETATM  789  CG  MSE A  94      57.330  36.308  84.062  1.00 19.06           C  
HETATM  790 SE   MSE A  94      55.772  37.292  84.396  0.74 16.04          SE  
HETATM  791  CE  MSE A  94      56.461  38.227  85.935  1.00 18.59           C  
ATOM    792  N   GLY A  95      58.617  32.503  81.157  1.00 20.92           N  
ATOM    793  CA  GLY A  95      58.436  31.236  80.510  1.00 21.43           C  
ATOM    794  C   GLY A  95      57.254  31.083  79.556  1.00 19.53           C  
ATOM    795  O   GLY A  95      56.989  29.999  79.076  1.00 21.92           O  
ATOM    796  N   PHE A  96      56.519  32.163  79.272  1.00 18.24           N  
ATOM    797  CA  PHE A  96      55.411  32.023  78.321  1.00 20.26           C  
ATOM    798  C   PHE A  96      55.958  31.912  76.894  1.00 17.47           C  
ATOM    799  O   PHE A  96      56.932  32.603  76.567  1.00 16.82           O  
ATOM    800  CB  PHE A  96      54.470  33.242  78.471  1.00 16.50           C  
ATOM    801  CG  PHE A  96      53.725  33.256  79.812  1.00 16.54           C  
ATOM    802  CD1 PHE A  96      52.632  32.423  80.011  1.00 16.36           C  
ATOM    803  CD2 PHE A  96      54.138  34.075  80.834  1.00 15.52           C  
ATOM    804  CE1 PHE A  96      51.955  32.423  81.214  1.00 16.99           C  
ATOM    805  CE2 PHE A  96      53.458  34.087  82.069  1.00 15.94           C  
ATOM    806  CZ  PHE A  96      52.382  33.268  82.228  1.00 16.54           C  
ATOM    807  N   ASP A  97      55.309  31.086  76.084  1.00 17.97           N  
ATOM    808  CA  ASP A  97      55.808  30.794  74.764  1.00 18.91           C  
ATOM    809  C   ASP A  97      55.474  31.893  73.747  1.00 17.87           C  
ATOM    810  O   ASP A  97      54.667  32.782  74.037  1.00 16.05           O  
ATOM    811  CB  ASP A  97      55.451  29.376  74.292  1.00 21.86           C  
ATOM    812  CG  ASP A  97      54.001  29.177  73.898  1.00 28.88           C  
ATOM    813  OD1 ASP A  97      53.225  30.125  73.628  1.00 27.05           O  
ATOM    814  OD2 ASP A  97      53.651  27.981  73.773  1.00 33.23           O  
ATOM    815  N   ILE A  98      56.110  31.816  72.594  1.00 18.51           N  
ATOM    816  CA  ILE A  98      55.991  32.853  71.575  1.00 16.81           C  
ATOM    817  C   ILE A  98      54.550  33.149  71.181  1.00 16.89           C  
ATOM    818  O   ILE A  98      54.159  34.323  71.081  1.00 15.39           O  
ATOM    819  CB  ILE A  98      56.830  32.488  70.315  1.00 19.00           C  
ATOM    820  CG1 ILE A  98      58.320  32.631  70.610  1.00 22.66           C  
ATOM    821  CG2 ILE A  98      56.505  33.403  69.149  1.00 21.13           C  
ATOM    822  CD1 ILE A  98      59.216  32.122  69.495  1.00 23.07           C  
ATOM    823  N   SER A  99      53.776  32.118  70.930  1.00 16.39           N  
ATOM    824  CA  SER A  99      52.409  32.319  70.487  1.00 16.68           C  
ATOM    825  C   SER A  99      51.576  32.919  71.616  1.00 17.87           C  
ATOM    826  O   SER A  99      50.773  33.800  71.353  1.00 16.98           O  
ATOM    827  CB  SER A  99      51.823  31.014  69.891  1.00 20.48           C  
ATOM    828  OG  SER A  99      52.614  30.592  68.754  1.00 20.32           O  
ATOM    829  N   PHE A 100      51.786  32.510  72.858  1.00 16.17           N  
ATOM    830  CA  PHE A 100      51.034  33.054  73.967  1.00 14.87           C  
ATOM    831  C   PHE A 100      51.313  34.536  74.082  1.00 14.25           C  
ATOM    832  O   PHE A 100      50.397  35.385  74.227  1.00 14.36           O  
ATOM    833  CB  PHE A 100      51.465  32.354  75.282  1.00 17.43           C  
ATOM    834  CG  PHE A 100      50.714  32.787  76.492  1.00 15.95           C  
ATOM    835  CD1 PHE A 100      51.021  33.949  77.144  1.00 15.41           C  
ATOM    836  CD2 PHE A 100      49.738  31.959  77.034  1.00 18.43           C  
ATOM    837  CE1 PHE A 100      50.337  34.341  78.305  1.00 18.76           C  
ATOM    838  CE2 PHE A 100      49.085  32.332  78.167  1.00 16.96           C  
ATOM    839  CZ  PHE A 100      49.368  33.498  78.794  1.00 14.62           C  
ATOM    840  N   VAL A 101      52.601  34.859  74.149  1.00 14.26           N  
ATOM    841  CA  VAL A 101      53.016  36.257  74.291  1.00 13.44           C  
ATOM    842  C   VAL A 101      52.498  37.128  73.121  1.00 13.57           C  
ATOM    843  O   VAL A 101      52.029  38.253  73.351  1.00 14.43           O  
ATOM    844  CB  VAL A 101      54.550  36.362  74.427  1.00 12.13           C  
ATOM    845  CG1 VAL A 101      54.990  37.784  74.450  1.00 13.18           C  
ATOM    846  CG2 VAL A 101      55.062  35.566  75.664  1.00 13.14           C  
ATOM    847  N   ALA A 102      52.554  36.629  71.891  1.00 13.42           N  
ATOM    848  CA  ALA A 102      52.083  37.423  70.745  1.00 13.61           C  
ATOM    849  C   ALA A 102      50.599  37.693  70.879  1.00 15.41           C  
ATOM    850  O   ALA A 102      50.137  38.782  70.580  1.00 13.95           O  
ATOM    851  CB  ALA A 102      52.393  36.719  69.479  1.00 14.29           C  
ATOM    852  N   GLU A 103      49.836  36.732  71.324  1.00 12.98           N  
ATOM    853  CA  GLU A 103      48.393  36.923  71.416  1.00 12.54           C  
ATOM    854  C   GLU A 103      48.059  37.950  72.499  1.00 14.04           C  
ATOM    855  O   GLU A 103      47.190  38.807  72.333  1.00 12.42           O  
ATOM    856  CB  GLU A 103      47.610  35.599  71.654  1.00 13.43           C  
ATOM    857  CG  GLU A 103      46.099  35.831  71.811  1.00 15.65           C  
ATOM    858  CD  GLU A 103      45.242  34.600  71.602  1.00 18.04           C  
ATOM    859  OE1 GLU A 103      45.748  33.615  71.036  1.00 21.79           O  
ATOM    860  OE2 GLU A 103      44.034  34.629  71.971  1.00 20.71           O  
ATOM    861  N   VAL A 104      48.660  37.796  73.662  1.00 14.05           N  
ATOM    862  CA  VAL A 104      48.428  38.746  74.737  1.00 12.30           C  
ATOM    863  C   VAL A 104      48.843  40.150  74.325  1.00 13.34           C  
ATOM    864  O   VAL A 104      48.108  41.134  74.598  1.00 12.18           O  
ATOM    865  CB  VAL A 104      49.143  38.333  76.062  1.00 12.94           C  
ATOM    866  CG1 VAL A 104      49.081  39.429  77.120  1.00 12.76           C  
ATOM    867  CG2 VAL A 104      48.537  37.055  76.587  1.00 14.70           C  
ATOM    868  N   SER A 105      50.026  40.262  73.729  1.00 11.85           N  
ATOM    869  CA  SER A 105      50.522  41.561  73.308  0.50 13.05           C  
ATOM    871  C   SER A 105      49.574  42.229  72.267  1.00 11.22           C  
ATOM    872  O   SER A 105      49.253  43.410  72.433  1.00 12.38           O  
ATOM    873  CB  SER A 105      51.957  41.454  72.793  0.50 13.34           C  
ATOM    875  OG  SER A 105      52.835  40.992  73.818  0.50 17.57           O  
ATOM    877  N   LYS A 106      49.095  41.468  71.278  1.00 11.95           N  
ATOM    878  CA  LYS A 106      48.218  41.987  70.232  1.00 14.60           C  
ATOM    879  C   LYS A 106      46.922  42.391  70.902  1.00 13.24           C  
ATOM    880  O   LYS A 106      46.293  43.417  70.533  1.00 12.19           O  
ATOM    881  CB  LYS A 106      47.958  40.904  69.192  1.00 14.07           C  
ATOM    882  CG  LYS A 106      47.107  41.406  68.011  1.00 23.40           C  
ATOM    883  CD  LYS A 106      46.910  40.293  66.896  1.00 26.58           C  
ATOM    884  N   ALA A 107      46.433  41.634  71.870  1.00 12.28           N  
ATOM    885  CA  ALA A 107      45.196  41.999  72.535  1.00 11.39           C  
ATOM    886  C   ALA A 107      45.315  43.342  73.205  1.00 14.35           C  
ATOM    887  O   ALA A 107      44.414  44.179  73.160  1.00 13.60           O  
ATOM    888  CB  ALA A 107      44.807  40.926  73.557  1.00 12.19           C  
ATOM    889  N   ILE A 108      46.422  43.592  73.865  1.00 12.36           N  
ATOM    890  CA  ILE A 108      46.612  44.860  74.537  1.00 13.38           C  
ATOM    891  C   ILE A 108      46.731  45.968  73.511  1.00 13.44           C  
ATOM    892  O   ILE A 108      46.204  47.068  73.658  1.00 14.63           O  
ATOM    893  CB  ILE A 108      47.872  44.805  75.425  1.00 13.43           C  
ATOM    894  CG1 ILE A 108      47.649  43.777  76.566  1.00 12.89           C  
ATOM    895  CG2 ILE A 108      48.270  46.218  75.964  1.00 14.42           C  
ATOM    896  CD1 ILE A 108      48.917  43.450  77.368  1.00 13.43           C  
ATOM    897  N   ARG A 109      47.458  45.671  72.453  1.00 14.17           N  
ATOM    898  CA  ARG A 109      47.672  46.663  71.411  1.00 15.31           C  
ATOM    899  C   ARG A 109      46.380  47.137  70.790  1.00 16.92           C  
ATOM    900  O   ARG A 109      46.269  48.311  70.391  1.00 18.21           O  
ATOM    901  CB  ARG A 109      48.568  46.085  70.336  1.00 15.31           C  
ATOM    902  CG  ARG A 109      49.010  47.075  69.264  1.00 18.25           C  
ATOM    903  CD  ARG A 109      49.915  46.401  68.267  1.00 29.84           C  
ATOM    904  NE  ARG A 109      51.122  45.899  68.907  1.00 34.27           N  
ATOM    905  CZ  ARG A 109      52.288  46.539  68.992  1.00 51.12           C  
ATOM    906  NH1 ARG A 109      52.457  47.755  68.452  1.00 56.41           N  
ATOM    907  NH2 ARG A 109      53.307  45.933  69.625  1.00 43.92           N  
ATOM    908  N   SER A 110      45.400  46.242  70.709  0.50 14.83           N  
ATOM    910  CA  SER A 110      44.113  46.517  70.054  0.50 13.65           C  
ATOM    912  C   SER A 110      42.988  47.015  70.950  0.50 16.04           C  
ATOM    914  O   SER A 110      41.895  47.333  70.465  0.50 15.21           O  
ATOM    916  CB  SER A 110      43.605  45.228  69.388  0.50 12.22           C  
ATOM    918  OG  SER A 110      44.587  44.659  68.558  0.50 14.16           O  
ATOM    920  N   HIS A 111      43.211  47.080  72.260  1.00 17.19           N  
ATOM    921  CA  HIS A 111      42.107  47.301  73.179  1.00 15.78           C  
ATOM    922  C   HIS A 111      41.328  48.611  73.177  1.00 16.35           C  
ATOM    923  O   HIS A 111      40.197  48.610  73.633  1.00 18.69           O  
ATOM    924  CB  HIS A 111      42.491  46.908  74.623  1.00 16.91           C  
ATOM    925  CG  HIS A 111      43.127  48.009  75.431  1.00 17.01           C  
ATOM    926  ND1 HIS A 111      44.488  48.206  75.502  1.00 15.08           N  
ATOM    927  CD2 HIS A 111      42.568  48.927  76.256  1.00 17.75           C  
ATOM    928  CE1 HIS A 111      44.734  49.225  76.311  1.00 13.54           C  
ATOM    929  NE2 HIS A 111      43.583  49.680  76.792  1.00 15.73           N  
ATOM    930  N   ARG A 112      41.907  49.676  72.668  1.00 19.34           N  
ATOM    931  CA  ARG A 112      41.154  50.943  72.616  1.00 26.50           C  
ATOM    932  C   ARG A 112      40.125  50.981  71.478  1.00 29.19           C  
ATOM    933  O   ARG A 112      40.341  50.334  70.444  1.00 32.62           O  
ATOM    934  CB  ARG A 112      42.058  52.143  72.444  1.00 29.16           C  
ATOM    935  CG  ARG A 112      43.110  52.359  73.465  1.00 35.53           C  
ATOM    936  CD  ARG A 112      43.054  53.847  73.873  1.00 48.20           C  
ATOM    937  NE  ARG A 112      44.319  54.547  73.762  1.00 54.22           N  
ATOM    938  CZ  ARG A 112      44.575  55.718  74.343  1.00 51.68           C  
ATOM    939  NH1 ARG A 112      43.668  56.323  75.119  1.00 56.90           N  
ATOM    940  NH2 ARG A 112      45.763  56.285  74.170  1.00 51.06           N  
ATOM    941  N   THR A 118      39.313  47.070  65.130  1.00 32.80           N  
ATOM    942  CA  THR A 118      38.986  46.072  66.143  1.00 28.81           C  
ATOM    943  C   THR A 118      40.062  45.016  66.515  1.00 24.84           C  
ATOM    944  O   THR A 118      41.001  44.774  65.780  1.00 26.49           O  
ATOM    945  CB  THR A 118      37.756  45.265  65.669  1.00 29.48           C  
ATOM    946  OG1 THR A 118      38.093  44.505  64.510  1.00 37.56           O  
ATOM    947  CG2 THR A 118      36.593  46.183  65.351  1.00 35.03           C  
ATOM    948  N   PRO A 119      39.911  44.348  67.692  1.00 19.96           N  
ATOM    949  CA  PRO A 119      40.698  43.169  68.047  1.00 19.33           C  
ATOM    950  C   PRO A 119      40.409  42.023  67.066  1.00 19.95           C  
ATOM    951  O   PRO A 119      39.293  41.943  66.548  1.00 21.19           O  
ATOM    952  CB  PRO A 119      40.154  42.759  69.405  1.00 18.96           C  
ATOM    953  CG  PRO A 119      39.288  43.800  69.870  1.00 20.65           C  
ATOM    954  CD  PRO A 119      38.983  44.755  68.764  1.00 21.96           C  
ATOM    955  N   THR A 120      41.374  41.144  66.874  1.00 19.92           N  
ATOM    956  CA  THR A 120      41.220  40.003  65.971  1.00 21.62           C  
ATOM    957  C   THR A 120      41.285  38.650  66.646  1.00 20.79           C  
ATOM    958  O   THR A 120      40.849  37.638  66.079  1.00 23.30           O  
ATOM    959  CB  THR A 120      42.285  40.048  64.872  1.00 22.74           C  
ATOM    960  OG1 THR A 120      43.591  40.166  65.455  1.00 27.65           O  
ATOM    961  CG2 THR A 120      42.006  41.227  63.918  1.00 22.43           C  
ATOM    962  N   SER A 121      41.780  38.599  67.878  1.00 16.57           N  
ATOM    963  CA  SER A 121      41.867  37.332  68.583  1.00 18.98           C  
ATOM    964  C   SER A 121      40.776  37.212  69.628  1.00 18.17           C  
ATOM    965  O   SER A 121      40.156  38.193  70.037  1.00 17.04           O  
ATOM    966  CB  SER A 121      43.208  37.180  69.289  1.00 21.07           C  
ATOM    967  OG  SER A 121      43.365  38.096  70.390  1.00 21.78           O  
ATOM    968  N   LEU A 122      40.569  36.001  70.100  1.00 16.39           N  
ATOM    969  CA  LEU A 122      39.601  35.760  71.157  1.00 15.70           C  
ATOM    970  C   LEU A 122      40.046  36.539  72.408  1.00 14.79           C  
ATOM    971  O   LEU A 122      39.235  37.158  73.085  1.00 13.77           O  
ATOM    972  CB  LEU A 122      39.490  34.288  71.521  1.00 20.97           C  
ATOM    973  CG  LEU A 122      38.902  33.366  70.444  1.00 31.79           C  
ATOM    974  CD1 LEU A 122      39.038  31.907  70.858  1.00 35.59           C  
ATOM    975  CD2 LEU A 122      37.460  33.711  70.206  1.00 37.52           C  
ATOM    976  N   THR A 123      41.328  36.508  72.726  1.00 13.84           N  
ATOM    977  CA  THR A 123      41.824  37.231  73.898  1.00 13.43           C  
ATOM    978  C   THR A 123      41.550  38.728  73.737  1.00 12.29           C  
ATOM    979  O   THR A 123      41.096  39.365  74.682  1.00 12.42           O  
ATOM    980  CB  THR A 123      43.313  36.985  74.139  1.00 15.51           C  
ATOM    981  OG1 THR A 123      43.551  35.583  74.325  1.00 16.88           O  
ATOM    982  CG2 THR A 123      43.793  37.714  75.393  1.00 14.71           C  
ATOM    983  N   GLY A 124      41.741  39.280  72.533  1.00 13.84           N  
ATOM    984  CA  GLY A 124      41.502  40.692  72.357  1.00 13.78           C  
ATOM    985  C   GLY A 124      40.036  41.096  72.460  1.00 13.07           C  
ATOM    986  O   GLY A 124      39.733  42.129  73.011  1.00 12.75           O  
ATOM    987  N   LYS A 125      39.152  40.245  71.978  1.00 12.50           N  
ATOM    988  CA  LYS A 125      37.735  40.465  72.055  1.00 14.70           C  
ATOM    989  C   LYS A 125      37.265  40.409  73.502  1.00 14.61           C  
ATOM    990  O   LYS A 125      36.496  41.260  73.960  1.00 14.97           O  
ATOM    991  CB  LYS A 125      37.014  39.480  71.147  1.00 13.25           C  
ATOM    992  CG  LYS A 125      37.225  39.878  69.650  1.00 16.80           C  
ATOM    993  CD  LYS A 125      36.563  38.871  68.710  1.00 20.69           C  
ATOM    994  CE  LYS A 125      36.997  39.074  67.246  1.00 28.82           C  
ATOM    995  NZ  LYS A 125      36.675  37.870  66.382  1.00 37.39           N  
ATOM    996  N   ILE A 126      37.697  39.391  74.237  1.00 13.14           N  
ATOM    997  CA  ILE A 126      37.366  39.253  75.648  1.00 12.68           C  
ATOM    998  C   ILE A 126      37.894  40.440  76.430  1.00 12.04           C  
ATOM    999  O   ILE A 126      37.162  41.020  77.258  1.00 13.28           O  
ATOM   1000  CB  ILE A 126      37.924  37.951  76.223  1.00 13.77           C  
ATOM   1001  CG1 ILE A 126      37.163  36.776  75.592  1.00 14.79           C  
ATOM   1002  CG2 ILE A 126      37.840  37.937  77.749  1.00 14.02           C  
ATOM   1003  CD1 ILE A 126      37.719  35.444  75.922  1.00 15.25           C  
ATOM   1004  N   LEU A 127      39.109  40.870  76.140  1.00 10.38           N  
ATOM   1005  CA  LEU A 127      39.723  41.990  76.851  1.00 11.40           C  
ATOM   1006  C   LEU A 127      38.923  43.244  76.637  1.00 11.65           C  
ATOM   1007  O   LEU A 127      38.635  43.968  77.583  1.00 13.28           O  
ATOM   1008  CB  LEU A 127      41.171  42.222  76.404  1.00 12.67           C  
ATOM   1009  CG  LEU A 127      41.835  43.460  77.005  1.00 11.86           C  
ATOM   1010  CD1 LEU A 127      41.860  43.408  78.552  1.00 13.63           C  
ATOM   1011  CD2 LEU A 127      43.224  43.627  76.457  1.00 12.09           C  
ATOM   1012  N   GLN A 128      38.603  43.535  75.368  1.00 12.62           N  
ATOM   1013  CA  GLN A 128      37.825  44.713  75.073  1.00 15.99           C  
ATOM   1014  C   GLN A 128      36.465  44.677  75.739  1.00 13.05           C  
ATOM   1015  O   GLN A 128      36.061  45.674  76.350  1.00 13.90           O  
ATOM   1016  CB  GLN A 128      37.718  44.934  73.583  1.00 17.87           C  
ATOM   1017  CG  GLN A 128      37.139  46.254  73.276  1.00 19.61           C  
ATOM   1018  CD  GLN A 128      37.360  46.638  71.813  1.00 19.79           C  
ATOM   1019  OE1 GLN A 128      36.742  46.087  70.909  1.00 20.47           O  
ATOM   1020  NE2 GLN A 128      38.244  47.593  71.579  1.00 21.11           N  
ATOM   1021  N   ASP A 129      35.786  43.534  75.744  1.00 13.16           N  
ATOM   1022  CA  ASP A 129      34.540  43.431  76.429  1.00 12.46           C  
ATOM   1023  C   ASP A 129      34.698  43.702  77.921  1.00 15.15           C  
ATOM   1024  O   ASP A 129      33.887  44.417  78.524  1.00 16.06           O  
ATOM   1025  CB  ASP A 129      33.928  42.035  76.282  1.00 15.14           C  
ATOM   1026  CG  ASP A 129      33.306  41.772  74.924  1.00 15.37           C  
ATOM   1027  OD1 ASP A 129      33.204  42.709  74.061  1.00 16.42           O  
ATOM   1028  OD2 ASP A 129      32.862  40.605  74.736  1.00 14.92           O  
ATOM   1029  N   ALA A 130      35.671  43.062  78.529  1.00 15.32           N  
ATOM   1030  CA  ALA A 130      35.940  43.167  79.957  1.00 16.56           C  
ATOM   1031  C   ALA A 130      36.230  44.615  80.384  1.00 15.13           C  
ATOM   1032  O   ALA A 130      35.789  45.086  81.464  1.00 14.54           O  
ATOM   1033  CB  ALA A 130      37.105  42.274  80.312  1.00 16.79           C  
ATOM   1034  N   ASP A 131      36.966  45.315  79.533  1.00 14.87           N  
ATOM   1035  CA  ASP A 131      37.346  46.714  79.762  1.00 16.33           C  
ATOM   1036  C   ASP A 131      36.092  47.574  79.672  1.00 17.93           C  
ATOM   1037  O   ASP A 131      35.781  48.359  80.596  1.00 18.24           O  
ATOM   1038  CB  ASP A 131      38.351  47.126  78.700  1.00 14.03           C  
ATOM   1039  CG  ASP A 131      38.990  48.487  78.953  1.00 16.08           C  
ATOM   1040  OD1 ASP A 131      39.335  48.779  80.132  1.00 17.61           O  
ATOM   1041  OD2 ASP A 131      39.170  49.225  77.960  1.00 21.15           O  
ATOM   1042  N   ARG A 132      35.329  47.387  78.593  1.00 17.72           N  
ATOM   1043  CA  ARG A 132      34.177  48.266  78.373  1.00 18.64           C  
ATOM   1044  C   ARG A 132      33.060  48.010  79.347  1.00 16.50           C  
ATOM   1045  O   ARG A 132      32.321  48.952  79.697  1.00 20.28           O  
ATOM   1046  CB  ARG A 132      33.684  48.202  76.928  1.00 18.57           C  
ATOM   1047  CG  ARG A 132      34.710  48.657  75.933  1.00 19.54           C  
ATOM   1048  CD  ARG A 132      34.351  48.428  74.495  1.00 22.79           C  
ATOM   1049  NE  ARG A 132      33.132  49.174  74.169  1.00 28.36           N  
ATOM   1050  CZ  ARG A 132      31.899  48.668  74.040  1.00 33.00           C  
ATOM   1051  NH1 ARG A 132      31.633  47.360  74.105  1.00 39.29           N  
ATOM   1052  NH2 ARG A 132      30.906  49.507  73.779  1.00 38.32           N  
ATOM   1053  N   LEU A 133      32.955  46.792  79.894  1.00 17.08           N  
ATOM   1054  CA  LEU A 133      31.903  46.512  80.877  1.00 18.60           C  
ATOM   1055  C   LEU A 133      32.081  47.393  82.126  1.00 18.49           C  
ATOM   1056  O   LEU A 133      31.126  47.608  82.864  1.00 18.88           O  
ATOM   1057  CB  LEU A 133      31.946  45.058  81.358  1.00 19.27           C  
ATOM   1058  CG  LEU A 133      31.218  44.014  80.526  1.00 22.11           C  
ATOM   1059  CD1 LEU A 133      31.562  42.577  81.005  1.00 19.49           C  
ATOM   1060  CD2 LEU A 133      29.668  44.287  80.628  1.00 25.05           C  
ATOM   1061  N   ASP A 134      33.294  47.872  82.371  1.00 17.01           N  
ATOM   1062  CA  ASP A 134      33.560  48.675  83.570  1.00 18.48           C  
ATOM   1063  C   ASP A 134      32.904  50.056  83.546  1.00 19.10           C  
ATOM   1064  O   ASP A 134      32.872  50.719  84.577  1.00 20.67           O  
ATOM   1065  CB  ASP A 134      35.064  48.791  83.833  1.00 20.00           C  
ATOM   1066  CG  ASP A 134      35.360  49.177  85.277  1.00 18.57           C  
ATOM   1067  OD1 ASP A 134      34.807  48.529  86.194  1.00 19.45           O  
ATOM   1068  OD2 ASP A 134      36.158  50.109  85.458  1.00 19.87           O  
ATOM   1069  N   ALA A 135      32.416  50.507  82.390  1.00 20.21           N  
ATOM   1070  CA  ALA A 135      31.709  51.768  82.280  1.00 22.77           C  
ATOM   1071  C   ALA A 135      30.266  51.708  82.830  1.00 22.43           C  
ATOM   1072  O   ALA A 135      29.613  52.750  82.985  1.00 24.77           O  
ATOM   1073  CB  ALA A 135      31.680  52.204  80.872  1.00 21.96           C  
ATOM   1074  N   ILE A 136      29.765  50.516  83.111  1.00 19.95           N  
ATOM   1075  CA  ILE A 136      28.411  50.349  83.617  1.00 23.10           C  
ATOM   1076  C   ILE A 136      28.285  49.469  84.832  1.00 22.46           C  
ATOM   1077  O   ILE A 136      29.105  48.607  85.110  1.00 21.95           O  
ATOM   1078  CB  ILE A 136      27.449  49.853  82.547  1.00 26.19           C  
ATOM   1079  CG1 ILE A 136      27.911  48.532  81.948  1.00 25.27           C  
ATOM   1080  CG2 ILE A 136      27.291  50.908  81.465  1.00 33.11           C  
ATOM   1081  CD1 ILE A 136      27.043  48.045  80.801  1.00 29.30           C  
ATOM   1082  N   GLY A 137      27.213  49.684  85.592  1.00 21.35           N  
ATOM   1083  CA  GLY A 137      26.988  48.902  86.783  1.00 19.37           C  
ATOM   1084  C   GLY A 137      26.988  49.745  88.052  1.00 19.95           C  
ATOM   1085  O   GLY A 137      27.061  50.981  87.994  1.00 21.74           O  
ATOM   1086  N   ALA A 138      26.951  49.064  89.184  1.00 20.59           N  
ATOM   1087  CA  ALA A 138      26.872  49.703  90.495  1.00 20.79           C  
ATOM   1088  C   ALA A 138      28.114  50.518  90.827  1.00 20.86           C  
ATOM   1089  O   ALA A 138      28.025  51.645  91.317  1.00 20.46           O  
ATOM   1090  CB  ALA A 138      26.637  48.675  91.552  1.00 21.98           C  
ATOM   1091  N   VAL A 139      29.304  49.988  90.546  1.00 19.18           N  
ATOM   1092  CA  VAL A 139      30.528  50.729  90.846  1.00 18.88           C  
ATOM   1093  C   VAL A 139      30.617  51.967  89.980  1.00 19.39           C  
ATOM   1094  O   VAL A 139      31.000  53.036  90.465  1.00 18.69           O  
ATOM   1095  CB  VAL A 139      31.810  49.847  90.721  1.00 21.38           C  
ATOM   1096  CG1 VAL A 139      33.055  50.681  90.956  1.00 20.93           C  
ATOM   1097  CG2 VAL A 139      31.768  48.690  91.708  1.00 19.34           C  
ATOM   1098  N   ALA A 140      30.254  51.850  88.700  1.00 19.37           N  
ATOM   1099  CA  ALA A 140      30.215  53.007  87.802  1.00 20.95           C  
ATOM   1100  C   ALA A 140      29.265  54.122  88.333  1.00 20.32           C  
ATOM   1101  O   ALA A 140      29.605  55.293  88.287  1.00 21.85           O  
ATOM   1102  CB  ALA A 140      29.799  52.567  86.404  1.00 22.32           C  
ATOM   1103  N   ILE A 141      28.085  53.724  88.797  1.00 19.85           N  
ATOM   1104  CA  ILE A 141      27.146  54.665  89.416  1.00 21.00           C  
ATOM   1105  C   ILE A 141      27.812  55.347  90.605  1.00 17.40           C  
ATOM   1106  O   ILE A 141      27.752  56.564  90.739  1.00 20.32           O  
ATOM   1107  CB  ILE A 141      25.837  53.977  89.862  1.00 20.63           C  
ATOM   1108  CG1 ILE A 141      25.006  53.522  88.663  1.00 23.77           C  
ATOM   1109  CG2 ILE A 141      25.008  54.915  90.749  1.00 20.61           C  
ATOM   1110  CD1 ILE A 141      23.953  52.459  89.016  1.00 22.16           C  
ATOM   1111  N   ALA A 142      28.398  54.568  91.503  1.00 17.80           N  
ATOM   1112  CA  ALA A 142      29.073  55.136  92.648  1.00 19.63           C  
ATOM   1113  C   ALA A 142      30.161  56.133  92.201  1.00 24.53           C  
ATOM   1114  O   ALA A 142      30.308  57.204  92.814  1.00 26.10           O  
ATOM   1115  CB  ALA A 142      29.641  54.069  93.541  1.00 21.07           C  
ATOM   1116  N   ARG A 143      30.910  55.811  91.131  1.00 23.23           N  
ATOM   1117  CA  ARG A 143      31.961  56.729  90.677  1.00 26.08           C  
ATOM   1118  C   ARG A 143      31.419  58.038  90.215  1.00 26.78           C  
ATOM   1119  O   ARG A 143      32.027  59.077  90.449  1.00 29.84           O  
ATOM   1120  CB  ARG A 143      32.782  56.162  89.501  1.00 26.94           C  
ATOM   1121  CG  ARG A 143      33.991  55.380  89.884  1.00 35.85           C  
ATOM   1122  CD  ARG A 143      35.004  55.328  88.679  1.00 33.89           C  
ATOM   1123  NE  ARG A 143      34.366  54.844  87.451  1.00 33.69           N  
ATOM   1124  CZ  ARG A 143      34.007  53.582  87.256  1.00 29.96           C  
ATOM   1125  NH1 ARG A 143      34.208  52.674  88.211  1.00 34.14           N  
ATOM   1126  NH2 ARG A 143      33.414  53.229  86.113  1.00 33.55           N  
ATOM   1127  N   VAL A 144      30.301  58.004  89.515  1.00 28.23           N  
ATOM   1128  CA  VAL A 144      29.721  59.243  89.021  1.00 31.12           C  
ATOM   1129  C   VAL A 144      29.418  60.164  90.199  1.00 30.80           C  
ATOM   1130  O   VAL A 144      29.762  61.340  90.173  1.00 32.83           O  
ATOM   1131  CB  VAL A 144      28.447  59.000  88.190  1.00 33.26           C  
ATOM   1132  CG1 VAL A 144      27.721  60.322  87.901  1.00 38.74           C  
ATOM   1133  CG2 VAL A 144      28.792  58.291  86.896  1.00 36.98           C  
ATOM   1134  N   PHE A 145      28.813  59.621  91.241  1.00 29.49           N  
ATOM   1135  CA  PHE A 145      28.474  60.422  92.408  1.00 30.35           C  
ATOM   1136  C   PHE A 145      29.674  60.856  93.249  1.00 33.97           C  
ATOM   1137  O   PHE A 145      29.672  61.964  93.811  1.00 34.44           O  
ATOM   1138  CB  PHE A 145      27.357  59.736  93.211  1.00 27.27           C  
ATOM   1139  CG  PHE A 145      26.046  59.753  92.489  1.00 25.81           C  
ATOM   1140  CD1 PHE A 145      25.365  60.942  92.303  1.00 27.86           C  
ATOM   1141  CD2 PHE A 145      25.484  58.605  91.981  1.00 20.94           C  
ATOM   1142  CE1 PHE A 145      24.154  60.986  91.625  1.00 28.02           C  
ATOM   1143  CE2 PHE A 145      24.274  58.655  91.312  1.00 24.21           C  
ATOM   1144  CZ  PHE A 145      23.615  59.843  91.134  1.00 31.14           C  
ATOM   1145  N   SER A 146      30.705  60.026  93.320  1.00 35.34           N  
ATOM   1146  CA  SER A 146      31.921  60.405  94.030  1.00 39.10           C  
ATOM   1147  C   SER A 146      32.642  61.560  93.349  1.00 42.85           C  
ATOM   1148  O   SER A 146      33.115  62.454  94.035  1.00 45.87           O  
ATOM   1149  CB  SER A 146      32.853  59.228  94.189  1.00 39.32           C  
ATOM   1150  OG  SER A 146      32.248  58.276  95.035  1.00 45.07           O  
ATOM   1151  N   TYR A 147      32.716  61.568  92.020  1.00 45.77           N  
ATOM   1152  CA  TYR A 147      33.349  62.683  91.306  1.00 48.27           C  
ATOM   1153  C   TYR A 147      32.506  63.953  91.462  1.00 50.86           C  
ATOM   1154  O   TYR A 147      31.295  63.948  91.199  1.00 52.30           O  
ATOM   1155  CB  TYR A 147      33.531  62.361  89.819  1.00 49.23           C  
ATOM   1156  N   PRO A 186      24.726  47.142  75.059  1.00 50.14           N  
ATOM   1157  CA  PRO A 186      24.838  45.693  75.272  1.00 48.68           C  
ATOM   1158  C   PRO A 186      25.090  44.917  73.985  1.00 47.11           C  
ATOM   1159  O   PRO A 186      25.838  43.949  74.003  1.00 45.09           O  
ATOM   1160  CB  PRO A 186      23.494  45.322  75.900  1.00 49.94           C  
ATOM   1161  CG  PRO A 186      23.108  46.553  76.678  1.00 49.18           C  
ATOM   1162  CD  PRO A 186      23.680  47.742  75.910  1.00 51.19           C  
ATOM   1163  N   GLU A 187      24.499  45.349  72.873  1.00 46.24           N  
ATOM   1164  CA  GLU A 187      24.737  44.688  71.572  1.00 47.12           C  
ATOM   1165  C   GLU A 187      26.104  45.031  70.935  1.00 44.64           C  
ATOM   1166  O   GLU A 187      26.474  44.456  69.910  1.00 45.61           O  
ATOM   1167  CB  GLU A 187      23.601  44.973  70.569  1.00 49.62           C  
ATOM   1168  CG  GLU A 187      23.500  46.405  69.998  1.00 54.68           C  
ATOM   1169  CD  GLU A 187      22.941  47.440  70.972  1.00 64.25           C  
ATOM   1170  OE1 GLU A 187      22.464  47.062  72.075  1.00 63.66           O  
ATOM   1171  OE2 GLU A 187      22.973  48.644  70.614  1.00 73.26           O  
ATOM   1172  N   THR A 188      26.834  45.981  71.521  1.00 42.26           N  
ATOM   1173  CA  THR A 188      28.169  46.359  71.040  1.00 38.45           C  
ATOM   1174  C   THR A 188      29.290  45.416  71.528  1.00 32.46           C  
ATOM   1175  O   THR A 188      30.415  45.546  71.103  1.00 34.10           O  
ATOM   1176  CB  THR A 188      28.535  47.767  71.540  1.00 37.32           C  
ATOM   1177  OG1 THR A 188      28.447  47.783  72.966  1.00 40.06           O  
ATOM   1178  CG2 THR A 188      27.567  48.821  70.980  1.00 45.18           C  
ATOM   1179  N   PHE A 189      28.971  44.458  72.384  1.00 26.20           N  
ATOM   1180  CA  PHE A 189      29.977  43.549  72.925  1.00 24.23           C  
ATOM   1181  C   PHE A 189      30.225  42.340  72.022  1.00 23.84           C  
ATOM   1182  O   PHE A 189      29.336  41.874  71.326  1.00 24.13           O  
ATOM   1183  CB  PHE A 189      29.582  43.146  74.326  1.00 24.42           C  
ATOM   1184  CG  PHE A 189      29.673  44.274  75.297  1.00 23.72           C  
ATOM   1185  CD1 PHE A 189      28.670  45.266  75.359  1.00 24.98           C  
ATOM   1186  CD2 PHE A 189      30.778  44.397  76.118  1.00 23.70           C  
ATOM   1187  CE1 PHE A 189      28.808  46.320  76.233  1.00 26.63           C  
ATOM   1188  CE2 PHE A 189      30.910  45.447  77.000  1.00 24.60           C  
ATOM   1189  CZ  PHE A 189      29.926  46.409  77.064  1.00 27.21           C  
ATOM   1190  N   TRP A 190      31.460  41.840  72.043  1.00 19.51           N  
ATOM   1191  CA  TRP A 190      31.863  40.741  71.192  1.00 18.62           C  
ATOM   1192  C   TRP A 190      31.300  39.412  71.607  1.00 18.21           C  
ATOM   1193  O   TRP A 190      30.903  38.593  70.753  1.00 19.66           O  
ATOM   1194  CB  TRP A 190      33.393  40.583  71.189  1.00 18.52           C  
ATOM   1195  CG  TRP A 190      34.120  41.697  70.613  1.00 21.04           C  
ATOM   1196  CD1 TRP A 190      34.802  42.682  71.273  1.00 21.06           C  
ATOM   1197  CD2 TRP A 190      34.255  41.964  69.235  1.00 21.40           C  
ATOM   1198  NE1 TRP A 190      35.352  43.560  70.372  1.00 21.95           N  
ATOM   1199  CE2 TRP A 190      35.024  43.135  69.108  1.00 26.40           C  
ATOM   1200  CE3 TRP A 190      33.803  41.322  68.082  1.00 27.95           C  
ATOM   1201  CZ2 TRP A 190      35.362  43.667  67.873  1.00 32.10           C  
ATOM   1202  CZ3 TRP A 190      34.128  41.856  66.859  1.00 32.29           C  
ATOM   1203  CH2 TRP A 190      34.909  43.014  66.761  1.00 28.69           C  
ATOM   1204  N   THR A 191      31.385  39.115  72.898  1.00 15.98           N  
ATOM   1205  CA  THR A 191      30.988  37.828  73.402  1.00 15.43           C  
ATOM   1206  C   THR A 191      29.564  37.792  73.935  1.00 15.76           C  
ATOM   1207  O   THR A 191      29.055  38.766  74.469  1.00 15.99           O  
ATOM   1208  CB  THR A 191      31.916  37.321  74.525  1.00 16.23           C  
ATOM   1209  OG1 THR A 191      31.839  38.182  75.671  1.00 15.35           O  
ATOM   1210  CG2 THR A 191      33.343  37.259  74.063  1.00 16.45           C  
ATOM   1211  N   GLU A 192      28.900  36.651  73.830  1.00 15.98           N  
ATOM   1212  CA  GLU A 192      27.570  36.527  74.385  1.00 17.85           C  
ATOM   1213  C   GLU A 192      27.549  36.720  75.901  1.00 19.83           C  
ATOM   1214  O   GLU A 192      26.613  37.301  76.451  1.00 18.12           O  
ATOM   1215  CB  GLU A 192      26.996  35.144  74.002  1.00 17.89           C  
ATOM   1216  CG  GLU A 192      25.592  34.892  74.529  1.00 22.61           C  
ATOM   1217  CD  GLU A 192      24.558  35.877  73.967  1.00 28.89           C  
ATOM   1218  OE1 GLU A 192      24.806  36.583  72.947  1.00 34.99           O  
ATOM   1219  OE2 GLU A 192      23.463  35.939  74.573  1.00 43.95           O  
ATOM   1220  N   THR A 193      28.546  36.213  76.593  1.00 17.48           N  
ATOM   1221  CA  THR A 193      28.617  36.382  78.026  1.00 16.56           C  
ATOM   1222  C   THR A 193      28.719  37.874  78.373  1.00 18.21           C  
ATOM   1223  O   THR A 193      27.991  38.333  79.280  1.00 17.87           O  
ATOM   1224  CB  THR A 193      29.795  35.605  78.638  1.00 15.90           C  
ATOM   1225  OG1 THR A 193      29.682  34.214  78.294  1.00 17.50           O  
ATOM   1226  CG2 THR A 193      29.921  35.796  80.133  1.00 17.79           C  
ATOM   1227  N   ALA A 194      29.566  38.642  77.685  1.00 18.14           N  
ATOM   1228  CA  ALA A 194      29.652  40.059  77.973  1.00 18.06           C  
ATOM   1229  C   ALA A 194      28.349  40.747  77.635  1.00 19.88           C  
ATOM   1230  O   ALA A 194      27.949  41.647  78.365  1.00 19.07           O  
ATOM   1231  CB  ALA A 194      30.806  40.727  77.227  1.00 17.82           C  
ATOM   1232  N   ARG A 195      27.693  40.361  76.536  1.00 18.96           N  
ATOM   1233  CA  ARG A 195      26.408  40.969  76.159  1.00 21.27           C  
ATOM   1234  C   ARG A 195      25.369  40.775  77.234  1.00 20.00           C  
ATOM   1235  O   ARG A 195      24.646  41.728  77.580  1.00 20.65           O  
ATOM   1236  CB  ARG A 195      25.878  40.397  74.852  1.00 22.17           C  
ATOM   1237  CG  ARG A 195      26.632  40.806  73.646  1.00 25.54           C  
ATOM   1238  CD  ARG A 195      25.775  40.523  72.425  1.00 37.70           C  
ATOM   1239  NE  ARG A 195      26.546  40.561  71.205  1.00 48.70           N  
ATOM   1240  CZ  ARG A 195      27.162  39.513  70.662  1.00 62.69           C  
ATOM   1241  NH1 ARG A 195      27.118  38.301  71.223  1.00 64.95           N  
ATOM   1242  NH2 ARG A 195      27.834  39.683  69.529  1.00 70.64           N  
ATOM   1243  N   LYS A 196      25.314  39.589  77.819  1.00 18.57           N  
ATOM   1244  CA  LYS A 196      24.378  39.308  78.902  1.00 21.66           C  
ATOM   1245  C   LYS A 196      24.723  40.120  80.145  1.00 22.70           C  
ATOM   1246  O   LYS A 196      23.842  40.628  80.815  1.00 22.79           O  
ATOM   1247  CB  LYS A 196      24.327  37.833  79.235  1.00 24.31           C  
ATOM   1248  CG  LYS A 196      23.652  37.012  78.125  1.00 29.69           C  
ATOM   1249  CD  LYS A 196      23.208  35.641  78.604  1.00 42.25           C  
ATOM   1250  CE  LYS A 196      24.359  34.731  78.998  1.00 51.49           C  
ATOM   1251  NZ  LYS A 196      25.186  34.312  77.828  1.00 61.86           N  
HETATM 1252  N   MSE A 197      26.009  40.213  80.469  0.50 19.78           N  
HETATM 1254  CA  MSE A 197      26.454  41.008  81.613  0.50 20.56           C  
HETATM 1256  C   MSE A 197      26.150  42.482  81.405  0.50 21.71           C  
HETATM 1258  O   MSE A 197      25.776  43.176  82.366  0.50 19.47           O  
HETATM 1260  CB  MSE A 197      27.952  40.798  81.856  0.50 21.36           C  
HETATM 1262  CG  MSE A 197      28.282  39.408  82.380  0.50 19.07           C  
HETATM 1264 SE   MSE A 197      30.198  38.987  82.334  0.37 15.09          SE  
HETATM 1266  CE  MSE A 197      30.885  39.813  83.936  0.50 20.94           C  
ATOM   1268  N   ALA A 198      26.323  42.968  80.175  1.00 21.15           N  
ATOM   1269  CA  ALA A 198      26.054  44.344  79.822  1.00 21.97           C  
ATOM   1270  C   ALA A 198      24.551  44.622  79.938  1.00 25.00           C  
ATOM   1271  O   ALA A 198      24.151  45.651  80.488  1.00 23.56           O  
ATOM   1272  CB  ALA A 198      26.521  44.645  78.432  1.00 21.22           C  
ATOM   1273  N   GLU A 199      23.730  43.694  79.445  1.00 23.67           N  
ATOM   1274  CA  GLU A 199      22.282  43.849  79.543  1.00 25.63           C  
ATOM   1275  C   GLU A 199      21.833  43.934  81.000  1.00 23.79           C  
ATOM   1276  O   GLU A 199      21.009  44.769  81.371  1.00 24.36           O  
ATOM   1277  CB  GLU A 199      21.588  42.668  78.861  1.00 25.12           C  
ATOM   1278  CG  GLU A 199      20.073  42.729  78.888  1.00 35.16           C  
ATOM   1279  N   ASP A 200      22.381  43.068  81.827  1.00 19.57           N  
ATOM   1280  CA  ASP A 200      22.067  43.022  83.223  1.00 20.95           C  
ATOM   1281  C   ASP A 200      22.504  44.326  83.932  1.00 20.24           C  
ATOM   1282  O   ASP A 200      21.708  44.958  84.665  1.00 20.57           O  
ATOM   1283  CB  ASP A 200      22.775  41.825  83.799  1.00 19.79           C  
ATOM   1284  CG  ASP A 200      22.592  41.674  85.271  1.00 25.94           C  
ATOM   1285  OD1 ASP A 200      21.429  41.597  85.761  1.00 26.19           O  
ATOM   1286  OD2 ASP A 200      23.620  41.581  85.970  1.00 26.39           O  
ATOM   1287  N   ARG A 201      23.754  44.725  83.736  1.00 20.54           N  
ATOM   1288  CA  ARG A 201      24.222  45.962  84.344  1.00 22.01           C  
ATOM   1289  C   ARG A 201      23.460  47.183  83.850  1.00 22.94           C  
ATOM   1290  O   ARG A 201      23.138  48.063  84.657  1.00 22.24           O  
ATOM   1291  CB  ARG A 201      25.705  46.153  84.089  1.00 21.52           C  
ATOM   1292  CG  ARG A 201      26.525  45.172  84.850  1.00 17.98           C  
ATOM   1293  CD  ARG A 201      27.974  45.423  84.529  1.00 21.10           C  
ATOM   1294  NE  ARG A 201      28.845  44.481  85.210  1.00 19.88           N  
ATOM   1295  CZ  ARG A 201      30.144  44.678  85.410  1.00 20.03           C  
ATOM   1296  NH1 ARG A 201      30.719  45.808  85.042  1.00 19.42           N  
ATOM   1297  NH2 ARG A 201      30.843  43.789  86.095  1.00 18.75           N  
ATOM   1298  N   TYR A 202      23.177  47.268  82.556  1.00 22.34           N  
ATOM   1299  CA  TYR A 202      22.461  48.387  81.967  1.00 25.42           C  
ATOM   1300  C   TYR A 202      21.027  48.482  82.533  1.00 23.19           C  
ATOM   1301  O   TYR A 202      20.541  49.574  82.840  1.00 23.52           O  
ATOM   1302  CB  TYR A 202      22.445  48.218  80.452  1.00 27.20           C  
ATOM   1303  CG  TYR A 202      21.876  49.388  79.702  1.00 36.18           C  
ATOM   1304  CD1 TYR A 202      20.513  49.475  79.434  1.00 35.12           C  
ATOM   1305  CD2 TYR A 202      22.694  50.417  79.278  1.00 48.36           C  
ATOM   1306  CE1 TYR A 202      19.985  50.553  78.758  1.00 43.76           C  
ATOM   1307  CE2 TYR A 202      22.175  51.501  78.595  1.00 51.98           C  
ATOM   1308  CZ  TYR A 202      20.819  51.564  78.340  1.00 47.18           C  
ATOM   1309  OH  TYR A 202      20.299  52.652  77.662  1.00 52.02           O  
ATOM   1310  N   SER A 203      20.357  47.345  82.664  0.50 20.53           N  
ATOM   1312  CA  SER A 203      19.006  47.334  83.229  0.50 22.08           C  
ATOM   1314  C   SER A 203      19.012  47.752  84.713  0.50 21.52           C  
ATOM   1316  O   SER A 203      18.004  48.273  85.218  0.50 19.81           O  
ATOM   1318  CB  SER A 203      18.349  45.976  83.050  0.50 23.45           C  
ATOM   1320  OG  SER A 203      18.190  45.700  81.678  0.50 27.87           O  
ATOM   1322  N   PHE A 204      20.110  47.478  85.422  1.00 21.15           N  
ATOM   1323  CA  PHE A 204      20.258  47.942  86.797  1.00 21.41           C  
ATOM   1324  C   PHE A 204      20.463  49.453  86.817  1.00 20.57           C  
ATOM   1325  O   PHE A 204      19.845  50.162  87.643  1.00 21.62           O  
ATOM   1326  CB  PHE A 204      21.405  47.216  87.540  1.00 19.55           C  
ATOM   1327  CG  PHE A 204      21.538  47.644  88.970  1.00 18.94           C  
ATOM   1328  CD1 PHE A 204      20.605  47.228  89.878  1.00 18.76           C  
ATOM   1329  CD2 PHE A 204      22.508  48.536  89.364  1.00 20.71           C  
ATOM   1330  CE1 PHE A 204      20.673  47.624  91.201  1.00 20.83           C  
ATOM   1331  CE2 PHE A 204      22.577  48.950  90.716  1.00 19.40           C  
ATOM   1332  CZ  PHE A 204      21.645  48.499  91.600  1.00 21.51           C  
ATOM   1333  N   VAL A 205      21.286  49.961  85.918  1.00 19.65           N  
ATOM   1334  CA  VAL A 205      21.521  51.395  85.808  1.00 20.66           C  
ATOM   1335  C   VAL A 205      20.219  52.135  85.478  1.00 22.80           C  
ATOM   1336  O   VAL A 205      19.943  53.176  86.088  1.00 21.29           O  
ATOM   1337  CB  VAL A 205      22.637  51.729  84.803  1.00 22.24           C  
ATOM   1338  CG1 VAL A 205      22.765  53.241  84.610  1.00 24.15           C  
ATOM   1339  CG2 VAL A 205      23.964  51.133  85.263  1.00 19.99           C  
ATOM   1340  N   VAL A 206      19.419  51.593  84.565  1.00 23.29           N  
ATOM   1341  CA  VAL A 206      18.148  52.210  84.190  1.00 26.11           C  
ATOM   1342  C   VAL A 206      17.224  52.267  85.400  1.00 24.58           C  
ATOM   1343  O   VAL A 206      16.648  53.324  85.699  1.00 24.05           O  
ATOM   1344  CB  VAL A 206      17.485  51.492  82.988  1.00 26.02           C  
ATOM   1345  CG1 VAL A 206      16.048  51.955  82.803  1.00 33.26           C  
ATOM   1346  CG2 VAL A 206      18.323  51.706  81.725  1.00 27.55           C  
ATOM   1347  N   GLU A 207      17.089  51.149  86.106  1.00 22.52           N  
ATOM   1348  CA  GLU A 207      16.287  51.124  87.316  1.00 23.91           C  
ATOM   1349  C   GLU A 207      16.778  52.155  88.345  1.00 22.79           C  
ATOM   1350  O   GLU A 207      15.963  52.830  88.991  1.00 19.97           O  
ATOM   1351  CB  GLU A 207      16.281  49.751  87.959  1.00 25.85           C  
ATOM   1352  CG  GLU A 207      15.385  49.688  89.220  1.00 27.90           C  
ATOM   1353  CD  GLU A 207      15.258  48.312  89.802  1.00 31.66           C  
ATOM   1354  OE1 GLU A 207      15.668  47.332  89.136  1.00 47.13           O  
ATOM   1355  OE2 GLU A 207      14.775  48.182  90.936  1.00 28.35           O  
ATOM   1356  N   PHE A 208      18.090  52.278  88.511  1.00 20.17           N  
ATOM   1357  CA  PHE A 208      18.644  53.261  89.428  1.00 18.29           C  
ATOM   1358  C   PHE A 208      18.160  54.665  89.051  1.00 19.75           C  
ATOM   1359  O   PHE A 208      17.726  55.428  89.929  1.00 19.06           O  
ATOM   1360  CB  PHE A 208      20.175  53.246  89.452  1.00 17.24           C  
ATOM   1361  CG  PHE A 208      20.758  54.134  90.522  1.00 17.07           C  
ATOM   1362  CD1 PHE A 208      20.866  55.494  90.320  1.00 21.17           C  
ATOM   1363  CD2 PHE A 208      21.146  53.609  91.748  1.00 22.13           C  
ATOM   1364  CE1 PHE A 208      21.357  56.311  91.329  1.00 17.93           C  
ATOM   1365  CE2 PHE A 208      21.644  54.417  92.730  1.00 20.13           C  
ATOM   1366  CZ  PHE A 208      21.740  55.759  92.530  1.00 18.91           C  
ATOM   1367  N   VAL A 209      18.254  55.008  87.774  1.00 20.93           N  
ATOM   1368  CA  VAL A 209      17.856  56.331  87.288  1.00 23.77           C  
ATOM   1369  C   VAL A 209      16.361  56.558  87.476  1.00 25.46           C  
ATOM   1370  O   VAL A 209      15.933  57.617  87.920  1.00 24.87           O  
ATOM   1371  CB  VAL A 209      18.242  56.528  85.813  1.00 26.15           C  
ATOM   1372  CG1 VAL A 209      17.651  57.826  85.262  1.00 28.00           C  
ATOM   1373  CG2 VAL A 209      19.730  56.565  85.657  1.00 26.54           C  
ATOM   1374  N   GLN A 210      15.573  55.564  87.139  1.00 22.98           N  
ATOM   1375  CA  GLN A 210      14.143  55.668  87.281  1.00 25.43           C  
ATOM   1376  C   GLN A 210      13.780  55.922  88.725  1.00 24.77           C  
ATOM   1377  O   GLN A 210      12.940  56.795  89.003  1.00 27.63           O  
ATOM   1378  CB  GLN A 210      13.462  54.413  86.753  1.00 26.16           C  
ATOM   1379  CG  GLN A 210      13.544  54.293  85.240  1.00 32.91           C  
ATOM   1380  CD  GLN A 210      13.017  52.968  84.721  1.00 34.54           C  
ATOM   1381  OE1 GLN A 210      12.946  51.983  85.460  1.00 48.57           O  
ATOM   1382  NE2 GLN A 210      12.657  52.933  83.440  1.00 45.48           N  
ATOM   1383  N   ARG A 211      14.388  55.164  89.642  1.00 21.30           N  
ATOM   1384  CA  ARG A 211      14.136  55.314  91.058  1.00 20.73           C  
ATOM   1385  C   ARG A 211      14.585  56.667  91.568  1.00 20.72           C  
ATOM   1386  O   ARG A 211      13.876  57.286  92.340  1.00 20.20           O  
ATOM   1387  CB  ARG A 211      14.817  54.207  91.879  1.00 21.40           C  
ATOM   1388  CG  ARG A 211      14.164  52.859  91.766  1.00 19.51           C  
ATOM   1389  CD  ARG A 211      14.915  51.806  92.579  1.00 20.15           C  
ATOM   1390  NE  ARG A 211      14.206  50.552  92.472  1.00 20.45           N  
ATOM   1391  CZ  ARG A 211      13.182  50.205  93.238  1.00 22.19           C  
ATOM   1392  NH1 ARG A 211      12.726  51.024  94.188  1.00 27.86           N  
ATOM   1393  NH2 ARG A 211      12.572  49.039  93.025  1.00 23.83           N  
ATOM   1394  N   PHE A 212      15.769  57.105  91.158  1.00 18.77           N  
ATOM   1395  CA  PHE A 212      16.303  58.406  91.528  1.00 19.49           C  
ATOM   1396  C   PHE A 212      15.297  59.494  91.164  1.00 22.62           C  
ATOM   1397  O   PHE A 212      14.929  60.321  92.006  1.00 22.81           O  
ATOM   1398  CB  PHE A 212      17.642  58.660  90.820  1.00 21.38           C  
ATOM   1399  CG  PHE A 212      18.375  59.867  91.307  1.00 21.47           C  
ATOM   1400  CD1 PHE A 212      18.061  61.112  90.812  1.00 28.42           C  
ATOM   1401  CD2 PHE A 212      19.372  59.762  92.234  1.00 18.15           C  
ATOM   1402  CE1 PHE A 212      18.745  62.231  91.253  1.00 30.74           C  
ATOM   1403  CE2 PHE A 212      20.048  60.872  92.700  1.00 21.83           C  
ATOM   1404  CZ  PHE A 212      19.747  62.103  92.201  1.00 26.60           C  
ATOM   1405  N   LEU A 213      14.848  59.463  89.928  1.00 24.33           N  
ATOM   1406  CA  LEU A 213      13.884  60.462  89.461  1.00 28.15           C  
ATOM   1407  C   LEU A 213      12.538  60.375  90.168  1.00 27.89           C  
ATOM   1408  O   LEU A 213      11.957  61.407  90.517  1.00 28.29           O  
ATOM   1409  CB  LEU A 213      13.693  60.320  87.962  1.00 27.01           C  
ATOM   1410  CG  LEU A 213      14.923  60.685  87.125  1.00 32.98           C  
ATOM   1411  CD1 LEU A 213      14.693  60.313  85.683  1.00 36.28           C  
ATOM   1412  CD2 LEU A 213      15.271  62.154  87.246  1.00 32.34           C  
ATOM   1413  N   ALA A 214      12.035  59.166  90.379  1.00 24.98           N  
ATOM   1414  CA  ALA A 214      10.776  58.993  91.079  1.00 25.93           C  
ATOM   1415  C   ALA A 214      10.873  59.503  92.516  1.00 27.47           C  
ATOM   1416  O   ALA A 214       9.942  60.157  93.012  1.00 27.55           O  
ATOM   1417  CB  ALA A 214      10.336  57.565  91.073  1.00 27.27           C  
ATOM   1418  N   GLU A 215      11.978  59.211  93.196  1.00 23.85           N  
ATOM   1419  CA  GLU A 215      12.170  59.656  94.573  1.00 26.20           C  
ATOM   1420  C   GLU A 215      12.432  61.143  94.700  1.00 29.27           C  
ATOM   1421  O   GLU A 215      12.061  61.758  95.694  1.00 29.77           O  
ATOM   1422  CB  GLU A 215      13.372  58.947  95.194  1.00 23.99           C  
ATOM   1423  CG  GLU A 215      13.220  57.431  95.393  1.00 24.07           C  
ATOM   1424  CD  GLU A 215      14.538  56.747  95.735  1.00 25.99           C  
ATOM   1425  OE1 GLU A 215      15.477  57.447  96.182  1.00 23.89           O  
ATOM   1426  OE2 GLU A 215      14.617  55.499  95.567  1.00 26.46           O  
ATOM   1427  N   TRP A 216      13.110  61.713  93.711  1.00 34.32           N  
ATOM   1428  CA  TRP A 216      13.486  63.116  93.762  1.00 37.39           C  
ATOM   1429  C   TRP A 216      12.250  64.006  93.675  1.00 40.04           C  
ATOM   1430  O   TRP A 216      12.234  65.101  94.252  1.00 40.38           O  
ATOM   1431  CB  TRP A 216      14.500  63.429  92.664  1.00 38.90           C  
ATOM   1432  CG  TRP A 216      15.132  64.765  92.802  1.00 43.58           C  
ATOM   1433  CD1 TRP A 216      14.711  65.936  92.233  1.00 46.63           C  
ATOM   1434  CD2 TRP A 216      16.309  65.078  93.548  1.00 45.35           C  
ATOM   1435  NE1 TRP A 216      15.560  66.966  92.580  1.00 44.24           N  
ATOM   1436  CE2 TRP A 216      16.548  66.466  93.391  1.00 49.59           C  
ATOM   1437  CE3 TRP A 216      17.177  64.331  94.348  1.00 45.52           C  
ATOM   1438  CZ2 TRP A 216      17.623  67.119  94.009  1.00 46.00           C  
ATOM   1439  CZ3 TRP A 216      18.252  64.979  94.963  1.00 46.14           C  
ATOM   1440  CH2 TRP A 216      18.465  66.362  94.788  1.00 45.90           C  
ATOM   1441  N   GLY A 217      11.219  63.513  92.991  1.00 41.61           N  
ATOM   1442  CA  GLY A 217       9.942  64.217  92.840  1.00 43.55           C  
ATOM   1443  C   GLY A 217       9.938  65.099  91.610  1.00 46.13           C  
ATOM   1444  O   GLY A 217      10.991  65.576  91.181  1.00 47.16           O  
TER    1445      GLY A 217                                                      
END
MOLECULE T0470_2_100.pdb
ATOM      1  N   THR     2      54.420  27.522  88.035  1.00 67.73           N  
ATOM      2  CA  THR     2      53.108  27.380  87.344  1.00 69.65           C  
ATOM      3  C   THR     2      52.525  28.722  86.889  1.00 69.97           C  
ATOM      4  O   THR     2      52.981  29.793  87.306  1.00 70.58           O  
ATOM      5  CB  THR     2      52.070  26.669  88.248  1.00 70.47           C  
ATOM      6  OG1 THR     2      50.847  26.474  87.525  1.00 71.89           O  
ATOM      7  CG2 THR     2      51.777  27.494  89.491  1.00 72.01           C  
ATOM      8  N   LYS     3      51.513  28.656  86.023  1.00 69.74           N  
ATOM      9  CA  LYS     3      50.861  29.849  85.484  1.00 69.53           C  
ATOM     10  C   LYS     3      50.268  30.737  86.573  1.00 70.20           C  
ATOM     11  O   LYS     3      50.510  31.945  86.591  1.00 69.16           O  
ATOM     12  CB  LYS     3      49.782  29.428  84.482  1.00 67.78           C  
ATOM     13  CG  LYS     3      50.303  29.361  83.052  1.00 68.14           C  
ATOM     14  CD  LYS     3      49.618  28.289  82.210  1.00 68.04           C  
ATOM     15  CE  LYS     3      49.960  28.461  80.732  1.00 67.69           C  
ATOM     16  NZ  LYS     3      51.397  28.805  80.520  1.00 68.33           N  
ATOM     17  N   GLN     4      49.505  30.130  87.481  1.00 70.53           N  
ATOM     18  CA  GLN     4      48.886  30.864  88.569  1.00 70.32           C  
ATOM     19  C   GLN     4      49.929  31.629  89.343  1.00 70.52           C  
ATOM     20  O   GLN     4      49.650  32.691  89.886  1.00 70.49           O  
ATOM     21  CB  GLN     4      48.149  29.918  89.517  1.00 70.74           C  
ATOM     22  CG  GLN     4      47.408  30.606  90.679  1.00 69.51           C  
ATOM     23  CD  GLN     4      46.205  31.420  90.223  1.00 68.71           C  
ATOM     24  OE1 GLN     4      45.399  30.969  89.405  1.00 68.36           O  
ATOM     25  NE2 GLN     4      46.064  32.617  90.776  1.00 68.07           N  
ATOM     26  N   GLU     5      51.137  31.100  89.418  1.00 72.17           N  
ATOM     27  CA  GLU     5      52.161  31.829  90.151  1.00 74.75           C  
ATOM     28  C   GLU     5      52.585  33.043  89.329  1.00 74.42           C  
ATOM     29  O   GLU     5      53.116  34.009  89.867  1.00 74.73           O  
ATOM     30  CB  GLU     5      53.366  30.926  90.458  1.00 76.64           C  
ATOM     31  CG  GLU     5      53.047  29.773  91.424  1.00 78.98           C  
ATOM     32  CD  GLU     5      54.280  28.980  91.856  1.00 79.51           C  
ATOM     33  OE1 GLU     5      55.222  29.593  92.417  1.00 79.22           O  
ATOM     34  OE2 GLU     5      54.298  27.744  91.649  1.00 79.24           O  
ATOM     35  N   LYS     6      52.328  32.993  88.026  1.00 73.80           N  
ATOM     36  CA  LYS     6      52.683  34.095  87.143  1.00 73.49           C  
ATOM     37  C   LYS     6      51.562  35.126  87.171  1.00 72.47           C  
ATOM     38  O   LYS     6      51.789  36.313  87.420  1.00 71.47           O  
ATOM     39  CB  LYS     6      52.922  33.561  85.727  1.00 75.15           C  
ATOM     40  CG  LYS     6      53.997  32.466  85.693  1.00 76.88           C  
ATOM     41  CD  LYS     6      54.449  32.067  84.283  1.00 76.71           C  
ATOM     42  CE  LYS     6      55.567  31.015  84.358  1.00 75.99           C  
ATOM     43  NZ  LYS     6      56.007  30.494  83.030  1.00 75.46           N  
ATOM     44  N   ILE     7      50.344  34.662  86.925  1.00 72.48           N  
ATOM     45  CA  ILE     7      49.190  35.538  86.961  1.00 72.23           C  
ATOM     46  C   ILE     7      49.228  36.208  88.335  1.00 72.32           C  
ATOM     47  O   ILE     7      48.704  37.300  88.502  1.00 73.73           O  
ATOM     48  CB  ILE     7      47.868  34.730  86.768  1.00 70.53           C  
ATOM     49  CG1 ILE     7      46.677  35.665  86.607  1.00 71.42           C  
ATOM     50  CG2 ILE     7      47.591  33.867  87.974  1.00 69.54           C  
ATOM     51  CD1 ILE     7      45.974  36.012  87.908  1.00 69.78           C  
ATOM     52  N   GLU     8      49.867  35.568  89.314  1.00 73.67           N  
ATOM     53  CA  GLU     8      49.958  36.157  90.650  1.00 74.45           C  
ATOM     54  C   GLU     8      51.022  37.243  90.738  1.00 74.03           C  
ATOM     55  O   GLU     8      50.756  38.341  91.224  1.00 75.27           O  
ATOM     56  CB  GLU     8      50.273  35.100  91.719  1.00 73.53           C  
ATOM     57  CG  GLU     8      49.055  34.457  92.367  1.00 75.26           C  
ATOM     58  CD  GLU     8      49.396  33.705  93.653  1.00 76.05           C  
ATOM     59  OE1 GLU     8      48.502  33.009  94.197  1.00 73.33           O  
ATOM     60  OE2 GLU     8      50.553  33.824  94.123  1.00 76.36           O  
ATOM     61  N   LYS     9      52.229  36.936  90.275  1.00 73.00           N  
ATOM     62  CA  LYS     9      53.322  37.894  90.358  1.00 72.14           C  
ATOM     63  C   LYS     9      53.089  39.085  89.445  1.00 72.09           C  
ATOM     64  O   LYS     9      53.622  40.178  89.668  1.00 70.96           O  
ATOM     65  CB  LYS     9      54.642  37.225  90.000  1.00 72.09           C  
ATOM     66  CG  LYS     9      55.819  37.867  90.700  1.00 72.17           C  
ATOM     67  CD  LYS     9      55.863  37.465  92.169  1.00 70.32           C  
ATOM     68  CE  LYS     9      56.739  38.411  92.991  1.00 69.14           C  
ATOM     69  NZ  LYS     9      56.059  39.713  93.280  1.00 66.21           N  
ATOM     70  N   THR    10      52.286  38.858  88.411  1.00 72.36           N  
ATOM     71  CA  THR    10      51.944  39.896  87.451  1.00 71.97           C  
ATOM     72  C   THR    10      50.982  40.874  88.183  1.00 71.19           C  
ATOM     73  O   THR    10      51.018  42.083  87.945  1.00 70.11           O  
ATOM     74  CB  THR    10      51.312  39.235  86.168  1.00 71.23           C  
ATOM     75  OG1 THR    10      51.643  40.001  85.000  1.00 69.88           O  
ATOM     76  CG2 THR    10      49.812  39.128  86.308  1.00 71.51           C  
ATOM     77  N   ILE    11      50.161  40.336  89.093  1.00 70.44           N  
ATOM     78  CA  ILE    11      49.219  41.124  89.904  1.00 69.72           C  
ATOM     79  C   ILE    11      50.035  42.057  90.766  1.00 71.16           C  
ATOM     80  O   ILE    11      49.551  43.080  91.257  1.00 71.13           O  
ATOM     81  CB  ILE    11      48.388  40.242  90.871  1.00 68.77           C  
ATOM     82  CG1 ILE    11      47.388  39.417  90.081  1.00 67.51           C  
ATOM     83  CG2 ILE    11      47.668  41.108  91.920  1.00 66.60           C  
ATOM     84  CD1 ILE    11      46.560  38.495  90.938  1.00 66.89           C  
ATOM     85  N   THR    12      51.283  41.681  90.970  1.00 72.51           N  
ATOM     86  CA  THR    12      52.155  42.500  91.759  1.00 73.91           C  
ATOM     87  C   THR    12      52.815  43.476  90.813  1.00 74.94           C  
ATOM     88  O   THR    12      53.055  44.622  91.173  1.00 75.82           O  
ATOM     89  CB  THR    12      53.201  41.642  92.473  1.00 75.30           C  
ATOM     90  OG1 THR    12      52.538  40.717  93.350  1.00 75.75           O  
ATOM     91  CG2 THR    12      54.145  42.526  93.284  1.00 76.45           C  
ATOM     92  N   PHE    13      53.071  43.034  89.586  1.00 75.86           N  
ATOM     93  CA  PHE    13      53.711  43.899  88.592  1.00 77.87           C  
ATOM     94  C   PHE    13      52.903  45.169  88.303  1.00 79.87           C  
ATOM     95  O   PHE    13      53.467  46.265  88.185  1.00 80.16           O  
ATOM     96  CB  PHE    13      53.940  43.127  87.291  1.00 76.60           C  
ATOM     97  CG  PHE    13      54.523  43.959  86.180  1.00 75.56           C  
ATOM     98  CD1 PHE    13      53.743  44.325  85.086  1.00 75.53           C  
ATOM     99  CD2 PHE    13      55.856  44.359  86.216  1.00 74.71           C  
ATOM    100  CE1 PHE    13      54.279  45.077  84.036  1.00 73.94           C  
ATOM    101  CE2 PHE    13      56.403  45.111  85.172  1.00 73.82           C  
ATOM    102  CZ  PHE    13      55.608  45.468  84.079  1.00 73.79           C  
ATOM    103  N   VAL    14      51.587  45.018  88.190  1.00 80.78           N  
ATOM    104  CA  VAL    14      50.717  46.147  87.927  1.00 81.21           C  
ATOM    105  C   VAL    14      50.497  46.914  89.220  1.00 83.76           C  
ATOM    106  O   VAL    14      50.582  48.134  89.241  1.00 85.04           O  
ATOM    107  CB  VAL    14      49.372  45.672  87.361  1.00 79.40           C  
ATOM    108  CG1 VAL    14      48.451  46.851  87.134  1.00 78.11           C  
ATOM    109  CG2 VAL    14      49.604  44.926  86.069  1.00 78.07           C  
ATOM    110  N   LYS    15      50.238  46.195  90.305  1.00 86.53           N  
ATOM    111  CA  LYS    15      50.010  46.838  91.594  1.00 89.42           C  
ATOM    112  C   LYS    15      51.136  47.797  91.974  1.00 92.04           C  
ATOM    113  O   LYS    15      50.909  48.804  92.650  1.00 91.87           O  
ATOM    114  CB  LYS    15      49.840  45.780  92.686  1.00 88.26           C  
ATOM    115  CG  LYS    15      48.424  45.229  92.793  1.00 87.49           C  
ATOM    116  CD  LYS    15      47.453  46.298  93.274  1.00 87.53           C  
ATOM    117  CE  LYS    15      46.640  45.797  94.462  1.00 87.66           C  
ATOM    118  NZ  LYS    15      45.830  46.861  95.134  1.00 86.79           N  
ATOM    119  N   HIS    16      52.344  47.486  91.518  1.00 95.20           N  
ATOM    120  CA  HIS    16      53.515  48.301  91.808  1.00 98.70           C  
ATOM    121  C   HIS    16      53.665  49.487  90.861  1.00 99.11           C  
ATOM    122  O   HIS    16      53.684  50.642  91.292  1.00 99.40           O  
ATOM    123  CB  HIS    16      54.783  47.437  91.756  1.00101.86           C  
ATOM    124  CG  HIS    16      55.481  47.306  93.076  1.00105.49           C  
ATOM    125  ND1 HIS    16      54.917  46.664  94.161  1.00106.97           N  
ATOM    126  CD2 HIS    16      56.685  47.762  93.496  1.00106.64           C  
ATOM    127  CE1 HIS    16      55.743  46.731  95.190  1.00107.92           C  
ATOM    128  NE2 HIS    16      56.824  47.394  94.814  1.00107.88           N  
ATOM    129  N   ILE    17      53.778  49.202  89.569  1.00 99.51           N  
ATOM    130  CA  ILE    17      53.945  50.257  88.577  1.00100.14           C  
ATOM    131  C   ILE    17      52.919  51.375  88.778  1.00100.65           C  
ATOM    132  O   ILE    17      53.162  52.521  88.400  1.00101.20           O  
ATOM    133  CB  ILE    17      53.827  49.695  87.139  1.00 99.75           C  
ATOM    134  CG1 ILE    17      54.322  50.731  86.138  1.00 99.34           C  
ATOM    135  CG2 ILE    17      52.386  49.319  86.835  1.00 99.68           C  
ATOM    136  CD1 ILE    17      55.770  51.105  86.326  1.00 99.26           C  
ATOM    137  N   LEU    18      51.780  51.040  89.380  1.00101.00           N  
ATOM    138  CA  LEU    18      50.732  52.024  89.637  1.00100.89           C  
ATOM    139  C   LEU    18      51.122  52.918  90.806  1.00101.50           C  
ATOM    140  O   LEU    18      50.451  53.906  91.094  1.00102.48           O  
ATOM    141  CB  LEU    18      49.396  51.330  89.947  1.00 99.29           C  
ATOM    142  CG  LEU    18      48.439  50.949  88.809  1.00 97.40           C  
ATOM    143  CD1 LEU    18      47.333  50.051  89.330  1.00 96.41           C  
ATOM    144  CD2 LEU    18      47.845  52.200  88.206  1.00 96.79           C  
ATOM    145  N   GLU    19      52.203  52.573  91.489  1.00101.98           N  
ATOM    146  CA  GLU    19      52.628  53.378  92.618  1.00103.29           C  
ATOM    147  C   GLU    19      53.678  54.398  92.190  1.00104.06           C  
ATOM    148  O   GLU    19      53.668  55.543  92.653  1.00104.54           O  
ATOM    149  CB  GLU    19      53.181  52.488  93.722  1.00103.20           C  
ATOM    150  CG  GLU    19      53.522  53.232  94.990  1.00103.43           C  
ATOM    151  CD  GLU    19      54.278  52.362  95.961  1.00104.06           C  
ATOM    152  OE1 GLU    19      55.462  52.057  95.693  1.00103.95           O  
ATOM    153  OE2 GLU    19      53.684  51.973  96.987  1.00104.64           O  
ATOM    154  N   LYS    20      54.579  53.988  91.300  1.00104.46           N  
ATOM    155  CA  LYS    20      55.623  54.888  90.812  1.00104.68           C  
ATOM    156  C   LYS    20      55.049  56.070  90.029  1.00104.66           C  
ATOM    157  O   LYS    20      55.796  56.822  89.401  1.00104.93           O  
ATOM    158  CB  LYS    20      56.616  54.142  89.910  1.00104.64           C  
ATOM    159  CG  LYS    20      57.659  53.292  90.629  1.00105.42           C  
ATOM    160  CD  LYS    20      57.151  51.896  90.962  1.00105.46           C  
ATOM    161  CE  LYS    20      58.321  50.946  91.197  1.00105.42           C  
ATOM    162  NZ  LYS    20      57.901  49.517  91.263  1.00104.88           N  
ATOM    163  N   ASP    21      53.731  56.236  90.059  1.00104.17           N  
ATOM    164  CA  ASP    21      53.103  57.338  89.337  1.00104.08           C  
ATOM    165  C   ASP    21      51.638  57.467  89.721  1.00102.94           C  
ATOM    166  O   ASP    21      51.298  57.504  90.908  1.00102.07           O  
ATOM    167  CB  ASP    21      53.222  57.118  87.817  1.00105.75           C  
ATOM    168  CG  ASP    21      52.880  58.371  87.003  1.00107.30           C  
ATOM    169  OD1 ASP    21      52.908  58.292  85.751  1.00108.74           O  
ATOM    170  OD2 ASP    21      52.592  59.431  87.609  1.00106.97           O  
ATOM    171  N   ALA    22      50.789  57.527  88.695  1.00101.55           N  
ATOM    172  CA  ALA    22      49.342  57.663  88.831  1.00 99.78           C  
ATOM    173  C   ALA    22      48.850  57.483  90.258  1.00 98.72           C  
ATOM    174  O   ALA    22      48.964  58.387  91.095  1.00 97.73           O  
ATOM    175  CB  ALA    22      48.637  56.669  87.906  1.00 98.99           C  
ATOM    176  N   SER    23      48.305  56.304  90.526  1.00 97.73           N  
ATOM    177  CA  SER    23      47.781  55.983  91.844  1.00 96.67           C  
ATOM    178  C   SER    23      47.405  54.521  91.962  1.00 93.94           C  
ATOM    179  O   SER    23      46.808  53.941  91.052  1.00 93.15           O  
ATOM    180  CB  SER    23      46.544  56.831  92.150  1.00 98.93           C  
ATOM    181  OG  SER    23      45.855  56.317  93.279  1.00101.01           O  
ATOM    182  N   GLY    24      47.747  53.934  93.100  1.00 91.17           N  
ATOM    183  CA  GLY    24      47.416  52.547  93.324  1.00 88.31           C  
ATOM    184  C   GLY    24      45.926  52.425  93.538  1.00 85.81           C  
ATOM    185  O   GLY    24      45.453  51.472  94.161  1.00 85.71           O  
ATOM    186  N   HIS    25      45.175  53.395  93.032  1.00 83.24           N  
ATOM    187  CA  HIS    25      43.738  53.342  93.195  1.00 81.98           C  
ATOM    188  C   HIS    25      43.058  52.852  91.917  1.00 80.44           C  
ATOM    189  O   HIS    25      41.926  52.355  91.961  1.00 79.67           O  
ATOM    190  CB  HIS    25      43.201  54.706  93.633  1.00 83.23           C  
ATOM    191  CG  HIS    25      41.775  54.670  94.088  1.00 84.88           C  
ATOM    192  ND1 HIS    25      41.314  53.769  95.025  1.00 85.42           N  
ATOM    193  CD2 HIS    25      40.702  55.406  93.714  1.00 84.94           C  
ATOM    194  CE1 HIS    25      40.018  53.948  95.204  1.00 85.70           C  
ATOM    195  NE2 HIS    25      39.622  54.935  94.420  1.00 85.98           N  
ATOM    196  N   ASP    26      43.757  52.958  90.784  1.00 79.12           N  
ATOM    197  CA  ASP    26      43.212  52.475  89.503  1.00 77.77           C  
ATOM    198  C   ASP    26      43.214  50.945  89.471  1.00 76.08           C  
ATOM    199  O   ASP    26      42.777  50.341  88.491  1.00 75.82           O  
ATOM    200  CB  ASP    26      44.034  52.977  88.307  1.00 77.40           C  
ATOM    201  CG  ASP    26      43.863  54.456  88.058  1.00 77.10           C  
ATOM    202  OD1 ASP    26      42.700  54.928  87.991  1.00 76.65           O  
ATOM    203  OD2 ASP    26      44.898  55.146  87.912  1.00 75.69           O  
ATOM    204  N   TRP    27      43.728  50.333  90.537  1.00 73.47           N  
ATOM    205  CA  TRP    27      43.779  48.888  90.635  1.00 70.85           C  
ATOM    206  C   TRP    27      42.388  48.305  90.787  1.00 68.98           C  
ATOM    207  O   TRP    27      42.028  47.349  90.096  1.00 70.15           O  
ATOM    208  CB  TRP    27      44.649  48.432  91.817  1.00 71.69           C  
ATOM    209  CG  TRP    27      44.241  47.064  92.346  1.00 73.38           C  
ATOM    210  CD1 TRP    27      43.473  46.804  93.458  1.00 74.39           C  
ATOM    211  CD2 TRP    27      44.455  45.796  91.714  1.00 73.53           C  
ATOM    212  NE1 TRP    27      43.191  45.462  93.549  1.00 73.85           N  
ATOM    213  CE2 TRP    27      43.783  44.819  92.494  1.00 74.77           C  
ATOM    214  CE3 TRP    27      45.143  45.388  90.567  1.00 72.74           C  
ATOM    215  CZ2 TRP    27      43.781  43.459  92.155  1.00 75.30           C  
ATOM    216  CZ3 TRP    27      45.139  44.037  90.231  1.00 74.15           C  
ATOM    217  CH2 TRP    27      44.463  43.089  91.024  1.00 74.79           C  
ATOM    218  N   TYR    28      41.596  48.873  91.687  1.00 65.51           N  
ATOM    219  CA  TYR    28      40.252  48.347  91.912  1.00 62.28           C  
ATOM    220  C   TYR    28      39.476  48.235  90.598  1.00 58.54           C  
ATOM    221  O   TYR    28      38.558  47.439  90.498  1.00 56.72           O  
ATOM    222  CB  TYR    28      39.515  49.208  92.951  1.00 64.73           C  
ATOM    223  CG  TYR    28      40.224  49.245  94.303  1.00 67.03           C  
ATOM    224  CD1 TYR    28      41.480  49.853  94.444  1.00 68.58           C  
ATOM    225  CD2 TYR    28      39.659  48.637  95.433  1.00 67.35           C  
ATOM    226  CE1 TYR    28      42.156  49.849  95.674  1.00 69.21           C  
ATOM    227  CE2 TYR    28      40.326  48.632  96.666  1.00 67.81           C  
ATOM    228  CZ  TYR    28      41.570  49.238  96.774  1.00 68.84           C  
ATOM    229  OH  TYR    28      42.228  49.226  97.980  1.00 70.91           O  
ATOM    230  N   HIS    29      39.866  49.016  89.593  1.00 55.40           N  
ATOM    231  CA  HIS    29      39.227  48.949  88.287  1.00 53.42           C  
ATOM    232  C   HIS    29      39.777  47.765  87.513  1.00 51.44           C  
ATOM    233  O   HIS    29      39.034  47.009  86.902  1.00 49.77           O  
ATOM    234  CB  HIS    29      39.485  50.221  87.475  1.00 55.32           C  
ATOM    235  CG  HIS    29      39.470  50.003  85.984  1.00 56.65           C  
ATOM    236  ND1 HIS    29      38.372  49.514  85.306  1.00 57.67           N  
ATOM    237  CD2 HIS    29      40.417  50.231  85.041  1.00 56.45           C  
ATOM    238  CE1 HIS    29      38.640  49.456  84.010  1.00 56.41           C  
ATOM    239  NE2 HIS    29      39.874  49.886  83.823  1.00 56.73           N  
ATOM    240  N   ILE    30      41.101  47.649  87.518  1.00 51.15           N  
ATOM    241  CA  ILE    30      41.801  46.572  86.828  1.00 51.20           C  
ATOM    242  C   ILE    30      41.229  45.238  87.300  1.00 53.62           C  
ATOM    243  O   ILE    30      40.860  44.378  86.488  1.00 53.68           O  
ATOM    244  CB  ILE    30      43.324  46.517  87.154  1.00 48.66           C  
ATOM    245  CG1 ILE    30      43.969  47.897  87.045  1.00 44.66           C  
ATOM    246  CG2 ILE    30      43.995  45.513  86.211  1.00 48.04           C  
ATOM    247  CD1 ILE    30      44.237  48.358  85.653  1.00 43.24           C  
ATOM    248  N   ARG    31      41.175  45.061  88.622  1.00 54.08           N  
ATOM    249  CA  ARG    31      40.676  43.817  89.194  1.00 54.15           C  
ATOM    250  C   ARG    31      39.234  43.543  88.788  1.00 52.06           C  
ATOM    251  O   ARG    31      38.924  42.494  88.229  1.00 51.50           O  
ATOM    252  CB  ARG    31      40.805  43.823  90.725  1.00 56.17           C  
ATOM    253  CG  ARG    31      40.390  42.491  91.340  1.00 60.09           C  
ATOM    254  CD  ARG    31      40.510  42.471  92.856  1.00 63.32           C  
ATOM    255  NE  ARG    31      39.691  43.495  93.505  1.00 65.45           N  
ATOM    256  CZ  ARG    31      39.502  43.561  94.823  1.00 66.81           C  
ATOM    257  NH1 ARG    31      40.069  42.659  95.621  1.00 66.56           N  
ATOM    258  NH2 ARG    31      38.759  44.528  95.351  1.00 65.71           N  
ATOM    259  N   ARG    32      38.358  44.492  89.071  1.00 51.28           N  
ATOM    260  CA  ARG    32      36.951  44.360  88.729  1.00 50.62           C  
ATOM    261  C   ARG    32      36.765  43.820  87.312  1.00 51.83           C  
ATOM    262  O   ARG    32      35.852  43.041  87.057  1.00 51.50           O  
ATOM    263  CB  ARG    32      36.276  45.712  88.846  1.00 48.27           C  
ATOM    264  CG  ARG    32      35.011  45.680  89.608  1.00 46.09           C  
ATOM    265  CD  ARG    32      34.328  47.014  89.485  1.00 47.69           C  
ATOM    266  NE  ARG    32      35.049  48.077  90.169  1.00 47.67           N  
ATOM    267  CZ  ARG    32      35.808  48.993  89.578  1.00 47.94           C  
ATOM    268  NH1 ARG    32      36.414  49.916  90.319  1.00 47.18           N  
ATOM    269  NH2 ARG    32      35.957  48.996  88.259  1.00 49.59           N  
ATOM    270  N   VAL    33      37.632  44.239  86.394  1.00 53.39           N  
ATOM    271  CA  VAL    33      37.567  43.781  85.003  1.00 54.19           C  
ATOM    272  C   VAL    33      38.111  42.351  84.934  1.00 55.41           C  
ATOM    273  O   VAL    33      37.501  41.474  84.322  1.00 54.30           O  
ATOM    274  CB  VAL    33      38.413  44.687  84.050  1.00 53.90           C  
ATOM    275  CG1 VAL    33      38.346  44.162  82.624  1.00 51.59           C  
ATOM    276  CG2 VAL    33      37.901  46.114  84.100  1.00 53.88           C  
ATOM    277  N   HIS    34      39.264  42.135  85.572  1.00 56.32           N  
ATOM    278  CA  HIS    34      39.923  40.826  85.620  1.00 55.84           C  
ATOM    279  C   HIS    34      38.996  39.755  86.217  1.00 56.94           C  
ATOM    280  O   HIS    34      38.687  38.754  85.561  1.00 56.34           O  
ATOM    281  CB  HIS    34      41.224  40.912  86.439  1.00 54.06           C  
ATOM    282  CG  HIS    34      41.802  39.575  86.794  1.00 52.65           C  
ATOM    283  ND1 HIS    34      41.877  38.535  85.894  1.00 50.77           N  
ATOM    284  CD2 HIS    34      42.330  39.108  87.952  1.00 52.11           C  
ATOM    285  CE1 HIS    34      42.424  37.485  86.480  1.00 50.16           C  
ATOM    286  NE2 HIS    34      42.708  37.805  87.728  1.00 50.45           N  
ATOM    287  N   LYS    35      38.549  39.958  87.455  1.00 56.59           N  
ATOM    288  CA  LYS    35      37.659  38.985  88.065  1.00 55.98           C  
ATOM    289  C   LYS    35      36.457  38.761  87.151  1.00 56.88           C  
ATOM    290  O   LYS    35      35.891  37.674  87.089  1.00 56.33           O  
ATOM    291  CB  LYS    35      37.201  39.472  89.439  1.00 53.59           C  
ATOM    292  CG  LYS    35      38.334  39.690  90.416  1.00 50.94           C  
ATOM    293  CD  LYS    35      37.800  40.159  91.759  1.00 50.35           C  
ATOM    294  CE  LYS    35      37.179  39.030  92.574  1.00 48.14           C  
ATOM    295  NZ  LYS    35      38.181  38.374  93.467  1.00 47.39           N  
ATOM    296  N   MET    36      36.091  39.803  86.424  1.00 59.10           N  
ATOM    297  CA  MET    36      34.960  39.753  85.511  1.00 62.62           C  
ATOM    298  C   MET    36      35.278  38.960  84.233  1.00 61.88           C  
ATOM    299  O   MET    36      34.404  38.286  83.671  1.00 62.26           O  
ATOM    300  CB  MET    36      34.539  41.187  85.171  1.00 67.04           C  
ATOM    301  CG  MET    36      33.169  41.333  84.535  1.00 72.36           C  
ATOM    302  SD  MET    36      32.234  42.926  85.147  1.00 81.64          SE  
ATOM    303  CE  MET    36      33.734  44.163  85.380  1.00 77.97           C  
ATOM    304  N   ALA    37      36.527  39.046  83.780  1.00 60.52           N  
ATOM    305  CA  ALA    37      36.968  38.332  82.585  1.00 58.25           C  
ATOM    306  C   ALA    37      37.003  36.852  82.909  1.00 56.97           C  
ATOM    307  O   ALA    37      36.825  36.009  82.026  1.00 55.56           O  
ATOM    308  CB  ALA    37      38.343  38.805  82.164  1.00 59.39           C  
ATOM    309  N   ILE    38      37.249  36.540  84.179  1.00 55.28           N  
ATOM    310  CA  ILE    38      37.252  35.153  84.601  1.00 54.56           C  
ATOM    311  C   ILE    38      35.823  34.652  84.444  1.00 55.34           C  
ATOM    312  O   ILE    38      35.507  33.926  83.510  1.00 55.56           O  
ATOM    313  CB  ILE    38      37.623  34.976  86.078  1.00 53.58           C  
ATOM    314  CG1 ILE    38      39.065  35.405  86.320  1.00 52.95           C  
ATOM    315  CG2 ILE    38      37.404  33.521  86.479  1.00 52.78           C  
ATOM    316  CD1 ILE    38      40.072  34.576  85.600  1.00 52.24           C  
ATOM    317  N   SER    39      34.959  35.068  85.359  1.00 55.32           N  
ATOM    318  CA  SER    39      33.573  34.645  85.344  1.00 56.07           C  
ATOM    319  C   SER    39      32.968  34.566  83.957  1.00 56.48           C  
ATOM    320  O   SER    39      32.089  33.741  83.699  1.00 55.65           O  
ATOM    321  CB  SER    39      32.749  35.572  86.226  1.00 56.50           C  
ATOM    322  OG  SER    39      33.229  35.508  87.550  1.00 59.84           O  
ATOM    323  N   LEU    40      33.451  35.419  83.064  1.00 57.31           N  
ATOM    324  CA  LEU    40      32.960  35.450  81.693  1.00 59.67           C  
ATOM    325  C   LEU    40      33.495  34.249  80.879  1.00 61.86           C  
ATOM    326  O   LEU    40      32.736  33.576  80.169  1.00 61.73           O  
ATOM    327  CB  LEU    40      33.367  36.778  81.046  1.00 59.16           C  
ATOM    328  CG  LEU    40      32.337  37.625  80.294  1.00 58.09           C  
ATOM    329  CD1 LEU    40      31.103  37.876  81.142  1.00 57.41           C  
ATOM    330  CD2 LEU    40      32.994  38.935  79.902  1.00 55.70           C  
ATOM    331  N   SER    41      34.795  33.970  80.996  1.00 63.41           N  
ATOM    332  CA  SER    41      35.410  32.847  80.270  1.00 63.60           C  
ATOM    333  C   SER    41      34.805  31.530  80.710  1.00 63.06           C  
ATOM    334  O   SER    41      34.439  30.702  79.880  1.00 61.82           O  
ATOM    335  CB  SER    41      36.937  32.800  80.500  1.00 64.79           C  
ATOM    336  OG  SER    41      37.285  32.046  81.658  1.00 63.73           O  
ATOM    337  N   GLU    42      34.717  31.354  82.026  1.00 62.63           N  
ATOM    338  CA  GLU    42      34.164  30.141  82.606  1.00 61.99           C  
ATOM    339  C   GLU    42      32.690  30.023  82.279  1.00 60.99           C  
ATOM    340  O   GLU    42      31.904  29.451  83.022  1.00 60.52           O  
ATOM    341  CB  GLU    42      34.377  30.105  84.125  1.00 62.67           C  
ATOM    342  CG  GLU    42      33.401  30.918  84.953  1.00 62.19           C  
ATOM    343  CD  GLU    42      33.918  31.142  86.361  1.00 62.74           C  
ATOM    344  OE1 GLU    42      33.116  31.508  87.246  1.00 62.64           O  
ATOM    345  OE2 GLU    42      35.140  30.973  86.577  1.00 62.23           O  
ATOM    346  N   GLN    43      32.310  30.580  81.150  1.00 59.93           N  
ATOM    347  CA  GLN    43      30.945  30.468  80.745  1.00 58.67           C  
ATOM    348  C   GLN    43      30.904  30.640  79.257  1.00 58.36           C  
ATOM    349  O   GLN    43      29.860  30.480  78.632  1.00 58.42           O  
ATOM    350  CB  GLN    43      30.096  31.522  81.412  1.00 59.96           C  
ATOM    351  CG  GLN    43      28.648  31.260  81.180  1.00 61.85           C  
ATOM    352  CD  GLN    43      27.815  31.788  82.291  1.00 62.80           C  
ATOM    353  OE1 GLN    43      26.603  31.585  82.327  1.00 64.57           O  
ATOM    354  NE2 GLN    43      28.457  32.478  83.223  1.00 62.58           N  
ATOM    355  N   GLU    44      32.062  30.948  78.687  1.00 56.60           N  
ATOM    356  CA  GLU    44      32.157  31.156  77.257  1.00 54.77           C  
ATOM    357  C   GLU    44      33.349  30.476  76.611  1.00 54.02           C  
ATOM    358  O   GLU    44      33.458  30.456  75.389  1.00 51.36           O  
ATOM    359  CB  GLU    44      32.226  32.645  76.963  1.00 56.28           C  
ATOM    360  CG  GLU    44      30.946  33.396  77.190  1.00 55.44           C  
ATOM    361  CD  GLU    44      29.845  32.942  76.270  1.00 58.05           C  
ATOM    362  OE1 GLU    44      30.150  32.492  75.138  1.00 57.77           O  
ATOM    363  OE2 GLU    44      28.665  33.049  76.675  1.00 59.93           O  
ATOM    364  N   GLY    45      34.248  29.937  77.428  1.00 54.00           N  
ATOM    365  CA  GLY    45      35.418  29.268  76.892  1.00 53.58           C  
ATOM    366  C   GLY    45      36.656  30.149  76.854  1.00 53.71           C  
ATOM    367  O   GLY    45      36.869  30.965  77.753  1.00 56.62           O  
ATOM    368  N   GLY    46      37.474  29.975  75.815  1.00 52.13           N  
ATOM    369  CA  GLY    46      38.703  30.742  75.660  1.00 49.24           C  
ATOM    370  C   GLY    46      39.796  30.423  76.673  1.00 48.72           C  
ATOM    371  O   GLY    46      39.519  29.985  77.795  1.00 47.46           O  
ATOM    372  N   ASN    47      41.047  30.672  76.289  1.00 48.16           N  
ATOM    373  CA  ASN    47      42.190  30.399  77.163  1.00 49.52           C  
ATOM    374  C   ASN    47      42.307  31.299  78.387  1.00 50.80           C  
ATOM    375  O   ASN    47      42.789  32.425  78.279  1.00 52.11           O  
ATOM    376  CB  ASN    47      43.494  30.520  76.391  1.00 49.39           C  
ATOM    377  CG  ASN    47      44.687  30.074  77.215  1.00 49.42           C  
ATOM    378  OD1 ASN    47      44.642  30.082  78.450  1.00 45.46           O  
ATOM    379  ND2 ASN    47      45.766  29.682  76.534  1.00 48.99           N  
ATOM    380  N   ARG    48      41.914  30.796  79.553  1.00 51.76           N  
ATOM    381  CA  ARG    48      41.987  31.582  80.780  1.00 51.84           C  
ATOM    382  C   ARG    48      43.284  32.372  80.928  1.00 51.82           C  
ATOM    383  O   ARG    48      43.280  33.595  80.782  1.00 51.81           O  
ATOM    384  CB  ARG    48      41.780  30.683  81.992  1.00 53.07           C  
ATOM    385  CG  ARG    48      40.309  30.400  82.278  1.00 57.10           C  
ATOM    386  CD  ARG    48      39.735  31.481  83.181  1.00 59.98           C  
ATOM    387  NE  ARG    48      40.602  31.683  84.348  1.00 61.76           N  
ATOM    388  CZ  ARG    48      40.326  31.286  85.589  1.00 60.86           C  
ATOM    389  NH1 ARG    48      39.184  30.661  85.857  1.00 59.67           N  
ATOM    390  NH2 ARG    48      41.210  31.501  86.559  1.00 59.79           N  
ATOM    391  N   PHE    49      44.394  31.697  81.203  1.00 51.76           N  
ATOM    392  CA  PHE    49      45.666  32.408  81.356  1.00 51.74           C  
ATOM    393  C   PHE    49      45.840  33.601  80.425  1.00 51.33           C  
ATOM    394  O   PHE    49      46.225  34.681  80.862  1.00 52.80           O  
ATOM    395  CB  PHE    49      46.830  31.481  81.111  1.00 51.48           C  
ATOM    396  CG  PHE    49      48.155  32.118  81.341  1.00 52.07           C  
ATOM    397  CD1 PHE    49      49.094  32.186  80.318  1.00 52.10           C  
ATOM    398  CD2 PHE    49      48.514  32.550  82.618  1.00 52.69           C  
ATOM    399  CE1 PHE    49      50.389  32.664  80.565  1.00 53.59           C  
ATOM    400  CE2 PHE    49      49.806  33.028  82.877  1.00 53.77           C  
ATOM    401  CZ  PHE    49      50.751  33.084  81.847  1.00 52.32           C  
ATOM    402  N   ILE    50      45.588  33.406  79.137  1.00 50.70           N  
ATOM    403  CA  ILE    50      45.739  34.514  78.214  1.00 50.46           C  
ATOM    404  C   ILE    50      44.749  35.584  78.623  1.00 49.83           C  
ATOM    405  O   ILE    50      45.142  36.714  78.886  1.00 51.30           O  
ATOM    406  CB  ILE    50      45.510  34.097  76.725  1.00 49.38           C  
ATOM    407  CG1 ILE    50      46.774  33.430  76.170  1.00 48.19           C  
ATOM    408  CG2 ILE    50      45.234  35.319  75.874  1.00 48.93           C  
ATOM    409  CD1 ILE    50      46.609  32.873  74.783  1.00 47.73           C  
ATOM    410  N   ILE    51      43.472  35.227  78.705  1.00 49.94           N  
ATOM    411  CA  ILE    51      42.448  36.195  79.082  1.00 50.81           C  
ATOM    412  C   ILE    51      42.883  36.992  80.317  1.00 53.81           C  
ATOM    413  O   ILE    51      42.873  38.229  80.291  1.00 55.26           O  
ATOM    414  CB  ILE    51      41.099  35.505  79.356  1.00 46.63           C  
ATOM    415  CG1 ILE    51      40.559  34.913  78.061  1.00 45.05           C  
ATOM    416  CG2 ILE    51      40.102  36.504  79.899  1.00 45.01           C  
ATOM    417  CD1 ILE    51      39.285  34.109  78.227  1.00 44.42           C  
ATOM    418  N   GLU    52      43.285  36.292  81.381  1.00 55.37           N  
ATOM    419  CA  GLU    52      43.718  36.952  82.608  1.00 57.49           C  
ATOM    420  C   GLU    52      44.933  37.841  82.408  1.00 58.45           C  
ATOM    421  O   GLU    52      44.906  39.026  82.735  1.00 59.10           O  
ATOM    422  CB  GLU    52      44.043  35.928  83.683  1.00 56.94           C  
ATOM    423  CG  GLU    52      42.875  35.139  84.137  1.00 58.84           C  
ATOM    424  CD  GLU    52      43.189  34.348  85.379  1.00 62.43           C  
ATOM    425  OE1 GLU    52      43.505  34.968  86.416  1.00 63.83           O  
ATOM    426  OE2 GLU    52      43.125  33.102  85.326  1.00 66.05           O  
ATOM    427  N   MET    53      46.008  37.267  81.887  1.00 60.12           N  
ATOM    428  CA  MET    53      47.213  38.051  81.661  1.00 63.39           C  
ATOM    429  C   MET    53      46.903  39.291  80.832  1.00 62.71           C  
ATOM    430  O   MET    53      47.500  40.356  81.037  1.00 62.91           O  
ATOM    431  CB  MET    53      48.274  37.225  80.941  1.00 67.12           C  
ATOM    432  CG  MET    53      48.942  36.210  81.823  1.00 73.08           C  
ATOM    433  SD  MET    53      49.749  37.059  83.358  1.00 83.60          SE  
ATOM    434  CE  MET    53      51.366  37.718  82.523  1.00 78.14           C  
ATOM    435  N   ALA    54      45.966  39.159  79.898  1.00 59.46           N  
ATOM    436  CA  ALA    54      45.625  40.288  79.052  1.00 57.21           C  
ATOM    437  C   ALA    54      44.861  41.346  79.830  1.00 55.89           C  
ATOM    438  O   ALA    54      45.317  42.490  79.935  1.00 57.33           O  
ATOM    439  CB  ALA    54      44.826  39.827  77.849  1.00 55.59           C  
ATOM    440  N   ALA    55      43.717  40.971  80.393  1.00 53.22           N  
ATOM    441  CA  ALA    55      42.894  41.910  81.150  1.00 50.69           C  
ATOM    442  C   ALA    55      43.701  42.646  82.206  1.00 50.15           C  
ATOM    443  O   ALA    55      43.427  43.796  82.508  1.00 48.41           O  
ATOM    444  CB  ALA    55      41.761  41.166  81.808  1.00 50.25           C  
ATOM    445  N   LEU    56      44.704  41.966  82.750  1.00 51.07           N  
ATOM    446  CA  LEU    56      45.559  42.507  83.792  1.00 51.70           C  
ATOM    447  C   LEU    56      46.627  43.484  83.326  1.00 54.01           C  
ATOM    448  O   LEU    56      47.231  44.160  84.155  1.00 54.43           O  
ATOM    449  CB  LEU    56      46.251  41.361  84.522  1.00 51.37           C  
ATOM    450  CG  LEU    56      45.783  40.934  85.917  1.00 51.81           C  
ATOM    451  CD1 LEU    56      45.348  39.469  85.913  1.00 51.25           C  
ATOM    452  CD2 LEU    56      46.937  41.137  86.898  1.00 50.58           C  
ATOM    453  N   LEU    57      46.873  43.574  82.020  1.00 55.71           N  
ATOM    454  CA  LEU    57      47.917  44.475  81.533  1.00 56.87           C  
ATOM    455  C   LEU    57      47.495  45.454  80.427  1.00 58.78           C  
ATOM    456  O   LEU    57      48.340  46.209  79.916  1.00 59.98           O  
ATOM    457  CB  LEU    57      49.135  43.645  81.079  1.00 56.76           C  
ATOM    458  CG  LEU    57      49.916  42.822  82.129  1.00 55.77           C  
ATOM    459  CD1 LEU    57      50.878  41.866  81.443  1.00 53.44           C  
ATOM    460  CD2 LEU    57      50.678  43.748  83.061  1.00 54.51           C  
ATOM    461  N   HIS    58      46.205  45.453  80.068  1.00 58.11           N  
ATOM    462  CA  HIS    58      45.678  46.352  79.023  1.00 57.60           C  
ATOM    463  C   HIS    58      45.853  47.808  79.420  1.00 56.70           C  
ATOM    464  O   HIS    58      46.028  48.694  78.582  1.00 55.98           O  
ATOM    465  CB  HIS    58      44.177  46.059  78.735  1.00 59.89           C  
ATOM    466  CG  HIS    58      43.226  46.445  79.840  1.00 64.46           C  
ATOM    467  ND1 HIS    58      43.357  46.003  81.143  1.00 66.22           N  
ATOM    468  CD2 HIS    58      42.085  47.181  79.815  1.00 66.37           C  
ATOM    469  CE1 HIS    58      42.343  46.447  81.868  1.00 65.24           C  
ATOM    470  NE2 HIS    58      41.556  47.163  81.086  1.00 66.11           N  
ATOM    471  N   ASP    59      45.824  48.028  80.724  1.00 55.66           N  
ATOM    472  CA  ASP    59      45.957  49.347  81.281  1.00 55.23           C  
ATOM    473  C   ASP    59      47.392  49.828  81.412  1.00 56.41           C  
ATOM    474  O   ASP    59      47.644  51.029  81.398  1.00 57.70           O  
ATOM    475  CB  ASP    59      45.263  49.386  82.638  1.00 54.64           C  
ATOM    476  CG  ASP    59      43.826  49.855  82.541  1.00 53.95           C  
ATOM    477  OD1 ASP    59      43.117  49.453  81.599  1.00 53.61           O  
ATOM    478  OD2 ASP    59      43.402  50.629  83.418  1.00 53.25           O  
ATOM    479  N   VAL    60      48.336  48.903  81.526  1.00 56.48           N  
ATOM    480  CA  VAL    60      49.734  49.276  81.686  1.00 55.99           C  
ATOM    481  C   VAL    60      50.368  49.796  80.405  1.00 57.45           C  
ATOM    482  O   VAL    60      51.435  50.415  80.427  1.00 57.80           O  
ATOM    483  CB  VAL    60      50.530  48.096  82.236  1.00 55.60           C  
ATOM    484  CG1 VAL    60      51.999  48.445  82.352  1.00 55.22           C  
ATOM    485  CG2 VAL    60      49.980  47.742  83.597  1.00 56.62           C  
ATOM    486  N   ALA    61      49.703  49.568  79.284  1.00 58.50           N  
ATOM    487  CA  ALA    61      50.227  50.055  78.023  1.00 60.65           C  
ATOM    488  C   ALA    61      49.501  51.351  77.644  1.00 63.43           C  
ATOM    489  O   ALA    61      50.048  52.195  76.934  1.00 63.87           O  
ATOM    490  CB  ALA    61      50.049  49.001  76.944  1.00 59.87           C  
ATOM    491  N   ASP    62      48.270  51.510  78.128  1.00 66.34           N  
ATOM    492  CA  ASP    62      47.468  52.711  77.854  1.00 66.96           C  
ATOM    493  C   ASP    62      48.321  53.975  77.892  1.00 65.64           C  
ATOM    494  O   ASP    62      48.732  54.471  76.852  1.00 64.05           O  
ATOM    495  CB  ASP    62      46.328  52.818  78.883  1.00 69.44           C  
ATOM    496  CG  ASP    62      45.606  54.165  78.846  1.00 72.14           C  
ATOM    497  OD1 ASP    62      44.950  54.481  77.817  1.00 70.22           O  
ATOM    498  OD2 ASP    62      45.688  54.904  79.865  1.00 73.11           O  
ATOM    499  N   LEU    65      48.350  56.770  79.950  1.00 63.26           N  
ATOM    500  CA  LEU    65      49.183  57.483  80.928  1.00 63.60           C  
ATOM    501  C   LEU    65      50.395  56.636  81.329  1.00 65.48           C  
ATOM    502  O   LEU    65      51.016  56.862  82.375  1.00 67.00           O  
ATOM    503  CB  LEU    65      48.374  57.837  82.200  1.00 61.25           C  
ATOM    504  CG  LEU    65      47.636  56.735  82.996  1.00 58.55           C  
ATOM    505  CD1 LEU    65      47.408  57.162  84.456  1.00 54.02           C  
ATOM    506  CD2 LEU    65      46.304  56.421  82.303  1.00 55.80           C  
ATOM    507  N   ASN    66      50.733  55.656  80.497  1.00 64.41           N  
ATOM    508  CA  ASN    66      51.866  54.777  80.800  1.00 65.42           C  
ATOM    509  C   ASN    66      53.182  55.458  80.452  1.00 65.25           C  
ATOM    510  O   ASN    66      54.152  55.400  81.217  1.00 66.11           O  
ATOM    511  CB  ASN    66      51.759  53.455  80.011  1.00 66.78           C  
ATOM    512  CG  ASN    66      52.116  53.618  78.521  1.00 67.01           C  
ATOM    513  OD1 ASN    66      51.412  54.308  77.774  1.00 67.34           O  
ATOM    514  ND2 ASN    66      53.216  52.990  78.096  1.00 64.00           N  
ATOM    515  N   GLU    67      53.196  56.073  79.272  1.00 64.42           N  
ATOM    516  CA  GLU    67      54.359  56.768  78.752  1.00 66.26           C  
ATOM    517  C   GLU    67      54.011  57.617  77.522  1.00 69.19           C  
ATOM    518  O   GLU    67      53.540  58.753  77.657  1.00 72.69           O  
ATOM    519  CB  GLU    67      55.446  55.770  78.375  1.00 67.01           C  
ATOM    520  CG  GLU    67      56.740  56.445  77.950  1.00 66.48           C  
ATOM    521  CD  GLU    67      57.832  56.281  78.992  1.00 65.04           C  
ATOM    522  OE1 GLU    67      57.622  56.701  80.158  1.00 65.65           O  
ATOM    523  OE2 GLU    67      58.910  55.746  78.640  1.00 64.94           O  
ATOM    524  N   SER    68      54.220  57.072  76.323  1.00 67.68           N  
ATOM    525  CA  SER    68      53.951  57.825  75.088  1.00 67.54           C  
ATOM    526  C   SER    68      53.652  56.898  73.899  1.00 71.84           C  
ATOM    527  O   SER    68      54.564  56.280  73.338  1.00 73.27           O  
ATOM    528  CB  SER    68      55.164  58.707  74.784  1.00 66.29           C  
ATOM    529  OG  SER    68      56.203  58.457  75.730  1.00 58.59           O  
ATOM    530  N   GLU    69      52.375  56.814  73.519  1.00 74.66           N  
ATOM    531  CA  GLU    69      51.937  55.948  72.421  1.00 77.50           C  
ATOM    532  C   GLU    69      52.318  54.458  72.665  1.00 80.84           C  
ATOM    533  O   GLU    69      52.253  53.969  73.795  1.00 79.23           O  
ATOM    534  CB  GLU    69      52.530  56.451  71.087  1.00 78.22           C  
ATOM    535  N   GLU    70      52.715  53.756  71.601  1.00 82.88           N  
ATOM    536  CA  GLU    70      53.096  52.344  71.665  1.00 83.86           C  
ATOM    537  C   GLU    70      54.446  52.143  72.368  1.00 84.49           C  
ATOM    538  O   GLU    70      55.265  51.314  71.962  1.00 82.91           O  
ATOM    539  CB  GLU    70      53.143  51.777  70.239  1.00 86.54           C  
ATOM    540  CG  GLU    70      53.149  50.249  70.127  1.00 91.10           C  
ATOM    541  CD  GLU    70      54.465  49.698  69.604  1.00 93.39           C  
ATOM    542  OE1 GLU    70      54.783  49.948  68.415  1.00 94.80           O  
ATOM    543  OE2 GLU    70      55.179  49.023  70.387  1.00 94.11           O  
ATOM    544  N   ALA    71      54.677  52.916  73.422  1.00 84.48           N  
ATOM    545  CA  ALA    71      55.915  52.811  74.174  1.00 85.35           C  
ATOM    546  C   ALA    71      55.727  51.797  75.298  1.00 87.00           C  
ATOM    547  O   ALA    71      56.696  51.242  75.827  1.00 86.42           O  
ATOM    548  CB  ALA    71      56.284  54.162  74.742  1.00 85.43           C  
ATOM    549  N   GLY    72      54.464  51.558  75.646  1.00 88.72           N  
ATOM    550  CA  GLY    72      54.136  50.614  76.701  1.00 90.58           C  
ATOM    551  C   GLY    72      54.090  49.183  76.206  1.00 91.40           C  
ATOM    552  O   GLY    72      54.205  48.240  76.985  1.00 91.79           O  
ATOM    553  N   MET    73      53.912  49.023  74.902  1.00 92.03           N  
ATOM    554  CA  MET    73      53.868  47.703  74.303  1.00 93.01           C  
ATOM    555  C   MET    73      55.137  46.949  74.672  1.00 91.55           C  
ATOM    556  O   MET    73      55.083  45.833  75.187  1.00 91.24           O  
ATOM    557  CB  MET    73      53.774  47.827  72.790  1.00 97.28           C  
ATOM    558  CG  MET    73      52.728  46.929  72.165  1.00102.19           C  
ATOM    559  SD  MET    73      50.960  47.206  72.919  1.00109.67          SE  
ATOM    560  CE  MET    73      50.901  49.159  72.946  1.00105.49           C  
ATOM    561  N   LYS    74      56.283  47.561  74.397  1.00 89.74           N  
ATOM    562  CA  LYS    74      57.549  46.929  74.721  1.00 88.01           C  
ATOM    563  C   LYS    74      57.703  46.900  76.228  1.00 87.41           C  
ATOM    564  O   LYS    74      58.559  46.197  76.755  1.00 88.23           O  
ATOM    565  CB  LYS    74      58.727  47.684  74.098  1.00 87.71           C  
ATOM    566  CG  LYS    74      60.100  47.062  74.395  1.00 86.29           C  
ATOM    567  CD  LYS    74      60.689  47.527  75.725  1.00 84.77           C  
ATOM    568  CE  LYS    74      62.018  46.846  76.007  1.00 85.01           C  
ATOM    569  NZ  LYS    74      62.982  46.979  74.879  1.00 83.18           N  
ATOM    570  N   LYS    75      56.881  47.671  76.928  1.00 85.82           N  
ATOM    571  CA  LYS    75      56.950  47.683  78.383  1.00 84.29           C  
ATOM    572  C   LYS    75      56.334  46.385  78.901  1.00 84.13           C  
ATOM    573  O   LYS    75      56.806  45.804  79.884  1.00 84.52           O  
ATOM    574  CB  LYS    75      56.204  48.901  78.934  1.00 83.86           C  
ATOM    575  CG  LYS    75      55.928  48.865  80.430  1.00 82.95           C  
ATOM    576  CD  LYS    75      55.774  50.284  81.001  1.00 84.90           C  
ATOM    577  CE  LYS    75      54.739  51.138  80.243  1.00 85.04           C  
ATOM    578  NZ  LYS    75      54.903  52.621  80.465  1.00 83.14           N  
ATOM    579  N   VAL    76      55.281  45.940  78.215  1.00 82.84           N  
ATOM    580  CA  VAL    76      54.563  44.703  78.540  1.00 80.09           C  
ATOM    581  C   VAL    76      55.294  43.546  77.868  1.00 80.15           C  
ATOM    582  O   VAL    76      55.431  42.451  78.423  1.00 78.85           O  
ATOM    583  CB  VAL    76      53.117  44.772  78.012  1.00 79.09           C  
ATOM    584  CG1 VAL    76      52.404  43.439  78.209  1.00 76.50           C  
ATOM    585  CG2 VAL    76      52.378  45.890  78.723  1.00 78.24           C  
ATOM    586  N   SER    77      55.766  43.823  76.661  1.00 80.38           N  
ATOM    587  CA  SER    77      56.513  42.862  75.873  1.00 81.49           C  
ATOM    588  C   SER    77      57.659  42.250  76.676  1.00 82.91           C  
ATOM    589  O   SER    77      57.655  41.050  76.962  1.00 83.81           O  
ATOM    590  CB  SER    77      57.058  43.547  74.619  1.00 80.41           C  
ATOM    591  OG  SER    77      58.246  42.925  74.183  1.00 79.27           O  
ATOM    592  N   ASP    78      58.634  43.079  77.043  1.00 84.30           N  
ATOM    593  CA  ASP    78      59.801  42.623  77.809  1.00 84.85           C  
ATOM    594  C   ASP    78      59.458  42.063  79.190  1.00 83.83           C  
ATOM    595  O   ASP    78      60.314  41.480  79.857  1.00 84.23           O  
ATOM    596  CB  ASP    78      60.859  43.756  77.933  1.00 85.87           C  
ATOM    597  CG  ASP    78      60.339  45.007  78.661  1.00 86.65           C  
ATOM    598  OD1 ASP    78      61.067  46.029  78.662  1.00 85.97           O  
ATOM    599  OD2 ASP    78      59.222  44.977  79.236  1.00 88.00           O  
ATOM    600  N   TRP    79      58.209  42.238  79.617  1.00 82.60           N  
ATOM    601  CA  TRP    79      57.786  41.726  80.919  1.00 81.42           C  
ATOM    602  C   TRP    79      57.365  40.270  80.794  1.00 81.65           C  
ATOM    603  O   TRP    79      57.804  39.413  81.565  1.00 81.76           O  
ATOM    604  CB  TRP    79      56.614  42.533  81.494  1.00 78.42           C  
ATOM    605  CG  TRP    79      55.969  41.841  82.677  1.00 75.56           C  
ATOM    606  CD1 TRP    79      54.757  41.201  82.696  1.00 74.82           C  
ATOM    607  CD2 TRP    79      56.530  41.668  83.987  1.00 74.54           C  
ATOM    608  NE1 TRP    79      54.531  40.640  83.935  1.00 73.22           N  
ATOM    609  CE2 TRP    79      55.604  40.908  84.744  1.00 73.62           C  
ATOM    610  CE3 TRP    79      57.729  42.075  84.595  1.00 73.64           C  
ATOM    611  CZ2 TRP    79      55.840  40.551  86.076  1.00 73.23           C  
ATOM    612  CZ3 TRP    79      57.961  41.716  85.926  1.00 72.07           C  
ATOM    613  CH2 TRP    79      57.021  40.961  86.645  1.00 72.33           C  
ATOM    614  N   LEU    80      56.502  39.997  79.822  1.00 81.35           N  
ATOM    615  CA  LEU    80      56.031  38.642  79.600  1.00 81.36           C  
ATOM    616  C   LEU    80      57.241  37.718  79.416  1.00 82.75           C  
ATOM    617  O   LEU    80      57.155  36.504  79.627  1.00 83.71           O  
ATOM    618  CB  LEU    80      55.126  38.608  78.372  1.00 78.55           C  
ATOM    619  CG  LEU    80      53.850  39.439  78.489  1.00 76.59           C  
ATOM    620  CD1 LEU    80      53.063  39.292  77.219  1.00 75.59           C  
ATOM    621  CD2 LEU    80      53.016  38.984  79.672  1.00 75.73           C  
ATOM    622  N   GLU    81      58.368  38.314  79.035  1.00 83.30           N  
ATOM    623  CA  GLU    81      59.611  37.592  78.827  1.00 83.18           C  
ATOM    624  C   GLU    81      60.227  37.194  80.150  1.00 83.96           C  
ATOM    625  O   GLU    81      60.591  36.040  80.354  1.00 83.28           O  
ATOM    626  CB  GLU    81      60.582  38.471  78.056  1.00 82.96           C  
ATOM    627  CG  GLU    81      60.260  38.530  76.601  1.00 83.91           C  
ATOM    628  CD  GLU    81      60.479  37.192  75.946  1.00 85.26           C  
ATOM    629  OE1 GLU    81      59.857  36.937  74.897  1.00 86.78           O  
ATOM    630  OE2 GLU    81      61.287  36.395  76.476  1.00 85.66           O  
ATOM    631  N   GLU    82      60.347  38.163  81.047  1.00 86.15           N  
ATOM    632  CA  GLU    82      60.911  37.912  82.360  1.00 89.31           C  
ATOM    633  C   GLU    82      60.109  36.816  83.058  1.00 91.08           C  
ATOM    634  O   GLU    82      60.662  36.018  83.811  1.00 90.62           O  
ATOM    635  CB  GLU    82      60.902  39.204  83.184  1.00 90.62           C  
ATOM    636  CG  GLU    82      61.229  39.021  84.663  1.00 92.96           C  
ATOM    637  CD  GLU    82      61.320  40.345  85.414  1.00 94.03           C  
ATOM    638  OE1 GLU    82      61.342  40.322  86.664  1.00 93.95           O  
ATOM    639  OE2 GLU    82      61.380  41.404  84.751  1.00 94.64           O  
ATOM    640  N   LEU    83      58.806  36.778  82.793  1.00 93.88           N  
ATOM    641  CA  LEU    83      57.914  35.771  83.373  1.00 96.03           C  
ATOM    642  C   LEU    83      57.913  34.522  82.495  1.00 97.28           C  
ATOM    643  O   LEU    83      57.220  33.550  82.785  1.00 97.42           O  
ATOM    644  CB  LEU    83      56.483  36.321  83.482  1.00 96.66           C  
ATOM    645  CG  LEU    83      55.888  36.711  84.846  1.00 97.05           C  
ATOM    646  CD1 LEU    83      55.599  35.465  85.651  1.00 97.35           C  
ATOM    647  CD2 LEU    83      56.836  37.626  85.602  1.00 98.25           C  
ATOM    648  N   HIS    84      58.693  34.565  81.420  1.00 99.41           N  
ATOM    649  CA  HIS    84      58.795  33.446  80.497  1.00101.32           C  
ATOM    650  C   HIS    84      57.437  32.991  80.006  1.00101.97           C  
ATOM    651  O   HIS    84      56.693  32.320  80.717  1.00102.24           O  
ATOM    652  CB  HIS    84      59.510  32.281  81.171  1.00103.74           C  
ATOM    653  CG  HIS    84      60.999  32.337  81.057  1.00106.67           C  
ATOM    654  ND1 HIS    84      61.839  32.019  82.103  1.00107.68           N  
ATOM    655  CD2 HIS    84      61.802  32.627  80.004  1.00107.80           C  
ATOM    656  CE1 HIS    84      63.094  32.107  81.701  1.00108.75           C  
ATOM    657  NE2 HIS    84      63.099  32.474  80.430  1.00109.14           N  
ATOM    658  N   VAL    85      57.117  33.366  78.778  1.00102.41           N  
ATOM    659  CA  VAL    85      55.851  32.991  78.173  1.00103.08           C  
ATOM    660  C   VAL    85      56.083  32.747  76.687  1.00103.80           C  
ATOM    661  O   VAL    85      56.294  33.689  75.927  1.00103.96           O  
ATOM    662  CB  VAL    85      54.799  34.106  78.368  1.00102.69           C  
ATOM    663  CG1 VAL    85      53.555  33.804  77.552  1.00102.21           C  
ATOM    664  CG2 VAL    85      54.442  34.222  79.837  1.00102.22           C  
ATOM    665  N   GLU    86      56.064  31.478  76.288  1.00104.39           N  
ATOM    666  CA  GLU    86      56.275  31.101  74.893  1.00105.44           C  
ATOM    667  C   GLU    86      55.646  32.116  73.959  1.00105.44           C  
ATOM    668  O   GLU    86      54.465  32.437  74.093  1.00106.40           O  
ATOM    669  CB  GLU    86      55.662  29.728  74.605  1.00106.95           C  
ATOM    670  CG  GLU    86      56.591  28.535  74.806  1.00107.43           C  
ATOM    671  CD  GLU    86      55.898  27.201  74.536  1.00107.73           C  
ATOM    672  OE1 GLU    86      55.252  27.052  73.474  1.00107.83           O  
ATOM    673  OE2 GLU    86      56.008  26.295  75.387  1.00108.14           O  
ATOM    674  N   GLU    87      56.432  32.616  73.011  1.00104.19           N  
ATOM    675  CA  GLU    87      55.925  33.590  72.056  1.00103.36           C  
ATOM    676  C   GLU    87      54.598  33.093  71.496  1.00102.82           C  
ATOM    677  O   GLU    87      53.759  33.882  71.068  1.00102.80           O  
ATOM    678  CB  GLU    87      56.909  33.780  70.904  1.00103.37           C  
ATOM    679  CG  GLU    87      56.454  34.829  69.898  1.00103.61           C  
ATOM    680  CD  GLU    87      57.228  34.789  68.595  1.00103.62           C  
ATOM    681  OE1 GLU    87      57.014  35.697  67.760  1.00103.68           O  
ATOM    682  OE2 GLU    87      58.038  33.853  68.403  1.00102.59           O  
ATOM    683  N   GLU    88      54.421  31.775  71.503  1.00101.96           N  
ATOM    684  CA  GLU    88      53.207  31.159  70.989  1.00101.12           C  
ATOM    685  C   GLU    88      51.974  31.695  71.713  1.00100.67           C  
ATOM    686  O   GLU    88      50.877  31.753  71.145  1.00101.54           O  
ATOM    687  CB  GLU    88      53.293  29.638  71.136  1.00100.80           C  
ATOM    688  CG  GLU    88      52.205  28.874  70.398  1.00 99.08           C  
ATOM    689  CD  GLU    88      52.751  27.672  69.648  1.00 98.05           C  
ATOM    690  OE1 GLU    88      53.387  26.802  70.285  1.00 97.31           O  
ATOM    691  OE2 GLU    88      52.535  27.597  68.421  1.00 96.89           O  
ATOM    692  N   GLU    89      52.159  32.094  72.967  1.00 98.71           N  
ATOM    693  CA  GLU    89      51.064  32.636  73.761  1.00 97.39           C  
ATOM    694  C   GLU    89      51.198  34.140  73.932  1.00 95.84           C  
ATOM    695  O   GLU    89      50.231  34.885  73.783  1.00 95.67           O  
ATOM    696  CB  GLU    89      51.022  31.957  75.130  1.00 97.85           C  
ATOM    697  CG  GLU    89      50.325  30.613  75.103  1.00 99.04           C  
ATOM    698  CD  GLU    89      50.149  29.999  76.478  1.00100.11           C  
ATOM    699  OE1 GLU    89      49.444  28.970  76.573  1.00101.59           O  
ATOM    700  OE2 GLU    89      50.717  30.529  77.461  1.00100.07           O  
ATOM    701  N   SER    90      52.414  34.570  74.244  1.00 93.98           N  
ATOM    702  CA  SER    90      52.719  35.974  74.447  1.00 91.31           C  
ATOM    703  C   SER    90      52.270  36.802  73.254  1.00 89.60           C  
ATOM    704  O   SER    90      51.670  37.861  73.401  1.00 88.42           O  
ATOM    705  CB  SER    90      54.220  36.138  74.659  1.00 90.94           C  
ATOM    706  OG  SER    90      54.531  37.471  74.991  1.00 92.54           O  
ATOM    707  N   LYS    91      52.567  36.305  72.066  1.00 88.76           N  
ATOM    708  CA  LYS    91      52.185  36.999  70.847  1.00 89.03           C  
ATOM    709  C   LYS    91      50.673  37.271  70.849  1.00 87.86           C  
ATOM    710  O   LYS    91      50.205  38.220  70.212  1.00 88.17           O  
ATOM    711  CB  LYS    91      52.576  36.150  69.624  1.00 89.63           C  
ATOM    712  CG  LYS    91      52.492  36.854  68.265  1.00 90.92           C  
ATOM    713  CD  LYS    91      53.587  37.910  68.079  1.00 90.23           C  
ATOM    714  CE  LYS    91      53.658  38.338  66.628  1.00 88.60           C  
ATOM    715  NZ  LYS    91      53.807  37.130  65.764  1.00 86.94           N  
ATOM    716  N   HIS    92      49.919  36.448  71.578  1.00 85.83           N  
ATOM    717  CA  HIS    92      48.453  36.571  71.658  1.00 83.02           C  
ATOM    718  C   HIS    92      48.032  37.435  72.824  1.00 81.96           C  
ATOM    719  O   HIS    92      47.025  38.143  72.755  1.00 81.68           O  
ATOM    720  CB  HIS    92      47.817  35.191  71.840  1.00 81.86           C  
ATOM    721  CG  HIS    92      46.321  35.184  71.732  1.00 80.25           C  
ATOM    722  ND1 HIS    92      45.557  34.099  72.113  1.00 79.61           N  
ATOM    723  CD2 HIS    92      45.458  36.100  71.239  1.00 79.93           C  
ATOM    724  CE1 HIS    92      44.286  34.351  71.857  1.00 78.84           C  
ATOM    725  NE2 HIS    92      44.196  35.555  71.325  1.00 80.02           N  
ATOM    726  N   VAL    93      48.798  37.349  73.905  1.00 81.14           N  
ATOM    727  CA  VAL    93      48.507  38.123  75.093  1.00 79.89           C  
ATOM    728  C   VAL    93      48.728  39.585  74.777  1.00 79.26           C  
ATOM    729  O   VAL    93      47.782  40.359  74.726  1.00 79.67           O  
ATOM    730  CB  VAL    93      49.407  37.712  76.278  1.00 79.74           C  
ATOM    731  CG1 VAL    93      49.230  38.699  77.421  1.00 79.38           C  
ATOM    732  CG2 VAL    93      49.063  36.298  76.742  1.00 77.99           C  
ATOM    733  N   LEU    94      49.971  39.969  74.528  1.00 78.44           N  
ATOM    734  CA  LEU    94      50.219  41.369  74.237  1.00 77.24           C  
ATOM    735  C   LEU    94      49.584  41.790  72.924  1.00 76.74           C  
ATOM    736  O   LEU    94      49.775  42.910  72.465  1.00 77.69           O  
ATOM    737  CB  LEU    94      51.716  41.678  74.217  1.00 75.64           C  
ATOM    738  CG  LEU    94      52.472  41.454  72.923  1.00 73.82           C  
ATOM    739  CD1 LEU    94      53.249  42.716  72.621  1.00 73.77           C  
ATOM    740  CD2 LEU    94      53.382  40.244  73.032  1.00 73.03           C  
ATOM    741  N   HIS    95      48.822  40.898  72.315  1.00 76.14           N  
ATOM    742  CA  HIS    95      48.185  41.242  71.060  1.00 75.94           C  
ATOM    743  C   HIS    95      46.935  42.046  71.368  1.00 76.07           C  
ATOM    744  O   HIS    95      46.907  43.256  71.146  1.00 76.24           O  
ATOM    745  CB  HIS    95      47.840  39.973  70.290  1.00 76.81           C  
ATOM    746  CG  HIS    95      47.133  40.217  68.994  1.00 77.40           C  
ATOM    747  ND1 HIS    95      47.681  40.955  67.967  1.00 77.15           N  
ATOM    748  CD2 HIS    95      45.931  39.783  68.545  1.00 78.36           C  
ATOM    749  CE1 HIS    95      46.849  40.963  66.940  1.00 76.73           C  
ATOM    750  NE2 HIS    95      45.780  40.259  67.266  1.00 77.49           N  
ATOM    751  N   ILE    96      45.913  41.385  71.906  1.00 76.13           N  
ATOM    752  CA  ILE    96      44.657  42.062  72.239  1.00 75.31           C  
ATOM    753  C   ILE    96      44.873  43.315  73.095  1.00 74.93           C  
ATOM    754  O   ILE    96      44.071  44.258  73.064  1.00 73.06           O  
ATOM    755  CB  ILE    96      43.658  41.069  72.918  1.00 75.29           C  
ATOM    756  CG1 ILE    96      44.343  40.261  74.013  1.00 74.28           C  
ATOM    757  CG2 ILE    96      43.108  40.102  71.872  1.00 75.72           C  
ATOM    758  CD1 ILE    96      43.480  39.134  74.559  1.00 72.10           C  
ATOM    759  N   ILE    97      45.986  43.319  73.827  1.00 75.18           N  
ATOM    760  CA  ILE    97      46.389  44.434  74.688  1.00 74.43           C  
ATOM    761  C   ILE    97      46.576  45.668  73.806  1.00 75.89           C  
ATOM    762  O   ILE    97      46.797  46.778  74.298  1.00 75.02           O  
ATOM    763  CB  ILE    97      47.732  44.127  75.385  1.00 72.70           C  
ATOM    764  CG1 ILE    97      47.703  44.579  76.831  1.00 70.67           C  
ATOM    765  CG2 ILE    97      48.869  44.845  74.674  1.00 73.04           C  
ATOM    766  CD1 ILE    97      48.921  44.134  77.596  1.00 68.87           C  
ATOM    767  N   ALA    98      46.514  45.457  72.496  1.00 77.45           N  
ATOM    768  CA  ALA    98      46.651  46.552  71.556  1.00 78.57           C  
ATOM    769  C   ALA    98      45.261  47.081  71.291  1.00 79.91           C  
ATOM    770  O   ALA    98      45.035  48.283  71.347  1.00 79.61           O  
ATOM    771  CB  ALA    98      47.285  46.072  70.272  1.00 77.97           C  
ATOM    772  N   ASN    99      44.325  46.173  71.027  1.00 82.07           N  
ATOM    773  CA  ASN    99      42.948  46.565  70.756  1.00 84.96           C  
ATOM    774  C   ASN    99      42.176  46.845  72.037  1.00 87.38           C  
ATOM    775  O   ASN    99      40.989  46.530  72.143  1.00 88.24           O  
ATOM    776  CB  ASN    99      42.228  45.489  69.935  1.00 84.22           C  
ATOM    777  CG  ASN    99      42.836  45.307  68.549  1.00 83.98           C  
ATOM    778  OD1 ASN    99      44.021  44.983  68.415  1.00 83.25           O  
ATOM    779  ND2 ASN    99      42.025  45.513  67.511  1.00 81.06           N  
ATOM    780  N   MET   100      42.862  47.446  73.004  1.00 90.07           N  
ATOM    781  CA  MET   100      42.257  47.791  74.289  1.00 92.39           C  
ATOM    782  C   MET   100      42.343  49.301  74.530  1.00 92.50           C  
ATOM    783  O   MET   100      42.370  49.760  75.676  1.00 92.32           O  
ATOM    784  CB  MET   100      42.967  47.035  75.423  1.00 94.34           C  
ATOM    785  CG  MET   100      42.676  45.532  75.458  1.00 96.06           C  
ATOM    786  SD  MET   100      40.983  45.046  76.295  1.00 99.14          SE  
ATOM    787  CE  MET   100      39.749  45.527  74.858  1.00 97.67           C  
END
